#!/bin/bash
gmt begin ushkan1.37_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases ushkan1.37'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    -2.024
     2.500    -2.235
     3.000    -2.446
     3.500    -2.657
     4.000    -2.868
     4.500    -3.079
     5.000    -3.291
     5.500    -3.502
     6.000    -3.713
     6.500    -3.924
     7.000    -4.135
     7.500    -4.346
     8.000    -4.557
     8.500    -4.768
     9.000    -4.979
     9.500    -5.190
    10.000    -5.401
    10.500    -5.612
    11.000    -5.823
    11.500    -6.034
    12.000    -6.245
    12.500    -6.456
    13.000    -6.667
    13.500    -6.878
    14.000    -7.089
    14.500    -7.300
    15.000    -7.511
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000    -3.667 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.500     0.550
     2.000    -3.168
     2.500    -6.887
     3.000   -10.605
     3.500   -14.323
     4.000   -18.044
     4.500   -21.765
     5.000   -25.489
     5.500   -29.214
     6.000   -32.942
     6.500   -36.672
     7.000   -40.404
     7.500   -44.139
     8.000   -47.878
     8.500   -51.619
     9.000   -55.364
     9.500   -59.112
    10.000   -62.865
    10.500   -66.622
    11.000   -70.383
    11.500   -74.148
    12.000   -77.919
    12.500   -81.694
    13.000   -85.476
    13.500   -89.263
    14.000   -93.054
    14.500   -96.854
    15.000  -100.658
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -82.476 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     1.014
     1.000     0.444
     1.500    -1.196
     2.000    -2.836
     2.500    -4.475
     3.000    -6.117
     3.500    -7.761
     4.000    -9.406
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -12.406 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.144    -0.332     0.200
     2.552    -2.983     0.200
     3.014    -1.434     0.200
     3.011    -3.633     0.200
     3.621    -4.148     0.200
     3.661    -2.937     0.200
     4.742    -3.708     0.200
     4.862    -4.089     0.200
     5.041    -4.279     0.200
     3.245    -3.158     0.200
     3.350    -2.482     0.200
     3.520    -1.861     0.200
    14.673    -3.428     0.200
     2.095    -1.339     0.200
     2.728    -0.816     0.200
     2.752    -3.061     0.200
     3.227    -1.634     0.200
     3.876    -2.495     0.200
     2.391    -3.120     0.200
     2.507    -2.776     0.200
     2.504    -2.107     0.200
     3.097    -2.092     0.200
     3.142    -4.527     0.200
     3.662    -4.989     0.200
     3.744    -5.489     0.200
     3.918    -2.510     0.200
     4.201    -3.183     0.200
     4.570    -4.879     0.200
     2.207    -1.285     0.200
     2.368    -1.782     0.200
     2.597    -3.642     0.200
     2.657    -3.742     0.200
     3.031    -3.025     0.200
     4.044    -4.507     0.200
     4.163    -3.403     0.200
     5.073    -2.746     0.200
     2.341    -2.384     0.200
     2.557    -3.334     0.200
     2.642    -2.618     0.200
     2.976    -1.619     0.200
     3.254    -3.617     0.200
     3.846    -4.203     0.200
     4.084    -1.645     0.200
     4.723    -4.900     0.200
     2.261    -2.333     0.200
     2.723    -2.961     0.200
     2.894    -3.486     0.200
     3.338    -3.980     0.200
     3.421    -4.299     0.200
     3.881    -4.078     0.200
     3.954    -1.895     0.200
     4.166    -4.031     0.200
     4.332    -4.078     0.200
     4.713    -5.049     0.200
     2.299    -2.609     0.200
     2.599    -2.618     0.200
     2.675    -2.733     0.200
     2.934    -3.049     0.200
     3.292    -3.997     0.200
     3.456    -2.084     0.200
     3.876    -3.499     0.200
     3.999    -1.813     0.200
     4.126    -3.737     0.200
     4.365    -2.322     0.200
     4.733    -5.970     0.200
     4.769    -4.216     0.200
     5.763    -4.028     0.200
     7.393    -6.393     0.200
     2.260    -0.860     0.200
     2.639    -2.056     0.200
     2.713    -2.622     0.200
     2.895    -1.769     0.200
     3.333    -3.051     0.200
     3.419    -2.281     0.200
     3.893    -4.825     0.200
     3.959    -1.895     0.200
     4.166    -2.960     0.200
     4.729    -3.818     0.200
     4.738    -2.602     0.200
     2.266    -0.870     0.200
     2.299     0.188     0.200
     2.476    -1.100     0.200
     2.487    -0.453     0.200
     2.658    -2.295     0.200
     2.658    -2.193     0.200
     2.808    -0.026     0.200
     3.670    -3.378     0.200
     3.670    -2.980     0.200
     4.117    -3.218     0.200
     4.264    -3.978     0.200
     4.450    -3.098     0.200
     4.848    -7.498     0.200
     6.309    -3.016     0.200
     7.463    -3.705     0.200
    14.160    -2.286     0.200
     2.354    -0.652     0.200
     2.696    -2.495     0.200
     2.979    -2.871     0.200
     3.286    -2.089     0.200
     3.519    -4.084     0.200
     3.767    -0.861     0.200
     4.019    -0.340     0.200
     4.084    -2.810     0.200
     4.624    -4.604     0.200
     4.855    -5.435     0.200
     5.759    -6.800     0.200
     6.172    -4.979     0.200
     7.039    -4.865     0.200
     2.282    -1.823     0.200
     2.570     0.038     0.200
     2.570    -1.667     0.200
     2.701    -3.098     0.200
     2.701    -2.802     0.200
     3.071    -2.841     0.200
     3.071    -2.544     0.200
     3.309    -1.375     0.200
     3.309    -4.281     0.200
     3.309    -0.880     0.200
     3.413    -4.789     0.200
     3.874    -2.300     0.200
     3.874    -1.800     0.200
     4.298    -2.838     0.200
     4.393    -3.153     0.200
     4.393    -3.653     0.200
     4.791    -5.162     0.200
     5.229    -2.255     0.200
     5.229    -1.958     0.200
     2.230    -1.696     0.200
     2.562    -2.525     0.200
     2.778    -2.356     0.200
     3.038    -2.507     0.200
     3.326    -3.722     0.200
     3.381    -2.672     0.200
     3.717    -2.527     0.200
     3.953    -2.820     0.200
     4.330    -3.257     0.200
     2.304    -0.716     0.200
     2.377    -2.820     0.200
     2.377    -2.320     0.200
     2.665    -2.965     0.200
     2.665    -1.762     0.200
     3.004    -2.303     0.200
     3.004    -0.905     0.200
     3.540    -3.599     0.200
     4.047    -2.780     0.200
     4.637    -5.377     0.200
     4.870    -2.143     0.200
     5.575    -2.691     0.200
     5.729    -4.594     0.200
     2.345    -1.562     0.200
     2.637    -2.333     0.200
     2.637    -2.134     0.200
     2.532    -1.295     0.200
     2.653    -1.836     0.200
     2.653    -0.836     0.200
     3.138    -1.512     0.200
     3.257    -2.357     0.200
     3.257    -1.959     0.200
     3.418    -2.476     0.200
     3.418    -1.676     0.200
     3.508     0.061     0.200
     3.508    -0.239     0.200
     3.837    -2.570     0.200
     3.829    -4.412     0.200
     3.829    -2.111     0.200
     4.191    -1.673     0.200
     4.219    -2.161     0.200
     4.237    -0.845     0.200
     4.360    -3.127     0.200
     4.747    -4.313     0.200
     5.197    -4.184     0.200
     5.197    -3.184     0.200
     5.367    -1.347     0.200
     5.610    -4.855     0.200
     5.610    -5.054     0.200
     6.789    -3.642     0.200
     6.992    -6.377     0.200
     8.198    -5.587     0.200
     2.296    -1.219     0.200
     2.713    -2.510     0.200
     2.768    -2.477     0.200
     3.063    -1.921     0.200
     3.168    -2.039     0.200
     3.458    -3.132     0.200
     3.731    -2.804     0.200
     4.018    -3.683     0.200
     4.073    -3.723     0.200
     4.995    -3.574     0.200
     5.270    -5.674     0.200
     2.573    -1.341     0.200
     2.737    -1.546     0.200
     2.737    -1.647     0.200
     2.726    -1.100     0.200
     2.726    -0.100     0.200
     3.193    -3.803     0.200
     3.193    -1.803     0.200
     3.262    -1.094     0.200
     3.262    -2.188     0.200
     3.310    -1.209     0.200
     3.557    -1.350     0.200
     3.827    -2.915     0.200
     3.908    -0.861     0.200
     3.908    -1.760     0.200
     4.181    -2.043     0.200
     4.181    -3.442     0.200
     4.248    -0.936     0.200
     5.310    -3.722     0.200
     5.362    -3.178     0.200
     6.773    -4.392     0.200
     6.909    -6.117     0.200
     2.089     0.392     0.200
     2.127    -1.222     0.200
     2.353    -1.559     0.200
     2.717    -1.312     0.200
     2.793    -2.932     0.200
     2.880    -1.274     0.200
     3.421    -4.026     0.200
     3.495    -1.781     0.200
     3.495    -1.481     0.200
     3.643    -2.873     0.200
     3.954    -4.419     0.200
     3.954    -4.719     0.200
     4.451    -1.167     0.200
     4.576    -4.928     0.200
     4.864    -4.870     0.200
     4.864    -5.370     0.200
     5.162    -3.028     0.200
     5.256    -3.994     0.200
     5.354    -4.301     0.200
     6.598    -5.729     0.200
     2.142    -0.240     0.200
     2.368    -1.319     0.200
     2.368    -1.018     0.200
     2.503    -2.076     0.200
     2.503    -1.275     0.200
     2.620    -2.102     0.200
     2.644    -1.861     0.200
     3.155    -2.042     0.200
     3.155    -1.941     0.200
     3.225    -2.287     0.200
     3.454    -2.716     0.200
     3.454    -3.017     0.200
     3.795    -3.054     0.200
     3.864    -2.734     0.200
     4.212    -1.143     0.200
     4.384    -4.221     0.200
     5.161    -3.250     0.200
     5.392    -3.279     0.200
     5.627    -5.312     0.200
     6.817    -5.722     0.200
     7.027    -5.586     0.200
     2.167    -1.044     0.200
     2.345    -0.486     0.200
     2.511    -1.150     0.200
     2.718    -1.799     0.200
     2.978    -2.257     0.200
     3.296    -1.825     0.200
     3.442    -2.065     0.200
     3.654    -1.868     0.200
     4.012    -1.916     0.200
     4.337    -2.913     0.200
     4.929    -3.891     0.200
     5.367    -4.979     0.200
     2.218    -0.573     0.200
     2.292    -0.916     0.200
     2.292    -1.916     0.200
     2.569    -2.801     0.200
     2.574    -1.434     0.200
     2.574    -1.832     0.200
     2.683    -1.816     0.200
     3.077    -2.175     0.200
     3.293    -2.106     0.200
     3.293    -3.445     0.200
     3.436    -2.561     0.200
     3.436    -2.662     0.200
     3.447    -0.636     0.200
     3.447    -3.136     0.200
     3.791    -4.417     0.200
     3.791    -3.218     0.200
     3.856    -4.592     0.200
     4.138    -2.222     0.200
     4.165    -2.086     0.200
     4.287    -3.031     0.200
     4.411    -2.894     0.200
     4.411    -4.194     0.200
     4.773    -3.543     0.200
     5.209    -4.467     0.200
     5.549    -6.448     0.200
     6.744    -4.325     0.200
     6.970    -5.796     0.200
     7.459    -6.595     0.200
     8.222    -4.125     0.200
     2.209    -1.797     0.200
     2.500    -1.447     0.200
     2.657    -2.398     0.200
     2.763    -0.772     0.200
     2.997    -1.983     0.200
     3.395    -3.802     0.200
     3.375    -1.071     0.200
     3.707    -3.795     0.200
     3.934    -2.098     0.200
     4.418    -2.318     0.200
     4.370    -1.320     0.200
     4.850    -4.222     0.200
     5.277    -4.676     0.200
     5.468    -3.833     0.200
     2.046    -0.147     0.200
     2.203    -1.306     0.200
     2.366    -1.685     0.200
     3.102    -2.995     0.200
     4.285    -3.903     0.200
     2.289    -1.955     0.200
     2.294    -0.817     0.200
     2.736    -2.419     0.200
     2.778    -3.341     0.200
     2.916    -1.321     0.200
     3.028    -3.086     0.200
     3.167    -3.284     0.200
     3.522    -1.841     0.200
     4.100    -3.169     0.200
     4.376    -3.311     0.200
     2.203    -2.261     0.200
     2.203    -3.061     0.200
     2.313    -0.954     0.200
     2.561    -3.416     0.200
     2.561    -2.216     0.200
     2.695    -1.453     0.200
     2.823    -0.512     0.200
     2.823    -2.413     0.200
     3.022    -3.920     0.200
     3.022    -3.521     0.200
     3.274    -4.233     0.200
     3.274    -4.533     0.200
     3.387    -2.319     0.200
     3.423    -2.731     0.200
     3.683    -3.997     0.200
     3.999    -3.513     0.200
     3.999    -4.113     0.200
     4.292    -3.606     0.200
     4.292    -4.606     0.200
     2.280    -2.038     0.200
     2.753    -3.737     0.200
     3.059    -4.455     0.200
     3.151    -3.261     0.200
     3.715    -3.644     0.200
     4.025    -3.760     0.200
     2.058    -1.571     0.200
     2.212    -1.169     0.200
     2.315    -2.715     0.200
     2.430    -0.882     0.200
     2.608    -2.522     0.200
     2.828    -3.297     0.200
     3.124    -3.360     0.200
     3.290    -2.343     0.200
     4.158    -3.162     0.200
     6.217    -6.410     0.200
     2.241    -0.778     0.200
     2.269    -1.969     0.200
     2.573    -2.397     0.200
     2.606    -2.148     0.200
     2.606    -2.249     0.200
     2.723    -2.655     0.200
     2.723    -1.655     0.200
     3.065    -3.504     0.200
     3.065    -2.305     0.200
     3.329    -1.564     0.200
     3.329    -3.166     0.200
     3.384    -4.193     0.200
     3.384    -4.091     0.200
     3.435    -4.014     0.200
     3.435    -2.014     0.200
     3.762    -2.889     0.200
     3.898    -4.083     0.200
     3.898    -4.282     0.200
     4.115    -2.885     0.200
     4.115    -1.085     0.200
     4.313    -1.944     0.200
     4.368    -4.212     0.200
     4.368    -2.712     0.200
     4.815    -5.161     0.200
     4.815    -4.860     0.200
     5.256    -3.958     0.200
     5.291    -6.557     0.200
     5.291    -1.659     0.200
     5.536    -5.228     0.200
     6.714    -4.565     0.200
     6.926    -7.288     0.200
     2.370     0.021     0.200
     2.370     0.121     0.200
     2.529    -3.136     0.200
     2.622    -3.381     0.200
     3.004    -4.395     0.200
     3.229    -4.126     0.200
     3.527    -4.063     0.200
     3.609    -2.848     0.200
     3.822    -4.027     0.200
     4.056    -3.226     0.200
     4.437    -5.096     0.200
     4.712    -4.412     0.200
     2.095    -1.780     0.200
     2.099    -0.395     0.200
     2.354    -3.384     0.200
     2.754    -2.078     0.200
     2.839    -2.959     0.200
     2.863    -1.215     0.200
     3.462    -3.630     0.200
     3.605    -3.862     0.200
     4.002    -4.433     0.200
     4.482    -1.040     0.200
     5.127    -1.505     0.200
     5.312    -3.555     0.200
     5.336    -4.615     0.200
     6.844    -5.336     0.200
     2.175    -1.907     0.200
     2.307    -1.089     0.200
     2.327    -2.122     0.200
     2.327    -1.622     0.200
     2.510    -0.831     0.200
     2.574    -2.156     0.200
     2.574    -2.258     0.200
     2.715    -3.118     0.200
     2.912    -1.265     0.200
     3.399    -2.312     0.200
     3.399    -1.617     0.200
     3.454    -1.652     0.200
     3.546    -2.366     0.200
     4.136    -5.185     0.200
     4.136    -3.490     0.200
     4.576    -4.337     0.200
     4.724    -2.813     0.200
     4.987    -4.364     0.200
     5.058    -2.297     0.200
     5.969    -5.176     0.200
     6.096    -5.909     0.200
     6.082    -5.350     0.200
     2.034    -2.471     0.200
     2.034    -0.771     0.200
     2.195    -0.781     0.200
     2.245    -0.444     0.200
     2.245    -0.241     0.200
     2.308    -2.853     0.200
     2.308    -2.353     0.200
     2.417    -0.514     0.200
     2.612    -2.984     0.200
     2.612    -2.382     0.200
     2.855    -4.601     0.200
     2.855    -3.101     0.200
     2.959    -1.981     0.200
     3.139    -2.108     0.200
     3.139    -1.811     0.200
     3.269    -1.621     0.200
     3.405    -1.936     0.200
     3.405    -3.936     0.200
     3.538    -2.056     0.200
     3.538    -1.657     0.200
     4.002    -3.660     0.200
     4.002    -3.360     0.200
     4.677    -4.263     0.200
     4.677    -3.563     0.200
     4.942    -2.651     0.200
     5.045    -5.827     0.200
     5.930    -5.283     0.200
     6.079    -4.611     0.200
     6.242    -6.158     0.200
     2.246    -1.781     0.200
     2.246    -1.582     0.200
     2.443    -2.205     0.200
     2.443    -2.306     0.200
     2.643    -1.551     0.200
     2.643    -3.453     0.200
     2.677    -1.249     0.200
     2.773    -2.074     0.200
     2.869    -2.821     0.200
     3.292    -1.248     0.200
     3.569    -3.621     0.200
     3.711    -3.627     0.200
     3.711    -3.225     0.200
     4.305    -4.954     0.200
     4.840    -6.294     0.200
     4.888    -5.933     0.200
     2.314    -1.946     0.200
     2.449    -1.439     0.200
     2.449    -1.238     0.200
     2.569    -1.326     0.200
     2.832    -1.963     0.200
     3.043    -1.664     0.200
     3.043    -1.365     0.200
     3.355    -2.153     0.200
     3.526    -1.680     0.200
     3.629    -4.443     0.200
     3.629    -3.542     0.200
     3.629    -0.542     0.200
     4.014    -1.330     0.200
     4.060    -3.103     0.200
     4.340    -3.665     0.200
     5.027    -3.438     0.200
     5.590    -5.500     0.200
     2.348    -2.563     0.200
     3.554    -4.794     0.200
     4.024    -4.789     0.200
     4.101    -2.853     0.200
     2.073    -1.200     0.200
     2.073    -2.301     0.200
     2.121     0.077     0.200
     2.332    -1.325     0.200
     2.840    -2.012     0.200
     2.775    -2.063     0.200
     2.858    -2.288     0.200
     3.212    -1.615     0.200
     3.212    -0.717     0.200
     3.431    -2.537     0.200
     3.431    -2.435     0.200
     3.483    -3.091     0.200
     3.483    -3.294     0.200
     3.917    -1.245     0.200
     4.536    -3.691     0.200
     4.536    -3.589     0.200
     4.504    -1.156     0.200
     4.931    -4.217     0.200
     4.931    -4.811     0.200
     5.106    -4.039     0.200
     5.313    -4.411     0.200
     5.313    -5.115     0.200
     5.327    -4.041     0.200
     5.855    -2.113     0.200
     6.539    -4.362     0.200
     6.828    -5.240     0.200
     7.400    -3.659     0.200
     7.565    -5.584     0.200
    14.012    -7.582     0.200
     2.127     0.085     0.200
     2.392    -3.012     0.200
     2.392    -2.412     0.200
     2.506    -0.345     0.200
     2.831    -1.745     0.200
     2.879    -1.567     0.200
     2.879    -1.667     0.200
     2.993    -2.095     0.200
     3.196    -1.500     0.200
     3.196    -0.400     0.200
     3.213    -2.263     0.200
     3.213    -3.163     0.200
     3.492    -2.500     0.200
     3.602    -1.182     0.200
     3.602    -2.982     0.200
     3.853    -0.554     0.200
     3.853    -1.954     0.200
     4.166    -3.053     0.200
     4.345    -4.543     0.200
     4.345    -3.643     0.200
     4.581    -2.421     0.200
     4.581    -2.521     0.200
     5.082    -3.685     0.200
     5.506    -2.629     0.200
     5.506    -2.729     0.200
     5.679    -1.157     0.200
     5.805     0.872     0.200
     6.443    -2.646     0.200
     6.663    -4.929     0.200
     7.293    -2.201     0.200
     8.038    -5.608     0.200
     2.013    -1.537     0.200
     2.013    -1.940     0.200
     2.389    -3.149     0.200
     2.389    -2.852     0.200
     2.500    -0.779     0.200
     2.833    -2.220     0.200
     2.833    -1.720     0.200
     2.871    -2.428     0.200
     2.984    -2.603     0.200
     2.984    -2.802     0.200
     3.198    -0.792     0.200
     3.227    -3.215     0.200
     3.227    -4.418     0.200
     3.499    -3.440     0.200
     3.499    -3.542     0.200
     3.593    -3.119     0.200
     4.155    -4.946     0.200
     4.155    -4.348     0.200
     4.356    -4.312     0.200
     4.575    -1.735     0.200
     5.029    -1.953     0.200
     5.029    -3.754     0.200
     5.071    -4.874     0.200
     5.298    -5.584     0.200
     5.494    -3.169     0.200
     5.494    -2.770     0.200
     6.675    -5.607     0.200
     2.009    -0.500     0.200
     2.011    -3.461     0.200
     2.011     0.238     0.200
     2.094    -1.168     0.200
     2.322    -2.192     0.200
     2.322    -3.095     0.200
     2.331    -2.277     0.200
     2.331    -1.277     0.200
     2.517    -1.788     0.200
     2.566    -0.430     0.200
     2.628     0.787     0.200
     2.660    -1.119     0.200
     2.660    -1.619     0.200
     2.739    -0.922     0.200
     2.779    -3.903     0.200
     2.779    -2.200     0.200
     2.817    -2.499     0.200
     3.218    -2.093     0.200
     3.218    -4.195     0.200
     3.700    -4.585     0.200
     4.286    -4.159     0.200
     4.286    -4.757     0.200
     4.738    -4.797     0.200
     4.871    -6.596     0.200
     2.072    -1.303     0.200
     2.072    -1.506     0.200
     2.132    -0.116     0.200
     2.316    -1.650     0.200
     2.316    -1.455     0.200
     2.447    -0.902     0.200
     2.832    -1.982     0.200
     2.832    -2.982     0.200
     2.774    -1.742     0.200
     2.774    -2.446     0.200
     2.851    -2.314     0.200
     2.851    -4.111     0.200
     3.205    -1.407     0.200
     3.205    -2.610     0.200
     3.455    -3.242     0.200
     3.455    -3.641     0.200
     3.479    -3.089     0.200
     3.479    -3.792     0.200
     3.586    -3.507     0.200
     3.586    -3.710     0.200
     4.012    -3.705     0.200
     4.012    -5.002     0.200
     4.505    -0.634     0.200
     4.564    -3.780     0.200
     4.922    -6.148     0.200
     4.922    -3.648     0.200
     4.922    -5.953     0.200
     5.106    -2.985     0.200
     5.305    -4.295     0.200
     5.305    -5.998     0.200
     5.312    -3.418     0.200
     5.763    -4.360     0.200
     5.871     0.039     0.200
     6.541    -5.366     0.200
     6.841    -5.770     0.200
     7.403    -5.608     0.200
    13.990    -7.858     0.200
    18.004    -4.031     0.200
     2.178    -1.562     0.200
     2.178    -2.363     0.200
     2.474    -2.255     0.200
     2.474    -2.454     0.200
     2.687    -2.683     0.200
     2.687    -1.086     0.200
     2.792    -2.909     0.200
     2.967    -3.079     0.200
     2.967    -4.680     0.200
     3.337    -2.107     0.200
     3.382    -3.640     0.200
     3.382    -3.538     0.200
     3.404    -2.340     0.200
     3.677    -3.470     0.200
     3.677    -2.470     0.200
     3.962    -6.213     0.200
     3.962    -2.713     0.200
     3.962    -1.612     0.200
     3.962    -5.014     0.200
     4.422    -4.104     0.200
     4.422    -3.905     0.200
     4.401    -1.824     0.200
     4.877    -4.526     0.200
     4.877    -4.327     0.200
     5.204    -1.872     0.200
     5.439    -5.222     0.200
     5.713    -1.743     0.200
     6.630    -3.583     0.200
     6.869    -6.154     0.200
     7.548    -6.581     0.200
     9.674    -5.280     0.200
    10.022    -5.923     0.200
    14.032    -7.818     0.200
     2.239    -1.550     0.200
     2.239    -0.952     0.200
     2.273    -0.830     0.200
     2.570    -2.743     0.200
     2.647    -2.683     0.200
     2.770    -1.788     0.200
     2.770    -1.686     0.200
     3.047    -2.456     0.200
     3.047    -3.756     0.200
     3.329    -2.800     0.200
     3.373    -3.689     0.200
     3.414    -0.411     0.200
     3.414    -0.712     0.200
     3.726    -3.079     0.200
     3.726    -4.177     0.200
     3.946    -4.957     0.200
     4.085    -0.660     0.200
     4.328    -4.677     0.200
     4.347    -1.386     0.200
     4.864    -4.157     0.200
     5.256    -4.398     0.200
     5.310    -4.185     0.200
     6.677    -5.221     0.200
     6.876    -5.641     0.200
     7.561    -5.070     0.200
     2.185    -1.945     0.200
     2.327    -0.869     0.200
     2.522    -2.533     0.200
     2.522    -2.431     0.200
     2.699    -2.044     0.200
     2.818    -3.121     0.200
     2.993    -2.676     0.200
     3.310    -3.730     0.200
     3.310    -2.831     0.200
     3.423    -3.304     0.200
     3.993    -4.953     0.200
     3.993    -4.652     0.200
     4.030    -2.552     0.200
     4.401    -3.009     0.200
     4.910    -4.529     0.200
     5.203    -4.112     0.200
     5.462    -3.231     0.200
     5.549    -2.609     0.200
     6.623    -4.554     0.200
     6.831    -6.847     0.200
     2.300    -2.595     0.200
     2.444    -2.434     0.200
     2.444    -2.137     0.200
     2.592    -2.626     0.200
     2.867    -3.747     0.200
     3.033    -3.009     0.200
     3.384    -1.355     0.200
     3.510    -3.324     0.200
     3.625    -4.283     0.200
     3.625    -2.983     0.200
     3.994    -1.076     0.200
     4.079    -3.376     0.200
     4.306    -5.066     0.200
     4.438    -2.640     0.200
     4.546    -4.483     0.200
     5.032    -3.672     0.200
     5.610    -2.110     0.200
     5.856    -3.920     0.200
     7.192    -6.851     0.200
     7.192    -4.948     0.200
     2.236    -1.311     0.200
     2.236    -1.111     0.200
     2.565    -2.440     0.200
     2.565    -2.639     0.200
     2.649    -2.281     0.200
     2.649    -3.183     0.200
     2.771    -2.752     0.200
     2.771    -1.651     0.200
     3.043    -1.282     0.200
     3.043    -3.282     0.200
     3.332    -2.454     0.200
     3.332    -4.056     0.200
     3.374    -2.676     0.200
     3.374    -3.375     0.200
     3.411    -2.640     0.200
     3.946    -3.514     0.200
     3.946    -3.315     0.200
     4.333    -4.991     0.200
     4.350    -2.009     0.200
     4.350    -1.907     0.200
     5.512    -5.552     0.200
     6.675    -3.606     0.200
     6.876    -5.594     0.200
     7.525    -6.048     0.200
     7.560    -6.177     0.200
     2.289    -1.845     0.200
     2.690    -2.058     0.200
     2.733    -1.916     0.200
     2.856    -2.327     0.200
     3.119    -3.064     0.200
     3.148    -2.885     0.200
     3.432    -1.684     0.200
     3.735    -2.396     0.200
     4.079    -3.989     0.200
     4.039    -2.337     0.200
     4.347    -1.992     0.200
     4.961    -3.568     0.200
     5.273    -1.940     0.200
     5.340    -3.253     0.200
     5.451    -3.201     0.200
     5.604    -3.944     0.200
     6.675    -4.296     0.200
     6.778    -7.460     0.200
     9.846    -7.693     0.200
     2.299    -2.311     0.200
     2.441    -1.816     0.200
     2.441    -1.511     0.200
     2.591    -1.873     0.200
     2.864    -3.108     0.200
     3.031    -3.409     0.200
     3.383    -2.756     0.200
     3.515    -3.842     0.200
     3.622    -4.757     0.200
     3.994    -2.427     0.200
     4.079    -3.247     0.200
     4.312    -5.012     0.200
     4.437    -1.386     0.200
     4.543    -3.649     0.200
     5.028    -3.402     0.200
     5.610    -3.776     0.200
     5.855    -4.830     0.200
     7.030    -5.571     0.200
     7.030    -5.774     0.200
     7.289    -4.901     0.200
     2.300    -2.404     0.200
     2.300    -2.204     0.200
     2.457    -3.583     0.200
     2.541    -3.561     0.200
     2.608    -3.656     0.200
     2.608    -2.556     0.200
     2.608    -0.356     0.200
     3.025    -4.489     0.200
     3.025    -2.489     0.200
     3.239    -4.276     0.200
     3.239    -3.696     0.200
     3.402    -2.637     0.200
     3.402    -3.837     0.200
     3.645    -0.844     0.200
     3.822    -4.757     0.200
     3.766    -4.472     0.200
     3.766    -4.972     0.200
     4.284    -1.807     0.200
     4.675    -6.301     0.200
     4.675    -5.301     0.200
     5.068    -2.261     0.200
     5.068    -5.561     0.200
     5.337    -1.786     0.200
     5.499    -5.519     0.200
     5.499    -4.519     0.200
     5.658    -2.747     0.200
     5.750    -2.588     0.200
     6.776    -3.505     0.200
     7.087    -5.754     0.200
    17.758    -4.366     0.200
    18.235    -3.180     0.200
    18.321    -5.901     0.200
     2.239    -1.183     0.200
     2.564    -1.279     0.200
     2.564    -1.678     0.200
     2.644    -1.841     0.200
     2.765    -2.573     0.200
     2.765    -1.979     0.200
     3.043    -3.596     0.200
     3.043    -2.198     0.200
     3.340    -2.297     0.200
     3.340    -2.399     0.200
     3.412    -2.162     0.200
     3.369    -3.122     0.200
     3.369    -2.122     0.200
     3.727    -3.662     0.200
     3.727    -2.467     0.200
     3.940    -4.826     0.200
     3.940    -3.326     0.200
     4.340    -4.708     0.200
     4.340    -4.810     0.200
     4.347    -1.700     0.200
     4.347    -1.802     0.200
     4.858    -6.416     0.200
     4.858    -3.916     0.200
     5.257    -4.770     0.200
     5.257    -3.474     0.200
     5.302    -5.683     0.200
     5.302    -5.784     0.200
     6.678    -4.319     0.200
     6.882    -5.485     0.200
     8.128    -6.270     0.200
    10.057    -8.217     0.200
    14.046   -10.183     0.200
    18.586    -8.706     0.200
    22.668    -2.497     0.200
    23.015   -31.517     0.200
     2.246    -1.392     0.200
     2.246    -1.689     0.200
     2.575    -1.517     0.200
     2.575    -1.916     0.200
     2.640    -2.352     0.200
     2.763    -3.258     0.200
     2.763    -2.351     0.200
     3.054    -2.476     0.200
     3.334    -2.759     0.200
     3.365    -3.155     0.200
     3.365    -3.054     0.200
     3.421    -2.330     0.200
     3.733    -3.425     0.200
     3.939    -4.929     0.200
     4.329    -3.802     0.200
     4.329    -3.997     0.200
     4.340    -2.756     0.200
     4.856    -4.528     0.200
     4.856    -4.130     0.200
     5.303    -4.278     0.200
     5.523    -5.246     0.200
     5.497    -2.947     0.200
     6.883    -5.880     0.200
     2.245    -1.678     0.200
     2.566    -1.178     0.200
     2.566    -2.381     0.200
     2.637    -2.129     0.200
     2.758    -2.645     0.200
     2.758    -2.544     0.200
     3.048    -4.655     0.200
     3.048    -2.452     0.200
     3.347    -2.704     0.200
     3.362    -2.294     0.200
     3.362    -3.497     0.200
     3.417    -2.625     0.200
     3.734    -2.675     0.200
     3.933    -3.999     0.200
     3.933    -5.202     0.200
     4.344    -4.014     0.200
     4.340    -2.106     0.200
     4.851    -5.487     0.200
     5.294    -4.549     0.200
     5.518    -5.137     0.200
     5.507    -1.293     0.200
     6.685    -5.436     0.200
     6.890    -6.220     0.200
     2.247    -1.168     0.200
     2.247    -1.363     0.200
     2.572    -0.872     0.200
     2.572    -2.067     0.200
     2.637    -2.325     0.200
     2.759    -2.393     0.200
     2.759    -1.987     0.200
     3.052    -3.491     0.200
     3.052    -2.195     0.200
     3.341    -3.146     0.200
     3.341    -2.349     0.200
     3.362    -3.712     0.200
     3.362    -2.712     0.200
     3.420    -0.260     0.200
     3.420    -1.455     0.200
     3.735    -2.429     0.200
     3.934    -3.554     0.200
     3.934    -5.250     0.200
     4.336    -4.694     0.200
     4.336    -4.397     0.200
     4.339    -2.469     0.200
     4.339    -1.867     0.200
     5.522    -5.474     0.200
     5.522    -5.068     0.200
     5.501    -2.621     0.200
     6.686    -5.285     0.200
     6.888    -5.876     0.200
     8.128    -5.993     0.200
     9.915    -6.756     0.200
     2.232    -1.540     0.200
     2.232    -1.137     0.200
     2.564    -1.744     0.200
     2.654    -2.195     0.200
     2.776    -3.075     0.200
     2.776    -2.279     0.200
     3.040    -2.342     0.200
     3.327    -2.857     0.200
     3.327    -0.958     0.200
     3.407    -2.297     0.200
     3.407    -0.797     0.200
     3.379    -2.595     0.200
     3.379    -2.192     0.200
     3.379    -1.595     0.200
     3.719    -3.874     0.200
     3.719    -2.972     0.200
     3.951    -4.441     0.200
     4.078    -0.748     0.200
     4.354    -2.210     0.200
     4.354    -2.409     0.200
     4.869    -4.934     0.200
     4.869    -4.137     0.200
     5.314    -5.633     0.200
     5.509    -4.908     0.200
     5.509    -2.010     0.200
     5.624    -0.176     0.200
     6.670    -4.018     0.200
     6.871    -5.584     0.200
     8.115    -6.331     0.200
     9.898    -8.959     0.200
     2.226    -1.393     0.200
     2.560    -2.064     0.200
     2.660    -2.433     0.200
     2.782    -3.515     0.200
     3.035    -4.520     0.200
     3.035    -1.820     0.200
     3.323    -1.852     0.200
     3.385    -3.032     0.200
     3.385    -2.232     0.200
     3.713    -3.019     0.200
     3.958    -3.179     0.200
     4.072    -1.502     0.200
     4.360    -1.040     0.200
     4.876    -6.573     0.200
     4.876    -4.273     0.200
     5.244    -3.540     0.200
     5.320    -3.862     0.200
     5.504    -4.580     0.200
     6.664    -5.463     0.200
     6.664    -4.263     0.200
     2.251    -1.982     0.200
     2.251    -1.382     0.200
     2.576    -2.601     0.200
     2.634    -2.320     0.200
     2.756    -4.104     0.200
     2.756    -2.104     0.200
     3.056    -2.120     0.200
     3.359    -3.217     0.200
     3.359    -2.117     0.200
     3.424    -0.585     0.200
     3.738    -3.141     0.200
     3.932    -4.771     0.200
     3.932    -3.571     0.200
     4.097    -1.292     0.200
     4.335    -2.049     0.200
     4.850    -6.169     0.200
     4.850    -4.469     0.200
     5.269    -4.954     0.200
     5.269    -3.454     0.200
     5.296    -3.803     0.200
     6.690    -4.490     0.200
     2.244    -1.803     0.200
     2.244    -1.303     0.200
     2.573    -2.349     0.200
     2.642    -2.439     0.200
     2.765    -3.641     0.200
     2.765    -2.539     0.200
     3.051    -3.390     0.200
     3.051    -2.492     0.200
     3.333    -2.822     0.200
     3.333    -3.720     0.200
     3.419    -2.149     0.200
     3.368    -3.444     0.200
     3.368    -2.444     0.200
     3.731    -4.039     0.200
     3.731    -3.636     0.200
     3.941    -4.712     0.200
     3.941    -3.111     0.200
     4.089    -2.011     0.200
     4.329    -4.615     0.200
     4.859    -3.408     0.200
     5.261    -4.656     0.200
     5.261    -3.758     0.200
     5.305    -2.046     0.200
     5.520    -4.159     0.200
     5.500    -2.019     0.200
     6.681    -4.482     0.200
     6.681    -4.181     0.200
     6.881    -6.302     0.200
     2.260    -2.055     0.200
     2.585    -2.038     0.200
     2.625    -2.110     0.200
     2.748    -2.713     0.200
     3.066    -1.586     0.200
     3.344    -2.924     0.200
     3.350    -0.516     0.200
     3.434    -1.855     0.200
     3.748    -3.312     0.200
     3.924    -2.890     0.200
     4.332    -4.126     0.200
     4.326    -1.529     0.200
     4.842    -5.089     0.200
     5.289    -2.463     0.200
     5.489    -1.606     0.200
     6.699    -3.059     0.200
     6.898    -4.070     0.200
     2.245    -1.368     0.200
     2.571    -2.077     0.200
     2.638    -2.325     0.200
     4.337    -5.161     0.200
     2.211    -1.905     0.200
     2.538    -2.247     0.200
     3.334    -2.587     0.200
     4.350    -5.504     0.200
     2.228    -1.959     0.200
     2.228    -1.659     0.200
     2.555    -1.802     0.200
     2.654    -2.251     0.200
     2.774    -2.864     0.200
     2.774    -2.564     0.200
     3.034    -4.582     0.200
     3.034    -2.882     0.200
     3.336    -3.972     0.200
     3.336    -2.672     0.200
     3.379    -3.920     0.200
     3.379    -2.720     0.200
     3.949    -5.211     0.200
     3.949    -4.211     0.200
     4.342    -3.866     0.200
     4.357    -2.121     0.200
     4.867    -4.597     0.200
     6.874    -6.009     0.200
     7.560    -4.981     0.200
     2.046    -0.134     0.200
     2.307    -1.202     0.200
     2.307    -1.702     0.200
     2.511    -0.859     0.200
     2.562    -2.284     0.200
     2.901    -1.037     0.200
     3.391    -2.260     0.200
     3.534    -0.900     0.200
     4.127    -3.296     0.200
     4.577    -5.146     0.200
     4.577    -2.943     0.200
     5.054    -3.065     0.200
     5.630    -5.150     0.200
     5.870    -3.351     0.200
     6.065    -3.731     0.200
     6.110    -5.343     0.200
     2.147    -2.851     0.200
     2.147    -1.949     0.200
     2.616    -3.287     0.200
     2.616    -3.486     0.200
     2.823    -2.650     0.200
     3.062    -2.242     0.200
     3.062    -3.242     0.200
     3.013    -2.976     0.200
     2.978    -3.081     0.200
     2.978    -2.280     0.200
     3.370    -1.704     0.200
     3.370    -1.306     0.200
     3.594    -3.600     0.200
     3.594    -2.799     0.200
     3.561    -4.176     0.200
     4.110    -5.365     0.200
     4.160    -4.736     0.200
     4.160    -4.536     0.200
     4.487    -2.511     0.200
     5.131    -3.731     0.200
     5.081    -5.034     0.200
     5.466    -5.044     0.200
     5.598    -1.163     0.200
     5.553    -5.212     0.200
     6.535    -4.328     0.200
     6.657    -5.809     0.200
    14.321    -8.882     0.200
     2.246    -1.493     0.200
     2.569    -2.632     0.200
     2.569    -2.433     0.200
     2.637    -2.085     0.200
     2.758    -2.220     0.200
     2.758    -1.923     0.200
     3.050    -2.588     0.200
     3.362    -2.660     0.200
     3.418    -0.658     0.200
     3.418    -1.759     0.200
     3.735    -2.482     0.200
     3.933    -5.879     0.200
     3.933    -2.379     0.200
     4.092    -1.305     0.200
     4.341    -3.707     0.200
     4.339    -2.049     0.200
     4.851    -4.169     0.200
     5.265    -2.488     0.200
     5.295    -4.851     0.200
     5.520    -5.474     0.200
     5.505    -2.695     0.200
     6.686    -5.639     0.200
     2.074    -0.359     0.200
     2.136    -2.205     0.200
     2.136    -1.405     0.200
     2.710    -2.520     0.200
     2.710    -1.720     0.200
     2.790    -3.051     0.200
     2.893    -2.702     0.200
     3.416    -3.890     0.200
     3.483    -3.406     0.200
     3.650    -3.097     0.200
     3.650    -2.297     0.200
     4.442    -1.607     0.200
     4.557    -4.858     0.200
     4.863    -4.156     0.200
     4.863    -5.256     0.200
     5.170    -2.085     0.200
     5.259    -5.012     0.200
     5.367    -5.624     0.200
     5.714    -2.244     0.200
     6.604    -3.653     0.200
     2.117    -2.291     0.200
     2.154    -2.266     0.200
     2.760    -3.986     0.200
     2.760    -3.786     0.200
     2.796    -4.102     0.200
     2.796    -3.903     0.200
     3.405    -4.024     0.200
     3.306    -4.597     0.200
     3.306    -3.995     0.200
     3.786    -3.708     0.200
     3.786    -3.407     0.200
     4.016    -4.291     0.200
     3.880    -3.779     0.200
     4.266    -4.412     0.200
     4.214    -5.478     0.200
     4.820    -4.583     0.200
     5.486    -3.784     0.200
     5.545    -2.501     0.200
     5.772    -5.163     0.200
     5.872    -6.130     0.200
     7.218    -6.001     0.200
     7.547    -6.724     0.200
     2.263    -0.973     0.200
     2.578    -3.259     0.200
     2.692    -3.172     0.200
     4.657    -4.666     0.200
     2.234    -1.671     0.200
     2.234    -1.569     0.200
     2.565    -1.539     0.200
     2.565    -2.441     0.200
     2.651    -2.279     0.200
     2.773    -1.757     0.200
     2.773    -1.655     0.200
     3.041    -4.458     0.200
     3.041    -2.958     0.200
     3.330    -4.295     0.200
     3.330    -3.095     0.200
     3.376    -3.576     0.200
     3.376    -2.576     0.200
     3.409    -0.314     0.200
     3.721    -2.613     0.200
     3.721    -3.113     0.200
     3.949    -5.122     0.200
     4.332    -4.465     0.200
     4.352    -2.300     0.200
     4.867    -4.416     0.200
     5.511    -4.926     0.200
     5.508    -2.646     0.200
     6.873    -6.333     0.200
     2.241    -1.451     0.200
     2.573    -1.879     0.200
     2.646    -2.092     0.200
     3.327    -2.786     0.200
     2.639    -3.272     0.200
     3.365    -2.982     0.200
     2.182    -0.938     0.200
     2.286    -2.928     0.200
     2.775    -2.844     0.200
     2.854    -3.144     0.200
     2.939    -3.939     0.200
     3.146    -1.293     0.200
     3.374    -5.236     0.200
     3.374    -2.134     0.200
     3.506    -3.309     0.200
     3.563    -2.115     0.200
     4.101    -6.192     0.200
     4.101    -3.692     0.200
     4.519    -3.834     0.200
     4.579    -2.639     0.200
     5.028    -2.877     0.200
     5.012    -4.968     0.200
     5.247    -5.107     0.200
     5.405    -3.322     0.200
     6.460    -4.160     0.200
     6.748    -6.693     0.200
     2.242    -1.583     0.200
     2.242    -1.388     0.200
     2.566    -1.656     0.200
     2.566    -2.453     0.200
     2.641    -2.536     0.200
     2.762    -2.371     0.200
     2.762    -1.769     0.200
     3.046    -4.188     0.200
     3.046    -2.290     0.200
     3.342    -3.370     0.200
     3.342    -2.574     0.200
     3.415    -1.858     0.200
     3.415    -0.655     0.200
     3.366    -3.106     0.200
     3.366    -2.911     0.200
     3.730    -4.371     0.200
     3.730    -2.473     0.200
     3.937    -5.024     0.200
     3.937    -3.820     0.200
     4.088    -1.095     0.200
     4.341    -3.520     0.200
     4.343    -2.797     0.200
     4.855    -4.911     0.200
     4.855    -6.012     0.200
     5.299    -3.481     0.200
     5.516    -5.674     0.200
     5.516    -4.369     0.200
     5.507    -2.705     0.200
     6.682    -5.325     0.200
     6.886    -5.786     0.200
     7.532    -4.881     0.200
     8.130    -4.836     0.200
     2.246    -1.712     0.200
     2.246    -1.415     0.200
     2.571    -2.522     0.200
     2.571    -2.123     0.200
     2.638    -2.458     0.200
     2.760    -3.320     0.200
     2.760    -2.516     0.200
     3.051    -4.544     0.200
     3.051    -2.442     0.200
     3.341    -3.725     0.200
     3.341    -2.725     0.200
     3.363    -3.548     0.200
     3.363    -3.446     0.200
     3.419    -0.507     0.200
     3.734    -3.584     0.200
     3.734    -2.584     0.200
     3.935    -3.778     0.200
     4.091    -1.223     0.200
     4.337    -4.399     0.200
     4.340    -2.198     0.200
     4.340    -1.299     0.200
     4.853    -4.778     0.200
     5.298    -4.577     0.200
     5.502    -3.548     0.200
     5.520    -6.120     0.200
     5.520    -5.221     0.200
     6.685    -3.932     0.200
     6.887    -5.639     0.200
     7.535    -2.879     0.200
     8.128    -5.771     0.200
     8.278    -5.836     0.200
     2.059    -1.033     0.200
     2.313    -1.576     0.200
     2.269    -0.582     0.200
     2.288    -1.689     0.200
     2.539    -0.449     0.200
     2.539    -0.550     0.200
     2.656    -1.049     0.200
     2.842    -2.661     0.200
     2.842    -3.161     0.200
     2.844    -3.319     0.200
     2.844    -4.022     0.200
     3.233    -1.733     0.200
     3.233    -1.835     0.200
     3.543    -2.958     0.200
     3.656    -3.550     0.200
     3.656    -2.351     0.200
     4.267    -4.321     0.200
     4.267    -4.021     0.200
     4.267    -3.060     0.200
     4.336    -4.695     0.200
     4.740    -5.602     0.200
     4.825    -5.797     0.200
     5.232    -4.026     0.200
     5.788    -4.934     0.200
     6.020    -5.300     0.200
     6.130    -3.264     0.200
     6.120    -2.176     0.200
     6.280    -2.127     0.200
     6.632    -3.006     0.200
    14.730    -8.182     0.200
     2.248    -1.635     0.200
     2.571    -2.069     0.200
     2.571    -2.569     0.200
     2.635    -2.001     0.200
     2.756    -2.445     0.200
     2.756    -2.047     0.200
     3.052    -2.831     0.200
     3.346    -3.835     0.200
     3.346    -2.929     0.200
     3.360    -2.378     0.200
     3.737    -3.127     0.200
     3.931    -4.906     0.200
     3.931    -2.304     0.200
     4.094    -3.147     0.200
     4.340    -4.070     0.200
     4.337    -1.361     0.200
     5.267    -5.235     0.200
     5.267    -3.735     0.200
     5.294    -4.282     0.200
     5.522    -4.515     0.200
     5.503    -3.120     0.200
     6.891    -5.626     0.200
     2.241    -1.297     0.200
     2.241    -1.094     0.200
     2.564    -1.311     0.200
     2.564    -2.014     0.200
     2.640    -1.944     0.200
     2.761    -1.458     0.200
     2.761    -1.357     0.200
     3.045    -4.175     0.200
     3.045    -2.374     0.200
     3.345    -3.289     0.200
     3.365    -3.111     0.200
     3.365    -2.209     0.200
     3.413    -1.148     0.200
     3.730    -2.498     0.200
     3.730    -2.295     0.200
     3.936    -2.806     0.200
     4.087    -3.009     0.200
     4.344    -3.551     0.200
     4.343    -2.123     0.200
     4.853    -5.097     0.200
     4.853    -4.695     0.200
     5.260    -3.699     0.200
     5.297    -3.847     0.200
     5.515    -4.762     0.200
     5.510    -2.399     0.200
     6.682    -5.056     0.200
     6.887    -5.854     0.200
     9.116    -7.324     0.200
     2.197    -1.367     0.200
     2.497    -2.071     0.200
     2.497    -2.270     0.200
     2.671    -2.089     0.200
     2.779    -2.413     0.200
     2.779    -1.710     0.200
     2.988    -2.562     0.200
     2.988    -1.062     0.200
     3.358    -1.281     0.200
     3.358    -0.879     0.200
     3.379    -3.236     0.200
     3.379    -2.838     0.200
     3.390    -2.688     0.200
     3.950    -4.950     0.200
     3.950    -2.450     0.200
     4.043    -1.776     0.200
     4.383    -2.266     0.200
     4.383    -1.965     0.200
     4.407    -4.137     0.200
     4.407    -4.539     0.200
     4.866    -3.780     0.200
     5.221    -4.741     0.200
     5.294    -6.558     0.200
     5.294    -2.058     0.200
     5.460    -5.495     0.200
     5.578    -2.163     0.200
     5.690    -1.004     0.200
     6.647    -4.821     0.200
     6.878    -4.574     0.200
     8.700    -7.114     0.200
     2.491    -2.090     0.200
     3.364    -3.980     0.200
     4.399    -3.484     0.200
     2.203    -1.590     0.200
     2.497    -0.914     0.200
     2.497    -1.814     0.200
     2.663    -2.081     0.200
     2.770    -2.260     0.200
     2.770    -2.461     0.200
     2.992    -1.804     0.200
     3.362    -1.134     0.200
     3.390    -2.522     0.200
     3.382    -2.658     0.200
     3.382    -2.458     0.200
     3.941    -4.187     0.200
     4.048    -3.098     0.200
     4.376    -0.494     0.200
     4.416    -4.237     0.200
     4.856    -3.412     0.200
     5.228    -3.988     0.200
     5.284    -4.860     0.200
     5.284    -5.060     0.200
     5.463    -6.650     0.200
     5.579    -2.318     0.200
     6.654    -5.388     0.200
     6.888    -4.622     0.200
     2.506    -2.521     0.200
     2.669    -1.781     0.200
     2.669    -1.882     0.200
     2.779    -1.570     0.200
     2.779    -1.770     0.200
     2.995    -2.834     0.200
     2.995    -1.633     0.200
     3.371    -1.042     0.200
     3.371    -2.142     0.200
     3.365    -0.943     0.200
     3.389    -2.909     0.200
     3.389    -2.509     0.200
     3.951    -4.627     0.200
     3.951    -3.727     0.200
     4.047    -2.575     0.200
     4.396    -3.639     0.200
     4.379    -1.205     0.200
     4.867    -3.667     0.200
     4.867    -3.466     0.200
     5.225    -3.506     0.200
     5.298    -4.320     0.200
     5.466    -5.659     0.200
     5.569    -1.609     0.200
     5.681    -2.769     0.200
     6.649    -4.466     0.200
     6.877    -4.873     0.200
     8.703    -5.775     0.200
     2.190    -1.521     0.200
     2.190    -1.420     0.200
     2.490    -2.151     0.200
     2.678    -2.192     0.200
     2.785    -2.399     0.200
     2.785    -2.500     0.200
     2.981    -2.616     0.200
     2.981    -1.917     0.200
     3.351    -0.936     0.200
     3.377    -2.646     0.200
     3.377    -2.247     0.200
     3.397    -2.784     0.200
     3.397    -3.183     0.200
     3.397    -3.284     0.200
     3.957    -5.429     0.200
     3.957    -4.632     0.200
     4.035    -1.832     0.200
     4.390    -1.876     0.200
     4.409    -4.775     0.200
     4.409    -5.178     0.200
     4.872    -6.455     0.200
     4.872    -6.556     0.200
     5.214    -3.796     0.200
     5.300    -4.107     0.200
     6.640    -4.582     0.200
     6.873    -4.470     0.200
     2.197    -1.232     0.200
     2.671    -1.663     0.200
     2.780    -2.313     0.200
     2.780    -1.813     0.200
     2.990    -2.062     0.200
     2.990    -3.062     0.200
     3.360    -1.577     0.200
     3.375    -1.853     0.200
     3.375    -2.952     0.200
     3.391    -2.874     0.200
     3.391    -3.374     0.200
     3.952    -4.859     0.200
     3.952    -3.559     0.200
     4.043    -2.343     0.200
     4.383    -1.915     0.200
     4.402    -4.334     0.200
     4.868    -4.392     0.200
     5.221    -5.591     0.200
     5.221    -2.392     0.200
     5.297    -4.600     0.200
     5.461    -4.593     0.200
     5.575    -2.613     0.200
     6.646    -5.364     0.200
     2.194    -1.870     0.200
     2.194    -1.472     0.200
     2.675    -1.118     0.200
     2.784    -2.273     0.200
     2.784    -1.674     0.200
     2.987    -1.620     0.200
     3.357    -1.332     0.200
     3.372    -2.699     0.200
     3.395    -3.331     0.200
     3.690    -2.995     0.200
     4.401    -3.736     0.200
     4.386    -2.565     0.200
     4.872    -3.752     0.200
     5.218    -3.827     0.200
     5.301    -4.358     0.200
     5.458    -5.246     0.200
     5.577    -2.707     0.200
     6.643    -6.295     0.200
     6.872    -6.578     0.200
     2.234    -2.058     0.200
     2.234    -1.456     0.200
     2.567    -3.110     0.200
     2.567    -1.310     0.200
     2.653    -3.442     0.200
     2.653    -1.641     0.200
     2.776    -2.641     0.200
     2.776    -1.345     0.200
     3.042    -4.083     0.200
     3.042    -2.286     0.200
     3.325    -3.747     0.200
     3.325    -4.446     0.200
     3.410    -0.336     0.200
     3.410    -2.234     0.200
     3.379    -2.746     0.200
     3.379    -3.847     0.200
     3.720    -3.779     0.200
     3.720    -3.376     0.200
     3.952    -5.114     0.200
     3.952    -2.313     0.200
     4.079    -3.066     0.200
     4.327    -5.014     0.200
     4.327    -4.713     0.200
     4.353    -2.537     0.200
     4.870    -4.310     0.200
     5.251    -4.099     0.200
     5.315    -4.631     0.200
     5.511    -5.645     0.200
     6.671    -6.021     0.200
     6.870    -5.934     0.200
     2.305    -1.574     0.200
     2.573    -2.072     0.200
     2.559    -1.427     0.200
     2.559    -2.626     0.200
     2.667    -2.347     0.200
     2.667    -2.947     0.200
     3.085    -2.212     0.200
     3.085    -3.112     0.200
     3.277    -2.607     0.200
     3.277    -1.407     0.200
     3.277    -3.808     0.200
     3.454    -2.319     0.200
     3.454    -2.819     0.200
     3.456    -1.285     0.200
     3.456    -1.686     0.200
     3.805    -4.529     0.200
     3.839    -3.508     0.200
     4.150    -2.375     0.200
     4.273    -1.387     0.200
     4.273    -1.686     0.200
     4.424    -4.572     0.200
     4.424    -4.271     0.200
     4.755    -6.351     0.200
     4.755    -3.152     0.200
     5.190    -3.838     0.200
     5.190    -6.538     0.200
     5.511    -3.323     0.200
     5.558    -4.195     0.200
     6.758    -4.343     0.200
     6.988    -5.733     0.200
     2.229    -1.816     0.200
     2.229    -1.417     0.200
     2.552    -2.060     0.200
     2.552    -2.161     0.200
     2.653    -1.960     0.200
     2.772    -2.239     0.200
     2.772    -1.934     0.200
     3.032    -1.894     0.200
     3.342    -2.210     0.200
     3.342    -2.108     0.200
     3.400    -1.066     0.200
     3.400    -0.964     0.200
     3.377    -3.109     0.200
     3.377    -4.015     0.200
     3.718    -3.231     0.200
     3.718    -2.325     0.200
     4.074    -1.625     0.200
     3.946    -3.775     0.200
     3.946    -4.572     0.200
     4.348    -4.616     0.200
     4.348    -4.413     0.200
     4.356    -2.756     0.200
     4.864    -4.255     0.200
     5.502    -4.578     0.200
     5.521    -1.999     0.200
     5.635    -1.918     0.200
     6.669    -4.191     0.200
     6.877    -5.669     0.200
     7.520    -5.058     0.200
    10.049    -8.235     0.200
    14.046   -11.411     0.200
    14.254    -9.182     0.200
    17.905    -5.608     0.200
    24.617   -10.090     0.200
     2.235    -1.150     0.200
     2.235    -2.252     0.200
     2.645    -2.143     0.200
     2.645    -2.443     0.200
     2.764    -2.416     0.200
     3.038    -2.196     0.200
     3.348    -2.519     0.200
     3.406    -1.174     0.200
     3.406    -1.072     0.200
     3.369    -2.792     0.200
     3.369    -3.195     0.200
     3.725    -2.177     0.200
     3.939    -3.256     0.200
     4.351    -2.407     0.200
     4.351    -5.208     0.200
     4.349    -2.255     0.200
     4.349    -2.853     0.200
     4.856    -3.936     0.200
     4.856    -4.838     0.200
     5.255    -3.671     0.200
     5.508    -5.288     0.200
     5.518    -2.408     0.200
     5.631    -1.366     0.200
     6.677    -4.740     0.200
     6.884    -4.531     0.200
     7.527    -4.013     0.200
    14.261   -10.040     0.200
    17.911    -5.611     0.200
    17.968    -5.268     0.200
    18.496    -4.755     0.200
    18.581    -7.457     0.200
    20.808     6.306     0.200
     2.152    -0.132     0.200
     2.315    -1.413     0.200
     2.568    -3.213     0.200
     2.543    -1.527     0.200
     2.646    -2.401     0.200
     3.089    -2.525     0.200
     3.484    -2.673     0.200
     3.817    -4.023     0.200
     3.817    -4.820     0.200
     4.160    -1.797     0.200
     4.262    -0.713     0.200
     4.451    -3.721     0.200
     4.733    -4.448     0.200
     5.164    -4.009     0.200
     5.344    -3.626     0.200
     5.562    -4.623     0.200
     6.772    -3.495     0.200
     7.011    -5.070     0.200
     2.674    -2.909     0.200
     2.692    -2.888     0.200
     3.338    -3.082     0.200
     2.258    -1.484     0.200
     2.258    -2.085     0.200
     2.231    -0.742     0.200
     2.578    -1.733     0.200
     2.625    -3.126     0.200
     2.746    -1.973     0.200
     2.746    -2.575     0.200
     2.879    -2.866     0.200
     3.061    -2.750     0.200
     3.061    -3.351     0.200
     3.352    -3.971     0.200
     3.352    -3.272     0.200
     3.429    -1.824     0.200
     3.429    -1.125     0.200
     3.350    -2.805     0.200
     3.350    -3.805     0.200
     3.746    -3.180     0.200
     3.922    -3.035     0.200
     3.922    -5.336     0.200
     4.103    -1.797     0.200
     4.341    -4.839     0.200
     4.327    -1.892     0.200
     4.839    -4.730     0.200
     5.277    -3.086     0.200
     5.496    -2.952     0.200
     5.531    -5.142     0.200
     6.698    -4.138     0.200
     6.901    -5.968     0.200
     2.155    -1.947     0.200
     2.412    -2.590     0.200
     2.924    -1.832     0.200
     3.664    -3.867     0.200
     4.506    -4.974     0.200
     2.232    -1.559     0.200
     2.253    -1.013     0.200
     2.550    -2.436     0.200
     2.646    -2.384     0.200
     2.764    -2.518     0.200
     2.764    -3.420     0.200
     2.900    -2.708     0.200
     3.034    -3.060     0.200
     3.034    -3.161     0.200
     3.352    -2.251     0.200
     3.352    -3.149     0.200
     3.402    -1.242     0.200
     3.370    -2.619     0.200
     3.723    -3.311     0.200
     4.357    -3.505     0.200
     4.351    -2.124     0.200
     4.856    -3.526     0.200
     5.253    -4.997     0.200
     5.296    -2.982     0.200
     5.504    -4.658     0.200
     6.675    -6.180     0.200
     6.885    -7.450     0.200
     2.201    -1.126     0.200
     2.329    -1.457     0.200
     2.329    -1.762     0.200
     2.455    -1.856     0.200
     2.666    -1.971     0.200
     2.885    -1.594     0.200
     2.927    -1.916     0.200
     2.927    -2.517     0.200
     3.434    -3.103     0.200
     3.508    -1.731     0.200
     3.508    -4.137     0.200
     3.641    -1.945     0.200
     3.808    -2.455     0.200
     3.911    -0.531     0.200
     4.428    -3.996     0.200
     4.512    -3.659     0.200
     4.904    -3.685     0.200
     5.237    -2.968     0.200
     5.693    -5.012     0.200
     5.908    -6.328     0.200
     6.859    -4.480     0.200
     7.118    -5.995     0.200
     7.310    -6.367     0.200
     2.122    -1.475     0.200
     2.122    -2.873     0.200
     2.469    -0.371     0.200
     2.617    -3.156     0.200
     2.867    -3.068     0.200
     3.009    -3.593     0.200
     2.998    -2.925     0.200
     2.998    -3.225     0.200
     3.027    -2.642     0.200
     3.127    -2.509     0.200
     3.353    -1.580     0.200
     3.560    -3.443     0.200
     3.607    -3.842     0.200
     4.209    -5.115     0.200
     2.171    -1.320     0.200
     2.303    -1.216     0.200
     2.303    -2.415     0.200
     2.425    -1.878     0.200
     2.701    -2.717     0.200
     2.921    -3.311     0.200
     2.898    -2.374     0.200
     2.898    -2.674     0.200
     3.470    -3.614     0.200
     3.470    -4.714     0.200
     3.483    -2.525     0.200
     3.648    -1.637     0.200
     3.878    -1.738     0.200
     4.198    -3.196     0.200
     4.395    -2.823     0.200
     4.404    -3.207     0.200
     4.546    -3.716     0.200
     4.886    -4.505     0.200
     5.203    -3.044     0.200
     5.944    -3.740     0.200
     7.334    -5.193     0.200
     2.031    -1.176     0.200
     2.429    -2.766     0.200
     2.421    -2.110     0.200
     2.515    -3.901     0.200
     2.630    -1.247     0.200
     2.669    -1.976     0.200
     3.181    -3.104     0.200
     3.181    -4.104     0.200
     3.132    -2.668     0.200
     3.132    -3.965     0.200
     3.556    -3.089     0.200
     3.556    -2.487     0.200
     3.603    -3.581     0.200
     3.684    -3.771     0.200
     3.939    -3.452     0.200
     4.148    -1.675     0.200
     4.272    -3.193     0.200
     4.515    -3.713     0.200
     4.599    -5.077     0.200
     4.599    -5.878     0.200
     5.029    -3.707     0.200
     5.462    -4.208     0.200
     5.480    -4.196     0.200
     5.573    -1.889     0.200
     5.655    -4.641     0.200
     6.893    -4.800     0.200
     7.146    -6.002     0.200
     7.279    -4.730     0.200
     9.952    -8.248     0.200
    13.776   -10.356     0.200
    17.704    -4.140     0.200
    18.164    -6.289     0.200
    18.673   -10.886     0.200
     2.236    -1.080     0.200
     2.257    -1.452     0.200
     2.571    -2.300     0.200
     2.652    -2.549     0.200
     2.776    -2.384     0.200
     2.906    -2.407     0.200
     3.321    -3.877     0.200
     3.321    -0.478     0.200
     3.378    -2.170     0.200
     3.952    -3.161     0.200
     3.952    -4.061     0.200
     4.082    -2.887     0.200
     4.322    -3.689     0.200
     4.351    -1.919     0.200
     4.870    -3.963     0.200
     5.253    -4.706     0.200
     5.316    -5.020     0.200
     5.316    -5.520     0.200
     5.501    -3.266     0.200
     6.673    -5.014     0.200
     6.870    -5.062     0.200
     7.303    -3.995     0.200
     7.568    -6.611     0.200
     2.250    -1.474     0.200
     2.578    -3.185     0.200
     2.578    -0.787     0.200
     2.759    -2.335     0.200
     2.759    -2.936     0.200
     2.890    -2.274     0.200
     3.057    -2.551     0.200
     3.336    -3.303     0.200
     3.336    -1.803     0.200
     3.362    -2.831     0.200
     3.362    -2.331     0.200
     3.737    -2.711     0.200
     3.935    -3.312     0.200
     3.935    -4.710     0.200
     4.095    -2.085     0.200
     4.329    -4.379     0.200
     4.337    -1.329     0.200
     4.853    -5.006     0.200
     4.853    -5.311     0.200
     5.300    -5.070     0.200
     5.526    -5.127     0.200
     5.495    -4.049     0.200
     6.886    -5.760     0.200
     7.286    -6.545     0.200
     8.797    -8.137     0.200
     2.246    -1.190     0.200
     2.246    -0.510     0.200
     2.575    -1.739     0.200
     2.764    -2.014     0.200
     2.764    -2.314     0.200
     2.895    -1.855     0.200
     3.053    -2.083     0.200
     3.053    -3.282     0.200
     3.333    -1.741     0.200
     3.333    -2.042     0.200
     3.421    -0.539     0.200
     3.421    -1.140     0.200
     3.366    -2.012     0.200
     3.366    -2.413     0.200
     3.732    -2.620     0.200
     3.940    -2.486     0.200
     4.091    -1.999     0.200
     4.091    -2.599     0.200
     4.328    -3.996     0.200
     4.341    -2.103     0.200
     4.858    -3.487     0.200
     4.858    -5.287     0.200
     5.304    -5.138     0.200
     5.522    -4.650     0.200
     5.497    -2.267     0.200
     5.612    -1.270     0.200
     6.683    -5.963     0.200
     6.882    -5.464     0.200
     8.119    -3.583     0.200
     8.802    -8.115     0.200
    20.487   -12.569     0.200
     2.253    -1.770     0.200
     2.241    -1.296     0.200
     2.585    -1.393     0.200
     2.585    -1.198     0.200
     2.635    -2.593     0.200
     2.760    -2.951     0.200
     3.062    -1.904     0.200
     3.062    -1.708     0.200
     3.329    -3.803     0.200
     3.739    -3.471     0.200
     3.936    -2.839     0.200
     3.936    -3.542     0.200
     4.320    -4.210     0.200
     4.320    -4.108     0.200
     4.334    -2.454     0.200
     4.855    -3.743     0.200
     4.855    -3.946     0.200
     5.530    -4.768     0.200
     6.689    -6.406     0.200
     6.885    -5.904     0.200
     2.038    -0.251     0.200
     2.290    -2.852     0.200
     2.624    -2.228     0.200
     2.704    -2.885     0.200
     3.017    -2.592     0.200
     3.127    -3.077     0.200
     3.151    -2.826     0.200
     3.270    -3.199     0.200
     3.353    -3.649     0.200
     3.738    -4.358     0.200
     4.297    -6.169     0.200
     4.361    -3.897     0.200
     4.720    -2.277     0.200
     5.166    -5.216     0.200
     5.212    -4.864     0.200
     5.624    -4.720     0.200
     5.786    -2.879     0.200
     6.304    -5.095     0.200
     6.538    -6.492     0.200
     2.134    -2.222     0.200
     2.134    -2.523     0.200
     2.368    -1.128     0.200
     2.507    -3.539     0.200
     2.507    -3.641     0.200
     2.763    -2.738     0.200
     2.888    -3.702     0.200
     2.958    -3.515     0.200
     2.958    -4.015     0.200
     3.017    -2.607     0.200
     3.017    -3.507     0.200
     3.241    -3.188     0.200
     3.241    -4.889     0.200
     3.490    -2.983     0.200
     3.490    -2.583     0.200
     3.614    -3.337     0.200
     4.063    -5.168     0.200
     4.298    -3.923     0.200
     2.338    -0.782     0.200
     2.477    -2.197     0.200
     2.551    -2.448     0.200
     2.594    -1.198     0.200
     2.829    -2.942     0.200
     3.069    -2.555     0.200
     3.344    -2.573     0.200
     3.494    -2.244     0.200
     3.658    -2.924     0.200
     3.715    -2.323     0.200
     4.040    -3.530     0.200
     4.034    -1.341     0.200
     4.315    -3.645     0.200
     4.397    -3.165     0.200
     4.578    -4.304     0.200
     5.058    -4.306     0.200
     5.264    -2.051     0.200
     5.570    -4.556     0.200
     5.816    -5.538     0.200
     6.990    -4.561     0.200
     7.009    -6.265     0.200
     7.159    -5.325     0.200
     7.318    -5.763     0.200
     2.337    -2.053     0.200
     2.476    -1.950     0.200
     2.551    -2.030     0.200
     2.593    -0.360     0.200
     2.827    -3.382     0.200
     3.068    -2.518     0.200
     3.343    -1.636     0.200
     3.497    -3.805     0.200
     3.656    -4.568     0.200
     3.714    -2.587     0.200
     4.040    -3.116     0.200
     4.034    -2.022     0.200
     4.317    -3.623     0.200
     4.397    -3.243     0.200
     4.577    -5.252     0.200
     5.056    -3.932     0.200
     5.570    -4.842     0.200
     5.815    -5.502     0.200
     6.990    -5.853     0.200
     7.008    -5.816     0.200
     7.161    -5.752     0.200
     7.316    -4.191     0.200
     8.524    -7.481     0.200
     2.038    -1.986     0.200
     2.419    -2.154     0.200
     2.423    -2.594     0.200
     2.498    -3.370     0.200
     2.498    -1.969     0.200
     2.574    -3.486     0.200
     2.667    -1.034     0.200
     3.147    -2.553     0.200
     3.147    -3.953     0.200
     3.125    -3.140     0.200
     3.125    -2.440     0.200
     3.524    -2.301     0.200
     3.680    -2.227     0.200
     3.661    -3.733     0.200
     3.661    -3.632     0.200
     3.938    -3.416     0.200
     4.163    -2.748     0.200
     4.258    -2.960     0.200
     4.611    -3.839     0.200
     4.573    -4.739     0.200
     4.573    -5.039     0.200
     4.983    -3.650     0.200
     4.983    -5.650     0.200
     5.455    -4.412     0.200
     5.552    -4.079     0.200
     5.622    -4.382     0.200
     5.622    -4.682     0.200
     5.640    -0.201     0.200
     6.893    -5.872     0.200
     7.007    -4.709     0.200
     7.181    -5.800     0.200
     7.229    -5.624     0.200
     8.509    -8.624     0.200
     2.141     0.244     0.200
     2.391    -3.095     0.200
     2.512    -0.122     0.200
     2.820    -2.668     0.200
     2.820    -3.364     0.200
     2.906    -3.012     0.200
     3.024    -2.251     0.200
     3.024    -1.454     0.200
     3.179    -1.751     0.200
     3.179    -2.251     0.200
     3.183    -1.578     0.200
     3.183    -1.375     0.200
     3.160    -1.460     0.200
     3.631    -2.838     0.200
     3.631    -2.979     0.200
     3.833    -2.103     0.200
     4.197    -3.436     0.200
     4.197    -5.639     0.200
     4.321    -5.179     0.200
     4.321    -2.874     0.200
     4.321    -4.179     0.200
     4.605    -1.452     0.200
     5.000    -4.583     0.200
     5.114    -6.787     0.200
     5.282    -4.939     0.200
     5.282    -6.338     0.200
     5.540    -3.607     0.200
     5.681    -1.678     0.200
     5.810     0.310     0.200
     6.418    -4.246     0.200
     6.630    -6.166     0.200
     7.267    -5.953     0.200
     8.946    -5.862     0.200
     9.648    -7.534     0.200
    14.242    -6.812     0.200
    17.739    -5.140     0.200
    18.219    -5.567     0.200
    20.281   -14.332     0.200
     2.137    -2.028     0.200
     2.272    -1.527     0.200
     2.736    -1.928     0.200
     2.865    -2.018     0.200
     2.955    -2.952     0.200
     3.453    -4.058     0.200
     3.453    -1.159     0.200
     3.506    -2.620     0.200
     3.664    -3.633     0.200
     3.843    -1.900     0.200
     3.879    -3.270     0.200
     4.374    -4.752     0.200
     4.391    -4.072     0.200
     4.582    -1.227     0.200
     4.862    -4.315     0.200
     5.762    -3.435     0.200
     5.980    -4.148     0.200
     7.125    -3.554     0.200
     7.185    -3.670     0.200
     7.364    -5.719     0.200
     2.250    -1.891     0.200
     2.234    -2.179     0.200
     2.560    -3.213     0.200
     2.560    -0.315     0.200
     2.627    -2.146     0.200
     2.744    -3.155     0.200
     2.880    -2.863     0.200
     3.048    -4.098     0.200
     3.369    -2.879     0.200
     3.350    -2.867     0.200
     3.417    -3.193     0.200
     3.918    -3.778     0.200
     4.096    -3.405     0.200
     4.333    -3.226     0.200
     4.835    -4.455     0.200
     5.271    -5.563     0.200
     5.276    -4.018     0.200
     5.518    -4.809     0.200
     6.694    -5.964     0.200
     6.906    -6.890     0.200
     7.527    -5.766     0.200
     8.681    -5.972     0.200
     2.249    -2.501     0.200
     2.556    -2.944     0.200
     3.046    -3.766     0.200
     2.196    -1.980     0.200
     2.292    -1.920     0.200
     2.525    -3.419     0.200
     2.685    -2.594     0.200
     2.803    -2.728     0.200
     2.938    -1.722     0.200
     3.326    -3.317     0.200
     3.369    -2.671     0.200
     3.409    -3.434     0.200
     3.409    -1.634     0.200
     3.977    -5.949     0.200
     3.977    -3.347     0.200
     4.351    -4.621     0.200
     4.389    -2.108     0.200
     4.894    -4.220     0.200
     5.332    -4.103     0.200
     5.470    -5.584     0.200
     6.636    -4.350     0.200
     6.847    -6.743     0.200
     7.582    -5.122     0.200
     2.250    -1.747     0.200
     2.241    -0.358     0.200
     2.577    -2.413     0.200
     2.635    -1.951     0.200
     2.758    -2.547     0.200
     2.889    -1.900     0.200
     3.056    -2.704     0.200
     3.338    -2.837     0.200
     3.361    -3.055     0.200
     3.424    -1.366     0.200
     3.737    -3.195     0.200
     3.934    -1.619     0.200
     4.096    -2.956     0.200
     4.336    -2.066     0.200
     4.852    -3.917     0.200
     5.268    -3.809     0.200
     5.298    -4.262     0.200
     5.526    -4.381     0.200
     6.577    -5.002     0.200
     6.888    -4.269     0.200
     7.550    -4.356     0.200
     8.703    -7.917     0.200
    10.065    -6.592     0.200
     2.254    -1.868     0.200
     2.237    -1.147     0.200
     2.579    -3.079     0.200
     2.754    -2.029     0.200
     3.059    -2.206     0.200
     3.342    -2.259     0.200
     3.357    -3.235     0.200
     3.741    -3.325     0.200
     3.930    -5.299     0.200
     3.930    -2.197     0.200
     4.099    -4.480     0.200
     4.333    -4.084     0.200
     4.332    -2.363     0.200
     4.848    -3.898     0.200
     5.272    -3.640     0.200
     5.294    -5.044     0.200
     5.529    -4.485     0.200
     6.692    -5.874     0.200
     6.892    -5.414     0.200
     8.285    -8.654     0.200
     2.209    -2.830     0.200
     2.274    -3.308     0.200
     2.450    -2.978     0.200
     2.633    -3.266     0.200
     2.633    -0.766     0.200
     2.729    -3.311     0.200
     2.904    -4.177     0.200
     3.338    -3.411     0.200
     3.436    -5.245     0.200
     3.717    -2.930     0.200
     3.853    -2.965     0.200
     3.958    -1.976     0.200
     4.157    -5.276     0.200
     4.348    -5.355     0.200
     4.684    -4.702     0.200
     5.453    -4.084     0.200
     5.526    -1.617     0.200
     5.810    -5.677     0.200
     7.015    -6.190     0.200
     7.111    -5.520     0.200
     8.742    -7.336     0.200
     2.251    -1.458     0.200
     2.241    -0.265     0.200
     2.580    -1.087     0.200
     2.636    -2.861     0.200
     2.759    -1.976     0.200
     2.890    -2.813     0.200
     2.890    -0.610     0.200
     3.058    -3.247     0.200
     3.335    -2.522     0.200
     3.362    -2.670     0.200
     3.737    -2.891     0.200
     3.935    -3.057     0.200
     4.096    -2.865     0.200
     4.327    -4.085     0.200
     4.336    -1.952     0.200
     4.853    -4.354     0.200
     5.300    -3.726     0.200
     5.527    -4.713     0.200
     5.493    -2.951     0.200
     6.688    -4.435     0.200
     6.886    -5.910     0.200
     7.552    -6.224     0.200
     8.280    -7.890     0.200
     8.706    -6.677     0.200
     9.122    -6.967     0.200
    10.065    -7.963     0.200
     2.250    -1.449     0.200
     2.250    -2.050     0.200
     2.240    -0.024     0.200
     2.574    -1.718     0.200
     2.574    -3.023     0.200
     2.634    -1.715     0.200
     2.756    -2.578     0.200
     2.887    -1.556     0.200
     3.055    -2.165     0.200
     3.344    -2.515     0.200
     3.344    -3.015     0.200
     3.359    -1.702     0.200
     3.359    -2.202     0.200
     3.738    -3.021     0.200
     3.738    -3.825     0.200
     3.931    -3.044     0.200
     3.931    -0.638     0.200
     3.931    -5.544     0.200
     4.096    -3.960     0.200
     4.335    -2.058     0.200
     4.335    -2.558     0.200
     4.337    -4.418     0.200
     4.337    -4.918     0.200
     4.849    -4.037     0.200
     5.294    -5.150     0.200
     5.294    -5.049     0.200
     5.524    -5.049     0.200
     5.500    -3.858     0.200
     5.613    -1.687     0.200
     6.574    -4.520     0.200
     6.689    -5.276     0.200
     6.891    -4.972     0.200
     7.546    -4.331     0.200
     8.282    -6.072     0.200
     8.700    -8.798     0.200
     9.115    -6.560     0.200
     9.919    -7.649     0.200
    10.067    -8.653     0.200
    15.106    -6.021     0.200
    17.906    -4.193     0.200
    17.963    -3.961     0.200
    18.580    -4.841     0.200
    18.796    -9.318     0.200
     2.059    -0.314     0.200
     2.127    -2.167     0.200
     2.336    -2.491     0.200
     2.726    -2.839     0.200
     2.816    -2.607     0.200
     2.816    -0.205     0.200
     2.901    -2.685     0.200
     2.974    -3.208     0.200
     3.424    -2.474     0.200
     3.437    -3.583     0.200
     3.972    -3.838     0.200
     4.450    -3.090     0.200
     4.497    -3.710     0.200
     4.894    -5.084     0.200
     5.158    -4.540     0.200
     5.301    -3.769     0.200
     5.373    -5.272     0.200
     5.682    -3.072     0.200
     6.588    -5.593     0.200
     6.859    -6.678     0.200
     7.542    -5.426     0.200
     8.204    -6.302     0.200
     9.993    -9.326     0.200
     2.224    -0.525     0.200
     2.224    -0.724     0.200
     2.330    -2.000     0.200
     2.621    -2.113     0.200
     2.621    -2.012     0.200
     2.735    -3.617     0.200
     2.735    -2.918     0.200
     2.780    -2.346     0.200
     2.880    -2.437     0.200
     2.880    -2.836     0.200
     3.202    -2.844     0.200
     3.202    -3.441     0.200
     3.174    -2.644     0.200
     3.174    -4.245     0.200
     3.360    -2.981     0.200
     3.360    -2.653     0.200
     3.360    -2.352     0.200
     3.536    -3.625     0.200
     3.536     0.774     0.200
     3.789    -3.740     0.200
     3.789    -4.037     0.200
     3.962    -4.734     0.200
     3.962    -3.332     0.200
     4.138    -4.009     0.200
     4.171    -2.369     0.200
     4.288    -3.173     0.200
     4.288    -2.372     0.200
     4.884    -4.651     0.200
     4.884    -4.248     0.200
     5.335    -2.963     0.200
     5.459    -0.717     0.200
     6.732    -5.047     0.200
     6.722    -3.809     0.200
     7.313    -5.262     0.200
     7.975    -6.446     0.200
     8.297    -8.056     0.200
     9.208    -6.529     0.200
    10.076    -8.047     0.200
    14.166    -8.467     0.200
     2.223    -2.265     0.200
     2.278    -1.601     0.200
     2.573    -3.270     0.200
     2.672    -2.715     0.200
     2.800    -2.764     0.200
     2.927    -1.496     0.200
     3.039    -3.329     0.200
     3.291    -2.039     0.200
     3.400    -2.184     0.200
     3.705    -2.938     0.200
     3.977    -2.964     0.200
     4.298    -4.056     0.200
     4.368    -2.670     0.200
     4.895    -4.179     0.200
     5.236    -4.098     0.200
     5.345    -4.729     0.200
     5.506    -5.147     0.200
     6.655    -5.655     0.200
     6.844    -6.755     0.200
     8.243    -5.287     0.200
    10.026    -8.643     0.200
     2.119    -2.448     0.200
     2.945    -3.325     0.200
     4.293    -4.254     0.200
     6.741    -6.560     0.200
     2.319    -1.092     0.200
     2.463    -1.257     0.200
     2.463    -1.556     0.200
     2.575    -1.725     0.200
     2.576    -2.129     0.200
     2.857    -2.954     0.200
     3.052    -2.224     0.200
     3.052    -1.518     0.200
     3.052    -2.918     0.200
     3.371    -1.838     0.200
     3.371    -3.739     0.200
     3.493    -0.397     0.200
     3.493    -0.597     0.200
     3.644    -3.405     0.200
     3.741    -2.879     0.200
     3.741     0.621     0.200
     4.011    -0.434     0.200
     4.011    -0.634     0.200
     4.062    -2.939     0.200
     4.297    -2.197     0.200
     4.297    -5.797     0.200
     4.421    -2.541     0.200
     4.565    -3.005     0.200
     4.565    -3.305     0.200
     5.051    -2.184     0.200
     5.335    -0.088     0.200
     6.867    -4.671     0.200
     7.012    -4.453     0.200
     7.173    -4.452     0.200
     7.312    -3.879     0.200
     8.596    -5.861     0.200
     8.894    -6.729     0.200
    13.868    -8.208     0.200
    14.601   -11.319     0.200
    17.695    -4.944     0.200
    18.368    -3.435     0.200
    18.920   -10.465     0.200
     2.425    -0.895     0.200
     2.425    -1.895     0.200
     2.598    -1.594     0.200
     2.725    -2.027     0.200
     2.725    -2.328     0.200
     2.720    -1.258     0.200
     3.224    -2.447     0.200
     3.194    -2.063     0.200
     3.194    -1.782     0.200
     3.194    -0.981     0.200
     3.419    -2.819     0.200
     3.419    -1.617     0.200
     3.594    -1.757     0.200
     3.594    -0.456     0.200
     3.777    -3.864     0.200
     3.777    -1.964     0.200
     3.777    -1.464     0.200
     3.912    -1.927     0.200
     4.162    -1.551     0.200
     4.162    -1.852     0.200
     4.271    -2.105     0.200
     4.697    -3.619     0.200
     5.163    -2.507     0.200
     5.442    -4.157     0.200
     5.463     0.207     0.200
     6.862    -3.957     0.200
     7.041    -5.528     0.200
     7.129    -4.113     0.200
     7.710    -6.149     0.200
     8.450    -6.590     0.200
     8.997    -6.127     0.200
    10.081    -6.908     0.200
    10.233    -6.727     0.200
    17.820    -1.645     0.200
    17.977    -6.389     0.200
    18.467    -4.227     0.200
     2.458    -2.253     0.200
     2.750    -2.493     0.200
     3.244    -2.658     0.200
     3.922    -2.166     0.200
     5.454    -5.225     0.200
     2.069    -0.791     0.200
     2.432    -1.797     0.200
     2.465    -1.023     0.200
     2.603    -2.807     0.200
     2.744    -2.668     0.200
     2.721    -1.941     0.200
     3.196    -1.401     0.200
     3.237    -3.514     0.200
     3.401    -2.292     0.200
     3.606    -3.099     0.200
     3.783    -1.208     0.200
     3.916    -3.823     0.200
     4.157    -3.569     0.200
     4.278    -3.104     0.200
     4.286    -4.255     0.200
     4.703    -4.082     0.200
     5.175    -3.626     0.200
     5.336    -2.156     0.200
     5.448    -4.081     0.200
     6.865    -4.829     0.200
     7.035    -6.088     0.200
     7.135    -4.757     0.200
     2.244    -1.041     0.200
     2.242    -0.809     0.200
     2.242    -0.504     0.200
     2.560    -1.993     0.200
     2.560    -1.290     0.200
     2.636    -2.183     0.200
     2.755    -2.149     0.200
     2.755    -2.946     0.200
     2.889    -1.210     0.200
     3.045    -1.849     0.200
     3.355    -2.791     0.200
     3.355    -3.392     0.200
     3.360    -2.659     0.200
     3.360    -2.026     0.200
     3.360    -3.331     0.200
     3.413    -1.728     0.200
     3.413    -0.033     0.200
     3.734    -2.590     0.200
     3.929    -4.684     0.200
     3.929    -1.285     0.200
     3.929    -4.481     0.200
     4.340    -2.413     0.200
     4.340    -1.811     0.200
     4.354    -4.440     0.200
     4.354    -4.643     0.200
     4.847    -3.664     0.200
     4.847    -3.867     0.200
     5.264    -4.580     0.200
     5.288    -3.871     0.200
     5.288    -4.269     0.200
     5.515    -5.148     0.200
     5.515    -5.444     0.200
     5.627    -1.331     0.200
     6.685    -4.352     0.200
     6.894    -5.268     0.200
     7.537    -5.330     0.200
     9.107    -6.125     0.200
    14.031   -10.959     0.200
    14.269   -11.774     0.200
    15.115    -6.863     0.200
    17.918    -4.661     0.200
    18.572    -8.144     0.200
    18.779   -11.543     0.200
    20.474   -15.722     0.200
     2.252    -1.472     0.200
     2.239    -1.053     0.200
     2.578    -1.115     0.200
     2.633    -2.044     0.200
     3.058    -3.322     0.200
     3.359    -2.846     0.200
     3.740    -2.523     0.200
     4.332    -3.497     0.200
     2.011    -1.186     0.200
     2.269    -1.153     0.200
     2.299    -2.127     0.200
     2.649    -2.117     0.200
     2.699    -1.908     0.200
     3.060    -3.231     0.200
     3.043    -2.404     0.200
     3.332    -3.551     0.200
     3.296    -1.637     0.200
     3.767    -1.940     0.200
     4.741    -2.735     0.200
     4.864    -3.724     0.200
     6.263    -6.591     0.200
     6.281    -6.858     0.200
     2.008    -0.900     0.200
     2.102    -0.080     0.200
     2.307    -3.175     0.200
     2.307    -2.476     0.200
     2.264    -1.223     0.200
     2.705    -2.482     0.200
     2.705    -2.782     0.200
     2.648    -1.199     0.200
     3.065    -2.196     0.200
     3.065    -1.395     0.200
     3.102    -2.170     0.200
     3.102    -3.870     0.200
     3.043    -2.293     0.200
     3.159    -2.878     0.200
     3.333    -3.906     0.200
     3.296    -2.131     0.200
     3.703    -3.921     0.200
     3.703    -4.421     0.200
     3.767    -1.951     0.200
     3.767    -3.752     0.200
     4.320    -2.576     0.200
     4.331    -2.628     0.200
     4.739    -1.879     0.200
     4.866    -3.594     0.200
     4.866    -6.391     0.200
     5.163    -5.605     0.200
     5.664    -4.099     0.200
     5.774    -3.790     0.200
     6.270    -5.704     0.200
     6.283    -4.707     0.200
     6.283    -6.305     0.200
     7.131    -7.095     0.200
     7.874    -6.937     0.200
     7.908    -5.718     0.200
     9.513    -8.199     0.200
    14.344    -9.626     0.200
    14.781    -5.634     0.200
    17.656    -5.905     0.200
    18.347    -7.359     0.200
    18.918    -6.099     0.200
    20.678     1.583     0.200
     2.351    -1.603     0.200
     2.351    -3.202     0.200
     2.447    -2.850     0.200
     2.447    -3.049     0.200
     2.600    -2.271     0.200
     2.600    -1.972     0.200
     2.687    -3.337     0.200
     3.063    -4.281     0.200
     3.063    -3.175     0.200
     3.063    -4.075     0.200
     3.246    -3.357     0.200
     3.246    -3.658     0.200
     3.621    -3.358     0.200
     3.621    -2.858     0.200
     3.643    -3.452     0.200
     3.643    -3.852     0.200
     3.618    -5.553     0.200
     3.618    -3.353     0.200
     4.008    -4.032     0.200
     4.008    -4.133     0.200
     4.080    -2.288     0.200
     4.340    -3.356     0.200
     4.519    -3.827     0.200
     4.519    -4.227     0.200
     4.534    -4.479     0.200
     4.534    -4.678     0.200
     4.970    -6.207     0.200
     5.531    -4.686     0.200
     5.522    -1.846     0.200
     6.702    -5.614     0.200
     6.963    -5.781     0.200
     6.968    -5.938     0.200
     7.210    -6.125     0.200
     8.576    -7.635     0.200
    10.223    -7.945     0.200
    13.729   -10.166     0.200
    14.515   -12.718     0.200
    15.426    -6.429     0.200
    17.641    -3.051     0.200
    18.258    -9.603     0.200
    20.609   -14.144     0.200
     2.146    -1.792     0.200
     2.685    -2.472     0.200
     2.921    -1.643     0.200
     2.896    -2.247     0.200
     3.040    -2.530     0.200
     3.158    -1.749     0.200
     3.391    -1.848     0.200
     3.563    -2.695     0.200
     3.641    -1.381     0.200
     3.975    -3.467     0.200
     4.535    -3.129     0.200
     5.102    -2.590     0.200
     5.177    -4.174     0.200
     5.480    -5.282     0.200
     5.669    -3.561     0.200
     6.564    -5.640     0.200
     2.245    -1.562     0.200
     2.251    -1.459     0.200
     2.581    -2.230     0.200
     2.581    -2.331     0.200
     2.645    -2.657     0.200
     2.771    -2.536     0.200
     2.771    -2.739     0.200
     2.900    -1.620     0.200
     3.055    -3.050     0.200
     3.055    -2.457     0.200
     3.320    -2.440     0.200
     3.320    -2.940     0.200
     3.372    -2.000     0.200
     3.372    -1.899     0.200
     3.422    -1.600     0.200
     3.422     0.205     0.200
     3.730    -2.733     0.200
     4.090    -2.465     0.200
     4.315    -3.987     0.200
     4.315    -4.089     0.200
     4.343    -2.695     0.200
     4.343    -2.891     0.200
     4.865    -3.738     0.200
     4.865    -4.035     0.200
     5.261    -2.770     0.200
     5.606    -1.309     0.200
     6.680    -5.265     0.200
     6.874    -5.516     0.200
     6.874    -5.711     0.200
     2.040    -0.258     0.200
     2.090     0.282     0.200
     2.252    -1.070     0.200
     2.317    -3.523     0.200
     2.317    -2.124     0.200
     2.636    -1.644     0.200
     2.717    -2.898     0.200
     3.030    -2.337     0.200
     3.077    -2.619     0.200
     3.106    -3.151     0.200
     3.147    -1.645     0.200
     3.284    -3.081     0.200
     3.346    -3.546     0.200
     3.715    -3.362     0.200
     3.755    -3.503     0.200
     4.317    -3.728     0.200
     4.319    -3.101     0.200
     4.727    -3.220     0.200
     5.175    -4.532     0.200
     5.235    -5.128     0.200
     5.654    -4.016     0.200
     6.295    -6.146     0.200
     6.511    -6.486     0.200
     7.144    -6.133     0.200
     7.669    -5.086     0.200
     2.251    -1.834     0.200
     2.242    -1.567     0.200
     2.580    -2.192     0.200
     2.636    -2.664     0.200
     2.760    -1.292     0.200
     2.890    -2.521     0.200
     3.058    -2.633     0.200
     3.333    -2.846     0.200
     3.362    -2.778     0.200
     3.426    -1.993     0.200
     3.737    -3.154     0.200
     3.936    -5.571     0.200
     3.936    -2.969     0.200
     4.096    -2.342     0.200
     4.325    -3.909     0.200
     4.336    -2.852     0.200
     4.854    -3.975     0.200
     5.268    -5.080     0.200
     5.302    -5.352     0.200
     5.527    -5.303     0.200
     6.688    -4.696     0.200
     6.885    -5.455     0.200
     7.287    -5.407     0.200
     2.248    -1.656     0.200
     2.246    -0.905     0.200
     2.581    -2.421     0.200
     2.641    -1.905     0.200
     2.765    -0.960     0.200
     2.895    -1.364     0.200
     3.057    -2.703     0.200
     3.326    -2.236     0.200
     3.367    -2.832     0.200
     3.424    -2.055     0.200
     3.733    -2.550     0.200
     3.942    -2.948     0.200
     4.094    -3.663     0.200
     4.320    -3.835     0.200
     4.340    -1.964     0.200
     4.860    -3.753     0.200
     5.264    -4.980     0.200
     5.308    -4.153     0.200
     5.526    -5.263     0.200
     6.580    -5.375     0.200
     6.684    -5.587     0.200
     6.880    -5.383     0.200
     7.533    -7.304     0.200
     8.275    -6.312     0.200
     2.059    -2.713     0.200
     2.742    -2.093     0.200
     2.789    -2.854     0.200
     2.045    -0.136     0.200
     2.156    -1.059     0.200
     2.304    -0.429     0.200
     2.692    -2.342     0.200
     2.939    -2.876     0.200
     2.001    -1.190     0.200
     2.040    -0.337     0.200
     2.069    -0.236     0.200
     2.201    -1.430     0.200
     2.290    -0.649     0.200
     2.591    -3.185     0.200
     2.591    -0.489     0.200
     2.664    -2.921     0.200
     2.980    -1.231     0.200
     3.033    -2.103     0.200
     3.065    -4.529     0.200
     3.065    -2.029     0.200
     3.228    -1.688     0.200
     3.303    -3.052     0.200
     3.380    -3.494     0.200
     3.719    -3.753     0.200
     3.690    -2.718     0.200
     4.227    -6.752     0.200
     4.227    -2.853     0.200
     4.514    -3.949     0.200
     4.703    -3.750     0.200
     4.903    -5.485     0.200
     5.134    -5.117     0.200
     5.137    -3.504     0.200
     5.523    -4.230     0.200
     6.334    -5.539     0.200
     6.627    -6.448     0.200
     7.571    -5.668     0.200
     7.952    -7.347     0.200
     8.926    -6.808     0.200
     9.743    -8.900     0.200
     2.078    -0.477     0.200
     2.393    -1.859     0.200
     2.470    -3.106     0.200
     2.470    -1.505     0.200
     2.645    -2.537     0.200
     2.645    -2.736     0.200
     2.581    -2.521     0.200
     2.581    -2.021     0.200
     2.721    -1.974     0.200
     3.168    -2.442     0.200
     3.190    -3.215     0.200
     3.190    -2.617     0.200
     3.503    -1.445     0.200
     3.503    -2.547     0.200
     3.755    -4.426     0.200
     3.755    -5.027     0.200
     3.755    -2.426     0.200
     3.894    -1.732     0.200
     3.894    -3.529     0.200
     4.185    -2.261     0.200
     4.424    -3.953     0.200
     4.424    -3.851     0.200
     4.672    -4.899     0.200
     4.672    -3.899     0.200
     5.420    -4.821     0.200
     5.548    -0.534     0.200
     5.642    -4.645     0.200
     6.847    -4.346     0.200
     7.069    -6.102     0.200
    10.236    -7.197     0.200
     2.279    -1.763     0.200
     2.409    -0.780     0.200
     2.534    -1.519     0.200
     2.595    -1.561     0.200
     3.572    -4.137     0.200
     2.187    -0.154     0.200
     2.610    -2.040     0.200
     2.704    -1.616     0.200
     2.835    -0.983     0.200
     3.100    -2.182     0.200
     3.469    -1.878     0.200
     3.378    -2.009     0.200
     3.790    -2.656     0.200
     3.879    -1.493     0.200
     4.284    -2.015     0.200
     4.344    -3.221     0.200
     4.797    -3.096     0.200
     5.320    -3.353     0.200
     5.570    -4.494     0.200
     5.577    -1.529     0.200
     6.613    -4.535     0.200
     6.741    -5.016     0.200
     6.942    -5.878     0.200
     7.231    -4.028     0.200
     7.592    -6.474     0.200
     8.335    -6.531     0.200
    14.002   -10.972     0.200
     2.141    -2.458     0.200
     2.349    -2.031     0.200
     2.488    -3.137     0.200
     2.488    -2.736     0.200
     2.742    -2.609     0.200
     2.860    -3.631     0.200
     2.952    -3.474     0.200
     2.996    -3.338     0.200
     3.319    -2.900     0.200
     3.319    -2.301     0.200
     3.289    -3.442     0.200
     3.289    -3.743     0.200
     3.466    -3.950     0.200
     3.466    -4.950     0.200
     3.628    -4.004     0.200
     3.987    -2.866     0.200
     4.033    -4.538     0.200
     4.033    -5.839     0.200
     4.345    -4.114     0.200
     4.345    -5.413     0.200
     4.445    -3.188     0.200
     4.445    -3.487     0.200
     4.950    -4.902     0.200
     5.159    -4.213     0.200
     5.420    -6.108     0.200
     5.385    -3.875     0.200
     5.702    -1.026     0.200
     6.482    -5.648     0.200
     6.580    -5.559     0.200
     6.792    -6.786     0.200
     7.430    -4.921     0.200
     8.790    -7.330     0.200
     9.813    -7.454     0.200
     9.960    -9.512     0.200
    14.167   -12.841     0.200
    18.059    -2.195     0.200
     2.319    -2.290     0.200
     2.462    -1.713     0.200
     2.574    -2.855     0.200
     2.574    -3.455     0.200
     2.575    -1.817     0.200
     2.852    -3.098     0.200
     2.852    -2.997     0.200
     3.051    -2.101     0.200
     3.367    -2.625     0.200
     3.497    -1.629     0.200
     3.497    -3.829     0.200
     3.643    -4.055     0.200
     3.643    -4.755     0.200
     3.738    -4.070     0.200
     3.738    -2.070     0.200
     4.060    -3.490     0.200
     4.060    -4.590     0.200
     4.012    -2.170     0.200
     4.012    -2.970     0.200
     4.303    -4.490     0.200
     4.419    -3.268     0.200
     4.564    -5.151     0.200
     4.564    -5.951     0.200
     5.048    -4.188     0.200
     5.340    -4.287     0.200
     5.592    -4.128     0.200
     5.839    -5.785     0.200
     6.863    -5.023     0.200
     7.011    -6.010     0.200
     7.174    -5.486     0.200
     7.858    -4.573     0.200
     8.595    -5.846     0.200
     8.891    -6.916     0.200
    10.223    -7.353     0.200
    10.378    -9.149     0.200
    13.864    -9.085     0.200
    17.693    -7.418     0.200
     2.326    -1.993     0.200
     2.467    -2.261     0.200
     2.565    -2.080     0.200
     2.582    -1.814     0.200
     3.057    -2.484     0.200
     3.358    -3.120     0.200
     3.498    -2.855     0.200
     3.647    -4.596     0.200
     3.647    -3.295     0.200
     3.647    -0.596     0.200
     3.729    -2.670     0.200
     4.053    -4.240     0.200
     4.020    -1.714     0.200
     4.310    -4.692     0.200
     4.310    -2.094     0.200
     4.411    -2.695     0.200
     4.568    -5.584     0.200
     4.568    -2.787     0.200
     5.050    -3.257     0.200
     5.584    -4.173     0.200
     5.830    -5.081     0.200
     7.003    -5.169     0.200
     7.169    -6.341     0.200
     7.851    -6.942     0.200
     8.589    -6.135     0.200
     8.892    -6.153     0.200
    10.217    -6.663     0.200
    10.371    -9.344     0.200
     2.080     0.996     0.200
     2.269    -1.898     0.200
     2.618    -1.664     0.200
     2.696    -2.536     0.200
     3.010    -1.806     0.200
     3.116    -3.651     0.200
     3.116    -0.955     0.200
     2.039    -0.705     0.200
     2.103    -2.232     0.200
     2.260    -1.117     0.200
     2.781    -3.222     0.200
     2.916    -3.322     0.200
     3.034    -2.745     0.200
     3.270    -3.248     0.200
     3.283    -3.134     0.200
     3.504    -3.246     0.200
     3.590    -4.069     0.200
     3.948    -3.738     0.200
     4.070    -6.284     0.200
     4.070    -3.483     0.200
     4.348    -4.819     0.200
     4.484    -3.211     0.200
     4.986    -4.435     0.200
     5.120    -4.079     0.200
     5.384    -5.036     0.200
     5.417    -4.791     0.200
     6.541    -6.125     0.200
     6.757    -7.270     0.200
     2.240    -0.905     0.200
     2.248    -0.962     0.200
     2.557    -1.260     0.200
     2.641    -1.841     0.200
     2.761    -1.034     0.200
     2.895    -0.374     0.200
     3.043    -1.965     0.200
     3.347    -2.823     0.200
     3.366    -2.097     0.200
     3.729    -2.018     0.200
     3.936    -2.279     0.200
     4.086    -2.418     0.200
     4.347    -3.527     0.200
     4.345    -1.938     0.200
     4.854    -3.263     0.200
     5.259    -5.016     0.200
     5.296    -3.291     0.200
     5.513    -4.551     0.200
     6.561    -4.789     0.200
     6.681    -4.579     0.200
     6.887    -5.725     0.200
     8.275    -7.328     0.200
     2.428    -1.656     0.200
     2.426    -1.386     0.200
     2.528    -1.008     0.200
     2.644    -2.685     0.200
     2.675    -1.696     0.200
     3.141    -2.954     0.200
     3.141    -1.759     0.200
     3.189    -1.971     0.200
     3.563    -2.724     0.200
     3.570    -1.861     0.200
     3.699    -2.144     0.200
     3.935    -2.617     0.200
     4.149    -1.595     0.200
     4.479    -3.252     0.200
     4.615    -4.385     0.200
     5.052    -2.334     0.200
     5.459    -3.632     0.200
     5.663    -4.704     0.200
     6.661    -5.128     0.200
     6.889    -4.653     0.200
     7.128    -5.041     0.200
     7.746    -5.430     0.200
     8.498    -7.381     0.200
    10.286    -9.255     0.200
     2.272    -3.415     0.200
     2.234    -2.408     0.200
     2.273    -2.539     0.200
     2.609    -1.414     0.200
     2.602    -3.379     0.200
     2.831    -3.729     0.200
     2.914    -2.876     0.200
     3.265    -2.284     0.200
     3.301    -2.832     0.200
     3.738    -2.302     0.200
     3.812    -4.427     0.200
     3.883    -2.686     0.200
     4.085    -3.204     0.200
     4.370    -1.719     0.200
     4.634    -4.089     0.200
     4.962    -4.293     0.200
     4.940    -2.584     0.200
     5.305    -3.975     0.200
     5.380    -5.544     0.200
     5.901    -4.048     0.200
     6.286    -6.070     0.200
     6.758    -5.338     0.200
     7.182    -6.961     0.200
     8.427    -6.544     0.200
     8.685    -6.923     0.200
    10.225    -8.719     0.200
     2.265    -2.731     0.200
     2.202    -0.415     0.200
     2.487    -1.775     0.200
     2.755    -2.746     0.200
     2.876    -2.305     0.200
     3.131    -2.271     0.200
     2.961    -3.194     0.200
     2.961    -3.490     0.200
     3.124    -2.854     0.200
     3.363    -3.320     0.200
     3.483    -2.547     0.200
     3.585    -3.177     0.200
     3.820    -3.114     0.200
     4.123    -3.835     0.200
     4.520    -4.998     0.200
     5.006    -3.020     0.200
     5.034    -5.409     0.200
     5.226    -4.901     0.200
     5.802    -3.055     0.200
     5.919    -2.448     0.200
     5.948    -0.157     0.200
     6.438    -6.298     0.200
     6.727    -5.681     0.200
     7.298    -6.667     0.200
     8.057    -6.927     0.200
     8.167    -6.529     0.200
     9.847    -7.778     0.200
    13.997   -13.015     0.200
    14.082    -6.632     0.200
    17.918    -5.287     0.200
    18.117    -7.268     0.200
    18.664    -7.334     0.200
    20.180   -11.155     0.200
    20.917    -3.446     0.200
    23.643   -14.505     0.200
    24.373   -11.281     0.200
     2.217    -0.830     0.200
     2.251    -2.312     0.200
     2.405    -0.198     0.200
     2.503    -2.199     0.200
     2.739    -2.867     0.200
     2.892    -2.027     0.200
     2.976    -3.188     0.200
     3.140    -2.072     0.200
     3.357    -3.376     0.200
     3.467    -3.965     0.200
     3.601    -2.986     0.200
     3.804    -2.418     0.200
     4.138    -3.825     0.200
     4.523    -4.336     0.200
     4.618    -3.222     0.200
     4.990    -6.128     0.200
     5.049    -4.586     0.200
     5.210    -4.116     0.200
     5.438    -4.229     0.200
     6.422    -5.115     0.200
     6.714    -5.979     0.200
     8.041    -6.664     0.200
     9.832    -8.616     0.200
     2.265    -3.123     0.200
     2.265    -1.319     0.200
     2.481    -1.863     0.200
     2.758    -3.045     0.200
     2.869    -2.881     0.200
     2.953    -2.829     0.200
     3.134    -3.080     0.200
     3.117    -2.717     0.200
     3.373    -3.453     0.200
     3.490    -4.063     0.200
     3.577    -3.430     0.200
     3.825    -2.593     0.200
     4.115    -3.160     0.200
     4.528    -4.351     0.200
     4.596    -2.601     0.200
     5.012    -3.919     0.200
     5.025    -4.719     0.200
     5.230    -5.205     0.200
     5.415    -4.690     0.200
     6.268    -5.032     0.200
     6.445    -5.214     0.200
     6.737    -5.585     0.200
     8.065    -6.381     0.200
     2.251    -1.981     0.200
     2.251    -1.578     0.200
     2.110     0.210     0.200
     2.234    -1.117     0.200
     2.234    -0.515     0.200
     2.627    -1.790     0.200
     2.627    -2.290     0.200
     2.746    -2.148     0.200
     2.880    -2.515     0.200
     3.052    -2.443     0.200
     3.362    -2.896     0.200
     3.351    -2.630     0.200
     3.742    -3.240     0.200
     3.920    -3.683     0.200
     4.332    -2.728     0.200
     4.332    -1.630     0.200
     4.356    -4.709     0.200
     4.356    -4.908     0.200
     4.838    -5.066     0.200
     4.838    -3.566     0.200
     5.272    -4.823     0.200
     5.280    -4.777     0.200
     5.522    -5.447     0.200
     5.622    -0.836     0.200
     6.567    -5.778     0.200
     6.694    -5.207     0.200
     6.903    -5.432     0.200
     7.545    -5.689     0.200
     8.290    -5.487     0.200
     8.527    -5.904     0.200
     9.099    -6.845     0.200
    10.075    -8.186     0.200
    14.024    -6.288     0.200
    14.277    -8.186     0.200
    17.950    -5.253     0.200
    20.479   -10.972     0.200
     2.190    -2.019     0.200
     2.285    -0.540     0.200
     2.485    -3.065     0.200
     2.677    -0.967     0.200
     2.784    -2.854     0.200
     2.980    -2.687     0.200
     2.928    -1.431     0.200
     3.356    -4.493     0.200
     3.380    -2.642     0.200
     3.396    -2.449     0.200
     3.687    -3.088     0.200
     3.687    -4.188     0.200
     3.955    -3.080     0.200
     4.390    -2.363     0.200
     4.412    -2.680     0.200
     4.871    -4.003     0.200
     5.214    -4.804     0.200
     5.297    -4.434     0.200
     5.452    -5.925     0.200
     5.587    -3.701     0.200
     6.640    -6.196     0.200
     6.874    -5.823     0.200
     7.305    -5.364     0.200
     7.545    -6.170     0.200
     8.244    -7.130     0.200
     9.108    -6.230     0.200
     2.114    -0.313     0.200
     2.267    -1.688     0.200
     2.316    -2.024     0.200
     2.389    -1.359     0.200
     2.534    -2.232     0.200
     2.642    -2.959     0.200
     2.585    -1.150     0.200
     2.961    -2.485     0.200
     3.091    -1.505     0.200
     3.748    -2.120     0.200
     4.071    -4.670     0.200
     4.227    -2.412     0.200
     4.817    -4.110     0.200
     4.934    -5.221     0.200
     5.142    -2.900     0.200
     5.736    -3.146     0.200
     5.888    -5.168     0.200
     6.003    -5.995     0.200
     6.160    -4.080     0.200
     6.175    -3.671     0.200
     6.716    -6.698     0.200
     7.432    -7.322     0.200
     8.169    -6.157     0.200
     2.180    -2.627     0.200
     2.180    -1.225     0.200
     2.221    -0.730     0.200
     2.316    -1.229     0.200
     2.401    -2.133     0.200
     2.476    -0.888     0.200
     2.595     0.426     0.200
     2.712    -3.473     0.200
     2.686    -0.958     0.200
     2.863    -2.659     0.200
     3.158    -1.819     0.200
     3.811    -2.427     0.200
     4.195    -4.195     0.200
     4.861    -4.415     0.200
     5.799    -4.824     0.200
     5.778    -4.072     0.200
     5.967    -5.970     0.200
     6.194    -4.247     0.200
     2.217    -2.029     0.200
     2.217    -1.326     0.200
     2.241    -1.502     0.200
     2.375    -2.851     0.200
     2.375    -2.351     0.200
     2.625    -1.854     0.200
     2.625    -2.151     0.200
     2.686    -2.107     0.200
     2.686    -2.412     0.200
     2.867    -2.321     0.200
     2.941    -2.687     0.200
     2.941    -2.491     0.200
     3.323    -3.300     0.200
     3.320    -3.804     0.200
     3.320    -4.007     0.200
     3.320    -2.405     0.200
     3.617    -2.301     0.200
     3.740    -3.329     0.200
     3.740    -2.829     0.200
     3.842    -4.940     0.200
     3.842    -1.542     0.200
     4.054    -2.466     0.200
     4.368    -1.736     0.200
     4.368    -1.634     0.200
     4.659    -4.862     0.200
     4.659    -3.862     0.200
     4.750    -4.620     0.200
     4.750    -3.620     0.200
     5.132    -4.354     0.200
     5.132    -4.049     0.200
     5.254    -3.118     0.200
     5.415    -3.517     0.200
     5.727    -3.104     0.200
     5.823    -2.696     0.200
     6.393    -4.523     0.200
     6.694    -5.064     0.200
     7.184    -5.671     0.200
     7.368    -5.730     0.200
     8.415    -5.900     0.200
     8.921    -6.132     0.200
    13.802    -8.712     0.200
    14.223   -12.928     0.200
    18.482    -8.792     0.200
    20.301   -13.839     0.200
     2.194    -0.632     0.200
     2.331    -1.266     0.200
     2.449    -0.716     0.200
     2.683    -2.952     0.200
     2.914    -1.771     0.200
     2.923    -1.846     0.200
     3.459    -2.247     0.200
     3.511    -2.095     0.200
     3.615    -3.091     0.200
     3.838    -2.750     0.200
     3.897    -1.311     0.200
     4.178    -3.238     0.200
     4.368    -2.656     0.200
     4.432    -2.386     0.200
     4.917    -2.971     0.200
     5.199    -2.689     0.200
     5.707    -5.106     0.200
     5.933    -4.863     0.200
     6.863    -4.141     0.200
     7.130    -5.807     0.200
     7.306    -5.476     0.200
     8.277    -4.456     0.200
     8.763    -6.581     0.200
     2.209    -1.753     0.200
     2.263    -1.667     0.200
     2.263    -2.167     0.200
     2.448    -2.320     0.200
     2.635    -2.438     0.200
     2.635    -2.243     0.200
     2.704    -3.434     0.200
     2.704    -3.832     0.200
     2.898    -2.897     0.200
     2.898    -3.397     0.200
     3.327    -3.695     0.200
     3.421    -2.674     0.200
     3.421    -2.369     0.200
     3.712    -3.097     0.200
     3.896    -2.220     0.200
     3.964    -2.464     0.200
     4.162    -5.058     0.200
     4.162    -3.159     0.200
     4.331    -4.220     0.200
     4.331    -4.024     0.200
     4.467    -4.725     0.200
     4.735    -3.109     0.200
     5.490    -3.555     0.200
     5.559    -0.311     0.200
     5.673    -4.750     0.200
     6.719    -5.606     0.200
     6.765    -5.284     0.200
     7.115    -6.083     0.200
     7.425    -6.011     0.200
     7.988    -5.156     0.200
     8.520    -6.831     0.200
    10.545    -8.804     0.200
     2.424    -2.256     0.200
     2.575    -0.932     0.200
     2.575    -1.131     0.200
     2.640    -2.293     0.200
     2.640    -2.090     0.200
     2.817    -1.921     0.200
     2.992    -1.877     0.200
     2.992    -1.775     0.200
     3.272    -3.416     0.200
     3.375    -1.592     0.200
     3.630    -3.799     0.200
     3.630    -1.799     0.200
     3.789    -3.032     0.200
     3.797    -4.280     0.200
     4.105    -1.830     0.200
     4.317    -1.481     0.200
     4.646    -3.084     0.200
     5.096    -3.445     0.200
     5.304    -4.455     0.200
     5.467    -4.808     0.200
     5.683    -2.266     0.200
     5.777    -0.514     0.200
     6.743    -4.979     0.200
     7.058    -5.560     0.200
     8.269    -3.998     0.200
     8.426    -5.106     0.200
    15.352    -5.593     0.200
     2.282    -1.653     0.200
     2.419    -1.392     0.200
     2.537    -1.848     0.200
     2.601    -2.164     0.200
     2.855    -1.814     0.200
     3.012    -2.184     0.200
     3.385    -2.444     0.200
     3.546    -3.823     0.200
     3.599    -3.614     0.200
     3.981    -1.733     0.200
     4.092    -3.950     0.200
     4.341    -4.339     0.200
     4.520    -3.095     0.200
     5.000    -2.626     0.200
     2.576    -1.430     0.200
     2.640    -1.568     0.200
     2.640    -1.865     0.200
     2.818    -1.614     0.200
     2.990    -4.076     0.200
     2.990    -2.576     0.200
     3.272    -2.698     0.200
     3.373    -3.193     0.200
     3.633    -2.055     0.200
     3.788    -3.671     0.200
     3.788    -3.077     0.200
     4.319    -2.590     0.200
     4.319    -2.395     0.200
     4.650    -3.969     0.200
     4.650    -2.875     0.200
     4.706    -3.956     0.200
     5.095    -3.381     0.200
     5.303    -3.490     0.200
     5.465    -4.905     0.200
     5.686    -2.641     0.200
     5.780     0.143     0.200
     6.440    -4.814     0.200
     6.743    -5.223     0.200
     7.140    -6.013     0.200
     8.268    -4.771     0.200
     8.272    -3.082     0.200
     8.429    -5.465     0.200
    10.168    -7.119     0.200
    13.776    -7.594     0.200
    14.272   -10.747     0.200
    18.503    -8.578     0.200
    20.347   -11.306     0.200
     2.018     0.228     0.200
     2.199    -0.823     0.200
     2.259    -1.811     0.200
     2.408    -3.348     0.200
     2.582    -2.162     0.200
     2.644    -2.413     0.200
     2.824    -2.530     0.200
     2.980    -3.077     0.200
     3.278    -3.505     0.200
     3.363    -2.201     0.200
     3.642    -1.341     0.200
     4.327    -2.171     0.200
     4.663    -2.924     0.200
     4.708    -4.447     0.200
     5.297    -3.305     0.200
     5.454    -5.407     0.200
     2.020    -0.291     0.200
     2.125    -1.339     0.200
     2.362    -2.536     0.200
     2.362    -0.938     0.200
     2.465    -2.112     0.200
     2.465    -1.713     0.200
     2.755    -1.106     0.200
     2.870    -2.846     0.200
     2.870    -2.948     0.200
     2.935    -2.801     0.200
     3.008    -2.422     0.200
     3.008    -1.821     0.200
     3.292    -2.414     0.200
     3.292    -2.914     0.200
     3.308    -1.622     0.200
     3.308    -1.521     0.200
     3.478    -4.318     0.200
     3.478    -3.412     0.200
     3.478    -2.111     0.200
     3.614    -3.333     0.200
     3.614    -3.134     0.200
     3.971    -2.248     0.200
     4.043    -3.933     0.200
     4.043    -3.433     0.200
     4.357    -2.287     0.200
     4.960    -3.881     0.200
     5.144    -2.728     0.200
     5.601    -2.420     0.200
     5.720    -3.712     0.200
     6.784    -4.805     0.200
     7.417    -4.183     0.200
     7.393    -5.234     0.200
     7.638    -5.599     0.200
     7.930    -6.560     0.200
     8.087    -5.530     0.200
     8.162    -6.206     0.200
     8.606    -5.085     0.200
     8.796    -7.202     0.200
    14.151   -12.198     0.200
    14.111    -7.718     0.200
    17.752    -4.778     0.200
    17.855    -7.852     0.200
    18.664    -7.170     0.200
    18.751   -10.363     0.200
     2.039    -0.029     0.200
     2.233    -1.563     0.200
     2.226    -1.440     0.200
     2.388    -2.377     0.200
     2.609    -2.285     0.200
     2.670    -2.640     0.200
     2.956    -2.691     0.200
     2.851    -2.355     0.200
     3.338    -3.105     0.200
     3.304    -4.445     0.200
     3.626    -2.440     0.200
     3.626    -1.640     0.200
     3.756    -3.769     0.200
     4.353    -2.478     0.200
     4.661    -3.447     0.200
     4.661    -4.345     0.200
     4.734    -4.355     0.200
     5.118    -4.120     0.200
     5.270    -3.856     0.200
     5.430    -5.621     0.200
     5.812    -4.902     0.200
     8.266    -4.953     0.200
    13.790   -12.146     0.200
     2.019    -0.895     0.200
     2.455    -1.329     0.200
     2.528    -1.651     0.200
     2.664    -2.942     0.200
     2.701    -2.136     0.200
     3.133    -3.035     0.200
     3.232    -2.748     0.200
     3.521    -2.319     0.200
     3.610    -3.332     0.200
     3.954    -2.638     0.200
     4.123    -2.206     0.200
     4.406    -3.367     0.200
     4.622    -4.723     0.200
     5.075    -4.378     0.200
     2.071    -1.368     0.200
     2.179    -1.091     0.200
     2.320    -1.478     0.200
     2.779    -2.213     0.200
     2.787    -2.820     0.200
     2.929    -2.871     0.200
     3.354    -3.561     0.200
     3.517    -3.120     0.200
     3.803    -1.097     0.200
     3.799    -1.351     0.200
     3.899    -3.145     0.200
     4.289    -2.101     0.200
     4.273    -3.984     0.200
     4.530    -3.520     0.200
     4.621    -3.022     0.200
     4.740    -3.681     0.200
     5.309    -2.307     0.200
     8.407    -4.943     0.200
    13.556    -7.999     0.200
     2.211    -0.801     0.200
     2.321    -1.208     0.200
     2.461    -1.039     0.200
     2.644    -1.839     0.200
     2.829    -2.403     0.200
     2.929    -2.416     0.200
     2.929    -2.064     0.200
     3.396    -1.889     0.200
     3.497    -1.969     0.200
     3.690    -2.601     0.200
     3.777    -2.759     0.200
     3.933    -2.084     0.200
     4.151    -2.505     0.200
     4.415    -2.677     0.200
     4.488    -2.685     0.200
     4.875    -3.149     0.200
     5.385    -2.156     0.200
     8.303    -3.946     0.200
    15.500    -9.492     0.200
     2.070    -2.270     0.200
     2.118    -0.893     0.200
     2.334    -2.417     0.200
     2.391    -1.524     0.200
     2.779    -2.245     0.200
     2.841    -2.905     0.200
     2.864    -2.441     0.200
     3.027    -2.687     0.200
     3.219    -3.569     0.200
     3.417    -3.058     0.200
     3.488    -1.912     0.200
     3.580    -3.929     0.200
     3.915    -2.528     0.200
     4.028    -2.717     0.200
     4.523    -3.923     0.200
     4.506    -3.082     0.200
     4.939    -4.409     0.200
     5.314    -5.193     0.200
     5.336    -4.104     0.200
     2.093     0.332     0.200
     2.237    -0.730     0.200
     2.275    -1.847     0.200
     2.631    -2.314     0.200
     2.632    -2.167     0.200
     2.769    -1.509     0.200
     2.889    -1.188     0.200
     3.097    -2.601     0.200
     3.281    -3.030     0.200
     3.364    -4.758     0.200
     3.364    -1.851     0.200
     3.469    -2.288     0.200
     4.120    -1.722     0.200
     4.255    -3.303     0.200
     4.321    -2.489     0.200
     4.868    -4.530     0.200
     5.285    -3.352     0.200
     5.329    -3.449     0.200
     5.436    -3.233     0.200
     7.912    -7.969     0.200
     2.054    -1.922     0.200
     2.054     0.479     0.200
     2.209     0.058     0.200
     2.359    -1.487     0.200
     2.604    -0.956     0.200
     2.762    -1.861     0.200
     2.999    -1.671     0.200
     3.095    -3.035     0.200
     3.128    -1.658     0.200
     3.121    -0.863     0.200
     3.253    -2.143     0.200
     3.382    -3.231     0.200
     3.756    -3.767     0.200
     3.726    -2.313     0.200
     4.283    -3.973     0.200
     4.295    -2.577     0.200
     4.691    -2.603     0.200
     4.916    -4.050     0.200
     5.219    -5.264     0.200
     5.212    -4.135     0.200
     2.027    -0.776     0.200
     2.063    -2.021     0.200
     2.297    -2.233     0.200
     2.301    -0.988     0.200
     2.341    -1.449     0.200
     2.534    -1.571     0.200
     2.759    -1.089     0.200
     2.794    -2.509     0.200
     3.197    -2.078     0.200
     3.847    -3.294     0.200
     4.310    -3.557     0.200
     4.337    -4.308     0.200
     4.715    -4.989     0.200
     4.879    -5.414     0.200
     2.255    -1.254     0.200
     2.400    -1.536     0.200
     2.512    -1.784     0.200
     2.635    -2.596     0.200
     2.897    -2.188     0.200
     2.988    -2.176     0.200
     3.425    -3.216     0.200
     3.541    -2.596     0.200
     3.582    -3.395     0.200
     3.582    -2.096     0.200
     3.949    -1.151     0.200
     4.313    -5.583     0.200
     4.313    -3.983     0.200
     4.481    -3.209     0.200
     4.503    -4.701     0.200
     4.503    -3.402     0.200
     4.992    -2.611     0.200
     5.201    -2.321     0.200
     2.218    -1.664     0.200
     2.329    -1.265     0.200
     2.469    -1.902     0.200
     2.636    -2.006     0.200
     2.823    -2.815     0.200
     2.937    -2.626     0.200
     3.389    -2.568     0.200
     3.504    -3.125     0.200
     3.685    -2.447     0.200
     3.940    -1.546     0.200
     4.038    -3.239     0.200
     4.143    -3.372     0.200
     4.422    -3.828     0.200
     4.480    -2.755     0.200
     4.480    -3.162     0.200
     4.881    -3.880     0.200
     5.307    -3.258     0.200
     2.227    -1.746     0.200
     2.227    -1.945     0.200
     2.137    -1.086     0.200
     2.272    -1.457     0.200
     2.570    -2.519     0.200
     2.666    -1.667     0.200
     2.794    -3.297     0.200
     2.794    -2.397     0.200
     2.921    -2.941     0.200
     2.921    -1.441     0.200
     3.042    -3.171     0.200
     3.298    -3.889     0.200
     3.415    -4.281     0.200
     3.394    -3.337     0.200
     3.394    -1.630     0.200
     3.710    -3.147     0.200
     4.073    -2.944     0.200
     3.970    -2.396     0.200
     4.302    -3.430     0.200
     4.363    -2.941     0.200
     5.242    -4.399     0.200
     5.497    -2.891     0.200
     5.510    -5.095     0.200
     6.660    -6.564     0.200
     6.851    -6.604     0.200
     7.932    -7.033     0.200
    14.087    -6.481     0.200
    15.061   -11.005     0.200
    18.823   -10.268     0.200
    20.482   -13.114     0.200
     2.122    -2.137     0.200
     2.150    -2.215     0.200
     2.150    -2.012     0.200
     2.354    -2.485     0.200
     2.354    -2.384     0.200
     2.740    -2.702     0.200
     2.735    -3.451     0.200
     2.795    -3.772     0.200
     3.298    -2.409     0.200
     3.396    -3.303     0.200
     3.782    -2.855     0.200
     3.836    -3.781     0.200
     3.889    -3.328     0.200
     3.889    -3.524     0.200
     4.047    -2.266     0.200
     4.047    -2.368     0.200
     4.268    -3.967     0.200
     4.204    -4.534     0.200
     4.558    -4.362     0.200
     4.595    -3.230     0.200
     4.859    -3.604     0.200
     5.517    -2.354     0.200
     2.191    -1.850     0.200
     2.303    -0.415     0.200
     2.532    -2.266     0.200
     2.698    -1.410     0.200
     2.820    -1.893     0.200
     2.952    -2.462     0.200
     3.003    -2.709     0.200
     3.297    -2.508     0.200
     3.423    -2.414     0.200
     3.676    -3.231     0.200
     3.995    -2.252     0.200
     4.036    -2.159     0.200
     4.323    -3.944     0.200
     4.397    -2.685     0.200
     4.913    -3.240     0.200
     5.207    -4.856     0.200
     5.355    -3.264     0.200
     2.280    -1.948     0.200
     2.423    -1.475     0.200
     2.536    -2.071     0.200
     2.610    -2.325     0.200
     2.875    -2.219     0.200
     3.012    -1.853     0.200
     3.400    -2.574     0.200
     3.974    -1.769     0.200
     4.134    -2.936     0.200
     4.314    -3.539     0.200
     4.525    -5.521     0.200
     4.525    -3.724     0.200
     5.011    -3.335     0.200
     5.220    -3.555     0.200
     2.171    -1.106     0.200
     2.307    -2.639     0.200
     2.589    -3.066     0.200
     2.563    -1.358     0.200
     2.678    -2.086     0.200
     2.816    -2.255     0.200
     3.096    -3.143     0.200
     3.285    -1.934     0.200
     3.423    -3.325     0.200
     3.852    -3.001     0.200
     4.273    -3.252     0.200
     4.386    -2.638     0.200
     4.769    -4.074     0.200
     5.210    -4.068     0.200
     5.331    -4.296     0.200
     5.488    -3.466     0.200
     2.142    -0.613     0.200
     2.261    -1.292     0.200
     2.266    -0.943     0.200
     2.488    -2.290     0.200
     2.609    -2.032     0.200
     2.686    -3.457     0.200
     3.356    -2.599     0.200
     3.495    -2.209     0.200
     3.753    -2.899     0.200
     4.127    -3.455     0.200
     4.231    -3.535     0.200
     4.477    -3.332     0.200
     4.814    -3.521     0.200
     5.732    -4.224     0.200
     2.196    -1.899     0.200
     2.334    -1.804     0.200
     2.451    -2.194     0.200
     2.684    -1.490     0.200
     2.920    -2.454     0.200
     2.926    -2.741     0.200
     3.462    -3.058     0.200
     3.516    -2.540     0.200
     3.516    -0.841     0.200
     3.607    -1.831     0.200
     3.896    -2.518     0.200
     4.046    -3.063     0.200
     4.178    -3.241     0.200
     4.358    -3.332     0.200
     4.437    -3.339     0.200
     4.924    -2.889     0.200
     5.191    -3.667     0.200
     2.092    -2.214     0.200
     2.092    -1.910     0.200
     2.333    -2.961     0.200
     2.333    -3.156     0.200
     2.309    -1.485     0.200
     2.497    -1.057     0.200
     2.608    -0.253     0.200
     2.680    -3.235     0.200
     2.721    -0.541     0.200
     2.793    -2.837     0.200
     2.793    -4.337     0.200
     2.836    -3.705     0.200
     3.010    -0.811     0.200
     3.163    -1.562     0.200
     3.163    -1.859     0.200
     3.235    -2.545     0.200
     3.558    -2.690     0.200
     3.678    -2.389     0.200
     3.813    -3.072     0.200
     4.289    -5.040     0.200
     4.289    -4.845     0.200
     4.286    -3.445     0.200
     4.374    -4.442     0.200
     4.753    -5.348     0.200
     4.849    -4.897     0.200
     6.146    -3.724     0.200
     6.262    -2.943     0.200
     7.416    -4.030     0.200
    14.774    -5.944     0.200
     2.190    -1.745     0.200
     2.276    -2.090     0.200
     2.276    -0.891     0.200
     2.456    -1.870     0.200
     2.667    -1.066     0.200
     2.764    -0.841     0.200
     2.916    -3.471     0.200
     2.916    -2.172     0.200
     2.967    -3.071     0.200
     3.381    -3.802     0.200
     3.381    -2.302     0.200
     3.431    -2.978     0.200
     3.694    -3.132     0.200
     3.932    -5.573     0.200
     3.932    -3.173     0.200
     4.387    -3.707     0.200
     4.468    -4.553     0.200
     4.468    -2.861     0.200
     4.846    -4.148     0.200
     5.219    -5.267     0.200
     5.263    -2.866     0.200
     2.269    -1.490     0.200
     2.361    -0.688     0.200
     2.516    -2.218     0.200
     2.576    -2.221     0.200
     2.734    -2.929     0.200
     2.979    -1.974     0.200
     3.313    -3.378     0.200
     3.530    -2.970     0.200
     3.717    -2.094     0.200
     4.002    -1.934     0.200
     4.090    -3.020     0.200
     4.418    -4.196     0.200
     4.446    -3.291     0.200
     4.557    -2.807     0.200
     4.883    -4.255     0.200
     2.193    -1.939     0.200
     2.193    -1.439     0.200
     2.299    -1.775     0.200
     2.299    -1.474     0.200
     2.443    -1.846     0.200
     2.443    -1.244     0.200
     2.657    -2.342     0.200
     2.657    -2.542     0.200
     2.828    -3.144     0.200
     2.909    -2.327     0.200
     3.403    -2.371     0.200
     3.403    -3.172     0.200
     3.721    -1.177     0.200
     3.721    -3.973     0.200
     3.784    -2.566     0.200
     3.920    -1.758     0.200
     4.007    -2.125     0.200
     4.167    -3.496     0.200
     4.391    -3.588     0.200
     4.500    -3.264     0.200
     4.510    -4.574     0.200
     4.846    -3.935     0.200
     5.311    -3.372     0.200
     5.392    -1.456     0.200
     7.020    -5.329     0.200
     8.334    -5.326     0.200
     2.217    -2.622     0.200
     2.217    -1.821     0.200
     2.261    -3.034     0.200
     2.173    -0.242     0.200
     2.270    -1.316     0.200
     2.270    -1.915     0.200
     2.643    -2.431     0.200
     2.643    -2.031     0.200
     2.665    -2.913     0.200
     2.665    -1.112     0.200
     2.881    -2.571     0.200
     2.881    -2.372     0.200
     2.876    -3.302     0.200
     3.267    -2.697     0.200
     3.315    -2.630     0.200
     3.753    -4.132     0.200
     3.753    -3.532     0.200
     3.797    -2.602     0.200
     3.797    -2.402     0.200
     3.801    -3.324     0.200
     3.801    -5.623     0.200
     3.801    -2.523     0.200
     4.037    -2.524     0.200
     4.340    -3.712     0.200
     4.406    -2.405     0.200
     4.699    -3.811     0.200
     4.869    -2.302     0.200
     4.869    -4.302     0.200
     5.253    -4.353     0.200
     5.350    -4.756     0.200
     5.882    -3.512     0.200
     5.967    -4.590     0.200
     6.451    -5.319     0.200
     7.105    -4.589     0.200
     8.439    -5.106     0.200
    13.650    -9.874     0.200
    18.244    -9.455     0.200
     2.186    -1.851     0.200
     2.284    -2.162     0.200
     2.434    -1.813     0.200
     2.661    -2.495     0.200
     2.816    -3.307     0.200
     2.898    -1.556     0.200
     2.898    -2.324     0.200
     3.399    -3.381     0.200
     3.457    -1.530     0.200
     3.751    -2.864     0.200
     3.781    -3.695     0.200
     3.917    -2.326     0.200
     3.991    -3.075     0.200
     4.173    -3.844     0.200
     4.374    -3.793     0.200
     4.543    -3.273     0.200
     4.503    -3.683     0.200
     4.823    -3.948     0.200
     5.332    -3.563     0.200
     5.411    -3.060     0.200
     7.008    -4.615     0.200
     8.365    -6.334     0.200
    13.612    -8.246     0.200
     2.079    -2.033     0.200
     2.106    -0.770     0.200
     2.348    -2.349     0.200
     2.383    -0.359     0.200
     2.772    -0.596     0.200
     2.853    -2.361     0.200
     2.860    -1.070     0.200
     3.020    -1.951     0.200
     3.409    -3.693     0.200
     3.482    -1.996     0.200
     3.588    -3.145     0.200
     4.024    -2.775     0.200
     4.497    -2.781     0.200
     4.510    -2.674     0.200
     4.561    -3.790     0.200
     4.936    -3.881     0.200
     5.110    -4.520     0.200
     5.326    -4.743     0.200
     5.336    -4.277     0.200
     2.065    -1.572     0.200
     2.120    -0.007     0.200
     2.335    -2.317     0.200
     2.300     0.364     0.200
     2.397    -1.493     0.200
     2.839    -1.697     0.200
     2.839    -1.893     0.200
     2.786    -1.426     0.200
     2.873    -2.671     0.200
     3.034    -2.378     0.200
     3.216    -3.050     0.200
     3.406    -3.468     0.200
     3.406    -3.765     0.200
     3.574    -3.090     0.200
     3.495    -4.345     0.200
     3.495    -3.313     0.200
     3.909    -2.436     0.200
     4.036    -3.257     0.200
     4.514    -4.001     0.200
     4.514    -5.001     0.200
     4.512    -1.319     0.200
     4.573    -4.680     0.200
     4.948    -4.858     0.200
     5.096    -5.859     0.200
     5.311    -4.579     0.200
     5.736    -3.142     0.200
     5.848    -2.654     0.200
     6.809    -5.164     0.200
     2.401    -1.960     0.200
     2.451    -1.635     0.200
     2.550    -1.160     0.200
     2.700    -1.429     0.200
     3.161    -2.535     0.200
     3.165    -2.564     0.200
     3.565    -2.655     0.200
     3.720    -4.965     0.200
     3.720    -1.262     0.200
     3.909    -2.162     0.200
     4.175    -1.791     0.200
     4.245    -2.814     0.200
     2.006    -0.789     0.200
     2.110    -0.996     0.200
     2.602    -2.883     0.200
     2.502    -1.705     0.200
     2.608    -1.961     0.200
     2.752    -1.547     0.200
     3.130    -2.221     0.200
     3.219    -3.574     0.200
     3.219    -2.246     0.200
     3.501    -2.482     0.200
     3.860    -2.572     0.200
     3.780    -2.413     0.200
     5.586    -3.498     0.200
     6.794    -4.452     0.200
     8.132    -6.250     0.200
    13.879    -9.944     0.200
    18.416    -3.792     0.200
    18.721    -9.790     0.200
    20.527   -11.386     0.200
     2.502    -1.816     0.200
     2.534    -1.927     0.200
     2.649    -1.595     0.200
     2.793    -2.354     0.200
     3.125    -3.674     0.200
     3.125    -2.467     0.200
     3.301    -2.762     0.200
     3.447    -2.185     0.200
     3.677    -2.763     0.200
     3.987    -3.195     0.200
     5.392    -3.145     0.200
     6.984    -4.067     0.200
     8.063    -3.040     0.200
    13.916    -9.610     0.200
     2.211    -2.287     0.200
     2.211    -1.885     0.200
     2.323    -3.256     0.200
     2.323    -2.358     0.200
     2.462    -2.240     0.200
     2.645    -2.060     0.200
     2.834    -2.442     0.200
     2.930    -3.435     0.200
     2.930    -2.478     0.200
     3.399    -2.668     0.200
     3.499    -3.731     0.200
     3.499    -1.833     0.200
     3.683    -4.663     0.200
     4.151    -2.998     0.200
     4.473    -3.186     0.200
     5.379    -2.416     0.200
     7.027    -4.524     0.200
     8.295    -3.117     0.200
    13.679    -9.921     0.200
     2.037    -0.270     0.200
     2.218    -0.833     0.200
     2.375    -0.388     0.200
     2.391    -2.003     0.200
     2.510    -0.183     0.200
     2.626    -3.260     0.200
     2.626    -2.061     0.200
     2.616    -3.153     0.200
     3.036    -3.564     0.200
     3.036    -3.064     0.200
     3.588    -2.854     0.200
     2.045    -0.830     0.200
     2.200    -1.033     0.200
     2.382    -2.984     0.200
     2.580    -2.389     0.200
     2.631    -2.594     0.200
     2.820    -2.976     0.200
     2.968    -3.683     0.200
     3.692    -3.029     0.200
     3.791    -4.151     0.200
     5.828    -5.265     0.200
     6.575    -5.403     0.200
     8.332    -6.365     0.200
    13.726    -8.824     0.200
     2.205    -0.942     0.200
     2.322    -1.559     0.200
     2.457    -1.421     0.200
     2.654    -1.894     0.200
     2.851    -2.424     0.200
     2.926    -2.502     0.200
     3.413    -2.934     0.200
     3.499    -4.870     0.200
     3.499    -1.573     0.200
     3.499     0.029     0.200
     3.922    -1.486     0.200
     5.360    -2.795     0.200
     8.282    -5.455     0.200
    13.690    -7.159     0.200
     2.247    -2.433     0.200
     2.227    -1.395     0.200
     2.620    -3.531     0.200
     2.620    -1.726     0.200
     2.871    -2.301     0.200
     2.199    -0.444     0.200
     2.320    -0.853     0.200
     2.452    -1.341     0.200
     2.662    -1.803     0.200
     2.863    -2.667     0.200
     2.922    -1.640     0.200
     3.422    -2.414     0.200
     3.497    -2.082     0.200
     3.666    -3.540     0.200
     3.915    -1.328     0.200
     4.165    -2.743     0.200
     4.442    -3.125     0.200
     5.347    -3.870     0.200
     7.056    -3.865     0.200
     8.275    -3.249     0.200
    13.695    -6.090     0.200
     2.258    -2.687     0.200
     2.520    -2.806     0.200
     2.602    -1.495     0.200
     2.852    -2.325     0.200
     3.036    -2.743     0.200
     3.760    -3.011     0.200
     2.289    -1.704     0.200
     2.432    -1.448     0.200
     2.545    -1.932     0.200
     2.602    -2.039     0.200
     2.871    -2.546     0.200
     3.021    -3.121     0.200
     3.021    -1.418     0.200
     3.394    -2.632     0.200
     3.518    -2.468     0.200
     3.614    -5.100     0.200
     3.614    -1.498     0.200
     4.309    -3.427     0.200
     5.320    -1.330     0.200
     7.063    -4.317     0.200
    15.340    -7.996     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.695     0.496     0.200
     1.823    -1.255     0.200
     2.552    -9.083     0.200
     3.014   -11.034     0.200
     3.621   -17.148     0.200
     3.661   -16.937     0.200
     4.862   -27.988     0.200
     5.041   -27.179     0.200
     1.902    -3.877     0.200
     3.245   -13.158     0.200
     3.350   -14.582     0.200
    13.284   -87.882     0.200
    13.492   -93.963     0.200
    15.011   -97.140     0.200
    15.732  -102.982     0.200
    16.332  -104.004     0.200
    17.884  -119.192     0.200
    18.126  -120.885     0.200
     2.728   -10.117     0.200
     2.752   -10.260     0.200
     3.227   -12.333     0.200
     3.876   -17.894     0.200
     1.163     2.814     0.200
     1.605    -0.783     0.200
     2.391    -8.319     0.200
     2.507    -7.976     0.200
     2.504    -8.408     0.200
     3.142   -13.527     0.200
     3.662   -14.591     0.200
     3.744   -20.387     0.200
     4.570   -21.579     0.200
     4.702   -28.282     0.200
     1.359    -0.003     0.200
     1.654    -1.373     0.200
     2.207    -7.285     0.200
     2.657   -11.141     0.200
     4.044   -23.507     0.200
     1.462    -0.739     0.200
     2.557   -10.334     0.200
     2.642   -10.918     0.200
     2.976   -11.919     0.200
     3.254   -14.617     0.200
     4.723   -30.201     0.200
     2.261    -6.833     0.200
     2.641   -13.457     0.200
     2.723   -10.762     0.200
     2.894   -10.689     0.200
     3.338   -15.878     0.200
     3.881   -23.180     0.200
     4.166   -22.128     0.200
     4.332   -21.781     0.200
     4.713   -29.248     0.200
     1.429     0.549     0.200
     1.477    -0.750     0.200
     2.675   -11.033     0.200
     2.934   -14.952     0.200
     3.292   -14.298     0.200
     3.456   -17.185     0.200
     3.876   -19.800     0.200
     3.999   -20.715     0.200
     4.126   -22.437     0.200
     4.365   -22.721     0.200
     4.442   -22.949     0.200
     4.733   -28.669     0.200
     4.769   -26.920     0.200
     5.763   -33.930     0.200
     2.299    -5.913     0.200
     2.911   -10.495     0.200
     3.391   -16.223     0.200
     3.670   -19.378     0.200
     4.117   -21.718     0.200
     4.450   -25.699     0.200
     4.848   -28.799     0.200
     5.766   -30.805     0.200
     5.975   -35.415     0.200
     6.196   -32.936     0.200
     6.309   -36.817     0.200
     7.463   -48.405     0.200
     2.979   -10.171     0.200
     3.767   -16.761     0.200
     4.855   -22.135     0.200
     2.282    -5.623     0.200
     2.570    -6.868     0.200
     2.701   -11.201     0.200
     3.071   -13.843     0.200
     3.413   -14.789     0.200
     3.874   -19.800     0.200
     4.298   -22.639     0.200
     4.393   -22.853     0.200
     5.229   -27.458     0.200
     1.916    -0.035     0.200
     3.717   -17.327     0.200
     4.330   -23.957     0.200
     1.443     1.765     0.200
     1.770     1.198     0.200
     2.537    -6.913     0.200
     2.665    -7.965     0.200
     3.004    -8.999     0.200
     3.256   -14.483     0.200
     3.540   -15.201     0.200
     4.637   -26.479     0.200
     4.870   -25.244     0.200
     1.818     0.541     0.200
     2.345    -7.460     0.200
     2.637    -8.333     0.200
     2.637    -7.930     0.200
     2.532    -8.295     0.200
     3.418   -14.379     0.200
     3.829   -18.810     0.200
     4.360   -23.127     0.200
     4.360   -23.228     0.200
     4.747   -21.215     0.200
     5.197   -25.485     0.200
     1.377     0.521     0.200
     2.713   -10.210     0.200
     3.063   -12.620     0.200
     4.995   -23.274     0.200
     5.270   -28.174     0.200
     1.509     3.082     0.200
     1.614     0.754     0.200
     2.573    -6.942     0.200
     2.737    -8.647     0.200
     2.737    -8.749     0.200
     3.193   -13.998     0.200
     3.262   -12.492     0.200
     3.827   -17.915     0.200
     4.181   -20.043     0.200
     4.181   -20.942     0.200
     5.310   -27.722     0.200
     6.909   -41.218     0.200
     1.375     0.824     0.200
     1.719     0.734     0.200
     1.809     0.477     0.200
     2.127    -3.821     0.200
     2.353    -5.360     0.200
     2.717    -9.512     0.200
     3.421   -12.526     0.200
     3.643   -18.273     0.200
     4.576   -25.628     0.200
     4.864   -25.370     0.200
     5.256   -25.294     0.200
     1.804    -0.534     0.200
     2.368    -7.620     0.200
     2.503    -6.877     0.200
     2.644    -8.661     0.200
     3.155   -12.140     0.200
     3.454   -15.216     0.200
     3.864   -16.933     0.200
     4.384   -22.221     0.200
     5.161   -26.652     0.200
     7.027   -40.984     0.200
     1.467     0.358     0.200
     1.741    -1.017     0.200
     1.782    -0.329     0.200
     2.718    -9.699     0.200
     1.314     2.291     0.200
     1.582     0.191     0.200
     1.621     1.061     0.200
     1.621     0.163     0.200
     1.650     0.731     0.200
     1.882    -0.511     0.200
     2.218    -6.073     0.200
     2.569    -9.301     0.200
     2.569    -6.301     0.200
     2.574    -7.133     0.200
     2.574    -8.133     0.200
     2.683    -9.116     0.200
     4.138   -21.523     0.200
     4.165   -21.785     0.200
     4.287   -21.133     0.200
     4.411   -24.491     0.200
     4.411   -23.694     0.200
     4.773   -24.144     0.200
     5.209   -26.967     0.200
     5.549   -29.948     0.200
     7.459   -43.595     0.200
     8.222   -54.500     0.200
    13.963   -88.232     0.200
     1.395     0.603     0.200
     1.664    -1.741     0.200
     1.734     1.745     0.200
     2.209    -6.198     0.200
     2.500    -7.547     0.200
     2.657    -9.898     0.200
     3.375   -16.272     0.200
     5.277   -28.276     0.200
     1.429     0.124     0.200
     1.469    -0.550     0.200
     2.203    -8.005     0.200
     3.102   -15.495     0.200
     1.835    -0.143     0.200
     1.135     1.787     0.200
     1.203     0.424     0.200
     1.452     0.052     0.200
     1.452    -0.147     0.200
     1.662    -0.832     0.200
     2.203    -6.561     0.200
     2.561    -8.616     0.200
     2.695   -11.653     0.200
     4.918   -24.626     0.200
     6.821   -40.276     0.200
     1.539    -1.355     0.200
     1.842    -0.956     0.200
     2.753   -13.036     0.200
     3.059   -14.855     0.200
     4.025   -20.860     0.200
     1.700    -0.843     0.200
     1.701    -0.567     0.200
     1.715    -1.200     0.200
     1.353     1.184     0.200
     1.890     0.257     0.200
     2.269    -7.071     0.200
     2.269    -6.871     0.200
     2.573    -8.897     0.200
     2.573    -8.796     0.200
     2.606    -8.448     0.200
     2.606    -8.347     0.200
     3.065   -12.204     0.200
     3.384   -13.693     0.200
     4.368   -22.915     0.200
     4.368   -22.415     0.200
     5.256   -27.259     0.200
     5.536   -29.630     0.200
     1.463    -0.132     0.200
     1.821    -2.587     0.200
     2.370    -7.178     0.200
     2.529    -9.337     0.200
     2.622    -9.181     0.200
     3.004   -12.695     0.200
     3.527   -15.063     0.200
     3.822   -21.427     0.200
     4.056   -21.926     0.200
     4.437   -21.996     0.200
     4.837   -25.203     0.200
     1.243     1.033     0.200
     1.793    -1.502     0.200
     2.754    -9.379     0.200
     3.462   -15.330     0.200
     5.312   -26.455     0.200
     1.642    -1.120     0.200
     1.642    -0.823     0.200
     1.785    -0.257     0.200
     1.820     0.258     0.200
     2.175    -6.602     0.200
     2.715    -9.524     0.200
     3.399   -16.218     0.200
     3.399   -16.617     0.200
     4.136   -22.888     0.200
     4.136   -20.592     0.200
     4.724   -23.719     0.200
     5.643   -30.544     0.200
     6.096   -35.409     0.200
     6.082   -35.654     0.200
     1.710    -1.996     0.200
     1.710    -1.195     0.200
     1.687     0.029     0.200
     1.695     0.879     0.200
     2.612    -9.984     0.200
     2.855   -11.601     0.200
     3.139   -12.710     0.200
     3.269   -15.121     0.200
     3.405   -15.033     0.200
     5.499   -29.916     0.200
     5.930   -33.483     0.200
     5.930   -33.080     0.200
     1.492    -0.586     0.200
     1.492    -0.687     0.200
     2.643   -12.754     0.200
     2.314    -6.046     0.200
     2.569    -9.826     0.200
     3.526   -15.581     0.200
     4.340   -21.966     0.200
     1.498    -1.124     0.200
     1.522     0.305     0.200
     1.499     1.595     0.200
     2.073    -4.700     0.200
     2.332    -6.021     0.200
     2.840   -10.012     0.200
     2.775    -8.868     0.200
     4.536   -24.191     0.200
     4.536   -24.589     0.200
     4.931   -22.717     0.200
     4.931   -22.514     0.200
     5.327   -27.744     0.200
     5.855   -28.527     0.200
    16.406  -111.255     0.200
    17.743  -117.627     0.200
     1.624     0.916     0.200
     1.900     0.268     0.200
     1.900     0.868     0.200
     1.944     2.490     0.200
     2.506    -6.245     0.200
     2.831   -10.245     0.200
     2.831    -9.146     0.200
     2.879    -8.867     0.200
     2.879    -9.766     0.200
     2.993   -11.795     0.200
     2.993   -11.595     0.200
     3.196   -12.400     0.200
     3.213   -12.763     0.200
     3.492   -13.300     0.200
     3.602   -15.182     0.200
     4.166   -17.853     0.200
     4.345   -21.443     0.200
     4.581   -25.721     0.200
     5.082   -24.285     0.200
     5.082   -24.986     0.200
     5.506   -27.029     0.200
     6.663   -38.629     0.200
    12.722   -77.790     0.200
    14.925   -96.026     0.200
    15.028  -102.903     0.200
     1.852     0.164     0.200
     2.833    -9.822     0.200
     2.871   -10.029     0.200
     3.227   -13.816     0.200
     3.227   -13.117     0.200
     5.071   -22.573     0.200
     5.298   -27.381     0.200
     5.494   -27.970     0.200
     1.371    -0.053     0.200
     1.396    -0.739     0.200
     1.440     0.758     0.200
     2.779   -11.903     0.200
     3.579   -19.064     0.200
     4.286   -25.659     0.200
     4.286   -24.956     0.200
     4.307   -22.926     0.200
     4.871   -26.995     0.200
     5.262   -28.194     0.200
     5.785   -33.482     0.200
     5.968   -35.894     0.200
     6.184   -35.039     0.200
     1.823     0.301     0.200
     1.859    -2.135     0.200
     1.859     0.365     0.200
     1.859     0.162     0.200
     2.316    -5.650     0.200
     2.447    -7.402     0.200
     2.832   -10.185     0.200
     2.774    -9.539     0.200
     2.774    -8.946     0.200
     2.851   -11.814     0.200
     3.205   -11.204     0.200
     3.455   -15.742     0.200
     3.455   -16.141     0.200
     3.479   -16.386     0.200
     3.586   -16.406     0.200
     4.564   -24.983     0.200
     4.564   -24.382     0.200
     4.922   -22.054     0.200
     4.922   -22.351     0.200
     5.312   -26.918     0.200
     5.871   -28.461     0.200
     6.841   -40.871     0.200
    16.430  -112.368     0.200
    17.760  -118.500     0.200
     1.265     1.396     0.200
     1.424     0.052     0.200
     1.695    -1.737     0.200
     1.734    -1.485     0.200
     2.178    -5.363     0.200
     2.474    -7.954     0.200
     2.687    -9.683     0.200
     2.967   -12.379     0.200
     2.967   -12.579     0.200
     3.382   -17.441     0.200
     3.382   -15.538     0.200
     3.404   -15.539     0.200
     3.677   -17.368     0.200
     3.677   -15.970     0.200
     3.962   -20.112     0.200
     4.422   -25.202     0.200
     4.422   -24.702     0.200
     4.401   -24.124     0.200
     4.401   -22.023     0.200
     4.877   -24.526     0.200
     5.439   -32.222     0.200
     5.713   -28.704     0.200
     6.630   -41.782     0.200
     6.869   -42.552     0.200
     6.869   -40.955     0.200
     1.627     0.561     0.200
     1.669     0.729     0.200
     1.710     0.925     0.200
     1.710     2.425     0.200
     2.647    -8.484     0.200
     3.047   -12.655     0.200
     3.373   -12.791     0.200
     4.864   -21.953     0.200
     5.310   -26.084     0.200
     6.876   -40.941     0.200
     1.448     0.624     0.200
     1.448    -0.080     0.200
     1.558    -0.188     0.200
     1.764    -0.801     0.200
     2.699   -10.946     0.200
     2.993   -11.278     0.200
     3.310   -15.030     0.200
     4.401   -25.911     0.200
     5.348   -28.535     0.200
     5.348   -26.836     0.200
     1.277     0.858     0.200
     5.856   -35.022     0.200
     1.512     0.457     0.200
     1.712    -0.199     0.200
     1.911    -0.111     0.200
     2.236    -5.408     0.200
     2.649    -8.683     0.200
     2.649    -8.582     0.200
     3.043   -12.481     0.200
     4.333   -22.792     0.200
     5.309   -27.800     0.200
     6.876   -40.696     0.200
     1.097     4.234     0.200
     1.392     2.395     0.200
     1.491     1.434     0.200
     1.599    -0.081     0.200
     1.649     0.651     0.200
     1.830    -0.410     0.200
     2.690    -9.660     0.200
     2.856   -10.022     0.200
     4.079   -20.786     0.200
     4.961   -25.068     0.200
     5.451   -31.100     0.200
     1.316     0.959     0.200
     1.318     1.503     0.200
     1.318     1.105     0.200
     1.577    -0.131     0.200
     2.299    -6.608     0.200
     2.591    -8.669     0.200
     4.312   -22.911     0.200
     4.543   -22.251     0.200
     5.028   -26.004     0.200
     7.194   -43.190     0.200
     1.633     0.134     0.200
     1.636    -0.054     0.200
     2.457    -6.984     0.200
     2.608    -7.756     0.200
     3.239   -11.875     0.200
     3.766   -14.972     0.200
     4.675   -20.901     0.200
     5.068   -24.561     0.200
     1.513     0.832     0.200
     1.628     0.679     0.200
     2.644   -10.341     0.200
     3.043   -12.393     0.200
     4.340   -22.005     0.200
     4.340   -21.607     0.200
     4.858   -22.619     0.200
     4.858   -21.416     0.200
     5.257   -30.771     0.200
     5.302   -26.979     0.200
     5.510   -28.170     0.200
     5.624   -26.746     0.200
     6.882   -40.680     0.200
    12.623   -77.154     0.200
    12.735   -79.222     0.200
    14.264   -97.081     0.200
    14.276  -100.356     0.200
    15.102   -97.940     0.200
    16.652  -107.176     0.200
    16.991  -113.622     0.200
     1.620     0.083     0.200
     2.575    -7.822     0.200
     2.575    -8.619     0.200
     2.640    -8.946     0.200
     4.329   -22.903     0.200
     4.856   -22.028     0.200
     5.303   -27.575     0.200
     1.622     0.760     0.200
     4.344   -22.912     0.200
     4.851   -26.487     0.200
     5.294   -25.948     0.200
     1.619     0.035     0.200
     2.637    -9.528     0.200
     3.052   -12.593     0.200
     3.735   -19.336     0.200
     4.336   -21.694     0.200
     4.336   -22.490     0.200
     5.297   -25.759     0.200
     6.888   -40.782     0.200
     1.100     4.037     0.200
     1.514     0.626     0.200
     1.634     0.131     0.200
     1.634     1.131     0.200
     1.915     0.129     0.200
     2.654    -8.597     0.200
     3.040   -12.740     0.200
     3.327   -14.658     0.200
     4.354   -20.311     0.200
     4.869   -21.434     0.200
     4.869   -21.137     0.200
     5.314   -28.833     0.200
     5.509   -25.811     0.200
     5.624   -27.399     0.200
     6.670   -38.721     0.200
     6.871   -40.381     0.200
     1.191     3.224     0.200
     1.639     0.911     0.200
     1.920    -0.071     0.200
     2.660    -8.733     0.200
     3.035   -12.520     0.200
     4.876   -21.573     0.200
     1.081     4.192     0.200
     1.170     3.471     0.200
     1.385     2.454     0.200
     1.615     1.161     0.200
     1.898     0.304     0.200
     2.634    -7.721     0.200
     3.056   -13.319     0.200
     5.269   -30.855     0.200
     5.296   -27.203     0.200
     1.622     1.194     0.200
     1.664     0.962     0.200
     1.904     0.978     0.200
     3.051   -12.191     0.200
     4.329   -21.716     0.200
     5.305   -25.347     0.200
     6.881   -40.501     0.200
     1.606     1.582     0.200
     1.648     1.459     0.200
     1.889     0.521     0.200
     1.505    -0.008     0.200
     1.621    -0.369     0.200
     1.904    -0.233     0.200
     2.571    -7.976     0.200
     2.638    -9.225     0.200
     4.337   -23.864     0.200
     1.539    -0.206     0.200
     1.655    -0.278     0.200
     1.736     1.975     0.200
     2.538    -8.946     0.200
     4.350   -22.504     0.200
     1.638     0.162     0.200
     1.680     0.043     0.200
     1.921    -0.402     0.200
     4.342   -22.866     0.200
     6.874   -40.809     0.200
     1.287     0.628     0.200
     1.287     0.527     0.200
     1.635    -0.900     0.200
     1.635    -0.696     0.200
     1.813     0.464     0.200
     2.163    -6.139     0.200
     2.511    -9.460     0.200
     2.562    -8.284     0.200
     3.391   -17.166     0.200
     6.065   -37.630     0.200
     1.243     1.416     0.200
     1.610    -2.596     0.200
     2.616    -8.986     0.200
     2.616    -9.388     0.200
     2.823   -12.548     0.200
     3.062   -13.344     0.200
     3.013   -12.875     0.200
     5.081   -26.335     0.200
     5.553   -28.212     0.200
     1.086     3.787     0.200
     1.507     1.940     0.200
     1.621     0.829     0.200
     1.662     1.212     0.200
     1.904    -0.865     0.200
     2.569    -7.730     0.200
     2.637    -8.285     0.200
     3.050   -13.287     0.200
     3.418   -12.959     0.200
     4.341   -22.207     0.200
     5.295   -26.051     0.200
     6.889   -40.491     0.200
     1.702    -0.151     0.200
     1.761    -1.537     0.200
     1.797    -0.361     0.200
     3.416   -14.390     0.200
     3.416   -12.890     0.200
     4.557   -24.958     0.200
     4.863   -22.356     0.200
     5.259   -26.412     0.200
     1.356    -0.065     0.200
     1.492    -1.767     0.200
     1.631    -1.384     0.200
     1.631    -2.384     0.200
     2.117    -6.693     0.200
     2.154    -6.766     0.200
     2.760   -12.486     0.200
     2.796   -11.602     0.200
     3.306   -15.694     0.200
     4.016   -22.892     0.200
     4.214   -20.181     0.200
     4.614   -25.054     0.200
     4.820   -29.282     0.200
     4.820   -29.482     0.200
     2.263    -6.172     0.200
     2.578    -9.158     0.200
     2.692    -9.471     0.200
     4.657   -26.566     0.200
     1.632    -0.170     0.200
     1.674     0.803     0.200
     2.234    -5.370     0.200
     2.565    -7.840     0.200
     2.565    -8.441     0.200
     2.651    -8.381     0.200
     3.041   -12.759     0.200
     3.721   -17.312     0.200
     4.332   -22.465     0.200
     5.311   -24.911     0.200
     5.511   -32.328     0.200
     6.873   -41.630     0.200
     1.504     0.200     0.200
     1.625     0.579     0.200
     2.573    -7.083     0.200
     2.646    -8.897     0.200
     1.086     2.974     0.200
     1.392     0.876     0.200
     1.501    -0.279     0.200
     1.619     0.467     0.200
     2.639   -10.374     0.200
     1.579    -0.528     0.200
     1.579    -0.228     0.200
     1.790    -0.629     0.200
     1.884    -0.593     0.200
     1.997    -4.492     0.200
     2.286    -6.928     0.200
     2.775   -11.344     0.200
     2.854   -10.746     0.200
     3.374   -15.736     0.200
     3.374   -15.435     0.200
     3.506   -16.411     0.200
     3.563   -16.317     0.200
     5.405   -29.123     0.200
     5.405   -28.422     0.200
     6.748   -40.893     0.200
     1.391     2.387     0.200
     1.510     2.115     0.200
     1.666     0.768     0.200
     2.242    -5.388     0.200
     2.566    -7.156     0.200
     2.641    -8.333     0.200
     3.046   -12.790     0.200
     3.342   -16.370     0.200
     3.366   -13.708     0.200
     3.366   -11.810     0.200
     4.088   -23.595     0.200
     4.341   -22.427     0.200
     5.299   -24.879     0.200
     5.516   -31.073     0.200
     5.507   -26.705     0.200
     6.886   -40.388     0.200
     1.389     2.338     0.200
     1.505     0.265     0.200
     1.505     2.163     0.200
     2.638    -8.060     0.200
     3.051   -13.044     0.200
     3.051   -11.044     0.200
     3.341   -14.827     0.200
     3.341   -16.921     0.200
     3.363   -14.141     0.200
     4.337   -21.993     0.200
     4.337   -22.298     0.200
     4.853   -25.473     0.200
     4.853   -22.372     0.200
     5.298   -27.780     0.200
     6.887   -41.240     0.200
     2.313    -7.678     0.200
     2.288    -7.689     0.200
     3.233   -14.733     0.200
     3.543   -17.958     0.200
     4.267   -23.919     0.200
     4.740   -28.102     0.200
     4.740   -26.102     0.200
     4.825   -27.894     0.200
     5.738   -32.644     0.200
     5.788   -34.535     0.200
     6.130   -36.065     0.200
     1.660     0.898     0.200
     1.660     0.398     0.200
     2.635    -9.602     0.200
     3.052   -12.933     0.200
     3.052   -12.628     0.200
     3.346   -14.632     0.200
     4.340   -22.469     0.200
     5.294   -28.384     0.200
     6.891   -41.024     0.200
     1.667     1.026     0.200
     1.909     0.237     0.200
     2.241    -4.797     0.200
     2.241    -5.797     0.200
     2.564    -8.913     0.200
     2.564    -8.112     0.200
     2.640    -8.241     0.200
     3.045   -11.675     0.200
     3.730   -16.295     0.200
     4.087   -20.407     0.200
     4.344   -21.953     0.200
     4.344   -22.352     0.200
     5.297   -27.245     0.200
     5.515   -30.563     0.200
     1.714     0.829     0.200
     1.967     0.413     0.200
     2.497    -7.173     0.200
     2.988   -11.359     0.200
     3.950   -19.551     0.200
     4.043   -21.577     0.200
     4.383   -23.766     0.200
     4.407   -22.637     0.200
     4.407   -22.739     0.200
     5.221   -29.741     0.200
     5.221   -29.139     0.200
     5.294   -27.058     0.200
     5.294   -25.160     0.200
     5.460   -31.397     0.200
     5.690   -29.004     0.200
     1.146     3.454     0.200
     4.399   -22.585     0.200
     1.709     1.056     0.200
     1.964     0.069     0.200
     2.663    -7.981     0.200
     2.992   -13.505     0.200
     2.992   -12.804     0.200
     3.941   -19.287     0.200
     4.416   -23.137     0.200
     5.228   -29.588     0.200
     5.284   -24.860     0.200
     6.888   -39.523     0.200
     1.709     1.139     0.200
     1.960     0.687     0.200
     2.506    -7.421     0.200
     4.396   -22.839     0.200
     4.867   -21.566     0.200
     5.298   -27.020     0.200
     5.298   -25.520     0.200
     6.877   -39.573     0.200
     1.722     1.017     0.200
     2.490    -8.049     0.200
     2.490    -5.850     0.200
     2.678    -7.192     0.200
     2.981   -11.417     0.200
     3.397   -11.784     0.200
     4.409   -22.775     0.200
     4.409   -23.478     0.200
     4.872   -22.256     0.200
     5.214   -26.999     0.200
     5.300   -25.505     0.200
     5.452   -31.849     0.200
     6.873   -40.071     0.200
     1.574     0.329     0.200
     1.574     2.229     0.200
     1.714     0.502     0.200
     1.965     0.317     0.200
     2.671    -7.963     0.200
     2.990   -11.762     0.200
     3.391   -12.874     0.200
     4.383   -21.215     0.200
     4.402   -23.934     0.200
     5.297   -26.800     0.200
     6.876   -40.055     0.200
     1.136     3.474     0.200
     1.415     2.320     0.200
     1.576    -0.179     0.200
     1.576     1.921     0.200
     1.717     0.862     0.200
     1.717    -0.538     0.200
     1.968    -0.007     0.200
     2.194    -5.472     0.200
     4.401   -23.136     0.200
     5.301   -26.258     0.200
     1.405     0.215     0.200
     1.511    -0.048     0.200
     1.511     1.249     0.200
     1.674     0.086     0.200
     1.674     0.188     0.200
     2.234    -5.956     0.200
     2.653    -8.942     0.200
     3.042   -12.786     0.200
     3.325   -15.845     0.200
     3.720   -16.779     0.200
     3.720   -16.677     0.200
     4.327   -22.811     0.200
     4.327   -23.913     0.200
     4.870   -23.610     0.200
     5.315   -27.432     0.200
     5.511   -34.446     0.200
     6.870   -40.235     0.200
     1.498     0.690     0.200
     1.611     0.128     0.200
     1.611     0.729     0.200
     1.875     0.340     0.200
     2.573    -9.271     0.200
     2.573   -10.771     0.200
     2.559    -7.325     0.200
     2.559    -8.126     0.200
     3.085   -14.212     0.200
     3.277   -14.208     0.200
     4.273   -21.487     0.200
     4.424   -22.970     0.200
     4.424   -23.072     0.200
     4.755   -24.451     0.200
     4.755   -24.053     0.200
     5.190   -27.838     0.200
     5.558   -32.095     0.200
     6.988   -40.733     0.200
     1.103     5.667     0.200
     1.524     1.904     0.200
     1.680     0.481     0.200
     2.552    -7.856     0.200
     2.653    -9.155     0.200
     3.032   -13.090     0.200
     4.074   -18.328     0.200
     4.348   -22.218     0.200
     4.348   -21.312     0.200
     5.305   -25.551     0.200
     5.502   -31.578     0.200
     5.635   -26.293     0.200
     6.877   -40.271     0.200
    12.634   -77.554     0.200
    16.311  -107.438     0.200
    17.394  -117.062     0.200
     1.394     0.531     0.200
     1.520     0.129     0.200
     1.520     1.731     0.200
     1.673     0.769     0.200
     1.917     0.050     0.200
     2.235    -6.752     0.200
     2.645    -9.443     0.200
     3.038    -9.896     0.200
     3.038   -13.497     0.200
     3.348   -12.320     0.200
     3.725   -13.677     0.200
     4.351   -23.309     0.200
     4.351   -23.009     0.200
     4.856   -22.838     0.200
     5.631   -26.608     0.200
    14.261   -96.954     0.200
    14.873  -100.185     0.200
    17.401  -114.807     0.200
     1.278     1.960     0.200
     1.604     1.042     0.200
     1.875     0.251     0.200
     4.451   -24.322     0.200
     1.795     0.331     0.200
     1.810     0.560     0.200
     2.674    -8.206     0.200
     2.692    -9.287     0.200
     3.338   -14.082     0.200
     1.497     0.520     0.200
     1.690     0.819     0.200
     1.690     7.616     0.200
     1.894     0.154     0.200
     2.625    -9.325     0.200
     2.879   -10.968     0.200
     3.061   -12.550     0.200
     4.341   -22.640     0.200
     5.285   -26.940     0.200
     6.901   -43.268     0.200
     6.901   -41.069     0.200
     1.423     0.655     0.200
     4.506   -25.573     0.200
     1.394     0.323     0.200
     1.525     0.070     0.200
     2.232    -6.360     0.200
     2.253    -6.513     0.200
     2.550    -9.733     0.200
     2.646    -9.485     0.200
     2.900   -11.806     0.200
     3.034   -13.861     0.200
     3.352   -15.950     0.200
     3.370   -15.518     0.200
     3.723   -19.409     0.200
     4.357   -24.606     0.200
     4.351   -22.425     0.200
     4.856   -22.526     0.200
     5.296   -29.779     0.200
     6.675   -41.079     0.200
     6.885   -44.052     0.200
     6.885   -41.751     0.200
     1.419     0.168     0.200
     1.545     0.569     0.200
     1.808     0.344     0.200
     2.201    -5.228     0.200
     2.885    -9.696     0.200
     4.428   -17.996     0.200
     4.904   -23.388     0.200
     6.859   -40.886     0.200
     7.310   -44.070     0.200
     2.469   -11.472     0.200
     2.867   -13.165     0.200
     3.127   -16.606     0.200
     3.607   -18.545     0.200
     4.209   -23.912     0.200
     5.130   -26.920     0.200
     6.608   -39.169     0.200
     1.448    -0.497     0.200
     1.509     0.258     0.200
     2.171    -5.820     0.200
     2.701   -11.016     0.200
     2.921   -11.110     0.200
     3.470   -16.214     0.200
     4.395   -23.024     0.200
     4.886   -28.804     0.200
     7.334   -45.193     0.200
     1.456    -0.222     0.200
     1.507     0.539     0.200
     1.801    -0.273     0.200
     2.429    -8.868     0.200
     2.421    -7.610     0.200
     2.630    -8.043     0.200
     2.669   -11.073     0.200
     3.181   -15.303     0.200
     3.181   -13.405     0.200
     3.132   -13.368     0.200
     3.132   -11.368     0.200
     3.556   -17.288     0.200
     3.603   -15.678     0.200
     3.684   -17.673     0.200
     3.939   -19.952     0.200
     4.272   -22.091     0.200
     4.515   -24.612     0.200
     4.599   -19.976     0.200
     5.029   -26.906     0.200
     5.655   -34.341     0.200
     7.146   -42.603     0.200
    14.614   -94.532     0.200
    16.565  -108.397     0.200
     1.405     2.677     0.200
     1.507     0.341     0.200
     1.672     1.024     0.200
     1.909     0.307     0.200
     4.322   -22.189     0.200
     4.870   -20.563     0.200
     5.316   -30.220     0.200
     5.316   -27.320     0.200
     6.870   -39.963     0.200
     1.389     2.421     0.200
     1.498     0.842     0.200
     1.898     0.685     0.200
     2.578   -10.381     0.200
     2.578   -10.084     0.200
     3.057   -13.652     0.200
     4.095   -21.085     0.200
     4.329   -22.082     0.200
     4.329   -21.582     0.200
     4.337   -25.032     0.200
     5.300   -27.070     0.200
     6.886   -39.557     0.200
     1.173     3.609     0.200
     1.501     2.701     0.200
     1.662     0.811     0.200
     1.703     0.807     0.200
     1.901     0.729     0.200
     2.575    -7.841     0.200
     2.764   -11.713     0.200
     2.895   -10.457     0.200
     3.053   -12.282     0.200
     3.333   -14.942     0.200
     3.421   -17.640     0.200
     4.091   -20.199     0.200
     4.328   -23.095     0.200
     4.328   -21.896     0.200
     4.858   -21.287     0.200
     5.304   -27.138     0.200
     5.304   -28.938     0.200
     6.882   -39.964     0.200
     1.164     3.135     0.200
     1.389     0.909     0.200
     1.492     0.241     0.200
     1.492     2.037     0.200
     1.655     0.486     0.200
     1.655     0.588     0.200
     1.893     0.343     0.200
     2.253    -7.973     0.200
     2.585   -10.495     0.200
     2.585    -7.292     0.200
     2.635    -9.593     0.200
     2.760   -11.350     0.200
     3.062   -11.708     0.200
     3.739   -20.869     0.200
     4.320   -22.108     0.200
     4.320   -21.608     0.200
     4.855   -24.047     0.200
     4.855   -23.446     0.200
     5.303   -29.659     0.200
     6.885   -41.599     0.200
     1.466     0.481     0.200
     1.525     0.496     0.200
     1.759    -1.707     0.200
     2.290    -8.156     0.200
     3.017   -13.295     0.200
     3.353   -16.454     0.200
     3.738   -20.163     0.200
     4.361   -22.991     0.200
     4.720   -26.175     0.200
     5.212   -29.161     0.200
     5.624   -30.923     0.200
     6.538   -41.297     0.200
     1.268    -0.049     0.200
     1.517    -0.641     0.200
     2.507    -8.840     0.200
     2.763   -11.437     0.200
     2.958   -11.313     0.200
     3.241   -16.589     0.200
     5.423   -28.365     0.200
     1.107     3.328     0.200
     1.277     0.935     0.200
     1.358     0.988     0.200
     1.396     1.372     0.200
     1.615     0.230     0.200
     2.338    -6.884     0.200
     2.594    -8.096     0.200
     2.829   -10.942     0.200
     5.058   -25.704     0.200
     5.264   -27.950     0.200
     1.106     3.175     0.200
     1.358     0.691     0.200
     1.396     1.389     0.200
     1.616     0.305     0.200
     2.827   -12.581     0.200
     4.397   -27.146     0.200
     5.056   -24.533     0.200
     1.545    -0.241     0.200
     1.544    -0.409     0.200
     2.423    -8.494     0.200
     2.498    -9.570     0.200
     2.498    -8.370     0.200
     2.667   -12.034     0.200
     3.147   -14.953     0.200
     3.125   -13.540     0.200
     3.680   -19.327     0.200
     3.661   -15.132     0.200
     4.611   -26.839     0.200
     4.611   -27.339     0.200
     4.573   -19.640     0.200
     4.983   -27.749     0.200
     4.983   -25.549     0.200
     7.181   -43.600     0.200
     1.350     0.813     0.200
     1.408     0.770     0.200
     1.654    -0.323     0.200
     1.720     0.287     0.200
     2.391    -8.892     0.200
     2.512    -8.622     0.200
     2.906   -12.418     0.200
     3.179   -13.556     0.200
     3.179   -14.150     0.200
     3.160   -12.460     0.200
     3.631   -16.784     0.200
     4.321   -23.179     0.200
     5.114   -24.982     0.200
     5.114   -25.388     0.200
     5.282   -29.838     0.200
     5.540   -28.107     0.200
     5.681   -30.881     0.200
     6.630   -39.166     0.200
    14.013   -93.690     0.200
     1.149     0.490     0.200
     1.475     0.238     0.200
     1.480    -0.822     0.200
     1.743    -0.631     0.200
     4.374   -24.152     0.200
     4.391   -26.173     0.200
     1.373    -0.715     0.200
     1.373     0.887     0.200
     1.514    -0.167     0.200
     2.234    -7.378     0.200
     2.560   -11.014     0.200
     2.627    -9.846     0.200
     2.744   -10.854     0.200
     2.880   -12.363     0.200
     3.048   -14.496     0.200
     3.350   -15.867     0.200
     3.918   -18.880     0.200
     5.276   -28.018     0.200
     5.518   -31.411     0.200
     1.372     0.102     0.200
     1.517    -0.086     0.200
     1.696     1.041     0.200
     2.556   -11.342     0.200
     1.136     1.617     0.200
     1.432     0.211     0.200
     1.553     0.085     0.200
     1.752     1.297     0.200
     2.196    -7.179     0.200
     2.292    -6.822     0.200
     2.525    -9.017     0.200
     2.685   -10.594     0.200
     2.803   -10.228     0.200
     2.938   -11.823     0.200
     3.409   -15.934     0.200
     3.977   -19.648     0.200
     4.351   -24.121     0.200
     4.389   -24.510     0.200
     4.894   -24.020     0.200
     5.332   -28.904     0.200
     1.170     3.988     0.200
     1.499     0.559     0.200
     1.499     2.259     0.200
     1.658     1.030     0.200
     5.298   -25.364     0.200
     1.079     1.481     0.200
     1.079     4.079     0.200
     1.168     3.557     0.200
     1.613    -0.152     0.200
     1.613     1.149     0.200
     1.654     0.427     0.200
     1.895     0.094     0.200
     4.333   -22.682     0.200
     4.848   -24.097     0.200
     5.272   -33.539     0.200
     1.352    -0.265     0.200
     1.375     0.392     0.200
     1.438     0.021     0.200
     1.487    -1.451     0.200
     1.720    -0.122     0.200
     2.209    -6.230     0.200
     2.274    -7.708     0.200
     2.904   -11.583     0.200
     2.904   -12.677     0.200
     4.348   -20.755     0.200
     4.684   -29.802     0.200
     4.766   -26.797     0.200
     1.082     4.195     0.200
     1.388     0.484     0.200
     1.497     0.733     0.200
     1.698     1.057     0.200
     1.896     0.375     0.200
     2.636    -9.463     0.200
     4.327   -22.585     0.200
     4.853   -23.956     0.200
     5.493   -29.349     0.200
     1.082     4.275     0.200
     1.658     0.510     0.200
     1.658     0.611     0.200
     1.698     0.747     0.200
     1.900     0.455     0.200
     2.250    -5.550     0.200
     2.574    -9.218     0.200
     2.634    -8.418     0.200
     3.344   -16.015     0.200
     3.344   -12.320     0.200
     3.359   -11.202     0.200
     4.337   -21.012     0.200
     4.337   -22.215     0.200
     4.849   -20.732     0.200
     4.849   -20.936     0.200
     5.294   -25.345     0.200
     5.613   -26.695     0.200
     6.891   -40.175     0.200
     1.453    -0.503     0.200
     1.676     0.217     0.200
     1.756     0.398     0.200
     1.816     0.983     0.200
     2.336    -7.593     0.200
     2.726   -12.139     0.200
     2.974   -12.809     0.200
     3.972   -20.138     0.200
     4.450   -24.289     0.200
     4.497   -25.409     0.200
     4.894   -22.084     0.200
     5.301   -30.468     0.200
     6.588   -41.394     0.200
     6.859   -44.080     0.200
     1.545     0.294     0.200
     1.593     0.582     0.200
     1.593     0.878     0.200
     1.657     1.239     0.200
     1.791    -0.015     0.200
     2.224    -6.224     0.200
     2.330    -5.699     0.200
     2.621    -8.215     0.200
     2.621    -8.113     0.200
     2.780   -10.545     0.200
     2.880   -11.437     0.200
     3.202   -14.242     0.200
     3.174   -13.745     0.200
     3.360   -15.250     0.200
     3.789   -18.139     0.200
     4.138   -21.009     0.200
     4.138   -20.509     0.200
     4.288   -21.673     0.200
     4.884   -20.248     0.200
     5.369   -27.924     0.200
     5.459   -27.775     0.200
     6.722   -38.609     0.200
     6.855   -39.228     0.200
     1.114     2.095     0.200
     1.429     0.396     0.200
     1.509    -1.052     0.200
     1.642    -1.265     0.200
     1.731    -0.563     0.200
     2.672   -10.418     0.200
     4.298   -23.353     0.200
     4.895   -23.382     0.200
     1.535    -1.237     0.200
     1.597    -0.807     0.200
     2.119    -8.346     0.200
     2.945   -13.325     0.200
     4.293   -24.054     0.200
     1.296     2.539     0.200
     1.374     3.074     0.200
     1.923     0.250     0.200
     2.319    -5.092     0.200
     2.575    -7.824     0.200
     2.857   -10.853     0.200
     3.052   -10.018     0.200
     3.371   -14.239     0.200
     4.297   -22.697     0.200
     4.565   -20.505     0.200
     4.565   -21.705     0.200
     5.051   -25.284     0.200
     6.867   -42.872     0.200
     6.996   -38.648     0.200
     1.483     1.144     0.200
     1.731     0.293     0.200
     2.070    -3.449     0.200
     2.425    -6.594     0.200
     2.598    -8.295     0.200
     2.725    -8.927     0.200
     2.720   -10.058     0.200
     3.419   -15.018     0.200
     3.912   -19.026     0.200
     4.311   -21.393     0.200
     5.163   -23.706     0.200
     7.041   -41.528     0.200
    14.190   -89.857     0.200
    14.924   -93.327     0.200
     1.321     2.684     0.200
     1.711    -0.161     0.200
     1.150     2.335     0.200
     1.433     0.566     0.200
     1.476     1.131     0.200
     1.520     1.633     0.200
     1.718     0.058     0.200
     2.465    -7.523     0.200
     2.744   -10.367     0.200
     2.721    -9.441     0.200
     3.196   -13.003     0.200
     3.237   -16.014     0.200
     3.783   -15.809     0.200
     4.286   -22.154     0.200
     4.703   -25.480     0.200
     5.336   -29.554     0.200
     1.514     2.374     0.200
     1.665     1.494     0.200
     1.910     0.336     0.200
     2.244    -5.244     0.200
     2.244    -4.948     0.200
     2.560    -8.087     0.200
     2.560    -7.087     0.200
     2.636    -9.284     0.200
     3.045   -12.248     0.200
     3.045   -13.443     0.200
     3.355   -12.595     0.200
     4.354   -22.346     0.200
     4.354   -22.744     0.200
     4.847   -22.469     0.200
     4.847   -22.867     0.200
     5.288   -26.871     0.200
     5.627   -25.331     0.200
     6.894   -40.268     0.200
    15.115   -97.941     0.200
     1.614     0.455     0.200
     1.896     0.209     0.200
     2.239    -6.053     0.200
     2.578    -9.814     0.200
     2.633    -8.845     0.200
     4.332   -23.497     0.200
     1.487     0.132     0.200
     1.789    -1.341     0.200
     1.856    -1.975     0.200
     1.840    -0.458     0.200
     1.485     0.682     0.200
     1.487    -1.391     0.200
     2.705   -10.083     0.200
     2.648    -9.801     0.200
     3.102   -13.069     0.200
     3.043   -14.293     0.200
     3.159   -14.980     0.200
     3.333   -13.207     0.200
     3.296   -15.534     0.200
     4.320   -23.280     0.200
     5.163   -31.605     0.200
     5.664   -33.798     0.200
     6.500   -38.799     0.200
     7.131   -46.295     0.200
     7.908   -55.218     0.200
     9.513   -64.300     0.200
    13.882   -92.295     0.200
    14.299   -93.234     0.200
    22.952  -158.107     0.200
     1.081     2.672     0.200
     1.299     0.672     0.200
     1.408     0.408     0.200
     1.410     0.833     0.200
     1.410     2.133     0.200
     2.351    -6.603     0.200
     2.351    -6.902     0.200
     2.447    -8.850     0.200
     2.447    -7.449     0.200
     2.600    -8.771     0.200
     2.600    -7.771     0.200
     2.687   -10.038     0.200
     2.687    -9.137     0.200
     3.063   -11.981     0.200
     3.063   -12.375     0.200
     3.063   -13.675     0.200
     3.246   -14.357     0.200
     3.246   -16.558     0.200
     3.621   -16.757     0.200
     3.643   -17.753     0.200
     3.643   -18.852     0.200
     3.618   -16.353     0.200
     4.008   -20.232     0.200
     4.080   -20.788     0.200
     4.340   -23.055     0.200
     4.519   -23.127     0.200
     4.534   -20.878     0.200
     4.534   -19.578     0.200
     5.531   -31.985     0.200
     5.522   -27.762     0.200
     5.720   -32.795     0.200
     6.963   -43.681     0.200
     6.968   -43.938     0.200
     7.210   -43.125     0.200
     1.526     0.178     0.200
     1.708    -0.502     0.200
     1.783    -0.276     0.200
     2.896   -11.747     0.200
     3.158   -13.749     0.200
     5.177   -25.076     0.200
     5.669   -29.163     0.200
     1.497     2.234     0.200
     1.621    -0.081     0.200
     1.663     0.371     0.200
     1.663     0.473     0.200
     1.706     1.016     0.200
     1.899    -0.013     0.200
     2.581    -8.230     0.200
     2.645    -8.555     0.200
     2.900   -10.222     0.200
     3.055   -14.550     0.200
     4.315   -21.394     0.200
     4.315   -21.292     0.200
     4.865   -23.934     0.200
     4.865   -23.137     0.200
     5.314   -27.651     0.200
     6.874   -42.609     0.200
     1.872    -5.622     0.200
     1.995    -5.638     0.200
     2.090    -5.921     0.200
     2.636   -10.543     0.200
     3.030   -13.837     0.200
     3.284   -15.284     0.200
     3.346   -16.847     0.200
     3.755   -18.905     0.200
     4.317   -24.927     0.200
     4.319   -22.801     0.200
     5.175   -31.832     0.200
     5.235   -30.026     0.200
     5.654   -32.817     0.200
     6.511   -42.287     0.200
     7.669   -48.887     0.200
     1.082     3.796     0.200
     1.657     0.068     0.200
     2.251    -6.435     0.200
     2.242    -5.567     0.200
     2.580   -10.090     0.200
     2.636    -9.364     0.200
     3.362   -14.380     0.200
     3.737   -17.654     0.200
     3.936   -19.872     0.200
     4.096   -19.842     0.200
     4.325   -22.510     0.200
     4.336   -22.751     0.200
     4.854   -23.475     0.200
     1.086     3.889     0.200
     1.496     0.365     0.200
     1.660     0.481     0.200
     1.702     0.448     0.200
     2.641    -8.604     0.200
     2.765   -10.862     0.200
     4.320   -22.437     0.200
     1.684     0.675     0.200
     2.295    -4.800     0.200
     1.671    -0.258     0.200
     1.735     0.098     0.200
     0.964     2.175     0.200
     1.457     0.439     0.200
     2.201    -8.235     0.200
     2.980   -13.629     0.200
     5.523   -33.230     0.200
     1.429     0.810     0.200
     1.487     0.760     0.200
     1.524     0.175     0.200
     1.524     1.175     0.200
     1.550     1.072     0.200
     2.078    -4.477     0.200
     2.470    -7.606     0.200
     2.645    -7.337     0.200
     2.645   -10.236     0.200
     2.581    -8.122     0.200
     2.721    -9.373     0.200
     3.168   -13.743     0.200
     3.190   -13.316     0.200
     3.503   -16.547     0.200
     3.755   -15.926     0.200
     3.894   -20.130     0.200
     4.424   -23.953     0.200
     4.424   -24.152     0.200
     4.672   -21.598     0.200
     5.115   -27.749     0.200
     5.548   -27.397     0.200
     5.642   -34.344     0.200
     1.348     1.454     0.200
     1.567     0.600     0.200
     1.608     0.999     0.200
     1.646     0.093     0.200
     2.187    -7.052     0.200
     2.610    -9.540     0.200
     2.581    -9.441     0.200
     2.835   -11.780     0.200
     3.100   -14.784     0.200
     3.879   -20.493     0.200
     4.284   -20.917     0.200
     4.344   -23.619     0.200
     4.797   -25.495     0.200
     5.246   -28.716     0.200
     5.570   -32.494     0.200
     1.489    -1.396     0.200
     1.724    -0.445     0.200
     1.767    -1.581     0.200
     2.141    -7.458     0.200
     2.141    -5.758     0.200
     2.349    -8.332     0.200
     2.488    -7.936     0.200
     2.742   -11.009     0.200
     2.952   -13.474     0.200
     2.996   -12.938     0.200
     3.289   -15.544     0.200
     3.987   -20.866     0.200
     4.950   -23.501     0.200
     4.950   -25.501     0.200
     5.385   -29.176     0.200
     5.702   -28.585     0.200
     6.792   -42.286     0.200
     6.792   -40.385     0.200
    12.041   -80.174     0.200
    14.167   -96.460     0.200
    16.748  -111.200     0.200
     1.296     0.651     0.200
     1.294     0.992     0.200
     1.335     1.005     0.200
     1.335     1.406     0.200
     2.319    -7.290     0.200
     2.462    -8.713     0.200
     2.575    -8.817     0.200
     2.852   -11.598     0.200
     3.367   -15.324     0.200
     3.367   -16.125     0.200
     3.497   -19.029     0.200
     3.643   -17.255     0.200
     3.738   -18.870     0.200
     4.060   -21.990     0.200
     4.012   -19.270     0.200
     4.303   -22.690     0.200
     4.419   -23.368     0.200
     4.564   -19.051     0.200
     4.564   -22.451     0.200
     5.048   -25.888     0.200
     5.839   -34.384     0.200
    12.324   -80.036     0.200
     1.289     1.255     0.200
     1.303     1.112     0.200
     1.344     0.731     0.200
     1.464     1.422     0.200
     1.870    -1.561     0.200
     1.844     0.075     0.200
     3.010   -12.306     0.200
     1.527    -0.370     0.200
     1.630    -0.656     0.200
     2.781   -12.923     0.200
     3.034   -12.645     0.200
     3.590   -16.467     0.200
     4.070   -21.884     0.200
     4.348   -23.518     0.200
     4.484   -23.612     0.200
     4.986   -27.435     0.200
     5.120   -30.478     0.200
     5.384   -31.236     0.200
     5.417   -27.691     0.200
     6.757   -43.571     0.200
     1.092     3.891     0.200
     1.627    -0.191     0.200
     1.669     0.999     0.200
     1.707     0.873     0.200
     1.912    -0.208     0.200
     2.557    -7.057     0.200
     2.641    -8.036     0.200
     2.895   -10.773     0.200
     3.366   -13.902     0.200
     4.347   -21.323     0.200
     5.296   -28.994     0.200
     1.433     0.683     0.200
     1.433     2.879     0.200
     1.465     0.876     0.200
     1.786     0.804     0.200
     2.426    -6.183     0.200
     2.644    -9.584     0.200
     3.570   -15.157     0.200
     4.479   -21.752     0.200
     4.615   -18.487     0.200
     5.052   -26.529     0.200
     5.052   -23.529     0.200
     6.661   -39.331     0.200
     1.251     1.258     0.200
     1.798    -0.484     0.200
     1.809    -2.729     0.200
     1.809    -0.428     0.200
     1.830    -2.111     0.200
     1.877    -3.403     0.200
     1.877    -1.102     0.200
     2.234    -6.307     0.200
     2.273    -7.739     0.200
     3.265   -13.585     0.200
     4.634   -24.089     0.200
     4.940   -29.987     0.200
     1.358    -0.689     0.200
     1.601    -0.688     0.200
     1.808    -0.348     0.200
     1.905    -4.815     0.200
     2.265    -8.430     0.200
     2.202    -7.016     0.200
     2.487    -9.177     0.200
     3.124   -13.752     0.200
     3.363   -17.218     0.200
     3.820   -19.512     0.200
     4.123   -21.539     0.200
     4.520   -26.599     0.200
     4.601   -25.293     0.200
     5.034   -26.109     0.200
     5.034   -26.007     0.200
     5.226   -31.100     0.200
     5.425   -28.812     0.200
     5.919   -32.065     0.200
     8.167   -54.631     0.200
    12.055   -80.257     0.200
    13.006   -86.919     0.200
    15.040  -101.347     0.200
    19.880  -133.520     0.200
     1.375     0.478     0.200
     4.523   -27.336     0.200
     5.049   -24.586     0.200
     5.438   -30.932     0.200
     1.354     0.567     0.200
     4.528   -26.945     0.200
     5.230   -30.807     0.200
     5.415   -28.589     0.200
     1.509    -0.234     0.200
     1.657     0.159     0.200
     1.903    -0.137     0.200
     2.251    -6.879     0.200
     2.234    -5.918     0.200
     2.627    -8.591     0.200
     2.627    -8.392     0.200
     2.746   -10.746     0.200
     2.880    -9.816     0.200
     3.362   -14.595     0.200
     3.351   -13.532     0.200
     3.742   -17.037     0.200
     4.332   -22.431     0.200
     4.356   -24.806     0.200
     4.356   -21.908     0.200
     4.838   -25.167     0.200
     4.838   -22.265     0.200
     5.272   -30.124     0.200
     5.280   -28.378     0.200
     6.694   -39.008     0.200
     1.585    -0.341     0.200
     1.682    -1.732     0.200
     1.682    -0.232     0.200
     2.190    -6.619     0.200
     4.412   -25.481     0.200
     5.297   -26.734     0.200
     1.096     0.841     0.200
     1.318     0.619     0.200
     1.398    -0.228     0.200
     1.587    -0.917     0.200
     4.071   -22.670     0.200
     1.167     0.608     0.200
     1.339     0.341     0.200
     1.391    -0.810     0.200
     1.399     0.429     0.200
     1.463    -0.903     0.200
     4.195   -23.293     0.200
     1.704    -0.183     0.200
     1.718     0.373     0.200
     1.749     0.386     0.200
     1.750     0.361     0.200
     2.217    -6.428     0.200
     2.375    -6.351     0.200
     2.375    -6.749     0.200
     2.625    -7.752     0.200
     2.625    -8.752     0.200
     2.867    -8.626     0.200
     2.867   -10.524     0.200
     3.320   -12.702     0.200
     3.320   -14.405     0.200
     3.842   -17.839     0.200
     4.659   -25.557     0.200
     4.659   -25.362     0.200
     5.132   -25.854     0.200
     5.132   -28.150     0.200
     5.415   -30.720     0.200
     1.260     4.177     0.200
     1.514     0.533     0.200
     4.432   -21.186     0.200
     4.917   -26.171     0.200
     1.509    -0.360     0.200
     1.750    -0.508     0.200
     1.800    -1.981     0.200
     1.800     0.121     0.200
     1.830    -0.846     0.200
     2.209    -8.050     0.200
     2.263    -6.269     0.200
     2.263    -6.769     0.200
     2.448    -6.718     0.200
     2.635    -9.837     0.200
     2.704   -11.832     0.200
     2.898   -11.397     0.200
     2.898   -11.296     0.200
     3.421   -15.471     0.200
     3.896   -21.415     0.200
     3.964   -20.565     0.200
     4.162   -22.159     0.200
     4.331   -19.923     0.200
     4.467   -24.225     0.200
     4.735   -28.609     0.200
     4.738   -25.833     0.200
     5.490   -33.657     0.200
     5.490   -31.352     0.200
     5.673   -35.055     0.200
     6.719   -41.504     0.200
     7.115   -44.982     0.200
     7.425   -47.613     0.200
     7.988   -50.054     0.200
     1.667     0.024     0.200
     1.667     1.427     0.200
     1.698     0.545     0.200
     2.002     0.006     0.200
     2.424    -7.056     0.200
     2.424    -6.158     0.200
     2.575    -7.232     0.200
     2.640    -8.090     0.200
     2.817    -8.921     0.200
     2.992   -12.275     0.200
     3.272   -11.564     0.200
     3.630   -16.498     0.200
     3.630   -14.900     0.200
     3.789   -16.833     0.200
     4.105   -19.932     0.200
     4.317   -20.578     0.200
     4.646   -24.385     0.200
     5.096   -25.945     0.200
     5.304   -30.256     0.200
     5.683   -31.965     0.200
     1.887     0.261     0.200
     2.282    -6.153     0.200
     2.537    -7.551     0.200
     4.341   -23.143     0.200
     5.000   -27.923     0.200
     1.662     0.919     0.200
     1.701     1.010     0.200
     1.701     0.804     0.200
     2.005     0.648     0.200
     2.192    -4.271     0.200
     2.266    -5.500     0.200
     2.576    -6.532     0.200
     2.640    -7.568     0.200
     2.640    -7.467     0.200
     2.818    -9.910     0.200
     2.990   -12.373     0.200
     3.633   -15.352     0.200
     3.788   -16.976     0.200
     4.319   -18.692     0.200
     4.650   -24.773     0.200
     4.650   -24.375     0.200
     4.706   -20.855     0.200
     4.706   -20.558     0.200
     5.095   -24.076     0.200
     5.095   -25.076     0.200
     5.465   -30.304     0.200
     5.686   -30.743     0.200
     6.440   -38.314     0.200
     7.059   -42.548     0.200
     8.268   -51.372     0.200
     1.681     0.605     0.200
     1.676     0.155     0.200
     1.710     0.579     0.200
     1.712     0.038     0.200
     2.018    -3.272     0.200
     2.199    -5.624     0.200
     2.582    -7.865     0.200
     3.278   -13.407     0.200
     4.663   -25.725     0.200
     4.708   -24.045     0.200
     1.741     0.658     0.200
     1.822     0.371     0.200
     2.125    -6.039     0.200
     2.362    -6.438     0.200
     2.755   -10.407     0.200
     2.870   -10.748     0.200
     3.008   -11.122     0.200
     3.292   -15.313     0.200
     3.478   -17.713     0.200
     4.357   -23.389     0.200
     4.960   -22.682     0.200
     4.960   -23.881     0.200
     5.403   -32.440     0.200
     5.391   -29.747     0.200
     7.393   -47.035     0.200
     8.606   -54.182     0.200
    12.039   -81.494     0.200
    14.151   -93.241     0.200
    20.936  -137.851     0.200
     1.694    -0.189     0.200
     1.704    -0.620     0.200
     1.735     0.402     0.200
     1.735     0.301     0.200
     2.233    -5.266     0.200
     2.226    -6.241     0.200
     2.388    -6.076     0.200
     2.609    -8.285     0.200
     2.670    -9.839     0.200
     2.956   -13.089     0.200
     2.851    -8.855     0.200
     3.304   -12.250     0.200
     3.626   -16.237     0.200
     3.626   -16.339     0.200
     3.756   -19.167     0.200
     4.353   -21.775     0.200
     4.661   -25.646     0.200
     4.661   -25.747     0.200
     4.734   -20.957     0.200
     5.430   -31.418     0.200
     1.158     2.403     0.200
     1.370     1.678     0.200
     1.424    -0.422     0.200
     1.461    -0.108     0.200
     1.487     0.646     0.200
     1.733    -0.545     0.200
     4.406   -23.664     0.200
     1.506     0.119     0.200
     1.506     0.815     0.200
     1.681    -0.719     0.200
     4.273   -17.577     0.200
     4.740   -21.477     0.200
     5.309   -25.268     0.200
     1.598     0.225     0.200
     1.727     0.032     0.200
     1.820     0.396     0.200
     2.211    -5.496     0.200
     2.829   -10.598     0.200
     2.929   -10.994     0.200
     4.415   -22.771     0.200
     4.875   -24.251     0.200
     5.385   -25.695     0.200
     1.504    -0.321     0.200
     1.734    -0.716     0.200
     1.874    -0.742     0.200
     2.118    -5.792     0.200
     2.334    -6.417     0.200
     1.449    -0.144     0.200
     1.590    -0.423     0.200
     1.634    -0.026     0.200
     1.859    -0.238     0.200
     4.255   -23.506     0.200
     4.321   -22.692     0.200
     4.868   -23.132     0.200
     5.329   -25.949     0.200
     1.437     0.746     0.200
     1.751    -1.020     0.200
     1.778     0.035     0.200
     1.913    -1.455     0.200
     1.956    -3.628     0.200
     2.604    -9.056     0.200
     2.999   -12.171     0.200
     3.253   -14.844     0.200
     3.726   -17.612     0.200
     1.373    -0.456     0.200
     1.457     0.468     0.200
     1.312     3.960     0.200
     1.538     0.104     0.200
     1.726     0.228     0.200
     1.860    -0.715     0.200
     2.255    -6.554     0.200
     4.992   -22.210     0.200
     1.604    -0.086     0.200
     1.734    -0.320     0.200
     1.828    -0.272     0.200
     2.218    -6.563     0.200
     2.823    -9.111     0.200
     4.422   -18.930     0.200
     4.881   -23.180     0.200
     1.422    -0.032     0.200
     1.507     0.383     0.200
     1.725    -0.433     0.200
     2.272    -7.457     0.200
     2.666   -10.366     0.200
     2.921   -12.041     0.200
     2.921   -12.342     0.200
     3.394   -15.511     0.200
     3.394   -15.730     0.200
     4.302   -23.129     0.200
     5.338   -30.743     0.200
     7.932   -50.533     0.200
     1.366    -0.146     0.200
     1.527    -1.653     0.200
     1.647    -1.473     0.200
     1.647    -2.177     0.200
     1.752    -1.014     0.200
     1.752    -0.912     0.200
     1.760    -2.641     0.200
     1.760    -0.446     0.200
     1.757     0.234     0.200
     2.150    -5.411     0.200
     2.150    -6.911     0.200
     2.740   -12.507     0.200
     2.795   -11.068     0.200
     3.298   -13.409     0.200
     4.268   -22.662     0.200
     4.204   -20.635     0.200
     4.595   -25.027     0.200
     4.859   -30.300     0.200
     1.449    -0.235     0.200
     1.546    -1.007     0.200
     1.674    -0.876     0.200
     1.760     0.121     0.200
     1.197     0.561     0.200
     1.197     2.963     0.200
     1.259     0.407     0.200
     1.335     0.097     0.200
     1.337     3.245     0.200
     1.561     0.043     0.200
     1.751    -0.887     0.200
     1.884    -1.515     0.200
     2.280    -7.647     0.200
     1.023     3.284     0.200
     1.478    -0.460     0.200
     1.604    -0.954     0.200
     2.563   -10.655     0.200
     4.769   -27.676     0.200
     5.210   -31.272     0.200
     1.301     0.637     0.200
     1.301     1.936     0.200
     1.331     0.283     0.200
     1.548    -1.194     0.200
     1.420    -0.124     0.200
     1.509    -0.023     0.200
     1.801    -0.584     0.200
     2.920   -12.857     0.200
     4.924   -24.685     0.200
     1.319    -0.312     0.200
     1.319     1.289     0.200
     1.350    -0.573     0.200
     1.350     0.224     0.200
     1.411    -1.525     0.200
     1.411    -1.322     0.200
     1.420     0.484     0.200
     2.333   -10.555     0.200
     2.309    -7.782     0.200
     2.309    -7.985     0.200
     2.497    -9.557     0.200
     2.721   -10.041     0.200
     2.793   -11.938     0.200
     2.836   -12.806     0.200
     3.163   -14.062     0.200
     3.558   -17.987     0.200
     3.813   -22.072     0.200
     4.753   -28.348     0.200
     4.849   -27.702     0.200
     5.763   -32.281     0.200
     5.763   -32.086     0.200
     6.146   -35.770     0.200
     6.163   -36.247     0.200
     1.398     0.146     0.200
     1.612     0.084     0.200
     1.690    -0.317     0.200
     2.667   -10.566     0.200
     4.468   -25.653     0.200
     4.846   -21.949     0.200
     5.263   -26.767     0.200
     1.378    -0.031     0.200
     1.694     0.050     0.200
     1.882    -0.501     0.200
     1.257     0.664     0.200
     1.287     1.694     0.200
     1.445    -0.197     0.200
     1.600    -0.135     0.200
     1.718     0.034     0.200
     1.804    -0.380     0.200
     2.193    -6.939     0.200
     2.299    -7.576     0.200
     2.443    -8.443     0.200
     2.657   -10.741     0.200
     2.828   -10.644     0.200
     2.909   -12.217     0.200
     3.920   -18.961     0.200
     4.007   -19.726     0.200
     4.167   -22.996     0.200
     4.391   -20.088     0.200
     4.500   -24.866     0.200
     4.846   -26.236     0.200
     5.311   -28.974     0.200
     7.020   -42.528     0.200
     1.255     0.668     0.200
     1.353     0.950     0.200
     1.815    -2.095     0.200
     1.815    -0.496     0.200
     1.857    -2.703     0.200
     1.857    -0.601     0.200
     1.818     0.835     0.200
     2.261    -7.534     0.200
     2.173    -4.541     0.200
     2.643   -10.931     0.200
     2.665    -8.712     0.200
     3.315   -15.312     0.200
     3.315   -14.931     0.200
     4.340   -20.812     0.200
     4.699   -23.510     0.200
     4.869   -28.601     0.200
     5.038   -27.366     0.200
     6.451   -39.254     0.200
     1.293     1.254     0.200
     1.310     0.135     0.200
     1.615    -0.628     0.200
     1.798    -0.434     0.200
     2.186    -6.851     0.200
     2.434    -8.513     0.200
     3.991   -20.475     0.200
     4.374   -19.593     0.200
     4.823   -24.049     0.200
     5.411   -27.740     0.200
     7.008   -43.190     0.200
     8.365   -52.535     0.200
     1.720    -0.553     0.200
     1.804    -0.600     0.200
     1.864    -0.517     0.200
     2.383    -8.260     0.200
     1.270     1.731     0.200
     1.512     0.275     0.200
     1.512     0.072     0.200
     1.734    -0.074     0.200
     1.818    -2.148     0.200
     1.818     0.055     0.200
     1.879    -0.860     0.200
     2.839   -10.494     0.200
     2.786   -10.622     0.200
     3.034   -12.573     0.200
     3.406   -14.671     0.200
     3.495   -13.571     0.200
     4.948   -21.460     0.200
     5.347   -26.699     0.200
     5.848   -29.576     0.200
    14.086   -92.747     0.200
     1.528     0.134     0.200
     1.814    -0.038     0.200
     2.451    -6.436     0.200
     1.467     0.001     0.200
     1.525     0.268     0.200
     1.562    -0.496     0.200
     1.585     0.557     0.200
     1.835     0.350     0.200
     6.794   -40.624     0.200
     1.222    -0.142     0.200
     1.274    -0.094     0.200
     1.365     0.026     0.200
     1.406     0.012     0.200
     1.655     0.029     0.200
     1.861     0.000     0.200
     2.649   -10.294     0.200
     1.270    -0.264     0.200
     1.289     0.238     0.200
     1.420    -0.323     0.200
     1.420     0.076     0.200
     1.593    -0.691     0.200
     2.211    -7.287     0.200
     3.683   -19.362     0.200
     5.379   -28.975     0.200
     7.027   -42.997     0.200
     1.279     1.232     0.200
     1.279     0.732     0.200
     1.383    -0.348     0.200
     1.669    -0.922     0.200
     1.669    -1.223     0.200
     1.292     0.356     0.200
     1.713    -2.994     0.200
     1.713    -0.494     0.200
     1.722     0.239     0.200
     1.730    -1.217     0.200
     2.263    -8.411     0.200
     2.382    -9.184     0.200
     2.382    -8.084     0.200
     2.820   -11.476     0.200
     3.270   -14.518     0.200
     6.575   -40.203     0.200
    13.726   -91.574     0.200
     1.250     3.030     0.200
     1.290     4.265     0.200
     1.575    -0.289     0.200
     1.713    -0.249     0.200
     1.813    -0.017     0.200
     5.360   -24.576     0.200
     1.360     0.905     0.200
     1.536    -0.272     0.200
     1.625    -0.415     0.200
     2.620   -10.132     0.200
     2.871   -11.605     0.200
     1.807     0.391     0.200
     1.074     0.730     0.200
     1.337     1.503     0.200
     2.602    -9.495     0.200
     1.201     3.295     0.200
     1.759     0.494     0.200
     1.894    -0.069     0.200
     2.289    -5.903     0.200
     3.518   -14.866     0.200
     4.309   -22.728     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.216     0.566     0.200
     0.984     0.421     0.200
     1.823    -3.255     0.200
     1.985    -2.303     0.200
     1.902    -2.176     0.200
     3.245    -7.158     0.200
     0.358     1.629     0.200
     0.826    -0.534     0.200
     1.750    -3.805     0.200
     0.240     2.678     0.200
     1.163    -0.585     0.200
     1.281    -1.035     0.200
     0.258     2.899     0.200
     2.368    -5.383     0.200
     0.264     2.267     0.200
     0.997    -0.396     0.200
     1.436    -2.499     0.200
     2.976    -5.720     0.200
     0.327     1.284     0.200
     0.914     0.182     0.200
     1.506    -2.578     0.200
     0.282     1.819     0.200
     0.314     1.540     0.200
     0.916     0.459     0.200
     1.391     0.291     0.200
     1.510    -1.289     0.200
     2.713    -6.224     0.200
     1.530    -1.120     0.200
     5.841   -14.172     0.200
     0.355     1.115     0.200
     0.995     0.011     0.200
     1.401     0.037     0.200
     1.413     0.673     0.200
     0.236     1.444     0.200
     0.569     0.171     0.200
     1.043     0.365     0.200
     1.331     0.522     0.200
     1.331     1.322     0.200
     1.501    -0.662     0.200
     1.501     0.638     0.200
     1.630    -1.143     0.200
     0.146     1.865     0.200
     0.649     1.423     0.200
     0.966    -0.214     0.200
     1.407     0.600     0.200
     0.331     0.838     0.200
     1.021    -0.035     0.200
     1.383     0.494     0.200
     1.464    -0.168     0.200
     2.304    -4.013     0.200
     0.260    -0.269     0.200
     0.260     0.833     0.200
     0.589     0.912     0.200
     1.282     0.923     0.200
     1.282     1.822     0.200
     1.434     0.531     0.200
     0.224     2.165     0.200
     0.934    -1.137     0.200
     0.951     0.429     0.200
     1.528    -1.342     0.200
     0.206     0.866     0.200
     0.767     1.180     0.200
     0.997     0.897     0.200
     0.999     0.852     0.200
     1.045     0.290     0.200
     1.033     0.645     0.200
     1.034     0.643     0.200
     1.358     1.367     0.200
     1.509     0.785     0.200
     2.167     0.411     0.200
     2.360    -0.819     0.200
     0.352     0.664     0.200
     0.471     0.775     0.200
     0.984    -0.082     0.200
     1.437    -0.243     0.200
     1.437    -0.043     0.200
     0.296    -0.024     0.200
     0.560     0.892     0.200
     1.123     0.057     0.200
     1.250     0.847     0.200
     1.250     0.250     0.200
     1.575     0.440     0.200
     2.644    -4.861     0.200
     0.118     2.018     0.200
     0.669     1.049     0.200
     0.906    -0.557     0.200
     1.166     1.306     0.200
     1.247     0.039     0.200
     1.976    -0.388     0.200
     0.258     0.178     0.200
     0.548     1.077     0.200
     0.548     1.178     0.200
     1.060     0.942     0.200
     1.038     1.545     0.200
     1.162     0.523     0.200
     1.314    -0.010     0.200
     0.215     1.104     0.200
     0.982    -0.115     0.200
     1.121     1.573     0.200
     1.236     0.728     0.200
     1.960    -0.499     0.200
     0.235     2.483     0.200
     0.630     0.159     0.200
     0.872     0.788     0.200
     1.743    -3.529     0.200
     1.743    -1.427     0.200
     1.920    -1.332     0.200
     1.949    -1.465     0.200
     0.247     1.797     0.200
     0.920    -0.259     0.200
     0.985     0.799     0.200
     1.105     0.676     0.200
     0.094     4.677     0.200
     0.698     1.246     0.200
     0.698     0.845     0.200
     0.923    -0.298     0.200
     1.934    -0.244     0.200
     0.212     2.489     0.200
     0.918    -1.680     0.200
     0.949     0.247     0.200
     1.110    -0.379     0.200
     1.143     0.194     0.200
     0.328     0.955     0.200
     1.182     0.080     0.200
     0.206     0.524     0.200
     0.598     0.922     0.200
     0.598     1.222     0.200
     1.020    -0.770     0.200
     1.353     0.184     0.200
     1.353     0.286     0.200
     0.259     1.927     0.200
     0.259     2.427     0.200
     0.648     0.907     0.200
     1.025    -0.350     0.200
     1.163    -1.124     0.200
     1.407    -2.146     0.200
     1.407    -1.646     0.200
     1.482    -1.246     0.200
     2.313    -6.087     0.200
     0.302     1.260     0.200
     0.533     1.147     0.200
     0.929    -0.721     0.200
     1.379     0.415     0.200
     1.479     0.457     0.200
     0.245     0.565     0.200
     0.245     1.166     0.200
     0.641     1.906     0.200
     1.308    -0.125     0.200
     0.347    -0.186     0.200
     0.347     0.916     0.200
     0.503     2.158     0.200
     2.308    -5.353     0.200
     0.108     3.788     0.200
     0.108     3.386     0.200
     0.807     1.024     0.200
     1.440    -1.515     0.200
     1.954    -3.031     0.200
     1.954    -1.031     0.200
     0.328     0.701     0.200
     0.456     0.842     0.200
     0.761     1.573     0.200
     0.895     0.230     0.200
     1.079     1.602     0.200
     1.079     1.000     0.200
     1.303     0.015     0.200
     1.303     0.402     0.200
     1.342     0.463     0.200
     0.226     2.904     0.200
     0.643    -1.024     0.200
     0.938     1.523     0.200
     1.059    -0.098     0.200
     1.201    -0.421     0.200
     1.386    -2.076     0.200
     0.311     1.556     0.200
     0.540     0.886     0.200
     0.540     1.081     0.200
     0.914    -0.048     0.200
     0.914     0.053     0.200
     1.265     1.907     0.200
     0.751    -0.194     0.200
     0.751     0.106     0.200
     0.752     0.950     0.200
     0.752     1.050     0.200
     0.798     0.699     0.200
     1.624    -0.284     0.200
     0.171     1.248     0.200
     0.739     0.857     0.200
     0.739     1.158     0.200
     0.761    -0.547     0.200
     0.761    -0.149     0.200
     0.795     0.362     0.200
     1.392    -0.466     0.200
     1.392     1.937     0.200
     1.614    -0.202     0.200
     0.072     4.231     0.200
     0.814     1.695     0.200
     2.009    -4.398     0.200
     0.338     0.863     0.200
     0.824     1.058     0.200
     0.928    -0.633     0.200
     1.414     0.544     0.200
     1.414     1.442     0.200
     1.495    -0.204     0.200
     1.495     0.898     0.200
     0.208     1.596     0.200
     0.581     1.476     0.200
     0.581     1.676     0.200
     0.669     1.066     0.200
     0.955     0.015     0.200
     0.955    -0.684     0.200
     1.265     0.192     0.200
     1.989    -0.159     0.200
     0.151     0.735     0.200
     0.648     1.086     0.200
     0.974    -0.442     0.200
     1.179     0.645     0.200
     1.399     0.272     0.200
     0.130     1.994     0.200
     0.656     1.100     0.200
     0.656     0.901     0.200
     0.925    -0.720     0.200
     0.925    -0.618     0.200
     1.148     0.631     0.200
     1.232     0.348     0.200
     0.289     1.263     0.200
     0.467     0.337     0.200
     0.657     1.189     0.200
     0.657     0.588     0.200
     0.740     1.175     0.200
     1.075     1.253     0.200
     1.314    -0.538     0.200
     0.153     0.815     0.200
     0.586     1.114     0.200
     0.644     1.170     0.200
     0.644     1.369     0.200
     0.973    -0.368     0.200
     0.973    -0.669     0.200
     1.096     1.833     0.200
     1.400    -0.097     0.200
     0.176     1.528     0.200
     0.889     0.630     0.200
     1.097     0.327     0.200
     1.108     2.398     0.200
     1.392     0.294     0.200
     1.491     0.137     0.200
     0.294     0.860     0.200
     0.468    -0.068     0.200
     0.652     1.408     0.200
     0.652     0.814     0.200
     0.652     1.509     0.200
     0.740     2.025     0.200
     0.863     0.015     0.200
     1.072     0.989     0.200
     1.211    -0.222     0.200
     1.278    -0.124     0.200
     1.316    -0.440     0.200
     0.320     1.449     0.200
     0.466     0.321     0.200
     1.172    -0.761     0.200
     1.172    -0.461     0.200
     1.257    -0.139     0.200
     1.257    -0.038     0.200
     0.161     1.379     0.200
     0.636     1.621     0.200
     0.636     1.426     0.200
     0.586     1.109     0.200
     0.978    -0.131     0.200
     0.978    -0.029     0.200
     1.093     1.232     0.200
     1.394    -0.026     0.200
     1.394     0.779     0.200
     0.157     1.142     0.200
     0.575     1.089     0.200
     0.645     1.378     0.200
     0.645     1.182     0.200
     0.981    -0.385     0.200
     1.086     1.890     0.200
     1.392     0.701     0.200
     1.501     0.331     0.200
     2.763    -6.156     0.200
     3.054    -5.070     0.200
     0.168     0.454     0.200
     0.631     1.291     0.200
     0.631     1.088     0.200
     0.986    -0.463     0.200
     0.986    -0.361     0.200
     1.087     1.431     0.200
     1.387     0.408     0.200
     1.509    -0.357     0.200
     2.566    -5.475     0.200
     0.164     0.976     0.200
     0.577     1.177     0.200
     0.637     1.269     0.200
     0.637     1.167     0.200
     0.985    -0.356     0.200
     0.985    -0.060     0.200
     1.085     1.576     0.200
     1.504     0.195     0.200
     2.572    -5.067     0.200
     0.148     0.521     0.200
     0.588     1.064     0.200
     0.648     1.477     0.200
     1.100     1.537     0.200
     1.186     0.615     0.200
     1.405     0.580     0.200
     2.776    -5.677     0.200
     0.143     0.750     0.200
     0.593     1.176     0.200
     0.652     1.428     0.200
     0.962    -0.502     0.200
     1.106     0.607     0.200
     1.191     0.024     0.200
     1.411     0.041     0.200
     1.518     0.449     0.200
     3.958    -6.078     0.200
     0.164     0.055     0.200
     0.573     1.110     0.200
     0.638     1.129     0.200
     0.638     1.028     0.200
     1.081     1.492     0.200
     1.170     0.670     0.200
     1.385     0.754     0.200
     1.500     0.332     0.200
     0.155     0.293     0.200
     0.578     1.107     0.200
     0.645     1.160     0.200
     0.645     0.961     0.200
     1.394    -0.081     0.200
     1.394     1.119     0.200
     1.504     0.349     0.200
     5.305   -10.246     0.200
     0.170    -0.301     0.200
     0.564     0.618     0.200
     0.637     0.889     0.200
     1.377     1.043     0.200
     1.491     0.831     0.200
     0.163     0.748     0.200
     0.637     1.111     0.200
     0.984    -0.667     0.200
     1.389    -0.029     0.200
     0.152     0.372     0.200
     0.613     0.758     0.200
     0.637     0.614     0.200
     0.955    -0.289     0.200
     1.120     1.993     0.200
     1.417     0.263     0.200
     0.156     0.748     0.200
     0.595     0.610     0.200
     0.638     1.067     0.200
     0.969    -0.435     0.200
     1.103     0.813     0.200
     1.404     0.086     0.200
     1.522    -0.358     0.200
     2.555    -5.602     0.200
     6.874   -20.909     0.200
     0.241     0.581     0.200
     0.241     1.175     0.200
     0.630     2.360     0.200
     0.124     3.702     0.200
     0.801    -0.177     0.200
     0.801     0.026     0.200
     0.909     0.598     0.200
     0.909     0.496     0.200
     1.740    -0.639     0.200
     1.972    -0.784     0.200
     0.167    -0.083     0.200
     0.167     0.713     0.200
     0.633     0.740     0.200
     0.633     1.040     0.200
     0.986    -0.250     0.200
     1.086     1.186     0.200
     1.387     0.632     0.200
     1.507    -0.162     0.200
     0.334     0.806     0.200
     0.482     1.026     0.200
     0.982    -0.525     0.200
     1.208     1.890     0.200
     2.369    -3.811     0.200
     2.790    -4.451     0.200
     0.344     1.210     0.200
     0.858    -0.192     0.200
     0.827     0.898     0.200
     0.827     0.695     0.200
     1.340    -0.570     0.200
     1.356    -0.663     0.200
     2.734    -5.466     0.200
     0.332     0.948     0.200
     0.641     0.333     0.200
     0.978    -0.047     0.200
     1.388     0.263     0.200
     1.427    -0.578     0.200
     1.452    -0.145     0.200
     0.151     0.276     0.200
     0.646     0.875     0.200
     0.646     0.977     0.200
     0.971    -0.111     0.200
     1.402    -0.301     0.200
     1.402    -0.102     0.200
     1.513    -0.098     0.200
     0.150     0.633     0.200
     0.650     0.772     0.200
     0.974    -0.501     0.200
     1.092     1.468     0.200
     1.399    -0.654     0.200
     1.399     0.947     0.200
     0.157     1.911     0.200
     0.645     1.327     0.200
     0.982    -0.631     0.200
     0.308     1.652     0.200
     0.609     0.804     0.200
     0.835    -0.138     0.200
     1.337     0.748     0.200
     1.884    -3.493     0.200
     1.997    -1.892     0.200
     1.997    -1.594     0.200
     0.164     0.394     0.200
     0.634     0.978     0.200
     0.634     1.173     0.200
     0.982    -0.739     0.200
     0.982    -0.239     0.200
     1.090     1.439     0.200
     1.391     0.583     0.200
     1.510     0.115     0.200
     0.163     0.811     0.200
     0.637     1.070     0.200
     0.984    -0.514     0.200
     0.984     0.290     0.200
     1.086     0.941     0.200
     1.389     0.838     0.200
     2.571    -4.623     0.200
     0.137     2.694     0.200
     0.782     1.959     0.200
     1.313    -0.188     0.200
     1.402    -1.217     0.200
     2.313    -4.076     0.200
     2.313    -6.076     0.200
     0.168     0.601     0.200
     0.633     1.266     0.200
     0.633     0.969     0.200
     0.988    -0.386     0.200
     1.084     1.773     0.200
     1.385     0.111     0.200
     1.505     0.117     0.200
     3.052    -4.831     0.200
     5.294   -10.181     0.200
     0.166     0.189     0.200
     0.631     1.352     0.200
     0.983    -0.394     0.200
     0.983    -0.094     0.200
     1.090     1.308     0.200
     1.390     0.993     0.200
     3.936    -6.009     0.200
     0.200     0.738     0.200
     0.586     1.081     0.200
     0.586     1.183     0.200
     0.966    -0.652     0.200
     1.133     1.461     0.200
     1.410     0.374     0.200
     2.497    -5.270     0.200
     0.187     0.845     0.200
     0.600     0.958     0.200
     0.950    -0.843     0.200
     1.146     0.852     0.200
     1.426    -0.318     0.200
     1.977    -0.384     0.200
     0.211     0.165     0.200
     0.576     1.386     0.200
     0.576     0.486     0.200
     1.127     1.406     0.200
     1.401    -0.085     0.200
     2.992    -4.704     0.200
     0.191     1.268     0.200
     0.595     1.141     0.200
     0.595     1.241     0.200
     0.965    -0.384     0.200
     1.129     1.343     0.200
     2.201    -1.963     0.200
     2.201    -1.363     0.200
     0.199     0.989     0.200
     0.588     1.150     0.200
     0.588     1.251     0.200
     0.960    -0.736     0.200
     0.960    -0.236     0.200
     1.974     0.407     0.200
     0.195     0.932     0.200
     0.591     0.984     0.200
     0.591     1.184     0.200
     0.964    -0.345     0.200
     1.133     0.820     0.200
     1.411    -0.022     0.200
     2.500    -4.415     0.200
     0.193     0.773     0.200
     0.594     0.756     0.200
     0.960    -0.668     0.200
     1.136     0.474     0.200
     1.415     0.119     0.200
     2.498    -4.100     0.200
     5.301   -10.858     0.200
     0.146     1.417     0.200
     0.651     0.914     0.200
     0.968    -0.538     0.200
     0.968    -0.335     0.200
     0.968     0.865     0.200
     1.099    -0.087     0.200
     1.405    -0.086     0.200
     1.912     0.037     0.200
     0.277     0.604     0.200
     0.532     1.122     0.200
     0.532     0.923     0.200
     1.026     1.747     0.200
     1.078    -0.874     0.200
     1.078    -0.975     0.200
     1.298     0.150     0.200
     1.298     0.049     0.200
     0.632     1.405     0.200
     0.632     1.506     0.200
     0.972    -0.073     0.200
     0.972    -0.268     0.200
     1.103     1.667     0.200
     1.401     0.114     0.200
     1.401    -0.089     0.200
     1.524     0.209     0.200
     2.552    -5.356     0.200
     0.627     1.134     0.200
     0.627     1.430     0.200
     0.979    -0.634     0.200
     0.979    -0.533     0.200
     1.096     1.969     0.200
     1.394    -0.168     0.200
     0.306     0.677     0.200
     0.502     1.454     0.200
     0.576     1.440     0.200
     1.018     2.015     0.200
     1.099    -0.154     0.200
     0.276     0.604     0.200
     0.772     0.385     0.200
     0.834     0.193     0.200
     0.860     1.786     0.200
     0.892     0.956     0.200
     1.423     1.429     0.200
     1.588    -0.900     0.200
     1.810    -0.940     0.200
     0.176     0.610     0.200
     0.569     0.729     0.200
     0.629     1.156     0.200
     0.998    -0.539     0.200
     0.998    -0.641     0.200
     1.074     0.939     0.200
     1.375     0.482     0.200
     2.578    -5.830     0.200
     2.578    -5.631     0.200
     0.286     1.000     0.200
     0.515     1.154     0.200
     0.729     1.472     0.200
     0.973    -0.788     0.200
     0.171     1.480     0.200
     0.597     0.882     0.200
     0.622     1.498     0.200
     0.979    -0.127     0.200
     0.979    -0.525     0.200
     1.098     1.088     0.200
     1.194     0.256     0.200
     1.921     0.118     0.200
     0.344     1.070     0.200
     0.576     0.708     0.200
     0.667     1.511     0.200
     0.958     0.797     0.200
     0.958     0.899     0.200
     1.212     0.549     0.200
     1.255     1.083     0.200
     6.859   -21.886     0.200
     0.173     4.408     0.200
     0.699     1.133     0.200
     0.764     0.080     0.200
     0.960     0.786     0.200
     1.776    -0.488     0.200
     1.898    -0.373     0.200
     1.999    -0.555     0.200
     2.122    -5.772     0.200
     2.122    -5.373     0.200
     0.321     0.601     0.200
     0.602     0.701     0.200
     0.620     1.031     0.200
     0.632     1.365     0.200
     0.933     1.220     0.200
     1.219     1.150     0.200
     2.701    -5.217     0.200
     0.426     1.406     0.200
     0.435     0.740     0.200
     0.545     0.932     0.200
     0.918     1.930     0.200
     1.149    -0.710     0.200
     1.149     0.392     0.200
     1.233    -0.551     0.200
     0.144     1.753     0.200
     0.582     1.061     0.200
     0.656     1.231     0.200
     0.656     1.131     0.200
     0.969     0.109     0.200
     0.969    -0.491     0.200
     1.180     0.508     0.200
     1.405     0.776     0.200
     2.776    -5.684     0.200
     4.870    -9.163     0.200
     6.673   -16.014     0.200
     0.160     0.977     0.200
     0.572     1.105     0.200
     0.644     1.630     0.200
     0.644     1.529     0.200
     0.985    -0.176     0.200
     1.170     1.058     0.200
     1.389     0.921     0.200
     1.658    -1.023     0.200
     3.057    -5.551     0.200
     5.300   -13.164     0.200
     5.495   -15.049     0.200
     0.156     1.257     0.200
     0.575     1.057     0.200
     0.646     1.921     0.200
     0.646     1.620     0.200
     0.980     0.022     0.200
     1.173     0.711     0.200
     1.393     1.045     0.200
     1.501     0.303     0.200
     5.522   -15.252     0.200
     0.156     0.414     0.200
     0.567     0.983     0.200
     0.651     1.001     0.200
     0.651     0.899     0.200
     0.985    -0.365     0.200
     0.985    -0.467     0.200
     1.164     0.034     0.200
     1.389    -0.794     0.200
     2.585    -4.198     0.200
     0.289     2.397     0.200
     0.621     0.050     0.200
     0.621    -0.450     0.200
     0.840     0.636     0.200
     0.840     0.933     0.200
     1.871    -2.373     0.200
     1.871    -2.068     0.200
     0.073     4.238     0.200
     0.671     0.570     0.200
     0.723     0.925     0.200
     0.857     0.084     0.200
     0.857    -0.316     0.200
     1.999    -0.546     0.200
     0.321     0.939     0.200
     0.430    -0.205     0.200
     0.639     1.253     0.200
     0.780     1.304     0.200
     1.107     0.921     0.200
     1.277    -0.768     0.200
     0.323     0.888     0.200
     0.431    -0.020     0.200
     0.431     1.879     0.200
     0.637     1.658     0.200
     0.780     1.420     0.200
     0.900     0.412     0.200
     1.106     0.578     0.200
     1.278    -0.376     0.200
     1.942    -1.027     0.200
     7.316   -23.488     0.200
     0.331     1.938     0.200
     0.501     0.829     0.200
     0.629     0.473     0.200
     0.955     1.363     0.200
     1.141    -0.562     0.200
     1.169     0.279     0.200
     1.856    -0.308     0.200
     2.574    -7.486     0.200
     7.229   -23.423     0.200
     0.174     2.809     0.200
     0.719    -0.180     0.200
     0.813     1.030     0.200
     0.788     1.340     0.200
     0.788     1.442     0.200
     1.921    -2.676     0.200
     1.921    -1.575     0.200
     1.989    -1.923     0.200
     1.967    -1.150     0.200
     0.311     0.941     0.200
     0.642     0.944     0.200
     0.788     0.519     0.200
     0.903     0.884     0.200
     1.183     0.696     0.200
     4.582   -12.427     0.200
     0.190     1.914     0.200
     0.585     0.778     0.200
     0.608     0.564     0.200
     0.608     1.462     0.200
     0.999    -0.255     0.200
     1.181     0.177     0.200
     1.907    -0.625     0.200
     0.194     1.250     0.200
     0.588     0.766     0.200
     0.602     1.198     0.200
     1.001    -0.236     0.200
     1.184     0.071     0.200
     0.145     1.629     0.200
     0.628     0.630     0.200
     0.642     1.277     0.200
     0.940    -0.786     0.200
     1.225     0.581     0.200
     1.953    -0.300     0.200
     0.162     0.950     0.200
     0.573     0.931     0.200
     0.641     1.152     0.200
     0.986    -0.277     0.200
     1.170     0.488     0.200
     1.387     0.411     0.200
     2.577    -5.413     0.200
     3.056    -6.204     0.200
     0.166     0.811     0.200
     0.570     0.697     0.200
     0.638     1.033     0.200
     0.990    -0.517     0.200
     1.168     0.456     0.200
     1.383     0.230     0.200
     4.332   -11.863     0.200
     4.848    -9.597     0.200
     0.343     2.022     0.200
     0.620     0.750     0.200
     0.698     0.552     0.200
     0.922     0.249     0.200
     0.922     1.349     0.200
     1.827    -0.937     0.200
     2.729    -6.711     0.200
     3.338    -8.611     0.200
     7.111   -20.520     0.200
     0.159     0.947     0.200
     0.571     1.196     0.200
     0.645     1.238     0.200
     0.985    -0.038     0.200
     1.082     1.093     0.200
     1.388    -0.922     0.200
     2.580    -5.485     0.200
     3.935    -6.557     0.200
     0.167     0.891     0.200
     0.575     1.351     0.200
     0.635     1.431     0.200
     0.988    -0.054     0.200
     0.988    -0.156     0.200
     1.082     1.579     0.200
     1.385     0.277     0.200
     1.385    -0.419     0.200
     1.502    -0.536     0.200
     0.273     1.603     0.200
     0.538     1.789     0.200
     0.746     1.111     0.200
     0.943    -0.630     0.200
     0.181     0.622     0.200
     0.470     1.483     0.200
     0.817     1.255     0.200
     1.001    -0.651     0.200
     1.365     0.490     0.200
     1.413     0.076     0.200
     0.114     2.780     0.200
     0.588     1.652     0.200
     0.684     1.411     0.200
     0.946    -0.474     0.200
     2.573    -5.668     0.200
     0.069     4.524     0.200
     0.685     0.618     0.200
     0.736     0.575     0.200
     0.838     0.144     0.200
     1.221    -0.275     0.200
     1.746    -1.537     0.200
     0.448     0.916     0.200
     0.662     1.143     0.200
     1.094     1.032     0.200
     1.094     0.231     0.200
     1.216     1.373     0.200
     1.292     1.565     0.200
     1.296     0.339     0.200
     1.296    -0.060     0.200
     1.333     2.271     0.200
     0.306     0.460     0.200
     0.415     0.412     0.200
     1.152     0.064     0.200
     1.152    -0.337     0.200
     1.227     0.964     0.200
     1.345     0.219     0.200
     1.442     1.055     0.200
     2.070     0.051     0.200
     0.309    -0.029     0.200
     0.391     0.974     0.200
     0.657     1.051     0.200
     0.896     0.375     0.200
     1.227     1.083     0.200
     1.321     0.184     0.200
     1.427     0.652     0.200
     1.513     0.015     0.200
     0.303     0.196     0.200
     0.397     0.806     0.200
     0.656     1.321     0.200
     0.903     1.094     0.200
     1.150    -0.364     0.200
     1.233     0.431     0.200
     1.328     0.217     0.200
     2.069    -4.291     0.200
     0.176     0.500     0.200
     0.586     0.893     0.200
     0.989    -0.068     0.200
     0.989    -0.264     0.200
     1.087     0.908     0.200
     1.384     0.297     0.200
     1.384    -0.297     0.200
     1.514     0.077     0.200
     1.624     0.798     0.200
     0.164     0.924     0.200
     0.571     0.918     0.200
     0.640     1.231     0.200
     0.988    -0.107     0.200
     1.385     0.320     0.200
     1.498    -0.157     0.200
     0.588     0.636     0.200
     0.880     0.856     0.200
     0.943    -0.135     0.200
     0.295     2.208     0.200
     0.586     0.492     0.200
     0.586    -1.008     0.200
     0.886     0.668     0.200
     0.886     0.770     0.200
     0.939     0.477     0.200
     1.859    -2.284     0.200
     1.859    -3.484     0.200
     1.789    -3.069     0.200
     0.431     1.276     0.200
     0.489     0.928     0.200
     0.512     0.611     0.200
     1.081    -1.428     0.200
     1.081    -0.128     0.200
     1.299    -0.928     0.200
     1.962    -0.870     0.200
     2.687    -4.438     0.200
     4.080    -7.488     0.200
     0.270     1.493     0.200
     0.766    -0.149     0.200
     1.055     1.100     0.200
     1.708    -2.604     0.200
     1.919    -0.177     0.200
     1.986    -0.501     0.200
     0.145     1.105     0.200
     0.573     0.945     0.200
     0.659     1.791     0.200
     0.974    -0.489     0.200
     0.974    -0.286     0.200
     1.089     0.961     0.200
     1.400    -0.175     0.200
     1.497    -0.165     0.200
     0.282     2.166     0.200
     0.597     0.090     0.200
     0.927     0.536     0.200
     1.778    -3.531     0.200
     1.872    -1.724     0.200
     1.995    -0.638     0.200
     4.317    -7.825     0.200
     4.319    -8.898     0.200
     0.158     1.011     0.200
     0.570     0.926     0.200
     0.647     2.000     0.200
     0.984    -0.689     0.200
     1.082     0.796     0.200
     1.389     0.168     0.200
     1.496    -0.231     0.200
     2.580    -5.789     0.200
     0.151     0.413     0.200
     0.571     0.999     0.200
     0.654     1.584     0.200
     0.979    -0.241     0.200
     1.086     1.690     0.200
     1.394     0.502     0.200
     2.581    -6.120     0.200
     0.276     0.597     0.200
     0.411     0.230     0.200
     0.705    -0.109     0.200
     0.729     2.238     0.200
     0.768     1.084     0.200
     0.875     0.595     0.200
     1.288     1.306     0.200
     1.431    -0.212     0.200
     1.665    -0.742     0.200
     2.105    -0.398     0.200
     2.295    -1.099     0.200
     0.310     0.477     0.200
     0.409     2.231     0.200
     0.493     0.872     0.200
     0.740     1.025     0.200
     0.986    -0.770     0.200
     1.184     0.879     0.200
     1.417    -0.209     0.200
     0.361     2.407     0.200
     0.719    -0.050     0.200
     0.964     0.878     0.200
     1.874    -1.456     0.200
     2.069    -4.939     0.200
     0.343     0.321     0.200
     0.503     1.156     0.200
     0.939     2.032     0.200
     1.162    -0.246     0.200
     1.211     0.504     0.200
     0.219     0.862     0.200
     0.342     0.550     0.200
     0.495     0.496     0.200
     0.594     1.072     0.200
     0.736     1.679     0.200
     1.038     1.576     0.200
     1.283     0.434     0.200
     1.339     0.037     0.200
     1.320     0.452     0.200
     0.212     1.379     0.200
     0.534     1.266     0.200
     1.041    -0.201     0.200
     1.031     1.808     0.200
     1.333     0.241     0.200
     1.333     1.343     0.200
     0.120     3.512     0.200
     0.675     0.735     0.200
     0.884    -0.489     0.200
     0.299     0.848     0.200
     0.448     0.124     0.200
     0.758     1.785     0.200
     1.093     0.885     0.200
     1.296    -0.750     0.200
     1.296    -0.649     0.200
     1.924    -0.553     0.200
     3.367    -5.924     0.200
     0.309     0.633     0.200
     0.442     0.424     0.200
     0.766     1.135     0.200
     1.097     0.950     0.200
     1.289    -0.444     0.200
     1.930    -1.062     0.200
     0.297     2.098     0.200
     0.637    -0.463     0.200
     0.679     0.908     0.200
     0.816     0.644     0.200
     0.936     1.266     0.200
     0.124     3.079     0.200
     0.452     1.485     0.200
     0.555     2.145     0.200
     0.691     1.327     0.200
     0.711     1.097     0.200
     0.847    -0.119     0.200
     1.763    -0.253     0.200
     0.168     0.569     0.200
     0.331     1.106     0.200
     0.439     1.976     0.200
     0.587     0.672     0.200
     0.628     0.866     0.200
     0.982    -0.046     0.200
     1.092     0.790     0.200
     1.390     0.313     0.200
     1.515    -0.226     0.200
     2.122     0.726     0.200
     0.201     1.955     0.200
     0.320     0.681     0.200
     0.408     0.080     0.200
     0.463     0.838     0.200
     0.518     0.710     0.200
     1.160     0.855     0.200
     1.217    -0.068     0.200
     1.500     0.973     0.200
     1.517    -0.458     0.200
     2.036    -0.614     0.200
     2.644    -5.084     0.200
     4.149    -9.595     0.200
     5.459   -15.733     0.200
     0.158     2.903     0.200
     0.736     0.968     0.200
     0.807     0.520     0.200
     0.994     0.182     0.200
     1.306    -0.610     0.200
     1.315    -0.377     0.200
     0.316     2.057     0.200
     0.624     1.378     0.200
     0.815    -0.452     0.200
     0.626     1.620     0.200
     0.880     0.966     0.200
     1.905    -0.315     0.200
     5.034   -11.609     0.200
     0.325     1.841     0.200
     0.636     1.084     0.200
     0.639     0.987     0.200
     0.802    -0.479     0.200
     0.895     0.770     0.200
     1.921    -0.148     0.200
     1.959    -1.351     0.200
     1.984    -2.652     0.200
     1.984    -0.652     0.200
     0.321     1.997     0.200
     0.616     0.861     0.200
     0.624     1.109     0.200
     0.825    -0.872     0.200
     0.879     0.909     0.200
     1.981    -1.822     0.200
     1.963    -0.240     0.200
     5.415   -13.893     0.200
     0.184     0.369     0.200
     0.325     0.887     0.200
     0.580     0.495     0.200
     1.375    -0.203     0.200
     0.202     1.488     0.200
     0.401     1.167     0.200
     0.585     1.358     0.200
     0.655     0.818     0.200
     0.961    -0.083     0.200
     0.961    -0.483     0.200
     1.140     0.249     0.200
     1.415    -0.177     0.200
     1.975    -0.922     0.200
     0.194     2.130     0.200
     0.734     1.516     0.200
     0.066     4.192     0.200
     0.788     1.612     0.200
     0.329     1.513     0.200
     0.346     0.870     0.200
     0.346     1.073     0.200
     0.453     0.885     0.200
     0.563     1.489     0.200
     0.785     0.663     0.200
     1.108    -0.375     0.200
     1.108     1.727     0.200
     1.159     0.996     0.200
     1.339    -0.200     0.200
     2.052     0.111     0.200
     0.255     0.624     0.200
     0.302     2.128     0.200
     0.300     0.695     0.200
     0.635     0.885     0.200
     0.647     2.005     0.200
     0.961     1.249     0.200
     1.173     0.024     0.200
     1.195     0.230     0.200
     1.232     0.962     0.200
     1.260     0.877     0.200
     1.423    -1.290     0.200
     0.128     3.030     0.200
     0.307     1.653     0.200
     0.733     1.129     0.200
     0.820     1.493     0.200
     0.920     0.415     0.200
     0.920     0.915     0.200
     1.376    -0.653     0.200
     1.370     0.162     0.200
     1.398     0.374     0.200
     1.477    -0.962     0.200
     1.509    -1.860     0.200
     1.509    -1.657     0.200
     3.421    -5.573     0.200
     3.896    -6.915     0.200
     0.279     1.049     0.200
     0.456     0.932     0.200
     0.331     0.779     0.200
     1.145    -0.298     0.200
     1.145     0.304     0.200
     1.290     0.399     0.200
     1.659     0.393     0.200
     2.127    -1.730     0.200
     2.191    -0.568     0.200
     2.267    -1.870     0.200
     2.424    -3.556     0.200
     0.301     1.328     0.200
     0.488    -0.175     0.200
     0.627     1.096     0.200
     1.049     1.231     0.200
     1.220     0.104     0.200
     1.220     1.799     0.200
     1.272     0.268     0.200
     1.272     1.666     0.200
     1.334    -0.821     0.200
     1.310     0.140     0.200
     0.280     0.948     0.200
     0.328     1.009     0.200
     0.328     0.408     0.200
     0.459     1.267     0.200
     1.110     1.915     0.200
     1.146     0.109     0.200
     1.291     0.807     0.200
     1.670     0.486     0.200
     2.129    -1.360     0.200
     2.192    -1.170     0.200
     2.192    -0.975     0.200
     2.266    -1.601     0.200
     2.266    -1.805     0.200
     0.320     1.163     0.200
     0.287     1.487     0.200
     0.470     0.110     0.200
     0.548     0.726     0.200
     0.762     0.651     0.200
     1.147    -0.548     0.200
     1.296    -0.399     0.200
     1.296     1.198     0.200
     1.681    -0.997     0.200
     1.676    -1.545     0.200
     0.131     2.473     0.200
     0.434     1.474     0.200
     0.528     2.185     0.200
     0.692     0.691     0.200
     0.670     1.196     0.200
     0.670     1.298     0.200
     0.873    -0.149     0.200
     0.873    -0.047     0.200
     1.206     1.689     0.200
     1.500    -0.425     0.200
     2.125    -3.738     0.200
     0.336     1.369     0.200
     0.459     0.758     0.200
     0.557     0.839     0.200
     0.776     0.605     0.200
     1.122    -0.273     0.200
     1.145     0.312     0.200
     1.145     2.210     0.200
     1.323    -0.026     0.200
     0.253     2.389     0.200
     0.383     0.946     0.200
     0.448     0.304     0.200
     0.537     1.190     0.200
     0.876     1.529     0.200
     1.158     0.700     0.200
     1.370    -0.424     0.200
     0.261     1.811     0.200
     0.443     0.840     0.200
     0.448     0.572     0.200
     0.561     0.800     0.200
     0.588     2.516     0.200
     0.730     0.839     0.200
     1.149     0.234     0.200
     1.174     0.948     0.200
     1.220    -0.219     0.200
     1.565    -0.534     0.200
     0.186     1.679     0.200
     0.337     0.796     0.200
     0.419     0.690     0.200
     0.518     0.557     0.200
     0.589     0.110     0.200
     0.702     1.722     0.200
     0.951     0.542     0.200
     1.260     0.328     0.200
     1.277    -0.103     0.200
     1.302     0.300     0.200
     1.422    -0.901     0.200
     0.298     1.611     0.200
     0.496     1.740     0.200
     0.553     1.431     0.200
     0.552     1.056     0.200
     0.904    -0.897     0.200
     1.266     0.233     0.200
     0.135     2.298     0.200
     0.491     2.217     0.200
     0.530     1.080     0.200
     0.711     0.959     0.200
     0.982    -0.465     0.200
     1.067     0.858     0.200
     1.399     0.253     0.200
     2.631    -6.314     0.200
     0.242     2.223     0.200
     0.622    -0.121     0.200
     0.634     1.090     0.200
     0.778     1.822     0.200
     0.879     1.126     0.200
     0.886     0.615     0.200
     1.956    -0.026     0.200
     0.088     3.775     0.200
     0.829     1.099     0.200
     1.372    -1.036     0.200
     0.180     0.836     0.200
     0.270     0.977     0.200
     0.512    -0.071     0.200
     0.664     0.684     0.200
     0.696     0.994     0.200
     1.032     1.633     0.200
     1.177     0.424     0.200
     1.274     0.955     0.200
     1.312     0.560     0.200
     1.359    -0.847     0.200
     0.183     1.859     0.200
     0.333     1.005     0.200
     0.420     0.540     0.200
     0.515     0.728     0.200
     0.581     0.032     0.200
     0.709     1.777     0.200
     0.958     0.577     0.200
     1.267     0.292     0.200
     1.282    -0.167     0.200
     1.299     0.672     0.200
     1.414    -0.572     0.200
     0.121     3.017     0.200
     0.327     2.202     0.200
     0.678     1.662     0.200
     0.678     0.762     0.200
     0.678     1.961     0.200
     0.952    -0.113     0.200
     0.952    -0.613     0.200
     1.108     1.122     0.200
     1.913     0.022     0.200
     0.329     1.115     0.200
     0.329     1.912     0.200
     0.718     0.591     0.200
     0.825     1.604     0.200
     0.885     0.500     0.200
     0.834     0.904     0.200
     0.834     1.107     0.200
     1.329     0.625     0.200
     1.380     0.008     0.200
     0.115     3.051     0.200
     0.497     2.251     0.200
     0.624     0.833     0.200
     0.672     1.304     0.200
     0.924    -0.284     0.200
     1.951    -0.652     0.200
     0.284     1.204     0.200
     0.329     2.283     0.200
     0.487     0.470     0.200
     0.655     0.947     0.200
     0.721     1.676     0.200
     1.054     1.215     0.200
     1.299     0.944     0.200
     1.337     1.245     0.200
     0.251     1.058     0.200
     0.355     2.439     0.200
     0.548     1.237     0.200
     0.567     1.429     0.200
     1.065    -0.573     0.200
     1.023     1.084     0.200
     1.308    -0.453     0.200
     1.861    -0.402     0.200
     0.733     1.042     0.200
     1.373    -0.644     0.200
     0.290     0.807     0.200
     0.312     2.112     0.200
     0.573     0.825     0.200
     0.646     1.435     0.200
     0.645     0.768     0.200
     0.965     0.897     0.200
     1.166    -0.156     0.200
     1.230    -0.077     0.200
     0.088     4.719     0.200
     0.793     1.664     0.200
     2.608    -7.058     0.200
     0.257     0.834     0.200
     0.403     1.982     0.200
     0.532     1.007     0.200
     0.681     0.678     0.200
     0.681     1.578     0.200
     0.987    -0.722     0.200
     1.143     0.634     0.200
     1.993    -0.605     0.200
     2.456    -5.671     0.200
     5.263   -12.167     0.200
     0.088     3.057     0.200
     0.420     1.020     0.200
     0.512     0.512     0.200
     0.575    -0.466     0.200
     0.789     1.549     0.200
     0.995     0.095     0.200
     1.349     0.387     0.200
     1.386    -0.693     0.200
     1.379     0.745     0.200
     0.172     2.654     0.200
     0.500     0.739     0.200
     0.615     0.207     0.200
     0.929     0.746     0.200
     0.929     0.945     0.200
     1.288    -0.030     0.200
     1.445    -0.795     0.200
     4.007    -8.925     0.200
     0.219     1.399     0.200
     0.409     1.096     0.200
     0.657     1.034     0.200
     0.756     0.693     0.200
     1.223    -0.313     0.200
     1.353    -0.450     0.200
     2.643    -5.232     0.200
     3.315    -6.763     0.200
     0.151     2.461     0.200
     0.401     1.047     0.200
     0.474     0.926     0.200
     0.635     0.811     0.200
     0.704     1.727     0.200
     0.916     0.004     0.200
     1.265     0.254     0.200
     1.294     0.935     0.200
     1.460    -0.616     0.200
     0.284     1.271     0.200
     0.492     1.695     0.200
     0.538     1.029     0.200
     0.558     0.585     0.200
     0.790     0.627     0.200
     0.905    -0.406     0.200
     1.256     0.879     0.200
     1.498    -0.813     0.200
     0.290     1.709     0.200
     0.551     1.317     0.200
     0.504     2.209     0.200
     0.564     1.206     0.200
     0.564     1.308     0.200
     0.894    -0.453     0.200
     0.804     1.403     0.200
     2.335    -5.520     0.200
     0.210     1.518     0.200
     0.337     0.770     0.200
     0.396     0.507     0.200
     0.452     0.726     0.200
     0.939     1.596     0.200
     1.196     0.033     0.200
     1.183     0.769     0.200
     1.460    -0.019     0.200
     1.493     0.037     0.200
     2.061    -0.275     0.200
     0.330     0.735     0.200
     0.314     1.151     0.200
     0.275     1.869     0.200
     0.502     0.901     0.200
     0.976     0.982     0.200
     1.136    -0.323     0.200
     1.239     0.427     0.200
     2.602    -5.883     0.200
     0.127     2.878     0.200
     0.345     1.565     0.200
     0.351     2.270     0.200
     0.374     1.228     0.200
     0.652     1.128     0.200
     0.832     1.428     0.200
     1.164     0.496     0.200
     1.998    -0.737     0.200
     0.194     2.438     0.200
     0.194     2.637     0.200
     0.329     1.164     0.200
     0.329     1.465     0.200
     0.410     1.088     0.200
     0.526     1.110     0.200
     0.585     0.936     0.200
     0.699     1.542     0.200
     0.953    -0.406     0.200
     0.953     0.293     0.200
     1.256     0.165     0.200
     1.820    -0.385     0.200
     0.277     1.918     0.200
     0.277     1.718     0.200
     0.689     1.764     0.200
     0.689     1.564     0.200
     1.279    -0.467     0.200
     1.383    -1.348     0.200
     0.270     2.550     0.200
     0.295     2.260     0.200
     0.524     0.396     0.200
     0.598     0.950     0.200
     0.805     0.398     0.200
     1.179    -1.251     0.200
     1.140     0.362     0.200
     1.292    -0.144     0.200
     2.580    -6.689     0.200
     0.216     1.719     0.200
     0.314     0.589     0.200
     0.389     0.425     0.200
     0.584     0.633     0.200
     0.548     0.586     0.200
     0.686     1.215     0.200
     0.951     0.701     0.200
     1.250    -0.267     0.200
     1.290     1.367     0.200
     1.422    -0.128     0.200
     0.226     0.845     0.200
     0.226     1.649     0.200
     0.355     1.650     0.200
     0.566     1.877     0.200
     0.605     0.522     0.200
     1.015    -0.575     0.200
     1.082     1.498     0.200
     1.921    -0.299     0.200
     0.308     0.427     0.200
     0.376     0.354     0.200
     0.561     0.492     0.200
     0.586     0.306     0.200
     0.676     0.235     0.200
     0.948     1.413     0.200
     1.237    -0.034     0.200
     1.232    -0.077     0.200
     1.426    -0.515     0.200
     0.267     1.034     0.200
     0.372     1.280     0.200
     0.524     1.065     0.200
     0.617     0.839     0.200
     1.042    -0.545     0.200
     1.337    -0.095     0.200
     1.925    -0.429     0.200
     0.159     0.733     0.200
     0.285     0.830     0.200
     0.333     1.696     0.200
     0.478     0.007     0.200
     0.658     1.006     0.200
     0.729     1.253     0.200
     1.064     1.338     0.200
     1.201     0.194     0.200
     1.266     0.114     0.200
     1.326    -0.668     0.200
EOF
gmt end
