#!/bin/bash
gmt begin ushkan1.37_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional ushkan1.37'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.000    42.410
    14.500    42.132
    15.000    41.854
    15.500    41.573
    16.000    41.288
    16.500    40.998
    17.000    40.702
    17.500    40.397
    18.000    40.081
    18.500    39.754
    19.000    39.411
    19.500    39.052
    20.000    38.674
    20.500    38.274
    21.000    37.851
    21.500    37.402
    22.000    36.925
    22.500    36.418
    23.000    35.879
    23.500    35.307
    24.000    34.066
    24.500    32.794
    25.000    31.512
    25.500    30.220
    26.000    28.917
    26.500    27.602
    27.000    26.275
    27.500    24.931
    28.000    23.567
    28.500    22.188
    29.000    20.798
    29.500    19.399
    30.000    17.992
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    20.567 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000     9.376
     1.500    10.355
     2.000    11.335
     2.500    12.315
     3.000    13.295
     3.500    14.274
     4.000    15.252
     4.500    16.230
     5.000    17.206
     5.500    18.182
     6.000    19.156
     6.500    20.129
     7.000    21.100
     7.500    22.070
     8.000    23.038
     8.500    24.005
     9.000    24.969
     9.500    25.931
    10.000    26.891
    10.500    27.848
    11.000    28.803
    11.500    29.756
    12.000    30.706
    12.500    31.652
    13.000    32.596
    13.500    33.537
    14.000    34.474
    14.500    35.407
    15.000    36.338
    15.500    37.265
    16.000    38.159
    16.500    38.747
    17.000    39.227
    17.500    39.286
    18.000    39.630
    18.500    39.917
    19.000    40.145
    19.500    40.315
    20.000    40.427
    20.500    40.479
    21.000    40.472
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    29.596 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    13.630
     2.500    16.818
     3.000    20.006
     3.500    23.193
     4.000    26.381
     4.500    29.568
     5.000    32.756
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    29.381 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.883
     1.000     7.089
     1.500     9.651
     2.000    12.213
     2.500    14.775
     3.000    17.336
     3.500    19.896
     4.000    22.455
     4.500    25.012
     5.000    27.569
     5.500    30.124
     6.000    32.678
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    25.569 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.500    30.595
     2.000    36.892
     2.500    43.188
     3.000    49.485
     3.500    55.782
     4.000    62.076
     4.500    68.370
     5.000    74.661
     5.500    80.951
     6.000    87.238
     6.500    93.523
     7.000    99.806
     7.500   106.086
     8.000   112.362
     8.500   118.636
     9.000   124.906
     9.500   131.173
    10.000   137.435
    10.500   143.693
    11.000   149.947
    11.500   156.197
    12.000   162.441
    12.500   168.681
    13.000   174.914
    13.500   181.142
    14.000   187.366
    14.500   193.581
    15.000   199.792
    15.500   205.996
    16.000   212.193
    16.500   218.383
    17.000   224.566
    17.500   233.878
    18.000   240.148
    18.500   246.406
    19.000   252.652
    19.500   258.883
    20.000   265.101
    20.500   271.305
    21.000   277.493
    21.500   283.667
    22.000   289.825
    22.500   295.966
    23.000   302.092
    23.500   308.201
    24.000   314.292
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    60.076 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    11.029
     1.000    20.474
     1.500    28.849
     2.000    37.224
     2.500    45.600
     3.000    53.973
     3.500    62.344
     4.000    70.714
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    60.344 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    38.036
     2.500    47.840
     3.000    57.644
     3.500    67.448
     4.000    77.252
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    59.644 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    13.669   354.204     0.150
    13.669   779.204     0.150
    13.669   792.204     0.150
    16.307   232.415     0.150
    18.553    50.208     0.150
    19.836   254.230     0.150
    19.818   260.446     0.150
    22.476   279.424     0.150
    22.837   279.209     0.150
    23.241   297.498     0.150
    23.294    61.885     0.150
    23.325   289.515     0.150
    23.334   289.413     0.150
    26.483  -301.055     0.150
    26.655   302.652     0.150
    27.425   305.669     0.150
    28.379  -326.181     0.150
    15.725    48.768     0.150
    17.955    49.447     0.150
    23.805   699.167     0.150
    16.406   327.652     0.150
    22.864   285.992     0.150
    22.864   329.492     0.150
    24.235   293.787     0.150
    24.235   298.990     0.150
    24.235   472.287     0.150
    17.685    44.417     0.150
    17.685    52.216     0.150
    22.564   282.781     0.150
    22.820   288.293     0.150
    24.056   255.267     0.150
    24.056   293.167     0.150
    24.056   302.067     0.150
    24.056   699.567     0.150
    24.392   254.847     0.150
    12.881    37.859     0.150
    12.881    41.155     0.150
    16.430   540.936     0.150
    22.277   276.099     0.150
    17.980    47.262     0.150
    12.623    35.975     0.150
    16.652   231.856     0.150
    17.510   243.544     0.150
    17.510   255.544     0.150
    18.124   247.874     0.150
    19.249    58.847     0.150
    19.249   278.644     0.150
    20.475   259.833     0.150
    22.510   283.187     0.150
    22.510   293.687     0.150
    22.629   282.196     0.150
    22.629   289.095     0.150
    22.629   324.095     0.150
    22.711   287.843     0.150
    23.131   293.838     0.150
    24.023   293.029     0.150
    24.023   297.826     0.150
    24.898   299.311     0.150
    26.044   240.746     0.150
    26.044   306.848     0.150
    26.044   459.746     0.150
    26.044   687.746     0.150
    26.837   233.997     0.150
    26.837   306.497     0.150
    26.837   378.497     0.150
    27.182   305.767     0.150
    28.392   311.348     0.150
    28.392   390.153     0.150
    28.462    78.132     0.150
    28.462   218.335     0.150
    28.462   312.530     0.150
    28.462   317.335     0.150
    28.462   396.835     0.150
    28.462   438.132     0.150
    28.462   439.335     0.150
    28.614   311.655     0.150
    29.317   317.850     0.150
    29.586   310.912     0.150
    28.356   390.807     0.150
    12.634    42.691     0.150
    16.659   547.214     0.150
    17.522   260.148     0.150
    22.641   321.605     0.150
    26.050   311.823     0.150
    27.179   304.442     0.150
    28.389   312.632     0.150
    28.389   389.734     0.150
    22.638   269.226     0.150
    22.638   284.726     0.150
    22.638   289.726     0.150
    22.638   323.226     0.150
    28.383   312.172     0.150
    28.470   399.463     0.150
    16.565   236.406     0.150
    16.565   765.206     0.150
    20.487   258.479     0.150
    26.426   298.923     0.150
    19.016    45.203     0.150
    12.516    41.903     0.150
    19.118    49.258     0.150
    19.118    52.457     0.150
    21.173   270.276     0.150
    22.474   282.392     0.150
    22.474   492.392     0.150
    28.336   311.282     0.150
    28.336   388.782     0.150
    17.782    42.141     0.150
    19.445    47.733     0.150
    19.445    50.135     0.150
    15.190    43.548     0.150
    20.394   256.569     0.150
    22.636   283.060     0.150
    22.728   266.379     0.150
    10.848    36.978     0.150
    16.862    48.198     0.150
    17.804    42.401     0.150
    20.180   251.311     0.150
    28.536    70.717     0.150
    28.536   213.119     0.150
    28.536   311.518     0.150
    28.536   391.119     0.150
    16.773    43.655     0.150
    16.773    49.155     0.150
    16.773   330.358     0.150
    28.416    67.774     0.150
    28.416   310.673     0.150
    28.416   389.079     0.150
    20.527   257.301     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    15.506    41.767     0.200
    15.732    43.529     0.200
    17.148    39.606     0.200
    18.126    39.686     0.200
    19.836    36.230     0.200
    22.476    35.424     0.200
    22.837    35.209     0.200
    22.934    37.086     0.200
    23.136    35.721     0.200
    23.241    37.098     0.200
    23.294    33.885     0.200
    23.325    35.515     0.200
    23.334    35.413     0.200
    23.632    36.931     0.200
    24.412    32.829     0.200
    25.085    33.173     0.200
    27.167    24.680     0.200
    27.389    27.594     0.200
    28.379    22.540     0.200
    29.126    20.825     0.200
    29.775    21.746     0.200
    14.261    45.551     0.200
    15.614    43.758     0.200
    15.661    42.215     0.200
    19.494    39.980     0.200
    22.401    37.560     0.200
    25.614    31.560     0.200
    20.555    37.505     0.200
    15.076    43.113     0.200
    17.882    41.749     0.200
    20.488    37.606     0.200
    20.488    37.457     0.200
    22.269    36.771     0.200
    22.624    37.721     0.200
    23.395    35.087     0.200
    15.315    44.085     0.200
    16.406    40.652     0.200
    16.759    44.238     0.200
    17.743    41.257     0.200
    18.017    41.158     0.200
    18.486    38.880     0.200
    18.486    38.520     0.200
    20.249    38.004     0.200
    22.608    35.333     0.200
    22.660    34.074     0.200
    22.864    38.288     0.200
    23.430    33.279     0.200
    24.235    33.287     0.200
    24.472    33.324     0.200
    24.947    32.478     0.200
    24.947    31.673     0.200
    16.884    44.262     0.200
    18.684    37.559     0.200
    18.684    38.299     0.200
    22.564    35.182     0.200
    22.799    39.737     0.200
    22.820    35.193     0.200
    22.820    35.530     0.200
    22.871    35.589     0.200
    23.144    37.479     0.200
    23.636    37.466     0.200
    23.642    34.295     0.200
    24.056    34.967     0.200
    24.297    33.858     0.200
    24.392    35.847     0.200
    25.114    31.620     0.200
    25.114    32.151     0.200
    27.190    27.993     0.200
    27.190    27.993     0.200
    28.503    22.667     0.200
    28.503    22.357     0.200
    15.326    43.819     0.200
    16.430    40.936     0.200
    16.753    41.173     0.200
    17.760    41.926     0.200
    22.277    35.810     0.200
    22.586    35.762     0.200
    23.408    34.303     0.200
    23.748    33.434     0.200
    24.472    34.695     0.200
    28.713    24.094     0.200
    14.032    41.060     0.200
    28.342    21.136     0.200
    17.758    40.059     0.200
    18.235    39.923     0.200
    20.379    37.492     0.200
    22.375    37.092     0.200
    24.699    35.064     0.200
    14.677    45.901     0.200
    16.652    42.660     0.200
    17.510    43.841     0.200
    18.501    37.575     0.200
    18.501    39.371     0.200
    18.501    37.676     0.200
    18.501    37.465     0.200
    18.501    38.129     0.200
    18.586    38.377     0.200
    20.475    37.732     0.200
    20.475    37.442     0.200
    20.798    39.267     0.200
    22.510    38.187     0.200
    22.668    35.285     0.200
    22.629    39.095     0.200
    22.720    36.340     0.200
    22.720    35.036     0.200
    22.720    34.645     0.200
    22.720    35.645     0.200
    22.711    38.241     0.200
    22.711    38.726     0.200
    23.015    39.409     0.200
    23.131    39.541     0.200
    24.023    35.326     0.200
    24.080    35.713     0.200
    24.080    35.369     0.200
    24.115    35.565     0.200
    24.520    35.023     0.200
    24.530    34.402     0.200
    24.626    33.598     0.200
    24.620    34.767     0.200
    24.709    33.535     0.200
    24.798    35.015     0.200
    24.898    33.921     0.200
    24.898    32.936     0.200
    24.898    33.218     0.200
    24.898    33.319     0.200
    24.898    34.116     0.200
    25.136    34.212     0.200
    25.136    33.579     0.200
    25.227    31.276     0.200
    25.306    32.848     0.200
    25.306    32.520     0.200
    25.677    31.978     0.200
    25.677    31.299     0.200
    26.130    32.746     0.200
    26.625    30.465     0.200
    26.625    29.465     0.200
    26.627    27.795     0.200
    26.837    30.700     0.200
    27.182    26.868     0.200
    28.392    22.653     0.200
    28.392    22.450     0.200
    28.392    22.098     0.200
    28.462    26.132     0.200
    28.614    22.452     0.200
    29.017    21.422     0.200
    29.317    23.748     0.200
    29.586    18.819     0.200
    29.586    20.405     0.200
    17.983    40.656     0.200
    17.983    40.332     0.200
    17.983    41.156     0.200
    18.599    39.291     0.200
    22.681    37.299     0.200
    24.092    34.972     0.200
    17.299    39.341     0.200
    17.803    39.949     0.200
    17.889    38.935     0.200
    20.654    36.090     0.200
    21.982    34.690     0.200
    22.034    36.679     0.200
    18.824    38.263     0.200
    19.257    37.616     0.200
    19.344    36.613     0.200
    23.320    35.896     0.200
    23.371    37.104     0.200
    23.371    34.002     0.200
    25.755    31.983     0.200
    17.971    40.792     0.200
    22.636    38.136     0.200
    24.899    34.441     0.200
    22.643    36.771     0.200
    22.695    37.664     0.200
    24.901    35.218     0.200
    24.901    33.262     0.200
    15.113    43.458     0.200
    16.311    40.977     0.200
    16.659    44.214     0.200
    17.522    45.749     0.200
    18.503    38.000     0.200
    18.588    38.857     0.200
    19.261    39.353     0.200
    20.464    37.721     0.200
    20.464    37.916     0.200
    20.780    39.263     0.200
    20.804    39.340     0.200
    20.804    39.293     0.200
    21.467    38.910     0.200
    22.520    38.020     0.200
    22.667    35.752     0.200
    22.720    37.292     0.200
    22.720    35.581     0.200
    24.085    34.655     0.200
    24.617    32.224     0.200
    24.903    32.505     0.200
    26.848    29.305     0.200
    26.987    29.992     0.200
    26.987    28.187     0.200
    27.179    27.247     0.200
    28.389    23.632     0.200
    28.389    22.742     0.200
    28.474    26.939     0.200
    15.108    43.400     0.200
    16.651    43.583     0.200
    17.911    41.380     0.200
    18.496    39.457     0.200
    18.581    38.466     0.200
    20.808    39.976     0.200
    20.808    40.018     0.200
    22.661    37.150     0.200
    22.713    36.241     0.200
    22.713    35.741     0.200
    24.077    34.923     0.200
    24.624    33.231     0.200
    24.896    33.664     0.200
    24.896    34.476     0.200
    24.896    32.203     0.200
    25.303    33.015     0.200
    26.979    29.857     0.200
    28.383    23.391     0.200
    28.383    24.070     0.200
    28.470    24.162     0.200
    14.447    43.731     0.200
    14.991    43.273     0.200
    16.411    44.201     0.200
    17.464    42.421     0.200
    17.704    40.759     0.200
    17.704    40.559     0.200
    17.704    41.016     0.200
    17.710    40.395     0.200
    20.552    36.674     0.200
    20.552    36.077     0.200
    22.400    36.444     0.200
    22.452    37.529     0.200
    22.452    36.810     0.200
    26.712    28.643     0.200
    26.712    28.963     0.200
    28.423    26.333     0.200
    29.891    19.305     0.200
    20.487    37.729     0.200
    20.487    39.020     0.200
    24.632    33.343     0.200
    24.899    33.829     0.200
    18.219    40.845     0.200
    18.219    40.845     0.200
    18.719    38.857     0.200
    18.805    39.482     0.200
    20.281    37.049     0.200
    20.281    36.260     0.200
    22.855    36.380     0.200
    22.907    37.526     0.200
    24.369    33.829     0.200
    26.426    27.727     0.200
    17.444    41.739     0.200
    17.963    40.546     0.200
    17.963    40.358     0.200
    20.486    38.161     0.200
    20.486    37.997     0.200
    22.664    37.329     0.200
    18.015    42.958     0.200
    14.782    44.716     0.200
    16.333    41.609     0.200
    16.333    44.409     0.200
    17.695    41.515     0.200
    18.283    41.969     0.200
    18.920    40.555     0.200
    18.920    40.384     0.200
    20.778    39.338     0.200
    20.778    38.619     0.200
    20.818    40.375     0.200
    22.502    35.652     0.200
    22.554    37.309     0.200
    22.554    37.889     0.200
    24.619    34.701     0.200
    24.619    34.216     0.200
    24.619    34.416     0.200
    26.720    30.091     0.200
    26.720    30.291     0.200
    28.289    25.855     0.200
    14.924    44.104     0.200
    16.476    44.789     0.200
    16.476    45.388     0.200
    17.351    43.078     0.200
    17.977    40.631     0.200
    18.382    40.548     0.200
    18.467    39.586     0.200
    18.467    38.660     0.200
    19.118    39.108     0.200
    20.643    38.030     0.200
    20.643    37.661     0.200
    20.643    37.892     0.200
    20.749    39.235     0.200
    20.806    39.260     0.200
    20.806    39.810     0.200
    21.069    38.840     0.200
    21.173    35.575     0.200
    21.408    37.438     0.200
    21.525    35.590     0.200
    21.786    37.855     0.200
    21.790    37.858     0.200
    22.198    37.743     0.200
    22.204    35.313     0.200
    22.440    38.293     0.200
    22.474    39.494     0.200
    22.577    36.802     0.200
    22.630    35.277     0.200
    22.630    34.927     0.200
    22.836    36.778     0.200
    22.917    35.606     0.200
    22.928    36.451     0.200
    22.923    37.831     0.200
    23.645    35.283     0.200
    23.926    36.238     0.200
    23.926    35.758     0.200
    24.052    35.503     0.200
    24.052    36.085     0.200
    24.184    34.823     0.200
    24.369    35.112     0.200
    24.811    33.020     0.200
    24.811    32.721     0.200
    24.745    34.388     0.200
    24.745    34.505     0.200
    24.745    32.595     0.200
    24.745    33.983     0.200
    24.982    34.782     0.200
    25.154    33.558     0.200
    25.523    32.674     0.200
    26.472    28.627     0.200
    26.695    30.836     0.200
    26.839    29.355     0.200
    26.839    28.426     0.200
    26.839    27.256     0.200
    26.839    27.955     0.200
    27.128    29.987     0.200
    28.336    24.802     0.200
    28.336    22.682     0.200
    28.336    24.503     0.200
    29.184    21.235     0.200
    29.496    20.928     0.200
    29.961    20.219     0.200
    17.959    41.693     0.200
    17.959    40.794     0.200
    18.487    39.929     0.200
    18.572    38.911     0.200
    18.779    38.303     0.200
    18.779    38.928     0.200
    20.474    38.269     0.200
    22.653    36.696     0.200
    15.436    41.420     0.200
    17.049    41.397     0.200
    18.347    38.042     0.200
    18.347    38.343     0.200
    18.347    36.542     0.200
    18.524    37.979     0.200
    18.747    37.211     0.200
    18.747    37.746     0.200
    18.832    36.587     0.200
    18.918    35.583     0.200
    20.179    35.668     0.200
    20.621    36.807     0.200
    20.678    36.545     0.200
    22.559    35.796     0.200
    22.952    32.771     0.200
    23.004    36.408     0.200
    23.004    34.634     0.200
    23.473    32.727     0.200
    24.029    33.841     0.200
    24.234    33.142     0.200
    24.522    32.883     0.200
    25.276    29.284     0.200
    28.612    19.572     0.200
    28.612    20.353     0.200
    14.931    44.193     0.200
    16.343    41.311     0.200
    17.413    39.725     0.200
    17.641    41.263     0.200
    18.689    37.936     0.200
    18.689    39.135     0.200
    18.689    38.646     0.200
    18.794    40.014     0.200
    20.609    36.750     0.200
    20.609    36.631     0.200
    22.356    36.568     0.200
    22.408    36.833     0.200
    22.408    39.353     0.200
    24.897    31.187     0.200
    26.651    30.214     0.200
    26.651    29.815     0.200
    29.845    20.358     0.200
    22.687    37.268     0.200
    17.784    41.471     0.200
    18.320    40.809     0.200
    18.405    39.832     0.200
    22.498    39.256     0.200
    20.525    36.981     0.200
    16.748    42.767     0.200
    17.586    41.495     0.200
    17.852    39.524     0.200
    18.575    37.849     0.200
    18.660    36.841     0.200
    18.766    36.670     0.200
    18.766    36.490     0.200
    20.394    36.743     0.200
    20.394    36.245     0.200
    20.394    36.524     0.200
    20.781    37.299     0.200
    20.781    38.511     0.200
    22.636    36.960     0.200
    22.728    33.646     0.200
    22.780    33.854     0.200
    22.780    34.374     0.200
    23.072    34.288     0.200
    23.630    34.401     0.200
    23.773    34.859     0.200
    23.773    32.070     0.200
    23.773    34.990     0.200
    24.528    32.932     0.200
    24.528    32.281     0.200
    24.987    32.017     0.200
    24.987    30.343     0.200
    24.987    32.323     0.200
    25.187    29.185     0.200
    25.619    29.680     0.200
    26.600    26.120     0.200
    27.068    24.800     0.200
    27.068    24.531     0.200
    27.303    25.389     0.200
    28.435    20.887     0.200
    28.924    18.789     0.200
    29.743    17.284     0.200
    17.693    41.246     0.200
    18.280    39.698     0.200
    18.364    38.665     0.200
    20.773    36.599     0.200
    22.497    34.525     0.200
    14.431    41.062     0.200
    15.394    41.421     0.200
    16.713    40.131     0.200
    17.227    39.340     0.200
    17.918    39.567     0.200
    18.577    36.455     0.200
    18.577    37.076     0.200
    18.577    38.186     0.200
    18.664    38.117     0.200
    19.880    38.877     0.200
    20.180    35.686     0.200
    20.180    35.268     0.200
    20.180    36.776     0.200
    20.180    36.487     0.200
    20.917    34.863     0.200
    20.917    37.921     0.200
    21.591    37.701     0.200
    22.630    36.462     0.200
    22.630    37.079     0.200
    22.630    36.931     0.200
    22.731    35.809     0.200
    22.689    35.738     0.200
    22.741    34.138     0.200
    22.741    37.247     0.200
    22.922    36.771     0.200
    23.119    38.099     0.200
    23.292    36.321     0.200
    23.262    34.512     0.200
    23.643    34.742     0.200
    23.643    33.855     0.200
    23.643    35.164     0.200
    23.643    35.672     0.200
    23.711    35.821     0.200
    23.810    32.084     0.200
    23.810    35.873     0.200
    24.373    33.940     0.200
    24.298    32.623     0.200
    24.298    33.694     0.200
    25.048    29.997     0.200
    25.048    31.110     0.200
    25.048    32.864     0.200
    25.048    33.075     0.200
    27.045    26.957     0.200
    27.111    25.085     0.200
    27.521    25.299     0.200
    28.457    23.871     0.200
    28.835    21.145     0.200
    28.755    21.203     0.200
    29.402    19.449     0.200
    29.810    17.984     0.200
    29.810    19.394     0.200
    17.950    40.913     0.200
    17.950    40.440     0.200
    17.950    40.913     0.200
    18.479    39.646     0.200
    18.564    38.874     0.200
    20.479    38.796     0.200
    20.479    37.901     0.200
    22.645    37.294     0.200
    24.641    30.435     0.200
    17.975    40.526     0.200
    18.482    39.930     0.200
    20.301    38.670     0.200
    22.414    36.712     0.200
    17.421    41.153     0.200
    17.929    42.148     0.200
    18.014    41.107     0.200
    22.103    38.802     0.200
    18.259    41.907     0.200
    20.350    39.948     0.200
    22.393    40.068     0.200
    17.786    41.261     0.200
    17.786    41.261     0.200
    18.257    41.161     0.200
    18.503    38.991     0.200
    20.347    37.693     0.200
    20.347    38.272     0.200
    21.113    40.029     0.200
    22.391    37.967     0.200
    14.111    40.563     0.200
    15.152    40.608     0.200
    17.854    40.573     0.200
    17.854    39.795     0.200
    18.067    41.298     0.200
    18.578    37.690     0.200
    18.664    38.681     0.200
    18.751    37.006     0.200
    18.751    39.424     0.200
    20.376    37.120     0.200
    20.376    37.452     0.200
    21.669    37.054     0.200
    22.632    38.117     0.200
    22.632    35.757     0.200
    22.728    35.476     0.200
    24.513    34.271     0.200
    24.995    30.367     0.200
    24.995    30.746     0.200
    24.995    29.586     0.200
    27.074    25.882     0.200
    27.074    25.382     0.200
    28.536    23.319     0.200
    28.914    20.489     0.200
    28.914    19.102     0.200
    29.482    19.681     0.200
    17.811    42.221     0.200
    17.849    40.844     0.200
    18.275    42.946     0.200
    18.361    41.973     0.200
    22.402    36.736     0.200
    18.181    40.119     0.200
    20.753    37.378     0.200
    22.304    37.328     0.200
    18.540    39.236     0.200
    18.823    39.629     0.200
    20.174    37.226     0.200
    20.482    37.031     0.200
    22.709    36.861     0.200
    17.283    39.249     0.200
    17.778    40.462     0.200
    21.986    37.257     0.200
    19.325    36.961     0.200
    23.458    34.630     0.200
    23.833    32.748     0.200
    25.770    30.448     0.200
    19.297    38.128     0.200
    19.297    37.917     0.200
    19.384    38.052     0.200
    22.470    34.985     0.200
    23.365    34.763     0.200
    23.399    34.344     0.200
    25.785    28.400     0.200
    27.848    23.597     0.200
    17.742    42.104     0.200
    20.180    37.672     0.200
    20.180    37.152     0.200
    22.254    36.266     0.200
    22.289    36.145     0.200
    17.487    40.342     0.200
    18.125    41.586     0.200
    18.717    39.971     0.200
    20.738    37.912     0.200
    22.243    39.451     0.200
    15.257    43.644     0.200
    18.508    39.853     0.200
    18.508    38.743     0.200
    18.508    40.603     0.200
    18.591    38.703     0.200
    18.591    38.305     0.200
    18.594    38.473     0.200
    20.254    37.511     0.200
    20.254    36.426     0.200
    21.652    36.710     0.200
    22.632    36.794     0.200
    22.667    35.767     0.200
    22.802    35.314     0.200
    23.176    35.531     0.200
    23.725    35.390     0.200
    24.049    31.818     0.200
    24.215    34.247     0.200
    24.887    32.312     0.200
    24.966    32.916     0.200
    24.966    32.611     0.200
    27.001    26.860     0.200
    26.964    27.324     0.200
    27.032    26.381     0.200
    28.008    22.845     0.200
    28.127    21.689     0.200
    28.127    22.978     0.200
    17.805    42.018     0.200
    18.416    38.870     0.200
    20.527    36.848     0.200
    22.503    37.871     0.200
    17.762    39.944     0.200
    18.424    38.285     0.200
    22.547    36.066     0.200
    20.306    36.411     0.200
    22.338    36.830     0.200
    17.540    41.400     0.200
    18.194    42.014     0.200
    22.323    38.284     0.200
    17.539    41.796     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.695    10.845     0.200
     1.985    10.758     0.200
     1.985    11.458     0.200
     3.014    13.646     0.200
     3.661    14.898     0.200
     4.862    15.890     0.200
     5.041    20.795     0.200
     1.902    10.623     0.200
     2.278    11.133     0.200
     3.245    13.148     0.200
     3.350    11.524     0.200
     3.515    12.698     0.200
     3.515    13.598     0.200
     3.520    14.243     0.200
     4.888    16.871     0.200
     4.925    17.248     0.200
     5.297    18.909     0.200
     5.297    19.210     0.200
     9.300    26.190     0.200
    13.140    32.374     0.200
    13.284    33.196     0.200
    13.492    34.274     0.200
    13.669    30.005     0.200
    14.673    34.481     0.200
    14.784    38.188     0.200
    14.911    35.713     0.200
    15.011    34.538     0.200
    15.011    34.737     0.200
    15.506    35.167     0.200
    15.732    38.129     0.200
    16.307    38.915     0.200
    16.332    39.126     0.200
    17.293    38.912     0.200
    17.884    38.018     0.200
    18.553    40.609     0.200
    19.818    39.446     0.200
     1.750     8.244     0.200
     2.787    10.837     0.200
     2.728    11.827     0.200
     2.752    12.053     0.200
     3.227    15.004     0.200
     1.163     9.110     0.200
     2.391    10.578     0.200
     3.097    12.642     0.200
     3.662    15.753     0.200
     3.744    11.695     0.200
     3.918    14.065     0.200
     4.570    16.455     0.200
     2.207    10.215     0.200
     2.597    11.471     0.200
     2.657    10.671     0.200
     4.044    13.484     0.200
     2.642    11.594     0.200
     4.723    13.503     0.200
     2.641    11.231     0.200
     2.723    11.773     0.200
     3.338    13.388     0.200
     4.713    13.548     0.200
     2.675    11.746     0.200
     2.934    11.419     0.200
     3.456    14.231     0.200
     3.876    13.232     0.200
     4.733    14.027     0.200
     5.763    15.707     0.200
     2.639    12.296     0.200
     3.893    13.156     0.200
     2.299    11.342     0.200
     2.476    11.887     0.200
     2.487    12.957     0.200
     2.487    12.559     0.200
     2.658    11.055     0.200
     2.911    12.406     0.200
     3.391    13.003     0.200
     3.391    13.402     0.200
     3.670    13.642     0.200
     3.670    13.443     0.200
     4.117    13.936     0.200
     4.264    15.323     0.200
     4.450    15.042     0.200
     4.458    15.054     0.200
     4.848    16.102     0.200
     4.848    19.602     0.200
     4.877    15.463     0.200
     4.877    16.064     0.200
     5.186    17.951     0.200
     5.186    17.850     0.200
     5.766    19.688     0.200
     5.766    19.789     0.200
     5.841    18.215     0.200
     5.975    18.254     0.200
     6.196    19.771     0.200
     6.196    21.470     0.200
     6.309    18.051     0.200
     7.463    19.984     0.200
    13.491    32.536     0.200
    14.098    32.759     0.200
    14.140    33.963     0.200
    14.160    34.631     0.200
    14.136    33.509     0.200
    14.870    34.545     0.200
    15.615    34.749     0.200
    15.725    37.467     0.200
    17.544    39.735     0.200
    17.955    40.447     0.200
    20.323    40.710     0.200
     2.696    13.003     0.200
     2.979    14.899     0.200
     3.286    14.121     0.200
     3.519    17.299     0.200
     3.767    14.599     0.200
     4.855    20.308     0.200
     2.282    11.183     0.200
     2.570    13.616     0.200
     3.071    12.872     0.200
     3.071    13.272     0.200
     3.309    13.298     0.200
     3.309    13.898     0.200
     3.874    16.301     0.200
     4.298    16.353     0.200
     4.393    15.244     0.200
     4.393    14.543     0.200
     4.791    19.302     0.200
     4.791    18.401     0.200
     5.229    19.486     0.200
     5.229    18.586     0.200
     5.543    19.927     0.200
     1.916    10.245     0.200
     2.230    10.677     0.200
     3.038    12.049     0.200
     3.717    13.127     0.200
     2.304    12.737     0.200
     2.377     9.990     0.200
     2.665    12.217     0.200
     3.256    13.731     0.200
     3.540    15.709     0.200
     3.765    14.794     0.200
     2.637    12.596     0.200
     2.637    12.495     0.200
     2.653    13.212     0.200
     3.138    13.450     0.200
     3.138    13.251     0.200
     3.257    13.172     0.200
     3.418    14.186     0.200
     3.837    14.691     0.200
     3.829    15.388     0.200
     3.829    14.888     0.200
     4.191    16.468     0.200
     4.237    16.627     0.200
     4.237    16.427     0.200
     4.747    18.674     0.200
     5.197    19.721     0.200
     5.367    17.548     0.200
     5.443    18.392     0.200
     5.610    17.507     0.200
     6.992    20.374     0.200
     2.296    10.580     0.200
     2.167    12.217     0.200
     2.360    12.360     0.200
     2.573    12.986     0.200
     2.737    13.772     0.200
     3.193    14.350     0.200
     3.262    13.646     0.200
     3.310    14.383     0.200
     3.827    15.642     0.200
     3.908    16.907     0.200
     3.908    17.110     0.200
     4.181    15.312     0.200
     4.181    15.711     0.200
     5.310    20.437     0.200
     5.362    18.431     0.200
     1.719    11.160     0.200
     2.127    10.790     0.200
     2.353    11.963     0.200
     2.717    13.209     0.200
     2.880    12.609     0.200
     3.421    14.495     0.200
     3.954    16.476     0.200
     3.954    14.476     0.200
     4.451    16.879     0.200
     4.576    15.220     0.200
     5.256    20.581     0.200
     2.368    11.622     0.200
     2.503    11.953     0.200
     2.644    13.103     0.200
     3.155    12.947     0.200
     3.155    13.646     0.200
     3.225    13.421     0.200
     3.454    13.259     0.200
     3.454    13.857     0.200
     3.795    14.969     0.200
     4.384    15.995     0.200
     4.384    15.097     0.200
     4.713    18.860     0.200
     5.161    19.729     0.200
     5.627    17.994     0.200
     1.976    10.596     0.200
     2.511    11.452     0.200
     2.718    11.941     0.200
     2.978    11.700     0.200
     3.442    13.286     0.200
     5.367    19.524     0.200
     1.882    10.486     0.200
     2.218    11.260     0.200
     2.292    11.397     0.200
     2.569    11.867     0.200
     2.574    12.416     0.200
     3.077    13.347     0.200
     3.293    14.717     0.200
     3.293    14.018     0.200
     3.436    13.257     0.200
     3.791    14.410     0.200
     3.856    15.350     0.200
     4.138    15.461     0.200
     4.165    15.342     0.200
     4.287    16.926     0.200
     4.287    16.726     0.200
     4.411    14.268     0.200
     4.773    19.753     0.200
     4.773    19.553     0.200
     5.209    18.964     0.200
     5.512    19.063     0.200
     5.549    17.195     0.200
     6.744    20.852     0.200
     6.744    20.551     0.200
     6.970    20.611     0.200
     7.459    22.806     0.200
     8.222    21.181     0.200
    13.963    34.679     0.200
    14.332    35.789     0.200
     1.960    10.051     0.200
     2.209    10.243     0.200
     2.657    11.616     0.200
     3.395    13.699     0.200
     3.934    16.405     0.200
     5.277    18.631     0.200
     1.743     8.984     0.200
     1.920     9.120     0.200
     2.203    10.418     0.200
     3.102    11.731     0.200
     4.285    13.821     0.200
     2.289    10.498     0.200
     3.167    13.453     0.200
     1.934    10.095     0.200
     2.203     9.859     0.200
     2.561    10.980     0.200
     2.695    10.819     0.200
     3.022    11.903     0.200
     3.274    11.353     0.200
     3.683    13.881     0.200
     4.292    13.172     0.200
     4.292    12.872     0.200
     4.918    17.875     0.200
     5.215    16.802     0.200
     5.366    18.241     0.200
     6.821    18.858     0.200
     2.280    10.419     0.200
     3.059    12.122     0.200
     3.151    12.651     0.200
     3.715    13.168     0.200
     4.025    13.255     0.200
     1.700     9.012     0.200
     1.701     9.606     0.200
     2.058     9.745     0.200
     2.212    11.242     0.200
     2.430    11.296     0.200
     3.124    12.306     0.200
     3.290    12.459     0.200
     1.890    10.612     0.200
     2.269    11.083     0.200
     2.606    11.652     0.200
     2.606    11.953     0.200
     2.723    11.690     0.200
     3.065    12.997     0.200
     3.329    13.317     0.200
     3.329    13.419     0.200
     3.384    12.381     0.200
     3.384    12.580     0.200
     3.762    14.964     0.200
     3.898    15.582     0.200
     3.898    15.082     0.200
     4.313    16.237     0.200
     4.313    16.038     0.200
     4.368    14.086     0.200
     4.815    17.479     0.200
     4.815    17.979     0.200
     5.256    19.428     0.200
     5.256    18.428     0.200
     5.536    17.760     0.200
     6.714    21.315     0.200
     6.926    19.540     0.200
     1.821     9.891     0.200
     2.313    10.647     0.200
     2.529    10.926     0.200
     2.622    11.742     0.200
     3.004    11.282     0.200
     3.229    12.557     0.200
     3.822    12.236     0.200
     4.056    14.712     0.200
     4.437    18.368     0.200
     4.712    13.660     0.200
     4.837    17.190     0.200
     2.095    10.682     0.200
     2.099    11.439     0.200
     2.354    12.061     0.200
     2.754    12.288     0.200
     3.605    14.254     0.200
     5.312    19.340     0.200
     1.642     9.773     0.200
     1.785    10.104     0.200
     2.175    10.356     0.200
     2.307    11.214     0.200
     2.327    11.286     0.200
     2.510    11.646     0.200
     2.715    10.554     0.200
     2.715    11.155     0.200
     3.399    13.068     0.200
     4.136    14.260     0.200
     4.724    16.707     0.200
     5.643    19.679     0.200
     5.643    18.983     0.200
     6.096    18.297     0.200
     6.082    19.059     0.200
     1.710     9.854     0.200
     1.710    10.054     0.200
     1.687    10.621     0.200
     2.034     9.872     0.200
     2.195    10.889     0.200
     2.245    10.615     0.200
     2.308    10.375     0.200
     2.417    11.202     0.200
     2.612    11.630     0.200
     2.855    11.789     0.200
     3.139    12.871     0.200
     3.269    12.659     0.200
     3.405    12.469     0.200
     3.538    14.215     0.200
     4.002    14.002     0.200
     4.677    15.326     0.200
     4.677    15.725     0.200
     5.499    18.832     0.200
     5.499    18.933     0.200
     5.930    19.500     0.200
     6.079    17.962     0.200
     2.340    10.312     0.200
     2.443    10.515     0.200
     2.443    10.617     0.200
     2.643     9.980     0.200
     2.677    11.678     0.200
     2.869    11.743     0.200
     6.233    20.082     0.200
     6.233    19.683     0.200
    10.198    28.613     0.200
     2.314    11.700     0.200
     2.569    12.126     0.200
     2.832    13.457     0.200
     3.043    13.090     0.200
     3.355    13.950     0.200
     3.629    15.551     0.200
     4.060    15.722     0.200
     4.340    15.359     0.200
     5.027    19.145     0.200
     2.496    10.741     0.200
     4.024    14.308     0.200
     2.073    10.917     0.200
     2.121    11.357     0.200
     2.332    11.993     0.200
     2.332    12.196     0.200
     2.840    12.873     0.200
     2.775    12.823     0.200
     2.775    12.722     0.200
     2.858    12.959     0.200
     2.858    11.459     0.200
     3.212    14.326     0.200
     3.212    14.225     0.200
     3.431    13.075     0.200
     3.483    14.067     0.200
     4.536    14.874     0.200
     4.504    16.654     0.200
     4.504    16.755     0.200
     4.931    18.763     0.200
     4.931    20.263     0.200
     4.931    18.966     0.200
     5.106    17.127     0.200
     5.106    17.026     0.200
     5.313    17.308     0.200
     5.313    16.011     0.200
     5.327    18.550     0.200
     5.327    19.948     0.200
     5.327    18.753     0.200
     5.745    18.774     0.200
     5.745    18.555     0.200
     5.855    19.331     0.200
     6.539    20.209     0.200
     6.539    21.006     0.200
     6.828    20.027     0.200
     6.828    20.230     0.200
     7.400    22.254     0.200
     7.565    23.933     0.200
     8.232    20.445     0.200
     9.357    24.716     0.200
    14.093    32.647     0.200
    14.012    34.399     0.200
    14.012    36.500     0.200
    14.493    35.182     0.200
    14.816    35.112     0.200
    18.017    38.979     0.200
     1.624    10.746     0.200
     1.900    10.926     0.200
     2.127    11.981     0.200
     2.392    12.590     0.200
     2.506    11.553     0.200
     2.831    13.261     0.200
     2.831    13.361     0.200
     2.879    12.901     0.200
     2.993    13.065     0.200
     3.196    15.207     0.200
     3.213    13.000     0.200
     3.492    14.447     0.200
     3.602    14.165     0.200
     3.853    15.730     0.200
     4.166    15.186     0.200
     4.166    16.586     0.200
     4.345    14.791     0.200
     4.581    17.138     0.200
     5.023    17.082     0.200
     5.082    18.098     0.200
     5.082    18.898     0.200
     5.296    16.295     0.200
     5.506    19.449     0.200
     5.506    20.149     0.200
     5.679    19.091     0.200
     5.805    19.572     0.200
     6.443    20.509     0.200
     6.443    19.908     0.200
     6.663    20.238     0.200
     7.293    22.585     0.200
     8.015    20.770     0.200
    12.722    32.733     0.200
    12.854    33.890     0.200
    14.033    33.834     0.200
    14.220    34.701     0.200
    14.321    35.274     0.200
    14.593    34.895     0.200
    14.925    34.724     0.200
    15.028    34.917     0.200
    17.685    37.417     0.200
    18.185    37.975     0.200
    18.185    38.719     0.200
     1.614    10.636     0.200
     2.013    10.984     0.200
     2.013    11.085     0.200
     2.389    12.497     0.200
     2.389    12.598     0.200
     2.833    11.817     0.200
     2.871    12.774     0.200
     3.227    12.819     0.200
     3.499    14.042     0.200
     3.593    15.648     0.200
     4.155    14.086     0.200
     4.356    15.840     0.200
     5.494    21.367     0.200
     6.675    19.585     0.200
     6.675    20.085     0.200
     2.009    10.351     0.200
     2.011    10.027     0.200
     2.094    10.868     0.200
     2.094    10.169     0.200
     2.322    10.606     0.200
     2.331    10.502     0.200
     2.517    11.428     0.200
     2.660    12.659     0.200
     2.739    11.638     0.200
     2.779    10.668     0.200
     2.817    11.426     0.200
     3.579    13.131     0.200
     4.286    13.388     0.200
     4.286    13.587     0.200
     4.307    14.340     0.200
     4.871    15.563     0.200
     4.871    16.563     0.200
     5.262    17.096     0.200
     5.785    18.790     0.200
     5.968    16.952     0.200
     6.184    19.432     0.200
     1.823    10.511     0.200
     2.072    10.897     0.200
     2.132    11.398     0.200
     2.316    12.045     0.200
     2.447    11.322     0.200
     2.832    12.931     0.200
     2.774    12.914     0.200
     2.774    12.812     0.200
     2.851    13.301     0.200
     2.851    12.200     0.200
     3.205    14.079     0.200
     3.455    12.961     0.200
     3.479    14.187     0.200
     3.479    14.085     0.200
     3.586    14.124     0.200
     3.586    14.429     0.200
     4.012    15.758     0.200
     4.012    15.859     0.200
     4.505    17.003     0.200
     4.505    16.901     0.200
     4.564    14.822     0.200
     4.922    19.137     0.200
     4.922    20.536     0.200
     5.106    16.988     0.200
     5.305    17.470     0.200
     5.305    16.666     0.200
     5.312    18.586     0.200
     5.312    20.289     0.200
     5.312    18.687     0.200
     5.763    18.720     0.200
     5.871    19.303     0.200
     6.541    20.646     0.200
     6.541    22.052     0.200
     6.841    20.146     0.200
     7.403    22.283     0.200
     9.333    23.659     0.200
    12.881    34.359     0.200
    12.995    34.524     0.200
    13.990    35.145     0.200
    14.500    36.261     0.200
    14.519    35.101     0.200
    14.794    34.934     0.200
    17.760    38.926     0.200
    18.004    39.628     0.200
     1.989    10.573     0.200
     2.178    10.464     0.200
     2.474    11.108     0.200
     2.687    11.728     0.200
     2.792    12.107     0.200
     2.967    12.255     0.200
     2.967    12.055     0.200
     3.382    12.012     0.200
     3.404    13.153     0.200
     3.677    13.675     0.200
     3.677    13.475     0.200
     3.962    15.544     0.200
     3.962    15.947     0.200
     4.422    13.876     0.200
     4.422    14.076     0.200
     4.401    16.025     0.200
     4.401    15.923     0.200
     4.877    15.665     0.200
     4.877    19.766     0.200
     5.204    16.555     0.200
     5.204    16.356     0.200
     5.439    17.015     0.200
     5.601    18.125     0.200
     5.601    19.293     0.200
     5.713    18.456     0.200
     6.630    19.814     0.200
     6.630    20.314     0.200
     6.869    19.226     0.200
     6.869    19.425     0.200
     7.548    23.402     0.200
     9.403    26.347     0.200
    14.202    34.038     0.200
     2.239    11.198     0.200
     2.570    12.335     0.200
     2.647    12.135     0.200
     3.047    12.971     0.200
     3.329    12.779     0.200
     3.726    14.048     0.200
     3.946    16.279     0.200
     4.328    14.517     0.200
     4.864    16.868     0.200
     5.310    19.064     0.200
     5.310    19.467     0.200
     2.185    10.314     0.200
     2.327    11.351     0.200
     2.522    11.878     0.200
     2.993    12.178     0.200
     2.993    11.779     0.200
     3.310    13.277     0.200
     5.348    18.693     0.200
     2.300    11.084     0.200
     2.592    11.184     0.200
     2.867    12.475     0.200
     3.384    13.235     0.200
     4.079    15.128     0.200
     4.306    13.579     0.200
     5.032    18.512     0.200
     7.192    20.002     0.200
     2.236    11.180     0.200
     2.236    10.981     0.200
     2.565    12.243     0.200
     2.565    11.841     0.200
     2.649    11.970     0.200
     2.649    12.368     0.200
     3.043    13.067     0.200
     3.332    11.690     0.200
     3.374    13.904     0.200
     3.374    14.107     0.200
     3.946    15.726     0.200
     4.333    14.308     0.200
     4.350    15.918     0.200
     4.350    15.515     0.200
     5.309    19.530     0.200
     1.830    10.656     0.200
     2.289    10.805     0.200
     2.690    12.219     0.200
     2.733    12.422     0.200
     3.148    12.471     0.200
     3.735    15.322     0.200
     4.079    13.509     0.200
     4.961    19.209     0.200
     2.299    10.943     0.200
     2.591    11.235     0.200
     2.864    12.455     0.200
     3.383    13.195     0.200
     3.622    14.798     0.200
     3.622    14.001     0.200
     3.994    15.964     0.200
     4.079    15.065     0.200
     4.312    14.455     0.200
     4.543    16.651     0.200
     5.028    18.600     0.200
     2.300    11.363     0.200
     2.457    12.330     0.200
     2.541    12.645     0.200
     2.608    12.273     0.200
     3.025    12.802     0.200
     3.239    13.603     0.200
     3.822    15.599     0.200
     3.766    16.357     0.200
     4.284    16.807     0.200
     4.675    18.943     0.200
     5.068    19.657     0.200
     5.750    19.502     0.200
    13.759    32.917     0.200
    18.235    38.638     0.200
    18.321    38.921     0.200
     2.239    11.555     0.200
     2.564    12.670     0.200
     2.644    12.320     0.200
     2.765    13.011     0.200
     2.765    12.815     0.200
     2.765    13.909     0.200
     3.043    12.264     0.200
     3.043    13.467     0.200
     3.340    13.005     0.200
     3.412    14.968     0.200
     3.369    13.768     0.200
     3.369    13.667     0.200
     3.369    14.120     0.200
     3.727    14.787     0.200
     3.940    14.796     0.200
     4.340    14.527     0.200
     4.347    16.658     0.200
     4.347    16.557     0.200
     4.858    19.392     0.200
     4.858    17.892     0.200
     5.257    17.328     0.200
     5.257    17.430     0.200
     5.302    18.715     0.200
     5.302    18.613     0.200
     5.513    17.750     0.200
     5.510    18.484     0.200
     5.510    19.187     0.200
     5.624    19.075     0.200
     6.678    20.447     0.200
     6.882    20.466     0.200
     8.128    20.328     0.200
     8.128    21.132     0.200
     9.909    26.249     0.200
     9.924    26.774     0.200
    10.057    26.816     0.200
    10.057    26.918     0.200
    12.623    32.678     0.200
    12.735    34.364     0.200
    14.046    34.462     0.200
    14.046    34.009     0.200
    14.264    31.922     0.200
    14.264    32.383     0.200
    14.257    35.110     0.200
    14.276    34.888     0.200
    14.677    34.002     0.200
    14.677    37.502     0.200
    14.881    35.930     0.200
    15.102    37.444     0.200
    15.304    35.585     0.200
    15.821    41.054     0.200
    16.309    36.660     0.200
    16.309    39.660     0.200
    16.991    38.999     0.200
    17.971    38.360     0.200
    17.971    39.079     0.200
    18.124    41.171     0.200
    19.249    43.042     0.200
    20.215    43.216     0.200
     2.246    11.409     0.200
     2.575    12.671     0.200
     2.640    12.119     0.200
     2.763    10.986     0.200
     3.054    13.787     0.200
     3.365    13.548     0.200
     3.365    13.649     0.200
     3.733    14.057     0.200
     3.939    15.460     0.200
     4.329    15.303     0.200
     4.329    14.803     0.200
     4.340    17.173     0.200
     4.856    19.247     0.200
     5.303    19.742     0.200
     2.245    11.383     0.200
     2.566    12.830     0.200
     2.637    11.605     0.200
     2.758    13.198     0.200
     4.344    14.286     0.200
     5.518    18.082     0.200
     2.247    11.441     0.200
     2.247    11.543     0.200
     2.572    12.851     0.200
     2.572    12.647     0.200
     2.637    12.493     0.200
     3.052    13.442     0.200
     3.362    13.826     0.200
     3.735    14.577     0.200
     3.735    14.679     0.200
     3.934    16.750     0.200
     3.934    16.649     0.200
     4.336    14.958     0.200
     4.336    14.662     0.200
     4.339    16.533     0.200
     5.297    19.744     0.200
     5.522    16.828     0.200
     5.522    18.031     0.200
     5.501    20.864     0.200
     6.686    21.739     0.200
     6.888    20.283     0.200
     6.888    20.588     0.200
     1.915    11.177     0.200
     2.232    11.271     0.200
     2.564    13.006     0.200
     2.564    12.506     0.200
     2.654    12.155     0.200
     2.776    12.527     0.200
     3.040    13.346     0.200
     3.040    13.448     0.200
     3.327    12.888     0.200
     3.327    13.189     0.200
     3.379    13.688     0.200
     3.379    13.587     0.200
     3.719    14.720     0.200
     3.951    15.008     0.200
     3.951    14.906     0.200
     4.354    16.506     0.200
     4.869    18.996     0.200
     4.869    19.097     0.200
     4.869    18.894     0.200
     5.314    18.107     0.200
     5.509    17.534     0.200
     5.509    19.334     0.200
     5.624    19.291     0.200
     6.670    20.782     0.200
     6.871    20.338     0.200
     6.871    20.139     0.200
     8.115    22.717     0.200
     9.914    26.823     0.200
    14.059    35.448     0.200
    18.514    40.286     0.200
    18.514    42.762     0.200
    20.474    39.885     0.200
    20.474    40.366     0.200
     0.962     9.559     0.200
     1.920    10.880     0.200
     2.226    11.500     0.200
     2.560    12.809     0.200
     2.660    12.242     0.200
     3.035    13.166     0.200
     3.035    14.066     0.200
     3.385    13.675     0.200
     3.385    13.775     0.200
     3.713    15.252     0.200
     4.876    17.484     0.200
     5.320    19.798     0.200
     5.320    19.998     0.200
     1.898    11.220     0.200
     2.251    11.402     0.200
     2.251    11.202     0.200
     2.634    12.334     0.200
     3.056    13.401     0.200
     3.359    12.368     0.200
     3.359    14.067     0.200
     3.738    15.141     0.200
     3.738    15.341     0.200
     3.932    15.884     0.200
     3.932    15.184     0.200
     4.850    19.172     0.200
     5.296    19.669     0.200
     5.296    20.069     0.200
     6.890    20.162     0.200
     1.904    11.208     0.200
     2.244    11.536     0.200
     2.573    13.491     0.200
     2.642    12.286     0.200
     3.333    13.031     0.200
     3.368    13.118     0.200
     3.368    13.516     0.200
     3.731    15.086     0.200
     3.731    14.184     0.200
     3.941    15.528     0.200
     4.329    14.798     0.200
     4.859    18.917     0.200
     4.859    19.218     0.200
     5.305    19.712     0.200
     5.305    19.911     0.200
     6.681    21.547     0.200
     6.881    20.623     0.200
     2.245    11.310     0.200
     2.571    11.413     0.200
     2.638    12.122     0.200
     4.337    14.703     0.200
     2.211    11.389     0.200
     2.538    12.679     0.200
     4.350    14.527     0.200
     2.228    11.278     0.200
     2.555    12.670     0.200
     2.654    12.211     0.200
     3.034    13.282     0.200
     3.379    14.155     0.200
     3.949    13.595     0.200
     4.342    14.510     0.200
     4.867    16.987     0.200
     5.247    17.150     0.200
     6.874    20.069     0.200
     2.046    10.354     0.200
     2.163    10.187     0.200
     2.511    11.433     0.200
     2.562    11.430     0.200
     4.577    14.623     0.200
     4.577    16.826     0.200
     4.712    15.147     0.200
     6.065    19.354     0.200
     1.610     8.643     0.200
     2.147    10.064     0.200
     2.616    11.102     0.200
     2.823    11.186     0.200
     3.062    10.790     0.200
     3.013    12.269     0.200
     3.594    13.283     0.200
     4.110    12.859     0.200
     4.160    14.582     0.200
     5.081    17.533     0.200
     5.598    17.858     0.200
     5.553    17.819     0.200
     2.246    11.392     0.200
     2.569    12.724     0.200
     2.569    12.224     0.200
     2.637    12.229     0.200
     3.050    12.706     0.200
     3.050    13.405     0.200
     3.418    15.210     0.200
     3.735    14.918     0.200
     4.341    14.544     0.200
     5.295    19.809     0.200
     6.889    20.003     0.200
     6.889    20.304     0.200
     2.074    11.388     0.200
     2.369    12.045     0.200
     2.893    12.637     0.200
     3.416    14.131     0.200
     3.416    13.931     0.200
     4.557    14.916     0.200
     4.863    19.846     0.200
     5.259    19.623     0.200
     1.631     9.084     0.200
     1.631     8.682     0.200
     2.117    10.709     0.200
     2.154    10.878     0.200
     2.734    11.304     0.200
     2.760    11.604     0.200
     2.796    11.790     0.200
     3.405    12.580     0.200
     3.405    12.881     0.200
     3.306    12.630     0.200
     4.016    12.848     0.200
     4.266    14.834     0.200
     4.214    16.334     0.200
     4.614    15.770     0.200
     4.614    17.469     0.200
     4.820    13.964     0.200
     5.486    17.597     0.200
     5.545    17.844     0.200
     5.772    18.853     0.200
     5.872    16.590     0.200
     5.872    17.090     0.200
     7.547    20.544     0.200
     8.789    25.554     0.200
    13.355    33.862     0.200
    17.299    37.966     0.200
     2.263    11.458     0.200
     2.578    11.982     0.200
     2.692    13.152     0.200
     4.657    14.418     0.200
     2.234    11.383     0.200
     2.565    12.626     0.200
     2.565    12.728     0.200
     2.651    12.219     0.200
     3.041    12.463     0.200
     3.041    13.361     0.200
     3.330    11.998     0.200
     3.330    13.298     0.200
     3.376    13.855     0.200
     3.721    14.728     0.200
     4.332    14.603     0.200
     4.867    18.062     0.200
     5.252    17.167     0.200
     5.311    19.775     0.200
     5.511    17.950     0.200
     6.873    20.342     0.200
     6.873    20.943     0.200
     2.241    11.239     0.200
     2.573    12.761     0.200
     2.646    12.206     0.200
     2.639    11.488     0.200
     1.884    10.139     0.200
     1.997    10.314     0.200
     2.182    11.262     0.200
     2.286    11.351     0.200
     2.775    12.338     0.200
     2.854    12.219     0.200
     3.374    12.347     0.200
     3.506    13.611     0.200
     3.563    13.346     0.200
     4.101    15.859     0.200
     4.101    15.960     0.200
     4.519    13.984     0.200
     4.579    17.083     0.200
     5.028    16.842     0.200
     5.247    15.990     0.200
     5.405    19.444     0.200
     6.748    18.972     0.200
     6.748    19.472     0.200
     1.090    11.165     0.200
     2.242    11.423     0.200
     2.566    12.643     0.200
     2.641    12.361     0.200
     3.046    13.128     0.200
     3.046    13.331     0.200
     3.342    13.079     0.200
     3.366    14.308     0.200
     3.730    14.951     0.200
     3.937    17.039     0.200
     3.937    16.734     0.200
     4.088    16.476     0.200
     4.341    14.623     0.200
     4.343    16.198     0.200
     4.855    16.626     0.200
     4.855    20.025     0.200
     5.299    19.650     0.200
     5.516    17.215     0.200
     6.886    20.427     0.200
     6.886    20.529     0.200
     2.246    11.363     0.200
     2.571    12.771     0.200
     2.571    12.669     0.200
     2.638    12.283     0.200
     2.760     9.963     0.200
     3.051    12.372     0.200
     3.051    13.169     0.200
     3.341    13.390     0.200
     3.341    12.992     0.200
     3.363    13.726     0.200
     3.734    14.702     0.200
     3.935    16.143     0.200
     3.935    15.948     0.200
     4.091    16.323     0.200
     4.337    14.869     0.200
     4.337    15.666     0.200
     4.340    16.331     0.200
     4.340    16.526     0.200
     4.853    19.534     0.200
     4.853    18.933     0.200
     5.298    19.741     0.200
     5.298    20.045     0.200
     5.502    19.859     0.200
     5.520    17.249     0.200
     6.685    19.965     0.200
     6.887    20.202     0.200
     2.059    10.212     0.200
     2.059    10.314     0.200
     2.313    10.552     0.200
     2.269    11.064     0.200
     2.288    10.642     0.200
     2.842    11.674     0.200
     3.233    12.119     0.200
     3.543    13.099     0.200
     4.267    14.345     0.200
     4.267    14.747     0.200
     4.267    13.255     0.200
     4.336    13.646     0.200
     4.336    13.545     0.200
     4.740    14.932     0.200
     4.825    16.139     0.200
     5.232    16.980     0.200
     5.738    19.181     0.200
     5.788    18.498     0.200
     6.020    16.986     0.200
     6.130    19.011     0.200
     6.130    19.312     0.200
     6.120    18.816     0.200
     6.120    18.715     0.200
     6.280    19.251     0.200
     7.643    18.340     0.200
    14.730    35.643     0.200
     2.248    11.391     0.200
     2.635    12.173     0.200
     2.756    11.157     0.200
     3.052    12.600     0.200
     3.360    13.714     0.200
     3.737    15.715     0.200
     3.931    15.144     0.200
     3.931    15.340     0.200
     4.340    14.667     0.200
     4.337    16.605     0.200
     5.267    17.960     0.200
     5.294    19.443     0.200
     5.294    19.748     0.200
     5.503    19.704     0.200
     6.891    21.207     0.200
     2.241    11.701     0.200
     2.564    13.241     0.200
     2.564    12.940     0.200
     2.640    12.346     0.200
     3.045    13.622     0.200
     3.365    14.090     0.200
     3.365    14.590     0.200
     3.730    14.926     0.200
     3.936    17.229     0.200
     4.344    15.061     0.200
     4.344    14.862     0.200
     4.343    17.275     0.200
     4.853    19.618     0.200
     5.260    17.770     0.200
     5.297    20.348     0.200
     5.515    17.802     0.200
     5.510    20.460     0.200
     6.887    20.489     0.200
     6.887    20.591     0.200
     1.967    11.418     0.200
     2.197    11.437     0.200
     2.497    12.739     0.200
     2.671    12.606     0.200
     2.779    12.545     0.200
     2.988    12.297     0.200
     2.988    13.500     0.200
     3.390    14.014     0.200
     3.390    13.912     0.200
     3.950    15.373     0.200
     3.950    15.072     0.200
     3.950    16.572     0.200
     4.383    16.824     0.200
     4.383    16.926     0.200
     4.407    15.340     0.200
     4.407    14.942     0.200
     4.866    18.186     0.200
     4.866    19.589     0.200
     5.221    18.540     0.200
     5.294    19.887     0.200
     5.294    19.687     0.200
     5.460    17.259     0.200
     5.578    19.975     0.200
     5.690    19.470     0.200
     6.878    20.604     0.200
    14.018    36.206     0.200
    18.482    41.685     0.200
    18.568    40.723     0.200
     1.977    11.105     0.200
     2.491    12.500     0.200
     4.399    15.136     0.200
     1.401    10.385     0.200
     1.964    11.215     0.200
     2.203    11.231     0.200
     2.497    12.699     0.200
     2.663    12.260     0.200
     2.992    13.423     0.200
     3.382    12.875     0.200
     3.382    14.075     0.200
     3.941    16.448     0.200
     4.416    14.808     0.200
     4.856    19.563     0.200
     5.284    19.675     0.200
     5.284    19.875     0.200
     6.888    21.651     0.200
     1.960    11.545     0.200
     2.201    11.428     0.200
     2.201    11.529     0.200
     2.506    12.873     0.200
     2.506    14.073     0.200
     2.669    12.773     0.200
     2.779    12.189     0.200
     2.995    14.262     0.200
     3.389    14.069     0.200
     3.951    16.610     0.200
     4.396    15.415     0.200
     4.379    17.011     0.200
     4.867    19.120     0.200
     4.867    19.520     0.200
     5.225    18.845     0.200
     5.298    19.693     0.200
     5.466    19.727     0.200
     5.466    19.227     0.200
     5.569    20.031     0.200
     5.569    20.131     0.200
     5.681    19.521     0.200
     6.649    20.720     0.200
     6.877    21.067     0.200
     6.877    20.766     0.200
    14.024    35.855     0.200
    17.973    40.668     0.200
    18.488    41.968     0.200
    18.573    40.960     0.200
     1.974    11.351     0.200
     2.190    11.537     0.200
     2.490    12.029     0.200
     2.678    12.642     0.200
     2.678    12.443     0.200
     2.981    11.900     0.200
     2.981    13.200     0.200
     3.377    14.287     0.200
     3.397    14.150     0.200
     3.397    13.251     0.200
     3.957    16.218     0.200
     3.957    16.519     0.200
     4.390    16.557     0.200
     4.409    15.038     0.200
     4.409    14.937     0.200
     4.872    19.634     0.200
     5.300    19.345     0.200
     1.133     9.404     0.200
     1.574    10.654     0.200
     1.714    11.324     0.200
     1.965    11.685     0.200
     2.197    11.479     0.200
     2.671    12.646     0.200
     2.990    12.028     0.200
     2.990    13.028     0.200
     3.391    12.748     0.200
     3.952    15.901     0.200
     3.952    16.401     0.200
     4.868    19.413     0.200
     5.297    20.303     0.200
     5.575    18.958     0.200
     1.968    11.512     0.200
     2.194    11.375     0.200
     2.498    11.930     0.200
     2.675    12.261     0.200
     3.395    13.963     0.200
     3.690    15.515     0.200
     4.401    15.217     0.200
     4.872    18.226     0.200
     5.301    19.418     0.200
     6.872    19.376     0.200
     1.912    10.939     0.200
     2.234    11.185     0.200
     2.653    11.694     0.200
     3.042    11.853     0.200
     3.042    13.052     0.200
     3.379    13.627     0.200
     3.720    13.940     0.200
     3.720    14.140     0.200
     4.327    14.457     0.200
     4.327    14.258     0.200
     4.870    19.926     0.200
     5.315    19.228     0.200
     5.315    19.427     0.200
     6.870    20.077     0.200
     6.870    18.976     0.200
     1.498    10.098     0.200
     1.611    11.088     0.200
     1.611    11.687     0.200
     1.875    11.099     0.200
     2.305    11.587     0.200
     2.573    12.559     0.200
     2.559    12.424     0.200
     2.559    12.322     0.200
     3.085    13.580     0.200
     3.277    14.137     0.200
     3.277    14.537     0.200
     3.839    16.084     0.200
     4.150    15.352     0.200
     4.273    16.810     0.200
     4.424    14.949     0.200
     4.755    19.292     0.200
     5.190    19.317     0.200
     5.511    19.067     0.200
     5.558    17.926     0.200
     5.558    17.224     0.200
     6.988    21.033     0.200
     6.988    21.633     0.200
     2.229    11.618     0.200
     2.552    12.652     0.200
     2.653    12.475     0.200
     2.653    12.373     0.200
     2.772    15.084     0.200
     2.772    13.279     0.200
     3.032    13.544     0.200
     3.032    13.239     0.200
     3.342    13.430     0.200
     3.342    12.930     0.200
     3.400    14.849     0.200
     3.377    13.821     0.200
     3.377    13.189     0.200
     3.377    13.923     0.200
     3.718    14.839     0.200
     3.718    14.144     0.200
     3.946    15.070     0.200
     4.348    14.786     0.200
     4.356    16.791     0.200
     4.864    18.567     0.200
     4.864    19.465     0.200
     5.305    19.314     0.200
     5.305    19.213     0.200
     5.502    17.826     0.200
     5.502    17.021     0.200
     5.521    18.893     0.200
     5.521    21.190     0.200
     5.521    18.994     0.200
     5.521    19.291     0.200
     5.622    19.417     0.200
     5.635    19.343     0.200
     6.669    20.294     0.200
     6.669    20.896     0.200
     6.877    19.872     0.200
     6.877    20.872     0.200
     8.130    21.242     0.200
     9.446    27.098     0.200
    12.634    34.496     0.200
    14.046    35.008     0.200
    14.046    34.383     0.200
    14.254    31.587     0.200
    14.266    36.140     0.200
    14.285    35.325     0.200
    14.880    34.579     0.200
    17.394    37.637     0.200
    17.976    40.048     0.200
    17.976    39.525     0.200
    17.976    40.447     0.200
     2.235    11.219     0.200
     2.645    12.339     0.200
     2.764    12.149     0.200
     3.038    13.153     0.200
     3.348    12.838     0.200
     3.348    12.338     0.200
     3.406    14.655     0.200
     3.406    14.554     0.200
     3.369    13.788     0.200
     3.369    13.288     0.200
     3.369    13.589     0.200
     3.725    14.435     0.200
     3.939    17.139     0.200
     4.351    14.435     0.200
     4.349    16.654     0.200
     4.856    19.035     0.200
     5.255    17.184     0.200
     5.298    19.580     0.200
     5.298    19.280     0.200
     5.508    17.433     0.200
     5.508    17.030     0.200
     5.518    18.474     0.200
     5.631    19.129     0.200
     6.677    19.991     0.200
     6.884    20.064     0.200
     6.884    20.166     0.200
     7.527    22.163     0.200
     8.136    20.357     0.200
     9.325    27.087     0.200
    12.633    33.984     0.200
    14.040    34.933     0.200
    14.261    32.165     0.200
    14.267    35.212     0.200
    14.286    35.291     0.200
    14.873    34.032     0.200
    15.108    40.099     0.200
    17.401    39.235     0.200
    17.968    38.859     0.200
    17.968    41.015     0.200
     1.875    10.806     0.200
     2.152    10.371     0.200
     2.315    11.261     0.200
     2.543    12.011     0.200
     4.451    14.140     0.200
     4.733    19.048     0.200
     5.164    19.323     0.200
     5.164    19.424     0.200
     5.344    19.119     0.200
     7.011    20.663     0.200
     2.674    13.041     0.200
     2.692    13.632     0.200
     3.338    14.784     0.200
     2.258    11.334     0.200
     2.258    11.435     0.200
     2.578    12.899     0.200
     2.625    12.149     0.200
     2.879    12.689     0.200
     3.061    11.959     0.200
     3.350    12.490     0.200
     3.350    13.588     0.200
     3.746    14.459     0.200
     3.922    16.316     0.200
     4.341    15.118     0.200
     4.327    16.982     0.200
     4.839    19.004     0.200
     5.285    19.711     0.200
     5.285    19.508     0.200
     6.901    20.552     0.200
     6.901    19.951     0.200
     2.155    10.718     0.200
     3.664    13.514     0.200
     4.506    14.381     0.200
     1.921    10.694     0.200
     2.232    10.757     0.200
     2.253    10.614     0.200
     2.550    12.247     0.200
     2.646    11.726     0.200
     2.900    12.069     0.200
     3.034    12.706     0.200
     3.034    11.905     0.200
     3.370    12.982     0.200
     3.723    13.959     0.200
     4.357    13.963     0.200
     4.351    16.628     0.200
     4.856    17.140     0.200
     5.253    16.609     0.200
     5.296    17.600     0.200
     6.675    20.415     0.200
     6.885    19.658     0.200
     2.201    10.271     0.200
     2.666    11.641     0.200
     2.885    12.590     0.200
     2.927    13.307     0.200
     3.434    13.385     0.200
     3.641    14.374     0.200
     4.428    15.885     0.200
     4.904    17.932     0.200
     7.310    21.153     0.200
     1.659     8.147     0.200
     1.999     9.280     0.200
     2.122     9.439     0.200
     2.122     9.638     0.200
     2.469    10.191     0.200
     2.617    11.166     0.200
     2.867    10.554     0.200
     3.127    11.317     0.200
     3.560    12.862     0.200
     3.607    12.208     0.200
     4.209    13.590     0.200
     5.130    17.338     0.200
     6.608    18.689     0.200
     2.171    11.058     0.200
     2.425    11.293     0.200
     2.701    11.576     0.200
     2.921    12.200     0.200
     2.921    12.601     0.200
     2.898    11.571     0.200
     2.898    12.571     0.200
     3.470    13.393     0.200
     3.470    12.595     0.200
     4.395    15.004     0.200
     4.404    18.601     0.200
     4.546    16.640     0.200
     4.886    17.768     0.200
     4.886    19.168     0.200
     5.203    17.773     0.200
     5.944    19.623     0.200
     1.801    10.102     0.200
     2.031    10.316     0.200
     2.429    11.181     0.200
     2.421    11.374     0.200
     2.515    12.271     0.200
     2.630    12.333     0.200
     2.669    12.181     0.200
     3.181    13.003     0.200
     3.132    12.971     0.200
     3.556    13.031     0.200
     3.603    14.079     0.200
     3.684    15.027     0.200
     3.684    14.925     0.200
     3.939    14.853     0.200
     4.148    15.914     0.200
     4.148    15.711     0.200
     4.515    14.131     0.200
     4.515    14.728     0.200
     4.599    18.150     0.200
     4.599    18.650     0.200
     5.029    17.929     0.200
     5.029    18.030     0.200
     5.462    17.686     0.200
     5.462    18.788     0.200
     5.480    19.570     0.200
     5.560    18.356     0.200
     5.573    18.346     0.200
     5.573    18.342     0.200
     5.655    17.928     0.200
     5.655    16.428     0.200
     6.893    21.276     0.200
     7.034    19.743     0.200
     7.146    20.228     0.200
     7.279    23.273     0.200
     8.382    22.605     0.200
     8.382    21.105     0.200
     9.058    25.418     0.200
    13.315    32.437     0.200
    13.775    35.070     0.200
    13.776    34.531     0.200
    13.776    35.063     0.200
    13.776    34.832     0.200
    14.614    32.880     0.200
    17.704    39.739     0.200
    17.704    39.735     0.200
    18.227    38.947     0.200
    18.227    39.619     0.200
    18.312    38.645     0.200
     1.405    10.916     0.200
     2.236    11.413     0.200
     2.571    12.704     0.200
     2.906    12.799     0.200
     3.378    13.890     0.200
     3.952    13.693     0.200
     4.322    14.976     0.200
     5.316    19.568     0.200
     6.870    19.240     0.200
     2.250    11.284     0.200
     2.578    11.656     0.200
     2.578    12.852     0.200
     2.890    13.014     0.200
     3.057    13.173     0.200
     3.057    12.470     0.200
     3.336    11.417     0.200
     3.737    14.736     0.200
     3.935    13.513     0.200
     4.329    14.827     0.200
     4.329    15.022     0.200
     5.300    18.892     0.200
     2.246    11.492     0.200
     2.246    11.084     0.200
     2.575    12.346     0.200
     2.575    12.644     0.200
     2.895    12.721     0.200
     3.053    13.271     0.200
     3.366    13.315     0.200
     3.366    13.715     0.200
     3.732    14.641     0.200
     3.940    14.724     0.200
     3.940    16.124     0.200
     4.328    14.894     0.200
     4.341    16.243     0.200
     4.341    16.443     0.200
     4.858    19.011     0.200
     5.304    18.801     0.200
     5.304    19.301     0.200
     5.522    17.557     0.200
     5.522    16.157     0.200
     5.497    21.045     0.200
     5.612    19.849     0.200
     6.683    20.304     0.200
     6.882    20.586     0.200
     6.882    20.785     0.200
     7.556    25.619     0.200
     9.330    25.122     0.200
    13.588    35.930     0.200
    17.972    40.965     0.200
     0.985     8.456     0.200
     1.164     9.560     0.200
     1.389     9.836     0.200
     1.492     9.928     0.200
     1.655    11.235     0.200
     1.655    11.430     0.200
     1.697    10.745     0.200
     2.253    11.153     0.200
     2.241    10.996     0.200
     2.585    12.178     0.200
     2.635    11.989     0.200
     3.062    12.920     0.200
     3.329    13.489     0.200
     3.329    12.387     0.200
     3.739    14.518     0.200
     3.936    15.109     0.200
     3.936    15.906     0.200
     4.320    14.731     0.200
     4.855    19.190     0.200
     4.855    18.589     0.200
     5.303    19.458     0.200
     5.530    17.007     0.200
     5.530    16.804     0.200
     6.885    20.397     0.200
     1.759     9.623     0.200
     1.759     9.725     0.200
     1.871     9.913     0.200
     2.290    11.523     0.200
     2.624    11.326     0.200
     3.017    12.338     0.200
     3.270    12.790     0.200
     3.353    13.118     0.200
     3.738    13.123     0.200
     4.361    14.452     0.200
     4.720    15.466     0.200
     5.212    17.329     0.200
     5.624    18.920     0.200
     6.304    18.875     0.200
     1.999    10.504     0.200
     2.134     9.929     0.200
     2.507    10.879     0.200
     2.507    11.079     0.200
     2.763    10.998     0.200
     2.958    11.525     0.200
     3.017    11.627     0.200
     3.017    11.728     0.200
     3.241    11.520     0.200
     3.490    12.914     0.200
     3.614    12.959     0.200
     3.614    13.158     0.200
     4.063    16.320     0.200
     4.298    13.675     0.200
     4.458    15.310     0.200
     5.423    18.354     0.200
     5.563    17.921     0.200
     1.277    10.116     0.200
     1.615     9.675     0.200
     2.338    10.842     0.200
     2.551    10.851     0.200
     2.594    11.458     0.200
     2.829    11.818     0.200
     3.069    12.617     0.200
     3.344    12.804     0.200
     3.658    12.542     0.200
     4.040    14.585     0.200
     4.034    15.155     0.200
     4.315    13.579     0.200
     4.578    17.595     0.200
     5.058    18.406     0.200
     5.570    17.119     0.200
     5.816    17.956     0.200
     7.159    20.974     0.200
     1.942     9.874     0.200
     2.337    10.962     0.200
     2.551    11.068     0.200
     2.593    11.579     0.200
     3.068    12.435     0.200
     3.343    12.326     0.200
     3.497    13.233     0.200
     3.656    14.369     0.200
     4.040    15.095     0.200
     4.317    13.956     0.200
     4.577    15.727     0.200
     4.577    18.528     0.200
     5.056    18.138     0.200
     2.419     9.895     0.200
     2.423    10.743     0.200
     2.574    11.380     0.200
     2.574    12.180     0.200
     2.667    11.894     0.200
     3.147    11.091     0.200
     3.125    12.754     0.200
     3.125    13.454     0.200
     3.661    14.298     0.200
     3.661    15.398     0.200
     3.938    14.965     0.200
     4.163    15.139     0.200
     4.611    14.314     0.200
     4.611    14.415     0.200
     4.573    16.057     0.200
     4.573    17.456     0.200
     4.983    16.167     0.200
     4.983    18.567     0.200
     5.455    16.658     0.200
     5.552    18.429     0.200
     5.622    18.119     0.200
     5.640    18.625     0.200
     7.181    20.426     0.200
     7.181    20.325     0.200
    17.666    39.136     0.200
    18.167    38.909     0.200
    18.253    37.937     0.200
     1.654    10.109     0.200
     1.720     9.638     0.200
     1.989     9.808     0.200
     1.967    10.355     0.200
     2.141    10.529     0.200
     2.391    11.108     0.200
     2.391    11.210     0.200
     2.512    10.596     0.200
     2.820    11.807     0.200
     2.906    11.599     0.200
     3.024    11.918     0.200
     3.179    11.919     0.200
     3.183    13.975     0.200
     3.183    14.272     0.200
     3.160    12.037     0.200
     3.631    13.113     0.200
     3.631    12.261     0.200
     3.631    12.941     0.200
     3.833    15.476     0.200
     4.197    14.932     0.200
     4.321    13.584     0.200
     4.321    14.084     0.200
     4.605    15.881     0.200
     5.000    15.862     0.200
     5.114    17.841     0.200
     5.114    18.638     0.200
     5.282    16.369     0.200
     5.282    15.471     0.200
     5.540    18.464     0.200
     5.681    17.264     0.200
     5.681    20.412     0.200
     5.681    18.115     0.200
     5.810    18.576     0.200
     5.810    18.576     0.200
     6.370    18.178     0.200
     6.418    18.717     0.200
     6.418    19.014     0.200
     6.630    19.140     0.200
     6.630    18.741     0.200
     7.267    21.404     0.200
     7.980    19.782     0.200
     9.648    25.320     0.200
     9.608    23.682     0.200
    13.828    32.544     0.200
    14.013    31.143     0.200
    14.013    30.986     0.200
    18.219    39.439     0.200
    18.396    41.254     0.200
    18.719    41.756     0.200
     2.137    10.272     0.200
     2.736    11.178     0.200
     2.865    11.172     0.200
     2.955    11.728     0.200
     3.453    12.909     0.200
     3.506    12.897     0.200
     4.374    16.462     0.200
     4.391    14.470     0.200
     4.862    18.470     0.200
     2.250    10.171     0.200
     2.234    10.458     0.200
     2.560    11.653     0.200
     2.627    10.868     0.200
     2.744    10.605     0.200
     2.880    11.717     0.200
     3.048    11.454     0.200
     3.350    11.833     0.200
     3.918    14.799     0.200
     4.835    18.095     0.200
     5.276    18.257     0.200
     5.518    15.924     0.200
     6.906    19.433     0.200
     2.249    10.346     0.200
     2.556    11.663     0.200
     3.046    12.346     0.200
     2.196    10.299     0.200
     2.292    10.281     0.200
     2.525    11.558     0.200
     2.685    11.485     0.200
     2.803    11.713     0.200
     2.938    12.132     0.200
     3.326    12.004     0.200
     3.409    12.443     0.200
     3.977    15.311     0.200
     4.351    13.839     0.200
     4.389    16.401     0.200
     4.894    16.609     0.200
     5.332    19.096     0.200
     6.636    20.276     0.200
     6.847    19.411     0.200
     2.250    11.323     0.200
     2.241    11.030     0.200
     2.577    12.406     0.200
     2.635    12.131     0.200
     2.889    12.765     0.200
     3.056    13.113     0.200
     3.361    13.561     0.200
     3.424    14.121     0.200
     3.737    14.767     0.200
     3.934    14.675     0.200
     4.852    18.861     0.200
     5.298    19.454     0.200
     6.888    20.398     0.200
     7.550    22.871     0.200
     2.254    11.271     0.200
     2.579    12.475     0.200
     3.059    13.268     0.200
     3.741    14.212     0.200
     3.930    16.513     0.200
     4.333    15.107     0.200
     4.848    18.699     0.200
     5.272    17.852     0.200
     5.294    19.190     0.200
     1.720     9.522     0.200
     1.827     9.265     0.200
     2.209    10.513     0.200
     2.450    10.497     0.200
     2.633    11.067     0.200
     2.729    11.746     0.200
     2.904    11.497     0.200
     3.338    11.741     0.200
     3.436    14.187     0.200
     4.348    17.744     0.200
     4.684    14.024     0.200
     7.403    20.096     0.200
     2.251    11.320     0.200
     2.241    10.530     0.200
     2.580    12.888     0.200
     3.058    13.400     0.200
     3.362    12.763     0.200
     3.737    14.673     0.200
     3.935    14.163     0.200
     4.327    13.689     0.200
     4.853    17.949     0.200
     5.300    20.038     0.200
     6.886    19.721     0.200
     1.900    11.105     0.200
     2.250    11.415     0.200
     2.240    10.737     0.200
     2.574    12.439     0.200
     2.574    12.634     0.200
     2.634    12.241     0.200
     2.756    10.913     0.200
     2.887    12.975     0.200
     3.055    13.226     0.200
     3.344    12.652     0.200
     3.344    13.152     0.200
     3.359    12.974     0.200
     3.738    14.548     0.200
     3.931    15.297     0.200
     3.931    16.398     0.200
     4.335    16.476     0.200
     4.337    14.956     0.200
     4.337    15.057     0.200
     4.849    18.789     0.200
     4.849    18.890     0.200
     5.294    19.390     0.200
     5.294    19.195     0.200
     5.524    17.805     0.200
     5.524    17.008     0.200
     5.500    19.993     0.200
     5.613    19.330     0.200
     6.574    22.657     0.200
     6.891    20.252     0.200
     7.546    24.509     0.200
     8.282    23.518     0.200
    13.578    33.614     0.200
    14.041    36.113     0.200
    18.495    41.140     0.200
    18.580    40.162     0.200
    20.798    40.402     0.200
     1.756     9.668     0.200
     1.793     9.333     0.200
     2.059    10.829     0.200
     2.127    10.138     0.200
     2.336     9.898     0.200
     2.726    11.853     0.200
     2.901    12.412     0.200
     2.974    12.456     0.200
     3.437    13.355     0.200
     4.450    16.035     0.200
     4.497    14.077     0.200
     4.894    17.045     0.200
     5.158    17.571     0.200
     5.301    19.102     0.200
     5.682    18.346     0.200
     6.859    19.311     0.200
     2.224    11.017     0.200
     2.224    11.217     0.200
     2.330    11.475     0.200
     2.330    11.877     0.200
     2.621    12.082     0.200
     2.735    12.657     0.200
     2.735    12.856     0.200
     2.880    12.856     0.200
     3.202    11.899     0.200
     3.174    13.429     0.200
     3.174    12.429     0.200
     3.360    13.548     0.200
     3.360    13.653     0.200
     3.536    14.101     0.200
     3.789    15.053     0.200
     3.962    15.629     0.200
     4.138    15.076     0.200
     4.138    14.478     0.200
     4.288    16.525     0.200
     4.884    18.673     0.200
     4.884    19.474     0.200
     5.325    19.224     0.200
     5.325    19.024     0.200
     5.335    18.705     0.200
     5.369    19.415     0.200
     5.459    19.186     0.200
     5.635    19.105     0.200
     6.732    21.703     0.200
     6.722    21.726     0.200
     6.855    20.774     0.200
    18.595    42.764     0.200
    18.680    41.762     0.200
     2.573    11.269     0.200
     2.927    11.339     0.200
     3.039    12.139     0.200
     3.705    13.665     0.200
     3.977    14.387     0.200
     4.298    14.036     0.200
     4.368    15.423     0.200
     4.895    16.271     0.200
     5.236    16.289     0.200
     5.345    16.628     0.200
     6.844    18.828     0.200
     0.838     6.938     0.200
     2.119     9.495     0.200
     2.945    11.760     0.200
     4.293    13.229     0.200
     1.923    11.172     0.200
     1.923    10.672     0.200
     2.319    11.855     0.200
     2.463    10.375     0.200
     2.463    12.375     0.200
     2.576    11.960     0.200
     2.857    13.574     0.200
     3.052    13.324     0.200
     3.052    13.425     0.200
     3.371    14.279     0.200
     3.493    14.159     0.200
     3.493    13.259     0.200
     3.644    14.589     0.200
     4.011    16.408     0.200
     4.062    15.417     0.200
     4.297    15.172     0.200
     4.565    17.339     0.200
     4.565    17.839     0.200
     5.051    18.778     0.200
     5.236    18.515     0.200
     5.236    18.855     0.200
     5.335    19.156     0.200
     5.335    18.957     0.200
     6.867    19.178     0.200
     7.173    21.414     0.200
     7.173    21.114     0.200
     7.312    25.685     0.200
     8.246    22.282     0.200
     8.246    21.971     0.200
     8.596    24.008     0.200
    12.435    34.205     0.200
    13.324    36.531     0.200
    13.868    34.778     0.200
    13.868    35.728     0.200
    13.868    34.639     0.200
    14.601    36.325     0.200
    14.782    39.415     0.200
    15.312    37.659     0.200
    15.312    39.023     0.200
    17.695    39.315     0.200
    17.695    41.285     0.200
    17.695    41.091     0.200
    17.874    39.926     0.200
    18.283    39.650     0.200
    18.368    39.498     0.200
    19.016    41.404     0.200
     2.425    12.073     0.200
     2.598    11.948     0.200
     2.725    12.964     0.200
     2.725    12.862     0.200
     2.720    12.825     0.200
     3.224    14.038     0.200
     3.194    13.638     0.200
     3.194    13.444     0.200
     3.419    13.468     0.200
     3.419    13.167     0.200
     3.594    15.329     0.200
     3.777    14.791     0.200
     3.912    15.222     0.200
     4.162    16.503     0.200
     4.271    16.831     0.200
     4.311    14.758     0.200
     4.697    17.557     0.200
     5.163    19.114     0.200
     5.356    18.861     0.200
     5.442    18.055     0.200
     5.463    19.061     0.200
     5.463    18.920     0.200
     6.862    20.889     0.200
     7.041    21.202     0.200
     7.129    24.176     0.200
     7.710    22.290     0.200
     8.190    21.794     0.200
     8.450    23.959     0.200
     8.997    28.177     0.200
    12.516    34.303     0.200
    13.442    34.199     0.200
    13.949    35.374     0.200
    13.949    35.360     0.200
    14.190    35.271     0.200
    14.209    35.650     0.200
    14.450    36.638     0.200
    14.450    35.468     0.200
    14.924    37.503     0.200
    15.215    35.731     0.200
    15.969    38.266     0.200
    16.375    38.977     0.200
    17.505    37.444     0.200
    17.820    39.111     0.200
    17.820    39.361     0.200
    17.820    38.832     0.200
    17.977    37.813     0.200
    17.998    38.528     0.200
    19.118    43.358     0.200
    19.118    41.858     0.200
     2.069    10.356     0.200
     2.432    11.221     0.200
     2.465    11.343     0.200
     2.744    12.388     0.200
     2.721    11.957     0.200
     3.196    11.709     0.200
     3.237    13.128     0.200
     3.783    15.159     0.200
     3.916    15.108     0.200
     4.286    14.090     0.200
     4.703    17.721     0.200
     5.175    18.117     0.200
     5.448    18.334     0.200
     1.910    11.385     0.200
     2.244    11.693     0.200
     2.244    11.795     0.200
     2.242    11.504     0.200
     2.560    12.792     0.200
     2.636    12.513     0.200
     2.636    12.317     0.200
     2.889    13.057     0.200
     3.045    13.639     0.200
     3.045    13.740     0.200
     3.355    13.513     0.200
     3.360    14.167     0.200
     3.360    14.066     0.200
     3.734    14.902     0.200
     3.929    16.122     0.200
     3.929    16.020     0.200
     4.354    15.065     0.200
     4.354    15.268     0.200
     4.847    19.212     0.200
     4.847    19.416     0.200
     5.264    17.950     0.200
     5.264    17.848     0.200
     5.288    19.862     0.200
     5.288    20.057     0.200
     5.515    18.416     0.200
     5.515    17.119     0.200
     5.514    20.733     0.200
     5.627    19.377     0.200
     6.685    20.957     0.200
     6.894    20.820     0.200
     6.894    20.523     0.200
     7.537    21.221     0.200
    13.573    34.680     0.200
    14.031    36.355     0.200
    17.959    39.646     0.200
     2.252    11.438     0.200
     2.239    11.193     0.200
     2.578    11.831     0.200
     2.633    12.494     0.200
     3.058    12.332     0.200
     3.740    14.479     0.200
     4.332    15.067     0.200
     1.487     9.810     0.200
     1.789     9.287     0.200
     1.856     9.700     0.200
     1.840     9.793     0.200
     2.011    10.494     0.200
     2.269    10.986     0.200
     2.299    11.128     0.200
     2.649    12.144     0.200
     2.699    11.761     0.200
     3.060    12.653     0.200
     3.043    12.047     0.200
     3.109    12.272     0.200
     3.332    12.980     0.200
     3.700    13.785     0.200
     4.329    13.640     0.200
     4.741    16.730     0.200
     4.864    16.000     0.200
     5.661    18.998     0.200
     6.281    19.056     0.200
     7.130    20.553     0.200
     7.874    21.674     0.200
     1.859     9.458     0.200
     1.789     9.176     0.200
     1.789     9.074     0.200
     1.834     9.650     0.200
     2.307    10.937     0.200
     2.264    10.633     0.200
     2.705    11.393     0.200
     2.705    11.694     0.200
     3.065    13.293     0.200
     3.043    11.650     0.200
     3.159    11.394     0.200
     3.333    12.660     0.200
     3.296    12.189     0.200
     3.703    14.046     0.200
     3.767    12.998     0.200
     3.767    12.768     0.200
     4.320    13.546     0.200
     4.331    14.117     0.200
     4.739    15.949     0.200
     4.866    15.672     0.200
     5.163    16.108     0.200
     5.163    15.206     0.200
     5.664    18.855     0.200
     5.664    18.555     0.200
     5.774    18.769     0.200
     5.774    16.472     0.200
     5.774    16.929     0.200
     6.283    18.438     0.200
     6.283    18.039     0.200
     6.500    18.502     0.200
     7.131    19.641     0.200
     7.874    21.072     0.200
     7.908    19.076     0.200
     9.513    25.043     0.200
    12.760    34.452     0.200
    13.882    30.156     0.200
    13.882    30.629     0.200
    13.953    35.926     0.200
    14.299    34.184     0.200
    14.319    33.458     0.200
    14.344    31.997     0.200
    14.344    34.169     0.200
    14.344    32.778     0.200
    14.781    33.061     0.200
    14.781    35.260     0.200
    17.782    36.844     0.200
    18.291    38.205     0.200
    18.747    39.184     0.200
    19.445    39.135     0.200
     1.962    10.635     0.200
     1.962    10.435     0.200
     2.351    11.695     0.200
     2.447    12.173     0.200
     2.447    10.673     0.200
     2.600    12.198     0.200
     2.687    12.480     0.200
     2.687    12.379     0.200
     3.063    13.028     0.200
     3.063    12.785     0.200
     3.246    13.056     0.200
     3.643    12.919     0.200
     3.643    12.219     0.200
     3.618    15.314     0.200
     4.008    14.156     0.200
     4.008    14.456     0.200
     4.080    15.826     0.200
     4.080    15.326     0.200
     4.519    13.694     0.200
     4.519    14.395     0.200
     4.534    18.129     0.200
     4.534    18.429     0.200
     4.970    17.737     0.200
     5.433    18.027     0.200
     5.531    17.093     0.200
     5.531    16.892     0.200
     5.522    18.449     0.200
     5.522    17.890     0.200
     5.720    17.380     0.200
     5.720    16.580     0.200
     6.963    21.381     0.200
     6.968    22.823     0.200
     7.210    20.293     0.200
     7.210    19.993     0.200
    12.661    33.682     0.200
    13.254    34.457     0.200
    13.729    33.253     0.200
    13.729    32.714     0.200
    13.729    34.814     0.200
    13.729    34.213     0.200
    17.413    36.725     0.200
    17.641    40.464     0.200
    17.641    39.337     0.200
    17.641    40.084     0.200
    18.173    39.751     0.200
    18.258    38.737     0.200
     1.986    10.772     0.200
     2.146    10.699     0.200
     2.896    12.154     0.200
     3.040    11.767     0.200
     3.158    12.695     0.200
     3.563    13.766     0.200
     3.641    14.852     0.200
     5.102    16.604     0.200
     5.177    19.327     0.200
     5.669    19.187     0.200
     6.564    19.540     0.200
     1.899    11.132     0.200
     2.245    11.297     0.200
     2.251    10.929     0.200
     2.581    12.471     0.200
     2.581    11.870     0.200
     2.645    12.021     0.200
     2.900    12.459     0.200
     3.055    13.144     0.200
     3.055    13.042     0.200
     3.372    13.540     0.200
     4.090    16.158     0.200
     4.315    14.637     0.200
     4.315    14.738     0.200
     4.343    16.202     0.200
     4.865    18.214     0.200
     4.865    19.112     0.200
     5.261    17.304     0.200
     5.314    19.285     0.200
     5.314    19.480     0.200
     5.524    17.836     0.200
     5.524    17.633     0.200
     5.606    18.886     0.200
     6.680    20.536     0.200
     6.874    20.272     0.200
    14.064    35.915     0.200
    17.981    41.052     0.200
     1.778     9.374     0.200
     1.822     9.549     0.200
     1.872     9.373     0.200
     1.995     9.932     0.200
     2.090    10.232     0.200
     2.252    10.536     0.200
     2.317    10.382     0.200
     2.717    11.414     0.200
     3.030    11.658     0.200
     3.284    12.095     0.200
     3.346    12.672     0.200
     3.755    13.801     0.200
     4.319    15.013     0.200
     5.235    17.628     0.200
     5.654    19.036     0.200
     6.295    18.650     0.200
     6.511    18.734     0.200
     7.669    22.320     0.200
     2.251    11.342     0.200
     2.242    11.440     0.200
     2.580    12.196     0.200
     2.636    11.742     0.200
     2.890    12.577     0.200
     3.058    13.121     0.200
     3.362    13.468     0.200
     3.426    14.329     0.200
     3.737    14.495     0.200
     3.936    15.771     0.200
     4.325    14.929     0.200
     4.336    16.904     0.200
     4.854    18.358     0.200
     5.268    17.432     0.200
     5.302    19.639     0.200
     5.527    17.807     0.200
     6.688    21.262     0.200
     6.885    20.656     0.200
     2.248    11.267     0.200
     2.581    12.479     0.200
     2.641    11.985     0.200
     2.895    12.620     0.200
     3.057    13.325     0.200
     3.367    13.609     0.200
     3.733    14.833     0.200
     3.942    14.205     0.200
     4.320    14.991     0.200
     4.860    17.888     0.200
     5.264    17.967     0.200
     5.308    18.961     0.200
     5.526    17.718     0.200
     6.684    20.797     0.200
     6.880    20.616     0.200
     2.059    12.520     0.200
     2.295    12.763     0.200
     2.692    12.479     0.200
     1.874     9.273     0.200
     2.201    10.454     0.200
     2.290    10.814     0.200
     2.591    10.405     0.200
     2.664    11.048     0.200
     3.380    12.200     0.200
     4.227    12.812     0.200
     4.514    13.667     0.200
     4.703    15.456     0.200
     4.903    14.124     0.200
     5.137    16.393     0.200
     5.523    16.392     0.200
     5.523    18.494     0.200
     2.078    11.444     0.200
     2.393    11.071     0.200
     2.470    11.471     0.200
     2.470    11.870     0.200
     2.581    12.876     0.200
     2.721    12.639     0.200
     3.168    13.423     0.200
     3.168    13.021     0.200
     3.190    12.772     0.200
     3.190    12.874     0.200
     3.503    12.519     0.200
     3.755    14.878     0.200
     3.755    16.081     0.200
     3.894    15.659     0.200
     4.424    14.267     0.200
     4.424    14.564     0.200
     4.672    19.079     0.200
     4.672    18.379     0.200
     5.115    19.303     0.200
     5.420    17.744     0.200
     5.548    18.753     0.200
     5.642    17.959     0.200
     6.847    21.095     0.200
     7.069    20.298     0.200
     2.534    11.928     0.200
     2.595    11.412     0.200
     3.100    12.507     0.200
     3.306    12.700     0.200
     3.378    12.859     0.200
     3.790    13.955     0.200
     3.879    14.610     0.200
     4.284    15.890     0.200
     4.344    13.790     0.200
     4.797    18.099     0.200
     5.246    18.661     0.200
     5.570    17.678     0.200
     5.577    18.018     0.200
     6.741    21.915     0.200
     6.942    20.369     0.200
     2.141     9.832     0.200
     2.349    10.111     0.200
     2.488    11.089     0.200
     2.742    11.217     0.200
     2.860    11.847     0.200
     2.860    10.448     0.200
     2.952    11.764     0.200
     2.996    11.761     0.200
     3.289    11.836     0.200
     3.289    11.437     0.200
     3.466    12.373     0.200
     3.628    12.976     0.200
     3.987    14.293     0.200
     4.033    13.751     0.200
     4.033    13.649     0.200
     4.345    13.314     0.200
     4.445    15.547     0.200
     4.950    16.751     0.200
     4.950    16.450     0.200
     5.159    15.717     0.200
     5.420    15.963     0.200
     5.385    17.981     0.200
     5.583    17.287     0.200
     5.583    17.567     0.200
     5.702    17.941     0.200
     6.482    19.180     0.200
     6.580    19.134     0.200
     6.580    19.333     0.200
     6.792    18.658     0.200
     7.430    20.908     0.200
     8.083    19.908     0.200
     9.960    24.886     0.200
    10.666    30.447     0.200
    11.098    28.906     0.200
    12.041    27.904     0.200
    13.671    35.282     0.200
    14.110    31.634     0.200
    14.110    33.087     0.200
    14.110    35.454     0.200
    14.167    30.665     0.200
    14.167    31.417     0.200
    14.298    33.872     0.200
    15.030    34.275     0.200
    15.030    33.724     0.200
    15.190    36.946     0.200
    17.852    37.287     0.200
    17.852    36.907     0.200
    18.059    36.079     0.200
    18.059    37.646     0.200
    18.237    37.868     0.200
    18.766    39.718     0.200
    19.690    39.440     0.200
     1.924     9.977     0.200
     2.319    10.961     0.200
     2.574    11.092     0.200
     2.574    11.193     0.200
     2.575    11.569     0.200
     2.852    12.237     0.200
     3.051    12.516     0.200
     3.367    13.026     0.200
     3.367    12.727     0.200
     3.643    13.913     0.200
     3.643    14.612     0.200
     4.060    15.140     0.200
     4.012    15.400     0.200
     4.012    14.600     0.200
     4.303    13.605     0.200
     4.564    17.564     0.200
     4.564    17.764     0.200
     5.048    17.418     0.200
     5.048    18.618     0.200
     5.241    18.561     0.200
     5.340    17.886     0.200
     5.592    18.071     0.200
     5.839    18.479     0.200
     7.011    20.712     0.200
     7.174    20.306     0.200
     7.174    19.006     0.200
     8.251    20.830     0.200
     8.595    23.418     0.200
    12.324    29.608     0.200
    13.864    33.370     0.200
    17.693    38.746     0.200
    17.693    37.845     0.200
     1.930    10.102     0.200
     2.326    10.789     0.200
     2.565    11.297     0.200
     2.582    11.500     0.200
     3.057    12.451     0.200
     3.647    13.864     0.200
     4.020    14.911     0.200
     4.310    15.032     0.200
     4.568    16.618     0.200
     5.050    18.395     0.200
     7.169    20.063     0.200
     1.749    10.012     0.200
     1.870    10.099     0.200
     2.269    11.843     0.200
     2.618    11.575     0.200
     3.010    12.587     0.200
     3.116    11.957     0.200
     2.039    10.732     0.200
     2.103     9.986     0.200
     3.504    12.835     0.200
     3.590    13.034     0.200
     4.070    13.933     0.200
     4.348    13.180     0.200
     4.986    17.037     0.200
     5.120    17.076     0.200
     5.417    18.009     0.200
     6.757    18.771     0.200
     1.912    11.285     0.200
     2.240    11.652     0.200
     2.557    12.756     0.200
     2.641    12.371     0.200
     2.895    13.108     0.200
     3.043    13.483     0.200
     3.366    14.918     0.200
     3.729    14.872     0.200
     4.086    15.611     0.200
     4.347    15.054     0.200
     4.345    16.688     0.200
     4.854    19.055     0.200
     5.259    17.416     0.200
     5.296    19.789     0.200
     6.887    20.621     0.200
     2.036    11.159     0.200
     2.428    11.884     0.200
     2.426    12.104     0.200
     2.644    13.368     0.200
     2.675    12.691     0.200
     3.699    16.347     0.200
     3.935    15.596     0.200
     4.149    15.899     0.200
     4.479    14.852     0.200
     4.615    18.157     0.200
     5.052    19.856     0.200
     5.459    17.514     0.200
     5.663    20.225     0.200
     6.889    20.921     0.200
     7.128    21.434     0.200
     1.809    10.098     0.200
     1.830    10.147     0.200
     2.234    10.135     0.200
     2.273    10.783     0.200
     2.602    11.737     0.200
     2.831    12.270     0.200
     2.914    12.593     0.200
     3.265    12.305     0.200
     3.738    14.577     0.200
     3.812    14.022     0.200
     4.370    15.707     0.200
     4.962    17.796     0.200
     4.940    14.858     0.200
     5.305    17.290     0.200
     5.380    16.719     0.200
     7.182    20.192     0.200
     1.808     9.570     0.200
     1.975     9.723     0.200
     1.905     9.542     0.200
     1.943     9.697     0.200
     1.968    10.204     0.200
     2.265    11.038     0.200
     2.202    10.480     0.200
     2.487    10.746     0.200
     2.755    11.729     0.200
     2.876    11.808     0.200
     3.124    12.217     0.200
     3.363    11.634     0.200
     3.483    12.924     0.200
     3.483    12.822     0.200
     3.585    13.036     0.200
     3.820    14.396     0.200
     4.123    14.052     0.200
     4.520    13.530     0.200
     4.520    13.428     0.200
     4.601    16.074     0.200
     4.601    15.676     0.200
     5.006    15.954     0.200
     5.034    17.924     0.200
     5.034    17.627     0.200
     5.226    16.384     0.200
     5.425    17.561     0.200
     5.802    17.691     0.200
     5.802    18.062     0.200
     5.802    18.273     0.200
     5.919    18.215     0.200
     5.919    18.344     0.200
     6.438    19.647     0.200
     6.727    18.867     0.200
     7.298    21.507     0.200
     8.057    20.950     0.200
     8.167    19.449     0.200
     8.167    19.562     0.200
     8.167    19.672     0.200
    11.048    28.547     0.200
    12.055    28.397     0.200
    12.881    32.348     0.200
    13.006    33.293     0.200
    14.082    33.704     0.200
    14.082    33.333     0.200
    14.082    34.368     0.200
    14.082    34.735     0.200
    14.473    34.471     0.200
    14.493    33.985     0.200
    14.493    34.356     0.200
    15.040    32.955     0.200
    15.040    34.858     0.200
    15.394    35.921     0.200
    16.862    36.397     0.200
    17.158    37.841     0.200
    17.918    36.816     0.200
    17.804    38.702     0.200
    18.117    37.473     0.200
    18.117    37.825     0.200
    18.117    38.168     0.200
    18.293    38.201     0.200
    19.880    41.377     0.200
    20.901    41.661     0.200
     1.823     9.679     0.200
     1.921     9.737     0.200
     1.959     9.591     0.200
     1.984     9.999     0.200
     2.217    10.681     0.200
     2.251    10.884     0.200
     2.503    10.638     0.200
     2.739    11.991     0.200
     2.892    11.599     0.200
     3.140    12.111     0.200
     3.357    11.569     0.200
     3.467    13.590     0.200
     3.601    12.933     0.200
     3.804    13.862     0.200
     4.138    15.365     0.200
     4.523    13.369     0.200
     4.618    15.964     0.200
     5.049    17.935     0.200
     5.210    16.850     0.200
     5.438    18.390     0.200
     6.714    18.602     0.200
     2.265    11.147     0.200
     2.481    10.824     0.200
     2.758    11.794     0.200
     2.869    11.890     0.200
     3.117    12.505     0.200
     3.490    13.441     0.200
     3.577    12.227     0.200
     4.115    15.154     0.200
     4.528    13.437     0.200
     5.415    18.576     0.200
     1.903    11.182     0.200
     2.251    11.616     0.200
     2.110    11.268     0.200
     2.234    11.323     0.200
     2.627    12.231     0.200
     2.880    12.480     0.200
     2.880    12.980     0.200
     3.052    13.482     0.200
     3.351    13.989     0.200
     3.351    13.489     0.200
     3.742    14.820     0.200
     3.920    15.741     0.200
     4.332    16.740     0.200
     4.356    14.754     0.200
     4.356    14.953     0.200
     4.838    18.535     0.200
     4.838    19.234     0.200
     5.272    17.369     0.200
     5.280    19.377     0.200
     5.522    17.951     0.200
     5.622    19.586     0.200
     6.694    20.475     0.200
     6.903    20.537     0.200
     6.903    20.435     0.200
    14.024    35.929     0.200
    14.277    32.883     0.200
    20.817    41.158     0.200
     2.190    10.340     0.200
     2.677    12.454     0.200
     2.980    11.812     0.200
     2.928    12.022     0.200
     3.396    13.666     0.200
     3.687    14.265     0.200
     3.955    13.839     0.200
     4.412    14.400     0.200
     5.297    20.173     0.200
     5.587    18.198     0.200
     1.587     8.468     0.200
     2.267    10.027     0.200
     2.585    11.323     0.200
     2.961    12.629     0.200
     3.748    12.750     0.200
     4.071    13.176     0.200
     6.003    17.937     0.200
     6.175    19.621     0.200
     2.316    10.362     0.200
     2.863    11.482     0.200
     4.195    13.532     0.200
     2.052    11.401     0.200
     2.217    11.576     0.200
     2.241    11.891     0.200
     2.375    12.523     0.200
     2.375    11.327     0.200
     2.625    12.614     0.200
     2.625    12.817     0.200
     2.867    13.790     0.200
     2.867    13.493     0.200
     2.941    13.021     0.200
     2.941    13.224     0.200
     3.320    14.402     0.200
     3.320    14.199     0.200
     3.740    14.795     0.200
     3.740    14.896     0.200
     3.842    17.510     0.200
     3.842    15.112     0.200
     4.368    16.568     0.200
     4.368    16.763     0.200
     4.659    15.171     0.200
     4.750    19.118     0.200
     5.132    19.652     0.200
     5.132    19.949     0.200
     5.254    17.830     0.200
     5.415    17.647     0.200
     5.727    19.212     0.200
     5.823    19.518     0.200
     7.019    20.638     0.200
     7.019    20.740     0.200
     8.257    21.339     0.200
    13.802    35.457     0.200
    17.826    39.185     0.200
    18.288    39.423     0.200
    18.374    38.372     0.200
     2.194    11.410     0.200
     2.914    12.502     0.200
     2.923    12.001     0.200
     3.459    13.342     0.200
     3.511    14.336     0.200
     4.178    15.152     0.200
     4.368    16.036     0.200
     4.917    17.425     0.200
     1.750    10.050     0.200
     1.830    10.615     0.200
     2.209    11.494     0.200
     2.263    10.767     0.200
     2.263    11.361     0.200
     2.448    12.013     0.200
     2.635    11.629     0.200
     2.704    12.526     0.200
     2.704    12.221     0.200
     2.898    12.451     0.200
     2.898    12.553     0.200
     3.327    13.048     0.200
     3.421    13.850     0.200
     3.896    13.311     0.200
     3.964    15.019     0.200
     4.162    14.907     0.200
     4.162    15.009     0.200
     4.331    17.534     0.200
     4.467    15.450     0.200
     4.735    14.521     0.200
     4.738    17.882     0.200
     4.738    16.781     0.200
     5.490    17.909     0.200
     5.559    18.461     0.200
     5.673    17.673     0.200
     6.719    19.773     0.200
     7.115    21.236     0.200
     7.425    20.822     0.200
     7.988    24.048     0.200
     8.520    20.682     0.200
     1.145    12.026     0.200
     2.002    11.916     0.200
     2.127    12.268     0.200
     2.191    12.315     0.200
     2.267    11.833     0.200
     2.424    12.895     0.200
     2.575    13.337     0.200
     2.575    13.439     0.200
     2.640    11.680     0.200
     2.640    12.579     0.200
     2.817    13.909     0.200
     2.992    14.761     0.200
     2.992    13.363     0.200
     3.272    14.720     0.200
     3.630    13.719     0.200
     3.630    15.118     0.200
     3.789    15.565     0.200
     4.317    17.400     0.200
     4.646    16.168     0.200
     5.096    18.218     0.200
     5.096    20.218     0.200
     5.304    17.785     0.200
     5.467    18.087     0.200
     5.683    19.364     0.200
     5.777    20.071     0.200
     6.743    21.590     0.200
     7.058    21.116     0.200
     7.140    23.160     0.200
     8.269    24.359     0.200
    13.779    36.715     0.200
    17.786    40.440     0.200
    18.345    40.853     0.200
     1.887    10.260     0.200
     2.282    11.551     0.200
     2.537    11.767     0.200
     2.601    11.625     0.200
     3.012    13.434     0.200
     3.385    13.671     0.200
     3.599    15.077     0.200
     4.092    15.522     0.200
     4.520    16.036     0.200
     5.000    18.329     0.200
     2.005    12.019     0.200
     2.192    11.434     0.200
     2.266    11.677     0.200
     2.576    13.364     0.200
     2.640    13.411     0.200
     2.818    13.832     0.200
     2.990    14.923     0.200
     2.990    13.719     0.200
     3.272    14.724     0.200
     3.272    14.326     0.200
     3.788    15.305     0.200
     3.788    15.406     0.200
     4.319    17.317     0.200
     4.319    16.614     0.200
     4.650    15.755     0.200
     4.706    19.903     0.200
     4.706    19.505     0.200
     5.095    20.367     0.200
     5.303    18.731     0.200
     5.465    19.049     0.200
     5.686    19.460     0.200
     5.686    19.859     0.200
     5.780    20.204     0.200
     6.743    21.330     0.200
     7.059    21.045     0.200
     7.059    20.842     0.200
     7.140    23.397     0.200
     8.268    26.436     0.200
     8.272    23.005     0.200
     8.429    23.959     0.200
    13.776    34.573     0.200
    17.786    38.862     0.200
    18.343    39.205     0.200
    18.503    41.288     0.200
     2.018    11.446     0.200
     2.199    11.731     0.200
     2.259    11.134     0.200
     2.408    12.391     0.200
     2.582    12.762     0.200
     2.644    11.943     0.200
     2.824    13.440     0.200
     2.980    12.818     0.200
     3.278    13.546     0.200
     4.327    16.203     0.200
     4.708    16.854     0.200
     1.822    10.570     0.200
     2.020    11.066     0.200
     2.125    10.630     0.200
     2.362    10.870     0.200
     2.465    11.868     0.200
     2.465    11.766     0.200
     2.755    11.780     0.200
     2.755    11.882     0.200
     2.870    12.439     0.200
     2.935    12.586     0.200
     3.008    12.533     0.200
     3.292    12.121     0.200
     3.292    12.921     0.200
     3.308    13.734     0.200
     3.478    13.265     0.200
     3.478    13.148     0.200
     3.478    13.449     0.200
     3.614    13.659     0.200
     3.971    14.692     0.200
     4.043    15.653     0.200
     4.043    15.250     0.200
     4.357    14.288     0.200
     4.960    18.958     0.200
     4.960    18.556     0.200
     5.144    16.306     0.200
     5.403    16.583     0.200
     5.403    16.880     0.200
     5.391    18.927     0.200
     5.391    19.126     0.200
     5.601    19.068     0.200
     5.601    18.068     0.200
     5.720    19.161     0.200
     6.784    19.371     0.200
     6.784    19.570     0.200
     7.393    24.953     0.200
     7.393    21.356     0.200
     7.930    20.561     0.200
     8.087    20.497     0.200
     8.606    24.998     0.200
    14.151    31.998     0.200
    14.111    36.071     0.200
    14.111    34.024     0.200
    14.313    33.508     0.200
    18.067    39.497     0.200
    18.067    38.946     0.200
    18.578    42.331     0.200
    18.751    40.604     0.200
     2.039    11.513     0.200
     2.233    11.555     0.200
     2.233    11.453     0.200
     2.226    11.739     0.200
     2.388    12.247     0.200
     2.609    12.565     0.200
     2.956    13.217     0.200
     2.851    13.542     0.200
     3.304    14.042     0.200
     3.626    14.394     0.200
     3.626    13.292     0.200
     3.756    14.671     0.200
     4.353    17.011     0.200
     4.734    18.165     0.200
     5.118    19.687     0.200
     5.270    17.906     0.200
     5.430    18.344     0.200
     5.812    19.218     0.200
     7.034    19.824     0.200
     8.266    22.329     0.200
     2.664    12.015     0.200
     5.075    18.775     0.200
     2.071    10.803     0.200
     2.779    11.845     0.200
     2.787    12.168     0.200
     2.787    12.355     0.200
     3.354    14.823     0.200
     4.289    15.614     0.200
     4.273    17.705     0.200
     4.530    14.107     0.200
     4.740    18.960     0.200
     5.309    17.793     0.200
     8.407    22.496     0.200
    17.394    39.493     0.200
     1.598    10.330     0.200
     1.727    11.527     0.200
     1.820    10.538     0.200
     2.211    11.578     0.200
     2.461    12.358     0.200
     2.644    11.918     0.200
     2.829    13.065     0.200
     2.929    13.065     0.200
     3.396    13.740     0.200
     3.497    13.569     0.200
     3.933    14.880     0.200
     4.151    15.036     0.200
     5.385    18.835     0.200
     8.303    22.857     0.200
    13.672    31.947     0.200
    17.533    40.082     0.200
    18.770    40.030     0.200
     1.734     9.823     0.200
     2.070    10.299     0.200
     2.118    10.641     0.200
     2.391    10.964     0.200
     2.779    12.126     0.200
     2.841    11.906     0.200
     3.027    12.740     0.200
     3.580    13.282     0.200
     5.336    17.286     0.200
     1.859    10.193     0.200
     2.093    11.356     0.200
     2.237    10.677     0.200
     2.275    10.627     0.200
     2.631    11.977     0.200
     2.632    11.365     0.200
     2.769    11.267     0.200
     2.889    12.274     0.200
     3.097    12.533     0.200
     3.281    11.794     0.200
     3.364    12.573     0.200
     4.255    13.827     0.200
     4.321    15.458     0.200
     4.868    17.872     0.200
     5.329    18.489     0.200
     5.436    18.945     0.200
     5.554    18.225     0.200
     7.912    20.078     0.200
    14.096    33.418     0.200
     1.778    10.542     0.200
     1.913    10.363     0.200
     2.209    11.506     0.200
     2.999    12.693     0.200
     4.283    14.510     0.200
     4.916    17.119     0.200
     2.063    10.092     0.200
     2.297    10.665     0.200
     2.341    10.843     0.200
     4.310    13.368     0.200
     4.337    14.258     0.200
     2.255    11.224     0.200
     2.512    11.831     0.200
     2.897    12.636     0.200
     2.988    13.473     0.200
     3.425    14.680     0.200
     4.503    17.793     0.200
     4.992    19.084     0.200
     2.218    10.974     0.200
     2.469    11.750     0.200
     2.636    11.798     0.200
     4.038    17.241     0.200
     4.143    14.514     0.200
     4.480    15.278     0.200
     4.881    18.994     0.200
     1.913     9.837     0.200
     2.272    10.947     0.200
     2.570    11.464     0.200
     2.666    11.642     0.200
     2.921    12.269     0.200
     3.042    12.360     0.200
     3.394    12.634     0.200
     3.394    11.681     0.200
     3.394    13.752     0.200
     3.710    13.865     0.200
     3.970    15.228     0.200
     4.302    13.950     0.200
     4.889    16.111     0.200
     5.242    17.190     0.200
     5.338    18.070     0.200
     5.497    16.881     0.200
     5.497    18.412     0.200
     5.510    16.962     0.200
     6.660    20.136     0.200
     6.851    19.614     0.200
     7.932    19.456     0.200
    18.005    40.120     0.200
    18.005    37.935     0.200
    18.540    41.896     0.200
    18.625    40.950     0.200
     1.752     9.885     0.200
     1.760     9.707     0.200
     1.757     9.634     0.200
     2.122    10.772     0.200
     2.150    10.652     0.200
     2.354    11.363     0.200
     2.740    11.170     0.200
     2.735    11.421     0.200
     2.795    12.122     0.200
     3.298    12.753     0.200
     3.396    12.913     0.200
     3.889    15.059     0.200
     3.889    14.363     0.200
     4.268    15.330     0.200
     4.204    16.475     0.200
     4.558    15.545     0.200
     4.595    15.913     0.200
     4.595    17.616     0.200
     4.859    14.127     0.200
     5.517    17.857     0.200
     5.517    17.756     0.200
     5.574    18.088     0.200
     6.638    18.177     0.200
     8.818    22.236     0.200
    12.884    30.077     0.200
    14.709    35.084     0.200
     1.951    10.026     0.200
     2.191    10.229     0.200
     2.698    11.418     0.200
     2.952    11.954     0.200
     3.003    12.247     0.200
     3.423    13.653     0.200
     3.676    13.305     0.200
     4.323    15.048     0.200
     5.207    16.735     0.200
     5.355    18.003     0.200
     2.280    10.915     0.200
     2.536    11.327     0.200
     2.610    11.358     0.200
     4.314    13.873     0.200
     5.011    18.840     0.200
     2.171    10.272     0.200
     2.307    10.473     0.200
     2.563    10.785     0.200
     3.096    12.268     0.200
     3.285    12.665     0.200
     3.852    14.248     0.200
     4.769    16.545     0.200
     5.210    17.495     0.200
     2.266    10.442     0.200
     3.637    13.240     0.200
     4.127    14.116     0.200
     4.231    15.510     0.200
     6.162    19.179     0.200
    13.516    31.648     0.200
    14.450    34.553     0.200
    18.842    39.299     0.200
     0.965     8.035     0.200
     1.801     9.485     0.200
     2.196    10.780     0.200
     2.451    11.199     0.200
     2.684    11.874     0.200
     2.920    12.626     0.200
     2.926    12.261     0.200
     3.516    14.376     0.200
     4.437    17.225     0.200
     4.924    18.339     0.200
     1.991     9.977     0.200
     2.092    10.295     0.200
     2.333    10.277     0.200
     2.263    10.699     0.200
     2.309    10.265     0.200
     2.497    10.864     0.200
     2.608    10.778     0.200
     2.721    11.662     0.200
     2.793     9.316     0.200
     2.836    11.110     0.200
     3.010    12.380     0.200
     3.163    11.398     0.200
     3.163    12.000     0.200
     3.235    13.856     0.200
     3.558    12.888     0.200
     3.678    13.489     0.200
     3.813    13.607     0.200
     4.289    13.661     0.200
     4.286    14.316     0.200
     4.286    13.957     0.200
     4.286    14.097     0.200
     4.374    14.269     0.200
     4.753    14.247     0.200
     4.849    15.328     0.200
     5.242    17.245     0.200
     5.242    16.940     0.200
     5.779    17.271     0.200
     5.763    18.352     0.200
     5.763    18.454     0.200
     5.990    16.909     0.200
     6.146    16.360     0.200
     6.099    16.789     0.200
     6.099    18.039     0.200
     6.099    17.938     0.200
     6.163    19.191     0.200
     6.262    17.715     0.200
     7.416    18.992     0.200
     7.592    19.061     0.200
    14.453    34.442     0.200
    14.774    35.099     0.200
    18.855    39.674     0.200
    18.855    39.252     0.200
    18.855    39.994     0.200
    18.855    40.572     0.200
     1.993    10.612     0.200
     2.190    10.315     0.200
     2.276    10.605     0.200
     2.916    12.139     0.200
     3.694    13.460     0.200
     4.468    14.033     0.200
     4.846    19.316     0.200
     5.263    18.251     0.200
     2.269    11.362     0.200
     2.516    12.081     0.200
     2.576    11.682     0.200
     2.979    12.885     0.200
     3.313    12.681     0.200
     4.090    14.910     0.200
     4.557    14.665     0.200
     1.288     9.065     0.200
     1.287     8.975     0.200
     1.600    10.918     0.200
     1.718    10.845     0.200
     1.718    12.243     0.200
     1.804    10.245     0.200
     2.193    11.195     0.200
     2.443    11.687     0.200
     2.443    11.585     0.200
     2.657    11.485     0.200
     2.828    12.895     0.200
     2.828    12.395     0.200
     2.909    12.240     0.200
     2.909    12.646     0.200
     3.403    12.684     0.200
     3.403    13.286     0.200
     3.721    14.067     0.200
     3.920    15.453     0.200
     4.167    15.166     0.200
     4.391    17.555     0.200
     4.510    14.161     0.200
     4.846    17.337     0.200
     5.311    19.310     0.200
     5.311    18.013     0.200
     5.392    17.814     0.200
     7.020    19.365     0.200
     8.334    24.340     0.200
    13.641    34.755     0.200
    17.507    39.611     0.200
    18.066    40.559     0.200
    18.151    39.561     0.200
     1.815    10.568     0.200
     1.857    10.687     0.200
     2.217    10.983     0.200
     2.261    11.162     0.200
     2.261    11.363     0.200
     2.173    11.491     0.200
     2.270    11.959     0.200
     2.643    12.509     0.200
     2.643    12.808     0.200
     2.881    13.134     0.200
     2.881    12.532     0.200
     2.876    12.696     0.200
     2.876    13.094     0.200
     3.315    12.461     0.200
     3.315    12.768     0.200
     3.315    13.569     0.200
     3.753    14.250     0.200
     3.797    12.745     0.200
     3.797    13.345     0.200
     3.801    15.300     0.200
     3.801    15.402     0.200
     4.340    15.810     0.200
     4.406    16.739     0.200
     4.406    17.139     0.200
     4.699    17.915     0.200
     4.699    18.415     0.200
     4.869    15.229     0.200
     5.253    17.156     0.200
     5.038    18.754     0.200
     5.350    16.513     0.200
     5.350    17.213     0.200
     5.882    18.609     0.200
     5.882    19.609     0.200
     5.967    19.701     0.200
     6.451    18.119     0.200
     7.105    20.334     0.200
     8.439    20.891     0.200
    13.650    34.055     0.200
    17.742    38.905     0.200
    17.742    38.879     0.200
    18.158    40.654     0.200
    18.244    37.818     0.200
     1.798    10.174     0.200
     2.186    10.240     0.200
     2.434    11.745     0.200
     2.661    12.001     0.200
     2.816    11.993     0.200
     2.898    12.772     0.200
     2.898    12.630     0.200
     3.399    13.592     0.200
     3.457    13.811     0.200
     3.917    15.238     0.200
     4.173    14.949     0.200
     4.374    18.012     0.200
     4.543    14.531     0.200
     4.823    18.564     0.200
     5.411    18.172     0.200
     7.008    18.166     0.200
     8.365    20.601     0.200
    13.612    34.794     0.200
     2.079    10.117     0.200
     2.106    10.707     0.200
     2.383    11.273     0.200
     4.510    13.554     0.200
     4.936    16.382     0.200
     5.336    18.507     0.200
     1.734     9.961     0.200
     1.818     9.976     0.200
     1.856    10.334     0.200
     1.879    10.568     0.200
     2.065     9.994     0.200
     2.120    10.854     0.200
     2.335    11.449     0.200
     2.335    11.644     0.200
     2.300    11.247     0.200
     2.397    11.222     0.200
     2.839    11.966     0.200
     2.839    12.068     0.200
     2.786    12.276     0.200
     3.034    12.589     0.200
     3.406    13.748     0.200
     3.574    13.389     0.200
     3.495    13.583     0.200
     3.495    13.357     0.200
     4.036    14.685     0.200
     4.514    14.212     0.200
     4.512    16.444     0.200
     4.573    15.920     0.200
     4.948    17.648     0.200
     4.948    18.351     0.200
     5.096    15.815     0.200
     5.311    17.806     0.200
     5.347    18.495     0.200
     5.347    18.800     0.200
     5.736    17.863     0.200
     5.736    18.824     0.200
     5.736    19.348     0.200
     5.736    18.449     0.200
     5.848    18.884     0.200
     5.848    18.540     0.200
     6.809    19.424     0.200
     8.207    20.884     0.200
    14.086    32.707     0.200
    14.022    34.962     0.200
    14.022    36.063     0.200
    14.473    33.714     0.200
    15.105    35.708     0.200
    15.105    37.817     0.200
    16.773    40.460     0.200
    18.036    39.617     0.200
    18.036    38.188     0.200
    18.036    39.516     0.200
    18.212    39.983     0.200
    18.591    40.328     0.200
     2.401    11.937     0.200
     2.451    12.158     0.200
     2.700    12.752     0.200
     3.720    15.048     0.200
     3.909    15.441     0.200
     2.602    12.736     0.200
     2.502    11.906     0.200
     2.608    13.670     0.200
     2.752    12.388     0.200
     3.130    12.978     0.200
     3.219    13.501     0.200
     3.860    14.652     0.200
     5.586    18.613     0.200
     6.794    18.811     0.200
     8.132    20.038     0.200
    13.879    34.356     0.200
     1.998     9.675     0.200
     2.502    10.793     0.200
     2.649    11.471     0.200
     2.793    12.093     0.200
     3.125    12.065     0.200
     3.301    12.863     0.200
     3.447    12.760     0.200
     3.677    13.382     0.200
     3.987    13.961     0.200
     5.392    16.838     0.200
     6.984    19.274     0.200
     8.063    19.576     0.200
     1.820     9.759     0.200
     2.211     9.693     0.200
     2.211    10.693     0.200
     2.462    10.968     0.200
     2.645    11.623     0.200
     2.930    12.572     0.200
     3.399    13.423     0.200
     3.399    12.821     0.200
     3.499    13.156     0.200
     3.683    13.509     0.200
     4.151    13.950     0.200
     4.473    14.298     0.200
     5.379    17.842     0.200
     7.027    20.061     0.200
     1.669     8.512     0.200
     2.037     9.725     0.200
     2.218     9.900     0.200
     2.510    11.397     0.200
     3.036    11.655     0.200
     1.713     9.319     0.200
     2.045    10.441     0.200
     2.263    10.107     0.200
     2.382    10.818     0.200
     2.580    10.997     0.200
     2.820    11.404     0.200
     2.968    11.772     0.200
     3.791    13.175     0.200
     6.575    17.911     0.200
    17.758    37.874     0.200
     2.205    11.222     0.200
     2.457    11.980     0.200
     2.654    11.977     0.200
     2.851    13.283     0.200
     2.926    13.003     0.200
     3.413    13.923     0.200
     3.499    15.219     0.200
     3.922    15.976     0.200
     5.360    19.421     0.200
     7.045    19.665     0.200
     8.282    23.625     0.200
     2.247    10.381     0.200
     2.620    11.337     0.200
     2.871    11.308     0.200
     2.199    11.911     0.200
     2.452    12.366     0.200
     2.662    12.213     0.200
     2.863    13.371     0.200
     2.922    13.182     0.200
     3.497    14.864     0.200
     4.165    15.976     0.200
     4.442    15.642     0.200
     5.347    18.856     0.200
     7.056    19.506     0.200
     1.337     9.484     0.200
     1.925    10.624     0.200
     2.258    10.336     0.200
     2.602    11.621     0.200
     2.852    11.501     0.200
     3.760    14.303     0.200
     1.894    11.262     0.200
     2.289    11.545     0.200
     2.545    12.252     0.200
     2.602    11.888     0.200
     2.871    12.955     0.200
     3.021    13.096     0.200
     3.394    14.052     0.200
     3.614    15.186     0.200
     4.309    14.674     0.200
     5.320    18.617     0.200
     7.063    21.425     0.200
    17.665    40.752     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.552    15.839     0.200
     3.014    18.346     0.200
     3.014    22.246     0.200
     3.661    23.298     0.200
     4.742    28.881     0.200
     4.862    30.890     0.200
     5.041    33.495     0.200
     3.515    22.598     0.200
     3.520    24.643     0.200
     2.095    12.719     0.200
     2.728    17.226     0.200
     2.752    16.854     0.200
     3.227    20.004     0.200
     3.876    24.435     0.200
     3.097    18.540     0.200
     3.142    19.313     0.200
     3.918    23.365     0.200
     4.201    27.460     0.200
     4.570    27.455     0.200
     4.702    28.607     0.200
     2.657    17.272     0.200
     5.073    31.469     0.200
     2.642    16.192     0.200
     2.976    19.390     0.200
     3.254    20.754     0.200
     4.084    26.960     0.200
     4.723    28.702     0.200
     2.723    17.375     0.200
     2.894    17.775     0.200
     3.954    26.504     0.200
     4.166    25.326     0.200
     4.332    25.694     0.200
     4.713    29.349     0.200
     2.299    15.335     0.200
     2.675    17.246     0.200
     2.934    18.318     0.200
     3.456    22.633     0.200
     3.876    25.232     0.200
     4.126    25.607     0.200
     4.365    26.518     0.200
     4.733    28.827     0.200
     4.769    28.307     0.200
     5.763    35.503     0.200
     2.639    16.496     0.200
     2.895    17.810     0.200
     3.333    20.199     0.200
     3.419    21.694     0.200
     3.893    23.656     0.200
     3.959    24.894     0.200
     4.166    25.977     0.200
     4.329    27.270     0.200
     2.266    14.328     0.200
     2.299    15.143     0.200
     2.476    15.286     0.200
     2.487    16.758     0.200
     2.808    19.211     0.200
     2.808    20.012     0.200
     3.391    22.402     0.200
     3.670    24.142     0.200
     3.670    24.040     0.200
     4.117    26.936     0.200
     4.450    28.042     0.200
     4.848    30.403     0.200
     5.186    33.151     0.200
     5.975    36.254     0.200
     5.975    37.453     0.200
     3.286    20.921     0.200
     3.519    21.499     0.200
     3.767    24.799     0.200
     4.019    26.562     0.200
     4.084    25.800     0.200
     4.624    28.007     0.200
     5.759    34.555     0.200
     6.172    38.541     0.200
     2.570    16.522     0.200
     2.570    16.817     0.200
     2.570    17.017     0.200
     2.701    18.395     0.200
     3.309    21.898     0.200
     3.309    20.197     0.200
     3.309    21.398     0.200
     3.874    25.301     0.200
     3.874    25.601     0.200
     4.156    27.017     0.200
     4.298    27.853     0.200
     4.393    28.843     0.200
     4.393    28.244     0.200
     4.791    31.610     0.200
     4.791    30.802     0.200
     4.791    32.502     0.200
     5.229    34.488     0.200
     5.543    35.830     0.200
     2.778    18.087     0.200
     3.038    18.748     0.200
     3.381    20.649     0.200
     3.717    22.928     0.200
     3.953    24.369     0.200
     4.330    28.173     0.200
     2.304    15.136     0.200
     2.377    15.787     0.200
     2.537    16.013     0.200
     3.256    20.629     0.200
     3.765    24.887     0.200
     4.047    26.290     0.200
     4.637    28.203     0.200
     2.637    16.796     0.200
     2.637    16.897     0.200
     2.653    17.509     0.200
     3.138    19.849     0.200
     3.138    19.649     0.200
     3.257    21.371     0.200
     3.257    21.672     0.200
     3.418    21.987     0.200
     3.418    22.287     0.200
     3.508    24.434     0.200
     3.837    25.093     0.200
     4.191    28.167     0.200
     4.219    27.943     0.200
     4.237    29.025     0.200
     4.360    27.697     0.200
     4.360    27.299     0.200
     4.747    30.072     0.200
     4.747    32.275     0.200
     5.197    31.920     0.200
     5.367    35.247     0.200
     5.373    36.369     0.200
     5.610    34.808     0.200
     5.610    34.007     0.200
     6.789    45.243     0.200
     6.992    43.476     0.200
     3.063    19.834     0.200
     3.458    21.627     0.200
     4.018    23.993     0.200
     2.573    16.884     0.200
     2.737    17.569     0.200
     2.737    17.171     0.200
     2.726    18.801     0.200
     3.193    19.850     0.200
     3.262    21.443     0.200
     3.310    21.086     0.200
     3.557    22.795     0.200
     3.827    23.743     0.200
     3.908    25.610     0.200
     4.181    27.609     0.200
     4.248    26.939     0.200
     4.248    27.439     0.200
     5.310    34.140     0.200
     5.362    34.634     0.200
     6.909    43.377     0.200
     2.089    14.138     0.200
     2.717    18.009     0.200
     2.880    18.609     0.200
     3.421    20.995     0.200
     3.495    22.428     0.200
     3.643    22.301     0.200
     4.451    30.278     0.200
     4.576    27.921     0.200
     2.142    13.566     0.200
     2.368    15.422     0.200
     2.503    15.754     0.200
     2.644    17.005     0.200
     3.155    19.747     0.200
     3.225    21.519     0.200
     3.225    20.519     0.200
     3.454    22.857     0.200
     3.454    21.459     0.200
     3.795    24.070     0.200
     4.212    26.714     0.200
     4.384    27.995     0.200
     4.384    27.198     0.200
     4.713    29.759     0.200
     5.392    33.434     0.200
     5.627    34.795     0.200
     6.817    45.013     0.200
     7.027    42.862     0.200
     2.511    16.452     0.200
     2.718    17.641     0.200
     2.978    18.901     0.200
     3.296    20.694     0.200
     3.442    22.586     0.200
     3.654    22.518     0.200
     4.012    25.441     0.200
     4.337    27.550     0.200
     4.929    32.437     0.200
     2.218    14.162     0.200
     2.569    15.964     0.200
     2.574    17.115     0.200
     2.574    16.416     0.200
     2.683    16.633     0.200
     2.683    17.133     0.200
     3.436    22.854     0.200
     3.447    22.319     0.200
     3.447    21.819     0.200
     3.791    24.211     0.200
     3.856    24.549     0.200
     3.856    23.448     0.200
     4.138    25.660     0.200
     4.165    26.643     0.200
     4.287    26.828     0.200
     4.411    28.268     0.200
     4.411    27.968     0.200
     4.773    28.753     0.200
     5.209    34.765     0.200
     5.549    34.195     0.200
     5.549    34.597     0.200
     6.744    41.950     0.200
     2.302    14.556     0.200
     2.500    15.538     0.200
     2.997    18.345     0.200
     3.375    20.732     0.200
     3.934    24.905     0.200
     4.418    26.666     0.200
     5.277    32.331     0.200
     2.366    14.410     0.200
     3.102    19.231     0.200
     4.285    26.520     0.200
     2.294    14.541     0.200
     4.376    27.145     0.200
     2.313    14.573     0.200
     2.695    16.519     0.200
     3.274    21.253     0.200
     3.387    20.733     0.200
     3.423    20.823     0.200
     3.999    24.293     0.200
     4.292    26.372     0.200
     4.292    26.772     0.200
     4.918    29.575     0.200
     6.821    41.558     0.200
     3.059    18.321     0.200
     3.715    23.369     0.200
     3.124    20.705     0.200
     3.290    20.560     0.200
     4.158    26.229     0.200
     6.217    38.908     0.200
     2.241    14.212     0.200
     2.606    16.355     0.200
     2.723    17.389     0.200
     2.723    16.690     0.200
     3.329    20.919     0.200
     3.329    20.817     0.200
     3.384    22.080     0.200
     3.435    21.385     0.200
     3.762    23.867     0.200
     3.898    25.785     0.200
     3.898    23.485     0.200
     4.115    25.444     0.200
     4.313    28.038     0.200
     4.313    27.838     0.200
     4.368    26.789     0.200
     4.368    27.988     0.200
     4.815    30.178     0.200
     4.815    29.178     0.200
     5.291    32.523     0.200
     5.291    35.121     0.200
     5.536    34.061     0.200
     6.926    41.641     0.200
     2.313    15.147     0.200
     2.370    16.488     0.200
     2.622    15.842     0.200
     3.527    21.483     0.200
     3.527    21.583     0.200
     3.822    23.436     0.200
     4.056    25.212     0.200
     4.065    26.406     0.200
     4.437    26.368     0.200
     4.712    29.560     0.200
     2.099    13.639     0.200
     2.354    14.961     0.200
     2.754    17.388     0.200
     2.863    18.623     0.200
     3.434    22.750     0.200
     3.462    21.422     0.200
     4.002    24.926     0.200
     5.127    33.494     0.200
     6.844    41.556     0.200
     2.574    15.798     0.200
     3.399    21.271     0.200
     4.136    25.065     0.200
     4.136    26.260     0.200
     4.576    28.531     0.200
     4.724    30.105     0.200
     4.987    30.329     0.200
     5.058    30.610     0.200
     5.643    34.483     0.200
     5.969    37.181     0.200
     6.096    36.992     0.200
     2.034    13.173     0.200
     2.245    14.013     0.200
     2.245    14.115     0.200
     2.855    17.687     0.200
     2.959    18.281     0.200
     3.139    19.172     0.200
     3.139    20.473     0.200
     3.405    21.570     0.200
     3.538    23.915     0.200
     3.538    21.817     0.200
     4.002    24.604     0.200
     4.002    24.905     0.200
     4.677    28.623     0.200
     4.677    29.525     0.200
     4.942    30.136     0.200
     5.045    30.629     0.200
     5.499    34.734     0.200
     6.079    36.962     0.200
     6.242    37.865     0.200
     2.340    14.613     0.200
     2.443    15.219     0.200
     2.677    16.979     0.200
     2.869    17.841     0.200
     4.305    28.481     0.200
     4.408    28.476     0.200
     4.408    28.277     0.200
     4.840    29.245     0.200
     5.798    36.057     0.200
     5.935    36.358     0.200
     5.935    35.756     0.200
     2.314    14.700     0.200
     2.449    16.120     0.200
     2.832    17.857     0.200
     3.043    20.391     0.200
     3.043    18.990     0.200
     3.355    20.850     0.200
     3.526    22.952     0.200
     3.629    22.350     0.200
     3.629    22.751     0.200
     4.014    26.164     0.200
     4.060    26.923     0.200
     4.340    26.558     0.200
     5.590    34.268     0.200
     2.348    14.467     0.200
     4.024    23.909     0.200
     4.101    24.604     0.200
     2.121    14.162     0.200
     2.332    15.094     0.200
     2.840    17.568     0.200
     2.775    17.628     0.200
     3.212    21.225     0.200
     3.431    21.075     0.200
     3.483    21.966     0.200
     3.483    21.669     0.200
     3.917    24.401     0.200
     4.536    29.272     0.200
     4.536    28.077     0.200
     4.931    31.966     0.200
     4.931    32.263     0.200
     5.106    32.932     0.200
     5.106    33.432     0.200
     5.313    32.511     0.200
     5.327    34.151     0.200
     2.127    13.681     0.200
     2.392    15.190     0.200
     2.506    16.153     0.200
     2.831    18.561     0.200
     2.879    18.701     0.200
     2.993    19.365     0.200
     2.993    20.365     0.200
     3.196    20.307     0.200
     3.213    20.200     0.200
     3.602    23.465     0.200
     3.602    22.865     0.200
     3.853    26.230     0.200
     3.853    26.330     0.200
     4.166    25.786     0.200
     4.345    26.391     0.200
     4.345    26.491     0.200
     4.581    29.838     0.200
     4.581    30.238     0.200
     5.082    30.798     0.200
     5.082    31.498     0.200
     6.663    41.338     0.200
     2.500    15.799     0.200
     2.833    17.520     0.200
     2.871    17.974     0.200
     2.984    18.658     0.200
     3.198    20.459     0.200
     3.499    21.745     0.200
     3.593    22.348     0.200
     4.155    26.586     0.200
     4.356    26.742     0.200
     4.575    30.393     0.200
     5.029    33.085     0.200
     5.029    31.386     0.200
     5.071    30.799     0.200
     5.494    35.468     0.200
     6.675    41.085     0.200
     2.011    12.527     0.200
     2.331    14.404     0.200
     2.517    15.326     0.200
     2.628    17.629     0.200
     2.660    17.362     0.200
     2.660    16.659     0.200
     2.739    18.236     0.200
     2.817    17.727     0.200
     3.218    21.854     0.200
     3.700    22.323     0.200
     4.286    26.485     0.200
     4.286    26.286     0.200
     4.307    26.438     0.200
     4.871    30.461     0.200
     5.262    32.397     0.200
     5.785    34.790     0.200
     5.968    36.151     0.200
     5.968    35.253     0.200
     2.132    14.195     0.200
     2.316    15.147     0.200
     2.316    15.045     0.200
     2.447    15.416     0.200
     2.832    17.634     0.200
     2.832    17.431     0.200
     2.774    17.109     0.200
     2.774    18.812     0.200
     2.851    18.106     0.200
     2.851    17.801     0.200
     3.205    20.985     0.200
     3.479    21.687     0.200
     3.586    21.929     0.200
     4.012    25.758     0.200
     4.505    30.308     0.200
     4.564    28.127     0.200
     4.564    29.424     0.200
     4.564    28.424     0.200
     4.922    31.137     0.200
     5.106    31.887     0.200
     5.305    32.064     0.200
     6.541    40.450     0.200
     6.541    40.349     0.200
     6.841    42.146     0.200
     2.474    16.007     0.200
     2.687    16.928     0.200
     2.792    17.505     0.200
     2.792    18.005     0.200
     2.967    18.153     0.200
     3.337    21.238     0.200
     3.382    21.211     0.200
     3.404    21.953     0.200
     3.677    22.874     0.200
     3.677    22.577     0.200
     3.962    25.947     0.200
     3.962    26.146     0.200
     4.422    28.173     0.200
     4.422    26.974     0.200
     4.401    28.126     0.200
     4.401    27.923     0.200
     4.877    29.266     0.200
     5.204    34.157     0.200
     5.204    32.555     0.200
     5.439    35.015     0.200
     6.630    43.114     0.200
     2.273    14.600     0.200
     2.647    16.436     0.200
     2.770    17.601     0.200
     3.373    20.967     0.200
     3.414    23.180     0.200
     3.726    23.048     0.200
     3.946    23.979     0.200
     3.946    24.779     0.200
     4.328    26.419     0.200
     4.347    27.593     0.200
     4.864    30.067     0.200
     5.310    33.967     0.200
     6.876    42.386     0.200
     2.327    14.851     0.200
     2.818    19.023     0.200
     2.993    18.178     0.200
     3.310    19.977     0.200
     3.423    20.860     0.200
     3.993    26.419     0.200
     2.444    15.810     0.200
     3.033    18.936     0.200
     3.384    20.536     0.200
     3.510    22.075     0.200
     3.510    21.672     0.200
     3.625    22.825     0.200
     4.079    25.929     0.200
     4.306    26.282     0.200
     4.546    27.978     0.200
     5.856    34.784     0.200
     7.192    43.302     0.200
     2.565    15.841     0.200
     2.649    16.669     0.200
     2.649    16.271     0.200
     2.771    17.545     0.200
     3.043    18.766     0.200
     3.332    21.889     0.200
     3.374    21.404     0.200
     3.946    24.429     0.200
     3.946    25.128     0.200
     4.082    26.844     0.200
     4.333    27.608     0.200
     4.350    26.816     0.200
     5.309    35.428     0.200
     5.512    33.155     0.200
     2.289    15.102     0.200
     2.690    17.023     0.200
     3.432    22.160     0.200
     3.735    24.119     0.200
     4.079    25.009     0.200
     4.039    24.970     0.200
     4.039    26.572     0.200
     4.347    28.683     0.200
     4.961    31.615     0.200
     5.273    33.981     0.200
     5.340    32.998     0.200
     2.299    14.545     0.200
     2.441    15.785     0.200
     2.864    17.557     0.200
     3.031    19.199     0.200
     3.383    21.000     0.200
     3.994    26.371     0.200
     4.079    25.964     0.200
     4.312    27.158     0.200
     4.543    28.354     0.200
     5.028    31.600     0.200
     5.610    35.301     0.200
     2.300    14.264     0.200
     2.300    14.464     0.200
     2.608    17.573     0.200
     3.025    19.701     0.200
     3.239    20.004     0.200
     3.239    19.903     0.200
     3.402    22.903     0.200
     3.645    22.166     0.200
     3.645    24.466     0.200
     3.766    23.256     0.200
     5.337    32.019     0.200
     2.564    16.365     0.200
     2.564    16.170     0.200
     2.644    17.227     0.200
     2.765    17.909     0.200
     2.765    17.315     0.200
     3.340    20.903     0.200
     3.340    21.106     0.200
     3.412    21.773     0.200
     3.412    20.968     0.200
     3.369    21.862     0.200
     3.369    22.362     0.200
     3.369    21.964     0.200
     3.369    21.362     0.200
     3.727    23.787     0.200
     3.940    26.499     0.200
     3.940    24.999     0.200
     4.340    27.027     0.200
     4.347    27.260     0.200
     4.347    27.760     0.200
     4.858    29.790     0.200
     4.858    29.892     0.200
     5.257    32.633     0.200
     5.257    33.031     0.200
     5.302    33.910     0.200
     5.513    34.250     0.200
     5.513    34.047     0.200
     5.510    35.586     0.200
     6.882    42.271     0.200
     9.909    62.647     0.200
    10.057    64.722     0.200
     2.575    16.171     0.200
     2.640    16.619     0.200
     2.763    18.384     0.200
     3.054    18.787     0.200
     3.365    20.852     0.200
     3.365    20.751     0.200
     3.421    21.097     0.200
     3.939    24.858     0.200
     4.329    26.904     0.200
     4.340    27.376     0.200
     4.856    31.950     0.200
     2.566    16.127     0.200
     2.566    16.026     0.200
     2.637    16.503     0.200
     2.758    17.698     0.200
     2.758    17.596     0.200
     3.347    21.922     0.200
     3.362    21.242     0.200
     3.734    23.109     0.200
     4.344    26.989     0.200
     2.572    16.249     0.200
     2.572    15.952     0.200
     2.637    17.391     0.200
     3.341    20.572     0.200
     3.362    21.131     0.200
     3.735    23.780     0.200
     3.934    25.055     0.200
     3.934    24.953     0.200
     4.336    26.958     0.200
     4.336    27.162     0.200
     4.339    26.932     0.200
     4.339    27.432     0.200
     5.522    33.328     0.200
     5.522    33.929     0.200
     6.888    42.384     0.200
     2.564    16.205     0.200
     2.564    16.404     0.200
     2.654    17.752     0.200
     2.776    17.824     0.200
     2.776    17.527     0.200
     3.040    18.744     0.200
     3.327    20.689     0.200
     3.327    21.189     0.200
     3.407    20.954     0.200
     3.407    21.157     0.200
     3.379    21.188     0.200
     3.379    21.587     0.200
     3.719    22.618     0.200
     3.951    25.906     0.200
     4.078    27.333     0.200
     4.354    27.205     0.200
     4.354    27.404     0.200
     4.354    28.205     0.200
     4.869    31.894     0.200
     4.869    32.195     0.200
     5.314    33.408     0.200
     5.509    34.034     0.200
     5.509    34.432     0.200
     5.624    35.869     0.200
     6.670    43.680     0.200
     6.871    42.537     0.200
     6.871    43.639     0.200
     2.560    16.109     0.200
     2.560    15.909     0.200
     2.660    17.642     0.200
     3.035    18.666     0.200
     3.385    20.875     0.200
     3.385    21.775     0.200
     3.713    22.851     0.200
     3.958    25.195     0.200
     3.958    25.795     0.200
     4.072    29.261     0.200
     4.360    29.597     0.200
     4.876    30.084     0.200
     2.634    16.433     0.200
     2.756    17.404     0.200
     3.056    18.800     0.200
     3.359    21.368     0.200
     3.738    22.741     0.200
     3.738    23.741     0.200
     3.932    25.084     0.200
     3.932    24.284     0.200
     4.335    27.080     0.200
     4.850    31.072     0.200
     5.269    33.582     0.200
     5.269    32.981     0.200
     2.642    16.485     0.200
     2.765    17.948     0.200
     3.051    18.917     0.200
     3.368    20.715     0.200
     3.368    20.817     0.200
     3.731    22.984     0.200
     3.941    25.629     0.200
     3.941    24.328     0.200
     4.329    26.697     0.200
     4.859    31.014     0.200
     5.261    34.822     0.200
     5.261    32.923     0.200
     5.305    32.911     0.200
     5.500    36.139     0.200
     6.681    41.547     0.200
     3.748    23.158     0.200
     4.332    26.741     0.200
     4.326    27.813     0.200
     2.571    15.913     0.200
     2.638    16.823     0.200
     4.337    26.703     0.200
     2.538    15.980     0.200
     3.334    20.489     0.200
     2.555    16.470     0.200
     2.555    16.170     0.200
     2.654    16.611     0.200
     3.336    22.051     0.200
     3.379    21.255     0.200
     3.949    25.895     0.200
     3.949    24.395     0.200
     4.342    27.410     0.200
     4.357    28.342     0.200
     4.867    30.887     0.200
     5.247    32.050     0.200
     6.874    42.069     0.200
     2.046    12.752     0.200
     2.901    18.276     0.200
     4.577    29.725     0.200
     4.577    28.920     0.200
     5.054    32.056     0.200
     5.870    36.823     0.200
     5.971    39.449     0.200
     2.147    13.365     0.200
     2.616    16.403     0.200
     3.062    19.090     0.200
     3.062    18.692     0.200
     3.013    18.167     0.200
     3.013    18.269     0.200
     3.370    22.797     0.200
     3.594    22.384     0.200
     3.594    21.986     0.200
     3.561    21.461     0.200
     4.110    24.859     0.200
     4.160    27.082     0.200
     4.160    25.480     0.200
     4.487    28.763     0.200
     5.081    31.134     0.200
     5.598    35.120     0.200
     6.535    41.563     0.200
     2.569    16.123     0.200
     2.637    16.530     0.200
     3.362    21.372     0.200
     3.418    22.210     0.200
     3.735    23.820     0.200
     3.933    24.804     0.200
     4.092    26.050     0.200
     4.341    27.044     0.200
     4.339    26.765     0.200
     5.265    33.061     0.200
     5.505    34.363     0.200
     6.889    42.202     0.200
     2.074    13.488     0.200
     2.710    16.966     0.200
     2.790    18.034     0.200
     3.416    21.831     0.200
     3.416    22.431     0.200
     3.483    21.652     0.200
     3.650    23.004     0.200
     3.650    23.604     0.200
     4.442    29.060     0.200
     4.557    28.116     0.200
     4.863    32.346     0.200
     4.863    29.846     0.200
     5.259    32.523     0.200
     2.734    16.707     0.200
     3.306    21.231     0.200
     3.306    20.829     0.200
     3.786    23.330     0.200
     3.786    23.529     0.200
     3.880    23.838     0.200
     4.266    26.733     0.200
     4.266    26.932     0.200
     4.214    24.936     0.200
     4.614    30.567     0.200
     4.820    30.964     0.200
     5.545    35.664     0.200
     5.772    37.255     0.200
     5.872    35.887     0.200
     7.218    46.881     0.200
     7.218    46.478     0.200
     2.263    14.358     0.200
     2.692    16.851     0.200
     4.657    28.819     0.200
     2.565    16.126     0.200
     2.773    19.093     0.200
     3.330    20.599     0.200
     3.330    22.798     0.200
     3.376    20.753     0.200
     3.376    21.453     0.200
     3.409    23.371     0.200
     3.721    23.028     0.200
     4.332    27.603     0.200
     4.352    27.768     0.200
     5.252    32.366     0.200
     5.511    34.247     0.200
     6.873    41.943     0.200
     2.573    16.456     0.200
     2.646    17.011     0.200
     3.365    20.319     0.200
     2.182    13.762     0.200
     2.286    15.252     0.200
     2.854    17.418     0.200
     2.939    18.826     0.200
     3.506    21.310     0.200
     3.563    22.346     0.200
     4.101    25.759     0.200
     4.519    27.384     0.200
     4.579    29.884     0.200
     5.028    32.441     0.200
     6.748    40.173     0.200
     2.566    16.237     0.200
     2.641    16.361     0.200
     2.762    17.355     0.200
     3.342    21.876     0.200
     3.342    23.079     0.200
     3.366    21.504     0.200
     3.366    20.605     0.200
     3.730    22.747     0.200
     3.730    23.349     0.200
     3.937    26.140     0.200
     4.088    26.476     0.200
     4.341    26.928     0.200
     4.343    26.799     0.200
     4.343    27.096     0.200
     5.299    34.150     0.200
     5.516    33.114     0.200
     5.516    33.512     0.200
     5.507    35.110     0.200
     6.682    44.205     0.200
     6.886    42.232     0.200
     2.571    16.271     0.200
     2.571    15.974     0.200
     2.638    16.486     0.200
     2.760    17.267     0.200
     2.760    17.166     0.200
     3.341    20.390     0.200
     3.363    20.922     0.200
     3.419    21.975     0.200
     3.734    23.405     0.200
     3.935    25.050     0.200
     4.091    26.026     0.200
     4.091    27.823     0.200
     4.337    26.869     0.200
     4.337    26.267     0.200
     4.340    27.026     0.200
     4.340    27.128     0.200
     4.853    32.136     0.200
     4.853    29.737     0.200
     5.298    33.545     0.200
     5.298    32.241     0.200
     5.502    34.562     0.200
     5.520    33.054     0.200
     5.520    33.851     0.200
     6.887    41.905     0.200
     8.128    51.525     0.200
     2.313    14.352     0.200
     2.539    16.809     0.200
     2.656    16.749     0.200
     2.844    17.448     0.200
     3.543    22.200     0.200
     4.267    25.947     0.200
     4.267    26.247     0.200
     4.336    26.845     0.200
     4.740    28.432     0.200
     4.740    30.932     0.200
     4.825    29.639     0.200
     5.232    32.577     0.200
     5.232    32.679     0.200
     5.738    35.982     0.200
     5.738    34.681     0.200
     5.788    36.299     0.200
     6.020    35.884     0.200
     6.020    36.185     0.200
     6.120    38.226     0.200
     2.635    16.572     0.200
     2.756    17.462     0.200
     3.346    21.778     0.200
     3.360    21.315     0.200
     3.931    24.644     0.200
     3.931    24.941     0.200
     4.094    26.249     0.200
     4.340    26.768     0.200
     4.337    27.105     0.200
     5.267    32.858     0.200
     5.267    32.061     0.200
     5.294    33.146     0.200
     5.503    34.907     0.200
     2.564    16.542     0.200
     2.564    16.042     0.200
     2.640    16.846     0.200
     3.045    18.720     0.200
     3.345    21.819     0.200
     3.365    21.192     0.200
     3.413    22.923     0.200
     3.730    23.524     0.200
     3.936    25.127     0.200
     4.087    25.262     0.200
     4.344    27.163     0.200
     4.344    28.264     0.200
     4.343    27.474     0.200
     4.853    29.118     0.200
     4.853    29.520     0.200
     5.260    33.071     0.200
     5.297    34.348     0.200
     5.515    34.802     0.200
     5.510    35.862     0.200
     2.497    16.137     0.200
     2.497    15.938     0.200
     2.671    16.606     0.200
     2.779    17.147     0.200
     2.988    18.797     0.200
     3.358    21.186     0.200
     3.358    21.385     0.200
     3.379    22.740     0.200
     3.390    20.713     0.200
     3.950    25.072     0.200
     3.950    25.276     0.200
     4.043    25.198     0.200
     4.383    27.523     0.200
     4.383    27.625     0.200
     4.407    27.141     0.200
     4.407    26.942     0.200
     4.866    30.589     0.200
     5.221    31.240     0.200
     5.294    33.687     0.200
     5.294    33.988     0.200
     5.460    33.060     0.200
     6.647    40.708     0.200
     6.647    41.208     0.200
     4.399    27.433     0.200
     2.497    15.699     0.200
     2.663    17.560     0.200
     2.770    18.016     0.200
     2.992    18.523     0.200
     3.941    24.348     0.200
     4.376    28.765     0.200
     4.416    26.808     0.200
     4.416    28.608     0.200
     4.856    31.063     0.200
     5.228    33.028     0.200
     5.284    34.576     0.200
     5.579    35.431     0.200
     2.506    16.073     0.200
     2.669    16.673     0.200
     2.995    19.162     0.200
     3.371    22.978     0.200
     3.371    21.778     0.200
     3.365    22.351     0.200
     3.365    22.152     0.200
     3.389    21.469     0.200
     3.389    21.569     0.200
     3.951    24.710     0.200
     3.951    25.010     0.200
     4.047    24.688     0.200
     4.396    27.315     0.200
     4.396    28.815     0.200
     4.379    27.611     0.200
     4.379    28.312     0.200
     4.867    32.620     0.200
     4.867    29.919     0.200
     5.225    33.045     0.200
     5.298    34.293     0.200
     5.466    33.727     0.200
     5.466    33.227     0.200
     5.681    36.121     0.200
     6.649    45.120     0.200
     6.649    41.820     0.200
     2.490    15.631     0.200
     2.678    17.743     0.200
     2.785    17.189     0.200
     3.377    21.186     0.200
     3.397    21.552     0.200
     3.957    24.117     0.200
     4.035    25.899     0.200
     4.035    27.399     0.200
     4.390    27.358     0.200
     4.409    27.038     0.200
     4.409    26.937     0.200
     5.214    31.343     0.200
     5.214    32.440     0.200
     5.300    33.943     0.200
     5.300    33.544     0.200
     2.500    15.951     0.200
     2.671    16.746     0.200
     2.780    18.476     0.200
     3.360    21.215     0.200
     3.391    20.748     0.200
     3.391    20.948     0.200
     3.952    25.601     0.200
     3.952    24.301     0.200
     3.952    26.201     0.200
     4.383    27.873     0.200
     4.402    26.845     0.200
     5.221    31.490     0.200
     5.221    32.790     0.200
     5.297    32.703     0.200
     5.575    35.558     0.200
     2.675    17.062     0.200
     3.395    21.763     0.200
     3.690    23.416     0.200
     4.401    27.319     0.200
     4.386    27.291     0.200
     4.872    30.527     0.200
     5.218    33.288     0.200
     5.301    33.818     0.200
     5.458    34.381     0.200
     5.577    35.698     0.200
     6.872    42.578     0.200
     2.567    15.902     0.200
     3.410    22.860     0.200
     3.379    20.724     0.200
     3.720    22.640     0.200
     3.952    25.240     0.200
     3.952    25.037     0.200
     4.327    26.656     0.200
     4.327    26.359     0.200
     4.353    27.853     0.200
     4.870    31.926     0.200
     4.870    29.325     0.200
     5.251    31.976     0.200
     6.671    43.504     0.200
     6.870    41.878     0.200
     2.559    16.723     0.200
     2.559    16.123     0.200
     2.667    16.563     0.200
     3.277    21.737     0.200
     3.454    22.472     0.200
     3.456    22.046     0.200
     3.839    24.783     0.200
     3.839    23.584     0.200
     4.150    26.751     0.200
     4.273    27.211     0.200
     4.273    26.211     0.200
     4.424    28.150     0.200
     4.424    26.850     0.200
     5.190    33.516     0.200
     5.331    32.067     0.200
     5.511    34.567     0.200
     5.558    35.025     0.200
     5.558    34.824     0.200
     6.758    42.018     0.200
     2.552    15.949     0.200
     2.552    16.949     0.200
     2.653    16.373     0.200
     2.653    16.772     0.200
     2.772    18.185     0.200
     3.032    18.645     0.200
     3.342    22.126     0.200
     3.400    22.247     0.200
     3.377    21.025     0.200
     3.718    23.238     0.200
     3.718    23.339     0.200
     4.074    26.578     0.200
     3.946    24.773     0.200
     4.348    26.981     0.200
     4.348    27.380     0.200
     4.356    28.994     0.200
     4.356    29.197     0.200
     4.864    31.567     0.200
     5.305    34.619     0.200
     5.502    34.122     0.200
     5.502    33.021     0.200
     5.521    35.791     0.200
     6.877    42.778     0.200
     2.645    16.538     0.200
     2.764    17.250     0.200
     3.348    20.537     0.200
     3.348    21.939     0.200
     3.406    22.354     0.200
     3.369    21.136     0.200
     3.369    21.487     0.200
     3.369    21.589     0.200
     3.725    23.435     0.200
     3.939    24.139     0.200
     3.939    24.241     0.200
     4.351    27.634     0.200
     4.349    26.955     0.200
     4.349    29.354     0.200
     4.349    26.756     0.200
     4.856    29.835     0.200
     4.856    31.535     0.200
     5.255    32.083     0.200
     5.255    31.684     0.200
     5.298    34.479     0.200
     5.508    33.233     0.200
     5.508    33.132     0.200
     5.631    36.165     0.200
     6.677    41.690     0.200
     6.677    43.690     0.200
     6.884    41.463     0.200
     2.152    13.472     0.200
     2.543    15.807     0.200
     4.262    26.750     0.200
     4.451    26.742     0.200
     5.164    32.221     0.200
     5.344    33.322     0.200
     7.011    42.663     0.200
     7.011    42.459     0.200
     3.338    20.683     0.200
     2.231    14.246     0.200
     2.578    16.098     0.200
     2.578    16.399     0.200
     2.746    17.034     0.200
     2.746    18.233     0.200
     3.352    22.365     0.200
     3.350    20.791     0.200
     3.350    21.689     0.200
     3.746    23.459     0.200
     3.922    23.617     0.200
     3.922    24.715     0.200
     4.103    25.695     0.200
     4.341    26.719     0.200
     4.327    27.982     0.200
     5.277    32.903     0.200
     5.285    31.809     0.200
     5.285    34.211     0.200
     5.496    34.839     0.200
     5.531    34.840     0.200
     6.698    43.017     0.200
     6.901    43.150     0.200
     6.901    41.650     0.200
     2.412    14.720     0.200
     3.664    22.313     0.200
     3.664    24.412     0.200
     4.506    27.782     0.200
     2.253    14.016     0.200
     2.550    15.848     0.200
     2.764    17.550     0.200
     2.900    17.869     0.200
     3.352    20.788     0.200
     3.402    23.604     0.200
     3.370    21.380     0.200
     3.723    23.260     0.200
     4.357    27.264     0.200
     4.351    28.331     0.200
     5.253    32.410     0.200
     5.253    33.813     0.200
     5.296    33.401     0.200
     5.504    34.678     0.200
     6.885    42.158     0.200
     6.885    41.658     0.200
     2.201    13.670     0.200
     2.885    19.192     0.200
     2.927    19.307     0.200
     3.508    22.027     0.200
     3.508    22.324     0.200
     3.641    22.475     0.200
     3.808    23.022     0.200
     3.911    24.815     0.200
     5.693    36.217     0.200
     7.310    43.653     0.200
     2.469    14.988     0.200
     3.009    19.388     0.200
     3.027    18.983     0.200
     4.209    26.090     0.200
     5.130    31.338     0.200
     6.608    39.689     0.200
     2.425    14.992     0.200
     2.898    17.673     0.200
     3.483    21.844     0.200
     3.878    23.837     0.200
     4.395    26.205     0.200
     4.886    32.069     0.200
     5.203    32.572     0.200
     7.334    43.605     0.200
     2.429    15.079     0.200
     2.421    14.874     0.200
     2.630    16.731     0.200
     2.669    17.779     0.200
     3.181    19.405     0.200
     3.132    19.272     0.200
     3.556    22.929     0.200
     3.603    22.880     0.200
     3.684    23.425     0.200
     3.684    22.328     0.200
     3.939    24.252     0.200
     4.148    27.512     0.200
     4.272    26.769     0.200
     4.515    28.927     0.200
     5.029    31.831     0.200
     5.029    32.230     0.200
     5.462    34.487     0.200
     5.462    32.487     0.200
     5.480    35.168     0.200
     7.146    43.529     0.200
     2.257    14.466     0.200
     2.571    16.004     0.200
     2.906    18.099     0.200
     3.378    20.590     0.200
     3.952    25.793     0.200
     4.322    26.676     0.200
     4.870    31.280     0.200
     5.253    32.009     0.200
     5.316    34.468     0.200
     5.501    35.316     0.200
     6.870    41.840     0.200
     2.578    15.953     0.200
     3.336    22.612     0.200
     3.362    21.305     0.200
     3.935    24.419     0.200
     3.935    24.614     0.200
     4.095    25.643     0.200
     4.329    26.327     0.200
     4.329    28.624     0.200
     4.329    26.921     0.200
     4.337    27.330     0.200
     5.526    34.358     0.200
     5.526    35.554     0.200
     5.495    33.718     0.200
     6.886    42.675     0.200
     2.246    14.186     0.200
     2.575    16.045     0.200
     2.764    18.647     0.200
     2.895    17.821     0.200
     3.333    21.109     0.200
     3.333    20.609     0.200
     3.421    21.480     0.200
     3.366    21.415     0.200
     3.732    22.942     0.200
     3.940    25.024     0.200
     3.940    24.724     0.200
     4.091    25.653     0.200
     4.091    28.052     0.200
     4.091    27.353     0.200
     4.328    27.693     0.200
     4.328    26.593     0.200
     4.341    27.743     0.200
     4.341    27.343     0.200
     4.858    31.812     0.200
     5.304    33.002     0.200
     5.522    34.057     0.200
     5.522    33.057     0.200
     5.612    36.228     0.200
     6.683    41.405     0.200
     6.683    44.005     0.200
     6.882    42.285     0.200
     7.291    45.715     0.200
     8.802    55.383     0.200
     2.241    14.395     0.200
     2.760    17.734     0.200
     3.062    18.920     0.200
     3.329    22.793     0.200
     3.936    24.304     0.200
     3.936    25.304     0.200
     4.320    27.130     0.200
     4.320    27.325     0.200
     4.334    26.762     0.200
     4.855    28.995     0.200
     5.303    33.661     0.200
     5.530    33.108     0.200
     6.689    40.880     0.200
     6.885    42.397     0.200
     2.038    14.064     0.200
     3.017    18.737     0.200
     3.270    19.993     0.200
     4.297    25.697     0.200
     4.361    27.257     0.200
     4.720    30.466     0.200
     5.166    31.962     0.200
     5.212    32.626     0.200
     5.624    35.217     0.200
     2.368    14.703     0.200
     2.958    19.125     0.200
     3.017    18.627     0.200
     3.490    21.315     0.200
     3.490    23.014     0.200
     3.614    21.959     0.200
     4.298    26.575     0.200
     4.458    27.310     0.200
     5.146    31.980     0.200
     2.338    15.045     0.200
     2.594    15.958     0.200
     3.069    18.617     0.200
     3.494    21.949     0.200
     3.658    23.245     0.200
     3.715    22.581     0.200
     4.040    24.984     0.200
     4.034    24.952     0.200
     4.315    26.376     0.200
     4.397    26.614     0.200
     4.578    27.298     0.200
     5.570    34.721     0.200
     6.990    43.950     0.200
     2.476    15.746     0.200
     2.593    16.079     0.200
     3.068    18.536     0.200
     3.343    20.525     0.200
     3.656    22.170     0.200
     3.714    23.500     0.200
     4.040    25.095     0.200
     4.034    24.968     0.200
     4.317    26.655     0.200
     4.397    29.129     0.200
     5.570    35.135     0.200
     7.161    45.276     0.200
     2.498    15.569     0.200
     3.125    20.054     0.200
     3.661    21.998     0.200
     4.163    26.038     0.200
     4.611    27.715     0.200
     4.573    27.557     0.200
     4.573    29.256     0.200
     4.983    31.867     0.200
     5.455    33.259     0.200
     5.455    32.158     0.200
     5.552    34.329     0.200
     6.893    41.987     0.200
     7.007    42.447     0.200
     7.181    43.426     0.200
     2.141    13.529     0.200
     2.391    15.507     0.200
     2.391    15.304     0.200
     2.512    16.596     0.200
     2.820    17.307     0.200
     2.906    17.998     0.200
     3.024    19.223     0.200
     3.024    18.918     0.200
     3.179    19.818     0.200
     3.183    21.272     0.200
     3.183    21.374     0.200
     3.631    22.410     0.200
     3.631    22.840     0.200
     3.833    25.179     0.200
     4.197    26.330     0.200
     4.321    27.584     0.200
     4.605    30.178     0.200
     4.605    29.974     0.200
     5.000    31.963     0.200
     5.114    30.942     0.200
     5.114    32.841     0.200
     5.540    34.862     0.200
     5.681    36.014     0.200
     8.946    56.121     0.200
     2.137    13.972     0.200
     2.736    16.777     0.200
     2.865    17.772     0.200
     3.453    20.709     0.200
     3.506    22.498     0.200
     4.391    28.170     0.200
     4.862    30.870     0.200
     5.762    37.170     0.200
     2.234    14.860     0.200
     2.627    16.270     0.200
     3.350    20.231     0.200
     3.417    21.050     0.200
     3.918    24.100     0.200
     4.096    25.130     0.200
     4.333    27.361     0.200
     4.835    30.498     0.200
     5.271    31.813     0.200
     5.276    32.358     0.200
     6.694    42.108     0.200
     6.906    43.034     0.200
     7.527    47.990     0.200
     8.681    55.714     0.200
     2.556    15.561     0.200
     2.685    16.188     0.200
     2.803    16.912     0.200
     3.369    21.108     0.200
     3.977    25.112     0.200
     4.351    26.539     0.200
     4.351    28.941     0.200
     4.389    28.202     0.200
     4.894    30.609     0.200
     5.470    33.687     0.200
     6.636    43.175     0.200
     6.847    42.513     0.200
     2.241    14.327     0.200
     2.577    15.906     0.200
     2.889    18.066     0.200
     3.361    20.362     0.200
     3.737    22.865     0.200
     3.934    24.675     0.200
     4.096    24.783     0.200
     4.336    27.482     0.200
     5.298    32.255     0.200
     6.888    43.999     0.200
     7.550    48.574     0.200
     2.579    15.776     0.200
     3.930    24.813     0.200
     4.332    26.615     0.200
     5.272    32.949     0.200
     6.892    42.739     0.200
     2.729    16.546     0.200
     2.904    18.541     0.200
     3.436    22.887     0.200
     3.958    25.801     0.200
     7.403    44.296     0.200
     2.241    14.530     0.200
     2.580    15.888     0.200
     2.890    18.270     0.200
     3.335    22.076     0.200
     3.362    21.060     0.200
     3.737    23.275     0.200
     3.935    24.366     0.200
     4.096    27.085     0.200
     4.327    28.088     0.200
     4.336    26.292     0.200
     4.336    29.190     0.200
     4.853    29.551     0.200
     5.300    34.139     0.200
     5.527    33.688     0.200
     5.493    36.284     0.200
     6.886    41.924     0.200
     2.250    14.313     0.200
     2.240    14.339     0.200
     2.574    15.939     0.200
     2.634    17.038     0.200
     2.887    18.077     0.200
     3.344    22.152     0.200
     3.359    20.974     0.200
     3.359    20.872     0.200
     3.738    23.447     0.200
     3.931    23.898     0.200
     4.096    24.875     0.200
     4.096    27.679     0.200
     4.335    27.077     0.200
     4.335    26.780     0.200
     4.337    28.659     0.200
     4.337    27.057     0.200
     4.849    30.984     0.200
     5.294    34.093     0.200
     5.524    33.907     0.200
     5.500    34.594     0.200
     6.689    42.413     0.200
     6.891    42.651     0.200
     2.059    13.130     0.200
     2.726    16.954     0.200
     2.816    17.399     0.200
     2.901    18.112     0.200
     2.974    18.557     0.200
     3.437    20.855     0.200
     4.450    28.035     0.200
     4.497    28.374     0.200
     4.894    29.947     0.200
     5.158    31.469     0.200
     6.588    40.675     0.200
     6.859    43.311     0.200
     2.224    14.119     0.200
     2.330    15.174     0.200
     2.330    14.775     0.200
     2.621    16.582     0.200
     2.621    16.282     0.200
     2.735    17.556     0.200
     2.880    17.856     0.200
     2.880    18.555     0.200
     3.174    20.328     0.200
     3.360    21.298     0.200
     3.360    20.856     0.200
     3.536    22.004     0.200
     3.789    23.753     0.200
     3.789    23.151     0.200
     3.962    25.129     0.200
     4.138    26.076     0.200
     4.138    25.478     0.200
     4.171    26.487     0.200
     4.288    26.321     0.200
     4.884    29.576     0.200
     4.884    30.474     0.200
     5.325    32.724     0.200
     5.325    33.524     0.200
     5.335    34.103     0.200
     5.369    34.513     0.200
     5.459    34.405     0.200
     5.635    34.605     0.200
     5.635    35.105     0.200
     6.855    41.973     0.200
     2.278    14.919     0.200
     2.672    16.415     0.200
     2.927    18.339     0.200
     3.291    20.590     0.200
     3.400    20.320     0.200
     3.705    23.962     0.200
     3.977    24.692     0.200
     4.298    27.442     0.200
     4.895    30.068     0.200
     5.236    33.187     0.200
     6.844    41.632     0.200
     4.293    26.229     0.200
     2.319    15.256     0.200
     2.463    16.175     0.200
     2.575    16.562     0.200
     2.575    16.762     0.200
     2.576    16.360     0.200
     2.857    18.275     0.200
     3.052    19.812     0.200
     3.052    19.005     0.200
     3.052    19.205     0.200
     3.371    21.380     0.200
     3.371    21.279     0.200
     3.493    22.159     0.200
     3.644    23.489     0.200
     3.741    24.058     0.200
     3.741    24.457     0.200
     4.011    26.308     0.200
     4.011    25.708     0.200
     4.062    25.517     0.200
     4.297    28.372     0.200
     4.421    27.620     0.200
     4.565    29.240     0.200
     4.565    28.839     0.200
     5.051    32.578     0.200
     5.843    37.034     0.200
     6.996    43.877     0.200
     7.173    44.514     0.200
     2.425    15.573     0.200
     2.465    16.404     0.200
     2.598    16.648     0.200
     2.598    16.448     0.200
     2.725    17.263     0.200
     2.720    17.325     0.200
     2.720    17.626     0.200
     3.224    19.839     0.200
     3.194    21.413     0.200
     3.194    20.794     0.200
     3.419    20.968     0.200
     3.594    23.429     0.200
     3.594    24.329     0.200
     3.777    24.490     0.200
     3.777    24.890     0.200
     3.912    24.421     0.200
     4.162    27.603     0.200
     4.162    27.003     0.200
     4.271    27.032     0.200
     4.311    26.459     0.200
     4.697    29.557     0.200
     5.442    34.856     0.200
     5.442    34.654     0.200
     5.463    35.141     0.200
     8.997    58.677     0.200
     2.069    13.356     0.200
     2.465    15.644     0.200
     2.744    16.888     0.200
     2.721    16.855     0.200
     3.196    20.912     0.200
     3.237    19.827     0.200
     3.783    23.859     0.200
     3.916    24.409     0.200
     4.157    26.094     0.200
     4.278    27.882     0.200
     4.286    27.090     0.200
     4.703    28.721     0.200
     5.336    34.530     0.200
     5.448    34.834     0.200
     6.865    43.588     0.200
     7.035    43.411     0.200
     2.244    14.693     0.200
     2.242    14.808     0.200
     2.242    15.105     0.200
     2.560    16.698     0.200
     2.560    16.894     0.200
     2.636    17.013     0.200
     2.636    16.911     0.200
     2.755    17.330     0.200
     2.889    18.456     0.200
     3.045    18.842     0.200
     3.355    20.615     0.200
     3.355    22.217     0.200
     3.360    20.714     0.200
     3.360    21.769     0.200
     3.413    21.541     0.200
     3.734    23.598     0.200
     3.929    25.919     0.200
     3.929    26.020     0.200
     4.340    27.928     0.200
     4.340    28.428     0.200
     4.354    27.167     0.200
     4.847    30.017     0.200
     5.264    32.950     0.200
     5.264    32.450     0.200
     5.288    33.659     0.200
     5.288    34.659     0.200
     5.515    33.814     0.200
     5.515    33.619     0.200
     5.627    36.580     0.200
     6.894    42.625     0.200
     9.107    58.491     0.200
     2.239    14.093     0.200
     2.578    15.930     0.200
     2.633    16.293     0.200
     3.359    21.027     0.200
     3.740    23.180     0.200
     4.332    26.968     0.200
     2.011    12.693     0.200
     2.299    14.428     0.200
     2.649    16.245     0.200
     3.332    20.383     0.200
     3.296    20.191     0.200
     3.700    22.984     0.200
     3.767    23.505     0.200
     4.329    27.640     0.200
     4.741    30.433     0.200
     6.281    38.958     0.200
     2.008    12.522     0.200
     2.102    14.425     0.200
     2.705    16.893     0.200
     2.648    16.952     0.200
     3.065    18.891     0.200
     3.102    19.162     0.200
     3.043    19.052     0.200
     3.159    19.292     0.200
     3.296    20.291     0.200
     3.703    22.648     0.200
     3.703    25.148     0.200
     3.767    23.299     0.200
     4.320    26.346     0.200
     4.331    27.019     0.200
     4.739    30.848     0.200
     4.739    30.148     0.200
     4.866    30.574     0.200
     5.163    30.905     0.200
     5.664    35.355     0.200
     6.270    38.484     0.200
     6.283    39.637     0.200
     6.500    38.900     0.200
     2.351    15.495     0.200
     2.447    15.773     0.200
     2.600    16.397     0.200
     2.600    16.498     0.200
     2.687    17.180     0.200
     3.063    19.004     0.200
     3.063    18.785     0.200
     3.621    21.875     0.200
     3.643    22.419     0.200
     3.618    22.814     0.200
     4.080    26.326     0.200
     4.340    26.883     0.200
     4.519    28.994     0.200
     4.519    29.595     0.200
     4.534    30.028     0.200
     4.970    31.437     0.200
     5.531    34.192     0.200
     5.531    33.293     0.200
     5.522    34.329     0.200
     5.720    34.880     0.200
     5.720    34.080     0.200
     6.963    46.381     0.200
     8.576    54.649     0.200
     2.685    16.310     0.200
     2.896    17.751     0.200
     3.158    19.097     0.200
     3.563    22.465     0.200
     3.641    22.152     0.200
     3.975    26.056     0.200
     4.535    28.915     0.200
     5.102    32.405     0.200
     5.177    32.527     0.200
     5.480    33.689     0.200
     6.564    40.040     0.200
     2.251    14.624     0.200
     2.581    16.073     0.200
     2.645    16.428     0.200
     2.771    17.658     0.200
     2.900    18.255     0.200
     3.320    22.555     0.200
     3.372    21.141     0.200
     3.372    20.946     0.200
     3.730    23.570     0.200
     4.090    25.658     0.200
     4.315    26.941     0.200
     4.315    26.137     0.200
     4.343    26.804     0.200
     4.343    26.702     0.200
     4.865    30.612     0.200
     4.865    31.816     0.200
     5.261    32.905     0.200
     5.524    33.633     0.200
     5.524    33.336     0.200
     2.040    13.409     0.200
     2.090    14.033     0.200
     2.636    16.855     0.200
     3.030    18.857     0.200
     3.077    18.812     0.200
     3.284    19.794     0.200
     3.346    21.070     0.200
     3.755    23.301     0.200
     4.317    25.939     0.200
     4.319    27.314     0.200
     4.727    29.859     0.200
     5.235    31.929     0.200
     6.295    39.251     0.200
     6.511    40.234     0.200
     2.242    14.440     0.200
     2.580    15.895     0.200
     2.636    17.340     0.200
     2.760    17.894     0.200
     2.890    17.874     0.200
     3.362    21.269     0.200
     3.426    21.927     0.200
     3.737    22.897     0.200
     3.936    24.771     0.200
     3.936    25.771     0.200
     4.096    27.404     0.200
     4.325    27.429     0.200
     4.336    27.904     0.200
     4.854    29.456     0.200
     5.268    32.733     0.200
     5.527    33.604     0.200
     6.688    42.660     0.200
     6.885    43.457     0.200
     2.248    14.670     0.200
     2.246    14.189     0.200
     2.581    15.979     0.200
     2.641    16.587     0.200
     2.895    18.518     0.200
     3.367    20.910     0.200
     3.424    21.837     0.200
     3.733    23.231     0.200
     3.942    24.803     0.200
     4.094    25.330     0.200
     4.094    27.330     0.200
     4.320    26.991     0.200
     4.340    27.158     0.200
     4.860    30.490     0.200
     5.264    32.365     0.200
     5.308    33.059     0.200
     5.526    34.015     0.200
     6.684    41.898     0.200
     6.880    44.015     0.200
     2.059    13.520     0.200
     2.295    14.763     0.200
     2.045    13.130     0.200
     2.156    13.433     0.200
     2.304    15.114     0.200
     2.692    17.081     0.200
     2.939    18.197     0.200
     2.001    12.391     0.200
     2.040    13.829     0.200
     2.201    13.657     0.200
     2.201    14.556     0.200
     2.290    14.119     0.200
     2.664    16.251     0.200
     2.980    18.565     0.200
     3.228    20.470     0.200
     3.303    20.498     0.200
     3.380    20.403     0.200
     3.719    22.841     0.200
     4.227    26.414     0.200
     4.514    27.464     0.200
     4.703    29.355     0.200
     4.903    29.624     0.200
     5.137    32.588     0.200
     5.523    34.689     0.200
     6.334    39.124     0.200
     2.078    13.944     0.200
     2.470    16.573     0.200
     2.645    16.435     0.200
     2.581    17.278     0.200
     2.721    17.338     0.200
     3.168    20.622     0.200
     3.190    20.073     0.200
     3.190    20.272     0.200
     3.503    21.718     0.200
     3.503    22.117     0.200
     3.755    22.878     0.200
     3.755    23.378     0.200
     3.894    25.159     0.200
     4.185    27.760     0.200
     4.424    26.767     0.200
     4.424    28.365     0.200
     4.672    30.477     0.200
     5.420    34.244     0.200
     5.642    35.357     0.200
     2.279    14.794     0.200
     2.409    15.577     0.200
     2.534    16.328     0.200
     2.595    16.912     0.200
     2.187    13.959     0.200
     2.610    16.730     0.200
     2.581    17.061     0.200
     2.704    17.633     0.200
     3.100    19.007     0.200
     3.306    21.001     0.200
     3.469    22.702     0.200
     3.378    21.559     0.200
     3.790    23.955     0.200
     3.879    24.610     0.200
     4.284    27.292     0.200
     4.344    27.891     0.200
     4.797    30.697     0.200
     5.246    34.262     0.200
     5.320    33.902     0.200
     5.570    35.080     0.200
     6.741    43.013     0.200
     6.942    43.272     0.200
     7.231    47.302     0.200
     2.860    19.048     0.200
     2.860    17.948     0.200
     3.319    19.983     0.200
     3.319    21.084     0.200
     3.289    21.937     0.200
     3.466    21.373     0.200
     3.628    21.976     0.200
     3.987    24.592     0.200
     4.033    24.550     0.200
     4.345    27.014     0.200
     4.445    28.345     0.200
     4.950    30.450     0.200
     5.159    32.016     0.200
     5.420    32.764     0.200
     5.420    32.264     0.200
     5.385    33.279     0.200
     5.702    34.746     0.200
     6.792    41.457     0.200
     7.430    47.408     0.200
     2.319    14.261     0.200
     2.319    14.662     0.200
     2.462    16.197     0.200
     2.462    15.296     0.200
     2.574    16.792     0.200
     2.575    16.470     0.200
     3.051    19.117     0.200
     3.051    19.317     0.200
     3.367    20.526     0.200
     3.643    22.312     0.200
     3.643    23.713     0.200
     3.738    22.702     0.200
     3.738    23.603     0.200
     4.012    25.000     0.200
     4.012    24.400     0.200
     4.303    27.105     0.200
     4.419    27.852     0.200
     4.564    27.864     0.200
     4.564    28.764     0.200
     5.048    32.819     0.200
     5.340    33.607     0.200
     5.592    34.071     0.200
     5.839    36.179     0.200
     7.174    46.207     0.200
     8.595    55.318     0.200
    10.223    66.120     0.200
     2.326    14.688     0.200
     2.582    16.500     0.200
     3.057    19.053     0.200
     3.057    20.651     0.200
     3.358    20.640     0.200
     3.647    22.665     0.200
     4.053    24.732     0.200
     4.020    26.212     0.200
     4.310    27.333     0.200
     4.568    29.118     0.200
     5.050    32.297     0.200
     5.584    35.366     0.200
     7.169    44.360     0.200
     2.080    14.551     0.200
     2.269    14.445     0.200
     2.618    16.770     0.200
     3.010    18.993     0.200
     3.116    20.356     0.200
     2.039    12.932     0.200
     2.916    17.592     0.200
     3.034    18.721     0.200
     3.283    20.617     0.200
     3.504    22.136     0.200
     3.590    23.034     0.200
     4.070    24.933     0.200
     4.348    26.680     0.200
     4.484    27.898     0.200
     4.986    30.638     0.200
     5.120    32.175     0.200
     5.417    34.009     0.200
     6.757    41.871     0.200
     2.122    13.932     0.200
     2.248    14.160     0.200
     2.557    16.053     0.200
     2.641    17.066     0.200
     2.761    18.270     0.200
     2.895    18.312     0.200
     3.366    21.512     0.200
     3.729    23.473     0.200
     3.936    25.457     0.200
     4.086    26.517     0.200
     4.347    27.757     0.200
     4.345    28.188     0.200
     4.854    30.953     0.200
     5.259    32.416     0.200
     5.513    34.060     0.200
     6.681    42.928     0.200
     6.887    42.722     0.200
     2.036    13.057     0.200
     2.426    15.502     0.200
     2.528    16.221     0.200
     2.644    16.368     0.200
     2.675    17.090     0.200
     3.141    20.461     0.200
     3.189    20.598     0.200
     3.570    22.055     0.200
     3.699    23.449     0.200
     3.935    24.393     0.200
     4.149    27.399     0.200
     4.479    28.149     0.200
     4.615    28.157     0.200
     5.052    32.263     0.200
     5.459    34.412     0.200
     5.663    35.632     0.200
     6.889    43.921     0.200
     7.128    45.434     0.200
     2.609    16.853     0.200
     2.602    15.737     0.200
     2.602    17.339     0.200
     3.265    19.707     0.200
     3.265    21.906     0.200
     3.738    23.678     0.200
     3.812    23.022     0.200
     3.812    25.022     0.200
     3.883    24.491     0.200
     4.085    25.526     0.200
     4.370    28.309     0.200
     4.370    29.207     0.200
     4.634    29.024     0.200
     4.940    30.955     0.200
     5.305    33.189     0.200
     5.380    32.816     0.200
     5.901    37.643     0.200
     6.758    42.634     0.200
     7.182    44.493     0.200
     2.202    13.980     0.200
     2.487    15.746     0.200
     2.876    17.707     0.200
     2.961    19.218     0.200
     3.124    18.920     0.200
     3.363    20.931     0.200
     3.483    21.924     0.200
     3.585    21.833     0.200
     3.820    24.197     0.200
     4.123    25.455     0.200
     4.520    27.631     0.200
     4.601    28.972     0.200
     5.006    31.751     0.200
     5.034    31.424     0.200
     5.226    31.981     0.200
     5.802    38.163     0.200
     5.919    36.465     0.200
     6.727    41.567     0.200
     7.298    44.909     0.200
     8.167    52.160     0.200
     2.217    14.079     0.200
     2.251    13.782     0.200
     2.405    14.983     0.200
     2.503    15.841     0.200
     2.739    16.890     0.200
     2.892    18.099     0.200
     2.976    18.221     0.200
     3.140    19.517     0.200
     3.467    20.691     0.200
     3.601    22.636     0.200
     3.804    22.963     0.200
     4.138    25.764     0.200
     4.523    27.462     0.200
     4.618    29.269     0.200
     4.990    30.220     0.200
     5.049    31.333     0.200
     5.210    31.647     0.200
     5.438    34.288     0.200
     6.422    40.512     0.200
     6.714    41.000     0.200
     2.481    15.527     0.200
     2.758    16.989     0.200
     2.869    17.686     0.200
     3.117    18.801     0.200
     3.373    20.612     0.200
     3.490    21.144     0.200
     3.577    22.126     0.200
     3.825    23.334     0.200
     4.115    26.060     0.200
     4.528    27.242     0.200
     4.596    28.542     0.200
     5.012    30.082     0.200
     5.415    33.678     0.200
     2.110    13.971     0.200
     2.234    14.526     0.200
     2.746    17.450     0.200
     2.880    18.179     0.200
     2.880    18.077     0.200
     3.362    21.453     0.200
     3.351    21.286     0.200
     3.351    20.887     0.200
     3.742    23.421     0.200
     3.920    24.640     0.200
     3.920    24.940     0.200
     4.332    27.939     0.200
     4.356    26.453     0.200
     4.838    29.637     0.200
     5.272    31.970     0.200
     5.522    33.655     0.200
     6.567    41.057     0.200
     6.694    42.674     0.200
     6.903    42.435     0.200
     2.285    14.529     0.200
     2.677    17.054     0.200
     2.980    18.512     0.200
     2.928    18.322     0.200
     3.396    20.966     0.200
     3.687    24.265     0.200
     3.687    22.765     0.200
     3.955    24.539     0.200
     4.390    27.965     0.200
     4.412    27.900     0.200
     4.871    29.754     0.200
     5.214    31.842     0.200
     5.297    32.873     0.200
     5.587    35.799     0.200
     2.267    14.227     0.200
     2.316    14.262     0.200
     2.961    19.729     0.200
     3.091    19.712     0.200
     3.748    23.250     0.200
     4.071    24.576     0.200
     4.817    29.674     0.200
     5.142    31.685     0.200
     5.888    35.772     0.200
     6.003    35.837     0.200
     2.221    13.864     0.200
     2.316    14.162     0.200
     2.476    15.098     0.200
     2.595    17.504     0.200
     2.686    16.642     0.200
     4.195    25.532     0.200
     4.195    27.434     0.200
     2.052    13.799     0.200
     2.217    13.974     0.200
     2.241    14.290     0.200
     2.375    15.023     0.200
     2.625    17.614     0.200
     2.625    16.317     0.200
     2.686    17.597     0.200
     2.686    17.198     0.200
     2.867    19.196     0.200
     2.867    18.196     0.200
     3.323    20.562     0.200
     3.320    21.097     0.200
     3.320    20.996     0.200
     3.617    22.842     0.200
     3.740    23.795     0.200
     3.740    23.998     0.200
     3.842    23.315     0.200
     3.842    24.213     0.200
     4.054    25.838     0.200
     4.368    27.763     0.200
     4.368    28.865     0.200
     4.659    28.866     0.200
     4.659    29.772     0.200
     4.750    31.415     0.200
     4.750    29.915     0.200
     5.132    33.949     0.200
     5.254    34.228     0.200
     5.415    34.850     0.200
     5.727    36.813     0.200
     5.823    37.432     0.200
     2.194    14.310     0.200
     2.449    15.534     0.200
     2.914    18.902     0.200
     2.923    18.601     0.200
     3.459    21.442     0.200
     3.511    22.636     0.200
     3.897    25.738     0.200
     4.178    26.452     0.200
     4.368    27.636     0.200
     4.432    28.089     0.200
     5.199    33.342     0.200
     5.707    35.309     0.200
     7.130    45.506     0.200
     7.306    46.456     0.200
     2.263    14.166     0.200
     2.263    14.564     0.200
     2.635    16.528     0.200
     2.704    17.221     0.200
     2.898    17.951     0.200
     2.898    18.154     0.200
     3.421    21.350     0.200
     3.712    23.656     0.200
     3.964    25.824     0.200
     4.162    25.509     0.200
     4.162    26.805     0.200
     4.331    26.729     0.200
     4.331    26.432     0.200
     4.467    27.551     0.200
     4.735    29.826     0.200
     4.738    30.078     0.200
     5.673    35.572     0.200
     8.520    52.198     0.200
     2.002    13.815     0.200
     2.127    14.366     0.200
     2.191    14.718     0.200
     2.424    15.497     0.200
     2.575    17.138     0.200
     2.640    16.282     0.200
     2.817    18.307     0.200
     2.817    18.007     0.200
     3.630    22.418     0.200
     3.630    23.719     0.200
     3.789    24.264     0.200
     3.797    23.673     0.200
     4.105    25.982     0.200
     4.317    28.900     0.200
     4.646    29.969     0.200
     5.304    33.687     0.200
     5.467    34.489     0.200
     7.058    43.916     0.200
     2.282    14.450     0.200
     2.419    15.555     0.200
     2.537    15.970     0.200
     2.855    17.967     0.200
     3.012    19.332     0.200
     3.385    21.468     0.200
     3.599    22.678     0.200
     3.981    25.717     0.200
     4.092    25.319     0.200
     4.341    26.415     0.200
     4.520    28.732     0.200
     5.000    32.228     0.200
     2.005    13.918     0.200
     2.129    14.378     0.200
     2.192    13.934     0.200
     2.192    14.434     0.200
     2.266    14.576     0.200
     2.576    17.364     0.200
     2.640    17.012     0.200
     2.818    18.035     0.200
     2.990    19.219     0.200
     2.990    19.118     0.200
     3.373    20.861     0.200
     3.633    23.718     0.200
     3.788    24.609     0.200
     3.788    24.305     0.200
     4.319    28.114     0.200
     4.650    28.357     0.200
     4.650    30.255     0.200
     4.706    32.005     0.200
     4.706    29.599     0.200
     5.303    34.035     0.200
     5.686    37.062     0.200
     6.440    40.967     0.200
     8.268    54.030     0.200
     2.018    13.246     0.200
     2.199    14.431     0.200
     2.644    16.642     0.200
     2.824    17.741     0.200
     3.278    20.347     0.200
     4.327    27.703     0.200
     4.663    29.479     0.200
     4.708    28.757     0.200
     2.020    12.863     0.200
     2.362    14.870     0.200
     2.465    15.465     0.200
     2.755    17.483     0.200
     2.870    18.439     0.200
     2.870    17.842     0.200
     2.935    18.086     0.200
     3.008    18.630     0.200
     3.008    19.130     0.200
     3.292    21.421     0.200
     3.292    20.421     0.200
     3.308    21.234     0.200
     3.478    21.949     0.200
     3.614    22.659     0.200
     3.614    22.460     0.200
     3.971    25.090     0.200
     4.043    25.153     0.200
     4.357    27.288     0.200
     4.960    30.556     0.200
     4.960    30.958     0.200
     5.144    32.005     0.200
     5.144    33.403     0.200
     5.403    33.583     0.200
     5.403    33.380     0.200
     5.391    32.728     0.200
     5.601    36.271     0.200
     5.720    35.544     0.200
     6.784    41.472     0.200
     8.087    52.356     0.200
     8.606    55.299     0.200
     2.039    13.513     0.200
     2.226    14.239     0.200
     2.851    18.445     0.200
     3.626    23.492     0.200
     3.626    21.992     0.200
     3.756    22.874     0.200
     4.353    27.710     0.200
     4.661    29.715     0.200
     4.734    29.665     0.200
     4.734    30.966     0.200
     5.270    33.305     0.200
     5.430    33.640     0.200
     5.812    36.069     0.200
     7.034    43.625     0.200
     2.019    13.441     0.200
     2.455    15.246     0.200
     2.528    16.493     0.200
     2.664    16.210     0.200
     2.701    16.771     0.200
     3.133    19.135     0.200
     3.232    19.885     0.200
     3.521    22.308     0.200
     3.954    24.654     0.200
     4.123    26.085     0.200
     4.406    27.287     0.200
     4.622    28.162     0.200
     2.071    13.303     0.200
     2.320    14.893     0.200
     2.779    17.142     0.200
     2.787    17.324     0.200
     2.787    17.551     0.200
     3.354    20.925     0.200
     3.517    22.025     0.200
     3.799    24.043     0.200
     4.289    26.512     0.200
     4.273    26.103     0.200
     4.530    28.514     0.200
     4.740    29.656     0.200
     5.309    34.957     0.200
     2.211    14.180     0.200
     2.321    14.786     0.200
     2.461    15.756     0.200
     2.644    16.722     0.200
     2.829    17.760     0.200
     2.929    18.299     0.200
     3.396    21.639     0.200
     3.497    21.968     0.200
     3.777    23.499     0.200
     3.933    24.880     0.200
     4.151    26.036     0.200
     4.415    28.158     0.200
     4.488    28.706     0.200
     5.385    33.733     0.200
     2.118    13.739     0.200
     2.334    14.527     0.200
     2.391    15.260     0.200
     2.779    17.224     0.200
     3.027    18.740     0.200
     3.417    21.186     0.200
     3.488    21.954     0.200
     4.028    25.758     0.200
     4.523    27.777     0.200
     4.506    28.374     0.200
     4.939    30.521     0.200
     5.336    33.485     0.200
     2.093    14.059     0.200
     2.237    14.575     0.200
     2.275    14.127     0.200
     2.631    16.680     0.200
     2.632    16.764     0.200
     2.889    18.274     0.200
     3.097    19.338     0.200
     3.281    20.489     0.200
     3.364    20.799     0.200
     3.364    21.424     0.200
     4.120    26.802     0.200
     4.255    26.428     0.200
     4.321    27.856     0.200
     4.868    31.075     0.200
     5.285    33.309     0.200
     5.329    33.489     0.200
     5.436    34.844     0.200
     5.554    33.218     0.200
     2.054    14.218     0.200
     2.209    13.907     0.200
     2.359    14.561     0.200
     2.604    16.700     0.200
     2.762    16.958     0.200
     2.999    19.094     0.200
     3.253    20.522     0.200
     3.726    23.310     0.200
     4.283    26.308     0.200
     4.295    27.259     0.200
     4.916    30.517     0.200
     2.341    15.144     0.200
     3.847    24.267     0.200
     4.310    26.469     0.200
     4.337    26.758     0.200
     2.255    14.323     0.200
     2.255    15.224     0.200
     2.512    16.331     0.200
     2.897    18.437     0.200
     2.988    18.774     0.200
     3.425    21.580     0.200
     3.582    23.247     0.200
     3.949    25.455     0.200
     4.313    27.009     0.200
     4.503    28.594     0.200
     4.992    32.084     0.200
     5.201    33.051     0.200
     2.218    14.072     0.200
     2.469    15.949     0.200
     2.636    16.798     0.200
     2.823    17.823     0.200
     2.937    18.891     0.200
     3.389    21.513     0.200
     3.504    22.265     0.200
     3.685    23.259     0.200
     3.940    25.079     0.200
     4.143    26.214     0.200
     4.422    27.753     0.200
     4.480    28.778     0.200
     4.881    29.693     0.200
     5.307    33.635     0.200
     2.227    14.568     0.200
     2.137    13.720     0.200
     2.272    14.347     0.200
     2.666    16.841     0.200
     2.794    17.758     0.200
     2.921    18.869     0.200
     3.394    20.621     0.200
     3.394    21.152     0.200
     3.710    23.564     0.200
     4.073    25.431     0.200
     3.970    25.328     0.200
     4.302    26.950     0.200
     4.363    27.647     0.200
     4.889    30.611     0.200
     5.242    32.891     0.200
     5.338    33.370     0.200
     5.497    35.012     0.200
     5.510    33.863     0.200
     5.614    33.304     0.200
     6.660    40.537     0.200
     6.851    42.813     0.200
     2.122    13.373     0.200
     2.150    13.746     0.200
     2.150    13.551     0.200
     2.354    15.465     0.200
     2.354    14.965     0.200
     2.740    17.569     0.200
     2.740    17.272     0.200
     2.795    18.216     0.200
     3.298    21.050     0.200
     3.889    24.262     0.200
     4.047    27.305     0.200
     4.268    26.127     0.200
     4.558    27.842     0.200
     4.859    30.729     0.200
     5.517    34.951     0.200
     2.303    15.120     0.200
     2.532    15.748     0.200
     2.698    17.418     0.200
     2.952    18.852     0.200
     3.003    18.450     0.200
     3.297    21.128     0.200
     3.423    21.653     0.200
     3.676    23.500     0.200
     3.995    25.274     0.200
     4.036    26.394     0.200
     4.323    26.751     0.200
     4.397    27.889     0.200
     4.913    31.267     0.200
     5.207    32.532     0.200
     5.355    34.105     0.200
     2.280    14.317     0.200
     2.536    15.624     0.200
     2.875    18.268     0.200
     3.012    19.372     0.200
     3.400    21.536     0.200
     3.974    25.838     0.200
     4.134    26.272     0.200
     4.314    26.674     0.200
     4.525    28.314     0.200
     5.011    31.340     0.200
     5.220    32.800     0.200
     2.171    13.272     0.200
     2.589    15.687     0.200
     2.563    15.785     0.200
     2.678    16.551     0.200
     2.816    17.142     0.200
     3.285    20.965     0.200
     3.423    21.048     0.200
     3.852    23.850     0.200
     4.273    26.834     0.200
     4.769    29.745     0.200
     5.210    32.995     0.200
     5.331    32.888     0.200
     5.488    34.956     0.200
     2.142    13.589     0.200
     2.266    14.241     0.200
     2.457    15.710     0.200
     3.495    21.697     0.200
     3.753    23.182     0.200
     4.127    25.517     0.200
     4.231    26.110     0.200
     4.477    27.640     0.200
     2.196    13.577     0.200
     2.451    15.097     0.200
     2.684    16.674     0.200
     2.920    18.028     0.200
     2.926    17.858     0.200
     3.462    21.395     0.200
     3.516    22.376     0.200
     3.896    24.728     0.200
     4.046    25.481     0.200
     4.358    27.050     0.200
     4.437    28.026     0.200
     4.924    31.737     0.200
     2.309    14.163     0.200
     2.309    14.366     0.200
     2.497    15.364     0.200
     2.546    15.797     0.200
     2.608    16.879     0.200
     2.721    17.857     0.200
     2.793    18.011     0.200
     3.010    19.083     0.200
     3.163    19.898     0.200
     3.163    20.195     0.200
     3.558    21.888     0.200
     3.678    22.583     0.200
     3.813    23.607     0.200
     4.289    26.458     0.200
     4.286    26.300     0.200
     4.753    28.247     0.200
     4.849    30.226     0.200
     5.242    32.542     0.200
     5.763    35.251     0.200
     5.990    35.605     0.200
     2.276    15.204     0.200
     2.456    15.514     0.200
     2.667    17.648     0.200
     2.764    17.917     0.200
     2.916    18.338     0.200
     3.381    20.915     0.200
     3.694    22.361     0.200
     3.932    24.384     0.200
     4.468    27.732     0.200
     4.468    28.729     0.200
     4.846    30.216     0.200
     5.219    31.866     0.200
     5.263    33.450     0.200
     2.516    15.780     0.200
     2.734    16.736     0.200
     2.979    18.787     0.200
     3.530    21.846     0.200
     4.090    25.812     0.200
     4.446    27.460     0.200
     4.557    29.068     0.200
     2.193    13.996     0.200
     2.193    13.797     0.200
     2.299    15.069     0.200
     2.299    14.768     0.200
     2.443    15.585     0.200
     2.443    15.386     0.200
     2.909    17.990     0.200
     2.909    18.248     0.200
     3.403    20.884     0.200
     3.721    24.465     0.200
     3.784    22.932     0.200
     3.920    25.253     0.200
     4.007    26.032     0.200
     4.167    25.767     0.200
     4.500    27.775     0.200
     4.510    27.762     0.200
     5.311    33.310     0.200
     8.334    55.379     0.200
     2.173    14.391     0.200
     2.270    14.359     0.200
     2.643    16.208     0.200
     2.665    18.057     0.200
     2.665    16.659     0.200
     2.881    17.933     0.200
     2.876    17.796     0.200
     3.267    20.732     0.200
     3.315    20.885     0.200
     3.315    21.069     0.200
     3.753    24.150     0.200
     3.753    22.750     0.200
     3.797    23.745     0.200
     3.797    24.146     0.200
     3.801    24.101     0.200
     4.037    26.039     0.200
     4.340    27.009     0.200
     4.406    28.039     0.200
     4.699    28.714     0.200
     4.869    31.229     0.200
     5.253    32.656     0.200
     5.038    31.055     0.200
     5.350    33.013     0.200
     5.350    33.613     0.200
     2.434    15.145     0.200
     2.898    18.598     0.200
     2.898    18.229     0.200
     3.399    20.692     0.200
     3.457    22.311     0.200
     3.751    23.375     0.200
     3.917    24.838     0.200
     3.991    24.773     0.200
     4.173    25.949     0.200
     4.374    27.012     0.200
     4.543    28.531     0.200
     4.823    29.964     0.200
     5.332    33.732     0.200
     5.411    32.951     0.200
     2.106    13.707     0.200
     2.383    15.273     0.200
     2.772    17.532     0.200
     2.860    18.510     0.200
     3.020    19.140     0.200
     3.482    22.146     0.200
     3.588    22.015     0.200
     4.024    25.123     0.200
     4.497    28.299     0.200
     4.510    28.654     0.200
     4.936    30.482     0.200
     5.110    31.443     0.200
     5.336    33.407     0.200
     2.120    13.955     0.200
     2.300    14.943     0.200
     2.397    15.316     0.200
     2.786    18.378     0.200
     2.873    19.172     0.200
     2.873    18.070     0.200
     3.034    19.292     0.200
     3.216    19.964     0.200
     3.406    21.451     0.200
     3.406    21.248     0.200
     3.574    22.084     0.200
     3.495    21.396     0.200
     3.495    21.997     0.200
     3.909    26.971     0.200
     4.036    25.287     0.200
     4.514    28.017     0.200
     4.512    29.046     0.200
     4.948    31.953     0.200
     5.096    32.916     0.200
     5.347    34.199     0.200
     5.736    36.254     0.200
     6.809    41.924     0.200
     2.061    13.310     0.200
     2.451    16.061     0.200
     2.700    17.552     0.200
     3.161    19.574     0.200
     3.165    20.430     0.200
     3.720    24.251     0.200
     3.909    24.340     0.200
     4.175    27.440     0.200
     2.006    13.097     0.200
     2.110    13.472     0.200
     2.602    16.337     0.200
     2.502    15.710     0.200
     2.608    16.974     0.200
     2.752    18.083     0.200
     3.130    19.173     0.200
     3.219    19.783     0.200
     3.219    20.236     0.200
     3.501    21.945     0.200
     3.860    24.456     0.200
     3.780    23.694     0.200
     5.586    34.355     0.200
     2.502    15.395     0.200
     2.649    17.272     0.200
     2.793    17.292     0.200
     3.125    18.967     0.200
     3.125    20.022     0.200
     3.301    20.763     0.200
     3.447    21.760     0.200
     3.987    25.063     0.200
     5.392    34.121     0.200
     2.211    13.693     0.200
     2.323    14.082     0.200
     2.462    14.968     0.200
     2.645    16.025     0.200
     2.930    18.205     0.200
     3.399    20.524     0.200
     3.399    21.321     0.200
     3.499    21.359     0.200
     3.499    22.156     0.200
     3.683    22.213     0.200
     4.151    25.548     0.200
     4.473    28.298     0.200
     5.379    34.022     0.200
     7.027    43.784     0.200
     8.295    53.089     0.200
     2.037    12.725     0.200
     2.218    14.001     0.200
     2.375    15.076     0.200
     2.510    16.495     0.200
     2.045    13.041     0.200
     2.200    14.236     0.200
     2.580    15.897     0.200
     2.820    17.604     0.200
     3.791    22.775     0.200
     5.828    36.435     0.200
     8.332    51.676     0.200
     2.205    14.019     0.200
     2.322    15.251     0.200
     2.457    15.582     0.200
     2.654    16.977     0.200
     2.851    17.682     0.200
     2.926    18.706     0.200
     3.413    20.822     0.200
     3.499    22.219     0.200
     3.922    25.375     0.200
     5.360    34.764     0.200
     8.282    51.851     0.200
     2.227    13.820     0.200
     2.620    17.040     0.200
     2.871    17.706     0.200
     2.199    14.110     0.200
     2.320    15.509     0.200
     2.452    15.968     0.200
     2.662    16.912     0.200
     2.863    17.769     0.200
     2.922    18.482     0.200
     3.422    21.435     0.200
     3.497    22.364     0.200
     3.666    22.892     0.200
     3.915    25.589     0.200
     4.165    26.676     0.200
     4.442    27.541     0.200
     5.347    35.133     0.200
     2.602    16.519     0.200
     2.852    17.501     0.200
     3.036    18.860     0.200
     3.760    22.905     0.200
     2.289    14.744     0.200
     2.432    16.172     0.200
     2.545    16.455     0.200
     2.871    18.158     0.200
     3.021    18.479     0.200
     3.021    19.299     0.200
     3.394    21.451     0.200
     3.518    22.201     0.200
     3.614    23.487     0.200
     4.309    27.475     0.200
     5.320    34.277     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.984     7.037     0.200
     1.695    11.645     0.200
     1.823    11.354     0.200
     3.621    21.372     0.200
     1.949    11.473     0.200
     3.245    17.347     0.200
     0.358     3.792     0.200
     0.826     5.320     0.200
     2.787    15.438     0.200
     4.184    23.635     0.200
     0.240     2.985     0.200
     1.281     7.331     0.200
     2.391    13.278     0.200
     2.507    13.631     0.200
     2.504    14.558     0.200
     3.662    21.553     0.200
     3.744    21.796     0.200
     0.258     2.664     0.200
     1.359     8.815     0.200
     1.654     9.366     0.200
     2.207    13.020     0.200
     2.368    13.744     0.200
     2.597    14.767     0.200
     2.657    14.671     0.200
     3.031    17.295     0.200
     4.044    23.086     0.200
     0.264     3.647     0.200
     0.997     6.180     0.200
     1.436     8.364     0.200
     2.557    14.781     0.200
     2.976    17.390     0.200
     3.254    17.852     0.200
     3.846    22.236     0.200
     0.327     3.333     0.200
     0.914     6.286     0.200
     1.506     8.477     0.200
     2.261    13.260     0.200
     2.641    15.133     0.200
     3.338    19.291     0.200
     3.421    20.025     0.200
     3.881    22.357     0.200
     0.282     3.768     0.200
     0.956     6.402     0.200
     1.429     9.179     0.200
     0.314     2.728     0.200
     0.916     5.903     0.200
     1.510     8.964     0.200
     2.713    16.226     0.200
     1.407     9.556     0.200
     2.658    15.652     0.200
     2.658    15.953     0.200
     3.391    19.402     0.200
     3.670    21.142     0.200
     4.117    24.038     0.200
     4.264    25.221     0.200
     0.355     2.923     0.200
     0.995     6.648     0.200
     1.401     8.609     0.200
     1.413     9.975     0.200
     2.696    16.003     0.200
     0.236     2.163     0.200
     0.569     4.571     0.200
     1.043     6.346     0.200
     1.331     8.681     0.200
     2.282    13.883     0.200
     2.570    14.517     0.200
     3.071    18.172     0.200
     3.413    19.179     0.200
     0.146     1.897     0.200
     0.649     5.428     0.200
     0.966     6.433     0.200
     1.407     9.185     0.200
     1.916    12.245     0.200
     2.230    13.278     0.200
     2.562    15.602     0.200
     3.038    18.049     0.200
     3.326    19.194     0.200
     0.331     3.063     0.200
     1.021     7.214     0.200
     1.383     8.991     0.200
     1.443     9.678     0.200
     1.464     9.342     0.200
     1.770    12.566     0.200
     2.377    14.185     0.200
     2.665    14.920     0.200
     2.665    15.123     0.200
     3.540    21.006     0.200
     4.058    24.364     0.200
     0.260     2.142     0.200
     0.589     4.505     0.200
     1.282     8.808     0.200
     1.434     9.544     0.200
     1.818    11.857     0.200
     2.345    14.009     0.200
     2.532    15.626     0.200
     2.653    16.310     0.200
     3.837    22.492     0.200
     0.224     2.461     0.200
     0.934     5.077     0.200
     0.951     6.580     0.200
     1.377     9.107     0.200
     1.528     9.354     0.200
     2.296    13.080     0.200
     2.768    16.173     0.200
     4.073    23.852     0.200
     0.206     1.897     0.200
     0.767     5.849     0.200
     0.997     7.371     0.200
     0.999     7.354     0.200
     1.045     7.215     0.200
     1.033     7.345     0.200
     1.034     7.345     0.200
     1.358     9.867     0.200
     1.509    10.503     0.200
     1.509    11.300     0.200
     1.614    11.473     0.200
     1.766    11.795     0.200
     2.360    14.563     0.200
     3.262    19.646     0.200
     0.352     2.311     0.200
     0.471     3.716     0.200
     0.984     6.231     0.200
     1.375     8.668     0.200
     1.375     9.469     0.200
     1.437     9.145     0.200
     2.127    12.991     0.200
     2.353    14.563     0.200
     2.793    16.819     0.200
     3.954    23.676     0.200
     4.864    28.954     0.200
     4.864    28.454     0.200
     0.296     1.704     0.200
     0.560     4.221     0.200
     1.123     7.256     0.200
     1.123     7.655     0.200
     1.250     8.378     0.200
     1.575    10.684     0.200
     1.804    11.206     0.200
     2.368    14.520     0.200
     3.155    19.345     0.200
     3.864    23.366     0.200
     0.118     1.782     0.200
     0.669     5.350     0.200
     0.906     5.387     0.200
     1.166     8.255     0.200
     1.247     7.910     0.200
     1.467     9.240     0.200
     1.741    11.847     0.200
     1.782    12.463     0.200
     1.976    12.296     0.200
     2.167    12.867     0.200
     0.258     1.940     0.200
     0.548     4.956     0.200
     1.060     7.377     0.200
     1.060     7.077     0.200
     1.038     8.035     0.200
     1.162     8.391     0.200
     1.314     8.914     0.200
     1.314     8.812     0.200
     1.582    10.386     0.200
     1.621    11.531     0.200
     1.621    10.934     0.200
     1.650    10.387     0.200
     1.650    11.591     0.200
     1.882    12.088     0.200
     2.292    13.897     0.200
     2.569    15.664     0.200
     3.077    18.448     0.200
     3.293    20.018     0.200
     3.436    20.854     0.200
     3.791    22.113     0.200
     3.791    22.012     0.200
     0.215     2.010     0.200
     0.982     6.158     0.200
     1.121     8.732     0.200
     1.236     8.491     0.200
     1.395     9.541     0.200
     1.664    10.895     0.200
     1.734    12.781     0.200
     1.960    12.651     0.200
     2.209    13.043     0.200
     2.657    15.515     0.200
     3.395    19.899     0.200
     3.707    21.957     0.200
     0.235     2.885     0.200
     0.630     4.076     0.200
     0.872     6.251     0.200
     1.429     9.147     0.200
     1.469     8.780     0.200
     1.743    10.484     0.200
     1.920    10.921     0.200
     1.949    12.878     0.200
     2.203    13.117     0.200
     0.247     2.535     0.200
     0.920     5.475     0.200
     0.985     6.824     0.200
     1.105     7.417     0.200
     1.557     9.247     0.200
     1.624    11.062     0.200
     1.835    11.707     0.200
     1.835    12.004     0.200
     2.289    12.998     0.200
     3.028    17.073     0.200
     3.167    18.156     0.200
     0.094     3.665     0.200
     0.698     5.421     0.200
     0.923     5.593     0.200
     1.135     7.820     0.200
     1.203     8.024     0.200
     1.452     9.125     0.200
     1.452     8.326     0.200
     1.662    10.765     0.200
     1.934    11.895     0.200
     2.203    12.559     0.200
     2.203    12.259     0.200
     2.561    14.879     0.200
     2.561    15.079     0.200
     3.022    17.502     0.200
     3.022    17.603     0.200
     3.274    18.753     0.200
     3.683    21.580     0.200
     0.212     2.843     0.200
     0.918     5.408     0.200
     0.949     6.250     0.200
     1.110     6.863     0.200
     1.143     7.685     0.200
     1.539     9.565     0.200
     1.842    11.030     0.200
     2.280    13.019     0.200
     2.753    15.998     0.200
     3.151    18.552     0.200
     4.025    23.354     0.200
     0.328     2.429     0.200
     1.182     7.460     0.200
     1.700     9.915     0.200
     1.701    10.505     0.200
     2.058    12.343     0.200
     2.212    13.039     0.200
     2.315    13.645     0.200
     2.430    14.397     0.200
     2.608    15.621     0.200
     2.828    16.054     0.200
     3.124    18.404     0.200
     0.206     1.759     0.200
     0.598     4.893     0.200
     1.020     5.865     0.200
     1.353     8.780     0.200
     1.353     9.081     0.200
     1.640    10.829     0.200
     1.640    11.227     0.200
     1.890    12.312     0.200
     2.269    13.083     0.200
     2.269    13.884     0.200
     2.573    15.441     0.200
     2.573    15.242     0.200
     2.606    15.355     0.200
     3.065    18.196     0.200
     3.065    17.997     0.200
     0.259     3.319     0.200
     0.648     4.783     0.200
     1.025     6.281     0.200
     1.163     7.171     0.200
     1.407     8.028     0.200
     1.463    10.171     0.200
     1.482    10.545     0.200
     1.821    11.091     0.200
     3.004    17.282     0.200
     3.229    19.257     0.200
     0.302     2.906     0.200
     0.533     4.714     0.200
     0.929     5.788     0.200
     1.243     8.926     0.200
     1.379     9.336     0.200
     1.479     9.574     0.200
     1.793    11.108     0.200
     2.095    12.381     0.200
     3.605    20.154     0.200
     0.245     1.670     0.200
     0.245     2.170     0.200
     0.641     4.954     0.200
     1.308     8.572     0.200
     1.308     8.471     0.200
     1.642     9.273     0.200
     1.642     9.672     0.200
     1.785    11.104     0.200
     1.820    11.704     0.200
     2.175    12.957     0.200
     2.307    14.019     0.200
     2.327    14.082     0.200
     2.510    15.045     0.200
     2.574    15.095     0.200
     2.715    15.257     0.200
     2.715    15.452     0.200
     0.347     2.160     0.200
     0.347     2.660     0.200
     0.503     4.136     0.200
     0.503     4.737     0.200
     1.687     9.723     0.200
     1.695    10.927     0.200
     2.034    11.771     0.200
     2.308    13.477     0.200
     2.417    14.600     0.200
     2.612    15.630     0.200
     2.855    14.687     0.200
     3.405    20.070     0.200
     0.108     2.857     0.200
     0.108     2.056     0.200
     0.807     5.499     0.200
     1.440     8.821     0.200
     1.440     8.719     0.200
     1.492     9.006     0.200
     1.492     8.205     0.200
     1.954    12.212     0.200
     2.246    13.510     0.200
     2.246    13.307     0.200
     2.443    14.418     0.200
     2.643    14.480     0.200
     2.643    14.781     0.200
     3.569    20.571     0.200
     3.711    22.010     0.200
     0.328     2.774     0.200
     0.456     3.480     0.200
     0.620     5.174     0.200
     0.761     6.220     0.200
     0.895     6.258     0.200
     1.079     7.713     0.200
     1.079     7.612     0.200
     1.303     8.204     0.200
     1.303     8.503     0.200
     1.303     9.299     0.200
     1.607    10.548     0.200
     2.569    14.828     0.200
     2.569    15.828     0.200
     4.060    24.523     0.200
     0.226     3.427     0.200
     0.643     4.056     0.200
     0.938     7.019     0.200
     1.059     7.112     0.200
     1.201     7.644     0.200
     1.386     8.089     0.200
     1.498     9.884     0.200
     1.522    10.102     0.200
     2.496    14.241     0.200
     3.554    20.892     0.200
     0.311     3.082     0.200
     0.540     4.506     0.200
     0.914     5.947     0.200
     1.265     9.250     0.200
     1.499     9.422     0.200
     1.499     9.821     0.200
     1.852    13.198     0.200
     2.073    12.722     0.200
     2.073    12.417     0.200
     2.332    14.391     0.200
     2.840    17.373     0.200
     2.858    17.162     0.200
     3.483    20.067     0.200
     0.751     4.940     0.200
     0.751     5.140     0.200
     0.752     5.819     0.200
     0.798     5.585     0.200
     1.624    10.246     0.200
     1.624    11.046     0.200
     1.900    12.226     0.200
     1.900    13.826     0.200
     1.944    12.219     0.200
     1.944    14.219     0.200
     2.831    17.361     0.200
     2.879    17.401     0.200
     3.213    18.700     0.200
     3.492    21.147     0.200
     0.171     1.779     0.200
     0.739     5.655     0.200
     0.761     4.794     0.200
     0.761     4.896     0.200
     0.795     5.393     0.200
     1.392     9.125     0.200
     1.614    10.237     0.200
     1.614    10.136     0.200
     1.852    12.761     0.200
     1.895    13.165     0.200
     2.013    12.683     0.200
     2.013    12.285     0.200
     2.389    14.497     0.200
     2.833    17.317     0.200
     3.227    19.619     0.200
     4.155    24.882     0.200
     0.072     2.766     0.200
     0.814     6.000     0.200
     1.371     8.702     0.200
     1.396     8.116     0.200
     1.440     8.896     0.200
     2.009    12.151     0.200
     2.094    12.669     0.200
     2.322    13.509     0.200
     2.322    13.407     0.200
     2.331    14.103     0.200
     2.739    15.838     0.200
     2.779    14.566     0.200
     2.779    16.468     0.200
     2.817    16.727     0.200
     3.218    19.252     0.200
     3.579    19.928     0.200
     0.338     2.938     0.200
     0.824     5.860     0.200
     0.928     5.750     0.200
     1.414     9.673     0.200
     1.495     9.634     0.200
     1.823    12.410     0.200
     1.859    12.693     0.200
     1.859    12.389     0.200
     2.072    12.397     0.200
     2.072    12.897     0.200
     3.205    19.079     0.200
     3.455    20.657     0.200
     3.479    20.789     0.200
     3.586    21.327     0.200
     4.012    23.562     0.200
     0.208     2.559     0.200
     0.581     4.907     0.200
     0.669     5.073     0.200
     0.955     6.342     0.200
     0.955     6.139     0.200
     1.265     8.625     0.200
     1.424     8.967     0.200
     1.695     9.505     0.200
     1.734    10.846     0.200
     1.734    11.447     0.200
     1.989    12.976     0.200
     2.178    12.863     0.200
     2.474    14.905     0.200
     2.967    17.454     0.200
     3.382    19.711     0.200
     0.151     1.564     0.200
     0.648     4.965     0.200
     0.974     6.065     0.200
     1.179     7.867     0.200
     1.399     8.799     0.200
     1.399     8.901     0.200
     1.627    10.945     0.200
     1.669    11.553     0.200
     1.710    11.776     0.200
     1.710    13.073     0.200
     2.239    13.198     0.200
     2.239    13.299     0.200
     2.570    14.936     0.200
     3.047    18.174     0.200
     3.047    17.674     0.200
     3.329    19.978     0.200
     0.130     1.997     0.200
     0.656     5.147     0.200
     0.925     5.312     0.200
     0.925     5.613     0.200
     1.148     8.216     0.200
     1.232     8.428     0.200
     1.448     9.017     0.200
     1.558    10.025     0.200
     2.185    12.415     0.200
     2.522    15.179     0.200
     2.522    15.281     0.200
     2.699    15.715     0.200
     3.310    18.277     0.200
     3.993    23.517     0.200
     0.289     2.856     0.200
     0.467     3.183     0.200
     0.657     5.058     0.200
     0.740     5.397     0.200
     1.075     7.487     0.200
     1.277     8.531     0.200
     1.314     8.091     0.200
     1.317     9.259     0.200
     2.300    13.982     0.200
     2.592    14.884     0.200
     2.867    17.174     0.200
     3.510    18.871     0.200
     3.625    21.626     0.200
     3.994    23.321     0.200
     4.079    22.327     0.200
     5.856    33.284     0.200
     0.153     1.389     0.200
     0.586     4.443     0.200
     0.644     4.866     0.200
     0.973     6.124     0.200
     0.973     6.323     0.200
     1.096     7.588     0.200
     1.400     8.941     0.200
     1.512     9.737     0.200
     1.672    11.171     0.200
     1.672    11.472     0.200
     1.712    12.097     0.200
     1.911    12.272     0.200
     2.236    13.180     0.200
     2.565    14.942     0.200
     3.043    17.766     0.200
     3.332    19.389     0.200
     5.512    32.354     0.200
     0.176     1.961     0.200
     0.889     6.336     0.200
     1.097     7.211     0.200
     1.108     8.384     0.200
     1.392     8.969     0.200
     1.392    10.070     0.200
     1.491     9.807     0.200
     1.599    10.448     0.200
     1.649    11.276     0.200
     1.720    12.439     0.200
     1.830    11.750     0.200
     2.289    13.500     0.200
     2.733    16.125     0.200
     2.856    15.982     0.200
     0.294     2.642     0.200
     0.468     3.208     0.200
     0.652     5.268     0.200
     0.740     5.640     0.200
     0.863     5.701     0.200
     1.072     7.660     0.200
     1.072     7.464     0.200
     1.211     7.936     0.200
     1.211     8.842     0.200
     1.278     8.567     0.200
     1.316     8.019     0.200
     1.577     9.763     0.200
     3.622    21.501     0.200
     0.320     3.265     0.200
     0.466     3.362     0.200
     1.172     7.122     0.200
     1.257     8.036     0.200
     1.257     8.836     0.200
     1.633    10.445     0.200
     1.636    10.312     0.200
     1.636    10.513     0.200
     2.457    14.330     0.200
     2.457    14.430     0.200
     3.239    19.303     0.200
     4.675    27.244     0.200
     4.675    27.844     0.200
     5.499    32.429     0.200
     0.161     1.706     0.200
     0.636     5.258     0.200
     0.586     4.648     0.200
     0.978     6.465     0.200
     1.093     7.829     0.200
     1.394     9.312     0.200
     1.394     9.109     0.200
     1.513    10.129     0.200
     1.628    10.285     0.200
     2.239    13.758     0.200
     2.239    13.555     0.200
     3.043    18.264     0.200
     3.043    18.568     0.200
     3.727    21.287     0.200
     3.727    21.990     0.200
     0.157     1.689     0.200
     0.575     4.109     0.200
     0.645     5.099     0.200
     0.981     6.172     0.200
     0.981     6.273     0.200
     1.086     8.348     0.200
     1.392     9.281     0.200
     1.501    10.004     0.200
     1.620    11.022     0.200
     2.246    13.307     0.200
     2.763    16.181     0.200
     3.733    22.159     0.200
     0.168     1.422     0.200
     0.631     5.024     0.200
     0.986     6.076     0.200
     0.986     6.178     0.200
     1.087     8.200     0.200
     1.387     9.092     0.200
     1.509     9.867     0.200
     1.622    11.047     0.200
     2.245    13.282     0.200
     3.048    18.309     0.200
     3.417    20.410     0.200
     0.164     1.653     0.200
     0.577     4.633     0.200
     0.637     5.032     0.200
     0.985     6.271     0.200
     0.985     6.373     0.200
     1.085     7.901     0.200
     1.388     8.865     0.200
     1.388     8.966     0.200
     1.504    10.012     0.200
     1.619    11.071     0.200
     2.247    13.441     0.200
     2.247    13.543     0.200
     2.759    16.367     0.200
     3.052    18.044     0.200
     3.052    18.646     0.200
     3.341    19.979     0.200
     3.362    20.030     0.200
     3.420    20.648     0.200
     3.735    21.077     0.200
     3.735    21.882     0.200
     0.148     1.290     0.200
     0.588     4.554     0.200
     0.648     5.258     0.200
     0.968     5.825     0.200
     1.100     7.876     0.200
     1.186     8.078     0.200
     1.405     9.224     0.200
     1.405     9.122     0.200
     1.514     9.952     0.200
     1.514    10.952     0.200
     1.634    10.356     0.200
     1.634    11.356     0.200
     1.915    12.376     0.200
     2.232    13.572     0.200
     2.232    13.271     0.200
     2.654    16.252     0.200
     3.951    23.808     0.200
     5.509    31.733     0.200
     0.143     1.413     0.200
     0.593     4.559     0.200
     0.652     5.279     0.200
     0.962     5.959     0.200
     1.106     8.470     0.200
     1.191     7.982     0.200
     1.191     9.182     0.200
     1.411     9.411     0.200
     1.518     9.962     0.200
     1.518    10.862     0.200
     1.639    11.449     0.200
     1.920    12.280     0.200
     2.226    13.200     0.200
     0.164     1.250     0.200
     0.573     4.385     0.200
     0.638     4.718     0.200
     0.638     5.018     0.200
     0.638     5.718     0.200
     0.988     5.942     0.200
     1.081     7.951     0.200
     1.081     9.050     0.200
     1.170     7.912     0.200
     1.170     8.712     0.200
     1.385     9.202     0.200
     1.385     9.402     0.200
     1.500     9.968     0.200
     1.615    10.317     0.200
     1.615    11.417     0.200
     1.898    12.620     0.200
     2.251    13.302     0.200
     2.576    15.503     0.200
     3.056    18.600     0.200
     3.359    19.868     0.200
     4.850    26.972     0.200
     0.155     1.405     0.200
     0.578     4.277     0.200
     0.645     4.987     0.200
     1.394     8.946     0.200
     1.394     9.048     0.200
     1.504    10.072     0.200
     1.622    10.286     0.200
     1.622    11.388     0.200
     1.664    11.399     0.200
     1.664    11.797     0.200
     1.904    12.606     0.200
     2.244    13.438     0.200
     2.573    14.792     0.200
     3.051    18.518     0.200
     3.333    18.129     0.200
     0.170     0.705     0.200
     0.637     4.753     0.200
     1.889    12.052     0.200
     1.889    12.353     0.200
     2.585    15.830     0.200
     2.625    15.764     0.200
     0.163     1.511     0.200
     0.637     4.975     0.200
     0.984     6.234     0.200
     1.389     8.800     0.200
     1.505     9.946     0.200
     1.621    10.996     0.200
     1.904    12.196     0.200
     2.245    13.409     0.200
     0.152     1.420     0.200
     0.613     4.540     0.200
     0.637     4.864     0.200
     0.955     5.944     0.200
     1.120     8.024     0.200
     1.417     9.252     0.200
     1.539    10.129     0.200
     1.655    11.077     0.200
     1.736    12.639     0.200
     2.211    13.189     0.200
     4.350    25.730     0.200
     0.156     1.567     0.200
     0.595     4.436     0.200
     0.638     5.141     0.200
     0.969     5.775     0.200
     0.969     6.075     0.200
     1.103     7.810     0.200
     1.404     8.903     0.200
     1.522    10.024     0.200
     1.638    11.270     0.200
     1.921    12.170     0.200
     2.228    13.278     0.200
     3.034    17.882     0.200
     3.034    18.282     0.200
     3.336    19.951     0.200
     5.247    30.550     0.200
     0.241     2.011     0.200
     0.241     2.112     0.200
     0.630     5.079     0.200
     1.287     8.511     0.200
     1.635     9.349     0.200
     1.813    11.274     0.200
     1.813    12.376     0.200
     2.307    13.905     0.200
     2.511    15.027     0.200
     2.562    14.532     0.200
     4.712    25.748     0.200
     0.124     2.880     0.200
     0.801     4.872     0.200
     0.801     4.974     0.200
     0.909     6.411     0.200
     1.243     8.418     0.200
     1.610     9.940     0.200
     1.740    10.716     0.200
     1.789    11.444     0.200
     1.789    11.944     0.200
     1.972    11.813     0.200
     2.147    12.162     0.200
     2.616    15.200     0.200
     2.823    16.987     0.200
     0.167     1.456     0.200
     0.633     5.017     0.200
     0.986     6.097     0.200
     1.086     7.932     0.200
     1.086     9.033     0.200
     1.387     8.915     0.200
     1.387     9.915     0.200
     1.507     9.819     0.200
     1.507    10.819     0.200
     1.621    10.990     0.200
     1.662    11.403     0.200
     1.662    11.103     0.200
     1.904    12.180     0.200
     2.246    13.493     0.200
     3.050    18.206     0.200
     3.050    18.405     0.200
     3.362    20.372     0.200
     3.418    20.710     0.200
     3.933    23.601     0.200
     0.334     2.596     0.200
     0.482     3.973     0.200
     0.982     6.038     0.200
     1.208     9.393     0.200
     1.702    11.335     0.200
     1.761    10.941     0.200
     1.797    11.527     0.200
     2.136    13.071     0.200
     2.136    13.271     0.200
     2.369    13.545     0.200
     2.369    13.345     0.200
     2.893    17.537     0.200
     0.344     3.399     0.200
     0.858     5.800     0.200
     0.827     6.062     0.200
     1.340     8.177     0.200
     1.356     8.994     0.200
     1.492     8.808     0.200
     2.154    12.277     0.200
     2.734    15.504     0.200
     2.760    16.405     0.200
     2.796    16.193     0.200
     2.796    16.493     0.200
     3.405    19.881     0.200
     3.405    19.478     0.200
     4.016    22.251     0.200
     4.214    24.834     0.200
     0.332     2.996     0.200
     0.641     4.282     0.200
     0.978     6.651     0.200
     1.388     9.568     0.200
     1.427     9.012     0.200
     1.452     9.829     0.200
     2.578    15.282     0.200
     0.151     1.596     0.200
     0.646     5.015     0.200
     0.646     5.117     0.200
     0.971     6.529     0.200
     0.971     6.228     0.200
     1.402     8.891     0.200
     1.402    10.091     0.200
     1.513    10.003     0.200
     1.632    10.814     0.200
     1.674    11.426     0.200
     1.674    11.625     0.200
     2.234    13.383     0.200
     2.565    15.529     0.200
     2.651    16.020     0.200
     3.041    18.264     0.200
     3.041    18.463     0.200
     3.330    19.498     0.200
     3.721    21.728     0.200
     3.949    23.273     0.200
     4.867    28.965     0.200
     0.150     1.639     0.200
     0.650     5.097     0.200
     0.974     6.018     0.200
     1.092     8.240     0.200
     1.399     8.965     0.200
     1.399     9.660     0.200
     1.504    10.029     0.200
     1.625    11.327     0.200
     2.241    13.333     0.200
     0.157     2.156     0.200
     0.645     5.456     0.200
     0.982     5.731     0.200
     1.086     7.918     0.200
     1.392     8.848     0.200
     1.501     9.677     0.200
     1.619    10.496     0.200
     1.661    11.106     0.200
     2.639    15.789     0.200
     0.308     3.026     0.200
     0.609     5.011     0.200
     0.835     5.381     0.200
     1.337     9.324     0.200
     1.579     9.797     0.200
     1.579    10.097     0.200
     1.790    11.330     0.200
     1.884    11.940     0.200
     1.922    12.996     0.200
     1.997    11.814     0.200
     2.775    16.639     0.200
     3.374    19.747     0.200
     3.563    21.046     0.200
     0.164     1.471     0.200
     0.634     4.980     0.200
     0.982     6.222     0.200
     1.090     7.868     0.200
     1.391     8.852     0.200
     1.510     9.963     0.200
     1.666    11.040     0.200
     2.242    13.423     0.200
     2.242    13.322     0.200
     2.566    15.542     0.200
     2.762    16.551     0.200
     3.046    18.034     0.200
     3.046    18.534     0.200
     3.342    20.173     0.200
     3.415    20.434     0.200
     3.937    23.539     0.200
     4.855    28.830     0.200
     4.855    28.931     0.200
     0.163     1.473     0.200
     0.637     5.039     0.200
     0.984     6.089     0.200
     0.984     6.191     0.200
     1.086     7.698     0.200
     1.389     8.960     0.200
     1.505    10.006     0.200
     1.662    11.773     0.200
     1.662    11.476     0.200
     2.246    13.363     0.200
     3.051    17.966     0.200
     3.051    18.466     0.200
     3.341    19.390     0.200
     3.363    19.820     0.200
     3.419    19.475     0.200
     3.734    21.202     0.200
     3.734    21.303     0.200
     3.935    23.643     0.200
     0.137     2.340     0.200
     0.782     5.919     0.200
     1.313     8.417     0.200
     1.402     8.176     0.200
     1.402     8.074     0.200
     2.059    11.712     0.200
     2.059    11.814     0.200
     2.313    13.352     0.200
     2.269    13.662     0.200
     2.288    13.439     0.200
     2.842    16.970     0.200
     2.842    17.072     0.200
     3.233    19.318     0.200
     4.336    25.545     0.200
     0.168     1.463     0.200
     0.633     4.937     0.200
     0.988     6.099     0.200
     1.084     7.979     0.200
     1.385     8.857     0.200
     1.385     9.959     0.200
     1.505    10.064     0.200
     1.660    11.447     0.200
     1.660    11.650     0.200
     2.248    13.188     0.200
     2.571    15.524     0.200
     2.756    16.759     0.200
     3.052    18.600     0.200
     3.346    20.082     0.200
     3.737    22.418     0.200
     0.166     1.618     0.200
     0.631     5.392     0.200
     0.983     6.289     0.200
     0.983     6.391     0.200
     1.090     7.941     0.200
     1.390     9.239     0.200
     1.390     9.137     0.200
     1.390    10.438     0.200
     1.667    12.210     0.200
     1.909    12.681     0.200
     2.241    13.701     0.200
     3.045    17.923     0.200
     0.200     1.742     0.200
     0.586     4.828     0.200
     0.966     6.101     0.200
     1.133     8.251     0.200
     1.133     9.552     0.200
     1.410     9.118     0.200
     1.410     9.017     0.200
     1.714    11.967     0.200
     1.967    13.316     0.200
     2.197    13.238     0.200
     2.671    15.906     0.200
     2.779    16.947     0.200
     2.988    18.297     0.200
     3.379    20.443     0.200
     3.390    20.514     0.200
     5.460    31.959     0.200
     0.187     1.693     0.200
     0.600     4.671     0.200
     0.950     5.889     0.200
     1.146     8.301     0.200
     1.146     9.106     0.200
     1.426     8.839     0.200
     1.426    10.034     0.200
     1.726    12.425     0.200
     1.977    12.910     0.200
     2.491    15.102     0.200
     3.364    20.308     0.200
     0.211     1.381     0.200
     0.576     4.719     0.200
     0.976     5.754     0.200
     1.127     7.984     0.200
     1.127     9.284     0.200
     1.401     8.984     0.200
     1.709    11.991     0.200
     1.964    12.914     0.200
     2.203    13.532     0.200
     2.663    16.060     0.200
     3.382    20.475     0.200
     3.382    20.175     0.200
     0.191     1.990     0.200
     0.595     4.868     0.200
     0.595     4.768     0.200
     0.965     6.152     0.200
     1.129     8.447     0.200
     1.129     9.647     0.200
     1.410     9.166     0.200
     1.410    10.566     0.200
     1.709    12.072     0.200
     1.960    13.345     0.200
     2.201    13.428     0.200
     2.506    15.573     0.200
     2.779    17.089     0.200
     4.867    27.919     0.200
     0.199     1.673     0.200
     0.588     4.529     0.200
     0.588     4.427     0.200
     0.960     5.888     0.200
     0.960     5.990     0.200
     1.417     8.960     0.200
     1.417    10.256     0.200
     1.722    11.999     0.200
     1.974    12.952     0.200
     2.190    13.236     0.200
     2.190    12.939     0.200
     2.678    15.943     0.200
     2.981    17.900     0.200
     2.981    18.200     0.200
     3.397    20.451     0.200
     3.397    20.552     0.200
     3.957    23.718     0.200
     4.872    27.732     0.200
     4.872    28.033     0.200
     5.452    32.363     0.200
     0.195     1.943     0.200
     0.591     4.823     0.200
     0.964     5.869     0.200
     1.133     7.904     0.200
     1.411     9.250     0.200
     1.411     9.149     0.200
     1.965    13.085     0.200
     2.197    13.479     0.200
     2.990    18.228     0.200
     2.990    18.028     0.200
     4.868    28.312     0.200
     0.193     1.631     0.200
     0.594     4.549     0.200
     0.960     5.971     0.200
     1.136     7.925     0.200
     1.415     8.765     0.200
     1.415    10.063     0.200
     1.576    10.288     0.200
     1.968    12.912     0.200
     2.194    13.474     0.200
     2.194    13.175     0.200
     2.498    14.730     0.200
     2.987    18.117     0.200
     3.395    20.463     0.200
     0.146     1.746     0.200
     0.651     5.054     0.200
     0.968     6.057     0.200
     1.099     7.627     0.200
     1.405     8.756     0.200
     1.511     9.720     0.200
     1.674    11.417     0.200
     1.674    11.117     0.200
     1.912    12.338     0.200
     2.234    13.287     0.200
     2.234    12.885     0.200
     2.567    14.801     0.200
     2.653    16.096     0.200
     3.042    17.853     0.200
     3.042    18.251     0.200
     3.720    22.038     0.200
     5.251    30.976     0.200
     0.277     2.151     0.200
     0.532     4.475     0.200
     1.026     7.704     0.200
     1.078     6.908     0.200
     1.078     6.709     0.200
     1.298     8.439     0.200
     1.875    12.298     0.200
     2.305    13.988     0.200
     2.573    15.658     0.200
     2.573    15.760     0.200
     2.559    14.723     0.200
     2.667    16.063     0.200
     3.085    18.580     0.200
     3.454    20.671     0.200
     3.456    19.646     0.200
     3.805    21.180     0.200
     0.632     5.253     0.200
     0.632     5.355     0.200
     0.972     6.286     0.200
     1.103     8.060     0.200
     1.401     9.180     0.200
     1.524    10.336     0.200
     1.680    11.625     0.200
     2.229    13.525     0.200
     2.772    16.279     0.200
     3.032    18.044     0.200
     3.342    20.126     0.200
     3.400    20.544     0.200
     3.377    20.493     0.200
     4.864    28.567     0.200
     0.627     4.988     0.200
     0.979     6.081     0.200
     1.096     7.618     0.200
     1.394     8.944     0.200
     1.394    10.143     0.200
     1.520     9.870     0.200
     1.673    10.882     0.200
     1.673    11.780     0.200
     1.917    12.341     0.200
     2.235    13.219     0.200
     2.235    13.321     0.200
     2.764    16.348     0.200
     3.038    18.454     0.200
     3.038    18.255     0.200
     3.406    20.456     0.200
     3.406    20.155     0.200
     3.369    20.191     0.200
     3.725    21.435     0.200
     4.351    25.736     0.200
     5.298    30.682     0.200
     0.306     2.411     0.200
     0.502     4.519     0.200
     0.576     4.470     0.200
     1.018     7.707     0.200
     1.018     8.606     0.200
     1.099     6.955     0.200
     1.278     8.269     0.200
     1.627     9.891     0.200
     1.875    12.306     0.200
     2.315    13.667     0.200
     2.568    15.221     0.200
     3.089    17.941     0.200
     3.817    22.140     0.200
     4.733    27.048     0.200
     0.276     2.626     0.200
     0.772     5.738     0.200
     0.834     5.904     0.200
     0.860     7.105     0.200
     0.892     6.728     0.200
     1.423    10.133     0.200
     1.588     9.810     0.200
     1.795    12.291     0.200
     1.810    12.015     0.200
     1.810    12.718     0.200
     2.674    16.440     0.200
     2.692    16.226     0.200
     0.176     1.531     0.200
     0.569     4.136     0.200
     0.629     4.844     0.200
     0.629     4.946     0.200
     0.998     6.140     0.200
     1.074     7.749     0.200
     1.375     9.332     0.200
     1.497     9.911     0.200
     1.651    11.621     0.200
     1.690    11.062     0.200
     1.894    12.082     0.200
     2.258    13.334     0.200
     2.625    15.348     0.200
     2.879    17.087     0.200
     3.061    18.459     0.200
     3.061    18.060     0.200
     3.352    19.365     0.200
     3.429    19.160     0.200
     3.429    19.863     0.200
     3.746    21.361     0.200
     4.839    28.606     0.200
     0.286     2.430     0.200
     0.515     4.262     0.200
     0.729     5.465     0.200
     0.973     5.909     0.200
     1.423     8.760     0.200
     1.423     9.959     0.200
     2.155    12.718     0.200
     2.924    17.440     0.200
     0.171     2.112     0.200
     0.597     4.439     0.200
     0.622     5.151     0.200
     0.979     6.185     0.200
     0.979     6.083     0.200
     1.098     7.991     0.200
     1.194     8.174     0.200
     1.394     8.941     0.200
     1.525     9.612     0.200
     1.525    10.112     0.200
     1.676    11.646     0.200
     1.676    10.146     0.200
     1.921    12.393     0.200
     2.232    13.155     0.200
     2.646    15.925     0.200
     3.034    17.706     0.200
     3.034    18.003     0.200
     3.352    18.492     0.200
     3.939    21.645     0.200
     4.856    27.640     0.200
     4.856    28.738     0.200
     0.344     2.850     0.200
     0.592     4.953     0.200
     0.576     3.640     0.200
     0.576     4.741     0.200
     0.667     5.177     0.200
     0.958     6.081     0.200
     0.958     6.285     0.200
     1.212     8.218     0.200
     1.255     8.615     0.200
     1.419     8.594     0.200
     1.808    11.456     0.200
     2.329    13.786     0.200
     2.455    14.509     0.200
     2.666    15.539     0.200
     2.927    17.401     0.200
     3.434    20.080     0.200
     4.428    23.986     0.200
     6.859    38.006     0.200
     0.173     3.882     0.200
     0.699     5.045     0.200
     0.764     4.789     0.200
     0.764     4.488     0.200
     0.960     7.106     0.200
     0.960     7.207     0.200
     1.285     9.007     0.200
     1.551     9.611     0.200
     1.659     9.745     0.200
     1.776    10.984     0.200
     1.826    10.996     0.200
     1.898    11.752     0.200
     1.999    11.780     0.200
     2.122    12.240     0.200
     2.122    12.138     0.200
     2.617    14.865     0.200
     2.867    16.851     0.200
     2.998    16.820     0.200
     2.998    16.621     0.200
     3.127    18.317     0.200
     3.560    21.061     0.200
     3.607    20.911     0.200
     4.209    24.489     0.200
     0.321     2.440     0.200
     0.602     4.564     0.200
     0.620     5.153     0.200
     0.620     5.254     0.200
     0.632     5.220     0.200
     0.933     6.405     0.200
     1.219     8.367     0.200
     1.448     8.699     0.200
     1.448     8.898     0.200
     1.509     9.982     0.200
     1.777    11.456     0.200
     2.171    13.259     0.200
     2.303    13.715     0.200
     2.701    15.676     0.200
     2.921    16.700     0.200
     2.898    17.472     0.200
     3.470    20.495     0.200
     3.470    20.294     0.200
     4.198    24.697     0.200
     4.404    25.900     0.200
     0.426     4.145     0.200
     0.426     4.247     0.200
     0.435     2.949     0.200
     0.545     3.857     0.200
     0.918     7.114     0.200
     1.149     6.912     0.200
     1.149     8.311     0.200
     1.233     7.736     0.200
     1.233     7.537     0.200
     1.456     9.434     0.200
     1.507    10.233     0.200
     1.801    11.703     0.200
     2.031    12.515     0.200
     3.181    18.804     0.200
     3.132    18.670     0.200
     3.556    21.429     0.200
     4.148    23.613     0.200
     4.148    23.914     0.200
     4.599    26.947     0.200
     4.599    27.349     0.200
     5.655    33.229     0.200
     0.144     1.733     0.200
     0.582     4.218     0.200
     0.656     5.361     0.200
     0.656     5.561     0.200
     0.969     6.308     0.200
     0.969     5.808     0.200
     1.405     8.616     0.200
     1.405     9.016     0.200
     1.507     9.925     0.200
     1.714    11.714     0.200
     1.909    12.237     0.200
     2.236    13.313     0.200
     2.652    15.565     0.200
     3.952    23.193     0.200
     3.952    22.193     0.200
     7.303    41.084     0.200
     0.160     1.675     0.200
     0.572     4.261     0.200
     0.644     5.729     0.200
     0.985     6.547     0.200
     1.170     7.989     0.200
     1.170     9.388     0.200
     1.389     8.835     0.200
     1.498    10.052     0.200
     1.658    10.392     0.200
     1.699    12.212     0.200
     1.898    12.291     0.200
     2.578    15.258     0.200
     2.759    16.836     0.200
     2.890    17.514     0.200
     3.057    17.970     0.200
     3.336    19.510     0.200
     3.737    21.830     0.200
     4.095    23.745     0.200
     4.853    28.503     0.200
     4.853    28.706     0.200
     0.156     1.880     0.200
     0.575     4.384     0.200
     0.646     5.861     0.200
     0.980     6.159     0.200
     0.980     6.460     0.200
     1.173     8.008     0.200
     1.393     8.845     0.200
     1.501    10.177     0.200
     1.662    10.703     0.200
     1.662    11.703     0.200
     1.703    12.223     0.200
     1.901    12.511     0.200
     2.246    13.492     0.200
     2.764    16.445     0.200
     3.053    18.470     0.200
     3.053    18.170     0.200
     3.421    20.480     0.200
     4.858    28.812     0.200
     0.156     1.427     0.200
     0.567     4.036     0.200
     0.651     5.344     0.200
     0.985     5.956     0.200
     0.985     6.753     0.200
     1.164     7.755     0.200
     1.389     8.437     0.200
     1.697    12.144     0.200
     1.893    11.458     0.200
     2.253    13.153     0.200
     2.253    13.052     0.200
     2.585    15.678     0.200
     2.635    16.090     0.200
     3.062    18.115     0.200
     3.329    18.387     0.200
     3.739    21.416     0.200
     4.855    28.894     0.200
     5.530    32.804     0.200
     0.289     3.077     0.200
     0.621     3.998     0.200
     0.621     3.795     0.200
     0.840     6.453     0.200
     1.466     9.239     0.200
     1.466    10.145     0.200
     1.525     9.748     0.200
     1.759    10.623     0.200
     1.759    10.818     0.200
     1.871    10.811     0.200
     2.290    13.421     0.200
     2.624    15.631     0.200
     2.704    15.987     0.200
     3.151    16.381     0.200
     3.353    19.915     0.200
     3.738    21.623     0.200
     0.073     2.891     0.200
     0.671     4.610     0.200
     0.723     5.903     0.200
     0.857     5.443     0.200
     1.268     8.344     0.200
     1.517     8.739     0.200
     1.517     9.038     0.200
     2.134    11.730     0.200
     2.507    14.579     0.200
     2.507    15.180     0.200
     2.763    16.399     0.200
     2.958    16.925     0.200
     3.017    16.027     0.200
     3.017    18.027     0.200
     3.241    17.520     0.200
     3.614    21.459     0.200
     4.063    23.720     0.200
     4.981    29.410     0.200
     5.423    31.752     0.200
     0.321     2.680     0.200
     0.430     2.606     0.200
     0.430     4.106     0.200
     0.639     5.366     0.200
     0.780     5.626     0.200
     1.107     7.203     0.200
     1.277     7.522     0.200
     1.358     9.087     0.200
     1.396     9.834     0.200
     1.615    10.276     0.200
     2.477    13.615     0.200
     2.551    14.452     0.200
     2.829    16.419     0.200
     3.344    19.804     0.200
     4.040    22.882     0.200
     4.578    24.399     0.200
     5.058    28.000     0.200
     0.323     2.667     0.200
     0.323     3.565     0.200
     0.431     2.709     0.200
     0.637     5.410     0.200
     0.780     5.739     0.200
     0.900     6.138     0.200
     1.106     7.330     0.200
     1.278     7.623     0.200
     1.358     9.493     0.200
     1.396     9.350     0.200
     1.396    10.549     0.200
     1.616     9.779     0.200
     1.942    12.276     0.200
     2.337    13.763     0.200
     2.551    14.467     0.200
     3.497    20.635     0.200
     4.040    22.498     0.200
     0.331     3.863     0.200
     0.331     3.363     0.200
     0.501     3.072     0.200
     0.629     3.878     0.200
     0.955     7.083     0.200
     1.141     6.702     0.200
     1.169     7.385     0.200
     1.264     7.870     0.200
     1.545    10.297     0.200
     1.545    10.398     0.200
     1.544     8.709     0.200
     1.856    11.565     0.200
     2.038    12.337     0.200
     2.419    13.695     0.200
     2.423    14.543     0.200
     2.574    14.779     0.200
     2.574    14.979     0.200
     2.667    15.094     0.200
     3.147    18.391     0.200
     3.125    17.554     0.200
     3.661    20.798     0.200
     3.938    22.465     0.200
     4.258    24.330     0.200
     0.174     2.685     0.200
     0.719     4.522     0.200
     0.813     5.524     0.200
     0.788     6.518     0.200
     1.350     8.555     0.200
     1.408     8.776     0.200
     1.654    10.609     0.200
     1.654     9.507     0.200
     1.720    11.341     0.200
     1.921    11.898     0.200
     1.989    12.206     0.200
     1.967    11.956     0.200
     1.967    14.355     0.200
     2.391    13.608     0.200
     2.512    14.698     0.200
     3.024    18.223     0.200
     3.179    17.615     0.200
     4.197    24.932     0.200
     4.321    25.685     0.200
     5.282    31.267     0.200
     0.311     2.675     0.200
     0.642     5.112     0.200
     0.788     5.709     0.200
     0.903     6.270     0.200
     1.149     7.801     0.200
     1.183     8.498     0.200
     1.475     9.790     0.200
     1.480     8.431     0.200
     1.480     8.931     0.200
     1.743    11.172     0.200
     2.736    15.077     0.200
     2.955    16.129     0.200
     0.190     2.212     0.200
     0.585     4.196     0.200
     0.608     5.433     0.200
     0.999     6.263     0.200
     1.181     7.737     0.200
     1.373     8.097     0.200
     1.373     8.897     0.200
     1.514     9.258     0.200
     1.659    10.562     0.200
     1.907    12.371     0.200
     2.250    12.671     0.200
     2.234    13.059     0.200
     2.560    15.153     0.200
     2.744    16.105     0.200
     2.880    17.018     0.200
     3.048    17.555     0.200
     3.369    20.005     0.200
     0.194     2.332     0.200
     0.588     4.236     0.200
     0.602     5.563     0.200
     1.001     6.314     0.200
     1.184     7.882     0.200
     1.372     8.286     0.200
     1.517     9.096     0.200
     1.517     9.995     0.200
     1.696    10.304     0.200
     1.696    11.906     0.200
     2.249    12.749     0.200
     3.046    17.948     0.200
     0.145     1.731     0.200
     0.628     4.399     0.200
     0.628     5.399     0.200
     0.642     5.534     0.200
     0.940     5.448     0.200
     1.136     7.968     0.200
     1.225     8.123     0.200
     1.432     8.603     0.200
     1.553     9.597     0.200
     1.553    10.195     0.200
     1.712    10.637     0.200
     1.752    10.083     0.200
     1.752    11.880     0.200
     2.196    13.100     0.200
     2.292    13.480     0.200
     2.525    15.155     0.200
     2.938    17.331     0.200
     3.326    19.606     0.200
     3.409    20.041     0.200
     0.162     1.392     0.200
     0.573     4.099     0.200
     0.641     5.497     0.200
     0.986     6.075     0.200
     1.170     7.825     0.200
     1.387     8.496     0.200
     1.387     9.793     0.200
     1.499     9.888     0.200
     1.658    10.935     0.200
     2.250    13.124     0.200
     2.635    16.029     0.200
     2.758    16.095     0.200
     3.056    18.113     0.200
     3.338    19.927     0.200
     4.852    27.763     0.200
     0.166     1.435     0.200
     0.570     4.019     0.200
     0.638     5.421     0.200
     0.990     6.117     0.200
     1.079     7.585     0.200
     1.168     7.745     0.200
     1.383     8.533     0.200
     1.613    11.052     0.200
     1.654    10.963     0.200
     1.895    12.153     0.200
     2.254    13.072     0.200
     2.237    13.662     0.200
     3.059    18.171     0.200
     3.357    19.796     0.200
     3.741    22.309     0.200
     0.343     3.989     0.200
     0.620     4.460     0.200
     0.698     4.740     0.200
     0.922     5.825     0.200
     1.352     8.114     0.200
     1.438     8.614     0.200
     1.438     9.314     0.200
     1.487     8.236     0.200
     1.487     8.936     0.200
     1.720    11.222     0.200
     2.209    12.513     0.200
     2.450    13.497     0.200
     2.633    14.867     0.200
     2.904    16.697     0.200
     3.338    19.241     0.200
     3.436    19.387     0.200
     4.157    24.482     0.200
     4.348    25.145     0.200
     4.684    26.225     0.200
     5.671    32.315     0.200
     0.159     1.432     0.200
     0.571     4.128     0.200
     0.645     5.464     0.200
     0.985     6.192     0.200
     1.082     8.460     0.200
     1.388     8.588     0.200
     1.497    10.022     0.200
     1.698    12.674     0.200
     1.896    12.259     0.200
     2.251    13.226     0.200
     2.636    16.032     0.200
     3.058    18.104     0.200
     0.167     1.431     0.200
     0.575     4.168     0.200
     0.635     5.562     0.200
     0.988     6.240     0.200
     0.988     6.139     0.200
     1.082     7.546     0.200
     1.385     8.614     0.200
     1.502     9.951     0.200
     1.658    11.627     0.200
     1.658    11.221     0.200
     1.698    10.662     0.200
     1.698    12.162     0.200
     1.900    12.308     0.200
     2.250    13.313     0.200
     2.634    15.335     0.200
     2.756    15.819     0.200
     2.756    16.819     0.200
     3.055    18.327     0.200
     3.344    20.254     0.200
     4.337    25.456     0.200
     4.849    28.984     0.200
     5.524    32.907     0.200
     7.546    43.212     0.200
     0.273     2.672     0.200
     0.538     5.278     0.200
     0.746     5.555     0.200
     0.943     5.656     0.200
     1.453     9.303     0.200
     1.676    10.096     0.200
     1.676    11.096     0.200
     1.756    11.168     0.200
     1.816    10.264     0.200
     1.816    13.365     0.200
     2.127    12.239     0.200
     2.336    13.800     0.200
     0.181     1.455     0.200
     0.470     3.591     0.200
     0.817     6.628     0.200
     1.001     6.092     0.200
     1.365     9.336     0.200
     1.413     9.280     0.200
     1.545     9.939     0.200
     1.593    10.581     0.200
     1.593    11.382     0.200
     1.657    11.529     0.200
     1.791    11.166     0.200
     1.791    11.763     0.200
     2.330    13.576     0.200
     2.735    16.755     0.200
     2.780    16.530     0.200
     2.880    16.754     0.200
     3.202    18.899     0.200
     3.174    18.929     0.200
     3.360    20.454     0.200
     4.288    25.525     0.200
     8.297    42.741     0.200
     0.114     2.269     0.200
     0.588     4.433     0.200
     0.684     5.812     0.200
     0.946     5.762     0.200
     1.114     8.605     0.200
     1.429     8.824     0.200
     1.509     9.385     0.200
     1.642    10.334     0.200
     1.685    10.933     0.200
     1.731    11.999     0.200
     1.916    10.637     0.200
     1.916    12.434     0.200
     2.223    12.256     0.200
     2.573    14.668     0.200
     2.800    15.221     0.200
     3.039    17.733     0.200
     3.705    21.462     0.200
     0.069     3.015     0.200
     0.685     4.833     0.200
     0.736     5.929     0.200
     0.838     5.340     0.200
     1.221     8.578     0.200
     1.535     8.911     0.200
     1.597     9.986     0.200
     1.746    11.143     0.200
     2.119    11.995     0.200
     2.945    17.358     0.200
     0.448     3.389     0.200
     0.662     5.796     0.200
     1.094     7.848     0.200
     1.094     8.048     0.200
     1.216     9.128     0.200
     1.292     9.241     0.200
     1.296     8.995     0.200
     1.333     9.965     0.200
     1.374    10.387     0.200
     1.923    13.273     0.200
     1.923    13.172     0.200
     2.576    15.360     0.200
     2.857    17.175     0.200
     3.493    20.859     0.200
     3.644    21.189     0.200
     4.297    25.771     0.200
     5.051    28.878     0.200
     0.306     2.795     0.200
     0.415     3.526     0.200
     1.152     7.729     0.200
     1.227     8.746     0.200
     1.345     9.268     0.200
     1.442     9.639     0.200
     1.483    10.158     0.200
     1.731    10.966     0.200
     1.731    11.966     0.200
     2.425    15.073     0.200
     0.309     1.965     0.200
     0.391     3.009     0.200
     0.657     5.408     0.200
     1.227     8.856     0.200
     1.321     9.053     0.200
     1.427    10.127     0.200
     1.711    11.608     0.200
     0.303     2.068     0.200
     0.397     2.865     0.200
     0.656     5.556     0.200
     0.903     6.572     0.200
     1.150     6.980     0.200
     1.233     7.823     0.200
     1.328     8.611     0.200
     1.433     9.378     0.200
     1.476    10.585     0.200
     1.520    11.071     0.200
     1.718    10.460     0.200
     1.718    11.163     0.200
     2.432    14.522     0.200
     0.176     1.618     0.200
     0.586     4.237     0.200
     0.989     6.540     0.200
     1.087     7.585     0.200
     1.384     8.824     0.200
     1.384    10.121     0.200
     1.514    10.001     0.200
     1.624    11.128     0.200
     1.665    11.945     0.200
     1.665    11.843     0.200
     1.910    12.588     0.200
     2.244    13.795     0.200
     3.045    18.545     0.200
     3.413    20.642     0.200
     0.164     1.607     0.200
     0.571     4.157     0.200
     0.640     5.551     0.200
     0.988     6.188     0.200
     1.385     9.059     0.200
     1.498    10.041     0.200
     1.614    10.684     0.200
     1.896    11.390     0.200
     1.896    12.390     0.200
     2.252    13.438     0.200
     3.058    18.332     0.200
     3.740    21.979     0.200
     0.299     3.073     0.200
     0.588     4.104     0.200
     0.880     6.989     0.200
     0.943     6.256     0.200
     1.789    11.185     0.200
     1.856    11.001     0.200
     1.840    11.293     0.200
     2.269    13.584     0.200
     0.295     2.917     0.200
     0.586     3.923     0.200
     0.586     3.821     0.200
     0.939     6.294     0.200
     1.485     9.427     0.200
     1.487     9.400     0.200
     1.859    10.759     0.200
     1.834    11.150     0.200
     2.307    13.335     0.200
     2.264    13.434     0.200
     2.705    15.893     0.200
     3.159    18.792     0.200
     3.333    19.859     0.200
     4.320    24.745     0.200
     5.163    30.405     0.200
     0.431     4.507     0.200
     0.489     3.726     0.200
     0.512     3.662     0.200
     1.081     6.422     0.200
     1.299     7.581     0.200
     1.299     8.481     0.200
     1.408     9.406     0.200
     1.410    10.178     0.200
     1.962    12.435     0.200
     1.962    12.034     0.200
     2.351    13.195     0.200
     2.447    14.173     0.200
     2.687    15.180     0.200
     3.063    18.285     0.200
     3.246    19.156     0.200
     3.643    19.719     0.200
     4.008    23.557     0.200
     4.008    23.356     0.200
     4.080    23.426     0.200
     4.534    25.228     0.200
     0.270     2.497     0.200
     0.766     4.502     0.200
     1.526     9.738     0.200
     1.708    10.609     0.200
     1.783    11.036     0.200
     1.836    11.422     0.200
     1.919    12.754     0.200
     1.986    12.073     0.200
     2.146    12.398     0.200
     3.040    17.966     0.200
     0.145     1.607     0.200
     0.573     4.116     0.200
     0.974     6.226     0.200
     0.974     6.124     0.200
     1.089     7.585     0.200
     1.089     8.881     0.200
     1.400     8.463     0.200
     1.400     9.658     0.200
     1.497     9.918     0.200
     1.621     9.976     0.200
     1.621    10.976     0.200
     1.663    10.982     0.200
     1.706    10.686     0.200
     1.706    11.983     0.200
     1.899    12.226     0.200
     2.245    13.196     0.200
     2.771    16.759     0.200
     3.055    18.339     0.200
     3.055    17.839     0.200
     3.320    20.055     0.200
     3.422    20.357     0.200
     3.422    20.053     0.200
     0.282     3.021     0.200
     0.597     3.750     0.200
     0.927     6.101     0.200
     1.778    11.073     0.200
     1.822    11.150     0.200
     1.872    11.072     0.200
     1.995    12.331     0.200
     2.252    13.439     0.200
     2.317    13.682     0.200
     2.717    16.016     0.200
     3.346    19.473     0.200
     0.158     1.469     0.200
     0.570     4.050     0.200
     0.984     6.121     0.200
     0.984     6.722     0.200
     1.082     7.577     0.200
     1.389     8.393     0.200
     1.389     9.694     0.200
     1.496     9.845     0.200
     1.657    11.065     0.200
     2.251    13.244     0.200
     2.636    16.043     0.200
     3.058    17.917     0.200
     0.151     1.440     0.200
     0.571     4.039     0.200
     0.979     6.072     0.200
     1.086     8.035     0.200
     1.394     8.630     0.200
     1.394     9.829     0.200
     1.496     9.939     0.200
     1.660    11.230     0.200
     1.702    12.040     0.200
     2.248    13.471     0.200
     3.057    18.528     0.200
     3.733    21.731     0.200
     0.276     2.723     0.200
     0.411     2.953     0.200
     0.705     5.314     0.200
     0.729     5.537     0.200
     0.768     6.177     0.200
     0.875     6.429     0.200
     1.431    10.146     0.200
     1.665    10.911     0.200
     1.684    11.697     0.200
     2.742    16.939     0.200
     2.789    17.202     0.200
     0.310     2.483     0.200
     0.409     4.023     0.200
     0.493     3.644     0.200
     0.740     4.956     0.200
     0.986     6.587     0.200
     1.184     7.985     0.200
     1.417     9.865     0.200
     1.671    10.902     0.200
     1.735    11.350     0.200
     1.771    11.727     0.200
     0.361     3.633     0.200
     0.719     4.648     0.200
     0.964     6.692     0.200
     1.457     9.632     0.200
     1.706     9.539     0.200
     1.706    10.937     0.200
     0.343     2.594     0.200
     0.503     3.928     0.200
     0.939     7.441     0.200
     1.162     7.233     0.200
     1.211     7.561     0.200
     1.211     8.561     0.200
     1.429     9.824     0.200
     1.487    10.342     0.200
     1.524    10.508     0.200
     1.524    11.109     0.200
     1.550    10.412     0.200
     2.393    13.973     0.200
     2.470    14.772     0.200
     2.645    15.333     0.200
     2.581    15.278     0.200
     2.721    15.236     0.200
     4.672    26.477     0.200
     0.219     2.141     0.200
     0.342     2.602     0.200
     0.495     3.616     0.200
     0.594     4.366     0.200
     0.736     6.010     0.200
     1.038     7.677     0.200
     1.283     8.827     0.200
     1.339     8.463     0.200
     1.348     8.860     0.200
     3.572    20.710     0.200
     0.212     2.215     0.200
     0.534     3.955     0.200
     1.041     6.642     0.200
     1.031     7.557     0.200
     1.333     8.234     0.200
     1.333     9.035     0.200
     1.567    10.193     0.200
     1.608    11.715     0.200
     1.646     9.669     0.200
     1.646    11.770     0.200
     0.120     2.918     0.200
     0.675     4.448     0.200
     0.884     5.208     0.200
     1.489     8.438     0.200
     1.489     9.237     0.200
     1.724    10.095     0.200
     1.724    11.696     0.200
     1.767    10.904     0.200
     1.767    11.204     0.200
     2.141    11.932     0.200
     2.141    11.730     0.200
     2.349    14.011     0.200
     2.488    14.689     0.200
     2.742    16.418     0.200
     2.952    17.664     0.200
     2.996    17.462     0.200
     3.289    19.636     0.200
     3.289    19.336     0.200
     3.466    20.473     0.200
     4.033    23.850     0.200
     4.345    25.615     0.200
     4.950    29.251     0.200
     5.159    29.316     0.200
     0.299     2.536     0.200
     0.448     2.998     0.200
     0.758     5.875     0.200
     1.093     7.373     0.200
     1.093     7.673     0.200
     1.296     7.904     0.200
     1.296     8.404     0.200
     1.294     9.219     0.200
     1.294     9.719     0.200
     1.335     9.045     0.200
     1.335     9.646     0.200
     1.924    12.477     0.200
     2.574    14.893     0.200
     2.574    13.992     0.200
     2.852    17.138     0.200
     2.852    17.037     0.200
     3.367    19.526     0.200
     3.497    18.515     0.200
     4.060    23.840     0.200
     4.060    23.440     0.200
     4.303    24.206     0.200
     0.309     2.522     0.200
     0.442     3.172     0.200
     0.766     5.787     0.200
     1.097     7.825     0.200
     1.289     8.082     0.200
     1.303     9.719     0.200
     1.344     9.646     0.200
     1.930    12.403     0.200
     2.565    14.996     0.200
     0.297     3.053     0.200
     0.637     3.890     0.200
     0.679     4.900     0.200
     0.816     5.793     0.200
     0.936     6.301     0.200
     1.464    10.239     0.200
     1.870    10.997     0.200
     1.844    11.608     0.200
     2.696    15.758     0.200
     3.116    18.660     0.200
     0.124     2.973     0.200
     0.452     3.945     0.200
     0.555     4.954     0.200
     0.691     5.563     0.200
     0.711     5.232     0.200
     0.847     5.444     0.200
     1.527     9.010     0.200
     1.527     9.609     0.200
     1.630     9.699     0.200
     1.630    10.699     0.200
     2.103    11.887     0.200
     2.781    15.975     0.200
     3.590    20.833     0.200
     0.168     1.432     0.200
     0.331     2.834     0.200
     0.439     3.971     0.200
     0.587     4.139     0.200
     0.628     4.861     0.200
     0.982     6.325     0.200
     1.092     7.551     0.200
     1.092     8.957     0.200
     1.390     8.664     0.200
     1.515     9.918     0.200
     1.627    10.706     0.200
     1.627    11.402     0.200
     1.669    11.318     0.200
     1.707    10.569     0.200
     1.707    12.069     0.200
     1.912    12.285     0.200
     2.240    13.456     0.200
     3.043    18.584     0.200
     0.201     2.472     0.200
     0.320     2.583     0.200
     0.408     2.754     0.200
     0.463     3.612     0.200
     0.518     3.773     0.200
     1.160     7.279     0.200
     1.217     7.608     0.200
     1.433     9.493     0.200
     1.433    10.493     0.200
     1.465     9.921     0.200
     1.500    10.717     0.200
     1.517    10.317     0.200
     1.786    11.777     0.200
     2.428    14.681     0.200
     3.563    21.437     0.200
     0.158     2.964     0.200
     0.736     5.510     0.200
     0.807     5.785     0.200
     0.994     6.701     0.200
     1.251     8.909     0.200
     1.306     8.457     0.200
     1.315     8.460     0.200
     1.798    10.825     0.200
     1.809    11.199     0.200
     1.830    11.647     0.200
     1.877    11.297     0.200
     2.272    12.691     0.200
     2.234    13.135     0.200
     2.273    13.283     0.200
     2.831    16.770     0.200
     2.914    17.296     0.200
     0.316     3.187     0.200
     0.624     4.885     0.200
     0.815     5.066     0.200
     0.815     4.965     0.200
     0.626     5.164     0.200
     0.880     6.198     0.200
     1.358     8.420     0.200
     1.601     9.188     0.200
     1.601    10.285     0.200
     1.601     9.086     0.200
     1.808    11.570     0.200
     1.975    11.325     0.200
     1.905    12.542     0.200
     1.968    13.504     0.200
     2.265    13.640     0.200
     2.755    16.327     0.200
     2.961    17.718     0.200
     5.034    26.525     0.200
     5.425    29.061     0.200
     0.325     2.953     0.200
     0.636     5.029     0.200
     0.639     4.696     0.200
     0.802     4.794     0.200
     0.895     6.104     0.200
     1.375     8.809     0.200
     1.375     9.512     0.200
     1.617     9.381     0.200
     1.823    11.281     0.200
     1.921    12.331     0.200
     1.959    11.388     0.200
     1.959    12.884     0.200
     1.984    12.898     0.200
     2.251    12.180     0.200
     3.357    19.873     0.200
     0.321     3.129     0.200
     0.616     5.293     0.200
     0.624     4.895     0.200
     0.825     4.851     0.200
     0.879     6.117     0.200
     1.354     9.375     0.200
     1.594     9.481     0.200
     1.594    10.176     0.200
     1.939    11.951     0.200
     1.981    11.256     0.200
     1.963    12.971     0.200
     2.265    13.241     0.200
     3.134    18.698     0.200
     0.184     1.450     0.200
     0.325     2.699     0.200
     0.580     4.118     0.200
     1.375     8.745     0.200
     1.375     9.842     0.200
     1.375     8.944     0.200
     1.509     9.885     0.200
     1.657    11.551     0.200
     1.903    12.283     0.200
     2.251    13.518     0.200
     2.251    12.917     0.200
     2.627    16.134     0.200
     3.052    18.380     0.200
     3.362    19.554     0.200
     4.332    25.740     0.200
     6.694    38.674     0.200
     0.202     2.436     0.200
     0.401     3.409     0.200
     0.585     4.770     0.200
     0.655     4.546     0.200
     0.961     6.274     0.200
     0.961     6.174     0.200
     1.140     7.688     0.200
     1.415     8.775     0.200
     1.415     9.075     0.200
     1.585    10.001     0.200
     1.682    10.363     0.200
     1.722    11.601     0.200
     1.975    12.143     0.200
     2.190    12.840     0.200
     2.190    12.540     0.200
     2.485    14.700     0.200
     2.980    17.712     0.200
     3.356    19.728     0.200
     3.687    21.865     0.200
     0.194     2.520     0.200
     0.734     5.320     0.200
     1.096     7.196     0.200
     1.318     8.511     0.200
     1.398     8.773     0.200
     1.587     9.268     0.200
     1.908    11.626     0.200
     2.114    12.622     0.200
     2.389    14.302     0.200
     2.534    14.619     0.200
     2.642    15.257     0.200
     2.585    15.123     0.200
     2.961    16.929     0.200
     0.066     2.919     0.200
     0.788     5.594     0.200
     1.167     7.776     0.200
     1.339     8.564     0.200
     1.391     8.355     0.200
     1.399     9.158     0.200
     1.463     8.312     0.200
     2.180    12.447     0.200
     2.401    14.367     0.200
     2.863    16.783     0.200
     0.329     3.003     0.200
     0.346     3.109     0.200
     0.453     3.457     0.200
     0.785     5.988     0.200
     1.108     7.017     0.200
     1.159     9.019     0.200
     1.339     8.524     0.200
     1.704    10.556     0.200
     1.704    11.454     0.200
     1.718    10.494     0.200
     1.718    11.494     0.200
     1.749    12.232     0.200
     1.750    11.817     0.200
     2.217    13.677     0.200
     2.941    17.521     0.200
     2.941    18.021     0.200
     0.255     2.234     0.200
     0.302     3.084     0.200
     0.300     2.508     0.200
     0.635     4.802     0.200
     0.647     5.663     0.200
     0.961     6.897     0.200
     1.173     8.322     0.200
     1.195     8.466     0.200
     1.232     9.136     0.200
     1.260     8.710     0.200
     1.423     8.508     0.200
     1.514    10.049     0.200
     1.799    12.114     0.200
     2.683    16.197     0.200
     0.128     2.588     0.200
     0.307     3.600     0.200
     0.733     5.716     0.200
     0.820     6.911     0.200
     0.920     6.537     0.200
     1.376     9.016     0.200
     1.370     9.595     0.200
     1.398     9.666     0.200
     1.477     9.234     0.200
     1.477    10.031     0.200
     1.509     8.968     0.200
     1.509     9.764     0.200
     1.750    11.449     0.200
     1.800    11.573     0.200
     1.830    11.818     0.200
     1.830    12.818     0.200
     2.209    13.596     0.200
     2.448    14.912     0.200
     2.704    16.424     0.200
     3.327    20.048     0.200
     4.162    22.907     0.200
     0.279     2.232     0.200
     0.456     3.864     0.200
     0.331     3.316     0.200
     1.145     7.627     0.200
     1.145     7.428     0.200
     1.290     8.733     0.200
     1.290     8.534     0.200
     1.659    11.022     0.200
     1.667    11.025     0.200
     1.667    11.724     0.200
     1.698    12.063     0.200
     2.267    13.731     0.200
     2.424    14.497     0.200
     2.640    16.079     0.200
     3.272    19.822     0.200
     0.301     2.267     0.200
     0.488     3.185     0.200
     0.627     5.259     0.200
     1.049     7.636     0.200
     1.220     8.043     0.200
     1.220     9.238     0.200
     1.272     8.840     0.200
     1.272     9.535     0.200
     1.334     8.405     0.200
     1.334     9.108     0.200
     1.310     9.387     0.200
     1.579    10.453     0.200
     1.579    10.953     0.200
     1.887    12.760     0.200
     2.601    15.727     0.200
     3.546    21.402     0.200
     0.280     1.952     0.200
     0.328     3.385     0.200
     0.459     3.861     0.200
     1.110     9.056     0.200
     1.146     7.647     0.200
     1.146     7.452     0.200
     1.291     8.861     0.200
     1.291     8.759     0.200
     1.662    11.022     0.200
     1.670    11.028     0.200
     1.701    12.270     0.200
     1.701    11.668     0.200
     2.266    13.982     0.200
     2.640    16.114     0.200
     0.320     2.969     0.200
     0.287     2.845     0.200
     0.470     3.219     0.200
     0.548     4.203     0.200
     0.762     5.310     0.200
     1.296     8.167     0.200
     1.681    11.279     0.200
     1.676    10.534     0.200
     1.676    11.233     0.200
     1.710    10.939     0.200
     1.710    11.740     0.200
     1.712    11.725     0.200
     2.259    13.837     0.200
     2.408    14.493     0.200
     2.582    15.661     0.200
     2.980    17.919     0.200
     0.131     2.303     0.200
     0.434     3.669     0.200
     0.528     4.670     0.200
     0.692     4.956     0.200
     0.670     5.416     0.200
     0.873     5.644     0.200
     1.206     8.456     0.200
     1.500     9.128     0.200
     1.500    10.327     0.200
     1.741    10.823     0.200
     1.741    11.620     0.200
     1.741    12.620     0.200
     1.783    12.131     0.200
     1.822    12.871     0.200
     2.125    12.533     0.200
     3.614    20.659     0.200
     4.960    27.458     0.200
     0.336     3.294     0.200
     0.459     3.651     0.200
     0.557     4.405     0.200
     0.776     5.653     0.200
     1.122     7.210     0.200
     1.323     9.273     0.200
     1.323     8.472     0.200
     1.694    10.541     0.200
     1.694    11.240     0.200
     1.704    10.418     0.200
     1.704    11.520     0.200
     1.735    11.558     0.200
     1.735    11.960     0.200
     1.735    11.160     0.200
     1.735    11.859     0.200
     2.233    13.754     0.200
     2.233    13.855     0.200
     2.388    14.348     0.200
     2.609    15.865     0.200
     2.670    16.146     0.200
     2.956    17.717     0.200
     3.304    20.003     0.200
     4.661    27.914     0.200
     0.244     2.553     0.200
     0.253     3.348     0.200
     0.383     3.423     0.200
     0.448     3.375     0.200
     0.537     4.737     0.200
     0.876     6.379     0.200
     1.158     7.591     0.200
     1.370     8.811     0.200
     1.370     9.514     0.200
     1.424     9.591     0.200
     1.461     9.849     0.200
     1.487    10.743     0.200
     1.733    11.070     0.200
     0.261     3.030     0.200
     0.443     3.505     0.200
     0.448     3.545     0.200
     0.561     4.528     0.200
     0.588     5.406     0.200
     0.730     5.056     0.200
     1.149     8.258     0.200
     1.149     8.758     0.200
     1.174     8.968     0.200
     1.220     8.328     0.200
     1.506     9.388     0.200
     1.506    10.294     0.200
     1.565     9.809     0.200
     0.186     2.508     0.200
     0.337     2.748     0.200
     0.419     3.289     0.200
     0.518     4.135     0.200
     0.589     3.903     0.200
     0.702     5.987     0.200
     0.951     6.585     0.200
     1.260     8.771     0.200
     1.277     8.575     0.200
     1.302     8.484     0.200
     1.422     8.982     0.200
     1.820    12.445     0.200
     2.929    17.870     0.200
     0.298     2.982     0.200
     0.496     4.576     0.200
     0.553     4.910     0.200
     0.552     4.516     0.200
     0.904     5.610     0.200
     1.266     8.886     0.200
     1.504     9.707     0.200
     1.734    11.323     0.200
     1.874    12.292     0.200
     2.070    12.201     0.200
     2.841    16.906     0.200
     3.219    19.200     0.200
     3.580    21.282     0.200
     0.135     2.101     0.200
     0.491     4.551     0.200
     0.530     4.197     0.200
     0.711     5.489     0.200
     0.982     6.120     0.200
     1.067     7.635     0.200
     1.399     8.664     0.200
     1.449     9.273     0.200
     1.590    10.224     0.200
     1.634    11.014     0.200
     1.684    10.228     0.200
     1.684    11.728     0.200
     1.859    11.896     0.200
     0.242     2.866     0.200
     0.622     4.031     0.200
     0.634     4.888     0.200
     0.778     6.107     0.200
     0.879     6.630     0.200
     0.886     5.753     0.200
     1.437     9.621     0.200
     1.751    11.054     0.200
     1.778    11.442     0.200
     1.913    11.663     0.200
     1.956    12.758     0.200
     3.382    20.415     0.200
     0.088     2.637     0.200
     0.829     5.795     0.200
     1.216     7.872     0.200
     1.373     8.044     0.200
     1.372     8.353     0.200
     1.457     9.259     0.200
     2.063    12.295     0.200
     2.297    13.364     0.200
     2.301    13.710     0.200
     2.534    15.089     0.200
     0.180     1.842     0.200
     0.270     2.391     0.200
     0.512     3.275     0.200
     0.664     5.190     0.200
     0.696     5.927     0.200
     1.032     7.503     0.200
     1.177     7.806     0.200
     1.177     8.806     0.200
     1.274     8.875     0.200
     1.359     8.181     0.200
     1.538    10.102     0.200
     1.726    12.301     0.200
     1.860    12.639     0.200
     2.635    15.990     0.200
     0.183     2.525     0.200
     0.333     2.676     0.200
     0.420     3.158     0.200
     0.515     4.049     0.200
     0.581     3.977     0.200
     0.709     5.683     0.200
     0.958     6.576     0.200
     1.267     8.872     0.200
     1.282     8.606     0.200
     1.299     9.098     0.200
     1.414     8.956     0.200
     1.604    10.644     0.200
     1.828    12.134     0.200
     0.121     2.146     0.200
     0.327     2.947     0.200
     0.678     4.845     0.200
     0.678     5.845     0.200
     0.952     5.453     0.200
     0.952     6.251     0.200
     1.108     7.625     0.200
     1.108     8.424     0.200
     1.422     8.560     0.200
     1.422     9.460     0.200
     1.507     9.271     0.200
     1.638    10.246     0.200
     1.681    10.745     0.200
     1.725    10.926     0.200
     1.913    12.636     0.200
     2.227    13.068     0.200
     2.570    15.665     0.200
     2.794    16.658     0.200
     3.042    18.061     0.200
     3.298    19.871     0.200
     0.329     3.702     0.200
     0.718     5.369     0.200
     0.825     6.714     0.200
     0.885     6.217     0.200
     0.834     6.410     0.200
     1.329     9.635     0.200
     1.366     8.604     0.200
     1.366     9.104     0.200
     1.380     9.337     0.200
     1.380     8.939     0.200
     1.527     9.020     0.200
     1.647     9.918     0.200
     1.647     9.715     0.200
     1.752    10.689     0.200
     1.760    11.402     0.200
     1.757    11.736     0.200
     4.204    24.577     0.200
     0.115     2.554     0.200
     0.497     4.601     0.200
     0.624     4.324     0.200
     0.672     5.363     0.200
     0.924     5.821     0.200
     1.449     8.987     0.200
     1.546     9.357     0.200
     1.674    11.061     0.200
     1.717    11.464     0.200
     1.760    12.068     0.200
     1.951    11.932     0.200
     2.191    12.729     0.200
     0.284     2.701     0.200
     0.329     3.580     0.200
     0.487     3.530     0.200
     0.655     5.072     0.200
     0.721     5.809     0.200
     1.054     7.522     0.200
     1.197     8.045     0.200
     1.197     9.045     0.200
     1.259     9.025     0.200
     1.299     8.861     0.200
     1.335     8.341     0.200
     1.337    10.521     0.200
     1.561    10.305     0.200
     1.884    11.932     0.200
     4.525    25.314     0.200
     0.251     2.377     0.200
     0.355     4.054     0.200
     0.548     4.209     0.200
     0.567     4.885     0.200
     1.065     6.567     0.200
     1.023     7.465     0.200
     1.023     8.567     0.200
     1.308     8.341     0.200
     1.478     9.449     0.200
     1.604    10.279     0.200
     1.861    10.478     0.200
     1.861    11.978     0.200
     2.307    13.274     0.200
     3.096    18.268     0.200
     0.150     2.431     0.200
     0.733     5.227     0.200
     1.301     8.499     0.200
     1.301     9.399     0.200
     1.331     8.647     0.200
     1.373     8.559     0.200
     1.548     8.817     0.200
     1.917    12.016     0.200
     2.261    13.396     0.200
     2.488    14.547     0.200
     2.609    15.633     0.200
     2.686    15.440     0.200
     0.290     2.616     0.200
     0.312     3.462     0.200
     0.573     4.309     0.200
     0.646     5.266     0.200
     0.645     5.178     0.200
     0.965     6.933     0.200
     1.166     7.797     0.200
     1.230     8.349     0.200
     1.509     9.797     0.200
     1.801    11.587     0.200
     0.088     3.286     0.200
     0.793     6.156     0.200
     1.319     8.417     0.200
     1.319     8.917     0.200
     1.350     8.359     0.200
     1.350     8.460     0.200
     1.420     8.839     0.200
     1.991    12.680     0.200
     2.092    12.295     0.200
     2.092    12.193     0.200
     2.333    13.777     0.200
     2.333    13.277     0.200
     2.263    13.598     0.200
     2.793    15.410     0.200
     3.235    19.160     0.200
     4.289    25.161     0.200
     4.374    25.964     0.200
     0.257     2.075     0.200
     0.403     3.263     0.200
     0.532     4.062     0.200
     0.681     4.821     0.200
     0.987     5.951     0.200
     1.143     8.231     0.200
     1.398     8.452     0.200
     1.612    10.264     0.200
     1.690    10.642     0.200
     1.993    12.713     0.200
     2.190    12.715     0.200
     2.967    17.450     0.200
     4.846    28.316     0.200
     0.088     2.521     0.200
     0.420     3.642     0.200
     0.512     3.668     0.200
     0.575     3.842     0.200
     0.789     6.344     0.200
     0.995     6.331     0.200
     1.349     8.904     0.200
     1.386     8.668     0.200
     1.378     9.066     0.200
     1.694    11.178     0.200
     1.882    11.988     0.200
     2.269    13.764     0.200
     2.576    15.381     0.200
     3.313    19.884     0.200
     0.172     2.892     0.200
     0.500     4.159     0.200
     0.615     4.521     0.200
     0.929     6.553     0.200
     0.929     6.451     0.200
     1.257     8.629     0.200
     1.445     8.838     0.200
     1.445     8.736     0.200
     1.600     9.821     0.200
     1.804    11.847     0.200
     2.657    15.782     0.200
     2.828    16.996     0.200
     2.909    16.846     0.200
     3.403    20.286     0.200
     4.391    25.355     0.200
     0.219     2.592     0.200
     0.409     3.484     0.200
     0.657     4.888     0.200
     0.756     5.434     0.200
     1.223     7.782     0.200
     1.255     8.707     0.200
     1.353     8.758     0.200
     1.353     8.959     0.200
     1.815    11.668     0.200
     1.857    11.886     0.200
     1.818    11.441     0.200
     1.840    12.580     0.200
     2.217    13.083     0.200
     2.217    13.282     0.200
     2.261    13.162     0.200
     2.881    17.134     0.200
     0.151     2.689     0.200
     0.401     3.375     0.200
     0.474     4.121     0.200
     0.635     4.638     0.200
     0.704     5.734     0.200
     0.916     6.059     0.200
     1.265     8.591     0.200
     1.294     8.952     0.200
     1.293     9.360     0.200
     1.310     8.969     0.200
     1.460     9.019     0.200
     1.615     9.611     0.200
     1.615    10.811     0.200
     1.798    11.674     0.200
     2.186    13.440     0.200
     2.284    13.994     0.200
     2.816    16.793     0.200
     0.284     2.666     0.200
     0.492     4.344     0.200
     0.538     4.105     0.200
     0.558     4.868     0.200
     0.790     5.359     0.200
     0.905     5.621     0.200
     1.256     9.230     0.200
     1.498     9.296     0.200
     1.720    10.806     0.200
     1.804    12.131     0.200
     1.841    12.593     0.200
     1.864    12.525     0.200
     2.079    12.415     0.200
     2.348    13.982     0.200
     2.853    16.986     0.200
     0.290     2.714     0.200
     0.551     4.357     0.200
     0.504     4.404     0.200
     0.564     4.610     0.200
     0.894     5.456     0.200
     0.804     5.609     0.200
     1.270     8.772     0.200
     1.512     9.554     0.200
     1.734    11.359     0.200
     1.818    11.671     0.200
     1.856    12.131     0.200
     1.879    13.169     0.200
     2.065    12.393     0.200
     2.335    13.949     0.200
     2.839    16.966     0.200
     2.839    17.162     0.200
     4.573    26.920     0.200
     4.948    28.148     0.200
     0.210     2.217     0.200
     0.337     2.627     0.200
     0.396     2.741     0.200
     0.452     3.484     0.200
     0.939     7.003     0.200
     1.196     7.799     0.200
     1.183     7.862     0.200
     1.183     9.260     0.200
     1.460     9.325     0.200
     1.460    10.525     0.200
     1.493    10.038     0.200
     1.528    10.535     0.200
     1.814    11.793     0.200
     2.401    14.538     0.200
     0.330     2.248     0.200
     0.314     2.743     0.200
     0.275     2.793     0.200
     0.502     3.747     0.200
     0.976     7.522     0.200
     1.136     7.144     0.200
     1.239     7.642     0.200
     1.239     9.142     0.200
     1.467     9.481     0.200
     1.525    10.308     0.200
     1.562    10.580     0.200
     1.585    10.807     0.200
     1.835    12.191     0.200
     0.127     2.613     0.200
     0.345     3.069     0.200
     0.351     3.497     0.200
     0.374     3.121     0.200
     0.652     4.882     0.200
     0.832     6.284     0.200
     1.164     7.807     0.200
     1.222     7.931     0.200
     1.274     8.323     0.200
     1.365     9.163     0.200
     1.406     9.577     0.200
     1.655     9.877     0.200
     1.655    10.778     0.200
     1.861    12.474     0.200
     1.998    13.076     0.200
     0.194     3.027     0.200
     0.329     3.254     0.200
     0.410     3.607     0.200
     0.526     4.350     0.200
     0.585     4.563     0.200
     0.699     5.938     0.200
     0.953     6.375     0.200
     1.256     8.733     0.200
     1.270     8.672     0.200
     1.289     8.752     0.200
     1.420     8.822     0.200
     1.593     9.907     0.200
     1.820    12.059     0.200
     2.211    13.193     0.200
     2.323    13.878     0.200
     0.277     2.961     0.200
     0.689     5.156     0.200
     1.279     8.761     0.200
     1.279     8.159     0.200
     1.279     8.562     0.200
     1.383     8.451     0.200
     1.383     8.150     0.200
     1.669     9.911     0.200
     1.669     9.809     0.200
     1.847    12.234     0.200
     2.391    14.289     0.200
     2.626    15.641     0.200
     2.616    15.255     0.200
     3.036    18.057     0.200
     3.036    17.854     0.200
     0.270     3.460     0.200
     0.295     3.368     0.200
     0.524     3.995     0.200
     0.598     4.631     0.200
     0.805     5.619     0.200
     1.179     7.057     0.200
     1.140     8.203     0.200
     1.292     8.134     0.200
     1.292     8.534     0.200
     1.713    11.219     0.200
     1.722    11.321     0.200
     1.730    11.027     0.200
     2.263    13.107     0.200
     2.382    13.918     0.200
     2.968    17.571     0.200
     3.270    18.623     0.200
     0.216     2.538     0.200
     0.314     2.581     0.200
     0.389     2.916     0.200
     0.584     4.035     0.200
     0.548     4.255     0.200
     0.686     5.552     0.200
     0.951     6.353     0.200
     1.250     8.266     0.200
     1.275     9.765     0.200
     1.290    10.301     0.200
     1.422     9.459     0.200
     1.575    10.366     0.200
     1.713    10.860     0.200
     1.813    11.898     0.200
     0.226     2.472     0.200
     0.355     3.465     0.200
     0.566     5.007     0.200
     0.605     4.045     0.200
     1.015     6.261     0.200
     1.082     8.680     0.200
     1.360     8.445     0.200
     1.536     9.986     0.200
     1.625    10.743     0.200
     1.921    12.484     0.200
     2.247    12.881     0.200
     0.308     2.587     0.200
     0.376     2.986     0.200
     0.561     4.530     0.200
     0.586     4.039     0.200
     0.676     5.583     0.200
     0.948     6.909     0.200
     1.237     8.440     0.200
     1.232     8.799     0.200
     1.426     9.442     0.200
     1.564    10.529     0.200
     1.807    12.388     0.200
     0.267     2.373     0.200
     0.372     3.337     0.200
     0.524     4.265     0.200
     0.617     4.590     0.200
     1.042     6.426     0.200
     1.074     7.647     0.200
     1.337     8.281     0.200
     1.925    12.323     0.200
     2.258    13.035     0.200
     2.520    14.972     0.200
     0.159     1.607     0.200
     0.285     2.535     0.200
     0.333     3.272     0.200
     0.478     3.180     0.200
     0.658     4.882     0.200
     0.729     5.552     0.200
     1.064     7.344     0.200
     1.201     8.147     0.200
     1.201     9.546     0.200
     1.266     8.581     0.200
     1.326     8.188     0.200
     1.566    10.381     0.200
     1.759    10.831     0.200
     1.759    11.928     0.200
     1.894    12.762     0.200
     2.602    15.587     0.200
     3.614    21.784     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.695    34.445     0.200
     1.823    35.254     0.200
     2.552    42.039     0.200
     3.014    49.346     0.200
     3.621    55.372     0.200
     3.661    56.398     0.200
     4.862    69.390     0.200
     5.041    73.795     0.200
     1.902    34.222     0.200
     3.245    51.847     0.200
     3.350    52.524     0.200
    13.284   178.196     0.200
    13.492   176.274     0.200
    15.011   203.538     0.200
    15.732   212.129     0.200
    16.332   223.126     0.200
    17.884   239.018     0.200
    18.126   242.186     0.200
     2.728    44.527     0.200
     2.752    44.854     0.200
     3.227    52.305     0.200
     3.876    59.736     0.200
     1.163    26.110     0.200
     1.605    31.359     0.200
     2.391    39.578     0.200
     2.507    42.232     0.200
     2.504    41.757     0.200
     3.142    49.414     0.200
     3.662    58.753     0.200
     3.744    54.597     0.200
     4.570    69.955     0.200
     4.702    65.908     0.200
     1.359    27.213     0.200
     1.654    31.764     0.200
     2.207    36.918     0.200
     2.657    42.069     0.200
     4.044    57.484     0.200
     1.462    28.554     0.200
     2.557    40.883     0.200
     2.642    41.993     0.200
     2.976    47.691     0.200
     3.254    50.551     0.200
     4.723    64.402     0.200
     2.261    38.459     0.200
     2.641    39.434     0.200
     2.723    43.773     0.200
     2.894    47.275     0.200
     3.338    50.990     0.200
     3.881    54.556     0.200
     4.166    61.326     0.200
     4.332    64.991     0.200
     4.713    65.150     0.200
     1.429    29.179     0.200
     1.477    28.827     0.200
     2.675    42.543     0.200
     2.934    43.818     0.200
     3.292    51.641     0.200
     3.456    52.032     0.200
     3.876    57.830     0.200
     3.999    59.388     0.200
     4.126    60.208     0.200
     4.365    64.717     0.200
     4.442    66.022     0.200
     4.733    66.128     0.200
     4.769    68.604     0.200
     5.763    81.503     0.200
     2.299    40.143     0.200
     2.911    47.808     0.200
     3.391    51.702     0.200
     3.670    54.142     0.200
     4.117    60.737     0.200
     4.450    63.440     0.200
     4.848    68.302     0.200
     5.766    84.688     0.200
     5.975    84.254     0.200
     6.196    91.170     0.200
     6.309    89.551     0.200
     7.463   101.081     0.200
     2.979    49.499     0.200
     3.767    58.699     0.200
     4.855    75.108     0.200
     2.282    40.083     0.200
     2.570    44.616     0.200
     2.701    42.895     0.200
     3.071    47.672     0.200
     3.413    53.580     0.200
     3.874    57.801     0.200
     4.298    63.453     0.200
     4.393    65.144     0.200
     5.229    77.286     0.200
     1.916    38.344     0.200
     3.717    57.127     0.200
     4.330    62.775     0.200
     1.443    30.678     0.200
     1.770    36.660     0.200
     2.537    43.912     0.200
     2.665    45.420     0.200
     3.004    51.170     0.200
     3.256    50.731     0.200
     3.540    55.709     0.200
     4.637    66.406     0.200
     4.870    72.296     0.200
     1.818    36.958     0.200
     2.345    39.509     0.200
     2.637    44.495     0.200
     2.637    44.897     0.200
     2.532    42.423     0.200
     3.418    54.084     0.200
     3.829    57.888     0.200
     4.360    64.197     0.200
     4.360    64.096     0.200
     4.747    73.873     0.200
     5.197    78.620     0.200
     1.377    28.107     0.200
     2.713    44.124     0.200
     3.063    48.734     0.200
     4.995    76.784     0.200
     5.270    77.381     0.200
     1.509    33.300     0.200
     1.614    33.075     0.200
     2.573    44.587     0.200
     2.737    46.171     0.200
     2.737    46.069     0.200
     3.193    49.952     0.200
     3.262    52.841     0.200
     3.827    58.743     0.200
     4.181    63.711     0.200
     4.181    62.812     0.200
     5.310    78.640     0.200
     6.909    97.174     0.200
     1.375    28.369     0.200
     1.719    35.160     0.200
     1.809    36.708     0.200
     2.127    38.790     0.200
     2.353    41.762     0.200
     2.717    44.910     0.200
     3.421    55.995     0.200
     3.643    54.701     0.200
     4.576    66.020     0.200
     4.864    72.055     0.200
     5.256    79.981     0.200
     1.804    35.605     0.200
     2.368    39.821     0.200
     2.503    43.254     0.200
     2.644    44.302     0.200
     3.155    51.048     0.200
     3.454    53.959     0.200
     3.864    60.467     0.200
     4.384    65.597     0.200
     5.161    76.729     0.200
     7.027    99.760     0.200
     1.467    29.740     0.200
     1.741    33.847     0.200
     1.782    35.363     0.200
     2.718    44.740     0.200
     1.314    28.613     0.200
     1.582    31.886     0.200
     1.621    33.531     0.200
     1.621    32.633     0.200
     1.650    33.790     0.200
     1.882    37.185     0.200
     2.218    38.361     0.200
     2.569    42.164     0.200
     2.569    45.164     0.200
     2.574    44.416     0.200
     2.574    43.416     0.200
     2.683    44.633     0.200
     4.138    61.359     0.200
     4.165    61.643     0.200
     4.287    64.726     0.200
     4.411    63.870     0.200
     4.411    64.667     0.200
     4.773    71.452     0.200
     5.209    77.363     0.200
     5.549    81.195     0.200
     7.459   105.806     0.200
     8.222   110.181     0.200
    13.963   191.449     0.200
     1.395    28.541     0.200
     1.664    31.596     0.200
     1.734    36.481     0.200
     2.209    38.043     0.200
     2.500    42.538     0.200
     2.657    43.315     0.200
     3.375    51.331     0.200
     5.277    77.431     0.200
     1.429    28.749     0.200
     1.469    28.878     0.200
     2.203    36.117     0.200
     3.102    46.629     0.200
     1.835    36.605     0.200
     1.135    24.520     0.200
     1.203    24.524     0.200
     1.452    29.125     0.200
     1.452    28.926     0.200
     1.662    32.465     0.200
     2.203    37.559     0.200
     2.561    42.679     0.200
     2.695    42.319     0.200
     4.918    73.875     0.200
     6.821    96.358     0.200
     1.539    29.465     0.200
     1.842    35.931     0.200
     2.753    42.099     0.200
     3.059    46.420     0.200
     4.025    59.755     0.200
     1.700    33.215     0.200
     1.701    33.505     0.200
     1.715    33.146     0.200
     1.353    28.280     0.200
     1.890    38.112     0.200
     2.269    38.384     0.200
     2.269    38.583     0.200
     2.573    42.641     0.200
     2.573    42.742     0.200
     2.606    43.754     0.200
     2.606    43.855     0.200
     3.065    49.196     0.200
     3.384    54.080     0.200
     4.368    64.586     0.200
     4.368    65.086     0.200
     5.256    78.026     0.200
     5.536    81.260     0.200
     1.463    29.171     0.200
     1.821    33.891     0.200
     2.370    40.288     0.200
     2.529    41.326     0.200
     2.622    43.342     0.200
     3.004    47.482     0.200
     3.527    55.583     0.200
     3.822    55.136     0.200
     4.056    59.312     0.200
     4.437    66.868     0.200
     4.837    71.690     0.200
     1.243    25.926     0.200
     1.793    34.407     0.200
     2.754    45.788     0.200
     3.462    54.022     0.200
     5.312    79.941     0.200
     1.642    31.773     0.200
     1.642    32.070     0.200
     1.785    35.502     0.200
     1.820    36.704     0.200
     2.175    36.957     0.200
     2.715    44.851     0.200
     3.399    51.865     0.200
     3.399    51.466     0.200
     4.136    59.963     0.200
     4.136    62.260     0.200
     4.724    70.902     0.200
     5.643    82.483     0.200
     6.096    86.695     0.200
     6.082    86.160     0.200
     1.710    32.253     0.200
     1.710    33.054     0.200
     1.687    33.820     0.200
     1.695    34.829     0.200
     2.612    42.329     0.200
     2.855    45.590     0.200
     3.139    50.172     0.200
     3.269    50.358     0.200
     3.405    53.172     0.200
     5.499    80.234     0.200
     5.930    85.301     0.200
     5.930    85.704     0.200
     1.492    29.307     0.200
     1.492    29.205     0.200
     2.643    40.179     0.200
     2.314    40.302     0.200
     2.569    41.626     0.200
     3.526    55.051     0.200
     4.340    64.959     0.200
     1.498    28.884     0.200
     1.522    30.797     0.200
     1.499    31.618     0.200
     2.073    36.823     0.200
     2.332    40.696     0.200
     2.840    46.873     0.200
     2.775    46.722     0.200
     4.536    66.671     0.200
     4.536    66.272     0.200
     4.931    76.060     0.200
     4.931    76.263     0.200
     5.327    78.948     0.200
     5.855    88.745     0.200
    16.406   217.355     0.200
    17.743   237.757     0.200
     1.624    33.446     0.200
     1.900    38.326     0.200
     1.900    38.926     0.200
     1.944    41.418     0.200
     2.506    43.953     0.200
     2.831    46.461     0.200
     2.831    47.561     0.200
     2.879    48.801     0.200
     2.879    47.901     0.200
     2.993    48.165     0.200
     2.993    48.365     0.200
     3.196    51.607     0.200
     3.213    51.600     0.200
     3.492    56.647     0.200
     3.602    56.965     0.200
     4.166    65.586     0.200
     4.345    65.591     0.200
     4.581    66.038     0.200
     5.082    77.498     0.200
     5.082    76.798     0.200
     5.506    83.249     0.200
     6.663    94.838     0.200
    12.722   177.033     0.200
    14.925   202.924     0.200
    15.028   198.117     0.200
     1.852    37.261     0.200
     2.833    46.918     0.200
     2.871    47.474     0.200
     3.227    50.819     0.200
     3.227    51.518     0.200
     5.071    78.998     0.200
     5.298    78.746     0.200
     5.494    82.066     0.200
     1.371    27.405     0.200
     1.396    27.214     0.200
     1.440    29.599     0.200
     2.779    43.765     0.200
     3.579    52.631     0.200
     4.286    60.185     0.200
     4.286    60.888     0.200
     4.307    63.340     0.200
     4.871    70.563     0.200
     5.262    77.198     0.200
     5.785    82.392     0.200
     5.968    83.651     0.200
     6.184    88.830     0.200
     1.823    36.808     0.200
     1.859    35.092     0.200
     1.859    37.592     0.200
     1.859    37.389     0.200
     2.316    40.748     0.200
     2.447    41.619     0.200
     2.832    46.533     0.200
     2.774    46.015     0.200
     2.774    46.609     0.200
     2.851    45.301     0.200
     3.205    52.985     0.200
     3.455    53.461     0.200
     3.455    53.063     0.200
     3.479    53.289     0.200
     3.586    55.429     0.200
     4.564    66.424     0.200
     4.564    67.025     0.200
     4.922    76.536     0.200
     4.922    76.239     0.200
     5.312    79.484     0.200
     5.871    89.139     0.200
     6.841    96.146     0.200
    16.430   216.733     0.200
    17.760   237.223     0.200
     1.265    26.726     0.200
     1.424    28.569     0.200
     1.695    32.208     0.200
     1.734    33.248     0.200
     2.178    38.265     0.200
     2.474    41.608     0.200
     2.687    44.131     0.200
     2.967    47.055     0.200
     2.967    46.856     0.200
     3.382    50.309     0.200
     3.382    52.211     0.200
     3.404    52.653     0.200
     3.677    56.276     0.200
     3.677    57.675     0.200
     3.962    59.248     0.200
     4.422    63.376     0.200
     4.422    63.876     0.200
     4.401    64.025     0.200
     4.401    66.126     0.200
     4.877    73.165     0.200
     5.439    76.714     0.200
     5.713    85.718     0.200
     6.630    91.013     0.200
     6.869    95.027     0.200
     6.869    96.624     0.200
     1.627    33.145     0.200
     1.669    34.155     0.200
     1.710    35.174     0.200
     1.710    36.674     0.200
     2.647    44.538     0.200
     3.047    48.373     0.200
     3.373    54.768     0.200
     4.864    75.469     0.200
     5.310    80.267     0.200
     6.876    96.785     0.200
     1.448    29.619     0.200
     1.448    28.915     0.200
     1.558    31.025     0.200
     1.764    34.527     0.200
     2.699    43.113     0.200
     2.993    48.678     0.200
     3.310    51.277     0.200
     4.401    62.247     0.200
     5.348    78.595     0.200
     5.348    80.294     0.200
     1.277    26.429     0.200
     5.856    82.284     0.200
     1.512    30.737     0.200
     1.712    34.097     0.200
     1.911    38.174     0.200
     2.236    39.384     0.200
     2.649    44.368     0.200
     2.649    44.470     0.200
     3.043    48.469     0.200
     4.333    64.007     0.200
     5.309    78.530     0.200
     6.876    97.033     0.200
     1.097    26.211     0.200
     1.392    30.273     0.200
     1.491    31.307     0.200
     1.599    31.948     0.200
     1.649    33.674     0.200
     1.830    36.250     0.200
     2.690    44.219     0.200
     2.856    47.185     0.200
     4.079    60.915     0.200
     4.961    74.310     0.200
     5.451    78.093     0.200
     1.316    27.316     0.200
     1.318    27.896     0.200
     1.318    27.498     0.200
     1.577    31.466     0.200
     2.299    39.443     0.200
     2.591    43.235     0.200
     4.312    63.455     0.200
     4.543    68.753     0.200
     5.028    74.701     0.200
     7.194   100.916     0.200
     1.633    32.845     0.200
     1.636    32.713     0.200
     2.457    42.230     0.200
     2.608    44.473     0.200
     3.239    53.004     0.200
     3.766    60.457     0.200
     4.675    72.744     0.200
     5.068    76.957     0.200
     1.513    31.129     0.200
     1.628    33.285     0.200
     2.644    42.625     0.200
     3.043    48.568     0.200
     4.340    64.933     0.200
     4.340    65.332     0.200
     4.858    74.689     0.200
     4.858    75.892     0.200
     5.257    74.531     0.200
     5.302    79.215     0.200
     5.510    82.187     0.200
     5.624    85.896     0.200
     6.882    97.169     0.200
    12.623   175.678     0.200
    12.735   175.864     0.200
    14.264   188.626     0.200
    14.276   185.584     0.200
    15.102   204.545     0.200
    16.652   226.356     0.200
    16.991   226.702     0.200
     1.620    32.522     0.200
     2.575    43.765     0.200
     2.575    42.968     0.200
     2.640    43.924     0.200
     4.329    63.803     0.200
     4.856    75.247     0.200
     5.303    78.640     0.200
     1.622    33.250     0.200
     4.344    64.091     0.200
     4.851    70.673     0.200
     5.294    80.098     0.200
     1.619    32.470     0.200
     2.637    43.290     0.200
     3.052    48.544     0.200
     3.735    55.476     0.200
     4.336    65.162     0.200
     4.336    64.365     0.200
     5.297    80.345     0.200
     6.888    97.181     0.200
     1.100    26.080     0.200
     1.514    30.952     0.200
     1.634    32.856     0.200
     1.634    33.856     0.200
     1.915    38.477     0.200
     2.654    44.553     0.200
     3.040    48.147     0.200
     3.327    51.990     0.200
     4.354    66.904     0.200
     4.869    76.097     0.200
     4.869    76.394     0.200
     5.314    77.607     0.200
     5.509    84.532     0.200
     5.624    85.248     0.200
     6.670    94.880     0.200
     6.871    97.240     0.200
     1.191    27.082     0.200
     1.639    33.750     0.200
     1.920    38.380     0.200
     2.660    44.542     0.200
     3.035    48.266     0.200
     4.876    76.084     0.200
     1.081    25.850     0.200
     1.170    26.912     0.200
     1.385    30.202     0.200
     1.615    33.517     0.200
     1.898    38.320     0.200
     2.634    45.033     0.200
     3.056    47.901     0.200
     5.269    74.681     0.200
     5.296    78.869     0.200
     1.622    33.689     0.200
     1.664    34.297     0.200
     1.904    39.106     0.200
     3.051    48.917     0.200
     4.329    64.998     0.200
     5.305    80.911     0.200
     6.881    97.322     0.200
     1.606    33.750     0.200
     1.648    34.463     0.200
     1.889    38.353     0.200
     1.505    30.145     0.200
     1.621    32.098     0.200
     1.904    37.897     0.200
     2.571    43.514     0.200
     2.638    43.622     0.200
     4.337    63.001     0.200
     1.539    30.629     0.200
     1.655    32.878     0.200
     1.736    36.741     0.200
     2.538    41.882     0.200
     4.350    64.629     0.200
     1.638    32.970     0.200
     1.680    33.684     0.200
     1.921    38.070     0.200
     4.342    64.110     0.200
     6.874    96.869     0.200
     1.287    26.409     0.200
     1.287    26.308     0.200
     1.635    31.849     0.200
     1.635    32.052     0.200
     1.813    36.774     0.200
     2.163    37.187     0.200
     2.511    40.831     0.200
     2.562    43.032     0.200
     3.391    50.755     0.200
     6.065    83.854     0.200
     1.243    26.316     0.200
     1.610    29.643     0.200
     2.616    43.403     0.200
     2.616    43.000     0.200
     2.823    43.987     0.200
     3.062    47.989     0.200
     3.013    47.468     0.200
     5.081    75.431     0.200
     5.553    83.018     0.200
     1.086    25.533     0.200
     1.507    32.120     0.200
     1.621    33.290     0.200
     1.662    34.505     0.200
     1.904    37.277     0.200
     2.569    43.724     0.200
     2.637    44.530     0.200
     3.050    47.807     0.200
     3.418    55.511     0.200
     4.341    64.743     0.200
     5.295    80.008     0.200
     6.889    97.503     0.200
     1.702    33.935     0.200
     1.761    33.741     0.200
     1.797    35.627     0.200
     3.416    54.031     0.200
     3.416    55.531     0.200
     4.557    66.316     0.200
     4.863    75.046     0.200
     5.259    78.923     0.200
     1.356    27.092     0.200
     1.492    28.109     0.200
     1.631    31.283     0.200
     1.631    30.283     0.200
     2.117    35.709     0.200
     2.154    36.378     0.200
     2.760    42.803     0.200
     2.796    44.392     0.200
     3.306    50.532     0.200
     4.016    57.548     0.200
     4.214    64.232     0.200
     4.614    67.367     0.200
     4.820    67.265     0.200
     4.820    67.066     0.200
     2.263    39.159     0.200
     2.578    42.482     0.200
     2.692    44.452     0.200
     4.657    66.719     0.200
     1.632    32.513     0.200
     1.674    34.325     0.200
     2.234    39.383     0.200
     2.565    43.529     0.200
     2.565    42.927     0.200
     2.651    44.719     0.200
     3.041    48.162     0.200
     3.721    57.228     0.200
     4.332    64.302     0.200
     5.311    81.474     0.200
     5.511    78.048     0.200
     6.873    96.045     0.200
     1.504    30.334     0.200
     1.625    33.124     0.200
     2.573    44.456     0.200
     2.646    44.104     0.200
     1.086    24.719     0.200
     1.392    28.749     0.200
     1.501    29.776     0.200
     1.619    32.894     0.200
     2.639    42.488     0.200
     1.579    31.097     0.200
     1.579    31.398     0.200
     1.790    35.230     0.200
     1.884    37.139     0.200
     1.997    35.515     0.200
     2.286    38.851     0.200
     2.775    44.239     0.200
     2.854    46.418     0.200
     3.374    51.847     0.200
     3.374    52.148     0.200
     3.506    53.810     0.200
     3.563    55.046     0.200
     5.405    79.144     0.200
     5.405    79.845     0.200
     6.748    94.273     0.200
     1.391    30.250     0.200
     1.510    32.362     0.200
     1.666    34.142     0.200
     2.242    39.517     0.200
     2.566    44.237     0.200
     2.641    44.564     0.200
     3.046    48.230     0.200
     3.342    50.579     0.200
     3.366    53.707     0.200
     3.366    55.605     0.200
     4.088    58.281     0.200
     4.341    64.521     0.200
     5.299    81.252     0.200
     5.516    79.411     0.200
     5.507    83.610     0.200
     6.886    97.529     0.200
     1.389    30.163     0.200
     1.505    30.412     0.200
     1.505    32.310     0.200
     2.638    44.783     0.200
     3.051    48.067     0.200
     3.051    50.067     0.200
     3.341    52.085     0.200
     3.341    49.992     0.200
     3.363    53.226     0.200
     4.337    64.869     0.200
     4.337    64.564     0.200
     4.853    71.737     0.200
     4.853    74.839     0.200
     5.298    78.342     0.200
     6.887    96.702     0.200
     2.313    38.649     0.200
     2.288    38.142     0.200
     3.233    50.017     0.200
     3.543    53.001     0.200
     4.267    61.548     0.200
     4.740    66.831     0.200
     4.740    68.831     0.200
     4.825    68.741     0.200
     5.738    82.283     0.200
     5.788    81.396     0.200
     6.130    86.710     0.200
     1.660    34.150     0.200
     1.660    33.650     0.200
     2.635    43.173     0.200
     3.052    48.202     0.200
     3.052    48.506     0.200
     3.346    52.379     0.200
     4.340    64.471     0.200
     5.294    77.646     0.200
     6.891    97.003     0.200
     1.667    34.409     0.200
     1.909    38.478     0.200
     2.241    40.100     0.200
     2.241    39.100     0.200
     2.564    42.440     0.200
     2.564    43.241     0.200
     2.640    44.647     0.200
     3.045    49.321     0.200
     3.730    58.426     0.200
     4.087    61.461     0.200
     4.344    65.061     0.200
     4.344    64.663     0.200
     5.297    78.848     0.200
     5.515    79.900     0.200
     1.714    35.166     0.200
     1.967    39.816     0.200
     2.497    42.836     0.200
     2.988    48.500     0.200
     3.950    59.572     0.200
     4.043    59.397     0.200
     4.383    64.023     0.200
     4.407    65.641     0.200
     4.407    65.540     0.200
     5.221    74.841     0.200
     5.221    75.443     0.200
     5.294    78.988     0.200
     5.294    80.887     0.200
     5.460    77.959     0.200
     5.690    84.970     0.200
     1.146    26.403     0.200
     4.399    65.534     0.200
     1.709    35.292     0.200
     1.964    39.414     0.200
     2.663    45.360     0.200
     2.992    46.423     0.200
     2.992    47.123     0.200
     3.941    59.648     0.200
     4.416    65.308     0.200
     5.228    75.128     0.200
     5.284    80.976     0.200
     6.888    98.451     0.200
     1.709    35.372     0.200
     1.960    39.945     0.200
     2.506    42.773     0.200
     4.396    65.215     0.200
     4.867    75.919     0.200
     5.298    79.093     0.200
     5.298    80.593     0.200
     6.877    98.167     0.200
     1.722    35.499     0.200
     2.490    41.830     0.200
     2.490    44.029     0.200
     2.678    46.443     0.200
     2.981    48.298     0.200
     3.397    56.251     0.200
     4.409    65.538     0.200
     4.409    64.835     0.200
     4.872    75.333     0.200
     5.214    77.440     0.200
     5.300    80.646     0.200
     5.452    77.363     0.200
     6.873    97.586     0.200
     1.574    31.854     0.200
     1.574    33.754     0.200
     1.714    34.824     0.200
     1.965    39.685     0.200
     2.671    45.546     0.200
     2.990    48.128     0.200
     3.391    55.048     0.200
     4.383    66.573     0.200
     4.402    64.245     0.200
     5.297    79.303     0.200
     6.876    97.676     0.200
     1.136    26.224     0.200
     1.415    30.665     0.200
     1.576    31.388     0.200
     1.576    33.487     0.200
     1.717    35.246     0.200
     1.717    33.846     0.200
     1.968    39.412     0.200
     2.194    38.474     0.200
     4.401    65.018     0.200
     5.301    79.918     0.200
     1.405    28.357     0.200
     1.511    30.220     0.200
     1.511    31.517     0.200
     1.674    33.617     0.200
     1.674    33.718     0.200
     2.234    38.787     0.200
     2.653    44.194     0.200
     3.042    48.150     0.200
     3.325    50.753     0.200
     3.720    57.737     0.200
     3.720    57.839     0.200
     4.327    63.859     0.200
     4.327    62.758     0.200
     4.870    73.926     0.200
     5.315    79.028     0.200
     5.511    75.940     0.200
     6.870    97.378     0.200
     1.498    30.698     0.200
     1.611    32.387     0.200
     1.611    32.988     0.200
     1.875    37.900     0.200
     2.573    42.260     0.200
     2.573    40.760     0.200
     2.559    43.924     0.200
     2.559    43.123     0.200
     3.085    47.580     0.200
     3.277    51.436     0.200
     4.273    64.111     0.200
     4.424    65.650     0.200
     4.424    65.549     0.200
     4.755    70.792     0.200
     4.755    71.190     0.200
     5.190    76.115     0.200
     5.558    79.224     0.200
     6.988    99.234     0.200
     1.103    27.756     0.200
     1.524    32.437     0.200
     1.680    34.125     0.200
     2.552    43.253     0.200
     2.653    43.975     0.200
     3.032    47.645     0.200
     4.074    63.281     0.200
     4.348    64.880     0.200
     4.348    65.786     0.200
     5.305    80.713     0.200
     5.502    78.622     0.200
     5.635    86.585     0.200
     6.877    97.473     0.200
    12.634   175.496     0.200
    16.311   219.274     0.200
    17.394   231.340     0.200
     1.394    28.444     0.200
     1.520    30.570     0.200
     1.520    32.171     0.200
     1.673    34.280     0.200
     1.917    38.439     0.200
     2.235    38.020     0.200
     2.645    43.538     0.200
     3.038    50.954     0.200
     3.038    47.352     0.200
     3.348    54.736     0.200
     3.725    60.935     0.200
     4.351    63.834     0.200
     4.351    64.134     0.200
     4.856    74.433     0.200
     5.631    86.188     0.200
    14.261   188.685     0.200
    14.873   197.731     0.200
    17.401   233.735     0.200
     1.278    27.566     0.200
     1.604    33.166     0.200
     1.875    37.806     0.200
     4.451    64.836     0.200
     1.795    36.291     0.200
     1.810    36.820     0.200
     2.674    45.346     0.200
     2.692    44.632     0.200
     3.338    52.784     0.200
     1.497    30.509     0.200
     1.690    34.664     0.200
     1.690    41.461     0.200
     1.894    38.082     0.200
     2.625    43.251     0.200
     2.879    46.689     0.200
     3.061    48.760     0.200
     4.341    64.317     0.200
     5.285    78.911     0.200
     6.901    94.951     0.200
     6.901    97.150     0.200
     1.423    29.160     0.200
     4.506    64.682     0.200
     1.394    28.242     0.200
     1.525    30.612     0.200
     2.232    38.355     0.200
     2.253    38.614     0.200
     2.550    41.348     0.200
     2.646    43.522     0.200
     2.900    46.272     0.200
     3.034    46.905     0.200
     3.352    51.191     0.200
     3.370    51.982     0.200
     3.723    55.162     0.200
     4.357    62.663     0.200
     4.351    64.729     0.200
     4.856    74.738     0.200
     5.296    76.303     0.200
     6.675    92.615     0.200
     6.885    93.857     0.200
     6.885    96.158     0.200
     1.419    28.594     0.200
     1.545    31.521     0.200
     1.808    36.557     0.200
     2.201    38.865     0.200
     2.885    48.090     0.200
     4.428    70.689     0.200
     4.904    74.830     0.200
     6.859    96.506     0.200
     7.310   102.349     0.200
     2.469    37.988     0.200
     2.867    44.253     0.200
     3.127    46.020     0.200
     3.607    53.708     0.200
     4.209    60.391     0.200
     5.130    75.838     0.200
     6.608    93.189     0.200
     1.448    28.497     0.200
     1.509    30.482     0.200
     2.171    37.660     0.200
     2.701    43.076     0.200
     2.921    47.402     0.200
     3.470    53.294     0.200
     4.395    65.004     0.200
     4.886    69.069     0.200
     7.334   101.705     0.200
     1.456    28.934     0.200
     1.507    30.733     0.200
     1.801    35.805     0.200
     2.429    39.778     0.200
     2.421    40.874     0.200
     2.630    44.633     0.200
     2.669    42.380     0.200
     3.181    48.405     0.200
     3.181    50.304     0.200
     3.132    49.370     0.200
     3.132    51.370     0.200
     3.556    53.929     0.200
     3.603    56.481     0.200
     3.684    56.125     0.200
     3.939    58.951     0.200
     4.272    63.473     0.200
     4.515    65.830     0.200
     4.599    72.150     0.200
     5.029    73.831     0.200
     5.655    78.928     0.200
     7.146   100.529     0.200
    14.614   198.181     0.200
    16.565   223.406     0.200
     1.405    30.816     0.200
     1.507    30.525     0.200
     1.672    34.504     0.200
     1.909    38.537     0.200
     4.322    64.376     0.200
     4.870    76.980     0.200
     5.316    76.268     0.200
     5.316    79.168     0.200
     6.870    97.640     0.200
     1.389    30.233     0.200
     1.498    30.857     0.200
     1.898    38.697     0.200
     2.578    41.258     0.200
     2.578    41.555     0.200
     3.057    47.572     0.200
     4.095    60.948     0.200
     4.329    64.624     0.200
     4.329    65.124     0.200
     4.337    61.830     0.200
     5.300    79.088     0.200
     6.886    98.378     0.200
     1.173    27.108     0.200
     1.501    32.776     0.200
     1.662    34.103     0.200
     1.703    34.922     0.200
     1.901    38.812     0.200
     2.575    43.744     0.200
     2.764    43.647     0.200
     2.895    47.520     0.200
     3.053    48.871     0.200
     3.333    51.809     0.200
     3.421    50.878     0.200
     4.091    61.753     0.200
     4.328    63.593     0.200
     4.328    64.792     0.200
     4.858    76.011     0.200
     5.304    79.102     0.200
     5.304    77.301     0.200
     6.882    97.885     0.200
     1.164    26.458     0.200
     1.389    28.734     0.200
     1.492    30.132     0.200
     1.492    31.928     0.200
     1.655    33.633     0.200
     1.655    33.735     0.200
     1.893    38.255     0.200
     2.253    37.153     0.200
     2.585    41.280     0.200
     2.585    44.483     0.200
     2.635    43.192     0.200
     2.760    43.937     0.200
     3.062    49.615     0.200
     3.739    54.018     0.200
     4.320    64.426     0.200
     4.320    64.926     0.200
     4.855    73.190     0.200
     4.855    73.792     0.200
     5.303    76.560     0.200
     6.885    96.303     0.200
     1.466    29.840     0.200
     1.525    31.045     0.200
     1.759    33.522     0.200
     2.290    37.718     0.200
     3.017    47.135     0.200
     3.353    50.712     0.200
     3.738    54.717     0.200
     4.361    64.358     0.200
     4.720    68.364     0.200
     5.212    75.227     0.200
     5.624    81.717     0.200
     6.538    89.651     0.200
     1.268    25.344     0.200
     1.517    29.739     0.200
     2.507    41.379     0.200
     2.763    43.899     0.200
     2.958    47.925     0.200
     3.241    48.321     0.200
     5.423    80.255     0.200
     1.107    25.507     0.200
     1.277    26.522     0.200
     1.358    28.181     0.200
     1.396    29.334     0.200
     1.615    32.581     0.200
     2.338    39.944     0.200
     2.594    43.856     0.200
     2.829    45.716     0.200
     5.058    75.602     0.200
     5.264    77.495     0.200
     1.106    25.330     0.200
     1.358    27.891     0.200
     1.396    29.350     0.200
     1.616    32.678     0.200
     2.827    44.046     0.200
     4.397    60.926     0.200
     5.056    76.736     0.200
     1.545    30.697     0.200
     1.544    30.509     0.200
     2.423    40.043     0.200
     2.498    40.468     0.200
     2.498    41.669     0.200
     2.667    41.394     0.200
     3.147    48.091     0.200
     3.125    49.054     0.200
     3.680    54.379     0.200
     3.661    58.199     0.200
     4.611    65.515     0.200
     4.611    65.015     0.200
     4.573    71.956     0.200
     4.983    72.067     0.200
     4.983    74.267     0.200
     7.181   100.226     0.200
     1.350    27.859     0.200
     1.408    28.979     0.200
     1.654    32.812     0.200
     1.720    34.740     0.200
     2.391    39.007     0.200
     2.512    41.698     0.200
     2.906    45.795     0.200
     3.179    50.115     0.200
     3.179    49.521     0.200
     3.160    50.834     0.200
     3.631    55.941     0.200
     4.321    63.381     0.200
     5.114    77.442     0.200
     5.114    77.036     0.200
     5.282    75.971     0.200
     5.540    82.862     0.200
     5.681    82.912     0.200
     6.630    93.640     0.200
    14.013   186.986     0.200
     1.149    23.501     0.200
     1.475    29.790     0.200
     1.480    28.831     0.200
     1.743    34.273     0.200
     4.374    63.462     0.200
     4.391    61.770     0.200
     1.373    26.796     0.200
     1.373    28.397     0.200
     1.514    30.157     0.200
     2.234    37.360     0.200
     2.560    40.255     0.200
     2.627    42.770     0.200
     2.744    44.105     0.200
     2.880    45.319     0.200
     3.048    46.555     0.200
     3.350    51.231     0.200
     3.918    59.600     0.200
     5.276    77.655     0.200
     5.518    79.123     0.200
     1.372    27.583     0.200
     1.517    30.295     0.200
     1.696    35.007     0.200
     2.556    39.862     0.200
     1.136    24.366     0.200
     1.432    28.904     0.200
     1.553    31.195     0.200
     1.752    36.380     0.200
     2.196    36.799     0.200
     2.292    39.078     0.200
     2.525    41.558     0.200
     2.685    43.188     0.200
     2.803    45.912     0.200
     2.938    47.031     0.200
     3.409    52.342     0.200
     3.977    60.011     0.200
     4.351    63.039     0.200
     4.389    63.401     0.200
     4.894    74.008     0.200
     5.332    77.896     0.200
     1.170    27.426     0.200
     1.499    30.587     0.200
     1.499    32.286     0.200
     1.658    34.236     0.200
     5.298    80.755     0.200
     1.079    23.085     0.200
     1.079    25.683     0.200
     1.168    26.944     0.200
     1.613    32.149     0.200
     1.613    33.450     0.200
     1.654    33.565     0.200
     1.895    38.055     0.200
     4.333    64.107     0.200
     4.848    72.999     0.200
     5.272    72.051     0.200
     1.352    26.814     0.200
     1.375    27.940     0.200
     1.438    28.814     0.200
     1.487    28.336     0.200
     1.720    34.322     0.200
     2.209    38.013     0.200
     2.274    37.848     0.200
     2.904    46.591     0.200
     2.904    45.497     0.200
     4.348    66.344     0.200
     4.684    64.024     0.200
     4.766    68.669     0.200
     1.082    25.866     0.200
     1.388    28.291     0.200
     1.497    30.718     0.200
     1.698    35.072     0.200
     1.896    38.361     0.200
     2.636    43.328     0.200
     4.327    64.088     0.200
     4.853    73.254     0.200
     5.493    80.682     0.200
     1.082    25.945     0.200
     1.658    33.721     0.200
     1.658    33.822     0.200
     1.698    34.756     0.200
     1.900    38.504     0.200
     2.250    39.516     0.200
     2.574    42.337     0.200
     2.634    44.335     0.200
     3.344    50.957     0.200
     3.344    54.652     0.200
     3.359    56.076     0.200
     4.337    65.862     0.200
     4.337    64.659     0.200
     4.849    76.390     0.200
     4.849    76.187     0.200
     5.294    80.695     0.200
     5.613    85.737     0.200
     6.891    97.854     0.200
     1.453    28.604     0.200
     1.676    33.796     0.200
     1.756    35.570     0.200
     1.816    37.365     0.200
     2.336    39.199     0.200
     2.726    42.454     0.200
     2.974    46.756     0.200
     3.972    59.413     0.200
     4.450    64.835     0.200
     4.497    64.675     0.200
     4.894    75.947     0.200
     5.301    75.704     0.200
     6.588    90.573     0.200
     6.859    93.311     0.200
     1.545    31.240     0.200
     1.593    32.483     0.200
     1.593    32.780     0.200
     1.657    34.431     0.200
     1.791    35.865     0.200
     2.224    38.318     0.200
     2.330    40.975     0.200
     2.621    44.282     0.200
     2.621    44.383     0.200
     2.780    45.132     0.200
     2.880    46.254     0.200
     3.202    49.899     0.200
     3.174    49.828     0.200
     3.360    52.055     0.200
     3.789    57.753     0.200
     4.138    61.877     0.200
     4.138    62.377     0.200
     4.288    64.224     0.200
     4.884    77.576     0.200
     5.369    79.615     0.200
     5.459    81.565     0.200
     6.722    96.026     0.200
     6.855    98.074     0.200
     1.114    24.402     0.200
     1.429    29.019     0.200
     1.509    29.182     0.200
     1.642    31.631     0.200
     1.731    34.101     0.200
     2.672    43.110     0.200
     4.298    62.739     0.200
     4.895    74.669     0.200
     1.535    29.508     0.200
     1.597    31.185     0.200
     2.119    34.096     0.200
     2.945    45.658     0.200
     4.293    61.928     0.200
     1.296    28.495     0.200
     1.374    30.587     0.200
     1.923    38.773     0.200
     2.319    41.355     0.200
     2.575    43.762     0.200
     2.857    46.375     0.200
     3.052    51.106     0.200
     3.371    53.279     0.200
     4.297    63.372     0.200
     4.565    70.940     0.200
     4.565    69.740     0.200
     5.051    75.878     0.200
     6.867    94.678     0.200
     6.996   101.477     0.200
     1.483    30.857     0.200
     1.731    34.966     0.200
     2.070    38.012     0.200
     2.425    41.973     0.200
     2.598    43.747     0.200
     2.725    45.663     0.200
     2.720    44.425     0.200
     3.419    53.468     0.200
     3.912    59.321     0.200
     4.311    64.959     0.200
     5.163    79.714     0.200
     7.041    99.501     0.200
    14.190   194.371     0.200
    14.924   205.604     0.200
     1.321    29.153     0.200
     1.711    34.108     0.200
     1.150    25.379     0.200
     1.433    29.276     0.200
     1.476    30.686     0.200
     1.520    32.071     0.200
     1.718    34.460     0.200
     2.465    41.843     0.200
     2.744    44.587     0.200
     2.721    45.054     0.200
     3.196    51.009     0.200
     3.237    48.827     0.200
     3.783    59.960     0.200
     4.286    63.691     0.200
     4.703    68.721     0.200
     5.336    77.331     0.200
     1.514    32.704     0.200
     1.665    34.843     0.200
     1.910    38.588     0.200
     2.244    39.693     0.200
     2.244    39.990     0.200
     2.560    43.198     0.200
     2.560    44.198     0.200
     2.636    43.513     0.200
     3.045    48.740     0.200
     3.045    47.545     0.200
     3.355    54.615     0.200
     4.354    64.862     0.200
     4.354    64.464     0.200
     4.847    74.611     0.200
     4.847    74.212     0.200
     5.288    79.057     0.200
     5.627    87.369     0.200
     6.894    97.820     0.200
    15.115   204.812     0.200
     1.614    32.784     0.200
     1.896    38.191     0.200
     2.239    38.792     0.200
     2.578    41.831     0.200
     2.633    43.893     0.200
     4.332    63.269     0.200
     1.487    29.911     0.200
     1.789    34.486     0.200
     1.856    35.200     0.200
     1.840    36.390     0.200
     1.485    30.427     0.200
     1.487    28.400     0.200
     2.705    44.092     0.200
     2.648    43.248     0.200
     3.102    49.060     0.200
     3.043    46.650     0.200
     3.159    48.292     0.200
     3.333    53.558     0.200
     3.296    50.490     0.200
     4.320    63.245     0.200
     5.163    71.808     0.200
     5.664    79.656     0.200
     6.500    91.400     0.200
     7.131    96.539     0.200
     7.908   103.174     0.200
     9.513   126.243     0.200
    13.882   185.757     0.200
    14.299   193.184     0.200
    22.952   301.622     0.200
     1.081    24.321     0.200
     1.299    26.681     0.200
     1.408    28.606     0.200
     1.410    29.079     0.200
     1.410    30.378     0.200
     2.351    40.495     0.200
     2.351    40.195     0.200
     2.447    40.173     0.200
     2.447    41.573     0.200
     2.600    43.298     0.200
     2.600    44.298     0.200
     2.687    43.779     0.200
     2.687    44.680     0.200
     3.063    49.379     0.200
     3.063    48.985     0.200
     3.063    47.685     0.200
     3.246    50.656     0.200
     3.246    48.456     0.200
     3.621    55.776     0.200
     3.643    55.219     0.200
     3.643    54.120     0.200
     3.618    56.114     0.200
     4.008    60.057     0.200
     4.080    60.926     0.200
     4.340    63.883     0.200
     4.519    67.395     0.200
     4.534    69.929     0.200
     4.534    71.228     0.200
     5.531    78.793     0.200
     5.522    82.849     0.200
     5.720    81.781     0.200
     6.963    95.781     0.200
     6.968    95.623     0.200
     7.210   101.293     0.200
     1.526    30.738     0.200
     1.708    33.711     0.200
     1.783    35.438     0.200
     2.896    46.251     0.200
     3.158    49.496     0.200
     5.177    78.624     0.200
     5.669    84.386     0.200
     1.497    32.223     0.200
     1.621    32.383     0.200
     1.663    33.685     0.200
     1.663    33.786     0.200
     1.706    35.186     0.200
     1.899    38.030     0.200
     2.581    43.471     0.200
     2.645    44.428     0.200
     2.900    47.857     0.200
     3.055    46.644     0.200
     4.315    65.035     0.200
     4.315    65.137     0.200
     4.865    73.519     0.200
     4.865    74.316     0.200
     5.314    78.785     0.200
     6.874    95.077     0.200
     1.872    31.873     0.200
     1.995    34.331     0.200
     2.090    35.932     0.200
     2.636    42.257     0.200
     3.030    46.857     0.200
     3.284    50.493     0.200
     3.346    50.172     0.200
     3.755    56.301     0.200
     4.317    61.540     0.200
     4.319    63.712     0.200
     5.175    71.825     0.200
     5.235    74.827     0.200
     5.654    80.435     0.200
     6.511    88.132     0.200
     7.669   104.722     0.200
     1.082    25.475     0.200
     1.657    33.265     0.200
     2.251    38.643     0.200
     2.242    39.342     0.200
     2.580    41.594     0.200
     2.636    43.441     0.200
     3.362    52.968     0.200
     3.737    57.198     0.200
     3.936    58.971     0.200
     4.096    62.205     0.200
     4.325    64.128     0.200
     4.336    64.103     0.200
     4.854    73.757     0.200
     1.086    25.632     0.200
     1.496    30.338     0.200
     1.660    33.730     0.200
     1.702    34.540     0.200
     2.641    44.286     0.200
     2.765    44.529     0.200
     4.320    64.088     0.200
     1.684    34.396     0.200
     2.295    41.164     0.200
     1.671    33.202     0.200
     1.735    34.850     0.200
     0.964    21.489     0.200
     1.457    29.632     0.200
     2.201    35.853     0.200
     2.980    46.065     0.200
     5.523    77.392     0.200
     1.429    29.426     0.200
     1.487    30.545     0.200
     1.524    30.707     0.200
     1.524    31.707     0.200
     1.550    32.111     0.200
     2.078    37.147     0.200
     2.470    41.870     0.200
     2.645    45.634     0.200
     2.645    42.735     0.200
     2.581    43.575     0.200
     2.721    45.139     0.200
     3.168    49.720     0.200
     3.190    50.573     0.200
     3.503    53.617     0.200
     3.755    59.281     0.200
     3.894    57.859     0.200
     4.424    64.666     0.200
     4.424    64.466     0.200
     4.672    71.977     0.200
     5.115    74.706     0.200
     5.548    83.726     0.200
     5.642    78.658     0.200
     1.348    28.459     0.200
     1.567    31.994     0.200
     1.608    33.215     0.200
     1.646    33.071     0.200
     2.187    36.759     0.200
     2.610    42.730     0.200
     2.581    42.260     0.200
     2.835    45.003     0.200
     3.100    47.308     0.200
     3.879    57.212     0.200
     4.284    64.890     0.200
     4.344    63.391     0.200
     4.797    70.599     0.200
     5.246    76.364     0.200
     5.570    79.080     0.200
     1.489    28.438     0.200
     1.724    34.095     0.200
     1.767    33.804     0.200
     2.141    35.432     0.200
     2.141    37.131     0.200
     2.349    38.711     0.200
     2.488    41.890     0.200
     2.742    43.918     0.200
     2.952    45.664     0.200
     2.996    47.062     0.200
     3.289    50.336     0.200
     3.987    58.992     0.200
     4.950    75.651     0.200
     4.950    73.651     0.200
     5.385    78.680     0.200
     5.702    85.621     0.200
     6.792    93.757     0.200
     6.792    95.658     0.200
    12.041   161.003     0.200
    14.167   187.296     0.200
    16.748   224.267     0.200
     1.296    26.604     0.200
     1.294    26.919     0.200
     1.335    27.746     0.200
     1.335    28.146     0.200
     2.319    39.162     0.200
     2.462    40.596     0.200
     2.575    42.770     0.200
     2.852    45.537     0.200
     3.367    52.127     0.200
     3.367    51.326     0.200
     3.497    51.015     0.200
     3.643    55.713     0.200
     3.738    56.002     0.200
     4.060    59.340     0.200
     4.012    61.100     0.200
     4.303    63.506     0.200
     4.419    65.152     0.200
     4.564    72.364     0.200
     4.564    68.965     0.200
     5.048    75.218     0.200
     5.839    82.579     0.200
    12.324   166.808     0.200
     1.289    27.082     0.200
     1.303    27.219     0.200
     1.344    27.646     0.200
     1.464    30.739     0.200
     1.870    35.896     0.200
     1.844    37.006     0.200
     3.010    47.993     0.200
     1.527    30.209     0.200
     1.630    31.999     0.200
     2.781    42.774     0.200
     3.034    48.121     0.200
     3.590    55.434     0.200
     4.070    59.632     0.200
     4.348    63.580     0.200
     4.484    66.199     0.200
     4.986    72.437     0.200
     5.120    72.076     0.200
     5.384    76.599     0.200
     5.417    80.810     0.200
     6.757    91.771     0.200
     1.092    25.754     0.200
     1.627    32.402     0.200
     1.669    34.419     0.200
     1.707    35.069     0.200
     1.912    38.082     0.200
     2.557    44.155     0.200
     2.641    44.871     0.200
     2.895    47.210     0.200
     3.366    53.512     0.200
     4.347    65.757     0.200
     5.296    77.086     0.200
     1.433    29.391     0.200
     1.433    31.586     0.200
     1.465    30.217     0.200
     1.786    36.574     0.200
     2.426    42.408     0.200
     2.644    43.368     0.200
     3.570    56.352     0.200
     4.479    67.954     0.200
     4.615    73.954     0.200
     5.052    74.661     0.200
     5.052    77.661     0.200
     6.661    94.082     0.200
     1.251    26.308     0.200
     1.798    35.524     0.200
     1.809    33.496     0.200
     1.809    35.797     0.200
     1.830    34.545     0.200
     1.877    34.196     0.200
     1.877    36.496     0.200
     2.234    38.436     0.200
     2.273    37.783     0.200
     3.265    51.805     0.200
     4.634    68.728     0.200
     4.940    68.955     0.200
     1.358    26.521     0.200
     1.601    31.387     0.200
     1.808    35.871     0.200
     1.905    33.343     0.200
     2.265    36.941     0.200
     2.202    37.081     0.200
     2.487    40.644     0.200
     3.124    48.818     0.200
     3.363    50.134     0.200
     3.820    56.998     0.200
     4.123    61.052     0.200
     4.520    63.928     0.200
     4.601    66.875     0.200
     5.034    74.725     0.200
     5.034    74.826     0.200
     5.226    73.583     0.200
     5.425    79.858     0.200
     5.919    86.485     0.200
     8.167   108.961     0.200
    12.055   161.197     0.200
    13.006   173.594     0.200
    15.040   199.905     0.200
    19.880   264.674     0.200
     1.375    28.012     0.200
     4.523    63.267     0.200
     5.049    76.536     0.200
     5.438    77.991     0.200
     1.354    27.680     0.200
     4.528    63.742     0.200
     5.230    73.945     0.200
     5.415    79.881     0.200
     1.509    29.986     0.200
     1.657    33.352     0.200
     1.903    37.982     0.200
     2.251    38.218     0.200
     2.234    38.823     0.200
     2.627    44.032     0.200
     2.627    44.231     0.200
     2.746    44.251     0.200
     2.880    47.878     0.200
     3.362    52.753     0.200
     3.351    53.586     0.200
     3.742    57.921     0.200
     4.332    64.337     0.200
     4.356    62.453     0.200
     4.356    65.352     0.200
     4.838    71.734     0.200
     4.838    74.637     0.200
     5.272    75.470     0.200
     5.280    77.377     0.200
     6.694    95.073     0.200
     1.585    31.400     0.200
     1.682    31.962     0.200
     1.682    33.462     0.200
     2.190    37.240     0.200
     4.412    62.900     0.200
     5.297    79.373     0.200
     1.096    22.796     0.200
     1.318    27.011     0.200
     1.398    27.773     0.200
     1.587    30.868     0.200
     4.071    58.876     0.200
     1.167    23.975     0.200
     1.339    27.162     0.200
     1.391    27.054     0.200
     1.399    28.458     0.200
     1.463    28.410     0.200
     4.195    60.735     0.200
     1.704    33.954     0.200
     1.718    34.791     0.200
     1.749    35.428     0.200
     1.750    35.418     0.200
     2.217    37.974     0.200
     2.375    41.226     0.200
     2.375    40.827     0.200
     2.625    44.817     0.200
     2.625    43.817     0.200
     2.867    48.790     0.200
     2.867    46.892     0.200
     3.320    53.801     0.200
     3.320    52.097     0.200
     3.842    59.112     0.200
     4.659    67.772     0.200
     4.659    67.968     0.200
     5.132    76.949     0.200
     5.132    74.652     0.200
     5.415    77.749     0.200
     1.260    29.410     0.200
     1.514    30.849     0.200
     4.432    67.589     0.200
     4.917    72.325     0.200
     1.509    29.866     0.200
     1.750    34.550     0.200
     1.800    34.073     0.200
     1.800    36.174     0.200
     1.830    35.818     0.200
     2.209    36.197     0.200
     2.263    39.064     0.200
     2.263    38.564     0.200
     2.448    42.310     0.200
     2.635    42.934     0.200
     2.704    42.323     0.200
     2.898    46.654     0.200
     2.898    46.756     0.200
     3.421    53.053     0.200
     3.896    56.615     0.200
     3.964    58.824     0.200
     4.162    61.204     0.200
     4.331    66.830     0.200
     4.467    65.247     0.200
     4.735    66.224     0.200
     4.738    69.078     0.200
     5.490    76.307     0.200
     5.490    78.612     0.200
     5.673    78.572     0.200
     6.719    93.070     0.200
     7.115    97.541     0.200
     7.425   101.119     0.200
     7.988   109.954     0.200
     1.667    33.424     0.200
     1.667    34.826     0.200
     1.698    34.563     0.200
     2.002    40.115     0.200
     2.424    41.497     0.200
     2.424    42.395     0.200
     2.575    44.337     0.200
     2.640    44.782     0.200
     2.817    47.507     0.200
     2.992    47.664     0.200
     3.272    53.970     0.200
     3.630    56.219     0.200
     3.630    57.817     0.200
     3.789    59.065     0.200
     4.105    62.283     0.200
     4.317    65.900     0.200
     4.646    68.668     0.200
     5.096    76.120     0.200
     5.304    75.984     0.200
     5.683    81.864     0.200
     1.887    38.057     0.200
     2.282    39.551     0.200
     2.537    43.267     0.200
     4.341    63.813     0.200
     5.000    72.228     0.200
     1.662    34.217     0.200
     1.701    35.075     0.200
     1.701    34.871     0.200
     2.005    40.816     0.200
     2.192    39.637     0.200
     2.266    39.881     0.200
     2.576    45.059     0.200
     2.640    45.309     0.200
     2.640    45.411     0.200
     2.818    46.535     0.200
     2.990    47.524     0.200
     3.633    57.421     0.200
     3.788    58.906     0.200
     4.319    67.817     0.200
     4.650    68.357     0.200
     4.650    68.755     0.200
     4.706    73.403     0.200
     4.706    73.700     0.200
     5.095    77.968     0.200
     5.095    76.968     0.200
     5.465    79.151     0.200
     5.686    83.155     0.200
     6.440    90.670     0.200
     7.059    98.842     0.200
     8.268   114.233     0.200
     1.681    34.279     0.200
     1.676    33.733     0.200
     1.710    34.837     0.200
     1.712    34.322     0.200
     2.018    37.149     0.200
     2.199    38.431     0.200
     2.582    43.860     0.200
     3.278    52.245     0.200
     4.663    67.679     0.200
     4.708    70.257     0.200
     1.741    35.523     0.200
     1.822    36.871     0.200
     2.125    36.533     0.200
     2.362    40.870     0.200
     2.755    44.780     0.200
     2.870    46.740     0.200
     3.008    49.130     0.200
     3.292    50.621     0.200
     3.478    51.949     0.200
     4.357    63.886     0.200
     4.960    76.657     0.200
     4.960    75.458     0.200
     5.403    75.783     0.200
     5.391    78.228     0.200
     7.393   101.055     0.200
     8.606   118.201     0.200
    12.039   159.644     0.200
    14.151   190.197     0.200
    20.936   281.507     0.200
     1.694    33.740     0.200
     1.704    33.520     0.200
     1.735    35.160     0.200
     1.735    35.058     0.200
     2.233    39.453     0.200
     2.226    38.337     0.200
     2.388    41.747     0.200
     2.609    43.967     0.200
     2.670    43.646     0.200
     2.956    46.115     0.200
     2.851    48.242     0.200
     3.304    53.933     0.200
     3.626    56.394     0.200
     3.626    56.292     0.200
     3.756    56.073     0.200
     4.353    65.413     0.200
     4.661    67.715     0.200
     4.661    67.613     0.200
     4.734    73.864     0.200
     5.430    77.344     0.200
     1.158    25.591     0.200
     1.370    29.116     0.200
     1.424    28.091     0.200
     1.461    29.154     0.200
     1.487    30.439     0.200
     1.733    34.172     0.200
     4.406    64.584     0.200
     1.506    30.294     0.200
     1.506    30.990     0.200
     1.681    32.952     0.200
     4.273    68.010     0.200
     4.740    73.460     0.200
     5.309    81.074     0.200
     1.598    32.229     0.200
     1.727    34.621     0.200
     1.820    36.843     0.200
     2.211    38.781     0.200
     2.829    46.065     0.200
     2.929    47.667     0.200
     4.415    65.658     0.200
     4.875    73.387     0.200
     5.385    82.171     0.200
     1.504    29.809     0.200
     1.734    34.022     0.200
     1.874    36.792     0.200
     2.118    36.641     0.200
     2.334    40.328     0.200
     1.449    28.874     0.200
     1.590    31.428     0.200
     1.634    32.709     0.200
     1.859    36.990     0.200
     4.255    61.725     0.200
     4.321    63.856     0.200
     4.868    74.372     0.200
     5.329    80.794     0.200
     1.437    29.522     0.200
     1.751    34.054     0.200
     1.778    35.642     0.200
     1.913    36.863     0.200
     1.956    35.557     0.200
     2.604    43.101     0.200
     2.999    47.892     0.200
     3.253    50.321     0.200
     3.726    57.011     0.200
     1.373    27.044     0.200
     1.457    29.657     0.200
     1.312    30.236     0.200
     1.538    30.901     0.200
     1.726    34.801     0.200
     1.860    36.539     0.200
     2.255    38.622     0.200
     4.992    77.785     0.200
     1.604    32.043     0.200
     1.734    34.420     0.200
     1.828    36.333     0.200
     2.218    37.873     0.200
     2.823    47.424     0.200
     4.422    69.652     0.200
     4.881    74.596     0.200
     1.422    28.460     0.200
     1.507    30.572     0.200
     1.725    34.125     0.200
     2.272    38.048     0.200
     2.666    43.043     0.200
     2.921    46.470     0.200
     2.921    46.170     0.200
     3.394    52.470     0.200
     3.394    52.252     0.200
     4.302    63.050     0.200
     5.338    76.169     0.200
     7.932   108.344     0.200
     1.366    27.205     0.200
     1.527    28.926     0.200
     1.647    31.520     0.200
     1.647    30.816     0.200
     1.752    34.088     0.200
     1.752    34.189     0.200
     1.760    32.605     0.200
     1.760    34.800     0.200
     1.757    35.431     0.200
     2.150    37.652     0.200
     2.150    36.152     0.200
     2.740    42.366     0.200
     2.795    44.919     0.200
     3.298    52.652     0.200
     4.268    62.830     0.200
     4.204    63.577     0.200
     4.595    67.015     0.200
     4.859    67.033     0.200
     1.449    28.791     0.200
     1.546    29.959     0.200
     1.674    32.663     0.200
     1.760    35.365     0.200
     1.197    24.545     0.200
     1.197    26.948     0.200
     1.259    25.627     0.200
     1.335    26.841     0.200
     1.337    30.021     0.200
     1.561    31.305     0.200
     1.751    34.187     0.200
     1.884    36.229     0.200
     2.280    38.016     0.200
     1.023    23.766     0.200
     1.478    29.148     0.200
     1.604    31.178     0.200
     2.563    40.688     0.200
     4.769    67.846     0.200
     5.210    73.093     0.200
     1.301    26.700     0.200
     1.301    27.999     0.200
     1.331    26.948     0.200
     1.548    29.817     0.200
     1.420    28.326     0.200
     1.509    30.195     0.200
     1.801    35.485     0.200
     2.920    45.626     0.200
     4.924    73.940     0.200
     1.319    26.112     0.200
     1.319    27.714     0.200
     1.350    26.460     0.200
     1.350    27.257     0.200
     1.411    26.742     0.200
     1.411    26.945     0.200
     1.420    28.933     0.200
     2.333    36.183     0.200
     2.309    38.468     0.200
     2.309    38.265     0.200
     2.497    40.465     0.200
     2.721    44.458     0.200
     2.793    44.011     0.200
     2.836    44.008     0.200
     3.163    49.296     0.200
     3.558    53.287     0.200
     3.813    54.310     0.200
     4.753    66.849     0.200
     4.849    69.421     0.200
     5.763    83.157     0.200
     5.763    83.352     0.200
     6.146    87.337     0.200
     6.163    87.191     0.200
     1.398    28.153     0.200
     1.612    32.363     0.200
     1.690    33.542     0.200
     2.667    42.849     0.200
     4.468    63.834     0.200
     4.846    75.117     0.200
     5.263    78.651     0.200
     1.378    27.566     0.200
     1.694    33.978     0.200
     1.882    37.187     0.200
     1.257    25.832     0.200
     1.287    27.475     0.200
     1.445    28.736     0.200
     1.600    31.918     0.200
     1.718    34.446     0.200
     1.804    35.745     0.200
     2.193    36.996     0.200
     2.299    38.467     0.200
     2.443    40.488     0.200
     2.657    42.485     0.200
     2.828    45.996     0.200
     2.909    46.049     0.200
     3.920    59.550     0.200
     4.007    60.532     0.200
     4.167    60.466     0.200
     4.391    67.855     0.200
     4.500    65.275     0.200
     4.846    70.837     0.200
     5.311    77.412     0.200
     7.020    98.091     0.200
     1.255    25.807     0.200
     1.353    28.059     0.200
     1.815    34.267     0.200
     1.815    35.867     0.200
     1.857    34.486     0.200
     1.857    36.587     0.200
     1.818    37.242     0.200
     2.261    37.762     0.200
     2.173    38.991     0.200
     2.643    42.009     0.200
     2.665    44.659     0.200
     3.315    51.086     0.200
     3.315    51.467     0.200
     4.340    66.111     0.200
     4.699    70.614     0.200
     4.869    68.930     0.200
     5.038    73.555     0.200
     6.451    89.959     0.200
     1.293    27.160     0.200
     1.310    26.368     0.200
     1.615    31.711     0.200
     1.798    35.574     0.200
     2.186    36.940     0.200
     2.434    40.245     0.200
     3.991    59.473     0.200
     4.374    68.012     0.200
     4.823    72.564     0.200
     5.411    80.632     0.200
     7.008    97.174     0.200
     8.365   115.026     0.200
     1.720    33.906     0.200
     1.804    35.531     0.200
     1.864    36.825     0.200
     2.383    39.472     0.200
     1.270    27.171     0.200
     1.512    30.554     0.200
     1.512    30.351     0.200
     1.734    34.656     0.200
     1.818    34.273     0.200
     1.818    36.476     0.200
     1.879    36.771     0.200
     2.839    46.365     0.200
     2.786    45.182     0.200
     3.034    48.191     0.200
     3.406    53.545     0.200
     3.495    56.443     0.200
     4.948    77.648     0.200
     5.347    80.394     0.200
     5.848    87.564     0.200
    14.086   189.402     0.200
     1.528    30.734     0.200
     1.814    36.293     0.200
     2.451    42.658     0.200
     1.467    29.387     0.200
     1.525    30.808     0.200
     1.562    30.784     0.200
     1.585    32.307     0.200
     1.835    37.098     0.200
     6.794    95.467     0.200
     1.222    24.331     0.200
     1.274    25.422     0.200
     1.365    27.362     0.200
     1.406    28.179     0.200
     1.655    33.176     0.200
     1.861    37.272     0.200
     2.649    42.772     0.200
     1.270    25.172     0.200
     1.289    26.053     0.200
     1.420    28.122     0.200
     1.420    28.521     0.200
     1.593    31.208     0.200
     2.211    36.994     0.200
     3.683    54.412     0.200
     5.379    78.764     0.200
     7.027    97.761     0.200
     1.279    26.858     0.200
     1.279    26.358     0.200
     1.383    27.353     0.200
     1.669    32.512     0.200
     1.669    32.212     0.200
     1.292    26.234     0.200
     1.713    31.319     0.200
     1.713    33.819     0.200
     1.722    34.721     0.200
     1.730    33.427     0.200
     2.263    36.907     0.200
     2.382    38.518     0.200
     2.382    39.618     0.200
     2.820    45.004     0.200
     3.270    50.973     0.200
     6.575    91.486     0.200
    13.726   183.355     0.200
     1.250    28.063     0.200
     1.290    30.098     0.200
     1.575    31.264     0.200
     1.713    34.063     0.200
     1.813    36.296     0.200
     5.360    82.780     0.200
     1.360    28.140     0.200
     1.536    30.486     0.200
     1.625    32.141     0.200
     2.620    42.337     0.200
     2.871    45.901     0.200
     1.807    36.587     0.200
     1.074    22.248     0.200
     1.337    28.281     0.200
     2.602    42.621     0.200
     1.201    27.347     0.200
     1.759    35.729     0.200
     1.894    37.859     0.200
     2.289    39.947     0.200
     3.518    55.603     0.200
     4.309    63.576     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.144    42.607     0.200
     2.552    48.139     0.200
     3.014    58.946     0.200
     3.011    56.683     0.200
     3.621    68.372     0.200
     3.661    70.398     0.200
     4.742    91.281     0.200
     4.862    93.289     0.200
     5.041    96.694     0.200
     3.245    61.847     0.200
     3.350    64.623     0.200
     3.520    68.643     0.200
    14.673   290.481     0.200
     2.095    40.617     0.200
     2.728    53.827     0.200
     2.752    52.053     0.200
     3.227    63.004     0.200
     3.876    75.134     0.200
     2.391    44.778     0.200
     2.507    47.431     0.200
     2.504    48.058     0.200
     3.097    59.943     0.200
     3.142    58.414     0.200
     3.662    68.354     0.200
     3.744    69.496     0.200
     3.918    75.963     0.200
     4.201    80.960     0.200
     4.570    86.654     0.200
     2.207    42.918     0.200
     2.368    45.643     0.200
     2.597    48.369     0.200
     2.657    49.467     0.200
     3.031    57.694     0.200
     4.044    76.484     0.200
     4.163    79.986     0.200
     5.073    98.868     0.200
     2.341    44.503     0.200
     2.557    47.883     0.200
     2.642    50.294     0.200
     2.976    57.992     0.200
     3.254    61.551     0.200
     3.846    72.837     0.200
     4.084    80.159     0.200
     4.723    89.702     0.200
     2.261    42.959     0.200
     2.723    51.574     0.200
     2.894    54.478     0.200
     3.338    62.889     0.200
     3.421    64.225     0.200
     3.881    73.658     0.200
     3.954    77.305     0.200
     4.166    79.424     0.200
     4.332    82.694     0.200
     4.713    89.349     0.200
     2.299    43.433     0.200
     2.599    49.432     0.200
     2.675    50.844     0.200
     2.934    55.720     0.200
     3.292    61.942     0.200
     3.456    67.133     0.200
     3.876    74.130     0.200
     3.999    78.291     0.200
     4.126    78.908     0.200
     4.365    85.115     0.200
     4.733    88.827     0.200
     4.769    91.307     0.200
     5.763   111.406     0.200
     7.393   141.686     0.200
     2.260    44.412     0.200
     2.639    50.796     0.200
     2.713    51.726     0.200
     2.895    56.209     0.200
     3.333    63.699     0.200
     3.419    66.194     0.200
     3.893    73.156     0.200
     3.959    77.394     0.200
     4.166    80.477     0.200
     4.729    90.903     0.200
     4.738    92.298     0.200
     2.266    44.527     0.200
     2.299    46.245     0.200
     2.476    48.485     0.200
     2.487    49.355     0.200
     2.658    50.953     0.200
     2.658    51.055     0.200
     2.808    56.211     0.200
     3.670    70.142     0.200
     3.670    70.540     0.200
     4.117    79.237     0.200
     4.264    81.420     0.200
     4.450    86.042     0.200
     4.848    89.602     0.200
     6.309   123.352     0.200
     7.463   145.781     0.200
    14.160   281.334     0.200
     2.354    46.495     0.200
     2.696    51.503     0.200
     2.979    56.799     0.200
     3.286    63.721     0.200
     3.519    66.399     0.200
     3.767    74.599     0.200
     4.019    80.162     0.200
     4.084    79.000     0.200
     4.624    88.007     0.200
     4.855    91.808     0.200
     5.759   108.555     0.200
     6.172   118.641     0.200
     7.039   136.122     0.200
     2.282    43.883     0.200
     2.570    51.522     0.200
     2.570    49.817     0.200
     2.701    50.998     0.200
     2.701    51.295     0.200
     3.071    58.675     0.200
     3.071    58.972     0.200
     3.309    64.902     0.200
     3.309    61.997     0.200
     3.309    65.398     0.200
     3.413    63.580     0.200
     3.874    75.301     0.200
     3.874    75.801     0.200
     4.298    83.254     0.200
     4.393    84.843     0.200
     4.393    84.343     0.200
     4.791    90.802     0.200
     5.229   102.489     0.200
     5.229   102.786     0.200
     2.230    42.978     0.200
     2.562    48.801     0.200
     2.778    53.286     0.200
     3.038    58.350     0.200
     3.326    62.893     0.200
     3.381    65.050     0.200
     3.717    71.928     0.200
     3.953    76.369     0.200
     4.330    83.474     0.200
     2.304    45.433     0.200
     2.377    44.787     0.200
     2.377    45.287     0.200
     2.665    50.420     0.200
     2.665    51.623     0.200
     3.004    57.866     0.200
     3.004    59.264     0.200
     3.540    67.311     0.200
     4.047    78.290     0.200
     4.637    87.508     0.200
     4.870    95.397     0.200
     5.575   108.968     0.200
     5.729   110.163     0.200
     2.345    45.408     0.200
     2.637    50.495     0.200
     2.637    50.694     0.200
     2.532    49.423     0.200
     2.653    51.310     0.200
     2.653    52.310     0.200
     3.138    61.349     0.200
     3.257    62.871     0.200
     3.257    63.270     0.200
     3.418    65.987     0.200
     3.418    66.787     0.200
     3.508    70.332     0.200
     3.508    70.031     0.200
     3.837    74.292     0.200
     3.829    72.286     0.200
     3.829    74.587     0.200
     4.191    82.269     0.200
     4.219    82.341     0.200
     4.237    84.025     0.200
     4.360    84.197     0.200
     4.747    90.775     0.200
     5.197    99.920     0.200
     5.197   100.920     0.200
     5.367   106.146     0.200
     5.610   107.507     0.200
     5.610   107.308     0.200
     6.789   132.345     0.200
     6.992   133.675     0.200
     8.198   158.619     0.200
     2.296    44.780     0.200
     2.713    51.824     0.200
     2.768    52.973     0.200
     3.063    59.433     0.200
     3.168    61.412     0.200
     3.458    66.127     0.200
     3.731    71.935     0.200
     4.018    76.792     0.200
     4.073    77.852     0.200
     4.995    96.484     0.200
     5.270    99.881     0.200
     2.573    50.189     0.200
     2.737    53.272     0.200
     2.737    53.171     0.200
     2.726    53.496     0.200
     2.726    54.496     0.200
     3.193    60.147     0.200
     3.193    62.147     0.200
     3.262    64.240     0.200
     3.262    63.146     0.200
     3.310    65.086     0.200
     3.557    69.896     0.200
     3.827    73.743     0.200
     3.908    77.407     0.200
     3.908    76.508     0.200
     4.181    81.711     0.200
     4.181    80.312     0.200
     4.248    84.142     0.200
     5.310   102.640     0.200
     5.362   104.227     0.200
     6.773   131.266     0.200
     6.909   132.275     0.200
     2.089    42.237     0.200
     2.127    41.390     0.200
     2.353    45.563     0.200
     2.717    53.110     0.200
     2.793    53.019     0.200
     2.880    56.410     0.200
     3.421    64.495     0.200
     3.495    68.228     0.200
     3.495    68.528     0.200
     3.643    70.101     0.200
     3.954    74.776     0.200
     3.954    74.476     0.200
     4.451    87.978     0.200
     4.576    86.720     0.200
     4.864    92.555     0.200
     4.864    92.055     0.200
     5.162   100.373     0.200
     5.256   101.281     0.200
     5.354   102.937     0.200
     6.598   126.422     0.200
     2.142    42.664     0.200
     2.368    46.122     0.200
     2.368    46.422     0.200
     2.503    48.054     0.200
     2.503    48.855     0.200
     2.620    50.382     0.200
     2.644    51.103     0.200
     3.155    61.146     0.200
     3.155    61.247     0.200
     3.225    62.320     0.200
     3.454    66.459     0.200
     3.454    66.158     0.200
     3.795    72.969     0.200
     3.864    74.666     0.200
     4.212    83.214     0.200
     4.384    83.597     0.200
     5.161   100.131     0.200
     5.392   104.731     0.200
     5.627   107.396     0.200
     6.817   130.814     0.200
     7.027   135.159     0.200
     2.167    42.367     0.200
     2.345    46.490     0.200
     2.511    49.152     0.200
     2.718    52.641     0.200
     2.978    57.401     0.200
     3.296    64.194     0.200
     3.442    66.886     0.200
     3.654    71.318     0.200
     4.012    78.441     0.200
     4.337    83.950     0.200
     4.929    94.837     0.200
     5.367   102.524     0.200
     2.218    43.861     0.200
     2.292    44.999     0.200
     2.292    43.999     0.200
     2.569    48.664     0.200
     2.574    50.115     0.200
     2.574    49.716     0.200
     2.683    51.934     0.200
     3.077    59.448     0.200
     3.293    63.857     0.200
     3.293    62.518     0.200
     3.436    66.257     0.200
     3.436    66.155     0.200
     3.447    68.416     0.200
     3.447    65.916     0.200
     3.791    71.512     0.200
     3.791    72.711     0.200
     3.856    72.647     0.200
     4.138    80.660     0.200
     4.165    81.342     0.200
     4.287    82.828     0.200
     4.411    85.468     0.200
     4.411    84.167     0.200
     4.773    92.053     0.200
     5.209    99.863     0.200
     5.549   104.695     0.200
     6.744   130.750     0.200
     6.970   133.810     0.200
     7.459   142.806     0.200
     8.222   160.556     0.200
     2.209    42.443     0.200
     2.500    48.638     0.200
     2.657    50.815     0.200
     2.763    54.573     0.200
     2.997    58.045     0.200
     3.395    64.199     0.200
     3.375    66.532     0.200
     3.707    70.457     0.200
     3.934    76.706     0.200
     4.418    86.166     0.200
     4.370    86.217     0.200
     4.850    92.921     0.200
     5.277   101.031     0.200
     5.468   105.701     0.200
     2.046    40.842     0.200
     2.203    42.817     0.200
     2.366    45.710     0.200
     3.102    59.129     0.200
     4.285    81.922     0.200
     2.289    43.901     0.200
     2.294    45.139     0.200
     2.736    52.386     0.200
     2.778    52.298     0.200
     2.916    57.087     0.200
     3.028    57.573     0.200
     3.167    60.156     0.200
     3.522    68.711     0.200
     4.100    78.964     0.200
     4.376    84.344     0.200
     2.203    41.859     0.200
     2.203    41.059     0.200
     2.313    45.374     0.200
     2.561    47.879     0.200
     2.561    49.079     0.200
     2.695    52.519     0.200
     2.823    56.025     0.200
     2.823    54.124     0.200
     3.022    56.603     0.200
     3.022    57.002     0.200
     3.274    61.353     0.200
     3.274    61.053     0.200
     3.387    65.532     0.200
     3.423    65.823     0.200
     3.683    69.780     0.200
     3.999    76.593     0.200
     3.999    75.993     0.200
     4.292    82.372     0.200
     4.292    81.372     0.200
     2.280    43.621     0.200
     2.753    51.398     0.200
     3.059    56.821     0.200
     3.151    59.851     0.200
     3.715    70.767     0.200
     4.025    76.854     0.200
     2.058    39.644     0.200
     2.212    43.141     0.200
     2.315    43.645     0.200
     2.430    47.796     0.200
     2.608    49.719     0.200
     2.828    53.351     0.200
     3.124    59.205     0.200
     3.290    63.560     0.200
     4.158    80.131     0.200
     6.217   118.111     0.200
     2.241    44.114     0.200
     2.269    43.486     0.200
     2.573    49.141     0.200
     2.606    50.054     0.200
     2.606    49.953     0.200
     2.723    51.889     0.200
     2.723    52.889     0.200
     3.065    57.895     0.200
     3.065    59.094     0.200
     3.329    65.118     0.200
     3.329    63.516     0.200
     3.384    63.580     0.200
     3.384    63.682     0.200
     3.435    64.784     0.200
     3.435    66.784     0.200
     3.762    72.464     0.200
     3.898    73.985     0.200
     3.898    73.785     0.200
     4.115    79.542     0.200
     4.115    81.343     0.200
     4.313    84.440     0.200
     4.368    83.289     0.200
     4.368    84.789     0.200
     4.815    91.280     0.200
     4.815    91.581     0.200
     5.256   101.326     0.200
     5.291    99.422     0.200
     5.291   104.320     0.200
     5.536   105.662     0.200
     6.714   129.917     0.200
     6.926   131.442     0.200
     2.370    47.488     0.200
     2.370    47.588     0.200
     2.529    47.526     0.200
     2.622    49.142     0.200
     3.004    55.782     0.200
     3.229    60.557     0.200
     3.527    66.583     0.200
     3.609    69.431     0.200
     3.822    72.536     0.200
     4.056    78.012     0.200
     4.437    83.769     0.200
     4.712    89.960     0.200
     2.095    40.182     0.200
     2.099    41.639     0.200
     2.354    43.761     0.200
     2.754    53.088     0.200
     2.839    53.901     0.200
     2.863    56.123     0.200
     3.462    65.723     0.200
     3.605    68.354     0.200
     4.002    75.726     0.200
     4.482    88.728     0.200
     5.127   101.194     0.200
     5.312   102.840     0.200
     5.336   102.261     0.200
     6.844   131.756     0.200
     2.175    41.653     0.200
     2.307    45.113     0.200
     2.327    44.481     0.200
     2.327    44.981     0.200
     2.510    49.443     0.200
     2.574    49.400     0.200
     2.574    49.298     0.200
     2.715    51.257     0.200
     2.912    57.053     0.200
     3.399    65.771     0.200
     3.399    66.466     0.200
     3.454    67.529     0.200
     3.546    68.654     0.200
     4.136    77.666     0.200
     4.136    79.361     0.200
     4.576    87.328     0.200
     4.724    91.809     0.200
     4.987    95.532     0.200
     5.058    99.008     0.200
     5.969   114.377     0.200
     6.096   116.195     0.200
     6.082   116.465     0.200
     2.034    38.271     0.200
     2.034    39.970     0.200
     2.195    43.190     0.200
     2.245    44.513     0.200
     2.245    44.717     0.200
     2.308    43.375     0.200
     2.308    43.875     0.200
     2.417    47.901     0.200
     2.612    49.329     0.200
     2.612    49.931     0.200
     2.855    52.590     0.200
     2.855    54.090     0.200
     2.959    57.281     0.200
     3.139    60.774     0.200
     3.139    61.070     0.200
     3.269    63.858     0.200
     3.405    66.270     0.200
     3.405    64.270     0.200
     3.538    68.817     0.200
     3.538    69.215     0.200
     4.002    76.502     0.200
     4.002    76.803     0.200
     4.677    89.424     0.200
     4.677    90.123     0.200
     4.942    96.335     0.200
     5.045    95.231     0.200
     5.930   113.500     0.200
     6.079   117.162     0.200
     6.242   118.865     0.200
     2.246    43.209     0.200
     2.246    43.408     0.200
     2.443    46.719     0.200
     2.443    46.617     0.200
     2.643    51.382     0.200
     2.643    49.480     0.200
     2.677    52.377     0.200
     2.773    53.463     0.200
     2.869    54.642     0.200
     3.292    64.699     0.200
     3.569    67.868     0.200
     3.711    70.709     0.200
     3.711    71.112     0.200
     4.305    81.278     0.200
     4.840    90.643     0.200
     4.888    91.975     0.200
     2.314    44.401     0.200
     2.449    47.620     0.200
     2.449    47.821     0.200
     2.569    50.126     0.200
     2.832    54.758     0.200
     3.043    59.291     0.200
     3.043    59.590     0.200
     3.355    65.049     0.200
     3.526    68.952     0.200
     3.629    68.251     0.200
     3.629    69.151     0.200
     3.629    72.151     0.200
     4.014    79.064     0.200
     4.060    78.222     0.200
     4.340    83.260     0.200
     5.027    97.244     0.200
     5.590   106.468     0.200
     2.348    44.467     0.200
     3.554    66.392     0.200
     4.024    75.808     0.200
     4.101    79.300     0.200
     2.073    40.323     0.200
     2.073    39.222     0.200
     2.121    42.561     0.200
     2.332    45.391     0.200
     2.840    54.873     0.200
     2.775    53.526     0.200
     2.858    54.959     0.200
     3.212    62.725     0.200
     3.212    63.623     0.200
     3.431    66.177     0.200
     3.431    66.278     0.200
     3.483    66.669     0.200
     3.483    66.466     0.200
     3.917    77.206     0.200
     4.536    87.171     0.200
     4.536    87.272     0.200
     4.504    89.052     0.200
     4.931    94.560     0.200
     4.931    93.966     0.200
     5.106    98.229     0.200
     5.313   102.011     0.200
     5.313   101.308     0.200
     5.327   102.651     0.200
     5.855   115.159     0.200
     6.539   126.608     0.200
     6.828   131.527     0.200
     7.400   144.559     0.200
     7.565   145.933     0.200
    14.012   273.071     0.200
     2.127    42.681     0.200
     2.392    44.890     0.200
     2.392    45.490     0.200
     2.506    49.853     0.200
     2.831    54.961     0.200
     2.879    56.101     0.200
     2.879    56.001     0.200
     2.993    57.865     0.200
     3.196    62.507     0.200
     3.196    63.607     0.200
     3.213    62.100     0.200
     3.213    61.200     0.200
     3.492    67.447     0.200
     3.602    70.965     0.200
     3.602    69.165     0.200
     3.853    76.630     0.200
     3.853    75.230     0.200
     4.166    80.386     0.200
     4.345    82.491     0.200
     4.345    83.391     0.200
     4.581    89.338     0.200
     4.581    89.238     0.200
     5.082    98.098     0.200
     5.506   107.649     0.200
     5.506   107.549     0.200
     5.679   112.601     0.200
     5.805   117.151     0.200
     6.443   126.408     0.200
     6.663   128.538     0.200
     7.293   143.885     0.200
     8.038   155.395     0.200
     2.013    38.785     0.200
     2.013    38.382     0.200
     2.389    44.700     0.200
     2.389    44.997     0.200
     2.500    49.299     0.200
     2.833    54.520     0.200
     2.833    55.020     0.200
     2.871    55.075     0.200
     2.984    57.158     0.200
     2.984    56.959     0.200
     3.198    63.260     0.200
     3.227    61.420     0.200
     3.227    60.217     0.200
     3.499    66.644     0.200
     3.499    66.542     0.200
     3.593    68.848     0.200
     4.155    78.285     0.200
     4.155    78.882     0.200
     4.356    82.941     0.200
     4.575    89.893     0.200
     5.029    98.784     0.200
     5.029    96.984     0.200
     5.071    96.697     0.200
     5.298   100.543     0.200
     5.494   106.867     0.200
     5.494   107.265     0.200
     6.675   128.085     0.200
     2.009    39.749     0.200
     2.011    36.828     0.200
     2.011    40.527     0.200
     2.094    40.767     0.200
     2.322    44.309     0.200
     2.322    43.407     0.200
     2.331    44.404     0.200
     2.331    45.404     0.200
     2.517    48.627     0.200
     2.566    50.961     0.200
     2.628    53.430     0.200
     2.660    52.159     0.200
     2.660    51.659     0.200
     2.739    53.939     0.200
     2.779    51.765     0.200
     2.779    53.468     0.200
     2.817    53.926     0.200
     3.218    62.354     0.200
     3.218    60.252     0.200
     3.700    69.522     0.200
     4.286    81.685     0.200
     4.286    81.087     0.200
     4.738    90.108     0.200
     4.871    90.961     0.200
     2.072    40.201     0.200
     2.072    39.998     0.200
     2.132    42.593     0.200
     2.316    44.748     0.200
     2.316    44.944     0.200
     2.447    48.119     0.200
     2.832    54.736     0.200
     2.832    53.736     0.200
     2.774    53.812     0.200
     2.774    53.109     0.200
     2.851    54.801     0.200
     2.851    53.004     0.200
     3.205    62.782     0.200
     3.205    61.579     0.200
     3.455    65.961     0.200
     3.455    65.563     0.200
     3.479    66.585     0.200
     3.479    65.882     0.200
     3.586    68.327     0.200
     3.586    68.124     0.200
     4.012    76.656     0.200
     4.012    75.359     0.200
     4.505    89.605     0.200
     4.564    87.627     0.200
     4.922    92.442     0.200
     4.922    94.942     0.200
     4.922    92.637     0.200
     5.106    99.293     0.200
     5.305   101.970     0.200
     5.305   100.267     0.200
     5.312   102.984     0.200
     5.763   111.064     0.200
     5.871   117.639     0.200
     6.541   125.646     0.200
     6.841   131.248     0.200
     7.403   142.681     0.200
    13.990   272.372     0.200
    18.004   356.589     0.200
     2.178    42.066     0.200
     2.178    41.265     0.200
     2.474    47.307     0.200
     2.474    47.108     0.200
     2.687    51.131     0.200
     2.687    52.728     0.200
     2.792    53.005     0.200
     2.967    56.356     0.200
     2.967    54.755     0.200
     3.337    64.738     0.200
     3.382    64.109     0.200
     3.382    64.211     0.200
     3.404    65.852     0.200
     3.677    70.175     0.200
     3.677    71.175     0.200
     3.962    73.146     0.200
     3.962    76.646     0.200
     3.962    77.748     0.200
     3.962    74.345     0.200
     4.422    84.474     0.200
     4.422    84.673     0.200
     4.401    86.326     0.200
     4.877    93.165     0.200
     4.877    93.364     0.200
     5.204   102.356     0.200
     5.439   103.714     0.200
     5.713   112.679     0.200
     6.630   129.212     0.200
     6.869   131.425     0.200
     7.548   144.601     0.200
     9.674   188.489     0.200
    10.022   194.822     0.200
    14.032   273.236     0.200
     2.239    43.299     0.200
     2.239    43.897     0.200
     2.273    44.702     0.200
     2.570    48.737     0.200
     2.647    50.339     0.200
     2.770    53.699     0.200
     2.770    53.801     0.200
     3.047    58.572     0.200
     3.047    57.272     0.200
     3.329    63.881     0.200
     3.373    63.869     0.200
     3.414    67.981     0.200
     3.414    67.680     0.200
     3.726    71.548     0.200
     3.726    70.450     0.200
     3.946    74.080     0.200
     4.085    81.159     0.200
     4.328    82.017     0.200
     4.347    85.695     0.200
     4.864    93.266     0.200
     5.256   100.888     0.200
     5.310   102.166     0.200
     6.677   128.513     0.200
     6.876   132.085     0.200
     7.561   146.386     0.200
     2.185    41.814     0.200
     2.327    45.749     0.200
     2.522    47.980     0.200
     2.522    48.082     0.200
     2.699    52.015     0.200
     2.818    53.324     0.200
     2.993    57.279     0.200
     3.310    62.578     0.200
     3.310    63.477     0.200
     3.423    65.263     0.200
     3.993    75.017     0.200
     3.993    75.318     0.200
     4.030    78.177     0.200
     4.401    85.149     0.200
     4.910    93.813     0.200
     5.203   100.095     0.200
     5.462   106.170     0.200
     5.549   108.547     0.200
     6.623   128.114     0.200
     6.831   129.988     0.200
     2.300    43.482     0.200
     2.444    46.513     0.200
     2.444    46.810     0.200
     2.592    49.286     0.200
     2.867    53.674     0.200
     3.033    57.737     0.200
     3.384    66.434     0.200
     3.510    66.973     0.200
     3.625    68.325     0.200
     3.625    69.626     0.200
     3.994    78.922     0.200
     4.079    78.327     0.200
     4.306    81.180     0.200
     4.438    86.245     0.200
     4.546    86.576     0.200
     5.032    97.110     0.200
     5.610   110.260     0.200
     5.856   113.385     0.200
     7.192   137.201     0.200
     7.192   139.103     0.200
     2.236    43.481     0.200
     2.236    43.680     0.200
     2.565    48.942     0.200
     2.565    48.743     0.200
     2.649    50.771     0.200
     2.649    49.868     0.200
     2.771    52.744     0.200
     2.771    53.846     0.200
     3.043    59.669     0.200
     3.043    57.669     0.200
     3.332    64.292     0.200
     3.332    62.690     0.200
     3.374    64.904     0.200
     3.374    64.204     0.200
     3.411    65.677     0.200
     3.946    75.527     0.200
     3.946    75.726     0.200
     4.333    81.808     0.200
     4.350    85.117     0.200
     4.350    85.219     0.200
     5.512   104.854     0.200
     6.675   130.087     0.200
     6.876   132.135     0.200
     7.525   144.669     0.200
     7.560   145.253     0.200
     2.289    44.000     0.200
     2.690    51.820     0.200
     2.733    52.820     0.200
     2.856    54.880     0.200
     3.119    59.412     0.200
     3.148    60.174     0.200
     3.432    67.058     0.200
     3.735    72.424     0.200
     4.079    77.712     0.200
     4.039    78.572     0.200
     4.347    85.081     0.200
     4.961    95.810     0.200
     5.273   103.676     0.200
     5.340   103.701     0.200
     5.451   105.991     0.200
     5.604   108.309     0.200
     6.675   129.411     0.200
     6.778   128.310     0.200
     9.846   189.515     0.200
     2.299    43.740     0.200
     2.441    47.082     0.200
     2.441    47.386     0.200
     2.591    50.032     0.200
     2.864    54.252     0.200
     3.031    57.301     0.200
     3.383    65.000     0.200
     3.515    66.555     0.200
     3.622    67.798     0.200
     3.994    77.566     0.200
     4.079    78.464     0.200
     4.312    81.353     0.200
     4.437    87.491     0.200
     4.543    87.354     0.200
     5.028    97.303     0.200
     5.610   108.598     0.200
     5.855   112.446     0.200
     7.030   135.236     0.200
     7.030   135.033     0.200
     7.289   141.105     0.200
     2.300    43.663     0.200
     2.300    43.863     0.200
     2.457    45.630     0.200
     2.541    47.344     0.200
     2.608    48.573     0.200
     2.608    49.673     0.200
     2.608    51.874     0.200
     3.025    56.102     0.200
     3.025    58.102     0.200
     3.239    60.603     0.200
     3.239    61.183     0.200
     3.402    65.503     0.200
     3.402    64.303     0.200
     3.645    72.166     0.200
     3.822    71.799     0.200
     3.766    70.957     0.200
     3.766    70.457     0.200
     4.284    84.006     0.200
     4.675    87.344     0.200
     4.675    88.344     0.200
     5.068    99.256     0.200
     5.068    95.957     0.200
     5.337   105.118     0.200
     5.499   104.629     0.200
     5.499   105.629     0.200
     5.658   110.578     0.200
     5.750   112.582     0.200
     6.776   132.224     0.200
     7.087   136.198     0.200
    17.758   351.324     0.200
    18.235   362.072     0.200
    18.321   361.071     0.200
     2.239    43.657     0.200
     2.564    50.068     0.200
     2.564    49.670     0.200
     2.644    51.125     0.200
     2.765    52.815     0.200
     2.765    53.409     0.200
     3.043    57.365     0.200
     3.043    58.764     0.200
     3.340    64.606     0.200
     3.340    64.505     0.200
     3.412    66.172     0.200
     3.369    64.362     0.200
     3.369    65.362     0.200
     3.727    70.990     0.200
     3.727    72.185     0.200
     3.940    74.101     0.200
     3.940    75.601     0.200
     4.340    82.230     0.200
     4.340    82.129     0.200
     4.347    85.361     0.200
     4.347    85.260     0.200
     4.858    90.892     0.200
     4.858    93.392     0.200
     5.257   100.531     0.200
     5.257   101.828     0.200
     5.302   100.511     0.200
     5.302   100.410     0.200
     6.678   129.447     0.200
     6.882   132.365     0.200
     8.128   156.531     0.200
    10.057   193.222     0.200
    14.046   271.165     0.200
    18.586   363.580     0.200
    22.668   451.543     0.200
    23.015   429.471     0.200
     2.246    43.604     0.200
     2.246    43.307     0.200
     2.575    50.069     0.200
     2.575    49.671     0.200
     2.640    50.517     0.200
     2.763    52.079     0.200
     2.763    52.986     0.200
     3.054    58.686     0.200
     3.334    64.017     0.200
     3.365    64.251     0.200
     3.365    64.352     0.200
     3.421    66.199     0.200
     3.733    71.354     0.200
     3.939    73.960     0.200
     4.329    82.904     0.200
     4.329    82.709     0.200
     4.340    84.173     0.200
     4.856    92.747     0.200
     4.856    93.145     0.200
     5.303   101.937     0.200
     5.523   105.372     0.200
     5.497   107.166     0.200
     6.883   131.992     0.200
     2.245    43.282     0.200
     2.566    50.229     0.200
     2.566    49.026     0.200
     2.637    50.698     0.200
     2.758    52.596     0.200
     2.758    52.698     0.200
     3.048    56.403     0.200
     3.048    58.606     0.200
     3.347    64.328     0.200
     3.362    65.047     0.200
     3.362    63.844     0.200
     3.417    65.809     0.200
     3.734    72.109     0.200
     3.933    74.781     0.200
     3.933    73.577     0.200
     4.344    82.989     0.200
     4.340    84.827     0.200
     4.851    91.673     0.200
     5.294   101.496     0.200
     5.518   105.387     0.200
     5.507   109.014     0.200
     6.685   128.463     0.200
     6.890   131.778     0.200
     2.247    43.840     0.200
     2.247    43.645     0.200
     2.572    50.647     0.200
     2.572    49.452     0.200
     2.637    50.493     0.200
     2.759    52.867     0.200
     2.759    53.273     0.200
     3.052    57.646     0.200
     3.052    58.942     0.200
     3.341    63.776     0.200
     3.341    64.572     0.200
     3.362    63.631     0.200
     3.362    64.631     0.200
     3.420    68.249     0.200
     3.420    67.054     0.200
     3.735    72.382     0.200
     3.934    75.250     0.200
     3.934    73.555     0.200
     4.336    82.162     0.200
     4.336    82.458     0.200
     4.339    84.432     0.200
     4.339    85.033     0.200
     5.522   105.125     0.200
     5.522   105.531     0.200
     5.501   107.567     0.200
     6.686   128.637     0.200
     6.888   132.088     0.200
     8.128   156.811     0.200
     9.915   191.850     0.200
     2.232    43.170     0.200
     2.232    43.572     0.200
     2.564    49.603     0.200
     2.654    50.955     0.200
     2.776    52.527     0.200
     2.776    53.324     0.200
     3.040    58.545     0.200
     3.327    63.791     0.200
     3.327    65.689     0.200
     3.407    65.954     0.200
     3.407    67.454     0.200
     3.379    65.087     0.200
     3.379    65.489     0.200
     3.379    66.087     0.200
     3.719    70.618     0.200
     3.719    71.521     0.200
     3.951    74.707     0.200
     4.078    80.931     0.200
     4.354    85.006     0.200
     4.354    84.807     0.200
     4.869    92.597     0.200
     4.869    93.394     0.200
     5.314   100.806     0.200
     5.509   105.432     0.200
     5.509   108.333     0.200
     5.624   112.471     0.200
     6.670   129.583     0.200
     6.871   132.037     0.200
     8.115   156.217     0.200
     9.898   189.306     0.200
     2.226    43.200     0.200
     2.560    49.209     0.200
     2.660    50.842     0.200
     2.782    52.213     0.200
     3.035    56.266     0.200
     3.035    58.966     0.200
     3.323    64.704     0.200
     3.385    64.775     0.200
     3.385    65.575     0.200
     3.713    71.351     0.200
     3.958    76.095     0.200
     4.072    80.061     0.200
     4.360    86.297     0.200
     4.876    91.084     0.200
     4.876    93.384     0.200
     5.244   101.489     0.200
     5.320   102.698     0.200
     5.504   105.656     0.200
     6.664   128.014     0.200
     6.664   129.214     0.200
     2.251    43.102     0.200
     2.251    43.702     0.200
     2.576    49.003     0.200
     2.634    50.433     0.200
     2.756    51.103     0.200
     2.756    53.103     0.200
     3.056    59.100     0.200
     3.359    64.067     0.200
     3.359    65.168     0.200
     3.424    68.006     0.200
     3.738    71.741     0.200
     3.932    73.984     0.200
     3.932    75.184     0.200
     4.097    80.762     0.200
     4.335    84.780     0.200
     4.850    90.972     0.200
     4.850    92.672     0.200
     5.269   100.582     0.200
     5.269   102.082     0.200
     5.296   102.269     0.200
     6.690   129.502     0.200
     2.244    43.137     0.200
     2.244    43.637     0.200
     2.573    49.191     0.200
     2.642    50.485     0.200
     2.765    51.748     0.200
     2.765    52.850     0.200
     3.051    57.717     0.200
     3.051    58.616     0.200
     3.333    63.929     0.200
     3.333    63.031     0.200
     3.419    66.324     0.200
     3.368    64.016     0.200
     3.368    65.016     0.200
     3.731    70.684     0.200
     3.731    71.086     0.200
     3.941    74.227     0.200
     3.941    75.828     0.200
     4.089    79.898     0.200
     4.329    82.099     0.200
     4.859    93.917     0.200
     5.261   100.724     0.200
     5.261   101.622     0.200
     5.305   104.212     0.200
     5.520   106.404     0.200
     5.500   108.139     0.200
     6.681   129.348     0.200
     6.681   129.648     0.200
     6.881   131.521     0.200
     2.260    43.217     0.200
     2.585    49.732     0.200
     2.625    50.463     0.200
     2.748    52.327     0.200
     3.066    59.818     0.200
     3.344    64.065     0.200
     3.350    66.592     0.200
     3.434    66.921     0.200
     3.748    71.756     0.200
     3.924    75.702     0.200
     4.332    82.640     0.200
     4.326    85.114     0.200
     4.842    91.891     0.200
     5.289   103.471     0.200
     5.489   108.338     0.200
     6.699   131.118     0.200
     6.898   134.095     0.200
     2.245    43.608     0.200
     2.571    49.413     0.200
     2.638    50.522     0.200
     4.337    81.705     0.200
     2.211    42.389     0.200
     2.538    48.581     0.200
     3.334    64.188     0.200
     4.350    81.629     0.200
     2.228    42.678     0.200
     2.228    42.978     0.200
     2.555    49.370     0.200
     2.654    50.911     0.200
     2.774    52.707     0.200
     2.774    53.007     0.200
     3.034    56.182     0.200
     3.034    57.882     0.200
     3.336    62.851     0.200
     3.336    64.151     0.200
     3.379    63.755     0.200
     3.379    64.955     0.200
     3.949    73.895     0.200
     3.949    74.895     0.200
     4.342    83.110     0.200
     4.357    85.142     0.200
     4.867    92.887     0.200
     6.874   131.669     0.200
     7.560   146.454     0.200
     2.046    40.854     0.200
     2.307    45.007     0.200
     2.307    44.507     0.200
     2.511    49.433     0.200
     2.562    49.032     0.200
     2.901    57.073     0.200
     3.391    65.662     0.200
     3.534    69.889     0.200
     4.127    79.369     0.200
     4.577    86.522     0.200
     4.577    88.725     0.200
     5.054    98.158     0.200
     5.630   107.623     0.200
     5.870   114.229     0.200
     6.065   117.752     0.200
     6.110   117.030     0.200
     2.147    40.162     0.200
     2.147    41.064     0.200
     2.616    49.102     0.200
     2.616    48.903     0.200
     2.823    53.885     0.200
     3.062    59.090     0.200
     3.062    58.090     0.200
     3.013    57.366     0.200
     2.978    56.570     0.200
     2.978    57.371     0.200
     3.370    65.797     0.200
     3.370    66.195     0.200
     3.594    68.384     0.200
     3.594    69.185     0.200
     3.561    67.160     0.200
     4.110    76.961     0.200
     4.160    78.582     0.200
     4.160    78.781     0.200
     4.487    87.361     0.200
     5.131    99.045     0.200
     5.081    96.732     0.200
     5.466   104.437     0.200
     5.598   110.960     0.200
     5.553   106.018     0.200
     6.535   126.563     0.200
     6.657   127.534     0.200
    14.321   277.970     0.200
     2.246    43.493     0.200
     2.569    48.822     0.200
     2.569    49.021     0.200
     2.637    50.729     0.200
     2.758    53.019     0.200
     2.758    53.316     0.200
     3.050    58.506     0.200
     3.362    64.672     0.200
     3.418    67.811     0.200
     3.418    66.710     0.200
     3.735    72.320     0.200
     3.933    72.901     0.200
     3.933    76.401     0.200
     4.092    80.652     0.200
     4.341    83.243     0.200
     4.339    84.863     0.200
     4.851    92.993     0.200
     5.265   102.964     0.200
     5.295   101.207     0.200
     5.520   105.085     0.200
     5.505   107.562     0.200
     6.686   128.277     0.200
     2.074    41.188     0.200
     2.136    40.571     0.200
     2.136    41.371     0.200
     2.710    51.766     0.200
     2.710    52.566     0.200
     2.790    52.834     0.200
     2.893    55.237     0.200
     3.416    64.531     0.200
     3.483    66.352     0.200
     3.650    70.004     0.200
     3.650    70.804     0.200
     4.442    87.360     0.200
     4.557    86.416     0.200
     4.863    93.246     0.200
     4.863    92.146     0.200
     5.170   101.464     0.200
     5.259   100.323     0.200
     5.367   101.867     0.200
     5.714   112.210     0.200
     6.604   128.626     0.200
     2.117    40.112     0.200
     2.154    40.878     0.200
     2.760    51.303     0.200
     2.760    51.502     0.200
     2.796    51.892     0.200
     2.796    52.091     0.200
     3.405    64.178     0.200
     3.306    61.630     0.200
     3.306    62.231     0.200
     3.786    72.131     0.200
     3.786    72.432     0.200
     4.016    76.149     0.200
     3.880    73.936     0.200
     4.266    81.033     0.200
     4.214    78.936     0.200
     4.820    91.964     0.200
     5.486   106.097     0.200
     5.545   108.566     0.200
     5.772   110.455     0.200
     5.872   111.488     0.200
     7.218   138.580     0.200
     7.547   144.442     0.200
     2.263    44.358     0.200
     2.578    48.382     0.200
     2.692    50.752     0.200
     4.657    88.619     0.200
     2.234    43.082     0.200
     2.234    43.184     0.200
     2.565    49.829     0.200
     2.565    48.927     0.200
     2.651    50.821     0.200
     2.773    53.792     0.200
     2.773    53.894     0.200
     3.041    56.463     0.200
     3.041    57.963     0.200
     3.330    62.400     0.200
     3.330    63.599     0.200
     3.376    64.054     0.200
     3.376    65.054     0.200
     3.409    67.972     0.200
     3.721    71.927     0.200
     3.721    71.427     0.200
     3.949    73.972     0.200
     4.332    82.302     0.200
     4.352    84.869     0.200
     4.867    93.062     0.200
     5.511   105.450     0.200
     5.508   107.679     0.200
     6.873   131.342     0.200
     2.241    43.434     0.200
     2.573    49.660     0.200
     2.646    50.909     0.200
     3.327    63.858     0.200
     2.639    49.590     0.200
     3.365    64.418     0.200
     2.182    42.762     0.200
     2.286    42.851     0.200
     2.775    52.739     0.200
     2.854    54.019     0.200
     2.939    54.926     0.200
     3.146    61.714     0.200
     3.374    62.347     0.200
     3.374    65.449     0.200
     3.506    66.912     0.200
     3.563    69.247     0.200
     4.101    75.960     0.200
     4.101    78.460     0.200
     4.519    86.685     0.200
     4.579    89.083     0.200
     5.028    97.842     0.200
     5.012    95.429     0.200
     5.247    99.990     0.200
     5.405   104.944     0.200
     6.460   125.234     0.200
     6.748   128.472     0.200
     2.242    43.322     0.200
     2.242    43.517     0.200
     2.566    49.737     0.200
     2.566    48.940     0.200
     2.641    50.361     0.200
     2.762    52.949     0.200
     2.762    53.551     0.200
     3.046    56.831     0.200
     3.046    58.730     0.200
     3.342    63.579     0.200
     3.342    64.376     0.200
     3.415    66.535     0.200
     3.415    67.738     0.200
     3.366    64.308     0.200
     3.366    64.504     0.200
     3.730    70.349     0.200
     3.730    72.247     0.200
     3.937    73.836     0.200
     3.937    75.039     0.200
     4.088    80.781     0.200
     4.341    83.428     0.200
     4.343    84.198     0.200
     4.855    92.330     0.200
     4.855    91.228     0.200
     5.299   102.650     0.200
     5.516   104.809     0.200
     5.516   106.114     0.200
     5.507   107.610     0.200
     6.682   128.509     0.200
     6.886   132.130     0.200
     7.532   145.985     0.200
     8.130   158.007     0.200
     2.246    43.269     0.200
     2.246    43.566     0.200
     2.571    48.974     0.200
     2.571    49.372     0.200
     2.638    50.384     0.200
     2.760    51.963     0.200
     2.760    52.767     0.200
     3.051    56.567     0.200
     3.051    58.669     0.200
     3.341    63.187     0.200
     3.341    64.187     0.200
     3.363    63.820     0.200
     3.363    63.922     0.200
     3.419    67.975     0.200
     3.734    71.202     0.200
     3.734    72.202     0.200
     3.935    75.050     0.200
     4.091    80.729     0.200
     4.337    82.462     0.200
     4.340    84.729     0.200
     4.340    85.628     0.200
     4.853    92.433     0.200
     5.298   101.545     0.200
     5.502   106.663     0.200
     5.520   104.453     0.200
     5.520   105.351     0.200
     6.685   129.965     0.200
     6.887   132.303     0.200
     7.535   148.045     0.200
     8.128   157.025     0.200
     8.278   159.969     0.200
     2.059    40.212     0.200
     2.313    44.751     0.200
     2.269    44.865     0.200
     2.288    44.142     0.200
     2.539    50.411     0.200
     2.539    50.309     0.200
     2.656    52.147     0.200
     2.842    54.271     0.200
     2.842    53.771     0.200
     2.844    53.651     0.200
     2.844    52.948     0.200
     3.233    63.017     0.200
     3.233    62.916     0.200
     3.543    68.001     0.200
     3.656    69.679     0.200
     3.656    70.878     0.200
     4.267    81.146     0.200
     4.267    81.447     0.200
     4.267    82.408     0.200
     4.336    82.146     0.200
     4.740    89.331     0.200
     4.825    90.838     0.200
     5.232   100.781     0.200
     5.788   110.998     0.200
     6.020   115.286     0.200
     6.130   119.511     0.200
     6.120   120.418     0.200
     6.280   123.669     0.200
     6.632   129.842     0.200
    14.730   286.862     0.200
     2.248    43.391     0.200
     2.571    49.422     0.200
     2.571    48.922     0.200
     2.635    50.775     0.200
     2.756    52.759     0.200
     2.756    53.157     0.200
     3.052    58.303     0.200
     3.346    63.176     0.200
     3.346    64.082     0.200
     3.360    64.917     0.200
     3.737    71.715     0.200
     3.931    73.840     0.200
     3.931    76.441     0.200
     4.094    78.851     0.200
     4.340    82.870     0.200
     4.337    85.511     0.200
     5.267   100.257     0.200
     5.267   101.757     0.200
     5.294   101.748     0.200
     5.522   106.085     0.200
     5.503   107.102     0.200
     6.891   132.402     0.200
     2.241    43.600     0.200
     2.241    43.803     0.200
     2.564    50.042     0.200
     2.564    49.338     0.200
     2.640    50.944     0.200
     2.761    53.840     0.200
     2.761    53.942     0.200
     3.045    56.821     0.200
     3.045    58.622     0.200
     3.345    63.718     0.200
     3.365    64.289     0.200
     3.365    65.192     0.200
     3.413    67.223     0.200
     3.730    72.223     0.200
     3.730    72.426     0.200
     3.936    76.029     0.200
     4.087    78.860     0.200
     4.344    83.463     0.200
     4.343    84.873     0.200
     4.853    92.118     0.200
     4.853    92.520     0.200
     5.260   101.669     0.200
     5.297   102.246     0.200
     5.515   105.700     0.200
     5.510   107.960     0.200
     6.682   128.781     0.200
     6.887   132.091     0.200
     9.116   175.274     0.200
     2.197    42.636     0.200
     2.497    47.938     0.200
     2.497    47.739     0.200
     2.671    51.406     0.200
     2.779    53.244     0.200
     2.779    53.947     0.200
     2.988    57.297     0.200
     2.988    58.797     0.200
     3.358    65.982     0.200
     3.358    66.385     0.200
     3.379    64.443     0.200
     3.379    64.842     0.200
     3.390    65.213     0.200
     3.950    74.174     0.200
     3.950    76.674     0.200
     4.043    79.198     0.200
     4.383    85.523     0.200
     4.383    85.824     0.200
     4.407    84.141     0.200
     4.407    83.739     0.200
     4.866    93.686     0.200
     5.221    99.841     0.200
     5.294    99.488     0.200
     5.294   103.988     0.200
     5.460   103.861     0.200
     5.578   109.572     0.200
     5.690   112.970     0.200
     6.647   128.309     0.200
     6.878   133.201     0.200
     8.700   167.144     0.200
     2.491    47.805     0.200
     3.364    63.409     0.200
     4.399    84.636     0.200
     2.203    42.532     0.200
     2.497    49.099     0.200
     2.497    48.199     0.200
     2.663    51.260     0.200
     2.770    53.216     0.200
     2.770    53.016     0.200
     2.992    58.123     0.200
     3.362    66.205     0.200
     3.390    65.378     0.200
     3.382    65.075     0.200
     3.382    65.275     0.200
     3.941    74.748     0.200
     4.048    77.993     0.200
     4.376    87.166     0.200
     4.416    84.208     0.200
     4.856    93.863     0.200
     5.228   100.728     0.200
     5.284   100.976     0.200
     5.284   100.775     0.200
     5.463   102.781     0.200
     5.579   109.431     0.200
     6.654   127.888     0.200
     6.888   133.351     0.200
     2.506    47.673     0.200
     2.669    51.673     0.200
     2.669    51.573     0.200
     2.779    54.089     0.200
     2.779    53.889     0.200
     2.995    57.162     0.200
     2.995    58.362     0.200
     3.371    66.478     0.200
     3.371    65.378     0.200
     3.365    66.451     0.200
     3.389    64.969     0.200
     3.389    65.370     0.200
     3.951    74.510     0.200
     3.951    75.410     0.200
     4.047    78.488     0.200
     4.396    84.415     0.200
     4.379    86.511     0.200
     4.867    93.819     0.200
     4.867    94.020     0.200
     5.225   101.145     0.200
     5.298   101.793     0.200
     5.466   103.827     0.200
     5.569   109.931     0.200
     5.681   111.021     0.200
     6.649   128.720     0.200
     6.877   132.866     0.200
     8.703   168.551     0.200
     2.190    42.337     0.200
     2.190    42.439     0.200
     2.490    47.728     0.200
     2.678    51.443     0.200
     2.785    53.388     0.200
     2.785    53.286     0.200
     2.981    57.099     0.200
     2.981    57.798     0.200
     3.351    66.183     0.200
     3.377    64.986     0.200
     3.377    65.385     0.200
     3.397    65.251     0.200
     3.397    64.853     0.200
     3.397    64.751     0.200
     3.957    73.820     0.200
     3.957    74.617     0.200
     4.035    78.997     0.200
     4.390    86.057     0.200
     4.409    83.538     0.200
     4.409    83.136     0.200
     4.872    91.134     0.200
     4.872    91.033     0.200
     5.214   100.643     0.200
     5.300   102.044     0.200
     6.640   128.407     0.200
     6.873   133.188     0.200
     2.197    42.779     0.200
     2.671    51.846     0.200
     2.780    53.376     0.200
     2.780    53.876     0.200
     2.990    57.828     0.200
     2.990    56.828     0.200
     3.360    65.715     0.200
     3.375    65.740     0.200
     3.375    64.640     0.200
     3.391    65.048     0.200
     3.391    64.548     0.200
     3.952    74.301     0.200
     3.952    75.601     0.200
     4.043    78.639     0.200
     4.383    85.873     0.200
     4.402    83.845     0.200
     4.868    93.113     0.200
     5.221    98.990     0.200
     5.221   102.189     0.200
     5.297   101.503     0.200
     5.461   104.791     0.200
     5.575   109.058     0.200
     6.646   127.760     0.200
     2.194    42.076     0.200
     2.194    42.474     0.200
     2.675    52.462     0.200
     2.784    53.490     0.200
     2.784    54.089     0.200
     2.987    58.216     0.200
     3.357    65.905     0.200
     3.372    64.834     0.200
     3.395    64.664     0.200
     3.690    70.916     0.200
     4.401    84.418     0.200
     4.386    85.291     0.200
     4.872    93.827     0.200
     5.218   100.686     0.200
     5.301   101.818     0.200
     5.458   104.082     0.200
     5.577   108.997     0.200
     6.643   126.759     0.200
     6.872   131.078     0.200
     2.234    42.685     0.200
     2.234    43.287     0.200
     2.567    48.301     0.200
     2.567    50.101     0.200
     2.653    49.694     0.200
     2.653    51.495     0.200
     2.776    52.960     0.200
     2.776    54.257     0.200
     3.042    56.853     0.200
     3.042    58.650     0.200
     3.325    62.851     0.200
     3.325    62.152     0.200
     3.410    67.962     0.200
     3.410    66.064     0.200
     3.379    64.927     0.200
     3.379    63.826     0.200
     3.720    70.737     0.200
     3.720    71.140     0.200
     3.952    74.037     0.200
     3.952    76.838     0.200
     4.079    78.646     0.200
     4.327    81.656     0.200
     4.327    81.957     0.200
     4.353    84.654     0.200
     4.870    93.227     0.200
     5.251   101.077     0.200
     5.315   101.829     0.200
     5.511   104.741     0.200
     6.671   127.601     0.200
     6.870   131.679     0.200
     2.305    44.587     0.200
     2.573    49.459     0.200
     2.559    49.822     0.200
     2.559    48.623     0.200
     2.667    51.063     0.200
     2.667    50.464     0.200
     3.085    59.580     0.200
     3.085    58.680     0.200
     3.277    63.037     0.200
     3.277    64.237     0.200
     3.277    61.836     0.200
     3.454    66.870     0.200
     3.454    66.370     0.200
     3.456    67.947     0.200
     3.456    67.546     0.200
     3.805    71.680     0.200
     3.839    73.383     0.200
     4.150    80.751     0.200
     4.273    84.211     0.200
     4.273    83.912     0.200
     4.424    84.049     0.200
     4.424    84.350     0.200
     4.755    88.892     0.200
     4.755    92.091     0.200
     5.190   100.115     0.200
     5.190    97.416     0.200
     5.511   107.067     0.200
     5.558   107.125     0.200
     6.758   131.018     0.200
     6.988   134.234     0.200
     2.229    42.821     0.200
     2.229    43.220     0.200
     2.552    49.050     0.200
     2.552    48.949     0.200
     2.653    51.170     0.200
     2.772    53.279     0.200
     2.772    53.584     0.200
     3.032    58.841     0.200
     3.342    64.727     0.200
     3.342    64.829     0.200
     3.400    67.044     0.200
     3.400    67.146     0.200
     3.377    64.525     0.200
     3.377    63.618     0.200
     3.718    71.238     0.200
     3.718    72.144     0.200
     4.074    79.984     0.200
     3.946    75.273     0.200
     3.946    74.476     0.200
     4.348    82.481     0.200
     4.348    82.684     0.200
     4.356    84.494     0.200
     4.864    93.168     0.200
     5.502   105.622     0.200
     5.521   108.596     0.200
     5.635   110.960     0.200
     6.669   129.396     0.200
     6.877   132.075     0.200
     7.520   145.569     0.200
    10.049   193.053     0.200
    14.046   269.938     0.200
    14.254   276.322     0.200
    17.905   353.027     0.200
    24.617   482.981     0.200
     2.235    43.622     0.200
     2.235    42.520     0.200
     2.645    50.839     0.200
     2.645    50.538     0.200
     2.764    52.950     0.200
     3.038    58.653     0.200
     3.348    64.537     0.200
     3.406    67.054     0.200
     3.406    67.155     0.200
     3.369    64.691     0.200
     3.369    64.288     0.200
     3.725    72.435     0.200
     3.939    75.639     0.200
     4.351    84.736     0.200
     4.351    81.935     0.200
     4.349    84.854     0.200
     4.349    84.256     0.200
     4.856    93.335     0.200
     4.856    92.433     0.200
     5.255   101.583     0.200
     5.508   105.030     0.200
     5.518   108.114     0.200
     5.631   111.430     0.200
     6.677   128.991     0.200
     6.884   133.365     0.200
     7.527   146.761     0.200
    14.261   275.599     0.200
    17.911   353.142     0.200
    17.968   354.640     0.200
    18.496   365.719     0.200
    18.581   364.724     0.200
    20.808   423.089     0.200
     2.152    42.972     0.200
     2.315    44.964     0.200
     2.568    48.221     0.200
     2.543    49.409     0.200
     2.646    50.603     0.200
     3.089    59.339     0.200
     3.484    67.119     0.200
     3.817    72.437     0.200
     3.817    71.640     0.200
     4.160    81.535     0.200
     4.262    84.649     0.200
     4.451    85.437     0.200
     4.733    90.353     0.200
     5.164    99.424     0.200
     5.344   103.416     0.200
     5.562   106.781     0.200
     6.772   132.154     0.200
     7.011   135.366     0.200
     2.674    50.643     0.200
     2.692    51.031     0.200
     3.338    63.784     0.200
     2.258    43.736     0.200
     2.258    43.134     0.200
     2.231    43.945     0.200
     2.578    49.899     0.200
     2.625    49.450     0.200
     2.746    53.034     0.200
     2.746    52.432     0.200
     2.879    54.791     0.200
     3.061    58.560     0.200
     3.061    57.959     0.200
     3.352    63.166     0.200
     3.352    63.865     0.200
     3.429    66.863     0.200
     3.429    67.563     0.200
     3.350    64.291     0.200
     3.350    63.291     0.200
     3.746    71.861     0.200
     3.922    75.516     0.200
     3.922    73.215     0.200
     4.103    80.394     0.200
     4.341    82.118     0.200
     4.327    84.782     0.200
     4.839    92.203     0.200
     5.277   102.603     0.200
     5.496   107.139     0.200
     5.531   105.637     0.200
     6.698   130.017     0.200
     6.901   132.251     0.200
     2.155    41.218     0.200
     2.412    45.720     0.200
     2.924    56.741     0.200
     3.664    69.514     0.200
     4.506    85.282     0.200
     2.232    43.155     0.200
     2.253    44.114     0.200
     2.550    48.645     0.200
     2.646    50.624     0.200
     2.764    52.850     0.200
     2.764    51.948     0.200
     2.900    55.369     0.200
     3.034    57.706     0.200
     3.034    57.604     0.200
     3.352    64.890     0.200
     3.352    63.992     0.200
     3.402    66.905     0.200
     3.370    64.880     0.200
     3.723    71.260     0.200
     4.357    83.764     0.200
     4.351    85.030     0.200
     4.856    93.738     0.200
     5.253   100.211     0.200
     5.296   103.100     0.200
     5.504   105.581     0.200
     6.675   127.513     0.200
     6.885   130.459     0.200
     2.201    42.967     0.200
     2.329    45.185     0.200
     2.329    44.880     0.200
     2.455    47.314     0.200
     2.666    51.437     0.200
     2.885    56.192     0.200
     2.927    56.705     0.200
     2.927    56.104     0.200
     3.434    65.682     0.200
     3.508    68.527     0.200
     3.508    66.121     0.200
     3.641    70.975     0.200
     3.808    73.819     0.200
     3.911    77.815     0.200
     4.428    84.689     0.200
     4.512    86.709     0.200
     4.904    94.533     0.200
     5.237   101.935     0.200
     5.693   109.022     0.200
     5.908   112.013     0.200
     6.859   132.913     0.200
     7.118   136.585     0.200
     7.310   140.052     0.200
     2.122    41.037     0.200
     2.122    39.638     0.200
     2.469    49.089     0.200
     2.617    49.264     0.200
     2.867    54.351     0.200
     3.009    56.685     0.200
     2.998    57.121     0.200
     2.998    56.820     0.200
     3.027    57.983     0.200
     3.127    60.118     0.200
     3.353    65.579     0.200
     3.560    67.862     0.200
     3.607    68.411     0.200
     4.209    79.188     0.200
     2.171    42.160     0.200
     2.303    44.914     0.200
     2.303    43.715     0.200
     2.425    46.693     0.200
     2.701    51.375     0.200
     2.921    55.200     0.200
     2.898    55.673     0.200
     2.898    55.372     0.200
     3.470    65.893     0.200
     3.470    64.794     0.200
     3.483    67.242     0.200
     3.648    71.425     0.200
     3.878    75.936     0.200
     4.198    80.896     0.200
     4.395    85.205     0.200
     4.404    84.999     0.200
     4.546    87.340     0.200
     4.886    93.367     0.200
     5.203   101.172     0.200
     5.944   115.322     0.200
     7.334   141.705     0.200
     2.031    39.515     0.200
     2.429    45.880     0.200
     2.421    46.374     0.200
     2.515    46.474     0.200
     2.630    51.430     0.200
     2.669    51.478     0.200
     3.181    60.604     0.200
     3.181    59.604     0.200
     3.132    60.069     0.200
     3.132    58.772     0.200
     3.556    68.128     0.200
     3.556    68.730     0.200
     3.603    68.579     0.200
     3.684    70.027     0.200
     3.939    75.451     0.200
     4.148    81.414     0.200
     4.272    82.371     0.200
     4.515    86.728     0.200
     4.599    87.048     0.200
     4.599    86.247     0.200
     5.029    97.030     0.200
     5.462   105.186     0.200
     5.480   105.570     0.200
     5.573   109.737     0.200
     5.655   108.628     0.200
     6.893   133.276     0.200
     7.146   137.131     0.200
     7.279   141.074     0.200
     9.952   191.086     0.200
    13.776   265.570     0.200
    17.704   350.469     0.200
    18.164   357.530     0.200
    18.673   363.136     0.200
     2.236    43.713     0.200
     2.257    43.766     0.200
     2.571    49.204     0.200
     2.652    50.565     0.200
     2.776    53.217     0.200
     2.906    55.799     0.200
     3.321    62.650     0.200
     3.321    66.050     0.200
     3.378    65.490     0.200
     3.952    75.993     0.200
     3.952    75.094     0.200
     4.082    78.874     0.200
     4.322    82.876     0.200
     4.351    85.233     0.200
     4.870    93.580     0.200
     5.253   100.509     0.200
     5.316   101.468     0.200
     5.316   100.968     0.200
     5.501   106.916     0.200
     6.673   128.640     0.200
     6.870   132.540     0.200
     7.303   142.285     0.200
     7.568   144.986     0.200
     2.250    43.589     0.200
     2.578    48.453     0.200
     2.578    50.852     0.200
     2.759    52.938     0.200
     2.759    52.336     0.200
     2.890    55.616     0.200
     3.057    58.673     0.200
     3.336    63.510     0.200
     3.336    65.010     0.200
     3.362    64.508     0.200
     3.362    65.008     0.200
     3.737    72.135     0.200
     3.935    75.513     0.200
     3.935    74.114     0.200
     4.095    79.948     0.200
     4.329    82.327     0.200
     4.337    85.533     0.200
     4.853    92.206     0.200
     4.853    91.901     0.200
     5.300   101.088     0.200
     5.526   105.554     0.200
     5.495   106.015     0.200
     6.886   132.175     0.200
     7.286   139.404     0.200
     8.797   168.076     0.200
     2.246    43.792     0.200
     2.246    44.484     0.200
     2.575    49.846     0.200
     2.764    53.346     0.200
     2.764    53.045     0.200
     2.895    56.121     0.200
     3.053    59.070     0.200
     3.053    57.871     0.200
     3.333    65.010     0.200
     3.333    64.709     0.200
     3.421    67.980     0.200
     3.421    67.378     0.200
     3.366    65.415     0.200
     3.366    65.014     0.200
     3.732    72.141     0.200
     3.940    76.425     0.200
     4.091    79.952     0.200
     4.091    79.353     0.200
     4.328    82.693     0.200
     4.341    84.843     0.200
     4.858    93.812     0.200
     4.858    92.011     0.200
     5.304   101.102     0.200
     5.522   105.957     0.200
     5.497   107.845     0.200
     5.612   111.136     0.200
     6.683   127.905     0.200
     6.882   132.385     0.200
     8.119   159.047     0.200
     8.802   168.184     0.200
    20.487   397.780     0.200
     2.253    43.356     0.200
     2.241    43.590     0.200
     2.585    50.382     0.200
     2.585    50.577     0.200
     2.635    50.192     0.200
     2.760    52.335     0.200
     3.062    59.420     0.200
     3.062    59.615     0.200
     3.329    62.887     0.200
     3.739    71.416     0.200
     3.936    76.007     0.200
     3.936    75.304     0.200
     4.320    82.325     0.200
     4.320    82.426     0.200
     4.334    84.363     0.200
     4.855    93.495     0.200
     4.855    93.292     0.200
     5.530   106.007     0.200
     6.689   127.583     0.200
     6.885   131.998     0.200
     2.038    40.564     0.200
     2.290    43.023     0.200
     2.624    50.326     0.200
     2.704    51.284     0.200
     3.017    57.838     0.200
     3.127    59.555     0.200
     3.151    60.280     0.200
     3.270    62.290     0.200
     3.353    63.516     0.200
     3.738    70.522     0.200
     4.297    79.901     0.200
     4.361    83.452     0.200
     4.720    92.263     0.200
     5.166    98.259     0.200
     5.212    99.524     0.200
     5.624   107.920     0.200
     5.786   113.021     0.200
     6.304   121.179     0.200
     6.538   124.456     0.200
     2.134    40.531     0.200
     2.134    40.230     0.200
     2.368    46.304     0.200
     2.507    46.680     0.200
     2.507    46.579     0.200
     2.763    52.598     0.200
     2.888    54.139     0.200
     2.958    55.724     0.200
     2.958    55.224     0.200
     3.017    57.828     0.200
     3.017    56.928     0.200
     3.241    61.721     0.200
     3.241    60.020     0.200
     3.490    66.914     0.200
     3.490    67.315     0.200
     3.614    69.059     0.200
     4.063    76.220     0.200
     4.298    82.175     0.200
     2.338    46.045     0.200
     2.477    47.420     0.200
     2.551    48.656     0.200
     2.594    50.755     0.200
     2.829    53.716     0.200
     3.069    58.913     0.200
     3.344    64.406     0.200
     3.494    67.746     0.200
     3.658    70.339     0.200
     3.715    72.081     0.200
     4.040    77.382     0.200
     4.034    79.452     0.200
     4.315    82.775     0.200
     4.397    84.911     0.200
     4.578    87.399     0.200
     5.058    97.000     0.200
     5.264   103.393     0.200
     5.570   107.018     0.200
     5.816   110.956     0.200
     6.990   135.450     0.200
     7.009   134.131     0.200
     7.159   138.076     0.200
     7.318   140.822     0.200
     2.337    44.763     0.200
     2.476    47.644     0.200
     2.551    49.068     0.200
     2.593    51.579     0.200
     2.827    53.246     0.200
     3.068    58.935     0.200
     3.343    65.326     0.200
     3.497    66.233     0.200
     3.656    68.670     0.200
     3.714    71.800     0.200
     4.040    77.798     0.200
     4.034    78.769     0.200
     4.317    82.854     0.200
     4.397    84.828     0.200
     4.577    86.426     0.200
     5.056    97.338     0.200
     5.570   106.732     0.200
     5.815   110.977     0.200
     6.990   134.162     0.200
     7.008   134.556     0.200
     7.161   137.674     0.200
     7.316   142.356     0.200
     8.524   163.260     0.200
     2.038    38.837     0.200
     2.419    46.295     0.200
     2.423    45.943     0.200
     2.498    46.669     0.200
     2.498    48.069     0.200
     2.574    48.079     0.200
     2.667    52.394     0.200
     3.147    60.492     0.200
     3.147    59.091     0.200
     3.125    59.454     0.200
     3.125    60.153     0.200
     3.524    68.293     0.200
     3.680    71.480     0.200
     3.661    69.598     0.200
     3.661    69.699     0.200
     3.938    75.465     0.200
     4.163    80.639     0.200
     4.258    82.330     0.200
     4.611    88.515     0.200
     4.573    86.857     0.200
     4.573    86.557     0.200
     4.983    96.167     0.200
     4.983    94.167     0.200
     5.455   104.859     0.200
     5.552   107.130     0.200
     5.622   108.218     0.200
     5.622   107.919     0.200
     5.640   112.765     0.200
     6.893   132.186     0.200
     7.007   135.647     0.200
     7.181   138.026     0.200
     7.229   139.165     0.200
     8.509   161.818     0.200
     2.141    43.130     0.200
     2.391    44.804     0.200
     2.512    50.198     0.200
     2.820    53.807     0.200
     2.820    53.112     0.200
     2.906    55.201     0.200
     3.024    58.324     0.200
     3.024    59.121     0.200
     3.179    61.919     0.200
     3.179    61.419     0.200
     3.183    62.171     0.200
     3.183    62.374     0.200
     3.160    61.834     0.200
     3.631    69.886     0.200
     3.631    69.746     0.200
     3.833    74.679     0.200
     4.197    80.635     0.200
     4.197    78.432     0.200
     4.321    81.381     0.200
     4.321    83.685     0.200
     4.321    82.381     0.200
     4.605    90.779     0.200
     5.000    95.565     0.200
     5.114    95.638     0.200
     5.282   100.869     0.200
     5.282    99.471     0.200
     5.540   107.362     0.200
     5.681   112.115     0.200
     5.810   116.678     0.200
     6.418   124.310     0.200
     6.630   126.640     0.200
     7.267   139.607     0.200
     8.946   173.317     0.200
     9.648   185.719     0.200
    14.242   278.458     0.200
    17.739   350.168     0.200
    18.219   359.360     0.200
    20.281   391.893     0.200
     2.137    40.772     0.200
     2.272    43.989     0.200
     2.736    52.877     0.200
     2.865    55.371     0.200
     2.955    56.228     0.200
     3.453    65.109     0.200
     3.453    68.009     0.200
     3.506    67.597     0.200
     3.664    69.752     0.200
     3.843    75.066     0.200
     3.879    74.435     0.200
     4.374    82.862     0.200
     4.391    83.871     0.200
     4.582    90.541     0.200
     4.862    93.069     0.200
     5.762   111.970     0.200
     5.980   115.625     0.200
     7.125   139.159     0.200
     7.185   140.254     0.200
     7.364   141.774     0.200
     2.250    43.171     0.200
     2.234    42.559     0.200
     2.560    48.055     0.200
     2.560    50.954     0.200
     2.627    50.470     0.200
     2.744    51.804     0.200
     2.880    54.819     0.200
     3.048    56.954     0.200
     3.369    64.607     0.200
     3.350    64.231     0.200
     3.417    65.249     0.200
     3.918    74.701     0.200
     4.096    78.630     0.200
     4.333    83.561     0.200
     4.835    92.396     0.200
     5.271   100.012     0.200
     5.276   101.655     0.200
     5.518   105.725     0.200
     6.694   128.108     0.200
     6.906   131.433     0.200
     7.527   144.990     0.200
     8.681   167.913     0.200
     2.249    42.549     0.200
     2.556    48.261     0.200
     3.046    57.248     0.200
     2.196    41.998     0.200
     2.292    43.980     0.200
     2.525    47.155     0.200
     2.685    51.188     0.200
     2.803    53.412     0.200
     2.938    57.132     0.200
     3.326    63.305     0.200
     3.369    64.807     0.200
     3.409    64.842     0.200
     3.409    66.642     0.200
     3.977    73.710     0.200
     3.977    76.311     0.200
     4.351    82.539     0.200
     4.389    85.804     0.200
     4.894    93.808     0.200
     5.332   102.697     0.200
     5.470   103.984     0.200
     6.636   128.577     0.200
     6.847   130.411     0.200
     7.582   146.742     0.200
     2.250    43.323     0.200
     2.241    44.530     0.200
     2.577    49.206     0.200
     2.635    50.830     0.200
     2.758    52.696     0.200
     2.889    55.968     0.200
     3.056    58.516     0.200
     3.338    64.025     0.200
     3.361    64.261     0.200
     3.424    67.222     0.200
     3.737    71.666     0.200
     3.934    77.175     0.200
     4.096    79.084     0.200
     4.336    84.782     0.200
     4.852    93.263     0.200
     5.268   101.707     0.200
     5.298   101.856     0.200
     5.526   106.297     0.200
     6.577   126.730     0.200
     6.888   133.699     0.200
     7.550   146.871     0.200
     8.703   166.412     0.200
    10.065   195.018     0.200
     2.254    43.271     0.200
     2.237    43.662     0.200
     2.579    48.576     0.200
     2.754    53.132     0.200
     3.059    59.069     0.200
     3.342    64.674     0.200
     3.357    63.999     0.200
     3.741    71.610     0.200
     3.930    73.411     0.200
     3.930    76.513     0.200
     4.099    77.630     0.200
     4.333    82.704     0.200
     4.332    84.411     0.200
     4.848    93.199     0.200
     5.272   101.949     0.200
     5.294   100.991     0.200
     5.529   106.252     0.200
     6.692   128.171     0.200
     6.892   132.638     0.200
     8.285   157.287     0.200
     2.209    41.413     0.200
     2.274    42.248     0.200
     2.450    46.098     0.200
     2.633    49.467     0.200
     2.633    51.967     0.200
     2.729    51.346     0.200
     2.904    53.997     0.200
     3.338    63.441     0.200
     3.436    63.587     0.200
     3.717    71.516     0.200
     3.853    74.220     0.200
     3.958    77.301     0.200
     4.157    77.982     0.200
     4.348    81.744     0.200
     4.684    89.125     0.200
     5.453   105.149     0.200
     5.526   109.059     0.200
     5.810   110.691     0.200
     7.015   134.323     0.200
     7.111   136.908     0.200
     8.742   167.770     0.200
     2.251    43.625     0.200
     2.241    44.631     0.200
     2.580    50.583     0.200
     2.636    49.930     0.200
     2.759    53.292     0.200
     2.890    55.067     0.200
     2.890    57.270     0.200
     3.058    58.002     0.200
     3.335    64.272     0.200
     3.362    64.662     0.200
     3.737    71.970     0.200
     3.935    75.764     0.200
     4.096    79.187     0.200
     4.327    82.588     0.200
     4.336    84.894     0.200
     4.853    92.855     0.200
     5.300   102.436     0.200
     5.527   105.992     0.200
     5.493   107.080     0.200
     6.688   129.533     0.200
     6.886   132.026     0.200
     7.552   145.051     0.200
     8.280   157.958     0.200
     8.706   167.695     0.200
     9.122   175.738     0.200
    10.065   193.632     0.200
     2.250    43.618     0.200
     2.250    43.016     0.200
     2.240    44.839     0.200
     2.574    49.837     0.200
     2.574    48.533     0.200
     2.634    51.038     0.200
     2.756    52.616     0.200
     2.887    56.280     0.200
     3.055    59.022     0.200
     3.344    64.457     0.200
     3.344    63.957     0.200
     3.359    65.576     0.200
     3.359    65.076     0.200
     3.738    71.853     0.200
     3.738    71.048     0.200
     3.931    75.695     0.200
     3.931    78.101     0.200
     3.931    73.195     0.200
     4.096    78.078     0.200
     4.335    84.780     0.200
     4.335    84.280     0.200
     4.337    82.456     0.200
     4.337    81.956     0.200
     4.849    93.086     0.200
     5.294   100.890     0.200
     5.294   100.992     0.200
     5.524   105.602     0.200
     5.500   106.297     0.200
     5.613   110.744     0.200
     6.574   127.157     0.200
     6.689   128.710     0.200
     6.891   133.057     0.200
     7.546   146.814     0.200
     8.282   159.822     0.200
     8.700   165.453     0.200
     9.115   176.007     0.200
     9.919   191.022     0.200
    10.067   192.993     0.200
    15.106   296.560     0.200
    17.906   354.471     0.200
    17.963   355.834     0.200
    18.580   367.318     0.200
    18.796   367.166     0.200
     2.059    40.931     0.200
     2.127    40.439     0.200
     2.336    44.300     0.200
     2.726    51.755     0.200
     2.816    53.797     0.200
     2.816    56.200     0.200
     2.901    55.412     0.200
     2.974    56.358     0.200
     3.424    66.106     0.200
     3.437    65.254     0.200
     3.972    75.714     0.200
     4.450    86.035     0.200
     4.497    86.374     0.200
     4.894    92.947     0.200
     5.158    98.770     0.200
     5.301   102.403     0.200
     5.373   102.356     0.200
     5.682   110.748     0.200
     6.588   126.374     0.200
     6.859   130.714     0.200
     7.542   145.643     0.200
     8.204   158.022     0.200
     9.993   190.839     0.200
     2.224    44.017     0.200
     2.224    43.818     0.200
     2.330    44.674     0.200
     2.621    50.383     0.200
     2.621    50.485     0.200
     2.735    51.157     0.200
     2.735    51.856     0.200
     2.780    53.331     0.200
     2.880    55.254     0.200
     2.880    54.856     0.200
     3.202    61.298     0.200
     3.202    60.700     0.200
     3.174    60.929     0.200
     3.174    59.328     0.200
     3.360    64.325     0.200
     3.360    64.653     0.200
     3.360    64.954     0.200
     3.536    67.203     0.200
     3.536    71.601     0.200
     3.789    72.151     0.200
     3.789    71.854     0.200
     3.962    74.629     0.200
     3.962    76.031     0.200
     4.138    78.877     0.200
     4.171    81.186     0.200
     4.288    82.724     0.200
     4.288    83.525     0.200
     4.884    93.173     0.200
     4.884    93.576     0.200
     5.335   103.904     0.200
     5.459   108.624     0.200
     6.732   129.801     0.200
     6.722   130.827     0.200
     7.313   141.224     0.200
     7.975   153.297     0.200
     8.297   158.139     0.200
     9.208   177.909     0.200
    10.076   193.778     0.200
    14.166   275.272     0.200
     2.223    42.256     0.200
     2.278    44.021     0.200
     2.573    48.269     0.200
     2.672    50.813     0.200
     2.800    53.323     0.200
     2.927    57.136     0.200
     3.039    57.537     0.200
     3.291    63.887     0.200
     3.400    65.922     0.200
     3.705    71.266     0.200
     3.977    76.692     0.200
     4.298    82.036     0.200
     4.368    84.822     0.200
     4.895    93.873     0.200
     5.236   100.789     0.200
     5.345   102.324     0.200
     5.506   105.142     0.200
     6.655   127.637     0.200
     6.844   130.328     0.200
     8.243   159.810     0.200
    10.026   192.187     0.200
     2.119    39.995     0.200
     2.945    55.658     0.200
     4.293    81.729     0.200
     6.741   128.459     0.200
     2.319    45.355     0.200
     2.463    48.075     0.200
     2.463    47.775     0.200
     2.575    49.861     0.200
     2.576    49.460     0.200
     2.857    54.275     0.200
     3.052    58.900     0.200
     3.052    59.606     0.200
     3.052    58.205     0.200
     3.371    65.680     0.200
     3.371    63.779     0.200
     3.493    69.559     0.200
     3.493    69.359     0.200
     3.644    69.589     0.200
     3.741    72.058     0.200
     3.741    75.558     0.200
     4.011    79.908     0.200
     4.011    79.708     0.200
     4.062    78.417     0.200
     4.297    83.872     0.200
     4.297    80.271     0.200
     4.421    86.019     0.200
     4.565    88.440     0.200
     4.565    88.139     0.200
     5.051    98.978     0.200
     5.335   106.774     0.200
     6.867   132.878     0.200
     7.012   135.991     0.200
     7.173   139.214     0.200
     7.312   142.584     0.200
     8.596   166.307     0.200
     8.894   171.422     0.200
    13.868   269.567     0.200
    14.601   281.137     0.200
    17.695   349.490     0.200
    18.368   364.469     0.200
    18.920   368.498     0.200
     2.425    47.672     0.200
     2.425    46.672     0.200
     2.598    50.448     0.200
     2.725    52.563     0.200
     2.725    52.263     0.200
     2.720    53.225     0.200
     3.224    62.140     0.200
     3.194    61.913     0.200
     3.194    62.194     0.200
     3.194    62.995     0.200
     3.419    65.667     0.200
     3.419    66.868     0.200
     3.594    70.228     0.200
     3.594    71.529     0.200
     3.777    71.791     0.200
     3.777    73.691     0.200
     3.777    74.191     0.200
     3.912    76.421     0.200
     4.162    81.804     0.200
     4.162    81.503     0.200
     4.271    83.433     0.200
     4.697    90.458     0.200
     5.163   100.913     0.200
     5.442   104.856     0.200
     5.463   109.621     0.200
     6.862   133.489     0.200
     7.041   135.501     0.200
     7.129   138.676     0.200
     7.710   148.290     0.200
     8.450   162.660     0.200
     8.997   174.077     0.200
    10.081   195.020     0.200
    10.233   198.246     0.200
    17.820   355.287     0.200
    17.977   353.682     0.200
    18.467   365.664     0.200
     2.458    46.986     0.200
     2.750    52.584     0.200
     3.244    62.318     0.200
     3.922    76.400     0.200
     5.454   104.023     0.200
     2.069    40.657     0.200
     2.432    46.920     0.200
     2.465    48.343     0.200
     2.603    49.330     0.200
     2.744    52.287     0.200
     2.721    52.554     0.200
     3.196    62.611     0.200
     3.237    61.327     0.200
     3.401    65.820     0.200
     3.606    69.127     0.200
     3.783    74.562     0.200
     3.916    74.608     0.200
     4.157    79.695     0.200
     4.278    82.581     0.200
     4.286    81.590     0.200
     4.703    90.120     0.200
     5.175   100.020     0.200
     5.336   104.730     0.200
     5.448   105.033     0.200
     6.865   132.685     0.200
     7.035   134.813     0.200
     7.135   138.147     0.200
     2.244    43.896     0.200
     2.242    44.105     0.200
     2.242    44.410     0.200
     2.560    49.292     0.200
     2.560    49.995     0.200
     2.636    50.614     0.200
     2.755    53.026     0.200
     2.755    52.229     0.200
     2.889    56.659     0.200
     3.045    59.139     0.200
     3.355    64.420     0.200
     3.355    63.818     0.200
     3.360    64.636     0.200
     3.360    65.269     0.200
     3.360    63.964     0.200
     3.413    66.642     0.200
     3.413    68.338     0.200
     3.734    72.199     0.200
     3.929    74.020     0.200
     3.929    77.419     0.200
     3.929    74.223     0.200
     4.340    84.522     0.200
     4.340    85.123     0.200
     4.354    82.768     0.200
     4.354    82.565     0.200
     4.847    93.416     0.200
     4.847    93.212     0.200
     5.264   100.848     0.200
     5.288   102.057     0.200
     5.288   101.659     0.200
     5.515   105.314     0.200
     5.515   105.017     0.200
     5.627   111.369     0.200
     6.685   129.558     0.200
     6.894   132.820     0.200
     7.537   145.627     0.200
     9.107   176.295     0.200
    14.031   270.090     0.200
    14.269   274.030     0.200
    15.115   295.890     0.200
    17.918   354.244     0.200
    18.572   363.857     0.200
    18.779   364.600     0.200
    20.474   394.363     0.200
     2.252    43.638     0.200
     2.239    43.792     0.200
     2.578    50.530     0.200
     2.633    50.694     0.200
     3.058    57.931     0.200
     3.359    64.425     0.200
     3.740    72.379     0.200
     4.332    83.269     0.200
     2.011    39.092     0.200
     2.269    44.287     0.200
     2.299    43.928     0.200
     2.649    50.945     0.200
     2.699    52.159     0.200
     3.060    58.055     0.200
     3.043    58.547     0.200
     3.332    63.180     0.200
     3.296    64.390     0.200
     3.767    73.505     0.200
     4.741    92.230     0.200
     4.864    93.699     0.200
     6.263   118.866     0.200
     6.281   118.958     0.200
     2.008    39.323     0.200
     2.102    42.026     0.200
     2.307    43.034     0.200
     2.307    43.733     0.200
     2.264    44.133     0.200
     2.705    51.694     0.200
     2.705    51.393     0.200
     2.648    51.850     0.200
     3.065    59.191     0.200
     3.065    59.992     0.200
     3.102    59.958     0.200
     3.102    58.259     0.200
     3.043    58.650     0.200
     3.159    60.394     0.200
     3.333    62.859     0.200
     3.296    63.892     0.200
     3.703    70.246     0.200
     3.703    69.746     0.200
     3.767    73.498     0.200
     3.767    71.697     0.200
     4.320    83.948     0.200
     4.331    84.117     0.200
     4.739    93.051     0.200
     4.866    93.871     0.200
     4.866    91.074     0.200
     5.163    97.808     0.200
     5.664   109.355     0.200
     5.774   111.871     0.200
     6.270   119.886     0.200
     6.283   121.137     0.200
     6.283   119.539     0.200
     7.131   135.738     0.200
     7.874   150.771     0.200
     7.908   152.674     0.200
     9.513   182.344     0.200
    14.344   277.676     0.200
    14.781   290.436     0.200
    17.656   347.739     0.200
    18.347   360.140     0.200
    18.918   372.833     0.200
    20.678   415.767     0.200
     2.351    45.495     0.200
     2.351    43.895     0.200
     2.447    46.173     0.200
     2.447    45.974     0.200
     2.600    49.798     0.200
     2.600    50.098     0.200
     2.687    50.480     0.200
     3.063    57.079     0.200
     3.063    58.185     0.200
     3.063    57.285     0.200
     3.246    61.656     0.200
     3.246    61.356     0.200
     3.621    69.175     0.200
     3.621    69.675     0.200
     3.643    69.520     0.200
     3.643    69.120     0.200
     3.618    66.914     0.200
     3.618    69.114     0.200
     4.008    76.257     0.200
     4.008    76.156     0.200
     4.080    79.426     0.200
     4.340    83.582     0.200
     4.519    86.694     0.200
     4.519    86.295     0.200
     4.534    86.328     0.200
     4.534    86.129     0.200
     4.970    93.338     0.200
     5.531   106.093     0.200
     5.522   108.766     0.200
     6.702   128.624     0.200
     6.963   133.680     0.200
     6.968   133.623     0.200
     7.210   138.293     0.200
     8.576   164.149     0.200
    10.223   196.829     0.200
    13.729   264.832     0.200
    14.515   278.015     0.200
    15.426   302.560     0.200
    17.641   350.300     0.200
    18.258   356.113     0.200
    20.609   398.649     0.200
     2.146    41.199     0.200
     2.685    51.310     0.200
     2.921    56.860     0.200
     2.896    55.751     0.200
     3.040    58.365     0.200
     3.158    61.496     0.200
     3.391    66.072     0.200
     3.563    68.668     0.200
     3.641    71.551     0.200
     3.975    76.154     0.200
     4.535    87.716     0.200
     5.102    99.604     0.200
     5.177    99.527     0.200
     5.480   104.490     0.200
     5.669   109.988     0.200
     6.564   125.841     0.200
     2.245    43.399     0.200
     2.251    43.624     0.200
     2.581    49.471     0.200
     2.581    49.370     0.200
     2.645    50.326     0.200
     2.771    52.962     0.200
     2.771    52.759     0.200
     2.900    56.459     0.200
     3.055    58.144     0.200
     3.055    58.737     0.200
     3.320    64.055     0.200
     3.320    63.555     0.200
     3.372    65.540     0.200
     3.372    65.641     0.200
     3.422    66.951     0.200
     3.422    68.756     0.200
     3.730    71.969     0.200
     4.090    79.462     0.200
     4.315    82.441     0.200
     4.315    82.340     0.200
     4.343    84.304     0.200
     4.343    84.109     0.200
     4.865    93.714     0.200
     4.865    93.417     0.200
     5.261   102.601     0.200
     5.606   110.987     0.200
     6.680   128.536     0.200
     6.874   132.171     0.200
     6.874   131.976     0.200
     2.040    40.608     0.200
     2.090    42.135     0.200
     2.252    44.036     0.200
     2.317    42.882     0.200
     2.317    44.280     0.200
     2.636    51.155     0.200
     2.717    51.516     0.200
     3.030    58.357     0.200
     3.077    59.011     0.200
     3.106    59.067     0.200
     3.147    61.391     0.200
     3.284    62.696     0.200
     3.346    63.473     0.200
     3.715    71.059     0.200
     3.755    71.703     0.200
     4.317    82.739     0.200
     4.319    83.412     0.200
     4.727    91.456     0.200
     5.175    99.126     0.200
     5.235    99.726     0.200
     5.654   109.235     0.200
     6.295   119.951     0.200
     6.511   123.933     0.200
     7.144   136.952     0.200
     7.669   148.523     0.200
     2.251    43.244     0.200
     2.242    43.342     0.200
     2.580    49.493     0.200
     2.636    50.141     0.200
     2.760    53.995     0.200
     2.890    55.374     0.200
     3.058    58.621     0.200
     3.333    63.913     0.200
     3.362    64.570     0.200
     3.426    66.626     0.200
     3.737    71.698     0.200
     3.936    73.271     0.200
     3.936    75.873     0.200
     4.096    79.705     0.200
     4.325    82.729     0.200
     4.336    84.002     0.200
     4.854    93.257     0.200
     5.268   100.432     0.200
     5.302   100.838     0.200
     5.527   105.405     0.200
     6.688   129.262     0.200
     6.885   132.457     0.200
     7.287   140.561     0.200
     2.248    43.369     0.200
     2.246    44.087     0.200
     2.581    49.280     0.200
     2.641    50.985     0.200
     2.765    54.431     0.200
     2.895    56.620     0.200
     3.057    58.528     0.200
     3.326    64.387     0.200
     3.367    64.609     0.200
     3.424    66.537     0.200
     3.733    72.231     0.200
     3.942    76.002     0.200
     4.094    78.330     0.200
     4.320    82.690     0.200
     4.340    84.959     0.200
     4.860    93.588     0.200
     5.264   100.467     0.200
     5.308   102.161     0.200
     5.526   105.417     0.200
     6.580   126.417     0.200
     6.684   128.297     0.200
     6.880   132.417     0.200
     7.533   143.587     0.200
     8.275   159.433     0.200
     2.059    38.520     0.200
     2.742    52.839     0.200
     2.789    53.001     0.200
     2.045    40.830     0.200
     2.156    42.132     0.200
     2.304    45.714     0.200
     2.692    51.581     0.200
     2.939    55.996     0.200
     2.001    38.891     0.200
     2.040    40.532     0.200
     2.069    41.201     0.200
     2.201    42.657     0.200
     2.290    45.220     0.200
     2.591    48.710     0.200
     2.591    51.405     0.200
     2.664    50.446     0.200
     2.980    58.463     0.200
     3.033    58.645     0.200
     3.065    56.869     0.200
     3.065    59.369     0.200
     3.228    62.970     0.200
     3.303    63.099     0.200
     3.380    64.200     0.200
     3.719    70.739     0.200
     3.690    71.185     0.200
     4.227    77.914     0.200
     4.227    81.812     0.200
     4.514    86.464     0.200
     4.703    90.456     0.200
     4.903    92.725     0.200
     5.134    97.723     0.200
     5.137    99.393     0.200
     5.523   106.392     0.200
     6.334   121.327     0.200
     6.627   126.299     0.200
     7.571   145.986     0.200
     7.952   151.938     0.200
     8.926   171.976     0.200
     9.743   186.247     0.200
     2.078    41.147     0.200
     2.393    46.071     0.200
     2.470    46.370     0.200
     2.470    47.971     0.200
     2.645    50.435     0.200
     2.645    50.235     0.200
     2.581    49.177     0.200
     2.581    49.677     0.200
     2.721    52.537     0.200
     3.168    61.021     0.200
     3.190    60.675     0.200
     3.190    61.272     0.200
     3.503    68.718     0.200
     3.503    67.617     0.200
     3.755    70.781     0.200
     3.755    70.179     0.200
     3.755    72.781     0.200
     3.894    76.257     0.200
     3.894    74.460     0.200
     4.185    81.561     0.200
     4.424    84.666     0.200
     4.424    84.767     0.200
     4.672    88.676     0.200
     4.672    89.676     0.200
     5.420   103.744     0.200
     5.548   110.589     0.200
     5.642   108.357     0.200
     6.847   132.794     0.200
     7.069   135.497     0.200
    10.236   197.838     0.200
     2.279    43.893     0.200
     2.409    47.478     0.200
     2.534    49.228     0.200
     2.595    50.412     0.200
     3.572    67.409     0.200
     2.187    43.658     0.200
     2.610    50.230     0.200
     2.704    52.536     0.200
     2.835    55.800     0.200
     3.100    59.910     0.200
     3.469    67.604     0.200
     3.378    65.660     0.200
     3.790    73.256     0.200
     3.879    76.212     0.200
     4.284    83.792     0.200
     4.344    83.790     0.200
     4.797    92.998     0.200
     5.320   103.203     0.200
     5.570   107.080     0.200
     5.577   110.186     0.200
     6.613   127.916     0.200
     6.741   130.013     0.200
     6.942   133.170     0.200
     7.231   140.802     0.200
     7.592   145.588     0.200
     8.335   160.416     0.200
    14.002   269.482     0.200
     2.141    40.432     0.200
     2.349    45.011     0.200
     2.488    46.689     0.200
     2.488    47.089     0.200
     2.742    52.318     0.200
     2.860    53.648     0.200
     2.952    55.664     0.200
     2.996    56.662     0.200
     3.319    63.584     0.200
     3.319    64.184     0.200
     3.289    62.437     0.200
     3.289    62.136     0.200
     3.466    65.473     0.200
     3.466    64.473     0.200
     3.628    68.675     0.200
     3.987    76.992     0.200
     4.033    76.251     0.200
     4.033    74.950     0.200
     4.345    82.914     0.200
     4.345    81.615     0.200
     4.445    85.845     0.200
     4.445    85.547     0.200
     4.950    94.251     0.200
     5.159    99.117     0.200
     5.420   102.463     0.200
     5.385   103.981     0.200
     5.702   113.179     0.200
     6.482   124.180     0.200
     6.580   126.234     0.200
     6.792   129.257     0.200
     7.430   143.908     0.200
     8.790   168.738     0.200
     9.813   189.101     0.200
     9.960   189.986     0.200
    14.167   270.915     0.200
    18.059   359.530     0.200
     2.319    44.162     0.200
     2.462    47.596     0.200
     2.574    48.693     0.200
     2.574    48.092     0.200
     2.575    49.770     0.200
     2.852    54.037     0.200
     2.852    54.138     0.200
     3.051    59.016     0.200
     3.367    64.826     0.200
     3.497    68.416     0.200
     3.497    66.216     0.200
     3.643    68.913     0.200
     3.643    68.213     0.200
     3.738    70.803     0.200
     3.738    72.803     0.200
     4.060    77.840     0.200
     4.060    76.740     0.200
     4.012    78.200     0.200
     4.012    77.400     0.200
     4.303    81.706     0.200
     4.419    85.251     0.200
     4.564    86.264     0.200
     4.564    85.465     0.200
     5.048    96.918     0.200
     5.340   102.675     0.200
     5.592   107.871     0.200
     5.839   111.179     0.200
     6.863   132.437     0.200
     7.011   134.412     0.200
     7.174   138.207     0.200
     7.858   152.823     0.200
     8.595   166.318     0.200
     8.891   171.169     0.200
    10.223   197.420     0.200
    10.378   198.717     0.200
    13.864   268.605     0.200
    17.693   346.977     0.200
     2.326    44.590     0.200
     2.467    47.145     0.200
     2.565    49.297     0.200
     2.582    49.898     0.200
     3.057    58.752     0.200
     3.358    64.140     0.200
     3.498    67.207     0.200
     3.647    68.462     0.200
     3.647    69.763     0.200
     3.647    72.462     0.200
     3.729    72.014     0.200
     4.053    76.936     0.200
     4.020    78.813     0.200
     4.310    81.634     0.200
     4.310    84.232     0.200
     4.411    85.654     0.200
     4.568    85.919     0.200
     4.568    88.716     0.200
     5.050    97.895     0.200
     5.584   107.667     0.200
     5.830   111.694     0.200
     7.003   135.103     0.200
     7.169   137.262     0.200
     7.851   150.310     0.200
     8.589   165.898     0.200
     8.892   171.958     0.200
    10.217   197.993     0.200
    10.371   198.395     0.200
     2.080    42.652     0.200
     2.269    43.546     0.200
     2.618    50.770     0.200
     2.696    51.461     0.200
     3.010    58.493     0.200
     3.116    58.762     0.200
     3.116    61.457     0.200
     2.039    40.133     0.200
     2.103    39.887     0.200
     2.260    44.151     0.200
     2.781    52.475     0.200
     2.916    55.092     0.200
     3.034    58.022     0.200
     3.270    62.259     0.200
     3.283    62.617     0.200
     3.504    66.936     0.200
     3.590    67.833     0.200
     3.948    75.348     0.200
     4.070    75.232     0.200
     4.070    78.032     0.200
     4.348    82.280     0.200
     4.484    86.600     0.200
     4.986    95.437     0.200
     5.120    98.474     0.200
     5.384   102.798     0.200
     5.417   103.710     0.200
     6.541   124.891     0.200
     6.757   128.072     0.200
     2.240    43.956     0.200
     2.248    44.059     0.200
     2.557    49.952     0.200
     2.641    51.066     0.200
     2.761    54.270     0.200
     2.895    57.608     0.200
     3.043    58.983     0.200
     3.347    64.225     0.200
     3.366    65.317     0.200
     3.729    72.676     0.200
     3.936    76.559     0.200
     4.086    79.416     0.200
     4.347    83.554     0.200
     4.345    85.086     0.200
     4.854    93.953     0.200
     5.259   100.323     0.200
     5.296   102.789     0.200
     5.513   105.864     0.200
     6.561   126.628     0.200
     6.681   129.233     0.200
     6.887   132.222     0.200
     8.275   158.422     0.200
     2.428    46.977     0.200
     2.426    47.205     0.200
     2.528    49.620     0.200
     2.644    50.266     0.200
     2.675    51.894     0.200
     3.141    59.961     0.200
     3.141    61.156     0.200
     3.189    61.903     0.200
     3.563    68.640     0.200
     3.570    69.649     0.200
     3.699    71.949     0.200
     3.935    76.198     0.200
     4.149    81.501     0.200
     4.479    86.454     0.200
     4.615    88.056     0.200
     5.052    98.856     0.200
     5.459   105.709     0.200
     5.663   108.725     0.200
     6.661   128.286     0.200
     6.889   133.328     0.200
     7.128   137.731     0.200
     7.746   149.722     0.200
     8.498   162.840     0.200
    10.286   196.774     0.200
     2.272    42.090     0.200
     2.234    42.334     0.200
     2.273    42.982     0.200
     2.609    50.853     0.200
     2.602    48.737     0.200
     2.831    52.970     0.200
     2.914    55.495     0.200
     3.265    63.105     0.200
     3.301    63.284     0.200
     3.738    72.577     0.200
     3.812    71.920     0.200
     3.883    75.089     0.200
     4.085    78.628     0.200
     4.370    85.809     0.200
     4.634    88.728     0.200
     4.962    95.097     0.200
     4.940    96.358     0.200
     5.305   102.290     0.200
     5.380   102.219     0.200
     5.901   114.143     0.200
     6.286   119.843     0.200
     6.758   130.032     0.200
     7.182   136.891     0.200
     8.427   162.255     0.200
     8.685   167.044     0.200
    10.225   196.081     0.200
     2.265    42.640     0.200
     2.202    43.683     0.200
     2.487    48.047     0.200
     2.755    52.428     0.200
     2.876    55.308     0.200
     3.131    60.437     0.200
     2.961    56.116     0.200
     2.961    55.819     0.200
     3.124    59.717     0.200
     3.363    64.032     0.200
     3.483    67.224     0.200
     3.585    68.634     0.200
     3.820    73.396     0.200
     4.123    78.755     0.200
     4.520    85.530     0.200
     5.006    97.251     0.200
     5.034    95.424     0.200
     5.226    99.782     0.200
     5.802   113.163     0.200
     5.919   116.102     0.200
     5.948   118.991     0.200
     6.438   122.647     0.200
     6.727   129.067     0.200
     7.298   139.507     0.200
     8.057   154.450     0.200
     8.167   157.062     0.200
     9.847   189.459     0.200
    13.997   267.346     0.200
    14.082   275.434     0.200
    17.918   353.616     0.200
    18.117   355.622     0.200
    18.664   366.500     0.200
    20.180   393.045     0.200
    20.917   415.523     0.200
    23.643   459.058     0.200
    24.373   476.913     0.200
     2.217    43.579     0.200
     2.251    42.782     0.200
     2.405    47.983     0.200
     2.503    47.943     0.200
     2.739    51.991     0.200
     2.892    55.904     0.200
     2.976    56.424     0.200
     3.140    60.814     0.200
     3.357    63.873     0.200
     3.467    65.488     0.200
     3.601    69.136     0.200
     3.804    73.768     0.200
     4.138    79.061     0.200
     4.523    86.267     0.200
     4.618    89.269     0.200
     4.990    93.821     0.200
     5.049    96.536     0.200
     5.210   100.249     0.200
     5.438   104.694     0.200
     6.422   123.512     0.200
     6.714   128.500     0.200
     8.041   154.406     0.200
     9.832   188.316     0.200
     2.265    42.241     0.200
     2.265    44.046     0.200
     2.481    47.824     0.200
     2.758    52.192     0.200
     2.869    54.593     0.200
     2.953    56.315     0.200
     3.134    59.698     0.200
     3.117    59.708     0.200
     3.373    64.112     0.200
     3.490    65.847     0.200
     3.577    68.227     0.200
     3.825    74.030     0.200
     4.115    79.256     0.200
     4.528    86.336     0.200
     4.596    89.448     0.200
     5.012    96.481     0.200
     5.025    95.935     0.200
     5.230    99.547     0.200
     5.415   103.779     0.200
     6.268   120.521     0.200
     6.445   123.870     0.200
     6.737   129.356     0.200
     8.065   155.157     0.200
     2.251    43.116     0.200
     2.251    43.518     0.200
     2.110    42.471     0.200
     2.234    43.624     0.200
     2.234    44.226     0.200
     2.627    50.833     0.200
     2.627    50.333     0.200
     2.746    52.848     0.200
     2.880    55.179     0.200
     3.052    58.681     0.200
     3.362    64.453     0.200
     3.351    64.489     0.200
     3.742    71.718     0.200
     3.920    74.843     0.200
     4.332    84.040     0.200
     4.332    85.138     0.200
     4.356    82.551     0.200
     4.356    82.352     0.200
     4.838    91.836     0.200
     4.838    93.336     0.200
     5.272   100.771     0.200
     5.280   100.978     0.200
     5.522   105.155     0.200
     5.622   111.766     0.200
     6.567   125.756     0.200
     6.694   128.873     0.200
     6.903   132.834     0.200
     7.545   145.440     0.200
     8.290   160.553     0.200
     8.527   164.885     0.200
     9.099   175.408     0.200
    10.075   193.616     0.200
    14.024   274.608     0.200
    14.277   277.777     0.200
    17.950   354.288     0.200
    20.479   399.222     0.200
     2.190    41.840     0.200
     2.285    45.228     0.200
     2.485    46.700     0.200
     2.677    52.653     0.200
     2.784    52.906     0.200
     2.980    57.012     0.200
     2.928    57.221     0.200
     3.356    62.728     0.200
     3.380    65.053     0.200
     3.396    65.567     0.200
     3.687    70.765     0.200
     3.687    69.665     0.200
     3.955    76.139     0.200
     4.390    85.565     0.200
     4.412    85.701     0.200
     4.871    93.554     0.200
     5.214    99.642     0.200
     5.297   101.673     0.200
     5.452   103.272     0.200
     5.587   108.198     0.200
     6.640   126.804     0.200
     6.874   131.870     0.200
     7.305   140.949     0.200
     7.545   144.949     0.200
     8.244   157.991     0.200
     9.108   176.204     0.200
     2.114    42.022     0.200
     2.267    43.727     0.200
     2.316    44.362     0.200
     2.389    46.502     0.200
     2.534    48.518     0.200
     2.642    49.957     0.200
     2.585    50.623     0.200
     2.961    56.829     0.200
     3.091    60.413     0.200
     3.748    72.950     0.200
     4.071    76.876     0.200
     4.227    82.257     0.200
     4.817    92.373     0.200
     4.934    93.607     0.200
     5.142   100.085     0.200
     5.736   111.747     0.200
     5.888   112.772     0.200
     6.003   114.237     0.200
     6.160   119.302     0.200
     6.175   120.021     0.200
     6.716   127.816     0.200
     7.432   141.550     0.200
     8.169   157.460     0.200
     2.180    41.044     0.200
     2.180    42.447     0.200
     2.221    43.767     0.200
     2.316    45.162     0.200
     2.401    45.965     0.200
     2.476    48.699     0.200
     2.595    52.406     0.200
     2.712    50.843     0.200
     2.686    52.845     0.200
     2.863    54.682     0.200
     3.158    61.435     0.200
     3.811    73.913     0.200
     4.195    79.832     0.200
     4.861    92.959     0.200
     5.799   111.320     0.200
     5.778   111.661     0.200
     5.967   113.554     0.200
     6.194   119.811     0.200
     2.217    42.373     0.200
     2.217    43.076     0.200
     2.241    43.391     0.200
     2.375    44.726     0.200
     2.375    45.226     0.200
     2.625    50.716     0.200
     2.625    50.419     0.200
     2.686    51.698     0.200
     2.686    51.394     0.200
     2.867    55.095     0.200
     2.941    56.224     0.200
     2.941    56.419     0.200
     3.323    63.265     0.200
     3.320    62.699     0.200
     3.320    62.496     0.200
     3.320    64.097     0.200
     3.617    70.139     0.200
     3.740    71.592     0.200
     3.740    72.092     0.200
     3.842    72.010     0.200
     3.842    75.409     0.200
     4.054    78.736     0.200
     4.368    85.763     0.200
     4.368    85.865     0.200
     4.659    88.468     0.200
     4.659    89.468     0.200
     4.750    90.516     0.200
     4.750    91.516     0.200
     5.132    98.449     0.200
     5.132    98.753     0.200
     5.254   102.127     0.200
     5.415   104.952     0.200
     5.727   111.610     0.200
     5.823   113.932     0.200
     6.393   123.537     0.200
     6.694   129.025     0.200
     7.184   138.215     0.200
     7.368   141.856     0.200
     8.415   162.645     0.200
     8.921   172.546     0.200
    13.802   267.738     0.200
    14.223   271.956     0.200
    18.482   361.406     0.200
    20.301   392.795     0.200
     2.194    43.310     0.200
     2.331    45.415     0.200
     2.449    48.334     0.200
     2.683    50.797     0.200
     2.914    56.602     0.200
     2.923    56.701     0.200
     3.459    67.042     0.200
     3.511    68.236     0.200
     3.615    69.322     0.200
     3.838    74.123     0.200
     3.897    76.738     0.200
     4.178    80.452     0.200
     4.368    84.837     0.200
     4.432    86.389     0.200
     4.917    95.525     0.200
     5.199   101.442     0.200
     5.707   109.209     0.200
     5.933   113.974     0.200
     6.863   133.322     0.200
     7.130   137.006     0.200
     7.306   140.855     0.200
     8.277   161.324     0.200
     8.763   168.946     0.200
     2.209    42.494     0.200
     2.263    43.666     0.200
     2.263    43.166     0.200
     2.448    46.708     0.200
     2.635    50.332     0.200
     2.635    50.528     0.200
     2.704    50.721     0.200
     2.704    50.323     0.200
     2.898    55.154     0.200
     2.898    54.654     0.200
     3.327    62.946     0.200
     3.421    65.850     0.200
     3.421    66.154     0.200
     3.712    71.257     0.200
     3.896    75.811     0.200
     3.964    76.925     0.200
     4.162    78.305     0.200
     4.162    80.204     0.200
     4.331    82.534     0.200
     4.331    82.729     0.200
     4.467    84.747     0.200
     4.735    91.724     0.200
     5.490   106.409     0.200
     5.559   111.039     0.200
     5.673   108.876     0.200
     6.719   128.968     0.200
     6.765   130.227     0.200
     7.115   136.439     0.200
     7.425   142.720     0.200
     7.988   154.853     0.200
     8.520   163.823     0.200
    10.545   202.415     0.200
     2.424    46.298     0.200
     2.575    50.638     0.200
     2.575    50.439     0.200
     2.640    50.579     0.200
     2.640    50.782     0.200
     2.817    54.507     0.200
     2.992    58.062     0.200
     2.992    58.164     0.200
     3.272    62.119     0.200
     3.375    66.001     0.200
     3.630    68.918     0.200
     3.630    70.918     0.200
     3.789    72.866     0.200
     3.797    71.775     0.200
     4.105    80.385     0.200
     4.317    84.998     0.200
     4.646    89.969     0.200
     5.096    98.620     0.200
     5.304   101.785     0.200
     5.467   104.689     0.200
     5.683   111.563     0.200
     5.777   115.192     0.200
     6.743   130.090     0.200
     7.058   135.815     0.200
     8.269   161.632     0.200
     8.426   163.658     0.200
    15.352   301.916     0.200
     2.282    44.051     0.200
     2.419    47.055     0.200
     2.537    48.970     0.200
     2.601    49.930     0.200
     2.855    55.365     0.200
     3.012    58.137     0.200
     3.385    65.367     0.200
     3.546    67.199     0.200
     3.599    68.475     0.200
     3.981    78.014     0.200
     4.092    78.022     0.200
     4.341    82.618     0.200
     4.520    87.435     0.200
     5.000    97.525     0.200
     2.576    50.161     0.200
     2.640    51.309     0.200
     2.640    51.012     0.200
     2.818    54.832     0.200
     2.990    55.821     0.200
     2.990    57.321     0.200
     3.272    62.849     0.200
     3.373    64.361     0.200
     3.633    70.718     0.200
     3.788    72.211     0.200
     3.788    72.805     0.200
     4.319    83.918     0.200
     4.319    84.114     0.200
     4.650    89.162     0.200
     4.650    90.255     0.200
     4.706    90.302     0.200
     5.095    98.664     0.200
     5.303   102.731     0.200
     5.465   104.549     0.200
     5.686   111.257     0.200
     5.780   115.915     0.200
     6.440   124.170     0.200
     6.743   129.830     0.200
     7.140   136.998     0.200
     8.268   160.834     0.200
     8.272   162.606     0.200
     8.429   163.358     0.200
    10.168   196.554     0.200
    13.776   268.347     0.200
    14.272   275.129     0.200
    18.503   362.038     0.200
    20.347   396.240     0.200
     2.018    40.649     0.200
     2.199    43.231     0.200
     2.259    43.435     0.200
     2.408    44.891     0.200
     2.582    49.563     0.200
     2.644    50.544     0.200
     2.824    54.038     0.200
     2.980    56.618     0.200
     3.278    62.148     0.200
     3.363    65.155     0.200
     3.642    71.600     0.200
     4.327    84.500     0.200
     4.663    90.479     0.200
     4.708    89.854     0.200
     5.297   102.786     0.200
     5.454   103.844     0.200
     2.020    40.164     0.200
     2.125    41.232     0.200
     2.362    44.773     0.200
     2.362    46.370     0.200
     2.465    47.266     0.200
     2.465    47.665     0.200
     2.755    54.081     0.200
     2.870    54.642     0.200
     2.870    54.541     0.200
     2.935    55.985     0.200
     3.008    57.829     0.200
     3.008    58.431     0.200
     3.292    63.519     0.200
     3.292    63.019     0.200
     3.308    64.633     0.200
     3.308    64.734     0.200
     3.478    65.343     0.200
     3.478    66.249     0.200
     3.478    67.550     0.200
     3.614    69.058     0.200
     3.614    69.257     0.200
     3.971    77.294     0.200
     4.043    77.051     0.200
     4.043    77.551     0.200
     4.357    84.987     0.200
     4.960    95.458     0.200
     5.144   100.306     0.200
     5.601   109.771     0.200
     5.720   110.860     0.200
     6.784   131.070     0.200
     7.417   144.378     0.200
     7.393   142.856     0.200
     7.638   147.396     0.200
     7.930   152.287     0.200
     8.087   156.458     0.200
     8.162   157.283     0.200
     8.606   167.299     0.200
     8.796   168.986     0.200
    14.151   271.240     0.200
    14.111   274.918     0.200
    17.752   350.800     0.200
    17.855   349.774     0.200
    18.664   366.661     0.200
    18.751   365.229     0.200
     2.039    40.813     0.200
     2.233    43.156     0.200
     2.226    43.137     0.200
     2.388    45.446     0.200
     2.609    49.967     0.200
     2.670    50.846     0.200
     2.956    56.514     0.200
     2.851    54.742     0.200
     3.338    63.756     0.200
     3.304    61.737     0.200
     3.626    70.191     0.200
     3.626    70.992     0.200
     3.756    71.472     0.200
     4.353    84.710     0.200
     4.661    89.914     0.200
     4.661    89.016     0.200
     4.734    90.466     0.200
     5.118    98.387     0.200
     5.270   101.707     0.200
     5.430   103.140     0.200
     5.812   111.511     0.200
     8.266   160.614     0.200
    13.790   264.065     0.200
     2.019    39.542     0.200
     2.455    47.848     0.200
     2.528    48.993     0.200
     2.664    50.414     0.200
     2.701    51.974     0.200
     3.133    59.729     0.200
     3.232    61.987     0.200
     3.521    68.207     0.200
     3.610    68.974     0.200
     3.954    76.560     0.200
     4.123    80.382     0.200
     4.406    84.881     0.200
     4.622    87.857     0.200
     5.075    97.275     0.200
     2.071    40.108     0.200
     2.179    42.545     0.200
     2.320    44.994     0.200
     2.779    53.446     0.200
     2.787    52.996     0.200
     2.929    55.791     0.200
     3.354    63.628     0.200
     3.517    67.329     0.200
     3.803    75.084     0.200
     3.799    74.739     0.200
     3.899    74.962     0.200
     4.289    83.817     0.200
     4.273    81.603     0.200
     4.530    87.209     0.200
     4.621    89.540     0.200
     4.740    91.257     0.200
     5.309   104.035     0.200
     8.407   163.441     0.200
    13.556   263.528     0.200
     2.211    43.476     0.200
     2.321    45.286     0.200
     2.461    48.256     0.200
     2.644    51.121     0.200
     2.829    54.260     0.200
     2.929    56.245     0.200
     2.929    56.596     0.200
     3.396    66.139     0.200
     3.497    68.069     0.200
     3.690    71.311     0.200
     3.777    72.897     0.200
     3.933    76.685     0.200
     4.151    80.637     0.200
     4.415    85.752     0.200
     4.488    87.206     0.200
     4.875    94.489     0.200
     5.385   105.710     0.200
     8.303   162.357     0.200
    15.500   300.979     0.200
     2.070    39.201     0.200
     2.118    41.539     0.200
     2.334    44.328     0.200
     2.391    46.362     0.200
     2.779    53.427     0.200
     2.841    54.004     0.200
     2.864    54.935     0.200
     3.027    57.939     0.200
     3.219    60.900     0.200
     3.417    65.385     0.200
     3.488    67.954     0.200
     3.580    67.782     0.200
     3.915    75.880     0.200
     4.028    77.958     0.200
     4.523    86.676     0.200
     4.506    87.175     0.200
     4.939    94.521     0.200
     5.314   101.247     0.200
     5.336   102.786     0.200
     2.093    42.255     0.200
     2.237    44.075     0.200
     2.275    43.728     0.200
     2.631    50.383     0.200
     2.632    50.561     0.200
     2.769    53.962     0.200
     2.889    56.672     0.200
     3.097    59.439     0.200
     3.281    62.693     0.200
     3.364    62.619     0.200
     3.364    65.526     0.200
     3.469    67.196     0.200
     4.120    80.802     0.200
     4.255    81.928     0.200
     4.321    84.059     0.200
     4.868    92.973     0.200
     5.285   102.505     0.200
     5.329   103.294     0.200
     5.436   105.649     0.200
     7.912   150.500     0.200
     2.054    39.218     0.200
     2.054    41.619     0.200
     2.209    44.307     0.200
     2.359    45.760     0.200
     2.604    51.200     0.200
     2.762    53.458     0.200
     2.999    58.392     0.200
     3.095    58.965     0.200
     3.128    60.989     0.200
     3.121    61.660     0.200
     3.253    63.022     0.200
     3.382    64.517     0.200
     3.756    71.459     0.200
     3.726    72.310     0.200
     4.283    81.808     0.200
     4.295    83.460     0.200
     4.691    91.349     0.200
     4.916    94.417     0.200
     5.219    99.278     0.200
     5.212   100.263     0.200
     2.027    39.815     0.200
     2.063    39.295     0.200
     2.297    43.766     0.200
     2.301    45.108     0.200
     2.341    45.444     0.200
     2.534    49.191     0.200
     2.759    54.171     0.200
     2.794    53.458     0.200
     3.197    61.957     0.200
     3.847    73.767     0.200
     4.310    82.770     0.200
     4.337    82.555     0.200
     4.715    89.445     0.200
     4.879    92.322     0.200
     2.255    43.923     0.200
     2.400    46.537     0.200
     2.512    48.530     0.200
     2.635    50.189     0.200
     2.897    55.837     0.200
     2.988    57.675     0.200
     3.425    65.379     0.200
     3.541    68.324     0.200
     3.582    68.346     0.200
     3.582    69.645     0.200
     3.949    77.955     0.200
     4.313    80.810     0.200
     4.313    82.410     0.200
     4.481    86.549     0.200
     4.503    85.495     0.200
     4.503    86.793     0.200
     4.992    97.385     0.200
     5.201   101.851     0.200
     2.218    42.771     0.200
     2.329    45.384     0.200
     2.469    47.551     0.200
     2.636    50.798     0.200
     2.823    53.721     0.200
     2.937    56.192     0.200
     3.389    65.314     0.200
     3.504    67.066     0.200
     3.685    71.361     0.200
     3.940    77.379     0.200
     4.038    77.640     0.200
     4.143    79.612     0.200
     4.422    84.753     0.200
     4.480    86.980     0.200
     4.480    86.578     0.200
     4.881    93.896     0.200
     5.307   103.033     0.200
     2.227    42.867     0.200
     2.227    42.668     0.200
     2.137    41.720     0.200
     2.272    44.048     0.200
     2.570    48.964     0.200
     2.666    51.742     0.200
     2.794    52.658     0.200
     2.794    53.559     0.200
     2.921    55.570     0.200
     2.921    57.070     0.200
     3.042    57.760     0.200
     3.298    62.172     0.200
     3.415    64.112     0.200
     3.394    64.644     0.200
     3.394    66.351     0.200
     3.710    71.164     0.200
     4.073    78.632     0.200
     3.970    77.127     0.200
     4.302    82.749     0.200
     4.363    84.446     0.200
     5.242   100.590     0.200
     5.497   107.211     0.200
     5.510   105.263     0.200
     6.660   126.837     0.200
     6.851   130.614     0.200
     7.932   151.844     0.200
    14.087   275.686     0.200
    15.061   290.666     0.200
    18.823   366.766     0.200
    20.482   397.148     0.200
     2.122    40.373     0.200
     2.150    40.848     0.200
     2.150    41.051     0.200
     2.354    44.668     0.200
     2.354    44.770     0.200
     2.740    52.170     0.200
     2.735    51.327     0.200
     2.795    52.216     0.200
     3.298    63.652     0.200
     3.396    64.710     0.200
     3.782    72.901     0.200
     3.836    73.064     0.200
     3.889    74.559     0.200
     3.889    74.363     0.200
     4.047    78.805     0.200
     4.047    78.703     0.200
     4.268    81.526     0.200
     4.204    79.678     0.200
     4.558    86.944     0.200
     4.595    88.812     0.200
     4.859    93.729     0.200
     5.517   108.154     0.200
     2.191    42.034     0.200
     2.303    45.721     0.200
     2.532    48.451     0.200
     2.698    52.621     0.200
     2.820    54.591     0.200
     2.952    56.657     0.200
     3.003    57.450     0.200
     3.297    63.526     0.200
     3.423    66.153     0.200
     3.676    70.398     0.200
     3.995    77.773     0.200
     4.036    78.691     0.200
     4.323    82.650     0.200
     4.397    85.389     0.200
     4.913    95.166     0.200
     5.207    99.438     0.200
     5.355   104.003     0.200
     2.280    43.716     0.200
     2.423    47.049     0.200
     2.536    48.725     0.200
     2.610    49.959     0.200
     2.875    55.369     0.200
     3.012    58.473     0.200
     3.400    65.536     0.200
     3.974    77.838     0.200
     4.134    79.874     0.200
     4.314    82.873     0.200
     4.525    85.115     0.200
     4.525    86.912     0.200
     5.011    97.039     0.200
     5.220   101.004     0.200
     2.171    42.369     0.200
     2.307    43.575     0.200
     2.589    48.788     0.200
     2.563    49.985     0.200
     2.678    51.551     0.200
     2.816    54.142     0.200
     3.096    58.870     0.200
     3.285    63.864     0.200
     3.423    65.247     0.200
     3.852    74.151     0.200
     4.273    82.334     0.200
     4.386    85.214     0.200
     4.769    91.448     0.200
     5.210   100.296     0.200
     5.331   102.485     0.200
     5.488   106.456     0.200
     2.142    42.288     0.200
     2.261    43.998     0.200
     2.266    44.442     0.200
     2.488    47.547     0.200
     2.609    50.233     0.200
     2.686    50.340     0.200
     3.356    64.620     0.200
     3.495    67.797     0.200
     3.753    72.282     0.200
     4.127    79.218     0.200
     4.231    81.209     0.200
     4.477    86.339     0.200
     4.814    92.904     0.200
     5.732   110.591     0.200
     2.196    42.077     0.200
     2.334    44.956     0.200
     2.451    46.898     0.200
     2.684    52.276     0.200
     2.920    56.028     0.200
     2.926    55.858     0.200
     3.462    66.293     0.200
     3.516    67.876     0.200
     3.516    69.575     0.200
     3.607    70.410     0.200
     3.896    75.528     0.200
     4.046    77.981     0.200
     4.178    80.443     0.200
     4.358    83.949     0.200
     4.437    85.526     0.200
     4.924    95.737     0.200
     5.191   100.318     0.200
     2.092    39.693     0.200
     2.092    39.998     0.200
     2.333    43.777     0.200
     2.333    43.582     0.200
     2.309    44.765     0.200
     2.497    48.965     0.200
     2.608    51.981     0.200
     2.680    50.439     0.200
     2.721    53.958     0.200
     2.793    53.113     0.200
     2.793    51.613     0.200
     2.836    53.110     0.200
     3.010    59.481     0.200
     3.163    61.796     0.200
     3.163    61.500     0.200
     3.235    62.254     0.200
     3.558    68.584     0.200
     3.678    71.286     0.200
     3.813    73.310     0.200
     4.289    80.864     0.200
     4.289    81.059     0.200
     4.286    82.394     0.200
     4.374    83.167     0.200
     4.753    89.849     0.200
     4.849    92.226     0.200
     6.146   119.384     0.200
     6.262   122.480     0.200
     7.416   144.516     0.200
    14.774   289.974     0.200
     2.190    42.115     0.200
     2.276    43.505     0.200
     2.276    44.704     0.200
     2.456    47.314     0.200
     2.667    52.349     0.200
     2.764    54.517     0.200
     2.916    54.939     0.200
     2.916    56.238     0.200
     2.967    56.350     0.200
     3.381    63.915     0.200
     3.381    65.415     0.200
     3.431    65.735     0.200
     3.694    70.861     0.200
     3.932    73.184     0.200
     3.932    75.585     0.200
     4.387    84.170     0.200
     4.468    84.933     0.200
     4.468    86.630     0.200
     4.846    92.918     0.200
     5.219    99.266     0.200
     5.263   102.551     0.200
     2.269    43.963     0.200
     2.361    46.596     0.200
     2.516    48.182     0.200
     2.576    49.381     0.200
     2.734    51.837     0.200
     2.979    57.686     0.200
     3.313    62.982     0.200
     3.530    67.745     0.200
     3.717    72.365     0.200
     4.002    78.236     0.200
     4.090    78.910     0.200
     4.418    84.290     0.200
     4.446    85.761     0.200
     4.557    88.466     0.200
     4.883    93.558     0.200
     2.193    41.996     0.200
     2.193    42.496     0.200
     2.299    44.268     0.200
     2.299    44.569     0.200
     2.443    47.085     0.200
     2.443    47.687     0.200
     2.657    50.884     0.200
     2.657    50.684     0.200
     2.828    53.496     0.200
     2.909    55.939     0.200
     3.403    65.786     0.200
     3.403    64.985     0.200
     3.721    73.364     0.200
     3.721    70.567     0.200
     3.784    73.232     0.200
     3.920    76.753     0.200
     4.007    78.134     0.200
     4.167    79.966     0.200
     4.391    84.355     0.200
     4.500    86.876     0.200
     4.510    85.762     0.200
     4.846    93.138     0.200
     5.311   103.013     0.200
     5.392   106.552     0.200
     7.020   135.290     0.200
     8.334   161.610     0.200
     2.217    41.782     0.200
     2.217    42.583     0.200
     2.261    42.262     0.200
     2.173    43.290     0.200
     2.270    44.158     0.200
     2.270    43.559     0.200
     2.643    50.509     0.200
     2.643    50.910     0.200
     2.665    50.458     0.200
     2.665    52.258     0.200
     2.881    55.134     0.200
     2.881    55.333     0.200
     2.876    54.296     0.200
     3.267    62.732     0.200
     3.315    63.768     0.200
     3.753    71.050     0.200
     3.753    71.650     0.200
     3.797    73.446     0.200
     3.797    73.646     0.200
     3.801    72.800     0.200
     3.801    70.502     0.200
     3.801    73.601     0.200
     4.037    78.340     0.200
     4.340    83.210     0.200
     4.406    85.840     0.200
     4.699    90.313     0.200
     4.869    95.229     0.200
     4.869    93.229     0.200
     5.253   100.855     0.200
     5.350   102.414     0.200
     5.882   114.308     0.200
     5.967   114.926     0.200
     6.451   123.895     0.200
     7.105   137.732     0.200
     8.439   163.922     0.200
    13.650   263.534     0.200
    18.244   355.978     0.200
     2.186    41.940     0.200
     2.284    43.594     0.200
     2.434    46.945     0.200
     2.661    50.801     0.200
     2.816    53.093     0.200
     2.898    56.497     0.200
     2.898    55.729     0.200
     3.399    64.692     0.200
     3.457    67.711     0.200
     3.751    72.275     0.200
     3.781    72.032     0.200
     3.917    76.138     0.200
     3.991    76.873     0.200
     4.173    79.749     0.200
     4.374    83.812     0.200
     4.543    87.731     0.200
     4.503    86.506     0.200
     4.823    92.664     0.200
     5.332   103.232     0.200
     5.411   105.312     0.200
     7.008   135.748     0.200
     8.365   161.226     0.200
    13.612   264.402     0.200
     2.079    39.617     0.200
     2.106    41.408     0.200
     2.348    44.681     0.200
     2.383    47.372     0.200
     2.772    54.930     0.200
     2.853    54.787     0.200
     2.860    56.209     0.200
     3.020    58.539     0.200
     3.409    64.596     0.200
     3.482    67.748     0.200
     3.588    68.715     0.200
     4.024    77.823     0.200
     4.497    87.299     0.200
     4.510    87.654     0.200
     4.561    87.559     0.200
     4.936    94.982     0.200
     5.110    97.843     0.200
     5.326   101.931     0.200
     5.336   102.608     0.200
     2.065    39.791     0.200
     2.120    42.455     0.200
     2.335    44.449     0.200
     2.300    46.443     0.200
     2.397    46.519     0.200
     2.839    55.162     0.200
     2.839    54.966     0.200
     2.786    54.378     0.200
     2.873    54.867     0.200
     3.034    58.386     0.200
     3.216    61.362     0.200
     3.406    64.748     0.200
     3.406    64.451     0.200
     3.574    68.490     0.200
     3.495    65.669     0.200
     3.495    66.700     0.200
     3.909    75.869     0.200
     4.036    77.591     0.200
     4.514    86.415     0.200
     4.514    85.415     0.200
     4.512    89.046     0.200
     4.573    86.920     0.200
     4.948    94.250     0.200
     5.096    96.221     0.200
     5.311   101.806     0.200
     5.736   111.754     0.200
     5.848   114.486     0.200
     6.809   131.229     0.200
     2.401    46.140     0.200
     2.451    47.459     0.200
     2.550    49.909     0.200
     2.700    52.654     0.200
     3.161    60.777     0.200
     3.165    60.828     0.200
     3.565    68.757     0.200
     3.720    69.548     0.200
     3.720    73.251     0.200
     3.909    76.140     0.200
     4.175    81.838     0.200
     4.245    82.219     0.200
     2.006    39.394     0.200
     2.110    41.277     0.200
     2.602    49.236     0.200
     2.502    48.406     0.200
     2.608    50.271     0.200
     2.752    53.583     0.200
     3.130    60.478     0.200
     3.219    60.908     0.200
     3.219    62.236     0.200
     3.501    67.648     0.200
     3.860    74.753     0.200
     3.780    73.296     0.200
     5.586   108.394     0.200
     6.794   131.639     0.200
     8.132   156.632     0.200
    13.879   268.059     0.200
    18.416   365.089     0.200
    18.721   365.201     0.200
    20.527   399.770     0.200
     2.502    48.293     0.200
     2.534    48.821     0.200
     2.649    51.471     0.200
     2.793    53.593     0.200
     3.125    58.916     0.200
     3.125    60.123     0.200
     3.301    63.363     0.200
     3.447    66.861     0.200
     3.677    70.882     0.200
     3.987    76.663     0.200
     5.392   104.863     0.200
     6.984   135.819     0.200
     8.063   158.467     0.200
    13.916   269.127     0.200
     2.211    41.994     0.200
     2.211    42.396     0.200
     2.323    43.281     0.200
     2.323    44.179     0.200
     2.462    47.066     0.200
     2.645    50.924     0.200
     2.834    54.322     0.200
     2.930    55.248     0.200
     2.930    56.205     0.200
     3.399    65.423     0.200
     3.499    66.359     0.200
     3.499    68.257     0.200
     3.683    69.111     0.200
     4.151    80.150     0.200
     4.473    86.399     0.200
     5.379   105.322     0.200
     7.027   136.233     0.200
     8.295   163.038     0.200
    13.679   264.064     0.200
     2.037    40.522     0.200
     2.218    43.603     0.200
     2.375    47.178     0.200
     2.391    45.887     0.200
     2.510    50.097     0.200
     2.626    49.344     0.200
     2.626    50.543     0.200
     2.616    49.255     0.200
     3.036    57.256     0.200
     3.036    57.756     0.200
     3.588    69.017     0.200
     2.045    40.141     0.200
     2.200    43.035     0.200
     2.382    44.718     0.200
     2.580    49.297     0.200
     2.631    50.106     0.200
     2.820    53.504     0.200
     2.968    55.772     0.200
     3.692    70.924     0.200
     3.791    71.775     0.200
     5.828   111.475     0.200
     6.575   126.286     0.200
     8.332   160.526     0.200
    13.726   266.105     0.200
     2.205    43.222     0.200
     2.322    44.954     0.200
     2.457    47.785     0.200
     2.654    51.273     0.200
     2.851    54.682     0.200
     2.926    56.104     0.200
     3.413    65.423     0.200
     3.499    65.219     0.200
     3.499    68.516     0.200
     3.499    70.117     0.200
     3.922    77.078     0.200
     5.360   104.561     0.200
     8.282   160.429     0.200
    13.690   267.046     0.200
     2.247    42.584     0.200
     2.227    43.218     0.200
     2.620    48.938     0.200
     2.620    50.743     0.200
     2.871    55.206     0.200
     2.199    43.610     0.200
     2.320    45.607     0.200
     2.452    47.765     0.200
     2.662    51.514     0.200
     2.863    54.671     0.200
     2.922    56.881     0.200
     3.422    66.138     0.200
     3.497    67.966     0.200
     3.666    69.892     0.200
     3.915    77.089     0.200
     4.165    80.676     0.200
     4.442    85.841     0.200
     5.347   103.235     0.200
     7.056   137.471     0.200
     8.275   162.505     0.200
    13.695   268.212     0.200
     2.258    42.535     0.200
     2.520    47.675     0.200
     2.602    50.621     0.200
     2.852    54.802     0.200
     3.036    58.059     0.200
     3.760    72.303     0.200
     2.289    44.146     0.200
     2.432    47.274     0.200
     2.545    49.053     0.200
     2.602    50.087     0.200
     2.871    54.955     0.200
     3.021    57.397     0.200
     3.021    59.100     0.200
     3.394    65.349     0.200
     3.518    68.001     0.200
     3.614    67.284     0.200
     3.614    70.886     0.200
     4.309    82.877     0.200
     5.320   105.226     0.200
     7.063   137.164     0.200
    15.340   299.274     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.216     4.900     0.200
     0.984    20.137     0.200
     1.823    33.254     0.200
     1.985    37.458     0.200
     1.902    35.924     0.200
     3.245    57.847     0.200
     0.358     8.792     0.200
     0.826    16.019     0.200
     1.750    31.244     0.200
     0.240     7.485     0.200
     1.163    22.712     0.200
     1.281    24.632     0.200
     0.258     8.062     0.200
     2.368    42.041     0.200
     0.264     7.546     0.200
     0.997    19.583     0.200
     1.436    26.262     0.200
     2.976    53.890     0.200
     0.327     7.833     0.200
     0.914    18.485     0.200
     1.506    27.579     0.200
     0.282     7.467     0.200
     0.314     7.826     0.200
     0.916    18.801     0.200
     1.391    28.156     0.200
     1.510    28.964     0.200
     2.713    48.124     0.200
     1.530    29.522     0.200
     5.841   102.816     0.200
     0.355     8.223     0.200
     0.995    19.949     0.200
     1.401    28.109     0.200
     1.413    28.975     0.200
     0.236     6.163     0.200
     0.569    11.571     0.200
     1.043    21.247     0.200
     1.331    27.181     0.200
     1.331    27.981     0.200
     1.501    29.399     0.200
     1.501    30.699     0.200
     1.630    31.496     0.200
     0.146     4.797     0.200
     0.649    14.428     0.200
     0.966    19.134     0.200
     1.407    28.784     0.200
     0.331     7.461     0.200
     1.021    20.409     0.200
     1.383    28.186     0.200
     1.464    29.147     0.200
     2.304    42.136     0.200
     0.260     4.939     0.200
     0.260     6.040     0.200
     0.589    12.704     0.200
     1.282    26.609     0.200
     1.282    27.507     0.200
     1.434    29.244     0.200
     0.224     6.660     0.200
     0.934    17.577     0.200
     0.951    19.480     0.200
     1.528    29.254     0.200
     0.206     4.998     0.200
     0.767    16.552     0.200
     0.997    20.871     0.200
     0.999    20.854     0.200
     1.045    21.215     0.200
     1.033    21.345     0.200
     1.034    21.345     0.200
     1.358    28.562     0.200
     1.509    31.003     0.200
     2.167    43.819     0.200
     2.360    46.461     0.200
     0.352     7.711     0.200
     0.471    10.216     0.200
     0.984    19.631     0.200
     1.437    28.545     0.200
     1.437    28.745     0.200
     0.296     5.907     0.200
     0.560    12.119     0.200
     1.123    22.553     0.200
     1.250    25.878     0.200
     1.250    25.280     0.200
     1.575    31.984     0.200
     2.644    48.103     0.200
     0.118     4.382     0.200
     0.669    14.451     0.200
     0.906    17.587     0.200
     1.166    24.655     0.200
     1.247    25.010     0.200
     1.976    39.196     0.200
     0.258     5.343     0.200
     0.548    12.054     0.200
     0.548    12.155     0.200
     1.060    22.178     0.200
     1.038    22.336     0.200
     1.162    23.794     0.200
     1.314    26.312     0.200
     0.215     5.410     0.200
     0.982    19.557     0.200
     1.121    24.033     0.200
     1.236    25.491     0.200
     1.960    38.751     0.200
     0.235     7.186     0.200
     0.630    12.775     0.200
     0.872    18.251     0.200
     1.743    31.383     0.200
     1.743    33.484     0.200
     1.920    37.120     0.200
     1.949    37.577     0.200
     0.247     6.738     0.200
     0.920    18.174     0.200
     0.985    20.523     0.200
     1.105    22.816     0.200
     0.094     6.565     0.200
     0.698    15.222     0.200
     0.698    14.822     0.200
     0.923    18.192     0.200
     1.934    38.494     0.200
     0.212     6.744     0.200
     0.918    16.708     0.200
     0.949    19.250     0.200
     1.110    21.863     0.200
     1.143    23.085     0.200
     0.328     7.527     0.200
     1.182    23.761     0.200
     0.206     4.658     0.200
     0.598    12.893     0.200
     0.598    13.193     0.200
     1.020    19.662     0.200
     1.353    27.280     0.200
     1.353    27.381     0.200
     0.259     7.118     0.200
     0.259     7.618     0.200
     0.648    13.883     0.200
     1.025    20.181     0.200
     1.163    22.171     0.200
     1.407    26.028     0.200
     1.407    26.528     0.200
     1.482    28.445     0.200
     2.313    40.248     0.200
     0.302     7.306     0.200
     0.533    11.814     0.200
     0.929    17.888     0.200
     1.379    28.036     0.200
     1.479    30.074     0.200
     0.245     5.475     0.200
     0.245     6.077     0.200
     0.641    14.751     0.200
     1.308    26.072     0.200
     0.347     6.761     0.200
     0.347     7.863     0.200
     0.503    12.237     0.200
     2.308    40.875     0.200
     0.108     5.958     0.200
     0.108     5.556     0.200
     0.807    17.198     0.200
     1.440    27.321     0.200
     1.954    36.115     0.200
     1.954    38.115     0.200
     0.328     7.274     0.200
     0.456     9.980     0.200
     0.761    16.820     0.200
     0.895    18.158     0.200
     1.079    23.213     0.200
     1.079    22.612     0.200
     1.303    26.104     0.200
     1.303    26.498     0.200
     1.342    27.343     0.200
     0.226     7.427     0.200
     0.643    11.861     0.200
     0.938    20.316     0.200
     1.059    21.112     0.200
     1.201    23.644     0.200
     1.386    25.690     0.200
     0.311     7.785     0.200
     0.540    11.710     0.200
     0.540    11.905     0.200
     0.914    18.252     0.200
     0.914    18.353     0.200
     1.265    27.250     0.200
     0.751    14.840     0.200
     0.751    15.140     0.200
     0.752    16.019     0.200
     0.752    16.119     0.200
     0.798    16.685     0.200
     1.624    32.246     0.200
     0.171     4.678     0.200
     0.739    15.655     0.200
     0.739    15.956     0.200
     0.761    14.697     0.200
     0.761    15.095     0.200
     0.795    16.295     0.200
     1.392    27.426     0.200
     1.392    29.828     0.200
     1.614    32.136     0.200
     0.072     5.665     0.200
     0.814    18.000     0.200
     2.009    35.851     0.200
     0.338     7.633     0.200
     0.824    17.563     0.200
     0.928    17.953     0.200
     1.414    28.876     0.200
     1.414    29.774     0.200
     1.495    29.736     0.200
     1.495    30.838     0.200
     0.208     5.759     0.200
     0.581    13.107     0.200
     0.581    13.306     0.200
     0.669    14.471     0.200
     0.955    19.139     0.200
     0.955    18.440     0.200
     1.265    25.523     0.200
     1.989    39.675     0.200
     0.151     3.763     0.200
     0.648    14.066     0.200
     0.974    19.065     0.200
     1.179    24.266     0.200
     1.399    28.299     0.200
     0.130     4.594     0.200
     0.656    14.249     0.200
     0.656    14.050     0.200
     0.925    17.812     0.200
     0.925    17.914     0.200
     1.148    23.619     0.200
     1.232    25.030     0.200
     0.289     7.055     0.200
     0.467     9.683     0.200
     0.657    14.359     0.200
     0.657    13.757     0.200
     0.740    15.995     0.200
     1.075    22.784     0.200
     1.314    25.790     0.200
     0.153     3.889     0.200
     0.586    12.845     0.200
     0.644    14.065     0.200
     0.644    14.264     0.200
     0.973    19.124     0.200
     0.973    18.823     0.200
     1.096    23.787     0.200
     1.400    27.941     0.200
     0.176     5.055     0.200
     0.889    18.438     0.200
     1.097    22.305     0.200
     1.108    24.588     0.200
     1.392    28.172     0.200
     1.491    30.010     0.200
     0.294     6.744     0.200
     0.468     9.310     0.200
     0.652    14.464     0.200
     0.652    13.870     0.200
     0.652    14.565     0.200
     0.740    16.843     0.200
     0.863    17.303     0.200
     1.072    22.464     0.200
     1.211    24.038     0.200
     1.278    25.466     0.200
     1.316    25.917     0.200
     0.320     7.865     0.200
     0.466     9.662     0.200
     1.172    22.722     0.200
     1.172    23.021     0.200
     1.257    25.036     0.200
     1.257    25.136     0.200
     0.161     4.605     0.200
     0.636    14.360     0.200
     0.636    14.164     0.200
     0.586    12.843     0.200
     0.978    19.465     0.200
     0.978    19.567     0.200
     1.093    23.126     0.200
     1.394    27.906     0.200
     1.394    28.711     0.200
     0.157     4.291     0.200
     0.575    12.609     0.200
     0.645    14.295     0.200
     0.645    14.099     0.200
     0.981    19.273     0.200
     1.086    23.645     0.200
     1.392    28.578     0.200
     1.501    30.402     0.200
     2.763    49.181     0.200
     3.054    56.092     0.200
     0.168     3.820     0.200
     0.631    13.922     0.200
     0.631    13.719     0.200
     0.986    19.279     0.200
     0.986    19.381     0.200
     1.087    23.200     0.200
     1.387    28.194     0.200
     1.509    29.867     0.200
     2.566    45.932     0.200
     0.164     4.254     0.200
     0.577    12.735     0.200
     0.637    14.032     0.200
     0.637    13.931     0.200
     0.985    19.373     0.200
     0.985    19.669     0.200
     1.085    23.308     0.200
     1.504    30.317     0.200
     2.572    46.452     0.200
     0.148     3.489     0.200
     0.588    12.851     0.200
     0.648    14.457     0.200
     1.100    23.580     0.200
     1.186    24.375     0.200
     1.405    28.724     0.200
     2.776    49.925     0.200
     0.143     3.613     0.200
     0.593    13.059     0.200
     0.652    14.478     0.200
     0.962    18.759     0.200
     1.106    22.769     0.200
     1.191    23.882     0.200
     1.411    28.311     0.200
     1.518    30.862     0.200
     3.958    73.195     0.200
     0.164     3.349     0.200
     0.573    12.584     0.200
     0.638    13.918     0.200
     0.638    13.817     0.200
     1.081    23.150     0.200
     1.170    24.111     0.200
     1.385    28.502     0.200
     1.500    30.369     0.200
     0.155     3.405     0.200
     0.578    12.680     0.200
     0.645    14.089     0.200
     0.645    13.889     0.200
     1.394    27.849     0.200
     1.394    29.048     0.200
     1.504    30.470     0.200
     5.305    96.013     0.200
     0.170     3.108     0.200
     0.564    11.912     0.200
     0.637    13.655     0.200
     1.377    28.623     0.200
     1.491    30.695     0.200
     0.163     4.011     0.200
     0.637    13.876     0.200
     0.984    19.035     0.200
     1.389    27.800     0.200
     0.152     3.420     0.200
     0.613    13.040     0.200
     0.637    13.364     0.200
     0.955    18.847     0.200
     1.120    24.426     0.200
     1.417    28.654     0.200
     0.156     3.867     0.200
     0.595    12.536     0.200
     0.638    13.841     0.200
     0.969    18.975     0.200
     1.103    22.910     0.200
     1.404    28.203     0.200
     1.522    30.124     0.200
     2.555    45.570     0.200
     6.874   116.769     0.200
     0.241     5.417     0.200
     0.241     6.011     0.200
     0.630    14.977     0.200
     0.124     6.181     0.200
     0.801    15.872     0.200
     0.801    16.075     0.200
     0.909    18.813     0.200
     0.909    18.711     0.200
     1.740    34.216     0.200
     1.972    38.712     0.200
     0.167     3.257     0.200
     0.167     4.054     0.200
     0.633    13.415     0.200
     0.633    13.716     0.200
     0.986    19.496     0.200
     1.086    22.932     0.200
     1.387    28.415     0.200
     1.507    30.018     0.200
     0.334     7.496     0.200
     0.482    10.673     0.200
     0.982    19.138     0.200
     1.208    26.093     0.200
     2.369    43.645     0.200
     2.790    51.434     0.200
     0.344     8.102     0.200
     0.858    16.999     0.200
     0.827    17.465     0.200
     0.827    17.262     0.200
     1.340    26.274     0.200
     1.356    26.494     0.200
     2.734    49.304     0.200
     0.332     7.596     0.200
     0.641    13.183     0.200
     0.978    19.551     0.200
     1.388    28.068     0.200
     1.427    28.012     0.200
     1.452    28.929     0.200
     0.151     3.295     0.200
     0.646    13.816     0.200
     0.646    13.917     0.200
     0.971    19.330     0.200
     1.402    27.790     0.200
     1.402    27.989     0.200
     1.513    30.202     0.200
     0.150     3.639     0.200
     0.650    13.800     0.200
     0.974    19.018     0.200
     1.092    23.342     0.200
     1.399    27.364     0.200
     1.399    28.965     0.200
     0.157     5.056     0.200
     0.645    14.255     0.200
     0.982    19.032     0.200
     0.308     7.826     0.200
     0.609    13.011     0.200
     0.835    16.582     0.200
     1.337    27.523     0.200
     1.884    34.239     0.200
     1.997    38.115     0.200
     1.997    38.414     0.200
     0.164     3.675     0.200
     0.634    13.683     0.200
     0.634    13.879     0.200
     0.982    18.926     0.200
     0.982    19.426     0.200
     1.090    23.267     0.200
     1.391    28.446     0.200
     1.510    30.362     0.200
     0.163     4.075     0.200
     0.637    13.836     0.200
     0.984    19.191     0.200
     0.984    19.996     0.200
     1.086    22.698     0.200
     1.389    28.663     0.200
     2.571    46.872     0.200
     0.137     5.442     0.200
     0.782    17.618     0.200
     1.313    26.116     0.200
     1.402    26.875     0.200
     2.313    42.251     0.200
     2.313    40.251     0.200
     0.168     3.963     0.200
     0.633    13.937     0.200
     0.633    13.641     0.200
     0.988    19.396     0.200
     1.084    23.479     0.200
     1.385    27.857     0.200
     1.505    30.259     0.200
     3.052    56.303     0.200
     5.294    95.849     0.200
     0.166     3.520     0.200
     0.631    13.994     0.200
     0.983    19.289     0.200
     0.983    19.590     0.200
     1.090    23.140     0.200
     1.390    28.836     0.200
     3.936    72.826     0.200
     0.200     4.742     0.200
     0.586    12.828     0.200
     0.586    12.929     0.200
     0.966    18.699     0.200
     1.133    24.153     0.200
     1.410    28.618     0.200
     2.497    44.739     0.200
     0.187     4.591     0.200
     0.600    12.975     0.200
     0.950    18.186     0.200
     1.146    23.801     0.200
     1.426    28.238     0.200
     1.977    39.207     0.200
     0.211     4.381     0.200
     0.576    12.919     0.200
     0.576    12.019     0.200
     1.127    23.984     0.200
     1.401    27.984     0.200
     2.992    55.223     0.200
     0.191     5.090     0.200
     0.595    13.068     0.200
     0.595    13.168     0.200
     0.965    18.952     0.200
     1.129    23.947     0.200
     2.201    42.129     0.200
     2.201    42.729     0.200
     0.199     4.970     0.200
     0.588    12.927     0.200
     0.588    13.029     0.200
     0.960    18.490     0.200
     0.960    18.990     0.200
     1.974    39.952     0.200
     0.195     4.843     0.200
     0.591    12.823     0.200
     0.591    13.023     0.200
     0.964    18.969     0.200
     1.133    23.504     0.200
     1.411    28.250     0.200
     2.500    45.651     0.200
     0.193     4.631     0.200
     0.594    12.649     0.200
     0.960    18.570     0.200
     1.136    23.224     0.200
     1.415    28.464     0.200
     2.498    45.930     0.200
     5.301    95.318     0.200
     0.146     4.347     0.200
     0.651    13.956     0.200
     0.968    18.854     0.200
     0.968    19.057     0.200
     0.968    20.257     0.200
     1.099    21.928     0.200
     1.405    28.057     0.200
     1.912    38.338     0.200
     0.277     6.151     0.200
     0.532    11.775     0.200
     0.532    11.576     0.200
     1.026    22.305     0.200
     1.078    20.709     0.200
     1.078    20.607     0.200
     1.298    26.141     0.200
     1.298    26.039     0.200
     0.632    14.058     0.200
     0.632    14.159     0.200
     0.972    19.388     0.200
     0.972    19.193     0.200
     1.103    23.756     0.200
     1.401    28.180     0.200
     1.401    27.977     0.200
     1.524    30.742     0.200
     2.552    45.753     0.200
     0.627    13.691     0.200
     0.627    13.988     0.200
     0.979    18.979     0.200
     0.979    19.081     0.200
     1.096    23.919     0.200
     1.394    27.745     0.200
     0.306     6.810     0.200
     0.502    11.519     0.200
     0.576    12.970     0.200
     1.018    22.403     0.200
     1.099    21.861     0.200
     0.276     6.126     0.200
     0.772    15.840     0.200
     0.834    16.904     0.200
     0.860    19.011     0.200
     0.892    18.829     0.200
     1.423    29.937     0.200
     1.588    30.911     0.200
     1.810    35.320     0.200
     0.176     4.129     0.200
     0.569    12.136     0.200
     0.629    13.746     0.200
     0.998    19.441     0.200
     0.998    19.340     0.200
     1.074    22.449     0.200
     1.375    28.031     0.200
     2.578    45.801     0.200
     2.578    46.000     0.200
     0.286     6.729     0.200
     0.515    11.461     0.200
     0.729    16.064     0.200
     0.973    18.708     0.200
     0.171     4.909     0.200
     0.597    12.841     0.200
     0.622    13.951     0.200
     0.979    19.482     0.200
     0.979    19.083     0.200
     1.098    23.088     0.200
     1.194    24.174     0.200
     1.921    38.592     0.200
     0.344     7.951     0.200
     0.576    12.241     0.200
     0.667    14.872     0.200
     0.958    19.980     0.200
     0.958    20.081     0.200
     1.212    24.820     0.200
     1.255    26.216     0.200
     6.859   115.506     0.200
     0.173     7.882     0.200
     0.699    15.142     0.200
     0.764    15.387     0.200
     0.960    20.008     0.200
     1.776    35.081     0.200
     1.898    37.651     0.200
     1.999    39.479     0.200
     2.122    36.740     0.200
     2.122    37.138     0.200
     0.321     7.040     0.200
     0.602    12.763     0.200
     0.620    13.454     0.200
     0.632    14.019     0.200
     0.933    19.905     0.200
     1.219    25.566     0.200
     2.701    48.875     0.200
     0.426     9.946     0.200
     0.435     9.449     0.200
     0.545    11.857     0.200
     0.918    20.313     0.200
     1.149    22.311     0.200
     1.149    23.412     0.200
     1.233    24.139     0.200
     0.144     4.633     0.200
     0.582    12.718     0.200
     0.656    14.361     0.200
     0.656    14.261     0.200
     0.969    19.508     0.200
     0.969    18.908     0.200
     1.180    24.141     0.200
     1.405    28.916     0.200
     2.776    49.916     0.200
     4.870    88.380     0.200
     6.673   117.640     0.200
     0.160     4.175     0.200
     0.572    12.565     0.200
     0.644    14.526     0.200
     0.644    14.424     0.200
     0.985    19.547     0.200
     1.170    24.489     0.200
     1.389    28.733     0.200
     1.658    32.189     0.200
     3.057    55.673     0.200
     5.300    92.994     0.200
     5.495    95.015     0.200
     0.156     4.380     0.200
     0.575    12.583     0.200
     0.646    14.861     0.200
     0.646    14.560     0.200
     0.980    19.659     0.200
     1.173    24.210     0.200
     1.393    28.944     0.200
     1.501    30.378     0.200
     5.522    95.356     0.200
     0.156     3.529     0.200
     0.567    12.333     0.200
     0.651    14.047     0.200
     0.651    13.946     0.200
     0.985    19.355     0.200
     0.985    19.253     0.200
     1.164    23.357     0.200
     1.389    27.031     0.200
     2.585    47.577     0.200
     0.289     8.179     0.200
     0.621    12.498     0.200
     0.621    11.998     0.200
     0.840    17.453     0.200
     0.840    17.749     0.200
     1.871    35.108     0.200
     1.871    35.413     0.200
     0.073     5.692     0.200
     0.671    14.008     0.200
     0.723    15.403     0.200
     0.857    17.242     0.200
     0.857    16.842     0.200
     1.999    39.504     0.200
     0.321     7.375     0.200
     0.430     8.410     0.200
     0.639    14.061     0.200
     0.780    16.923     0.200
     1.107    23.101     0.200
     1.277    24.819     0.200
     0.323     7.366     0.200
     0.431     8.612     0.200
     0.431    10.510     0.200
     0.637    14.410     0.200
     0.780    17.040     0.200
     0.900    18.439     0.200
     1.106    22.733     0.200
     1.278    25.225     0.200
     1.942    37.874     0.200
     7.316   123.059     0.200
     0.331     8.563     0.200
     0.501    10.871     0.200
     0.629    13.079     0.200
     0.955    20.483     0.200
     1.141    22.301     0.200
     1.169    23.685     0.200
     1.856    36.865     0.200
     2.574    44.079     0.200
     7.229   121.365     0.200
     0.174     6.286     0.200
     0.719    14.225     0.200
     0.813    17.321     0.200
     0.788    17.119     0.200
     0.788    17.221     0.200
     1.921    35.796     0.200
     1.921    36.898     0.200
     1.989    37.910     0.200
     1.967    38.253     0.200
     0.311     7.175     0.200
     0.642    13.811     0.200
     0.788    16.308     0.200
     0.903    18.970     0.200
     1.183    24.398     0.200
     4.582    79.341     0.200
     0.190     5.712     0.200
     0.585    12.497     0.200
     0.608    12.734     0.200
     0.608    13.632     0.200
     0.999    19.763     0.200
     1.181    23.839     0.200
     1.907    37.570     0.200
     0.194     5.132     0.200
     0.588    12.537     0.200
     0.602    13.266     0.200
     1.001    19.814     0.200
     1.184    23.780     0.200
     0.145     4.532     0.200
     0.628    13.200     0.200
     0.642    14.132     0.200
     0.940    18.049     0.200
     1.225    25.123     0.200
     1.953    38.825     0.200
     0.162     4.193     0.200
     0.573    12.400     0.200
     0.641    13.997     0.200
     0.986    19.474     0.200
     1.170    23.926     0.200
     1.387    28.195     0.200
     2.577    46.206     0.200
     3.056    55.016     0.200
     0.166     4.134     0.200
     0.570    12.116     0.200
     0.638    13.820     0.200
     0.990    19.316     0.200
     1.168    23.843     0.200
     1.383    27.931     0.200
     4.332    74.911     0.200
     4.848    87.499     0.200
     0.343     8.889     0.200
     0.620    13.160     0.200
     0.698    14.540     0.200
     0.922    18.726     0.200
     0.922    19.825     0.200
     1.827    35.665     0.200
     2.729    47.946     0.200
     3.338    58.241     0.200
     7.111   121.908     0.200
     0.159     4.135     0.200
     0.571    12.628     0.200
     0.645    14.159     0.200
     0.985    19.692     0.200
     1.082    22.765     0.200
     1.388    26.885     0.200
     2.580    46.185     0.200
     3.935    72.264     0.200
     0.167     4.228     0.200
     0.575    12.863     0.200
     0.635    14.156     0.200
     0.988    19.740     0.200
     0.988    19.639     0.200
     1.082    23.249     0.200
     1.385    28.012     0.200
     1.385    27.317     0.200
     1.502    29.545     0.200
     0.273     7.074     0.200
     0.538    12.575     0.200
     0.746    16.055     0.200
     0.943    18.258     0.200
     0.181     4.252     0.200
     0.470    10.888     0.200
     0.817    17.628     0.200
     1.001    19.393     0.200
     1.365    27.836     0.200
     1.413    28.378     0.200
     0.114     5.066     0.200
     0.588    13.433     0.200
     0.684    15.117     0.200
     0.946    18.465     0.200
     2.573    45.871     0.200
     0.069     5.913     0.200
     0.685    14.333     0.200
     0.736    15.327     0.200
     0.838    16.938     0.200
     1.221    24.176     0.200
     1.746    33.444     0.200
     0.448     9.889     0.200
     0.662    14.396     0.200
     1.094    22.949     0.200
     1.094    22.148     0.200
     1.216    25.728     0.200
     1.292    27.441     0.200
     1.296    26.295     0.200
     1.296    25.895     0.200
     1.333    28.965     0.200
     0.306     6.594     0.200
     0.415     8.725     0.200
     1.152    23.130     0.200
     1.152    22.729     0.200
     1.227    25.546     0.200
     1.345    27.168     0.200
     1.442    29.940     0.200
     2.070    41.512     0.200
     0.309     6.166     0.200
     0.391     8.810     0.200
     0.657    14.209     0.200
     0.896    18.320     0.200
     1.227    25.657     0.200
     1.321    26.653     0.200
     1.427    29.227     0.200
     1.513    30.319     0.200
     0.303     6.267     0.200
     0.397     8.768     0.200
     0.656    14.454     0.200
     0.903    19.174     0.200
     1.150    22.680     0.200
     1.233    25.120     0.200
     1.328    26.811     0.200
     2.069    37.157     0.200
     0.176     4.025     0.200
     0.586    12.635     0.200
     0.989    19.735     0.200
     0.989    19.540     0.200
     1.087    22.686     0.200
     1.384    28.020     0.200
     1.384    27.426     0.200
     1.514    30.407     0.200
     1.624    33.323     0.200
     0.164     4.207     0.200
     0.571    12.356     0.200
     0.640    14.051     0.200
     0.988    19.688     0.200
     1.385    28.059     0.200
     1.498    29.842     0.200
     0.588    12.405     0.200
     0.880    18.489     0.200
     0.943    18.756     0.200
     0.295     8.116     0.200
     0.586    12.223     0.200
     0.586    10.723     0.200
     0.886    18.417     0.200
     0.886    18.518     0.200
     0.939    19.294     0.200
     1.859    34.958     0.200
     1.859    33.759     0.200
     1.789    32.773     0.200
     0.431     9.906     0.200
     0.489    10.726     0.200
     0.512    10.862     0.200
     1.081    20.221     0.200
     1.081    21.521     0.200
     1.299    25.081     0.200
     1.962    38.435     0.200
     2.687    49.379     0.200
     4.080    74.226     0.200
     0.270     6.895     0.200
     0.766    15.201     0.200
     1.055    22.231     0.200
     1.708    31.609     0.200
     1.919    38.254     0.200
     1.986    39.272     0.200
     0.145     4.006     0.200
     0.573    12.412     0.200
     0.659    14.999     0.200
     0.974    19.022     0.200
     0.974    19.226     0.200
     1.089    22.780     0.200
     1.400    27.861     0.200
     1.497    29.824     0.200
     0.282     7.822     0.200
     0.597    12.051     0.200
     0.927    19.101     0.200
     1.778    32.073     0.200
     1.872    35.771     0.200
     1.995    39.331     0.200
     4.317    78.642     0.200
     4.319    77.615     0.200
     0.158     4.168     0.200
     0.570    12.351     0.200
     0.647    14.958     0.200
     0.984    19.023     0.200
     1.082    22.475     0.200
     1.389    27.995     0.200
     1.496    29.743     0.200
     2.580    45.895     0.200
     0.151     3.440     0.200
     0.571    12.437     0.200
     0.654    14.674     0.200
     0.979    19.373     0.200
     1.086    23.433     0.200
     1.394    28.431     0.200
     2.581    45.581     0.200
     0.276     6.124     0.200
     0.411     8.453     0.200
     0.705    14.015     0.200
     0.729    16.838     0.200
     0.768    16.476     0.200
     0.875    18.128     0.200
     1.288    27.110     0.200
     1.431    28.447     0.200
     1.665    32.611     0.200
     2.105    41.773     0.200
     2.295    44.865     0.200
     0.310     6.682     0.200
     0.409    10.424     0.200
     0.493    10.745     0.200
     0.740    15.857     0.200
     0.986    18.987     0.200
     1.184    24.585     0.200
     1.417    28.166     0.200
     0.361     9.633     0.200
     0.719    14.351     0.200
     0.964    20.192     0.200
     1.874    36.077     0.200
     2.069    36.498     0.200
     0.343     7.192     0.200
     0.503    11.229     0.200
     0.939    20.839     0.200
     1.162    23.034     0.200
     1.211    24.764     0.200
     0.219     5.243     0.200
     0.342     7.402     0.200
     0.495    10.415     0.200
     0.594    12.965     0.200
     0.736    16.411     0.200
     1.038    22.376     0.200
     1.283    26.125     0.200
     1.339    26.864     0.200
     1.320    26.891     0.200
     0.212     5.617     0.200
     0.534    11.955     0.200
     1.041    20.642     0.200
     1.031    22.455     0.200
     1.333    26.933     0.200
     1.333    28.035     0.200
     0.120     5.918     0.200
     0.675    14.247     0.200
     0.884    17.208     0.200
     0.299     6.836     0.200
     0.448     9.097     0.200
     0.758    16.975     0.200
     1.093    22.773     0.200
     1.296    25.204     0.200
     1.296    25.305     0.200
     1.924    37.977     0.200
     3.367    61.526     0.200
     0.309     6.823     0.200
     0.442     9.274     0.200
     0.766    16.486     0.200
     1.097    22.927     0.200
     1.289    25.382     0.200
     1.930    37.602     0.200
     0.297     8.053     0.200
     0.637    12.289     0.200
     0.679    14.502     0.200
     0.816    16.996     0.200
     0.936    20.004     0.200
     0.124     5.573     0.200
     0.452    10.546     0.200
     0.555    13.253     0.200
     0.691    15.163     0.200
     0.711    15.332     0.200
     0.847    16.842     0.200
     1.763    35.054     0.200
     0.168     3.932     0.200
     0.331     7.733     0.200
     0.439    10.768     0.200
     0.587    12.435     0.200
     0.628    13.455     0.200
     0.982    19.630     0.200
     1.092    22.653     0.200
     1.390    28.164     0.200
     1.515    30.113     0.200
     2.122    43.229     0.200
     0.201     5.972     0.200
     0.320     7.083     0.200
     0.408     8.254     0.200
     0.463    10.112     0.200
     0.518    11.077     0.200
     1.160    24.083     0.200
     1.217    24.311     0.200
     1.500    31.013     0.200
     1.517    29.919     0.200
     2.036    40.159     0.200
     2.644    47.868     0.200
     4.149    73.501     0.200
     5.459    93.608     0.200
     0.158     6.062     0.200
     0.736    15.714     0.200
     0.807    16.684     0.200
     0.994    20.099     0.200
     1.306    25.558     0.200
     1.315    25.960     0.200
     0.316     8.386     0.200
     0.624    13.885     0.200
     0.815    15.867     0.200
     0.626    14.164     0.200
     0.880    18.601     0.200
     1.905    37.843     0.200
     5.034    89.225     0.200
     0.325     8.359     0.200
     0.636    13.826     0.200
     0.639    13.790     0.200
     0.802    15.591     0.200
     0.895    18.706     0.200
     1.921    38.331     0.200
     1.959    37.888     0.200
     1.984    37.093     0.200
     1.984    39.093     0.200
     0.321     8.426     0.200
     0.616    13.191     0.200
     0.624    13.598     0.200
     0.825    15.648     0.200
     0.879    18.516     0.200
     1.981    37.858     0.200
     1.963    39.072     0.200
     5.415    94.576     0.200
     0.184     4.048     0.200
     0.325     7.398     0.200
     0.580    12.118     0.200
     1.375    27.342     0.200
     0.202     5.535     0.200
     0.401     9.208     0.200
     0.585    13.070     0.200
     0.655    13.946     0.200
     0.961    19.174     0.200
     0.961    18.774     0.200
     1.140    23.087     0.200
     1.415    28.176     0.200
     1.975    38.643     0.200
     0.194     6.020     0.200
     0.734    16.220     0.200
     0.066     5.517     0.200
     0.788    17.395     0.200
     0.329     8.105     0.200
     0.346     7.804     0.200
     0.346     8.007     0.200
     0.453     9.957     0.200
     0.563    12.771     0.200
     0.785    16.386     0.200
     1.108    21.814     0.200
     1.108    23.916     0.200
     1.159    24.215     0.200
     1.339    26.618     0.200
     2.052    41.206     0.200
     0.255     5.734     0.200
     0.302     8.184     0.200
     0.300     6.708     0.200
     0.635    13.602     0.200
     0.647    14.962     0.200
     0.961    20.497     0.200
     1.173    23.522     0.200
     1.195    24.166     0.200
     1.232    25.636     0.200
     1.260    26.110     0.200
     1.423    27.208     0.200
     0.128     5.588     0.200
     0.307     7.796     0.200
     0.733    15.817     0.200
     0.820    17.911     0.200
     0.920    18.842     0.200
     0.920    19.342     0.200
     1.376    26.915     0.200
     1.370    27.595     0.200
     1.398    28.369     0.200
     1.477    28.633     0.200
     1.509    28.366     0.200
     1.509    28.569     0.200
     3.421    62.951     0.200
     3.896    71.115     0.200
     0.279     6.631     0.200
     0.456    10.063     0.200
     0.331     7.417     0.200
     1.145    22.627     0.200
     1.145    23.229     0.200
     1.290    26.233     0.200
     1.659    33.624     0.200
     2.127    40.866     0.200
     2.191    43.315     0.200
     2.267    43.532     0.200
     2.424    44.997     0.200
     0.301     7.360     0.200
     0.488     9.591     0.200
     0.627    13.658     0.200
     1.049    22.237     0.200
     1.220    24.543     0.200
     1.220    26.238     0.200
     1.272    25.738     0.200
     1.272    27.137     0.200
     1.334    25.905     0.200
     1.310    26.387     0.200
     0.280     6.554     0.200
     0.328     7.589     0.200
     0.328     6.987     0.200
     0.459    10.463     0.200
     1.110    24.158     0.200
     1.146    23.054     0.200
     1.291    26.657     0.200
     1.670    33.934     0.200
     2.129    41.276     0.200
     2.192    42.738     0.200
     2.192    42.934     0.200
     2.266    43.779     0.200
     2.266    43.576     0.200
     0.320     7.566     0.200
     0.287     7.244     0.200
     0.470     9.516     0.200
     0.548    11.703     0.200
     0.762    15.908     0.200
     1.147    22.417     0.200
     1.296    25.569     0.200
     1.296    27.167     0.200
     1.681    32.677     0.200
     1.676    32.034     0.200
     0.131     5.104     0.200
     0.434    10.169     0.200
     0.528    12.768     0.200
     0.692    14.558     0.200
     0.670    14.615     0.200
     0.670    14.717     0.200
     0.873    17.344     0.200
     0.873    17.445     0.200
     1.206    25.854     0.200
     1.500    29.628     0.200
     2.125    38.834     0.200
     0.336     8.091     0.200
     0.459     9.952     0.200
     0.557    12.003     0.200
     0.776    16.153     0.200
     1.122    22.210     0.200
     1.145    23.247     0.200
     1.145    25.145     0.200
     1.323    26.472     0.200
     0.253     7.450     0.200
     0.383     8.627     0.200
     0.448     9.274     0.200
     0.537    11.940     0.200
     0.876    19.074     0.200
     1.158    23.888     0.200
     1.370    27.014     0.200
     0.261     7.030     0.200
     0.443     9.708     0.200
     0.448     9.545     0.200
     0.561    12.028     0.200
     0.588    14.304     0.200
     0.730    15.454     0.200
     1.149    23.258     0.200
     1.174    24.468     0.200
     1.220    24.226     0.200
     1.565    30.809     0.200
     0.186     5.406     0.200
     0.337     7.545     0.200
     0.419     9.085     0.200
     0.518    10.932     0.200
     0.589    11.903     0.200
     0.702    15.784     0.200
     0.951    19.585     0.200
     1.260    25.568     0.200
     1.277    25.473     0.200
     1.302    26.382     0.200
     1.422    27.584     0.200
     0.298     7.583     0.200
     0.496    11.674     0.200
     0.553    12.508     0.200
     0.552    12.118     0.200
     0.904    17.211     0.200
     1.266    25.590     0.200
     0.135     5.007     0.200
     0.491    12.051     0.200
     0.530    11.697     0.200
     0.711    15.192     0.200
     0.982    19.214     0.200
     1.067    22.229     0.200
     1.399    28.265     0.200
     2.631    46.383     0.200
     0.242     7.065     0.200
     0.622    12.332     0.200
     0.634    13.789     0.200
     0.778    17.408     0.200
     0.879    18.731     0.200
     0.886    18.353     0.200
     1.956    39.158     0.200
     0.088     5.539     0.200
     0.829    17.697     0.200
     1.372    26.451     0.200
     0.180     4.443     0.200
     0.270     6.391     0.200
     0.512    10.175     0.200
     0.664    13.991     0.200
     0.696    14.927     0.200
     1.032    22.301     0.200
     1.177    24.005     0.200
     1.274    26.475     0.200
     1.312    26.836     0.200
     1.359    26.381     0.200
     0.183     5.525     0.200
     0.333     7.676     0.200
     0.420     8.958     0.200
     0.515    11.049     0.200
     0.581    11.676     0.200
     0.709    15.984     0.200
     0.958    19.775     0.200
     1.267    25.673     0.200
     1.282    25.504     0.200
     1.299    26.699     0.200
     1.414    27.757     0.200
     0.121     5.445     0.200
     0.327     8.747     0.200
     0.678    15.246     0.200
     0.678    14.345     0.200
     0.678    15.545     0.200
     0.952    18.953     0.200
     0.952    18.453     0.200
     1.108    23.324     0.200
     1.913    38.337     0.200
     0.329     7.702     0.200
     0.329     8.499     0.200
     0.718    14.963     0.200
     0.825    18.120     0.200
     0.885    18.217     0.200
     0.834    17.605     0.200
     0.834    17.808     0.200
     1.329    27.237     0.200
     1.380    27.642     0.200
     0.115     5.359     0.200
     0.497    12.202     0.200
     0.624    13.324     0.200
     0.672    14.761     0.200
     0.924    18.219     0.200
     1.951    38.432     0.200
     0.284     6.900     0.200
     0.329     8.877     0.200
     0.487    10.234     0.200
     0.655    14.072     0.200
     0.721    16.110     0.200
     1.054    22.323     0.200
     1.299    26.962     0.200
     1.337    28.021     0.200
     0.251     6.076     0.200
     0.355     9.554     0.200
     0.548    12.209     0.200
     0.567    12.783     0.200
     1.065    20.766     0.200
     1.023    21.567     0.200
     1.308    25.740     0.200
     1.861    36.880     0.200
     0.733    15.727     0.200
     1.373    26.860     0.200
     0.290     6.616     0.200
     0.312     8.360     0.200
     0.573    12.309     0.200
     0.646    14.368     0.200
     0.645    13.678     0.200
     0.965    20.234     0.200
     1.166    23.195     0.200
     1.230    24.552     0.200
     0.088     6.481     0.200
     0.793    17.554     0.200
     2.608    45.176     0.200
     0.257     5.975     0.200
     0.403    10.062     0.200
     0.532    11.661     0.200
     0.681    14.321     0.200
     0.681    15.221     0.200
     0.987    19.050     0.200
     1.143    23.530     0.200
     1.993    39.313     0.200
     2.456    43.514     0.200
     5.263    93.251     0.200
     0.088     4.818     0.200
     0.420     9.439     0.200
     0.512    10.770     0.200
     0.575    11.041     0.200
     0.789    17.344     0.200
     0.995    20.030     0.200
     1.349    27.404     0.200
     1.386    27.070     0.200
     1.379    28.357     0.200
     0.172     6.091     0.200
     0.500    10.757     0.200
     0.615    12.521     0.200
     0.929    19.354     0.200
     0.929    19.553     0.200
     1.288    25.765     0.200
     1.445    28.139     0.200
     4.007    71.333     0.200
     0.219     5.793     0.200
     0.409     9.283     0.200
     0.657    14.189     0.200
     0.756    15.832     0.200
     1.223    24.182     0.200
     1.353    26.659     0.200
     2.643    47.708     0.200
     3.315    59.635     0.200
     0.151     5.489     0.200
     0.401     9.075     0.200
     0.474    10.421     0.200
     0.635    13.538     0.200
     0.704    15.834     0.200
     0.916    18.359     0.200
     1.265    25.591     0.200
     1.294    26.853     0.200
     1.460    28.620     0.200
     0.284     6.964     0.200
     0.492    11.543     0.200
     0.538    11.804     0.200
     0.558    11.767     0.200
     0.790    16.458     0.200
     0.905    17.720     0.200
     1.256    26.029     0.200
     1.498    29.197     0.200
     0.290     7.511     0.200
     0.551    12.357     0.200
     0.504    12.310     0.200
     0.564    12.509     0.200
     0.564    12.610     0.200
     0.894    17.456     0.200
     0.804    17.508     0.200
     2.335    41.246     0.200
     0.210     5.717     0.200
     0.337     7.525     0.200
     0.396     8.440     0.200
     0.452     9.785     0.200
     0.939    20.405     0.200
     1.196    23.998     0.200
     1.183    24.459     0.200
     1.460    29.224     0.200
     1.493    29.941     0.200
     2.061    41.009     0.200
     0.330     7.349     0.200
     0.314     7.438     0.200
     0.275     7.387     0.200
     0.502    10.950     0.200
     0.976    20.522     0.200
     1.136    22.440     0.200
     1.239    25.244     0.200
     2.602    46.236     0.200
     0.127     5.412     0.200
     0.345     8.467     0.200
     0.351     9.295     0.200
     0.374     8.723     0.200
     0.652    14.183     0.200
     0.832    18.084     0.200
     1.164    23.807     0.200
     1.998    39.277     0.200
     0.194     6.328     0.200
     0.194     6.527     0.200
     0.329     7.754     0.200
     0.329     8.055     0.200
     0.410     9.306     0.200
     0.526    11.651     0.200
     0.585    12.661     0.200
     0.699    15.540     0.200
     0.953    18.676     0.200
     0.953    19.375     0.200
     1.256    25.330     0.200
     1.820    36.059     0.200
     0.277     7.461     0.200
     0.277     7.262     0.200
     0.689    15.555     0.200
     0.689    15.356     0.200
     1.279    25.159     0.200
     1.383    26.353     0.200
     0.270     7.960     0.200
     0.295     8.168     0.200
     0.524    10.894     0.200
     0.598    12.931     0.200
     0.805    16.519     0.200
     1.179    22.357     0.200
     1.140    23.203     0.200
     1.292    25.734     0.200
     2.580    44.997     0.200
     0.216     6.038     0.200
     0.314     6.886     0.200
     0.389     8.213     0.200
     0.584    12.332     0.200
     0.548    11.560     0.200
     0.686    14.950     0.200
     0.951    19.752     0.200
     1.250    24.766     0.200
     1.290    27.199     0.200
     1.422    28.357     0.200
     0.226     5.371     0.200
     0.226     6.175     0.200
     0.355     8.762     0.200
     0.566    13.210     0.200
     0.605    12.647     0.200
     1.015    19.761     0.200
     1.082    23.180     0.200
     1.921    38.187     0.200
     0.308     6.587     0.200
     0.376     7.888     0.200
     0.561    11.730     0.200
     0.586    12.039     0.200
     0.676    13.783     0.200
     0.948    20.409     0.200
     1.237    24.741     0.200
     1.232    24.599     0.200
     1.426    28.039     0.200
     0.267     6.373     0.200
     0.372     8.740     0.200
     0.524    11.566     0.200
     0.617    13.188     0.200
     1.042    20.325     0.200
     1.337    26.684     0.200
     1.925    38.124     0.200
     0.159     3.908     0.200
     0.285     6.535     0.200
     0.333     8.370     0.200
     0.478     9.582     0.200
     0.658    14.182     0.200
     0.729    15.853     0.200
     1.064    22.645     0.200
     1.201    24.245     0.200
     1.266    25.479     0.200
     1.326    25.888     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
