#!/bin/bash
gmt begin ushkan1.37_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance ushkan1.37'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.9  0.000
  0.9 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.900    19.683
     1.000    21.046
     1.100    22.409
     1.200    23.771
     1.300    25.134
     1.400    26.497
     1.500    27.860
     1.600    29.223
     1.700    30.586
     1.800    31.949
     1.900    33.312
     2.000    34.675
     2.100    36.038
     2.200    37.401
     2.300    38.764
     2.400    40.127
     2.500    41.490
     2.600    42.853
     2.700    44.216
     2.800    45.579
     2.900    46.942
     3.000    48.305
     3.100    49.668
     3.200    51.031
     3.300    52.394
     3.400    53.756
     3.500    55.119
     3.600    56.482
     3.700    57.844
     3.800    59.207
     3.900    60.570
     4.000    61.932
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    54.482 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     3.065
     0.200     4.475
     0.300     6.144
     0.400     7.909
     0.500     9.718
     0.600    11.551
     0.700    13.398
     0.800    15.253
     0.900    17.080
     1.000    18.759
     1.100    20.439
     1.200    22.118
     1.300    23.797
     1.400    25.477
     1.500    27.156
     1.600    28.835
     1.700    30.515
     1.800    32.194
     1.900    33.874
     2.000    35.553
     2.100    37.232
     2.200    38.912
     2.300    40.591
     2.400    42.271
     2.500    43.950
     2.600    45.629
     2.700    47.309
     2.800    48.988
     2.900    50.667
     3.000    52.346
     3.100    54.025
     3.200    55.704
     3.300    57.383
     3.400    59.062
     3.500    60.741
     3.600    62.420
     3.700    64.099
     3.800    65.777
     3.900    67.456
     4.000    69.135
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    61.420 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    36.970
     2.100    38.775
     2.200    40.579
     2.300    42.384
     2.400    44.188
     2.500    45.993
     2.600    47.798
     2.700    49.602
     2.800    51.407
     2.900    53.211
     3.000    55.016
     3.100    56.820
     3.200    58.625
     3.300    60.429
     3.400    62.234
     3.500    64.038
     3.600    65.843
     3.700    67.647
     3.800    69.452
     3.900    71.256
     4.000    73.061
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    67.843 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.100    38.394
     1.200    40.821
     1.300    43.247
     1.400    45.673
     1.500    48.100
     1.600    50.526
     1.700    52.952
     1.800    55.379
     1.900    57.805
     2.000    60.232
     2.100    62.658
     2.200    65.084
     2.300    67.511
     2.400    69.937
     2.500    72.363
     2.600    74.790
     2.700    77.216
     2.800    79.642
     2.900    82.069
     3.000    84.495
     3.100    86.922
     3.200    89.348
     3.300    91.774
     3.400    94.201
     3.500    96.627
     3.600    99.053
     3.700   101.479
     3.800   103.905
     3.900   106.331
     4.000   108.756
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    97.053 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     5.318
     0.200     7.765
     0.300    10.661
     0.400    13.725
     0.500    16.864
     0.600    20.045
     0.700    23.249
     0.800    26.460
     0.900    29.302
     1.000    32.144
     1.100    34.986
     1.200    37.828
     1.300    40.670
     1.400    43.512
     1.500    46.354
     1.600    49.196
     1.700    52.038
     1.800    54.880
     1.900    57.722
     2.000    60.564
     2.100    63.406
     2.200    66.248
     2.300    69.090
     2.400    71.932
     2.500    74.775
     2.600    77.616
     2.700    80.458
     2.800    83.300
     2.900    86.141
     3.000    88.983
     3.100    91.824
     3.200    94.665
     3.300    97.506
     3.400   100.348
     3.500   103.189
     3.600   106.030
     3.700   108.872
     3.800   111.713
     3.900   114.553
     4.000   117.394
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   105.030 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    61.376
     2.100    64.504
     2.200    67.631
     2.300    70.759
     2.400    73.887
     2.500    77.015
     2.600    80.143
     2.700    83.270
     2.800    86.398
     2.900    89.526
     3.000    92.654
     3.100    95.781
     3.200    98.909
     3.300   102.037
     3.400   105.165
     3.500   108.293
     3.600   111.420
     3.700   114.548
     3.800   117.676
     3.900   120.804
     4.000   123.932
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   113.420 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.100    24.076
     1.200    25.439
     1.300    26.802
     1.400    28.165
     1.500    29.528
     1.600    30.891
     1.700    32.254
     1.800    33.617
     1.900    34.980
     2.000    36.343
     2.100    37.706
     2.200    39.069
     2.300    40.432
     2.400    41.795
     2.500    43.158
     2.600    44.521
     2.700    45.884
     2.800    47.247
     2.900    48.610
     3.000    49.973
     3.100    51.336
     3.200    52.699
     3.300    54.062
     3.400    55.425
     3.500    56.788
     3.600    58.150
     3.700    59.513
     3.800    60.876
     3.900    62.238
     4.000    63.601
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.885
     0.200     3.769
     0.300     5.654
     0.400     7.538
     0.500     9.423
     0.600    11.307
     0.700    13.192
     0.800    15.077
     0.900    16.961
     1.000    18.846
     1.100    20.730
     1.200    22.615
     1.300    24.499
     1.400    26.384
     1.500    28.249
     1.600    29.928
     1.700    31.608
     1.800    33.287
     1.900    34.967
     2.000    36.646
     2.100    38.325
     2.200    40.005
     2.300    41.684
     2.400    43.364
     2.500    45.043
     2.600    46.722
     2.700    48.402
     2.800    50.081
     2.900    51.760
     3.000    53.439
     3.100    55.119
     3.200    56.798
     3.300    58.477
     3.400    60.156
     3.500    61.835
     3.600    63.514
     3.700    65.193
     3.800    66.872
     3.900    68.551
     4.000    70.229
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.200    43.630
     1.300    46.057
     1.400    48.483
     1.500    50.910
     1.600    53.336
     1.700    55.762
     1.800    58.189
     1.900    60.615
     2.000    63.041
     2.100    65.468
     2.200    67.894
     2.300    70.321
     2.400    72.747
     2.500    75.173
     2.600    77.600
     2.700    80.026
     2.800    82.452
     2.900    84.879
     3.000    87.305
     3.100    89.732
     3.200    92.158
     3.300    94.584
     3.400    97.011
     3.500    99.437
     3.600   101.864
     3.700   104.290
     3.800   106.716
     3.900   109.142
     4.000   111.568
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.270
     0.200     6.541
     0.300     9.811
     0.400    13.081
     0.500    16.351
     0.600    19.622
     0.700    22.892
     0.800    26.162
     0.900    29.433
     1.000    32.703
     1.100    35.973
     1.200    39.243
     1.300    42.514
     1.400    45.582
     1.500    48.424
     1.600    51.266
     1.700    54.108
     1.800    56.950
     1.900    59.792
     2.000    62.634
     2.100    65.476
     2.200    68.318
     2.300    71.160
     2.400    74.002
     2.500    76.844
     2.600    79.686
     2.700    82.528
     2.800    85.370
     2.900    88.212
     3.000    91.053
     3.100    93.895
     3.200    96.736
     3.300    99.577
     3.400   102.419
     3.500   105.260
     3.600   108.101
     3.700   110.942
     3.800   113.784
     3.900   116.625
     4.000   119.467
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.800    16.855
     0.900    18.218
     1.000    19.581
     1.100    20.944
     1.200    22.307
     1.300    23.670
     1.400    25.033
     1.500    26.396
     1.600    27.759
     1.700    29.121
     1.800    30.484
     1.900    31.847
     2.000    33.210
     2.100    34.573
     2.200    35.936
     2.300    37.299
     2.400    38.662
     2.500    40.025
     2.600    41.388
     2.700    42.751
     2.800    44.114
     2.900    45.477
     3.000    46.840
     3.100    48.203
     3.200    49.566
     3.300    50.929
     3.400    52.291
     3.500    53.654
     3.600    55.017
     3.700    56.379
     3.800    57.742
     3.900    59.104
     4.000    60.467
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     5.088
     0.200     5.980
     0.300     7.222
     0.400     8.658
     0.500    10.201
     0.600    11.801
     0.700    13.432
     0.800    15.080
     0.900    16.737
     1.000    18.401
     1.100    20.068
     1.200    21.737
     1.300    23.409
     1.400    25.082
     1.500    26.755
     1.600    28.430
     1.700    30.104
     1.800    31.780
     1.900    33.456
     2.000    35.132
     2.100    36.808
     2.200    38.484
     2.300    40.161
     2.400    41.837
     2.500    43.514
     2.600    45.191
     2.700    46.868
     2.800    48.545
     2.900    50.222
     3.000    51.899
     3.100    53.576
     3.200    55.253
     3.300    56.930
     3.400    58.607
     3.500    60.284
     3.600    61.961
     3.700    63.638
     3.800    65.315
     3.900    66.992
     4.000    68.669
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    31.216
     1.000    33.642
     1.100    36.068
     1.200    38.495
     1.300    40.921
     1.400    43.347
     1.500    45.774
     1.600    48.200
     1.700    50.627
     1.800    53.053
     1.900    55.479
     2.000    57.906
     2.100    60.332
     2.200    62.758
     2.300    65.185
     2.400    67.611
     2.500    70.038
     2.600    72.464
     2.700    74.890
     2.800    77.317
     2.900    79.743
     3.000    82.170
     3.100    84.596
     3.200    87.022
     3.300    89.449
     3.400    91.875
     3.500    94.301
     3.600    96.727
     3.700    99.152
     3.800   101.578
     3.900   104.003
     4.000   106.429
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     8.766
     0.200    10.299
     0.300    12.431
     0.400    14.891
     0.500    17.525
     0.600    20.249
     0.700    23.019
     0.800    25.814
     0.900    28.623
     1.000    31.440
     1.100    34.263
     1.200    37.090
     1.300    39.919
     1.400    42.751
     1.500    45.584
     1.600    48.417
     1.700    51.252
     1.800    54.088
     1.900    56.924
     2.000    59.760
     2.100    62.597
     2.200    65.434
     2.300    68.271
     2.400    71.109
     2.500    73.946
     2.600    76.784
     2.700    79.622
     2.800    82.460
     2.900    85.298
     3.000    88.136
     3.100    90.974
     3.200    93.812
     3.300    96.650
     3.400    99.488
     3.500   102.326
     3.600   105.165
     3.700   108.003
     3.800   110.841
     3.900   113.679
     4.000   116.517
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.695    30.625     0.200
     1.985    33.924     0.200
     1.985    34.625     0.200
     3.014    48.825     0.200
     3.661    57.625     0.200
     4.862    72.625     0.200
     5.041    79.625     0.200
     1.902    32.820     0.200
     2.278    37.721     0.200
     3.245    51.021     0.200
     3.350    50.621     0.200
     3.515    53.721     0.200
     3.515    54.621     0.200
     3.520    55.320     0.200
     4.888    73.920     0.200
     4.925    74.721     0.200
     5.297    80.721     0.200
     5.297    81.021     0.200
     9.300   134.721     0.200
    13.140   185.721     0.200
    13.284   188.221     0.200
    13.492   191.721     0.200
    13.669   189.521     0.200
    14.673   205.721     0.200
    14.784   210.721     0.200
    14.911   209.721     0.200
    15.011   209.721     0.200
    15.011   209.920     0.200
    15.506   216.121     0.200
    15.732   221.721     0.200
    16.307   229.221     0.200
    16.332   229.721     0.200
    17.293   240.721     0.200
    17.884   246.721     0.200
    18.553   257.121     0.200
    19.818   270.721     0.200
     1.750    28.664     0.200
     2.787    43.363     0.200
     2.728    43.664     0.200
     2.752    44.164     0.200
     3.227    52.664     0.200
     1.163    22.684     0.200
     2.391    38.484     0.200
     3.097    48.785     0.200
     3.662    58.484     0.200
     3.744    55.383     0.200
     3.918    59.785     0.200
     4.570    69.785     0.200
     2.207    35.969     0.200
     2.597    41.773     0.200
     2.657    41.672     0.200
     4.044    60.672     0.200
     2.642    42.422     0.200
     4.723    68.621     0.200
     2.641    42.047     0.200
     2.723    43.547     0.200
     3.338    52.348     0.200
     4.713    68.547     0.200
     2.675    42.961     0.200
     2.934    45.660     0.200
     3.456    54.559     0.200
     3.876    58.461     0.200
     4.733    69.258     0.200
     5.763    82.961     0.200
     2.639    43.090     0.200
     3.893    58.590     0.200
     2.299    38.176     0.200
     2.476    40.777     0.200
     2.487    41.977     0.200
     2.487    41.578     0.200
     2.658    42.078     0.200
     2.911    46.375     0.200
     3.391    52.578     0.200
     3.391    52.977     0.200
     3.670    56.477     0.200
     3.670    56.277     0.200
     4.117    61.977     0.200
     4.264    65.078     0.200
     4.450    66.977     0.200
     4.458    67.078     0.200
     4.848    72.676     0.200
     4.848    76.176     0.200
     4.877    72.375     0.200
     4.877    72.977     0.200
     5.186    78.477     0.200
     5.186    78.375     0.200
     5.766    86.977     0.200
     5.766    87.078     0.200
     5.841    86.375     0.200
     5.975    87.977     0.200
     6.196    92.078     0.200
     6.196    93.777     0.200
     6.309    91.676     0.200
     7.463   107.078     0.200
    13.491   189.977     0.200
    14.098   197.277     0.200
    14.140   198.977     0.200
    14.160   199.875     0.200
    14.136   198.477     0.200
    14.870   208.078     0.200
    15.615   216.977     0.200
    15.725   220.977     0.200
    17.544   244.477     0.200
    17.955   249.977     0.200
    20.323   277.875     0.200
     2.696    44.464     0.200
     2.979    49.665     0.200
     3.286    52.464     0.200
     3.519    58.364     0.200
     3.767    58.564     0.200
     4.855    76.964     0.200
     2.282    37.812     0.200
     2.570    43.612     0.200
     3.071    48.713     0.200
     3.071    49.112     0.200
     3.309    51.913     0.200
     3.309    52.513     0.200
     3.874    61.513     0.200
     4.298    66.513     0.200
     4.393    66.513     0.200
     4.393    65.812     0.200
     4.791    75.213     0.200
     4.791    74.312     0.200
     5.229    80.513     0.200
     5.229    79.612     0.200
     5.543    84.612     0.200
     1.916    32.605     0.200
     2.230    36.705     0.200
     3.038    47.506     0.200
     3.717    56.506     0.200
     2.304    39.625     0.200
     2.377    37.727     0.200
     2.665    43.320     0.200
     3.256    51.727     0.200
     3.540    57.023     0.200
     3.765    58.727     0.200
     2.637    43.375     0.200
     2.637    43.273     0.200
     2.653    44.176     0.200
     3.138    50.074     0.200
     3.138    49.875     0.200
     3.257    51.176     0.200
     3.418    54.074     0.200
     3.837    59.473     0.200
     3.829    60.074     0.200
     3.829    59.574     0.200
     4.191    65.375     0.200
     4.237    66.074     0.200
     4.237    65.875     0.200
     4.747    74.074     0.200
     5.197    80.375     0.200
     5.367    80.176     0.200
     5.443    81.914     0.200
     5.610    82.973     0.200
     6.992   101.973     0.200
     2.296    37.380     0.200
     2.167    37.508     0.200
     2.360    39.906     0.200
     2.573    43.008     0.200
     2.737    45.711     0.200
     3.193    51.609     0.200
     3.262    51.711     0.200
     3.310    53.008     0.200
     3.827    60.305     0.200
     3.908    62.508     0.200
     3.908    62.711     0.200
     4.181    64.109     0.200
     4.181    64.508     0.200
     5.310    82.406     0.200
     5.362    81.008     0.200
     1.719    31.217     0.200
     2.127    35.617     0.200
     2.353    39.417     0.200
     2.717    44.917     0.200
     2.880    46.217     0.200
     3.421    54.417     0.200
     3.954    62.617     0.200
     3.954    60.617     0.200
     4.451    68.817     0.200
     4.576    68.617     0.200
     5.256    81.917     0.200
     2.368    39.262     0.200
     2.503    41.160     0.200
     2.644    43.961     0.200
     3.155    49.762     0.200
     3.155    50.461     0.200
     3.225    51.062     0.200
     3.454    53.562     0.200
     3.454    54.160     0.200
     3.795    59.262     0.200
     4.384    67.160     0.200
     4.384    66.262     0.200
     4.713    73.863     0.200
     5.161    79.961     0.200
     5.627    83.660     0.200
     1.976    33.659     0.200
     2.511    40.759     0.200
     2.718    43.659     0.200
     2.978    46.458     0.200
     3.442    53.458     0.200
     5.367    82.159     0.200
     1.882    32.449     0.200
     2.218    37.148     0.200
     2.292    38.148     0.200
     2.569    41.852     0.200
     2.574    42.449     0.200
     3.077    49.250     0.200
     3.293    53.148     0.200
     3.293    52.449     0.200
     3.436    53.352     0.200
     3.791    58.648     0.200
     3.856    60.352     0.200
     4.138    63.750     0.200
     4.165    63.949     0.200
     4.287    66.949     0.200
     4.287    66.750     0.200
     4.411    65.750     0.200
     4.773    75.449     0.200
     4.773    75.250     0.200
     5.209    79.750     0.200
     5.512    83.391     0.200
     5.549    81.949     0.200
     6.744    99.551     0.200
     6.744    99.250     0.200
     6.970   101.949     0.200
     7.459   109.852     0.200
     8.222   117.129     0.200
    13.963   197.629     0.200
    14.332   203.047     0.200
     1.960    32.919     0.200
     2.209    36.019     0.200
     2.657    42.619     0.200
     3.395    53.318     0.200
     3.934    62.318     0.200
     5.277    80.219     0.200
     1.743    29.324     0.200
     1.920    31.523     0.200
     2.203    36.125     0.200
     3.102    47.926     0.200
     4.285    63.824     0.200
     2.289    37.215     0.200
     3.167    50.414     0.200
     1.934    32.665     0.200
     2.203    35.564     0.200
     2.561    40.865     0.200
     2.695    42.265     0.200
     3.022    47.165     0.200
     3.274    49.564     0.200
     3.683    56.865     0.200
     4.292    63.265     0.200
     4.292    62.965     0.200
     4.918    75.265     0.200
     5.215    77.665     0.200
     5.366    80.865     0.200
     6.821    98.465     0.200
     2.280    37.021     0.200
     3.059    47.822     0.200
     3.151    49.422     0.200
     3.715    56.521     0.200
     4.025    60.223     0.200
     1.700    28.855     0.200
     1.701    29.457     0.200
     2.058    33.758     0.200
     2.212    37.059     0.200
     2.430    39.656     0.200
     3.124    48.758     0.200
     3.290    50.855     0.200
     1.890    32.668     0.200
     2.269    37.566     0.200
     2.606    42.066     0.200
     2.606    42.367     0.200
     2.723    43.469     0.200
     3.065    48.770     0.200
     3.329    52.168     0.200
     3.329    52.270     0.200
     3.384    51.867     0.200
     3.384    52.066     0.200
     3.762    58.867     0.200
     3.898    61.066     0.200
     3.898    60.566     0.200
     4.313    66.566     0.200
     4.313    66.367     0.200
     4.368    65.066     0.200
     4.815    73.668     0.200
     4.815    74.168     0.200
     5.256    80.770     0.200
     5.256    79.770     0.200
     5.536    82.367     0.200
     6.714    99.668     0.200
     6.926   100.367     0.200
     1.821    31.143     0.200
     2.313    37.643     0.200
     2.529    40.443     0.200
     2.622    42.343     0.200
     3.004    46.343     0.200
     3.229    50.243     0.200
     3.822    56.843     0.200
     4.056    62.043     0.200
     4.437    70.143     0.200
     4.712    68.643     0.200
     4.837    73.643     0.200
     2.095    35.129     0.200
     2.099    35.929     0.200
     2.354    39.529     0.200
     2.754    44.429     0.200
     3.605    56.329     0.200
     5.312    81.329     0.200
     1.642    28.938     0.200
     1.785    30.938     0.200
     2.175    35.734     0.200
     2.307    38.133     0.200
     2.327    38.438     0.200
     2.510    40.938     0.200
     2.715    42.234     0.200
     2.715    42.836     0.200
     3.399    52.734     0.200
     4.136    62.531     0.200
     4.724    71.836     0.200
     5.643    85.531     0.200
     5.643    84.836     0.200
     6.096    89.438     0.200
     6.082    90.031     0.200
     1.710    29.809     0.200
     1.710    30.008     0.200
     1.687    30.309     0.200
     2.034    33.609     0.200
     2.195    36.508     0.200
     2.245    36.809     0.200
     2.308    37.309     0.200
     2.417    39.410     0.200
     2.612    42.109     0.200
     2.855    45.109     0.200
     3.139    49.508     0.200
     3.269    50.809     0.200
     3.405    52.207     0.200
     3.538    55.508     0.200
     4.002    60.707     0.200
     4.677    69.910     0.200
     4.677    70.309     0.200
     5.499    83.008     0.200
     5.499    83.109     0.200
     5.930    88.707     0.200
     6.079    88.910     0.200
     2.340    37.621     0.200
     2.443    39.020     0.200
     2.443    39.121     0.200
     2.643    40.820     0.200
     2.677    42.922     0.200
     2.869    45.223     0.200
     6.233    92.820     0.200
     6.233    92.422     0.200
    10.198   147.621     0.200
     2.314    38.703     0.200
     2.569    42.104     0.200
     2.832    46.504     0.200
     3.043    48.604     0.200
     3.355    53.104     0.200
     3.629    57.904     0.200
     4.060    63.104     0.200
     4.340    66.004     0.200
     5.027    77.805     0.200
     2.496    39.867     0.200
     4.024    61.266     0.200
     2.073    35.109     0.200
     2.121    36.109     0.200
     2.332    39.211     0.200
     2.332    39.414     0.200
     2.840    46.016     0.200
     2.775    45.211     0.200
     2.775    45.109     0.200
     2.858    46.312     0.200
     2.858    44.812     0.200
     3.212    51.812     0.200
     3.212    51.711     0.200
     3.431    53.109     0.200
     3.483    54.711     0.200
     4.536    67.812     0.200
     4.504    69.211     0.200
     4.504    69.312     0.200
     4.931    76.312     0.200
     4.931    77.812     0.200
     4.931    76.516     0.200
     5.106    76.711     0.200
     5.106    76.609     0.200
     5.313    79.312     0.200
     5.313    78.016     0.200
     5.327    80.711     0.200
     5.327    82.109     0.200
     5.327    80.914     0.200
     5.745    85.812     0.200
     5.745    85.594     0.200
     5.855    87.656     0.200
     6.539    96.516     0.200
     6.539    97.312     0.200
     6.828    99.711     0.200
     6.828    99.914     0.200
     7.400   108.609     0.200
     7.565   112.211     0.200
     8.232   116.516     0.200
     9.357   133.914     0.200
    14.093   197.109     0.200
    14.012   197.914     0.200
    14.012   200.016     0.200
    14.493   204.312     0.200
    14.816   208.016     0.200
    18.017   249.234     0.200
     1.624    29.699     0.200
     1.900    33.099     0.200
     2.127    36.799     0.200
     2.392    40.500     0.200
     2.506    40.799     0.200
     2.831    46.299     0.200
     2.831    46.399     0.200
     2.879    46.500     0.200
     2.993    48.000     0.200
     3.196    52.500     0.200
     3.213    50.500     0.200
     3.492    55.199     0.200
     3.602    56.199     0.200
     3.853    60.699     0.200
     4.166    63.799     0.200
     4.166    65.199     0.200
     4.345    65.500     0.200
     4.581    70.599     0.200
     5.023    75.699     0.200
     5.082    77.399     0.200
     5.082    78.199     0.200
     5.296    78.099     0.200
     5.506    83.699     0.200
     5.506    84.399     0.200
     5.679    85.369     0.200
     5.805    87.319     0.200
     6.443    95.699     0.200
     6.443    95.099     0.200
     6.663    98.000     0.200
     7.293   107.699     0.200
     8.015   114.299     0.200
    12.722   181.199     0.200
    12.854   183.899     0.200
    14.033   197.599     0.200
    14.220   200.649     0.200
    14.321   202.399     0.200
    14.593   205.199     0.200
    14.925   208.899     0.200
    15.028   210.299     0.200
    17.685   243.799     0.200
    18.185   250.199     0.200
    18.185   250.943     0.200
     1.614    29.477     0.200
     2.013    34.477     0.200
     2.013    34.578     0.200
     2.389    40.375     0.200
     2.389    40.477     0.200
     2.833    44.875     0.200
     2.871    46.277     0.200
     3.227    50.477     0.200
     3.499    54.875     0.200
     3.593    57.578     0.200
     4.155    62.578     0.200
     4.356    66.676     0.200
     5.494    85.477     0.200
     6.675    97.477     0.200
     6.675    97.977     0.200
     2.009    33.801     0.200
     2.011    33.500     0.200
     2.094    35.301     0.200
     2.094    34.602     0.200
     2.322    37.699     0.200
     2.331    37.699     0.200
     2.517    40.801     0.200
     2.660    43.699     0.200
     2.739    43.602     0.200
     2.779    43.102     0.200
     2.817    44.301     0.200
     3.579    54.902     0.200
     4.286    63.402     0.200
     4.286    63.602     0.200
     4.307    64.602     0.200
     4.871    72.402     0.200
     4.871    73.402     0.200
     5.262    78.500     0.200
     5.785    86.301     0.200
     5.968    86.602     0.200
     6.184    91.602     0.200
     1.823    31.781     0.200
     2.072    35.078     0.200
     2.132    36.281     0.200
     2.316    39.078     0.200
     2.447    39.883     0.200
     2.832    45.977     0.200
     2.774    45.281     0.200
     2.774    45.180     0.200
     2.851    46.578     0.200
     2.851    45.477     0.200
     3.205    51.477     0.200
     3.455    53.281     0.200
     3.479    54.781     0.200
     3.479    54.680     0.200
     3.586    55.977     0.200
     3.586    56.281     0.200
     4.012    62.578     0.200
     4.012    62.680     0.200
     4.505    69.578     0.200
     4.505    69.477     0.200
     4.564    68.078     0.200
     4.922    76.578     0.200
     4.922    77.977     0.200
     5.106    76.578     0.200
     5.305    79.383     0.200
     5.305    78.578     0.200
     5.312    80.578     0.200
     5.312    82.281     0.200
     5.312    80.680     0.200
     5.763    85.969     0.200
     5.871    87.820     0.200
     6.541    96.977     0.200
     6.541    98.383     0.200
     6.841    99.977     0.200
     7.403   108.680     0.200
     9.333   132.578     0.200
    12.881   184.680     0.200
    12.995   186.180     0.200
    13.990   198.414     0.200
    14.500   205.477     0.200
    14.519   204.539     0.200
    14.794   207.578     0.200
    17.760   246.180     0.200
    18.004   249.734     0.200
     1.989    33.781     0.200
     2.178    35.883     0.200
     2.474    39.984     0.200
     2.687    43.082     0.200
     2.792    44.684     0.200
     2.967    46.883     0.200
     2.967    46.684     0.200
     3.382    51.484     0.200
     3.404    52.883     0.200
     3.677    56.582     0.200
     3.677    56.383     0.200
     3.962    61.781     0.200
     3.962    62.184     0.200
     4.422    65.484     0.200
     4.422    65.684     0.200
     4.401    67.383     0.200
     4.401    67.281     0.200
     4.877    72.582     0.200
     4.877    76.684     0.200
     5.204    77.281     0.200
     5.204    77.082     0.200
     5.439    80.484     0.200
     5.601    83.484     0.200
     5.601    84.652     0.200
     5.713    85.121     0.200
     6.630    97.184     0.200
     6.630    97.684     0.200
     6.869    99.383     0.200
     6.869    99.582     0.200
     7.548   111.484     0.200
     9.403   136.082     0.200
    14.202   199.781     0.200
     2.239    37.328     0.200
     2.570    42.328     0.200
     2.647    43.027     0.200
     3.047    48.527     0.200
     3.329    51.629     0.200
     3.726    57.527     0.200
     3.946    62.328     0.200
     4.328    65.027     0.200
     4.864    73.629     0.200
     5.310    81.027     0.200
     5.310    81.430     0.200
     2.185    35.809     0.200
     2.327    38.512     0.200
     2.522    41.309     0.200
     2.993    47.109     0.200
     2.993    46.711     0.200
     3.310    51.910     0.200
     5.348    81.109     0.200
     2.300    37.930     0.200
     2.592    41.430     0.200
     2.867    45.930     0.200
     3.384    52.730     0.200
     4.079    62.730     0.200
     4.306    63.828     0.200
     5.032    77.230     0.200
     7.192   103.930     0.200
     2.236    37.277     0.200
     2.236    37.078     0.200
     2.565    42.180     0.200
     2.565    41.777     0.200
     2.649    42.879     0.200
     2.649    43.277     0.200
     3.043    48.578     0.200
     3.332    50.578     0.200
     3.374    53.277     0.200
     3.374    53.480     0.200
     3.946    61.777     0.200
     4.333    64.879     0.200
     4.350    66.680     0.200
     4.350    66.277     0.200
     5.309    81.480     0.200
     1.830    32.016     0.200
     2.289    37.516     0.200
     2.690    43.609     0.200
     2.733    44.312     0.200
     3.148    49.211     0.200
     3.735    58.914     0.200
     4.079    61.109     0.200
     4.961    77.109     0.200
     2.299    37.773     0.200
     2.591    41.477     0.200
     2.864    45.875     0.200
     3.383    52.672     0.200
     3.622    57.070     0.200
     3.622    56.273     0.200
     3.994    62.570     0.200
     4.079    62.672     0.200
     4.312    64.773     0.200
     4.543    69.672     0.200
     5.028    77.273     0.200
     2.300    38.203     0.200
     2.457    41.003     0.200
     2.541    42.304     0.200
     2.608    42.703     0.200
     3.025    48.104     0.200
     3.239    51.403     0.200
     3.822    60.203     0.200
     3.766    60.304     0.200
     4.284    66.804     0.200
     4.675    73.503     0.200
     5.068    78.804     0.200
     5.750    86.604     0.200
    13.759   193.482     0.200
    18.235   251.443     0.200
    18.321   252.729     0.200
     2.239    37.680     0.200
     2.564    42.586     0.200
     2.644    43.180     0.200
     2.765    45.281     0.200
     2.765    45.086     0.200
     2.765    46.180     0.200
     3.043    47.781     0.200
     3.043    48.984     0.200
     3.340    51.984     0.200
     3.412    54.781     0.200
     3.369    53.086     0.200
     3.369    52.984     0.200
     3.369    53.438     0.200
     3.727    58.281     0.200
     3.940    60.781     0.200
     4.340    65.180     0.200
     4.347    67.383     0.200
     4.347    67.281     0.200
     4.858    76.086     0.200
     4.858    74.586     0.200
     5.257    78.680     0.200
     5.257    78.781     0.200
     5.302    80.586     0.200
     5.302    80.484     0.200
     5.513    82.086     0.200
     5.510    82.781     0.200
     5.510    83.484     0.200
     5.624    84.703     0.200
     6.678    98.383     0.200
     6.882   100.781     0.200
     8.128   115.180     0.200
     8.128   115.984     0.200
     9.909   141.883     0.200
     9.924   142.586     0.200
    10.057   144.180     0.200
    10.057   144.281     0.200
    12.623   179.984     0.200
    12.735   182.984     0.200
    14.046   198.383     0.200
    14.046   197.930     0.200
    14.264   198.383     0.200
    14.264   198.844     0.200
    14.257   201.484     0.200
    14.276   201.484     0.200
    14.677   205.281     0.200
    14.677   208.781     0.200
    14.881   209.586     0.200
    15.102   213.680     0.200
    15.304   214.180     0.200
    15.821   225.680     0.200
    16.309   226.984     0.200
    16.309   229.984     0.200
    16.991   237.281     0.200
    17.971   248.086     0.200
    17.971   248.805     0.200
    18.124   252.680     0.200
    19.249   267.680     0.200
    20.215   279.125     0.200
     2.246    37.625     0.200
     2.575    42.727     0.200
     2.640    42.922     0.200
     2.763    43.227     0.200
     3.054    49.422     0.200
     3.365    52.820     0.200
     3.365    52.922     0.200
     3.733    57.625     0.200
     3.939    61.422     0.200
     4.329    65.820     0.200
     4.329    65.320     0.200
     4.340    67.820     0.200
     4.856    75.922     0.200
     5.303    81.625     0.200
     2.245    37.578     0.200
     2.566    42.781     0.200
     2.637    42.383     0.200
     2.758    45.383     0.200
     4.344    64.977     0.200
     5.518    82.477     0.200
     2.247    37.664     0.200
     2.247    37.766     0.200
     2.572    42.867     0.200
     2.572    42.664     0.200
     2.637    43.266     0.200
     3.052    49.062     0.200
     3.362    53.062     0.200
     3.735    58.164     0.200
     3.735    58.266     0.200
     3.934    62.664     0.200
     3.934    62.562     0.200
     4.336    65.562     0.200
     4.336    65.266     0.200
     4.339    67.164     0.200
     5.297    81.562     0.200
     5.522    81.266     0.200
     5.522    82.469     0.200
     5.501    85.062     0.200
     6.686    99.766     0.200
     6.888   100.664     0.200
     6.888   100.969     0.200
     1.915    33.520     0.200
     2.232    37.320     0.200
     2.564    42.922     0.200
     2.564    42.422     0.200
     2.654    43.121     0.200
     2.776    44.922     0.200
     3.040    48.820     0.200
     3.040    48.922     0.200
     3.327    51.719     0.200
     3.327    52.020     0.200
     3.379    53.121     0.200
     3.379    53.020     0.200
     3.719    58.121     0.200
     3.951    61.121     0.200
     3.951    61.020     0.200
     4.354    67.320     0.200
     4.869    75.820     0.200
     4.869    75.922     0.200
     4.869    75.719     0.200
     5.314    80.121     0.200
     5.509    81.820     0.200
     5.509    83.621     0.200
     5.624    84.922     0.200
     6.670    98.621     0.200
     6.871   100.520     0.200
     6.871   100.320     0.200
     8.115   117.422     0.200
     9.914   142.520     0.200
    14.059   199.520     0.200
    18.514   256.344     0.200
    18.514   258.820     0.200
    20.474   278.820     0.200
    20.474   279.301     0.200
     0.962    20.782     0.200
     1.920    33.282     0.200
     2.226    37.482     0.200
     2.560    42.682     0.200
     2.660    43.282     0.200
     3.035    48.582     0.200
     3.035    49.482     0.200
     3.385    53.182     0.200
     3.385    53.282     0.200
     3.713    58.582     0.200
     4.876    74.382     0.200
     5.320    81.882     0.200
     5.320    82.082     0.200
     1.898    33.369     0.200
     2.251    37.669     0.200
     2.251    37.469     0.200
     2.634    43.069     0.200
     3.056    49.069     0.200
     3.359    51.569     0.200
     3.359    53.269     0.200
     3.738    58.769     0.200
     3.738    58.969     0.200
     3.932    61.769     0.200
     3.932    61.069     0.200
     4.850    75.769     0.200
     5.296    81.469     0.200
     5.296    81.869     0.200
     6.890   100.569     0.200
     1.904    33.422     0.200
     2.244    37.719     0.200
     2.573    43.520     0.200
     2.642    43.121     0.200
     3.333    51.922     0.200
     3.368    52.422     0.200
     3.368    52.820     0.200
     3.731    58.621     0.200
     3.731    57.719     0.200
     3.941    61.520     0.200
     4.329    65.320     0.200
     4.859    75.621     0.200
     4.859    75.922     0.200
     5.305    81.621     0.200
     5.305    81.820     0.200
     6.681    99.520     0.200
     6.881   100.922     0.200
     2.245    37.514     0.200
     2.571    41.412     0.200
     2.638    42.912     0.200
     4.337    65.312     0.200
     2.211    37.195     0.200
     2.538    42.293     0.200
     4.350    65.293     0.200
     2.228    37.284     0.200
     2.555    42.484     0.200
     2.654    43.184     0.200
     3.034    48.684     0.200
     3.379    53.584     0.200
     3.949    59.684     0.200
     4.342    65.184     0.200
     4.867    73.784     0.200
     5.247    78.384     0.200
     6.874   100.284     0.200
     2.046    34.234     0.200
     2.163    35.430     0.200
     2.511    40.734     0.200
     2.562    41.328     0.200
     4.577    68.031     0.200
     4.577    70.234     0.200
     4.712    70.133     0.200
     6.065    90.133     0.200
     1.610    27.426     0.200
     2.147    35.125     0.200
     2.616    41.625     0.200
     2.823    44.125     0.200
     3.062    46.523     0.200
     3.013    47.426     0.200
     3.594    55.223     0.200
     4.110    60.824     0.200
     4.160    63.125     0.200
     5.081    76.824     0.200
     5.598    83.184     0.200
     5.553    82.625     0.200
     2.246    37.602     0.200
     2.569    42.703     0.200
     2.569    42.203     0.200
     2.637    43.000     0.200
     3.050    48.301     0.200
     3.050    49.000     0.200
     3.418    55.102     0.200
     3.735    58.500     0.200
     4.341    65.203     0.200
     5.295    81.602     0.200
     6.889   100.402     0.200
     6.889   100.703     0.200
     2.074    35.594     0.200
     2.369    39.694     0.200
     2.893    46.394     0.200
     3.416    53.994     0.200
     3.416    53.794     0.200
     4.557    68.094     0.200
     4.863    76.594     0.200
     5.259    80.994     0.200
     1.631    28.117     0.200
     1.631    27.715     0.200
     2.117    35.414     0.200
     2.154    36.016     0.200
     2.734    43.215     0.200
     2.760    43.816     0.200
     2.796    44.414     0.200
     3.405    52.316     0.200
     3.405    52.617     0.200
     3.306    51.215     0.200
     4.016    59.715     0.200
     4.266    64.617     0.200
     4.214    65.516     0.200
     4.614    69.617     0.200
     4.614    71.316     0.200
     4.820    70.215     0.200
     5.486    81.617     0.200
     5.545    82.555     0.200
     5.772    86.215     0.200
     5.872    85.117     0.200
     5.872    85.617     0.200
     7.547   108.617     0.200
     8.789   128.117     0.200
    13.355   189.715     0.200
    17.299   239.840     0.200
     2.263    37.869     0.200
     2.578    42.069     0.200
     2.692    44.569     0.200
     4.657    68.769     0.200
     2.234    37.457     0.200
     2.565    42.555     0.200
     2.565    42.656     0.200
     2.651    43.156     0.200
     3.041    47.957     0.200
     3.041    48.855     0.200
     3.330    50.855     0.200
     3.330    52.156     0.200
     3.376    53.258     0.200
     3.721    58.156     0.200
     4.332    65.156     0.200
     4.867    74.855     0.200
     5.252    78.457     0.200
     5.311    81.758     0.200
     5.511    82.258     0.200
     6.873   100.555     0.200
     6.873   101.156     0.200
     2.241    37.391     0.200
     2.573    42.789     0.200
     2.646    43.086     0.200
     2.639    42.287     0.200
     1.884    32.123     0.200
     1.997    33.623     0.200
     2.182    36.723     0.200
     2.286    38.023     0.200
     2.775    44.723     0.200
     2.854    45.523     0.200
     3.374    51.723     0.200
     3.506    54.523     0.200
     3.563    54.924     0.200
     4.101    63.723     0.200
     4.101    63.824     0.200
     4.519    66.723     0.200
     4.579    70.523     0.200
     5.028    75.523     0.200
     5.247    77.223     0.200
     5.405    82.523     0.200
     6.748    97.723     0.200
     6.748    98.223     0.200
     1.090    23.883     0.200
     2.242    37.586     0.200
     2.566    42.586     0.200
     2.641    43.180     0.200
     3.046    48.680     0.200
     3.046    48.883     0.200
     3.342    52.086     0.200
     3.366    53.586     0.200
     3.730    58.484     0.200
     3.937    62.984     0.200
     3.937    62.680     0.200
     4.088    64.180     0.200
     4.341    65.281     0.200
     4.343    66.883     0.200
     4.855    73.281     0.200
     4.855    76.680     0.200
     5.299    81.484     0.200
     5.516    81.586     0.200
     6.886   100.781     0.200
     6.886   100.883     0.200
     2.246    37.570     0.200
     2.571    42.773     0.200
     2.571    42.672     0.200
     2.638    43.070     0.200
     2.760    42.172     0.200
     3.051    47.977     0.200
     3.051    48.773     0.200
     3.341    52.375     0.200
     3.341    51.977     0.200
     3.363    52.977     0.200
     3.734    58.273     0.200
     3.935    62.070     0.200
     3.935    61.875     0.200
     4.091    64.070     0.200
     4.337    65.477     0.200
     4.337    66.273     0.200
     4.340    66.977     0.200
     4.340    67.172     0.200
     4.853    76.172     0.200
     4.853    75.570     0.200
     5.298    81.570     0.200
     5.298    81.875     0.200
     5.502    84.070     0.200
     5.520    81.672     0.200
     6.685    97.977     0.200
     6.887   100.570     0.200
     2.059    34.242     0.200
     2.059    34.344     0.200
     2.313    37.543     0.200
     2.269    37.543     0.200
     2.288    37.344     0.200
     2.842    44.844     0.200
     3.233    49.844     0.200
     3.543    54.441     0.200
     4.267    64.141     0.200
     4.267    64.543     0.200
     4.267    63.051     0.200
     4.336    64.242     0.200
     4.336    64.141     0.200
     4.740    70.242     0.200
     4.825    72.441     0.200
     5.232    78.043     0.200
     5.738    86.141     0.200
     5.788    86.043     0.200
     6.020    87.242     0.200
     6.130    90.543     0.200
     6.130    90.844     0.200
     6.120    90.242     0.200
     6.120    90.141     0.200
     6.280    92.543     0.200
     7.643   107.531     0.200
    14.730   207.543     0.200
     2.248    37.625     0.200
     2.635    42.922     0.200
     2.756    43.320     0.200
     3.052    48.219     0.200
     3.360    52.922     0.200
     3.737    59.320     0.200
     3.931    61.023     0.200
     3.931    61.219     0.200
     4.340    65.320     0.200
     4.337    67.219     0.200
     5.267    79.422     0.200
     5.294    81.219     0.200
     5.294    81.523     0.200
     5.503    83.922     0.200
     6.891   101.625     0.200
     2.241    37.859     0.200
     2.564    43.160     0.200
     2.564    42.859     0.200
     2.640    43.160     0.200
     3.045    49.160     0.200
     3.365    53.359     0.200
     3.365    53.859     0.200
     3.730    58.461     0.200
     3.936    63.160     0.200
     4.344    65.758     0.200
     4.344    65.559     0.200
     4.343    67.961     0.200
     4.853    76.258     0.200
     5.260    79.160     0.200
     5.297    82.160     0.200
     5.515    82.160     0.200
     5.510    84.758     0.200
     6.887   100.859     0.200
     6.887   100.961     0.200
     1.967    34.375     0.200
     2.197    37.074     0.200
     2.497    41.875     0.200
     2.671    43.773     0.200
     2.779    44.973     0.200
     2.988    47.172     0.200
     2.988    48.375     0.200
     3.390    53.574     0.200
     3.390    53.473     0.200
     3.950    61.473     0.200
     3.950    61.172     0.200
     3.950    62.672     0.200
     4.383    67.973     0.200
     4.383    68.074     0.200
     4.407    66.773     0.200
     4.407    66.375     0.200
     4.866    74.973     0.200
     4.866    76.375     0.200
     5.221    79.473     0.200
     5.294    81.672     0.200
     5.294    81.473     0.200
     5.460    80.973     0.200
     5.578    85.074     0.200
     5.690    85.875     0.200
     6.878   100.875     0.200
    14.018   199.793     0.200
    18.482   257.375     0.200
    18.568   257.410     0.200
     1.977    34.172     0.200
     2.491    41.570     0.200
     4.399    66.477     0.200
     1.401    26.738     0.200
     1.964    34.138     0.200
     2.203    36.938     0.200
     2.497    41.838     0.200
     2.663    43.338     0.200
     2.992    48.338     0.200
     3.382    52.338     0.200
     3.382    53.538     0.200
     3.941    62.438     0.200
     4.416    66.338     0.200
     4.856    76.238     0.200
     5.284    81.338     0.200
     5.284    81.538     0.200
     6.888   102.038     0.200
     1.960    34.417     0.200
     2.201    37.117     0.200
     2.201    37.217     0.200
     2.506    42.117     0.200
     2.506    43.317     0.200
     2.669    43.917     0.200
     2.779    44.617     0.200
     2.995    49.217     0.200
     3.389    53.617     0.200
     3.951    62.717     0.200
     4.396    66.717     0.200
     4.379    68.117     0.200
     4.867    75.917     0.200
     4.867    76.317     0.200
     5.225    79.817     0.200
     5.298    81.517     0.200
     5.466    83.517     0.200
     5.466    83.017     0.200
     5.569    85.017     0.200
     5.569    85.117     0.200
     5.681    85.817     0.200
     6.649    98.317     0.200
     6.877   101.317     0.200
     6.877   101.017     0.200
    14.024   199.517     0.200
    17.973   250.418     0.200
    18.488   257.717     0.200
    18.573   257.706     0.200
     1.974    34.391     0.200
     2.190    37.090     0.200
     2.490    41.090     0.200
     2.678    43.891     0.200
     2.678    43.691     0.200
     2.981    46.691     0.200
     2.981    47.992     0.200
     3.377    53.691     0.200
     3.397    53.789     0.200
     3.397    52.891     0.200
     3.957    62.391     0.200
     3.957    62.691     0.200
     4.390    67.789     0.200
     4.409    66.492     0.200
     4.409    66.391     0.200
     4.872    76.492     0.200
     5.300    81.191     0.200
     1.133    22.621     0.200
     1.574    29.021     0.200
     1.714    31.321     0.200
     1.965    34.621     0.200
     2.197    37.121     0.200
     2.671    43.821     0.200
     2.990    46.921     0.200
     2.990    47.921     0.200
     3.391    52.321     0.200
     3.952    62.021     0.200
     3.952    62.521     0.200
     4.868    76.221     0.200
     5.297    82.121     0.200
     5.575    84.021     0.200
     1.968    34.479     0.200
     2.194    36.979     0.200
     2.498    41.078     0.200
     2.675    43.479     0.200
     3.395    53.578     0.200
     3.690    58.578     0.200
     4.401    66.578     0.200
     4.872    75.078     0.200
     5.301    81.279     0.200
     6.872    99.578     0.200
     1.912    33.254     0.200
     2.234    37.254     0.200
     2.653    42.652     0.200
     3.042    47.355     0.200
     3.042    48.555     0.200
     3.379    53.055     0.200
     3.720    57.355     0.200
     3.720    57.555     0.200
     4.327    64.953     0.200
     4.327    64.754     0.200
     4.870    76.754     0.200
     5.315    81.254     0.200
     5.315    81.453     0.200
     6.870   100.254     0.200
     6.870    99.152     0.200
     1.498    27.582     0.200
     1.611    29.883     0.200
     1.611    30.482     0.200
     1.875    32.982     0.200
     2.305    38.482     0.200
     2.573    42.582     0.200
     2.559    42.283     0.200
     2.559    42.182     0.200
     3.085    49.582     0.200
     3.277    52.383     0.200
     3.277    52.783     0.200
     3.839    60.883     0.200
     4.150    63.783     0.200
     4.273    66.682     0.200
     4.424    66.582     0.200
     4.755    74.783     0.200
     5.190    79.883     0.200
     5.511    83.383     0.200
     5.558    82.783     0.200
     5.558    82.082     0.200
     6.988   102.582     0.200
     6.988   103.182     0.200
     2.229    37.625     0.200
     2.552    42.430     0.200
     2.653    43.430     0.200
     2.653    43.328     0.200
     2.772    47.430     0.200
     2.772    45.625     0.200
     3.032    48.930     0.200
     3.032    48.625     0.200
     3.342    52.430     0.200
     3.342    51.930     0.200
     3.400    54.531     0.200
     3.377    53.227     0.200
     3.377    52.594     0.200
     3.377    53.328     0.200
     3.718    58.227     0.200
     3.718    57.531     0.200
     3.946    61.125     0.200
     4.348    65.531     0.200
     4.356    67.625     0.200
     4.864    75.328     0.200
     4.864    76.227     0.200
     5.305    81.227     0.200
     5.305    81.125     0.200
     5.502    82.031     0.200
     5.502    81.227     0.200
     5.521    83.328     0.200
     5.521    85.625     0.200
     5.521    83.430     0.200
     5.521    83.727     0.200
     5.622    85.031     0.200
     5.635    85.109     0.200
     6.669    98.125     0.200
     6.669    98.727     0.200
     6.877   100.125     0.200
     6.877   101.125     0.200
     8.130   116.125     0.200
     9.446   137.328     0.200
    12.634   181.930     0.200
    14.046   198.930     0.200
    14.046   198.305     0.200
    14.254   197.930     0.200
    14.266   202.625     0.200
    14.285   202.031     0.200
    14.880   208.227     0.200
    17.394   240.625     0.200
    17.976   249.828     0.200
    17.976   249.305     0.200
    17.976   250.227     0.200
     2.235    37.305     0.200
     2.645    43.207     0.200
     2.764    44.406     0.200
     3.038    48.605     0.200
     3.348    51.906     0.200
     3.348    51.406     0.200
     3.406    54.406     0.200
     3.406    54.305     0.200
     3.369    53.105     0.200
     3.369    52.605     0.200
     3.369    52.906     0.200
     3.725    57.906     0.200
     3.939    63.105     0.200
     4.351    65.207     0.200
     4.349    67.406     0.200
     4.856    75.707     0.200
     5.255    78.508     0.200
     5.298    81.406     0.200
     5.298    81.105     0.200
     5.508    81.707     0.200
     5.508    81.305     0.200
     5.518    82.867     0.200
     5.631    84.848     0.200
     6.677    97.906     0.200
     6.884   100.406     0.200
     6.884   100.508     0.200
     7.527   110.008     0.200
     8.136   115.305     0.200
     9.325   135.906     0.200
    12.633   181.406     0.200
    14.040   198.777     0.200
    14.261   198.586     0.200
    14.267   201.707     0.200
    14.286   202.008     0.200
    14.873   207.605     0.200
    15.108   216.406     0.200
    17.401   242.305     0.200
    17.968   248.551     0.200
    17.968   250.707     0.200
     1.875    32.688     0.200
     2.152    35.484     0.200
     2.315    38.281     0.200
     2.543    41.688     0.200
     4.451    66.086     0.200
     4.733    74.281     0.200
     5.164    79.586     0.200
     5.164    79.688     0.200
     5.344    81.484     0.200
     7.011   102.484     0.200
     2.674    44.242     0.200
     2.692    45.047     0.200
     3.338    53.742     0.200
     2.258    37.680     0.200
     2.258    37.781     0.200
     2.578    42.980     0.200
     2.625    42.781     0.200
     2.879    46.281     0.200
     3.061    47.680     0.200
     3.350    51.582     0.200
     3.350    52.680     0.200
     3.746    58.180     0.200
     3.922    62.082     0.200
     4.341    65.781     0.200
     4.327    67.480     0.200
     4.839    75.480     0.200
     5.285    81.383     0.200
     5.285    81.180     0.200
     6.901   101.082     0.200
     6.901   100.480     0.200
     2.155    35.867     0.200
     3.664    56.268     0.200
     4.506    66.967     0.200
     1.921    33.109     0.200
     2.232    36.809     0.200
     2.253    36.906     0.200
     2.550    42.008     0.200
     2.646    42.609     0.200
     2.900    45.906     0.200
     3.034    48.109     0.200
     3.034    47.309     0.200
     3.370    52.309     0.200
     3.723    57.406     0.200
     4.357    64.809     0.200
     4.351    67.406     0.200
     4.856    73.809     0.200
     5.253    77.906     0.200
     5.296    79.406     0.200
     6.675    98.309     0.200
     6.885   100.008     0.200
     2.201    35.961     0.200
     2.666    42.758     0.200
     2.885    46.258     0.200
     2.927    47.461     0.200
     3.434    53.461     0.200
     3.641    56.859     0.200
     4.428    67.555     0.200
     4.904    75.156     0.200
     7.310   106.461     0.200
     1.659    27.508     0.200
     1.999    32.605     0.200
     2.122    34.207     0.200
     2.122    34.406     0.200
     2.469    39.008     0.200
     2.617    41.707     0.200
     2.867    44.008     0.200
     3.127    47.805     0.200
     3.560    54.406     0.200
     3.607    54.305     0.200
     4.209    62.707     0.200
     5.130    77.207     0.200
     6.608    95.805     0.200
     2.171    36.391     0.200
     2.425    39.592     0.200
     2.701    43.092     0.200
     2.921    46.291     0.200
     2.921    46.691     0.200
     2.898    45.391     0.200
     2.898    46.391     0.200
     3.470    53.891     0.200
     3.470    53.092     0.200
     4.395    66.291     0.200
     4.404    69.992     0.200
     4.546    69.691     0.200
     4.886    74.791     0.200
     4.886    76.191     0.200
     5.203    78.492     0.200
     5.944    88.992     0.200
     1.801    31.121     0.200
     2.031    34.023     0.200
     2.429    39.523     0.200
     2.421    39.621     0.200
     2.515    41.621     0.200
     2.630    43.023     0.200
     2.669    43.324     0.200
     3.181    50.121     0.200
     3.132    49.523     0.200
     3.556    54.523     0.200
     3.603    56.121     0.200
     3.684    58.023     0.200
     3.684    57.922     0.200
     3.939    60.824     0.200
     4.148    64.324     0.200
     4.148    64.121     0.200
     4.515    66.824     0.200
     4.515    67.422     0.200
     4.599    71.824     0.200
     4.599    72.324     0.200
     5.029    76.621     0.200
     5.029    76.723     0.200
     5.462    81.422     0.200
     5.462    82.523     0.200
     5.480    83.523     0.200
     5.560    83.242     0.200
     5.573    83.383     0.200
     5.573    83.379     0.200
     5.655    83.922     0.200
     5.655    82.422     0.200
     6.893   101.723     0.200
     7.034   101.824     0.200
     7.146   103.621     0.200
     7.279   108.223     0.200
     8.382   120.422     0.200
     8.382   118.922     0.200
     9.058   131.121     0.200
    13.315   187.824     0.200
    13.775   195.824     0.200
    13.776   195.293     0.200
    13.776   195.824     0.200
    13.776   195.594     0.200
    14.614   203.422     0.200
    17.704   246.344     0.200
    17.704   246.340     0.200
    18.227   251.652     0.200
    18.227   252.324     0.200
    18.312   252.344     0.200
     1.405    27.311     0.200
     2.236    37.511     0.200
     2.571    42.711     0.200
     2.906    46.711     0.200
     3.378    53.311     0.200
     3.952    59.811     0.200
     4.322    65.411     0.200
     5.316    81.611     0.200
     6.870    99.411     0.200
     2.250    37.539     0.200
     2.578    41.742     0.200
     2.578    42.938     0.200
     2.890    46.742     0.200
     3.057    48.844     0.200
     3.057    48.141     0.200
     3.336    50.344     0.200
     3.737    58.344     0.200
     3.935    59.438     0.200
     4.329    65.344     0.200
     4.329    65.539     0.200
     5.300    80.742     0.200
     2.246    37.699     0.200
     2.246    37.299     0.200
     2.575    42.400     0.200
     2.575    42.699     0.200
     2.895    46.500     0.200
     3.053    48.900     0.200
     3.366    52.600     0.200
     3.366    53.000     0.200
     3.732    58.199     0.200
     3.940    60.699     0.200
     3.940    62.100     0.200
     4.328    65.400     0.200
     4.341    66.900     0.200
     4.341    67.100     0.200
     4.858    75.699     0.200
     5.304    80.699     0.200
     5.304    81.199     0.200
     5.522    82.000     0.200
     5.522    80.600     0.200
     5.497    85.199     0.200
     5.612    85.340     0.200
     6.683    98.299     0.200
     6.882   100.900     0.200
     6.882   101.100     0.200
     7.556   113.799     0.200
     9.330   134.000     0.200
    13.588   194.500     0.200
    17.972   250.701     0.200
     0.985    19.945     0.200
     1.164    23.148     0.200
     1.389    26.047     0.200
     1.492    27.344     0.200
     1.655    30.547     0.200
     1.655    30.742     0.200
     1.697    30.547     0.200
     2.253    37.445     0.200
     2.241    37.148     0.200
     2.585    42.344     0.200
     2.635    42.742     0.200
     3.062    48.648     0.200
     3.329    52.344     0.200
     3.329    51.242     0.200
     3.739    58.148     0.200
     3.936    61.047     0.200
     3.936    61.844     0.200
     4.320    65.148     0.200
     4.855    75.844     0.200
     4.855    75.242     0.200
     5.303    81.344     0.200
     5.530    81.547     0.200
     5.530    81.344     0.200
     6.885   100.742     0.200
     1.759    30.148     0.200
     1.759    30.250     0.200
     1.871    31.750     0.200
     2.290    38.250     0.200
     2.624    41.945     0.200
     3.017    47.547     0.200
     3.270    50.945     0.200
     3.353    52.250     0.200
     3.738    56.750     0.200
     4.361    65.344     0.200
     4.720    70.547     0.200
     5.212    78.148     0.200
     5.624    84.547     0.200
     6.304    92.445     0.200
     1.999    33.838     0.200
     2.134    34.838     0.200
     2.507    40.139     0.200
     2.507    40.338     0.200
     2.763    43.238     0.200
     2.958    46.039     0.200
     3.017    46.838     0.200
     3.017    46.939     0.200
     3.241    49.338     0.200
     3.490    53.639     0.200
     3.614    55.139     0.200
     3.614    55.338     0.200
     4.063    63.738     0.200
     4.298    63.838     0.200
     4.458    67.338     0.200
     5.423    81.639     0.200
     5.563    82.838     0.200
     1.277    25.023     0.200
     1.615    28.523     0.200
     2.338    38.125     0.200
     2.551    40.625     0.200
     2.594    41.727     0.200
     2.829    44.828     0.200
     3.069    48.430     0.200
     3.344    51.828     0.200
     3.658    55.227     0.200
     4.040    61.727     0.200
     4.034    62.227     0.200
     4.315    63.930     0.200
     4.578    71.023     0.200
     5.058    77.430     0.200
     5.570    82.125     0.200
     5.816    85.828     0.200
     7.159   104.523     0.200
     1.942    32.539     0.200
     2.337    38.238     0.200
     2.551    40.840     0.200
     2.593    41.840     0.200
     3.068    48.238     0.200
     3.343    51.340     0.200
     3.497    54.039     0.200
     3.656    57.039     0.200
     4.040    62.238     0.200
     4.317    64.340     0.200
     4.577    69.141     0.200
     4.577    71.941     0.200
     5.056    77.141     0.200
     2.419    38.122     0.200
     2.423    39.022     0.200
     2.574    41.423     0.200
     2.574    42.223     0.200
     2.667    43.022     0.200
     3.147    47.822     0.200
     3.125    49.223     0.200
     3.125    49.923     0.200
     3.661    57.022     0.200
     3.661    58.122     0.200
     3.938    60.923     0.200
     4.163    63.723     0.200
     4.611    68.122     0.200
     4.611    68.223     0.200
     4.573    69.423     0.200
     4.573    70.822     0.200
     4.983    74.322     0.200
     4.983    76.723     0.200
     5.455    80.322     0.200
     5.552    83.223     0.200
     5.622    83.723     0.200
     5.640    84.441     0.200
     7.181   104.223     0.200
     7.181   104.122     0.200
    17.666   245.298     0.200
    18.167   250.923     0.200
    18.253   250.947     0.200
     1.654    29.414     0.200
     1.720    29.711     0.200
     1.989    33.016     0.200
     1.967    33.312     0.200
     2.141    35.516     0.200
     2.391    39.016     0.200
     2.391    39.117     0.200
     2.512    39.914     0.200
     2.820    44.711     0.200
     2.906    45.516     0.200
     3.024    47.211     0.200
     3.179    49.016     0.200
     3.183    51.117     0.200
     3.183    51.414     0.200
     3.160    48.914     0.200
     3.631    55.484     0.200
     3.631    54.633     0.200
     3.631    55.312     0.200
     3.833    60.211     0.200
     4.197    63.914     0.200
     4.321    64.016     0.200
     4.321    64.516     0.200
     4.605    69.617     0.200
     5.000    74.211     0.200
     5.114    77.516     0.200
     5.114    78.312     0.200
     5.282    78.016     0.200
     5.282    77.117     0.200
     5.540    83.117     0.200
     5.681    83.562     0.200
     5.681    86.711     0.200
     5.681    84.414     0.200
     5.810    86.375     0.200
     5.810    86.375     0.200
     6.370    92.516     0.200
     6.418    93.617     0.200
     6.418    93.914     0.200
     6.630    96.516     0.200
     6.630    96.117     0.200
     7.267   106.211     0.200
     7.980   112.914     0.200
     9.648   137.914     0.200
     9.608   135.812     0.200
    13.828   193.914     0.200
    14.013   194.672     0.200
    14.013   194.516     0.200
    18.219   252.055     0.200
    18.396   255.938     0.200
    18.719   260.211     0.200
     2.137    35.208     0.200
     2.736    43.108     0.200
     2.865    44.608     0.200
     2.955    46.208     0.200
     3.453    53.208     0.200
     3.506    53.808     0.200
     4.374    67.508     0.200
     4.391    65.708     0.200
     4.862    75.208     0.200
     2.250    36.426     0.200
     2.234    36.523     0.200
     2.560    41.523     0.200
     2.627    41.523     0.200
     2.744    42.625     0.200
     2.880    45.324     0.200
     3.048    47.023     0.200
     3.350    50.926     0.200
     3.918    60.523     0.200
     4.835    74.523     0.200
     5.276    79.824     0.200
     5.518    80.324     0.200
     6.906   100.023     0.200
     2.249    36.594     0.200
     2.556    41.496     0.200
     3.046    47.895     0.200
     2.196    35.922     0.200
     2.292    37.023     0.200
     2.525    41.023     0.200
     2.685    42.820     0.200
     2.803    44.422     0.200
     2.938    46.422     0.200
     3.326    50.820     0.200
     3.409    52.223     0.200
     3.977    61.723     0.200
     4.351    64.621     0.200
     4.389    67.621     0.200
     4.894    73.723     0.200
     5.332    81.320     0.200
     6.636    97.723     0.200
     6.847    99.320     0.200
     2.250    37.582     0.200
     2.241    37.184     0.200
     2.577    42.480     0.200
     2.635    42.883     0.200
     2.889    46.480     0.200
     3.056    48.781     0.200
     3.361    52.781     0.200
     3.424    54.082     0.200
     3.737    58.383     0.200
     3.934    60.582     0.200
     4.852    75.480     0.200
     5.298    81.281     0.200
     6.888   100.781     0.200
     7.550   110.980     0.200
     2.254    37.570     0.200
     2.579    42.570     0.200
     3.059    48.969     0.200
     3.741    57.871     0.200
     3.930    62.371     0.200
     4.333    65.672     0.200
     4.848    75.270     0.200
     5.272    79.371     0.200
     5.294    80.969     0.200
     1.720    29.590     0.200
     1.827    30.590     0.200
     2.209    36.291     0.200
     2.450    39.090     0.200
     2.633    41.791     0.200
     2.729    43.590     0.200
     2.904    45.391     0.200
     3.338    50.690     0.200
     3.436    54.291     0.200
     4.348    68.490     0.200
     4.684    68.690     0.200
     7.403   106.490     0.200
     2.251    37.586     0.200
     2.241    36.688     0.200
     2.580    42.992     0.200
     3.058    49.086     0.200
     3.362    51.992     0.200
     3.737    58.289     0.200
     3.935    60.086     0.200
     4.327    64.188     0.200
     4.853    74.586     0.200
     5.300    81.891     0.200
     6.886   100.086     0.200
     1.900    33.273     0.200
     2.250    37.672     0.200
     2.240    36.875     0.200
     2.574    42.477     0.200
     2.574    42.672     0.200
     2.634    42.977     0.200
     2.756    43.070     0.200
     2.887    46.672     0.200
     3.055    48.875     0.200
     3.344    51.672     0.200
     3.344    52.172     0.200
     3.359    52.172     0.200
     3.738    58.172     0.200
     3.931    61.172     0.200
     3.931    62.273     0.200
     4.335    67.070     0.200
     4.337    65.570     0.200
     4.337    65.672     0.200
     4.849    75.375     0.200
     4.849    75.477     0.200
     5.294    81.172     0.200
     5.294    80.977     0.200
     5.524    82.273     0.200
     5.524    81.477     0.200
     5.500    84.172     0.200
     5.613    84.836     0.200
     6.574    99.375     0.200
     6.891   100.672     0.200
     7.546   112.570     0.200
     8.282   120.172     0.200
    13.578   192.070     0.200
    14.041   199.977     0.200
    18.495   256.977     0.200
    18.580   256.992     0.200
    20.798   283.109     0.200
     1.756    30.160     0.200
     1.793    30.262     0.200
     2.059    34.859     0.200
     2.127    34.961     0.200
     2.336    37.160     0.200
     2.726    43.660     0.200
     2.901    46.262     0.200
     2.974    47.160     0.200
     3.437    53.461     0.200
     4.450    67.961     0.200
     4.497    66.562     0.200
     4.894    74.160     0.200
     5.158    77.762     0.200
     5.301    80.961     0.200
     5.682    84.660     0.200
     6.859    99.359     0.200
     2.224    36.969     0.200
     2.224    37.168     0.200
     2.330    38.668     0.200
     2.330    39.070     0.200
     2.621    42.668     0.200
     2.735    44.570     0.200
     2.735    44.770     0.200
     2.880    46.469     0.200
     3.202    49.270     0.200
     3.174    50.469     0.200
     3.174    49.469     0.200
     3.360    52.762     0.200
     3.360    52.867     0.200
     3.536    55.367     0.200
     3.789    59.270     0.200
     3.962    61.867     0.200
     4.138    63.367     0.200
     4.138    62.770     0.200
     4.288    66.570     0.200
     4.884    75.668     0.200
     4.884    76.469     0.200
     5.325    81.367     0.200
     5.325    81.168     0.200
     5.335    80.969     0.200
     5.369    82.070     0.200
     5.459    82.891     0.200
     5.635    84.867     0.200
     6.732   100.270     0.200
     6.722   100.168     0.200
     6.855   100.770     0.200
    18.595   259.770     0.200
    18.680   259.754     0.200
     2.573    41.297     0.200
     2.927    45.500     0.200
     3.039    47.602     0.200
     3.705    56.898     0.200
     3.977    60.797     0.200
     4.298    64.195     0.200
     4.368    66.398     0.200
     4.895    73.398     0.200
     5.236    77.398     0.200
     5.345    79.000     0.200
     6.844    98.695     0.200
     0.838    16.723     0.200
     2.119    34.223     0.200
     2.945    46.125     0.200
     4.293    63.324     0.200
     1.923    33.617     0.200
     1.923    33.117     0.200
     2.319    38.917     0.200
     2.463    39.117     0.200
     2.463    41.117     0.200
     2.576    42.018     0.200
     2.857    46.917     0.200
     3.052    48.937     0.200
     3.052    49.037     0.200
     3.371    53.617     0.200
     3.493    54.917     0.200
     3.493    54.018     0.200
     3.644    57.117     0.200
     4.011    63.218     0.200
     4.062    62.817     0.200
     4.297    65.317     0.200
     4.565    70.617     0.200
     4.565    71.117     0.200
     5.051    77.718     0.200
     5.236    79.617     0.200
     5.236    79.957     0.200
     5.335    81.417     0.200
     5.335    81.218     0.200
     6.867    99.317     0.200
     7.173   105.117     0.200
     7.173   104.817     0.200
     7.312   111.018     0.200
     8.246   118.518     0.200
     8.246   118.207     0.200
     8.596   124.317     0.200
    12.435   179.317     0.200
    13.324   192.018     0.200
    13.868   196.617     0.200
    13.868   197.567     0.200
    13.868   196.478     0.200
    14.601   206.718     0.200
    14.782   211.917     0.200
    15.312   216.354     0.200
    15.312   217.718     0.200
    17.695   245.817     0.200
    17.695   247.787     0.200
    17.695   247.594     0.200
    17.874   248.518     0.200
    18.283   253.018     0.200
    18.368   253.849     0.200
    19.016   263.317     0.200
     2.425    40.369     0.200
     2.598    42.270     0.200
     2.725    44.770     0.200
     2.725    44.668     0.200
     2.720    44.568     0.200
     3.224    51.668     0.200
     3.194    50.912     0.200
     3.194    50.719     0.200
     3.419    53.369     0.200
     3.419    53.068     0.200
     3.594    57.270     0.200
     3.777    58.869     0.200
     3.912    60.869     0.200
     4.162    65.068     0.200
     4.271    66.668     0.200
     4.311    65.068     0.200
     4.697    72.369     0.200
     5.163    79.369     0.200
     5.356    81.369     0.200
     5.442    81.568     0.200
     5.463    82.809     0.200
     5.463    82.668     0.200
     6.862   100.969     0.200
     7.041   103.369     0.200
     7.129   107.369     0.200
     7.710   112.270     0.200
     8.190   117.369     0.200
     8.450   122.568     0.200
     8.997   133.168     0.200
    12.516   180.369     0.200
    13.442   191.068     0.200
    13.949   198.158     0.200
    13.949   198.145     0.200
    14.190   200.869     0.200
    14.209   201.469     0.200
    14.450   205.270     0.200
    14.450   204.100     0.200
    14.924   211.668     0.200
    15.215   213.293     0.200
    15.969   224.619     0.200
    16.375   230.068     0.200
    17.505   241.729     0.200
    17.820   247.068     0.200
    17.820   247.318     0.200
    17.820   246.789     0.200
    17.977   247.600     0.200
    17.998   248.568     0.200
    19.118   266.469     0.200
    19.118   264.969     0.200
     2.069    34.504     0.200
     2.432    39.605     0.200
     2.465    40.105     0.200
     2.744    44.406     0.200
     2.721    43.707     0.200
     3.196    49.004     0.200
     3.237    50.906     0.200
     3.783    59.305     0.200
     3.916    60.805     0.200
     4.286    64.105     0.200
     4.703    72.605     0.200
     5.175    78.504     0.200
     5.448    81.906     0.200
     1.910    33.672     0.200
     2.244    37.875     0.200
     2.244    37.977     0.200
     2.242    37.672     0.200
     2.560    42.672     0.200
     2.636    43.273     0.200
     2.636    43.078     0.200
     2.889    46.773     0.200
     3.045    49.172     0.200
     3.045    49.273     0.200
     3.355    52.672     0.200
     3.360    53.375     0.200
     3.360    53.273     0.200
     3.734    58.477     0.200
     3.929    61.977     0.200
     3.929    61.875     0.200
     4.354    65.875     0.200
     4.354    66.078     0.200
     4.847    75.773     0.200
     4.847    75.977     0.200
     5.264    79.375     0.200
     5.264    79.273     0.200
     5.288    81.578     0.200
     5.288    81.773     0.200
     5.515    82.773     0.200
     5.515    81.477     0.200
     5.514    85.078     0.200
     5.627    85.039     0.200
     6.685    98.977     0.200
     6.894   101.273     0.200
     6.894   100.977     0.200
     7.537   109.172     0.200
    13.573   193.078     0.200
    14.031   200.102     0.200
    17.959   249.227     0.200
     2.252    37.721     0.200
     2.239    37.320     0.200
     2.578    41.920     0.200
     2.633    43.221     0.200
     3.058    48.020     0.200
     3.740    58.119     0.200
     4.332    65.619     0.200
     1.487    27.160     0.200
     1.789    30.160     0.200
     1.856    31.359     0.200
     1.840    31.262     0.200
     2.011    33.961     0.200
     2.269    37.461     0.200
     2.299    37.961     0.200
     2.649    43.059     0.200
     2.699    43.262     0.200
     3.060    48.359     0.200
     3.043    47.559     0.200
     3.109    48.559     0.200
     3.332    51.859     0.200
     3.700    56.961     0.200
     4.329    64.160     0.200
     4.741    72.059     0.200
     4.864    72.762     0.200
     5.661    85.059     0.200
     6.281    92.359     0.200
     7.130   103.762     0.200
     7.874   113.559     0.200
     1.859    31.156     0.200
     1.789    30.059     0.200
     1.789    29.957     0.200
     1.834    31.059     0.200
     2.307    37.859     0.200
     2.264    37.059     0.200
     2.705    42.957     0.200
     2.705    43.258     0.200
     3.065    49.059     0.200
     3.043    47.156     0.200
     3.159    48.258     0.200
     3.333    51.559     0.200
     3.296    50.656     0.200
     3.703    57.258     0.200
     3.767    56.957     0.200
     3.767    56.727     0.200
     4.320    63.957     0.200
     4.331    64.656     0.200
     4.739    71.258     0.200
     4.866    72.457     0.200
     5.163    76.359     0.200
     5.163    75.457     0.200
     5.664    84.957     0.200
     5.664    84.656     0.200
     5.774    86.156     0.200
     5.774    83.859     0.200
     5.774    84.316     0.200
     6.283    91.758     0.200
     6.283    91.359     0.200
     6.500    94.359     0.200
     7.131   102.859     0.200
     7.874   112.957     0.200
     7.908   111.359     0.200
     9.513   136.059     0.200
    12.760   183.359     0.200
    13.882   192.156     0.200
    13.882   192.629     0.200
    13.953   198.758     0.200
    14.299   201.059     0.200
    14.319   200.559     0.200
    14.344   199.387     0.200
    14.344   201.559     0.200
    14.344   200.168     0.200
    14.781   205.559     0.200
    14.781   207.758     0.200
    17.782   244.359     0.200
    18.291   251.656     0.200
    18.747   257.957     0.200
    19.445   266.059     0.200
     1.962    33.535     0.200
     1.962    33.335     0.200
     2.351    39.135     0.200
     2.447    40.734     0.200
     2.447    39.234     0.200
     2.600    42.535     0.200
     2.687    43.835     0.200
     2.687    43.734     0.200
     3.063    48.778     0.200
     3.063    48.535     0.200
     3.246    50.935     0.200
     3.643    55.435     0.200
     3.643    54.734     0.200
     3.618    57.535     0.200
     4.008    60.935     0.200
     4.008    61.234     0.200
     4.080    63.435     0.200
     4.080    62.935     0.200
     4.519    66.435     0.200
     4.519    67.135     0.200
     4.534    71.035     0.200
     4.534    71.335     0.200
     4.970    75.734     0.200
     5.433    81.435     0.200
     5.531    81.635     0.200
     5.531    81.435     0.200
     5.522    82.895     0.200
     5.522    82.335     0.200
     5.720    84.135     0.200
     5.720    83.335     0.200
     6.963   102.635     0.200
     6.968   104.135     0.200
     7.210   104.435     0.200
     7.210   104.135     0.200
    12.661   181.435     0.200
    13.254   189.135     0.200
    13.729   193.475     0.200
    13.729   192.936     0.200
    13.729   195.035     0.200
    13.729   194.435     0.200
    17.413   239.935     0.200
    17.641   246.335     0.200
    17.641   245.209     0.200
    17.641   245.955     0.200
    18.173   251.835     0.200
    18.258   251.812     0.200
     1.986    33.945     0.200
     2.146    35.746     0.200
     2.896    45.945     0.200
     3.040    47.246     0.200
     3.158    49.543     0.200
     3.563    55.344     0.200
     3.641    57.344     0.200
     5.102    76.145     0.200
     5.177    79.746     0.200
     5.669    85.344     0.200
     6.564    96.145     0.200
     1.899    33.297     0.200
     2.245    37.492     0.200
     2.251    37.195     0.200
     2.581    42.594     0.200
     2.581    41.992     0.200
     2.645    42.891     0.200
     2.900    46.297     0.200
     3.055    48.797     0.200
     3.055    48.695     0.200
     3.372    52.891     0.200
     4.090    63.891     0.200
     4.315    64.992     0.200
     4.315    65.094     0.200
     4.343    66.891     0.200
     4.865    74.992     0.200
     4.865    75.891     0.200
     5.261    78.695     0.200
     5.314    81.297     0.200
     5.314    81.492     0.200
     5.524    82.297     0.200
     5.524    82.094     0.200
     5.606    84.312     0.200
     6.680    98.492     0.200
     6.874   100.492     0.200
    14.064   200.047     0.200
    17.981   250.891     0.200
     1.778    30.117     0.200
     1.822    30.816     0.200
     1.872    31.219     0.200
     1.995    33.219     0.200
     2.090    34.617     0.200
     2.252    36.816     0.200
     2.317    37.418     0.200
     2.717    43.117     0.200
     3.030    47.020     0.200
     3.284    50.418     0.200
     3.346    51.719     0.200
     3.755    57.617     0.200
     4.319    65.418     0.200
     5.235    78.719     0.200
     5.654    85.020     0.200
     6.295    92.117     0.200
     6.511    94.719     0.200
     7.669   111.816     0.200
     2.251    37.605     0.200
     2.242    37.605     0.200
     2.580    42.309     0.200
     2.636    42.508     0.200
     2.890    46.309     0.200
     3.058    48.809     0.200
     3.362    52.707     0.200
     3.426    54.309     0.200
     3.737    58.105     0.200
     3.936    61.707     0.200
     4.325    65.406     0.200
     4.336    67.508     0.200
     4.854    75.008     0.200
     5.268    78.906     0.200
     5.302    81.508     0.200
     5.527    82.309     0.200
     6.688    99.309     0.200
     6.885   101.008     0.200
     2.248    37.500     0.200
     2.581    42.602     0.200
     2.641    42.801     0.200
     2.895    46.402     0.200
     3.057    49.000     0.200
     3.367    52.902     0.200
     3.733    58.402     0.200
     3.942    60.203     0.200
     4.320    65.402     0.200
     4.860    74.602     0.200
     5.264    79.402     0.200
     5.308    80.902     0.200
     5.526    82.203     0.200
     6.684    98.801     0.200
     6.880   100.902     0.200
     2.059    36.543     0.200
     2.295    39.543     0.200
     2.692    43.896     0.200
     1.874    31.141     0.200
     2.201    36.141     0.200
     2.290    37.539     0.200
     2.591    40.641     0.200
     2.664    42.141     0.200
     3.380    51.641     0.200
     4.227    62.141     0.200
     4.514    66.344     0.200
     4.703    70.344     0.200
     4.903    71.344     0.200
     5.137    76.344     0.200
     5.523    80.844     0.200
     5.523    82.945     0.200
     2.078    35.695     0.200
     2.393    38.996     0.200
     2.470    40.297     0.200
     2.470    40.695     0.200
     2.581    42.996     0.200
     2.721    44.398     0.200
     3.168    50.398     0.200
     3.168    49.996     0.200
     3.190    49.996     0.200
     3.190    50.098     0.200
     3.503    53.398     0.200
     3.755    58.695     0.200
     3.755    59.898     0.200
     3.894    61.098     0.200
     4.424    65.898     0.200
     4.424    66.195     0.200
     4.672    73.598     0.200
     4.672    72.898     0.200
     5.115    78.996     0.200
     5.420    80.996     0.200
     5.548    83.496     0.200
     5.642    83.797     0.200
     6.847   100.996     0.200
     7.069   102.797     0.200
     2.534    41.494     0.200
     2.595    41.693     0.200
     3.100    48.684     0.200
     3.306    51.285     0.200
     3.378    52.285     0.200
     3.790    58.184     0.200
     3.879    59.883     0.200
     4.284    65.883     0.200
     4.344    64.484     0.200
     4.797    74.086     0.200
     5.246    79.883     0.200
     5.570    82.684     0.200
     5.577    83.105     0.200
     6.741   100.586     0.200
     6.942   101.383     0.200
     2.141    34.820     0.200
     2.349    37.520     0.200
     2.488    40.119     0.200
     2.742    43.219     0.200
     2.860    45.219     0.200
     2.860    43.820     0.200
     2.952    46.219     0.200
     2.996    46.719     0.200
     3.289    50.219     0.200
     3.289    49.820     0.200
     3.466    52.820     0.200
     3.628    55.320     0.200
     3.987    60.820     0.200
     4.033    60.820     0.200
     4.033    60.719     0.200
     4.345    64.020     0.200
     4.445    67.420     0.200
     4.950    74.520     0.200
     4.950    74.219     0.200
     5.159    75.920     0.200
     5.420    79.219     0.200
     5.385    80.820     0.200
     5.583    82.439     0.200
     5.583    82.719     0.200
     5.702    84.480     0.200
     6.482    94.820     0.200
     6.580    95.920     0.200
     6.580    96.119     0.200
     6.792    97.920     0.200
     7.430   107.619     0.200
     8.083   114.240     0.200
     9.960   141.119     0.200
    10.666   154.920     0.200
    11.098   158.420     0.200
    12.041   168.420     0.200
    13.671   194.820     0.200
    14.110   196.299     0.200
    14.110   197.752     0.200
    14.110   200.119     0.200
    14.167   195.988     0.200
    14.167   196.740     0.200
    14.298   200.730     0.200
    15.030   209.670     0.200
    15.030   209.119     0.200
    15.190   214.219     0.200
    17.852   245.619     0.200
    17.852   245.240     0.200
    18.059   246.830     0.200
    18.059   248.396     0.200
    18.237   250.689     0.200
    18.766   258.719     0.200
    19.690   269.219     0.200
     1.924    32.426     0.200
     2.319    38.025     0.200
     2.574    41.125     0.200
     2.574    41.226     0.200
     2.575    41.625     0.200
     2.852    45.525     0.200
     3.051    48.125     0.200
     3.367    52.325     0.200
     3.367    52.025     0.200
     3.643    56.426     0.200
     3.643    57.125     0.200
     4.060    62.525     0.200
     4.012    62.226     0.200
     4.012    61.426     0.200
     4.303    63.825     0.200
     4.564    70.825     0.200
     4.564    71.025     0.200
     5.048    76.325     0.200
     5.048    77.525     0.200
     5.241    79.726     0.200
     5.340    80.205     0.200
     5.592    83.325     0.200
     5.839    86.625     0.200
     7.011   102.525     0.200
     7.174   104.025     0.200
     7.174   102.726     0.200
     8.251   117.125     0.200
     8.595   123.726     0.200
    12.324   173.426     0.200
    13.864   195.159     0.200
    17.693   245.226     0.200
    17.693   244.325     0.200
     1.930    32.629     0.200
     2.326    37.930     0.200
     2.565    41.230     0.200
     2.582    41.629     0.200
     3.057    48.129     0.200
     3.647    56.430     0.200
     4.020    61.828     0.200
     4.310    65.328     0.200
     4.568    69.930     0.200
     5.050    77.328     0.200
     7.169   103.730     0.200
     1.749    30.422     0.200
     1.870    31.922     0.200
     2.269    38.320     0.200
     2.618    42.125     0.200
     3.010    47.719     0.200
     3.116    48.320     0.200
     2.039    34.525     0.200
     2.103    34.525     0.200
     3.504    53.725     0.200
     3.590    54.926     0.200
     4.070    61.426     0.200
     4.348    63.926     0.200
     4.986    75.225     0.200
     5.120    76.826     0.200
     5.417    81.225     0.200
     6.757    97.625     0.200
     1.912    33.594     0.200
     2.240    37.789     0.200
     2.557    42.594     0.200
     2.641    43.195     0.200
     2.895    46.891     0.200
     3.043    48.992     0.200
     3.366    54.195     0.200
     3.729    58.391     0.200
     4.086    63.289     0.200
     4.347    65.789     0.200
     4.345    67.391     0.200
     4.854    75.695     0.200
     5.259    78.789     0.200
     5.296    81.594     0.200
     6.887   100.992     0.200
     2.036    34.914     0.200
     2.428    40.219     0.200
     2.426    40.414     0.200
     2.644    44.219     0.200
     2.675    43.914     0.200
     3.699    59.516     0.200
     3.935    61.516     0.200
     4.149    64.312     0.200
     4.479    67.117     0.200
     4.615    72.016     0.200
     5.052    78.812     0.200
     5.459    81.219     0.200
     5.663    86.312     0.200
     6.889   101.312     0.200
     7.128   104.617     0.200
     1.809    31.203     0.200
     1.830    31.504     0.200
     2.234    36.203     0.200
     2.273    37.305     0.200
     2.602    42.102     0.200
     2.831    45.305     0.200
     2.914    46.602     0.200
     3.265    50.402     0.200
     3.738    58.203     0.200
     3.812    58.504     0.200
     4.370    66.703     0.200
     4.962    75.703     0.200
     4.940    72.504     0.200
     5.305    79.203     0.200
     5.380    79.504     0.200
     7.182   104.004     0.200
     1.808    30.672     0.200
     1.975    32.773     0.200
     1.905    31.773     0.200
     1.943    32.375     0.200
     1.968    33.172     0.200
     2.265    37.473     0.200
     2.202    36.172     0.200
     2.487    39.773     0.200
     2.755    43.875     0.200
     2.876    45.375     0.200
     3.124    48.672     0.200
     3.363    50.875     0.200
     3.483    53.574     0.200
     3.483    53.473     0.200
     3.585    54.875     0.200
     3.820    58.973     0.200
     4.123    62.172     0.200
     4.520    66.273     0.200
     4.520    66.172     0.200
     4.601    69.773     0.200
     4.601    69.375     0.200
     5.006    74.375     0.200
     5.034    76.672     0.200
     5.034    76.375     0.200
     5.226    77.375     0.200
     5.425    80.875     0.200
     5.802    85.402     0.200
     5.802    85.773     0.200
     5.802    85.984     0.200
     5.919    87.285     0.200
     5.919    87.414     0.200
     6.438    94.773     0.200
     6.727    97.375     0.200
     7.298   106.672     0.200
     8.057   114.973     0.200
     8.167   114.762     0.200
     8.167   114.875     0.200
     8.167   114.984     0.200
    11.048   157.473     0.200
    12.055   169.074     0.200
    12.881   182.672     0.200
    13.006   185.074     0.200
    14.082   198.043     0.200
    14.082   197.672     0.200
    14.082   198.707     0.200
    14.082   199.074     0.200
    14.473   203.375     0.200
    14.493   203.113     0.200
    14.493   203.484     0.200
    15.040   208.473     0.200
    15.040   210.375     0.200
    15.394   215.574     0.200
    16.862   233.172     0.200
    17.158   238.074     0.200
    17.918   245.922     0.200
    17.804   246.473     0.200
    18.117   248.902     0.200
    18.117   249.254     0.200
    18.117   249.598     0.200
    18.293   251.684     0.200
    19.880   273.375     0.200
    20.901   285.574     0.200
     1.823    30.953     0.200
     1.921    32.156     0.200
     1.959    32.453     0.200
     1.984    33.156     0.200
     2.217    36.555     0.200
     2.251    37.156     0.200
     2.503    39.852     0.200
     2.739    43.953     0.200
     2.892    45.352     0.200
     3.140    48.750     0.200
     3.357    50.750     0.200
     3.467    54.055     0.200
     3.601    54.953     0.200
     3.804    58.250     0.200
     4.138    63.656     0.200
     4.523    66.156     0.200
     4.618    69.852     0.200
     5.049    76.852     0.200
     5.210    77.656     0.200
     5.438    81.852     0.200
     6.714    96.953     0.200
     2.265    37.578     0.200
     2.481    39.773     0.200
     2.758    43.977     0.200
     2.869    45.375     0.200
     3.117    48.875     0.200
     3.490    54.172     0.200
     3.577    53.977     0.200
     4.115    63.172     0.200
     4.528    66.273     0.200
     5.415    81.773     0.200
     1.903    33.391     0.200
     2.251    37.891     0.200
     2.110    35.891     0.200
     2.234    37.391     0.200
     2.627    42.891     0.200
     2.880    46.094     0.200
     2.880    46.594     0.200
     3.052    49.094     0.200
     3.351    53.094     0.200
     3.351    52.594     0.200
     3.742    58.492     0.200
     3.920    61.492     0.200
     4.332    67.293     0.200
     4.356    65.594     0.200
     4.356    65.793     0.200
     4.838    74.992     0.200
     4.838    75.691     0.200
     5.272    78.891     0.200
     5.280    80.992     0.200
     5.522    82.391     0.200
     5.622    85.191     0.200
     6.694    98.594     0.200
     6.903   101.094     0.200
     6.903   100.992     0.200
    14.024   199.586     0.200
    14.277   199.492     0.200
    20.817   284.098     0.200
     2.190    35.894     0.200
     2.677    43.694     0.200
     2.980    46.594     0.200
     2.928    46.194     0.200
     3.396    53.294     0.200
     3.687    57.294     0.200
     3.955    59.994     0.200
     4.412    65.894     0.200
     5.297    81.994     0.200
     5.587    83.394     0.200
     1.587    26.987     0.200
     2.267    36.487     0.200
     2.585    41.487     0.200
     2.961    47.187     0.200
     3.748    56.487     0.200
     4.071    60.687     0.200
     6.003    87.987     0.200
     6.175    91.687     0.200
     2.316    37.391     0.200
     2.863    44.891     0.200
     4.195    62.488     0.200
     2.052    35.344     0.200
     2.217    37.445     0.200
     2.241    38.047     0.200
     2.375    40.242     0.200
     2.375    39.047     0.200
     2.625    43.242     0.200
     2.625    43.445     0.200
     2.867    47.242     0.200
     2.867    46.945     0.200
     2.941    47.344     0.200
     2.941    47.547     0.200
     3.320    53.148     0.200
     3.320    52.945     0.200
     3.740    58.445     0.200
     3.740    58.547     0.200
     3.842    62.344     0.200
     3.842    59.945     0.200
     4.368    67.547     0.200
     4.368    67.742     0.200
     4.659    69.547     0.200
     4.750    74.547     0.200
     5.132    79.547     0.200
     5.132    79.844     0.200
     5.254    79.148     0.200
     5.415    80.844     0.200
     5.727    86.047     0.200
     5.823    87.469     0.200
     7.019   102.547     0.200
     7.019   102.648     0.200
     8.257   117.695     0.200
    13.802   196.523     0.200
    17.826   247.211     0.200
    18.288   252.844     0.200
    18.374   252.797     0.200
     2.194    37.012     0.200
     2.914    46.512     0.200
     2.923    46.112     0.200
     3.459    53.712     0.200
     3.511    55.312     0.200
     4.178    63.912     0.200
     4.368    67.012     0.200
     4.917    74.812     0.200
     1.750    30.477     0.200
     1.830    31.977     0.200
     2.209    37.273     0.200
     2.263    37.180     0.200
     2.263    37.773     0.200
     2.448    40.578     0.200
     2.635    42.375     0.200
     2.704    44.078     0.200
     2.704    43.773     0.200
     2.898    46.273     0.200
     2.898    46.375     0.200
     3.327    51.875     0.200
     3.421    53.773     0.200
     3.896    58.773     0.200
     3.964    61.273     0.200
     4.162    63.477     0.200
     4.162    63.578     0.200
     4.331    68.078     0.200
     4.467    67.578     0.200
     4.735    69.773     0.200
     4.738    73.180     0.200
     4.738    72.078     0.200
     5.490    81.977     0.200
     5.559    83.336     0.200
     5.673    83.875     0.200
     6.719    98.180     0.200
     7.115   104.273     0.200
     7.425   107.477     0.200
     7.988   117.273     0.200
     8.520   120.109     0.200
     1.145    25.383     0.200
     2.002    35.285     0.200
     2.127    37.086     0.200
     2.191    37.883     0.200
     2.267    38.285     0.200
     2.424    41.184     0.200
     2.575    43.383     0.200
     2.575    43.484     0.200
     2.640    42.484     0.200
     2.640    43.383     0.200
     2.817    46.785     0.200
     2.992    49.684     0.200
     2.992    48.285     0.200
     3.272    52.902     0.200
     3.630    56.086     0.200
     3.630    57.484     0.200
     3.789    59.785     0.200
     4.317    67.785     0.200
     4.646    70.383     0.200
     5.096    77.684     0.200
     5.096    79.684     0.200
     5.304    79.684     0.200
     5.467    81.883     0.200
     5.683    85.684     0.200
     5.777    87.484     0.200
     6.743   100.285     0.200
     7.058   103.484     0.200
     7.140   106.484     0.200
     8.269   120.859     0.200
    13.779   197.512     0.200
    17.786   248.008     0.200
    18.345   254.934     0.200
     1.887    32.281     0.200
     2.282    38.180     0.200
     2.537    41.375     0.200
     2.601    41.977     0.200
     3.012    48.578     0.200
     3.385    53.180     0.200
     3.599    57.078     0.200
     4.092    63.281     0.200
     4.520    68.781     0.200
     5.000    76.680     0.200
     2.005    35.422     0.200
     2.192    37.016     0.200
     2.266    38.117     0.200
     2.576    43.422     0.200
     2.640    44.219     0.200
     2.818    46.719     0.200
     2.990    49.820     0.200
     2.990    48.617     0.200
     3.272    52.914     0.200
     3.272    52.516     0.200
     3.788    59.516     0.200
     3.788    59.617     0.200
     4.319    67.719     0.200
     4.319    67.016     0.200
     4.650    70.016     0.200
     4.706    74.820     0.200
     4.706    74.422     0.200
     5.095    79.820     0.200
     5.303    80.617     0.200
     5.465    82.820     0.200
     5.686    85.820     0.200
     5.686    86.219     0.200
     5.780    87.656     0.200
     6.743   100.016     0.200
     7.059   103.422     0.200
     7.059   103.219     0.200
     7.140   106.719     0.200
     8.268   122.922     0.200
     8.272   119.539     0.200
     8.429   122.320     0.200
    13.776   195.344     0.200
    17.786   246.422     0.200
    18.343   253.266     0.200
    18.503   257.219     0.200
     2.018    34.996     0.200
     2.199    37.398     0.200
     2.259    37.496     0.200
     2.408    40.496     0.200
     2.582    42.898     0.200
     2.644    42.797     0.200
     2.824    46.398     0.200
     2.980    47.598     0.200
     3.278    51.797     0.200
     4.327    66.699     0.200
     4.708    71.797     0.200
     1.822    31.836     0.200
     2.020    34.637     0.200
     2.125    35.434     0.200
     2.362    38.434     0.200
     2.465    40.637     0.200
     2.465    40.535     0.200
     2.755    43.934     0.200
     2.755    44.035     0.200
     2.870    45.934     0.200
     2.935    46.836     0.200
     3.008    47.637     0.200
     3.292    50.535     0.200
     3.292    51.336     0.200
     3.308    52.336     0.200
     3.478    53.852     0.200
     3.478    53.734     0.200
     3.478    54.035     0.200
     3.614    55.836     0.200
     3.971    61.035     0.200
     4.043    62.836     0.200
     4.043    62.434     0.200
     4.357    65.137     0.200
     4.960    76.836     0.200
     4.960    76.434     0.200
     5.144    76.336     0.200
     5.403    79.637     0.200
     5.403    79.934     0.200
     5.391    81.836     0.200
     5.391    82.035     0.200
     5.601    84.434     0.200
     5.601    83.434     0.200
     5.720    85.914     0.200
     6.784    98.535     0.200
     6.784    98.734     0.200
     7.393   111.234     0.200
     7.393   107.637     0.200
     7.930   113.109     0.200
     8.087   114.875     0.200
     8.606   125.434     0.200
    14.151   197.137     0.200
    14.111   200.742     0.200
    14.111   198.695     0.200
    14.313   200.535     0.200
    18.067   250.336     0.200
    18.067   249.785     0.200
    18.578   259.137     0.200
    18.751   259.434     0.200
     2.039    35.309     0.200
     2.233    37.609     0.200
     2.233    37.508     0.200
     2.226    37.711     0.200
     2.388    40.109     0.200
     2.609    43.008     0.200
     2.956    47.711     0.200
     2.851    46.809     0.200
     3.304    52.602     0.200
     3.626    56.711     0.200
     3.626    55.609     0.200
     3.756    58.508     0.200
     4.353    67.809     0.200
     4.734    73.410     0.200
     5.118    79.410     0.200
     5.270    79.410     0.200
     5.430    81.711     0.200
     5.812    87.043     0.200
     7.034   101.910     0.200
     8.266   118.793     0.200
     2.664    43.102     0.200
     5.075    78.000     0.200
     2.071    34.969     0.200
     2.779    44.273     0.200
     2.787    44.688     0.200
     2.787    44.875     0.200
     3.354    53.969     0.200
     4.289    65.672     0.200
     4.273    67.570     0.200
     4.530    66.969     0.200
     4.740    74.273     0.200
     5.309    79.750     0.200
     8.407   120.602     0.200
    17.394   242.477     0.200
     1.598    28.977     0.200
     1.727    31.680     0.200
     1.820    31.773     0.200
     2.211    37.375     0.200
     2.461    41.078     0.200
     2.644    42.773     0.200
     2.829    46.078     0.200
     2.929    47.242     0.200
     3.396    53.375     0.200
     3.497    54.375     0.200
     3.933    60.773     0.200
     4.151    63.477     0.200
     5.385    81.680     0.200
     8.303   119.750     0.200
    13.672   191.500     0.200
    17.533   244.695     0.200
    18.770   259.078     0.200
     1.734    30.062     0.200
     2.070    34.461     0.200
     2.118    35.363     0.200
     2.391    38.863     0.200
     2.779    44.562     0.200
     2.841    45.062     0.200
     3.027    48.062     0.200
     3.580    55.062     0.200
     5.336    79.562     0.200
     1.859    31.883     0.200
     2.093    35.781     0.200
     2.237    36.781     0.200
     2.275    37.180     0.200
     2.631    42.680     0.200
     2.632    42.086     0.200
     2.769    43.586     0.200
     2.889    45.984     0.200
     3.097    48.680     0.200
     3.281    50.086     0.200
     3.364    51.828     0.200
     4.255    63.484     0.200
     4.321    65.883     0.200
     4.868    74.680     0.200
     5.329    80.680     0.200
     5.436    82.383     0.200
     5.554    83.039     0.200
     7.912   112.406     0.200
    14.096   197.922     0.200
     1.778    31.287     0.200
     1.913    32.688     0.200
     2.209    37.287     0.200
     2.999    47.688     0.200
     4.283    64.488     0.200
     4.916    74.488     0.200
     2.063    34.164     0.200
     2.297    37.465     0.200
     2.341    38.164     0.200
     4.310    63.664     0.200
     4.337    64.867     0.200
     2.255    37.545     0.200
     2.512    41.145     0.200
     2.897    46.443     0.200
     2.988    48.344     0.200
     3.425    54.645     0.200
     4.503    70.344     0.200
     4.992    77.344     0.200
     2.218    36.863     0.200
     2.469    40.562     0.200
     2.636    42.562     0.200
     4.038    64.363     0.200
     4.143    62.863     0.200
     4.480    67.562     0.200
     4.881    75.961     0.200
     1.913    32.160     0.200
     2.272    37.459     0.200
     2.570    41.459     0.200
     2.666    42.760     0.200
     2.921    46.359     0.200
     3.042    47.859     0.200
     3.394    52.242     0.200
     3.394    51.289     0.200
     3.394    53.359     0.200
     3.710    57.160     0.200
     3.970    61.561     0.200
     4.302    64.160     0.200
     4.889    73.160     0.200
     5.242    78.359     0.200
     5.338    80.359     0.200
     5.497    81.029     0.200
     5.497    82.561     0.200
     5.510    81.260     0.200
     6.660    97.859     0.200
     6.851    99.561     0.200
     7.932   112.021     0.200
    18.005   250.234     0.200
    18.005   248.049     0.200
    18.540   258.260     0.200
    18.625   258.307     0.200
     1.752    30.336     0.200
     1.760    30.242     0.200
     1.757    30.141     0.200
     2.122    35.539     0.200
     2.150    35.742     0.200
     2.354    38.836     0.200
     2.740    43.141     0.200
     2.735    43.336     0.200
     2.795    44.742     0.200
     3.298    51.242     0.200
     3.396    52.539     0.200
     3.889    60.438     0.200
     3.889    59.742     0.200
     4.268    65.141     0.200
     4.204    65.539     0.200
     4.558    68.742     0.200
     4.595    69.539     0.200
     4.595    71.242     0.200
     4.859    70.836     0.200
     5.517    82.242     0.200
     5.517    82.141     0.200
     5.574    83.141     0.200
     6.638    95.641     0.200
     8.818   125.141     0.200
    12.884   180.438     0.200
    14.709   206.742     0.200
     1.951    32.797     0.200
     2.191    35.797     0.200
     2.698    42.898     0.200
     2.952    46.398     0.200
     3.003    47.297     0.200
     3.423    53.602     0.200
     3.676    56.203     0.200
     4.323    65.500     0.200
     5.207    77.500     0.200
     5.355    80.500     0.200
     2.280    37.520     0.200
     2.536    40.922     0.200
     2.610    41.820     0.200
     4.314    64.219     0.200
     5.011    77.320     0.200
     2.171    35.602     0.200
     2.307    37.398     0.200
     2.563    40.699     0.200
     3.096    48.398     0.200
     3.285    51.000     0.200
     3.852    59.199     0.200
     4.769    72.199     0.200
     5.210    78.301     0.200
     2.266    36.885     0.200
     3.637    55.684     0.200
     4.127    62.283     0.200
     4.231    64.885     0.200
     6.162    91.084     0.200
    13.516   189.385     0.200
    14.450   203.184     0.200
    18.842   259.184     0.200
     0.965    19.301     0.200
     1.801    30.500     0.200
     2.196    36.402     0.200
     2.451    39.801     0.200
     2.684    43.199     0.200
     2.920    46.699     0.200
     2.926    46.402     0.200
     3.516    55.402     0.200
     4.437    69.000     0.200
     4.924    75.801     0.200
     1.991    33.211     0.200
     2.092    34.711     0.200
     2.333    37.508     0.200
     2.263    37.109     0.200
     2.309    37.211     0.200
     2.497    40.008     0.200
     2.608    41.211     0.200
     2.721    43.414     0.200
     2.793    41.914     0.200
     2.836    44.211     0.200
     3.010    47.508     0.200
     3.163    48.312     0.200
     3.163    48.914     0.200
     3.235    51.609     0.200
     3.558    54.414     0.200
     3.678    56.414     0.200
     3.813    58.109     0.200
     4.289    63.711     0.200
     4.286    64.328     0.200
     4.286    63.969     0.200
     4.286    64.109     0.200
     4.374    65.312     0.200
     4.753    69.711     0.200
     4.849    71.914     0.200
     5.242    78.414     0.200
     5.242    78.109     0.200
     5.779    84.711     0.200
     5.763    85.609     0.200
     5.763    85.711     0.200
     5.990    86.812     0.200
     6.146    88.086     0.200
     6.099    87.961     0.200
     6.099    89.211     0.200
     6.099    89.109     0.200
     6.163    91.109     0.200
     6.262    90.789     0.200
     7.416   105.539     0.200
     7.592   107.664     0.200
    14.453   203.109     0.200
    14.774   207.508     0.200
    18.855   259.711     0.200
    18.855   259.289     0.200
    18.855   260.031     0.200
    18.855   260.609     0.200
     1.993    33.869     0.200
     2.190    35.869     0.200
     2.276    37.170     0.200
     2.916    46.170     0.200
     3.694    56.570     0.200
     4.468    66.170     0.200
     4.846    75.869     0.200
     5.263    79.670     0.200
     2.269    37.844     0.200
     2.516    41.445     0.200
     2.576    41.746     0.200
     2.979    47.645     0.200
     3.313    51.344     0.200
     4.090    62.645     0.200
     4.557    67.844     0.200
     1.288    24.094     0.200
     1.287    23.996     0.200
     1.600    29.594     0.200
     1.718    30.895     0.200
     1.718    32.293     0.200
     1.804    31.293     0.200
     2.193    36.793     0.200
     2.443    40.195     0.200
     2.443    40.094     0.200
     2.657    42.496     0.200
     2.828    45.895     0.200
     2.828    45.395     0.200
     2.909    46.188     0.200
     2.909    46.594     0.200
     3.403    52.395     0.200
     3.403    52.996     0.200
     3.721    57.496     0.200
     3.920    61.195     0.200
     4.167    63.793     0.200
     4.391    68.793     0.200
     4.510    66.793     0.200
     4.846    73.895     0.200
     5.311    81.293     0.200
     5.311    79.996     0.200
     5.392    80.742     0.200
     7.020   101.293     0.200
     8.334   121.602     0.200
    13.641   193.945     0.200
    17.507   243.918     0.200
    18.066   251.395     0.200
    18.151   251.383     0.200
     1.815    31.754     0.200
     1.857    32.354     0.200
     2.217    36.854     0.200
     2.261    37.553     0.200
     2.261    37.754     0.200
     2.173    36.854     0.200
     2.270    38.453     0.200
     2.643    43.354     0.200
     2.643    43.652     0.200
     2.881    46.754     0.200
     2.881    46.152     0.200
     2.876    46.254     0.200
     2.876    46.652     0.200
     3.315    51.146     0.200
     3.315    51.453     0.200
     3.315    52.254     0.200
     3.753    58.053     0.200
     3.797    57.053     0.200
     3.797    57.652     0.200
     3.801    59.652     0.200
     3.801    59.754     0.200
     4.340    66.453     0.200
     4.406    68.152     0.200
     4.406    68.553     0.200
     4.699    72.754     0.200
     4.699    73.254     0.200
     4.869    72.053     0.200
     5.253    78.453     0.200
     5.038    77.553     0.200
     5.350    78.953     0.200
     5.350    79.652     0.200
     5.882    87.254     0.200
     5.882    88.254     0.200
     5.967    89.334     0.200
     6.451    93.402     0.200
     7.105   103.254     0.200
     8.439   119.371     0.200
    13.650   193.350     0.200
    17.742   245.953     0.200
    17.742   245.928     0.200
    18.158   252.553     0.200
    18.244   250.729     0.200
     1.798    31.153     0.200
     2.186    35.753     0.200
     2.434    40.153     0.200
     2.661    43.053     0.200
     2.816    44.853     0.200
     2.898    46.596     0.200
     2.898    46.453     0.200
     3.399    53.253     0.200
     3.457    54.153     0.200
     3.917    60.953     0.200
     4.173    63.653     0.200
     4.374    69.053     0.200
     4.543    67.553     0.200
     4.823    74.853     0.200
     5.411    81.313     0.200
     7.008    99.946     0.200
     8.365   118.226     0.200
    13.612   193.645     0.200
     2.079    34.383     0.200
     2.106    35.281     0.200
     2.383    39.082     0.200
     4.510    66.182     0.200
     4.936    73.982     0.200
     5.336    80.781     0.200
     1.734    30.195     0.200
     1.818    31.195     0.200
     1.856    31.992     0.200
     1.879    32.492     0.200
     2.065    34.094     0.200
     2.120    35.594     0.200
     2.335    38.695     0.200
     2.335    38.891     0.200
     2.300    38.094     0.200
     2.397    39.195     0.200
     2.839    45.094     0.200
     2.839    45.195     0.200
     2.786    44.789     0.200
     3.034    47.992     0.200
     3.406    53.492     0.200
     3.574    55.094     0.200
     3.495    54.375     0.200
     3.495    54.148     0.200
     4.036    61.789     0.200
     4.514    66.891     0.200
     4.512    69.094     0.200
     4.573    69.289     0.200
     4.948    75.391     0.200
     4.948    76.094     0.200
     5.096    75.289     0.200
     5.311    79.789     0.200
     5.347    80.891     0.200
     5.347    81.195     0.200
     5.736    84.805     0.200
     5.736    85.766     0.200
     5.736    86.289     0.200
     5.736    85.391     0.200
     5.848    87.133     0.200
     5.848    86.789     0.200
     6.809    98.891     0.200
     8.207   116.664     0.200
    14.086   197.094     0.200
    14.022   198.594     0.200
    14.022   199.695     0.200
    14.473   202.609     0.200
    15.105   211.984     0.200
    15.105   214.094     0.200
    16.773   236.195     0.200
    18.036   250.094     0.200
    18.036   248.664     0.200
    18.036   249.992     0.200
    18.212   252.516     0.200
    18.591   257.289     0.200
     2.401    39.961     0.200
     2.451    40.762     0.200
     2.700    44.262     0.200
     3.720    58.461     0.200
     3.909    61.062     0.200
     2.602    43.102     0.200
     2.502    41.102     0.200
     2.608    44.102     0.200
     2.752    44.508     0.200
     3.130    49.508     0.200
     3.219    51.070     0.200
     3.860    59.703     0.200
     5.586    83.805     0.200
     6.794    98.102     0.200
     8.132   114.938     0.200
    13.879   196.328     0.200
     1.998    32.988     0.200
     2.502    39.988     0.200
     2.649    42.389     0.200
     2.793    44.689     0.200
     3.125    48.531     0.200
     3.301    51.389     0.200
     3.447    52.988     0.200
     3.677    56.289     0.200
     3.987    60.488     0.200
     5.392    79.766     0.200
     6.984   100.775     0.200
     8.063   113.674     0.200
     1.820    30.992     0.200
     2.211    35.492     0.200
     2.211    36.492     0.200
     2.462    39.695     0.200
     2.645    42.492     0.200
     2.930    46.762     0.200
     3.399    53.094     0.200
     3.399    52.492     0.200
     3.499    53.992     0.200
     3.683    56.492     0.200
     4.151    62.395     0.200
     4.473    66.492     0.200
     5.379    80.613     0.200
     7.027   102.070     0.200
     1.669    27.992     0.200
     2.037    33.492     0.200
     2.218    35.789     0.200
     2.510    40.691     0.200
     3.036    47.090     0.200
     1.713    29.311     0.200
     2.045    34.311     0.200
     2.263    36.511     0.200
     2.382    38.611     0.200
     2.580    41.111     0.200
     2.820    44.311     0.200
     2.968    46.411     0.200
     3.791    57.411     0.200
     6.575    94.636     0.200
    17.758   245.111     0.200
     2.205    36.953     0.200
     2.457    40.648     0.200
     2.654    42.953     0.200
     2.851    46.555     0.200
     2.926    47.148     0.200
     3.413    53.750     0.200
     3.499    56.055     0.200
     3.922    61.750     0.200
     5.360    81.969     0.200
     7.045   101.875     0.200
     8.282   120.273     0.200
     2.247    36.609     0.200
     2.620    41.906     0.200
     2.871    44.812     0.200
     2.199    37.578     0.200
     2.452    40.977     0.200
     2.662    43.277     0.200
     2.863    46.777     0.200
     2.922    47.277     0.200
     3.497    55.676     0.200
     4.165    64.578     0.200
     4.442    67.477     0.200
     5.347    81.258     0.200
     7.056   101.852     0.200
     1.337    25.086     0.200
     1.925    33.086     0.200
     2.258    36.684     0.200
     2.602    41.984     0.200
     2.852    44.785     0.200
     3.760    58.184     0.200
     1.894    33.359     0.200
     2.289    38.258     0.200
     2.545    41.957     0.200
     2.602    42.258     0.200
     2.871    46.457     0.200
     3.021    48.355     0.200
     3.394    53.660     0.200
     3.614    57.359     0.200
     4.309    64.957     0.200
     5.320    80.699     0.200
     7.063   103.855     0.200
    17.665   246.902     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.552    45.625     0.200
     3.014    53.524     0.200
     3.014    57.424     0.200
     3.661    66.024     0.200
     4.742    84.225     0.200
     4.862    87.625     0.200
     5.041    92.325     0.200
     3.515    63.621     0.200
     3.520    65.721     0.200
     2.095    37.164     0.200
     2.728    49.062     0.200
     2.752    48.965     0.200
     3.227    57.664     0.200
     3.876    69.664     0.200
     3.097    54.684     0.200
     3.142    55.984     0.200
     3.918    69.086     0.200
     4.201    76.484     0.200
     4.570    80.785     0.200
     4.702    83.484     0.200
     2.657    48.273     0.200
     5.073    90.672     0.200
     2.642    47.020     0.200
     2.976    54.121     0.200
     3.254    58.723     0.200
     4.084    74.621     0.200
     4.723    83.820     0.200
     2.723    49.148     0.200
     2.894    51.547     0.200
     3.954    72.648     0.200
     4.166    73.949     0.200
     4.332    76.250     0.200
     4.713    84.348     0.200
     2.299    42.160     0.200
     2.675    48.461     0.200
     2.934    52.559     0.200
     3.456    62.961     0.200
     3.876    70.461     0.200
     4.126    73.758     0.200
     4.365    77.461     0.200
     4.733    84.059     0.200
     4.769    83.961     0.200
     5.763   102.758     0.200
     2.639    47.289     0.200
     2.895    51.590     0.200
     3.333    59.090     0.200
     3.419    61.590     0.200
     3.893    69.090     0.200
     3.959    71.090     0.200
     4.166    74.590     0.200
     4.329    77.789     0.200
     2.266    40.777     0.200
     2.299    41.977     0.200
     2.476    44.176     0.200
     2.487    45.777     0.200
     2.808    51.977     0.200
     2.808    52.777     0.200
     3.391    61.977     0.200
     3.670    66.977     0.200
     3.670    66.875     0.200
     4.117    74.977     0.200
     4.450    79.977     0.200
     4.848    86.977     0.200
     5.186    93.676     0.200
     5.975   105.977     0.200
     5.975   107.176     0.200
     3.286    59.264     0.200
     3.519    62.564     0.200
     3.767    68.764     0.200
     4.019    73.464     0.200
     4.084    73.464     0.200
     4.624    81.964     0.200
     5.759   101.764     0.200
     6.172   110.564     0.200
     2.570    46.518     0.200
     2.570    46.812     0.200
     2.570    47.013     0.200
     2.701    49.913     0.200
     3.309    60.513     0.200
     3.309    58.812     0.200
     3.309    60.013     0.200
     3.874    70.513     0.200
     3.874    70.812     0.200
     4.156    75.513     0.200
     4.298    78.013     0.200
     4.393    80.112     0.200
     4.393    79.513     0.200
     4.791    87.521     0.200
     4.791    86.713     0.200
     4.791    88.413     0.200
     5.229    95.515     0.200
     5.543   100.516     0.200
     2.778    50.506     0.200
     3.038    54.205     0.200
     3.381    60.105     0.200
     3.717    66.307     0.200
     3.953    70.506     0.200
     4.330    78.705     0.200
     2.304    42.023     0.200
     2.377    43.523     0.200
     2.537    45.625     0.200
     3.256    58.625     0.200
     3.765    68.820     0.200
     4.047    73.523     0.200
     4.637    82.320     0.200
     2.637    47.574     0.200
     2.637    47.676     0.200
     2.653    48.473     0.200
     3.138    56.473     0.200
     3.138    56.273     0.200
     3.257    59.375     0.200
     3.257    59.676     0.200
     3.418    61.875     0.200
     3.418    62.176     0.200
     3.508    65.375     0.200
     3.837    69.875     0.200
     4.191    77.074     0.200
     4.219    77.176     0.200
     4.237    78.473     0.200
     4.360    78.574     0.200
     4.360    78.176     0.200
     4.747    85.473     0.200
     4.747    87.676     0.200
     5.197    92.574     0.200
     5.367    97.875     0.200
     5.373    99.074     0.200
     5.610   100.273     0.200
     5.610    99.473     0.200
     6.789   124.473     0.200
     6.992   125.074     0.200
     3.063    55.580     0.200
     3.458    61.980     0.200
     4.018    70.880     0.200
     2.573    46.906     0.200
     2.737    49.508     0.200
     2.737    49.109     0.200
     2.726    50.609     0.200
     3.193    57.109     0.200
     3.262    59.508     0.200
     3.310    59.711     0.200
     3.557    64.305     0.200
     3.827    68.406     0.200
     3.908    71.211     0.200
     4.181    76.406     0.200
     4.248    76.508     0.200
     4.248    77.008     0.200
     5.310    96.109     0.200
     5.362    97.211     0.200
     6.909   124.008     0.200
     2.089    38.518     0.200
     2.717    49.717     0.200
     2.880    52.217     0.200
     3.421    60.917     0.200
     3.495    63.217     0.200
     3.643    64.817     0.200
     4.451    82.217     0.200
     4.576    81.317     0.200
     2.142    38.562     0.200
     2.368    43.062     0.200
     2.503    44.961     0.200
     2.644    47.863     0.200
     3.155    56.562     0.200
     3.225    59.160     0.200
     3.225    58.160     0.200
     3.454    63.160     0.200
     3.454    61.762     0.200
     3.795    68.363     0.200
     4.212    75.863     0.200
     4.384    79.160     0.200
     4.384    78.363     0.200
     4.713    84.762     0.200
     5.392    96.363     0.200
     5.627   100.461     0.200
     6.817   124.562     0.200
     7.027   124.863     0.200
     2.511    45.759     0.200
     2.718    49.359     0.200
     2.978    53.659     0.200
     3.296    59.159     0.200
     3.442    62.759     0.200
     3.654    65.159     0.200
     4.012    72.259     0.200
     4.337    78.159     0.200
     4.929    89.958     0.200
     2.218    40.051     0.200
     2.569    45.949     0.200
     2.574    47.148     0.200
     2.574    46.449     0.200
     2.683    47.949     0.200
     2.683    48.449     0.200
     3.436    62.949     0.200
     3.447    62.551     0.200
     3.447    62.051     0.200
     3.791    68.449     0.200
     3.856    69.551     0.200
     3.856    68.449     0.200
     4.138    73.949     0.200
     4.165    75.250     0.200
     4.287    76.852     0.200
     4.411    79.750     0.200
     4.411    79.449     0.200
     4.773    84.449     0.200
     5.209    95.551     0.200
     5.549    98.949     0.200
     5.549    99.352     0.200
     6.744   120.648     0.200
     2.302    41.419     0.200
     2.500    44.719     0.200
     2.997    53.318     0.200
     3.375    60.119     0.200
     3.934    70.818     0.200
     4.418    78.219     0.200
     5.277    93.919     0.200
     2.366    42.023     0.200
     3.102    55.426     0.200
     4.285    76.523     0.200
     2.294    41.316     0.200
     4.376    78.215     0.200
     2.313    41.564     0.200
     2.695    47.965     0.200
     3.274    59.465     0.200
     3.387    60.265     0.200
     3.423    60.765     0.200
     3.999    70.965     0.200
     4.292    76.465     0.200
     4.292    76.865     0.200
     4.918    86.965     0.200
     6.821   121.165     0.200
     3.059    54.021     0.200
     3.715    66.723     0.200
     3.124    57.156     0.200
     3.290    58.957     0.200
     4.158    74.758     0.200
     6.217   111.457     0.200
     2.241    40.367     0.200
     2.606    46.770     0.200
     2.723    49.168     0.200
     2.723    48.469     0.200
     3.329    59.770     0.200
     3.329    59.668     0.200
     3.384    61.566     0.200
     3.435    61.469     0.200
     3.762    67.770     0.200
     3.898    71.270     0.200
     3.898    68.969     0.200
     4.115    73.469     0.200
     4.313    78.367     0.200
     4.313    78.168     0.200
     4.368    77.770     0.200
     4.368    78.969     0.200
     4.815    86.367     0.200
     4.815    85.367     0.200
     5.291    94.270     0.200
     5.291    96.867     0.200
     5.536    98.668     0.200
     6.926   122.469     0.200
     2.313    42.143     0.200
     2.370    44.143     0.200
     2.622    46.443     0.200
     3.527    62.643     0.200
     3.527    62.743     0.200
     3.822    68.043     0.200
     4.056    72.543     0.200
     4.065    73.843     0.200
     4.437    78.143     0.200
     4.712    84.543     0.200
     2.099    38.129     0.200
     2.354    42.429     0.200
     2.754    49.529     0.200
     2.863    52.029     0.200
     3.434    62.829     0.200
     3.462    61.829     0.200
     4.002    71.629     0.200
     5.127    93.329     0.200
     6.844   121.429     0.200
     2.574    45.836     0.200
     3.399    60.938     0.200
     4.136    73.336     0.200
     4.136    74.531     0.200
     4.576    81.938     0.200
     4.724    85.234     0.200
     4.987    88.531     0.200
     5.058    89.633     0.200
     5.643   100.336     0.200
     5.969   106.836     0.200
     6.096   108.133     0.200
     2.034    36.910     0.200
     2.245    40.207     0.200
     2.245    40.309     0.200
     2.855    51.008     0.200
     2.959    52.809     0.200
     3.139    55.809     0.200
     3.139    57.109     0.200
     3.405    61.309     0.200
     3.538    65.207     0.200
     3.538    63.109     0.200
     4.002    71.309     0.200
     4.002    71.609     0.200
     4.677    83.207     0.200
     4.677    84.109     0.200
     4.942    87.809     0.200
     5.045    89.508     0.200
     5.499    98.910     0.200
     6.079   107.910     0.200
     6.242   110.707     0.200
     2.340    41.922     0.200
     2.443    43.723     0.200
     2.677    48.223     0.200
     2.869    51.320     0.200
     4.305    78.723     0.200
     4.408    79.922     0.200
     4.408    79.723     0.200
     4.840    85.723     0.200
     5.798   103.723     0.200
     5.935   105.621     0.200
     5.935   105.020     0.200
     2.314    41.703     0.200
     2.449    44.703     0.200
     2.832    50.904     0.200
     3.043    55.904     0.200
     3.043    54.504     0.200
     3.355    60.004     0.200
     3.526    64.104     0.200
     3.629    64.703     0.200
     3.629    65.104     0.200
     4.014    73.004     0.200
     4.060    74.305     0.200
     4.340    77.203     0.200
     5.590    99.504     0.200
     2.348    41.867     0.200
     4.024    70.867     0.200
     4.101    72.469     0.200
     2.121    38.914     0.200
     2.332    42.312     0.200
     2.840    50.711     0.200
     2.775    50.016     0.200
     3.212    58.711     0.200
     3.431    61.109     0.200
     3.483    62.609     0.200
     3.483    62.312     0.200
     3.917    70.109     0.200
     4.536    82.211     0.200
     4.536    81.016     0.200
     4.931    89.516     0.200
     4.931    89.812     0.200
     5.106    92.516     0.200
     5.106    93.016     0.200
     5.313    94.516     0.200
     5.327    96.312     0.200
     2.127    38.500     0.200
     2.392    43.099     0.200
     2.506    45.399     0.200
     2.831    51.599     0.200
     2.879    52.299     0.200
     2.993    54.299     0.200
     2.993    55.299     0.200
     3.196    57.599     0.200
     3.213    57.699     0.200
     3.602    65.500     0.200
     3.602    64.899     0.200
     3.853    71.199     0.200
     3.853    71.299     0.200
     4.166    74.399     0.200
     4.345    77.099     0.200
     4.345    77.199     0.200
     4.581    83.299     0.200
     4.581    83.699     0.200
     5.082    90.099     0.200
     5.082    90.799     0.200
     6.663   119.099     0.200
     2.500    44.977     0.200
     2.833    50.578     0.200
     2.871    51.477     0.200
     2.984    53.477     0.200
     3.198    57.777     0.200
     3.499    62.578     0.200
     3.593    64.277     0.200
     4.155    75.078     0.200
     4.356    77.578     0.200
     4.575    83.777     0.200
     5.029    91.777     0.200
     5.029    90.078     0.200
     5.071    89.977     0.200
     5.494    99.578     0.200
     6.675   118.977     0.200
     2.011    36.000     0.200
     2.331    41.602     0.200
     2.517    44.699     0.200
     2.628    48.301     0.200
     2.660    48.402     0.200
     2.660    47.699     0.200
     2.739    50.199     0.200
     2.817    50.602     0.200
     3.218    59.402     0.200
     3.700    65.500     0.200
     4.286    76.500     0.200
     4.286    76.301     0.200
     4.307    76.699     0.200
     4.871    87.301     0.200
     5.262    93.801     0.200
     5.785   102.301     0.200
     5.968   105.801     0.200
     5.968   104.902     0.200
     2.132    39.078     0.200
     2.316    42.180     0.200
     2.316    42.078     0.200
     2.447    43.977     0.200
     2.832    50.680     0.200
     2.832    50.477     0.200
     2.774    49.477     0.200
     2.774    51.180     0.200
     2.851    51.383     0.200
     2.851    51.078     0.200
     3.205    58.383     0.200
     3.479    62.281     0.200
     3.586    63.781     0.200
     4.012    72.578     0.200
     4.505    82.883     0.200
     4.564    81.383     0.200
     4.564    82.680     0.200
     4.564    81.680     0.200
     4.922    88.578     0.200
     5.106    91.477     0.200
     5.305    93.977     0.200
     6.541   116.781     0.200
     6.541   116.680     0.200
     6.841   121.977     0.200
     2.474    44.883     0.200
     2.687    48.281     0.200
     2.792    50.082     0.200
     2.792    50.582     0.200
     2.967    52.781     0.200
     3.337    60.184     0.200
     3.382    60.684     0.200
     3.404    61.684     0.200
     3.677    65.781     0.200
     3.677    65.484     0.200
     3.962    72.184     0.200
     3.962    72.383     0.200
     4.422    79.781     0.200
     4.422    78.582     0.200
     4.401    79.484     0.200
     4.401    79.281     0.200
     4.877    86.184     0.200
     5.204    94.883     0.200
     5.204    93.281     0.200
     5.439    98.484     0.200
     6.630   120.484     0.200
     2.273    41.129     0.200
     2.647    47.328     0.200
     2.770    49.930     0.200
     3.373    60.328     0.200
     3.414    63.027     0.200
     3.726    66.527     0.200
     3.946    70.027     0.200
     3.946    70.828     0.200
     4.328    76.930     0.200
     4.347    78.328     0.200
     4.864    86.828     0.200
     5.310    95.930     0.200
     6.876   122.629     0.200
     2.327    42.012     0.200
     2.818    51.910     0.200
     2.993    53.109     0.200
     3.310    58.609     0.200
     3.423    60.809     0.200
     3.993    73.012     0.200
     2.444    44.328     0.200
     3.033    54.328     0.200
     3.384    60.031     0.200
     3.510    63.031     0.200
     3.510    62.629     0.200
     3.625    65.129     0.200
     4.079    73.531     0.200
     4.306    76.531     0.200
     4.546    81.031     0.200
     5.856   103.129     0.200
     7.192   127.230     0.200
     2.565    45.777     0.200
     2.649    47.578     0.200
     2.649    47.180     0.200
     2.771    49.879     0.200
     3.043    54.277     0.200
     3.332    60.777     0.200
     3.374    60.777     0.200
     3.946    70.480     0.200
     3.946    71.180     0.200
     4.082    74.480     0.200
     4.333    78.180     0.200
     4.350    77.578     0.200
     5.309    97.379     0.200
     5.512    97.480     0.200
     2.289    41.812     0.200
     2.690    48.414     0.200
     3.432    62.211     0.200
     3.735    67.711     0.200
     4.079    72.609     0.200
     4.039    72.109     0.200
     4.039    73.711     0.200
     4.347    79.414     0.200
     4.961    89.516     0.200
     5.273    95.516     0.200
     5.340    95.312     0.200
     2.299    41.375     0.200
     2.441    44.273     0.200
     2.864    50.977     0.200
     3.031    54.570     0.200
     3.383    60.477     0.200
     3.994    72.977     0.200
     4.079    73.570     0.200
     4.312    77.477     0.200
     4.543    81.375     0.200
     5.028    90.273     0.200
     5.610   100.773     0.200
     2.300    41.104     0.200
     2.300    41.304     0.200
     2.608    48.003     0.200
     3.025    55.003     0.200
     3.239    57.804     0.200
     3.239    57.703     0.200
     3.402    62.604     0.200
     3.645    64.703     0.200
     3.645    67.003     0.200
     3.766    67.203     0.200
     5.337    94.304     0.200
     2.564    46.281     0.200
     2.564    46.086     0.200
     2.644    48.086     0.200
     2.765    50.180     0.200
     2.765    49.586     0.200
     3.340    59.883     0.200
     3.340    60.086     0.200
     3.412    61.586     0.200
     3.412    60.781     0.200
     3.369    61.180     0.200
     3.369    61.680     0.200
     3.369    61.281     0.200
     3.369    60.680     0.200
     3.727    67.281     0.200
     3.940    72.484     0.200
     3.940    70.984     0.200
     4.340    77.680     0.200
     4.347    77.984     0.200
     4.347    78.484     0.200
     4.858    86.484     0.200
     4.858    86.586     0.200
     5.257    93.984     0.200
     5.257    94.383     0.200
     5.302    95.781     0.200
     5.513    98.586     0.200
     5.513    98.383     0.200
     5.510    99.883     0.200
     6.882   122.586     0.200
     9.909   178.281     0.200
    10.057   182.086     0.200
     2.575    46.227     0.200
     2.640    47.422     0.200
     2.763    50.625     0.200
     3.054    54.422     0.200
     3.365    60.125     0.200
     3.365    60.023     0.200
     3.421    61.023     0.200
     3.939    70.820     0.200
     4.329    77.422     0.200
     4.340    78.023     0.200
     4.856    88.625     0.200
     2.566    46.078     0.200
     2.566    45.977     0.200
     2.637    47.281     0.200
     2.758    49.883     0.200
     2.758    49.781     0.200
     3.347    60.977     0.200
     3.362    60.477     0.200
     3.734    66.680     0.200
     4.344    77.680     0.200
     2.572    46.266     0.200
     2.572    45.969     0.200
     2.637    48.164     0.200
     3.341    59.562     0.200
     3.362    60.367     0.200
     3.735    67.367     0.200
     3.934    70.969     0.200
     3.934    70.867     0.200
     4.336    77.562     0.200
     4.336    77.766     0.200
     4.339    77.562     0.200
     4.339    78.062     0.200
     5.522    97.766     0.200
     5.522    98.367     0.200
     6.888   122.766     0.200
     2.564    46.121     0.200
     2.564    46.320     0.200
     2.654    48.719     0.200
     2.776    50.219     0.200
     2.776    49.922     0.200
     3.040    54.219     0.200
     3.327    59.520     0.200
     3.327    60.020     0.200
     3.407    60.719     0.200
     3.407    60.922     0.200
     3.379    60.621     0.200
     3.379    61.020     0.200
     3.719    66.020     0.200
     3.951    72.020     0.200
     4.078    74.922     0.200
     4.354    78.020     0.200
     4.354    78.219     0.200
     4.354    79.020     0.200
     4.869    88.719     0.200
     4.869    89.020     0.200
     5.314    95.422     0.200
     5.509    98.320     0.200
     5.509    98.719     0.200
     5.624   101.500     0.200
     6.670   121.520     0.200
     6.871   122.719     0.200
     6.871   123.820     0.200
     2.560    45.982     0.200
     2.560    45.782     0.200
     2.660    48.682     0.200
     3.035    54.082     0.200
     3.385    60.382     0.200
     3.385    61.282     0.200
     3.713    66.182     0.200
     3.958    71.382     0.200
     3.958    71.982     0.200
     4.072    76.782     0.200
     4.360    80.482     0.200
     4.876    86.982     0.200
     2.634    47.169     0.200
     2.756    49.569     0.200
     3.056    54.469     0.200
     3.359    60.569     0.200
     3.738    66.369     0.200
     3.738    67.369     0.200
     3.932    70.969     0.200
     3.932    70.169     0.200
     4.335    77.669     0.200
     4.850    87.669     0.200
     5.269    95.069     0.200
     5.269    94.469     0.200
     2.642    47.320     0.200
     2.765    50.219     0.200
     3.051    54.520     0.200
     3.368    60.020     0.200
     3.368    60.121     0.200
     3.731    66.520     0.200
     3.941    71.621     0.200
     3.941    70.320     0.200
     4.329    77.219     0.200
     4.859    87.719     0.200
     5.261    96.219     0.200
     5.261    94.320     0.200
     5.305    94.820     0.200
     5.500   100.320     0.200
     6.681   119.520     0.200
     3.748    66.895     0.200
     4.332    77.293     0.200
     4.326    78.293     0.200
     2.571    45.912     0.200
     2.638    47.613     0.200
     4.337    77.312     0.200
     2.538    45.594     0.200
     3.334    59.395     0.200
     2.555    46.284     0.200
     2.555    45.984     0.200
     2.654    47.584     0.200
     3.336    60.984     0.200
     3.379    60.684     0.200
     3.949    71.984     0.200
     3.949    70.484     0.200
     4.342    78.084     0.200
     4.357    79.184     0.200
     4.867    87.684     0.200
     5.247    93.284     0.200
     6.874   122.284     0.200
     2.046    36.633     0.200
     2.901    52.133     0.200
     4.577    83.133     0.200
     4.577    82.328     0.200
     5.054    91.031     0.200
     5.870   105.328     0.200
     5.971   109.133     0.200
     2.147    38.426     0.200
     2.616    46.926     0.200
     3.062    54.824     0.200
     3.062    54.426     0.200
     3.013    53.324     0.200
     3.013    53.426     0.200
     3.370    62.125     0.200
     3.594    64.324     0.200
     3.594    63.926     0.200
     3.561    63.023     0.200
     4.110    72.824     0.200
     4.160    75.625     0.200
     4.160    74.023     0.200
     4.487    81.125     0.200
     5.081    90.426     0.200
     5.598   100.445     0.200
     6.535   117.824     0.200
     2.569    46.102     0.200
     2.637    47.301     0.200
     3.362    60.602     0.200
     3.418    62.102     0.200
     3.735    67.402     0.200
     3.933    70.703     0.200
     4.092    73.801     0.200
     4.341    77.703     0.200
     4.339    77.402     0.200
     5.265    94.500     0.200
     5.505    98.602     0.200
     6.889   122.602     0.200
     2.074    37.694     0.200
     2.710    48.594     0.200
     2.790    50.594     0.200
     3.416    61.694     0.200
     3.416    62.294     0.200
     3.483    62.294     0.200
     3.650    65.594     0.200
     3.650    66.194     0.200
     4.442    80.894     0.200
     4.557    81.294     0.200
     4.863    89.094     0.200
     4.863    86.594     0.200
     5.259    93.894     0.200
     2.734    48.617     0.200
     3.306    59.816     0.200
     3.306    59.414     0.200
     3.786    67.516     0.200
     3.786    67.715     0.200
     3.880    69.117     0.200
     4.266    76.516     0.200
     4.266    76.715     0.200
     4.214    74.117     0.200
     4.614    84.414     0.200
     4.820    87.215     0.200
     5.545   100.375     0.200
     5.772   104.617     0.200
     5.872   104.414     0.200
     7.218   131.117     0.200
     7.218   130.715     0.200
     2.263    40.769     0.200
     2.692    48.269     0.200
     4.657    83.169     0.200
     2.565    46.055     0.200
     2.773    51.457     0.200
     3.330    59.457     0.200
     3.330    61.656     0.200
     3.376    60.156     0.200
     3.376    60.855     0.200
     3.409    63.156     0.200
     3.721    66.457     0.200
     4.332    78.156     0.200
     4.352    78.555     0.200
     5.252    93.656     0.200
     5.511    98.555     0.200
     6.873   122.156     0.200
     2.573    46.484     0.200
     2.646    47.891     0.200
     3.365    59.588     0.200
     2.182    39.223     0.200
     2.286    41.924     0.200
     2.854    50.723     0.200
     2.939    53.123     0.200
     3.506    62.223     0.200
     3.563    63.924     0.200
     4.101    73.623     0.200
     4.519    80.123     0.200
     4.579    83.324     0.200
     5.028    91.123     0.200
     6.748   118.924     0.200
     2.566    46.180     0.200
     2.641    47.180     0.200
     2.762    49.586     0.200
     3.342    60.883     0.200
     3.342    62.086     0.200
     3.366    60.781     0.200
     3.366    59.883     0.200
     3.730    66.281     0.200
     3.730    66.883     0.200
     3.937    72.086     0.200
     4.088    74.180     0.200
     4.341    77.586     0.200
     4.343    77.484     0.200
     4.343    77.781     0.200
     5.299    95.984     0.200
     5.516    97.484     0.200
     5.516    97.883     0.200
     5.507    99.383     0.200
     6.682   122.180     0.200
     6.886   122.586     0.200
     2.571    46.273     0.200
     2.571    45.977     0.200
     2.638    47.273     0.200
     2.760    49.477     0.200
     2.760    49.375     0.200
     3.341    59.375     0.200
     3.363    60.172     0.200
     3.419    61.875     0.200
     3.734    66.977     0.200
     3.935    70.977     0.200
     4.091    73.773     0.200
     4.091    75.570     0.200
     4.337    77.477     0.200
     4.337    76.875     0.200
     4.340    77.672     0.200
     4.340    77.773     0.200
     4.853    88.773     0.200
     4.853    86.375     0.200
     5.298    95.375     0.200
     5.298    94.070     0.200
     5.502    98.773     0.200
     5.520    97.477     0.200
     5.520    98.273     0.200
     6.887   122.273     0.200
     8.128   146.375     0.200
     2.313    41.344     0.200
     2.539    46.441     0.200
     2.656    47.742     0.200
     2.844    50.641     0.200
     3.543    63.543     0.200
     4.267    75.742     0.200
     4.267    76.043     0.200
     4.336    77.441     0.200
     4.740    83.742     0.200
     4.740    86.242     0.200
     4.825    85.941     0.200
     5.232    93.641     0.200
     5.232    93.742     0.200
     5.738   102.941     0.200
     5.738   101.641     0.200
     5.788   103.844     0.200
     6.020   106.141     0.200
     6.020   106.441     0.200
     6.120   109.652     0.200
     2.635    47.320     0.200
     2.756    49.625     0.200
     3.346    60.820     0.200
     3.360    60.523     0.200
     3.931    70.523     0.200
     3.931    70.820     0.200
     4.094    74.023     0.200
     4.340    77.422     0.200
     4.337    77.719     0.200
     5.267    94.320     0.200
     5.267    93.523     0.200
     5.294    94.922     0.200
     5.503    99.125     0.200
     2.564    46.461     0.200
     2.564    45.961     0.200
     2.640    47.660     0.200
     3.045    54.258     0.200
     3.345    60.859     0.200
     3.365    60.461     0.200
     3.413    62.758     0.200
     3.730    67.059     0.200
     3.936    71.059     0.200
     4.087    72.961     0.200
     4.344    77.859     0.200
     4.344    78.961     0.200
     4.343    78.160     0.200
     4.853    85.758     0.200
     4.853    86.160     0.200
     5.260    94.461     0.200
     5.297    96.160     0.200
     5.515    99.160     0.200
     5.510   100.160     0.200
     2.497    45.273     0.200
     2.497    45.074     0.200
     2.671    47.773     0.200
     2.779    49.574     0.200
     2.988    53.672     0.200
     3.358    60.375     0.200
     3.358    60.574     0.200
     3.379    62.172     0.200
     3.390    60.273     0.200
     3.950    71.172     0.200
     3.950    71.375     0.200
     4.043    72.375     0.200
     4.383    78.672     0.200
     4.383    78.773     0.200
     4.407    78.574     0.200
     4.407    78.375     0.200
     4.866    87.375     0.200
     5.221    92.172     0.200
     5.294    95.473     0.200
     5.294    95.773     0.200
     5.460    96.773     0.200
     6.647   118.273     0.200
     6.647   118.773     0.200
     4.399    78.773     0.200
     2.497    44.838     0.200
     2.663    48.638     0.200
     2.770    50.338     0.200
     2.992    53.438     0.200
     3.941    70.338     0.200
     4.376    79.838     0.200
     4.416    78.338     0.200
     4.416    80.138     0.200
     4.856    87.738     0.200
     5.228    94.038     0.200
     5.284    96.238     0.200
     5.579   100.538     0.200
     2.506    45.317     0.200
     2.669    47.817     0.200
     2.995    54.117     0.200
     3.371    62.317     0.200
     3.371    61.117     0.200
     3.365    61.617     0.200
     3.365    61.417     0.200
     3.389    61.017     0.200
     3.389    61.117     0.200
     3.951    70.817     0.200
     3.951    71.117     0.200
     4.047    71.917     0.200
     4.396    78.617     0.200
     4.396    80.117     0.200
     4.379    78.717     0.200
     4.379    79.417     0.200
     4.867    89.417     0.200
     4.867    86.717     0.200
     5.225    94.017     0.200
     5.298    96.117     0.200
     5.466    97.517     0.200
     5.466    97.017     0.200
     5.681   102.417     0.200
     6.649   122.717     0.200
     6.649   119.417     0.200
     2.490    44.691     0.200
     2.678    48.992     0.200
     2.785    49.691     0.200
     3.377    60.590     0.200
     3.397    61.191     0.200
     3.957    70.289     0.200
     4.035    72.992     0.200
     4.035    74.492     0.200
     4.390    78.590     0.200
     4.409    78.492     0.200
     4.409    78.391     0.200
     5.214    92.191     0.200
     5.214    93.289     0.200
     5.300    95.789     0.200
     5.300    95.391     0.200
     2.500    45.121     0.200
     2.671    47.921     0.200
     2.780    50.921     0.200
     3.360    60.421     0.200
     3.391    60.321     0.200
     3.391    60.521     0.200
     3.952    71.721     0.200
     3.952    70.421     0.200
     3.952    72.321     0.200
     4.383    79.021     0.200
     4.402    78.221     0.200
     5.221    92.421     0.200
     5.221    93.721     0.200
     5.297    94.521     0.200
     5.575   100.621     0.200
     2.675    48.279     0.200
     3.395    61.379     0.200
     3.690    66.479     0.200
     4.401    78.680     0.200
     4.386    78.479     0.200
     4.872    87.379     0.200
     5.218    94.180     0.200
     5.301    95.680     0.200
     5.458    98.078     0.200
     5.577   100.779     0.200
     6.872   122.779     0.200
     2.567    45.855     0.200
     3.410    62.652     0.200
     3.379    60.152     0.200
     3.720    66.055     0.200
     3.952    71.355     0.200
     3.952    71.152     0.200
     4.327    77.152     0.200
     4.327    76.855     0.200
     4.353    78.652     0.200
     4.870    88.754     0.200
     4.870    86.152     0.200
     5.251    93.254     0.200
     6.671   121.355     0.200
     6.870   122.055     0.200
     2.559    46.582     0.200
     2.559    45.982     0.200
     2.667    47.682     0.200
     3.277    59.982     0.200
     3.454    62.783     0.200
     3.456    62.383     0.200
     3.839    69.582     0.200
     3.839    68.383     0.200
     4.150    75.182     0.200
     4.273    77.082     0.200
     4.273    76.082     0.200
     4.424    79.783     0.200
     4.424    78.482     0.200
     5.190    94.082     0.200
     5.331    94.283     0.200
     5.511    98.883     0.200
     5.558    99.883     0.200
     5.558    99.682     0.200
     6.758   120.883     0.200
     2.552    45.727     0.200
     2.552    46.727     0.200
     2.653    47.328     0.200
     2.653    47.727     0.200
     2.772    50.531     0.200
     3.032    54.031     0.200
     3.342    61.125     0.200
     3.400    61.930     0.200
     3.377    60.430     0.200
     3.718    66.625     0.200
     3.718    66.727     0.200
     4.074    74.125     0.200
     3.946    70.828     0.200
     4.348    77.727     0.200
     4.348    78.125     0.200
     4.356    79.828     0.200
     4.356    80.031     0.200
     4.864    88.328     0.200
     5.305    96.531     0.200
     5.502    98.328     0.200
     5.502    97.227     0.200
     5.521   100.227     0.200
     6.877   123.031     0.200
     2.645    47.406     0.200
     2.764    49.508     0.200
     3.348    59.605     0.200
     3.348    61.008     0.200
     3.406    62.105     0.200
     3.369    60.453     0.200
     3.369    60.805     0.200
     3.369    60.906     0.200
     3.725    66.906     0.200
     3.939    70.105     0.200
     3.939    70.207     0.200
     4.351    78.406     0.200
     4.349    77.707     0.200
     4.349    80.105     0.200
     4.349    77.508     0.200
     4.856    86.508     0.200
     4.856    88.207     0.200
     5.255    93.406     0.200
     5.255    93.008     0.200
     5.298    96.305     0.200
     5.508    97.508     0.200
     5.508    97.406     0.200
     5.631   101.883     0.200
     6.677   119.605     0.200
     6.677   121.605     0.200
     6.884   121.805     0.200
     2.152    38.586     0.200
     2.543    45.484     0.200
     4.262    76.484     0.200
     4.451    78.688     0.200
     5.164    92.484     0.200
     5.344    95.688     0.200
     7.011   124.484     0.200
     7.011   124.281     0.200
     3.338    59.641     0.200
     2.231    40.281     0.200
     2.578    46.180     0.200
     2.578    46.480     0.200
     2.746    49.082     0.200
     2.746    50.281     0.200
     3.352    61.480     0.200
     3.350    59.883     0.200
     3.350    60.781     0.200
     3.746    67.180     0.200
     3.922    69.383     0.200
     3.922    70.480     0.200
     4.103    73.582     0.200
     4.341    77.383     0.200
     4.327    78.480     0.200
     5.277    94.480     0.200
     5.285    93.480     0.200
     5.285    95.883     0.200
     5.496    98.980     0.200
     5.531    99.383     0.200
     6.698   121.180     0.200
     6.901   123.680     0.200
     6.901   122.180     0.200
     2.412    42.867     0.200
     3.664    65.066     0.200
     3.664    67.166     0.200
     4.506    80.367     0.200
     2.253    40.309     0.200
     2.550    45.609     0.200
     2.764    49.809     0.200
     2.900    51.707     0.200
     3.352    59.906     0.200
     3.402    63.309     0.200
     3.370    60.707     0.200
     3.723    66.707     0.200
     4.357    78.109     0.200
     4.351    79.109     0.200
     5.253    93.707     0.200
     5.253    95.109     0.200
     5.296    95.207     0.200
     5.504    98.906     0.200
     6.885   122.508     0.200
     6.885   122.008     0.200
     2.201    39.359     0.200
     2.885    52.859     0.200
     2.927    53.461     0.200
     3.508    62.961     0.200
     3.508    63.258     0.200
     3.641    64.961     0.200
     3.808    67.461     0.200
     3.911    70.461     0.200
     5.693   102.656     0.200
     7.310   128.961     0.200
     2.469    43.805     0.200
     3.009    54.508     0.200
     3.027    54.305     0.200
     4.209    75.207     0.200
     5.130    91.207     0.200
     6.608   116.805     0.200
     2.425    43.291     0.200
     2.898    51.492     0.200
     3.483    62.492     0.200
     3.878    69.092     0.200
     4.395    77.492     0.200
     4.886    89.092     0.200
     5.203    93.291     0.200
     7.334   129.191     0.200
     2.429    43.422     0.200
     2.421    43.121     0.200
     2.630    47.422     0.200
     2.669    48.922     0.200
     3.181    56.523     0.200
     3.132    55.824     0.200
     3.556    64.422     0.200
     3.603    64.922     0.200
     3.684    66.422     0.200
     3.684    65.324     0.200
     3.939    70.223     0.200
     4.148    75.922     0.200
     4.272    76.621     0.200
     4.515    81.621     0.200
     5.029    90.523     0.200
     5.029    90.922     0.200
     5.462    98.223     0.200
     5.462    96.223     0.200
     5.480    99.121     0.200
     7.146   126.922     0.200
     2.257    40.811     0.200
     2.571    46.011     0.200
     2.906    52.011     0.200
     3.378    60.011     0.200
     3.952    71.911     0.200
     4.322    77.111     0.200
     4.870    88.111     0.200
     5.253    93.311     0.200
     5.316    96.511     0.200
     5.501    99.511     0.200
     6.870   122.011     0.200
     2.578    46.039     0.200
     3.336    61.539     0.200
     3.362    60.539     0.200
     3.935    70.344     0.200
     3.935    70.539     0.200
     4.095    73.438     0.200
     4.329    76.844     0.200
     4.329    79.141     0.200
     4.329    77.438     0.200
     4.337    77.938     0.200
     5.526    98.844     0.200
     5.526   100.039     0.200
     5.495    97.844     0.200
     6.886   123.039     0.200
     2.246    40.400     0.200
     2.575    46.100     0.200
     2.764    50.900     0.200
     2.895    51.600     0.200
     3.333    60.000     0.200
     3.333    59.500     0.200
     3.421    61.400     0.200
     3.366    60.699     0.200
     3.732    66.500     0.200
     3.940    71.000     0.200
     3.940    70.699     0.200
     4.091    73.400     0.200
     4.091    75.799     0.200
     4.091    75.100     0.200
     4.328    78.199     0.200
     4.328    77.100     0.200
     4.341    78.400     0.200
     4.341    78.000     0.200
     4.858    88.500     0.200
     5.304    94.900     0.200
     5.522    98.500     0.200
     5.522    97.500     0.200
     5.612   101.719     0.200
     6.683   119.400     0.200
     6.683   122.000     0.200
     6.882   122.600     0.200
     7.291   130.799     0.200
     8.802   158.100     0.200
     2.241    40.547     0.200
     2.760    49.945     0.200
     3.062    54.648     0.200
     3.329    61.648     0.200
     3.936    70.242     0.200
     3.936    71.242     0.200
     4.320    77.547     0.200
     4.320    77.742     0.200
     4.334    77.344     0.200
     4.855    85.648     0.200
     5.303    95.547     0.200
     5.530    97.648     0.200
     6.689   118.945     0.200
     6.885   122.742     0.200
     2.038    37.844     0.200
     3.017    53.945     0.200
     3.270    58.148     0.200
     4.297    75.844     0.200
     4.361    78.148     0.200
     4.720    85.547     0.200
     5.166    92.250     0.200
     5.212    93.445     0.200
     5.624   100.844     0.200
     2.368    42.338     0.200
     2.958    53.639     0.200
     3.017    53.838     0.200
     3.490    62.039     0.200
     3.490    63.738     0.200
     3.614    64.139     0.200
     4.298    76.738     0.200
     4.458    79.338     0.200
     5.146    92.039     0.200
     2.338    42.328     0.200
     2.594    46.227     0.200
     3.069    54.430     0.200
     3.494    62.727     0.200
     3.658    65.930     0.200
     3.715    65.930     0.200
     4.040    72.125     0.200
     4.034    72.023     0.200
     4.315    76.727     0.200
     4.397    77.930     0.200
     4.578    80.727     0.200
     5.570    99.727     0.200
     6.990   125.523     0.200
     2.476    44.641     0.200
     2.593    46.340     0.200
     3.068    54.340     0.200
     3.343    59.539     0.200
     3.656    64.840     0.200
     3.714    66.840     0.200
     4.040    72.238     0.200
     4.034    72.039     0.200
     4.317    77.039     0.200
     4.397    80.441     0.200
     5.570   100.141     0.200
     7.161   128.840     0.200
     2.498    44.723     0.200
     3.125    56.522     0.200
     3.661    64.723     0.200
     4.163    74.622     0.200
     4.611    81.522     0.200
     4.573    80.923     0.200
     4.573    82.622     0.200
     4.983    90.022     0.200
     5.455    96.923     0.200
     5.455    95.822     0.200
     5.552    99.122     0.200
     6.893   122.423     0.200
     7.007   124.223     0.200
     7.181   127.223     0.200
     2.141    38.516     0.200
     2.391    43.414     0.200
     2.391    43.211     0.200
     2.512    45.914     0.200
     2.820    50.211     0.200
     2.906    51.914     0.200
     3.024    54.516     0.200
     3.024    54.211     0.200
     3.179    56.914     0.200
     3.183    58.414     0.200
     3.183    58.516     0.200
     3.631    64.781     0.200
     3.631    65.211     0.200
     3.833    69.914     0.200
     4.197    75.312     0.200
     4.321    78.016     0.200
     4.605    83.914     0.200
     4.605    83.711     0.200
     5.000    90.312     0.200
     5.114    90.617     0.200
     5.114    92.516     0.200
     5.540    99.516     0.200
     5.681   102.312     0.200
     8.946   160.516     0.200
     2.137    38.908     0.200
     2.736    48.708     0.200
     2.865    51.208     0.200
     3.453    61.008     0.200
     3.506    63.408     0.200
     4.391    79.408     0.200
     4.862    87.608     0.200
     5.762   104.408     0.200
     2.234    40.926     0.200
     2.627    46.926     0.200
     3.350    59.324     0.200
     3.417    60.926     0.200
     3.918    69.824     0.200
     4.096    72.926     0.200
     4.333    77.926     0.200
     4.835    86.926     0.200
     5.271    93.324     0.200
     5.276    93.926     0.200
     6.694   120.223     0.200
     6.906   123.625     0.200
     7.527   135.824     0.200
     8.681   157.023     0.200
     2.556    45.395     0.200
     2.685    47.523     0.200
     2.803    49.621     0.200
     3.369    60.422     0.200
     3.977    71.523     0.200
     4.351    77.320     0.200
     4.351    79.723     0.200
     4.389    79.422     0.200
     4.894    87.723     0.200
     5.470    97.523     0.200
     6.636   120.621     0.200
     6.847   122.422     0.200
     2.241    40.480     0.200
     2.577    45.980     0.200
     2.889    51.781     0.200
     3.361    59.582     0.200
     3.737    66.480     0.200
     3.934    70.582     0.200
     4.096    72.582     0.200
     4.336    78.082     0.200
     5.298    94.082     0.200
     6.888   124.383     0.200
     7.550   136.684     0.200
     2.579    45.871     0.200
     3.930    70.672     0.200
     4.332    77.172     0.200
     5.272    94.469     0.200
     6.892   123.172     0.200
     2.729    48.391     0.200
     2.904    52.435     0.200
     3.436    62.990     0.200
     3.958    71.990     0.200
     7.403   130.690     0.200
     2.241    40.688     0.200
     2.580    45.992     0.200
     2.890    51.992     0.200
     3.335    60.992     0.200
     3.362    60.289     0.200
     3.737    66.891     0.200
     3.935    70.289     0.200
     4.096    74.891     0.200
     4.327    78.586     0.200
     4.336    76.891     0.200
     4.336    79.789     0.200
     4.853    86.188     0.200
     5.300    95.992     0.200
     5.527    98.188     0.200
     5.493   100.391     0.200
     6.886   122.289     0.200
     2.250    40.570     0.200
     2.240    40.477     0.200
     2.574    45.977     0.200
     2.634    47.773     0.200
     2.887    51.773     0.200
     3.344    61.172     0.200
     3.359    60.172     0.200
     3.359    60.070     0.200
     3.738    67.070     0.200
     3.931    69.773     0.200
     4.096    72.672     0.200
     4.096    75.477     0.200
     4.335    77.672     0.200
     4.335    77.375     0.200
     4.337    79.273     0.200
     4.337    77.672     0.200
     4.849    87.570     0.200
     5.294    95.875     0.200
     5.524    98.375     0.200
     5.500    98.773     0.200
     6.689   120.477     0.200
     6.891   123.070     0.200
     2.059    37.160     0.200
     2.726    48.762     0.200
     2.816    50.262     0.200
     2.901    51.961     0.200
     2.974    53.262     0.200
     3.437    60.961     0.200
     4.450    79.961     0.200
     4.497    80.859     0.200
     4.894    87.062     0.200
     5.158    91.660     0.200
     6.588   117.562     0.200
     6.859   123.359     0.200
     2.224    40.070     0.200
     2.330    42.367     0.200
     2.330    41.969     0.200
     2.621    47.168     0.200
     2.621    46.867     0.200
     2.735    49.469     0.200
     2.880    51.469     0.200
     2.880    52.168     0.200
     3.174    57.367     0.200
     3.360    60.512     0.200
     3.360    60.070     0.200
     3.536    63.270     0.200
     3.789    67.969     0.200
     3.789    67.367     0.200
     3.962    71.367     0.200
     4.138    74.367     0.200
     4.138    73.770     0.200
     4.171    75.168     0.200
     4.288    76.367     0.200
     4.884    86.570     0.200
     4.884    87.469     0.200
     5.325    94.867     0.200
     5.325    95.668     0.200
     5.335    96.367     0.200
     5.369    97.168     0.200
     5.459    98.109     0.200
     5.635   100.367     0.200
     5.635   100.867     0.200
     6.855   121.969     0.200
     2.278    41.500     0.200
     2.672    47.602     0.200
     2.927    52.500     0.200
     3.291    59.000     0.200
     3.400    60.000     0.200
     3.705    67.195     0.200
     3.977    71.102     0.200
     4.298    77.602     0.200
     4.895    87.195     0.200
     5.236    94.297     0.200
     6.844   121.500     0.200
     4.293    76.324     0.200
     2.319    42.317     0.200
     2.463    44.917     0.200
     2.575    46.617     0.200
     2.575    46.817     0.200
     2.576    46.417     0.200
     2.857    51.617     0.200
     3.052    55.424     0.200
     3.052    54.617     0.200
     3.052    54.817     0.200
     3.371    60.718     0.200
     3.371    60.617     0.200
     3.493    62.917     0.200
     3.644    66.018     0.200
     3.741    67.718     0.200
     3.741    68.117     0.200
     4.011    73.117     0.200
     4.011    72.518     0.200
     4.062    72.917     0.200
     4.297    78.518     0.200
     4.421    79.218     0.200
     4.565    82.518     0.200
     4.565    82.117     0.200
     5.051    91.518     0.200
     5.843   105.218     0.200
     6.996   125.518     0.200
     7.173   128.218     0.200
     2.425    43.869     0.200
     2.465    45.168     0.200
     2.598    46.969     0.200
     2.598    46.770     0.200
     2.725    49.068     0.200
     2.720    49.068     0.200
     2.720    49.369     0.200
     3.224    57.469     0.200
     3.194    58.688     0.200
     3.194    58.068     0.200
     3.419    60.869     0.200
     3.594    65.369     0.200
     3.594    66.270     0.200
     3.777    68.568     0.200
     3.777    68.969     0.200
     3.912    70.068     0.200
     4.162    76.168     0.200
     4.162    75.568     0.200
     4.271    76.869     0.200
     4.311    76.770     0.200
     4.697    84.369     0.200
     5.442    98.369     0.200
     5.442    98.168     0.200
     5.463    98.889     0.200
     8.997   163.668     0.200
     2.069    37.504     0.200
     2.465    44.406     0.200
     2.744    48.906     0.200
     2.721    48.605     0.200
     3.196    58.207     0.200
     3.237    57.605     0.200
     3.783    68.004     0.200
     3.916    70.105     0.200
     4.157    74.605     0.200
     4.278    77.805     0.200
     4.286    77.105     0.200
     4.703    83.605     0.200
     5.336    96.805     0.200
     5.448    98.406     0.200
     6.865   123.707     0.200
     7.035   125.504     0.200
     2.244    40.875     0.200
     2.242    40.977     0.200
     2.242    41.273     0.200
     2.560    46.578     0.200
     2.560    46.773     0.200
     2.636    47.773     0.200
     2.636    47.672     0.200
     2.755    49.477     0.200
     2.889    52.172     0.200
     3.045    54.375     0.200
     3.355    59.773     0.200
     3.355    61.375     0.200
     3.360    59.922     0.200
     3.360    60.977     0.200
     3.413    61.375     0.200
     3.734    67.172     0.200
     3.929    71.773     0.200
     3.929    71.875     0.200
     4.340    78.578     0.200
     4.340    79.078     0.200
     4.354    77.977     0.200
     4.847    86.578     0.200
     5.264    94.375     0.200
     5.264    93.875     0.200
     5.288    95.375     0.200
     5.288    96.375     0.200
     5.515    98.172     0.200
     5.515    97.977     0.200
     5.627   102.242     0.200
     6.894   123.078     0.200
     9.107   164.773     0.200
     2.239    40.221     0.200
     2.578    46.020     0.200
     2.633    47.020     0.200
     3.359    60.221     0.200
     3.740    66.820     0.200
     4.332    77.520     0.200
     2.011    36.160     0.200
     2.299    41.262     0.200
     2.649    47.160     0.200
     3.332    59.262     0.200
     3.296    58.660     0.200
     3.700    66.160     0.200
     3.767    67.461     0.200
     4.329    78.160     0.200
     4.741    85.762     0.200
     6.281   112.262     0.200
     2.008    35.957     0.200
     2.102    38.957     0.200
     2.705    48.457     0.200
     2.648    47.859     0.200
     3.065    54.656     0.200
     3.102    55.359     0.200
     3.043    54.559     0.200
     3.159    56.156     0.200
     3.296    58.758     0.200
     3.703    65.859     0.200
     3.703    68.359     0.200
     3.767    67.258     0.200
     4.320    76.758     0.200
     4.331    77.559     0.200
     4.739    86.156     0.200
     4.739    85.457     0.200
     4.866    87.359     0.200
     5.163    91.156     0.200
     5.664   101.457     0.200
     6.270   111.656     0.200
     6.283   112.957     0.200
     6.500   114.758     0.200
     2.351    42.935     0.200
     2.447    44.335     0.200
     2.600    46.734     0.200
     2.600    46.835     0.200
     2.687    48.535     0.200
     3.063    54.754     0.200
     3.063    54.535     0.200
     3.621    64.135     0.200
     3.643    64.935     0.200
     3.618    65.035     0.200
     4.080    73.935     0.200
     4.340    77.535     0.200
     4.519    81.734     0.200
     4.519    82.335     0.200
     4.534    82.935     0.200
     4.970    89.435     0.200
     5.531    98.734     0.200
     5.531    97.835     0.200
     5.522    98.774     0.200
     5.720   101.635     0.200
     5.720   100.835     0.200
     6.963   127.635     0.200
     8.576   154.734     0.200
     2.685    47.645     0.200
     2.896    51.543     0.200
     3.158    55.945     0.200
     3.563    64.043     0.200
     3.641    64.645     0.200
     3.975    72.445     0.200
     4.535    81.844     0.200
     5.102    91.945     0.200
     5.177    92.945     0.200
     5.480    97.645     0.200
     6.564   116.645     0.200
     2.251    40.891     0.200
     2.581    46.195     0.200
     2.645    47.297     0.200
     2.771    49.992     0.200
     2.900    52.094     0.200
     3.320    61.297     0.200
     3.372    60.492     0.200
     3.372    60.297     0.200
     3.730    67.094     0.200
     4.090    73.391     0.200
     4.315    77.297     0.200
     4.315    76.492     0.200
     4.343    77.492     0.200
     4.343    77.391     0.200
     4.865    87.391     0.200
     4.865    88.594     0.200
     5.261    94.297     0.200
     5.524    98.094     0.200
     5.524    97.797     0.200
     2.040    37.219     0.200
     2.090    38.418     0.200
     2.636    47.617     0.200
     3.030    54.219     0.200
     3.077    54.719     0.200
     3.284    58.117     0.200
     3.346    60.117     0.200
     3.755    67.117     0.200
     4.317    76.316     0.200
     4.319    77.719     0.200
     4.727    85.020     0.200
     5.235    93.020     0.200
     6.295   112.719     0.200
     6.511   116.219     0.200
     2.242    40.605     0.200
     2.580    46.008     0.200
     2.636    48.105     0.200
     2.760    50.105     0.200
     2.890    51.605     0.200
     3.362    60.508     0.200
     3.426    61.906     0.200
     3.737    66.508     0.200
     3.936    70.707     0.200
     3.936    71.707     0.200
     4.096    75.207     0.200
     4.325    77.906     0.200
     4.336    78.508     0.200
     4.854    86.105     0.200
     5.268    94.207     0.200
     5.527    98.105     0.200
     6.688   120.707     0.200
     6.885   123.809     0.200
     2.248    40.902     0.200
     2.246    40.402     0.200
     2.581    46.102     0.200
     2.641    47.402     0.200
     2.895    52.301     0.200
     3.367    60.203     0.200
     3.424    61.801     0.200
     3.733    66.801     0.200
     3.942    70.801     0.200
     4.094    73.102     0.200
     4.094    75.102     0.200
     4.320    77.402     0.200
     4.340    77.801     0.200
     4.860    87.203     0.200
     5.264    93.801     0.200
     5.308    95.000     0.200
     5.526    98.500     0.200
     6.684   119.902     0.200
     6.880   124.301     0.200
     2.059    37.543     0.200
     2.295    41.543     0.200
     2.045    36.998     0.200
     2.156    38.598     0.200
     2.304    41.998     0.200
     2.692    48.498     0.200
     2.939    52.498     0.200
     2.001    35.742     0.200
     2.040    37.641     0.200
     2.201    39.344     0.200
     2.201    40.242     0.200
     2.290    40.844     0.200
     2.664    47.344     0.200
     2.980    53.344     0.200
     3.228    58.141     0.200
     3.303    59.039     0.200
     3.380    59.844     0.200
     3.719    66.242     0.200
     4.227    75.742     0.200
     4.514    80.141     0.200
     4.703    84.242     0.200
     4.903    86.844     0.200
     5.137    92.539     0.200
     5.523    99.141     0.200
     6.334   113.039     0.200
     2.078    38.195     0.200
     2.470    45.398     0.200
     2.645    47.297     0.200
     2.581    47.398     0.200
     2.721    49.098     0.200
     3.168    57.598     0.200
     3.190    57.297     0.200
     3.190    57.496     0.200
     3.503    62.598     0.200
     3.503    62.996     0.200
     3.755    66.695     0.200
     3.755    67.195     0.200
     3.894    70.598     0.200
     4.185    76.598     0.200
     4.424    78.398     0.200
     4.424    79.996     0.200
     4.672    84.996     0.200
     5.420    97.496     0.200
     5.642   101.195     0.200
     2.279    41.395     0.200
     2.409    43.693     0.200
     2.534    45.895     0.200
     2.595    47.193     0.200
     2.187    39.484     0.200
     2.610    47.184     0.200
     2.581    47.184     0.200
     2.704    49.184     0.200
     3.100    55.184     0.200
     3.306    59.586     0.200
     3.469    63.184     0.200
     3.378    60.984     0.200
     3.790    68.184     0.200
     3.879    69.883     0.200
     4.284    77.285     0.200
     4.344    78.586     0.200
     4.797    86.684     0.200
     5.246    95.484     0.200
     5.320    95.984     0.200
     5.570   100.086     0.200
     6.741   121.684     0.200
     6.942   124.285     0.200
     7.231   131.684     0.200
     2.860    52.420     0.200
     2.860    51.320     0.200
     3.319    58.719     0.200
     3.319    59.820     0.200
     3.289    60.320     0.200
     3.466    61.820     0.200
     3.628    64.320     0.200
     3.987    71.119     0.200
     4.033    71.619     0.200
     4.345    77.719     0.200
     4.445    80.219     0.200
     4.950    88.219     0.200
     5.159    92.219     0.200
     5.420    96.020     0.200
     5.420    95.520     0.200
     5.385    96.119     0.200
     5.702   101.285     0.200
     6.792   120.719     0.200
     7.430   134.119     0.200
     2.319    41.325     0.200
     2.319    41.726     0.200
     2.462    44.926     0.200
     2.462    44.025     0.200
     2.574    46.825     0.200
     2.575    46.525     0.200
     3.051    54.726     0.200
     3.051    54.926     0.200
     3.367    59.825     0.200
     3.643    64.825     0.200
     3.643    66.226     0.200
     3.738    66.325     0.200
     3.738    67.226     0.200
     4.012    71.825     0.200
     4.012    71.226     0.200
     4.303    77.325     0.200
     4.419    79.426     0.200
     4.564    81.125     0.200
     4.564    82.025     0.200
     5.048    91.726     0.200
     5.340    95.926     0.200
     5.592    99.325     0.200
     5.839   104.325     0.200
     7.174   129.926     0.200
     8.595   155.625     0.200
    10.223   185.426     0.200
     2.326    41.828     0.200
     2.582    46.629     0.200
     3.057    54.730     0.200
     3.057    56.328     0.200
     3.358    59.828     0.200
     3.647    65.230     0.200
     4.053    72.027     0.200
     4.020    73.129     0.200
     4.310    77.629     0.200
     4.568    82.430     0.200
     5.050    91.230     0.200
     5.584   100.527     0.200
     7.169   128.027     0.200
     2.080    38.820     0.200
     2.269    40.922     0.200
     2.618    47.320     0.200
     3.010    54.125     0.200
     3.116    56.719     0.200
     2.039    36.725     0.200
     2.916    51.625     0.200
     3.034    54.125     0.200
     3.283    58.926     0.200
     3.504    63.025     0.200
     3.590    64.926     0.200
     4.070    72.426     0.200
     4.348    77.426     0.200
     4.484    80.225     0.200
     4.986    88.826     0.200
     5.120    91.926     0.200
     5.417    97.225     0.200
     6.757   120.725     0.200
     2.122    38.695     0.200
     2.248    40.391     0.200
     2.557    45.891     0.200
     2.641    47.891     0.200
     2.761    50.492     0.200
     2.895    52.094     0.200
     3.366    60.789     0.200
     3.729    66.992     0.200
     3.936    71.391     0.200
     4.086    74.195     0.200
     4.347    78.492     0.200
     4.345    78.891     0.200
     4.854    87.594     0.200
     5.259    93.789     0.200
     5.513    98.391     0.200
     6.681   120.891     0.200
     6.887   123.094     0.200
     2.036    36.812     0.200
     2.426    43.812     0.200
     2.528    45.719     0.200
     2.644    47.219     0.200
     2.675    48.312     0.200
     3.141    57.117     0.200
     3.189    57.812     0.200
     3.570    63.719     0.200
     3.699    66.617     0.200
     3.935    70.312     0.200
     4.149    75.812     0.200
     4.479    80.414     0.200
     4.615    82.016     0.200
     5.052    91.219     0.200
     5.459    98.117     0.200
     5.663   101.719     0.200
     6.889   124.312     0.200
     7.128   128.617     0.200
     2.609    47.305     0.200
     2.602    46.102     0.200
     2.602    47.703     0.200
     3.265    57.805     0.200
     3.265    60.004     0.200
     3.738    67.305     0.200
     3.812    67.504     0.200
     3.812    69.504     0.200
     3.883    69.805     0.200
     4.085    73.203     0.200
     4.370    79.305     0.200
     4.370    80.203     0.200
     4.634    83.102     0.200
     4.940    88.602     0.200
     5.305    95.102     0.200
     5.380    95.602     0.200
     5.901   106.504     0.200
     6.758   121.504     0.200
     7.182   128.305     0.200
     2.202    39.672     0.200
     2.487    44.773     0.200
     2.876    51.273     0.200
     2.961    53.773     0.200
     3.124    55.375     0.200
     3.363    60.172     0.200
     3.483    62.574     0.200
     3.585    63.672     0.200
     3.820    68.773     0.200
     4.123    73.574     0.200
     4.520    80.375     0.200
     4.601    82.672     0.200
     5.006    90.172     0.200
     5.034    90.172     0.200
     5.226    92.973     0.200
     5.802   105.875     0.200
     5.919   105.535     0.200
     6.727   120.074     0.200
     7.298   130.074     0.200
     8.167   147.473     0.200
     2.217    39.953     0.200
     2.251    40.055     0.200
     2.405    43.055     0.200
     2.503    45.055     0.200
     2.739    48.852     0.200
     2.892    51.852     0.200
     2.976    52.953     0.200
     3.140    56.156     0.200
     3.467    61.156     0.200
     3.601    64.656     0.200
     3.804    67.352     0.200
     4.138    74.055     0.200
     4.523    80.250     0.200
     4.618    83.156     0.200
     4.990    88.453     0.200
     5.049    90.250     0.200
     5.210    92.453     0.200
     5.438    97.750     0.200
     6.422   115.453     0.200
     6.714   119.352     0.200
     2.481    44.477     0.200
     2.758    49.172     0.200
     2.869    51.172     0.200
     3.117    55.172     0.200
     3.373    59.977     0.200
     3.490    61.875     0.200
     3.577    63.875     0.200
     3.825    67.977     0.200
     4.115    74.078     0.200
     4.528    80.078     0.200
     4.596    82.172     0.200
     5.012    88.578     0.200
     5.415    96.875     0.200
     2.110    38.594     0.200
     2.234    40.594     0.200
     2.746    49.492     0.200
     2.880    51.793     0.200
     2.880    51.691     0.200
     3.362    60.691     0.200
     3.351    60.391     0.200
     3.351    59.992     0.200
     3.742    67.094     0.200
     3.920    70.391     0.200
     3.920    70.691     0.200
     4.332    78.492     0.200
     4.356    77.293     0.200
     4.838    86.094     0.200
     5.272    93.492     0.200
     5.522    98.094     0.200
     6.567   117.691     0.200
     6.694   120.793     0.200
     6.903   122.992     0.200
     2.285    41.194     0.200
     2.677    48.294     0.200
     2.980    53.294     0.200
     2.928    52.494     0.200
     3.396    60.594     0.200
     3.687    67.294     0.200
     3.687    65.794     0.200
     3.955    70.694     0.200
     4.390    79.194     0.200
     4.412    79.394     0.200
     4.871    86.594     0.200
     5.214    92.694     0.200
     5.297    94.694     0.200
     5.587   100.994     0.200
     2.267    40.687     0.200
     2.316    41.287     0.200
     2.961    54.287     0.200
     3.091    55.787     0.200
     3.748    66.987     0.200
     4.071    72.087     0.200
     4.817    85.887     0.200
     5.142    91.687     0.200
     5.888   104.487     0.200
     6.003   105.887     0.200
     2.221    39.789     0.200
     2.316    41.191     0.200
     2.476    43.988     0.200
     2.595    47.789     0.200
     2.686    47.988     0.200
     4.195    74.488     0.200
     4.195    76.391     0.200
     2.052    37.742     0.200
     2.217    39.844     0.200
     2.241    40.445     0.200
     2.375    42.742     0.200
     2.625    48.242     0.200
     2.625    46.945     0.200
     2.686    48.945     0.200
     2.686    48.547     0.200
     2.867    52.648     0.200
     2.867    51.648     0.200
     3.323    59.344     0.200
     3.320    59.844     0.200
     3.320    59.742     0.200
     3.617    65.047     0.200
     3.740    67.445     0.200
     3.740    67.648     0.200
     3.842    68.148     0.200
     3.842    69.047     0.200
     4.054    73.148     0.200
     4.368    78.742     0.200
     4.368    79.844     0.200
     4.659    83.242     0.200
     4.659    84.148     0.200
     4.750    86.844     0.200
     4.750    85.344     0.200
     5.132    93.844     0.200
     5.254    95.547     0.200
     5.415    98.047     0.200
     5.727   103.648     0.200
     5.823   105.383     0.200
     2.194    39.912     0.200
     2.449    44.112     0.200
     2.914    52.912     0.200
     2.923    52.712     0.200
     3.459    61.812     0.200
     3.511    63.612     0.200
     3.897    71.212     0.200
     4.178    75.212     0.200
     4.368    78.612     0.200
     4.432    79.812     0.200
     5.199    94.012     0.200
     5.707   101.912     0.200
     7.130   128.712     0.200
     7.306   131.712     0.200
     2.263    40.578     0.200
     2.263    40.977     0.200
     2.635    47.273     0.200
     2.704    48.773     0.200
     2.898    51.773     0.200
     2.898    51.977     0.200
     3.421    61.273     0.200
     3.712    66.977     0.200
     3.964    72.078     0.200
     4.162    74.078     0.200
     4.162    75.375     0.200
     4.331    77.273     0.200
     4.331    76.977     0.200
     4.467    79.680     0.200
     4.735    85.078     0.200
     4.738    85.375     0.200
     5.673   101.773     0.200
     8.520   151.625     0.200
     2.002    37.184     0.200
     2.127    39.184     0.200
     2.191    40.285     0.200
     2.424    43.785     0.200
     2.575    47.184     0.200
     2.640    47.086     0.200
     2.817    51.184     0.200
     2.817    50.883     0.200
     3.630    64.785     0.200
     3.630    66.086     0.200
     3.789    68.484     0.200
     3.797    67.984     0.200
     4.105    73.883     0.200
     4.317    79.285     0.200
     4.646    84.184     0.200
     5.304    95.586     0.200
     5.467    98.285     0.200
     7.058   126.285     0.200
     2.282    41.078     0.200
     2.419    43.781     0.200
     2.537    45.578     0.200
     2.855    51.281     0.200
     3.012    54.477     0.200
     3.385    60.977     0.200
     3.599    64.680     0.200
     3.981    72.180     0.200
     4.092    73.078     0.200
     4.341    77.078     0.200
     4.520    81.477     0.200
     5.000    90.578     0.200
     2.005    37.320     0.200
     2.129    39.219     0.200
     2.192    39.516     0.200
     2.192    40.016     0.200
     2.266    41.016     0.200
     2.576    47.422     0.200
     2.640    47.820     0.200
     2.818    50.922     0.200
     2.990    54.117     0.200
     2.990    54.016     0.200
     3.373    60.219     0.200
     3.633    66.117     0.200
     3.788    68.820     0.200
     3.788    68.516     0.200
     4.319    78.516     0.200
     4.650    82.617     0.200
     4.650    84.516     0.200
     4.706    86.922     0.200
     4.706    84.516     0.200
     5.303    95.922     0.200
     5.686   103.422     0.200
     6.440   116.117     0.200
     8.268   150.516     0.200
     2.018    36.797     0.200
     2.199    40.098     0.200
     2.644    47.496     0.200
     2.824    50.699     0.200
     3.278    58.598     0.200
     4.327    78.199     0.200
     4.663    83.898     0.200
     4.708    83.699     0.200
     2.020    36.434     0.200
     2.362    42.434     0.200
     2.465    44.234     0.200
     2.755    49.637     0.200
     2.870    51.934     0.200
     2.870    51.336     0.200
     2.935    52.336     0.200
     3.008    53.734     0.200
     3.008    54.234     0.200
     3.292    59.836     0.200
     3.292    58.836     0.200
     3.308    59.836     0.200
     3.478    62.535     0.200
     3.614    64.836     0.200
     3.614    64.637     0.200
     3.971    71.434     0.200
     4.043    72.336     0.200
     4.357    78.137     0.200
     4.960    88.434     0.200
     4.960    88.836     0.200
     5.144    92.035     0.200
     5.144    93.434     0.200
     5.403    96.637     0.200
     5.403    96.434     0.200
     5.391    95.637     0.200
     5.601   101.637     0.200
     5.720   102.297     0.200
     6.784   120.637     0.200
     8.087   146.734     0.200
     8.606   155.734     0.200
     2.039    37.309     0.200
     2.226    40.211     0.200
     2.851    51.711     0.200
     3.626    65.809     0.200
     3.626    64.309     0.200
     3.756    66.711     0.200
     4.353    78.508     0.200
     4.661    84.109     0.200
     4.734    84.910     0.200
     4.734    86.211     0.200
     5.270    94.809     0.200
     5.430    97.008     0.200
     5.812   103.895     0.200
     7.034   125.711     0.200
     2.019    37.000     0.200
     2.455    43.898     0.200
     2.528    46.000     0.200
     2.664    47.297     0.200
     2.701    48.297     0.200
     3.133    55.703     0.200
     3.232    57.602     0.200
     3.521    63.398     0.200
     3.954    70.797     0.200
     4.123    74.203     0.200
     4.406    78.703     0.200
     4.622    82.102     0.200
     2.071    37.469     0.200
     2.320    41.969     0.200
     2.779    49.570     0.200
     2.787    49.844     0.200
     2.787    50.070     0.200
     3.354    60.070     0.200
     3.517    63.070     0.200
     3.799    68.375     0.200
     4.289    76.570     0.200
     4.273    75.969     0.200
     4.530    81.375     0.200
     4.740    84.969     0.200
     5.309    96.914     0.200
     2.211    39.977     0.200
     2.321    41.875     0.200
     2.461    44.477     0.200
     2.644    47.578     0.200
     2.829    50.773     0.200
     2.929    52.477     0.200
     3.396    61.273     0.200
     3.497    62.773     0.200
     3.777    67.578     0.200
     3.933    70.773     0.200
     4.151    74.477     0.200
     4.415    79.680     0.200
     4.488    81.078     0.200
     5.385    96.578     0.200
     2.118    38.461     0.200
     2.334    41.762     0.200
     2.391    43.160     0.200
     2.779    49.660     0.200
     3.027    54.062     0.200
     3.417    61.062     0.200
     3.488    62.660     0.200
     4.028    72.762     0.200
     4.523    80.562     0.200
     4.506    80.961     0.200
     4.939    88.160     0.200
     5.336    95.762     0.200
     2.093    38.484     0.200
     2.237    40.680     0.200
     2.275    40.680     0.200
     2.631    47.383     0.200
     2.632    47.484     0.200
     2.889    51.984     0.200
     3.097    55.484     0.200
     3.281    58.781     0.200
     3.364    60.055     0.200
     3.364    60.680     0.200
     4.120    74.883     0.200
     4.255    76.086     0.200
     4.321    78.281     0.200
     4.868    87.883     0.200
     5.285    94.984     0.200
     5.329    95.680     0.200
     5.436    98.281     0.200
     5.554    98.031     0.200
     2.054    38.188     0.200
     2.209    39.688     0.200
     2.359    42.088     0.200
     2.604    47.088     0.200
     2.762    49.188     0.200
     2.999    54.088     0.200
     3.253    58.488     0.200
     3.726    66.787     0.200
     4.283    76.287     0.200
     4.295    77.387     0.200
     4.916    87.887     0.200
     2.341    42.465     0.200
     3.847    69.164     0.200
     4.310    76.766     0.200
     4.337    77.367     0.200
     2.255    40.645     0.200
     2.255    41.545     0.200
     2.512    45.645     0.200
     2.897    52.244     0.200
     2.988    53.645     0.200
     3.425    61.545     0.200
     3.582    65.045     0.200
     3.949    71.545     0.200
     4.313    77.344     0.200
     4.503    81.145     0.200
     4.992    90.344     0.200
     5.201    93.744     0.200
     2.218    39.961     0.200
     2.469    44.762     0.200
     2.636    47.562     0.200
     2.823    50.762     0.200
     2.937    53.160     0.200
     3.389    61.062     0.200
     3.504    63.160     0.200
     3.685    66.262     0.200
     3.940    71.062     0.200
     4.143    74.562     0.200
     4.422    79.363     0.200
     4.480    81.062     0.200
     4.881    86.660     0.200
     5.307    95.562     0.200
     2.227    40.561     0.200
     2.137    38.660     0.200
     2.272    40.859     0.200
     2.666    47.959     0.200
     2.794    50.359     0.200
     2.921    52.959     0.200
     3.394    60.229     0.200
     3.394    60.760     0.200
     3.710    66.859     0.200
     4.073    72.959     0.200
     3.970    71.660     0.200
     4.302    77.160     0.200
     4.363    78.561     0.200
     4.889    87.660     0.200
     5.242    94.061     0.200
     5.338    95.660     0.200
     5.497    99.160     0.200
     5.510    98.160     0.200
     5.614    98.820     0.200
     6.660   118.260     0.200
     6.851   122.760     0.200
     2.122    38.141     0.200
     2.150    38.836     0.200
     2.150    38.641     0.200
     2.354    42.938     0.200
     2.354    42.438     0.200
     2.740    49.539     0.200
     2.740    49.242     0.200
     2.795    50.836     0.200
     3.298    59.539     0.200
     3.889    69.641     0.200
     4.047    74.539     0.200
     4.268    75.938     0.200
     4.558    81.039     0.200
     4.859    87.438     0.200
     5.517    99.336     0.200
     2.303    42.000     0.200
     2.532    45.297     0.200
     2.698    48.898     0.200
     2.952    53.297     0.200
     3.003    53.500     0.200
     3.297    59.602     0.200
     3.423    61.602     0.200
     3.676    66.398     0.200
     3.995    71.898     0.200
     4.036    73.500     0.200
     4.323    77.203     0.200
     4.397    79.203     0.200
     4.913    88.602     0.200
     5.207    93.297     0.200
     5.355    96.602     0.200
     2.280    40.922     0.200
     2.536    45.219     0.200
     2.875    51.820     0.200
     3.012    54.520     0.200
     3.400    61.219     0.200
     3.974    72.219     0.200
     4.134    74.520     0.200
     4.314    77.020     0.200
     4.525    81.121     0.200
     5.011    89.820     0.200
     5.220    93.719     0.200
     2.171    38.602     0.200
     2.589    45.898     0.200
     2.563    45.699     0.200
     2.678    47.801     0.200
     2.816    50.000     0.200
     3.285    59.301     0.200
     3.423    61.000     0.200
     3.852    68.801     0.200
     4.273    76.699     0.200
     4.769    85.398     0.200
     5.210    93.801     0.200
     5.331    95.102     0.200
     5.488    99.000     0.200
     2.142    38.584     0.200
     2.266    40.684     0.200
     2.457    44.385     0.200
     3.495    62.484     0.200
     3.753    66.984     0.200
     4.127    73.684     0.200
     4.231    75.484     0.200
     4.477    79.885     0.200
     2.196    39.199     0.200
     2.451    43.699     0.200
     2.684    48.000     0.200
     2.920    52.102     0.200
     2.926    52.000     0.200
     3.462    61.801     0.200
     3.516    63.402     0.200
     3.896    70.199     0.200
     4.046    72.699     0.200
     4.358    77.902     0.200
     4.437    79.801     0.200
     4.924    89.199     0.200
     2.309    41.109     0.200
     2.309    41.312     0.200
     2.497    44.508     0.200
     2.546    45.508     0.200
     2.608    47.312     0.200
     2.721    49.609     0.200
     2.793    50.609     0.200
     3.010    54.211     0.200
     3.163    56.812     0.200
     3.163    57.109     0.200
     3.558    63.414     0.200
     3.678    65.508     0.200
     3.813    68.109     0.200
     4.289    76.508     0.200
     4.286    76.312     0.200
     4.753    83.711     0.200
     4.849    86.812     0.200
     5.242    93.711     0.200
     5.763   102.508     0.200
     5.990   105.508     0.200
     2.276    41.770     0.200
     2.456    44.170     0.200
     2.667    48.770     0.200
     2.764    50.170     0.200
     2.916    52.369     0.200
     3.381    60.369     0.200
     3.694    65.471     0.200
     3.932    70.270     0.200
     4.468    79.869     0.200
     4.468    80.869     0.200
     4.846    86.770     0.200
     5.219    92.770     0.200
     5.263    94.869     0.200
     2.516    45.145     0.200
     2.734    48.645     0.200
     2.979    53.547     0.200
     3.530    63.047     0.200
     4.090    73.547     0.200
     4.446    79.344     0.200
     4.557    82.246     0.200
     2.193    39.594     0.200
     2.193    39.395     0.200
     2.299    41.895     0.200
     2.299    41.594     0.200
     2.443    44.094     0.200
     2.443    43.895     0.200
     2.909    51.938     0.200
     2.909    52.195     0.200
     3.403    60.594     0.200
     3.721    67.895     0.200
     3.784    67.094     0.200
     3.920    70.996     0.200
     4.007    72.793     0.200
     4.167    74.395     0.200
     4.500    80.293     0.200
     4.510    80.395     0.200
     5.311    95.293     0.200
     8.334   152.641     0.200
     2.173    39.754     0.200
     2.270    40.854     0.200
     2.643    47.053     0.200
     2.665    49.152     0.200
     2.665    47.754     0.200
     2.881    51.553     0.200
     2.876    51.354     0.200
     3.267    58.854     0.200
     3.315    59.570     0.200
     3.315    59.754     0.200
     3.753    67.953     0.200
     3.753    66.553     0.200
     3.797    68.053     0.200
     3.797    68.453     0.200
     3.801    68.453     0.200
     4.037    73.152     0.200
     4.340    77.652     0.200
     4.406    79.453     0.200
     4.699    83.553     0.200
     4.869    88.053     0.200
     5.253    93.953     0.200
     5.038    89.854     0.200
     5.350    95.453     0.200
     5.350    96.053     0.200
     2.434    43.553     0.200
     2.898    52.421     0.200
     2.898    52.053     0.200
     3.399    60.353     0.200
     3.457    62.653     0.200
     3.751    67.153     0.200
     3.917    70.553     0.200
     3.991    71.353     0.200
     4.173    74.653     0.200
     4.374    78.053     0.200
     4.543    81.553     0.200
     4.823    86.253     0.200
     5.332    95.953     0.200
     5.411    96.092     0.200
     2.106    38.281     0.200
     2.383    43.082     0.200
     2.772    49.883     0.200
     2.860    51.883     0.200
     3.020    54.383     0.200
     3.482    62.781     0.200
     3.588    63.883     0.200
     4.024    72.082     0.200
     4.497    80.781     0.200
     4.510    81.281     0.200
     4.936    88.082     0.200
     5.110    91.082     0.200
     5.336    95.682     0.200
     2.120    38.695     0.200
     2.300    41.789     0.200
     2.397    43.289     0.200
     2.786    50.891     0.200
     2.873    52.695     0.200
     2.873    51.594     0.200
     3.034    54.695     0.200
     3.216    57.492     0.200
     3.406    61.195     0.200
     3.406    60.992     0.200
     3.574    63.789     0.200
     3.495    62.188     0.200
     3.495    62.789     0.200
     3.909    72.594     0.200
     4.036    72.391     0.200
     4.514    80.695     0.200
     4.512    81.695     0.200
     4.948    89.695     0.200
     5.096    92.391     0.200
     5.347    96.594     0.200
     5.736   103.195     0.200
     6.809   121.391     0.200
     2.061    37.363     0.200
     2.451    44.664     0.200
     2.700    49.062     0.200
     3.161    56.461     0.200
     3.165    57.363     0.200
     3.720    67.664     0.200
     3.909    69.961     0.200
     4.175    76.164     0.200
     2.006    36.508     0.200
     2.110    38.102     0.200
     2.602    46.703     0.200
     2.502    44.906     0.200
     2.608    47.406     0.200
     2.752    50.203     0.200
     3.130    55.703     0.200
     3.219    57.352     0.200
     3.219    57.805     0.200
     3.501    62.805     0.200
     3.860    69.508     0.200
     3.780    67.805     0.200
     5.586    99.547     0.200
     2.502    44.590     0.200
     2.649    48.189     0.200
     2.793    49.889     0.200
     3.125    55.434     0.200
     3.125    56.488     0.200
     3.301    59.289     0.200
     3.447    61.988     0.200
     3.987    71.590     0.200
     5.392    97.049     0.200
     2.211    39.492     0.200
     2.323    41.195     0.200
     2.462    43.695     0.200
     2.645    46.895     0.200
     2.930    52.395     0.200
     3.399    60.195     0.200
     3.399    60.992     0.200
     3.499    62.195     0.200
     3.499    62.992     0.200
     3.683    65.195     0.200
     4.151    73.992     0.200
     4.473    80.492     0.200
     5.379    96.793     0.200
     7.027   125.793     0.200
     8.295   149.895     0.200
     2.037    36.492     0.200
     2.218    39.891     0.200
     2.375    42.789     0.200
     2.510    45.789     0.200
     2.045    36.911     0.200
     2.200    39.911     0.200
     2.580    46.011     0.200
     2.820    50.511     0.200
     3.791    67.011     0.200
     5.828   104.451     0.200
     8.332   148.911     0.200
     2.205    39.750     0.200
     2.322    42.352     0.200
     2.457    44.250     0.200
     2.654    47.953     0.200
     2.851    50.953     0.200
     2.926    52.852     0.200
     3.413    60.648     0.200
     3.499    63.055     0.200
     3.922    71.148     0.200
     5.360    97.312     0.200
     8.282   148.500     0.200
     2.227    39.812     0.200
     2.620    47.609     0.200
     2.871    51.211     0.200
     2.199    39.777     0.200
     2.320    42.578     0.200
     2.452    44.578     0.200
     2.662    47.977     0.200
     2.863    51.176     0.200
     2.922    52.578     0.200
     3.422    61.375     0.200
     3.497    63.176     0.200
     3.666    65.676     0.200
     3.915    71.277     0.200
     4.165    75.277     0.200
     4.442    79.375     0.200
     5.347    97.535     0.200
     2.602    46.883     0.200
     2.852    50.785     0.200
     3.036    54.285     0.200
     3.760    66.785     0.200
     2.289    41.457     0.200
     2.432    44.559     0.200
     2.545    46.160     0.200
     2.871    51.660     0.200
     3.021    53.738     0.200
     3.021    54.559     0.200
     3.394    61.059     0.200
     3.518    63.258     0.200
     3.614    65.660     0.200
     4.309    77.758     0.200
     5.320    96.359     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.984    18.524     0.200
     1.695    31.424     0.200
     1.823    32.625     0.200
     3.621    63.625     0.200
     1.949    34.221     0.200
     3.245    55.221     0.200
     0.358     7.965     0.200
     0.826    14.965     0.200
     2.787    47.965     0.200
     4.184    72.465     0.200
     0.240     5.785     0.200
     1.281    22.285     0.200
     2.391    41.184     0.200
     2.507    42.883     0.200
     2.504    43.785     0.200
     3.662    64.285     0.200
     3.744    65.484     0.200
     0.258     5.672     0.200
     1.359    24.672     0.200
     1.654    28.672     0.200
     2.207    38.773     0.200
     2.368    41.375     0.200
     2.597    45.070     0.200
     2.657    45.672     0.200
     3.031    52.672     0.200
     4.044    70.273     0.200
     0.264     6.723     0.200
     0.997    17.820     0.200
     1.436    25.121     0.200
     2.557    44.621     0.200
     2.976    52.121     0.200
     3.254    55.820     0.200
     3.846    67.121     0.200
     0.327     7.148     0.200
     0.914    16.949     0.200
     1.506    26.047     0.200
     2.261    39.648     0.200
     2.641    45.949     0.200
     3.338    58.250     0.200
     3.421    59.949     0.200
     3.881    67.648     0.200
     0.282     7.059     0.200
     0.956    17.559     0.200
     1.429    25.859     0.200
     0.314     6.391     0.200
     0.916    16.590     0.200
     1.510    26.590     0.200
     2.713    47.891     0.200
     1.407    25.977     0.200
     2.658    46.676     0.200
     2.658    46.977     0.200
     3.391    58.977     0.200
     3.670    63.977     0.200
     4.117    72.078     0.200
     4.264    74.977     0.200
     0.355     7.064     0.200
     0.995    18.264     0.200
     1.401    24.964     0.200
     1.413    26.464     0.200
     2.696    47.464     0.200
     0.236     4.913     0.200
     0.569    11.213     0.200
     1.043    18.513     0.200
     1.331    24.213     0.200
     2.282    40.513     0.200
     2.570    44.513     0.200
     3.071    54.013     0.200
     3.413    59.013     0.200
     0.146     3.605     0.200
     0.649    13.006     0.200
     0.966    17.705     0.200
     1.407    25.605     0.200
     1.916    34.605     0.200
     2.230    39.307     0.200
     2.562    45.506     0.200
     3.038    53.506     0.200
     3.326    58.006     0.200
     0.331     6.922     0.200
     1.021    19.125     0.200
     1.383    25.125     0.200
     1.443    26.523     0.200
     1.464    26.422     0.200
     1.770    33.227     0.200
     2.377    41.922     0.200
     2.665    46.023     0.200
     2.665    46.227     0.200
     3.540    62.320     0.200
     4.058    71.727     0.200
     0.260     5.176     0.200
     0.589    11.375     0.200
     1.282    23.773     0.200
     1.434    26.273     0.200
     1.818    33.074     0.200
     2.345    41.375     0.200
     2.532    45.176     0.200
     2.653    47.273     0.200
     3.837    67.273     0.200
     0.224     5.080     0.200
     0.934    15.980     0.200
     0.951    17.680     0.200
     1.377    25.180     0.200
     1.528    27.180     0.200
     2.296    39.880     0.200
     2.768    48.480     0.200
     4.073    71.380     0.200
     0.206     4.305     0.200
     0.767    14.805     0.200
     0.997    19.008     0.200
     0.999    19.008     0.200
     1.045    19.406     0.200
     1.033    19.406     0.200
     1.034    19.406     0.200
     1.358    25.711     0.200
     1.509    28.109     0.200
     1.509    28.906     0.200
     1.614    30.305     0.200
     1.766    32.406     0.200
     2.360    42.109     0.200
     3.262    57.711     0.200
     0.352     6.417     0.200
     0.471     9.217     0.200
     0.984    17.717     0.200
     1.375    24.717     0.200
     1.375    25.518     0.200
     1.437    25.917     0.200
     2.127    37.817     0.200
     2.353    42.018     0.200
     2.793    49.417     0.200
     3.954    69.817     0.200
     4.864    85.717     0.200
     4.864    85.217     0.200
     0.296     5.160     0.200
     0.560    10.762     0.200
     1.123    20.363     0.200
     1.123    20.762     0.200
     1.250    22.961     0.200
     1.575    29.062     0.200
     1.804    32.262     0.200
     2.368    42.160     0.200
     3.155    56.160     0.200
     3.864    68.461     0.200
     0.118     3.159     0.200
     0.669    13.159     0.200
     0.906    15.958     0.200
     1.166    21.859     0.200
     1.247    22.458     0.200
     1.467    26.359     0.200
     1.741    32.159     0.200
     1.782    33.259     0.200
     1.976    35.359     0.200
     2.167    38.159     0.200
     0.258     4.949     0.200
     0.548    11.352     0.200
     1.060    19.750     0.200
     1.060    19.449     0.200
     1.038    20.148     0.200
     1.162    21.949     0.200
     1.314    24.250     0.200
     1.314    24.148     0.200
     1.582    28.852     0.200
     1.621    30.449     0.200
     1.621    29.852     0.200
     1.650    29.648     0.200
     1.650    30.852     0.200
     1.882    34.051     0.200
     2.292    40.648     0.200
     2.569    45.648     0.200
     3.077    54.352     0.200
     3.293    58.449     0.200
     3.436    60.949     0.200
     3.791    66.352     0.200
     3.791    66.250     0.200
     0.215     4.519     0.200
     0.982    17.619     0.200
     1.121    21.818     0.200
     1.236    22.919     0.200
     1.395    25.818     0.200
     1.664    30.318     0.200
     1.734    33.019     0.200
     1.960    35.519     0.200
     2.209    38.818     0.200
     2.657    46.519     0.200
     3.395    59.519     0.200
     3.707    65.219     0.200
     0.235     5.625     0.200
     0.630    11.426     0.200
     0.872    16.426     0.200
     1.429    25.824     0.200
     1.469    25.926     0.200
     1.743    30.824     0.200
     1.920    33.324     0.200
     1.949    35.625     0.200
     2.203    38.824     0.200
     0.247     5.414     0.200
     0.920    16.215     0.200
     0.985    18.316     0.200
     1.105    20.316     0.200
     1.557    27.414     0.200
     1.624    30.016     0.200
     1.835    33.117     0.200
     1.835    33.414     0.200
     2.289    39.715     0.200
     3.028    52.414     0.200
     3.167    55.117     0.200
     0.094     4.765     0.200
     0.698    13.564     0.200
     0.923    16.365     0.200
     1.135    21.064     0.200
     1.203    22.064     0.200
     1.452    26.064     0.200
     1.452    25.265     0.200
     1.662    30.165     0.200
     1.934    34.465     0.200
     2.203    38.265     0.200
     2.203    37.965     0.200
     2.561    44.765     0.200
     2.561    44.965     0.200
     3.022    52.765     0.200
     3.022    52.865     0.200
     3.274    56.965     0.200
     3.683    64.564     0.200
     0.212     5.322     0.200
     0.918    16.121     0.200
     0.949    17.322     0.200
     1.110    19.822     0.200
     1.143    21.021     0.200
     1.539    27.521     0.200
     1.842    32.521     0.200
     2.280    39.621     0.200
     2.753    48.121     0.200
     3.151    55.322     0.200
     4.025    70.322     0.200
     0.328     6.258     0.200
     1.182    21.258     0.200
     1.700    29.758     0.200
     1.701    30.355     0.200
     2.058    36.355     0.200
     2.212    38.855     0.200
     2.315    40.656     0.200
     2.430    42.758     0.200
     2.608    46.059     0.200
     2.828    49.059     0.200
     3.124    54.855     0.200
     0.206     4.168     0.200
     0.598    11.867     0.200
     1.020    17.770     0.200
     1.353    24.566     0.200
     1.353    24.867     0.200
     1.640    29.969     0.200
     1.640    30.367     0.200
     1.890    34.367     0.200
     2.269    39.566     0.200
     2.269    40.367     0.200
     2.573    45.469     0.200
     2.573    45.270     0.200
     2.606    45.770     0.200
     3.065    53.969     0.200
     3.065    53.770     0.200
     0.259     6.343     0.200
     0.648    12.343     0.200
     1.025    18.243     0.200
     1.163    20.743     0.200
     1.407    24.443     0.200
     1.463    27.243     0.200
     1.482    27.843     0.200
     1.821    32.343     0.200
     3.004    52.343     0.200
     3.229    56.943     0.200
     0.302     6.429     0.200
     0.533    10.929     0.200
     0.929    16.629     0.200
     1.243    23.429     0.200
     1.379    25.429     0.200
     1.479    26.829     0.200
     1.793    32.029     0.200
     2.095    36.829     0.200
     3.605    62.229     0.200
     0.245     4.531     0.200
     0.245     5.031     0.200
     0.641    12.438     0.200
     1.308    23.836     0.200
     1.308    23.734     0.200
     1.642    28.438     0.200
     1.642    28.836     0.200
     1.785    31.938     0.200
     1.820    32.938     0.200
     2.175    38.336     0.200
     2.307    40.938     0.200
     2.327    41.234     0.200
     2.510    44.336     0.200
     2.574    45.133     0.200
     2.715    46.938     0.200
     2.715    47.133     0.200
     0.347     6.207     0.200
     0.347     6.707     0.200
     0.503    10.008     0.200
     0.503    10.609     0.200
     1.687    29.410     0.200
     1.695    30.707     0.200
     2.034    35.508     0.200
     2.308    40.410     0.200
     2.417    42.809     0.200
     2.612    46.109     0.200
     2.855    48.008     0.200
     3.405    59.809     0.200
     0.108     4.121     0.200
     0.108     3.320     0.200
     0.807    14.922     0.200
     1.440    25.621     0.200
     1.440    25.520     0.200
     1.492    26.422     0.200
     1.492    25.621     0.200
     1.954    35.020     0.200
     2.246    39.723     0.200
     2.246    39.520     0.200
     2.443    42.922     0.200
     2.643    45.320     0.200
     2.643    45.621     0.200
     3.569    62.223     0.200
     3.711    65.320     0.200
     0.328     6.604     0.200
     0.456     8.805     0.200
     0.620    12.404     0.200
     0.761    15.104     0.200
     0.895    16.703     0.200
     1.079    20.305     0.200
     1.079    20.203     0.200
     1.303    23.404     0.200
     1.303    23.703     0.200
     1.303    24.504     0.200
     1.607    29.305     0.200
     2.569    44.805     0.200
     2.569    45.805     0.200
     4.060    71.904     0.200
     0.226     6.062     0.200
     0.643    11.562     0.200
     0.938    17.969     0.200
     1.059    19.469     0.200
     1.201    21.664     0.200
     1.386    24.266     0.200
     1.498    27.367     0.200
     1.522    27.867     0.200
     2.496    43.367     0.200
     3.554    62.367     0.200
     0.311     6.711     0.200
     0.540    10.812     0.200
     0.914    16.609     0.200
     1.265    24.016     0.200
     1.499    26.914     0.200
     1.499    27.312     0.200
     1.852    34.812     0.200
     2.073    36.914     0.200
     2.073    36.609     0.200
     2.332    41.609     0.200
     2.840    50.516     0.200
     2.858    50.516     0.200
     3.483    60.711     0.200
     0.751    13.699     0.200
     0.751    13.899     0.200
     0.752    14.599     0.200
     0.798    14.899     0.200
     1.624    29.199     0.200
     1.624    30.000     0.200
     1.900    34.399     0.200
     1.900    36.000     0.200
     1.944    34.899     0.200
     1.944    36.899     0.200
     2.831    50.399     0.200
     2.879    51.000     0.200
     3.213    56.199     0.200
     3.492    61.899     0.200
     0.171     3.777     0.200
     0.739    14.277     0.200
     0.761    13.676     0.200
     0.761    13.777     0.200
     0.795    14.676     0.200
     1.392    25.375     0.200
     1.614    29.078     0.200
     1.614    28.977     0.200
     1.852    34.375     0.200
     1.895    35.277     0.200
     2.013    36.176     0.200
     2.013    35.777     0.200
     2.389    42.375     0.200
     2.833    50.375     0.200
     3.227    57.277     0.200
     4.155    73.375     0.200
     0.072     3.602     0.200
     0.814    15.500     0.200
     1.371    24.699     0.200
     1.396    24.402     0.200
     1.440    25.699     0.200
     2.009    35.602     0.200
     2.094    37.102     0.200
     2.322    40.602     0.200
     2.322    40.500     0.200
     2.331    41.301     0.200
     2.739    47.801     0.200
     2.779    47.000     0.200
     2.779    48.902     0.200
     2.817    49.602     0.200
     3.218    56.801     0.200
     3.579    61.699     0.200
     0.338     6.883     0.200
     0.824    15.477     0.200
     0.928    16.578     0.200
     1.414    26.180     0.200
     1.495    27.078     0.200
     1.823    33.680     0.200
     1.859    34.383     0.200
     1.859    34.078     0.200
     2.072    36.578     0.200
     2.072    37.078     0.200
     3.205    56.477     0.200
     3.455    60.977     0.200
     3.479    61.383     0.200
     3.586    63.180     0.200
     4.012    70.383     0.200
     0.208     4.984     0.200
     0.581    11.684     0.200
     0.669    12.883     0.200
     0.955    17.484     0.200
     0.955    17.281     0.200
     1.265    23.383     0.200
     1.424    25.582     0.200
     1.695    29.281     0.200
     1.734    31.082     0.200
     1.734    31.684     0.200
     1.989    36.184     0.200
     2.178    38.281     0.200
     2.474    43.781     0.200
     2.967    52.082     0.200
     3.382    59.184     0.200
     0.151     3.328     0.200
     0.648    12.527     0.200
     0.974    17.430     0.200
     1.179    21.629     0.200
     1.399    25.129     0.200
     1.399    25.230     0.200
     1.627    29.930     0.200
     1.669    31.027     0.200
     1.710    31.730     0.200
     1.710    33.027     0.200
     2.239    39.328     0.200
     2.239    39.430     0.200
     2.570    44.930     0.200
     3.047    53.730     0.200
     3.047    53.230     0.200
     3.329    58.828     0.200
     0.130     3.512     0.200
     0.656    12.809     0.200
     0.925    16.109     0.200
     0.925    16.410     0.200
     1.148    21.609     0.200
     1.232    22.809     0.200
     1.448    25.910     0.200
     1.558    28.211     0.200
     2.185    37.910     0.200
     2.522    44.609     0.200
     2.522    44.711     0.200
     2.699    47.211     0.200
     3.310    56.910     0.200
     3.993    70.109     0.200
     0.289     6.230     0.200
     0.467     8.629     0.200
     0.657    12.730     0.200
     0.740    14.031     0.200
     1.075    20.031     0.200
     1.277    23.430     0.200
     1.314    23.430     0.200
     1.317    24.629     0.200
     2.300    40.828     0.200
     2.592    45.129     0.200
     2.867    50.629     0.200
     3.510    59.828     0.200
     3.625    63.930     0.200
     3.994    69.930     0.200
     4.079    69.930     0.200
     5.856   101.629     0.200
     0.153     3.180     0.200
     0.586    11.277     0.200
     0.644    12.379     0.200
     0.973    17.480     0.200
     0.973    17.680     0.200
     1.096    20.379     0.200
     1.400    25.277     0.200
     1.512    27.379     0.200
     1.672    30.680     0.200
     1.672    30.980     0.200
     1.712    32.078     0.200
     1.911    34.578     0.200
     2.236    39.277     0.200
     2.565    44.879     0.200
     3.043    53.277     0.200
     3.332    58.277     0.200
     5.512    96.680     0.200
     0.176     4.016     0.200
     0.889    16.711     0.200
     1.097    20.016     0.200
     1.108    21.312     0.200
     1.392    25.211     0.200
     1.392    26.312     0.200
     1.491    27.211     0.200
     1.599    29.109     0.200
     1.649    30.516     0.200
     1.720    32.516     0.200
     1.830    33.109     0.200
     2.289    40.211     0.200
     2.733    48.016     0.200
     2.856    49.312     0.200
     0.294     6.070     0.200
     0.468     8.672     0.200
     0.652    12.875     0.200
     0.740    14.273     0.200
     0.863    15.773     0.200
     1.072    20.172     0.200
     1.072    19.977     0.200
     1.211    22.070     0.200
     1.211    22.977     0.200
     1.278    23.477     0.200
     1.316    23.375     0.200
     1.577    28.172     0.200
     3.622    63.773     0.200
     0.320     7.003     0.200
     0.466     8.804     0.200
     1.172    20.804     0.200
     1.257    22.703     0.200
     1.257    23.503     0.200
     1.633    29.503     0.200
     1.636    29.403     0.200
     1.636    29.604     0.200
     2.457    43.003     0.200
     2.457    43.104     0.200
     3.239    57.104     0.200
     4.675    81.804     0.200
     4.675    82.403     0.200
     5.499    96.604     0.200
     0.161     3.586     0.200
     0.636    12.680     0.200
     0.586    11.484     0.200
     0.978    17.883     0.200
     1.093    20.586     0.200
     1.394    25.586     0.200
     1.394    25.383     0.200
     1.513    27.781     0.200
     1.628    29.281     0.200
     2.239    39.883     0.200
     2.239    39.680     0.200
     3.043    53.781     0.200
     3.043    54.086     0.200
     3.727    64.781     0.200
     3.727    65.484     0.200
     0.157     3.523     0.200
     0.575    10.820     0.200
     0.645    12.625     0.200
     0.981    17.625     0.200
     0.981    17.727     0.200
     1.086    21.023     0.200
     1.392    25.523     0.200
     1.501    27.523     0.200
     1.620    29.922     0.200
     2.246    39.523     0.200
     2.763    48.422     0.200
     3.733    65.727     0.200
     0.168     3.383     0.200
     0.631    12.383     0.200
     0.986    17.578     0.200
     0.986    17.680     0.200
     1.087    20.883     0.200
     1.387    25.281     0.200
     1.509    27.477     0.200
     1.622    29.977     0.200
     2.245    39.477     0.200
     3.048    53.883     0.200
     3.417    60.281     0.200
     0.164     3.562     0.200
     0.577    11.367     0.200
     0.637    12.469     0.200
     0.985    17.766     0.200
     0.985    17.867     0.200
     1.085    20.562     0.200
     1.388    25.062     0.200
     1.388    25.164     0.200
     1.504    27.562     0.200
     1.619    29.969     0.200
     2.247    39.664     0.200
     2.247    39.766     0.200
     2.759    48.562     0.200
     3.052    53.664     0.200
     3.052    54.266     0.200
     3.341    58.969     0.200
     3.362    59.266     0.200
     3.420    60.562     0.200
     3.735    64.664     0.200
     3.735    65.469     0.200
     0.148     3.020     0.200
     0.588    11.422     0.200
     0.648    12.820     0.200
     0.968    17.121     0.200
     1.100    20.719     0.200
     1.186    21.922     0.200
     1.405    25.621     0.200
     1.405    25.520     0.200
     1.514    27.621     0.200
     1.514    28.621     0.200
     1.634    29.422     0.200
     1.634    30.422     0.200
     1.915    34.719     0.200
     2.232    39.621     0.200
     2.232    39.320     0.200
     2.654    47.219     0.200
     3.951    69.922     0.200
     5.509    96.020     0.200
     0.143     3.082     0.200
     0.593    11.482     0.200
     0.652    12.882     0.200
     0.962    17.182     0.200
     1.106    21.382     0.200
     1.191    21.882     0.200
     1.191    23.082     0.200
     1.411    25.882     0.200
     1.518    27.682     0.200
     1.518    28.582     0.200
     1.639    30.582     0.200
     1.920    34.682     0.200
     2.226    39.182     0.200
     0.164     3.169     0.200
     0.573    11.069     0.200
     0.638    12.169     0.200
     0.638    12.469     0.200
     0.638    13.169     0.200
     0.988    17.469     0.200
     1.081    20.569     0.200
     1.081    21.669     0.200
     1.170    21.569     0.200
     1.170    22.369     0.200
     1.385    25.369     0.200
     1.385    25.569     0.200
     1.500    27.469     0.200
     1.615    29.169     0.200
     1.615    30.269     0.200
     1.898    34.769     0.200
     2.251    39.569     0.200
     2.576    45.569     0.200
     3.056    54.269     0.200
     3.359    59.069     0.200
     4.850    83.569     0.200
     0.155     3.219     0.200
     0.578    11.020     0.200
     0.645    12.520     0.200
     1.394    25.219     0.200
     1.394    25.320     0.200
     1.504    27.621     0.200
     1.622    29.219     0.200
     1.622    30.320     0.200
     1.664    30.820     0.200
     1.664    31.219     0.200
     1.904    34.820     0.200
     2.244    39.621     0.200
     2.573    44.820     0.200
     3.051    54.121     0.200
     3.333    57.020     0.200
     0.170     2.691     0.200
     0.637    12.191     0.200
     1.889    34.094     0.200
     1.889    34.395     0.200
     2.585    45.992     0.200
     2.625    46.395     0.200
     0.163     3.412     0.200
     0.637    12.412     0.200
     0.984    17.713     0.200
     1.389    25.014     0.200
     1.505    27.514     0.200
     1.621    29.912     0.200
     1.904    34.412     0.200
     2.245    39.613     0.200
     0.152     3.195     0.200
     0.613    11.695     0.200
     0.637    12.293     0.200
     0.955    17.094     0.200
     1.120    21.094     0.200
     1.417    25.793     0.200
     1.539    28.094     0.200
     1.655    30.395     0.200
     1.736    32.895     0.200
     2.211    38.996     0.200
     4.350    76.496     0.200
     0.156     3.384     0.200
     0.595    11.384     0.200
     0.638    12.584     0.200
     0.969    17.084     0.200
     0.969    17.384     0.200
     1.103    20.684     0.200
     1.404    25.284     0.200
     1.522    27.784     0.200
     1.638    30.384     0.200
     1.921    34.584     0.200
     2.228    39.284     0.200
     3.034    53.284     0.200
     3.034    53.684     0.200
     3.336    58.884     0.200
     5.247    91.784     0.200
     0.241     4.828     0.200
     0.241     4.930     0.200
     0.630    12.430     0.200
     1.287    23.531     0.200
     1.635    28.430     0.200
     1.813    32.430     0.200
     1.813    33.531     0.200
     2.307    40.828     0.200
     2.511    44.328     0.200
     2.562    44.430     0.200
     4.712    80.734     0.200
     0.124     4.324     0.200
     0.801    14.223     0.200
     0.801    14.324     0.200
     0.909    17.023     0.200
     1.243    22.926     0.200
     1.610    28.723     0.200
     1.740    31.023     0.200
     1.789    32.324     0.200
     1.789    32.824     0.200
     1.972    34.824     0.200
     2.147    37.223     0.200
     2.616    45.723     0.200
     2.823    49.926     0.200
     0.167     3.402     0.200
     0.633    12.402     0.200
     0.986    17.602     0.200
     1.086    20.602     0.200
     1.086    21.703     0.200
     1.387    25.102     0.200
     1.387    26.102     0.200
     1.507    27.402     0.200
     1.507    28.402     0.200
     1.621    29.902     0.200
     1.662    30.801     0.200
     1.662    30.500     0.200
     1.904    34.402     0.200
     2.246    39.703     0.200
     3.050    53.801     0.200
     3.050    54.000     0.200
     3.362    59.602     0.200
     3.418    60.602     0.200
     3.933    69.500     0.200
     0.334     6.494     0.200
     0.482     9.594     0.200
     0.982    17.494     0.200
     1.208    23.494     0.200
     1.702    31.194     0.200
     1.761    31.494     0.200
     1.797    32.494     0.200
     2.136    37.994     0.200
     2.136    38.194     0.200
     2.369    41.194     0.200
     2.369    40.994     0.200
     2.893    51.294     0.200
     0.344     7.414     0.200
     0.858    15.816     0.200
     0.827    15.715     0.200
     1.340    23.816     0.200
     1.356    24.816     0.200
     1.492    26.215     0.200
     2.154    37.414     0.200
     2.734    47.414     0.200
     2.760    48.617     0.200
     2.796    48.816     0.200
     2.796    49.117     0.200
     3.405    59.617     0.200
     3.405    59.215     0.200
     4.016    69.117     0.200
     4.214    74.016     0.200
     0.332     6.869     0.200
     0.641    11.769     0.200
     0.978    18.069     0.200
     1.388    25.769     0.200
     1.427    25.669     0.200
     1.452    26.769     0.200
     2.578    45.369     0.200
     0.151     3.355     0.200
     0.646    12.555     0.200
     0.646    12.656     0.200
     0.971    17.855     0.200
     0.971    17.555     0.200
     1.402    25.258     0.200
     1.402    26.457     0.200
     1.513    27.656     0.200
     1.632    29.855     0.200
     1.674    30.957     0.200
     1.674    31.156     0.200
     2.234    39.457     0.200
     2.565    45.457     0.200
     2.651    46.957     0.200
     3.041    53.758     0.200
     3.041    53.957     0.200
     3.330    58.355     0.200
     3.721    65.156     0.200
     3.949    69.355     0.200
     4.867    85.758     0.200
     0.150     3.391     0.200
     0.650    12.688     0.200
     0.974    17.391     0.200
     1.092    20.984     0.200
     1.399    25.289     0.200
     1.399    25.984     0.200
     1.504    27.586     0.200
     1.625    30.289     0.200
     2.241    39.484     0.200
     0.157     3.988     0.200
     0.645    12.988     0.200
     0.982    17.188     0.200
     1.086    20.588     0.200
     1.392    25.088     0.200
     1.501    27.188     0.200
     1.619    29.389     0.200
     1.661    30.488     0.200
     2.639    46.588     0.200
     0.308     6.623     0.200
     0.609    12.123     0.200
     0.835    15.123     0.200
     1.337    24.924     0.200
     1.579    28.223     0.200
     1.579    28.523     0.200
     1.790    32.223     0.200
     1.884    33.924     0.200
     1.922    35.424     0.200
     1.997    35.123     0.200
     2.775    49.023     0.200
     3.374    59.123     0.200
     3.563    62.623     0.200
     0.164     3.383     0.200
     0.634    12.383     0.200
     0.982    17.680     0.200
     1.090    20.586     0.200
     1.391    25.086     0.200
     1.510    27.586     0.200
     1.666    30.484     0.200
     2.242    39.586     0.200
     2.242    39.484     0.200
     2.566    45.484     0.200
     2.762    48.781     0.200
     3.046    53.586     0.200
     3.046    54.086     0.200
     3.342    59.180     0.200
     3.415    60.281     0.200
     3.937    69.484     0.200
     4.855    85.484     0.200
     4.855    85.586     0.200
     0.163     3.375     0.200
     0.637    12.477     0.200
     0.984    17.570     0.200
     0.984    17.672     0.200
     1.086    20.375     0.200
     1.389    25.172     0.200
     1.505    27.570     0.200
     1.662    31.172     0.200
     1.662    30.875     0.200
     2.246    39.570     0.200
     3.051    53.570     0.200
     3.051    54.070     0.200
     3.341    58.375     0.200
     3.363    59.070     0.200
     3.419    59.375     0.200
     3.734    64.773     0.200
     3.734    64.875     0.200
     3.935    69.570     0.200
     0.137     3.941     0.200
     0.782    15.043     0.200
     1.313    23.742     0.200
     1.402    24.543     0.200
     1.402    24.441     0.200
     2.059    35.742     0.200
     2.059    35.844     0.200
     2.313    40.344     0.200
     2.269    40.141     0.200
     2.288    40.141     0.200
     2.842    50.141     0.200
     2.842    50.242     0.200
     3.233    57.043     0.200
     4.336    76.141     0.200
     0.168     3.422     0.200
     0.633    12.320     0.200
     0.988    17.625     0.200
     1.084    20.625     0.200
     1.385    25.023     0.200
     1.385    26.125     0.200
     1.505    27.625     0.200
     1.660    30.820     0.200
     1.660    31.023     0.200
     2.248    39.422     0.200
     2.571    45.523     0.200
     2.756    48.922     0.200
     3.052    54.219     0.200
     3.346    59.125     0.200
     3.737    66.023     0.200
     0.166     3.559     0.200
     0.631    12.758     0.200
     0.983    17.758     0.200
     0.983    17.859     0.200
     1.090    20.660     0.200
     1.390    25.461     0.200
     1.390    25.359     0.200
     1.390    26.660     0.200
     1.667    31.660     0.200
     1.909    34.961     0.200
     2.241    39.859     0.200
     3.045    53.461     0.200
     0.200     4.074     0.200
     0.586    11.672     0.200
     0.966    17.375     0.200
     1.133    21.473     0.200
     1.133    22.773     0.200
     1.410    25.574     0.200
     1.410    25.473     0.200
     1.714    31.973     0.200
     1.967    36.273     0.200
     2.197    38.875     0.200
     2.671    47.074     0.200
     2.779    49.375     0.200
     2.988    53.172     0.200
     3.379    59.875     0.200
     3.390    60.074     0.200
     5.460    95.672     0.200
     0.187     3.875     0.200
     0.600    11.672     0.200
     0.950    16.977     0.200
     1.146    21.672     0.200
     1.146    22.477     0.200
     1.426    25.477     0.200
     1.426    26.672     0.200
     1.726    32.570     0.200
     1.977    35.977     0.200
     2.491    44.172     0.200
     3.364    59.570     0.200
     0.211     3.838     0.200
     0.576    11.438     0.200
     0.976    17.138     0.200
     1.127    21.138     0.200
     1.127    22.438     0.200
     1.401    25.338     0.200
     1.709    31.938     0.200
     1.964    35.838     0.200
     2.203    39.238     0.200
     2.663    47.138     0.200
     3.382    59.938     0.200
     3.382    59.638     0.200
     0.191     4.217     0.200
     0.595    11.817     0.200
     0.595    11.717     0.200
     0.965    17.417     0.200
     1.129    21.617     0.200
     1.129    22.817     0.200
     1.410    25.617     0.200
     1.410    27.017     0.200
     1.709    32.017     0.200
     1.960    36.217     0.200
     2.201    39.117     0.200
     2.506    44.817     0.200
     2.779    49.517     0.200
     4.867    84.717     0.200
     0.199     3.992     0.200
     0.588    11.391     0.200
     0.588    11.289     0.200
     0.960    17.090     0.200
     0.960    17.191     0.200
     1.417    25.492     0.200
     1.417    26.789     0.200
     1.722    32.090     0.200
     1.974    35.992     0.200
     2.190    38.789     0.200
     2.190    38.492     0.200
     2.678    47.191     0.200
     2.981    52.691     0.200
     2.981    52.992     0.200
     3.397    60.090     0.200
     3.397    60.191     0.200
     3.957    69.891     0.200
     4.872    84.590     0.200
     4.872    84.891     0.200
     5.452    95.992     0.200
     0.195     4.221     0.200
     0.591    11.721     0.200
     0.964    17.121     0.200
     1.133    21.121     0.200
     1.411    25.721     0.200
     1.411    25.621     0.200
     1.965    36.021     0.200
     2.197    39.121     0.200
     2.990    53.121     0.200
     2.990    52.921     0.200
     4.868    85.121     0.200
     0.193     3.879     0.200
     0.594    11.479     0.200
     0.960    17.180     0.200
     1.136    21.180     0.200
     1.415    25.279     0.200
     1.415    26.578     0.200
     1.576    28.680     0.200
     1.968    35.879     0.200
     2.194    39.078     0.200
     2.194    38.779     0.200
     2.498    43.879     0.200
     2.987    52.979     0.200
     3.395    60.078     0.200
     0.146     3.453     0.200
     0.651    12.652     0.200
     0.968    17.355     0.200
     1.099    20.453     0.200
     1.405    25.152     0.200
     1.511    27.355     0.200
     1.674    30.953     0.200
     1.674    30.652     0.200
     1.912    34.652     0.200
     2.234    39.355     0.200
     2.234    38.953     0.200
     2.567    44.754     0.200
     2.653    47.055     0.200
     3.042    53.355     0.200
     3.042    53.754     0.200
     3.720    65.453     0.200
     5.251    92.254     0.200
     0.277     5.383     0.200
     0.532    10.682     0.200
     1.026    19.682     0.200
     1.078    19.482     0.200
     1.078    19.283     0.200
     1.298    23.582     0.200
     1.875    34.182     0.200
     2.305    40.883     0.200
     2.573    45.682     0.200
     2.573    45.783     0.200
     2.559    44.582     0.200
     2.667    47.182     0.200
     3.085    54.582     0.200
     3.454    60.982     0.200
     3.456    59.982     0.200
     3.805    65.582     0.200
     0.632    12.625     0.200
     0.632    12.727     0.200
     0.972    17.625     0.200
     1.103    20.930     0.200
     1.401    25.531     0.200
     1.524    28.125     0.200
     1.680    31.227     0.200
     2.229    39.531     0.200
     2.772    48.625     0.200
     3.032    53.430     0.200
     3.342    59.125     0.200
     3.400    60.227     0.200
     3.377    59.898     0.200
     4.864    85.328     0.200
     0.627    12.305     0.200
     0.979    17.508     0.200
     1.096    20.406     0.200
     1.394    25.207     0.200
     1.394    26.406     0.200
     1.520    27.605     0.200
     1.673    30.406     0.200
     1.673    31.305     0.200
     1.917    34.707     0.200
     2.235    39.305     0.200
     2.235    39.406     0.200
     2.764    48.605     0.200
     3.038    53.906     0.200
     3.038    53.707     0.200
     3.406    60.207     0.200
     3.406    59.906     0.200
     3.369    59.508     0.200
     3.725    64.906     0.200
     4.351    76.508     0.200
     5.298    92.508     0.200
     0.306     5.984     0.200
     0.502    10.383     0.200
     0.576    11.188     0.200
     1.018    19.586     0.200
     1.018    20.484     0.200
     1.099    19.781     0.200
     1.278    23.188     0.200
     1.627    28.883     0.200
     1.875    34.188     0.200
     2.315    40.688     0.200
     2.568    45.188     0.200
     3.089    53.984     0.200
     3.817    66.688     0.200
     4.733    82.281     0.200
     0.276     5.844     0.200
     0.772    14.742     0.200
     0.834    15.641     0.200
     0.860    17.141     0.200
     0.892    17.141     0.200
     1.423    26.742     0.200
     1.588    28.344     0.200
     1.795    33.242     0.200
     1.810    33.141     0.200
     1.810    33.844     0.200
     2.674    47.641     0.200
     2.692    47.641     0.200
     0.176     3.582     0.200
     0.569    10.781     0.200
     0.629    12.180     0.200
     0.629    12.281     0.200
     0.998    17.781     0.200
     1.074    20.281     0.200
     1.375    25.383     0.200
     1.497    27.383     0.200
     1.651    30.883     0.200
     1.690    30.781     0.200
     1.894    34.180     0.200
     2.258    39.680     0.200
     2.625    45.980     0.200
     2.879    50.680     0.200
     3.061    54.180     0.200
     3.061    53.781     0.200
     3.352    58.480     0.200
     3.429    59.180     0.200
     3.429    59.883     0.200
     3.746    65.082     0.200
     4.839    85.082     0.200
     0.286     5.768     0.200
     0.515    10.268     0.200
     0.729    13.967     0.200
     0.973    17.268     0.200
     1.423    25.367     0.200
     1.423    26.566     0.200
     2.155    37.867     0.200
     2.924    51.566     0.200
     0.171     4.109     0.200
     0.597    11.406     0.200
     0.622    12.406     0.200
     0.979    17.609     0.200
     0.979    17.508     0.200
     1.098    20.809     0.200
     1.194    22.109     0.200
     1.394    25.207     0.200
     1.525    27.406     0.200
     1.525    27.906     0.200
     1.676    31.207     0.200
     1.676    29.707     0.200
     1.921    34.809     0.200
     2.232    39.207     0.200
     2.646    46.809     0.200
     3.034    53.109     0.200
     3.034    53.406     0.200
     3.352    57.609     0.200
     3.939    67.609     0.200
     4.856    84.309     0.200
     4.856    85.406     0.200
     0.344     6.859     0.200
     0.592    11.859     0.200
     0.576    10.359     0.200
     0.576    11.461     0.200
     0.667    12.961     0.200
     0.958    17.258     0.200
     0.958    17.461     0.200
     1.212    22.359     0.200
     1.255    23.258     0.200
     1.419    25.156     0.200
     1.808    32.555     0.200
     2.329    40.961     0.200
     2.455    43.156     0.200
     2.666    46.656     0.200
     2.927    51.555     0.200
     3.434    60.156     0.200
     4.428    75.656     0.200
     6.859   118.055     0.200
     0.173     5.906     0.200
     0.699    13.207     0.200
     0.764    13.707     0.200
     0.764    13.406     0.200
     0.960    18.305     0.200
     0.960    18.406     0.200
     1.285    24.008     0.200
     1.551    27.707     0.200
     1.659    29.105     0.200
     1.776    31.707     0.200
     1.826    32.305     0.200
     1.898    33.906     0.200
     1.999    35.105     0.200
     2.122    37.008     0.200
     2.122    36.906     0.200
     2.617    45.406     0.200
     2.867    50.305     0.200
     2.998    51.805     0.200
     2.998    51.605     0.200
     3.127    54.805     0.200
     3.560    62.605     0.200
     3.607    63.008     0.200
     4.209    73.605     0.200
     0.321     6.191     0.200
     0.602    11.592     0.200
     0.620    12.391     0.200
     0.620    12.492     0.200
     0.632    12.592     0.200
     0.933    17.291     0.200
     1.219    22.592     0.200
     1.448    25.592     0.200
     1.448    25.791     0.200
     1.509    27.592     0.200
     1.777    32.191     0.200
     2.171    38.592     0.200
     2.303    40.592     0.200
     2.701    47.191     0.200
     2.921    50.791     0.200
     2.898    51.291     0.200
     3.470    60.992     0.200
     3.470    60.791     0.200
     4.198    73.691     0.200
     4.404    77.291     0.200
     0.426     9.121     0.200
     0.426     9.223     0.200
     0.435     8.023     0.200
     0.545    10.223     0.200
     0.918    17.824     0.200
     1.149    20.324     0.200
     1.149    21.723     0.200
     1.233    22.121     0.200
     1.233    21.922     0.200
     1.456    26.422     0.200
     1.507    27.824     0.200
     1.801    32.723     0.200
     2.031    36.223     0.200
     3.181    55.922     0.200
     3.132    55.223     0.200
     3.556    62.922     0.200
     4.148    72.023     0.200
     4.148    72.324     0.200
     4.599    80.621     0.200
     4.599    81.023     0.200
     5.655    99.223     0.200
     0.144     3.411     0.200
     0.582    11.011     0.200
     0.656    13.011     0.200
     0.656    13.211     0.200
     0.969    17.611     0.200
     0.969    17.111     0.200
     1.405    25.011     0.200
     1.405    25.411     0.200
     1.507    27.511     0.200
     1.714    31.711     0.200
     1.909    34.511     0.200
     2.236    39.411     0.200
     2.652    46.511     0.200
     3.952    69.311     0.200
     3.952    68.311     0.200
     7.303   126.311     0.200
     0.160     3.539     0.200
     0.572    10.938     0.200
     0.644    13.242     0.200
     0.985    18.039     0.200
     1.170    21.641     0.200
     1.170    23.039     0.200
     1.389    25.039     0.200
     1.498    27.539     0.200
     1.658    29.742     0.200
     1.699    32.039     0.200
     1.898    34.438     0.200
     2.578    45.344     0.200
     2.759    49.039     0.200
     2.890    51.242     0.200
     3.057    53.641     0.200
     3.336    58.438     0.200
     3.737    65.438     0.200
     4.095    71.539     0.200
     4.853    85.141     0.200
     4.853    85.344     0.200
     0.156     3.699     0.200
     0.575    11.100     0.200
     0.646    13.400     0.200
     0.980    17.600     0.200
     0.980    17.900     0.200
     1.173    21.699     0.200
     1.393    25.100     0.200
     1.501    27.699     0.200
     1.662    30.100     0.200
     1.662    31.100     0.200
     1.703    32.100     0.200
     1.901    34.699     0.200
     2.246    39.699     0.200
     2.764    48.699     0.200
     3.053    54.100     0.200
     3.053    53.799     0.200
     3.421    60.400     0.200
     4.858    85.500     0.200
     0.156     3.242     0.200
     0.567    10.648     0.200
     0.651    12.945     0.200
     0.985    17.445     0.200
     0.985    18.242     0.200
     1.164    21.344     0.200
     1.389    24.648     0.200
     1.697    31.945     0.200
     1.893    33.547     0.200
     2.253    39.445     0.200
     2.253    39.344     0.200
     2.585    45.844     0.200
     2.635    46.844     0.200
     3.062    53.844     0.200
     3.329    57.242     0.200
     3.739    65.047     0.200
     4.855    85.547     0.200
     5.530    97.344     0.200
     0.289     6.445     0.200
     0.621    11.250     0.200
     0.621    11.047     0.200
     0.840    16.250     0.200
     1.466    26.344     0.200
     1.466    27.250     0.200
     1.525    27.547     0.200
     1.759    31.148     0.200
     1.759    31.344     0.200
     1.871    32.648     0.200
     2.290    40.148     0.200
     2.624    46.250     0.200
     2.704    47.547     0.200
     3.151    53.148     0.200
     3.353    59.047     0.200
     3.738    65.250     0.200
     0.073     3.738     0.200
     0.671    12.439     0.200
     0.723    14.338     0.200
     0.857    15.439     0.200
     1.268    23.139     0.200
     1.517    26.439     0.200
     1.517    26.738     0.200
     2.134    36.639     0.200
     2.507    43.838     0.200
     2.507    44.439     0.200
     2.763    48.639     0.200
     2.958    51.439     0.200
     3.017    51.238     0.200
     3.017    53.238     0.200
     3.241    55.338     0.200
     3.614    63.639     0.200
     4.063    71.139     0.200
     4.981    87.539     0.200
     5.423    95.039     0.200
     0.321     6.430     0.200
     0.430     7.625     0.200
     0.430     9.125     0.200
     0.639    12.828     0.200
     0.780    14.727     0.200
     1.107    20.125     0.200
     1.277    22.430     0.200
     1.358    24.930     0.200
     1.396    26.125     0.200
     1.615    29.125     0.200
     2.477    42.523     0.200
     2.551    44.227     0.200
     2.829    49.430     0.200
     3.344    58.828     0.200
     4.040    70.023     0.200
     4.578    77.828     0.200
     5.058    87.023     0.200
     0.323     6.441     0.200
     0.323     7.340     0.200
     0.431     7.738     0.200
     0.637    12.840     0.200
     0.780    14.840     0.200
     0.900    16.641     0.200
     1.106    20.238     0.200
     1.278    22.539     0.200
     1.358    25.340     0.200
     1.396    25.641     0.200
     1.396    26.840     0.200
     1.616    28.641     0.200
     1.942    34.941     0.200
     2.337    41.039     0.200
     2.551    44.238     0.200
     3.497    61.441     0.200
     4.040    69.641     0.200
     0.331     7.723     0.200
     0.331     7.223     0.200
     0.501     8.923     0.200
     0.629    11.223     0.200
     0.955    18.223     0.200
     1.141    20.022     0.200
     1.169    21.022     0.200
     1.264    22.622     0.200
     1.545    28.322     0.200
     1.545    28.423     0.200
     1.544    26.723     0.200
     1.856    33.223     0.200
     2.038    36.122     0.200
     2.419    41.923     0.200
     2.423    42.822     0.200
     2.574    44.822     0.200
     2.574    45.022     0.200
     2.667    46.223     0.200
     3.147    55.122     0.200
     3.125    54.022     0.200
     3.661    63.522     0.200
     3.938    68.423     0.200
     4.258    74.022     0.200
     0.174     4.711     0.200
     0.719    12.914     0.200
     0.813    15.016     0.200
     0.788    15.711     0.200
     1.350    24.312     0.200
     1.408    25.211     0.200
     1.654    29.914     0.200
     1.654    28.812     0.200
     1.720    31.414     0.200
     1.921    34.312     0.200
     1.989    35.414     0.200
     1.967    34.914     0.200
     1.967    37.312     0.200
     2.391    41.516     0.200
     2.512    44.016     0.200
     3.024    53.516     0.200
     3.179    54.711     0.200
     4.197    73.914     0.200
     4.321    76.117     0.200
     5.282    92.914     0.200
     0.311     6.308     0.200
     0.642    12.608     0.200
     0.788    14.908     0.200
     0.903    16.808     0.200
     1.149    21.208     0.200
     1.183    22.308     0.200
     1.475    27.008     0.200
     1.480    25.708     0.200
     1.480    26.208     0.200
     1.743    31.508     0.200
     2.736    47.008     0.200
     2.955    50.608     0.200
     0.190     4.426     0.200
     0.585    11.023     0.200
     0.608    12.523     0.200
     0.999    17.926     0.200
     1.181    21.523     0.200
     1.373    24.125     0.200
     1.373    24.926     0.200
     1.514    26.926     0.200
     1.659    29.926     0.200
     1.907    34.625     0.200
     2.250    38.926     0.200
     2.234    39.125     0.200
     2.560    45.023     0.200
     2.744    48.125     0.200
     2.880    50.625     0.200
     3.048    53.125     0.200
     3.369    59.324     0.200
     0.194     4.594     0.200
     0.588    11.094     0.200
     0.602    12.594     0.200
     1.001    17.996     0.200
     1.184    21.695     0.200
     1.372    24.297     0.200
     1.517    26.797     0.200
     1.517    27.695     0.200
     1.696    30.094     0.200
     1.696    31.695     0.200
     2.249    38.996     0.200
     3.046    53.496     0.200
     0.145     3.422     0.200
     0.628    11.723     0.200
     0.628    12.723     0.200
     0.642    13.023     0.200
     0.940    16.422     0.200
     1.136    21.223     0.200
     1.225    22.422     0.200
     1.432    25.320     0.200
     1.553    27.723     0.200
     1.553    28.320     0.200
     1.712    30.621     0.200
     1.752    30.523     0.200
     1.752    32.320     0.200
     2.196    38.723     0.200
     2.292    40.223     0.200
     2.525    44.621     0.200
     2.938    51.621     0.200
     3.326    58.422     0.200
     3.409    59.820     0.200
     0.162     3.281     0.200
     0.573    10.781     0.200
     0.641    12.980     0.200
     0.986    17.582     0.200
     1.170    21.480     0.200
     1.387    24.684     0.200
     1.387    25.980     0.200
     1.499    27.383     0.200
     1.658    30.281     0.200
     2.250    39.383     0.200
     2.635    46.781     0.200
     2.758    48.281     0.200
     3.056    53.781     0.200
     3.338    58.883     0.200
     4.852    84.383     0.200
     0.166     3.371     0.200
     0.570    10.672     0.200
     0.638    12.871     0.200
     0.990    17.672     0.200
     1.079    20.172     0.200
     1.168    21.371     0.200
     1.383    24.672     0.200
     1.613    29.871     0.200
     1.654    30.270     0.200
     1.895    34.270     0.200
     2.254    39.371     0.200
     2.237    39.770     0.200
     3.059    53.871     0.200
     3.357    58.969     0.200
     3.741    65.969     0.200
     0.343     7.990     0.200
     0.620    11.690     0.200
     0.698    12.890     0.200
     0.922    16.590     0.200
     1.352    23.890     0.200
     1.438    25.390     0.200
     1.438    26.090     0.200
     1.487    25.590     0.200
     1.487    26.291     0.200
     1.720    31.291     0.200
     2.209    38.291     0.200
     2.450    42.090     0.200
     2.633    45.590     0.200
     2.904    50.590     0.200
     3.338    58.190     0.200
     3.436    59.490     0.200
     4.157    72.990     0.200
     4.348    75.891     0.200
     4.684    80.891     0.200
     5.671    98.490     0.200
     0.159     3.289     0.200
     0.571    10.789     0.200
     0.645    12.992     0.200
     0.985    17.688     0.200
     1.082    21.086     0.200
     1.388    24.789     0.200
     1.497    27.492     0.200
     1.698    32.492     0.200
     1.896    34.391     0.200
     2.251    39.492     0.200
     2.636    46.789     0.200
     3.058    53.789     0.200
     0.167     3.375     0.200
     0.575    10.875     0.200
     0.635    12.977     0.200
     0.988    17.773     0.200
     0.988    17.672     0.200
     1.082    20.172     0.200
     1.385    24.773     0.200
     1.502    27.477     0.200
     1.658    30.977     0.200
     1.658    30.570     0.200
     1.698    30.477     0.200
     1.698    31.977     0.200
     1.900    34.477     0.200
     2.250    39.570     0.200
     2.634    46.070     0.200
     2.756    47.977     0.200
     2.756    48.977     0.200
     3.055    53.977     0.200
     3.344    59.273     0.200
     4.337    76.070     0.200
     4.849    85.570     0.200
     5.524    97.375     0.200
     7.546   131.273     0.200
     0.273     5.859     0.200
     0.538    11.562     0.200
     0.746    14.262     0.200
     0.943    16.660     0.200
     1.453    26.262     0.200
     1.676    29.660     0.200
     1.676    30.660     0.200
     1.756    31.660     0.200
     1.816    31.461     0.200
     1.816    34.562     0.200
     2.127    37.062     0.200
     2.336    41.062     0.200
     0.181     3.570     0.200
     0.470     9.070     0.200
     0.817    16.168     0.200
     1.001    17.770     0.200
     1.365    25.270     0.200
     1.413    25.770     0.200
     1.545    27.969     0.200
     1.593    29.168     0.200
     1.593    29.969     0.200
     1.657    30.867     0.200
     1.791    32.070     0.200
     1.791    32.668     0.200
     2.330    40.770     0.200
     2.735    48.668     0.200
     2.780    48.969     0.200
     2.880    50.367     0.200
     3.202    56.270     0.200
     3.174    55.969     0.200
     3.360    59.668     0.200
     4.288    75.570     0.200
     8.297   139.570     0.200
     0.114     3.602     0.200
     0.588    11.297     0.200
     0.684    13.797     0.200
     0.946    16.797     0.200
     1.114    21.602     0.200
     1.429    25.500     0.200
     1.509    27.000     0.200
     1.642    29.500     0.200
     1.685    30.602     0.200
     1.731    32.195     0.200
     1.916    33.000     0.200
     1.916    34.797     0.200
     2.223    38.195     0.200
     2.573    44.695     0.200
     2.800    47.898     0.200
     3.039    53.195     0.200
     3.705    64.695     0.200
     0.069     3.824     0.200
     0.685    12.824     0.200
     0.736    14.523     0.200
     0.838    15.125     0.200
     1.221    22.824     0.200
     1.535    26.824     0.200
     1.597    28.625     0.200
     1.746    31.523     0.200
     2.119    36.723     0.200
     2.945    51.723     0.200
     0.448     8.617     0.200
     0.662    13.518     0.200
     1.094    20.617     0.200
     1.094    20.817     0.200
     1.216    23.317     0.200
     1.292    24.317     0.200
     1.296    24.117     0.200
     1.333    25.518     0.200
     1.374    26.417     0.200
     1.923    35.718     0.200
     1.923    35.617     0.200
     2.576    45.417     0.200
     2.857    50.518     0.200
     3.493    61.617     0.200
     3.644    63.718     0.200
     4.297    75.917     0.200
     5.051    87.817     0.200
     0.306     6.369     0.200
     0.415     8.369     0.200
     1.152    21.168     0.200
     1.227    23.068     0.200
     1.345    24.969     0.200
     1.442    26.469     0.200
     1.483    27.469     0.200
     1.731    31.168     0.200
     1.731    32.168     0.200
     2.425    43.369     0.200
     0.309     5.574     0.200
     0.391     7.574     0.200
     0.657    13.074     0.200
     1.227    23.174     0.200
     1.321    24.475     0.200
     1.427    26.775     0.200
     1.711    31.574     0.200
     0.303     5.605     0.200
     0.397     7.504     0.200
     0.656    13.207     0.200
     0.903    17.105     0.200
     1.150    20.406     0.200
     1.233    22.207     0.200
     1.328    24.105     0.200
     1.433    26.105     0.200
     1.476    27.805     0.200
     1.520    28.805     0.200
     1.718    30.504     0.200
     1.718    31.207     0.200
     2.432    42.906     0.200
     0.176     3.672     0.200
     0.586    11.078     0.200
     0.989    18.078     0.200
     1.087    20.273     0.200
     1.384    24.977     0.200
     1.384    26.273     0.200
     1.514    27.672     0.200
     1.624    30.078     0.200
     1.665    31.375     0.200
     1.665    31.273     0.200
     1.910    34.875     0.200
     2.244    39.977     0.200
     3.045    54.078     0.200
     3.413    60.477     0.200
     0.164     3.520     0.200
     0.571    10.820     0.200
     0.640    13.020     0.200
     0.988    17.721     0.200
     1.385    25.221     0.200
     1.498    27.520     0.200
     1.614    29.520     0.200
     1.896    33.520     0.200
     1.896    34.520     0.200
     2.252    39.721     0.200
     3.058    54.020     0.200
     3.740    65.619     0.200
     0.299     6.559     0.200
     0.588    10.961     0.200
     0.880    17.262     0.200
     0.943    17.262     0.200
     1.789    32.059     0.200
     1.856    32.660     0.200
     1.840    32.762     0.200
     2.269    40.059     0.200
     0.295     6.359     0.200
     0.586    10.758     0.200
     0.586    10.656     0.200
     0.939    17.258     0.200
     1.485    26.758     0.200
     1.487    26.758     0.200
     1.859    32.457     0.200
     1.834    32.559     0.200
     2.307    40.258     0.200
     2.264    39.859     0.200
     2.705    47.457     0.200
     3.159    55.656     0.200
     3.333    58.758     0.200
     4.320    75.156     0.200
     5.163    90.656     0.200
     0.431     9.535     0.200
     0.489     9.435     0.200
     0.512     9.635     0.200
     1.081    19.035     0.200
     1.299    22.734     0.200
     1.299    23.635     0.200
     1.408    25.835     0.200
     1.410    26.635     0.200
     1.962    35.335     0.200
     1.962    34.935     0.200
     2.351    40.635     0.200
     2.447    42.734     0.200
     2.687    46.535     0.200
     3.063    54.035     0.200
     3.246    57.035     0.200
     3.643    62.234     0.200
     4.008    70.335     0.200
     4.008    70.135     0.200
     4.080    71.035     0.200
     4.534    78.135     0.200
     0.270     5.645     0.200
     0.766    13.445     0.200
     1.526    27.543     0.200
     1.708    30.543     0.200
     1.783    31.844     0.200
     1.836    32.844     0.200
     1.919    35.145     0.200
     1.986    35.246     0.200
     2.146    37.445     0.200
     3.040    53.445     0.200
     0.145     3.297     0.200
     0.573    10.797     0.200
     0.974    17.594     0.200
     0.974    17.492     0.200
     1.089    20.297     0.200
     1.089    21.594     0.200
     1.400    24.797     0.200
     1.400    25.992     0.200
     1.497    27.391     0.200
     1.621    28.891     0.200
     1.621    29.891     0.200
     1.663    30.391     0.200
     1.706    30.594     0.200
     1.706    31.891     0.200
     1.899    34.391     0.200
     2.245    39.391     0.200
     2.771    49.094     0.200
     3.055    53.992     0.200
     3.055    53.492     0.200
     3.320    58.797     0.200
     3.422    60.297     0.200
     3.422    59.992     0.200
     0.282     6.316     0.200
     0.597    10.719     0.200
     0.927    16.918     0.200
     1.778    31.816     0.200
     1.822    32.418     0.200
     1.872    32.918     0.200
     1.995    35.617     0.200
     2.252    39.719     0.200
     2.317    40.719     0.200
     2.717    47.719     0.200
     3.346    58.520     0.200
     0.158     3.309     0.200
     0.570    10.707     0.200
     0.984    17.605     0.200
     0.984    18.207     0.200
     1.082    20.207     0.200
     1.389    24.605     0.200
     1.389    25.906     0.200
     1.496    27.309     0.200
     1.657    30.406     0.200
     2.251    39.508     0.200
     2.636    46.809     0.200
     3.058    53.605     0.200
     0.151     3.203     0.200
     0.571    10.703     0.200
     0.979    17.500     0.200
     1.086    20.703     0.200
     1.394    24.902     0.200
     1.394    26.102     0.200
     1.496    27.402     0.200
     1.660    30.602     0.200
     1.702    31.902     0.200
     2.248    39.703     0.200
     3.057    54.203     0.200
     3.733    65.301     0.200
     0.276     5.943     0.200
     0.411     7.744     0.200
     0.705    13.543     0.200
     0.729    14.043     0.200
     0.768    15.145     0.200
     0.875    16.645     0.200
     1.431    26.844     0.200
     1.665    30.344     0.200
     1.684    31.344     0.200
     2.742    48.943     0.200
     2.789    49.744     0.200
     0.310     6.098     0.200
     0.409     8.797     0.200
     0.493     9.396     0.200
     0.740    13.598     0.200
     0.986    18.098     0.200
     1.184    21.797     0.200
     1.417    26.396     0.200
     1.671    30.396     0.200
     1.735    31.598     0.200
     1.771    32.396     0.200
     0.361     7.844     0.200
     0.719    13.039     0.200
     0.964    17.945     0.200
     1.457    26.641     0.200
     1.706    29.445     0.200
     1.706    30.844     0.200
     0.343     6.598     0.200
     0.503     9.797     0.200
     0.939    18.398     0.200
     1.162    20.797     0.200
     1.211    21.695     0.200
     1.211    22.695     0.200
     1.429    26.496     0.200
     1.487    27.695     0.200
     1.524    28.297     0.200
     1.524    28.898     0.200
     1.550    28.496     0.200
     2.393    41.898     0.200
     2.470    43.598     0.200
     2.645    46.195     0.200
     2.581    45.398     0.200
     2.721    46.996     0.200
     4.672    80.996     0.200
     0.219     4.693     0.200
     0.342     6.594     0.200
     0.495     9.395     0.200
     0.594    11.295     0.200
     0.736    14.594     0.200
     1.038    19.795     0.200
     1.283    23.795     0.200
     1.339    24.094     0.200
     1.348    24.594     0.200
     3.572    62.395     0.200
     0.212     4.684     0.200
     0.534    10.184     0.200
     1.041    18.785     0.200
     1.031    19.586     0.200
     1.333    23.785     0.200
     1.333    24.586     0.200
     1.567    28.484     0.200
     1.608    30.484     0.200
     1.646    28.883     0.200
     1.646    30.984     0.200
     0.120     4.320     0.200
     0.675    12.320     0.200
     0.884    15.520     0.200
     1.489    25.820     0.200
     1.489    26.619     0.200
     1.724    30.219     0.200
     1.724    31.820     0.200
     1.767    31.520     0.200
     1.767    31.820     0.200
     2.141    36.920     0.200
     2.141    36.719     0.200
     2.349    41.420     0.200
     2.488    43.719     0.200
     2.742    48.420     0.200
     2.952    52.119     0.200
     2.996    52.420     0.200
     3.289    58.020     0.200
     3.289    57.719     0.200
     3.466    60.920     0.200
     4.033    70.920     0.200
     4.345    76.320     0.200
     4.950    87.020     0.200
     5.159    89.520     0.200
     0.299     6.025     0.200
     0.448     8.226     0.200
     0.758    14.726     0.200
     1.093    20.125     0.200
     1.093    20.426     0.200
     1.296    23.025     0.200
     1.296    23.525     0.200
     1.294    24.325     0.200
     1.294    24.825     0.200
     1.335    24.625     0.200
     1.335    25.226     0.200
     1.924    34.926     0.200
     2.574    44.926     0.200
     2.574    44.025     0.200
     2.852    50.426     0.200
     2.852    50.325     0.200
     3.367    58.825     0.200
     3.497    59.325     0.200
     4.060    71.226     0.200
     4.060    70.825     0.200
     4.303    74.426     0.200
     0.309     6.129     0.200
     0.442     8.328     0.200
     0.766    14.730     0.200
     1.097    20.629     0.200
     1.289    23.129     0.200
     1.303    24.930     0.200
     1.344    25.328     0.200
     1.930    34.930     0.200
     2.565    44.930     0.200
     0.297     6.523     0.200
     0.637    11.320     0.200
     0.679    12.820     0.200
     0.816    15.320     0.200
     0.936    17.219     0.200
     1.464    27.320     0.200
     1.870    32.820     0.200
     1.844    33.125     0.200
     2.696    47.219     0.200
     3.116    55.023     0.200
     0.124     4.426     0.200
     0.452     9.225     0.200
     0.555    11.426     0.200
     0.691    13.625     0.200
     0.711    13.525     0.200
     0.847    15.326     0.200
     1.527    26.826     0.200
     1.527    27.426     0.200
     1.630    28.725     0.200
     1.630    29.725     0.200
     2.103    36.426     0.200
     2.781    48.426     0.200
     3.590    62.725     0.200
     0.168     3.391     0.200
     0.331     6.695     0.200
     0.439     9.094     0.200
     0.587    10.992     0.200
     0.628    12.195     0.200
     0.982    17.789     0.200
     1.092    20.289     0.200
     1.092    21.695     0.200
     1.390    24.891     0.200
     1.515    27.594     0.200
     1.627    29.695     0.200
     1.627    30.391     0.200
     1.669    30.789     0.200
     1.707    30.492     0.200
     1.707    31.992     0.200
     1.912    34.594     0.200
     2.240    39.594     0.200
     3.043    54.094     0.200
     0.201     4.812     0.200
     0.320     6.312     0.200
     0.408     7.516     0.200
     0.463     9.016     0.200
     0.518     9.812     0.200
     1.160    20.812     0.200
     1.217    21.812     0.200
     1.433    26.219     0.200
     1.433    27.219     0.200
     1.465    27.016     0.200
     1.500    28.219     0.200
     1.517    28.016     0.200
     1.786    32.617     0.200
     2.428    43.016     0.200
     3.563    63.016     0.200
     0.158     4.805     0.200
     0.736    14.102     0.200
     0.807    15.203     0.200
     0.994    18.305     0.200
     1.251    23.504     0.200
     1.306    23.703     0.200
     1.315    23.805     0.200
     1.798    31.805     0.200
     1.809    32.305     0.200
     1.830    33.004     0.200
     1.877    33.203     0.200
     2.272    39.203     0.200
     2.234    39.203     0.200
     2.273    39.805     0.200
     2.831    49.805     0.200
     2.914    51.305     0.200
     0.316     6.875     0.200
     0.624    12.172     0.200
     0.815    14.574     0.200
     0.815    14.473     0.200
     0.626    12.473     0.200
     0.880    16.473     0.200
     1.358    24.273     0.200
     1.601    27.875     0.200
     1.601    28.973     0.200
     1.601    27.773     0.200
     1.808    32.672     0.200
     1.975    34.375     0.200
     1.905    34.773     0.200
     1.968    36.473     0.200
     2.265    40.074     0.200
     2.755    48.473     0.200
     2.961    52.273     0.200
     5.034    85.273     0.200
     5.425    92.375     0.200
     0.325     6.750     0.200
     0.636    12.453     0.200
     0.639    12.156     0.200
     0.802    14.156     0.200
     0.895    16.555     0.200
     1.375    24.852     0.200
     1.375    25.555     0.200
     1.617    28.250     0.200
     1.823    32.555     0.200
     1.921    34.750     0.200
     1.959    34.250     0.200
     1.959    35.750     0.200
     1.984    36.055     0.200
     2.251    38.453     0.200
     3.357    59.055     0.200
     0.321     6.875     0.200
     0.616    12.477     0.200
     0.624    12.172     0.200
     0.825    14.477     0.200
     0.879    16.375     0.200
     1.354    25.172     0.200
     1.594    28.078     0.200
     1.594    28.773     0.200
     1.939    34.578     0.200
     1.981    34.375     0.200
     1.963    35.875     0.200
     2.265    39.672     0.200
     3.134    55.273     0.200
     0.184     3.594     0.200
     0.325     6.492     0.200
     0.580    10.891     0.200
     1.375    24.793     0.200
     1.375    25.891     0.200
     1.375    24.992     0.200
     1.509    27.492     0.200
     1.657    30.891     0.200
     1.903    34.492     0.200
     2.251    39.793     0.200
     2.251    39.191     0.200
     2.627    46.793     0.200
     3.052    53.992     0.200
     3.362    58.793     0.200
     4.332    76.293     0.200
     6.694   116.793     0.200
     0.202     4.794     0.200
     0.401     8.094     0.200
     0.585    11.594     0.200
     0.655    12.194     0.200
     0.961    17.494     0.200
     0.961    17.394     0.200
     1.140    20.994     0.200
     1.415    25.294     0.200
     1.415    25.594     0.200
     1.585    28.494     0.200
     1.682    29.994     0.200
     1.722    31.694     0.200
     1.975    35.194     0.200
     2.190    38.394     0.200
     2.190    38.094     0.200
     2.485    43.694     0.200
     2.980    52.494     0.200
     3.356    58.894     0.200
     3.687    64.894     0.200
     0.194     4.787     0.200
     0.734    13.887     0.200
     1.096    19.987     0.200
     1.318    23.887     0.200
     1.398    25.087     0.200
     1.587    27.787     0.200
     1.908    33.887     0.200
     2.114    37.287     0.200
     2.389    42.187     0.200
     2.534    44.187     0.200
     2.642    46.087     0.200
     2.585    45.287     0.200
     2.961    51.487     0.200
     0.066     3.691     0.200
     0.788    14.789     0.200
     1.167    21.391     0.200
     1.339    24.191     0.200
     1.391    24.590     0.200
     1.399    25.488     0.200
     1.463    25.391     0.200
     2.180    37.891     0.200
     2.401    42.391     0.200
     2.863    50.191     0.200
     0.329     6.844     0.200
     0.346     7.148     0.200
     0.453     8.742     0.200
     0.785    15.148     0.200
     1.108    19.945     0.200
     1.159    22.547     0.200
     1.339    24.148     0.200
     1.704    30.445     0.200
     1.704    31.344     0.200
     1.718    30.547     0.200
     1.718    31.547     0.200
     1.749    32.648     0.200
     1.750    32.242     0.200
     2.217    39.547     0.200
     2.941    51.844     0.200
     2.941    52.344     0.200
     0.255     5.212     0.200
     0.302     6.612     0.200
     0.300     6.012     0.200
     0.635    12.212     0.200
     0.647    13.212     0.200
     0.961    18.112     0.200
     1.173    22.012     0.200
     1.195    22.412     0.200
     1.232    23.512     0.200
     1.260    23.412     0.200
     1.423    25.112     0.200
     1.514    27.712     0.200
     1.799    33.112     0.200
     2.683    47.512     0.200
     0.128     4.078     0.200
     0.307     7.180     0.200
     0.733    14.273     0.200
     0.820    16.477     0.200
     0.920    17.273     0.200
     1.376    25.078     0.200
     1.370    25.578     0.200
     1.398    25.977     0.200
     1.477    26.477     0.200
     1.477    27.273     0.200
     1.509    26.578     0.200
     1.509    27.375     0.200
     1.750    31.875     0.200
     1.800    32.578     0.200
     1.830    33.180     0.200
     1.830    34.180     0.200
     2.209    39.375     0.200
     2.448    43.477     0.200
     2.704    47.977     0.200
     3.327    58.875     0.200
     4.162    71.477     0.200
     0.279     5.484     0.200
     0.456     9.184     0.200
     0.331     7.184     0.200
     1.145    20.984     0.200
     1.145    20.785     0.200
     1.290    23.785     0.200
     1.290    23.586     0.200
     1.659    30.383     0.200
     1.667    30.484     0.200
     1.667    31.184     0.200
     1.698    31.883     0.200
     2.267    40.184     0.200
     2.424    42.785     0.200
     2.640    46.883     0.200
     3.272    58.004     0.200
     0.301     5.781     0.200
     0.488     8.875     0.200
     0.627    12.578     0.200
     1.049    19.875     0.200
     1.220    22.281     0.200
     1.220    23.477     0.200
     1.272    23.680     0.200
     1.272    24.375     0.200
     1.334    23.977     0.200
     1.334    24.680     0.200
     1.310    24.680     0.200
     1.579    28.875     0.200
     1.579    29.375     0.200
     1.887    34.781     0.200
     2.601    46.078     0.200
     3.546    62.781     0.200
     0.280     5.219     0.200
     0.328     7.219     0.200
     0.459     9.219     0.200
     1.110    22.016     0.200
     1.146    21.016     0.200
     1.146    20.820     0.200
     1.291    23.922     0.200
     1.291    23.820     0.200
     1.662    30.422     0.200
     1.670    30.516     0.200
     1.701    32.117     0.200
     1.701    31.516     0.200
     2.266    40.422     0.200
     2.640    46.922     0.200
     0.320     6.699     0.200
     0.287     6.199     0.200
     0.470     8.699     0.200
     0.548    10.598     0.200
     0.762    14.199     0.200
     1.296    23.297     0.200
     1.681    30.898     0.200
     1.676    30.098     0.200
     1.676    30.797     0.200
     1.710    30.898     0.200
     1.710    31.699     0.200
     1.712    31.699     0.200
     2.259    40.199     0.200
     2.408    42.598     0.200
     2.582    45.797     0.200
     2.980    52.699     0.200
     0.131     3.836     0.200
     0.434     8.734     0.200
     0.528    10.836     0.200
     0.692    13.035     0.200
     0.670    13.234     0.200
     0.873    15.836     0.200
     1.206    22.535     0.200
     1.500    26.637     0.200
     1.500    27.836     0.200
     1.741    31.137     0.200
     1.741    31.934     0.200
     1.741    32.934     0.200
     1.783    32.934     0.200
     1.822    34.137     0.200
     2.125    37.336     0.200
     3.614    62.836     0.200
     4.960    85.336     0.200
     0.336     7.211     0.200
     0.459     9.008     0.200
     0.557    10.910     0.200
     0.776    14.711     0.200
     1.122    20.309     0.200
     1.323    24.711     0.200
     1.323    23.910     0.200
     1.694    30.309     0.200
     1.694    31.008     0.200
     1.704    30.309     0.200
     1.704    31.410     0.200
     1.735    31.809     0.200
     1.735    32.211     0.200
     1.735    31.410     0.200
     1.735    32.109     0.200
     2.233    39.809     0.200
     2.233    39.910     0.200
     2.388    42.211     0.200
     2.609    46.309     0.200
     2.670    47.309     0.200
     2.956    52.211     0.200
     3.304    58.562     0.200
     4.661    82.309     0.200
     0.244     5.398     0.200
     0.253     6.297     0.200
     0.383     7.898     0.200
     0.448     8.602     0.200
     0.537    11.000     0.200
     0.876    16.602     0.200
     1.158    21.102     0.200
     1.370    24.797     0.200
     1.370    25.500     0.200
     1.424    26.203     0.200
     1.461    26.898     0.200
     1.487    28.102     0.200
     1.733    31.297     0.200
     0.261     6.070     0.200
     0.443     8.672     0.200
     0.448     8.773     0.200
     0.561    11.070     0.200
     0.588    12.273     0.200
     0.730    13.570     0.200
     1.149    21.672     0.200
     1.149    22.172     0.200
     1.174    22.672     0.200
     1.220    22.570     0.200
     1.506    26.969     0.200
     1.506    27.875     0.200
     1.565    28.070     0.200
     0.186     4.680     0.200
     0.337     6.680     0.200
     0.419     8.180     0.200
     0.518    10.180     0.200
     0.589    10.773     0.200
     0.702    14.180     0.200
     0.951    17.680     0.200
     1.260    23.477     0.200
     1.277    23.477     0.200
     1.302    23.680     0.200
     1.422    25.578     0.200
     1.820    33.680     0.200
     2.929    52.047     0.200
     0.298     6.461     0.200
     0.496    10.363     0.200
     0.553    11.363     0.200
     0.552    10.961     0.200
     0.904    16.160     0.200
     1.266    23.660     0.200
     1.504    27.262     0.200
     1.734    31.562     0.200
     1.874    34.160     0.200
     2.070    36.363     0.200
     2.841    50.062     0.200
     3.219    56.762     0.200
     3.580    63.062     0.200
     0.135     3.680     0.200
     0.491    10.281     0.200
     0.530    10.383     0.200
     0.711    13.781     0.200
     0.982    17.586     0.200
     1.067    20.086     0.200
     1.399    24.984     0.200
     1.449    26.180     0.200
     1.590    28.781     0.200
     1.634    30.086     0.200
     1.684    29.883     0.200
     1.684    31.383     0.200
     1.859    33.586     0.200
     0.242     5.688     0.200
     0.622    11.287     0.200
     0.634    12.287     0.200
     0.778    15.188     0.200
     0.879    16.887     0.200
     0.886    16.088     0.200
     1.437    26.387     0.200
     1.751    31.488     0.200
     1.778    32.188     0.200
     1.913    33.988     0.200
     1.956    35.588     0.200
     3.382    59.887     0.200
     0.088     3.664     0.200
     0.829    15.465     0.200
     1.216    22.066     0.200
     1.373    24.066     0.200
     1.372    24.367     0.200
     1.457    26.266     0.200
     2.063    36.367     0.200
     2.297    40.164     0.200
     2.301    40.566     0.200
     2.534    44.664     0.200
     0.180     3.943     0.200
     0.270     5.545     0.200
     0.512     9.244     0.200
     0.664    12.943     0.200
     0.696    14.045     0.200
     1.032    19.545     0.200
     1.177    21.545     0.200
     1.177    22.545     0.200
     1.274    23.744     0.200
     1.359    24.045     0.200
     1.538    28.045     0.200
     1.726    32.443     0.200
     1.860    34.344     0.200
     2.635    46.744     0.200
     0.183     4.660     0.200
     0.333     6.562     0.200
     0.420     8.062     0.200
     0.515    10.062     0.200
     0.581    10.762     0.200
     0.709    13.961     0.200
     0.958    17.762     0.200
     1.267    23.660     0.200
     1.282    23.562     0.200
     1.299    24.262     0.200
     1.414    25.461     0.200
     1.604    29.363     0.200
     1.828    33.461     0.200
     0.121     3.561     0.200
     0.327     6.760     0.200
     0.678    12.760     0.200
     0.678    13.760     0.200
     0.952    16.561     0.200
     0.952    17.359     0.200
     1.108    20.561     0.200
     1.108    21.359     0.200
     1.422    25.160     0.200
     1.422    26.061     0.200
     1.507    26.859     0.200
     1.638    29.359     0.200
     1.681    30.359     0.200
     1.725    31.061     0.200
     1.913    34.959     0.200
     2.227    39.061     0.200
     2.570    45.660     0.200
     2.794    49.260     0.200
     3.042    53.561     0.200
     3.298    58.359     0.200
     0.329     7.539     0.200
     0.718    13.742     0.200
     0.825    16.336     0.200
     0.885    16.539     0.200
     0.834    16.141     0.200
     1.329    25.141     0.200
     1.366    24.539     0.200
     1.366    25.039     0.200
     1.380    25.438     0.200
     1.380    25.039     0.200
     1.527    26.836     0.200
     1.647    29.141     0.200
     1.647    28.938     0.200
     1.752    31.141     0.200
     1.760    31.938     0.200
     1.757    32.242     0.200
     4.204    73.641     0.200
     0.115     3.898     0.200
     0.497    10.398     0.200
     0.624    11.602     0.200
     0.672    13.203     0.200
     0.924    16.602     0.200
     1.449    25.898     0.200
     1.546    27.398     0.200
     1.674    30.602     0.200
     1.717    31.500     0.200
     1.760    32.602     0.200
     1.951    34.703     0.200
     2.191    38.297     0.200
     0.284     6.020     0.200
     0.329     7.422     0.200
     0.487     9.219     0.200
     0.655    12.719     0.200
     0.721    14.219     0.200
     1.054    19.820     0.200
     1.197    22.020     0.200
     1.197    23.020     0.200
     1.259    23.719     0.200
     1.299    24.020     0.200
     1.335    23.922     0.200
     1.337    26.121     0.200
     1.561    28.520     0.200
     1.884    33.922     0.200
     4.525    78.121     0.200
     0.251     5.301     0.200
     0.355     8.199     0.200
     0.548    10.602     0.200
     0.567    11.500     0.200
     1.065    19.000     0.200
     1.023    19.398     0.200
     1.023    20.500     0.200
     1.308    23.602     0.200
     1.478    26.699     0.200
     1.604    29.000     0.200
     1.861    32.199     0.200
     1.861    33.699     0.200
     2.307    40.199     0.200
     3.096    54.398     0.200
     0.150     4.184     0.200
     0.733    13.783     0.200
     1.301    23.684     0.200
     1.301    24.584     0.200
     1.331    24.184     0.200
     1.373    24.584     0.200
     1.548    26.885     0.200
     1.917    34.385     0.200
     2.261    39.783     0.200
     2.488    43.584     0.200
     2.609    46.084     0.200
     2.686    46.783     0.200
     0.290     6.000     0.200
     0.312     7.102     0.200
     0.573    11.000     0.200
     0.646    12.801     0.200
     0.645    12.699     0.200
     0.965    18.199     0.200
     1.166    21.402     0.200
     1.230    22.699     0.200
     1.509    27.402     0.200
     1.801    32.602     0.200
     0.088     4.312     0.200
     0.793    15.414     0.200
     1.319    23.812     0.200
     1.319    24.312     0.200
     1.350    24.109     0.200
     1.350    24.211     0.200
     1.420    25.414     0.200
     1.991    35.914     0.200
     2.092    36.711     0.200
     2.092    36.609     0.200
     2.333    41.008     0.200
     2.333    40.508     0.200
     2.263    40.008     0.200
     2.793    48.008     0.200
     3.235    56.914     0.200
     4.289    75.211     0.200
     4.374    77.008     0.200
     0.257     5.070     0.200
     0.403     7.971     0.200
     0.532    10.270     0.200
     0.681    12.770     0.200
     0.987    17.471     0.200
     1.143    21.570     0.200
     1.398    24.770     0.200
     1.612    29.070     0.200
     1.690    30.369     0.200
     1.993    35.971     0.200
     2.190    38.270     0.200
     2.967    52.070     0.200
     4.846    84.869     0.200
     0.088     3.547     0.200
     0.420     8.547     0.200
     0.512     9.645     0.200
     0.575    10.547     0.200
     0.789    15.547     0.200
     0.995    17.945     0.200
     1.349    24.645     0.200
     1.386    24.844     0.200
     1.378    25.145     0.200
     1.694    30.945     0.200
     1.882    33.945     0.200
     2.269    40.246     0.200
     2.576    45.445     0.200
     3.313    58.547     0.200
     0.172     4.895     0.200
     0.500     9.996     0.200
     0.615    11.695     0.200
     0.929    17.395     0.200
     0.929    17.293     0.200
     1.257    23.293     0.200
     1.445    25.695     0.200
     1.445    25.594     0.200
     1.600    28.496     0.200
     1.804    32.895     0.200
     2.657    46.793     0.200
     2.828    49.996     0.200
     2.909    50.793     0.200
     3.403    59.996     0.200
     4.391    76.594     0.200
     0.219     5.152     0.200
     0.409     8.254     0.200
     0.657    12.553     0.200
     0.756    14.254     0.200
     1.223    22.053     0.200
     1.255    23.354     0.200
     1.353    24.553     0.200
     1.353    24.754     0.200
     1.815    32.854     0.200
     1.857    33.553     0.200
     1.818    32.652     0.200
     1.840    34.053     0.200
     2.217    38.953     0.200
     2.217    39.152     0.200
     2.261    39.553     0.200
     2.881    50.754     0.200
     0.151     4.453     0.200
     0.401     8.053     0.200
     0.474     9.653     0.200
     0.635    12.053     0.200
     0.704    13.953     0.200
     0.916    16.753     0.200
     1.265    23.353     0.200
     1.294    24.053     0.200
     1.293    24.453     0.200
     1.310    24.253     0.200
     1.460    26.053     0.200
     1.615    28.453     0.200
     1.615    29.653     0.200
     1.798    32.653     0.200
     2.186    38.953     0.200
     2.284    40.653     0.200
     2.816    49.653     0.200
     0.284     5.982     0.200
     0.492    10.082     0.200
     0.538    10.383     0.200
     0.558    11.383     0.200
     0.790    14.582     0.200
     0.905    16.182     0.200
     1.256    23.883     0.200
     1.498    26.781     0.200
     1.720    30.883     0.200
     1.804    33.182     0.200
     1.841    34.082     0.200
     1.864    34.281     0.200
     2.079    36.682     0.200
     2.348    41.383     0.200
     2.853    50.281     0.200
     0.290     6.094     0.200
     0.551    10.789     0.200
     0.504    10.289     0.200
     0.564    11.195     0.200
     0.894    15.891     0.200
     0.804    14.992     0.200
     1.270    23.594     0.200
     1.512    27.195     0.200
     1.734    31.594     0.200
     1.818    32.891     0.200
     1.856    33.789     0.200
     1.879    35.094     0.200
     2.065    36.492     0.200
     2.335    41.195     0.200
     2.839    50.094     0.200
     2.839    50.289     0.200
     4.573    80.289     0.200
     4.948    85.891     0.200
     0.210     4.664     0.200
     0.337     6.562     0.200
     0.396     7.363     0.200
     0.452     8.762     0.200
     0.939    17.961     0.200
     1.196    21.762     0.200
     1.183    21.664     0.200
     1.183    23.062     0.200
     1.460    26.363     0.200
     1.460    27.562     0.200
     1.493    27.461     0.200
     1.528    28.363     0.200
     1.814    32.961     0.200
     2.401    42.562     0.200
     0.330     6.102     0.200
     0.314     6.406     0.200
     0.275     6.008     0.200
     0.502     9.602     0.200
     0.976    18.906     0.200
     1.136    20.406     0.200
     1.239    22.102     0.200
     1.239    23.602     0.200
     1.467    26.602     0.200
     1.525    28.102     0.200
     1.562    28.805     0.200
     1.585    29.305     0.200
     1.835    33.602     0.200
     0.127     4.090     0.200
     0.345     7.090     0.200
     0.351     7.590     0.200
     0.374     7.488     0.200
     0.652    12.488     0.200
     0.832    15.988     0.200
     1.164    21.389     0.200
     1.222    22.189     0.200
     1.274    23.189     0.200
     1.365    25.090     0.200
     1.406    25.988     0.200
     1.655    29.189     0.200
     1.655    30.090     0.200
     1.861    34.189     0.200
     1.998    36.389     0.200
     0.194     5.293     0.200
     0.329     7.094     0.200
     0.410     8.395     0.200
     0.526    10.492     0.200
     0.585    11.395     0.200
     0.699    14.094     0.200
     0.953    17.492     0.200
     1.256    23.395     0.200
     1.270    23.492     0.200
     1.289    23.793     0.200
     1.420    25.395     0.200
     1.593    28.492     0.200
     1.820    33.293     0.200
     2.211    38.992     0.200
     2.323    40.992     0.200
     0.277     6.191     0.200
     0.689    13.191     0.200
     1.279    23.691     0.200
     1.279    23.090     0.200
     1.279    23.492     0.200
     1.383    24.590     0.200
     1.383    24.289     0.200
     1.669    29.391     0.200
     1.669    29.289     0.200
     1.847    33.789     0.200
     2.391    42.191     0.200
     2.626    46.289     0.200
     2.616    45.789     0.200
     3.036    53.492     0.200
     3.036    53.289     0.200
     0.270     6.611     0.200
     0.295     6.811     0.200
     0.524    10.111     0.200
     0.598    11.611     0.200
     0.805    15.011     0.200
     1.179    20.811     0.200
     1.140    21.511     0.200
     1.292    23.211     0.200
     1.292    23.611     0.200
     1.713    31.211     0.200
     1.722    31.411     0.200
     1.730    31.211     0.200
     2.263    39.511     0.200
     2.382    41.711     0.200
     2.968    52.211     0.200
     3.270    56.779     0.200
     0.216     5.055     0.200
     0.314     6.250     0.200
     0.389     7.453     0.200
     0.584    10.852     0.200
     0.548    10.648     0.200
     0.686    13.555     0.200
     0.951    17.453     0.200
     1.250    22.852     0.200
     1.275    24.648     0.200
     1.290    25.352     0.200
     1.422    26.055     0.200
     1.575    28.750     0.200
     1.713    30.852     0.200
     1.813    33.055     0.200
     0.226     5.109     0.200
     0.355     7.609     0.200
     0.566    11.609     0.200
     0.605    11.109     0.200
     1.015    18.109     0.200
     1.082    21.312     0.200
     1.360    24.312     0.200
     1.536    27.906     0.200
     1.625    29.711     0.200
     1.921    34.906     0.200
     2.247    39.109     0.200
     0.308     6.176     0.200
     0.376     7.375     0.200
     0.561    11.078     0.200
     0.586    10.875     0.200
     0.676    13.477     0.200
     0.948    17.977     0.200
     1.237    22.875     0.200
     1.232    23.176     0.200
     1.426    26.078     0.200
     1.564    28.777     0.200
     1.807    33.477     0.200
     0.267     5.484     0.200
     0.372     7.684     0.200
     0.524    10.383     0.200
     0.617    11.785     0.200
     1.042    18.586     0.200
     1.074    20.184     0.200
     1.337    23.883     0.200
     1.925    34.785     0.200
     2.258    39.383     0.200
     2.520    44.383     0.200
     0.159     3.457     0.200
     0.285     5.859     0.200
     0.333     7.160     0.200
     0.478     8.758     0.200
     0.658    12.559     0.200
     0.729    14.059     0.200
     1.064    19.758     0.200
     1.201    22.160     0.200
     1.201    23.559     0.200
     1.266    23.359     0.200
     1.326    23.660     0.200
     1.566    28.660     0.200
     1.759    31.359     0.200
     1.759    32.457     0.200
     1.894    34.859     0.200
     2.602    45.957     0.200
     3.614    63.957     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.695    54.225     0.200
     1.823    56.524     0.200
     2.552    71.825     0.200
     3.014    84.524     0.200
     3.621    97.625     0.200
     3.661    99.125     0.200
     4.862   126.125     0.200
     5.041   132.625     0.200
     1.902    56.420     0.200
     3.245    89.721     0.200
     3.350    91.621     0.200
    13.284   333.221     0.200
    13.492   333.721     0.200
    15.011   378.721     0.200
    15.732   395.721     0.200
    16.332   413.721     0.200
    17.884   447.721     0.200
    18.126   453.721     0.200
     2.728    76.363     0.200
     2.752    76.965     0.200
     3.227    89.965     0.200
     3.876   104.965     0.200
     1.163    39.684     0.200
     1.605    50.086     0.200
     2.391    67.484     0.200
     2.507    71.484     0.200
     2.504    70.984     0.200
     3.142    86.086     0.200
     3.662   101.484     0.200
     3.744    98.285     0.200
     4.570   123.285     0.200
     4.702   120.785     0.200
     1.359    43.070     0.200
     1.654    51.070     0.200
     2.207    62.672     0.200
     2.657    73.070     0.200
     4.044   104.672     0.200
     1.462    45.621     0.200
     2.557    70.723     0.200
     2.642    72.820     0.200
     2.976    82.422     0.200
     3.254    88.520     0.200
     4.723   119.520     0.200
     2.261    64.848     0.200
     2.641    70.250     0.200
     2.723    75.547     0.200
     2.894    81.047     0.200
     3.338    89.949     0.200
     3.881    99.848     0.200
     4.166   109.949     0.200
     4.332   115.547     0.200
     4.713   120.148     0.200
     1.429    45.859     0.200
     1.477    46.059     0.200
     2.675    73.758     0.200
     2.934    78.059     0.200
     3.292    90.059     0.200
     3.456    92.359     0.200
     3.876   103.059     0.200
     3.999   106.059     0.200
     4.126   108.359     0.200
     4.365   115.660     0.200
     4.442   117.859     0.200
     4.733   121.359     0.200
     4.769   124.258     0.200
     5.763   148.758     0.200
     2.299    66.977     0.200
     2.911    81.777     0.200
     3.391    91.277     0.200
     3.670    96.977     0.200
     4.117   108.777     0.200
     4.450   115.375     0.200
     4.848   124.875     0.200
     5.766   151.977     0.200
     5.975   153.977     0.200
     6.196   163.477     0.200
     6.309   163.176     0.200
     7.463   188.176     0.200
     2.979    84.264     0.200
     3.767   102.665     0.200
     4.855   131.764     0.200
     2.282    66.713     0.200
     2.570    74.612     0.200
     2.701    74.413     0.200
     3.071    83.513     0.200
     3.413    93.413     0.200
     3.874   103.013     0.200
     4.298   113.612     0.200
     4.393   116.413     0.200
     5.229   138.312     0.200
     1.916    60.705     0.200
     3.717   100.506     0.200
     4.330   113.307     0.200
     1.443    47.523     0.200
     1.770    57.320     0.200
     2.537    73.523     0.200
     2.665    76.523     0.200
     3.004    86.227     0.200
     3.256    88.727     0.200
     3.540    97.023     0.200
     4.637   120.523     0.200
     4.870   129.125     0.200
     1.818    58.176     0.200
     2.345    66.875     0.200
     2.637    75.273     0.200
     2.637    75.676     0.200
     2.532    71.973     0.200
     3.418    93.973     0.200
     3.829   102.574     0.200
     4.360   115.074     0.200
     4.360   114.973     0.200
     4.747   129.273     0.200
     5.197   139.273     0.200
     1.377    44.180     0.200
     2.713    75.780     0.200
     3.063    84.480     0.200
     4.995   135.080     0.200
     5.270   138.880     0.200
     1.509    50.906     0.200
     1.614    51.906     0.200
     2.573    74.609     0.200
     2.737    78.109     0.200
     2.737    78.008     0.200
     3.193    87.211     0.200
     3.262    90.906     0.200
     3.827   103.406     0.200
     4.181   112.508     0.200
     4.181   111.609     0.200
     5.310   140.609     0.200
     6.909   177.805     0.200
     1.375    44.417     0.200
     1.719    55.217     0.200
     1.809    57.817     0.200
     2.127    63.617     0.200
     2.353    69.217     0.200
     2.717    76.617     0.200
     3.421    95.917     0.200
     3.643    97.217     0.200
     4.576   119.417     0.200
     4.864   128.817     0.200
     5.256   141.317     0.200
     1.804    56.660     0.200
     2.368    67.461     0.200
     2.503    72.461     0.200
     2.644    75.160     0.200
     3.155    87.863     0.200
     3.454    94.262     0.200
     3.864   105.562     0.200
     4.384   116.762     0.200
     5.161   136.961     0.200
     7.027   181.762     0.200
     1.467    46.859     0.200
     1.741    54.159     0.200
     1.782    56.159     0.200
     2.718    76.458     0.200
     1.314    43.949     0.200
     1.582    50.352     0.200
     1.621    52.449     0.200
     1.621    51.551     0.200
     1.650    53.051     0.200
     1.882    59.148     0.200
     2.218    64.250     0.200
     2.569    72.148     0.200
     2.569    75.148     0.200
     2.574    74.449     0.200
     2.574    73.449     0.200
     2.683    75.949     0.200
     4.138   109.648     0.200
     4.165   110.250     0.200
     4.287   114.750     0.200
     4.411   115.352     0.200
     4.411   116.148     0.200
     4.773   127.148     0.200
     5.209   138.148     0.200
     5.549   145.949     0.200
     7.459   192.852     0.200
     8.222   206.129     0.200
    13.963   354.398     0.200
     1.395    44.818     0.200
     1.664    51.019     0.200
     1.734    56.719     0.200
     2.209    63.818     0.200
     2.500    71.719     0.200
     2.657    74.318     0.200
     3.375    90.719     0.200
     5.277   139.019     0.200
     1.429    45.426     0.200
     1.469    46.023     0.200
     2.203    61.824     0.200
     3.102    82.824     0.200
     1.835    58.016     0.200
     1.135    37.765     0.200
     1.203    38.564     0.200
     1.452    46.064     0.200
     1.452    45.865     0.200
     1.662    51.865     0.200
     2.203    63.265     0.200
     2.561    72.564     0.200
     2.695    73.765     0.200
     4.918   131.265     0.200
     6.821   175.965     0.200
     1.539    47.422     0.200
     1.842    57.422     0.200
     2.753    74.223     0.200
     3.059    82.121     0.200
     4.025   106.723     0.200
     1.700    53.059     0.200
     1.701    53.355     0.200
     1.715    53.156     0.200
     1.353    44.066     0.200
     1.890    60.168     0.200
     2.269    64.867     0.200
     2.269    65.066     0.200
     2.573    72.668     0.200
     2.573    72.770     0.200
     2.606    74.168     0.200
     2.606    74.270     0.200
     3.065    84.969     0.200
     3.384    93.566     0.200
     4.368   115.566     0.200
     4.368   116.066     0.200
     5.256   139.367     0.200
     5.536   145.867     0.200
     1.463    46.243     0.200
     1.821    55.143     0.200
     2.370    67.943     0.200
     2.529    70.843     0.200
     2.622    73.943     0.200
     3.004    82.543     0.200
     3.527    96.743     0.200
     3.822    99.743     0.200
     4.056   106.643     0.200
     4.437   118.643     0.200
     4.837   128.143     0.200
     1.243    40.429     0.200
     1.793    55.329     0.200
     2.754    77.929     0.200
     3.462    94.429     0.200
     5.312   141.929     0.200
     1.642    50.938     0.200
     1.642    51.234     0.200
     1.785    56.336     0.200
     1.820    57.938     0.200
     2.175    62.336     0.200
     2.715    76.531     0.200
     3.399    91.531     0.200
     3.399    91.133     0.200
     4.136   108.234     0.200
     4.136   110.531     0.200
     4.724   126.031     0.200
     5.643   148.336     0.200
     6.096   157.836     0.200
     6.082   157.133     0.200
     1.710    52.207     0.200
     1.710    53.008     0.200
     1.687    53.508     0.200
     1.695    54.609     0.200
     2.612    72.809     0.200
     2.855    78.910     0.200
     3.139    86.809     0.200
     3.269    88.508     0.200
     3.405    92.910     0.200
     5.499   144.410     0.200
     5.930   154.508     0.200
     5.930   154.910     0.200
     1.492    46.723     0.200
     1.492    46.621     0.200
     2.643    71.020     0.200
     2.314    67.305     0.200
     2.569    71.604     0.200
     3.526    96.203     0.200
     4.340   115.604     0.200
     1.498    46.367     0.200
     1.522    48.562     0.200
     1.499    49.109     0.200
     2.073    61.016     0.200
     2.332    67.914     0.200
     2.840    80.016     0.200
     2.775    79.109     0.200
     4.536   119.609     0.200
     4.536   119.211     0.200
     4.931   133.609     0.200
     4.931   133.812     0.200
     5.327   141.109     0.200
     5.855   157.070     0.200
    16.406   408.812     0.200
    17.743   444.812     0.200
     1.624    52.399     0.200
     1.900    60.500     0.200
     1.900    61.099     0.200
     1.944    64.099     0.200
     2.506    73.199     0.200
     2.831    79.500     0.200
     2.831    80.599     0.200
     2.879    82.399     0.200
     2.879    81.500     0.200
     2.993    83.099     0.200
     2.993    83.299     0.200
     3.196    88.899     0.200
     3.213    89.099     0.200
     3.492    97.399     0.200
     3.602    99.000     0.200
     4.166   114.199     0.200
     4.345   116.299     0.200
     4.581   119.500     0.200
     5.082   136.799     0.200
     5.082   136.099     0.200
     5.506   147.500     0.200
     6.663   172.599     0.200
    12.722   325.500     0.200
    14.925   377.099     0.200
    15.028   373.500     0.200
     1.852    58.875     0.200
     2.833    79.977     0.200
     2.871    80.977     0.200
     3.227    88.477     0.200
     3.227    89.176     0.200
     5.071   138.176     0.200
     5.298   140.578     0.200
     5.494   146.176     0.200
     1.371    43.402     0.200
     1.396    43.500     0.200
     1.440    46.402     0.200
     2.779    76.199     0.200
     3.579    94.402     0.200
     4.286   110.199     0.200
     4.286   110.902     0.200
     4.307   113.602     0.200
     4.871   127.402     0.200
     5.262   138.602     0.200
     5.785   149.902     0.200
     5.968   153.301     0.200
     6.184   161.000     0.200
     1.823    58.078     0.200
     1.859    56.781     0.200
     1.859    59.281     0.200
     1.859    59.078     0.200
     2.316    67.781     0.200
     2.447    70.180     0.200
     2.832    79.578     0.200
     2.774    78.383     0.200
     2.774    78.977     0.200
     2.851    78.578     0.200
     3.205    90.383     0.200
     3.455    93.781     0.200
     3.455    93.383     0.200
     3.479    93.883     0.200
     3.586    97.281     0.200
     4.564   119.680     0.200
     4.564   120.281     0.200
     4.922   133.977     0.200
     4.922   133.680     0.200
     5.312   141.477     0.200
     5.871   157.656     0.200
     6.841   175.977     0.200
    16.430   408.477     0.200
    17.760   444.477     0.200
     1.265    41.484     0.200
     1.424    45.184     0.200
     1.695    51.984     0.200
     1.734    53.484     0.200
     2.178    63.684     0.200
     2.474    70.484     0.200
     2.687    75.484     0.200
     2.967    81.684     0.200
     2.967    81.484     0.200
     3.382    89.781     0.200
     3.382    91.684     0.200
     3.404    92.383     0.200
     3.677    99.184     0.200
     3.677   100.582     0.200
     3.962   105.484     0.200
     4.422   114.984     0.200
     4.422   115.484     0.200
     4.401   115.383     0.200
     4.401   117.484     0.200
     4.877   130.082     0.200
     5.439   140.184     0.200
     5.713   152.383     0.200
     6.630   168.383     0.200
     6.869   175.184     0.200
     6.869   176.781     0.200
     1.627    52.129     0.200
     1.669    53.629     0.200
     1.710    55.129     0.200
     1.710    56.629     0.200
     2.647    75.430     0.200
     3.047    83.930     0.200
     3.373    94.129     0.200
     4.864   132.230     0.200
     5.310   142.230     0.200
     6.876   177.027     0.200
     1.448    46.512     0.200
     1.448    45.809     0.200
     1.558    49.211     0.200
     1.764    55.109     0.200
     2.699    74.609     0.200
     2.993    83.609     0.200
     3.310    89.910     0.200
     4.401   113.609     0.200
     5.348   141.012     0.200
     5.348   142.711     0.200
     1.277    41.328     0.200
     5.856   150.629     0.200
     1.512    48.379     0.200
     1.712    54.078     0.200
     1.911    60.480     0.200
     2.236    65.480     0.200
     2.649    75.277     0.200
     2.649    75.379     0.200
     3.043    83.980     0.200
     4.333   114.578     0.200
     5.309   140.480     0.200
     6.876   177.277     0.200
     1.097    39.016     0.200
     1.392    46.516     0.200
     1.491    48.711     0.200
     1.599    50.609     0.200
     1.649    52.914     0.200
     1.830    57.609     0.200
     2.690    75.609     0.200
     2.856    80.516     0.200
     4.079   108.516     0.200
     4.961   132.211     0.200
     5.451   141.711     0.200
     1.316    42.672     0.200
     1.318    43.273     0.200
     1.318    42.875     0.200
     1.577    49.875     0.200
     2.299    66.273     0.200
     2.591    73.477     0.200
     4.312   113.773     0.200
     4.543   121.773     0.200
     5.028   133.375     0.200
     7.194   184.875     0.200
     1.633    51.903     0.200
     1.636    51.804     0.200
     2.457    70.903     0.200
     2.608    74.903     0.200
     3.239    90.804     0.200
     3.766   104.403     0.200
     4.675   127.304     0.200
     5.068   136.104     0.200
     1.513    48.781     0.200
     1.628    52.281     0.200
     2.644    73.484     0.200
     3.043    84.086     0.200
     4.340   115.586     0.200
     4.340   115.984     0.200
     4.858   131.383     0.200
     4.858   132.586     0.200
     5.257   135.883     0.200
     5.302   141.086     0.200
     5.510   146.484     0.200
     5.624   151.523     0.200
     6.882   177.484     0.200
    12.623   322.984     0.200
    12.735   324.484     0.200
    14.264   355.086     0.200
    14.276   352.180     0.200
    15.102   380.781     0.200
    16.652   420.680     0.200
    16.991   424.984     0.200
     1.620    51.422     0.200
     2.575    73.820     0.200
     2.575    73.023     0.200
     2.640    74.727     0.200
     4.329   114.320     0.200
     4.856   131.922     0.200
     5.303   140.523     0.200
     1.622    52.180     0.200
     4.344   114.781     0.200
     4.851   127.281     0.200
     5.294   141.883     0.200
     1.619    51.367     0.200
     2.637    74.062     0.200
     3.052    84.164     0.200
     3.735    99.062     0.200
     4.336   115.766     0.200
     4.336   114.969     0.200
     5.297   142.164     0.200
     6.888   177.562     0.200
     1.100    38.922     0.200
     1.514    48.621     0.200
     1.634    51.922     0.200
     1.634    52.922     0.200
     1.915    60.820     0.200
     2.654    75.520     0.200
     3.040    83.621     0.200
     3.327    90.820     0.200
     4.354   117.719     0.200
     4.869   132.922     0.200
     4.869   133.219     0.200
     5.314   139.621     0.200
     5.509   148.820     0.200
     5.624   150.879     0.200
     6.670   172.719     0.200
     6.871   177.422     0.200
     1.191    40.982     0.200
     1.639    52.882     0.200
     1.920    60.782     0.200
     2.660    75.582     0.200
     3.035    83.682     0.200
     4.876   132.982     0.200
     1.081    38.469     0.200
     1.170    40.569     0.200
     1.385    46.369     0.200
     1.615    52.369     0.200
     1.898    60.469     0.200
     2.634    75.769     0.200
     3.056    83.569     0.200
     5.269   136.169     0.200
     5.296   140.669     0.200
     1.622    52.621     0.200
     1.664    53.719     0.200
     1.904    61.320     0.200
     3.051    84.520     0.200
     4.329   115.520     0.200
     5.305   142.820     0.200
     6.881   177.621     0.200
     1.606    52.492     0.200
     1.648    53.691     0.200
     1.889    60.395     0.200
     1.505    47.713     0.200
     1.621    51.014     0.200
     1.904    60.113     0.200
     2.571    73.514     0.200
     2.638    74.412     0.200
     4.337   113.611     0.200
     1.539    48.594     0.200
     1.655    52.195     0.200
     1.736    56.996     0.200
     2.538    71.496     0.200
     4.350   115.395     0.200
     1.638    52.084     0.200
     1.680    53.284     0.200
     1.921    60.484     0.200
     4.342   114.784     0.200
     6.874   177.084     0.200
     1.287    41.430     0.200
     1.287    41.328     0.200
     1.635    50.930     0.200
     1.635    51.133     0.200
     1.813    57.930     0.200
     2.163    62.430     0.200
     2.511    70.133     0.200
     2.562    72.930     0.200
     3.391    90.328     0.200
     6.065   154.633     0.200
     1.243    40.824     0.200
     1.610    48.426     0.200
     2.616    73.926     0.200
     2.616    73.523     0.200
     2.823    76.926     0.200
     3.062    83.723     0.200
     3.013    82.625     0.200
     5.081   134.723     0.200
     5.553   147.824     0.200
     1.086    38.203     0.200
     1.507    49.703     0.200
     1.621    52.203     0.200
     1.662    53.902     0.200
     1.904    59.500     0.200
     2.569    73.703     0.200
     2.637    75.301     0.200
     3.050    83.402     0.200
     3.418    95.402     0.200
     4.341   115.402     0.200
     5.295   141.801     0.200
     6.889   177.902     0.200
     1.702    53.794     0.200
     1.761    54.294     0.200
     1.797    56.594     0.200
     3.416    93.894     0.200
     3.416    95.394     0.200
     4.557   119.494     0.200
     4.863   131.794     0.200
     5.259   140.294     0.200
     1.356    42.914     0.200
     1.492    45.516     0.200
     1.631    50.316     0.200
     1.631    49.316     0.200
     2.117    60.414     0.200
     2.154    61.516     0.200
     2.760    75.016     0.200
     2.796    77.016     0.200
     3.306    89.117     0.200
     4.016   104.414     0.200
     4.214   113.414     0.200
     4.614   121.215     0.200
     4.820   123.516     0.200
     4.820   123.316     0.200
     2.263    65.569     0.200
     2.578    72.569     0.200
     2.692    75.869     0.200
     4.657   121.069     0.200
     1.632    51.555     0.200
     1.674    53.855     0.200
     2.234    65.457     0.200
     2.565    73.457     0.200
     2.565    72.855     0.200
     2.651    75.656     0.200
     3.041    83.656     0.200
     3.721   100.656     0.200
     4.332   114.855     0.200
     5.311   143.457     0.200
     5.511   142.355     0.200
     6.873   176.258     0.200
     1.504    47.891     0.200
     1.625    52.086     0.200
     2.573    74.484     0.200
     2.646    74.984     0.200
     1.086    37.389     0.200
     1.392    44.988     0.200
     1.501    47.287     0.200
     1.619    51.787     0.200
     2.639    73.287     0.200
     1.579    49.523     0.200
     1.579    49.824     0.200
     1.790    56.123     0.200
     1.884    59.123     0.200
     1.997    58.824     0.200
     2.286    65.523     0.200
     2.775    76.623     0.200
     2.854    79.723     0.200
     3.374    91.223     0.200
     3.374    91.523     0.200
     3.506    94.723     0.200
     3.563    96.623     0.200
     5.405   142.223     0.200
     5.405   142.924     0.200
     6.748   173.023     0.200
     1.391    46.484     0.200
     1.510    49.984     0.200
     1.666    53.586     0.200
     2.242    65.680     0.200
     2.566    74.180     0.200
     2.641    75.383     0.200
     3.046    83.781     0.200
     3.342    89.586     0.200
     3.366    92.984     0.200
     3.366    94.883     0.200
     4.088   105.984     0.200
     4.341   115.180     0.200
     5.299   143.086     0.200
     5.516   143.781     0.200
     5.507   147.883     0.200
     6.886   177.883     0.200
     1.389    46.375     0.200
     1.505    47.977     0.200
     1.505    49.875     0.200
     2.638    75.570     0.200
     3.051    83.672     0.200
     3.051    85.672     0.200
     3.341    91.070     0.200
     3.341    88.977     0.200
     3.363    92.477     0.200
     4.337   115.477     0.200
     4.337   115.172     0.200
     4.853   128.375     0.200
     4.853   131.477     0.200
     5.298   140.172     0.200
     6.887   177.070     0.200
     2.313    65.641     0.200
     2.288    64.844     0.200
     3.233    87.742     0.200
     3.543    94.344     0.200
     4.267   111.344     0.200
     4.740   122.141     0.200
     4.740   124.141     0.200
     4.825   125.043     0.200
     5.738   149.242     0.200
     5.788   148.941     0.200
     6.130   158.242     0.200
     1.660    53.523     0.200
     1.660    53.023     0.200
     2.635    73.922     0.200
     3.052    83.820     0.200
     3.052    84.125     0.200
     3.346    91.422     0.200
     4.340   115.125     0.200
     5.294   139.422     0.200
     6.891   177.422     0.200
     1.667    53.859     0.200
     1.909    60.758     0.200
     2.241    66.258     0.200
     2.241    65.258     0.200
     2.564    72.359     0.200
     2.564    73.160     0.200
     2.640    75.461     0.200
     3.045    84.859     0.200
     3.730   101.961     0.200
     4.087   109.160     0.200
     4.344   115.758     0.200
     4.344   115.359     0.200
     5.297   140.660     0.200
     5.515   144.258     0.200
     1.714    55.172     0.200
     1.967    62.773     0.200
     2.497    71.973     0.200
     2.988    83.375     0.200
     3.950   105.672     0.200
     4.043   106.574     0.200
     4.383   115.172     0.200
     4.407   117.074     0.200
     4.407   116.973     0.200
     5.221   135.773     0.200
     5.221   136.375     0.200
     5.294   140.773     0.200
     5.294   142.672     0.200
     5.460   141.672     0.200
     5.690   151.375     0.200
     1.146    39.773     0.200
     4.399   116.875     0.200
     1.709    55.238     0.200
     1.964    62.338     0.200
     2.663    76.438     0.200
     2.992    81.338     0.200
     2.992    82.038     0.200
     3.941   105.638     0.200
     4.416   116.838     0.200
     5.228   136.138     0.200
     5.284   142.638     0.200
     6.888   178.838     0.200
     1.709    55.317     0.200
     1.960    62.817     0.200
     2.506    72.017     0.200
     4.396   116.517     0.200
     4.867   132.717     0.200
     5.298   140.917     0.200
     5.298   142.417     0.200
     6.877   178.417     0.200
     1.722    55.590     0.200
     2.490    70.891     0.200
     2.490    73.090     0.200
     2.678    77.691     0.200
     2.981    83.090     0.200
     3.397    95.891     0.200
     4.409   116.992     0.200
     4.409   116.289     0.200
     4.872   132.191     0.200
     5.214   138.289     0.200
     5.300   142.492     0.200
     5.452   140.992     0.200
     6.873   177.789     0.200
     1.574    50.221     0.200
     1.574    52.121     0.200
     1.714    54.821     0.200
     1.965    62.621     0.200
     2.671    76.721     0.200
     2.990    83.021     0.200
     3.391    94.621     0.200
     4.383   117.721     0.200
     4.402   115.621     0.200
     5.297   141.121     0.200
     6.876   177.921     0.200
     1.136    39.479     0.200
     1.415    47.180     0.200
     1.576    49.779     0.200
     1.576    51.879     0.200
     1.717    55.279     0.200
     1.717    53.879     0.200
     1.968    62.379     0.200
     2.194    64.078     0.200
     4.401   116.379     0.200
     5.301   141.779     0.200
     1.405    44.754     0.200
     1.511    47.855     0.200
     1.511    49.152     0.200
     1.674    53.152     0.200
     1.674    53.254     0.200
     2.234    64.855     0.200
     2.653    75.152     0.200
     3.042    83.652     0.200
     3.325    89.555     0.200
     3.720   101.152     0.200
     3.720   101.254     0.200
     4.327   114.355     0.200
     4.327   113.254     0.200
     4.870   130.754     0.200
     5.315   141.055     0.200
     5.511   140.254     0.200
     6.870   177.555     0.200
     1.498    48.182     0.200
     1.611    51.182     0.200
     1.611    51.783     0.200
     1.875    59.783     0.200
     2.573    72.283     0.200
     2.573    70.783     0.200
     2.559    73.783     0.200
     2.559    72.982     0.200
     3.085    83.582     0.200
     3.277    89.682     0.200
     4.273   113.982     0.200
     4.424   117.283     0.200
     4.424   117.182     0.200
     4.755   126.283     0.200
     4.755   126.682     0.200
     5.190   136.682     0.200
     5.558   144.082     0.200
     6.988   180.783     0.200
     1.103    40.625     0.200
     1.524    50.227     0.200
     1.680    53.727     0.200
     2.552    73.031     0.200
     2.653    74.930     0.200
     3.032    83.031     0.200
     4.074   110.828     0.200
     4.348   115.625     0.200
     4.348   116.531     0.200
     5.305   142.625     0.200
     5.502   142.828     0.200
     5.635   152.352     0.200
     6.877   177.727     0.200
    12.634   322.930     0.200
    16.311   409.625     0.200
    17.394   434.328     0.200
     1.394    44.707     0.200
     1.520    48.305     0.200
     1.520    49.906     0.200
     1.673    53.805     0.200
     1.917    60.805     0.200
     2.235    64.105     0.200
     2.645    74.406     0.200
     3.038    86.406     0.200
     3.038    82.805     0.200
     3.348    93.805     0.200
     3.725   104.406     0.200
     4.351   114.605     0.200
     4.351   114.906     0.200
     4.856   131.105     0.200
     5.631   151.906     0.200
    14.261   355.105     0.200
    14.873   371.305     0.200
    17.401   436.805     0.200
     1.278    42.484     0.200
     1.604    51.883     0.200
     1.875    59.688     0.200
     4.451   116.781     0.200
     1.795    57.242     0.200
     1.810    57.945     0.200
     2.674    76.547     0.200
     2.692    76.047     0.200
     3.338    91.742     0.200
     1.497    47.980     0.200
     1.690    54.383     0.200
     1.690    61.180     0.200
     1.894    60.180     0.200
     2.625    73.883     0.200
     2.879    80.281     0.200
     3.061    84.480     0.200
     4.341   114.980     0.200
     5.285   140.582     0.200
     6.901   175.480     0.200
     6.901   177.680     0.200
     1.423    45.768     0.200
     4.506   117.268     0.200
     1.394    44.508     0.200
     1.525    48.406     0.200
     2.232    64.406     0.200
     2.253    64.906     0.200
     2.550    71.109     0.200
     2.646    74.406     0.200
     2.900    80.109     0.200
     3.034    82.309     0.200
     3.352    90.309     0.200
     3.370    91.309     0.200
     3.723    98.609     0.200
     4.357   113.508     0.200
     4.351   115.508     0.200
     4.856   131.406     0.200
     5.296   138.109     0.200
     6.675   170.508     0.200
     6.885   174.207     0.200
     6.885   176.508     0.200
     1.419    45.156     0.200
     1.545    49.555     0.200
     1.808    57.656     0.200
     2.201    64.555     0.200
     2.885    81.758     0.200
     4.428   122.359     0.200
     4.904   132.055     0.200
     6.859   176.555     0.200
     7.310   187.656     0.200
     2.469    66.805     0.200
     2.867    77.707     0.200
     3.127    82.508     0.200
     3.607    95.805     0.200
     4.209   109.508     0.200
     5.130   135.707     0.200
     6.608   170.305     0.200
     1.448    45.391     0.200
     1.509    48.092     0.200
     2.171    62.992     0.200
     2.701    74.592     0.200
     2.921    81.492     0.200
     3.470    93.791     0.200
     4.395   116.291     0.200
     4.886   126.092     0.200
     7.334   187.291     0.200
     1.456    45.922     0.200
     1.507    48.324     0.200
     1.801    56.824     0.200
     2.429    68.121     0.200
     2.421    69.121     0.200
     2.630    75.324     0.200
     2.669    73.523     0.200
     3.181    85.523     0.200
     3.181    87.422     0.200
     3.132    85.922     0.200
     3.132    87.922     0.200
     3.556    95.422     0.200
     3.603    98.523     0.200
     3.684    99.121     0.200
     3.939   104.922     0.200
     4.272   113.324     0.200
     4.515   118.523     0.200
     4.599   125.824     0.200
     5.029   132.523     0.200
     5.655   144.922     0.200
     7.146   183.922     0.200
    14.614   368.723     0.200
    16.565   416.723     0.200
     1.405    47.211     0.200
     1.507    48.111     0.200
     1.672    54.011     0.200
     1.909    60.811     0.200
     4.322   114.811     0.200
     4.870   133.811     0.200
     5.316   138.311     0.200
     5.316   141.211     0.200
     6.870   177.811     0.200
     1.389    46.438     0.200
     1.498    48.344     0.200
     1.898    60.844     0.200
     2.578    71.344     0.200
     2.578    71.641     0.200
     3.057    83.242     0.200
     4.095   108.742     0.200
     4.329   115.141     0.200
     4.329   115.641     0.200
     4.337   112.438     0.200
     5.300   140.938     0.200
     6.886   178.742     0.200
     1.173    40.799     0.200
     1.501    50.299     0.200
     1.662    53.500     0.200
     1.703    54.799     0.200
     1.901    61.000     0.200
     2.575    73.799     0.200
     2.764    75.900     0.200
     2.895    81.299     0.200
     3.053    84.500     0.200
     3.333    90.699     0.200
     3.421    90.799     0.200
     4.091   109.500     0.200
     4.328   114.100     0.200
     4.328   115.299     0.200
     4.858   132.699     0.200
     5.304   141.000     0.200
     5.304   139.199     0.200
     6.882   178.199     0.200
     1.164    40.047     0.200
     1.389    44.945     0.200
     1.492    47.547     0.200
     1.492    49.344     0.200
     1.655    52.945     0.200
     1.655    53.047     0.200
     1.893    60.344     0.200
     2.253    63.445     0.200
     2.585    71.445     0.200
     2.585    74.648     0.200
     2.635    73.945     0.200
     2.760    76.148     0.200
     3.062    85.344     0.200
     3.739    97.648     0.200
     4.320   114.844     0.200
     4.320   115.344     0.200
     4.855   129.844     0.200
     4.855   130.445     0.200
     5.303   138.445     0.200
     6.885   176.648     0.200
     1.466    46.945     0.200
     1.525    48.844     0.200
     1.759    54.047     0.200
     2.290    64.445     0.200
     3.017    82.344     0.200
     3.353    89.844     0.200
     3.738    98.344     0.200
     4.361   115.250     0.200
     4.720   123.445     0.200
     5.212   136.047     0.200
     5.624   147.344     0.200
     6.538   165.945     0.200
     1.268    40.139     0.200
     1.517    47.439     0.200
     2.507    70.639     0.200
     2.763    76.139     0.200
     2.958    82.439     0.200
     3.241    86.139     0.200
     5.423   143.539     0.200
     1.107    38.430     0.200
     1.277    41.430     0.200
     1.358    44.023     0.200
     1.396    45.625     0.200
     1.615    51.430     0.200
     2.338    67.227     0.200
     2.594    74.125     0.200
     2.829    78.727     0.200
     5.058   134.625     0.200
     5.264   138.930     0.200
     1.106    38.238     0.200
     1.358    43.738     0.200
     1.396    45.641     0.200
     1.616    51.539     0.200
     2.827    77.039     0.200
     4.397   112.238     0.200
     5.056   135.738     0.200
     1.545    48.723     0.200
     1.544    48.522     0.200
     2.423    68.322     0.200
     2.498    69.622     0.200
     2.498    70.822     0.200
     2.667    72.522     0.200
     3.147    84.822     0.200
     3.125    85.522     0.200
     3.680    97.322     0.200
     3.661   100.923     0.200
     4.611   119.322     0.200
     4.611   118.822     0.200
     4.573   125.322     0.200
     4.983   130.223     0.200
     4.983   132.423     0.200
     7.181   184.022     0.200
     1.350    43.617     0.200
     1.408    45.414     0.200
     1.654    52.117     0.200
     1.720    54.812     0.200
     2.391    66.914     0.200
     2.512    71.016     0.200
     2.906    79.711     0.200
     3.179    87.211     0.200
     3.179    86.617     0.200
     3.160    87.711     0.200
     3.631    98.312     0.200
     4.321   113.812     0.200
     5.114   137.117     0.200
     5.114   136.711     0.200
     5.282   137.617     0.200
     5.540   147.516     0.200
     5.681   149.211     0.200
     6.630   171.016     0.200
    14.013   350.516     0.200
     1.149    36.908     0.200
     1.475    47.008     0.200
     1.480    46.108     0.200
     1.743    54.608     0.200
     4.374   114.508     0.200
     4.391   113.008     0.200
     1.373    42.824     0.200
     1.373    44.426     0.200
     1.514    47.824     0.200
     2.234    63.426     0.200
     2.560    70.125     0.200
     2.627    73.426     0.200
     2.744    76.125     0.200
     2.880    78.926     0.200
     3.048    82.125     0.200
     3.350    90.324     0.200
     3.918   105.324     0.200
     5.276   139.223     0.200
     5.518   143.523     0.200
     1.372    43.594     0.200
     1.517    47.996     0.200
     1.696    54.797     0.200
     2.556    69.695     0.200
     1.136    37.621     0.200
     1.432    45.621     0.200
     1.553    49.320     0.200
     1.752    56.820     0.200
     2.196    62.422     0.200
     2.292    65.820     0.200
     2.525    71.023     0.200
     2.685    74.523     0.200
     2.803    78.621     0.200
     2.938    81.320     0.200
     3.409    92.121     0.200
     3.977   106.422     0.200
     4.351   113.820     0.200
     4.389   114.621     0.200
     4.894   131.121     0.200
     5.332   140.121     0.200
     1.170    41.082     0.200
     1.499    48.082     0.200
     1.499    49.781     0.200
     1.658    53.582     0.200
     5.298   142.582     0.200
     1.079    35.672     0.200
     1.079    38.270     0.200
     1.168    40.570     0.200
     1.613    50.969     0.200
     1.613    52.270     0.200
     1.654    52.871     0.200
     1.895    60.172     0.200
     4.333   114.672     0.200
     4.848   129.570     0.200
     5.272   133.570     0.200
     1.352    42.590     0.200
     1.375    43.990     0.200
     1.438    45.590     0.200
     1.487    45.690     0.200
     1.720    54.391     0.200
     2.209    63.791     0.200
     2.274    64.391     0.200
     2.904    80.484     0.200
     2.904    79.391     0.200
     4.348   117.090     0.200
     4.684   118.690     0.200
     4.766   124.291     0.200
     1.082    38.492     0.200
     1.388    44.492     0.200
     1.497    48.188     0.200
     1.698    54.891     0.200
     1.896    60.492     0.200
     2.636    74.086     0.200
     4.327   114.586     0.200
     4.853   129.891     0.200
     5.493   144.789     0.200
     1.082    38.570     0.200
     1.658    53.070     0.200
     1.658    53.172     0.200
     1.698    54.570     0.200
     1.900    60.672     0.200
     2.250    65.773     0.200
     2.574    72.375     0.200
     2.634    75.070     0.200
     3.344    89.977     0.200
     3.344    93.672     0.200
     3.359    95.273     0.200
     4.337   116.477     0.200
     4.337   115.273     0.200
     4.849   132.977     0.200
     4.849   132.773     0.200
     5.294   142.477     0.200
     5.613   151.242     0.200
     6.891   178.273     0.200
     1.453    45.562     0.200
     1.676    53.359     0.200
     1.756    56.062     0.200
     1.816    58.562     0.200
     2.336    66.461     0.200
     2.726    74.262     0.200
     2.974    81.461     0.200
     3.972   105.762     0.200
     4.450   116.762     0.200
     4.497   117.160     0.200
     4.894   133.062     0.200
     5.301   137.562     0.200
     6.588   167.461     0.200
     6.859   173.359     0.200
     1.545    49.270     0.200
     1.593    51.070     0.200
     1.593    51.367     0.200
     1.657    53.770     0.200
     1.791    56.770     0.200
     2.224    64.270     0.200
     2.330    68.168     0.200
     2.621    74.867     0.200
     2.621    74.969     0.200
     2.780    77.570     0.200
     2.880    79.867     0.200
     3.202    87.270     0.200
     3.174    86.867     0.200
     3.360    91.270     0.200
     3.789   101.969     0.200
     4.138   110.168     0.200
     4.138   110.668     0.200
     4.288   114.270     0.200
     4.884   134.570     0.200
     5.369   142.270     0.200
     5.459   145.270     0.200
     6.722   174.469     0.200
     6.855   178.070     0.200
     1.114    37.398     0.200
     1.429    45.695     0.200
     1.509    46.797     0.200
     1.642    50.797     0.200
     1.731    54.297     0.200
     2.672    74.297     0.200
     4.298   112.898     0.200
     4.895   131.797     0.200
     1.535    47.422     0.200
     1.597    49.824     0.200
     2.119    58.824     0.200
     2.945    80.023     0.200
     4.293   112.023     0.200
     1.296    43.617     0.200
     1.374    46.617     0.200
     1.923    61.218     0.200
     2.319    68.417     0.200
     2.575    73.817     0.200
     2.857    79.718     0.200
     3.052    86.718     0.200
     3.371    92.617     0.200
     4.297   113.518     0.200
     4.565   124.218     0.200
     4.565   123.018     0.200
     5.051   134.817     0.200
     6.867   174.817     0.200
     6.996   183.117     0.200
     1.483    48.168     0.200
     1.731    55.168     0.200
     2.070    62.168     0.200
     2.425    70.270     0.200
     2.598    74.068     0.200
     2.725    77.469     0.200
     2.720    76.168     0.200
     3.419    93.369     0.200
     3.912   104.969     0.200
     4.311   115.270     0.200
     5.163   139.969     0.200
     7.041   181.668     0.200
    14.190   359.969     0.200
    14.924   379.770     0.200
     1.321    44.574     0.200
     1.711    54.074     0.200
     1.150    38.805     0.200
     1.433    46.004     0.200
     1.476    47.906     0.200
     1.520    49.805     0.200
     1.718    54.504     0.200
     2.465    70.605     0.200
     2.744    76.605     0.200
     2.721    76.805     0.200
     3.196    88.305     0.200
     3.237    86.605     0.200
     3.783   104.105     0.200
     4.286   113.707     0.200
     4.703   123.605     0.200
     5.336   139.605     0.200
     1.514    50.375     0.200
     1.665    54.273     0.200
     1.910    60.875     0.200
     2.244    65.875     0.200
     2.244    66.172     0.200
     2.560    73.078     0.200
     2.560    74.078     0.200
     2.636    74.273     0.200
     3.045    84.273     0.200
     3.045    83.078     0.200
     3.355    93.773     0.200
     4.354   115.672     0.200
     4.354   115.273     0.200
     4.847   131.172     0.200
     4.847   130.773     0.200
     5.288   140.773     0.200
     5.627   153.031     0.200
     6.894   178.273     0.200
    15.115   381.203     0.200
     1.614    51.619     0.200
     1.896    60.320     0.200
     2.239    64.920     0.200
     2.578    71.920     0.200
     2.633    74.619     0.200
     4.332   113.820     0.200
     1.487    47.262     0.200
     1.789    55.359     0.200
     1.856    56.859     0.200
     1.840    57.859     0.200
     1.485    47.758     0.200
     1.487    45.758     0.200
     2.705    75.656     0.200
     2.648    74.156     0.200
     3.102    85.258     0.200
     3.043    82.156     0.200
     3.159    85.156     0.200
     3.333    92.457     0.200
     3.296    88.957     0.200
     4.320   113.656     0.200
     5.163   132.059     0.200
     5.664   145.758     0.200
     6.500   167.258     0.200
     7.131   179.758     0.200
     7.908   195.457     0.200
     9.513   237.258     0.200
    13.882   347.758     0.200
    14.299   360.059     0.200
    22.952   569.473     0.200
     1.081    36.935     0.200
     1.299    41.835     0.200
     1.408    45.035     0.200
     1.410    45.535     0.200
     1.410    46.835     0.200
     2.351    67.935     0.200
     2.351    67.635     0.200
     2.447    68.734     0.200
     2.447    70.135     0.200
     2.600    73.635     0.200
     2.600    74.635     0.200
     2.687    75.135     0.200
     2.687    76.035     0.200
     3.063    85.129     0.200
     3.063    84.734     0.200
     3.063    83.435     0.200
     3.246    88.535     0.200
     3.246    86.335     0.200
     3.621    98.035     0.200
     3.643    97.734     0.200
     3.643    96.635     0.200
     3.618    98.335     0.200
     4.008   106.835     0.200
     4.080   108.535     0.200
     4.340   114.535     0.200
     4.519   120.135     0.200
     4.534   122.835     0.200
     4.534   124.135     0.200
     5.531   143.335     0.200
     5.522   147.295     0.200
     5.720   148.535     0.200
     6.963   177.035     0.200
     6.968   176.935     0.200
     7.210   185.435     0.200
     1.526    48.543     0.200
     1.708    53.645     0.200
     1.783    56.246     0.200
     2.896    80.043     0.200
     3.158    86.344     0.200
     5.177   139.043     0.200
     5.669   150.543     0.200
     1.497    49.695     0.200
     1.621    51.297     0.200
     1.663    53.094     0.200
     1.663    53.195     0.200
     1.706    55.094     0.200
     1.899    60.195     0.200
     2.581    73.594     0.200
     2.645    75.297     0.200
     2.900    81.695     0.200
     3.055    82.297     0.200
     4.315   115.391     0.200
     4.315   115.492     0.200
     4.865   130.297     0.200
     4.865   131.094     0.200
     5.314   140.797     0.200
     6.874   175.297     0.200
     1.872    53.719     0.200
     1.995    57.617     0.200
     2.090    60.316     0.200
     2.636    73.020     0.200
     3.030    82.219     0.200
     3.284    88.816     0.200
     3.346    89.219     0.200
     3.755   100.117     0.200
     4.317   111.918     0.200
     4.319   114.117     0.200
     5.175   132.219     0.200
     5.235   135.918     0.200
     5.654   146.418     0.200
     6.511   164.117     0.200
     7.669   194.219     0.200
     1.082    38.105     0.200
     1.657    52.605     0.200
     2.251    64.906     0.200
     2.242    65.508     0.200
     2.580    71.707     0.200
     2.636    74.207     0.200
     3.362    92.207     0.200
     3.737   100.809     0.200
     3.936   104.906     0.200
     4.096   110.008     0.200
     4.325   114.605     0.200
     4.336   114.707     0.200
     4.854   130.406     0.200
     1.086    38.301     0.200
     1.496    47.801     0.200
     1.660    53.102     0.200
     1.702    54.402     0.200
     2.641    75.102     0.200
     2.765    76.801     0.200
     4.320   114.500     0.200
     1.684    54.043     0.200
     2.295    67.943     0.200
     1.671    52.697     0.200
     1.735    55.098     0.200
     0.964    32.742     0.200
     1.457    46.641     0.200
     2.201    61.539     0.200
     2.980    80.844     0.200
     5.523   141.844     0.200
     1.429    46.098     0.200
     1.487    47.898     0.200
     1.524    48.496     0.200
     1.524    49.496     0.200
     1.550    50.195     0.200
     2.078    61.398     0.200
     2.470    70.695     0.200
     2.645    76.496     0.200
     2.645    73.598     0.200
     2.581    73.695     0.200
     2.721    76.898     0.200
     3.168    86.695     0.200
     3.190    87.797     0.200
     3.503    94.496     0.200
     3.755   103.098     0.200
     3.894   103.297     0.200
     4.424   116.297     0.200
     4.424   116.098     0.200
     4.672   126.496     0.200
     5.115   134.398     0.200
     5.548   148.469     0.200
     5.642   144.496     0.200
     1.348    44.193     0.200
     1.567    50.285     0.200
     1.608    51.984     0.200
     1.646    52.285     0.200
     2.187    62.285     0.200
     2.610    73.184     0.200
     2.581    72.383     0.200
     2.835    78.086     0.200
     3.100    83.484     0.200
     3.879   102.484     0.200
     4.284   114.883     0.200
     4.344   114.086     0.200
     4.797   126.586     0.200
     5.246   137.586     0.200
     5.570   144.086     0.200
     1.489    45.820     0.200
     1.724    54.219     0.200
     1.767    54.420     0.200
     2.141    60.420     0.200
     2.141    62.119     0.200
     2.349    66.119     0.200
     2.488    70.920     0.200
     2.742    75.920     0.200
     2.952    80.119     0.200
     2.996    82.020     0.200
     3.289    88.719     0.200
     3.987   105.520     0.200
     4.950   133.420     0.200
     4.950   131.420     0.200
     5.385   141.520     0.200
     5.702   152.160     0.200
     6.792   173.020     0.200
     6.792   174.920     0.200
    12.041   301.520     0.200
    14.167   352.619     0.200
    16.748   419.719     0.200
     1.296    41.726     0.200
     1.294    42.025     0.200
     1.335    43.325     0.200
     1.335    43.726     0.200
     2.319    66.226     0.200
     2.462    69.325     0.200
     2.575    72.825     0.200
     2.852    78.825     0.200
     3.367    91.426     0.200
     3.367    90.625     0.200
     3.497    91.825     0.200
     3.643    98.226     0.200
     3.738    99.625     0.200
     4.060   106.726     0.200
     4.012   107.926     0.200
     4.303   113.726     0.200
     4.419   116.726     0.200
     4.564   125.625     0.200
     4.564   122.226     0.200
     5.048   134.125     0.200
     5.839   150.726     0.200
    12.324   310.625     0.200
     1.289    42.129     0.200
     1.303    42.430     0.200
     1.344    43.328     0.200
     1.464    47.820     0.200
     1.870    57.719     0.200
     1.844    58.523     0.200
     3.010    83.125     0.200
     1.527    48.025     0.200
     1.630    51.025     0.200
     2.781    75.225     0.200
     3.034    83.525     0.200
     3.590    97.326     0.200
     4.070   107.125     0.200
     4.348   114.326     0.200
     4.484   118.525     0.200
     4.986   130.625     0.200
     5.120   131.826     0.200
     5.384   139.426     0.200
     5.417   144.025     0.200
     6.757   170.625     0.200
     1.092    38.492     0.200
     1.627    51.391     0.200
     1.669    53.891     0.200
     1.707    54.992     0.200
     1.912    60.391     0.200
     2.557    73.992     0.200
     2.641    75.695     0.200
     2.895    80.992     0.200
     3.366    92.789     0.200
     4.347   116.492     0.200
     5.296   138.891     0.200
     1.433    46.117     0.200
     1.433    48.312     0.200
     1.465    47.312     0.200
     1.786    57.414     0.200
     2.426    70.719     0.200
     2.644    74.219     0.200
     3.570    98.016     0.200
     4.479   120.219     0.200
     4.615   127.812     0.200
     5.052   133.617     0.200
     5.052   136.617     0.200
     6.661   171.812     0.200
     1.251    40.902     0.200
     1.798    56.504     0.200
     1.809    54.602     0.200
     1.809    56.902     0.200
     1.830    55.902     0.200
     1.877    56.102     0.200
     1.877    58.402     0.200
     2.234    64.504     0.200
     2.273    64.305     0.200
     3.265    89.902     0.200
     4.634   122.805     0.200
     4.940   126.602     0.200
     1.358    42.375     0.200
     1.601    50.074     0.200
     1.808    56.973     0.200
     1.905    55.574     0.200
     2.265    63.375     0.200
     2.202    62.773     0.200
     2.487    69.672     0.200
     3.124    85.273     0.200
     3.363    89.375     0.200
     3.820   101.574     0.200
     4.123   109.172     0.200
     4.520   116.672     0.200
     4.601   120.574     0.200
     5.034   133.473     0.200
     5.034   133.574     0.200
     5.226   134.574     0.200
     5.425   143.172     0.200
     5.919   155.555     0.200
     8.167   204.273     0.200
    12.055   301.875     0.200
    13.006   325.375     0.200
    15.040   375.422     0.200
    19.880   496.672     0.200
     1.375    44.055     0.200
     4.523   116.055     0.200
     5.049   135.453     0.200
     5.438   141.453     0.200
     1.354    43.477     0.200
     4.528   116.578     0.200
     5.230   134.977     0.200
     5.415   143.078     0.200
     1.509    47.594     0.200
     1.657    52.691     0.200
     1.903    60.191     0.200
     2.251    64.492     0.200
     2.234    64.891     0.200
     2.627    74.691     0.200
     2.627    74.891     0.200
     2.746    76.293     0.200
     2.880    81.492     0.200
     3.362    91.992     0.200
     3.351    92.691     0.200
     3.742   101.594     0.200
     4.332   114.891     0.200
     4.356   113.293     0.200
     4.356   116.191     0.200
     4.838   128.191     0.200
     4.838   131.094     0.200
     5.272   136.992     0.200
     5.280   138.992     0.200
     6.694   173.191     0.200
     1.585    49.894     0.200
     1.682    51.594     0.200
     1.682    53.094     0.200
     2.190    62.794     0.200
     4.412   114.394     0.200
     5.297   141.194     0.200
     1.096    35.587     0.200
     1.318    42.387     0.200
     1.398    44.087     0.200
     1.587    49.387     0.200
     4.071   106.387     0.200
     1.167    37.590     0.200
     1.339    42.789     0.200
     1.391    43.289     0.200
     1.399    44.789     0.200
     1.463    45.488     0.200
     4.195   109.691     0.200
     1.704    53.844     0.200
     1.718    54.844     0.200
     1.749    55.844     0.200
     1.750    55.844     0.200
     2.217    63.844     0.200
     2.375    68.945     0.200
     2.375    68.547     0.200
     2.625    75.445     0.200
     2.625    74.445     0.200
     2.867    82.242     0.200
     2.867    80.344     0.200
     3.320    92.547     0.200
     3.320    90.844     0.200
     3.842   103.945     0.200
     4.659   122.148     0.200
     4.659   122.344     0.200
     5.132   136.844     0.200
     5.132   134.547     0.200
     5.415   140.945     0.200
     1.260    44.112     0.200
     1.514    48.512     0.200
     4.432   119.312     0.200
     4.917   129.712     0.200
     1.509    47.477     0.200
     1.750    54.977     0.200
     1.800    55.078     0.200
     1.800    57.180     0.200
     1.830    57.180     0.200
     2.209    61.977     0.200
     2.263    65.477     0.200
     2.263    64.977     0.200
     2.448    70.875     0.200
     2.635    73.680     0.200
     2.704    73.875     0.200
     2.898    80.477     0.200
     2.898    80.578     0.200
     3.421    92.977     0.200
     3.896   102.078     0.200
     3.964   105.078     0.200
     4.162   109.773     0.200
     4.331   117.375     0.200
     4.467   117.375     0.200
     4.735   121.477     0.200
     4.738   124.375     0.200
     5.490   140.375     0.200
     5.490   142.680     0.200
     5.673   144.773     0.200
     6.719   171.477     0.200
     7.115   180.578     0.200
     7.425   187.773     0.200
     7.988   203.180     0.200
     1.667    52.883     0.200
     1.667    54.285     0.200
     1.698    54.383     0.200
     2.002    63.484     0.200
     2.424    69.785     0.200
     2.424    70.684     0.200
     2.575    74.383     0.200
     2.640    75.586     0.200
     2.817    80.383     0.200
     2.992    82.586     0.200
     3.272    92.152     0.200
     3.630    98.586     0.200
     3.630   100.184     0.200
     3.789   103.285     0.200
     4.105   110.184     0.200
     4.317   116.285     0.200
     4.646   122.883     0.200
     5.096   135.586     0.200
     5.304   137.883     0.200
     5.683   148.184     0.200
     1.887    60.078     0.200
     2.282    66.180     0.200
     2.537    72.875     0.200
     4.341   114.477     0.200
     5.000   130.578     0.200
     1.662    53.617     0.200
     1.701    54.922     0.200
     1.701    54.719     0.200
     2.005    64.219     0.200
     2.192    65.219     0.200
     2.266    66.320     0.200
     2.576    75.117     0.200
     2.640    76.117     0.200
     2.640    76.219     0.200
     2.818    79.422     0.200
     2.990    82.422     0.200
     3.633    99.820     0.200
     3.788   103.117     0.200
     4.319   118.219     0.200
     4.650   122.617     0.200
     4.650   123.016     0.200
     4.706   128.320     0.200
     4.706   128.617     0.200
     5.095   137.422     0.200
     5.095   136.422     0.200
     5.465   142.922     0.200
     5.686   149.516     0.200
     6.440   165.820     0.200
     7.059   181.219     0.200
     8.268   210.719     0.200
     1.681    53.898     0.200
     1.676    53.297     0.200
     1.710    54.797     0.200
     1.712    54.297     0.200
     2.018    60.699     0.200
     2.199    64.098     0.200
     2.582    73.996     0.200
     3.278    90.496     0.200
     4.663   122.098     0.200
     4.708   125.199     0.200
     1.741    55.836     0.200
     1.822    58.137     0.200
     2.125    61.336     0.200
     2.362    68.434     0.200
     2.755    76.934     0.200
     2.870    80.234     0.200
     3.008    84.234     0.200
     3.292    89.035     0.200
     3.478    92.535     0.200
     4.357   114.734     0.200
     4.960   134.535     0.200
     4.960   133.336     0.200
     5.403   138.836     0.200
     5.391   141.137     0.200
     7.393   187.336     0.200
     8.606   218.637     0.200
    12.039   300.137     0.200
    14.151   355.336     0.200
    20.936   525.836     0.200
     1.694    53.508     0.200
     1.704    53.410     0.200
     1.735    55.410     0.200
     1.735    55.309     0.200
     2.233    65.508     0.200
     2.226    64.309     0.200
     2.388    69.609     0.200
     2.609    74.410     0.200
     2.670    74.809     0.200
     2.956    80.609     0.200
     2.851    81.508     0.200
     3.304    92.492     0.200
     3.626    98.711     0.200
     3.626    98.609     0.200
     3.756    99.910     0.200
     4.353   116.211     0.200
     4.661   122.109     0.200
     4.661   122.008     0.200
     4.734   129.109     0.200
     5.430   140.711     0.200
     1.158    39.102     0.200
     1.370    45.102     0.200
     1.424    44.703     0.200
     1.461    46.203     0.200
     1.487    47.797     0.200
     1.733    54.398     0.200
     4.406   116.000     0.200
     1.506    47.875     0.200
     1.506    48.570     0.200
     1.681    52.570     0.200
     4.273   117.875     0.200
     4.740   128.773     0.200
     5.309   143.031     0.200
     1.598    50.875     0.200
     1.727    54.773     0.200
     1.820    58.078     0.200
     2.211    64.578     0.200
     2.829    79.078     0.200
     2.929    81.844     0.200
     4.415   117.180     0.200
     4.875   130.273     0.200
     5.385   145.016     0.200
     1.504    47.363     0.200
     1.734    54.262     0.200
     1.874    58.660     0.200
     2.118    61.363     0.200
     2.334    67.562     0.200
     1.449    45.781     0.200
     1.590    49.984     0.200
     1.634    51.781     0.200
     1.859    58.680     0.200
     4.255   111.383     0.200
     4.321   114.281     0.200
     4.868   131.180     0.200
     5.329   142.984     0.200
     1.437    46.287     0.200
     1.751    54.488     0.200
     1.778    56.387     0.200
     1.913    59.188     0.200
     1.956    58.387     0.200
     2.604    73.488     0.200
     2.999    82.887     0.200
     3.253    88.287     0.200
     3.726   100.488     0.200
     1.373    43.066     0.200
     1.457    46.664     0.200
     1.312    45.545     0.200
     1.538    48.844     0.200
     1.726    54.943     0.200
     1.860    58.244     0.200
     2.255    64.943     0.200
     4.992   136.045     0.200
     1.604    50.762     0.200
     1.734    54.660     0.200
     1.828    57.660     0.200
     2.218    63.762     0.200
     2.823    80.363     0.200
     4.422   121.262     0.200
     4.881   131.562     0.200
     1.422    45.061     0.200
     1.507    48.160     0.200
     1.725    54.260     0.200
     2.272    64.561     0.200
     2.666    74.160     0.200
     2.921    80.561     0.200
     2.921    80.260     0.200
     3.394    92.078     0.200
     3.394    91.859     0.200
     4.302   113.260     0.200
     5.338   138.459     0.200
     7.932   200.910     0.200
     1.366    43.141     0.200
     1.527    46.742     0.200
     1.647    50.742     0.200
     1.647    50.039     0.200
     1.752    54.539     0.200
     1.752    54.641     0.200
     1.760    53.141     0.200
     1.760    55.336     0.200
     1.757    55.938     0.200
     2.150    62.742     0.200
     2.150    61.242     0.200
     2.740    74.336     0.200
     2.795    77.539     0.200
     3.298    91.141     0.200
     4.268   112.641     0.200
     4.204   112.641     0.200
     4.595   120.641     0.200
     4.859   123.742     0.200
     1.449    45.703     0.200
     1.546    48.000     0.200
     1.674    52.203     0.200
     1.760    55.898     0.200
     1.197    38.520     0.200
     1.197    40.922     0.200
     1.259    40.320     0.200
     1.335    42.422     0.200
     1.337    45.621     0.200
     1.561    49.520     0.200
     1.751    54.621     0.200
     1.884    58.219     0.200
     2.280    64.621     0.200
     1.023    35.699     0.200
     1.478    46.398     0.200
     1.604    49.898     0.200
     2.563    70.602     0.200
     4.769   123.500     0.200
     5.210   133.898     0.200
     1.301    41.885     0.200
     1.301    43.184     0.200
     1.331    42.484     0.200
     1.548    47.885     0.200
     1.420    44.902     0.200
     1.509    47.801     0.200
     1.801    56.500     0.200
     2.920    79.699     0.200
     4.924   131.402     0.200
     1.319    41.508     0.200
     1.319    43.109     0.200
     1.350    42.211     0.200
     1.350    43.008     0.200
     1.411    43.211     0.200
     1.411    43.414     0.200
     1.420    45.508     0.200
     2.333    63.414     0.200
     2.309    65.414     0.200
     2.309    65.211     0.200
     2.497    69.609     0.200
     2.721    76.211     0.200
     2.793    76.609     0.200
     2.836    77.109     0.200
     3.163    86.211     0.200
     3.558    94.812     0.200
     3.813    98.812     0.200
     4.753   122.312     0.200
     4.849   126.008     0.200
     5.763   150.414     0.200
     5.763   150.609     0.200
     6.146   159.062     0.200
     6.163   159.109     0.200
     1.398    44.471     0.200
     1.612    51.170     0.200
     1.690    53.270     0.200
     2.667    73.971     0.200
     4.468   115.971     0.200
     4.846   131.670     0.200
     5.263   140.070     0.200
     1.378    43.645     0.200
     1.694    53.746     0.200
     1.882    59.145     0.200
     1.257    40.496     0.200
     1.287    42.496     0.200
     1.445    45.594     0.200
     1.600    50.594     0.200
     1.718    54.496     0.200
     1.804    56.793     0.200
     2.193    62.594     0.200
     2.299    65.293     0.200
     2.443    68.996     0.200
     2.657    73.496     0.200
     2.828    78.996     0.200
     2.909    79.996     0.200
     3.920   105.293     0.200
     4.007   107.293     0.200
     4.167   109.094     0.200
     4.391   119.094     0.200
     4.500   117.793     0.200
     4.846   127.395     0.200
     5.311   139.395     0.200
     7.020   180.020     0.200
     1.255    40.453     0.200
     1.353    43.854     0.200
     1.815    55.453     0.200
     1.815    57.053     0.200
     1.857    56.152     0.200
     1.857    58.254     0.200
     1.818    58.453     0.200
     2.261    64.152     0.200
     2.173    64.354     0.200
     2.643    72.854     0.200
     2.665    75.754     0.200
     3.315    89.771     0.200
     3.315    90.152     0.200
     4.340   116.754     0.200
     4.699   125.453     0.200
     4.869   125.754     0.200
     5.038   132.354     0.200
     6.451   165.242     0.200
     1.293    42.253     0.200
     1.310    41.653     0.200
     1.615    50.553     0.200
     1.798    56.553     0.200
     2.186    62.453     0.200
     2.434    68.653     0.200
     3.991   106.053     0.200
     4.374   119.053     0.200
     4.823   128.853     0.200
     5.411   143.773     0.200
     7.008   178.953     0.200
     8.365   212.651     0.200
     1.720    53.982     0.200
     1.804    56.582     0.200
     1.864    58.582     0.200
     2.383    67.281     0.200
     1.270    41.992     0.200
     1.512    48.195     0.200
     1.512    47.992     0.200
     1.734    54.891     0.200
     1.818    55.492     0.200
     1.818    57.695     0.200
     1.879    58.695     0.200
     2.839    79.492     0.200
     2.786    77.695     0.200
     3.034    83.594     0.200
     3.406    93.289     0.200
     3.495    97.234     0.200
     4.948   135.391     0.200
     5.347   142.789     0.200
     5.848   155.812     0.200
    14.086   353.789     0.200
     1.528    48.562     0.200
     1.814    57.461     0.200
     2.451    71.262     0.200
     1.467    46.508     0.200
     1.525    48.602     0.200
     1.562    49.008     0.200
     1.585    50.805     0.200
     1.835    58.508     0.200
     6.794   174.758     0.200
     1.222    38.590     0.200
     1.274    40.289     0.200
     1.365    43.289     0.200
     1.406    44.590     0.200
     1.655    52.488     0.200
     1.861    58.988     0.200
     2.649    73.689     0.200
     1.270    39.992     0.200
     1.289    41.094     0.200
     1.420    44.695     0.200
     1.420    45.094     0.200
     1.593    49.793     0.200
     2.211    62.793     0.200
     3.683    97.395     0.200
     5.379   141.535     0.200
     7.027   179.770     0.200
     1.279    41.789     0.200
     1.279    41.289     0.200
     1.383    43.492     0.200
     1.669    51.992     0.200
     1.669    51.691     0.200
     1.292    41.311     0.200
     1.713    51.311     0.200
     1.713    53.811     0.200
     1.722    54.811     0.200
     1.730    53.611     0.200
     2.263    63.311     0.200
     2.382    66.311     0.200
     2.382    67.411     0.200
     2.820    77.911     0.200
     3.270    89.129     0.200
     6.575   168.211     0.200
    13.726   343.536     0.200
     1.250    42.648     0.200
     1.290    45.148     0.200
     1.575    49.648     0.200
     1.713    54.055     0.200
     1.813    57.453     0.200
     5.360   145.328     0.200
     1.360    44.008     0.200
     1.536    48.406     0.200
     1.625    51.109     0.200
     2.620    72.906     0.200
     2.871    79.406     0.200
     1.807    57.676     0.200
     1.074    34.785     0.200
     1.337    43.883     0.200
     2.602    72.984     0.200
     1.201    41.359     0.200
     1.759    56.258     0.200
     1.894    59.957     0.200
     2.289    66.660     0.200
     3.518    96.660     0.200
     4.309   113.859     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.216     7.424     0.200
     0.984    31.625     0.200
     1.823    54.524     0.200
     1.985    60.625     0.200
     1.902    58.121     0.200
     3.245    95.721     0.200
     0.358    12.965     0.200
     0.826    25.664     0.200
     1.750    51.664     0.200
     0.240    10.285     0.200
     1.163    36.285     0.200
     1.281    39.586     0.200
     0.258    11.070     0.200
     2.368    69.672     0.200
     0.264    10.621     0.200
     0.997    31.223     0.200
     1.436    43.020     0.200
     2.976    88.621     0.200
     0.327    11.648     0.200
     0.914    29.148     0.200
     1.506    45.148     0.200
     0.282    10.758     0.200
     0.314    11.488     0.200
     0.916    29.488     0.200
     1.391    44.391     0.200
     1.510    46.590     0.200
     2.713    79.789     0.200
     1.530    47.375     0.200
     5.841   170.977     0.200
     0.355    12.364     0.200
     0.995    31.564     0.200
     1.401    44.464     0.200
     1.413    45.464     0.200
     0.236     8.913     0.200
     0.569    18.213     0.200
     1.043    33.413     0.200
     1.331    42.713     0.200
     1.331    43.513     0.200
     1.501    46.913     0.200
     1.501    48.213     0.200
     1.630    50.513     0.200
     0.146     6.506     0.200
     0.649    22.006     0.200
     0.966    30.406     0.200
     1.407    45.205     0.200
     0.331    11.320     0.200
     1.021    32.320     0.200
     1.383    44.320     0.200
     1.464    46.227     0.200
     2.304    69.023     0.200
     0.260     7.973     0.200
     0.260     9.074     0.200
     0.589    19.574     0.200
     1.282    41.574     0.200
     1.282    42.473     0.200
     1.434    45.973     0.200
     0.224     9.280     0.200
     0.934    28.480     0.200
     0.951    30.580     0.200
     1.528    47.080     0.200
     0.206     7.406     0.200
     0.767    25.508     0.200
     0.997    32.508     0.200
     0.999    32.508     0.200
     1.045    33.406     0.200
     1.033    33.406     0.200
     1.034    33.406     0.200
     1.358    44.406     0.200
     1.509    48.609     0.200
     2.167    69.109     0.200
     2.360    74.008     0.200
     0.352    11.817     0.200
     0.471    15.717     0.200
     0.984    31.117     0.200
     1.437    45.317     0.200
     1.437    45.518     0.200
     0.296     9.363     0.200
     0.560    18.660     0.200
     1.123    35.660     0.200
     1.250    40.461     0.200
     1.250    39.863     0.200
     1.575    50.363     0.200
     2.644    78.961     0.200
     0.118     5.759     0.200
     0.669    22.259     0.200
     0.906    28.159     0.200
     1.166    38.259     0.200
     1.247    39.559     0.200
     1.976    62.259     0.200
     0.258     8.352     0.200
     0.548    18.449     0.200
     0.548    18.551     0.200
     1.060    34.551     0.200
     1.038    34.449     0.200
     1.162    37.352     0.200
     1.314    41.648     0.200
     0.215     7.919     0.200
     0.982    31.019     0.200
     1.121    37.119     0.200
     1.236    39.919     0.200
     1.960    61.619     0.200
     0.235     9.926     0.200
     0.630    20.125     0.200
     0.872    28.426     0.200
     1.743    51.723     0.200
     1.743    53.824     0.200
     1.920    59.523     0.200
     1.949    60.324     0.200
     0.247     9.617     0.200
     0.920    28.914     0.200
     0.985    32.016     0.200
     1.105    35.715     0.200
     0.094     7.665     0.200
     0.698    23.365     0.200
     0.698    22.965     0.200
     0.923    28.965     0.200
     1.934    61.064     0.200
     0.212     9.223     0.200
     0.918    27.422     0.200
     0.949    30.322     0.200
     1.110    34.822     0.200
     1.143    36.422     0.200
     0.328    11.355     0.200
     1.182    37.559     0.200
     0.206     7.066     0.200
     0.598    19.867     0.200
     0.598    20.168     0.200
     1.020    31.566     0.200
     1.353    43.066     0.200
     1.353    43.168     0.200
     0.259    10.143     0.200
     0.259    10.643     0.200
     0.648    21.443     0.200
     1.025    32.143     0.200
     1.163    35.743     0.200
     1.407    42.443     0.200
     1.407    42.943     0.200
     1.482    45.743     0.200
     2.313    67.243     0.200
     0.302    10.829     0.200
     0.533    18.029     0.200
     0.929    28.729     0.200
     1.379    44.129     0.200
     1.479    47.329     0.200
     0.245     8.336     0.200
     0.245     8.938     0.200
     0.641    22.234     0.200
     1.308    41.336     0.200
     0.347    10.809     0.200
     0.347    11.910     0.200
     0.503    18.109     0.200
     2.308    67.809     0.200
     0.108     7.223     0.200
     0.108     6.820     0.200
     0.807    26.621     0.200
     1.440    44.121     0.200
     1.954    58.922     0.200
     1.954    60.922     0.200
     0.328    11.104     0.200
     0.456    15.305     0.200
     0.761    25.703     0.200
     0.895    28.604     0.200
     1.079    35.805     0.200
     1.079    35.203     0.200
     1.303    41.305     0.200
     1.303    41.703     0.200
     1.342    43.004     0.200
     0.226    10.062     0.200
     0.643    19.367     0.200
     0.938    31.266     0.200
     1.059    33.469     0.200
     1.201    37.664     0.200
     1.386    41.867     0.200
     0.311    11.414     0.200
     0.540    18.016     0.200
     0.540    18.211     0.200
     0.914    28.914     0.200
     0.914    29.016     0.200
     1.265    42.016     0.200
     0.751    23.599     0.200
     0.751    23.899     0.200
     0.752    24.799     0.200
     0.752    24.899     0.200
     0.798    26.000     0.200
     1.624    51.199     0.200
     0.171     6.676     0.200
     0.739    24.277     0.200
     0.739    24.578     0.200
     0.761    23.578     0.200
     0.761    23.977     0.200
     0.795    25.578     0.200
     1.392    43.676     0.200
     1.392    46.078     0.200
     1.614    50.977     0.200
     0.072     6.500     0.200
     0.814    27.500     0.200
     2.009    59.301     0.200
     0.338    11.578     0.200
     0.824    27.180     0.200
     0.928    28.781     0.200
     1.414    45.383     0.200
     1.414    46.281     0.200
     1.495    47.180     0.200
     1.495    48.281     0.200
     0.208     8.184     0.200
     0.581    19.883     0.200
     0.581    20.082     0.200
     0.669    22.281     0.200
     0.955    30.281     0.200
     0.955    29.582     0.200
     1.265    40.281     0.200
     1.989    62.883     0.200
     0.151     5.527     0.200
     0.648    21.629     0.200
     0.974    30.430     0.200
     1.179    38.027     0.200
     1.399    44.629     0.200
     0.130     6.109     0.200
     0.656    21.910     0.200
     0.656    21.711     0.200
     0.925    28.609     0.200
     0.925    28.711     0.200
     1.148    37.012     0.200
     1.232    39.410     0.200
     0.289    10.430     0.200
     0.467    15.129     0.200
     0.657    22.031     0.200
     0.657    21.430     0.200
     0.740    24.629     0.200
     1.075    35.328     0.200
     1.314    41.129     0.200
     0.153     5.680     0.200
     0.586    19.680     0.200
     0.644    21.578     0.200
     0.644    21.777     0.200
     0.973    30.480     0.200
     0.973    30.180     0.200
     1.096    36.578     0.200
     1.400    44.277     0.200
     0.176     7.109     0.200
     0.889    28.812     0.200
     1.097    35.109     0.200
     1.108    37.516     0.200
     1.392    44.414     0.200
     1.491    47.414     0.200
     0.294    10.172     0.200
     0.468    14.773     0.200
     0.652    22.070     0.200
     0.652    21.477     0.200
     0.652    22.172     0.200
     0.740    25.477     0.200
     0.863    27.375     0.200
     1.072    34.977     0.200
     1.211    38.172     0.200
     1.278    40.375     0.200
     1.316    41.273     0.200
     0.320    11.604     0.200
     0.466    15.104     0.200
     1.172    36.403     0.200
     1.172    36.703     0.200
     1.257    39.703     0.200
     1.257    39.804     0.200
     0.161     6.484     0.200
     0.636    21.781     0.200
     0.636    21.586     0.200
     0.586    19.680     0.200
     0.978    30.883     0.200
     0.978    30.984     0.200
     1.093    35.883     0.200
     1.394    44.180     0.200
     1.394    44.984     0.200
     0.157     6.125     0.200
     0.575    19.320     0.200
     0.645    21.820     0.200
     0.645    21.625     0.200
     0.981    30.727     0.200
     1.086    36.320     0.200
     1.392    44.820     0.200
     1.501    47.922     0.200
     2.763    81.422     0.200
     3.054    91.727     0.200
     0.168     5.781     0.200
     0.631    21.281     0.200
     0.631    21.078     0.200
     0.986    30.781     0.200
     0.986    30.883     0.200
     1.087    35.883     0.200
     1.387    44.383     0.200
     1.509    47.477     0.200
     2.566    75.883     0.200
     0.164     6.164     0.200
     0.577    19.469     0.200
     0.637    21.469     0.200
     0.637    21.367     0.200
     0.985    30.867     0.200
     0.985    31.164     0.200
     1.085    35.969     0.200
     1.504    47.867     0.200
     2.572    76.469     0.200
     0.148     5.219     0.200
     0.588    19.719     0.200
     0.648    22.020     0.200
     1.100    36.422     0.200
     1.186    38.219     0.200
     1.405    45.121     0.200
     2.776    82.320     0.200
     0.143     5.282     0.200
     0.593    19.982     0.200
     0.652    22.082     0.200
     0.962    29.982     0.200
     1.106    35.682     0.200
     1.191    37.782     0.200
     1.411    44.782     0.200
     1.518    48.582     0.200
     3.958   119.382     0.200
     0.164     5.269     0.200
     0.573    19.269     0.200
     0.638    21.369     0.200
     0.638    21.269     0.200
     1.081    35.769     0.200
     1.170    37.769     0.200
     1.385    44.669     0.200
     1.500    47.869     0.200
     0.155     5.219     0.200
     0.578    19.422     0.200
     0.645    21.621     0.200
     0.645    21.422     0.200
     1.394    44.121     0.200
     1.394    45.320     0.200
     1.504    48.020     0.200
     5.305   157.922     0.200
     0.170     5.094     0.200
     0.564    18.492     0.200
     0.637    21.094     0.200
     1.377    44.691     0.200
     1.491    48.094     0.200
     0.163     5.912     0.200
     0.637    21.312     0.200
     0.984    30.514     0.200
     1.389    44.014     0.200
     0.152     5.195     0.200
     0.613    20.195     0.200
     0.637    20.793     0.200
     0.955    29.996     0.200
     1.120    37.496     0.200
     1.417    45.195     0.200
     0.156     5.684     0.200
     0.595    19.484     0.200
     0.638    21.284     0.200
     0.969    30.284     0.200
     1.103    35.784     0.200
     1.404    44.584     0.200
     1.522    47.884     0.200
     2.555    75.384     0.200
     6.874   196.984     0.200
     0.241     8.234     0.200
     0.241     8.828     0.200
     0.630    22.328     0.200
     0.124     7.625     0.200
     0.801    25.223     0.200
     0.801    25.426     0.200
     0.909    29.426     0.200
     0.909    29.324     0.200
     1.740    54.523     0.200
     1.972    61.723     0.200
     0.167     5.203     0.200
     0.167     6.000     0.200
     0.633    20.801     0.200
     0.633    21.102     0.200
     0.986    31.000     0.200
     1.086    35.602     0.200
     1.387    44.602     0.200
     1.507    47.602     0.200
     0.334    11.394     0.200
     0.482    16.294     0.200
     0.982    30.594     0.200
     1.208    40.194     0.200
     2.369    71.294     0.200
     2.790    83.994     0.200
     0.344    12.117     0.200
     0.858    27.016     0.200
     0.827    27.117     0.200
     0.827    26.914     0.200
     1.340    41.914     0.200
     1.356    42.316     0.200
     2.734    81.215     0.200
     0.332    11.469     0.200
     0.641    20.669     0.200
     0.978    30.969     0.200
     1.388    44.269     0.200
     1.427    44.669     0.200
     1.452    45.869     0.200
     0.151     5.055     0.200
     0.646    21.355     0.200
     0.646    21.457     0.200
     0.971    30.656     0.200
     1.402    44.156     0.200
     1.402    44.355     0.200
     1.513    47.855     0.200
     0.150     5.391     0.200
     0.650    21.391     0.200
     0.974    30.391     0.200
     1.092    36.086     0.200
     1.399    43.688     0.200
     1.399    45.289     0.200
     0.157     6.889     0.200
     0.645    21.787     0.200
     0.982    30.488     0.200
     0.308    11.424     0.200
     0.609    20.123     0.200
     0.835    26.324     0.200
     1.337    43.123     0.200
     1.884    56.223     0.200
     1.997    61.424     0.200
     1.997    61.723     0.200
     0.164     5.586     0.200
     0.634    21.086     0.200
     0.634    21.281     0.200
     0.982    30.383     0.200
     0.982    30.883     0.200
     1.090    35.984     0.200
     1.391    44.680     0.200
     1.510    47.984     0.200
     0.163     5.977     0.200
     0.637    21.273     0.200
     0.984    30.672     0.200
     0.984    31.477     0.200
     1.086    35.375     0.200
     1.389    44.875     0.200
     2.571    76.875     0.200
     0.137     7.043     0.200
     0.782    26.742     0.200
     1.313    41.441     0.200
     1.402    43.242     0.200
     2.313    69.242     0.200
     2.313    67.242     0.200
     0.168     5.922     0.200
     0.633    21.320     0.200
     0.633    21.023     0.200
     0.988    30.922     0.200
     1.084    36.125     0.200
     1.385    44.023     0.200
     1.505    47.820     0.200
     3.052    91.922     0.200
     5.294   157.625     0.200
     0.166     5.461     0.200
     0.631    21.359     0.200
     0.983    30.758     0.200
     0.983    31.059     0.200
     1.090    35.859     0.200
     1.390    45.059     0.200
     3.936   118.758     0.200
     0.200     7.074     0.200
     0.586    19.672     0.200
     0.586    19.773     0.200
     0.966    29.973     0.200
     1.133    37.375     0.200
     1.410    45.074     0.200
     2.497    73.875     0.200
     0.187     6.773     0.200
     0.600    19.977     0.200
     0.950    29.273     0.200
     1.146    37.172     0.200
     1.426    44.875     0.200
     1.977    62.273     0.200
     0.211     6.838     0.200
     0.576    19.638     0.200
     0.576    18.738     0.200
     1.127    37.138     0.200
     1.401    44.338     0.200
     2.992    90.138     0.200
     0.191     7.317     0.200
     0.595    20.017     0.200
     0.595    20.117     0.200
     0.965    30.217     0.200
     1.129    37.117     0.200
     2.201    67.817     0.200
     2.201    68.417     0.200
     0.199     7.289     0.200
     0.588    19.789     0.200
     0.588    19.891     0.200
     0.960    29.691     0.200
     0.960    30.191     0.200
     1.974    62.992     0.200
     0.195     7.121     0.200
     0.591    19.721     0.200
     0.591    19.921     0.200
     0.964    30.221     0.200
     1.133    36.721     0.200
     1.411    44.721     0.200
     2.500    74.821     0.200
     0.193     6.879     0.200
     0.594    19.578     0.200
     0.960    29.779     0.200
     1.136    36.479     0.200
     1.415    44.979     0.200
     2.498    75.078     0.200
     5.301   157.180     0.200
     0.146     6.055     0.200
     0.651    21.555     0.200
     0.968    30.152     0.200
     0.968    30.355     0.200
     0.968    31.555     0.200
     1.099    34.754     0.200
     1.405    44.453     0.200
     1.912    60.652     0.200
     0.277     9.383     0.200
     0.532    17.982     0.200
     0.532    17.783     0.200
     1.026    34.283     0.200
     1.078    33.283     0.200
     1.078    33.182     0.200
     1.298    41.283     0.200
     1.298    41.182     0.200
     0.632    21.430     0.200
     0.632    21.531     0.200
     0.972    30.727     0.200
     0.972    30.531     0.200
     1.103    36.625     0.200
     1.401    44.531     0.200
     1.401    44.328     0.200
     1.524    48.531     0.200
     2.552    75.531     0.200
     0.627    21.008     0.200
     0.627    21.305     0.200
     0.979    30.406     0.200
     0.979    30.508     0.200
     1.096    36.707     0.200
     1.394    44.008     0.200
     0.306    10.383     0.200
     0.502    17.383     0.200
     0.576    19.688     0.200
     1.018    34.281     0.200
     1.099    34.688     0.200
     0.276     9.344     0.200
     0.772    24.844     0.200
     0.834    26.641     0.200
     0.860    29.047     0.200
     0.892    29.242     0.200
     1.423    46.547     0.200
     1.588    49.445     0.200
     1.810    56.445     0.200
     0.176     6.180     0.200
     0.569    18.781     0.200
     0.629    21.082     0.200
     0.998    31.082     0.200
     0.998    30.980     0.200
     1.074    34.980     0.200
     1.375    44.082     0.200
     2.578    75.883     0.200
     2.578    76.082     0.200
     0.286    10.066     0.200
     0.515    17.467     0.200
     0.729    24.566     0.200
     0.973    30.066     0.200
     0.171     6.906     0.200
     0.597    19.809     0.200
     0.622    21.207     0.200
     0.979    30.906     0.200
     0.979    30.508     0.200
     1.098    35.906     0.200
     1.194    38.109     0.200
     1.921    61.008     0.200
     0.344    11.961     0.200
     0.576    18.961     0.200
     0.667    22.656     0.200
     0.958    31.156     0.200
     0.958    31.258     0.200
     1.212    38.961     0.200
     1.255    40.859     0.200
     6.859   195.555     0.200
     0.173     9.906     0.200
     0.699    23.305     0.200
     0.764    24.305     0.200
     0.960    31.207     0.200
     1.776    55.805     0.200
     1.898    59.805     0.200
     1.999    62.805     0.200
     2.122    61.508     0.200
     2.122    61.906     0.200
     0.321    10.791     0.200
     0.602    19.791     0.200
     0.620    20.691     0.200
     0.632    21.391     0.200
     0.933    30.791     0.200
     1.219    39.791     0.200
     2.701    80.391     0.200
     0.426    14.922     0.200
     0.435    14.523     0.200
     0.545    18.223     0.200
     0.918    31.023     0.200
     1.149    35.723     0.200
     1.149    36.824     0.200
     1.233    38.523     0.200
     0.144     6.311     0.200
     0.582    19.511     0.200
     0.656    22.011     0.200
     0.656    21.911     0.200
     0.969    30.811     0.200
     0.969    30.211     0.200
     1.180    37.911     0.200
     1.405    45.311     0.200
     2.776    82.311     0.200
     4.870   145.211     0.200
     6.673   195.511     0.200
     0.160     6.039     0.200
     0.572    19.242     0.200
     0.644    22.039     0.200
     0.644    21.938     0.200
     0.985    31.039     0.200
     1.170    38.141     0.200
     1.389    44.938     0.200
     1.658    51.539     0.200
     3.057    91.344     0.200
     5.300   154.844     0.200
     5.495   159.141     0.200
     0.156     6.199     0.200
     0.575    19.299     0.200
     0.646    22.400     0.200
     0.646    22.100     0.200
     0.980    31.100     0.200
     1.173    37.900     0.200
     1.393    45.199     0.200
     1.501    47.900     0.200
     5.522   159.799     0.200
     0.156     5.344     0.200
     0.567    18.945     0.200
     0.651    21.648     0.200
     0.651    21.547     0.200
     0.985    30.844     0.200
     0.985    30.742     0.200
     1.164    36.945     0.200
     1.389    43.242     0.200
     2.585    77.742     0.200
     0.289    11.547     0.200
     0.621    19.750     0.200
     0.621    19.250     0.200
     0.840    27.250     0.200
     0.840    27.547     0.200
     1.871    56.945     0.200
     1.871    57.250     0.200
     0.073     6.539     0.200
     0.671    21.838     0.200
     0.723    23.838     0.200
     0.857    27.238     0.200
     0.857    26.838     0.200
     1.999    62.838     0.200
     0.321    11.125     0.200
     0.430    13.430     0.200
     0.639    21.523     0.200
     0.780    26.023     0.200
     1.107    36.023     0.200
     1.277    39.727     0.200
     0.323    11.141     0.200
     0.431    13.641     0.200
     0.431    15.539     0.200
     0.637    21.840     0.200
     0.780    26.141     0.200
     0.900    28.941     0.200
     1.106    35.641     0.200
     1.278    40.141     0.200
     1.942    60.539     0.200
     7.316   208.441     0.200
     0.331    12.423     0.200
     0.501    16.723     0.200
     0.629    20.423     0.200
     0.955    31.622     0.200
     1.141    35.622     0.200
     1.169    37.322     0.200
     1.856    58.522     0.200
     2.574    74.122     0.200
     7.229   205.723     0.200
     0.174     8.312     0.200
     0.719    22.617     0.200
     0.813    26.812     0.200
     0.788    26.312     0.200
     0.788    26.414     0.200
     1.921    58.211     0.200
     1.921    59.312     0.200
     1.989    61.117     0.200
     1.967    61.211     0.200
     0.311    10.808     0.200
     0.642    21.308     0.200
     0.788    25.508     0.200
     0.903    29.508     0.200
     1.183    38.208     0.200
     4.582   132.808     0.200
     0.190     7.926     0.200
     0.585    19.324     0.200
     0.608    19.824     0.200
     0.608    20.723     0.200
     0.999    31.426     0.200
     1.181    37.625     0.200
     1.907    59.824     0.200
     0.194     7.395     0.200
     0.588    19.395     0.200
     0.602    20.297     0.200
     1.001    31.496     0.200
     1.184    37.594     0.200
     0.145     6.223     0.200
     0.628    20.523     0.200
     0.642    21.621     0.200
     0.940    29.023     0.200
     1.225    39.422     0.200
     1.953    61.621     0.200
     0.162     6.082     0.200
     0.573    19.082     0.200
     0.641    21.480     0.200
     0.986    30.980     0.200
     1.170    37.582     0.200
     1.387    44.383     0.200
     2.577    76.281     0.200
     3.056    90.684     0.200
     0.166     6.070     0.200
     0.570    18.770     0.200
     0.638    21.270     0.200
     0.990    30.871     0.200
     1.168    37.469     0.200
     1.383    44.070     0.200
     4.332   125.469     0.200
     4.848   144.070     0.200
     0.343    12.890     0.200
     0.620    20.390     0.200
     0.698    22.690     0.200
     0.922    29.490     0.200
     0.922    30.590     0.200
     1.827    56.990     0.200
     2.729    79.791     0.200
     3.338    97.190     0.200
     7.111   204.891     0.200
     0.159     5.992     0.200
     0.571    19.289     0.200
     0.645    21.688     0.200
     0.985    31.188     0.200
     1.082    35.391     0.200
     1.388    43.086     0.200
     2.580    76.289     0.200
     3.935   118.188     0.200
     0.167     6.172     0.200
     0.575    19.570     0.200
     0.635    21.570     0.200
     0.988    31.273     0.200
     0.988    31.172     0.200
     1.082    35.875     0.200
     1.385    44.172     0.200
     1.385    43.477     0.200
     1.502    47.070     0.200
     0.273    10.262     0.200
     0.538    18.859     0.200
     0.746    24.762     0.200
     0.943    29.262     0.200
     0.181     6.367     0.200
     0.470    16.367     0.200
     0.817    27.168     0.200
     1.001    31.070     0.200
     1.365    43.770     0.200
     1.413    44.867     0.200
     0.114     6.398     0.200
     0.588    20.297     0.200
     0.684    23.102     0.200
     0.946    29.500     0.200
     2.573    75.898     0.200
     0.069     6.723     0.200
     0.685    22.324     0.200
     0.736    23.922     0.200
     0.838    26.723     0.200
     1.221    38.422     0.200
     1.746    53.824     0.200
     0.448    15.117     0.200
     0.662    22.117     0.200
     1.094    35.718     0.200
     1.094    34.917     0.200
     1.216    39.917     0.200
     1.292    42.518     0.200
     1.296    41.417     0.200
     1.296    41.018     0.200
     1.333    44.518     0.200
     0.306    10.168     0.200
     0.415    13.568     0.200
     1.152    36.568     0.200
     1.152    36.168     0.200
     1.227    39.869     0.200
     1.345    42.869     0.200
     1.442    46.770     0.200
     2.070    65.668     0.200
     0.309     9.775     0.200
     0.391    13.375     0.200
     0.657    21.875     0.200
     0.896    28.775     0.200
     1.227    39.975     0.200
     1.321    42.074     0.200
     1.427    45.875     0.200
     1.513    47.975     0.200
     0.303     9.805     0.200
     0.397    13.406     0.200
     0.656    22.105     0.200
     0.903    29.707     0.200
     1.150    36.105     0.200
     1.233    39.504     0.200
     1.328    42.305     0.200
     2.069    61.305     0.200
     0.176     6.078     0.200
     0.586    19.477     0.200
     0.989    31.273     0.200
     0.989    31.078     0.200
     1.087    35.375     0.200
     1.384    44.172     0.200
     1.384    43.578     0.200
     1.514    48.078     0.200
     1.624    52.273     0.200
     0.164     6.119     0.200
     0.571    19.020     0.200
     0.640    21.520     0.200
     0.988    31.221     0.200
     1.385    44.221     0.200
     1.498    47.320     0.200
     0.588    19.262     0.200
     0.880    28.762     0.200
     0.943    29.762     0.200
     0.295    11.559     0.200
     0.586    19.059     0.200
     0.586    17.559     0.200
     0.886    28.758     0.200
     0.886    28.859     0.200
     0.939    30.258     0.200
     1.859    56.656     0.200
     1.859    55.457     0.200
     1.789    53.656     0.200
     0.431    14.935     0.200
     0.489    16.435     0.200
     0.512    16.835     0.200
     1.081    32.835     0.200
     1.081    34.135     0.200
     1.299    40.234     0.200
     1.962    61.335     0.200
     2.687    80.734     0.200
     4.080   121.835     0.200
     0.270    10.043     0.200
     0.766    24.145     0.200
     1.055    34.543     0.200
     1.708    51.543     0.200
     1.919    60.645     0.200
     1.986    62.445     0.200
     0.145     5.695     0.200
     0.573    19.094     0.200
     0.659    22.695     0.200
     0.974    30.391     0.200
     0.974    30.594     0.200
     1.089    35.492     0.200
     1.400    44.195     0.200
     1.497    47.297     0.200
     0.282    11.117     0.200
     0.597    19.020     0.200
     0.927    29.918     0.200
     1.778    52.816     0.200
     1.872    57.617     0.200
     1.995    62.617     0.200
     4.317   129.020     0.200
     4.319   128.020     0.200
     0.158     6.008     0.200
     0.570    19.008     0.200
     0.647    22.508     0.200
     0.984    30.508     0.200
     1.082    35.105     0.200
     1.389    44.207     0.200
     1.496    47.207     0.200
     2.580    76.008     0.200
     0.151     5.203     0.200
     0.571    19.102     0.200
     0.654    22.301     0.200
     0.979    30.801     0.200
     1.086    36.102     0.200
     1.394    44.703     0.200
     2.581    75.703     0.200
     0.276     9.344     0.200
     0.411    13.244     0.200
     0.705    22.244     0.200
     0.729    25.344     0.200
     0.768    25.443     0.200
     0.875    28.344     0.200
     1.288    42.145     0.200
     1.431    45.145     0.200
     1.665    52.043     0.200
     2.105    66.344     0.200
     2.295    71.645     0.200
     0.310    10.297     0.200
     0.409    15.197     0.200
     0.493    16.498     0.200
     0.740    24.498     0.200
     0.986    30.498     0.200
     1.184    38.396     0.200
     1.417    44.697     0.200
     0.361    13.844     0.200
     0.719    22.742     0.200
     0.964    31.445     0.200
     1.874    57.945     0.200
     2.069    60.641     0.200
     0.343    11.195     0.200
     0.503    17.098     0.200
     0.939    31.797     0.200
     1.162    36.598     0.200
     1.211    38.898     0.200
     0.219     7.795     0.200
     0.342    11.395     0.200
     0.495    16.193     0.200
     0.594    19.895     0.200
     0.736    24.994     0.200
     1.038    34.494     0.200
     1.283    41.094     0.200
     1.339    42.494     0.200
     1.320    42.295     0.200
     0.212     8.086     0.200
     0.534    18.184     0.200
     1.041    32.785     0.200
     1.031    34.484     0.200
     1.333    42.484     0.200
     1.333    43.586     0.200
     0.120     7.320     0.200
     0.675    22.119     0.200
     0.884    27.520     0.200
     0.299    10.325     0.200
     0.448    14.325     0.200
     0.758    25.825     0.200
     1.093    35.525     0.200
     1.296    40.325     0.200
     1.296    40.426     0.200
     1.924    60.426     0.200
     3.367   100.825     0.200
     0.309    10.430     0.200
     0.442    14.430     0.200
     0.766    25.430     0.200
     1.097    35.730     0.200
     1.289    40.430     0.200
     1.930    60.129     0.200
     0.297    11.523     0.200
     0.637    19.719     0.200
     0.679    22.422     0.200
     0.816    26.523     0.200
     0.936    30.922     0.200
     0.124     7.025     0.200
     0.452    15.826     0.200
     0.555    19.725     0.200
     0.691    23.225     0.200
     0.711    23.625     0.200
     0.847    26.725     0.200
     1.763    55.625     0.200
     0.168     5.891     0.200
     0.331    11.594     0.200
     0.439    15.891     0.200
     0.587    19.289     0.200
     0.628    20.789     0.200
     0.982    31.094     0.200
     1.092    35.391     0.200
     1.390    44.391     0.200
     1.515    47.789     0.200
     2.122    67.992     0.200
     0.201     8.312     0.200
     0.320    10.812     0.200
     0.408    13.016     0.200
     0.463    15.516     0.200
     0.518    17.117     0.200
     1.160    37.617     0.200
     1.217    38.516     0.200
     1.500    48.516     0.200
     1.517    47.617     0.200
     2.036    63.914     0.200
     2.644    78.719     0.200
     4.149   121.914     0.200
     5.459   157.312     0.200
     0.158     7.902     0.200
     0.736    24.305     0.200
     0.807    26.102     0.200
     0.994    31.703     0.200
     1.306    40.805     0.200
     1.315    41.305     0.200
     0.316    12.074     0.200
     0.624    21.172     0.200
     0.815    25.375     0.200
     0.626    21.473     0.200
     0.880    28.875     0.200
     1.905    60.074     0.200
     5.034   147.973     0.200
     0.325    12.156     0.200
     0.636    21.250     0.200
     0.639    21.250     0.200
     0.802    24.953     0.200
     0.895    29.156     0.200
     1.921    60.750     0.200
     1.959    60.750     0.200
     1.984    60.250     0.200
     1.984    62.250     0.200
     0.321    12.172     0.200
     0.616    20.375     0.200
     0.624    20.875     0.200
     0.825    25.273     0.200
     0.879    28.773     0.200
     1.981    60.977     0.200
     1.963    61.977     0.200
     5.415   157.773     0.200
     0.184     6.191     0.200
     0.325    11.191     0.200
     0.580    18.891     0.200
     1.375    43.391     0.200
     0.202     7.894     0.200
     0.401    13.894     0.200
     0.585    19.894     0.200
     0.655    21.594     0.200
     0.961    30.394     0.200
     0.961    29.994     0.200
     1.140    36.394     0.200
     1.415    44.694     0.200
     1.975    61.694     0.200
     0.194     8.287     0.200
     0.734    24.787     0.200
     0.066     6.289     0.200
     0.788    26.590     0.200
     0.329    11.945     0.200
     0.346    11.844     0.200
     0.346    12.047     0.200
     0.453    15.242     0.200
     0.563    19.344     0.200
     0.785    25.547     0.200
     1.108    34.742     0.200
     1.108    36.844     0.200
     1.159    37.742     0.200
     1.339    42.242     0.200
     2.052    65.148     0.200
     0.255     8.712     0.200
     0.302    11.712     0.200
     0.300    10.212     0.200
     0.635    21.012     0.200
     0.647    22.512     0.200
     0.961    31.712     0.200
     1.173    37.212     0.200
     1.195    38.112     0.200
     1.232    40.012     0.200
     1.260    40.812     0.200
     1.423    43.812     0.200
     0.128     7.078     0.200
     0.307    11.375     0.200
     0.733    24.375     0.200
     0.820    27.477     0.200
     0.920    29.578     0.200
     0.920    30.078     0.200
     1.376    42.977     0.200
     1.370    43.578     0.200
     1.398    44.680     0.200
     1.477    45.875     0.200
     1.509    45.977     0.200
     1.509    46.180     0.200
     3.421   102.875     0.200
     3.896   116.578     0.200
     0.279     9.883     0.200
     0.456    15.383     0.200
     0.331    11.285     0.200
     1.145    35.984     0.200
     1.145    36.586     0.200
     1.290    41.285     0.200
     1.659    52.984     0.200
     2.127    65.684     0.200
     2.191    68.883     0.200
     2.267    69.984     0.200
     2.424    73.285     0.200
     0.301    10.875     0.200
     0.488    15.281     0.200
     0.627    20.977     0.200
     1.049    34.477     0.200
     1.220    38.781     0.200
     1.220    40.477     0.200
     1.272    40.578     0.200
     1.272    41.977     0.200
     1.334    41.477     0.200
     1.310    41.680     0.200
     0.280     9.820     0.200
     0.328    11.422     0.200
     0.328    10.820     0.200
     0.459    15.820     0.200
     1.110    37.117     0.200
     1.146    36.422     0.200
     1.291    41.719     0.200
     1.670    53.422     0.200
     2.129    66.117     0.200
     2.192    68.320     0.200
     2.192    68.516     0.200
     2.266    70.219     0.200
     2.266    70.016     0.200
     0.320    11.297     0.200
     0.287    10.598     0.200
     0.470    14.996     0.200
     0.548    18.098     0.200
     0.762    24.797     0.200
     1.147    35.797     0.200
     1.296    40.699     0.200
     1.296    42.297     0.200
     1.681    52.297     0.200
     1.676    51.598     0.200
     0.131     6.637     0.200
     0.434    15.234     0.200
     0.528    18.934     0.200
     0.692    22.637     0.200
     0.670    22.434     0.200
     0.670    22.535     0.200
     0.873    27.535     0.200
     0.873    27.637     0.200
     1.206    39.934     0.200
     1.500    47.137     0.200
     2.125    63.637     0.200
     0.336    12.008     0.200
     0.459    15.309     0.200
     0.557    18.508     0.200
     0.776    25.211     0.200
     1.122    35.309     0.200
     1.145    36.609     0.200
     1.145    38.508     0.200
     1.323    41.910     0.200
     0.253    10.398     0.200
     0.383    13.102     0.200
     0.448    14.500     0.200
     0.537    18.203     0.200
     0.876    29.297     0.200
     1.158    37.398     0.200
     1.370    43.000     0.200
     0.261    10.070     0.200
     0.443    14.875     0.200
     0.448    14.773     0.200
     0.561    18.570     0.200
     0.588    21.172     0.200
     0.730    23.969     0.200
     1.149    36.672     0.200
     1.174    38.172     0.200
     1.220    38.469     0.200
     1.565    49.070     0.200
     0.186     7.578     0.200
     0.337    11.477     0.200
     0.419    13.977     0.200
     0.518    16.977     0.200
     0.589    18.773     0.200
     0.702    23.977     0.200
     0.951    30.680     0.200
     1.260    40.273     0.200
     1.277    40.375     0.200
     1.302    41.578     0.200
     1.422    44.180     0.200
     0.298    11.062     0.200
     0.496    17.461     0.200
     0.553    18.961     0.200
     0.552    18.562     0.200
     0.904    27.762     0.200
     1.266    40.363     0.200
     0.135     6.586     0.200
     0.491    17.781     0.200
     0.530    17.883     0.200
     0.711    23.484     0.200
     0.982    30.680     0.200
     1.067    34.680     0.200
     1.399    44.586     0.200
     2.631    77.086     0.200
     0.242     9.887     0.200
     0.622    19.588     0.200
     0.634    21.188     0.200
     0.778    26.488     0.200
     0.879    28.988     0.200
     0.886    28.688     0.200
     1.956    61.988     0.200
     0.088     6.566     0.200
     0.829    27.367     0.200
     1.372    42.465     0.200
     0.180     6.545     0.200
     0.270     9.545     0.200
     0.512    16.145     0.200
     0.664    21.744     0.200
     0.696    23.045     0.200
     1.032    34.344     0.200
     1.177    37.744     0.200
     1.274    41.344     0.200
     1.312    42.145     0.200
     1.359    42.244     0.200
     0.183     7.660     0.200
     0.333    11.562     0.200
     0.420    13.863     0.200
     0.515    17.062     0.200
     0.581    18.461     0.200
     0.709    24.262     0.200
     0.958    30.961     0.200
     1.267    40.461     0.200
     1.282    40.461     0.200
     1.299    41.863     0.200
     1.414    44.262     0.200
     0.121     6.859     0.200
     0.327    12.561     0.200
     0.678    23.160     0.200
     0.678    22.260     0.200
     0.678    23.459     0.200
     0.952    30.061     0.200
     0.952    29.561     0.200
     1.108    36.260     0.200
     1.913    60.660     0.200
     0.329    11.539     0.200
     0.329    12.336     0.200
     0.718    23.336     0.200
     0.825    27.742     0.200
     0.885    28.539     0.200
     0.834    27.336     0.200
     0.834    27.539     0.200
     1.329    42.742     0.200
     1.380    43.742     0.200
     0.115     6.703     0.200
     0.497    18.000     0.200
     0.624    20.602     0.200
     0.672    22.602     0.200
     0.924    29.000     0.200
     1.951    61.203     0.200
     0.284    10.219     0.200
     0.329    12.719     0.200
     0.487    15.922     0.200
     0.655    21.719     0.200
     0.721    24.520     0.200
     1.054    34.621     0.200
     1.299    42.121     0.200
     1.337    43.621     0.200
     0.251     9.000     0.200
     0.355    13.699     0.200
     0.548    18.602     0.200
     0.567    19.398     0.200
     1.065    33.199     0.200
     1.023    33.500     0.200
     1.308    41.000     0.200
     1.861    58.602     0.200
     0.733    24.283     0.200
     1.373    42.885     0.200
     0.290    10.000     0.200
     0.312    12.000     0.200
     0.573    19.000     0.200
     0.646    21.902     0.200
     0.645    21.199     0.200
     0.965    31.500     0.200
     1.166    36.801     0.200
     1.230    38.902     0.200
     0.088     7.508     0.200
     0.793    26.812     0.200
     2.608    75.609     0.200
     0.257     8.971     0.200
     0.403    14.770     0.200
     0.532    17.869     0.200
     0.681    22.270     0.200
     0.681    23.170     0.200
     0.987    30.570     0.200
     1.143    36.869     0.200
     1.993    62.570     0.200
     2.456    72.170     0.200
     5.263   154.670     0.200
     0.088     5.844     0.200
     0.420    14.344     0.200
     0.512    16.746     0.200
     0.575    17.746     0.200
     0.789    26.547     0.200
     0.995    31.645     0.200
     1.349    43.145     0.200
     1.386    43.246     0.200
     1.379    44.445     0.200
     0.172     8.094     0.200
     0.500    16.594     0.200
     0.615    19.695     0.200
     0.929    30.195     0.200
     0.929    30.395     0.200
     1.288    40.793     0.200
     1.445    44.996     0.200
     4.007   118.094     0.200
     0.219     8.354     0.200
     0.409    14.053     0.200
     0.657    21.854     0.200
     0.756    24.652     0.200
     1.223    38.453     0.200
     1.353    42.453     0.200
     2.643    78.553     0.200
     3.315    98.320     0.200
     0.151     7.253     0.200
     0.401    13.753     0.200
     0.474    15.953     0.200
     0.635    20.953     0.200
     0.704    24.053     0.200
     0.916    29.053     0.200
     1.265    40.353     0.200
     1.294    41.953     0.200
     1.460    45.653     0.200
     0.284    10.281     0.200
     0.492    17.281     0.200
     0.538    18.082     0.200
     0.558    18.281     0.200
     0.790    25.682     0.200
     0.905    28.281     0.200
     1.256    40.682     0.200
     1.498    46.682     0.200
     0.290    10.891     0.200
     0.551    18.789     0.200
     0.504    18.195     0.200
     0.564    19.094     0.200
     0.564    19.195     0.200
     0.894    27.891     0.200
     0.804    26.891     0.200
     2.335    68.492     0.200
     0.210     8.164     0.200
     0.337    11.461     0.200
     0.396    13.062     0.200
     0.452    15.062     0.200
     0.939    31.363     0.200
     1.196    37.961     0.200
     1.183    38.262     0.200
     1.460    46.262     0.200
     1.493    47.363     0.200
     2.061    65.062     0.200
     0.330    11.203     0.200
     0.314    11.102     0.200
     0.275    10.602     0.200
     0.502    16.805     0.200
     0.976    31.906     0.200
     1.136    35.703     0.200
     1.239    39.703     0.200
     2.602    76.602     0.200
     0.127     6.889     0.200
     0.345    12.488     0.200
     0.351    13.389     0.200
     0.374    13.090     0.200
     0.652    21.789     0.200
     0.832    27.789     0.200
     1.164    37.389     0.200
     1.998    62.590     0.200
     0.194     8.594     0.200
     0.194     8.793     0.200
     0.329    11.594     0.200
     0.329    11.895     0.200
     0.410    14.094     0.200
     0.526    17.793     0.200
     0.585    19.492     0.200
     0.699    23.695     0.200
     0.953    29.793     0.200
     0.953    30.492     0.200
     1.256    39.992     0.200
     1.820    57.293     0.200
     0.277    10.691     0.200
     0.277    10.492     0.200
     0.689    23.590     0.200
     0.689    23.391     0.200
     1.279    40.090     0.200
     1.383    42.492     0.200
     0.270    11.111     0.200
     0.295    11.611     0.200
     0.524    17.011     0.200
     0.598    19.911     0.200
     0.805    25.911     0.200
     1.179    36.111     0.200
     1.140    36.511     0.200
     1.292    40.811     0.200
     2.580    75.111     0.200
     0.216     8.555     0.200
     0.314    10.555     0.200
     0.389    12.750     0.200
     0.584    19.148     0.200
     0.548    17.953     0.200
     0.686    22.953     0.200
     0.951    30.852     0.200
     1.250    39.352     0.200
     1.290    42.250     0.200
     1.422    44.953     0.200
     0.226     8.008     0.200
     0.226     8.812     0.200
     0.355    12.906     0.200
     0.566    19.812     0.200
     0.605    19.711     0.200
     1.015    31.609     0.200
     1.082    35.812     0.200
     1.921    60.609     0.200
     0.308    10.176     0.200
     0.376    12.277     0.200
     0.561    18.277     0.200
     0.586    18.875     0.200
     0.676    21.676     0.200
     0.948    31.477     0.200
     1.237    39.176     0.200
     1.232    38.977     0.200
     1.426    44.676     0.200
     0.267     9.484     0.200
     0.372    13.086     0.200
     0.524    17.684     0.200
     0.617    20.383     0.200
     1.042    32.484     0.200
     1.337    42.285     0.200
     1.925    60.586     0.200
     0.159     5.758     0.200
     0.285     9.859     0.200
     0.333    12.258     0.200
     0.478    15.160     0.200
     0.658    21.859     0.200
     0.729    24.359     0.200
     1.064    35.059     0.200
     1.201    38.258     0.200
     1.266    40.258     0.200
     1.326    41.359     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.144    67.625     0.200
     2.552    77.924     0.200
     3.014    94.125     0.200
     3.011    91.825     0.200
     3.621   110.625     0.200
     3.661   113.125     0.200
     4.742   146.625     0.200
     4.862   150.024     0.200
     5.041   155.524     0.200
     3.245    99.721     0.200
     3.350   103.721     0.200
     3.520   109.721     0.200
    14.673   461.721     0.200
     2.095    65.062     0.200
     2.728    85.664     0.200
     2.752    84.164     0.200
     3.227   100.664     0.200
     3.876   120.363     0.200
     2.391    72.684     0.200
     2.507    76.684     0.200
     2.504    77.285     0.200
     3.097    96.086     0.200
     3.142    95.086     0.200
     3.662   111.086     0.200
     3.744   113.184     0.200
     3.918   121.684     0.200
     4.201   129.984     0.200
     4.570   139.984     0.200
     2.207    68.672     0.200
     2.368    73.273     0.200
     2.597    78.672     0.200
     2.657    80.469     0.200
     3.031    93.070     0.200
     4.044   123.672     0.200
     4.163   128.570     0.200
     5.073   158.070     0.200
     2.341    71.820     0.200
     2.557    77.723     0.200
     2.642    81.121     0.200
     2.976    92.723     0.200
     3.254    99.520     0.200
     3.846   117.723     0.200
     4.084   127.820     0.200
     4.723   144.820     0.200
     2.261    69.348     0.200
     2.723    83.348     0.200
     2.894    88.250     0.200
     3.338   101.848     0.200
     3.421   104.148     0.200
     3.881   118.949     0.200
     3.954   123.449     0.200
     4.166   128.047     0.200
     4.332   133.250     0.200
     4.713   144.348     0.200
     2.299    70.258     0.200
     2.599    79.758     0.200
     2.675    82.059     0.200
     2.934    89.961     0.200
     3.292   100.359     0.200
     3.456   107.461     0.200
     3.876   119.359     0.200
     3.999   124.961     0.200
     4.126   127.059     0.200
     4.365   136.059     0.200
     4.733   144.059     0.200
     4.769   146.961     0.200
     5.763   178.660     0.200
     7.393   227.961     0.200
     2.260    70.789     0.200
     2.639    81.590     0.200
     2.713    83.391     0.200
     2.895    89.988     0.200
     3.333   102.590     0.200
     3.419   106.090     0.200
     3.893   118.590     0.200
     3.959   123.590     0.200
     4.166   129.090     0.200
     4.729   146.090     0.200
     4.738   147.590     0.200
     2.266    70.977     0.200
     2.299    73.078     0.200
     2.476    77.375     0.200
     2.487    78.375     0.200
     2.658    81.977     0.200
     2.658    82.078     0.200
     2.808    88.977     0.200
     3.670   112.977     0.200
     3.670   113.375     0.200
     4.117   127.277     0.200
     4.264   131.176     0.200
     4.450   137.977     0.200
     4.848   146.176     0.200
     6.309   196.977     0.200
     7.463   232.875     0.200
    14.160   446.578     0.200
     2.354    73.964     0.200
     2.696    82.964     0.200
     2.979    91.564     0.200
     3.286   102.064     0.200
     3.519   107.464     0.200
     3.767   118.564     0.200
     4.019   127.064     0.200
     4.084   126.665     0.200
     4.624   141.964     0.200
     4.855   148.464     0.200
     5.759   175.764     0.200
     6.172   190.665     0.200
     7.039   218.264     0.200
     2.282    70.513     0.200
     2.570    81.518     0.200
     2.570    79.812     0.200
     2.701    82.516     0.200
     2.701    82.812     0.200
     3.071    94.516     0.200
     3.071    94.812     0.200
     3.309   103.518     0.200
     3.309   100.612     0.200
     3.309   104.013     0.200
     3.413   103.413     0.200
     3.874   120.513     0.200
     3.874   121.013     0.200
     4.298   133.413     0.200
     4.393   136.112     0.200
     4.393   135.612     0.200
     4.791   146.713     0.200
     5.229   163.516     0.200
     5.229   163.812     0.200
     2.230    69.006     0.200
     2.562    78.705     0.200
     2.778    85.705     0.200
     3.038    93.807     0.200
     3.326   101.705     0.200
     3.381   104.506     0.200
     3.717   115.307     0.200
     3.953   122.506     0.200
     4.330   134.006     0.200
     2.304    72.320     0.200
     2.377    72.523     0.200
     2.377    73.023     0.200
     2.665    81.523     0.200
     2.665    82.727     0.200
     3.004    92.922     0.200
     3.004    94.320     0.200
     3.540   108.625     0.200
     4.047   125.523     0.200
     4.637   141.625     0.200
     4.870   152.227     0.200
     5.575   174.023     0.200
     5.729   177.023     0.200
     2.345    72.773     0.200
     2.637    81.273     0.200
     2.637    81.473     0.200
     2.532    78.973     0.200
     2.653    82.273     0.200
     2.653    83.273     0.200
     3.138    97.973     0.200
     3.257   100.875     0.200
     3.257   101.273     0.200
     3.418   105.875     0.200
     3.418   106.676     0.200
     3.508   111.273     0.200
     3.508   110.973     0.200
     3.837   119.074     0.200
     3.829   116.973     0.200
     3.829   119.273     0.200
     4.191   131.176     0.200
     4.219   131.574     0.200
     4.237   133.473     0.200
     4.360   135.074     0.200
     4.747   146.176     0.200
     5.197   160.574     0.200
     5.197   161.574     0.200
     5.367   168.773     0.200
     5.610   172.973     0.200
     5.610   172.773     0.200
     6.789   211.574     0.200
     6.992   215.273     0.200
     8.198   254.289     0.200
     2.296    71.580     0.200
     2.713    83.480     0.200
     2.768    85.280     0.200
     3.063    95.180     0.200
     3.168    98.380     0.200
     3.458   106.480     0.200
     3.731   115.480     0.200
     4.018   123.680     0.200
     4.073   125.380     0.200
     4.995   154.780     0.200
     5.270   161.380     0.200
     2.573    80.211     0.200
     2.737    85.211     0.200
     2.737    85.109     0.200
     2.726    85.305     0.200
     2.726    86.305     0.200
     3.193    97.406     0.200
     3.193    99.406     0.200
     3.262   102.305     0.200
     3.262   101.211     0.200
     3.310   103.711     0.200
     3.557   111.406     0.200
     3.827   118.406     0.200
     3.908   123.008     0.200
     3.908   122.109     0.200
     4.181   130.508     0.200
     4.181   129.109     0.200
     4.248   133.711     0.200
     5.310   164.609     0.200
     5.362   166.805     0.200
     6.773   210.305     0.200
     6.909   212.906     0.200
     2.089    66.617     0.200
     2.127    66.217     0.200
     2.353    73.018     0.200
     2.717    84.817     0.200
     2.793    85.617     0.200
     2.880    90.018     0.200
     3.421   104.417     0.200
     3.495   109.018     0.200
     3.495   109.317     0.200
     3.643   112.617     0.200
     3.954   120.917     0.200
     3.954   120.617     0.200
     4.451   139.917     0.200
     4.576   140.117     0.200
     4.864   149.317     0.200
     4.864   148.817     0.200
     5.162   160.617     0.200
     5.256   162.617     0.200
     5.354   165.417     0.200
     6.598   203.417     0.200
     2.142    67.660     0.200
     2.368    73.762     0.200
     2.368    74.062     0.200
     2.503    77.262     0.200
     2.503    78.062     0.200
     2.620    80.961     0.200
     2.644    81.961     0.200
     3.155    97.961     0.200
     3.155    98.062     0.200
     3.225    99.961     0.200
     3.454   106.762     0.200
     3.454   106.461     0.200
     3.795   117.262     0.200
     3.864   119.762     0.200
     4.212   132.363     0.200
     4.384   134.762     0.200
     5.161   160.363     0.200
     5.392   167.660     0.200
     5.627   173.062     0.200
     6.817   210.363     0.200
     7.027   217.160     0.200
     2.167    67.659     0.200
     2.345    73.859     0.200
     2.511    78.458     0.200
     2.718    84.359     0.200
     2.978    92.159     0.200
     3.296   102.659     0.200
     3.442   107.059     0.200
     3.654   113.958     0.200
     4.012   125.259     0.200
     4.337   134.559     0.200
     4.929   152.359     0.200
     5.367   165.159     0.200
     2.218    69.750     0.200
     2.292    71.750     0.200
     2.292    70.750     0.200
     2.569    78.648     0.200
     2.574    80.148     0.200
     2.574    79.750     0.200
     2.683    83.250     0.200
     3.077    95.352     0.200
     3.293   102.289     0.200
     3.293   100.949     0.200
     3.436   106.352     0.200
     3.436   106.250     0.200
     3.447   108.648     0.200
     3.447   106.148     0.200
     3.791   115.750     0.200
     3.791   116.949     0.200
     3.856   117.648     0.200
     4.138   128.949     0.200
     4.165   129.949     0.200
     4.287   132.852     0.200
     4.411   136.949     0.200
     4.411   135.648     0.200
     4.773   147.750     0.200
     5.209   160.648     0.200
     5.549   169.449     0.200
     6.744   209.449     0.200
     6.970   215.148     0.200
     7.459   229.852     0.200
     8.222   256.504     0.200
     2.209    68.219     0.200
     2.500    77.818     0.200
     2.657    81.818     0.200
     2.763    86.818     0.200
     2.997    93.019     0.200
     3.395   103.818     0.200
     3.375   105.919     0.200
     3.707   113.719     0.200
     3.934   122.619     0.200
     4.418   137.719     0.200
     4.370   137.219     0.200
     4.850   149.519     0.200
     5.277   162.619     0.200
     5.468   169.519     0.200
     2.046    64.723     0.200
     2.203    68.523     0.200
     2.366    73.324     0.200
     3.102    95.324     0.200
     4.285   131.926     0.200
     2.289    70.617     0.200
     2.294    71.914     0.200
     2.736    84.316     0.200
     2.778    84.715     0.200
     2.916    91.117     0.200
     3.028    92.914     0.200
     3.167    97.117     0.200
     3.522   109.816     0.200
     4.100   126.816     0.200
     4.376   135.414     0.200
     2.203    67.564     0.200
     2.203    66.765     0.200
     2.313    72.365     0.200
     2.561    77.765     0.200
     2.561    78.965     0.200
     2.695    83.965     0.200
     2.823    88.965     0.200
     2.823    87.064     0.200
     3.022    91.865     0.200
     3.022    92.265     0.200
     3.274    99.564     0.200
     3.274    99.265     0.200
     3.387   105.064     0.200
     3.423   105.765     0.200
     3.683   112.765     0.200
     3.999   123.265     0.200
     3.999   122.665     0.200
     4.292   132.465     0.200
     4.292   131.465     0.200
     2.280    70.223     0.200
     2.753    83.521     0.200
     3.059    92.521     0.200
     3.151    96.621     0.200
     3.715   114.121     0.200
     4.025   123.822     0.200
     2.058    63.656     0.200
     2.212    68.957     0.200
     2.315    70.656     0.200
     2.430    76.156     0.200
     2.608    80.156     0.200
     2.828    86.355     0.200
     3.124    95.656     0.200
     3.290   101.957     0.200
     4.158   128.660     0.200
     6.217   190.660     0.200
     2.241    70.270     0.200
     2.269    69.969     0.200
     2.573    79.168     0.200
     2.606    80.469     0.200
     2.606    80.367     0.200
     2.723    83.668     0.200
     2.723    84.668     0.200
     3.065    93.668     0.200
     3.065    94.867     0.200
     3.329   103.969     0.200
     3.329   102.367     0.200
     3.384   103.066     0.200
     3.384   103.168     0.200
     3.435   104.867     0.200
     3.435   106.867     0.200
     3.762   116.367     0.200
     3.898   119.469     0.200
     3.898   119.270     0.200
     4.115   127.566     0.200
     4.115   129.367     0.200
     4.313   134.770     0.200
     4.368   134.270     0.200
     4.368   135.770     0.200
     4.815   147.469     0.200
     4.815   147.770     0.200
     5.256   162.668     0.200
     5.291   161.168     0.200
     5.291   166.066     0.200
     5.536   170.270     0.200
     6.714   208.270     0.200
     6.926   212.270     0.200
     2.370    75.143     0.200
     2.370    75.243     0.200
     2.529    77.043     0.200
     2.622    79.743     0.200
     3.004    90.843     0.200
     3.229    98.243     0.200
     3.527   107.743     0.200
     3.609   111.543     0.200
     3.822   117.143     0.200
     4.056   125.343     0.200
     4.437   135.543     0.200
     4.712   144.943     0.200
     2.095    64.629     0.200
     2.099    66.129     0.200
     2.354    71.229     0.200
     2.754    85.229     0.200
     2.839    87.029     0.200
     2.863    89.529     0.200
     3.462   106.129     0.200
     3.605   110.429     0.200
     4.002   122.429     0.200
     4.482   141.029     0.200
     5.127   161.029     0.200
     5.312   164.829     0.200
     5.336   164.529     0.200
     6.844   211.629     0.200
     2.175    67.031     0.200
     2.307    72.031     0.200
     2.327    71.633     0.200
     2.327    72.133     0.200
     2.510    78.734     0.200
     2.574    79.438     0.200
     2.574    79.336     0.200
     2.715    82.938     0.200
     2.912    91.031     0.200
     3.399   105.438     0.200
     3.399   106.133     0.200
     3.454   107.836     0.200
     3.546   110.031     0.200
     4.136   125.938     0.200
     4.136   127.633     0.200
     4.576   140.734     0.200
     4.724   146.938     0.200
     4.987   153.734     0.200
     5.058   158.031     0.200
     5.969   184.031     0.200
     6.096   187.336     0.200
     6.082   187.438     0.200
     2.034    62.008     0.200
     2.034    63.707     0.200
     2.195    68.809     0.200
     2.245    70.707     0.200
     2.245    70.910     0.200
     2.308    70.309     0.200
     2.308    70.809     0.200
     2.417    76.109     0.200
     2.612    79.809     0.200
     2.612    80.410     0.200
     2.855    85.910     0.200
     2.855    87.410     0.200
     2.959    91.809     0.200
     3.139    97.410     0.200
     3.139    97.707     0.200
     3.269   102.008     0.200
     3.405   106.008     0.200
     3.405   104.008     0.200
     3.538   110.109     0.200
     3.538   110.508     0.200
     4.002   123.207     0.200
     4.002   123.508     0.200
     4.677   144.008     0.200
     4.677   144.707     0.200
     4.942   154.008     0.200
     5.045   154.109     0.200
     5.930   182.707     0.200
     6.079   188.109     0.200
     6.242   191.707     0.200
     2.246    69.422     0.200
     2.246    69.621     0.200
     2.443    75.223     0.200
     2.443    75.121     0.200
     2.643    82.223     0.200
     2.643    80.320     0.200
     2.677    83.621     0.200
     2.773    85.820     0.200
     2.869    88.121     0.200
     3.292   103.121     0.200
     3.569   109.520     0.200
     3.711   114.020     0.200
     3.711   114.422     0.200
     4.305   131.520     0.200
     4.840   147.121     0.200
     4.888   149.020     0.200
     2.314    71.404     0.200
     2.449    76.203     0.200
     2.449    76.404     0.200
     2.569    80.104     0.200
     2.832    87.805     0.200
     3.043    94.805     0.200
     3.043    95.104     0.200
     3.355   104.203     0.200
     3.526   110.104     0.200
     3.629   110.604     0.200
     3.629   111.504     0.200
     3.629   114.504     0.200
     4.014   125.904     0.200
     4.060   125.604     0.200
     4.340   133.904     0.200
     5.027   155.904     0.200
     5.590   171.703     0.200
     2.348    71.867     0.200
     3.554   107.867     0.200
     4.024   122.766     0.200
     4.101   127.164     0.200
     2.073    64.516     0.200
     2.073    63.414     0.200
     2.121    67.312     0.200
     2.332    72.609     0.200
     2.840    88.016     0.200
     2.775    85.914     0.200
     2.858    88.312     0.200
     3.212   100.211     0.200
     3.212   101.109     0.200
     3.431   106.211     0.200
     3.431   106.312     0.200
     3.483   107.312     0.200
     3.483   107.109     0.200
     3.917   122.914     0.200
     4.536   140.109     0.200
     4.536   140.211     0.200
     4.504   141.609     0.200
     4.931   152.109     0.200
     4.931   151.516     0.200
     5.106   157.812     0.200
     5.313   164.016     0.200
     5.313   163.312     0.200
     5.327   164.812     0.200
     5.855   183.484     0.200
     6.539   202.914     0.200
     6.828   211.211     0.200
     7.400   230.914     0.200
     7.565   234.211     0.200
    14.012   436.586     0.200
     2.127    67.500     0.200
     2.392    72.799     0.200
     2.392    73.399     0.200
     2.506    79.099     0.200
     2.831    88.000     0.200
     2.879    89.699     0.200
     2.879    89.599     0.200
     2.993    92.799     0.200
     3.196    99.799     0.200
     3.196   100.899     0.200
     3.213    99.599     0.200
     3.213    98.699     0.200
     3.492   108.199     0.200
     3.602   113.000     0.200
     3.602   111.199     0.200
     3.853   121.599     0.200
     3.853   120.199     0.200
     4.166   129.000     0.200
     4.345   133.199     0.200
     4.345   134.099     0.200
     4.581   142.799     0.200
     4.581   142.699     0.200
     5.082   157.399     0.200
     5.506   171.899     0.200
     5.506   171.799     0.200
     5.679   178.879     0.200
     5.805   184.898     0.200
     6.443   201.599     0.200
     6.663   206.299     0.200
     7.293   229.000     0.200
     8.038   249.199     0.200
     2.013    62.277     0.200
     2.013    61.875     0.200
     2.389    72.578     0.200
     2.389    72.875     0.200
     2.500    78.477     0.200
     2.833    87.578     0.200
     2.833    88.078     0.200
     2.871    88.578     0.200
     2.984    91.977     0.200
     2.984    91.777     0.200
     3.198   100.578     0.200
     3.227    99.078     0.200
     3.227    97.875     0.200
     3.499   107.477     0.200
     3.499   107.375     0.200
     3.593   110.777     0.200
     4.155   126.777     0.200
     4.155   127.375     0.200
     4.356   133.777     0.200
     4.575   143.277     0.200
     5.029   157.477     0.200
     5.029   155.676     0.200
     5.071   155.875     0.200
     5.298   162.375     0.200
     5.494   170.977     0.200
     5.494   171.375     0.200
     6.675   205.977     0.200
     2.009    63.199     0.200
     2.011    60.301     0.200
     2.011    64.000     0.200
     2.094    65.199     0.200
     2.322    71.402     0.200
     2.322    70.500     0.200
     2.331    71.602     0.200
     2.331    72.602     0.200
     2.517    78.000     0.200
     2.566    80.902     0.200
     2.628    84.102     0.200
     2.660    83.199     0.200
     2.660    82.699     0.200
     2.739    85.902     0.200
     2.779    84.199     0.200
     2.779    85.902     0.200
     2.817    86.801     0.200
     3.218    99.902     0.200
     3.218    97.801     0.200
     3.700   112.699     0.200
     4.286   131.699     0.200
     4.286   131.102     0.200
     4.738   145.402     0.200
     4.871   147.801     0.200
     2.072    64.383     0.200
     2.072    64.180     0.200
     2.132    67.477     0.200
     2.316    71.781     0.200
     2.316    71.977     0.200
     2.447    76.680     0.200
     2.832    87.781     0.200
     2.832    86.781     0.200
     2.774    86.180     0.200
     2.774    85.477     0.200
     2.851    88.078     0.200
     2.851    86.281     0.200
     3.205   100.180     0.200
     3.205    98.977     0.200
     3.455   106.281     0.200
     3.455   105.883     0.200
     3.479   107.180     0.200
     3.479   106.477     0.200
     3.586   110.180     0.200
     3.586   109.977     0.200
     4.012   123.477     0.200
     4.012   122.180     0.200
     4.505   142.180     0.200
     4.564   140.883     0.200
     4.922   149.883     0.200
     4.922   152.383     0.200
     4.922   150.078     0.200
     5.106   158.883     0.200
     5.305   163.883     0.200
     5.305   162.180     0.200
     5.312   164.977     0.200
     5.763   178.312     0.200
     5.871   186.156     0.200
     6.541   201.977     0.200
     6.841   211.078     0.200
     7.403   229.078     0.200
    13.990   435.641     0.200
    18.004   566.695     0.200
     2.178    67.484     0.200
     2.178    66.684     0.200
     2.474    76.184     0.200
     2.474    75.984     0.200
     2.687    82.484     0.200
     2.687    84.082     0.200
     2.792    85.582     0.200
     2.967    90.984     0.200
     2.967    89.383     0.200
     3.337   103.684     0.200
     3.382   103.582     0.200
     3.382   103.684     0.200
     3.404   105.582     0.200
     3.677   113.082     0.200
     3.677   114.082     0.200
     3.962   119.383     0.200
     3.962   122.883     0.200
     3.962   123.984     0.200
     3.962   120.582     0.200
     4.422   136.082     0.200
     4.422   136.281     0.200
     4.401   137.684     0.200
     4.877   150.082     0.200
     4.877   150.281     0.200
     5.204   163.082     0.200
     5.439   167.184     0.200
     5.713   179.344     0.200
     6.630   206.582     0.200
     6.869   211.582     0.200
     7.548   232.684     0.200
     9.674   301.383     0.200
    10.022   311.781     0.200
    14.032   436.984     0.200
     2.239    69.430     0.200
     2.239    70.027     0.200
     2.273    71.230     0.200
     2.570    78.730     0.200
     2.647    81.230     0.200
     2.770    86.027     0.200
     2.770    86.129     0.200
     3.047    94.129     0.200
     3.047    92.828     0.200
     3.329   102.730     0.200
     3.373   103.230     0.200
     3.414   107.828     0.200
     3.414   107.527     0.200
     3.726   115.027     0.200
     3.726   113.930     0.200
     3.946   120.129     0.200
     4.085   128.828     0.200
     4.328   132.527     0.200
     4.347   136.430     0.200
     4.864   150.027     0.200
     5.256   162.230     0.200
     5.310   164.129     0.200
     6.677   206.430     0.200
     6.876   212.328     0.200
     7.561   234.629     0.200
     2.185    67.309     0.200
     2.327    72.910     0.200
     2.522    77.410     0.200
     2.522    77.512     0.200
     2.699    83.512     0.200
     2.818    86.211     0.200
     2.993    92.211     0.200
     3.310   101.211     0.200
     3.310   102.109     0.200
     3.423   105.211     0.200
     3.993   121.609     0.200
     3.993   121.910     0.200
     4.030   125.211     0.200
     4.401   136.512     0.200
     4.910   151.109     0.200
     5.203   160.809     0.200
     5.462   169.910     0.200
     5.549   173.309     0.200
     6.623   205.410     0.200
     6.831   209.711     0.200
     2.300    70.328     0.200
     2.444    75.031     0.200
     2.444    75.328     0.200
     2.592    79.531     0.200
     2.867    87.129     0.200
     3.033    93.129     0.200
     3.384   105.930     0.200
     3.510   107.930     0.200
     3.625   110.629     0.200
     3.625   111.930     0.200
     3.994   125.531     0.200
     4.079   125.930     0.200
     4.306   131.430     0.200
     4.438   138.031     0.200
     4.546   139.629     0.200
     5.032   155.828     0.200
     5.610   175.730     0.200
     5.856   181.730     0.200
     7.192   221.129     0.200
     7.192   223.031     0.200
     2.236    69.578     0.200
     2.236    69.777     0.200
     2.565    78.879     0.200
     2.565    78.680     0.200
     2.649    81.680     0.200
     2.649    80.777     0.200
     2.771    85.078     0.200
     2.771    86.180     0.200
     3.043    95.180     0.200
     3.043    93.180     0.200
     3.332   103.180     0.200
     3.332   101.578     0.200
     3.374   104.277     0.200
     3.374   103.578     0.200
     3.411   105.480     0.200
     3.946   121.578     0.200
     3.946   121.777     0.200
     4.333   132.379     0.200
     4.350   135.879     0.200
     4.350   135.980     0.200
     5.512   169.180     0.200
     6.675   207.980     0.200
     6.876   212.379     0.200
     7.525   232.480     0.200
     7.560   233.480     0.200
     2.289    70.711     0.200
     2.690    83.211     0.200
     2.733    84.711     0.200
     2.856    88.211     0.200
     3.119    95.812     0.200
     3.148    96.914     0.200
     3.432   107.109     0.200
     3.735   116.016     0.200
     4.079   125.312     0.200
     4.039   125.711     0.200
     4.347   135.812     0.200
     4.961   153.711     0.200
     5.273   165.211     0.200
     5.340   166.016     0.200
     5.451   169.609     0.200
     5.604   173.711     0.200
     6.675   207.312     0.200
     6.778   207.414     0.200
     9.846   304.414     0.200
     2.299    70.570     0.200
     2.441    75.570     0.200
     2.441    75.875     0.200
     2.591    80.273     0.200
     2.864    87.672     0.200
     3.031    92.672     0.200
     3.383   104.477     0.200
     3.515   107.570     0.200
     3.622   110.070     0.200
     3.994   124.172     0.200
     4.079   126.070     0.200
     4.312   131.672     0.200
     4.437   139.273     0.200
     4.543   140.375     0.200
     5.028   155.977     0.200
     5.610   174.070     0.200
     5.855   180.773     0.200
     7.030   217.273     0.200
     7.030   217.070     0.200
     7.289   226.172     0.200
     2.300    70.503     0.200
     2.300    70.703     0.200
     2.457    74.304     0.200
     2.541    77.003     0.200
     2.608    79.003     0.200
     2.608    80.104     0.200
     2.608    82.304     0.200
     3.025    91.403     0.200
     3.025    93.403     0.200
     3.239    98.403     0.200
     3.239    98.983     0.200
     3.402   105.203     0.200
     3.402   104.003     0.200
     3.645   114.703     0.200
     3.822   116.403     0.200
     3.766   114.903     0.200
     3.766   114.403     0.200
     4.284   134.003     0.200
     4.675   141.903     0.200
     4.675   142.903     0.200
     5.068   158.403     0.200
     5.068   155.104     0.200
     5.337   167.403     0.200
     5.499   168.804     0.200
     5.499   169.804     0.200
     5.658   176.604     0.200
     5.750   179.684     0.200
     6.776   211.304     0.200
     7.087   218.903     0.200
    17.758   558.558     0.200
    18.235   574.878     0.200
    18.321   574.878     0.200
     2.239    69.781     0.200
     2.564    79.984     0.200
     2.564    79.586     0.200
     2.644    81.984     0.200
     2.765    85.086     0.200
     2.765    85.680     0.200
     3.043    92.883     0.200
     3.043    94.281     0.200
     3.340   103.586     0.200
     3.340   103.484     0.200
     3.412   105.984     0.200
     3.369   103.680     0.200
     3.369   104.680     0.200
     3.727   114.484     0.200
     3.727   115.680     0.200
     3.940   120.086     0.200
     3.940   121.586     0.200
     4.340   132.883     0.200
     4.340   132.781     0.200
     4.347   136.086     0.200
     4.347   135.984     0.200
     4.858   147.586     0.200
     4.858   150.086     0.200
     5.257   161.883     0.200
     5.257   163.180     0.200
     5.302   162.383     0.200
     5.302   162.281     0.200
     6.678   207.383     0.200
     6.882   212.680     0.200
     8.128   251.383     0.200
    10.057   310.586     0.200
    14.046   435.086     0.200
    18.586   580.484     0.200
    22.668   716.078     0.200
    23.015   698.055     0.200
     2.246    69.820     0.200
     2.246    69.523     0.200
     2.575    80.125     0.200
     2.575    79.727     0.200
     2.640    81.320     0.200
     2.763    84.320     0.200
     2.763    85.227     0.200
     3.054    94.320     0.200
     3.334   102.922     0.200
     3.365   103.523     0.200
     3.365   103.625     0.200
     3.421   106.125     0.200
     3.733   114.922     0.200
     3.939   119.922     0.200
     4.329   133.422     0.200
     4.329   133.227     0.200
     4.340   134.820     0.200
     4.856   149.422     0.200
     4.856   149.820     0.200
     5.303   163.820     0.200
     5.523   169.820     0.200
     5.497   171.320     0.200
     6.883   212.320     0.200
     2.245    69.477     0.200
     2.566    80.180     0.200
     2.566    78.977     0.200
     2.637    81.477     0.200
     2.758    84.781     0.200
     2.758    84.883     0.200
     3.048    91.977     0.200
     3.048    94.180     0.200
     3.347   103.383     0.200
     3.362   104.281     0.200
     3.362   103.078     0.200
     3.417   105.680     0.200
     3.734   115.680     0.200
     3.933   120.680     0.200
     3.933   119.477     0.200
     4.344   133.680     0.200
     4.340   135.477     0.200
     4.851   148.281     0.200
     5.294   163.281     0.200
     5.518   169.781     0.200
     5.507   173.281     0.200
     6.685   206.477     0.200
     6.890   212.180     0.200
     2.247    70.062     0.200
     2.247    69.867     0.200
     2.572    80.664     0.200
     2.572    79.469     0.200
     2.637    81.266     0.200
     2.759    85.062     0.200
     2.759    85.469     0.200
     3.052    93.266     0.200
     3.052    94.562     0.200
     3.341   102.766     0.200
     3.341   103.562     0.200
     3.362   102.867     0.200
     3.362   103.867     0.200
     3.420   108.164     0.200
     3.420   106.969     0.200
     3.735   115.969     0.200
     3.934   121.164     0.200
     3.934   119.469     0.200
     4.336   132.766     0.200
     4.336   133.062     0.200
     4.339   135.062     0.200
     4.339   135.664     0.200
     5.522   169.562     0.200
     5.522   169.969     0.200
     5.501   171.766     0.200
     6.686   206.664     0.200
     6.888   212.469     0.200
     8.128   251.664     0.200
     9.915   307.562     0.200
     2.232    69.219     0.200
     2.232    69.621     0.200
     2.564    79.520     0.200
     2.654    81.922     0.200
     2.776    84.922     0.200
     2.776    85.719     0.200
     3.040    94.020     0.200
     3.327   102.621     0.200
     3.327   104.520     0.200
     3.407   105.719     0.200
     3.407   107.219     0.200
     3.379   104.520     0.200
     3.379   104.922     0.200
     3.379   105.520     0.200
     3.719   114.020     0.200
     3.719   114.922     0.200
     3.951   120.820     0.200
     4.078   128.520     0.200
     4.354   135.820     0.200
     4.354   135.621     0.200
     4.869   149.422     0.200
     4.869   150.219     0.200
     5.314   162.820     0.200
     5.509   169.719     0.200
     5.509   172.621     0.200
     5.624   178.102     0.200
     6.670   207.422     0.200
     6.871   212.219     0.200
     8.115   250.922     0.200
     9.898   304.820     0.200
     2.226    69.182     0.200
     2.560    79.082     0.200
     2.660    81.882     0.200
     2.782    84.682     0.200
     3.035    91.682     0.200
     3.035    94.382     0.200
     3.323   103.482     0.200
     3.385   104.282     0.200
     3.385   105.082     0.200
     3.713   114.682     0.200
     3.958   122.282     0.200
     4.072   127.582     0.200
     4.360   137.182     0.200
     4.876   147.982     0.200
     4.876   150.282     0.200
     5.244   162.682     0.200
     5.320   164.782     0.200
     5.504   169.882     0.200
     6.664   205.782     0.200
     6.664   206.982     0.200
     2.251    69.369     0.200
     2.251    69.969     0.200
     2.576    79.069     0.200
     2.634    81.169     0.200
     2.756    83.269     0.200
     2.756    85.269     0.200
     3.056    94.769     0.200
     3.359   103.269     0.200
     3.359   104.369     0.200
     3.424   107.969     0.200
     3.738   115.369     0.200
     3.932   119.869     0.200
     3.932   121.069     0.200
     4.097   128.569     0.200
     4.335   135.369     0.200
     4.850   147.569     0.200
     4.850   149.269     0.200
     5.269   162.069     0.200
     5.269   163.569     0.200
     5.296   164.069     0.200
     6.690   207.569     0.200
     2.244    69.320     0.200
     2.244    69.820     0.200
     2.573    79.219     0.200
     2.642    81.320     0.200
     2.765    84.020     0.200
     2.765    85.121     0.200
     3.051    93.320     0.200
     3.051    94.219     0.200
     3.333   102.820     0.200
     3.333   101.922     0.200
     3.419   106.219     0.200
     3.368   103.320     0.200
     3.368   104.320     0.200
     3.731   114.219     0.200
     3.731   114.621     0.200
     3.941   120.219     0.200
     3.941   121.820     0.200
     4.089   127.621     0.200
     4.329   132.621     0.200
     4.859   150.621     0.200
     5.261   162.121     0.200
     5.261   163.020     0.200
     5.305   166.121     0.200
     5.520   170.820     0.200
     5.500   172.320     0.200
     6.681   207.320     0.200
     6.681   207.621     0.200
     6.881   211.820     0.200
     2.260    69.594     0.200
     2.585    79.895     0.200
     2.625    81.094     0.200
     2.748    84.395     0.200
     3.066    95.594     0.200
     3.344   103.094     0.200
     3.350   105.691     0.200
     3.434   106.992     0.200
     3.748   115.492     0.200
     3.924   121.492     0.200
     4.332   133.191     0.200
     4.326   135.594     0.200
     4.842   148.395     0.200
     5.289   165.191     0.200
     5.489   172.395     0.200
     6.699   209.293     0.200
     6.898   214.594     0.200
     2.245    69.812     0.200
     2.571    79.412     0.200
     2.638    81.312     0.200
     4.337   132.314     0.200
     2.211    68.195     0.200
     2.538    78.195     0.200
     3.334   103.094     0.200
     4.350   132.395     0.200
     2.228    68.684     0.200
     2.228    68.984     0.200
     2.555    79.184     0.200
     2.654    81.884     0.200
     2.774    85.084     0.200
     2.774    85.384     0.200
     3.034    91.584     0.200
     3.034    93.284     0.200
     3.336   101.784     0.200
     3.336   103.084     0.200
     3.379   103.184     0.200
     3.379   104.384     0.200
     3.949   119.984     0.200
     3.949   120.984     0.200
     4.342   133.784     0.200
     4.357   135.984     0.200
     4.867   149.684     0.200
     6.874   211.884     0.200
     7.560   234.684     0.200
     2.046    64.734     0.200
     2.307    71.930     0.200
     2.307    71.430     0.200
     2.511    78.734     0.200
     2.562    78.930     0.200
     2.901    90.930     0.200
     3.391   105.234     0.200
     3.534   111.133     0.200
     4.127   127.531     0.200
     4.577   139.930     0.200
     4.577   142.133     0.200
     5.054   157.133     0.200
     5.630   173.328     0.200
     5.870   182.734     0.200
     6.065   188.531     0.200
     6.110   188.328     0.200
     2.147    65.223     0.200
     2.147    66.125     0.200
     2.616    79.625     0.200
     2.616    79.426     0.200
     2.823    86.824     0.200
     3.062    94.824     0.200
     3.062    93.824     0.200
     3.013    92.523     0.200
     2.978    91.324     0.200
     2.978    92.125     0.200
     3.370   105.125     0.200
     3.370   105.523     0.200
     3.594   110.324     0.200
     3.594   111.125     0.200
     3.561   108.723     0.200
     4.110   124.926     0.200
     4.160   127.125     0.200
     4.160   127.324     0.200
     4.487   139.723     0.200
     5.131   158.926     0.200
     5.081   156.023     0.200
     5.466   168.223     0.200
     5.598   176.285     0.200
     5.553   170.824     0.200
     6.535   202.824     0.200
     6.657   205.223     0.200
    14.321   445.098     0.200
     2.246    69.703     0.200
     2.569    78.801     0.200
     2.569    79.000     0.200
     2.637    81.500     0.200
     2.758    85.203     0.200
     2.758    85.500     0.200
     3.050    94.102     0.200
     3.362   103.902     0.200
     3.418   107.703     0.200
     3.418   106.602     0.200
     3.735   115.902     0.200
     3.933   118.801     0.200
     3.933   122.301     0.200
     4.092   128.402     0.200
     4.341   133.902     0.200
     4.339   135.500     0.200
     4.851   149.602     0.200
     5.265   164.402     0.200
     5.295   163.000     0.200
     5.520   169.500     0.200
     5.505   171.801     0.200
     6.686   206.301     0.200
     2.074    65.394     0.200
     2.136    65.494     0.200
     2.136    66.294     0.200
     2.710    83.394     0.200
     2.710    84.194     0.200
     2.790    85.394     0.200
     2.893    88.994     0.200
     3.416   104.394     0.200
     3.483   106.994     0.200
     3.650   112.594     0.200
     3.650   113.394     0.200
     4.442   139.194     0.200
     4.557   139.594     0.200
     4.863   149.994     0.200
     4.863   148.894     0.200
     5.170   161.794     0.200
     5.259   161.694     0.200
     5.367   164.494     0.200
     5.714   178.894     0.200
     6.604   205.694     0.200
     2.117    64.816     0.200
     2.154    66.016     0.200
     2.760    83.516     0.200
     2.760    83.715     0.200
     2.796    84.516     0.200
     2.796    84.715     0.200
     3.405   103.914     0.200
     3.306   100.215     0.200
     3.306   100.816     0.200
     3.786   116.316     0.200
     3.786   116.617     0.200
     4.016   123.016     0.200
     3.880   119.215     0.200
     4.266   130.816     0.200
     4.214   128.117     0.200
     4.820   148.215     0.200
     5.486   170.117     0.200
     5.545   173.277     0.200
     5.772   177.816     0.200
     5.872   180.016     0.200
     7.218   222.816     0.200
     7.547   232.516     0.200
     2.263    70.769     0.200
     2.578    78.469     0.200
     2.692    82.169     0.200
     4.657   142.969     0.200
     2.234    69.156     0.200
     2.234    69.258     0.200
     2.565    79.758     0.200
     2.565    78.855     0.200
     2.651    81.758     0.200
     2.773    86.156     0.200
     2.773    86.258     0.200
     3.041    91.957     0.200
     3.041    93.457     0.200
     3.330   101.258     0.200
     3.330   102.457     0.200
     3.376   103.457     0.200
     3.376   104.457     0.200
     3.409   107.758     0.200
     3.721   115.355     0.200
     3.721   114.855     0.200
     3.949   120.055     0.200
     4.332   132.855     0.200
     4.352   135.656     0.200
     4.867   149.855     0.200
     5.511   169.758     0.200
     5.508   171.957     0.200
     6.873   211.555     0.200
     2.241    69.586     0.200
     2.573    79.688     0.200
     2.646    81.789     0.200
     3.327   102.688     0.200
     2.639    80.389     0.200
     3.365   103.688     0.200
     2.182    68.223     0.200
     2.286    69.523     0.200
     2.775    85.123     0.200
     2.854    87.324     0.200
     2.939    89.223     0.200
     3.146    98.424     0.200
     3.374   101.723     0.200
     3.374   104.824     0.200
     3.506   107.824     0.200
     3.563   110.824     0.200
     4.101   123.824     0.200
     4.101   126.324     0.200
     4.519   139.424     0.200
     4.579   142.523     0.200
     5.028   156.523     0.200
     5.012   153.924     0.200
     5.247   161.223     0.200
     5.405   168.023     0.200
     6.460   200.623     0.200
     6.748   207.223     0.200
     2.242    69.484     0.200
     2.242    69.680     0.200
     2.566    79.680     0.200
     2.566    78.883     0.200
     2.641    81.180     0.200
     2.762    85.180     0.200
     2.762    85.781     0.200
     3.046    92.383     0.200
     3.046    94.281     0.200
     3.342   102.586     0.200
     3.342   103.383     0.200
     3.415   106.383     0.200
     3.415   107.586     0.200
     3.366   103.586     0.200
     3.366   103.781     0.200
     3.730   113.883     0.200
     3.730   115.781     0.200
     3.937   119.781     0.200
     3.937   120.984     0.200
     4.088   128.484     0.200
     4.341   134.086     0.200
     4.343   134.883     0.200
     4.855   148.984     0.200
     4.855   147.883     0.200
     5.299   164.484     0.200
     5.516   169.180     0.200
     5.516   170.484     0.200
     5.507   171.883     0.200
     6.682   206.484     0.200
     6.886   212.484     0.200
     7.532   233.883     0.200
     8.130   252.883     0.200
     2.246    69.477     0.200
     2.246    69.773     0.200
     2.571    78.977     0.200
     2.571    79.375     0.200
     2.638    81.172     0.200
     2.760    84.172     0.200
     2.760    84.977     0.200
     3.051    92.172     0.200
     3.051    94.273     0.200
     3.341   102.172     0.200
     3.341   103.172     0.200
     3.363   103.070     0.200
     3.363   103.172     0.200
     3.419   107.875     0.200
     3.734   114.773     0.200
     3.734   115.773     0.200
     3.935   120.977     0.200
     4.091   128.477     0.200
     4.337   133.070     0.200
     4.340   135.375     0.200
     4.340   136.273     0.200
     4.853   149.070     0.200
     5.298   163.375     0.200
     5.502   170.875     0.200
     5.520   168.875     0.200
     5.520   169.773     0.200
     6.685   207.977     0.200
     6.887   212.672     0.200
     7.535   235.977     0.200
     8.128   251.875     0.200
     8.278   256.570     0.200
     2.059    64.242     0.200
     2.313    71.742     0.200
     2.269    71.344     0.200
     2.288    70.844     0.200
     2.539    80.043     0.200
     2.539    79.941     0.200
     2.656    83.141     0.200
     2.842    87.441     0.200
     2.842    86.941     0.200
     2.844    86.844     0.200
     2.844    86.141     0.200
     3.233   100.742     0.200
     3.233   100.641     0.200
     3.543   109.344     0.200
     3.656   112.344     0.200
     3.656   113.543     0.200
     4.267   130.941     0.200
     4.267   131.242     0.200
     4.267   132.203     0.200
     4.336   132.742     0.200
     4.740   144.641     0.200
     4.825   147.141     0.200
     5.232   161.844     0.200
     5.788   178.543     0.200
     6.020   185.543     0.200
     6.130   191.043     0.200
     6.120   191.844     0.200
     6.280   196.961     0.200
     6.632   207.242     0.200
    14.730   458.762     0.200
     2.248    69.625     0.200
     2.571    79.422     0.200
     2.571    78.922     0.200
     2.635    81.523     0.200
     2.756    84.922     0.200
     2.756    85.320     0.200
     3.052    93.922     0.200
     3.346   102.219     0.200
     3.346   103.125     0.200
     3.360   104.125     0.200
     3.737   115.320     0.200
     3.931   119.719     0.200
     3.931   122.320     0.200
     4.094   126.625     0.200
     4.340   133.523     0.200
     4.337   136.125     0.200
     5.267   161.719     0.200
     5.267   163.219     0.200
     5.294   163.523     0.200
     5.522   170.523     0.200
     5.503   171.320     0.200
     6.891   212.820     0.200
     2.241    69.758     0.200
     2.241    69.961     0.200
     2.564    79.961     0.200
     2.564    79.258     0.200
     2.640    81.758     0.200
     2.761    86.059     0.200
     2.761    86.160     0.200
     3.045    92.359     0.200
     3.045    94.160     0.200
     3.345   102.758     0.200
     3.365   103.559     0.200
     3.365   104.461     0.200
     3.413   107.059     0.200
     3.730   115.758     0.200
     3.730   115.961     0.200
     3.936   121.961     0.200
     4.087   126.559     0.200
     4.344   134.160     0.200
     4.343   135.559     0.200
     4.853   148.758     0.200
     4.853   149.160     0.200
     5.260   163.059     0.200
     5.297   164.059     0.200
     5.515   170.059     0.200
     5.510   172.258     0.200
     6.682   206.758     0.200
     6.887   212.461     0.200
     9.116   281.660     0.200
     2.197    68.273     0.200
     2.497    77.074     0.200
     2.497    76.875     0.200
     2.671    82.574     0.200
     2.779    85.672     0.200
     2.779    86.375     0.200
     2.988    92.172     0.200
     2.988    93.672     0.200
     3.358   105.172     0.200
     3.358   105.574     0.200
     3.379   103.875     0.200
     3.379   104.273     0.200
     3.390   104.773     0.200
     3.950   120.273     0.200
     3.950   122.773     0.200
     4.043   126.375     0.200
     4.383   136.672     0.200
     4.383   136.973     0.200
     4.407   135.574     0.200
     4.407   135.172     0.200
     4.866   150.473     0.200
     5.221   160.773     0.200
     5.294   161.273     0.200
     5.294   165.773     0.200
     5.460   167.574     0.200
     5.578   174.672     0.200
     5.690   179.375     0.200
     6.647   205.875     0.200
     6.878   213.473     0.200
     8.700   268.672     0.200
     2.491    76.875     0.200
     3.364   102.672     0.200
     4.399   135.977     0.200
     2.203    68.238     0.200
     2.497    78.238     0.200
     2.497    77.338     0.200
     2.663    82.338     0.200
     2.770    85.538     0.200
     2.770    85.338     0.200
     2.992    93.038     0.200
     3.362   105.438     0.200
     3.390   104.938     0.200
     3.382   104.538     0.200
     3.382   104.738     0.200
     3.941   120.738     0.200
     4.048   125.238     0.200
     4.376   138.238     0.200
     4.416   135.738     0.200
     4.856   150.538     0.200
     5.228   161.738     0.200
     5.284   162.638     0.200
     5.284   162.438     0.200
     5.463   166.538     0.200
     5.579   174.538     0.200
     6.654   205.538     0.200
     6.888   213.738     0.200
     2.506    76.917     0.200
     2.669    82.817     0.200
     2.669    82.717     0.200
     2.779    86.517     0.200
     2.779    86.317     0.200
     2.995    92.117     0.200
     2.995    93.317     0.200
     3.371   105.817     0.200
     3.371   104.717     0.200
     3.365   105.717     0.200
     3.389   104.517     0.200
     3.389   104.917     0.200
     3.951   120.617     0.200
     3.951   121.517     0.200
     4.047   125.717     0.200
     4.396   135.717     0.200
     4.379   137.617     0.200
     4.867   150.617     0.200
     4.867   150.817     0.200
     5.225   162.117     0.200
     5.298   163.617     0.200
     5.466   167.617     0.200
     5.569   174.917     0.200
     5.681   177.317     0.200
     6.649   206.317     0.200
     6.877   213.117     0.200
     8.703   270.117     0.200
     2.190    67.891     0.200
     2.190    67.992     0.200
     2.490    76.789     0.200
     2.678    82.691     0.200
     2.785    85.891     0.200
     2.785    85.789     0.200
     2.981    91.891     0.200
     2.981    92.590     0.200
     3.351   105.289     0.200
     3.377   104.391     0.200
     3.377   104.789     0.200
     3.397   104.891     0.200
     3.397   104.492     0.200
     3.397   104.391     0.200
     3.957   119.992     0.200
     3.957   120.789     0.200
     4.035   126.090     0.200
     4.390   137.289     0.200
     4.409   134.992     0.200
     4.409   134.590     0.200
     4.872   147.992     0.200
     4.872   147.891     0.200
     5.214   161.492     0.200
     5.300   163.891     0.200
     6.640   205.891     0.200
     6.873   213.391     0.200
     2.197    68.421     0.200
     2.671    83.021     0.200
     2.780    85.821     0.200
     2.780    86.321     0.200
     2.990    92.721     0.200
     2.990    91.721     0.200
     3.360   104.921     0.200
     3.375   105.121     0.200
     3.375   104.021     0.200
     3.391   104.621     0.200
     3.391   104.121     0.200
     3.952   120.421     0.200
     3.952   121.721     0.200
     4.043   125.821     0.200
     4.383   137.021     0.200
     4.402   135.221     0.200
     4.868   149.921     0.200
     5.221   159.921     0.200
     5.221   163.121     0.200
     5.297   163.321     0.200
     5.461   168.521     0.200
     5.575   174.121     0.200
     6.646   205.321     0.200
     2.194    67.680     0.200
     2.194    68.078     0.200
     2.675    83.680     0.200
     2.784    85.979     0.200
     2.784    86.578     0.200
     2.987    93.078     0.200
     3.357   105.078     0.200
     3.372   104.180     0.200
     3.395   104.279     0.200
     3.690   113.979     0.200
     4.401   135.779     0.200
     4.386   136.479     0.200
     4.872   150.680     0.200
     5.218   161.578     0.200
     5.301   163.680     0.200
     5.458   167.779     0.200
     5.577   174.078     0.200
     6.643   204.279     0.200
     6.872   211.279     0.200
     2.234    68.754     0.200
     2.234    69.355     0.200
     2.567    78.254     0.200
     2.567    80.055     0.200
     2.653    80.652     0.200
     2.653    82.453     0.200
     2.776    85.355     0.200
     2.776    86.652     0.200
     3.042    92.355     0.200
     3.042    94.152     0.200
     3.325   101.652     0.200
     3.325   100.953     0.200
     3.410   107.754     0.200
     3.410   105.855     0.200
     3.379   104.355     0.200
     3.379   103.254     0.200
     3.720   114.152     0.200
     3.720   114.555     0.200
     3.952   120.152     0.200
     3.952   122.953     0.200
     4.079   126.254     0.200
     4.327   132.152     0.200
     4.327   132.453     0.200
     4.353   135.453     0.200
     4.870   150.055     0.200
     5.251   162.355     0.200
     5.315   163.855     0.200
     5.511   169.055     0.200
     6.671   205.453     0.200
     6.870   211.855     0.200
     2.305    71.482     0.200
     2.573    79.482     0.200
     2.559    79.682     0.200
     2.559    78.482     0.200
     2.667    82.182     0.200
     2.667    81.582     0.200
     3.085    95.582     0.200
     3.085    94.682     0.200
     3.277   101.283     0.200
     3.277   102.482     0.200
     3.277   100.082     0.200
     3.454   107.182     0.200
     3.454   106.682     0.200
     3.456   108.283     0.200
     3.456   107.883     0.200
     3.805   116.082     0.200
     3.839   118.182     0.200
     4.150   129.182     0.200
     4.273   134.082     0.200
     4.273   133.783     0.200
     4.424   135.682     0.200
     4.424   135.982     0.200
     4.755   144.383     0.200
     4.755   147.582     0.200
     5.190   160.682     0.200
     5.190   157.982     0.200
     5.511   171.383     0.200
     5.558   171.982     0.200
     6.758   209.883     0.200
     6.988   215.783     0.200
     2.229    68.828     0.200
     2.229    69.227     0.200
     2.552    78.828     0.200
     2.552    78.727     0.200
     2.653    82.125     0.200
     2.772    85.625     0.200
     2.772    85.930     0.200
     3.032    94.227     0.200
     3.342   103.727     0.200
     3.342   103.828     0.200
     3.400   106.727     0.200
     3.400   106.828     0.200
     3.377   103.930     0.200
     3.377   103.023     0.200
     3.718   114.625     0.200
     3.718   115.531     0.200
     4.074   127.531     0.200
     3.946   121.328     0.200
     3.946   120.531     0.200
     4.348   133.227     0.200
     4.348   133.430     0.200
     4.356   135.328     0.200
     4.864   149.930     0.200
     5.502   169.828     0.200
     5.521   173.031     0.200
     5.635   176.727     0.200
     6.669   207.227     0.200
     6.877   212.328     0.200
     7.520   233.328     0.200
    10.049   310.328     0.200
    14.046   433.859     0.200
    14.254   442.664     0.200
    17.905   561.977     0.200
    24.617   770.258     0.200
     2.235    69.707     0.200
     2.235    68.605     0.200
     2.645    81.707     0.200
     2.645    81.406     0.200
     2.764    85.207     0.200
     3.038    94.105     0.200
     3.348   103.605     0.200
     3.406   106.805     0.200
     3.406   106.906     0.200
     3.369   104.008     0.200
     3.369   103.605     0.200
     3.725   115.906     0.200
     3.939   121.605     0.200
     4.351   135.508     0.200
     4.351   132.707     0.200
     4.349   135.605     0.200
     4.349   135.008     0.200
     4.856   150.008     0.200
     4.856   149.105     0.200
     5.255   162.906     0.200
     5.508   169.305     0.200
     5.518   172.508     0.200
     5.631   177.148     0.200
     6.677   206.906     0.200
     6.884   213.707     0.200
     7.527   234.605     0.200
    14.261   442.020     0.200
    17.911   562.160     0.200
    17.968   564.332     0.200
    18.496   581.566     0.200
    18.581   581.566     0.200
    20.808   665.918     0.200
     2.152    68.086     0.200
     2.315    71.984     0.200
     2.568    78.188     0.200
     2.543    79.086     0.200
     2.646    81.484     0.200
     3.089    95.383     0.200
     3.484   107.781     0.200
     3.817   116.984     0.200
     3.817   116.188     0.200
     4.160   130.086     0.200
     4.262   134.383     0.200
     4.451   137.383     0.200
     4.733   145.586     0.200
     5.164   159.688     0.200
     5.344   165.781     0.200
     5.562   171.688     0.200
     6.772   211.188     0.200
     7.011   217.188     0.200
     2.674    81.844     0.200
     2.692    82.445     0.200
     3.338   102.742     0.200
     2.258    70.082     0.200
     2.258    69.480     0.200
     2.231    69.980     0.200
     2.578    79.980     0.200
     2.625    80.082     0.200
     2.746    85.082     0.200
     2.746    84.480     0.200
     2.879    88.383     0.200
     3.061    94.281     0.200
     3.061    93.680     0.200
     3.352   102.281     0.200
     3.352   102.980     0.200
     3.429   106.883     0.200
     3.429   107.582     0.200
     3.350   103.383     0.200
     3.350   102.383     0.200
     3.746   115.582     0.200
     3.922   121.281     0.200
     3.922   118.980     0.200
     4.103   128.281     0.200
     4.341   132.781     0.200
     4.327   135.281     0.200
     4.839   148.680     0.200
     5.277   164.180     0.200
     5.496   171.281     0.200
     5.531   170.180     0.200
     6.698   208.180     0.200
     6.901   212.781     0.200
     2.155    66.367     0.200
     2.412    73.867     0.200
     2.924    90.867     0.200
     3.664   112.268     0.200
     4.506   137.867     0.200
     2.232    69.207     0.200
     2.253    70.406     0.200
     2.550    78.406     0.200
     2.646    81.508     0.200
     2.764    85.109     0.200
     2.764    84.207     0.200
     2.900    89.207     0.200
     3.034    93.109     0.200
     3.034    93.008     0.200
     3.352   104.008     0.200
     3.352   103.109     0.200
     3.402   106.609     0.200
     3.370   104.207     0.200
     3.723   114.707     0.200
     4.357   134.609     0.200
     4.351   135.809     0.200
     4.856   150.406     0.200
     5.253   161.508     0.200
     5.296   164.906     0.200
     5.504   169.809     0.200
     6.675   205.406     0.200
     6.885   210.809     0.200
     2.201    68.656     0.200
     2.329    72.359     0.200
     2.329    72.055     0.200
     2.455    75.961     0.200
     2.666    82.555     0.200
     2.885    89.859     0.200
     2.927    90.859     0.200
     2.927    90.258     0.200
     3.434   105.758     0.200
     3.508   109.461     0.200
     3.508   107.055     0.200
     3.641   113.461     0.200
     3.808   118.258     0.200
     3.911   123.461     0.200
     4.428   136.359     0.200
     4.512   139.359     0.200
     4.904   151.758     0.200
     5.237   163.055     0.200
     5.693   175.461     0.200
     5.908   180.961     0.200
     6.859   212.961     0.200
     7.118   219.656     0.200
     7.310   225.359     0.200
     2.122    65.805     0.200
     2.122    64.406     0.200
     2.469    77.906     0.200
     2.617    79.805     0.200
     2.867    87.805     0.200
     3.009    91.805     0.200
     2.998    92.105     0.200
     2.998    91.805     0.200
     3.027    93.305     0.200
     3.127    96.605     0.200
     3.353   104.707     0.200
     3.560   109.406     0.200
     3.607   110.508     0.200
     4.209   128.305     0.200
     2.171    67.492     0.200
     2.303    71.791     0.200
     2.303    70.592     0.200
     2.425    74.992     0.200
     2.701    82.891     0.200
     2.921    89.291     0.200
     2.898    89.492     0.200
     2.898    89.191     0.200
     3.470   106.391     0.200
     3.470   105.291     0.200
     3.483   107.891     0.200
     3.648   113.992     0.200
     3.878   121.191     0.200
     4.198   129.891     0.200
     4.395   136.492     0.200
     4.404   136.391     0.200
     4.546   140.391     0.200
     4.886   150.391     0.200
     5.203   161.891     0.200
     5.944   184.691     0.200
     7.334   227.291     0.200
     2.031    63.223     0.200
     2.429    74.223     0.200
     2.421    74.621     0.200
     2.515    75.824     0.200
     2.630    82.121     0.200
     2.669    82.621     0.200
     3.181    97.723     0.200
     3.181    96.723     0.200
     3.132    96.621     0.200
     3.132    95.324     0.200
     3.556   109.621     0.200
     3.556   110.223     0.200
     3.603   110.621     0.200
     3.684   113.023     0.200
     3.939   121.422     0.200
     4.148   129.824     0.200
     4.272   132.223     0.200
     4.515   139.422     0.200
     4.599   140.723     0.200
     4.599   139.922     0.200
     5.029   155.723     0.200
     5.462   168.922     0.200
     5.480   169.523     0.200
     5.573   174.773     0.200
     5.655   174.621     0.200
     6.893   213.723     0.200
     7.146   220.523     0.200
     7.279   226.023     0.200
     9.952   307.223     0.200
    13.776   426.332     0.200
    17.704   557.074     0.200
    18.164   569.500     0.200
    18.673   581.051     0.200
     2.236    69.811     0.200
     2.257    70.111     0.200
     2.571    79.211     0.200
     2.652    81.511     0.200
     2.776    85.611     0.200
     2.906    89.711     0.200
     3.321   101.411     0.200
     3.321   104.811     0.200
     3.378   104.911     0.200
     3.952   122.111     0.200
     3.952   121.211     0.200
     4.082   126.511     0.200
     4.322   133.311     0.200
     4.351   136.011     0.200
     4.870   150.411     0.200
     5.253   161.811     0.200
     5.316   163.511     0.200
     5.316   163.011     0.200
     5.501   171.111     0.200
     6.673   206.511     0.200
     6.870   212.711     0.200
     7.303   227.511     0.200
     7.568   233.311     0.200
     2.250    69.844     0.200
     2.578    78.539     0.200
     2.578    80.938     0.200
     2.759    85.141     0.200
     2.759    84.539     0.200
     2.890    89.344     0.200
     3.057    94.344     0.200
     3.336   102.438     0.200
     3.336   103.938     0.200
     3.362   103.742     0.200
     3.362   104.242     0.200
     3.737   115.742     0.200
     3.935   121.438     0.200
     3.935   120.039     0.200
     4.095   127.742     0.200
     4.329   132.844     0.200
     4.337   136.141     0.200
     4.853   148.844     0.200
     4.853   148.539     0.200
     5.300   162.938     0.200
     5.526   170.039     0.200
     5.495   170.141     0.200
     6.886   212.539     0.200
     7.286   224.438     0.200
     8.797   270.742     0.200
     2.246    70.000     0.200
     2.246    70.699     0.200
     2.575    79.900     0.200
     2.764    85.600     0.200
     2.764    85.299     0.200
     2.895    89.900     0.200
     3.053    94.699     0.200
     3.053    93.500     0.200
     3.333   103.900     0.200
     3.333   103.600     0.200
     3.421   107.900     0.200
     3.421   107.299     0.200
     3.366   104.699     0.200
     3.366   104.299     0.200
     3.732   115.699     0.200
     3.940   122.400     0.200
     4.091   127.699     0.200
     4.091   127.100     0.200
     4.328   133.199     0.200
     4.341   135.500     0.200
     4.858   150.500     0.200
     4.858   148.699     0.200
     5.304   163.000     0.200
     5.522   170.400     0.200
     5.497   172.000     0.200
     5.612   176.627     0.200
     6.683   205.900     0.200
     6.882   212.699     0.200
     8.119   253.799     0.200
     8.802   270.900     0.200
    20.487   636.859     0.200
     2.253    69.648     0.200
     2.241    69.742     0.200
     2.585    80.547     0.200
     2.585    80.742     0.200
     2.635    80.945     0.200
     2.760    84.547     0.200
     3.062    95.148     0.200
     3.062    95.344     0.200
     3.329   101.742     0.200
     3.739   115.047     0.200
     3.936   121.945     0.200
     3.936   121.242     0.200
     4.320   132.742     0.200
     4.320   132.844     0.200
     4.334   134.945     0.200
     4.855   150.148     0.200
     4.855   149.945     0.200
     5.530   170.547     0.200
     6.689   205.648     0.200
     6.885   212.344     0.200
     2.038    64.344     0.200
     2.290    69.750     0.200
     2.624    80.945     0.200
     2.704    82.844     0.200
     3.017    93.047     0.200
     3.127    96.047     0.200
     3.151    97.047     0.200
     3.270   100.445     0.200
     3.353   102.648     0.200
     3.738   114.148     0.200
     4.297   130.047     0.200
     4.361   134.344     0.200
     4.720   147.344     0.200
     5.166   158.547     0.200
     5.212   160.344     0.200
     5.624   173.547     0.200
     5.786   180.547     0.200
     6.304   194.750     0.200
     6.538   200.750     0.200
     2.134    65.439     0.200
     2.134    65.139     0.200
     2.368    73.939     0.200
     2.507    75.939     0.200
     2.507    75.838     0.200
     2.763    84.838     0.200
     2.888    87.838     0.200
     2.958    90.238     0.200
     2.958    89.738     0.200
     3.017    93.039     0.200
     3.017    92.139     0.200
     3.241    99.539     0.200
     3.241    97.838     0.200
     3.490   107.639     0.200
     3.490   108.039     0.200
     3.614   111.238     0.200
     4.063   123.639     0.200
     4.298   132.338     0.200
     2.338    73.328     0.200
     2.477    76.328     0.200
     2.551    78.430     0.200
     2.594    81.023     0.200
     2.829    86.727     0.200
     3.069    94.727     0.200
     3.344   103.430     0.200
     3.494   108.523     0.200
     3.658   113.023     0.200
     3.715   115.430     0.200
     4.040   124.523     0.200
     4.034   126.523     0.200
     4.315   133.125     0.200
     4.397   136.227     0.200
     4.578   140.828     0.200
     5.058   156.023     0.200
     5.264   164.828     0.200
     5.570   172.023     0.200
     5.816   178.828     0.200
     6.990   217.023     0.200
     7.009   215.930     0.200
     7.159   221.625     0.200
     7.318   226.227     0.200
     2.337    72.039     0.200
     2.476    76.539     0.200
     2.551    78.840     0.200
     2.593    81.840     0.200
     2.827    86.238     0.200
     3.068    94.738     0.200
     3.343   104.340     0.200
     3.497   107.039     0.200
     3.656   111.340     0.200
     3.714   115.141     0.200
     4.040   124.941     0.200
     4.034   125.840     0.200
     4.317   133.238     0.200
     4.397   136.141     0.200
     4.577   139.840     0.200
     5.056   156.340     0.200
     5.570   171.738     0.200
     5.815   178.840     0.200
     6.990   215.738     0.200
     7.008   216.340     0.200
     7.161   221.238     0.200
     7.316   227.738     0.200
     8.524   262.738     0.200
     2.038    62.622     0.200
     2.419    74.522     0.200
     2.423    74.223     0.200
     2.498    75.822     0.200
     2.498    77.223     0.200
     2.574    78.122     0.200
     2.667    83.522     0.200
     3.147    97.223     0.200
     3.147    95.822     0.200
     3.125    95.923     0.200
     3.125    96.622     0.200
     3.524   109.423     0.200
     3.680   114.423     0.200
     3.661   112.322     0.200
     3.661   112.423     0.200
     3.938   121.423     0.200
     4.163   129.223     0.200
     4.258   132.022     0.200
     4.611   142.322     0.200
     4.573   140.223     0.200
     4.573   139.923     0.200
     4.983   154.322     0.200
     4.983   152.322     0.200
     5.455   168.522     0.200
     5.552   171.923     0.200
     5.622   173.822     0.200
     5.622   173.522     0.200
     5.640   178.581     0.200
     6.893   212.622     0.200
     7.007   217.423     0.200
     7.181   221.822     0.200
     7.229   223.522     0.200
     8.509   261.122     0.200
     2.141    68.117     0.200
     2.391    72.711     0.200
     2.512    79.516     0.200
     2.820    86.711     0.200
     2.820    86.016     0.200
     2.906    89.117     0.200
     3.024    93.617     0.200
     3.024    94.414     0.200
     3.179    99.016     0.200
     3.179    98.516     0.200
     3.183    99.312     0.200
     3.183    99.516     0.200
     3.160    98.711     0.200
     3.631   112.258     0.200
     3.631   112.117     0.200
     3.833   119.414     0.200
     4.197   129.617     0.200
     4.197   127.414     0.200
     4.321   131.812     0.200
     4.321   134.117     0.200
     4.321   132.812     0.200
     4.605   144.516     0.200
     5.000   153.914     0.200
     5.114   155.312     0.200
     5.282   162.516     0.200
     5.282   161.117     0.200
     5.540   172.016     0.200
     5.681   178.414     0.200
     5.810   184.477     0.200
     6.418   199.211     0.200
     6.630   204.016     0.200
     7.267   224.414     0.200
     8.946   277.711     0.200
     9.648   298.312     0.200
    14.242   444.664     0.200
    17.739   557.180     0.200
    18.219   571.977     0.200
    20.281   628.570     0.200
     2.137    65.708     0.200
     2.272    70.508     0.200
     2.736    84.808     0.200
     2.865    88.808     0.200
     2.955    90.708     0.200
     3.453   105.408     0.200
     3.453   108.308     0.200
     3.506   108.508     0.200
     3.664   112.508     0.200
     3.843   119.908     0.200
     3.879   119.708     0.200
     4.374   133.908     0.200
     4.391   135.108     0.200
     4.582   144.008     0.200
     4.862   149.808     0.200
     5.762   179.208     0.200
     5.980   185.408     0.200
     7.125   222.308     0.200
     7.185   224.108     0.200
     7.364   227.708     0.200
     2.250    69.426     0.200
     2.234    68.625     0.200
     2.560    77.926     0.200
     2.560    80.824     0.200
     2.627    81.125     0.200
     2.744    83.824     0.200
     2.880    88.426     0.200
     3.048    92.523     0.200
     3.369   103.926     0.200
     3.350   103.324     0.200
     3.417   105.125     0.200
     3.918   120.426     0.200
     4.096   126.426     0.200
     4.333   134.125     0.200
     4.835   148.824     0.200
     5.271   161.523     0.200
     5.276   163.223     0.200
     5.518   170.125     0.200
     6.694   206.223     0.200
     6.906   212.023     0.200
     7.527   232.824     0.200
     8.681   269.223     0.200
     2.249    68.797     0.200
     2.556    78.094     0.200
     3.046    92.797     0.200
     2.196    67.621     0.200
     2.292    70.723     0.200
     2.525    76.621     0.200
     2.685    82.523     0.200
     2.803    86.121     0.200
     2.938    91.422     0.200
     3.326   102.121     0.200
     3.369   104.121     0.200
     3.409   104.621     0.200
     3.409   106.422     0.200
     3.977   120.121     0.200
     3.977   122.723     0.200
     4.351   133.320     0.200
     4.389   137.023     0.200
     4.894   150.922     0.200
     5.332   164.922     0.200
     5.470   167.820     0.200
     6.636   206.023     0.200
     6.847   210.320     0.200
     7.582   235.223     0.200
     2.250    69.582     0.200
     2.241    70.684     0.200
     2.577    79.281     0.200
     2.635    81.582     0.200
     2.758    84.883     0.200
     2.889    89.684     0.200
     3.056    94.184     0.200
     3.338   102.980     0.200
     3.361   103.480     0.200
     3.424   107.184     0.200
     3.737   115.281     0.200
     3.934   123.082     0.200
     4.096   126.883     0.200
     4.336   135.383     0.200
     4.852   149.883     0.200
     5.268   163.184     0.200
     5.298   163.684     0.200
     5.526   170.781     0.200
     6.577   203.480     0.200
     6.888   214.082     0.200
     7.550   234.980     0.200
     8.703   267.980     0.200
    10.065   312.480     0.200
     2.254    69.570     0.200
     2.237    69.770     0.200
     2.579    78.672     0.200
     2.754    85.270     0.200
     3.059    94.770     0.200
     3.342   103.672     0.200
     3.357   103.172     0.200
     3.741   115.270     0.200
     3.930   119.270     0.200
     3.930   122.371     0.200
     4.099   125.469     0.200
     4.333   133.270     0.200
     4.332   134.969     0.200
     4.848   149.770     0.200
     5.272   163.469     0.200
     5.294   162.770     0.200
     5.529   170.770     0.200
     6.692   206.270     0.200
     6.892   213.070     0.200
     8.285   253.969     0.200
     2.209    67.190     0.200
     2.274    68.791     0.200
     2.450    74.690     0.200
     2.633    80.190     0.200
     2.633    82.690     0.200
     2.729    83.190     0.200
     2.904    87.891     0.200
     3.338   102.391     0.200
     3.436   103.690     0.200
     3.717   114.891     0.200
     3.853   119.190     0.200
     3.958   123.490     0.200
     4.157   126.490     0.200
     4.348   132.490     0.200
     4.684   143.791     0.200
     5.453   168.791     0.200
     5.526   173.542     0.200
     5.810   178.490     0.200
     7.015   216.190     0.200
     7.111   219.891     0.200
     8.742   269.791     0.200
     2.251    69.891     0.200
     2.241    70.789     0.200
     2.580    80.688     0.200
     2.636    80.688     0.200
     2.759    85.492     0.200
     2.890    88.789     0.200
     2.890    90.992     0.200
     3.058    93.688     0.200
     3.335   103.188     0.200
     3.362   103.891     0.200
     3.737   115.586     0.200
     3.935   121.688     0.200
     4.096   126.992     0.200
     4.327   133.086     0.200
     4.336   135.492     0.200
     4.853   149.492     0.200
     5.300   164.289     0.200
     5.527   170.492     0.200
     5.493   171.188     0.200
     6.688   207.586     0.200
     6.886   212.391     0.200
     7.552   233.188     0.200
     8.280   254.586     0.200
     8.706   269.289     0.200
     9.122   282.188     0.200
    10.065   311.086     0.200
     2.250    69.875     0.200
     2.250    69.273     0.200
     2.240    70.977     0.200
     2.574    79.875     0.200
     2.574    78.570     0.200
     2.634    81.773     0.200
     2.756    84.773     0.200
     2.887    89.977     0.200
     3.055    94.672     0.200
     3.344   103.477     0.200
     3.344   102.977     0.200
     3.359   104.773     0.200
     3.359   104.273     0.200
     3.738   115.477     0.200
     3.738   114.672     0.200
     3.931   121.570     0.200
     3.931   123.977     0.200
     3.931   119.070     0.200
     4.096   125.875     0.200
     4.335   135.375     0.200
     4.335   134.875     0.200
     4.337   133.070     0.200
     4.337   132.570     0.200
     4.849   149.672     0.200
     5.294   162.672     0.200
     5.294   162.773     0.200
     5.524   170.070     0.200
     5.500   170.477     0.200
     5.613   176.250     0.200
     6.574   203.875     0.200
     6.689   206.773     0.200
     6.891   213.477     0.200
     7.546   234.875     0.200
     8.282   256.477     0.200
     8.700   266.977     0.200
     9.115   282.375     0.200
     9.919   306.773     0.200
    10.067   310.477     0.200
    15.106   472.852     0.200
    17.906   563.438     0.200
    17.963   565.461     0.200
    18.580   584.148     0.200
    18.796   586.516     0.200
     2.059    64.961     0.200
     2.127    65.262     0.200
     2.336    71.562     0.200
     2.726    83.562     0.200
     2.816    86.660     0.200
     2.816    89.062     0.200
     2.901    89.262     0.200
     2.974    91.062     0.200
     3.424   106.062     0.200
     3.437   105.359     0.200
     3.972   122.062     0.200
     4.450   137.961     0.200
     4.497   138.859     0.200
     4.894   150.062     0.200
     5.158   158.961     0.200
     5.301   164.262     0.200
     5.373   165.062     0.200
     5.682   177.062     0.200
     6.588   203.262     0.200
     6.859   210.762     0.200
     7.542   233.660     0.200
     8.204   253.762     0.200
     9.993   307.461     0.200
     2.224    69.969     0.200
     2.224    69.770     0.200
     2.330    71.867     0.200
     2.621    80.969     0.200
     2.621    81.070     0.200
     2.735    83.070     0.200
     2.735    83.770     0.200
     2.780    85.770     0.200
     2.880    88.867     0.200
     2.880    88.469     0.200
     3.202    98.668     0.200
     3.202    98.070     0.200
     3.174    97.969     0.200
     3.174    96.367     0.200
     3.360   103.539     0.200
     3.360   103.867     0.200
     3.360   104.168     0.200
     3.536   108.469     0.200
     3.536   112.867     0.200
     3.789   116.367     0.200
     3.789   116.070     0.200
     3.962   120.867     0.200
     3.962   122.270     0.200
     4.138   127.168     0.200
     4.171   129.867     0.200
     4.288   132.770     0.200
     4.288   133.570     0.200
     4.884   150.168     0.200
     4.884   150.570     0.200
     5.335   166.168     0.200
     5.459   172.328     0.200
     6.732   208.367     0.200
     6.722   209.270     0.200
     7.313   226.570     0.200
     7.975   246.367     0.200
     8.297   254.969     0.200
     9.208   285.367     0.200
    10.076   311.367     0.200
    14.166   440.586     0.200
     2.223    68.195     0.200
     2.278    70.602     0.200
     2.573    78.297     0.200
     2.672    82.000     0.200
     2.800    86.000     0.200
     2.927    91.297     0.200
     3.039    93.000     0.200
     3.291   102.297     0.200
     3.400   105.602     0.200
     3.705   114.500     0.200
     3.977   123.102     0.200
     4.298   132.195     0.200
     4.368   135.797     0.200
     4.895   151.000     0.200
     5.236   161.898     0.200
     5.345   164.695     0.200
     5.506   169.398     0.200
     6.655   205.297     0.200
     6.844   210.195     0.200
     8.243   256.000     0.200
    10.026   309.195     0.200
     2.119    64.723     0.200
     2.945    90.023     0.200
     4.293   131.824     0.200
     6.741   207.125     0.200
     2.319    72.417     0.200
     2.463    76.817     0.200
     2.463    76.518     0.200
     2.575    79.917     0.200
     2.576    79.518     0.200
     2.857    87.617     0.200
     3.052    94.512     0.200
     3.052    95.218     0.200
     3.052    93.817     0.200
     3.371   105.018     0.200
     3.371   103.117     0.200
     3.493   110.317     0.200
     3.493   110.117     0.200
     3.644   112.117     0.200
     3.741   115.718     0.200
     3.741   119.218     0.200
     4.011   126.718     0.200
     4.011   126.518     0.200
     4.062   125.817     0.200
     4.297   134.018     0.200
     4.297   130.417     0.200
     4.421   137.617     0.200
     4.565   141.718     0.200
     4.565   141.417     0.200
     5.051   157.917     0.200
     5.335   169.035     0.200
     6.867   213.018     0.200
     7.012   217.817     0.200
     7.173   222.917     0.200
     7.312   227.917     0.200
     8.596   266.617     0.200
     8.894   275.218     0.200
    13.868   431.406     0.200
    14.601   451.530     0.200
    17.695   555.992     0.200
    18.368   578.819     0.200
    18.920   589.292     0.200
     2.425    75.969     0.200
     2.425    74.969     0.200
     2.598    80.770     0.200
     2.725    84.369     0.200
     2.725    84.068     0.200
     2.720    84.969     0.200
     3.224    99.770     0.200
     3.194    99.188     0.200
     3.194    99.469     0.200
     3.194   100.270     0.200
     3.419   105.568     0.200
     3.419   106.770     0.200
     3.594   112.168     0.200
     3.594   113.469     0.200
     3.777   115.869     0.200
     3.777   117.770     0.200
     3.777   118.270     0.200
     3.912   122.068     0.200
     4.162   130.369     0.200
     4.162   130.068     0.200
     4.271   133.270     0.200
     4.697   145.270     0.200
     5.163   161.168     0.200
     5.442   168.369     0.200
     5.463   173.369     0.200
     6.862   213.568     0.200
     7.041   217.668     0.200
     7.129   221.869     0.200
     7.710   238.270     0.200
     8.450   261.270     0.200
     8.997   279.068     0.200
    10.081   312.668     0.200
    10.233   317.668     0.200
    17.820   563.244     0.200
    17.977   563.469     0.200
    18.467   581.172     0.200
     2.458    75.674     0.200
     2.750    84.674     0.200
     3.244   100.174     0.200
     3.922   122.174     0.200
     5.454   167.674     0.200
     2.069    64.805     0.200
     2.432    75.305     0.200
     2.465    77.105     0.200
     2.603    79.707     0.200
     2.744    84.305     0.200
     2.721    84.305     0.200
     3.196    99.906     0.200
     3.237    99.105     0.200
     3.401   105.504     0.200
     3.606   111.207     0.200
     3.783   118.707     0.200
     3.916   120.305     0.200
     4.157   128.207     0.200
     4.278   132.504     0.200
     4.286   131.605     0.200
     4.703   145.004     0.200
     5.175   160.406     0.200
     5.336   167.004     0.200
     5.448   168.605     0.200
     6.865   212.805     0.200
     7.035   216.906     0.200
     7.135   221.406     0.200
     2.244    70.078     0.200
     2.242    70.273     0.200
     2.242    70.578     0.200
     2.560    79.172     0.200
     2.560    79.875     0.200
     2.636    81.375     0.200
     2.755    85.172     0.200
     2.755    84.375     0.200
     2.889    90.375     0.200
     3.045    94.672     0.200
     3.355   103.578     0.200
     3.355   102.977     0.200
     3.360   103.844     0.200
     3.360   104.477     0.200
     3.360   103.172     0.200
     3.413   106.477     0.200
     3.413   108.172     0.200
     3.734   115.773     0.200
     3.929   119.875     0.200
     3.929   123.273     0.200
     3.929   120.078     0.200
     4.340   135.172     0.200
     4.340   135.773     0.200
     4.354   133.578     0.200
     4.354   133.375     0.200
     4.847   149.977     0.200
     4.847   149.773     0.200
     5.264   162.273     0.200
     5.288   163.773     0.200
     5.288   163.375     0.200
     5.515   169.672     0.200
     5.515   169.375     0.200
     5.627   177.031     0.200
     6.685   207.578     0.200
     6.894   213.273     0.200
     7.537   233.578     0.200
     9.107   282.578     0.200
    14.031   433.836     0.200
    14.269   440.547     0.200
    15.115   472.281     0.200
    17.918   563.352     0.200
    18.572   580.594     0.200
    18.779   583.750     0.200
    20.474   633.289     0.200
     2.252    69.920     0.200
     2.239    69.920     0.200
     2.578    80.619     0.200
     2.633    81.420     0.200
     3.058    93.619     0.200
     3.359   103.619     0.200
     3.740   116.020     0.200
     4.332   133.820     0.200
     2.011    62.559     0.200
     2.269    70.762     0.200
     2.299    70.762     0.200
     2.649    81.859     0.200
     2.699    83.660     0.200
     3.060    93.762     0.200
     3.043    94.059     0.200
     3.332   102.059     0.200
     3.296   102.859     0.200
     3.767   117.461     0.200
     4.741   147.559     0.200
     4.864   150.461     0.200
     6.263   191.961     0.200
     6.281   192.262     0.200
     2.008    62.758     0.200
     2.102    66.559     0.200
     2.307    69.957     0.200
     2.307    70.656     0.200
     2.264    70.559     0.200
     2.705    83.258     0.200
     2.705    82.957     0.200
     2.648    82.758     0.200
     3.065    94.957     0.200
     3.065    95.758     0.200
     3.102    96.156     0.200
     3.102    94.457     0.200
     3.043    94.156     0.200
     3.159    97.258     0.200
     3.333   101.758     0.200
     3.296   102.359     0.200
     3.703   113.457     0.200
     3.703   112.957     0.200
     3.767   117.457     0.200
     3.767   115.656     0.200
     4.320   134.359     0.200
     4.331   134.656     0.200
     4.739   148.359     0.200
     4.866   150.656     0.200
     4.866   147.859     0.200
     5.163   158.059     0.200
     5.664   175.457     0.200
     5.774   179.258     0.200
     6.270   193.059     0.200
     6.283   194.457     0.200
     6.283   192.859     0.200
     7.131   218.957     0.200
     7.874   242.656     0.200
     7.908   244.957     0.200
     9.513   293.359     0.200
    14.344   445.066     0.200
    14.781   462.934     0.200
    17.656   553.781     0.200
    18.347   574.254     0.200
    18.918   593.609     0.200
    20.678   657.082     0.200
     2.351    72.935     0.200
     2.351    71.335     0.200
     2.447    74.734     0.200
     2.447    74.535     0.200
     2.600    80.135     0.200
     2.600    80.435     0.200
     2.687    81.835     0.200
     3.063    92.829     0.200
     3.063    93.935     0.200
     3.063    93.035     0.200
     3.246    99.535     0.200
     3.246    99.234     0.200
     3.621   111.435     0.200
     3.621   111.935     0.200
     3.643   112.035     0.200
     3.643   111.635     0.200
     3.618   109.135     0.200
     3.618   111.335     0.200
     4.008   123.035     0.200
     4.008   122.935     0.200
     4.080   127.035     0.200
     4.340   134.234     0.200
     4.519   139.435     0.200
     4.519   139.035     0.200
     4.534   139.234     0.200
     4.534   139.035     0.200
     4.970   151.335     0.200
     5.531   170.635     0.200
     5.522   173.212     0.200
     6.702   206.835     0.200
     6.963   214.935     0.200
     6.968   214.935     0.200
     7.210   222.435     0.200
     8.576   264.234     0.200
    10.223   316.135     0.200
    13.729   425.054     0.200
    14.515   447.403     0.200
    15.426   482.585     0.200
    17.641   556.172     0.200
    18.258   569.188     0.200
    20.609   639.153     0.200
     2.146    66.246     0.200
     2.685    82.645     0.200
     2.921    90.945     0.200
     2.896    89.543     0.200
     3.040    93.844     0.200
     3.158    98.344     0.200
     3.391   105.645     0.200
     3.563   110.246     0.200
     3.641   114.043     0.200
     3.975   122.543     0.200
     4.535   140.645     0.200
     5.102   159.145     0.200
     5.177   159.945     0.200
     5.480   168.445     0.200
     5.669   176.145     0.200
     6.564   202.445     0.200
     2.245    69.594     0.200
     2.251    69.891     0.200
     2.581    79.594     0.200
     2.581    79.492     0.200
     2.645    81.195     0.200
     2.771    85.297     0.200
     2.771    85.094     0.200
     2.900    90.297     0.200
     3.055    93.797     0.200
     3.055    94.391     0.200
     3.320   102.797     0.200
     3.320   102.297     0.200
     3.372   104.891     0.200
     3.372   104.992     0.200
     3.422   106.891     0.200
     3.422   108.695     0.200
     3.730   115.492     0.200
     4.090   127.195     0.200
     4.315   132.797     0.200
     4.315   132.695     0.200
     4.343   134.992     0.200
     4.343   134.797     0.200
     4.865   150.492     0.200
     4.865   150.195     0.200
     5.261   163.992     0.200
     5.606   176.414     0.200
     6.680   206.492     0.200
     6.874   212.391     0.200
     6.874   212.195     0.200
     2.040    64.418     0.200
     2.090    66.520     0.200
     2.252    70.316     0.200
     2.317    69.918     0.200
     2.317    71.316     0.200
     2.636    81.918     0.200
     2.717    83.219     0.200
     3.030    93.719     0.200
     3.077    94.918     0.200
     3.106    95.316     0.200
     3.147    98.117     0.200
     3.284   101.020     0.200
     3.346   102.520     0.200
     3.715   114.418     0.200
     3.755   115.520     0.200
     4.317   133.117     0.200
     4.319   133.816     0.200
     4.727   146.617     0.200
     5.175   159.520     0.200
     5.235   160.816     0.200
     5.654   175.219     0.200
     6.295   193.418     0.200
     6.511   199.918     0.200
     7.144   220.316     0.200
     7.669   238.020     0.200
     2.251    69.508     0.200
     2.242    69.508     0.200
     2.580    79.605     0.200
     2.636    80.906     0.200
     2.760    86.207     0.200
     2.890    89.105     0.200
     3.058    94.309     0.200
     3.333   102.809     0.200
     3.362   103.809     0.200
     3.426   106.605     0.200
     3.737   115.309     0.200
     3.936   119.207     0.200
     3.936   121.809     0.200
     4.096   127.508     0.200
     4.325   133.207     0.200
     4.336   134.605     0.200
     4.854   149.906     0.200
     5.268   161.906     0.200
     5.302   162.707     0.200
     5.527   169.906     0.200
     6.688   207.309     0.200
     6.885   212.809     0.200
     7.287   225.605     0.200
     2.248    69.602     0.200
     2.246    70.301     0.200
     2.581    79.402     0.200
     2.641    81.801     0.200
     2.765    86.703     0.200
     2.895    90.402     0.200
     3.057    94.203     0.200
     3.326   103.203     0.200
     3.367   103.902     0.200
     3.424   106.500     0.200
     3.733   115.801     0.200
     3.942   122.000     0.200
     4.094   126.102     0.200
     4.320   133.102     0.200
     4.340   135.602     0.200
     4.860   150.301     0.200
     5.264   161.902     0.200
     5.308   164.102     0.200
     5.526   169.902     0.200
     6.580   203.203     0.200
     6.684   206.301     0.200
     6.880   212.703     0.200
     7.533   231.500     0.200
     8.275   256.000     0.200
     2.059    62.543     0.200
     2.742    84.844     0.200
     2.789    85.543     0.200
     2.045    64.697     0.200
     2.156    67.297     0.200
     2.304    72.598     0.200
     2.692    82.998     0.200
     2.939    90.297     0.200
     2.001    62.242     0.200
     2.040    64.344     0.200
     2.069    65.344     0.200
     2.201    68.344     0.200
     2.290    71.945     0.200
     2.591    78.945     0.200
     2.591    81.641     0.200
     2.664    81.539     0.200
     2.980    93.242     0.200
     3.033    94.039     0.200
     3.065    92.641     0.200
     3.065    95.141     0.200
     3.228   100.641     0.200
     3.303   101.641     0.200
     3.380   103.641     0.200
     3.719   114.141     0.200
     3.690   114.242     0.200
     4.227   127.242     0.200
     4.227   131.141     0.200
     4.514   139.141     0.200
     4.703   145.344     0.200
     4.903   149.945     0.200
     5.134   157.641     0.200
     5.137   159.344     0.200
     5.523   170.844     0.200
     6.334   195.242     0.200
     6.627   203.641     0.200
     7.571   234.344     0.200
     7.952   244.742     0.200
     8.926   276.141     0.200
     9.743   299.945     0.200
     2.078    65.398     0.200
     2.393    73.996     0.200
     2.470    75.195     0.200
     2.470    76.797     0.200
     2.645    81.297     0.200
     2.645    81.098     0.200
     2.581    79.297     0.200
     2.581    79.797     0.200
     2.721    84.297     0.200
     3.168    97.996     0.200
     3.190    97.898     0.200
     3.190    98.496     0.200
     3.503   109.598     0.200
     3.503   108.496     0.200
     3.755   114.598     0.200
     3.755   113.996     0.200
     3.755   116.598     0.200
     3.894   121.695     0.200
     3.894   119.898     0.200
     4.185   130.398     0.200
     4.424   136.297     0.200
     4.424   136.398     0.200
     4.672   143.195     0.200
     4.672   144.195     0.200
     5.420   166.996     0.200
     5.548   175.332     0.200
     5.642   174.195     0.200
     6.847   212.695     0.200
     7.069   217.996     0.200
    10.236   317.297     0.200
     2.279    70.494     0.200
     2.409    75.594     0.200
     2.534    78.795     0.200
     2.595    80.693     0.200
     3.572   109.094     0.200
     2.187    69.184     0.200
     2.610    80.684     0.200
     2.704    84.086     0.200
     2.835    88.883     0.200
     3.100    96.086     0.200
     3.469   108.086     0.200
     3.378   105.086     0.200
     3.790   117.484     0.200
     3.879   121.484     0.200
     4.284   133.785     0.200
     4.344   134.484     0.200
     4.797   148.984     0.200
     5.320   165.285     0.200
     5.570   172.086     0.200
     5.577   175.273     0.200
     6.613   205.086     0.200
     6.741   208.684     0.200
     6.942   214.184     0.200
     7.231   225.184     0.200
     7.592   234.184     0.200
     8.335   257.684     0.200
    14.002   432.883     0.200
     2.141    65.420     0.200
     2.349    72.420     0.200
     2.488    75.719     0.200
     2.488    76.119     0.200
     2.742    84.320     0.200
     2.860    87.020     0.200
     2.952    90.119     0.200
     2.996    91.619     0.200
     3.319   102.320     0.200
     3.319   102.920     0.200
     3.289   100.820     0.200
     3.289   100.520     0.200
     3.466   105.920     0.200
     3.466   104.920     0.200
     3.628   111.020     0.200
     3.987   123.520     0.200
     4.033   123.320     0.200
     4.033   122.020     0.200
     4.345   133.619     0.200
     4.345   132.320     0.200
     4.445   137.719     0.200
     4.445   137.420     0.200
     4.950   152.020     0.200
     5.159   159.320     0.200
     5.420   165.719     0.200
     5.385   166.820     0.200
     5.702   179.719     0.200
     6.482   199.820     0.200
     6.580   203.020     0.200
     6.792   208.520     0.200
     7.430   230.619     0.200
     8.790   271.320     0.200
     9.813   303.619     0.200
     9.960   306.219     0.200
    14.167   436.238     0.200
    18.059   570.281     0.200
     2.319    71.226     0.200
     2.462    76.325     0.200
     2.574    78.726     0.200
     2.574    78.125     0.200
     2.575    79.825     0.200
     2.852    87.325     0.200
     2.852    87.426     0.200
     3.051    94.625     0.200
     3.367   104.125     0.200
     3.497   109.226     0.200
     3.497   107.025     0.200
     3.643   111.426     0.200
     3.643   110.726     0.200
     3.738   114.426     0.200
     3.738   116.426     0.200
     4.060   125.226     0.200
     4.060   124.125     0.200
     4.012   125.025     0.200
     4.012   124.226     0.200
     4.303   131.926     0.200
     4.419   136.825     0.200
     4.564   139.525     0.200
     4.564   138.726     0.200
     5.048   155.825     0.200
     5.340   164.994     0.200
     5.592   173.125     0.200
     5.839   179.325     0.200
     6.863   212.525     0.200
     7.011   216.226     0.200
     7.174   221.926     0.200
     7.858   244.525     0.200
     8.595   266.625     0.200
     8.891   274.926     0.200
    10.223   316.726     0.200
    10.378   319.825     0.200
    13.864   430.395     0.200
    17.693   553.457     0.200
     2.326    71.730     0.200
     2.467    75.930     0.200
     2.565    79.230     0.200
     2.582    80.027     0.200
     3.057    94.430     0.200
     3.358   103.328     0.200
     3.498   108.027     0.200
     3.647   111.027     0.200
     3.647   112.328     0.200
     3.647   115.027     0.200
     3.729   115.527     0.200
     4.053   124.230     0.200
     4.020   125.730     0.200
     4.310   131.930     0.200
     4.310   134.527     0.200
     4.411   137.129     0.200
     4.568   139.230     0.200
     4.568   142.027     0.200
     5.050   156.828     0.200
     5.584   172.828     0.200
     5.830   179.730     0.200
     7.003   216.828     0.200
     7.169   220.930     0.200
     7.851   241.930     0.200
     8.589   266.129     0.200
     8.892   275.730     0.200
    10.217   317.230     0.200
    10.371   319.430     0.200
     2.080    66.922     0.200
     2.269    70.023     0.200
     2.618    81.320     0.200
     2.696    82.922     0.200
     3.010    93.625     0.200
     3.116    95.125     0.200
     3.116    97.820     0.200
     2.039    63.926     0.200
     2.103    64.426     0.200
     2.260    70.525     0.200
     2.781    84.926     0.200
     2.916    89.125     0.200
     3.034    93.426     0.200
     3.270   100.426     0.200
     3.283   100.926     0.200
     3.504   107.826     0.200
     3.590   109.725     0.200
     3.948   121.426     0.200
     4.070   122.725     0.200
     4.070   125.525     0.200
     4.348   133.025     0.200
     4.484   138.926     0.200
     4.986   153.625     0.200
     5.120   158.225     0.200
     5.384   165.625     0.200
     5.417   166.926     0.200
     6.541   201.225     0.200
     6.757   206.926     0.200
     2.240    70.094     0.200
     2.248    70.289     0.200
     2.557    79.789     0.200
     2.641    81.891     0.200
     2.761    86.492     0.200
     2.895    91.391     0.200
     3.043    94.492     0.200
     3.347   103.289     0.200
     3.366   104.594     0.200
     3.729   116.195     0.200
     3.936   122.492     0.200
     4.086   127.094     0.200
     4.347   134.289     0.200
     4.345   135.789     0.200
     4.854   150.594     0.200
     5.259   161.695     0.200
     5.296   164.594     0.200
     5.513   170.195     0.200
     6.561   203.195     0.200
     6.681   207.195     0.200
     6.887   212.594     0.200
     8.275   254.992     0.200
     2.428    75.312     0.200
     2.426    75.516     0.200
     2.528    79.117     0.200
     2.644    81.117     0.200
     2.675    83.117     0.200
     3.141    96.617     0.200
     3.141    97.812     0.200
     3.189    99.117     0.200
     3.563   110.219     0.200
     3.570   111.312     0.200
     3.699   115.117     0.200
     3.935   122.117     0.200
     4.149   129.914     0.200
     4.479   138.719     0.200
     4.615   141.914     0.200
     5.052   157.812     0.200
     5.459   169.414     0.200
     5.663   174.812     0.200
     6.661   206.016     0.200
     6.889   213.719     0.200
     7.128   220.914     0.200
     7.746   240.117     0.200
     8.498   262.016     0.200
    10.286   316.812     0.200
     2.272    68.602     0.200
     2.234    68.402     0.200
     2.273    69.504     0.200
     2.609    81.305     0.200
     2.602    79.102     0.200
     2.831    86.004     0.200
     2.914    89.504     0.200
     3.265   101.203     0.200
     3.301   101.805     0.200
     3.738   116.203     0.200
     3.812   116.402     0.200
     3.883   120.402     0.200
     4.085   126.305     0.200
     4.370   136.805     0.200
     4.634   142.805     0.200
     4.962   153.004     0.200
     4.940   154.004     0.200
     5.305   164.203     0.200
     5.380   165.004     0.200
     5.901   183.004     0.200
     6.286   193.203     0.200
     6.758   208.902     0.200
     7.182   220.703     0.200
     8.427   260.602     0.200
     8.685   268.402     0.200
    10.225   315.402     0.200
     2.265    69.074     0.200
     2.202    69.375     0.200
     2.487    77.074     0.200
     2.755    84.574     0.200
     2.876    88.875     0.200
     3.131    96.973     0.200
     2.961    90.672     0.200
     2.961    90.375     0.200
     3.124    96.172     0.200
     3.363   103.273     0.200
     3.483   107.875     0.200
     3.585   110.473     0.200
     3.820   117.973     0.200
     4.123   126.875     0.200
     4.520   138.273     0.200
     5.006   155.672     0.200
     5.034   154.172     0.200
     5.226   160.773     0.200
     5.802   180.875     0.200
     5.919   185.172     0.200
     5.948   188.410     0.200
     6.438   197.773     0.200
     6.727   207.574     0.200
     7.298   224.672     0.200
     8.057   248.473     0.200
     8.167   252.375     0.200
     9.847   304.375     0.200
    13.997   430.691     0.200
    14.082   439.773     0.200
    17.918   562.723     0.200
    18.117   567.051     0.200
    18.664   584.305     0.200
    20.180   628.543     0.200
    20.917   659.625     0.200
    23.643   734.969     0.200
    24.373   761.348     0.200
     2.217    69.453     0.200
     2.251    69.055     0.200
     2.405    76.055     0.200
     2.503    77.156     0.200
     2.739    83.953     0.200
     2.892    89.656     0.200
     2.976    91.156     0.200
     3.140    97.453     0.200
     3.357   103.055     0.200
     3.467   105.953     0.200
     3.601   111.156     0.200
     3.804   118.156     0.200
     4.138   127.352     0.200
     4.523   139.055     0.200
     4.618   143.156     0.200
     4.990   152.055     0.200
     5.049   155.453     0.200
     5.210   161.055     0.200
     5.438   168.156     0.200
     6.422   198.453     0.200
     6.714   206.852     0.200
     8.041   248.250     0.200
     9.832   303.055     0.200
     2.265    68.672     0.200
     2.265    70.477     0.200
     2.481    76.773     0.200
     2.758    84.375     0.200
     2.869    88.078     0.200
     2.953    90.773     0.200
     3.134    96.273     0.200
     3.117    96.078     0.200
     3.373   103.477     0.200
     3.490   106.578     0.200
     3.577   109.977     0.200
     3.825   118.672     0.200
     4.115   127.273     0.200
     4.528   139.172     0.200
     4.596   143.078     0.200
     5.012   154.977     0.200
     5.025   154.578     0.200
     5.230   160.578     0.200
     5.415   166.977     0.200
     6.268   193.672     0.200
     6.445   199.078     0.200
     6.737   207.977     0.200
     8.065   249.273     0.200
     2.251    69.391     0.200
     2.251    69.793     0.200
     2.110    67.094     0.200
     2.234    69.691     0.200
     2.234    70.293     0.200
     2.627    81.492     0.200
     2.627    80.992     0.200
     2.746    84.891     0.200
     2.880    88.793     0.200
     3.052    94.293     0.200
     3.362   103.691     0.200
     3.351   103.594     0.200
     3.742   115.391     0.200
     3.920   120.594     0.200
     4.332   134.594     0.200
     4.332   135.691     0.200
     4.356   133.391     0.200
     4.356   133.191     0.200
     4.838   148.293     0.200
     4.838   149.793     0.200
     5.272   162.293     0.200
     5.280   162.594     0.200
     5.522   169.594     0.200
     5.622   177.371     0.200
     6.567   202.391     0.200
     6.694   206.992     0.200
     6.903   213.391     0.200
     7.545   233.492     0.200
     8.290   257.293     0.200
     8.527   264.391     0.200
     9.099   281.594     0.200
    10.075   311.191     0.200
    14.024   438.266     0.200
    14.277   444.387     0.200
    17.950   563.766     0.200
    20.479   638.211     0.200
     2.190    67.394     0.200
     2.285    71.894     0.200
     2.485    75.694     0.200
     2.677    83.894     0.200
     2.784    85.394     0.200
     2.980    91.794     0.200
     2.928    91.394     0.200
     3.356   101.894     0.200
     3.380   104.494     0.200
     3.396   105.194     0.200
     3.687   113.794     0.200
     3.687   112.694     0.200
     3.955   122.294     0.200
     4.390   136.794     0.200
     4.412   137.194     0.200
     4.871   150.394     0.200
     5.214   160.494     0.200
     5.297   163.494     0.200
     5.452   166.894     0.200
     5.587   173.394     0.200
     6.640   204.294     0.200
     6.874   212.094     0.200
     7.305   226.194     0.200
     7.545   232.994     0.200
     8.244   254.194     0.200
     9.108   282.494     0.200
     2.114    66.687     0.200
     2.267    70.187     0.200
     2.316    71.387     0.200
     2.389    74.387     0.200
     2.534    78.087     0.200
     2.642    80.787     0.200
     2.585    80.787     0.200
     2.961    91.387     0.200
     3.091    96.487     0.200
     3.748   116.687     0.200
     4.071   124.387     0.200
     4.227   131.587     0.200
     4.817   148.587     0.200
     4.934   151.187     0.200
     5.142   160.087     0.200
     5.736   178.687     0.200
     5.888   181.487     0.200
     6.003   184.287     0.200
     6.160   191.187     0.200
     6.175   192.087     0.200
     6.716   206.187     0.200
     7.432   228.287     0.200
     8.169   252.787     0.200
     2.180    66.488     0.200
     2.180    67.891     0.200
     2.221    69.691     0.200
     2.316    72.191     0.200
     2.401    73.988     0.200
     2.476    77.590     0.200
     2.595    82.691     0.200
     2.712    82.488     0.200
     2.686    84.191     0.200
     2.863    88.090     0.200
     3.158    98.289     0.200
     3.811   118.391     0.200
     4.195   128.789     0.200
     4.861   149.691     0.200
     5.799   178.988     0.200
     5.778   179.090     0.200
     5.967   183.191     0.200
     6.194   192.090     0.200
     2.217    68.242     0.200
     2.217    68.945     0.200
     2.241    69.547     0.200
     2.375    72.445     0.200
     2.375    72.945     0.200
     2.625    81.344     0.200
     2.625    81.047     0.200
     2.686    83.047     0.200
     2.686    82.742     0.200
     2.867    88.547     0.200
     2.941    90.547     0.200
     2.941    90.742     0.200
     3.323   102.047     0.200
     3.320   101.445     0.200
     3.320   101.242     0.200
     3.320   102.844     0.200
     3.617   112.344     0.200
     3.740   115.242     0.200
     3.740   115.742     0.200
     3.842   116.844     0.200
     3.842   120.242     0.200
     4.054   126.047     0.200
     4.368   136.742     0.200
     4.368   136.844     0.200
     4.659   142.844     0.200
     4.659   143.844     0.200
     4.750   145.945     0.200
     4.750   146.945     0.200
     5.132   158.344     0.200
     5.132   158.648     0.200
     5.254   163.445     0.200
     5.415   168.148     0.200
     5.727   178.445     0.200
     5.823   181.883     0.200
     6.393   198.148     0.200
     6.694   207.148     0.200
     7.184   222.047     0.200
     7.368   227.844     0.200
     8.415   260.844     0.200
     8.921   276.648     0.200
    13.802   428.805     0.200
    14.223   437.938     0.200
    18.482   577.094     0.200
    20.301   629.711     0.200
     2.194    68.912     0.200
     2.331    72.612     0.200
     2.449    76.912     0.200
     2.683    82.112     0.200
     2.914    90.612     0.200
     2.923    90.812     0.200
     3.459   107.412     0.200
     3.511   109.212     0.200
     3.615   111.512     0.200
     3.838   118.912     0.200
     3.897   122.212     0.200
     4.178   129.212     0.200
     4.368   135.812     0.200
     4.432   138.112     0.200
     4.917   152.912     0.200
     5.199   162.112     0.200
     5.707   175.812     0.200
     5.933   183.212     0.200
     6.863   213.412     0.200
     7.130   220.212     0.200
     7.306   226.112     0.200
     8.277   257.912     0.200
     8.763   271.212     0.200
     2.209    68.273     0.200
     2.263    70.078     0.200
     2.263    69.578     0.200
     2.448    75.273     0.200
     2.635    81.078     0.200
     2.635    81.273     0.200
     2.704    82.273     0.200
     2.704    81.875     0.200
     2.898    88.977     0.200
     2.898    88.477     0.200
     3.327   101.773     0.200
     3.421   105.773     0.200
     3.421   106.078     0.200
     3.712   114.578     0.200
     3.896   121.273     0.200
     3.964   123.180     0.200
     4.162   126.875     0.200
     4.162   128.773     0.200
     4.331   133.078     0.200
     4.331   133.273     0.200
     4.467   136.875     0.200
     4.735   146.977     0.200
     5.490   170.477     0.200
     5.559   175.914     0.200
     5.673   175.078     0.200
     6.719   207.375     0.200
     6.765   209.180     0.200
     7.115   219.477     0.200
     7.425   229.375     0.200
     7.988   248.078     0.200
     8.520   263.250     0.200
    10.545   325.477     0.200
     2.424    74.586     0.200
     2.575    80.684     0.200
     2.575    80.484     0.200
     2.640    81.383     0.200
     2.640    81.586     0.200
     2.817    87.383     0.200
     2.992    92.984     0.200
     2.992    93.086     0.200
     3.272   100.301     0.200
     3.375   105.383     0.200
     3.630   111.285     0.200
     3.630   113.285     0.200
     3.789   117.086     0.200
     3.797   116.086     0.200
     4.105   128.285     0.200
     4.317   135.383     0.200
     4.646   144.184     0.200
     5.096   158.086     0.200
     5.304   163.684     0.200
     5.467   168.484     0.200
     5.683   177.883     0.200
     5.777   182.605     0.200
     6.743   208.785     0.200
     7.058   218.184     0.200
     8.269   258.133     0.200
     8.426   261.984     0.200
    15.352   481.078     0.200
     2.282    70.680     0.200
     2.419    75.281     0.200
     2.537    78.578     0.200
     2.601    80.281     0.200
     2.855    88.680     0.200
     3.012    93.281     0.200
     3.385   104.875     0.200
     3.546   108.578     0.200
     3.599   110.477     0.200
     3.981   124.477     0.200
     4.092   125.781     0.200
     4.341   133.281     0.200
     4.520   140.180     0.200
     5.000   155.875     0.200
     2.576    80.219     0.200
     2.640    82.117     0.200
     2.640    81.820     0.200
     2.818    87.719     0.200
     2.990    90.719     0.200
     2.990    92.219     0.200
     3.272   101.039     0.200
     3.373   103.719     0.200
     3.633   113.117     0.200
     3.788   116.422     0.200
     3.788   117.016     0.200
     4.319   134.320     0.200
     4.319   134.516     0.200
     4.650   143.422     0.200
     4.650   144.516     0.200
     4.706   145.219     0.200
     5.095   158.117     0.200
     5.303   164.617     0.200
     5.465   168.320     0.200
     5.686   177.617     0.200
     5.780   183.367     0.200
     6.440   199.320     0.200
     6.743   208.516     0.200
     7.140   220.320     0.200
     8.268   257.320     0.200
     8.272   259.141     0.200
     8.429   261.719     0.200
    10.168   315.219     0.200
    13.776   429.117     0.200
    14.272   441.688     0.200
    18.503   577.969     0.200
    20.347   633.688     0.200
     2.018    64.199     0.200
     2.199    68.898     0.200
     2.259    69.797     0.200
     2.408    72.996     0.200
     2.582    79.699     0.200
     2.644    81.398     0.200
     2.824    86.996     0.200
     2.980    91.398     0.200
     3.278   100.398     0.200
     3.363   104.398     0.200
     3.642   114.098     0.200
     4.327   134.996     0.200
     4.663   144.898     0.200
     4.708   144.797     0.200
     5.297   164.598     0.200
     5.454   167.496     0.200
     2.020    63.734     0.200
     2.125    66.035     0.200
     2.362    72.336     0.200
     2.362    73.934     0.200
     2.465    76.035     0.200
     2.465    76.434     0.200
     2.755    86.234     0.200
     2.870    88.137     0.200
     2.870    88.035     0.200
     2.935    90.234     0.200
     3.008    92.934     0.200
     3.008    93.535     0.200
     3.292   101.934     0.200
     3.292   101.434     0.200
     3.308   103.234     0.200
     3.308   103.336     0.200
     3.478   105.930     0.200
     3.478   106.836     0.200
     3.478   108.137     0.200
     3.614   111.234     0.200
     3.614   111.434     0.200
     3.971   123.637     0.200
     4.043   124.234     0.200
     4.043   124.734     0.200
     4.357   135.836     0.200
     4.960   153.336     0.200
     5.144   160.336     0.200
     5.601   175.137     0.200
     5.720   177.613     0.200
     6.784   210.234     0.200
     7.417   230.934     0.200
     7.393   229.137     0.200
     7.638   236.535     0.200
     7.930   244.836     0.200
     8.087   250.836     0.200
     8.162   252.535     0.200
     8.606   267.734     0.200
     8.796   271.637     0.200
    14.151   436.379     0.200
    14.111   439.590     0.200
    17.752   557.969     0.200
    17.855   558.137     0.200
    18.664   584.465     0.200
    18.751   584.059     0.200
     2.039    64.609     0.200
     2.233    69.211     0.200
     2.226    69.109     0.200
     2.388    73.309     0.200
     2.609    80.410     0.200
     2.670    82.008     0.200
     2.956    91.008     0.200
     2.851    88.008     0.200
     3.338   102.711     0.200
     3.304   100.297     0.200
     3.626   112.508     0.200
     3.626   113.309     0.200
     3.756   115.309     0.200
     4.353   135.508     0.200
     4.661   144.309     0.200
     4.661   143.410     0.200
     4.734   145.711     0.200
     5.118   158.109     0.200
     5.270   163.211     0.200
     5.430   166.508     0.200
     5.812   179.336     0.200
     8.266   257.078     0.200
    13.790   424.992     0.200
     2.019    63.102     0.200
     2.455    76.500     0.200
     2.528    78.500     0.200
     2.664    81.500     0.200
     2.701    83.500     0.200
     3.133    96.297     0.200
     3.232    99.703     0.200
     3.521   109.297     0.200
     3.610   111.102     0.200
     3.954   122.703     0.200
     4.123   128.500     0.200
     4.406   136.297     0.200
     4.622   141.797     0.200
     5.075   156.500     0.200
     2.071    64.273     0.200
     2.179    67.969     0.200
     2.320    72.070     0.200
     2.779    85.875     0.200
     2.787    85.516     0.200
     2.929    89.969     0.200
     3.354   102.773     0.200
     3.517   108.375     0.200
     3.803   119.469     0.200
     3.799   119.070     0.200
     3.899   120.469     0.200
     4.289   133.875     0.200
     4.273   131.469     0.200
     4.530   140.070     0.200
     4.621   143.469     0.200
     4.740   146.570     0.200
     5.309   165.992     0.200
     8.407   261.547     0.200
    13.556   421.727     0.200
     2.211    69.273     0.200
     2.321    72.375     0.200
     2.461    76.977     0.200
     2.644    81.977     0.200
     2.829    87.273     0.200
     2.929    90.422     0.200
     2.929    90.773     0.200
     3.396   105.773     0.200
     3.497   108.875     0.200
     3.690   114.375     0.200
     3.777   116.977     0.200
     3.933   122.578     0.200
     4.151   129.078     0.200
     4.415   137.273     0.200
     4.488   139.578     0.200
     4.875   151.375     0.200
     5.385   168.555     0.200
     8.303   259.250     0.200
    15.500   481.867     0.200
     2.070    63.363     0.200
     2.118    66.262     0.200
     2.334    71.562     0.200
     2.391    74.262     0.200
     2.779    85.863     0.200
     2.841    87.160     0.200
     2.864    88.363     0.200
     3.027    93.262     0.200
     3.219    98.461     0.200
     3.417   105.262     0.200
     3.488   108.660     0.200
     3.580   109.562     0.200
     3.915   121.562     0.200
     4.028   124.961     0.200
     4.523   139.461     0.200
     4.506   139.762     0.200
     4.939   152.160     0.200
     5.314   163.262     0.200
     5.336   165.062     0.200
     2.093    66.680     0.200
     2.237    70.180     0.200
     2.275    70.281     0.200
     2.631    81.086     0.200
     2.632    81.281     0.200
     2.769    86.281     0.200
     2.889    90.383     0.200
     3.097    95.586     0.200
     3.281   100.984     0.200
     3.364   101.875     0.200
     3.364   104.781     0.200
     3.469   107.680     0.200
     4.120   128.883     0.200
     4.255   131.586     0.200
     4.321   134.484     0.200
     4.868   149.781     0.200
     5.285   164.180     0.200
     5.329   165.484     0.200
     5.436   169.086     0.200
     7.912   242.828     0.200
     2.054    63.188     0.200
     2.054    65.588     0.200
     2.209    70.088     0.200
     2.359    73.287     0.200
     2.604    81.588     0.200
     2.762    85.688     0.200
     2.999    93.387     0.200
     3.095    95.088     0.200
     3.128    97.488     0.200
     3.121    98.088     0.200
     3.253   100.988     0.200
     3.382   103.988     0.200
     3.756   115.287     0.200
     3.726   115.787     0.200
     4.283   131.787     0.200
     4.295   133.588     0.200
     4.691   146.088     0.200
     4.916   151.787     0.200
     5.219   160.188     0.200
     5.212   161.088     0.200
     2.027    63.465     0.200
     2.063    63.367     0.200
     2.297    70.566     0.200
     2.301    71.965     0.200
     2.341    72.766     0.200
     2.534    78.766     0.200
     2.759    86.367     0.200
     2.794    86.066     0.200
     3.197    99.266     0.200
     3.847   118.664     0.200
     4.310   133.066     0.200
     4.337   133.164     0.200
     4.715   144.465     0.200
     4.879   149.266     0.200
     2.255    70.244     0.200
     2.400    74.545     0.200
     2.512    77.844     0.200
     2.635    80.943     0.200
     2.897    89.645     0.200
     2.988    92.545     0.200
     3.425   105.344     0.200
     3.541   109.645     0.200
     3.582   110.145     0.200
     3.582   111.443     0.200
     3.949   124.045     0.200
     4.313   131.145     0.200
     4.313   132.744     0.200
     4.481   138.844     0.200
     4.503   138.045     0.200
     4.503   139.344     0.200
     4.992   155.645     0.200
     5.201   162.545     0.200
     2.218    68.660     0.200
     2.329    72.562     0.200
     2.469    76.363     0.200
     2.636    81.562     0.200
     2.823    86.660     0.200
     2.937    90.461     0.200
     3.389   104.863     0.200
     3.504   107.961     0.200
     3.685   114.363     0.200
     3.940   123.363     0.200
     4.038   124.762     0.200
     4.143   127.961     0.200
     4.422   136.363     0.200
     4.480   139.262     0.200
     4.480   138.863     0.200
     4.881   150.863     0.200
     5.307   164.961     0.200
     2.227    68.859     0.200
     2.227    68.660     0.200
     2.137    66.660     0.200
     2.272    70.561     0.200
     2.570    78.959     0.200
     2.666    82.859     0.200
     2.794    85.260     0.200
     2.794    86.160     0.200
     2.921    89.660     0.200
     2.921    91.160     0.200
     3.042    93.260     0.200
     3.298   100.660     0.200
     3.415   103.959     0.200
     3.394   104.252     0.200
     3.394   105.959     0.200
     3.710   114.459     0.200
     4.073   126.160     0.200
     3.970   123.459     0.200
     4.302   132.959     0.200
     4.363   135.359     0.200
     5.242   161.760     0.200
     5.497   171.359     0.200
     5.510   169.561     0.200
     6.660   204.561     0.200
     6.851   210.561     0.200
     7.932   244.410     0.200
    14.087   440.084     0.200
    15.061   466.428     0.200
    18.823   586.436     0.200
    20.482   636.178     0.200
     2.122    65.141     0.200
     2.150    65.938     0.200
     2.150    66.141     0.200
     2.354    72.141     0.200
     2.354    72.242     0.200
     2.740    84.141     0.200
     2.735    83.242     0.200
     2.795    84.836     0.200
     3.298   102.141     0.200
     3.396   104.336     0.200
     3.782   117.039     0.200
     3.836   117.836     0.200
     3.889   119.938     0.200
     3.889   119.742     0.200
     4.047   126.039     0.200
     4.047   125.938     0.200
     4.268   131.336     0.200
     4.204   128.742     0.200
     4.558   140.141     0.200
     4.595   142.438     0.200
     4.859   150.438     0.200
     5.517   172.539     0.200
     2.191    67.602     0.200
     2.303    72.602     0.200
     2.532    78.000     0.200
     2.698    84.102     0.200
     2.820    87.500     0.200
     2.952    91.102     0.200
     3.003    92.500     0.200
     3.297   102.000     0.200
     3.423   106.102     0.200
     3.676   113.297     0.200
     3.995   124.398     0.200
     4.036   125.797     0.200
     4.323   133.102     0.200
     4.397   136.703     0.200
     4.913   152.500     0.200
     5.207   160.203     0.200
     5.355   166.500     0.200
     2.280    70.320     0.200
     2.423    75.320     0.200
     2.536    78.320     0.200
     2.610    80.422     0.200
     2.875    88.922     0.200
     3.012    93.621     0.200
     3.400   105.219     0.200
     3.974   124.219     0.200
     4.134   128.121     0.200
     4.314   133.219     0.200
     4.525   137.922     0.200
     4.525   139.719     0.200
     5.011   155.520     0.200
     5.220   161.922     0.200
     2.171    67.699     0.200
     2.307    70.500     0.200
     2.589    79.000     0.200
     2.563    79.898     0.200
     2.678    82.801     0.200
     2.816    87.000     0.200
     3.096    95.000     0.200
     3.285   102.199     0.200
     3.423   105.199     0.200
     3.852   119.102     0.200
     4.273   132.199     0.200
     4.386   136.398     0.200
     4.769   147.102     0.200
     5.210   161.102     0.200
     5.331   164.699     0.200
     5.488   170.500     0.200
     2.142    67.283     0.200
     2.261    70.385     0.200
     2.266    70.885     0.200
     2.488    76.584     0.200
     2.609    80.684     0.200
     2.686    81.684     0.200
     3.356   103.783     0.200
     3.495   108.584     0.200
     3.753   116.084     0.200
     4.127   127.385     0.200
     4.231   130.584     0.200
     4.477   138.584     0.200
     4.814   149.084     0.200
     5.732   177.484     0.200
     2.196    67.699     0.200
     2.334    72.199     0.200
     2.451    75.500     0.200
     2.684    83.602     0.200
     2.920    90.102     0.200
     2.926    90.000     0.200
     3.462   106.699     0.200
     3.516   108.902     0.200
     3.516   110.602     0.200
     3.607   112.500     0.200
     3.896   121.000     0.200
     4.046   125.199     0.200
     4.178   129.199     0.200
     4.358   134.801     0.200
     4.437   137.301     0.200
     4.924   153.199     0.200
     5.191   160.902     0.200
     2.092    64.109     0.200
     2.092    64.414     0.200
     2.333    71.008     0.200
     2.333    70.812     0.200
     2.309    71.711     0.200
     2.497    78.109     0.200
     2.608    82.414     0.200
     2.680    81.711     0.200
     2.721    85.711     0.200
     2.793    85.711     0.200
     2.793    84.211     0.200
     2.836    86.211     0.200
     3.010    94.609     0.200
     3.163    98.711     0.200
     3.163    98.414     0.200
     3.235   100.008     0.200
     3.558   110.109     0.200
     3.678   114.211     0.200
     3.813   117.812     0.200
     4.289   130.914     0.200
     4.289   131.109     0.200
     4.286   132.406     0.200
     4.374   134.211     0.200
     4.753   145.312     0.200
     4.849   148.812     0.200
     6.146   191.109     0.200
     6.262   195.555     0.200
     7.416   231.062     0.200
    14.774   462.383     0.200
     2.190    67.670     0.200
     2.276    70.070     0.200
     2.276    71.270     0.200
     2.456    75.971     0.200
     2.667    83.471     0.200
     2.764    86.770     0.200
     2.916    88.971     0.200
     2.916    90.270     0.200
     2.967    90.971     0.200
     3.381   103.369     0.200
     3.381   104.869     0.200
     3.431   105.770     0.200
     3.694   113.971     0.200
     3.932   119.070     0.200
     3.932   121.471     0.200
     4.387   135.369     0.200
     4.468   137.070     0.200
     4.468   138.770     0.200
     4.846   149.471     0.200
     5.219   160.170     0.200
     5.263   163.971     0.200
     2.269    70.445     0.200
     2.361    74.145     0.200
     2.516    77.547     0.200
     2.576    79.445     0.200
     2.734    83.746     0.200
     2.979    92.445     0.200
     3.313   101.645     0.200
     3.530   108.945     0.200
     3.717   115.746     0.200
     4.002   124.945     0.200
     4.090   126.645     0.200
     4.418   135.844     0.200
     4.446   137.645     0.200
     4.557   141.645     0.200
     4.883   150.547     0.200
     2.193    67.594     0.200
     2.193    68.094     0.200
     2.299    71.094     0.200
     2.299    71.395     0.200
     2.443    75.594     0.200
     2.443    76.195     0.200
     2.657    81.895     0.200
     2.657    81.695     0.200
     2.828    86.496     0.200
     2.909    89.887     0.200
     3.403   105.496     0.200
     3.403   104.695     0.200
     3.721   116.793     0.200
     3.721   113.996     0.200
     3.784   117.395     0.200
     3.920   122.496     0.200
     4.007   124.895     0.200
     4.167   128.594     0.200
     4.391   135.594     0.200
     4.500   139.395     0.200
     4.510   138.395     0.200
     4.846   149.695     0.200
     5.311   164.996     0.200
     5.392   169.480     0.200
     7.020   217.219     0.200
     8.334   258.871     0.200
     2.217    67.652     0.200
     2.217    68.453     0.200
     2.261    68.652     0.200
     2.173    68.652     0.200
     2.270    70.652     0.200
     2.270    70.053     0.200
     2.643    81.354     0.200
     2.643    81.754     0.200
     2.665    81.553     0.200
     2.665    83.354     0.200
     2.881    88.754     0.200
     2.881    88.953     0.200
     2.876    87.854     0.200
     3.267   100.854     0.200
     3.315   102.453     0.200
     3.753   114.854     0.200
     3.753   115.453     0.200
     3.797   117.754     0.200
     3.797   117.953     0.200
     3.801   117.152     0.200
     3.801   114.854     0.200
     3.801   117.953     0.200
     4.037   125.453     0.200
     4.340   133.854     0.200
     4.406   137.254     0.200
     4.699   145.152     0.200
     4.869   152.053     0.200
     4.869   150.053     0.200
     5.253   162.152     0.200
     5.350   164.854     0.200
     5.882   182.953     0.200
     5.967   184.559     0.200
     6.451   199.178     0.200
     7.105   220.652     0.200
     8.439   262.402     0.200
    13.650   422.828     0.200
    18.244   568.889     0.200
     2.186    67.453     0.200
     2.284    70.253     0.200
     2.434    75.353     0.200
     2.661    81.853     0.200
     2.816    85.953     0.200
     2.898    90.321     0.200
     2.898    89.553     0.200
     3.399   104.353     0.200
     3.457   108.053     0.200
     3.751   116.053     0.200
     3.781   116.153     0.200
     3.917   121.853     0.200
     3.991   123.453     0.200
     4.173   128.453     0.200
     4.374   134.853     0.200
     4.543   140.753     0.200
     4.503   139.053     0.200
     4.823   148.953     0.200
     5.332   165.453     0.200
     5.411   168.453     0.200
     7.008   217.528     0.200
     8.365   258.851     0.200
    13.612   423.253     0.200
     2.079    63.883     0.200
     2.106    65.982     0.200
     2.348    72.082     0.200
     2.383    75.182     0.200
     2.772    87.281     0.200
     2.853    88.082     0.200
     2.860    89.582     0.200
     3.020    93.781     0.200
     3.409   104.383     0.200
     3.482   108.383     0.200
     3.588   110.582     0.200
     4.024   124.781     0.200
     4.497   139.781     0.200
     4.510   140.281     0.200
     4.561   140.781     0.200
     4.936   152.582     0.200
     5.110   157.482     0.200
     5.326   164.082     0.200
     5.336   164.883     0.200
     2.065    63.891     0.200
     2.120    67.195     0.200
     2.335    71.695     0.200
     2.300    73.289     0.200
     2.397    74.492     0.200
     2.839    88.289     0.200
     2.839    88.094     0.200
     2.786    86.891     0.200
     2.873    88.391     0.200
     3.034    93.789     0.200
     3.216    98.891     0.200
     3.406   104.492     0.200
     3.406   104.195     0.200
     3.574   110.195     0.200
     3.495   106.461     0.200
     3.495   107.492     0.200
     3.909   121.492     0.200
     4.036   124.695     0.200
     4.514   139.094     0.200
     4.514   138.094     0.200
     4.512   141.695     0.200
     4.573   140.289     0.200
     4.948   151.992     0.200
     5.096   155.695     0.200
     5.311   163.789     0.200
     5.736   178.695     0.200
     5.848   182.734     0.200
     6.809   210.695     0.200
     2.401    74.164     0.200
     2.451    76.062     0.200
     2.550    79.664     0.200
     2.700    84.164     0.200
     3.161    97.664     0.200
     3.165    97.762     0.200
     3.565   110.363     0.200
     3.720   112.961     0.200
     3.720   116.664     0.200
     3.909   121.762     0.200
     4.175   130.562     0.200
     4.245   131.762     0.200
     2.006    62.805     0.200
     2.110    65.906     0.200
     2.602    79.602     0.200
     2.502    77.602     0.200
     2.608    80.703     0.200
     2.752    85.703     0.200
     3.130    97.008     0.200
     3.219    98.477     0.200
     3.219    99.805     0.200
     3.501   108.508     0.200
     3.860   119.805     0.200
     3.780   117.406     0.200
     5.586   173.586     0.200
     6.794   210.930     0.200
     8.132   251.531     0.200
    13.879   430.031     0.200
    18.416   580.008     0.200
    18.721   583.680     0.200
    20.527   639.320     0.200
     2.502    77.488     0.200
     2.534    78.389     0.200
     2.649    82.389     0.200
     2.793    86.189     0.200
     3.125    95.383     0.200
     3.125    96.590     0.200
     3.301   101.889     0.200
     3.447   107.090     0.200
     3.677   113.789     0.200
     3.987   123.189     0.200
     5.392   167.791     0.200
     6.984   217.320     0.200
     8.063   252.564     0.200
    13.916   431.527     0.200
     2.211    67.793     0.200
     2.211    68.195     0.200
     2.323    70.395     0.200
     2.323    71.293     0.200
     2.462    75.793     0.200
     2.645    81.793     0.200
     2.834    87.395     0.200
     2.930    89.438     0.200
     2.930    90.395     0.200
     3.399   105.094     0.200
     3.499   107.195     0.200
     3.499   109.094     0.200
     3.683   112.094     0.200
     4.151   128.594     0.200
     4.473   138.594     0.200
     5.379   168.094     0.200
     7.027   218.242     0.200
     8.295   259.844     0.200
    13.679   423.695     0.200
     2.037    64.289     0.200
     2.218    69.492     0.200
     2.375    74.891     0.200
     2.391    73.789     0.200
     2.510    79.391     0.200
     2.626    79.992     0.200
     2.626    81.191     0.200
     2.616    79.789     0.200
     3.036    92.691     0.200
     3.036    93.191     0.200
     3.588   110.891     0.200
     2.045    64.011     0.200
     2.200    68.711     0.200
     2.382    72.511     0.200
     2.580    79.411     0.200
     2.631    80.811     0.200
     2.820    86.411     0.200
     2.968    90.411     0.200
     3.692   114.011     0.200
     3.791   116.011     0.200
     5.828   179.491     0.200
     6.575   203.011     0.200
     8.332   257.761     0.200
    13.726   426.286     0.200
     2.205    68.953     0.200
     2.322    72.055     0.200
     2.457    76.453     0.200
     2.654    82.250     0.200
     2.851    87.953     0.200
     2.926    90.250     0.200
     3.413   105.250     0.200
     3.499   106.055     0.200
     3.499   109.352     0.200
     3.499   110.953     0.200
     3.922   122.852     0.200
     5.360   167.109     0.200
     8.282   257.078     0.200
    13.690   426.805     0.200
     2.247    68.812     0.200
     2.227    69.211     0.200
     2.620    79.508     0.200
     2.620    81.312     0.200
     2.871    88.711     0.200
     2.199    69.277     0.200
     2.320    72.676     0.200
     2.452    76.375     0.200
     2.662    82.578     0.200
     2.863    88.078     0.200
     2.922    90.977     0.200
     3.422   106.078     0.200
     3.497   108.777     0.200
     3.666   112.676     0.200
     3.915   122.777     0.200
     4.165   129.277     0.200
     4.442   137.676     0.200
     5.347   165.637     0.200
     7.056   219.816     0.200
     8.275   259.078     0.200
    13.695   428.027     0.200
     2.258    68.883     0.200
     2.520    77.086     0.200
     2.602    80.984     0.200
     2.852    88.086     0.200
     3.036    93.484     0.200
     3.760   116.184     0.200
     2.289    70.859     0.200
     2.432    75.660     0.200
     2.545    78.758     0.200
     2.602    80.457     0.200
     2.871    88.457     0.200
     3.021    92.656     0.200
     3.021    94.359     0.200
     3.394   104.957     0.200
     3.518   109.059     0.200
     3.614   109.457     0.200
     3.614   113.059     0.200
     4.309   133.160     0.200
     5.320   167.309     0.200
     7.063   219.594     0.200
    15.340   478.297     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.216     7.424     0.200
     0.984    31.625     0.200
     1.823    54.524     0.200
     1.985    60.625     0.200
     1.902    58.121     0.200
     3.245    95.721     0.200
     0.358    12.965     0.200
     0.826    25.664     0.200
     1.750    51.664     0.200
     0.240    10.285     0.200
     1.163    36.285     0.200
     1.281    39.586     0.200
     0.258    11.070     0.200
     2.368    69.672     0.200
     0.264    10.621     0.200
     0.997    31.223     0.200
     1.436    43.020     0.200
     2.976    88.621     0.200
     0.327    11.648     0.200
     0.914    29.148     0.200
     1.506    45.148     0.200
     0.282    10.758     0.200
     0.314    11.488     0.200
     0.916    29.488     0.200
     1.391    44.391     0.200
     1.510    46.590     0.200
     2.713    79.789     0.200
     1.530    47.375     0.200
     5.841   170.977     0.200
     0.355    12.364     0.200
     0.995    31.564     0.200
     1.401    44.464     0.200
     1.413    45.464     0.200
     0.236     8.913     0.200
     0.569    18.213     0.200
     1.043    33.413     0.200
     1.331    42.713     0.200
     1.331    43.513     0.200
     1.501    46.913     0.200
     1.501    48.213     0.200
     1.630    50.513     0.200
     0.146     6.506     0.200
     0.649    22.006     0.200
     0.966    30.406     0.200
     1.407    45.205     0.200
     0.331    11.320     0.200
     1.021    32.320     0.200
     1.383    44.320     0.200
     1.464    46.227     0.200
     2.304    69.023     0.200
     0.260     7.973     0.200
     0.260     9.074     0.200
     0.589    19.574     0.200
     1.282    41.574     0.200
     1.282    42.473     0.200
     1.434    45.973     0.200
     0.224     9.280     0.200
     0.934    28.480     0.200
     0.951    30.580     0.200
     1.528    47.080     0.200
     0.206     7.406     0.200
     0.767    25.508     0.200
     0.997    32.508     0.200
     0.999    32.508     0.200
     1.045    33.406     0.200
     1.033    33.406     0.200
     1.034    33.406     0.200
     1.358    44.406     0.200
     1.509    48.609     0.200
     2.167    69.109     0.200
     2.360    74.008     0.200
     0.352    11.817     0.200
     0.471    15.717     0.200
     0.984    31.117     0.200
     1.437    45.317     0.200
     1.437    45.518     0.200
     0.296     9.363     0.200
     0.560    18.660     0.200
     1.123    35.660     0.200
     1.250    40.461     0.200
     1.250    39.863     0.200
     1.575    50.363     0.200
     2.644    78.961     0.200
     0.118     5.759     0.200
     0.669    22.259     0.200
     0.906    28.159     0.200
     1.166    38.259     0.200
     1.247    39.559     0.200
     1.976    62.259     0.200
     0.258     8.352     0.200
     0.548    18.449     0.200
     0.548    18.551     0.200
     1.060    34.551     0.200
     1.038    34.449     0.200
     1.162    37.352     0.200
     1.314    41.648     0.200
     0.215     7.919     0.200
     0.982    31.019     0.200
     1.121    37.119     0.200
     1.236    39.919     0.200
     1.960    61.619     0.200
     0.235     9.926     0.200
     0.630    20.125     0.200
     0.872    28.426     0.200
     1.743    51.723     0.200
     1.743    53.824     0.200
     1.920    59.523     0.200
     1.949    60.324     0.200
     0.247     9.617     0.200
     0.920    28.914     0.200
     0.985    32.016     0.200
     1.105    35.715     0.200
     0.094     7.665     0.200
     0.698    23.365     0.200
     0.698    22.965     0.200
     0.923    28.965     0.200
     1.934    61.064     0.200
     0.212     9.223     0.200
     0.918    27.422     0.200
     0.949    30.322     0.200
     1.110    34.822     0.200
     1.143    36.422     0.200
     0.328    11.355     0.200
     1.182    37.559     0.200
     0.206     7.066     0.200
     0.598    19.867     0.200
     0.598    20.168     0.200
     1.020    31.566     0.200
     1.353    43.066     0.200
     1.353    43.168     0.200
     0.259    10.143     0.200
     0.259    10.643     0.200
     0.648    21.443     0.200
     1.025    32.143     0.200
     1.163    35.743     0.200
     1.407    42.443     0.200
     1.407    42.943     0.200
     1.482    45.743     0.200
     2.313    67.243     0.200
     0.302    10.829     0.200
     0.533    18.029     0.200
     0.929    28.729     0.200
     1.379    44.129     0.200
     1.479    47.329     0.200
     0.245     8.336     0.200
     0.245     8.938     0.200
     0.641    22.234     0.200
     1.308    41.336     0.200
     0.347    10.809     0.200
     0.347    11.910     0.200
     0.503    18.109     0.200
     2.308    67.809     0.200
     0.108     7.223     0.200
     0.108     6.820     0.200
     0.807    26.621     0.200
     1.440    44.121     0.200
     1.954    58.922     0.200
     1.954    60.922     0.200
     0.328    11.104     0.200
     0.456    15.305     0.200
     0.761    25.703     0.200
     0.895    28.604     0.200
     1.079    35.805     0.200
     1.079    35.203     0.200
     1.303    41.305     0.200
     1.303    41.703     0.200
     1.342    43.004     0.200
     0.226    10.062     0.200
     0.643    19.367     0.200
     0.938    31.266     0.200
     1.059    33.469     0.200
     1.201    37.664     0.200
     1.386    41.867     0.200
     0.311    11.414     0.200
     0.540    18.016     0.200
     0.540    18.211     0.200
     0.914    28.914     0.200
     0.914    29.016     0.200
     1.265    42.016     0.200
     0.751    23.599     0.200
     0.751    23.899     0.200
     0.752    24.799     0.200
     0.752    24.899     0.200
     0.798    26.000     0.200
     1.624    51.199     0.200
     0.171     6.676     0.200
     0.739    24.277     0.200
     0.739    24.578     0.200
     0.761    23.578     0.200
     0.761    23.977     0.200
     0.795    25.578     0.200
     1.392    43.676     0.200
     1.392    46.078     0.200
     1.614    50.977     0.200
     0.072     6.500     0.200
     0.814    27.500     0.200
     2.009    59.301     0.200
     0.338    11.578     0.200
     0.824    27.180     0.200
     0.928    28.781     0.200
     1.414    45.383     0.200
     1.414    46.281     0.200
     1.495    47.180     0.200
     1.495    48.281     0.200
     0.208     8.184     0.200
     0.581    19.883     0.200
     0.581    20.082     0.200
     0.669    22.281     0.200
     0.955    30.281     0.200
     0.955    29.582     0.200
     1.265    40.281     0.200
     1.989    62.883     0.200
     0.151     5.527     0.200
     0.648    21.629     0.200
     0.974    30.430     0.200
     1.179    38.027     0.200
     1.399    44.629     0.200
     0.130     6.109     0.200
     0.656    21.910     0.200
     0.656    21.711     0.200
     0.925    28.609     0.200
     0.925    28.711     0.200
     1.148    37.012     0.200
     1.232    39.410     0.200
     0.289    10.430     0.200
     0.467    15.129     0.200
     0.657    22.031     0.200
     0.657    21.430     0.200
     0.740    24.629     0.200
     1.075    35.328     0.200
     1.314    41.129     0.200
     0.153     5.680     0.200
     0.586    19.680     0.200
     0.644    21.578     0.200
     0.644    21.777     0.200
     0.973    30.480     0.200
     0.973    30.180     0.200
     1.096    36.578     0.200
     1.400    44.277     0.200
     0.176     7.109     0.200
     0.889    28.812     0.200
     1.097    35.109     0.200
     1.108    37.516     0.200
     1.392    44.414     0.200
     1.491    47.414     0.200
     0.294    10.172     0.200
     0.468    14.773     0.200
     0.652    22.070     0.200
     0.652    21.477     0.200
     0.652    22.172     0.200
     0.740    25.477     0.200
     0.863    27.375     0.200
     1.072    34.977     0.200
     1.211    38.172     0.200
     1.278    40.375     0.200
     1.316    41.273     0.200
     0.320    11.604     0.200
     0.466    15.104     0.200
     1.172    36.403     0.200
     1.172    36.703     0.200
     1.257    39.703     0.200
     1.257    39.804     0.200
     0.161     6.484     0.200
     0.636    21.781     0.200
     0.636    21.586     0.200
     0.586    19.680     0.200
     0.978    30.883     0.200
     0.978    30.984     0.200
     1.093    35.883     0.200
     1.394    44.180     0.200
     1.394    44.984     0.200
     0.157     6.125     0.200
     0.575    19.320     0.200
     0.645    21.820     0.200
     0.645    21.625     0.200
     0.981    30.727     0.200
     1.086    36.320     0.200
     1.392    44.820     0.200
     1.501    47.922     0.200
     2.763    81.422     0.200
     3.054    91.727     0.200
     0.168     5.781     0.200
     0.631    21.281     0.200
     0.631    21.078     0.200
     0.986    30.781     0.200
     0.986    30.883     0.200
     1.087    35.883     0.200
     1.387    44.383     0.200
     1.509    47.477     0.200
     2.566    75.883     0.200
     0.164     6.164     0.200
     0.577    19.469     0.200
     0.637    21.469     0.200
     0.637    21.367     0.200
     0.985    30.867     0.200
     0.985    31.164     0.200
     1.085    35.969     0.200
     1.504    47.867     0.200
     2.572    76.469     0.200
     0.148     5.219     0.200
     0.588    19.719     0.200
     0.648    22.020     0.200
     1.100    36.422     0.200
     1.186    38.219     0.200
     1.405    45.121     0.200
     2.776    82.320     0.200
     0.143     5.282     0.200
     0.593    19.982     0.200
     0.652    22.082     0.200
     0.962    29.982     0.200
     1.106    35.682     0.200
     1.191    37.782     0.200
     1.411    44.782     0.200
     1.518    48.582     0.200
     3.958   119.382     0.200
     0.164     5.269     0.200
     0.573    19.269     0.200
     0.638    21.369     0.200
     0.638    21.269     0.200
     1.081    35.769     0.200
     1.170    37.769     0.200
     1.385    44.669     0.200
     1.500    47.869     0.200
     0.155     5.219     0.200
     0.578    19.422     0.200
     0.645    21.621     0.200
     0.645    21.422     0.200
     1.394    44.121     0.200
     1.394    45.320     0.200
     1.504    48.020     0.200
     5.305   157.922     0.200
     0.170     5.094     0.200
     0.564    18.492     0.200
     0.637    21.094     0.200
     1.377    44.691     0.200
     1.491    48.094     0.200
     0.163     5.912     0.200
     0.637    21.312     0.200
     0.984    30.514     0.200
     1.389    44.014     0.200
     0.152     5.195     0.200
     0.613    20.195     0.200
     0.637    20.793     0.200
     0.955    29.996     0.200
     1.120    37.496     0.200
     1.417    45.195     0.200
     0.156     5.684     0.200
     0.595    19.484     0.200
     0.638    21.284     0.200
     0.969    30.284     0.200
     1.103    35.784     0.200
     1.404    44.584     0.200
     1.522    47.884     0.200
     2.555    75.384     0.200
     6.874   196.984     0.200
     0.241     8.234     0.200
     0.241     8.828     0.200
     0.630    22.328     0.200
     0.124     7.625     0.200
     0.801    25.223     0.200
     0.801    25.426     0.200
     0.909    29.426     0.200
     0.909    29.324     0.200
     1.740    54.523     0.200
     1.972    61.723     0.200
     0.167     5.203     0.200
     0.167     6.000     0.200
     0.633    20.801     0.200
     0.633    21.102     0.200
     0.986    31.000     0.200
     1.086    35.602     0.200
     1.387    44.602     0.200
     1.507    47.602     0.200
     0.334    11.394     0.200
     0.482    16.294     0.200
     0.982    30.594     0.200
     1.208    40.194     0.200
     2.369    71.294     0.200
     2.790    83.994     0.200
     0.344    12.117     0.200
     0.858    27.016     0.200
     0.827    27.117     0.200
     0.827    26.914     0.200
     1.340    41.914     0.200
     1.356    42.316     0.200
     2.734    81.215     0.200
     0.332    11.469     0.200
     0.641    20.669     0.200
     0.978    30.969     0.200
     1.388    44.269     0.200
     1.427    44.669     0.200
     1.452    45.869     0.200
     0.151     5.055     0.200
     0.646    21.355     0.200
     0.646    21.457     0.200
     0.971    30.656     0.200
     1.402    44.156     0.200
     1.402    44.355     0.200
     1.513    47.855     0.200
     0.150     5.391     0.200
     0.650    21.391     0.200
     0.974    30.391     0.200
     1.092    36.086     0.200
     1.399    43.688     0.200
     1.399    45.289     0.200
     0.157     6.889     0.200
     0.645    21.787     0.200
     0.982    30.488     0.200
     0.308    11.424     0.200
     0.609    20.123     0.200
     0.835    26.324     0.200
     1.337    43.123     0.200
     1.884    56.223     0.200
     1.997    61.424     0.200
     1.997    61.723     0.200
     0.164     5.586     0.200
     0.634    21.086     0.200
     0.634    21.281     0.200
     0.982    30.383     0.200
     0.982    30.883     0.200
     1.090    35.984     0.200
     1.391    44.680     0.200
     1.510    47.984     0.200
     0.163     5.977     0.200
     0.637    21.273     0.200
     0.984    30.672     0.200
     0.984    31.477     0.200
     1.086    35.375     0.200
     1.389    44.875     0.200
     2.571    76.875     0.200
     0.137     7.043     0.200
     0.782    26.742     0.200
     1.313    41.441     0.200
     1.402    43.242     0.200
     2.313    69.242     0.200
     2.313    67.242     0.200
     0.168     5.922     0.200
     0.633    21.320     0.200
     0.633    21.023     0.200
     0.988    30.922     0.200
     1.084    36.125     0.200
     1.385    44.023     0.200
     1.505    47.820     0.200
     3.052    91.922     0.200
     5.294   157.625     0.200
     0.166     5.461     0.200
     0.631    21.359     0.200
     0.983    30.758     0.200
     0.983    31.059     0.200
     1.090    35.859     0.200
     1.390    45.059     0.200
     3.936   118.758     0.200
     0.200     7.074     0.200
     0.586    19.672     0.200
     0.586    19.773     0.200
     0.966    29.973     0.200
     1.133    37.375     0.200
     1.410    45.074     0.200
     2.497    73.875     0.200
     0.187     6.773     0.200
     0.600    19.977     0.200
     0.950    29.273     0.200
     1.146    37.172     0.200
     1.426    44.875     0.200
     1.977    62.273     0.200
     0.211     6.838     0.200
     0.576    19.638     0.200
     0.576    18.738     0.200
     1.127    37.138     0.200
     1.401    44.338     0.200
     2.992    90.138     0.200
     0.191     7.317     0.200
     0.595    20.017     0.200
     0.595    20.117     0.200
     0.965    30.217     0.200
     1.129    37.117     0.200
     2.201    67.817     0.200
     2.201    68.417     0.200
     0.199     7.289     0.200
     0.588    19.789     0.200
     0.588    19.891     0.200
     0.960    29.691     0.200
     0.960    30.191     0.200
     1.974    62.992     0.200
     0.195     7.121     0.200
     0.591    19.721     0.200
     0.591    19.921     0.200
     0.964    30.221     0.200
     1.133    36.721     0.200
     1.411    44.721     0.200
     2.500    74.821     0.200
     0.193     6.879     0.200
     0.594    19.578     0.200
     0.960    29.779     0.200
     1.136    36.479     0.200
     1.415    44.979     0.200
     2.498    75.078     0.200
     5.301   157.180     0.200
     0.146     6.055     0.200
     0.651    21.555     0.200
     0.968    30.152     0.200
     0.968    30.355     0.200
     0.968    31.555     0.200
     1.099    34.754     0.200
     1.405    44.453     0.200
     1.912    60.652     0.200
     0.277     9.383     0.200
     0.532    17.982     0.200
     0.532    17.783     0.200
     1.026    34.283     0.200
     1.078    33.283     0.200
     1.078    33.182     0.200
     1.298    41.283     0.200
     1.298    41.182     0.200
     0.632    21.430     0.200
     0.632    21.531     0.200
     0.972    30.727     0.200
     0.972    30.531     0.200
     1.103    36.625     0.200
     1.401    44.531     0.200
     1.401    44.328     0.200
     1.524    48.531     0.200
     2.552    75.531     0.200
     0.627    21.008     0.200
     0.627    21.305     0.200
     0.979    30.406     0.200
     0.979    30.508     0.200
     1.096    36.707     0.200
     1.394    44.008     0.200
     0.306    10.383     0.200
     0.502    17.383     0.200
     0.576    19.688     0.200
     1.018    34.281     0.200
     1.099    34.688     0.200
     0.276     9.344     0.200
     0.772    24.844     0.200
     0.834    26.641     0.200
     0.860    29.047     0.200
     0.892    29.242     0.200
     1.423    46.547     0.200
     1.588    49.445     0.200
     1.810    56.445     0.200
     0.176     6.180     0.200
     0.569    18.781     0.200
     0.629    21.082     0.200
     0.998    31.082     0.200
     0.998    30.980     0.200
     1.074    34.980     0.200
     1.375    44.082     0.200
     2.578    75.883     0.200
     2.578    76.082     0.200
     0.286    10.066     0.200
     0.515    17.467     0.200
     0.729    24.566     0.200
     0.973    30.066     0.200
     0.171     6.906     0.200
     0.597    19.809     0.200
     0.622    21.207     0.200
     0.979    30.906     0.200
     0.979    30.508     0.200
     1.098    35.906     0.200
     1.194    38.109     0.200
     1.921    61.008     0.200
     0.344    11.961     0.200
     0.576    18.961     0.200
     0.667    22.656     0.200
     0.958    31.156     0.200
     0.958    31.258     0.200
     1.212    38.961     0.200
     1.255    40.859     0.200
     6.859   195.555     0.200
     0.173     9.906     0.200
     0.699    23.305     0.200
     0.764    24.305     0.200
     0.960    31.207     0.200
     1.776    55.805     0.200
     1.898    59.805     0.200
     1.999    62.805     0.200
     2.122    61.508     0.200
     2.122    61.906     0.200
     0.321    10.791     0.200
     0.602    19.791     0.200
     0.620    20.691     0.200
     0.632    21.391     0.200
     0.933    30.791     0.200
     1.219    39.791     0.200
     2.701    80.391     0.200
     0.426    14.922     0.200
     0.435    14.523     0.200
     0.545    18.223     0.200
     0.918    31.023     0.200
     1.149    35.723     0.200
     1.149    36.824     0.200
     1.233    38.523     0.200
     0.144     6.311     0.200
     0.582    19.511     0.200
     0.656    22.011     0.200
     0.656    21.911     0.200
     0.969    30.811     0.200
     0.969    30.211     0.200
     1.180    37.911     0.200
     1.405    45.311     0.200
     2.776    82.311     0.200
     4.870   145.211     0.200
     6.673   195.511     0.200
     0.160     6.039     0.200
     0.572    19.242     0.200
     0.644    22.039     0.200
     0.644    21.938     0.200
     0.985    31.039     0.200
     1.170    38.141     0.200
     1.389    44.938     0.200
     1.658    51.539     0.200
     3.057    91.344     0.200
     5.300   154.844     0.200
     5.495   159.141     0.200
     0.156     6.199     0.200
     0.575    19.299     0.200
     0.646    22.400     0.200
     0.646    22.100     0.200
     0.980    31.100     0.200
     1.173    37.900     0.200
     1.393    45.199     0.200
     1.501    47.900     0.200
     5.522   159.799     0.200
     0.156     5.344     0.200
     0.567    18.945     0.200
     0.651    21.648     0.200
     0.651    21.547     0.200
     0.985    30.844     0.200
     0.985    30.742     0.200
     1.164    36.945     0.200
     1.389    43.242     0.200
     2.585    77.742     0.200
     0.289    11.547     0.200
     0.621    19.750     0.200
     0.621    19.250     0.200
     0.840    27.250     0.200
     0.840    27.547     0.200
     1.871    56.945     0.200
     1.871    57.250     0.200
     0.073     6.539     0.200
     0.671    21.838     0.200
     0.723    23.838     0.200
     0.857    27.238     0.200
     0.857    26.838     0.200
     1.999    62.838     0.200
     0.321    11.125     0.200
     0.430    13.430     0.200
     0.639    21.523     0.200
     0.780    26.023     0.200
     1.107    36.023     0.200
     1.277    39.727     0.200
     0.323    11.141     0.200
     0.431    13.641     0.200
     0.431    15.539     0.200
     0.637    21.840     0.200
     0.780    26.141     0.200
     0.900    28.941     0.200
     1.106    35.641     0.200
     1.278    40.141     0.200
     1.942    60.539     0.200
     7.316   208.441     0.200
     0.331    12.423     0.200
     0.501    16.723     0.200
     0.629    20.423     0.200
     0.955    31.622     0.200
     1.141    35.622     0.200
     1.169    37.322     0.200
     1.856    58.522     0.200
     2.574    74.122     0.200
     7.229   205.723     0.200
     0.174     8.312     0.200
     0.719    22.617     0.200
     0.813    26.812     0.200
     0.788    26.312     0.200
     0.788    26.414     0.200
     1.921    58.211     0.200
     1.921    59.312     0.200
     1.989    61.117     0.200
     1.967    61.211     0.200
     0.311    10.808     0.200
     0.642    21.308     0.200
     0.788    25.508     0.200
     0.903    29.508     0.200
     1.183    38.208     0.200
     4.582   132.808     0.200
     0.190     7.926     0.200
     0.585    19.324     0.200
     0.608    19.824     0.200
     0.608    20.723     0.200
     0.999    31.426     0.200
     1.181    37.625     0.200
     1.907    59.824     0.200
     0.194     7.395     0.200
     0.588    19.395     0.200
     0.602    20.297     0.200
     1.001    31.496     0.200
     1.184    37.594     0.200
     0.145     6.223     0.200
     0.628    20.523     0.200
     0.642    21.621     0.200
     0.940    29.023     0.200
     1.225    39.422     0.200
     1.953    61.621     0.200
     0.162     6.082     0.200
     0.573    19.082     0.200
     0.641    21.480     0.200
     0.986    30.980     0.200
     1.170    37.582     0.200
     1.387    44.383     0.200
     2.577    76.281     0.200
     3.056    90.684     0.200
     0.166     6.070     0.200
     0.570    18.770     0.200
     0.638    21.270     0.200
     0.990    30.871     0.200
     1.168    37.469     0.200
     1.383    44.070     0.200
     4.332   125.469     0.200
     4.848   144.070     0.200
     0.343    12.890     0.200
     0.620    20.390     0.200
     0.698    22.690     0.200
     0.922    29.490     0.200
     0.922    30.590     0.200
     1.827    56.990     0.200
     2.729    79.791     0.200
     3.338    97.190     0.200
     7.111   204.891     0.200
     0.159     5.992     0.200
     0.571    19.289     0.200
     0.645    21.688     0.200
     0.985    31.188     0.200
     1.082    35.391     0.200
     1.388    43.086     0.200
     2.580    76.289     0.200
     3.935   118.188     0.200
     0.167     6.172     0.200
     0.575    19.570     0.200
     0.635    21.570     0.200
     0.988    31.273     0.200
     0.988    31.172     0.200
     1.082    35.875     0.200
     1.385    44.172     0.200
     1.385    43.477     0.200
     1.502    47.070     0.200
     0.273    10.262     0.200
     0.538    18.859     0.200
     0.746    24.762     0.200
     0.943    29.262     0.200
     0.181     6.367     0.200
     0.470    16.367     0.200
     0.817    27.168     0.200
     1.001    31.070     0.200
     1.365    43.770     0.200
     1.413    44.867     0.200
     0.114     6.398     0.200
     0.588    20.297     0.200
     0.684    23.102     0.200
     0.946    29.500     0.200
     2.573    75.898     0.200
     0.069     6.723     0.200
     0.685    22.324     0.200
     0.736    23.922     0.200
     0.838    26.723     0.200
     1.221    38.422     0.200
     1.746    53.824     0.200
     0.448    15.117     0.200
     0.662    22.117     0.200
     1.094    35.718     0.200
     1.094    34.917     0.200
     1.216    39.917     0.200
     1.292    42.518     0.200
     1.296    41.417     0.200
     1.296    41.018     0.200
     1.333    44.518     0.200
     0.306    10.168     0.200
     0.415    13.568     0.200
     1.152    36.568     0.200
     1.152    36.168     0.200
     1.227    39.869     0.200
     1.345    42.869     0.200
     1.442    46.770     0.200
     2.070    65.668     0.200
     0.309     9.775     0.200
     0.391    13.375     0.200
     0.657    21.875     0.200
     0.896    28.775     0.200
     1.227    39.975     0.200
     1.321    42.074     0.200
     1.427    45.875     0.200
     1.513    47.975     0.200
     0.303     9.805     0.200
     0.397    13.406     0.200
     0.656    22.105     0.200
     0.903    29.707     0.200
     1.150    36.105     0.200
     1.233    39.504     0.200
     1.328    42.305     0.200
     2.069    61.305     0.200
     0.176     6.078     0.200
     0.586    19.477     0.200
     0.989    31.273     0.200
     0.989    31.078     0.200
     1.087    35.375     0.200
     1.384    44.172     0.200
     1.384    43.578     0.200
     1.514    48.078     0.200
     1.624    52.273     0.200
     0.164     6.119     0.200
     0.571    19.020     0.200
     0.640    21.520     0.200
     0.988    31.221     0.200
     1.385    44.221     0.200
     1.498    47.320     0.200
     0.588    19.262     0.200
     0.880    28.762     0.200
     0.943    29.762     0.200
     0.295    11.559     0.200
     0.586    19.059     0.200
     0.586    17.559     0.200
     0.886    28.758     0.200
     0.886    28.859     0.200
     0.939    30.258     0.200
     1.859    56.656     0.200
     1.859    55.457     0.200
     1.789    53.656     0.200
     0.431    14.935     0.200
     0.489    16.435     0.200
     0.512    16.835     0.200
     1.081    32.835     0.200
     1.081    34.135     0.200
     1.299    40.234     0.200
     1.962    61.335     0.200
     2.687    80.734     0.200
     4.080   121.835     0.200
     0.270    10.043     0.200
     0.766    24.145     0.200
     1.055    34.543     0.200
     1.708    51.543     0.200
     1.919    60.645     0.200
     1.986    62.445     0.200
     0.145     5.695     0.200
     0.573    19.094     0.200
     0.659    22.695     0.200
     0.974    30.391     0.200
     0.974    30.594     0.200
     1.089    35.492     0.200
     1.400    44.195     0.200
     1.497    47.297     0.200
     0.282    11.117     0.200
     0.597    19.020     0.200
     0.927    29.918     0.200
     1.778    52.816     0.200
     1.872    57.617     0.200
     1.995    62.617     0.200
     4.317   129.020     0.200
     4.319   128.020     0.200
     0.158     6.008     0.200
     0.570    19.008     0.200
     0.647    22.508     0.200
     0.984    30.508     0.200
     1.082    35.105     0.200
     1.389    44.207     0.200
     1.496    47.207     0.200
     2.580    76.008     0.200
     0.151     5.203     0.200
     0.571    19.102     0.200
     0.654    22.301     0.200
     0.979    30.801     0.200
     1.086    36.102     0.200
     1.394    44.703     0.200
     2.581    75.703     0.200
     0.276     9.344     0.200
     0.411    13.244     0.200
     0.705    22.244     0.200
     0.729    25.344     0.200
     0.768    25.443     0.200
     0.875    28.344     0.200
     1.288    42.145     0.200
     1.431    45.145     0.200
     1.665    52.043     0.200
     2.105    66.344     0.200
     2.295    71.645     0.200
     0.310    10.297     0.200
     0.409    15.197     0.200
     0.493    16.498     0.200
     0.740    24.498     0.200
     0.986    30.498     0.200
     1.184    38.396     0.200
     1.417    44.697     0.200
     0.361    13.844     0.200
     0.719    22.742     0.200
     0.964    31.445     0.200
     1.874    57.945     0.200
     2.069    60.641     0.200
     0.343    11.195     0.200
     0.503    17.098     0.200
     0.939    31.797     0.200
     1.162    36.598     0.200
     1.211    38.898     0.200
     0.219     7.795     0.200
     0.342    11.395     0.200
     0.495    16.193     0.200
     0.594    19.895     0.200
     0.736    24.994     0.200
     1.038    34.494     0.200
     1.283    41.094     0.200
     1.339    42.494     0.200
     1.320    42.295     0.200
     0.212     8.086     0.200
     0.534    18.184     0.200
     1.041    32.785     0.200
     1.031    34.484     0.200
     1.333    42.484     0.200
     1.333    43.586     0.200
     0.120     7.320     0.200
     0.675    22.119     0.200
     0.884    27.520     0.200
     0.299    10.325     0.200
     0.448    14.325     0.200
     0.758    25.825     0.200
     1.093    35.525     0.200
     1.296    40.325     0.200
     1.296    40.426     0.200
     1.924    60.426     0.200
     3.367   100.825     0.200
     0.309    10.430     0.200
     0.442    14.430     0.200
     0.766    25.430     0.200
     1.097    35.730     0.200
     1.289    40.430     0.200
     1.930    60.129     0.200
     0.297    11.523     0.200
     0.637    19.719     0.200
     0.679    22.422     0.200
     0.816    26.523     0.200
     0.936    30.922     0.200
     0.124     7.025     0.200
     0.452    15.826     0.200
     0.555    19.725     0.200
     0.691    23.225     0.200
     0.711    23.625     0.200
     0.847    26.725     0.200
     1.763    55.625     0.200
     0.168     5.891     0.200
     0.331    11.594     0.200
     0.439    15.891     0.200
     0.587    19.289     0.200
     0.628    20.789     0.200
     0.982    31.094     0.200
     1.092    35.391     0.200
     1.390    44.391     0.200
     1.515    47.789     0.200
     2.122    67.992     0.200
     0.201     8.312     0.200
     0.320    10.812     0.200
     0.408    13.016     0.200
     0.463    15.516     0.200
     0.518    17.117     0.200
     1.160    37.617     0.200
     1.217    38.516     0.200
     1.500    48.516     0.200
     1.517    47.617     0.200
     2.036    63.914     0.200
     2.644    78.719     0.200
     4.149   121.914     0.200
     5.459   157.312     0.200
     0.158     7.902     0.200
     0.736    24.305     0.200
     0.807    26.102     0.200
     0.994    31.703     0.200
     1.306    40.805     0.200
     1.315    41.305     0.200
     0.316    12.074     0.200
     0.624    21.172     0.200
     0.815    25.375     0.200
     0.626    21.473     0.200
     0.880    28.875     0.200
     1.905    60.074     0.200
     5.034   147.973     0.200
     0.325    12.156     0.200
     0.636    21.250     0.200
     0.639    21.250     0.200
     0.802    24.953     0.200
     0.895    29.156     0.200
     1.921    60.750     0.200
     1.959    60.750     0.200
     1.984    60.250     0.200
     1.984    62.250     0.200
     0.321    12.172     0.200
     0.616    20.375     0.200
     0.624    20.875     0.200
     0.825    25.273     0.200
     0.879    28.773     0.200
     1.981    60.977     0.200
     1.963    61.977     0.200
     5.415   157.773     0.200
     0.184     6.191     0.200
     0.325    11.191     0.200
     0.580    18.891     0.200
     1.375    43.391     0.200
     0.202     7.894     0.200
     0.401    13.894     0.200
     0.585    19.894     0.200
     0.655    21.594     0.200
     0.961    30.394     0.200
     0.961    29.994     0.200
     1.140    36.394     0.200
     1.415    44.694     0.200
     1.975    61.694     0.200
     0.194     8.287     0.200
     0.734    24.787     0.200
     0.066     6.289     0.200
     0.788    26.590     0.200
     0.329    11.945     0.200
     0.346    11.844     0.200
     0.346    12.047     0.200
     0.453    15.242     0.200
     0.563    19.344     0.200
     0.785    25.547     0.200
     1.108    34.742     0.200
     1.108    36.844     0.200
     1.159    37.742     0.200
     1.339    42.242     0.200
     2.052    65.148     0.200
     0.255     8.712     0.200
     0.302    11.712     0.200
     0.300    10.212     0.200
     0.635    21.012     0.200
     0.647    22.512     0.200
     0.961    31.712     0.200
     1.173    37.212     0.200
     1.195    38.112     0.200
     1.232    40.012     0.200
     1.260    40.812     0.200
     1.423    43.812     0.200
     0.128     7.078     0.200
     0.307    11.375     0.200
     0.733    24.375     0.200
     0.820    27.477     0.200
     0.920    29.578     0.200
     0.920    30.078     0.200
     1.376    42.977     0.200
     1.370    43.578     0.200
     1.398    44.680     0.200
     1.477    45.875     0.200
     1.509    45.977     0.200
     1.509    46.180     0.200
     3.421   102.875     0.200
     3.896   116.578     0.200
     0.279     9.883     0.200
     0.456    15.383     0.200
     0.331    11.285     0.200
     1.145    35.984     0.200
     1.145    36.586     0.200
     1.290    41.285     0.200
     1.659    52.984     0.200
     2.127    65.684     0.200
     2.191    68.883     0.200
     2.267    69.984     0.200
     2.424    73.285     0.200
     0.301    10.875     0.200
     0.488    15.281     0.200
     0.627    20.977     0.200
     1.049    34.477     0.200
     1.220    38.781     0.200
     1.220    40.477     0.200
     1.272    40.578     0.200
     1.272    41.977     0.200
     1.334    41.477     0.200
     1.310    41.680     0.200
     0.280     9.820     0.200
     0.328    11.422     0.200
     0.328    10.820     0.200
     0.459    15.820     0.200
     1.110    37.117     0.200
     1.146    36.422     0.200
     1.291    41.719     0.200
     1.670    53.422     0.200
     2.129    66.117     0.200
     2.192    68.320     0.200
     2.192    68.516     0.200
     2.266    70.219     0.200
     2.266    70.016     0.200
     0.320    11.297     0.200
     0.287    10.598     0.200
     0.470    14.996     0.200
     0.548    18.098     0.200
     0.762    24.797     0.200
     1.147    35.797     0.200
     1.296    40.699     0.200
     1.296    42.297     0.200
     1.681    52.297     0.200
     1.676    51.598     0.200
     0.131     6.637     0.200
     0.434    15.234     0.200
     0.528    18.934     0.200
     0.692    22.637     0.200
     0.670    22.434     0.200
     0.670    22.535     0.200
     0.873    27.535     0.200
     0.873    27.637     0.200
     1.206    39.934     0.200
     1.500    47.137     0.200
     2.125    63.637     0.200
     0.336    12.008     0.200
     0.459    15.309     0.200
     0.557    18.508     0.200
     0.776    25.211     0.200
     1.122    35.309     0.200
     1.145    36.609     0.200
     1.145    38.508     0.200
     1.323    41.910     0.200
     0.253    10.398     0.200
     0.383    13.102     0.200
     0.448    14.500     0.200
     0.537    18.203     0.200
     0.876    29.297     0.200
     1.158    37.398     0.200
     1.370    43.000     0.200
     0.261    10.070     0.200
     0.443    14.875     0.200
     0.448    14.773     0.200
     0.561    18.570     0.200
     0.588    21.172     0.200
     0.730    23.969     0.200
     1.149    36.672     0.200
     1.174    38.172     0.200
     1.220    38.469     0.200
     1.565    49.070     0.200
     0.186     7.578     0.200
     0.337    11.477     0.200
     0.419    13.977     0.200
     0.518    16.977     0.200
     0.589    18.773     0.200
     0.702    23.977     0.200
     0.951    30.680     0.200
     1.260    40.273     0.200
     1.277    40.375     0.200
     1.302    41.578     0.200
     1.422    44.180     0.200
     0.298    11.062     0.200
     0.496    17.461     0.200
     0.553    18.961     0.200
     0.552    18.562     0.200
     0.904    27.762     0.200
     1.266    40.363     0.200
     0.135     6.586     0.200
     0.491    17.781     0.200
     0.530    17.883     0.200
     0.711    23.484     0.200
     0.982    30.680     0.200
     1.067    34.680     0.200
     1.399    44.586     0.200
     2.631    77.086     0.200
     0.242     9.887     0.200
     0.622    19.588     0.200
     0.634    21.188     0.200
     0.778    26.488     0.200
     0.879    28.988     0.200
     0.886    28.688     0.200
     1.956    61.988     0.200
     0.088     6.566     0.200
     0.829    27.367     0.200
     1.372    42.465     0.200
     0.180     6.545     0.200
     0.270     9.545     0.200
     0.512    16.145     0.200
     0.664    21.744     0.200
     0.696    23.045     0.200
     1.032    34.344     0.200
     1.177    37.744     0.200
     1.274    41.344     0.200
     1.312    42.145     0.200
     1.359    42.244     0.200
     0.183     7.660     0.200
     0.333    11.562     0.200
     0.420    13.863     0.200
     0.515    17.062     0.200
     0.581    18.461     0.200
     0.709    24.262     0.200
     0.958    30.961     0.200
     1.267    40.461     0.200
     1.282    40.461     0.200
     1.299    41.863     0.200
     1.414    44.262     0.200
     0.121     6.859     0.200
     0.327    12.561     0.200
     0.678    23.160     0.200
     0.678    22.260     0.200
     0.678    23.459     0.200
     0.952    30.061     0.200
     0.952    29.561     0.200
     1.108    36.260     0.200
     1.913    60.660     0.200
     0.329    11.539     0.200
     0.329    12.336     0.200
     0.718    23.336     0.200
     0.825    27.742     0.200
     0.885    28.539     0.200
     0.834    27.336     0.200
     0.834    27.539     0.200
     1.329    42.742     0.200
     1.380    43.742     0.200
     0.115     6.703     0.200
     0.497    18.000     0.200
     0.624    20.602     0.200
     0.672    22.602     0.200
     0.924    29.000     0.200
     1.951    61.203     0.200
     0.284    10.219     0.200
     0.329    12.719     0.200
     0.487    15.922     0.200
     0.655    21.719     0.200
     0.721    24.520     0.200
     1.054    34.621     0.200
     1.299    42.121     0.200
     1.337    43.621     0.200
     0.251     9.000     0.200
     0.355    13.699     0.200
     0.548    18.602     0.200
     0.567    19.398     0.200
     1.065    33.199     0.200
     1.023    33.500     0.200
     1.308    41.000     0.200
     1.861    58.602     0.200
     0.733    24.283     0.200
     1.373    42.885     0.200
     0.290    10.000     0.200
     0.312    12.000     0.200
     0.573    19.000     0.200
     0.646    21.902     0.200
     0.645    21.199     0.200
     0.965    31.500     0.200
     1.166    36.801     0.200
     1.230    38.902     0.200
     0.088     7.508     0.200
     0.793    26.812     0.200
     2.608    75.609     0.200
     0.257     8.971     0.200
     0.403    14.770     0.200
     0.532    17.869     0.200
     0.681    22.270     0.200
     0.681    23.170     0.200
     0.987    30.570     0.200
     1.143    36.869     0.200
     1.993    62.570     0.200
     2.456    72.170     0.200
     5.263   154.670     0.200
     0.088     5.844     0.200
     0.420    14.344     0.200
     0.512    16.746     0.200
     0.575    17.746     0.200
     0.789    26.547     0.200
     0.995    31.645     0.200
     1.349    43.145     0.200
     1.386    43.246     0.200
     1.379    44.445     0.200
     0.172     8.094     0.200
     0.500    16.594     0.200
     0.615    19.695     0.200
     0.929    30.195     0.200
     0.929    30.395     0.200
     1.288    40.793     0.200
     1.445    44.996     0.200
     4.007   118.094     0.200
     0.219     8.354     0.200
     0.409    14.053     0.200
     0.657    21.854     0.200
     0.756    24.652     0.200
     1.223    38.453     0.200
     1.353    42.453     0.200
     2.643    78.553     0.200
     3.315    98.320     0.200
     0.151     7.253     0.200
     0.401    13.753     0.200
     0.474    15.953     0.200
     0.635    20.953     0.200
     0.704    24.053     0.200
     0.916    29.053     0.200
     1.265    40.353     0.200
     1.294    41.953     0.200
     1.460    45.653     0.200
     0.284    10.281     0.200
     0.492    17.281     0.200
     0.538    18.082     0.200
     0.558    18.281     0.200
     0.790    25.682     0.200
     0.905    28.281     0.200
     1.256    40.682     0.200
     1.498    46.682     0.200
     0.290    10.891     0.200
     0.551    18.789     0.200
     0.504    18.195     0.200
     0.564    19.094     0.200
     0.564    19.195     0.200
     0.894    27.891     0.200
     0.804    26.891     0.200
     2.335    68.492     0.200
     0.210     8.164     0.200
     0.337    11.461     0.200
     0.396    13.062     0.200
     0.452    15.062     0.200
     0.939    31.363     0.200
     1.196    37.961     0.200
     1.183    38.262     0.200
     1.460    46.262     0.200
     1.493    47.363     0.200
     2.061    65.062     0.200
     0.330    11.203     0.200
     0.314    11.102     0.200
     0.275    10.602     0.200
     0.502    16.805     0.200
     0.976    31.906     0.200
     1.136    35.703     0.200
     1.239    39.703     0.200
     2.602    76.602     0.200
     0.127     6.889     0.200
     0.345    12.488     0.200
     0.351    13.389     0.200
     0.374    13.090     0.200
     0.652    21.789     0.200
     0.832    27.789     0.200
     1.164    37.389     0.200
     1.998    62.590     0.200
     0.194     8.594     0.200
     0.194     8.793     0.200
     0.329    11.594     0.200
     0.329    11.895     0.200
     0.410    14.094     0.200
     0.526    17.793     0.200
     0.585    19.492     0.200
     0.699    23.695     0.200
     0.953    29.793     0.200
     0.953    30.492     0.200
     1.256    39.992     0.200
     1.820    57.293     0.200
     0.277    10.691     0.200
     0.277    10.492     0.200
     0.689    23.590     0.200
     0.689    23.391     0.200
     1.279    40.090     0.200
     1.383    42.492     0.200
     0.270    11.111     0.200
     0.295    11.611     0.200
     0.524    17.011     0.200
     0.598    19.911     0.200
     0.805    25.911     0.200
     1.179    36.111     0.200
     1.140    36.511     0.200
     1.292    40.811     0.200
     2.580    75.111     0.200
     0.216     8.555     0.200
     0.314    10.555     0.200
     0.389    12.750     0.200
     0.584    19.148     0.200
     0.548    17.953     0.200
     0.686    22.953     0.200
     0.951    30.852     0.200
     1.250    39.352     0.200
     1.290    42.250     0.200
     1.422    44.953     0.200
     0.226     8.008     0.200
     0.226     8.812     0.200
     0.355    12.906     0.200
     0.566    19.812     0.200
     0.605    19.711     0.200
     1.015    31.609     0.200
     1.082    35.812     0.200
     1.921    60.609     0.200
     0.308    10.176     0.200
     0.376    12.277     0.200
     0.561    18.277     0.200
     0.586    18.875     0.200
     0.676    21.676     0.200
     0.948    31.477     0.200
     1.237    39.176     0.200
     1.232    38.977     0.200
     1.426    44.676     0.200
     0.267     9.484     0.200
     0.372    13.086     0.200
     0.524    17.684     0.200
     0.617    20.383     0.200
     1.042    32.484     0.200
     1.337    42.285     0.200
     1.925    60.586     0.200
     0.159     5.758     0.200
     0.285     9.859     0.200
     0.333    12.258     0.200
     0.478    15.160     0.200
     0.658    21.859     0.200
     0.729    24.359     0.200
     1.064    35.059     0.200
     1.201    38.258     0.200
     1.266    40.258     0.200
     1.326    41.359     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
