#!/bin/bash
gmt begin ushkan1.37_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source ushkan1.37'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.9 -10.0
  0.9 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.984    -0.127     0.200
     0.358     0.272     0.200
     0.826    -0.516     0.200
     0.240    -0.149     0.200
     0.258    -0.680     0.200
     0.264     0.375     0.200
     0.997    -0.534     0.200
     0.327     0.040     0.200
     0.914     0.013     0.200
     0.282     0.523     0.200
     0.956    -0.094     0.200
     0.314    -0.011     0.200
     0.916    -0.835     0.200
     0.355     0.306     0.200
     0.995    -0.531     0.200
     0.236     0.291     0.200
     0.569     0.408     0.200
     0.146    -0.090     0.200
     0.649     0.531     0.200
     0.966    -0.543     0.200
     0.331     0.524     0.200
     0.260     0.111     0.200
     0.589     0.204     0.200
     0.224    -0.184     0.200
     0.934    -1.432     0.200
     0.951    -0.016     0.200
     0.206     0.400     0.200
     0.767     0.326     0.200
     0.997     0.200     0.200
     0.999     0.173     0.200
     0.352    -0.371     0.200
     0.471     0.215     0.200
     0.984    -0.887     0.200
     0.296    -0.533     0.200
     0.560     0.136     0.200
     0.118    -0.034     0.200
     0.669     0.348     0.200
     0.906    -1.258     0.200
     0.258    -0.172     0.200
     0.548     0.898     0.200
     0.215    -0.310     0.200
     0.982    -0.825     0.200
     0.235    -0.329     0.200
     0.630    -0.761     0.200
     0.872     0.194     0.200
     0.247    -0.192     0.200
     0.920    -0.962     0.200
     0.985     0.056     0.200
     0.094     0.461     0.200
     0.698     0.258     0.200
     0.923    -0.717     0.200
     0.212     0.023     0.200
     0.918    -0.866     0.200
     0.949    -0.181     0.200
     0.328    -0.748     0.200
     0.206    -0.433     0.200
     0.598     0.344     0.200
     0.259     0.353     0.200
     0.648    -0.108     0.200
     0.302     0.415     0.200
     0.533     0.706     0.200
     0.929    -0.982     0.200
     0.245    -1.049     0.200
     0.245    -0.549     0.200
     0.641    -0.039     0.200
     0.347    -0.966     0.200
     0.347    -0.466     0.200
     0.503     0.078     0.200
     0.503     0.679     0.200
     0.108    -0.292     0.200
     0.108    -1.093     0.200
     0.807    -0.223     0.200
     0.328     0.319     0.200
     0.456     0.131     0.200
     0.620     0.671     0.200
     0.761     0.712     0.200
     0.895    -0.209     0.200
     0.226     0.229     0.200
     0.643    -0.849     0.200
     0.938     0.626     0.200
     0.311     0.585     0.200
     0.540     0.475     0.200
     0.914    -0.698     0.200
     0.751    -0.506     0.200
     0.751    -0.306     0.200
     0.752     0.360     0.200
     0.798    -0.197     0.200
     0.171     0.169     0.200
     0.739     0.261     0.200
     0.761    -0.757     0.200
     0.761    -0.655     0.200
     0.795    -0.400     0.200
     0.072    -0.546     0.200
     0.814     0.245     0.200
     0.338     0.267     0.200
     0.824    -0.151     0.200
     0.928    -0.996     0.200
     0.208     0.173     0.200
     0.581     0.396     0.200
     0.669    -0.026     0.200
     0.955    -0.424     0.200
     0.955    -0.627     0.200
     0.151    -0.327     0.200
     0.648     0.107     0.200
     0.974    -1.028     0.200
     0.130    -0.466     0.200
     0.656     0.062     0.200
     0.925    -1.150     0.200
     0.925    -0.849     0.200
     0.289    -0.050     0.200
     0.467    -0.701     0.200
     0.657    -0.033     0.200
     0.740    -0.115     0.200
     0.153    -0.616     0.200
     0.586    -0.024     0.200
     0.644     0.005     0.200
     0.973    -0.889     0.200
     0.973    -0.690     0.200
     0.176     0.078     0.200
     0.889    -0.171     0.200
     0.294    -0.126     0.200
     0.468    -0.579     0.200
     0.652     0.285     0.200
     0.740     0.064     0.200
     0.863    -0.604     0.200
     0.320     0.660     0.200
     0.466    -0.198     0.200
     0.161     0.148     0.200
     0.636     0.586     0.200
     0.586     0.328     0.200
     0.978    -0.623     0.200
     0.157     0.066     0.200
     0.575    -0.162     0.200
     0.645     0.343     0.200
     0.981    -0.953     0.200
     0.981    -0.851     0.200
     0.168    -0.525     0.200
     0.631     0.284     0.200
     0.986    -1.077     0.200
     0.986    -0.975     0.200
     0.164     0.082     0.200
     0.577     0.375     0.200
     0.637     0.352     0.200
     0.985    -0.865     0.200
     0.985    -0.763     0.200
     0.148    -0.206     0.200
     0.588     0.216     0.200
     0.648     0.501     0.200
     0.968    -1.190     0.200
     0.143     0.024     0.200
     0.593     0.208     0.200
     0.652     0.517     0.200
     0.962    -0.999     0.200
     0.164    -0.406     0.200
     0.573     0.130     0.200
     0.638     0.006     0.200
     0.638     0.306     0.200
     0.638     1.006     0.200
     0.988    -1.227     0.200
     0.155    -0.125     0.200
     0.578     0.014     0.200
     0.645     0.249     0.200
     0.170    -0.761     0.200
     0.637     0.109     0.200
     0.163    -0.521     0.200
     0.637     0.159     0.200
     0.984    -0.832     0.200
     0.152    -0.474     0.200
     0.613    -0.079     0.200
     0.637     0.084     0.200
     0.955    -1.054     0.200
     0.156    -0.338     0.200
     0.595    -0.062     0.200
     0.638     0.354     0.200
     0.969    -1.293     0.200
     0.969    -0.993     0.200
     0.241    -0.792     0.200
     0.241    -0.690     0.200
     0.630     0.204     0.200
     0.124    -0.356     0.200
     0.801    -0.827     0.200
     0.801    -0.725     0.200
     0.909     0.163     0.200
     0.167    -0.211     0.200
     0.633     0.344     0.200
     0.986    -1.058     0.200
     0.334    -0.048     0.200
     0.482     0.344     0.200
     0.982    -1.088     0.200
     0.344    -0.015     0.200
     0.858    -0.174     0.200
     0.827     0.230     0.200
     0.332     0.266     0.200
     0.641    -0.503     0.200
     0.978    -0.493     0.200
     0.151     0.002     0.200
     0.646     0.250     0.200
     0.646     0.352     0.200
     0.971    -0.519     0.200
     0.971    -0.819     0.200
     0.150    -0.045     0.200
     0.650     0.278     0.200
     0.974    -1.072     0.200
     0.157    -0.323     0.200
     0.645     0.427     0.200
     0.982    -1.020     0.200
     0.308     0.249     0.200
     0.609     0.348     0.200
     0.835    -0.817     0.200
     0.164    -0.182     0.200
     0.634     0.297     0.200
     0.982    -0.904     0.200
     0.163    -0.357     0.200
     0.637     0.283     0.200
     0.984    -1.083     0.200
     0.984    -0.982     0.200
     0.137    -0.619     0.200
     0.782     0.336     0.200
     0.168    -0.209     0.200
     0.633     0.266     0.200
     0.988    -1.069     0.200
     0.166     0.234     0.200
     0.631     0.807     0.200
     0.983    -0.799     0.200
     0.983    -0.697     0.200
     0.200     0.039     0.200
     0.586     0.524     0.200
     0.966    -0.888     0.200
     0.187    -0.238     0.200
     0.600     0.172     0.200
     0.950    -1.046     0.200
     0.211    -0.385     0.200
     0.576     0.489     0.200
     0.976    -1.303     0.200
     0.191     0.565     0.200
     0.595     0.570     0.200
     0.595     0.470     0.200
     0.965    -0.794     0.200
     0.199    -0.156     0.200
     0.588     0.168     0.200
     0.588     0.066     0.200
     0.960    -1.083     0.200
     0.960    -0.982     0.200
     0.195     0.203     0.200
     0.591     0.465     0.200
     0.964    -1.120     0.200
     0.193    -0.165     0.200
     0.594     0.148     0.200
     0.960    -1.005     0.200
     0.146    -0.356     0.200
     0.651     0.111     0.200
     0.968    -0.854     0.200
     0.277    -0.132     0.200
     0.532     0.501     0.200
     0.632     0.611     0.200
     0.632     0.713     0.200
     0.972    -0.754     0.200
     0.627     0.357     0.200
     0.979    -1.028     0.200
     0.306    -0.107     0.200
     0.502     0.715     0.200
     0.576     0.169     0.200
     0.276     0.586     0.200
     0.772     0.174     0.200
     0.834    -0.110     0.200
     0.860     0.908     0.200
     0.892     0.292     0.200
     0.176    -0.444     0.200
     0.569    -0.187     0.200
     0.629     0.119     0.200
     0.629     0.220     0.200
     0.998    -1.074     0.200
     0.286    -0.303     0.200
     0.515     0.180     0.200
     0.729    -0.034     0.200
     0.973    -0.952     0.200
     0.171    -0.160     0.200
     0.597    -0.179     0.200
     0.622     0.368     0.200
     0.979    -0.705     0.200
     0.979    -0.807     0.200
     0.344    -0.061     0.200
     0.592     0.444     0.200
     0.576    -0.763     0.200
     0.576     0.339     0.200
     0.667     0.159     0.200
     0.958    -0.871     0.200
     0.958    -0.668     0.200
     0.173     0.130     0.200
     0.699    -0.257     0.200
     0.764    -0.825     0.200
     0.764    -1.125     0.200
     0.960     0.533     0.200
     0.960     0.635     0.200
     0.321    -0.406     0.200
     0.602    -0.052     0.200
     0.620     0.417     0.200
     0.620     0.519     0.200
     0.632     0.408     0.200
     0.933    -0.344     0.200
     0.426     0.672     0.200
     0.426     0.773     0.200
     0.435    -0.578     0.200
     0.545    -0.379     0.200
     0.918     0.462     0.200
     0.144     0.072     0.200
     0.582    -0.127     0.200
     0.656     0.506     0.200
     0.656     0.707     0.200
     0.969    -0.740     0.200
     0.969    -1.240     0.200
     0.160    -0.048     0.200
     0.572    -0.017     0.200
     0.644     0.956     0.200
     0.985    -0.615     0.200
     0.156     0.425     0.200
     0.575     0.158     0.200
     0.646     1.138     0.200
     0.980    -0.932     0.200
     0.980    -0.631     0.200
     0.156    -0.477     0.200
     0.567    -0.267     0.200
     0.651     0.463     0.200
     0.985    -1.191     0.200
     0.985    -0.394     0.200
     0.289     0.083     0.200
     0.621    -0.832     0.200
     0.621    -1.035     0.200
     0.840     0.505     0.200
     0.073    -0.418     0.200
     0.671    -0.414     0.200
     0.723     0.612     0.200
     0.857    -0.527     0.200
     0.321    -0.382     0.200
     0.430    -1.061     0.200
     0.430     0.439     0.200
     0.639     0.386     0.200
     0.780    -0.090     0.200
     0.323    -0.406     0.200
     0.323     0.493     0.200
     0.431    -0.962     0.200
     0.637     0.449     0.200
     0.780     0.022     0.200
     0.900    -0.204     0.200
     0.331     0.592     0.200
     0.331     0.092     0.200
     0.501    -1.069     0.200
     0.629    -0.913     0.200
     0.955     0.623     0.200
     0.174     0.294     0.200
     0.719    -0.961     0.200
     0.813    -0.439     0.200
     0.788     0.683     0.200
     0.311    -0.417     0.200
     0.642     0.174     0.200
     0.788     0.015     0.200
     0.903    -0.022     0.200
     0.190    -0.748     0.200
     0.585    -0.381     0.200
     0.608     0.738     0.200
     0.999    -0.431     0.200
     0.194    -0.332     0.200
     0.588    -0.419     0.200
     0.602     0.830     0.200
     0.145    -0.737     0.200
     0.628    -0.501     0.200
     0.628     0.499     0.200
     0.642     0.539     0.200
     0.940    -1.092     0.200
     0.162    -0.434     0.200
     0.573    -0.211     0.200
     0.641     0.714     0.200
     0.986    -1.114     0.200
     0.166    -0.606     0.200
     0.570    -0.343     0.200
     0.638     0.598     0.200
     0.990    -0.983     0.200
     0.343     0.470     0.200
     0.620    -0.322     0.200
     0.698    -0.441     0.200
     0.922    -0.508     0.200
     0.159    -0.384     0.200
     0.571    -0.170     0.200
     0.645     0.655     0.200
     0.985    -0.990     0.200
     0.167    -0.235     0.200
     0.575    -0.100     0.200
     0.635     0.873     0.200
     0.988    -0.932     0.200
     0.988    -1.034     0.200
     0.273    -0.166     0.200
     0.538     0.949     0.200
     0.746     0.013     0.200
     0.943    -0.897     0.200
     0.181    -0.282     0.200
     0.470     0.046     0.200
     0.817     0.662     0.200
     0.114    -0.610     0.200
     0.588    -0.152     0.200
     0.684     0.733     0.200
     0.946    -0.654     0.200
     0.069    -0.456     0.200
     0.685    -0.275     0.200
     0.736     0.557     0.200
     0.838    -0.547     0.200
     0.448     0.116     0.200
     0.662     1.007     0.200
     0.306     0.456     0.200
     0.415     0.443     0.200
     0.309    -0.573     0.200
     0.391    -0.049     0.200
     0.657     0.544     0.200
     0.303    -0.680     0.200
     0.397    -0.428     0.200
     0.656     0.582     0.200
     0.903    -0.002     0.200
     0.176     0.174     0.200
     0.586    -0.029     0.200
     0.989    -0.591     0.200
     0.164    -0.227     0.200
     0.571    -0.143     0.200
     0.640     0.777     0.200
     0.988    -1.016     0.200
     0.299     0.119     0.200
     0.588    -0.538     0.200
     0.880     0.756     0.200
     0.943    -0.296     0.200
     0.295    -0.305     0.200
     0.586    -0.661     0.200
     0.586    -0.762     0.200
     0.939    -0.091     0.200
     0.431     1.005     0.200
     0.489    -0.147     0.200
     0.512    -0.355     0.200
     0.270    -0.155     0.200
     0.766    -1.256     0.200
     0.145    -0.159     0.200
     0.573    -0.195     0.200
     0.974    -0.879     0.200
     0.974    -0.981     0.200
     0.282    -0.227     0.200
     0.597    -0.905     0.200
     0.927    -0.225     0.200
     0.158    -0.341     0.200
     0.570    -0.245     0.200
     0.984    -1.055     0.200
     0.984    -0.453     0.200
     0.151    -0.249     0.200
     0.571    -0.231     0.200
     0.979    -1.052     0.200
     0.276     0.717     0.200
     0.411    -0.015     0.200
     0.705     0.236     0.200
     0.729     0.289     0.200
     0.768     0.637     0.200
     0.875     0.130     0.200
     0.310    -0.113     0.200
     0.409     0.805     0.200
     0.493    -0.130     0.200
     0.740    -0.512     0.200
     0.986    -0.605     0.200
     0.361    -0.218     0.200
     0.719    -0.720     0.200
     0.964     0.118     0.200
     0.343    -0.155     0.200
     0.503     0.124     0.200
     0.939     0.601     0.200
     0.219     0.135     0.200
     0.342    -0.139     0.200
     0.495    -0.139     0.200
     0.594    -0.062     0.200
     0.736     0.600     0.200
     0.212     0.168     0.200
     0.534    -0.091     0.200
     0.120     0.051     0.200
     0.675    -0.578     0.200
     0.884    -0.890     0.200
     0.299    -0.336     0.200
     0.448    -0.718     0.200
     0.758     0.192     0.200
     0.309    -0.255     0.200
     0.442    -0.399     0.200
     0.766     0.059     0.200
     0.297     0.263     0.200
     0.637    -0.991     0.200
     0.679    -0.263     0.200
     0.816    -0.264     0.200
     0.936    -0.364     0.200
     0.124    -0.134     0.200
     0.452     0.002     0.200
     0.555     0.513     0.200
     0.691     0.435     0.200
     0.711     0.006     0.200
     0.847    -0.477     0.200
     0.168     0.037     0.200
     0.331     0.360     0.200
     0.439     0.744     0.200
     0.587    -0.134     0.200
     0.628     0.295     0.200
     0.982    -0.760     0.200
     0.201     0.874     0.200
     0.320     0.186     0.200
     0.408    -0.259     0.200
     0.463     0.215     0.200
     0.518    -0.007     0.200
     0.158     0.607     0.200
     0.736    -0.061     0.200
     0.807    -0.147     0.200
     0.994    -0.190     0.200
     0.316    -0.060     0.200
     0.624     0.113     0.200
     0.815    -0.680     0.200
     0.815    -0.781     0.200
     0.626     0.382     0.200
     0.880     0.118     0.200
     0.325    -0.443     0.200
     0.636     0.177     0.200
     0.639    -0.169     0.200
     0.802    -0.900     0.200
     0.895    -0.062     0.200
     0.321    -0.191     0.200
     0.616     0.558     0.200
     0.624     0.121     0.200
     0.825    -0.950     0.200
     0.879     0.041     0.200
     0.184    -0.300     0.200
     0.325     0.113     0.200
     0.580    -0.188     0.200
     0.202    -0.033     0.200
     0.401    -0.027     0.200
     0.585     0.190     0.200
     0.655    -0.497     0.200
     0.961    -0.450     0.200
     0.961    -0.550     0.200
     0.194    -0.645     0.200
     0.734    -0.040     0.200
     0.066     0.001     0.200
     0.788    -0.015     0.200
     0.329     0.510     0.200
     0.346     0.499     0.200
     0.453     0.109     0.200
     0.785     0.299     0.200
     0.255     0.276     0.200
     0.302     0.805     0.200
     0.300     0.245     0.200
     0.635     0.190     0.200
     0.647     0.966     0.200
     0.961    -0.044     0.200
     0.128     0.641     0.200
     0.307     0.901     0.200
     0.733     0.243     0.200
     0.820     0.844     0.200
     0.920    -0.222     0.200
     0.279     0.206     0.200
     0.456     0.570     0.200
     0.331     0.913     0.200
     0.301    -0.166     0.200
     0.488    -0.486     0.200
     0.627     0.627     0.200
     0.280    -0.097     0.200
     0.328     0.991     0.200
     0.459     0.536     0.200
     0.320     0.417     0.200
     0.287     0.498     0.200
     0.470    -0.328     0.200
     0.548     0.119     0.200
     0.762    -0.263     0.200
     0.131     0.347     0.200
     0.434     0.197     0.200
     0.528     0.585     0.200
     0.692    -0.233     0.200
     0.670     0.378     0.200
     0.873    -0.796     0.200
     0.336     0.722     0.200
     0.459     0.235     0.200
     0.557     0.306     0.200
     0.776     0.012     0.200
     0.244    -0.160     0.200
     0.253     0.600     0.200
     0.383     0.025     0.200
     0.448    -0.393     0.200
     0.537     0.419     0.200
     0.876     0.170     0.200
     0.261     0.724     0.200
     0.443     0.066     0.200
     0.448     0.073     0.200
     0.561     0.298     0.200
     0.588     0.986     0.200
     0.730    -0.339     0.200
     0.186     0.748     0.200
     0.337     0.086     0.200
     0.419     0.084     0.200
     0.518     0.257     0.200
     0.589    -0.464     0.200
     0.702     0.832     0.200
     0.951    -0.331     0.200
     0.298     0.110     0.200
     0.496     0.565     0.200
     0.553     0.536     0.200
     0.552     0.147     0.200
     0.904    -0.821     0.200
     0.135    -0.105     0.200
     0.491     0.622     0.200
     0.530     0.018     0.200
     0.711     0.110     0.200
     0.982    -0.788     0.200
     0.242     0.662     0.200
     0.622    -0.617     0.200
     0.634     0.156     0.200
     0.778     0.376     0.200
     0.879     0.193     0.200
     0.886    -0.728     0.200
     0.088    -0.867     0.200
     0.829    -0.057     0.200
     0.180     0.256     0.200
     0.270     0.251     0.200
     0.512    -0.506     0.200
     0.664     0.338     0.200
     0.696     0.855     0.200
     0.183     0.524     0.200
     0.333    -0.115     0.200
     0.420    -0.178     0.200
     0.515     0.089     0.200
     0.581    -0.428     0.200
     0.709     0.405     0.200
     0.958    -0.457     0.200
     0.121    -0.184     0.200
     0.327    -0.070     0.200
     0.678    -0.351     0.200
     0.678     0.649     0.200
     0.952    -1.222     0.200
     0.952    -0.424     0.200
     0.329     0.599     0.200
     0.718    -0.028     0.200
     0.825     0.768     0.200
     0.885    -0.039     0.200
     0.834     0.397     0.200
     0.115     0.221     0.200
     0.497     0.585     0.200
     0.624    -0.509     0.200
     0.672     0.209     0.200
     0.924    -0.710     0.200
     0.284     0.056     0.200
     0.329     0.689     0.200
     0.487    -0.332     0.200
     0.655     0.101     0.200
     0.721     0.395     0.200
     0.251    -0.703     0.200
     0.355     0.594     0.200
     0.548    -0.180     0.200
     0.567     0.397     0.200
     0.150    -0.038     0.200
     0.733    -0.253     0.200
     0.290    -0.294     0.200
     0.312     0.445     0.200
     0.573    -0.243     0.200
     0.646     0.237     0.200
     0.645     0.153     0.200
     0.965     0.246     0.200
     0.088    -0.358     0.200
     0.793     0.466     0.200
     0.257    -0.693     0.200
     0.403    -0.246     0.200
     0.532    -0.226     0.200
     0.681    -0.388     0.200
     0.987    -0.829     0.200
     0.088     0.724     0.200
     0.420     0.304     0.200
     0.512    -0.269     0.200
     0.575    -0.517     0.200
     0.789     0.517     0.200
     0.995    -0.891     0.200
     0.172     0.835     0.200
     0.500     0.259     0.200
     0.615    -0.144     0.200
     0.929    -0.253     0.200
     0.929    -0.354     0.200
     0.219     0.428     0.200
     0.409     0.222     0.200
     0.657    -0.030     0.200
     0.756    -0.166     0.200
     0.151     0.581     0.200
     0.401     0.060     0.200
     0.474     0.345     0.200
     0.635    -0.200     0.200
     0.704     0.431     0.200
     0.916    -0.605     0.200
     0.284    -0.138     0.200
     0.492     0.361     0.200
     0.538    -0.172     0.200
     0.558     0.460     0.200
     0.790    -0.487     0.200
     0.905    -0.814     0.200
     0.290     0.037     0.200
     0.551     0.081     0.200
     0.504     0.435     0.200
     0.564     0.247     0.200
     0.894    -1.076     0.200
     0.804    -0.375     0.200
     0.210     0.512     0.200
     0.337     0.078     0.200
     0.396    -0.212     0.200
     0.452     0.141     0.200
     0.939     0.217     0.200
     0.330    -0.588     0.200
     0.314     0.004     0.200
     0.275     0.267     0.200
     0.502    -0.163     0.200
     0.976     0.497     0.200
     0.127     0.018     0.200
     0.345    -0.188     0.200
     0.351     0.206     0.200
     0.374    -0.295     0.200
     0.652    -0.104     0.200
     0.832     0.378     0.200
     0.194     0.160     0.200
     0.329    -0.046     0.200
     0.410    -0.076     0.200
     0.526     0.079     0.200
     0.585    -0.011     0.200
     0.699     0.786     0.200
     0.953    -0.097     0.200
     0.277    -0.196     0.200
     0.689     0.049     0.200
     0.270     0.392     0.200
     0.295     0.209     0.200
     0.524    -0.267     0.200
     0.598    -0.006     0.200
     0.805    -0.074     0.200
     0.216     0.684     0.200
     0.314     0.110     0.200
     0.389    -0.049     0.200
     0.584    -0.274     0.200
     0.548     0.198     0.200
     0.686     0.531     0.200
     0.951    -0.551     0.200
     0.226    -0.178     0.200
     0.355     0.225     0.200
     0.566     0.504     0.200
     0.605    -0.710     0.200
     0.308     0.301     0.200
     0.376     0.221     0.200
     0.561     0.457     0.200
     0.586    -0.211     0.200
     0.676     0.690     0.200
     0.948     0.066     0.200
     0.267    -0.527     0.200
     0.372    -0.067     0.200
     0.524    -0.026     0.200
     0.617    -0.212     0.200
     0.159     0.141     0.200
     0.285     0.301     0.200
     0.333     0.717     0.200
     0.478    -0.368     0.200
     0.658     0.076     0.200
     0.729     0.245     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.962    -0.507     0.200
     0.985    -1.070     0.200
     0.838    -1.130     0.200
     0.965    -0.890     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.216    -0.233     0.200
     0.984    -0.719     0.200
     0.358    -0.316     0.200
     0.826    -0.837     0.200
     0.240     0.030     0.200
     0.258     0.111     0.200
     0.264    -0.338     0.200
     0.997    -0.142     0.200
     0.327    -0.653     0.200
     0.914     0.183     0.200
     0.282    -0.534     0.200
     0.314     0.392     0.200
     0.916    -0.397     0.200
     0.355     0.652     0.200
     0.995    -1.045     0.200
     0.236     0.913     0.200
     0.569    -0.524     0.200
     0.146     0.100     0.200
     0.649     0.385     0.200
     0.966    -0.874     0.200
     0.331     0.242     0.200
     0.260    -0.795     0.200
     0.260     0.307     0.200
     0.589     0.201     0.200
     0.224     0.154     0.200
     0.934    -1.324     0.200
     0.951     0.297     0.200
     0.206     0.632     0.200
     0.767     0.384     0.200
     0.997    -0.129     0.200
     0.999    -0.175     0.200
     0.352     0.065     0.200
     0.471     0.120     0.200
     0.984    -1.159     0.200
     0.296    -0.480     0.200
     0.560     0.232     0.200
     0.118     0.227     0.200
     0.669     0.062     0.200
     0.906    -1.560     0.200
     0.258    -0.517     0.200
     0.548     0.331     0.200
     0.548     0.432     0.200
     0.215    -0.450     0.200
     0.982    -0.578     0.200
     0.235    -0.355     0.200
     0.630    -0.796     0.200
     0.872     0.653     0.200
     0.247    -0.101     0.200
     0.920    -0.492     0.200
     0.985     0.777     0.200
     0.094     0.225     0.200
     0.698     0.544     0.200
     0.698     0.144     0.200
     0.923    -0.248     0.200
     0.212     0.034     0.200
     0.918    -1.632     0.200
     0.949     0.395     0.200
     0.328    -0.791     0.200
     0.206    -0.908     0.200
     0.598    -0.104     0.200
     0.598     0.197     0.200
     0.259    -0.243     0.200
     0.259     0.257     0.200
     0.648     0.066     0.200
     0.302     0.409     0.200
     0.533     0.319     0.200
     0.929    -1.819     0.200
     0.245    -1.338     0.200
     0.245    -0.736     0.200
     0.641     0.755     0.200
     0.347    -1.626     0.200
     0.347    -0.525     0.200
     0.503     0.895     0.200
     0.108    -0.407     0.200
     0.108    -0.809     0.200
     0.807     0.687     0.200
     0.328     0.222     0.200
     0.456     0.267     0.200
     0.761     0.735     0.200
     0.895    -0.737     0.200
     0.226    -0.010     0.200
     0.643    -1.935     0.200
     0.938     1.612     0.200
     0.311     0.802     0.200
     0.540     0.106     0.200
     0.540     0.302     0.200
     0.914    -1.107     0.200
     0.914    -1.005     0.200
     0.751    -1.043     0.200
     0.751    -0.743     0.200
     0.752     0.099     0.200
     0.752     0.200     0.200
     0.798    -0.190     0.200
     0.171     0.427     0.200
     0.739    -0.032     0.200
     0.739     0.269     0.200
     0.761    -1.454     0.200
     0.761    -1.056     0.200
     0.795    -0.571     0.200
     0.072    -0.670     0.200
     0.814     1.380     0.200
     0.338     0.119     0.200
     0.824     0.074     0.200
     0.928    -1.703     0.200
     0.208    -0.157     0.200
     0.581     0.316     0.200
     0.581     0.516     0.200
     0.669    -0.097     0.200
     0.955    -0.393     0.200
     0.955    -1.093     0.200
     0.151    -0.807     0.200
     0.648     0.106     0.200
     0.974    -1.222     0.200
     0.130    -0.787     0.200
     0.656     0.001     0.200
     0.656    -0.198     0.200
     0.925    -0.936     0.200
     0.925    -0.834     0.200
     0.289    -0.459     0.200
     0.467    -1.046     0.200
     0.657     0.094     0.200
     0.657    -0.507     0.200
     0.740     0.352     0.200
     0.153    -0.899     0.200
     0.586     0.091     0.200
     0.644     0.133     0.200
     0.644     0.332     0.200
     0.973    -1.005     0.200
     0.973    -1.306     0.200
     0.176     0.287     0.200
     0.889    -0.466     0.200
     0.294    -0.570     0.200
     0.468    -1.263     0.200
     0.652     0.246     0.200
     0.652    -0.348     0.200
     0.652     0.347     0.200
     0.740     0.913     0.200
     0.863    -0.709     0.200
     0.320     0.613     0.200
     0.466    -0.491     0.200
     0.161     0.530     0.200
     0.636     0.812     0.200
     0.636     0.617     0.200
     0.586     0.338     0.200
     0.978    -1.222     0.200
     0.978    -1.120     0.200
     0.157     0.136     0.200
     0.575     0.287     0.200
     0.645     0.527     0.200
     0.645     0.332     0.200
     0.981    -1.500     0.200
     0.168    -0.991     0.200
     0.631     0.317     0.200
     0.631     0.113     0.200
     0.986    -1.203     0.200
     0.986    -1.102     0.200
     0.164     0.135     0.200
     0.577     0.412     0.200
     0.637     0.459     0.200
     0.637     0.357     0.200
     0.985    -1.453     0.200
     0.985    -1.156     0.200
     0.148    -0.368     0.200
     0.588     0.291     0.200
     0.648     0.658     0.200
     0.143    -0.012     0.200
     0.593     0.433     0.200
     0.652     0.638     0.200
     0.962    -1.559     0.200
     0.164    -0.925     0.200
     0.573     0.310     0.200
     0.638     0.283     0.200
     0.638     0.182     0.200
     0.155    -0.572     0.200
     0.578     0.342     0.200
     0.645     0.344     0.200
     0.645     0.145     0.200
     0.170    -0.883     0.200
     0.564    -0.071     0.200
     0.637     0.137     0.200
     0.163    -0.904     0.200
     0.637     0.077     0.200
     0.984    -1.269     0.200
     0.152    -1.163     0.200
     0.613    -0.210     0.200
     0.637    -0.363     0.200
     0.955    -1.129     0.200
     0.156    -0.766     0.200
     0.595    -0.353     0.200
     0.638     0.090     0.200
     0.969    -1.231     0.200
     0.241    -1.509     0.200
     0.241    -0.915     0.200
     0.630     1.317     0.200
     0.124    -0.459     0.200
     0.801    -0.548     0.200
     0.801    -0.345     0.200
     0.909     0.588     0.200
     0.909     0.487     0.200
     0.167    -1.056     0.200
     0.167    -0.259     0.200
     0.633    -0.102     0.200
     0.633     0.199     0.200
     0.986    -1.370     0.200
     0.334     0.061     0.200
     0.482     0.273     0.200
     0.982    -1.641     0.200
     0.344    -0.721     0.200
     0.858    -0.350     0.200
     0.827     0.608     0.200
     0.827     0.405     0.200
     0.332     0.027     0.200
     0.641    -0.591     0.200
     0.978    -0.987     0.200
     0.151    -0.755     0.200
     0.646     0.024     0.200
     0.646     0.126     0.200
     0.971    -1.217     0.200
     0.150    -0.563     0.200
     0.650    -0.119     0.200
     0.974    -1.567     0.200
     0.157    -0.586     0.200
     0.645     0.192     0.200
     0.982    -0.662     0.200
     0.308     0.376     0.200
     0.609    -0.287     0.200
     0.835    -1.085     0.200
     0.164    -0.589     0.200
     0.634     0.135     0.200
     0.634     0.330     0.200
     0.982    -1.855     0.200
     0.982    -1.355     0.200
     0.163    -0.490     0.200
     0.637     0.148     0.200
     0.984    -1.406     0.200
     0.984    -0.601     0.200
     0.137    -0.848     0.200
     0.782     1.548     0.200
     0.168    -0.368     0.200
     0.633     0.424     0.200
     0.633     0.127     0.200
     0.988    -1.507     0.200
     0.166    -0.292     0.200
     0.631     0.630     0.200
     0.983    -1.438     0.200
     0.983    -1.138     0.200
     0.200     0.087     0.200
     0.586     0.342     0.200
     0.586     0.444     0.200
     0.966    -1.712     0.200
     0.187    -0.353     0.200
     0.600     0.052     0.200
     0.950    -1.845     0.200
     0.211    -0.474     0.200
     0.576     0.655     0.200
     0.576    -0.245     0.200
     0.191     0.998     0.200
     0.595     0.502     0.200
     0.595     0.602     0.200
     0.965    -1.383     0.200
     0.199     0.104     0.200
     0.588     0.339     0.200
     0.588     0.440     0.200
     0.960    -1.834     0.200
     0.960    -1.334     0.200
     0.195     0.162     0.200
     0.591     0.208     0.200
     0.591     0.408     0.200
     0.964    -1.423     0.200
     0.193    -0.127     0.200
     0.594    -0.059     0.200
     0.960    -1.766     0.200
     0.146    -0.548     0.200
     0.651    -0.184     0.200
     0.968    -1.047     0.200
     0.968    -0.843     0.200
     0.968     0.356     0.200
     0.277    -0.171     0.200
     0.532     0.348     0.200
     0.532     0.149     0.200
     0.632     0.599     0.200
     0.632     0.701     0.200
     0.972    -1.158     0.200
     0.972    -1.353     0.200
     0.627     0.296     0.200
     0.627     0.593     0.200
     0.979    -1.748     0.200
     0.979    -1.646     0.200
     0.306    -0.170     0.200
     0.502     0.635     0.200
     0.576     0.599     0.200
     0.276     0.235     0.200
     0.772    -0.433     0.200
     0.834    -0.688     0.200
     0.860     0.882     0.200
     0.892     0.010     0.200
     0.176    -0.797     0.200
     0.569    -0.227     0.200
     0.629     0.182     0.200
     0.998    -1.241     0.200
     0.998    -1.342     0.200
     0.286    -0.457     0.200
     0.515    -0.019     0.200
     0.729     0.325     0.200
     0.973    -1.135     0.200
     0.171    -0.495     0.200
     0.597    -0.275     0.200
     0.622     0.339     0.200
     0.979    -0.456     0.200
     0.979    -0.854     0.200
     0.344    -0.035     0.200
     0.576    -0.315     0.200
     0.667     0.468     0.200
     0.958     0.079     0.200
     0.958     0.180     0.200
     0.173    -0.039     0.200
     0.699     0.235     0.200
     0.764    -0.577     0.200
     0.960     0.834     0.200
     0.321    -0.645     0.200
     0.602    -0.390     0.200
     0.620    -0.062     0.200
     0.632     0.271     0.200
     0.933     0.564     0.200
     0.426     0.276     0.200
     0.435    -0.386     0.200
     0.545    -0.156     0.200
     0.918     1.257     0.200
     0.144     0.525     0.200
     0.582     0.214     0.200
     0.656     0.336     0.200
     0.656     0.236     0.200
     0.969    -0.977     0.200
     0.969    -1.577     0.200
     0.160    -0.175     0.200
     0.572     0.267     0.200
     0.644     0.743     0.200
     0.644     0.642     0.200
     0.985    -1.209     0.200
     0.156     0.529     0.200
     0.575     0.327     0.200
     0.646     1.135     0.200
     0.646     0.834     0.200
     0.980    -1.051     0.200
     0.156    -1.101     0.200
     0.567     0.028     0.200
     0.651     0.020     0.200
     0.651    -0.082     0.200
     0.985    -1.109     0.200
     0.985    -1.211     0.200
     0.289     0.517     0.200
     0.621    -1.018     0.200
     0.621    -1.518     0.200
     0.840     0.283     0.200
     0.840     0.579     0.200
     0.073    -0.647     0.200
     0.671    -0.217     0.200
     0.723     0.307     0.200
     0.857    -0.087     0.200
     0.857    -0.487     0.200
     0.321    -0.686     0.200
     0.430    -1.628     0.200
     0.639     0.098     0.200
     0.780     0.612     0.200
     0.323    -0.731     0.200
     0.431    -1.442     0.200
     0.431     0.456     0.200
     0.637     0.495     0.200
     0.780     0.728     0.200
     0.900     0.098     0.200
     0.331     0.059     0.200
     0.501    -0.492     0.200
     0.629    -0.421     0.200
     0.955     1.532     0.200
     0.174     0.656     0.200
     0.719    -1.217     0.200
     0.813     0.306     0.200
     0.788     0.528     0.200
     0.788     0.629     0.200
     0.311    -0.852     0.200
     0.642    -0.057     0.200
     0.788    -0.018     0.200
     0.903     0.708     0.200
     0.190    -1.025     0.200
     0.585    -0.279     0.200
     0.608    -0.423     0.200
     0.608     0.475     0.200
     0.999     0.055     0.200
     0.194    -1.145     0.200
     0.588    -0.410     0.200
     0.602     0.067     0.200
     0.145    -0.987     0.200
     0.628    -0.558     0.200
     0.642     0.130     0.200
     0.940    -0.953     0.200
     0.162    -0.356     0.200
     0.573     0.033     0.200
     0.641     0.227     0.200
     0.986    -1.161     0.200
     0.166    -0.824     0.200
     0.570    -0.323     0.200
     0.638    -0.002     0.200
     0.990    -1.098     0.200
     0.343    -0.084     0.200
     0.620    -0.237     0.200
     0.698    -0.170     0.200
     0.922     0.253     0.200
     0.922     1.353     0.200
     0.159    -0.373     0.200
     0.571     0.299     0.200
     0.645     0.311     0.200
     0.985    -0.925     0.200
     0.167    -0.082     0.200
     0.575     0.550     0.200
     0.635     0.587     0.200
     0.988    -1.221     0.200
     0.988    -1.322     0.200
     0.273    -0.184     0.200
     0.538     0.459     0.200
     0.746     0.311     0.200
     0.943    -0.788     0.200
     0.181    -0.307     0.200
     0.470     0.734     0.200
     0.817     0.275     0.200
     0.114    -0.896     0.200
     0.588     0.617     0.200
     0.684     0.688     0.200
     0.946    -0.338     0.200
     0.069    -0.672     0.200
     0.685    -0.144     0.200
     0.736    -0.015     0.200
     0.838    -0.102     0.200
     0.448     0.376     0.200
     0.662     0.413     0.200
     0.306    -0.066     0.200
     0.415    -0.165     0.200
     0.309    -0.874     0.200
     0.391     0.165     0.200
     0.657     0.155     0.200
     0.896    -0.696     0.200
     0.303    -1.091     0.200
     0.397    -0.344     0.200
     0.656     0.222     0.200
     0.903     0.372     0.200
     0.176     0.027     0.200
     0.586     0.212     0.200
     0.989    -1.118     0.200
     0.989    -1.313     0.200
     0.164    -0.372     0.200
     0.571     0.021     0.200
     0.640     0.308     0.200
     0.988    -0.984     0.200
     0.588    -0.688     0.200
     0.880     0.492     0.200
     0.943    -0.289     0.200
     0.295     0.036     0.200
     0.586    -0.568     0.200
     0.586    -2.068     0.200
     0.886     0.604     0.200
     0.886     0.705     0.200
     0.939     0.592     0.200
     0.431     0.149     0.200
     0.489    -0.174     0.200
     0.512    -0.481     0.200
     0.270    -0.011     0.200
     0.766    -1.176     0.200
     0.145    -0.293     0.200
     0.573     0.047     0.200
     0.659     0.854     0.200
     0.974    -1.413     0.200
     0.974    -1.209     0.200
     0.282    -0.187     0.200
     0.597    -0.952     0.200
     0.927     0.602     0.200
     0.158    -0.316     0.200
     0.570     0.029     0.200
     0.647     1.072     0.200
     0.984    -1.579     0.200
     0.151    -0.777     0.200
     0.571     0.162     0.200
     0.654     0.691     0.200
     0.979    -1.292     0.200
     0.276     0.278     0.200
     0.411    -0.218     0.200
     0.705    -0.845     0.200
     0.729     1.478     0.200
     0.768     0.272     0.200
     0.875    -0.312     0.200
     0.310    -0.465     0.200
     0.409     1.347     0.200
     0.493    -0.009     0.200
     0.740     0.036     0.200
     0.986    -1.653     0.200
     0.361    -0.027     0.200
     0.719    -0.832     0.200
     0.964     0.977     0.200
     0.343    -0.504     0.200
     0.503     0.338     0.200
     0.939     0.926     0.200
     0.219    -0.103     0.200
     0.342    -0.272     0.200
     0.495    -0.322     0.200
     0.594     0.218     0.200
     0.736     0.729     0.200
     0.212     0.262     0.200
     0.534     0.379     0.200
     0.120    -0.075     0.200
     0.675    -0.015     0.200
     0.884    -0.557     0.200
     0.299    -0.703     0.200
     0.448    -1.179     0.200
     0.758     0.878     0.200
     0.309    -0.636     0.200
     0.442    -0.698     0.200
     0.766    -0.034     0.200
     0.297     0.671     0.200
     0.637    -1.624     0.200
     0.679    -0.258     0.200
     0.816    -0.219     0.200
     0.936     0.798     0.200
     0.124    -0.858     0.200
     0.452    -0.068     0.200
     0.555     0.958     0.200
     0.691     0.601     0.200
     0.711     0.443     0.200
     0.847    -0.323     0.200
     0.168     0.089     0.200
     0.331     0.625     0.200
     0.439     1.416     0.200
     0.587    -0.010     0.200
     0.628     0.147     0.200
     0.982    -1.089     0.200
     0.201     1.497     0.200
     0.320     0.208     0.200
     0.408    -0.457     0.200
     0.463     0.258     0.200
     0.518     0.088     0.200
     0.158     0.625     0.200
     0.736    -0.016     0.200
     0.807    -0.228     0.200
     0.994     0.052     0.200
     0.316     0.071     0.200
     0.624     0.460     0.200
     0.815    -0.745     0.200
     0.626     0.706     0.200
     0.880     0.893     0.200
     0.325    -0.265     0.200
     0.636     0.174     0.200
     0.639     0.090     0.200
     0.802    -0.831     0.200
     0.895     0.732     0.200
     0.321    -0.043     0.200
     0.616    -0.099     0.200
     0.624     0.177     0.200
     0.825    -1.138     0.200
     0.879     0.826     0.200
     0.184    -0.553     0.200
     0.325     0.140     0.200
     0.580    -0.311     0.200
     0.202    -0.473     0.200
     0.401    -0.184     0.200
     0.585     0.125     0.200
     0.655    -0.424     0.200
     0.961    -0.326     0.200
     0.961    -0.725     0.200
     0.194    -1.094     0.200
     0.734     0.916     0.200
     0.066    -0.110     0.200
     0.788     1.231     0.200
     0.329     0.984     0.200
     0.346     0.339     0.200
     0.346     0.542     0.200
     0.453     0.280     0.200
     0.563     0.799     0.200
     0.785    -0.214     0.200
     0.255     0.172     0.200
     0.302     1.669     0.200
     0.300     0.238     0.200
     0.635     0.159     0.200
     0.647     1.270     0.200
     0.961     0.214     0.200
     0.128     1.121     0.200
     0.307     0.493     0.200
     0.733     0.064     0.200
     0.820     0.354     0.200
     0.920    -0.427     0.200
     0.920     0.073     0.200
     0.279     0.727     0.200
     0.456     0.438     0.200
     0.331     0.407     0.200
     0.301     0.571     0.200
     0.488    -0.930     0.200
     0.627     0.259     0.200
     0.280     0.605     0.200
     0.328     0.623     0.200
     0.328     0.021     0.200
     0.459     0.758     0.200
     0.320     0.414     0.200
     0.287     0.721     0.200
     0.470    -0.640     0.200
     0.548    -0.058     0.200
     0.762    -0.285     0.200
     0.131     0.589     0.200
     0.434     0.437     0.200
     0.528     1.167     0.200
     0.692    -0.360     0.200
     0.670     0.152     0.200
     0.670     0.254     0.200
     0.873    -1.113     0.200
     0.873    -1.012     0.200
     0.336     0.772     0.200
     0.459     0.111     0.200
     0.557     0.122     0.200
     0.776    -0.287     0.200
     0.253     0.522     0.200
     0.383    -0.548     0.200
     0.448    -1.094     0.200
     0.537    -0.141     0.200
     0.876     1.152     0.200
     0.261     0.806     0.200
     0.443    -0.039     0.200
     0.448    -0.305     0.200
     0.561    -0.095     0.200
     0.588     1.614     0.200
     0.730    -0.144     0.200
     0.186     0.766     0.200
     0.337     0.053     0.200
     0.419    -0.048     0.200
     0.518    -0.207     0.200
     0.589    -0.702     0.200
     0.702     0.831     0.200
     0.951    -0.557     0.200
     0.298     0.052     0.200
     0.496     0.475     0.200
     0.553     0.190     0.200
     0.552    -0.184     0.200
     0.904    -1.327     0.200
     0.135     0.025     0.200
     0.491     1.036     0.200
     0.530    -0.086     0.200
     0.711    -0.251     0.200
     0.982    -0.782     0.200
     0.242     1.179     0.200
     0.622    -1.034     0.200
     0.634     0.170     0.200
     0.778     0.807     0.200
     0.879     0.038     0.200
     0.886    -0.477     0.200
     0.088    -1.256     0.200
     0.829     0.798     0.200
     0.180     0.159     0.200
     0.270     0.377     0.200
     0.512    -0.755     0.200
     0.664    -0.117     0.200
     0.696     0.169     0.200
     0.183     0.491     0.200
     0.333    -0.011     0.200
     0.420    -0.419     0.200
     0.515    -0.222     0.200
     0.581    -0.929     0.200
     0.709     0.769     0.200
     0.958    -0.284     0.200
     0.121     0.367     0.200
     0.327     0.720     0.200
     0.678     0.490     0.200
     0.678    -0.410     0.200
     0.678     0.789     0.200
     0.952    -0.386     0.200
     0.952    -0.886     0.200
     0.329    -0.494     0.200
     0.329     0.303     0.200
     0.718    -0.305     0.200
     0.825     1.059     0.200
     0.885     0.147     0.200
     0.834     0.357     0.200
     0.834     0.560     0.200
     0.115     0.328     0.200
     0.497     0.986     0.200
     0.624    -0.394     0.200
     0.672     0.112     0.200
     0.924    -0.650     0.200
     0.284    -0.119     0.200
     0.329     1.047     0.200
     0.487    -0.632     0.200
     0.655    -0.152     0.200
     0.721     0.559     0.200
     0.251    -1.384     0.200
     0.355     0.558     0.200
     0.548     0.054     0.200
     0.567     0.306     0.200
     0.733     0.193     0.200
     0.290    -0.912     0.200
     0.312     0.459     0.200
     0.573    -0.491     0.200
     0.646     0.303     0.200
     0.645    -0.369     0.200
     0.965     0.782     0.200
     0.088    -0.550     0.200
     0.793     1.217     0.200
     0.257    -1.020     0.200
     0.403     0.524     0.200
     0.532    -0.327     0.200
     0.681    -0.335     0.200
     0.681     0.565     0.200
     0.987    -0.735     0.200
     0.088     0.952     0.200
     0.420     0.059     0.200
     0.512    -0.437     0.200
     0.575    -1.426     0.200
     0.789     0.490     0.200
     0.995    -0.645     0.200
     0.172     1.058     0.200
     0.500    -0.282     0.200
     0.615    -0.823     0.200
     0.929    -0.067     0.200
     0.929     0.132     0.200
     0.219     0.166     0.200
     0.409     0.132     0.200
     0.657     0.051     0.200
     0.756    -0.345     0.200
     0.151     0.541     0.200
     0.401    -0.102     0.200
     0.474    -0.180     0.200
     0.635    -0.285     0.200
     0.704     0.615     0.200
     0.916    -0.705     0.200
     0.284    -0.329     0.200
     0.492     0.428     0.200
     0.538    -0.217     0.200
     0.558    -0.654     0.200
     0.790    -0.172     0.200
     0.905    -0.834     0.200
     0.290     0.393     0.200
     0.551     0.228     0.200
     0.504     1.114     0.200
     0.564     0.117     0.200
     0.564     0.219     0.200
     0.894    -1.205     0.200
     0.804     0.360     0.200
     0.210     0.977     0.200
     0.337     0.240     0.200
     0.396    -0.058     0.200
     0.452     0.121     0.200
     0.939     0.579     0.200
     0.330    -0.391     0.200
     0.314     0.004     0.200
     0.275     0.651     0.200
     0.502    -0.120     0.200
     0.976     0.354     0.200
     0.127    -0.172     0.200
     0.345    -0.131     0.200
     0.351     0.586     0.200
     0.374    -0.404     0.200
     0.652     0.158     0.200
     0.832     1.050     0.200
     0.194    -0.295     0.200
     0.194    -0.096     0.200
     0.329    -0.763     0.200
     0.329    -0.462     0.200
     0.410    -0.539     0.200
     0.526    -0.134     0.200
     0.585    -0.114     0.200
     0.699     0.869     0.200
     0.953    -0.277     0.200
     0.953     0.422     0.200
     0.277    -0.354     0.200
     0.277    -0.554     0.200
     0.689     1.044     0.200
     0.689     0.845     0.200
     0.270     0.343     0.200
     0.295     0.182     0.200
     0.524    -0.857     0.200
     0.598    -0.055     0.200
     0.805     0.076     0.200
     0.216     0.984     0.200
     0.314    -0.080     0.200
     0.389    -0.244     0.200
     0.584    -0.138     0.200
     0.548    -0.160     0.200
     0.686     0.368     0.200
     0.951    -0.376     0.200
     0.226    -1.158     0.200
     0.226    -0.353     0.200
     0.355     0.104     0.200
     0.566     0.559     0.200
     0.605    -0.740     0.200
     0.308     0.000     0.200
     0.376    -0.124     0.200
     0.561    -0.146     0.200
     0.586    -0.355     0.200
     0.676    -0.507     0.200
     0.948     0.403     0.200
     0.267    -0.938     0.200
     0.372    -0.353     0.200
     0.524    -0.323     0.200
     0.617    -0.242     0.200
     0.159     0.015     0.200
     0.285     0.234     0.200
     0.333     1.101     0.200
     0.478    -0.653     0.200
     0.658     0.211     0.200
     0.729     0.400     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.964    -0.188     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00    0.037
 0.90    0.037
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00   -1.130
 0.90   -1.130
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.0
 0.90    0.0
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-0.9)
     0.050     7.000   Pg = red x; average =   0.0 (solid red line)
     0.050     5.000   Pn = green x; average =  -1.1 (solid green line)
     0.050    -7.500   Sg = red circles; average =   0.0 (dashed red line)
EOF
gmt end
