#!/bin/bash
gmt begin ushkan1.37_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic ushkan1.37'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.470
   135.500     1.553
   136.000     1.638
   136.500     1.726
   137.000     1.818
   137.500     1.912
   138.000     2.010
   138.500     2.112
   139.000     2.217
   139.500     2.326
   140.000     2.439
   140.500     2.556
   141.000     2.677
   141.500     2.803
   142.000     2.933
   142.500     3.068
   143.000     3.208
   143.500     3.353
   144.000     3.504
   144.500     3.660
   145.000     3.822
   145.500     3.991
   146.000     4.166
   146.500     4.347
   147.000     4.536
   147.500     4.731
   148.000     4.934
   148.500     5.145
   149.000     5.365
   149.500     5.593
   150.000     5.831
   150.500     6.079
   151.000     6.338
   151.500     6.606
   152.000     6.885
   152.500     7.174
   153.000     7.473
   153.500     7.782
   154.000     8.103
   154.500     8.434
   155.000     8.776
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.680
   145.500     0.284
   146.000     1.311
   146.500     2.381
   147.000     3.485
   147.500     4.619
   148.000     5.781
   148.500     6.967
   149.000     8.177
   149.500     9.410
   150.000    10.665
   150.500    11.941
   151.000    13.238
   151.500    14.554
   152.000    15.890
   152.500    17.243
   153.000    18.615
   153.500    20.004
   154.000    21.411
   154.500    22.835
   155.000    24.277
   155.500    25.735
   156.000    27.211
   156.500    28.703
   157.000    30.212
   157.500    31.738
   158.000    33.280
   158.500    34.839
   159.000    36.414
   159.500    38.005
   160.000    39.613
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.684
   145.500     0.081
   146.000     0.774
   146.500     1.415
   147.000     2.014
   147.500     2.573
   148.000     3.098
   148.500     3.590
   149.000     4.056
   149.500     4.501
   150.000     4.932
   150.500     5.349
   151.000     5.755
   151.500     6.152
   152.000     6.541
   152.500     6.922
   153.000     7.297
   153.500     7.669
   154.000     8.037
   154.500     8.404
   155.000     8.769
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   144.856    -0.970     0.200
   148.082    -4.718     0.200
   146.082    -1.477     0.200
   147.510     0.761     0.200
   148.253     0.634     0.200
   147.499     0.773     0.200
   142.981     0.394     0.200
   142.981     0.262     0.200
   143.049    -2.319     0.200
   147.291     0.055     0.200
   147.572     0.682     0.200
   151.060    -0.526     0.200
   147.302     0.849     0.200
   148.047     1.250     0.200
   145.871    -1.585     0.200
   147.296     0.738     0.200
   145.538    -2.237     0.200
   146.961    -0.177     0.200
   147.706     0.490     0.200
   143.102    -1.826     0.200
   145.684    -2.037     0.200
   147.109     0.097     0.200
   147.389     0.551     0.200
   147.853     0.741     0.200
   146.216    -0.797     0.200
   145.667    -1.243     0.200
   146.154    -1.035     0.200
   150.852    -0.269     0.200
   145.976    -1.404     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   147.510     2.361     0.200
   148.253     1.535     0.200
   148.253     3.535     0.200
   151.025     4.203     0.200
   150.821     3.788     0.200
   151.120     4.402     0.200
   147.929     1.487     0.200
   148.389     1.673     0.200
   151.036     3.910     0.200
   151.042     4.335     0.200
   151.028     4.012     0.200
   150.868     3.886     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   148.253     7.335     0.200
   148.253    11.435     0.200
   145.857     1.068     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   142.677     6.348     0.200
   143.674     1.590     0.200
   150.599     5.555     0.200
   147.510     4.461     0.200
   147.510     8.061     0.200
   148.244     5.245     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
