#!/bin/bash
gmt begin ushkan1.37_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P ushkan1.37'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.699
    79.000     8.525
    80.000     7.435
    81.000     6.431
    82.000     5.513
    83.000     4.679
    84.000     3.928
    85.000     3.266
    86.000     2.689
    87.000     2.189
    88.000     1.795
    89.000     1.495
    90.000     1.238
    91.000     1.011
    92.000     0.810
    93.000     0.628
    94.000     0.463
    95.000     0.318
    96.000     0.199
    97.000     0.106
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    15.506     4.798     0.200
    15.732     6.255     0.200
    17.148     0.825     0.200
    18.126     0.207     0.200
    19.836    -2.324     0.200
    22.476    -0.771     0.200
    22.837    -0.601     0.200
    22.934     1.382     0.200
    23.136     0.243     0.200
    23.241     1.739     0.200
    23.294    -1.414     0.200
    23.325     0.253     0.200
    23.334     0.161     0.200
    23.632     2.197     0.200
    24.412     0.073     0.200
    25.085     2.143     0.200
    27.167    -0.884     0.200
    27.389     2.626     0.200
    28.379     0.280     0.200
    29.126     0.642     0.200
    29.775     3.385     0.200
    30.046     0.886     0.200
    30.395     0.399     0.200
    30.963     2.388     0.200
    30.986     1.183     0.200
    31.311     1.921     0.200
    31.453     2.069     0.200
    31.530     0.394     0.200
    31.542     2.288     0.200
    32.401    -1.258     0.200
    34.163     0.864     0.200
    34.443     1.537     0.200
    34.775     2.070     0.200
    35.540     0.078     0.200
    35.823     1.052     0.200
    36.790    -0.217     0.200
    37.256     1.828     0.200
    37.351     1.422     0.200
    37.744     1.695     0.200
    37.888     3.475     0.200
    38.188     1.942     0.200
    38.267     2.275     0.200
    38.345    -1.181     0.200
    38.339     0.772     0.200
    38.464     1.621     0.200
    39.058     2.834     0.200
    39.480     0.113     0.200
    39.828     3.717     0.200
    40.309    -0.174     0.200
    40.287    -1.593     0.200
    41.053     0.079     0.200
    41.159    -0.094     0.200
    41.221     2.694     0.200
    41.464     1.506     0.200
    41.561     0.810     0.200
    41.682    -1.089     0.200
    41.682    -0.288     0.200
    41.747     2.386     0.200
    42.885     0.111     0.200
    43.146     1.201     0.200
    43.166    -0.165     0.200
    43.276     0.149     0.200
    43.318     0.613     0.200
    44.405    -0.130     0.200
    44.405     0.370     0.200
    44.490     2.192     0.200
    44.934     0.650     0.200
    45.069    -0.422     0.200
    45.208     1.071     0.200
    45.524    -1.129     0.200
    45.603    -0.654     0.200
    46.169     0.978     0.200
    46.467    -1.062     0.200
    46.531    -0.971     0.200
    47.023     1.179     0.200
    47.391     1.509     0.200
    47.785     1.448     0.200
    47.896    -0.511     0.200
    48.042     1.262     0.200
    48.307    -0.788     0.200
    48.567    -0.794     0.200
    48.762    -0.690     0.200
    48.928    -0.562     0.200
    48.900     0.651     0.200
    49.534     0.298     0.200
    49.613     1.200     0.200
    49.753    -0.667     0.200
    49.836    -0.900     0.200
    49.860     1.318     0.200
    50.026     2.059     0.200
    50.253     1.236     0.200
    50.763     1.484     0.200
    50.754     0.249     0.200
    51.250     0.821     0.200
    51.351     2.060     0.200
    51.423     2.521     0.200
    51.447     0.345     0.200
    51.485     0.061     0.200
    51.578     3.660     0.200
    51.712     1.361     0.200
    51.904     0.624     0.200
    52.050     1.844     0.200
    52.050    -2.156     0.200
    52.091    -0.467     0.200
    52.137    -2.809     0.200
    52.196     1.751     0.200
    52.320     0.233     0.200
    52.309     4.118     0.200
    52.923     0.466     0.200
    52.964     0.469     0.200
    53.780     0.868     0.200
    53.792     0.784     0.200
    53.814    -0.177     0.200
    53.906    -0.854     0.200
    53.927    -0.309     0.200
    54.112     0.640     0.200
    54.115     2.021     0.200
    54.117     0.202     0.200
    54.097    -0.246     0.200
    54.176     0.477     0.200
    54.314     0.970     0.200
    54.450     1.180     0.200
    54.473     0.316     0.200
    54.480    -0.438     0.200
    54.507     0.567     0.200
    55.020     0.849     0.200
    55.132     0.242     0.200
    55.164     0.609     0.200
    55.210     0.678     0.200
    55.305    -0.407     0.200
    55.484     1.001     0.200
    55.654     0.878     0.200
    55.741     0.854     0.200
    55.869     0.835     0.200
    55.997     0.518     0.200
    56.062     0.356     0.200
    56.209     0.005     0.200
    56.261    -0.368     0.200
    56.485     1.133     0.200
    56.668     3.333     0.200
    56.718     1.181     0.200
    56.876     0.256     0.200
    56.898     1.099     0.200
    56.928     2.091     0.200
    56.941    -0.102     0.200
    57.142     3.872     0.200
    57.157    -0.730     0.200
    57.195     0.496     0.200
    57.310     1.386     0.200
    57.333    -2.576     0.200
    57.470     0.560     0.200
    57.489    -0.477     0.200
    57.549     1.063     0.200
    57.637     0.481     0.200
    57.727     0.746     0.200
    57.819    -0.398     0.200
    57.978     1.184     0.200
    58.272    -0.173     0.200
    58.369     0.742     0.200
    58.540    -0.141     0.200
    58.593     0.385     0.200
    59.240    -0.006     0.200
    59.313     0.092     0.200
    59.357     0.388     0.200
    59.736    -2.133     0.200
    59.777    -0.109     0.200
    60.160     0.355     0.200
    60.321    -0.904     0.200
    60.438     1.053     0.200
    60.562     1.410     0.200
    60.847     1.050     0.200
    60.866     0.099     0.200
    60.913    -0.281     0.200
    60.981    -0.545     0.200
    60.992     0.585     0.200
    60.997     0.550     0.200
    61.018    -0.937     0.200
    61.249    -1.580     0.200
    61.275    -0.625     0.200
    61.295    -0.573     0.200
    61.365     1.053     0.200
    61.381     0.545     0.200
    61.387    -0.499     0.200
    61.411     0.300     0.200
    61.461    -0.598     0.200
    61.569    -0.528     0.200
    61.570    -0.980     0.200
    61.636    -1.430     0.200
    61.649     0.127     0.200
    61.695    -1.177     0.200
    61.716    -1.317     0.200
    61.880    -0.120     0.200
    61.972    -0.843     0.200
    62.355    -0.105     0.200
    62.462    -0.224     0.200
    62.519    -0.702     0.200
    62.792    -0.627     0.200
    63.251    -0.473     0.200
    63.578     0.261     0.200
    64.160     0.128     0.200
    65.835    -0.465     0.200
    68.809    -0.710     0.200
    69.352    -1.080     0.200
    69.877    -0.016     0.200
    70.281    -0.293     0.200
    70.821    -0.087     0.200
    70.899     0.133     0.200
    71.070     0.095     0.200
    71.243     1.250     0.200
    72.327     0.533     0.200
    74.625     0.307     0.200
    76.365     0.521     0.200
    76.694    -0.138     0.200
    76.697    -0.056     0.200
    77.332    -0.628     0.200
    77.349     0.776     0.200
    78.226     0.587     0.200
    78.248    -0.633     0.200
    78.402    -0.082     0.200
    78.689    -0.667     0.200
    79.891     1.070     0.200
    79.935     1.533     0.200
    80.152     0.559     0.200
    80.170     0.061     0.200
    80.617     1.058     0.200
    81.403     1.172     0.200
    81.884    -0.869     0.200
    82.236     1.083     0.200
    82.991     1.352     0.200
    83.324     0.629     0.200
    84.144     0.428     0.200
    85.212     0.039     0.200
    85.525     0.480     0.200
    86.404     1.228     0.200
    86.407     1.513     0.200
    86.597     0.883     0.200
    86.686    -0.155     0.200
    87.008    -0.229     0.200
    87.875     0.596     0.200
    88.069     0.073     0.200
    88.305     0.057     0.200
    88.559     0.855     0.200
    90.170     0.205     0.200
    90.339     0.619     0.200
    14.261    10.277     0.200
    15.614     6.135     0.200
    15.661     4.530     0.200
    19.494     0.603     0.200
    22.401     0.714     0.200
    25.614     1.292     0.200
    30.889     1.039     0.200
    31.132     1.576     0.200
    31.224     1.765     0.200
    31.453     1.133     0.200
    31.578     1.391     0.200
    31.661     1.683     0.200
    31.687     0.297     0.200
    31.884     1.434     0.200
    31.993     1.293     0.200
    32.094     1.622     0.200
    32.219     1.299     0.200
    32.232     1.602     0.200
    32.397     1.266     0.200
    32.548     0.686     0.200
    36.027    -0.360     0.200
    39.530    -1.670     0.200
    42.346    -1.680     0.200
    42.764    -0.773     0.200
    43.813     0.049     0.200
    43.819     0.807     0.200
    43.830     0.113     0.200
    45.140    -1.055     0.200
    46.003    -1.290     0.200
    47.815    -0.126     0.200
    48.954    -0.842     0.200
    48.954    -1.244     0.200
    55.991    -0.118     0.200
    59.140    -2.001     0.200
    59.140    -2.302     0.200
    71.135    -0.397     0.200
    71.977    -1.070     0.200
    78.259    -0.998     0.200
    92.475     0.402     0.200
    20.555    -1.757     0.200
    48.545    -1.890     0.200
    48.981    -0.492     0.200
    59.769    -1.857     0.200
    79.746    -0.977     0.200
    15.076     5.890     0.200
    17.882     1.500     0.200
    20.488    -1.427     0.200
    20.488    -1.575     0.200
    22.269    -0.639     0.200
    22.624     0.677     0.200
    23.395    -1.102     0.200
    35.541     0.268     0.200
    42.230    -1.052     0.200
    42.230    -0.326     0.200
    48.921     0.063     0.200
    59.702    -2.200     0.200
    76.344    -0.270     0.200
    79.807    -0.203     0.200
    15.315     6.631     0.200
    16.406     1.800     0.200
    16.759     5.026     0.200
    17.743     1.234     0.200
    18.017     0.953     0.200
    18.486    -1.486     0.200
    18.486    -1.845     0.200
    20.249    -1.080     0.200
    22.608    -1.583     0.200
    22.660    -2.787     0.200
    22.864     1.646     0.200
    23.430    -2.725     0.200
    24.235    -0.830     0.200
    24.472    -0.188     0.200
    24.947     0.181     0.200
    24.947    -0.623     0.200
    30.410    -1.058     0.200
    30.537     2.317     0.200
    30.637     1.732     0.200
    30.886     1.538     0.200
    30.962     1.275     0.200
    31.601     1.437     0.200
    39.043    -1.140     0.200
    39.289    -0.925     0.200
    40.261    -2.422     0.200
    42.142    -0.918     0.200
    42.142    -0.394     0.200
    46.377    -1.536     0.200
    48.389    -0.776     0.200
    48.389    -0.854     0.200
    48.685    -0.155     0.200
    50.871     1.008     0.200
    55.291     0.585     0.200
    59.463    -1.673     0.200
    71.935    -1.236     0.200
    76.503    -0.496     0.200
    78.667    -0.490     0.200
    89.234    -0.377     0.200
    92.886    -0.725     0.200
    16.884     4.542     0.200
    18.684    -3.096     0.200
    18.684    -2.356     0.200
    22.564    -2.212     0.200
    22.799     2.593     0.200
    22.820    -1.928     0.200
    22.820    -1.591     0.200
    22.871    -1.476     0.200
    23.144     0.715     0.200
    23.636     1.379     0.200
    23.642    -1.777     0.200
    24.056    -0.059     0.200
    24.297    -0.556     0.200
    24.392     1.675     0.200
    25.114    -0.702     0.200
    25.114    -0.171     0.200
    27.190     1.120     0.200
    27.190     1.120     0.200
    28.503    -0.622     0.200
    28.503    -0.932     0.200
    30.369    -0.072     0.200
    30.369    -0.212     0.200
    30.321    -1.043     0.200
    30.688     1.417     0.200
    30.920    -0.536     0.200
    30.920    -0.536     0.200
    30.942     1.775     0.200
    31.022     1.268     0.200
    31.173     1.635     0.200
    31.667     1.390     0.200
    36.656    -0.680     0.200
    39.235    -1.501     0.200
    39.497    -0.545     0.200
    40.478    -0.697     0.200
    40.738     0.386     0.200
    41.941    -1.330     0.200
    42.351    -1.173     0.200
    43.186     0.050     0.200
    43.187     0.037     0.200
    45.607     0.087     0.200
    46.595    -0.932     0.200
    48.169    -1.856     0.200
    48.592    -1.223     0.200
    48.592    -0.898     0.200
    48.665     0.215     0.200
    49.251     2.417     0.200
    50.179    -1.097     0.200
    50.566     0.820     0.200
    50.567     0.115     0.200
    50.579     0.822     0.200
    51.084     1.213     0.200
    51.085     0.397     0.200
    51.232     0.807     0.200
    52.425    -1.496     0.200
    53.231     0.641     0.200
    53.242     0.767     0.200
    53.750     1.334     0.200
    53.798     0.969     0.200
    53.924     0.958     0.200
    53.944     0.812     0.200
    54.005     0.170     0.200
    54.146    -0.464     0.200
    54.323     0.449     0.200
    54.342     0.211     0.200
    55.240    -1.499     0.200
    55.368    -0.219     0.200
    55.506    -0.054     0.200
    56.085     0.629     0.200
    56.085     0.629     0.200
    59.488    -1.642     0.200
    60.688     0.877     0.200
    61.202    -0.117     0.200
    61.207     0.049     0.200
    61.947    -1.649     0.200
    61.970    -1.603     0.200
    62.049    -0.434     0.200
    63.146    -1.608     0.200
    63.755    -1.186     0.200
    66.060    -0.897     0.200
    66.420    -1.158     0.200
    66.727    -0.406     0.200
    67.035    -0.483     0.200
    67.460    -0.905     0.200
    68.537    -0.258     0.200
    69.105    -1.555     0.200
    69.989    -1.995     0.200
    70.063    -3.038     0.200
    70.688    -0.007     0.200
    70.688     0.320     0.200
    72.047    -1.239     0.200
    72.445    -0.895     0.200
    72.544    -0.056     0.200
    72.799    -0.676     0.200
    73.463     0.559     0.200
    73.590    -0.769     0.200
    73.698     0.545     0.200
    73.820     0.503     0.200
    73.836     1.118     0.200
    74.017    -1.861     0.200
    74.406     0.478     0.200
    74.453     0.613     0.200
    74.623    -1.608     0.200
    75.421     0.527     0.200
    76.241     0.002     0.200
    76.323     0.760     0.200
    76.329    -0.591     0.200
    76.332    -0.493     0.200
    76.593     0.267     0.200
    78.669    -0.363     0.200
    79.161     1.016     0.200
    79.800    -0.044     0.200
    79.863    -0.214     0.200
    83.559     1.112     0.200
    89.450    -0.108     0.200
    92.887     0.634     0.200
    15.326     6.350     0.200
    16.430     2.058     0.200
    16.753     1.966     0.200
    17.760     1.892     0.200
    22.277    -1.449     0.200
    22.586    -1.178     0.200
    23.408    -1.728     0.200
    23.748    -1.915     0.200
    24.472     1.182     0.200
    28.713     1.846     0.200
    30.541     1.249     0.200
    30.642     1.661     0.200
    30.686    -0.105     0.200
    30.686    -0.105     0.200
    30.889     1.076     0.200
    30.965     1.513     0.200
    31.604     1.578     0.200
    39.016    -0.779     0.200
    42.115    -0.727     0.200
    46.352    -1.193     0.200
    48.362    -1.495     0.200
    48.362    -0.644     0.200
    48.677    -0.125     0.200
    50.849     0.209     0.200
    55.264    -0.020     0.200
    59.450    -1.519     0.200
    71.913    -1.135     0.200
    76.529    -0.552     0.200
    79.997    -0.086     0.200
    89.211     0.071     0.200
    14.032     6.721     0.200
    28.342    -1.226     0.200
    76.376    -0.642     0.200
    76.376    -1.877     0.200
    79.842    -0.050     0.200
    17.758     0.158     0.200
    18.235    -0.282     0.200
    20.379    -1.346     0.200
    22.375     0.075     0.200
    24.699     2.284     0.200
    59.603    -1.549     0.200
    76.565    -0.186     0.200
    80.026     0.132     0.200
    14.677     9.446     0.200
    16.652     3.423     0.200
    17.510     3.856     0.200
    18.501    -2.922     0.200
    18.501    -1.125     0.200
    18.501    -2.820     0.200
    18.501    -3.031     0.200
    18.501    -2.367     0.200
    18.586    -2.062     0.200
    20.475    -1.311     0.200
    20.475    -1.600     0.200
    20.798     0.493     0.200
    22.510     1.025     0.200
    22.668    -1.712     0.200
    22.629     2.057     0.200
    22.720    -0.601     0.200
    22.720    -1.905     0.200
    22.720    -2.296     0.200
    22.720    -1.296     0.200
    22.711     1.291     0.200
    22.711     1.775     0.200
    23.015     2.788     0.200
    23.131     3.050     0.200
    24.023     0.521     0.200
    24.080     1.051     0.200
    24.080     0.707     0.200
    24.115     0.993     0.200
    24.520     1.481     0.200
    24.530     0.886     0.200
    24.626     0.327     0.200
    24.620     1.481     0.200
    24.709     0.475     0.200
    24.798     2.184     0.200
    24.898     1.348     0.200
    24.898     0.363     0.200
    24.898     0.645     0.200
    24.898     0.746     0.200
    24.898     1.543     0.200
    25.136     2.252     0.200
    25.136     1.619     0.200
    25.227    -0.449     0.200
    25.306     1.326     0.200
    25.306     0.998     0.200
    25.677     1.417     0.200
    25.677     0.738     0.200
    26.130     3.368     0.200
    26.625     2.392     0.200
    26.625     1.392     0.200
    26.627    -0.273     0.200
    26.837     3.188     0.200
    27.182     0.279     0.200
    28.392    -0.639     0.200
    28.392    -0.842     0.200
    28.392    -1.194     0.200
    28.462     3.034     0.200
    28.614    -0.223     0.200
    29.017    -0.132     0.200
    29.317     3.033     0.200
    29.586    -1.145     0.200
    29.586     0.441     0.200
    30.162    -0.875     0.200
    30.192     1.242     0.200
    30.596    -0.077     0.200
    30.596     0.079     0.200
    30.771    -0.195     0.200
    30.771    -0.202     0.200
    30.782     1.551     0.200
    30.928     1.236     0.200
    31.656     0.861     0.200
    33.476    -1.278     0.200
    33.829     0.758     0.200
    34.042     0.321     0.200
    34.031     2.603     0.200
    34.213     1.623     0.200
    34.473    -0.240     0.200
    34.822     0.574     0.200
    35.200     1.090     0.200
    35.200    -0.214     0.200
    35.549     1.015     0.200
    35.549     0.281     0.200
    36.595    -1.768     0.200
    36.718     0.114     0.200
    36.729     2.388     0.200
    37.591     1.767     0.200
    38.110     0.380     0.200
    38.281     0.591     0.200
    38.673    -0.561     0.200
    38.921    -0.305     0.200
    38.925     0.194     0.200
    39.242    -0.926     0.200
    39.242     1.886     0.200
    39.460     0.859     0.200
    39.458    -2.128     0.200
    39.516    -0.406     0.200
    39.692    -1.178     0.200
    40.214     0.229     0.200
    40.389    -1.067     0.200
    40.325     3.975     0.200
    40.680    -1.776     0.200
    40.964     0.429     0.200
    40.962    -0.602     0.200
    41.227    -1.783     0.200
    41.904    -0.933     0.200
    42.311    -0.321     0.200
    42.724     3.491     0.200
    43.031    -0.897     0.200
    43.036     1.257     0.200
    43.036    -0.539     0.200
    43.036     0.734     0.200
    43.036     1.687     0.200
    43.177     0.332     0.200
    43.186     0.937     0.200
    43.304     0.532     0.200
    43.476    -0.801     0.200
    44.174     1.291     0.200
    44.174    -0.108     0.200
    44.174     2.088     0.200
    44.357    -0.679     0.200
    44.746    -1.075     0.200
    44.975    -0.312     0.200
    45.048    -3.192     0.200
    45.131    -0.682     0.200
    45.284    -0.238     0.200
    45.336     2.522     0.200
    45.359    -0.411     0.200
    45.539    -1.289     0.200
    45.989    -1.645     0.200
    46.306    -0.563     0.200
    46.498    -0.923     0.200
    46.498    -1.048     0.200
    46.498    -1.251     0.200
    46.510    -1.448     0.200
    46.781     0.431     0.200
    47.313     1.772     0.200
    47.573     0.451     0.200
    47.574    -0.490     0.200
    47.574    -0.654     0.200
    47.910    -0.588     0.200
    48.021     1.085     0.200
    48.214     0.495     0.200
    48.143     2.403     0.200
    48.267     0.191     0.200
    48.282     0.372     0.200
    48.499    -0.110     0.200
    48.554     0.154     0.200
    48.572    -0.269     0.200
    48.572    -0.870     0.200
    48.818    -2.595     0.200
    48.851    -0.619     0.200
    48.945    -1.642     0.200
    49.508     0.560     0.200
    49.661     0.177     0.200
    49.691    -0.546     0.200
    50.150    -0.327     0.200
    50.120     0.430     0.200
    50.170     0.673     0.200
    50.252    -0.252     0.200
    50.383    -1.051     0.200
    50.383    -0.598     0.200
    50.455    -0.510     0.200
    50.465     0.385     0.200
    50.465    -0.014     0.200
    50.478     0.783     0.200
    50.478     0.065     0.200
    50.719    -0.458     0.200
    50.832     0.541     0.200
    50.939     0.639     0.200
    50.939    -0.245     0.200
    50.939     1.107     0.200
    51.003    -1.265     0.200
    51.152    -1.203     0.200
    51.142     0.183     0.200
    51.291     0.066     0.200
    51.350    -0.983     0.200
    51.325     1.305     0.200
    51.351     0.110     0.200
    51.367    -0.301     0.200
    51.671     0.119     0.200
    51.768    -0.801     0.200
    51.790     0.445     0.200
    51.822     0.884     0.200
    52.197     0.039     0.200
    52.302     1.014     0.200
    52.336    -0.450     0.200
    52.337     0.461     0.200
    52.612     1.011     0.200
    52.847     0.796     0.200
    52.847    -0.125     0.200
    52.948    -0.187     0.200
    52.948     0.532     0.200
    53.006     0.030     0.200
    53.006     0.905     0.200
    53.006     0.804     0.200
    53.159     1.075     0.200
    53.157     0.487     0.200
    53.190     1.849     0.200
    53.317     0.615     0.200
    53.519    -0.867     0.200
    53.721    -0.752     0.200
    53.876     1.014     0.200
    53.939     0.248     0.200
    53.939    -0.056     0.200
    54.018    -0.725     0.200
    54.084    -0.008     0.200
    54.084    -0.109     0.200
    54.253     1.458     0.200
    54.267     0.852     0.200
    54.514     0.440     0.200
    54.592     0.397     0.200
    54.785     1.793     0.200
    54.922     0.600     0.200
    55.074     1.199     0.200
    55.178     0.049     0.200
    55.178     0.549     0.200
    55.297     0.298     0.200
    55.297     0.103     0.200
    55.434     0.402     0.200
    55.434    -0.621     0.200
    55.434    -0.582     0.200
    55.508     0.969     0.200
    55.621     0.961     0.200
    55.643    -0.662     0.200
    55.760    -0.140     0.200
    55.799     0.383     0.200
    56.021     0.991     0.200
    56.021     0.991     0.200
    56.281    -0.110     0.200
    56.475    -0.240     0.200
    56.586     0.059     0.200
    56.638     1.486     0.200
    56.833     1.081     0.200
    56.924     0.561     0.200
    57.065     1.058     0.200
    57.613     0.591     0.200
    57.613     0.693     0.200
    57.924     1.109     0.200
    58.035    -0.376     0.200
    58.187     0.016     0.200
    58.331     0.757     0.200
    58.331     0.273     0.200
    58.629    -0.323     0.200
    58.717     0.592     0.200
    58.734     1.883     0.200
    58.757    -0.123     0.200
    58.810     1.013     0.200
    58.931    -0.524     0.200
    58.954     1.315     0.200
    58.954     0.315     0.200
    58.987     0.625     0.200
    59.005    -1.434     0.200
    59.339     1.445     0.200
    59.385    -0.275     0.200
    59.479    -0.320     0.200
    59.685    -1.793     0.200
    59.702    -0.064     0.200
    59.738     1.494     0.200
    60.171     0.523     0.200
    60.626     0.005     0.200
    60.715     0.470     0.200
    61.135     0.346     0.200
    61.140     0.313     0.200
    61.157    -0.802     0.200
    61.471    -0.634     0.200
    61.505    -0.464     0.200
    61.632    -0.517     0.200
    61.704    -0.207     0.200
    61.703    -0.198     0.200
    61.744    -0.578     0.200
    61.905    -1.163     0.200
    61.930    -1.225     0.200
    61.982     0.124     0.200
    62.028    -0.488     0.200
    62.149    -0.391     0.200
    62.549     2.825     0.200
    62.596    -0.086     0.200
    62.634    -0.544     0.200
    62.640    -0.383     0.200
    62.870    -0.417     0.200
    63.200    -0.902     0.200
    63.435    -1.062     0.200
    63.446    -0.441     0.200
    63.568     0.457     0.200
    63.718    -0.739     0.200
    63.747     0.478     0.200
    63.789     0.398     0.200
    64.337     0.296     0.200
    64.895     0.353     0.200
    66.001    -0.207     0.200
    66.515    -0.206     0.200
    66.818    -1.459     0.200
    67.205     0.943     0.200
    67.519     0.709     0.200
    67.538     1.186     0.200
    67.759     0.892     0.200
    68.257     0.112     0.200
    68.281    -0.288     0.200
    68.843     0.706     0.200
    68.871    -0.867     0.200
    68.871    -2.430     0.200
    69.436    -0.780     0.200
    69.436    -0.577     0.200
    69.471    -0.568     0.200
    69.580    -0.749     0.200
    69.825     0.985     0.200
    69.935     1.344     0.200
    70.016     2.848     0.200
    70.085    -0.200     0.200
    70.136    -0.243     0.200
    70.223     0.448     0.200
    70.267     0.749     0.200
    70.631     0.240     0.200
    70.631     0.740     0.200
    70.631     0.474     0.200
    70.646     0.412     0.200
    70.795     1.487     0.200
    70.841     0.535     0.200
    70.904     1.127     0.200
    70.906     0.205     0.200
    70.913     0.362     0.200
    70.910    -2.111     0.200
    71.080     1.020     0.200
    71.103     0.861     0.200
    71.224     0.656     0.200
    71.259     0.494     0.200
    71.283     0.857     0.200
    71.298     0.395     0.200
    71.513     0.712     0.200
    71.499     1.716     0.200
    71.615     0.482     0.200
    71.638     0.873     0.200
    71.630     0.137     0.200
    71.677    -0.582     0.200
    71.734     1.006     0.200
    71.737     0.438     0.200
    71.749     0.633     0.200
    71.771     1.079     0.200
    71.863     0.928     0.200
    71.897    -1.069     0.200
    72.030     0.559     0.200
    72.112    -0.068     0.200
    72.132     0.467     0.200
    72.173    -1.062     0.200
    72.173    -1.327     0.200
    72.194     0.278     0.200
    72.297    -0.340     0.200
    72.335     0.698     0.200
    72.359     0.350     0.200
    72.383     0.505     0.200
    72.565    -0.722     0.200
    72.586     0.771     0.200
    72.631    -0.386     0.200
    72.643     0.753     0.200
    72.651     0.610     0.200
    72.666     1.036     0.200
    72.710     0.540     0.200
    72.739     0.594     0.200
    72.749    -0.532     0.200
    72.871    -0.307     0.200
    72.922     0.442     0.200
    72.950    -0.225     0.200
    72.952     0.599     0.200
    72.957     0.727     0.200
    72.980     0.394     0.200
    73.004     0.337     0.200
    73.091    -0.196     0.200
    73.116    -0.457     0.200
    73.200     0.457     0.200
    73.244     0.512     0.200
    73.276     0.781     0.200
    73.294     0.412     0.200
    73.358     1.168     0.200
    73.375     0.833     0.200
    73.409     1.005     0.200
    73.428    -0.034     0.200
    73.445     0.006     0.200
    73.519     0.365     0.200
    73.618    -0.395     0.200
    73.641    -0.193     0.200
    73.664     0.391     0.200
    73.663     0.526     0.200
    73.692     0.772     0.200
    73.714     0.644     0.200
    73.749     0.885     0.200
    73.778     0.792     0.200
    73.806     0.440     0.200
    73.890     0.898     0.200
    73.910     0.345     0.200
    73.965    -0.270     0.200
    73.965    -0.418     0.200
    74.030     0.304     0.200
    74.061    -0.466     0.200
    74.100     0.592     0.200
    74.121     0.158     0.200
    74.139     0.638     0.200
    74.189     0.246     0.200
    74.335     0.723     0.200
    74.400    -0.126     0.200
    74.414     0.330     0.200
    74.492     0.126     0.200
    74.504     0.369     0.200
    74.522    -0.040     0.200
    74.528     1.192     0.200
    74.615     0.101     0.200
    74.641     1.130     0.200
    74.650     0.296     0.200
    74.717     0.110     0.200
    74.723     0.935     0.200
    74.738    -0.036     0.200
    74.806    -1.062     0.200
    74.821     0.433     0.200
    74.776     3.236     0.200
    74.892    -0.097     0.200
    74.999     0.611     0.200
    75.083     0.051     0.200
    75.111     0.341     0.200
    75.210     0.257     0.200
    75.225     0.481     0.200
    75.254     0.384     0.200
    75.269     0.236     0.200
    75.317     1.069     0.200
    75.367     1.264     0.200
    75.399    -0.027     0.200
    75.491     0.508     0.200
    75.517     0.423     0.200
    75.521     0.208     0.200
    75.597     0.316     0.200
    75.633     0.758     0.200
    75.677     0.400     0.200
    75.692     0.245     0.200
    75.704    -0.090     0.200
    75.843     0.492     0.200
    75.872     0.871     0.200
    75.933     0.361     0.200
    75.940     0.511     0.200
    76.048     0.854     0.200
    76.051     0.002     0.200
    76.089     0.669     0.200
    76.119     0.760     0.200
    76.193     0.841     0.200
    76.300     0.696     0.200
    76.300     0.673     0.200
    76.302     0.900     0.200
    76.281    -0.188     0.200
    76.281    -0.587     0.200
    76.428     0.583     0.200
    76.452     0.709     0.200
    76.504     0.297     0.200
    76.517    -0.013     0.200
    76.619     0.626     0.200
    76.667    -0.277     0.200
    76.669     0.835     0.200
    76.690     0.506     0.200
    76.698    -1.472     0.200
    76.733     0.624     0.200
    76.806     1.215     0.200
    76.910     0.850     0.200
    76.944     0.855     0.200
    76.956     1.041     0.200
    76.967     2.187     0.200
    76.983     2.236     0.200
    77.091     1.699     0.200
    77.312     1.200     0.200
    77.422     1.156     0.200
    77.428     1.144     0.200
    77.448     1.118     0.200
    77.474     1.200     0.200
    77.529     1.564     0.200
    77.578     1.034     0.200
    77.561     1.200     0.200
    77.657     1.320     0.200
    77.663     1.440     0.200
    77.805     1.026     0.200
    77.819     1.609     0.200
    77.829     1.284     0.200
    77.830     1.360     0.200
    77.845     0.629     0.200
    77.900     1.362     0.200
    77.906     1.401     0.200
    77.942     0.982     0.200
    77.965     0.392     0.200
    78.004     1.057     0.200
    78.034     1.376     0.200
    78.082     0.657     0.200
    78.099     1.342     0.200
    78.216     1.609     0.200
    78.230     1.545     0.200
    78.241     1.117     0.200
    78.339     0.852     0.200
    78.444     0.467     0.200
    78.481     1.213     0.200
    78.509     0.403     0.200
    78.524     1.133     0.200
    78.640     1.308     0.200
    78.766     0.683     0.200
    78.797     0.479     0.200
    78.803     1.376     0.200
    78.810     1.151     0.200
    78.863     0.743     0.200
    78.878    -0.365     0.200
    78.878    -0.349     0.200
    78.995     1.219     0.200
    78.995     1.336     0.200
    79.020    -0.215     0.200
    79.027     1.360     0.200
    79.032    -0.147     0.200
    79.038     0.760     0.200
    79.122     0.368     0.200
    79.243     0.632     0.200
    79.257     0.930     0.200
    79.257     0.594     0.200
    79.312    -0.234     0.200
    79.374     0.549     0.200
    79.408     1.602     0.200
    79.448     1.275     0.200
    79.523     0.155     0.200
    79.550     0.007     0.200
    79.577     0.760     0.200
    79.619     1.033     0.200
    79.623     0.472     0.200
    79.644     0.820     0.200
    79.696     0.333     0.200
    79.745     0.542     0.200
    79.759     0.317     0.200
    79.775     1.780     0.200
    79.775     0.006     0.200
    79.752    -0.018     0.200
    79.918     0.207     0.200
    79.939     1.060     0.200
    79.974     0.319     0.200
    79.986     1.028     0.200
    80.073     0.914     0.200
    80.085     0.199     0.200
    80.159     0.254     0.200
    80.078     2.967     0.200
    80.200     0.489     0.200
    80.219    -0.164     0.200
    80.292     0.876     0.200
    80.292     0.407     0.200
    80.319     0.988     0.200
    80.331    -1.134     0.200
    80.382     0.522     0.200
    80.441     0.692     0.200
    80.503     0.074     0.200
    80.555    -0.233     0.200
    80.591     0.808     0.200
    80.612     0.952     0.200
    80.612     1.355     0.200
    80.679     0.740     0.200
    80.706     0.956     0.200
    80.720    -0.036     0.200
    80.738     0.872     0.200
    80.765     0.904     0.200
    80.899     0.739     0.200
    80.917     1.265     0.200
    80.948     0.153     0.200
    80.976    -1.099     0.200
    81.028     0.808     0.200
    81.031     1.079     0.200
    81.044     0.868     0.200
    81.065     0.743     0.200
    81.084     0.602     0.200
    81.129     0.736     0.200
    81.181     1.124     0.200
    81.250     0.702     0.200
    81.288     0.525     0.200
    81.303     0.625     0.200
    81.339     0.373     0.200
    81.342     1.424     0.200
    81.520     0.809     0.200
    81.548     0.770     0.200
    81.582     0.498     0.200
    81.585     0.834     0.200
    81.648     0.905     0.200
    81.687     0.434     0.200
    81.698     1.426     0.200
    81.766     0.970     0.200
    81.825     0.809     0.200
    81.945     0.355     0.200
    81.965     0.778     0.200
    81.980     0.453     0.200
    81.980     0.023     0.200
    81.999     1.322     0.200
    82.030     0.663     0.200
    82.104     0.063     0.200
    82.120     1.342     0.200
    82.209     1.048     0.200
    82.236     0.625     0.200
    82.255     0.535     0.200
    82.275     1.562     0.200
    82.348     0.659     0.200
    82.349     1.179     0.200
    82.275    -0.320     0.200
    82.407     0.750     0.200
    82.453     1.055     0.200
    82.497     0.745     0.200
    82.563     0.050     0.200
    82.576     1.171     0.200
    82.701     1.307     0.200
    82.710     0.208     0.200
    82.739     1.684     0.200
    82.771     0.358     0.200
    82.836    -0.106     0.200
    82.844     1.019     0.200
    82.845     1.035     0.200
    82.895     1.392     0.200
    82.930     1.176     0.200
    83.064     1.152     0.200
    83.072     1.125     0.200
    83.085     0.841     0.200
    83.110     0.774     0.200
    83.118    -0.052     0.200
    83.242     0.780     0.200
    83.258     0.562     0.200
    83.350    -0.786     0.200
    83.374     0.685     0.200
    83.376     0.800     0.200
    83.418     0.940     0.200
    83.450     0.345     0.200
    83.456     0.779     0.200
    83.460     1.102     0.200
    83.526     0.939     0.200
    83.563     0.672     0.200
    83.642    -0.170     0.200
    83.652    -0.005     0.200
    83.707     1.090     0.200
    83.877     1.338     0.200
    83.905     0.168     0.200
    83.999     0.299     0.200
    84.071     0.495     0.200
    84.117     1.219     0.200
    84.256     0.716     0.200
    84.285     0.930     0.200
    84.336     0.415     0.200
    84.336     0.751     0.200
    84.371     1.354     0.200
    84.502     1.119     0.200
    84.533     0.937     0.200
    84.535     0.629     0.200
    84.546     0.271     0.200
    84.602     0.934     0.200
    84.663     0.622     0.200
    84.670     0.645     0.200
    84.763     0.668     0.200
    84.980     0.185     0.200
    85.031     1.163     0.200
    85.033     1.028     0.200
    85.033    -0.065     0.200
    85.059     1.388     0.200
    85.065     0.423     0.200
    85.105     0.485     0.200
    85.118     1.001     0.200
    85.241     0.448     0.200
    85.300     0.777     0.200
    85.371     1.273     0.200
    85.379     0.896     0.200
    85.506     1.092     0.200
    85.436     3.023     0.200
    85.564     0.615     0.200
    85.614     0.883     0.200
    85.658     0.456     0.200
    85.704     1.359     0.200
    85.728     0.983     0.200
    85.792     0.975     0.200
    85.893     0.545     0.200
    85.901     0.843     0.200
    85.909     0.793     0.200
    85.954     0.859     0.200
    86.000     0.883     0.200
    86.021     1.022     0.200
    86.023     1.386     0.200
    86.145     0.652     0.200
    86.161     0.648     0.200
    86.274     0.523     0.200
    86.325    -0.941     0.200
    86.362     0.896     0.200
    86.388     0.663     0.200
    86.406     0.290     0.200
    86.411     1.007     0.200
    86.506     1.232     0.200
    86.685     0.808     0.200
    86.767     0.852     0.200
    86.817     1.426     0.200
    86.879     1.330     0.200
    86.919     1.070     0.200
    86.960     0.051     0.200
    87.034     0.339     0.200
    87.078     0.749     0.200
    87.081     1.000     0.200
    87.118     1.405     0.200
    87.132     1.664     0.200
    87.288     1.402     0.200
    87.328     0.380     0.200
    87.345     0.843     0.200
    87.348     1.769     0.200
    87.443     1.394     0.200
    87.634     0.742     0.200
    87.645     0.946     0.200
    87.717     1.209     0.200
    87.730     1.045     0.200
    87.833     1.339     0.200
    87.833     0.665     0.200
    87.841     0.433     0.200
    87.925     0.565     0.200
    88.098     0.693     0.200
    88.118     1.258     0.200
    88.131     0.814     0.200
    88.130     0.980     0.200
    88.226     0.649     0.200
    88.278     0.641     0.200
    88.470     1.005     0.200
    88.485     0.534     0.200
    88.632     1.328     0.200
    88.659     1.420     0.200
    88.676     0.872     0.200
    88.722     1.434     0.200
    88.858     1.124     0.200
    88.902     0.907     0.200
    88.932     0.565     0.200
    88.947     1.033     0.200
    88.952     0.609     0.200
    89.085     0.924     0.200
    89.036    -1.395     0.200
    89.189     0.788     0.200
    89.234     0.753     0.200
    89.255     0.572     0.200
    89.262     1.124     0.200
    89.293     0.289     0.200
    89.320     0.701     0.200
    89.320     0.467     0.200
    89.392     0.554     0.200
    89.424     0.972     0.200
    89.457     0.265     0.200
    89.505     0.749     0.200
    89.518     0.643     0.200
    89.551     0.190     0.200
    89.571    -0.300     0.200
    89.571    -0.550     0.200
    89.571    -0.682     0.200
    89.686     0.348     0.200
    89.788     0.837     0.200
    89.991     0.875     0.200
    90.810     0.997     0.200
    91.139     0.415     0.200
    91.356     0.954     0.200
    91.738     0.724     0.200
    92.049     0.747     0.200
    92.293     0.800     0.200
    92.346     0.632     0.200
    92.758     0.032     0.200
    93.062     0.623     0.200
    93.097    -0.436     0.200
    93.168     0.417     0.200
    17.983     0.341     0.200
    17.983     0.017     0.200
    17.983     0.841     0.200
    18.599    -1.139     0.200
    22.681     0.316     0.200
    24.092     0.339     0.200
    50.952     1.666     0.200
    79.744    -0.140     0.200
    17.299     1.170     0.200
    17.803     1.415     0.200
    17.889     0.345     0.200
    20.654    -1.005     0.200
    21.982    -1.194     0.200
    22.034     0.848     0.200
    76.631    -0.619     0.200
    80.081     0.241     0.200
    48.887     0.066     0.200
    76.287    -0.659     0.200
    18.824    -0.226     0.200
    19.257    -0.567     0.200
    19.344    -1.507     0.200
    23.320     1.446     0.200
    23.371     2.714     0.200
    23.371    -0.388     0.200
    25.755     3.557     0.200
    48.086     0.649     0.200
    17.971     0.352     0.200
    22.636     0.962     0.200
    24.899     1.718     0.200
    76.358    -0.101     0.200
    79.824     0.166     0.200
    22.643    -1.113     0.200
    22.695    -0.165     0.200
    24.901     1.742     0.200
    24.901    -0.214     0.200
    30.554     1.408     0.200
    42.260    -0.141     0.200
    76.347    -1.116     0.200
    79.812    -0.255     0.200
    89.289    -0.691     0.200
    15.113     6.179     0.200
    16.311     2.102     0.200
    16.659     4.970     0.200
    17.522     5.756     0.200
    18.503    -2.495     0.200
    18.588    -1.581     0.200
    19.261    -0.618     0.200
    20.464    -1.332     0.200
    20.464    -1.136     0.200
    20.780     0.474     0.200
    20.804     0.571     0.200
    20.804     0.524     0.200
    21.467     0.726     0.200
    22.520     0.868     0.200
    22.667    -1.246     0.200
    22.720     0.350     0.200
    22.720    -1.361     0.200
    24.085     0.006     0.200
    24.617    -1.071     0.200
    24.903    -0.056     0.200
    26.848     1.825     0.200
    26.987     2.881     0.200
    26.987     1.076     0.200
    27.179     0.650     0.200
    28.389     0.332     0.200
    28.389    -0.558     0.200
    28.474     3.874     0.200
    30.162    -0.524     0.200
    30.585     0.056     0.200
    34.224     1.367     0.200
    35.561     0.616     0.200
    36.590    -2.682     0.200
    37.067    -0.545     0.200
    39.234    -1.732     0.200
    40.385     0.412     0.200
    42.304    -2.105     0.200
    43.035     2.309     0.200
    43.048    -1.274     0.200
    43.470    -0.505     0.200
    43.439     1.850     0.200
    45.537    -1.832     0.200
    46.295    -0.507     0.200
    46.495    -1.183     0.200
    46.507    -0.771     0.200
    48.488    -0.478     0.200
    48.647     0.425     0.200
    48.564    -0.565     0.200
    48.564    -2.010     0.200
    48.873     0.680     0.200
    48.873    -0.984     0.200
    50.526     0.165     0.200
    50.462    -0.169     0.200
    50.460     0.561     0.200
    50.778     0.967     0.200
    50.893     1.499     0.200
    50.938    -0.442     0.200
    51.138    -1.045     0.200
    51.356    -1.081     0.200
    51.440     1.996     0.200
    52.220     1.172     0.200
    53.154     0.556     0.200
    53.154    -0.139     0.200
    53.153     0.769     0.200
    54.079    -0.124     0.200
    55.292     1.178     0.200
    55.429    -1.054     0.200
    55.412    -0.015     0.200
    58.028     1.919     0.200
    59.673    -2.525     0.200
    61.130    -0.377     0.200
    61.135    -0.410     0.200
    61.627    -0.339     0.200
    61.899    -0.769     0.200
    61.923    -0.838     0.200
    62.371    -1.037     0.200
    62.635    -0.001     0.200
    62.629    -0.160     0.200
    63.193    -0.515     0.200
    63.428     0.224     0.200
    63.440    -0.151     0.200
    63.712    -0.446     0.200
    65.996    -0.226     0.200
    70.575     0.668     0.200
    70.625    -0.342     0.200
    72.162    -1.618     0.200
    73.652     0.418     0.200
    73.899    -0.010     0.200
    74.659     0.222     0.200
    76.296    -0.574     0.200
    76.417     0.888     0.200
    76.722     0.141     0.200
    77.437     0.448     0.200
    77.628     0.160     0.200
    77.808     0.016     0.200
    78.867    -1.263     0.200
    79.021    -0.138     0.200
    79.362     0.548     0.200
    79.609     0.159     0.200
    79.762    -0.226     0.200
    79.771     0.057     0.200
    81.327    -1.683     0.200
    89.319    -0.025     0.200
    89.319    -0.392     0.200
    93.086    -0.595     0.200
    15.108     6.253     0.200
    16.651     4.476     0.200
    17.911     1.244     0.200
    18.496    -0.901     0.200
    18.581    -1.835     0.200
    20.808     1.352     0.200
    20.808     1.394     0.200
    22.661     0.290     0.200
    22.713    -0.564     0.200
    22.713    -1.064     0.200
    24.077     0.406     0.200
    24.624     0.106     0.200
    24.896     1.235     0.200
    24.896     2.048     0.200
    24.896    -0.226     0.200
    25.303     1.637     0.200
    26.979     2.877     0.200
    28.383     0.229     0.200
    28.383     0.908     0.200
    28.470     1.239     0.200
    30.155    -0.082     0.200
    30.764    -0.136     0.200
    35.557     2.428     0.200
    38.911    -0.529     0.200
    39.232     0.374     0.200
    42.301    -0.338     0.200
    46.490     0.252     0.200
    48.494     0.208     0.200
    48.561     0.068     0.200
    48.879     0.250     0.200
    50.932     0.534     0.200
    50.932     3.244     0.200
    58.873     0.375     0.200
    59.678    -1.863     0.200
    70.622     0.240     0.200
    72.734     0.714     0.200
    72.974     0.917     0.200
    73.270     0.562     0.200
    74.024     0.472     0.200
    74.609     0.347     0.200
    75.627     0.671     0.200
    76.042     0.915     0.200
    76.045     0.561     0.200
    76.297    -0.394     0.200
    76.391     0.875     0.200
    79.368     0.179     0.200
    79.762    -0.139     0.200
    80.081     0.738     0.200
    89.313    -0.053     0.200
    93.091     1.161     0.200
    14.447     8.455     0.200
    14.991     6.929     0.200
    16.411     5.986     0.200
    17.464     3.258     0.200
    17.704     1.421     0.200
    17.704     1.222     0.200
    17.704     1.679     0.200
    17.710     1.053     0.200
    20.552    -1.453     0.200
    20.552    -2.051     0.200
    22.400     0.027     0.200
    22.452     1.166     0.200
    22.452     0.447     0.200
    26.712     1.713     0.200
    26.712     2.033     0.200
    28.423     4.042     0.200
    29.891     1.117     0.200
    39.450    -3.094     0.200
    46.256     1.901     0.200
    46.256     1.897     0.200
    48.642     0.080     0.200
    48.801     0.412     0.200
    48.818     0.177     0.200
    49.026    -0.418     0.200
    49.025    -0.148     0.200
    49.025     0.532     0.200
    49.025    -0.269     0.200
    49.239    -0.352     0.200
    50.378    -0.639     0.200
    50.697    -0.881     0.200
    50.852    -0.546     0.200
    51.900    -0.720     0.200
    55.137     0.138     0.200
    55.208     0.407     0.200
    59.775    -1.737     0.200
    71.869     0.241     0.200
    73.825    -0.339     0.200
    74.032    -0.474     0.200
    74.805    -0.342     0.200
    75.754     0.432     0.200
    75.768    -0.495     0.200
    76.171     0.054     0.200
    77.758    -0.203     0.200
    77.781    -0.621     0.200
    77.939    -0.769     0.200
    78.995    -0.158     0.200
    79.498    -0.888     0.200
    79.883    -0.328     0.200
    80.235     0.505     0.200
    83.064    -0.352     0.200
    89.060    -0.285     0.200
    20.487    -1.447     0.200
    20.487    -0.156     0.200
    24.632    -0.064     0.200
    24.899     1.106     0.200
    30.604    -0.188     0.200
    48.893    -0.231     0.200
    59.696    -1.664     0.200
    79.739     0.414     0.200
    42.014     2.052     0.200
    18.219     1.444     0.200
    18.219     1.443     0.200
    18.719    -0.363     0.200
    18.805     0.321     0.200
    20.281    -1.016     0.200
    20.281    -1.805     0.200
    22.855     0.733     0.200
    22.907     1.936     0.200
    24.369     1.113     0.200
    26.426     0.344     0.200
    30.352     1.026     0.200
    40.511    -0.998     0.200
    42.380     2.159     0.200
    42.380     2.159     0.200
    46.628    -0.435     0.200
    48.438    -0.452     0.200
    48.650    -0.048     0.200
    48.650    -0.017     0.200
    50.322    -0.796     0.200
    51.120     0.945     0.200
    51.120     0.942     0.200
    51.120     3.442     0.200
    59.480    -2.456     0.200
    59.480    -2.456     0.200
    70.718     0.222     0.200
    76.309    -0.072     0.200
    76.309    -0.071     0.200
    78.658    -0.237     0.200
    79.780    -0.623     0.200
    89.483    -0.340     0.200
    89.485    -0.360     0.200
    17.444     3.667     0.200
    17.963     0.375     0.200
    17.963     0.188     0.200
    20.486    -0.731     0.200
    20.486    -0.895     0.200
    22.664     0.471     0.200
    42.312     0.410     0.200
    48.895    -0.013     0.200
    50.935     1.155     0.200
    76.282     0.229     0.200
    18.015     2.754     0.200
    74.969     1.222     0.200
    76.079    -0.165     0.200
    79.544     0.360     0.200
    14.782     7.572     0.200
    16.333     2.196     0.200
    16.333     4.996     0.200
    17.695     0.869     0.200
    18.283     0.941     0.200
    18.920    -0.222     0.200
    18.920    -0.393     0.200
    20.778    -0.022     0.200
    20.778    -0.742     0.200
    20.818     1.049     0.200
    22.502    -2.093     0.200
    22.554    -0.382     0.200
    22.554     0.198     0.200
    24.619     0.805     0.200
    24.619     0.320     0.200
    24.619     0.520     0.200
    26.720     1.662     0.200
    26.720     1.862     0.200
    28.289     1.668     0.200
    35.255    -0.034     0.200
    35.255     0.434     0.200
    37.343     2.557     0.200
    42.313    -1.574     0.200
    42.313    -1.459     0.200
    46.417    -1.642     0.200
    49.214    -0.101     0.200
    49.214    -0.401     0.200
    49.214     0.500     0.200
    49.418     2.540     0.200
    50.377     0.322     0.200
    50.763    -1.217     0.200
    59.995    -1.050     0.200
    60.315     0.864     0.200
    70.609     0.155     0.200
    70.609    -0.519     0.200
    72.465    -0.284     0.200
    76.170    -1.133     0.200
    76.173    -0.722     0.200
    76.239    -1.874     0.200
    79.627    -0.415     0.200
    79.627    -0.121     0.200
    89.186    -0.599     0.200
    89.186    -0.782     0.200
    14.924     6.923     0.200
    16.476     5.475     0.200
    16.476     6.075     0.200
    17.351     2.955     0.200
    17.977     0.056     0.200
    18.382    -0.271     0.200
    18.467    -1.216     0.200
    18.467    -2.141     0.200
    19.118    -1.248     0.200
    20.643    -1.158     0.200
    20.643    -1.527     0.200
    20.643    -1.297     0.200
    20.749     0.135     0.200
    20.806     0.208     0.200
    20.806     0.758     0.200
    21.069     0.014     0.200
    21.173    -3.159     0.200
    21.408    -1.085     0.200
    21.525    -2.825     0.200
    21.786    -0.316     0.200
    21.790    -0.310     0.200
    22.198    -0.026     0.200
    22.204    -2.450     0.200
    22.440     0.771     0.200
    22.474     2.007     0.200
    22.577    -0.577     0.200
    22.630    -2.047     0.200
    22.630    -2.397     0.200
    22.836    -0.326     0.200
    22.917    -1.410     0.200
    22.928    -0.552     0.200
    22.923     0.822     0.200
    23.645    -0.782     0.200
    23.926     0.882     0.200
    23.926     0.402     0.200
    24.052     0.466     0.200
    24.052     1.049     0.200
    24.184     0.121     0.200
    24.369     0.882     0.200
    24.811    -0.080     0.200
    24.811    -0.379     0.200
    24.745     1.118     0.200
    24.745     1.235     0.200
    24.745    -0.675     0.200
    24.745     0.714     0.200
    24.982     2.119     0.200
    25.154     1.340     0.200
    25.523     1.410     0.200
    26.472    -0.153     0.200
    26.695     2.645     0.200
    26.839     1.546     0.200
    26.839     0.617     0.200
    26.839    -0.553     0.200
    26.839     0.146     0.200
    27.128     2.947     0.200
    28.336     1.052     0.200
    28.336    -1.067     0.200
    28.336     0.753     0.200
    29.184    -0.158     0.200
    29.496     0.407     0.200
    29.961     1.007     0.200
    30.064    -0.601     0.200
    30.064    -0.580     0.200
    30.175     1.721     0.200
    30.273     1.655     0.200
    30.524     1.129     0.200
    30.604     1.422     0.200
    30.781    -0.136     0.200
    30.666     1.377     0.200
    30.682    -0.988     0.200
    30.682    -1.664     0.200
    30.746     0.574     0.200
    31.226     1.636     0.200
    31.248     1.644     0.200
    32.517    -1.609     0.200
    33.529    -1.358     0.200
    35.036    -0.020     0.200
    35.385    -0.780     0.200
    35.385     0.470     0.200
    35.385     0.358     0.200
    35.728    -0.773     0.200
    36.582    -3.084     0.200
    37.379    -0.065     0.200
    37.456     0.662     0.200
    37.456    -1.315     0.200
    39.006     0.001     0.200
    39.006    -0.445     0.200
    40.352    -3.086     0.200
    42.314    -1.626     0.200
    42.314    -0.702     0.200
    42.314    -1.081     0.200
    42.946    -0.039     0.200
    42.946     0.621     0.200
    42.958     1.290     0.200
    42.958    -2.036     0.200
    43.092    -0.823     0.200
    43.347     0.016     0.200
    44.889    -0.354     0.200
    45.863    -0.769     0.200
    46.038    -0.077     0.200
    46.086    -0.234     0.200
    46.488     0.050     0.200
    46.455    -1.013     0.200
    46.455     0.461     0.200
    46.455    -0.849     0.200
    46.455    -0.238     0.200
    46.455    -0.709     0.200
    46.771    -0.049     0.200
    47.615     0.721     0.200
    48.008     0.769     0.200
    48.094     0.738     0.200
    48.094     0.274     0.200
    48.591    -0.797     0.200
    48.856    -0.128     0.200
    49.030     0.281     0.200
    49.035     0.443     0.200
    49.067    -0.033     0.200
    49.067    -0.303     0.200
    49.067    -0.483     0.200
    49.694     0.067     0.200
    50.377     0.330     0.200
    50.409    -0.411     0.200
    50.418    -0.044     0.200
    50.418     0.127     0.200
    50.559    -0.461     0.200
    50.564    -1.085     0.200
    50.739    -0.994     0.200
    50.889    -0.522     0.200
    50.901    -0.146     0.200
    50.853     1.123     0.200
    50.853     0.274     0.200
    50.888    -0.836     0.200
    50.888    -0.506     0.200
    51.054    -0.236     0.200
    51.126    -0.073     0.200
    51.500    -0.737     0.200
    51.556     0.204     0.200
    51.536     1.593     0.200
    51.888    -0.596     0.200
    51.945     0.304     0.200
    51.949    -1.180     0.200
    51.903     1.502     0.200
    51.985    -2.043     0.200
    52.257     0.531     0.200
    52.826     0.502     0.200
    52.921     0.301     0.200
    53.095     0.015     0.200
    53.108    -0.377     0.200
    53.124     0.701     0.200
    53.136     0.213     0.200
    53.140     0.601     0.200
    53.671     0.208     0.200
    53.695     0.953     0.200
    53.695    -0.192     0.200
    53.812     1.046     0.200
    53.922     0.346     0.200
    53.922     0.057     0.200
    53.956     0.694     0.200
    53.956    -0.406     0.200
    54.743     0.061     0.200
    55.135     0.229     0.200
    55.164    -0.584     0.200
    55.275    -0.180     0.200
    55.275    -1.340     0.200
    55.411     0.267     0.200
    55.411    -0.037     0.200
    55.612     0.282     0.200
    55.821    -0.424     0.200
    56.250     0.121     0.200
    56.608    -0.575     0.200
    56.973     0.863     0.200
    57.445     0.547     0.200
    57.485    -0.744     0.200
    57.507    -0.391     0.200
    57.744    -3.643     0.200
    57.769     0.371     0.200
    58.029     0.058     0.200
    58.116    -3.475     0.200
    58.333    -0.722     0.200
    59.169     0.200     0.200
    59.857    -1.334     0.200
    59.857    -1.459     0.200
    66.977    -1.389     0.200
    69.603    -0.753     0.200
    70.621     0.855     0.200
    70.621     0.626     0.200
    71.094     0.385     0.200
    71.858     0.418     0.200
    71.919     0.802     0.200
    72.518    -0.431     0.200
    73.873     1.226     0.200
    74.089     0.392     0.200
    74.595     2.128     0.200
    74.793    -0.011     0.200
    74.852     0.458     0.200
    74.970    -0.875     0.200
    76.220    -0.838     0.200
    77.162     1.091     0.200
    77.321     2.180     0.200
    77.984     0.788     0.200
    78.079    -0.033     0.200
    79.057    -0.774     0.200
    79.554    -0.167     0.200
    79.614     1.234     0.200
    79.681    -0.382     0.200
    80.269    -1.240     0.200
    87.213     1.226     0.200
    89.248    -0.588     0.200
    89.361     0.130     0.200
    89.986    -0.494     0.200
    90.750    -0.314     0.200
    93.276     0.386     0.200
    17.959     0.997     0.200
    17.959     0.098     0.200
    18.487    -1.000     0.200
    18.572    -1.961     0.200
    18.779    -2.429     0.200
    18.779    -1.804     0.200
    20.474    -1.201     0.200
    22.653    -0.748     0.200
    30.599    -0.481     0.200
    46.483    -0.907     0.200
    59.684    -2.269     0.200
    59.684    -1.620     0.200
    76.299    -0.401     0.200
    79.764     0.579     0.200
    15.436     5.249     0.200
    17.049     3.429     0.200
    18.347    -0.770     0.200
    18.347    -0.469     0.200
    18.347    -2.270     0.200
    18.524    -0.715     0.200
    18.747    -1.332     0.200
    18.747    -0.797     0.200
    18.832    -1.896     0.200
    18.918    -2.840     0.200
    20.179    -1.816     0.200
    20.621    -0.316     0.200
    20.678    -0.529     0.200
    22.559     0.502     0.200
    22.952    -2.097     0.200
    23.004     1.598     0.200
    23.004    -0.176     0.200
    23.473    -1.544     0.200
    24.029     0.976     0.200
    24.234     0.799     0.200
    24.522     1.274     0.200
    25.276    -0.386     0.200
    28.612    -1.168     0.200
    28.612    -0.386     0.200
    30.225     0.717     0.200
    30.457     0.024     0.200
    30.938     0.713     0.200
    33.682    -3.041     0.200
    35.835    -1.786     0.200
    36.733    -1.204     0.200
    39.267    -0.812     0.200
    39.267    -0.187     0.200
    40.592     0.987     0.200
    40.573     0.965     0.200
    42.413    -0.727     0.200
    42.415    -2.589     0.200
    42.415    -1.238     0.200
    42.415    -0.726     0.200
    43.317     0.852     0.200
    45.955    -0.070     0.200
    46.410    -0.078     0.200
    46.695    -1.738     0.200
    46.695    -0.613     0.200
    46.695     0.458     0.200
    46.695     0.989     0.200
    47.468     0.777     0.200
    47.570     0.633     0.200
    47.902     1.162     0.200
    47.918     0.783     0.200
    47.963     0.714     0.200
    48.300     0.297     0.200
    48.315    -0.255     0.200
    48.405     0.461     0.200
    48.496    -0.299     0.200
    48.469     0.459     0.200
    48.528     0.055     0.200
    48.528    -0.195     0.200
    48.651     0.331     0.200
    48.642    -1.616     0.200
    48.669    -0.029     0.200
    48.723    -0.048     0.200
    48.738    -0.435     0.200
    48.702    -0.443     0.200
    48.815    -0.563     0.200
    49.882    -0.585     0.200
    50.056    -0.829     0.200
    50.056    -0.427     0.200
    50.177    -0.543     0.200
    50.199    -0.974     0.200
    50.370    -0.075     0.200
    50.318     0.841     0.200
    50.552    -0.610     0.200
    50.592    -0.568     0.200
    50.528     0.412     0.200
    50.625     1.164     0.200
    50.638     0.814     0.200
    50.668     0.923     0.200
    50.668     0.334     0.200
    50.690     0.758     0.200
    50.745     0.902     0.200
    50.910     0.018     0.200
    50.985    -0.182     0.200
    51.007     0.011     0.200
    51.000     1.632     0.200
    51.051    -0.559     0.200
    51.118     1.125     0.200
    51.213     0.544     0.200
    51.213     0.191     0.200
    51.213     1.644     0.200
    51.213     0.742     0.200
    51.306    -0.100     0.200
    51.339     0.069     0.200
    51.350    -0.074     0.200
    51.398     0.018     0.200
    51.419    -0.067     0.200
    51.504    -1.545     0.200
    51.458     2.007     0.200
    51.644     1.844     0.200
    51.707     0.902     0.200
    52.171     1.712     0.200
    52.391     0.769     0.200
    52.502     0.891     0.200
    52.749     1.005     0.200
    52.799     1.157     0.200
    52.979     1.047     0.200
    53.112     0.992     0.200
    53.112     0.226     0.200
    53.284     0.358     0.200
    53.397     0.097     0.200
    53.852     1.132     0.200
    53.931     1.067     0.200
    54.224    -0.422     0.200
    54.224    -0.222     0.200
    55.068     1.154     0.200
    55.068     0.255     0.200
    55.181     1.114     0.200
    55.451     0.792     0.200
    55.590    -0.320     0.200
    55.590    -0.784     0.200
    55.590    -0.507     0.200
    55.733    -0.391     0.200
    55.773     0.777     0.200
    55.815     1.169     0.200
    56.011    -0.107     0.200
    56.164     0.793     0.200
    56.164     0.781     0.200
    56.164     0.347     0.200
    56.166     0.771     0.200
    56.454     1.094     0.200
    56.811     0.974     0.200
    56.998     1.477     0.200
    57.170     0.883     0.200
    57.635     0.294     0.200
    57.665     1.167     0.200
    57.688     1.090     0.200
    57.884     0.800     0.200
    57.886    -0.443     0.200
    57.944     0.782     0.200
    58.038    -0.172     0.200
    58.096     0.219     0.200
    58.294     1.059     0.200
    58.471     0.101     0.200
    58.483    -0.482     0.200
    58.525    -1.369     0.200
    58.553    -0.572     0.200
    59.090     0.294     0.200
    59.373    -1.188     0.200
    59.373    -1.063     0.200
    59.578    -0.998     0.200
    60.156     0.669     0.200
    60.585    -0.523     0.200
    61.655     0.458     0.200
    69.906     0.764     0.200
    70.562     0.384     0.200
    70.722     0.868     0.200
    70.760     0.221     0.200
    70.762     0.422     0.200
    71.039     0.666     0.200
    71.099     0.360     0.200
    71.992    -1.680     0.200
    72.714     0.050     0.200
    73.342     1.141     0.200
    73.569     0.365     0.200
    74.051     1.529     0.200
    74.279    -0.212     0.200
    74.318     0.371     0.200
    75.005     1.248     0.200
    75.270     1.254     0.200
    75.293     0.723     0.200
    75.706     0.279     0.200
    75.719     0.779     0.200
    76.013     0.383     0.200
    76.078     0.671     0.200
    76.146    -0.124     0.200
    76.253     0.343     0.200
    76.322     0.051     0.200
    76.386     0.631     0.200
    76.431     0.004     0.200
    76.445     0.877     0.200
    76.702    -1.041     0.200
    77.444    -0.878     0.200
    77.467     0.352     0.200
    77.481     1.515     0.200
    77.626     0.154     0.200
    77.717     0.284     0.200
    78.542    -0.668     0.200
    78.542    -0.227     0.200
    78.675     0.999     0.200
    78.713     0.089     0.200
    79.031     0.799     0.200
    79.164    -0.975     0.200
    79.239     1.207     0.200
    79.536    -0.048     0.200
    79.723    -0.277     0.200
    79.723     0.942     0.200
    79.797     0.167     0.200
    79.944     0.975     0.200
    80.391     0.902     0.200
    80.551     1.292     0.200
    80.569     1.006     0.200
    80.680    -0.473     0.200
    81.238     0.525     0.200
    81.351     0.720     0.200
    82.595     1.169     0.200
    82.811     0.764     0.200
    84.338     0.601     0.200
    86.695     1.698     0.200
    86.695     0.518     0.200
    89.570    -0.149     0.200
    92.760    -0.065     0.200
    14.931     7.967     0.200
    16.343     3.171     0.200
    17.413     0.601     0.200
    17.641     1.970     0.200
    18.689    -1.587     0.200
    18.689    -0.388     0.200
    18.689    -0.877     0.200
    18.794     0.562     0.200
    20.609    -1.331     0.200
    20.609    -1.450     0.200
    22.356     0.105     0.200
    22.408     0.425     0.200
    22.408     2.944     0.200
    24.897    -0.480     0.200
    26.651     3.123     0.200
    26.651     2.724     0.200
    29.845     2.040     0.200
    42.096    -0.410     0.200
    42.097    -0.846     0.200
    42.097    -0.490     0.200
    42.724    -0.523     0.200
    46.228    -0.602     0.200
    48.104     1.099     0.200
    48.126     0.788     0.200
    48.381    -0.767     0.200
    48.706     0.492     0.200
    49.090     0.569     0.200
    49.090     0.198     0.200
    50.762    -1.157     0.200
    51.910     0.427     0.200
    58.137     0.727     0.200
    65.879     3.002     0.200
    74.869     0.841     0.200
    76.395     1.502     0.200
    76.401    -0.056     0.200
    76.404     0.280     0.200
    76.470    -0.030     0.200
    79.858    -0.124     0.200
    79.858     0.195     0.200
    80.301    -1.490     0.200
    22.687     0.722     0.200
    17.784     1.552     0.200
    18.320     0.555     0.200
    18.405    -0.446     0.200
    22.498     2.367     0.200
    49.013    -0.266     0.200
    76.335    -0.650     0.200
    79.795    -0.262     0.200
    20.525    -1.596     0.200
    48.942    -0.761     0.200
    76.278    -1.079     0.200
    16.748     4.963     0.200
    17.586     3.004     0.200
    17.852     0.851     0.200
    18.575    -0.928     0.200
    18.660    -1.879     0.200
    18.766    -1.977     0.200
    18.766    -2.157     0.200
    20.394    -0.686     0.200
    20.394    -1.184     0.200
    20.394    -0.905     0.200
    20.781     0.193     0.200
    20.781     1.405     0.200
    22.636     1.628     0.200
    22.728    -1.587     0.200
    22.780    -1.322     0.200
    22.780    -0.803     0.200
    23.072    -0.566     0.200
    23.630     0.396     0.200
    23.773     1.216     0.200
    23.773    -1.573     0.200
    23.773     1.347     0.200
    24.528     1.207     0.200
    24.528     0.556     0.200
    24.987     1.470     0.200
    24.987    -0.204     0.200
    24.987     1.776     0.200
    25.187    -0.845     0.200
    25.619     0.768     0.200
    26.600    -0.217     0.200
    27.068    -0.291     0.200
    27.068    -0.560     0.200
    27.303     0.930     0.200
    28.435    -0.477     0.200
    28.924    -1.215     0.200
    29.743    -0.427     0.200
    30.225    -0.327     0.200
    30.225     1.083     0.200
    30.500     0.916     0.200
    30.647     0.369     0.200
    30.827    -0.161     0.200
    31.363     1.493     0.200
    32.583     0.285     0.200
    35.390     1.297     0.200
    35.628     0.820     0.200
    37.075    -0.091     0.200
    37.674    -0.629     0.200
    37.674    -0.489     0.200
    42.323    -0.382     0.200
    42.323     0.934     0.200
    43.095     2.168     0.200
    45.077    -1.141     0.200
    45.761    -0.311     0.200
    46.267     0.511     0.200
    46.535     0.616     0.200
    46.535    -0.054     0.200
    46.535     0.366     0.200
    47.259     0.504     0.200
    47.823     0.892     0.200
    48.406     0.418     0.200
    48.564    -0.153     0.200
    48.576     0.408     0.200
    48.576     0.433     0.200
    48.791    -0.303     0.200
    48.791     0.406     0.200
    48.791    -0.574     0.200
    49.002     0.244     0.200
    49.408    -1.754     0.200
    49.542    -0.815     0.200
    49.718    -0.554     0.200
    50.053    -1.538     0.200
    50.267     0.648     0.200
    50.296    -1.178     0.200
    50.373    -0.852     0.200
    50.443    -0.006     0.200
    50.494    -0.166     0.200
    50.504     0.189     0.200
    50.996    -0.296     0.200
    50.997     1.642     0.200
    50.997     0.242     0.200
    51.406    -1.381     0.200
    51.601    -0.290     0.200
    51.612    -0.564     0.200
    51.676    -1.156     0.200
    51.729    -1.456     0.200
    53.066    -0.059     0.200
    54.592    -0.076     0.200
    54.699     0.070     0.200
    55.322     1.641     0.200
    55.460     0.647     0.200
    55.460     0.399     0.200
    56.612    -0.057     0.200
    59.600    -1.035     0.200
    59.600    -0.890     0.200
    67.244     0.170     0.200
    69.354    -0.196     0.200
    70.651     0.423     0.200
    70.651    -0.637     0.200
    71.646     0.158     0.200
    73.600    -0.241     0.200
    73.820     0.162     0.200
    74.526     0.052     0.200
    74.578     0.719     0.200
    74.776     0.752     0.200
    74.807     0.401     0.200
    76.154    -0.214     0.200
    76.265     0.171     0.200
    76.302     0.981     0.200
    76.336     0.458     0.200
    76.302    -0.417     0.200
    76.308    -0.243     0.200
    76.308    -0.733     0.200
    76.312    -0.210     0.200
    76.376    -0.465     0.200
    76.642     1.139     0.200
    76.688     1.116     0.200
    77.358     0.457     0.200
    77.550     0.996     0.200
    77.715     0.994     0.200
    77.875     1.542     0.200
    78.789     0.210     0.200
    78.789     0.089     0.200
    78.789     0.249     0.200
    78.946     0.225     0.200
    79.283     0.873     0.200
    79.506     1.326     0.200
    79.756    -0.034     0.200
    79.775     0.294     0.200
    79.776     0.051     0.200
    79.991     1.260     0.200
    79.991     0.635     0.200
    80.044    -0.150     0.200
    80.044    -0.051     0.200
    80.200     0.886     0.200
    80.646     0.748     0.200
    80.818     0.879     0.200
    81.491     1.160     0.200
    81.598     0.336     0.200
    82.043     1.191     0.200
    83.248    -0.668     0.200
    86.944     1.297     0.200
    89.103     0.211     0.200
    89.371    -0.046     0.200
    89.588    -0.908     0.200
    93.008     0.067     0.200
    17.693     2.179     0.200
    18.280     0.262     0.200
    18.364    -0.793     0.200
    20.773    -1.059     0.200
    22.497    -1.504     0.200
    42.307    -1.695     0.200
    49.211    -0.423     0.200
    59.990    -0.572     0.200
    14.431     6.513     0.200
    15.394     5.210     0.200
    16.713     2.360     0.200
    17.227     1.121     0.200
    17.918     0.851     0.200
    18.577    -2.320     0.200
    18.577    -1.699     0.200
    18.577    -0.590     0.200
    18.664    -0.600     0.200
    19.880     1.040     0.200
    20.180    -1.916     0.200
    20.180    -2.334     0.200
    20.180    -0.826     0.200
    20.180    -1.115     0.200
    20.917    -2.125     0.200
    20.917     0.933     0.200
    21.591     1.322     0.200
    22.630     1.124     0.200
    22.630     1.741     0.200
    22.630     1.593     0.200
    22.731     0.578     0.200
    22.689     0.464     0.200
    22.741    -1.082     0.200
    22.741     2.028     0.200
    22.922     1.750     0.200
    23.119     3.297     0.200
    23.292     1.717     0.200
    23.262    -0.125     0.200
    23.643     0.770     0.200
    23.643    -0.117     0.200
    23.643     1.192     0.200
    23.643     1.699     0.200
    23.711     2.020     0.200
    23.810    -1.466     0.200
    23.810     2.323     0.200
    24.373     1.821     0.200
    24.298     0.313     0.200
    24.298     1.383     0.200
    25.048    -0.393     0.200
    25.048     0.720     0.200
    25.048     2.474     0.200
    25.048     2.685     0.200
    27.045     1.805     0.200
    27.111     0.109     0.200
    27.521     1.430     0.200
    28.457     2.571     0.200
    28.835     0.893     0.200
    28.755     0.729     0.200
    29.402     0.783     0.200
    29.810     0.463     0.200
    29.810     1.873     0.200
    30.318     0.574     0.200
    30.317    -0.113     0.200
    30.195    -0.330     0.200
    30.798     0.482     0.200
    32.052     2.078     0.200
    32.387     1.667     0.200
    32.387     0.046     0.200
    32.477     1.476     0.200
    35.495    -0.104     0.200
    35.844    -0.133     0.200
    35.844     0.769     0.200
    36.488    -1.439     0.200
    39.944    -1.505     0.200
    40.501    -2.605     0.200
    41.094    -1.379     0.200
    41.149    -1.151     0.200
    41.221    -1.608     0.200
    41.326    -1.826     0.200
    41.422    -1.280     0.200
    41.517    -2.183     0.200
    41.731    -1.281     0.200
    41.848    -1.160     0.200
    41.928    -1.181     0.200
    42.098    -1.264     0.200
    42.229    -1.180     0.200
    42.180     0.678     0.200
    42.180     1.307     0.200
    42.380    -0.681     0.200
    42.404    -0.658     0.200
    42.492    -1.872     0.200
    42.549    -1.998     0.200
    42.733    -1.306     0.200
    42.805    -1.429     0.200
    42.839    -1.418     0.200
    43.178    -1.672     0.200
    43.216    -1.322     0.200
    43.251    -1.425     0.200
    43.054    -0.245     0.200
    43.329    -0.882     0.200
    43.341    -1.450     0.200
    43.407    -1.435     0.200
    43.526    -0.774     0.200
    43.543    -1.794     0.200
    43.610     0.642     0.200
    43.610    -1.222     0.200
    43.667    -1.547     0.200
    43.661    -0.503     0.200
    43.690    -0.986     0.200
    43.746    -0.656     0.200
    43.921    -0.654     0.200
    43.962    -1.625     0.200
    44.152    -1.959     0.200
    44.214    -1.673     0.200
    44.297    -1.711     0.200
    44.317    -0.195     0.200
    44.317    -0.426     0.200
    44.323    -0.420     0.200
    44.340    -1.237     0.200
    44.412    -1.345     0.200
    44.413    -1.354     0.200
    44.566    -1.324     0.200
    44.730    -1.672     0.200
    44.774    -1.779     0.200
    44.876    -1.604     0.200
    44.891    -1.248     0.200
    44.968    -2.169     0.200
    44.997    -0.865     0.200
    44.994    -1.490     0.200
    45.030    -1.724     0.200
    45.078    -1.901     0.200
    45.087    -1.919     0.200
    44.962    -0.238     0.200
    45.164    -1.590     0.200
    45.229    -1.836     0.200
    45.320    -1.844     0.200
    45.353    -1.945     0.200
    45.390    -1.219     0.200
    45.393    -0.336     0.200
    45.393    -1.391     0.200
    45.245     1.974     0.200
    45.458    -1.602     0.200
    45.716    -1.283     0.200
    45.757    -1.018     0.200
    45.862    -1.239     0.200
    45.943    -1.342     0.200
    45.936    -1.598     0.200
    45.928    -0.779     0.200
    45.963    -1.449     0.200
    45.991    -2.064     0.200
    45.977    -1.182     0.200
    46.019    -1.629     0.200
    46.038    -1.601     0.200
    46.051    -1.631     0.200
    46.076    -1.388     0.200
    46.086    -1.040     0.200
    46.379    -0.775     0.200
    46.419    -0.943     0.200
    46.465    -1.730     0.200
    46.484    -1.917     0.200
    46.503    -1.488     0.200
    46.487    -1.764     0.200
    46.519    -1.336     0.200
    46.567    -1.527     0.200
    46.635    -2.081     0.200
    46.657    -1.602     0.200
    46.841    -1.367     0.200
    46.848    -1.587     0.200
    46.896    -1.195     0.200
    46.972    -1.050     0.200
    47.168    -1.462     0.200
    47.195    -1.310     0.200
    47.202    -2.451     0.200
    47.292    -1.498     0.200
    47.291    -1.860     0.200
    47.377    -1.502     0.200
    47.417    -1.496     0.200
    47.453    -1.665     0.200
    47.480    -1.442     0.200
    47.540    -1.532     0.200
    47.565    -1.380     0.200
    47.583    -2.225     0.200
    47.584    -1.116     0.200
    47.601    -1.878     0.200
    47.627    -1.529     0.200
    47.640    -2.272     0.200
    47.654    -1.521     0.200
    47.719    -1.959     0.200
    47.876    -1.984     0.200
    47.940    -1.713     0.200
    47.934     1.164     0.200
    47.934    -2.320     0.200
    47.982    -1.193     0.200
    47.986    -0.978     0.200
    48.018    -1.477     0.200
    48.000    -1.741     0.200
    48.018    -1.226     0.200
    48.144    -1.073     0.200
    48.171    -1.215     0.200
    48.207    -1.173     0.200
    48.198    -2.339     0.200
    48.214     0.652     0.200
    48.255    -1.317     0.200
    48.272    -1.303     0.200
    48.293    -1.113     0.200
    48.346    -1.162     0.200
    48.556    -1.146     0.200
    48.560    -0.876     0.200
    48.418     1.368     0.200
    48.568    -0.748     0.200
    48.598     0.119     0.200
    48.598     0.439     0.200
    48.649    -0.928     0.200
    48.742    -1.094     0.200
    48.785    -1.664     0.200
    48.790    -1.993     0.200
    48.810    -1.321     0.200
    48.883    -1.124     0.200
    48.898    -1.685     0.200
    48.926    -1.268     0.200
    48.936    -1.407     0.200
    48.977    -1.084     0.200
    48.978    -0.781     0.200
    49.020    -1.633     0.200
    49.085    -1.244     0.200
    49.186    -0.868     0.200
    49.199    -1.216     0.200
    49.195    -1.377     0.200
    49.325    -0.552     0.200
    49.404    -1.405     0.200
    49.448    -1.457     0.200
    49.479    -1.494     0.200
    49.509    -1.916     0.200
    49.524    -2.310     0.200
    49.558    -2.761     0.200
    49.596    -2.809     0.200
    49.650    -2.937     0.200
    49.724    -2.257     0.200
    49.853    -1.618     0.200
    49.858    -1.683     0.200
    49.870    -1.654     0.200
    49.908    -0.696     0.200
    49.877    -1.588     0.200
    49.950    -0.828     0.200
    49.974    -0.797     0.200
    49.998    -1.257     0.200
    50.018    -1.077     0.200
    50.074    -0.890     0.200
    50.090    -1.177     0.200
    50.233    -0.870     0.200
    50.246    -1.204     0.200
    50.253    -0.874     0.200
    50.264    -0.796     0.200
    50.330    -1.162     0.200
    50.340    -1.585     0.200
    50.362    -2.001     0.200
    50.395    -2.288     0.200
    50.521    -3.012     0.200
    50.559    -2.192     0.200
    50.587    -1.557     0.200
    50.642    -2.638     0.200
    50.657    -1.693     0.200
    50.666    -1.948     0.200
    50.726    -1.205     0.200
    50.739    -0.726     0.200
    50.889    -1.482     0.200
    50.905    -1.378     0.200
    50.931    -2.026     0.200
    51.025    -1.020     0.200
    51.021    -0.019     0.200
    51.082    -1.096     0.200
    51.099    -0.190     0.200
    50.950     1.699     0.200
    50.950     2.295     0.200
    51.158    -2.739     0.200
    51.419     0.247     0.200
    51.478    -0.767     0.200
    51.479    -2.368     0.200
    51.479    -2.164     0.200
    51.518    -1.816     0.200
    51.563    -2.453     0.200
    51.555    -1.374     0.200
    51.707    -1.498     0.200
    51.794    -2.125     0.200
    51.884    -2.034     0.200
    51.915    -2.245     0.200
    52.040    -2.515     0.200
    52.216    -1.712     0.200
    52.342    -1.632     0.200
    52.561    -1.027     0.200
    52.706    -1.337     0.200
    52.939    -2.617     0.200
    53.355    -2.270     0.200
    53.370    -2.060     0.200
    53.405    -1.444     0.200
    53.584    -2.073     0.200
    53.682    -2.062     0.200
    54.071    -2.500     0.200
    54.105    -2.055     0.200
    54.395    -2.181     0.200
    54.442    -2.048     0.200
    54.473    -2.270     0.200
    54.503    -1.123     0.200
    54.691    -2.186     0.200
    54.943    -1.487     0.200
    55.148    -1.138     0.200
    55.416    -1.722     0.200
    55.603    -1.501     0.200
    55.534    -0.328     0.200
    55.534     1.262     0.200
    56.189    -2.161     0.200
    56.416    -2.405     0.200
    56.615    -1.940     0.200
    56.738    -2.200     0.200
    56.856    -2.038     0.200
    57.035    -2.598     0.200
    57.373    -2.153     0.200
    57.572    -2.508     0.200
    57.638    -2.514     0.200
    57.981    -3.293     0.200
    57.846     0.569     0.200
    58.046    -2.670     0.200
    58.699    -2.703     0.200
    58.769    -3.001     0.200
    59.073    -2.991     0.200
    59.389    -1.229     0.200
    59.389    -1.503     0.200
    59.544    -2.469     0.200
    59.563    -2.590     0.200
    59.803    -2.376     0.200
    59.807    -2.101     0.200
    60.057    -3.144     0.200
    60.741    -3.282     0.200
    70.519     0.713     0.200
    72.864     0.489     0.200
    74.382     0.538     0.200
    76.111     0.203     0.200
    76.346    -0.836     0.200
    76.495    -0.659     0.200
    76.501    -0.092     0.200
    76.501    -0.194     0.200
    76.504    -0.489     0.200
    78.586    -0.042     0.200
    78.741     1.803     0.200
    79.083     0.029     0.200
    79.803     1.058     0.200
    79.971    -0.065     0.200
    79.971     0.048     0.200
    82.611     2.287     0.200
    84.016    -2.532     0.200
    85.236    -1.452     0.200
    88.612    -0.836     0.200
    89.307     0.399     0.200
    89.307     0.680     0.200
    89.775    -1.081     0.200
    92.963    -1.182     0.200
    17.950     0.751     0.200
    17.950     0.278     0.200
    17.950     0.751     0.200
    18.479    -0.724     0.200
    18.564    -1.439     0.200
    20.479    -0.102     0.200
    20.479    -0.997     0.200
    22.645     0.417     0.200
    24.641    -2.647     0.200
    48.893     0.527     0.200
    70.612     0.424     0.200
    17.975     1.272     0.200
    18.482    -0.861     0.200
    20.301    -0.797     0.200
    22.414    -0.837     0.200
    48.784    -0.256     0.200
    80.061    -0.413     0.200
    17.421     1.891     0.200
    17.929     2.528     0.200
    18.014     1.432     0.200
    22.103     1.941     0.200
    18.259     0.495     0.200
    20.350    -0.191     0.200
    22.393     1.781     0.200
    80.037    -0.421     0.200
    17.786     0.287     0.200
    17.786     0.287     0.200
    18.257    -0.117     0.200
    18.503    -2.350     0.200
    20.347    -2.306     0.200
    20.347    -1.727     0.200
    21.113     0.673     0.200
    22.391    -0.179     0.200
    41.996    -1.180     0.200
    76.579    -1.577     0.200
    76.579     0.673     0.200
    80.041    -1.090     0.200
    80.041    -0.090     0.200
    14.111     5.827     0.200
    15.152     3.896     0.200
    17.854     1.001     0.200
    17.854     0.224     0.200
    18.067     1.590     0.200
    18.578    -2.049     0.200
    18.664    -1.001     0.200
    18.751    -2.615     0.200
    18.751    -0.197     0.200
    20.376    -1.294     0.200
    20.376    -0.962     0.200
    21.669    -0.228     0.200
    22.632     1.799     0.200
    22.632    -0.560     0.200
    22.728    -0.739     0.200
    24.513     1.468     0.200
    24.995    -1.200     0.200
    24.995    -0.821     0.200
    24.995    -1.981     0.200
    27.074    -0.236     0.200
    27.074    -0.736     0.200
    28.536     1.190     0.200
    28.914    -0.591     0.200
    28.914    -1.978     0.200
    29.482     0.190     0.200
    30.226    -0.036     0.200
    30.226    -0.993     0.200
    30.483    -0.172     0.200
    30.655     1.012     0.200
    30.655    -0.668     0.200
    32.577     2.602     0.200
    35.646    -0.828     0.200
    35.646    -1.809     0.200
    35.836     0.944     0.200
    40.416     1.439     0.200
    42.314    -0.942     0.200
    42.314     0.558     0.200
    43.095     1.314     0.200
    43.242     1.025     0.200
    43.785    -0.617     0.200
    45.062    -0.364     0.200
    45.144    -0.346     0.200
    46.250     0.183     0.200
    46.530     0.191     0.200
    46.634     0.491     0.200
    46.747     0.199     0.200
    47.715    -0.095     0.200
    48.138    -0.730     0.200
    48.547     0.180     0.200
    48.562     0.154     0.200
    48.565     0.317     0.200
    48.738     0.182     0.200
    48.774     0.198     0.200
    48.774    -0.431     0.200
    48.774     0.120     0.200
    48.774     0.018     0.200
    50.489     0.229     0.200
    50.499     0.076     0.200
    50.996     0.925     0.200
    50.996     1.425     0.200
    50.996     0.706     0.200
    51.584     0.104     0.200
    55.453     0.818     0.200
    55.453     1.919     0.200
    57.996    -0.216     0.200
    59.582    -1.652     0.200
    59.582    -1.175     0.200
    67.239    -0.175     0.200
    67.239    -0.659     0.200
    70.642     0.059     0.200
    70.642     0.794     0.200
    71.607    -0.578     0.200
    73.583    -0.460     0.200
    75.516    -0.337     0.200
    76.323    -0.678     0.200
    76.323    -0.451     0.200
    76.323    -1.241     0.200
    76.376    -1.253     0.200
    76.670    -0.049     0.200
    78.771    -1.134     0.200
    78.771    -0.192     0.200
    79.790    -0.400     0.200
    79.790    -0.580     0.200
    79.974     0.003     0.200
    79.974     0.316     0.200
    89.369    -0.062     0.200
    17.811     1.889     0.200
    17.849     0.485     0.200
    18.275     2.320     0.200
    18.361     1.299     0.200
    22.402    -0.682     0.200
    76.596    -0.142     0.200
    80.059     0.396     0.200
    18.181    -0.187     0.200
    20.753    -1.292     0.200
    22.304     0.097     0.200
    42.123    -0.538     0.200
    49.241    -0.198     0.200
    59.979    -0.932     0.200
    18.540    -0.105     0.200
    18.823     0.481     0.200
    20.174    -0.924     0.200
    20.482    -0.870     0.200
    22.709     1.056     0.200
    45.850    -0.319     0.200
    46.397     0.004     0.200
    48.880     0.201     0.200
    50.284     0.900     0.200
    51.702     0.057     0.200
    59.689    -1.222     0.200
    76.253    -1.355     0.200
    79.719    -0.341     0.200
    17.283     0.619     0.200
    17.778     1.468     0.200
    21.986     0.852     0.200
    19.325    -1.691     0.200
    23.458    -0.189     0.200
    23.833    -1.175     0.200
    25.770     1.497     0.200
    19.297     0.445     0.200
    19.297     0.234     0.200
    19.384     0.433     0.200
    22.470     0.079     0.200
    23.365     0.851     0.200
    23.399     0.471     0.200
    25.785     0.573     0.200
    27.848     1.272     0.200
    30.882     0.145     0.200
    30.882     0.856     0.200
    35.462     0.273     0.200
    36.169    -0.710     0.200
    36.169     1.595     0.200
    41.552     1.050     0.200
    42.611     0.616     0.200
    42.611    -0.337     0.200
    47.003     0.275     0.200
    48.094     0.601     0.200
    48.394    -1.062     0.200
    49.007    -0.927     0.200
    51.613     0.806     0.200
    51.613     1.126     0.200
    58.207    -0.000     0.200
    40.088     1.216     0.200
    49.246    -0.093     0.200
    17.742     2.477     0.200
    20.180    -1.041     0.200
    20.180    -1.560     0.200
    22.254    -0.587     0.200
    22.289    -0.673     0.200
    32.053    -1.134     0.200
    36.546    -0.163     0.200
    41.787    -1.402     0.200
    42.619    -0.961     0.200
    47.614    -1.427     0.200
    48.709    -0.186     0.200
    59.410    -1.331     0.200
    76.804    -0.700     0.200
    76.804     0.777     0.200
    80.266    -0.521     0.200
    17.487     1.161     0.200
    18.125     1.976     0.200
    18.717     0.468     0.200
    20.738    -0.060     0.200
    22.243     2.873     0.200
    15.257     6.902     0.200
    18.508     0.208     0.200
    18.508    -0.902     0.200
    18.508     0.958     0.200
    18.591    -0.886     0.200
    18.591    -1.284     0.200
    18.594    -1.114     0.200
    20.254    -0.859     0.200
    20.254    -1.945     0.200
    21.652    -0.446     0.200
    22.632     0.621     0.200
    22.667    -0.370     0.200
    22.802    -0.677     0.200
    23.176    -0.046     0.200
    23.725     0.740     0.200
    24.049    -2.014     0.200
    24.215     0.838     0.200
    24.887     0.620     0.200
    24.966     1.426     0.200
    24.966     1.121     0.200
    27.001     0.699     0.200
    26.964     1.064     0.200
    27.032     0.303     0.200
    28.008    -0.589     0.200
    28.127    -1.418     0.200
    28.127    -0.129     0.200
    30.406    -0.475     0.200
    30.919     1.073     0.200
    30.892     0.064     0.200
    31.001     1.561     0.200
    31.484     0.350     0.200
    39.958     0.354     0.200
    41.468    -0.964     0.200
    42.166    -1.404     0.200
    42.166     1.869     0.200
    42.998    -0.187     0.200
    44.482     1.582     0.200
    47.988    -1.158     0.200
    48.683     0.077     0.200
    48.683    -0.352     0.200
    49.615    -0.058     0.200
    50.264     0.089     0.200
    51.123     0.157     0.200
    51.330     1.125     0.200
    51.504    -0.863     0.200
    52.138     0.836     0.200
    52.728     0.644     0.200
    52.962     0.336     0.200
    53.869     0.528     0.200
    53.957    -0.499     0.200
    54.725     1.500     0.200
    55.316     1.729     0.200
    55.668     1.554     0.200
    55.857     1.710     0.200
    56.529     1.305     0.200
    56.719     1.451     0.200
    56.792     1.488     0.200
    57.334     1.268     0.200
    57.478     0.159     0.200
    57.523     0.585     0.200
    58.389     1.402     0.200
    59.078    -0.778     0.200
    59.466    -1.307     0.200
    61.969     0.611     0.200
    65.121     1.956     0.200
    76.196     1.070     0.200
    76.483    -0.214     0.200
    79.166     1.253     0.200
    79.911     1.027     0.200
    79.951    -0.095     0.200
    79.951    -0.243     0.200
    84.870     0.761     0.200
    85.646     0.654     0.200
    87.170    -0.805     0.200
    89.236     0.037     0.200
    89.336     1.452     0.200
    17.805     2.479     0.200
    18.416    -0.977     0.200
    20.527    -1.442     0.200
    22.503     1.417     0.200
    76.361    -0.714     0.200
    79.823    -1.028     0.200
    17.762     1.093     0.200
    18.424    -0.852     0.200
    22.547     0.376     0.200
    49.144    -0.002     0.200
    20.306    -1.089     0.200
    22.338     1.185     0.200
    17.540     1.393     0.200
    18.194     1.568     0.200
    22.323     0.928     0.200
    60.001    -1.282     0.200
    17.539     1.265     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   100.498    -0.950     0.200
   100.498     4.450     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    13.669   320.582     0.200
    40.309   122.227     0.200
    41.053   119.079     0.200
    42.885   107.111     0.200
    43.146   108.201     0.200
    45.603    96.346     0.200
    47.785    89.748     0.200
    53.792    65.983     0.200
    55.020    58.748     0.200
    56.718    63.480     0.200
    56.898    53.698     0.200
    98.493    -0.320     0.200
    36.027   145.941     0.200
    39.530   126.131     0.200
    16.406   288.800     0.200
    24.056   220.241     0.200
    24.392   220.675     0.200
    39.235   127.189     0.200
    40.478   120.803     0.200
    50.849    76.888     0.200
    26.044   211.144     0.200
    26.837   206.485     0.200
    28.462   195.237     0.200
    47.574    93.846     0.200
    54.084    66.891     0.200
    40.385   126.216     0.200
    45.537    97.168     0.200
    22.638   232.340     0.200
    39.282   127.713     0.200
    40.352   122.914     0.200
    44.889   102.544     0.200
    45.021    99.207     0.200
    54.070    61.764     0.200
    30.225   182.120     0.200
    39.267   127.914     0.200
    40.573   122.066     0.200
    22.728   231.146     0.200
    46.535    92.272     0.200
    48.791    84.263     0.200
    28.536   190.991     0.200
    40.088   126.813     0.200
    16.773   291.781     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
