#!/bin/bash
gmt begin ushkan1.37_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times ushkan1.37'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   323.262
    25.500   327.805
    26.000   332.337
    26.500   336.857
    27.000   341.365
    27.500   345.856
    28.000   350.327
    28.500   354.783
    29.000   359.228
    29.500   363.664
    30.000   368.092
    30.500   372.513
    31.000   376.926
    31.500   381.331
    32.000   385.728
    32.500   390.115
    33.000   394.492
    33.500   398.856
    34.000   403.206
    34.500   407.541
    35.000   411.861
    35.500   416.165
    36.000   420.455
    36.500   424.730
    37.000   428.989
    37.500   433.232
    38.000   437.460
    38.500   441.671
    39.000   445.865
    39.500   450.043
    40.000   454.204
    40.500   458.348
    41.000   462.474
    41.500   466.584
    42.000   470.676
    42.500   474.752
    43.000   478.810
    43.500   482.850
    44.000   486.873
    44.500   490.877
    45.000   494.864
    45.500   498.833
    46.000   502.784
    46.500   506.717
    47.000   510.632
    47.500   514.529
    48.000   518.408
    48.500   522.269
    49.000   526.111
    49.500   529.935
    50.000   533.741
    50.500   537.529
    51.000   541.298
    51.500   545.050
    52.000   548.783
    52.500   552.498
    53.000   556.195
    53.500   559.875
    54.000   563.537
    54.500   567.180
    55.000   570.805
    55.500   574.411
    56.000   577.999
    56.500   581.568
    57.000   585.119
    57.500   588.652
    58.000   592.167
    58.500   595.663
    59.000   599.142
    59.500   602.602
    60.000   606.044
    60.500   609.467
    61.000   612.872
    61.500   616.259
    62.000   619.628
    62.500   622.978
    63.000   626.310
    63.500   629.625
    64.000   632.922
    64.500   636.200
    65.000   639.461
    65.500   642.704
    66.000   645.929
    66.500   649.136
    67.000   652.325
    67.500   655.495
    68.000   658.648
    68.500   661.782
    69.000   664.898
    69.500   667.996
    70.000   671.076
    70.500   674.138
    71.000   677.181
    71.500   680.207
    72.000   683.214
    72.500   686.203
    73.000   689.174
    73.500   692.126
    74.000   695.060
    74.500   697.974
    75.000   700.870
    75.500   703.748
    76.000   706.607
    76.500   709.448
    77.000   712.271
    77.500   715.075
    78.000   717.862
    78.500   720.631
    79.000   723.381
    79.500   726.113
    80.000   728.826
    80.500   731.521
    81.000   734.196
    81.500   736.851
    82.000   739.488
    82.500   742.106
    83.000   744.705
    83.500   747.285
    84.000   749.846
    84.500   752.386
    85.000   754.906
    85.500   757.406
    86.000   759.887
    86.500   762.351
    87.000   764.797
    87.500   767.220
    88.000   769.608
    88.500   771.974
    89.000   774.329
    89.500   776.674
    90.000   779.012
    90.500   781.343
    91.000   783.668
    91.500   785.987
    92.000   788.302
    92.500   790.612
    93.000   792.919
    93.500   795.223
    94.000   797.523
    94.500   799.819
    95.000   802.109
    95.500   804.393
    96.000   806.671
    96.500   808.943
    97.000   811.208
    97.500   813.466
    98.000   815.718
    98.500   817.962
    99.000   820.198
    99.500   822.427
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1121.427
   116.000  1122.389
   116.500  1123.351
   117.000  1124.313
   117.500  1125.275
   118.000  1126.237
   118.500  1127.199
   119.000  1128.161
   119.500  1129.122
   120.000  1130.083
   120.500  1131.044
   121.000  1132.005
   121.500  1132.966
   122.000  1133.926
   122.500  1134.886
   123.000  1135.845
   123.500  1136.805
   124.000  1137.763
   124.500  1138.721
   125.000  1139.679
   125.500  1140.636
   126.000  1141.593
   126.500  1142.549
   127.000  1143.504
   127.500  1144.458
   128.000  1145.412
   128.500  1146.365
   129.000  1147.316
   129.500  1148.267
   130.000  1149.217
   130.500  1150.166
   131.000  1151.114
   131.500  1152.060
   132.000  1153.005
   132.500  1153.949
   133.000  1154.891
   133.500  1155.831
   134.000  1156.770
   134.500  1157.707
   135.000  1158.642
   135.500  1159.576
   136.000  1160.507
   136.500  1161.436
   137.000  1162.362
   137.500  1163.286
   138.000  1164.207
   138.500  1165.126
   139.000  1166.042
   139.500  1166.954
   140.000  1167.864
   140.500  1168.770
   141.000  1169.673
   141.500  1170.571
   142.000  1171.466
   142.500  1172.356
   143.000  1173.242
   143.500  1174.123
   144.000  1175.000
   144.500  1175.871
   145.000  1176.736
   145.500  1177.596
   146.000  1178.450
   146.500  1179.298
   147.000  1180.139
   147.500  1180.973
   148.000  1181.800
   148.500  1182.619
   149.000  1183.431
   149.500  1184.233
   150.000  1185.026
   150.500  1185.810
   151.000  1186.583
   151.500  1187.347
   152.000  1188.100
   152.500  1188.843
   153.000  1189.577
   153.500  1190.300
   154.000  1191.012
   154.500  1191.713
   155.000  1192.404
   155.500  1193.083
   156.000  1193.750
   156.500  1194.405
   157.000  1195.049
   157.500  1195.680
   158.000  1196.299
   158.500  1196.906
   159.000  1197.500
   159.500  1198.081
   160.000  1198.650
   160.500  1199.205
   161.000  1199.748
   161.500  1200.277
   162.000  1200.793
   162.500  1201.296
   163.000  1201.786
   163.500  1202.262
   164.000  1202.724
   164.500  1203.172
   165.000  1203.607
   165.500  1204.027
   166.000  1204.434
   166.500  1204.827
   167.000  1205.206
   167.500  1205.572
   168.000  1205.922
   168.500  1206.260
   169.000  1206.582
   169.500  1206.891
   170.000  1207.186
   170.500  1207.466
   171.000  1207.732
   171.500  1207.984
   172.000  1208.221
   172.500  1208.444
   173.000  1208.653
   173.500  1208.848
   174.000  1209.028
   174.500  1209.194
   175.000  1209.345
   175.500  1209.483
   176.000  1209.605
   176.500  1209.713
   177.000  1209.807
   177.500  1209.887
   178.000  1209.951
   178.500  1210.002
   179.000  1210.038
   179.500  1210.060
   180.000  1210.067
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   992.366
     1.000   992.374
     1.500   992.388
     2.000   992.408
     2.500   992.433
     3.000   992.464
     3.500   992.500
     4.000   992.542
     4.500   992.589
     5.000   992.643
     5.500   992.701
     6.000   992.766
     6.500   992.836
     7.000   992.911
     7.500   992.992
     8.000   993.079
     8.500   993.171
     9.000   993.269
     9.500   993.372
    10.000   993.481
    10.500   993.595
    11.000   993.715
    11.500   993.841
    12.000   993.972
    12.500   994.109
    13.000   994.251
    13.500   994.398
    14.000   994.552
    14.500   994.711
    15.000   994.875
    15.500   995.045
    16.000   995.220
    16.500   995.401
    17.000   995.587
    17.500   995.779
    18.000   995.976
    18.500   996.179
    19.000   996.387
    19.500   996.600
    20.000   996.819
    20.500   997.044
    21.000   997.274
    21.500   997.509
    22.000   997.750
    22.500   997.996
    23.000   998.248
    23.500   998.505
    24.000   998.767
    24.500   999.035
    25.000   999.308
    25.500   999.587
    26.000   999.871
    26.500  1000.160
    27.000  1000.454
    27.500  1000.754
    28.000  1001.059
    28.500  1001.370
    29.000  1001.685
    29.500  1002.006
    30.000  1002.332
    30.500  1002.664
    31.000  1003.001
    31.500  1003.343
    32.000  1003.690
    32.500  1004.042
    33.000  1004.400
    33.500  1004.763
    34.000  1005.131
    34.500  1005.504
    35.000  1005.882
    35.500  1006.265
    36.000  1006.654
    36.500  1007.047
    37.000  1007.446
    37.500  1007.850
    38.000  1008.259
    38.500  1008.673
    39.000  1009.092
    39.500  1009.516
    40.000  1009.945
    40.500  1010.379
    41.000  1010.818
    41.500  1011.262
    42.000  1011.711
    42.500  1012.164
    43.000  1012.623
    43.500  1013.087
    44.000  1013.556
    44.500  1014.029
    45.000  1014.507
    45.500  1014.990
    46.000  1015.479
    46.500  1015.971
    47.000  1016.469
    47.500  1016.971
    48.000  1017.479
    48.500  1017.991
    49.000  1018.507
    49.500  1019.029
    50.000  1019.555
    50.500  1020.085
    51.000  1020.621
    51.500  1021.161
    52.000  1021.706
    52.500  1022.255
    53.000  1022.809
    53.500  1023.368
    54.000  1023.931
    54.500  1024.498
    55.000  1025.071
    55.500  1025.647
    56.000  1026.228
    56.500  1026.814
    57.000  1027.404
    57.500  1027.999
    58.000  1028.598
    58.500  1029.201
    59.000  1029.809
    59.500  1030.421
    60.000  1031.037
    60.500  1031.658
    61.000  1032.283
    61.500  1032.912
    62.000  1033.546
    62.500  1034.184
    63.000  1034.826
    63.500  1035.472
    64.000  1036.122
    64.500  1036.777
    65.000  1037.436
    65.500  1038.099
    66.000  1038.766
    66.500  1039.437
    67.000  1040.112
    67.500  1040.791
    68.000  1041.474
    68.500  1042.161
    69.000  1042.853
    69.500  1043.548
    70.000  1044.247
    70.500  1044.950
    71.000  1045.656
    71.500  1046.367
    72.000  1047.082
    72.500  1047.800
    73.000  1048.522
    73.500  1049.249
    74.000  1049.978
    74.500  1050.712
    75.000  1051.449
    75.500  1052.190
    76.000  1052.935
    76.500  1053.683
    77.000  1054.435
    77.500  1055.190
    78.000  1055.949
    78.500  1056.712
    79.000  1057.479
    79.500  1058.248
    80.000  1059.021
    80.500  1059.798
    81.000  1060.578
    81.500  1061.362
    82.000  1062.149
    82.500  1062.939
    83.000  1063.733
    83.500  1064.530
    84.000  1065.331
    84.500  1066.135
    85.000  1066.942
    85.500  1067.752
    86.000  1068.565
    86.500  1069.382
    87.000  1070.202
    87.500  1071.025
    88.000  1071.851
    88.500  1072.681
    89.000  1073.513
    89.500  1074.348
    90.000  1075.187
    90.500  1076.028
    91.000  1076.873
    91.500  1077.720
    92.000  1078.571
    92.500  1079.424
    93.000  1080.281
    93.500  1081.140
    94.000  1082.002
    94.500  1082.866
    95.000  1083.734
    95.500  1084.604
    96.000  1085.478
    96.500  1086.354
    97.000  1087.232
    97.500  1088.113
    98.000  1088.997
    98.500  1089.884
    99.000  1090.773
    99.500  1091.665
   100.000  1092.559
   100.500  1093.456
   101.000  1094.356
   101.500  1095.258
   102.000  1096.162
   102.500  1097.069
   103.000  1097.978
   103.500  1098.890
   104.000  1099.804
   104.500  1100.720
   105.000  1101.639
   105.500  1102.560
   106.000  1103.483
   106.500  1104.409
   107.000  1105.337
   107.500  1106.267
   108.000  1107.199
   108.500  1108.133
   109.000  1109.070
   109.500  1110.008
   110.000  1110.949
   110.500  1111.892
   111.000  1112.837
   111.500  1113.783
   112.000  1114.732
   112.500  1115.683
   113.000  1116.635
   113.500  1117.590
   114.000  1118.547
   114.500  1119.505
   115.000  1120.465
   115.500  1121.427
   116.000  1122.391
   116.500  1123.357
   117.000  1124.324
   117.500  1125.293
   118.000  1126.264
   118.500  1127.236
   119.000  1128.210
   119.500  1129.186
   120.000  1130.164
   120.500  1131.142
   121.000  1132.123
   121.500  1133.105
   122.000  1134.089
   122.500  1135.073
   123.000  1136.060
   123.500  1137.048
   124.000  1138.037
   124.500  1139.028
   125.000  1140.020
   125.500  1141.013
   126.000  1142.008
   126.500  1143.004
   127.000  1144.002
   127.500  1145.000
   128.000  1146.000
   128.500  1147.001
   129.000  1148.003
   129.500  1149.006
   130.000  1150.011
   130.500  1151.017
   131.000  1152.023
   131.500  1153.031
   132.000  1154.040
   132.500  1155.050
   133.000  1156.060
   133.500  1157.072
   134.000  1158.085
   134.500  1159.098
   135.000  1160.113
   135.500  1161.128
   136.000  1162.145
   136.500  1163.162
   137.000  1164.180
   137.500  1165.198
   138.000  1166.218
   138.500  1167.238
   139.000  1168.259
   139.500  1169.281
   140.000  1170.303
   140.500  1171.326
   141.000  1172.350
   141.500  1173.374
   142.000  1174.399
   142.500  1175.424
   143.000  1176.450
   143.500  1177.476
   144.000  1178.503
   144.500  1179.531
   145.000  1180.559
   145.500  1181.587
   146.000  1182.616
   146.500  1183.645
   147.000  1184.674
   147.500  1185.704
   148.000  1186.734
   148.500  1187.765
   149.000  1188.796
   149.500  1189.827
   150.000  1190.858
   150.500  1191.889
   151.000  1192.921
   151.500  1193.953
   152.000  1194.985
   152.500  1196.017
   153.000  1197.050
   153.500  1198.082
   154.000  1199.115
   154.500  1200.147
   155.000  1201.180
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.056
   145.500  1177.880
   146.000  1179.761
   146.500  1181.678
   147.000  1183.624
   147.500  1185.592
   148.000  1187.580
   148.500  1189.586
   149.000  1191.608
   149.500  1193.643
   150.000  1195.691
   150.500  1197.751
   151.000  1199.821
   151.500  1201.901
   152.000  1203.989
   152.500  1206.086
   153.000  1208.191
   153.500  1210.304
   154.000  1212.423
   154.500  1214.549
   155.000  1216.680
   155.500  1218.818
   156.000  1220.961
   156.500  1223.108
   157.000  1225.261
   157.500  1227.418
   158.000  1229.579
   158.500  1231.745
   159.000  1233.914
   159.500  1236.087
   160.000  1238.263
   160.500  1240.443
   161.000  1242.625
   161.500  1244.811
   162.000  1246.999
   162.500  1249.190
   163.000  1251.383
   163.500  1253.578
   164.000  1255.776
   164.500  1257.976
   165.000  1260.177
   165.500  1262.380
   166.000  1264.586
   166.500  1266.792
   167.000  1269.001
   167.500  1271.210
   168.000  1273.421
   168.500  1275.634
   169.000  1277.847
   169.500  1280.061
   170.000  1282.277
   170.500  1284.493
   171.000  1286.710
   171.500  1288.928
   172.000  1291.147
   172.500  1293.367
   173.000  1295.587
   173.500  1297.807
   174.000  1300.028
   174.500  1302.250
   175.000  1304.471
   175.500  1306.693
   176.000  1308.916
   176.500  1311.138
   177.000  1313.361
   177.500  1315.584
   178.000  1317.806
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.052
   145.500  1177.677
   146.000  1179.224
   146.500  1180.713
   147.000  1182.152
   147.500  1183.546
   148.000  1184.898
   148.500  1186.209
   149.000  1187.486
   149.500  1188.735
   150.000  1189.958
   150.500  1191.158
   151.000  1192.338
   151.500  1193.498
   152.000  1194.641
   152.500  1195.765
   153.000  1196.874
   153.500  1197.968
   154.000  1199.049
   154.500  1200.117
   155.000  1201.172
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   509.241
     1.000   509.277
     1.500   509.337
     2.000   509.421
     2.500   509.529
     3.000   509.661
     3.500   509.817
     4.000   509.997
     4.500   510.201
     5.000   510.428
     5.500   510.680
     6.000   510.955
     6.500   511.253
     7.000   511.576
     7.500   511.922
     8.000   512.291
     8.500   512.684
     9.000   513.100
     9.500   513.540
    10.000   514.003
    10.500   514.489
    11.000   514.997
    11.500   515.529
    12.000   516.084
    12.500   516.661
    13.000   517.261
    13.500   517.883
    14.000   518.528
    14.500   519.195
    15.000   519.884
    15.500   520.596
    16.000   521.329
    16.500   522.084
    17.000   522.860
    17.500   523.658
    18.000   524.478
    18.500   525.318
    19.000   526.180
    19.500   527.062
    20.000   527.966
    20.500   528.890
    21.000   529.834
    21.500   530.799
    22.000   531.784
    22.500   532.789
    23.000   533.813
    23.500   534.858
    24.000   535.922
    24.500   537.005
    25.000   538.107
    25.500   539.228
    26.000   540.368
    26.500   541.527
    27.000   542.704
    27.500   543.900
    28.000   545.113
    28.500   546.345
    29.000   547.594
    29.500   548.860
    30.000   550.145
    30.500   551.446
    31.000   552.764
    31.500   554.099
    32.000   555.451
    32.500   556.819
    33.000   558.203
    33.500   559.604
    34.000   561.020
    34.500   562.452
    35.000   563.899
    35.500   565.362
    36.000   566.840
    36.500   568.333
    37.000   569.841
    37.500   571.363
    38.000   572.900
    38.500   574.451
    39.000   576.016
    39.500   577.594
    40.000   579.187
    40.500   580.793
    41.000   582.412
    41.500   584.044
    42.000   585.689
    42.500   587.347
    43.000   589.017
    43.500   590.700
    44.000   592.395
    44.500   594.102
    45.000   595.821
    45.500   597.551
    46.000   599.293
    46.500   601.047
    47.000   602.811
    47.500   604.586
    48.000   606.373
    48.500   608.170
    49.000   609.977
    49.500   611.794
    50.000   613.622
    50.500   615.460
    51.000   617.307
    51.500   619.164
    52.000   621.031
    52.500   622.907
    53.000   624.792
    53.500   626.686
    54.000   628.588
    54.500   630.500
    55.000   632.420
    55.500   634.348
    56.000   636.285
    56.500   638.229
    57.000   640.182
    57.500   642.142
    58.000   644.110
    58.500   646.086
    59.000   648.068
    59.500   650.058
    60.000   652.055
    60.500   654.059
    61.000   656.070
    61.500   658.087
    62.000   660.111
    62.500   662.141
    63.000   664.177
    63.500   666.220
    64.000   668.268
    64.500   670.322
    65.000   672.382
    65.500   674.448
    66.000   676.519
    66.500   678.595
    67.000   680.677
    67.500   682.763
    68.000   684.855
    68.500   686.951
    69.000   689.053
    69.500   691.159
    70.000   693.269
    70.500   695.384
    71.000   697.503
    71.500   699.626
    72.000   701.753
    72.500   703.885
    73.000   706.020
    73.500   708.159
    74.000   710.301
    74.500   712.447
    75.000   714.597
    75.500   716.750
    76.000   718.906
    76.500   721.065
    77.000   723.228
    77.500   725.393
    78.000   727.561
    78.500   729.732
    79.000   731.906
    79.500   734.083
    80.000   736.262
    80.500   738.443
    81.000   740.627
    81.500   742.813
    82.000   745.001
    82.500   747.191
    83.000   749.384
    83.500   751.578
    84.000   753.774
    84.500   755.972
    85.000   758.172
    85.500   760.373
    86.000   762.576
    86.500   764.781
    87.000   766.987
    87.500   769.194
    88.000   771.403
    88.500   773.613
    89.000   775.824
    89.500   778.036
    90.000   780.249
    90.500   782.464
    91.000   784.679
    91.500   786.895
    92.000   789.112
    92.500   791.329
    93.000   793.548
    93.500   795.767
    94.000   797.987
    94.500   800.207
    95.000   802.427
    95.500   804.648
    96.000   806.870
    96.500   809.092
    97.000   811.314
    97.500   813.536
    98.000   815.759
    98.500   817.981
    99.000   820.204
    99.500   822.427
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.141
    29.000   424.698
    29.500   430.255
    30.000   435.811
    30.500   441.366
    31.000   446.920
    31.500   452.471
    32.000   458.021
    32.500   463.568
    33.000   469.113
    33.500   474.654
    34.000   480.191
    34.500   485.724
    35.000   491.253
    35.500   496.776
    36.000   502.294
    36.500   507.806
    37.000   513.311
    37.500   518.809
    38.000   524.299
    38.500   529.781
    39.000   535.254
    39.500   540.718
    40.000   546.171
    40.500   551.614
    41.000   557.046
    41.500   562.466
    42.000   567.874
    42.500   573.269
    43.000   578.650
    43.500   584.018
    44.000   589.371
    44.500   594.709
    45.000   600.032
    45.500   605.340
    46.000   610.631
    46.500   615.905
    47.000   621.163
    47.500   625.884
    48.000   630.455
    48.500   635.021
    49.000   639.582
    49.500   644.139
    50.000   648.690
    50.500   653.236
    51.000   657.777
    51.500   662.312
    52.000   666.842
    52.500   671.366
    53.000   675.884
    53.500   680.396
    54.000   684.901
    54.500   689.398
    55.000   693.886
    55.500   698.364
    56.000   702.831
    56.500   707.291
    57.000   711.744
    57.500   716.193
    58.000   720.636
    58.500   725.074
    59.000   729.509
    59.500   733.940
    60.000   738.366
    60.500   742.789
    61.000   747.208
    61.500   751.624
    62.000   756.035
    62.500   760.443
    63.000   764.847
    63.500   769.246
    64.000   773.641
    64.500   778.032
    65.000   782.418
    65.500   786.798
    66.000   791.172
    66.500   795.541
    67.000   799.902
    67.500   804.257
    68.000   808.604
    68.500   812.944
    69.000   817.276
    69.500   821.601
    70.000   825.918
    70.500   830.227
    71.000   834.529
    71.500   838.824
    72.000   843.111
    72.500   847.390
    73.000   851.662
    73.500   855.926
    74.000   860.182
    74.500   864.430
    75.000   868.670
    75.500   872.903
    76.000   877.127
    76.500   881.344
    77.000   885.552
    77.500   889.752
    78.000   893.943
    78.500   898.126
    79.000   902.301
    79.500   906.467
    80.000   910.625
    80.500   914.774
    81.000   918.914
    81.500   923.046
    82.000   927.169
    82.500   931.284
    83.000   935.391
    83.500   939.489
    84.000   943.578
    84.500   947.659
    85.000   951.731
    85.500   955.794
    86.000   959.849
    86.500   963.894
    87.000   967.931
    87.500   971.960
    88.000   975.979
    88.500   979.989
    89.000   983.991
    89.500   987.983
    90.000   991.966
    90.500   995.941
    91.000   999.907
    91.500  1003.863
    92.000  1007.811
    92.500  1011.749
    93.000  1015.679
    93.500  1019.599
    94.000  1023.511
    94.500  1027.413
    95.000  1031.307
    95.500  1035.191
    96.000  1039.067
    96.500  1042.933
    97.000  1046.790
    97.500  1050.638
    98.000  1054.477
    98.500  1058.307
    99.000  1062.127
    99.500  1065.939
   100.000  1069.741
   100.500  1073.535
   101.000  1077.319
   101.500  1081.094
   102.000  1084.859
   102.500  1088.616
   103.000  1092.364
   103.500  1096.102
   104.000  1099.832
   104.500  1103.552
   105.000  1107.264
   105.500  1110.967
   106.000  1114.661
   106.500  1118.346
   107.000  1122.022
   107.500  1125.690
   108.000  1129.347
   108.500  1132.996
   109.000  1136.636
   109.500  1140.266
   110.000  1143.887
   110.500  1147.499
   111.000  1151.102
   111.500  1154.695
   112.000  1158.279
   112.500  1161.854
   113.000  1165.419
   113.500  1168.976
   114.000  1172.523
   114.500  1176.062
   115.000  1179.591
   115.500  1183.111
   116.000  1186.623
   116.500  1190.125
   117.000  1193.618
   117.500  1197.102
   118.000  1200.577
   118.500  1204.042
   119.000  1207.499
   119.500  1210.946
   120.000  1214.385
   120.500  1217.813
   121.000  1221.233
   121.500  1224.644
   122.000  1228.045
   122.500  1231.437
   123.000  1234.820
   123.500  1238.194
   124.000  1241.559
   124.500  1244.915
   125.000  1248.261
   125.500  1251.599
   126.000  1254.928
   126.500  1258.248
   127.000  1261.559
   127.500  1264.861
   128.000  1268.154
   128.500  1271.438
   129.000  1274.713
   129.500  1277.979
   130.000  1281.237
   130.500  1284.485
   131.000  1287.724
   131.500  1290.954
   132.000  1294.176
   132.500  1297.388
   133.000  1300.591
   133.500  1303.785
   134.000  1306.970
   134.500  1310.146
   135.000  1313.313
   135.500  1316.471
   136.000  1319.619
   136.500  1322.759
   137.000  1325.890
   137.500  1329.011
   138.000  1332.124
   138.500  1335.227
   139.000  1338.321
   139.500  1341.406
   140.000  1344.482
   140.500  1347.549
   141.000  1350.607
   141.500  1353.656
   142.000  1356.696
   142.500  1359.727
   143.000  1362.749
   143.500  1365.761
   144.000  1368.765
   144.500  1371.759
   145.000  1374.745
   145.500  1377.721
   146.000  1380.688
   146.500  1383.645
   147.000  1386.594
   147.500  1389.532
   148.000  1392.462
   148.500  1395.382
   149.000  1398.293
   149.500  1401.194
   150.000  1404.086
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   824.650
   100.500   826.872
   101.000   829.095
   101.500   831.318
   102.000   833.541
   102.500   835.764
   103.000   837.987
   103.500   840.210
   104.000   842.432
   104.500   844.655
   105.000   846.878
   105.500   849.101
   106.000   851.324
   106.500   853.547
   107.000   855.769
   107.500   857.992
   108.000   860.215
   108.500   862.438
   109.000   864.661
   109.500   866.884
   110.000   869.106
   110.500   871.329
   111.000   873.552
   111.500   875.775
   112.000   877.998
   112.500   880.221
   113.000   882.443
   113.500   884.666
   114.000   886.889
   114.500   889.112
   115.000   891.335
   115.500   893.558
   116.000   895.780
   116.500   898.003
   117.000   900.226
   117.500   902.449
   118.000   904.672
   118.500   906.895
   119.000   909.117
   119.500   911.340
   120.000   913.563
   120.500   915.786
   121.000   918.009
   121.500   920.232
   122.000   922.454
   122.500   924.677
   123.000   926.900
   123.500   929.123
   124.000   931.346
   124.500   933.569
   125.000   935.791
   125.500   938.014
   126.000   940.237
   126.500   942.460
   127.000   944.683
   127.500   946.906
   128.000   949.128
   128.500   951.351
   129.000   953.574
   129.500   955.797
   130.000   958.020
   130.500   960.243
   131.000   962.465
   131.500   964.688
   132.000   966.911
   132.500   969.134
   133.000   971.357
   133.500   973.580
   134.000   975.802
   134.500   978.025
   135.000   980.248
   135.500   982.471
   136.000   984.694
   136.500   986.917
   137.000   989.139
   137.500   991.362
   138.000   993.585
   138.500   995.808
   139.000   998.031
   139.500  1000.254
   140.000  1002.476
   140.500  1004.699
   141.000  1006.922
   141.500  1009.145
   142.000  1011.368
   142.500  1013.591
   143.000  1015.813
   143.500  1018.036
   144.000  1020.259
   144.500  1022.482
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   384.778
    15.000   395.017
    15.500   405.251
    16.000   415.479
    16.500   425.695
    17.000   435.898
    17.500   446.082
    18.000   456.243
    18.500   466.375
    19.000   476.474
    19.500   486.532
    20.000   496.545
    20.500   506.505
    21.000   516.408
    21.500   526.248
    22.000   536.020
    22.500   545.719
    23.000   554.331
    23.500   562.473
    24.000   570.581
    24.500   578.656
    25.000   586.687
    25.500   594.638
    26.000   602.549
    26.500   610.449
    27.000   618.340
    27.500   626.224
    28.000   634.100
    28.500   641.971
    29.000   649.834
    29.500   657.691
    30.000   665.541
    30.500   673.382
    31.000   681.214
    31.500   689.034
    32.000   696.842
    32.500   704.635
    33.000   712.413
    33.500   720.174
    34.000   727.917
    34.500   735.642
    35.000   743.348
    35.500   751.034
    36.000   758.700
    36.500   766.347
    37.000   773.973
    37.500   781.579
    38.000   789.163
    38.500   796.726
    39.000   804.266
    39.500   811.785
    40.000   819.280
    40.500   826.752
    41.000   834.201
    41.500   841.626
    42.000   849.027
    42.500   856.404
    43.000   863.757
    43.500   871.085
    44.000   878.389
    44.500   885.667
    45.000   892.920
    45.500   900.149
    46.000   907.351
    46.500   914.528
    47.000   921.678
    47.500   928.802
    48.000   935.900
    48.500   942.970
    49.000   950.014
    49.500   957.031
    50.000   964.020
    50.500   970.983
    51.000   977.918
    51.500   984.826
    52.000   991.706
    52.500   998.559
    53.000  1005.384
    53.500  1012.184
    54.000  1018.957
    54.500  1025.705
    55.000  1032.425
    55.500  1039.119
    56.000  1045.785
    56.500  1052.423
    57.000  1059.033
    57.500  1065.615
    58.000  1072.169
    58.500  1078.695
    59.000  1085.194
    59.500  1091.665
    60.000  1098.108
    60.500  1104.524
    61.000  1110.911
    61.500  1117.271
    62.000  1123.603
    62.500  1129.906
    63.000  1136.180
    63.500  1142.426
    64.000  1148.644
    64.500  1154.833
    65.000  1160.994
    65.500  1167.127
    66.000  1173.231
    66.500  1179.307
    67.000  1185.355
    67.500  1191.375
    68.000  1197.366
    68.500  1203.328
    69.000  1209.262
    69.500  1215.167
    70.000  1221.043
    70.500  1226.891
    71.000  1232.709
    71.500  1238.499
    72.000  1244.260
    72.500  1249.991
    73.000  1255.693
    73.500  1261.364
    74.000  1267.005
    74.500  1272.617
    75.000  1278.199
    75.500  1283.751
    76.000  1289.274
    76.500  1294.768
    77.000  1300.232
    77.500  1305.666
    78.000  1311.070
    78.500  1316.443
    79.000  1321.787
    79.500  1327.101
    80.000  1332.386
    80.500  1337.641
    81.000  1342.866
    81.500  1348.060
    82.000  1353.222
    82.500  1358.352
    83.000  1363.451
    83.500  1368.517
    84.000  1373.553
    84.500  1378.558
    85.000  1383.532
    85.500  1388.474
    86.000  1393.385
    86.500  1398.264
    87.000  1403.110
    87.500  1407.924
    88.000  1412.705
    88.500  1417.453
    89.000  1422.167
    89.500  1426.849
    90.000  1431.496
    90.500  1436.110
    91.000  1440.690
    91.500  1445.236
    92.000  1449.748
    92.500  1454.226
    93.000  1458.671
    93.500  1463.081
    94.000  1467.466
    94.500  1471.833
    95.000  1476.188
    95.500  1480.531
    96.000  1484.863
    96.500  1489.181
    97.000  1493.483
    97.500  1497.765
    98.000  1502.026
    98.500  1506.268
    99.000  1510.490
    99.500  1514.693
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   719.628
     1.000   719.675
     1.500   719.753
     2.000   719.862
     2.500   720.002
     3.000   720.173
     3.500   720.375
     4.000   720.608
     4.500   720.872
     5.000   721.167
     5.500   721.493
     6.000   721.849
     6.500   722.236
     7.000   722.653
     7.500   723.101
     8.000   723.579
     8.500   724.087
     9.000   724.625
     9.500   725.194
    10.000   725.792
    10.500   726.419
    11.000   727.077
    11.500   727.763
    12.000   728.479
    12.500   729.223
    13.000   729.997
    13.500   730.799
    14.000   731.630
    14.500   732.488
    15.000   733.375
    15.500   734.290
    16.000   735.233
    16.500   736.202
    17.000   737.199
    17.500   738.224
    18.000   739.274
    18.500   740.352
    19.000   741.455
    19.500   742.585
    20.000   743.740
    20.500   744.921
    21.000   746.127
    21.500   747.358
    22.000   748.614
    22.500   749.894
    23.000   751.198
    23.500   752.527
    24.000   753.878
    24.500   755.254
    25.000   756.652
    25.500   758.073
    26.000   759.516
    26.500   760.981
    27.000   762.469
    27.500   763.977
    28.000   765.507
    28.500   767.058
    29.000   768.630
    29.500   770.221
    30.000   771.833
    30.500   773.464
    31.000   775.115
    31.500   776.784
    32.000   778.473
    32.500   780.179
    33.000   781.904
    33.500   783.646
    34.000   785.405
    34.500   787.182
    35.000   788.975
    35.500   790.785
    36.000   792.610
    36.500   794.451
    37.000   796.308
    37.500   798.180
    38.000   800.066
    38.500   801.966
    39.000   803.881
    39.500   805.809
    40.000   807.751
    40.500   809.705
    41.000   811.673
    41.500   813.652
    42.000   815.644
    42.500   817.647
    43.000   819.661
    43.500   821.687
    44.000   823.723
    44.500   825.770
    45.000   827.826
    45.500   829.892
    46.000   831.968
    46.500   834.052
    47.000   836.146
    47.500   838.247
    48.000   840.357
    48.500   842.475
    49.000   844.600
    49.500   846.732
    50.000   848.871
    50.500   851.016
    51.000   853.168
    51.500   855.326
    52.000   857.489
    52.500   859.658
    53.000   861.831
    53.500   864.010
    54.000   866.193
    54.500   868.380
    55.000   870.572
    55.500   872.767
    56.000   874.965
    56.500   877.167
    57.000   879.372
    57.500   881.579
    58.000   883.789
    58.500   886.001
    59.000   888.215
    59.500   890.431
    60.000   892.648
    60.500   894.867
    61.000   897.087
    61.500   899.308
    62.000   901.530
    62.500   903.752
    63.000   905.975
    63.500   908.197
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   931.683
     1.000   931.749
     1.500   931.860
     2.000   932.015
     2.500   932.214
     3.000   932.457
     3.500   932.745
     4.000   933.077
     4.500   933.452
     5.000   933.872
     5.500   934.336
     6.000   934.843
     6.500   935.394
     7.000   935.989
     7.500   936.627
     8.000   937.308
     8.500   938.033
     9.000   938.801
     9.500   939.612
    10.000   940.465
    10.500   941.361
    11.000   942.300
    11.500   943.281
    12.000   944.304
    12.500   945.369
    13.000   946.476
    13.500   947.624
    14.000   948.814
    14.500   950.045
    15.000   951.316
    15.500   952.629
    16.000   953.982
    16.500   955.375
    17.000   956.808
    17.500   958.281
    18.000   959.793
    18.500   961.345
    19.000   962.935
    19.500   964.564
    20.000   966.232
    20.500   967.938
    21.000   969.681
    21.500   971.462
    22.000   973.281
    22.500   975.136
    23.000   977.029
    23.500   978.957
    24.000   980.922
    24.500   982.922
    25.000   984.958
    25.500   987.029
    26.000   989.135
    26.500   991.276
    27.000   993.451
    27.500   995.659
    28.000   997.901
    28.500  1000.177
    29.000  1002.485
    29.500  1004.826
    30.000  1007.200
    30.500  1009.605
    31.000  1012.042
    31.500  1014.510
    32.000  1017.009
    32.500  1019.538
    33.000  1022.098
    33.500  1024.688
    34.000  1027.307
    34.500  1029.956
    35.000  1032.633
    35.500  1035.339
    36.000  1038.074
    36.500  1040.836
    37.000  1043.626
    37.500  1046.443
    38.000  1049.287
    38.500  1052.157
    39.000  1055.054
    39.500  1057.976
    40.000  1060.924
    40.500  1063.898
    41.000  1066.896
    41.500  1069.919
    42.000  1072.966
    42.500  1076.037
    43.000  1079.131
    43.500  1082.249
    44.000  1085.389
    44.500  1088.553
    45.000  1091.738
    45.500  1094.946
    46.000  1098.175
    46.500  1101.425
    47.000  1104.697
    47.500  1107.989
    48.000  1111.302
    48.500  1114.634
    49.000  1117.987
    49.500  1121.359
    50.000  1124.750
    50.500  1128.160
    51.000  1131.589
    51.500  1135.035
    52.000  1138.500
    52.500  1141.983
    53.000  1145.483
    53.500  1149.000
    54.000  1152.534
    54.500  1156.084
    55.000  1159.651
    55.500  1163.234
    56.000  1166.832
    56.500  1170.446
    57.000  1174.075
    57.500  1177.719
    58.000  1181.378
    58.500  1185.051
    59.000  1188.738
    59.500  1192.439
    60.000  1196.154
    60.500  1199.882
    61.000  1203.623
    61.500  1207.377
    62.000  1211.143
    62.500  1214.922
    63.000  1218.713
    63.500  1222.516
    64.000  1226.330
    64.500  1230.156
    65.000  1233.993
    65.500  1237.841
    66.000  1241.700
    66.500  1245.569
    67.000  1249.448
    67.500  1253.338
    68.000  1257.237
    68.500  1261.146
    69.000  1265.064
    69.500  1268.992
    70.000  1272.928
    70.500  1276.873
    71.000  1280.827
    71.500  1284.789
    72.000  1288.760
    72.500  1292.738
    73.000  1296.724
    73.500  1300.717
    74.000  1304.718
    74.500  1308.726
    75.000  1312.741
    75.500  1316.763
    76.000  1320.792
    76.500  1324.827
    77.000  1328.868
    77.500  1332.915
    78.000  1336.969
    78.500  1341.027
    79.000  1345.092
    79.500  1349.162
    80.000  1353.237
    80.500  1357.318
    81.000  1361.403
    81.500  1365.493
    82.000  1369.587
    82.500  1373.686
    83.000  1377.790
    83.500  1381.897
    84.000  1386.009
    84.500  1390.124
    85.000  1394.243
    85.500  1398.365
    86.000  1402.491
    86.500  1406.620
    87.000  1410.753
    87.500  1414.888
    88.000  1419.026
    88.500  1423.167
    89.000  1427.310
    89.500  1431.456
    90.000  1435.604
    90.500  1439.755
    91.000  1443.907
    91.500  1448.062
    92.000  1452.218
    92.500  1456.376
    93.000  1460.535
    93.500  1464.696
    94.000  1468.859
    94.500  1473.022
    95.000  1477.187
    95.500  1481.353
    96.000  1485.520
    96.500  1489.687
    97.000  1493.855
    97.500  1498.024
    98.000  1502.193
    98.500  1506.363
    99.000  1510.533
    99.500  1514.703
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   772.732
    29.500   782.972
    30.000   793.210
    30.500   803.446
    31.000   813.680
    31.500   823.910
    32.000   834.137
    32.500   844.358
    33.000   854.573
    33.500   864.781
    34.000   874.981
    34.500   885.173
    35.000   895.354
    35.500   905.523
    36.000   915.681
    36.500   925.824
    37.000   935.952
    37.500   946.063
    38.000   956.156
    38.500   965.973
    39.000   976.282
    39.500   986.312
    40.000   996.317
    40.500  1006.297
    41.000  1016.250
    41.500  1026.174
    42.000  1036.068
    42.500  1045.931
    43.000  1055.761
    43.500  1065.557
    44.000  1075.318
    44.500  1085.043
    45.000  1094.731
    45.500  1104.045
    46.000  1112.214
    46.500  1120.367
    47.000  1128.502
    47.500  1136.621
    48.000  1144.724
    48.500  1152.810
    49.000  1160.879
    49.500  1168.927
    50.000  1176.949
    50.500  1184.933
    51.000  1192.863
    51.500  1200.778
    52.000  1208.687
    52.500  1216.590
    53.000  1224.488
    53.500  1232.382
    54.000  1240.271
    54.500  1248.157
    55.000  1256.040
    55.500  1263.919
    56.000  1271.795
    56.500  1279.667
    57.000  1287.536
    57.500  1295.402
    58.000  1303.264
    58.500  1311.123
    59.000  1318.979
    59.500  1326.831
    60.000  1334.679
    60.500  1342.524
    61.000  1350.364
    61.500  1358.199
    62.000  1366.028
    62.500  1373.853
    63.000  1381.671
    63.500  1389.483
    64.000  1397.288
    64.500  1405.086
    65.000  1412.877
    65.500  1420.660
    66.000  1428.435
    66.500  1436.202
    67.000  1443.959
    67.500  1451.708
    68.000  1459.449
    68.500  1467.179
    69.000  1474.901
    69.500  1482.613
    70.000  1490.315
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     1.823    36.225     0.150
     1.985    57.625     0.150
     3.011    97.625     0.150
     3.661   110.625     0.150
     4.742    90.625     0.150
     5.041   164.924     0.150
     1.902    32.820     0.150
     1.902    34.721     0.150
     1.949    60.221     0.150
     1.949    34.221     0.150
     1.949    60.221     0.150
     3.245    51.021     0.150
     3.245    89.721     0.150
     3.245    99.721     0.150
     3.350    50.621     0.150
     3.350    56.920     0.150
     3.520    55.320     0.150
     4.888    73.920     0.150
     4.888    93.420     0.150
     4.888   131.521     0.150
     4.888   152.021     0.150
     4.925    74.721     0.150
     4.925    90.721     0.150
     4.925   154.221     0.150
     5.297   144.521     0.150
    13.284   400.721     0.150
    13.284   422.721     0.150
    13.492   191.721     0.150
    13.492   333.721     0.150
    13.669   347.721     0.150
    13.669   375.721     0.150
    13.669   700.721     0.150
    13.669   708.721     0.150
    13.669   189.521     0.150
    13.669   347.721     0.150
    14.673   205.721     0.150
    14.673   373.721     0.150
    14.784   204.721     0.150
    14.784   375.721     0.150
    14.784   465.721     0.150
    14.911   383.221     0.150
    15.011   378.721     0.150
    15.732     2.600     0.150
    15.732   486.721     0.150
    15.732   510.721     0.150
    16.332   413.721     0.150
    16.332   424.721     0.150
    16.332   504.721     0.150
    17.148   239.721     0.150
    17.148    15.000     0.150
    17.293   240.721     0.150
    17.293   240.721     0.150
    17.293   240.721     0.150
    17.293   240.721     0.150
    17.884   246.721     0.150
    17.884   447.721     0.150
    18.126   251.221     0.150
    18.126     3.500     0.150
    18.126   461.721     0.150
    18.315   244.920     0.150
    18.315   244.920     0.150
    19.836   267.721     0.150
    19.836   485.721     0.150
    19.818   623.721     0.150
    22.476   297.721     0.150
    22.476   338.721     0.150
    22.476   541.721     0.150
    22.837   301.721     0.150
    22.837   545.721     0.150
    22.934   304.721     0.150
    22.934   552.721     0.150
    23.136   305.721     0.150
    23.241     4.900     0.150
    23.241    27.801     0.150
    23.241   560.420     0.150
    23.294    15.000     0.150
    23.294   305.721     0.150
    23.294    15.000     0.150
    23.294   348.721     0.150
    23.294   617.721     0.150
    23.334   352.721     0.150
    23.334   614.721     0.150
    23.632   312.721     0.150
    24.412   317.721     0.150
    24.412    35.000     0.150
    25.085     6.000     0.150
    25.085   591.721     0.150
    25.085   325.920     0.150
    25.085     6.000     0.150
    25.085   367.721     0.150
    25.085   591.721     0.150
    26.483   338.721     0.150
    26.655   345.721     0.150
    27.167   341.721     0.150
    27.167   712.721     0.150
    27.425   349.920     0.150
    28.379    13.000     0.150
    28.379   353.721     0.150
    28.379     5.000     0.150
    28.379    13.000     0.150
    28.379   399.721     0.150
    28.379   716.721     0.150
    28.379   736.721     0.150
    29.126   360.721     0.150
    29.074   364.721     0.150
    29.074   364.721     0.150
    30.395   371.721     0.150
    30.395   661.721     0.150
    30.395   768.920     0.150
    30.911   380.920     0.150
    30.986   377.721     0.150
    30.986   685.721     0.150
    31.386   380.320     0.150
    31.530   381.721     0.150
    31.530   461.721     0.150
    31.530   681.721     0.150
    31.530   820.721     0.150
    32.401   987.721     0.150
    32.580   396.021     0.150
    34.163   405.221     0.150
    34.163   731.721     0.150
    35.540   416.320     0.150
    35.540   511.721     0.150
    35.540   753.721     0.150
    35.540   769.721     0.150
    36.790   426.820     0.150
    37.555   417.221     0.150
    37.555   440.221     0.150
    37.888   439.721     0.150
    38.267   441.721     0.150
    38.725   449.920     0.150
    39.480   449.721     0.150
    39.480   577.721     0.150
    39.480   807.721     0.150
    40.309    12.400     0.150
    40.309    18.400     0.150
    40.309   583.721     0.150
    40.309   837.721     0.150
    40.309  1035.721     0.150
    40.309   456.320     0.150
    40.309    12.400     0.150
    40.309   551.721     0.150
    40.309   578.721     0.150
    40.309   583.721     0.150
    40.309  1003.721     0.150
    40.309  1035.721     0.150
    41.053   462.721     0.150
    41.053   593.721     0.150
    41.053   836.721     0.150
    41.221   466.721     0.150
    41.297   470.221     0.150
    41.747   470.721     0.150
    42.885   477.721     0.150
    43.146   480.920     0.150
    43.166   479.621     0.150
    44.490   492.721     0.150
    44.934   883.721     0.150
    44.934   494.721     0.150
    44.934   883.721     0.150
    45.069   494.721     0.150
    45.603   498.721     0.150
    45.603   913.721     0.150
    47.034   516.920     0.150
    47.896   516.820     0.150
    47.879   518.221     0.150
    47.879   518.221     0.150
    48.928   524.721     0.150
    48.928     6.000     0.150
    48.928   945.721     0.150
    48.928   966.721     0.150
    49.213   538.721     0.150
    49.613   531.721     0.150
    49.652   536.221     0.150
    50.534   529.721     0.150
    50.534    15.000     0.150
    51.084   547.721     0.150
    51.250    14.199     0.150
    51.250   543.721     0.150
    51.250    14.199     0.150
    51.250   993.721     0.150
    51.452   553.721     0.150
    51.485   544.721     0.150
    51.665   551.521     0.150
    51.904   548.420     0.150
    51.904   668.621     0.150
    51.964   552.621     0.150
    52.029   554.221     0.150
    52.454   556.621     0.150
    52.714   551.521     0.150
    52.714   592.420     0.150
    52.678   559.021     0.150
    52.923   581.721     0.150
    52.923   609.721     0.150
    53.421   549.721     0.150
    53.780   761.221     0.150
    53.792   730.721     0.150
    53.792   562.521     0.150
    53.927   562.420     0.150
    53.927   562.420     0.150
    53.927     7.500     0.150
    54.115   554.021     0.150
    54.115   761.221     0.150
    54.117   564.320     0.150
    54.117     5.600     0.150
    54.480   585.721     0.150
    54.480   601.721     0.150
    55.020   571.521     0.150
    55.020     7.199     0.150
    55.020   629.420     0.150
    55.020   719.920     0.150
    55.020  1263.721     0.150
    55.020   571.521     0.150
    55.020     7.199     0.150
    55.020   629.420     0.150
    55.164     1.400     0.150
    55.164    13.900     0.150
    55.164   572.320     0.150
    55.164    13.900     0.150
    55.878   585.121     0.150
    56.196   589.721     0.150
    56.196   590.221     0.150
    56.718     0.500     0.150
    56.718   609.420     0.150
    56.718   584.021     0.150
    56.718   646.320     0.150
    56.928   623.420     0.150
    57.470   588.721     0.150
    57.470     6.000     0.150
    58.176   585.721     0.150
    58.540   652.420     0.150
    59.055   597.820     0.150
    61.143   602.721     0.150
    70.835   680.721     0.150
    79.665   726.621     0.150
    80.170   729.521     0.150
    80.170     5.398     0.150
    82.058   732.721     0.150
    84.537   759.721     0.150
    86.686    13.400     0.150
    87.117   770.721     0.150
    89.958   798.721     0.150
     0.358     7.965     0.150
     0.358     7.965     0.150
     0.826    14.965     0.150
     0.826    14.965     0.150
     1.750    28.664     0.150
     1.750    51.664     0.150
     2.095    37.164     0.150
     2.095    65.062     0.150
     2.787    83.863     0.150
     2.787    47.965     0.150
     2.787    83.863     0.150
     2.728    43.664     0.150
     2.728    49.062     0.150
     2.728    76.363     0.150
     2.728    85.664     0.150
     2.752    44.164     0.150
     2.752    48.965     0.150
     2.752    76.965     0.150
     2.752    84.164     0.150
     3.227    52.664     0.150
     3.227    57.664     0.150
     3.227    89.965     0.150
     3.227   100.664     0.150
     3.876    69.664     0.150
     3.876   104.965     0.150
     3.876   120.363     0.150
     4.184    60.266     0.150
     4.184   105.465     0.150
     4.184   126.266     0.150
     4.184    60.266     0.150
     4.184    72.465     0.150
     4.184   105.465     0.150
     4.184   126.266     0.150
     1.163    19.684     0.150
     1.163    19.684     0.150
     1.163    22.684     0.150
     1.163    36.285     0.150
     1.163    36.285     0.150
     1.281    22.285     0.150
     1.281    39.586     0.150
     1.605    50.086     0.150
     2.391    38.484     0.150
     2.391    41.184     0.150
     2.391    67.484     0.150
     2.391    72.684     0.150
     2.507    42.883     0.150
     2.507    71.484     0.150
     2.507    76.684     0.150
     2.504    43.785     0.150
     2.504    70.984     0.150
     2.504    77.285     0.150
     3.097    48.785     0.150
     3.097    54.684     0.150
     3.097    96.086     0.150
     3.142    50.984     0.150
     3.142    50.984     0.150
     3.142    55.984     0.150
     3.142    86.086     0.150
     3.142    95.086     0.150
     3.662    58.484     0.150
     3.662    64.285     0.150
     3.662   101.484     0.150
     3.662   111.086     0.150
     3.744    59.684     0.150
     3.744    55.383     0.150
     3.744    59.684     0.150
     3.744    65.484     0.150
     3.744    98.285     0.150
     3.744   113.184     0.150
     3.918    59.785     0.150
     3.918    69.086     0.150
     3.918   121.684     0.150
     4.201    76.484     0.150
     4.201   129.984     0.150
     4.570    69.785     0.150
     4.570    80.785     0.150
     4.570   123.285     0.150
     4.570   139.984     0.150
     4.702    70.484     0.150
     4.702   141.984     0.150
     4.702    70.484     0.150
     4.702    83.484     0.150
     4.702   120.785     0.150
     4.702   141.984     0.150
     0.997    17.820     0.150
     0.997    17.820     0.150
     2.557    48.922     0.150
     2.976    58.121     0.150
     3.254    62.723     0.150
     3.846    54.121     0.150
     3.846    97.020     0.150
     0.914    16.949     0.150
     0.914    16.949     0.150
     1.506    26.750     0.150
     1.506    26.750     0.150
     1.506    26.750     0.150
     1.506    31.750     0.150
     2.641    51.449     0.150
     2.641    79.750     0.150
     2.894    47.047     0.150
     3.338    80.449     0.150
     3.421    56.348     0.150
     3.421    96.148     0.150
     3.881    56.148     0.150
     4.166    66.547     0.150
     4.332    72.648     0.150
     0.956    17.559     0.150
     0.956    17.559     0.150
     0.956    28.660     0.150
     1.477    26.258     0.150
     1.477    32.359     0.150
     2.934    58.660     0.150
     3.292    57.961     0.150
     4.126    64.961     0.150
     4.442    78.059     0.150
     4.442   136.961     0.150
     0.314     6.391     0.150
     0.314     6.391     0.150
     0.916    16.590     0.150
     0.916    16.590     0.150
     3.419   112.988     0.150
     4.329   123.590     0.150
     4.329   135.691     0.150
     4.738   131.191     0.150
     0.136     4.176     0.150
     1.407    25.977     0.150
     1.407    25.977     0.150
     1.407    42.777     0.150
     1.530    27.277     0.150
     1.530    27.277     0.150
     1.530    27.277     0.150
     1.530    28.777     0.150
     1.530    34.477     0.150
     2.266    37.676     0.150
     2.266    40.777     0.150
     2.266    70.977     0.150
     2.266    40.777     0.150
     2.266    70.977     0.150
     2.299    41.176     0.150
     2.299    38.176     0.150
     2.299    38.176     0.150
     2.299    47.477     0.150
     2.299    74.176     0.150
     2.299    41.176     0.150
     2.299    73.078     0.150
     2.476    43.977     0.150
     2.476    40.777     0.150
     2.476    40.777     0.150
     2.487    51.977     0.150
     2.487    59.977     0.150
     2.487    78.977     0.150
     2.487    41.977     0.150
     2.487    78.375     0.150
     2.658    42.078     0.150
     2.658    42.078     0.150
     2.658    52.977     0.150
     2.658    76.875     0.150
     2.658    46.676     0.150
     2.658    81.977     0.150
     2.911    46.375     0.150
     2.911    46.375     0.150
     2.911    53.977     0.150
     2.911    93.078     0.150
     3.391    63.977     0.150
     3.391    67.977     0.150
     3.391   107.477     0.150
     3.670    56.477     0.150
     3.670    66.977     0.150
     3.670   112.977     0.150
     4.264    65.078     0.150
     4.264    65.078     0.150
     4.264    69.977     0.150
     4.264    72.977     0.150
     4.264    79.277     0.150
     4.264    81.578     0.150
     4.264   107.977     0.150
     4.264   134.977     0.150
     4.450    71.875     0.150
     4.450    75.578     0.150
     4.450    83.676     0.150
     4.848    82.375     0.150
     4.848    90.477     0.150
     4.848   107.477     0.150
     4.848   150.578     0.150
     4.877   151.176     0.150
     4.877    79.977     0.150
     4.877    84.477     0.150
     4.877    89.277     0.150
     4.877    99.176     0.150
     4.877   151.176     0.150
     4.877   192.977     0.150
     4.877    72.375     0.150
     4.877   151.176     0.150
     5.186   162.977     0.150
     5.186    78.375     0.150
     5.186    78.375     0.150
     5.186    86.977     0.150
     5.186    93.578     0.150
     5.186   125.277     0.150
     5.186   163.375     0.150
     5.186    78.477     0.150
     5.186    93.676     0.150
     5.186   162.977     0.150
     5.766   104.375     0.150
     5.766   108.578     0.150
     5.766   110.977     0.150
     5.766   178.078     0.150
     5.841    90.977     0.150
     5.841    94.977     0.150
     5.841   105.977     0.150
     5.841   107.277     0.150
     5.841   111.977     0.150
     5.841   167.176     0.150
     5.841   182.875     0.150
     5.841   105.875     0.150
     5.841   180.777     0.150
     5.975    98.777     0.150
     5.975   108.277     0.150
     5.975   166.078     0.150
     5.975   183.777     0.150
     6.196    92.078     0.150
     6.196    92.078     0.150
     6.196   111.977     0.150
     6.196   183.977     0.150
     6.196   194.277     0.150
     6.309    91.676     0.150
     6.309   163.176     0.150
     6.309   196.977     0.150
     7.463   137.078     0.150
    13.491   189.977     0.150
    14.140   435.977     0.150
    14.140   198.977     0.150
    14.136   198.477     0.150
    14.261   211.977     0.150
    15.614   225.977     0.150
    15.661   393.977     0.150
    15.661   224.977     0.150
    15.661   393.977     0.150
    15.725   398.977     0.150
    17.544   244.477     0.150
    17.544   244.477     0.150
    17.544   244.477     0.150
    17.955   249.977     0.150
    21.848   289.977     0.150
    23.003   308.676     0.150
    23.805   318.977     0.150
    23.805   318.977     0.150
    23.805   976.977     0.150
    25.614   330.477     0.150
    27.859   359.277     0.150
    38.988   444.676     0.150
    43.819   486.578     0.150
    43.819     9.797     0.150
    43.830   485.977     0.150
    45.140   495.277     0.150
    46.003   501.875     0.150
    47.815   517.176     0.150
    48.202   519.277     0.150
    54.475   577.176     0.150
    54.475   577.176     0.150
     0.355     7.064     0.150
     0.355     7.064     0.150
     2.696    73.264     0.150
     3.519   100.464     0.150
     7.317   228.264     0.150
     0.236     4.913     0.150
     0.236     8.913     0.150
     0.569    11.213     0.150
     0.569    18.213     0.150
     1.043    18.513     0.150
     1.043    33.413     0.150
     1.331    24.213     0.150
     1.331    24.213     0.150
     1.331    43.513     0.150
     1.331    24.213     0.150
     1.331    42.713     0.150
     1.501    26.612     0.150
     1.501    26.612     0.150
     1.501    26.612     0.150
     1.630    28.513     0.150
     1.630    28.513     0.150
     1.630    50.513     0.150
     2.282    40.513     0.150
     2.282    40.513     0.150
     2.282    42.812     0.150
     2.570    43.612     0.150
     2.570    46.812     0.150
     2.570    74.612     0.150
     2.570    79.812     0.150
     2.570    44.513     0.150
     2.570    82.013     0.150
     2.701    82.513     0.150
     2.701    74.413     0.150
     2.701    82.513     0.150
     2.701    49.913     0.150
     3.071    49.112     0.150
     3.071    54.013     0.150
     3.071    83.513     0.150
     3.071    94.812     0.150
     3.071    48.713     0.150
     3.071    94.812     0.150
     3.309    89.013     0.150
     3.309    52.513     0.150
     3.309    58.812     0.150
     3.309    89.013     0.150
     3.309   100.612     0.150
     3.309    51.913     0.150
     3.309    60.513     0.150
     3.309   105.413     0.150
     3.413    59.013     0.150
     3.413    93.413     0.150
     3.413   103.413     0.150
     3.874    61.513     0.150
     3.874    70.812     0.150
     3.874   103.013     0.150
     3.874   121.013     0.150
     3.874    70.513     0.150
     3.874   120.513     0.150
     4.298    66.513     0.150
     4.298    78.013     0.150
     4.298   113.612     0.150
     4.298   133.413     0.150
     4.393    65.812     0.150
     4.393    79.513     0.150
     4.393   116.413     0.150
     4.393   135.612     0.150
     4.791    74.312     0.150
     4.791    86.713     0.150
     4.791   146.713     0.150
     4.791    75.213     0.150
     5.229    95.612     0.150
     5.229   163.513     0.150
     5.229    79.612     0.150
     5.229    95.612     0.150
     5.229   138.312     0.150
     5.229   163.513     0.150
     5.229    80.513     0.150
     5.229    95.713     0.150
     5.543    84.612     0.150
     5.543   100.812     0.150
     0.146     6.506     0.150
     0.649    13.006     0.150
     0.649    13.006     0.150
     0.966    17.705     0.150
     0.966    30.406     0.150
     1.407    25.705     0.150
     1.407    45.205     0.150
     1.407    25.705     0.150
     1.407    45.205     0.150
     1.407    25.605     0.150
     1.407    45.205     0.150
     1.916    32.605     0.150
     1.916    34.605     0.150
     1.916    60.705     0.150
     2.230    36.705     0.150
     2.230    39.307     0.150
     2.230    69.006     0.150
     2.562    45.506     0.150
     2.562    78.705     0.150
     2.778    50.506     0.150
     2.778    85.705     0.150
     3.038    54.205     0.150
     3.038    93.807     0.150
     3.038    93.807     0.150
     3.038    47.506     0.150
     3.038    53.506     0.150
     3.038    93.807     0.150
     3.038    54.205     0.150
     3.038    93.807     0.150
     3.326    58.006     0.150
     3.326   101.705     0.150
     3.381    60.105     0.150
     3.381   104.506     0.150
     3.717    66.307     0.150
     3.717   115.307     0.150
     3.717    56.506     0.150
     3.717    66.307     0.150
     3.717   115.307     0.150
     3.717    66.307     0.150
     3.717   100.506     0.150
     3.717   115.307     0.150
     3.953    70.506     0.150
     3.953   122.506     0.150
     3.953    70.506     0.150
     3.953   122.506     0.150
     3.953    70.506     0.150
     3.953   122.506     0.150
     3.953    70.506     0.150
     3.953   122.506     0.150
     4.330    78.705     0.150
     4.330   113.307     0.150
     4.330   134.006     0.150
     0.331     6.922     0.150
     0.331     6.922     0.150
     1.021    19.125     0.150
     1.021    19.125     0.150
     1.021    19.125     0.150
     1.021    32.320     0.150
     1.021    19.125     0.150
     1.021    32.320     0.150
     1.383    25.125     0.150
     1.383    25.125     0.150
     1.770    34.227     0.150
     1.770    58.922     0.150
     2.377    43.523     0.150
     2.377    72.523     0.150
     2.537    42.727     0.150
     2.537    80.023     0.150
     2.665    46.023     0.150
     2.665    81.523     0.150
     3.004    51.727     0.150
     3.004    51.023     0.150
     3.004    55.727     0.150
     3.004    51.727     0.150
     3.004    92.922     0.150
     3.256   102.320     0.150
     3.765    58.727     0.150
     3.765   119.523     0.150
     4.058   123.523     0.150
     4.047    65.727     0.150
     4.391   135.727     0.150
     7.299   227.523     0.150
     0.260     6.473     0.150
     1.282    23.676     0.150
     1.434    26.273     0.150
     1.434    26.273     0.150
     1.434    30.574     0.150
     1.818    31.773     0.150
     2.166    40.176     0.150
     2.166    69.574     0.150
     2.345    38.176     0.150
     2.345    38.176     0.150
     2.345    38.176     0.150
     2.345    46.375     0.150
     2.532    41.176     0.150
     3.138    59.375     0.150
     3.138    97.973     0.150
     3.138   105.875     0.150
     3.257    51.273     0.150
     3.837    58.574     0.150
     3.837    75.074     0.150
     3.829    64.375     0.150
     3.829    71.074     0.150
     3.829    77.074     0.150
     4.237    69.273     0.150
     4.237    78.375     0.150
     4.237   133.473     0.150
     4.360    64.875     0.150
     4.360    69.176     0.150
     4.360    81.176     0.150
     4.360   135.074     0.150
     4.747   148.676     0.150
     5.197    86.375     0.150
     5.443   168.785     0.150
     6.992   174.375     0.150
     6.992   204.074     0.150
     8.198   119.738     0.150
    14.272   205.785     0.150
    14.272   452.797     0.150
    59.769   603.770     0.150
     0.934    32.880     0.150
     0.951    17.680     0.150
     0.951    17.680     0.150
     3.168    64.880     0.150
     3.731    59.880     0.150
     0.206     7.406     0.150
     0.767    14.805     0.150
     0.767    14.805     0.150
     0.767    30.508     0.150
     1.045    20.906     0.150
     1.045    25.609     0.150
     1.045    37.305     0.150
     1.045    19.406     0.150
     1.045    20.906     0.150
     1.045    25.609     0.150
     1.045    33.406     0.150
     1.045    37.305     0.150
     1.033    19.406     0.150
     1.033    19.406     0.150
     1.033    37.805     0.150
     1.034    37.805     0.150
     1.358    44.805     0.150
     1.358    25.711     0.150
     1.358    25.711     0.150
     1.358    44.406     0.150
     1.614    30.305     0.150
     1.614    51.906     0.150
     1.766    56.508     0.150
     1.766    32.406     0.150
     1.766    56.508     0.150
     2.167    39.906     0.150
     2.167    37.508     0.150
     2.167    39.906     0.150
     2.167    69.109     0.150
     2.360    39.906     0.150
     2.360    42.109     0.150
     2.360    74.008     0.150
     2.573    43.008     0.150
     2.573    46.906     0.150
     2.573    74.609     0.150
     2.573    80.211     0.150
     2.737    45.711     0.150
     2.737    49.109     0.150
     2.737    78.008     0.150
     2.737    85.109     0.150
     2.726    51.109     0.150
     2.726    51.109     0.150
     2.726    86.305     0.150
     3.193    57.109     0.150
     3.193    51.609     0.150
     3.193    57.109     0.150
     3.193    99.406     0.150
     3.262    57.805     0.150
     3.262    61.711     0.150
     3.262    51.711     0.150
     3.262    57.805     0.150
     3.262    59.508     0.150
     3.262    61.711     0.150
     3.262    90.906     0.150
     3.262   101.211     0.150
     3.310    59.711     0.150
     3.310   103.711     0.150
     3.310    53.008     0.150
     3.310    59.711     0.150
     3.310   103.711     0.150
     3.557    64.305     0.150
     3.557   111.406     0.150
     3.827    70.406     0.150
     3.827    60.305     0.150
     3.827    68.406     0.150
     3.827    70.406     0.150
     3.827   103.406     0.150
     3.827   118.406     0.150
     3.908    62.711     0.150
     3.908    71.211     0.150
     3.908   122.109     0.150
     4.181    78.305     0.150
     4.181    64.508     0.150
     4.181    76.406     0.150
     4.181    78.305     0.150
     4.181   111.609     0.150
     4.181   129.109     0.150
     4.248    79.406     0.150
     4.248   133.805     0.150
     4.248    77.008     0.150
     4.248    79.406     0.150
     4.248   133.805     0.150
     5.310    82.406     0.150
     5.310    96.109     0.150
     5.310   140.609     0.150
     5.310   164.609     0.150
     5.362    99.906     0.150
     5.362   105.508     0.150
     5.362    81.008     0.150
     5.362    97.211     0.150
     5.362    99.906     0.150
     5.362   105.508     0.150
     5.362   166.805     0.150
     6.773   122.508     0.150
     6.773   210.406     0.150
     6.773   210.305     0.150
     6.909   212.406     0.150
     6.909   212.906     0.150
     0.352     6.417     0.150
     0.352     6.417     0.150
     0.471     9.217     0.150
     0.471     9.217     0.150
     0.984    35.817     0.150
     1.437    25.917     0.150
     1.437    25.917     0.150
     1.437    25.917     0.150
     2.717    44.917     0.150
     2.717    44.917     0.150
     2.793    74.817     0.150
     3.495    63.117     0.150
     5.256    81.917     0.150
     5.256    81.917     0.150
     6.898   215.018     0.150
     0.296     9.363     0.150
     1.123    35.762     0.150
     1.123    20.762     0.150
     1.123    35.660     0.150
     1.250    22.961     0.150
     1.250    34.461     0.150
     1.250    22.961     0.150
     1.250    34.461     0.150
     1.250    39.863     0.150
     1.575    56.762     0.150
     1.575    29.062     0.150
     1.575    50.363     0.150
     1.575    56.762     0.150
     1.804    32.262     0.150
     1.804    56.660     0.150
     2.142    38.562     0.150
     2.142    67.660     0.150
     2.368    39.262     0.150
     2.368    39.262     0.150
     2.368    43.062     0.150
     2.368    74.062     0.150
     2.503    41.160     0.150
     2.503    72.461     0.150
     2.503    41.160     0.150
     2.503    72.461     0.150
     2.503    78.062     0.150
     2.620    80.961     0.150
     2.644    42.762     0.150
     2.644    45.461     0.150
     2.644    42.762     0.150
     2.644    45.461     0.150
     2.644    78.961     0.150
     3.155    50.461     0.150
     3.155    56.562     0.150
     3.155    98.062     0.150
     3.225    99.961     0.150
     3.225    58.160     0.150
     3.225    99.961     0.150
     3.454    54.160     0.150
     3.454    61.762     0.150
     3.454   106.461     0.150
     3.864    57.762     0.150
     3.864    57.762     0.150
     3.864    68.461     0.150
     3.864   105.562     0.150
     3.864   119.762     0.150
     4.212    75.863     0.150
     4.212   132.363     0.150
     4.384   116.762     0.150
     4.384   134.762     0.150
     4.384    66.262     0.150
     4.384    78.363     0.150
     4.384   116.762     0.150
     4.384   134.762     0.150
     5.161    94.562     0.150
     5.161   160.160     0.150
     5.161    79.961     0.150
     5.161    79.961     0.150
     5.161   136.961     0.150
     5.161   160.363     0.150
     5.392    96.363     0.150
     5.392   167.660     0.150
     5.399    97.461     0.150
     5.399   166.762     0.150
     5.627   143.262     0.150
     5.627    83.660     0.150
     5.627   100.461     0.150
     5.627   143.262     0.150
     5.627   173.062     0.150
     6.817   209.961     0.150
     6.817   210.363     0.150
     7.027   216.961     0.150
     7.027   105.660     0.150
     7.027   126.863     0.150
     7.027   105.660     0.150
     7.027   126.863     0.150
     7.027   217.160     0.150
     0.669    13.159     0.150
     0.669    13.159     0.150
     0.906    21.958     0.150
     0.906    32.159     0.150
     1.247    22.458     0.150
     1.247    22.458     0.150
     5.367    84.059     0.150
     5.367    88.458     0.150
     0.548    11.352     0.150
     0.548    16.148     0.150
     1.060    21.250     0.150
     1.060    33.250     0.150
     1.162    23.250     0.150
     1.162    29.148     0.150
     1.314    42.551     0.150
     1.314    24.148     0.150
     1.314    24.148     0.150
     1.650    54.949     0.150
     1.882    57.051     0.150
     2.292    38.148     0.150
     2.292    38.148     0.150
     2.292    40.648     0.150
     2.569    78.551     0.150
     2.574    42.449     0.150
     2.574    44.352     0.150
     2.574    52.551     0.150
     2.683    83.250     0.150
     3.077    54.449     0.150
     3.077    95.352     0.150
     3.293    55.422     0.150
     3.436    53.352     0.150
     3.436    53.352     0.150
     3.436    53.352     0.150
     3.436    56.852     0.150
     3.436    60.949     0.150
     3.436   108.949     0.150
     4.287    76.852     0.150
     4.287   132.852     0.150
     4.411    65.750     0.150
     4.411    65.750     0.150
     4.411    65.750     0.150
     4.411    81.852     0.150
     4.773    84.352     0.150
     4.773   131.750     0.150
     5.209   161.250     0.150
     5.512   101.520     0.150
     5.512   174.531     0.150
     5.549   171.949     0.150
     5.549    81.949     0.150
     6.744   210.051     0.150
     6.744   108.051     0.150
     6.744   120.551     0.150
     6.744   123.051     0.150
     6.970   125.551     0.150
     6.970   215.949     0.150
     6.970   101.852     0.150
     6.970   109.852     0.150
     6.970   124.949     0.150
    10.133   161.852     0.150
    10.133   268.750     0.150
    13.963   430.219     0.150
    13.963   197.625     0.150
    13.963   354.398     0.150
    13.963   430.227     0.150
    14.332   444.547     0.150
    14.316   205.750     0.150
    15.076     5.500     0.150
    16.575   241.750     0.150
    20.488   289.352     0.150
    20.488   301.750     0.150
    22.565   299.250     0.150
    22.565   539.750     0.150
    22.624   306.148     0.150
    22.624   536.852     0.150
    53.999   560.750     0.150
     0.571    12.519     0.150
     0.571    12.519     0.150
     0.571    12.519     0.150
     0.571    21.119     0.150
     0.982    17.619     0.150
     0.982    17.619     0.150
     1.236    22.919     0.150
     1.236    22.919     0.150
     1.664    28.818     0.150
     1.664    53.519     0.150
     1.704    54.919     0.150
     1.960    58.619     0.150
     2.302    70.719     0.150
     2.302    73.619     0.150
     2.500    39.419     0.150
     3.375    50.619     0.150
     6.895   210.419     0.150
     0.872    16.426     0.150
     0.872    16.426     0.150
     1.557    28.816     0.150
     1.557    50.117     0.150
     1.624    51.914     0.150
     1.676    54.117     0.150
     1.835    35.914     0.150
     0.698    13.564     0.150
     0.698    13.564     0.150
     0.698    13.465     0.150
     0.923    16.365     0.150
     0.923    16.365     0.150
     0.923    30.965     0.150
     0.923    16.365     0.150
     0.923    30.665     0.150
     1.135    21.064     0.150
     1.135    37.765     0.150
     1.203    22.064     0.150
     1.203    38.564     0.150
     1.452    26.064     0.150
     1.452    46.064     0.150
     1.662    30.165     0.150
     1.662    51.865     0.150
     1.706    32.365     0.150
     1.706    54.165     0.150
     2.203    35.564     0.150
     2.203    35.564     0.150
     2.203    35.465     0.150
     2.313    41.564     0.150
     2.313    72.365     0.150
     2.561    40.865     0.150
     2.561    44.765     0.150
     2.561    77.765     0.150
     2.823    52.665     0.150
     2.823    88.965     0.150
     3.022    85.965     0.150
     3.022    47.165     0.150
     3.022    52.765     0.150
     3.022    91.865     0.150
     3.274    49.564     0.150
     3.274    56.965     0.150
     3.274    99.564     0.150
     3.423    60.765     0.150
     3.423   105.765     0.150
     3.683    56.865     0.150
     3.683    64.564     0.150
     3.683   112.765     0.150
     3.999    74.465     0.150
     3.999    70.965     0.150
     3.999   123.265     0.150
     4.292    63.265     0.150
     4.292    76.465     0.150
     4.292   132.465     0.150
     4.918   151.465     0.150
     4.918    75.265     0.150
     4.918    86.965     0.150
     4.918   131.265     0.150
     4.918   151.465     0.150
     5.215    94.365     0.150
     5.215   161.765     0.150
     5.215    77.665     0.150
     5.215    94.365     0.150
     5.215   161.765     0.150
     5.366    89.965     0.150
     5.366   165.564     0.150
     5.366    80.865     0.150
     5.366    89.965     0.150
     5.366   165.564     0.150
     6.821   101.365     0.150
     6.821   122.165     0.150
     6.821   210.965     0.150
     6.821   210.965     0.150
     6.821   101.365     0.150
     6.821   122.165     0.150
     6.821   210.965     0.150
     2.753    42.322     0.150
     1.700    48.855     0.150
     2.262    72.258     0.150
     0.598    11.867     0.150
     0.598    11.867     0.150
     0.598    11.867     0.150
     1.020    31.066     0.150
     1.020    17.867     0.150
     1.020    17.867     0.150
     1.020    17.867     0.150
     1.020    35.168     0.150
     1.353    25.668     0.150
     1.640    53.270     0.150
     1.640    53.168     0.150
     2.269    68.066     0.150
     2.269    37.566     0.150
     2.573    41.066     0.150
     2.573    79.168     0.150
     2.606    42.367     0.150
     2.606    42.367     0.150
     3.065    48.770     0.150
     3.384    52.066     0.150
     3.384    52.066     0.150
     3.384    61.566     0.150
     3.762    70.168     0.150
     4.313   134.668     0.150
     4.368    65.066     0.150
     4.815   133.867     0.150
     5.256    96.469     0.150
     5.256   163.066     0.150
     5.291    82.367     0.150
     6.714   120.867     0.150
     6.926   102.270     0.150
     6.926   123.668     0.150
     6.926   212.168     0.150
     0.259     6.343     0.150
     1.025    31.843     0.150
     1.025    18.143     0.150
     1.407    24.443     0.150
     1.463    29.743     0.150
     1.463    48.543     0.150
     1.821    35.243     0.150
     2.313    73.843     0.150
     2.529    44.743     0.150
     3.822    56.843     0.150
     3.822    56.843     0.150
     4.065   127.043     0.150
     4.837   149.943     0.150
     5.567   113.043     0.150
     5.567   172.443     0.150
     5.701   149.643     0.150
     5.701   174.243     0.150
     7.081   127.643     0.150
     7.081   194.743     0.150
     7.081   219.343     0.150
     7.323   226.843     0.150
     0.929    16.629     0.150
     0.929    16.629     0.150
     1.379    25.429     0.150
     1.379    25.429     0.150
     1.379    30.329     0.150
     3.434    56.829     0.150
     3.434   109.329     0.150
     4.482    89.429     0.150
     6.844   183.829     0.150
     0.245     5.031     0.150
     0.245     5.031     0.150
     1.308    41.531     0.150
     1.308    23.734     0.150
     1.308    23.734     0.150
     1.642    28.133     0.150
     1.642    51.031     0.150
     2.175    35.734     0.150
     2.175    35.734     0.150
     2.327    38.438     0.150
     2.327    41.234     0.150
     2.715    82.938     0.150
     3.399    52.734     0.150
     3.399    61.031     0.150
     4.136    62.531     0.150
     5.643   101.938     0.150
     5.643   173.336     0.150
     5.643   173.031     0.150
     6.096   186.633     0.150
     6.096    93.031     0.150
     0.347     6.707     0.150
     0.347     6.707     0.150
     1.710    29.109     0.150
     2.034    33.609     0.150
     2.034    33.609     0.150
     2.195    40.008     0.150
     2.308    40.410     0.150
     2.612    46.207     0.150
     3.269    50.809     0.150
     3.269    50.809     0.150
     4.942    73.309     0.150
     5.499   167.910     0.150
     5.499   168.410     0.150
     5.930   106.707     0.150
     5.930   182.809     0.150
     5.930    88.609     0.150
     6.242   191.207     0.150
     6.242    93.609     0.150
     6.242   110.707     0.150
     1.440    25.621     0.150
     1.440    25.621     0.150
     1.440    44.320     0.150
     1.954    41.020     0.150
     1.954    67.020     0.150
     1.990    62.320     0.150
     2.340    64.922     0.150
     2.340    72.520     0.150
     2.443    48.820     0.150
     2.643    47.922     0.150
     2.773    58.422     0.150
     4.408   137.621     0.150
     4.408   136.621     0.150
     4.888    89.621     0.150
     5.229   100.020     0.150
     5.229   161.422     0.150
     5.798   110.020     0.150
     5.798   180.422     0.150
     5.798   180.121     0.150
     5.935    93.121     0.150
     5.935   181.320     0.150
     5.935   181.723     0.150
     6.233   112.320     0.150
     6.233   163.520     0.150
     6.233   193.320     0.150
     6.233   111.922     0.150
     6.233   192.723     0.150
    23.763   307.320     0.150
     0.328    12.703     0.150
     0.456    19.604     0.150
     0.620    21.404     0.150
     0.620    12.404     0.150
     0.620    14.104     0.150
     0.620    19.703     0.150
     0.620    21.404     0.150
     0.620    22.703     0.150
     0.761    31.004     0.150
     0.895    19.504     0.150
     0.895    32.703     0.150
     1.303    39.703     0.150
     1.303    28.305     0.150
     1.607    51.004     0.150
     2.569    42.104     0.150
     3.043    48.604     0.150
     3.043    56.703     0.150
     3.526   115.404     0.150
     3.629    68.703     0.150
     4.014    77.104     0.150
     4.014   114.703     0.150
     4.340    80.004     0.150
     5.027    93.004     0.150
     5.027   137.604     0.150
     7.188   130.104     0.150
     7.188   222.504     0.150
     1.059    21.969     0.150
     2.348    39.164     0.150
     2.496    75.062     0.150
     0.540    10.812     0.150
     0.914    16.609     0.150
     0.914    16.609     0.150
     0.914    32.914     0.150
     0.914    16.609     0.150
     1.265    30.516     0.150
     1.499    28.414     0.150
     1.499    26.914     0.150
     1.499    49.016     0.150
     1.852    39.109     0.150
     1.852    59.711     0.150
     1.852    35.312     0.150
     1.852    59.516     0.150
     2.073    35.109     0.150
     2.073    35.109     0.150
     2.073    35.109     0.150
     2.840    46.016     0.150
     2.840    88.109     0.150
     2.775    45.211     0.150
     2.775    45.211     0.150
     2.775    57.516     0.150
     2.775    51.414     0.150
     2.775    85.914     0.150
     2.858    50.609     0.150
     2.858    88.312     0.150
     3.431    53.016     0.150
     3.483    64.914     0.150
     3.483    54.711     0.150
     4.536    67.812     0.150
     4.504    77.016     0.150
     4.504    83.711     0.150
     4.504   141.812     0.150
     4.931   161.812     0.150
     5.106    95.812     0.150
     5.106   159.609     0.150
     5.327    87.312     0.150
     5.327   164.109     0.150
     5.855   106.523     0.150
     6.539   121.609     0.150
     6.828   122.516     0.150
     6.828   122.414     0.150
     6.828   210.812     0.150
     7.565   120.812     0.150
     7.565   136.016     0.150
     8.232   116.531     0.150
    12.973   191.109     0.150
    14.493   204.281     0.150
    15.315     7.297     0.150
    15.315    10.500     0.150
    15.315   393.109     0.150
    16.406   226.312     0.150
    16.406     1.203     0.150
    17.743    15.297     0.150
    18.017   249.234     0.150
    22.608   549.305     0.150
    22.660   298.555     0.150
    22.864    30.000     0.150
    23.430   306.734     0.150
    24.235     3.000     0.150
    28.286   357.016     0.150
    28.286   406.609     0.150
    28.286   350.305     0.150
    42.142   471.586     0.150
    48.389   521.312     0.150
    48.389   521.234     0.150
    59.463   601.312     0.150
    76.503   709.711     0.150
     0.751    13.699     0.150
     0.751    13.699     0.150
     0.751    16.699     0.150
     0.752    14.599     0.150
     0.752    14.599     0.150
     0.752    14.599     0.150
     0.798    30.399     0.150
     1.624    32.899     0.150
     1.624    29.199     0.150
     1.624    51.500     0.150
     1.900    64.299     0.150
     2.392    40.500     0.150
     2.392    40.500     0.150
     2.392    40.500     0.150
     2.392    43.099     0.150
     2.831    88.099     0.150
     2.879    46.500     0.150
     2.993    61.899     0.150
     2.993    48.000     0.150
     2.993    92.799     0.150
     3.196   112.000     0.150
     3.196    57.599     0.150
     3.213    50.500     0.150
     3.213    89.099     0.150
     3.602    56.199     0.150
     4.166    78.199     0.150
     4.345    65.599     0.150
     4.581    70.500     0.150
     5.023    92.899     0.150
     5.023   158.199     0.150
     5.023    75.699     0.150
     5.023    93.000     0.150
     5.082    95.699     0.150
     5.082   167.799     0.150
     5.805   105.520     0.150
     5.805    87.299     0.150
     5.805   105.500     0.150
     5.805   184.899     0.150
     6.443   117.699     0.150
     6.443   117.500     0.150
     6.443   198.699     0.150
     6.663   102.799     0.150
     6.663   120.500     0.150
     6.663    98.000     0.150
     6.663   205.099     0.150
     7.293   133.799     0.150
     7.293   200.599     0.150
     8.015   255.599     0.150
     8.015   114.270     0.150
     8.015   255.609     0.150
    12.722   185.199     0.150
    12.722     4.800     0.150
    12.722   193.599     0.150
    12.722   331.500     0.150
    12.722   341.099     0.150
    12.854   332.099     0.150
    14.033   357.699     0.150
    14.321   202.409     0.150
    15.310   219.699     0.150
    15.310     7.700     0.150
    15.310    10.500     0.150
    16.884     7.500     0.150
    16.884    12.500     0.150
    17.685   438.899     0.150
    17.685   461.699     0.150
    18.185   563.882     0.150
    20.286   272.299     0.150
    20.286   497.000     0.150
    22.799   556.199     0.150
    22.871   541.299     0.150
    22.871   302.449     0.150
    22.871   541.329     0.150
    23.642   569.799     0.150
    23.642   310.209     0.150
    23.642   569.839     0.150
    24.056     5.100     0.150
    24.056     7.700     0.150
    30.942   379.299     0.150
    39.235   447.500     0.150
    39.235   576.199     0.150
    40.478  1008.399     0.150
    41.941   470.000     0.150
    48.592   523.219     0.150
    49.251   531.559     0.150
    50.567   539.329     0.150
    51.061   541.524     0.150
    51.061   541.520     0.150
    51.437   541.799     0.150
    53.275   563.399     0.150
    54.146   565.299     0.150
    56.085   580.399     0.150
    56.085     4.000     0.150
    56.085   580.399     0.150
    56.085     4.000     0.150
    59.488   602.040     0.150
    60.688   612.799     0.150
    60.688   612.799     0.150
    61.689   618.899     0.150
    61.689   618.899     0.150
    61.689   618.899     0.150
    61.947   618.799     0.150
    61.947   618.799     0.150
    66.060   646.599     0.150
    66.060   646.599     0.150
    69.989   670.159     0.150
    72.544   687.619     0.150
    76.323   710.349     0.150
    76.329   712.199     0.150
   147.510  1194.299     0.150
   147.510  1212.399     0.150
   148.253  1212.599     0.150
     0.171     3.777     0.150
     0.171     6.676     0.150
     0.739    14.277     0.150
     0.739    14.277     0.150
     0.739    29.477     0.150
     0.739    14.277     0.150
     0.761    13.676     0.150
     0.761    23.578     0.150
     0.795    14.676     0.150
     0.795    25.578     0.150
     1.392    25.375     0.150
     1.392    43.676     0.150
     1.392    46.078     0.150
     1.614    51.375     0.150
     1.614    29.078     0.150
     1.614    50.977     0.150
     1.852    34.375     0.150
     1.852    58.875     0.150
     1.895    60.578     0.150
     1.895    60.676     0.150
     1.895    60.578     0.150
     2.013    34.477     0.150
     2.013    36.176     0.150
     2.013    62.277     0.150
     2.389    42.277     0.150
     2.389    40.375     0.150
     2.389    42.375     0.150
     2.389    72.578     0.150
     2.500    45.777     0.150
     2.500    44.977     0.150
     2.500    45.777     0.150
     2.500    78.477     0.150
     2.833    50.578     0.150
     2.833    87.578     0.150
     2.871    46.277     0.150
     2.871    51.477     0.150
     2.871    80.977     0.150
     2.871    88.578     0.150
     2.984    91.977     0.150
     3.227    57.277     0.150
     3.227    50.477     0.150
     3.227    57.277     0.150
     3.227    88.477     0.150
     3.227    99.078     0.150
     3.499    53.875     0.150
     3.499    62.676     0.150
     3.499    54.875     0.150
     3.499    62.578     0.150
     3.499   107.477     0.150
     3.593   103.375     0.150
     3.593    57.578     0.150
     3.593    64.277     0.150
     3.593   103.375     0.150
     3.593   110.777     0.150
     4.155    62.578     0.150
     4.155    73.375     0.150
     4.155   126.777     0.150
     4.356    66.676     0.150
     4.356    77.578     0.150
     4.356   133.777     0.150
     4.575    73.078     0.150
     4.575    73.078     0.150
     4.575    83.777     0.150
     4.575   143.277     0.150
     5.029    77.676     0.150
     5.029    17.676     0.150
     5.029    91.777     0.150
     5.029   157.477     0.150
     5.071    89.977     0.150
     5.071   138.176     0.150
     5.071   155.875     0.150
     5.298    96.777     0.150
     5.298    96.777     0.150
     5.298   140.578     0.150
     5.298   162.375     0.150
     5.494    81.875     0.150
     5.494    85.477     0.150
     5.494    99.578     0.150
     5.494   146.176     0.150
     5.494   170.977     0.150
     6.675   122.676     0.150
     6.675   203.977     0.150
     6.675    97.477     0.150
     6.675   122.676     0.150
     6.675   205.977     0.150
     0.072     3.602     0.150
     0.072     6.500     0.150
     0.814    17.301     0.150
     0.814    30.301     0.150
     0.814    15.500     0.150
     0.814    17.301     0.150
     0.814    27.500     0.150
     0.814    30.301     0.150
     1.371    24.699     0.150
     1.371    43.402     0.150
     1.396    24.402     0.150
     1.396    24.402     0.150
     1.440    26.402     0.150
     2.009    33.801     0.150
     2.009    35.602     0.150
     2.009    59.301     0.150
     2.009    63.199     0.150
     2.011    33.500     0.150
     2.011    36.000     0.150
     2.011    60.301     0.150
     2.011    64.000     0.150
     2.094    37.000     0.150
     2.094    65.199     0.150
     2.094    35.301     0.150
     2.094    37.000     0.150
     2.094    65.199     0.150
     2.322    37.602     0.150
     2.322    37.699     0.150
     2.322    40.602     0.150
     2.322    71.402     0.150
     2.331    67.199     0.150
     2.331    37.699     0.150
     2.331    37.699     0.150
     2.331    41.602     0.150
     2.331    67.199     0.150
     2.331    71.602     0.150
     2.517    40.801     0.150
     2.517    44.699     0.150
     2.517    78.000     0.150
     2.566    80.902     0.150
     2.628    42.801     0.150
     2.628    42.801     0.150
     2.628    48.301     0.150
     2.628    84.102     0.150
     2.660    54.902     0.150
     2.660    43.699     0.150
     2.660    48.402     0.150
     2.660    54.902     0.150
     2.660    83.199     0.150
     2.739    43.602     0.150
     2.739    47.801     0.150
     2.739    50.199     0.150
     2.739    85.902     0.150
     2.779    43.102     0.150
     2.779    47.000     0.150
     2.779    76.199     0.150
     2.779    84.199     0.150
     2.817    44.301     0.150
     2.817    49.602     0.150
     2.817    50.602     0.150
     2.817    86.801     0.150
     3.218    56.801     0.150
     3.218    99.902     0.150
     3.579   109.301     0.150
     3.579    54.902     0.150
     3.579    61.699     0.150
     3.579    94.402     0.150
     3.579   109.301     0.150
     3.700   112.602     0.150
     3.700   112.699     0.150
     4.286    63.402     0.150
     4.286    76.500     0.150
     4.286   110.199     0.150
     4.286   131.699     0.150
     4.307   131.699     0.150
     4.307    64.602     0.150
     4.307    76.699     0.150
     4.307   113.602     0.150
     4.307   131.699     0.150
     4.738   145.402     0.150
     4.871   149.000     0.150
     4.871    85.602     0.150
     4.871    72.402     0.150
     4.871    87.301     0.150
     4.871   127.402     0.150
     4.871   149.000     0.150
     5.262   163.602     0.150
     5.262    78.500     0.150
     5.262    93.801     0.150
     5.262   138.602     0.150
     5.262   163.602     0.150
     5.759   177.402     0.150
     5.759   177.402     0.150
     5.785   176.699     0.150
     5.785    86.301     0.150
     5.785   102.301     0.150
     5.785   149.902     0.150
     5.785   176.699     0.150
     5.968   182.801     0.150
     5.968    86.699     0.150
     5.968   181.602     0.150
     5.968    86.602     0.150
     5.968   105.801     0.150
     5.968   182.801     0.150
     6.184    97.102     0.150
     6.184   190.699     0.150
     6.184    91.602     0.150
     6.184    97.102     0.150
     6.184   161.000     0.150
     6.184   190.699     0.150
     0.519    10.781     0.150
     0.519    10.781     0.150
     0.519    10.781     0.150
     0.519    17.977     0.150
     0.519    10.781     0.150
     0.519    18.180     0.150
     0.928    16.578     0.150
     0.928    16.578     0.150
     0.928    16.578     0.150
     0.928    28.781     0.150
     1.495    27.078     0.150
     1.495    48.078     0.150
     2.072    35.078     0.150
     2.072    35.078     0.150
     2.072    42.781     0.150
     2.072    35.078     0.150
     2.316    44.078     0.150
     2.316    79.383     0.150
     2.316    39.078     0.150
     2.316    67.781     0.150
     2.832    45.883     0.150
     2.774    45.281     0.150
     2.774    45.281     0.150
     3.205    51.477     0.150
     3.455    53.281     0.150
     3.455    60.883     0.150
     3.586    66.781     0.150
     4.505    76.680     0.150
     4.505    86.477     0.150
     4.505   137.977     0.150
     4.564    68.078     0.150
     4.564   140.977     0.150
     4.922    92.281     0.150
     4.922   161.281     0.150
     4.922    76.578     0.150
     5.312    82.281     0.150
     5.312    82.281     0.150
     5.312   164.977     0.150
     5.763   105.836     0.150
     5.763    85.977     0.150
     5.763   105.883     0.150
     5.763   178.281     0.150
     5.871   106.258     0.150
     5.871    87.781     0.150
     5.871   106.281     0.150
     5.871   157.680     0.150
     5.871   186.180     0.150
     6.541   202.680     0.150
     6.841   122.383     0.150
     6.841    99.883     0.150
     6.841   210.781     0.150
     8.257   116.117     0.150
     8.257   200.836     0.150
     8.257   116.078     0.150
     8.257   200.883     0.150
    12.881   188.180     0.150
    12.881   191.477     0.150
    12.881   195.477     0.150
    12.881   332.680     0.150
    12.881   337.680     0.150
    12.881   347.680     0.150
    14.519   204.578     0.150
    14.794   383.477     0.150
    15.326     4.297     0.150
    15.326     6.797     0.150
    15.326   233.977     0.150
    16.430   225.680     0.150
    16.753     3.500     0.150
    16.753     7.000     0.150
    16.753   251.180     0.150
    16.753   259.180     0.150
    16.753   424.477     0.150
    16.753   445.180     0.150
    16.753   523.180     0.150
    17.760    12.000     0.150
    17.760   471.477     0.150
    18.004   249.727     0.150
    18.004   566.688     0.150
    18.467   252.609     0.150
    18.467   252.578     0.150
    22.277   295.781     0.150
    22.277   536.078     0.150
    22.638   297.922     0.150
    22.638   297.883     0.150
    22.755   298.977     0.150
    22.881   301.680     0.150
    23.408   559.906     0.150
    23.408   307.477     0.150
    23.408   559.883     0.150
    28.713     7.000     0.150
    30.686   374.680     0.150
    39.016   445.883     0.150
    40.235   445.680     0.150
    40.235   989.281     0.150
    48.362   520.383     0.150
    59.450   601.383     0.150
     0.581    11.684     0.150
     0.581    11.684     0.150
     0.581    15.883     0.150
     0.581    18.781     0.150
     0.581    11.684     0.150
     0.581    11.684     0.150
     0.581    20.082     0.150
     0.669    14.984     0.150
     0.669    16.984     0.150
     0.955    18.184     0.150
     0.955    17.281     0.150
     0.955    29.582     0.150
     1.265    28.582     0.150
     1.424    26.484     0.150
     1.424    25.582     0.150
     1.424    45.281     0.150
     1.695    30.984     0.150
     1.695    32.484     0.150
     1.695    54.883     0.150
     1.734    40.082     0.150
     1.734    56.184     0.150
     1.734    31.684     0.150
     1.734    56.184     0.150
     1.989    36.984     0.150
     1.989    41.281     0.150
     1.989    59.781     0.150
     2.178    35.883     0.150
     2.178    35.883     0.150
     2.178    35.883     0.150
     2.178    38.281     0.150
     2.178    35.883     0.150
     2.178    38.281     0.150
     2.178    66.684     0.150
     2.474    43.781     0.150
     2.474    75.984     0.150
     2.687    42.984     0.150
     2.687    48.184     0.150
     2.687    75.484     0.150
     2.687    42.984     0.150
     2.687    48.184     0.150
     2.687    75.484     0.150
     2.687    84.082     0.150
     2.792    94.281     0.150
     2.792    85.582     0.150
     2.792    50.582     0.150
     2.792    85.582     0.150
     2.967    46.684     0.150
     2.967    52.082     0.150
     2.967    81.484     0.150
     2.967    89.383     0.150
     3.337    60.184     0.150
     3.337   103.684     0.150
     3.382   109.383     0.150
     3.382    51.582     0.150
     3.382    51.582     0.150
     3.382    59.184     0.150
     3.382    91.684     0.150
     3.382   103.684     0.150
     3.404    52.883     0.150
     3.404    61.684     0.150
     3.404    92.383     0.150
     3.404   105.582     0.150
     3.677   118.082     0.150
     3.677    56.383     0.150
     3.677    65.484     0.150
     3.677   100.582     0.150
     3.677   114.082     0.150
     3.962    80.281     0.150
     3.962    62.184     0.150
     3.962    72.383     0.150
     3.962   120.582     0.150
     4.422    65.684     0.150
     4.422    78.582     0.150
     4.422   115.484     0.150
     4.422   136.281     0.150
     4.401    82.883     0.150
     4.401   139.184     0.150
     4.401    67.281     0.150
     4.401    79.281     0.150
     4.401   117.484     0.150
     4.401   139.184     0.150
     4.877   133.383     0.150
     4.877    72.383     0.150
     4.877    72.383     0.150
     4.877    86.184     0.150
     4.877   130.082     0.150
     4.877   150.281     0.150
     5.204   161.883     0.150
     5.204    77.082     0.150
     5.204    93.281     0.150
     5.204   161.883     0.150
     5.601   142.234     0.150
     5.713   103.422     0.150
     5.713    85.082     0.150
     5.713   103.383     0.150
     5.713   152.383     0.150
     6.630   105.781     0.150
     6.630   119.883     0.150
     6.630   206.684     0.150
     6.630    97.684     0.150
     6.630   119.883     0.150
     6.630   206.684     0.150
     6.869   122.684     0.150
     6.869   122.484     0.150
     6.869   211.184     0.150
     6.869    99.582     0.150
     6.869   122.484     0.150
     6.869   176.781     0.150
     6.869   211.184     0.150
     7.548   135.281     0.150
    14.032   204.781     0.150
    14.202   199.781     0.150
    17.980   257.082     0.150
    22.636   308.293     0.150
    22.636   308.281     0.150
     0.151     5.527     0.150
     0.648    12.527     0.150
     0.648    12.527     0.150
     0.974    17.430     0.150
     0.974    30.430     0.150
     1.179    21.629     0.150
     1.179    21.629     0.150
     1.399    26.328     0.150
     1.399    44.027     0.150
     1.399    25.129     0.150
     1.399    26.328     0.150
     1.399    44.629     0.150
     1.627    29.930     0.150
     1.627    52.129     0.150
     1.669    31.027     0.150
     1.669    53.629     0.150
     1.710    31.730     0.150
     1.710    33.027     0.150
     1.710    55.129     0.150
     1.710    56.629     0.150
     2.239    37.328     0.150
     2.239    37.328     0.150
     2.273    41.129     0.150
     2.273    71.230     0.150
     2.570    42.328     0.150
     2.570    44.930     0.150
     2.570    78.730     0.150
     2.647    43.027     0.150
     2.647    47.328     0.150
     2.647    75.430     0.150
     2.647    81.230     0.150
     2.770    86.027     0.150
     3.047    48.527     0.150
     3.047    53.730     0.150
     3.047    94.129     0.150
     3.329    51.629     0.150
     3.329    58.828     0.150
     3.329   102.730     0.150
     3.373    60.328     0.150
     3.373    94.129     0.150
     3.373   103.230     0.150
     3.414   107.828     0.150
     3.726    66.527     0.150
     3.726    57.527     0.150
     3.726    66.527     0.150
     3.726   115.027     0.150
     3.946    70.027     0.150
     3.946   120.129     0.150
     4.085   128.828     0.150
     4.328    65.027     0.150
     4.328    76.930     0.150
     4.328   132.527     0.150
     4.347    78.328     0.150
     4.347   136.430     0.150
     4.864    73.629     0.150
     4.864    86.828     0.150
     4.864   132.230     0.150
     4.864   150.027     0.150
     5.256   162.230     0.150
     5.310    96.629     0.150
     5.310   164.129     0.150
     5.310    81.027     0.150
     5.310    95.930     0.150
     5.310   142.230     0.150
     5.310   164.129     0.150
     6.677   121.027     0.150
     6.677   208.930     0.150
     6.876   101.430     0.150
     6.876   123.230     0.150
     6.876   210.930     0.150
     6.876   122.629     0.150
     6.876   212.328     0.150
     0.656    12.809     0.150
     0.656    12.809     0.150
     0.656    21.711     0.150
     0.925    16.410     0.150
     0.925    16.410     0.150
     0.925    31.910     0.150
     1.148    41.109     0.150
     1.148    21.609     0.150
     1.148    37.012     0.150
     1.148    41.109     0.150
     1.232    22.809     0.150
     1.232    39.410     0.150
     1.448    25.910     0.150
     1.448    31.809     0.150
     1.448    25.910     0.150
     1.448    31.809     0.150
     1.448    45.809     0.150
     1.558    31.512     0.150
     1.558    28.211     0.150
     1.558    31.512     0.150
     1.558    49.211     0.150
     1.723    54.211     0.150
     1.723    54.211     0.150
     1.764    72.410     0.150
     1.764    55.109     0.150
     1.764    72.410     0.150
     2.185    35.809     0.150
     2.185    37.910     0.150
     2.185    67.309     0.150
     2.327    47.109     0.150
     2.327    38.512     0.150
     2.327    42.012     0.150
     2.327    47.109     0.150
     2.327    72.910     0.150
     2.522    41.211     0.150
     2.522    41.211     0.150
     2.522    44.711     0.150
     2.522    77.512     0.150
     2.699    47.211     0.150
     2.699    74.609     0.150
     2.699    83.512     0.150
     2.818    86.211     0.150
     2.818    86.211     0.150
     2.993    53.109     0.150
     2.993    57.109     0.150
     2.993    92.309     0.150
     2.993    46.711     0.150
     2.993    53.109     0.150
     2.993    57.109     0.150
     2.993    92.309     0.150
     3.310   108.109     0.150
     3.310    51.910     0.150
     3.310    58.609     0.150
     3.310   102.109     0.150
     3.310   108.109     0.150
     3.423    60.809     0.150
     3.423   105.211     0.150
     3.993    70.109     0.150
     3.993   121.910     0.150
     4.030   125.211     0.150
     4.401   113.609     0.150
     4.401   136.512     0.150
     4.910   131.609     0.150
     4.910   131.609     0.150
     4.910   151.109     0.150
     5.348   164.012     0.150
     5.348    81.012     0.150
     5.348   164.109     0.150
     5.348    81.012     0.150
     5.348   142.711     0.150
     5.348   164.109     0.150
     5.462   169.910     0.150
     6.623   205.410     0.150
     6.831   209.711     0.150
     7.598   235.309     0.150
     0.289     6.230     0.150
     0.289    10.430     0.150
     0.467     8.629     0.150
     0.467    15.129     0.150
     0.657    12.828     0.150
     0.657    12.828     0.150
     0.657    12.828     0.150
     0.740    14.031     0.150
     0.740    24.629     0.150
     1.075    34.828     0.150
     1.075    20.328     0.150
     1.075    20.328     0.150
     1.075    35.328     0.150
     1.277    23.430     0.150
     1.277    41.328     0.150
     1.314    23.430     0.150
     1.314    41.129     0.150
     1.314    23.430     0.150
     1.314    41.129     0.150
     2.300    37.930     0.150
     2.300    40.828     0.150
     2.300    70.328     0.150
     2.444    50.230     0.150
     2.444    50.230     0.150
     2.444    75.328     0.150
     2.592    41.430     0.150
     2.592    45.129     0.150
     2.592    79.531     0.150
     2.867    45.930     0.150
     2.867    50.629     0.150
     2.867    87.129     0.150
     3.033    54.328     0.150
     3.033    93.129     0.150
     3.384    52.730     0.150
     3.384    60.031     0.150
     3.384   105.930     0.150
     3.510    59.828     0.150
     3.510    62.629     0.150
     3.510   107.930     0.150
     3.625    65.129     0.150
     3.625   111.930     0.150
     3.994    69.930     0.150
     3.994   125.531     0.150
     4.079    62.730     0.150
     4.079    69.930     0.150
     4.079    73.531     0.150
     4.079   125.930     0.150
     4.306    63.828     0.150
     4.306    76.531     0.150
     4.306   131.430     0.150
     4.438    94.629     0.150
     4.438    94.629     0.150
     4.438   138.031     0.150
     4.546    76.828     0.150
     4.546   125.828     0.150
     4.546    76.828     0.150
     4.546    81.031     0.150
     4.546   125.828     0.150
     4.546   139.629     0.150
     5.032    93.230     0.150
     5.032   136.230     0.150
     5.032    77.230     0.150
     5.032    93.230     0.150
     5.032   136.230     0.150
     5.032   155.828     0.150
     5.610    84.930     0.150
     5.610   152.828     0.150
     5.856   101.629     0.150
     5.856   150.629     0.150
     5.856   181.730     0.150
     7.192   146.531     0.150
     7.192   146.531     0.150
     7.192   223.031     0.150
     0.644    12.379     0.150
     1.400    26.379     0.150
     1.400    25.277     0.150
     1.400    44.680     0.150
     1.672    54.078     0.150
     1.672    54.578     0.150
     2.236    39.277     0.150
     3.043    46.980     0.150
     3.374    60.680     0.150
     3.411    49.680     0.150
     4.082   130.980     0.150
     4.350    77.578     0.150
     5.309   161.578     0.150
     5.309   166.680     0.150
     5.512   169.078     0.150
     6.675   120.680     0.150
     6.675   121.578     0.150
     6.876   101.379     0.150
     6.876   123.277     0.150
     6.876   211.680     0.150
     0.889    16.711     0.150
     0.889    16.711     0.150
     0.889    31.914     0.150
     1.097    22.109     0.150
     1.097    20.016     0.150
     1.097    22.109     0.150
     1.097    35.109     0.150
     1.097    39.016     0.150
     1.108    21.312     0.150
     1.108    37.516     0.150
     1.392    25.211     0.150
     1.392    26.312     0.150
     1.392    44.414     0.150
     1.392    46.516     0.150
     1.491    27.211     0.150
     1.491    47.414     0.150
     1.491    48.711     0.150
     1.599    29.109     0.150
     1.599    50.609     0.150
     1.649    30.516     0.150
     1.649    52.914     0.150
     1.720    33.609     0.150
     1.720    56.016     0.150
     1.720    32.516     0.150
     1.720    33.609     0.150
     1.720    56.016     0.150
     1.830    32.016     0.150
     1.830    33.109     0.150
     1.830    57.609     0.150
     2.289    43.812     0.150
     2.289    37.516     0.150
     2.289    40.211     0.150
     2.289    41.812     0.150
     2.289    43.812     0.150
     2.289    70.711     0.150
     2.690    49.914     0.150
     2.690    43.609     0.150
     2.690    48.414     0.150
     2.690    49.914     0.150
     2.690    75.609     0.150
     2.690    83.211     0.150
     2.733    87.609     0.150
     2.733    44.312     0.150
     2.733    48.016     0.150
     2.733    84.711     0.150
     2.733    87.609     0.150
     2.856    49.312     0.150
     2.856    80.516     0.150
     2.856    88.211     0.150
     3.119    95.812     0.150
     3.148    53.516     0.150
     3.148    58.016     0.150
     3.148    59.312     0.150
     3.148    66.914     0.150
     3.148    49.211     0.150
     3.148    53.516     0.150
     3.148    58.016     0.150
     3.148    59.312     0.150
     3.148    66.914     0.150
     3.148    96.914     0.150
     3.432    62.211     0.150
     3.432   107.109     0.150
     3.735    71.211     0.150
     3.735    58.914     0.150
     3.735    67.711     0.150
     3.735    71.211     0.150
     3.735   116.016     0.150
     4.079    75.609     0.150
     4.079    61.109     0.150
     4.079    72.609     0.150
     4.079    75.609     0.150
     4.079   108.516     0.150
     4.079   125.312     0.150
     4.039    72.109     0.150
     4.039    73.711     0.150
     4.039   125.711     0.150
     4.347    82.914     0.150
     4.347    79.414     0.150
     4.347    82.914     0.150
     4.347   135.812     0.150
     4.961    81.211     0.150
     4.961    77.109     0.150
     4.961    81.211     0.150
     4.961    89.516     0.150
     4.961   132.211     0.150
     4.961   153.711     0.150
     5.273   123.516     0.150
     5.273    95.516     0.150
     5.273   123.516     0.150
     5.273   165.211     0.150
     5.451    80.109     0.150
     5.451    80.109     0.150
     5.451   141.711     0.150
     5.451   169.609     0.150
     5.604   173.711     0.150
     6.675   207.312     0.150
     6.778   207.414     0.150
     0.652    12.875     0.150
     0.652    12.875     0.150
     0.652    12.875     0.150
     0.652    12.875     0.150
     0.652    12.875     0.150
     0.652    12.875     0.150
     0.652    21.477     0.150
     0.652    22.172     0.150
     0.652    22.070     0.150
     0.863    17.773     0.150
     0.863    30.570     0.150
     1.072    35.375     0.150
     1.072    36.570     0.150
     1.072    20.172     0.150
     1.072    35.375     0.150
     1.278    27.773     0.150
     1.316    23.375     0.150
     1.316    23.375     0.150
     1.316    23.375     0.150
     1.316    41.273     0.150
     1.318    26.273     0.150
     1.318    25.672     0.150
     1.318    26.273     0.150
     1.318    43.273     0.150
     2.441    44.273     0.150
     2.441    75.570     0.150
     2.591    41.477     0.150
     2.591    41.477     0.150
     2.591    46.070     0.150
     3.622    63.773     0.150
     7.194   106.273     0.150
     7.194   129.172     0.150
     7.194   221.477     0.150
     7.194   221.570     0.150
     7.194   106.273     0.150
     7.194   129.172     0.150
     7.194   184.875     0.150
     7.194   221.477     0.150
     0.320     7.003     0.150
     0.320    11.604     0.150
     0.320    11.604     0.150
     0.466     8.804     0.150
     0.466     8.804     0.150
     0.466    21.503     0.150
     1.172    20.903     0.150
     1.172    20.903     0.150
     1.172    20.903     0.150
     1.172    20.804     0.150
     1.257    22.703     0.150
     1.257    22.703     0.150
     1.257    39.703     0.150
     2.300    41.104     0.150
     2.300    70.503     0.150
     2.457    74.403     0.150
     2.457    43.003     0.150
     2.457    74.304     0.150
     2.541    42.304     0.150
     2.541    42.304     0.150
     2.608    79.003     0.150
     3.025    51.903     0.150
     3.025    55.003     0.150
     3.025    91.403     0.150
     3.239    51.403     0.150
     3.239    98.503     0.150
     3.239    51.453     0.150
     3.239    61.533     0.150
     3.239    98.304     0.150
     3.645    58.403     0.150
     3.645   114.604     0.150
     3.645    64.703     0.150
     3.645   114.703     0.150
     3.822    70.604     0.150
     3.822   120.304     0.150
     4.284    81.003     0.150
     4.675    73.403     0.150
     4.675   127.403     0.150
     4.675    81.804     0.150
     4.675   141.903     0.150
     5.337   166.703     0.150
     5.337    84.903     0.150
     5.337    98.403     0.150
     5.337    94.304     0.150
     5.337   166.703     0.150
     5.499    86.003     0.150
     5.499   101.703     0.150
     5.499    96.604     0.150
     5.750   104.003     0.150
     5.750   149.503     0.150
     5.750    86.583     0.150
     5.750   104.043     0.150
     5.750   149.543     0.150
     6.776   127.304     0.150
     7.087   199.304     0.150
     7.087   126.903     0.150
     7.087   218.903     0.150
    13.759   424.237     0.150
    17.758   242.407     0.150
    18.235   574.884     0.150
    22.375   298.166     0.150
    22.426   302.983     0.150
     0.636    12.680     0.150
     0.636    21.781     0.150
     0.978    17.883     0.150
     0.978    17.883     0.150
     0.978    17.883     0.150
     0.978    23.781     0.150
     1.093    43.984     0.150
     1.394    25.383     0.150
     1.394    25.383     0.150
     1.394    26.383     0.150
     1.513    27.781     0.150
     1.513    27.781     0.150
     1.513    54.883     0.150
     1.628    33.086     0.150
     2.239    37.680     0.150
     2.239    37.680     0.150
     2.239    39.680     0.150
     2.239    39.680     0.150
     2.239    69.781     0.150
     2.239    39.883     0.150
     2.239    69.781     0.150
     2.564    42.586     0.150
     2.564    42.586     0.150
     2.564    46.281     0.150
     2.564    79.984     0.150
     2.644    43.180     0.150
     2.644    43.180     0.150
     2.765    52.883     0.150
     2.765    45.281     0.150
     2.765    50.180     0.150
     2.765    85.086     0.150
     3.043    47.781     0.150
     3.043    53.781     0.150
     3.043    84.086     0.150
     3.043    92.883     0.150
     3.340    51.984     0.150
     3.340    55.484     0.150
     3.340    94.781     0.150
     3.340    51.984     0.150
     3.340    59.883     0.150
     3.340   103.586     0.150
     3.412    54.781     0.150
     3.412    69.383     0.150
     3.412    87.086     0.150
     3.369    53.086     0.150
     3.369    52.906     0.150
     3.369    65.180     0.150
     3.369   104.695     0.150
     3.369    53.438     0.150
     3.369   104.680     0.150
     3.727    58.281     0.150
     3.727    58.281     0.150
     3.727    67.281     0.150
     3.727    67.281     0.150
     3.727    64.781     0.150
     3.727   114.484     0.150
     3.940    66.484     0.150
     3.940    75.883     0.150
     3.940    72.484     0.150
     3.940   120.086     0.150
     4.340    65.180     0.150
     4.340    65.180     0.150
     4.340    55.281     0.150
     4.340   115.586     0.150
     4.340   132.883     0.150
     4.347   160.383     0.150
     4.347    67.383     0.150
     4.347    77.984     0.150
     4.347   136.086     0.150
     4.858    95.281     0.150
     4.858   159.680     0.150
     4.858    86.484     0.150
     4.858   147.586     0.150
     5.257    86.781     0.150
     5.257   175.586     0.150
     5.257    78.680     0.150
     5.257    93.984     0.150
     5.257   161.883     0.150
     5.302    87.984     0.150
     5.302    80.586     0.150
     5.302    95.781     0.150
     5.302   162.383     0.150
     5.513   169.883     0.150
     5.513    82.086     0.150
     5.513    82.086     0.150
     5.513    82.086     0.150
     5.513   101.984     0.150
     5.513   120.180     0.150
     5.513   153.984     0.150
     5.513   169.586     0.150
     5.510   149.680     0.150
     5.510   169.383     0.150
     5.510    99.883     0.150
     5.510   171.781     0.150
     5.510    82.812     0.150
     5.510    99.883     0.150
     5.510   149.711     0.150
     5.510   169.352     0.150
     5.510    83.469     0.150
     5.510    83.469     0.150
     5.624   102.320     0.150
     5.624   172.305     0.150
     5.624    84.680     0.150
     5.624   102.281     0.150
     5.624   151.484     0.150
     5.624   172.281     0.150
     6.678   122.383     0.150
     6.678   208.484     0.150
     6.678   107.984     0.150
     6.678   121.281     0.150
     6.678   185.680     0.150
     6.678   122.383     0.150
     6.678   208.484     0.150
     6.882   211.781     0.150
     6.882   100.781     0.150
     6.882   123.680     0.150
     6.882   191.484     0.150
     6.882   100.781     0.150
     6.882   122.586     0.150
     6.882   177.484     0.150
     6.882   211.781     0.150
     8.128   256.586     0.150
     8.128   147.383     0.150
     8.128   190.883     0.150
     8.128   240.086     0.150
     8.128   115.203     0.150
     8.128   256.594     0.150
     9.909   154.281     0.150
    10.057   266.781     0.150
    12.623   183.281     0.150
    12.623   190.383     0.150
    12.623   327.680     0.150
    14.046   362.195     0.150
    14.264   361.172     0.150
    14.257   363.180     0.150
    14.276   201.477     0.150
    14.276   352.133     0.150
    14.276   444.570     0.150
    14.677     3.602     0.150
    15.100   209.680     0.150
    15.100   382.383     0.150
    15.102   216.781     0.150
    15.102     2.398     0.150
    15.102     9.602     0.150
    15.304   394.383     0.150
    15.821   408.180     0.150
    16.309   234.484     0.150
    16.309   415.250     0.150
    16.309   511.070     0.150
    16.652     6.500     0.150
    16.652   440.484     0.150
    17.510     3.703     0.150
    17.510     6.703     0.150
    17.510   443.883     0.150
    17.971   559.406     0.150
    17.971   248.805     0.150
    17.971   559.414     0.150
    18.501   580.484     0.150
    18.501   254.039     0.150
    19.249   472.383     0.150
    20.475   528.781     0.150
    20.475   487.227     0.150
    20.798   654.828     0.150
    22.510     4.000     0.150
    22.510     6.297     0.150
    22.510    27.297     0.150
    22.668   536.023     0.150
    22.668   299.781     0.150
    22.668   535.984     0.150
    22.629     4.203     0.150
    22.629     7.000     0.150
    22.629    28.203     0.150
    22.720   300.789     0.150
    22.711   600.883     0.150
    23.078   311.281     0.150
    24.023     3.602     0.150
    24.080   316.352     0.150
    24.898   324.555     0.150
    24.898   783.727     0.150
    24.898   324.680     0.150
    25.239   345.781     0.150
    25.747   335.281     0.150
    26.044   339.680     0.150
    26.044     4.000     0.150
    26.044     7.000     0.150
    26.044    43.000     0.150
    26.625   619.883     0.150
    26.768   344.484     0.150
    26.768   345.484     0.150
    26.768   345.430     0.150
    26.837    45.000     0.150
    27.491   363.586     0.150
    28.392   408.281     0.150
    28.392   735.984     0.150
    28.462     2.398     0.150
    28.462     3.898     0.150
    29.017   360.055     0.150
    30.098   375.781     0.150
    30.596   428.781     0.150
    30.596   549.281     0.150
    33.476   398.180     0.150
    34.213     7.297     0.150
    35.200   414.156     0.150
    37.075   433.281     0.150
    37.075   521.883     0.150
    37.886   441.883     0.150
    38.673   443.391     0.150
    39.458   448.383     0.150
    39.565   447.180     0.150
    39.565   565.484     0.150
    39.565  1016.680     0.150
    40.389  1003.984     0.150
    40.389   454.711     0.150
    41.342   560.203     0.150
    41.904   469.781     0.150
    43.036   481.609     0.150
    44.174   490.422     0.150
    44.174   491.180     0.150
    45.539   901.586     0.150
    45.539  1155.883     0.150
    45.989   501.883     0.150
    46.510   506.195     0.150
    47.313   611.883     0.150
    47.574   515.273     0.150
    47.574   609.820     0.150
    48.220   632.695     0.150
    48.499   523.023     0.150
    48.851   525.211     0.150
    48.945   524.883     0.150
    48.945   950.883     0.150
    50.150   535.359     0.150
    50.383   536.844     0.150
    50.478   538.984     0.150
    50.719   547.281     0.150
    50.719   547.281     0.150
    51.142   543.383     0.150
    51.142     4.602     0.150
    51.142   543.383     0.150
    51.142     4.602     0.150
    51.291   543.430     0.150
    51.323   548.883     0.150
    51.323   548.883     0.150
    51.350   543.812     0.150
    51.351   544.883     0.150
    51.351     4.602     0.150
    51.351   564.883     0.150
    51.351   544.883     0.150
    51.351     4.602     0.150
    51.351   564.883     0.150
    51.443   550.883     0.150
    51.443   550.883     0.150
    51.509   549.680     0.150
    51.554   542.383     0.150
    51.554   550.680     0.150
    51.554   542.383     0.150
    51.554   550.680     0.150
    51.554   980.086     0.150
    51.554  1198.781     0.150
    51.956   554.883     0.150
    51.956   554.883     0.150
    52.302   552.883     0.150
    52.318   555.484     0.150
    52.337   552.586     0.150
    52.337     4.594     0.150
    52.337   566.984     0.150
    52.337   552.586     0.150
    52.337     4.594     0.150
    52.337   566.984     0.150
    52.612   555.180     0.150
    52.612  1004.883     0.150
    53.159   559.281     0.150
    53.159  1011.883     0.150
    53.157   563.781     0.150
    53.157   572.086     0.150
    53.157   558.680     0.150
    53.157   563.781     0.150
    53.157   572.086     0.150
    53.157   558.680     0.150
    53.157   572.086     0.150
    53.317   573.781     0.150
    53.317   559.984     0.150
    53.317     4.602     0.150
    53.317   573.781     0.150
    53.519   559.984     0.150
    53.519   559.984     0.150
    53.721   561.586     0.150
    53.876   564.484     0.150
    53.939   563.883     0.150
    53.939     4.797     0.150
    53.939   687.883     0.150
    53.939  1023.883     0.150
    54.084   572.383     0.150
    54.084  1018.883     0.150
    54.084   564.883     0.150
    54.084   572.383     0.150
    54.084   631.883     0.150
    54.084  1018.883     0.150
    54.084   564.883     0.150
    54.084     3.398     0.150
    54.084   572.383     0.150
    54.084   631.883     0.150
    54.084   729.883     0.150
    54.084   745.180     0.150
    54.084   751.984     0.150
    54.084   768.086     0.150
    54.084  1018.883     0.150
    54.084  1018.883     0.150
    54.084  1078.883     0.150
    54.253   567.680     0.150
    54.253  1025.586     0.150
    54.267   567.180     0.150
    54.785   571.883     0.150
    54.922   571.680     0.150
    54.922   571.680     0.150
    55.074   573.383     0.150
    55.074  1040.484     0.150
    55.178   572.984     0.150
    55.297   579.383     0.150
    55.297   574.086     0.150
    55.297  1042.586     0.150
    55.434   575.180     0.150
    55.621   577.086     0.150
    55.621   577.086     0.150
    56.021   579.984     0.150
    56.021   579.984     0.150
    56.021   579.984     0.150
    56.924   585.984     0.150
    56.924   585.984     0.150
    57.065   587.484     0.150
    57.065   587.484     0.150
    57.613   590.984     0.150
    57.739   596.891     0.150
    58.035   592.875     0.150
    58.283   598.781     0.150
    58.331   596.086     0.150
    58.358   602.289     0.150
    58.757   598.180     0.150
    58.757   598.180     0.150
    58.931   598.984     0.150
    58.931   598.984     0.150
    58.954   599.977     0.150
    59.005   598.586     0.150
    59.231   605.281     0.150
    59.385   602.383     0.150
    59.385   602.383     0.150
    59.479   602.984     0.150
    59.479   602.984     0.150
    59.685   602.922     0.150
    59.702   604.781     0.150
    60.171   608.531     0.150
    60.626   611.180     0.150
    60.626   611.180     0.150
    61.135   614.984     0.150
    61.135   614.984     0.150
    61.157   613.984     0.150
    61.157   613.984     0.150
    61.471   616.281     0.150
    61.471   616.281     0.150
    61.505   616.633     0.150
    61.632   617.484     0.150
    61.632   617.484     0.150
    61.703   618.281     0.150
    61.703   618.281     0.150
    61.744   618.180     0.150
    61.744   618.180     0.150
    61.905   618.680     0.150
    61.905   618.680     0.150
    61.930   618.781     0.150
    61.933   624.586     0.150
    61.982   620.484     0.150
    61.982   620.484     0.150
    62.006   624.281     0.150
    62.028   620.180     0.150
    62.028   620.180     0.150
    62.049   624.586     0.150
    62.140   627.383     0.150
    62.149   621.086     0.150
    62.149   621.086     0.150
    62.374   628.281     0.150
    62.402   629.586     0.150
    62.634   624.180     0.150
    62.634   624.180     0.150
    62.640   624.383     0.150
    62.640   624.383     0.150
    62.870   625.883     0.150
    62.870   625.883     0.150
    62.972   632.383     0.150
    63.435   628.984     0.150
    63.435   628.984     0.150
    63.446   629.680     0.150
    63.446   629.680     0.150
    63.718   631.180     0.150
    63.718   631.180     0.150
    64.337   636.281     0.150
    64.337   636.281     0.150
    64.895   639.984     0.150
    64.895   639.984     0.150
    66.001   646.586     0.150
    66.001   646.586     0.150
    66.323   652.953     0.150
    66.361   653.195     0.150
    66.691   654.656     0.150
    66.970   656.906     0.150
    67.400   660.211     0.150
    68.276   665.883     0.150
    68.368   666.484     0.150
    68.473   666.664     0.150
    68.843   665.516     0.150
    68.877   668.883     0.150
    69.066   669.914     0.150
    69.436   667.039     0.150
    69.935   672.922     0.150
    70.142   676.289     0.150
    70.795   678.266     0.150
    70.910   675.359     0.150
    71.771   683.766     0.150
    72.766   692.180     0.150
    72.766   692.227     0.150
    74.806   699.555     0.150
    74.892   701.062     0.150
    75.597   705.461     0.150
    75.692   705.883     0.150
    75.692   705.922     0.150
    76.281   708.484     0.150
    76.667   710.961     0.150
    76.733   712.312     0.150
    76.983   715.281     0.150
    78.810   724.344     0.150
    78.878   723.234     0.150
    79.032   724.234     0.150
    79.408   728.125     0.150
    79.775   728.453     0.150
    80.085   730.352     0.150
    80.292   731.680     0.150
    82.030   741.156     0.150
    82.710   744.273     0.150
    83.418   748.695     0.150
    86.805   769.680     0.150
    87.034   766.203     0.150
    89.189   776.891     0.150
    89.320   777.180     0.150
    89.320   988.406     0.150
   143.049  1171.914     0.150
   151.060  1187.055     0.150
   151.060  1192.461     0.150
     0.645    12.625     0.150
     0.645    21.820     0.150
     0.981    30.727     0.150
     0.981    17.625     0.150
     0.981    30.727     0.150
     1.392    45.320     0.150
     1.392    25.523     0.150
     1.392    25.523     0.150
     1.392    45.320     0.150
     2.246    37.625     0.150
     2.246    39.523     0.150
     2.246    37.625     0.150
     2.246    39.523     0.150
     2.246    69.820     0.150
     2.575    42.727     0.150
     2.575    46.227     0.150
     2.575    42.727     0.150
     2.575    46.227     0.150
     2.575    73.820     0.150
     2.575    80.125     0.150
     2.763    43.227     0.150
     2.763    48.422     0.150
     2.763    84.320     0.150
     3.054    52.523     0.150
     3.054    52.523     0.150
     3.054    91.727     0.150
     3.365    52.820     0.150
     3.365    60.125     0.150
     3.365   103.523     0.150
     4.329    77.422     0.150
     4.329    65.820     0.150
     4.329    77.422     0.150
     4.329   133.422     0.150
     4.856    88.625     0.150
     4.856   149.422     0.150
     0.631    12.383     0.150
     0.631    21.281     0.150
     0.986    17.578     0.150
     0.986    30.781     0.150
     2.566    42.781     0.150
     2.566    46.078     0.150
     2.566    80.180     0.150
     2.758    45.383     0.150
     2.758    49.883     0.150
     2.758    84.781     0.150
     3.048    53.883     0.150
     3.048    53.883     0.150
     3.048    91.977     0.150
     3.362    60.477     0.150
     3.362    60.477     0.150
     3.362   104.281     0.150
     5.294    75.977     0.150
     5.507   100.180     0.150
     6.685   120.977     0.150
     0.637    12.469     0.150
     0.637    12.469     0.150
     0.637    12.469     0.150
     0.637    21.469     0.150
     0.985    20.266     0.150
     0.985    17.766     0.150
     0.985    30.867     0.150
     1.388    44.469     0.150
     1.388    44.562     0.150
     1.388    48.062     0.150
     1.388    25.062     0.150
     1.388    44.469     0.150
     1.504    30.367     0.150
     1.619    34.664     0.150
     2.247    37.664     0.150
     2.247    39.664     0.150
     2.247    70.062     0.150
     2.572    49.664     0.150
     2.572    42.867     0.150
     2.572    46.266     0.150
     2.572    80.664     0.150
     2.759    48.562     0.150
     2.759    85.062     0.150
     3.052    47.469     0.150
     3.052    57.164     0.150
     3.052    47.469     0.150
     3.052    53.664     0.150
     3.052    84.164     0.150
     3.052    93.266     0.150
     3.341    58.969     0.150
     3.341   102.766     0.150
     3.362    59.266     0.150
     3.362   102.867     0.150
     3.420    60.562     0.150
     3.420    60.562     0.150
     3.420   108.164     0.150
     3.735   116.062     0.150
     3.735    58.164     0.150
     3.735    64.664     0.150
     3.735    99.062     0.150
     3.735   115.969     0.150
     3.934    62.664     0.150
     3.934    70.969     0.150
     4.336    65.562     0.150
     4.336    77.562     0.150
     4.336   115.766     0.150
     4.336   132.766     0.150
     4.339    68.469     0.150
     4.339    77.562     0.150
     4.339   135.062     0.150
     5.297    89.664     0.150
     5.297    97.266     0.150
     5.297   163.562     0.150
     5.522    81.266     0.150
     5.522    97.766     0.150
     5.522   169.562     0.150
     5.501   100.469     0.150
     6.686   121.664     0.150
     6.686   207.469     0.150
     6.686   121.562     0.150
     6.686   121.664     0.150
     6.686   207.469     0.150
     6.888   211.562     0.150
     6.888   123.766     0.150
     6.888   100.664     0.150
     6.888   122.766     0.150
     6.888   177.562     0.150
     6.888   211.562     0.150
     0.648    12.820     0.150
     0.648    21.922     0.150
     0.968    29.820     0.150
     0.968    17.121     0.150
     0.968    29.719     0.150
     0.968    34.020     0.150
     1.100    25.320     0.150
     1.186    21.922     0.150
     1.186    21.922     0.150
     1.405    44.621     0.150
     1.405    26.719     0.150
     1.405    25.621     0.150
     1.405    44.621     0.150
     1.514    27.621     0.150
     1.514    27.621     0.150
     1.514    51.422     0.150
     1.634    57.121     0.150
     2.232    37.320     0.150
     2.232    37.320     0.150
     2.232    37.320     0.150
     2.564    49.422     0.150
     2.654    43.121     0.150
     2.654    43.121     0.150
     2.776    42.422     0.150
     2.776    96.719     0.150
     2.776    50.219     0.150
     2.776    84.922     0.150
     3.040    52.121     0.150
     3.040    54.121     0.150
     3.040    80.621     0.150
     3.327    77.922     0.150
     3.327   102.719     0.150
     3.327    51.719     0.150
     3.327    59.520     0.150
     3.327    90.820     0.150
     3.327   102.621     0.150
     3.407    60.719     0.150
     3.407   105.719     0.150
     3.379    88.020     0.150
     3.379    98.520     0.150
     3.379    53.031     0.150
     3.379    53.121     0.150
     3.379    60.621     0.150
     3.379   104.520     0.150
     3.951    80.422     0.150
     4.078    65.719     0.150
     4.078   112.121     0.150
     4.354    67.320     0.150
     4.354    67.320     0.150
     4.354    67.320     0.150
     4.354    79.020     0.150
     4.354    79.020     0.150
     4.354    85.422     0.150
     4.869   114.219     0.150
     4.869   158.422     0.150
     4.869    88.719     0.150
     4.869   149.422     0.150
     5.314    80.121     0.150
     5.314    95.422     0.150
     5.314   139.621     0.150
     5.314   162.820     0.150
     5.509   170.320     0.150
     5.509    81.820     0.150
     5.509    98.320     0.150
     5.509   170.320     0.150
     5.509   103.820     0.150
     5.509   167.719     0.150
     5.624    84.922     0.150
     5.624   101.520     0.150
     5.624   150.922     0.150
     6.670   206.422     0.150
     6.670   109.520     0.150
     6.670   121.520     0.150
     6.670   130.520     0.150
     6.670   121.520     0.150
     6.670   206.422     0.150
     6.871   211.719     0.150
     6.871   103.621     0.150
     6.871   100.520     0.150
     6.871   122.719     0.150
     6.871   177.422     0.150
     6.871   211.719     0.150
     9.898   309.922     0.150
    14.059   445.438     0.150
    14.059   199.520     0.150
    17.983   573.672     0.150
    18.514   592.172     0.150
    18.599   592.172     0.150
    22.681   302.020     0.150
    24.092   316.129     0.150
    25.688   325.859     0.150
    50.952   543.422     0.150
    79.744   728.219     0.150
     0.593    26.782     0.150
     0.652    12.882     0.150
     0.652    12.882     0.150
     0.652    12.882     0.150
     0.652    22.082     0.150
     0.652    27.082     0.150
     0.652    22.082     0.150
     0.962    22.782     0.150
     1.106    25.482     0.150
     1.411    25.982     0.150
     1.411    44.782     0.150
     1.411    25.882     0.150
     1.411    44.782     0.150
     1.920    34.682     0.150
     1.920    34.682     0.150
     2.560    42.682     0.150
     3.035    54.182     0.150
     3.035    48.582     0.150
     3.035    54.082     0.150
     3.035    83.682     0.150
     3.035    91.682     0.150
     3.385    53.182     0.150
     3.385    60.382     0.150
     3.385   104.282     0.150
     3.958    71.382     0.150
     3.958   119.382     0.150
     4.876    74.382     0.150
     4.876   147.982     0.150
     5.320    97.082     0.150
     5.320   164.482     0.150
     5.320    81.882     0.150
     5.320    97.082     0.150
     5.320   164.482     0.150
     5.504   100.782     0.150
     6.664   121.082     0.150
     6.865   102.682     0.150
     6.865   124.182     0.150
     6.865   210.682     0.150
     6.865   102.882     0.150
     6.865   124.082     0.150
     6.865   210.982     0.150
     6.865   102.682     0.150
     6.865   124.182     0.150
     6.865   210.682     0.150
     0.573    12.969     0.150
     0.638    12.469     0.150
     0.638    12.469     0.150
     0.638    21.369     0.150
     0.988    30.669     0.150
     0.988    17.469     0.150
     0.988    30.369     0.150
     0.988    33.369     0.150
     0.988    17.469     0.150
     0.988    30.669     0.150
     1.385    44.169     0.150
     1.385    26.369     0.150
     1.385    25.369     0.150
     1.385    44.169     0.150
     1.500    27.469     0.150
     1.500    27.469     0.150
     1.615    53.369     0.150
     2.251    39.569     0.150
     2.251    37.669     0.150
     2.251    39.569     0.150
     2.251    69.369     0.150
     2.576    54.269     0.150
     2.576    81.969     0.150
     2.756    49.569     0.150
     2.756    83.269     0.150
     3.056    51.769     0.150
     3.056    56.369     0.150
     3.359    51.569     0.150
     3.359    59.069     0.150
     3.359   103.269     0.150
     3.738   112.869     0.150
     3.738   121.269     0.150
     3.738    58.769     0.150
     3.738    66.369     0.150
     3.738   112.869     0.150
     3.932   114.369     0.150
     3.932    61.769     0.150
     3.932    70.969     0.150
     3.932   119.869     0.150
     4.097    68.969     0.150
     4.850   134.269     0.150
     4.850    87.669     0.150
     4.850   147.569     0.150
     5.269    95.069     0.150
     5.269   162.069     0.150
     5.296    97.069     0.150
     5.296   165.469     0.150
     5.296    87.469     0.150
     5.296    81.469     0.150
     5.296    97.069     0.150
     5.296   165.469     0.150
     6.890   123.469     0.150
     6.890   211.669     0.150
     6.890   123.469     0.150
     6.890   193.469     0.150
     6.890   211.769     0.150
     6.890   123.469     0.150
     6.890   211.669     0.150
     0.645    12.520     0.150
     0.645    12.520     0.150
     0.645    12.520     0.150
     0.645    21.621     0.150
     1.394    25.219     0.150
     1.394    44.121     0.150
     1.504    27.621     0.150
     1.504    27.621     0.150
     1.504    28.922     0.150
     1.622    31.820     0.150
     1.664    54.520     0.150
     1.705    32.820     0.150
     1.705    57.020     0.150
     1.904    34.820     0.150
     1.904    34.820     0.150
     1.904    36.422     0.150
     2.244    37.719     0.150
     2.244    39.621     0.150
     2.244    43.820     0.150
     2.244    37.719     0.150
     2.244    39.621     0.150
     2.244    69.320     0.150
     2.765    50.219     0.150
     2.765    84.020     0.150
     3.051    47.621     0.150
     3.051    54.121     0.150
     3.051    84.520     0.150
     3.051    93.320     0.150
     3.419    66.719     0.150
     3.368    63.020     0.150
     3.368    87.922     0.150
     3.368    52.422     0.150
     3.368    60.020     0.150
     3.368   103.320     0.150
     3.731    58.621     0.150
     3.731   114.219     0.150
     3.941    95.922     0.150
     3.941    71.621     0.150
     3.941   120.219     0.150
     4.089   140.020     0.150
     4.859    80.320     0.150
     4.859   135.520     0.150
     5.261    83.121     0.150
     5.261    96.020     0.150
     5.261   148.621     0.150
     5.261    96.219     0.150
     5.261   162.121     0.150
     5.305    97.121     0.150
     5.305   164.320     0.150
     5.305    81.621     0.150
     5.305    97.121     0.150
     5.305   164.320     0.150
     5.500    91.719     0.150
     6.881   123.621     0.150
     6.881   211.719     0.150
     6.881   100.922     0.150
     6.881   103.121     0.150
     6.881   123.520     0.150
     6.881   193.422     0.150
     6.881   100.922     0.150
     6.881   123.621     0.150
     6.881   177.621     0.150
     6.881   211.719     0.150
     0.564    23.992     0.150
     1.072    33.492     0.150
     1.377    47.094     0.150
     1.688    55.895     0.150
     2.625    46.395     0.150
     2.748    42.293     0.150
     3.434   114.395     0.150
     5.278   167.492     0.150
     5.535   172.594     0.150
     0.637    12.412     0.150
     0.637    12.412     0.150
     0.984    35.014     0.150
     2.245    42.312     0.150
     0.613    24.293     0.150
     0.955    34.395     0.150
     1.417    49.793     0.150
     1.539    30.793     0.150
     2.211    41.496     0.150
     0.156     3.384     0.150
     0.156     3.384     0.150
     0.638    12.584     0.150
     0.638    12.584     0.150
     0.638    12.584     0.150
     0.638    21.384     0.150
     0.638    21.284     0.150
     0.969    17.384     0.150
     0.969    17.384     0.150
     0.969    30.284     0.150
     1.404    44.184     0.150
     1.404    25.384     0.150
     1.404    25.284     0.150
     1.404    44.184     0.150
     1.921    34.584     0.150
     1.921    34.584     0.150
     2.228    37.284     0.150
     2.228    37.284     0.150
     2.228    37.284     0.150
     2.228    39.284     0.150
     2.228    39.284     0.150
     2.228    39.284     0.150
     2.555    42.484     0.150
     2.555    79.284     0.150
     2.555    42.484     0.150
     2.555    46.284     0.150
     2.555    79.184     0.150
     2.654    79.984     0.150
     3.034    53.284     0.150
     3.034    91.584     0.150
     3.336    58.884     0.150
     3.336   101.784     0.150
     3.379    60.784     0.150
     3.379    53.584     0.150
     3.379    60.684     0.150
     3.379   103.184     0.150
     3.949    59.684     0.150
     3.949    71.984     0.150
     3.949   119.984     0.150
     4.867   134.784     0.150
     5.247   162.584     0.150
     5.247   162.584     0.150
     5.247    78.384     0.150
     5.247    91.784     0.150
     5.247   162.584     0.150
     5.309    97.284     0.150
     5.309   163.884     0.150
     5.309    83.784     0.150
     5.309   143.584     0.150
     5.309   163.784     0.150
     5.309    97.284     0.150
     5.309   163.884     0.150
     6.874   210.684     0.150
     6.874   100.284     0.150
     6.874   122.284     0.150
     6.874   177.084     0.150
     6.874   210.684     0.150
     7.560   196.484     0.150
     1.287    23.531     0.150
     1.635    27.633     0.150
     1.635    27.633     0.150
     2.046    61.734     0.150
     2.163    68.531     0.150
     2.307    43.234     0.150
     2.354    74.930     0.150
     2.901    75.430     0.150
     3.391    64.828     0.150
     4.577   152.430     0.150
     4.712   145.328     0.150
     5.971   184.734     0.150
     5.971   184.828     0.150
     8.309   257.930     0.150
     0.801    25.223     0.150
     0.909    17.023     0.150
     0.909    17.023     0.150
     0.909    29.426     0.150
     1.789    57.223     0.150
     1.789    56.723     0.150
     1.789    32.324     0.150
     1.789    57.223     0.150
     2.147    35.125     0.150
     2.147    35.125     0.150
     2.147    37.223     0.150
     2.147    65.223     0.150
     2.616    43.324     0.150
     2.616    43.324     0.150
     2.616    46.926     0.150
     2.616    73.926     0.150
     2.616    79.625     0.150
     3.062    54.824     0.150
     3.062    94.824     0.150
     3.013    47.926     0.150
     3.370    62.223     0.150
     3.370    62.125     0.150
     3.370   105.125     0.150
     3.594    64.324     0.150
     3.594   110.324     0.150
     3.561   102.723     0.150
     4.160    63.125     0.150
     4.160    75.625     0.150
     4.160   127.125     0.150
     4.487    71.926     0.150
     5.131    87.324     0.150
     5.131    97.023     0.150
     5.466   191.824     0.150
     5.598    83.223     0.150
     5.598   100.426     0.150
     5.553    90.426     0.150
     6.535   201.625     0.150
     6.535   117.824     0.150
     6.535   117.824     0.150
     6.535   201.625     0.150
     6.657    99.324     0.150
     6.657   120.125     0.150
     6.657   205.023     0.150
     6.657   122.023     0.150
     6.657   185.223     0.150
     6.657    99.324     0.150
     6.657   120.125     0.150
     6.657   205.023     0.150
    48.826   525.273     0.150
    48.826   525.324     0.150
    79.556   728.297     0.150
    79.556   728.324     0.150
     0.633    12.402     0.150
     0.633    12.402     0.150
     0.633    12.402     0.150
     0.633    20.801     0.150
     0.986    17.602     0.150
     0.986    17.602     0.150
     0.986    34.902     0.150
     1.387    44.703     0.150
     1.387    25.102     0.150
     1.387    25.102     0.150
     1.387    44.703     0.150
     1.904    34.402     0.150
     1.904    34.402     0.150
     2.246    43.801     0.150
     2.569    46.102     0.150
     2.569    42.703     0.150
     2.569    46.102     0.150
     2.569    73.703     0.150
     2.569    78.801     0.150
     2.758    38.102     0.150
     3.050   117.500     0.150
     3.362   106.500     0.150
     3.418    62.102     0.150
     3.418   107.703     0.150
     3.933    69.500     0.150
     3.933   118.801     0.150
     4.092    53.102     0.150
     5.295    97.801     0.150
     5.295    89.801     0.150
     5.295   163.602     0.150
     5.295    97.801     0.150
     5.295   163.000     0.150
     6.686   121.500     0.150
     6.686   207.902     0.150
     6.686   120.703     0.150
     6.686   121.500     0.150
     6.686   207.902     0.150
     6.889   212.500     0.150
     6.889   123.402     0.150
     6.889   212.500     0.150
     6.889   100.402     0.150
     6.889   122.602     0.150
     6.889   177.902     0.150
     6.889   212.500     0.150
     0.334     6.494     0.150
     0.334     6.494     0.150
     0.482     9.594     0.150
     0.482     9.594     0.150
     0.482     9.594     0.150
     0.482    16.294     0.150
     0.482    16.294     0.150
     0.982    23.394     0.150
     0.982    34.394     0.150
     2.074    62.994     0.150
     2.136    37.994     0.150
     2.136    65.494     0.150
     2.790    50.594     0.150
     2.790    83.994     0.150
     3.416   104.494     0.150
     3.416    53.994     0.150
     3.416    61.694     0.150
     3.416    93.894     0.150
     3.416   104.394     0.150
     3.650    65.594     0.150
     3.650   112.594     0.150
     4.442    74.594     0.150
     4.863    89.094     0.150
     4.863   149.994     0.150
     5.170    88.794     0.150
     5.170   103.194     0.150
     5.259   160.194     0.150
     5.259    80.894     0.150
     5.259    80.994     0.150
     5.259    93.894     0.150
     5.259   160.194     0.150
     5.367    97.894     0.150
     5.714   103.994     0.150
     6.897   124.594     0.150
     6.897   212.294     0.150
     6.897   188.294     0.150
     6.897   212.294     0.150
     6.897   124.594     0.150
     6.897   212.294     0.150
     0.344    13.117     0.150
     0.344     7.414     0.150
     0.344    13.117     0.150
     0.858    16.816     0.150
     0.827    15.715     0.150
     0.827    30.215     0.150
     0.827    15.715     0.150
     0.827    27.117     0.150
     1.356    24.816     0.150
     1.356    24.816     0.150
     1.356    42.914     0.150
     1.631    28.117     0.150
     1.631    50.316     0.150
     2.117    43.816     0.150
     2.154    66.016     0.150
     2.154    37.414     0.150
     2.154    66.016     0.150
     2.734    82.715     0.150
     2.734    47.414     0.150
     2.734    81.215     0.150
     2.796    48.816     0.150
     2.796    84.516     0.150
     3.405   102.414     0.150
     3.405    52.316     0.150
     3.405    59.617     0.150
     3.405   102.414     0.150
     3.306    64.914     0.150
     3.306    59.816     0.150
     3.306   100.215     0.150
     3.786    67.516     0.150
     3.786   116.316     0.150
     4.016    69.117     0.150
     3.880    69.117     0.150
     3.880   119.215     0.150
     4.266   129.016     0.150
     4.266    76.516     0.150
     4.266   129.016     0.150
     4.214    81.816     0.150
     4.214   128.215     0.150
     4.214    74.016     0.150
     4.214   128.117     0.150
     4.614   142.914     0.150
     4.614   142.914     0.150
     4.614    84.414     0.150
     4.614   142.914     0.150
     4.820   148.715     0.150
     4.820    70.215     0.150
     4.820    87.816     0.150
     4.820    70.215     0.150
     4.820    87.215     0.150
     4.820   123.516     0.150
     4.820   148.715     0.150
     5.545   141.855     0.150
     5.772   179.414     0.150
     5.772   104.617     0.150
     5.772   179.414     0.150
     5.872   179.715     0.150
     5.872    85.117     0.150
     5.872   104.414     0.150
     5.872   179.715     0.150
     7.218   222.316     0.150
     7.218   131.117     0.150
     7.218   222.316     0.150
     7.547   133.914     0.150
     7.547   232.414     0.150
     7.547   108.617     0.150
     7.547   108.617     0.150
     7.547   133.914     0.150
     7.547   232.414     0.150
    13.355   189.672     0.150
    21.982   291.176     0.150
    49.224   524.664     0.150
     0.332     6.869     0.150
     0.332     6.869     0.150
     0.646    12.656     0.150
     0.646    12.656     0.150
     0.646    21.355     0.150
     0.971    30.656     0.150
     0.971    34.855     0.150
     0.971    17.855     0.150
     0.971    30.656     0.150
     1.402    25.258     0.150
     1.402    25.258     0.150
     1.402    44.156     0.150
     1.674    30.957     0.150
     2.234    37.555     0.150
     2.234    39.457     0.150
     2.234    37.457     0.150
     2.234    39.457     0.150
     2.234    65.457     0.150
     2.234    69.156     0.150
     2.565    42.555     0.150
     2.565    46.055     0.150
     2.565    73.457     0.150
     2.565    79.758     0.150
     2.773    51.457     0.150
     2.773    86.156     0.150
     3.041    47.957     0.150
     3.041    53.758     0.150
     3.041    83.656     0.150
     3.041    91.957     0.150
     3.330    50.855     0.150
     3.330    59.457     0.150
     3.330   101.258     0.150
     3.376    53.258     0.150
     3.376    60.156     0.150
     3.376   103.457     0.150
     3.409    63.156     0.150
     3.409   107.758     0.150
     3.721    65.156     0.150
     3.721   100.656     0.150
     3.721   115.355     0.150
     3.949    69.355     0.150
     3.949   120.055     0.150
     4.332    83.055     0.150
     4.867    85.758     0.150
     5.252   163.457     0.150
     5.252    78.457     0.150
     5.252    93.656     0.150
     5.252   163.457     0.150
     5.311    97.055     0.150
     5.311   163.855     0.150
     5.311   163.855     0.150
     5.311    97.055     0.150
     5.311   163.855     0.150
     6.672   120.758     0.150
     6.672   207.355     0.150
     6.672   120.758     0.150
     6.672   207.355     0.150
     6.873   209.855     0.150
     6.873   123.156     0.150
     6.873   100.555     0.150
     6.873   122.156     0.150
     6.873   176.258     0.150
     6.873   209.855     0.150
     0.650    12.688     0.150
     0.650    12.688     0.150
     2.241    37.391     0.150
     2.241    37.391     0.150
     0.157     3.988     0.150
     0.157     3.988     0.150
     0.645    12.988     0.150
     0.645    12.988     0.150
     0.982    17.188     0.150
     0.982    17.188     0.150
     1.392    25.088     0.150
     1.392    25.088     0.150
     1.661    53.588     0.150
     0.609    12.123     0.150
     0.609    20.223     0.150
     0.609    20.123     0.150
     0.835    15.023     0.150
     0.835    26.324     0.150
     0.835    30.223     0.150
     0.835    15.123     0.150
     0.835    26.324     0.150
     1.579    28.223     0.150
     1.579    49.523     0.150
     1.922    60.424     0.150
     1.922    60.623     0.150
     1.922    35.424     0.150
     1.922    60.424     0.150
     1.997    33.623     0.150
     1.997    35.123     0.150
     1.997    40.824     0.150
     1.997    33.623     0.150
     1.997    35.123     0.150
     1.997    58.824     0.150
     1.997    61.424     0.150
     2.286    38.023     0.150
     2.286    41.924     0.150
     2.286    65.523     0.150
     2.286    69.523     0.150
     2.775    44.723     0.150
     2.775    49.123     0.150
     2.775    52.523     0.150
     2.775    44.723     0.150
     2.775    49.023     0.150
     2.775    76.623     0.150
     2.939    53.123     0.150
     2.939    89.223     0.150
     3.374    51.723     0.150
     3.374    59.123     0.150
     3.374    91.223     0.150
     3.374   101.723     0.150
     3.563    55.023     0.150
     3.563   107.223     0.150
     3.563    54.924     0.150
     3.563    62.623     0.150
     4.101    73.723     0.150
     4.101    63.723     0.150
     4.101    73.623     0.150
     4.519    66.723     0.150
     4.519    80.123     0.150
     4.519   139.424     0.150
     5.012    85.023     0.150
     5.405   168.023     0.150
     6.748   206.223     0.150
     6.748    97.723     0.150
     6.748   118.924     0.150
     6.748   173.023     0.150
     6.748   206.223     0.150
     0.634    12.383     0.150
     0.634    12.383     0.150
     0.634    12.383     0.150
     0.634    25.383     0.150
     0.634    21.086     0.150
     0.982    17.680     0.150
     0.982    20.086     0.150
     0.982    35.086     0.150
     0.982    17.680     0.150
     0.982    30.383     0.150
     1.391    44.781     0.150
     1.391    25.086     0.150
     1.391    29.383     0.150
     1.391    25.086     0.150
     1.391    44.781     0.150
     1.510    27.586     0.150
     1.510    27.586     0.150
     1.510    30.586     0.150
     1.510    32.883     0.150
     1.666    34.680     0.150
     2.242    37.586     0.150
     2.242    37.586     0.150
     2.242    37.586     0.150
     2.242    42.180     0.150
     2.242    37.586     0.150
     2.242    39.586     0.150
     2.242    65.680     0.150
     2.242    69.484     0.150
     2.566    42.586     0.150
     2.566    66.086     0.150
     2.566    42.586     0.150
     2.566    46.180     0.150
     2.566    74.180     0.150
     2.566    79.680     0.150
     2.641    49.281     0.150
     2.762    88.781     0.150
     2.762    49.586     0.150
     2.762    85.180     0.150
     3.046    58.086     0.150
     3.046    48.680     0.150
     3.046    53.586     0.150
     3.046    83.781     0.150
     3.046    92.383     0.150
     3.342    54.484     0.150
     3.342    54.484     0.150
     3.342    60.883     0.150
     3.342   102.586     0.150
     3.415    60.281     0.150
     3.415   106.383     0.150
     3.366    54.781     0.150
     3.366    65.781     0.150
     3.366    53.586     0.150
     3.366    60.781     0.150
     3.366    92.984     0.150
     3.366   103.586     0.150
     3.730    70.180     0.150
     3.730    66.281     0.150
     3.730   113.883     0.150
     3.937    76.180     0.150
     3.937    62.984     0.150
     3.937    72.086     0.150
     3.937   119.781     0.150
     4.088   123.680     0.150
     4.341    65.281     0.150
     4.341    77.586     0.150
     4.341   115.180     0.150
     4.341   134.086     0.150
     4.343   136.281     0.150
     4.343    69.484     0.150
     4.343   125.680     0.150
     4.343    66.883     0.150
     4.343    77.484     0.150
     4.343   136.281     0.150
     4.855   135.086     0.150
     4.855   157.180     0.150
     4.855    85.484     0.150
     5.299    81.484     0.150
     5.299    89.586     0.150
     5.299   102.180     0.150
     5.299   159.383     0.150
     5.299    81.484     0.150
     5.516    81.586     0.150
     5.516    97.484     0.150
     5.516   143.781     0.150
     5.516   169.180     0.150
     5.507    85.586     0.150
     5.507    85.484     0.150
     5.507   104.586     0.150
     6.682   206.586     0.150
     6.682    95.781     0.150
     6.682   107.484     0.150
     6.682   115.680     0.150
     6.682   122.086     0.150
     6.682   167.984     0.150
     6.682   122.180     0.150
     6.682   206.586     0.150
     6.886   211.484     0.150
     6.886   122.680     0.150
     6.886   193.883     0.150
     6.886   218.680     0.150
     6.886   100.781     0.150
     6.886   122.586     0.150
     6.886   177.883     0.150
     6.886   211.484     0.150
     7.532   166.484     0.150
     7.532   187.781     0.150
     8.130   231.680     0.150
    17.968   255.680     0.150
    17.968   255.727     0.150
    18.498   260.586     0.150
    18.584   260.617     0.150
    22.665   306.781     0.150
    22.665   306.828     0.150
     0.637    12.477     0.150
     0.637    12.477     0.150
     0.637    12.477     0.150
     0.637    21.273     0.150
     0.637    21.273     0.150
     0.984    17.672     0.150
     0.984    17.672     0.150
     0.984    23.477     0.150
     0.984    17.570     0.150
     0.984    30.672     0.150
     1.086    21.875     0.150
     1.389    44.672     0.150
     1.389    25.172     0.150
     1.389    25.172     0.150
     1.389    25.172     0.150
     1.389    25.172     0.150
     1.389    44.672     0.150
     1.505    27.570     0.150
     1.505    27.570     0.150
     1.505    28.773     0.150
     1.662    53.875     0.150
     1.662    57.070     0.150
     1.662    31.172     0.150
     2.246    37.570     0.150
     2.246    37.570     0.150
     2.246    37.570     0.150
     2.246    39.477     0.150
     2.246    39.477     0.150
     2.246    39.477     0.150
     2.246    71.773     0.150
     2.246    37.570     0.150
     2.246    39.570     0.150
     2.246    69.477     0.150
     2.571    42.773     0.150
     2.571    46.273     0.150
     2.571    78.977     0.150
     2.760    49.477     0.150
     2.760    84.172     0.150
     3.051    63.375     0.150
     3.051    47.977     0.150
     3.051    53.570     0.150
     3.051    83.672     0.150
     3.051    92.172     0.150
     3.341    52.375     0.150
     3.341    59.375     0.150
     3.341    91.070     0.150
     3.341   102.172     0.150
     3.363    53.070     0.150
     3.363    87.875     0.150
     3.363    52.977     0.150
     3.363    60.172     0.150
     3.363    92.477     0.150
     3.363   103.070     0.150
     3.419    59.375     0.150
     3.734    64.773     0.150
     3.734   114.773     0.150
     3.935    62.070     0.150
     3.935    70.977     0.150
     4.337    65.477     0.150
     4.337    80.977     0.150
     4.337   132.977     0.150
     4.337    65.477     0.150
     4.337    77.477     0.150
     4.337   115.477     0.150
     4.337   133.070     0.150
     4.340    84.570     0.150
     4.340   141.172     0.150
     4.340    66.977     0.150
     4.340    77.672     0.150
     4.340   135.375     0.150
     4.853    88.875     0.150
     4.853    76.172     0.150
     4.853    88.773     0.150
     4.853   128.375     0.150
     5.298    83.672     0.150
     5.298    89.672     0.150
     5.298   158.875     0.150
     5.298    81.570     0.150
     5.298    95.375     0.150
     5.502   101.273     0.150
     5.502   173.672     0.150
     5.520   183.570     0.150
     5.520    81.672     0.150
     5.520    97.477     0.150
     5.520   168.875     0.150
     6.685   121.672     0.150
     6.685   206.375     0.150
     6.685   107.070     0.150
     6.685   120.875     0.150
     6.685   168.070     0.150
     6.685   121.672     0.150
     6.685   206.375     0.150
     6.887   211.375     0.150
     6.887   123.477     0.150
     6.887   213.977     0.150
     6.887   100.570     0.150
     6.887   122.273     0.150
     6.887   177.070     0.150
     6.887   211.375     0.150
     7.535   136.773     0.150
     7.535   214.172     0.150
     8.128   134.570     0.150
     8.128   184.773     0.150
     8.278   249.477     0.150
     8.278   258.375     0.150
     0.137     3.941     0.150
     0.137     7.043     0.150
     0.137     3.941     0.150
     0.137     7.043     0.150
     0.782    15.641     0.150
     0.782    30.441     0.150
     1.313    23.742     0.150
     1.313    41.441     0.150
     1.313    23.742     0.150
     1.313    23.742     0.150
     1.313    41.441     0.150
     1.402    42.941     0.150
     1.402    24.543     0.150
     1.402    24.543     0.150
     1.402    42.941     0.150
     2.059    39.742     0.150
     2.059    64.242     0.150
     2.059    34.242     0.150
     2.059    34.242     0.150
     2.059    35.742     0.150
     2.059    64.242     0.150
     2.313    37.543     0.150
     2.313    37.543     0.150
     2.313    37.543     0.150
     2.313    40.344     0.150
     2.313    69.242     0.150
     2.269    46.941     0.150
     2.269    65.641     0.150
     2.269    77.742     0.150
     2.288    40.641     0.150
     2.288    37.344     0.150
     2.288    72.441     0.150
     2.288    37.344     0.150
     2.288    37.344     0.150
     2.288    40.641     0.150
     2.288    70.844     0.150
     2.656    47.742     0.150
     2.656    47.742     0.150
     2.656    83.141     0.150
     2.842    64.141     0.150
     2.842    50.141     0.150
     2.842    50.141     0.150
     2.842    87.441     0.150
     4.267    64.141     0.150
     4.267    75.742     0.150
     4.267   130.941     0.150
     4.378   131.641     0.150
     4.336    82.742     0.150
     4.336   115.641     0.150
     4.336   132.742     0.150
     4.336    64.242     0.150
     4.336    64.242     0.150
     4.336    76.141     0.150
     4.336   132.742     0.150
     4.740   144.543     0.150
     4.825   147.141     0.150
     5.232   161.441     0.150
     5.738   175.242     0.150
     5.738    86.043     0.150
     5.738   175.742     0.150
     5.738    86.141     0.150
     5.738    86.141     0.150
     5.738   102.941     0.150
     5.738   175.242     0.150
     5.788    97.242     0.150
     5.788   104.441     0.150
     5.788   177.141     0.150
     6.020   185.441     0.150
     6.020    87.242     0.150
     6.020   162.242     0.150
     6.020    87.242     0.150
     6.020   106.141     0.150
     6.020   185.441     0.150
     6.130   109.844     0.150
     6.130   189.742     0.150
     6.130    90.543     0.150
     6.130   109.844     0.150
     6.130   189.742     0.150
     6.120   111.141     0.150
     6.120    90.152     0.150
     6.120    99.723     0.150
     6.120   194.043     0.150
     6.280    92.582     0.150
     6.280   113.781     0.150
     7.643   237.184     0.150
    14.730   207.492     0.150
    18.824   257.914     0.150
    19.818   269.441     0.150
    23.320   308.074     0.150
    48.086   518.492     0.150
    79.272   727.566     0.150
     0.633    12.320     0.150
     0.633    21.320     0.150
     1.385    44.625     0.150
     1.385    25.023     0.150
     1.385    25.023     0.150
     1.385    44.625     0.150
     1.660    30.820     0.150
     1.660    53.523     0.150
     2.571    45.523     0.150
     2.571    45.523     0.150
     2.571    79.422     0.150
     2.756    49.625     0.150
     2.756    84.922     0.150
     3.052    54.219     0.150
     3.052    54.219     0.150
     3.052    83.820     0.150
     3.052    91.922     0.150
     3.346    60.820     0.150
     3.346   102.219     0.150
     3.931    61.023     0.150
     3.931    70.523     0.150
     5.267    94.320     0.150
     5.267   161.719     0.150
     5.294    89.820     0.150
     5.294   139.422     0.150
     5.294    81.219     0.150
     5.294    94.922     0.150
     5.294   139.422     0.150
     6.688   121.422     0.150
     6.688   207.125     0.150
     6.688   121.422     0.150
     6.688   207.125     0.150
     6.891   123.320     0.150
     6.891   210.820     0.150
     6.891   102.023     0.150
     6.891   124.625     0.150
     6.891   101.625     0.150
     6.891   123.320     0.150
     6.891   177.422     0.150
     6.891   210.820     0.150
     0.631    12.758     0.150
     0.631    12.758     0.150
     0.631    12.758     0.150
     0.631    21.359     0.150
     0.631    21.359     0.150
     0.983    17.758     0.150
     0.983    30.758     0.150
     1.390    45.258     0.150
     1.390    25.461     0.150
     1.390    45.258     0.150
     2.241    37.859     0.150
     2.241    37.859     0.150
     2.241    37.859     0.150
     2.241    39.859     0.150
     2.564    43.160     0.150
     2.564    46.461     0.150
     2.564    72.359     0.150
     2.564    79.961     0.150
     3.045    47.559     0.150
     3.045    47.559     0.150
     3.045    53.461     0.150
     3.045    92.359     0.150
     3.345    60.859     0.150
     3.345   102.758     0.150
     3.365    60.461     0.150
     3.365    53.359     0.150
     3.365    60.461     0.150
     3.365   103.559     0.150
     3.413    62.758     0.150
     3.413   107.059     0.150
     3.730    66.961     0.150
     3.730    67.059     0.150
     3.730   115.758     0.150
     3.936    76.559     0.150
     4.344    83.160     0.150
     4.344   134.160     0.150
     4.344    65.758     0.150
     4.344    77.859     0.150
     4.344   115.758     0.150
     4.344   134.160     0.150
     4.853   135.359     0.150
     4.853    85.758     0.150
     4.853   148.758     0.150
     5.297    90.160     0.150
     5.297   159.059     0.150
     6.682   120.559     0.150
     6.682   207.758     0.150
     6.682   120.559     0.150
     6.682   207.758     0.150
     6.887   124.059     0.150
     6.887   212.359     0.150
     6.887   114.559     0.150
     6.887   124.160     0.150
     6.887   100.859     0.150
     6.887   124.059     0.150
     6.887   212.359     0.150
     0.586    11.672     0.150
     0.586    11.672     0.150
     0.586    11.672     0.150
     0.586    19.672     0.150
     0.966    30.074     0.150
     0.966    17.375     0.150
     0.966    17.375     0.150
     0.966    17.375     0.150
     1.410    45.074     0.150
     1.410    25.574     0.150
     1.410    45.074     0.150
     1.714    31.973     0.150
     1.967    38.773     0.150
     1.967    64.773     0.150
     2.197    37.074     0.150
     2.197    38.875     0.150
     2.197    68.273     0.150
     2.197    37.074     0.150
     2.197    38.875     0.150
     2.197    68.273     0.150
     2.497    41.875     0.150
     2.497    49.273     0.150
     2.497    64.574     0.150
     2.671    43.773     0.150
     2.671    43.773     0.150
     2.671    55.375     0.150
     2.671    82.672     0.150
     2.671    85.473     0.150
     2.671    47.773     0.150
     2.671    82.574     0.150
     2.779    53.473     0.150
     2.779    44.973     0.150
     2.779    49.574     0.150
     2.779    85.672     0.150
     2.988    47.172     0.150
     2.988    53.172     0.150
     2.988    83.375     0.150
     2.988    92.172     0.150
     3.358    60.375     0.150
     3.358   105.172     0.150
     3.379    55.172     0.150
     3.379    95.973     0.150
     3.379    55.172     0.150
     3.379    62.172     0.150
     3.379   103.875     0.150
     3.390    56.273     0.150
     3.390    90.672     0.150
     3.390   104.773     0.150
     3.390    53.574     0.150
     3.390    60.074     0.150
     3.390   104.773     0.150
     3.950    61.473     0.150
     3.950    71.172     0.150
     3.950   120.273     0.150
     4.043    66.172     0.150
     4.383    67.973     0.150
     4.383    78.672     0.150
     4.383   136.672     0.150
     4.407    69.973     0.150
     4.407    84.273     0.150
     4.407    66.773     0.150
     4.407    78.574     0.150
     4.407   117.074     0.150
     4.407   135.574     0.150
     4.866   128.172     0.150
     4.866    74.973     0.150
     4.866   150.473     0.150
     4.866    74.973     0.150
     4.866   128.172     0.150
     4.866   150.473     0.150
     5.221    80.773     0.150
     5.221    85.672     0.150
     5.221   157.172     0.150
     5.294    81.473     0.150
     5.294    81.473     0.150
     5.294    90.375     0.150
     5.294   154.574     0.150
     5.460    88.273     0.150
     5.460   100.273     0.150
     5.460   167.672     0.150
     5.460    80.973     0.150
     5.460    95.672     0.150
     5.460   167.574     0.150
     5.578   101.473     0.150
     5.578   137.375     0.150
     5.578   180.473     0.150
     5.690   103.672     0.150
     5.690    85.914     0.150
     5.690   103.695     0.150
     5.690   151.395     0.150
     6.647   204.773     0.150
     6.647   156.973     0.150
     6.647   176.773     0.150
     6.647   118.273     0.150
     6.647   204.773     0.150
     6.878   124.375     0.150
    48.831   528.148     0.150
    59.623   604.691     0.150
    76.358   709.547     0.150
    79.824   729.094     0.150
     0.950    23.773     0.150
     0.950    34.672     0.150
     1.426    39.773     0.150
     1.726    55.273     0.150
     0.576    11.438     0.150
     0.576    11.438     0.150
     0.576    11.438     0.150
     0.576    19.638     0.150
     0.576    19.638     0.150
     0.976    29.638     0.150
     1.401    45.538     0.150
     1.401    25.238     0.150
     1.401    25.338     0.150
     1.401    45.538     0.150
     1.709    32.938     0.150
     1.709    56.438     0.150
     1.709    36.038     0.150
     1.709    32.938     0.150
     1.709    56.438     0.150
     1.964    38.238     0.150
     2.497    44.838     0.150
     2.497    49.338     0.150
     2.497    44.838     0.150
     2.497    78.238     0.150
     2.663    43.338     0.150
     2.663    82.338     0.150
     2.663    86.338     0.150
     2.663    43.338     0.150
     2.663    48.638     0.150
     2.663    82.338     0.150
     2.770    50.338     0.150
     2.770    85.538     0.150
     2.992    50.938     0.150
     2.992    50.938     0.150
     2.992    81.338     0.150
     2.992    90.138     0.150
     3.382    56.138     0.150
     3.382    64.138     0.150
     3.382   107.038     0.150
     3.382    52.338     0.150
     3.382    59.938     0.150
     3.382   104.538     0.150
     3.941    70.238     0.150
     4.856   135.738     0.150
     5.228    98.938     0.150
     5.284    81.338     0.150
     5.284    96.238     0.150
     5.284   162.638     0.150
     5.579    94.538     0.150
     5.579   103.638     0.150
     5.579   179.738     0.150
     6.888   124.038     0.150
     6.888   213.038     0.150
     6.888   124.238     0.150
     6.888   125.638     0.150
     6.888   102.038     0.150
     6.888   124.038     0.150
     6.888   178.838     0.150
     6.888   213.038     0.150
     0.595    11.717     0.150
     0.595    11.717     0.150
     0.965    30.117     0.150
     0.965    17.517     0.150
     0.965    17.517     0.150
     0.965    17.517     0.150
     0.965    19.017     0.150
     1.129    26.417     0.150
     1.129    42.017     0.150
     1.410    45.317     0.150
     1.410    25.617     0.150
     1.410    25.617     0.150
     1.410    25.617     0.150
     1.410    45.317     0.150
     1.709    30.817     0.150
     2.201    38.817     0.150
     2.201    42.617     0.150
     2.201    37.117     0.150
     2.201    39.117     0.150
     2.201    67.817     0.150
     2.506    42.117     0.150
     2.506    64.917     0.150
     2.506    77.017     0.150
     2.506    42.117     0.150
     2.506    45.317     0.150
     2.506    72.017     0.150
     2.506    76.917     0.150
     2.669    43.917     0.150
     2.669    43.917     0.150
     2.669    43.917     0.150
     2.669    47.817     0.150
     2.669    54.117     0.150
     2.779    49.417     0.150
     2.779    74.517     0.150
     2.779    44.617     0.150
     2.779    49.517     0.150
     2.779    86.517     0.150
     2.995    46.517     0.150
     2.995    52.617     0.150
     2.995    59.317     0.150
     2.995    46.517     0.150
     2.995    52.617     0.150
     2.995    92.117     0.150
     3.371    56.517     0.150
     3.371    87.217     0.150
     3.371   109.817     0.150
     3.371    56.517     0.150
     3.371    62.317     0.150
     3.371   105.817     0.150
     3.365   105.717     0.150
     3.365    61.617     0.150
     3.365   105.717     0.150
     3.389    53.617     0.150
     3.389    53.617     0.150
     3.389    53.617     0.150
     3.389    63.417     0.150
     3.389    98.017     0.150
     3.389   107.417     0.150
     3.951    66.317     0.150
     3.951    78.017     0.150
     3.951   112.017     0.150
     3.951    62.717     0.150
     3.951    70.817     0.150
     3.951   120.617     0.150
     4.047    79.117     0.150
     4.379    68.117     0.150
     4.379   137.617     0.150
     4.867   128.717     0.150
     4.867    96.217     0.150
     4.867    75.917     0.150
     4.867    89.417     0.150
     4.867   128.717     0.150
     4.867   150.617     0.150
     5.225    85.717     0.150
     5.298    81.517     0.150
     5.298   163.617     0.150
     5.298    81.517     0.150
     5.298    96.117     0.150
     5.298   140.917     0.150
     5.298   163.617     0.150
     5.569   102.217     0.150
     5.569   154.017     0.150
     5.681    85.837     0.150
     5.681   102.438     0.150
     6.877   123.717     0.150
     6.877   213.517     0.150
     6.877   124.617     0.150
     6.877   129.017     0.150
     6.877   101.317     0.150
     6.877   123.717     0.150
     6.877   178.417     0.150
     6.877   213.517     0.150
     8.703   239.117     0.150
    22.643   301.035     0.150
    28.356   358.217     0.150
    28.356   405.217     0.150
    28.356   648.117     0.150
    42.260   474.445     0.150
    48.838   530.717     0.150
    48.838   529.173     0.150
    50.912   548.017     0.150
    59.631   605.312     0.150
    76.347   709.289     0.150
    79.812   729.417     0.150
     0.199     3.992     0.150
     0.199     3.992     0.150
     0.588    19.789     0.150
     0.960    17.191     0.150
     0.960    17.191     0.150
     0.960    19.090     0.150
     0.960    34.391     0.150
     1.417    45.090     0.150
     1.417    25.492     0.150
     1.417    45.090     0.150
     1.417    25.492     0.150
     1.417    45.090     0.150
     1.722    32.090     0.150
     1.974    64.992     0.150
     2.190    36.992     0.150
     2.190    36.992     0.150
     2.190    36.992     0.150
     2.190    40.992     0.150
     2.490    44.691     0.150
     2.490    76.691     0.150
     2.490    41.090     0.150
     2.490    44.691     0.150
     2.490    70.891     0.150
     2.490    76.789     0.150
     2.678    55.691     0.150
     2.678    82.691     0.150
     2.678    43.891     0.150
     2.678    48.992     0.150
     2.678    82.691     0.150
     2.981    57.191     0.150
     2.981    46.691     0.150
     2.981    52.691     0.150
     2.981    83.090     0.150
     2.981    91.891     0.150
     3.377   107.590     0.150
     3.377    53.691     0.150
     3.377    60.590     0.150
     3.377   104.391     0.150
     3.397    53.691     0.150
     3.397    63.789     0.150
     3.957    62.391     0.150
     3.957    70.289     0.150
     3.957   119.992     0.150
     4.390   139.789     0.150
     4.409    66.492     0.150
     4.409    78.492     0.150
     4.409   116.992     0.150
     4.409   134.992     0.150
     4.872    71.789     0.150
     4.872   127.891     0.150
     4.872   160.391     0.150
     4.872    71.789     0.150
     4.872    84.590     0.150
     4.872   127.891     0.150
     4.872   147.992     0.150
     5.214   161.090     0.150
     5.214    75.289     0.150
     5.214   172.289     0.150
     5.214    92.191     0.150
     5.214   161.090     0.150
     5.300   161.691     0.150
     5.300    81.191     0.150
     5.300   176.891     0.150
     5.300    81.191     0.150
     5.300    95.789     0.150
     5.300   161.691     0.150
     5.452   167.590     0.150
     5.452    95.992     0.150
     5.452   140.992     0.150
     5.452   167.590     0.150
     6.640   119.590     0.150
     6.640   206.090     0.150
     6.640   119.289     0.150
     6.640   133.090     0.150
     6.640   185.691     0.150
     6.640   217.289     0.150
     6.640   119.590     0.150
     6.640   206.090     0.150
     6.873   102.191     0.150
     6.873   123.492     0.150
     6.873   211.090     0.150
     6.873   110.090     0.150
     6.873   123.492     0.150
     6.873   102.191     0.150
     6.873   123.492     0.150
     6.873   177.789     0.150
     6.873   211.090     0.150
     0.591    11.721     0.150
     0.591    11.721     0.150
     0.591    11.721     0.150
     1.411    44.721     0.150
     1.411    25.721     0.150
     1.411    44.721     0.150
     1.714    54.921     0.150
     2.500    42.921     0.150
     2.780    50.921     0.150
     2.780    85.821     0.150
     2.990    46.921     0.150
     3.360    74.721     0.150
     3.375    79.021     0.150
     3.391    52.321     0.150
     3.391    52.321     0.150
     3.952    62.021     0.150
     3.952    71.721     0.150
     3.952   120.421     0.150
     4.043   104.321     0.150
     4.383    74.921     0.150
     5.221    99.121     0.150
     5.221    92.421     0.150
     5.221   159.921     0.150
     5.297    97.421     0.150
     5.297   163.721     0.150
     5.297   141.021     0.150
     5.297    82.121     0.150
     5.297    97.421     0.150
     5.297   141.121     0.150
     5.297   163.721     0.150
     5.575   102.821     0.150
     6.876   103.121     0.150
     6.876   211.121     0.150
     6.876   103.121     0.150
     6.876   124.421     0.150
     6.876   210.621     0.150
     0.594    11.479     0.150
     0.594    11.479     0.150
     0.594    11.479     0.150
     0.594    19.479     0.150
     0.594    19.578     0.150
     1.415    45.279     0.150
     1.415    25.279     0.150
     1.415    25.279     0.150
     1.415    45.279     0.150
     1.717    32.879     0.150
     1.717    32.879     0.150
     1.717    55.279     0.150
     1.968    64.180     0.150
     2.194    36.979     0.150
     2.194    36.979     0.150
     2.194    39.078     0.150
     2.194    64.078     0.150
     2.194    67.680     0.150
     2.498    49.180     0.150
     2.987    55.578     0.150
     3.357   112.578     0.150
     3.690   121.779     0.150
     4.386    75.279     0.150
     4.872   128.180     0.150
     4.872   135.779     0.150
     4.872   162.078     0.150
     5.218    97.779     0.150
     5.218   130.078     0.150
     6.872   102.078     0.150
     6.872   124.479     0.150
     6.872   213.578     0.150
     6.872   179.680     0.150
     6.872   102.078     0.150
     6.872   124.479     0.150
     6.872   213.578     0.150
     0.651    12.555     0.150
     0.651    21.555     0.150
     0.651    21.555     0.150
     0.968    17.453     0.150
     0.968    17.355     0.150
     0.968    30.152     0.150
     1.099    26.152     0.150
     1.405    25.152     0.150
     1.405    43.652     0.150
     1.405    25.152     0.150
     1.405    44.754     0.150
     1.674    30.953     0.150
     1.674    53.152     0.150
     1.912    63.453     0.150
     2.234    37.254     0.150
     2.234    37.254     0.150
     2.234    37.254     0.150
     2.567    40.754     0.150
     3.042    47.355     0.150
     3.042    53.355     0.150
     3.042    83.652     0.150
     3.042    92.355     0.150
     3.410    62.652     0.150
     3.410   107.754     0.150
     3.720    57.355     0.150
     3.720    66.055     0.150
     3.720   101.152     0.150
     3.720   114.152     0.150
     3.952    84.254     0.150
     3.952    71.355     0.150
     3.952   120.152     0.150
     4.353    67.855     0.150
     5.251   162.754     0.150
     5.251   172.254     0.150
     5.251    92.254     0.150
     5.251   162.754     0.150
     5.315    96.355     0.150
     5.315   163.254     0.150
     5.315   136.652     0.150
     5.315    81.254     0.150
     5.315    96.355     0.150
     5.315   141.055     0.150
     5.315   163.254     0.150
     5.511   175.453     0.150
     6.671   206.055     0.150
     6.671   119.652     0.150
     6.671   121.355     0.150
     6.671   206.055     0.150
     6.870   210.355     0.150
     6.870   195.453     0.150
     6.870   100.254     0.150
     6.870   122.055     0.150
     6.870   177.555     0.150
     6.870   210.355     0.150
     0.532    10.682     0.150
     0.532    10.682     0.150
     0.532    23.283     0.150
     0.532    25.582     0.150
     0.532    10.682     0.150
     1.078    19.283     0.150
     1.078    33.182     0.150
     1.298    23.682     0.150
     1.298    23.682     0.150
     1.298    41.182     0.150
     1.611    30.482     0.150
     1.611    51.783     0.150
     2.573    42.582     0.150
     2.559    42.182     0.150
     2.559    45.982     0.150
     2.559    72.982     0.150
     2.559    78.482     0.150
     2.667    47.182     0.150
     2.667    81.582     0.150
     3.277    59.883     0.150
     3.277    52.283     0.150
     3.277    59.883     0.150
     3.277   100.082     0.150
     3.454    55.982     0.150
     3.454    55.982     0.150
     3.454    62.783     0.150
     3.454   106.682     0.150
     3.456    59.982     0.150
     3.456   107.883     0.150
     3.805    65.582     0.150
     3.805   116.082     0.150
     4.273    64.082     0.150
     4.273    64.082     0.150
     4.273    76.082     0.150
     4.273   133.783     0.150
     4.424    66.682     0.150
     4.424    66.682     0.150
     4.424    78.482     0.150
     4.424   117.182     0.150
     4.424   135.982     0.150
     4.755   158.283     0.150
     4.755    87.383     0.150
     4.755   144.482     0.150
     4.755    87.383     0.150
     4.755   126.682     0.150
     4.755   144.482     0.150
     5.190    87.783     0.150
     5.190    79.982     0.150
     5.190    79.982     0.150
     5.190    94.082     0.150
     5.190   157.982     0.150
     5.331    78.283     0.150
     5.331   165.982     0.150
     5.331    78.283     0.150
     5.331    94.283     0.150
     5.331   165.982     0.150
     6.758   121.082     0.150
     6.758   208.883     0.150
     6.758   121.082     0.150
     6.758   208.883     0.150
     6.988   125.582     0.150
     6.988   125.383     0.150
     6.988   215.383     0.150
     6.988   103.182     0.150
     6.988   125.383     0.150
     6.988   180.783     0.150
     6.988   215.383     0.150
     0.632    12.625     0.150
     0.632    12.625     0.150
     0.632    12.727     0.150
     0.632    21.531     0.150
     0.972    17.625     0.150
     0.972    17.625     0.150
     0.972    34.930     0.150
     0.972    17.625     0.150
     0.972    17.625     0.150
     0.972    30.531     0.150
     1.401    25.531     0.150
     1.401    25.531     0.150
     1.401    25.531     0.150
     1.401    25.531     0.150
     1.401    44.328     0.150
     1.524    28.125     0.150
     1.524    28.125     0.150
     1.524    54.625     0.150
     1.680    32.727     0.150
     2.229    37.625     0.150
     2.229    37.625     0.150
     2.229    37.625     0.150
     2.229    39.625     0.150
     2.229    37.625     0.150
     2.229    39.625     0.150
     2.229    69.227     0.150
     2.552    42.430     0.150
     2.653    53.031     0.150
     2.653    82.125     0.150
     3.377    98.227     0.150
     3.377    59.930     0.150
     3.377   103.031     0.150
     3.377    53.352     0.150
     3.377    59.898     0.150
     3.377   103.016     0.150
     3.718    97.531     0.150
     3.946   127.430     0.150
     3.946    73.031     0.150
     4.348    65.531     0.150
     4.356   136.930     0.150
     4.356    67.531     0.150
     4.864   135.727     0.150
     4.864   135.125     0.150
     5.305   164.227     0.150
     5.305   164.125     0.150
     5.502   148.430     0.150
     5.502   186.531     0.150
     5.502   170.031     0.150
     5.635    85.125     0.150
     5.635   152.328     0.150
     6.669   107.828     0.150
     6.669   120.227     0.150
     6.669   122.031     0.150
     6.669   207.430     0.150
     6.877   123.328     0.150
     6.877   196.328     0.150
     6.877   211.625     0.150
     8.130   201.125     0.150
     8.130   250.227     0.150
     8.130   116.156     0.150
     8.264   256.227     0.150
    10.049   139.625     0.150
    12.634   190.125     0.150
    12.634   192.125     0.150
    14.285   202.047     0.150
    14.880   382.227     0.150
    15.113     3.398     0.150
    15.113     7.000     0.150
    15.113   389.625     0.150
    15.113   394.328     0.150
    15.113   406.227     0.150
    16.659     4.703     0.150
    16.659     8.500     0.150
    16.659   252.625     0.150
    16.659   421.930     0.150
    16.659   441.930     0.150
    16.659   529.930     0.150
    17.522   250.227     0.150
    17.522     4.000     0.150
    17.522     6.500     0.150
    17.522   445.125     0.150
    17.976   572.656     0.150
    17.976   250.211     0.150
    17.976   572.656     0.150
    18.503   253.938     0.150
    18.503   588.797     0.150
    18.588   588.797     0.150
    20.804   282.078     0.150
    22.641   301.125     0.150
    22.641     5.203     0.150
    22.641     8.500     0.150
    22.641    28.500     0.150
    22.641   543.328     0.150
    22.667   300.328     0.150
    24.085   315.766     0.150
    24.903   323.102     0.150
    25.311   327.328     0.150
    25.311   327.367     0.150
    26.050   342.625     0.150
    26.050    45.500     0.150
    26.050   625.125     0.150
    26.050   688.625     0.150
    26.987   343.148     0.150
    27.179   404.328     0.150
    28.389   400.430     0.150
    30.585   556.625     0.150
    35.561   418.125     0.150
    39.234   446.930     0.150
    42.304   471.930     0.150
    43.048   478.727     0.150
    45.537   901.031     0.150
    46.495   506.328     0.150
    48.564   521.625     0.150
    48.873   525.031     0.150
    50.526   538.719     0.150
    50.462   540.031     0.150
    50.462   540.031     0.150
    50.460   538.625     0.150
    50.778   541.430     0.150
    50.893   542.828     0.150
    50.938   541.227     0.150
    51.138   542.125     0.150
    51.440   547.430     0.150
    53.154   558.000     0.150
    53.153   558.930     0.150
    54.079   564.828     0.150
    55.292   574.930     0.150
    55.292   580.227     0.150
    59.673   602.125     0.150
    76.296   708.625     0.150
    79.021   724.219     0.150
    79.762   728.227     0.150
   145.877  1175.719     0.150
     0.627    12.305     0.150
     0.627    12.305     0.150
     0.627    12.305     0.150
     0.627    12.305     0.150
     0.627    21.305     0.150
     0.979    19.906     0.150
     0.979    34.605     0.150
     0.979    17.508     0.150
     0.979    17.508     0.150
     0.979    44.008     0.150
     1.394    25.207     0.150
     1.394    25.207     0.150
     1.394    25.207     0.150
     1.394    25.207     0.150
     1.394    44.008     0.150
     1.520    27.605     0.150
     1.520    27.605     0.150
     1.520    30.707     0.150
     1.673    31.305     0.150
     1.917    34.707     0.150
     1.917    34.707     0.150
     2.235    37.305     0.150
     2.235    37.305     0.150
     2.235    39.406     0.150
     2.235    64.105     0.150
     2.235    68.605     0.150
     2.645    47.406     0.150
     2.764    85.207     0.150
     2.764    44.406     0.150
     2.764    49.508     0.150
     2.764    85.207     0.150
     3.038    62.207     0.150
     3.038    48.508     0.150
     3.348    55.305     0.150
     3.348   107.008     0.150
     3.348    51.406     0.150
     3.348    61.008     0.150
     3.369    65.207     0.150
     3.369   104.090     0.150
     3.369    52.848     0.150
     3.369   103.984     0.150
     3.725    57.906     0.150
     3.725    57.906     0.150
     3.939    58.207     0.150
     3.939    77.008     0.150
     4.351    65.207     0.150
     4.351    65.207     0.150
     4.351    82.305     0.150
     4.351    65.207     0.150
     4.349    65.508     0.150
     4.856    78.605     0.150
     4.856    75.805     0.150
     5.255   123.008     0.150
     5.255    78.605     0.150
     5.255   163.207     0.150
     5.298    81.406     0.150
     5.298    81.406     0.150
     5.298    89.508     0.150
     5.298   143.605     0.150
     5.298   163.605     0.150
     5.298   163.305     0.150
     5.508   169.305     0.150
     5.518    85.805     0.150
     5.518   100.605     0.150
     5.518   108.305     0.150
     5.518    85.805     0.150
     5.631    84.805     0.150
     5.631   101.906     0.150
     5.631   151.906     0.150
     6.677   107.707     0.150
     6.677   207.805     0.150
     6.884   123.906     0.150
     6.884   191.207     0.150
     6.884   212.207     0.150
     7.527   136.508     0.150
     7.527   150.406     0.150
     8.136   115.316     0.150
    12.633   195.906     0.150
    12.633   318.906     0.150
    12.633   337.207     0.150
    14.040   429.605     0.150
    14.261   198.508     0.150
    14.267   359.207     0.150
    14.286   202.027     0.150
    15.106   223.105     0.150
    15.108   216.406     0.150
    15.108     2.699     0.150
    15.108   386.906     0.150
    15.108   391.906     0.150
    15.108   403.906     0.150
    16.651     4.801     0.150
    16.651     7.000     0.150
    18.134   256.707     0.150
    18.496   255.305     0.150
    19.258   269.207     0.150
    20.808   282.848     0.150
    20.808   665.910     0.150
    22.638   300.707     0.150
    22.638     3.000     0.150
    22.661   301.605     0.150
    24.077   315.867     0.150
    24.624   775.355     0.150
    24.896   791.492     0.150
    24.896   791.496     0.150
    25.303   328.316     0.150
    26.979   344.707     0.150
    27.174   348.805     0.150
    28.383   400.508     0.150
    28.383   415.605     0.150
    28.383   719.008     0.150
    28.470     3.500     0.150
    28.470     5.301     0.150
    28.470   641.707     0.150
    30.764   375.406     0.150
    42.301   473.508     0.150
    46.490   509.605     0.150
    48.494   523.078     0.150
    48.879   526.105     0.150
    59.678   602.605     0.150
    76.291   712.008     0.150
    76.291   712.016     0.150
    76.297   708.605     0.150
    76.391   710.426     0.150
    79.762   728.105     0.150
     0.502    10.383     0.150
     0.502    10.383     0.150
     0.502    10.383     0.150
     0.502    17.383     0.150
     1.018    38.281     0.150
     1.099    21.484     0.150
     1.099    37.281     0.150
     1.278    24.586     0.150
     1.278    23.281     0.150
     1.278    42.086     0.150
     1.627    52.688     0.150
     3.089    47.188     0.150
     3.817    66.781     0.150
     4.160   132.188     0.150
     4.733   130.586     0.150
     5.164   140.188     0.150
     5.164   156.281     0.150
     5.164    94.281     0.150
     5.164   159.781     0.150
     5.562   173.984     0.150
     7.011   101.086     0.150
     7.011   217.086     0.150
     0.834    31.141     0.150
     0.892    33.445     0.150
     1.795    32.242     0.150
     1.795    55.641     0.150
     2.674    51.141     0.150
     2.692    85.445     0.150
     3.338    63.844     0.150
     0.629    12.180     0.150
     0.629    12.180     0.150
     0.629    26.582     0.150
     0.629    21.180     0.150
     0.998    19.980     0.150
     0.998    17.781     0.150
     1.074    40.180     0.150
     1.375    25.383     0.150
     1.375    44.383     0.150
     1.497    30.480     0.150
     1.651    53.082     0.150
     1.651    30.883     0.150
     1.651    53.281     0.150
     1.690    49.883     0.150
     1.690    61.180     0.150
     1.894    31.781     0.150
     2.258    72.883     0.150
     2.258    39.680     0.150
     2.578    42.883     0.150
     2.625    40.480     0.150
     3.061    84.480     0.150
     3.352    63.082     0.150
     3.429    64.480     0.150
     3.350    56.980     0.150
     3.350   107.582     0.150
     3.350    96.680     0.150
     3.746   112.980     0.150
     4.103    69.883     0.150
     4.839   125.480     0.150
     5.277    86.383     0.150
     5.277    98.281     0.150
     5.277   141.680     0.150
     5.285   162.680     0.150
     5.285   161.980     0.150
     5.496    85.781     0.150
     5.531    93.781     0.150
     6.901   219.082     0.150
     6.901   211.680     0.150
     0.515    10.268     0.150
     0.515    10.268     0.150
     0.973    18.467     0.150
     0.973    33.768     0.150
     2.924    57.666     0.150
     3.664   101.967     0.150
     0.979    18.809     0.150
     1.394    25.207     0.150
     1.394    44.508     0.150
     1.676    53.609     0.150
     1.676    54.109     0.150
     2.232    36.809     0.150
     2.232    39.109     0.150
     2.253    43.906     0.150
     2.646    49.109     0.150
     2.764    49.906     0.150
     5.253   162.008     0.150
     5.296   183.809     0.150
     6.675   119.906     0.150
     6.675   119.609     0.150
     6.675   206.109     0.150
     6.885   100.008     0.150
     6.885   210.906     0.150
     8.270   255.008     0.150
     0.592    10.555     0.150
     0.592    10.555     0.150
     0.592    10.555     0.150
     0.592    18.258     0.150
     0.667    15.758     0.150
     0.958    34.461     0.150
     1.212    24.359     0.150
     1.255    43.156     0.150
     1.419    32.359     0.150
     1.545    51.758     0.150
     2.329    45.055     0.150
     2.329    58.258     0.150
     2.455    39.156     0.150
     2.885    91.859     0.150
     3.434    71.961     0.150
     3.508    63.055     0.150
     3.808    96.859     0.150
     3.911    59.555     0.150
     4.512   143.156     0.150
     4.904    80.656     0.150
     4.904    83.555     0.150
     5.237    95.258     0.150
     5.237   150.258     0.150
     5.237   166.258     0.150
     6.859   222.258     0.150
     7.310   130.258     0.150
     7.310   224.758     0.150
     0.699    26.105     0.150
     0.764    24.305     0.150
     0.960    18.305     0.150
     0.960    18.305     0.150
     0.960    31.207     0.150
     1.285    42.105     0.150
     1.551    49.008     0.150
     1.659    52.707     0.150
     1.659   109.207     0.150
     1.826    58.008     0.150
     1.898    63.805     0.150
     1.999    42.008     0.150
     2.122    38.906     0.150
     2.617    50.207     0.150
     2.998    44.805     0.150
     2.998    98.105     0.150
     3.027    93.207     0.150
     3.353    79.105     0.150
     4.209    66.305     0.150
     4.525    68.906     0.150
     4.525   140.805     0.150
     4.525   144.805     0.150
     5.098   156.805     0.150
     5.130   158.207     0.150
     5.447   167.305     0.150
     5.467    85.508     0.150
     5.467   169.008     0.150
     6.608   104.508     0.150
     6.608   202.805     0.150
     6.608   213.707     0.150
     6.608    98.305     0.150
     6.608   118.707     0.150
     6.608   202.605     0.150
     7.560   233.805     0.150
     0.620    12.391     0.150
     0.620    12.391     0.150
     0.620    25.592     0.150
     0.620    19.492     0.150
     0.632    18.391     0.150
     0.933    19.191     0.150
     0.933    17.291     0.150
     0.933    30.691     0.150
     1.219    22.691     0.150
     1.219    39.492     0.150
     1.448    28.891     0.150
     1.448    45.291     0.150
     1.509    27.592     0.150
     1.509    27.592     0.150
     1.509    49.891     0.150
     1.777    56.592     0.150
     2.701    86.291     0.150
     2.701    43.092     0.150
     2.701    47.191     0.150
     2.921    96.391     0.150
     2.921    50.791     0.150
     2.921    89.291     0.150
     3.483    51.391     0.150
     3.844   117.092     0.150
     3.844   135.592     0.150
     3.878    62.691     0.150
     3.878   123.791     0.150
     4.198    58.691     0.150
     4.198   132.391     0.150
     4.395    70.891     0.150
     4.395    83.592     0.150
     4.404    64.992     0.150
     4.404   139.191     0.150
     4.404   147.791     0.150
     4.886    83.691     0.150
     4.886   151.291     0.150
     5.203   168.191     0.150
     5.944   107.191     0.150
     7.334   234.592     0.150
     7.334   104.691     0.150
     7.334   225.592     0.150
     0.426    14.023     0.150
     0.918    34.324     0.150
     1.149    20.324     0.150
     1.149    20.324     0.150
     1.233    39.621     0.150
     1.456    35.523     0.150
     2.031    59.922     0.150
     2.429    50.723     0.150
     2.429    35.324     0.150
     2.429    35.324     0.150
     2.630    51.824     0.150
     2.630    43.121     0.150
     2.630    43.121     0.150
     3.181    51.922     0.150
     3.181    50.121     0.150
     3.181    50.121     0.150
     3.132    52.023     0.150
     3.132    49.473     0.150
     3.132    49.523     0.150
     4.148   130.523     0.150
     4.272   136.023     0.150
     4.515    94.223     0.150
     4.515    81.621     0.150
     4.515   118.621     0.150
     4.515   139.422     0.150
     4.599    87.324     0.150
     5.029    84.223     0.150
     5.462   168.621     0.150
     5.480    83.461     0.150
     5.480    78.621     0.150
     5.655   102.121     0.150
     6.893   124.922     0.150
     7.146   110.723     0.150
     7.146   128.922     0.150
     7.146   103.621     0.150
     7.146   220.121     0.150
     7.279   131.723     0.150
     7.279   200.422     0.150
     7.753   239.922     0.150
     8.382   260.121     0.150
    14.384   206.023     0.150
    14.384   367.223     0.150
    14.991     4.500     0.150
    14.991     7.000     0.150
    14.991   386.023     0.150
    14.991   390.723     0.150
    14.991   403.223     0.150
    16.565   235.023     0.150
    16.565     6.500     0.150
    17.464     4.301     0.150
    17.464     8.000     0.150
    17.464   261.023     0.150
    17.704   247.324     0.150
    18.312   565.617     0.150
    22.632   303.023     0.150
    25.788   337.223     0.150
    26.712   340.422     0.150
    26.712   340.723     0.150
    30.759   371.922     0.150
    46.256   506.621     0.150
    55.137   571.824     0.150
    74.805   699.324     0.150
    79.873   724.176     0.150
     1.180    25.411     0.150
     1.405    44.611     0.150
     1.507    30.711     0.150
     1.714    56.011     0.150
     1.909    63.511     0.150
     2.236    42.011     0.150
     2.571    49.911     0.150
     2.652    42.011     0.150
     2.652    69.111     0.150
     2.652    84.911     0.150
     2.906    92.111     0.150
     4.351    85.911     0.150
     4.351    99.411     0.150
     4.351   132.611     0.150
     4.870    71.311     0.150
     4.870    78.011     0.150
     5.253    76.611     0.150
     5.253    97.911     0.150
     5.253   166.611     0.150
     5.316    89.011     0.150
     5.316    81.611     0.150
     5.501   160.111     0.150
     5.501   175.111     0.150
     6.673   119.811     0.150
     6.870   123.511     0.150
     6.870   212.611     0.150
     7.303   131.611     0.150
     7.303   231.811     0.150
     7.568   240.111     0.150
     0.572    12.141     0.150
     0.644    13.242     0.150
     0.985    33.742     0.150
     0.985    35.242     0.150
     1.389    25.039     0.150
     1.389    44.039     0.150
     1.658    47.242     0.150
     1.699    55.641     0.150
     1.699    57.141     0.150
     2.250    39.539     0.150
     2.890    75.844     0.150
     3.057    57.141     0.150
     3.057    60.844     0.150
     3.057    53.641     0.150
     3.362    54.344     0.150
     3.362    57.539     0.150
     3.362   106.938     0.150
     4.095   134.539     0.150
     4.329    67.344     0.150
     4.329   132.938     0.150
     4.853    79.938     0.150
     4.853   134.844     0.150
     4.853   159.641     0.150
     5.300    89.438     0.150
     5.300    96.938     0.150
     5.300    96.438     0.150
     5.495   174.039     0.150
     6.886   102.039     0.150
     6.886   102.844     0.150
     6.886   124.344     0.150
     6.886   211.938     0.150
     7.286   198.742     0.150
     7.286   230.742     0.150
     7.552   215.438     0.150
     7.552   233.539     0.150
     0.646    13.400     0.150
     0.980    22.699     0.150
     0.980    35.100     0.150
     0.980    31.100     0.150
     1.393    25.100     0.150
     1.393    44.500     0.150
     1.662    46.600     0.150
     1.703    57.000     0.150
     1.901    67.000     0.150
     2.246    46.000     0.150
     2.575    50.299     0.150
     2.575    46.100     0.150
     2.575    79.900     0.150
     3.053    57.699     0.150
     3.053    47.699     0.150
     3.333    54.000     0.150
     3.333   108.900     0.150
     3.421    73.400     0.150
     3.421   112.600     0.150
     3.366    60.699     0.150
     3.732    62.600     0.150
     3.940   111.100     0.150
     3.940   122.400     0.150
     4.328    65.500     0.150
     4.328   133.100     0.150
     4.341   136.600     0.150
     4.858    75.699     0.150
     5.304    89.500     0.150
     5.304   164.500     0.150
     5.522    85.699     0.150
     5.522   174.199     0.150
     5.522   170.600     0.150
     5.497   174.000     0.150
     6.683   107.699     0.150
     6.683   188.400     0.150
     6.683   207.799     0.150
     6.882   123.900     0.150
     6.882   219.100     0.150
     6.882   212.500     0.150
     7.291   124.000     0.150
     7.291   226.000     0.150
     7.291   236.600     0.150
     7.556   135.699     0.150
     7.556   233.799     0.150
     8.119   272.199     0.150
     8.119   118.600     0.150
    14.052   433.600     0.150
    48.893   526.100     0.150
     0.651    12.945     0.150
     0.651    12.945     0.150
     0.651    27.844     0.150
     0.651    12.945     0.150
     0.985    23.242     0.150
     0.985    35.445     0.150
     0.985    17.445     0.150
     1.164    25.844     0.150
     1.389    24.742     0.150
     1.389    43.242     0.150
     1.697    55.742     0.150
     1.893    34.344     0.150
     2.253    37.445     0.150
     2.585    42.344     0.150
     2.585    45.844     0.150
     3.062    47.047     0.150
     3.062    53.844     0.150
     3.329   101.742     0.150
     4.320    65.148     0.150
     5.530   170.445     0.150
     6.885   212.047     0.150
     0.840    31.250     0.150
     0.840    16.250     0.150
     1.759    54.945     0.150
     1.759    55.148     0.150
     1.871    35.445     0.150
     1.871    31.750     0.150
     2.624    48.344     0.150
     3.353    64.148     0.150
     5.212   156.047     0.150
     6.304   112.750     0.150
     6.538   117.148     0.150
     0.723    14.338     0.150
     0.723    14.338     0.150
     0.723    14.338     0.150
     0.723    23.738     0.150
     0.857    15.439     0.150
     0.857    15.439     0.150
     0.857    30.238     0.150
     0.857    15.439     0.150
     1.517    33.238     0.150
     1.517    47.738     0.150
     1.774    56.238     0.150
     1.999    35.639     0.150
     1.999    42.039     0.150
     2.134    40.838     0.150
     2.134    34.738     0.150
     2.958    48.439     0.150
     3.614   113.939     0.150
     4.458   138.439     0.150
     4.981    72.639     0.150
     4.981   153.238     0.150
     5.146    81.338     0.150
     5.146   101.738     0.150
     5.146   160.238     0.150
     5.423   166.238     0.150
     5.423    89.238     0.150
     5.423   169.039     0.150
     5.563   100.738     0.150
     5.563   173.738     0.150
     6.564   118.838     0.150
     6.564   203.238     0.150
     6.564   119.639     0.150
     6.564   203.439     0.150
     6.759   196.439     0.150
     6.759   210.539     0.150
     1.107    21.727     0.150
     2.338    56.023     0.150
     4.034    81.625     0.150
     4.315    70.328     0.150
     4.315   137.125     0.150
     4.578   145.523     0.150
     5.058   151.523     0.150
     5.570    86.930     0.150
     5.570   188.828     0.150
     6.990   110.727     0.150
     6.990   190.828     0.150
     7.009   112.125     0.150
     7.009   122.523     0.150
     7.009   223.328     0.150
     7.318   118.828     0.150
     7.318   130.023     0.150
     7.318   229.828     0.150
     0.637    12.840     0.150
     0.637    12.840     0.150
     0.900    18.539     0.150
     0.900    32.441     0.150
     1.106    21.539     0.150
     1.616    32.141     0.150
     1.616    52.738     0.150
     2.827    97.941     0.150
     3.343    55.340     0.150
     4.034   127.941     0.150
     4.577    76.039     0.150
     4.577   126.141     0.150
     5.815   186.039     0.150
     6.990   193.441     0.150
     7.008   106.840     0.150
     7.008   218.840     0.150
     7.161   106.238     0.150
     7.161   115.941     0.150
     8.524   251.141     0.150
     8.524   257.738     0.150
     0.331     9.923     0.150
     1.141    20.122     0.150
     1.141    36.122     0.150
     1.264    39.923     0.150
     1.264    22.522     0.150
     1.264    39.423     0.150
     1.545    49.622     0.150
     1.544    29.423     0.150
     1.544    51.723     0.150
     2.423    55.923     0.150
     2.574    69.923     0.150
     2.667    51.423     0.150
     3.147    52.622     0.150
     3.147    52.622     0.150
     3.524    68.723     0.150
     3.680   118.822     0.150
     3.661    69.322     0.150
     4.611    71.522     0.150
     4.611    81.622     0.150
     4.611   142.223     0.150
     4.983    80.522     0.150
     5.455    84.822     0.150
     5.455   167.122     0.150
     5.552   166.723     0.150
     5.622   104.223     0.150
     5.640   101.982     0.150
     7.007   127.022     0.150
     7.181   109.423     0.150
     7.181   221.423     0.150
    13.706   438.930     0.150
    17.666   564.099     0.150
    18.253   580.683     0.150
    48.990   523.426     0.150
     0.719    12.914     0.150
     0.719    12.914     0.150
     0.719    12.914     0.150
     0.719    22.711     0.150
     0.813    16.312     0.150
     0.788    16.812     0.150
     0.788    29.312     0.150
     0.788    15.711     0.150
     1.350    51.312     0.150
     1.654    28.117     0.150
     1.654    52.211     0.150
     1.921    33.211     0.150
     1.921    61.211     0.150
     2.141    65.211     0.150
     2.391    72.617     0.150
     2.820    57.016     0.150
     2.820    93.516     0.150
     2.820    44.711     0.150
     2.820    52.117     0.150
     3.160    58.117     0.150
     3.631    88.711     0.150
     3.631   114.914     0.150
     3.631    55.312     0.150
     3.631    65.117     0.150
     3.631   112.211     0.150
     3.833    60.117     0.150
     3.833    69.914     0.150
     3.833   119.414     0.150
     4.197    70.617     0.150
     4.197   133.812     0.150
     4.197    63.914     0.150
     4.321    72.312     0.150
     4.605    78.516     0.150
     4.605   149.711     0.150
     4.605    69.617     0.150
     4.605   143.711     0.150
     5.000    96.117     0.150
     5.114    68.812     0.150
     5.114   157.711     0.150
     5.114   167.016     0.150
     5.282    83.617     0.150
     5.282    98.117     0.150
     5.540    89.312     0.150
     5.540    83.117     0.150
     5.540   147.516     0.150
     5.540   170.211     0.150
     5.810   106.594     0.150
     5.810   106.602     0.150
     6.370    97.414     0.150
     6.370   102.016     0.150
     6.370   176.711     0.150
     6.370   195.414     0.150
     6.418   102.914     0.150
     6.418   116.117     0.150
     6.418   115.211     0.150
     6.418   195.312     0.150
     6.630   104.211     0.150
     6.630   118.617     0.150
     6.630   210.617     0.150
     6.630   118.617     0.150
     6.630   203.711     0.150
     7.267   125.711     0.150
     7.267   134.117     0.150
     7.267   196.711     0.150
     7.267   231.617     0.150
     7.786   116.414     0.150
     7.786   125.711     0.150
     7.786   141.016     0.150
     7.786   243.211     0.150
     8.946   150.016     0.150
     8.946   208.117     0.150
     8.946   280.211     0.150
     9.648   144.914     0.150
     9.648   272.812     0.150
    10.939   166.711     0.150
    10.939   282.414     0.150
    14.241   204.195     0.150
    14.242   204.188     0.150
    18.219   252.016     0.150
    18.396   255.914     0.150
    18.805   587.039     0.150
    20.281   273.016     0.150
    22.907   304.914     0.150
    42.380   475.516     0.150
    47.694   509.984     0.150
     0.788    16.408     0.150
     0.788    29.308     0.150
     0.903    32.208     0.150
     1.475    48.908     0.150
     1.743    56.508     0.150
     2.137    68.408     0.150
     2.272    29.608     0.150
     2.272    58.608     0.150
     2.955    83.308     0.150
     2.955    94.908     0.150
     3.664   118.508     0.150
     4.374    72.608     0.150
     4.374   122.608     0.150
     4.391    70.208     0.150
     4.862    78.808     0.150
     4.862   121.408     0.150
     4.862   131.308     0.150
     5.762   184.308     0.150
     5.762   191.808     0.150
     7.125   198.308     0.150
     7.185   133.208     0.150
     7.185   231.808     0.150
     7.364   125.808     0.150
     7.364   131.508     0.150
     0.608    12.523     0.150
     0.608    12.523     0.150
     0.999    34.023     0.150
     1.181    28.324     0.150
     1.373    24.125     0.150
     1.373    24.125     0.150
     1.373    30.426     0.150
     1.514    33.723     0.150
     1.514    50.926     0.150
     1.659    37.023     0.150
     1.659    52.324     0.150
     1.907    32.625     0.150
     1.907    39.625     0.150
     2.250    44.223     0.150
     2.250    73.523     0.150
     2.627    51.324     0.150
     3.048    61.125     0.150
     4.835    80.125     0.150
     4.835   124.523     0.150
     4.835   158.324     0.150
     5.276    86.523     0.150
     6.906   104.926     0.150
     7.527    98.426     0.150
     7.527   119.223     0.150
     1.001    33.594     0.150
     1.517    33.895     0.150
     3.046    58.496     0.150
     1.136    41.523     0.150
     1.225    26.320     0.150
     1.553    31.523     0.150
     1.712    54.320     0.150
     1.953    35.621     0.150
     2.292    46.820     0.150
     2.685    52.121     0.150
     2.803    91.121     0.150
     3.326    64.820     0.150
     4.351    83.223     0.150
     4.894    82.621     0.150
     4.894   148.223     0.150
     6.636   164.723     0.150
     7.582   136.422     0.150
     0.641    18.883     0.150
     0.641    22.781     0.150
     0.986    35.184     0.150
     1.170    25.082     0.150
     1.387    47.883     0.150
     1.499    27.383     0.150
     1.499    27.383     0.150
     1.499    30.281     0.150
     2.250    71.781     0.150
     2.241    73.684     0.150
     2.758    52.684     0.150
     3.056    56.781     0.150
     3.338    54.480     0.150
     3.338   108.883     0.150
     3.361    56.383     0.150
     3.424   110.480     0.150
     3.737    72.980     0.150
     3.934    64.883     0.150
     4.096   135.383     0.150
     4.336   132.883     0.150
     4.852    58.184     0.150
     4.852   154.082     0.150
     5.268    38.383     0.150
     5.268   171.480     0.150
     5.298    89.082     0.150
     5.526   175.281     0.150
     6.888   103.582     0.150
     7.550   121.781     0.150
     7.550   187.082     0.150
    10.065   301.480     0.150
    10.065   324.082     0.150
     0.638    18.871     0.150
     0.990    20.070     0.150
     0.990    23.570     0.150
     1.168    23.172     0.150
     1.383    26.070     0.150
     1.613    31.371     0.150
     1.895    35.672     0.150
     1.895    38.070     0.150
     2.579    50.570     0.150
     2.579    54.871     0.150
     3.059    57.770     0.150
     3.342   106.172     0.150
     3.741   105.770     0.150
     3.930    65.770     0.150
     4.333    81.270     0.150
     4.332   103.172     0.150
     4.848    80.770     0.150
     5.294    89.070     0.150
     5.294   141.871     0.150
     6.692   208.672     0.150
     6.892   107.371     0.150
     8.285   258.172     0.150
     0.698    25.590     0.150
     0.922    18.791     0.150
     1.352    28.490     0.150
     1.352    31.690     0.150
     1.375    29.990     0.150
     1.438    29.190     0.150
     1.487    47.190     0.150
     1.720    35.391     0.150
     1.720    51.090     0.150
     1.827    40.590     0.150
     2.450    48.791     0.150
     2.633    51.090     0.150
     2.904    46.935     0.150
     3.338   108.291     0.150
     3.436   109.090     0.150
     3.958   125.190     0.150
     4.157    60.990     0.150
     4.157   102.791     0.150
     4.468   138.490     0.150
     4.468   144.791     0.150
     4.766    80.891     0.150
     4.766   146.590     0.150
     5.453   164.090     0.150
     5.453   175.490     0.150
     5.526    84.774     0.150
     5.526   100.174     0.150
     5.671   107.291     0.150
     5.671   172.990     0.150
     5.810   173.490     0.150
     5.810   229.291     0.150
     7.015   127.490     0.150
     7.015   219.190     0.150
     7.403   179.490     0.150
     7.403   214.990     0.150
     7.403   227.291     0.150
    59.873   618.440     0.150
     0.159     4.992     0.150
     0.645    23.086     0.150
     0.985    35.289     0.150
     1.388    26.289     0.150
     1.388    48.492     0.150
     1.497    49.891     0.150
     1.657    52.789     0.150
     1.657    56.492     0.150
     1.698    57.086     0.150
     1.896    38.391     0.150
     2.241    73.891     0.150
     2.580    39.891     0.150
     2.636    41.789     0.150
     2.636    84.492     0.150
     2.890    45.289     0.150
     3.058    57.586     0.150
     3.335    45.188     0.150
     3.335    49.492     0.150
     3.362   142.891     0.150
     4.096   122.688     0.150
     4.096   131.789     0.150
     4.327    71.688     0.150
     4.327   138.391     0.150
     4.853    94.289     0.150
     4.853   146.492     0.150
     5.300    89.492     0.150
     5.300   143.289     0.150
     5.527   176.188     0.150
     5.493   174.992     0.150
     6.688   113.586     0.150
     6.886   208.086     0.150
     7.552   127.688     0.150
     7.552   210.391     0.150
     8.280   183.891     0.150
     8.706   264.289     0.150
     9.122   273.086     0.150
    10.065   323.188     0.150
     0.575    25.477     0.150
     0.635    12.977     0.150
     0.635    12.977     0.150
     0.635    28.172     0.150
     0.635    12.977     0.150
     0.635    21.570     0.150
     1.082    40.477     0.150
     1.385    26.273     0.150
     1.385    24.773     0.150
     1.502    27.477     0.150
     1.502    27.477     0.150
     1.502    42.172     0.150
     1.658    58.070     0.150
     2.250    37.672     0.150
     2.250    37.672     0.150
     2.250    37.672     0.150
     2.240    73.477     0.150
     2.574    50.375     0.150
     2.574    45.977     0.150
     2.756    84.773     0.150
     2.887    47.977     0.150
     3.344    80.570     0.150
     3.359    55.773     0.150
     3.738    58.172     0.150
     3.738    66.977     0.150
     3.931    65.070     0.150
     3.931    69.773     0.150
     4.096    66.875     0.150
     4.096   135.875     0.150
     4.335    65.672     0.150
     4.849    71.773     0.150
     4.849   160.172     0.150
     5.294    89.477     0.150
     5.524    85.570     0.150
     5.524   176.477     0.150
     5.524   171.070     0.150
     5.500    85.672     0.150
     5.613   101.844     0.150
     6.574   175.172     0.150
     6.689   107.977     0.150
     6.689   165.672     0.150
     6.689   120.477     0.150
     6.689   206.977     0.150
     6.891   123.273     0.150
     6.891   100.672     0.150
     6.891   212.977     0.150
     7.546   121.773     0.150
     7.546   203.672     0.150
     8.282   151.875     0.150
     8.282   227.977     0.150
     9.115   148.672     0.150
     9.919   282.477     0.150
     9.919   311.273     0.150
    10.067   318.273     0.150
    10.067   328.477     0.150
    14.041   434.078     0.150
    14.876   212.773     0.150
     0.273    12.660     0.150
     0.538    11.562     0.150
     0.538    11.562     0.150
     0.943    32.660     0.150
     1.453    51.062     0.150
     1.676    32.961     0.150
     1.793    57.359     0.150
     2.059    39.859     0.150
     2.059    67.562     0.150
     2.726    46.262     0.150
     2.816    63.562     0.150
     3.437    55.859     0.150
     3.972    80.660     0.150
     4.894   158.062     0.150
     5.158    98.562     0.150
     5.301    86.461     0.150
     5.301   101.461     0.150
     7.542   125.062     0.150
     0.470     9.570     0.150
     0.817    31.168     0.150
     0.817    16.168     0.150
     0.817    27.168     0.150
     1.001    36.570     0.150
     1.001    17.770     0.150
     1.001    31.469     0.150
     1.365    25.270     0.150
     1.365    25.270     0.150
     1.413    45.469     0.150
     1.593    29.168     0.150
     2.224    72.867     0.150
     2.224    40.168     0.150
     2.330    65.668     0.150
     2.330    71.867     0.150
     2.621    42.668     0.150
     2.735    54.770     0.150
     2.780    73.270     0.150
     2.880    46.469     0.150
     3.202    53.969     0.150
     3.174    52.867     0.150
     3.360    63.867     0.150
     3.360    52.770     0.150
     3.789    61.168     0.150
     3.789    60.770     0.150
     4.138   105.168     0.150
     4.138   135.469     0.150
     4.138   127.168     0.150
     4.171    81.270     0.150
     4.288    64.469     0.150
     4.884    96.969     0.150
     5.325   164.367     0.150
     5.325   165.969     0.150
     5.369   164.070     0.150
     5.635    85.867     0.150
     5.635   154.367     0.150
     5.635   173.070     0.150
     5.635   170.668     0.150
     6.732   121.367     0.150
     6.732   136.969     0.150
     6.732   181.168     0.150
     6.732   123.070     0.150
     6.732   208.270     0.150
     6.722   122.168     0.150
     6.855   102.168     0.150
     6.855   173.668     0.150
     6.855   210.270     0.150
     6.855   102.969     0.150
     6.855   125.770     0.150
     6.855   209.867     0.150
     7.313   132.270     0.150
     8.297   122.668     0.150
     9.208   272.668     0.150
    14.166   204.070     0.150
    49.001   530.070     0.150
     0.946    18.500     0.150
     0.946    32.695     0.150
     1.429    27.898     0.150
     1.509    28.102     0.150
     1.509    30.000     0.150
     1.509    48.602     0.150
     1.642    35.898     0.150
     1.642    54.602     0.150
     1.685    35.398     0.150
     1.685    53.797     0.150
     1.731    57.602     0.150
     1.916    40.000     0.150
     1.916    61.102     0.150
     2.223    35.000     0.150
     2.278    74.297     0.150
     2.672    41.000     0.150
     2.672    84.898     0.150
     3.291    48.398     0.150
     3.291    52.398     0.150
     3.400   108.195     0.150
     3.977    64.000     0.150
     4.298    68.898     0.150
     4.368    80.898     0.150
     5.345    83.500     0.150
     5.345    88.297     0.150
     5.506   171.898     0.150
     6.844   105.500     0.150
     6.844   215.000     0.150
    10.026   307.195     0.150
     1.535    30.723     0.150
     1.535    51.824     0.150
     1.746    38.023     0.150
     4.293    80.125     0.150
     4.293    88.824     0.150
     0.662    13.518     0.150
     0.662    22.018     0.150
     1.094    22.117     0.150
     1.216    24.917     0.150
     1.292    25.817     0.150
     1.296    24.917     0.150
     1.296    24.018     0.150
     1.333    25.617     0.150
     1.333    43.718     0.150
     1.374    27.617     0.150
     1.374    48.417     0.150
     1.923    40.518     0.150
     1.923    58.417     0.150
     2.463    80.018     0.150
     2.463    44.917     0.150
     2.575    41.817     0.150
     2.575    52.817     0.150
     2.575    79.917     0.150
     2.576    42.117     0.150
     2.576    79.518     0.150
     2.857    46.817     0.150
     2.857    87.518     0.150
     3.052    48.917     0.150
     3.052    61.117     0.150
     3.052    48.817     0.150
     3.371    63.518     0.150
     3.741    62.917     0.150
     4.011    63.218     0.150
     4.062   116.317     0.150
     4.297    67.218     0.150
     4.297   146.518     0.150
     4.297    65.317     0.150
     4.421    73.518     0.150
     4.565    78.018     0.150
     4.565   153.117     0.150
     5.051    77.817     0.150
     5.051   131.617     0.150
     5.051   158.218     0.150
     5.335    98.107     0.150
     5.335    81.207     0.150
     5.843    83.018     0.150
     5.843   100.417     0.150
     5.843   177.117     0.150
     5.843   180.718     0.150
     5.843   187.817     0.150
     5.843    89.617     0.150
     5.843   181.018     0.150
     6.996   116.617     0.150
     6.996   216.518     0.150
     7.012    98.817     0.150
     7.012   127.417     0.150
     7.012   147.518     0.150
     7.012   222.917     0.150
     7.012   127.018     0.150
     7.012   217.718     0.150
     7.173   129.817     0.150
     7.173   220.417     0.150
     7.173   182.218     0.150
     7.173   220.317     0.150
     7.312   119.417     0.150
     7.312   132.317     0.150
     7.312   197.218     0.150
     7.859   124.718     0.150
     7.859   146.218     0.150
     7.859   244.917     0.150
     7.859   251.617     0.150
     8.453   263.218     0.150
     8.596   139.218     0.150
     8.596   275.018     0.150
     8.894   133.218     0.150
     8.894   145.317     0.150
     8.894   155.518     0.150
    12.435   326.117     0.150
    12.435   349.218     0.150
    14.601   202.039     0.150
    14.782     3.399     0.150
    15.312   483.917     0.150
    16.333     3.199     0.150
    16.333   235.048     0.150
    17.695   248.077     0.150
    17.874   248.497     0.150
    18.041   571.479     0.150
    20.818   283.308     0.150
    25.743   337.417     0.150
    25.743   377.917     0.150
    26.720   341.917     0.150
    26.720   342.067     0.150
    28.289   361.917     0.150
    28.289   410.617     0.150
    28.289   744.817     0.150
    49.214   529.758     0.150
    49.418   533.308     0.150
    79.627   728.247     0.150
     0.630    13.969     0.150
     0.630    22.869     0.150
     0.630    13.969     0.150
     0.630    23.068     0.150
     1.152    21.168     0.150
     1.152    21.168     0.150
     1.152    22.869     0.150
     1.152    39.568     0.150
     1.152    21.168     0.150
     1.227    23.068     0.150
     1.227    23.068     0.150
     1.227    23.068     0.150
     1.227    39.770     0.150
     1.345    24.969     0.150
     1.345    24.969     0.150
     1.345    26.270     0.150
     1.483    27.469     0.150
     1.483    48.068     0.150
     2.070    38.869     0.150
     2.425    45.168     0.150
     2.425    47.568     0.150
     2.425    40.369     0.150
     2.598    74.068     0.150
     2.598    80.869     0.150
     2.725    50.469     0.150
     2.720    87.969     0.150
     3.224    65.969     0.150
     3.224   105.068     0.150
     3.224    51.568     0.150
     3.224    57.469     0.150
     3.194    50.869     0.150
     3.194    63.869     0.150
     3.194    50.869     0.150
     3.194    58.770     0.150
     3.419    60.770     0.150
     3.594    71.969     0.150
     3.777    58.969     0.150
     3.912    74.068     0.150
     4.162    79.770     0.150
     4.162    65.068     0.150
     4.311   130.270     0.150
     5.163    87.469     0.150
     5.163    79.369     0.150
     5.163    95.369     0.150
     5.163   161.068     0.150
     5.356    81.398     0.150
     5.442    81.469     0.150
     5.442   170.969     0.150
     5.463    82.639     0.150
     6.862   124.369     0.150
     6.862   104.369     0.150
     6.862   125.770     0.150
     6.862   212.369     0.150
     7.041   126.668     0.150
     7.041   103.369     0.150
     7.041   125.969     0.150
     7.041   216.568     0.150
     7.129   117.668     0.150
     7.129   128.770     0.150
     7.710   138.969     0.150
     8.190   117.379     0.150
     8.450   151.770     0.150
    11.336   166.869     0.150
    11.336   291.568     0.150
    12.516   187.969     0.150
    12.516   322.068     0.150
    12.615   179.270     0.150
    13.949   441.219     0.150
    13.949   198.168     0.150
    14.209   201.418     0.150
    14.450   453.938     0.150
    14.712   211.668     0.150
    14.924     2.600     0.150
    14.924   397.869     0.150
    15.215   478.943     0.150
    15.215   218.168     0.150
    15.969   224.568     0.150
    16.476     4.301     0.150
    16.476     7.400     0.150
    17.351     3.701     0.150
    17.351     5.900     0.150
    17.505   241.668     0.150
    17.820   247.158     0.150
    17.998   248.609     0.150
    18.382   255.100     0.150
    18.863   256.619     0.150
    18.863   458.969     0.150
    18.863   256.168     0.150
    18.863   256.658     0.150
    19.118   477.469     0.150
    20.806   282.088     0.150
    21.069   284.668     0.150
    21.460   293.270     0.150
    21.525   286.770     0.150
    21.786   292.068     0.150
    21.790   292.068     0.150
    22.198   296.770     0.150
    22.204   294.369     0.150
    22.836   546.969     0.150
    22.917   302.969     0.150
    22.928   303.969     0.150
    22.923   305.270     0.150
    23.645   311.168     0.150
    24.052   316.809     0.150
    24.184   316.969     0.150
    26.472   337.469     0.150
    26.839   341.139     0.150
    26.839   340.430     0.150
    28.336   400.168     0.150
    30.781   375.969     0.150
    35.036   413.238     0.150
    35.728   418.568     0.150
    36.582   423.469     0.150
    39.282   446.895     0.150
    44.889   643.369     0.150
    44.889  1138.068     0.150
    45.021   490.719     0.150
    45.021   490.719     0.150
    45.021   490.719     0.150
    45.021   632.549     0.150
    45.021   888.258     0.150
    45.021  1133.789     0.150
    49.035   527.998     0.150
    50.559   538.668     0.150
    51.500   545.459     0.150
    51.536   548.068     0.150
    52.921   556.969     0.150
    53.095   558.068     0.150
    53.124   558.969     0.150
    53.136   558.568     0.150
    53.812   564.369     0.150
    54.070   563.969     0.150
    54.070  1025.969     0.150
    54.070   563.969     0.150
    54.070  1025.969     0.150
    54.982   567.805     0.150
    55.275   573.770     0.150
    55.411   574.969     0.150
    56.806   584.578     0.150
    57.706   587.307     0.150
    57.744   587.891     0.150
    66.977   651.918     0.150
    69.603   669.059     0.150
    71.858   683.939     0.150
    74.852   701.689     0.150
    77.162   715.498     0.150
    79.681   727.969     0.150
    87.213   768.229     0.150
    89.248   776.129     0.150
    89.361   777.398     0.150
    89.986   779.709     0.150
     0.309    34.275     0.150
     0.309    38.574     0.150
     0.391    36.074     0.150
     0.391    41.574     0.150
     0.657    41.875     0.150
     0.657    50.475     0.150
     1.227    51.674     0.150
     1.227    68.174     0.150
     1.321    71.674     0.150
     1.427    74.375     0.150
     1.711    60.475     0.150
     1.711    82.574     0.150
     2.750   114.275     0.150
     0.656    13.207     0.150
     0.656    13.207     0.150
     1.150    21.906     0.150
     1.328    25.504     0.150
     4.286    82.004     0.150
     4.286   136.504     0.150
     5.175   139.707     0.150
     0.621    13.273     0.150
     0.621    13.273     0.150
     0.621    13.273     0.150
     0.621    21.773     0.150
     0.621    13.273     0.150
     0.621    21.977     0.150
     0.989    20.477     0.150
     0.989    23.273     0.150
     0.989    35.672     0.150
     0.989    18.078     0.150
     1.087    38.875     0.150
     1.384    24.977     0.150
     1.665    54.273     0.150
     2.242    37.578     0.150
     2.560    42.672     0.150
     2.636    81.375     0.150
     2.889    55.273     0.150
     3.355    55.273     0.150
     3.360    87.078     0.150
     3.360   109.375     0.150
     3.360    53.273     0.150
     3.360    59.977     0.150
     4.340    68.977     0.150
     4.340    71.078     0.150
     4.354    77.977     0.150
     4.847   159.875     0.150
     4.847    89.273     0.150
     5.264   163.578     0.150
     5.288   137.477     0.150
     6.685   107.773     0.150
     6.685   120.977     0.150
     6.685   121.477     0.150
     6.685   206.172     0.150
     6.894   123.875     0.150
     6.894   212.977     0.150
     7.537   135.773     0.150
     8.143   119.875     0.150
     9.107   144.773     0.150
     9.107   258.875     0.150
    17.959   557.023     0.150
    18.779   450.781     0.150
    48.886   525.102     0.150
     0.640    18.920     0.150
     7.874   140.160     0.150
     7.874   241.059     0.150
     0.886    17.059     0.150
     0.886    31.359     0.150
     0.886    17.059     0.150
     1.859    61.859     0.150
     1.859    31.059     0.150
     1.789    31.758     0.150
     1.789    38.559     0.150
     1.789    55.559     0.150
     1.789    51.859     0.150
     1.834    57.758     0.150
     2.307    47.059     0.150
     2.307    38.758     0.150
     2.648    88.059     0.150
     3.065    54.656     0.150
     3.065    49.059     0.150
     3.102    49.859     0.150
     3.102    55.457     0.150
     3.102    50.156     0.150
     3.159    95.156     0.150
     3.767    51.703     0.150
     3.767    93.727     0.150
     3.767   113.652     0.150
     3.767    72.559     0.150
     3.767    56.957     0.150
     3.767    51.859     0.150
     4.320    63.957     0.150
     4.320   129.559     0.150
     4.320   129.059     0.150
     4.739    71.258     0.150
     4.739   145.457     0.150
     4.866    72.457     0.150
     4.866    88.559     0.150
     5.163   166.859     0.150
     5.163   159.156     0.150
     5.664    90.559     0.150
     5.664   101.457     0.150
     5.664   175.156     0.150
     5.774   103.758     0.150
     5.910    82.559     0.150
     5.910   180.816     0.150
     5.910    85.957     0.150
     5.910    85.930     0.150
     6.283   120.656     0.150
     6.500   199.559     0.150
     7.131   127.758     0.150
     7.908   111.457     0.150
     7.908   111.430     0.150
    10.812   157.957     0.150
    12.760   183.359     0.150
    14.299   204.156     0.150
    14.319   200.539     0.150
    14.344   198.156     0.150
    14.504   207.758     0.150
    14.504   371.059     0.150
    14.781   205.559     0.150
    15.436     4.000     0.150
    15.436     7.000     0.150
    17.049     2.699     0.150
    17.049     6.699     0.150
    18.347   252.117     0.150
    18.347   250.320     0.150
    18.524   254.117     0.150
    18.747   449.332     0.150
    18.747   587.383     0.150
    18.832   256.359     0.150
    20.179   271.188     0.150
    20.678   277.879     0.150
    20.678   276.902     0.150
    20.678   276.859     0.150
    22.952   300.656     0.150
    22.952   300.617     0.150
    22.952   569.469     0.150
    23.473   306.637     0.150
    24.029   314.270     0.150
    24.522   319.039     0.150
    27.402   358.059     0.150
    28.643   360.559     0.150
    35.835   416.156     0.150
    36.733   424.359     0.150
    39.267   446.770     0.150
    45.214   491.258     0.150
    45.214   595.957     0.150
    45.214   889.758     0.150
    45.214   491.270     0.150
    45.214   491.270     0.150
    45.214   491.270     0.150
    45.214   595.996     0.150
    45.214   633.629     0.150
    45.214   889.758     0.150
    45.214  1092.449     0.150
    45.214  1131.688     0.150
    45.495   480.309     0.150
    46.410   504.758     0.150
    48.528   521.156     0.150
    48.528   521.109     0.150
    48.642   520.559     0.150
    48.642   520.566     0.150
    48.723   522.789     0.150
    48.702   522.156     0.150
    50.056   532.539     0.150
    50.177   533.379     0.150
    50.318   535.859     0.150
    50.690   538.559     0.150
    50.910   539.449     0.150
    51.000   541.758     0.150
    51.051   539.957     0.150
    51.118   542.156     0.150
    51.213   542.207     0.150
    52.171   550.559     0.150
    52.502   552.258     0.150
    53.112   556.008     0.150
    53.852   562.359     0.150
    54.224   578.758     0.150
    54.224   563.738     0.150
    55.068   570.387     0.150
    55.451   573.656     0.150
    55.590   573.359     0.150
    55.773   575.996     0.150
    56.166   578.777     0.150
    58.038   591.078     0.150
    58.096   591.836     0.150
    58.471   594.367     0.150
    58.483   593.836     0.150
    58.553   594.238     0.150
    59.090   598.816     0.150
    59.373   599.336     0.150
    61.655   616.578     0.150
    70.762   671.934     0.150
    71.039   676.867     0.150
    71.992   680.258     0.150
    74.318   696.098     0.150
    76.322   704.957     0.150
    76.322   704.957     0.150
    78.675   721.398     0.150
    78.713   720.688     0.150
    79.239   724.637     0.150
    79.797   723.609     0.150
    79.797   726.680     0.150
    79.944   728.227     0.150
    89.570   774.457     0.150
    92.760   790.457     0.150
     0.431     9.635     0.150
     0.431    14.935     0.150
     1.081    19.035     0.150
     1.299    22.635     0.150
     1.299    40.234     0.150
     1.962    57.935     0.150
     1.962    61.335     0.150
     2.351    39.135     0.150
     2.447    51.835     0.150
     2.447    83.234     0.150
     2.600    49.935     0.150
     2.600    42.635     0.150
     2.687    52.135     0.150
     2.687    46.635     0.150
     3.063    48.734     0.150
     3.063    48.604     0.150
     3.246    63.234     0.150
     3.246    50.935     0.150
     3.246    57.035     0.150
     3.621    64.234     0.150
     3.643   119.734     0.150
     4.008    79.234     0.150
     4.008   132.035     0.150
     4.519    85.135     0.150
     4.534    85.734     0.150
     4.534   150.835     0.150
     5.433    81.435     0.150
     5.531   173.935     0.150
     5.531   171.635     0.150
     5.522    82.285     0.150
     5.720   175.435     0.150
     5.720   175.335     0.150
     6.963   125.535     0.150
     6.963   128.035     0.150
     6.963   214.635     0.150
     6.968   125.635     0.150
     6.968   139.234     0.150
     7.210   129.234     0.150
     7.210   128.435     0.150
     7.210   222.335     0.150
    11.516   169.734     0.150
    11.516   298.435     0.150
    15.426   219.835     0.150
    17.413     3.101     0.150
    17.641   246.325     0.150
    18.202   576.767     0.150
    18.173   251.814     0.150
    18.689   450.785     0.150
    18.689   578.160     0.150
    20.609   494.704     0.150
    20.609   277.185     0.150
    23.041   303.335     0.150
    26.651   341.194     0.150
    26.651   340.785     0.150
    28.109   356.535     0.150
    28.109   405.335     0.150
    28.109   725.535     0.150
    57.851   587.935     0.150
    58.137   593.705     0.150
    69.567   671.734     0.150
    74.869   700.814     0.150
    76.401   708.734     0.150
    76.401   708.805     0.150
    79.858   728.115     0.150
   147.086  1177.908     0.150
     1.055    21.246     0.150
     1.055    22.043     0.150
     1.708    29.246     0.150
     1.836    58.344     0.150
     2.146    42.145     0.150
     0.659    14.297     0.150
     0.659    14.297     0.150
     0.659    14.297     0.150
     0.659    22.992     0.150
     0.659    14.297     0.150
     0.974    17.594     0.150
     0.974    17.594     0.150
     0.974    34.797     0.150
     1.400    47.992     0.150
     1.400    24.891     0.150
     1.400    44.297     0.150
     1.497    27.391     0.150
     1.497    27.391     0.150
     1.497    30.195     0.150
     1.663    30.297     0.150
     1.899    34.391     0.150
     1.899    34.391     0.150
     2.581    46.195     0.150
     3.320    54.695     0.150
     3.422    51.797     0.150
     4.315   138.891     0.150
     4.343    84.891     0.150
     4.343    66.797     0.150
     5.314   163.594     0.150
     5.314    96.891     0.150
     5.314   163.391     0.150
     5.524   169.695     0.150
     5.524   169.695     0.150
     5.606   101.797     0.150
     6.680   120.695     0.150
     6.680   121.391     0.150
     6.680   206.891     0.150
     6.874   123.297     0.150
     6.874   123.391     0.150
    14.064   434.039     0.150
     0.879    18.020     0.150
     0.879    29.918     0.150
     1.778    55.418     0.150
     1.822    57.520     0.150
     1.872    34.117     0.150
     2.717    45.816     0.150
     2.717    54.117     0.150
     2.717    91.117     0.150
     4.317    65.316     0.150
     5.175   156.918     0.150
     5.235   156.719     0.150
     6.295   176.918     0.150
     0.647    13.906     0.150
     0.984    35.105     0.150
     1.496    30.309     0.150
     1.657    33.605     0.150
     1.657    64.008     0.150
     2.242    43.105     0.150
     2.580    50.207     0.150
     2.580    89.508     0.150
     2.636    50.809     0.150
     2.636    84.207     0.150
     2.890    59.906     0.150
     3.058    56.809     0.150
     3.058    78.207     0.150
     3.058   105.105     0.150
     4.325    84.008     0.150
     4.336    87.207     0.150
     4.854    92.207     0.150
     4.854   106.605     0.150
     4.854   159.309     0.150
     5.268   165.906     0.150
     5.302    89.008     0.150
     5.527   101.508     0.150
     7.287   131.008     0.150
     0.654    13.902     0.150
     0.654    28.301     0.150
     1.496    50.203     0.150
     4.094   131.703     0.150
     4.860    99.402     0.150
     4.860   150.301     0.150
     5.264   100.703     0.150
     5.264   167.000     0.150
     5.308    83.402     0.150
     5.308    89.301     0.150
     5.308   143.402     0.150
     2.059    65.043     0.150
     2.789    46.943     0.150
     1.771    56.697     0.150
     0.964    18.539     0.150
     1.457    50.242     0.150
     1.706    54.141     0.150
     1.706    54.641     0.150
     1.874    33.742     0.150
     2.201    70.844     0.150
     2.290    66.844     0.150
     2.664    51.344     0.150
     3.303   105.945     0.150
     4.514    75.242     0.150
     5.137   157.945     0.150
     6.627   206.445     0.150
     0.518    11.695     0.150
     0.518    18.695     0.150
     0.939    19.398     0.150
     1.162    20.797     0.150
     1.162    36.598     0.150
     1.162    39.098     0.150
     1.211    21.695     0.150
     1.211    38.898     0.150
     1.524    34.898     0.150
     2.393    47.898     0.150
     2.645    50.598     0.150
     2.645    42.098     0.150
     2.645    54.098     0.150
     3.168    58.195     0.150
     3.168    97.996     0.150
     3.503    73.195     0.150
     3.755    71.797     0.150
     3.755   129.297     0.150
     3.894    70.598     0.150
     3.894    74.898     0.150
     4.672    89.398     0.150
     4.672   141.195     0.150
     4.672   155.195     0.150
     5.115    85.797     0.150
     5.115   158.297     0.150
     5.548   101.352     0.150
     6.847   123.797     0.150
     7.069   126.898     0.150
     7.701   237.098     0.150
     8.450   261.297     0.150
    15.280   482.172     0.150
     1.320    23.594     0.150
     2.595    49.895     0.150
     1.041    20.383     0.150
     1.041    35.484     0.150
     1.031    35.684     0.150
     2.187    35.684     0.150
     2.610    41.684     0.150
     2.610    51.285     0.150
     2.581    41.184     0.150
     2.581    50.484     0.150
     2.581    81.184     0.150
     2.835    44.883     0.150
     2.835    51.883     0.150
     3.306    64.883     0.150
     3.306   104.184     0.150
     3.378    63.785     0.150
     3.790    72.586     0.150
     4.344    81.086     0.150
     4.797    93.484     0.150
     5.246    78.285     0.150
     5.246    86.684     0.150
     5.246   164.285     0.150
     6.741   130.383     0.150
    14.002   195.016     0.150
    17.913   242.301     0.150
    79.742   726.684     0.150
     0.674    15.520     0.150
     0.674    24.920     0.150
     0.884    15.520     0.150
     0.884    15.520     0.150
     0.884    30.719     0.150
     0.884    15.520     0.150
     0.884    27.520     0.150
     1.489    25.820     0.150
     1.489    25.820     0.150
     1.489    25.820     0.150
     1.489    45.920     0.150
     1.767    56.119     0.150
     2.141    34.820     0.150
     2.141    34.820     0.150
     2.141    72.719     0.150
     2.141    34.820     0.150
     2.141    65.320     0.150
     2.488    40.119     0.150
     2.488    43.719     0.150
     2.860    87.119     0.150
     2.952    60.119     0.150
     2.952    46.219     0.150
     2.952    52.219     0.150
     2.952    90.020     0.150
     3.466    52.820     0.150
     4.345    64.020     0.150
     4.445    67.320     0.150
     4.445    80.219     0.150
     4.950   152.020     0.150
     5.159    75.920     0.150
     5.159   158.420     0.150
     5.420    79.119     0.150
     5.420   165.420     0.150
     5.385    80.920     0.150
     5.385   167.920     0.150
     6.482   116.020     0.150
     6.580   118.320     0.150
     6.580   119.119     0.150
     6.580   201.920     0.150
     6.792   127.219     0.150
     6.792    97.920     0.150
     6.792   118.820     0.150
     6.792   208.119     0.150
     8.083   114.219     0.150
    10.666   154.920     0.150
    10.666   278.119     0.150
    12.667   184.020     0.150
    14.110   442.445     0.150
    14.110   195.430     0.150
    14.167   345.439     0.150
    14.167   196.719     0.150
    14.298   200.719     0.150
    15.030   379.619     0.150
    15.030   470.969     0.150
    16.262   223.320     0.150
    16.508   225.420     0.150
    16.508   401.920     0.150
    16.748     7.201     0.150
    17.586     8.201     0.150
    17.852   242.859     0.150
    17.852   563.006     0.150
    18.059   246.820     0.150
    18.059   245.959     0.150
    18.237   250.719     0.150
    18.660   589.473     0.150
    18.766   456.469     0.150
    18.766   592.770     0.150
    19.690   496.619     0.150
    20.781   279.820     0.150
    22.636   298.510     0.150
    23.630   310.119     0.150
    25.619   328.619     0.150
    27.068   340.719     0.150
    27.068   340.420     0.150
    28.435   399.820     0.150
    28.435   639.719     0.150
    30.647   373.219     0.150
    30.827   374.219     0.150
    35.628   416.990     0.150
    45.077   493.299     0.150
    45.077   493.299     0.150
    45.077   587.740     0.150
    45.077   609.109     0.150
    45.077   655.250     0.150
    45.077  1070.799     0.150
    45.077  1149.500     0.150
    45.077   493.219     0.150
    45.077   893.320     0.150
    45.077  1149.420     0.150
    45.363   502.779     0.150
    50.296   533.719     0.150
    50.443   536.020     0.150
    50.463   533.709     0.150
    50.504   536.719     0.150
    50.996   539.920     0.150
    50.997   541.820     0.150
    51.269   540.289     0.150
    53.189   558.420     0.150
    53.189   558.420     0.150
    59.600   601.320     0.150
    69.354   665.820     0.150
    70.821   674.619     0.150
    74.578   698.020     0.150
    79.506   726.420     0.150
    80.200   729.719     0.150
     0.655    15.726     0.150
     0.655    24.325     0.150
     1.093    35.726     0.150
     1.296    22.926     0.150
     1.335    24.625     0.150
     2.319    37.926     0.150
     2.319    71.226     0.150
     2.462    76.325     0.150
     2.852    45.525     0.150
     3.051    46.426     0.150
     3.051    94.525     0.150
     4.012    80.325     0.150
     4.303    63.825     0.150
     4.303   129.625     0.150
     5.048   137.426     0.150
     5.048   155.825     0.150
     5.592   112.426     0.150
     5.592   151.226     0.150
     5.839    93.325     0.150
     7.011   126.325     0.150
     7.011   176.325     0.150
     7.011   190.426     0.150
     7.011   222.825     0.150
     7.011   126.325     0.150
     7.011   215.325     0.150
     7.174   224.926     0.150
     7.174   125.625     0.150
     7.174   221.926     0.150
     7.858   141.426     0.150
     7.858   147.926     0.150
     7.858   207.125     0.150
     8.595   249.226     0.150
    15.316   480.900     0.150
    18.364   570.950     0.150
     2.565    49.930     0.150
     4.053    59.527     0.150
     4.053    76.027     0.150
     4.568   129.629     0.150
     5.830   154.527     0.150
     5.830   187.730     0.150
     7.003   224.129     0.150
     7.169   130.930     0.150
     8.892   280.527     0.150
    10.371  7525.027     0.150
     0.816    30.922     0.150
     1.749    55.625     0.150
     1.870    35.625     0.150
     0.691    15.926     0.150
     0.847    16.826     0.150
     1.805    33.926     0.150
     1.805    57.625     0.150
     2.039    59.826     0.150
     2.781    44.826     0.150
     2.916    58.125     0.150
     2.916    94.625     0.150
     3.034    57.125     0.150
     3.504    86.625     0.150
     4.986    94.025     0.150
     5.417    90.225     0.150
     5.417   173.125     0.150
     0.628    26.492     0.150
     0.982    19.289     0.150
     0.982    34.391     0.150
     1.390    56.391     0.150
     1.912    37.789     0.150
     2.240    42.195     0.150
     2.641  3649.492     0.150
     3.043    56.992     0.150
     3.729    73.594     0.150
     4.347    80.789     0.150
     5.259    96.594     0.150
     5.296    89.695     0.150
     6.681   122.492     0.150
     1.160    23.219     0.150
     1.160    39.914     0.150
     1.500    51.617     0.150
     1.786    31.719     0.150
     2.428    48.414     0.150
     3.189    55.219     0.150
     3.699   105.016     0.150
     3.935    77.414     0.150
     3.935    80.914     0.150
     4.615   154.914     0.150
     5.052    85.617     0.150
     6.661   174.719     0.150
     8.873   276.719     0.150
     0.736    27.902     0.150
     1.306    24.504     0.150
     1.306    42.102     0.150
     1.809    36.504     0.150
     1.830    35.102     0.150
     1.830    58.004     0.150
     1.877    38.902     0.150
     2.234    41.602     0.150
     2.831    52.203     0.150
     4.940    91.102     0.150
     0.815    14.574     0.150
     0.815    14.574     0.150
     0.626    24.773     0.150
     0.626    12.473     0.150
     1.601    27.875     0.150
     1.601    27.875     0.150
     1.975    41.973     0.150
     1.975    61.074     0.150
     1.943    60.875     0.150
     1.968    62.773     0.150
     2.487    86.074     0.150
     2.876    53.273     0.150
     3.124    61.273     0.150
     3.363   108.473     0.150
     3.585   115.574     0.150
     3.820   125.172     0.150
     4.520    83.672     0.150
     4.520   148.375     0.150
     4.601   143.273     0.150
     4.601   144.375     0.150
     5.034   155.973     0.150
     5.425   157.375     0.150
     5.425   168.473     0.150
     5.802    85.773     0.150
     6.438   118.973     0.150
     8.167   114.773     0.150
    10.848   160.875     0.150
    10.848   163.574     0.150
    10.848   286.172     0.150
    11.048   273.973     0.150
    13.006   181.273     0.150
    13.006     3.199     0.150
    13.006   191.875     0.150
    13.997   191.844     0.150
    13.997   339.219     0.150
    13.997   198.672     0.150
    14.493   203.074     0.150
    15.040   472.500     0.150
    17.158   420.574     0.150
    18.117   248.875     0.150
    18.346   249.875     0.150
    18.346   447.773     0.150
    20.917   278.973     0.150
    22.630   549.172     0.150
    22.731     2.699     0.150
    22.689   552.348     0.150
    22.741   299.473     0.150
    23.810   309.973     0.150
    24.298   316.172     0.150
    25.048   795.141     0.150
    26.224   339.973     0.150
    27.111   341.473     0.150
    27.141   348.773     0.150
    28.457   359.773     0.150
    28.457   410.672     0.150
    35.495   414.973     0.150
    35.844   418.973     0.150
    38.688   443.039     0.150
    39.061   445.703     0.150
    40.688   457.285     0.150
    40.851   455.473     0.150
    44.962   493.293     0.150
    44.962   493.293     0.150
    44.962   636.664     0.150
    44.962   892.973     0.150
    44.962  1140.875     0.150
    44.962   493.273     0.150
    44.962   598.672     0.150
    44.962   636.574     0.150
    44.962   892.973     0.150
    44.962  1140.875     0.150
    47.996   518.305     0.150
    48.214   516.883     0.150
    51.021   538.680     0.150
    51.099   539.043     0.150
    51.090   539.598     0.150
    51.408   541.621     0.150
    55.534   573.273     0.150
    60.686   606.098     0.150
    71.898   681.023     0.150
    73.619   691.305     0.150
    74.382   696.773     0.150
    76.495   707.672     0.150
    78.741   722.672     0.150
    79.971   727.473     0.150
    83.323   742.527     0.150
   143.329  1166.844     0.150
     0.636    24.750     0.150
     0.639    12.156     0.150
     0.639    12.156     0.150
     0.802    16.055     0.150
     0.895    18.156     0.150
     1.375    27.453     0.150
     1.617    50.453     0.150
     1.823    57.250     0.150
     1.959    41.453     0.150
     1.959    33.555     0.150
     1.959    61.453     0.150
     2.739    54.250     0.150
     2.739    86.852     0.150
     4.990    76.656     0.150
     4.990   156.953     0.150
     0.624    13.078     0.150
     1.594    50.078     0.150
     1.939    60.977     0.150
     3.577   100.672     0.150
     5.012    79.477     0.150
     5.025   136.477     0.150
     5.415    89.773     0.150
     6.445   174.578     0.150
     1.375    44.191     0.150
     2.251    37.891     0.150
     2.251    37.891     0.150
     2.251    42.793     0.150
     2.251    37.793     0.150
     2.234    37.391     0.150
     2.234    40.594     0.150
     2.627    42.891     0.150
     2.627    46.891     0.150
     2.746    84.891     0.150
     2.880    88.793     0.150
     3.351   103.594     0.150
     3.920   109.594     0.150
     3.920    61.492     0.150
     3.920   120.691     0.150
     4.356   151.391     0.150
     4.356    77.293     0.150
     4.838    90.992     0.150
     4.838   158.293     0.150
     4.838    89.094     0.150
     5.280    88.891     0.150
     5.280    96.594     0.150
     5.280    80.992     0.150
     5.280    96.191     0.150
     5.280   162.992     0.150
     5.509    80.293     0.150
     5.622   102.434     0.150
     5.622   155.172     0.150
     6.567   183.691     0.150
     6.903   123.492     0.150
     6.903   192.891     0.150
     6.903   212.293     0.150
     8.527   220.492     0.150
    18.564   578.594     0.150
    76.300   712.008     0.150
    79.764   731.688     0.150
     0.585    11.594     0.150
     0.585    19.794     0.150
     1.415    45.794     0.150
     1.722    54.494     0.150
     2.190    35.194     0.150
     2.190    35.794     0.150
     2.190    65.694     0.150
     2.485    38.094     0.150
     2.980    48.294     0.150
     4.871   126.294     0.150
     6.640   175.194     0.150
     8.173   118.394     0.150
     0.734    26.287     0.150
     1.398    45.787     0.150
     1.908    60.587     0.150
     2.114    43.887     0.150
     2.534    50.587     0.150
     6.175   110.787     0.150
     1.980    63.289     0.150
     2.595    86.090     0.150
     0.346     7.148     0.150
     0.453    21.344     0.150
     0.563    11.648     0.150
     0.785    16.648     0.150
     0.785    29.945     0.150
     1.108    33.742     0.150
     1.108    19.945     0.150
     1.108    21.844     0.150
     1.339    41.547     0.150
     1.339    23.945     0.150
     2.217    37.445     0.150
     2.217    41.844     0.150
     2.375    42.648     0.150
     2.686    90.742     0.150
     2.867    56.742     0.150
     2.867    88.547     0.150
     2.941    55.742     0.150
     3.320    64.047     0.150
     3.740    70.742     0.150
     3.842    74.148     0.150
     4.368    85.648     0.150
     4.659    69.547     0.150
     4.659    86.945     0.150
     4.750    71.648     0.150
     5.132    77.242     0.150
     6.694   120.344     0.150
     7.019   126.148     0.150
     7.019   217.445     0.150
     7.019   126.844     0.150
     7.019   217.445     0.150
     8.257   253.320     0.150
    17.826   556.773     0.150
    18.374   571.992     0.150
     0.635    12.212     0.150
     0.635    12.212     0.150
     1.423    30.312     0.150
     1.799    57.312     0.150
     2.683    42.412     0.150
     4.432    66.812     0.150
     0.307     7.180     0.150
     0.307    11.375     0.150
     0.920    17.273     0.150
     0.920    33.680     0.150
     1.509    26.578     0.150
     1.750    36.875     0.150
     1.750    53.078     0.150
     1.800    38.477     0.150
     2.263    43.180     0.150
     2.635    46.875     0.150
     2.635    42.375     0.150
     3.327    81.875     0.150
     3.421    61.273     0.150
     4.331    83.180     0.150
     4.331   141.078     0.150
     4.738   147.180     0.150
     4.738    80.578     0.150
     4.738   124.375     0.150
     4.738   146.875     0.150
     5.490    99.578     0.150
     5.559   101.516     0.150
     5.559   142.875     0.150
     5.673   109.875     0.150
     5.673   191.773     0.150
     6.719   214.375     0.150
     6.765   120.977     0.150
     6.765   130.977     0.150
     7.115   127.578     0.150
     7.115   154.875     0.150
     7.425   132.977     0.150
     7.988   144.977     0.150
    17.421   244.477     0.150
     0.279     5.484     0.150
     0.279     5.484     0.150
     0.456    21.184     0.150
     0.331     7.184     0.150
     0.331    11.285     0.150
     1.145    22.086     0.150
     1.290    40.785     0.150
     1.667    59.785     0.150
     2.002    60.883     0.150
     2.127    43.484     0.150
     2.191    63.785     0.150
     2.267    43.984     0.150
     2.424    41.184     0.150
     2.575    47.184     0.150
     2.640    50.785     0.150
     2.640    87.785     0.150
     2.817    46.883     0.150
     2.817    87.383     0.150
     2.992    55.086     0.150
     2.992    52.383     0.150
     2.992    54.785     0.150
     2.992    60.383     0.150
     2.992    82.586     0.150
     2.992   102.883     0.150
     4.105    78.883     0.150
     4.105    90.684     0.150
     4.646   107.086     0.150
     5.467   148.484     0.150
     5.683   103.883     0.150
     5.777   105.723     0.150
     5.777   153.684     0.150
     6.743   121.684     0.150
     7.058   178.684     0.150
     7.058   218.285     0.150
     7.058   103.484     0.150
     7.058   126.383     0.150
     7.058   179.086     0.150
     7.058   232.785     0.150
     7.140   128.086     0.150
     7.140   188.785     0.150
     7.140   220.984     0.150
    13.779   432.234     0.150
    14.274   452.152     0.150
     1.049    36.578     0.150
     1.334    43.180     0.150
     1.579    49.875     0.150
     4.520   125.477     0.150
     0.328     7.219     0.150
     1.146    22.617     0.150
     1.146    36.422     0.150
     1.146    38.617     0.150
     1.291    41.016     0.150
     1.670    35.719     0.150
     1.701    36.219     0.150
     2.005    60.117     0.150
     2.129    63.219     0.150
     2.192    37.016     0.150
     2.266    38.117     0.150
     2.990   104.820     0.150
     4.319    80.117     0.150
     4.319   154.219     0.150
     4.650    70.016     0.150
     4.706   150.820     0.150
     5.095    94.320     0.150
     5.095   158.922     0.150
     5.095    79.820     0.150
     5.465   104.922     0.150
     6.743   121.922     0.150
     7.059   128.719     0.150
     7.059   219.016     0.150
     7.059   129.219     0.150
     7.059   219.016     0.150
     7.059   237.117     0.150
     7.140   128.516     0.150
     7.140   196.219     0.150
    14.272   203.617     0.150
    14.272   363.219     0.150
    17.786   563.578     0.150
    18.343   581.188     0.150
    18.503   441.695     0.150
    20.347   485.461     0.150
    41.996   468.820     0.150
    48.833   523.820     0.150
    70.316   672.672     0.150
     0.470    20.898     0.150
     0.762    28.797     0.150
     1.147    20.199     0.150
     1.147    21.898     0.150
     1.147    38.496     0.150
     1.296    25.199     0.150
     1.681    29.398     0.150
     1.681    35.297     0.150
     1.676    35.699     0.150
     1.710    36.199     0.150
     2.018    66.496     0.150
     2.199    43.996     0.150
     2.980    99.297     0.150
     4.663    71.797     0.150
     0.528    10.836     0.150
     0.528    10.836     0.150
     0.670    13.137     0.150
     0.670    13.137     0.150
     0.670    13.137     0.150
     0.873    15.934     0.150
     0.873    15.934     0.150
     0.873    15.934     0.150
     1.500    26.637     0.150
     1.500    32.535     0.150
     1.500    47.137     0.150
     1.783    35.137     0.150
     1.783    56.934     0.150
     1.783    68.734     0.150
     2.020    38.734     0.150
     2.020    68.734     0.150
     2.125    35.434     0.150
     2.125    35.434     0.150
     2.125    35.434     0.150
     2.125    37.336     0.150
     2.125    42.336     0.150
     2.362    42.434     0.150
     2.362    51.637     0.150
     2.362    83.035     0.150
     2.465    44.234     0.150
     2.465    46.234     0.150
     2.755    49.734     0.150
     2.755    86.234     0.150
     2.935    57.035     0.150
     3.008    47.734     0.150
     3.008    59.336     0.150
     3.308    59.934     0.150
     3.478    62.535     0.150
     3.478    66.234     0.150
     3.478    53.637     0.150
     3.614    55.934     0.150
     4.043    72.434     0.150
     4.357    82.836     0.150
     4.960   156.137     0.150
     5.144   158.934     0.150
     5.144    76.434     0.150
     5.144   140.934     0.150
     5.403   167.336     0.150
     5.403   165.637     0.150
     5.391   167.434     0.150
     5.391    88.336     0.150
     5.391   167.434     0.150
     5.601   196.535     0.150
     5.601    81.066     0.150
     5.720    88.234     0.150
     5.720    84.613     0.150
     6.784   208.434     0.150
     6.784   122.234     0.150
     6.784   126.734     0.150
     7.393   133.535     0.150
     7.638   115.637     0.150
     7.638   214.637     0.150
     7.930   141.234     0.150
     8.087   117.535     0.150
     8.087   117.637     0.150
     8.087   286.434     0.150
    12.039   173.637     0.150
    13.677   198.137     0.150
    14.313   200.574     0.150
    18.067   565.160     0.150
    18.067   255.836     0.150
    18.751   452.059     0.150
    20.376   630.180     0.150
    20.376   274.945     0.150
    20.936   288.934     0.150
    21.669   289.957     0.150
    24.995   787.129     0.150
    26.631   342.336     0.150
    27.074   341.836     0.150
    27.074   341.297     0.150
    27.221   353.137     0.150
    42.314   473.875     0.150
    50.499   537.625     0.150
   143.126  1167.777     0.150
     0.336     7.211     0.150
     0.336    12.008     0.150
     0.459    20.309     0.150
     0.776    29.508     0.150
     1.122    20.309     0.150
     1.122    35.309     0.150
     1.145    20.609     0.150
     1.323    42.410     0.150
     1.704    58.609     0.150
     1.735    36.711     0.150
     1.735    56.910     0.150
     1.735    55.508     0.150
     2.039    61.309     0.150
     2.233    69.309     0.150
     2.670    91.711     0.150
     2.670    81.910     0.150
     2.956    47.711     0.150
     2.956    52.211     0.150
     4.661    71.410     0.150
     5.270   106.008     0.150
     5.430   177.211     0.150
     5.812   152.105     0.150
     7.034   216.410     0.150
    80.059   730.609     0.150
     0.244     8.703     0.150
     1.158    22.797     0.150
     1.215    22.500     0.150
     1.215    39.203     0.150
     4.406    66.703     0.150
     0.730    15.070     0.150
     0.730    26.773     0.150
     1.174    23.172     0.150
     1.220    25.375     0.150
     1.681    29.375     0.150
     2.787    85.570     0.150
     8.407   150.898     0.150
     0.518    10.180     0.150
     0.518    10.180     0.150
     0.518    21.477     0.150
     0.702    29.180     0.150
     0.951    35.180     0.150
     2.929    47.180     0.150
     4.875    73.578     0.150
     8.303   149.523     0.150
    13.672   420.969     0.150
     1.852    57.961     0.150
     1.874    61.762     0.150
     2.391    79.461     0.150
     4.939    73.160     0.150
     0.711    13.781     0.150
     0.711    13.781     0.150
     1.684    54.586     0.150
     2.275    43.680     0.150
     3.281    90.180     0.150
     4.255    81.680     0.150
     5.554   170.695     0.150
    14.096   435.719     0.150
    15.059   457.055     0.150
     0.879    18.988     0.150
     0.879    31.887     0.150
     2.054    67.688     0.150
     1.216    38.766     0.150
     4.337    71.664     0.150
     1.032    36.844     0.150
     1.538    52.045     0.150
     2.635    42.045     0.150
     2.635    76.744     0.150
     4.313    66.844     0.150
     1.414    34.461     0.150
     2.636    54.461     0.150
     0.678    12.760     0.150
     0.678    12.760     0.150
     0.678    12.760     0.150
     0.952    16.561     0.150
     0.952    16.561     0.150
     0.952    16.561     0.150
     0.952    32.660     0.150
     1.422    25.160     0.150
     1.422    26.061     0.150
     1.422    45.061     0.150
     1.507    27.859     0.150
     1.638    52.359     0.150
     1.681    53.859     0.150
     1.681    30.359     0.150
     1.681    53.859     0.150
     2.227    35.561     0.150
     2.227    35.561     0.150
     2.272    37.459     0.150
     2.272    40.859     0.150
     2.272    64.561     0.150
     2.272    70.561     0.150
     2.570    41.459     0.150
     2.570    45.660     0.150
     2.570    78.959     0.150
     2.666    42.760     0.150
     2.666    47.959     0.150
     2.666    74.160     0.150
     2.666    82.859     0.150
     2.921    46.459     0.150
     2.921    52.859     0.150
     3.042    47.859     0.150
     3.042    53.561     0.150
     3.042    93.260     0.150
     3.298    58.359     0.150
     3.298   100.660     0.150
     3.394    53.359     0.150
     3.394    60.760     0.150
     3.394    91.859     0.150
     3.394   105.959     0.150
     4.073    72.959     0.150
     4.073   126.160     0.150
     3.970    61.561     0.150
     3.970    71.660     0.150
     3.970   123.459     0.150
     4.302    64.160     0.150
     4.302    77.160     0.150
     4.302   113.260     0.150
     4.302   132.959     0.150
     4.363    74.260     0.150
     4.363   135.660     0.150
     4.889    94.061     0.150
     4.889   126.959     0.150
     4.889   161.760     0.150
     4.889    73.160     0.150
     4.889   126.959     0.150
     4.889   151.260     0.150
     5.338    80.359     0.150
     5.338   138.459     0.150
     5.338   165.359     0.150
     5.497    81.061     0.150
     5.510    81.260     0.150
     5.614    82.320     0.150
     5.614   171.162     0.150
     5.614    82.641     0.150
     6.660    97.859     0.150
     6.660   118.260     0.150
     6.851    99.561     0.150
    14.252   436.154     0.150
    18.005   561.584     0.150
    18.005   250.260     0.150
    18.625   582.035     0.150
    18.823   259.260     0.150
    20.174   272.641     0.150
    20.482   276.061     0.150
    59.689   602.260     0.150
    76.253   706.260     0.150
     0.329     7.539     0.150
     0.825    17.539     0.150
     0.825    30.938     0.150
     0.834    16.141     0.150
     0.834    30.836     0.150
     1.380    43.742     0.150
     1.752    30.336     0.150
     1.752    31.141     0.150
     1.760    34.539     0.150
     2.122    43.438     0.150
     2.354    38.836     0.150
     2.740    43.141     0.150
     2.740    84.141     0.150
     2.735    48.438     0.150
     2.735    43.336     0.150
     2.735    48.438     0.150
     2.735    83.242     0.150
     3.396    60.336     0.150
     3.396    96.641     0.150
     3.889   111.336     0.150
     5.517   140.539     0.150
     0.672    13.203     0.150
     0.672    13.203     0.150
     0.672    25.703     0.150
     0.924    18.000     0.150
     1.717    54.602     0.150
     0.167     7.121     0.150
     0.167     9.820     0.150
     0.167    10.320     0.150
     2.610    46.320     0.150
     2.589    42.898     0.150
     0.150     6.984     0.150
     0.150     4.184     0.150
     1.373    24.584     0.150
     1.373    42.885     0.150
     1.548    26.885     0.150
     1.548    47.885     0.150
     1.917    60.584     0.150
     2.261    39.783     0.150
     2.261    70.385     0.150
     2.266    63.584     0.150
     2.266    36.885     0.150
     2.266    40.684     0.150
     2.266    63.584     0.150
     2.266    70.885     0.150
     2.457    76.783     0.150
     2.488    43.584     0.150
     2.488    76.584     0.150
     2.686    46.783     0.150
     2.686    81.684     0.150
     4.127    62.283     0.150
     4.127   127.385     0.150
     5.157    75.283     0.150
     5.732    83.584     0.150
    14.295   196.783     0.150
     0.965    32.902     0.150
     1.420    25.902     0.150
     3.462    55.199     0.150
     4.437   133.199     0.150
     0.088     4.312     0.150
     1.411    24.211     0.150
     1.411    24.211     0.150
     1.420    26.109     0.150
     1.991    62.211     0.150
     2.333    37.414     0.150
     2.263    71.008     0.150
     2.309    37.211     0.150
     2.309    72.508     0.150
     2.546    69.914     0.150
     2.546    79.609     0.150
     2.793    93.609     0.150
     2.793    48.008     0.150
     2.836    49.812     0.150
     2.836    51.508     0.150
     2.836    44.211     0.150
     2.836    49.812     0.150
     2.836    86.211     0.150
     4.289   133.508     0.150
     4.289    63.711     0.150
     4.286    64.008     0.150
     4.286   133.008     0.150
     4.374    82.812     0.150
     5.242   161.914     0.150
     5.242   161.609     0.150
     5.779   104.914     0.150
     5.779   152.211     0.150
     5.779   177.914     0.150
     5.779   104.211     0.150
     5.779   177.508     0.150
     5.763   177.508     0.150
     5.763   102.508     0.150
     5.990   164.609     0.150
     5.990   184.508     0.150
     5.990   199.508     0.150
     6.099   109.508     0.150
     6.099   190.312     0.150
     6.163   110.211     0.150
     6.163   190.711     0.150
     6.163    89.211     0.150
     6.262    90.859     0.150
     6.262    90.914     0.150
     7.592   107.711     0.150
    14.337   438.727     0.150
    14.774   207.539     0.150
    22.470   297.234     0.150
    23.365   307.430     0.150
    27.848   348.609     0.150
    48.094   515.359     0.150
    48.094   515.359     0.150
    51.613   545.312     0.150
     0.681    14.770     0.150
     0.987    34.170     0.150
     1.728    54.270     0.150
     2.667    80.471     0.150
     3.381    58.070     0.150
     2.734    42.844     0.150
     0.500     9.996     0.150
     0.500    16.594     0.150
     1.287    23.996     0.150
     1.287    42.496     0.150
     1.804    31.293     0.150
     1.804    34.195     0.150
     1.804    56.793     0.150
     2.193    36.695     0.150
     2.299    46.895     0.150
     2.657    47.195     0.150
     2.657    42.496     0.150
     2.657    55.793     0.150
     2.828    49.996     0.150
     2.828    86.594     0.150
     2.909    89.793     0.150
     2.909    89.895     0.150
     3.403    62.695     0.150
     3.920    61.195     0.150
     3.920   105.293     0.150
     4.167    63.793     0.150
     4.167   109.094     0.150
     4.391    68.793     0.150
     4.391   135.594     0.150
     4.391   146.094     0.150
     4.510    66.793     0.150
     4.510   138.395     0.150
     4.846    73.895     0.150
     4.846   127.395     0.150
     5.392    98.254     0.150
     5.392   146.941     0.150
     7.020   126.418     0.150
     7.121   129.594     0.150
     7.121   221.094     0.150
    13.641   418.445     0.150
    40.088   571.793     0.150
    76.350   711.508     0.150
     0.219     5.152     0.150
     0.219     8.354     0.150
     0.409     8.254     0.150
     0.409     8.254     0.150
     0.756    27.652     0.150
     1.223    22.053     0.150
     1.223    38.354     0.150
     1.223    40.053     0.150
     1.255    44.754     0.150
     1.353    26.754     0.150
     1.353    42.553     0.150
     1.857    37.553     0.150
     1.840    58.152     0.150
     1.840    34.152     0.150
     1.840    58.354     0.150
     1.840    59.854     0.150
     2.217    36.953     0.150
     2.261    39.652     0.150
     2.261    68.553     0.150
     2.173    42.953     0.150
     2.270    38.652     0.150
     2.270    40.953     0.150
     2.643    47.053     0.150
     2.665    39.953     0.150
     2.876    51.254     0.150
     2.876    87.854     0.150
     3.267    58.854     0.150
     3.267   100.854     0.150
     3.801    68.553     0.150
     4.037    73.152     0.150
     4.037   125.453     0.150
     4.406    82.053     0.150
     4.869    88.053     0.150
     4.869   152.053     0.150
     5.253    93.953     0.150
     5.253   162.152     0.150
     5.038    75.254     0.150
     5.038   155.754     0.150
     5.350   166.652     0.150
     5.882   106.053     0.150
     5.882   151.453     0.150
     5.967   107.666     0.150
     5.967   153.652     0.150
     7.105   129.254     0.150
     7.105   129.254     0.150
     7.105   220.652     0.150
     7.261   130.854     0.150
     7.261   224.354     0.150
     7.261   113.652     0.150
     7.261   130.854     0.150
     7.261   224.354     0.150
     8.129   146.152     0.150
     8.129   146.152     0.150
     8.129   250.053     0.150
     8.439   211.428     0.150
    14.189   433.021     0.150
    14.189   201.854     0.150
    15.468   479.195     0.150
    17.742   548.240     0.150
    18.277   248.402     0.150
    18.277   442.508     0.150
    18.277   562.434     0.150
    18.277   248.354     0.150
     1.293    44.553     0.150
     1.798    52.953     0.150
     2.661    47.253     0.150
     7.008   123.103     0.150
     0.790    16.082     0.150
     0.790    27.982     0.150
     0.905    17.781     0.150
     0.905    30.082     0.150
     1.841    58.482     0.150
     4.936    92.682     0.150
     0.504    10.289     0.150
     0.504    10.289     0.150
     0.564    11.195     0.150
     0.894    15.594     0.150
     0.894    27.492     0.150
     0.804    29.195     0.150
     1.270    29.391     0.150
     1.512    27.195     0.150
     1.734    38.094     0.150
     1.856    59.195     0.150
     1.856    33.789     0.150
     1.856    58.594     0.150
     1.879    61.891     0.150
     2.065    41.789     0.150
     2.335    71.695     0.150
     2.873    88.391     0.150
     3.495    54.383     0.150
     3.495    54.391     0.150
     3.495    98.891     0.150
     3.495    54.289     0.150
     4.514    66.891     0.150
     4.514    80.695     0.150
     4.948   162.195     0.150
     4.948   151.992     0.150
     5.347    87.594     0.150
     5.347   165.094     0.150
     5.347   165.492     0.150
     5.848   105.992     0.150
     5.848   155.812     0.150
     5.848    86.789     0.150
     5.848   155.789     0.150
     8.207   116.695     0.150
    11.127   167.891     0.150
    14.473   202.594     0.150
    17.735   254.891     0.150
    18.036   249.992     0.150
    18.212   252.594     0.150
    18.212   252.594     0.150
    20.254   273.852     0.150
    20.254   273.789     0.150
    20.934   280.844     0.150
    21.652   289.398     0.150
    22.632   300.914     0.150
    22.802   301.391     0.150
    23.725   312.195     0.150
    24.215   316.789     0.150
    24.966   323.992     0.150
    26.964   342.000     0.150
    27.032   341.891     0.150
    27.100   346.594     0.150
    28.416   353.391     0.150
    51.275   374.453     0.150
    30.892   375.891     0.150
    31.001   378.391     0.150
    36.910   426.094     0.150
    42.166   470.523     0.150
    47.707   515.094     0.150
    48.683   523.195     0.150
    51.123   542.289     0.150
    51.330   544.789     0.150
    52.728   554.695     0.150
    53.869   562.992     0.150
    53.957   562.594     0.150
    53.957  1904.492     0.150
    54.725   570.250     0.150
    55.316   574.695     0.150
    56.719   584.391     0.150
    56.792   584.992     0.150
    57.334   588.594     0.150
    59.078   598.789     0.150
    59.466   600.945     0.150
    61.969   619.891     0.150
    76.196   708.695     0.150
    76.483   709.023     0.150
    84.870   754.898     0.150
   150.868  1190.141     0.150
     0.939    19.562     0.150
     1.196    28.664     0.150
     1.183    28.863     0.150
     1.814    31.863     0.150
     1.814    38.363     0.150
     2.401    47.762     0.150
     3.161    62.062     0.150
     3.720    69.562     0.150
     3.219    51.008     0.150
    15.270   209.602     0.150
    15.270   465.625     0.150
    18.721   454.031     0.150
     1.222    22.789     0.150
     2.502    49.590     0.150
     3.125    48.590     0.150
     3.987    77.889     0.150
    15.257   471.830     0.150
     0.194     5.195     0.150
     0.329     7.094     0.150
     0.526    10.492     0.150
     0.526    17.793     0.150
     0.953    17.492     0.150
     1.420    25.895     0.150
     1.593    29.293     0.150
     0.277     6.191     0.150
     0.689    13.191     0.150
     1.669    27.992     0.150
     1.847    58.789     0.150
     2.391    37.090     0.150
     0.805    17.411     0.150
     0.805    28.111     0.150
     1.292    25.111     0.150
     1.713    33.911     0.150
     1.722    34.811     0.150
     2.045    43.211     0.150
     2.045    58.211     0.150
     2.263    44.111     0.150
     2.263    68.211     0.150
     2.200    37.111     0.150
     2.580    48.511     0.150
     2.968    54.211     0.150
     3.270    49.279     0.150
     3.270    97.554     0.150
     5.828    85.111     0.150
     0.686    25.648     0.150
     0.951    34.750     0.150
     1.275    41.250     0.150
     2.654    55.453     0.150
     2.851    83.055     0.150
     7.045   178.477     0.150
     7.045   216.516     0.150
    15.486   478.758     0.150
     1.015    33.812     0.150
     1.237    41.875     0.150
     1.564    49.676     0.150
     3.422    53.078     0.150
     7.056   178.828     0.150
     1.566    49.457     0.150
     2.432    84.059     0.150
     3.021    48.258     0.150
     7.063   185.219     0.150
    13.842   427.012     0.150
    14.628   447.027     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     0.216     7.424     0.150
     0.984    18.524     0.150
     0.984    31.625     0.150
     1.695    30.625     0.150
     1.695    31.424     0.150
     1.695    54.225     0.150
     1.823    32.625     0.150
     1.823    54.524     0.150
     1.823    56.524     0.150
     1.985    33.924     0.150
     1.985    34.625     0.150
     1.985    60.625     0.150
     2.144    67.625     0.150
     2.552    45.625     0.150
     2.552    71.825     0.150
     2.552    77.924     0.150
     3.014    48.825     0.150
     3.014    53.524     0.150
     3.014    57.424     0.150
     3.014    84.524     0.150
     3.014    94.125     0.150
     3.011    91.825     0.150
     3.621    63.625     0.150
     3.621    97.625     0.150
     3.621   110.625     0.150
     3.661    57.625     0.150
     3.661    66.024     0.150
     3.661    99.125     0.150
     3.661   113.125     0.150
     4.742    84.225     0.150
     4.742   146.625     0.150
     4.862    72.625     0.150
     4.862    87.625     0.150
     4.862   126.125     0.150
     4.862   150.024     0.150
     5.041    79.625     0.150
     5.041    92.325     0.150
     5.041   132.625     0.150
     5.041   155.524     0.150
     1.902    32.820     0.150
     1.902    56.420     0.150
     1.902    58.121     0.150
     1.949    34.221     0.150
     2.278    37.721     0.150
     3.245    51.021     0.150
     3.245    55.221     0.150
     3.245    89.721     0.150
     3.245    95.721     0.150
     3.245    99.721     0.150
     3.350    50.621     0.150
     3.350    91.621     0.150
     3.350   103.721     0.150
     3.515    53.721     0.150
     3.515    54.621     0.150
     3.515    63.621     0.150
     3.520    55.320     0.150
     3.520    65.721     0.150
     3.520   109.721     0.150
     4.888    73.920     0.150
     4.925    74.721     0.150
     5.297    80.721     0.150
     5.297    81.021     0.150
     9.300   134.721     0.150
    13.140   185.721     0.150
    13.284   188.221     0.150
    13.284   333.221     0.150
    13.492   191.721     0.150
    13.492   333.721     0.150
    13.669   189.521     0.150
    13.669   513.721     0.150
    13.669   938.721     0.150
    13.669   951.721     0.150
    14.673   205.721     0.150
    14.673   461.721     0.150
    14.784   210.721     0.150
    14.911   209.721     0.150
    15.011   209.721     0.150
    15.011   378.721     0.150
    15.011   209.920     0.150
    15.506   216.121     0.150
    15.506   222.721     0.150
    15.732   221.721     0.150
    15.732   227.121     0.150
    15.732   395.721     0.150
    16.307   229.221     0.150
    16.307   422.721     0.150
    16.332   229.721     0.150
    17.148   239.721     0.150
    17.293   240.721     0.150
    17.884   246.721     0.150
    17.884   447.721     0.150
    18.126   251.221     0.150
    18.126   453.721     0.150
    18.553   257.121     0.150
    18.553   266.721     0.150
    19.836   267.721     0.150
    19.836   485.721     0.150
    19.818   270.721     0.150
    19.818   491.721     0.150
    22.476   297.721     0.150
    22.476   541.721     0.150
    22.837   301.721     0.150
    22.837   545.721     0.150
    22.934   304.721     0.150
    23.136   305.721     0.150
    23.241   308.320     0.150
    23.241   568.721     0.150
    23.294   305.721     0.150
    23.294   333.721     0.150
    23.325   307.721     0.150
    23.325   561.721     0.150
    23.334   307.721     0.150
    23.334   561.721     0.150
    23.632   312.721     0.150
    24.412   317.721     0.150
    25.085   325.920     0.150
    26.483     8.000     0.150
    26.655   613.721     0.150
    27.167   341.721     0.150
    27.389   347.221     0.150
    27.425   625.721     0.150
    28.379   353.721     0.150
    28.379     5.000     0.150
    29.126   360.721     0.150
    29.775   369.221     0.150
    30.046   369.121     0.150
    30.395   371.721     0.150
    30.395   661.721     0.150
    30.963   378.721     0.150
    30.986   377.721     0.150
    30.986   685.721     0.150
    31.311   381.320     0.150
    31.453   382.721     0.150
    31.530   381.721     0.150
    31.530   681.721     0.150
    31.530   447.721     0.150
    31.542   383.721     0.150
    32.401   387.721     0.150
    34.163   405.221     0.150
    34.163   731.721     0.150
    34.443   408.320     0.150
    34.775   411.721     0.150
    34.775   741.721     0.150
    35.540   416.320     0.150
    35.540   753.721     0.150
    35.540   769.721     0.150
    35.540   497.721     0.150
    35.540   883.721     0.150
    35.823   419.721     0.150
    36.790   426.721     0.150
    37.256   432.721     0.150
    37.351   433.121     0.150
    37.744   436.721     0.150
    37.888   439.721     0.150
    38.188   440.721     0.150
    38.188   805.721     0.150
    38.267   441.721     0.150
    38.267   529.721     0.150
    38.345   438.920     0.150
    38.339   440.820     0.150
    38.464   442.721     0.150
    39.058   448.920     0.150
    39.480   449.721     0.150
    39.480   807.721     0.150
    39.480   541.721     0.150
    39.828   456.221     0.150
    40.309   456.320     0.150
    40.309   551.721     0.150
    40.309   578.721     0.150
    40.309  1003.721     0.150
    40.287   454.721     0.150
    41.053   462.721     0.150
    41.053   836.721     0.150
    41.053   564.721     0.150
    41.053   581.721     0.150
    41.053  1009.721     0.150
    41.159   463.420     0.150
    41.221   466.721     0.150
    41.464   467.521     0.150
    41.561   467.621     0.150
    41.682   466.721     0.150
    41.682   467.521     0.150
    41.747   470.721     0.150
    42.885   477.721     0.150
    42.885   584.721     0.150
    42.885  1053.721     0.150
    43.146   480.920     0.150
    43.146   587.920     0.150
    43.146  1048.920     0.150
    43.166   479.721     0.150
    43.166     5.199     0.150
    43.276   480.920     0.150
    43.318   481.721     0.150
    43.318     4.500     0.150
    43.318   873.721     0.150
    44.405   489.721     0.150
    44.405   490.221     0.150
    44.490   492.721     0.150
    44.934   494.721     0.150
    45.069   494.721     0.150
    45.208   497.320     0.150
    45.524   497.621     0.150
    45.603   498.721     0.150
    45.603   595.721     0.150
    46.169   504.820     0.150
    46.467   505.121     0.150
    46.531   505.721     0.150
    47.023   511.721     0.150
    47.391   514.920     0.150
    47.785   517.920     0.150
    47.785     7.301     0.150
    47.785   606.221     0.150
    47.785   942.221     0.150
    47.785  1099.721     0.150
    47.785  1147.721     0.150
    47.896   516.820     0.150
    48.042   519.721     0.150
    48.307   519.721     0.150
    48.567   521.721     0.150
    48.762   523.320     0.150
    48.928   524.721     0.150
    48.928     6.000     0.150
    48.928   945.721     0.150
    48.900   525.721     0.150
    49.213   964.221     0.150
    49.213  1123.721     0.150
    49.534   530.221     0.150
    49.613   531.721     0.150
    49.613   651.721     0.150
    49.753   530.920     0.150
    49.836   531.320     0.150
    49.860   533.721     0.150
    50.026   535.721     0.150
    50.253   536.621     0.150
    50.534     8.000     0.150
    50.763   540.721     0.150
    50.754   539.420     0.150
    51.250   543.721     0.150
    51.351   545.721     0.150
    51.423   546.721     0.150
    51.447   544.721     0.150
    51.485   544.721     0.150
    51.485     5.199     0.150
    51.485     7.801     0.150
    51.578   549.021     0.150
    51.712   547.721     0.150
    51.712     4.000     0.150
    51.904   548.420     0.150
    51.904   668.621     0.150
    52.050   550.721     0.150
    52.050   546.721     0.150
    52.091   548.721     0.150
    52.137   546.721     0.150
    52.196   551.721     0.150
    52.320   551.121     0.150
    52.309   554.920     0.150
    52.714     3.600     0.150
    52.923   555.820     0.150
    52.923     5.900     0.150
    52.964   556.121     0.150
    53.780   562.521     0.150
    53.792   562.521     0.150
    53.792     7.199     0.150
    53.792   627.721     0.150
    53.792     7.000     0.150
    53.814   561.721     0.150
    53.906   561.721     0.150
    53.927   562.420     0.150
    53.927     7.301     0.150
    53.927     7.500     0.150
    54.112   564.721     0.150
    54.112     7.000     0.150
    54.115   566.121     0.150
    54.115     8.500     0.150
    54.117   564.320     0.150
    54.117     5.600     0.150
    54.097   563.721     0.150
    54.176   565.021     0.150
    54.314   566.521     0.150
    54.450   567.721     0.150
    54.473   567.021     0.150
    54.480   566.320     0.150
    54.507   567.521     0.150
    55.020   571.521     0.150
    55.020     7.199     0.150
    55.020   629.420     0.150
    55.132   571.721     0.150
    55.164   572.320     0.150
    55.210   572.721     0.150
    55.305   572.320     0.150
    55.484   575.021     0.150
    55.654   576.121     0.150
    55.741   576.721     0.150
    55.869   577.621     0.150
    55.869     5.600     0.150
    55.869     7.199     0.150
    55.997   578.221     0.150
    56.062   578.521     0.150
    56.209   579.221     0.150
    56.209     7.500     0.150
    56.261   579.221     0.150
    56.485   582.320     0.150
    56.668   585.820     0.150
    56.718   584.021     0.150
    56.718   646.320     0.150
    56.876   584.221     0.150
    56.898   585.221     0.150
    56.898   637.820     0.150
    56.928   586.420     0.150
    56.941   584.320     0.150
    57.142   589.721     0.150
    57.157   585.221     0.150
    57.195   586.721     0.150
    57.310   588.420     0.150
    57.333   584.621     0.150
    57.470   588.721     0.150
    57.470     6.000     0.150
    57.489   587.820     0.150
    57.549   589.781     0.150
    57.637   589.820     0.150
    57.727   590.721     0.150
    57.819   590.221     0.150
    57.978   592.920     0.150
    58.272   593.621     0.150
    58.369   595.211     0.150
    58.540   595.521     0.150
    58.593   596.420     0.150
    59.240   600.521     0.150
    59.313   601.121     0.150
    59.357   601.721     0.150
    59.736   601.820     0.150
    59.777   604.121     0.150
    60.160   607.221     0.150
    60.321   607.061     0.150
    60.438   609.820     0.150
    60.562   611.021     0.150
    60.847   612.602     0.150
    60.866   611.781     0.150
    60.913   611.721     0.150
    60.981   611.920     0.150
    60.992   613.121     0.150
    60.997   613.121     0.150
    61.018   611.781     0.150
    61.249   612.701     0.150
    61.275   613.830     0.150
    61.295   614.021     0.150
    61.365   616.121     0.150
    61.381   615.721     0.150
    61.387   614.721     0.150
    61.411   615.682     0.150
    61.461   615.121     0.150
    61.569   615.920     0.150
    61.570   615.471     0.150
    61.636   615.471     0.150
    61.649   617.111     0.150
    61.695   616.121     0.150
    61.716   616.121     0.150
    61.880   618.420     0.150
    61.972   618.320     0.150
    62.355   621.621     0.150
    62.462   622.221     0.150
    62.519   622.121     0.150
    62.792   624.021     0.150
    63.251   627.221     0.150
    63.578   630.121     0.150
    64.160   633.820     0.150
    65.835   644.121     0.150
    68.809   662.721     0.150
    69.352   665.721     0.150
    69.877   670.021     0.150
    70.281   672.221     0.150
    70.821   675.721     0.150
    70.821     7.000     0.150
    70.899   676.420     0.150
    71.070   677.420     0.150
    71.243   679.621     0.150
    72.327   685.420     0.150
    74.625   698.721     0.150
    76.365   708.920     0.150
    76.694   710.121     0.150
    76.697   710.221     0.150
    76.697     4.699     0.150
    77.332   713.221     0.150
    77.349   714.721     0.150
    78.226   719.420     0.150
    78.248   718.320     0.150
    78.402   719.721     0.150
    78.689   720.721     0.150
    79.891   729.021     0.150
    79.935   729.721     0.150
    80.152   729.920     0.150
    80.170   729.521     0.150
    80.170     5.398     0.150
    80.617   732.920     0.150
    81.403   737.221     0.150
    81.884   737.721     0.150
    82.236   741.521     0.150
    82.991   745.721     0.150
    83.324   746.721     0.150
    84.144   750.721     0.150
    85.212   755.721     0.150
    85.525   757.721     0.150
    86.404   762.820     0.150
    86.407   763.121     0.150
    86.597   763.420     0.150
    86.686   762.820     0.150
    86.686     6.000     0.150
    87.008   764.320     0.150
    87.875   769.320     0.150
    88.069   769.721     0.150
    88.069     7.699     0.150
    88.305   770.820     0.150
    88.559   772.820     0.150
    90.170   779.721     0.150
    90.339   780.920     0.150
    98.493   817.320     0.150
   100.498   825.621     0.150
   100.498   831.021     0.150
   142.677  1178.721     0.150
   143.674  1175.721     0.150
   144.856  1175.221     0.150
   144.856  1180.721     0.150
   148.082  1176.920     0.150
   150.599  1191.221     0.150
     0.358     7.965     0.150
     0.358    12.965     0.150
     0.826    14.965     0.150
     0.826    25.664     0.150
     1.750    28.664     0.150
     1.750    51.664     0.150
     2.095    37.164     0.150
     2.095    65.062     0.150
     2.787    47.965     0.150
     2.787    43.363     0.150
     2.728    43.664     0.150
     2.728    49.062     0.150
     2.728    76.363     0.150
     2.728    85.664     0.150
     2.752    44.164     0.150
     2.752    48.965     0.150
     2.752    76.965     0.150
     2.752    84.164     0.150
     3.227    52.664     0.150
     3.227    57.664     0.150
     3.227    89.965     0.150
     3.227   100.664     0.150
     3.876    69.664     0.150
     3.876   104.965     0.150
     3.876   120.363     0.150
     4.184    72.465     0.150
     0.240     5.785     0.150
     0.240    10.285     0.150
     1.163    22.684     0.150
     1.163    36.285     0.150
     1.163    39.684     0.150
     1.281    22.285     0.150
     1.281    39.586     0.150
     1.605    50.086     0.150
     2.391    38.484     0.150
     2.391    41.184     0.150
     2.391    67.484     0.150
     2.391    72.684     0.150
     2.507    42.883     0.150
     2.507    71.484     0.150
     2.507    76.684     0.150
     2.504    43.785     0.150
     2.504    70.984     0.150
     2.504    77.285     0.150
     3.097    48.785     0.150
     3.097    54.684     0.150
     3.097    96.086     0.150
     3.142    55.984     0.150
     3.142    86.086     0.150
     3.142    95.086     0.150
     3.662    58.484     0.150
     3.662    64.285     0.150
     3.662   101.484     0.150
     3.662   111.086     0.150
     3.744    55.383     0.150
     3.744    65.484     0.150
     3.744    98.285     0.150
     3.744   113.184     0.150
     3.918    59.785     0.150
     3.918    69.086     0.150
     3.918   121.684     0.150
     4.201    76.484     0.150
     4.201   129.984     0.150
     4.570    69.785     0.150
     4.570    80.785     0.150
     4.570   123.285     0.150
     4.570   139.984     0.150
     4.702    83.484     0.150
     4.702   120.785     0.150
     0.258     5.672     0.150
     0.258    11.070     0.150
     1.359    24.672     0.150
     1.359    43.070     0.150
     1.654    28.672     0.150
     1.654    51.070     0.150
     2.207    35.969     0.150
     2.207    38.773     0.150
     2.207    62.672     0.150
     2.207    68.672     0.150
     2.368    41.375     0.150
     2.368    69.672     0.150
     2.368    73.273     0.150
     2.597    41.773     0.150
     2.597    45.070     0.150
     2.597    78.672     0.150
     2.657    41.672     0.150
     2.657    45.672     0.150
     2.657    48.273     0.150
     2.657    73.070     0.150
     2.657    80.469     0.150
     3.031    52.672     0.150
     3.031    93.070     0.150
     4.044    60.672     0.150
     4.044    70.273     0.150
     4.044   104.672     0.150
     4.044   123.672     0.150
     4.163   128.570     0.150
     5.073    90.672     0.150
     5.073   158.070     0.150
     0.264     6.723     0.150
     0.264    10.621     0.150
     0.997    17.820     0.150
     0.997    31.223     0.150
     1.436    25.121     0.150
     1.436    43.020     0.150
     1.462    45.621     0.150
     2.341    71.820     0.150
     2.557    44.621     0.150
     2.557    70.723     0.150
     2.557    77.723     0.150
     2.642    42.422     0.150
     2.642    47.020     0.150
     2.642    72.820     0.150
     2.642    81.121     0.150
     2.976    52.121     0.150
     2.976    54.121     0.150
     2.976    82.422     0.150
     2.976    88.621     0.150
     2.976    92.723     0.150
     3.254    55.820     0.150
     3.254    58.723     0.150
     3.254    88.520     0.150
     3.254    99.520     0.150
     3.846    67.121     0.150
     3.846   117.723     0.150
     4.084    74.621     0.150
     4.084   127.820     0.150
     4.723    68.621     0.150
     4.723    83.820     0.150
     4.723   119.520     0.150
     4.723   144.820     0.150
     0.327     7.148     0.150
     0.327    11.648     0.150
     0.914    16.949     0.150
     0.914    29.148     0.150
     1.506    26.047     0.150
     1.506    45.148     0.150
     2.261    39.648     0.150
     2.261    64.848     0.150
     2.261    69.348     0.150
     2.641    42.047     0.150
     2.641    45.949     0.150
     2.641    70.250     0.150
     2.723    43.547     0.150
     2.723    49.148     0.150
     2.723    75.547     0.150
     2.723    83.348     0.150
     2.894    51.547     0.150
     2.894    81.047     0.150
     2.894    88.250     0.150
     3.338    52.348     0.150
     3.338    58.250     0.150
     3.338    89.949     0.150
     3.338   101.848     0.150
     3.421    59.949     0.150
     3.421   104.148     0.150
     3.881    67.648     0.150
     3.881    99.848     0.150
     3.881   118.949     0.150
     3.954    72.648     0.150
     3.954   123.449     0.150
     4.166    73.949     0.150
     4.166   109.949     0.150
     4.166   128.047     0.150
     4.332    76.250     0.150
     4.332   115.547     0.150
     4.332   133.250     0.150
     4.713    68.547     0.150
     4.713    84.348     0.150
     4.713   120.148     0.150
     4.713   144.348     0.150
     0.282     7.059     0.150
     0.282    10.758     0.150
     0.956    17.559     0.150
     1.429    25.859     0.150
     1.429    45.859     0.150
     1.477    46.059     0.150
     2.299    42.160     0.150
     2.299    70.258     0.150
     2.599    79.758     0.150
     2.675    42.961     0.150
     2.675    48.461     0.150
     2.675    73.758     0.150
     2.675    82.059     0.150
     2.934    45.660     0.150
     2.934    52.559     0.150
     2.934    78.059     0.150
     2.934    89.961     0.150
     3.292    90.059     0.150
     3.292   100.359     0.150
     3.456    54.559     0.150
     3.456    62.961     0.150
     3.456    92.359     0.150
     3.456   107.461     0.150
     3.876    58.461     0.150
     3.876    70.461     0.150
     3.876   103.059     0.150
     3.876   119.359     0.150
     3.999   106.059     0.150
     3.999   124.961     0.150
     4.126    73.758     0.150
     4.126   108.359     0.150
     4.126   127.059     0.150
     4.365    77.461     0.150
     4.365   115.660     0.150
     4.365   136.059     0.150
     4.442   117.859     0.150
     4.733    69.258     0.150
     4.733    84.059     0.150
     4.733   121.359     0.150
     4.733   144.059     0.150
     4.769    83.961     0.150
     4.769   124.258     0.150
     4.769   146.961     0.150
     5.763    82.961     0.150
     5.763   102.758     0.150
     5.763   148.758     0.150
     5.763   178.660     0.150
     7.393   227.961     0.150
     0.314     6.391     0.150
     0.314    11.488     0.150
     0.916    16.590     0.150
     0.916    29.488     0.150
     1.391    44.391     0.150
     1.510    26.590     0.150
     1.510    46.590     0.150
     2.260    70.789     0.150
     2.639    43.090     0.150
     2.639    47.289     0.150
     2.639    81.590     0.150
     2.713    47.891     0.150
     2.713    79.789     0.150
     2.713    83.391     0.150
     2.895    51.590     0.150
     2.895    89.988     0.150
     3.333    59.090     0.150
     3.333   102.590     0.150
     3.419    61.590     0.150
     3.419   106.090     0.150
     3.893    58.590     0.150
     3.893    69.090     0.150
     3.893   118.590     0.150
     3.959    71.090     0.150
     3.959   123.590     0.150
     4.166    74.590     0.150
     4.166   129.090     0.150
     4.329    77.789     0.150
     4.729   146.090     0.150
     4.738   147.590     0.150
     1.407    25.977     0.150
     1.530    47.375     0.150
     2.266    40.777     0.150
     2.266    70.977     0.150
     2.299    73.078     0.150
     2.299    38.176     0.150
     2.299    41.977     0.150
     2.299    66.977     0.150
     2.476    40.777     0.150
     2.476    44.176     0.150
     2.476    77.375     0.150
     2.487    41.977     0.150
     2.487    78.375     0.150
     2.487    41.578     0.150
     2.487    45.777     0.150
     2.658    46.676     0.150
     2.658    81.977     0.150
     2.658    42.078     0.150
     2.658    46.977     0.150
     2.658    82.078     0.150
     2.808    51.977     0.150
     2.808    88.977     0.150
     2.808    52.777     0.150
     2.911    46.375     0.150
     2.911    81.777     0.150
     3.391    52.578     0.150
     3.391    52.977     0.150
     3.391    58.977     0.150
     3.391    61.977     0.150
     3.391    91.277     0.150
     3.670    56.477     0.150
     3.670    66.977     0.150
     3.670   112.977     0.150
     3.670    56.277     0.150
     3.670    63.977     0.150
     3.670    66.875     0.150
     3.670    96.977     0.150
     3.670   113.375     0.150
     4.117    61.977     0.150
     4.117    72.078     0.150
     4.117    74.977     0.150
     4.117   108.777     0.150
     4.117   127.277     0.150
     4.264    65.078     0.150
     4.264    74.977     0.150
     4.264   131.176     0.150
     4.450    66.977     0.150
     4.450    79.977     0.150
     4.450   115.375     0.150
     4.450   137.977     0.150
     4.458    67.078     0.150
     4.848    72.676     0.150
     4.848    76.176     0.150
     4.848    86.977     0.150
     4.848   124.875     0.150
     4.848   146.176     0.150
     4.877    72.375     0.150
     4.877    72.977     0.150
     5.186    78.477     0.150
     5.186    93.676     0.150
     5.186    78.375     0.150
     5.766    86.977     0.150
     5.766    87.078     0.150
     5.766   151.977     0.150
     5.841    86.375     0.150
     5.841   170.977     0.150
     5.975    87.977     0.150
     5.975   105.977     0.150
     5.975   107.176     0.150
     5.975   153.977     0.150
     6.196    92.078     0.150
     6.196    93.777     0.150
     6.196   163.477     0.150
     6.309    91.676     0.150
     6.309   163.176     0.150
     6.309   196.977     0.150
     7.463   107.078     0.150
     7.463   188.176     0.150
     7.463   232.875     0.150
    13.491   189.977     0.150
    14.098   197.277     0.150
    14.140   198.977     0.150
    14.160   199.875     0.150
    14.160   446.578     0.150
    14.136   198.477     0.150
    14.261   211.977     0.150
    14.870   208.078     0.150
    15.615   216.977     0.150
    15.614   225.977     0.150
    15.661   224.977     0.150
    15.725   220.977     0.150
    15.725   232.277     0.150
    17.544   244.477     0.150
    17.955   249.977     0.150
    17.955   258.977     0.150
    19.494   267.477     0.150
    20.323   277.875     0.150
    22.401   298.977     0.150
    23.805   976.977     0.150
    25.614   330.477     0.150
    30.889   377.336     0.150
    31.132   380.016     0.150
    31.224   381.016     0.150
    31.453   382.398     0.150
    31.578   383.758     0.150
    31.661   384.777     0.150
    31.687   383.617     0.150
    31.884   386.488     0.150
    31.993   387.305     0.150
    32.094   388.527     0.150
    32.219   389.297     0.150
    32.232   389.715     0.150
    32.397   390.828     0.150
    32.548   391.566     0.150
    36.027   420.676     0.150
    36.027   566.977     0.150
    39.530   448.977     0.150
    39.530   576.777     0.150
    42.346   472.176     0.150
    42.764   476.477     0.150
    43.813   485.777     0.150
    43.819   486.578     0.150
    43.819     9.797     0.150
    43.830   485.977     0.150
    45.140   495.277     0.150
    46.003   501.875     0.150
    47.815   517.207     0.150
    48.954   525.277     0.150
    48.954   524.875     0.150
    55.991   578.176     0.150
    59.140   598.477     0.150
    59.140   598.176     0.150
    71.135   677.977     0.150
    71.977   682.375     0.150
    78.259   718.676     0.150
    92.475   791.277     0.150
     0.355     7.064     0.150
     0.355    12.364     0.150
     0.995    18.264     0.150
     0.995    31.564     0.150
     1.401    24.964     0.150
     1.401    44.464     0.150
     1.413    26.464     0.150
     1.413    45.464     0.150
     2.354    73.964     0.150
     2.696    44.464     0.150
     2.696    47.464     0.150
     2.696    82.964     0.150
     2.979    49.665     0.150
     2.979    84.264     0.150
     2.979    91.564     0.150
     3.286    52.464     0.150
     3.286    59.264     0.150
     3.286   102.064     0.150
     3.519    58.364     0.150
     3.519    62.564     0.150
     3.519   107.464     0.150
     3.767    58.564     0.150
     3.767    68.764     0.150
     3.767   102.665     0.150
     3.767   118.564     0.150
     4.019    73.464     0.150
     4.019   127.064     0.150
     4.084    73.464     0.150
     4.084   126.665     0.150
     4.624    81.964     0.150
     4.624   141.964     0.150
     4.855    76.964     0.150
     4.855   131.764     0.150
     4.855   148.464     0.150
     5.759   101.764     0.150
     5.759   175.764     0.150
     6.172   110.564     0.150
     6.172   190.665     0.150
     7.039   218.264     0.150
     0.236     4.913     0.150
     0.236     8.913     0.150
     0.569    11.213     0.150
     0.569    18.213     0.150
     1.043    18.513     0.150
     1.043    33.413     0.150
     1.331    24.213     0.150
     1.331    42.713     0.150
     1.331    43.513     0.150
     1.501    46.913     0.150
     1.501    48.213     0.150
     1.630    50.513     0.150
     2.282    37.812     0.150
     2.282    40.513     0.150
     2.282    66.713     0.150
     2.282    70.513     0.150
     2.570    44.513     0.150
     2.570    46.518     0.150
     2.570    81.518     0.150
     2.570    43.612     0.150
     2.570    46.812     0.150
     2.570    74.612     0.150
     2.570    79.812     0.150
     2.570    47.013     0.150
     2.701    49.913     0.150
     2.701    82.516     0.150
     2.701    74.413     0.150
     2.701    82.812     0.150
     3.071    48.713     0.150
     3.071    94.516     0.150
     3.071    49.112     0.150
     3.071    54.013     0.150
     3.071    83.513     0.150
     3.071    94.812     0.150
     3.309    51.913     0.150
     3.309    60.513     0.150
     3.309   103.518     0.150
     3.309    52.513     0.150
     3.309    58.812     0.150
     3.309   100.612     0.150
     3.309   104.013     0.150
     3.309    60.013     0.150
     3.413    59.013     0.150
     3.413    93.413     0.150
     3.413   103.413     0.150
     3.874    70.513     0.150
     3.874   120.513     0.150
     3.874    61.513     0.150
     3.874    70.812     0.150
     3.874   103.013     0.150
     3.874   121.013     0.150
     4.156    75.513     0.150
     4.298    66.513     0.150
     4.298    78.013     0.150
     4.298   113.612     0.150
     4.298   133.413     0.150
     4.393    66.513     0.150
     4.393    80.112     0.150
     4.393   136.112     0.150
     4.393    65.812     0.150
     4.393    79.513     0.150
     4.393   116.413     0.150
     4.393   135.612     0.150
     4.791    75.213     0.150
     4.791    87.521     0.150
     4.791    74.312     0.150
     4.791    86.713     0.150
     4.791   146.713     0.150
     4.791    88.413     0.150
     5.229    80.513     0.150
     5.229    95.515     0.150
     5.229   163.516     0.150
     5.229    79.612     0.150
     5.229   138.312     0.150
     5.229   163.812     0.150
     5.543    84.612     0.150
     5.543   100.516     0.150
     0.146     3.605     0.150
     0.146     6.506     0.150
     0.649    13.006     0.150
     0.649    22.006     0.150
     0.966    17.705     0.150
     0.966    30.406     0.150
     1.407    25.605     0.150
     1.407    45.205     0.150
     1.916    32.605     0.150
     1.916    34.605     0.150
     1.916    60.705     0.150
     2.230    36.705     0.150
     2.230    39.307     0.150
     2.230    69.006     0.150
     2.562    45.506     0.150
     2.562    78.705     0.150
     2.778    50.506     0.150
     2.778    85.705     0.150
     3.038    54.205     0.150
     3.038    93.807     0.150
     3.038    47.506     0.150
     3.038    53.506     0.150
     3.326    58.006     0.150
     3.326   101.705     0.150
     3.381    60.105     0.150
     3.381   104.506     0.150
     3.717    66.307     0.150
     3.717   100.506     0.150
     3.717   115.307     0.150
     3.717    56.506     0.150
     3.953    70.506     0.150
     3.953   122.506     0.150
     4.330    78.705     0.150
     4.330   113.307     0.150
     4.330   134.006     0.150
     0.331     6.922     0.150
     0.331    11.320     0.150
     1.021    19.125     0.150
     1.021    32.320     0.150
     1.383    25.125     0.150
     1.383    44.320     0.150
     1.443    26.523     0.150
     1.443    47.523     0.150
     1.464    26.422     0.150
     1.464    46.227     0.150
     1.770    33.227     0.150
     1.770    57.320     0.150
     2.304    39.625     0.150
     2.304    42.023     0.150
     2.304    69.023     0.150
     2.304    72.320     0.150
     2.377    43.523     0.150
     2.377    72.523     0.150
     2.377    37.727     0.150
     2.377    41.922     0.150
     2.377    73.023     0.150
     2.537    45.625     0.150
     2.537    73.523     0.150
     2.665    46.023     0.150
     2.665    81.523     0.150
     2.665    43.320     0.150
     2.665    46.227     0.150
     2.665    76.523     0.150
     2.665    82.727     0.150
     3.004    92.922     0.150
     3.004    86.227     0.150
     3.004    94.320     0.150
     3.256    51.727     0.150
     3.256    58.625     0.150
     3.256    88.727     0.150
     3.540    57.023     0.150
     3.540    62.320     0.150
     3.540    97.023     0.150
     3.540   108.625     0.150
     3.765    58.727     0.150
     3.765    68.820     0.150
     4.058    71.727     0.150
     4.047    73.523     0.150
     4.047   125.523     0.150
     4.637    82.320     0.150
     4.637   120.523     0.150
     4.637   141.625     0.150
     4.870   129.125     0.150
     4.870   152.227     0.150
     5.575   174.023     0.150
     5.729   177.023     0.150
     0.260     5.176     0.150
     0.260     7.973     0.150
     0.260     9.074     0.150
     0.589    11.375     0.150
     0.589    19.574     0.150
     1.282    23.773     0.150
     1.282    41.574     0.150
     1.282    42.473     0.150
     1.434    26.273     0.150
     1.434    45.973     0.150
     1.818    33.074     0.150
     1.818    58.176     0.150
     2.345    41.375     0.150
     2.345    66.875     0.150
     2.345    72.773     0.150
     2.637    43.375     0.150
     2.637    47.574     0.150
     2.637    75.273     0.150
     2.637    81.273     0.150
     2.637    43.273     0.150
     2.637    47.676     0.150
     2.637    75.676     0.150
     2.637    81.473     0.150
     2.532    45.176     0.150
     2.532    71.973     0.150
     2.532    78.973     0.150
     2.653    47.273     0.150
     2.653    82.273     0.150
     2.653    44.176     0.150
     2.653    48.473     0.150
     2.653    83.273     0.150
     3.138    50.074     0.150
     3.138    56.473     0.150
     3.138    97.973     0.150
     3.138    49.875     0.150
     3.138    56.273     0.150
     3.257    51.176     0.150
     3.257    59.375     0.150
     3.257   100.875     0.150
     3.257    59.676     0.150
     3.257   101.273     0.150
     3.418    61.875     0.150
     3.418   105.875     0.150
     3.418    54.074     0.150
     3.418    62.176     0.150
     3.418    93.973     0.150
     3.418   106.676     0.150
     3.508    65.375     0.150
     3.508   111.273     0.150
     3.508   110.973     0.150
     3.837    59.473     0.150
     3.837    67.273     0.150
     3.837    69.875     0.150
     3.837   119.074     0.150
     3.829    60.074     0.150
     3.829    59.574     0.150
     3.829   102.574     0.150
     3.829   116.973     0.150
     3.829   119.273     0.150
     4.191    65.375     0.150
     4.191    77.074     0.150
     4.191   131.176     0.150
     4.219    77.176     0.150
     4.219   131.574     0.150
     4.237    66.074     0.150
     4.237    78.473     0.150
     4.237   133.473     0.150
     4.237    65.875     0.150
     4.360    78.574     0.150
     4.360   115.074     0.150
     4.360   135.074     0.150
     4.360    78.176     0.150
     4.360   114.973     0.150
     4.747    85.473     0.150
     4.747   146.176     0.150
     4.747    74.074     0.150
     4.747    87.676     0.150
     4.747   129.273     0.150
     5.197    92.574     0.150
     5.197   160.574     0.150
     5.197    80.375     0.150
     5.197   139.273     0.150
     5.197   161.574     0.150
     5.367    80.176     0.150
     5.367    97.875     0.150
     5.367   168.773     0.150
     5.373    99.074     0.150
     5.443    81.914     0.150
     5.610   100.273     0.150
     5.610   172.973     0.150
     5.610    82.973     0.150
     5.610    99.473     0.150
     5.610   172.773     0.150
     6.789   124.473     0.150
     6.789   211.574     0.150
     6.992   101.973     0.150
     6.992   125.074     0.150
     6.992   215.273     0.150
     8.198   254.289     0.150
    20.555   277.383     0.150
    48.545   521.875     0.150
    48.981   526.625     0.150
    59.769   603.766     0.150
    79.746   727.676     0.150
     0.224     5.080     0.150
     0.224     9.280     0.150
     0.934    15.980     0.150
     0.934    28.480     0.150
     0.951    17.680     0.150
     0.951    30.580     0.150
     1.377    25.180     0.150
     1.377    44.180     0.150
     1.528    27.180     0.150
     1.528    47.080     0.150
     2.296    37.380     0.150
     2.296    39.880     0.150
     2.296    71.580     0.150
     2.713    75.780     0.150
     2.713    83.480     0.150
     2.768    48.480     0.150
     2.768    85.280     0.150
     3.063    55.580     0.150
     3.063    84.480     0.150
     3.063    95.180     0.150
     3.168    98.380     0.150
     3.458    61.980     0.150
     3.458   106.480     0.150
     3.731   115.480     0.150
     4.018    70.880     0.150
     4.018   123.680     0.150
     4.073    71.380     0.150
     4.073   125.380     0.150
     4.995   135.080     0.150
     4.995   154.780     0.150
     5.270   138.880     0.150
     5.270   161.380     0.150
     0.206     4.305     0.150
     0.206     7.406     0.150
     0.767    14.805     0.150
     0.767    25.508     0.150
     0.997    19.008     0.150
     0.997    32.508     0.150
     0.999    19.008     0.150
     0.999    32.508     0.150
     1.045    19.406     0.150
     1.045    33.406     0.150
     1.033    19.406     0.150
     1.033    33.406     0.150
     1.034    19.406     0.150
     1.034    33.406     0.150
     1.358    25.711     0.150
     1.358    44.406     0.150
     1.509    28.109     0.150
     1.509    28.906     0.150
     1.509    48.609     0.150
     1.509    50.906     0.150
     1.614    30.305     0.150
     1.614    51.906     0.150
     1.766    32.406     0.150
     2.167    37.508     0.150
     2.167    69.109     0.150
     2.360    39.906     0.150
     2.360    42.109     0.150
     2.360    74.008     0.150
     2.573    43.008     0.150
     2.573    46.906     0.150
     2.573    74.609     0.150
     2.573    80.211     0.150
     2.737    49.508     0.150
     2.737    78.109     0.150
     2.737    85.211     0.150
     2.737    45.711     0.150
     2.737    49.109     0.150
     2.737    78.008     0.150
     2.737    85.109     0.150
     2.726    50.609     0.150
     2.726    85.305     0.150
     2.726    86.305     0.150
     3.193    57.109     0.150
     3.193    87.211     0.150
     3.193    97.406     0.150
     3.193    51.609     0.150
     3.193    99.406     0.150
     3.262    57.711     0.150
     3.262   102.305     0.150
     3.262    51.711     0.150
     3.262    59.508     0.150
     3.262    90.906     0.150
     3.262   101.211     0.150
     3.310    59.711     0.150
     3.310   103.711     0.150
     3.310    53.008     0.150
     3.557    64.305     0.150
     3.557   111.406     0.150
     3.827    60.305     0.150
     3.827    68.406     0.150
     3.827   103.406     0.150
     3.827   118.406     0.150
     3.908    62.508     0.150
     3.908   123.008     0.150
     3.908    62.711     0.150
     3.908    71.211     0.150
     3.908   122.109     0.150
     4.181    64.109     0.150
     4.181   112.508     0.150
     4.181   130.508     0.150
     4.181    64.508     0.150
     4.181    76.406     0.150
     4.181   111.609     0.150
     4.181   129.109     0.150
     4.248    76.508     0.150
     4.248   133.711     0.150
     4.248    77.008     0.150
     5.310    82.406     0.150
     5.310    96.109     0.150
     5.310   140.609     0.150
     5.310   164.609     0.150
     5.362    81.008     0.150
     5.362    97.211     0.150
     5.362   166.805     0.150
     6.773   210.305     0.150
     6.909   124.008     0.150
     6.909   177.805     0.150
     6.909   212.906     0.150
     0.352     6.417     0.150
     0.352    11.817     0.150
     0.471     9.217     0.150
     0.471    15.717     0.150
     0.984    17.717     0.150
     0.984    31.117     0.150
     1.375    24.717     0.150
     1.375    25.518     0.150
     1.375    44.417     0.150
     1.437    25.917     0.150
     1.437    45.317     0.150
     1.437    45.518     0.150
     1.719    31.217     0.150
     1.719    55.217     0.150
     1.809    57.817     0.150
     2.089    38.518     0.150
     2.089    66.617     0.150
     2.127    35.617     0.150
     2.127    37.817     0.150
     2.127    63.617     0.150
     2.127    66.217     0.150
     2.353    39.417     0.150
     2.353    42.018     0.150
     2.353    69.217     0.150
     2.353    73.018     0.150
     2.717    44.917     0.150
     2.717    49.717     0.150
     2.717    76.617     0.150
     2.717    84.817     0.150
     2.793    49.417     0.150
     2.793    85.617     0.150
     2.880    46.217     0.150
     2.880    52.217     0.150
     2.880    90.018     0.150
     3.421    54.417     0.150
     3.421    60.917     0.150
     3.421    95.917     0.150
     3.421   104.417     0.150
     3.495    63.217     0.150
     3.495   109.018     0.150
     3.495   109.317     0.150
     3.643    64.817     0.150
     3.643    97.217     0.150
     3.643   112.617     0.150
     3.954    62.617     0.150
     3.954   120.917     0.150
     3.954    60.617     0.150
     3.954    69.817     0.150
     3.954   120.617     0.150
     4.451    68.817     0.150
     4.451    82.217     0.150
     4.451   139.917     0.150
     4.576    68.617     0.150
     4.576    81.317     0.150
     4.576   119.417     0.150
     4.576   140.117     0.150
     4.864    85.717     0.150
     4.864   149.317     0.150
     4.864    85.217     0.150
     4.864   128.817     0.150
     4.864   148.817     0.150
     5.162   160.617     0.150
     5.256    81.917     0.150
     5.256   141.317     0.150
     5.256   162.617     0.150
     5.354   165.417     0.150
     6.598   203.417     0.150
     0.296     5.160     0.150
     0.296     9.363     0.150
     0.560    10.762     0.150
     0.560    18.660     0.150
     1.123    20.363     0.150
     1.123    20.762     0.150
     1.123    35.660     0.150
     1.250    22.961     0.150
     1.250    40.461     0.150
     1.250    39.863     0.150
     1.575    29.062     0.150
     1.575    50.363     0.150
     1.804    32.262     0.150
     1.804    56.660     0.150
     2.142    38.562     0.150
     2.142    67.660     0.150
     2.368    39.262     0.150
     2.368    42.160     0.150
     2.368    67.461     0.150
     2.368    73.762     0.150
     2.368    43.062     0.150
     2.368    74.062     0.150
     2.503    41.160     0.150
     2.503    44.961     0.150
     2.503    72.461     0.150
     2.503    77.262     0.150
     2.503    78.062     0.150
     2.620    80.961     0.150
     2.644    43.961     0.150
     2.644    47.863     0.150
     2.644    75.160     0.150
     2.644    81.961     0.150
     2.644    78.961     0.150
     3.155    49.762     0.150
     3.155    56.160     0.150
     3.155    87.863     0.150
     3.155    97.961     0.150
     3.155    50.461     0.150
     3.155    56.562     0.150
     3.155    98.062     0.150
     3.225    51.062     0.150
     3.225    59.160     0.150
     3.225    99.961     0.150
     3.225    58.160     0.150
     3.454    53.562     0.150
     3.454    63.160     0.150
     3.454    94.262     0.150
     3.454   106.762     0.150
     3.454    54.160     0.150
     3.454    61.762     0.150
     3.454   106.461     0.150
     3.795    59.262     0.150
     3.795    68.363     0.150
     3.795   117.262     0.150
     3.864    68.461     0.150
     3.864   105.562     0.150
     3.864   119.762     0.150
     4.212    75.863     0.150
     4.212   132.363     0.150
     4.384    67.160     0.150
     4.384    79.160     0.150
     4.384   116.762     0.150
     4.384   134.762     0.150
     4.384    66.262     0.150
     4.384    78.363     0.150
     4.713    73.863     0.150
     4.713    84.762     0.150
     5.161    79.961     0.150
     5.161   136.961     0.150
     5.161   160.363     0.150
     5.392    96.363     0.150
     5.392   167.660     0.150
     5.627    83.660     0.150
     5.627   100.461     0.150
     5.627   173.062     0.150
     6.817   124.562     0.150
     6.817   210.363     0.150
     7.027   124.863     0.150
     7.027   181.762     0.150
     7.027   217.160     0.150
     0.118     3.159     0.150
     0.118     5.759     0.150
     0.669    13.159     0.150
     0.669    22.259     0.150
     0.906    15.958     0.150
     0.906    28.159     0.150
     1.166    21.859     0.150
     1.166    38.259     0.150
     1.247    22.458     0.150
     1.247    39.559     0.150
     1.467    26.359     0.150
     1.467    46.859     0.150
     1.741    32.159     0.150
     1.741    54.159     0.150
     1.782    33.259     0.150
     1.782    56.159     0.150
     1.976    33.659     0.150
     1.976    35.359     0.150
     1.976    62.259     0.150
     2.167    38.159     0.150
     2.167    67.659     0.150
     2.345    73.859     0.150
     2.511    40.759     0.150
     2.511    45.759     0.150
     2.511    78.458     0.150
     2.718    43.659     0.150
     2.718    49.359     0.150
     2.718    76.458     0.150
     2.718    84.359     0.150
     2.978    46.458     0.150
     2.978    53.659     0.150
     2.978    92.159     0.150
     3.296    59.159     0.150
     3.296   102.659     0.150
     3.442    53.458     0.150
     3.442    62.759     0.150
     3.442   107.059     0.150
     3.654    65.159     0.150
     3.654   113.958     0.150
     4.012    72.259     0.150
     4.012   125.259     0.150
     4.337    78.159     0.150
     4.337   134.559     0.150
     4.929    89.958     0.150
     4.929   152.359     0.150
     5.367    82.159     0.150
     5.367   165.159     0.150
     0.258     4.949     0.150
     0.258     8.352     0.150
     0.548    11.352     0.150
     0.548    18.449     0.150
     0.548    18.551     0.150
     1.060    19.750     0.150
     1.060    34.551     0.150
     1.060    19.449     0.150
     1.038    20.148     0.150
     1.038    34.449     0.150
     1.162    21.949     0.150
     1.162    37.352     0.150
     1.314    24.250     0.150
     1.314    24.148     0.150
     1.314    41.648     0.150
     1.314    43.949     0.150
     1.582    28.852     0.150
     1.582    50.352     0.150
     1.621    30.449     0.150
     1.621    52.449     0.150
     1.621    29.852     0.150
     1.621    51.551     0.150
     1.650    29.648     0.150
     1.650    30.852     0.150
     1.650    53.051     0.150
     1.882    32.449     0.150
     1.882    34.051     0.150
     1.882    59.148     0.150
     2.218    37.148     0.150
     2.218    40.051     0.150
     2.218    64.250     0.150
     2.218    69.750     0.150
     2.292    40.648     0.150
     2.292    71.750     0.150
     2.292    38.148     0.150
     2.292    70.750     0.150
     2.569    45.949     0.150
     2.569    78.648     0.150
     2.569    41.852     0.150
     2.569    45.648     0.150
     2.569    72.148     0.150
     2.569    75.148     0.150
     2.574    42.449     0.150
     2.574    47.148     0.150
     2.574    74.449     0.150
     2.574    80.148     0.150
     2.574    46.449     0.150
     2.574    73.449     0.150
     2.574    79.750     0.150
     2.683    47.949     0.150
     2.683    83.250     0.150
     2.683    48.449     0.150
     2.683    75.949     0.150
     3.077    54.352     0.150
     3.077    95.352     0.150
     3.077    49.250     0.150
     3.293   102.289     0.150
     3.293    53.148     0.150
     3.293    52.449     0.150
     3.293    58.449     0.150
     3.293   100.949     0.150
     3.436    53.352     0.150
     3.436    60.949     0.150
     3.436   106.352     0.150
     3.436    62.949     0.150
     3.436   106.250     0.150
     3.447    62.551     0.150
     3.447   108.648     0.150
     3.447    62.051     0.150
     3.447   106.148     0.150
     3.791    66.352     0.150
     3.791   115.750     0.150
     3.791    58.648     0.150
     3.791    66.250     0.150
     3.791    68.449     0.150
     3.791   116.949     0.150
     3.856    69.551     0.150
     3.856    60.352     0.150
     3.856    68.449     0.150
     3.856   117.648     0.150
     4.138    63.750     0.150
     4.138    73.949     0.150
     4.138   109.648     0.150
     4.138   128.949     0.150
     4.165    63.949     0.150
     4.165    75.250     0.150
     4.165   110.250     0.150
     4.165   129.949     0.150
     4.287    66.949     0.150
     4.287    76.852     0.150
     4.287   132.852     0.150
     4.287    66.750     0.150
     4.287   114.750     0.150
     4.411    65.750     0.150
     4.411    79.750     0.150
     4.411   115.352     0.150
     4.411   136.949     0.150
     4.411    79.449     0.150
     4.411   116.148     0.150
     4.411   135.648     0.150
     4.773    75.449     0.150
     4.773    84.449     0.150
     4.773   127.148     0.150
     4.773    75.250     0.150
     4.773   147.750     0.150
     5.209    95.551     0.150
     5.209    79.750     0.150
     5.209   138.148     0.150
     5.209   160.648     0.150
     5.512    83.391     0.150
     5.549    81.949     0.150
     5.549    98.949     0.150
     5.549   145.949     0.150
     5.549    99.352     0.150
     5.549   169.449     0.150
     6.744    99.551     0.150
     6.744   120.648     0.150
     6.744    99.250     0.150
     6.744   209.449     0.150
     6.970   101.949     0.150
     6.970   215.148     0.150
     7.459   109.852     0.150
     7.459   192.852     0.150
     7.459   229.852     0.150
     8.222   117.129     0.150
     8.222   206.129     0.150
     8.222   256.504     0.150
    13.963   197.629     0.150
    13.963   354.398     0.150
    14.332   203.047     0.150
    15.076   219.051     0.150
    17.882   250.426     0.150
    20.488   276.699     0.150
    20.488   276.551     0.150
    22.269   296.648     0.150
    22.624   301.738     0.150
    23.395   308.109     0.150
    35.541   417.602     0.150
    42.230   472.324     0.150
    42.230   473.051     0.150
    48.921   526.398     0.150
    59.702   602.645     0.150
    76.344   709.160     0.150
    79.807   728.449     0.150
     0.215     4.519     0.150
     0.215     7.919     0.150
     0.982    17.619     0.150
     0.982    31.019     0.150
     1.121    21.818     0.150
     1.121    37.119     0.150
     1.236    22.919     0.150
     1.236    39.919     0.150
     1.395    25.818     0.150
     1.395    44.818     0.150
     1.664    30.318     0.150
     1.664    51.019     0.150
     1.734    33.019     0.150
     1.734    56.719     0.150
     1.960    32.919     0.150
     1.960    35.519     0.150
     1.960    61.619     0.150
     2.209    36.019     0.150
     2.209    38.818     0.150
     2.209    63.818     0.150
     2.209    68.219     0.150
     2.302    41.419     0.150
     2.500    44.719     0.150
     2.500    71.719     0.150
     2.500    77.818     0.150
     2.657    42.619     0.150
     2.657    46.519     0.150
     2.657    74.318     0.150
     2.657    81.818     0.150
     2.763    86.818     0.150
     2.997    53.318     0.150
     2.997    93.019     0.150
     3.395    53.318     0.150
     3.395    59.519     0.150
     3.395   103.818     0.150
     3.375    60.119     0.150
     3.375    90.719     0.150
     3.375   105.919     0.150
     3.707    65.219     0.150
     3.707   113.719     0.150
     3.934    62.318     0.150
     3.934    70.818     0.150
     3.934   122.619     0.150
     4.418    78.219     0.150
     4.418   137.719     0.150
     4.370   137.219     0.150
     4.850   149.519     0.150
     5.277    80.219     0.150
     5.277    93.919     0.150
     5.277   139.019     0.150
     5.277   162.619     0.150
     5.468   169.519     0.150
     0.235     5.625     0.150
     0.235     9.926     0.150
     0.630    11.426     0.150
     0.630    20.125     0.150
     0.872    16.426     0.150
     0.872    28.426     0.150
     1.429    25.824     0.150
     1.429    45.426     0.150
     1.469    25.926     0.150
     1.469    46.023     0.150
     1.743    29.324     0.150
     1.743    30.824     0.150
     1.743    51.723     0.150
     1.743    53.824     0.150
     1.920    31.523     0.150
     1.920    33.324     0.150
     1.920    59.523     0.150
     1.949    35.625     0.150
     1.949    60.324     0.150
     2.046    64.723     0.150
     2.203    36.125     0.150
     2.203    38.824     0.150
     2.203    61.824     0.150
     2.203    68.523     0.150
     2.366    42.023     0.150
     2.366    73.324     0.150
     3.102    47.926     0.150
     3.102    55.426     0.150
     3.102    82.824     0.150
     3.102    95.324     0.150
     4.285    63.824     0.150
     4.285    76.523     0.150
     4.285   131.926     0.150
     0.247     5.414     0.150
     0.247     9.617     0.150
     0.920    16.215     0.150
     0.920    28.914     0.150
     0.985    18.316     0.150
     0.985    32.016     0.150
     1.105    20.316     0.150
     1.105    35.715     0.150
     1.557    27.414     0.150
     1.624    30.016     0.150
     1.835    33.117     0.150
     1.835    33.414     0.150
     1.835    58.016     0.150
     2.289    37.215     0.150
     2.289    39.715     0.150
     2.289    70.617     0.150
     2.294    41.316     0.150
     2.294    71.914     0.150
     2.736    84.316     0.150
     2.778    84.715     0.150
     2.916    91.117     0.150
     3.028    52.414     0.150
     3.028    92.914     0.150
     3.167    50.414     0.150
     3.167    55.117     0.150
     3.167    97.117     0.150
     3.522   109.816     0.150
     4.100   126.816     0.150
     4.376    78.215     0.150
     4.376   135.414     0.150
     0.094     4.765     0.150
     0.094     7.665     0.150
     0.698    13.564     0.150
     0.698    23.365     0.150
     0.698    22.965     0.150
     0.923    16.365     0.150
     0.923    28.965     0.150
     1.135    21.064     0.150
     1.135    37.765     0.150
     1.203    22.064     0.150
     1.203    38.564     0.150
     1.452    26.064     0.150
     1.452    46.064     0.150
     1.452    25.265     0.150
     1.452    45.865     0.150
     1.662    30.165     0.150
     1.662    51.865     0.150
     1.934    32.665     0.150
     1.934    34.465     0.150
     1.934    61.064     0.150
     2.203    35.564     0.150
     2.203    38.265     0.150
     2.203    67.564     0.150
     2.203    37.965     0.150
     2.203    63.265     0.150
     2.203    66.765     0.150
     2.313    41.564     0.150
     2.313    72.365     0.150
     2.561    40.865     0.150
     2.561    44.765     0.150
     2.561    77.765     0.150
     2.561    44.965     0.150
     2.561    72.564     0.150
     2.561    78.965     0.150
     2.695    42.265     0.150
     2.695    47.965     0.150
     2.695    73.765     0.150
     2.695    83.965     0.150
     2.823    88.965     0.150
     2.823    87.064     0.150
     3.022    47.165     0.150
     3.022    52.765     0.150
     3.022    91.865     0.150
     3.022    52.865     0.150
     3.022    92.265     0.150
     3.274    49.564     0.150
     3.274    56.965     0.150
     3.274    99.564     0.150
     3.274    59.465     0.150
     3.274    99.265     0.150
     3.387    60.265     0.150
     3.387   105.064     0.150
     3.423    60.765     0.150
     3.423   105.765     0.150
     3.683    56.865     0.150
     3.683    64.564     0.150
     3.683   112.765     0.150
     3.999    70.965     0.150
     3.999   123.265     0.150
     3.999   122.665     0.150
     4.292    63.265     0.150
     4.292    76.465     0.150
     4.292   132.465     0.150
     4.292    62.965     0.150
     4.292    76.865     0.150
     4.292   131.465     0.150
     4.918    75.265     0.150
     4.918    86.965     0.150
     4.918   131.265     0.150
     5.215    77.665     0.150
     5.366    80.865     0.150
     6.821    98.465     0.150
     6.821   121.165     0.150
     6.821   175.965     0.150
     0.212     5.322     0.150
     0.212     9.223     0.150
     0.918    16.121     0.150
     0.918    27.422     0.150
     0.949    17.322     0.150
     0.949    30.322     0.150
     1.110    19.822     0.150
     1.110    34.822     0.150
     1.143    21.021     0.150
     1.143    36.422     0.150
     1.539    27.521     0.150
     1.539    47.422     0.150
     1.842    32.521     0.150
     1.842    57.422     0.150
     2.280    37.021     0.150
     2.280    39.621     0.150
     2.280    70.223     0.150
     2.753    48.121     0.150
     2.753    74.223     0.150
     2.753    83.521     0.150
     3.059    47.822     0.150
     3.059    54.021     0.150
     3.059    82.121     0.150
     3.059    92.521     0.150
     3.151    49.422     0.150
     3.151    55.322     0.150
     3.151    96.621     0.150
     3.715    56.521     0.150
     3.715    66.723     0.150
     3.715   114.121     0.150
     4.025    60.223     0.150
     4.025    70.322     0.150
     4.025   106.723     0.150
     4.025   123.822     0.150
     0.328     6.258     0.150
     0.328    11.355     0.150
     1.182    21.258     0.150
     1.182    37.559     0.150
     1.700    28.855     0.150
     1.700    29.758     0.150
     1.700    53.059     0.150
     1.701    29.457     0.150
     1.701    30.355     0.150
     1.701    53.355     0.150
     1.715    53.156     0.150
     2.058    33.758     0.150
     2.058    36.355     0.150
     2.058    63.656     0.150
     2.212    37.059     0.150
     2.212    38.855     0.150
     2.212    68.957     0.150
     2.315    40.656     0.150
     2.315    70.656     0.150
     2.430    39.656     0.150
     2.430    42.758     0.150
     2.430    76.156     0.150
     2.608    46.059     0.150
     2.608    80.156     0.150
     2.828    49.059     0.150
     2.828    86.355     0.150
     3.124    48.758     0.150
     3.124    54.855     0.150
     3.124    57.156     0.150
     3.124    95.656     0.150
     3.290    50.855     0.150
     3.290    58.957     0.150
     3.290   101.957     0.150
     4.158    74.758     0.150
     4.158   128.660     0.150
     6.217   111.457     0.150
     6.217   190.660     0.150
     0.206     4.168     0.150
     0.206     7.066     0.150
     0.598    11.867     0.150
     0.598    19.867     0.150
     0.598    20.168     0.150
     1.020    17.770     0.150
     1.020    31.566     0.150
     1.353    24.566     0.150
     1.353    43.066     0.150
     1.353    24.867     0.150
     1.353    43.168     0.150
     1.353    44.066     0.150
     1.640    29.969     0.150
     1.640    30.367     0.150
     1.890    32.668     0.150
     1.890    34.367     0.150
     1.890    60.168     0.150
     2.241    40.367     0.150
     2.241    70.270     0.150
     2.269    37.566     0.150
     2.269    39.566     0.150
     2.269    64.867     0.150
     2.269    40.367     0.150
     2.269    65.066     0.150
     2.269    69.969     0.150
     2.573    45.469     0.150
     2.573    72.668     0.150
     2.573    79.168     0.150
     2.573    45.270     0.150
     2.573    72.770     0.150
     2.606    42.066     0.150
     2.606    45.770     0.150
     2.606    74.168     0.150
     2.606    80.469     0.150
     2.606    42.367     0.150
     2.606    46.770     0.150
     2.606    74.270     0.150
     2.606    80.367     0.150
     2.723    49.168     0.150
     2.723    83.668     0.150
     2.723    43.469     0.150
     2.723    48.469     0.150
     2.723    84.668     0.150
     3.065    48.770     0.150
     3.065    53.969     0.150
     3.065    84.969     0.150
     3.065    93.668     0.150
     3.065    53.770     0.150
     3.065    94.867     0.150
     3.329    52.168     0.150
     3.329    59.770     0.150
     3.329   103.969     0.150
     3.329    52.270     0.150
     3.329    59.668     0.150
     3.329   102.367     0.150
     3.384    51.867     0.150
     3.384    61.566     0.150
     3.384   103.066     0.150
     3.384    52.066     0.150
     3.384    93.566     0.150
     3.384   103.168     0.150
     3.435    61.469     0.150
     3.435   104.867     0.150
     3.435   106.867     0.150
     3.762    58.867     0.150
     3.762    67.770     0.150
     3.762   116.367     0.150
     3.898    61.066     0.150
     3.898    71.270     0.150
     3.898   119.469     0.150
     3.898    60.566     0.150
     3.898    68.969     0.150
     3.898   119.270     0.150
     4.115    73.469     0.150
     4.115   127.566     0.150
     4.115   129.367     0.150
     4.313    66.566     0.150
     4.313    78.367     0.150
     4.313    66.367     0.150
     4.313    78.168     0.150
     4.313   134.770     0.150
     4.368    65.066     0.150
     4.368    77.770     0.150
     4.368   115.566     0.150
     4.368   134.270     0.150
     4.368    78.969     0.150
     4.368   116.066     0.150
     4.368   135.770     0.150
     4.815    73.668     0.150
     4.815    86.367     0.150
     4.815   147.469     0.150
     4.815    74.168     0.150
     4.815    85.367     0.150
     4.815   147.770     0.150
     5.256    80.770     0.150
     5.256    79.770     0.150
     5.256   139.367     0.150
     5.256   162.668     0.150
     5.291    94.270     0.150
     5.291   161.168     0.150
     5.291    96.867     0.150
     5.291   166.066     0.150
     5.536    82.367     0.150
     5.536    98.668     0.150
     5.536   145.867     0.150
     5.536   170.270     0.150
     6.714    99.668     0.150
     6.714   208.270     0.150
     6.926   100.367     0.150
     6.926   122.469     0.150
     6.926   212.270     0.150
     0.259     6.343     0.150
     0.259    10.143     0.150
     0.259    10.643     0.150
     0.648    12.343     0.150
     0.648    21.443     0.150
     1.025    18.243     0.150
     1.025    32.143     0.150
     1.163    20.743     0.150
     1.163    35.743     0.150
     1.407    24.443     0.150
     1.407    42.443     0.150
     1.407    42.943     0.150
     1.463    27.243     0.150
     1.463    46.243     0.150
     1.482    27.843     0.150
     1.482    45.743     0.150
     1.821    31.143     0.150
     1.821    32.343     0.150
     1.821    55.143     0.150
     2.313    37.643     0.150
     2.313    42.143     0.150
     2.313    67.243     0.150
     2.370    44.143     0.150
     2.370    75.143     0.150
     2.370    67.943     0.150
     2.370    75.243     0.150
     2.529    40.443     0.150
     2.529    70.843     0.150
     2.529    77.043     0.150
     2.622    42.343     0.150
     2.622    46.443     0.150
     2.622    73.943     0.150
     2.622    79.743     0.150
     3.004    46.343     0.150
     3.004    52.343     0.150
     3.004    82.543     0.150
     3.004    90.843     0.150
     3.229    50.243     0.150
     3.229    56.943     0.150
     3.229    98.243     0.150
     3.527    62.643     0.150
     3.527    62.743     0.150
     3.527    96.743     0.150
     3.527   107.743     0.150
     3.609   111.543     0.150
     3.822    56.843     0.150
     3.822    68.043     0.150
     3.822    99.743     0.150
     3.822   117.143     0.150
     4.056    62.043     0.150
     4.056    72.543     0.150
     4.056   106.643     0.150
     4.056   125.343     0.150
     4.065    73.843     0.150
     4.437    70.143     0.150
     4.437    78.143     0.150
     4.437   118.643     0.150
     4.437   135.543     0.150
     4.712    68.643     0.150
     4.712    84.543     0.150
     4.712   144.943     0.150
     4.837    73.643     0.150
     4.837   128.143     0.150
     0.302     6.429     0.150
     0.302    10.829     0.150
     0.533    10.929     0.150
     0.533    18.029     0.150
     0.929    16.629     0.150
     0.929    28.729     0.150
     1.243    23.429     0.150
     1.243    40.429     0.150
     1.379    25.429     0.150
     1.379    44.129     0.150
     1.479    26.829     0.150
     1.479    47.329     0.150
     1.793    32.029     0.150
     1.793    55.329     0.150
     2.095    35.129     0.150
     2.095    36.829     0.150
     2.095    64.629     0.150
     2.099    35.929     0.150
     2.099    38.129     0.150
     2.099    66.129     0.150
     2.354    39.529     0.150
     2.354    42.429     0.150
     2.354    71.229     0.150
     2.754    44.429     0.150
     2.754    49.529     0.150
     2.754    77.929     0.150
     2.754    85.229     0.150
     2.839    87.029     0.150
     2.863    52.029     0.150
     2.863    89.529     0.150
     3.434    62.829     0.150
     3.462    61.829     0.150
     3.462    94.429     0.150
     3.462   106.129     0.150
     3.605    56.329     0.150
     3.605    62.229     0.150
     3.605   110.429     0.150
     4.002    71.629     0.150
     4.002   122.429     0.150
     4.482   141.029     0.150
     5.127    93.329     0.150
     5.127   161.029     0.150
     5.312    81.329     0.150
     5.312   141.929     0.150
     5.312   164.829     0.150
     5.336   164.529     0.150
     6.844   121.429     0.150
     6.844   211.629     0.150
     0.245     4.531     0.150
     0.245     8.336     0.150
     0.245     5.031     0.150
     0.245     8.938     0.150
     0.641    12.438     0.150
     0.641    22.234     0.150
     1.308    23.836     0.150
     1.308    23.734     0.150
     1.308    41.336     0.150
     1.642    28.438     0.150
     1.642    28.938     0.150
     1.642    50.938     0.150
     1.642    51.234     0.150
     1.642    28.836     0.150
     1.785    30.938     0.150
     1.785    31.938     0.150
     1.785    56.336     0.150
     1.820    32.938     0.150
     1.820    57.938     0.150
     2.175    35.734     0.150
     2.175    38.336     0.150
     2.175    62.336     0.150
     2.175    67.031     0.150
     2.307    38.133     0.150
     2.307    40.938     0.150
     2.307    72.031     0.150
     2.327    38.438     0.150
     2.327    41.234     0.150
     2.327    71.633     0.150
     2.327    72.133     0.150
     2.510    40.938     0.150
     2.510    44.336     0.150
     2.510    78.734     0.150
     2.574    45.836     0.150
     2.574    79.438     0.150
     2.574    45.133     0.150
     2.574    79.336     0.150
     2.715    42.234     0.150
     2.715    46.938     0.150
     2.715    82.938     0.150
     2.715    42.836     0.150
     2.715    47.133     0.150
     2.715    76.531     0.150
     2.912    91.031     0.150
     3.399    52.734     0.150
     3.399    60.938     0.150
     3.399    91.531     0.150
     3.399   105.438     0.150
     3.399    91.133     0.150
     3.399   106.133     0.150
     3.454   107.836     0.150
     3.546   110.031     0.150
     4.136    62.531     0.150
     4.136    73.336     0.150
     4.136   108.234     0.150
     4.136   125.938     0.150
     4.136    74.531     0.150
     4.136   110.531     0.150
     4.136   127.633     0.150
     4.576    81.938     0.150
     4.576   140.734     0.150
     4.724    71.836     0.150
     4.724    85.234     0.150
     4.724   126.031     0.150
     4.724   146.938     0.150
     4.987    88.531     0.150
     4.987   153.734     0.150
     5.058    89.633     0.150
     5.058   158.031     0.150
     5.643    85.531     0.150
     5.643   148.336     0.150
     5.643    84.836     0.150
     5.643   100.336     0.150
     5.969   106.836     0.150
     5.969   184.031     0.150
     6.096    89.438     0.150
     6.096   108.133     0.150
     6.096   157.836     0.150
     6.096   187.336     0.150
     6.082    90.031     0.150
     6.082   157.133     0.150
     6.082   187.438     0.150
     0.347     6.207     0.150
     0.347    10.809     0.150
     0.347     6.707     0.150
     0.347    11.910     0.150
     0.503    10.008     0.150
     0.503    10.609     0.150
     0.503    18.109     0.150
     1.710    29.809     0.150
     1.710    52.207     0.150
     1.710    30.008     0.150
     1.710    53.008     0.150
     1.687    29.410     0.150
     1.687    30.309     0.150
     1.687    53.508     0.150
     1.695    30.707     0.150
     1.695    54.609     0.150
     2.034    35.508     0.150
     2.034    62.008     0.150
     2.034    33.609     0.150
     2.034    36.910     0.150
     2.034    63.707     0.150
     2.195    36.508     0.150
     2.195    68.809     0.150
     2.245    40.207     0.150
     2.245    70.707     0.150
     2.245    36.809     0.150
     2.245    40.309     0.150
     2.245    70.910     0.150
     2.308    40.410     0.150
     2.308    70.309     0.150
     2.308    37.309     0.150
     2.308    67.809     0.150
     2.308    70.809     0.150
     2.417    39.410     0.150
     2.417    42.809     0.150
     2.417    76.109     0.150
     2.612    46.109     0.150
     2.612    79.809     0.150
     2.612    42.109     0.150
     2.612    72.809     0.150
     2.612    80.410     0.150
     2.855    48.008     0.150
     2.855    85.910     0.150
     2.855    45.109     0.150
     2.855    51.008     0.150
     2.855    78.910     0.150
     2.855    87.410     0.150
     2.959    52.809     0.150
     2.959    91.809     0.150
     3.139    55.809     0.150
     3.139    97.410     0.150
     3.139    49.508     0.150
     3.139    57.109     0.150
     3.139    86.809     0.150
     3.139    97.707     0.150
     3.269    50.809     0.150
     3.269    88.508     0.150
     3.269   102.008     0.150
     3.405    52.207     0.150
     3.405    61.309     0.150
     3.405    92.910     0.150
     3.405   106.008     0.150
     3.405    59.809     0.150
     3.405   104.008     0.150
     3.538    55.508     0.150
     3.538    65.207     0.150
     3.538   110.109     0.150
     3.538    63.109     0.150
     3.538   110.508     0.150
     4.002    60.707     0.150
     4.002    71.309     0.150
     4.002   123.207     0.150
     4.002    71.609     0.150
     4.002   123.508     0.150
     4.677    69.910     0.150
     4.677    83.207     0.150
     4.677   144.008     0.150
     4.677    70.309     0.150
     4.677    84.109     0.150
     4.677   144.707     0.150
     4.942    87.809     0.150
     4.942   154.008     0.150
     5.045    89.508     0.150
     5.045   154.109     0.150
     5.499    83.008     0.150
     5.499    98.910     0.150
     5.499   144.410     0.150
     5.499    83.109     0.150
     5.930    88.707     0.150
     5.930   154.508     0.150
     5.930   154.910     0.150
     5.930   182.707     0.150
     6.079    88.910     0.150
     6.079   107.910     0.150
     6.079   188.109     0.150
     6.242   110.707     0.150
     6.242   191.707     0.150
     0.108     4.121     0.150
     0.108     7.223     0.150
     0.108     3.320     0.150
     0.108     6.820     0.150
     0.807    14.922     0.150
     0.807    26.621     0.150
     1.440    25.621     0.150
     1.440    44.121     0.150
     1.440    25.520     0.150
     1.492    26.422     0.150
     1.492    46.723     0.150
     1.492    25.621     0.150
     1.492    46.621     0.150
     1.954    35.020     0.150
     1.954    58.922     0.150
     1.954    60.922     0.150
     2.246    39.723     0.150
     2.246    69.422     0.150
     2.246    39.520     0.150
     2.246    69.621     0.150
     2.340    37.621     0.150
     2.340    41.922     0.150
     2.443    39.020     0.150
     2.443    43.723     0.150
     2.443    75.223     0.150
     2.443    39.121     0.150
     2.443    42.922     0.150
     2.443    75.121     0.150
     2.643    45.320     0.150
     2.643    71.020     0.150
     2.643    82.223     0.150
     2.643    40.820     0.150
     2.643    45.621     0.150
     2.643    80.320     0.150
     2.677    42.922     0.150
     2.677    48.223     0.150
     2.677    83.621     0.150
     2.773    85.820     0.150
     2.869    45.223     0.150
     2.869    51.320     0.150
     2.869    88.121     0.150
     3.292   103.121     0.150
     3.569    62.223     0.150
     3.569   109.520     0.150
     3.711   114.020     0.150
     3.711    65.320     0.150
     3.711   114.422     0.150
     4.305    78.723     0.150
     4.305   131.520     0.150
     4.408    79.922     0.150
     4.408    79.723     0.150
     4.840    85.723     0.150
     4.840   147.121     0.150
     4.888   149.020     0.150
     5.798   103.723     0.150
     5.935   105.621     0.150
     5.935   105.020     0.150
     6.233    92.820     0.150
     6.233    92.422     0.150
    10.198   147.621     0.150
     0.328     6.604     0.150
     0.328    11.104     0.150
     0.456     8.805     0.150
     0.456    15.305     0.150
     0.620    12.404     0.150
     0.761    15.104     0.150
     0.761    25.703     0.150
     0.895    16.703     0.150
     0.895    28.604     0.150
     1.079    20.305     0.150
     1.079    35.805     0.150
     1.079    20.203     0.150
     1.079    35.203     0.150
     1.303    23.404     0.150
     1.303    23.703     0.150
     1.303    41.305     0.150
     1.303    24.504     0.150
     1.303    41.703     0.150
     1.342    43.004     0.150
     1.607    29.305     0.150
     2.314    38.703     0.150
     2.314    41.703     0.150
     2.314    67.305     0.150
     2.314    71.404     0.150
     2.449    44.703     0.150
     2.449    76.203     0.150
     2.449    76.404     0.150
     2.569    42.104     0.150
     2.569    44.805     0.150
     2.569    71.604     0.150
     2.569    45.805     0.150
     2.569    80.104     0.150
     2.832    46.504     0.150
     2.832    50.904     0.150
     2.832    87.805     0.150
     3.043    48.604     0.150
     3.043    55.904     0.150
     3.043    94.805     0.150
     3.043    54.504     0.150
     3.043    95.104     0.150
     3.355    53.104     0.150
     3.355    60.004     0.150
     3.355   104.203     0.150
     3.526    64.104     0.150
     3.526    96.203     0.150
     3.526   110.104     0.150
     3.629    64.703     0.150
     3.629   110.604     0.150
     3.629    57.904     0.150
     3.629    65.104     0.150
     3.629   111.504     0.150
     3.629   114.504     0.150
     4.014    73.004     0.150
     4.014   125.904     0.150
     4.060    63.104     0.150
     4.060    71.904     0.150
     4.060    74.305     0.150
     4.060   125.604     0.150
     4.340    66.004     0.150
     4.340    77.203     0.150
     4.340   115.604     0.150
     4.340   133.904     0.150
     5.027    77.805     0.150
     5.027   155.904     0.150
     5.590    99.504     0.150
     5.590   171.703     0.150
     0.226     6.062     0.150
     0.226    10.062     0.150
     0.643    11.562     0.150
     0.643    19.367     0.150
     0.938    17.969     0.150
     0.938    31.266     0.150
     1.059    19.469     0.150
     1.059    33.469     0.150
     1.201    21.664     0.150
     1.201    37.664     0.150
     1.386    24.266     0.150
     1.386    41.867     0.150
     1.498    27.367     0.150
     1.498    46.367     0.150
     1.522    27.867     0.150
     1.522    48.562     0.150
     2.348    41.867     0.150
     2.348    71.867     0.150
     2.496    39.867     0.150
     2.496    43.367     0.150
     3.554    62.367     0.150
     3.554   107.867     0.150
     4.024    61.266     0.150
     4.024    70.867     0.150
     4.024   122.766     0.150
     4.101    72.469     0.150
     4.101   127.164     0.150
     0.311     6.711     0.150
     0.311    11.414     0.150
     0.540    10.812     0.150
     0.540    18.016     0.150
     0.540    18.211     0.150
     0.914    16.609     0.150
     0.914    28.914     0.150
     0.914    29.016     0.150
     1.265    24.016     0.150
     1.265    42.016     0.150
     1.499    26.914     0.150
     1.499    49.109     0.150
     1.499    27.312     0.150
     1.852    34.812     0.150
     2.073    35.109     0.150
     2.073    36.914     0.150
     2.073    64.516     0.150
     2.073    36.609     0.150
     2.073    61.016     0.150
     2.073    63.414     0.150
     2.121    36.109     0.150
     2.121    38.914     0.150
     2.121    67.312     0.150
     2.332    39.211     0.150
     2.332    42.312     0.150
     2.332    67.914     0.150
     2.332    72.609     0.150
     2.332    39.414     0.150
     2.332    41.609     0.150
     2.840    46.016     0.150
     2.840    50.711     0.150
     2.840    88.016     0.150
     2.840    50.516     0.150
     2.840    80.016     0.150
     2.775    45.211     0.150
     2.775    50.016     0.150
     2.775    85.914     0.150
     2.775    45.109     0.150
     2.775    79.109     0.150
     2.858    46.312     0.150
     2.858    50.516     0.150
     2.858    88.312     0.150
     2.858    44.812     0.150
     3.212    51.812     0.150
     3.212    58.711     0.150
     3.212   100.211     0.150
     3.212    51.711     0.150
     3.212   101.109     0.150
     3.431    53.109     0.150
     3.431    61.109     0.150
     3.431   106.211     0.150
     3.431   106.312     0.150
     3.483    54.711     0.150
     3.483    60.711     0.150
     3.483    62.609     0.150
     3.483   107.312     0.150
     3.483    62.312     0.150
     3.483   107.109     0.150
     3.917    70.109     0.150
     3.917   122.914     0.150
     4.536    67.812     0.150
     4.536    82.211     0.150
     4.536   119.609     0.150
     4.536   140.109     0.150
     4.536    81.016     0.150
     4.536   119.211     0.150
     4.536   140.211     0.150
     4.504    69.211     0.150
     4.504   141.609     0.150
     4.504    69.312     0.150
     4.931    76.312     0.150
     4.931    77.812     0.150
     4.931    89.516     0.150
     4.931   133.609     0.150
     4.931   152.109     0.150
     4.931    76.516     0.150
     4.931    89.812     0.150
     4.931   133.812     0.150
     4.931   151.516     0.150
     5.106    76.711     0.150
     5.106    92.516     0.150
     5.106   157.812     0.150
     5.106    76.609     0.150
     5.106    93.016     0.150
     5.313    79.312     0.150
     5.313   164.016     0.150
     5.313    78.016     0.150
     5.313    94.516     0.150
     5.313   163.312     0.150
     5.327    80.711     0.150
     5.327    82.109     0.150
     5.327   141.109     0.150
     5.327   164.812     0.150
     5.327    80.914     0.150
     5.327    96.312     0.150
     5.745    85.812     0.150
     5.745    85.594     0.150
     5.855    87.656     0.150
     5.855   157.070     0.150
     5.855   183.484     0.150
     6.539    96.516     0.150
     6.539   202.914     0.150
     6.539    97.312     0.150
     6.828    99.711     0.150
     6.828   211.211     0.150
     6.828    99.914     0.150
     7.400   108.609     0.150
     7.400   230.914     0.150
     7.565   112.211     0.150
     7.565   234.211     0.150
     8.232   116.516     0.150
     9.357   133.914     0.150
    14.093   197.109     0.150
    14.012   197.914     0.150
    14.012   436.586     0.150
    14.012   200.016     0.150
    14.493   204.312     0.150
    14.816   208.016     0.150
    15.315   222.812     0.150
    16.406   232.109     0.150
    16.406   408.812     0.150
    16.406   519.109     0.150
    16.759   239.812     0.150
    17.743   248.312     0.150
    17.743   444.812     0.150
    18.017   249.234     0.150
    18.017   251.414     0.150
    18.486   254.609     0.150
    18.486   254.250     0.150
    20.249   274.312     0.150
    22.608   299.172     0.150
    22.660   298.516     0.150
    22.864   305.109     0.150
    22.864   552.812     0.150
    22.864   596.312     0.150
    23.430   306.711     0.150
    24.235   316.109     0.150
    24.235   576.609     0.150
    24.235   581.812     0.150
    24.235   755.109     0.150
    24.472   318.914     0.150
    24.947   323.609     0.150
    24.947   322.805     0.150
    30.410   371.312     0.150
    30.537   375.812     0.150
    30.637   376.109     0.150
    30.886   378.109     0.150
    30.962   378.516     0.150
    31.601   384.312     0.150
    39.043   445.750     0.150
    39.289   448.016     0.150
    40.261   454.609     0.150
    42.142   471.586     0.150
    42.142   472.109     0.150
    46.377   504.891     0.150
    48.389   521.312     0.150
    48.389   521.234     0.150
    48.685   524.211     0.150
    50.871   542.016     0.150
    55.291   574.172     0.150
    59.463   601.359     0.150
    71.935   682.289     0.150
    76.503   709.672     0.150
    78.667   721.766     0.150
    89.234   775.766     0.150
    92.886   792.383     0.150
     0.751    13.699     0.150
     0.751    23.599     0.150
     0.751    13.899     0.150
     0.751    23.899     0.150
     0.752    14.599     0.150
     0.752    24.799     0.150
     0.752    24.899     0.150
     0.798    14.899     0.150
     0.798    26.000     0.150
     1.624    29.199     0.150
     1.624    30.000     0.150
     1.624    51.199     0.150
     1.624    52.399     0.150
     1.624    29.699     0.150
     1.900    33.099     0.150
     1.900    34.399     0.150
     1.900    60.500     0.150
     1.900    36.000     0.150
     1.900    61.099     0.150
     1.944    34.899     0.150
     1.944    36.899     0.150
     1.944    64.099     0.150
     2.127    36.799     0.150
     2.127    38.500     0.150
     2.127    67.500     0.150
     2.392    40.500     0.150
     2.392    43.099     0.150
     2.392    72.799     0.150
     2.392    73.399     0.150
     2.506    40.799     0.150
     2.506    45.399     0.150
     2.506    73.199     0.150
     2.506    79.099     0.150
     2.831    46.299     0.150
     2.831    50.399     0.150
     2.831    79.500     0.150
     2.831    88.000     0.150
     2.831    46.399     0.150
     2.831    51.599     0.150
     2.831    80.599     0.150
     2.879    46.500     0.150
     2.879    51.000     0.150
     2.879    82.399     0.150
     2.879    89.699     0.150
     2.879    52.299     0.150
     2.879    81.500     0.150
     2.879    89.599     0.150
     2.993    48.000     0.150
     2.993    54.299     0.150
     2.993    83.099     0.150
     2.993    92.799     0.150
     2.993    55.299     0.150
     2.993    83.299     0.150
     3.196    52.500     0.150
     3.196    57.599     0.150
     3.196    88.899     0.150
     3.196    99.799     0.150
     3.196   100.899     0.150
     3.213    50.500     0.150
     3.213    56.199     0.150
     3.213    89.099     0.150
     3.213    99.599     0.150
     3.213    57.699     0.150
     3.213    98.699     0.150
     3.492    55.199     0.150
     3.492    61.899     0.150
     3.492    97.399     0.150
     3.492   108.199     0.150
     3.602    56.199     0.150
     3.602    65.500     0.150
     3.602   113.000     0.150
     3.602    64.899     0.150
     3.602    99.000     0.150
     3.602   111.199     0.150
     3.853    60.699     0.150
     3.853    71.199     0.150
     3.853   121.599     0.150
     3.853    71.299     0.150
     3.853   120.199     0.150
     4.166    63.799     0.150
     4.166    65.199     0.150
     4.166    74.399     0.150
     4.166   114.199     0.150
     4.166   129.000     0.150
     4.345    65.500     0.150
     4.345    77.099     0.150
     4.345   133.199     0.150
     4.345    77.199     0.150
     4.345   116.299     0.150
     4.345   134.099     0.150
     4.581    70.599     0.150
     4.581    83.299     0.150
     4.581   119.500     0.150
     4.581   142.799     0.150
     4.581    83.699     0.150
     4.581   142.699     0.150
     5.023    75.699     0.150
     5.082    77.399     0.150
     5.082    90.099     0.150
     5.082   136.799     0.150
     5.082   157.399     0.150
     5.082    78.199     0.150
     5.082    90.799     0.150
     5.082   136.099     0.150
     5.296    78.099     0.150
     5.506    83.699     0.150
     5.506   147.500     0.150
     5.506   171.899     0.150
     5.506    84.399     0.150
     5.506   171.799     0.150
     5.679    85.369     0.150
     5.679   178.879     0.150
     5.805    87.319     0.150
     5.805   184.898     0.150
     6.443    95.699     0.150
     6.443   201.599     0.150
     6.443    95.099     0.150
     6.663    98.000     0.150
     6.663   206.299     0.150
     6.663   119.099     0.150
     6.663   172.599     0.150
     7.293   107.699     0.150
     7.293   229.000     0.150
     8.015   114.299     0.150
     8.038   249.199     0.150
    12.722   181.199     0.150
    12.722   325.500     0.150
    12.854   183.899     0.150
    14.033   197.599     0.150
    14.220   200.649     0.150
    14.321   202.399     0.150
    14.593   205.199     0.150
    14.925   208.899     0.150
    14.925   377.099     0.150
    15.028   210.299     0.150
    15.028   373.500     0.150
    16.884   241.299     0.150
    17.685   243.799     0.150
    17.685   250.799     0.150
    17.685   258.599     0.150
    18.185   250.199     0.150
    18.185   250.943     0.150
    18.684   255.599     0.150
    18.684   256.339     0.150
    22.564   298.500     0.150
    22.564   546.099     0.150
    22.799   305.799     0.150
    22.820   301.500     0.150
    22.820   554.599     0.150
    22.820   301.836     0.150
    22.871   302.500     0.150
    23.144   307.569     0.150
    23.636   313.299     0.150
    23.642   310.199     0.150
    24.056   315.699     0.150
    24.056   536.000     0.150
    24.056   573.899     0.150
    24.056   582.799     0.150
    24.056   980.299     0.150
    24.297   317.399     0.150
    24.392   320.500     0.150
    24.392   539.500     0.150
    25.114   324.699     0.150
    25.114   325.229     0.150
    27.190   345.299     0.150
    27.190   345.299     0.150
    28.503   355.299     0.150
    28.503   354.989     0.150
    30.369   372.399     0.150
    30.369   372.259     0.150
    30.321   371.000     0.150
    30.688   376.699     0.150
    30.920   376.799     0.150
    30.920   376.799     0.150
    30.942   379.299     0.150
    31.022   379.500     0.150
    31.173   381.199     0.150
    31.667   385.299     0.150
    36.656   426.500     0.150
    36.656   506.799     0.150
    39.235   447.459     0.150
    39.235   576.149     0.150
    39.497   450.599     0.150
    40.478   458.599     0.150
    40.478   558.000     0.150
    40.478   580.099     0.150
    40.478   823.500     0.150
    40.738   461.829     0.150
    41.941   470.000     0.150
    42.351   473.500     0.150
    43.186   481.500     0.150
    43.187   481.500     0.150
    43.187     4.500     0.150
    45.607   500.909     0.150
    46.595   507.674     0.150
    48.169   519.005     0.150
    48.592   522.899     0.150
    48.592   523.224     0.150
    48.665   524.899     0.150
    49.251   531.599     0.150
    50.179   535.149     0.150
    50.566   540.000     0.150
    50.567   539.299     0.150
    50.579   540.099     0.150
    51.084   544.299     0.150
    51.085   543.484     0.150
    51.232   545.000     0.150
    52.425   551.599     0.150
    53.231   559.699     0.150
    53.231     3.300     0.150
    53.242   559.899     0.150
    53.750   564.199     0.150
    53.798   564.188     0.150
    53.924   565.099     0.150
    53.944   565.099     0.150
    54.005   564.899     0.150
    54.146   565.299     0.150
    54.146     6.000     0.150
    54.323   567.500     0.150
    54.323     2.900     0.150
    54.342   567.399     0.150
    54.342     4.000     0.150
    55.240   572.199     0.150
    55.368   574.399     0.150
    55.506   575.562     0.150
    56.085   580.399     0.150
    56.085     4.000     0.150
    56.085   580.399     0.150
    56.085     4.000     0.150
    59.488   602.044     0.150
    60.688   612.799     0.150
    61.202   615.299     0.150
    61.207   615.500     0.150
    61.947   618.799     0.150
    61.970   619.000     0.150
    62.049   620.699     0.150
    63.146   626.849     0.150
    63.755   631.299     0.150
    66.060   646.599     0.150
    66.420   648.649     0.150
    66.727   651.359     0.150
    67.035   653.250     0.150
    67.460   655.520     0.150
    68.537   662.939     0.150
    69.105   665.179     0.150
    69.989   670.199     0.150
    70.063   669.609     0.150
    70.688   676.462     0.150
    70.688   676.790     0.150
    72.047   683.449     0.150
    72.445   686.169     0.150
    72.544   687.599     0.150
    72.799   688.500     0.150
    73.463   693.659     0.150
    73.590   693.079     0.150
    73.698   695.029     0.150
    73.820   695.699     0.150
    73.836   696.409     0.150
    74.017   694.489     0.150
    74.406   699.099     0.150
    74.453   699.509     0.150
    74.623   698.274     0.150
    75.421   705.020     0.150
    76.241   709.179     0.150
    76.323   710.399     0.150
    76.329   709.083     0.150
    76.332   709.199     0.150
    76.593   711.437     0.150
    78.669   722.399     0.150
    79.161   726.479     0.150
    79.800   728.899     0.150
    79.863   729.074     0.150
    83.559   749.909     0.150
    89.450   777.549     0.150
    92.887   794.250     0.150
   146.082  1178.361     0.150
   147.510  1183.000     0.150
   147.510  1184.599     0.150
   147.510  1186.699     0.150
   147.510  1190.299     0.150
   148.253  1184.099     0.150
   148.253  1185.000     0.150
   148.253  1187.000     0.150
   148.253  1190.799     0.150
   148.253  1194.899     0.150
   151.025  1192.074     0.150
     0.171     3.777     0.150
     0.171     6.676     0.150
     0.739    14.277     0.150
     0.739    24.277     0.150
     0.739    24.578     0.150
     0.761    13.676     0.150
     0.761    23.578     0.150
     0.761    13.777     0.150
     0.761    23.977     0.150
     0.795    14.676     0.150
     0.795    25.578     0.150
     1.392    25.375     0.150
     1.392    43.676     0.150
     1.392    46.078     0.150
     1.614    29.078     0.150
     1.614    50.977     0.150
     1.614    28.977     0.150
     1.614    29.477     0.150
     1.852    34.375     0.150
     1.852    58.875     0.150
     1.895    35.277     0.150
     2.013    34.477     0.150
     2.013    36.176     0.150
     2.013    62.277     0.150
     2.013    34.578     0.150
     2.013    35.777     0.150
     2.013    61.875     0.150
     2.389    40.375     0.150
     2.389    42.375     0.150
     2.389    72.578     0.150
     2.389    40.477     0.150
     2.389    72.875     0.150
     2.500    44.977     0.150
     2.500    78.477     0.150
     2.833    50.578     0.150
     2.833    87.578     0.150
     2.833    44.875     0.150
     2.833    50.375     0.150
     2.833    79.977     0.150
     2.833    88.078     0.150
     2.871    46.277     0.150
     2.871    51.477     0.150
     2.871    80.977     0.150
     2.871    88.578     0.150
     2.984    91.977     0.150
     2.984    53.477     0.150
     2.984    91.777     0.150
     3.198    57.777     0.150
     3.198   100.578     0.150
     3.227    50.477     0.150
     3.227    57.277     0.150
     3.227    88.477     0.150
     3.227    99.078     0.150
     3.227    89.176     0.150
     3.227    97.875     0.150
     3.499    54.875     0.150
     3.499    62.578     0.150
     3.499   107.477     0.150
     3.499   107.375     0.150
     3.593    57.578     0.150
     3.593    64.277     0.150
     3.593   110.777     0.150
     4.155    62.578     0.150
     4.155    73.375     0.150
     4.155   126.777     0.150
     4.155    75.078     0.150
     4.155   127.375     0.150
     4.356    66.676     0.150
     4.356    77.578     0.150
     4.356   133.777     0.150
     4.575    83.777     0.150
     4.575   143.277     0.150
     5.029    91.777     0.150
     5.029   157.477     0.150
     5.029    90.078     0.150
     5.029   155.676     0.150
     5.071    89.977     0.150
     5.071   138.176     0.150
     5.071   155.875     0.150
     5.298   140.578     0.150
     5.298   162.375     0.150
     5.494    85.477     0.150
     5.494    99.578     0.150
     5.494   146.176     0.150
     5.494   170.977     0.150
     5.494   171.375     0.150
     6.675    97.477     0.150
     6.675   205.977     0.150
     6.675    97.977     0.150
     6.675   118.977     0.150
     0.072     3.602     0.150
     0.072     6.500     0.150
     0.814    15.500     0.150
     0.814    27.500     0.150
     1.371    24.699     0.150
     1.371    43.402     0.150
     1.396    24.402     0.150
     1.396    43.500     0.150
     1.440    25.699     0.150
     1.440    46.402     0.150
     2.009    33.801     0.150
     2.009    35.602     0.150
     2.009    59.301     0.150
     2.009    63.199     0.150
     2.011    33.500     0.150
     2.011    36.000     0.150
     2.011    60.301     0.150
     2.011    64.000     0.150
     2.094    35.301     0.150
     2.094    65.199     0.150
     2.094    34.602     0.150
     2.094    37.102     0.150
     2.322    37.699     0.150
     2.322    40.602     0.150
     2.322    71.402     0.150
     2.322    40.500     0.150
     2.322    70.500     0.150
     2.331    37.699     0.150
     2.331    41.602     0.150
     2.331    71.602     0.150
     2.331    41.301     0.150
     2.331    72.602     0.150
     2.517    40.801     0.150
     2.517    44.699     0.150
     2.517    78.000     0.150
     2.566    80.902     0.150
     2.628    48.301     0.150
     2.628    84.102     0.150
     2.660    43.699     0.150
     2.660    48.402     0.150
     2.660    83.199     0.150
     2.660    47.699     0.150
     2.660    82.699     0.150
     2.739    43.602     0.150
     2.739    47.801     0.150
     2.739    50.199     0.150
     2.739    85.902     0.150
     2.779    43.102     0.150
     2.779    47.000     0.150
     2.779    76.199     0.150
     2.779    84.199     0.150
     2.779    48.902     0.150
     2.779    85.902     0.150
     2.817    44.301     0.150
     2.817    49.602     0.150
     2.817    50.602     0.150
     2.817    86.801     0.150
     3.218    56.801     0.150
     3.218    99.902     0.150
     3.218    59.402     0.150
     3.218    97.801     0.150
     3.579    54.902     0.150
     3.579    61.699     0.150
     3.579    94.402     0.150
     3.700   112.699     0.150
     3.700    65.500     0.150
     4.286    63.402     0.150
     4.286    76.500     0.150
     4.286   110.199     0.150
     4.286   131.699     0.150
     4.286    63.602     0.150
     4.286    76.301     0.150
     4.286   110.902     0.150
     4.286   131.102     0.150
     4.307    64.602     0.150
     4.307    76.699     0.150
     4.307   113.602     0.150
     4.738   145.402     0.150
     4.871    72.402     0.150
     4.871    87.301     0.150
     4.871   127.402     0.150
     4.871    73.402     0.150
     4.871   147.801     0.150
     5.262    78.500     0.150
     5.262    93.801     0.150
     5.262   138.602     0.150
     5.785    86.301     0.150
     5.785   102.301     0.150
     5.785   149.902     0.150
     5.968    86.602     0.150
     5.968   105.801     0.150
     5.968   104.902     0.150
     5.968   153.301     0.150
     6.184    91.602     0.150
     6.184   161.000     0.150
     0.338     6.883     0.150
     0.338    11.578     0.150
     0.824    15.477     0.150
     0.824    27.180     0.150
     0.928    16.578     0.150
     0.928    28.781     0.150
     1.414    26.180     0.150
     1.414    45.383     0.150
     1.414    46.281     0.150
     1.495    27.078     0.150
     1.495    47.180     0.150
     1.495    48.281     0.150
     1.823    31.781     0.150
     1.823    33.680     0.150
     1.823    58.078     0.150
     1.859    34.383     0.150
     1.859    56.781     0.150
     1.859    59.281     0.150
     1.859    34.078     0.150
     1.859    59.078     0.150
     2.072    35.078     0.150
     2.072    36.578     0.150
     2.072    64.383     0.150
     2.072    37.078     0.150
     2.072    64.180     0.150
     2.132    36.281     0.150
     2.132    39.078     0.150
     2.132    67.477     0.150
     2.316    39.078     0.150
     2.316    42.180     0.150
     2.316    67.781     0.150
     2.316    71.781     0.150
     2.316    42.078     0.150
     2.316    71.977     0.150
     2.447    39.883     0.150
     2.447    43.977     0.150
     2.447    70.180     0.150
     2.447    76.680     0.150
     2.832    45.977     0.150
     2.832    50.680     0.150
     2.832    87.781     0.150
     2.832    50.477     0.150
     2.832    79.578     0.150
     2.832    86.781     0.150
     2.774    45.281     0.150
     2.774    49.477     0.150
     2.774    78.383     0.150
     2.774    86.180     0.150
     2.774    45.180     0.150
     2.774    51.180     0.150
     2.774    78.977     0.150
     2.774    85.477     0.150
     2.851    46.578     0.150
     2.851    51.383     0.150
     2.851    88.078     0.150
     2.851    45.477     0.150
     2.851    51.078     0.150
     2.851    78.578     0.150
     2.851    86.281     0.150
     3.205    51.477     0.150
     3.205    58.383     0.150
     3.205    90.383     0.150
     3.205   100.180     0.150
     3.205    56.477     0.150
     3.205    98.977     0.150
     3.455    53.281     0.150
     3.455    60.977     0.150
     3.455    93.781     0.150
     3.455   106.281     0.150
     3.455    93.383     0.150
     3.455   105.883     0.150
     3.479    54.781     0.150
     3.479    62.281     0.150
     3.479   107.180     0.150
     3.479    54.680     0.150
     3.479    61.383     0.150
     3.479    93.883     0.150
     3.479   106.477     0.150
     3.586    55.977     0.150
     3.586    63.781     0.150
     3.586   110.180     0.150
     3.586    56.281     0.150
     3.586    63.180     0.150
     3.586    97.281     0.150
     3.586   109.977     0.150
     4.012    62.578     0.150
     4.012    72.578     0.150
     4.012   123.477     0.150
     4.012    62.680     0.150
     4.012    70.383     0.150
     4.012   122.180     0.150
     4.505    69.578     0.150
     4.505   142.180     0.150
     4.505    69.477     0.150
     4.505    82.883     0.150
     4.564    68.078     0.150
     4.564    81.383     0.150
     4.564    82.680     0.150
     4.564   119.680     0.150
     4.564   140.883     0.150
     4.564    81.680     0.150
     4.564   120.281     0.150
     4.922    76.578     0.150
     4.922    77.977     0.150
     4.922   133.977     0.150
     4.922   149.883     0.150
     4.922   152.383     0.150
     4.922    88.578     0.150
     4.922   133.680     0.150
     4.922   150.078     0.150
     5.106    76.578     0.150
     5.106    91.477     0.150
     5.106   158.883     0.150
     5.305    79.383     0.150
     5.305   163.883     0.150
     5.305    78.578     0.150
     5.305    93.977     0.150
     5.305   162.180     0.150
     5.312    80.578     0.150
     5.312    82.281     0.150
     5.312   141.477     0.150
     5.312   164.977     0.150
     5.312    80.680     0.150
     5.763    85.969     0.150
     5.763   178.312     0.150
     5.871    87.820     0.150
     5.871   157.656     0.150
     5.871   186.156     0.150
     6.541    96.977     0.150
     6.541   116.781     0.150
     6.541   201.977     0.150
     6.541    98.383     0.150
     6.541   116.680     0.150
     6.841    99.977     0.150
     6.841   211.078     0.150
     6.841   121.977     0.150
     6.841   175.977     0.150
     7.403   108.680     0.150
     7.403   229.078     0.150
     9.333   132.578     0.150
    12.881   184.680     0.150
    12.995   186.180     0.150
    13.990   198.414     0.150
    13.990   435.641     0.150
    14.500   205.477     0.150
    14.519   204.539     0.150
    14.794   207.578     0.150
    15.326   222.680     0.150
    16.430   232.680     0.150
    16.430   408.477     0.150
    16.430   732.680     0.150
    16.753   236.680     0.150
    17.760   246.180     0.150
    17.760   249.180     0.150
    17.760   444.477     0.150
    18.004   249.734     0.150
    18.004   566.695     0.150
    22.277   295.781     0.150
    22.277   536.070     0.150
    22.586   299.344     0.150
    23.408   307.477     0.150
    23.748   310.578     0.150
    24.472   320.281     0.150
    28.713   359.180     0.150
    30.541   374.781     0.150
    30.642   376.078     0.150
    30.686   374.703     0.150
    30.686   374.703     0.150
    30.889   377.680     0.150
    30.965   378.781     0.150
    31.604   384.477     0.150
    39.016   445.883     0.150
    40.235   551.680     0.150
    42.115   471.555     0.150
    46.352   505.031     0.150
    48.362   520.383     0.150
    48.362   521.234     0.150
    48.677   524.180     0.150
    50.849   541.047     0.150
    50.849   617.727     0.150
    55.264   573.375     0.150
    59.450   601.422     0.150
    71.913   682.258     0.150
    76.529   709.766     0.150
    79.997   729.430     0.150
    89.211   776.102     0.150
   147.499  1182.477     0.150
   148.244  1188.180     0.150
   150.821  1190.828     0.150
     0.208     4.984     0.150
     0.208     8.184     0.150
     0.581    11.684     0.150
     0.581    19.883     0.150
     0.581    20.082     0.150
     0.669    12.883     0.150
     0.669    22.281     0.150
     0.955    17.484     0.150
     0.955    30.281     0.150
     0.955    17.281     0.150
     0.955    29.582     0.150
     1.265    23.383     0.150
     1.265    40.281     0.150
     1.265    41.484     0.150
     1.424    25.582     0.150
     1.424    45.184     0.150
     1.695    29.281     0.150
     1.695    51.984     0.150
     1.734    31.082     0.150
     1.734    53.484     0.150
     1.734    31.684     0.150
     1.989    33.781     0.150
     1.989    36.184     0.150
     1.989    62.883     0.150
     2.178    35.883     0.150
     2.178    38.281     0.150
     2.178    63.684     0.150
     2.178    67.484     0.150
     2.178    66.684     0.150
     2.474    39.984     0.150
     2.474    44.883     0.150
     2.474    70.484     0.150
     2.474    76.184     0.150
     2.474    43.781     0.150
     2.474    75.984     0.150
     2.687    43.082     0.150
     2.687    48.281     0.150
     2.687    75.484     0.150
     2.687    82.484     0.150
     2.687    84.082     0.150
     2.792    44.684     0.150
     2.792    50.082     0.150
     2.792    85.582     0.150
     2.792    50.582     0.150
     2.967    46.883     0.150
     2.967    52.781     0.150
     2.967    81.684     0.150
     2.967    90.984     0.150
     2.967    46.684     0.150
     2.967    52.082     0.150
     2.967    81.484     0.150
     2.967    89.383     0.150
     3.337    60.184     0.150
     3.337   103.684     0.150
     3.382    51.484     0.150
     3.382    60.684     0.150
     3.382    89.781     0.150
     3.382   103.582     0.150
     3.382    59.184     0.150
     3.382    91.684     0.150
     3.382   103.684     0.150
     3.404    52.883     0.150
     3.404    61.684     0.150
     3.404    92.383     0.150
     3.404   105.582     0.150
     3.677    56.582     0.150
     3.677    65.781     0.150
     3.677    99.184     0.150
     3.677   113.082     0.150
     3.677    56.383     0.150
     3.677    65.484     0.150
     3.677   100.582     0.150
     3.677   114.082     0.150
     3.962    61.781     0.150
     3.962    72.184     0.150
     3.962   105.484     0.150
     3.962   119.383     0.150
     3.962   122.883     0.150
     3.962   123.984     0.150
     3.962    62.184     0.150
     3.962    72.383     0.150
     3.962   120.582     0.150
     4.422    65.484     0.150
     4.422    79.781     0.150
     4.422   114.984     0.150
     4.422   136.082     0.150
     4.422    65.684     0.150
     4.422    78.582     0.150
     4.422   115.484     0.150
     4.422   136.281     0.150
     4.401    67.383     0.150
     4.401    79.484     0.150
     4.401   115.383     0.150
     4.401   137.684     0.150
     4.401    67.281     0.150
     4.401    79.281     0.150
     4.401   117.484     0.150
     4.877    72.582     0.150
     4.877    76.684     0.150
     4.877   150.082     0.150
     4.877    86.184     0.150
     4.877   130.082     0.150
     4.877   150.281     0.150
     5.204    77.281     0.150
     5.204    94.883     0.150
     5.204   163.082     0.150
     5.204    77.082     0.150
     5.204    93.281     0.150
     5.439    80.484     0.150
     5.439    98.484     0.150
     5.439   140.184     0.150
     5.439   167.184     0.150
     5.601    83.484     0.150
     5.601    84.652     0.150
     5.713    85.121     0.150
     5.713   152.383     0.150
     5.713   179.344     0.150
     6.630    97.184     0.150
     6.630   120.484     0.150
     6.630   168.383     0.150
     6.630   206.582     0.150
     6.630    97.684     0.150
     6.869    99.383     0.150
     6.869   175.184     0.150
     6.869   211.582     0.150
     6.869    99.582     0.150
     6.869   176.781     0.150
     7.548   111.484     0.150
     7.548   232.684     0.150
     9.403   136.082     0.150
     9.674   301.383     0.150
    10.022   311.781     0.150
    14.032   204.809     0.150
    14.032   436.984     0.150
    14.202   199.781     0.150
    17.980   257.090     0.150
    28.342   351.883     0.150
    76.376   707.816     0.150
    76.376   706.582     0.150
    79.842   727.633     0.150
     0.151     3.328     0.150
     0.151     5.527     0.150
     0.648    12.527     0.150
     0.648    21.629     0.150
     0.974    17.430     0.150
     0.974    30.430     0.150
     1.179    21.629     0.150
     1.179    38.027     0.150
     1.399    25.129     0.150
     1.399    44.629     0.150
     1.399    25.230     0.150
     1.627    29.930     0.150
     1.627    52.129     0.150
     1.669    31.027     0.150
     1.669    53.629     0.150
     1.710    31.730     0.150
     1.710    33.027     0.150
     1.710    55.129     0.150
     1.710    56.629     0.150
     2.239    37.328     0.150
     2.239    39.328     0.150
     2.239    69.430     0.150
     2.239    39.430     0.150
     2.239    70.027     0.150
     2.273    41.129     0.150
     2.273    71.230     0.150
     2.570    42.328     0.150
     2.570    44.930     0.150
     2.570    78.730     0.150
     2.647    43.027     0.150
     2.647    47.328     0.150
     2.647    75.430     0.150
     2.647    81.230     0.150
     2.770    86.027     0.150
     2.770    49.930     0.150
     2.770    86.129     0.150
     3.047    48.527     0.150
     3.047    53.730     0.150
     3.047    94.129     0.150
     3.047    53.230     0.150
     3.047    83.930     0.150
     3.047    92.828     0.150
     3.329    51.629     0.150
     3.329    58.828     0.150
     3.329   102.730     0.150
     3.373    60.328     0.150
     3.373    94.129     0.150
     3.373   103.230     0.150
     3.414   107.828     0.150
     3.414    63.027     0.150
     3.414   107.527     0.150
     3.726    57.527     0.150
     3.726    66.527     0.150
     3.726   115.027     0.150
     3.726   113.930     0.150
     3.946    70.027     0.150
     3.946   120.129     0.150
     3.946    62.328     0.150
     3.946    70.828     0.150
     4.085   128.828     0.150
     4.328    65.027     0.150
     4.328    76.930     0.150
     4.328   132.527     0.150
     4.347    78.328     0.150
     4.347   136.430     0.150
     4.864    73.629     0.150
     4.864    86.828     0.150
     4.864   132.230     0.150
     4.864   150.027     0.150
     5.256   162.230     0.150
     5.310    81.027     0.150
     5.310    95.930     0.150
     5.310   142.230     0.150
     5.310   164.129     0.150
     5.310    81.430     0.150
     6.677   206.430     0.150
     6.876   122.629     0.150
     6.876   212.328     0.150
     6.876   177.027     0.150
     7.561   234.629     0.150
     0.130     3.512     0.150
     0.130     6.109     0.150
     0.656    12.809     0.150
     0.656    21.910     0.150
     0.656    21.711     0.150
     0.925    16.109     0.150
     0.925    28.609     0.150
     0.925    16.410     0.150
     0.925    28.711     0.150
     1.148    21.609     0.150
     1.148    37.012     0.150
     1.232    22.809     0.150
     1.232    39.410     0.150
     1.448    25.910     0.150
     1.448    46.512     0.150
     1.448    45.809     0.150
     1.558    28.211     0.150
     1.558    49.211     0.150
     1.764    55.109     0.150
     2.185    35.809     0.150
     2.185    37.910     0.150
     2.185    67.309     0.150
     2.327    38.512     0.150
     2.327    42.012     0.150
     2.327    72.910     0.150
     2.522    41.309     0.150
     2.522    44.609     0.150
     2.522    77.410     0.150
     2.522    44.711     0.150
     2.522    77.512     0.150
     2.699    47.211     0.150
     2.699    74.609     0.150
     2.699    83.512     0.150
     2.818    51.910     0.150
     2.818    86.211     0.150
     2.993    47.109     0.150
     2.993    53.109     0.150
     2.993    83.609     0.150
     2.993    92.211     0.150
     2.993    46.711     0.150
     3.310    56.910     0.150
     3.310    89.910     0.150
     3.310   101.211     0.150
     3.310    51.910     0.150
     3.310    58.609     0.150
     3.310   102.109     0.150
     3.423    60.809     0.150
     3.423   105.211     0.150
     3.993    73.012     0.150
     3.993   121.609     0.150
     3.993    70.109     0.150
     3.993   121.910     0.150
     4.030   125.211     0.150
     4.401   113.609     0.150
     4.401   136.512     0.150
     4.910   151.109     0.150
     5.203   160.809     0.150
     5.348    81.109     0.150
     5.348   141.012     0.150
     5.348   142.711     0.150
     5.462   169.910     0.150
     5.549   173.309     0.150
     6.623   205.410     0.150
     6.831   209.711     0.150
     0.289     6.230     0.150
     0.289    10.430     0.150
     0.467     8.629     0.150
     0.467    15.129     0.150
     0.657    12.730     0.150
     0.657    22.031     0.150
     0.657    21.430     0.150
     0.740    14.031     0.150
     0.740    24.629     0.150
     1.075    20.031     0.150
     1.075    35.328     0.150
     1.277    23.430     0.150
     1.277    41.328     0.150
     1.314    23.430     0.150
     1.314    41.129     0.150
     1.317    24.629     0.150
     2.300    37.930     0.150
     2.300    40.828     0.150
     2.300    70.328     0.150
     2.444    44.328     0.150
     2.444    75.031     0.150
     2.444    75.328     0.150
     2.592    41.430     0.150
     2.592    45.129     0.150
     2.592    79.531     0.150
     2.867    45.930     0.150
     2.867    50.629     0.150
     2.867    87.129     0.150
     3.033    54.328     0.150
     3.033    93.129     0.150
     3.384    52.730     0.150
     3.384    60.031     0.150
     3.384   105.930     0.150
     3.510    63.031     0.150
     3.510    59.828     0.150
     3.510    62.629     0.150
     3.510   107.930     0.150
     3.625    63.930     0.150
     3.625   110.629     0.150
     3.625    65.129     0.150
     3.625   111.930     0.150
     3.994    69.930     0.150
     3.994   125.531     0.150
     4.079    62.730     0.150
     4.079    69.930     0.150
     4.079    73.531     0.150
     4.079   125.930     0.150
     4.306    63.828     0.150
     4.306    76.531     0.150
     4.306   131.430     0.150
     4.438   138.031     0.150
     4.546    81.031     0.150
     4.546   139.629     0.150
     5.032    77.230     0.150
     5.032   155.828     0.150
     5.610   175.730     0.150
     5.856   103.129     0.150
     5.856   101.629     0.150
     5.856   150.629     0.150
     5.856   181.730     0.150
     7.192   103.930     0.150
     7.192   127.230     0.150
     7.192   221.129     0.150
     7.192   223.031     0.150
     0.153     3.180     0.150
     0.153     5.680     0.150
     0.586    11.277     0.150
     0.586    19.680     0.150
     0.644    12.379     0.150
     0.644    21.578     0.150
     0.644    21.777     0.150
     0.973    17.480     0.150
     0.973    30.480     0.150
     0.973    17.680     0.150
     0.973    30.180     0.150
     1.096    20.379     0.150
     1.096    36.578     0.150
     1.400    25.277     0.150
     1.400    44.277     0.150
     1.512    27.379     0.150
     1.512    48.379     0.150
     1.672    30.680     0.150
     1.672    30.980     0.150
     1.712    32.078     0.150
     1.712    54.078     0.150
     1.911    34.578     0.150
     1.911    60.480     0.150
     2.236    37.277     0.150
     2.236    39.277     0.150
     2.236    69.578     0.150
     2.236    37.078     0.150
     2.236    65.480     0.150
     2.236    69.777     0.150
     2.565    42.180     0.150
     2.565    44.879     0.150
     2.565    78.879     0.150
     2.565    41.777     0.150
     2.565    45.777     0.150
     2.565    78.680     0.150
     2.649    42.879     0.150
     2.649    47.578     0.150
     2.649    75.277     0.150
     2.649    81.680     0.150
     2.649    43.277     0.150
     2.649    47.180     0.150
     2.649    75.379     0.150
     2.649    80.777     0.150
     2.771    85.078     0.150
     2.771    49.879     0.150
     2.771    86.180     0.150
     3.043    48.578     0.150
     3.043    54.277     0.150
     3.043    95.180     0.150
     3.043    53.277     0.150
     3.043    83.980     0.150
     3.043    93.180     0.150
     3.332    50.578     0.150
     3.332    58.277     0.150
     3.332   103.180     0.150
     3.332    60.777     0.150
     3.332   101.578     0.150
     3.374    53.277     0.150
     3.374    60.777     0.150
     3.374   104.277     0.150
     3.374    53.480     0.150
     3.374   103.578     0.150
     3.411   105.480     0.150
     3.946    61.777     0.150
     3.946    70.480     0.150
     3.946   121.578     0.150
     3.946    71.180     0.150
     3.946   121.777     0.150
     4.082    74.480     0.150
     4.333    64.879     0.150
     4.333    78.180     0.150
     4.333   114.578     0.150
     4.333   132.379     0.150
     4.350    66.680     0.150
     4.350    77.578     0.150
     4.350   135.879     0.150
     4.350    66.277     0.150
     4.350   135.980     0.150
     5.309    81.480     0.150
     5.309   140.480     0.150
     5.309    97.379     0.150
     5.512    97.480     0.150
     5.512   169.180     0.150
     5.512    96.680     0.150
     6.675   207.980     0.150
     6.876   212.379     0.150
     6.876   177.277     0.150
     7.525   232.480     0.150
     7.560   233.480     0.150
     0.176     4.016     0.150
     0.176     7.109     0.150
     0.889    16.711     0.150
     0.889    28.812     0.150
     1.097    20.016     0.150
     1.097    35.109     0.150
     1.097    39.016     0.150
     1.108    21.312     0.150
     1.108    37.516     0.150
     1.392    25.211     0.150
     1.392    26.312     0.150
     1.392    44.414     0.150
     1.392    46.516     0.150
     1.491    27.211     0.150
     1.491    47.414     0.150
     1.491    48.711     0.150
     1.599    29.109     0.150
     1.599    50.609     0.150
     1.649    30.516     0.150
     1.649    52.914     0.150
     1.720    32.516     0.150
     1.830    32.016     0.150
     1.830    33.109     0.150
     1.830    57.609     0.150
     2.289    37.516     0.150
     2.289    40.211     0.150
     2.289    41.812     0.150
     2.289    70.711     0.150
     2.690    43.609     0.150
     2.690    48.414     0.150
     2.690    75.609     0.150
     2.690    83.211     0.150
     2.733    44.312     0.150
     2.733    48.016     0.150
     2.733    84.711     0.150
     2.856    49.312     0.150
     2.856    80.516     0.150
     2.856    88.211     0.150
     3.119    95.812     0.150
     3.148    49.211     0.150
     3.148    96.914     0.150
     3.432    62.211     0.150
     3.432   107.109     0.150
     3.735    58.914     0.150
     3.735    67.711     0.150
     3.735   116.016     0.150
     4.079    61.109     0.150
     4.079    72.609     0.150
     4.079   108.516     0.150
     4.079   125.312     0.150
     4.039    72.109     0.150
     4.039    73.711     0.150
     4.039   125.711     0.150
     4.347    79.414     0.150
     4.347   135.812     0.150
     4.961    77.109     0.150
     4.961    89.516     0.150
     4.961   132.211     0.150
     4.961   153.711     0.150
     5.273    95.516     0.150
     5.273   165.211     0.150
     5.340    95.312     0.150
     5.340   166.016     0.150
     5.451   141.711     0.150
     5.451   169.609     0.150
     5.604   173.711     0.150
     6.675   207.312     0.150
     6.778   207.414     0.150
     9.846   304.414     0.150
     0.294     6.070     0.150
     0.294    10.172     0.150
     0.468     8.672     0.150
     0.468    14.773     0.150
     0.652    12.875     0.150
     0.652    22.070     0.150
     0.652    21.477     0.150
     0.652    22.172     0.150
     0.740    14.273     0.150
     0.740    25.477     0.150
     0.863    15.773     0.150
     0.863    27.375     0.150
     1.072    20.172     0.150
     1.072    19.977     0.150
     1.072    34.977     0.150
     1.211    22.070     0.150
     1.211    22.977     0.150
     1.211    38.172     0.150
     1.278    23.477     0.150
     1.278    40.375     0.150
     1.316    23.375     0.150
     1.316    41.273     0.150
     1.316    42.672     0.150
     1.318    43.273     0.150
     1.318    42.875     0.150
     1.577    28.172     0.150
     1.577    49.875     0.150
     2.299    37.773     0.150
     2.299    41.375     0.150
     2.299    66.273     0.150
     2.299    70.570     0.150
     2.441    44.273     0.150
     2.441    75.570     0.150
     2.441    75.875     0.150
     2.591    41.477     0.150
     2.591    73.477     0.150
     2.591    80.273     0.150
     2.864    45.875     0.150
     2.864    50.977     0.150
     2.864    87.672     0.150
     3.031    54.570     0.150
     3.031    92.672     0.150
     3.383    52.672     0.150
     3.383    60.477     0.150
     3.383   104.477     0.150
     3.515   107.570     0.150
     3.622    57.070     0.150
     3.622    63.773     0.150
     3.622    56.273     0.150
     3.622   110.070     0.150
     3.994    62.570     0.150
     3.994    72.977     0.150
     3.994   124.172     0.150
     4.079    62.672     0.150
     4.079    73.570     0.150
     4.079   126.070     0.150
     4.312    64.773     0.150
     4.312    77.477     0.150
     4.312   113.773     0.150
     4.312   131.672     0.150
     4.437   139.273     0.150
     4.543    69.672     0.150
     4.543    81.375     0.150
     4.543   121.773     0.150
     4.543   140.375     0.150
     5.028    77.273     0.150
     5.028    90.273     0.150
     5.028   133.375     0.150
     5.028   155.977     0.150
     5.610   100.773     0.150
     5.610   174.070     0.150
     5.855   180.773     0.150
     7.030   217.273     0.150
     7.030   217.070     0.150
     7.194   184.875     0.150
     7.289   226.172     0.150
     0.320     7.003     0.150
     0.320    11.604     0.150
     0.466     8.804     0.150
     0.466    15.104     0.150
     1.172    20.804     0.150
     1.172    36.403     0.150
     1.172    36.703     0.150
     1.257    22.703     0.150
     1.257    39.703     0.150
     1.257    23.503     0.150
     1.257    39.804     0.150
     1.633    29.503     0.150
     1.633    51.903     0.150
     1.636    29.403     0.150
     1.636    29.604     0.150
     1.636    51.804     0.150
     2.300    41.104     0.150
     2.300    70.503     0.150
     2.300    38.203     0.150
     2.300    41.304     0.150
     2.300    70.703     0.150
     2.457    43.003     0.150
     2.457    74.304     0.150
     2.457    41.003     0.150
     2.457    43.104     0.150
     2.457    70.903     0.150
     2.541    42.304     0.150
     2.541    77.003     0.150
     2.608    42.703     0.150
     2.608    79.003     0.150
     2.608    48.003     0.150
     2.608    74.903     0.150
     2.608    80.104     0.150
     2.608    82.304     0.150
     3.025    55.003     0.150
     3.025    91.403     0.150
     3.025    48.104     0.150
     3.025    93.403     0.150
     3.239    51.403     0.150
     3.239    57.804     0.150
     3.239    98.403     0.150
     3.239    57.104     0.150
     3.239    90.804     0.150
     3.239    98.983     0.150
     3.239    57.703     0.150
     3.402    62.604     0.150
     3.402   105.203     0.150
     3.402   104.003     0.150
     3.645    64.703     0.150
     3.645   114.703     0.150
     3.645    67.003     0.150
     3.822    60.203     0.150
     3.822   116.403     0.150
     3.766    60.304     0.150
     3.766    67.203     0.150
     3.766   104.403     0.150
     3.766   114.903     0.150
     3.766   114.403     0.150
     4.284    66.804     0.150
     4.284   134.003     0.150
     4.675    73.503     0.150
     4.675    81.804     0.150
     4.675   127.304     0.150
     4.675   141.903     0.150
     4.675    82.403     0.150
     4.675   142.903     0.150
     5.068    78.804     0.150
     5.068   136.104     0.150
     5.068   158.403     0.150
     5.068   155.104     0.150
     5.337    94.304     0.150
     5.337   167.403     0.150
     5.499    96.604     0.150
     5.499   168.804     0.150
     5.499   169.804     0.150
     5.658   176.604     0.150
     5.750    86.604     0.150
     5.750   179.684     0.150
     6.776   211.304     0.150
     7.087   218.903     0.150
    13.759   193.482     0.150
    17.758   247.293     0.150
    17.758   558.558     0.150
    18.235   252.729     0.150
    18.235   574.878     0.150
    18.235   251.443     0.150
    18.321   252.729     0.150
    18.321   574.878     0.150
    20.379   275.313     0.150
    22.375   298.203     0.150
    24.699   323.304     0.150
    59.603   602.291     0.150
    76.565   710.167     0.150
    80.026   729.641     0.150
     0.161     3.586     0.150
     0.161     6.484     0.150
     0.636    12.680     0.150
     0.636    21.781     0.150
     0.636    21.586     0.150
     0.586    11.484     0.150
     0.586    19.680     0.150
     0.978    17.883     0.150
     0.978    30.883     0.150
     0.978    30.984     0.150
     1.093    20.586     0.150
     1.093    35.883     0.150
     1.394    25.586     0.150
     1.394    44.180     0.150
     1.394    25.383     0.150
     1.394    44.984     0.150
     1.513    27.781     0.150
     1.513    48.781     0.150
     1.628    29.281     0.150
     1.628    52.281     0.150
     2.239    39.883     0.150
     2.239    69.781     0.150
     2.239    37.680     0.150
     2.239    39.680     0.150
     2.564    46.281     0.150
     2.564    79.984     0.150
     2.564    42.586     0.150
     2.564    46.086     0.150
     2.564    79.586     0.150
     2.644    43.180     0.150
     2.644    48.086     0.150
     2.644    73.484     0.150
     2.644    81.984     0.150
     2.765    45.281     0.150
     2.765    50.180     0.150
     2.765    85.086     0.150
     2.765    45.086     0.150
     2.765    46.180     0.150
     2.765    49.586     0.150
     2.765    85.680     0.150
     3.043    47.781     0.150
     3.043    53.781     0.150
     3.043    84.086     0.150
     3.043    92.883     0.150
     3.043    48.984     0.150
     3.043    54.086     0.150
     3.043    94.281     0.150
     3.340    51.984     0.150
     3.340    59.883     0.150
     3.340   103.586     0.150
     3.340    60.086     0.150
     3.340   103.484     0.150
     3.412    54.781     0.150
     3.412    61.586     0.150
     3.412    60.781     0.150
     3.412   105.984     0.150
     3.369    53.086     0.150
     3.369    52.984     0.150
     3.369    61.180     0.150
     3.369   103.680     0.150
     3.369    61.680     0.150
     3.369   104.680     0.150
     3.369    61.281     0.150
     3.369    53.438     0.150
     3.369    60.680     0.150
     3.727    64.781     0.150
     3.727   114.484     0.150
     3.727    58.281     0.150
     3.727    65.484     0.150
     3.727    67.281     0.150
     3.727   115.680     0.150
     3.940    72.484     0.150
     3.940   120.086     0.150
     3.940    60.781     0.150
     3.940    70.984     0.150
     3.940   121.586     0.150
     4.340   115.586     0.150
     4.340   132.883     0.150
     4.340    65.180     0.150
     4.340    77.680     0.150
     4.340   115.984     0.150
     4.340   132.781     0.150
     4.347    67.383     0.150
     4.347    77.984     0.150
     4.347   136.086     0.150
     4.347    67.281     0.150
     4.347    78.484     0.150
     4.347   135.984     0.150
     4.858    76.086     0.150
     4.858    86.484     0.150
     4.858   131.383     0.150
     4.858   147.586     0.150
     4.858    74.586     0.150
     4.858    86.586     0.150
     4.858   132.586     0.150
     4.858   150.086     0.150
     5.257    78.680     0.150
     5.257    93.984     0.150
     5.257   161.883     0.150
     5.257    78.781     0.150
     5.257    94.383     0.150
     5.257   135.883     0.150
     5.257   163.180     0.150
     5.302    80.586     0.150
     5.302    95.781     0.150
     5.302   162.383     0.150
     5.302    80.484     0.150
     5.302   141.086     0.150
     5.302   162.281     0.150
     5.513    82.086     0.150
     5.513    98.586     0.150
     5.513    98.383     0.150
     5.510    82.781     0.150
     5.510    99.883     0.150
     5.510    83.484     0.150
     5.510   146.484     0.150
     5.624    84.703     0.150
     5.624   151.523     0.150
     6.678    98.383     0.150
     6.678   207.383     0.150
     6.882   100.781     0.150
     6.882   122.586     0.150
     6.882   177.484     0.150
     6.882   212.680     0.150
     8.128   115.180     0.150
     8.128   115.984     0.150
     8.128   251.383     0.150
     9.909   141.883     0.150
     9.909   178.281     0.150
     9.924   142.586     0.150
    10.057   144.180     0.150
    10.057   144.281     0.150
    10.057   182.086     0.150
    10.057   310.586     0.150
    12.623   179.984     0.150
    12.623   322.984     0.150
    12.735   182.984     0.150
    12.735   324.484     0.150
    14.046   198.383     0.150
    14.046   197.930     0.150
    14.046   435.086     0.150
    14.264   198.383     0.150
    14.264   355.086     0.150
    14.264   198.844     0.150
    14.257   201.484     0.150
    14.276   201.484     0.150
    14.276   352.180     0.150
    14.677   205.281     0.150
    14.677   208.781     0.150
    14.677   217.180     0.150
    14.881   209.586     0.150
    15.102   213.680     0.150
    15.102   380.781     0.150
    15.304   214.180     0.150
    15.821   225.680     0.150
    16.309   226.984     0.150
    16.309   229.984     0.150
    16.652   236.984     0.150
    16.652   420.680     0.150
    16.652   426.180     0.150
    16.991   237.281     0.150
    16.991   424.984     0.150
    17.510   248.180     0.150
    17.510   447.883     0.150
    17.510   459.883     0.150
    17.971   248.086     0.150
    17.971   248.805     0.150
    18.124   252.680     0.150
    18.124   459.383     0.150
    18.501   253.484     0.150
    18.501   255.281     0.150
    18.501   253.586     0.150
    18.501   253.375     0.150
    18.501   254.039     0.150
    18.586   255.281     0.150
    18.586   580.484     0.150
    19.249   267.680     0.150
    19.249   283.484     0.150
    19.249   503.281     0.150
    20.215   279.125     0.150
    20.475   276.680     0.150
    20.475   498.781     0.150
    20.475   276.391     0.150
    20.798   281.984     0.150
    22.510   300.883     0.150
    22.510   545.883     0.150
    22.510   556.383     0.150
    22.668   299.820     0.150
    22.668   716.078     0.150
    22.629   303.180     0.150
    22.629   546.281     0.150
    22.629   553.180     0.150
    22.629   588.180     0.150
    22.720   301.484     0.150
    22.720   300.180     0.150
    22.720   299.789     0.150
    22.720   300.789     0.150
    22.711   303.281     0.150
    22.711   552.883     0.150
    22.711   303.766     0.150
    23.015   307.992     0.150
    23.015   698.055     0.150
    23.131   309.484     0.150
    23.131   563.781     0.150
    24.023   315.680     0.150
    24.023   573.383     0.150
    24.023   578.180     0.150
    24.080   316.727     0.150
    24.080   316.383     0.150
    24.115   316.992     0.150
    24.520   321.172     0.150
    24.530   320.672     0.150
    24.626   320.984     0.150
    24.620   322.086     0.150
    24.709   321.883     0.150
    24.798   324.406     0.150
    24.898   324.484     0.150
    24.898   323.500     0.150
    24.898   589.875     0.150
    24.898   323.781     0.150
    24.898   323.883     0.150
    24.898   324.680     0.150
    25.136   327.555     0.150
    25.136   326.922     0.150
    25.227   325.680     0.150
    25.306   328.172     0.150
    25.306   327.844     0.150
    25.677   331.625     0.150
    25.677   330.945     0.150
    26.044   544.680     0.150
    26.044   610.781     0.150
    26.044   763.680     0.150
    26.044   991.680     0.150
    26.130   337.680     0.150
    26.625   341.180     0.150
    26.625   340.180     0.150
    26.627   338.531     0.150
    26.837   343.883     0.150
    26.837   547.180     0.150
    26.837   619.680     0.150
    26.837   691.680     0.150
    27.182   344.086     0.150
    27.182   622.984     0.150
    28.392   353.984     0.150
    28.392   353.781     0.150
    28.392   642.680     0.150
    28.392   721.484     0.150
    28.392   353.430     0.150
    28.462   358.281     0.150
    28.462   410.281     0.150
    28.462   550.484     0.150
    28.462   644.680     0.150
    28.462   649.484     0.150
    28.462   728.984     0.150
    28.462   770.281     0.150
    28.462   771.484     0.150
    28.614   356.383     0.150
    28.614   645.586     0.150
    29.017   360.055     0.150
    29.317   365.883     0.150
    29.317   659.984     0.150
    29.586   364.086     0.150
    29.586   656.180     0.150
    29.586   365.672     0.150
    30.162   369.453     0.150
    30.192   371.836     0.150
    30.596   374.086     0.150
    30.596   444.586     0.150
    30.596   678.383     0.150
    30.596   374.242     0.150
    30.771   375.516     0.150
    30.771   375.508     0.150
    30.782   377.359     0.150
    30.928   378.336     0.150
    31.656   384.375     0.150
    33.476   398.180     0.150
    33.829   403.289     0.150
    34.042   404.703     0.150
    34.031   406.883     0.150
    34.213   407.484     0.150
    34.213   732.383     0.150
    34.473   407.875     0.150
    34.822   411.711     0.150
    35.200   415.484     0.150
    35.200   414.180     0.150
    35.549   418.414     0.150
    35.549   417.680     0.150
    36.595   424.586     0.150
    36.595   507.883     0.150
    36.595   764.984     0.150
    36.595   910.680     0.150
    36.718   427.516     0.150
    36.729   429.883     0.150
    37.075   772.883     0.150
    37.591   436.586     0.150
    37.886   795.883     0.150
    38.110   439.586     0.150
    38.281   441.234     0.150
    38.673   443.383     0.150
    38.921   445.719     0.150
    38.925   446.250     0.150
    39.242   447.781     0.150
    39.242   450.594     0.150
    39.460   451.383     0.150
    39.458   448.383     0.150
    39.516   450.586     0.150
    39.565   539.781     0.150
    39.565   813.586     0.150
    39.565   980.586     0.150
    39.692   451.281     0.150
    39.692     6.703     0.150
    39.692   815.281     0.150
    40.214   457.023     0.150
    40.389   457.180     0.150
    40.389     4.102     0.150
    40.389   556.781     0.150
    40.389   827.281     0.150
    40.325   461.695     0.150
    40.680   458.883     0.150
    40.964   463.430     0.150
    40.962   462.383     0.150
    40.962     4.602     0.150
    40.962   833.883     0.150
    41.227   463.383     0.150
    41.342   841.836     0.150
    41.904   469.781     0.150
    42.311   473.711     0.150
    42.724   480.883     0.150
    43.031   478.984     0.150
    43.031   869.086     0.150
    43.036   481.180     0.150
    43.036   479.383     0.150
    43.036   575.883     0.150
    43.036   863.781     0.150
    43.036  1054.281     0.150
    43.036   480.656     0.150
    43.036   481.609     0.150
    43.177   481.398     0.150
    43.186   482.078     0.150
    43.304   482.625     0.150
    43.476   482.680     0.150
    44.174   490.383     0.150
    44.174   488.984     0.150
    44.174   491.180     0.150
    44.357   489.883     0.150
    44.746   492.594     0.150
    44.975   495.180     0.150
    44.975   598.984     0.150
    44.975   895.281     0.150
    44.975  1087.086     0.150
    45.048   492.883     0.150
    45.131   496.055     0.150
    45.284   497.711     0.150
    45.336   500.883     0.150
    45.359   498.133     0.150
    45.539   498.680     0.150
    45.989   501.883     0.150
    46.306   505.461     0.150
    46.498   506.609     0.150
    46.498   506.484     0.150
    46.498   506.281     0.150
    46.510   506.180     0.150
    46.781   510.180     0.150
    47.313   515.680     0.150
    47.313   928.883     0.150
    47.573   516.375     0.150
    47.574   515.445     0.150
    47.574   515.281     0.150
    47.574   609.781     0.150
    47.910   517.953     0.150
    48.021   520.484     0.150
    48.214   521.391     0.150
    48.220   941.961     0.150
    48.220  1149.742     0.150
    48.143   522.750     0.150
    48.267   521.492     0.150
    48.282   521.789     0.150
    48.499   522.984     0.150
    48.554   523.672     0.150
    48.572   523.383     0.150
    48.572   522.781     0.150
    48.818   522.953     0.150
    48.851   525.180     0.150
    48.945   524.883     0.150
    48.945   950.883     0.150
    48.945  1162.883     0.150
    49.508   531.391     0.150
    49.661   532.172     0.150
    49.691   531.680     0.150
    49.691   965.086     0.150
    50.150   535.383     0.150
    50.120   535.914     0.150
    50.170   536.539     0.150
    50.252   536.234     0.150
    50.383   536.430     0.150
    50.383   536.883     0.150
    50.455   537.516     0.150
    50.465   538.484     0.150
    50.465   538.086     0.150
    50.478   538.984     0.150
    50.478   538.266     0.150
    50.527   973.742     0.150
    50.527  1192.633     0.150
    50.719   539.562     0.150
    50.832   541.414     0.150
    50.939   542.312     0.150
    50.939   541.430     0.150
    50.939   542.781     0.150
    51.003   540.891     0.150
    51.152   542.070     0.150
    51.142   543.383     0.150
    51.142     4.602     0.150
    51.222   980.305     0.150
    51.291   544.383     0.150
    51.350   543.781     0.150
    51.325   545.883     0.150
    51.325   984.883     0.150
    51.351   544.883     0.150
    51.351     4.602     0.150
    51.367   544.586     0.150
    51.554   980.086     0.150
    51.554  1198.781     0.150
    51.671   547.281     0.150
    51.768   547.086     0.150
    51.790   548.500     0.150
    51.822   549.180     0.150
    52.197   551.125     0.150
    52.302   552.883     0.150
    52.318   996.180     0.150
    52.336   551.672     0.150
    52.337   552.586     0.150
    52.337     4.594     0.150
    52.612   555.180     0.150
    52.612  1004.883     0.150
    52.612  1232.086     0.150
    52.847   556.703     0.150
    52.847   555.781     0.150
    52.847     4.898     0.150
    52.847  1003.883     0.150
    52.948   556.461     0.150
    52.948   557.180     0.150
    53.006   557.109     0.150
    53.006   557.984     0.150
    53.006   557.883     0.150
    53.159   559.281     0.150
    53.159  1011.883     0.150
    53.157   558.680     0.150
    53.157     5.102     0.150
    53.190   560.281     0.150
    53.317   559.984     0.150
    53.317     4.602     0.150
    53.519   559.984     0.150
    53.721   561.586     0.150
    53.876   564.484     0.150
    53.939   564.180     0.150
    53.939   563.875     0.150
    53.939     4.766     0.150
    53.939   687.883     0.150
    53.939  1023.883     0.150
    53.939  1247.883     0.150
    54.018   563.781     0.150
    54.084   564.984     0.150
    54.084   564.883     0.150
    54.084   631.883     0.150
    54.084     3.398     0.150
    54.084   688.883     0.150
    54.084  1244.883     0.150
    54.253   567.680     0.150
    54.253  1025.586     0.150
    54.267   567.180     0.150
    54.514   568.562     0.150
    54.592   569.086     0.150
    54.785   571.883     0.150
    54.922   571.680     0.150
    55.074   573.383     0.150
    55.074  1040.484     0.150
    55.178   572.984     0.150
    55.178   573.484     0.150
    55.297   574.086     0.150
    55.297  1042.586     0.150
    55.297   573.891     0.150
    55.434   575.180     0.150
    55.434   574.156     0.150
    55.434   574.195     0.150
    55.508   576.281     0.150
    55.621   577.086     0.150
    55.643   575.617     0.150
    55.760   576.984     0.150
    55.799   577.781     0.150
    56.021   579.984     0.150
    56.021   579.984     0.150
    56.281   580.742     0.150
    56.475   581.992     0.150
    56.586   583.086     0.150
    56.638   584.883     0.150
    56.833   585.859     0.150
    56.924   585.984     0.150
    57.065   587.484     0.150
    57.613   590.883     0.150
    57.613   590.984     0.150
    57.924   593.586     0.150
    58.035   592.883     0.150
    58.187   594.336     0.150
    58.331   596.086     0.150
    58.331   595.602     0.150
    58.629   597.086     0.150
    58.717   598.617     0.150
    58.734   600.023     0.150
    58.757   598.180     0.150
    58.810   599.680     0.150
    58.931   598.984     0.150
    58.954   600.984     0.150
    58.954   599.984     0.150
    58.987   600.523     0.150
    59.005   598.586     0.150
    59.339   603.781     0.150
    59.385   602.383     0.150
    59.479   602.984     0.150
    59.685   602.930     0.150
    59.702   604.781     0.150
    59.738   606.586     0.150
    60.171   608.586     0.150
    60.626   611.180     0.150
    60.715   612.250     0.150
    61.135   614.984     0.150
    61.140   614.984     0.150
    61.157   613.984     0.150
    61.471   616.281     0.150
    61.505   616.680     0.150
    61.632   617.484     0.150
    61.704   618.281     0.150
    61.703   618.281     0.150
    61.744   618.180     0.150
    61.905   618.680     0.150
    61.930   618.781     0.150
    61.982   620.484     0.150
    62.028   620.180     0.150
    62.149   621.086     0.150
    62.549   626.984     0.150
    62.596   624.383     0.150
    62.634   624.180     0.150
    62.640   624.383     0.150
    62.870   625.883     0.150
    63.200   627.586     0.150
    63.435   628.984     0.150
    63.446   629.680     0.150
    63.568   631.383     0.150
    63.718   631.180     0.150
    63.747   632.586     0.150
    63.789   632.781     0.150
    64.337   636.281     0.150
    64.895   639.984     0.150
    66.001   646.586     0.150
    66.515   649.883     0.150
    66.818   650.562     0.150
    67.205   655.430     0.150
    67.519   657.180     0.150
    67.538   657.781     0.150
    67.759   658.883     0.150
    68.257   661.234     0.150
    68.281   660.984     0.150
    68.843   665.484     0.150
    68.871   664.086     0.150
    68.871   662.523     0.150
    69.436   667.680     0.150
    69.436   667.883     0.150
    69.471   668.109     0.150
    69.580   668.602     0.150
    69.825   671.844     0.150
    69.935   672.883     0.150
    70.016   674.883     0.150
    70.085   672.258     0.150
    70.136   672.531     0.150
    70.223   673.750     0.150
    70.267   674.320     0.150
    70.631   676.039     0.150
    70.631   676.539     0.150
    70.631   676.273     0.150
    70.646   676.305     0.150
    70.795   678.281     0.150
    70.841   677.609     0.150
    70.904   678.586     0.150
    70.906   677.680     0.150
    70.913   677.875     0.150
    70.910   675.383     0.150
    71.080   679.547     0.150
    71.103   679.531     0.150
    71.224   680.055     0.150
    71.259   680.109     0.150
    71.283   680.617     0.150
    71.298   680.242     0.150
    71.513   681.859     0.150
    71.499   682.781     0.150
    71.615   682.242     0.150
    71.638   682.773     0.150
    71.630   681.992     0.150
    71.677   681.555     0.150
    71.734   683.484     0.150
    71.737   682.938     0.150
    71.749   683.203     0.150
    71.771   683.781     0.150
    71.863   684.180     0.150
    71.897   682.391     0.150
    72.030   684.812     0.150
    72.112   684.680     0.150
    72.132   685.336     0.150
    72.173   684.055     0.150
    72.173   683.789     0.150
    72.194   685.516     0.150
    72.297   685.516     0.150
    72.335   686.781     0.150
    72.359   686.578     0.150
    72.383   686.875     0.150
    72.565   686.734     0.150
    72.586   688.352     0.150
    72.631   687.461     0.150
    72.643   688.672     0.150
    72.651   688.578     0.150
    72.666   689.094     0.150
    72.710   688.859     0.150
    72.739   689.086     0.150
    72.749   688.016     0.150
    72.871   688.969     0.150
    72.922   690.016     0.150
    72.950   689.516     0.150
    72.952   690.352     0.150
    72.957   690.508     0.150
    72.980   690.312     0.150
    73.004   690.398     0.150
    73.091   690.383     0.150
    73.116   690.266     0.150
    73.200   691.680     0.150
    73.244   691.992     0.150
    73.276   692.453     0.150
    73.294   692.188     0.150
    73.358   693.320     0.150
    73.375   693.086     0.150
    73.409   693.461     0.150
    73.428   692.531     0.150
    73.445   692.672     0.150
    73.519   693.469     0.150
    73.618   693.289     0.150
    73.641   693.625     0.150
    73.664   694.344     0.150
    73.663   694.477     0.150
    73.692   694.891     0.150
    73.714   694.891     0.150
    73.749   695.336     0.150
    73.778   695.414     0.150
    73.806   695.227     0.150
    73.890   696.180     0.150
    73.910   695.742     0.150
    73.965   695.453     0.150
    73.965   695.305     0.150
    74.030   696.406     0.150
    74.061   695.812     0.150
    74.100   697.102     0.150
    74.121   696.789     0.150
    74.139   697.375     0.150
    74.189   697.273     0.150
    74.335   698.602     0.150
    74.400   698.133     0.150
    74.414   698.672     0.150
    74.492   698.922     0.150
    74.504   699.234     0.150
    74.522   698.930     0.150
    74.528   700.195     0.150
    74.615   699.609     0.150
    74.641   700.789     0.150
    74.650   700.008     0.150
    74.717   700.211     0.150
    74.723   701.070     0.150
    74.738   700.188     0.150
    74.806   699.555     0.150
    74.821   701.133     0.150
    74.776   703.680     0.150
    74.892   701.016     0.150
    74.999   702.344     0.150
    75.083   702.266     0.150
    75.111   702.719     0.150
    75.210   703.203     0.150
    75.225   703.516     0.150
    75.254   703.586     0.150
    75.269   703.523     0.150
    75.317   704.633     0.150
    75.367   705.117     0.150
    75.399   704.008     0.150
    75.491   705.070     0.150
    75.517   705.133     0.150
    75.521   704.945     0.150
    75.597   705.484     0.150
    75.633   706.133     0.150
    75.677   706.031     0.150
    75.692   705.961     0.150
    75.704   705.695     0.150
    75.843   707.070     0.150
    75.872   707.617     0.150
    75.933   707.453     0.150
    75.940   707.641     0.150
    76.048   708.602     0.150
    76.051   707.766     0.150
    76.089   708.648     0.150
    76.119   708.914     0.150
    76.193   709.414     0.150
    76.300   709.875     0.150
    76.300   709.852     0.150
    76.302   710.094     0.150
    76.281   708.883     0.150
    76.281   708.484     0.150
    76.428   710.492     0.150
    76.452   710.750     0.150
    76.504   710.633     0.150
    76.517   710.398     0.150
    76.619   711.617     0.150
    76.667   710.984     0.150
    76.669   712.109     0.150
    76.690   711.898     0.150
    76.698   709.961     0.150
    76.733   712.258     0.150
    76.806   713.258     0.150
    76.910   713.484     0.150
    76.944   713.680     0.150
    76.956   713.930     0.150
    76.967   715.141     0.150
    76.983   715.281     0.150
    77.091   715.352     0.150
    77.312   716.094     0.150
    77.422   716.664     0.150
    77.428   716.688     0.150
    77.448   716.773     0.150
    77.474   717.000     0.150
    77.529   717.672     0.150
    77.578   717.414     0.150
    77.561   717.484     0.150
    77.657   718.141     0.150
    77.663   718.297     0.150
    77.805   718.672     0.150
    77.819   719.336     0.150
    77.829   719.062     0.150
    77.830   719.148     0.150
    77.845   718.500     0.150
    77.900   719.539     0.150
    77.906   719.609     0.150
    77.942   719.391     0.150
    77.965   718.930     0.150
    78.004   719.812     0.150
    78.034   720.297     0.150
    78.082   719.844     0.150
    78.099   720.625     0.150
    78.216   721.539     0.150
    78.230   721.555     0.150
    78.241   721.188     0.150
    78.339   721.461     0.150
    78.444   721.656     0.150
    78.481   722.609     0.150
    78.509   721.953     0.150
    78.524   722.766     0.150
    78.640   723.578     0.150
    78.766   723.648     0.150
    78.797   723.617     0.150
    78.803   724.547     0.150
    78.810   724.359     0.150
    78.863   724.242     0.150
    78.878   723.219     0.150
    78.878   723.234     0.150
    78.995   725.445     0.150
    78.995   725.562     0.150
    79.020   724.148     0.150
    79.027   725.758     0.150
    79.032   724.281     0.150
    79.038   725.219     0.150
    79.122   725.289     0.150
    79.243   726.211     0.150
    79.257   726.586     0.150
    79.257   726.250     0.150
    79.312   725.727     0.150
    79.374   726.844     0.150
    79.408   728.086     0.150
    79.448   727.977     0.150
    79.523   727.266     0.150
    79.550   727.266     0.150
    79.577   728.164     0.150
    79.619   728.664     0.150
    79.623   728.125     0.150
    79.644   728.586     0.150
    79.696   728.383     0.150
    79.745   728.859     0.150
    79.759   728.711     0.150
    79.775   730.258     0.150
    79.775   728.484     0.150
    79.752   728.336     0.150
    79.918   729.461     0.150
    79.939   730.430     0.150
    79.974   729.875     0.150
    79.986   730.648     0.150
    80.073   731.008     0.150
    80.085   730.359     0.150
    80.159   730.812     0.150
    80.078   733.086     0.150
    80.200   731.266     0.150
    80.219   730.719     0.150
    80.292   732.148     0.150
    80.292   731.680     0.150
    80.319   732.406     0.150
    80.331   730.352     0.150
    80.382   732.281     0.150
    80.441   732.766     0.150
    80.503   732.484     0.150
    80.555   732.453     0.150
    80.591   733.688     0.150
    80.612   733.945     0.150
    80.612   734.352     0.150
    80.679   734.094     0.150
    80.706   734.453     0.150
    80.720   733.539     0.150
    80.738   734.539     0.150
    80.765   734.719     0.150
    80.899   735.266     0.150
    80.917   735.891     0.150
    80.948   734.945     0.150
    80.976   733.844     0.150
    81.028   736.023     0.150
    81.031   736.312     0.150
    81.044   736.172     0.150
    81.065   736.156     0.150
    81.084   736.117     0.150
    81.129   736.492     0.150
    81.181   737.156     0.150
    81.250   737.102     0.150
    81.288   737.125     0.150
    81.303   737.305     0.150
    81.339   737.242     0.150
    81.342   738.312     0.150
    81.520   738.641     0.150
    81.548   738.750     0.150
    81.582   738.656     0.150
    81.585   739.008     0.150
    81.648   739.414     0.150
    81.687   739.148     0.150
    81.698   740.195     0.150
    81.766   740.102     0.150
    81.825   740.250     0.150
    81.945   740.430     0.150
    81.965   740.953     0.150
    81.980   740.711     0.150
    81.980   740.281     0.150
    81.999   741.680     0.150
    82.030   741.180     0.150
    82.104   740.969     0.150
    82.120   742.336     0.150
    82.209   742.508     0.150
    82.236   742.227     0.150
    82.255   742.234     0.150
    82.275   743.367     0.150
    82.348   742.844     0.150
    82.349   743.367     0.150
    82.275   741.484     0.150
    82.407   743.242     0.150
    82.453   743.789     0.150
    82.497   743.711     0.150
    82.563   743.359     0.150
    82.576   744.547     0.150
    82.701   745.336     0.150
    82.710   744.281     0.150
    82.739   745.906     0.150
    82.771   744.750     0.150
    82.836   744.625     0.150
    82.844   745.789     0.150
    82.845   745.812     0.150
    82.895   746.430     0.150
    82.930   746.391     0.150
    83.064   747.062     0.150
    83.072   747.078     0.150
    83.085   746.859     0.150
    83.110   746.922     0.150
    83.118   746.141     0.150
    83.242   747.609     0.150
    83.258   747.477     0.150
    83.350   746.602     0.150
    83.374   748.195     0.150
    83.376   748.320     0.150
    83.418   748.680     0.150
    83.450   748.250     0.150
    83.456   748.711     0.150
    83.460   749.055     0.150
    83.526   749.234     0.150
    83.563   749.156     0.150
    83.642   748.719     0.150
    83.652   748.938     0.150
    83.707   750.312     0.150
    83.877   751.430     0.150
    83.905   750.406     0.150
    83.999   751.016     0.150
    84.071   751.578     0.150
    84.117   752.539     0.150
    84.256   752.742     0.150
    84.285   753.102     0.150
    84.336   752.844     0.150
    84.336   753.180     0.150
    84.371   753.961     0.150
    84.502   754.391     0.150
    84.533   754.367     0.150
    84.535   754.070     0.150
    84.546   753.766     0.150
    84.602   754.711     0.150
    84.663   754.711     0.150
    84.670   754.766     0.150
    84.763   755.258     0.150
    84.980   755.867     0.150
    85.031   757.102     0.150
    85.033   756.977     0.150
    85.033   755.883     0.150
    85.059   757.469     0.150
    85.065   756.531     0.150
    85.105   756.797     0.150
    85.118   757.375     0.150
    85.241   757.438     0.150
    85.300   758.062     0.150
    85.371   758.914     0.150
    85.379   758.578     0.150
    85.506   759.406     0.150
    85.436   760.984     0.150
    85.564   759.219     0.150
    85.614   759.734     0.150
    85.658   759.523     0.150
    85.704   760.656     0.150
    85.728   760.398     0.150
    85.792   760.711     0.150
    85.893   760.781     0.150
    85.901   761.117     0.150
    85.909   761.109     0.150
    85.954   761.398     0.150
    86.000   761.648     0.150
    86.021   761.891     0.150
    86.023   762.266     0.150
    86.145   762.133     0.150
    86.161   762.211     0.150
    86.274   762.641     0.150
    86.325   761.430     0.150
    86.362   763.445     0.150
    86.388   763.344     0.150
    86.406   763.055     0.150
    86.411   763.797     0.150
    86.506   764.492     0.150
    86.685   764.945     0.150
    86.767   765.391     0.150
    86.817   766.211     0.150
    86.879   766.414     0.150
    86.919   766.352     0.150
    86.960   765.531     0.150
    87.034   766.180     0.150
    87.078   766.805     0.150
    87.081   767.070     0.150
    87.118   767.656     0.150
    87.132   767.984     0.150
    87.288   768.477     0.150
    87.328   767.648     0.150
    87.345   768.195     0.150
    87.348   769.133     0.150
    87.443   769.219     0.150
    87.634   769.484     0.150
    87.645   769.742     0.150
    87.717   770.352     0.150
    87.730   770.250     0.150
    87.833   771.031     0.150
    87.833   770.359     0.150
    87.841   770.164     0.150
    87.925   770.695     0.150
    88.098   771.648     0.150
    88.118   772.305     0.150
    88.131   771.922     0.150
    88.130   772.086     0.150
    88.226   772.211     0.150
    88.278   772.445     0.150
    88.470   773.719     0.150
    88.485   773.320     0.150
    88.632   774.805     0.150
    88.659   775.023     0.150
    88.676   774.555     0.150
    88.722   775.336     0.150
    88.858   775.664     0.150
    88.902   775.656     0.150
    88.932   775.453     0.150
    88.947   775.992     0.150
    88.952   775.594     0.150
    89.085   776.531     0.150
    89.036   773.984     0.150
    89.189   776.883     0.150
    89.234   777.062     0.150
    89.255   776.977     0.150
    89.262   777.562     0.150
    89.293   776.875     0.150
    89.320   777.414     0.150
    89.320   777.180     0.150
    89.320   988.406     0.150
    89.392   777.602     0.150
    89.424   778.172     0.150
    89.457   777.617     0.150
    89.505   778.328     0.150
    89.518   778.281     0.150
    89.551   777.984     0.150
    89.571   777.586     0.150
    89.571   777.336     0.150
    89.571   777.203     0.150
    89.686   778.773     0.150
    89.788   779.742     0.150
    89.991   780.727     0.150
    90.194  1437.281     0.150
    90.194  1793.180     0.150
    90.810   784.664     0.150
    91.139   785.609     0.150
    91.356   787.156     0.150
    91.738   788.695     0.150
    92.049   790.156     0.150
    92.293   791.336     0.150
    92.346   791.414     0.150
    92.758   792.719     0.150
    93.062   794.711     0.150
    93.097   793.812     0.150
    93.097  1007.180     0.150
    93.168   794.992     0.150
   111.004  2073.883     0.150
   125.295  1141.047     0.150
   142.981  1174.508     0.150
   142.981  1174.375     0.150
   143.049  1171.914     0.150
   147.291  1181.586     0.150
   147.572  1182.680     0.150
   151.060  1187.055     0.150
   151.060  1192.461     0.150
     0.157     3.523     0.150
     0.157     6.125     0.150
     0.575    10.820     0.150
     0.575    19.320     0.150
     0.645    12.625     0.150
     0.645    21.820     0.150
     0.645    21.625     0.150
     0.981    17.625     0.150
     0.981    30.727     0.150
     0.981    17.727     0.150
     1.086    21.023     0.150
     1.086    36.320     0.150
     1.392    25.523     0.150
     1.392    44.820     0.150
     1.501    27.523     0.150
     1.501    47.922     0.150
     1.620    29.922     0.150
     1.620    51.422     0.150
     2.246    37.625     0.150
     2.246    39.523     0.150
     2.246    69.820     0.150
     2.246    69.523     0.150
     2.575    42.727     0.150
     2.575    46.227     0.150
     2.575    73.820     0.150
     2.575    80.125     0.150
     2.575    73.023     0.150
     2.575    79.727     0.150
     2.640    42.922     0.150
     2.640    47.422     0.150
     2.640    74.727     0.150
     2.640    81.320     0.150
     2.763    43.227     0.150
     2.763    48.422     0.150
     2.763    84.320     0.150
     2.763    50.625     0.150
     2.763    81.422     0.150
     2.763    85.227     0.150
     3.054    91.727     0.150
     3.054    49.422     0.150
     3.054    54.422     0.150
     3.054    94.320     0.150
     3.334   102.922     0.150
     3.365    52.820     0.150
     3.365    60.125     0.150
     3.365   103.523     0.150
     3.365    52.922     0.150
     3.365    60.023     0.150
     3.365   103.625     0.150
     3.421    61.023     0.150
     3.421   106.125     0.150
     3.733    57.625     0.150
     3.733    65.727     0.150
     3.733   114.922     0.150
     3.939    61.422     0.150
     3.939    70.820     0.150
     3.939   119.922     0.150
     4.329    65.820     0.150
     4.329    77.422     0.150
     4.329   133.422     0.150
     4.329    65.320     0.150
     4.329   114.320     0.150
     4.329   133.227     0.150
     4.340    67.820     0.150
     4.340    78.023     0.150
     4.340   134.820     0.150
     4.856    88.625     0.150
     4.856   149.422     0.150
     4.856    75.922     0.150
     4.856   131.922     0.150
     4.856   149.820     0.150
     5.303    81.625     0.150
     5.303   140.523     0.150
     5.303   163.820     0.150
     5.523   169.820     0.150
     5.497   171.320     0.150
     6.883   212.320     0.150
     0.168     3.383     0.150
     0.168     5.781     0.150
     0.631    12.383     0.150
     0.631    21.281     0.150
     0.631    21.078     0.150
     0.986    17.578     0.150
     0.986    30.781     0.150
     0.986    17.680     0.150
     0.986    30.883     0.150
     1.087    20.883     0.150
     1.087    35.883     0.150
     1.387    25.281     0.150
     1.387    44.383     0.150
     1.509    27.477     0.150
     1.509    47.477     0.150
     1.622    29.977     0.150
     1.622    52.180     0.150
     2.245    37.578     0.150
     2.245    39.477     0.150
     2.245    69.477     0.150
     2.566    42.781     0.150
     2.566    46.078     0.150
     2.566    80.180     0.150
     2.566    45.977     0.150
     2.566    75.883     0.150
     2.566    78.977     0.150
     2.637    42.383     0.150
     2.637    47.281     0.150
     2.637    81.477     0.150
     2.758    45.383     0.150
     2.758    49.883     0.150
     2.758    84.781     0.150
     2.758    49.781     0.150
     2.758    84.883     0.150
     3.048    53.883     0.150
     3.048    91.977     0.150
     3.048    94.180     0.150
     3.347    60.977     0.150
     3.347   103.383     0.150
     3.362    60.477     0.150
     3.362   104.281     0.150
     3.362   103.078     0.150
     3.417    60.281     0.150
     3.417   105.680     0.150
     3.734    66.680     0.150
     3.734   115.680     0.150
     3.933   120.680     0.150
     3.933   119.477     0.150
     4.344    64.977     0.150
     4.344    77.680     0.150
     4.344   114.781     0.150
     4.344   133.680     0.150
     4.340   135.477     0.150
     4.851   127.281     0.150
     4.851   148.281     0.150
     5.294   141.883     0.150
     5.294   163.281     0.150
     5.518    82.477     0.150
     5.518   169.781     0.150
     5.507   173.281     0.150
     6.685   206.477     0.150
     6.890   212.180     0.150
     0.164     3.562     0.150
     0.164     6.164     0.150
     0.577    11.367     0.150
     0.577    19.469     0.150
     0.637    12.469     0.150
     0.637    21.469     0.150
     0.637    21.367     0.150
     0.985    17.766     0.150
     0.985    30.867     0.150
     0.985    17.867     0.150
     0.985    31.164     0.150
     1.085    20.562     0.150
     1.085    35.969     0.150
     1.388    25.062     0.150
     1.388    25.164     0.150
     1.504    27.562     0.150
     1.504    47.867     0.150
     1.619    29.969     0.150
     1.619    51.367     0.150
     2.247    37.664     0.150
     2.247    39.664     0.150
     2.247    70.062     0.150
     2.247    37.766     0.150
     2.247    39.766     0.150
     2.247    69.867     0.150
     2.572    42.867     0.150
     2.572    46.266     0.150
     2.572    80.664     0.150
     2.572    42.664     0.150
     2.572    45.969     0.150
     2.572    76.469     0.150
     2.572    79.469     0.150
     2.637    43.266     0.150
     2.637    48.164     0.150
     2.637    74.062     0.150
     2.637    81.266     0.150
     2.759    48.562     0.150
     2.759    85.062     0.150
     2.759    85.469     0.150
     3.052    53.664     0.150
     3.052    84.164     0.150
     3.052    93.266     0.150
     3.052    49.062     0.150
     3.052    54.266     0.150
     3.052    94.562     0.150
     3.341    58.969     0.150
     3.341   102.766     0.150
     3.341    59.562     0.150
     3.341   103.562     0.150
     3.362    59.266     0.150
     3.362   102.867     0.150
     3.362    53.062     0.150
     3.362    60.367     0.150
     3.362   103.867     0.150
     3.420    60.562     0.150
     3.420   108.164     0.150
     3.420   106.969     0.150
     3.735    58.164     0.150
     3.735    64.664     0.150
     3.735    99.062     0.150
     3.735   115.969     0.150
     3.735    58.266     0.150
     3.735    65.469     0.150
     3.735    67.367     0.150
     3.934    62.664     0.150
     3.934    70.969     0.150
     3.934    62.562     0.150
     3.934    70.867     0.150
     3.934   121.164     0.150
     3.934   119.469     0.150
     4.336    65.562     0.150
     4.336    77.562     0.150
     4.336   115.766     0.150
     4.336   132.766     0.150
     4.336    65.266     0.150
     4.336    77.766     0.150
     4.336   114.969     0.150
     4.336   133.062     0.150
     4.339    67.164     0.150
     4.339    77.562     0.150
     4.339   135.062     0.150
     4.339    78.062     0.150
     4.339   135.664     0.150
     5.297    81.562     0.150
     5.297   142.164     0.150
     5.522    81.266     0.150
     5.522    97.766     0.150
     5.522   169.562     0.150
     5.522    82.469     0.150
     5.522    98.367     0.150
     5.522   169.969     0.150
     5.501    85.062     0.150
     5.501   171.766     0.150
     6.686    99.766     0.150
     6.686   206.664     0.150
     6.888   100.664     0.150
     6.888   122.766     0.150
     6.888   177.562     0.150
     6.888   100.969     0.150
     6.888   212.469     0.150
     8.128   251.664     0.150
     9.915   307.562     0.150
     0.148     3.020     0.150
     0.148     5.219     0.150
     0.588    11.422     0.150
     0.588    19.719     0.150
     0.648    12.820     0.150
     0.648    22.020     0.150
     0.968    17.121     0.150
     1.100    20.719     0.150
     1.100    36.422     0.150
     1.100    38.922     0.150
     1.186    21.922     0.150
     1.186    38.219     0.150
     1.405    25.621     0.150
     1.405    25.520     0.150
     1.405    45.121     0.150
     1.514    27.621     0.150
     1.514    28.621     0.150
     1.514    48.621     0.150
     1.634    29.422     0.150
     1.634    30.422     0.150
     1.634    51.922     0.150
     1.634    52.922     0.150
     1.915    33.520     0.150
     1.915    34.719     0.150
     1.915    60.820     0.150
     2.232    37.320     0.150
     2.232    39.621     0.150
     2.232    69.219     0.150
     2.232    39.320     0.150
     2.232    69.621     0.150
     2.564    42.922     0.150
     2.564    46.121     0.150
     2.564    42.422     0.150
     2.564    46.320     0.150
     2.564    79.520     0.150
     2.654    43.121     0.150
     2.654    47.219     0.150
     2.654    48.719     0.150
     2.654    75.520     0.150
     2.654    81.922     0.150
     2.776    44.922     0.150
     2.776    50.219     0.150
     2.776    84.922     0.150
     2.776    49.922     0.150
     2.776    82.320     0.150
     2.776    85.719     0.150
     3.040    48.820     0.150
     3.040    54.219     0.150
     3.040    83.621     0.150
     3.040    48.922     0.150
     3.040    94.020     0.150
     3.327    51.719     0.150
     3.327    59.520     0.150
     3.327    90.820     0.150
     3.327   102.621     0.150
     3.327    52.020     0.150
     3.327    60.020     0.150
     3.327   104.520     0.150
     3.407    60.719     0.150
     3.407   105.719     0.150
     3.407    60.922     0.150
     3.407   107.219     0.150
     3.379    53.121     0.150
     3.379    60.621     0.150
     3.379   104.520     0.150
     3.379    53.020     0.150
     3.379    61.020     0.150
     3.379   104.922     0.150
     3.379   105.520     0.150
     3.719    58.121     0.150
     3.719    66.020     0.150
     3.719   114.020     0.150
     3.719   114.922     0.150
     3.951    61.121     0.150
     3.951    72.020     0.150
     3.951    61.020     0.150
     3.951    69.922     0.150
     3.951   120.820     0.150
     4.078    74.922     0.150
     4.078   128.520     0.150
     4.354    67.320     0.150
     4.354    78.020     0.150
     4.354   135.820     0.150
     4.354    78.219     0.150
     4.354    79.020     0.150
     4.354   117.719     0.150
     4.354   135.621     0.150
     4.869    75.820     0.150
     4.869    88.719     0.150
     4.869   132.922     0.150
     4.869   149.422     0.150
     4.869    75.922     0.150
     4.869    89.020     0.150
     4.869   133.219     0.150
     4.869   150.219     0.150
     4.869    75.719     0.150
     5.314    80.121     0.150
     5.314    95.422     0.150
     5.314   139.621     0.150
     5.314   162.820     0.150
     5.509    81.820     0.150
     5.509    98.320     0.150
     5.509    83.621     0.150
     5.509    96.020     0.150
     5.509    98.719     0.150
     5.509   169.719     0.150
     5.509   148.820     0.150
     5.509   172.621     0.150
     5.624    84.922     0.150
     5.624   101.500     0.150
     5.624   150.879     0.150
     5.624   178.102     0.150
     6.670   121.520     0.150
     6.670    98.621     0.150
     6.670   172.719     0.150
     6.670   207.422     0.150
     6.871   100.520     0.150
     6.871   122.719     0.150
     6.871   177.422     0.150
     6.871   100.320     0.150
     6.871   123.820     0.150
     6.871   212.219     0.150
     8.115   117.422     0.150
     8.115   250.922     0.150
     9.898   304.820     0.150
     9.914   142.520     0.150
    14.059   199.520     0.150
    17.983   250.520     0.150
    17.983   250.195     0.150
    17.983   251.020     0.150
    18.514   256.344     0.150
    18.514   258.820     0.150
    18.599   256.344     0.150
    20.474   278.820     0.150
    20.474   279.301     0.150
    22.681   301.984     0.150
    24.092   316.121     0.150
    50.952   543.438     0.150
    79.744   728.172     0.150
     0.143     3.082     0.150
     0.143     5.282     0.150
     0.593    11.482     0.150
     0.593    19.982     0.150
     0.652    12.882     0.150
     0.652    22.082     0.150
     0.962    17.182     0.150
     0.962    20.782     0.150
     0.962    29.982     0.150
     1.106    21.382     0.150
     1.106    35.682     0.150
     1.191    21.882     0.150
     1.191    23.082     0.150
     1.191    37.782     0.150
     1.191    40.982     0.150
     1.411    25.882     0.150
     1.411    44.782     0.150
     1.518    27.682     0.150
     1.518    28.582     0.150
     1.518    48.582     0.150
     1.639    30.582     0.150
     1.639    52.882     0.150
     1.920    33.282     0.150
     1.920    34.682     0.150
     1.920    60.782     0.150
     2.226    37.482     0.150
     2.226    39.182     0.150
     2.226    69.182     0.150
     2.560    42.682     0.150
     2.560    45.982     0.150
     2.560    45.782     0.150
     2.560    79.082     0.150
     2.660    43.282     0.150
     2.660    48.682     0.150
     2.660    75.582     0.150
     2.660    81.882     0.150
     2.782    84.682     0.150
     3.035    48.582     0.150
     3.035    54.082     0.150
     3.035    83.682     0.150
     3.035    91.682     0.150
     3.035    49.482     0.150
     3.035    94.382     0.150
     3.323   103.482     0.150
     3.385    53.182     0.150
     3.385    60.382     0.150
     3.385   104.282     0.150
     3.385    53.282     0.150
     3.385    61.282     0.150
     3.385   105.082     0.150
     3.713    58.582     0.150
     3.713    66.182     0.150
     3.713   114.682     0.150
     3.958    71.382     0.150
     3.958   119.382     0.150
     3.958    71.982     0.150
     3.958   122.282     0.150
     4.072    76.782     0.150
     4.072   127.582     0.150
     4.360    80.482     0.150
     4.360   137.182     0.150
     4.876    74.382     0.150
     4.876   147.982     0.150
     4.876    86.982     0.150
     4.876   132.982     0.150
     4.876   150.282     0.150
     5.244   162.682     0.150
     5.320    81.882     0.150
     5.320    82.082     0.150
     5.320   164.782     0.150
     5.504   169.882     0.150
     6.664   205.782     0.150
     6.664   206.982     0.150
     0.164     3.169     0.150
     0.164     5.269     0.150
     0.573    11.069     0.150
     0.573    19.269     0.150
     0.638    12.169     0.150
     0.638    21.369     0.150
     0.638    12.469     0.150
     0.638    13.169     0.150
     0.638    21.269     0.150
     0.988    17.469     0.150
     1.081    20.569     0.150
     1.081    21.669     0.150
     1.081    35.769     0.150
     1.081    38.469     0.150
     1.170    21.569     0.150
     1.170    22.369     0.150
     1.170    37.769     0.150
     1.170    40.569     0.150
     1.385    25.369     0.150
     1.385    25.569     0.150
     1.385    44.669     0.150
     1.385    46.369     0.150
     1.500    27.469     0.150
     1.500    47.869     0.150
     1.615    29.169     0.150
     1.615    30.269     0.150
     1.615    52.369     0.150
     1.898    33.369     0.150
     1.898    34.769     0.150
     1.898    60.469     0.150
     2.251    37.669     0.150
     2.251    39.569     0.150
     2.251    69.369     0.150
     2.251    37.469     0.150
     2.251    69.969     0.150
     2.576    45.569     0.150
     2.576    79.069     0.150
     2.634    43.069     0.150
     2.634    47.169     0.150
     2.634    75.769     0.150
     2.634    81.169     0.150
     2.756    49.569     0.150
     2.756    83.269     0.150
     2.756    85.269     0.150
     3.056    49.069     0.150
     3.056    54.269     0.150
     3.056    83.569     0.150
     3.056    54.469     0.150
     3.056    94.769     0.150
     3.359    51.569     0.150
     3.359    59.069     0.150
     3.359   103.269     0.150
     3.359    53.269     0.150
     3.359    60.569     0.150
     3.359   104.369     0.150
     3.424   107.969     0.150
     3.738    58.769     0.150
     3.738    66.369     0.150
     3.738    58.969     0.150
     3.738    67.369     0.150
     3.738   115.369     0.150
     3.932    61.769     0.150
     3.932    70.969     0.150
     3.932   119.869     0.150
     3.932    61.069     0.150
     3.932    70.169     0.150
     3.932   121.069     0.150
     4.097   128.569     0.150
     4.335    77.669     0.150
     4.335   135.369     0.150
     4.850    87.669     0.150
     4.850   147.569     0.150
     4.850    75.769     0.150
     4.850    83.569     0.150
     4.850   149.269     0.150
     5.269    95.069     0.150
     5.269   162.069     0.150
     5.269    94.469     0.150
     5.269   136.169     0.150
     5.269   163.569     0.150
     5.296    81.469     0.150
     5.296    81.869     0.150
     5.296   140.669     0.150
     5.296   164.069     0.150
     6.690   207.569     0.150
     6.890   100.569     0.150
     0.155     3.219     0.150
     0.155     5.219     0.150
     0.578    11.020     0.150
     0.578    19.422     0.150
     0.645    12.520     0.150
     0.645    21.621     0.150
     0.645    21.422     0.150
     1.394    25.219     0.150
     1.394    44.121     0.150
     1.394    25.320     0.150
     1.394    45.320     0.150
     1.504    27.621     0.150
     1.504    48.020     0.150
     1.622    29.219     0.150
     1.622    30.320     0.150
     1.622    52.621     0.150
     1.664    30.820     0.150
     1.664    31.219     0.150
     1.664    53.719     0.150
     1.904    33.422     0.150
     1.904    34.820     0.150
     1.904    61.320     0.150
     2.244    37.719     0.150
     2.244    39.621     0.150
     2.244    69.320     0.150
     2.244    69.820     0.150
     2.573    43.520     0.150
     2.573    44.820     0.150
     2.573    79.219     0.150
     2.642    43.121     0.150
     2.642    47.320     0.150
     2.642    81.320     0.150
     2.765    50.219     0.150
     2.765    84.020     0.150
     2.765    85.121     0.150
     3.051    54.121     0.150
     3.051    84.520     0.150
     3.051    93.320     0.150
     3.051    54.520     0.150
     3.051    94.219     0.150
     3.333    51.922     0.150
     3.333    57.020     0.150
     3.333   102.820     0.150
     3.333   101.922     0.150
     3.419   106.219     0.150
     3.368    52.422     0.150
     3.368    60.020     0.150
     3.368   103.320     0.150
     3.368    52.820     0.150
     3.368    60.121     0.150
     3.368   104.320     0.150
     3.731    58.621     0.150
     3.731   114.219     0.150
     3.731    57.719     0.150
     3.731    66.520     0.150
     3.731   114.621     0.150
     3.941    71.621     0.150
     3.941   120.219     0.150
     3.941    61.520     0.150
     3.941    70.320     0.150
     3.941   121.820     0.150
     4.089   127.621     0.150
     4.329    65.320     0.150
     4.329    77.219     0.150
     4.329   115.520     0.150
     4.329   132.621     0.150
     4.859    75.621     0.150
     4.859    87.719     0.150
     4.859    75.922     0.150
     4.859   150.621     0.150
     5.261    96.219     0.150
     5.261   162.121     0.150
     5.261    94.320     0.150
     5.261   163.020     0.150
     5.305    81.621     0.150
     5.305    81.820     0.150
     5.305    94.820     0.150
     5.305   142.820     0.150
     5.305   157.922     0.150
     5.305   166.121     0.150
     5.520   170.820     0.150
     5.500   100.320     0.150
     5.500   172.320     0.150
     6.681    99.520     0.150
     6.681   119.520     0.150
     6.681   207.320     0.150
     6.681   207.621     0.150
     6.881   100.922     0.150
     6.881   177.621     0.150
     6.881   211.820     0.150
     0.170     2.691     0.150
     0.170     5.094     0.150
     0.564    18.492     0.150
     0.637    12.191     0.150
     0.637    21.094     0.150
     1.377    44.691     0.150
     1.491    48.094     0.150
     1.606    52.492     0.150
     1.648    53.691     0.150
     1.889    34.094     0.150
     1.889    60.395     0.150
     1.889    34.395     0.150
     2.260    69.594     0.150
     2.585    45.992     0.150
     2.585    79.895     0.150
     2.625    46.395     0.150
     2.625    81.094     0.150
     2.748    84.395     0.150
     3.066    95.594     0.150
     3.344   103.094     0.150
     3.350   105.691     0.150
     3.434   106.992     0.150
     3.748    66.895     0.150
     3.748   115.492     0.150
     3.924   121.492     0.150
     4.332    77.293     0.150
     4.332   133.191     0.150
     4.326    78.293     0.150
     4.326   135.594     0.150
     4.842   148.395     0.150
     5.289   165.191     0.150
     5.489   172.395     0.150
     6.699   209.293     0.150
     6.898   214.594     0.150
     0.163     3.412     0.150
     0.163     5.912     0.150
     0.637    12.412     0.150
     0.637    21.312     0.150
     0.984    17.713     0.150
     0.984    30.514     0.150
     1.389    25.014     0.150
     1.389    44.014     0.150
     1.505    27.514     0.150
     1.505    47.713     0.150
     1.621    29.912     0.150
     1.621    51.014     0.150
     1.904    34.412     0.150
     1.904    60.113     0.150
     2.245    37.514     0.150
     2.245    39.613     0.150
     2.245    69.812     0.150
     2.571    41.412     0.150
     2.571    45.912     0.150
     2.571    73.514     0.150
     2.571    79.412     0.150
     2.638    42.912     0.150
     2.638    47.613     0.150
     2.638    74.412     0.150
     2.638    81.312     0.150
     4.337    65.312     0.150
     4.337    77.312     0.150
     4.337   113.611     0.150
     4.337   132.314     0.150
     0.152     3.195     0.150
     0.152     5.195     0.150
     0.613    11.695     0.150
     0.613    20.195     0.150
     0.637    12.293     0.150
     0.637    20.793     0.150
     0.955    17.094     0.150
     0.955    29.996     0.150
     1.120    21.094     0.150
     1.120    37.496     0.150
     1.417    25.793     0.150
     1.417    45.195     0.150
     1.539    28.094     0.150
     1.539    48.594     0.150
     1.655    30.395     0.150
     1.655    52.195     0.150
     1.736    32.895     0.150
     1.736    56.996     0.150
     2.211    37.195     0.150
     2.211    38.996     0.150
     2.211    68.195     0.150
     2.538    42.293     0.150
     2.538    45.594     0.150
     2.538    71.496     0.150
     2.538    78.195     0.150
     3.334    59.395     0.150
     3.334   103.094     0.150
     4.350    65.293     0.150
     4.350    76.496     0.150
     4.350   115.395     0.150
     4.350   132.395     0.150
     0.156     3.384     0.150
     0.156     5.684     0.150
     0.595    11.384     0.150
     0.595    19.484     0.150
     0.638    12.584     0.150
     0.638    21.284     0.150
     0.969    17.084     0.150
     0.969    30.284     0.150
     0.969    17.384     0.150
     1.103    20.684     0.150
     1.103    35.784     0.150
     1.404    25.284     0.150
     1.404    44.584     0.150
     1.522    27.784     0.150
     1.522    47.884     0.150
     1.638    30.384     0.150
     1.638    52.084     0.150
     1.680    53.284     0.150
     1.921    34.584     0.150
     1.921    60.484     0.150
     2.228    37.284     0.150
     2.228    39.284     0.150
     2.228    68.684     0.150
     2.228    68.984     0.150
     2.555    42.484     0.150
     2.555    46.284     0.150
     2.555    79.184     0.150
     2.555    45.984     0.150
     2.555    75.384     0.150
     2.654    43.184     0.150
     2.654    47.584     0.150
     2.654    81.884     0.150
     2.774    85.084     0.150
     2.774    85.384     0.150
     3.034    53.284     0.150
     3.034    91.584     0.150
     3.034    48.684     0.150
     3.034    53.684     0.150
     3.034    93.284     0.150
     3.336    58.884     0.150
     3.336   101.784     0.150
     3.336    60.984     0.150
     3.336   103.084     0.150
     3.379    53.584     0.150
     3.379    60.684     0.150
     3.379   103.184     0.150
     3.379   104.384     0.150
     3.949    59.684     0.150
     3.949    71.984     0.150
     3.949   119.984     0.150
     3.949    70.484     0.150
     3.949   120.984     0.150
     4.342    65.184     0.150
     4.342    78.084     0.150
     4.342   114.784     0.150
     4.342   133.784     0.150
     4.357    79.184     0.150
     4.357   135.984     0.150
     4.867    73.784     0.150
     4.867    87.684     0.150
     4.867   149.684     0.150
     5.247    78.384     0.150
     5.247    91.784     0.150
     5.247    93.284     0.150
     6.874   100.284     0.150
     6.874   122.284     0.150
     6.874   177.084     0.150
     6.874   196.984     0.150
     6.874   211.884     0.150
     7.560   234.684     0.150
     0.241     4.828     0.150
     0.241     8.234     0.150
     0.241     4.930     0.150
     0.241     8.828     0.150
     0.630    12.430     0.150
     0.630    22.328     0.150
     1.287    23.531     0.150
     1.287    41.430     0.150
     1.287    41.328     0.150
     1.635    50.930     0.150
     1.635    28.430     0.150
     1.635    51.133     0.150
     1.813    32.430     0.150
     1.813    33.531     0.150
     1.813    57.930     0.150
     2.046    34.234     0.150
     2.046    36.633     0.150
     2.046    64.734     0.150
     2.163    35.430     0.150
     2.163    62.430     0.150
     2.307    71.930     0.150
     2.307    40.828     0.150
     2.307    71.430     0.150
     2.511    40.734     0.150
     2.511    44.328     0.150
     2.511    70.133     0.150
     2.511    78.734     0.150
     2.562    41.328     0.150
     2.562    44.430     0.150
     2.562    72.930     0.150
     2.562    78.930     0.150
     2.901    52.133     0.150
     2.901    90.930     0.150
     3.391    90.328     0.150
     3.391   105.234     0.150
     3.534   111.133     0.150
     4.127   127.531     0.150
     4.577    68.031     0.150
     4.577    83.133     0.150
     4.577   139.930     0.150
     4.577    70.234     0.150
     4.577    82.328     0.150
     4.577   142.133     0.150
     4.712    70.133     0.150
     4.712    80.734     0.150
     5.054    91.031     0.150
     5.054   157.133     0.150
     5.630   173.328     0.150
     5.870   105.328     0.150
     5.870   182.734     0.150
     5.971   109.133     0.150
     6.065    90.133     0.150
     6.065   154.633     0.150
     6.065   188.531     0.150
     6.110   188.328     0.150
     0.124     4.324     0.150
     0.124     7.625     0.150
     0.801    14.223     0.150
     0.801    25.223     0.150
     0.801    14.324     0.150
     0.801    25.426     0.150
     0.909    17.023     0.150
     0.909    29.426     0.150
     0.909    29.324     0.150
     1.243    22.926     0.150
     1.243    40.824     0.150
     1.610    27.426     0.150
     1.610    28.723     0.150
     1.610    48.426     0.150
     1.740    31.023     0.150
     1.740    54.523     0.150
     1.789    32.324     0.150
     1.789    32.824     0.150
     1.972    34.824     0.150
     1.972    61.723     0.150
     2.147    35.125     0.150
     2.147    37.223     0.150
     2.147    65.223     0.150
     2.147    38.426     0.150
     2.147    66.125     0.150
     2.616    46.926     0.150
     2.616    73.926     0.150
     2.616    79.625     0.150
     2.616    41.625     0.150
     2.616    45.723     0.150
     2.616    73.523     0.150
     2.616    79.426     0.150
     2.823    44.125     0.150
     2.823    49.926     0.150
     2.823    76.926     0.150
     2.823    86.824     0.150
     3.062    54.824     0.150
     3.062    94.824     0.150
     3.062    46.523     0.150
     3.062    54.426     0.150
     3.062    83.723     0.150
     3.062    93.824     0.150
     3.013    53.324     0.150
     3.013    82.625     0.150
     3.013    47.426     0.150
     3.013    53.426     0.150
     3.013    92.523     0.150
     2.978    91.324     0.150
     2.978    92.125     0.150
     3.370    62.125     0.150
     3.370   105.125     0.150
     3.370   105.523     0.150
     3.594    64.324     0.150
     3.594   110.324     0.150
     3.594    55.223     0.150
     3.594    63.926     0.150
     3.594   111.125     0.150
     3.561    63.023     0.150
     3.561   108.723     0.150
     4.110    60.824     0.150
     4.110    72.824     0.150
     4.110   124.926     0.150
     4.160    63.125     0.150
     4.160    75.625     0.150
     4.160   127.125     0.150
     4.160    74.023     0.150
     4.160   127.324     0.150
     4.487    81.125     0.150
     4.487   139.723     0.150
     5.131   158.926     0.150
     5.081    76.824     0.150
     5.081    90.426     0.150
     5.081   134.723     0.150
     5.081   156.023     0.150
     5.466   168.223     0.150
     5.598    83.184     0.150
     5.598   100.445     0.150
     5.598   176.285     0.150
     5.553    82.625     0.150
     5.553   147.824     0.150
     5.553   170.824     0.150
     6.535   117.824     0.150
     6.535   202.824     0.150
     6.657   205.223     0.150
    14.321   445.098     0.150
     0.167     3.402     0.150
     0.167     5.203     0.150
     0.167     6.000     0.150
     0.633    12.402     0.150
     0.633    20.801     0.150
     0.633    21.102     0.150
     0.986    17.602     0.150
     0.986    31.000     0.150
     1.086    20.602     0.150
     1.086    21.703     0.150
     1.086    35.602     0.150
     1.086    38.203     0.150
     1.387    25.102     0.150
     1.387    26.102     0.150
     1.387    44.602     0.150
     1.507    27.402     0.150
     1.507    28.402     0.150
     1.507    47.602     0.150
     1.507    49.703     0.150
     1.621    29.902     0.150
     1.621    52.203     0.150
     1.662    30.801     0.150
     1.662    30.500     0.150
     1.662    53.902     0.150
     1.904    34.402     0.150
     1.904    59.500     0.150
     2.246    37.602     0.150
     2.246    39.703     0.150
     2.246    69.703     0.150
     2.569    42.703     0.150
     2.569    46.102     0.150
     2.569    73.703     0.150
     2.569    78.801     0.150
     2.569    42.203     0.150
     2.569    79.000     0.150
     2.637    43.000     0.150
     2.637    47.301     0.150
     2.637    75.301     0.150
     2.637    81.500     0.150
     2.758    85.203     0.150
     2.758    85.500     0.150
     3.050    48.301     0.150
     3.050    53.801     0.150
     3.050    83.402     0.150
     3.050    49.000     0.150
     3.050    54.000     0.150
     3.050    94.102     0.150
     3.362    59.602     0.150
     3.362   103.902     0.150
     3.362    60.602     0.150
     3.418    62.102     0.150
     3.418   107.703     0.150
     3.418    55.102     0.150
     3.418    60.602     0.150
     3.418    95.402     0.150
     3.418   106.602     0.150
     3.735    58.500     0.150
     3.735    67.402     0.150
     3.735   115.902     0.150
     3.933    69.500     0.150
     3.933   118.801     0.150
     3.933    70.703     0.150
     3.933   122.301     0.150
     4.092    73.801     0.150
     4.092   128.402     0.150
     4.341    65.203     0.150
     4.341    77.703     0.150
     4.341   115.402     0.150
     4.341   133.902     0.150
     4.339    77.402     0.150
     4.339   135.500     0.150
     4.851   149.602     0.150
     5.265    94.500     0.150
     5.265   164.402     0.150
     5.295   163.000     0.150
     5.295    81.602     0.150
     5.295   141.801     0.150
     5.520   169.500     0.150
     5.505    98.602     0.150
     5.505   171.801     0.150
     6.686   206.301     0.150
     6.889   100.402     0.150
     6.889   122.602     0.150
     6.889   177.902     0.150
     6.889   100.703     0.150
     0.334     6.494     0.150
     0.334    11.394     0.150
     0.482     9.594     0.150
     0.482    16.294     0.150
     0.982    17.494     0.150
     0.982    30.594     0.150
     1.208    23.494     0.150
     1.208    40.194     0.150
     1.702    31.194     0.150
     1.702    53.794     0.150
     1.761    31.494     0.150
     1.761    54.294     0.150
     1.797    32.494     0.150
     1.797    56.594     0.150
     2.074    35.594     0.150
     2.074    37.694     0.150
     2.074    65.394     0.150
     2.136    37.994     0.150
     2.136    65.494     0.150
     2.136    38.194     0.150
     2.136    66.294     0.150
     2.369    41.194     0.150
     2.369    39.694     0.150
     2.369    40.994     0.150
     2.369    71.294     0.150
     2.710    48.594     0.150
     2.710    83.394     0.150
     2.710    84.194     0.150
     2.790    50.594     0.150
     2.790    83.994     0.150
     2.790    85.394     0.150
     2.893    46.394     0.150
     2.893    51.294     0.150
     2.893    88.994     0.150
     3.416    53.994     0.150
     3.416    61.694     0.150
     3.416    93.894     0.150
     3.416   104.394     0.150
     3.416    53.794     0.150
     3.416    62.294     0.150
     3.416    95.394     0.150
     3.483    62.294     0.150
     3.483   106.994     0.150
     3.650    65.594     0.150
     3.650   112.594     0.150
     3.650    66.194     0.150
     3.650   113.394     0.150
     4.442    80.894     0.150
     4.442   139.194     0.150
     4.557    68.094     0.150
     4.557    81.294     0.150
     4.557   119.494     0.150
     4.557   139.594     0.150
     4.863    89.094     0.150
     4.863   149.994     0.150
     4.863    76.594     0.150
     4.863    86.594     0.150
     4.863   131.794     0.150
     4.863   148.894     0.150
     5.170   161.794     0.150
     5.259    80.994     0.150
     5.259    93.894     0.150
     5.259   140.294     0.150
     5.259   161.694     0.150
     5.367   164.494     0.150
     5.714   178.894     0.150
     6.604   205.694     0.150
     0.344     7.414     0.150
     0.344    12.117     0.150
     0.858    15.816     0.150
     0.858    27.016     0.150
     0.827    15.715     0.150
     0.827    27.117     0.150
     0.827    26.914     0.150
     1.340    23.816     0.150
     1.340    41.914     0.150
     1.356    24.816     0.150
     1.356    42.914     0.150
     1.356    42.316     0.150
     1.492    26.215     0.150
     1.492    45.516     0.150
     1.631    28.117     0.150
     1.631    50.316     0.150
     1.631    27.715     0.150
     1.631    49.316     0.150
     2.117    35.414     0.150
     2.117    60.414     0.150
     2.117    64.816     0.150
     2.154    37.414     0.150
     2.154    66.016     0.150
     2.154    36.016     0.150
     2.154    61.516     0.150
     2.734    47.414     0.150
     2.734    81.215     0.150
     2.734    43.215     0.150
     2.734    48.617     0.150
     2.760    43.816     0.150
     2.760    48.617     0.150
     2.760    75.016     0.150
     2.760    83.516     0.150
     2.760    83.715     0.150
     2.796    48.816     0.150
     2.796    84.516     0.150
     2.796    44.414     0.150
     2.796    49.117     0.150
     2.796    77.016     0.150
     2.796    84.715     0.150
     3.405    52.316     0.150
     3.405    59.617     0.150
     3.405    52.617     0.150
     3.405    59.215     0.150
     3.405   103.914     0.150
     3.306    59.816     0.150
     3.306   100.215     0.150
     3.306    51.215     0.150
     3.306    59.414     0.150
     3.306    89.117     0.150
     3.306   100.816     0.150
     3.786    67.516     0.150
     3.786   116.316     0.150
     3.786    67.715     0.150
     3.786   116.617     0.150
     4.016    69.117     0.150
     4.016    59.715     0.150
     4.016   104.414     0.150
     4.016   123.016     0.150
     3.880    69.117     0.150
     3.880   119.215     0.150
     4.266    76.516     0.150
     4.266    64.617     0.150
     4.266    76.715     0.150
     4.266   130.816     0.150
     4.214    74.016     0.150
     4.214   128.117     0.150
     4.214    65.516     0.150
     4.214    74.117     0.150
     4.214   113.414     0.150
     4.614    84.414     0.150
     4.614    69.617     0.150
     4.614    71.316     0.150
     4.614   121.215     0.150
     4.820    70.215     0.150
     4.820    87.215     0.150
     4.820   123.516     0.150
     4.820   123.316     0.150
     4.820   148.215     0.150
     5.486    81.617     0.150
     5.486   170.117     0.150
     5.545    82.555     0.150
     5.545   100.375     0.150
     5.545   173.277     0.150
     5.772   104.617     0.150
     5.772    86.215     0.150
     5.772   177.816     0.150
     5.872    85.117     0.150
     5.872   104.414     0.150
     5.872    85.617     0.150
     5.872   180.016     0.150
     7.218   131.117     0.150
     7.218   130.715     0.150
     7.218   222.816     0.150
     7.547   108.617     0.150
     7.547   232.516     0.150
     8.789   128.117     0.150
    13.355   189.715     0.150
    17.299   241.215     0.150
    17.299   239.840     0.150
    17.803   247.715     0.150
    17.889   247.695     0.150
    20.654   277.117     0.150
    21.982   291.215     0.150
    22.034   293.816     0.150
    76.631   708.336     0.150
    80.081   728.266     0.150
     0.332     6.869     0.150
     0.332    11.469     0.150
     0.641    11.769     0.150
     0.641    20.669     0.150
     0.978    18.069     0.150
     0.978    30.969     0.150
     1.388    25.769     0.150
     1.388    44.269     0.150
     1.427    25.669     0.150
     1.427    44.669     0.150
     1.452    26.769     0.150
     1.452    45.869     0.150
     2.263    37.869     0.150
     2.263    40.769     0.150
     2.263    65.569     0.150
     2.263    70.769     0.150
     2.578    42.069     0.150
     2.578    45.369     0.150
     2.578    72.569     0.150
     2.578    78.469     0.150
     2.692    44.569     0.150
     2.692    48.269     0.150
     2.692    75.869     0.150
     2.692    82.169     0.150
     4.657    68.769     0.150
     4.657    83.169     0.150
     4.657   121.069     0.150
     4.657   142.969     0.150
     0.151     3.355     0.150
     0.151     5.055     0.150
     0.646    12.555     0.150
     0.646    21.355     0.150
     0.646    12.656     0.150
     0.646    21.457     0.150
     0.971    17.855     0.150
     0.971    30.656     0.150
     0.971    17.555     0.150
     1.402    25.258     0.150
     1.402    44.156     0.150
     1.402    26.457     0.150
     1.402    44.355     0.150
     1.513    27.656     0.150
     1.513    47.855     0.150
     1.632    29.855     0.150
     1.632    51.555     0.150
     1.674    30.957     0.150
     1.674    31.156     0.150
     1.674    53.855     0.150
     2.234    37.457     0.150
     2.234    39.457     0.150
     2.234    65.457     0.150
     2.234    69.156     0.150
     2.234    69.258     0.150
     2.565    42.555     0.150
     2.565    46.055     0.150
     2.565    73.457     0.150
     2.565    79.758     0.150
     2.565    42.656     0.150
     2.565    45.457     0.150
     2.565    72.855     0.150
     2.565    78.855     0.150
     2.651    43.156     0.150
     2.651    46.957     0.150
     2.651    75.656     0.150
     2.651    81.758     0.150
     2.773    51.457     0.150
     2.773    86.156     0.150
     2.773    86.258     0.150
     3.041    47.957     0.150
     3.041    53.758     0.150
     3.041    83.656     0.150
     3.041    91.957     0.150
     3.041    48.855     0.150
     3.041    53.957     0.150
     3.041    93.457     0.150
     3.330    50.855     0.150
     3.330    59.457     0.150
     3.330   101.258     0.150
     3.330    52.156     0.150
     3.330    58.355     0.150
     3.330    61.656     0.150
     3.330   102.457     0.150
     3.376    53.258     0.150
     3.376    60.156     0.150
     3.376   103.457     0.150
     3.376    60.855     0.150
     3.376   104.457     0.150
     3.409    63.156     0.150
     3.409   107.758     0.150
     3.721    65.156     0.150
     3.721   100.656     0.150
     3.721   115.355     0.150
     3.721    58.156     0.150
     3.721    66.457     0.150
     3.721   114.855     0.150
     3.949    69.355     0.150
     3.949   120.055     0.150
     4.332    65.156     0.150
     4.332    78.156     0.150
     4.332   114.855     0.150
     4.332   132.855     0.150
     4.352    78.555     0.150
     4.352   135.656     0.150
     4.867    85.758     0.150
     4.867    74.855     0.150
     4.867   149.855     0.150
     5.252    78.457     0.150
     5.252    93.656     0.150
     5.311    81.758     0.150
     5.311   143.457     0.150
     5.511    82.258     0.150
     5.511    98.555     0.150
     5.511   142.355     0.150
     5.511   169.758     0.150
     5.508   171.957     0.150
     6.873   100.555     0.150
     6.873   122.156     0.150
     6.873   176.258     0.150
     6.873   101.156     0.150
     6.873   211.555     0.150
     0.150     3.391     0.150
     0.150     5.391     0.150
     0.650    12.688     0.150
     0.650    21.391     0.150
     0.974    17.391     0.150
     0.974    30.391     0.150
     1.092    20.984     0.150
     1.092    36.086     0.150
     1.399    25.289     0.150
     1.399    25.984     0.150
     1.399    43.688     0.150
     1.399    45.289     0.150
     1.504    27.586     0.150
     1.504    47.891     0.150
     1.625    30.289     0.150
     1.625    52.086     0.150
     2.241    37.391     0.150
     2.241    39.484     0.150
     2.241    69.586     0.150
     2.573    42.789     0.150
     2.573    46.484     0.150
     2.573    74.484     0.150
     2.573    79.688     0.150
     2.646    43.086     0.150
     2.646    47.891     0.150
     2.646    74.984     0.150
     2.646    81.789     0.150
     3.327   102.688     0.150
     0.157     3.988     0.150
     0.157     6.889     0.150
     0.645    12.988     0.150
     0.645    21.787     0.150
     0.982    17.188     0.150
     0.982    30.488     0.150
     1.086    20.588     0.150
     1.086    37.389     0.150
     1.392    25.088     0.150
     1.392    44.988     0.150
     1.501    27.188     0.150
     1.501    47.287     0.150
     1.619    29.389     0.150
     1.619    51.787     0.150
     1.661    30.488     0.150
     2.639    42.287     0.150
     2.639    46.588     0.150
     2.639    73.287     0.150
     2.639    80.389     0.150
     3.365    59.588     0.150
     3.365   103.688     0.150
     0.308     6.623     0.150
     0.308    11.424     0.150
     0.609    12.123     0.150
     0.609    20.123     0.150
     0.835    15.123     0.150
     0.835    26.324     0.150
     1.337    24.924     0.150
     1.337    43.123     0.150
     1.579    28.223     0.150
     1.579    49.523     0.150
     1.579    49.824     0.150
     1.579    28.523     0.150
     1.790    32.223     0.150
     1.790    56.123     0.150
     1.884    32.123     0.150
     1.884    33.924     0.150
     1.884    56.223     0.150
     1.884    59.123     0.150
     1.922    35.424     0.150
     1.997    33.623     0.150
     1.997    35.123     0.150
     1.997    58.824     0.150
     1.997    61.424     0.150
     1.997    61.723     0.150
     2.182    36.723     0.150
     2.182    39.223     0.150
     2.182    68.223     0.150
     2.286    38.023     0.150
     2.286    41.924     0.150
     2.286    65.523     0.150
     2.286    69.523     0.150
     2.775    44.723     0.150
     2.775    49.023     0.150
     2.775    76.623     0.150
     2.775    85.123     0.150
     2.854    45.523     0.150
     2.854    50.723     0.150
     2.854    79.723     0.150
     2.854    87.324     0.150
     2.939    53.123     0.150
     2.939    89.223     0.150
     3.146    98.424     0.150
     3.374    51.723     0.150
     3.374    59.123     0.150
     3.374    91.223     0.150
     3.374   101.723     0.150
     3.374    91.523     0.150
     3.374   104.824     0.150
     3.506    54.523     0.150
     3.506    62.223     0.150
     3.506    94.723     0.150
     3.506   107.824     0.150
     3.563    54.924     0.150
     3.563    62.623     0.150
     3.563    63.924     0.150
     3.563    96.623     0.150
     3.563   110.824     0.150
     4.101    63.723     0.150
     4.101    73.623     0.150
     4.101    63.824     0.150
     4.101   123.824     0.150
     4.101   126.324     0.150
     4.519    66.723     0.150
     4.519    80.123     0.150
     4.519   139.424     0.150
     4.579    70.523     0.150
     4.579    83.324     0.150
     4.579   142.523     0.150
     5.028    75.523     0.150
     5.028    91.123     0.150
     5.028   156.523     0.150
     5.012   153.924     0.150
     5.247    77.223     0.150
     5.247   161.223     0.150
     5.405    82.523     0.150
     5.405   142.223     0.150
     5.405   168.023     0.150
     5.405   142.924     0.150
     6.460   200.623     0.150
     6.748    97.723     0.150
     6.748   118.924     0.150
     6.748   173.023     0.150
     6.748    98.223     0.150
     6.748   207.223     0.150
     0.164     3.383     0.150
     0.164     5.586     0.150
     0.634    12.383     0.150
     0.634    21.086     0.150
     0.634    21.281     0.150
     0.982    17.680     0.150
     0.982    30.383     0.150
     0.982    30.883     0.150
     1.090    20.586     0.150
     1.090    23.883     0.150
     1.090    35.984     0.150
     1.391    25.086     0.150
     1.391    44.680     0.150
     1.391    46.484     0.150
     1.510    27.586     0.150
     1.510    47.984     0.150
     1.510    49.984     0.150
     1.666    30.484     0.150
     1.666    53.586     0.150
     2.242    37.586     0.150
     2.242    39.586     0.150
     2.242    65.680     0.150
     2.242    69.484     0.150
     2.242    39.484     0.150
     2.242    69.680     0.150
     2.566    42.586     0.150
     2.566    46.180     0.150
     2.566    74.180     0.150
     2.566    79.680     0.150
     2.566    45.484     0.150
     2.566    78.883     0.150
     2.641    43.180     0.150
     2.641    47.180     0.150
     2.641    75.383     0.150
     2.641    81.180     0.150
     2.762    49.586     0.150
     2.762    85.180     0.150
     2.762    48.781     0.150
     2.762    85.781     0.150
     3.046    48.680     0.150
     3.046    53.586     0.150
     3.046    83.781     0.150
     3.046    92.383     0.150
     3.046    48.883     0.150
     3.046    54.086     0.150
     3.046    94.281     0.150
     3.342    60.883     0.150
     3.342   102.586     0.150
     3.342    52.086     0.150
     3.342    59.180     0.150
     3.342    62.086     0.150
     3.342    89.586     0.150
     3.342   103.383     0.150
     3.415    60.281     0.150
     3.415   106.383     0.150
     3.415   107.586     0.150
     3.366    53.586     0.150
     3.366    60.781     0.150
     3.366    92.984     0.150
     3.366   103.586     0.150
     3.366    59.883     0.150
     3.366    94.883     0.150
     3.366   103.781     0.150
     3.730    66.281     0.150
     3.730   113.883     0.150
     3.730    58.484     0.150
     3.730    66.883     0.150
     3.730   115.781     0.150
     3.937    62.984     0.150
     3.937    72.086     0.150
     3.937   119.781     0.150
     3.937    62.680     0.150
     3.937    69.484     0.150
     3.937   120.984     0.150
     4.088    64.180     0.150
     4.088    74.180     0.150
     4.088   105.984     0.150
     4.088   128.484     0.150
     4.341    65.281     0.150
     4.341    77.586     0.150
     4.341   115.180     0.150
     4.341   134.086     0.150
     4.343    66.883     0.150
     4.343    77.484     0.150
     4.343    77.781     0.150
     4.343   134.883     0.150
     4.855    85.484     0.150
     4.855    73.281     0.150
     4.855    76.680     0.150
     4.855    85.586     0.150
     4.855   148.984     0.150
     4.855   147.883     0.150
     5.299    81.484     0.150
     5.299    95.984     0.150
     5.299   143.086     0.150
     5.299   164.484     0.150
     5.516    81.586     0.150
     5.516    97.484     0.150
     5.516   143.781     0.150
     5.516   169.180     0.150
     5.516    97.883     0.150
     5.516   170.484     0.150
     5.507    99.383     0.150
     5.507   147.883     0.150
     5.507   171.883     0.150
     6.682   122.180     0.150
     6.682   206.484     0.150
     6.886   100.781     0.150
     6.886   122.586     0.150
     6.886   177.883     0.150
     6.886   100.883     0.150
     6.886   212.484     0.150
     7.532   233.883     0.150
     8.130   252.883     0.150
    48.887   525.984     0.150
    76.287   708.281     0.150
     0.163     3.375     0.150
     0.163     5.977     0.150
     0.637    12.477     0.150
     0.637    21.273     0.150
     0.984    17.570     0.150
     0.984    30.672     0.150
     0.984    17.672     0.150
     0.984    31.477     0.150
     1.086    20.375     0.150
     1.086    35.375     0.150
     1.389    25.172     0.150
     1.389    44.875     0.150
     1.389    46.375     0.150
     1.505    27.570     0.150
     1.505    47.977     0.150
     1.505    49.875     0.150
     1.662    31.172     0.150
     1.662    30.875     0.150
     2.246    37.570     0.150
     2.246    39.570     0.150
     2.246    69.477     0.150
     2.246    69.773     0.150
     2.571    42.773     0.150
     2.571    46.273     0.150
     2.571    78.977     0.150
     2.571    42.672     0.150
     2.571    45.977     0.150
     2.571    76.875     0.150
     2.571    79.375     0.150
     2.638    43.070     0.150
     2.638    47.273     0.150
     2.638    75.570     0.150
     2.638    81.172     0.150
     2.760    49.477     0.150
     2.760    84.172     0.150
     2.760    42.172     0.150
     2.760    49.375     0.150
     2.760    84.977     0.150
     3.051    47.977     0.150
     3.051    53.570     0.150
     3.051    83.672     0.150
     3.051    92.172     0.150
     3.051    48.773     0.150
     3.051    54.070     0.150
     3.051    85.672     0.150
     3.051    94.273     0.150
     3.341    52.375     0.150
     3.341    59.375     0.150
     3.341    91.070     0.150
     3.341   102.172     0.150
     3.341    51.977     0.150
     3.341    58.375     0.150
     3.341    88.977     0.150
     3.341   103.172     0.150
     3.363    52.977     0.150
     3.363    60.172     0.150
     3.363    92.477     0.150
     3.363   103.070     0.150
     3.363    59.070     0.150
     3.363   103.172     0.150
     3.419    59.375     0.150
     3.419    61.875     0.150
     3.419   107.875     0.150
     3.734    64.773     0.150
     3.734   114.773     0.150
     3.734    58.273     0.150
     3.734    64.875     0.150
     3.734    66.977     0.150
     3.734   115.773     0.150
     3.935    62.070     0.150
     3.935    70.977     0.150
     3.935    61.875     0.150
     3.935    69.570     0.150
     3.935   120.977     0.150
     4.091    64.070     0.150
     4.091    73.773     0.150
     4.091    75.570     0.150
     4.091   128.477     0.150
     4.337    65.477     0.150
     4.337    77.477     0.150
     4.337   115.477     0.150
     4.337   133.070     0.150
     4.337    66.273     0.150
     4.337    76.875     0.150
     4.337   115.172     0.150
     4.340    66.977     0.150
     4.340    77.672     0.150
     4.340   135.375     0.150
     4.340    67.172     0.150
     4.340    77.773     0.150
     4.340   136.273     0.150
     4.853    76.172     0.150
     4.853    88.773     0.150
     4.853   128.375     0.150
     4.853    75.570     0.150
     4.853    86.375     0.150
     4.853   131.477     0.150
     4.853   149.070     0.150
     5.298    81.570     0.150
     5.298    95.375     0.150
     5.298    81.875     0.150
     5.298    94.070     0.150
     5.298   140.172     0.150
     5.298   163.375     0.150
     5.502    84.070     0.150
     5.502    98.773     0.150
     5.502   170.875     0.150
     5.520    81.672     0.150
     5.520    97.477     0.150
     5.520   168.875     0.150
     5.520    98.273     0.150
     5.520   169.773     0.150
     6.685    97.977     0.150
     6.685   207.977     0.150
     6.887   100.570     0.150
     6.887   122.273     0.150
     6.887   177.070     0.150
     6.887   212.672     0.150
     7.535   235.977     0.150
     8.128   146.375     0.150
     8.128   251.875     0.150
     8.278   256.570     0.150
     0.137     3.941     0.150
     0.137     7.043     0.150
     0.782    15.043     0.150
     0.782    26.742     0.150
     1.313    23.742     0.150
     1.313    41.441     0.150
     1.402    24.543     0.150
     1.402    24.441     0.150
     1.402    43.242     0.150
     2.059    34.242     0.150
     2.059    35.742     0.150
     2.059    64.242     0.150
     2.059    34.344     0.150
     2.059    35.844     0.150
     2.313    37.543     0.150
     2.313    40.344     0.150
     2.313    69.242     0.150
     2.313    41.344     0.150
     2.313    67.242     0.150
     2.313    71.742     0.150
     2.313    65.641     0.150
     2.269    37.543     0.150
     2.269    40.141     0.150
     2.269    71.344     0.150
     2.288    37.344     0.150
     2.288    70.844     0.150
     2.288    40.141     0.150
     2.288    64.844     0.150
     2.539    46.441     0.150
     2.539    80.043     0.150
     2.539    79.941     0.150
     2.656    47.742     0.150
     2.656    83.141     0.150
     2.842    50.141     0.150
     2.842    87.441     0.150
     2.842    44.844     0.150
     2.842    50.242     0.150
     2.842    86.941     0.150
     2.844    50.641     0.150
     2.844    86.844     0.150
     2.844    86.141     0.150
     3.233    49.844     0.150
     3.233    57.043     0.150
     3.233    87.742     0.150
     3.233   100.742     0.150
     3.233   100.641     0.150
     3.543    54.441     0.150
     3.543    63.543     0.150
     3.543    94.344     0.150
     3.543   109.344     0.150
     3.656   112.344     0.150
     3.656   113.543     0.150
     4.267    64.141     0.150
     4.267    75.742     0.150
     4.267   130.941     0.150
     4.267    64.543     0.150
     4.267    76.043     0.150
     4.267   111.344     0.150
     4.267   131.242     0.150
     4.267    63.051     0.150
     4.267   132.203     0.150
     4.336    64.242     0.150
     4.336    76.141     0.150
     4.336   132.742     0.150
     4.336    64.141     0.150
     4.336    77.441     0.150
     4.740    70.242     0.150
     4.740    83.742     0.150
     4.740   122.141     0.150
     4.740   144.641     0.150
     4.740    86.242     0.150
     4.740   124.141     0.150
     4.825    72.441     0.150
     4.825    85.941     0.150
     4.825   125.043     0.150
     4.825   147.141     0.150
     5.232    78.043     0.150
     5.232    93.641     0.150
     5.232   161.844     0.150
     5.232    93.742     0.150
     5.738    86.141     0.150
     5.738   102.941     0.150
     5.738   101.641     0.150
     5.738   149.242     0.150
     5.788    86.043     0.150
     5.788   103.844     0.150
     5.788   148.941     0.150
     5.788   178.543     0.150
     6.020    87.242     0.150
     6.020   106.141     0.150
     6.020   106.441     0.150
     6.020   185.543     0.150
     6.130    90.543     0.150
     6.130    90.844     0.150
     6.130   158.242     0.150
     6.130   191.043     0.150
     6.120    90.242     0.150
     6.120    90.141     0.150
     6.120   191.844     0.150
     6.120   109.652     0.150
     6.280    92.543     0.150
     6.280   196.961     0.150
     6.632   207.242     0.150
     7.643   107.531     0.150
    14.730   207.543     0.150
    14.730   458.762     0.150
    18.824   257.941     0.150
    19.257   262.344     0.150
    19.344   262.355     0.150
    23.320   308.043     0.150
    23.371   309.844     0.150
    23.371   306.742     0.150
    25.755   332.543     0.150
    48.086   518.543     0.150
     0.168     3.422     0.150
     0.168     5.922     0.150
     0.633    12.320     0.150
     0.633    21.320     0.150
     0.633    21.023     0.150
     0.988    17.625     0.150
     0.988    30.922     0.150
     1.084    20.625     0.150
     1.084    36.125     0.150
     1.385    25.023     0.150
     1.385    26.125     0.150
     1.385    44.023     0.150
     1.505    27.625     0.150
     1.505    47.820     0.150
     1.660    30.820     0.150
     1.660    53.523     0.150
     1.660    31.023     0.150
     1.660    53.023     0.150
     2.248    37.625     0.150
     2.248    39.422     0.150
     2.248    69.625     0.150
     2.571    45.523     0.150
     2.571    79.422     0.150
     2.571    78.922     0.150
     2.635    42.922     0.150
     2.635    47.320     0.150
     2.635    73.922     0.150
     2.635    81.523     0.150
     2.756    49.625     0.150
     2.756    84.922     0.150
     2.756    43.320     0.150
     2.756    48.922     0.150
     2.756    85.320     0.150
     3.052    54.219     0.150
     3.052    83.820     0.150
     3.052    91.922     0.150
     3.052    48.219     0.150
     3.052    84.125     0.150
     3.052    93.922     0.150
     3.346    60.820     0.150
     3.346   102.219     0.150
     3.346    59.125     0.150
     3.346    91.422     0.150
     3.346   103.125     0.150
     3.360    52.922     0.150
     3.360    60.523     0.150
     3.360   104.125     0.150
     3.737    59.320     0.150
     3.737    66.023     0.150
     3.737   115.320     0.150
     3.931    61.023     0.150
     3.931    70.523     0.150
     3.931    61.219     0.150
     3.931    70.820     0.150
     3.931   119.719     0.150
     3.931   122.320     0.150
     4.094    74.023     0.150
     4.094   126.625     0.150
     4.340    65.320     0.150
     4.340    77.422     0.150
     4.340   115.125     0.150
     4.340   133.523     0.150
     4.337    67.219     0.150
     4.337    77.719     0.150
     4.337   136.125     0.150
     5.267    94.320     0.150
     5.267   161.719     0.150
     5.267    79.422     0.150
     5.267    93.523     0.150
     5.267   163.219     0.150
     5.294    81.219     0.150
     5.294    94.922     0.150
     5.294   139.422     0.150
     5.294    81.523     0.150
     5.294   157.625     0.150
     5.294   163.523     0.150
     5.522   170.523     0.150
     5.503    83.922     0.150
     5.503    99.125     0.150
     5.503   171.320     0.150
     6.891   101.625     0.150
     6.891   177.422     0.150
     6.891   212.820     0.150
     0.166     3.559     0.150
     0.166     5.461     0.150
     0.631    12.758     0.150
     0.631    21.359     0.150
     0.983    17.758     0.150
     0.983    30.758     0.150
     0.983    17.859     0.150
     0.983    31.059     0.150
     1.090    20.660     0.150
     1.090    35.859     0.150
     1.390    25.461     0.150
     1.390    25.359     0.150
     1.390    26.660     0.150
     1.390    45.059     0.150
     1.667    31.660     0.150
     1.667    53.859     0.150
     1.909    34.961     0.150
     1.909    60.758     0.150
     2.241    37.859     0.150
     2.241    39.859     0.150
     2.241    66.258     0.150
     2.241    69.758     0.150
     2.241    65.258     0.150
     2.241    69.961     0.150
     2.564    43.160     0.150
     2.564    46.461     0.150
     2.564    72.359     0.150
     2.564    79.961     0.150
     2.564    42.859     0.150
     2.564    45.961     0.150
     2.564    73.160     0.150
     2.564    79.258     0.150
     2.640    43.160     0.150
     2.640    47.660     0.150
     2.640    75.461     0.150
     2.640    81.758     0.150
     2.761    86.059     0.150
     2.761    86.160     0.150
     3.045    53.461     0.150
     3.045    92.359     0.150
     3.045    49.160     0.150
     3.045    54.258     0.150
     3.045    84.859     0.150
     3.045    94.160     0.150
     3.345    60.859     0.150
     3.345   102.758     0.150
     3.365    53.359     0.150
     3.365    60.461     0.150
     3.365   103.559     0.150
     3.365    53.859     0.150
     3.365   104.461     0.150
     3.413    62.758     0.150
     3.413   107.059     0.150
     3.730    67.059     0.150
     3.730   115.758     0.150
     3.730    58.461     0.150
     3.730   101.961     0.150
     3.730   115.961     0.150
     3.936    63.160     0.150
     3.936    71.059     0.150
     3.936   118.758     0.150
     3.936   121.961     0.150
     4.087    72.961     0.150
     4.087   109.160     0.150
     4.087   126.559     0.150
     4.344    65.758     0.150
     4.344    77.859     0.150
     4.344   115.758     0.150
     4.344   134.160     0.150
     4.344    65.559     0.150
     4.344    78.961     0.150
     4.344   115.359     0.150
     4.343    67.961     0.150
     4.343    78.160     0.150
     4.343   135.559     0.150
     4.853    85.758     0.150
     4.853   148.758     0.150
     4.853    76.258     0.150
     4.853    86.160     0.150
     4.853   149.160     0.150
     5.260    79.160     0.150
     5.260    94.461     0.150
     5.260   163.059     0.150
     5.297    82.160     0.150
     5.297    96.160     0.150
     5.297   140.660     0.150
     5.297   164.059     0.150
     5.515    82.160     0.150
     5.515    99.160     0.150
     5.515   144.258     0.150
     5.515   170.059     0.150
     5.510    84.758     0.150
     5.510   100.160     0.150
     5.510   172.258     0.150
     6.682   206.758     0.150
     6.887   100.859     0.150
     6.887   100.961     0.150
     6.887   212.461     0.150
     9.116   281.660     0.150
     0.200     4.074     0.150
     0.200     7.074     0.150
     0.586    11.672     0.150
     0.586    19.672     0.150
     0.586    19.773     0.150
     0.966    17.375     0.150
     0.966    29.973     0.150
     1.133    21.473     0.150
     1.133    22.773     0.150
     1.133    37.375     0.150
     1.410    25.574     0.150
     1.410    45.074     0.150
     1.410    25.473     0.150
     1.714    31.973     0.150
     1.714    55.172     0.150
     1.967    34.375     0.150
     1.967    36.273     0.150
     1.967    62.773     0.150
     2.197    37.074     0.150
     2.197    38.875     0.150
     2.197    68.273     0.150
     2.497    41.875     0.150
     2.497    45.273     0.150
     2.497    71.973     0.150
     2.497    77.074     0.150
     2.497    45.074     0.150
     2.497    73.875     0.150
     2.497    76.875     0.150
     2.671    47.773     0.150
     2.671    82.574     0.150
     2.671    43.773     0.150
     2.671    47.074     0.150
     2.779    44.973     0.150
     2.779    49.574     0.150
     2.779    85.672     0.150
     2.779    49.375     0.150
     2.779    86.375     0.150
     2.988    47.172     0.150
     2.988    53.172     0.150
     2.988    83.375     0.150
     2.988    92.172     0.150
     2.988    48.375     0.150
     2.988    53.672     0.150
     2.988    93.672     0.150
     3.358    60.375     0.150
     3.358   105.172     0.150
     3.358    60.574     0.150
     3.358   105.574     0.150
     3.379    62.172     0.150
     3.379   103.875     0.150
     3.379    59.875     0.150
     3.379   104.273     0.150
     3.390    53.574     0.150
     3.390    60.074     0.150
     3.390   104.773     0.150
     3.390    53.473     0.150
     3.390    60.273     0.150
     3.950    61.473     0.150
     3.950    71.172     0.150
     3.950   120.273     0.150
     3.950    61.172     0.150
     3.950    62.672     0.150
     3.950    71.375     0.150
     3.950   105.672     0.150
     3.950   122.773     0.150
     4.043    72.375     0.150
     4.043   106.574     0.150
     4.043   126.375     0.150
     4.383    67.973     0.150
     4.383    78.672     0.150
     4.383   136.672     0.150
     4.383    68.074     0.150
     4.383    78.773     0.150
     4.383   115.172     0.150
     4.383   136.973     0.150
     4.407    66.773     0.150
     4.407    78.574     0.150
     4.407   117.074     0.150
     4.407   135.574     0.150
     4.407    66.375     0.150
     4.407    78.375     0.150
     4.407   116.973     0.150
     4.407   135.172     0.150
     4.866    74.973     0.150
     4.866   150.473     0.150
     4.866    76.375     0.150
     4.866    87.375     0.150
     5.221    79.473     0.150
     5.221   135.773     0.150
     5.221    92.172     0.150
     5.221   136.375     0.150
     5.221   160.773     0.150
     5.294    81.672     0.150
     5.294    95.473     0.150
     5.294   140.773     0.150
     5.294   161.273     0.150
     5.294    81.473     0.150
     5.294    95.773     0.150
     5.294   142.672     0.150
     5.294   165.773     0.150
     5.460    80.973     0.150
     5.460    95.672     0.150
     5.460   167.574     0.150
     5.460    96.773     0.150
     5.460   141.672     0.150
     5.578    85.074     0.150
     5.578   174.672     0.150
     5.690    85.875     0.150
     5.690   151.375     0.150
     5.690   179.375     0.150
     6.647   118.273     0.150
     6.647   118.773     0.150
     6.647   205.875     0.150
     6.878   100.875     0.150
     6.878   213.473     0.150
     8.700   268.672     0.150
    14.018   199.793     0.150
    17.971   250.516     0.150
    18.482   257.375     0.150
    18.568   257.410     0.150
    22.636   302.301     0.150
    24.899   325.016     0.150
    76.358   709.574     0.150
    79.824   729.074     0.150
     0.187     3.875     0.150
     0.187     6.773     0.150
     0.600    11.672     0.150
     0.600    19.977     0.150
     0.950    16.977     0.150
     0.950    29.273     0.150
     1.146    21.672     0.150
     1.146    22.477     0.150
     1.146    37.172     0.150
     1.146    39.773     0.150
     1.426    25.477     0.150
     1.426    26.672     0.150
     1.426    44.875     0.150
     1.726    32.570     0.150
     1.977    34.172     0.150
     1.977    35.977     0.150
     1.977    62.273     0.150
     2.491    41.570     0.150
     2.491    44.172     0.150
     2.491    76.875     0.150
     3.364    59.570     0.150
     3.364   102.672     0.150
     4.399    66.477     0.150
     4.399    78.773     0.150
     4.399   116.875     0.150
     4.399   135.977     0.150
     0.211     3.838     0.150
     0.211     6.838     0.150
     0.576    11.438     0.150
     0.576    19.638     0.150
     0.576    18.738     0.150
     0.976    17.138     0.150
     1.127    21.138     0.150
     1.127    22.438     0.150
     1.127    37.138     0.150
     1.401    25.338     0.150
     1.401    26.738     0.150
     1.401    44.338     0.150
     1.709    31.938     0.150
     1.709    55.238     0.150
     1.964    34.138     0.150
     1.964    35.838     0.150
     1.964    62.338     0.150
     2.203    36.938     0.150
     2.203    39.238     0.150
     2.203    68.238     0.150
     2.497    44.838     0.150
     2.497    78.238     0.150
     2.497    41.838     0.150
     2.497    77.338     0.150
     2.663    43.338     0.150
     2.663    48.638     0.150
     2.663    82.338     0.150
     2.663    47.138     0.150
     2.663    76.438     0.150
     2.770    50.338     0.150
     2.770    85.538     0.150
     2.770    85.338     0.150
     2.992    81.338     0.150
     2.992    90.138     0.150
     2.992    48.338     0.150
     2.992    53.438     0.150
     2.992    82.038     0.150
     2.992    93.038     0.150
     3.362   105.438     0.150
     3.390   104.938     0.150
     3.382    52.338     0.150
     3.382    59.938     0.150
     3.382   104.538     0.150
     3.382    53.538     0.150
     3.382    59.638     0.150
     3.382   104.738     0.150
     3.941    70.338     0.150
     3.941    62.438     0.150
     3.941   105.638     0.150
     3.941   120.738     0.150
     4.048   125.238     0.150
     4.376    79.838     0.150
     4.376   138.238     0.150
     4.416    66.338     0.150
     4.416    78.338     0.150
     4.416    80.138     0.150
     4.416   116.838     0.150
     4.416   135.738     0.150
     4.856    76.238     0.150
     4.856    87.738     0.150
     4.856   150.538     0.150
     5.228    94.038     0.150
     5.228   136.138     0.150
     5.228   161.738     0.150
     5.284    81.338     0.150
     5.284    96.238     0.150
     5.284   162.638     0.150
     5.284    81.538     0.150
     5.284   142.638     0.150
     5.284   162.438     0.150
     5.463   166.538     0.150
     5.579   100.538     0.150
     5.579   174.538     0.150
     6.654   205.538     0.150
     6.888   102.038     0.150
     6.888   178.838     0.150
     6.888   213.738     0.150
     0.191     4.217     0.150
     0.191     7.317     0.150
     0.595    11.817     0.150
     0.595    20.017     0.150
     0.595    11.717     0.150
     0.595    20.117     0.150
     0.965    17.417     0.150
     0.965    30.217     0.150
     1.129    21.617     0.150
     1.129    22.817     0.150
     1.129    37.117     0.150
     1.410    25.617     0.150
     1.410    27.017     0.150
     1.709    32.017     0.150
     1.709    55.317     0.150
     1.960    34.417     0.150
     1.960    36.217     0.150
     1.960    62.817     0.150
     2.201    37.117     0.150
     2.201    39.117     0.150
     2.201    67.817     0.150
     2.201    37.217     0.150
     2.201    68.417     0.150
     2.506    42.117     0.150
     2.506    45.317     0.150
     2.506    72.017     0.150
     2.506    76.917     0.150
     2.506    43.317     0.150
     2.506    44.817     0.150
     2.669    43.917     0.150
     2.669    47.817     0.150
     2.669    82.817     0.150
     2.669    82.717     0.150
     2.779    44.617     0.150
     2.779    49.517     0.150
     2.779    86.517     0.150
     2.779    86.317     0.150
     2.995    92.117     0.150
     2.995    49.217     0.150
     2.995    54.117     0.150
     2.995    93.317     0.150
     3.371    62.317     0.150
     3.371   105.817     0.150
     3.371    61.117     0.150
     3.371   104.717     0.150
     3.365    61.617     0.150
     3.365   105.717     0.150
     3.365    61.417     0.150
     3.389    53.617     0.150
     3.389    61.017     0.150
     3.389   104.517     0.150
     3.389    61.117     0.150
     3.389   104.917     0.150
     3.951    62.717     0.150
     3.951    70.817     0.150
     3.951   120.617     0.150
     3.951    71.117     0.150
     3.951   121.517     0.150
     4.047    71.917     0.150
     4.047   125.717     0.150
     4.396    66.717     0.150
     4.396    78.617     0.150
     4.396    80.117     0.150
     4.396   116.517     0.150
     4.396   135.717     0.150
     4.379    68.117     0.150
     4.379    78.717     0.150
     4.379   137.617     0.150
     4.379    79.417     0.150
     4.867    75.917     0.150
     4.867    89.417     0.150
     4.867   150.617     0.150
     4.867    76.317     0.150
     4.867    84.717     0.150
     4.867    86.717     0.150
     4.867   132.717     0.150
     4.867   150.817     0.150
     5.225    79.817     0.150
     5.225    94.017     0.150
     5.225   162.117     0.150
     5.298    81.517     0.150
     5.298    96.117     0.150
     5.298   140.917     0.150
     5.298   163.617     0.150
     5.298   142.417     0.150
     5.466    83.517     0.150
     5.466    97.517     0.150
     5.466    83.017     0.150
     5.466    97.017     0.150
     5.466   167.617     0.150
     5.569    85.017     0.150
     5.569    85.117     0.150
     5.569   174.917     0.150
     5.681    85.817     0.150
     5.681   102.417     0.150
     5.681   177.317     0.150
     6.649   122.717     0.150
     6.649    98.317     0.150
     6.649   119.417     0.150
     6.649   206.317     0.150
     6.877   101.317     0.150
     6.877   178.417     0.150
     6.877   101.017     0.150
     6.877   213.117     0.150
     8.703   270.117     0.150
    14.024   199.517     0.150
    17.973   250.418     0.150
    18.488   257.717     0.150
    18.573   257.706     0.150
    22.643   301.017     0.150
    22.695   302.517     0.150
    24.901   325.817     0.150
    24.901   323.861     0.150
    28.356   721.717     0.150
    30.554   376.117     0.150
    30.554   438.917     0.150
    42.260   474.417     0.150
    76.347   709.317     0.150
    79.812   729.417     0.150
    89.289   776.879     0.150
     0.199     3.992     0.150
     0.199     7.289     0.150
     0.588    11.391     0.150
     0.588    19.789     0.150
     0.588    11.289     0.150
     0.588    19.891     0.150
     0.960    17.090     0.150
     0.960    29.691     0.150
     0.960    17.191     0.150
     0.960    30.191     0.150
     1.417    25.492     0.150
     1.417    26.789     0.150
     1.722    32.090     0.150
     1.722    55.590     0.150
     1.974    34.391     0.150
     1.974    35.992     0.150
     1.974    62.992     0.150
     2.190    37.090     0.150
     2.190    38.789     0.150
     2.190    67.891     0.150
     2.190    38.492     0.150
     2.190    67.992     0.150
     2.490    41.090     0.150
     2.490    44.691     0.150
     2.490    70.891     0.150
     2.490    76.789     0.150
     2.490    73.090     0.150
     2.678    43.891     0.150
     2.678    48.992     0.150
     2.678    82.691     0.150
     2.678    43.691     0.150
     2.678    47.191     0.150
     2.678    77.691     0.150
     2.785    49.691     0.150
     2.785    85.891     0.150
     2.785    85.789     0.150
     2.981    46.691     0.150
     2.981    52.691     0.150
     2.981    83.090     0.150
     2.981    91.891     0.150
     2.981    47.992     0.150
     2.981    52.992     0.150
     2.981    92.590     0.150
     3.351   105.289     0.150
     3.377    53.691     0.150
     3.377    60.590     0.150
     3.377   104.391     0.150
     3.377   104.789     0.150
     3.397    53.789     0.150
     3.397    61.191     0.150
     3.397   104.891     0.150
     3.397    60.090     0.150
     3.397    95.891     0.150
     3.397   104.492     0.150
     3.397    52.891     0.150
     3.397    60.191     0.150
     3.397   104.391     0.150
     3.957    62.391     0.150
     3.957    70.289     0.150
     3.957   119.992     0.150
     3.957    62.691     0.150
     3.957    69.891     0.150
     3.957   120.789     0.150
     4.035    72.992     0.150
     4.035    74.492     0.150
     4.035   126.090     0.150
     4.390    67.789     0.150
     4.390    78.590     0.150
     4.390   137.289     0.150
     4.409    66.492     0.150
     4.409    78.492     0.150
     4.409   116.992     0.150
     4.409   134.992     0.150
     4.409    66.391     0.150
     4.409    78.391     0.150
     4.409   116.289     0.150
     4.409   134.590     0.150
     4.872    84.590     0.150
     4.872   147.992     0.150
     4.872    76.492     0.150
     4.872    84.891     0.150
     4.872   132.191     0.150
     4.872   147.891     0.150
     5.214    92.191     0.150
     5.214    93.289     0.150
     5.214   138.289     0.150
     5.214   161.492     0.150
     5.300    81.191     0.150
     5.300    95.789     0.150
     5.300    95.391     0.150
     5.300   142.492     0.150
     5.300   163.891     0.150
     5.452    95.992     0.150
     5.452   140.992     0.150
     6.640   205.891     0.150
     6.873   177.789     0.150
     6.873   213.391     0.150
     0.195     4.221     0.150
     0.195     7.121     0.150
     0.591    11.721     0.150
     0.591    19.721     0.150
     0.591    19.921     0.150
     0.964    17.121     0.150
     0.964    30.221     0.150
     1.133    21.121     0.150
     1.133    22.621     0.150
     1.133    36.721     0.150
     1.411    25.721     0.150
     1.411    44.721     0.150
     1.411    25.621     0.150
     1.574    29.021     0.150
     1.574    50.221     0.150
     1.574    52.121     0.150
     1.714    31.321     0.150
     1.714    54.821     0.150
     1.965    34.621     0.150
     1.965    36.021     0.150
     1.965    62.621     0.150
     2.197    37.121     0.150
     2.197    39.121     0.150
     2.197    68.421     0.150
     2.500    45.121     0.150
     2.500    74.821     0.150
     2.671    43.821     0.150
     2.671    47.921     0.150
     2.671    76.721     0.150
     2.671    83.021     0.150
     2.780    50.921     0.150
     2.780    85.821     0.150
     2.780    86.321     0.150
     2.990    46.921     0.150
     2.990    47.921     0.150
     2.990    53.121     0.150
     2.990    92.721     0.150
     2.990    52.921     0.150
     2.990    83.021     0.150
     2.990    91.721     0.150
     3.360    60.421     0.150
     3.360   104.921     0.150
     3.375   105.121     0.150
     3.375   104.021     0.150
     3.391    52.321     0.150
     3.391    60.321     0.150
     3.391    94.621     0.150
     3.391   104.621     0.150
     3.391    60.521     0.150
     3.391   104.121     0.150
     3.952    62.021     0.150
     3.952    71.721     0.150
     3.952   120.421     0.150
     3.952    62.521     0.150
     3.952    70.421     0.150
     3.952    72.321     0.150
     3.952   121.721     0.150
     4.043   125.821     0.150
     4.383    79.021     0.150
     4.383   117.721     0.150
     4.383   137.021     0.150
     4.402    78.221     0.150
     4.402   115.621     0.150
     4.402   135.221     0.150
     4.868    76.221     0.150
     4.868    85.121     0.150
     4.868   149.921     0.150
     5.221    92.421     0.150
     5.221   159.921     0.150
     5.221    93.721     0.150
     5.221   163.121     0.150
     5.297    82.121     0.150
     5.297   141.121     0.150
     5.297    94.521     0.150
     5.297   163.321     0.150
     5.461   168.521     0.150
     5.575    84.021     0.150
     5.575   100.621     0.150
     5.575   174.121     0.150
     6.646   205.321     0.150
     6.876   177.921     0.150
     0.193     3.879     0.150
     0.193     6.879     0.150
     0.594    11.479     0.150
     0.594    19.578     0.150
     0.960    17.180     0.150
     0.960    29.779     0.150
     1.136    21.180     0.150
     1.136    36.479     0.150
     1.136    39.479     0.150
     1.415    25.279     0.150
     1.415    26.578     0.150
     1.415    44.979     0.150
     1.415    47.180     0.150
     1.576    28.680     0.150
     1.576    49.779     0.150
     1.576    51.879     0.150
     1.717    55.279     0.150
     1.717    53.879     0.150
     1.968    34.479     0.150
     1.968    35.879     0.150
     1.968    62.379     0.150
     2.194    36.979     0.150
     2.194    39.078     0.150
     2.194    64.078     0.150
     2.194    67.680     0.150
     2.194    38.779     0.150
     2.194    68.078     0.150
     2.498    41.078     0.150
     2.498    43.879     0.150
     2.498    75.078     0.150
     2.675    43.479     0.150
     2.675    48.279     0.150
     2.675    83.680     0.150
     2.784    85.979     0.150
     2.784    86.578     0.150
     2.987    52.979     0.150
     2.987    93.078     0.150
     3.357   105.078     0.150
     3.372   104.180     0.150
     3.395    53.578     0.150
     3.395    60.078     0.150
     3.395    61.379     0.150
     3.395   104.279     0.150
     3.690    58.578     0.150
     3.690    66.479     0.150
     3.690   113.979     0.150
     4.401    66.578     0.150
     4.401    78.680     0.150
     4.401   116.379     0.150
     4.401   135.779     0.150
     4.386    78.479     0.150
     4.386   136.479     0.150
     4.872    75.078     0.150
     4.872    87.379     0.150
     4.872   150.680     0.150
     5.218    94.180     0.150
     5.218   161.578     0.150
     5.301    81.279     0.150
     5.301    95.680     0.150
     5.301   141.779     0.150
     5.301   157.180     0.150
     5.301   163.680     0.150
     5.458    98.078     0.150
     5.458   167.779     0.150
     5.577   100.779     0.150
     5.577   174.078     0.150
     6.643   204.279     0.150
     6.872    99.578     0.150
     6.872   122.779     0.150
     6.872   211.279     0.150
     0.146     3.453     0.150
     0.146     6.055     0.150
     0.651    12.652     0.150
     0.651    21.555     0.150
     0.968    17.355     0.150
     0.968    30.152     0.150
     0.968    30.355     0.150
     0.968    31.555     0.150
     1.099    20.453     0.150
     1.099    34.754     0.150
     1.405    25.152     0.150
     1.405    44.754     0.150
     1.405    44.453     0.150
     1.511    27.355     0.150
     1.511    47.855     0.150
     1.511    49.152     0.150
     1.674    30.953     0.150
     1.674    53.152     0.150
     1.674    30.652     0.150
     1.674    53.254     0.150
     1.912    33.254     0.150
     1.912    34.652     0.150
     1.912    60.652     0.150
     2.234    37.254     0.150
     2.234    39.355     0.150
     2.234    64.855     0.150
     2.234    68.754     0.150
     2.234    38.953     0.150
     2.234    69.355     0.150
     2.567    44.754     0.150
     2.567    45.855     0.150
     2.567    78.254     0.150
     2.567    80.055     0.150
     2.653    42.652     0.150
     2.653    47.055     0.150
     2.653    75.152     0.150
     2.653    80.652     0.150
     2.653    82.453     0.150
     2.776    85.355     0.150
     2.776    86.652     0.150
     3.042    47.355     0.150
     3.042    53.355     0.150
     3.042    83.652     0.150
     3.042    92.355     0.150
     3.042    48.555     0.150
     3.042    53.754     0.150
     3.042    94.152     0.150
     3.325    89.555     0.150
     3.325   101.652     0.150
     3.325   100.953     0.150
     3.410    62.652     0.150
     3.410   107.754     0.150
     3.410   105.855     0.150
     3.379    53.055     0.150
     3.379    60.152     0.150
     3.379   104.355     0.150
     3.379   103.254     0.150
     3.720    57.355     0.150
     3.720    66.055     0.150
     3.720   101.152     0.150
     3.720   114.152     0.150
     3.720    57.555     0.150
     3.720    65.453     0.150
     3.720   101.254     0.150
     3.720   114.555     0.150
     3.952    71.355     0.150
     3.952   120.152     0.150
     3.952    71.152     0.150
     3.952   122.953     0.150
     4.079   126.254     0.150
     4.327    64.953     0.150
     4.327    77.152     0.150
     4.327   114.355     0.150
     4.327   132.152     0.150
     4.327    64.754     0.150
     4.327    76.855     0.150
     4.327   113.254     0.150
     4.327   132.453     0.150
     4.353    78.652     0.150
     4.353   135.453     0.150
     4.870    88.754     0.150
     4.870    76.754     0.150
     4.870    86.152     0.150
     4.870   130.754     0.150
     4.870   150.055     0.150
     5.251    92.254     0.150
     5.251    93.254     0.150
     5.251   162.355     0.150
     5.315    81.254     0.150
     5.315   141.055     0.150
     5.315    81.453     0.150
     5.315   163.855     0.150
     5.511   140.254     0.150
     5.511   169.055     0.150
     6.671   121.355     0.150
     6.671   205.453     0.150
     6.870   100.254     0.150
     6.870   122.055     0.150
     6.870   177.555     0.150
     6.870    99.152     0.150
     6.870   211.855     0.150
     0.277     5.383     0.150
     0.277     9.383     0.150
     0.532    10.682     0.150
     0.532    17.982     0.150
     0.532    17.783     0.150
     1.026    19.682     0.150
     1.026    34.283     0.150
     1.078    19.482     0.150
     1.078    33.283     0.150
     1.078    19.283     0.150
     1.078    33.182     0.150
     1.298    23.582     0.150
     1.298    41.283     0.150
     1.298    41.182     0.150
     1.498    27.582     0.150
     1.498    48.182     0.150
     1.611    29.883     0.150
     1.611    51.182     0.150
     1.611    30.482     0.150
     1.611    51.783     0.150
     1.875    32.982     0.150
     1.875    34.182     0.150
     1.875    59.783     0.150
     2.305    38.482     0.150
     2.305    40.883     0.150
     2.305    71.482     0.150
     2.573    42.582     0.150
     2.573    45.682     0.150
     2.573    72.283     0.150
     2.573    79.482     0.150
     2.573    45.783     0.150
     2.573    70.783     0.150
     2.559    42.283     0.150
     2.559    44.582     0.150
     2.559    46.582     0.150
     2.559    73.783     0.150
     2.559    79.682     0.150
     2.559    42.182     0.150
     2.559    45.982     0.150
     2.559    72.982     0.150
     2.559    78.482     0.150
     2.667    47.682     0.150
     2.667    82.182     0.150
     2.667    47.182     0.150
     2.667    81.582     0.150
     3.085    49.582     0.150
     3.085    54.582     0.150
     3.085    95.582     0.150
     3.085    83.582     0.150
     3.085    94.682     0.150
     3.277    52.383     0.150
     3.277    59.982     0.150
     3.277    89.682     0.150
     3.277   101.283     0.150
     3.277   102.482     0.150
     3.277    52.783     0.150
     3.277   100.082     0.150
     3.454    60.982     0.150
     3.454   107.182     0.150
     3.454    62.783     0.150
     3.454   106.682     0.150
     3.456    62.383     0.150
     3.456   108.283     0.150
     3.456    59.982     0.150
     3.456   107.883     0.150
     3.805    65.582     0.150
     3.805   116.082     0.150
     3.839    60.883     0.150
     3.839    69.582     0.150
     3.839   118.182     0.150
     3.839    68.383     0.150
     4.150    63.783     0.150
     4.150    75.182     0.150
     4.150   129.182     0.150
     4.273    66.682     0.150
     4.273    77.082     0.150
     4.273   113.982     0.150
     4.273   134.082     0.150
     4.273    76.082     0.150
     4.273   133.783     0.150
     4.424    66.582     0.150
     4.424    79.783     0.150
     4.424   117.283     0.150
     4.424   135.682     0.150
     4.424    78.482     0.150
     4.424   117.182     0.150
     4.424   135.982     0.150
     4.755    74.783     0.150
     4.755   126.283     0.150
     4.755   144.383     0.150
     4.755   147.582     0.150
     4.755   126.682     0.150
     5.190    79.883     0.150
     5.190   136.682     0.150
     5.190   160.682     0.150
     5.190    94.082     0.150
     5.190   157.982     0.150
     5.331    94.283     0.150
     5.511    83.383     0.150
     5.511    98.883     0.150
     5.511   171.383     0.150
     5.558    82.783     0.150
     5.558    99.883     0.150
     5.558   144.082     0.150
     5.558   171.982     0.150
     5.558    82.082     0.150
     5.558    99.682     0.150
     6.758   120.883     0.150
     6.758   209.883     0.150
     6.988   102.582     0.150
     6.988   215.783     0.150
     6.988   103.182     0.150
     6.988   180.783     0.150
     0.632    12.625     0.150
     0.632    21.430     0.150
     0.632    12.727     0.150
     0.632    21.531     0.150
     0.972    17.625     0.150
     0.972    30.727     0.150
     0.972    30.531     0.150
     1.103    20.930     0.150
     1.103    36.625     0.150
     1.103    40.625     0.150
     1.401    25.531     0.150
     1.401    44.531     0.150
     1.401    44.328     0.150
     1.524    28.125     0.150
     1.524    48.531     0.150
     1.524    50.227     0.150
     1.680    31.227     0.150
     1.680    53.727     0.150
     2.229    37.625     0.150
     2.229    39.531     0.150
     2.229    68.828     0.150
     2.229    69.227     0.150
     2.552    42.430     0.150
     2.552    45.727     0.150
     2.552    75.531     0.150
     2.552    78.828     0.150
     2.552    46.727     0.150
     2.552    73.031     0.150
     2.552    78.727     0.150
     2.653    43.430     0.150
     2.653    47.328     0.150
     2.653    74.930     0.150
     2.653    82.125     0.150
     2.653    43.328     0.150
     2.653    47.727     0.150
     2.772    47.430     0.150
     2.772    48.625     0.150
     2.772    85.625     0.150
     2.772    45.625     0.150
     2.772    50.531     0.150
     2.772    85.930     0.150
     3.032    48.930     0.150
     3.032    54.031     0.150
     3.032    94.227     0.150
     3.032    48.625     0.150
     3.032    53.430     0.150
     3.032    83.031     0.150
     3.342    52.430     0.150
     3.342    59.125     0.150
     3.342   103.727     0.150
     3.342    51.930     0.150
     3.342    61.125     0.150
     3.342   103.828     0.150
     3.400    54.531     0.150
     3.400    61.930     0.150
     3.400   106.727     0.150
     3.400    60.227     0.150
     3.400   106.828     0.150
     3.377    53.227     0.150
     3.377    60.430     0.150
     3.377   103.930     0.150
     3.377    52.594     0.150
     3.377    59.898     0.150
     3.377   103.023     0.150
     3.377    53.328     0.150
     3.718    58.227     0.150
     3.718    66.625     0.150
     3.718   114.625     0.150
     3.718    57.531     0.150
     3.718    66.727     0.150
     3.718   115.531     0.150
     4.074    74.125     0.150
     4.074   110.828     0.150
     4.074   127.531     0.150
     3.946    61.125     0.150
     3.946    70.828     0.150
     3.946   121.328     0.150
     3.946   120.531     0.150
     4.348    65.531     0.150
     4.348    77.727     0.150
     4.348   115.625     0.150
     4.348   133.227     0.150
     4.348    78.125     0.150
     4.348   116.531     0.150
     4.348   133.430     0.150
     4.356    67.625     0.150
     4.356    79.828     0.150
     4.356    80.031     0.150
     4.356   135.328     0.150
     4.864    75.328     0.150
     4.864    85.328     0.150
     4.864   149.930     0.150
     4.864    76.227     0.150
     4.864    88.328     0.150
     5.305    81.227     0.150
     5.305   142.625     0.150
     5.305    81.125     0.150
     5.305    96.531     0.150
     5.502    82.031     0.150
     5.502    98.328     0.150
     5.502   169.828     0.150
     5.502    81.227     0.150
     5.502    97.227     0.150
     5.502   142.828     0.150
     5.521    83.328     0.150
     5.521    85.625     0.150
     5.521   100.227     0.150
     5.521   173.031     0.150
     5.521    83.430     0.150
     5.521    83.727     0.150
     5.622    85.031     0.150
     5.635    85.109     0.150
     5.635   152.352     0.150
     5.635   176.727     0.150
     6.669    98.125     0.150
     6.669   207.227     0.150
     6.669    98.727     0.150
     6.877   100.125     0.150
     6.877   212.328     0.150
     6.877   101.125     0.150
     6.877   123.031     0.150
     6.877   177.727     0.150
     7.520   233.328     0.150
     8.130   116.125     0.150
     9.446   137.328     0.150
    10.049   310.328     0.150
    12.634   181.930     0.150
    12.634   322.930     0.150
    14.046   198.930     0.150
    14.046   198.305     0.150
    14.046   433.859     0.150
    14.254   442.664     0.150
    14.254   197.930     0.150
    14.266   202.625     0.150
    14.285   202.031     0.150
    14.880   208.227     0.150
    15.113   219.828     0.150
    16.311   231.328     0.150
    16.311   409.625     0.150
    16.659   238.625     0.150
    16.659   741.625     0.150
    17.394   240.625     0.150
    17.394   434.328     0.150
    17.522   464.625     0.150
    17.905   561.977     0.150
    17.976   249.828     0.150
    17.976   249.305     0.150
    17.976   250.227     0.150
    18.503   253.930     0.150
    18.588   255.781     0.150
    19.261   264.125     0.150
    20.464   276.531     0.150
    20.464   276.727     0.150
    20.780   281.766     0.150
    20.804   282.125     0.150
    20.804   282.078     0.150
    21.467   289.430     0.150
    22.520   300.828     0.150
    22.641   585.828     0.150
    22.667   300.281     0.150
    22.720   302.430     0.150
    22.720   300.719     0.150
    24.085   315.727     0.150
    24.617   319.500     0.150
    24.617   770.258     0.150
    24.903   323.125     0.150
    26.050   615.828     0.150
    26.848   342.625     0.150
    26.987   344.930     0.150
    26.987   343.125     0.150
    27.179   344.430     0.150
    27.179   621.625     0.150
    28.389   354.930     0.150
    28.389   643.930     0.150
    28.389   721.031     0.150
    28.389   354.039     0.150
    28.474   359.227     0.150
    30.162   369.805     0.150
    30.585   374.125     0.150
    30.585   433.531     0.150
    34.224   407.328     0.150
    34.224   735.828     0.150
    35.561   418.117     0.150
    36.590   423.625     0.150
    37.067   429.828     0.150
    39.234   446.906     0.150
    40.385   458.625     0.150
    40.385   554.430     0.150
    40.385   584.430     0.150
    42.304   471.875     0.150
    43.035   482.227     0.150
    43.048   478.750     0.150
    43.470   482.930     0.150
    43.439   485.031     0.150
    45.537   498.125     0.150
    45.537     3.805     0.150
    45.537   597.125     0.150
    46.295   505.430     0.150
    46.495   506.320     0.150
    46.507   506.828     0.150
    48.488   522.531     0.150
    48.647   524.656     0.150
    48.564   523.031     0.150
    48.564   521.586     0.150
    48.873   526.648     0.150
    48.873   524.984     0.150
    50.526   538.727     0.150
    50.462   537.906     0.150
    50.460   538.625     0.150
    50.778   541.430     0.150
    50.893   542.828     0.150
    50.938   541.227     0.150
    51.138   542.125     0.150
    51.356   543.727     0.150
    51.440   547.430     0.150
    52.220   552.430     0.150
    53.154   558.727     0.150
    53.154     3.703     0.150
    53.154   558.031     0.150
    53.153   558.930     0.150
    54.079   564.828     0.150
    55.292   574.930     0.150
    55.429   573.688     0.150
    55.412   574.602     0.150
    58.028   595.125     0.150
    59.673   602.117     0.150
    61.130   614.227     0.150
    61.135   614.227     0.150
    61.627   617.625     0.150
    61.899   619.031     0.150
    61.923   619.125     0.150
    62.371   621.930     0.150
    62.635   624.727     0.150
    62.629   624.531     0.150
    63.193   627.930     0.150
    63.428   630.227     0.150
    63.440   629.930     0.150
    63.712   631.430     0.150
    65.996   646.531     0.150
    70.575   676.125     0.150
    70.625   675.422     0.150
    72.162   683.430     0.150
    73.652   694.305     0.150
    73.899   695.320     0.150
    74.659   699.984     0.150
    76.296   708.586     0.150
    76.417   710.734     0.150
    76.722   711.711     0.150
    77.437   716.039     0.150
    77.628   716.820     0.150
    77.808   717.680     0.150
    78.867   722.258     0.150
    79.021   724.227     0.150
    79.362   726.781     0.150
    79.609   727.734     0.150
    79.762   728.180     0.150
    79.771   728.516     0.150
    81.327   735.125     0.150
    89.319   776.680     0.150
    89.319   776.312     0.150
    93.086   793.602     0.150
   147.302  1182.398     0.150
   148.047  1184.031     0.150
     0.627    12.305     0.150
     0.627    21.008     0.150
     0.627    21.305     0.150
     0.979    17.508     0.150
     0.979    30.406     0.150
     0.979    30.508     0.150
     1.096    20.406     0.150
     1.096    36.707     0.150
     1.394    25.207     0.150
     1.394    26.406     0.150
     1.394    44.707     0.150
     1.394    44.008     0.150
     1.520    27.605     0.150
     1.520    48.305     0.150
     1.520    49.906     0.150
     1.673    30.406     0.150
     1.673    53.805     0.150
     1.673    31.305     0.150
     1.917    34.707     0.150
     1.917    60.805     0.150
     2.235    37.305     0.150
     2.235    39.305     0.150
     2.235    69.707     0.150
     2.235    39.406     0.150
     2.235    64.105     0.150
     2.235    68.605     0.150
     2.645    43.207     0.150
     2.645    47.406     0.150
     2.645    74.406     0.150
     2.645    81.707     0.150
     2.645    81.406     0.150
     2.764    48.605     0.150
     2.764    85.207     0.150
     2.764    44.406     0.150
     2.764    49.508     0.150
     3.038    48.605     0.150
     3.038    53.906     0.150
     3.038    86.406     0.150
     3.038    94.105     0.150
     3.038    53.707     0.150
     3.038    82.805     0.150
     3.348    51.906     0.150
     3.348    59.605     0.150
     3.348    93.805     0.150
     3.348   103.605     0.150
     3.348    51.406     0.150
     3.348    61.008     0.150
     3.406    54.406     0.150
     3.406    60.207     0.150
     3.406    62.105     0.150
     3.406   106.805     0.150
     3.406    54.305     0.150
     3.406    59.906     0.150
     3.406   106.906     0.150
     3.369    53.105     0.150
     3.369    59.508     0.150
     3.369   104.008     0.150
     3.369    52.605     0.150
     3.369    60.453     0.150
     3.369    52.906     0.150
     3.369    60.805     0.150
     3.369   103.605     0.150
     3.369    60.906     0.150
     3.725    57.906     0.150
     3.725    64.906     0.150
     3.725    66.906     0.150
     3.725   104.406     0.150
     3.725   115.906     0.150
     3.939    63.105     0.150
     3.939    70.105     0.150
     3.939   121.605     0.150
     3.939    70.207     0.150
     4.351    65.207     0.150
     4.351    78.406     0.150
     4.351   114.605     0.150
     4.351   135.508     0.150
     4.351    76.508     0.150
     4.351   114.906     0.150
     4.351   132.707     0.150
     4.349    67.406     0.150
     4.349    77.707     0.150
     4.349    80.105     0.150
     4.349   135.605     0.150
     4.349    77.508     0.150
     4.349   135.008     0.150
     4.856    75.707     0.150
     4.856    86.508     0.150
     4.856   131.105     0.150
     4.856   150.008     0.150
     4.856    88.207     0.150
     4.856   149.105     0.150
     5.255    78.508     0.150
     5.255    93.406     0.150
     5.255   162.906     0.150
     5.255    93.008     0.150
     5.298    81.406     0.150
     5.298    92.508     0.150
     5.298    81.105     0.150
     5.298    96.305     0.150
     5.508    81.707     0.150
     5.508    97.508     0.150
     5.508   169.305     0.150
     5.508    81.305     0.150
     5.508    97.406     0.150
     5.518   172.508     0.150
     5.518    82.867     0.150
     5.631    84.848     0.150
     5.631   101.883     0.150
     5.631   151.906     0.150
     5.631   177.148     0.150
     6.677    97.906     0.150
     6.677   119.605     0.150
     6.677   206.906     0.150
     6.677   121.605     0.150
     6.884   100.406     0.150
     6.884   213.707     0.150
     6.884   100.508     0.150
     6.884   121.805     0.150
     7.527   110.008     0.150
     7.527   234.605     0.150
     8.136   115.305     0.150
     9.325   135.906     0.150
    12.633   181.406     0.150
    14.040   198.777     0.150
    14.261   198.586     0.150
    14.261   442.020     0.150
    14.261   355.105     0.150
    14.267   201.707     0.150
    14.286   202.008     0.150
    14.873   207.605     0.150
    14.873   371.305     0.150
    15.108   219.707     0.150
    16.651   237.906     0.150
    17.401   242.305     0.150
    17.401   436.805     0.150
    17.911   250.398     0.150
    17.911   562.160     0.150
    17.968   248.551     0.150
    17.968   564.332     0.150
    17.968   250.707     0.150
    18.496   255.305     0.150
    18.496   581.566     0.150
    18.581   255.309     0.150
    18.581   581.566     0.150
    20.808   282.805     0.150
    20.808   665.918     0.150
    20.808   282.848     0.150
    22.638   533.406     0.150
    22.638   548.906     0.150
    22.638   553.906     0.150
    22.638   587.406     0.150
    22.661   301.605     0.150
    22.713   301.305     0.150
    22.713   300.805     0.150
    24.077   315.906     0.150
    24.624   320.590     0.150
    24.896   324.195     0.150
    24.896   325.008     0.150
    24.896   322.734     0.150
    25.303   328.305     0.150
    26.979   344.707     0.150
    28.383   354.625     0.150
    28.383   355.305     0.150
    28.383   643.406     0.150
    28.470   356.406     0.150
    28.470   731.707     0.150
    30.155   370.035     0.150
    30.764   375.359     0.150
    35.557   419.738     0.150
    38.911   445.254     0.150
    39.232   448.840     0.150
    42.301   473.457     0.150
    46.490   507.559     0.150
    48.494   523.105     0.150
    48.561   523.484     0.150
    48.879   526.105     0.150
    50.932   541.996     0.150
    50.932   544.707     0.150
    58.873   599.320     0.150
    59.678   602.652     0.150
    70.622   675.816     0.150
    72.734   689.008     0.150
    72.974   690.637     0.150
    73.270   692.035     0.150
    74.024   696.375     0.150
    74.609   699.656     0.150
    75.627   705.848     0.150
    76.042   708.465     0.150
    76.045   708.125     0.150
    76.297   708.605     0.150
    76.391   710.406     0.150
    79.368   726.277     0.150
    79.762   728.105     0.150
    80.081   730.707     0.150
    89.313   776.457     0.150
    93.091   795.215     0.150
   145.871  1177.379     0.150
   147.296  1182.105     0.150
     0.306     5.984     0.150
     0.306    10.383     0.150
     0.502    10.383     0.150
     0.502    17.383     0.150
     0.576    11.188     0.150
     0.576    19.688     0.150
     1.018    19.586     0.150
     1.018    20.484     0.150
     1.018    34.281     0.150
     1.099    19.781     0.150
     1.099    34.688     0.150
     1.278    23.188     0.150
     1.278    42.484     0.150
     1.604    51.883     0.150
     1.627    28.883     0.150
     1.875    32.688     0.150
     1.875    34.188     0.150
     1.875    59.688     0.150
     2.152    35.484     0.150
     2.152    38.586     0.150
     2.152    68.086     0.150
     2.315    38.281     0.150
     2.315    40.688     0.150
     2.315    71.984     0.150
     2.568    45.188     0.150
     2.568    78.188     0.150
     2.543    41.688     0.150
     2.543    45.484     0.150
     2.543    79.086     0.150
     2.646    81.484     0.150
     3.089    53.984     0.150
     3.089    95.383     0.150
     3.484   107.781     0.150
     3.817    66.688     0.150
     3.817   116.984     0.150
     3.817   116.188     0.150
     4.160   130.086     0.150
     4.262    76.484     0.150
     4.262   134.383     0.150
     4.451    66.086     0.150
     4.451    78.688     0.150
     4.451   116.781     0.150
     4.451   137.383     0.150
     4.733    74.281     0.150
     4.733    82.281     0.150
     4.733   145.586     0.150
     5.164    79.586     0.150
     5.164    92.484     0.150
     5.164   159.688     0.150
     5.164    79.688     0.150
     5.344    81.484     0.150
     5.344    95.688     0.150
     5.344   165.781     0.150
     5.562   171.688     0.150
     6.772   211.188     0.150
     7.011   102.484     0.150
     7.011   124.484     0.150
     7.011   217.188     0.150
     7.011   124.281     0.150
     0.276     5.844     0.150
     0.276     9.344     0.150
     0.772    14.742     0.150
     0.772    24.844     0.150
     0.834    15.641     0.150
     0.834    26.641     0.150
     0.860    17.141     0.150
     0.860    29.047     0.150
     0.892    17.141     0.150
     0.892    29.242     0.150
     1.423    26.742     0.150
     1.423    46.547     0.150
     1.588    28.344     0.150
     1.588    49.445     0.150
     1.795    33.242     0.150
     1.795    57.242     0.150
     1.810    33.141     0.150
     1.810    33.844     0.150
     1.810    56.445     0.150
     1.810    57.945     0.150
     2.674    44.242     0.150
     2.674    47.641     0.150
     2.674    76.547     0.150
     2.674    81.844     0.150
     2.692    45.047     0.150
     2.692    47.641     0.150
     2.692    76.047     0.150
     2.692    82.445     0.150
     3.338    53.742     0.150
     3.338    59.641     0.150
     3.338    91.742     0.150
     3.338   102.742     0.150
     0.176     3.582     0.150
     0.176     6.180     0.150
     0.569    10.781     0.150
     0.569    18.781     0.150
     0.629    12.180     0.150
     0.629    21.082     0.150
     0.629    12.281     0.150
     0.998    17.781     0.150
     0.998    31.082     0.150
     0.998    30.980     0.150
     1.074    20.281     0.150
     1.074    34.980     0.150
     1.375    25.383     0.150
     1.375    44.082     0.150
     1.497    27.383     0.150
     1.497    47.980     0.150
     1.651    30.883     0.150
     1.690    30.781     0.150
     1.690    54.383     0.150
     1.894    34.180     0.150
     1.894    60.180     0.150
     2.258    37.680     0.150
     2.258    39.680     0.150
     2.258    70.082     0.150
     2.258    37.781     0.150
     2.258    69.480     0.150
     2.231    40.281     0.150
     2.231    69.980     0.150
     2.578    42.980     0.150
     2.578    46.180     0.150
     2.578    75.883     0.150
     2.578    79.980     0.150
     2.578    46.480     0.150
     2.578    76.082     0.150
     2.625    42.781     0.150
     2.625    45.980     0.150
     2.625    73.883     0.150
     2.625    80.082     0.150
     2.746    49.082     0.150
     2.746    85.082     0.150
     2.746    50.281     0.150
     2.746    84.480     0.150
     2.879    46.281     0.150
     2.879    50.680     0.150
     2.879    80.281     0.150
     2.879    88.383     0.150
     3.061    54.180     0.150
     3.061    84.480     0.150
     3.061    94.281     0.150
     3.061    47.680     0.150
     3.061    53.781     0.150
     3.061    93.680     0.150
     3.352    58.480     0.150
     3.352   102.281     0.150
     3.352    61.480     0.150
     3.352   102.980     0.150
     3.429    59.180     0.150
     3.429   106.883     0.150
     3.429    59.883     0.150
     3.429   107.582     0.150
     3.350    51.582     0.150
     3.350    59.883     0.150
     3.350   103.383     0.150
     3.350    52.680     0.150
     3.350    60.781     0.150
     3.350   102.383     0.150
     3.746    58.180     0.150
     3.746    67.180     0.150
     3.746   115.582     0.150
     3.746    65.082     0.150
     3.922    62.082     0.150
     3.922    69.383     0.150
     3.922   121.281     0.150
     3.922    70.480     0.150
     3.922   118.980     0.150
     4.103    73.582     0.150
     4.103   128.281     0.150
     4.341    65.781     0.150
     4.341    77.383     0.150
     4.341   114.980     0.150
     4.341   132.781     0.150
     4.327    67.480     0.150
     4.327    78.480     0.150
     4.327   135.281     0.150
     4.839    75.480     0.150
     4.839    85.082     0.150
     4.839   148.680     0.150
     5.277    94.480     0.150
     5.277   164.180     0.150
     5.285    81.383     0.150
     5.285    93.480     0.150
     5.285   140.582     0.150
     5.285    81.180     0.150
     5.285    95.883     0.150
     5.496    98.980     0.150
     5.496   171.281     0.150
     5.531    99.383     0.150
     5.531   170.180     0.150
     6.698   121.180     0.150
     6.698   208.180     0.150
     6.901   101.082     0.150
     6.901   123.680     0.150
     6.901   175.480     0.150
     6.901   212.781     0.150
     6.901   100.480     0.150
     6.901   122.180     0.150
     6.901   177.680     0.150
     0.286     5.768     0.150
     0.286    10.066     0.150
     0.515    10.268     0.150
     0.515    17.467     0.150
     0.729    13.967     0.150
     0.729    24.566     0.150
     0.973    17.268     0.150
     0.973    30.066     0.150
     1.423    25.367     0.150
     1.423    26.566     0.150
     1.423    45.768     0.150
     2.155    35.867     0.150
     2.155    37.867     0.150
     2.155    66.367     0.150
     2.412    42.867     0.150
     2.412    73.867     0.150
     2.924    51.566     0.150
     2.924    90.867     0.150
     3.664    56.268     0.150
     3.664    65.066     0.150
     3.664    67.166     0.150
     3.664   112.268     0.150
     4.506    66.967     0.150
     4.506    80.367     0.150
     4.506   117.268     0.150
     4.506   137.867     0.150
     0.171     4.109     0.150
     0.171     6.906     0.150
     0.597    11.406     0.150
     0.597    19.809     0.150
     0.622    12.406     0.150
     0.622    21.207     0.150
     0.979    17.609     0.150
     0.979    30.906     0.150
     0.979    17.508     0.150
     0.979    30.508     0.150
     1.098    20.809     0.150
     1.098    35.906     0.150
     1.194    22.109     0.150
     1.194    38.109     0.150
     1.394    25.207     0.150
     1.394    44.508     0.150
     1.525    27.406     0.150
     1.525    27.906     0.150
     1.525    48.406     0.150
     1.676    31.207     0.150
     1.676    29.707     0.150
     1.921    33.109     0.150
     1.921    34.809     0.150
     1.921    61.008     0.150
     2.232    36.809     0.150
     2.232    39.207     0.150
     2.232    69.207     0.150
     2.232    64.406     0.150
     2.253    36.906     0.150
     2.253    40.309     0.150
     2.253    64.906     0.150
     2.253    70.406     0.150
     2.550    42.008     0.150
     2.550    45.609     0.150
     2.550    71.109     0.150
     2.550    78.406     0.150
     2.646    42.609     0.150
     2.646    46.809     0.150
     2.646    74.406     0.150
     2.646    81.508     0.150
     2.764    49.809     0.150
     2.764    85.109     0.150
     2.764    84.207     0.150
     2.900    45.906     0.150
     2.900    51.707     0.150
     2.900    80.109     0.150
     2.900    89.207     0.150
     3.034    48.109     0.150
     3.034    53.109     0.150
     3.034    82.309     0.150
     3.034    93.109     0.150
     3.034    47.309     0.150
     3.034    53.406     0.150
     3.034    93.008     0.150
     3.352    59.906     0.150
     3.352   104.008     0.150
     3.352    57.609     0.150
     3.352    90.309     0.150
     3.352   103.109     0.150
     3.402    63.309     0.150
     3.402   106.609     0.150
     3.370    52.309     0.150
     3.370    60.707     0.150
     3.370    91.309     0.150
     3.370   104.207     0.150
     3.723    57.406     0.150
     3.723    66.707     0.150
     3.723    98.609     0.150
     3.723   114.707     0.150
     3.939    67.609     0.150
     4.357    64.809     0.150
     4.357    78.109     0.150
     4.357   113.508     0.150
     4.357   134.609     0.150
     4.351    67.406     0.150
     4.351    79.109     0.150
     4.351   115.508     0.150
     4.351   135.809     0.150
     4.856    73.809     0.150
     4.856    84.309     0.150
     4.856    85.406     0.150
     4.856   131.406     0.150
     4.856   150.406     0.150
     5.253    77.906     0.150
     5.253    93.707     0.150
     5.253   161.508     0.150
     5.253    95.109     0.150
     5.296    79.406     0.150
     5.296    95.207     0.150
     5.296   138.109     0.150
     5.296   164.906     0.150
     5.504    98.906     0.150
     5.504   169.809     0.150
     6.675    98.309     0.150
     6.675   170.508     0.150
     6.675   205.406     0.150
     6.885   100.008     0.150
     6.885   122.508     0.150
     6.885   174.207     0.150
     6.885   210.809     0.150
     6.885   122.008     0.150
     6.885   176.508     0.150
     0.344     6.859     0.150
     0.344    11.961     0.150
     0.592    11.859     0.150
     0.576    10.359     0.150
     0.576    11.461     0.150
     0.576    18.961     0.150
     0.667    12.961     0.150
     0.667    22.656     0.150
     0.958    17.258     0.150
     0.958    31.156     0.150
     0.958    17.461     0.150
     0.958    31.258     0.150
     1.212    22.359     0.150
     1.212    38.961     0.150
     1.255    23.258     0.150
     1.255    40.859     0.150
     1.419    25.156     0.150
     1.419    45.156     0.150
     1.545    49.555     0.150
     1.808    32.555     0.150
     1.808    57.656     0.150
     2.201    35.961     0.150
     2.201    39.359     0.150
     2.201    64.555     0.150
     2.201    68.656     0.150
     2.329    72.359     0.150
     2.329    40.961     0.150
     2.329    72.055     0.150
     2.455    43.156     0.150
     2.455    75.961     0.150
     2.666    42.758     0.150
     2.666    46.656     0.150
     2.666    82.555     0.150
     2.885    46.258     0.150
     2.885    52.859     0.150
     2.885    81.758     0.150
     2.885    89.859     0.150
     2.927    47.461     0.150
     2.927    51.555     0.150
     2.927    90.859     0.150
     2.927    53.461     0.150
     2.927    90.258     0.150
     3.434    53.461     0.150
     3.434    60.156     0.150
     3.434   105.758     0.150
     3.508    62.961     0.150
     3.508   109.461     0.150
     3.508    63.258     0.150
     3.508   107.055     0.150
     3.641    56.859     0.150
     3.641    64.961     0.150
     3.641   113.461     0.150
     3.808    67.461     0.150
     3.808   118.258     0.150
     3.911    70.461     0.150
     3.911   123.461     0.150
     4.428    67.555     0.150
     4.428    75.656     0.150
     4.428   122.359     0.150
     4.428   136.359     0.150
     4.512   139.359     0.150
     4.904    75.156     0.150
     4.904   132.055     0.150
     4.904   151.758     0.150
     5.237   163.055     0.150
     5.693   102.656     0.150
     5.693   175.461     0.150
     5.908   180.961     0.150
     6.859   118.055     0.150
     6.859   176.555     0.150
     6.859   195.555     0.150
     6.859   212.961     0.150
     7.118   219.656     0.150
     7.310   128.961     0.150
     7.310   225.359     0.150
     7.310   106.461     0.150
     7.310   187.656     0.150
     0.173     5.906     0.150
     0.173     9.906     0.150
     0.699    13.207     0.150
     0.699    23.305     0.150
     0.764    13.707     0.150
     0.764    24.305     0.150
     0.764    13.406     0.150
     0.960    18.305     0.150
     0.960    31.207     0.150
     0.960    18.406     0.150
     1.285    24.008     0.150
     1.551    27.707     0.150
     1.659    27.508     0.150
     1.659    29.105     0.150
     1.776    31.707     0.150
     1.776    55.805     0.150
     1.826    32.305     0.150
     1.898    33.906     0.150
     1.898    59.805     0.150
     1.999    32.605     0.150
     1.999    35.105     0.150
     1.999    62.805     0.150
     2.122    34.207     0.150
     2.122    37.008     0.150
     2.122    61.508     0.150
     2.122    65.805     0.150
     2.122    34.406     0.150
     2.122    36.906     0.150
     2.122    61.906     0.150
     2.122    64.406     0.150
     2.469    39.008     0.150
     2.469    43.805     0.150
     2.469    66.805     0.150
     2.469    77.906     0.150
     2.617    41.707     0.150
     2.617    45.406     0.150
     2.617    79.805     0.150
     2.867    44.008     0.150
     2.867    50.305     0.150
     2.867    77.707     0.150
     2.867    87.805     0.150
     3.009    54.508     0.150
     3.009    91.805     0.150
     2.998    51.805     0.150
     2.998    92.105     0.150
     2.998    51.605     0.150
     2.998    91.805     0.150
     3.027    93.305     0.150
     3.027    54.305     0.150
     3.127    47.805     0.150
     3.127    54.805     0.150
     3.127    82.508     0.150
     3.127    96.605     0.150
     3.353   104.707     0.150
     3.560    54.406     0.150
     3.560    62.605     0.150
     3.560   109.406     0.150
     3.607    54.305     0.150
     3.607    63.008     0.150
     3.607    95.805     0.150
     3.607   110.508     0.150
     4.209    62.707     0.150
     4.209    73.605     0.150
     4.209   109.508     0.150
     4.209   128.305     0.150
     4.209    75.207     0.150
     5.130    77.207     0.150
     5.130    91.207     0.150
     5.130   135.707     0.150
     6.608    95.805     0.150
     6.608   116.805     0.150
     6.608   170.305     0.150
     0.321     6.191     0.150
     0.321    10.791     0.150
     0.602    11.592     0.150
     0.602    19.791     0.150
     0.620    12.391     0.150
     0.620    20.691     0.150
     0.620    12.492     0.150
     0.632    12.592     0.150
     0.632    21.391     0.150
     0.933    17.291     0.150
     0.933    30.791     0.150
     1.219    22.592     0.150
     1.219    39.791     0.150
     1.448    25.592     0.150
     1.448    45.391     0.150
     1.448    25.791     0.150
     1.509    27.592     0.150
     1.509    48.092     0.150
     1.777    32.191     0.150
     2.171    36.391     0.150
     2.171    38.592     0.150
     2.171    62.992     0.150
     2.171    67.492     0.150
     2.303    71.791     0.150
     2.303    40.592     0.150
     2.303    70.592     0.150
     2.425    39.592     0.150
     2.425    43.291     0.150
     2.425    74.992     0.150
     2.701    43.092     0.150
     2.701    47.191     0.150
     2.701    82.891     0.150
     2.701    74.592     0.150
     2.701    80.391     0.150
     2.921    46.291     0.150
     2.921    50.791     0.150
     2.921    89.291     0.150
     2.921    46.691     0.150
     2.921    81.492     0.150
     2.898    45.391     0.150
     2.898    51.291     0.150
     2.898    89.492     0.150
     2.898    46.391     0.150
     2.898    51.492     0.150
     2.898    89.191     0.150
     3.470    53.891     0.150
     3.470    60.992     0.150
     3.470   106.391     0.150
     3.470    53.092     0.150
     3.470    60.791     0.150
     3.470    93.791     0.150
     3.470   105.291     0.150
     3.483    62.492     0.150
     3.483   107.891     0.150
     3.648   113.992     0.150
     3.878    69.092     0.150
     3.878   121.191     0.150
     4.198    73.691     0.150
     4.198   129.891     0.150
     4.395    66.291     0.150
     4.395    77.492     0.150
     4.395   116.291     0.150
     4.395   136.492     0.150
     4.404    69.992     0.150
     4.404    77.291     0.150
     4.404   136.391     0.150
     4.546    69.691     0.150
     4.546   140.391     0.150
     4.886    74.791     0.150
     4.886   126.092     0.150
     4.886   150.391     0.150
     4.886    76.191     0.150
     4.886    89.092     0.150
     5.203    78.492     0.150
     5.203    93.291     0.150
     5.203   161.891     0.150
     5.944    88.992     0.150
     5.944   184.691     0.150
     7.334   227.291     0.150
     7.334   129.191     0.150
     7.334   187.291     0.150
     0.426     9.121     0.150
     0.426    14.922     0.150
     0.426     9.223     0.150
     0.435     8.023     0.150
     0.435    14.523     0.150
     0.545    10.223     0.150
     0.545    18.223     0.150
     0.918    17.824     0.150
     0.918    31.023     0.150
     1.149    20.324     0.150
     1.149    21.723     0.150
     1.149    35.723     0.150
     1.149    36.824     0.150
     1.233    22.121     0.150
     1.233    38.523     0.150
     1.233    21.922     0.150
     1.456    26.422     0.150
     1.456    45.922     0.150
     1.507    27.824     0.150
     1.507    48.324     0.150
     1.801    31.121     0.150
     1.801    32.723     0.150
     1.801    56.824     0.150
     2.031    34.023     0.150
     2.031    36.223     0.150
     2.031    63.223     0.150
     2.429    39.523     0.150
     2.429    43.422     0.150
     2.429    68.121     0.150
     2.429    74.223     0.150
     2.421    39.621     0.150
     2.421    43.121     0.150
     2.421    69.121     0.150
     2.421    74.621     0.150
     2.515    41.621     0.150
     2.515    75.824     0.150
     2.630    43.023     0.150
     2.630    47.422     0.150
     2.630    75.324     0.150
     2.630    82.121     0.150
     2.669    43.324     0.150
     2.669    48.922     0.150
     2.669    73.523     0.150
     2.669    82.621     0.150
     3.181    50.121     0.150
     3.181    55.922     0.150
     3.181    85.523     0.150
     3.181    97.723     0.150
     3.181    56.523     0.150
     3.181    87.422     0.150
     3.181    96.723     0.150
     3.132    49.523     0.150
     3.132    55.824     0.150
     3.132    85.922     0.150
     3.132    96.621     0.150
     3.132    55.223     0.150
     3.132    87.922     0.150
     3.132    95.324     0.150
     3.556    54.523     0.150
     3.556    64.422     0.150
     3.556    95.422     0.150
     3.556   109.621     0.150
     3.556    62.922     0.150
     3.556   110.223     0.150
     3.603    56.121     0.150
     3.603    64.922     0.150
     3.603    98.523     0.150
     3.603   110.621     0.150
     3.684    58.023     0.150
     3.684    66.422     0.150
     3.684    99.121     0.150
     3.684   113.023     0.150
     3.684    57.922     0.150
     3.684    65.324     0.150
     3.939    60.824     0.150
     3.939    70.223     0.150
     3.939   104.922     0.150
     3.939   121.422     0.150
     4.148    64.324     0.150
     4.148    72.023     0.150
     4.148    75.922     0.150
     4.148   129.824     0.150
     4.148    64.121     0.150
     4.148    72.324     0.150
     4.272    76.621     0.150
     4.272   113.324     0.150
     4.272   132.223     0.150
     4.515    66.824     0.150
     4.515    81.621     0.150
     4.515   118.523     0.150
     4.515   139.422     0.150
     4.515    67.422     0.150
     4.599    71.824     0.150
     4.599    80.621     0.150
     4.599   125.824     0.150
     4.599   140.723     0.150
     4.599    72.324     0.150
     4.599    81.023     0.150
     4.599   139.922     0.150
     5.029    76.621     0.150
     5.029    90.523     0.150
     5.029   132.523     0.150
     5.029   155.723     0.150
     5.029    76.723     0.150
     5.029    90.922     0.150
     5.462    81.422     0.150
     5.462    98.223     0.150
     5.462   168.922     0.150
     5.462    82.523     0.150
     5.462    96.223     0.150
     5.480    83.523     0.150
     5.480    99.121     0.150
     5.480   169.523     0.150
     5.560    83.242     0.150
     5.573    83.383     0.150
     5.573    83.379     0.150
     5.573   174.773     0.150
     5.655    83.922     0.150
     5.655   144.922     0.150
     5.655   174.621     0.150
     5.655    82.422     0.150
     5.655    99.223     0.150
     6.893   101.723     0.150
     6.893   213.723     0.150
     7.034   101.824     0.150
     7.146   103.621     0.150
     7.146   220.523     0.150
     7.146   126.922     0.150
     7.146   183.922     0.150
     7.279   108.223     0.150
     7.279   226.023     0.150
     8.382   120.422     0.150
     8.382   118.922     0.150
     9.058   131.121     0.150
     9.952   307.223     0.150
    13.315   187.824     0.150
    13.775   195.824     0.150
    13.776   195.293     0.150
    13.776   195.824     0.150
    13.776   426.332     0.150
    13.776   195.594     0.150
    14.447   212.324     0.150
    14.614   203.422     0.150
    14.614   368.723     0.150
    14.991   218.223     0.150
    16.411   235.723     0.150
    16.565   416.723     0.150
    16.565   429.723     0.150
    16.565   958.523     0.150
    17.464   246.223     0.150
    17.704   247.363     0.150
    17.704   246.344     0.150
    17.704   246.340     0.150
    17.704   557.074     0.150
    17.704   247.164     0.150
    17.704   247.621     0.150
    17.710   247.074     0.150
    18.164   569.500     0.150
    18.227   251.652     0.150
    18.227   252.324     0.150
    18.312   252.344     0.150
    18.673   581.051     0.150
    20.552   276.520     0.150
    20.552   275.922     0.150
    22.400   297.848     0.150
    22.452   299.543     0.150
    22.452   298.824     0.150
    26.712   340.371     0.150
    26.712   340.691     0.150
    28.423   358.023     0.150
    29.891   368.133     0.150
    39.450   446.422     0.150
    46.256   506.586     0.150
    46.256   506.582     0.150
    48.642   523.324     0.150
    48.801   524.883     0.150
    48.818   524.773     0.150
    49.026   525.773     0.150
    49.025   526.043     0.150
    49.025   526.723     0.150
    49.025   525.922     0.150
    49.239   527.473     0.150
    50.378   535.852     0.150
    50.697   538.023     0.150
    50.852   539.523     0.150
    51.900   547.203     0.150
    55.137   571.812     0.150
    55.208   572.594     0.150
    59.775   602.641     0.150
    71.869   682.551     0.150
    73.825   693.574     0.150
    74.032   694.652     0.150
    74.805   699.281     0.150
    75.754   705.512     0.150
    75.768   704.664     0.150
    76.171   707.512     0.150
    77.758   716.191     0.150
    77.781   715.902     0.150
    77.939   716.633     0.150
    78.995   723.074     0.150
    79.498   725.094     0.150
    79.883   727.742     0.150
    80.235   730.480     0.150
    83.064   744.562     0.150
    89.060   774.203     0.150
     0.144     3.411     0.150
     0.144     6.311     0.150
     0.582    11.011     0.150
     0.582    19.511     0.150
     0.656    13.011     0.150
     0.656    22.011     0.150
     0.656    13.211     0.150
     0.656    21.911     0.150
     0.969    17.611     0.150
     0.969    30.811     0.150
     0.969    17.111     0.150
     0.969    30.211     0.150
     1.180    37.911     0.150
     1.405    25.011     0.150
     1.405    27.311     0.150
     1.405    45.311     0.150
     1.405    47.211     0.150
     1.405    25.411     0.150
     1.507    27.511     0.150
     1.507    48.111     0.150
     1.672    54.011     0.150
     1.714    31.711     0.150
     1.909    34.511     0.150
     1.909    60.811     0.150
     2.236    37.511     0.150
     2.236    39.411     0.150
     2.236    69.811     0.150
     2.257    40.811     0.150
     2.257    70.111     0.150
     2.571    42.711     0.150
     2.571    46.011     0.150
     2.571    79.211     0.150
     2.652    46.511     0.150
     2.652    81.511     0.150
     2.776    82.311     0.150
     2.776    85.611     0.150
     2.906    46.711     0.150
     2.906    52.011     0.150
     2.906    89.711     0.150
     3.321   101.411     0.150
     3.321   104.811     0.150
     3.378    53.311     0.150
     3.378    60.011     0.150
     3.378   104.911     0.150
     3.952    59.811     0.150
     3.952    69.311     0.150
     3.952    71.911     0.150
     3.952   122.111     0.150
     3.952    68.311     0.150
     3.952   121.211     0.150
     4.082   126.511     0.150
     4.322    65.411     0.150
     4.322    77.111     0.150
     4.322   114.811     0.150
     4.322   133.311     0.150
     4.351   136.011     0.150
     4.870    88.111     0.150
     4.870   133.811     0.150
     4.870   145.211     0.150
     4.870   150.411     0.150
     5.253    93.311     0.150
     5.253   161.811     0.150
     5.316    81.611     0.150
     5.316   138.311     0.150
     5.316   163.511     0.150
     5.316    96.511     0.150
     5.316   141.211     0.150
     5.316   163.011     0.150
     5.501    99.511     0.150
     5.501   171.111     0.150
     6.673   195.511     0.150
     6.673   206.511     0.150
     6.870   212.711     0.150
     6.870    99.411     0.150
     6.870   122.011     0.150
     6.870   177.811     0.150
     7.303   126.311     0.150
     7.303   227.511     0.150
     7.568   233.311     0.150
     0.160     3.539     0.150
     0.160     6.039     0.150
     0.572    10.938     0.150
     0.572    19.242     0.150
     0.644    13.242     0.150
     0.644    22.039     0.150
     0.644    21.938     0.150
     0.985    18.039     0.150
     0.985    31.039     0.150
     1.170    21.641     0.150
     1.170    23.039     0.150
     1.170    38.141     0.150
     1.389    25.039     0.150
     1.389    44.938     0.150
     1.389    46.438     0.150
     1.498    27.539     0.150
     1.498    48.344     0.150
     1.658    29.742     0.150
     1.658    51.539     0.150
     1.699    32.039     0.150
     1.898    34.438     0.150
     1.898    60.844     0.150
     2.250    37.539     0.150
     2.250    69.844     0.150
     2.578    41.742     0.150
     2.578    45.344     0.150
     2.578    71.344     0.150
     2.578    78.539     0.150
     2.578    80.938     0.150
     2.578    42.938     0.150
     2.578    46.039     0.150
     2.578    71.641     0.150
     2.759    85.141     0.150
     2.759    49.039     0.150
     2.759    84.539     0.150
     2.890    46.742     0.150
     2.890    51.242     0.150
     2.890    89.344     0.150
     3.057    48.844     0.150
     3.057    53.641     0.150
     3.057    94.344     0.150
     3.057    48.141     0.150
     3.057    83.242     0.150
     3.057    91.344     0.150
     3.336    50.344     0.150
     3.336    58.438     0.150
     3.336   102.438     0.150
     3.336    61.539     0.150
     3.336   103.938     0.150
     3.362   103.742     0.150
     3.362    60.539     0.150
     3.362   104.242     0.150
     3.737    58.344     0.150
     3.737    65.438     0.150
     3.737   115.742     0.150
     3.935    59.438     0.150
     3.935    70.344     0.150
     3.935   121.438     0.150
     3.935    70.539     0.150
     3.935   120.039     0.150
     4.095    71.539     0.150
     4.095    73.438     0.150
     4.095   108.742     0.150
     4.095   127.742     0.150
     4.329    65.344     0.150
     4.329    76.844     0.150
     4.329    79.141     0.150
     4.329   115.141     0.150
     4.329   132.844     0.150
     4.329    65.539     0.150
     4.329    77.438     0.150
     4.329   115.641     0.150
     4.337    77.938     0.150
     4.337   112.438     0.150
     4.337   136.141     0.150
     4.853    85.141     0.150
     4.853   148.844     0.150
     4.853    85.344     0.150
     4.853   148.539     0.150
     5.300    80.742     0.150
     5.300   140.938     0.150
     5.300   154.844     0.150
     5.300   162.938     0.150
     5.526    98.844     0.150
     5.526   100.039     0.150
     5.526   170.039     0.150
     5.495    97.844     0.150
     5.495   159.141     0.150
     5.495   170.141     0.150
     6.886   123.039     0.150
     6.886   212.539     0.150
     6.886   178.742     0.150
     7.286   224.438     0.150
     8.797   270.742     0.150
     0.156     3.699     0.150
     0.156     6.199     0.150
     0.575    11.100     0.150
     0.575    19.299     0.150
     0.646    13.400     0.150
     0.646    22.400     0.150
     0.646    22.100     0.150
     0.980    17.600     0.150
     0.980    31.100     0.150
     0.980    17.900     0.150
     1.173    21.699     0.150
     1.173    37.900     0.150
     1.173    40.799     0.150
     1.393    25.100     0.150
     1.393    45.199     0.150
     1.501    27.699     0.150
     1.501    47.900     0.150
     1.501    50.299     0.150
     1.662    30.100     0.150
     1.662    53.500     0.150
     1.662    31.100     0.150
     1.703    32.100     0.150
     1.703    54.799     0.150
     1.901    34.699     0.150
     1.901    61.000     0.150
     2.246    37.699     0.150
     2.246    39.699     0.150
     2.246    70.000     0.150
     2.246    37.299     0.150
     2.246    40.400     0.150
     2.246    70.699     0.150
     2.575    42.400     0.150
     2.575    46.100     0.150
     2.575    79.900     0.150
     2.575    42.699     0.150
     2.575    73.799     0.150
     2.764    50.900     0.150
     2.764    75.900     0.150
     2.764    85.600     0.150
     2.764    48.699     0.150
     2.764    85.299     0.150
     2.895    46.500     0.150
     2.895    51.600     0.150
     2.895    81.299     0.150
     2.895    89.900     0.150
     3.053    48.900     0.150
     3.053    54.100     0.150
     3.053    94.699     0.150
     3.053    53.799     0.150
     3.053    84.500     0.150
     3.053    93.500     0.150
     3.333    60.000     0.150
     3.333    90.699     0.150
     3.333   103.900     0.150
     3.333    59.500     0.150
     3.333   103.600     0.150
     3.421    61.400     0.150
     3.421    90.799     0.150
     3.421   107.900     0.150
     3.421    60.400     0.150
     3.421   107.299     0.150
     3.366    52.600     0.150
     3.366    60.699     0.150
     3.366   104.699     0.150
     3.366    53.000     0.150
     3.366   104.299     0.150
     3.732    58.199     0.150
     3.732    66.500     0.150
     3.732   115.699     0.150
     3.940    60.699     0.150
     3.940    71.000     0.150
     3.940   122.400     0.150
     3.940    62.100     0.150
     3.940    70.699     0.150
     4.091    73.400     0.150
     4.091    75.799     0.150
     4.091   109.500     0.150
     4.091   127.699     0.150
     4.091    75.100     0.150
     4.091   127.100     0.150
     4.328    65.400     0.150
     4.328    78.199     0.150
     4.328   114.100     0.150
     4.328   133.199     0.150
     4.328    77.100     0.150
     4.328   115.299     0.150
     4.341    66.900     0.150
     4.341    78.400     0.150
     4.341    67.100     0.150
     4.341    78.000     0.150
     4.341   135.500     0.150
     4.858    75.699     0.150
     4.858    85.500     0.150
     4.858   132.699     0.150
     4.858   150.500     0.150
     4.858    88.500     0.150
     4.858   148.699     0.150
     5.304    80.699     0.150
     5.304   141.000     0.150
     5.304   163.000     0.150
     5.304    81.199     0.150
     5.304    94.900     0.150
     5.304   139.199     0.150
     5.522    82.000     0.150
     5.522    98.500     0.150
     5.522   159.799     0.150
     5.522   170.400     0.150
     5.522    80.600     0.150
     5.522    97.500     0.150
     5.497   172.000     0.150
     5.497    85.199     0.150
     5.612    85.340     0.150
     5.612   101.719     0.150
     5.612   176.627     0.150
     6.683    98.299     0.150
     6.683   119.400     0.150
     6.683   205.900     0.150
     6.683   122.000     0.150
     6.882   100.900     0.150
     6.882   212.699     0.150
     6.882   101.100     0.150
     6.882   122.600     0.150
     6.882   178.199     0.150
     7.291   130.799     0.150
     7.556   113.799     0.150
     8.119   253.799     0.150
     8.802   158.100     0.150
     8.802   270.900     0.150
     9.330   134.000     0.150
    13.588   194.500     0.150
    17.972   250.701     0.150
    20.487   276.809     0.150
    20.487   497.559     0.150
    20.487   636.859     0.150
    20.487   278.100     0.150
    24.632   320.799     0.150
    24.899   324.400     0.150
    30.604   374.199     0.150
    48.893   526.049     0.150
    59.696   603.295     0.150
    79.739   728.861     0.150
     0.156     3.242     0.150
     0.156     5.344     0.150
     0.567    10.648     0.150
     0.567    18.945     0.150
     0.651    12.945     0.150
     0.651    21.648     0.150
     0.651    21.547     0.150
     0.985    17.445     0.150
     0.985    18.242     0.150
     0.985    19.945     0.150
     0.985    30.844     0.150
     0.985    30.742     0.150
     1.164    21.344     0.150
     1.164    23.148     0.150
     1.164    36.945     0.150
     1.164    40.047     0.150
     1.389    24.648     0.150
     1.389    26.047     0.150
     1.389    43.242     0.150
     1.389    44.945     0.150
     1.492    27.344     0.150
     1.492    47.547     0.150
     1.492    49.344     0.150
     1.655    30.547     0.150
     1.655    52.945     0.150
     1.655    30.742     0.150
     1.655    53.047     0.150
     1.697    30.547     0.150
     1.697    31.945     0.150
     1.893    33.547     0.150
     1.893    60.344     0.150
     2.253    37.445     0.150
     2.253    39.445     0.150
     2.253    69.648     0.150
     2.253    39.344     0.150
     2.253    63.445     0.150
     2.241    37.148     0.150
     2.241    40.547     0.150
     2.241    69.742     0.150
     2.585    42.344     0.150
     2.585    45.844     0.150
     2.585    71.445     0.150
     2.585    77.742     0.150
     2.585    80.547     0.150
     2.585    74.648     0.150
     2.585    80.742     0.150
     2.635    42.742     0.150
     2.635    46.844     0.150
     2.635    73.945     0.150
     2.635    80.945     0.150
     2.760    49.945     0.150
     2.760    76.148     0.150
     2.760    84.547     0.150
     3.062    48.648     0.150
     3.062    53.844     0.150
     3.062    54.648     0.150
     3.062    95.148     0.150
     3.062    85.344     0.150
     3.062    95.344     0.150
     3.329    52.344     0.150
     3.329    57.242     0.150
     3.329   101.742     0.150
     3.329    51.242     0.150
     3.329    61.648     0.150
     3.739    58.148     0.150
     3.739    65.047     0.150
     3.739    97.648     0.150
     3.739   115.047     0.150
     3.936    61.047     0.150
     3.936    70.242     0.150
     3.936   121.945     0.150
     3.936    61.844     0.150
     3.936    71.242     0.150
     3.936   121.242     0.150
     4.320    65.148     0.150
     4.320    77.547     0.150
     4.320   114.844     0.150
     4.320   132.742     0.150
     4.320    77.742     0.150
     4.320   115.344     0.150
     4.320   132.844     0.150
     4.334    77.344     0.150
     4.334   134.945     0.150
     4.855    75.844     0.150
     4.855    85.648     0.150
     4.855   129.844     0.150
     4.855   150.148     0.150
     4.855    75.242     0.150
     4.855    85.547     0.150
     4.855   130.445     0.150
     4.855   149.945     0.150
     5.303    81.344     0.150
     5.303    95.547     0.150
     5.303   138.445     0.150
     5.530    81.547     0.150
     5.530    97.344     0.150
     5.530   170.547     0.150
     5.530    81.344     0.150
     5.530    97.648     0.150
     6.689   118.945     0.150
     6.689   205.648     0.150
     6.885   212.344     0.150
     6.885   100.742     0.150
     6.885   122.742     0.150
     6.885   176.648     0.150
     0.289     6.445     0.150
     0.289    11.547     0.150
     0.621    11.250     0.150
     0.621    19.750     0.150
     0.621    11.047     0.150
     0.621    19.250     0.150
     0.840    16.250     0.150
     0.840    27.250     0.150
     0.840    27.547     0.150
     1.466    26.344     0.150
     1.466    27.250     0.150
     1.466    46.945     0.150
     1.525    27.547     0.150
     1.525    48.844     0.150
     1.759    30.148     0.150
     1.759    31.148     0.150
     1.759    30.250     0.150
     1.759    31.344     0.150
     1.759    54.047     0.150
     1.871    31.750     0.150
     1.871    32.648     0.150
     1.871    56.945     0.150
     1.871    57.250     0.150
     2.038    37.844     0.150
     2.038    64.344     0.150
     2.290    38.250     0.150
     2.290    40.148     0.150
     2.290    64.445     0.150
     2.290    69.750     0.150
     2.624    41.945     0.150
     2.624    46.250     0.150
     2.624    80.945     0.150
     2.704    47.547     0.150
     2.704    82.844     0.150
     3.017    47.547     0.150
     3.017    53.945     0.150
     3.017    82.344     0.150
     3.017    93.047     0.150
     3.127    96.047     0.150
     3.151    53.148     0.150
     3.151    97.047     0.150
     3.270    50.945     0.150
     3.270    58.148     0.150
     3.270   100.445     0.150
     3.353    52.250     0.150
     3.353    59.047     0.150
     3.353    89.844     0.150
     3.353   102.648     0.150
     3.738    56.750     0.150
     3.738    65.250     0.150
     3.738    98.344     0.150
     3.738   114.148     0.150
     4.297    75.844     0.150
     4.297   130.047     0.150
     4.361    65.344     0.150
     4.361    78.148     0.150
     4.361   115.250     0.150
     4.361   134.344     0.150
     4.720    70.547     0.150
     4.720    85.547     0.150
     4.720   123.445     0.150
     4.720   147.344     0.150
     5.166    92.250     0.150
     5.166   158.547     0.150
     5.212    78.148     0.150
     5.212    93.445     0.150
     5.212   136.047     0.150
     5.212   160.344     0.150
     5.624    84.547     0.150
     5.624   100.844     0.150
     5.624   147.344     0.150
     5.624   173.547     0.150
     5.786   180.547     0.150
     6.304    92.445     0.150
     6.304   194.750     0.150
     6.538   165.945     0.150
     6.538   200.750     0.150
     0.073     3.738     0.150
     0.073     6.539     0.150
     0.671    12.439     0.150
     0.671    21.838     0.150
     0.723    14.338     0.150
     0.723    23.838     0.150
     0.857    15.439     0.150
     0.857    27.238     0.150
     0.857    26.838     0.150
     1.268    23.139     0.150
     1.268    40.139     0.150
     1.517    26.439     0.150
     1.517    47.439     0.150
     1.517    26.738     0.150
     1.999    33.838     0.150
     1.999    62.838     0.150
     2.134    34.838     0.150
     2.134    36.639     0.150
     2.134    65.439     0.150
     2.134    65.139     0.150
     2.368    42.338     0.150
     2.368    73.939     0.150
     2.507    40.139     0.150
     2.507    43.838     0.150
     2.507    75.939     0.150
     2.507    40.338     0.150
     2.507    44.439     0.150
     2.507    70.639     0.150
     2.507    75.838     0.150
     2.763    43.238     0.150
     2.763    48.639     0.150
     2.763    76.139     0.150
     2.763    84.838     0.150
     2.888    87.838     0.150
     2.958    46.039     0.150
     2.958    51.439     0.150
     2.958    90.238     0.150
     2.958    53.639     0.150
     2.958    82.439     0.150
     2.958    89.738     0.150
     3.017    46.838     0.150
     3.017    51.238     0.150
     3.017    53.238     0.150
     3.017    93.039     0.150
     3.017    46.939     0.150
     3.017    53.838     0.150
     3.017    92.139     0.150
     3.241    99.539     0.150
     3.241    49.338     0.150
     3.241    55.338     0.150
     3.241    86.139     0.150
     3.241    97.838     0.150
     3.490    53.639     0.150
     3.490    62.039     0.150
     3.490   107.639     0.150
     3.490    63.738     0.150
     3.490   108.039     0.150
     3.614    55.139     0.150
     3.614    63.639     0.150
     3.614    55.338     0.150
     3.614    64.139     0.150
     3.614   111.238     0.150
     4.063    63.738     0.150
     4.063    71.139     0.150
     4.063   123.639     0.150
     4.298    63.838     0.150
     4.298    76.738     0.150
     4.298   132.338     0.150
     4.458    67.338     0.150
     4.458    79.338     0.150
     4.981    87.539     0.150
     5.146    92.039     0.150
     5.423    95.039     0.150
     5.423    81.639     0.150
     5.423   143.539     0.150
     5.563    82.838     0.150
     0.321     6.430     0.150
     0.321    11.125     0.150
     0.430     7.625     0.150
     0.430     9.125     0.150
     0.430    13.430     0.150
     0.639    12.828     0.150
     0.639    21.523     0.150
     0.780    14.727     0.150
     0.780    26.023     0.150
     1.107    20.125     0.150
     1.107    36.023     0.150
     1.107    38.430     0.150
     1.277    22.430     0.150
     1.277    25.023     0.150
     1.277    39.727     0.150
     1.277    41.430     0.150
     1.358    24.930     0.150
     1.358    44.023     0.150
     1.396    26.125     0.150
     1.396    45.625     0.150
     1.615    28.523     0.150
     1.615    29.125     0.150
     1.615    51.430     0.150
     2.338    38.125     0.150
     2.338    42.328     0.150
     2.338    67.227     0.150
     2.338    73.328     0.150
     2.477    42.523     0.150
     2.477    76.328     0.150
     2.551    40.625     0.150
     2.551    44.227     0.150
     2.551    78.430     0.150
     2.594    41.727     0.150
     2.594    46.227     0.150
     2.594    74.125     0.150
     2.594    81.023     0.150
     2.829    44.828     0.150
     2.829    49.430     0.150
     2.829    78.727     0.150
     2.829    86.727     0.150
     3.069    48.430     0.150
     3.069    54.430     0.150
     3.069    94.727     0.150
     3.344    51.828     0.150
     3.344    58.828     0.150
     3.344   103.430     0.150
     3.494    62.727     0.150
     3.494   108.523     0.150
     3.658    55.227     0.150
     3.658    65.930     0.150
     3.658   113.023     0.150
     3.715    65.930     0.150
     3.715   115.430     0.150
     4.040    61.727     0.150
     4.040    70.023     0.150
     4.040    72.125     0.150
     4.040   124.523     0.150
     4.034    62.227     0.150
     4.034    72.023     0.150
     4.034   126.523     0.150
     4.315    63.930     0.150
     4.315    76.727     0.150
     4.315   133.125     0.150
     4.397    77.930     0.150
     4.397   136.227     0.150
     4.578    71.023     0.150
     4.578    77.828     0.150
     4.578    80.727     0.150
     4.578   140.828     0.150
     5.058    77.430     0.150
     5.058    87.023     0.150
     5.058   134.625     0.150
     5.058   156.023     0.150
     5.264   138.930     0.150
     5.264   164.828     0.150
     5.570    82.125     0.150
     5.570    99.727     0.150
     5.570   172.023     0.150
     5.816    85.828     0.150
     5.816   178.828     0.150
     6.990   125.523     0.150
     6.990   217.023     0.150
     7.009   215.930     0.150
     7.159   104.523     0.150
     7.159   221.625     0.150
     7.318   226.227     0.150
     0.323     6.441     0.150
     0.323     7.340     0.150
     0.323    11.141     0.150
     0.431     7.738     0.150
     0.431    13.641     0.150
     0.431    15.539     0.150
     0.637    12.840     0.150
     0.637    21.840     0.150
     0.780    14.840     0.150
     0.780    26.141     0.150
     0.900    16.641     0.150
     0.900    28.941     0.150
     1.106    20.238     0.150
     1.106    35.641     0.150
     1.106    38.238     0.150
     1.278    22.539     0.150
     1.278    40.141     0.150
     1.358    25.340     0.150
     1.358    43.738     0.150
     1.396    25.641     0.150
     1.396    26.840     0.150
     1.396    45.641     0.150
     1.616    28.641     0.150
     1.616    51.539     0.150
     1.942    32.539     0.150
     1.942    34.941     0.150
     1.942    60.539     0.150
     2.337    38.238     0.150
     2.337    41.039     0.150
     2.337    72.039     0.150
     2.476    44.641     0.150
     2.476    76.539     0.150
     2.551    40.840     0.150
     2.551    44.238     0.150
     2.551    78.840     0.150
     2.593    41.840     0.150
     2.593    46.340     0.150
     2.593    81.840     0.150
     2.827    77.039     0.150
     2.827    86.238     0.150
     3.068    48.238     0.150
     3.068    54.340     0.150
     3.068    94.738     0.150
     3.343    51.340     0.150
     3.343    59.539     0.150
     3.343   104.340     0.150
     3.497    54.039     0.150
     3.497    61.441     0.150
     3.497   107.039     0.150
     3.656    57.039     0.150
     3.656    64.840     0.150
     3.656   111.340     0.150
     3.714    66.840     0.150
     3.714   115.141     0.150
     4.040    62.238     0.150
     4.040    69.641     0.150
     4.040    72.238     0.150
     4.040   124.941     0.150
     4.034    72.039     0.150
     4.034   125.840     0.150
     4.317    64.340     0.150
     4.317    77.039     0.150
     4.317   133.238     0.150
     4.397    80.441     0.150
     4.397   112.238     0.150
     4.397   136.141     0.150
     4.577    69.141     0.150
     4.577    71.941     0.150
     4.577   139.840     0.150
     5.056    77.141     0.150
     5.056   135.738     0.150
     5.056   156.340     0.150
     5.570   100.141     0.150
     5.570   171.738     0.150
     5.815   178.840     0.150
     6.990   215.738     0.150
     7.008   216.340     0.150
     7.161   128.840     0.150
     7.161   221.238     0.150
     7.316   208.441     0.150
     7.316   227.738     0.150
     8.524   262.738     0.150
     0.331     7.723     0.150
     0.331    12.423     0.150
     0.331     7.223     0.150
     0.501     8.923     0.150
     0.501    16.723     0.150
     0.629    11.223     0.150
     0.629    20.423     0.150
     0.955    18.223     0.150
     0.955    31.622     0.150
     1.141    20.022     0.150
     1.141    35.622     0.150
     1.169    21.022     0.150
     1.169    37.322     0.150
     1.264    22.622     0.150
     1.545    28.322     0.150
     1.545    48.723     0.150
     1.545    28.423     0.150
     1.544    26.723     0.150
     1.544    48.522     0.150
     1.856    33.223     0.150
     1.856    58.522     0.150
     2.038    36.122     0.150
     2.038    62.622     0.150
     2.419    38.122     0.150
     2.419    41.923     0.150
     2.419    74.522     0.150
     2.423    39.022     0.150
     2.423    42.822     0.150
     2.423    68.322     0.150
     2.423    74.223     0.150
     2.498    69.622     0.150
     2.498    75.822     0.150
     2.498    44.723     0.150
     2.498    70.822     0.150
     2.498    77.223     0.150
     2.574    41.423     0.150
     2.574    44.822     0.150
     2.574    74.122     0.150
     2.574    78.122     0.150
     2.574    42.223     0.150
     2.574    45.022     0.150
     2.667    43.022     0.150
     2.667    46.223     0.150
     2.667    72.522     0.150
     2.667    83.522     0.150
     3.147    47.822     0.150
     3.147    55.122     0.150
     3.147    97.223     0.150
     3.147    84.822     0.150
     3.147    95.822     0.150
     3.125    49.223     0.150
     3.125    54.022     0.150
     3.125    85.522     0.150
     3.125    95.923     0.150
     3.125    49.923     0.150
     3.125    56.522     0.150
     3.125    96.622     0.150
     3.524   109.423     0.150
     3.680    97.322     0.150
     3.680   114.423     0.150
     3.661    57.022     0.150
     3.661    64.723     0.150
     3.661   100.923     0.150
     3.661   112.322     0.150
     3.661    58.122     0.150
     3.661    63.522     0.150
     3.661   112.423     0.150
     3.938    60.923     0.150
     3.938    68.423     0.150
     3.938   121.423     0.150
     4.163    63.723     0.150
     4.163    74.622     0.150
     4.163   129.223     0.150
     4.258    74.022     0.150
     4.258   132.022     0.150
     4.611    68.122     0.150
     4.611    81.522     0.150
     4.611   119.322     0.150
     4.611   142.322     0.150
     4.611    68.223     0.150
     4.611   118.822     0.150
     4.573    69.423     0.150
     4.573    80.923     0.150
     4.573   125.322     0.150
     4.573   140.223     0.150
     4.573    70.822     0.150
     4.573    82.622     0.150
     4.573   139.923     0.150
     4.983    74.322     0.150
     4.983   130.223     0.150
     4.983   154.322     0.150
     4.983    76.723     0.150
     4.983    90.022     0.150
     4.983   132.423     0.150
     4.983   152.322     0.150
     5.455    96.923     0.150
     5.455   168.522     0.150
     5.455    80.322     0.150
     5.455    95.822     0.150
     5.552    83.223     0.150
     5.552    99.122     0.150
     5.552   171.923     0.150
     5.622   173.822     0.150
     5.622    83.723     0.150
     5.622   173.522     0.150
     5.640    84.441     0.150
     5.640   178.581     0.150
     6.893   122.423     0.150
     6.893   212.622     0.150
     7.007   124.223     0.150
     7.007   217.423     0.150
     7.181   104.223     0.150
     7.181   221.822     0.150
     7.181   104.122     0.150
     7.181   127.223     0.150
     7.181   184.022     0.150
     7.229   205.723     0.150
     7.229   223.522     0.150
     8.509   261.122     0.150
    17.666   245.298     0.150
    18.167   250.923     0.150
    18.253   250.947     0.150
    42.014   471.951     0.150
     0.174     4.711     0.150
     0.174     8.312     0.150
     0.719    12.914     0.150
     0.719    22.617     0.150
     0.813    15.016     0.150
     0.813    26.812     0.150
     0.788    15.711     0.150
     0.788    26.312     0.150
     0.788    26.414     0.150
     1.350    24.312     0.150
     1.350    43.617     0.150
     1.408    25.211     0.150
     1.408    45.414     0.150
     1.654    29.914     0.150
     1.654    52.117     0.150
     1.654    28.812     0.150
     1.654    29.414     0.150
     1.720    29.711     0.150
     1.720    31.414     0.150
     1.720    54.812     0.150
     1.921    58.211     0.150
     1.921    34.312     0.150
     1.921    59.312     0.150
     1.989    33.016     0.150
     1.989    35.414     0.150
     1.989    61.117     0.150
     1.967    33.312     0.150
     1.967    34.914     0.150
     1.967    37.312     0.150
     1.967    61.211     0.150
     2.141    35.516     0.150
     2.141    38.516     0.150
     2.141    68.117     0.150
     2.391    39.016     0.150
     2.391    41.516     0.150
     2.391    43.414     0.150
     2.391    72.711     0.150
     2.391    39.117     0.150
     2.391    43.211     0.150
     2.391    66.914     0.150
     2.512    39.914     0.150
     2.512    44.016     0.150
     2.512    45.914     0.150
     2.512    71.016     0.150
     2.512    79.516     0.150
     2.820    44.711     0.150
     2.820    50.211     0.150
     2.820    86.711     0.150
     2.820    86.016     0.150
     2.906    45.516     0.150
     2.906    51.914     0.150
     2.906    79.711     0.150
     2.906    89.117     0.150
     3.024    53.516     0.150
     3.024    54.516     0.150
     3.024    93.617     0.150
     3.024    47.211     0.150
     3.024    54.211     0.150
     3.024    94.414     0.150
     3.179    49.016     0.150
     3.179    56.914     0.150
     3.179    87.211     0.150
     3.179    99.016     0.150
     3.179    54.711     0.150
     3.179    86.617     0.150
     3.179    98.516     0.150
     3.183    51.117     0.150
     3.183    58.414     0.150
     3.183    99.312     0.150
     3.183    51.414     0.150
     3.183    58.516     0.150
     3.183    99.516     0.150
     3.160    48.914     0.150
     3.160    87.711     0.150
     3.160    98.711     0.150
     3.631    55.484     0.150
     3.631    64.781     0.150
     3.631   112.258     0.150
     3.631    54.633     0.150
     3.631    55.312     0.150
     3.631    65.211     0.150
     3.631    98.312     0.150
     3.631   112.117     0.150
     3.833    60.211     0.150
     3.833    69.914     0.150
     3.833   119.414     0.150
     4.197    63.914     0.150
     4.197    73.914     0.150
     4.197   129.617     0.150
     4.197    75.312     0.150
     4.197   127.414     0.150
     4.321    64.016     0.150
     4.321    78.016     0.150
     4.321   131.812     0.150
     4.321   134.117     0.150
     4.321    64.516     0.150
     4.321    76.117     0.150
     4.321   113.812     0.150
     4.321   132.812     0.150
     4.605    69.617     0.150
     4.605    83.914     0.150
     4.605   144.516     0.150
     4.605    83.711     0.150
     5.000    74.211     0.150
     5.000    90.312     0.150
     5.000   153.914     0.150
     5.114    77.516     0.150
     5.114    90.617     0.150
     5.114   137.117     0.150
     5.114    78.312     0.150
     5.114    92.516     0.150
     5.114   136.711     0.150
     5.114   155.312     0.150
     5.282    78.016     0.150
     5.282   162.516     0.150
     5.282    77.117     0.150
     5.282    92.914     0.150
     5.282   137.617     0.150
     5.282   161.117     0.150
     5.540    83.117     0.150
     5.540   147.516     0.150
     5.540   172.016     0.150
     5.540    99.516     0.150
     5.681    83.562     0.150
     5.681    86.711     0.150
     5.681   102.312     0.150
     5.681   149.211     0.150
     5.681   178.414     0.150
     5.681    84.414     0.150
     5.810    86.375     0.150
     5.810    86.375     0.150
     5.810   184.477     0.150
     6.370    92.516     0.150
     6.418    93.617     0.150
     6.418   199.211     0.150
     6.418    93.914     0.150
     6.630    96.516     0.150
     6.630   204.016     0.150
     6.630    96.117     0.150
     6.630   171.016     0.150
     7.267   106.211     0.150
     7.267   224.414     0.150
     7.980   112.914     0.150
     8.946   160.516     0.150
     8.946   277.711     0.150
     9.648   137.914     0.150
     9.648   298.312     0.150
     9.608   135.812     0.150
    13.828   193.914     0.150
    14.013   194.672     0.150
    14.013   194.516     0.150
    14.013   350.516     0.150
    14.242   444.664     0.150
    17.739   557.180     0.150
    18.219   252.055     0.150
    18.219   253.461     0.150
    18.219   253.461     0.150
    18.219   571.977     0.150
    18.396   255.938     0.150
    18.719   257.312     0.150
    18.719   260.211     0.150
    18.805   258.938     0.150
    20.281   273.727     0.150
    20.281   628.570     0.150
    20.281   272.938     0.150
    22.855   303.102     0.150
    22.907   304.852     0.150
    24.369   318.211     0.150
    26.426   336.117     0.150
    26.426   607.312     0.150
    30.352   371.812     0.150
    40.511   457.016     0.150
    42.380   475.508     0.150
    42.380   475.508     0.150
    46.628   506.859     0.150
    48.438   520.906     0.150
    48.650   522.945     0.150
    48.650   522.977     0.150
    50.322   534.953     0.150
    51.120   542.711     0.150
    51.120   542.711     0.150
    51.120   545.211     0.150
    59.480   599.570     0.150
    59.480   599.570     0.150
    70.718   675.242     0.150
    76.309   707.844     0.150
    76.309   707.844     0.150
    78.658   720.812     0.150
    79.780   726.562     0.150
    89.483   775.797     0.150
    89.485   775.789     0.150
     0.311     6.308     0.150
     0.311    10.808     0.150
     0.642    12.608     0.150
     0.642    21.308     0.150
     0.788    14.908     0.150
     0.788    25.508     0.150
     0.903    16.808     0.150
     0.903    29.508     0.150
     1.149    21.208     0.150
     1.149    36.908     0.150
     1.183    22.308     0.150
     1.183    38.208     0.150
     1.475    27.008     0.150
     1.475    47.008     0.150
     1.480    25.708     0.150
     1.480    26.208     0.150
     1.480    46.108     0.150
     1.743    31.508     0.150
     1.743    54.608     0.150
     2.137    35.208     0.150
     2.137    38.908     0.150
     2.137    65.708     0.150
     2.272    70.508     0.150
     2.736    43.108     0.150
     2.736    47.008     0.150
     2.736    48.708     0.150
     2.736    84.808     0.150
     2.865    44.608     0.150
     2.865    51.208     0.150
     2.865    88.808     0.150
     2.955    46.208     0.150
     2.955    50.608     0.150
     2.955    90.708     0.150
     3.453    53.208     0.150
     3.453    61.008     0.150
     3.453   105.408     0.150
     3.453   108.308     0.150
     3.506    53.808     0.150
     3.506    63.408     0.150
     3.506   108.508     0.150
     3.664   112.508     0.150
     3.843   119.908     0.150
     3.879   119.708     0.150
     4.374    67.508     0.150
     4.374   114.508     0.150
     4.374   133.908     0.150
     4.391    65.708     0.150
     4.391    79.408     0.150
     4.391   113.008     0.150
     4.391   135.108     0.150
     4.582   132.808     0.150
     4.582   144.008     0.150
     4.862    75.208     0.150
     4.862    87.608     0.150
     4.862   149.808     0.150
     5.762   104.408     0.150
     5.762   179.208     0.150
     5.980   185.408     0.150
     7.125   222.308     0.150
     7.185   224.108     0.150
     7.364   227.708     0.150
     0.190     4.426     0.150
     0.190     7.926     0.150
     0.585    11.023     0.150
     0.585    19.324     0.150
     0.608    12.523     0.150
     0.608    19.824     0.150
     0.608    20.723     0.150
     0.999    17.926     0.150
     0.999    31.426     0.150
     1.181    21.523     0.150
     1.181    37.625     0.150
     1.373    24.125     0.150
     1.373    24.926     0.150
     1.373    42.824     0.150
     1.373    44.426     0.150
     1.514    26.926     0.150
     1.514    47.824     0.150
     1.659    29.926     0.150
     1.907    34.625     0.150
     1.907    59.824     0.150
     2.250    36.426     0.150
     2.250    38.926     0.150
     2.250    69.426     0.150
     2.234    36.523     0.150
     2.234    39.125     0.150
     2.234    40.926     0.150
     2.234    63.426     0.150
     2.234    68.625     0.150
     2.560    41.523     0.150
     2.560    45.023     0.150
     2.560    70.125     0.150
     2.560    77.926     0.150
     2.560    80.824     0.150
     2.627    41.523     0.150
     2.627    46.926     0.150
     2.627    73.426     0.150
     2.627    81.125     0.150
     2.744    42.625     0.150
     2.744    48.125     0.150
     2.744    76.125     0.150
     2.744    83.824     0.150
     2.880    45.324     0.150
     2.880    50.625     0.150
     2.880    78.926     0.150
     2.880    88.426     0.150
     3.048    47.023     0.150
     3.048    53.125     0.150
     3.048    82.125     0.150
     3.048    92.523     0.150
     3.369    59.324     0.150
     3.369   103.926     0.150
     3.350    50.926     0.150
     3.350    59.324     0.150
     3.350    90.324     0.150
     3.350   103.324     0.150
     3.417    60.926     0.150
     3.417   105.125     0.150
     3.918    60.523     0.150
     3.918    69.824     0.150
     3.918   105.324     0.150
     3.918   120.426     0.150
     4.096    72.926     0.150
     4.096   126.426     0.150
     4.333    77.926     0.150
     4.333   134.125     0.150
     4.835    74.523     0.150
     4.835    86.926     0.150
     4.835   148.824     0.150
     5.271    93.324     0.150
     5.271   161.523     0.150
     5.276    79.824     0.150
     5.276    93.926     0.150
     5.276   139.223     0.150
     5.276   163.223     0.150
     5.518    80.324     0.150
     5.518   143.523     0.150
     5.518   170.125     0.150
     6.694   120.223     0.150
     6.694   206.223     0.150
     6.906   100.023     0.150
     6.906   123.625     0.150
     6.906   212.023     0.150
     7.527   135.824     0.150
     7.527   232.824     0.150
     8.681   157.023     0.150
     8.681   269.223     0.150
     0.194     4.594     0.150
     0.194     7.395     0.150
     0.588    11.094     0.150
     0.588    19.395     0.150
     0.602    12.594     0.150
     0.602    20.297     0.150
     1.001    17.996     0.150
     1.001    31.496     0.150
     1.184    21.695     0.150
     1.184    37.594     0.150
     1.372    24.297     0.150
     1.372    43.594     0.150
     1.517    26.797     0.150
     1.517    27.695     0.150
     1.517    47.996     0.150
     1.696    30.094     0.150
     1.696    31.695     0.150
     1.696    54.797     0.150
     2.249    36.594     0.150
     2.249    38.996     0.150
     2.249    68.797     0.150
     2.556    41.496     0.150
     2.556    45.395     0.150
     2.556    69.695     0.150
     2.556    78.094     0.150
     3.046    47.895     0.150
     3.046    53.496     0.150
     3.046    92.797     0.150
     0.145     3.422     0.150
     0.145     6.223     0.150
     0.628    11.723     0.150
     0.628    12.723     0.150
     0.628    20.523     0.150
     0.642    13.023     0.150
     0.642    21.621     0.150
     0.940    16.422     0.150
     0.940    29.023     0.150
     1.136    21.223     0.150
     1.136    37.621     0.150
     1.225    22.422     0.150
     1.225    39.422     0.150
     1.432    25.320     0.150
     1.432    45.621     0.150
     1.553    27.723     0.150
     1.553    28.320     0.150
     1.553    49.320     0.150
     1.712    30.621     0.150
     1.752    30.523     0.150
     1.752    32.320     0.150
     1.752    56.820     0.150
     1.953    61.621     0.150
     2.196    35.922     0.150
     2.196    38.723     0.150
     2.196    62.422     0.150
     2.196    67.621     0.150
     2.292    37.023     0.150
     2.292    40.223     0.150
     2.292    65.820     0.150
     2.292    70.723     0.150
     2.525    41.023     0.150
     2.525    44.621     0.150
     2.525    71.023     0.150
     2.525    76.621     0.150
     2.685    42.820     0.150
     2.685    47.523     0.150
     2.685    74.523     0.150
     2.685    82.523     0.150
     2.803    44.422     0.150
     2.803    49.621     0.150
     2.803    78.621     0.150
     2.803    86.121     0.150
     2.938    46.422     0.150
     2.938    51.621     0.150
     2.938    81.320     0.150
     2.938    91.422     0.150
     3.326    50.820     0.150
     3.326    58.422     0.150
     3.326   102.121     0.150
     3.369    60.422     0.150
     3.369   104.121     0.150
     3.409    52.223     0.150
     3.409    59.820     0.150
     3.409    92.121     0.150
     3.409   104.621     0.150
     3.409   106.422     0.150
     3.977    61.723     0.150
     3.977    71.523     0.150
     3.977   106.422     0.150
     3.977   120.121     0.150
     3.977   122.723     0.150
     4.351    64.621     0.150
     4.351    77.320     0.150
     4.351    79.723     0.150
     4.351   113.820     0.150
     4.351   133.320     0.150
     4.389    67.621     0.150
     4.389    79.422     0.150
     4.389   114.621     0.150
     4.389   137.023     0.150
     4.894    73.723     0.150
     4.894    87.723     0.150
     4.894   131.121     0.150
     4.894   150.922     0.150
     5.332    81.320     0.150
     5.332   140.121     0.150
     5.332   164.922     0.150
     5.470    97.523     0.150
     5.470   167.820     0.150
     6.636    97.723     0.150
     6.636   120.621     0.150
     6.636   206.023     0.150
     6.847    99.320     0.150
     6.847   122.422     0.150
     6.847   210.320     0.150
     7.582   235.223     0.150
     0.162     3.281     0.150
     0.162     6.082     0.150
     0.573    10.781     0.150
     0.573    19.082     0.150
     0.641    12.980     0.150
     0.641    21.480     0.150
     0.986    17.582     0.150
     0.986    30.980     0.150
     1.170    21.480     0.150
     1.170    37.582     0.150
     1.170    41.082     0.150
     1.387    24.684     0.150
     1.387    25.980     0.150
     1.387    44.383     0.150
     1.499    27.383     0.150
     1.499    48.082     0.150
     1.499    49.781     0.150
     1.658    30.281     0.150
     1.658    53.582     0.150
     2.250    37.582     0.150
     2.250    39.383     0.150
     2.250    69.582     0.150
     2.241    37.184     0.150
     2.241    40.480     0.150
     2.241    70.684     0.150
     2.577    42.480     0.150
     2.577    45.980     0.150
     2.577    76.281     0.150
     2.577    79.281     0.150
     2.635    42.883     0.150
     2.635    46.781     0.150
     2.635    81.582     0.150
     2.758    48.281     0.150
     2.758    84.883     0.150
     2.889    46.480     0.150
     2.889    51.781     0.150
     2.889    89.684     0.150
     3.056    48.781     0.150
     3.056    53.781     0.150
     3.056    90.684     0.150
     3.056    94.184     0.150
     3.338    58.883     0.150
     3.338   102.980     0.150
     3.361    52.781     0.150
     3.361    59.582     0.150
     3.361   103.480     0.150
     3.424    54.082     0.150
     3.424   107.184     0.150
     3.737    58.383     0.150
     3.737    66.480     0.150
     3.737   115.281     0.150
     3.934    60.582     0.150
     3.934    70.582     0.150
     3.934   123.082     0.150
     4.096    72.582     0.150
     4.096   126.883     0.150
     4.336    78.082     0.150
     4.336   135.383     0.150
     4.852    75.480     0.150
     4.852    84.383     0.150
     4.852   149.883     0.150
     5.268   163.184     0.150
     5.298    81.281     0.150
     5.298    94.082     0.150
     5.298   142.582     0.150
     5.298   163.684     0.150
     5.526   170.781     0.150
     6.577   203.480     0.150
     6.888   100.781     0.150
     6.888   124.383     0.150
     6.888   214.082     0.150
     7.550   110.980     0.150
     7.550   136.684     0.150
     7.550   234.980     0.150
     8.703   267.980     0.150
    10.065   312.480     0.150
     0.166     3.371     0.150
     0.166     6.070     0.150
     0.570    10.672     0.150
     0.570    18.770     0.150
     0.638    12.871     0.150
     0.638    21.270     0.150
     0.990    17.672     0.150
     0.990    30.871     0.150
     1.079    20.172     0.150
     1.079    35.672     0.150
     1.079    38.270     0.150
     1.168    21.371     0.150
     1.168    37.469     0.150
     1.168    40.570     0.150
     1.383    24.672     0.150
     1.383    44.070     0.150
     1.613    29.871     0.150
     1.613    50.969     0.150
     1.613    52.270     0.150
     1.654    30.270     0.150
     1.654    52.871     0.150
     1.895    34.270     0.150
     1.895    60.172     0.150
     2.254    37.570     0.150
     2.254    39.371     0.150
     2.254    69.570     0.150
     2.237    39.770     0.150
     2.237    69.770     0.150
     2.579    42.570     0.150
     2.579    45.871     0.150
     2.579    78.672     0.150
     2.754    85.270     0.150
     3.059    48.969     0.150
     3.059    53.871     0.150
     3.059    94.770     0.150
     3.342   103.672     0.150
     3.357    58.969     0.150
     3.357   103.172     0.150
     3.741    57.871     0.150
     3.741    65.969     0.150
     3.741   115.270     0.150
     3.930    62.371     0.150
     3.930    70.672     0.150
     3.930   119.270     0.150
     3.930   122.371     0.150
     4.099   125.469     0.150
     4.333    65.672     0.150
     4.333   114.672     0.150
     4.333   133.270     0.150
     4.332    77.172     0.150
     4.332   125.469     0.150
     4.332   134.969     0.150
     4.848    75.270     0.150
     4.848   129.570     0.150
     4.848   144.070     0.150
     4.848   149.770     0.150
     5.272    79.371     0.150
     5.272    94.469     0.150
     5.272   133.570     0.150
     5.272   163.469     0.150
     5.294    80.969     0.150
     5.294   162.770     0.150
     5.529   170.770     0.150
     6.692   206.270     0.150
     6.892   123.172     0.150
     6.892   213.070     0.150
     8.285   253.969     0.150
     0.343     7.990     0.150
     0.343    12.890     0.150
     0.620    11.690     0.150
     0.620    20.390     0.150
     0.698    12.890     0.150
     0.698    22.690     0.150
     0.922    16.590     0.150
     0.922    29.490     0.150
     0.922    30.590     0.150
     1.352    23.890     0.150
     1.352    42.590     0.150
     1.375    43.990     0.150
     1.438    25.390     0.150
     1.438    26.090     0.150
     1.438    45.590     0.150
     1.487    25.590     0.150
     1.487    26.291     0.150
     1.487    45.690     0.150
     1.720    29.590     0.150
     1.720    31.291     0.150
     1.720    54.391     0.150
     1.827    30.590     0.150
     1.827    56.990     0.150
     2.209    36.291     0.150
     2.209    38.291     0.150
     2.209    63.791     0.150
     2.209    67.190     0.150
     2.274    64.391     0.150
     2.274    68.791     0.150
     2.450    39.090     0.150
     2.450    42.090     0.150
     2.450    74.690     0.150
     2.633    41.791     0.150
     2.633    45.590     0.150
     2.633    80.190     0.150
     2.633    82.690     0.150
     2.729    43.590     0.150
     2.729    48.391     0.150
     2.729    79.791     0.150
     2.729    83.190     0.150
     2.904    52.435     0.150
     2.904    80.484     0.150
     2.904    45.391     0.150
     2.904    50.590     0.150
     2.904    79.391     0.150
     2.904    87.891     0.150
     3.338    50.690     0.150
     3.338    58.190     0.150
     3.338    97.190     0.150
     3.338   102.391     0.150
     3.436    54.291     0.150
     3.436    59.490     0.150
     3.436    62.990     0.150
     3.436   103.690     0.150
     3.717   114.891     0.150
     3.853   119.190     0.150
     3.958    71.990     0.150
     3.958   123.490     0.150
     4.157    72.990     0.150
     4.157   126.490     0.150
     4.348    68.490     0.150
     4.348    75.891     0.150
     4.348   117.090     0.150
     4.348   132.490     0.150
     4.684    68.690     0.150
     4.684    80.891     0.150
     4.684   118.690     0.150
     4.684   143.791     0.150
     4.766   124.291     0.150
     5.453   168.791     0.150
     5.526   173.542     0.150
     5.671    98.490     0.150
     5.810   178.490     0.150
     7.015   216.190     0.150
     7.111   204.891     0.150
     7.111   219.891     0.150
     7.403   106.490     0.150
     7.403   130.690     0.150
     8.742   269.791     0.150
    17.444   245.315     0.150
     0.159     3.289     0.150
     0.159     5.992     0.150
     0.571    10.789     0.150
     0.571    19.289     0.150
     0.645    12.992     0.150
     0.645    21.688     0.150
     0.985    17.688     0.150
     0.985    31.188     0.150
     1.082    21.086     0.150
     1.082    35.391     0.150
     1.082    38.492     0.150
     1.388    24.789     0.150
     1.388    43.086     0.150
     1.388    44.492     0.150
     1.497    27.492     0.150
     1.497    48.188     0.150
     1.698    32.492     0.150
     1.698    54.891     0.150
     1.896    34.391     0.150
     1.896    60.492     0.150
     2.251    37.586     0.150
     2.251    39.492     0.150
     2.251    69.891     0.150
     2.241    36.688     0.150
     2.241    40.688     0.150
     2.241    70.789     0.150
     2.580    42.992     0.150
     2.580    45.992     0.150
     2.580    76.289     0.150
     2.580    80.688     0.150
     2.636    46.789     0.150
     2.636    74.086     0.150
     2.636    80.688     0.150
     2.759    85.492     0.150
     2.890    51.992     0.150
     2.890    88.789     0.150
     2.890    90.992     0.150
     3.058    49.086     0.150
     3.058    53.789     0.150
     3.058    93.688     0.150
     3.335    60.992     0.150
     3.335   103.188     0.150
     3.362    51.992     0.150
     3.362    60.289     0.150
     3.362   103.891     0.150
     3.737    58.289     0.150
     3.737    66.891     0.150
     3.737   115.586     0.150
     3.935    60.086     0.150
     3.935    70.289     0.150
     3.935   118.188     0.150
     3.935   121.688     0.150
     4.096    74.891     0.150
     4.096   126.992     0.150
     4.327    64.188     0.150
     4.327    78.586     0.150
     4.327   114.586     0.150
     4.327   133.086     0.150
     4.336    76.891     0.150
     4.336    79.789     0.150
     4.336   135.492     0.150
     4.853    74.586     0.150
     4.853    86.188     0.150
     4.853   129.891     0.150
     4.853   149.492     0.150
     5.300    81.891     0.150
     5.300    95.992     0.150
     5.300   164.289     0.150
     5.527    98.188     0.150
     5.527   170.492     0.150
     5.493   100.391     0.150
     5.493   144.789     0.150
     5.493   171.188     0.150
     6.688   207.586     0.150
     6.886   100.086     0.150
     6.886   122.289     0.150
     6.886   212.391     0.150
     7.552   233.188     0.150
     8.280   254.586     0.150
     8.706   269.289     0.150
     9.122   282.188     0.150
    10.065   311.086     0.150
     0.167     3.375     0.150
     0.167     6.172     0.150
     0.575    10.875     0.150
     0.575    19.570     0.150
     0.635    12.977     0.150
     0.635    21.570     0.150
     0.988    17.773     0.150
     0.988    31.273     0.150
     0.988    17.672     0.150
     0.988    31.172     0.150
     1.082    20.172     0.150
     1.082    35.875     0.150
     1.082    38.570     0.150
     1.385    24.773     0.150
     1.385    44.172     0.150
     1.385    43.477     0.150
     1.502    27.477     0.150
     1.502    47.070     0.150
     1.658    30.977     0.150
     1.658    53.070     0.150
     1.658    30.570     0.150
     1.658    53.172     0.150
     1.698    30.477     0.150
     1.698    31.977     0.150
     1.698    54.570     0.150
     1.900    33.273     0.150
     1.900    34.477     0.150
     1.900    60.672     0.150
     2.250    37.672     0.150
     2.250    39.570     0.150
     2.250    69.875     0.150
     2.250    40.570     0.150
     2.250    65.773     0.150
     2.250    69.273     0.150
     2.240    36.875     0.150
     2.240    40.477     0.150
     2.240    70.977     0.150
     2.574    42.477     0.150
     2.574    45.977     0.150
     2.574    79.875     0.150
     2.574    42.672     0.150
     2.574    72.375     0.150
     2.574    78.570     0.150
     2.634    42.977     0.150
     2.634    46.070     0.150
     2.634    47.773     0.150
     2.634    75.070     0.150
     2.634    81.773     0.150
     2.756    43.070     0.150
     2.756    47.977     0.150
     2.756    84.773     0.150
     2.756    48.977     0.150
     2.887    46.672     0.150
     2.887    51.773     0.150
     2.887    89.977     0.150
     3.055    48.875     0.150
     3.055    53.977     0.150
     3.055    94.672     0.150
     3.344    51.672     0.150
     3.344    59.273     0.150
     3.344    89.977     0.150
     3.344   103.477     0.150
     3.344    52.172     0.150
     3.344    61.172     0.150
     3.344    93.672     0.150
     3.344   102.977     0.150
     3.359    52.172     0.150
     3.359    60.172     0.150
     3.359    95.273     0.150
     3.359   104.773     0.150
     3.359    60.070     0.150
     3.359   104.273     0.150
     3.738    58.172     0.150
     3.738    67.070     0.150
     3.738   115.477     0.150
     3.738   114.672     0.150
     3.931    61.172     0.150
     3.931    69.773     0.150
     3.931   121.570     0.150
     3.931   123.977     0.150
     3.931    62.273     0.150
     3.931   119.070     0.150
     4.096    72.672     0.150
     4.096    75.477     0.150
     4.096   125.875     0.150
     4.335    77.672     0.150
     4.335   135.375     0.150
     4.335    67.070     0.150
     4.335    77.375     0.150
     4.335   134.875     0.150
     4.337    65.570     0.150
     4.337    76.070     0.150
     4.337    79.273     0.150
     4.337   116.477     0.150
     4.337   133.070     0.150
     4.337    65.672     0.150
     4.337    77.672     0.150
     4.337   115.273     0.150
     4.337   132.570     0.150
     4.849    75.375     0.150
     4.849    85.570     0.150
     4.849   132.977     0.150
     4.849   149.672     0.150
     4.849    75.477     0.150
     4.849    87.570     0.150
     4.849   132.773     0.150
     5.294    81.172     0.150
     5.294   142.477     0.150
     5.294   162.672     0.150
     5.294    80.977     0.150
     5.294    95.875     0.150
     5.294   162.773     0.150
     5.524    82.273     0.150
     5.524    98.375     0.150
     5.524   170.070     0.150
     5.524    81.477     0.150
     5.524    97.375     0.150
     5.500    84.172     0.150
     5.500    98.773     0.150
     5.500   170.477     0.150
     5.613    84.836     0.150
     5.613   151.242     0.150
     5.613   176.250     0.150
     6.574    99.375     0.150
     6.574   203.875     0.150
     6.689   120.477     0.150
     6.689   206.773     0.150
     6.891   100.672     0.150
     6.891   213.477     0.150
     6.891   123.070     0.150
     6.891   178.273     0.150
     7.546   112.570     0.150
     7.546   131.273     0.150
     7.546   234.875     0.150
     8.282   120.172     0.150
     8.282   256.477     0.150
     8.700   266.977     0.150
     9.115   282.375     0.150
     9.919   306.773     0.150
    10.067   310.477     0.150
    13.578   192.070     0.150
    14.041   199.977     0.150
    15.106   472.852     0.150
    17.906   563.438     0.150
    17.963   250.172     0.150
    17.963   249.984     0.150
    17.963   565.461     0.150
    18.495   256.977     0.150
    18.580   256.992     0.150
    18.580   584.148     0.150
    18.796   586.516     0.150
    20.486   277.234     0.150
    20.486   277.070     0.150
    20.798   283.109     0.150
    22.664   301.812     0.150
    42.312   474.297     0.150
    48.895   525.969     0.150
    50.935   542.641     0.150
    76.282   709.141     0.150
     0.273     5.859     0.150
     0.273    10.262     0.150
     0.538    11.562     0.150
     0.538    18.859     0.150
     0.746    14.262     0.150
     0.746    24.762     0.150
     0.943    16.660     0.150
     0.943    29.262     0.150
     1.453    26.262     0.150
     1.453    45.562     0.150
     1.676    29.660     0.150
     1.676    30.660     0.150
     1.676    53.359     0.150
     1.756    30.160     0.150
     1.756    31.660     0.150
     1.756    56.062     0.150
     1.793    30.262     0.150
     1.816    31.461     0.150
     1.816    34.562     0.150
     1.816    58.562     0.150
     2.059    34.859     0.150
     2.059    37.160     0.150
     2.059    64.961     0.150
     2.127    34.961     0.150
     2.127    37.062     0.150
     2.127    65.262     0.150
     2.336    37.160     0.150
     2.336    41.062     0.150
     2.336    66.461     0.150
     2.336    71.562     0.150
     2.726    43.660     0.150
     2.726    48.762     0.150
     2.726    74.262     0.150
     2.726    83.562     0.150
     2.816    50.262     0.150
     2.816    86.660     0.150
     2.816    89.062     0.150
     2.901    46.262     0.150
     2.901    51.961     0.150
     2.901    89.262     0.150
     2.974    47.160     0.150
     2.974    53.262     0.150
     2.974    81.461     0.150
     2.974    91.062     0.150
     3.424   106.062     0.150
     3.437    53.461     0.150
     3.437    60.961     0.150
     3.437   105.359     0.150
     3.972   105.762     0.150
     3.972   122.062     0.150
     4.450    67.961     0.150
     4.450    79.961     0.150
     4.450   116.762     0.150
     4.450   137.961     0.150
     4.497    66.562     0.150
     4.497    80.859     0.150
     4.497   117.160     0.150
     4.497   138.859     0.150
     4.894    74.160     0.150
     4.894    87.062     0.150
     4.894   133.062     0.150
     4.894   150.062     0.150
     5.158    77.762     0.150
     5.158    91.660     0.150
     5.158   158.961     0.150
     5.301    80.961     0.150
     5.301   137.562     0.150
     5.301   164.262     0.150
     5.373   165.062     0.150
     5.682    84.660     0.150
     5.682   177.062     0.150
     6.588   117.562     0.150
     6.588   167.461     0.150
     6.588   203.262     0.150
     6.859    99.359     0.150
     6.859   123.359     0.150
     6.859   173.359     0.150
     6.859   210.762     0.150
     7.542   233.660     0.150
     8.204   253.762     0.150
     9.993   307.461     0.150
     0.181     3.570     0.150
     0.181     6.367     0.150
     0.470     9.070     0.150
     0.470    16.367     0.150
     0.817    16.168     0.150
     0.817    27.168     0.150
     1.001    17.770     0.150
     1.001    31.070     0.150
     1.365    25.270     0.150
     1.365    43.770     0.150
     1.413    44.867     0.150
     1.413    25.770     0.150
     1.545    27.969     0.150
     1.545    49.270     0.150
     1.593    29.168     0.150
     1.593    29.969     0.150
     1.593    51.070     0.150
     1.593    51.367     0.150
     1.657    30.867     0.150
     1.657    53.770     0.150
     1.791    32.070     0.150
     1.791    32.668     0.150
     1.791    56.770     0.150
     2.224    36.969     0.150
     2.224    40.070     0.150
     2.224    64.270     0.150
     2.224    69.969     0.150
     2.224    37.168     0.150
     2.224    69.770     0.150
     2.330    38.668     0.150
     2.330    40.770     0.150
     2.330    42.367     0.150
     2.330    71.867     0.150
     2.330    39.070     0.150
     2.330    41.969     0.150
     2.330    68.168     0.150
     2.621    42.668     0.150
     2.621    47.168     0.150
     2.621    74.867     0.150
     2.621    80.969     0.150
     2.621    46.867     0.150
     2.621    74.969     0.150
     2.621    81.070     0.150
     2.735    44.570     0.150
     2.735    48.668     0.150
     2.735    83.070     0.150
     2.735    44.770     0.150
     2.735    49.469     0.150
     2.735    83.770     0.150
     2.780    48.969     0.150
     2.780    77.570     0.150
     2.780    85.770     0.150
     2.880    46.469     0.150
     2.880    50.367     0.150
     2.880    51.469     0.150
     2.880    79.867     0.150
     2.880    88.867     0.150
     2.880    52.168     0.150
     2.880    88.469     0.150
     3.202    49.270     0.150
     3.202    56.270     0.150
     3.202    98.668     0.150
     3.202    87.270     0.150
     3.202    98.070     0.150
     3.174    50.469     0.150
     3.174    57.367     0.150
     3.174    97.969     0.150
     3.174    49.469     0.150
     3.174    55.969     0.150
     3.174    86.867     0.150
     3.174    96.367     0.150
     3.360    52.762     0.150
     3.360    60.512     0.150
     3.360   103.539     0.150
     3.360    52.867     0.150
     3.360    59.668     0.150
     3.360    91.270     0.150
     3.360   103.867     0.150
     3.360    60.070     0.150
     3.360   104.168     0.150
     3.536    55.367     0.150
     3.536    63.270     0.150
     3.536   108.469     0.150
     3.536   112.867     0.150
     3.789    59.270     0.150
     3.789    67.969     0.150
     3.789   101.969     0.150
     3.789   116.367     0.150
     3.789    67.367     0.150
     3.789   116.070     0.150
     3.962    61.867     0.150
     3.962    71.367     0.150
     3.962   120.867     0.150
     3.962   122.270     0.150
     4.138    63.367     0.150
     4.138    74.367     0.150
     4.138   110.168     0.150
     4.138   127.168     0.150
     4.138    62.770     0.150
     4.138    73.770     0.150
     4.138   110.668     0.150
     4.171    75.168     0.150
     4.171   129.867     0.150
     4.288    76.367     0.150
     4.288   114.270     0.150
     4.288   132.770     0.150
     4.288    66.570     0.150
     4.288    75.570     0.150
     4.288   133.570     0.150
     4.884    75.668     0.150
     4.884    86.570     0.150
     4.884   150.168     0.150
     4.884    76.469     0.150
     4.884    87.469     0.150
     4.884   134.570     0.150
     4.884   150.570     0.150
     5.325    81.367     0.150
     5.325    94.867     0.150
     5.325    81.168     0.150
     5.325    95.668     0.150
     5.335    80.969     0.150
     5.335    96.367     0.150
     5.335   166.168     0.150
     5.369    82.070     0.150
     5.369    97.168     0.150
     5.369   142.270     0.150
     5.459    82.891     0.150
     5.459    98.109     0.150
     5.459   145.270     0.150
     5.459   172.328     0.150
     5.635   100.367     0.150
     5.635    84.867     0.150
     5.635   100.867     0.150
     6.732   100.270     0.150
     6.732   208.367     0.150
     6.722   100.168     0.150
     6.722   174.469     0.150
     6.722   209.270     0.150
     6.855   100.770     0.150
     6.855   121.969     0.150
     6.855   178.070     0.150
     7.313   226.570     0.150
     7.975   246.367     0.150
     8.297   139.570     0.150
     8.297   254.969     0.150
     9.208   285.367     0.150
    10.076   311.367     0.150
    14.166   440.586     0.150
    18.015   253.195     0.150
    18.595   259.770     0.150
    18.680   259.754     0.150
    74.969   702.617     0.150
    76.079   707.594     0.150
    79.544   727.418     0.150
     0.114     3.602     0.150
     0.114     6.398     0.150
     0.588    11.297     0.150
     0.588    20.297     0.150
     0.684    13.797     0.150
     0.684    23.102     0.150
     0.946    16.797     0.150
     0.946    29.500     0.150
     1.114    21.602     0.150
     1.114    37.398     0.150
     1.429    25.500     0.150
     1.429    45.695     0.150
     1.509    27.000     0.150
     1.509    46.797     0.150
     1.642    29.500     0.150
     1.642    50.797     0.150
     1.685    30.602     0.150
     1.731    32.195     0.150
     1.731    54.297     0.150
     1.916    33.000     0.150
     1.916    34.797     0.150
     2.223    38.195     0.150
     2.223    68.195     0.150
     2.278    41.500     0.150
     2.278    70.602     0.150
     2.573    41.297     0.150
     2.573    44.695     0.150
     2.573    75.898     0.150
     2.573    78.297     0.150
     2.672    47.602     0.150
     2.672    74.297     0.150
     2.672    82.000     0.150
     2.800    47.898     0.150
     2.800    86.000     0.150
     2.927    45.500     0.150
     2.927    52.500     0.150
     2.927    91.297     0.150
     3.039    47.602     0.150
     3.039    53.195     0.150
     3.039    93.000     0.150
     3.291    59.000     0.150
     3.291   102.297     0.150
     3.400    60.000     0.150
     3.400   105.602     0.150
     3.705    56.898     0.150
     3.705    64.695     0.150
     3.705    67.195     0.150
     3.705   114.500     0.150
     3.977    60.797     0.150
     3.977    71.102     0.150
     3.977   123.102     0.150
     4.298    64.195     0.150
     4.298    77.602     0.150
     4.298   112.898     0.150
     4.298   132.195     0.150
     4.368    66.398     0.150
     4.368   135.797     0.150
     4.895    73.398     0.150
     4.895    87.195     0.150
     4.895   131.797     0.150
     4.895   151.000     0.150
     5.236    77.398     0.150
     5.236    94.297     0.150
     5.236   161.898     0.150
     5.345    79.000     0.150
     5.345   164.695     0.150
     5.506   169.398     0.150
     6.655   205.297     0.150
     6.844    98.695     0.150
     6.844   121.500     0.150
     6.844   210.195     0.150
     8.243   256.000     0.150
    10.026   309.195     0.150
     0.069     3.824     0.150
     0.069     6.723     0.150
     0.685    12.824     0.150
     0.685    22.324     0.150
     0.736    14.523     0.150
     0.736    23.922     0.150
     0.838    15.125     0.150
     0.838    16.723     0.150
     0.838    26.723     0.150
     1.221    22.824     0.150
     1.221    38.422     0.150
     1.535    26.824     0.150
     1.535    47.422     0.150
     1.597    28.625     0.150
     1.597    49.824     0.150
     1.746    31.523     0.150
     1.746    53.824     0.150
     2.119    34.223     0.150
     2.119    36.723     0.150
     2.119    58.824     0.150
     2.119    64.723     0.150
     2.945    46.125     0.150
     2.945    51.723     0.150
     2.945    80.023     0.150
     2.945    90.023     0.150
     4.293    63.324     0.150
     4.293    76.324     0.150
     4.293   112.023     0.150
     4.293   131.824     0.150
     6.741   207.125     0.150
     0.448     8.617     0.150
     0.448    15.117     0.150
     0.662    13.518     0.150
     0.662    22.117     0.150
     1.094    20.617     0.150
     1.094    35.718     0.150
     1.094    20.817     0.150
     1.094    34.917     0.150
     1.216    23.317     0.150
     1.216    39.917     0.150
     1.292    24.317     0.150
     1.292    42.518     0.150
     1.296    24.117     0.150
     1.296    41.417     0.150
     1.296    43.617     0.150
     1.296    41.018     0.150
     1.333    25.518     0.150
     1.333    44.518     0.150
     1.374    26.417     0.150
     1.374    46.617     0.150
     1.923    33.617     0.150
     1.923    35.718     0.150
     1.923    61.218     0.150
     1.923    33.117     0.150
     1.923    35.617     0.150
     2.319    38.917     0.150
     2.319    42.317     0.150
     2.319    68.417     0.150
     2.319    72.417     0.150
     2.463    39.117     0.150
     2.463    44.917     0.150
     2.463    76.817     0.150
     2.463    41.117     0.150
     2.463    76.518     0.150
     2.575    46.617     0.150
     2.575    73.817     0.150
     2.575    79.917     0.150
     2.575    46.817     0.150
     2.576    42.018     0.150
     2.576    46.417     0.150
     2.576    79.518     0.150
     2.576    45.417     0.150
     2.857    46.917     0.150
     2.857    50.518     0.150
     2.857    87.617     0.150
     2.857    51.617     0.150
     2.857    79.718     0.150
     3.052    48.937     0.150
     3.052    55.424     0.150
     3.052    94.512     0.150
     3.052    54.617     0.150
     3.052    86.718     0.150
     3.052    95.218     0.150
     3.052    54.817     0.150
     3.052    93.817     0.150
     3.052    49.037     0.150
     3.371    60.718     0.150
     3.371   105.018     0.150
     3.371    53.617     0.150
     3.371    60.617     0.150
     3.371    92.617     0.150
     3.371   103.117     0.150
     3.493    54.917     0.150
     3.493    61.617     0.150
     3.493   110.317     0.150
     3.493    54.018     0.150
     3.493    62.917     0.150
     3.493   110.117     0.150
     3.644    57.117     0.150
     3.644    63.718     0.150
     3.644    66.018     0.150
     3.644   112.117     0.150
     3.741    67.718     0.150
     3.741   115.718     0.150
     3.741    68.117     0.150
     3.741   119.218     0.150
     4.011    63.218     0.150
     4.011    73.117     0.150
     4.011   126.718     0.150
     4.011    72.518     0.150
     4.011   126.518     0.150
     4.062    62.817     0.150
     4.062    72.917     0.150
     4.062   125.817     0.150
     4.297    65.317     0.150
     4.297    78.518     0.150
     4.297   113.518     0.150
     4.297   134.018     0.150
     4.297    75.917     0.150
     4.297   130.417     0.150
     4.421    79.218     0.150
     4.421   137.617     0.150
     4.565    70.617     0.150
     4.565    82.518     0.150
     4.565   124.218     0.150
     4.565   141.718     0.150
     4.565    71.117     0.150
     4.565    82.117     0.150
     4.565   123.018     0.150
     4.565   141.417     0.150
     5.051    77.718     0.150
     5.051    87.817     0.150
     5.051   134.817     0.150
     5.051   157.917     0.150
     5.051    91.518     0.150
     5.236    79.617     0.150
     5.236    79.957     0.150
     5.335    81.417     0.150
     5.335   169.035     0.150
     5.335    81.218     0.150
     5.843   105.218     0.150
     6.867    99.317     0.150
     6.867   174.817     0.150
     6.867   213.018     0.150
     6.996   125.518     0.150
     6.996   183.117     0.150
     7.012   217.817     0.150
     7.173   105.117     0.150
     7.173   222.917     0.150
     7.173   104.817     0.150
     7.173   128.218     0.150
     7.312   111.018     0.150
     7.312   227.917     0.150
     8.246   118.518     0.150
     8.246   118.207     0.150
     8.596   124.317     0.150
     8.596   266.617     0.150
     8.894   275.218     0.150
    12.435   179.317     0.150
    13.324   192.018     0.150
    13.868   196.617     0.150
    13.868   197.567     0.150
    13.868   431.406     0.150
    13.868   196.478     0.150
    14.601   451.530     0.150
    14.601   206.718     0.150
    14.782   211.917     0.150
    14.782   217.218     0.150
    15.312   216.354     0.150
    15.312   217.718     0.150
    16.333   232.218     0.150
    16.333   235.018     0.150
    17.695   245.817     0.150
    17.695   247.787     0.150
    17.695   247.594     0.150
    17.695   555.992     0.150
    17.695   248.018     0.150
    17.874   248.518     0.150
    18.283   253.018     0.150
    18.283   255.337     0.150
    18.368   253.849     0.150
    18.368   578.819     0.150
    18.920   261.349     0.150
    18.920   589.292     0.150
    18.920   261.178     0.150
    19.016   263.317     0.150
    19.016   267.117     0.150
    20.778   281.817     0.150
    20.778   281.098     0.150
    20.818   283.317     0.150
    22.502   298.245     0.150
    22.554   300.518     0.150
    22.554   301.098     0.150
    24.619   322.002     0.150
    24.619   321.518     0.150
    24.619   321.718     0.150
    26.720   341.917     0.150
    26.720   342.117     0.150
    28.289   355.984     0.150
    35.255   415.449     0.150
    35.255   415.917     0.150
    37.343   435.888     0.150
    42.313   473.103     0.150
    42.313   473.218     0.150
    46.417   505.878     0.150
    49.214   529.117     0.150
    49.214   528.817     0.150
    49.214   529.718     0.150
    49.418   533.317     0.150
    50.377   538.388     0.150
    50.763   539.766     0.150
    59.995   606.449     0.150
    60.315   610.558     0.150
    70.609   676.472     0.150
    70.609   675.798     0.150
    72.465   687.228     0.150
    76.170   707.968     0.150
    76.173   708.397     0.150
    76.239   707.617     0.150
    79.627   727.924     0.150
    79.627   728.218     0.150
    89.186   776.150     0.150
    89.186   775.968     0.150
   145.538  1177.016     0.150
   146.961  1181.488     0.150
   147.706  1183.396     0.150
     0.306     6.369     0.150
     0.306    10.168     0.150
     0.415     8.369     0.150
     0.415    13.568     0.150
     1.152    21.168     0.150
     1.152    36.568     0.150
     1.152    36.168     0.150
     1.227    23.068     0.150
     1.227    39.869     0.150
     1.345    24.969     0.150
     1.345    42.869     0.150
     1.442    26.469     0.150
     1.442    46.770     0.150
     1.483    27.469     0.150
     1.483    48.168     0.150
     1.731    31.168     0.150
     1.731    32.168     0.150
     1.731    55.168     0.150
     2.070    62.168     0.150
     2.070    65.668     0.150
     2.425    40.369     0.150
     2.425    43.369     0.150
     2.425    75.969     0.150
     2.425    43.869     0.150
     2.425    70.270     0.150
     2.425    74.969     0.150
     2.465    45.168     0.150
     2.598    46.969     0.150
     2.598    74.068     0.150
     2.598    80.770     0.150
     2.598    42.270     0.150
     2.598    46.770     0.150
     2.725    44.770     0.150
     2.725    49.068     0.150
     2.725    77.469     0.150
     2.725    84.369     0.150
     2.725    44.668     0.150
     2.725    84.068     0.150
     2.720    44.568     0.150
     2.720    49.068     0.150
     2.720    76.168     0.150
     2.720    84.969     0.150
     2.720    49.369     0.150
     3.224    51.668     0.150
     3.224    57.469     0.150
     3.224    99.770     0.150
     3.194    50.912     0.150
     3.194    58.688     0.150
     3.194    99.188     0.150
     3.194    58.068     0.150
     3.194    99.469     0.150
     3.194   100.270     0.150
     3.194    50.719     0.150
     3.419    53.369     0.150
     3.419    60.869     0.150
     3.419    93.369     0.150
     3.419   105.568     0.150
     3.419    53.068     0.150
     3.419   106.770     0.150
     3.594    57.270     0.150
     3.594    65.369     0.150
     3.594   112.168     0.150
     3.594    66.270     0.150
     3.594   113.469     0.150
     3.777    58.869     0.150
     3.777    68.568     0.150
     3.777   115.869     0.150
     3.777   117.770     0.150
     3.777    68.969     0.150
     3.777   118.270     0.150
     3.912    60.869     0.150
     3.912    70.068     0.150
     3.912   104.969     0.150
     3.912   122.068     0.150
     4.162    65.068     0.150
     4.162    76.168     0.150
     4.162   130.369     0.150
     4.162    75.568     0.150
     4.162   130.068     0.150
     4.271    66.668     0.150
     4.271    76.869     0.150
     4.271   133.270     0.150
     4.311    65.068     0.150
     4.311    76.770     0.150
     4.311   115.270     0.150
     4.697    72.369     0.150
     4.697    84.369     0.150
     4.697   145.270     0.150
     5.163    79.369     0.150
     5.163   139.969     0.150
     5.163   161.168     0.150
     5.356    81.369     0.150
     5.442    81.568     0.150
     5.442    98.369     0.150
     5.442   168.369     0.150
     5.442    98.168     0.150
     5.463    82.809     0.150
     5.463    98.889     0.150
     5.463   173.369     0.150
     5.463    82.668     0.150
     6.862   100.969     0.150
     6.862   213.568     0.150
     7.041   103.369     0.150
     7.041   217.668     0.150
     7.041   181.668     0.150
     7.129   107.369     0.150
     7.129   221.869     0.150
     7.710   112.270     0.150
     7.710   238.270     0.150
     8.190   117.369     0.150
     8.450   122.568     0.150
     8.450   261.270     0.150
     8.997   133.168     0.150
     8.997   163.668     0.150
     8.997   279.068     0.150
    10.081   312.668     0.150
    10.233   317.668     0.150
    12.516   180.369     0.150
    13.442   191.068     0.150
    13.949   198.158     0.150
    13.949   198.145     0.150
    14.190   200.869     0.150
    14.190   359.969     0.150
    14.209   201.469     0.150
    14.450   205.270     0.150
    14.450   204.100     0.150
    14.924   211.668     0.150
    14.924   218.270     0.150
    14.924   379.770     0.150
    15.215   213.293     0.150
    15.969   224.619     0.150
    16.375   230.068     0.150
    16.476   237.068     0.150
    16.476   237.668     0.150
    17.351   245.568     0.150
    17.505   241.729     0.150
    17.820   247.068     0.150
    17.820   247.318     0.150
    17.820   563.244     0.150
    17.820   246.789     0.150
    17.977   250.418     0.150
    17.977   563.469     0.150
    17.977   247.600     0.150
    17.998   248.568     0.150
    18.382   255.068     0.150
    18.467   255.094     0.150
    18.467   581.172     0.150
    18.467   254.168     0.150
    19.118   266.469     0.150
    19.118   272.369     0.150
    19.118   275.568     0.150
    19.118   264.969     0.150
    19.118   262.219     0.150
    20.643   278.938     0.150
    20.643   278.568     0.150
    20.643   278.799     0.150
    20.749   281.379     0.150
    20.806   282.068     0.150
    20.806   282.619     0.150
    21.069   284.719     0.150
    21.173   282.668     0.150
    21.173   517.369     0.150
    21.408   287.270     0.150
    21.525   286.789     0.150
    21.786   292.100     0.150
    21.790   292.148     0.150
    22.198   296.789     0.150
    22.204   294.430     0.150
    22.440   300.168     0.150
    22.474   301.770     0.150
    22.474   544.668     0.150
    22.474   754.668     0.150
    22.577   300.281     0.150
    22.630   299.369     0.150
    22.630   299.020     0.150
    22.836   303.270     0.150
    22.917   303.049     0.150
    22.928   304.020     0.150
    22.923   305.338     0.150
    23.645   311.219     0.150
    23.926   315.449     0.150
    23.926   314.969     0.150
    24.052   316.188     0.150
    24.052   316.770     0.150
    24.184   317.049     0.150
    24.369   319.498     0.150
    24.811   322.568     0.150
    24.811   322.270     0.150
    24.745   323.162     0.150
    24.745   323.279     0.150
    24.745   321.369     0.150
    24.745   322.758     0.150
    24.982   326.318     0.150
    25.154   327.109     0.150
    25.523   330.529     0.150
    26.472   337.559     0.150
    26.695   342.369     0.150
    26.839   342.568     0.150
    26.839   341.639     0.150
    26.839   340.469     0.150
    26.839   341.168     0.150
    27.128   346.568     0.150
    28.336   355.488     0.150
    28.336   353.369     0.150
    28.336   641.969     0.150
    28.336   719.469     0.150
    28.336   355.189     0.150
    29.184   361.818     0.150
    29.496   365.148     0.150
    29.961   369.869     0.150
    30.064   369.168     0.150
    30.064   369.189     0.150
    30.175   372.469     0.150
    30.273   373.270     0.150
    30.524   374.969     0.150
    30.604   375.969     0.150
    30.781   375.969     0.150
    30.666   376.469     0.150
    30.682   374.244     0.150
    30.682   373.568     0.150
    30.746   376.369     0.150
    31.226   381.668     0.150
    31.248   381.869     0.150
    32.517   389.770     0.150
    33.529   398.869     0.150
    33.529   468.469     0.150
    35.036   413.270     0.150
    35.385   415.520     0.150
    35.385   416.770     0.150
    35.385   416.658     0.150
    35.728   418.469     0.150
    36.582   423.469     0.150
    37.379   433.270     0.150
    37.456   434.645     0.150
    37.456   432.668     0.150
    39.006   447.039     0.150
    39.006   446.594     0.150
    39.282   577.068     0.150
    40.352   455.168     0.150
    40.352   551.168     0.150
    40.352   581.168     0.150
    40.352   999.168     0.150
    42.314   472.744     0.150
    42.314   473.668     0.150
    42.314   473.289     0.150
    42.946   479.469     0.150
    42.946   480.129     0.150
    42.958   480.895     0.150
    42.958   477.568     0.150
    43.092   479.869     0.150
    43.347   482.770     0.150
    44.889   494.770     0.150
    44.889   597.668     0.150
    44.889   894.168     0.150
    44.889  1094.469     0.150
    45.021   595.379     0.150
    45.021  1090.828     0.150
    45.863   502.078     0.150
    46.038   504.148     0.150
    46.086   504.369     0.150
    46.488   507.818     0.150
    46.455   506.494     0.150
    46.455   507.969     0.150
    46.455   506.658     0.150
    46.455   507.270     0.150
    46.455   506.799     0.150
    46.771   509.939     0.150
    47.615   517.289     0.150
    48.008   520.389     0.150
    48.094   521.020     0.150
    48.094   520.559     0.150
    48.591   523.318     0.150
    48.856   526.029     0.150
    49.030   527.770     0.150
    49.035   527.969     0.150
    49.067   527.738     0.150
    49.067   527.469     0.150
    49.067   527.289     0.150
    49.694   532.629     0.150
    50.377   538.080     0.150
    50.409   537.578     0.150
    50.418   538.018     0.150
    50.418   538.189     0.150
    50.559   538.668     0.150
    50.564   538.078     0.150
    50.739   539.488     0.150
    50.889   541.094     0.150
    50.901   541.559     0.150
    50.853   542.469     0.150
    50.853   541.619     0.150
    50.888   540.770     0.150
    50.888   541.100     0.150
    51.054   542.619     0.150
    51.126   543.328     0.150
    51.500   545.469     0.150
    51.556   546.828     0.150
    51.536   548.068     0.150
    51.888   548.508     0.150
    51.945   549.828     0.150
    51.949   548.379     0.150
    51.903   550.715     0.150
    51.985   547.779     0.150
    52.257   552.383     0.150
    52.826   556.568     0.150
    52.921   557.068     0.150
    53.095   558.068     0.150
    53.108   557.770     0.150
    53.124   558.969     0.150
    53.136   558.568     0.150
    53.140   558.988     0.150
    53.671   562.498     0.150
    53.695   563.414     0.150
    53.695   562.270     0.150
    53.812   564.369     0.150
    53.922   564.469     0.150
    53.922   564.180     0.150
    53.956   565.068     0.150
    53.956   563.969     0.150
    54.070   626.969     0.150
    54.070  1240.969     0.150
    54.743   570.162     0.150
    55.135   573.168     0.150
    55.164   572.568     0.150
    55.275   573.770     0.150
    55.275   572.609     0.150
    55.411   575.199     0.150
    55.411   574.895     0.150
    55.612   576.660     0.150
    55.821   577.451     0.150
    56.250   581.068     0.150
    56.608   582.922     0.150
    56.973   586.953     0.150
    57.445   589.977     0.150
    57.485   588.969     0.150
    57.507   589.475     0.150
    57.769   592.084     0.150
    58.029   593.594     0.150
    58.116   590.672     0.150
    58.333   594.943     0.150
    59.169   601.680     0.150
    59.857   604.895     0.150
    59.857   604.770     0.150
    66.977   651.969     0.150
    69.603   669.068     0.150
    70.621   676.918     0.150
    70.621   676.689     0.150
    71.094   679.328     0.150
    71.858   683.969     0.150
    71.919   684.719     0.150
    72.518   687.068     0.150
    73.873   696.738     0.150
    74.089   697.168     0.150
    74.595   701.850     0.150
    74.793   700.859     0.150
    74.852   701.668     0.150
    74.970   701.020     0.150
    76.220   708.219     0.150
    77.162   715.469     0.150
    77.321   717.449     0.150
    77.984   719.758     0.150
    78.079   719.469     0.150
    79.057   724.119     0.150
    79.554   727.439     0.150
    79.614   729.168     0.150
    79.681   727.918     0.150
    80.269   730.244     0.150
    87.213   768.270     0.150
    89.248   776.119     0.150
    89.361   777.369     0.150
    89.986   779.668     0.150
    90.750   783.408     0.150
    93.276   795.793     0.150
   143.102  1172.844     0.150
   145.684  1177.123     0.150
   147.109  1181.666     0.150
   147.389  1182.588     0.150
   147.853  1183.547     0.150
   151.120  1192.418     0.150
     0.309     5.574     0.150
     0.309     9.775     0.150
     0.391     7.574     0.150
     0.391    13.375     0.150
     0.657    13.074     0.150
     0.657    21.875     0.150
     0.896    28.775     0.150
     1.227    23.174     0.150
     1.227    39.975     0.150
     1.321    24.475     0.150
     1.321    42.074     0.150
     1.321    44.574     0.150
     1.427    26.775     0.150
     1.427    45.875     0.150
     1.513    47.975     0.150
     1.711    31.574     0.150
     1.711    54.074     0.150
     2.458    75.674     0.150
     2.750    84.674     0.150
     3.244   100.174     0.150
     3.922   122.174     0.150
     5.454   167.674     0.150
     0.303     5.605     0.150
     0.303     9.805     0.150
     0.397     7.504     0.150
     0.397    13.406     0.150
     0.656    13.207     0.150
     0.656    22.105     0.150
     0.903    17.105     0.150
     0.903    29.707     0.150
     1.150    20.406     0.150
     1.150    36.105     0.150
     1.150    38.805     0.150
     1.233    22.207     0.150
     1.233    39.504     0.150
     1.328    24.105     0.150
     1.328    42.305     0.150
     1.433    26.105     0.150
     1.433    46.004     0.150
     1.476    27.805     0.150
     1.476    47.906     0.150
     1.520    28.805     0.150
     1.520    49.805     0.150
     1.718    30.504     0.150
     1.718    31.207     0.150
     1.718    54.504     0.150
     2.069    34.504     0.150
     2.069    37.504     0.150
     2.069    61.305     0.150
     2.069    64.805     0.150
     2.432    39.605     0.150
     2.432    42.906     0.150
     2.432    75.305     0.150
     2.465    40.105     0.150
     2.465    44.406     0.150
     2.465    70.605     0.150
     2.465    77.105     0.150
     2.603    79.707     0.150
     2.744    44.406     0.150
     2.744    48.906     0.150
     2.744    76.605     0.150
     2.744    84.305     0.150
     2.721    43.707     0.150
     2.721    48.605     0.150
     2.721    76.805     0.150
     2.721    84.305     0.150
     3.196    49.004     0.150
     3.196    58.207     0.150
     3.196    88.305     0.150
     3.196    99.906     0.150
     3.237    50.906     0.150
     3.237    57.605     0.150
     3.237    86.605     0.150
     3.237    99.105     0.150
     3.401   105.504     0.150
     3.606   111.207     0.150
     3.783    59.305     0.150
     3.783    68.004     0.150
     3.783   104.105     0.150
     3.783   118.707     0.150
     3.916    60.805     0.150
     3.916    70.105     0.150
     3.916   120.305     0.150
     4.157    74.605     0.150
     4.157   128.207     0.150
     4.278    77.805     0.150
     4.278   132.504     0.150
     4.286    64.105     0.150
     4.286    77.105     0.150
     4.286   113.707     0.150
     4.286   131.605     0.150
     4.703    72.605     0.150
     4.703    83.605     0.150
     4.703   123.605     0.150
     4.703   145.004     0.150
     5.175    78.504     0.150
     5.175   160.406     0.150
     5.336    96.805     0.150
     5.336   139.605     0.150
     5.336   167.004     0.150
     5.448    81.906     0.150
     5.448    98.406     0.150
     5.448   168.605     0.150
     6.865   123.707     0.150
     6.865   212.805     0.150
     7.035   125.504     0.150
     7.035   216.906     0.150
     7.135   221.406     0.150
     0.176     3.672     0.150
     0.176     6.078     0.150
     0.586    11.078     0.150
     0.586    19.477     0.150
     0.989    18.078     0.150
     0.989    31.273     0.150
     0.989    31.078     0.150
     1.087    20.273     0.150
     1.087    35.375     0.150
     1.384    24.977     0.150
     1.384    26.273     0.150
     1.384    44.172     0.150
     1.384    43.578     0.150
     1.514    27.672     0.150
     1.514    48.078     0.150
     1.514    50.375     0.150
     1.624    30.078     0.150
     1.624    52.273     0.150
     1.665    31.375     0.150
     1.665    54.273     0.150
     1.665    31.273     0.150
     1.910    33.672     0.150
     1.910    34.875     0.150
     1.910    60.875     0.150
     2.244    37.875     0.150
     2.244    39.977     0.150
     2.244    65.875     0.150
     2.244    70.078     0.150
     2.244    37.977     0.150
     2.244    40.875     0.150
     2.244    66.172     0.150
     2.242    37.672     0.150
     2.242    40.977     0.150
     2.242    70.273     0.150
     2.242    41.273     0.150
     2.242    70.578     0.150
     2.560    42.672     0.150
     2.560    46.578     0.150
     2.560    73.078     0.150
     2.560    79.172     0.150
     2.560    46.773     0.150
     2.560    74.078     0.150
     2.560    79.875     0.150
     2.636    43.273     0.150
     2.636    47.773     0.150
     2.636    74.273     0.150
     2.636    81.375     0.150
     2.636    43.078     0.150
     2.636    47.672     0.150
     2.755    85.172     0.150
     2.755    49.477     0.150
     2.755    84.375     0.150
     2.889    46.773     0.150
     2.889    52.172     0.150
     2.889    90.375     0.150
     3.045    49.172     0.150
     3.045    54.078     0.150
     3.045    84.273     0.150
     3.045    94.672     0.150
     3.045    49.273     0.150
     3.045    54.375     0.150
     3.045    83.078     0.150
     3.355    52.672     0.150
     3.355    59.773     0.150
     3.355   103.578     0.150
     3.355    61.375     0.150
     3.355    93.773     0.150
     3.355   102.977     0.150
     3.360    53.375     0.150
     3.360    59.922     0.150
     3.360   103.844     0.150
     3.360    53.273     0.150
     3.360    60.977     0.150
     3.360   104.477     0.150
     3.360   103.172     0.150
     3.413    61.375     0.150
     3.413   106.477     0.150
     3.413    60.477     0.150
     3.413   108.172     0.150
     3.734    58.477     0.150
     3.734    67.172     0.150
     3.734   115.773     0.150
     3.929    61.977     0.150
     3.929    71.773     0.150
     3.929   119.875     0.150
     3.929   123.273     0.150
     3.929    61.875     0.150
     3.929    71.875     0.150
     3.929   120.078     0.150
     4.340    78.578     0.150
     4.340   135.172     0.150
     4.340    79.078     0.150
     4.340   135.773     0.150
     4.354    65.875     0.150
     4.354    77.977     0.150
     4.354   115.672     0.150
     4.354   133.578     0.150
     4.354    66.078     0.150
     4.354   115.273     0.150
     4.354   133.375     0.150
     4.847    75.773     0.150
     4.847    86.578     0.150
     4.847   131.172     0.150
     4.847   149.977     0.150
     4.847    75.977     0.150
     4.847   130.773     0.150
     4.847   149.773     0.150
     5.264    79.375     0.150
     5.264    94.375     0.150
     5.264   162.273     0.150
     5.264    79.273     0.150
     5.264    93.875     0.150
     5.288    81.578     0.150
     5.288    95.375     0.150
     5.288   163.773     0.150
     5.288    81.773     0.150
     5.288    96.375     0.150
     5.288   140.773     0.150
     5.288   163.375     0.150
     5.515    82.773     0.150
     5.515    98.172     0.150
     5.515   169.672     0.150
     5.515    81.477     0.150
     5.515    97.977     0.150
     5.515   169.375     0.150
     5.514    85.078     0.150
     5.627    85.039     0.150
     5.627   102.242     0.150
     5.627   153.031     0.150
     5.627   177.031     0.150
     6.685    98.977     0.150
     6.685   207.578     0.150
     6.894   101.273     0.150
     6.894   213.273     0.150
     6.894   100.977     0.150
     6.894   123.078     0.150
     6.894   178.273     0.150
     7.537   109.172     0.150
     7.537   233.578     0.150
     9.107   164.773     0.150
     9.107   282.578     0.150
    13.573   193.078     0.150
    14.031   200.102     0.150
    14.031   433.836     0.150
    14.269   440.547     0.150
    15.115   381.203     0.150
    15.115   472.281     0.150
    17.918   563.352     0.150
    17.959   251.273     0.150
    17.959   249.227     0.150
    17.959   250.375     0.150
    18.487   255.672     0.150
    18.572   255.648     0.150
    18.572   580.594     0.150
    18.779   257.453     0.150
    18.779   583.750     0.150
    18.779   258.078     0.150
    20.474   277.195     0.150
    20.474   633.289     0.150
    22.653   301.055     0.150
    30.599   374.172     0.150
    30.599   433.172     0.150
    46.483   506.977     0.150
    59.684   602.930     0.150
    59.684   603.578     0.150
    76.299   709.266     0.150
    79.764   729.492     0.150
     0.164     3.520     0.150
     0.164     6.119     0.150
     0.571    10.820     0.150
     0.571    19.020     0.150
     0.640    13.020     0.150
     0.640    21.520     0.150
     0.988    17.721     0.150
     0.988    31.221     0.150
     1.385    25.221     0.150
     1.385    44.221     0.150
     1.498    27.520     0.150
     1.498    47.320     0.150
     1.614    29.520     0.150
     1.614    51.619     0.150
     1.896    33.520     0.150
     1.896    34.520     0.150
     1.896    60.320     0.150
     2.252    37.721     0.150
     2.252    39.721     0.150
     2.252    69.920     0.150
     2.239    37.320     0.150
     2.239    40.221     0.150
     2.239    64.920     0.150
     2.239    69.920     0.150
     2.578    41.920     0.150
     2.578    46.020     0.150
     2.578    71.920     0.150
     2.578    80.619     0.150
     2.633    43.221     0.150
     2.633    47.020     0.150
     2.633    74.619     0.150
     2.633    81.420     0.150
     3.058    48.020     0.150
     3.058    54.020     0.150
     3.058    93.619     0.150
     3.359    60.221     0.150
     3.359   103.619     0.150
     3.740    58.119     0.150
     3.740    65.619     0.150
     3.740    66.820     0.150
     3.740   116.020     0.150
     4.332    65.619     0.150
     4.332    77.520     0.150
     4.332   113.820     0.150
     4.332   133.820     0.150
     0.299     6.559     0.150
     0.588    10.961     0.150
     0.588    19.262     0.150
     0.880    17.262     0.150
     0.880    28.762     0.150
     0.943    17.262     0.150
     0.943    29.762     0.150
     1.487    27.160     0.150
     1.487    47.262     0.150
     1.789    30.160     0.150
     1.789    32.059     0.150
     1.789    55.359     0.150
     1.856    31.359     0.150
     1.856    32.660     0.150
     1.856    56.859     0.150
     1.840    31.262     0.150
     1.840    32.762     0.150
     1.840    57.859     0.150
     2.011    33.961     0.150
     2.011    36.160     0.150
     2.011    62.559     0.150
     2.269    37.461     0.150
     2.269    40.059     0.150
     2.269    70.762     0.150
     2.299    37.961     0.150
     2.299    41.262     0.150
     2.299    70.762     0.150
     2.649    43.059     0.150
     2.649    47.160     0.150
     2.649    81.859     0.150
     2.699    43.262     0.150
     2.699    83.660     0.150
     3.060    48.359     0.150
     3.060    93.762     0.150
     3.043    47.559     0.150
     3.043    94.059     0.150
     3.109    48.559     0.150
     3.332    51.859     0.150
     3.332    59.262     0.150
     3.332   102.059     0.150
     3.296    58.660     0.150
     3.296   102.859     0.150
     3.700    56.961     0.150
     3.700    66.160     0.150
     3.767    67.461     0.150
     3.767   117.461     0.150
     4.329    64.160     0.150
     4.329    78.160     0.150
     4.741    72.059     0.150
     4.741    85.762     0.150
     4.741   147.559     0.150
     4.864    72.762     0.150
     4.864   150.461     0.150
     5.661    85.059     0.150
     6.263   191.961     0.150
     6.281    92.359     0.150
     6.281   112.262     0.150
     6.281   192.262     0.150
     7.130   103.762     0.150
     7.874   113.559     0.150
     0.295     6.359     0.150
     0.295    11.559     0.150
     0.586    10.758     0.150
     0.586    19.059     0.150
     0.586    10.656     0.150
     0.586    17.559     0.150
     0.886    28.758     0.150
     0.886    28.859     0.150
     0.939    17.258     0.150
     0.939    30.258     0.150
     1.485    26.758     0.150
     1.485    47.758     0.150
     1.487    26.758     0.150
     1.487    45.758     0.150
     1.859    31.156     0.150
     1.859    32.457     0.150
     1.859    56.656     0.150
     1.859    55.457     0.150
     1.789    30.059     0.150
     1.789    29.957     0.150
     1.789    53.656     0.150
     1.834    31.059     0.150
     1.834    32.559     0.150
     2.008    35.957     0.150
     2.008    62.758     0.150
     2.102    38.957     0.150
     2.102    66.559     0.150
     2.307    37.859     0.150
     2.307    40.258     0.150
     2.307    69.957     0.150
     2.307    70.656     0.150
     2.264    37.059     0.150
     2.264    39.859     0.150
     2.264    70.559     0.150
     2.705    48.457     0.150
     2.705    83.258     0.150
     2.705    42.957     0.150
     2.705    47.457     0.150
     2.705    75.656     0.150
     2.705    82.957     0.150
     2.705    43.258     0.150
     2.648    47.859     0.150
     2.648    74.156     0.150
     2.648    82.758     0.150
     3.065    54.656     0.150
     3.065    94.957     0.150
     3.065    49.059     0.150
     3.065    95.758     0.150
     3.102    55.359     0.150
     3.102    96.156     0.150
     3.102    85.258     0.150
     3.102    94.457     0.150
     3.043    47.156     0.150
     3.043    54.559     0.150
     3.043    82.156     0.150
     3.043    94.156     0.150
     3.159    48.258     0.150
     3.159    55.656     0.150
     3.159    85.156     0.150
     3.159    97.258     0.150
     3.159    56.156     0.150
     3.333    51.559     0.150
     3.333    58.758     0.150
     3.333    92.457     0.150
     3.333   101.758     0.150
     3.296    50.656     0.150
     3.296    58.758     0.150
     3.296    88.957     0.150
     3.296   102.359     0.150
     3.703    57.258     0.150
     3.703    65.859     0.150
     3.703   113.457     0.150
     3.703    68.359     0.150
     3.703   112.957     0.150
     3.767    56.957     0.150
     3.767    67.258     0.150
     3.767   117.457     0.150
     3.767   115.656     0.150
     3.767    56.727     0.150
     4.320    63.957     0.150
     4.320    76.758     0.150
     4.320   113.656     0.150
     4.320   134.359     0.150
     4.320    75.156     0.150
     4.331    64.656     0.150
     4.331    77.559     0.150
     4.331   134.656     0.150
     4.739    71.258     0.150
     4.739    86.156     0.150
     4.739   148.359     0.150
     4.739    85.457     0.150
     4.866    72.457     0.150
     4.866    87.359     0.150
     4.866   150.656     0.150
     4.866   147.859     0.150
     5.163    76.359     0.150
     5.163    91.156     0.150
     5.163   132.059     0.150
     5.163   158.059     0.150
     5.163    75.457     0.150
     5.163    90.656     0.150
     5.664    84.957     0.150
     5.664   101.457     0.150
     5.664   175.457     0.150
     5.664    84.656     0.150
     5.664   145.758     0.150
     5.774    86.156     0.150
     5.774   179.258     0.150
     5.774    83.859     0.150
     5.774    84.316     0.150
     6.270   111.656     0.150
     6.270   193.059     0.150
     6.283    91.758     0.150
     6.283   112.957     0.150
     6.283   194.457     0.150
     6.283    91.359     0.150
     6.283   192.859     0.150
     6.500    94.359     0.150
     6.500   114.758     0.150
     6.500   167.258     0.150
     7.131   102.859     0.150
     7.131   179.758     0.150
     7.131   218.957     0.150
     7.874   112.957     0.150
     7.874   242.656     0.150
     7.908   111.359     0.150
     7.908   195.457     0.150
     7.908   244.957     0.150
     9.513   136.059     0.150
     9.513   237.258     0.150
     9.513   293.359     0.150
    13.882   192.156     0.150
    13.882   347.758     0.150
    13.882   192.629     0.150
    13.953   198.758     0.150
    14.299   201.059     0.150
    14.299   360.059     0.150
    14.319   200.559     0.150
    14.344   199.387     0.150
    14.344   445.066     0.150
    14.344   201.559     0.150
    14.344   200.168     0.150
    14.781   205.559     0.150
    14.781   462.934     0.150
    14.781   207.758     0.150
    15.436   221.559     0.150
    17.049   240.359     0.150
    17.656   553.781     0.150
    17.782   244.359     0.150
    17.782   249.656     0.150
    18.291   251.656     0.150
    18.347   252.156     0.150
    18.347   574.254     0.150
    18.347   252.457     0.150
    18.347   250.656     0.150
    18.524   254.156     0.150
    18.747   255.984     0.150
    18.747   257.957     0.150
    18.747   256.520     0.150
    18.832   256.359     0.150
    18.918   256.359     0.150
    18.918   593.609     0.150
    19.445   266.059     0.150
    19.445   274.656     0.150
    19.445   277.059     0.150
    20.179   271.156     0.150
    20.621   277.449     0.150
    20.678   277.859     0.150
    20.678   657.082     0.150
    22.559   299.059     0.150
    22.952   300.621     0.150
    22.952   569.473     0.150
    23.004   304.859     0.150
    23.004   303.086     0.150
    23.473   306.656     0.150
    24.029   314.258     0.150
    24.234   315.957     0.150
    24.522   319.059     0.150
    25.276   324.258     0.150
    28.612   353.477     0.150
    28.612   354.258     0.150
    30.225   369.656     0.150
    30.225   551.059     0.150
    30.457   371.020     0.150
    30.938   375.949     0.150
    33.682   396.258     0.150
    35.835   416.109     0.150
    36.733   424.359     0.150
    39.267   446.133     0.150
    39.267   574.859     0.150
    39.267   446.758     0.150
    40.592   458.938     0.150
    40.573   458.758     0.150
    40.573   553.859     0.150
    40.573   579.859     0.150
    42.413   472.156     0.150
    42.415   470.305     0.150
    42.415   471.656     0.150
    42.415   472.168     0.150
    43.317   481.059     0.150
    45.214  1092.359     0.150
    45.214   825.117     0.150
    45.214   826.387     0.150
    45.955   501.188     0.150
    46.410   504.758     0.150
    46.695   505.332     0.150
    46.695   506.457     0.150
    46.695   507.527     0.150
    46.695   508.059     0.150
    47.468   513.879     0.150
    47.570   514.527     0.150
    47.902   517.637     0.150
    47.918   517.379     0.150
    47.963   517.656     0.150
    48.300   519.848     0.150
    48.315   519.406     0.150
    48.405   520.816     0.150
    48.496   520.758     0.150
    48.469   521.309     0.150
    48.528   521.359     0.150
    48.528   521.109     0.150
    48.651   522.586     0.150
    48.642   520.566     0.150
    48.669   522.359     0.150
    48.723   522.758     0.150
    48.738   522.488     0.150
    48.702   522.199     0.150
    48.815   522.949     0.150
    49.882   531.078     0.150
    50.056   532.156     0.150
    50.056   532.559     0.150
    50.177   533.359     0.150
    50.199   533.098     0.150
    50.370   535.289     0.150
    50.318   535.812     0.150
    50.552   536.129     0.150
    50.592   536.469     0.150
    50.528   536.969     0.150
    50.625   538.453     0.150
    50.638   538.199     0.150
    50.668   538.539     0.150
    50.668   537.949     0.150
    50.690   538.539     0.150
    50.745   539.098     0.150
    50.910   539.457     0.150
    50.985   539.816     0.150
    51.007   540.180     0.150
    51.000   541.742     0.150
    51.051   539.938     0.150
    51.118   542.125     0.150
    51.213   542.258     0.150
    51.213   541.906     0.150
    51.213   543.359     0.150
    51.213   542.457     0.150
    51.306   542.309     0.150
    51.339   542.727     0.150
    51.350   542.668     0.150
    51.398   543.117     0.150
    51.419   543.188     0.150
    51.504   542.348     0.150
    51.458   545.559     0.150
    51.644   546.785     0.150
    51.707   546.316     0.150
    52.171   550.582     0.150
    52.391   551.270     0.150
    52.502   552.215     0.150
    52.749   554.156     0.150
    52.799   554.680     0.150
    52.979   555.898     0.150
    53.112   556.824     0.150
    53.112   556.059     0.150
    53.284   557.457     0.150
    53.397   558.027     0.150
    53.852   562.395     0.150
    53.931   562.906     0.150
    54.224   563.559     0.150
    54.224  1231.758     0.150
    54.224   563.758     0.150
    55.068   571.258     0.150
    55.068   570.359     0.150
    55.181   572.031     0.150
    55.451   573.656     0.150
    55.590   573.547     0.150
    55.590   573.082     0.150
    55.590   573.359     0.150
    55.733   574.496     0.150
    55.773   575.957     0.150
    55.815   576.645     0.150
    56.011   576.777     0.150
    56.164   578.770     0.150
    56.164   578.758     0.150
    56.164   578.324     0.150
    56.166   578.758     0.150
    56.454   581.141     0.150
    56.811   583.555     0.150
    56.998   585.383     0.150
    57.170   586.008     0.150
    57.635   588.699     0.150
    57.665   589.785     0.150
    57.688   589.867     0.150
    57.884   590.953     0.150
    57.886   589.727     0.150
    57.944   591.355     0.150
    58.038   591.059     0.150
    58.096   591.859     0.150
    58.294   594.086     0.150
    58.471   594.359     0.150
    58.483   593.859     0.150
    58.525   593.270     0.150
    58.553   594.258     0.150
    59.090   598.859     0.150
    59.373   599.332     0.150
    59.373   599.457     0.150
    59.578   600.938     0.150
    60.156   606.578     0.150
    60.585   608.316     0.150
    61.655   616.559     0.150
    69.906   670.039     0.150
    70.562   673.680     0.150
    70.722   675.137     0.150
    70.760   674.719     0.150
    70.762   674.930     0.150
    71.039   676.859     0.150
    71.099   676.918     0.150
    71.992   680.258     0.150
    72.714   686.297     0.150
    73.342   691.109     0.150
    73.569   691.668     0.150
    74.051   695.656     0.150
    74.279   695.246     0.150
    74.318   696.059     0.150
    75.005   700.918     0.150
    75.270   702.449     0.150
    75.293   702.047     0.150
    75.706   703.977     0.150
    75.719   704.547     0.150
    76.013   705.828     0.150
    76.078   706.488     0.150
    76.146   706.078     0.150
    76.253   707.156     0.150
    76.322   707.258     0.150
    76.386   708.199     0.150
    76.431   707.828     0.150
    76.445   708.777     0.150
    76.702   708.316     0.150
    77.444   712.648     0.150
    77.467   714.008     0.150
    77.481   715.246     0.150
    77.626   714.699     0.150
    77.717   715.336     0.150
    78.542   718.957     0.150
    78.542   719.398     0.150
    78.675   721.359     0.150
    78.713   720.656     0.150
    79.031   723.109     0.150
    79.164   722.066     0.150
    79.239   724.656     0.150
    79.536   725.020     0.150
    79.723   725.809     0.150
    79.723   727.027     0.150
    79.797   726.656     0.150
    79.944   728.258     0.150
    80.391   730.598     0.150
    80.551   731.848     0.150
    80.569   731.656     0.150
    80.680   730.770     0.150
    81.238   734.746     0.150
    81.351   735.539     0.150
    82.595   742.527     0.150
    82.811   743.246     0.150
    84.338   750.918     0.150
    86.695   763.758     0.150
    86.695   762.578     0.150
    89.570   775.598     0.150
    92.760   790.492     0.150
   146.216  1176.730     0.150
   147.929  1181.879     0.150
   148.389  1182.820     0.150
   151.036  1189.258     0.150
     0.431     9.535     0.150
     0.431    14.935     0.150
     0.489     9.435     0.150
     0.489    16.435     0.150
     0.512     9.635     0.150
     0.512    16.835     0.150
     1.081    19.035     0.150
     1.081    32.835     0.150
     1.081    36.935     0.150
     1.081    34.135     0.150
     1.299    22.734     0.150
     1.299    23.635     0.150
     1.299    40.234     0.150
     1.299    41.835     0.150
     1.408    25.835     0.150
     1.408    45.035     0.150
     1.410    26.635     0.150
     1.410    45.535     0.150
     1.410    46.835     0.150
     1.962    33.535     0.150
     1.962    35.335     0.150
     1.962    61.335     0.150
     1.962    33.335     0.150
     1.962    34.935     0.150
     2.351    39.135     0.150
     2.351    42.935     0.150
     2.351    67.935     0.150
     2.351    72.935     0.150
     2.351    40.635     0.150
     2.351    67.635     0.150
     2.351    71.335     0.150
     2.447    40.734     0.150
     2.447    44.335     0.150
     2.447    68.734     0.150
     2.447    74.734     0.150
     2.447    39.234     0.150
     2.447    42.734     0.150
     2.447    70.135     0.150
     2.447    74.535     0.150
     2.600    42.535     0.150
     2.600    46.734     0.150
     2.600    73.635     0.150
     2.600    80.135     0.150
     2.600    46.835     0.150
     2.600    74.635     0.150
     2.600    80.435     0.150
     2.687    43.835     0.150
     2.687    46.535     0.150
     2.687    48.535     0.150
     2.687    75.135     0.150
     2.687    81.835     0.150
     2.687    43.734     0.150
     2.687    76.035     0.150
     2.687    80.734     0.150
     3.063    48.778     0.150
     3.063    54.754     0.150
     3.063    85.129     0.150
     3.063    92.829     0.150
     3.063    54.535     0.150
     3.063    84.734     0.150
     3.063    93.935     0.150
     3.063    48.535     0.150
     3.063    54.035     0.150
     3.063    83.435     0.150
     3.063    93.035     0.150
     3.246    50.935     0.150
     3.246    57.035     0.150
     3.246    88.535     0.150
     3.246    99.535     0.150
     3.246    86.335     0.150
     3.246    99.234     0.150
     3.621    64.135     0.150
     3.621    98.035     0.150
     3.621   111.435     0.150
     3.621   111.935     0.150
     3.643    55.435     0.150
     3.643    64.935     0.150
     3.643    97.734     0.150
     3.643   112.035     0.150
     3.643    54.734     0.150
     3.643    62.234     0.150
     3.643    96.635     0.150
     3.643   111.635     0.150
     3.618    57.535     0.150
     3.618    65.035     0.150
     3.618    98.335     0.150
     3.618   109.135     0.150
     3.618   111.335     0.150
     4.008    60.935     0.150
     4.008    70.335     0.150
     4.008   106.835     0.150
     4.008   123.035     0.150
     4.008    61.234     0.150
     4.008    70.135     0.150
     4.008   122.935     0.150
     4.080    63.435     0.150
     4.080    73.935     0.150
     4.080   108.535     0.150
     4.080   127.035     0.150
     4.080    62.935     0.150
     4.080    71.035     0.150
     4.080   121.835     0.150
     4.340    77.535     0.150
     4.340   114.535     0.150
     4.340   134.234     0.150
     4.519    66.435     0.150
     4.519    81.734     0.150
     4.519   120.135     0.150
     4.519   139.435     0.150
     4.519    67.135     0.150
     4.519    82.335     0.150
     4.519   139.035     0.150
     4.534    71.035     0.150
     4.534    78.135     0.150
     4.534   122.835     0.150
     4.534   139.234     0.150
     4.534    71.335     0.150
     4.534    82.935     0.150
     4.534   124.135     0.150
     4.534   139.035     0.150
     4.970    75.734     0.150
     4.970    89.435     0.150
     4.970   151.335     0.150
     5.433    81.435     0.150
     5.531    81.635     0.150
     5.531    98.734     0.150
     5.531   143.335     0.150
     5.531   170.635     0.150
     5.531    81.435     0.150
     5.531    97.835     0.150
     5.522    82.895     0.150
     5.522    98.774     0.150
     5.522   147.295     0.150
     5.522   173.212     0.150
     5.522    82.335     0.150
     5.720    84.135     0.150
     5.720   101.635     0.150
     5.720   148.535     0.150
     5.720    83.335     0.150
     5.720   100.835     0.150
     6.702   206.835     0.150
     6.963   102.635     0.150
     6.963   177.035     0.150
     6.963   214.935     0.150
     6.963   127.635     0.150
     6.968   104.135     0.150
     6.968   176.935     0.150
     6.968   214.935     0.150
     7.210   104.435     0.150
     7.210   222.435     0.150
     7.210   104.135     0.150
     7.210   185.435     0.150
     8.576   154.734     0.150
     8.576   264.234     0.150
    10.223   316.135     0.150
    12.661   181.435     0.150
    13.254   189.135     0.150
    13.729   193.475     0.150
    13.729   192.936     0.150
    13.729   425.054     0.150
    13.729   195.035     0.150
    13.729   194.435     0.150
    14.515   447.403     0.150
    14.931   218.435     0.150
    15.426   482.585     0.150
    16.343   232.035     0.150
    17.413   239.935     0.150
    17.413   242.935     0.150
    17.641   246.335     0.150
    17.641   245.209     0.150
    17.641   556.172     0.150
    17.641   247.135     0.150
    17.641   245.955     0.150
    18.173   251.835     0.150
    18.258   251.812     0.150
    18.258   569.188     0.150
    18.689   256.035     0.150
    18.689   257.234     0.150
    18.689   256.745     0.150
    18.794   259.335     0.150
    20.609   277.254     0.150
    20.609   639.153     0.150
    20.609   277.135     0.150
    22.356   297.458     0.150
    22.408   298.335     0.150
    22.408   300.854     0.150
    24.897   321.734     0.150
    26.651   341.234     0.150
    26.651   340.835     0.150
    29.845   368.645     0.150
    42.096   470.935     0.150
    42.097   470.510     0.150
    42.097   470.865     0.150
    42.724   475.935     0.150
    46.228   503.863     0.150
    48.104   520.194     0.150
    48.126   520.055     0.150
    48.381   520.468     0.150
    48.706   524.234     0.150
    49.090   527.255     0.150
    49.090   526.885     0.150
    50.762   538.234     0.150
    51.910   548.425     0.150
    58.137   593.734     0.150
    65.879   648.035     0.150
    74.869   700.835     0.150
    76.395   710.234     0.150
    76.401   708.710     0.150
    76.404   709.064     0.150
    76.470   709.125     0.150
    79.858   727.815     0.150
    79.858   728.135     0.150
    80.301   728.839     0.150
   145.667  1176.514     0.150
     0.270     5.645     0.150
     0.270    10.043     0.150
     0.766    13.445     0.150
     0.766    24.145     0.150
     1.055    34.543     0.150
     1.526    27.543     0.150
     1.526    48.543     0.150
     1.708    30.543     0.150
     1.708    51.543     0.150
     1.708    53.645     0.150
     1.783    31.844     0.150
     1.783    56.246     0.150
     1.836    32.844     0.150
     1.919    35.145     0.150
     1.919    60.645     0.150
     1.986    33.945     0.150
     1.986    35.246     0.150
     1.986    62.445     0.150
     2.146    35.746     0.150
     2.146    37.445     0.150
     2.146    66.246     0.150
     2.685    47.645     0.150
     2.685    82.645     0.150
     2.921    90.945     0.150
     2.896    45.945     0.150
     2.896    51.543     0.150
     2.896    80.043     0.150
     2.896    89.543     0.150
     3.040    47.246     0.150
     3.040    53.445     0.150
     3.040    93.844     0.150
     3.158    49.543     0.150
     3.158    55.945     0.150
     3.158    86.344     0.150
     3.158    98.344     0.150
     3.391   105.645     0.150
     3.563    55.344     0.150
     3.563    64.043     0.150
     3.563   110.246     0.150
     3.641    57.344     0.150
     3.641    64.645     0.150
     3.641   114.043     0.150
     3.975    72.445     0.150
     3.975   122.543     0.150
     4.535    81.844     0.150
     4.535   140.645     0.150
     5.102    76.145     0.150
     5.102    91.945     0.150
     5.102   159.145     0.150
     5.177    79.746     0.150
     5.177    92.945     0.150
     5.177   139.043     0.150
     5.177   159.945     0.150
     5.480    97.645     0.150
     5.480   168.445     0.150
     5.669    85.344     0.150
     5.669   150.543     0.150
     5.669   176.145     0.150
     6.564    96.145     0.150
     6.564   116.645     0.150
     6.564   202.445     0.150
     0.145     3.297     0.150
     0.145     5.695     0.150
     0.573    10.797     0.150
     0.573    19.094     0.150
     0.659    22.695     0.150
     0.974    17.594     0.150
     0.974    30.391     0.150
     0.974    17.492     0.150
     0.974    30.594     0.150
     1.089    20.297     0.150
     1.089    21.594     0.150
     1.089    35.492     0.150
     1.400    24.797     0.150
     1.400    25.992     0.150
     1.400    44.195     0.150
     1.497    27.391     0.150
     1.497    47.297     0.150
     1.497    49.695     0.150
     1.621    28.891     0.150
     1.621    29.891     0.150
     1.621    51.297     0.150
     1.663    30.391     0.150
     1.663    53.094     0.150
     1.663    53.195     0.150
     1.706    30.594     0.150
     1.706    31.891     0.150
     1.706    55.094     0.150
     1.899    33.297     0.150
     1.899    34.391     0.150
     1.899    60.195     0.150
     2.245    37.492     0.150
     2.245    39.391     0.150
     2.245    69.594     0.150
     2.251    37.195     0.150
     2.251    40.891     0.150
     2.251    69.891     0.150
     2.581    42.594     0.150
     2.581    46.195     0.150
     2.581    79.594     0.150
     2.581    41.992     0.150
     2.581    73.594     0.150
     2.581    79.492     0.150
     2.645    42.891     0.150
     2.645    47.297     0.150
     2.645    75.297     0.150
     2.645    81.195     0.150
     2.771    49.992     0.150
     2.771    85.297     0.150
     2.771    49.094     0.150
     2.771    85.094     0.150
     2.900    46.297     0.150
     2.900    52.094     0.150
     2.900    81.695     0.150
     2.900    90.297     0.150
     3.055    48.797     0.150
     3.055    53.992     0.150
     3.055    93.797     0.150
     3.055    48.695     0.150
     3.055    53.492     0.150
     3.055    82.297     0.150
     3.055    94.391     0.150
     3.320    58.797     0.150
     3.320   102.797     0.150
     3.320    61.297     0.150
     3.320   102.297     0.150
     3.372    52.891     0.150
     3.372    60.492     0.150
     3.372   104.891     0.150
     3.372    60.297     0.150
     3.372   104.992     0.150
     3.422    60.297     0.150
     3.422   106.891     0.150
     3.422    59.992     0.150
     3.422   108.695     0.150
     3.730    67.094     0.150
     3.730   115.492     0.150
     4.090    63.891     0.150
     4.090    73.391     0.150
     4.090   127.195     0.150
     4.315    64.992     0.150
     4.315    77.297     0.150
     4.315   115.391     0.150
     4.315   132.797     0.150
     4.315    65.094     0.150
     4.315    76.492     0.150
     4.315   115.492     0.150
     4.315   132.695     0.150
     4.343    66.891     0.150
     4.343    77.492     0.150
     4.343   134.992     0.150
     4.343    77.391     0.150
     4.343   134.797     0.150
     4.865    74.992     0.150
     4.865    87.391     0.150
     4.865   130.297     0.150
     4.865   150.492     0.150
     4.865    75.891     0.150
     4.865    88.594     0.150
     4.865   131.094     0.150
     4.865   150.195     0.150
     5.261    78.695     0.150
     5.261    94.297     0.150
     5.261   163.992     0.150
     5.314    81.297     0.150
     5.314   140.797     0.150
     5.314    81.492     0.150
     5.524    82.297     0.150
     5.524    98.094     0.150
     5.524    82.094     0.150
     5.524    97.797     0.150
     5.606    84.312     0.150
     5.606   176.414     0.150
     6.680    98.492     0.150
     6.680   206.492     0.150
     6.874   100.492     0.150
     6.874   175.297     0.150
     6.874   212.391     0.150
     6.874   212.195     0.150
    14.064   200.047     0.150
    17.981   250.891     0.150
    22.687   302.023     0.150
     0.282     6.316     0.150
     0.282    11.117     0.150
     0.597    10.719     0.150
     0.597    19.020     0.150
     0.927    16.918     0.150
     0.927    29.918     0.150
     1.778    30.117     0.150
     1.778    31.816     0.150
     1.778    52.816     0.150
     1.822    30.816     0.150
     1.822    32.418     0.150
     1.872    31.219     0.150
     1.872    32.918     0.150
     1.872    53.719     0.150
     1.872    57.617     0.150
     1.995    33.219     0.150
     1.995    35.617     0.150
     1.995    57.617     0.150
     1.995    62.617     0.150
     2.040    37.219     0.150
     2.040    64.418     0.150
     2.090    34.617     0.150
     2.090    38.418     0.150
     2.090    60.316     0.150
     2.090    66.520     0.150
     2.252    36.816     0.150
     2.252    39.719     0.150
     2.252    70.316     0.150
     2.317    37.418     0.150
     2.317    40.719     0.150
     2.317    69.918     0.150
     2.317    71.316     0.150
     2.636    47.617     0.150
     2.636    73.020     0.150
     2.636    81.918     0.150
     2.717    43.117     0.150
     2.717    47.719     0.150
     2.717    83.219     0.150
     3.030    47.020     0.150
     3.030    54.219     0.150
     3.030    82.219     0.150
     3.030    93.719     0.150
     3.077    54.719     0.150
     3.077    94.918     0.150
     3.106    95.316     0.150
     3.147    98.117     0.150
     3.284    50.418     0.150
     3.284    58.117     0.150
     3.284    88.816     0.150
     3.284   101.020     0.150
     3.346    51.719     0.150
     3.346    58.520     0.150
     3.346    60.117     0.150
     3.346    89.219     0.150
     3.346   102.520     0.150
     3.715   114.418     0.150
     3.755    57.617     0.150
     3.755    67.117     0.150
     3.755   100.117     0.150
     3.755   115.520     0.150
     4.317    76.316     0.150
     4.317   111.918     0.150
     4.317   129.020     0.150
     4.317   133.117     0.150
     4.319    65.418     0.150
     4.319    77.719     0.150
     4.319   114.117     0.150
     4.319   128.020     0.150
     4.319   133.816     0.150
     4.727    85.020     0.150
     4.727   146.617     0.150
     5.175   132.219     0.150
     5.175   159.520     0.150
     5.235    78.719     0.150
     5.235    93.020     0.150
     5.235   135.918     0.150
     5.235   160.816     0.150
     5.654    85.020     0.150
     5.654   146.418     0.150
     5.654   175.219     0.150
     6.295    92.117     0.150
     6.295   112.719     0.150
     6.295   193.418     0.150
     6.511    94.719     0.150
     6.511   116.219     0.150
     6.511   164.117     0.150
     6.511   199.918     0.150
     7.144   220.316     0.150
     7.669   111.816     0.150
     7.669   194.219     0.150
     7.669   238.020     0.150
     0.158     3.309     0.150
     0.158     6.008     0.150
     0.570    10.707     0.150
     0.570    19.008     0.150
     0.647    22.508     0.150
     0.984    17.605     0.150
     0.984    18.207     0.150
     0.984    30.508     0.150
     1.082    20.207     0.150
     1.082    35.105     0.150
     1.082    38.105     0.150
     1.389    24.605     0.150
     1.389    25.906     0.150
     1.389    44.207     0.150
     1.496    27.309     0.150
     1.496    47.207     0.150
     1.657    30.406     0.150
     1.657    52.605     0.150
     2.251    37.605     0.150
     2.251    39.508     0.150
     2.251    64.906     0.150
     2.251    69.508     0.150
     2.242    37.605     0.150
     2.242    40.605     0.150
     2.242    65.508     0.150
     2.242    69.508     0.150
     2.580    42.309     0.150
     2.580    46.008     0.150
     2.580    71.707     0.150
     2.580    76.008     0.150
     2.580    79.605     0.150
     2.636    42.508     0.150
     2.636    46.809     0.150
     2.636    48.105     0.150
     2.636    74.207     0.150
     2.636    80.906     0.150
     2.760    50.105     0.150
     2.760    86.207     0.150
     2.890    46.309     0.150
     2.890    51.605     0.150
     2.890    89.105     0.150
     3.058    48.809     0.150
     3.058    53.605     0.150
     3.058    94.309     0.150
     3.333   102.809     0.150
     3.362    52.707     0.150
     3.362    60.508     0.150
     3.362    92.207     0.150
     3.362   103.809     0.150
     3.426    54.309     0.150
     3.426    61.906     0.150
     3.426   106.605     0.150
     3.737    58.105     0.150
     3.737    66.508     0.150
     3.737   100.809     0.150
     3.737   115.309     0.150
     3.936    61.707     0.150
     3.936    70.707     0.150
     3.936    71.707     0.150
     3.936   104.906     0.150
     3.936   119.207     0.150
     3.936   121.809     0.150
     4.096    75.207     0.150
     4.096   110.008     0.150
     4.096   127.508     0.150
     4.325    65.406     0.150
     4.325    77.906     0.150
     4.325   114.605     0.150
     4.325   133.207     0.150
     4.336    67.508     0.150
     4.336    78.508     0.150
     4.336   114.707     0.150
     4.336   134.605     0.150
     4.854    75.008     0.150
     4.854    86.105     0.150
     4.854   130.406     0.150
     4.854   149.906     0.150
     5.268    78.906     0.150
     5.268    94.207     0.150
     5.268   161.906     0.150
     5.302    81.508     0.150
     5.302   162.707     0.150
     5.527    82.309     0.150
     5.527    98.105     0.150
     5.527   169.906     0.150
     6.688    99.309     0.150
     6.688   120.707     0.150
     6.688   207.309     0.150
     6.885   101.008     0.150
     6.885   123.809     0.150
     6.885   212.809     0.150
     7.287   225.605     0.150
     0.151     3.203     0.150
     0.151     5.203     0.150
     0.571    10.703     0.150
     0.571    19.102     0.150
     0.654    22.301     0.150
     0.979    17.500     0.150
     0.979    30.801     0.150
     1.086    20.703     0.150
     1.086    36.102     0.150
     1.086    38.301     0.150
     1.394    24.902     0.150
     1.394    26.102     0.150
     1.394    44.703     0.150
     1.496    27.402     0.150
     1.496    47.801     0.150
     1.660    30.602     0.150
     1.660    53.102     0.150
     1.702    31.902     0.150
     1.702    54.402     0.150
     2.248    37.500     0.150
     2.248    39.703     0.150
     2.248    40.902     0.150
     2.248    69.602     0.150
     2.246    40.402     0.150
     2.246    70.301     0.150
     2.581    42.602     0.150
     2.581    46.102     0.150
     2.581    75.703     0.150
     2.581    79.402     0.150
     2.641    42.801     0.150
     2.641    47.402     0.150
     2.641    75.102     0.150
     2.641    81.801     0.150
     2.765    76.801     0.150
     2.765    86.703     0.150
     2.895    46.402     0.150
     2.895    52.301     0.150
     2.895    90.402     0.150
     3.057    49.000     0.150
     3.057    54.203     0.150
     3.057    94.203     0.150
     3.326   103.203     0.150
     3.367    52.902     0.150
     3.367    60.203     0.150
     3.367   103.902     0.150
     3.424    61.801     0.150
     3.424   106.500     0.150
     3.733    58.402     0.150
     3.733    65.301     0.150
     3.733    66.801     0.150
     3.733   115.801     0.150
     3.942    60.203     0.150
     3.942    70.801     0.150
     3.942   122.000     0.150
     4.094    73.102     0.150
     4.094    75.102     0.150
     4.094   126.102     0.150
     4.320    65.402     0.150
     4.320    77.402     0.150
     4.320   114.500     0.150
     4.320   133.102     0.150
     4.340    77.801     0.150
     4.340   135.602     0.150
     4.860    74.602     0.150
     4.860    87.203     0.150
     4.860   150.301     0.150
     5.264    79.402     0.150
     5.264    93.801     0.150
     5.264   161.902     0.150
     5.308    80.902     0.150
     5.308    95.000     0.150
     5.308   164.102     0.150
     5.526    82.203     0.150
     5.526    98.500     0.150
     5.526   169.902     0.150
     6.580   203.203     0.150
     6.684    98.801     0.150
     6.684   119.902     0.150
     6.684   206.301     0.150
     6.880   100.902     0.150
     6.880   124.301     0.150
     6.880   212.703     0.150
     7.533   231.500     0.150
     8.275   256.000     0.150
     0.276     5.943     0.150
     0.276     9.344     0.150
     0.411     7.744     0.150
     0.411    13.244     0.150
     0.705    13.543     0.150
     0.705    22.244     0.150
     0.729    14.043     0.150
     0.729    25.344     0.150
     0.768    15.145     0.150
     0.768    25.443     0.150
     0.875    16.645     0.150
     0.875    28.344     0.150
     1.288    42.145     0.150
     1.431    26.844     0.150
     1.431    45.145     0.150
     1.665    30.344     0.150
     1.665    52.043     0.150
     1.684    31.344     0.150
     1.684    54.043     0.150
     2.059    36.543     0.150
     2.059    37.543     0.150
     2.059    62.543     0.150
     2.105    66.344     0.150
     2.295    39.543     0.150
     2.295    41.543     0.150
     2.295    67.943     0.150
     2.295    71.645     0.150
     2.742    48.943     0.150
     2.742    84.844     0.150
     2.789    49.744     0.150
     2.789    85.543     0.150
     0.310     6.098     0.150
     0.310    10.297     0.150
     0.409     8.797     0.150
     0.409    15.197     0.150
     0.493     9.396     0.150
     0.493    16.498     0.150
     0.740    13.598     0.150
     0.740    24.498     0.150
     0.986    18.098     0.150
     0.986    30.498     0.150
     1.184    21.797     0.150
     1.184    38.396     0.150
     1.417    26.396     0.150
     1.417    44.697     0.150
     1.671    30.396     0.150
     1.671    52.697     0.150
     1.735    31.598     0.150
     1.735    55.098     0.150
     1.771    32.396     0.150
     2.045    36.998     0.150
     2.045    64.697     0.150
     2.156    38.598     0.150
     2.156    67.297     0.150
     2.304    41.998     0.150
     2.304    72.598     0.150
     2.692    43.896     0.150
     2.692    48.498     0.150
     2.692    82.998     0.150
     2.939    52.498     0.150
     2.939    90.297     0.150
     0.361     7.844     0.150
     0.361    13.844     0.150
     0.719    13.039     0.150
     0.719    22.742     0.150
     0.964    17.945     0.150
     0.964    31.445     0.150
     0.964    32.742     0.150
     1.457    26.641     0.150
     1.457    46.641     0.150
     1.706    29.445     0.150
     1.706    30.844     0.150
     1.874    31.141     0.150
     1.874    57.945     0.150
     2.001    35.742     0.150
     2.001    62.242     0.150
     2.040    37.641     0.150
     2.040    64.344     0.150
     2.069    60.641     0.150
     2.069    65.344     0.150
     2.201    36.141     0.150
     2.201    39.344     0.150
     2.201    40.242     0.150
     2.201    61.539     0.150
     2.201    68.344     0.150
     2.290    37.539     0.150
     2.290    40.844     0.150
     2.290    71.945     0.150
     2.591    40.641     0.150
     2.591    78.945     0.150
     2.591    81.641     0.150
     2.664    42.141     0.150
     2.664    47.344     0.150
     2.664    81.539     0.150
     2.980    53.344     0.150
     2.980    80.844     0.150
     2.980    93.242     0.150
     3.033    94.039     0.150
     3.065    92.641     0.150
     3.065    95.141     0.150
     3.228    58.141     0.150
     3.228   100.641     0.150
     3.303    59.039     0.150
     3.303   101.641     0.150
     3.380    51.641     0.150
     3.380    59.844     0.150
     3.380   103.641     0.150
     3.719    66.242     0.150
     3.719   114.141     0.150
     3.690   114.242     0.150
     4.227    62.141     0.150
     4.227    75.742     0.150
     4.227   127.242     0.150
     4.227   131.141     0.150
     4.514    66.344     0.150
     4.514    80.141     0.150
     4.514   139.141     0.150
     4.703    70.344     0.150
     4.703    84.242     0.150
     4.703   145.344     0.150
     4.903    71.344     0.150
     4.903    86.844     0.150
     4.903   149.945     0.150
     5.134   157.641     0.150
     5.137    76.344     0.150
     5.137    92.539     0.150
     5.137   159.344     0.150
     5.523    80.844     0.150
     5.523    82.945     0.150
     5.523    99.141     0.150
     5.523   141.844     0.150
     5.523   170.844     0.150
     6.334   113.039     0.150
     6.334   195.242     0.150
     6.627   203.641     0.150
     7.571   234.344     0.150
     7.952   244.742     0.150
     8.926   276.141     0.150
     9.743   299.945     0.150
     0.343     6.598     0.150
     0.343    11.195     0.150
     0.503     9.797     0.150
     0.503    17.098     0.150
     0.939    18.398     0.150
     0.939    31.797     0.150
     1.162    20.797     0.150
     1.162    36.598     0.150
     1.211    21.695     0.150
     1.211    38.898     0.150
     1.211    22.695     0.150
     1.429    26.496     0.150
     1.429    46.098     0.150
     1.487    27.695     0.150
     1.487    47.898     0.150
     1.524    28.297     0.150
     1.524    48.496     0.150
     1.524    28.898     0.150
     1.524    49.496     0.150
     1.550    28.496     0.150
     1.550    50.195     0.150
     2.078    35.695     0.150
     2.078    38.195     0.150
     2.078    61.398     0.150
     2.078    65.398     0.150
     2.393    38.996     0.150
     2.393    41.898     0.150
     2.393    73.996     0.150
     2.470    40.297     0.150
     2.470    43.598     0.150
     2.470    75.195     0.150
     2.470    40.695     0.150
     2.470    45.398     0.150
     2.470    70.695     0.150
     2.470    76.797     0.150
     2.645    46.195     0.150
     2.645    76.496     0.150
     2.645    81.297     0.150
     2.645    47.297     0.150
     2.645    73.598     0.150
     2.645    81.098     0.150
     2.581    45.398     0.150
     2.581    79.297     0.150
     2.581    42.996     0.150
     2.581    47.398     0.150
     2.581    73.695     0.150
     2.581    79.797     0.150
     2.721    44.398     0.150
     2.721    46.996     0.150
     2.721    49.098     0.150
     2.721    76.898     0.150
     2.721    84.297     0.150
     3.168    50.398     0.150
     3.168    97.996     0.150
     3.168    49.996     0.150
     3.168    57.598     0.150
     3.168    86.695     0.150
     3.190    49.996     0.150
     3.190    57.297     0.150
     3.190    97.898     0.150
     3.190    50.098     0.150
     3.190    57.496     0.150
     3.190    87.797     0.150
     3.190    98.496     0.150
     3.503    53.398     0.150
     3.503    62.598     0.150
     3.503   109.598     0.150
     3.503    62.996     0.150
     3.503    94.496     0.150
     3.503   108.496     0.150
     3.755    58.695     0.150
     3.755    66.695     0.150
     3.755   114.598     0.150
     3.755    59.898     0.150
     3.755    67.195     0.150
     3.755   103.098     0.150
     3.755   113.996     0.150
     3.755   116.598     0.150
     3.894    70.598     0.150
     3.894   121.695     0.150
     3.894    61.098     0.150
     3.894   103.297     0.150
     3.894   119.898     0.150
     4.185    76.598     0.150
     4.185   130.398     0.150
     4.424    65.898     0.150
     4.424    78.398     0.150
     4.424   116.297     0.150
     4.424   136.297     0.150
     4.424    66.195     0.150
     4.424    79.996     0.150
     4.424   116.098     0.150
     4.424   136.398     0.150
     4.672    73.598     0.150
     4.672    84.996     0.150
     4.672   143.195     0.150
     4.672    72.898     0.150
     4.672    80.996     0.150
     4.672   126.496     0.150
     4.672   144.195     0.150
     5.115    78.996     0.150
     5.115   134.398     0.150
     5.420    80.996     0.150
     5.420    97.496     0.150
     5.420   166.996     0.150
     5.548    83.496     0.150
     5.548   148.469     0.150
     5.548   175.332     0.150
     5.642    83.797     0.150
     5.642   101.195     0.150
     5.642   144.496     0.150
     5.642   174.195     0.150
     6.847   100.996     0.150
     6.847   212.695     0.150
     7.069   102.797     0.150
     7.069   217.996     0.150
    10.236   317.297     0.150
    17.784   249.008     0.150
    18.320   254.598     0.150
    18.405   254.613     0.150
    22.498   301.809     0.150
    49.013   526.465     0.150
    76.335   708.398     0.150
    79.795   727.996     0.150
     0.219     4.693     0.150
     0.219     7.795     0.150
     0.342     6.594     0.150
     0.342    11.395     0.150
     0.495     9.395     0.150
     0.495    16.193     0.150
     0.594    11.295     0.150
     0.594    19.895     0.150
     0.736    14.594     0.150
     0.736    24.994     0.150
     1.038    19.795     0.150
     1.038    34.494     0.150
     1.283    23.795     0.150
     1.283    41.094     0.150
     1.339    24.094     0.150
     1.339    42.494     0.150
     1.320    42.295     0.150
     1.348    24.594     0.150
     1.348    44.193     0.150
     2.279    41.395     0.150
     2.279    70.494     0.150
     2.409    43.693     0.150
     2.409    75.594     0.150
     2.534    41.494     0.150
     2.534    45.895     0.150
     2.534    78.795     0.150
     2.595    41.693     0.150
     2.595    47.193     0.150
     2.595    80.693     0.150
     3.572    62.395     0.150
     3.572   109.094     0.150
     0.212     4.684     0.150
     0.212     8.086     0.150
     0.534    10.184     0.150
     0.534    18.184     0.150
     1.041    18.785     0.150
     1.041    32.785     0.150
     1.031    19.586     0.150
     1.031    34.484     0.150
     1.333    23.785     0.150
     1.333    24.586     0.150
     1.333    42.484     0.150
     1.333    43.586     0.150
     1.567    28.484     0.150
     1.567    50.285     0.150
     1.608    30.484     0.150
     1.608    51.984     0.150
     1.646    28.883     0.150
     1.646    30.984     0.150
     1.646    52.285     0.150
     2.187    39.484     0.150
     2.187    62.285     0.150
     2.187    69.184     0.150
     2.610    47.184     0.150
     2.610    73.184     0.150
     2.610    80.684     0.150
     2.581    47.184     0.150
     2.581    72.383     0.150
     2.704    49.184     0.150
     2.704    84.086     0.150
     2.835    78.086     0.150
     2.835    88.883     0.150
     3.100    48.684     0.150
     3.100    55.184     0.150
     3.100    83.484     0.150
     3.100    96.086     0.150
     3.306    51.285     0.150
     3.306    59.586     0.150
     3.469    63.184     0.150
     3.469   108.086     0.150
     3.378    52.285     0.150
     3.378    60.984     0.150
     3.378   105.086     0.150
     3.790    58.184     0.150
     3.790    68.184     0.150
     3.790   117.484     0.150
     3.879    59.883     0.150
     3.879    69.883     0.150
     3.879   102.484     0.150
     3.879   121.484     0.150
     4.284    65.883     0.150
     4.284    77.285     0.150
     4.284   114.883     0.150
     4.284   133.785     0.150
     4.344    64.484     0.150
     4.344    78.586     0.150
     4.344   114.086     0.150
     4.344   134.484     0.150
     4.797    74.086     0.150
     4.797    86.684     0.150
     4.797   126.586     0.150
     4.797   148.984     0.150
     5.246    79.883     0.150
     5.246    95.484     0.150
     5.246   137.586     0.150
     5.320    95.984     0.150
     5.320   165.285     0.150
     5.570    82.684     0.150
     5.570   100.086     0.150
     5.570   144.086     0.150
     5.570   172.086     0.150
     5.577    83.105     0.150
     5.577   175.273     0.150
     6.613   205.086     0.150
     6.741   100.586     0.150
     6.741   121.684     0.150
     6.741   208.684     0.150
     6.942   101.383     0.150
     6.942   124.285     0.150
     6.942   214.184     0.150
     7.231   131.684     0.150
     7.231   225.184     0.150
     7.592   234.184     0.150
     8.335   257.684     0.150
    14.002   432.883     0.150
    20.525   276.504     0.150
    48.942   525.262     0.150
    76.278   707.484     0.150
     0.120     4.320     0.150
     0.120     7.320     0.150
     0.675    12.320     0.150
     0.675    22.119     0.150
     0.884    15.520     0.150
     0.884    27.520     0.150
     1.489    25.820     0.150
     1.489    26.619     0.150
     1.489    45.820     0.150
     1.724    30.219     0.150
     1.724    31.820     0.150
     1.724    54.219     0.150
     1.767    31.520     0.150
     1.767    31.820     0.150
     1.767    54.420     0.150
     2.141    34.820     0.150
     2.141    36.920     0.150
     2.141    60.420     0.150
     2.141    65.420     0.150
     2.141    36.719     0.150
     2.141    62.119     0.150
     2.349    37.520     0.150
     2.349    41.420     0.150
     2.349    66.119     0.150
     2.349    72.420     0.150
     2.488    40.119     0.150
     2.488    43.719     0.150
     2.488    70.920     0.150
     2.488    75.719     0.150
     2.488    76.119     0.150
     2.742    43.219     0.150
     2.742    48.420     0.150
     2.742    75.920     0.150
     2.742    84.320     0.150
     2.860    45.219     0.150
     2.860    52.420     0.150
     2.860    87.020     0.150
     2.860    43.820     0.150
     2.860    51.320     0.150
     2.952    46.219     0.150
     2.952    52.119     0.150
     2.952    80.119     0.150
     2.952    90.119     0.150
     2.996    46.719     0.150
     2.996    52.420     0.150
     2.996    82.020     0.150
     2.996    91.619     0.150
     3.319    58.719     0.150
     3.319   102.320     0.150
     3.319    59.820     0.150
     3.319   102.920     0.150
     3.289    50.219     0.150
     3.289    58.020     0.150
     3.289    60.320     0.150
     3.289    88.719     0.150
     3.289   100.820     0.150
     3.289    49.820     0.150
     3.289    57.719     0.150
     3.289   100.520     0.150
     3.466    52.820     0.150
     3.466    60.920     0.150
     3.466   105.920     0.150
     3.466    61.820     0.150
     3.466   104.920     0.150
     3.628    55.320     0.150
     3.628    64.320     0.150
     3.628   111.020     0.150
     3.987    60.820     0.150
     3.987    71.119     0.150
     3.987   105.520     0.150
     3.987   123.520     0.150
     4.033    60.820     0.150
     4.033    70.920     0.150
     4.033   123.320     0.150
     4.033    60.719     0.150
     4.033    71.619     0.150
     4.033   122.020     0.150
     4.345    64.020     0.150
     4.345    77.719     0.150
     4.345   133.619     0.150
     4.345    76.320     0.150
     4.345   132.320     0.150
     4.445    67.420     0.150
     4.445    80.219     0.150
     4.445   137.719     0.150
     4.445   137.420     0.150
     4.950    74.520     0.150
     4.950    88.219     0.150
     4.950   133.420     0.150
     4.950   152.020     0.150
     4.950    74.219     0.150
     4.950    87.020     0.150
     4.950   131.420     0.150
     5.159    75.920     0.150
     5.159    92.219     0.150
     5.159   159.320     0.150
     5.159    89.520     0.150
     5.420    79.219     0.150
     5.420    96.020     0.150
     5.420   165.719     0.150
     5.420    95.520     0.150
     5.385    80.820     0.150
     5.385   166.820     0.150
     5.385    96.119     0.150
     5.385   141.520     0.150
     5.583    82.439     0.150
     5.583    82.719     0.150
     5.702    84.480     0.150
     5.702   101.285     0.150
     5.702   152.160     0.150
     5.702   179.719     0.150
     6.482    94.820     0.150
     6.482   199.820     0.150
     6.580    95.920     0.150
     6.580   203.020     0.150
     6.580    96.119     0.150
     6.792    97.920     0.150
     6.792   120.719     0.150
     6.792   173.020     0.150
     6.792   208.520     0.150
     6.792   174.920     0.150
     7.430   107.619     0.150
     7.430   134.119     0.150
     7.430   230.619     0.150
     8.083   114.240     0.150
     8.790   271.320     0.150
     9.813   303.619     0.150
     9.960   141.119     0.150
     9.960   306.219     0.150
    11.098   158.420     0.150
    12.041   168.420     0.150
    12.041   301.520     0.150
    13.671   194.820     0.150
    14.110   196.299     0.150
    14.110   197.752     0.150
    14.110   200.119     0.150
    14.167   195.988     0.150
    14.167   436.238     0.150
    14.167   196.740     0.150
    14.167   352.619     0.150
    14.298   200.730     0.150
    15.030   209.670     0.150
    15.030   209.119     0.150
    15.190   214.219     0.150
    15.190   220.820     0.150
    16.748   238.219     0.150
    16.748   419.719     0.150
    17.586   246.719     0.150
    17.852   245.619     0.150
    17.852   247.857     0.150
    17.852   245.240     0.150
    18.059   246.830     0.150
    18.059   248.396     0.150
    18.059   570.281     0.150
    18.237   250.689     0.150
    18.575   254.619     0.150
    18.660   254.607     0.150
    18.766   255.670     0.150
    18.766   255.490     0.150
    18.766   258.719     0.150
    19.690   269.219     0.150
    20.394   274.738     0.150
    20.394   494.564     0.150
    20.394   274.240     0.150
    20.394   274.520     0.150
    20.781   279.809     0.150
    20.781   281.021     0.150
    22.636   301.119     0.150
    22.636   547.219     0.150
    22.728   298.885     0.150
    22.728   531.617     0.150
    22.780   299.699     0.150
    22.780   300.219     0.150
    23.072   303.539     0.150
    23.630   310.160     0.150
    23.773   312.289     0.150
    23.773   309.500     0.150
    23.773   312.420     0.150
    24.528   319.170     0.150
    24.528   318.520     0.150
    24.987   323.613     0.150
    24.987   321.939     0.150
    24.987   323.920     0.150
    25.187   323.119     0.150
    25.619   328.650     0.150
    26.600   336.539     0.150
    27.068   340.680     0.150
    27.068   340.410     0.150
    27.303   344.020     0.150
    28.435   352.719     0.150
    28.924   356.328     0.150
    29.743   364.379     0.150
    30.225   368.750     0.150
    30.225   370.160     0.150
    30.500   372.420     0.150
    30.500   431.119     0.150
    30.500   673.520     0.150
    30.500   770.320     0.150
    30.647   373.170     0.150
    30.827   374.230     0.150
    31.363   380.609     0.150
    32.583   390.119     0.150
    35.390   415.500     0.150
    35.628   417.070     0.150
    37.075   428.520     0.150
    37.674   433.059     0.150
    37.674   433.199     0.150
    42.323   471.902     0.150
    42.323   473.219     0.150
    43.095   480.719     0.150
    45.077   493.299     0.150
    45.077   893.340     0.150
    45.761   499.549     0.150
    46.267   504.359     0.150
    46.535   506.570     0.150
    46.535   598.227     0.150
    46.535   505.900     0.150
    46.535   506.320     0.150
    47.259   512.119     0.150
    47.823   516.889     0.150
    48.406   520.920     0.150
    48.564   521.570     0.150
    48.576   522.219     0.150
    48.576   522.244     0.150
    48.791   523.160     0.150
    48.791   523.869     0.150
    48.791   607.727     0.150
    48.791   522.889     0.150
    49.002   525.330     0.150
    49.408   526.439     0.150
    49.542   528.400     0.150
    49.718   530.000     0.150
    50.053   531.559     0.150
    50.267   535.369     0.150
    50.296   533.760     0.150
    50.373   534.670     0.150
    50.443   536.049     0.150
    50.494   536.270     0.150
    50.504   536.699     0.150
    50.996   539.930     0.150
    50.997   541.869     0.150
    50.997   540.469     0.150
    51.406   541.920     0.150
    51.601   544.469     0.150
    51.612   544.279     0.150
    51.676   544.160     0.150
    51.729   544.260     0.150
    53.066   555.570     0.150
    54.592   566.719     0.150
    54.699   567.639     0.150
    55.322   573.719     0.150
    55.460   573.717     0.150
    55.460   573.469     0.150
    56.612   581.250     0.150
    59.600   601.195     0.150
    59.600   601.340     0.150
    67.244   652.969     0.150
    69.354   665.820     0.150
    70.651   674.400     0.150
    70.651   673.340     0.150
    71.646   680.160     0.150
    73.600   691.389     0.150
    73.820   693.080     0.150
    74.526   697.090     0.150
    74.578   698.059     0.150
    74.776   699.240     0.150
    74.807   699.070     0.150
    76.154   706.180     0.150
    76.265   707.199     0.150
    76.302   708.219     0.150
    76.336   707.889     0.150
    76.302   706.820     0.150
    76.308   707.029     0.150
    76.308   706.539     0.150
    76.312   707.080     0.150
    76.376   707.189     0.150
    76.642   710.299     0.150
    76.688   710.539     0.150
    77.358   713.650     0.150
    77.550   715.260     0.150
    77.715   716.180     0.150
    77.875   717.619     0.150
    78.789   721.340     0.150
    78.789   721.219     0.150
    78.789   721.379     0.150
    78.946   722.219     0.150
    79.283   724.709     0.150
    79.506   726.379     0.150
    79.756   726.379     0.150
    79.775   726.809     0.150
    79.776   726.570     0.150
    79.991   728.945     0.150
    79.991   728.320     0.150
    80.044   727.820     0.150
    80.044   727.920     0.150
    80.200   729.699     0.150
    80.646   731.959     0.150
    80.818   733.010     0.150
    81.491   736.869     0.150
    81.598   736.609     0.150
    82.043   739.809     0.150
    83.248   744.219     0.150
    86.944   764.719     0.150
    89.103   773.920     0.150
    89.371   774.920     0.150
    89.588   775.070     0.150
    93.008   791.914     0.150
   151.042  1189.844     0.150
     0.299     6.025     0.150
     0.299    10.325     0.150
     0.448     8.226     0.150
     0.448    14.325     0.150
     0.758    14.726     0.150
     0.758    25.825     0.150
     1.093    20.125     0.150
     1.093    35.525     0.150
     1.093    20.426     0.150
     1.296    23.025     0.150
     1.296    23.525     0.150
     1.296    40.325     0.150
     1.296    41.726     0.150
     1.296    40.426     0.150
     1.294    24.325     0.150
     1.294    24.825     0.150
     1.294    42.025     0.150
     1.335    24.625     0.150
     1.335    25.226     0.150
     1.335    43.325     0.150
     1.335    43.726     0.150
     1.924    32.426     0.150
     1.924    34.926     0.150
     1.924    60.426     0.150
     2.319    38.025     0.150
     2.319    41.325     0.150
     2.319    66.226     0.150
     2.319    71.226     0.150
     2.319    41.726     0.150
     2.462    44.926     0.150
     2.462    69.325     0.150
     2.462    76.325     0.150
     2.462    44.025     0.150
     2.574    41.125     0.150
     2.574    44.926     0.150
     2.574    46.825     0.150
     2.574    78.726     0.150
     2.574    41.226     0.150
     2.574    44.025     0.150
     2.574    78.125     0.150
     2.575    41.625     0.150
     2.575    46.525     0.150
     2.575    72.825     0.150
     2.575    79.825     0.150
     2.852    45.525     0.150
     2.852    50.426     0.150
     2.852    78.825     0.150
     2.852    87.325     0.150
     2.852    50.325     0.150
     2.852    87.426     0.150
     3.051    48.125     0.150
     3.051    54.726     0.150
     3.051    94.625     0.150
     3.051    54.926     0.150
     3.367    52.325     0.150
     3.367    59.825     0.150
     3.367    91.426     0.150
     3.367   104.125     0.150
     3.367    52.025     0.150
     3.367    58.825     0.150
     3.367    90.625     0.150
     3.367   100.825     0.150
     3.497   109.226     0.150
     3.497    59.325     0.150
     3.497    91.825     0.150
     3.497   107.025     0.150
     3.643    56.426     0.150
     3.643    64.825     0.150
     3.643    98.226     0.150
     3.643   111.426     0.150
     3.643    57.125     0.150
     3.643    66.226     0.150
     3.643   110.726     0.150
     3.738    66.325     0.150
     3.738    99.625     0.150
     3.738   114.426     0.150
     3.738    67.226     0.150
     3.738   116.426     0.150
     4.060    62.525     0.150
     4.060    71.226     0.150
     4.060   106.726     0.150
     4.060   125.226     0.150
     4.060    70.825     0.150
     4.060   124.125     0.150
     4.012    62.226     0.150
     4.012    71.825     0.150
     4.012   107.926     0.150
     4.012   125.025     0.150
     4.012    61.426     0.150
     4.012    71.226     0.150
     4.012   124.226     0.150
     4.303    63.825     0.150
     4.303    77.325     0.150
     4.303   113.726     0.150
     4.303   131.926     0.150
     4.303    74.426     0.150
     4.419    79.426     0.150
     4.419   116.726     0.150
     4.419   136.825     0.150
     4.564    70.825     0.150
     4.564    81.125     0.150
     4.564   125.625     0.150
     4.564   139.525     0.150
     4.564    71.025     0.150
     4.564    82.025     0.150
     4.564   122.226     0.150
     4.564   138.726     0.150
     5.048    76.325     0.150
     5.048   155.825     0.150
     5.048    77.525     0.150
     5.048    91.726     0.150
     5.048   134.125     0.150
     5.241    79.726     0.150
     5.340    80.205     0.150
     5.340    95.926     0.150
     5.340   164.994     0.150
     5.592    83.325     0.150
     5.592    99.325     0.150
     5.592   173.125     0.150
     5.839    86.625     0.150
     5.839   104.325     0.150
     5.839   150.726     0.150
     5.839   179.325     0.150
     6.863   212.525     0.150
     7.011   102.525     0.150
     7.011   216.226     0.150
     7.174   104.025     0.150
     7.174   129.926     0.150
     7.174   221.926     0.150
     7.174   102.726     0.150
     7.858   244.525     0.150
     8.251   117.125     0.150
     8.595   123.726     0.150
     8.595   155.625     0.150
     8.595   266.625     0.150
     8.891   274.926     0.150
    10.223   185.426     0.150
    10.223   316.726     0.150
    10.378   319.825     0.150
    12.324   173.426     0.150
    12.324   310.625     0.150
    13.864   195.159     0.150
    13.864   430.395     0.150
    17.693   245.226     0.150
    17.693   244.325     0.150
    17.693   553.457     0.150
    17.693   247.726     0.150
    18.280   253.025     0.150
    18.364   252.976     0.150
    20.773   279.025     0.150
    22.497   297.066     0.150
    42.307   471.059     0.150
    49.211   526.875     0.150
    59.990   604.966     0.150
     0.309     6.129     0.150
     0.309    10.430     0.150
     0.442     8.328     0.150
     0.442    14.430     0.150
     0.766    14.730     0.150
     0.766    25.430     0.150
     1.097    20.629     0.150
     1.097    35.730     0.150
     1.289    23.129     0.150
     1.289    40.430     0.150
     1.289    42.129     0.150
     1.303    24.930     0.150
     1.303    42.430     0.150
     1.344    25.328     0.150
     1.344    43.328     0.150
     1.930    32.629     0.150
     1.930    34.930     0.150
     1.930    60.129     0.150
     2.326    37.930     0.150
     2.326    41.828     0.150
     2.326    71.730     0.150
     2.467    75.930     0.150
     2.565    41.230     0.150
     2.565    44.930     0.150
     2.565    79.230     0.150
     2.582    41.629     0.150
     2.582    46.629     0.150
     2.582    80.027     0.150
     3.057    48.129     0.150
     3.057    54.730     0.150
     3.057    56.328     0.150
     3.057    94.430     0.150
     3.358    59.828     0.150
     3.358   103.328     0.150
     3.498   108.027     0.150
     3.647    56.430     0.150
     3.647    65.230     0.150
     3.647   111.027     0.150
     3.647   112.328     0.150
     3.647   115.027     0.150
     3.729   115.527     0.150
     4.053    72.027     0.150
     4.053   124.230     0.150
     4.020    61.828     0.150
     4.020    73.129     0.150
     4.020   125.730     0.150
     4.310    65.328     0.150
     4.310    77.629     0.150
     4.310   131.930     0.150
     4.310   134.527     0.150
     4.411   137.129     0.150
     4.568    69.930     0.150
     4.568    82.430     0.150
     4.568   139.230     0.150
     4.568   142.027     0.150
     5.050    77.328     0.150
     5.050    91.230     0.150
     5.050   156.828     0.150
     5.584   100.527     0.150
     5.584   172.828     0.150
     5.830   179.730     0.150
     7.003   216.828     0.150
     7.169   103.730     0.150
     7.169   128.027     0.150
     7.169   220.930     0.150
     7.851   241.930     0.150
     8.589   266.129     0.150
     8.892   275.730     0.150
    10.217   317.230     0.150
    10.371   319.430     0.150
     0.297     6.523     0.150
     0.297    11.523     0.150
     0.637    11.320     0.150
     0.637    19.719     0.150
     0.679    12.820     0.150
     0.679    22.422     0.150
     0.816    15.320     0.150
     0.816    26.523     0.150
     0.936    17.219     0.150
     0.936    30.922     0.150
     1.464    27.320     0.150
     1.464    47.820     0.150
     1.749    30.422     0.150
     1.870    31.922     0.150
     1.870    32.820     0.150
     1.870    57.719     0.150
     1.844    33.125     0.150
     1.844    58.523     0.150
     2.080    38.820     0.150
     2.080    66.922     0.150
     2.269    38.320     0.150
     2.269    40.922     0.150
     2.269    70.023     0.150
     2.618    42.125     0.150
     2.618    47.320     0.150
     2.618    81.320     0.150
     2.696    47.219     0.150
     2.696    82.922     0.150
     3.010    47.719     0.150
     3.010    54.125     0.150
     3.010    83.125     0.150
     3.010    93.625     0.150
     3.116    48.320     0.150
     3.116    55.023     0.150
     3.116    56.719     0.150
     3.116    95.125     0.150
     3.116    97.820     0.150
     0.124     4.426     0.150
     0.124     7.025     0.150
     0.452     9.225     0.150
     0.452    15.826     0.150
     0.555    11.426     0.150
     0.555    19.725     0.150
     0.691    13.625     0.150
     0.691    23.225     0.150
     0.711    13.525     0.150
     0.711    23.625     0.150
     0.847    15.326     0.150
     0.847    26.725     0.150
     1.527    26.826     0.150
     1.527    27.426     0.150
     1.527    48.025     0.150
     1.630    28.725     0.150
     1.630    29.725     0.150
     1.630    51.025     0.150
     1.763    55.625     0.150
     2.039    34.525     0.150
     2.039    36.725     0.150
     2.039    63.926     0.150
     2.103    34.525     0.150
     2.103    36.426     0.150
     2.103    64.426     0.150
     2.260    70.525     0.150
     2.781    48.426     0.150
     2.781    75.225     0.150
     2.781    84.926     0.150
     2.916    51.625     0.150
     2.916    89.125     0.150
     3.034    54.125     0.150
     3.034    83.525     0.150
     3.034    93.426     0.150
     3.270   100.426     0.150
     3.283    58.926     0.150
     3.283   100.926     0.150
     3.504    53.725     0.150
     3.504    63.025     0.150
     3.504   107.826     0.150
     3.590    54.926     0.150
     3.590    62.725     0.150
     3.590    64.926     0.150
     3.590    97.326     0.150
     3.590   109.725     0.150
     3.948   121.426     0.150
     4.070    61.426     0.150
     4.070    72.426     0.150
     4.070   107.125     0.150
     4.070   122.725     0.150
     4.070   125.525     0.150
     4.348    63.926     0.150
     4.348    77.426     0.150
     4.348   114.326     0.150
     4.348   133.025     0.150
     4.484    80.225     0.150
     4.484   118.525     0.150
     4.484   138.926     0.150
     4.986    75.225     0.150
     4.986    88.826     0.150
     4.986   130.625     0.150
     4.986   153.625     0.150
     5.120    76.826     0.150
     5.120    91.926     0.150
     5.120   131.826     0.150
     5.120   158.225     0.150
     5.384   139.426     0.150
     5.384   165.625     0.150
     5.417    81.225     0.150
     5.417    97.225     0.150
     5.417   144.025     0.150
     5.417   166.926     0.150
     6.541   201.225     0.150
     6.757    97.625     0.150
     6.757   120.725     0.150
     6.757   170.625     0.150
     6.757   206.926     0.150
     0.168     3.391     0.150
     0.168     5.891     0.150
     0.331     6.695     0.150
     0.331    11.594     0.150
     0.439     9.094     0.150
     0.439    15.891     0.150
     0.587    10.992     0.150
     0.587    19.289     0.150
     0.628    12.195     0.150
     0.628    20.789     0.150
     0.982    17.789     0.150
     0.982    31.094     0.150
     1.092    20.289     0.150
     1.092    21.695     0.150
     1.092    35.391     0.150
     1.092    38.492     0.150
     1.390    24.891     0.150
     1.390    44.391     0.150
     1.515    27.594     0.150
     1.515    47.789     0.150
     1.627    29.695     0.150
     1.627    30.391     0.150
     1.627    51.391     0.150
     1.669    30.789     0.150
     1.669    53.891     0.150
     1.707    30.492     0.150
     1.707    31.992     0.150
     1.707    54.992     0.150
     1.912    33.594     0.150
     1.912    34.594     0.150
     1.912    60.391     0.150
     2.122    38.695     0.150
     2.122    67.992     0.150
     2.240    37.789     0.150
     2.240    39.594     0.150
     2.240    70.094     0.150
     2.248    40.391     0.150
     2.248    70.289     0.150
     2.557    42.594     0.150
     2.557    45.891     0.150
     2.557    73.992     0.150
     2.557    79.789     0.150
     2.641    43.195     0.150
     2.641    47.891     0.150
     2.641    75.695     0.150
     2.641    81.891     0.150
     2.761    50.492     0.150
     2.761    86.492     0.150
     2.895    46.891     0.150
     2.895    52.094     0.150
     2.895    80.992     0.150
     2.895    91.391     0.150
     3.043    48.992     0.150
     3.043    54.094     0.150
     3.043    94.492     0.150
     3.347   103.289     0.150
     3.366    54.195     0.150
     3.366    60.789     0.150
     3.366    92.789     0.150
     3.366   104.594     0.150
     3.729    58.391     0.150
     3.729    66.992     0.150
     3.729   116.195     0.150
     3.936    71.391     0.150
     3.936   122.492     0.150
     4.086    63.289     0.150
     4.086    74.195     0.150
     4.086   127.094     0.150
     4.347    65.789     0.150
     4.347    78.492     0.150
     4.347   116.492     0.150
     4.347   134.289     0.150
     4.345    67.391     0.150
     4.345    78.891     0.150
     4.345   135.789     0.150
     4.854    75.695     0.150
     4.854    87.594     0.150
     4.854   150.594     0.150
     5.259    78.789     0.150
     5.259    93.789     0.150
     5.259   161.695     0.150
     5.296    81.594     0.150
     5.296   138.891     0.150
     5.296   164.594     0.150
     5.513    98.391     0.150
     5.513   170.195     0.150
     6.561   203.195     0.150
     6.681   120.891     0.150
     6.681   207.195     0.150
     6.887   100.992     0.150
     6.887   123.094     0.150
     6.887   212.594     0.150
     8.275   254.992     0.150
     0.201     4.812     0.150
     0.201     8.312     0.150
     0.320     6.312     0.150
     0.320    10.812     0.150
     0.408     7.516     0.150
     0.408    13.016     0.150
     0.463     9.016     0.150
     0.463    15.516     0.150
     0.518     9.812     0.150
     0.518    17.117     0.150
     1.160    20.812     0.150
     1.160    37.617     0.150
     1.217    21.812     0.150
     1.217    38.516     0.150
     1.433    26.219     0.150
     1.433    27.219     0.150
     1.433    46.117     0.150
     1.433    48.312     0.150
     1.465    27.016     0.150
     1.465    47.312     0.150
     1.500    28.219     0.150
     1.500    48.516     0.150
     1.517    28.016     0.150
     1.517    47.617     0.150
     1.786    32.617     0.150
     1.786    57.414     0.150
     2.036    34.914     0.150
     2.036    36.812     0.150
     2.036    63.914     0.150
     2.428    40.219     0.150
     2.428    43.016     0.150
     2.428    75.312     0.150
     2.426    40.414     0.150
     2.426    43.812     0.150
     2.426    70.719     0.150
     2.426    75.516     0.150
     2.528    45.719     0.150
     2.528    79.117     0.150
     2.644    44.219     0.150
     2.644    47.219     0.150
     2.644    74.219     0.150
     2.644    78.719     0.150
     2.644    81.117     0.150
     2.675    43.914     0.150
     2.675    48.312     0.150
     2.675    83.117     0.150
     3.141    57.117     0.150
     3.141    96.617     0.150
     3.141    97.812     0.150
     3.189    57.812     0.150
     3.189    99.117     0.150
     3.563    63.016     0.150
     3.563   110.219     0.150
     3.570    63.719     0.150
     3.570    98.016     0.150
     3.570   111.312     0.150
     3.699    59.516     0.150
     3.699    66.617     0.150
     3.699   115.117     0.150
     3.935    61.516     0.150
     3.935    70.312     0.150
     3.935   122.117     0.150
     4.149    64.312     0.150
     4.149    75.812     0.150
     4.149   121.914     0.150
     4.149   129.914     0.150
     4.479    67.117     0.150
     4.479    80.414     0.150
     4.479   120.219     0.150
     4.479   138.719     0.150
     4.615    72.016     0.150
     4.615    82.016     0.150
     4.615   127.812     0.150
     4.615   141.914     0.150
     5.052    78.812     0.150
     5.052    91.219     0.150
     5.052   133.617     0.150
     5.052   136.617     0.150
     5.052   157.812     0.150
     5.459    81.219     0.150
     5.459    98.117     0.150
     5.459   157.312     0.150
     5.459   169.414     0.150
     5.663    86.312     0.150
     5.663   101.719     0.150
     5.663   174.812     0.150
     6.661   171.812     0.150
     6.661   206.016     0.150
     6.889   101.312     0.150
     6.889   124.312     0.150
     6.889   213.719     0.150
     7.128   104.617     0.150
     7.128   128.617     0.150
     7.128   220.914     0.150
     7.746   240.117     0.150
     8.498   262.016     0.150
    10.286   316.812     0.150
     0.158     4.805     0.150
     0.158     7.902     0.150
     0.736    14.102     0.150
     0.736    24.305     0.150
     0.807    15.203     0.150
     0.807    26.102     0.150
     0.994    18.305     0.150
     0.994    31.703     0.150
     1.251    23.504     0.150
     1.251    40.902     0.150
     1.306    23.703     0.150
     1.306    40.805     0.150
     1.315    23.805     0.150
     1.315    41.305     0.150
     1.798    31.805     0.150
     1.798    56.504     0.150
     1.809    31.203     0.150
     1.809    32.305     0.150
     1.809    54.602     0.150
     1.809    56.902     0.150
     1.830    31.504     0.150
     1.830    33.004     0.150
     1.830    55.902     0.150
     1.877    33.203     0.150
     1.877    56.102     0.150
     1.877    58.402     0.150
     2.272    39.203     0.150
     2.272    68.602     0.150
     2.234    36.203     0.150
     2.234    39.203     0.150
     2.234    64.504     0.150
     2.234    68.402     0.150
     2.273    37.305     0.150
     2.273    39.805     0.150
     2.273    64.305     0.150
     2.273    69.504     0.150
     2.609    47.305     0.150
     2.609    81.305     0.150
     2.602    42.102     0.150
     2.602    46.102     0.150
     2.602    47.703     0.150
     2.602    79.102     0.150
     2.831    45.305     0.150
     2.831    49.805     0.150
     2.831    86.004     0.150
     2.914    46.602     0.150
     2.914    51.305     0.150
     2.914    89.504     0.150
     3.265    50.402     0.150
     3.265    57.805     0.150
     3.265    60.004     0.150
     3.265    89.902     0.150
     3.265   101.203     0.150
     3.301   101.805     0.150
     3.738    58.203     0.150
     3.738    67.305     0.150
     3.738   116.203     0.150
     3.812    58.504     0.150
     3.812    67.504     0.150
     3.812    69.504     0.150
     3.812   116.402     0.150
     3.883    69.805     0.150
     3.883   120.402     0.150
     4.085    73.203     0.150
     4.085   126.305     0.150
     4.370    66.703     0.150
     4.370    79.305     0.150
     4.370    80.203     0.150
     4.370   136.805     0.150
     4.634    83.102     0.150
     4.634   122.805     0.150
     4.634   142.805     0.150
     4.962    75.703     0.150
     4.962   153.004     0.150
     4.940    72.504     0.150
     4.940    88.602     0.150
     4.940   126.602     0.150
     4.940   154.004     0.150
     5.305    79.203     0.150
     5.305    95.102     0.150
     5.305   164.203     0.150
     5.380    79.504     0.150
     5.380    95.602     0.150
     5.380   165.004     0.150
     5.901   106.504     0.150
     5.901   183.004     0.150
     6.286   193.203     0.150
     6.758   121.504     0.150
     6.758   208.902     0.150
     7.182   104.004     0.150
     7.182   128.305     0.150
     7.182   220.703     0.150
     8.427   260.602     0.150
     8.685   268.402     0.150
    10.225   315.402     0.150
     0.316     6.875     0.150
     0.316    12.074     0.150
     0.624    12.172     0.150
     0.624    21.172     0.150
     0.815    14.574     0.150
     0.815    25.375     0.150
     0.815    14.473     0.150
     0.626    12.473     0.150
     0.626    21.473     0.150
     0.880    16.473     0.150
     0.880    28.875     0.150
     1.358    24.273     0.150
     1.358    42.375     0.150
     1.601    27.875     0.150
     1.601    28.973     0.150
     1.601    50.074     0.150
     1.601    27.773     0.150
     1.808    30.672     0.150
     1.808    32.672     0.150
     1.808    56.973     0.150
     1.975    32.773     0.150
     1.975    34.375     0.150
     1.905    31.773     0.150
     1.905    34.773     0.150
     1.905    55.574     0.150
     1.905    60.074     0.150
     1.943    32.375     0.150
     1.968    33.172     0.150
     1.968    36.473     0.150
     2.265    37.473     0.150
     2.265    40.074     0.150
     2.265    63.375     0.150
     2.265    69.074     0.150
     2.202    36.172     0.150
     2.202    39.672     0.150
     2.202    62.773     0.150
     2.202    69.375     0.150
     2.487    39.773     0.150
     2.487    44.773     0.150
     2.487    69.672     0.150
     2.487    77.074     0.150
     2.755    43.875     0.150
     2.755    48.473     0.150
     2.755    84.574     0.150
     2.876    45.375     0.150
     2.876    51.273     0.150
     2.876    88.875     0.150
     3.131    96.973     0.150
     2.961    52.273     0.150
     2.961    90.672     0.150
     2.961    53.773     0.150
     2.961    90.375     0.150
     3.124    48.672     0.150
     3.124    55.375     0.150
     3.124    85.273     0.150
     3.124    96.172     0.150
     3.363    50.875     0.150
     3.363    60.172     0.150
     3.363    89.375     0.150
     3.363   103.273     0.150
     3.483    53.574     0.150
     3.483    62.574     0.150
     3.483   107.875     0.150
     3.483    53.473     0.150
     3.585    54.875     0.150
     3.585    63.672     0.150
     3.585   110.473     0.150
     3.820    58.973     0.150
     3.820    68.773     0.150
     3.820   101.574     0.150
     3.820   117.973     0.150
     4.123    62.172     0.150
     4.123    73.574     0.150
     4.123   109.172     0.150
     4.123   126.875     0.150
     4.520    66.273     0.150
     4.520    80.375     0.150
     4.520   116.672     0.150
     4.520   138.273     0.150
     4.520    66.172     0.150
     4.601    69.773     0.150
     4.601    82.672     0.150
     4.601   120.574     0.150
     4.601    69.375     0.150
     5.006    74.375     0.150
     5.006    90.172     0.150
     5.006   155.672     0.150
     5.034    76.672     0.150
     5.034    85.273     0.150
     5.034    90.172     0.150
     5.034   133.473     0.150
     5.034   147.973     0.150
     5.034    76.375     0.150
     5.034   133.574     0.150
     5.034   154.172     0.150
     5.226    77.375     0.150
     5.226    92.973     0.150
     5.226   134.574     0.150
     5.226   160.773     0.150
     5.425    80.875     0.150
     5.425    92.375     0.150
     5.425   143.172     0.150
     5.802    85.402     0.150
     5.802    85.773     0.150
     5.802   105.875     0.150
     5.802   180.875     0.150
     5.802    85.984     0.150
     5.919    87.285     0.150
     5.919    87.414     0.150
     5.919   105.535     0.150
     5.919   155.555     0.150
     5.919   185.172     0.150
     5.948   188.410     0.150
     6.438    94.773     0.150
     6.438   197.773     0.150
     6.727    97.375     0.150
     6.727   120.074     0.150
     6.727   207.574     0.150
     7.298   106.672     0.150
     7.298   130.074     0.150
     7.298   224.672     0.150
     8.057   114.973     0.150
     8.057   248.473     0.150
     8.167   114.762     0.150
     8.167   114.875     0.150
     8.167   147.473     0.150
     8.167   204.273     0.150
     8.167   252.375     0.150
     8.167   114.984     0.150
     9.847   304.375     0.150
    11.048   157.473     0.150
    12.055   169.074     0.150
    12.055   301.875     0.150
    12.881   182.672     0.150
    13.006   185.074     0.150
    13.006   325.375     0.150
    13.997   430.691     0.150
    14.082   198.043     0.150
    14.082   197.672     0.150
    14.082   198.707     0.150
    14.082   439.773     0.150
    14.082   199.074     0.150
    14.431   209.473     0.150
    14.473   203.375     0.150
    14.493   203.113     0.150
    14.493   203.484     0.150
    15.040   208.473     0.150
    15.040   375.422     0.150
    15.040   210.375     0.150
    15.394   215.574     0.150
    15.394   221.074     0.150
    16.713   235.172     0.150
    16.862   233.172     0.150
    16.862   244.973     0.150
    17.158   238.074     0.150
    17.227   240.375     0.150
    17.918   248.672     0.150
    17.918   245.922     0.150
    17.918   562.723     0.150
    17.804   246.473     0.150
    17.804   250.172     0.150
    18.117   248.902     0.150
    18.117   249.254     0.150
    18.117   249.598     0.150
    18.117   567.051     0.150
    18.293   251.684     0.150
    18.577   253.254     0.150
    18.577   253.875     0.150
    18.577   254.984     0.150
    18.664   255.922     0.150
    18.664   584.305     0.150
    19.880   270.875     0.150
    19.880   273.375     0.150
    19.880   496.672     0.150
    20.180   271.184     0.150
    20.180   270.766     0.150
    20.180   486.809     0.150
    20.180   628.543     0.150
    20.180   272.273     0.150
    20.180   271.984     0.150
    20.901   285.574     0.150
    20.917   278.965     0.150
    20.917   282.023     0.150
    20.917   659.625     0.150
    21.591   289.672     0.150
    22.630   300.555     0.150
    22.630   301.172     0.150
    22.630   301.023     0.150
    22.731   301.074     0.150
    22.689   300.523     0.150
    22.741   299.523     0.150
    22.741   302.633     0.150
    22.922   304.273     0.150
    23.119   307.895     0.150
    23.292   308.133     0.150
    23.262   305.984     0.150
    23.643   310.652     0.150
    23.643   309.766     0.150
    23.643   734.969     0.150
    23.643   311.074     0.150
    23.643   311.582     0.150
    23.711   312.523     0.150
    23.810   309.945     0.150
    23.810   313.734     0.150
    24.373   761.348     0.150
    24.373   318.375     0.150
    24.298   316.184     0.150
    24.298   317.254     0.150
    25.048   322.305     0.150
    25.048   323.418     0.150
    25.048   325.172     0.150
    25.048   325.383     0.150
    27.045   342.574     0.150
    27.111   341.465     0.150
    27.521   346.473     0.150
    28.457   355.969     0.150
    28.835   357.648     0.150
    28.755   356.773     0.150
    29.402   362.574     0.150
    29.810   365.863     0.150
    29.810   367.273     0.150
    30.318   370.473     0.150
    30.317   369.773     0.150
    30.195   368.484     0.150
    30.798   374.613     0.150
    32.052   387.254     0.150
    32.387   389.785     0.150
    32.387   388.164     0.150
    32.477   390.375     0.150
    35.495   415.004     0.150
    35.844   417.973     0.150
    35.844   418.875     0.150
    36.488   422.172     0.150
    39.944   451.207     0.150
    40.501   454.723     0.150
    40.851   825.172     0.150
    41.094   460.840     0.150
    41.149   461.523     0.150
    41.221   461.656     0.150
    41.326   462.301     0.150
    41.422   463.637     0.150
    41.517   463.512     0.150
    41.731   466.164     0.150
    41.848   467.242     0.150
    41.928   467.875     0.150
    42.098   469.188     0.150
    42.229   470.340     0.150
    42.180   471.793     0.150
    42.180   472.422     0.150
    42.380   472.066     0.150
    42.404   472.285     0.150
    42.492   471.785     0.150
    42.549   472.125     0.150
    42.733   474.309     0.150
    42.805   474.770     0.150
    42.839   475.059     0.150
    43.178   477.551     0.150
    43.216   478.207     0.150
    43.251   478.387     0.150
    43.054   477.973     0.150
    43.329   479.559     0.150
    43.341   479.090     0.150
    43.407   479.637     0.150
    43.526   481.258     0.150
    43.543   480.375     0.150
    43.610   483.344     0.150
    43.610   481.480     0.150
    43.667   481.617     0.150
    43.661   482.613     0.150
    43.690   482.363     0.150
    43.746   483.141     0.150
    43.921   484.555     0.150
    43.962   483.910     0.150
    44.152   485.098     0.150
    44.214   485.887     0.150
    44.297   486.512     0.150
    44.317   488.184     0.150
    44.317   487.953     0.150
    44.323   488.012     0.150
    44.340   487.324     0.150
    44.412   487.793     0.150
    44.413   487.797     0.150
    44.566   489.047     0.150
    44.730   490.004     0.150
    44.774   490.254     0.150
    44.876   491.238     0.150
    44.891   491.715     0.150
    44.968   491.406     0.150
    44.997   492.941     0.150
    44.994   492.293     0.150
    45.030   492.344     0.150
    45.078   492.547     0.150
    45.087   492.605     0.150
    44.962   493.293     0.150
    44.962   598.684     0.150
    44.962  1096.453     0.150
    44.962  1090.574     0.150
    45.164   493.543     0.150
    45.229   493.816     0.150
    45.320   494.527     0.150
    45.353   494.688     0.150
    45.390   495.707     0.150
    45.393   496.613     0.150
    45.393   495.559     0.150
    45.245   497.754     0.150
    45.458   495.859     0.150
    45.716   498.227     0.150
    45.757   498.816     0.150
    45.862   499.422     0.150
    45.943   499.953     0.150
    45.936   499.645     0.150
    45.928   500.402     0.150
    45.963   500.004     0.150
    45.991   499.613     0.150
    45.977   500.387     0.150
    46.019   500.266     0.150
    46.038   500.449     0.150
    46.051   500.520     0.150
    46.076   500.961     0.150
    46.086   501.383     0.150
    46.379   503.957     0.150
    46.419   504.098     0.150
    46.465   503.676     0.150
    46.484   503.641     0.150
    46.503   504.219     0.150
    46.487   503.812     0.150
    46.519   504.492     0.150
    46.567   504.680     0.150
    46.635   504.656     0.150
    46.657   505.312     0.150
    46.841   506.988     0.150
    46.848   506.820     0.150
    46.896   507.586     0.150
    46.972   508.328     0.150
    47.168   509.445     0.150
    47.195   509.805     0.150
    47.202   508.723     0.150
    47.292   510.375     0.150
    47.291   510.004     0.150
    47.377   511.035     0.150
    47.417   511.352     0.150
    47.453   511.461     0.150
    47.480   511.895     0.150
    47.540   512.270     0.150
    47.565   512.617     0.150
    47.583   511.906     0.150
    47.584   513.023     0.150
    47.601   512.398     0.150
    47.627   512.949     0.150
    47.640   512.305     0.150
    47.654   513.164     0.150
    47.719   513.230     0.150
    47.876   514.426     0.150
    47.940   515.188     0.150
    47.934   518.023     0.150
    47.934   514.539     0.150
    47.982   516.031     0.150
    47.986   516.281     0.150
    48.018   516.031     0.150
    48.000   515.629     0.150
    48.018   516.277     0.150
    48.144   517.406     0.150
    48.171   517.473     0.150
    48.207   517.793     0.150
    48.198   516.559     0.150
    48.214   519.672     0.150
    48.255   518.020     0.150
    48.272   518.168     0.150
    48.293   518.516     0.150
    48.346   518.875     0.150
    48.556   520.516     0.150
    48.560   520.816     0.150
    48.418   521.965     0.150
    48.568   521.000     0.150
    48.598   522.102     0.150
    48.598   522.422     0.150
    48.649   521.445     0.150
    48.742   521.996     0.150
    48.785   521.758     0.150
    48.790   521.465     0.150
    48.810   522.293     0.150
    48.883   523.047     0.150
    48.898   522.602     0.150
    48.926   523.230     0.150
    48.936   523.168     0.150
    48.977   523.812     0.150
    48.978   524.117     0.150
    49.020   523.590     0.150
    49.085   524.477     0.150
    49.186   525.621     0.150
    49.199   525.375     0.150
    49.195   525.188     0.150
    49.325   527.008     0.150
    49.404   526.758     0.150
    49.448   527.039     0.150
    49.479   527.238     0.150
    49.509   527.047     0.150
    49.524   526.766     0.150
    49.558   526.574     0.150
    49.596   526.812     0.150
    49.650   527.098     0.150
    49.724   528.340     0.150
    49.853   529.965     0.150
    49.858   529.938     0.150
    49.870   530.055     0.150
    49.908   531.301     0.150
    49.877   530.172     0.150
    49.950   531.488     0.150
    49.974   531.699     0.150
    49.998   531.426     0.150
    50.018   531.758     0.150
    50.074   532.367     0.150
    50.090   532.199     0.150
    50.233   533.594     0.150
    50.246   533.359     0.150
    50.253   533.742     0.150
    50.264   533.902     0.150
    50.330   534.039     0.150
    50.340   533.691     0.150
    50.362   533.438     0.150
    50.395   533.398     0.150
    50.521   533.633     0.150
    50.559   534.734     0.150
    50.587   535.586     0.150
    50.642   534.918     0.150
    50.657   535.977     0.150
    50.666   535.785     0.150
    50.726   536.984     0.150
    50.739   537.562     0.150
    50.889   537.934     0.150
    50.905   538.156     0.150
    50.931   537.707     0.150
    51.025   539.422     0.150
    51.021   540.391     0.150
    51.082   539.773     0.150
    51.099   540.805     0.150
    50.950   541.574     0.150
    50.950   542.172     0.150
    51.158   538.703     0.150
    51.419   543.645     0.150
    51.478   543.070     0.150
    51.479   541.477     0.150
    51.479   541.684     0.150
    51.518   542.320     0.150
    51.563   542.020     0.150
    51.555   543.039     0.150
    51.707   544.055     0.150
    51.794   544.074     0.150
    51.884   544.836     0.150
    51.915   544.859     0.150
    52.040   545.520     0.150
    52.216   547.629     0.150
    52.342   548.645     0.150
    52.561   550.871     0.150
    52.706   551.637     0.150
    52.939   552.078     0.150
    53.355   555.492     0.150
    53.370   555.809     0.150
    53.405   556.684     0.150
    53.584   557.367     0.150
    53.682   558.098     0.150
    54.071   560.504     0.150
    54.105   561.195     0.150
    54.395   563.180     0.150
    54.442   563.656     0.150
    54.473   563.664     0.150
    54.503   565.027     0.150
    54.691   565.328     0.150
    54.943   567.855     0.150
    55.148   569.680     0.150
    55.416   571.031     0.150
    55.603   572.598     0.150
    55.534   573.273     0.150
    55.534   574.863     0.150
    56.189   576.133     0.150
    56.416   577.508     0.150
    56.615   579.387     0.150
    56.738   580.004     0.150
    56.856   581.000     0.150
    57.035   581.711     0.150
    57.373   584.547     0.150
    57.572   585.590     0.150
    57.638   586.055     0.150
    57.981   587.684     0.150
    57.846   590.598     0.150
    58.046   588.758     0.150
    58.699   593.285     0.150
    58.769   593.477     0.150
    59.073   595.598     0.150
    59.389   599.547     0.150
    59.389   599.273     0.150
    59.544   599.371     0.150
    59.563   599.387     0.150
    59.803   601.254     0.150
    59.807   601.555     0.150
    60.057   602.227     0.150
    60.741   606.766     0.150
    70.519   673.887     0.150
    72.864   687.773     0.150
    74.382   696.742     0.150
    76.111   706.352     0.150
    76.346   706.652     0.150
    76.495   707.672     0.150
    76.501   708.273     0.150
    76.501   708.172     0.150
    76.504   707.895     0.150
    78.586   719.973     0.150
    78.741   722.672     0.150
    79.083   722.773     0.150
    79.803   727.723     0.150
    79.971   727.512     0.150
    79.971   727.625     0.150
    82.611   743.875     0.150
    84.016   746.297     0.150
    85.236   753.535     0.150
    88.612   770.562     0.150
    89.307   775.062     0.150
    89.307   775.344     0.150
    89.775   775.773     0.150
    92.963   790.461     0.150
   146.154  1176.539     0.150
   150.852  1184.949     0.150
   150.852  1189.574     0.150
     0.325     6.750     0.150
     0.325    12.156     0.150
     0.636    12.453     0.150
     0.636    21.250     0.150
     0.639    12.156     0.150
     0.639    21.250     0.150
     0.802    14.156     0.150
     0.802    24.953     0.150
     0.895    16.555     0.150
     0.895    29.156     0.150
     1.375    24.852     0.150
     1.375    25.555     0.150
     1.375    44.055     0.150
     1.617    28.250     0.150
     1.823    30.953     0.150
     1.823    32.555     0.150
     1.921    32.156     0.150
     1.921    34.750     0.150
     1.921    60.750     0.150
     1.959    32.453     0.150
     1.959    34.250     0.150
     1.959    60.750     0.150
     1.959    35.750     0.150
     1.984    33.156     0.150
     1.984    36.055     0.150
     1.984    60.250     0.150
     1.984    62.250     0.150
     2.217    36.555     0.150
     2.217    39.953     0.150
     2.217    69.453     0.150
     2.251    37.156     0.150
     2.251    38.453     0.150
     2.251    40.055     0.150
     2.251    69.055     0.150
     2.405    43.055     0.150
     2.405    76.055     0.150
     2.503    39.852     0.150
     2.503    45.055     0.150
     2.503    77.156     0.150
     2.739    43.953     0.150
     2.739    48.852     0.150
     2.739    83.953     0.150
     2.892    45.352     0.150
     2.892    51.852     0.150
     2.892    89.656     0.150
     2.976    52.953     0.150
     2.976    91.156     0.150
     3.140    48.750     0.150
     3.140    56.156     0.150
     3.140    97.453     0.150
     3.357    50.750     0.150
     3.357    59.055     0.150
     3.357   103.055     0.150
     3.467    54.055     0.150
     3.467    61.156     0.150
     3.467   105.953     0.150
     3.601    54.953     0.150
     3.601    64.656     0.150
     3.601   111.156     0.150
     3.804    58.250     0.150
     3.804    67.352     0.150
     3.804   118.156     0.150
     4.138    63.656     0.150
     4.138    74.055     0.150
     4.138   127.352     0.150
     4.523    66.156     0.150
     4.523    80.250     0.150
     4.523   116.055     0.150
     4.523   139.055     0.150
     4.618    69.852     0.150
     4.618    83.156     0.150
     4.618   143.156     0.150
     4.990    88.453     0.150
     4.990   152.055     0.150
     5.049    76.852     0.150
     5.049    90.250     0.150
     5.049   135.453     0.150
     5.049   155.453     0.150
     5.210    77.656     0.150
     5.210    92.453     0.150
     5.210   161.055     0.150
     5.438    81.852     0.150
     5.438    97.750     0.150
     5.438   141.453     0.150
     5.438   168.156     0.150
     6.422   115.453     0.150
     6.422   198.453     0.150
     6.714    96.953     0.150
     6.714   119.352     0.150
     6.714   206.852     0.150
     8.041   248.250     0.150
     9.832   303.055     0.150
     0.321     6.875     0.150
     0.321    12.172     0.150
     0.616    12.477     0.150
     0.616    20.375     0.150
     0.624    12.172     0.150
     0.624    20.875     0.150
     0.825    14.477     0.150
     0.825    25.273     0.150
     0.879    16.375     0.150
     0.879    28.773     0.150
     1.354    25.172     0.150
     1.354    43.477     0.150
     1.594    28.078     0.150
     1.594    28.773     0.150
     1.939    34.578     0.150
     1.981    34.375     0.150
     1.981    60.977     0.150
     1.963    35.875     0.150
     1.963    61.977     0.150
     2.265    37.578     0.150
     2.265    39.672     0.150
     2.265    68.672     0.150
     2.265    70.477     0.150
     2.481    39.773     0.150
     2.481    44.477     0.150
     2.481    76.773     0.150
     2.758    43.977     0.150
     2.758    49.172     0.150
     2.758    84.375     0.150
     2.869    45.375     0.150
     2.869    51.172     0.150
     2.869    88.078     0.150
     2.953    90.773     0.150
     3.134    55.273     0.150
     3.134    96.273     0.150
     3.117    48.875     0.150
     3.117    55.172     0.150
     3.117    96.078     0.150
     3.373    59.977     0.150
     3.373   103.477     0.150
     3.490    54.172     0.150
     3.490    61.875     0.150
     3.490   106.578     0.150
     3.577    53.977     0.150
     3.577    63.875     0.150
     3.577   109.977     0.150
     3.825    67.977     0.150
     3.825   118.672     0.150
     4.115    63.172     0.150
     4.115    74.078     0.150
     4.115   127.273     0.150
     4.528    66.273     0.150
     4.528    80.078     0.150
     4.528   116.578     0.150
     4.528   139.172     0.150
     4.596    82.172     0.150
     4.596   143.078     0.150
     5.012    88.578     0.150
     5.012   154.977     0.150
     5.025   154.578     0.150
     5.230   134.977     0.150
     5.230   160.578     0.150
     5.415    81.773     0.150
     5.415    96.875     0.150
     5.415   143.078     0.150
     5.415   157.773     0.150
     5.415   166.977     0.150
     6.268   193.672     0.150
     6.445   199.078     0.150
     6.737   207.977     0.150
     8.065   249.273     0.150
     0.184     3.594     0.150
     0.184     6.191     0.150
     0.325     6.492     0.150
     0.325    11.191     0.150
     0.580    10.891     0.150
     0.580    18.891     0.150
     1.375    24.793     0.150
     1.375    25.891     0.150
     1.375    43.391     0.150
     1.375    24.992     0.150
     1.509    27.492     0.150
     1.509    47.594     0.150
     1.657    30.891     0.150
     1.657    52.691     0.150
     1.903    33.391     0.150
     1.903    34.492     0.150
     1.903    60.191     0.150
     2.251    37.891     0.150
     2.251    39.793     0.150
     2.251    64.492     0.150
     2.251    69.391     0.150
     2.251    39.191     0.150
     2.251    69.793     0.150
     2.110    35.891     0.150
     2.110    38.594     0.150
     2.110    67.094     0.150
     2.234    37.391     0.150
     2.234    40.594     0.150
     2.234    64.891     0.150
     2.234    69.691     0.150
     2.234    70.293     0.150
     2.627    42.891     0.150
     2.627    46.793     0.150
     2.627    74.691     0.150
     2.627    81.492     0.150
     2.627    74.891     0.150
     2.627    80.992     0.150
     2.746    76.293     0.150
     2.746    84.891     0.150
     2.746    49.492     0.150
     2.880    46.094     0.150
     2.880    51.793     0.150
     2.880    81.492     0.150
     2.880    88.793     0.150
     2.880    46.594     0.150
     2.880    51.691     0.150
     3.052    49.094     0.150
     3.052    53.992     0.150
     3.052    94.293     0.150
     3.362    58.793     0.150
     3.362    60.691     0.150
     3.362    91.992     0.150
     3.362   103.691     0.150
     3.351    53.094     0.150
     3.351    60.391     0.150
     3.351    92.691     0.150
     3.351   103.594     0.150
     3.351    52.594     0.150
     3.351    59.992     0.150
     3.742    58.492     0.150
     3.742    67.094     0.150
     3.742   101.594     0.150
     3.742   115.391     0.150
     3.920    61.492     0.150
     3.920    70.391     0.150
     3.920   120.594     0.150
     3.920    70.691     0.150
     4.332    67.293     0.150
     4.332    78.492     0.150
     4.332   114.891     0.150
     4.332   134.594     0.150
     4.332    76.293     0.150
     4.332   135.691     0.150
     4.356    65.594     0.150
     4.356    77.293     0.150
     4.356   113.293     0.150
     4.356   116.191     0.150
     4.356   133.391     0.150
     4.356    65.793     0.150
     4.356   133.191     0.150
     4.838    74.992     0.150
     4.838    86.094     0.150
     4.838   128.191     0.150
     4.838   148.293     0.150
     4.838    75.691     0.150
     4.838   131.094     0.150
     4.838   149.793     0.150
     5.272    78.891     0.150
     5.272    93.492     0.150
     5.272   136.992     0.150
     5.272   162.293     0.150
     5.280    80.992     0.150
     5.280   138.992     0.150
     5.280   162.594     0.150
     5.522    82.391     0.150
     5.522    98.094     0.150
     5.522   169.594     0.150
     5.622    85.191     0.150
     5.622   177.371     0.150
     6.567   117.691     0.150
     6.567   202.391     0.150
     6.694    98.594     0.150
     6.694   116.793     0.150
     6.694   120.793     0.150
     6.694   173.191     0.150
     6.694   206.992     0.150
     6.903   101.094     0.150
     6.903   213.391     0.150
     6.903   100.992     0.150
     6.903   122.992     0.150
     7.545   233.492     0.150
     8.290   257.293     0.150
     8.527   264.391     0.150
     9.099   281.594     0.150
    10.075   311.191     0.150
    14.024   199.586     0.150
    14.024   438.266     0.150
    14.277   444.387     0.150
    14.277   199.492     0.150
    17.950   250.391     0.150
    17.950   249.918     0.150
    17.950   563.766     0.150
    17.950   250.391     0.150
    18.479   255.293     0.150
    18.564   255.516     0.150
    20.479   277.785     0.150
    20.479   638.211     0.150
    20.479   276.891     0.150
    20.817   284.098     0.150
    22.645   301.566     0.150
    24.641   317.992     0.150
    48.893   526.492     0.150
    70.612   675.941     0.150
   145.857  1180.008     0.150
     0.202     4.794     0.150
     0.202     7.894     0.150
     0.401     8.094     0.150
     0.401    13.894     0.150
     0.585    11.594     0.150
     0.585    19.894     0.150
     0.655    12.194     0.150
     0.655    21.594     0.150
     0.961    17.494     0.150
     0.961    30.394     0.150
     0.961    17.394     0.150
     0.961    29.994     0.150
     1.140    20.994     0.150
     1.140    36.394     0.150
     1.415    25.294     0.150
     1.415    44.694     0.150
     1.415    25.594     0.150
     1.585    28.494     0.150
     1.585    49.894     0.150
     1.682    29.994     0.150
     1.682    51.594     0.150
     1.682    53.094     0.150
     1.722    31.694     0.150
     1.975    35.194     0.150
     1.975    61.694     0.150
     2.190    35.894     0.150
     2.190    38.394     0.150
     2.190    67.394     0.150
     2.190    38.094     0.150
     2.190    62.794     0.150
     2.285    41.194     0.150
     2.285    71.894     0.150
     2.485    43.694     0.150
     2.485    75.694     0.150
     2.677    43.694     0.150
     2.677    48.294     0.150
     2.677    83.894     0.150
     2.784    85.394     0.150
     2.980    46.594     0.150
     2.980    53.294     0.150
     2.980    91.794     0.150
     2.980    52.494     0.150
     2.928    46.194     0.150
     2.928    52.494     0.150
     2.928    91.394     0.150
     3.356    58.894     0.150
     3.356   101.894     0.150
     3.380   104.494     0.150
     3.396    60.594     0.150
     3.396   105.194     0.150
     3.396    53.294     0.150
     3.687    64.894     0.150
     3.687    67.294     0.150
     3.687   113.794     0.150
     3.687    57.294     0.150
     3.687    65.794     0.150
     3.687   112.694     0.150
     3.955    59.994     0.150
     3.955    70.694     0.150
     3.955   122.294     0.150
     4.390    79.194     0.150
     4.390   136.794     0.150
     4.412    65.894     0.150
     4.412    79.394     0.150
     4.412   114.394     0.150
     4.412   137.194     0.150
     4.871    86.594     0.150
     4.871   150.394     0.150
     5.214    92.694     0.150
     5.214   160.494     0.150
     5.297    81.994     0.150
     5.297    94.694     0.150
     5.297   141.194     0.150
     5.297   163.494     0.150
     5.452   166.894     0.150
     5.587   100.994     0.150
     5.587   173.394     0.150
     5.587    83.394     0.150
     6.640   204.294     0.150
     6.874   212.094     0.150
     7.305   226.194     0.150
     7.545   232.994     0.150
     8.244   254.194     0.150
     9.108   282.494     0.150
    17.975   250.294     0.150
     0.194     4.787     0.150
     0.194     8.287     0.150
     0.734    13.887     0.150
     0.734    24.787     0.150
     1.096    19.987     0.150
     1.096    35.587     0.150
     1.318    23.887     0.150
     1.318    42.387     0.150
     1.398    25.087     0.150
     1.398    44.087     0.150
     1.587    26.987     0.150
     1.587    27.787     0.150
     1.587    49.387     0.150
     1.908    33.887     0.150
     2.114    37.287     0.150
     2.114    66.687     0.150
     2.267    36.487     0.150
     2.267    40.687     0.150
     2.267    70.187     0.150
     2.316    41.287     0.150
     2.316    71.387     0.150
     2.389    42.187     0.150
     2.389    74.387     0.150
     2.534    44.187     0.150
     2.534    78.087     0.150
     2.642    46.087     0.150
     2.642    80.787     0.150
     2.585    41.487     0.150
     2.585    45.287     0.150
     2.585    80.787     0.150
     2.961    47.187     0.150
     2.961    51.487     0.150
     2.961    54.287     0.150
     2.961    91.387     0.150
     3.091    55.787     0.150
     3.091    96.487     0.150
     3.748    56.487     0.150
     3.748    66.987     0.150
     3.748   116.687     0.150
     4.071    60.687     0.150
     4.071    72.087     0.150
     4.071   106.387     0.150
     4.071   124.387     0.150
     4.227   131.587     0.150
     4.817    85.887     0.150
     4.817   148.587     0.150
     4.934   151.187     0.150
     5.142    91.687     0.150
     5.142   160.087     0.150
     5.736   178.687     0.150
     5.888   104.487     0.150
     5.888   181.487     0.150
     6.003    87.987     0.150
     6.003   105.887     0.150
     6.003   184.287     0.150
     6.160   191.187     0.150
     6.175    91.687     0.150
     6.175   192.087     0.150
     6.716   206.187     0.150
     7.432   228.287     0.150
     8.169   252.787     0.150
     0.066     3.691     0.150
     0.066     6.289     0.150
     0.788    14.789     0.150
     0.788    26.590     0.150
     1.167    21.391     0.150
     1.167    37.590     0.150
     1.339    24.191     0.150
     1.339    42.789     0.150
     1.391    24.590     0.150
     1.391    43.289     0.150
     1.399    25.488     0.150
     1.399    44.789     0.150
     1.463    25.391     0.150
     1.463    45.488     0.150
     2.180    37.891     0.150
     2.180    66.488     0.150
     2.180    67.891     0.150
     2.221    39.789     0.150
     2.221    69.691     0.150
     2.316    37.391     0.150
     2.316    41.191     0.150
     2.316    72.191     0.150
     2.401    42.391     0.150
     2.401    73.988     0.150
     2.476    43.988     0.150
     2.476    77.590     0.150
     2.595    47.789     0.150
     2.595    82.691     0.150
     2.712    82.488     0.150
     2.686    47.988     0.150
     2.686    84.191     0.150
     2.863    44.891     0.150
     2.863    50.191     0.150
     2.863    88.090     0.150
     3.158    98.289     0.150
     3.811   118.391     0.150
     4.195    62.488     0.150
     4.195    74.488     0.150
     4.195    76.391     0.150
     4.195   109.691     0.150
     4.195   128.789     0.150
     4.861   149.691     0.150
     5.799   178.988     0.150
     5.778   179.090     0.150
     5.967   183.191     0.150
     6.194   192.090     0.150
     0.329     6.844     0.150
     0.329    11.945     0.150
     0.346     7.148     0.150
     0.346    11.844     0.150
     0.346    12.047     0.150
     0.453     8.742     0.150
     0.453    15.242     0.150
     0.563    19.344     0.150
     0.785    15.148     0.150
     0.785    25.547     0.150
     1.108    19.945     0.150
     1.108    34.742     0.150
     1.108    36.844     0.150
     1.159    22.547     0.150
     1.159    37.742     0.150
     1.339    24.148     0.150
     1.339    42.242     0.150
     1.704    30.445     0.150
     1.704    31.344     0.150
     1.704    53.844     0.150
     1.718    30.547     0.150
     1.718    31.547     0.150
     1.718    54.844     0.150
     1.749    32.648     0.150
     1.749    55.844     0.150
     1.750    32.242     0.150
     1.750    55.844     0.150
     2.052    35.344     0.150
     2.052    37.742     0.150
     2.052    65.148     0.150
     2.217    37.445     0.150
     2.217    39.547     0.150
     2.217    63.844     0.150
     2.217    68.242     0.150
     2.217    39.844     0.150
     2.217    68.945     0.150
     2.241    38.047     0.150
     2.241    40.445     0.150
     2.241    69.547     0.150
     2.375    40.242     0.150
     2.375    42.742     0.150
     2.375    68.945     0.150
     2.375    72.445     0.150
     2.375    39.047     0.150
     2.375    68.547     0.150
     2.375    72.945     0.150
     2.625    43.242     0.150
     2.625    48.242     0.150
     2.625    75.445     0.150
     2.625    81.344     0.150
     2.625    43.445     0.150
     2.625    46.945     0.150
     2.625    74.445     0.150
     2.625    81.047     0.150
     2.686    48.945     0.150
     2.686    83.047     0.150
     2.686    48.547     0.150
     2.686    82.742     0.150
     2.867    47.242     0.150
     2.867    52.648     0.150
     2.867    82.242     0.150
     2.867    88.547     0.150
     2.867    46.945     0.150
     2.867    51.648     0.150
     2.867    80.344     0.150
     2.941    47.344     0.150
     2.941    51.844     0.150
     2.941    90.547     0.150
     2.941    47.547     0.150
     2.941    52.344     0.150
     2.941    90.742     0.150
     3.323    59.344     0.150
     3.323   102.047     0.150
     3.320    53.148     0.150
     3.320    59.844     0.150
     3.320    92.547     0.150
     3.320   101.445     0.150
     3.320    52.945     0.150
     3.320    59.742     0.150
     3.320    90.844     0.150
     3.320   101.242     0.150
     3.320   102.844     0.150
     3.617    65.047     0.150
     3.617   112.344     0.150
     3.740    58.445     0.150
     3.740    67.445     0.150
     3.740   115.242     0.150
     3.740    58.547     0.150
     3.740    67.648     0.150
     3.740   115.742     0.150
     3.842    62.344     0.150
     3.842    68.148     0.150
     3.842   116.844     0.150
     3.842    59.945     0.150
     3.842    69.047     0.150
     3.842   103.945     0.150
     3.842   120.242     0.150
     4.054    73.148     0.150
     4.054   126.047     0.150
     4.368    67.547     0.150
     4.368    78.742     0.150
     4.368   136.742     0.150
     4.368    67.742     0.150
     4.368    79.844     0.150
     4.368   136.844     0.150
     4.659    69.547     0.150
     4.659    83.242     0.150
     4.659   122.148     0.150
     4.659   142.844     0.150
     4.659    84.148     0.150
     4.659   122.344     0.150
     4.659   143.844     0.150
     4.750    74.547     0.150
     4.750    86.844     0.150
     4.750   145.945     0.150
     4.750    85.344     0.150
     4.750   146.945     0.150
     5.132    79.547     0.150
     5.132    93.844     0.150
     5.132   136.844     0.150
     5.132   158.344     0.150
     5.132    79.844     0.150
     5.132   134.547     0.150
     5.132   158.648     0.150
     5.254    79.148     0.150
     5.254    95.547     0.150
     5.254   163.445     0.150
     5.415    80.844     0.150
     5.415    98.047     0.150
     5.415   140.945     0.150
     5.415   168.148     0.150
     5.727    86.047     0.150
     5.727   103.648     0.150
     5.727   178.445     0.150
     5.823    87.469     0.150
     5.823   105.383     0.150
     5.823   181.883     0.150
     6.393   198.148     0.150
     6.694   207.148     0.150
     7.019   102.547     0.150
     7.019   102.648     0.150
     7.184   222.047     0.150
     7.368   227.844     0.150
     8.257   117.695     0.150
     8.415   260.844     0.150
     8.921   276.648     0.150
    13.802   196.523     0.150
    13.802   428.805     0.150
    14.223   437.938     0.150
    17.826   247.211     0.150
    18.288   252.844     0.150
    18.374   252.797     0.150
    18.482   255.617     0.150
    18.482   577.094     0.150
    20.301   275.586     0.150
    20.301   629.711     0.150
    22.414   298.281     0.150
    48.784   525.344     0.150
    80.061   729.945     0.150
     0.255     5.212     0.150
     0.255     8.712     0.150
     0.302     6.612     0.150
     0.302    11.712     0.150
     0.300     6.012     0.150
     0.300    10.212     0.150
     0.635    12.212     0.150
     0.635    21.012     0.150
     0.647    13.212     0.150
     0.647    22.512     0.150
     0.961    18.112     0.150
     0.961    31.712     0.150
     1.173    22.012     0.150
     1.173    37.212     0.150
     1.195    22.412     0.150
     1.195    38.112     0.150
     1.232    23.512     0.150
     1.232    40.012     0.150
     1.260    23.412     0.150
     1.260    40.812     0.150
     1.260    44.112     0.150
     1.423    25.112     0.150
     1.423    43.812     0.150
     1.514    27.712     0.150
     1.514    48.512     0.150
     1.799    33.112     0.150
     2.194    37.012     0.150
     2.194    39.912     0.150
     2.194    68.912     0.150
     2.331    72.612     0.150
     2.449    44.112     0.150
     2.449    76.912     0.150
     2.683    47.512     0.150
     2.683    82.112     0.150
     2.914    46.512     0.150
     2.914    52.912     0.150
     2.914    90.612     0.150
     2.923    46.112     0.150
     2.923    52.712     0.150
     2.923    90.812     0.150
     3.459    53.712     0.150
     3.459    61.812     0.150
     3.459   107.412     0.150
     3.511    55.312     0.150
     3.511    63.612     0.150
     3.511   109.212     0.150
     3.615   111.512     0.150
     3.838   118.912     0.150
     3.897    71.212     0.150
     3.897   122.212     0.150
     4.178    63.912     0.150
     4.178    75.212     0.150
     4.178   129.212     0.150
     4.368    67.012     0.150
     4.368    78.612     0.150
     4.368   135.812     0.150
     4.432    79.812     0.150
     4.432   119.312     0.150
     4.432   138.112     0.150
     4.917    74.812     0.150
     4.917   129.712     0.150
     4.917   152.912     0.150
     5.199    94.012     0.150
     5.199   162.112     0.150
     5.707   101.912     0.150
     5.707   175.812     0.150
     5.933   183.212     0.150
     6.863   213.412     0.150
     7.130   128.712     0.150
     7.130   220.212     0.150
     7.306   131.712     0.150
     7.306   226.112     0.150
     8.277   257.912     0.150
     8.763   271.212     0.150
     0.128     4.078     0.150
     0.128     7.078     0.150
     0.307     7.180     0.150
     0.307    11.375     0.150
     0.733    14.273     0.150
     0.733    24.375     0.150
     0.820    16.477     0.150
     0.820    27.477     0.150
     0.920    17.273     0.150
     0.920    29.578     0.150
     0.920    30.078     0.150
     1.376    25.078     0.150
     1.376    42.977     0.150
     1.370    25.578     0.150
     1.370    43.578     0.150
     1.398    25.977     0.150
     1.398    44.680     0.150
     1.477    26.477     0.150
     1.477    27.273     0.150
     1.477    45.875     0.150
     1.509    26.578     0.150
     1.509    45.977     0.150
     1.509    27.375     0.150
     1.509    46.180     0.150
     1.509    47.477     0.150
     1.750    30.477     0.150
     1.750    31.875     0.150
     1.750    54.977     0.150
     1.800    32.578     0.150
     1.800    55.078     0.150
     1.800    57.180     0.150
     1.830    31.977     0.150
     1.830    33.180     0.150
     1.830    34.180     0.150
     1.830    57.180     0.150
     2.209    37.273     0.150
     2.209    39.375     0.150
     2.209    61.977     0.150
     2.209    68.273     0.150
     2.263    37.180     0.150
     2.263    40.578     0.150
     2.263    65.477     0.150
     2.263    70.078     0.150
     2.263    37.773     0.150
     2.263    40.977     0.150
     2.263    64.977     0.150
     2.263    69.578     0.150
     2.448    40.578     0.150
     2.448    43.477     0.150
     2.448    70.875     0.150
     2.448    75.273     0.150
     2.635    42.375     0.150
     2.635    81.078     0.150
     2.635    47.273     0.150
     2.635    73.680     0.150
     2.635    81.273     0.150
     2.704    44.078     0.150
     2.704    48.773     0.150
     2.704    82.273     0.150
     2.704    43.773     0.150
     2.704    47.977     0.150
     2.704    73.875     0.150
     2.704    81.875     0.150
     2.898    46.273     0.150
     2.898    51.773     0.150
     2.898    80.477     0.150
     2.898    88.977     0.150
     2.898    46.375     0.150
     2.898    51.977     0.150
     2.898    80.578     0.150
     2.898    88.477     0.150
     3.327    51.875     0.150
     3.327    58.875     0.150
     3.327   101.773     0.150
     3.421    61.273     0.150
     3.421   105.773     0.150
     3.421    53.773     0.150
     3.421    92.977     0.150
     3.421   102.875     0.150
     3.421   106.078     0.150
     3.712    66.977     0.150
     3.712   114.578     0.150
     3.896    58.773     0.150
     3.896   102.078     0.150
     3.896   116.578     0.150
     3.896   121.273     0.150
     3.964    61.273     0.150
     3.964    72.078     0.150
     3.964   105.078     0.150
     3.964   123.180     0.150
     4.162    63.477     0.150
     4.162    74.078     0.150
     4.162   126.875     0.150
     4.162    63.578     0.150
     4.162    71.477     0.150
     4.162    75.375     0.150
     4.162   109.773     0.150
     4.162   128.773     0.150
     4.331    77.273     0.150
     4.331   133.078     0.150
     4.331    68.078     0.150
     4.331    76.977     0.150
     4.331   117.375     0.150
     4.331   133.273     0.150
     4.467    67.578     0.150
     4.467    79.680     0.150
     4.467   117.375     0.150
     4.467   136.875     0.150
     4.735    69.773     0.150
     4.735    85.078     0.150
     4.735   121.477     0.150
     4.735   146.977     0.150
     4.738    73.180     0.150
     4.738    85.375     0.150
     4.738   124.375     0.150
     4.738    72.078     0.150
     5.490    81.977     0.150
     5.490   140.375     0.150
     5.490   142.680     0.150
     5.490   170.477     0.150
     5.559    83.336     0.150
     5.559   175.914     0.150
     5.673    83.875     0.150
     5.673   101.773     0.150
     5.673   144.773     0.150
     5.673   175.078     0.150
     6.719    98.180     0.150
     6.719   171.477     0.150
     6.719   207.375     0.150
     6.765   209.180     0.150
     7.115   104.273     0.150
     7.115   180.578     0.150
     7.115   219.477     0.150
     7.425   107.477     0.150
     7.425   187.773     0.150
     7.425   229.375     0.150
     7.988   117.273     0.150
     7.988   203.180     0.150
     7.988   248.078     0.150
     8.520   120.109     0.150
     8.520   151.625     0.150
     8.520   263.250     0.150
    10.545   325.477     0.150
    17.421   244.453     0.150
    17.929   251.375     0.150
    18.014   251.328     0.150
    22.103   296.750     0.150
     0.279     5.484     0.150
     0.279     9.883     0.150
     0.456     9.184     0.150
     0.456    15.383     0.150
     0.331     7.184     0.150
     0.331    11.285     0.150
     1.145    20.984     0.150
     1.145    35.984     0.150
     1.145    20.785     0.150
     1.145    25.383     0.150
     1.145    36.586     0.150
     1.290    23.785     0.150
     1.290    41.285     0.150
     1.290    23.586     0.150
     1.659    30.383     0.150
     1.659    52.984     0.150
     1.667    30.484     0.150
     1.667    31.184     0.150
     1.667    52.883     0.150
     1.667    54.285     0.150
     1.698    31.883     0.150
     1.698    54.383     0.150
     2.002    35.285     0.150
     2.002    37.184     0.150
     2.002    63.484     0.150
     2.127    37.086     0.150
     2.127    39.184     0.150
     2.127    65.684     0.150
     2.191    37.883     0.150
     2.191    40.285     0.150
     2.191    68.883     0.150
     2.267    38.285     0.150
     2.267    40.184     0.150
     2.267    69.984     0.150
     2.424    41.184     0.150
     2.424    42.785     0.150
     2.424    69.785     0.150
     2.424    73.285     0.150
     2.424    43.785     0.150
     2.424    70.684     0.150
     2.424    74.586     0.150
     2.575    43.383     0.150
     2.575    47.184     0.150
     2.575    80.684     0.150
     2.575    43.484     0.150
     2.575    74.383     0.150
     2.575    80.484     0.150
     2.640    42.484     0.150
     2.640    46.883     0.150
     2.640    81.383     0.150
     2.640    43.383     0.150
     2.640    47.086     0.150
     2.640    75.586     0.150
     2.640    81.586     0.150
     2.817    46.785     0.150
     2.817    51.184     0.150
     2.817    87.383     0.150
     2.817    50.883     0.150
     2.817    80.383     0.150
     2.992    49.684     0.150
     2.992    82.586     0.150
     2.992    92.984     0.150
     2.992    48.285     0.150
     2.992    93.086     0.150
     3.272    52.902     0.150
     3.272    58.004     0.150
     3.272    92.152     0.150
     3.272   100.301     0.150
     3.375   105.383     0.150
     3.630    56.086     0.150
     3.630    64.785     0.150
     3.630    98.586     0.150
     3.630   111.285     0.150
     3.630    57.484     0.150
     3.630    66.086     0.150
     3.630   100.184     0.150
     3.630   113.285     0.150
     3.789    59.785     0.150
     3.789    68.484     0.150
     3.789   103.285     0.150
     3.789   117.086     0.150
     3.797    67.984     0.150
     3.797   116.086     0.150
     4.105    73.883     0.150
     4.105   110.184     0.150
     4.105   128.285     0.150
     4.317    67.785     0.150
     4.317    79.285     0.150
     4.317   116.285     0.150
     4.317   135.383     0.150
     4.646    70.383     0.150
     4.646    84.184     0.150
     4.646   122.883     0.150
     4.646   144.184     0.150
     5.096    77.684     0.150
     5.096    79.684     0.150
     5.096   135.586     0.150
     5.096   158.086     0.150
     5.304    79.684     0.150
     5.304    95.586     0.150
     5.304   137.883     0.150
     5.304   163.684     0.150
     5.467    81.883     0.150
     5.467    98.285     0.150
     5.467   168.484     0.150
     5.683    85.684     0.150
     5.683   148.184     0.150
     5.683   177.883     0.150
     5.777    87.484     0.150
     5.777   182.605     0.150
     6.743   100.285     0.150
     6.743   208.785     0.150
     7.058   103.484     0.150
     7.058   126.285     0.150
     7.058   218.184     0.150
     7.140   106.484     0.150
     8.269   120.859     0.150
     8.269   258.133     0.150
     8.426   261.984     0.150
    13.779   197.512     0.150
    15.352   481.078     0.150
    17.786   248.008     0.150
    18.259   254.984     0.150
    18.345   254.934     0.150
    20.350   277.430     0.150
    22.393   301.395     0.150
    80.037   730.633     0.150
     0.301     5.781     0.150
     0.301    10.875     0.150
     0.488     8.875     0.150
     0.488    15.281     0.150
     0.627    12.578     0.150
     0.627    20.977     0.150
     1.049    19.875     0.150
     1.049    34.477     0.150
     1.220    22.281     0.150
     1.220    23.477     0.150
     1.220    38.781     0.150
     1.220    40.477     0.150
     1.272    23.680     0.150
     1.272    24.375     0.150
     1.272    40.578     0.150
     1.272    41.977     0.150
     1.334    23.977     0.150
     1.334    24.680     0.150
     1.334    41.477     0.150
     1.310    24.680     0.150
     1.310    41.680     0.150
     1.579    28.875     0.150
     1.579    29.375     0.150
     1.887    32.281     0.150
     1.887    34.781     0.150
     1.887    60.078     0.150
     2.282    38.180     0.150
     2.282    41.078     0.150
     2.282    66.180     0.150
     2.282    70.680     0.150
     2.419    43.781     0.150
     2.419    75.281     0.150
     2.537    41.375     0.150
     2.537    45.578     0.150
     2.537    72.875     0.150
     2.537    78.578     0.150
     2.601    41.977     0.150
     2.601    46.078     0.150
     2.601    80.281     0.150
     2.855    51.281     0.150
     2.855    88.680     0.150
     3.012    48.578     0.150
     3.012    54.477     0.150
     3.012    93.281     0.150
     3.385    53.180     0.150
     3.385    60.977     0.150
     3.385   104.875     0.150
     3.546    62.781     0.150
     3.546   108.578     0.150
     3.599    57.078     0.150
     3.599    64.680     0.150
     3.599   110.477     0.150
     3.981    72.180     0.150
     3.981   124.477     0.150
     4.092    63.281     0.150
     4.092    73.078     0.150
     4.092   125.781     0.150
     4.341    77.078     0.150
     4.341   114.477     0.150
     4.341   133.281     0.150
     4.520    68.781     0.150
     4.520    81.477     0.150
     4.520   140.180     0.150
     5.000    76.680     0.150
     5.000    90.578     0.150
     5.000   130.578     0.150
     5.000   155.875     0.150
     0.280     5.219     0.150
     0.280     9.820     0.150
     0.328     7.219     0.150
     0.328    11.422     0.150
     0.328    10.820     0.150
     0.459     9.219     0.150
     0.459    15.820     0.150
     1.110    22.016     0.150
     1.110    37.117     0.150
     1.146    21.016     0.150
     1.146    36.422     0.150
     1.146    20.820     0.150
     1.291    23.922     0.150
     1.291    41.719     0.150
     1.291    23.820     0.150
     1.662    30.422     0.150
     1.662    53.617     0.150
     1.670    30.516     0.150
     1.670    53.422     0.150
     1.701    32.117     0.150
     1.701    54.922     0.150
     1.701    31.516     0.150
     1.701    54.719     0.150
     2.005    35.422     0.150
     2.005    37.320     0.150
     2.005    64.219     0.150
     2.129    39.219     0.150
     2.129    66.117     0.150
     2.192    37.016     0.150
     2.192    39.516     0.150
     2.192    68.320     0.150
     2.192    40.016     0.150
     2.192    65.219     0.150
     2.192    68.516     0.150
     2.266    38.117     0.150
     2.266    40.422     0.150
     2.266    70.219     0.150
     2.266    41.016     0.150
     2.266    66.320     0.150
     2.266    70.016     0.150
     2.576    43.422     0.150
     2.576    47.422     0.150
     2.576    75.117     0.150
     2.576    80.219     0.150
     2.640    44.219     0.150
     2.640    46.922     0.150
     2.640    76.117     0.150
     2.640    82.117     0.150
     2.640    47.820     0.150
     2.640    76.219     0.150
     2.640    81.820     0.150
     2.818    46.719     0.150
     2.818    50.922     0.150
     2.818    79.422     0.150
     2.818    87.719     0.150
     2.990    49.820     0.150
     2.990    54.117     0.150
     2.990    90.719     0.150
     2.990    48.617     0.150
     2.990    54.016     0.150
     2.990    82.422     0.150
     2.990    92.219     0.150
     3.272    52.914     0.150
     3.272   101.039     0.150
     3.272    52.516     0.150
     3.373    60.219     0.150
     3.373   103.719     0.150
     3.633    66.117     0.150
     3.633    99.820     0.150
     3.633   113.117     0.150
     3.788    59.516     0.150
     3.788    68.820     0.150
     3.788   116.422     0.150
     3.788    59.617     0.150
     3.788    68.516     0.150
     3.788   103.117     0.150
     3.788   117.016     0.150
     4.319    67.719     0.150
     4.319   134.320     0.150
     4.319    67.016     0.150
     4.319    78.516     0.150
     4.319   118.219     0.150
     4.319   134.516     0.150
     4.650    70.016     0.150
     4.650    82.617     0.150
     4.650   122.617     0.150
     4.650   143.422     0.150
     4.650    84.516     0.150
     4.650   123.016     0.150
     4.650   144.516     0.150
     4.706    74.820     0.150
     4.706    86.922     0.150
     4.706   128.320     0.150
     4.706    74.422     0.150
     4.706    84.516     0.150
     4.706   128.617     0.150
     4.706   145.219     0.150
     5.095    79.820     0.150
     5.095   137.422     0.150
     5.095   136.422     0.150
     5.095   158.117     0.150
     5.303    80.617     0.150
     5.303    95.922     0.150
     5.303   164.617     0.150
     5.465    82.820     0.150
     5.465   142.922     0.150
     5.465   168.320     0.150
     5.686    85.820     0.150
     5.686    86.219     0.150
     5.686   103.422     0.150
     5.686   149.516     0.150
     5.686   177.617     0.150
     5.780    87.656     0.150
     5.780   183.367     0.150
     6.440   116.117     0.150
     6.440   165.820     0.150
     6.440   199.320     0.150
     6.743   100.016     0.150
     6.743   208.516     0.150
     7.059   103.422     0.150
     7.059   103.219     0.150
     7.059   181.219     0.150
     7.140   106.719     0.150
     7.140   220.320     0.150
     8.268   122.922     0.150
     8.268   150.516     0.150
     8.268   210.719     0.150
     8.268   257.320     0.150
     8.272   119.539     0.150
     8.272   259.141     0.150
     8.429   122.320     0.150
     8.429   261.719     0.150
    10.168   315.219     0.150
    13.776   195.344     0.150
    13.776   429.117     0.150
    14.272   441.688     0.150
    17.786   248.820     0.150
    17.786   246.422     0.150
    17.786   248.820     0.150
    18.257   254.219     0.150
    18.343   253.266     0.150
    18.503   254.922     0.150
    18.503   577.969     0.150
    18.503   257.219     0.150
    20.347   275.141     0.150
    20.347   633.688     0.150
    20.347   275.719     0.150
    21.113   286.422     0.150
    22.391   299.266     0.150
    41.996   471.219     0.150
    76.579   710.172     0.150
    76.579   712.422     0.150
    80.041   729.820     0.150
    80.041   730.820     0.150
     0.320     6.699     0.150
     0.320    11.297     0.150
     0.287     6.199     0.150
     0.287    10.598     0.150
     0.470     8.699     0.150
     0.470    14.996     0.150
     0.548    10.598     0.150
     0.548    18.098     0.150
     0.762    14.199     0.150
     0.762    24.797     0.150
     1.147    35.797     0.150
     1.296    23.297     0.150
     1.296    40.699     0.150
     1.296    42.297     0.150
     1.681    30.898     0.150
     1.681    52.297     0.150
     1.681    53.898     0.150
     1.676    30.098     0.150
     1.676    30.797     0.150
     1.676    51.598     0.150
     1.676    53.297     0.150
     1.710    30.898     0.150
     1.710    31.699     0.150
     1.710    54.797     0.150
     1.712    31.699     0.150
     1.712    54.297     0.150
     2.018    34.996     0.150
     2.018    36.797     0.150
     2.018    60.699     0.150
     2.018    64.199     0.150
     2.199    37.398     0.150
     2.199    40.098     0.150
     2.199    64.098     0.150
     2.199    68.898     0.150
     2.259    37.496     0.150
     2.259    40.199     0.150
     2.259    69.797     0.150
     2.408    40.496     0.150
     2.408    42.598     0.150
     2.408    72.996     0.150
     2.582    42.898     0.150
     2.582    45.797     0.150
     2.582    73.996     0.150
     2.582    79.699     0.150
     2.644    42.797     0.150
     2.644    47.496     0.150
     2.644    81.398     0.150
     2.824    46.398     0.150
     2.824    50.699     0.150
     2.824    86.996     0.150
     2.980    47.598     0.150
     2.980    52.699     0.150
     2.980    91.398     0.150
     3.278    51.797     0.150
     3.278    58.598     0.150
     3.278    90.496     0.150
     3.278   100.398     0.150
     3.363   104.398     0.150
     3.642   114.098     0.150
     4.327    66.699     0.150
     4.327    78.199     0.150
     4.327   134.996     0.150
     4.663    83.898     0.150
     4.663   122.098     0.150
     4.663   144.898     0.150
     4.708    71.797     0.150
     4.708    83.699     0.150
     4.708   125.199     0.150
     4.708   144.797     0.150
     5.297   164.598     0.150
     5.454   167.496     0.150
     0.131     3.836     0.150
     0.131     6.637     0.150
     0.434     8.734     0.150
     0.434    15.234     0.150
     0.528    10.836     0.150
     0.528    18.934     0.150
     0.692    13.035     0.150
     0.692    22.637     0.150
     0.670    13.234     0.150
     0.670    22.434     0.150
     0.670    22.535     0.150
     0.873    15.836     0.150
     0.873    27.535     0.150
     0.873    27.637     0.150
     1.206    22.535     0.150
     1.206    39.934     0.150
     1.500    26.637     0.150
     1.500    47.137     0.150
     1.500    27.836     0.150
     1.741    31.137     0.150
     1.741    31.934     0.150
     1.741    32.934     0.150
     1.741    55.836     0.150
     1.783    32.934     0.150
     1.822    31.836     0.150
     1.822    34.137     0.150
     1.822    58.137     0.150
     2.020    34.637     0.150
     2.020    36.434     0.150
     2.020    63.734     0.150
     2.125    35.434     0.150
     2.125    37.336     0.150
     2.125    61.336     0.150
     2.125    63.637     0.150
     2.125    66.035     0.150
     2.362    42.434     0.150
     2.362    72.336     0.150
     2.362    38.434     0.150
     2.362    68.434     0.150
     2.362    73.934     0.150
     2.465    40.637     0.150
     2.465    44.234     0.150
     2.465    76.035     0.150
     2.465    40.535     0.150
     2.465    76.434     0.150
     2.755    43.934     0.150
     2.755    49.637     0.150
     2.755    86.234     0.150
     2.755    44.035     0.150
     2.755    76.934     0.150
     2.870    51.934     0.150
     2.870    88.137     0.150
     2.870    45.934     0.150
     2.870    51.336     0.150
     2.870    80.234     0.150
     2.870    88.035     0.150
     2.935    46.836     0.150
     2.935    52.336     0.150
     2.935    90.234     0.150
     3.008    47.637     0.150
     3.008    53.734     0.150
     3.008    92.934     0.150
     3.008    54.234     0.150
     3.008    84.234     0.150
     3.008    93.535     0.150
     3.292    50.535     0.150
     3.292    59.836     0.150
     3.292   101.934     0.150
     3.292    51.336     0.150
     3.292    58.836     0.150
     3.292    89.035     0.150
     3.292   101.434     0.150
     3.308    59.836     0.150
     3.308   103.234     0.150
     3.308    52.336     0.150
     3.308   103.336     0.150
     3.478    53.852     0.150
     3.478   105.930     0.150
     3.478    53.734     0.150
     3.478    62.535     0.150
     3.478   106.836     0.150
     3.478    54.035     0.150
     3.478    92.535     0.150
     3.478   108.137     0.150
     3.614    55.836     0.150
     3.614    64.836     0.150
     3.614   111.234     0.150
     3.614    62.836     0.150
     3.614    64.637     0.150
     3.614   111.434     0.150
     3.971    61.035     0.150
     3.971    71.434     0.150
     3.971   123.637     0.150
     4.043    62.836     0.150
     4.043    72.336     0.150
     4.043   124.234     0.150
     4.043    62.434     0.150
     4.043   124.734     0.150
     4.357    65.137     0.150
     4.357    78.137     0.150
     4.357   114.734     0.150
     4.357   135.836     0.150
     4.960    76.836     0.150
     4.960    88.434     0.150
     4.960   134.535     0.150
     4.960    76.434     0.150
     4.960    85.336     0.150
     4.960    88.836     0.150
     4.960   133.336     0.150
     4.960   153.336     0.150
     5.144    76.336     0.150
     5.144    92.035     0.150
     5.144    93.434     0.150
     5.144   160.336     0.150
     5.403    79.637     0.150
     5.403    96.637     0.150
     5.403    79.934     0.150
     5.403    96.434     0.150
     5.403   138.836     0.150
     5.391    81.836     0.150
     5.391    95.637     0.150
     5.391    82.035     0.150
     5.391   141.137     0.150
     5.601    84.434     0.150
     5.601    83.434     0.150
     5.601   101.637     0.150
     5.601   175.137     0.150
     5.720    85.914     0.150
     5.720   102.297     0.150
     5.720   177.613     0.150
     6.784    98.535     0.150
     6.784   120.637     0.150
     6.784    98.734     0.150
     6.784   210.234     0.150
     7.417   230.934     0.150
     7.393   111.234     0.150
     7.393   107.637     0.150
     7.393   187.336     0.150
     7.393   229.137     0.150
     7.638   236.535     0.150
     7.930   113.109     0.150
     7.930   244.836     0.150
     8.087   146.734     0.150
     8.087   250.836     0.150
     8.087   114.875     0.150
     8.162   252.535     0.150
     8.606   125.434     0.150
     8.606   155.734     0.150
     8.606   218.637     0.150
     8.606   267.734     0.150
     8.796   271.637     0.150
    12.039   300.137     0.150
    14.151   436.379     0.150
    14.151   197.137     0.150
    14.151   355.336     0.150
    14.111   200.742     0.150
    14.111   439.590     0.150
    14.111   205.234     0.150
    14.111   198.695     0.150
    14.313   200.535     0.150
    15.152   217.434     0.150
    17.752   557.969     0.150
    17.854   248.934     0.150
    17.854   248.156     0.150
    17.855   558.137     0.150
    18.067   252.137     0.150
    18.067   250.336     0.150
    18.067   249.785     0.150
    18.578   259.137     0.150
    18.578   254.496     0.150
    18.664   256.484     0.150
    18.664   584.465     0.150
    18.751   255.836     0.150
    18.751   584.059     0.150
    18.751   259.434     0.150
    18.751   258.254     0.150
    20.376   274.902     0.150
    20.376   275.234     0.150
    20.936   525.836     0.150
    21.669   289.934     0.150
    22.632   302.234     0.150
    22.632   299.875     0.150
    22.728   300.711     0.150
    24.513   320.336     0.150
    24.995   322.055     0.150
    24.995   322.434     0.150
    24.995   321.273     0.150
    27.074   341.836     0.150
    27.074   341.336     0.150
    28.536   356.336     0.150
    28.536   403.734     0.150
    28.536   546.137     0.150
    28.536   644.535     0.150
    28.536   724.137     0.150
    28.914   357.910     0.150
    28.914   356.523     0.150
    29.482   363.734     0.150
    30.226   370.094     0.150
    30.226   369.137     0.150
    30.483   372.234     0.150
    30.655   374.934     0.150
    30.655   373.254     0.150
    32.577   393.434     0.150
    35.646   416.637     0.150
    35.646   415.656     0.150
    35.836   420.035     0.150
    40.416   459.137     0.150
    40.416   554.934     0.150
    42.314   472.336     0.150
    42.314   473.836     0.150
    43.095   480.934     0.150
    43.242   481.836     0.150
    43.785   484.566     0.150
    45.062   495.035     0.150
    45.144   495.707     0.150
    46.250   504.977     0.150
    46.530   507.184     0.150
    46.634   508.305     0.150
    46.747   508.895     0.150
    47.715   516.145     0.150
    48.138   518.789     0.150
    48.547   522.855     0.150
    48.562   522.945     0.150
    48.565   523.129     0.150
    48.738   524.324     0.150
    48.774   524.613     0.150
    48.774   523.984     0.150
    48.774   524.535     0.150
    48.774   524.434     0.150
    50.489   537.715     0.150
    50.499   537.637     0.150
    50.996   542.234     0.150
    50.996   542.734     0.150
    50.996   542.016     0.150
    51.584   545.824     0.150
    55.453   574.934     0.150
    55.453   576.035     0.150
    57.996   591.969     0.150
    59.582   601.559     0.150
    59.582   602.035     0.150
    67.239   653.711     0.150
    67.239   653.227     0.150
    70.642   675.109     0.150
    70.642   675.844     0.150
    71.607   680.316     0.150
    73.583   692.195     0.150
    75.516   703.547     0.150
    76.323   707.809     0.150
    76.323   708.035     0.150
    76.323   707.246     0.150
    76.376   707.535     0.150
    76.670   710.406     0.150
    78.771   721.035     0.150
    78.771   721.977     0.150
    79.790   727.336     0.150
    79.790   727.156     0.150
    79.974   728.734     0.150
    79.974   729.047     0.150
    89.369   776.043     0.150
   145.976  1177.051     0.150
   151.028  1190.684     0.150
     0.336     7.211     0.150
     0.336    12.008     0.150
     0.459     9.008     0.150
     0.459    15.309     0.150
     0.557    10.910     0.150
     0.557    18.508     0.150
     0.776    14.711     0.150
     0.776    25.211     0.150
     1.122    20.309     0.150
     1.122    35.309     0.150
     1.145    36.609     0.150
     1.145    38.508     0.150
     1.323    24.711     0.150
     1.323    41.910     0.150
     1.323    23.910     0.150
     1.694    30.309     0.150
     1.694    31.008     0.150
     1.694    53.508     0.150
     1.704    30.309     0.150
     1.704    31.410     0.150
     1.704    53.410     0.150
     1.735    31.809     0.150
     1.735    55.410     0.150
     1.735    32.211     0.150
     1.735    31.410     0.150
     1.735    32.109     0.150
     1.735    55.309     0.150
     2.039    35.309     0.150
     2.039    37.309     0.150
     2.039    64.609     0.150
     2.233    37.609     0.150
     2.233    39.809     0.150
     2.233    65.508     0.150
     2.233    69.211     0.150
     2.233    37.508     0.150
     2.233    39.910     0.150
     2.226    37.711     0.150
     2.226    40.211     0.150
     2.226    64.309     0.150
     2.226    69.109     0.150
     2.388    40.109     0.150
     2.388    42.211     0.150
     2.388    69.609     0.150
     2.388    73.309     0.150
     2.609    43.008     0.150
     2.609    46.309     0.150
     2.609    74.410     0.150
     2.609    80.410     0.150
     2.670    74.809     0.150
     2.670    82.008     0.150
     2.670    47.309     0.150
     2.956    47.711     0.150
     2.956    52.211     0.150
     2.956    80.609     0.150
     2.956    91.008     0.150
     2.851    46.809     0.150
     2.851    51.711     0.150
     2.851    81.508     0.150
     2.851    88.008     0.150
     3.338   102.711     0.150
     3.304    52.602     0.150
     3.304    58.562     0.150
     3.304    92.492     0.150
     3.304   100.297     0.150
     3.626    56.711     0.150
     3.626    65.809     0.150
     3.626    98.711     0.150
     3.626   112.508     0.150
     3.626    55.609     0.150
     3.626    64.309     0.150
     3.626    98.609     0.150
     3.626   113.309     0.150
     3.756    58.508     0.150
     3.756    66.711     0.150
     3.756    99.910     0.150
     3.756   115.309     0.150
     4.353    67.809     0.150
     4.353    78.508     0.150
     4.353   116.211     0.150
     4.353   135.508     0.150
     4.661    84.109     0.150
     4.661   122.109     0.150
     4.661   144.309     0.150
     4.661    82.309     0.150
     4.661   122.008     0.150
     4.661   143.410     0.150
     4.734    73.410     0.150
     4.734    84.910     0.150
     4.734   129.109     0.150
     4.734   145.711     0.150
     4.734    86.211     0.150
     5.118    79.410     0.150
     5.118   158.109     0.150
     5.270    79.410     0.150
     5.270    94.809     0.150
     5.270   163.211     0.150
     5.430    81.711     0.150
     5.430    97.008     0.150
     5.430   140.711     0.150
     5.430   166.508     0.150
     5.812    87.043     0.150
     5.812   103.895     0.150
     5.812   179.336     0.150
     7.034   101.910     0.150
     7.034   125.711     0.150
     8.266   118.793     0.150
     8.266   257.078     0.150
    13.790   424.992     0.150
    17.811   250.070     0.150
    17.849   249.145     0.150
    18.275   256.211     0.150
    18.361   256.242     0.150
    22.402   298.172     0.150
    76.596   710.883     0.150
    80.059   730.578     0.150
     0.244     5.398     0.150
     0.253     6.297     0.150
     0.253    10.398     0.150
     0.383     7.898     0.150
     0.383    13.102     0.150
     0.448     8.602     0.150
     0.448    14.500     0.150
     0.537    11.000     0.150
     0.537    18.203     0.150
     0.876    16.602     0.150
     0.876    29.297     0.150
     1.158    21.102     0.150
     1.158    37.398     0.150
     1.158    39.102     0.150
     1.370    24.797     0.150
     1.370    25.500     0.150
     1.370    43.000     0.150
     1.370    45.102     0.150
     1.424    26.203     0.150
     1.424    44.703     0.150
     1.461    26.898     0.150
     1.461    46.203     0.150
     1.487    28.102     0.150
     1.487    47.797     0.150
     1.733    31.297     0.150
     1.733    54.398     0.150
     2.019    37.000     0.150
     2.019    63.102     0.150
     2.455    43.898     0.150
     2.455    76.500     0.150
     2.528    46.000     0.150
     2.528    78.500     0.150
     2.664    43.102     0.150
     2.664    47.297     0.150
     2.664    81.500     0.150
     2.701    48.297     0.150
     2.701    83.500     0.150
     3.133    55.703     0.150
     3.133    96.297     0.150
     3.232    57.602     0.150
     3.232    99.703     0.150
     3.521    63.398     0.150
     3.521   109.297     0.150
     3.610   111.102     0.150
     3.954    70.797     0.150
     3.954   122.703     0.150
     4.123    74.203     0.150
     4.123   128.500     0.150
     4.406    78.703     0.150
     4.406   116.000     0.150
     4.406   136.297     0.150
     4.622    82.102     0.150
     4.622   141.797     0.150
     5.075    78.000     0.150
     5.075   156.500     0.150
     0.261     6.070     0.150
     0.261    10.070     0.150
     0.443     8.672     0.150
     0.443    14.875     0.150
     0.448     8.773     0.150
     0.448    14.773     0.150
     0.561    11.070     0.150
     0.561    18.570     0.150
     0.588    12.273     0.150
     0.588    21.172     0.150
     0.730    13.570     0.150
     0.730    23.969     0.150
     1.149    21.672     0.150
     1.149    22.172     0.150
     1.149    36.672     0.150
     1.174    22.672     0.150
     1.174    38.172     0.150
     1.220    22.570     0.150
     1.220    38.469     0.150
     1.506    26.969     0.150
     1.506    27.875     0.150
     1.506    47.875     0.150
     1.506    48.570     0.150
     1.565    28.070     0.150
     1.565    49.070     0.150
     1.681    52.570     0.150
     2.071    34.969     0.150
     2.071    37.469     0.150
     2.071    64.273     0.150
     2.179    67.969     0.150
     2.320    41.969     0.150
     2.320    72.070     0.150
     2.779    44.273     0.150
     2.779    49.570     0.150
     2.779    85.875     0.150
     2.787    44.688     0.150
     2.787    49.844     0.150
     2.787    85.516     0.150
     2.787    44.875     0.150
     2.787    50.070     0.150
     2.929    89.969     0.150
     3.354    53.969     0.150
     3.354    60.070     0.150
     3.354   102.773     0.150
     3.517    63.070     0.150
     3.517   108.375     0.150
     3.803   119.469     0.150
     3.799    68.375     0.150
     3.799   119.070     0.150
     3.899   120.469     0.150
     4.289    65.672     0.150
     4.289    76.570     0.150
     4.289   133.875     0.150
     4.273    67.570     0.150
     4.273    75.969     0.150
     4.273   117.875     0.150
     4.273   131.469     0.150
     4.530    66.969     0.150
     4.530    81.375     0.150
     4.530   140.070     0.150
     4.621   143.469     0.150
     4.740    74.273     0.150
     4.740    84.969     0.150
     4.740   128.773     0.150
     4.740   146.570     0.150
     5.309    79.750     0.150
     5.309    96.914     0.150
     5.309   143.031     0.150
     5.309   165.992     0.150
     8.407   120.602     0.150
     8.407   261.547     0.150
    13.556   421.727     0.150
    17.394   242.477     0.150
     0.186     4.680     0.150
     0.186     7.578     0.150
     0.337     6.680     0.150
     0.337    11.477     0.150
     0.419     8.180     0.150
     0.419    13.977     0.150
     0.518    10.180     0.150
     0.518    16.977     0.150
     0.589    10.773     0.150
     0.589    18.773     0.150
     0.702    14.180     0.150
     0.702    23.977     0.150
     0.951    17.680     0.150
     0.951    30.680     0.150
     1.260    23.477     0.150
     1.260    40.273     0.150
     1.277    23.477     0.150
     1.277    40.375     0.150
     1.302    23.680     0.150
     1.302    41.578     0.150
     1.422    25.578     0.150
     1.422    44.180     0.150
     1.598    28.977     0.150
     1.598    50.875     0.150
     1.727    31.680     0.150
     1.727    54.773     0.150
     1.820    31.773     0.150
     1.820    33.680     0.150
     1.820    58.078     0.150
     2.211    37.375     0.150
     2.211    39.977     0.150
     2.211    64.578     0.150
     2.211    69.273     0.150
     2.321    41.875     0.150
     2.321    72.375     0.150
     2.461    41.078     0.150
     2.461    44.477     0.150
     2.461    76.977     0.150
     2.644    42.773     0.150
     2.644    47.578     0.150
     2.644    81.977     0.150
     2.829    46.078     0.150
     2.829    50.773     0.150
     2.829    79.078     0.150
     2.829    87.273     0.150
     2.929    47.242     0.150
     2.929    52.047     0.150
     2.929    81.844     0.150
     2.929    90.422     0.150
     2.929    52.477     0.150
     2.929    90.773     0.150
     3.396    53.375     0.150
     3.396    61.273     0.150
     3.396   105.773     0.150
     3.497    54.375     0.150
     3.497    62.773     0.150
     3.497   108.875     0.150
     3.690   114.375     0.150
     3.777    67.578     0.150
     3.777   116.977     0.150
     3.933    60.773     0.150
     3.933    70.773     0.150
     3.933   122.578     0.150
     4.151    63.477     0.150
     4.151    74.477     0.150
     4.151   129.078     0.150
     4.415    79.680     0.150
     4.415   117.180     0.150
     4.415   137.273     0.150
     4.488    81.078     0.150
     4.488   139.578     0.150
     4.875   130.273     0.150
     4.875   151.375     0.150
     5.385    81.680     0.150
     5.385    96.578     0.150
     5.385   145.016     0.150
     5.385   168.555     0.150
     8.303   119.750     0.150
     8.303   259.250     0.150
    13.672   191.500     0.150
    15.500   481.867     0.150
    17.533   244.695     0.150
    18.181   252.289     0.150
    18.770   259.078     0.150
    20.753   279.570     0.150
    22.304   297.617     0.150
    42.123   471.812     0.150
    49.241   528.430     0.150
    59.979   605.656     0.150
     0.298     6.461     0.150
     0.298    11.062     0.150
     0.496    10.363     0.150
     0.496    17.461     0.150
     0.553    11.363     0.150
     0.553    18.961     0.150
     0.552    10.961     0.150
     0.552    18.562     0.150
     0.904    16.160     0.150
     0.904    27.762     0.150
     1.266    23.660     0.150
     1.266    40.363     0.150
     1.504    27.262     0.150
     1.504    47.363     0.150
     1.734    30.062     0.150
     1.734    31.562     0.150
     1.734    54.262     0.150
     1.874    34.160     0.150
     1.874    58.660     0.150
     2.070    34.461     0.150
     2.070    36.363     0.150
     2.070    63.363     0.150
     2.118    35.363     0.150
     2.118    38.461     0.150
     2.118    61.363     0.150
     2.118    66.262     0.150
     2.334    41.762     0.150
     2.334    67.562     0.150
     2.334    71.562     0.150
     2.391    38.863     0.150
     2.391    43.160     0.150
     2.391    74.262     0.150
     2.779    44.562     0.150
     2.779    49.660     0.150
     2.779    85.863     0.150
     2.841    45.062     0.150
     2.841    50.062     0.150
     2.841    87.160     0.150
     2.864    88.363     0.150
     3.027    48.062     0.150
     3.027    54.062     0.150
     3.027    93.262     0.150
     3.219    56.762     0.150
     3.219    98.461     0.150
     3.417    61.062     0.150
     3.417   105.262     0.150
     3.488    62.660     0.150
     3.488   108.660     0.150
     3.580    55.062     0.150
     3.580    63.062     0.150
     3.580   109.562     0.150
     3.915   121.562     0.150
     4.028    72.762     0.150
     4.028   124.961     0.150
     4.523    80.562     0.150
     4.523   139.461     0.150
     4.506    80.961     0.150
     4.506   139.762     0.150
     4.939    88.160     0.150
     4.939   152.160     0.150
     5.314   163.262     0.150
     5.336    79.562     0.150
     5.336    95.762     0.150
     5.336   165.062     0.150
     0.135     3.680     0.150
     0.135     6.586     0.150
     0.491    10.281     0.150
     0.491    17.781     0.150
     0.530    10.383     0.150
     0.530    17.883     0.150
     0.711    13.781     0.150
     0.711    23.484     0.150
     0.982    17.586     0.150
     0.982    30.680     0.150
     1.067    20.086     0.150
     1.067    34.680     0.150
     1.399    24.984     0.150
     1.399    44.586     0.150
     1.449    26.180     0.150
     1.449    45.781     0.150
     1.590    28.781     0.150
     1.590    49.984     0.150
     1.634    30.086     0.150
     1.634    51.781     0.150
     1.684    29.883     0.150
     1.684    31.383     0.150
     1.859    31.883     0.150
     1.859    33.586     0.150
     1.859    58.680     0.150
     2.093    35.781     0.150
     2.093    38.484     0.150
     2.093    66.680     0.150
     2.237    36.781     0.150
     2.237    40.680     0.150
     2.237    70.180     0.150
     2.275    37.180     0.150
     2.275    40.680     0.150
     2.275    70.281     0.150
     2.631    42.680     0.150
     2.631    47.383     0.150
     2.631    77.086     0.150
     2.631    81.086     0.150
     2.632    42.086     0.150
     2.632    47.484     0.150
     2.632    81.281     0.150
     2.769    43.586     0.150
     2.769    86.281     0.150
     2.889    45.984     0.150
     2.889    51.984     0.150
     2.889    90.383     0.150
     3.097    48.680     0.150
     3.097    55.484     0.150
     3.097    95.586     0.150
     3.281    50.086     0.150
     3.281    58.781     0.150
     3.281   100.984     0.150
     3.364    51.828     0.150
     3.364    60.055     0.150
     3.364   101.875     0.150
     3.364    60.680     0.150
     3.364   104.781     0.150
     3.469   107.680     0.150
     4.120    74.883     0.150
     4.120   128.883     0.150
     4.255    63.484     0.150
     4.255    76.086     0.150
     4.255   111.383     0.150
     4.255   131.586     0.150
     4.321    65.883     0.150
     4.321    78.281     0.150
     4.321   114.281     0.150
     4.321   134.484     0.150
     4.868    74.680     0.150
     4.868    87.883     0.150
     4.868   131.180     0.150
     4.868   149.781     0.150
     5.285    94.984     0.150
     5.285   164.180     0.150
     5.329    80.680     0.150
     5.329    95.680     0.150
     5.329   142.984     0.150
     5.329   165.484     0.150
     5.436    82.383     0.150
     5.436    98.281     0.150
     5.436   169.086     0.150
     5.554    83.039     0.150
     5.554    98.031     0.150
     7.912   112.406     0.150
     7.912   242.828     0.150
    14.096   197.922     0.150
     0.242     5.688     0.150
     0.242     9.887     0.150
     0.622    11.287     0.150
     0.622    19.588     0.150
     0.634    12.287     0.150
     0.634    21.188     0.150
     0.778    15.188     0.150
     0.778    26.488     0.150
     0.879    16.887     0.150
     0.879    28.988     0.150
     0.886    16.088     0.150
     0.886    28.688     0.150
     1.437    26.387     0.150
     1.437    46.287     0.150
     1.751    31.488     0.150
     1.751    54.488     0.150
     1.778    31.287     0.150
     1.778    32.188     0.150
     1.778    56.387     0.150
     1.913    32.688     0.150
     1.913    33.988     0.150
     1.913    59.188     0.150
     1.956    35.588     0.150
     1.956    58.387     0.150
     1.956    61.988     0.150
     2.054    38.188     0.150
     2.054    63.188     0.150
     2.054    65.588     0.150
     2.209    37.287     0.150
     2.209    39.688     0.150
     2.209    70.088     0.150
     2.359    42.088     0.150
     2.359    73.287     0.150
     2.604    47.088     0.150
     2.604    73.488     0.150
     2.604    81.588     0.150
     2.762    49.188     0.150
     2.762    85.688     0.150
     2.999    47.688     0.150
     2.999    54.088     0.150
     2.999    82.887     0.150
     2.999    93.387     0.150
     3.095    95.088     0.150
     3.128    97.488     0.150
     3.121    98.088     0.150
     3.253    58.488     0.150
     3.253    88.287     0.150
     3.253   100.988     0.150
     3.382    59.887     0.150
     3.382   103.988     0.150
     3.756   115.287     0.150
     3.726    66.787     0.150
     3.726   100.488     0.150
     3.726   115.787     0.150
     4.283    64.488     0.150
     4.283    76.287     0.150
     4.283   131.787     0.150
     4.295    77.387     0.150
     4.295   133.588     0.150
     4.691   146.088     0.150
     4.916    74.488     0.150
     4.916    87.887     0.150
     4.916   151.787     0.150
     5.219   160.188     0.150
     5.212   161.088     0.150
     0.088     3.664     0.150
     0.088     6.566     0.150
     0.829    15.465     0.150
     0.829    27.367     0.150
     1.216    22.066     0.150
     1.373    24.066     0.150
     1.373    43.066     0.150
     1.372    24.367     0.150
     1.372    42.465     0.150
     1.457    26.266     0.150
     1.457    46.664     0.150
     2.027    63.465     0.150
     2.063    34.164     0.150
     2.063    36.367     0.150
     2.063    63.367     0.150
     2.297    37.465     0.150
     2.297    40.164     0.150
     2.297    70.566     0.150
     2.301    40.566     0.150
     2.301    71.965     0.150
     2.341    38.164     0.150
     2.341    42.465     0.150
     2.341    72.766     0.150
     2.534    44.664     0.150
     2.534    78.766     0.150
     2.759    86.367     0.150
     2.794    86.066     0.150
     3.197    99.266     0.150
     3.847    69.164     0.150
     3.847   118.664     0.150
     4.310    63.664     0.150
     4.310    76.766     0.150
     4.310   133.066     0.150
     4.337    64.867     0.150
     4.337    77.367     0.150
     4.337   133.164     0.150
     4.715   144.465     0.150
     4.879   149.266     0.150
     0.180     3.943     0.150
     0.180     6.545     0.150
     0.270     5.545     0.150
     0.270     9.545     0.150
     0.512     9.244     0.150
     0.512    16.145     0.150
     0.664    12.943     0.150
     0.664    21.744     0.150
     0.696    14.045     0.150
     0.696    23.045     0.150
     1.032    19.545     0.150
     1.032    34.344     0.150
     1.177    21.545     0.150
     1.177    22.545     0.150
     1.177    37.744     0.150
     1.274    23.744     0.150
     1.274    41.344     0.150
     1.312    42.145     0.150
     1.312    45.545     0.150
     1.359    24.045     0.150
     1.359    42.244     0.150
     1.538    28.045     0.150
     1.538    48.844     0.150
     1.726    32.443     0.150
     1.726    54.943     0.150
     1.860    34.344     0.150
     1.860    58.244     0.150
     2.255    37.545     0.150
     2.255    40.645     0.150
     2.255    41.545     0.150
     2.255    64.943     0.150
     2.255    70.244     0.150
     2.400    74.545     0.150
     2.512    41.145     0.150
     2.512    45.645     0.150
     2.512    77.844     0.150
     2.635    46.744     0.150
     2.635    80.943     0.150
     2.897    46.443     0.150
     2.897    52.244     0.150
     2.897    89.645     0.150
     2.988    48.344     0.150
     2.988    53.645     0.150
     2.988    92.545     0.150
     3.425    54.645     0.150
     3.425    61.545     0.150
     3.425   105.344     0.150
     3.541   109.645     0.150
     3.582    65.045     0.150
     3.582   110.145     0.150
     3.582   111.443     0.150
     3.949    71.545     0.150
     3.949   124.045     0.150
     4.313    77.344     0.150
     4.313   131.145     0.150
     4.313   132.744     0.150
     4.481   138.844     0.150
     4.503    70.344     0.150
     4.503    81.145     0.150
     4.503   138.045     0.150
     4.503   139.344     0.150
     4.992    77.344     0.150
     4.992    90.344     0.150
     4.992   136.045     0.150
     4.992   155.645     0.150
     5.201    93.744     0.150
     5.201   162.545     0.150
     0.183     4.660     0.150
     0.183     7.660     0.150
     0.333     6.562     0.150
     0.333    11.562     0.150
     0.420     8.062     0.150
     0.420    13.863     0.150
     0.515    10.062     0.150
     0.515    17.062     0.150
     0.581    10.762     0.150
     0.581    18.461     0.150
     0.709    13.961     0.150
     0.709    24.262     0.150
     0.958    17.762     0.150
     0.958    30.961     0.150
     1.267    23.660     0.150
     1.267    40.461     0.150
     1.282    23.562     0.150
     1.282    40.461     0.150
     1.299    24.262     0.150
     1.299    41.863     0.150
     1.414    25.461     0.150
     1.414    44.262     0.150
     1.604    29.363     0.150
     1.604    50.762     0.150
     1.734    54.660     0.150
     1.828    33.461     0.150
     1.828    57.660     0.150
     2.218    36.863     0.150
     2.218    39.961     0.150
     2.218    63.762     0.150
     2.218    68.660     0.150
     2.329    72.562     0.150
     2.469    40.562     0.150
     2.469    44.762     0.150
     2.469    76.363     0.150
     2.636    42.562     0.150
     2.636    47.562     0.150
     2.636    81.562     0.150
     2.823    50.762     0.150
     2.823    80.363     0.150
     2.823    86.660     0.150
     2.937    53.160     0.150
     2.937    90.461     0.150
     3.389    61.062     0.150
     3.389   104.863     0.150
     3.504    63.160     0.150
     3.504   107.961     0.150
     3.685    66.262     0.150
     3.685   114.363     0.150
     3.940    71.062     0.150
     3.940   123.363     0.150
     4.038    64.363     0.150
     4.038   124.762     0.150
     4.143    62.863     0.150
     4.143    74.562     0.150
     4.143   127.961     0.150
     4.422    79.363     0.150
     4.422   121.262     0.150
     4.422   136.363     0.150
     4.480   139.262     0.150
     4.480    67.562     0.150
     4.480    81.062     0.150
     4.480   138.863     0.150
     4.881    75.961     0.150
     4.881    86.660     0.150
     4.881   131.562     0.150
     4.881   150.863     0.150
     5.307    95.562     0.150
     5.307   164.961     0.150
     0.121     3.561     0.150
     0.121     6.859     0.150
     0.327     6.760     0.150
     0.327    12.561     0.150
     0.678    12.760     0.150
     0.678    23.160     0.150
     0.678    13.760     0.150
     0.678    22.260     0.150
     0.678    23.459     0.150
     0.952    16.561     0.150
     0.952    30.061     0.150
     0.952    17.359     0.150
     0.952    29.561     0.150
     1.108    20.561     0.150
     1.108    21.359     0.150
     1.108    36.260     0.150
     1.422    25.160     0.150
     1.422    26.061     0.150
     1.422    45.061     0.150
     1.507    26.859     0.150
     1.507    48.160     0.150
     1.638    29.359     0.150
     1.681    30.359     0.150
     1.725    31.061     0.150
     1.725    54.260     0.150
     1.913    32.160     0.150
     1.913    34.959     0.150
     1.913    60.660     0.150
     2.227    40.561     0.150
     2.227    68.859     0.150
     2.227    39.061     0.150
     2.227    68.660     0.150
     2.137    38.660     0.150
     2.137    66.660     0.150
     2.272    37.459     0.150
     2.272    40.859     0.150
     2.272    64.561     0.150
     2.272    70.561     0.150
     2.570    41.459     0.150
     2.570    45.660     0.150
     2.570    78.959     0.150
     2.666    42.760     0.150
     2.666    47.959     0.150
     2.666    74.160     0.150
     2.666    82.859     0.150
     2.794    49.260     0.150
     2.794    85.260     0.150
     2.794    50.359     0.150
     2.794    86.160     0.150
     2.921    46.359     0.150
     2.921    52.959     0.150
     2.921    80.561     0.150
     2.921    89.660     0.150
     2.921    80.260     0.150
     2.921    91.160     0.150
     3.042    47.859     0.150
     3.042    53.561     0.150
     3.042    93.260     0.150
     3.298    58.359     0.150
     3.298   100.660     0.150
     3.415   103.959     0.150
     3.394    52.242     0.150
     3.394    60.229     0.150
     3.394    92.078     0.150
     3.394   104.252     0.150
     3.394    51.289     0.150
     3.394    53.359     0.150
     3.394    60.760     0.150
     3.394    91.859     0.150
     3.394   105.959     0.150
     3.710    57.160     0.150
     3.710    66.859     0.150
     3.710   114.459     0.150
     4.073    72.959     0.150
     4.073   126.160     0.150
     3.970    61.561     0.150
     3.970    71.660     0.150
     3.970   123.459     0.150
     4.302    64.160     0.150
     4.302    77.160     0.150
     4.302   113.260     0.150
     4.302   132.959     0.150
     4.363    78.561     0.150
     4.363   135.359     0.150
     4.889    73.160     0.150
     4.889    87.660     0.150
     5.242    78.359     0.150
     5.242    94.061     0.150
     5.242   161.760     0.150
     5.338    80.359     0.150
     5.338   138.459     0.150
     5.338    95.660     0.150
     5.497    81.029     0.150
     5.497    82.561     0.150
     5.497    99.160     0.150
     5.497   171.359     0.150
     5.510    81.260     0.150
     5.510    98.160     0.150
     5.510   169.561     0.150
     5.614    98.820     0.150
     6.660    97.859     0.150
     6.660   118.260     0.150
     6.660   204.561     0.150
     6.851    99.561     0.150
     6.851   122.760     0.150
     6.851   210.561     0.150
     7.932   112.021     0.150
     7.932   200.910     0.150
     7.932   244.410     0.150
    14.087   440.084     0.150
    15.061   466.428     0.150
    18.005   250.234     0.150
    18.005   248.049     0.150
    18.540   255.600     0.150
    18.540   258.260     0.150
    18.625   258.307     0.150
    18.823   586.436     0.150
    18.823   259.299     0.150
    20.174   272.660     0.150
    20.482   276.061     0.150
    20.482   636.178     0.150
    22.709   301.879     0.150
    45.850   500.850     0.150
    46.397   505.480     0.150
    48.880   524.959     0.150
    50.284   536.359     0.150
    51.702   546.180     0.150
    59.689   602.246     0.150
    76.253   706.242     0.150
    79.719   726.510     0.150
     0.329     7.539     0.150
     0.329    11.539     0.150
     0.329    12.336     0.150
     0.718    13.742     0.150
     0.718    23.336     0.150
     0.825    16.336     0.150
     0.825    27.742     0.150
     0.885    16.539     0.150
     0.885    28.539     0.150
     0.834    16.141     0.150
     0.834    27.336     0.150
     0.834    27.539     0.150
     1.329    25.141     0.150
     1.329    42.742     0.150
     1.366    24.539     0.150
     1.366    25.039     0.150
     1.366    43.141     0.150
     1.380    25.438     0.150
     1.380    43.742     0.150
     1.380    25.039     0.150
     1.527    26.836     0.150
     1.527    46.742     0.150
     1.647    29.141     0.150
     1.647    50.742     0.150
     1.647    28.938     0.150
     1.647    50.039     0.150
     1.752    30.336     0.150
     1.752    31.141     0.150
     1.752    54.539     0.150
     1.752    54.641     0.150
     1.760    30.242     0.150
     1.760    31.938     0.150
     1.760    53.141     0.150
     1.760    55.336     0.150
     1.757    30.141     0.150
     1.757    32.242     0.150
     1.757    55.938     0.150
     2.122    35.539     0.150
     2.122    38.141     0.150
     2.122    65.141     0.150
     2.150    38.836     0.150
     2.150    62.742     0.150
     2.150    65.938     0.150
     2.150    35.742     0.150
     2.150    38.641     0.150
     2.150    61.242     0.150
     2.150    66.141     0.150
     2.354    38.836     0.150
     2.354    42.938     0.150
     2.354    72.141     0.150
     2.354    42.438     0.150
     2.354    72.242     0.150
     2.740    43.141     0.150
     2.740    49.539     0.150
     2.740    84.141     0.150
     2.740    49.242     0.150
     2.740    74.336     0.150
     2.735    43.336     0.150
     2.735    83.242     0.150
     2.795    44.742     0.150
     2.795    50.836     0.150
     2.795    77.539     0.150
     2.795    84.836     0.150
     3.298    51.242     0.150
     3.298    59.539     0.150
     3.298    91.141     0.150
     3.298   102.141     0.150
     3.396    52.539     0.150
     3.396   104.336     0.150
     3.782   117.039     0.150
     3.836   117.836     0.150
     3.889    60.438     0.150
     3.889   119.938     0.150
     3.889    59.742     0.150
     3.889    69.641     0.150
     3.889   119.742     0.150
     4.047    74.539     0.150
     4.047   126.039     0.150
     4.047   125.938     0.150
     4.268    65.141     0.150
     4.268    75.938     0.150
     4.268   112.641     0.150
     4.268   131.336     0.150
     4.204    65.539     0.150
     4.204    73.641     0.150
     4.204   112.641     0.150
     4.204   128.742     0.150
     4.558    68.742     0.150
     4.558    81.039     0.150
     4.558   140.141     0.150
     4.595    69.539     0.150
     4.595    71.242     0.150
     4.595   120.641     0.150
     4.595   142.438     0.150
     4.859    70.836     0.150
     4.859    87.438     0.150
     4.859   123.742     0.150
     4.859   150.438     0.150
     5.517    82.242     0.150
     5.517    82.141     0.150
     5.517    99.336     0.150
     5.517   172.539     0.150
     5.574    83.141     0.150
     6.638    95.641     0.150
     8.818   125.141     0.150
    12.884   180.438     0.150
    14.709   206.742     0.150
    17.283   240.938     0.150
    17.778   247.938     0.150
    21.986   293.836     0.150
     0.115     3.898     0.150
     0.115     6.703     0.150
     0.497    10.398     0.150
     0.497    18.000     0.150
     0.624    11.602     0.150
     0.624    20.602     0.150
     0.672    13.203     0.150
     0.672    22.602     0.150
     0.924    16.602     0.150
     0.924    29.000     0.150
     1.449    25.898     0.150
     1.449    45.703     0.150
     1.546    27.398     0.150
     1.546    48.000     0.150
     1.674    30.602     0.150
     1.674    52.203     0.150
     1.717    31.500     0.150
     1.760    32.602     0.150
     1.760    55.898     0.150
     1.951    32.797     0.150
     1.951    34.703     0.150
     1.951    61.203     0.150
     2.191    35.797     0.150
     2.191    38.297     0.150
     2.191    67.602     0.150
     2.303    42.000     0.150
     2.303    72.602     0.150
     2.532    45.297     0.150
     2.532    78.000     0.150
     2.698    42.898     0.150
     2.698    48.898     0.150
     2.698    84.102     0.150
     2.820    87.500     0.150
     2.952    46.398     0.150
     2.952    53.297     0.150
     2.952    91.102     0.150
     3.003    47.297     0.150
     3.003    53.500     0.150
     3.003    92.500     0.150
     3.297    59.602     0.150
     3.297   102.000     0.150
     3.423    53.602     0.150
     3.423    61.602     0.150
     3.423   106.102     0.150
     3.676    56.203     0.150
     3.676    66.398     0.150
     3.676   113.297     0.150
     3.995    71.898     0.150
     3.995   124.398     0.150
     4.036    73.500     0.150
     4.036   125.797     0.150
     4.323    65.500     0.150
     4.323    77.203     0.150
     4.323   133.102     0.150
     4.397    79.203     0.150
     4.397   136.703     0.150
     4.913    88.602     0.150
     4.913   152.500     0.150
     5.207    77.500     0.150
     5.207    93.297     0.150
     5.207   160.203     0.150
     5.355    80.500     0.150
     5.355    96.602     0.150
     5.355   166.500     0.150
     0.284     6.020     0.150
     0.284    10.219     0.150
     0.329     7.422     0.150
     0.329    12.719     0.150
     0.487     9.219     0.150
     0.487    15.922     0.150
     0.655    12.719     0.150
     0.655    21.719     0.150
     0.721    14.219     0.150
     0.721    24.520     0.150
     1.054    19.820     0.150
     1.054    34.621     0.150
     1.197    22.020     0.150
     1.197    23.020     0.150
     1.197    38.520     0.150
     1.197    40.922     0.150
     1.259    23.719     0.150
     1.259    40.320     0.150
     1.299    24.020     0.150
     1.299    42.121     0.150
     1.335    23.922     0.150
     1.335    42.422     0.150
     1.337    26.121     0.150
     1.337    43.621     0.150
     1.337    45.621     0.150
     1.561    28.520     0.150
     1.561    49.520     0.150
     1.751    54.621     0.150
     1.884    33.922     0.150
     1.884    58.219     0.150
     2.280    37.520     0.150
     2.280    40.922     0.150
     2.280    64.621     0.150
     2.280    70.320     0.150
     2.423    75.320     0.150
     2.536    40.922     0.150
     2.536    45.219     0.150
     2.536    78.320     0.150
     2.610    41.820     0.150
     2.610    80.422     0.150
     2.875    51.820     0.150
     2.875    88.922     0.150
     3.012    54.520     0.150
     3.012    93.621     0.150
     3.400    61.219     0.150
     3.400   105.219     0.150
     3.974    72.219     0.150
     3.974   124.219     0.150
     4.134    74.520     0.150
     4.134   128.121     0.150
     4.314    64.219     0.150
     4.314    77.020     0.150
     4.314   133.219     0.150
     4.525    78.121     0.150
     4.525    81.121     0.150
     4.525   137.922     0.150
     4.525   139.719     0.150
     5.011    77.320     0.150
     5.011    89.820     0.150
     5.011   155.520     0.150
     5.220    93.719     0.150
     5.220   161.922     0.150
     0.251     5.301     0.150
     0.251     9.000     0.150
     0.355     8.199     0.150
     0.355    13.699     0.150
     0.548    10.602     0.150
     0.548    18.602     0.150
     0.567    11.500     0.150
     0.567    19.398     0.150
     1.065    19.000     0.150
     1.065    33.199     0.150
     1.023    19.398     0.150
     1.023    20.500     0.150
     1.023    33.500     0.150
     1.023    35.699     0.150
     1.308    23.602     0.150
     1.308    41.000     0.150
     1.478    26.699     0.150
     1.478    46.398     0.150
     1.604    29.000     0.150
     1.604    49.898     0.150
     1.861    32.199     0.150
     1.861    33.699     0.150
     1.861    58.602     0.150
     2.171    35.602     0.150
     2.171    38.602     0.150
     2.171    67.699     0.150
     2.307    37.398     0.150
     2.307    40.199     0.150
     2.307    70.500     0.150
     2.589    45.898     0.150
     2.589    79.000     0.150
     2.563    40.699     0.150
     2.563    45.699     0.150
     2.563    70.602     0.150
     2.563    79.898     0.150
     2.678    47.801     0.150
     2.678    82.801     0.150
     2.816    50.000     0.150
     2.816    87.000     0.150
     3.096    48.398     0.150
     3.096    54.398     0.150
     3.096    95.000     0.150
     3.285    51.000     0.150
     3.285    59.301     0.150
     3.285   102.199     0.150
     3.423    61.000     0.150
     3.423   105.199     0.150
     3.852    59.199     0.150
     3.852    68.801     0.150
     3.852   119.102     0.150
     4.273    76.699     0.150
     4.273   132.199     0.150
     4.386   136.398     0.150
     4.769    72.199     0.150
     4.769    85.398     0.150
     4.769   123.500     0.150
     4.769   147.102     0.150
     5.210    78.301     0.150
     5.210    93.801     0.150
     5.210   133.898     0.150
     5.210   161.102     0.150
     5.331    95.102     0.150
     5.331   164.699     0.150
     5.488    99.000     0.150
     5.488   170.500     0.150
     0.150     4.184     0.150
     0.733    13.783     0.150
     0.733    24.283     0.150
     1.301    23.684     0.150
     1.301    24.584     0.150
     1.301    41.885     0.150
     1.301    43.184     0.150
     1.331    24.184     0.150
     1.331    42.484     0.150
     1.373    24.584     0.150
     1.373    42.885     0.150
     1.548    26.885     0.150
     1.548    47.885     0.150
     1.917    34.385     0.150
     2.142    38.584     0.150
     2.142    67.283     0.150
     2.261    39.783     0.150
     2.261    70.385     0.150
     2.266    36.885     0.150
     2.266    40.684     0.150
     2.266    70.885     0.150
     2.457    44.385     0.150
     2.488    43.584     0.150
     2.488    76.584     0.150
     2.609    46.084     0.150
     2.609    80.684     0.150
     2.686    46.783     0.150
     2.686    81.684     0.150
     3.356   103.783     0.150
     3.495    62.484     0.150
     3.495   108.584     0.150
     3.637    55.684     0.150
     3.753    66.984     0.150
     3.753   116.084     0.150
     4.127    62.283     0.150
     4.127    73.684     0.150
     4.127   127.385     0.150
     4.231    75.484     0.150
     4.231   130.584     0.150
     4.231    64.885     0.150
     4.477    79.885     0.150
     4.477   138.584     0.150
     4.814   149.084     0.150
     5.732   177.484     0.150
     6.162    91.084     0.150
    13.516   189.385     0.150
    14.450   203.184     0.150
    18.842   259.184     0.150
    19.325   262.484     0.150
    23.458   308.385     0.150
    23.833   310.885     0.150
    25.770   331.184     0.150
     0.290     6.000     0.150
     0.290    10.000     0.150
     0.312     7.102     0.150
     0.312    12.000     0.150
     0.573    11.000     0.150
     0.573    19.000     0.150
     0.646    12.801     0.150
     0.646    21.902     0.150
     0.645    12.699     0.150
     0.645    21.199     0.150
     0.965    18.199     0.150
     0.965    19.301     0.150
     0.965    31.500     0.150
     1.166    21.402     0.150
     1.166    36.801     0.150
     1.230    22.699     0.150
     1.230    38.902     0.150
     1.420    44.902     0.150
     1.509    27.402     0.150
     1.509    47.801     0.150
     1.801    30.500     0.150
     1.801    32.602     0.150
     1.801    56.500     0.150
     2.196    36.402     0.150
     2.196    39.199     0.150
     2.196    67.699     0.150
     2.334    72.199     0.150
     2.451    39.801     0.150
     2.451    43.699     0.150
     2.451    75.500     0.150
     2.684    43.199     0.150
     2.684    48.000     0.150
     2.684    83.602     0.150
     2.920    46.699     0.150
     2.920    52.102     0.150
     2.920    79.699     0.150
     2.920    90.102     0.150
     2.926    46.402     0.150
     2.926    52.000     0.150
     2.926    90.000     0.150
     3.462    61.801     0.150
     3.462   106.699     0.150
     3.516    55.402     0.150
     3.516    63.402     0.150
     3.516   108.902     0.150
     3.516   110.602     0.150
     3.607   112.500     0.150
     3.896    70.199     0.150
     3.896   121.000     0.150
     4.046    72.699     0.150
     4.046   125.199     0.150
     4.178   129.199     0.150
     4.358    77.902     0.150
     4.358   134.801     0.150
     4.437    69.000     0.150
     4.437    79.801     0.150
     4.437   137.301     0.150
     4.924    75.801     0.150
     4.924    89.199     0.150
     4.924   131.402     0.150
     4.924   153.199     0.150
     5.191   160.902     0.150
     0.088     4.312     0.150
     0.088     7.508     0.150
     0.793    15.414     0.150
     0.793    26.812     0.150
     1.319    23.812     0.150
     1.319    24.312     0.150
     1.319    41.508     0.150
     1.319    43.109     0.150
     1.350    24.109     0.150
     1.350    42.211     0.150
     1.350    24.211     0.150
     1.350    43.008     0.150
     1.411    43.211     0.150
     1.411    43.414     0.150
     1.420    25.414     0.150
     1.420    45.508     0.150
     1.991    33.211     0.150
     1.991    35.914     0.150
     2.092    34.711     0.150
     2.092    36.711     0.150
     2.092    64.109     0.150
     2.092    36.609     0.150
     2.092    64.414     0.150
     2.333    37.508     0.150
     2.333    41.008     0.150
     2.333    71.008     0.150
     2.333    40.508     0.150
     2.333    63.414     0.150
     2.333    70.812     0.150
     2.263    37.109     0.150
     2.263    40.008     0.150
     2.309    37.211     0.150
     2.309    41.109     0.150
     2.309    65.414     0.150
     2.309    71.711     0.150
     2.309    41.312     0.150
     2.309    65.211     0.150
     2.497    40.008     0.150
     2.497    44.508     0.150
     2.497    69.609     0.150
     2.497    78.109     0.150
     2.546    45.508     0.150
     2.608    41.211     0.150
     2.608    47.312     0.150
     2.608    75.609     0.150
     2.608    82.414     0.150
     2.680    81.711     0.150
     2.721    43.414     0.150
     2.721    49.609     0.150
     2.721    76.211     0.150
     2.721    85.711     0.150
     2.793    48.008     0.150
     2.793    50.609     0.150
     2.793    76.609     0.150
     2.793    85.711     0.150
     2.793    41.914     0.150
     2.793    84.211     0.150
     2.836    44.211     0.150
     2.836    77.109     0.150
     2.836    86.211     0.150
     3.010    47.508     0.150
     3.010    54.211     0.150
     3.010    94.609     0.150
     3.163    48.312     0.150
     3.163    56.812     0.150
     3.163    86.211     0.150
     3.163    98.711     0.150
     3.163    48.914     0.150
     3.163    57.109     0.150
     3.163    98.414     0.150
     3.235    51.609     0.150
     3.235    56.914     0.150
     3.235   100.008     0.150
     3.558    54.414     0.150
     3.558    63.414     0.150
     3.558    94.812     0.150
     3.558   110.109     0.150
     3.678    56.414     0.150
     3.678    65.508     0.150
     3.678   114.211     0.150
     3.813    58.109     0.150
     3.813    68.109     0.150
     3.813    98.812     0.150
     3.813   117.812     0.150
     4.289    63.711     0.150
     4.289    76.508     0.150
     4.289   130.914     0.150
     4.289    75.211     0.150
     4.289   131.109     0.150
     4.286    64.328     0.150
     4.286   132.406     0.150
     4.286    63.969     0.150
     4.286    76.312     0.150
     4.286    64.109     0.150
     4.374    65.312     0.150
     4.374    77.008     0.150
     4.374   134.211     0.150
     4.753    69.711     0.150
     4.753    83.711     0.150
     4.753   122.312     0.150
     4.753   145.312     0.150
     4.849    71.914     0.150
     4.849    86.812     0.150
     4.849   126.008     0.150
     4.849   148.812     0.150
     5.242    78.414     0.150
     5.242    93.711     0.150
     5.242    78.109     0.150
     5.779    84.711     0.150
     5.763    85.609     0.150
     5.763   102.508     0.150
     5.763   150.414     0.150
     5.763    85.711     0.150
     5.763   150.609     0.150
     5.990    86.812     0.150
     5.990   105.508     0.150
     6.146    88.086     0.150
     6.146   159.062     0.150
     6.146   191.109     0.150
     6.099    87.961     0.150
     6.099    89.211     0.150
     6.099    89.109     0.150
     6.163    91.109     0.150
     6.163   159.109     0.150
     6.262    90.789     0.150
     6.262   195.555     0.150
     7.416   105.539     0.150
     7.416   231.062     0.150
     7.592   107.664     0.150
    14.453   203.109     0.150
    14.774   207.508     0.150
    14.774   462.383     0.150
    18.855   259.711     0.150
    18.855   259.289     0.150
    18.855   260.031     0.150
    18.855   260.609     0.150
    19.297   263.320     0.150
    19.297   263.109     0.150
    19.384   264.258     0.150
    22.470   297.211     0.150
    23.365   307.438     0.150
    23.399   307.414     0.150
    25.785   329.312     0.150
    27.848   348.578     0.150
    30.882   374.367     0.150
    30.882   375.078     0.150
    35.462   414.430     0.150
    36.169   419.508     0.150
    36.169   421.812     0.150
    41.552   466.359     0.150
    42.611   474.562     0.150
    42.611   473.609     0.150
    47.003   509.211     0.150
    48.094   518.008     0.150
    48.394   518.664     0.150
    49.007   523.508     0.150
    51.613   544.961     0.150
    51.613   545.281     0.150
    58.207   591.852     0.150
     0.257     5.070     0.150
     0.257     8.971     0.150
     0.403     7.971     0.150
     0.403    14.770     0.150
     0.532    10.270     0.150
     0.532    17.869     0.150
     0.681    12.770     0.150
     0.681    22.270     0.150
     0.681    23.170     0.150
     0.987    17.471     0.150
     0.987    30.570     0.150
     1.143    21.570     0.150
     1.143    36.869     0.150
     1.398    24.770     0.150
     1.398    44.471     0.150
     1.612    29.070     0.150
     1.612    51.170     0.150
     1.690    30.369     0.150
     1.690    53.270     0.150
     1.993    33.869     0.150
     1.993    35.971     0.150
     1.993    62.570     0.150
     2.190    35.869     0.150
     2.190    38.270     0.150
     2.190    67.670     0.150
     2.276    37.170     0.150
     2.276    41.770     0.150
     2.276    70.070     0.150
     2.276    71.270     0.150
     2.456    44.170     0.150
     2.456    72.170     0.150
     2.456    75.971     0.150
     2.667    48.770     0.150
     2.667    73.971     0.150
     2.667    83.471     0.150
     2.764    50.170     0.150
     2.764    86.770     0.150
     2.916    46.170     0.150
     2.916    52.369     0.150
     2.916    88.971     0.150
     2.916    90.270     0.150
     2.967    52.070     0.150
     2.967    90.971     0.150
     3.381    60.369     0.150
     3.381   103.369     0.150
     3.381   104.869     0.150
     3.431   105.770     0.150
     3.694    56.570     0.150
     3.694    65.471     0.150
     3.694   113.971     0.150
     3.932    70.270     0.150
     3.932   119.070     0.150
     3.932   121.471     0.150
     4.387   135.369     0.150
     4.468    66.170     0.150
     4.468    79.869     0.150
     4.468   115.971     0.150
     4.468   137.070     0.150
     4.468    80.869     0.150
     4.468   138.770     0.150
     4.846    75.869     0.150
     4.846    84.869     0.150
     4.846    86.770     0.150
     4.846   131.670     0.150
     4.846   149.471     0.150
     5.219    92.770     0.150
     5.219   160.170     0.150
     5.263    79.670     0.150
     5.263    94.869     0.150
     5.263   140.070     0.150
     5.263   154.670     0.150
     5.263   163.971     0.150
     0.088     3.547     0.150
     0.088     5.844     0.150
     0.420     8.547     0.150
     0.420    14.344     0.150
     0.512     9.645     0.150
     0.512    16.746     0.150
     0.575    10.547     0.150
     0.575    17.746     0.150
     0.789    15.547     0.150
     0.789    26.547     0.150
     0.995    17.945     0.150
     0.995    31.645     0.150
     1.349    24.645     0.150
     1.349    43.145     0.150
     1.386    24.844     0.150
     1.386    43.246     0.150
     1.378    25.145     0.150
     1.378    43.645     0.150
     1.379    44.445     0.150
     1.694    30.945     0.150
     1.694    53.746     0.150
     1.882    33.945     0.150
     1.882    59.145     0.150
     2.269    37.844     0.150
     2.269    40.246     0.150
     2.269    70.445     0.150
     2.361    74.145     0.150
     2.516    41.445     0.150
     2.516    45.145     0.150
     2.516    77.547     0.150
     2.576    41.746     0.150
     2.576    45.445     0.150
     2.576    79.445     0.150
     2.734    48.645     0.150
     2.734    83.746     0.150
     2.979    47.645     0.150
     2.979    53.547     0.150
     2.979    92.445     0.150
     3.313    51.344     0.150
     3.313    58.547     0.150
     3.313   101.645     0.150
     3.530    63.047     0.150
     3.530   108.945     0.150
     3.717   115.746     0.150
     4.002   124.945     0.150
     4.090    62.645     0.150
     4.090    73.547     0.150
     4.090   126.645     0.150
     4.418   135.844     0.150
     4.446    79.344     0.150
     4.446   137.645     0.150
     4.557    67.844     0.150
     4.557    82.246     0.150
     4.557   141.645     0.150
     4.883   150.547     0.150
     0.172     4.895     0.150
     0.172     8.094     0.150
     0.500     9.996     0.150
     0.500    16.594     0.150
     0.615    11.695     0.150
     0.615    19.695     0.150
     0.929    17.395     0.150
     0.929    30.195     0.150
     0.929    17.293     0.150
     0.929    30.395     0.150
     1.257    23.293     0.150
     1.257    40.496     0.150
     1.288    24.094     0.150
     1.288    40.793     0.150
     1.287    23.996     0.150
     1.287    42.496     0.150
     1.445    25.695     0.150
     1.445    45.594     0.150
     1.445    25.594     0.150
     1.445    44.996     0.150
     1.600    28.496     0.150
     1.600    29.594     0.150
     1.600    50.594     0.150
     1.718    30.895     0.150
     1.718    32.293     0.150
     1.718    54.496     0.150
     1.804    31.293     0.150
     1.804    56.793     0.150
     1.804    32.895     0.150
     2.193    36.793     0.150
     2.193    39.594     0.150
     2.193    67.594     0.150
     2.193    39.395     0.150
     2.193    62.594     0.150
     2.193    68.094     0.150
     2.299    41.895     0.150
     2.299    71.094     0.150
     2.299    41.594     0.150
     2.299    65.293     0.150
     2.299    71.395     0.150
     2.443    40.195     0.150
     2.443    44.094     0.150
     2.443    75.594     0.150
     2.443    40.094     0.150
     2.443    43.895     0.150
     2.443    68.996     0.150
     2.443    76.195     0.150
     2.657    42.496     0.150
     2.657    81.895     0.150
     2.657    46.793     0.150
     2.657    73.496     0.150
     2.657    81.695     0.150
     2.828    45.895     0.150
     2.828    49.996     0.150
     2.828    86.496     0.150
     2.828    45.395     0.150
     2.828    78.996     0.150
     2.909    46.188     0.150
     2.909    51.938     0.150
     2.909    89.887     0.150
     2.909    50.793     0.150
     2.909    46.594     0.150
     2.909    52.195     0.150
     2.909    79.996     0.150
     3.403    52.395     0.150
     3.403    59.996     0.150
     3.403   105.496     0.150
     3.403    52.996     0.150
     3.403    60.594     0.150
     3.403   104.695     0.150
     3.721    57.496     0.150
     3.721    67.895     0.150
     3.721   116.793     0.150
     3.721   113.996     0.150
     3.784    67.094     0.150
     3.784   117.395     0.150
     3.920    61.195     0.150
     3.920   105.293     0.150
     3.920    70.996     0.150
     3.920   122.496     0.150
     4.007    72.793     0.150
     4.007   107.293     0.150
     4.007   118.094     0.150
     4.007   124.895     0.150
     4.167    63.793     0.150
     4.167   109.094     0.150
     4.167    74.395     0.150
     4.167   128.594     0.150
     4.391    68.793     0.150
     4.391   135.594     0.150
     4.391    76.594     0.150
     4.391   119.094     0.150
     4.500    80.293     0.150
     4.500   117.793     0.150
     4.500   139.395     0.150
     4.510    66.793     0.150
     4.510   138.395     0.150
     4.510    80.395     0.150
     4.846    73.895     0.150
     4.846   127.395     0.150
     4.846   149.695     0.150
     5.311    81.293     0.150
     5.311    79.996     0.150
     5.311    95.293     0.150
     5.311   139.395     0.150
     5.311   164.996     0.150
     5.392    80.742     0.150
     5.392   169.480     0.150
     7.020   101.293     0.150
     7.020   180.020     0.150
     7.020   217.219     0.150
     8.334   121.602     0.150
     8.334   152.641     0.150
     8.334   258.871     0.150
    13.641   193.945     0.150
    17.507   243.918     0.150
    18.066   251.395     0.150
    18.151   251.383     0.150
    40.088   456.195     0.150
    40.088   551.094     0.150
    40.088   581.793     0.150
    49.246   527.945     0.150
     0.219     5.152     0.150
     0.219     8.354     0.150
     0.409     8.254     0.150
     0.409    14.053     0.150
     0.657    12.553     0.150
     0.657    21.854     0.150
     0.756    14.254     0.150
     0.756    24.652     0.150
     1.223    22.053     0.150
     1.223    38.453     0.150
     1.255    23.354     0.150
     1.255    40.453     0.150
     1.353    24.553     0.150
     1.353    42.453     0.150
     1.353    24.754     0.150
     1.353    43.854     0.150
     1.815    31.754     0.150
     1.815    32.854     0.150
     1.815    55.453     0.150
     1.815    57.053     0.150
     1.857    32.354     0.150
     1.857    33.553     0.150
     1.857    56.152     0.150
     1.857    58.254     0.150
     1.818    32.652     0.150
     1.818    58.453     0.150
     1.840    34.053     0.150
     2.217    36.854     0.150
     2.217    38.953     0.150
     2.217    67.652     0.150
     2.217    39.152     0.150
     2.217    68.453     0.150
     2.261    37.553     0.150
     2.261    39.553     0.150
     2.261    64.152     0.150
     2.261    68.652     0.150
     2.261    37.754     0.150
     2.173    36.854     0.150
     2.173    39.754     0.150
     2.173    64.354     0.150
     2.173    68.652     0.150
     2.270    38.453     0.150
     2.270    40.854     0.150
     2.270    70.652     0.150
     2.270    70.053     0.150
     2.643    43.354     0.150
     2.643    47.053     0.150
     2.643    72.854     0.150
     2.643    81.354     0.150
     2.643    43.652     0.150
     2.643    78.553     0.150
     2.643    81.754     0.150
     2.665    49.152     0.150
     2.665    47.754     0.150
     2.665    75.754     0.150
     2.665    81.553     0.150
     2.665    83.354     0.150
     2.881    46.754     0.150
     2.881    51.553     0.150
     2.881    88.754     0.150
     2.881    46.152     0.150
     2.881    50.754     0.150
     2.881    88.953     0.150
     2.876    46.254     0.150
     2.876    51.354     0.150
     2.876    87.854     0.150
     2.876    46.652     0.150
     3.267    58.854     0.150
     3.267   100.854     0.150
     3.315    51.146     0.150
     3.315    59.570     0.150
     3.315    89.771     0.150
     3.315    98.320     0.150
     3.315    51.453     0.150
     3.315    52.254     0.150
     3.315    59.754     0.150
     3.315    90.152     0.150
     3.315   102.453     0.150
     3.753    67.953     0.150
     3.753   114.854     0.150
     3.753    58.053     0.150
     3.753    66.553     0.150
     3.753   115.453     0.150
     3.797    57.053     0.150
     3.797    68.053     0.150
     3.797   117.754     0.150
     3.797    57.652     0.150
     3.797    68.453     0.150
     3.797   117.953     0.150
     3.801    59.652     0.150
     3.801    68.453     0.150
     3.801   117.152     0.150
     3.801    59.754     0.150
     3.801   114.854     0.150
     3.801   117.953     0.150
     4.037    73.152     0.150
     4.037   125.453     0.150
     4.340    66.453     0.150
     4.340    77.652     0.150
     4.340   116.754     0.150
     4.340   133.854     0.150
     4.406    68.152     0.150
     4.406    68.553     0.150
     4.406    79.453     0.150
     4.406   137.254     0.150
     4.699    72.754     0.150
     4.699    73.254     0.150
     4.699    83.553     0.150
     4.699   125.453     0.150
     4.699   145.152     0.150
     4.869    88.053     0.150
     4.869   152.053     0.150
     4.869    72.053     0.150
     4.869   125.754     0.150
     4.869   150.053     0.150
     5.253    93.953     0.150
     5.253   162.152     0.150
     5.253    78.453     0.150
     5.038    77.553     0.150
     5.038    89.854     0.150
     5.038   132.354     0.150
     5.350    78.953     0.150
     5.350    95.453     0.150
     5.350    79.652     0.150
     5.350    96.053     0.150
     5.350   164.854     0.150
     5.882    87.254     0.150
     5.882    88.254     0.150
     5.882   182.953     0.150
     5.967    89.334     0.150
     5.967   184.559     0.150
     6.451    93.402     0.150
     6.451   165.242     0.150
     6.451   199.178     0.150
     7.105   220.652     0.150
     7.105   103.254     0.150
     8.439   119.371     0.150
     8.439   262.402     0.150
    13.650   193.350     0.150
    13.650   422.828     0.150
    17.742   245.953     0.150
    17.742   245.928     0.150
    17.742   249.152     0.150
    18.158   252.553     0.150
    18.244   250.729     0.150
    18.244   568.889     0.150
    20.180   273.172     0.150
    20.180   272.652     0.150
    22.254   295.975     0.150
    22.289   296.254     0.150
    32.053   385.254     0.150
    36.546   425.152     0.150
    41.787   467.729     0.150
    42.619   474.953     0.150
    47.614   514.188     0.150
    48.709   523.891     0.150
    59.410   600.855     0.150
    76.804   710.676     0.150
    76.804   712.152     0.150
    80.266   729.953     0.150
     0.151     4.453     0.150
     0.151     7.253     0.150
     0.401     8.053     0.150
     0.401    13.753     0.150
     0.474     9.653     0.150
     0.474    15.953     0.150
     0.635    12.053     0.150
     0.635    20.953     0.150
     0.704    13.953     0.150
     0.704    24.053     0.150
     0.916    16.753     0.150
     0.916    29.053     0.150
     1.265    23.353     0.150
     1.265    40.353     0.150
     1.294    24.053     0.150
     1.294    41.953     0.150
     1.293    24.453     0.150
     1.293    42.253     0.150
     1.310    24.253     0.150
     1.310    41.653     0.150
     1.460    26.053     0.150
     1.460    45.653     0.150
     1.615    28.453     0.150
     1.615    29.653     0.150
     1.615    50.553     0.150
     1.798    31.153     0.150
     1.798    32.653     0.150
     1.798    56.553     0.150
     2.186    35.753     0.150
     2.186    38.953     0.150
     2.186    62.453     0.150
     2.186    67.453     0.150
     2.284    40.653     0.150
     2.284    70.253     0.150
     2.434    40.153     0.150
     2.434    43.553     0.150
     2.434    68.653     0.150
     2.434    75.353     0.150
     2.661    43.053     0.150
     2.661    81.853     0.150
     2.816    44.853     0.150
     2.816    49.653     0.150
     2.816    85.953     0.150
     2.898    46.596     0.150
     2.898    52.421     0.150
     2.898    90.321     0.150
     2.898    46.453     0.150
     2.898    52.053     0.150
     2.898    89.553     0.150
     3.399    53.253     0.150
     3.399    60.353     0.150
     3.399   104.353     0.150
     3.457    54.153     0.150
     3.457    62.653     0.150
     3.457   108.053     0.150
     3.751    67.153     0.150
     3.751   116.053     0.150
     3.781   116.153     0.150
     3.917    60.953     0.150
     3.917    70.553     0.150
     3.917   121.853     0.150
     3.991    71.353     0.150
     3.991   106.053     0.150
     3.991   123.453     0.150
     4.173    63.653     0.150
     4.173    74.653     0.150
     4.173   128.453     0.150
     4.374    69.053     0.150
     4.374    78.053     0.150
     4.374   119.053     0.150
     4.374   134.853     0.150
     4.543    67.553     0.150
     4.543    81.553     0.150
     4.543   140.753     0.150
     4.503   139.053     0.150
     4.823    74.853     0.150
     4.823    86.253     0.150
     4.823   128.853     0.150
     4.823   148.953     0.150
     5.332    95.953     0.150
     5.332   165.453     0.150
     5.411    81.313     0.150
     5.411    96.092     0.150
     5.411   143.773     0.150
     5.411   168.453     0.150
     7.008    99.946     0.150
     7.008   178.953     0.150
     7.008   217.528     0.150
     8.365   118.226     0.150
     8.365   212.651     0.150
     8.365   258.851     0.150
    13.612   193.645     0.150
    13.612   423.253     0.150
    17.487   244.416     0.150
    18.125   253.103     0.150
    18.717   258.403     0.150
    20.738   279.921     0.150
    22.243   299.028     0.150
     0.284     5.982     0.150
     0.284    10.281     0.150
     0.492    10.082     0.150
     0.492    17.281     0.150
     0.538    10.383     0.150
     0.538    18.082     0.150
     0.558    11.383     0.150
     0.558    18.281     0.150
     0.790    14.582     0.150
     0.790    25.682     0.150
     0.905    16.182     0.150
     0.905    28.281     0.150
     1.256    23.883     0.150
     1.256    40.682     0.150
     1.498    26.781     0.150
     1.498    46.682     0.150
     1.720    30.883     0.150
     1.720    53.982     0.150
     1.804    33.182     0.150
     1.804    56.582     0.150
     1.841    34.082     0.150
     1.864    34.281     0.150
     1.864    58.582     0.150
     2.079    34.383     0.150
     2.079    36.682     0.150
     2.079    63.883     0.150
     2.106    35.281     0.150
     2.106    38.281     0.150
     2.106    65.982     0.150
     2.348    41.383     0.150
     2.348    72.082     0.150
     2.383    39.082     0.150
     2.383    43.082     0.150
     2.383    67.281     0.150
     2.383    75.182     0.150
     2.772    49.883     0.150
     2.772    87.281     0.150
     2.853    50.281     0.150
     2.853    88.082     0.150
     2.860    51.883     0.150
     2.860    89.582     0.150
     3.020    54.383     0.150
     3.020    93.781     0.150
     3.409   104.383     0.150
     3.482    62.781     0.150
     3.482   108.383     0.150
     3.588    63.883     0.150
     3.588   110.582     0.150
     4.024    72.082     0.150
     4.024   124.781     0.150
     4.497    80.781     0.150
     4.497   139.781     0.150
     4.510    66.182     0.150
     4.510    81.281     0.150
     4.510   140.281     0.150
     4.561   140.781     0.150
     4.936    73.982     0.150
     4.936    88.082     0.150
     4.936   152.582     0.150
     5.110    91.082     0.150
     5.110   157.482     0.150
     5.326   164.082     0.150
     5.336    80.781     0.150
     5.336    95.682     0.150
     5.336   164.883     0.150
     0.290     6.094     0.150
     0.290    10.891     0.150
     0.551    10.789     0.150
     0.551    18.789     0.150
     0.504    10.289     0.150
     0.504    18.195     0.150
     0.564    11.195     0.150
     0.564    19.094     0.150
     0.564    19.195     0.150
     0.894    27.891     0.150
     0.894    15.891     0.150
     0.804    14.992     0.150
     0.804    26.891     0.150
     1.270    23.594     0.150
     1.270    41.992     0.150
     1.512    27.195     0.150
     1.512    48.195     0.150
     1.512    47.992     0.150
     1.734    30.195     0.150
     1.734    31.594     0.150
     1.734    54.891     0.150
     1.818    31.195     0.150
     1.818    32.891     0.150
     1.818    55.492     0.150
     1.818    57.695     0.150
     1.856    31.992     0.150
     1.856    33.789     0.150
     1.879    32.492     0.150
     1.879    35.094     0.150
     1.879    58.695     0.150
     2.065    34.094     0.150
     2.065    36.492     0.150
     2.065    63.891     0.150
     2.120    35.594     0.150
     2.120    38.695     0.150
     2.120    67.195     0.150
     2.335    38.695     0.150
     2.335    68.492     0.150
     2.335    71.695     0.150
     2.335    38.891     0.150
     2.335    41.195     0.150
     2.300    38.094     0.150
     2.300    41.789     0.150
     2.300    73.289     0.150
     2.397    39.195     0.150
     2.397    43.289     0.150
     2.397    74.492     0.150
     2.839    45.094     0.150
     2.839    50.094     0.150
     2.839    88.289     0.150
     2.839    45.195     0.150
     2.839    50.289     0.150
     2.839    79.492     0.150
     2.839    88.094     0.150
     2.786    44.789     0.150
     2.786    50.891     0.150
     2.786    77.695     0.150
     2.786    86.891     0.150
     2.873    52.695     0.150
     2.873    88.391     0.150
     2.873    51.594     0.150
     3.034    47.992     0.150
     3.034    54.695     0.150
     3.034    83.594     0.150
     3.034    93.789     0.150
     3.216    57.492     0.150
     3.216    98.891     0.150
     3.406    61.195     0.150
     3.406   104.492     0.150
     3.406    53.492     0.150
     3.406    60.992     0.150
     3.406    93.289     0.150
     3.406   104.195     0.150
     3.574    55.094     0.150
     3.574    63.789     0.150
     3.574   110.195     0.150
     3.495    54.375     0.150
     3.495    62.188     0.150
     3.495    97.234     0.150
     3.495   106.461     0.150
     3.495    54.148     0.150
     3.495    62.789     0.150
     3.495   107.492     0.150
     3.909    72.594     0.150
     3.909   121.492     0.150
     4.036    61.789     0.150
     4.036    72.391     0.150
     4.036   124.695     0.150
     4.514    66.891     0.150
     4.514    80.695     0.150
     4.514   139.094     0.150
     4.514   138.094     0.150
     4.512    69.094     0.150
     4.512    81.695     0.150
     4.512   141.695     0.150
     4.573    69.289     0.150
     4.573    80.289     0.150
     4.573   140.289     0.150
     4.948    75.391     0.150
     4.948    85.891     0.150
     4.948   135.391     0.150
     4.948   151.992     0.150
     4.948    76.094     0.150
     4.948    89.695     0.150
     5.096    75.289     0.150
     5.096    92.391     0.150
     5.096   155.695     0.150
     5.311    79.789     0.150
     5.311   163.789     0.150
     5.347    80.891     0.150
     5.347   142.789     0.150
     5.347    81.195     0.150
     5.347    96.594     0.150
     5.736    84.805     0.150
     5.736    85.766     0.150
     5.736    86.289     0.150
     5.736   103.195     0.150
     5.736   178.695     0.150
     5.736    85.391     0.150
     5.848    87.133     0.150
     5.848   155.812     0.150
     5.848   182.734     0.150
     5.848    86.789     0.150
     6.809    98.891     0.150
     6.809   121.391     0.150
     6.809   210.695     0.150
     8.207   116.664     0.150
    14.086   197.094     0.150
    14.086   353.789     0.150
    14.022   198.594     0.150
    14.022   199.695     0.150
    14.473   202.609     0.150
    15.105   211.984     0.150
    15.105   214.094     0.150
    15.257   221.695     0.150
    16.773   236.195     0.150
    16.773   239.391     0.150
    16.773   244.891     0.150
    16.773   526.094     0.150
    18.036   250.094     0.150
    18.036   248.664     0.150
    18.036   249.992     0.150
    18.212   252.516     0.150
    18.508   255.844     0.150
    18.508   254.734     0.150
    18.508   256.594     0.150
    18.591   255.664     0.150
    18.591   255.266     0.150
    18.591   257.289     0.150
    18.594   255.469     0.150
    20.254   273.875     0.150
    20.254   272.789     0.150
    21.652   289.391     0.150
    22.632   300.914     0.150
    22.667   300.289     0.150
    22.802   301.414     0.150
    23.176   305.992     0.150
    23.725   312.266     0.150
    24.049   312.469     0.150
    24.215   316.836     0.150
    24.887   322.742     0.150
    24.966   324.266     0.150
    24.966   323.961     0.150
    27.001   341.961     0.150
    26.964   341.992     0.150
    27.032   341.844     0.150
    28.008   349.695     0.150
    28.127   349.930     0.150
    28.127   351.219     0.150
    28.416   399.391     0.150
    28.416   642.289     0.150
    28.416   720.695     0.150
    30.406   371.094     0.150
    30.919   377.172     0.150
    30.892   375.922     0.150
    31.001   378.383     0.150
    31.484   381.430     0.150
    39.958   454.094     0.150
    41.468   465.242     0.150
    42.166   470.516     0.150
    42.166   473.789     0.150
    42.998   478.492     0.150
    44.482   492.203     0.150
    47.625   519.289     0.150
    47.988   517.039     0.150
    48.683   523.641     0.150
    48.683   523.211     0.150
    49.615   530.641     0.150
    50.264   535.719     0.150
    51.123   542.266     0.150
    51.330   544.781     0.150
    51.504   544.102     0.150
    52.138   550.531     0.150
    52.728   554.711     0.150
    52.962   556.133     0.150
    53.869   562.992     0.150
    53.957   562.609     0.150
    54.725   570.195     0.150
    55.316   574.695     0.150
    55.668   577.055     0.150
    55.857   578.570     0.150
    56.529   582.961     0.150
    56.719   584.461     0.150
    56.792   585.016     0.150
    57.334   588.633     0.150
    57.478   588.539     0.150
    57.523   589.281     0.150
    58.389   596.172     0.150
    59.078   598.789     0.150
    59.466   600.945     0.150
    61.969   619.914     0.150
    65.121   642.086     0.150
    76.196   708.672     0.150
    76.483   709.016     0.150
    79.166   725.422     0.150
    79.911   729.250     0.150
    79.951   728.344     0.150
    79.951   728.195     0.150
    84.870   754.891     0.150
    85.646   758.664     0.150
    87.170   764.695     0.150
    89.236   775.352     0.150
    89.336   777.234     0.150
   150.868  1190.141     0.150
     0.210     4.664     0.150
     0.210     8.164     0.150
     0.337     6.562     0.150
     0.337    11.461     0.150
     0.396     7.363     0.150
     0.396    13.062     0.150
     0.452     8.762     0.150
     0.452    15.062     0.150
     0.939    17.961     0.150
     0.939    31.363     0.150
     1.196    21.762     0.150
     1.196    37.961     0.150
     1.183    21.664     0.150
     1.183    23.062     0.150
     1.183    38.262     0.150
     1.460    26.363     0.150
     1.460    27.562     0.150
     1.460    46.262     0.150
     1.493    27.461     0.150
     1.493    47.363     0.150
     1.528    28.363     0.150
     1.528    48.562     0.150
     1.814    32.961     0.150
     1.814    57.461     0.150
     2.061    37.363     0.150
     2.061    65.062     0.150
     2.401    39.961     0.150
     2.401    42.562     0.150
     2.401    74.164     0.150
     2.451    40.762     0.150
     2.451    44.664     0.150
     2.451    71.262     0.150
     2.451    76.062     0.150
     2.550    79.664     0.150
     2.700    44.262     0.150
     2.700    49.062     0.150
     2.700    84.164     0.150
     3.161    56.461     0.150
     3.161    97.664     0.150
     3.165    57.363     0.150
     3.165    97.762     0.150
     3.565   110.363     0.150
     3.720    58.461     0.150
     3.720    67.664     0.150
     3.720   112.961     0.150
     3.720   116.664     0.150
     3.909    61.062     0.150
     3.909    69.961     0.150
     3.909   121.762     0.150
     4.175    76.164     0.150
     4.175   130.562     0.150
     4.245   131.762     0.150
     0.330     6.102     0.150
     0.330    11.203     0.150
     0.314     6.406     0.150
     0.314    11.102     0.150
     0.275     6.008     0.150
     0.275    10.602     0.150
     0.502     9.602     0.150
     0.502    16.805     0.150
     0.976    18.906     0.150
     0.976    31.906     0.150
     1.136    20.406     0.150
     1.136    35.703     0.150
     1.239    22.102     0.150
     1.239    23.602     0.150
     1.239    39.703     0.150
     1.467    26.602     0.150
     1.467    46.508     0.150
     1.525    28.102     0.150
     1.525    48.602     0.150
     1.562    28.805     0.150
     1.562    49.008     0.150
     1.585    29.305     0.150
     1.585    50.805     0.150
     1.835    33.602     0.150
     1.835    58.508     0.150
     2.006    36.508     0.150
     2.006    62.805     0.150
     2.110    38.102     0.150
     2.110    65.906     0.150
     2.602    43.102     0.150
     2.602    46.703     0.150
     2.602    76.602     0.150
     2.602    79.602     0.150
     2.502    41.102     0.150
     2.502    44.906     0.150
     2.502    77.602     0.150
     2.608    44.102     0.150
     2.608    47.406     0.150
     2.608    80.703     0.150
     2.752    44.508     0.150
     2.752    50.203     0.150
     2.752    85.703     0.150
     3.130    49.508     0.150
     3.130    55.703     0.150
     3.130    97.008     0.150
     3.219    51.070     0.150
     3.219    57.352     0.150
     3.219    98.477     0.150
     3.219    57.805     0.150
     3.219    99.805     0.150
     3.501    62.805     0.150
     3.501   108.508     0.150
     3.860    59.703     0.150
     3.860    69.508     0.150
     3.860   119.805     0.150
     3.780    67.805     0.150
     3.780   117.406     0.150
     5.586    83.805     0.150
     5.586    99.547     0.150
     5.586   173.586     0.150
     6.794    98.102     0.150
     6.794   174.758     0.150
     6.794   210.930     0.150
     8.132   114.938     0.150
     8.132   251.531     0.150
    13.879   196.328     0.150
    13.879   430.031     0.150
    17.805   249.797     0.150
    18.416   253.789     0.150
    18.416   580.008     0.150
    18.721   583.680     0.150
    20.527   276.398     0.150
    20.527   496.852     0.150
    20.527   639.320     0.150
    22.503   300.477     0.150
    76.361   707.992     0.150
    79.823   726.883     0.150
     0.127     4.090     0.150
     0.127     6.889     0.150
     0.345     7.090     0.150
     0.345    12.488     0.150
     0.351     7.590     0.150
     0.351    13.389     0.150
     0.374     7.488     0.150
     0.374    13.090     0.150
     0.652    12.488     0.150
     0.652    21.789     0.150
     0.832    15.988     0.150
     0.832    27.789     0.150
     1.164    21.389     0.150
     1.164    37.389     0.150
     1.222    22.189     0.150
     1.222    38.590     0.150
     1.274    23.189     0.150
     1.274    40.289     0.150
     1.365    25.090     0.150
     1.365    43.289     0.150
     1.406    25.988     0.150
     1.406    44.590     0.150
     1.655    29.189     0.150
     1.655    30.090     0.150
     1.655    52.488     0.150
     1.861    34.189     0.150
     1.861    58.988     0.150
     1.998    32.988     0.150
     1.998    36.389     0.150
     1.998    62.590     0.150
     2.502    39.988     0.150
     2.502    44.590     0.150
     2.502    77.488     0.150
     2.534    78.389     0.150
     2.649    42.389     0.150
     2.649    48.189     0.150
     2.649    73.689     0.150
     2.649    82.389     0.150
     2.793    44.689     0.150
     2.793    49.889     0.150
     2.793    86.189     0.150
     3.125    48.531     0.150
     3.125    55.434     0.150
     3.125    95.383     0.150
     3.125    56.488     0.150
     3.125    96.590     0.150
     3.301    51.389     0.150
     3.301    59.289     0.150
     3.301   101.889     0.150
     3.447    52.988     0.150
     3.447    61.988     0.150
     3.447   107.090     0.150
     3.677    56.289     0.150
     3.677   113.789     0.150
     3.987    60.488     0.150
     3.987    71.590     0.150
     3.987   123.189     0.150
     5.392    79.766     0.150
     5.392    97.049     0.150
     5.392   167.791     0.150
     6.984   100.775     0.150
     6.984   217.320     0.150
     8.063   113.674     0.150
     8.063   252.564     0.150
    13.916   431.527     0.150
    17.762   247.227     0.150
    18.424   253.291     0.150
    22.547   299.193     0.150
    49.144   526.465     0.150
     0.194     5.293     0.150
     0.194     8.594     0.150
     0.194     8.793     0.150
     0.329     7.094     0.150
     0.329    11.594     0.150
     0.329    11.895     0.150
     0.410     8.395     0.150
     0.410    14.094     0.150
     0.526    10.492     0.150
     0.526    17.793     0.150
     0.585    11.395     0.150
     0.585    19.492     0.150
     0.699    14.094     0.150
     0.699    23.695     0.150
     0.953    17.492     0.150
     0.953    29.793     0.150
     0.953    30.492     0.150
     1.256    23.395     0.150
     1.256    39.992     0.150
     1.270    23.492     0.150
     1.270    39.992     0.150
     1.289    23.793     0.150
     1.289    41.094     0.150
     1.420    44.695     0.150
     1.420    25.395     0.150
     1.420    45.094     0.150
     1.593    28.492     0.150
     1.593    49.793     0.150
     1.820    30.992     0.150
     1.820    33.293     0.150
     1.820    57.293     0.150
     2.211    35.492     0.150
     2.211    38.992     0.150
     2.211    62.793     0.150
     2.211    67.793     0.150
     2.211    36.492     0.150
     2.211    39.492     0.150
     2.211    68.195     0.150
     2.323    40.992     0.150
     2.323    70.395     0.150
     2.323    41.195     0.150
     2.323    71.293     0.150
     2.462    39.695     0.150
     2.462    43.695     0.150
     2.462    75.793     0.150
     2.645    42.492     0.150
     2.645    46.895     0.150
     2.645    81.793     0.150
     2.834    87.395     0.150
     2.930    46.762     0.150
     2.930    89.438     0.150
     2.930    52.395     0.150
     2.930    90.395     0.150
     3.399    53.094     0.150
     3.399    60.195     0.150
     3.399    52.492     0.150
     3.399    60.992     0.150
     3.399   105.094     0.150
     3.499    62.195     0.150
     3.499   107.195     0.150
     3.499    53.992     0.150
     3.499    62.992     0.150
     3.499   109.094     0.150
     3.683    56.492     0.150
     3.683    65.195     0.150
     3.683    97.395     0.150
     3.683   112.094     0.150
     4.151    62.395     0.150
     4.151    73.992     0.150
     4.151   128.594     0.150
     4.473    66.492     0.150
     4.473    80.492     0.150
     4.473   138.594     0.150
     5.379    80.613     0.150
     5.379    96.793     0.150
     5.379   141.535     0.150
     5.379   168.094     0.150
     7.027   102.070     0.150
     7.027   125.793     0.150
     7.027   179.770     0.150
     7.027   218.242     0.150
     8.295   149.895     0.150
     8.295   259.844     0.150
    13.679   423.695     0.150
     0.277     6.191     0.150
     0.277    10.691     0.150
     0.277    10.492     0.150
     0.689    13.191     0.150
     0.689    23.590     0.150
     0.689    23.391     0.150
     1.279    23.691     0.150
     1.279    41.789     0.150
     1.279    23.090     0.150
     1.279    23.492     0.150
     1.279    40.090     0.150
     1.279    41.289     0.150
     1.383    24.590     0.150
     1.383    43.492     0.150
     1.383    24.289     0.150
     1.383    42.492     0.150
     1.669    27.992     0.150
     1.669    29.391     0.150
     1.669    51.992     0.150
     1.669    29.289     0.150
     1.669    51.691     0.150
     1.847    33.789     0.150
     2.037    33.492     0.150
     2.037    36.492     0.150
     2.037    64.289     0.150
     2.218    35.789     0.150
     2.218    39.891     0.150
     2.218    69.492     0.150
     2.375    42.789     0.150
     2.375    74.891     0.150
     2.391    42.191     0.150
     2.391    73.789     0.150
     2.510    40.691     0.150
     2.510    45.789     0.150
     2.510    79.391     0.150
     2.626    79.992     0.150
     2.626    46.289     0.150
     2.626    81.191     0.150
     2.616    45.789     0.150
     2.616    79.789     0.150
     3.036    47.090     0.150
     3.036    53.492     0.150
     3.036    92.691     0.150
     3.036    53.289     0.150
     3.036    93.191     0.150
     3.588   110.891     0.150
     0.270     6.611     0.150
     0.270    11.111     0.150
     0.295     6.811     0.150
     0.295    11.611     0.150
     0.524    10.111     0.150
     0.524    17.011     0.150
     0.598    11.611     0.150
     0.598    19.911     0.150
     0.805    15.011     0.150
     0.805    25.911     0.150
     1.179    20.811     0.150
     1.179    36.111     0.150
     1.140    21.511     0.150
     1.140    36.511     0.150
     1.292    23.211     0.150
     1.292    23.611     0.150
     1.292    40.811     0.150
     1.292    41.311     0.150
     1.713    29.311     0.150
     1.713    31.211     0.150
     1.713    51.311     0.150
     1.713    53.811     0.150
     1.722    31.411     0.150
     1.722    54.811     0.150
     1.730    31.211     0.150
     1.730    53.611     0.150
     2.045    34.311     0.150
     2.045    36.911     0.150
     2.045    64.011     0.150
     2.263    36.511     0.150
     2.263    39.511     0.150
     2.263    63.311     0.150
     2.200    39.911     0.150
     2.200    68.711     0.150
     2.382    38.611     0.150
     2.382    41.711     0.150
     2.382    66.311     0.150
     2.382    67.411     0.150
     2.382    72.511     0.150
     2.580    41.111     0.150
     2.580    46.011     0.150
     2.580    75.111     0.150
     2.580    79.411     0.150
     2.631    80.811     0.150
     2.820    44.311     0.150
     2.820    50.511     0.150
     2.820    77.911     0.150
     2.820    86.411     0.150
     2.968    46.411     0.150
     2.968    52.211     0.150
     2.968    90.411     0.150
     3.270    56.779     0.150
     3.270    89.129     0.150
     3.692   114.011     0.150
     3.791    57.411     0.150
     3.791    67.011     0.150
     3.791   116.011     0.150
     5.828   104.451     0.150
     5.828   179.491     0.150
     6.575    94.636     0.150
     6.575   168.211     0.150
     6.575   203.011     0.150
     8.332   148.911     0.150
     8.332   257.761     0.150
    13.726   343.536     0.150
    13.726   426.286     0.150
    17.758   245.111     0.150
    20.306   273.379     0.150
    22.338   297.511     0.150
     0.216     5.055     0.150
     0.216     8.555     0.150
     0.314     6.250     0.150
     0.314    10.555     0.150
     0.389     7.453     0.150
     0.389    12.750     0.150
     0.584    10.852     0.150
     0.584    19.148     0.150
     0.548    10.648     0.150
     0.548    17.953     0.150
     0.686    13.555     0.150
     0.686    22.953     0.150
     0.951    17.453     0.150
     0.951    30.852     0.150
     1.250    22.852     0.150
     1.250    39.352     0.150
     1.250    42.648     0.150
     1.275    24.648     0.150
     1.290    25.352     0.150
     1.290    42.250     0.150
     1.290    45.148     0.150
     1.422    26.055     0.150
     1.422    44.953     0.150
     1.575    28.750     0.150
     1.575    49.648     0.150
     1.713    30.852     0.150
     1.713    54.055     0.150
     1.813    33.055     0.150
     1.813    57.453     0.150
     2.205    36.953     0.150
     2.205    39.750     0.150
     2.205    68.953     0.150
     2.322    42.352     0.150
     2.322    72.055     0.150
     2.457    40.648     0.150
     2.457    44.250     0.150
     2.457    76.453     0.150
     2.654    42.953     0.150
     2.654    47.953     0.150
     2.654    82.250     0.150
     2.851    46.555     0.150
     2.851    50.953     0.150
     2.851    87.953     0.150
     2.926    47.148     0.150
     2.926    52.852     0.150
     2.926    90.250     0.150
     3.413    53.750     0.150
     3.413    60.648     0.150
     3.413   105.250     0.150
     3.499    56.055     0.150
     3.499    63.055     0.150
     3.499   106.055     0.150
     3.499   109.352     0.150
     3.499   110.953     0.150
     3.922    61.750     0.150
     3.922    71.148     0.150
     3.922   122.852     0.150
     5.360    81.969     0.150
     5.360    97.312     0.150
     5.360   145.328     0.150
     5.360   167.109     0.150
     7.045   101.875     0.150
     8.282   120.273     0.150
     8.282   148.500     0.150
     8.282   257.078     0.150
    13.690   426.805     0.150
    17.540   246.086     0.150
    18.194   254.344     0.150
    22.323   298.789     0.150
    60.001   605.617     0.150
     0.226     5.109     0.150
     0.226     8.008     0.150
     0.226     8.812     0.150
     0.355     7.609     0.150
     0.355    12.906     0.150
     0.566    11.609     0.150
     0.566    19.812     0.150
     0.605    11.109     0.150
     0.605    19.711     0.150
     1.015    18.109     0.150
     1.015    31.609     0.150
     1.082    21.312     0.150
     1.082    35.812     0.150
     1.360    24.312     0.150
     1.360    44.008     0.150
     1.536    27.906     0.150
     1.536    48.406     0.150
     1.625    29.711     0.150
     1.625    51.109     0.150
     1.921    34.906     0.150
     1.921    60.609     0.150
     2.247    36.609     0.150
     2.247    39.109     0.150
     2.247    68.812     0.150
     2.227    39.812     0.150
     2.227    69.211     0.150
     2.620    41.906     0.150
     2.620    47.609     0.150
     2.620    72.906     0.150
     2.620    79.508     0.150
     2.620    81.312     0.150
     2.871    44.812     0.150
     2.871    51.211     0.150
     2.871    79.406     0.150
     2.871    88.711     0.150
     0.308     6.176     0.150
     0.308    10.176     0.150
     0.376     7.375     0.150
     0.376    12.277     0.150
     0.561    11.078     0.150
     0.561    18.277     0.150
     0.586    10.875     0.150
     0.586    18.875     0.150
     0.676    13.477     0.150
     0.676    21.676     0.150
     0.948    17.977     0.150
     0.948    31.477     0.150
     1.237    22.875     0.150
     1.237    39.176     0.150
     1.232    23.176     0.150
     1.232    38.977     0.150
     1.426    26.078     0.150
     1.426    44.676     0.150
     1.564    28.777     0.150
     1.807    33.477     0.150
     1.807    57.676     0.150
     2.199    37.578     0.150
     2.199    39.777     0.150
     2.199    69.277     0.150
     2.320    42.578     0.150
     2.320    72.676     0.150
     2.452    40.977     0.150
     2.452    44.578     0.150
     2.452    76.375     0.150
     2.662    43.277     0.150
     2.662    47.977     0.150
     2.662    82.578     0.150
     2.863    46.777     0.150
     2.863    51.176     0.150
     2.863    88.078     0.150
     2.922    47.277     0.150
     2.922    52.578     0.150
     2.922    90.977     0.150
     3.422    61.375     0.150
     3.422   106.078     0.150
     3.497    55.676     0.150
     3.497    63.176     0.150
     3.497   108.777     0.150
     3.666    65.676     0.150
     3.666   112.676     0.150
     3.915    71.277     0.150
     3.915   122.777     0.150
     4.165    64.578     0.150
     4.165    75.277     0.150
     4.165   129.277     0.150
     4.442    67.477     0.150
     4.442    79.375     0.150
     4.442   137.676     0.150
     5.347    81.258     0.150
     5.347    97.535     0.150
     5.347   165.637     0.150
     7.056   101.852     0.150
     7.056   219.816     0.150
     8.275   259.078     0.150
    13.695   428.027     0.150
    17.539   246.477     0.150
     0.267     5.484     0.150
     0.267     9.484     0.150
     0.372     7.684     0.150
     0.372    13.086     0.150
     0.524    10.383     0.150
     0.524    17.684     0.150
     0.617    11.785     0.150
     0.617    20.383     0.150
     1.042    18.586     0.150
     1.042    32.484     0.150
     1.074    20.184     0.150
     1.074    34.785     0.150
     1.337    23.883     0.150
     1.337    25.086     0.150
     1.337    42.285     0.150
     1.337    43.883     0.150
     1.925    33.086     0.150
     1.925    34.785     0.150
     1.925    60.586     0.150
     2.258    36.684     0.150
     2.258    39.383     0.150
     2.258    68.883     0.150
     2.520    44.383     0.150
     2.520    77.086     0.150
     2.602    41.984     0.150
     2.602    46.883     0.150
     2.602    72.984     0.150
     2.602    80.984     0.150
     2.852    44.785     0.150
     2.852    50.785     0.150
     2.852    88.086     0.150
     3.036    54.285     0.150
     3.036    93.484     0.150
     3.760    58.184     0.150
     3.760    66.785     0.150
     3.760   116.184     0.150
     0.159     3.457     0.150
     0.159     5.758     0.150
     0.285     5.859     0.150
     0.285     9.859     0.150
     0.333     7.160     0.150
     0.333    12.258     0.150
     0.478     8.758     0.150
     0.478    15.160     0.150
     0.658    12.559     0.150
     0.658    21.859     0.150
     0.729    14.059     0.150
     0.729    24.359     0.150
     1.064    19.758     0.150
     1.064    35.059     0.150
     1.201    22.160     0.150
     1.201    23.559     0.150
     1.201    38.258     0.150
     1.201    41.359     0.150
     1.266    23.359     0.150
     1.266    40.258     0.150
     1.326    23.660     0.150
     1.326    41.359     0.150
     1.566    28.660     0.150
     1.759    31.359     0.150
     1.759    32.457     0.150
     1.759    56.258     0.150
     1.894    33.359     0.150
     1.894    34.859     0.150
     1.894    59.957     0.150
     2.289    38.258     0.150
     2.289    41.457     0.150
     2.289    66.660     0.150
     2.289    70.859     0.150
     2.432    44.559     0.150
     2.432    75.660     0.150
     2.545    41.957     0.150
     2.545    46.160     0.150
     2.545    78.758     0.150
     2.602    42.258     0.150
     2.602    45.957     0.150
     2.602    80.457     0.150
     2.871    46.457     0.150
     2.871    51.660     0.150
     2.871    88.457     0.150
     3.021    48.355     0.150
     3.021    53.738     0.150
     3.021    92.656     0.150
     3.021    54.559     0.150
     3.021    94.359     0.150
     3.394    53.660     0.150
     3.394    61.059     0.150
     3.394   104.957     0.150
     3.518    63.258     0.150
     3.518    96.660     0.150
     3.518   109.059     0.150
     3.614    57.359     0.150
     3.614    63.957     0.150
     3.614    65.660     0.150
     3.614   109.457     0.150
     3.614   113.059     0.150
     4.309    64.957     0.150
     4.309    77.758     0.150
     4.309   113.859     0.150
     4.309   133.160     0.150
     5.320    80.699     0.150
     5.320    96.359     0.150
     5.320   167.309     0.150
     7.063   103.855     0.150
     7.063   219.594     0.150
    15.340   478.297     0.150
    17.665   246.902     0.150
EOF
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jBL  << EOF
    60.000   140.000 P phases in red
EOF
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL  << EOF
    60.000   100.000 S phases in green
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL  << EOF
    60.000    60.000 Readings used for cluster vectors in black
EOF
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    60.000    20.000 Readings not used for cluster vectors in cyan
EOF
gmt end
