#!/bin/bash
gmt begin ushkan1.37_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-17/17/-17/17
gmt basemap $proj $reg -Bxa10f5+l'km' -Bya10f5+l'km' -BWeSn+t'Epicentral Mislocation ushkan1.37'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     5.593     5.593
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.024     2.279
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.866     4.586
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.292   -10.657
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.292   -10.657 3
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.890    -6.738
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.890    -6.738 4
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.151    -2.025
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.209    -3.532
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.197    -2.076
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.351    -1.357
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.781    -0.292
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.970     2.582
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.730     2.387
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.186    -1.531
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.398    -1.118
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.740     2.579
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.335     7.569
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.335     7.569 15
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.068    -1.526
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.456     0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.043     1.230
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.227     0.572
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.086     0.978
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.876    -1.970
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.786    -0.503
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.590    -0.457
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.219     0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.072     1.102
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.426     0.180
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.854     1.612
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.745    -0.403
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.648    -0.058
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.237     3.222
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.470    -0.755
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.501     3.163
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.847     2.207
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.023     0.393
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.897     0.203
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.025     4.089
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.025     4.089 36
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.796     1.875
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.690     0.852
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.608     0.431
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.865     3.243
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.353     1.822
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.353     1.822 41
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.068     1.850
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.443     0.610
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.957    -0.893
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.218     0.149
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.688    -0.771
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.388     0.867
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.493     2.624
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.493     2.624 48
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.371     5.306
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.109     1.189
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.820     2.136
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.102     1.763
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.773     1.371
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.773     1.371 53
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.627     2.051
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.232     2.222
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.880     2.092
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.277     0.767
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.006    -0.584
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.290     0.527
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.226     1.184
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.862     0.464
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.799    -2.894
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.799    -2.894 62
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.708     0.237
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     2.229
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.505     1.336
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.505     1.336 65
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.769    -0.639
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.241     0.157
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.641     1.107
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.793     0.132
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.242     2.305
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.979     1.943
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.979     1.943 71
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.009    -0.583
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.672     2.911
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.541     1.488
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.231     1.896
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.549     4.473
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.389     0.461
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.407     0.377
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.477    -2.690
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.016     0.053
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.154     2.201
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.444     0.974
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.477     0.481
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.999     0.848
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.758     4.084
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.758     4.084 85
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.389     2.865
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.389     2.865 86
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.693     1.635
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.895     3.154
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.123    -3.706
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.123    -3.706 89
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.986     1.068
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.100     1.416
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.764     4.333
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.757    -0.290
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.610     1.304
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.873     3.500
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.380     0.463
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.415     1.415
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.392     1.981
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.392     1.981 98
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.013     1.157
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.429     3.054
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.519     1.811
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.232     1.089
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.775    -0.249
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.367     1.008
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.021    -1.170
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.021    -1.170 105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.167    -0.146
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.704     1.892
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.051     1.474
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.280     0.526
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.974     1.246
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.092     1.359
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.165     2.309
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.382     1.590
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.808     3.016
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.791     2.174
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.645    -4.315
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.645    -4.315 116
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.066     3.095
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.862    -0.985
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.388     4.336
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.772     0.250
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.788     1.015
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.606     1.551
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.204     3.886
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.542     0.222
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.408     0.179
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.950     2.565
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.032     1.080
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.695     0.331
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.652    -3.390
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.652    -3.390 129
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.269    -1.255
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.883    -0.504
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.184     1.970
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.459     2.603
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.866     1.406
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.564     0.933
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.772     0.236
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.772     0.236 136
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.345    -0.470
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.654     9.380
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.654     9.380 138
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.234     6.704
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.234     6.704 139
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.450     1.022
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.450     1.022 140
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.028     2.422
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.350     1.857
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.003     1.455
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.682     0.377
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.679     1.566
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.597     4.639
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.520     1.183
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    13.520     1.183 147
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.581     0.704
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.687     1.700
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.862     9.362
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.862     9.362 150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.314     3.095
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.728    -1.092
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.584     0.251
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.134     1.090
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.118     1.033
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.487    -1.036
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.571    -5.016
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.571    -5.016 157
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.527    -0.725
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.563    -1.207
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.534     3.373
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.619    -4.809
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.619    -4.809 161
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.257     2.499
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.257     2.499 162
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.465     0.449
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.319    -0.372
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.359     1.440
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.110     2.038
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.833     5.322
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.833     5.322 167
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.040     0.427
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.561     0.830
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.828     0.630
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.122     0.770
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.628    -4.232
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.628    -4.232 172
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.189     4.488
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.850    -0.926
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.150     0.965
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.138     1.611
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.126     0.074
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.704    -0.299
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.465     3.271
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.939     0.843
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.777     2.257
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.252     1.586
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.360     4.016
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.360     4.016 183
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.515    -3.568
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.267     2.597
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.678    -1.017
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.678    -1.017 186
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.499     1.050
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.785     2.086
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.785     2.086 188
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.602     0.282
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.369    -3.507
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.636    -1.417
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.334     3.002
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.007     6.063
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.007     6.063 193
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.547     0.562
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.004     0.246
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.462     1.514
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.709     0.828
EOF
gmt plot $proj $reg -SE -Gred << EOF
     2.626     0.973     0.000     1.500     1.500
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -15.500    15.500 Author: all ( 197 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -15.500   -15.500 Average =   2.8 km at  69.7 deg; median =    2.8 km
EOF
gmt end
