#!/bin/bash
gmt begin ushkan1.37_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-26/18/0/82
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya50f10+lCounts -BWeSn+t'Focal Depth Mislocation ushkan1.37' << EOF
    -0.000
     5.700
     1.000
    -8.000
    -0.000
    -0.000
    -0.000
    -2.000
     6.000
    -2.000
     6.000
     5.000
     6.000
    -0.000
    -5.100
    -0.000
     9.000
    -0.000
     5.000
     3.000
     0.300
     7.000
    -0.000
    -1.000
    -0.000
    -0.000
    -0.000
    -0.000
     2.000
    -0.000
    -0.000
     1.000
    -1.000
     7.000
     1.000
    -5.200
     6.200
     5.000
    -2.000
    -4.200
    -0.600
    -0.000
    -0.000
     1.000
    -0.000
     4.000
    -0.000
    -1.000
     0.200
    -0.000
     2.000
    -0.000
    -0.200
    -0.000
    -0.000
     3.000
    -7.000
     1.000
    -0.000
    -0.000
    -0.000
   -14.000
   -10.000
    -0.000
   -12.000
     4.000
    -0.000
    -0.000
     4.000
    -0.000
    -0.000
    -0.000
   -15.100
    -0.000
    -0.000
    -5.500
     3.000
    -8.000
     7.000
    -0.000
    -0.000
     1.000
    -0.000
     1.000
    -6.400
    -9.400
     8.000
     3.000
     0.100
     5.000
     3.000
     1.000
    -1.000
     4.000
   -14.100
    -4.400
     6.000
     6.700
    -0.000
    -0.000
    -0.000
    -0.000
    -0.000
   -10.000
    -7.800
    -0.000
    -2.000
    -0.000
    -0.000
    -0.000
    -0.000
   -16.900
     5.000
    -0.000
     1.000
    -0.000
     3.000
     1.000
    -0.300
     2.600
    -0.000
    -0.000
    -5.700
     3.000
    -0.000
   -12.300
   -10.700
    -0.000
     0.300
    -2.000
    -0.000
     3.000
    -0.000
     6.000
    -1.000
    -2.000
     8.000
    -7.600
   -11.100
    -8.000
     4.000
     3.000
    -1.000
     5.000
     5.000
    -1.000
    -8.600
    -3.000
    -1.000
    -0.000
     5.000
    -3.000
     5.000
     3.000
    13.000
     0.300
    -0.300
     4.000
    -2.500
     1.000
     1.800
    -6.500
     4.000
    -0.400
     4.500
     3.000
     0.200
     6.000
    -2.000
     4.000
     6.000
    -0.900
    -8.000
     4.000
   -15.000
    -0.000
    -5.400
     2.000
    -1.800
     2.000
     6.000
    -1.200
   -10.900
    -5.800
     4.000
   -10.600
     5.000
    -0.000
     3.000
     2.000
     2.000
   -21.000
    -9.000
     6.000
     9.000
    -0.000
     6.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -0.000    72.305 Median =  -0.0 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -0.0  0.
 -0.0  70.9
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -25.000    77.695 Author: all ( 197 samples)
EOF
gmt end
