#!/bin/bash
gmt begin ushkan1.37_dcal pdf,ps
proj=-JM16.0c+
reg=-R104.0/113.1/51.1/55.8
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration ushkan1.37'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
   108.300    54.100
   108.434    53.900
>
   107.595    53.643
   107.085    53.455
>
   107.595    53.643
   107.085    53.455
>
   106.348    52.760
   107.085    53.455
>
   106.348    52.760
   107.085    53.455
>
   107.595    53.643
   107.872    53.471
>
   107.595    53.643
   107.872    53.471
>
   109.999    53.658
   109.838    53.418
>
   109.999    53.658
   109.838    53.418
>
   107.595    53.643
   107.637    53.382
>
   107.595    53.643
   107.637    53.382
>
   107.595    53.643
   107.542    53.319
>
   107.595    53.643
   107.542    53.319
>
   107.595    53.643
   107.575    53.362
>
   107.595    53.643
   107.575    53.362
>
   107.595    53.643
   107.528    53.333
>
   107.595    53.643
   107.528    53.333
>
   107.595    53.643
   107.731    53.299
>
   107.595    53.643
   107.731    53.299
>
   108.745    53.263
   108.357    53.304
>
   108.745    53.263
   108.357    53.304
>
   107.595    53.643
   108.357    53.304
>
   107.595    53.643
   108.357    53.304
>
   108.745    53.263
   108.504    53.290
>
   108.745    53.263
   108.504    53.290
>
   107.595    53.643
   108.504    53.290
>
   107.595    53.643
   108.504    53.290
>
   107.595    53.643
   107.751    53.327
>
   107.595    53.643
   107.751    53.327
>
   108.745    53.263
   108.312    53.242
>
   108.745    53.263
   108.312    53.242
>
   108.745    53.263
   108.312    53.242
>
   107.595    53.643
   108.312    53.242
>
   107.595    53.643
   108.312    53.242
>
   108.745    53.263
   108.824    53.044
>
   108.745    53.263
   108.824    53.044
>
   108.745    53.263
   108.513    53.110
>
   108.745    53.263
   108.513    53.110
>
   107.595    53.643
   108.513    53.110
>
   107.595    53.643
   108.513    53.110
>
   108.745    53.263
   108.361    53.529
>
   108.745    53.263
   108.361    53.529
>
   107.595    53.643
   108.361    53.529
>
   107.595    53.643
   108.361    53.529
>
   108.745    53.263
   108.252    53.245
>
   108.745    53.263
   108.252    53.245
>
   107.595    53.643
   108.252    53.245
>
   107.595    53.643
   108.252    53.245
>
   108.745    53.263
   108.584    53.331
>
   108.745    53.263
   108.584    53.331
>
   107.595    53.643
   108.584    53.331
>
   107.595    53.643
   108.584    53.331
>
   108.745    53.263
   108.322    53.310
>
   108.745    53.263
   108.322    53.310
>
   107.595    53.643
   108.322    53.310
>
   107.595    53.643
   108.322    53.310
>
   107.595    53.643
   108.322    53.310
>
   108.745    53.263
   108.428    53.365
>
   108.745    53.263
   108.428    53.365
>
   108.745    53.263
   109.011    53.434
>
   108.745    53.263
   109.011    53.434
>
   109.999    53.658
   109.011    53.434
>
   109.999    53.658
   109.011    53.434
>
   107.595    53.643
   109.011    53.434
>
   107.595    53.643
   109.011    53.434
>
   108.745    53.263
   108.877    53.030
>
   108.745    53.263
   108.877    53.030
>
   108.745    53.263
   108.589    53.280
>
   108.745    53.263
   108.589    53.280
>
   107.595    53.643
   108.589    53.280
>
   107.595    53.643
   108.589    53.280
>
   107.595    53.643
   108.589    53.280
>
   108.745    53.263
   108.839    53.058
>
   108.745    53.263
   108.839    53.058
>
   109.999    53.658
   109.552    53.466
>
   109.999    53.658
   109.552    53.466
>
   108.745    53.263
   108.404    53.294
>
   108.745    53.263
   108.404    53.294
>
   107.595    53.643
   108.404    53.294
>
   107.595    53.643
   108.404    53.294
>
   107.595    53.643
   108.404    53.294
>
   107.595    53.643
   107.685    53.390
>
   107.595    53.643
   107.685    53.390
>
   107.595    53.643
   107.685    53.390
>
   108.745    53.263
   107.685    53.390
>
   108.745    53.263
   107.685    53.390
>
   108.745    53.263
   108.459    53.511
>
   108.745    53.263
   108.459    53.511
>
   107.595    53.643
   108.459    53.511
>
   107.595    53.643
   108.459    53.511
>
   109.999    53.658
   109.763    53.457
>
   109.999    53.658
   109.763    53.457
>
   109.999    53.658
   109.763    53.457
>
   109.999    53.658
   109.763    53.457
>
   108.745    53.263
   109.763    53.457
>
   108.745    53.263
   109.763    53.457
>
   109.999    53.658
   109.508    53.472
>
   109.999    53.658
   109.508    53.472
>
   109.999    53.658
   109.508    53.472
>
   109.999    53.658
   109.508    53.472
>
   108.745    53.263
   109.508    53.472
>
   108.745    53.263
   109.508    53.472
>
   108.745    53.263
   109.508    53.472
>
   109.999    53.658
   110.003    53.550
>
   109.999    53.658
   110.003    53.550
>
   109.999    53.658
   110.003    53.550
>
   109.999    53.658
   110.003    53.550
>
   108.745    53.263
   110.003    53.550
>
   108.745    53.263
   110.003    53.550
>
   108.080    52.760
   108.045    53.087
>
   108.080    52.760
   108.045    53.087
>
   108.745    53.263
   108.045    53.087
>
   108.745    53.263
   108.045    53.087
>
   107.595    53.643
   108.045    53.087
>
   107.152    52.554
   108.045    53.087
>
   107.152    52.554
   108.045    53.087
>
   107.630    52.230
   108.045    53.087
>
   107.630    52.230
   108.045    53.087
>
   107.595    53.643
   107.706    53.428
>
   107.595    53.643
   107.706    53.428
>
   108.745    53.263
   107.706    53.428
>
   108.745    53.263
   107.706    53.428
>
   108.745    53.263
   108.480    53.530
>
   108.745    53.263
   108.480    53.530
>
   107.595    53.643
   108.480    53.530
>
   107.595    53.643
   108.480    53.530
>
   107.595    53.643
   108.480    53.530
>
   109.999    53.658
   108.801    53.427
>
   109.999    53.658
   108.801    53.427
>
   109.999    53.658
   108.801    53.427
>
   109.999    53.658
   108.801    53.427
>
   107.595    53.643
   108.801    53.427
>
   107.595    53.643
   108.801    53.427
>
   107.595    53.643
   108.801    53.427
>
   108.080    52.760
   108.801    53.427
>
   108.080    52.760
   108.801    53.427
>
   108.745    53.263
   108.780    53.432
>
   108.745    53.263
   108.780    53.432
>
   107.595    53.643
   108.780    53.432
>
   107.595    53.643
   108.780    53.432
>
   107.595    53.643
   108.780    53.432
>
   109.999    53.658
   108.780    53.432
>
   109.999    53.658
   108.780    53.432
>
   109.999    53.658
   108.780    53.432
>
   109.999    53.658
   108.780    53.432
>
   108.080    52.760
   108.780    53.432
>
   108.080    52.760
   108.780    53.432
>
   109.999    53.658
   109.896    53.696
>
   109.999    53.658
   109.896    53.696
>
   108.745    53.263
   109.896    53.696
>
   108.745    53.263
   109.896    53.696
>
   108.745    53.263
   108.451    53.551
>
   108.745    53.263
   108.451    53.551
>
   108.080    52.760
   108.451    53.551
>
   108.080    52.760
   108.451    53.551
>
   108.745    53.263
   108.465    53.386
>
   108.745    53.263
   108.465    53.386
>
   107.595    53.643
   108.465    53.386
>
   107.595    53.643
   108.465    53.386
>
   107.595    53.643
   108.465    53.386
>
   108.080    52.760
   108.465    53.386
>
   108.080    52.760
   108.465    53.386
>
   108.745    53.263
   108.494    53.283
>
   108.745    53.263
   108.494    53.283
>
   107.595    53.643
   108.494    53.283
>
   107.595    53.643
   108.494    53.283
>
   108.745    53.263
   108.553    53.324
>
   108.745    53.263
   108.553    53.324
>
   107.595    53.643
   108.553    53.324
>
   107.595    53.643
   108.553    53.324
>
   107.595    53.643
   108.553    53.324
>
   108.080    52.760
   108.056    53.048
>
   108.080    52.760
   108.056    53.048
>
   108.745    53.263
   108.056    53.048
>
   108.745    53.263
   108.056    53.048
>
   107.595    53.643
   108.056    53.048
>
   107.595    53.643
   108.056    53.048
>
   107.595    53.643
   108.056    53.048
>
   107.152    52.554
   108.056    53.048
>
   107.152    52.554
   108.056    53.048
>
   108.745    53.263
   108.492    53.289
>
   108.745    53.263
   108.492    53.289
>
   108.080    52.760
   108.492    53.289
>
   108.080    52.760
   108.492    53.289
>
   107.595    53.643
   108.492    53.289
>
   107.595    53.643
   108.492    53.289
>
   107.595    53.643
   108.492    53.289
>
   108.745    53.263
   108.750    53.087
>
   108.745    53.263
   108.750    53.087
>
   107.595    53.643
   108.750    53.087
>
   107.595    53.643
   108.750    53.087
>
   108.080    52.760
   108.049    53.052
>
   108.080    52.760
   108.049    53.052
>
   108.745    53.263
   108.049    53.052
>
   108.745    53.263
   108.049    53.052
>
   107.595    53.643
   108.049    53.052
>
   107.595    53.643
   108.049    53.052
>
   107.595    53.643
   108.049    53.052
>
   107.595    53.643
   108.049    53.052
>
   107.152    52.554
   108.049    53.052
>
   107.152    52.554
   108.049    53.052
>
   107.630    52.230
   108.049    53.052
>
   107.630    52.230
   108.049    53.052
>
   107.595    53.643
   108.055    53.479
>
   107.595    53.643
   108.055    53.479
>
   108.745    53.263
   108.055    53.479
>
   108.745    53.263
   108.055    53.479
>
   108.745    53.263
   108.480    53.292
>
   108.745    53.263
   108.480    53.292
>
   107.595    53.643
   108.480    53.292
>
   107.595    53.643
   108.480    53.292
>
   107.595    53.643
   108.480    53.292
>
   108.080    52.760
   108.480    53.292
>
   108.080    52.760
   108.480    53.292
>
   108.745    53.263
   108.483    53.279
>
   108.745    53.263
   108.483    53.279
>
   108.080    52.760
   108.483    53.279
>
   108.080    52.760
   108.483    53.279
>
   107.595    53.643
   108.483    53.279
>
   107.595    53.643
   108.483    53.279
>
   107.595    53.643
   108.483    53.279
>
   108.745    53.263
   108.468    53.291
>
   108.745    53.263
   108.468    53.291
>
   107.595    53.643
   108.468    53.291
>
   107.595    53.643
   108.468    53.291
>
   107.595    53.643
   108.468    53.291
>
   108.745    53.263
   108.474    53.284
>
   108.745    53.263
   108.474    53.284
>
   108.080    52.760
   108.474    53.284
>
   108.080    52.760
   108.474    53.284
>
   107.595    53.643
   108.474    53.284
>
   107.595    53.643
   108.474    53.284
>
   107.595    53.643
   108.474    53.284
>
   108.745    53.263
   108.501    53.289
>
   108.745    53.263
   108.501    53.289
>
   108.080    52.760
   108.501    53.289
>
   108.080    52.760
   108.501    53.289
>
   107.595    53.643
   108.501    53.289
>
   107.595    53.643
   108.501    53.289
>
   108.745    53.263
   108.510    53.292
>
   108.745    53.263
   108.510    53.292
>
   108.080    52.760
   108.510    53.292
>
   108.080    52.760
   108.510    53.292
>
   107.595    53.643
   108.510    53.292
>
   107.595    53.643
   108.510    53.292
>
   108.745    53.263
   108.471    53.280
>
   108.745    53.263
   108.471    53.280
>
   108.080    52.760
   108.471    53.280
>
   108.080    52.760
   108.471    53.280
>
   107.595    53.643
   108.471    53.280
>
   107.595    53.643
   108.471    53.280
>
   107.595    53.643
   108.471    53.280
>
   107.595    53.643
   108.471    53.280
>
   107.595    53.643
   108.471    53.280
>
   108.745    53.263
   108.487    53.281
>
   108.745    53.263
   108.487    53.281
>
   108.080    52.760
   108.487    53.281
>
   108.080    52.760
   108.487    53.281
>
   107.595    53.643
   108.487    53.281
>
   107.595    53.643
   108.487    53.281
>
   107.595    53.643
   108.487    53.281
>
   108.745    53.263
   108.461    53.273
>
   108.745    53.263
   108.461    53.273
>
   108.080    52.760
   108.461    53.273
>
   107.595    53.643
   108.461    53.273
>
   107.595    53.643
   108.461    53.273
>
   108.745    53.263
   108.475    53.285
>
   108.745    53.263
   108.475    53.285
>
   107.595    53.643
   108.475    53.285
>
   107.595    53.643
   108.475    53.285
>
   108.745    53.263
   108.506    53.315
>
   108.745    53.263
   108.506    53.315
>
   108.080    52.760
   108.506    53.315
>
   108.080    52.760
   108.506    53.315
>
   107.595    53.643
   108.506    53.315
>
   107.595    53.643
   108.506    53.315
>
   108.745    53.263
   108.492    53.299
>
   108.745    53.263
   108.492    53.299
>
   108.080    52.760
   108.492    53.299
>
   108.080    52.760
   108.492    53.299
>
   107.595    53.643
   108.492    53.299
>
   107.595    53.643
   108.492    53.299
>
   109.999    53.658
   109.732    53.476
>
   109.999    53.658
   109.732    53.476
>
   109.999    53.658
   109.732    53.476
>
   109.999    53.658
   109.732    53.476
>
   108.745    53.263
   109.732    53.476
>
   108.745    53.263
   109.732    53.476
>
   108.745    53.263
   108.911    53.191
>
   108.745    53.263
   108.911    53.191
>
   109.999    53.658
   108.911    53.191
>
   109.999    53.658
   108.911    53.191
>
   109.999    53.658
   108.911    53.191
>
   109.999    53.658
   108.911    53.191
>
   108.745    53.263
   108.469    53.288
>
   108.745    53.263
   108.469    53.288
>
   108.745    53.263
   108.469    53.288
>
   107.595    53.643
   108.469    53.288
>
   107.595    53.643
   108.469    53.288
>
   107.595    53.643
   108.469    53.288
>
   108.745    53.263
   108.370    53.510
>
   108.745    53.263
   108.370    53.510
>
   107.595    53.643
   108.370    53.510
>
   107.595    53.643
   108.370    53.510
>
   107.595    53.643
   107.319    53.341
>
   107.595    53.643
   107.319    53.341
>
   108.745    53.263
   107.319    53.341
>
   108.745    53.263
   107.319    53.341
>
   106.348    52.760
   107.319    53.341
>
   106.348    52.760
   107.319    53.341
>
   106.348    52.760
   107.319    53.341
>
   107.595    53.643
   107.678    53.316
>
   107.595    53.643
   107.678    53.316
>
   108.745    53.263
   107.678    53.316
>
   108.745    53.263
   107.678    53.316
>
   108.745    53.263
   108.496    53.289
>
   108.745    53.263
   108.496    53.289
>
   107.595    53.643
   108.496    53.289
>
   107.595    53.643
   108.496    53.289
>
   107.595    53.643
   108.496    53.289
>
   107.595    53.643
   108.496    53.289
>
   108.745    53.263
   108.495    53.280
>
   108.745    53.263
   108.495    53.280
>
   107.595    53.643
   108.495    53.280
>
   107.595    53.643
   108.495    53.280
>
   108.745    53.263
   108.483    53.279
>
   108.745    53.263
   108.483    53.279
>
   107.595    53.643
   108.483    53.279
>
   107.595    53.643
   108.483    53.279
>
   108.745    53.263
   108.606    53.559
>
   108.745    53.263
   108.606    53.559
>
   107.595    53.643
   108.606    53.559
>
   107.595    53.643
   108.606    53.559
>
   109.999    53.658
   108.606    53.559
>
   109.999    53.658
   108.606    53.559
>
   108.745    53.263
   108.475    53.290
>
   108.745    53.263
   108.475    53.290
>
   107.595    53.643
   108.475    53.290
>
   107.595    53.643
   108.475    53.290
>
   107.595    53.643
   108.475    53.290
>
   108.745    53.263
   108.475    53.285
>
   108.745    53.263
   108.475    53.285
>
   107.595    53.643
   108.475    53.285
>
   107.595    53.643
   108.475    53.285
>
   109.999    53.658
   109.797    53.726
>
   109.999    53.658
   109.797    53.726
>
   108.745    53.263
   109.797    53.726
>
   108.745    53.263
   109.797    53.726
>
   108.745    53.263
   108.467    53.287
>
   108.745    53.263
   108.467    53.287
>
   107.595    53.643
   108.467    53.287
>
   107.595    53.643
   108.467    53.287
>
   107.595    53.643
   108.467    53.287
>
   108.745    53.263
   108.471    53.293
>
   108.745    53.263
   108.471    53.293
>
   107.595    53.643
   108.471    53.293
>
   107.595    53.643
   108.471    53.293
>
   108.745    53.263
   108.457    53.364
>
   108.745    53.263
   108.457    53.364
>
   107.595    53.643
   108.457    53.364
>
   107.595    53.643
   108.457    53.364
>
   107.595    53.643
   108.457    53.364
>
   108.745    53.263
   108.484    53.366
>
   108.745    53.263
   108.484    53.366
>
   107.595    53.643
   108.484    53.366
>
   107.595    53.643
   108.484    53.366
>
   108.745    53.263
   108.439    53.367
>
   108.745    53.263
   108.439    53.367
>
   107.595    53.643
   108.439    53.367
>
   107.595    53.643
   108.439    53.367
>
   107.595    53.643
   108.439    53.367
>
   108.745    53.263
   108.464    53.354
>
   108.745    53.263
   108.464    53.354
>
   107.595    53.643
   108.464    53.354
>
   107.595    53.643
   108.464    53.354
>
   107.595    53.643
   108.464    53.354
>
   107.595    53.643
   108.464    53.354
>
   108.745    53.263
   108.465    53.370
>
   108.745    53.263
   108.465    53.370
>
   107.595    53.643
   108.465    53.370
>
   107.595    53.643
   108.465    53.370
>
   107.595    53.643
   108.465    53.370
>
   107.595    53.643
   108.465    53.370
>
   108.745    53.263
   108.462    53.360
>
   108.745    53.263
   108.462    53.360
>
   107.595    53.643
   108.462    53.360
>
   107.595    53.643
   108.462    53.360
>
   107.595    53.643
   108.462    53.360
>
   108.745    53.263
   108.468    53.361
>
   108.745    53.263
   108.468    53.361
>
   107.595    53.643
   108.468    53.361
>
   107.595    53.643
   108.468    53.361
>
   108.745    53.263
   108.503    53.286
>
   108.745    53.263
   108.503    53.286
>
   107.595    53.643
   108.503    53.286
>
   107.595    53.643
   108.503    53.286
>
   108.745    53.263
   108.290    53.312
>
   108.745    53.263
   108.290    53.312
>
   107.595    53.643
   108.290    53.312
>
   107.595    53.643
   108.290    53.312
>
   107.595    53.643
   108.290    53.312
>
   107.595    53.643
   108.484    53.304
>
   107.595    53.643
   108.484    53.304
>
   107.595    53.643
   108.484    53.304
>
   107.595    53.643
   108.484    53.304
>
   107.595    53.643
   108.472    53.301
>
   107.595    53.643
   108.472    53.301
>
   107.595    53.643
   108.472    53.301
>
   108.745    53.263
   108.244    53.325
>
   108.745    53.263
   108.244    53.325
>
   107.595    53.643
   108.244    53.325
>
   107.595    53.643
   108.244    53.325
>
   108.080    52.760
   108.244    53.325
>
   108.080    52.760
   108.244    53.325
>
   107.595    53.643
   107.372    53.402
>
   107.595    53.643
   107.372    53.402
>
   108.080    52.760
   107.372    53.402
>
   108.080    52.760
   107.372    53.402
>
   108.745    53.263
   107.372    53.402
>
   108.745    53.263
   107.372    53.402
>
   107.152    52.554
   107.372    53.402
>
   107.152    52.554
   107.372    53.402
>
   106.348    52.760
   107.372    53.402
>
   106.348    52.760
   107.372    53.402
>
   108.745    53.263
   108.453    53.282
>
   108.745    53.263
   108.453    53.282
>
   108.080    52.760
   108.453    53.282
>
   108.080    52.760
   108.453    53.282
>
   107.595    53.643
   108.453    53.282
>
   107.595    53.643
   108.453    53.282
>
   107.595    53.643
   108.453    53.282
>
   108.745    53.263
   108.400    53.461
>
   108.745    53.263
   108.400    53.461
>
   107.595    53.643
   108.400    53.461
>
   107.595    53.643
   108.400    53.461
>
   108.080    52.760
   108.400    53.461
>
   108.080    52.760
   108.400    53.461
>
   108.745    53.263
   108.468    53.307
>
   108.745    53.263
   108.468    53.307
>
   108.080    52.760
   108.468    53.307
>
   108.080    52.760
   108.468    53.307
>
   107.595    53.643
   108.468    53.307
>
   107.595    53.643
   108.468    53.307
>
   108.080    52.760
   107.842    53.071
>
   108.080    52.760
   107.842    53.071
>
   107.595    53.643
   107.842    53.071
>
   108.745    53.263
   107.842    53.071
>
   108.745    53.263
   107.842    53.071
>
   108.745    53.263
   107.842    53.071
>
   107.152    52.554
   107.842    53.071
>
   107.152    52.554
   107.842    53.071
>
   108.745    53.263
   108.999    53.183
>
   108.745    53.263
   108.999    53.183
>
   108.080    52.760
   108.999    53.183
>
   108.080    52.760
   108.999    53.183
>
   109.999    53.658
   108.999    53.183
>
   109.999    53.658
   108.999    53.183
>
   109.999    53.658
   108.999    53.183
>
   108.080    52.760
   107.816    53.038
>
   108.080    52.760
   107.816    53.038
>
   108.745    53.263
   107.816    53.038
>
   108.745    53.263
   107.816    53.038
>
   107.595    53.643
   107.816    53.038
>
   107.595    53.643
   107.816    53.038
>
   107.595    53.643
   107.816    53.038
>
   107.152    52.554
   107.816    53.038
>
   107.152    52.554
   107.816    53.038
>
   107.595    53.643
   108.023    53.303
>
   107.595    53.643
   108.023    53.303
>
   107.595    53.643
   108.023    53.303
>
   108.745    53.263
   108.023    53.303
>
   108.745    53.263
   108.023    53.303
>
   108.080    52.760
   108.023    53.303
>
   108.080    52.760
   108.023    53.303
>
   108.745    53.263
   108.506    53.280
>
   108.745    53.263
   108.506    53.280
>
   108.080    52.760
   108.506    53.280
>
   108.080    52.760
   108.506    53.280
>
   107.595    53.643
   108.506    53.280
>
   107.595    53.643
   108.506    53.280
>
   107.595    53.643
   108.506    53.280
>
   107.595    53.643
   108.506    53.280
>
   108.745    53.263
   108.479    53.277
>
   108.745    53.263
   108.479    53.277
>
   108.080    52.760
   108.479    53.277
>
   108.080    52.760
   108.479    53.277
>
   107.595    53.643
   108.479    53.277
>
   107.595    53.643
   108.479    53.277
>
   107.595    53.643
   108.479    53.277
>
   108.745    53.263
   108.486    53.279
>
   108.745    53.263
   108.486    53.279
>
   108.080    52.760
   108.486    53.279
>
   108.080    52.760
   108.486    53.279
>
   107.595    53.643
   108.486    53.279
>
   107.595    53.643
   108.486    53.279
>
   107.595    53.643
   108.486    53.279
>
   108.745    53.263
   108.485    53.269
>
   108.745    53.263
   108.485    53.269
>
   108.080    52.760
   108.485    53.269
>
   108.080    52.760
   108.485    53.269
>
   107.595    53.643
   108.485    53.269
>
   107.595    53.643
   108.485    53.269
>
   107.595    53.643
   108.485    53.269
>
   108.745    53.263
   108.984    53.513
>
   108.745    53.263
   108.984    53.513
>
   109.999    53.658
   108.984    53.513
>
   109.999    53.658
   108.984    53.513
>
   109.999    53.658
   108.984    53.513
>
   109.999    53.658
   108.984    53.513
>
   107.595    53.643
   108.984    53.513
>
   107.595    53.643
   108.984    53.513
>
   107.595    53.643
   108.984    53.513
>
   108.745    53.263
   108.678    53.324
>
   108.745    53.263
   108.678    53.324
>
   108.080    52.760
   108.678    53.324
>
   108.080    52.760
   108.678    53.324
>
   107.595    53.643
   108.678    53.324
>
   107.595    53.643
   108.678    53.324
>
   109.999    53.658
   108.678    53.324
>
   109.999    53.658
   108.678    53.324
>
   109.999    53.658
   108.678    53.324
>
   108.080    52.760
   108.097    53.080
>
   108.080    52.760
   108.097    53.080
>
   108.745    53.263
   108.097    53.080
>
   108.745    53.263
   108.097    53.080
>
   108.745    53.263
   108.097    53.080
>
   107.595    53.643
   108.097    53.080
>
   107.595    53.643
   108.097    53.080
>
   107.152    52.554
   108.097    53.080
>
   107.152    52.554
   108.097    53.080
>
   108.080    52.760
   108.094    53.082
>
   108.080    52.760
   108.094    53.082
>
   108.080    52.760
   108.094    53.082
>
   108.745    53.263
   108.094    53.082
>
   108.745    53.263
   108.094    53.082
>
   108.745    53.263
   108.094    53.082
>
   107.595    53.643
   108.094    53.082
>
   107.595    53.643
   108.094    53.082
>
   107.152    52.554
   108.094    53.082
>
   107.152    52.554
   108.094    53.082
>
   107.630    52.230
   108.094    53.082
>
   107.630    52.230
   108.094    53.082
>
   107.595    53.643
   107.932    53.382
>
   107.595    53.643
   107.932    53.382
>
   107.595    53.643
   107.932    53.382
>
   108.745    53.263
   107.932    53.382
>
   108.745    53.263
   107.932    53.382
>
   108.080    52.760
   107.932    53.382
>
   108.080    52.760
   107.932    53.382
>
   108.745    53.263
   108.859    53.422
>
   108.745    53.263
   108.859    53.422
>
   109.999    53.658
   108.859    53.422
>
   109.999    53.658
   108.859    53.422
>
   108.080    52.760
   108.859    53.422
>
   108.080    52.760
   108.859    53.422
>
   107.595    53.643
   108.859    53.422
>
   107.595    53.643
   108.859    53.422
>
   107.595    53.643
   108.859    53.422
>
   108.080    52.760
   107.777    53.011
>
   108.080    52.760
   107.777    53.011
>
   107.595    53.643
   107.777    53.011
>
   107.595    53.643
   107.777    53.011
>
   107.630    52.230
   107.777    53.011
>
   107.630    52.230
   107.777    53.011
>
   108.745    53.263
   108.435    53.303
>
   108.745    53.263
   108.435    53.303
>
   108.080    52.760
   108.435    53.303
>
   108.080    52.760
   108.435    53.303
>
   107.595    53.643
   108.435    53.303
>
   107.595    53.643
   108.435    53.303
>
   107.595    53.643
   108.435    53.303
>
   108.745    53.263
   108.429    53.307
>
   108.745    53.263
   108.429    53.307
>
   108.080    52.760
   108.429    53.307
>
   108.080    52.760
   108.429    53.307
>
   107.595    53.643
   108.429    53.307
>
   107.595    53.643
   108.429    53.307
>
   108.745    53.263
   108.526    53.325
>
   108.745    53.263
   108.526    53.325
>
   108.080    52.760
   108.526    53.325
>
   108.080    52.760
   108.526    53.325
>
   108.080    52.760
   108.526    53.325
>
   107.595    53.643
   108.526    53.325
>
   107.595    53.643
   108.526    53.325
>
   108.745    53.263
   108.475    53.279
>
   108.745    53.263
   108.475    53.279
>
   108.080    52.760
   108.475    53.279
>
   108.080    52.760
   108.475    53.279
>
   107.595    53.643
   108.475    53.279
>
   107.595    53.643
   108.475    53.279
>
   108.745    53.263
   108.469    53.278
>
   108.745    53.263
   108.469    53.278
>
   108.080    52.760
   108.469    53.278
>
   108.080    52.760
   108.469    53.278
>
   107.595    53.643
   108.469    53.278
>
   107.595    53.643
   108.469    53.278
>
   107.595    53.643
   107.582    53.301
>
   107.595    53.643
   107.582    53.301
>
   108.080    52.760
   107.582    53.301
>
   108.080    52.760
   107.582    53.301
>
   108.745    53.263
   107.582    53.301
>
   108.745    53.263
   107.582    53.301
>
   108.745    53.263
   108.479    53.276
>
   108.745    53.263
   108.479    53.276
>
   108.080    52.760
   108.479    53.276
>
   108.080    52.760
   108.479    53.276
>
   107.595    53.643
   108.479    53.276
>
   107.595    53.643
   108.479    53.276
>
   108.745    53.263
   108.468    53.283
>
   108.745    53.263
   108.468    53.283
>
   108.080    52.760
   108.468    53.283
>
   108.080    52.760
   108.468    53.283
>
   107.595    53.643
   108.468    53.283
>
   107.595    53.643
   108.468    53.283
>
   108.745    53.263
   108.448    53.470
>
   108.745    53.263
   108.448    53.470
>
   107.595    53.643
   108.448    53.470
>
   107.595    53.643
   108.448    53.470
>
   108.080    52.760
   108.448    53.470
>
   108.080    52.760
   108.448    53.470
>
   108.745    53.263
   108.612    53.100
>
   108.745    53.263
   108.612    53.100
>
   108.080    52.760
   108.612    53.100
>
   108.080    52.760
   108.612    53.100
>
   107.595    53.643
   108.612    53.100
>
   107.595    53.643
   108.612    53.100
>
   108.745    53.263
   108.554    53.272
>
   108.745    53.263
   108.554    53.272
>
   108.080    52.760
   108.554    53.272
>
   108.080    52.760
   108.554    53.272
>
   107.595    53.643
   108.554    53.272
>
   107.595    53.643
   108.554    53.272
>
   108.745    53.263
   108.707    53.329
>
   108.745    53.263
   108.707    53.329
>
   108.080    52.760
   108.707    53.329
>
   108.080    52.760
   108.707    53.329
>
   107.595    53.643
   108.707    53.329
>
   107.595    53.643
   108.707    53.329
>
   109.999    53.658
   108.707    53.329
>
   109.999    53.658
   108.707    53.329
>
   109.999    53.658
   108.707    53.329
>
   108.745    53.263
   108.087    53.052
>
   108.745    53.263
   108.087    53.052
>
   107.595    53.643
   108.087    53.052
>
   107.595    53.643
   108.087    53.052
>
   108.745    53.263
   108.265    53.159
>
   108.745    53.263
   108.265    53.159
>
   108.080    52.760
   108.265    53.159
>
   108.080    52.760
   108.265    53.159
>
   108.745    53.263
   108.278    53.131
>
   108.745    53.263
   108.278    53.131
>
   108.080    52.760
   108.278    53.131
>
   108.080    52.760
   108.278    53.131
>
   107.595    53.643
   108.278    53.131
>
   107.595    53.643
   108.278    53.131
>
   107.152    52.554
   108.278    53.131
>
   108.745    53.263
   108.286    53.136
>
   108.745    53.263
   108.286    53.136
>
   108.080    52.760
   108.286    53.136
>
   108.080    52.760
   108.286    53.136
>
   107.595    53.643
   108.286    53.136
>
   107.595    53.643
   108.286    53.136
>
   108.745    53.263
   108.457    53.299
>
   108.745    53.263
   108.457    53.299
>
   108.080    52.760
   108.457    53.299
>
   108.080    52.760
   108.457    53.299
>
   108.745    53.263
   108.472    53.278
>
   108.745    53.263
   108.472    53.278
>
   108.080    52.760
   108.472    53.278
>
   108.080    52.760
   108.472    53.278
>
   107.595    53.643
   108.472    53.278
>
   107.595    53.643
   108.472    53.278
>
   108.745    53.263
   109.049    53.499
>
   109.999    53.658
   109.049    53.499
>
   109.999    53.658
   109.049    53.499
>
   107.595    53.643
   109.049    53.499
>
   107.595    53.643
   109.049    53.499
>
   108.745    53.263
   109.057    53.490
>
   108.745    53.263
   109.057    53.490
>
   109.999    53.658
   109.057    53.490
>
   109.999    53.658
   109.057    53.490
>
   109.999    53.658
   109.057    53.490
>
   109.999    53.658
   109.057    53.490
>
   107.595    53.643
   109.057    53.490
>
   107.595    53.643
   109.057    53.490
>
   107.595    53.643
   107.929    53.262
>
   107.595    53.643
   107.929    53.262
>
   108.745    53.263
   107.929    53.262
>
   108.745    53.263
   107.929    53.262
>
   108.080    52.760
   107.929    53.262
>
   108.080    52.760
   107.929    53.262
>
   108.745    53.263
   109.110    53.107
>
   108.745    53.263
   109.110    53.107
>
   109.999    53.658
   109.110    53.107
>
   109.999    53.658
   109.110    53.107
>
   108.745    53.263
   108.503    53.271
>
   108.745    53.263
   108.503    53.271
>
   108.080    52.760
   108.503    53.271
>
   108.080    52.760
   108.503    53.271
>
   107.595    53.643
   108.503    53.271
>
   108.745    53.263
   109.041    53.481
>
   108.745    53.263
   109.041    53.481
>
   109.999    53.658
   109.041    53.481
>
   109.999    53.658
   109.041    53.481
>
   108.745    53.263
   108.482    53.275
>
   108.745    53.263
   108.482    53.275
>
   108.080    52.760
   108.482    53.275
>
   108.080    52.760
   108.482    53.275
>
   107.595    53.643
   108.482    53.275
>
   108.745    53.263
   108.492    53.272
>
   108.745    53.263
   108.492    53.272
>
   108.080    52.760
   108.492    53.272
>
   108.080    52.760
   108.492    53.272
>
   107.595    53.643
   108.492    53.272
>
   107.741    53.323
   107.287    53.277
>
   107.741    53.323
   107.287    53.277
>
   107.595    53.643
   107.287    53.277
>
   107.595    53.643
   107.287    53.277
>
   108.080    52.760
   107.287    53.277
>
   108.080    52.760
   107.287    53.277
>
   107.152    52.554
   107.287    53.277
>
   107.152    52.554
   107.287    53.277
>
   106.348    52.760
   107.287    53.277
>
   106.348    52.760
   107.287    53.277
>
   108.745    53.263
   107.287    53.277
>
   108.745    53.263
   107.287    53.277
>
   108.745    53.263
   108.372    53.477
>
   108.745    53.263
   108.372    53.477
>
   107.741    53.323
   108.372    53.477
>
   107.741    53.323
   108.372    53.477
>
   107.595    53.643
   108.372    53.477
>
   107.595    53.643
   108.372    53.477
>
   108.080    52.760
   108.372    53.477
>
   108.080    52.760
   108.372    53.477
>
   108.745    53.263
   108.791    53.622
>
   108.745    53.263
   108.791    53.622
>
   109.999    53.658
   108.791    53.622
>
   109.999    53.658
   108.791    53.622
>
   108.745    53.263
   108.173    53.258
>
   108.745    53.263
   108.173    53.258
>
   108.080    52.760
   108.173    53.258
>
   108.080    52.760
   108.173    53.258
>
   108.285    52.986
   107.970    53.094
>
   108.285    52.986
   107.970    53.094
>
   108.080    52.760
   107.970    53.094
>
   108.080    52.760
   107.970    53.094
>
   108.745    53.263
   107.970    53.094
>
   108.745    53.263
   107.970    53.094
>
   107.595    53.643
   107.970    53.094
>
   107.595    53.643
   107.970    53.094
>
   107.152    52.554
   107.970    53.094
>
   107.152    52.554
   107.970    53.094
>
   108.745    53.263
   108.391    53.258
>
   108.745    53.263
   108.391    53.258
>
   108.080    52.760
   108.391    53.258
>
   108.080    52.760
   108.391    53.258
>
   108.745    53.263
   108.610    53.352
>
   108.745    53.263
   108.610    53.352
>
   108.080    52.760
   108.610    53.352
>
   108.080    52.760
   108.610    53.352
>
   109.999    53.658
   108.610    53.352
>
   109.999    53.658
   108.610    53.352
>
   108.080    52.760
   108.082    53.058
>
   108.080    52.760
   108.082    53.058
>
   108.745    53.263
   108.082    53.058
>
   108.745    53.263
   108.082    53.058
>
   107.152    52.554
   108.082    53.058
>
   107.152    52.554
   108.082    53.058
>
   108.080    52.760
   108.085    53.068
>
   108.080    52.760
   108.085    53.068
>
   108.745    53.263
   108.085    53.068
>
   108.745    53.263
   108.085    53.068
>
   107.152    52.554
   108.085    53.068
>
   107.152    52.554
   108.085    53.068
>
   108.745    53.263
   108.950    53.533
>
   108.745    53.263
   108.950    53.533
>
   109.999    53.658
   108.950    53.533
>
   109.999    53.658
   108.950    53.533
>
   108.285    52.986
   108.950    53.533
>
   108.285    52.986
   108.950    53.533
>
   107.595    53.643
   108.950    53.533
>
   107.595    53.643
   108.950    53.533
>
   108.745    53.263
   108.660    53.377
>
   108.745    53.263
   108.660    53.377
>
   108.285    52.986
   108.660    53.377
>
   108.285    52.986
   108.660    53.377
>
   107.741    53.323
   108.660    53.377
>
   107.741    53.323
   108.660    53.377
>
   107.595    53.643
   108.660    53.377
>
   107.595    53.643
   108.660    53.377
>
   108.080    52.760
   108.660    53.377
>
   108.080    52.760
   108.660    53.377
>
   109.999    53.658
   108.660    53.377
>
   109.999    53.658
   108.660    53.377
>
   108.745    53.263
   108.470    53.296
>
   108.745    53.263
   108.470    53.296
>
   108.285    52.986
   108.470    53.296
>
   108.285    52.986
   108.470    53.296
>
   107.741    53.323
   108.470    53.296
>
   107.741    53.323
   108.470    53.296
>
   108.080    52.760
   108.470    53.296
>
   108.080    52.760
   108.470    53.296
>
   107.595    53.643
   108.470    53.296
>
   107.595    53.643
   108.470    53.296
>
   107.741    53.323
   108.065    53.276
>
   107.741    53.323
   108.065    53.276
>
   108.285    52.986
   108.065    53.276
>
   108.285    52.986
   108.065    53.276
>
   108.745    53.263
   108.065    53.276
>
   108.745    53.263
   108.065    53.276
>
   107.595    53.643
   108.065    53.276
>
   107.595    53.643
   108.065    53.276
>
   108.080    52.760
   108.065    53.276
>
   108.080    52.760
   108.065    53.276
>
   107.595    53.643
   107.804    53.738
>
   107.595    53.643
   107.804    53.738
>
   108.745    53.263
   107.804    53.738
>
   108.745    53.263
   107.804    53.738
>
   108.285    52.986
   107.804    53.738
>
   108.285    52.986
   107.804    53.738
>
   108.745    53.263
   108.637    53.572
>
   108.745    53.263
   108.637    53.572
>
   108.285    52.986
   108.637    53.572
>
   108.285    52.986
   108.637    53.572
>
   109.999    53.658
   108.637    53.572
>
   109.999    53.658
   108.637    53.572
>
   109.999    53.658
   108.637    53.572
>
   107.595    53.643
   108.637    53.572
>
   107.595    53.643
   108.637    53.572
>
   108.080    52.760
   108.637    53.572
>
   108.080    52.760
   108.637    53.572
>
   108.745    53.263
   108.656    53.584
>
   108.745    53.263
   108.656    53.584
>
   107.595    53.643
   108.656    53.584
>
   107.595    53.643
   108.656    53.584
>
   108.285    52.986
   108.656    53.584
>
   108.285    52.986
   108.656    53.584
>
   109.999    53.658
   108.656    53.584
>
   109.999    53.658
   108.656    53.584
>
   108.080    52.760
   108.656    53.584
>
   108.080    52.760
   108.656    53.584
>
   108.745    53.263
   108.620    53.575
>
   108.745    53.263
   108.620    53.575
>
   107.595    53.643
   108.620    53.575
>
   107.595    53.643
   108.620    53.575
>
   108.285    52.986
   108.620    53.575
>
   108.285    52.986
   108.620    53.575
>
   109.999    53.658
   108.620    53.575
>
   109.999    53.658
   108.620    53.575
>
   108.080    52.760
   108.620    53.575
>
   108.080    52.760
   108.620    53.575
>
   108.745    53.263
   108.443    53.296
>
   108.745    53.263
   108.443    53.296
>
   108.285    52.986
   108.443    53.296
>
   108.285    52.986
   108.443    53.296
>
   108.080    52.760
   108.443    53.296
>
   108.080    52.760
   108.443    53.296
>
   108.745    53.263
   108.461    53.372
>
   108.745    53.263
   108.461    53.372
>
   108.285    52.986
   108.461    53.372
>
   108.285    52.986
   108.461    53.372
>
   107.595    53.643
   108.461    53.372
>
   107.595    53.643
   108.461    53.372
>
   108.080    52.760
   108.461    53.372
>
   108.080    52.760
   108.461    53.372
>
   109.999    53.658
   109.919    53.470
>
   109.999    53.658
   109.919    53.470
>
   108.745    53.263
   109.919    53.470
>
   108.745    53.263
   109.919    53.470
>
   109.999    53.658
   109.926    53.608
>
   109.999    53.658
   109.926    53.608
>
   108.745    53.263
   109.926    53.608
>
   108.745    53.263
   109.926    53.608
>
   107.741    53.323
   108.149    53.542
>
   107.741    53.323
   108.149    53.542
>
   107.595    53.643
   108.149    53.542
>
   107.595    53.643
   108.149    53.542
>
   107.595    53.643
   108.149    53.542
>
   108.745    53.263
   108.149    53.542
>
   108.745    53.263
   108.149    53.542
>
   108.285    52.986
   108.149    53.542
>
   108.080    52.760
   108.149    53.542
>
   108.080    52.760
   108.149    53.542
>
   108.285    52.986
   107.868    53.031
>
   108.285    52.986
   107.868    53.031
>
   107.741    53.323
   107.868    53.031
>
   107.741    53.323
   107.868    53.031
>
   108.080    52.760
   107.868    53.031
>
   108.080    52.760
   107.868    53.031
>
   107.595    53.643
   107.868    53.031
>
   107.595    53.643
   107.868    53.031
>
   107.152    52.554
   107.868    53.031
>
   107.152    52.554
   107.868    53.031
>
   107.741    53.323
   107.529    53.340
>
   107.741    53.323
   107.529    53.340
>
   107.595    53.643
   107.529    53.340
>
   107.595    53.643
   107.529    53.340
>
   108.745    53.263
   107.529    53.340
>
   108.745    53.263
   107.529    53.340
>
   107.152    52.554
   107.529    53.340
>
   107.152    52.554
   107.529    53.340
>
   107.741    53.323
   108.096    53.502
>
   107.741    53.323
   108.096    53.502
>
   108.745    53.263
   108.096    53.502
>
   108.745    53.263
   108.096    53.502
>
   107.595    53.643
   108.096    53.502
>
   107.595    53.643
   108.096    53.502
>
   107.741    53.323
   108.002    53.067
>
   107.741    53.323
   108.002    53.067
>
   108.745    53.263
   108.002    53.067
>
   108.745    53.263
   108.002    53.067
>
   107.595    53.643
   108.002    53.067
>
   107.595    53.643
   108.002    53.067
>
   107.741    53.323
   108.094    53.505
>
   107.741    53.323
   108.094    53.505
>
   107.595    53.643
   108.094    53.505
>
   107.595    53.643
   108.094    53.505
>
   107.595    53.643
   108.094    53.505
>
   108.745    53.263
   108.094    53.505
>
   108.745    53.263
   108.094    53.505
>
   107.595    53.643
   108.088    53.520
>
   107.595    53.643
   108.088    53.520
>
   107.741    53.323
   108.088    53.520
>
   107.741    53.323
   108.088    53.520
>
   108.745    53.263
   108.088    53.520
>
   108.745    53.263
   108.088    53.520
>
   108.285    52.986
   108.088    53.520
>
   108.285    52.986
   108.088    53.520
>
   108.080    52.760
   108.088    53.520
>
   108.080    52.760
   108.088    53.520
>
   108.745    53.263
   108.617    53.370
>
   108.745    53.263
   108.617    53.370
>
   108.285    52.986
   108.617    53.370
>
   108.285    52.986
   108.617    53.370
>
   107.741    53.323
   108.617    53.370
>
   107.741    53.323
   108.617    53.370
>
   108.080    52.760
   108.617    53.370
>
   108.080    52.760
   108.617    53.370
>
   107.595    53.643
   108.617    53.370
>
   107.595    53.643
   108.617    53.370
>
   107.595    53.643
   108.617    53.370
>
   109.999    53.658
   108.617    53.370
>
   109.999    53.658
   108.617    53.370
>
   109.999    53.658
   108.617    53.370
>
   107.595    53.643
   108.126    53.534
>
   107.595    53.643
   108.126    53.534
>
   108.745    53.263
   108.126    53.534
>
   108.745    53.263
   108.126    53.534
>
   108.285    52.986
   108.126    53.534
>
   108.285    52.986
   108.126    53.534
>
   108.080    52.760
   108.126    53.534
>
   108.080    52.760
   108.126    53.534
>
   108.285    52.986
   108.113    53.206
>
   107.741    53.323
   108.113    53.206
>
   107.741    53.323
   108.113    53.206
>
   108.745    53.263
   108.113    53.206
>
   108.745    53.263
   108.113    53.206
>
   108.080    52.760
   108.113    53.206
>
   108.080    52.760
   108.113    53.206
>
   107.595    53.643
   108.113    53.206
>
   107.595    53.643
   108.113    53.206
>
   107.152    52.554
   108.113    53.206
>
   107.152    52.554
   108.113    53.206
>
   107.741    53.323
   107.569    53.084
>
   107.741    53.323
   107.569    53.084
>
   108.285    52.986
   107.569    53.084
>
   108.285    52.986
   107.569    53.084
>
   108.080    52.760
   107.569    53.084
>
   108.080    52.760
   107.569    53.084
>
   107.595    53.643
   107.569    53.084
>
   107.595    53.643
   107.569    53.084
>
   107.152    52.554
   107.569    53.084
>
   107.152    52.554
   107.569    53.084
>
   108.745    53.263
   107.569    53.084
>
   108.745    53.263
   107.569    53.084
>
   107.741    53.323
   107.787    53.139
>
   107.741    53.323
   107.787    53.139
>
   108.285    52.986
   107.787    53.139
>
   108.285    52.986
   107.787    53.139
>
   108.080    52.760
   107.787    53.139
>
   108.080    52.760
   107.787    53.139
>
   107.595    53.643
   107.787    53.139
>
   107.595    53.643
   107.787    53.139
>
   108.745    53.263
   107.787    53.139
>
   108.745    53.263
   107.787    53.139
>
   107.152    52.554
   107.787    53.139
>
   107.152    52.554
   107.787    53.139
>
   108.745    53.263
   108.498    53.522
>
   108.745    53.263
   108.498    53.522
>
   107.741    53.323
   108.498    53.522
>
   107.741    53.323
   108.498    53.522
>
   107.595    53.643
   108.498    53.522
>
   107.595    53.643
   108.498    53.522
>
   108.285    52.986
   108.498    53.522
>
   108.285    52.986
   108.498    53.522
>
   108.745    53.263
   108.536    53.211
>
   108.745    53.263
   108.536    53.211
>
   107.741    53.323
   108.536    53.211
>
   107.741    53.323
   108.536    53.211
>
   108.080    52.760
   108.536    53.211
>
   108.080    52.760
   108.536    53.211
>
   107.595    53.643
   108.536    53.211
>
   107.595    53.643
   108.536    53.211
>
   108.745    53.263
   109.024    53.436
>
   108.745    53.263
   109.024    53.436
>
   109.999    53.658
   109.024    53.436
>
   109.999    53.658
   109.024    53.436
>
   108.285    52.986
   109.024    53.436
>
   108.285    52.986
   109.024    53.436
>
   107.741    53.323
   109.024    53.436
>
   107.741    53.323
   109.024    53.436
>
   107.595    53.643
   109.024    53.436
>
   107.595    53.643
   109.024    53.436
>
   108.080    52.760
   109.024    53.436
>
   108.080    52.760
   109.024    53.436
>
   109.999    53.658
   109.896    53.723
>
   109.999    53.658
   109.896    53.723
>
   108.745    53.263
   109.896    53.723
>
   108.745    53.263
   109.896    53.723
>
   108.285    52.986
   107.993    53.024
>
   108.285    52.986
   107.993    53.024
>
   108.080    52.760
   107.993    53.024
>
   108.080    52.760
   107.993    53.024
>
   108.745    53.263
   107.993    53.024
>
   108.745    53.263
   107.993    53.024
>
   107.595    53.643
   107.993    53.024
>
   107.595    53.643
   107.993    53.024
>
   107.152    52.554
   107.993    53.024
>
   107.152    52.554
   107.993    53.024
>
   107.741    53.323
   107.798    53.143
>
   107.741    53.323
   107.798    53.143
>
   108.285    52.986
   107.798    53.143
>
   108.285    52.986
   107.798    53.143
>
   108.080    52.760
   107.798    53.143
>
   108.080    52.760
   107.798    53.143
>
   107.595    53.643
   107.798    53.143
>
   107.595    53.643
   107.798    53.143
>
   108.745    53.263
   107.798    53.143
>
   108.745    53.263
   107.798    53.143
>
   107.152    52.554
   107.798    53.143
>
   107.152    52.554
   107.798    53.143
>
   108.745    53.263
   108.542    53.273
>
   108.745    53.263
   108.542    53.273
>
   108.285    52.986
   108.542    53.273
>
   108.285    52.986
   108.542    53.273
>
   107.595    53.643
   108.542    53.273
>
   107.595    53.643
   108.542    53.273
>
   107.595    53.643
   108.542    53.273
>
   107.595    53.643
   108.542    53.273
>
   107.595    53.643
   108.542    53.273
>
   107.595    53.643
   107.281    53.373
>
   107.595    53.643
   107.281    53.373
>
   107.595    53.643
   107.281    53.373
>
   108.285    52.986
   107.281    53.373
>
   108.285    52.986
   107.281    53.373
>
   107.152    52.554
   107.281    53.373
>
   107.152    52.554
   107.281    53.373
>
   108.745    53.263
   107.281    53.373
>
   108.745    53.263
   107.281    53.373
>
   106.348    52.760
   107.281    53.373
>
   106.348    52.760
   107.281    53.373
>
   106.348    52.760
   107.281    53.373
>
   108.745    53.263
   108.567    53.308
>
   108.745    53.263
   108.567    53.308
>
   107.741    53.323
   108.567    53.308
>
   107.741    53.323
   108.567    53.308
>
   108.080    52.760
   108.567    53.308
>
   108.080    52.760
   108.567    53.308
>
   107.595    53.643
   108.567    53.308
>
   107.595    53.643
   108.567    53.308
>
   108.080    52.760
   108.023    53.041
>
   108.080    52.760
   108.023    53.041
>
   107.741    53.323
   108.023    53.041
>
   107.741    53.323
   108.023    53.041
>
   108.745    53.263
   108.023    53.041
>
   108.745    53.263
   108.023    53.041
>
   107.595    53.643
   108.023    53.041
>
   107.595    53.643
   108.023    53.041
>
   107.152    52.554
   108.023    53.041
>
   107.152    52.554
   108.023    53.041
>
   108.745    53.263
   108.328    53.285
>
   108.745    53.263
   108.328    53.285
>
   107.741    53.323
   108.328    53.285
>
   107.741    53.323
   108.328    53.285
>
   108.080    52.760
   108.328    53.285
>
   108.080    52.760
   108.328    53.285
>
   107.595    53.643
   108.328    53.285
>
   107.595    53.643
   108.328    53.285
>
   109.999    53.658
   109.887    53.523
>
   108.745    53.263
   109.887    53.523
>
   108.745    53.263
   109.887    53.523
>
   108.080    52.760
   107.880    53.023
>
   108.080    52.760
   107.880    53.023
>
   107.741    53.323
   107.880    53.023
>
   107.741    53.323
   107.880    53.023
>
   108.745    53.263
   107.880    53.023
>
   108.745    53.263
   107.880    53.023
>
   107.152    52.554
   107.880    53.023
>
   107.152    52.554
   107.880    53.023
>
   107.595    53.643
   107.880    53.023
>
   107.595    53.643
   107.880    53.023
>
   109.999    53.658
   109.860    53.691
>
   109.999    53.658
   109.860    53.691
>
   108.745    53.263
   109.860    53.691
>
   108.745    53.263
   109.860    53.691
>
   108.745    53.263
   108.396    53.412
>
   108.745    53.263
   108.396    53.412
>
   107.741    53.323
   108.396    53.412
>
   107.741    53.323
   108.396    53.412
>
   107.595    53.643
   108.396    53.412
>
   107.595    53.643
   108.396    53.412
>
   108.080    52.760
   108.396    53.412
>
   108.080    52.760
   108.396    53.412
>
   108.080    52.760
   108.396    53.412
>
   107.741    53.323
   107.788    53.240
>
   107.741    53.323
   107.788    53.240
>
   107.595    53.643
   107.788    53.240
>
   107.595    53.643
   107.788    53.240
>
   108.080    52.760
   107.788    53.240
>
   108.080    52.760
   107.788    53.240
>
   108.745    53.263
   107.788    53.240
>
   108.745    53.263
   107.788    53.240
>
   107.152    52.554
   107.788    53.240
>
   107.152    52.554
   107.788    53.240
>
   107.741    53.323
   107.738    53.151
>
   107.741    53.323
   107.738    53.151
>
   107.595    53.643
   107.738    53.151
>
   107.595    53.643
   107.738    53.151
>
   108.745    53.263
   107.738    53.151
>
   108.745    53.263
   107.738    53.151
>
   107.595    53.643
   107.944    53.712
>
   107.595    53.643
   107.944    53.712
>
   107.741    53.323
   107.944    53.712
>
   107.741    53.323
   107.944    53.712
>
   108.745    53.263
   107.944    53.712
>
   108.745    53.263
   107.944    53.712
>
   108.285    52.986
   107.944    53.712
>
   108.285    52.986
   107.944    53.712
>
   107.741    53.323
   107.698    53.174
>
   107.741    53.323
   107.698    53.174
>
   108.285    52.986
   107.698    53.174
>
   108.285    52.986
   107.698    53.174
>
   107.595    53.643
   107.698    53.174
>
   107.595    53.643
   107.698    53.174
>
   108.745    53.263
   107.698    53.174
>
   108.745    53.263
   107.698    53.174
>
   107.152    52.554
   107.698    53.174
>
   107.152    52.554
   107.698    53.174
>
   108.745    53.263
   108.501    53.507
>
   108.745    53.263
   108.501    53.507
>
   107.741    53.323
   108.501    53.507
>
   107.741    53.323
   108.501    53.507
>
   108.285    52.986
   108.501    53.507
>
   108.285    52.986
   108.501    53.507
>
   107.595    53.643
   108.501    53.507
>
   107.595    53.643
   108.501    53.507
>
   108.080    52.760
   108.501    53.507
>
   108.080    52.760
   108.501    53.507
>
   108.745    53.263
   108.516    53.518
>
   108.745    53.263
   108.516    53.518
>
   108.285    52.986
   108.516    53.518
>
   108.285    52.986
   108.516    53.518
>
   107.741    53.323
   108.516    53.518
>
   107.741    53.323
   108.516    53.518
>
   107.595    53.643
   108.516    53.518
>
   107.595    53.643
   108.516    53.518
>
   107.595    53.643
   108.516    53.518
>
   109.999    53.658
   108.516    53.518
>
   109.999    53.658
   108.516    53.518
>
   108.080    52.760
   108.516    53.518
>
   108.080    52.760
   108.516    53.518
>
   107.741    53.323
   108.088    53.301
>
   107.741    53.323
   108.088    53.301
>
   108.285    52.986
   108.088    53.301
>
   108.285    52.986
   108.088    53.301
>
   108.745    53.263
   108.088    53.301
>
   108.745    53.263
   108.088    53.301
>
   107.595    53.643
   108.088    53.301
>
   107.595    53.643
   108.088    53.301
>
   108.745    53.263
   108.197    53.294
>
   108.745    53.263
   108.197    53.294
>
   108.285    52.986
   108.197    53.294
>
   108.285    52.986
   108.197    53.294
>
   107.741    53.323
   108.197    53.294
>
   107.741    53.323
   108.197    53.294
>
   107.595    53.643
   108.197    53.294
>
   107.595    53.643
   108.197    53.294
>
   108.285    52.986
   108.186    53.097
>
   108.285    52.986
   108.186    53.097
>
   108.080    52.760
   108.186    53.097
>
   108.080    52.760
   108.186    53.097
>
   107.741    53.323
   108.186    53.097
>
   107.741    53.323
   108.186    53.097
>
   108.745    53.263
   108.186    53.097
>
   108.745    53.263
   108.186    53.097
>
   107.595    53.643
   108.186    53.097
>
   107.595    53.643
   108.186    53.097
>
   107.152    52.554
   108.186    53.097
>
   107.152    52.554
   108.186    53.097
>
   107.741    53.323
   107.796    53.131
>
   107.741    53.323
   107.796    53.131
>
   107.741    53.323
   107.796    53.131
>
   108.285    52.986
   107.796    53.131
>
   108.285    52.986
   107.796    53.131
>
   108.285    52.986
   107.796    53.131
>
   108.080    52.760
   107.796    53.131
>
   108.080    52.760
   107.796    53.131
>
   107.595    53.643
   107.796    53.131
>
   107.595    53.643
   107.796    53.131
>
   108.745    53.263
   107.796    53.131
>
   108.745    53.263
   107.796    53.131
>
   107.152    52.554
   107.796    53.131
>
   107.152    52.554
   107.796    53.131
>
   109.999    53.658
   109.870    53.392
>
   109.999    53.658
   109.870    53.392
>
   109.999    53.658
   109.870    53.392
>
   108.745    53.263
   109.870    53.392
>
   108.745    53.263
   109.870    53.392
>
   108.745    53.263
   109.870    53.392
>
   107.595    53.643
   108.026    53.562
>
   107.595    53.643
   108.026    53.562
>
   107.741    53.323
   108.026    53.562
>
   107.741    53.323
   108.026    53.562
>
   108.745    53.263
   108.026    53.562
>
   108.745    53.263
   108.026    53.562
>
   108.285    52.986
   108.026    53.562
>
   108.285    52.986
   108.026    53.562
>
   108.080    52.760
   108.026    53.562
>
   108.080    52.760
   108.026    53.562
>
   107.741    53.323
   107.807    53.111
>
   107.741    53.323
   107.807    53.111
>
   108.285    52.986
   107.807    53.111
>
   108.285    52.986
   107.807    53.111
>
   108.080    52.760
   107.807    53.111
>
   108.080    52.760
   107.807    53.111
>
   108.745    53.263
   107.807    53.111
>
   108.745    53.263
   107.807    53.111
>
   107.595    53.643
   107.807    53.111
>
   107.595    53.643
   107.807    53.111
>
   107.152    52.554
   107.807    53.111
>
   107.152    52.554
   107.807    53.111
>
   108.745    53.263
   108.387    53.335
>
   108.745    53.263
   108.387    53.335
>
   108.745    53.263
   108.387    53.335
>
   108.285    52.986
   108.387    53.335
>
   108.285    52.986
   108.387    53.335
>
   107.595    53.643
   108.387    53.335
>
   107.595    53.643
   108.387    53.335
>
   108.080    52.760
   108.387    53.335
>
   108.080    52.760
   108.387    53.335
>
   108.285    52.986
   107.810    53.098
>
   108.285    52.986
   107.810    53.098
>
   108.080    52.760
   107.810    53.098
>
   108.080    52.760
   107.810    53.098
>
   107.595    53.643
   107.810    53.098
>
   107.595    53.643
   107.810    53.098
>
   108.745    53.263
   107.810    53.098
>
   108.745    53.263
   107.810    53.098
>
   107.152    52.554
   107.810    53.098
>
   107.152    52.554
   107.810    53.098
>
   108.745    53.263
   108.328    53.356
>
   108.745    53.263
   108.328    53.356
>
   108.285    52.986
   108.328    53.356
>
   108.285    52.986
   108.328    53.356
>
   107.595    53.643
   108.328    53.356
>
   107.595    53.643
   108.328    53.356
>
   108.080    52.760
   108.328    53.356
>
   108.080    52.760
   108.328    53.356
>
   108.285    52.986
   108.040    53.043
>
   108.285    52.986
   108.040    53.043
>
   108.080    52.760
   108.040    53.043
>
   108.080    52.760
   108.040    53.043
>
   107.741    53.323
   108.040    53.043
>
   107.741    53.323
   108.040    53.043
>
   108.745    53.263
   108.040    53.043
>
   108.745    53.263
   108.040    53.043
>
   107.595    53.643
   108.040    53.043
>
   107.595    53.643
   108.040    53.043
>
   107.152    52.554
   108.040    53.043
>
   107.152    52.554
   108.040    53.043
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
   108.300    54.100     0.300
   107.595    53.643     0.300
   106.348    52.760     0.300
   109.999    53.658     0.300
   108.745    53.263     0.300
   108.080    52.760     0.300
   107.152    52.554     0.300
   107.630    52.230     0.300
   107.741    53.323     0.300
   108.285    52.986     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
   108.434    53.900     0.200
>
   108.927    53.863     0.200
>
   107.085    53.455     0.200
>
   107.872    53.471     0.200
>
   109.838    53.418     0.200
>
   107.637    53.382     0.200
>
   107.542    53.319     0.200
>
   107.575    53.362     0.200
>
   107.528    53.333     0.200
>
   109.945    53.526     0.200
>
   107.731    53.299     0.200
>
   108.357    53.304     0.200
>
   108.504    53.290     0.200
>
   107.751    53.327     0.200
>
   108.312    53.242     0.200
>
   108.824    53.044     0.200
>
   108.513    53.110     0.200
>
   108.361    53.529     0.200
>
   108.252    53.245     0.200
>
   108.584    53.331     0.200
>
   108.322    53.310     0.200
>
   108.428    53.365     0.200
>
   109.011    53.434     0.200
>
   108.877    53.030     0.200
>
   108.589    53.280     0.200
>
   108.839    53.058     0.200
>
   109.552    53.466     0.200
>
   108.404    53.294     0.200
>
   107.685    53.390     0.200
>
   108.459    53.511     0.200
>
   109.763    53.457     0.200
>
   109.508    53.472     0.200
>
   110.003    53.550     0.200
>
   108.045    53.087     0.200
>
   107.706    53.428     0.200
>
   108.480    53.530     0.200
>
   108.801    53.427     0.200
>
   108.780    53.432     0.200
>
   109.896    53.696     0.200
>
   108.451    53.551     0.200
>
   108.465    53.386     0.200
>
   108.494    53.283     0.200
>
   108.553    53.324     0.200
>
   108.056    53.048     0.200
>
   108.492    53.289     0.200
>
   108.750    53.087     0.200
>
   108.049    53.052     0.200
>
   108.055    53.479     0.200
>
   108.480    53.292     0.200
>
   108.483    53.279     0.200
>
   108.468    53.291     0.200
>
   108.474    53.284     0.200
>
   108.501    53.289     0.200
>
   108.510    53.292     0.200
>
   108.471    53.280     0.200
>
   108.487    53.281     0.200
>
   108.461    53.273     0.200
>
   108.475    53.285     0.200
>
   108.506    53.315     0.200
>
   108.492    53.299     0.200
>
   109.732    53.476     0.200
>
   108.911    53.191     0.200
>
   108.469    53.288     0.200
>
   108.370    53.510     0.200
>
   107.319    53.341     0.200
>
   107.678    53.316     0.200
>
   108.496    53.289     0.200
>
   108.495    53.280     0.200
>
   108.483    53.279     0.200
>
   108.606    53.559     0.200
>
   108.475    53.290     0.200
>
   108.475    53.285     0.200
>
   109.797    53.726     0.200
>
   108.467    53.287     0.200
>
   108.471    53.293     0.200
>
   108.457    53.364     0.200
>
   108.484    53.366     0.200
>
   108.439    53.367     0.200
>
   108.464    53.354     0.200
>
   108.465    53.370     0.200
>
   108.462    53.360     0.200
>
   108.468    53.361     0.200
>
   108.503    53.286     0.200
>
   108.290    53.312     0.200
>
   108.484    53.304     0.200
>
   108.472    53.301     0.200
>
   108.244    53.325     0.200
>
   107.372    53.402     0.200
>
   108.453    53.282     0.200
>
   108.400    53.461     0.200
>
   108.468    53.307     0.200
>
   107.842    53.071     0.200
>
   108.999    53.183     0.200
>
   107.816    53.038     0.200
>
   108.023    53.303     0.200
>
   108.506    53.280     0.200
>
   108.479    53.277     0.200
>
   108.486    53.279     0.200
>
   108.485    53.269     0.200
>
   108.984    53.513     0.200
>
   108.678    53.324     0.200
>
   108.097    53.080     0.200
>
   108.094    53.082     0.200
>
   107.932    53.382     0.200
>
   108.859    53.422     0.200
>
   107.777    53.011     0.200
>
   108.435    53.303     0.200
>
   108.429    53.307     0.200
>
   108.526    53.325     0.200
>
   108.475    53.279     0.200
>
   108.469    53.278     0.200
>
   107.582    53.301     0.200
>
   108.479    53.276     0.200
>
   108.468    53.283     0.200
>
   108.448    53.470     0.200
>
   108.612    53.100     0.200
>
   108.554    53.272     0.200
>
   108.707    53.329     0.200
>
   108.087    53.052     0.200
>
   108.265    53.159     0.200
>
   108.278    53.131     0.200
>
   108.286    53.136     0.200
>
   108.457    53.299     0.200
>
   108.472    53.278     0.200
>
   109.049    53.499     0.200
>
   109.057    53.490     0.200
>
   107.929    53.262     0.200
>
   109.110    53.107     0.200
>
   108.503    53.271     0.200
>
   109.041    53.481     0.200
>
   108.482    53.275     0.200
>
   108.492    53.272     0.200
>
   107.287    53.277     0.200
>
   108.372    53.477     0.200
>
   108.791    53.622     0.200
>
   108.173    53.258     0.200
>
   107.970    53.094     0.200
>
   108.391    53.258     0.200
>
   108.610    53.352     0.200
>
   108.082    53.058     0.200
>
   108.085    53.068     0.200
>
   108.950    53.533     0.200
>
   108.660    53.377     0.200
>
   108.470    53.296     0.200
>
   108.065    53.276     0.200
>
   107.804    53.738     0.200
>
   108.637    53.572     0.200
>
   108.656    53.584     0.200
>
   108.620    53.575     0.200
>
   108.443    53.296     0.200
>
   108.461    53.372     0.200
>
   109.919    53.470     0.200
>
   109.926    53.608     0.200
>
   108.149    53.542     0.200
>
   107.868    53.031     0.200
>
   107.529    53.340     0.200
>
   108.096    53.502     0.200
>
   108.002    53.067     0.200
>
   108.094    53.505     0.200
>
   108.088    53.520     0.200
>
   108.617    53.370     0.200
>
   108.126    53.534     0.200
>
   108.113    53.206     0.200
>
   107.569    53.084     0.200
>
   107.787    53.139     0.200
>
   108.498    53.522     0.200
>
   108.536    53.211     0.200
>
   109.024    53.436     0.200
>
   109.896    53.723     0.200
>
   107.993    53.024     0.200
>
   107.798    53.143     0.200
>
   108.542    53.273     0.200
>
   107.281    53.373     0.200
>
   108.567    53.308     0.200
>
   108.023    53.041     0.200
>
   108.328    53.285     0.200
>
   109.887    53.523     0.200
>
   107.880    53.023     0.200
>
   109.860    53.691     0.200
>
   108.396    53.412     0.200
>
   107.788    53.240     0.200
>
   107.738    53.151     0.200
>
   107.944    53.712     0.200
>
   107.698    53.174     0.200
>
   108.501    53.507     0.200
>
   108.516    53.518     0.200
>
   108.088    53.301     0.200
>
   108.197    53.294     0.200
>
   108.186    53.097     0.200
>
   107.796    53.131     0.200
>
   109.870    53.392     0.200
>
   108.026    53.562     0.200
>
   107.807    53.111     0.200
>
   108.387    53.335     0.200
>
   107.810    53.098     0.200
>
   108.328    53.356     0.200
>
   108.040    53.043     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
   108.424    53.328     0.000   222.000   222.000
   108.424    53.328     0.000   444.000   444.000
EOF
gmt end
