#!/bin/bash
gmt begin ushkan1.37_base pdf,ps
proj=-JM16.0c+
reg=-R107.0/110.1/52.9/54.0
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map ushkan1.37'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
   108.434    53.900 1
   108.927    53.863 2
   107.085    53.455 3
   107.872    53.471 4
   109.838    53.418 5
   107.637    53.382 6
   107.542    53.319 7
   107.575    53.362 8
   107.528    53.333 9
   109.945    53.526 10
   107.731    53.299 11
   108.357    53.304 12
   108.504    53.290 13
   107.751    53.327 14
   108.312    53.242 15
   108.824    53.044 16
   108.513    53.110 17
   108.361    53.529 18
   108.252    53.245 19
   108.584    53.331 20
   108.322    53.310 21
   108.428    53.365 22
   109.011    53.434 23
   108.877    53.030 24
   108.589    53.280 25
   108.839    53.058 26
   109.552    53.466 27
   108.404    53.294 28
   107.685    53.390 29
   108.459    53.511 30
   109.763    53.457 31
   109.508    53.472 32
   110.003    53.550 33
   108.045    53.087 34
   107.706    53.428 35
   108.480    53.530 36
   108.801    53.427 37
   108.780    53.432 38
   109.896    53.696 39
   108.451    53.551 40
   108.465    53.386 41
   108.494    53.283 42
   108.553    53.324 43
   108.056    53.048 44
   108.492    53.289 45
   108.750    53.087 46
   108.049    53.052 47
   108.055    53.479 48
   108.480    53.292 49
   108.483    53.279 50
   108.468    53.291 51
   108.474    53.284 52
   108.501    53.289 53
   108.510    53.292 54
   108.471    53.280 55
   108.487    53.281 56
   108.461    53.273 57
   108.475    53.285 58
   108.506    53.315 59
   108.492    53.299 60
   109.732    53.476 61
   108.911    53.191 62
   108.469    53.288 63
   108.370    53.510 64
   107.319    53.341 65
   107.678    53.316 66
   108.496    53.289 67
   108.495    53.280 68
   108.483    53.279 69
   108.606    53.559 70
   108.475    53.290 71
   108.475    53.285 72
   109.797    53.726 73
   108.467    53.287 74
   108.471    53.293 75
   108.457    53.364 76
   108.484    53.366 77
   108.439    53.367 78
   108.464    53.354 79
   108.465    53.370 80
   108.462    53.360 81
   108.468    53.361 82
   108.503    53.286 83
   108.290    53.312 84
   108.484    53.304 85
   108.472    53.301 86
   108.244    53.325 87
   107.372    53.402 88
   108.453    53.282 89
   108.400    53.461 90
   108.468    53.307 91
   107.842    53.071 92
   108.999    53.183 93
   107.816    53.038 94
   108.023    53.303 95
   108.506    53.280 96
   108.479    53.277 97
   108.486    53.279 98
   108.485    53.269 99
   108.984    53.513 100
   108.678    53.324 101
   108.097    53.080 102
   108.094    53.082 103
   107.932    53.382 104
   108.859    53.422 105
   107.777    53.011 106
   108.435    53.303 107
   108.429    53.307 108
   108.526    53.325 109
   108.475    53.279 110
   108.469    53.278 111
   107.582    53.301 112
   108.479    53.276 113
   108.468    53.283 114
   108.448    53.470 115
   108.612    53.100 116
   108.554    53.272 117
   108.707    53.329 118
   108.087    53.052 119
   108.265    53.159 120
   108.278    53.131 121
   108.286    53.136 122
   108.457    53.299 123
   108.472    53.278 124
   109.049    53.499 125
   109.057    53.490 126
   107.929    53.262 127
   109.110    53.107 128
   108.503    53.271 129
   109.041    53.481 130
   108.482    53.275 131
   108.492    53.272 132
   107.287    53.277 133
   108.372    53.477 134
   108.791    53.622 135
   108.173    53.258 136
   107.970    53.094 137
   108.391    53.258 138
   108.610    53.352 139
   108.082    53.058 140
   108.085    53.068 141
   108.950    53.533 142
   108.660    53.377 143
   108.470    53.296 144
   108.065    53.276 145
   107.804    53.738 146
   108.637    53.572 147
   108.656    53.584 148
   108.620    53.575 149
   108.443    53.296 150
   108.461    53.372 151
   109.919    53.470 152
   109.926    53.608 153
   108.149    53.542 154
   107.868    53.031 155
   107.529    53.340 156
   108.096    53.502 157
   108.002    53.067 158
   108.094    53.505 159
   108.088    53.520 160
   108.617    53.370 161
   108.126    53.534 162
   108.113    53.206 163
   107.569    53.084 164
   107.787    53.139 165
   108.498    53.522 166
   108.536    53.211 167
   109.024    53.436 168
   109.896    53.723 169
   107.993    53.024 170
   107.798    53.143 171
   108.542    53.273 172
   107.281    53.373 173
   108.567    53.308 174
   108.023    53.041 175
   108.328    53.285 176
   109.887    53.523 177
   107.880    53.023 178
   109.860    53.691 179
   108.396    53.412 180
   107.788    53.240 181
   107.738    53.151 182
   107.944    53.712 183
   107.698    53.174 184
   108.501    53.507 185
   108.516    53.518 186
   108.088    53.301 187
   108.197    53.294 188
   108.186    53.097 189
   107.796    53.131 190
   109.870    53.392 191
   108.026    53.562 192
   107.807    53.111 193
   108.387    53.335 194
   107.810    53.098 195
   108.328    53.356 196
   108.040    53.043 197
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
   108.480    53.920
   108.434    53.900
>
   108.884    53.904
   108.927    53.863
>
   107.240    53.360
   107.085    53.455
>
   107.930    53.410
   107.872    53.471
>
   109.900    53.400
   109.838    53.418
>
   107.700    53.350
   107.637    53.382
>
   107.590    53.300
   107.542    53.319
>
   107.610    53.350
   107.575    53.362
>
   107.570    53.330
   107.528    53.333
>
   109.990    53.549
   109.945    53.526
>
   107.720    53.320
   107.731    53.299
>
   108.390    53.290
   108.357    53.304
>
   108.540    53.280
   108.504    53.290
>
   107.740    53.350
   107.751    53.327
>
   108.332    53.310
   108.312    53.242
>
   108.840    53.030
   108.824    53.044
>
   108.550    53.110
   108.513    53.110
>
   108.360    53.540
   108.361    53.529
>
   108.270    53.250
   108.252    53.245
>
   108.600    53.340
   108.584    53.331
>
   108.395    53.293
   108.322    53.310
>
   108.500    53.360
   108.428    53.365
>
   109.050    53.430
   109.011    53.434
>
   108.940    53.030
   108.877    53.030
>
   108.620    53.290
   108.589    53.280
>
   108.890    53.060
   108.839    53.058
>
   109.580    53.480
   109.552    53.466
>
   108.430    53.290
   108.404    53.294
>
   107.710    53.390
   107.685    53.390
>
   108.440    53.540
   108.459    53.511
>
   109.800    53.450
   109.763    53.457
>
   109.500    53.500
   109.508    53.472
>
   109.990    53.570
   110.003    53.550
>
   108.060    53.090
   108.045    53.087
>
   107.750    53.430
   107.706    53.428
>
   108.601    53.566
   108.480    53.530
>
   108.813    53.444
   108.801    53.427
>
   108.790    53.440
   108.780    53.432
>
   109.920    53.700
   109.896    53.696
>
   108.509    53.580
   108.451    53.551
>
   108.560    53.403
   108.465    53.386
>
   108.510    53.300
   108.494    53.283
>
   108.560    53.330
   108.553    53.324
>
   108.070    53.040
   108.056    53.048
>
   108.510    53.290
   108.492    53.289
>
   108.790    53.080
   108.750    53.087
>
   108.070    53.060
   108.049    53.052
>
   108.152    53.503
   108.055    53.479
>
   108.486    53.340
   108.480    53.292
>
   108.500    53.290
   108.483    53.279
>
   108.480    53.310
   108.468    53.291
>
   108.490    53.300
   108.474    53.284
>
   108.617    53.301
   108.501    53.289
>
   108.520    53.310
   108.510    53.292
>
   108.490    53.300
   108.471    53.280
>
   108.530    53.300
   108.487    53.281
>
   108.480    53.280
   108.461    53.273
>
   108.520    53.280
   108.475    53.285
>
   108.570    53.320
   108.506    53.315
>
   108.510    53.310
   108.492    53.299
>
   109.760    53.480
   109.732    53.476
>
   109.072    53.166
   108.911    53.191
>
   108.510    53.290
   108.469    53.288
>
   108.370    53.530
   108.370    53.510
>
   107.462    53.354
   107.319    53.341
>
   107.720    53.310
   107.678    53.316
>
   108.530    53.290
   108.496    53.289
>
   108.520    53.290
   108.495    53.280
>
   108.540    53.280
   108.483    53.279
>
   108.610    53.580
   108.606    53.559
>
   108.565    53.307
   108.475    53.290
>
   108.490    53.280
   108.475    53.285
>
   109.807    53.752
   109.797    53.726
>
   108.490    53.300
   108.467    53.287
>
   108.490    53.310
   108.471    53.293
>
   108.448    53.404
   108.457    53.364
>
   108.550    53.370
   108.484    53.366
>
   108.460    53.370
   108.439    53.367
>
   108.531    53.329
   108.464    53.354
>
   108.480    53.370
   108.465    53.370
>
   108.460    53.380
   108.462    53.360
>
   108.490    53.370
   108.468    53.361
>
   108.540    53.290
   108.503    53.286
>
   108.320    53.320
   108.290    53.312
>
   108.615    53.340
   108.484    53.304
>
   108.553    53.327
   108.472    53.301
>
   108.270    53.340
   108.244    53.325
>
   107.400    53.430
   107.372    53.402
>
   108.635    53.249
   108.453    53.282
>
   108.460    53.470
   108.400    53.461
>
   108.500    53.320
   108.468    53.307
>
   107.830    53.110
   107.842    53.071
>
   109.040    53.180
   108.999    53.183
>
   107.840    53.050
   107.816    53.038
>
   108.036    53.334
   108.023    53.303
>
   108.542    53.285
   108.506    53.280
>
   108.500    53.290
   108.479    53.277
>
   108.596    53.297
   108.486    53.279
>
   108.530    53.280
   108.485    53.269
>
   108.990    53.540
   108.984    53.513
>
   108.670    53.340
   108.678    53.324
>
   108.130    53.090
   108.097    53.080
>
   108.120    53.080
   108.094    53.082
>
   107.997    53.391
   107.932    53.382
>
   108.950    53.411
   108.859    53.422
>
   107.780    53.010
   107.777    53.011
>
   108.460    53.320
   108.435    53.303
>
   108.490    53.320
   108.429    53.307
>
   108.560    53.330
   108.526    53.325
>
   108.490    53.290
   108.475    53.279
>
   108.500    53.290
   108.469    53.278
>
   107.519    53.321
   107.582    53.301
>
   108.500    53.290
   108.479    53.276
>
   108.456    53.310
   108.468    53.283
>
   108.460    53.490
   108.448    53.470
>
   108.711    53.061
   108.612    53.100
>
   108.570    53.300
   108.554    53.272
>
   108.750    53.320
   108.707    53.329
>
   108.037    53.091
   108.087    53.052
>
   108.336    53.160
   108.265    53.159
>
   108.320    53.140
   108.278    53.131
>
   108.310    53.150
   108.286    53.136
>
   108.454    53.334
   108.457    53.299
>
   108.510    53.280
   108.472    53.278
>
   109.100    53.500
   109.049    53.499
>
   109.116    53.513
   109.057    53.490
>
   107.960    53.272
   107.929    53.262
>
   109.150    53.110
   109.110    53.107
>
   108.603    53.241
   108.503    53.271
>
   109.090    53.470
   109.041    53.481
>
   108.510    53.270
   108.482    53.275
>
   108.510    53.290
   108.492    53.272
>
   107.280    53.300
   107.287    53.277
>
   108.400    53.490
   108.372    53.477
>
   108.830    53.630
   108.791    53.622
>
   108.274    53.260
   108.173    53.258
>
   108.020    53.090
   107.970    53.094
>
   108.366    53.342
   108.391    53.258
>
   108.614    53.412
   108.610    53.352
>
   108.178    53.067
   108.082    53.058
>
   108.100    53.090
   108.085    53.068
>
   109.000    53.550
   108.950    53.533
>
   108.690    53.390
   108.660    53.377
>
   108.510    53.300
   108.470    53.296
>
   108.090    53.290
   108.065    53.276
>
   107.780    53.780
   107.804    53.738
>
   108.841    53.583
   108.637    53.572
>
   108.680    53.590
   108.656    53.584
>
   108.630    53.590
   108.620    53.575
>
   108.486    53.380
   108.443    53.296
>
   108.480    53.400
   108.461    53.372
>
   109.990    53.460
   109.919    53.470
>
   109.980    53.610
   109.926    53.608
>
   108.147    53.552
   108.149    53.542
>
   107.900    53.040
   107.868    53.031
>
   107.596    53.331
   107.529    53.340
>
   108.180    53.457
   108.096    53.502
>
   108.040    53.060
   108.002    53.067
>
   108.085    53.494
   108.094    53.505
>
   108.080    53.550
   108.088    53.520
>
   108.716    53.327
   108.617    53.370
>
   108.236    53.556
   108.126    53.534
>
   108.120    53.210
   108.113    53.206
>
   107.648    53.080
   107.569    53.084
>
   107.793    53.152
   107.787    53.139
>
   108.530    53.540
   108.498    53.522
>
   108.509    53.259
   108.536    53.211
>
   109.070    53.440
   109.024    53.436
>
   109.920    53.730
   109.896    53.723
>
   108.020    53.030
   107.993    53.024
>
   107.800    53.150
   107.798    53.143
>
   108.716    53.234
   108.542    53.273
>
   107.314    53.413
   107.281    53.373
>
   108.610    53.300
   108.567    53.308
>
   108.040    53.050
   108.023    53.041
>
   108.360    53.300
   108.328    53.285
>
   109.919    53.524
   109.887    53.523
>
   107.890    53.020
   107.880    53.023
>
   109.897    53.720
   109.860    53.691
>
   108.440    53.420
   108.396    53.412
>
   107.800    53.260
   107.788    53.240
>
   107.787    53.166
   107.738    53.151
>
   108.131    53.747
   107.944    53.712
>
   107.720    53.142
   107.698    53.174
>
   108.520    53.530
   108.501    53.507
>
   108.662    53.509
   108.516    53.518
>
   108.110    53.310
   108.088    53.301
>
   108.313    53.313
   108.197    53.294
>
   108.210    53.100
   108.186    53.097
>
   107.790    53.100
   107.796    53.131
>
   109.940    53.380
   109.870    53.392
>
   108.076    53.589
   108.026    53.562
>
   108.030    53.166
   107.807    53.111
>
   108.440    53.340
   108.387    53.335
>
   107.840    53.100
   107.810    53.098
>
   108.350    53.370
   108.328    53.356
>
   108.080    53.050
   108.040    53.043
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
   108.433    53.900
   108.434    53.900
>
   108.927    53.863
   108.927    53.863
>
   107.084    53.456
   107.085    53.455
>
   107.872    53.471
   107.872    53.471
>
   109.838    53.419
   109.838    53.418
>
   107.638    53.381
   107.637    53.382
>
   107.542    53.319
   107.542    53.319
>
   107.576    53.362
   107.575    53.362
>
   107.528    53.333
   107.528    53.333
>
   109.945    53.526
   109.945    53.526
>
   107.731    53.299
   107.731    53.299
>
   108.358    53.303
   108.357    53.304
>
   108.504    53.290
   108.504    53.290
>
   107.751    53.327
   107.751    53.327
>
   108.312    53.242
   108.312    53.242
>
   108.824    53.044
   108.824    53.044
>
   108.514    53.110
   108.513    53.110
>
   108.361    53.529
   108.361    53.529
>
   108.252    53.245
   108.252    53.245
>
   108.584    53.332
   108.584    53.331
>
   108.323    53.310
   108.322    53.310
>
   108.428    53.365
   108.428    53.365
>
   109.010    53.434
   109.011    53.434
>
   108.876    53.030
   108.877    53.030
>
   108.589    53.279
   108.589    53.280
>
   108.838    53.059
   108.839    53.058
>
   109.550    53.470
   109.552    53.466
>
   108.404    53.293
   108.404    53.294
>
   107.686    53.391
   107.685    53.390
>
   108.459    53.511
   108.459    53.511
>
   109.763    53.457
   109.763    53.457
>
   109.507    53.472
   109.508    53.472
>
   110.003    53.550
   110.003    53.550
>
   108.045    53.086
   108.045    53.087
>
   107.705    53.428
   107.706    53.428
>
   108.479    53.530
   108.480    53.530
>
   108.802    53.428
   108.801    53.427
>
   108.780    53.433
   108.780    53.432
>
   109.895    53.696
   109.896    53.696
>
   108.451    53.551
   108.451    53.551
>
   108.465    53.386
   108.465    53.386
>
   108.494    53.283
   108.494    53.283
>
   108.553    53.324
   108.553    53.324
>
   108.056    53.048
   108.056    53.048
>
   108.492    53.289
   108.492    53.289
>
   108.750    53.087
   108.750    53.087
>
   108.049    53.052
   108.049    53.052
>
   108.055    53.479
   108.055    53.479
>
   108.479    53.292
   108.480    53.292
>
   108.483    53.279
   108.483    53.279
>
   108.467    53.291
   108.468    53.291
>
   108.474    53.284
   108.474    53.284
>
   108.501    53.289
   108.501    53.289
>
   108.510    53.292
   108.510    53.292
>
   108.471    53.280
   108.471    53.280
>
   108.487    53.281
   108.487    53.281
>
   108.460    53.273
   108.461    53.273
>
   108.475    53.286
   108.475    53.285
>
   108.506    53.315
   108.506    53.315
>
   108.492    53.299
   108.492    53.299
>
   109.732    53.476
   109.732    53.476
>
   108.910    53.191
   108.911    53.191
>
   108.469    53.288
   108.469    53.288
>
   108.370    53.510
   108.370    53.510
>
   107.320    53.341
   107.319    53.341
>
   107.679    53.316
   107.678    53.316
>
   108.497    53.289
   108.496    53.289
>
   108.496    53.280
   108.495    53.280
>
   108.483    53.279
   108.483    53.279
>
   108.606    53.559
   108.606    53.559
>
   108.475    53.291
   108.475    53.290
>
   108.475    53.285
   108.475    53.285
>
   109.796    53.726
   109.797    53.726
>
   108.467    53.287
   108.467    53.287
>
   108.471    53.293
   108.471    53.293
>
   108.457    53.364
   108.457    53.364
>
   108.485    53.368
   108.484    53.366
>
   108.439    53.366
   108.439    53.367
>
   108.464    53.353
   108.464    53.354
>
   108.465    53.371
   108.465    53.370
>
   108.462    53.360
   108.462    53.360
>
   108.468    53.362
   108.468    53.361
>
   108.503    53.286
   108.503    53.286
>
   108.290    53.312
   108.290    53.312
>
   108.485    53.303
   108.484    53.304
>
   108.472    53.301
   108.472    53.301
>
   108.244    53.325
   108.244    53.325
>
   107.372    53.402
   107.372    53.402
>
   108.453    53.281
   108.453    53.282
>
   108.400    53.461
   108.400    53.461
>
   108.468    53.307
   108.468    53.307
>
   107.842    53.071
   107.842    53.071
>
   108.999    53.182
   108.999    53.183
>
   107.816    53.039
   107.816    53.038
>
   108.024    53.304
   108.023    53.303
>
   108.506    53.280
   108.506    53.280
>
   108.479    53.277
   108.479    53.277
>
   108.485    53.279
   108.486    53.279
>
   108.485    53.269
   108.485    53.269
>
   108.984    53.513
   108.984    53.513
>
   108.678    53.324
   108.678    53.324
>
   108.096    53.081
   108.097    53.080
>
   108.093    53.082
   108.094    53.082
>
   107.932    53.381
   107.932    53.382
>
   108.859    53.422
   108.859    53.422
>
   107.777    53.012
   107.777    53.011
>
   108.435    53.303
   108.435    53.303
>
   108.429    53.307
   108.429    53.307
>
   108.526    53.325
   108.526    53.325
>
   108.475    53.279
   108.475    53.279
>
   108.469    53.278
   108.469    53.278
>
   107.582    53.301
   107.582    53.301
>
   108.479    53.276
   108.479    53.276
>
   108.469    53.284
   108.468    53.283
>
   108.448    53.470
   108.448    53.470
>
   108.612    53.100
   108.612    53.100
>
   108.553    53.273
   108.554    53.272
>
   108.708    53.329
   108.707    53.329
>
   108.087    53.052
   108.087    53.052
>
   108.265    53.159
   108.265    53.159
>
   108.278    53.131
   108.278    53.131
>
   108.285    53.136
   108.286    53.136
>
   108.457    53.299
   108.457    53.299
>
   108.472    53.278
   108.472    53.278
>
   109.048    53.499
   109.049    53.499
>
   109.056    53.490
   109.057    53.490
>
   107.929    53.263
   107.929    53.262
>
   109.110    53.107
   109.110    53.107
>
   108.503    53.271
   108.503    53.271
>
   109.040    53.482
   109.041    53.481
>
   108.481    53.275
   108.482    53.275
>
   108.492    53.272
   108.492    53.272
>
   107.288    53.276
   107.287    53.277
>
   108.372    53.478
   108.372    53.477
>
   108.791    53.622
   108.791    53.622
>
   108.172    53.258
   108.173    53.258
>
   107.970    53.095
   107.970    53.094
>
   108.392    53.258
   108.391    53.258
>
   108.610    53.353
   108.610    53.352
>
   108.083    53.058
   108.082    53.058
>
   108.085    53.068
   108.085    53.068
>
   108.950    53.533
   108.950    53.533
>
   108.660    53.377
   108.660    53.377
>
   108.470    53.297
   108.470    53.296
>
   108.065    53.276
   108.065    53.276
>
   107.805    53.738
   107.804    53.738
>
   108.636    53.573
   108.637    53.572
>
   108.656    53.584
   108.656    53.584
>
   108.621    53.575
   108.620    53.575
>
   108.442    53.296
   108.443    53.296
>
   108.461    53.372
   108.461    53.372
>
   109.919    53.470
   109.919    53.470
>
   109.926    53.608
   109.926    53.608
>
   108.149    53.542
   108.149    53.542
>
   107.868    53.030
   107.868    53.031
>
   107.529    53.339
   107.529    53.340
>
   108.096    53.501
   108.096    53.502
>
   108.002    53.067
   108.002    53.067
>
   108.094    53.505
   108.094    53.505
>
   108.088    53.520
   108.088    53.520
>
   108.617    53.370
   108.617    53.370
>
   108.126    53.534
   108.126    53.534
>
   108.113    53.206
   108.113    53.206
>
   107.569    53.083
   107.569    53.084
>
   107.787    53.139
   107.787    53.139
>
   108.498    53.522
   108.498    53.522
>
   108.536    53.211
   108.536    53.211
>
   109.024    53.436
   109.024    53.436
>
   109.896    53.723
   109.896    53.723
>
   107.996    53.023
   107.993    53.024
>
   107.798    53.143
   107.798    53.143
>
   108.542    53.273
   108.542    53.273
>
   107.282    53.373
   107.281    53.373
>
   108.567    53.309
   108.567    53.308
>
   108.023    53.041
   108.023    53.041
>
   108.328    53.286
   108.328    53.285
>
   109.887    53.523
   109.887    53.523
>
   107.879    53.023
   107.880    53.023
>
   109.860    53.691
   109.860    53.691
>
   108.396    53.413
   108.396    53.412
>
   107.788    53.240
   107.788    53.240
>
   107.738    53.151
   107.738    53.151
>
   107.943    53.712
   107.944    53.712
>
   107.698    53.174
   107.698    53.174
>
   108.501    53.506
   108.501    53.507
>
   108.516    53.518
   108.516    53.518
>
   108.088    53.301
   108.088    53.301
>
   108.197    53.294
   108.197    53.294
>
   108.186    53.097
   108.186    53.097
>
   107.796    53.131
   107.796    53.131
>
   109.869    53.393
   109.870    53.392
>
   108.026    53.562
   108.026    53.562
>
   107.807    53.111
   107.807    53.111
>
   108.386    53.335
   108.387    53.335
>
   107.810    53.098
   107.810    53.098
>
   108.328    53.356
   108.328    53.356
>
   108.039    53.042
   108.040    53.043
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
   108.434    53.900    33.753     2.483     6.622
   108.927    53.863    48.247     1.479     2.403
   107.085    53.455   -38.966     0.028     3.401
   107.872    53.471    60.359     3.315     6.154
   109.838    53.418    41.136     3.240     4.366
   107.637    53.382    46.511     3.693     5.967
   107.542    53.319    48.797     3.022     5.096
   107.575    53.362    46.827     2.734     4.598
   107.528    53.333    46.335     2.731     4.731
   109.945    53.526    52.742     1.558     3.150
   107.731    53.299    45.703     3.446     5.018
   108.357    53.304    56.670     2.564     3.888
   108.504    53.290    63.880     2.312     3.399
   107.751    53.327    39.354     2.727     4.662
   108.312    53.242    52.052     1.564     2.894
   108.824    53.044    59.302     2.600     4.079
   108.513    53.110    51.891     1.806     3.285
   108.361    53.529    57.638     1.973     3.291
   108.252    53.245    51.341     1.266     2.558
   108.584    53.331    48.368     1.799     3.430
   108.322    53.310    50.386     0.986     2.034
   108.428    53.365    48.851     1.971     4.590
   109.011    53.434    56.095     2.413     3.871
   108.877    53.030    45.031     1.774     4.523
   108.589    53.280    47.901     1.391     2.727
   108.839    53.058    49.908     2.649     3.482
   109.552    53.466    51.531     1.838     4.029
   108.404    53.294    53.221     1.228     2.377
   107.685    53.390    45.885     2.187     3.478
   108.459    53.511    55.715     1.988     3.626
   109.763    53.457    50.991     1.501     3.702
   109.508    53.472    49.087     1.130     4.070
   110.003    53.550    48.869     2.235     4.675
   108.045    53.087    49.638     1.700     3.380
   107.706    53.428    46.852     3.262     5.757
   108.480    53.530    60.888     1.017     1.607
   108.801    53.427    49.287     1.119     1.773
   108.780    53.432    52.587     1.202     2.528
   109.896    53.696    45.795     1.350     3.205
   108.451    53.551    48.388     1.009     1.955
   108.465    53.386    56.789     1.221     1.908
   108.494    53.283    51.583     1.158     2.626
   108.553    53.324    52.045     1.466     2.924
   108.056    53.048    50.634     1.976     3.133
   108.492    53.289    52.380     1.271     2.215
   108.750    53.087    45.369     1.886     3.298
   108.049    53.052    36.422     1.408     2.047
   108.055    53.479    56.903     1.852     3.476
   108.480    53.292    53.002     0.894     1.258
   108.483    53.279    54.199     1.089     1.727
   108.468    53.291    58.593     1.483     2.288
   108.474    53.284    51.728     1.104     1.788
   108.501    53.289    51.269     1.178     2.306
   108.510    53.292    50.153     1.625     3.196
   108.471    53.280    51.530     1.321     2.319
   108.487    53.281    51.904     1.347     2.186
   108.461    53.273    55.076     2.680     3.633
   108.475    53.285    58.216     2.196     3.050
   108.506    53.315    47.381     2.367     3.064
   108.492    53.299    50.370     1.341     2.278
   109.732    53.476    43.085     2.163     6.003
   108.911    53.191    52.077     1.449     2.664
   108.469    53.288    52.157     1.129     1.879
   108.370    53.510    52.826     1.593     2.797
   107.319    53.341    46.203     1.669     3.650
   107.678    53.316    35.018     2.630     3.792
   108.496    53.289    60.268     1.226     1.951
   108.495    53.280    61.327     1.745     2.956
   108.483    53.279    72.131     2.793     4.378
   108.606    53.559    55.531     1.481     2.745
   108.475    53.290    57.275     1.278     2.200
   108.475    53.285    54.675     1.310     2.345
   109.797    53.726    46.448     1.190     3.068
   108.467    53.287    59.549     1.201     1.922
   108.471    53.293    58.713     1.178     2.236
   108.457    53.364    54.282     1.251     1.949
   108.484    53.366    72.765     2.916     3.405
   108.439    53.367    58.566     1.661     2.604
   108.464    53.354    60.799     1.561     2.373
   108.465    53.370    59.110     1.417     2.350
   108.462    53.360    55.704     1.435     2.295
   108.468    53.361    54.933     1.446     2.576
   108.503    53.286    51.671     1.352     2.550
   108.290    53.312    56.922     1.435     2.394
   108.484    53.304    50.078     1.075     1.462
   108.472    53.301    55.670     1.170     2.000
   108.244    53.325    53.307     1.750     2.843
   107.372    53.402    29.993     1.912     3.882
   108.453    53.282    51.161     1.246     2.345
   108.400    53.461    50.578     2.602     3.264
   108.468    53.307    50.127     1.191     2.313
   107.842    53.071    52.237     1.656     3.333
   108.999    53.183    49.827     1.677     4.380
   107.816    53.038    46.722     1.582     2.754
   108.023    53.303    46.733     1.239     2.083
   108.506    53.280    64.285     1.593     2.558
   108.479    53.277    52.274     1.758     2.549
   108.486    53.279    52.045     1.321     2.197
   108.485    53.269    51.617     1.307     2.180
   108.984    53.513    51.494     1.244     2.923
   108.678    53.324    48.486     1.700     3.551
   108.097    53.080    50.215     1.564     3.001
   108.094    53.082    57.416     1.490     2.599
   107.932    53.382    52.071     1.572     2.582
   108.859    53.422    49.389     1.328     2.335
   107.777    53.011    44.355     1.918     3.068
   108.435    53.303    50.448     1.570     2.899
   108.429    53.307    38.187     2.509     3.899
   108.526    53.325    52.382     1.577     2.765
   108.475    53.279    52.362     1.283     2.536
   108.469    53.278    52.387     1.554     2.837
   107.582    53.301    45.237     1.896     3.555
   108.479    53.276    56.273     1.353     2.514
   108.468    53.283    54.256     1.096     1.934
   108.448    53.470    55.997     1.750     3.160
   108.612    53.100    49.292     1.143     2.321
   108.554    53.272    51.727     1.669     3.261
   108.707    53.329    48.537     1.931     3.178
   108.087    53.052    54.119     1.368     2.437
   108.265    53.159    48.718     0.989     1.755
   108.278    53.131    24.603     2.603     3.859
   108.286    53.136    47.738     1.395     2.651
   108.457    53.299    51.514     1.065     2.230
   108.472    53.278    46.348     1.510     2.585
   109.049    53.499    47.947     1.632     3.893
   109.057    53.490    50.843     0.958     1.875
   107.929    53.262    52.461     1.283     2.225
   109.110    53.107    50.338     1.697     3.621
   108.503    53.271    49.828     1.007     2.006
   109.041    53.481    48.622     1.020     3.084
   108.482    53.275    52.398     1.153     2.413
   108.492    53.272    51.705     1.133     2.330
   107.287    53.277    48.950     2.328     4.344
   108.372    53.477    69.732     2.256     3.302
   108.791    53.622    44.984     1.552     4.215
   108.173    53.258    52.657     1.283     2.716
   107.970    53.094    71.135     2.047     2.442
   108.391    53.258    52.433     1.700     3.711
   108.610    53.352    50.739     1.196     2.370
   108.082    53.058    52.253     1.307     3.104
   108.085    53.068    56.705     1.573     3.688
   108.950    53.533    42.174     2.067     4.827
   108.660    53.377    50.721     1.618     3.143
   108.470    53.296    45.518     1.338     2.354
   108.065    53.276    39.432     1.395     1.832
   107.804    53.738    46.714     1.612     2.920
   108.637    53.572    45.763     1.042     1.885
   108.656    53.584    45.002     1.314     2.576
   108.620    53.575    43.801     1.461     2.694
   108.443    53.296    49.104     0.986     2.006
   108.461    53.372    45.244     1.242     2.300
   109.919    53.470    46.854     1.557     3.576
   109.926    53.608    43.580     1.977     4.132
   108.149    53.542    47.756     1.122     1.838
   107.868    53.031    53.354     2.041     2.637
   107.529    53.340    49.980     1.208     2.464
   108.096    53.502    53.446     1.442     2.567
   108.002    53.067    44.273     1.641     2.724
   108.094    53.505    58.110     1.377     2.313
   108.088    53.520    38.542     1.417     1.927
   108.617    53.370    51.757     0.997     1.626
   108.126    53.534    43.486     1.309     1.985
   108.113    53.206    31.807     1.695     2.097
   107.569    53.084    48.092     1.438     2.049
   107.787    53.139    47.060     1.348     1.763
   108.498    53.522    43.004     1.157     2.047
   108.536    53.211    44.504     1.138     1.945
   109.024    53.436    47.894     1.434     3.081
   109.896    53.723    40.761     1.705     3.571
   107.993    53.024    55.125     1.671     2.342
   107.798    53.143    46.282     1.285     1.591
   108.542    53.273    48.579     1.292     2.237
   107.281    53.373    48.258     1.428     2.561
   108.567    53.308    50.091     1.295     2.344
   108.023    53.041    35.118     1.524     2.288
   108.328    53.285    47.238     1.735     3.131
   109.887    53.523    43.139     2.206     4.110
   107.880    53.023    37.960     1.424     2.254
   109.860    53.691    45.245     1.480     2.836
   108.396    53.412    47.363     1.521     2.626
   107.788    53.240    40.029     1.622     2.548
   107.738    53.151    45.622     1.205     2.380
   107.944    53.712    44.104     1.165     2.019
   107.698    53.174    50.196     1.424     2.037
   108.501    53.507    46.215     1.569     2.579
   108.516    53.518    42.022     0.997     1.563
   108.088    53.301    53.082     1.623     2.018
   108.197    53.294    33.159     1.442     1.925
   108.186    53.097    35.444     1.582     2.316
   107.796    53.131    55.424     1.819     2.399
   109.870    53.392    45.683     1.461     3.911
   108.026    53.562    39.230     1.451     2.244
   107.807    53.111    43.579     1.566     1.949
   108.387    53.335    44.338     2.230     3.349
   107.810    53.098    49.844     1.756     2.256
   108.328    53.356    35.961     1.885     3.107
   108.040    53.043    49.094     1.374     1.686
EOF

# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
   107.074    52.965    34.112     2.570     4.349
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
   107.096    52.965   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
   107.074    52.965     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
   107.074    52.965     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
   107.074    52.920   5 km
EOF
gmt end
