#!/bin/bash
gmt begin tofino1.52_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases tofino1.52'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     0.500     0.926
     1.000    -2.574
     1.500    -6.074
     2.000    -9.574
     2.500   -13.074
     3.000   -16.574
     3.500   -20.079
     4.000   -23.586
     4.500   -27.095
     5.000   -30.609
     5.500   -34.125
     6.000   -37.646
     6.500   -41.171
     7.000   -44.702
     7.500   -48.237
     8.000   -51.777
     8.500   -55.324
     9.000   -58.877
     9.500   -62.437
    10.000   -66.004
    10.500   -69.579
    11.000   -73.161
    11.500   -76.752
    12.000   -80.351
    12.500   -83.960
    13.000   -87.578
    13.500   -91.208
    14.000   -94.850
    14.500   -98.503
    15.000  -102.167
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -84.578 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     0.786
     1.000    -1.492
     1.500    -3.320
     2.000    -5.048
     2.500    -6.739
     3.000    -8.413
     3.500   -10.079
     4.000   -11.741
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -14.741 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
    10.089     1.330     0.200
    15.217    -6.136     0.200
     2.973    -3.434     0.200
     6.079    -3.596     0.200
     9.251    -4.553     0.200
    18.856    -2.587     0.200
    19.228    -2.409     0.200
     4.124    -6.354     0.200
     5.106    -6.587     0.200
    14.978    -3.658     0.200
     2.538    -4.081     0.200
     2.761    -4.459     0.200
     3.389    -4.745     0.200
     3.618    -4.355     0.200
     5.181    -7.391     0.200
     6.778   -11.590     0.200
     9.103    -7.603     0.200
     3.854    -3.935     0.200
     5.703    -6.467     0.200
     2.548     1.119     0.200
     2.548    -0.006     0.200
     2.853    -2.239     0.200
     3.626    -2.684     0.200
     4.023    -5.777     0.200
     5.266    -1.964     0.200
     5.699    -3.357     0.200
     5.927    -3.324     0.200
     6.245    -0.873     0.200
     6.723    -2.820     0.200
     7.573    -4.814     0.200
     8.683    -4.881     0.200
     8.705    -5.535     0.200
     8.949    -3.025     0.200
     9.238    -9.725     0.200
     9.446    -8.452     0.200
     9.470    -9.112     0.200
     9.735    -2.369     0.200
    10.224     1.332     0.200
    12.136    -6.882     0.200
    12.892     1.439     0.200
    13.219     5.475     0.200
    13.876    -4.780     0.200
    14.785    -2.419     0.200
    14.810    -2.327     0.200
    14.872   -11.200     0.200
    14.926    -5.523     0.200
    14.929    -6.049     0.200
    18.654    -1.423     0.200
    19.255     0.443     0.200
    19.255    -7.229     0.200
    20.052    -4.531     0.200
    20.140   -15.254     0.200
    20.140   -10.840     0.200
    28.782   -18.994     0.200
     2.985    -4.549     0.200
     3.367    -5.928     0.200
     5.768    -5.144     0.200
     9.612    -7.808     0.200
    14.696   -12.557     0.200
    19.255    -7.892     0.200
    19.277   -18.065     0.200
    19.571    -7.288     0.200
     3.600   -10.876     0.200
     9.832    -9.198     0.200
     4.083    -1.985     0.200
     5.378    -4.414     0.200
    10.303    -3.628     0.200
    15.161   -11.370     0.200
    19.097   -12.420     0.200
     3.140    -6.911     0.200
     9.441   -11.209     0.200
    14.731   -10.379     0.200
    19.009    -8.896     0.200
    19.426   -12.906     0.200
    19.587   -11.208     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     2.101    -9.116     0.200
     4.792   -30.286     0.200
     2.372    -9.994     0.200
     4.212   -24.617     0.200
     0.861    -0.667     0.200
     0.302     3.542     0.200
     0.279     4.925     0.200
     0.409     3.020     0.200
     0.681     0.298     0.200
     0.744     0.261     0.200
     0.726     0.399     0.200
     0.740     0.193     0.200
     0.888    -0.965     0.200
     0.918    -0.592     0.200
     1.072    -2.304     0.200
     1.133    -1.482     0.200
     1.129    -2.026     0.200
     1.427    -3.876     0.200
     1.856    -7.886     0.200
     2.150   -10.536     0.200
     2.342   -10.776     0.200
     3.068   -17.092     0.200
     5.498   -35.993     0.200
     6.149   -40.422     0.200
     7.004   -43.230     0.200
     0.238     3.330     0.200
     0.344     2.086     0.200
     0.613    -0.278     0.200
     0.632     0.053     0.200
     0.758    -1.233     0.200
     0.883    -1.737     0.200
     0.877    -1.332     0.200
     0.947    -1.131     0.200
     0.994    -2.214     0.200
     1.061    -2.724     0.200
     1.067    -2.690     0.200
     1.108    -3.545     0.200
     1.220    -2.809     0.200
     1.365    -2.556     0.200
     1.393    -3.350     0.200
     1.431    -3.568     0.200
     1.427    -3.539     0.200
     1.442    -2.580     0.200
     1.571    -3.874     0.200
     1.889    -6.890     0.200
     4.124   -23.627     0.200
     0.238     3.381     0.200
     0.451     1.444     0.200
     0.682    -1.301     0.200
     0.744    -0.833     0.200
     0.732    -0.507     0.200
     1.015    -1.666     0.200
     1.036    -3.256     0.200
     1.105    -2.430     0.200
     1.393    -5.267     0.200
     1.770    -7.351     0.200
     1.775    -8.969     0.200
     0.791     0.138     0.200
     0.939    -0.821     0.200
     1.235    -1.419     0.200
     1.253    -1.674     0.200
     1.439    -5.627     0.200
     2.053    -7.992     0.200
     2.246    -9.996     0.200
     2.498   -10.250     0.200
     2.590   -10.357     0.200
     2.692   -12.909     0.200
     2.832   -13.550     0.200
     2.923   -13.107     0.200
     2.976   -16.061     0.200
     3.296   -16.288     0.200
     3.420   -16.755     0.200
     3.746   -20.967     0.200
     4.069   -18.654     0.200
     4.177   -20.858     0.200
     4.635   -29.175     0.200
     4.725   -29.198     0.200
     5.018   -31.234     0.200
     5.337   -32.983     0.200
     5.723   -35.801     0.200
     9.330   -55.830     0.200
     0.937    -0.800     0.200
     1.245    -2.687     0.200
     1.256    -1.944     0.200
     1.297    -3.661     0.200
     1.434    -5.183     0.200
     2.972   -14.580     0.200
     2.972   -14.759     0.200
     4.195   -23.382     0.200
     4.177   -23.596     0.200
     5.329   -32.458     0.200
     9.324   -56.012     0.200
     1.165    -2.135     0.200
     4.210   -23.666     0.200
     4.560   -27.698     0.200
     0.784    -1.052     0.200
     0.825    -1.375     0.200
     0.902    -0.705     0.200
     4.198   -24.906     0.200
     4.529   -28.582     0.200
     4.705   -29.031     0.200
     5.017   -31.019     0.200
     0.825    -2.028     0.200
     1.229    -4.188     0.200
     1.474    -5.623     0.200
     1.582    -6.957     0.200
     1.608    -5.965     0.200
     1.758    -6.759     0.200
     1.994    -8.485     0.200
     2.129    -9.293     0.200
     2.341   -12.367     0.200
     2.387   -11.223     0.200
     2.892   -14.397     0.200
     3.141   -14.622     0.200
     3.854   -22.583     0.200
     3.854   -22.158     0.200
     4.042   -21.035     0.200
     5.478   -32.067     0.200
     5.849   -33.802     0.200
     0.502     1.118     0.200
     0.617     1.049     0.200
     0.752    -1.104     0.200
     1.283    -4.679     0.200
     2.788   -15.124     0.200
     2.788   -15.593     0.200
     0.108     8.886     0.200
     0.370     3.686     0.200
     0.412     3.188     0.200
     0.445     2.544     0.200
     0.451     2.597     0.200
     0.538     2.632     0.200
     0.577     1.149     0.200
     0.558     2.403     0.200
     0.621     0.740     0.200
     0.665     0.832     0.200
     0.737     0.474     0.200
     0.797    -0.218     0.200
     0.968    -1.023     0.200
     1.028    -1.603     0.200
     1.041    -2.496     0.200
     1.052    -2.101     0.200
     1.105    -1.710     0.200
     1.197    -3.017     0.200
     1.849    -8.665     0.200
     2.147   -10.864     0.200
     0.240     4.771     0.200
     0.286     3.800     0.200
     0.320     4.011     0.200
     0.343     3.303     0.200
     0.342     3.359     0.200
     0.364     2.675     0.200
     0.380     2.882     0.200
     0.454     1.899     0.200
     0.568     1.613     0.200
     0.729     0.196     0.200
     0.754    -0.281     0.200
     0.749     0.374     0.200
     0.761     0.174     0.200
     0.784    -0.165     0.200
     0.842    -1.434     0.200
     0.865    -1.255     0.200
     0.860    -0.275     0.200
     0.882    -0.601     0.200
     0.994    -2.628     0.200
     1.041    -1.342     0.200
     1.098    -2.652     0.200
     1.218    -3.093     0.200
     1.317    -3.591     0.200
     1.346    -5.071     0.200
     1.388    -4.509     0.200
     1.477    -4.830     0.200
     2.049    -9.632     0.200
     2.331   -12.652     0.200
     0.357     2.712     0.200
     0.329     3.922     0.200
     0.458     2.410     0.200
     0.525     2.089     0.200
     0.645     0.233     0.200
     0.659     0.023     0.200
     0.681     0.734     0.200
     0.748     0.165     0.200
     0.803    -0.319     0.200
     0.813    -0.492     0.200
     0.842    -0.826     0.200
     0.886    -1.972     0.200
     0.888    -2.022     0.200
     0.902    -0.445     0.200
     0.995    -1.524     0.200
     1.007    -2.346     0.200
     1.051    -1.065     0.200
     1.183    -3.029     0.200
     1.308    -5.189     0.200
     1.359    -4.479     0.200
     1.417    -4.677     0.200
     1.402    -4.848     0.200
     1.508    -5.888     0.200
     1.627    -6.265     0.200
     1.700    -7.332     0.200
     1.773    -8.225     0.200
     1.738    -6.202     0.200
     1.776    -7.658     0.200
     1.894    -9.778     0.200
     1.895    -9.522     0.200
     1.894    -9.407     0.200
     1.894    -7.607     0.200
     1.896    -9.296     0.200
     2.086   -11.266     0.200
     2.253    -9.039     0.200
     2.316   -10.422     0.200
     2.554   -16.790     0.200
     2.790   -13.229     0.200
     2.801   -14.198     0.200
     2.873   -15.204     0.200
     3.004   -15.833     0.200
     3.006   -15.936     0.200
     3.146   -16.183     0.200
     3.152   -17.232     0.200
     3.388   -21.273     0.200
     3.513   -19.560     0.200
     3.550   -19.996     0.200
     3.606   -19.911     0.200
     3.883   -23.356     0.200
     3.943   -24.410     0.200
     3.943   -23.010     0.200
     4.556   -27.571     0.200
     0.842    -1.008     0.200
     0.878    -0.975     0.200
     1.348    -5.017     0.200
     2.880   -15.099     0.200
     4.324   -27.162     0.200
     4.835   -30.442     0.200
     5.082   -32.422     0.200
     5.145   -32.761     0.200
     5.145   -32.663     0.200
     5.829   -37.900     0.200
    14.872  -103.700     0.200
    17.304  -114.723     0.200
    17.640  -118.103     0.200
     2.919   -15.745     0.200
     5.094   -32.758     0.200
     5.157   -32.857     0.200
     0.493     0.489     0.200
     0.736     0.564     0.200
     1.415    -5.975     0.200
     1.531    -5.708     0.200
     1.671    -8.475     0.200
     2.324   -10.881     0.200
     2.534   -12.676     0.200
     2.875   -16.407     0.200
     2.875   -15.037     0.200
     3.716   -21.874     0.200
     5.085   -32.232     0.200
     5.148   -32.428     0.200
     0.518     0.450     0.200
     1.432    -5.790     0.200
     1.654    -7.321     0.200
     2.077    -8.370     0.200
     2.152    -9.614     0.200
     2.896   -16.614     0.200
     1.045    -1.435     0.200
     1.046    -1.382     0.200
     1.046    -1.295     0.200
     1.046    -1.479     0.200
     1.047    -1.223     0.200
     1.048    -1.438     0.200
     1.049    -1.200     0.200
     1.050    -1.596     0.200
     1.050    -1.400     0.200
     1.060    -1.926     0.200
     1.165    -0.369     0.200
     1.163    -1.779     0.200
     1.266    -1.413     0.200
     1.311    -2.965     0.200
     1.726    -6.059     0.200
     2.557   -10.860     0.200
     3.711   -19.043     0.200
     0.846    -0.892     0.200
     0.924    -1.304     0.200
     0.973    -1.474     0.200
     0.999    -2.197     0.200
     1.946   -10.218     0.200
     0.927    -1.375     0.200
     0.981    -1.717     0.200
     0.990    -1.248     0.200
     0.999    -2.144     0.200
     2.759   -12.914     0.200
     0.752     0.242     0.200
     0.867     0.881     0.200
     0.893    -0.048     0.200
     1.063    -1.648     0.200
     1.237    -1.473     0.200
     1.355    -4.006     0.200
     1.563    -6.614     0.200
     1.768    -6.451     0.200
     2.271    -9.168     0.200
     2.331    -9.003     0.200
     2.426    -9.765     0.200
     2.608   -10.735     0.200
     2.663   -12.465     0.200
     2.898   -13.143     0.200
     2.898   -12.995     0.200
     3.100   -16.556     0.200
     3.100   -16.712     0.200
     0.471     0.205     0.200
     0.637    -0.236     0.200
     1.182    -4.399     0.200
     1.156    -3.793     0.200
     1.465    -5.884     0.200
     1.480    -5.829     0.200
     1.838    -7.550     0.200
     2.275   -11.482     0.200
     2.419   -10.297     0.200
     2.696   -14.912     0.200
     2.853   -14.527     0.200
     2.853   -14.396     0.200
     3.017   -15.609     0.200
     3.915   -25.080     0.200
     4.038   -25.285     0.200
     4.417   -27.954     0.200
     4.459   -28.335     0.200
     4.557   -29.154     0.200
     4.799   -31.133     0.200
     4.799   -31.702     0.200
     4.862   -31.018     0.200
     4.862   -31.559     0.200
     5.094   -31.836     0.200
     0.122     7.039     0.200
     0.271     4.569     0.200
     0.286     4.074     0.200
     0.316     4.490     0.200
     0.523     1.493     0.200
     0.602     0.847     0.200
     0.812    -0.523     0.200
     0.883     0.059     0.200
     0.984    -1.223     0.200
     1.047    -2.322     0.200
     1.112    -2.477     0.200
     1.141    -2.446     0.200
     1.279    -2.879     0.200
     1.542    -5.785     0.200
     1.571    -6.994     0.200
     1.593    -6.240     0.200
     1.593    -6.229     0.200
     1.595    -6.309     0.200
     1.595    -6.009     0.200
     1.595    -6.116     0.200
     1.765    -7.986     0.200
     1.881    -8.107     0.200
     2.044    -7.611     0.200
     2.053    -7.334     0.200
     2.132   -10.352     0.200
     2.411    -9.806     0.200
     2.448   -12.802     0.200
     2.558   -15.464     0.200
     2.574   -12.248     0.200
     3.014   -18.119     0.200
     3.381   -19.529     0.200
     3.367   -20.653     0.200
     3.585   -20.791     0.200
     3.585   -20.341     0.200
     3.605   -20.205     0.200
     3.891   -21.251     0.200
     4.313   -26.328     0.200
     4.386   -24.500     0.200
     4.665   -30.077     0.200
     5.300   -34.215     0.200
     5.581   -37.488     0.200
     5.856   -36.948     0.200
     5.847   -40.116     0.200
     6.150   -38.824     0.200
     6.646   -41.627     0.200
     0.641     1.168     0.200
     0.666     2.055     0.200
     0.779     1.714     0.200
     0.842     1.201     0.200
     0.921    -0.532     0.200
     1.115    -1.301     0.200
     1.115    -1.173     0.200
     1.114    -1.194     0.200
     1.114    -1.093     0.200
     2.205    -9.341     0.200
     0.218     4.740     0.200
     0.337     3.391     0.200
     0.345     3.149     0.200
     0.420     2.290     0.200
     0.526     1.518     0.200
     0.535     0.802     0.200
     0.781    -0.985     0.200
     0.782    -1.387     0.200
     0.798    -0.869     0.200
     0.792    -0.201     0.200
     0.878    -0.463     0.200
     0.885    -1.574     0.200
     0.938    -2.181     0.200
     1.043    -1.462     0.200
     1.079    -2.402     0.200
     1.162    -2.439     0.200
     1.303    -4.330     0.200
     1.331    -3.795     0.200
     1.349    -3.454     0.200
     1.413    -4.278     0.200
     1.629    -6.682     0.200
     1.693    -6.798     0.200
     1.830    -8.584     0.200
     1.830    -8.553     0.200
     1.830    -8.548     0.200
     1.830    -8.552     0.200
     1.831    -8.275     0.200
     1.831    -8.441     0.200
     1.832    -8.581     0.200
     1.874    -8.611     0.200
     1.958    -8.633     0.200
     2.011    -9.627     0.200
     3.000   -15.834     0.200
     3.126   -17.503     0.200
     3.737   -21.417     0.200
     3.843   -23.276     0.200
     0.204     5.478     0.200
     0.252     4.470     0.200
     0.281     3.973     0.200
     0.281     4.090     0.200
     0.322     3.241     0.200
     0.392     2.606     0.200
     0.404     3.191     0.200
     0.424     2.447     0.200
     0.642     1.070     0.200
     0.707    -0.089     0.200
     0.761    -0.486     0.200
     0.800    -0.405     0.200
     0.800    -0.223     0.200
     0.807     0.118     0.200
     0.831    -0.358     0.200
     0.850    -0.289     0.200
     0.844    -0.405     0.200
     0.935    -0.578     0.200
     1.038    -1.603     0.200
     1.129    -2.402     0.200
     1.282    -2.527     0.200
     1.321    -3.211     0.200
     1.434    -5.865     0.200
     1.459    -5.722     0.200
     1.778    -6.359     0.200
     2.538   -11.505     0.200
     0.488     0.680     0.200
     0.488     1.298     0.200
     0.520     0.625     0.200
     0.650    -0.159     0.200
     0.687    -0.414     0.200
     0.687    -0.258     0.200
     1.090    -4.086     0.200
     1.183    -3.756     0.200
     1.408    -5.527     0.200
     1.535    -6.480     0.200
     1.580    -6.121     0.200
     1.580    -6.048     0.200
     1.701    -7.625     0.200
     1.828    -8.066     0.200
     1.887    -7.453     0.200
     2.068   -10.733     0.200
     2.043    -9.145     0.200
     2.043    -8.974     0.200
     2.043    -8.825     0.200
     2.045    -8.986     0.200
     2.167   -10.897     0.200
     2.183    -9.542     0.200
     2.632   -12.155     0.200
     2.670   -11.578     0.200
     2.918   -14.541     0.200
     2.929   -13.329     0.200
     2.929   -14.110     0.200
     3.483   -20.126     0.200
     3.484   -17.618     0.200
     4.238   -23.342     0.200
     4.550   -28.816     0.200
     4.961   -31.123     0.200
     5.440   -34.157     0.200
     0.035     8.198     0.200
     0.035     8.358     0.200
     0.066     7.108     0.200
     0.302     3.313     0.200
     0.299     3.069     0.200
     0.300     2.971     0.200
     0.521     0.634     0.200
     0.710     0.763     0.200
     0.829    -1.093     0.200
     0.859    -1.342     0.200
     0.859    -1.670     0.200
     0.934    -1.648     0.200
     0.934    -1.770     0.200
     1.003    -2.529     0.200
     1.036    -1.793     0.200
     1.036    -2.012     0.200
     1.049    -2.372     0.200
     1.219    -4.262     0.200
     1.238    -3.093     0.200
     1.326    -4.719     0.200
     1.411    -5.119     0.200
     1.410    -5.015     0.200
     1.411    -5.120     0.200
     1.413    -5.111     0.200
     1.413    -4.892     0.200
     1.566    -7.123     0.200
     1.931   -12.956     0.200
     3.600   -21.450     0.200
     5.617   -32.489     0.200
     0.299     4.139     0.200
     0.340     3.449     0.200
     0.463     1.911     0.200
     0.463     2.081     0.200
     0.462     2.062     0.200
     0.659     1.141     0.200
     0.655     1.200     0.200
     0.779     0.484     0.200
     0.966    -0.772     0.200
     0.966    -1.172     0.200
     0.943    -1.872     0.200
     0.941    -0.594     0.200
     1.107    -2.529     0.200
     1.067    -2.366     0.200
     1.173    -2.694     0.200
     1.220    -2.567     0.200
     1.266    -4.523     0.200
     1.434    -6.133     0.200
     1.786    -7.948     0.200
     1.844    -6.651     0.200
     1.867    -7.992     0.200
     1.947    -9.041     0.200
     2.233   -11.920     0.200
     2.409   -12.433     0.200
     2.622   -13.638     0.200
     2.745   -18.030     0.200
     2.986   -18.332     0.200
     3.395   -20.188     0.200
     3.488   -20.704     0.200
     4.266   -25.731     0.200
     0.260     3.776     0.200
     0.401     1.522     0.200
     0.449     1.387     0.200
     0.500     0.535     0.200
     0.566    -0.492     0.200
     0.595    -0.116     0.200
     0.596     0.050     0.200
     0.961    -2.623     0.200
     1.036    -3.141     0.200
     1.056    -3.367     0.200
     1.124    -3.203     0.200
     1.255    -4.100     0.200
     1.245    -4.184     0.200
     1.245    -4.210     0.200
     1.481    -9.476     0.200
     1.436    -4.859     0.200
     1.441    -5.190     0.200
     1.461    -6.007     0.200
     1.550    -5.991     0.200
     1.668    -6.426     0.200
     1.792    -8.612     0.200
     1.922    -8.022     0.200
     2.253   -11.155     0.200
     2.341   -10.893     0.200
     2.422   -12.684     0.200
     2.390   -12.372     0.200
     2.489   -10.939     0.200
     2.679   -14.712     0.200
     3.039   -15.950     0.200
     3.070   -15.999     0.200
     3.098   -15.158     0.200
     3.781   -21.998     0.200
     3.843   -20.867     0.200
     4.252   -22.938     0.200
     4.679   -29.428     0.200
     5.089   -32.529     0.200
     0.076     7.598     0.200
     0.244     3.593     0.200
     0.244     3.413     0.200
     0.254     3.435     0.200
     0.559     0.743     0.200
     0.559     0.485     0.200
     0.560     0.828     0.200
     0.560     0.508     0.200
     0.575     0.832     0.200
     0.575     0.660     0.200
     0.576     0.943     0.200
     0.576     0.716     0.200
     0.609     0.331     0.200
     0.702     0.203     0.200
     0.702    -0.183     0.200
     0.806    -1.141     0.200
     0.806    -1.441     0.200
     0.856    -1.403     0.200
     0.856    -1.841     0.200
     0.838    -0.289     0.200
     0.856    -1.627     0.200
     0.857    -1.660     0.200
     0.857    -1.773     0.200
     0.860    -1.508     0.200
     0.897    -1.991     0.200
     0.897    -2.101     0.200
     0.963    -1.598     0.200
     0.970    -1.376     0.200
     1.074    -2.222     0.200
     1.259    -3.270     0.200
     1.336    -3.309     0.200
     1.373    -4.380     0.200
     1.391    -4.520     0.200
     1.662    -6.435     0.200
     1.737    -8.386     0.200
     1.972   -10.065     0.200
     2.103    -9.099     0.200
     2.374   -11.308     0.200
     2.914   -14.134     0.200
     1.154    -3.790     0.200
     1.247    -4.654     0.200
     4.083   -24.766     0.200
     7.049   -41.260     0.200
     0.505     0.460     0.200
     0.654     0.295     0.200
     0.679     0.397     0.200
     0.788    -1.056     0.200
     0.841    -1.383     0.200
     0.906    -2.004     0.200
     0.166     4.881     0.200
     0.210     3.892     0.200
     0.320     2.939     0.200
     0.344     2.373     0.200
     0.355     2.993     0.200
     0.414     1.892     0.200
     0.414     2.039     0.200
     0.493     1.348     0.200
     0.772    -0.541     0.200
     0.801    -0.322     0.200
     0.866    -0.302     0.200
     0.903    -1.438     0.200
     0.912    -0.487     0.200
     0.949    -1.187     0.200
     1.120    -1.630     0.200
     1.281    -2.875     0.200
     1.349    -2.935     0.200
     1.385    -3.210     0.200
     1.544    -5.087     0.200
     0.212     4.508     0.200
     0.235     4.986     0.200
     0.219     4.798     0.200
     0.219     5.028     0.200
     0.270     4.582     0.200
     0.219     4.850     0.200
     0.310     4.116     0.200
     0.332     4.202     0.200
     0.354     2.861     0.200
     0.354     2.941     0.200
     0.509     1.163     0.200
     0.509     1.293     0.200
     0.459     2.574     0.200
     0.597     0.824     0.200
     0.675     0.566     0.200
     0.763    -0.689     0.200
     0.763    -0.848     0.200
     0.782    -0.664     0.200
     0.836    -1.082     0.200
     0.836    -1.442     0.200
     0.836    -1.048     0.200
     0.829    -1.118     0.200
     0.829    -1.399     0.200
     0.864    -1.655     0.200
     0.935    -1.639     0.200
     0.965    -2.712     0.200
     1.000    -2.759     0.200
     1.001    -2.126     0.200
     1.001    -2.755     0.200
     1.001    -2.286     0.200
     1.003    -2.785     0.200
     1.050    -3.140     0.200
     1.050    -2.901     0.200
     1.070    -2.902     0.200
     1.158    -3.426     0.200
     1.158    -3.246     0.200
     1.173    -3.417     0.200
     1.127    -2.775     0.200
     1.127    -2.905     0.200
     1.248    -3.659     0.200
     1.275    -4.082     0.200
     1.340    -5.083     0.200
     1.365    -6.332     0.200
     1.575    -6.650     0.200
     1.621    -6.118     0.200
     1.641    -6.443     0.200
     1.696    -8.156     0.200
     1.862    -7.186     0.200
     1.860    -7.648     0.200
     1.938    -8.909     0.200
     1.955    -8.815     0.200
     1.999    -8.482     0.200
     2.022    -9.519     0.200
     2.361   -10.762     0.200
     2.346   -12.014     0.200
     2.441   -12.258     0.200
     2.510   -12.894     0.200
     2.525   -12.874     0.200
     2.564   -13.925     0.200
     2.922   -17.053     0.200
     2.964   -19.231     0.200
     3.008   -17.424     0.200
     3.201   -18.405     0.200
     3.430   -20.450     0.200
     0.069     7.039     0.200
     0.259     3.518     0.200
     0.393     2.115     0.200
     0.523     1.577     0.200
     0.587     0.255     0.200
     0.593     0.459     0.200
     0.593     0.239     0.200
     0.673     0.170     0.200
     0.859    -1.461     0.200
     0.860    -1.428     0.200
     0.906    -0.951     0.200
     0.950    -0.737     0.200
     3.111   -17.998     0.200
     3.140   -18.012     0.200
     5.541   -37.378     0.200
     5.541   -37.663     0.200
     7.946   -48.927     0.200
     0.492     0.986     0.200
     0.492     1.096     0.200
     0.492     1.265     0.200
     0.492     1.031     0.200
     0.490     2.328     0.200
     0.536     0.264     0.200
     0.566     0.848     0.200
     0.566     0.953     0.200
     0.599     0.436     0.200
     0.599     0.531     0.200
     2.356   -11.626     0.200
     2.708   -13.961     0.200
     2.959   -15.705     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.980    -1.961     0.200
     1.387    -3.743     0.200
     1.438    -3.909     0.200
     1.406    -4.449     0.200
     1.652    -4.812     0.200
     2.930    -7.562     0.200
     0.837    -1.476     0.200
     0.925    -1.683     0.200
     1.117    -1.690     0.200
     1.364    -1.854     0.200
     1.558    -1.730     0.200
     2.182    -2.982     0.200
     2.267    -4.410     0.200
     1.282    -3.336     0.200
     1.508    -4.349     0.200
     1.510    -3.720     0.200
     1.538    -4.832     0.200
     1.780    -4.914     0.200
     3.027   -12.114     0.200
     1.508    -4.449     0.200
     1.528    -3.521     0.200
     1.648    -4.616     0.200
     0.449    -0.343     0.200
     0.506     1.465     0.200
     0.863    -2.588     0.200
     0.896    -2.320     0.200
     0.966    -1.664     0.200
     1.269    -3.167     0.200
     1.313    -2.167     0.200
     1.392    -3.923     0.200
     1.628    -3.643     0.200
     1.770    -6.198     0.200
     1.886    -4.276     0.200
     2.181    -5.431     0.200
     2.242    -6.248     0.200
     2.612    -6.166     0.200
     2.676    -4.645     0.200
     2.794    -7.153     0.200
     2.924    -7.887     0.200
     3.095    -9.626     0.200
     3.688    -9.749     0.200
     0.378     0.668     0.200
     0.467     1.439     0.200
     1.113    -2.314     0.200
     1.177    -3.294     0.200
     1.213    -3.101     0.200
     1.318    -3.270     0.200
     1.583    -3.389     0.200
     1.735    -4.606     0.200
     1.826    -3.774     0.200
     2.135    -3.775     0.200
     2.185    -4.828     0.200
     2.560    -5.812     0.200
     2.625    -4.427     0.200
     2.618    -5.931     0.200
     2.744    -6.585     0.200
     2.744    -5.886     0.200
     3.045    -6.195     0.200
     3.790   -11.548     0.200
     0.319     2.327     0.200
     0.319     2.198     0.200
     0.731    -0.810     0.200
     0.811    -1.180     0.200
     0.824    -1.484     0.200
     1.142    -3.263     0.200
     1.246    -3.413     0.200
     1.384    -3.967     0.200
     1.459    -4.825     0.200
     1.506    -3.674     0.200
     1.662    -5.154     0.200
     1.726    -5.736     0.200
     1.898    -6.909     0.200
     0.994    -1.249     0.200
     1.005    -1.625     0.200
     1.279    -3.840     0.200
     1.278    -3.155     0.200
     1.341    -2.939     0.200
     1.499    -3.919     0.200
     0.408     1.616     0.200
     1.111    -2.196     0.200
     1.195    -2.948     0.200
     1.266    -2.324     0.200
     1.257    -2.440     0.200
     1.342    -2.791     0.200
     1.529    -3.404     0.200
     1.806    -4.555     0.200
     2.880    -7.927     0.200
     2.880    -8.458     0.200
     0.451     1.535     0.200
     0.554    -0.289     0.200
     0.900    -2.377     0.200
     1.175    -2.077     0.200
     2.919    -9.261     0.200
     0.392     2.094     0.200
     0.823    -1.468     0.200
     0.863    -0.589     0.200
     0.837    -0.483     0.200
     1.023    -1.758     0.200
     1.059    -2.018     0.200
     1.092    -2.160     0.200
     1.143    -2.342     0.200
     1.183    -2.375     0.200
     1.247    -2.623     0.200
     1.341    -3.985     0.200
     1.323    -3.829     0.200
     0.403     2.227     0.200
     0.845    -1.585     0.200
     0.889    -1.072     0.200
     1.047    -1.422     0.200
     1.072    -2.122     0.200
     1.114    -2.126     0.200
     1.209    -2.970     0.200
     1.265    -3.240     0.200
     1.266    -2.420     0.200
     1.363    -4.240     0.200
     1.803    -6.559     0.200
     2.896    -7.638     0.200
     0.456     0.385     0.200
     0.629     0.154     0.200
     0.784    -0.263     0.200
     0.792    -0.422     0.200
     0.993    -1.244     0.200
     1.046    -2.045     0.200
     1.165    -3.417     0.200
     1.441    -2.038     0.200
     1.501    -3.048     0.200
     1.525    -2.783     0.200
     1.576    -2.541     0.200
     1.834    -3.170     0.200
     2.013    -3.016     0.200
     2.287    -7.503     0.200
     3.007   -10.394     0.200
     0.132     1.761     0.200
     0.152     1.437     0.200
     0.219     0.947     0.200
     0.388    -0.459     0.200
     0.400     0.335     0.200
     0.537    -0.409     0.200
     0.601    -0.376     0.200
     0.697    -0.771     0.200
     0.750    -0.844     0.200
     0.821    -1.586     0.200
     0.897    -2.072     0.200
     0.915    -1.952     0.200
     1.244    -2.156     0.200
     1.256    -2.598     0.200
     1.260    -2.414     0.200
     1.444    -2.706     0.200
     1.479    -3.377     0.200
     1.480    -3.504     0.200
     1.480    -3.261     0.200
     1.480    -3.576     0.200
     1.480    -3.076     0.200
     1.481    -2.901     0.200
     1.481    -3.231     0.200
     1.481    -3.326     0.200
     1.482    -3.221     0.200
     1.483    -2.934     0.200
     1.484    -3.233     0.200
     1.539    -3.379     0.200
     1.628    -3.539     0.200
     1.643    -3.882     0.200
     1.667    -4.769     0.200
     1.678    -4.411     0.200
     1.679    -4.686     0.200
     2.021    -6.087     0.200
     2.036    -6.549     0.200
     0.126     2.207     0.200
     0.145     1.735     0.200
     0.222     0.808     0.200
     0.384     0.461     0.200
     0.408     0.201     0.200
     0.540    -0.247     0.200
     0.601    -0.436     0.200
     0.705    -1.062     0.200
     0.743    -0.758     0.200
     0.829    -1.395     0.200
     0.850    -1.253     0.200
     0.896    -2.024     0.200
     0.911    -2.070     0.200
     1.248    -2.139     0.200
     1.256    -2.941     0.200
     1.258    -2.642     0.200
     1.441    -3.586     0.200
     1.478    -3.337     0.200
     1.479    -3.392     0.200
     1.479    -3.729     0.200
     1.478    -3.224     0.200
     1.480    -3.376     0.200
     1.480    -3.420     0.200
     1.480    -3.550     0.200
     1.481    -3.201     0.200
     1.482    -3.344     0.200
     1.483    -3.201     0.200
     1.542    -3.164     0.200
     1.628    -3.504     0.200
     1.641    -4.001     0.200
     1.686    -4.723     0.200
     2.041    -5.222     0.200
     1.329    -2.794     0.200
     1.336    -2.214     0.200
     1.259    -4.024     0.200
     1.489    -4.520     0.200
     1.531    -3.854     0.200
     1.517    -4.319     0.200
     1.579    -4.860     0.200
     1.605    -4.414     0.200
     1.630    -4.989     0.200
     1.767    -5.972     0.200
     1.836    -4.627     0.200
     2.498    -8.858     0.200
     0.925    -2.305     0.200
     0.930    -1.095     0.200
     1.348    -3.506     0.200
     1.532    -4.786     0.200
     0.194     2.497     0.200
     0.467     1.639     0.200
     1.204    -1.682     0.200
     1.205    -1.803     0.200
     1.205    -1.664     0.200
     1.205    -1.762     0.200
     1.206    -1.623     0.200
     1.209    -1.512     0.200
     1.232    -2.031     0.200
     1.291    -2.919     0.200
     1.317    -3.503     0.200
     1.310    -3.147     0.200
     1.310    -3.037     0.200
     1.415    -3.440     0.200
     1.454    -2.740     0.200
     1.530    -3.663     0.200
     1.567    -3.667     0.200
     1.875    -6.222     0.200
     1.906    -5.958     0.200
     1.936    -6.132     0.200
     2.126    -7.563     0.200
     0.286     3.126     0.200
     0.916    -1.708     0.200
     0.917    -1.609     0.200
     0.917    -1.741     0.200
     1.183    -3.584     0.200
     1.182    -2.514     0.200
     1.182    -2.350     0.200
     1.305    -3.753     0.200
     1.604    -5.852     0.200
     1.569    -5.580     0.200
     1.604    -5.209     0.200
     1.708    -5.521     0.200
     0.275     2.854     0.200
     0.275     2.690     0.200
     0.275     2.869     0.200
     0.275     2.752     0.200
     0.434     1.230     0.200
     0.434     1.026     0.200
     0.513     0.531     0.200
     0.704    -0.358     0.200
     0.704    -0.928     0.200
     0.672     0.581     0.200
     0.704    -0.912     0.200
     0.746    -0.781     0.200
     0.746    -1.140     0.200
     0.740     0.573     0.200
     1.034    -2.912     0.200
     1.109    -2.744     0.200
     1.155    -3.321     0.200
     1.230    -2.911     0.200
     1.240    -3.209     0.200
     1.349    -3.573     0.200
     1.478    -4.880     0.200
     0.113     5.313     0.200
     0.112     5.327     0.200
     0.112     5.458     0.200
     0.183     4.000     0.200
     0.214     3.351     0.200
     0.350     2.167     0.200
     0.350     2.276     0.200
     0.393     1.362     0.200
     0.393     1.373     0.200
     0.659    -0.253     0.200
     0.726    -0.220     0.200
     0.727    -0.264     0.200
     0.861    -1.336     0.200
     0.921    -1.590     0.200
     1.003    -2.218     0.200
     1.011    -1.416     0.200
     1.106    -2.028     0.200
     1.130    -2.152     0.200
     1.126    -1.544     0.200
     1.202    -2.979     0.200
     1.202    -2.986     0.200
     1.203    -2.912     0.200
     1.204    -2.867     0.200
     1.354    -3.459     0.200
     1.513    -4.537     0.200
     0.333     0.938     0.200
     0.409     0.456     0.200
     0.538     0.448     0.200
     1.076    -2.687     0.200
     1.103    -1.902     0.200
     1.129    -2.108     0.200
     1.197    -2.298     0.200
     1.228    -1.813     0.200
     1.500    -3.603     0.200
     1.514    -3.802     0.200
     2.064    -7.584     0.200
     0.303     2.446     0.200
     0.274     2.400     0.200
     0.304     2.555     0.200
     0.290     3.316     0.200
     0.386     2.605     0.200
     0.638     0.328     0.200
     0.674    -0.121     0.200
     0.674     0.275     0.200
     0.674    -0.008     0.200
     0.715     0.890     0.200
     0.715     1.077     0.200
     0.751    -0.228     0.200
     0.784     0.194     0.200
     0.784    -0.185     0.200
     0.814    -0.386     0.200
     0.815    -0.345     0.200
     0.796    -1.182     0.200
     0.800     0.467     0.200
     0.901     0.016     0.200
     0.905    -0.785     0.200
     0.901    -0.461     0.200
     0.902    -1.025     0.200
     0.894    -1.535     0.200
     0.904    -1.198     0.200
     0.909    -1.555     0.200
     0.909    -1.812     0.200
     0.942    -1.754     0.200
     1.034    -1.542     0.200
     1.088    -1.000     0.200
     1.106    -1.961     0.200
     1.092    -1.624     0.200
     1.168    -2.020     0.200
     1.201    -1.681     0.200
     1.218    -1.427     0.200
     1.250    -1.942     0.200
     1.217    -1.669     0.200
     1.412    -3.595     0.200
     1.420    -3.794     0.200
     1.460    -3.152     0.200
     1.477    -2.684     0.200
     1.622    -3.210     0.200
     1.766    -4.607     0.200
     1.841    -3.875     0.200
     1.871    -5.193     0.200
     1.924    -5.727     0.200
     1.949    -4.357     0.200
     1.961    -4.133     0.200
     2.285    -7.332     0.200
     2.337    -6.688     0.200
     2.360    -7.710     0.200
     2.521    -5.955     0.200
     2.755    -7.786     0.200
EOF
gmt end
