#!/bin/bash
gmt begin tofino1.52_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional tofino1.52'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.000    40.527
    14.500    40.250
    15.000    39.971
    15.500    39.689
    16.000    39.403
    16.500    39.112
    17.000    38.814
    17.500    38.507
    18.000    38.189
    18.500    37.858
    19.000    37.513
    19.500    37.150
    20.000    36.767
    20.500    36.363
    21.000    35.934
    21.500    35.479
    22.000    34.996
    22.500    34.483
    23.000    33.938
    23.500    33.261
    24.000    31.997
    24.500    30.723
    25.000    29.440
    25.500    28.146
    26.000    26.841
    26.500    25.524
    27.000    24.194
    27.500    22.848
    28.000    21.481
    28.500    20.100
    29.000    18.708
    29.500    17.308
    30.000    15.900
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    18.481 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     0.500     3.966
     1.000     5.224
     1.500     6.483
     2.000     7.741
     2.500     9.000
     3.000    10.259
     3.500    11.517
     4.000    12.772
     4.500    14.028
     5.000    15.282
     5.500    16.535
     6.000    17.787
     6.500    19.037
     7.000    20.285
     7.500    21.532
     8.000    22.777
     8.500    24.019
     9.000    25.260
     9.500    26.498
    10.000    27.734
    10.500    28.967
    11.000    30.197
    11.500    31.425
    12.000    32.240
    12.500    32.991
    13.000    33.724
    13.500    34.439
    14.000    35.131
    14.500    35.798
    15.000    36.390
    15.500    36.926
    16.000    37.412
    16.500    37.846
    17.000    38.228
    17.500    37.558
    18.000    37.887
    18.500    38.158
    19.000    38.372
    19.500    38.527
    20.000    38.625
    20.500    38.663
    21.000    38.642
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    30.724 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.902
     1.000     5.978
     1.500     8.307
     2.000    10.694
     2.500    13.101
     3.000    15.518
     3.500    17.939
     4.000    20.363
     4.500    22.788
     5.000    25.213
     5.500    27.637
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    23.213 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     0.500    10.941
     1.000    17.456
     1.500    23.971
     2.000    30.486
     2.500    37.001
     3.000    43.516
     3.500    50.026
     4.000    56.534
     4.500    63.040
     5.000    69.541
     5.500    76.040
     6.000    82.534
     6.500    89.024
     7.000    95.508
     7.500   101.988
     8.000   108.463
     8.500   114.931
     9.000   121.393
     9.500   127.848
    10.000   134.296
    10.500   140.736
    11.000   147.169
    11.500   153.593
    12.000   160.009
    12.500   166.415
    13.000   172.812
    13.500   179.197
    14.000   185.570
    14.500   191.932
    15.000   198.283
    15.500   204.621
    16.000   210.946
    16.500   217.259
    17.000   223.559
    17.500   231.496
    18.000   237.762
    18.500   244.015
    19.000   250.255
    19.500   256.482
    20.000   262.695
    20.500   268.893
    21.000   275.076
    21.500   281.243
    22.000   287.395
    22.500   293.531
    23.000   299.651
    23.500   305.753
    24.000   311.838
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    54.534 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    10.801
     1.000    18.538
     1.500    26.725
     2.000    35.012
     2.500    43.336
     3.000    51.677
     3.500    60.026
     4.000    68.379
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    58.026 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    26.837  -302.795     0.150
    18.606   315.565     0.150
    20.140   259.199     0.150
    17.585   315.436     0.150
    19.489   295.668     0.150
    19.009   302.796     0.150
    26.321  -299.468     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    19.108    39.918     0.200
    19.539    39.394     0.200
    19.775    39.336     0.200
    20.480    39.301     0.200
    20.685    36.513     0.200
    20.771    38.317     0.200
    21.154    39.043     0.200
    21.156    39.414     0.200
    21.703    38.232     0.200
    21.962    35.618     0.200
    22.897    35.703     0.200
    26.035    29.887     0.200
    26.619    29.166     0.200
    26.837    28.217     0.200
    27.164    27.610     0.200
    27.530    24.940     0.200
    28.797    22.655     0.200
    29.044    20.968     0.200
    29.248    20.190     0.200
    15.133    41.846     0.200
    16.383    40.716     0.200
    16.953    39.374     0.200
    17.228    39.639     0.200
    18.539    40.371     0.200
    21.153    39.770     0.200
    21.651    37.679     0.200
    23.786    34.177     0.200
    25.694    30.035     0.200
    27.009    26.551     0.200
    27.009    27.730     0.200
    29.013    21.365     0.200
    16.615    41.769     0.200
    16.955    40.698     0.200
    19.519    37.410     0.200
    22.783    35.264     0.200
    23.096    36.782     0.200
    24.406    33.629     0.200
    25.744    30.937     0.200
    25.744    31.317     0.200
    27.741    25.359     0.200
    28.632    21.672     0.200
    14.493    38.436     0.200
    14.510    42.804     0.200
    14.566    38.119     0.200
    14.603    38.095     0.200
    14.916    38.938     0.200
    15.491    38.084     0.200
    15.768    37.389     0.200
    16.004    39.117     0.200
    16.257    38.772     0.200
    17.417    40.627     0.200
    17.662    39.290     0.200
    17.653    39.906     0.200
    19.469    34.336     0.200
    20.765    33.666     0.200
    21.638    35.270     0.200
    21.865    37.363     0.200
    22.800    29.966     0.200
    24.909    30.153     0.200
    26.408    26.766     0.200
    26.408    27.085     0.200
    27.487    22.903     0.200
    27.743    22.522     0.200
    28.168    21.717     0.200
    28.930    18.462     0.200
    29.846    16.584     0.200
    16.145    42.975     0.200
    16.087    42.035     0.200
    16.559    42.897     0.200
    17.219    42.852     0.200
    17.728    41.669     0.200
    18.146    43.223     0.200
    18.355    41.078     0.200
    19.357    40.218     0.200
    20.582    37.400     0.200
    20.582    37.750     0.200
    21.164    40.409     0.200
    21.262    41.995     0.200
    21.531    39.808     0.200
    21.600    39.673     0.200
    21.776    37.934     0.200
    21.725    40.245     0.200
    24.067    36.291     0.200
    24.396    35.566     0.200
    24.433    35.424     0.200
    25.778    31.627     0.200
    27.064    28.424     0.200
    27.064    28.927     0.200
    15.189    41.367     0.200
    15.523    42.584     0.200
    16.137    40.251     0.200
    16.100    41.581     0.200
    16.573    41.188     0.200
    17.077    41.997     0.200
    17.313    43.426     0.200
    17.746    43.683     0.200
    18.164    43.724     0.200
    21.554    40.564     0.200
    21.788    37.873     0.200
    21.788    37.451     0.200
    24.415    35.935     0.200
    25.795    32.010     0.200
    26.619    30.947     0.200
    17.145    40.280     0.200
    20.148    37.750     0.200
    25.631    30.605     0.200
    20.326    35.577     0.200
    27.033    26.905     0.200
    16.307    41.662     0.200
    17.332    41.772     0.200
    17.372    41.805     0.200
    17.412    41.706     0.200
    17.425    41.896     0.200
    17.444    41.939     0.200
    17.444    42.040     0.200
    17.593    41.908     0.200
    17.613    41.829     0.200
    17.640    41.828     0.200
    17.640    42.172     0.200
    17.647    41.928     0.200
    17.700    42.187     0.200
    17.949    42.265     0.200
    18.098    42.478     0.200
    18.209    42.192     0.200
    18.209    41.739     0.200
    18.311    43.035     0.200
    18.411    40.854     0.200
    18.587    41.158     0.200
    18.700    40.764     0.200
    18.700    39.873     0.200
    18.654    39.330     0.200
    18.654    40.665     0.200
    18.654    40.673     0.200
    18.844    41.022     0.200
    18.844    40.529     0.200
    18.808    40.716     0.200
    18.842    40.030     0.200
    18.879    41.348     0.200
    19.016    41.440     0.200
    19.016    40.370     0.200
    19.151    41.465     0.200
    19.151    41.152     0.200
    19.168    40.632     0.200
    19.191    40.094     0.200
    19.255    40.112     0.200
    19.255    39.932     0.200
    19.255    39.823     0.200
    19.261    40.648     0.200
    19.376    36.355     0.200
    19.370    41.088     0.200
    19.455    41.119     0.200
    19.455    40.807     0.200
    19.482    36.081     0.200
    19.473    39.095     0.200
    19.522    41.558     0.200
    19.556    36.299     0.200
    19.552    39.105     0.200
    19.552    38.964     0.200
    19.513    39.912     0.200
    19.583    40.561     0.200
    19.703    35.859     0.200
    19.747    36.316     0.200
    19.748    35.996     0.200
    19.831    36.404     0.200
    19.819    40.053     0.200
    20.006    35.566     0.200
    20.009    36.291     0.200
    19.982    40.446     0.200
    20.102    35.786     0.200
    20.128    36.280     0.200
    20.136    35.620     0.200
    20.140    36.527     0.200
    20.140    35.785     0.200
    20.140    35.067     0.200
    20.255    35.455     0.200
    20.271    34.687     0.200
    20.279    36.700     0.200
    20.328    39.739     0.200
    20.328    39.293     0.200
    20.461    35.783     0.200
    20.473    36.744     0.200
    20.479    35.327     0.200
    20.461    40.526     0.200
    20.501    40.537     0.200
    20.501    39.920     0.200
    20.562    35.403     0.200
    20.562    34.926     0.200
    20.710    34.725     0.200
    20.745    34.997     0.200
    20.764    34.649     0.200
    20.777    36.434     0.200
    20.798    35.693     0.200
    20.785    38.662     0.200
    20.792    38.818     0.200
    20.897    34.959     0.200
    20.979    35.583     0.200
    20.960    37.708     0.200
    20.960    39.786     0.200
    20.960    39.357     0.200
    20.995    34.680     0.200
    21.016    35.745     0.200
    20.995    40.241     0.200
    20.995    39.749     0.200
    21.035    34.462     0.200
    21.022    39.497     0.200
    21.062    39.307     0.200
    21.178    34.645     0.200
    21.179    35.449     0.200
    21.266    35.851     0.200
    21.295    33.610     0.200
    21.292    38.772     0.200
    21.336    34.192     0.200
    21.353    34.001     0.200
    21.355    36.542     0.200
    21.355    35.933     0.200
    21.355    39.336     0.200
    21.404    35.054     0.200
    21.391    40.266     0.200
    21.391    39.484     0.200
    21.369    39.662     0.200
    21.369    39.115     0.200
    21.483    39.356     0.200
    21.536    34.178     0.200
    21.562    36.758     0.200
    21.612    33.939     0.200
    21.614    35.303     0.200
    21.660    35.087     0.200
    21.660    34.829     0.200
    21.683    35.024     0.200
    21.726    34.304     0.200
    21.774    36.498     0.200
    21.774    36.084     0.200
    21.816    34.583     0.200
    21.922    33.269     0.200
    21.922    35.326     0.200
    21.943    33.543     0.200
    21.948    35.653     0.200
    21.958    35.591     0.200
    22.020    33.565     0.200
    22.021    34.435     0.200
    22.080    33.830     0.200
    22.151    34.240     0.200
    22.192    38.847     0.200
    22.192    38.652     0.200
    22.287    34.122     0.200
    22.305    35.544     0.200
    22.248    38.946     0.200
    22.348    35.545     0.200
    22.422    33.943     0.200
    22.444    33.871     0.200
    22.472    34.233     0.200
    22.456    38.222     0.200
    22.581    33.098     0.200
    22.577    35.608     0.200
    22.626    33.000     0.200
    22.637    34.387     0.200
    22.662    33.035     0.200
    22.672    33.511     0.200
    22.736    34.710     0.200
    22.740    33.983     0.200
    22.781    33.752     0.200
    22.834    33.503     0.200
    22.853    35.134     0.200
    22.919    33.719     0.200
    23.018    34.119     0.200
    23.061    33.744     0.200
    23.092    32.684     0.200
    23.105    33.963     0.200
    23.110    32.710     0.200
    23.134    34.828     0.200
    23.165    32.238     0.200
    23.236    32.979     0.200
    23.321    32.638     0.200
    23.323    32.944     0.200
    23.329    34.265     0.200
    23.363    35.129     0.200
    23.387    32.303     0.200
    23.446    33.876     0.200
    23.469    32.536     0.200
    23.473    32.341     0.200
    23.473    31.755     0.200
    23.541    33.239     0.200
    23.541    32.379     0.200
    23.566    33.307     0.200
    23.632    35.133     0.200
    23.639    32.610     0.200
    23.657    35.927     0.200
    23.657    35.326     0.200
    23.675    34.658     0.200
    23.683    32.237     0.200
    23.681    33.390     0.200
    23.720    33.574     0.200
    23.700    35.713     0.200
    23.700    35.095     0.200
    23.820    33.924     0.200
    23.807    35.837     0.200
    23.799    35.730     0.200
    23.845    32.684     0.200
    23.856    32.013     0.200
    23.872    33.758     0.200
    23.893    33.178     0.200
    23.914    33.305     0.200
    23.920    34.935     0.200
    24.026    34.393     0.200
    24.026    34.042     0.200
    24.036    32.857     0.200
    24.059    35.393     0.200
    24.059    34.979     0.200
    24.097    32.534     0.200
    24.094    34.188     0.200
    24.140    33.284     0.200
    24.158    33.871     0.200
    24.181    32.030     0.200
    24.187    30.923     0.200
    24.219    34.234     0.200
    24.264    32.946     0.200
    24.153    35.053     0.200
    24.327    31.866     0.200
    24.389    30.433     0.200
    24.380    32.059     0.200
    24.392    35.092     0.200
    24.423    33.224     0.200
    24.501    32.905     0.200
    24.511    31.188     0.200
    24.530    32.817     0.200
    24.546    31.608     0.200
    24.544    33.079     0.200
    24.582    30.452     0.200
    24.583    31.226     0.200
    24.610    32.290     0.200
    24.627    32.634     0.200
    24.641    31.648     0.200
    24.655    32.311     0.200
    24.658    32.495     0.200
    24.608    33.553     0.200
    24.721    32.027     0.200
    24.748    31.835     0.200
    24.741    32.611     0.200
    24.774    32.233     0.200
    24.837    32.278     0.200
    24.865    31.333     0.200
    24.844    33.709     0.200
    24.919    32.303     0.200
    24.934    31.540     0.200
    24.975    32.279     0.200
    25.010    31.693     0.200
    25.028    29.640     0.200
    25.041    31.177     0.200
    25.052    32.114     0.200
    25.181    31.942     0.200
    25.195    31.386     0.200
    25.208    30.796     0.200
    25.222    30.055     0.200
    25.269    31.440     0.200
    25.354    30.628     0.200
    25.409    30.567     0.200
    25.406    31.017     0.200
    25.458    31.292     0.200
    25.458    30.761     0.200
    25.469    30.603     0.200
    25.484    30.707     0.200
    25.510    30.517     0.200
    25.530    30.824     0.200
    25.523    30.223     0.200
    25.612    30.214     0.200
    25.616    30.659     0.200
    25.616    30.527     0.200
    25.645    29.955     0.200
    25.700    29.990     0.200
    25.701    30.036     0.200
    25.701    29.913     0.200
    25.711    29.685     0.200
    25.756    28.705     0.200
    25.837    29.349     0.200
    25.867    28.245     0.200
    25.846    28.536     0.200
    25.907    29.368     0.200
    25.927    29.397     0.200
    25.946    29.395     0.200
    25.945    29.843     0.200
    25.945    29.717     0.200
    26.000    29.049     0.200
    26.016    29.265     0.200
    26.078    29.104     0.200
    26.134    28.657     0.200
    26.184    28.498     0.200
    26.222    28.768     0.200
    26.116    30.839     0.200
    26.217    27.321     0.200
    26.279    28.510     0.200
    26.275    28.655     0.200
    26.278    28.401     0.200
    26.288    28.434     0.200
    26.295    28.571     0.200
    26.326    28.397     0.200
    26.381    28.027     0.200
    26.413    27.898     0.200
    26.460    27.895     0.200
    26.460    27.770     0.200
    26.481    28.019     0.200
    26.493    28.087     0.200
    26.493    27.392     0.200
    26.487    27.594     0.200
    26.505    27.958     0.200
    26.598    27.872     0.200
    26.611    26.583     0.200
    26.607    27.697     0.200
    26.529    29.077     0.200
    26.711    27.207     0.200
    26.726    26.987     0.200
    26.723    27.704     0.200
    26.730    27.666     0.200
    26.759    26.715     0.200
    26.774    27.273     0.200
    26.836    27.970     0.200
    26.860    26.939     0.200
    26.836    28.079     0.200
    26.915    26.817     0.200
    26.926    26.379     0.200
    26.943    26.406     0.200
    26.991    26.136     0.200
    27.034    26.793     0.200
    27.034    26.783     0.200
    27.074    26.886     0.200
    27.152    26.202     0.200
    27.174    24.684     0.200
    27.199    25.702     0.200
    27.219    26.577     0.200
    27.266    25.203     0.200
    27.272    25.788     0.200
    27.309    25.848     0.200
    27.333    25.634     0.200
    27.330    25.579     0.200
    27.347    25.717     0.200
    27.385    25.526     0.200
    27.413    25.309     0.200
    27.522    24.573     0.200
    27.531    25.739     0.200
    27.558    24.953     0.200
    27.620    25.656     0.200
    27.631    24.749     0.200
    27.639    24.761     0.200
    27.778    24.282     0.200
    27.786    24.130     0.200
    27.780    24.195     0.200
    27.828    25.131     0.200
    27.834    23.630     0.200
    27.750    26.056     0.200
    27.877    24.404     0.200
    27.877    24.486     0.200
    27.879    25.133     0.200
    27.878    25.668     0.200
    27.900    24.981     0.200
    27.956    23.815     0.200
    27.978    23.738     0.200
    28.012    22.963     0.200
    28.033    23.843     0.200
    28.052    23.608     0.200
    28.084    23.476     0.200
    28.165    22.666     0.200
    28.184    23.046     0.200
    28.203    23.689     0.200
    28.221    22.669     0.200
    28.216    22.802     0.200
    28.291    23.082     0.200
    28.324    22.141     0.200
    28.380    22.469     0.200
    28.381    22.793     0.200
    28.416    22.645     0.200
    28.415    22.722     0.200
    28.447    23.084     0.200
    28.457    23.006     0.200
    28.516    21.398     0.200
    28.478    23.841     0.200
    28.558    22.396     0.200
    28.584    21.831     0.200
    28.651    21.788     0.200
    28.651    22.545     0.200
    28.734    21.533     0.200
    28.720    22.018     0.200
    28.715    21.690     0.200
    28.719    21.871     0.200
    28.756    22.571     0.200
    28.756    21.977     0.200
    28.761    20.533     0.200
    28.755    22.206     0.200
    28.757    22.354     0.200
    28.781    21.091     0.200
    28.782    21.455     0.200
    28.782    20.783     0.200
    28.782    21.580     0.200
    28.782    19.767     0.200
    28.841    22.281     0.200
    28.849    21.414     0.200
    28.970    21.060     0.200
    28.980    20.730     0.200
    28.998    21.261     0.200
    29.021    20.720     0.200
    29.070    21.780     0.200
    29.041    20.697     0.200
    29.061    20.447     0.200
    29.080    20.067     0.200
    29.079    20.301     0.200
    29.094    20.023     0.200
    29.111    21.545     0.200
    29.108    20.526     0.200
    29.146    21.127     0.200
    29.179    20.790     0.200
    29.246    19.265     0.200
    29.256    20.404     0.200
    29.258    21.049     0.200
    29.293    20.598     0.200
    29.321    19.561     0.200
    29.337    18.738     0.200
    29.347    19.351     0.200
    29.375    20.142     0.200
    29.451    20.090     0.200
    29.461    19.681     0.200
    29.482    19.886     0.200
    29.482    19.526     0.200
    29.518    20.374     0.200
    29.553    19.068     0.200
    29.554    20.603     0.200
    29.463    20.299     0.200
    29.572    19.274     0.200
    29.570    19.472     0.200
    29.600    18.323     0.200
    29.593    20.210     0.200
    29.597    19.788     0.200
    29.614    19.832     0.200
    29.620    19.522     0.200
    29.624    19.159     0.200
    29.656    19.022     0.200
    29.693    18.108     0.200
    29.712    18.571     0.200
    29.726    20.193     0.200
    29.795    19.539     0.200
    29.799    19.803     0.200
    29.823    19.347     0.200
    29.841    17.673     0.200
    29.871    17.861     0.200
    29.877    19.206     0.200
    29.903    19.181     0.200
    29.923    18.990     0.200
    29.933    19.126     0.200
    29.943    17.622     0.200
    29.942    18.978     0.200
    29.969    18.962     0.200
    29.979    17.219     0.200
    29.998    17.790     0.200
    20.190    36.955     0.200
    26.837    29.579     0.200
    20.122    37.156     0.200
    26.829    29.109     0.200
    26.822    28.933     0.200
    15.981    41.720     0.200
    16.054    42.270     0.200
    16.211    41.118     0.200
    16.170    40.882     0.200
    16.979    43.546     0.200
    17.447    42.176     0.200
    17.518    42.179     0.200
    21.849    38.246     0.200
    24.209    35.730     0.200
    18.609    34.966     0.200
    20.374    36.236     0.200
    20.374    33.986     0.200
    27.140    27.468     0.200
    14.917    38.261     0.200
    14.938    38.124     0.200
    14.974    37.905     0.200
    16.195    39.087     0.200
    16.815    38.605     0.200
    16.940    38.675     0.200
    16.908    40.199     0.200
    17.018    40.513     0.200
    17.018    38.936     0.200
    17.025    38.927     0.200
    17.166    39.393     0.200
    17.251    39.215     0.200
    17.300    39.959     0.200
    17.700    38.904     0.200
    17.740    40.084     0.200
    17.805    40.191     0.200
    18.056    40.406     0.200
    18.543    37.742     0.200
    18.597    37.487     0.200
    18.597    36.843     0.200
    18.880    36.178     0.200
    19.023    37.795     0.200
    19.255    37.578     0.200
    19.277    34.031     0.200
    19.277    33.451     0.200
    19.386    37.246     0.200
    19.446    36.281     0.200
    19.457    37.430     0.200
    19.587    37.805     0.200
    19.571    38.074     0.200
    19.571    37.509     0.200
    19.971    37.656     0.200
    20.094    36.618     0.200
    20.114    37.390     0.200
    20.187    36.825     0.200
    20.241    36.342     0.200
    20.244    35.749     0.200
    20.244    36.329     0.200
    20.443    36.261     0.200
    20.630    35.298     0.200
    20.709    33.243     0.200
    20.709    33.028     0.200
    20.742    32.214     0.200
    20.744    32.631     0.200
    20.744    33.111     0.200
    20.878    35.217     0.200
    21.277    35.249     0.200
    21.277    35.435     0.200
    21.378    38.473     0.200
    21.528    36.189     0.200
    21.618    34.947     0.200
    21.680    34.571     0.200
    21.722    31.177     0.200
    21.940    37.184     0.200
    21.974    33.527     0.200
    22.152    34.331     0.200
    22.286    30.373     0.200
    22.563    29.784     0.200
    22.580    30.694     0.200
    22.611    31.144     0.200
    22.716    33.115     0.200
    22.743    34.501     0.200
    22.743    34.105     0.200
    22.777    36.548     0.200
    22.777    34.339     0.200
    22.805    34.365     0.200
    22.805    33.683     0.200
    23.068    33.655     0.200
    23.219    33.120     0.200
    23.735    29.751     0.200
    24.527    30.787     0.200
    25.017    27.441     0.200
    25.242    27.904     0.200
    25.242    26.832     0.200
    25.383    27.296     0.200
    25.544    27.855     0.200
    25.544    27.330     0.200
    25.550    28.159     0.200
    25.550    27.929     0.200
    25.693    26.974     0.200
    25.753    27.234     0.200
    25.907    26.687     0.200
    25.984    26.728     0.200
    25.998    26.215     0.200
    25.999    28.125     0.200
    26.044    26.019     0.200
    26.079    26.568     0.200
    26.307    25.322     0.200
    26.389    27.086     0.200
    26.458    25.441     0.200
    26.977    23.501     0.200
    27.051    23.100     0.200
    27.087    24.060     0.200
    27.087    23.936     0.200
    27.095    23.666     0.200
    27.095    22.961     0.200
    27.101    24.058     0.200
    27.101    22.894     0.200
    27.250    23.706     0.200
    27.250    23.154     0.200
    27.336    23.199     0.200
    27.406    21.935     0.200
    27.670    21.455     0.200
    27.753    20.942     0.200
    27.806    22.066     0.200
    27.806    21.833     0.200
    27.803    20.949     0.200
    27.847    20.696     0.200
    28.065    21.207     0.200
    28.223    20.870     0.200
    28.304    19.794     0.200
    28.349    19.835     0.200
    28.378    19.713     0.200
    28.533    18.527     0.200
    28.594    18.723     0.200
    28.606    18.773     0.200
    28.665    19.637     0.200
    28.691    19.651     0.200
    28.691    19.356     0.200
    28.756    18.454     0.200
    29.382    16.534     0.200
    29.546    15.787     0.200
    20.422    35.238     0.200
    20.442    34.401     0.200
    25.770    28.817     0.200
    16.301    38.224     0.200
    16.301    40.216     0.200
    16.639    38.228     0.200
    17.184    37.894     0.200
    18.785    36.706     0.200
    19.097    35.667     0.200
    19.097    35.479     0.200
    19.164    36.838     0.200
    19.413    35.539     0.200
    19.413    36.203     0.200
    19.430    37.454     0.200
    19.430    39.478     0.200
    19.532    41.635     0.200
    20.313    35.287     0.200
    20.313    36.896     0.200
    20.346    35.880     0.200
    20.549    33.282     0.200
    20.873    34.001     0.200
    21.018    36.970     0.200
    21.346    36.239     0.200
    22.259    33.096     0.200
    22.343    31.544     0.200
    22.343    32.012     0.200
    22.540    34.806     0.200
    22.540    36.619     0.200
    22.572    35.171     0.200
    22.760    34.748     0.200
    23.253    32.614     0.200
    23.477    34.626     0.200
    23.529    30.590     0.200
    23.935    33.715     0.200
    24.175    31.469     0.200
    24.212    31.622     0.200
    25.318    28.677     0.200
    25.318    31.020     0.200
    26.484    24.712     0.200
    26.600    24.300     0.200
    26.633    24.365     0.200
    26.633    25.967     0.200
    27.261    24.844     0.200
    29.717    15.642     0.200
    29.793    16.601     0.200
    17.265    38.598     0.200
    17.265    39.407     0.200
    17.265    38.917     0.200
    17.331    39.960     0.200
    17.553    39.031     0.200
    17.564    41.562     0.200
    17.633    38.723     0.200
    18.144    38.885     0.200
    18.956    37.634     0.200
    18.937    39.508     0.200
    19.009    37.096     0.200
    19.009    38.606     0.200
    19.232    35.743     0.200
    19.427    37.343     0.200
    19.426    38.083     0.200
    19.426    37.583     0.200
    19.426    37.903     0.200
    19.419    39.163     0.200
    19.587    34.076     0.200
    19.587    34.231     0.200
    19.587    34.752     0.200
    19.595    37.142     0.200
    19.734    37.618     0.200
    19.742    37.492     0.200
    19.989    34.110     0.200
    19.989    35.749     0.200
    19.919    38.655     0.200
    20.062    38.947     0.200
    20.426    37.392     0.200
    20.426    37.818     0.200
    20.447    36.909     0.200
    20.535    37.105     0.200
    20.951    33.992     0.200
    20.955    37.347     0.200
    21.055    33.099     0.200
    21.060    33.240     0.200
    21.060    33.620     0.200
    21.172    35.514     0.200
    21.296    37.064     0.200
    21.477    37.389     0.200
    21.634    35.382     0.200
    21.693    36.672     0.200
    21.705    37.389     0.200
    21.865    35.950     0.200
    21.984    36.087     0.200
    22.035    34.265     0.200
    22.073    34.183     0.200
    22.510    34.176     0.200
    22.553    35.999     0.200
    22.557    35.285     0.200
    23.073    32.913     0.200
    23.090    34.021     0.200
    23.171    33.274     0.200
    23.370    32.555     0.200
    23.426    33.182     0.200
    23.439    33.256     0.200
    23.543    34.492     0.200
    23.543    33.723     0.200
    23.765    32.610     0.200
    24.088    33.254     0.200
    24.674    30.878     0.200
    24.872    30.229     0.200
    24.880    30.740     0.200
    24.880    30.130     0.200
    25.511    28.687     0.200
    25.588    28.089     0.200
    26.317    27.717     0.200
    26.321    26.888     0.200
    26.321    27.168     0.200
    26.322    27.635     0.200
    26.322    26.870     0.200
    27.400    25.627     0.200
    27.400    22.927     0.200
    27.400    25.777     0.200
    27.458    23.256     0.200
    27.458    22.497     0.200
    28.163    22.132     0.200
    28.707    19.036     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     0.980     4.984     0.200
     1.424     6.296     0.200
     1.576     6.411     0.200
     1.609     7.226     0.200
     1.703     6.833     0.200
     1.813     8.049     0.200
     1.923     8.229     0.200
     2.019     7.887     0.200
     2.101     7.601     0.200
     2.307     8.425     0.200
     2.555     9.461     0.200
     2.535     9.327     0.200
     2.683     9.946     0.200
     2.718     9.813     0.200
     2.782    10.246     0.200
     2.952     9.564     0.200
     2.932    10.120     0.200
     3.036    10.848     0.200
     3.119    10.558     0.200
     3.162    10.012     0.200
     3.183    10.773     0.200
     3.390    12.110     0.200
     3.490    11.447     0.200
     3.488    12.515     0.200
     3.506    11.942     0.200
     3.616    11.993     0.200
     3.530    12.812     0.200
     3.713    12.585     0.200
     3.804    12.099     0.200
     4.049    12.855     0.200
     4.355    14.390     0.200
     4.315    13.157     0.200
     4.679    16.103     0.200
     4.758    15.384     0.200
     4.792    12.992     0.200
     4.878    13.282     0.200
     5.430    15.742     0.200
     5.524    15.743     0.200
     5.637    15.725     0.200
     5.884    17.851     0.200
     5.856    15.877     0.200
     5.977    19.054     0.200
     6.826    20.249     0.200
     7.171    18.919     0.200
     8.131    22.819     0.200
     8.679    26.627     0.200
     8.768    27.585     0.200
     9.136    25.399     0.200
     9.199    23.354     0.200
     9.260    28.642     0.200
     9.503    26.617     0.200
     9.762    30.192     0.200
    10.050    25.820     0.200
    10.023    27.048     0.200
    10.515    30.996     0.200
    10.937    27.276     0.200
    11.166    31.598     0.200
    11.872    32.865     0.200
    11.876    33.020     0.200
    12.198    34.666     0.200
    12.255    33.091     0.200
    12.555    34.899     0.200
    12.753    33.584     0.200
    13.029    34.759     0.200
    13.129    34.500     0.200
    13.384    36.715     0.200
    13.403    35.701     0.200
    13.425    34.935     0.200
    13.557    35.198     0.200
    13.881    36.424     0.200
    14.199    35.905     0.200
    15.112    34.249     0.200
    15.043    37.356     0.200
    15.213    38.373     0.200
    15.436    37.074     0.200
    15.631    39.494     0.200
    15.963    39.620     0.200
    16.148    39.459     0.200
    16.304    38.938     0.200
    16.494    39.422     0.200
    16.527    39.045     0.200
    16.601    39.675     0.200
    16.934    40.296     0.200
    16.992    39.017     0.200
    17.340    39.554     0.200
    17.691    41.451     0.200
    18.369    41.540     0.200
    18.544    40.504     0.200
    18.606    41.273     0.200
    18.712    41.546     0.200
     1.387     6.433     0.200
     1.406     6.084     0.200
     1.829     7.009     0.200
     1.944     6.805     0.200
     2.120     8.388     0.200
     2.372     8.836     0.200
     2.467     8.999     0.200
     2.657     9.059     0.200
     2.753     8.378     0.200
     2.754     9.468     0.200
     2.826     9.712     0.200
     2.819     9.741     0.200
     2.849    10.401     0.200
     2.904    10.556     0.200
     2.967     9.776     0.200
     2.930    10.928     0.200
     3.192    12.019     0.200
     3.211    10.635     0.200
     3.177    11.863     0.200
     3.335    10.777     0.200
     3.632    12.039     0.200
     3.733    12.531     0.200
     3.797    13.027     0.200
     3.920    12.495     0.200
     4.073    11.756     0.200
     4.282    13.027     0.200
     4.412    15.105     0.200
     4.625    14.778     0.200
     4.647    14.015     0.200
     4.636    15.137     0.200
     4.672    15.104     0.200
     4.742    15.847     0.200
     4.766    15.288     0.200
     4.764    15.723     0.200
     4.783    15.924     0.200
     4.807    16.493     0.200
     4.807    16.430     0.200
     4.840    16.182     0.200
     4.868    16.140     0.200
     4.741    14.150     0.200
     4.892    15.889     0.200
     4.915    16.489     0.200
     4.996    16.715     0.200
     5.146    16.620     0.200
     5.131    16.774     0.200
     5.239    15.684     0.200
     5.222    17.164     0.200
     5.286    16.927     0.200
     5.277    17.480     0.200
     5.337    16.404     0.200
     5.553    18.314     0.200
     5.624    18.615     0.200
     5.688    16.828     0.200
     5.689    16.658     0.200
     5.654    17.387     0.200
     5.762    18.641     0.200
     5.915    17.556     0.200
     5.891    18.891     0.200
     5.964    17.300     0.200
     6.103    17.699     0.200
     6.408    17.326     0.200
     7.014    19.669     0.200
     7.175    19.206     0.200
     7.253    24.647     0.200
     7.898    25.707     0.200
     8.293    26.358     0.200
     8.990    24.411     0.200
     9.289    27.321     0.200
    10.755    28.644     0.200
    10.821    27.945     0.200
    11.508    32.328     0.200
    12.800    35.444     0.200
    13.617    33.298     0.200
    13.879    35.267     0.200
    14.122    35.691     0.200
    15.384    37.836     0.200
    15.450    36.617     0.200
    18.606    41.489     0.200
    19.315    40.822     0.200
    20.456    38.202     0.200
     1.364     6.884     0.200
     1.367     7.127     0.200
     1.449     6.507     0.200
     1.471     7.224     0.200
     1.558     7.561     0.200
     1.570     7.259     0.200
     1.620     7.247     0.200
     1.740     8.494     0.200
     1.693     7.964     0.200
     1.727     6.968     0.200
     1.741     7.741     0.200
     1.806     8.081     0.200
     1.925     8.504     0.200
     1.913     8.099     0.200
     2.021     8.769     0.200
     2.030     8.655     0.200
     2.059     8.825     0.200
     2.182     8.904     0.200
     2.158     8.867     0.200
     2.182     8.740     0.200
     2.267     9.165     0.200
     2.263     8.845     0.200
     2.272     9.338     0.200
     2.294     9.308     0.200
     2.360     9.743     0.200
     2.452     8.985     0.200
     2.529    10.251     0.200
     2.520    10.538     0.200
     2.516     9.533     0.200
     2.647    10.770     0.200
     2.682    10.368     0.200
     2.686    10.211     0.200
     2.712    10.445     0.200
     2.841    10.232     0.200
     2.890    10.754     0.200
     2.918    11.189     0.200
     2.997    11.823     0.200
     3.122    11.306     0.200
     3.158    11.599     0.200
     3.252    12.321     0.200
     3.202    11.127     0.200
     3.305    11.887     0.200
     3.360    12.123     0.200
     3.375    11.882     0.200
     3.450    12.529     0.200
     3.449    11.618     0.200
     3.507    13.017     0.200
     3.518    12.890     0.200
     3.517    13.060     0.200
     3.518    13.023     0.200
     3.547    13.330     0.200
     3.641    13.342     0.200
     3.653    13.796     0.200
     3.711    14.088     0.200
     3.796    12.757     0.200
     3.864    13.924     0.200
     3.874    13.175     0.200
     4.184    13.645     0.200
     4.457    15.279     0.200
     4.484    15.728     0.200
     4.873    15.470     0.200
     5.198    15.690     0.200
     5.500    19.531     0.200
     5.849    17.035     0.200
     5.885    17.887     0.200
     7.291    24.686     0.200
     8.047    25.519     0.200
     8.432    26.646     0.200
     9.464    26.563     0.200
     9.577    25.490     0.200
     9.686    25.241     0.200
     9.650    30.194     0.200
     9.943    26.497     0.200
    10.089    30.887     0.200
    10.957    31.802     0.200
    11.077    32.028     0.200
    11.099    31.101     0.200
    11.614    34.560     0.200
    11.664    33.867     0.200
    11.899    32.362     0.200
    12.326    34.296     0.200
    13.292    36.049     0.200
    13.671    37.881     0.200
    14.174    37.801     0.200
    14.185    37.740     0.200
    15.217    34.466     0.200
    19.661    41.459     0.200
    19.915    42.239     0.200
    20.065    39.647     0.200
    20.392    41.001     0.200
     0.302     4.272     0.200
     0.279     4.686     0.200
     0.409     4.443     0.200
     0.744     4.805     0.200
     0.726     5.063     0.200
     0.740     4.584     0.200
     0.888     5.222     0.200
     0.918     5.712     0.200
     1.072     5.622     0.200
     1.133     5.738     0.200
     1.129     6.160     0.200
     1.427     6.522     0.200
     1.451     6.223     0.200
     1.484     6.577     0.200
     1.473     6.915     0.200
     1.722     7.234     0.200
     1.811     7.994     0.200
     1.856     7.078     0.200
     1.844     7.860     0.200
     1.920     7.785     0.200
     1.962     7.611     0.200
     1.998     7.952     0.200
     2.081     9.702     0.200
     2.116     7.850     0.200
     2.150     7.765     0.200
     2.177     8.462     0.200
     2.183     8.592     0.200
     2.325     9.013     0.200
     2.342     8.491     0.200
     2.327     8.874     0.200
     2.460     8.894     0.200
     2.541     9.904     0.200
     2.572     9.745     0.200
     2.644     9.256     0.200
     2.690     9.118     0.200
     2.759     9.888     0.200
     2.861    11.058     0.200
     2.877    10.276     0.200
     2.865     9.969     0.200
     2.930    10.074     0.200
     2.970    10.236     0.200
     2.961    10.277     0.200
     2.973     9.547     0.200
     3.073    10.783     0.200
     3.068    10.545     0.200
     3.236    12.033     0.200
     3.270    11.914     0.200
     3.357    11.811     0.200
     3.531    12.222     0.200
     3.645    12.137     0.200
     3.696    12.408     0.200
     3.853    13.045     0.200
     3.930    13.021     0.200
     3.937    12.585     0.200
     3.949    13.343     0.200
     3.994    12.831     0.200
     3.994    13.683     0.200
     4.052    13.361     0.200
     4.092    13.492     0.200
     4.086    13.030     0.200
     4.104    13.347     0.200
     4.159    13.891     0.200
     4.170    13.469     0.200
     4.190    14.063     0.200
     4.268    12.579     0.200
     4.250    13.858     0.200
     4.253    14.554     0.200
     4.259    14.162     0.200
     4.254    12.861     0.200
     4.299    14.196     0.200
     4.369    15.084     0.200
     4.365    14.573     0.200
     4.506    14.788     0.200
     4.536    14.873     0.200
     4.696    12.793     0.200
     4.834    16.303     0.200
     4.893    13.297     0.200
     5.074    15.080     0.200
     5.138    16.175     0.200
     5.169    13.514     0.200
     5.277    15.185     0.200
     5.272    16.543     0.200
     5.293    16.068     0.200
     5.401    15.826     0.200
     5.388    16.632     0.200
     5.417    15.670     0.200
     5.408    17.633     0.200
     5.506    15.762     0.200
     5.498    14.054     0.200
     5.617    16.552     0.200
     6.079    16.644     0.200
     6.149    16.010     0.200
     6.326    19.898     0.200
     7.004    19.954     0.200
     8.017    21.937     0.200
     8.122    25.468     0.200
     8.616    25.894     0.200
     8.781    26.465     0.200
     8.991    22.195     0.200
     9.251    26.577     0.200
     9.266    27.777     0.200
     9.357    24.614     0.200
     9.602    24.884     0.200
     9.863    29.231     0.200
     9.942    24.912     0.200
     9.974    24.420     0.200
     9.970    29.632     0.200
    10.020    27.553     0.200
    10.557    25.810     0.200
    10.682    29.911     0.200
    10.721    30.636     0.200
    11.047    28.076     0.200
    11.037    31.035     0.200
    11.256    31.569     0.200
    11.601    30.230     0.200
    12.111    34.420     0.200
    12.178    32.479     0.200
    12.203    35.402     0.200
    12.247    33.791     0.200
    12.407    34.378     0.200
    12.437    35.642     0.200
    12.453    34.239     0.200
    13.057    33.332     0.200
    13.093    34.855     0.200
    13.169    34.001     0.200
    13.312    34.396     0.200
    13.313    33.680     0.200
    13.890    35.218     0.200
    14.445    36.510     0.200
    14.844    36.241     0.200
    14.854    36.551     0.200
    16.064    37.133     0.200
    18.835    38.511     0.200
    18.856    38.844     0.200
    19.228    38.274     0.200
    19.225    40.204     0.200
    20.499    38.103     0.200
     0.238     3.471     0.200
     0.344     3.412     0.200
     0.613     3.793     0.200
     0.632     3.956     0.200
     0.758     4.308     0.200
     0.779     5.235     0.200
     0.883     5.010     0.200
     0.877     4.776     0.200
     0.895     4.994     0.200
     0.947     5.191     0.200
     0.994     4.476     0.200
     0.995     5.939     0.200
     1.003     6.029     0.200
     1.061     5.267     0.200
     1.067     5.604     0.200
     1.108     4.949     0.200
     1.104     6.119     0.200
     1.220     5.957     0.200
     1.287     6.080     0.200
     1.292     6.071     0.200
     1.277     6.297     0.200
     1.368     6.216     0.200
     1.365     6.018     0.200
     1.393     6.434     0.200
     1.431     6.599     0.200
     1.427     6.451     0.200
     1.467     6.607     0.200
     1.528     7.163     0.200
     1.533     6.981     0.200
     1.571     7.575     0.200
     1.650     7.271     0.200
     1.678     7.617     0.200
     1.705     7.074     0.200
     1.780     8.033     0.200
     1.801     7.516     0.200
     1.907     8.211     0.200
     1.906     7.923     0.200
     1.889     7.765     0.200
     1.935     8.352     0.200
     1.950     7.771     0.200
     1.959     7.965     0.200
     2.016     7.800     0.200
     2.043     8.776     0.200
     2.176     8.540     0.200
     2.184     8.465     0.200
     2.278     8.712     0.200
     2.325     8.872     0.200
     2.342     9.090     0.200
     2.434     8.967     0.200
     2.478     9.427     0.200
     2.709    10.066     0.200
     2.679    10.062     0.200
     2.713     9.606     0.200
     2.704     9.949     0.200
     2.746     9.546     0.200
     2.767     9.939     0.200
     2.876    10.190     0.200
     2.888    10.702     0.200
     2.933    11.070     0.200
     2.948    10.190     0.200
     2.963    10.675     0.200
     3.007    10.868     0.200
     3.015    11.250     0.200
     3.051    11.134     0.200
     3.312    12.033     0.200
     3.459    12.047     0.200
     3.639    13.159     0.200
     4.124    12.156     0.200
     4.213    11.502     0.200
     4.200    12.168     0.200
     4.900    14.648     0.200
     4.940    14.356     0.200
     4.970    14.763     0.200
     5.106    15.114     0.200
     5.405    16.159     0.200
     5.832    16.880     0.200
     7.955    19.484     0.200
    11.247    32.859     0.200
    12.151    31.043     0.200
    20.013    38.388     0.200
    20.187    37.676     0.200
     0.238     3.669     0.200
     0.451     3.890     0.200
     0.682     4.110     0.200
     0.744     4.344     0.200
     0.732     4.140     0.200
     1.015     5.574     0.200
     1.036     5.025     0.200
     1.036     4.861     0.200
     1.105     5.875     0.200
     1.203     5.840     0.200
     1.203     6.258     0.200
     1.351     6.944     0.200
     1.380     6.593     0.200
     1.393     6.160     0.200
     1.548     6.790     0.200
     1.618     6.115     0.200
     1.603     7.191     0.200
     1.683     6.965     0.200
     1.694     7.244     0.200
     1.677     6.960     0.200
     1.710     6.537     0.200
     1.710     6.982     0.200
     1.770     7.919     0.200
     1.770     7.513     0.200
     1.775     6.641     0.200
     1.807     7.660     0.200
     1.879     8.117     0.200
     1.949     7.986     0.200
     2.009     8.477     0.200
     2.137     8.178     0.200
     2.176     8.244     0.200
     2.324     8.389     0.200
     2.445     8.957     0.200
     2.531     9.838     0.200
     2.600     9.943     0.200
     2.723    10.189     0.200
     2.902    10.240     0.200
     2.914    10.437     0.200
     2.982    10.768     0.200
     3.124     8.305     0.200
     3.450    11.212     0.200
     3.507    11.924     0.200
     3.553    11.581     0.200
     3.771    12.099     0.200
     3.782    13.727     0.200
    18.535    38.266     0.200
     1.508     7.142     0.200
     1.510     7.564     0.200
     1.638     8.450     0.200
     1.780     8.720     0.200
     2.053     8.052     0.200
     2.246     9.604     0.200
     2.498    10.188     0.200
     2.590    10.160     0.200
     2.738    10.643     0.200
     2.832    11.823     0.200
     2.822    10.596     0.200
     2.946    10.384     0.200
     2.923    11.004     0.200
     2.976    10.457     0.200
     3.027    11.267     0.200
     3.080    12.582     0.200
     3.296    12.279     0.200
     3.420    12.676     0.200
     3.746    13.235     0.200
     3.705    13.659     0.200
     3.836    14.082     0.200
     4.069    14.123     0.200
     4.177    14.494     0.200
     4.124    14.635     0.200
     4.222    14.716     0.200
     4.368    13.817     0.200
     4.493    16.971     0.200
     4.635    14.162     0.200
     4.725    14.077     0.200
     4.694    16.016     0.200
     4.719    16.457     0.200
     4.793    16.643     0.200
     4.761    16.268     0.200
     4.823    16.107     0.200
     4.864    17.747     0.200
     4.897    17.424     0.200
     5.076    15.691     0.200
     5.234    17.874     0.200
     5.337    16.082     0.200
     5.358    16.637     0.200
     5.687    18.348     0.200
     5.604    19.683     0.200
     5.723    16.419     0.200
     5.672    19.921     0.200
     5.784    17.757     0.200
     5.813    19.840     0.200
     6.038    21.081     0.200
     6.369    18.852     0.200
     6.513    18.343     0.200
     6.682    20.891     0.200
     7.125    21.116     0.200
     7.125    20.749     0.200
     7.257    20.827     0.200
     7.655    22.987     0.200
     9.109    25.462     0.200
     9.330    25.941     0.200
     9.330    27.265     0.200
     9.909    26.188     0.200
    10.009    26.266     0.200
    10.088    26.935     0.200
    10.863    33.358     0.200
    11.283    29.452     0.200
    11.243    32.465     0.200
    11.461    34.330     0.200
    11.547    33.643     0.200
    11.998    32.334     0.200
    12.156    33.026     0.200
    12.767    36.926     0.200
    12.822    36.143     0.200
    13.378    34.915     0.200
    13.501    37.425     0.200
    13.941    36.240     0.200
    14.096    36.978     0.200
    14.650    38.298     0.200
    15.231    34.472     0.200
    15.495    39.038     0.200
    15.507    39.611     0.200
    17.296    40.924     0.200
    18.505    41.950     0.200
    18.606    41.366     0.200
    19.357    40.391     0.200
     1.245     7.250     0.200
     1.434     6.320     0.200
     1.508     7.215     0.200
     1.528     7.654     0.200
     1.556     7.484     0.200
     2.072     8.220     0.200
     2.263     9.700     0.200
     2.516    10.529     0.200
     2.608    10.510     0.200
     2.710    10.871     0.200
     2.850    12.143     0.200
     2.972    10.656     0.200
     2.972    10.476     0.200
     2.964    11.358     0.200
     2.839    11.809     0.200
     2.941    11.642     0.200
     2.941    11.310     0.200
     3.044    11.495     0.200
     3.098    13.240     0.200
     3.312    13.067     0.200
     3.438    12.518     0.200
     3.764    13.364     0.200
     4.085    14.394     0.200
     4.195    14.558     0.200
     4.177    14.117     0.200
     4.241    14.552     0.200
     4.626    13.836     0.200
     4.713    14.861     0.200
     4.737    16.580     0.200
     5.005    14.875     0.200
     5.094    15.377     0.200
     5.329    16.576     0.200
     5.376    16.359     0.200
     5.691    18.767     0.200
     5.711    16.763     0.200
     6.385    18.827     0.200
     6.696    21.067     0.200
     7.144    21.257     0.200
     7.144    20.698     0.200
     8.306    27.545     0.200
     8.834    27.801     0.200
     9.127    24.987     0.200
     9.019    28.969     0.200
     9.324    27.505     0.200
     9.324    27.931     0.200
     9.324    26.091     0.200
     9.335    29.019     0.200
    10.090    26.987     0.200
    10.758    32.405     0.200
    10.874    32.756     0.200
    11.256    34.459     0.200
    11.474    34.170     0.200
    11.562    34.583     0.200
    12.836    35.923     0.200
    14.229    36.065     0.200
    14.229    38.098     0.200
    15.236    34.809     0.200
    15.236    34.602     0.200
    16.137    38.829     0.200
    18.595    41.091     0.200
    18.951    42.471     0.200
    19.352    43.001     0.200
    19.769    42.496     0.200
    20.599    39.155     0.200
     1.165     6.189     0.200
     1.283     6.613     0.200
     1.392     6.670     0.200
     1.628     7.601     0.200
     1.770     7.732     0.200
     1.886     8.138     0.200
     2.181     9.558     0.200
     2.242    10.201     0.200
     2.676    10.035     0.200
     2.657    11.419     0.200
     2.680     8.964     0.200
     2.794    10.455     0.200
     2.924    11.621     0.200
     3.435    12.788     0.200
     3.522    12.473     0.200
     3.569    13.975     0.200
     3.612    13.744     0.200
     3.844    14.036     0.200
     4.164    14.747     0.200
     4.210    13.659     0.200
     4.560    14.196     0.200
     4.722    14.127     0.200
     5.031    14.857     0.200
     5.718    16.436     0.200
     5.654    17.761     0.200
     6.050    16.985     0.200
     6.233    18.025     0.200
     7.475    22.212     0.200
     8.355    26.398     0.200
    10.650    28.392     0.200
    15.394    37.719     0.200
    17.575    38.080     0.200
    19.571    40.858     0.200
     1.113     5.548     0.200
     1.177     6.164     0.200
     1.259     5.678     0.200
     1.280     6.110     0.200
     1.318     6.266     0.200
     1.583     6.702     0.200
     1.735     6.836     0.200
     1.826     7.506     0.200
     2.135     8.843     0.200
     2.185     9.780     0.200
     2.625     8.914     0.200
     2.677    10.359     0.200
     2.744     9.480     0.200
     2.744     9.879     0.200
     2.857    11.454     0.200
     3.389    12.273     0.200
     3.509    12.735     0.200
     3.618    13.553     0.200
     3.790    13.542     0.200
     4.198    12.603     0.200
     4.529    13.333     0.200
     4.554    14.658     0.200
     5.017    13.552     0.200
     5.699    15.653     0.200
     6.778    19.376     0.200
     7.507    21.062     0.200
     8.389    28.197     0.200
    10.634    26.609     0.200
    12.788    36.023     0.200
    13.964    34.905     0.200
    15.382    34.307     0.200
    18.519    41.287     0.200
     0.731     4.298     0.200
     0.811     4.777     0.200
     0.825     4.264     0.200
     0.824     4.681     0.200
     0.911     5.135     0.200
     1.061     5.787     0.200
     1.142     5.813     0.200
     1.229     5.526     0.200
     1.237     6.068     0.200
     1.246     6.072     0.200
     1.315     6.577     0.200
     1.357     6.080     0.200
     1.357     6.252     0.200
     1.360     6.345     0.200
     1.384     6.774     0.200
     1.431     6.181     0.200
     1.459     6.914     0.200
     1.474     5.942     0.200
     1.474     6.270     0.200
     1.506     7.494     0.200
     1.536     6.116     0.200
     1.566     6.887     0.200
     1.582     5.934     0.200
     1.608     7.214     0.200
     1.632     6.750     0.200
     1.662     7.327     0.200
     1.726     7.713     0.200
     1.758     8.079     0.200
     1.884     7.909     0.200
     1.898     8.194     0.200
     1.919     7.678     0.200
     1.994     8.143     0.200
     2.010     7.940     0.200
     2.026     7.320     0.200
     2.028     7.853     0.200
     2.129     8.450     0.200
     2.319     9.710     0.200
     2.341     8.948     0.200
     2.387     9.076     0.200
     2.406     8.539     0.200
     2.502    10.210     0.200
     2.542     8.882     0.200
     2.538     9.670     0.200
     2.749     9.903     0.200
     2.772    10.673     0.200
     2.832    10.231     0.200
     2.862    10.674     0.200
     2.892    10.402     0.200
     3.033    10.984     0.200
     3.141    11.414     0.200
     3.208    11.010     0.200
     3.345    11.630     0.200
     3.742    12.986     0.200
     3.854    11.752     0.200
     3.854    12.029     0.200
     4.042    13.080     0.200
     5.421    15.549     0.200
     5.478    16.577     0.200
     5.503    15.099     0.200
     5.703    15.667     0.200
     5.703    14.952     0.200
     5.849    18.080     0.200
     5.996    16.295     0.200
     6.316    16.429     0.200
     6.897    20.223     0.200
     6.984    18.157     0.200
     7.241    23.910     0.200
     7.770    21.720     0.200
     7.948    24.566     0.200
    10.848    31.483     0.200
    11.537    33.784     0.200
    12.705    35.328     0.200
    15.853    35.501     0.200
    19.731    39.001     0.200
     0.502     4.040     0.200
     0.617     4.549     0.200
     0.752     4.758     0.200
     0.994     5.862     0.200
     1.005     5.324     0.200
     1.283     6.095     0.200
     1.279     6.494     0.200
     1.278     6.389     0.200
     1.341     7.195     0.200
     1.385     5.959     0.200
     1.499     7.260     0.200
     1.650     6.545     0.200
     2.788    10.005     0.200
     4.908    13.653     0.200
     6.934    19.456     0.200
     8.391    26.674     0.200
    12.243    33.929     0.200
    12.819    36.257     0.200
    14.090    36.999     0.200
     0.108     5.971     0.200
     0.370     4.586     0.200
     0.412     4.610     0.200
     0.418     4.483     0.200
     0.445     4.461     0.200
     0.451     4.548     0.200
     0.538     5.013     0.200
     0.577     4.458     0.200
     0.558     5.203     0.200
     0.621     4.895     0.200
     0.665     5.096     0.200
     0.711     4.983     0.200
     0.737     5.035     0.200
     0.797     5.252     0.200
     0.911     5.559     0.200
     0.968     5.682     0.200
     1.028     5.970     0.200
     1.041     5.290     0.200
     1.052     5.686     0.200
     1.073     6.293     0.200
     1.105     6.456     0.200
     1.205     5.949     0.200
     1.197     5.564     0.200
     1.231     6.357     0.200
     1.281     6.166     0.200
     1.314     6.185     0.200
     1.341     6.837     0.200
     1.502     6.194     0.200
     1.501     6.140     0.200
     1.501     6.223     0.200
     1.503     6.225     0.200
     1.478     6.966     0.200
     1.519     7.028     0.200
     1.613     7.870     0.200
     1.698     6.674     0.200
     1.806     7.922     0.200
     1.857     7.618     0.200
     1.849     7.964     0.200
     1.938     7.975     0.200
     2.135     8.614     0.200
     2.147     8.299     0.200
     2.222     8.104     0.200
     2.239     8.957     0.200
     2.347     8.965     0.200
     2.394    10.095     0.200
     2.407     9.652     0.200
     2.514     9.381     0.200
     2.609    10.166     0.200
     2.615     9.801     0.200
     2.633     9.456     0.200
     2.756    10.628     0.200
     3.117    11.708     0.200
     3.629    11.946     0.200
     3.815    11.906     0.200
     3.827    12.160     0.200
     4.163    13.102     0.200
     4.767    14.874     0.200
     5.301    16.166     0.200
     0.240     4.280     0.200
     0.286     4.005     0.200
     0.320     4.355     0.200
     0.343     3.903     0.200
     0.342     3.977     0.200
     0.364     3.834     0.200
     0.380     4.112     0.200
     0.454     3.967     0.200
     0.568     4.623     0.200
     0.729     4.812     0.200
     0.754     4.565     0.200
     0.749     5.100     0.200
     0.761     5.060     0.200
     0.842     4.551     0.200
     0.865     4.658     0.200
     0.860     5.364     0.200
     0.882     5.088     0.200
     0.994     5.202     0.200
     1.041     5.582     0.200
     1.098     6.208     0.200
     1.142     5.944     0.200
     1.218     6.876     0.200
     1.275     6.432     0.200
     1.317     6.754     0.200
     1.346     6.614     0.200
     1.346     6.272     0.200
     1.346     6.439     0.200
     1.348     6.627     0.200
     1.477     8.094     0.200
     1.684     7.077     0.200
     1.714     7.627     0.200
     1.833     7.838     0.200
     1.866     7.455     0.200
     1.953     7.636     0.200
     2.049     7.947     0.200
     2.126     8.348     0.200
     2.152     8.055     0.200
     2.293     9.777     0.200
     2.331     8.568     0.200
     2.652     9.944     0.200
     0.359     4.092     0.200
     0.278     4.290     0.200
     0.357     4.078     0.200
     0.329     4.265     0.200
     0.458     4.396     0.200
     0.525     4.448     0.200
     0.645     4.320     0.200
     0.659     4.341     0.200
     0.681     4.705     0.200
     0.748     5.141     0.200
     0.803     4.822     0.200
     0.813     5.077     0.200
     0.842     4.954     0.200
     0.842     5.064     0.200
     0.886     4.672     0.200
     0.888     4.650     0.200
     0.902     5.725     0.200
     0.995     4.939     0.200
     1.007     5.204     0.200
     1.051     5.607     0.200
     1.167     6.149     0.200
     1.168     6.132     0.200
     1.183     5.786     0.200
     1.308     5.605     0.200
     1.359     6.112     0.200
     1.398     5.733     0.200
     1.417     6.415     0.200
     1.402     6.285     0.200
     1.508     6.674     0.200
     1.508     6.794     0.200
     1.518     6.406     0.200
     1.627     7.027     0.200
     1.700     6.822     0.200
     1.773     7.137     0.200
     1.738     8.036     0.200
     1.776     6.766     0.200
     1.831     7.303     0.200
     1.837     7.575     0.200
     1.905     7.394     0.200
     1.894     7.112     0.200
     1.895     7.703     0.200
     1.894     7.039     0.200
     1.894     8.549     0.200
     1.896     7.157     0.200
     2.088     5.163     0.200
     2.104     8.406     0.200
     2.253     9.338     0.200
     2.281     8.730     0.200
     2.316     9.418     0.200
     2.513     9.168     0.200
     2.554     8.617     0.200
     2.790    10.926     0.200
     2.822     8.993     0.200
     2.801    10.468     0.200
     2.801    10.578     0.200
     2.889    10.097     0.200
     2.994     9.366     0.200
     3.004    11.359     0.200
     3.006     9.849     0.200
     3.146    11.032     0.200
     3.183    10.556     0.200
     3.152    11.539     0.200
     3.388     9.945     0.200
     3.388    10.375     0.200
     3.606    12.305     0.200
     3.883    12.068     0.200
     3.943    12.440     0.200
     3.943    13.260     0.200
     4.062    13.347     0.200
     4.079    13.655     0.200
     4.130    13.775     0.200
     4.197    14.678     0.200
     4.213    14.344     0.200
     4.215    13.872     0.200
     4.322    14.283     0.200
     4.489    14.631     0.200
     4.556    13.624     0.200
     4.685    14.045     0.200
     4.746    12.298     0.200
     5.214    13.670     0.200
     5.259    16.048     0.200
     5.197    14.744     0.200
     5.544    13.763     0.200
     6.093    18.447     0.200
     6.191    15.475     0.200
     1.154     5.568     0.200
     1.171     5.706     0.200
     1.266     6.664     0.200
     1.257     6.553     0.200
     1.342     6.743     0.200
     1.348     6.351     0.200
     1.436     6.733     0.200
     1.437     6.568     0.200
     1.416     6.079     0.200
     1.529     7.050     0.200
     1.547     7.223     0.200
     1.663     6.843     0.200
     1.658     5.686     0.200
     1.806     8.161     0.200
     1.962     8.068     0.200
     1.964     7.864     0.200
     1.991     7.832     0.200
     2.067     8.373     0.200
     2.083     9.021     0.200
     2.156     9.351     0.200
     2.235     8.803     0.200
     2.314     9.375     0.200
     2.327     9.017     0.200
     2.332     9.108     0.200
     2.332     9.006     0.200
     2.434    10.117     0.200
     2.442     9.526     0.200
     2.520     9.131     0.200
     2.548    10.231     0.200
     2.548     9.580     0.200
     2.548     9.398     0.200
     2.550     9.797     0.200
     2.592    10.029     0.200
     2.692    10.488     0.200
     2.708     9.957     0.200
     2.772    10.282     0.200
     2.853    11.234     0.200
     2.933    10.725     0.200
     2.880    10.370     0.200
     2.880     9.784     0.200
     2.880     9.073     0.200
     3.003    10.492     0.200
     3.015    11.882     0.200
     3.182    11.916     0.200
     3.198    11.448     0.200
     3.230    11.608     0.200
     3.239    10.768     0.200
     3.273    11.707     0.200
     3.406    11.240     0.200
     3.460    12.659     0.200
     3.509    12.547     0.200
     3.626    12.759     0.200
     3.626    11.548     0.200
     3.655    12.529     0.200
     3.655    11.935     0.200
     3.752    12.653     0.200
     3.721    12.471     0.200
     3.721    11.510     0.200
     3.740    13.362     0.200
     3.839    13.406     0.200
     3.839    12.437     0.200
     3.839    12.916     0.200
     3.839    12.478     0.200
     3.992    13.935     0.200
     4.023    13.586     0.200
     4.078    15.297     0.200
     4.088    14.111     0.200
     4.088    13.189     0.200
     4.179    14.111     0.200
     4.321    13.654     0.200
     4.351    13.836     0.200
     4.401    13.694     0.200
     4.324    12.435     0.200
     4.412    15.012     0.200
     4.496    14.456     0.200
     4.506    16.014     0.200
     4.540    14.554     0.200
     4.598    16.602     0.200
     4.702    14.697     0.200
     4.820    16.270     0.200
     4.820    15.168     0.200
     4.835    13.289     0.200
     4.933    15.062     0.200
     4.933    14.593     0.200
     4.948    16.034     0.200
     4.935    15.394     0.200
     5.082    13.437     0.200
     5.082    13.226     0.200
     5.082    14.258     0.200
     5.145    14.203     0.200
     5.145    13.603     0.200
     5.266    15.967     0.200
     5.266    14.944     0.200
     5.246    16.946     0.200
     5.467    17.056     0.200
     5.467    16.938     0.200
     5.657    16.049     0.200
     5.699    17.505     0.200
     5.732    18.002     0.200
     5.799    19.791     0.200
     5.829    15.706     0.200
     5.927    17.077     0.200
     5.934    16.629     0.200
     5.975    16.131     0.200
     6.067    18.158     0.200
     6.245    18.753     0.200
     6.255    19.055     0.200
     6.276    19.756     0.200
     6.340    21.284     0.200
     6.424    19.301     0.200
     6.459    20.264     0.200
     6.468    19.779     0.200
     6.698    17.653     0.200
     6.723    18.984     0.200
     6.723    18.328     0.200
     6.723    18.117     0.200
     6.791    20.953     0.200
     6.818    21.303     0.200
     7.059    21.206     0.200
     7.109    19.135     0.200
     7.340    21.440     0.200
     7.371    23.009     0.200
     7.448    23.714     0.200
     7.631    22.470     0.200
     7.726    22.091     0.200
     7.722    21.355     0.200
     7.947    23.713     0.200
     8.099    21.542     0.200
     8.175    25.052     0.200
     8.255    21.054     0.200
     8.252    25.553     0.200
     8.343    21.950     0.200
     8.343    21.481     0.200
     8.408    24.565     0.200
     8.456    25.072     0.200
     8.579    21.993     0.200
     8.535    25.538     0.200
     8.683    23.883     0.200
     8.683    23.008     0.200
     8.699    23.009     0.200
     8.699    22.056     0.200
     8.705    22.837     0.200
     8.845    23.556     0.200
     8.845    22.064     0.200
     8.835    27.753     0.200
     8.835    26.469     0.200
     8.878    25.535     0.200
     8.949    22.626     0.200
     8.966    26.645     0.200
     9.238    27.875     0.200
     9.238    27.727     0.200
     9.238    27.266     0.200
     9.357    23.760     0.200
     9.379    28.211     0.200
     9.470    24.550     0.200
     9.471    27.956     0.200
     9.669    25.416     0.200
     9.735    25.982     0.200
     9.834    25.878     0.200
     9.842    25.546     0.200
    10.014    29.520     0.200
    10.126    25.150     0.200
    10.224    27.510     0.200
    10.463    26.774     0.200
    10.534    26.724     0.200
    10.534    26.529     0.200
    10.551    27.492     0.200
    10.607    27.295     0.200
    10.613    30.214     0.200
    10.781    32.185     0.200
    10.976    33.376     0.200
    11.016    32.776     0.200
    11.091    32.949     0.200
    11.160    28.761     0.200
    11.137    32.215     0.200
    11.145    33.903     0.200
    11.161    30.464     0.200
    11.201    33.037     0.200
    11.324    32.196     0.200
    11.374    32.226     0.200
    11.425    30.074     0.200
    11.542    29.837     0.200
    11.640    30.344     0.200
    11.616    34.054     0.200
    11.639    32.566     0.200
    11.670    30.670     0.200
    11.825    29.210     0.200
    11.830    34.142     0.200
    12.009    29.708     0.200
    12.029    34.395     0.200
    12.036    34.647     0.200
    12.166    30.177     0.200
    12.136    32.631     0.200
    12.195    30.648     0.200
    12.199    35.071     0.200
    12.305    30.755     0.200
    12.342    29.951     0.200
    12.341    33.945     0.200
    12.341    33.695     0.200
    12.385    31.959     0.200
    12.412    32.710     0.200
    12.412    31.358     0.200
    12.415    30.161     0.200
    12.378    35.507     0.200
    12.466    31.228     0.200
    12.467    35.891     0.200
    12.472    33.223     0.200
    12.568    31.826     0.200
    12.502    33.497     0.200
    12.541    35.957     0.200
    12.541    36.040     0.200
    12.612    30.885     0.200
    12.605    34.066     0.200
    12.605    32.300     0.200
    12.627    31.453     0.200
    12.673    35.471     0.200
    12.757    31.677     0.200
    12.761    32.299     0.200
    12.772    32.119     0.200
    12.809    34.642     0.200
    12.875    31.200     0.200
    12.875    30.747     0.200
    12.948    35.598     0.200
    12.892    34.631     0.200
    12.892    33.654     0.200
    13.025    34.188     0.200
    13.053    34.625     0.200
    13.053    35.660     0.200
    13.103    34.800     0.200
    13.158    35.441     0.200
    13.174    34.894     0.200
    13.198    33.757     0.200
    13.190    37.295     0.200
    13.288    34.829     0.200
    13.245    35.288     0.200
    13.270    35.900     0.200
    13.270    35.783     0.200
    13.292    36.019     0.200
    13.362    33.828     0.200
    13.400    35.016     0.200
    13.450    36.112     0.200
    13.528    35.953     0.200
    13.633    35.211     0.200
    13.599    37.211     0.200
    13.692    36.129     0.200
    13.692    33.972     0.200
    13.736    34.782     0.200
    13.745    33.814     0.200
    13.817    35.360     0.200
    13.807    36.481     0.200
    13.807    35.552     0.200
    13.876    35.464     0.200
    13.876    35.143     0.200
    13.876    35.055     0.200
    13.876    35.961     0.200
    13.914    38.327     0.200
    13.950    36.136     0.200
    13.945    36.879     0.200
    13.984    35.563     0.200
    14.105    36.217     0.200
    14.138    36.480     0.200
    14.143    36.305     0.200
    14.160    36.319     0.200
    14.117    38.354     0.200
    14.215    36.689     0.200
    14.261    33.356     0.200
    14.261    33.005     0.200
    14.256    36.440     0.200
    14.268    38.412     0.200
    14.298    35.836     0.200
    14.280    37.269     0.200
    14.449    36.730     0.200
    14.441    36.327     0.200
    14.484    37.334     0.200
    14.522    39.315     0.200
    14.500    36.808     0.200
    14.500    36.449     0.200
    14.500    35.113     0.200
    14.543    38.212     0.200
    14.571    38.339     0.200
    14.627    36.126     0.200
    14.571    35.227     0.200
    14.604    38.080     0.200
    14.697    36.238     0.200
    14.719    36.539     0.200
    14.730    38.552     0.200
    14.730    38.270     0.200
    14.785    33.173     0.200
    14.759    38.349     0.200
    14.797    32.879     0.200
    14.822    33.382     0.200
    14.835    33.183     0.200
    14.847    33.163     0.200
    14.833    39.153     0.200
    14.859    33.160     0.200
    14.808    38.405     0.200
    14.872    32.900     0.200
    14.872    33.079     0.200
    14.885    33.220     0.200
    14.891    33.085     0.200
    14.922    39.807     0.200
    14.948    37.481     0.200
    14.978    36.912     0.200
    15.006    37.203     0.200
    15.003    39.606     0.200
    14.977    37.284     0.200
    14.977    35.761     0.200
    15.047    37.264     0.200
    15.067    37.548     0.200
    15.067    40.088     0.200
    15.118    33.945     0.200
    15.108    39.700     0.200
    15.108    39.356     0.200
    15.178    38.627     0.200
    15.193    37.575     0.200
    15.190    37.563     0.200
    15.233    37.985     0.200
    15.246    38.646     0.200
    15.250    40.290     0.200
    15.277    38.073     0.200
    15.277    37.613     0.200
    15.240    36.217     0.200
    15.460    38.218     0.200
    15.399    36.721     0.200
    15.461    37.060     0.200
    15.478    38.504     0.200
    15.453    40.180     0.200
    15.499    39.608     0.200
    15.534    39.439     0.200
    15.528    40.597     0.200
    15.554    37.878     0.200
    15.549    38.971     0.200
    15.637    38.865     0.200
    15.643    40.042     0.200
    15.694    38.513     0.200
    15.809    35.953     0.200
    15.809    35.562     0.200
    15.776    38.649     0.200
    15.776    37.290     0.200
    15.807    37.702     0.200
    15.902    40.671     0.200
    15.955    38.582     0.200
    15.965    39.362     0.200
    15.978    40.407     0.200
    15.987    41.226     0.200
    15.987    40.897     0.200
    16.008    40.421     0.200
    16.008    40.147     0.200
    16.045    39.606     0.200
    16.039    41.356     0.200
    16.146    38.837     0.200
    16.137    39.765     0.200
    16.137    38.991     0.200
    16.185    40.729     0.200
    16.251    40.346     0.200
    16.269    38.647     0.200
    16.269    38.241     0.200
    16.347    40.324     0.200
    16.349    38.522     0.200
    16.388    40.314     0.200
    16.419    40.158     0.200
    16.419    39.299     0.200
    16.458    40.175     0.200
    16.568    40.513     0.200
    16.578    41.380     0.200
    16.579    40.387     0.200
    16.671    35.513     0.200
    16.676    41.186     0.200
    16.811    39.701     0.200
    16.801    39.691     0.200
    16.801    39.573     0.200
    16.871    40.329     0.200
    16.862    41.216     0.200
    16.889    39.114     0.200
    16.892    41.427     0.200
    16.921    40.397     0.200
    16.921    39.702     0.200
    16.975    40.960     0.200
    17.028    40.068     0.200
    16.990    40.654     0.200
    16.990    39.615     0.200
    17.089    39.333     0.200
    17.085    40.972     0.200
    17.085    40.808     0.200
    17.161    38.248     0.200
    17.161    37.741     0.200
    17.145    39.728     0.200
    17.219    37.252     0.200
    17.211    39.590     0.200
    17.144    39.394     0.200
    17.162    39.879     0.200
    17.162    39.723     0.200
    17.232    40.844     0.200
    17.197    39.017     0.200
    17.196    39.576     0.200
    17.275    40.901     0.200
    17.283    40.216     0.200
    17.307    39.305     0.200
    17.344    40.164     0.200
    17.344    39.625     0.200
    17.458    39.204     0.200
    17.395    39.660     0.200
    17.442    40.551     0.200
    17.635    39.164     0.200
    17.624    40.408     0.200
    17.728    39.485     0.200
    17.781    41.033     0.200
    17.836    40.421     0.200
    17.870    41.392     0.200
    17.918    40.224     0.200
    18.033    39.772     0.200
    18.033    39.623     0.200
    18.033    39.420     0.200
    18.043    41.207     0.200
    18.043    40.824     0.200
    18.139    38.206     0.200
    18.171    40.558     0.200
    18.171    40.261     0.200
    18.253    37.515     0.200
    18.253    36.953     0.200
    18.293    40.889     0.200
    18.321    40.681     0.200
    18.347    41.450     0.200
    18.427    42.537     0.200
    18.471    42.190     0.200
    18.637    42.751     0.200
    18.650    41.715     0.200
    18.701    42.359     0.200
    18.719    42.173     0.200
    18.719    42.009     0.200
    18.921    42.115     0.200
     1.175     5.774     0.200
     1.193     5.918     0.200
     1.400     6.781     0.200
     1.442     6.718     0.200
     1.457     6.579     0.200
     1.568     6.792     0.200
     1.583     6.827     0.200
     1.693     7.204     0.200
     1.855     7.772     0.200
     1.983     8.400     0.200
     2.121     8.788     0.200
     2.202     8.879     0.200
     2.346     9.349     0.200
     2.351     9.884     0.200
     2.467    10.117     0.200
     2.562     9.031     0.200
     2.575     9.973     0.200
     2.575     9.893     0.200
     2.575     9.601     0.200
     2.577     9.907     0.200
     2.638    10.045     0.200
     2.722    10.330     0.200
     2.731    10.561     0.200
     2.919    10.427     0.200
     2.919    10.802     0.200
     2.905    11.376     0.200
     4.918    17.291     0.200
     5.094    15.031     0.200
     5.157    14.897     0.200
     8.433    28.080     0.200
    13.896    36.326     0.200
    18.678    41.062     0.200
     0.879     4.758     0.200
     1.092     6.029     0.200
     1.143     5.343     0.200
     1.183     6.271     0.200
     1.158     5.480     0.200
     1.240     6.678     0.200
     1.247     6.380     0.200
     1.341     6.480     0.200
     1.323     6.473     0.200
     1.415     6.225     0.200
     1.424     6.398     0.200
     1.425     5.952     0.200
     1.513     6.546     0.200
     1.531     6.569     0.200
     1.649     6.546     0.200
     1.671     5.632     0.200
     1.788     7.475     0.200
     1.948     7.511     0.200
     1.953     7.307     0.200
     1.982     8.425     0.200
     2.067     8.508     0.200
     2.138     8.306     0.200
     2.314     8.543     0.200
     2.324     8.503     0.200
     2.419     8.505     0.200
     2.433     8.866     0.200
     2.503     8.846     0.200
     2.534     9.623     0.200
     2.535     9.507     0.200
     2.534     9.131     0.200
     2.536     9.578     0.200
     2.574     9.519     0.200
     2.677     9.694     0.200
     2.763    10.171     0.200
     2.834    10.474     0.200
     2.875     9.827     0.200
     2.875     9.677     0.200
     2.919    11.396     0.200
     2.989    11.299     0.200
     3.083    11.283     0.200
     3.193    11.887     0.200
     3.221    11.860     0.200
     3.265    11.523     0.200
     3.446    13.149     0.200
     3.494    12.331     0.200
     3.513    12.089     0.200
     3.607    12.684     0.200
     3.642    12.562     0.200
     3.716    11.756     0.200
     3.735    12.430     0.200
     3.824    12.479     0.200
     3.824    13.049     0.200
     4.328    12.360     0.200
     4.403    15.288     0.200
     4.837    13.125     0.200
     4.916    14.793     0.200
     4.933    16.283     0.200
     5.085    13.563     0.200
     5.085    13.263     0.200
     5.148    13.789     0.200
     5.148    13.690     0.200
     5.251    14.719     0.200
     5.832    15.191     0.200
     6.707    18.655     0.200
    13.864    36.279     0.200
    20.952    39.517     0.200
     1.114     5.801     0.200
     1.143     5.363     0.200
     1.160     5.405     0.200
     1.363     6.688     0.200
     1.425     6.040     0.200
     1.427     5.915     0.200
     1.432     6.525     0.200
     1.540     6.435     0.200
     1.654     6.568     0.200
     1.803     7.600     0.200
     1.954     7.507     0.200
     1.953     7.239     0.200
     1.979     8.284     0.200
     2.058     8.715     0.200
     2.077     8.520     0.200
     2.152     8.362     0.200
     2.317     8.586     0.200
     2.426     9.169     0.200
     2.539     9.246     0.200
     2.538     9.834     0.200
     2.539     9.210     0.200
     2.541     9.457     0.200
     2.683    10.434     0.200
     2.698     9.088     0.200
     2.852    10.909     0.200
     2.896     9.926     0.200
     2.924    11.338     0.200
     3.218    11.645     0.200
     3.451    13.094     0.200
     3.502    12.573     0.200
     3.626    12.500     0.200
     3.646    12.752     0.200
     3.830    13.058     0.200
     4.033    14.117     0.200
     4.339    12.767     0.200
     4.850    13.382     0.200
     4.919    16.147     0.200
     5.097    13.744     0.200
     5.160    14.038     0.200
     5.845    15.556     0.200
     6.452    20.759     0.200
    13.866    34.814     0.200
    18.670    40.647     0.200
     1.050     6.212     0.200
     1.050     5.783     0.200
     1.148     6.183     0.200
     1.266     6.671     0.200
     1.302     7.741     0.200
     1.311     6.965     0.200
     1.726     8.129     0.200
     1.978     8.950     0.200
     2.297     9.919     0.200
     2.703    10.942     0.200
     3.088    12.755     0.200
     3.711    14.314     0.200
     1.068     5.977     0.200
     1.480     7.910     0.200
     2.041     8.510     0.200
     2.876    10.115     0.200
     3.396    13.140     0.200
     6.184    19.089     0.200
     1.071     5.926     0.200
     0.752     5.334     0.200
     0.867     6.528     0.200
     0.893     5.626     0.200
     1.237     6.925     0.200
     1.259     6.319     0.200
     1.489     7.280     0.200
     1.517     7.376     0.200
     1.563     6.472     0.200
     1.630     7.489     0.200
     1.767     7.913     0.200
     1.768     7.972     0.200
     2.039     8.841     0.200
     2.271    10.274     0.200
     2.242     9.542     0.200
     2.331     9.389     0.200
     2.498    10.349     0.200
     2.608    11.112     0.200
     2.663    10.597     0.200
     2.694    11.417     0.200
     2.683    10.659     0.200
     2.820    11.643     0.200
     2.812    10.257     0.200
     2.898    10.732     0.200
     2.898    10.932     0.200
     2.898    10.370     0.200
     2.900    11.215     0.200
     2.953    12.083     0.200
     3.004    11.640     0.200
     3.032    11.018     0.200
     3.061    12.276     0.200
     3.100    10.795     0.200
     3.100    10.686     0.200
     3.125    12.287     0.200
     3.380    12.317     0.200
     3.426    12.943     0.200
     3.472    12.369     0.200
     3.740    13.797     0.200
     3.894    14.477     0.200
     3.988    14.032     0.200
     4.112    14.995     0.200
     4.112    15.667     0.200
     4.183    14.807     0.200
     4.326    16.206     0.200
     4.641    15.992     0.200
     4.654    16.064     0.200
     4.654    16.454     0.200
     5.104    17.158     0.200
     5.104    17.720     0.200
     5.801    18.569     0.200
     5.848    19.867     0.200
     5.914    19.817     0.200
     6.214    21.292     0.200
     6.461    19.238     0.200
     6.739    21.111     0.200
     7.112    21.357     0.200
     7.312    24.462     0.200
     8.182    28.143     0.200
     8.328    25.167     0.200
     8.905    28.981     0.200
     9.085    25.046     0.200
     9.989    26.652     0.200
    10.638    33.246     0.200
    11.138    33.624     0.200
    11.262    33.357     0.200
    11.398    35.315     0.200
    11.598    35.177     0.200
    11.822    35.196     0.200
    12.108    34.572     0.200
    12.186    33.890     0.200
    12.186    34.726     0.200
    12.210    35.812     0.200
    12.405    34.713     0.200
    12.508    31.642     0.200
    12.719    36.543     0.200
    13.310    36.788     0.200
    14.162    38.703     0.200
    14.162    38.250     0.200
    15.289    35.179     0.200
    16.124    37.384     0.200
    18.720    41.548     0.200
    20.608    40.209     0.200
     1.046     5.471     0.200
     1.182     5.563     0.200
     1.143     6.072     0.200
     1.156     5.737     0.200
     1.199     5.853     0.200
     1.312     6.725     0.200
     1.348     5.804     0.200
     1.465     6.252     0.200
     1.480     6.444     0.200
     1.532     6.532     0.200
     1.746     7.245     0.200
     1.747     6.854     0.200
     1.838     7.432     0.200
     1.965     8.033     0.200
     2.198     8.362     0.200
     2.265     7.891     0.200
     2.275     8.736     0.200
     2.372     8.616     0.200
     2.370     8.541     0.200
     2.419     8.809     0.200
     2.613     9.671     0.200
     2.696     9.532     0.200
     2.696     9.387     0.200
     2.731    10.695     0.200
     2.752     9.867     0.200
     2.795     9.716     0.200
     2.812     9.609     0.200
     2.853     9.787     0.200
     2.853     9.354     0.200
     2.853     9.340     0.200
     2.854    10.693     0.200
     2.855    11.048     0.200
     2.852    10.702     0.200
     2.911    10.669     0.200
     2.992    11.487     0.200
     3.082    11.348     0.200
     3.083    11.062     0.200
     3.234    12.040     0.200
     3.283    11.093     0.200
     3.541    12.632     0.200
     3.579    12.504     0.200
     3.624    12.910     0.200
     3.804    12.893     0.200
     3.915    11.287     0.200
     3.836    12.586     0.200
     3.836    12.735     0.200
     4.038    11.929     0.200
     3.962    12.969     0.200
     4.013    12.684     0.200
     4.037    13.744     0.200
     4.025    13.998     0.200
     4.138    13.674     0.200
     4.417    12.745     0.200
     4.459    12.195     0.200
     4.498    13.878     0.200
     4.557    12.564     0.200
     4.557    11.805     0.200
     4.484    14.195     0.200
     4.722    14.725     0.200
     4.799    13.025     0.200
     4.799    12.791     0.200
     4.754    15.332     0.200
     4.862    13.256     0.200
     4.862    13.239     0.200
     4.999    15.496     0.200
     5.094    15.004     0.200
     5.131    17.036     0.200
     5.131    17.437     0.200
     5.207    16.404     0.200
     5.554    15.414     0.200
     5.561    14.987     0.200
     5.832    16.001     0.200
     5.868    17.710     0.200
     6.076    17.236     0.200
     6.246    17.588     0.200
     6.284    15.964     0.200
     6.404    17.221     0.200
     6.418    18.891     0.200
     7.013    20.324     0.200
     7.218    18.334     0.200
     9.056    26.278     0.200
     9.056    26.131     0.200
     9.056    24.191     0.200
     9.647    24.719     0.200
    10.032    25.087     0.200
    14.186    36.947     0.200
    14.853    33.932     0.200
    15.911    35.964     0.200
    16.381    36.329     0.200
    17.348    37.539     0.200
    17.529    36.159     0.200
     0.122     4.929     0.200
     0.271     4.505     0.200
     0.286     4.360     0.200
     0.316     4.542     0.200
     0.523     4.511     0.200
     0.565     4.608     0.200
     0.602     4.586     0.200
     0.631     4.905     0.200
     0.704     4.825     0.200
     0.812     5.037     0.200
     0.883     5.666     0.200
     0.984     5.897     0.200
     0.987     5.926     0.200
     1.047     5.378     0.200
     1.112     5.572     0.200
     1.147     5.955     0.200
     1.122     6.246     0.200
     1.141     6.128     0.200
     1.141     5.280     0.200
     1.240     6.833     0.200
     1.257     6.092     0.200
     1.279     6.640     0.200
     1.279     6.219     0.200
     1.433     6.965     0.200
     1.457     7.100     0.200
     1.476     7.158     0.200
     1.539     7.210     0.200
     1.542     7.124     0.200
     1.571     6.156     0.200
     1.586     6.992     0.200
     1.594     6.639     0.200
     1.593     6.586     0.200
     1.593     6.893     0.200
     1.595     6.551     0.200
     1.595     6.534     0.200
     1.595     6.606     0.200
     1.600     7.089     0.200
     1.711     6.888     0.200
     1.711     7.534     0.200
     1.765     6.604     0.200
     1.881     7.909     0.200
     1.881     8.119     0.200
     1.916     7.894     0.200
     1.961     5.286     0.200
     1.974     7.926     0.200
     2.044     8.337     0.200
     2.053     8.734     0.200
     2.053     8.863     0.200
     2.132     8.204     0.200
     2.180     8.424     0.200
     2.174     8.170     0.200
     2.351     9.027     0.200
     2.386     8.926     0.200
     2.411     8.675     0.200
     2.401     8.938     0.200
     2.448     9.173     0.200
     2.503     9.854     0.200
     2.523     9.093     0.200
     2.552     9.741     0.200
     2.574     9.395     0.200
     2.704     9.905     0.200
     2.811     9.586     0.200
     2.817    10.077     0.200
     2.827    10.276     0.200
     2.880    10.420     0.200
     2.880    10.210     0.200
     2.880    10.370     0.200
     2.867    10.659     0.200
     3.014     9.862     0.200
     3.014    10.052     0.200
     3.073    10.894     0.200
     3.200    11.263     0.200
     3.200    10.923     0.200
     3.224    11.563     0.200
     3.381    11.411     0.200
     3.367    10.707     0.200
     3.449    11.450     0.200
     3.531    11.746     0.200
     3.585    11.882     0.200
     3.585    12.092     0.200
     3.605    11.469     0.200
     3.856    12.548     0.200
     3.891    12.751     0.200
     3.891    12.990     0.200
     4.005    12.410     0.200
     4.313    13.621     0.200
     4.308    13.038     0.200
     4.308    13.348     0.200
     4.386    14.217     0.200
     4.665    13.078     0.200
     4.744    14.300     0.200
     4.890    15.471     0.200
     4.914    13.825     0.200
     4.956    15.758     0.200
     5.022    14.360     0.200
     5.030    14.390     0.200
     5.025    15.349     0.200
     5.092    15.435     0.200
     5.112    14.886     0.200
     5.122    15.052     0.200
     5.241    15.461     0.200
     5.235    14.705     0.200
     5.268    15.578     0.200
     5.365    15.149     0.200
     5.372    16.042     0.200
     5.558    16.824     0.200
     5.581    14.931     0.200
     5.706    16.936     0.200
     5.728    16.576     0.200
     5.759    15.596     0.200
     5.768    15.993     0.200
     5.768    16.103     0.200
     5.768    15.761     0.200
     5.856    16.730     0.200
     5.847    15.311     0.200
     5.866    16.626     0.200
     6.032    16.483     0.200
     6.150    17.501     0.200
     6.323    17.267     0.200
     6.451    18.906     0.200
     6.560    17.009     0.200
     6.584    17.486     0.200
     6.646    18.961     0.200
     6.661    17.955     0.200
     6.670    20.376     0.200
     6.855    18.553     0.200
     6.820    17.724     0.200
     7.120    22.246     0.200
     7.181    20.448     0.200
     7.202    18.560     0.200
     7.211    20.163     0.200
     7.213    20.405     0.200
     7.365    20.468     0.200
     7.557    21.281     0.200
     7.747    24.532     0.200
     7.744    19.807     0.200
     7.755    20.311     0.200
     7.888    22.811     0.200
     8.049    24.663     0.200
     8.248    20.602     0.200
     8.482    25.056     0.200
     8.551    22.942     0.200
     8.758    22.468     0.200
     8.953    22.701     0.200
     9.244    26.805     0.200
     9.314    23.906     0.200
     9.593    23.802     0.200
     9.626    24.205     0.200
     9.626    23.685     0.200
     9.612    26.472     0.200
     9.612    24.673     0.200
     9.649    23.786     0.200
     9.708    23.996     0.200
     9.758    23.840     0.200
     9.814    24.042     0.200
     9.856    24.702     0.200
    10.210    25.542     0.200
    10.210    25.009     0.200
    10.645    26.039     0.200
    10.645    25.608     0.200
    10.688    25.812     0.200
    10.786    26.586     0.200
    10.872    26.437     0.200
    10.877    27.998     0.200
    11.232    32.054     0.200
    11.355    27.328     0.200
    11.383    27.204     0.200
    11.433    28.375     0.200
    11.527    28.073     0.200
    11.667    27.717     0.200
    11.818    28.174     0.200
    11.917    28.331     0.200
    11.917    28.449     0.200
    12.005    33.826     0.200
    12.631    33.856     0.200
    12.836    31.161     0.200
    12.836    30.264     0.200
    12.936    33.271     0.200
    12.936    33.481     0.200
    13.026    30.628     0.200
    13.062    33.566     0.200
    13.251    31.069     0.200
    13.312    31.655     0.200
    13.312    30.928     0.200
    13.452    35.354     0.200
    13.576    31.728     0.200
    13.906    36.183     0.200
    14.032    33.001     0.200
    14.088    32.783     0.200
    14.196    33.618     0.200
    14.199    32.477     0.200
    14.261    36.542     0.200
    14.437    36.798     0.200
    14.487    37.261     0.200
    14.523    34.170     0.200
    14.832    33.777     0.200
    14.857    34.005     0.200
    14.936    35.004     0.200
    15.176    35.072     0.200
    15.236    35.017     0.200
    15.347    35.522     0.200
    15.347    35.026     0.200
    15.357    35.151     0.200
    15.353    35.388     0.200
    15.353    34.660     0.200
    15.389    35.809     0.200
    15.712    33.368     0.200
    15.712    33.606     0.200
    15.931    37.141     0.200
    15.947    36.588     0.200
    15.992    36.048     0.200
    16.086    37.593     0.200
    16.082    35.899     0.200
    16.106    36.094     0.200
    16.157    36.160     0.200
    16.165    35.880     0.200
    16.205    35.981     0.200
    16.210    36.085     0.200
    16.220    35.851     0.200
    16.311    35.525     0.200
    16.754    37.309     0.200
    16.801    37.627     0.200
    17.100    36.981     0.200
    17.295    37.647     0.200
    17.300    38.217     0.200
    17.335    35.584     0.200
    17.585    38.406     0.200
    17.801    37.610     0.200
    17.917    37.381     0.200
    18.019    37.502     0.200
    18.333    40.922     0.200
    19.023    39.448     0.200
    19.241    40.808     0.200
    19.255    39.188     0.200
    19.664    38.926     0.200
    19.759    38.601     0.200
    20.094    38.268     0.200
    20.288    38.954     0.200
     0.779     5.292     0.200
     0.779     5.131     0.200
     0.842     5.398     0.200
     0.898     6.023     0.200
     1.086     6.521     0.200
     1.101     6.284     0.200
     1.105     6.295     0.200
     1.105     6.474     0.200
     1.115     5.697     0.200
     1.114     5.930     0.200
     1.108     6.156     0.200
     1.140     6.833     0.200
     1.174     6.818     0.200
     1.194     6.736     0.200
     1.204     6.012     0.200
     1.205     6.078     0.200
     1.205     6.050     0.200
     1.205     6.113     0.200
     1.206     6.059     0.200
     1.209     6.179     0.200
     1.232     6.472     0.200
     1.270     6.625     0.200
     1.270     6.754     0.200
     1.299     6.824     0.200
     1.291     6.398     0.200
     1.317     6.728     0.200
     1.319     7.107     0.200
     1.310     6.596     0.200
     1.415     7.181     0.200
     1.425     7.151     0.200
     1.442     7.035     0.200
     1.442     6.785     0.200
     1.454     7.206     0.200
     1.454     7.096     0.200
     1.535     7.418     0.200
     1.530     7.399     0.200
     1.567     7.565     0.200
     1.627     8.923     0.200
     1.609     7.267     0.200
     1.804     8.352     0.200
     1.790     7.929     0.200
     1.837     9.104     0.200
     1.875     8.227     0.200
     1.896     8.713     0.200
     1.916     9.639     0.200
     1.906     8.626     0.200
     1.936     8.631     0.200
     2.020     9.913     0.200
     2.066     8.881     0.200
     2.117     9.647     0.200
     2.117     9.948     0.200
     2.122     9.270     0.200
     2.126     9.031     0.200
     2.205     9.350     0.200
     2.210     9.645     0.200
     2.213     9.471     0.200
     2.203     9.597     0.200
     2.228     9.457     0.200
     2.228     9.687     0.200
     2.258     8.583     0.200
     2.268     9.475     0.200
     2.307    10.419     0.200
     2.310    10.097     0.200
     2.407    10.459     0.200
     2.407    10.682     0.200
     2.562    10.822     0.200
     2.629    10.809     0.200
     2.629    11.110     0.200
     2.703    10.244     0.200
     2.698    10.846     0.200
     2.766    11.445     0.200
     2.766    11.132     0.200
     2.787    11.627     0.200
     2.796    11.063     0.200
     2.936    12.771     0.200
     2.943    11.936     0.200
     3.128    11.662     0.200
     3.383    12.323     0.200
     3.538    12.807     0.200
     3.634    12.938     0.200
     3.634    11.528     0.200
     3.703    12.824     0.200
     4.319    13.214     0.200
     4.319    13.093     0.200
     5.096    15.106     0.200
     0.218     4.226     0.200
     0.337     4.043     0.200
     0.345     4.280     0.200
     0.420     4.098     0.200
     0.526     4.193     0.200
     0.535     4.161     0.200
     0.782     4.472     0.200
     0.798     4.700     0.200
     0.792     4.907     0.200
     0.885     4.886     0.200
     0.878     5.447     0.200
     0.885     4.699     0.200
     0.938     4.898     0.200
     0.998     5.393     0.200
     1.043     6.032     0.200
     1.079     5.630     0.200
     1.162     6.045     0.200
     1.303     5.624     0.200
     1.284     6.547     0.200
     1.331     6.413     0.200
     1.349     5.760     0.200
     1.404     6.316     0.200
     1.413     6.269     0.200
     1.629     7.279     0.200
     1.693     7.895     0.200
     1.768     6.793     0.200
     1.830     7.496     0.200
     1.830     7.844     0.200
     1.830     7.462     0.200
     1.832     8.029     0.200
     1.849     7.605     0.200
     1.874     7.646     0.200
     2.011     7.616     0.200
     2.145     9.051     0.200
     2.174     8.841     0.200
     2.250     9.144     0.200
     2.943    10.432     0.200
     3.126    10.101     0.200
     3.263    10.152     0.200
     3.788    12.520     0.200
     0.204     4.486     0.200
     0.252     4.316     0.200
     0.281     4.092     0.200
     0.281     4.134     0.200
     0.322     3.863     0.200
     0.392     4.024     0.200
     0.404     4.415     0.200
     0.424     4.158     0.200
     0.642     4.779     0.200
     0.707     4.776     0.200
     0.761     4.623     0.200
     0.800     4.646     0.200
     0.800     4.574     0.200
     0.807     5.219     0.200
     0.831     5.287     0.200
     0.850     5.161     0.200
     0.844     5.290     0.200
     0.877     5.056     0.200
     0.909     5.278     0.200
     0.902     5.002     0.200
     0.935     5.695     0.200
     1.038     5.873     0.200
     1.129     5.048     0.200
     1.167     6.164     0.200
     1.281     6.234     0.200
     1.282     5.945     0.200
     1.282     6.231     0.200
     1.284     6.247     0.200
     1.321     6.375     0.200
     1.327     6.167     0.200
     1.358     6.735     0.200
     1.401     7.115     0.200
     1.421     6.639     0.200
     1.434     6.067     0.200
     1.456     6.487     0.200
     1.459     6.205     0.200
     1.651     6.885     0.200
     1.662     6.744     0.200
     1.778     7.611     0.200
     1.795     7.705     0.200
     1.941     6.960     0.200
     2.083     8.332     0.200
     2.131     5.450     0.200
     2.131     8.417     0.200
     2.243     9.292     0.200
     2.410     8.748     0.200
     2.564     9.035     0.200
     2.568     9.864     0.200
     2.661    10.301     0.200
     2.774     6.927     0.200
     2.803     9.131     0.200
     2.795     6.992     0.200
     3.246    11.167     0.200
     3.869    12.563     0.200
     0.488     4.027     0.200
     0.520     4.411     0.200
     1.090     5.146     0.200
     1.371     3.608     0.200
     1.182     6.429     0.200
     1.305     6.548     0.200
     1.379     6.428     0.200
     1.408     6.291     0.200
     1.580     6.716     0.200
     1.580     6.597     0.200
     1.604     7.434     0.200
     1.569     7.693     0.200
     1.577     7.802     0.200
     1.604     7.499     0.200
     1.701     7.482     0.200
     1.708     7.871     0.200
     1.921     4.954     0.200
     1.943     4.969     0.200
     1.823     7.487     0.200
     1.828     7.140     0.200
     1.887     8.215     0.200
     1.989     8.676     0.200
     2.024     7.531     0.200
     2.068     7.419     0.200
     2.043     7.838     0.200
     2.043     8.052     0.200
     2.043     7.846     0.200
     2.045     7.941     0.200
     2.045     8.046     0.200
     2.167     7.864     0.200
     2.183     9.224     0.200
     2.216     8.603     0.200
     2.313     8.626     0.200
     2.614    10.391     0.200
     2.632     9.820     0.200
     2.918    10.194     0.200
     2.929    10.580     0.200
     2.952    11.509     0.200
     3.056    10.662     0.200
     3.055    11.484     0.200
     3.124    11.374     0.200
     3.346    11.809     0.200
     3.471    11.348     0.200
     3.483    11.355     0.200
     3.484    12.351     0.200
     3.789    13.107     0.200
     3.812    12.838     0.200
     4.238    14.001     0.200
     4.325    14.177     0.200
     4.550    13.312     0.200
     4.796    14.589     0.200
     5.639    17.663     0.200
     5.779    17.916     0.200
     5.791    17.748     0.200
     0.035     4.994     0.200
     0.066     4.592     0.200
     0.302     3.918     0.200
     0.299     3.718     0.200
     0.300     3.657     0.200
     0.521     3.730     0.200
     0.710     4.246     0.200
     0.771     4.992     0.200
     0.829     4.600     0.200
     0.859     5.168     0.200
     0.859     4.525     0.200
     0.913     5.212     0.200
     0.934     4.801     0.200
     0.934     4.779     0.200
     0.934     4.889     0.200
     1.003     5.561     0.200
     1.003     5.670     0.200
     1.036     5.457     0.200
     1.049     5.803     0.200
     1.049     5.912     0.200
     1.198     6.131     0.200
     1.222     6.038     0.200
     1.219     5.803     0.200
     1.238     6.438     0.200
     1.326     6.318     0.200
     1.356     6.798     0.200
     1.368     6.023     0.200
     1.355     6.040     0.200
     1.411     5.981     0.200
     1.410     5.986     0.200
     1.411     5.752     0.200
     1.411     5.932     0.200
     1.413     5.961     0.200
     1.413     5.793     0.200
     1.457     7.294     0.200
     1.490     5.930     0.200
     1.512     6.757     0.200
     1.566     6.249     0.200
     1.567     6.909     0.200
     1.634     7.045     0.200
     1.804     7.520     0.200
     1.931     4.422     0.200
     1.931     8.279     0.200
     1.944     7.214     0.200
     2.117     8.622     0.200
     2.125     8.236     0.200
     2.212     8.033     0.200
     2.212     8.193     0.200
     2.298     9.501     0.200
     2.324     9.871     0.200
     2.364     8.821     0.200
     2.400     9.402     0.200
     2.514     9.391     0.200
     2.577     5.893     0.200
     2.598     6.218     0.200
     2.713     9.792     0.200
     2.821     9.469     0.200
     2.862    10.256     0.200
     2.862    10.545     0.200
     2.977    12.247     0.200
     3.041    11.122     0.200
     3.307    11.368     0.200
     3.357    11.974     0.200
     3.357    11.865     0.200
     3.600    11.274     0.200
     3.683    13.474     0.200
     3.713    12.635     0.200
     3.890    12.279     0.200
     3.966    12.092     0.200
     4.012    12.998     0.200
     4.082    12.305     0.200
     4.481    13.314     0.200
     4.662    14.633     0.200
     4.722    13.915     0.200
     4.807    13.787     0.200
     4.833    13.325     0.200
     4.860    13.676     0.200
     4.878    14.312     0.200
     4.896    13.347     0.200
     5.040    15.323     0.200
     5.147    14.965     0.200
     5.233    15.318     0.200
     5.545    16.155     0.200
     5.566    16.735     0.200
     5.599    14.468     0.200
     5.617    14.593     0.200
     5.617    15.772     0.200
     5.933    15.702     0.200
     6.380    17.185     0.200
     7.004    18.235     0.200
     7.235    20.348     0.200
     7.523    24.434     0.200
     7.591    21.294     0.200
     8.213    21.558     0.200
     8.717    23.562     0.200
     9.925    25.906     0.200
    11.000    32.054     0.200
    11.770    33.453     0.200
    12.736    33.357     0.200
    19.197    37.983     0.200
    19.489    37.614     0.200
    20.834    37.335     0.200
     0.299     4.395     0.200
     0.340     4.233     0.200
     0.403     4.293     0.200
     0.463     4.122     0.200
     0.462     4.175     0.200
     0.659     5.012     0.200
     0.655     4.954     0.200
     0.740     5.201     0.200
     0.740     4.772     0.200
     0.779     5.210     0.200
     0.966     5.048     0.200
     0.943     5.021     0.200
     0.955     5.116     0.200
     0.955     4.974     0.200
     0.941     5.473     0.200
     0.975     4.894     0.200
     1.107     4.913     0.200
     1.094     5.555     0.200
     1.067     5.548     0.200
     1.067     5.749     0.200
     1.173     6.222     0.200
     1.220     6.484     0.200
     1.220     6.516     0.200
     1.266     5.783     0.200
     1.278     6.107     0.200
     1.294     6.544     0.200
     1.427     6.827     0.200
     1.393     6.153     0.200
     1.434     6.119     0.200
     1.434     5.995     0.200
     1.434     6.216     0.200
     1.435     6.180     0.200
     1.436     5.944     0.200
     1.435     5.980     0.200
     1.512     6.697     0.200
     1.499     6.709     0.200
     1.559     6.982     0.200
     1.613     7.170     0.200
     1.604     6.417     0.200
     1.623     6.137     0.200
     1.748     7.501     0.200
     1.748     7.671     0.200
     1.786     7.500     0.200
     1.802     7.273     0.200
     1.836     7.141     0.200
     1.844     8.063     0.200
     1.867     8.264     0.200
     1.867     7.405     0.200
     1.947     8.146     0.200
     1.947     7.845     0.200
     2.154     5.371     0.200
     2.134     7.509     0.200
     2.233     8.188     0.200
     2.207     8.507     0.200
     2.252     8.698     0.200
     2.252     8.509     0.200
     2.367     9.905     0.200
     2.367     9.765     0.200
     2.409     8.354     0.200
     2.420     8.906     0.200
     2.545    10.070     0.200
     2.622     9.934     0.200
     2.745     6.843     0.200
     2.768     6.861     0.200
     2.705    10.654     0.200
     2.786     6.936     0.200
     2.986     9.428     0.200
     3.039    10.219     0.200
     3.031    11.584     0.200
     3.090    10.967     0.200
     3.377    12.321     0.200
     3.395    10.297     0.200
     3.423    11.986     0.200
     3.488    11.794     0.200
     3.488    11.585     0.200
     3.609    11.960     0.200
     3.641    12.541     0.200
     3.683    12.683     0.200
     3.712    13.108     0.200
     3.741    13.112     0.200
     3.744    14.226     0.200
     3.752    12.387     0.200
     3.801    11.760     0.200
     3.896    13.181     0.200
     4.042    14.528     0.200
     4.200    11.644     0.200
     4.305    13.078     0.200
     4.674    15.351     0.200
     4.706    13.453     0.200
     5.079    15.915     0.200
     5.081    15.093     0.200
     5.203    13.953     0.200
     5.204    13.945     0.200
     5.258    15.458     0.200
     5.398    15.673     0.200
     6.278    19.199     0.200
     6.321    20.536     0.200
     0.260     3.395     0.200
     0.401     3.518     0.200
     0.449     3.619     0.200
     0.500     3.589     0.200
     0.566     3.594     0.200
     0.595     4.176     0.200
     0.596     4.062     0.200
     0.803     4.954     0.200
     0.961     5.011     0.200
     0.980     5.457     0.200
     1.036     4.745     0.200
     1.056     4.832     0.200
     1.124     5.671     0.200
     1.190     5.381     0.200
     1.242     6.193     0.200
     1.255     6.160     0.200
     1.255     6.031     0.200
     1.245     5.796     0.200
     1.245     5.633     0.200
     1.245     5.825     0.200
     1.373     6.169     0.200
     1.422     5.812     0.200
     1.422     5.711     0.200
     1.481     3.956     0.200
     1.423     6.477     0.200
     1.436     6.410     0.200
     1.436     6.879     0.200
     1.441     6.828     0.200
     1.461     6.141     0.200
     1.550     7.082     0.200
     1.631     6.559     0.200
     1.668     7.671     0.200
     1.668     7.569     0.200
     1.680     7.803     0.200
     1.687     7.383     0.200
     1.687     6.916     0.200
     1.687     6.253     0.200
     1.689     7.079     0.200
     1.747     8.151     0.200
     1.747     8.095     0.200
     1.747     7.033     0.200
     1.767     7.040     0.200
     1.792     6.695     0.200
     1.859     7.269     0.200
     1.907     8.016     0.200
     1.874     7.962     0.200
     1.909     7.116     0.200
     1.922     8.095     0.200
     2.029     8.114     0.200
     2.084     8.714     0.200
     2.097     8.029     0.200
     2.150     8.164     0.200
     2.213     8.458     0.200
     2.253     8.908     0.200
     2.338     8.822     0.200
     2.341     9.148     0.200
     2.422     8.436     0.200
     2.422     8.616     0.200
     2.390     8.101     0.200
     2.489    10.079     0.200
     2.557     9.114     0.200
     2.560     8.915     0.200
     2.715    10.992     0.200
     2.715    10.641     0.200
     2.747     9.882     0.200
     2.984    11.121     0.200
     3.072    11.454     0.200
     3.098    11.084     0.200
     3.193    10.499     0.200
     3.228    10.319     0.200
     3.282    11.780     0.200
     3.311    12.072     0.200
     3.353    11.457     0.200
     3.418    12.148     0.200
     3.448    12.657     0.200
     3.457    12.338     0.200
     3.474    10.903     0.200
     3.491    12.379     0.200
     3.490    13.057     0.200
     3.500    12.496     0.200
     3.523    12.611     0.200
     3.549    13.048     0.200
     3.557    13.102     0.200
     3.562    12.844     0.200
     3.569    12.776     0.200
     3.781    12.321     0.200
     3.843    13.213     0.200
     3.937    13.981     0.200
     4.431    15.157     0.200
     4.679    14.184     0.200
     5.089    14.554     0.200
     5.367    14.627     0.200
     5.367    14.711     0.200
     5.656    15.839     0.200
     6.943    19.576     0.200
     0.076     4.713     0.200
     0.244     3.663     0.200
     0.254     3.764     0.200
     0.358     4.422     0.200
     0.427     4.574     0.200
     0.467     4.115     0.200
     0.516     4.496     0.200
     0.559     4.004     0.200
     0.560     4.061     0.200
     0.575     4.218     0.200
     0.576     4.055     0.200
     0.576     4.274     0.200
     0.609     4.136     0.200
     0.702     4.587     0.200
     0.806     4.644     0.200
     0.856     4.788     0.200
     0.838     4.902     0.200
     0.838     4.793     0.200
     0.856     4.771     0.200
     0.857     4.688     0.200
     0.857     4.807     0.200
     0.848     5.203     0.200
     0.897     4.547     0.200
     0.963     5.521     0.200
     0.970     5.384     0.200
     1.030     5.331     0.200
     1.074     5.861     0.200
     1.115     5.646     0.200
     1.123     6.006     0.200
     1.115     5.646     0.200
     1.259     6.358     0.200
     1.301     6.307     0.200
     1.311     6.380     0.200
     1.336     6.651     0.200
     1.336     6.881     0.200
     1.360     6.595     0.200
     1.360     6.251     0.200
     1.373     6.697     0.200
     1.378     6.211     0.200
     1.391     6.310     0.200
     1.477     6.452     0.200
     1.508     6.638     0.200
     1.565     6.801     0.200
     1.607     7.373     0.200
     1.662     7.260     0.200
     1.674     7.124     0.200
     1.674     6.932     0.200
     1.728     7.691     0.200
     1.728     7.344     0.200
     1.737     6.946     0.200
     1.837     8.126     0.200
     1.837     7.977     0.200
     1.884     8.181     0.200
     1.884     8.431     0.200
     1.972     7.386     0.200
     2.035     7.672     0.200
     2.103     8.884     0.200
     2.103     8.716     0.200
     2.132     7.856     0.200
     2.146     8.635     0.200
     2.156     8.093     0.200
     2.158     8.663     0.200
     2.158     8.296     0.200
     2.184     8.974     0.200
     2.184     8.521     0.200
     2.206     7.764     0.200
     2.229     9.146     0.200
     2.230     9.644     0.200
     2.230     9.042     0.200
     2.315     9.411     0.200
     2.374     9.055     0.200
     2.425     9.374     0.200
     2.462     9.138     0.200
     2.483     9.002     0.200
     2.483     9.182     0.200
     2.504     8.676     0.200
     2.523     9.166     0.200
     2.523     8.698     0.200
     2.543     9.760     0.200
     2.550     9.321     0.200
     2.554     8.882     0.200
     2.578     9.633     0.200
     2.612     9.921     0.200
     2.612     9.663     0.200
     2.601     9.656     0.200
     2.618    10.085     0.200
     2.634     9.673     0.200
     2.676     9.899     0.200
     2.685    10.056     0.200
     2.734    10.914     0.200
     2.747    11.000     0.200
     2.772     9.454     0.200
     2.886    10.005     0.200
     2.875    10.964     0.200
     2.880    10.475     0.200
     2.953    10.294     0.200
     3.205    10.446     0.200
     3.205    10.165     0.200
     3.300    12.143     0.200
     3.302    11.348     0.200
     3.529    13.141     0.200
     3.659    13.019     0.200
     3.900    12.613     0.200
     4.064    13.063     0.200
     4.071    14.024     0.200
     4.126    12.429     0.200
     4.323    11.951     0.200
     4.332    14.591     0.200
     4.413    12.894     0.200
     5.736    15.610     0.200
     1.034     5.516     0.200
     1.034     5.672     0.200
     1.091     5.464     0.200
     1.109     5.156     0.200
     1.154     5.684     0.200
     1.154     5.699     0.200
     1.155     5.611     0.200
     1.156     5.536     0.200
     1.156     5.676     0.200
     1.230     5.784     0.200
     1.209     5.964     0.200
     1.247     5.378     0.200
     1.247     5.518     0.200
     1.240     6.602     0.200
     1.352     6.756     0.200
     1.349     7.011     0.200
     1.342     6.362     0.200
     1.397     5.960     0.200
     1.466     6.458     0.200
     1.478     7.286     0.200
     1.652     7.487     0.200
     1.653     6.994     0.200
     1.695     7.350     0.200
     1.700     7.890     0.200
     1.721     7.465     0.200
     1.731     7.343     0.200
     1.754     7.471     0.200
     1.840     8.020     0.200
     1.871     7.442     0.200
     1.871     7.575     0.200
     1.898     5.003     0.200
     1.930     8.577     0.200
     1.930     8.651     0.200
     1.962     7.592     0.200
     2.105     7.933     0.200
     2.156     9.602     0.200
     2.156     9.438     0.200
     2.201     8.914     0.200
     2.337     8.747     0.200
     2.405     9.097     0.200
     2.405     9.199     0.200
     2.553     9.782     0.200
     2.615     9.736     0.200
     2.598     9.677     0.200
     2.669     6.312     0.200
     2.744     9.568     0.200
     2.855    10.020     0.200
     2.877    10.201     0.200
     2.887    10.290     0.200
     2.913    10.097     0.200
     2.971    11.362     0.200
     3.048    10.865     0.200
     3.305    11.775     0.200
     3.600    11.933     0.200
     3.748    12.223     0.200
     3.861    12.789     0.200
     3.900    12.380     0.200
     3.900    12.005     0.200
     3.945    11.833     0.200
     4.044    13.714     0.200
     4.083    12.432     0.200
     4.083    12.088     0.200
     4.128    12.847     0.200
     4.183    13.041     0.200
     4.205    12.909     0.200
     4.248    14.212     0.200
     4.377    14.185     0.200
     4.394    13.044     0.200
     4.404    13.144     0.200
     4.481    12.863     0.200
     4.559    14.740     0.200
     4.622    14.554     0.200
     4.890    15.978     0.200
     5.070    15.784     0.200
     5.378    15.119     0.200
     5.378    15.244     0.200
     5.396    14.937     0.200
     5.470    15.715     0.200
     5.737    17.792     0.200
     5.801    15.657     0.200
     5.933    17.182     0.200
     6.002    16.230     0.200
     6.405    17.180     0.200
     6.565    18.064     0.200
     6.547    17.726     0.200
     7.049    22.860     0.200
     7.194    19.812     0.200
     7.340    19.844     0.200
     7.754    21.108     0.200
     7.784    19.367     0.200
     7.786    21.975     0.200
     8.833    22.836     0.200
     9.001    23.963     0.200
     9.001    25.495     0.200
     9.176    22.948     0.200
     9.262    23.462     0.200
     9.712    24.066     0.200
    10.302    25.203     0.200
    10.303    27.644     0.200
    10.540    29.953     0.200
    10.548    26.081     0.200
    11.109    27.823     0.200
    11.286    32.341     0.200
    11.865    32.439     0.200
    12.165    31.702     0.200
    12.165    32.343     0.200
    12.364    32.989     0.200
    12.929    30.281     0.200
    13.543    34.609     0.200
    13.912    33.174     0.200
    14.000    32.663     0.200
    14.117    34.000     0.200
    14.200    33.739     0.200
    14.472    34.320     0.200
    14.614    32.989     0.200
    14.738    34.536     0.200
    15.075    33.783     0.200
    15.254    33.684     0.200
    15.844    36.263     0.200
    16.239    35.733     0.200
    16.551    37.503     0.200
    17.643    37.736     0.200
    17.737    36.974     0.200
    19.430    38.228     0.200
    19.532    37.900     0.200
    19.973    38.149     0.200
    19.973    37.547     0.200
    20.242    37.740     0.200
     0.505     3.582     0.200
     0.700     4.733     0.200
     0.900     5.145     0.200
     1.011     5.922     0.200
     1.106     5.569     0.200
     1.077     5.475     0.200
     1.127     5.464     0.200
     1.202     6.478     0.200
     1.437     7.505     0.200
     1.437     7.295     0.200
     1.437     6.724     0.200
     1.513     7.154     0.200
     1.570     7.825     0.200
     1.674     7.858     0.200
     1.703     6.730     0.200
     1.703     6.838     0.200
     1.786     7.150     0.200
     1.916     8.551     0.200
     1.916     8.105     0.200
     1.934     7.744     0.200
     1.934     8.354     0.200
     2.060     7.671     0.200
     2.060     7.491     0.200
     2.109     9.231     0.200
     2.105     8.834     0.200
     2.191     8.101     0.200
     2.283     9.756     0.200
     2.338     8.150     0.200
     2.449     8.495     0.200
     2.548     8.218     0.200
     2.688     9.185     0.200
     2.738    10.145     0.200
     3.168    10.019     0.200
     3.173    10.193     0.200
     3.552    11.612     0.200
     3.743    10.577     0.200
     3.747    11.348     0.200
     4.171    12.462     0.200
     4.688    13.816     0.200
     4.732    13.059     0.200
     5.558    15.447     0.200
     0.654     4.547     0.200
     0.679     4.651     0.200
     1.129     5.798     0.200
     1.129     5.721     0.200
     1.197     5.960     0.200
     1.228     6.601     0.200
     1.370     6.260     0.200
     1.500     7.334     0.200
     1.514     7.642     0.200
     1.667     6.876     0.200
     1.898     7.826     0.200
     1.863     8.028     0.200
     1.981     8.317     0.200
     2.570    10.927     0.200
     0.166     3.817     0.200
     0.210     3.605     0.200
     0.320     3.473     0.200
     0.344     3.464     0.200
     0.355     3.843     0.200
     0.414     3.619     0.200
     0.414     3.587     0.200
     0.493     3.809     0.200
     0.593     4.175     0.200
     0.801     4.863     0.200
     0.882     4.403     0.200
     0.866     5.352     0.200
     0.903     4.836     0.200
     0.903     4.865     0.200
     0.912     5.565     0.200
     0.915     5.384     0.200
     0.949     5.235     0.200
     1.120     6.132     0.200
     1.125     5.526     0.200
     1.211     6.138     0.200
     1.271     6.646     0.200
     1.281     6.321     0.200
     1.349     6.807     0.200
     1.385     6.686     0.200
     1.875     7.732     0.200
     1.914     8.650     0.200
     2.052     8.049     0.200
     2.321     8.330     0.200
     2.347     9.524     0.200
     2.734     9.855     0.200
     0.212     4.058     0.200
     0.235     4.456     0.200
     0.270     4.366     0.200
     0.219     4.188     0.200
     0.310     4.393     0.200
     0.354     4.089     0.200
     0.354     4.109     0.200
     0.509     4.066     0.200
     0.459     4.332     0.200
     0.536     4.146     0.200
     0.597     4.543     0.200
     0.675     4.647     0.200
     0.695     4.717     0.200
     0.763     4.702     0.200
     0.736     4.660     0.200
     0.782     4.817     0.200
     0.782     4.823     0.200
     0.782     4.843     0.200
     0.836     5.016     0.200
     0.836     4.886     0.200
     0.836     4.944     0.200
     0.829     4.829     0.200
     0.799     4.688     0.200
     0.799     4.797     0.200
     0.840     5.008     0.200
     0.864     4.975     0.200
     0.935     5.258     0.200
     0.965     4.868     0.200
     1.000     5.260     0.200
     1.001     5.359     0.200
     1.001     5.300     0.200
     1.003     5.295     0.200
     0.952     5.080     0.200
     0.965     5.328     0.200
     1.050     5.341     0.200
     1.158     5.906     0.200
     1.158     5.946     0.200
     1.173     6.072     0.200
     1.127     5.681     0.200
     1.248     6.383     0.200
     1.275     6.496     0.200
     1.299     5.721     0.200
     1.371     6.789     0.200
     1.340     6.147     0.200
     1.365     5.743     0.200
     1.381     6.708     0.200
     1.463     7.019     0.200
     1.507     6.433     0.200
     1.525     6.803     0.200
     1.621     7.572     0.200
     1.641     7.471     0.200
     1.682     6.713     0.200
     1.696     6.649     0.200
     1.696     6.699     0.200
     1.839     7.808     0.200
     1.862     8.027     0.200
     1.860     7.942     0.200
     1.938     7.745     0.200
     1.955     8.521     0.200
     1.980     8.801     0.200
     1.999     8.407     0.200
     2.014     8.299     0.200
     2.040     7.992     0.200
     2.142     9.499     0.200
     2.257     8.705     0.200
     2.361     8.797     0.200
     2.327     8.566     0.200
     2.346     8.730     0.200
     2.359     9.505     0.200
     2.426     9.017     0.200
     2.441     9.057     0.200
     2.510     9.519     0.200
     2.525     9.585     0.200
     2.564     9.232     0.200
     2.631     9.869     0.200
     2.821    10.304     0.200
     2.922     9.828     0.200
     2.964     7.169     0.200
     3.008    10.489     0.200
     2.985     7.334     0.200
     3.065    10.604     0.200
     3.131    11.391     0.200
     3.201    11.676     0.200
     3.430    11.851     0.200
     3.573    12.162     0.200
     3.580    12.031     0.200
     5.054    14.672     0.200
     6.641    18.090     0.200
     6.991    18.855     0.200
     0.069     4.520     0.200
     0.259     3.927     0.200
     0.393     3.835     0.200
     0.523     4.372     0.200
     0.587     4.308     0.200
     0.593     4.360     0.200
     0.673     4.528     0.200
     0.724     4.783     0.200
     0.859     4.846     0.200
     0.860     4.775     0.200
     0.854     5.033     0.200
     0.947     5.166     0.200
     0.947     5.207     0.200
     0.906     5.577     0.200
     0.950     5.646     0.200
     0.962     5.259     0.200
     1.060     5.401     0.200
     1.256     6.427     0.200
     1.320     5.825     0.200
     1.419     5.842     0.200
     1.470     6.435     0.200
     1.470     6.223     0.200
     1.485     6.854     0.200
     1.409     6.778     0.200
     1.619     7.338     0.200
     1.772     7.038     0.200
     1.817     5.208     0.200
     1.951     6.936     0.200
     1.951     7.587     0.200
     2.021     8.210     0.200
     2.120     7.479     0.200
     2.194     7.958     0.200
     2.402     9.187     0.200
     2.318     6.649     0.200
     2.330     5.805     0.200
     2.469     8.701     0.200
     2.668     9.859     0.200
     2.681     9.763     0.200
     2.727     9.537     0.200
     2.727     9.798     0.200
     2.856     9.868     0.200
     2.907    10.448     0.200
     2.899     9.959     0.200
     3.039    10.865     0.200
     3.118    10.922     0.200
     3.163    10.855     0.200
     3.140    10.263     0.200
     3.140    10.399     0.200
     3.909    11.397     0.200
     4.054    13.318     0.200
     4.131    13.252     0.200
     4.188    11.447     0.200
     4.352    12.162     0.200
     4.817    15.117     0.200
     4.806    13.377     0.200
     4.872    15.221     0.200
     5.046    16.128     0.200
     5.090    15.205     0.200
     5.253    16.765     0.200
     5.332    16.163     0.200
     5.280    14.328     0.200
     5.373    16.264     0.200
     5.541    15.715     0.200
     5.541    15.576     0.200
     5.630    16.184     0.200
     6.121    16.817     0.200
     9.370    28.602     0.200
     9.428    28.882     0.200
     9.463    28.661     0.200
     9.441    27.279     0.200
     9.522    28.494     0.200
     9.499    24.893     0.200
     9.971    25.607     0.200
     9.971    27.406     0.200
    10.066    25.140     0.200
    10.216    30.111     0.200
    10.297    29.803     0.200
    10.745    31.837     0.200
    10.919    31.575     0.200
    10.927    32.018     0.200
    10.991    26.894     0.200
    11.002    30.769     0.200
    11.547    32.436     0.200
    12.253    34.045     0.200
    12.275    29.731     0.200
    12.260    33.558     0.200
    12.373    29.866     0.200
    12.839    31.640     0.200
    13.164    32.552     0.200
    13.291    33.929     0.200
    14.875    34.799     0.200
    15.034    36.284     0.200
    15.067    35.847     0.200
    15.131    37.013     0.200
    15.155    36.353     0.200
    15.159    36.390     0.200
    15.214    33.983     0.200
    15.215    37.851     0.200
    15.307    36.386     0.200
    15.280    36.547     0.200
    16.429    37.992     0.200
    16.547    37.920     0.200
    17.317    35.533     0.200
    17.453    37.812     0.200
    17.446    38.821     0.200
    17.446    38.931     0.200
    18.411    38.731     0.200
    18.890    38.949     0.200
    19.135    37.042     0.200
    19.009    40.896     0.200
    19.377    39.885     0.200
    19.426    38.833     0.200
    19.915    39.119     0.200
    19.934    38.453     0.200
    20.426    38.231     0.200
    20.426    38.562     0.200
    20.535    37.796     0.200
    20.535    38.896     0.200
    20.817    38.583     0.200
     0.492     3.820     0.200
     0.492     3.830     0.200
     0.490     3.786     0.200
     0.566     4.084     0.200
     0.566     3.905     0.200
     0.599     3.922     0.200
     0.599     3.980     0.200
     0.621     4.642     0.200
     0.674     4.129     0.200
     0.692     4.835     0.200
     0.715     4.435     0.200
     0.715     4.484     0.200
     0.784     4.934     0.200
     0.815     5.109     0.200
     0.796     4.244     0.200
     0.800     4.915     0.200
     0.901     4.458     0.200
     0.902     4.998     0.200
     0.894     4.608     0.200
     0.904     4.967     0.200
     0.894     5.126     0.200
     0.909     4.507     0.200
     0.909     4.544     0.200
     0.942     4.835     0.200
     1.037     5.529     0.200
     1.037     5.678     0.200
     1.039     5.537     0.200
     1.106     5.975     0.200
     1.117     6.646     0.200
     1.291     6.743     0.200
     1.313     7.221     0.200
     1.297     5.759     0.200
     1.398     7.459     0.200
     1.382     5.577     0.200
     1.460     7.038     0.200
     1.449     7.931     0.200
     1.526     7.422     0.200
     1.589     8.367     0.200
     1.778     6.522     0.200
     1.841     8.164     0.200
     2.037     7.462     0.200
     2.087    10.130     0.200
     2.196     7.462     0.200
     2.337     9.066     0.200
     2.521     9.945     0.200
     2.562     9.887     0.200
     2.755    10.222     0.200
     3.099    10.881     0.200
     3.121    10.866     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.536    17.448     0.200
     3.066    25.558     0.200
     3.448    26.745     0.200
     3.503    22.960     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.948     5.677     0.200
     0.717     4.757     0.200
     0.683     4.557     0.200
     0.888     4.966     0.200
     1.153     5.661     0.200
     1.166     6.240     0.200
     1.438     6.885     0.200
     1.652     7.597     0.200
     0.837     5.067     0.200
     0.861     5.105     0.200
     0.826     5.483     0.200
     0.925     5.432     0.200
     1.117     6.060     0.200
     1.188     6.819     0.200
     1.405     7.350     0.200
     1.409     7.208     0.200
     1.619     8.232     0.200
     0.791     5.234     0.200
     0.840     5.866     0.200
     0.939     5.278     0.200
     1.235     6.949     0.200
     1.253     6.744     0.200
     0.799     5.287     0.200
     0.858     5.925     0.200
     0.937     5.408     0.200
     1.648     8.522     0.200
     1.795     8.598     0.200
     0.449     3.272     0.200
     0.506     4.714     0.200
     0.863     4.635     0.200
     0.896     4.737     0.200
     0.966     5.500     0.200
     1.269     6.582     0.200
     1.313     6.890     0.200
     2.538    13.430     0.200
     2.612    13.387     0.200
     2.657    13.297     0.200
     2.794    16.108     0.200
     2.798    13.887     0.200
     3.688    21.051     0.200
     0.378     3.041     0.200
     0.467     3.938     0.200
     0.744     4.664     0.200
     0.784     4.632     0.200
     0.825     4.346     0.200
     1.213     6.196     0.200
     2.185    11.440     0.200
     2.560    13.710     0.200
     2.618    12.146     0.200
     2.744    14.301     0.200
     2.761    16.487     0.200
     3.618    20.510     0.200
     0.319     3.422     0.200
     0.408     3.791     0.200
     0.503     3.371     0.200
     0.732     4.484     0.200
     0.842     4.821     0.200
     0.850     4.742     0.200
     0.880     4.593     0.200
     1.076     5.901     0.200
     1.032     5.842     0.200
     1.111     6.242     0.200
     1.195     6.478     0.200
     2.880    16.440     0.200
     0.554     3.803     0.200
     0.906     5.199     0.200
     0.938     5.240     0.200
     0.879     4.853     0.200
     1.080     5.838     0.200
     1.121     5.827     0.200
     1.169     6.326     0.200
     1.249     6.676     0.200
     1.318     6.710     0.200
     1.319     6.666     0.200
     2.919    16.567     0.200
     0.392     3.907     0.200
     0.493     3.670     0.200
     0.736     4.857     0.200
     0.823     4.540     0.200
     0.863     5.069     0.200
     0.837     4.714     0.200
     1.023     5.540     0.200
     1.059     5.730     0.200
     0.403     3.941     0.200
     0.518     3.862     0.200
     0.845     4.626     0.200
     0.841     4.770     0.200
     0.889     5.197     0.200
     0.896     5.063     0.200
     1.047     5.837     0.200
     1.072     5.721     0.200
     1.209     6.659     0.200
     1.265     6.462     0.200
     1.266     6.702     0.200
     2.896    15.200     0.200
     0.456     2.711     0.200
     0.629     4.194     0.200
     0.778     4.044     0.200
     0.784     4.330     0.200
     0.806     4.259     0.200
     0.882     5.881     0.200
     0.993     5.485     0.200
     1.045     5.601     0.200
     1.046     5.494     0.200
     1.046     5.583     0.200
     1.046     5.592     0.200
     1.047     5.565     0.200
     1.048     5.571     0.200
     1.049     5.615     0.200
     1.060     5.317     0.200
     1.165     6.028     0.200
     1.362     8.822     0.200
     1.383     7.861     0.200
     1.441     7.809     0.200
     1.538    10.288     0.200
     1.501     7.867     0.200
     1.525     8.172     0.200
     1.576     8.196     0.200
     1.834     9.365     0.200
     2.013     9.530     0.200
     2.063    10.300     0.200
     2.207    12.781     0.200
     2.534    14.762     0.200
     2.641    13.380     0.200
     2.791    15.132     0.200
     3.007    14.580     0.200
     0.132     2.229     0.200
     0.152     2.148     0.200
     0.219     2.304     0.200
     0.388     2.888     0.200
     0.400     3.170     0.200
     0.537     3.537     0.200
     0.601     3.866     0.200
     0.687     4.624     0.200
     0.697     4.415     0.200
     0.821     4.939     0.200
     0.846     5.176     0.200
     0.897     5.179     0.200
     0.915     4.860     0.200
     0.924     5.516     0.200
     0.918     5.356     0.200
     0.973     5.534     0.200
     0.984     5.796     0.200
     0.999     5.372     0.200
     1.008     6.729     0.200
     1.244     6.972     0.200
     1.256     6.738     0.200
     1.260     6.505     0.200
     1.276     7.450     0.200
     1.380     7.511     0.200
     1.444     7.288     0.200
     1.448     7.777     0.200
     1.479     7.602     0.200
     1.480     7.677     0.200
     1.480     7.790     0.200
     1.480     7.629     0.200
     1.481     7.722     0.200
     1.481     7.536     0.200
     1.483     7.790     0.200
     1.484     7.715     0.200
     1.539     8.057     0.200
     1.628     8.864     0.200
     1.643     8.520     0.200
     1.667     8.668     0.200
     1.678     8.311     0.200
     1.679     8.568     0.200
     1.868     9.718     0.200
     2.021    10.401     0.200
     2.036    10.691     0.200
     2.045    10.233     0.200
     2.115    10.719     0.200
     2.215    10.621     0.200
     2.270    10.302     0.200
     2.300    10.736     0.200
     2.456    11.826     0.200
     2.587    11.963     0.200
     2.773    12.389     0.200
     2.776    12.742     0.200
     0.126     2.276     0.200
     0.145     2.179     0.200
     0.384     2.891     0.200
     0.408     3.045     0.200
     0.540     3.415     0.200
     0.601     3.810     0.200
     0.690     4.551     0.200
     0.705     4.210     0.200
     0.743     5.625     0.200
     0.829     4.725     0.200
     0.850     5.295     0.200
     0.896     5.150     0.200
     0.911     4.905     0.200
     0.927     5.437     0.200
     0.914     5.154     0.200
     0.981     5.399     0.200
     0.990     5.684     0.200
     0.999     5.358     0.200
     1.003     6.859     0.200
     1.248     6.868     0.200
     1.256     6.662     0.200
     1.258     6.432     0.200
     1.281     7.767     0.200
     1.373     7.031     0.200
     1.380     7.482     0.200
     1.441     7.426     0.200
     1.478     7.652     0.200
     1.479     7.656     0.200
     1.479     7.480     0.200
     1.478     7.708     0.200
     1.480     7.765     0.200
     1.480     7.888     0.200
     1.480     7.812     0.200
     1.481     7.816     0.200
     1.482     7.879     0.200
     1.483     7.734     0.200
     1.542     8.218     0.200
     1.628     8.883     0.200
     1.641     8.960     0.200
     1.671     8.759     0.200
     1.684     8.933     0.200
     1.686     8.790     0.200
     1.774    10.135     0.200
     1.786     9.244     0.200
     1.867     9.659     0.200
     2.027     9.640     0.200
     2.041     9.739     0.200
     2.042    10.905     0.200
     2.301    11.151     0.200
     2.456    11.430     0.200
     1.063     5.632     0.200
     1.329     7.543     0.200
     1.336     7.483     0.200
     1.368     7.257     0.200
     1.531     8.289     0.200
     1.579     8.115     0.200
     1.605     8.810     0.200
     1.726     9.069     0.200
     1.836     8.950     0.200
     1.958     9.334     0.200
     0.471     3.554     0.200
     0.656     4.246     0.200
     0.637     4.182     0.200
     0.698     4.806     0.200
     0.930     5.306     0.200
     0.194     1.842     0.200
     0.387     3.270     0.200
     0.467     3.211     0.200
     0.485     3.389     0.200
     0.530     4.958     0.200
     0.641     4.845     0.200
     0.921     5.052     0.200
     1.154     7.329     0.200
     3.604    18.288     0.200
     0.286     3.152     0.200
     0.520     4.200     0.200
     0.650     4.354     0.200
     0.687     4.524     0.200
     0.979     5.413     0.200
     0.275     3.426     0.200
     0.275     3.452     0.200
     0.456     4.385     0.200
     0.456     4.517     0.200
     0.434     3.683     0.200
     0.513     3.720     0.200
     0.704     4.172     0.200
     0.704     4.289     0.200
     0.672     4.583     0.200
     0.672     4.333     0.200
     0.704     4.204     0.200
     0.745     4.552     0.200
     0.746     4.292     0.200
     0.746     4.691     0.200
     0.740     4.786     0.200
     0.857     5.099     0.200
     4.083    20.049     0.200
     0.113     3.652     0.200
     0.112     3.718     0.200
     0.183     3.490     0.200
     0.183     3.330     0.200
     0.214     3.336     0.200
     0.350     3.422     0.200
     0.393     3.277     0.200
     0.393     3.307     0.200
     0.659     4.184     0.200
     0.726     4.452     0.200
     0.727     4.509     0.200
     0.801     4.706     0.200
     0.861     4.977     0.200
     0.921     5.087     0.200
     1.003     5.257     0.200
     1.011     5.303     0.200
     1.106     5.799     0.200
     1.104     6.029     0.200
     1.126     6.255     0.200
     1.202     6.411     0.200
     1.202     6.267     0.200
     1.203     6.374     0.200
     1.204     6.395     0.200
     1.293     6.384     0.200
     1.354     6.493     0.200
     1.358     7.115     0.200
     1.502     7.141     0.200
     1.903    10.884     0.200
     1.902    10.898     0.200
     2.832    15.749     0.200
     0.333     2.750     0.200
     0.448     3.713     0.200
     0.409     3.181     0.200
     0.538     3.841     0.200
     0.671     4.530     0.200
     0.788     4.595     0.200
     0.841     4.888     0.200
     0.906     5.024     0.200
     0.936     5.349     0.200
     1.076     5.644     0.200
     1.103     6.135     0.200
     0.303     3.308     0.200
     0.274     3.065     0.200
     0.304     3.150     0.200
     0.304     3.351     0.200
     0.290     3.576     0.200
     0.386     3.795     0.200
     0.536     3.358     0.200
     0.638     4.093     0.200
     0.674     4.182     0.200
     0.902     5.133     0.200
     0.901     5.178     0.200
     1.034     6.486     0.200
     1.088     6.204     0.200
     1.168     6.474     0.200
     1.201     7.205     0.200
     1.218     6.964     0.200
     1.250     6.749     0.200
     1.217     6.965     0.200
     1.412     7.247     0.200
     1.420     6.874     0.200
     1.460     7.241     0.200
     1.477     7.675     0.200
     1.622     8.409     0.200
     1.699     9.524     0.200
     1.766     8.437     0.200
     1.841     9.270     0.200
     1.871     9.455     0.200
     1.949    10.329     0.200
     1.961    10.378     0.200
     1.966     9.968     0.200
     2.356    11.498     0.200
     2.499    13.089     0.200
     2.708    12.595     0.200
     2.755    14.056     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     2.101    32.969     0.200
     4.792    65.691     0.200
     2.372    37.508     0.200
     4.212    59.754     0.200
     0.861    16.574     0.200
     0.302     9.592     0.200
     0.279    10.506     0.200
     0.409    11.217     0.200
     0.681    13.941     0.200
     0.744    15.172     0.200
     0.726    14.946     0.200
     0.740    15.014     0.200
     0.888    16.823     0.200
     0.918    17.790     0.200
     1.072    19.169     0.200
     1.133    21.214     0.200
     1.129    20.590     0.200
     1.427    24.702     0.200
     1.856    29.297     0.200
     2.150    32.522     0.200
     2.342    36.132     0.200
     3.068    44.365     0.200
     5.498    74.124     0.200
     6.149    82.737     0.200
     7.004    97.055     0.200
     0.238     8.100     0.200
     0.344     8.982     0.200
     0.613    12.004     0.200
     0.632    12.706     0.200
     0.758    13.941     0.200
     0.883    15.959     0.200
     0.877    16.229     0.200
     0.947    17.831     0.200
     0.994    17.699     0.200
     1.061    18.528     0.200
     1.067    18.686     0.200
     1.108    18.648     0.200
     1.220    21.636     0.200
     1.365    24.788     0.200
     1.393    24.547     0.200
     1.431    25.099     0.200
     1.427    25.053     0.200
     1.442    26.302     0.200
     1.571    27.595     0.200
     1.889    30.945     0.200
     4.124    58.980     0.200
     0.238     8.146     0.200
     0.451    10.468     0.200
     0.682    12.360     0.200
     0.744    14.078     0.200
     0.732    14.164     0.200
     1.015    18.668     0.200
     1.036    17.486     0.200
     1.105    19.695     0.200
     1.393    22.644     0.200
     1.770    28.107     0.200
     1.775    26.578     0.200
     0.791    15.975     0.200
     0.939    17.997     0.200
     1.235    23.318     0.200
     1.253    23.414     0.200
     1.439    23.204     0.200
     2.053    33.132     0.200
     2.246    34.985     0.200
     2.498    39.788     0.200
     2.590    41.531     0.200
     2.692    41.002     0.200
     2.832    43.172     0.200
     2.923    45.434     0.200
     2.976    43.557     0.200
     3.296    49.729     0.200
     3.420    51.756     0.200
     3.746    54.065     0.200
     4.069    62.853     0.200
     4.177    62.812     0.200
     4.635    63.662     0.200
     4.725    65.448     0.200
     5.018    69.274     0.200
     5.337    73.912     0.200
     5.723    78.839     0.200
     9.330   131.040     0.200
     0.937    17.970     0.200
     1.245    22.242     0.200
     1.256    23.209     0.200
     1.297    22.318     0.200
     1.434    23.539     0.200
     2.972    44.957     0.200
     2.972    44.777     0.200
     4.195    60.648     0.200
     4.177    60.070     0.200
     5.329    74.283     0.200
     9.324   130.755     0.200
     1.165    21.208     0.200
     4.210    60.659     0.200
     4.560    63.637     0.200
     0.784    14.652     0.200
     0.825    15.147     0.200
     0.902    17.358     0.200
     4.198    59.181     0.200
     4.529    62.129     0.200
     4.705    65.220     0.200
     5.017    69.474     0.200
     0.825    14.487     0.200
     1.229    20.428     0.200
     1.474    23.910     0.200
     1.582    24.735     0.200
     1.608    26.238     0.200
     1.758    28.458     0.200
     1.994    31.463     0.200
     2.129    33.353     0.200
     2.341    34.526     0.200
     2.387    36.584     0.200
     2.892    43.524     0.200
     3.141    48.293     0.200
     3.854    54.603     0.200
     3.854    55.029     0.200
     4.042    59.927     0.200
     5.478    77.648     0.200
     5.849    83.357     0.200
     0.502    11.173     0.200
     0.617    13.409     0.200
     0.752    13.968     0.200
     1.283    21.025     0.200
     2.788    40.716     0.200
     2.788    40.247     0.200
     0.108    11.041     0.200
     0.370    11.101     0.200
     0.412    11.446     0.200
     0.445    11.461     0.200
     0.451    11.634     0.200
     0.538    13.404     0.200
     0.577    12.700     0.200
     0.558    13.586     0.200
     0.621    13.176     0.200
     0.665    14.143     0.200
     0.737    15.230     0.200
     0.797    15.736     0.200
     0.968    18.362     0.200
     1.028    18.978     0.200
     1.041    18.353     0.200
     1.052    18.967     0.200
     1.105    20.424     0.200
     1.197    20.955     0.200
     1.849    28.379     0.200
     2.147    32.135     0.200
     0.240     9.570     0.200
     0.286     9.535     0.200
     0.320    10.415     0.200
     0.343    10.173     0.200
     0.342    10.207     0.200
     0.364     9.974     0.200
     0.380    10.492     0.200
     0.454    10.996     0.200
     0.568    12.982     0.200
     0.729    14.792     0.200
     0.754    14.825     0.200
     0.749    15.370     0.200
     0.761    15.410     0.200
     0.784    15.531     0.200
     0.842    15.430     0.200
     0.865    16.078     0.200
     0.860    16.944     0.200
     0.882    17.058     0.200
     0.994    17.272     0.200
     1.041    19.502     0.200
     1.098    19.348     0.200
     1.218    21.296     0.200
     1.317    22.794     0.200
     1.346    21.889     0.200
     1.388    23.303     0.200
     1.477    24.764     0.200
     2.049    31.407     0.200
     2.331    34.048     0.200
     0.357     9.868     0.200
     0.329    10.515     0.200
     0.458    11.576     0.200
     0.525    12.608     0.200
     0.645    13.150     0.200
     0.659    13.231     0.200
     0.681    14.365     0.200
     0.748    15.141     0.200
     0.803    15.772     0.200
     0.813    15.797     0.200
     0.842    16.034     0.200
     0.886    15.782     0.200
     0.888    15.770     0.200
     0.902    17.615     0.200
     0.995    18.399     0.200
     1.007    17.824     0.200
     1.051    19.977     0.200
     1.183    20.676     0.200
     1.308    21.005     0.200
     1.359    22.732     0.200
     1.417    23.715     0.200
     1.402    23.235     0.200
     1.508    24.324     0.200
     1.627    26.327     0.200
     1.700    26.712     0.200
     1.773    27.287     0.200
     1.738    28.606     0.200
     1.776    27.906     0.200
     1.894    28.162     0.200
     1.895    28.433     0.200
     1.894    28.539     0.200
     1.894    30.339     0.200
     1.896    28.687     0.200
     2.086    30.520     0.200
     2.253    36.098     0.200
     2.316    35.963     0.200
     2.554    34.357     0.200
     2.790    42.656     0.200
     2.801    41.908     0.200
     2.873    42.343     0.200
     3.004    44.339     0.200
     3.006    44.269     0.200
     3.146    46.832     0.200
     3.152    45.909     0.200
     3.388    46.595     0.200
     3.513    50.814     0.200
     3.550    51.115     0.200
     3.606    52.315     0.200
     3.883    54.428     0.200
     3.943    54.570     0.200
     3.943    55.970     0.200
     4.556    63.693     0.200
     0.842    15.860     0.200
     0.878    16.613     0.200
     1.348    21.976     0.200
     2.880    42.596     0.200
     4.324    59.451     0.200
     4.835    66.398     0.200
     5.082    69.367     0.200
     5.145    70.289     0.200
     5.145    70.384     0.200
     5.829    78.862     0.200
    14.872   194.181     0.200
    17.304   231.880     0.200
    17.640   235.227     0.200
     2.919    42.724     0.200
     5.094    69.273     0.200
     5.157    70.436     0.200
     0.493    10.370     0.200
     0.736    15.307     0.200
     1.415    22.365     0.200
     1.531    24.960     0.200
     1.671    25.002     0.200
     2.324    35.673     0.200
     2.534    38.084     0.200
     2.875    41.177     0.200
     2.875    42.547     0.200
     3.716    52.566     0.200
     5.085    69.623     0.200
     5.148    70.688     0.200
     0.518    10.823     0.200
     1.432    22.889     0.200
     1.654    25.818     0.200
     2.077    33.224     0.200
     2.152    33.491     0.200
     2.896    41.399     0.200
     1.045    19.501     0.200
     1.046    19.565     0.200
     1.046    19.653     0.200
     1.046    19.472     0.200
     1.047    19.756     0.200
     1.048    19.550     0.200
     1.049    19.815     0.200
     1.050    19.441     0.200
     1.050    19.634     0.200
     1.060    19.308     0.200
     1.165    22.970     0.200
     1.163    21.510     0.200
     1.266    23.951     0.200
     1.311    23.284     0.200
     1.726    28.509     0.200
     2.557    40.364     0.200
     3.711    55.283     0.200
     0.846    16.046     0.200
     0.924    17.196     0.200
     0.973    18.024     0.200
     0.999    17.821     0.200
     1.946    28.763     0.200
     0.927    17.187     0.200
     0.981    17.940     0.200
     0.990    18.573     0.200
     0.999    17.858     0.200
     2.759    42.339     0.200
     0.752    15.303     0.200
     0.867    18.239     0.200
     0.893    17.837     0.200
     1.063    19.647     0.200
     1.237    23.300     0.200
     1.355    23.143     0.200
     1.563    24.691     0.200
     1.768    28.972     0.200
     2.271    36.329     0.200
     2.331    37.678     0.200
     2.426    38.829     0.200
     2.608    41.502     0.200
     2.663    40.871     0.200
     2.898    44.896     0.200
     2.898    45.049     0.200
     3.100    45.545     0.200
     3.100    45.389     0.200
     0.471     9.645     0.200
     0.637    12.522     0.200
     1.182    19.273     0.200
     1.156    19.357     0.200
     1.465    23.453     0.200
     1.480    23.814     0.200
     1.838    29.272     0.200
     2.275    34.086     0.200
     2.419    38.149     0.200
     2.696    39.082     0.200
     2.853    42.614     0.200
     2.853    42.750     0.200
     3.017    44.819     0.200
     3.915    53.337     0.200
     4.038    55.599     0.200
     4.417    60.525     0.200
     4.459    60.985     0.200
     4.557    62.124     0.200
     4.799    64.985     0.200
     4.799    64.415     0.200
     4.862    66.363     0.200
     4.862    65.820     0.200
     5.094    70.204     0.200
     0.122     9.489     0.200
     0.271     9.995     0.200
     0.286     9.800     0.200
     0.316    10.812     0.200
     0.523    11.971     0.200
     0.602    12.896     0.200
     0.812    15.747     0.200
     0.883    17.736     0.200
     0.984    18.497     0.200
     1.047    18.648     0.200
     1.112    19.791     0.200
     1.141    20.410     0.200
     1.279    22.739     0.200
     1.542    25.095     0.200
     1.571    24.466     0.200
     1.593    25.666     0.200
     1.593    25.683     0.200
     1.595    25.641     0.200
     1.595    25.935     0.200
     1.595    25.826     0.200
     1.765    27.374     0.200
     1.881    29.579     0.200
     2.044    33.334     0.200
     2.053    33.794     0.200
     2.132    32.354     0.200
     2.411    38.491     0.200
     2.448    36.223     0.200
     2.558    35.767     0.200
     2.574    39.307     0.200
     3.014    42.252     0.200
     3.381    48.184     0.200
     3.367    46.782     0.200
     3.585    51.011     0.200
     3.585    51.462     0.200
     3.605    51.995     0.200
     3.891    56.681     0.200
     4.313    60.067     0.200
     4.386    63.350     0.200
     4.665    63.358     0.200
     5.300    71.945     0.200
     5.581    74.290     0.200
     5.856    80.343     0.200
     5.847    77.001     0.200
     6.150    84.370     0.200
     6.646    91.487     0.200
     0.641    14.013     0.200
     0.666    15.403     0.200
     0.779    17.311     0.200
     0.842    18.070     0.200
     0.921    17.911     0.200
     1.115    21.029     0.200
     1.115    21.158     0.200
     1.114    21.118     0.200
     1.114    21.219     0.200
     2.205    34.819     0.200
     0.218     9.116     0.200
     0.337    10.143     0.200
     0.345    10.060     0.200
     0.420    10.697     0.200
     0.526    12.062     0.200
     0.535    11.521     0.200
     0.781    14.660     0.200
     0.782    14.273     0.200
     0.798    15.120     0.200
     0.792    15.657     0.200
     0.878    17.127     0.200
     0.885    16.150     0.200
     0.938    16.609     0.200
     1.043    19.432     0.200
     1.079    19.219     0.200
     1.162    20.836     0.200
     1.303    21.763     0.200
     1.331    22.864     0.200
     1.349    23.571     0.200
     1.413    24.019     0.200
     1.629    25.939     0.200
     1.693    27.104     0.200
     1.830    28.076     0.200
     1.830    28.094     0.200
     1.830    28.116     0.200
     1.830    28.100     0.200
     1.831    28.405     0.200
     1.831    28.242     0.200
     1.832    28.109     0.200
     1.874    28.925     0.200
     1.958    30.580     0.200
     2.011    30.656     0.200
     3.000    44.256     0.200
     3.126    45.101     0.200
     3.737    53.442     0.200
     3.843    53.692     0.200
     0.204     9.564     0.200
     0.252     9.519     0.200
     0.281     9.608     0.200
     0.281     9.720     0.200
     0.322     9.699     0.200
     0.392    10.462     0.200
     0.404    11.275     0.200
     0.424    10.932     0.200
     0.642    13.920     0.200
     0.707    14.081     0.200
     0.761    14.764     0.200
     0.800    15.623     0.200
     0.800    15.808     0.200
     0.807    16.289     0.200
     0.831    16.287     0.200
     0.850    16.732     0.200
     0.844    16.501     0.200
     0.935    18.156     0.200
     1.038    19.185     0.200
     1.129    20.204     0.200
     1.282    23.145     0.200
     1.321    23.258     0.200
     1.434    22.863     0.200
     1.459    23.494     0.200
     1.778    29.252     0.200
     2.538    39.324     0.200
     0.488    10.449     0.200
     0.488    11.066     0.200
     0.520    11.036     0.200
     0.650    12.870     0.200
     0.687    13.344     0.200
     0.687    13.500     0.200
     1.090    17.748     0.200
     1.183    19.933     0.200
     1.408    22.682     0.200
     1.535    24.266     0.200
     1.580    25.529     0.200
     1.580    25.605     0.200
     1.701    26.451     0.200
     1.828    28.554     0.200
     1.887    30.340     0.200
     2.068    30.693     0.200
     2.043    31.776     0.200
     2.043    31.942     0.200
     2.043    32.096     0.200
     2.045    31.972     0.200
     2.167    32.513     0.200
     2.183    34.177     0.200
     2.632    40.570     0.200
     2.670    41.893     0.200
     2.918    43.912     0.200
     2.929    45.346     0.200
     2.929    44.565     0.200
     3.483    49.636     0.200
     3.484    52.164     0.200
     4.238    61.548     0.200
     4.550    62.327     0.200
     4.961    68.236     0.200
     5.440    74.805     0.200
     0.035     8.905     0.200
     0.035     9.065     0.200
     0.066     8.439     0.200
     0.302     9.367     0.200
     0.299     9.058     0.200
     0.300     8.977     0.200
     0.521    11.062     0.200
     0.710    14.977     0.200
     0.829    15.518     0.200
     0.859    15.868     0.200
     0.859    15.532     0.200
     0.934    17.051     0.200
     0.934    16.932     0.200
     1.003    17.561     0.200
     1.036    18.957     0.200
     1.036    18.739     0.200
     1.049    18.643     0.200
     1.219    20.151     0.200
     1.238    21.707     0.200
     1.326    21.849     0.200
     1.411    23.141     0.200
     1.410    23.236     0.200
     1.411    23.135     0.200
     1.413    23.183     0.200
     1.413    23.402     0.200
     1.566    24.249     0.200
     1.931    25.723     0.200
     3.600    50.649     0.200
     5.617    80.022     0.200
     0.299    10.125     0.200
     0.340    10.263     0.200
     0.463    11.181     0.200
     0.463    11.351     0.200
     0.462    11.326     0.200
     0.659    14.342     0.200
     0.655    14.313     0.200
     0.779    16.091     0.200
     0.966    18.579     0.200
     0.966    18.179     0.200
     0.943    17.012     0.200
     0.941    18.252     0.200
     1.107    19.644     0.200
     1.067    19.009     0.200
     1.173    20.802     0.200
     1.220    21.867     0.200
     1.266    20.844     0.200
     1.434    22.595     0.200
     1.786    27.828     0.200
     1.844    30.284     0.200
     1.867    29.405     0.200
     1.947    29.966     0.200
     2.233    32.799     0.200
     2.409    35.813     0.200
     2.622    38.883     0.200
     2.745    36.962     0.200
     2.986    41.476     0.200
     3.395    47.806     0.200
     3.488    49.165     0.200
     4.266    59.711     0.200
     0.260     8.985     0.200
     0.401     9.557     0.200
     0.449    10.381     0.200
     0.500    10.546     0.200
     0.566    10.844     0.200
     0.595    11.805     0.200
     0.596    11.992     0.200
     0.961    16.633     0.200
     1.036    17.604     0.200
     1.056    17.793     0.200
     1.124    19.312     0.200
     1.255    21.043     0.200
     1.245    20.745     0.200
     1.245    20.723     0.200
     1.481    20.186     0.200
     1.436    23.910     0.200
     1.441    23.667     0.200
     1.461    23.258     0.200
     1.550    25.058     0.200
     1.668    26.991     0.200
     1.792    27.285     0.200
     1.922    30.466     0.200
     2.253    33.970     0.200
     2.341    35.999     0.200
     2.422    35.827     0.200
     2.390    35.492     0.200
     2.489    38.908     0.200
     2.679    38.940     0.200
     3.039    44.912     0.200
     3.070    45.486     0.200
     3.098    46.896     0.200
     3.781    53.743     0.200
     3.843    56.104     0.200
     4.252    62.223     0.200
     4.679    64.294     0.200
     5.089    69.402     0.200
     0.076     9.123     0.200
     0.244     8.483     0.200
     0.244     8.303     0.200
     0.254     8.514     0.200
     0.559    11.946     0.200
     0.559    11.688     0.200
     0.560    12.041     0.200
     0.560    11.721     0.200
     0.575    12.359     0.200
     0.575    12.187     0.200
     0.576    12.473     0.200
     0.576    12.247     0.200
     0.609    12.527     0.200
     0.702    14.255     0.200
     0.702    13.868     0.200
     0.806    15.011     0.200
     0.806    14.711     0.200
     0.856    15.749     0.200
     0.856    15.311     0.200
     0.838    16.500     0.200
     0.856    15.521     0.200
     0.857    15.496     0.200
     0.857    15.386     0.200
     0.860    15.718     0.200
     0.897    15.969     0.200
     0.897    15.860     0.200
     0.963    17.681     0.200
     0.970    18.052     0.200
     1.074    19.291     0.200
     1.259    21.955     0.200
     1.336    23.451     0.200
     1.373    23.126     0.200
     1.391    23.342     0.200
     1.662    26.850     0.200
     1.737    26.415     0.200
     1.972    29.425     0.200
     2.103    33.017     0.200
     2.374    36.234     0.200
     2.914    44.235     0.200
     1.154    19.333     0.200
     1.247    20.323     0.200
     4.083    57.026     0.200
     7.049    99.923     0.200
     0.505    10.582     0.200
     0.654    13.395     0.200
     0.679    14.003     0.200
     0.788    14.724     0.200
     0.841    15.458     0.200
     0.906    16.145     0.200
     0.166     8.199     0.200
     0.210     8.097     0.200
     0.320     9.340     0.200
     0.344     9.261     0.200
     0.355    10.101     0.200
     0.414    10.189     0.200
     0.414    10.337     0.200
     0.493    11.223     0.200
     0.772    14.921     0.200
     0.801    15.723     0.200
     0.866    17.048     0.200
     0.903    16.654     0.200
     0.912    17.784     0.200
     0.949    17.813     0.200
     1.120    20.804     0.200
     1.281    22.790     0.200
     1.349    24.080     0.200
     1.385    24.522     0.200
     1.544    25.831     0.200
     0.212     8.758     0.200
     0.235     9.686     0.200
     0.219     9.181     0.200
     0.219     9.411     0.200
     0.270     9.986     0.200
     0.219     9.238     0.200
     0.310    10.332     0.200
     0.332    10.857     0.200
     0.354     9.959     0.200
     0.354    10.039     0.200
     0.509    11.356     0.200
     0.509    11.486     0.200
     0.459    11.762     0.200
     0.597    12.773     0.200
     0.675    14.087     0.200
     0.763    14.592     0.200
     0.763    14.432     0.200
     0.782    14.992     0.200
     0.836    15.666     0.200
     0.836    15.306     0.200
     0.836    15.704     0.200
     0.829    15.489     0.200
     0.829    15.209     0.200
     0.864    15.645     0.200
     0.935    17.098     0.200
     0.965    16.608     0.200
     1.000    17.279     0.200
     1.001    17.929     0.200
     1.001    17.300     0.200
     1.001    17.769     0.200
     1.003    17.295     0.200
     1.050    17.891     0.200
     1.050    18.131     0.200
     1.070    18.528     0.200
     1.158    19.776     0.200
     1.158    19.956     0.200
     1.173    20.083     0.200
     1.127    19.801     0.200
     1.127    19.671     0.200
     1.248    21.333     0.200
     1.275    21.456     0.200
     1.340    21.757     0.200
     1.365    21.013     0.200
     1.575    24.889     0.200
     1.621    26.342     0.200
     1.641    26.431     0.200
     1.696    25.819     0.200
     1.862    30.107     0.200
     1.860    29.602     0.200
     1.938    29.915     0.200
     1.955    30.341     0.200
     1.999    31.557     0.200
     2.022    30.979     0.200
     2.361    36.537     0.200
     2.346    34.970     0.200
     2.441    36.637     0.200
     2.510    37.389     0.200
     2.525    37.705     0.200
     2.564    37.432     0.200
     2.922    41.468     0.200
     2.964    40.129     0.200
     3.008    42.829     0.200
     3.201    45.716     0.200
     3.430    48.262     0.200
     0.069     8.421     0.200
     0.259     8.698     0.200
     0.393     9.995     0.200
     0.523    12.052     0.200
     0.587    12.008     0.200
     0.593    12.329     0.200
     0.593    12.110     0.200
     0.673    13.657     0.200
     0.859    15.755     0.200
     0.860    15.805     0.200
     0.906    17.206     0.200
     0.950    18.296     0.200
     3.111    44.319     0.200
     3.140    44.888     0.200
     5.541    73.604     0.200
     5.541    73.316     0.200
     7.946   110.226     0.200
     0.492    10.846     0.200
     0.492    10.956     0.200
     0.492    11.128     0.200
     0.492    10.894     0.200
     0.490    12.145     0.200
     0.536    11.007     0.200
     0.566    12.178     0.200
     0.566    12.283     0.200
     0.599    12.441     0.200
     0.599    12.535     0.200
     2.356    35.574     0.200
     2.708    40.277     0.200
     2.959    43.558     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
    10.089   203.412     0.200
    15.217   298.665     0.200
     2.973    56.117     0.200
     6.079   118.167     0.200
     9.251   180.749     0.200
    18.856   375.094     0.200
    19.228   382.727     0.200
     4.124    76.254     0.200
     5.106    95.677     0.200
    14.978   296.359     0.200
     2.538    46.758     0.200
     2.761    50.835     0.200
     3.389    63.140     0.200
     3.618    68.111     0.200
     5.181    96.388     0.200
     6.778   124.176     0.200
     9.103   174.724     0.200
     3.854    73.252     0.200
     5.703   107.768     0.200
     2.548    52.160     0.200
     2.548    51.026     0.200
     2.853    54.898     0.200
     3.626    69.938     0.200
     4.023    74.797     0.200
     5.266   103.514     0.200
     5.699   110.786     0.200
     5.927   115.389     0.200
     6.245   124.214     0.200
     6.723   131.835     0.200
     7.573   146.878     0.200
     8.683   169.047     0.200
     8.705   168.837     0.200
     8.949   176.227     0.200
     9.238   175.321     0.200
     9.446   180.755     0.200
     9.470   180.581     0.200
     9.735   192.630     0.200
    10.224   206.112     0.200
    12.136   236.201     0.200
    12.892   259.662     0.200
    13.219   270.246     0.200
    13.876   273.164     0.200
    14.785   293.720     0.200
    14.810   294.312     0.200
    14.872   286.681     0.200
    14.926   293.436     0.200
    14.929   292.981     0.200
    18.654   372.220     0.200
    19.255   386.112     0.200
    19.255   378.440     0.200
    20.052   397.111     0.200
    20.140   388.152     0.200
    20.140   392.567     0.200
    28.782   557.501     0.200
     2.985    55.248     0.200
     3.367    61.507     0.200
     5.768   110.392     0.200
     9.612   184.722     0.200
    14.696   281.804     0.200
    19.255   377.788     0.200
    19.277   368.056     0.200
    19.571   384.724     0.200
     3.600    61.224     0.200
     9.832   187.740     0.200
     4.083    79.807     0.200
     5.378   103.298     0.200
    10.303   202.746     0.200
    15.161   292.300     0.200
    19.097   370.097     0.200
     3.140    55.989     0.200
     9.441   177.904     0.200
    14.731   284.687     0.200
    19.009   371.862     0.200
    19.426   376.198     0.200
    19.587   381.126     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.980    17.671     0.200
     1.387    24.042     0.200
     1.438    24.904     0.200
     1.406    23.713     0.200
     1.652    28.269     0.200
     2.930    51.127     0.200
     0.837    15.298     0.200
     0.925    16.852     0.200
     1.117    20.691     0.200
     1.364    25.464     0.200
     1.558    29.471     0.200
     2.182    40.725     0.200
     2.267    40.995     0.200
     1.282    22.341     0.200
     1.508    25.860     0.200
     1.510    26.535     0.200
     1.538    25.967     0.200
     1.780    30.739     0.200
     3.027    48.517     0.200
     1.508    25.762     0.200
     1.528    27.083     0.200
     1.648    28.393     0.200
     0.449     8.651     0.200
     0.506    11.604     0.200
     0.863    14.706     0.200
     0.896    15.623     0.200
     0.966    17.679     0.200
     1.269    22.250     0.200
     1.313    24.129     0.200
     1.392    23.951     0.200
     1.628    28.968     0.200
     1.770    29.260     0.200
     1.886    33.501     0.200
     2.181    38.257     0.200
     2.242    38.650     0.200
     2.612    46.156     0.200
     2.676    48.965     0.200
     2.794    48.807     0.200
     2.924    50.671     0.200
     3.095    52.369     0.200
     3.688    64.121     0.200
     0.378     8.240     0.200
     0.467    10.785     0.200
     1.113    19.970     0.200
     1.177    20.285     0.200
     1.213    21.196     0.200
     1.318    23.138     0.200
     1.583    28.312     0.200
     1.735    30.144     0.200
     1.826    32.795     0.200
     2.135    38.980     0.200
     2.185    38.928     0.200
     2.560    45.460     0.200
     2.625    48.144     0.200
     2.618    46.517     0.200
     2.744    48.379     0.200
     2.744    49.078     0.200
     3.045    54.792     0.200
     3.790    64.370     0.200
     0.319     8.723     0.200
     0.319     8.594     0.200
     0.731    13.830     0.200
     0.811    15.059     0.200
     0.824    15.021     0.200
     1.142    19.606     0.200
     1.246    21.552     0.200
     1.384    23.762     0.200
     1.459    24.394     0.200
     1.506    26.494     0.200
     1.662    28.128     0.200
     1.726    28.842     0.200
     1.898    31.116     0.200
     0.994    18.659     0.200
     1.005    18.503     0.200
     1.279    21.775     0.200
     1.278    22.452     0.200
     1.341    23.914     0.200
     1.499    26.100     0.200
     0.408     9.791     0.200
     1.111    20.063     0.200
     1.195    20.985     0.200
     1.266    23.032     0.200
     1.257    22.732     0.200
     1.342    24.079     0.200
     1.529    27.230     0.200
     1.806    31.614     0.200
     2.880    49.768     0.200
     2.880    49.237     0.200
     0.451    10.571     0.200
     0.554    10.803     0.200
     0.900    15.657     0.200
     1.175    21.454     0.200
     2.919    49.208     0.200
     0.392     9.937     0.200
     0.823    15.020     0.200
     0.863    16.690     0.200
     0.837    16.274     0.200
     1.023    18.730     0.200
     1.059    19.190     0.200
     1.092    19.719     0.200
     1.143    20.543     0.200
     1.183    21.321     0.200
     1.247    22.361     0.200
     1.341    22.870     0.200
     1.323    22.662     0.200
     0.403    10.300     0.200
     0.845    15.336     0.200
     0.889    16.740     0.200
     1.047    19.548     0.200
     1.072    19.354     0.200
     1.114    20.180     0.200
     1.209    21.242     0.200
     1.265    22.102     0.200
     1.266    22.940     0.200
     1.363    23.067     0.200
     1.803    29.561     0.200
     2.896    50.376     0.200
     0.456     9.511     0.200
     0.629    12.743     0.200
     0.784    15.439     0.200
     0.792    15.438     0.200
     0.993    18.655     0.200
     1.046    18.903     0.200
     1.165    19.908     0.200
     1.441    26.829     0.200
     1.501    27.007     0.200
     1.525    27.762     0.200
     1.576    29.026     0.200
     1.834    33.566     0.200
     2.013    37.300     0.200
     2.287    38.314     0.200
     3.007    49.830     0.200
     0.132     4.399     0.200
     0.152     4.488     0.200
     0.219     5.343     0.200
     0.388     7.308     0.200
     0.400     8.340     0.200
     0.537    10.348     0.200
     0.601    11.655     0.200
     0.697    13.184     0.200
     0.750    14.175     0.200
     0.821    14.868     0.200
     0.897    15.890     0.200
     0.915    16.370     0.200
     1.244    22.753     0.200
     1.256    22.558     0.200
     1.260    22.816     0.200
     1.444    26.208     0.200
     1.479    26.253     0.200
     1.480    26.136     0.200
     1.480    26.389     0.200
     1.480    26.058     0.200
     1.480    26.558     0.200
     1.481    26.768     0.200
     1.481    26.432     0.200
     1.481    26.347     0.200
     1.482    26.468     0.200
     1.483    26.768     0.200
     1.484    26.494     0.200
     1.539    27.445     0.200
     1.628    29.073     0.200
     1.643    29.030     0.200
     1.667    28.627     0.200
     1.678    29.202     0.200
     1.679    28.949     0.200
     2.021    34.391     0.200
     2.036    34.240     0.200
     0.126     4.725     0.200
     0.145     4.640     0.200
     0.222     5.246     0.200
     0.384     8.151     0.200
     0.408     8.365     0.200
     0.540    10.575     0.200
     0.601    11.599     0.200
     0.705    13.050     0.200
     0.743    14.115     0.200
     0.829    15.215     0.200
     0.850    15.766     0.200
     0.896    15.931     0.200
     0.911    16.186     0.200
     1.248    22.858     0.200
     1.256    22.221     0.200
     1.258    22.553     0.200
     1.441    25.276     0.200
     1.478    26.271     0.200
     1.479    26.226     0.200
     1.479    25.900     0.200
     1.478    26.389     0.200
     1.480    26.275     0.200
     1.480    26.228     0.200
     1.480    26.092     0.200
     1.481    26.467     0.200
     1.482    26.337     0.200
     1.483    26.505     0.200
     1.542    27.718     0.200
     1.628    29.103     0.200
     1.641    28.870     0.200
     1.686    29.040     0.200
     2.041    35.668     0.200
     1.329    23.817     0.200
     1.336    24.553     0.200
     1.259    21.201     0.200
     1.489    25.304     0.200
     1.531    26.812     0.200
     1.517    26.064     0.200
     1.579    26.763     0.200
     1.605    27.732     0.200
     1.630    27.653     0.200
     1.767    29.429     0.200
     1.836    32.146     0.200
     2.498    41.177     0.200
     0.925    16.228     0.200
     0.930    17.526     0.200
     1.348    23.494     0.200
     1.532    25.891     0.200
     0.194     6.389     0.200
     0.467    10.985     0.200
     1.204    22.441     0.200
     1.205    22.328     0.200
     1.205    22.480     0.200
     1.205    22.382     0.200
     1.206    22.540     0.200
     1.209    22.706     0.200
     1.232    22.643     0.200
     1.291    22.948     0.200
     1.317    22.877     0.200
     1.310    23.084     0.200
     1.310    23.194     0.200
     1.415    24.912     0.200
     1.454    26.374     0.200
     1.530    26.989     0.200
     1.567    27.713     0.200
     1.875    31.336     0.200
     1.906    32.216     0.200
     1.936    32.650     0.200
     2.126    35.011     0.200
     0.286     8.847     0.200
     0.916    16.639     0.200
     0.917    16.759     0.200
     0.917    16.626     0.200
     1.183    20.105     0.200
     1.182    21.155     0.200
     1.182    21.319     0.200
     1.305    22.392     0.200
     1.604    26.270     0.200
     1.569    25.842     0.200
     1.604    26.921     0.200
     1.708    28.692     0.200
     0.275     8.372     0.200
     0.275     8.207     0.200
     0.275     8.382     0.200
     0.275     8.265     0.200
     0.434     9.926     0.200
     0.434     9.722     0.200
     0.513    10.814     0.200
     0.704    13.735     0.200
     0.704    13.164     0.200
     0.672    14.036     0.200
     0.704    13.180     0.200
     0.746    14.151     0.200
     0.746    13.792     0.200
     0.740    15.395     0.200
     1.034    17.805     0.200
     1.109    19.476     0.200
     1.155    19.807     0.200
     1.230    21.730     0.200
     1.240    21.625     0.200
     1.349    23.441     0.200
     1.478    24.732     0.200
     0.113     7.572     0.200
     0.112     7.577     0.200
     0.112     7.708     0.200
     0.183     7.670     0.200
     0.214     7.627     0.200
     0.350     9.182     0.200
     0.350     9.291     0.200
     0.393     9.226     0.200
     0.393     9.237     0.200
     0.659    12.954     0.200
     0.726    14.331     0.200
     0.727    14.290     0.200
     0.861    15.917     0.200
     0.921    16.866     0.200
     1.003    17.867     0.200
     1.011    18.832     0.200
     1.106    20.130     0.200
     1.130    20.475     0.200
     1.126    21.015     0.200
     1.202    21.100     0.200
     1.202    21.097     0.200
     1.203    21.175     0.200
     1.204    21.255     0.200
     1.354    23.653     0.200
     1.513    25.764     0.200
     0.333     7.609     0.200
     0.409     8.654     0.200
     0.538    11.220     0.200
     1.076    18.863     0.200
     1.103    20.193     0.200
     1.129    20.510     0.200
     1.197    21.679     0.200
     1.228    22.793     0.200
     1.500    26.436     0.200
     1.514    26.533     0.200
     2.064    33.752     0.200
     0.303     8.517     0.200
     0.274     7.895     0.200
     0.304     8.640     0.200
     0.290     9.117     0.200
     0.386    10.346     0.200
     0.638    13.102     0.200
     0.674    13.381     0.200
     0.674    13.778     0.200
     0.674    13.494     0.200
     0.715    15.205     0.200
     0.715    15.394     0.200
     0.751    14.812     0.200
     0.784    15.902     0.200
     0.784    15.523     0.200
     0.814    15.925     0.200
     0.815    15.971     0.200
     0.796    14.755     0.200
     0.800    16.483     0.200
     0.901    18.053     0.200
     0.905    17.342     0.200
     0.901    17.594     0.200
     0.902    17.043     0.200
     0.894    16.382     0.200
     0.904    16.907     0.200
     0.909    16.656     0.200
     0.909    16.393     0.200
     0.942    17.124     0.200
     1.034    19.173     0.200
     1.088    20.784     0.200
     1.106    20.197     0.200
     1.092    20.257     0.200
     1.168    21.373     0.200
     1.201    22.375     0.200
     1.218    22.962     0.200
     1.250    23.088     0.200
     1.217    22.715     0.200
     1.412    24.680     0.200
     1.420    24.652     0.200
     1.460    26.092     0.200
     1.477    26.900     0.200
     1.622    29.286     0.200
     1.766    30.763     0.200
     1.841    32.992     0.200
     1.871    32.275     0.200
     1.924    32.807     0.200
     1.949    34.679     0.200
     1.961    35.144     0.200
     2.285    38.441     0.200
     2.337    40.115     0.200
     2.360    39.567     0.200
     2.521    44.545     0.200
     2.755    47.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
