#!/bin/bash
gmt begin tofino1.52_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance tofino1.52'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.500     9.801
     0.600    11.219
     0.700    12.638
     0.800    14.057
     0.900    15.476
     1.000    16.894
     1.100    18.313
     1.200    19.732
     1.300    21.150
     1.400    22.569
     1.500    23.988
     1.600    25.407
     1.700    26.825
     1.800    28.244
     1.900    29.663
     2.000    31.081
     2.100    32.500
     2.200    33.919
     2.300    35.338
     2.400    36.756
     2.500    38.175
     2.600    39.594
     2.700    41.012
     2.800    42.431
     2.900    43.850
     3.000    45.269
     3.100    46.687
     3.200    48.106
     3.300    49.525
     3.400    50.943
     3.500    52.362
     3.600    53.780
     3.700    55.198
     3.800    56.616
     3.900    58.034
     4.000    59.452
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    51.780 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.884
     0.200     5.728
     0.300     6.904
     0.400     8.268
     0.500     9.737
     0.600    11.268
     0.700    12.835
     0.800    14.425
     0.900    16.031
     1.000    17.648
     1.100    19.272
     1.200    20.902
     1.300    22.536
     1.400    24.173
     1.500    25.812
     1.600    27.454
     1.700    29.097
     1.800    30.742
     1.900    32.388
     2.000    34.034
     2.100    35.681
     2.200    37.329
     2.300    38.978
     2.400    40.627
     2.500    42.276
     2.600    43.926
     2.700    45.576
     2.800    47.227
     2.900    48.877
     3.000    50.528
     3.100    52.179
     3.200    53.830
     3.300    55.481
     3.400    57.133
     3.500    58.784
     3.600    60.436
     3.700    62.088
     3.800    63.740
     3.900    65.391
     4.000    67.043
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    59.436 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.500    16.776
     0.600    19.246
     0.700    21.716
     0.800    24.186
     0.900    26.656
     1.000    29.126
     1.100    31.596
     1.200    34.066
     1.300    36.536
     1.400    39.006
     1.500    41.476
     1.600    43.946
     1.700    46.416
     1.800    48.886
     1.900    51.356
     2.000    53.826
     2.100    56.296
     2.200    58.766
     2.300    61.236
     2.400    63.706
     2.500    66.176
     2.600    68.646
     2.700    71.116
     2.800    73.586
     2.900    76.056
     3.000    78.526
     3.100    80.996
     3.200    83.465
     3.300    85.934
     3.400    88.402
     3.500    90.871
     3.600    93.340
     3.700    95.808
     3.800    98.277
     3.900   100.745
     4.000   103.214
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    91.340 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     8.333
     0.200     9.774
     0.300    11.785
     0.400    14.120
     0.500    16.636
     0.600    19.259
     0.700    21.947
     0.800    24.676
     0.900    27.432
     1.000    30.208
     1.100    32.997
     1.200    35.796
     1.300    38.602
     1.400    41.413
     1.500    44.230
     1.600    47.049
     1.700    49.872
     1.800    52.697
     1.900    55.524
     2.000    58.352
     2.100    61.182
     2.200    64.013
     2.300    66.845
     2.400    69.678
     2.500    72.511
     2.600    75.346
     2.700    78.180
     2.800    81.015
     2.900    83.851
     3.000    86.687
     3.100    89.523
     3.200    92.360
     3.300    95.197
     3.400    98.034
     3.500   100.871
     3.600   103.708
     3.700   106.546
     3.800   109.384
     3.900   112.221
     4.000   115.059
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   102.708 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    13.886
     0.800    15.304
     0.900    16.723
     1.000    18.142
     1.100    19.560
     1.200    20.979
     1.300    22.398
     1.400    23.816
     1.500    25.235
     1.600    26.654
     1.700    28.073
     1.800    29.491
     1.900    30.910
     2.000    32.329
     2.100    33.747
     2.200    35.166
     2.300    36.585
     2.400    38.004
     2.500    39.422
     2.600    40.841
     2.700    42.260
     2.800    43.678
     2.900    45.097
     3.000    46.516
     3.100    47.934
     3.200    49.353
     3.300    50.772
     3.400    52.191
     3.500    53.609
     3.600    55.028
     3.700    56.446
     3.800    57.865
     3.900    59.283
     4.000    60.701
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     2.815
     0.200     4.221
     0.300     5.819
     0.400     7.458
     0.500     9.107
     0.600    10.760
     0.700    12.414
     0.800    14.068
     0.900    15.724
     1.000    17.379
     1.100    19.035
     1.200    20.691
     1.300    22.347
     1.400    24.003
     1.500    25.660
     1.600    27.316
     1.700    28.972
     1.800    30.628
     1.900    32.285
     2.000    33.941
     2.100    35.597
     2.200    37.253
     2.300    38.909
     2.400    40.565
     2.500    42.221
     2.600    43.878
     2.700    45.534
     2.800    47.190
     2.900    48.846
     3.000    50.502
     3.100    52.158
     3.200    53.814
     3.300    55.470
     3.400    57.126
     3.500    58.782
     3.600    60.438
     3.700    62.094
     3.800    63.749
     3.900    65.405
     4.000    67.061
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    23.777
     0.800    26.247
     0.900    28.717
     1.000    31.187
     1.100    33.657
     1.200    36.127
     1.300    38.597
     1.400    41.066
     1.500    43.536
     1.600    46.006
     1.700    48.476
     1.800    50.946
     1.900    53.416
     2.000    55.886
     2.100    58.356
     2.200    60.826
     2.300    63.296
     2.400    65.766
     2.500    68.236
     2.600    70.706
     2.700    73.176
     2.800    75.646
     2.900    78.116
     3.000    80.586
     3.100    83.056
     3.200    85.526
     3.300    87.996
     3.400    90.465
     3.500    92.934
     3.600    95.403
     3.700    97.872
     3.800   100.341
     3.900   102.809
     4.000   105.278
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     4.766
     0.200     7.154
     0.300     9.885
     0.400    12.697
     0.500    15.528
     0.600    18.366
     0.700    21.208
     0.800    24.050
     0.900    26.894
     1.000    29.738
     1.100    32.583
     1.200    35.428
     1.300    38.273
     1.400    41.118
     1.500    43.963
     1.600    46.808
     1.700    49.653
     1.800    52.499
     1.900    55.344
     2.000    58.189
     2.100    61.035
     2.200    63.880
     2.300    66.725
     2.400    69.570
     2.500    72.415
     2.600    75.261
     2.700    78.106
     2.800    80.951
     2.900    83.796
     3.000    86.641
     3.100    89.486
     3.200    92.331
     3.300    95.176
     3.400    98.021
     3.500   100.866
     3.600   103.710
     3.700   106.555
     3.800   109.400
     3.900   112.244
     4.000   115.088
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100     7.045
     0.200     7.574
     0.300     8.378
     0.400     9.381
     0.500    10.520
     0.600    11.751
     0.700    13.042
     0.800    14.370
     0.900    15.724
     1.000    17.095
     1.100    18.476
     1.200    19.866
     1.300    21.261
     1.400    22.660
     1.500    24.063
     1.600    25.467
     1.700    26.873
     1.800    28.281
     1.900    29.690
     2.000    31.100
     2.100    32.511
     2.200    33.922
     2.300    35.334
     2.400    36.747
     2.500    38.159
     2.600    39.572
     2.700    40.986
     2.800    42.400
     2.900    43.813
     3.000    45.227
     3.100    46.642
     3.200    48.056
     3.300    49.470
     3.400    50.885
     3.500    52.299
     3.600    53.714
     3.700    55.129
     3.800    56.544
     3.900    57.959
     4.000    59.374
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100    12.098
     0.200    13.008
     0.300    14.393
     0.400    16.124
     0.500    18.092
     0.600    20.221
     0.700    22.456
     0.800    24.760
     0.900    27.110
     1.000    29.490
     1.100    31.892
     1.200    34.308
     1.300    36.734
     1.400    39.168
     1.500    41.607
     1.600    44.051
     1.700    46.498
     1.800    48.947
     1.900    51.398
     2.000    53.852
     2.100    56.307
     2.200    58.763
     2.300    61.219
     2.400    63.677
     2.500    66.136
     2.600    68.594
     2.700    71.054
     2.800    73.514
     2.900    75.974
     3.000    78.434
     3.100    80.895
     3.200    83.356
     3.300    85.817
     3.400    88.278
     3.500    90.740
     3.600    93.201
     3.700    95.663
     3.800    98.124
     3.900   100.586
     4.000   103.048
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     0.980    16.422     0.200
     1.424    22.910     0.200
     1.576    24.801     0.200
     1.609    26.000     0.200
     1.703    26.711     0.200
     1.813    29.211     0.200
     1.923    30.672     0.200
     2.019    31.449     0.200
     2.101    32.121     0.200
     2.307    35.352     0.200
     2.555    39.281     0.200
     2.535    38.910     0.200
     2.683    41.262     0.200
     2.718    41.531     0.200
     2.782    42.711     0.200
     2.952    44.020     0.200
     2.932    44.340     0.200
     3.036    46.281     0.200
     3.119    46.961     0.200
     3.162    46.910     0.200
     3.183    47.922     0.200
     3.390    51.672     0.200
     3.490    52.180     0.200
     3.488    53.219     0.200
     3.506    52.852     0.200
     3.616    54.191     0.200
     3.530    54.012     0.200
     3.713    55.910     0.200
     3.804    56.488     0.200
     4.049    60.109     0.200
     4.355    65.211     0.200
     4.315    63.512     0.200
     4.679    70.711     0.200
     4.758    70.910     0.200
     4.792    68.910     0.200
     4.878    70.211     0.200
     5.430    79.109     0.200
     5.524    80.211     0.200
     5.637    81.512     0.200
     5.884    86.512     0.200
     5.856    84.211     0.200
     5.977    88.809     0.200
     6.826    99.910     0.200
     7.171   102.609     0.200
     8.131   117.711     0.200
     8.679   127.910     0.200
     8.768   129.910     0.200
     9.136   132.012     0.200
     9.199   130.711     0.200
     9.260   136.711     0.200
     9.503   137.512     0.200
     9.762   144.109     0.200
    10.050   143.109     0.200
    10.023   144.012     0.200
    10.515   153.711     0.200
    10.937   154.910     0.200
    11.166   161.910     0.200
    11.872   171.410     0.200
    11.876   171.609     0.200
    12.198   177.012     0.200
    12.255   176.109     0.200
    12.555   181.410     0.200
    12.753   182.410     0.200
    13.029   186.809     0.200
    13.129   187.711     0.200
    13.384   192.910     0.200
    13.403   192.109     0.200
    13.425   191.609     0.200
    13.557   193.410     0.200
    13.881   198.410     0.200
    14.199   201.609     0.200
    15.112   210.609     0.200
    15.043   212.910     0.200
    15.213   215.910     0.200
    15.436   217.211     0.200
    15.631   221.910     0.200
    15.963   225.910     0.200
    16.148   227.910     0.200
    16.304   229.211     0.200
    16.494   231.910     0.200
    16.527   231.910     0.200
    16.601   233.410     0.200
    16.934   237.910     0.200
    16.992   237.309     0.200
    17.340   241.910     0.200
    17.691   247.910     0.200
    18.369   255.910     0.200
    18.544   256.910     0.200
    18.606   258.410     0.200
    18.712   259.910     0.200
     1.387    22.621     0.200
     1.406    22.492     0.200
     1.829    28.352     0.200
     1.944    29.492     0.200
     2.120    33.133     0.200
     2.372    36.512     0.200
     2.467    37.793     0.200
     2.657    40.070     0.200
     2.753    40.500     0.200
     2.754    41.602     0.200
     2.826    42.691     0.200
     2.819    42.641     0.200
     2.849    43.652     0.200
     2.904    44.441     0.200
     2.967    44.402     0.200
     2.930    45.121     0.200
     3.192    49.273     0.200
     3.211    48.113     0.200
     3.177    48.934     0.200
     3.335    49.691     0.200
     3.632    54.422     0.200
     3.733    56.094     0.200
     3.797    57.344     0.200
     3.920    58.242     0.200
     4.073    59.293     0.200
     4.282    63.000     0.200
     4.412    66.594     0.200
     4.625    68.750     0.200
     4.647    68.250     0.200
     4.636    69.242     0.200
     4.672    69.621     0.200
     4.742    71.191     0.200
     4.766    70.902     0.200
     4.764    71.320     0.200
     4.783    71.742     0.200
     4.807    72.594     0.200
     4.807    72.523     0.200
     4.840    72.660     0.200
     4.868    72.953     0.200
     4.741    69.473     0.200
     4.892    72.980     0.200
     4.915    73.844     0.200
     4.996    75.023     0.200
     5.146    76.672     0.200
     5.131    76.652     0.200
     5.239    76.820     0.200
     5.222    78.102     0.200
     5.286    78.613     0.200
     5.277    79.062     0.200
     5.337    78.691     0.200
     5.553    83.113     0.200
     5.624    84.250     0.200
     5.688    83.211     0.200
     5.689    83.051     0.200
     5.654    83.371     0.200
     5.762    85.883     0.200
     5.915    86.582     0.200
     5.891    87.633     0.200
     5.964    86.902     0.200
     6.103    88.922     0.200
     6.408    92.102     0.200
     7.014   101.523     0.200
     7.175   102.934     0.200
     7.253   109.293     0.200
     7.898   117.871     0.200
     8.293   123.133     0.200
     8.990   129.320     0.200
     9.289   135.723     0.200
    10.755   154.152     0.200
    10.821   154.223     0.200
    11.508   166.621     0.200
    12.800   184.820     0.200
    13.617   192.203     0.200
    13.879   197.230     0.200
    14.122   200.492     0.200
    15.384   217.371     0.200
    15.450   216.922     0.200
    18.606   258.621     0.200
    19.315   266.223     0.200
    20.456   276.922     0.200
     1.364    22.801     0.200
     1.367    23.080     0.200
     1.449    23.420     0.200
     1.471    24.391     0.200
     1.558    25.740     0.200
     1.570    25.580     0.200
     1.620    26.150     0.200
     1.740    28.801     0.200
     1.693    27.721     0.200
     1.727    27.119     0.200
     1.741    28.061     0.200
     1.806    29.160     0.200
     1.925    30.971     0.200
     1.913    30.420     0.200
     2.021    32.350     0.200
     2.030    32.340     0.200
     2.059    32.850     0.200
     2.182    34.369     0.200
     2.158    34.051     0.200
     2.182    34.199     0.200
     2.267    35.619     0.200
     2.263    35.250     0.200
     2.272    35.850     0.200
     2.294    36.080     0.200
     2.360    37.279     0.200
     2.452    37.600     0.200
     2.529    39.770     0.200
     2.520    39.949     0.200
     2.516    38.891     0.200
     2.647    41.660     0.200
     2.682    41.670     0.200
     2.686    41.561     0.200
     2.712    42.090     0.200
     2.841    43.391     0.200
     2.890    44.480     0.200
     2.918    45.240     0.200
     2.997    46.801     0.200
     3.122    47.740     0.200
     3.158    48.449     0.200
     3.252    50.270     0.200
     3.202    48.500     0.200
     3.305    50.461     0.200
     3.360    51.330     0.200
     3.375    51.270     0.200
     3.450    52.789     0.200
     3.449    51.869     0.200
     3.507    53.939     0.200
     3.518    53.949     0.200
     3.517    54.109     0.200
     3.518    54.080     0.200
     3.547    54.721     0.200
     3.641    55.830     0.200
     3.653    56.430     0.200
     3.711    57.400     0.200
     3.796    57.051     0.200
     3.864    59.020     0.200
     3.874    58.391     0.200
     4.184    62.471     0.200
     4.457    67.289     0.200
     4.484    68.061     0.200
     4.873    72.340     0.200
     5.198    76.350     0.200
     5.500    83.721     0.200
     5.849    85.289     0.200
     5.885    86.570     0.200
     7.291   109.770     0.200
     8.047   119.430     0.200
     8.432   125.051     0.200
     9.464   137.010     0.200
     9.577   137.250     0.200
     9.686   138.279     0.200
     9.650   142.811     0.200
     9.943   142.529     0.200
    10.089   148.625     0.200
    10.957   159.670     0.200
    11.077   161.301     0.200
    11.099   160.631     0.200
    11.614   170.100     0.200
    11.664   169.980     0.200
    11.899   171.221     0.200
    12.326   178.141     0.200
    13.292   191.170     0.200
    13.671   197.420     0.200
    14.174   203.211     0.200
    14.185   203.279     0.200
    15.217   212.051     0.200
    19.661   270.900     0.200
    19.915   274.650     0.200
    20.065   273.801     0.200
    20.392   278.971     0.200
     0.302     7.797     0.200
     0.279     7.938     0.200
     0.409     9.219     0.200
     0.744    13.492     0.200
     0.726    13.539     0.200
     0.740    13.219     0.200
     0.888    15.586     0.200
     0.918    16.422     0.200
     1.072    18.133     0.200
     1.133    18.961     0.200
     1.129    19.336     0.200
     1.427    23.172     0.200
     1.451    23.156     0.200
     1.484    23.898     0.200
     1.473    24.109     0.200
     1.722    27.328     0.200
     1.811    29.133     0.200
     1.856    28.742     0.200
     1.844    29.383     0.200
     1.920    30.188     0.200
     1.962    30.508     0.200
     1.998    31.266     0.200
     2.081    33.992     0.200
     2.116    32.539     0.200
     2.150    32.852     0.200
     2.177    33.867     0.200
     2.183    34.062     0.200
     2.325    36.148     0.200
     2.342    35.820     0.200
     2.327    36.031     0.200
     2.460    37.602     0.200
     2.541    39.562     0.200
     2.572    39.758     0.200
     2.644    40.117     0.200
     2.690    40.508     0.200
     2.759    42.086     0.200
     2.861    44.445     0.200
     2.877    43.852     0.200
     2.865    43.398     0.200
     2.930    44.266     0.200
     2.970    44.891     0.200
     2.961    44.828     0.200
     2.973    44.242     0.200
     3.073    46.641     0.200
     3.068    46.352     0.200
     3.236    49.797     0.200
     3.270    50.070     0.200
     3.357    50.992     0.200
     3.531    53.430     0.200
     3.645    54.680     0.200
     3.696    55.539     0.200
     3.853    58.008     0.200
     3.930    58.883     0.200
     3.937    58.531     0.200
     3.949    59.422     0.200
     3.994    59.438     0.200
     3.994    60.289     0.200
     4.052    60.648     0.200
     4.092    61.250     0.200
     4.086    60.719     0.200
     4.104    61.242     0.200
     4.159    62.430     0.200
     4.170    62.133     0.200
     4.190    62.961     0.200
     4.268    62.391     0.200
     4.250    63.461     0.200
     4.253    64.188     0.200
     4.259    63.859     0.200
     4.254    62.508     0.200
     4.299    64.367     0.200
     4.369    66.070     0.200
     4.365    65.508     0.200
     4.506    67.367     0.200
     4.536    67.812     0.200
     4.696    67.602     0.200
     4.834    72.711     0.200
     4.893    70.398     0.200
     5.074    74.297     0.200
     5.138    76.133     0.200
     5.169    73.836     0.200
     5.277    76.766     0.200
     5.272    78.070     0.200
     5.293    77.836     0.200
     5.401    78.859     0.200
     5.388    79.508     0.200
     5.417    78.891     0.200
     5.408    80.750     0.200
     5.506    80.016     0.200
     5.498    78.211     0.200
     5.617    82.102     0.200
     6.079    87.586     0.200
     6.149    87.766     0.200
     6.326    93.727     0.200
     7.004   101.688     0.200
     8.017   115.492     0.200
     8.122   120.250     0.200
     8.616   126.445     0.200
     8.781   128.938     0.200
     8.991   127.117     0.200
     9.251   134.539     0.200
     9.266   135.906     0.200
     9.357   133.812     0.200
     9.602   136.938     0.200
     9.863   144.328     0.200
     9.942   140.938     0.200
     9.974   140.812     0.200
     9.970   145.977     0.200
    10.020   144.492     0.200
    10.557   149.016     0.200
    10.682   154.570     0.200
    10.721   155.750     0.200
    11.047   157.000     0.200
    11.037   159.836     0.200
    11.256   162.930     0.200
    11.601   165.609     0.200
    12.111   175.750     0.200
    12.178   174.602     0.200
    12.203   177.812     0.200
    12.247   176.711     0.200
    12.407   179.164     0.200
    12.437   180.781     0.200
    12.453   179.570     0.200
    13.057   185.711     0.200
    13.093   187.648     0.200
    13.169   187.688     0.200
    13.312   189.742     0.200
    13.313   189.047     0.200
    13.890   197.320     0.200
    14.445   205.078     0.200
    14.844   209.469     0.200
    14.854   209.898     0.200
    16.064   224.602     0.200
    18.835   258.320     0.200
    18.856   258.891     0.200
    19.228   262.664     0.200
    19.225   264.562     0.200
    20.499   277.328     0.200
     0.238     6.250     0.200
     0.344     7.430     0.200
     0.613    10.949     0.200
     0.632    11.328     0.200
     0.758    13.148     0.200
     0.779    14.320     0.200
     0.883    15.320     0.200
     0.877    15.008     0.200
     0.895    15.438     0.200
     0.947    16.238     0.200
     0.994    16.078     0.200
     0.995    17.551     0.200
     1.003    17.738     0.200
     1.061    17.648     0.200
     1.067    18.059     0.200
     1.108    17.879     0.200
     1.104    19.000     0.200
     1.220    20.199     0.200
     1.287    21.098     0.200
     1.292    21.148     0.200
     1.277    21.199     0.200
     1.368    22.180     0.200
     1.365    21.949     0.200
     1.393    22.688     0.200
     1.431    23.301     0.200
     1.427    23.109     0.200
     1.467    23.730     0.200
     1.528    25.000     0.200
     1.533    24.871     0.200
     1.571    25.910     0.200
     1.650    26.531     0.200
     1.678    27.199     0.200
     1.705    26.969     0.200
     1.780    28.801     0.200
     1.801    28.539     0.200
     1.907    30.461     0.200
     1.906    30.168     0.200
     1.889    29.809     0.200
     1.935    30.930     0.200
     1.950    30.531     0.200
     1.959    30.828     0.200
     2.016    31.328     0.200
     2.043    32.621     0.200
     2.176    33.930     0.200
     2.184    33.949     0.200
     2.278    35.301     0.200
     2.325    36.008     0.200
     2.342    36.418     0.200
     2.434    37.371     0.200
     2.478    38.340     0.200
     2.709    41.680     0.200
     2.679    41.328     0.200
     2.713    41.270     0.200
     2.704    41.508     0.200
     2.746    41.598     0.200
     2.767    42.230     0.200
     2.876    43.750     0.200
     2.888    44.410     0.200
     2.933    45.301     0.200
     2.948    44.598     0.200
     2.963    45.258     0.200
     3.007    45.961     0.200
     3.015    46.430     0.200
     3.051    46.738     0.200
     3.312    50.680     0.200
     3.459    52.410     0.200
     3.639    55.621     0.200
     4.124    60.285     0.200
     4.213    60.668     0.200
     4.200    61.180     0.200
     4.900    71.828     0.200
     4.940    72.008     0.200
     4.970    72.758     0.200
     5.106    74.695     0.200
     5.405    79.238     0.200
     5.832    84.938     0.200
     7.955   112.320     0.200
    11.247   164.109     0.200
    12.151   172.840     0.200
    20.013   271.938     0.200
    20.187   273.258     0.200
     0.238     6.445     0.200
     0.451     9.148     0.200
     0.682    12.070     0.200
     0.744    13.031     0.200
     0.732    12.688     0.200
     1.015    17.422     0.200
     1.036    17.109     0.200
     1.036    16.945     0.200
     1.105    18.766     0.200
     1.203    19.875     0.200
     1.203    20.297     0.200
     1.351    22.711     0.200
     1.380    22.695     0.200
     1.393    22.422     0.200
     1.548    24.852     0.200
     1.618    24.992     0.200
     1.603    25.898     0.200
     1.683    26.602     0.200
     1.694    27.008     0.200
     1.677    26.531     0.200
     1.710    26.492     0.200
     1.710    26.938     0.200
     1.770    28.578     0.200
     1.770    28.172     0.200
     1.775    27.352     0.200
     1.807    28.742     0.200
     1.879    30.047     0.200
     1.949    30.727     0.200
     2.009    31.922     0.200
     2.137    33.117     0.200
     2.176    33.641     0.200
     2.324    35.516     0.200
     2.445    37.492     0.200
     2.531    39.375     0.200
     2.600    40.281     0.200
     2.723    41.961     0.200
     2.902    44.102     0.200
     2.914    44.445     0.200
     2.982    45.570     0.200
     3.124    44.758     0.200
     3.450    51.477     0.200
     3.507    52.852     0.200
     3.553    53.047     0.200
     3.771    56.102     0.200
     3.782    57.867     0.200
    18.535   254.570     0.200
     1.508    24.742     0.200
     1.510    25.191     0.200
     1.638    27.561     0.200
     1.780    29.492     0.200
     2.053    32.012     0.200
     2.246    35.811     0.200
     2.498    39.342     0.200
     2.590    40.391     0.200
     2.738    42.592     0.200
     2.832    44.871     0.200
     2.822    43.531     0.200
     2.946    44.762     0.200
     2.923    45.111     0.200
     2.976    45.191     0.200
     3.027    46.592     0.200
     3.080    48.521     0.200
     3.296    50.742     0.200
     3.420    52.592     0.200
     3.746    56.951     0.200
     3.705    56.891     0.200
     3.836    58.852     0.200
     4.069    61.611     0.200
     4.177    63.242     0.200
     4.124    62.762     0.200
     4.222    63.992     0.200
     4.368    64.791     0.200
     4.493    69.402     0.200
     4.635    68.252     0.200
     4.725    69.221     0.200
     4.694    70.801     0.200
     4.719    71.531     0.200
     4.793    72.582     0.200
     4.761    71.832     0.200
     4.823    72.391     0.200
     4.864    74.512     0.200
     4.897    74.572     0.200
     5.076    74.922     0.200
     5.234    78.951     0.200
     5.337    78.361     0.200
     5.358    79.162     0.200
     5.687    84.721     0.200
     5.604    85.082     0.200
     5.723    83.211     0.200
     5.672    86.111     0.200
     5.784    85.262     0.200
     5.813    87.682     0.200
     6.038    91.541     0.200
     6.369    93.182     0.200
     6.513    94.352     0.200
     6.682    98.871     0.200
     7.125   104.270     0.200
     7.125   103.902     0.200
     7.257   105.512     0.200
     7.655   112.322     0.200
     9.109   131.762     0.200
     9.330   134.816     0.200
     9.330   136.141     0.200
     9.909   141.822     0.200
    10.009   143.072     0.200
    10.088   144.662     0.200
    10.863   160.131     0.200
    11.283   161.121     0.200
    11.243   163.672     0.200
    11.461   168.082     0.200
    11.547   168.402     0.200
    11.998   172.352     0.200
    12.156   174.891     0.200
    12.767   185.916     0.200
    12.822   185.781     0.200
    13.378   191.041     0.200
    13.501   194.980     0.200
    13.941   198.932     0.200
    14.096   201.480     0.200
    14.650   209.262     0.200
    15.231   212.221     0.200
    15.495   219.861     0.200
    15.507   220.572     0.200
    17.296   242.771     0.200
    18.505   257.902     0.200
    18.606   258.492     0.200
    19.357   266.291     0.200
     1.245    21.773     0.200
     1.434    23.055     0.200
     1.508    24.816     0.200
     1.528    25.484     0.200
     1.556    25.645     0.200
     2.072    32.395     0.200
     2.263    36.105     0.200
     2.516    39.895     0.200
     2.608    40.945     0.200
     2.710    42.496     0.200
     2.850    45.406     0.200
     2.972    45.344     0.200
     2.972    45.164     0.200
     2.964    45.945     0.200
     2.839    44.945     0.200
     2.941    45.965     0.200
     2.941    45.633     0.200
     3.044    47.023     0.200
     3.098    49.395     0.200
     3.312    51.723     0.200
     3.438    52.645     0.200
     3.764    57.293     0.200
     4.085    62.066     0.200
     4.195    63.516     0.200
     4.177    62.863     0.200
     4.241    64.043     0.200
     4.626    67.816     0.200
     4.713    69.863     0.200
     4.737    71.855     0.200
     5.005    73.285     0.200
     5.094    74.824     0.200
     5.329    78.766     0.200
     5.376    79.094     0.200
     5.691    85.184     0.200
     5.711    83.414     0.200
     6.385    93.336     0.200
     6.696    99.215     0.200
     7.144   104.625     0.200
     7.144   104.066     0.200
     8.306   124.473     0.200
     8.834   130.895     0.200
     9.127   131.496     0.200
     9.019   134.223     0.200
     9.324   136.320     0.200
     9.324   136.746     0.200
     9.324   134.906     0.200
     9.335   137.953     0.200
    10.090   144.734     0.200
    10.758   157.953     0.200
    10.874   159.656     0.200
    11.256   165.816     0.200
    11.474   168.066     0.200
    11.562   169.516     0.200
    12.836   185.715     0.200
    14.229   202.113     0.200
    14.229   204.148     0.200
    15.236   212.613     0.200
    15.236   212.406     0.200
    16.137   227.145     0.200
    18.595   258.094     0.200
    18.951   263.633     0.200
    19.352   268.844     0.200
    19.769   273.203     0.200
    20.599   279.543     0.200
     1.165    19.789     0.200
     1.283    21.590     0.200
     1.392    22.910     0.200
     1.628    26.602     0.200
     1.770    28.391     0.200
     1.886    30.148     0.200
     2.181    35.012     0.200
     2.242    36.359     0.200
     2.676    41.270     0.200
     2.657    42.430     0.200
     2.680    40.238     0.200
     2.794    43.059     0.200
     2.924    45.738     0.200
     3.435    52.879     0.200
     3.522    53.578     0.200
     3.569    55.621     0.200
     3.612    55.898     0.200
     3.844    58.891     0.200
     4.164    63.340     0.200
     4.210    62.789     0.200
     4.560    67.410     0.200
     4.722    69.238     0.200
     5.031    73.570     0.200
     5.718    83.160     0.200
     5.654    83.738     0.200
     6.050    87.590     0.200
     6.233    90.770     0.200
     7.475   109.441     0.200
     8.355   123.898     0.200
    10.650   152.680     0.200
    15.394   217.371     0.200
    17.575   243.180     0.200
    19.571   269.250     0.200
     1.113    18.531     0.200
     1.177    19.902     0.200
     1.259    20.371     0.200
     1.280    21.051     0.200
     1.318    21.652     0.200
     1.583    25.172     0.200
     1.735    27.082     0.200
     1.826    28.812     0.200
     2.135    33.754     0.200
     2.185    35.273     0.200
     2.625    39.543     0.200
     2.677    41.602     0.200
     2.744    41.504     0.200
     2.744    41.902     0.200
     2.857    44.801     0.200
     3.389    51.824     0.200
     3.509    53.684     0.200
     3.618    55.773     0.200
     3.790    57.773     0.200
     4.198    61.594     0.200
     4.529    66.184     0.200
     4.554    67.801     0.200
     5.017    72.102     0.200
     5.699    82.164     0.200
     6.778    98.477     0.200
     7.507   108.672     0.200
     8.389   126.094     0.200
    10.634   150.703     0.200
    12.788   185.254     0.200
    13.964   197.863     0.200
    15.382   213.812     0.200
    18.519   257.402     0.200
     0.731    12.828     0.200
     0.811    14.238     0.200
     0.825    13.887     0.200
     0.824    14.297     0.200
     0.911    15.770     0.200
     1.061    18.168     0.200
     1.142    19.137     0.200
     1.229    19.867     0.200
     1.237    20.508     0.200
     1.246    20.617     0.200
     1.315    21.918     0.200
     1.357    21.918     0.200
     1.357    22.090     0.200
     1.360    22.219     0.200
     1.384    22.930     0.200
     1.431    22.887     0.200
     1.459    23.938     0.200
     1.474    23.148     0.200
     1.474    23.477     0.200
     1.506    25.070     0.200
     1.536    24.047     0.200
     1.566    25.160     0.200
     1.582    24.398     0.200
     1.608    25.977     0.200
     1.632    25.797     0.200
     1.662    26.719     0.200
     1.726    27.859     0.200
     1.758    28.598     0.200
     1.884    29.898     0.200
     1.898    30.348     0.200
     1.919    30.078     0.200
     1.994    31.418     0.200
     2.010    31.398     0.200
     2.026    30.969     0.200
     2.028    31.520     0.200
     2.129    33.297     0.200
     2.319    36.770     0.200
     2.341    36.270     0.200
     2.387    36.930     0.200
     2.406    36.617     0.200
     2.502    39.410     0.200
     2.542    38.547     0.200
     2.538    39.289     0.200
     2.749    41.988     0.200
     2.772    43.027     0.200
     2.832    43.277     0.200
     2.862    44.070     0.200
     2.892    44.148     0.200
     3.033    46.379     0.200
     3.141    48.070     0.200
     3.208    48.449     0.200
     3.345    50.668     0.200
     3.742    56.660     0.200
     3.854    56.723     0.200
     3.854    57.000     0.200
     4.042    60.250     0.200
     5.421    78.809     0.200
     5.478    80.500     0.200
     5.503    79.320     0.200
     5.703    82.223     0.200
     5.703    81.508     0.200
     5.849    86.340     0.200
     5.996    86.270     0.200
     6.316    90.137     0.200
     6.897   100.707     0.200
     6.984    99.660     0.200
     7.241   108.414     0.200
     7.770   112.398     0.200
     7.948   117.320     0.200
    10.848   158.074     0.200
    11.537   168.422     0.200
    12.705   183.590     0.200
    15.853   220.500     0.200
    19.731   269.258     0.200
     0.502     9.898     0.200
     0.617    11.750     0.200
     0.752    13.539     0.200
     0.994    17.461     0.200
     1.005    17.051     0.200
     1.283    21.070     0.200
     1.279    21.418     0.200
     1.278    21.309     0.200
     1.341    22.840     0.200
     1.385    22.121     0.200
     1.499    24.750     0.200
     1.650    25.801     0.200
     2.788    42.539     0.200
     4.908    70.930     0.200
     6.934   100.379     0.200
     8.391   124.598     0.200
    12.243   176.805     0.200
    12.819   185.855     0.200
    14.090   201.430     0.200
     0.108     7.227     0.200
     0.370     8.906     0.200
     0.412     9.422     0.200
     0.418     9.359     0.200
     0.445     9.656     0.200
     0.451     9.812     0.200
     0.538    11.289     0.200
     0.577    11.188     0.200
     0.558    11.719     0.200
     0.621    12.141     0.200
     0.665    12.852     0.200
     0.711    13.281     0.200
     0.737    13.633     0.200
     0.797    14.547     0.200
     0.911    16.195     0.200
     0.968    16.977     0.200
     1.028    17.961     0.200
     1.041    17.438     0.200
     1.052    17.961     0.200
     1.073    18.820     0.200
     1.105    19.352     0.200
     1.205    20.008     0.200
     1.197    19.531     0.200
     1.231    20.719     0.200
     1.281    21.109     0.200
     1.314    21.516     0.200
     1.341    22.492     0.200
     1.502    23.719     0.200
     1.501    23.656     0.200
     1.501    23.742     0.200
     1.503    23.766     0.200
     1.478    24.211     0.200
     1.519    24.750     0.200
     1.613    26.695     0.200
     1.698    26.492     0.200
     1.806    29.000     0.200
     1.857    29.289     0.200
     1.849    29.547     0.200
     1.938    30.586     0.200
     2.135    33.531     0.200
     2.147    33.352     0.200
     2.222    34.039     0.200
     2.239    35.086     0.200
     2.347    36.359     0.200
     2.394    38.031     0.200
     2.407    37.742     0.200
     2.514    38.719     0.200
     2.609    40.617     0.200
     2.615    40.320     0.200
     2.633    40.188     0.200
     2.756    42.789     0.200
     3.117    48.086     0.200
     3.629    54.297     0.200
     3.815    56.422     0.200
     3.827    56.820     0.200
     4.163    61.688     0.200
     4.767    70.500     0.200
     5.301    78.031     0.200
     0.240     7.077     0.200
     0.286     7.347     0.200
     0.320     8.086     0.200
     0.343     7.906     0.200
     0.342     7.966     0.200
     0.364     8.086     0.200
     0.380     8.546     0.200
     0.454     9.267     0.200
     0.568    11.247     0.200
     0.729    13.316     0.200
     0.754    13.367     0.200
     0.749    13.836     0.200
     0.761    13.937     0.200
     0.842    14.376     0.200
     0.865    14.756     0.200
     0.860    15.396     0.200
     0.882    15.376     0.200
     0.994    16.796     0.200
     1.041    17.727     0.200
     1.098    19.026     0.200
     1.142    19.276     0.200
     1.218    21.086     0.200
     1.275    21.307     0.200
     1.317    22.126     0.200
     1.346    22.327     0.200
     1.346    21.977     0.200
     1.346    22.146     0.200
     1.348    22.356     0.200
     1.477    25.336     0.200
     1.684    26.727     0.200
     1.714    27.626     0.200
     1.833    29.227     0.200
     1.866    29.236     0.200
     1.953    30.426     0.200
     2.049    31.856     0.200
     2.126    33.156     0.200
     2.152    33.167     0.200
     2.293    36.537     0.200
     2.331    35.776     0.200
     2.652    40.896     0.200
     0.359     8.286     0.200
     0.278     7.536     0.200
     0.357     8.246     0.200
     0.329     8.106     0.200
     0.458     9.736     0.200
     0.525    10.577     0.200
     0.645    11.847     0.200
     0.659    12.036     0.200
     0.681    12.646     0.200
     0.748    13.866     0.200
     0.803    14.197     0.200
     0.813    14.567     0.200
     0.842    14.776     0.200
     0.842    14.886     0.200
     0.886    15.016     0.200
     0.888    15.016     0.200
     0.902    16.246     0.200
     0.995    16.547     0.200
     1.007    16.957     0.200
     1.051    17.866     0.200
     1.167    19.766     0.200
     1.168    19.766     0.200
     1.183    19.597     0.200
     1.308    20.866     0.200
     1.359    21.967     0.200
     1.398    22.047     0.200
     1.417    22.957     0.200
     1.402    22.646     0.200
     1.508    24.276     0.200
     1.508    24.396     0.200
     1.518    24.126     0.200
     1.627    26.016     0.200
     1.700    26.656     0.200
     1.773    27.827     0.200
     1.738    28.317     0.200
     1.776    27.486     0.200
     1.831    28.677     0.200
     1.837    29.016     0.200
     1.905    29.626     0.200
     1.894    29.217     0.200
     1.895    29.817     0.200
     1.894    29.146     0.200
     1.894    30.656     0.200
     1.896    29.286     0.200
     2.088    29.526     0.200
     2.104    32.957     0.200
     2.253    35.636     0.200
     2.281    35.347     0.200
     2.316    36.443     0.200
     2.513    38.496     0.200
     2.554    38.417     0.200
     2.790    43.486     0.200
     2.822    41.927     0.200
     2.801    43.156     0.200
     2.801    43.266     0.200
     2.889    43.817     0.200
     2.994    44.307     0.200
     3.004    46.417     0.200
     3.006    44.927     0.200
     3.146    47.746     0.200
     3.183    47.697     0.200
     3.152    48.327     0.200
     3.388    49.486     0.200
     3.388    49.917     0.200
     3.606    54.386     0.200
     3.883    57.386     0.200
     3.943    58.457     0.200
     3.943    59.276     0.200
     4.062    60.746     0.200
     4.079    61.256     0.200
     4.130    61.977     0.200
     4.197    63.656     0.200
     4.213    63.506     0.200
     4.215    63.067     0.200
     4.322    64.717     0.200
     4.489    67.016     0.200
     4.556    66.797     0.200
     4.685    68.718     0.200
     4.746    67.687     0.200
     5.214    74.516     0.200
     5.259    77.417     0.200
     5.197    75.396     0.200
     5.544    78.467     0.200
     6.093    89.547     0.200
     6.191    87.727     0.200
     1.154    19.039     0.200
     1.171    19.367     0.200
     1.266    21.438     0.200
     1.257    21.219     0.200
     1.342    22.398     0.200
     1.348    22.078     0.200
     1.436    23.492     0.200
     1.437    23.344     0.200
     1.416    22.602     0.200
     1.529    24.898     0.200
     1.547    25.273     0.200
     1.663    26.250     0.200
     1.658    25.039     0.200
     1.806    29.234     0.200
     1.962    30.969     0.200
     1.964    30.789     0.200
     1.991    31.070     0.200
     2.067    32.500     0.200
     2.083    33.328     0.200
     2.156    34.508     0.200
     2.235    34.883     0.200
     2.314    36.383     0.200
     2.327    36.172     0.200
     2.332    36.320     0.200
     2.332    36.219     0.200
     2.434    38.523     0.200
     2.442    38.023     0.200
     2.520    38.539     0.200
     2.548    39.969     0.200
     2.548    39.312     0.200
     2.548    39.133     0.200
     2.550    39.555     0.200
     2.592    40.273     0.200
     2.692    41.898     0.200
     2.708    41.562     0.200
     2.772    42.633     0.200
     2.853    44.523     0.200
     2.933    44.953     0.200
     2.880    43.984     0.200
     2.880    43.398     0.200
     2.880    42.688     0.200
     3.003    45.539     0.200
     3.015    47.070     0.200
     3.182    49.055     0.200
     3.198    48.773     0.200
     3.230    49.305     0.200
     3.239    48.570     0.200
     3.273    49.898     0.200
     3.406    50.984     0.200
     3.460    53.039     0.200
     3.509    53.500     0.200
     3.626    55.070     0.200
     3.626    53.859     0.200
     3.655    55.188     0.200
     3.655    54.594     0.200
     3.752    56.438     0.200
     3.721    55.891     0.200
     3.721    54.930     0.200
     3.740    57.008     0.200
     3.839    58.203     0.200
     3.839    57.234     0.200
     3.839    57.711     0.200
     3.839    57.273     0.200
     3.992    60.523     0.200
     4.023    60.531     0.200
     4.078    62.891     0.200
     4.088    61.812     0.200
     4.088    60.891     0.200
     4.179    62.883     0.200
     4.321    64.086     0.200
     4.351    64.617     0.200
     4.401    65.055     0.200
     4.324    62.898     0.200
     4.412    66.500     0.200
     4.496    66.930     0.200
     4.506    68.594     0.200
     4.540    67.539     0.200
     4.598    70.258     0.200
     4.702    69.570     0.200
     4.820    72.523     0.200
     4.820    71.422     0.200
     4.835    69.711     0.200
     4.933    72.633     0.200
     4.933    72.164     0.200
     4.948    73.781     0.200
     4.935    72.984     0.200
     5.082    72.742     0.200
     5.082    72.531     0.200
     5.082    73.562     0.200
     5.145    74.242     0.200
     5.145    73.641     0.200
     5.266    77.422     0.200
     5.266    76.398     0.200
     5.246    78.164     0.200
     5.467    80.859     0.200
     5.467    80.742     0.200
     5.657    82.070     0.200
     5.699    84.008     0.200
     5.732    84.898     0.200
     5.799    87.461     0.200
     5.829    83.734     0.200
     5.927    86.242     0.200
     5.934    85.883     0.200
     5.975    85.859     0.200
     6.067    88.961     0.200
     6.245    91.633     0.200
     6.255    92.055     0.200
     6.276    93.000     0.200
     6.340    95.273     0.200
     6.424    94.273     0.200
     6.459    95.641     0.200
     6.468    95.258     0.200
     6.698    95.812     0.200
     6.723    97.438     0.200
     6.723    96.781     0.200
     6.723    96.570     0.200
     6.791   100.203     0.200
     6.818   100.867     0.200
     7.059   103.586     0.200
     7.109   102.102     0.200
     7.340   107.094     0.200
     7.371   109.031     0.200
     7.448   110.633     0.200
     7.631   111.523     0.200
     7.726   112.250     0.200
     7.722   111.469     0.200
     7.947   116.453     0.200
     8.099   116.062     0.200
     8.175   120.453     0.200
     8.255   117.391     0.200
     8.252   121.859     0.200
     8.343   119.312     0.200
     8.343   118.844     0.200
     8.408   122.688     0.200
     8.456   123.750     0.200
     8.579   122.109     0.200
     8.535   125.141     0.200
     8.683   125.219     0.200
     8.683   124.344     0.200
     8.699   124.523     0.200
     8.699   123.570     0.200
     8.705   124.430     0.200
     8.845   126.773     0.200
     8.845   125.281     0.200
     8.835   130.859     0.200
     8.835   129.578     0.200
     8.878   129.141     0.200
     8.949   127.062     0.200
     8.966   131.281     0.200
     9.238   135.688     0.200
     9.238   135.539     0.200
     9.238   135.078     0.200
     9.357   132.961     0.200
     9.379   137.664     0.200
     9.470   135.070     0.200
     9.471   138.484     0.200
     9.669   138.250     0.200
     9.735   139.594     0.200
     9.834   140.641     0.200
     9.842   140.398     0.200
    10.014   146.383     0.200
    10.126   143.320     0.200
    10.224   146.820     0.200
    10.463   148.883     0.200
    10.534   149.656     0.200
    10.534   149.461     0.200
    10.551   150.617     0.200
    10.607   151.078     0.200
    10.613   154.062     0.200
    10.781   158.000     0.200
    10.976   161.469     0.200
    11.016   161.328     0.200
    11.091   162.383     0.200
    11.160   158.992     0.200
    11.137   162.180     0.200
    11.145   163.961     0.200
    11.161   160.711     0.200
    11.201   163.758     0.200
    11.324   164.352     0.200
    11.374   164.961     0.200
    11.425   163.398     0.200
    11.542   164.531     0.200
    11.640   166.188     0.200
    11.616   169.609     0.200
    11.639   168.398     0.200
    11.670   166.859     0.200
    11.825   167.211     0.200
    11.830   172.203     0.200
    12.009   169.852     0.200
    12.029   174.773     0.200
    12.036   175.109     0.200
    12.166   172.148     0.200
    12.136   174.258     0.200
    12.195   172.969     0.200
    12.199   177.430     0.200
    12.305   174.352     0.200
    12.342   173.984     0.200
    12.341   177.961     0.200
    12.341   177.711     0.200
    12.385   176.492     0.200
    12.412   177.562     0.200
    12.412   176.211     0.200
    12.415   175.039     0.200
    12.378   179.961     0.200
    12.466   176.703     0.200
    12.467   181.383     0.200
    12.472   178.773     0.200
    12.568   178.500     0.200
    12.502   179.391     0.200
    12.541   182.305     0.200
    12.541   182.398     0.200
    12.612   178.070     0.200
    12.605   181.164     0.200
    12.605   179.398     0.200
    12.627   178.805     0.200
    12.673   183.359     0.200
    12.757   180.555     0.200
    12.761   181.219     0.200
    12.772   181.164     0.200
    12.809   184.117     0.200
    12.875   181.453     0.200
    12.875   181.000     0.200
    12.948   186.703     0.200
    12.892   185.078     0.200
    12.892   184.102     0.200
    13.025   186.188     0.200
    13.053   186.953     0.200
    13.053   187.992     0.200
    13.103   187.711     0.200
    13.158   188.992     0.200
    13.174   188.641     0.200
    13.198   187.781     0.200
    13.190   191.219     0.200
    13.288   189.898     0.200
    13.245   189.852     0.200
    13.270   190.758     0.200
    13.270   190.641     0.200
    13.292   191.133     0.200
    13.362   189.758     0.200
    13.400   191.391     0.200
    13.450   193.070     0.200
    13.528   193.820     0.200
    13.633   194.312     0.200
    13.599   195.914     0.200
    13.692   195.914     0.200
    13.692   193.758     0.200
    13.736   195.078     0.200
    13.745   194.219     0.200
    13.817   196.609     0.200
    13.807   197.609     0.200
    13.807   196.680     0.200
    13.876   197.398     0.200
    13.876   197.078     0.200
    13.876   196.992     0.200
    13.876   197.898     0.200
    13.914   200.703     0.200
    13.950   198.938     0.200
    13.945   199.617     0.200
    13.984   198.758     0.200
    14.105   200.820     0.200
    14.138   201.469     0.200
    14.143   201.352     0.200
    14.160   201.562     0.200
    14.117   203.094     0.200
    14.215   202.578     0.200
    14.261   199.781     0.200
    14.261   199.430     0.200
    14.256   202.805     0.200
    14.268   204.922     0.200
    14.298   202.688     0.200
    14.280   203.922     0.200
    14.449   205.344     0.200
    14.441   204.852     0.200
    14.484   206.367     0.200
    14.522   208.781     0.200
    14.500   206.023     0.200
    14.500   205.664     0.200
    14.500   204.328     0.200
    14.543   207.930     0.200
    14.571   208.383     0.200
    14.627   206.828     0.200
    14.571   205.273     0.200
    14.604   208.508     0.200
    14.697   207.758     0.200
    14.719   208.312     0.200
    14.730   210.445     0.200
    14.730   210.164     0.200
    14.785   205.711     0.200
    14.759   210.586     0.200
    14.797   205.562     0.200
    14.822   206.352     0.200
    14.835   206.305     0.200
    14.847   206.430     0.200
    14.833   212.258     0.200
    14.859   206.570     0.200
    14.808   211.219     0.200
    14.872   206.453     0.200
    14.872   206.633     0.200
    14.885   206.922     0.200
    14.891   206.867     0.200
    14.922   213.945     0.200
    14.948   211.922     0.200
    14.978   211.703     0.200
    15.006   212.320     0.200
    15.003   214.688     0.200
    14.977   212.062     0.200
    14.977   210.539     0.200
    15.047   212.859     0.200
    15.067   213.383     0.200
    15.067   215.922     0.200
    15.118   210.367     0.200
    15.108   216.008     0.200
    15.108   215.664     0.200
    15.178   215.750     0.200
    15.193   214.883     0.200
    15.190   214.828     0.200
    15.233   215.758     0.200
    15.246   216.562     0.200
    15.250   218.258     0.200
    15.277   216.359     0.200
    15.277   215.898     0.200
    15.240   214.062     0.200
    15.460   218.641     0.200
    15.399   216.430     0.200
    15.461   217.492     0.200
    15.478   219.133     0.200
    15.453   220.516     0.200
    15.499   220.477     0.200
    15.534   220.719     0.200
    15.528   221.812     0.200
    15.554   219.391     0.200
    15.549   220.422     0.200
    15.637   221.352     0.200
    15.643   222.594     0.200
    15.694   221.664     0.200
    15.809   220.445     0.200
    15.809   220.055     0.200
    15.776   222.750     0.200
    15.776   221.391     0.200
    15.807   222.172     0.200
    15.902   226.250     0.200
    15.955   224.773     0.200
    15.965   225.672     0.200
    15.978   226.875     0.200
    15.987   227.789     0.200
    15.987   227.461     0.200
    16.008   227.234     0.200
    16.008   226.961     0.200
    16.045   226.852     0.200
    16.039   228.531     0.200
    16.146   227.258     0.200
    16.137   228.078     0.200
    16.137   227.305     0.200
    16.185   229.609     0.200
    16.251   230.000     0.200
    16.269   228.508     0.200
    16.269   228.102     0.200
    16.347   231.094     0.200
    16.349   229.320     0.200
    16.388   231.562     0.200
    16.419   231.773     0.200
    16.419   230.914     0.200
    16.458   232.242     0.200
    16.568   233.859     0.200
    16.578   234.844     0.200
    16.579   233.859     0.200
    16.671   230.062     0.200
    16.676   235.797     0.200
    16.811   235.883     0.200
    16.801   235.758     0.200
    16.801   235.641     0.200
    16.871   237.219     0.200
    16.862   238.000     0.200
    16.889   236.203     0.200
    16.892   238.555     0.200
    16.921   237.859     0.200
    16.921   237.164     0.200
    16.975   239.062     0.200
    17.028   238.781     0.200
    16.990   238.922     0.200
    16.990   237.883     0.200
    17.089   238.758     0.200
    17.085   240.352     0.200
    17.085   240.188     0.200
    17.161   238.516     0.200
    17.161   238.008     0.200
    17.145   239.812     0.200
    17.219   238.203     0.200
    17.211   240.438     0.200
    17.144   239.461     0.200
    17.162   240.164     0.200
    17.162   240.008     0.200
    17.232   241.945     0.200
    17.197   239.711     0.200
    17.196   240.258     0.200
    17.275   242.500     0.200
    17.283   241.914     0.200
    17.307   241.273     0.200
    17.344   242.562     0.200
    17.344   242.023     0.200
    17.458   242.938     0.200
    17.395   242.664     0.200
    17.442   244.094     0.200
    17.635   244.969     0.200
    17.624   246.078     0.200
    17.728   246.367     0.200
    17.781   248.539     0.200
    17.836   248.562     0.200
    17.870   249.938     0.200
    17.918   249.328     0.200
    18.033   250.211     0.200
    18.033   250.062     0.200
    18.033   249.859     0.200
    18.043   251.773     0.200
    18.043   251.391     0.200
    18.139   249.883     0.200
    18.171   252.609     0.200
    18.171   252.312     0.200
    18.253   250.523     0.200
    18.253   249.961     0.200
    18.293   254.367     0.200
    18.321   254.484     0.200
    18.347   255.562     0.200
    18.427   257.578     0.200
    18.471   257.750     0.200
    18.637   260.242     0.200
    18.650   259.359     0.200
    18.701   260.602     0.200
    18.719   260.625     0.200
    18.719   260.461     0.200
    18.921   262.922     0.200
     1.175    19.484     0.200
     1.193    19.844     0.200
     1.400    23.117     0.200
     1.442    23.547     0.200
     1.457    23.586     0.200
     1.568    25.086     0.200
     1.583    25.305     0.200
     1.693    26.961     0.200
     1.855    29.414     0.200
     1.983    31.547     0.200
     2.121    33.539     0.200
     2.202    34.570     0.200
     2.346    36.727     0.200
     2.351    37.320     0.200
     2.467    38.906     0.200
     2.562    38.930     0.200
     2.575    40.023     0.200
     2.575    39.938     0.200
     2.575    39.648     0.200
     2.577    39.977     0.200
     2.638    40.828     0.200
     2.722    42.094     0.200
     2.731    42.430     0.200
     2.919    44.492     0.200
     2.919    44.867     0.200
     2.905    45.273     0.200
     4.918    74.688     0.200
     5.094    74.477     0.200
     5.157    75.078     0.200
     8.433   126.492     0.200
    13.896   198.492     0.200
    18.678   259.039     0.200
     0.879    15.017     0.200
     1.092    18.776     0.200
     1.143    18.677     0.200
     1.183    20.077     0.200
     1.158    18.997     0.200
     1.240    21.146     0.200
     1.247    20.937     0.200
     1.341    22.127     0.200
     1.323    21.907     0.200
     1.415    22.736     0.200
     1.424    23.017     0.200
     1.425    22.587     0.200
     1.513    24.207     0.200
     1.531    24.437     0.200
     1.649    25.787     0.200
     1.671    25.137     0.200
     1.788    28.337     0.200
     1.948    30.247     0.200
     1.953    30.097     0.200
     1.982    31.557     0.200
     2.067    32.627     0.200
     2.138    33.257     0.200
     2.314    35.547     0.200
     2.324    35.627     0.200
     2.419    36.736     0.200
     2.433    37.257     0.200
     2.503    38.057     0.200
     2.534    39.196     0.200
     2.535    39.087     0.200
     2.534    38.707     0.200
     2.536    39.177     0.200
     2.574    39.557     0.200
     2.677    40.937     0.200
     2.763    42.417     0.200
     2.834    43.547     0.200
     2.875    43.377     0.200
     2.875    43.227     0.200
     2.919    45.457     0.200
     2.989    46.177     0.200
     3.083    47.257     0.200
     3.193    49.146     0.200
     3.221    49.446     0.200
     3.265    49.627     0.200
     3.446    53.367     0.200
     3.494    53.106     0.200
     3.513    53.090     0.200
     3.607    54.776     0.200
     3.642    55.066     0.200
     3.716    55.127     0.200
     3.735    56.017     0.200
     3.824    57.106     0.200
     3.824    57.677     0.200
     4.328    62.867     0.200
     4.403    66.667     0.200
     4.837    69.577     0.200
     4.916    72.167     0.200
     4.933    73.854     0.200
     5.085    72.907     0.200
     5.085    72.606     0.200
     5.148    73.867     0.200
     5.148    73.767     0.200
     5.251    75.997     0.200
     5.832    83.247     0.200
     6.707    96.927     0.200
    13.864   198.077     0.200
    20.952   284.026     0.200
     1.114    18.797     0.200
     1.143    18.707     0.200
     1.160    18.945     0.200
     1.363    22.598     0.200
     1.425    22.676     0.200
     1.427    22.566     0.200
     1.432    23.234     0.200
     1.540    24.406     0.200
     1.654    25.875     0.200
     1.803    28.645     0.200
     1.954    30.305     0.200
     1.953    30.035     0.200
     1.979    31.375     0.200
     2.058    32.734     0.200
     2.077    32.754     0.200
     2.152    33.477     0.200
     2.317    35.625     0.200
     2.426    37.484     0.200
     2.539    38.875     0.200
     2.538    39.457     0.200
     2.539    38.836     0.200
     2.541    39.105     0.200
     2.683    41.746     0.200
     2.698    40.574     0.200
     2.852    44.188     0.200
     2.896    43.727     0.200
     2.924    45.465     0.200
     3.218    49.195     0.200
     3.451    53.367     0.200
     3.502    53.438     0.200
     3.626    54.816     0.200
     3.646    55.297     0.200
     3.830    57.754     0.200
     4.033    61.188     0.200
     4.339    63.406     0.200
     4.850    69.984     0.200
     4.919    73.555     0.200
     5.097    73.227     0.200
     5.160    74.254     0.200
     5.845    83.766     0.200
     6.452    96.055     0.200
    13.866   196.625     0.200
    18.670   258.527     0.200
     1.050    18.469     0.200
     1.050    18.038     0.200
     1.148    19.578     0.200
     1.266    21.448     0.200
     1.302    22.938     0.200
     1.311    22.259     0.200
     1.726    28.269     0.200
     1.978    32.038     0.200
     2.297    36.729     0.200
     2.703    42.488     0.200
     3.088    48.788     0.200
     3.711    57.618     0.200
     1.068    18.445     0.200
     1.480    25.176     0.200
     2.041    32.324     0.200
     2.876    43.676     0.200
     3.396    52.775     0.200
     6.184    91.254     0.200
     1.071    18.422     0.200
     0.752    14.109     0.200
     0.867    16.641     0.200
     0.893    16.047     0.200
     1.237    21.359     0.200
     1.259    21.016     0.200
     1.489    24.656     0.200
     1.517    25.078     0.200
     1.563    24.711     0.200
     1.630    26.508     0.200
     1.767    28.539     0.200
     1.768    28.609     0.200
     2.039    32.641     0.200
     2.271    36.781     0.200
     2.242    35.711     0.200
     2.331    36.586     0.200
     2.498    39.500     0.200
     2.608    41.547     0.200
     2.663    41.672     0.200
     2.694    42.859     0.200
     2.683    41.969     0.200
     2.820    44.547     0.200
     2.812    43.078     0.200
     2.898    44.547     0.200
     2.898    44.750     0.200
     2.898    44.188     0.200
     2.900    45.055     0.200
     2.953    46.547     0.200
     3.004    46.695     0.200
     3.032    46.398     0.200
     3.061    48.000     0.200
     3.100    46.977     0.200
     3.100    46.867     0.200
     3.125    48.758     0.200
     3.380    51.758     0.200
     3.426    52.930     0.200
     3.472    52.891     0.200
     3.740    57.438     0.200
     3.894    59.922     0.200
     3.988    60.570     0.200
     4.112    62.977     0.200
     4.112    63.648     0.200
     4.183    63.617     0.200
     4.326    66.695     0.200
     4.641    70.148     0.200
     4.654    70.375     0.200
     4.654    70.766     0.200
     5.104    76.727     0.200
     5.104    77.289     0.200
     5.801    86.266     0.200
     5.848    88.117     0.200
     5.914    88.836     0.200
     6.214    93.805     0.200
     6.461    94.641     0.200
     6.739    99.758     0.200
     7.112   104.352     0.200
     7.312   109.789     0.200
     8.182   123.625     0.200
     8.328   122.359     0.200
     8.905   132.898     0.200
     9.085   131.070     0.200
     9.989   143.227     0.200
    10.638   157.391     0.200
    11.138   163.609     0.200
    11.262   164.789     0.200
    11.398   168.328     0.200
    11.598   170.531     0.200
    11.822   173.156     0.200
    12.108   175.867     0.200
    12.186   176.102     0.200
    12.186   176.938     0.200
    12.210   178.297     0.200
    12.405   179.484     0.200
    12.508   177.609     0.200
    12.719   184.969     0.200
    13.310   192.117     0.200
    14.162   203.977     0.200
    14.162   203.523     0.200
    15.289   213.602     0.200
    16.124   225.555     0.200
    18.720   260.008     0.200
    20.608   280.703     0.200
     1.046    17.675     0.200
     1.182    19.355     0.200
     1.143    19.405     0.200
     1.156    19.225     0.200
     1.199    19.845     0.200
     1.312    22.035     0.200
     1.348    21.535     0.200
     1.465    23.345     0.200
     1.480    23.715     0.200
     1.532    24.405     0.200
     1.746    27.625     0.200
     1.747    27.245     0.200
     1.838    28.885     0.200
     1.965    30.965     0.200
     2.198    34.015     0.200
     2.265    34.325     0.200
     2.275    35.285     0.200
     2.372    36.295     0.200
     2.370    36.195     0.200
     2.419    37.035     0.200
     2.613    40.165     0.200
     2.696    40.990     0.200
     2.696    40.845     0.200
     2.731    42.565     0.200
     2.752    41.985     0.200
     2.795    42.335     0.200
     2.812    42.425     0.200
     2.853    43.085     0.200
     2.853    42.646     0.200
     2.853    42.635     0.200
     2.854    44.005     0.200
     2.855    44.365     0.200
     2.852    43.985     0.200
     2.911    44.635     0.200
     2.992    46.405     0.200
     3.082    47.315     0.200
     3.083    47.045     0.200
     3.234    49.785     0.200
     3.283    49.405     0.200
     3.541    53.955     0.200
     3.579    54.275     0.200
     3.624    55.205     0.200
     3.804    57.285     0.200
     3.915    56.975     0.200
     3.836    57.355     0.200
     3.836    57.505     0.200
     4.038    59.055     0.200
     3.962    59.205     0.200
     4.013    59.515     0.200
     4.037    60.855     0.200
     4.025    60.975     0.200
     4.138    61.965     0.200
     4.417    64.295     0.200
     4.459    64.235     0.200
     4.498    66.375     0.200
     4.557    65.745     0.200
     4.557    64.985     0.200
     4.484    66.525     0.200
     4.722    69.835     0.200
     4.799    69.025     0.200
     4.799    68.792     0.200
     4.754    70.815     0.200
     4.862    69.992     0.200
     4.862    69.975     0.200
     4.999    73.835     0.200
     5.094    74.455     0.200
     5.131    76.915     0.200
     5.131    77.315     0.200
     5.207    77.165     0.200
     5.554    80.225     0.200
     5.561    79.885     0.200
     5.832    84.065     0.200
     5.868    86.195     0.200
     6.076    88.146     0.200
     6.246    90.475     0.200
     6.284    89.295     0.200
     6.404    91.955     0.200
     6.418    93.785     0.200
     7.013   102.167     0.200
     7.218   102.565     0.200
     9.056   131.962     0.200
     9.056   131.815     0.200
     9.056   129.875     0.200
     9.647   137.295     0.200
    10.032   142.155     0.200
    14.186   202.501     0.200
    14.853   207.265     0.200
    15.911   221.646     0.200
    16.381   227.495     0.200
    17.348   239.995     0.200
    17.529   240.725     0.200
     0.122     6.355     0.200
     0.271     7.666     0.200
     0.286     7.696     0.200
     0.316     8.226     0.200
     0.523    10.616     0.200
     0.565    11.206     0.200
     0.602    11.605     0.200
     0.631    12.266     0.200
     0.704    13.046     0.200
     0.812    14.516     0.200
     0.883    15.966     0.200
     0.984    17.386     0.200
     0.987    17.446     0.200
     1.047    17.596     0.200
     1.112    18.546     0.200
     1.147    19.346     0.200
     1.122    19.336     0.200
     1.141    19.446     0.200
     1.141    18.596     0.200
     1.240    21.306     0.200
     1.257    20.756     0.200
     1.279    21.566     0.200
     1.279    21.146     0.200
     1.433    23.686     0.200
     1.457    24.105     0.200
     1.476    24.386     0.200
     1.539    25.166     0.200
     1.542    25.116     0.200
     1.571    24.486     0.200
     1.586    25.506     0.200
     1.594    25.236     0.200
     1.593    25.176     0.200
     1.593    25.486     0.200
     1.595    25.166     0.200
     1.595    25.146     0.200
     1.595    25.216     0.200
     1.600    25.766     0.200
     1.711    26.855     0.200
     1.711    27.496     0.200
     1.765    27.206     0.200
     1.881    29.866     0.200
     1.881    30.076     0.200
     1.916    30.256     0.200
     1.961    28.176     0.200
     1.974    30.966     0.200
     2.044    32.193     0.200
     2.053    32.696     0.200
     2.053    32.826     0.200
     2.132    33.086     0.200
     2.180    33.866     0.200
     2.174    33.546     0.200
     2.351    36.466     0.200
     2.386    36.776     0.200
     2.411    36.815     0.200
     2.401    36.956     0.200
     2.448    37.736     0.200
     2.503    39.066     0.200
     2.523    38.536     0.200
     2.552    39.526     0.200
     2.574    39.433     0.200
     2.704    41.456     0.200
     2.811    42.396     0.200
     2.817    42.948     0.200
     2.827    43.266     0.200
     2.880    44.026     0.200
     2.880    43.816     0.200
     2.880    43.976     0.200
     2.867    44.116     0.200
     3.014    45.036     0.200
     3.014    45.226     0.200
     3.073    46.756     0.200
     3.200    48.605     0.200
     3.200    48.266     0.200
     3.224    49.186     0.200
     3.381    50.863     0.200
     3.367    49.996     0.200
     3.449    51.699     0.200
     3.531    52.956     0.200
     3.585    53.716     0.200
     3.585    53.926     0.200
     3.605    53.535     0.200
     3.856    57.546     0.200
     3.891    58.156     0.200
     3.891    58.396     0.200
     4.005    59.146     0.200
     4.313    63.957     0.200
     4.308    63.316     0.200
     4.308    63.625     0.200
     4.386    65.401     0.200
     4.665    67.516     0.200
     4.744    69.666     0.200
     4.890    72.536     0.200
     4.914    71.176     0.200
     4.956    73.601     0.200
     5.022    72.966     0.200
     5.030    73.086     0.200
     5.025    73.986     0.200
     5.092    74.859     0.200
     5.112    74.546     0.200
     5.122    74.826     0.200
     5.241    76.625     0.200
     5.235    75.796     0.200
     5.268    77.056     0.200
     5.365    77.756     0.200
     5.372    78.736     0.200
     5.558    81.686     0.200
     5.581    80.056     0.200
     5.706    83.526     0.200
     5.728    83.421     0.200
     5.759    82.806     0.200
     5.768    83.308     0.200
     5.768    83.417     0.200
     5.768    83.076     0.200
     5.856    85.067     0.200
     5.847    83.546     0.200
     5.866    85.086     0.200
     6.032    86.875     0.200
     6.150    89.277     0.200
     6.323    91.056     0.200
     6.451    94.192     0.200
     6.560    93.566     0.200
     6.584    94.326     0.200
     6.646    96.517     0.200
     6.661    95.686     0.200
     6.670    98.218     0.200
     6.855    98.546     0.200
     6.820    97.316     0.200
     7.120   105.333     0.200
     7.181   104.255     0.200
     7.202   102.605     0.200
     7.211   104.316     0.200
     7.213   104.576     0.200
     7.365   106.421     0.200
     7.557   109.476     0.200
     7.747   114.934     0.200
     7.744   110.176     0.200
     7.755   110.816     0.200
     7.888   114.858     0.200
     8.049   118.601     0.200
     8.248   116.857     0.200
     8.482   124.039     0.200
     8.551   122.736     0.200
     8.758   124.676     0.200
     8.953   127.186     0.200
     9.244   134.688     0.200
     9.314   132.602     0.200
     9.593   135.756     0.200
     9.626   136.536     0.200
     9.626   136.016     0.200
     9.612   138.646     0.200
     9.612   136.846     0.200
     9.649   136.386     0.200
     9.708   137.286     0.200
     9.758   137.716     0.200
     9.814   138.576     0.200
     9.856   139.726     0.200
    10.210   144.688     0.200
    10.210   144.156     0.200
    10.645   150.268     0.200
    10.645   149.836     0.200
    10.688   150.536     0.200
    10.786   152.456     0.200
    10.872   153.316     0.200
    10.877   154.936     0.200
    11.232   163.133     0.200
    11.355   159.836     0.200
    11.383   160.046     0.200
    11.433   161.796     0.200
    11.527   162.596     0.200
    11.667   163.875     0.200
    11.818   166.086     0.200
    11.917   167.397     0.200
    11.917   167.516     0.200
    12.005   173.921     0.200
    12.631   181.256     0.200
    12.836   180.954     0.200
    12.836   180.056     0.200
    12.936   184.233     0.200
    12.936   184.446     0.200
    13.026   182.636     0.200
    13.062   186.001     0.200
    13.251   185.706     0.200
    13.312   187.003     0.200
    13.312   186.276     0.200
    13.452   192.336     0.200
    13.576   190.156     0.200
    13.906   198.472     0.200
    14.032   196.756     0.200
    14.088   197.186     0.200
    14.196   199.284     0.200
    14.199   198.178     0.200
    14.261   202.972     0.200
    14.437   205.283     0.200
    14.487   206.328     0.200
    14.523   203.656     0.200
    14.832   206.866     0.200
    14.857   207.383     0.200
    14.936   209.312     0.200
    15.176   212.176     0.200
    15.236   212.826     0.200
    15.347   214.622     0.200
    15.347   214.125     0.200
    15.357   214.366     0.200
    15.353   214.553     0.200
    15.353   213.826     0.200
    15.389   215.402     0.200
    15.712   216.729     0.200
    15.712   216.966     0.200
    15.931   223.057     0.200
    15.947   222.686     0.200
    15.992   222.676     0.200
    16.086   225.312     0.200
    16.082   223.576     0.200
    16.106   224.046     0.200
    16.157   224.716     0.200
    16.165   224.526     0.200
    16.205   225.096     0.200
    16.210   225.256     0.200
    16.220   225.135     0.200
    16.311   225.875     0.200
    16.754   232.826     0.200
    16.801   233.697     0.200
    17.100   236.536     0.200
    17.295   239.478     0.200
    17.300   240.108     0.200
    17.335   237.888     0.200
    17.585   243.625     0.200
    17.801   245.353     0.200
    17.917   246.467     0.200
    18.019   247.781     0.200
    18.333   254.864     0.200
    19.023   261.449     0.200
    19.241   265.352     0.200
    19.255   263.896     0.200
    19.664   268.403     0.200
    19.759   269.195     0.200
    20.094   272.766     0.200
    20.288   275.712     0.200
     0.779    14.379     0.200
     0.779    14.219     0.200
     0.842    15.227     0.200
     0.898    16.508     0.200
     1.086    19.199     0.200
     1.101    19.129     0.200
     1.105    19.188     0.200
     1.105    19.367     0.200
     1.115    18.707     0.200
     1.114    18.930     0.200
     1.108    19.086     0.200
     1.140    20.137     0.200
     1.174    20.520     0.200
     1.194    20.668     0.200
     1.204    20.066     0.200
     1.205    20.137     0.200
     1.205    20.117     0.200
     1.205    20.180     0.200
     1.206    20.137     0.200
     1.209    20.289     0.200
     1.232    20.848     0.200
     1.270    21.449     0.200
     1.270    21.578     0.200
     1.299    21.988     0.200
     1.291    21.469     0.200
     1.317    22.098     0.200
     1.319    22.496     0.200
     1.310    21.879     0.200
     1.415    23.699     0.200
     1.425    23.777     0.200
     1.442    23.859     0.200
     1.442    23.609     0.200
     1.454    24.168     0.200
     1.454    24.059     0.200
     1.535    25.336     0.200
     1.530    25.258     0.200
     1.567    25.848     0.200
     1.627    27.906     0.200
     1.609    26.047     0.200
     1.804    29.406     0.200
     1.790    28.816     0.200
     1.837    30.547     0.200
     1.875    30.109     0.200
     1.896    30.836     0.200
     1.916    31.996     0.200
     1.906    30.867     0.200
     1.936    31.227     0.200
     2.020    33.488     0.200
     2.066    32.996     0.200
     2.117    34.348     0.200
     2.117    34.648     0.200
     2.122    34.039     0.200
     2.126    33.836     0.200
     2.205    35.078     0.200
     2.210    35.438     0.200
     2.213    35.297     0.200
     2.203    35.309     0.200
     2.228    35.457     0.200
     2.228    35.688     0.200
     2.258    34.938     0.200
     2.268    35.938     0.200
     2.307    37.336     0.200
     2.310    37.059     0.200
     2.407    38.547     0.200
     2.407    38.770     0.200
     2.562    40.719     0.200
     2.629    41.488     0.200
     2.629    41.789     0.200
     2.703    41.789     0.200
     2.698    42.336     0.200
     2.766    43.719     0.200
     2.766    43.406     0.200
     2.787    44.156     0.200
     2.796    43.688     0.200
     2.936    47.039     0.200
     2.943    46.277     0.200
     3.128    48.168     0.200
     3.383    51.809     0.200
     3.538    54.098     0.200
     3.634    55.348     0.200
     3.634    53.938     0.200
     3.703    56.039     0.200
     4.319    63.617     0.200
     4.319    63.496     0.200
     5.096    74.578     0.200
     0.218     6.775     0.200
     0.337     7.977     0.200
     0.345     8.307     0.200
     0.420     8.996     0.200
     0.526    10.336     0.200
     0.535    10.406     0.200
     0.782    13.596     0.200
     0.798    14.016     0.200
     0.792    14.146     0.200
     0.885    15.215     0.200
     0.878    15.695     0.200
     0.885    15.025     0.200
     0.938    15.846     0.200
     0.998    17.045     0.200
     1.043    18.205     0.200
     1.079    18.227     0.200
     1.162    19.605     0.200
     1.303    20.826     0.200
     1.284    21.535     0.200
     1.331    21.945     0.200
     1.349    21.506     0.200
     1.404    22.705     0.200
     1.413    22.756     0.200
     1.629    26.285     0.200
     1.693    27.646     0.200
     1.768    27.426     0.200
     1.830    28.855     0.200
     1.830    29.195     0.200
     1.830    28.816     0.200
     1.832    29.406     0.200
     1.849    29.186     0.200
     1.874    29.516     0.200
     2.011    31.086     0.200
     2.145    34.086     0.200
     2.174    34.215     0.200
     2.250    35.406     0.200
     2.943    44.775     0.200
     3.126    46.576     0.200
     3.263    48.227     0.200
     3.788    56.727     0.200
     0.204     6.867     0.200
     0.252     7.258     0.200
     0.281     7.375     0.200
     0.281     7.414     0.200
     0.322     7.625     0.200
     0.392     8.602     0.200
     0.404     9.125     0.200
     0.424     9.102     0.200
     0.642    12.266     0.200
     0.707    13.031     0.200
     0.761    13.508     0.200
     0.800    13.984     0.200
     0.800    13.914     0.200
     0.807    14.641     0.200
     0.831    14.984     0.200
     0.850    15.078     0.200
     0.844    15.141     0.200
     0.877    15.289     0.200
     0.909    15.891     0.200
     0.902    15.531     0.200
     0.935    16.609     0.200
     1.038    17.984     0.200
     1.129    18.219     0.200
     1.167    19.781     0.200
     1.281    21.188     0.200
     1.282    20.906     0.200
     1.282    21.188     0.200
     1.284    21.227     0.200
     1.321    21.797     0.200
     1.327    21.656     0.200
     1.358    22.578     0.200
     1.401    23.461     0.200
     1.421    23.219     0.200
     1.434    22.805     0.200
     1.456    23.477     0.200
     1.459    23.227     0.200
     1.651    26.156     0.200
     1.662    26.141     0.200
     1.778    28.359     0.200
     1.795    28.656     0.200
     1.941    29.609     0.200
     2.083    32.641     0.200
     2.131    30.320     0.200
     2.131    33.289     0.200
     2.243    35.469     0.200
     2.410    36.875     0.200
     2.564    38.961     0.200
     2.568    39.828     0.200
     2.661    41.359     0.200
     2.774    39.297     0.200
     2.803    41.836     0.200
     2.795    39.609     0.200
     3.246    49.047     0.200
     3.869    57.719     0.200
     0.488     9.719     0.200
     0.520    10.477     0.200
     1.090    17.867     0.200
     1.371    19.609     0.200
     1.182    20.219     0.200
     1.305    21.781     0.200
     1.379    22.516     0.200
     1.408    22.727     0.200
     1.580    25.156     0.200
     1.580    25.039     0.200
     1.604    26.148     0.200
     1.569    26.000     0.200
     1.577    26.211     0.200
     1.604    26.219     0.200
     1.701    27.336     0.200
     1.708    27.805     0.200
     1.921    27.367     0.200
     1.943    27.641     0.200
     1.823    28.766     0.200
     1.828    28.477     0.200
     1.887    30.234     0.200
     1.989    31.891     0.200
     2.024    31.156     0.200
     2.068    31.555     0.200
     2.043    31.680     0.200
     2.043    31.891     0.200
     2.043    31.688     0.200
     2.045    31.805     0.200
     2.045    31.914     0.200
     2.167    33.156     0.200
     2.183    34.695     0.200
     2.216    34.469     0.200
     2.313    35.617     0.200
     2.614    40.898     0.200
     2.632    40.539     0.200
     2.918    44.250     0.200
     2.929    44.766     0.200
     2.952    45.961     0.200
     3.056    46.328     0.200
     3.055    47.141     0.200
     3.124    47.828     0.200
     3.346    50.852     0.200
     3.471    51.852     0.200
     3.483    52.000     0.200
     3.484    53.008     0.200
     3.789    57.328     0.200
     3.812    57.320     0.200
     4.238    63.461     0.200
     4.325    64.648     0.200
     4.550    66.414     0.200
     4.796    70.555     0.200
     5.639    83.469     0.200
     5.779    85.352     0.200
     5.791    85.328     0.200
     0.035     5.406     0.200
     0.066     5.367     0.200
     0.302     7.445     0.200
     0.299     7.207     0.200
     0.300     7.156     0.200
     0.521     9.805     0.200
     0.710    12.527     0.200
     0.771    13.984     0.200
     0.829    14.277     0.200
     0.859    15.195     0.200
     0.859    14.547     0.200
     0.913    15.867     0.200
     0.934    15.695     0.200
     0.934    15.676     0.200
     0.934    15.785     0.200
     1.003    17.266     0.200
     1.003    17.375     0.200
     1.036    17.547     0.200
     1.049    18.047     0.200
     1.049    18.156     0.200
     1.198    20.117     0.200
     1.222    20.297     0.200
     1.219    20.027     0.200
     1.238    20.887     0.200
     1.326    21.797     0.200
     1.356    22.625     0.200
     1.368    21.984     0.200
     1.355    21.848     0.200
     1.411    22.445     0.200
     1.410    22.445     0.200
     1.411    22.215     0.200
     1.411    22.395     0.200
     1.413    22.445     0.200
     1.413    22.277     0.200
     1.457    24.297     0.200
     1.490    23.316     0.200
     1.512    24.406     0.200
     1.566    24.527     0.200
     1.567    25.195     0.200
     1.634    26.117     0.200
     1.804    28.578     0.200
     1.931    26.957     0.200
     1.931    30.816     0.200
     1.944    29.906     0.200
     2.117    33.328     0.200
     2.125    33.035     0.200
     2.212    33.848     0.200
     2.212    34.008     0.200
     2.298    36.316     0.200
     2.324    36.996     0.200
     2.364    36.406     0.200
     2.400    37.406     0.200
     2.514    38.734     0.200
     2.577    35.965     0.200
     2.598    36.535     0.200
     2.713    41.457     0.200
     2.821    42.387     0.200
     2.862    43.656     0.200
     2.862    43.945     0.200
     2.977    46.984     0.200
     3.041    46.605     0.200
     3.307    49.957     0.200
     3.357    51.145     0.200
     3.357    51.035     0.200
     3.600    53.281     0.200
     3.683    56.457     0.200
     3.713    55.965     0.200
     3.890    57.676     0.200
     3.966    58.375     0.200
     4.012    59.816     0.200
     4.082    59.945     0.200
     4.481    65.605     0.200
     4.662    69.035     0.200
     4.722    69.016     0.200
     4.807    69.887     0.200
     4.833    69.727     0.200
     4.860    70.395     0.200
     4.878    71.234     0.200
     4.896    70.484     0.200
     5.040    74.137     0.200
     5.147    75.027     0.200
     5.233    76.387     0.200
     5.545    80.867     0.200
     5.566    81.695     0.200
     5.599    79.805     0.200
     5.617    80.145     0.200
     5.617    81.324     0.200
     5.933    84.945     0.200
     6.380    91.637     0.200
     7.004    99.977     0.200
     7.235   104.785     0.200
     7.523   112.223     0.200
     7.591   109.875     0.200
     8.213   117.406     0.200
     8.717   125.285     0.200
     9.925   141.727     0.200
    11.000   160.430     0.200
    11.770   170.812     0.200
    12.736   181.984     0.200
    19.197   262.008     0.200
    19.489   265.051     0.200
    20.834   280.465     0.200
     0.299     7.883     0.200
     0.340     8.203     0.200
     0.403     8.992     0.200
     0.463     9.523     0.200
     0.462     9.572     0.200
     0.659    12.703     0.200
     0.655    12.594     0.200
     0.740    13.832     0.200
     0.740    13.402     0.200
     0.779    14.303     0.200
     0.966    16.322     0.200
     0.943    16.023     0.200
     0.955    16.264     0.200
     0.955    16.123     0.200
     0.941    16.453     0.200
     0.975    16.273     0.200
     1.107    17.832     0.200
     1.094    18.322     0.200
     1.067    18.002     0.200
     1.067    18.203     0.200
     1.173    19.912     0.200
     1.220    20.723     0.200
     1.220    20.752     0.200
     1.266    20.562     0.200
     1.278    21.023     0.200
     1.294    21.643     0.200
     1.427    23.482     0.200
     1.393    22.412     0.200
     1.434    22.854     0.200
     1.434    22.732     0.200
     1.434    22.953     0.200
     1.435    22.922     0.200
     1.436    22.703     0.200
     1.435    22.732     0.200
     1.512    24.344     0.200
     1.499    24.203     0.200
     1.559    25.172     0.200
     1.613    25.992     0.200
     1.604    25.133     0.200
     1.623    25.072     0.200
     1.748    27.902     0.200
     1.748    28.072     0.200
     1.786    28.344     0.200
     1.802    28.303     0.200
     1.836    28.562     0.200
     1.844    29.582     0.200
     1.867    30.053     0.200
     1.867    29.193     0.200
     1.947    30.873     0.200
     1.947    30.572     0.200
     2.154    30.514     0.200
     2.134    32.412     0.200
     2.233    34.242     0.200
     2.207    34.264     0.200
     2.252    34.982     0.200
     2.252    34.793     0.200
     2.367    37.523     0.200
     2.367    37.383     0.200
     2.409    36.463     0.200
     2.420    37.152     0.200
     2.545    39.773     0.200
     2.622    40.533     0.200
     2.745    38.883     0.200
     2.768    39.162     0.200
     2.705    42.223     0.200
     2.786    39.443     0.200
     2.986    44.273     0.200
     3.039    45.684     0.200
     3.031    46.953     0.200
     3.090    47.033     0.200
     3.377    51.732     0.200
     3.395    49.912     0.200
     3.423    51.934     0.200
     3.488    52.502     0.200
     3.488    52.293     0.200
     3.609    54.082     0.200
     3.641    55.033     0.200
     3.683    55.662     0.200
     3.712    56.422     0.200
     3.741    56.764     0.200
     3.744    57.922     0.200
     3.752    56.172     0.200
     3.801    56.123     0.200
     3.896    58.652     0.200
     4.042    61.693     0.200
     4.200    60.662     0.200
     4.305    63.312     0.200
     4.674    69.902     0.200
     4.706    68.373     0.200
     5.079    75.184     0.200
     5.081    74.393     0.200
     5.203    74.672     0.200
     5.204    74.672     0.200
     5.258    76.822     0.200
     5.398    78.662     0.200
     6.278    92.463     0.200
     6.321    94.303     0.200
     0.260     6.430     0.200
     0.401     8.199     0.200
     0.449     8.859     0.200
     0.500     9.422     0.200
     0.566    10.199     0.200
     0.595    11.121     0.200
     0.596    11.020     0.200
     0.803    14.320     0.200
     0.961    16.230     0.200
     0.980    16.898     0.200
     1.036    16.832     0.200
     1.056    17.160     0.200
     1.124    18.789     0.200
     1.190    19.270     0.200
     1.242    20.691     0.200
     1.255    20.809     0.200
     1.255    20.680     0.200
     1.245    20.320     0.200
     1.245    20.160     0.200
     1.245    20.352     0.200
     1.373    22.191     0.200
     1.422    22.410     0.200
     1.422    22.309     0.200
     1.481    21.238     0.200
     1.423    23.082     0.200
     1.436    23.172     0.200
     1.436    23.641     0.200
     1.441    23.641     0.200
     1.461    23.191     0.200
     1.550    25.172     0.200
     1.631    25.590     0.200
     1.668    27.141     0.200
     1.668    27.039     0.200
     1.680    27.410     0.200
     1.687    27.070     0.200
     1.687    26.602     0.200
     1.687    25.941     0.200
     1.689    26.789     0.200
     1.747    28.539     0.200
     1.747    28.488     0.200
     1.747    27.422     0.200
     1.767    27.660     0.200
     1.792    27.609     0.200
     1.859    28.961     0.200
     1.907    30.270     0.200
     1.874    29.832     0.200
     1.909    29.391     0.200
     1.922    30.520     0.200
     2.029    31.789     0.200
     2.084    33.031     0.200
     2.097    32.500     0.200
     2.150    33.250     0.200
     2.213    34.289     0.200
     2.253    35.199     0.200
     2.338    36.102     0.200
     2.341    36.469     0.200
     2.422    36.699     0.200
     2.422    36.879     0.200
     2.390    35.988     0.200
     2.489    39.121     0.200
     2.557    38.949     0.200
     2.560    38.789     0.200
     2.715    42.672     0.200
     2.715    42.320     0.200
     2.747    41.941     0.200
     2.984    45.949     0.200
     3.072    47.301     0.200
     3.098    47.238     0.200
     3.193    47.762     0.200
     3.228    47.988     0.200
     3.282    50.082     0.200
     3.311    50.711     0.200
     3.353    50.590     0.200
     3.418    52.031     0.200
     3.448    52.898     0.200
     3.457    52.680     0.200
     3.474    51.441     0.200
     3.491    53.121     0.200
     3.490    53.789     0.200
     3.500    53.340     0.200
     3.523    53.730     0.200
     3.549    54.461     0.200
     3.557    54.609     0.200
     3.562    54.410     0.200
     3.569    54.422     0.200
     3.781    56.449     0.200
     3.843    58.059     0.200
     3.937    59.930     0.200
     4.431    66.871     0.200
     4.679    68.789     0.200
     5.089    73.941     0.200
     5.367    77.262     0.200
     5.367    77.340     0.200
     5.656    81.840     0.200
     6.943   100.602     0.200
     0.076     5.602     0.200
     0.244     6.512     0.200
     0.254     6.723     0.200
     0.358     8.602     0.200
     0.427     9.555     0.200
     0.467     9.562     0.200
     0.516    10.523     0.200
     0.559    10.531     0.200
     0.560    10.594     0.200
     0.575    10.934     0.200
     0.576    10.773     0.200
     0.576    10.992     0.200
     0.609    11.242     0.200
     0.702    12.773     0.200
     0.806    14.055     0.200
     0.856    14.781     0.200
     0.838    14.684     0.200
     0.838    14.574     0.200
     0.856    14.762     0.200
     0.857    14.684     0.200
     0.857    14.805     0.200
     0.848    15.102     0.200
     0.897    15.012     0.200
     0.963    16.754     0.200
     0.970    16.703     0.200
     1.030    17.352     0.200
     1.074    18.395     0.200
     1.115    18.664     0.200
     1.123    19.113     0.200
     1.115    18.664     0.200
     1.259    21.055     0.200
     1.301    21.492     0.200
     1.311    21.684     0.200
     1.336    22.242     0.200
     1.336    22.473     0.200
     1.360    22.465     0.200
     1.360    22.121     0.200
     1.373    22.723     0.200
     1.378    22.293     0.200
     1.391    22.543     0.200
     1.477    23.684     0.200
     1.508    24.234     0.200
     1.565    25.062     0.200
     1.607    26.133     0.200
     1.662    26.652     0.200
     1.674    26.664     0.200
     1.674    26.473     0.200
     1.728    27.852     0.200
     1.728    27.504     0.200
     1.737    27.223     0.200
     1.837    29.562     0.200
     1.837    29.414     0.200
     1.884    30.172     0.200
     1.884    30.422     0.200
     1.972    30.395     0.200
     2.035    31.422     0.200
     2.103    33.422     0.200
     2.103    33.254     0.200
     2.132    32.734     0.200
     2.146    33.684     0.200
     2.156    33.254     0.200
     2.158    33.852     0.200
     2.158    33.484     0.200
     2.184    34.465     0.200
     2.184    34.012     0.200
     2.206    33.504     0.200
     2.229    35.164     0.200
     2.230    35.664     0.200
     2.230    35.062     0.200
     2.315    36.422     0.200
     2.374    36.754     0.200
     2.425    37.672     0.200
     2.462    37.871     0.200
     2.483    37.984     0.200
     2.483    38.164     0.200
     2.504    37.902     0.200
     2.523    38.613     0.200
     2.523    38.145     0.200
     2.543    39.441     0.200
     2.550    39.082     0.200
     2.554    38.684     0.200
     2.578    39.715     0.200
     2.612    40.402     0.200
     2.612    40.145     0.200
     2.601    40.004     0.200
     2.618    40.633     0.200
     2.634    40.414     0.200
     2.676    41.133     0.200
     2.685    41.395     0.200
     2.734    42.824     0.200
     2.747    43.062     0.200
     2.772    41.805     0.200
     2.886    43.684     0.200
     2.875    44.512     0.200
     2.880    44.082     0.200
     2.953    44.754     0.200
     3.205    47.844     0.200
     3.205    47.562     0.200
     3.300    50.652     0.200
     3.302    49.883     0.200
     3.529    54.324     0.200
     3.659    55.715     0.200
     3.900    58.121     0.200
     4.064    60.492     0.200
     4.071    61.531     0.200
     4.126    60.582     0.200
     4.323    62.402     0.200
     4.332    65.145     0.200
     4.413    64.395     0.200
     5.736    82.555     0.200
     1.034    17.586     0.200
     1.034    17.742     0.200
     1.091    18.195     0.200
     1.109    18.102     0.200
     1.154    19.156     0.200
     1.154    19.172     0.200
     1.155    19.086     0.200
     1.156    19.031     0.200
     1.156    19.172     0.200
     1.230    20.141     0.200
     1.209    20.070     0.200
     1.247    19.930     0.200
     1.247    20.070     0.200
     1.240    21.070     0.200
     1.352    22.539     0.200
     1.349    22.750     0.200
     1.342    22.023     0.200
     1.397    22.266     0.200
     1.466    23.570     0.200
     1.478    24.539     0.200
     1.652    26.766     0.200
     1.653    26.289     0.200
     1.695    27.133     0.200
     1.700    27.727     0.200
     1.721    27.555     0.200
     1.731    27.539     0.200
     1.754    27.945     0.200
     1.840    29.492     0.200
     1.871    29.273     0.200
     1.871    29.406     0.200
     1.898    27.156     0.200
     1.930    31.102     0.200
     1.930    31.172     0.200
     1.962    30.484     0.200
     2.105    32.500     0.200
     2.156    34.766     0.200
     2.156    34.602     0.200
     2.201    34.602     0.200
     2.337    36.023     0.200
     2.405    37.164     0.200
     2.405    37.266     0.200
     2.553    39.570     0.200
     2.615    40.250     0.200
     2.598    39.992     0.200
     2.669    37.453     0.200
     2.744    41.586     0.200
     2.855    43.336     0.200
     2.877    43.773     0.200
     2.887    43.977     0.200
     2.913    44.094     0.200
     2.971    46.031     0.200
     3.048    46.430     0.200
     3.305    50.344     0.200
     3.600    53.945     0.200
     3.748    55.961     0.200
     3.861    57.844     0.200
     3.900    57.891     0.200
     3.900    57.516     0.200
     3.945    57.875     0.200
     4.044    60.906     0.200
     4.083    60.086     0.200
     4.083    59.742     0.200
     4.128    61.016     0.200
     4.183    61.852     0.200
     4.205    61.984     0.200
     4.248    63.789     0.200
     4.377    65.266     0.200
     4.394    64.320     0.200
     4.404    64.539     0.200
     4.481    65.156     0.200
     4.559    67.945     0.200
     4.622    68.492     0.200
     4.890    73.039     0.200
     5.070    74.953     0.200
     5.378    77.875     0.200
     5.378    78.000     0.200
     5.396    77.914     0.200
     5.470    79.555     0.200
     5.737    84.742     0.200
     5.801    83.359     0.200
     5.933    86.422     0.200
     6.002    86.273     0.200
     6.405    91.930     0.200
     6.565    94.672     0.200
     6.547    94.125     0.200
     7.049   105.117     0.200
     7.194   103.766     0.200
     7.340   105.500     0.200
     7.754   111.602     0.200
     7.784   110.203     0.200
     7.786   112.836     0.200
     8.833   125.922     0.200
     9.001   129.000     0.200
     9.001   130.531     0.200
     9.176   130.031     0.200
     9.262   131.555     0.200
     9.712   137.406     0.200
    10.302   145.422     0.200
    10.303   147.883     0.200
    10.540   152.961     0.200
    10.548   149.172     0.200
    11.109   157.461     0.200
    11.286   164.055     0.200
    11.865   170.906     0.200
    12.165   173.664     0.200
    12.165   174.305     0.200
    12.364   177.281     0.200
    12.929   181.164     0.200
    13.543   192.656     0.200
    13.912   195.523     0.200
    14.000   196.039     0.200
    14.117   198.742     0.200
    14.200   199.453     0.200
    14.472   203.211     0.200
    14.614   203.539     0.200
    14.738   206.523     0.200
    15.075   209.703     0.200
    15.254   211.695     0.200
    15.844   221.164     0.200
    16.239   225.242     0.200
    16.551   230.656     0.200
    17.643   243.625     0.200
    17.737   243.961     0.200
    19.430   264.977     0.200
    19.532   265.836     0.200
    19.973   271.234     0.200
    19.973   270.633     0.200
    20.242   273.961     0.200
     0.505     9.479     0.200
     0.700    12.898     0.200
     0.900    15.648     0.200
     1.011    17.719     0.200
     1.106    18.479     0.200
     1.077    18.039     0.200
     1.127    18.619     0.200
     1.202    20.510     0.200
     1.437    24.270     0.200
     1.437    24.068     0.200
     1.437    23.498     0.200
     1.513    24.809     0.200
     1.570    26.148     0.200
     1.674    27.389     0.200
     1.703    26.600     0.200
     1.703    26.709     0.200
     1.786    27.998     0.200
     1.916    30.908     0.200
     1.916    30.469     0.200
     1.934    30.309     0.200
     1.934    30.918     0.200
     2.060    31.709     0.200
     2.060    31.529     0.200
     2.109    33.840     0.200
     2.105    33.398     0.200
     2.191    33.668     0.200
     2.283    36.398     0.200
     2.338    35.439     0.200
     2.449    37.078     0.200
     2.548    37.949     0.200
     2.688    40.559     0.200
     2.738    42.100     0.200
     3.168    46.988     0.200
     3.173    47.219     0.200
     3.552    53.059     0.200
     3.743    54.260     0.200
     3.747    55.078     0.200
     4.171    61.139     0.200
     4.688    68.520     0.200
     4.732    68.279     0.200
     5.558    80.309     0.200
     0.654    12.180     0.200
     0.679    12.578     0.200
     1.129    18.977     0.200
     1.129    18.898     0.200
     1.197    19.930     0.200
     1.228    20.938     0.200
     1.370    22.246     0.200
     1.500    24.836     0.200
     1.514    25.316     0.200
     1.667    26.328     0.200
     1.898    29.977     0.200
     1.863    29.770     0.200
     1.981    31.430     0.200
     2.570    40.918     0.200
     0.166     5.750     0.200
     0.210     6.055     0.200
     0.320     7.203     0.200
     0.344     7.477     0.200
     0.355     7.984     0.200
     0.414     8.453     0.200
     0.414     8.422     0.200
     0.493     9.562     0.200
     0.593    11.102     0.200
     0.801    14.211     0.200
     0.882    14.695     0.200
     0.866    15.461     0.200
     0.903    15.375     0.200
     0.903    15.406     0.200
     0.912    16.211     0.200
     0.915    16.062     0.200
     0.949    16.305     0.200
     1.120    19.203     0.200
     1.125    18.656     0.200
     1.211    20.273     0.200
     1.271    21.477     0.200
     1.281    21.273     0.200
     1.349    22.547     0.200
     1.385    22.844     0.200
     1.875    29.609     0.200
     1.914    30.992     0.200
     2.052    31.992     0.200
     2.321    35.414     0.200
     2.347    36.914     0.200
     2.734    41.766     0.200
     0.212     6.534     0.200
     0.235     7.194     0.200
     0.270     7.514     0.200
     0.219     6.744     0.200
     0.310     8.014     0.200
     0.354     8.224     0.200
     0.354     8.244     0.200
     0.509    10.004     0.200
     0.459     9.685     0.200
     0.536    10.404     0.200
     0.597    11.504     0.200
     0.675    12.524     0.200
     0.695    12.824     0.200
     0.763    13.604     0.200
     0.736    13.244     0.200
     0.782    13.944     0.200
     0.782    13.944     0.200
     0.782    13.964     0.200
     0.836    14.774     0.200
     0.836    14.645     0.200
     0.836    14.704     0.200
     0.829    14.504     0.200
     0.799    14.014     0.200
     0.799    14.125     0.200
     0.840    14.814     0.200
     0.864    15.054     0.200
     0.935    16.174     0.200
     0.965    16.125     0.200
     1.000    16.935     0.200
     1.001    17.044     0.200
     1.001    16.984     0.200
     1.003    16.994     0.200
     0.952    16.194     0.200
     0.965    16.584     0.200
     1.050    17.594     0.200
     1.158    19.424     0.200
     1.158    19.464     0.200
     1.173    19.764     0.200
     1.127    18.834     0.200
     1.248    20.944     0.200
     1.275    21.375     0.200
     1.299    20.884     0.200
     1.371    22.784     0.200
     1.340    21.784     0.200
     1.365    21.674     0.200
     1.381    22.824     0.200
     1.463    24.094     0.200
     1.507    24.024     0.200
     1.525    24.594     0.200
     1.621    26.484     0.200
     1.641    26.625     0.200
     1.682    26.344     0.200
     1.696    26.444     0.200
     1.696    26.494     0.200
     1.839    29.274     0.200
     1.862    29.754     0.200
     1.860    29.645     0.200
     1.938    30.364     0.200
     1.955    31.334     0.200
     1.980    31.904     0.200
     1.999    31.734     0.200
     2.014    31.804     0.200
     2.040    31.794     0.200
     2.142    34.494     0.200
     2.257    35.044     0.200
     2.361    36.354     0.200
     2.327    35.724     0.200
     2.346    36.104     0.200
     2.359    37.034     0.200
     2.426    37.324     0.200
     2.441    37.544     0.200
     2.510    38.814     0.200
     2.525    39.054     0.200
     2.564    39.154     0.200
     2.631    40.574     0.200
     2.821    43.224     0.200
     2.922    43.924     0.200
     2.964    41.754     0.200
     3.008    45.594     0.200
     2.985    42.165     0.200
     3.065    46.375     0.200
     3.131    47.935     0.200
     3.201    49.034     0.200
     3.430    51.884     0.200
     3.573    53.864     0.200
     3.580    53.814     0.200
     5.054    73.654     0.200
     6.641    95.594     0.200
     6.991   100.435     0.200
     0.069     5.325     0.200
     0.259     6.945     0.200
     0.393     8.426     0.200
     0.523    10.476     0.200
     0.587    11.155     0.200
     0.593    11.275     0.200
     0.673    12.386     0.200
     0.724    13.235     0.200
     0.859    14.876     0.200
     0.860    14.815     0.200
     0.854    14.995     0.200
     0.947    16.216     0.200
     0.947    16.256     0.200
     0.906    16.155     0.200
     0.950    16.735     0.200
     0.962    16.485     0.200
     1.060    17.766     0.200
     1.256    21.086     0.200
     1.320    21.235     0.200
     1.419    22.405     0.200
     1.470    23.586     0.200
     1.470    23.376     0.200
     1.485    24.186     0.200
     1.409    23.216     0.200
     1.619    26.235     0.200
     1.772    27.716     0.200
     1.817    26.416     0.200
     1.951    29.705     0.200
     1.951    30.355     0.200
     2.021    31.796     0.200
     2.120    32.216     0.200
     2.194    33.565     0.200
     2.402    37.216     0.200
     2.318    33.695     0.200
     2.330    32.995     0.200
     2.469    37.516     0.200
     2.668    40.995     0.200
     2.681    41.046     0.200
     2.727    41.365     0.200
     2.727    41.626     0.200
     2.856    43.195     0.200
     2.907    44.376     0.200
     2.899    43.796     0.200
     3.039    46.336     0.200
     3.118    47.306     0.200
     3.163    47.766     0.200
     3.140    46.910     0.200
     3.140    47.046     0.200
     3.909    57.016     0.200
     4.054    60.626     0.200
     4.131    61.455     0.200
     4.188    60.315     0.200
     4.352    62.955     0.200
     4.817    71.336     0.200
     4.806    69.466     0.200
     4.872    72.075     0.200
     5.046    75.016     0.200
     5.090    74.605     0.200
     5.253    78.065     0.200
     5.332    78.386     0.200
     5.280    75.945     0.200
     5.373    78.966     0.200
     5.541    80.376     0.200
     5.541    80.235     0.200
     5.630    81.886     0.200
     6.121    88.255     0.200
     9.370   137.945     0.200
     9.428   138.905     0.200
     9.463   139.096     0.200
     9.441   137.461     0.200
     9.522   139.615     0.200
     9.499   135.745     0.200
     9.971   141.966     0.200
     9.971   143.766     0.200
    10.066   142.605     0.200
    10.216   149.336     0.200
    10.297   149.966     0.200
    10.745   157.235     0.200
    10.919   158.995     0.200
    10.927   159.535     0.200
    10.991   155.155     0.200
    11.002   159.166     0.200
    11.547   167.185     0.200
    12.253   177.035     0.200
    12.275   172.976     0.200
    12.260   176.636     0.200
    12.373   174.256     0.200
    12.839   181.476     0.200
    13.164   186.176     0.200
    13.291   189.035     0.200
    14.875   208.386     0.200
    15.034   211.726     0.200
    15.067   211.676     0.200
    15.131   213.596     0.200
    15.155   213.216     0.200
    15.159   213.296     0.200
    15.214   211.535     0.200
    15.215   215.416     0.200
    15.307   215.016     0.200
    15.280   214.865     0.200
    16.429   229.716     0.200
    16.547   231.025     0.200
    17.317   237.626     0.200
    17.453   241.485     0.200
    17.446   242.416     0.200
    17.446   242.525     0.200
    18.411   253.586     0.200
    18.890   259.396     0.200
    19.135   260.346     0.200
    19.009   262.735     0.200
    19.377   266.016     0.200
    19.426   265.535     0.200
    19.915   271.525     0.200
    19.934   271.086     0.200
    20.426   276.604     0.200
    20.426   276.936     0.200
    20.535   277.436     0.200
    20.535   278.535     0.200
    20.817   281.516     0.200
     0.492     9.564     0.200
     0.492     9.576     0.200
     0.490     9.506     0.200
     0.566    10.686     0.200
     0.566    10.506     0.200
     0.599    10.916     0.200
     0.599    10.975     0.200
     0.621    11.885     0.200
     0.674    11.996     0.200
     0.692    12.916     0.200
     0.715    12.775     0.200
     0.715    12.826     0.200
     0.784    14.086     0.200
     0.815    14.615     0.200
     0.796    13.529     0.200
     0.800    14.246     0.200
     0.901    14.967     0.200
     0.902    15.525     0.200
     0.894    15.047     0.200
     0.904    15.516     0.200
     0.894    15.555     0.200
     0.909    15.117     0.200
     0.909    15.150     0.200
     0.942    15.834     0.200
     1.037    17.635     0.200
     1.037    17.785     0.200
     1.039    17.656     0.200
     1.106    18.885     0.200
     1.117    19.686     0.200
     1.291    21.814     0.200
     1.313    22.545     0.200
     1.297    20.895     0.200
     1.398    23.775     0.200
     1.382    21.705     0.200
     1.460    24.076     0.200
     1.449    24.846     0.200
     1.526    25.225     0.200
     1.589    26.906     0.200
     1.778    27.275     0.200
     1.841    29.645     0.200
     2.037    31.236     0.200
     2.087    34.486     0.200
     2.196    33.086     0.200
     2.337    36.334     0.200
     2.521    39.367     0.200
     2.562    39.785     0.200
     2.755    42.375     0.200
     3.099    47.045     0.200
     3.121    47.285     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.536    47.047     0.200
     3.066    61.334     0.200
     3.448    66.984     0.200
     3.503    63.846     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.948    16.738     0.200
     0.717    13.121     0.200
     0.683    12.523     0.200
     0.888    15.332     0.200
     1.153    19.121     0.200
     1.166    19.844     0.200
     1.438    23.672     0.200
     1.652    26.871     0.200
     0.837    14.840     0.200
     0.861    15.150     0.200
     0.826    15.119     0.200
     0.925    16.230     0.200
     1.117    19.100     0.200
     1.188    20.680     0.200
     1.405    23.750     0.200
     1.409    23.650     0.200
     1.619    27.131     0.200
     0.791    14.461     0.200
     0.840    15.672     0.200
     0.939    16.242     0.200
     1.235    21.361     0.200
     1.253    21.361     0.200
     0.799    14.605     0.200
     0.858    15.934     0.200
     0.937    16.344     0.200
     1.648    27.754     0.200
     1.795    29.543     0.200
     0.449     8.512     0.200
     0.506    10.621     0.200
     0.863    14.711     0.200
     0.896    15.191     0.200
     0.966    16.770     0.200
     1.269    21.391     0.200
     1.313    22.211     0.200
     2.538    43.051     0.200
     2.612    43.871     0.200
     2.657    44.309     0.200
     2.794    48.711     0.200
     2.798    46.539     0.200
     3.688    64.090     0.200
     0.378     7.453     0.200
     0.467     9.383     0.200
     0.744    13.352     0.200
     0.784    13.781     0.200
     0.825    13.973     0.200
     1.213    20.352     0.200
     2.185    36.934     0.200
     2.560    43.582     0.200
     2.618    42.703     0.200
     2.744    46.324     0.200
     2.761    48.703     0.200
     3.618    62.730     0.200
     0.319     7.148     0.200
     0.408     8.555     0.200
     0.503     9.242     0.200
     0.732    13.023     0.200
     0.842    14.648     0.200
     0.850    14.664     0.200
     0.880    14.859     0.200
     1.076    18.461     0.200
     1.032    17.883     0.200
     1.111    19.211     0.200
     1.195    20.422     0.200
     2.880    50.055     0.200
     0.554    10.266     0.200
     0.906    15.773     0.200
     0.938    16.188     0.200
     0.879    15.109     0.200
     1.080    18.438     0.200
     1.121    18.914     0.200
     1.169    19.969     0.200
     1.249    21.250     0.200
     1.318    22.094     0.200
     1.319    22.055     0.200
     2.919    50.633     0.200
     0.392     8.477     0.200
     0.493     9.427     0.200
     0.736    13.446     0.200
     0.823    14.146     0.200
     0.863    15.137     0.200
     0.837    14.477     0.200
     1.023    17.477     0.200
     1.059    18.087     0.200
     0.403     8.645     0.200
     0.518     9.906     0.200
     0.845    14.484     0.200
     0.841    14.586     0.200
     0.889    15.574     0.200
     0.896    15.516     0.200
     1.047    18.055     0.200
     1.072    18.234     0.200
     1.209    20.766     0.200
     1.265    21.227     0.200
     1.266    21.477     0.200
     2.896    49.000     0.200
     0.456     8.028     0.200
     0.629    11.528     0.200
     0.778    13.118     0.200
     0.784    13.479     0.200
     0.806    13.668     0.200
     0.882    16.179     0.200
     0.993    17.078     0.200
     1.045    17.799     0.200
     1.046    17.698     0.200
     1.046    17.788     0.200
     1.046    17.799     0.200
     1.047    17.788     0.200
     1.048    17.799     0.200
     1.049    17.858     0.200
     1.060    17.688     0.200
     1.165    19.618     0.200
     1.362    24.719     0.200
     1.383    23.998     0.200
     1.441    24.628     0.200
     1.538    28.238     0.200
     1.501    25.378     0.200
     1.525    25.969     0.200
     1.576    26.588     0.200
     1.834    30.769     0.200
     2.013    33.019     0.200
     2.063    34.378     0.200
     2.207    38.538     0.200
     2.534    44.328     0.200
     2.641    44.198     0.200
     2.791    47.698     0.200
     3.007    49.668     0.200
     0.132     3.766     0.200
     0.152     3.926     0.200
     0.219     4.865     0.200
     0.388     7.414     0.200
     0.400     7.834     0.200
     0.537     9.805     0.200
     0.601    10.875     0.200
     0.687    12.645     0.200
     0.697    12.545     0.200
     0.821    14.525     0.200
     0.846    15.045     0.200
     0.897    15.645     0.200
     0.915    15.535     0.200
     0.924    16.295     0.200
     0.918    16.074     0.200
     0.973    16.895     0.200
     0.984    17.275     0.200
     0.999    17.035     0.200
     1.008    18.494     0.200
     1.244    21.484     0.200
     1.256    21.395     0.200
     1.260    21.205     0.200
     1.276    22.346     0.200
     1.380    23.615     0.200
     1.444    24.135     0.200
     1.448    24.676     0.200
     1.479    24.865     0.200
     1.480    24.945     0.200
     1.480    25.064     0.200
     1.480    24.895     0.200
     1.481    25.004     0.200
     1.481    24.824     0.200
     1.483    25.096     0.200
     1.484    25.035     0.200
     1.539    26.016     0.200
     1.628    27.865     0.200
     1.643    27.695     0.200
     1.667    28.125     0.200
     1.678    27.895     0.200
     1.679    28.164     0.200
     1.868    31.516     0.200
     2.021    33.984     0.200
     2.036    34.455     0.200
     2.045    34.096     0.200
     2.115    35.404     0.200
     2.215    36.475     0.200
     2.270    36.795     0.200
     2.300    37.574     0.200
     2.456    40.484     0.200
     2.587    42.154     0.200
     2.773    44.754     0.200
     2.776    45.135     0.200
     0.126     3.742     0.200
     0.145     3.871     0.200
     0.384     7.371     0.200
     0.408     7.801     0.200
     0.540     9.721     0.200
     0.601    10.822     0.200
     0.690    12.602     0.200
     0.705    12.432     0.200
     0.743    14.291     0.200
     0.829    14.402     0.200
     0.850    15.211     0.200
     0.896    15.611     0.200
     0.911    15.541     0.200
     0.927    16.252     0.200
     0.914    15.822     0.200
     0.981    16.852     0.200
     0.990    17.232     0.200
     0.999    17.012     0.200
     1.003    18.562     0.200
     1.248    21.432     0.200
     1.256    21.322     0.200
     1.258    21.111     0.200
     1.281    22.711     0.200
     1.373    23.051     0.200
     1.380    23.592     0.200
     1.441    24.242     0.200
     1.478    24.902     0.200
     1.479    24.912     0.200
     1.479    24.742     0.200
     1.478    24.961     0.200
     1.480    25.041     0.200
     1.480    25.162     0.200
     1.480    25.082     0.200
     1.481    25.102     0.200
     1.482    25.172     0.200
     1.483    25.041     0.200
     1.542    26.211     0.200
     1.628    27.881     0.200
     1.641    28.111     0.200
     1.671    28.262     0.200
     1.684    28.582     0.200
     1.686    28.461     0.200
     1.774    30.832     0.200
     1.786    30.092     0.200
     1.867    31.451     0.200
     2.027    33.291     0.200
     2.041    33.562     0.200
     2.042    34.732     0.200
     2.301    38.002     0.200
     2.456    40.092     0.200
     1.063    18.039     0.200
     1.329    23.047     0.200
     1.336    23.078     0.200
     1.368    23.227     0.200
     1.531    26.156     0.200
     1.579    26.539     0.200
     1.605    27.539     0.200
     1.726    29.211     0.200
     1.836    30.375     0.200
     1.958    32.188     0.200
     0.471     9.055     0.200
     0.656    11.896     0.200
     0.637    11.615     0.200
     0.698    12.955     0.200
     0.930    16.155     0.200
     0.194     4.109     0.200
     0.387     7.789     0.200
     0.467     8.656     0.200
     0.485     9.047     0.200
     0.530    11.148     0.200
     0.641    12.328     0.200
     0.921    15.797     0.200
     1.154    20.797     0.200
     3.604    60.348     0.200
     0.286     6.484     0.200
     0.520    10.266     0.200
     0.650    11.945     0.200
     0.687    12.539     0.200
     0.979    16.836     0.200
     0.275     6.641     0.200
     0.275     6.664     0.200
     0.456     9.711     0.200
     0.456     9.844     0.200
     0.434     8.750     0.200
     0.513     9.711     0.200
     0.704    12.383     0.200
     0.704    12.500     0.200
     0.672    12.422     0.200
     0.672    12.172     0.200
     0.704    12.414     0.200
     0.745    13.250     0.200
     0.746    12.992     0.200
     0.746    13.391     0.200
     0.740    13.422     0.200
     0.857    15.102     0.200
     4.083    67.703     0.200
     0.113     4.969     0.200
     0.112     5.029     0.200
     0.183     5.629     0.200
     0.183     5.469     0.200
     0.214     5.828     0.200
     0.350     7.510     0.200
     0.393     7.859     0.200
     0.393     7.889     0.200
     0.659    11.879     0.200
     0.726    12.930     0.200
     0.727    12.988     0.200
     0.801    14.049     0.200
     0.861    15.029     0.200
     0.921    15.840     0.200
     1.003    16.959     0.200
     1.011    17.100     0.200
     1.106    18.709     0.200
     1.104    18.908     0.200
     1.126    19.398     0.200
     1.202    20.439     0.200
     1.202    20.299     0.200
     1.203    20.408     0.200
     1.204    20.449     0.200
     1.293    21.469     0.200
     1.354    22.289     0.200
     1.358    22.969     0.200
     1.502    24.668     0.200
     1.903    33.090     0.200
     1.902    33.100     0.200
     2.832    48.799     0.200
     0.333     6.637     0.200
     0.448     8.938     0.200
     0.409     7.957     0.200
     0.538    10.117     0.200
     0.671    12.359     0.200
     0.788    13.789     0.200
     0.841    14.699     0.200
     0.906    15.598     0.200
     0.936    16.270     0.200
     1.076    18.199     0.200
     1.103    19.008     0.200
     0.303     6.846     0.200
     0.274     6.266     0.200
     0.304     6.695     0.200
     0.304     6.896     0.200
     0.290     6.955     0.200
     0.386     8.305     0.200
     0.536     9.617     0.200
     0.638    11.535     0.200
     0.674    12.049     0.200
     0.902    15.658     0.200
     0.901    15.697     0.200
     1.034    18.555     0.200
     1.088    18.896     0.200
     1.168    20.104     0.200
     1.201    21.221     0.200
     1.218    21.174     0.200
     1.250    21.332     0.200
     1.217    21.172     0.200
     1.412    23.721     0.200
     1.420    23.447     0.200
     1.460    24.279     0.200
     1.477    24.912     0.200
     1.622    27.342     0.200
     1.699    29.350     0.200
     1.766    29.045     0.200
     1.841    30.750     0.200
     1.871    31.285     0.200
     1.949    33.072     0.200
     1.961    33.262     0.200
     1.966    32.910     0.200
     2.356    38.998     0.200
     2.499    42.258     0.200
     2.708    44.195     0.200
     2.755    46.209     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     2.101    57.488     0.200
     4.792   121.609     0.200
     2.372    65.184     0.200
     4.212   108.910     0.200
     0.861    26.619     0.200
     0.302    13.117     0.200
     0.279    13.758     0.200
     0.409    15.992     0.200
     0.681    21.891     0.200
     0.744    23.859     0.200
     0.726    23.422     0.200
     0.740    23.648     0.200
     0.888    27.188     0.200
     0.918    28.500     0.200
     1.072    31.680     0.200
     1.133    34.438     0.200
     1.129    33.766     0.200
     1.427    41.352     0.200
     1.856    50.961     0.200
     2.150    57.609     0.200
     2.342    63.461     0.200
     3.068    80.172     0.200
     5.498   138.281     0.200
     6.149   154.492     0.200
     7.004   178.789     0.200
     0.238    10.879     0.200
     0.344    13.000     0.200
     0.613    19.160     0.200
     0.632    20.078     0.200
     0.758    22.781     0.200
     0.883    26.270     0.200
     0.877    26.461     0.200
     0.947    28.879     0.200
     0.994    29.301     0.200
     1.061    30.910     0.200
     1.067    31.141     0.200
     1.108    31.578     0.200
     1.220    35.879     0.200
     1.365    40.719     0.200
     1.393    40.801     0.200
     1.431    41.801     0.200
     1.427    41.711     0.200
     1.442    43.129     0.200
     1.571    45.930     0.200
     1.889    52.988     0.200
     4.124   107.109     0.200
     0.238    10.922     0.200
     0.451    15.727     0.200
     0.682    20.320     0.200
     0.744    22.766     0.200
     0.732    22.711     0.200
     1.015    30.516     0.200
     1.036    29.570     0.200
     1.105    32.586     0.200
     1.393    38.906     0.200
     1.770    48.766     0.200
     1.775    47.289     0.200
     0.791    25.201     0.200
     0.939    28.961     0.200
     1.235    37.730     0.200
     1.253    38.031     0.200
     1.439    40.002     0.200
     2.053    57.092     0.200
     2.246    61.191     0.200
     2.498    68.941     0.200
     2.590    71.762     0.200
     2.692    72.412     0.200
     2.832    76.221     0.200
     2.923    79.541     0.200
     2.976    78.291     0.200
     3.296    88.191     0.200
     3.420    91.672     0.200
     3.746    97.781     0.200
     4.069   110.342     0.200
     4.177   111.561     0.200
     4.635   117.752     0.200
     4.725   120.592     0.200
     5.018   127.832     0.200
     5.337   136.191     0.200
     5.723   145.631     0.200
     9.330   239.916     0.200
     0.937    28.906     0.200
     1.245    36.766     0.200
     1.256    37.863     0.200
     1.297    37.453     0.200
     1.434    40.273     0.200
     2.972    79.645     0.200
     2.972    79.465     0.200
     4.195   109.605     0.200
     4.177   108.816     0.200
     5.329   136.473     0.200
     9.324   239.570     0.200
     1.165    34.809     0.200
     4.210   109.789     0.200
     4.560   116.852     0.200
     0.784    23.801     0.200
     0.825    24.773     0.200
     0.902    27.883     0.200
     4.198   108.172     0.200
     4.529   114.980     0.200
     4.705   120.133     0.200
     5.017   128.023     0.200
     0.825    24.109     0.200
     1.229    34.770     0.200
     1.474    41.117     0.200
     1.582    43.199     0.200
     1.608    45.000     0.200
     1.758    48.977     0.200
     1.994    54.738     0.200
     2.129    58.199     0.200
     2.341    61.848     0.200
     2.387    64.438     0.200
     2.892    77.270     0.200
     3.141    84.949     0.200
     3.854    99.574     0.200
     3.854   100.000     0.200
     4.042   107.098     0.200
     5.478   141.570     0.200
     5.849   151.617     0.200
     0.502    17.031     0.200
     0.617    20.609     0.200
     0.752    22.750     0.200
     1.283    36.000     0.200
     2.788    73.250     0.200
     2.788    72.781     0.200
     0.108    12.297     0.200
     0.370    15.422     0.200
     0.412    16.258     0.200
     0.445    16.656     0.200
     0.451    16.898     0.200
     0.538    19.680     0.200
     0.577    19.430     0.200
     0.558    20.102     0.200
     0.621    20.422     0.200
     0.665    21.898     0.200
     0.737    23.828     0.200
     0.797    25.031     0.200
     0.968    29.656     0.200
     1.028    30.969     0.200
     1.041    30.500     0.200
     1.052    31.242     0.200
     1.105    33.320     0.200
     1.197    34.922     0.200
     1.849    49.961     0.200
     2.147    57.188     0.200
     0.240    12.367     0.200
     0.286    12.876     0.200
     0.320    14.146     0.200
     0.343    14.176     0.200
     0.342    14.196     0.200
     0.364    14.227     0.200
     0.380    14.926     0.200
     0.454    16.296     0.200
     0.568    19.606     0.200
     0.729    23.296     0.200
     0.754    23.626     0.200
     0.749    24.106     0.200
     0.761    24.287     0.200
     0.784    24.676     0.200
     0.842    25.256     0.200
     0.865    26.176     0.200
     0.860    26.977     0.200
     0.882    27.347     0.200
     0.994    28.867     0.200
     1.041    31.646     0.200
     1.098    32.167     0.200
     1.218    35.506     0.200
     1.317    38.167     0.200
     1.346    37.597     0.200
     1.388    39.506     0.200
     1.477    42.006     0.200
     2.049    55.316     0.200
     2.331    61.256     0.200
     0.357    14.036     0.200
     0.329    14.356     0.200
     0.458    16.917     0.200
     0.525    18.736     0.200
     0.645    20.677     0.200
     0.659    20.927     0.200
     0.681    22.307     0.200
     0.748    23.866     0.200
     0.803    25.146     0.200
     0.813    25.286     0.200
     0.842    25.856     0.200
     0.886    26.126     0.200
     0.888    26.136     0.200
     0.902    28.136     0.200
     0.995    30.006     0.200
     1.007    29.577     0.200
     1.051    32.236     0.200
     1.183    34.486     0.200
     1.308    36.266     0.200
     1.359    38.587     0.200
     1.417    40.256     0.200
     1.402    39.597     0.200
     1.508    41.927     0.200
     1.627    45.317     0.200
     1.700    46.547     0.200
     1.773    47.977     0.200
     1.738    48.886     0.200
     1.776    48.626     0.200
     1.894    50.266     0.200
     1.895    50.547     0.200
     1.894    50.646     0.200
     1.894    52.447     0.200
     1.896    50.817     0.200
     2.086    54.866     0.200
     2.253    62.396     0.200
     2.316    62.988     0.200
     2.554    64.156     0.200
     2.790    75.217     0.200
     2.801    74.597     0.200
     2.873    75.871     0.200
     3.004    79.396     0.200
     3.006    79.347     0.200
     3.146    83.547     0.200
     3.152    82.697     0.200
     3.388    86.136     0.200
     3.513    91.817     0.200
     3.550    92.547     0.200
     3.606    94.396     0.200
     3.883    99.746     0.200
     3.943   100.587     0.200
     3.943   101.986     0.200
     4.556   116.866     0.200
     0.842    25.688     0.200
     0.878    26.859     0.200
     1.348    37.703     0.200
     2.880    76.211     0.200
     4.324   109.914     0.200
     4.835   122.820     0.200
     5.082   128.672     0.200
     5.145   130.328     0.200
     5.145   130.422     0.200
     5.829   146.891     0.200
    14.872   367.734     0.200
    17.304   433.820     0.200
    17.640   441.086     0.200
     2.919    76.789     0.200
     5.094   128.719     0.200
     5.157   130.617     0.200
     0.493    16.127     0.200
     0.736    23.896     0.200
     1.415    38.877     0.200
     1.531    42.827     0.200
     1.671    44.507     0.200
     2.324    62.797     0.200
     2.534    67.657     0.200
     2.875    74.727     0.200
     2.875    76.097     0.200
     3.716    95.937     0.200
     5.085   128.967     0.200
     5.148   130.767     0.200
     0.518    16.867     0.200
     1.432    39.598     0.200
     1.654    45.125     0.200
     2.077    57.457     0.200
     2.152    58.605     0.200
     2.896    75.199     0.200
     1.045    31.698     0.200
     1.046    31.769     0.200
     1.046    31.858     0.200
     1.046    31.679     0.200
     1.047    31.979     0.200
     1.048    31.778     0.200
     1.049    32.059     0.200
     1.050    31.698     0.200
     1.050    31.889     0.200
     1.060    31.679     0.200
     1.165    36.568     0.200
     1.163    35.078     0.200
     1.266    38.729     0.200
     1.311    38.578     0.200
     1.726    48.648     0.200
     2.557    70.208     0.200
     3.711    98.588     0.200
     0.846    25.914     0.200
     0.924    27.975     0.200
     0.973    29.385     0.200
     0.999    29.484     0.200
     1.946    51.475     0.200
     0.927    28.002     0.200
     0.981    29.393     0.200
     0.990    30.121     0.200
     0.999    29.512     0.200
     2.759    74.531     0.200
     0.752    24.078     0.200
     0.867    28.352     0.200
     0.893    28.258     0.200
     1.063    32.055     0.200
     1.237    37.734     0.200
     1.355    38.961     0.200
     1.563    42.930     0.200
     1.768    49.609     0.200
     2.271    62.836     0.200
     2.331    64.875     0.200
     2.426    67.141     0.200
     2.608    71.938     0.200
     2.663    71.945     0.200
     2.898    78.711     0.200
     2.898    78.867     0.200
     3.100    81.727     0.200
     3.100    81.570     0.200
     0.471    15.146     0.200
     0.637    19.955     0.200
     1.182    33.065     0.200
     1.156    32.845     0.200
     1.465    40.545     0.200
     1.480    41.085     0.200
     1.838    50.725     0.200
     2.275    60.635     0.200
     2.419    66.375     0.200
     2.696    70.540     0.200
     2.853    75.905     0.200
     2.853    76.045     0.200
     3.017    80.025     0.200
     3.915    99.025     0.200
     4.038   102.725     0.200
     4.417   112.075     0.200
     4.459   113.025     0.200
     4.557   115.305     0.200
     4.799   120.985     0.200
     4.799   120.416     0.200
     4.862   123.100     0.200
     4.862   122.555     0.200
     5.094   129.655     0.200
     0.122    10.916     0.200
     0.271    13.156     0.200
     0.286    13.136     0.200
     0.316    14.496     0.200
     0.523    18.076     0.200
     0.602    19.916     0.200
     0.812    25.226     0.200
     0.883    28.036     0.200
     0.984    29.986     0.200
     1.047    30.866     0.200
     1.112    32.766     0.200
     1.141    33.726     0.200
     1.279    37.666     0.200
     1.542    43.086     0.200
     1.571    42.796     0.200
     1.593    44.256     0.200
     1.593    44.276     0.200
     1.595    44.256     0.200
     1.595    44.546     0.200
     1.595    44.436     0.200
     1.765    47.976     0.200
     1.881    51.536     0.200
     2.044    57.190     0.200
     2.053    57.756     0.200
     2.132    57.236     0.200
     2.411    66.631     0.200
     2.448    64.786     0.200
     2.558    65.616     0.200
     2.574    69.345     0.200
     3.014    77.426     0.200
     3.381    87.636     0.200
     3.367    86.071     0.200
     3.585    92.846     0.200
     3.585    93.296     0.200
     3.605    94.061     0.200
     3.891   102.086     0.200
     4.313   110.403     0.200
     4.386   114.534     0.200
     4.665   117.796     0.200
     5.300   133.796     0.200
     5.581   139.416     0.200
     5.856   148.681     0.200
     5.847   145.236     0.200
     6.150   156.146     0.200
     6.646   169.042     0.200
     0.641    21.496     0.200
     0.666    23.180     0.200
     0.779    26.398     0.200
     0.842    27.898     0.200
     0.921    28.656     0.200
     1.115    34.039     0.200
     1.115    34.168     0.200
     1.114    34.117     0.200
     1.114    34.219     0.200
     2.205    60.547     0.200
     0.218    11.666     0.200
     0.337    14.076     0.200
     0.345    14.086     0.200
     0.420    15.596     0.200
     0.526    18.205     0.200
     0.535    17.766     0.200
     0.781    23.775     0.200
     0.782    23.396     0.200
     0.798    24.436     0.200
     0.792    24.896     0.200
     0.878    27.375     0.200
     0.885    26.477     0.200
     0.938    27.557     0.200
     1.043    31.605     0.200
     1.079    31.816     0.200
     1.162    34.396     0.200
     1.303    36.965     0.200
     1.331    38.396     0.200
     1.349    39.316     0.200
     1.413    40.506     0.200
     1.629    44.945     0.200
     1.693    46.855     0.200
     1.830    49.436     0.200
     1.830    49.445     0.200
     1.830    49.477     0.200
     1.830    49.455     0.200
     1.831    49.775     0.200
     1.831    49.615     0.200
     1.832    49.486     0.200
     1.874    50.795     0.200
     1.958    53.426     0.200
     2.011    54.125     0.200
     3.000    79.266     0.200
     3.126    81.576     0.200
     3.737    97.057     0.200
     3.843    98.535     0.200
     0.204    11.945     0.200
     0.252    12.461     0.200
     0.281    12.891     0.200
     0.281    13.000     0.200
     0.322    13.461     0.200
     0.392    15.039     0.200
     0.404    15.984     0.200
     0.424    15.875     0.200
     0.642    21.406     0.200
     0.707    22.336     0.200
     0.761    23.648     0.200
     0.800    24.961     0.200
     0.800    25.148     0.200
     0.807    25.711     0.200
     0.831    25.984     0.200
     0.850    26.648     0.200
     0.844    26.352     0.200
     0.935    29.070     0.200
     1.038    31.297     0.200
     1.129    33.375     0.200
     1.282    38.102     0.200
     1.321    38.680     0.200
     1.434    39.602     0.200
     1.459    40.516     0.200
     1.778    50.000     0.200
     2.538    68.938     0.200
     0.488    16.141     0.200
     0.488    16.758     0.200
     0.520    17.102     0.200
     0.650    20.461     0.200
     0.687    21.359     0.200
     0.687    21.516     0.200
     1.090    30.469     0.200
     1.183    33.734     0.200
     1.408    39.117     0.200
     1.535    42.180     0.200
     1.580    43.969     0.200
     1.580    44.047     0.200
     1.701    46.305     0.200
     1.828    49.891     0.200
     1.887    52.359     0.200
     2.068    54.828     0.200
     2.043    55.617     0.200
     2.043    55.781     0.200
     2.043    55.938     0.200
     2.045    55.836     0.200
     2.167    57.805     0.200
     2.183    59.648     0.200
     2.632    71.289     0.200
     2.670    73.047     0.200
     2.918    77.969     0.200
     2.929    79.531     0.200
     2.929    78.750     0.200
     3.483    90.281     0.200
     3.484    92.820     0.200
     4.238   111.008     0.200
     4.550   115.430     0.200
     4.961   126.125     0.200
     5.440   138.289     0.200
     0.035     9.316     0.200
     0.035     9.477     0.200
     0.066     9.215     0.200
     0.302    12.895     0.200
     0.299    12.547     0.200
     0.300    12.477     0.200
     0.521    17.137     0.200
     0.710    23.258     0.200
     0.829    25.195     0.200
     0.859    25.895     0.200
     0.859    25.555     0.200
     0.934    27.945     0.200
     0.934    27.828     0.200
     1.003    29.266     0.200
     1.036    31.047     0.200
     1.036    30.828     0.200
     1.049    30.887     0.200
     1.219    34.375     0.200
     1.238    36.156     0.200
     1.326    37.328     0.200
     1.411    39.605     0.200
     1.410    39.695     0.200
     1.411    39.598     0.200
     1.413    39.668     0.200
     1.413    39.887     0.200
     1.566    42.527     0.200
     1.931    48.258     0.200
     3.600    92.656     0.200
     5.617   145.574     0.200
     0.299    13.613     0.200
     0.340    14.232     0.200
     0.463    16.582     0.200
     0.463    16.752     0.200
     0.462    16.723     0.200
     0.659    22.033     0.200
     0.655    21.953     0.200
     0.779    25.184     0.200
     0.966    29.854     0.200
     0.966    29.453     0.200
     0.943    28.014     0.200
     0.941    29.232     0.200
     1.107    32.562     0.200
     1.067    31.463     0.200
     1.173    34.492     0.200
     1.220    36.104     0.200
     1.266    35.623     0.200
     1.434    39.332     0.200
     1.786    48.672     0.200
     1.844    51.803     0.200
     1.867    51.193     0.200
     1.947    52.693     0.200
     2.233    58.854     0.200
     2.409    63.922     0.200
     2.622    69.482     0.200
     2.745    69.002     0.200
     2.986    76.322     0.200
     3.395    87.422     0.200
     3.488    89.873     0.200
     4.266   109.492     0.200
     0.260    12.020     0.200
     0.401    14.238     0.200
     0.449    15.621     0.200
     0.500    16.379     0.200
     0.566    17.449     0.200
     0.595    18.750     0.200
     0.596    18.949     0.200
     0.961    27.852     0.200
     1.036    29.691     0.200
     1.056    30.121     0.200
     1.124    32.430     0.200
     1.255    35.691     0.200
     1.245    35.270     0.200
     1.245    35.250     0.200
     1.481    37.469     0.200
     1.436    40.672     0.200
     1.441    40.480     0.200
     1.461    40.309     0.200
     1.550    43.148     0.200
     1.668    46.461     0.200
     1.792    48.199     0.200
     1.922    52.891     0.200
     2.253    60.262     0.200
     2.341    63.320     0.200
     2.422    64.090     0.200
     2.390    63.379     0.200
     2.489    67.949     0.200
     2.679    70.199     0.200
     3.039    80.371     0.200
     3.070    81.309     0.200
     3.098    83.051     0.200
     3.781    97.871     0.200
     3.843   100.949     0.200
     4.252   111.840     0.200
     4.679   118.898     0.200
     5.089   128.789     0.200
     0.076    10.012     0.200
     0.244    11.332     0.200
     0.244    11.152     0.200
     0.254    11.473     0.200
     0.559    18.473     0.200
     0.559    18.215     0.200
     0.560    18.574     0.200
     0.560    18.254     0.200
     0.575    19.074     0.200
     0.575    18.902     0.200
     0.576    19.191     0.200
     0.576    18.965     0.200
     0.609    19.633     0.200
     0.702    22.441     0.200
     0.702    22.055     0.200
     0.806    24.422     0.200
     0.806    24.121     0.200
     0.856    25.742     0.200
     0.856    25.305     0.200
     0.838    26.281     0.200
     0.856    25.512     0.200
     0.857    25.492     0.200
     0.857    25.383     0.200
     0.860    25.754     0.200
     0.897    26.434     0.200
     0.897    26.324     0.200
     0.963    28.914     0.200
     0.970    29.371     0.200
     1.074    31.824     0.200
     1.259    36.652     0.200
     1.336    39.043     0.200
     1.373    39.152     0.200
     1.391    39.574     0.200
     1.662    46.242     0.200
     1.737    46.691     0.200
     1.972    52.434     0.200
     2.103    57.555     0.200
     2.374    63.934     0.200
     2.914    78.242     0.200
     1.154    32.805     0.200
     1.247    34.875     0.200
     4.083   104.680     0.200
     7.049   182.180     0.200
     0.505    16.479     0.200
     0.654    21.027     0.200
     0.679    21.930     0.200
     0.788    23.918     0.200
     0.841    25.270     0.200
     0.906    26.719     0.200
     0.166    10.133     0.200
     0.210    10.547     0.200
     0.320    13.070     0.200
     0.344    13.273     0.200
     0.355    14.242     0.200
     0.414    15.023     0.200
     0.414    15.172     0.200
     0.493    16.977     0.200
     0.772    23.930     0.200
     0.801    25.070     0.200
     0.866    27.156     0.200
     0.903    27.195     0.200
     0.912    28.430     0.200
     0.949    28.883     0.200
     1.120    33.875     0.200
     1.281    37.742     0.200
     1.349    39.820     0.200
     1.385    40.680     0.200
     1.544    43.844     0.200
     0.212    11.234     0.200
     0.235    12.424     0.200
     0.219    11.734     0.200
     0.219    11.964     0.200
     0.270    13.134     0.200
     0.219    11.794     0.200
     0.310    13.954     0.200
     0.332    14.734     0.200
     0.354    14.094     0.200
     0.354    14.174     0.200
     0.509    17.294     0.200
     0.509    17.424     0.200
     0.459    17.114     0.200
     0.597    19.734     0.200
     0.675    21.964     0.200
     0.763    23.494     0.200
     0.763    23.334     0.200
     0.782    24.114     0.200
     0.836    25.424     0.200
     0.836    25.064     0.200
     0.836    25.464     0.200
     0.829    25.165     0.200
     0.829    24.884     0.200
     0.864    25.724     0.200
     0.935    28.014     0.200
     0.965    27.864     0.200
     1.000    28.954     0.200
     1.001    29.614     0.200
     1.001    28.984     0.200
     1.001    29.454     0.200
     1.003    28.994     0.200
     1.050    30.145     0.200
     1.050    30.384     0.200
     1.070    31.014     0.200
     1.158    33.294     0.200
     1.158    33.474     0.200
     1.173    33.774     0.200
     1.127    32.954     0.200
     1.127    32.824     0.200
     1.248    35.895     0.200
     1.275    36.334     0.200
     1.340    37.395     0.200
     1.365    36.944     0.200
     1.575    43.264     0.200
     1.621    45.254     0.200
     1.641    45.584     0.200
     1.696    45.614     0.200
     1.862    51.834     0.200
     1.860    51.304     0.200
     1.938    52.534     0.200
     1.955    53.154     0.200
     1.999    54.884     0.200
     2.022    54.574     0.200
     2.361    64.094     0.200
     2.346    62.344     0.200
     2.441    65.125     0.200
     2.510    66.685     0.200
     2.525    67.174     0.200
     2.564    67.354     0.200
     2.922    75.564     0.200
     2.964    74.714     0.200
     3.008    77.935     0.200
     3.201    83.074     0.200
     3.430    88.294     0.200
     0.069     9.226     0.200
     0.259    11.716     0.200
     0.393    14.586     0.200
     0.523    18.155     0.200
     0.587    18.855     0.200
     0.593    19.245     0.200
     0.593    19.025     0.200
     0.673    21.516     0.200
     0.859    25.785     0.200
     0.860    25.846     0.200
     0.906    27.785     0.200
     0.950    29.386     0.200
     3.111    80.626     0.200
     3.140    81.535     0.200
     5.541   138.266     0.200
     5.541   137.976     0.200
     7.946   202.953     0.200
     0.492    16.590     0.200
     0.492    16.701     0.200
     0.492    16.875     0.200
     0.492    16.641     0.200
     0.490    17.865     0.200
     0.536    17.266     0.200
     0.566    18.779     0.200
     0.566    18.885     0.200
     0.599    19.436     0.200
     0.599    19.529     0.200
     2.356    63.074     0.200
     2.708    71.877     0.200
     2.959    78.086     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.980    29.109     0.200
     1.387    40.230     0.200
     1.438    41.691     0.200
     1.406    40.121     0.200
     1.652    47.543     0.200
     2.930    85.320     0.200
     0.837    25.070     0.200
     0.925    27.650     0.200
     1.117    33.730     0.200
     1.364    41.381     0.200
     1.558    47.650     0.200
     2.182    66.189     0.200
     2.267    67.449     0.200
     1.282    37.301     0.200
     1.508    43.461     0.200
     1.510    44.162     0.200
     1.538    43.912     0.200
     1.780    51.512     0.200
     3.027    83.842     0.200
     1.508    43.363     0.200
     1.528    44.914     0.200
     1.648    47.625     0.200
     0.449    13.891     0.200
     0.506    17.512     0.200
     0.863    24.781     0.200
     0.896    26.078     0.200
     0.966    28.949     0.200
     1.269    37.059     0.200
     1.313    39.449     0.200
     1.392    40.191     0.200
     1.628    47.969     0.200
     1.770    49.918     0.200
     1.886    55.512     0.200
     2.181    63.711     0.200
     2.242    64.809     0.200
     2.612    76.641     0.200
     2.676    80.199     0.200
     2.794    81.410     0.200
     2.924    84.789     0.200
     3.095    88.488     0.200
     3.688   107.160     0.200
     0.378    12.652     0.200
     0.467    16.230     0.200
     1.113    32.953     0.200
     1.177    34.023     0.200
     1.213    35.352     0.200
     1.318    38.523     0.200
     1.583    46.781     0.200
     1.735    50.391     0.200
     1.826    54.102     0.200
     2.135    63.891     0.200
     2.185    64.422     0.200
     2.560    75.332     0.200
     2.625    78.773     0.200
     2.618    77.074     0.200
     2.744    80.402     0.200
     2.744    81.102     0.200
     3.045    90.324     0.200
     3.790   108.602     0.200
     0.319    12.449     0.200
     0.319    12.320     0.200
     0.731    22.359     0.200
     0.811    24.520     0.200
     0.824    24.637     0.200
     1.142    32.930     0.200
     1.246    36.098     0.200
     1.384    39.918     0.200
     1.459    41.418     0.200
     1.506    44.070     0.200
     1.662    47.520     0.200
     1.726    48.988     0.200
     1.898    53.270     0.200
     0.994    30.258     0.200
     1.005    30.230     0.200
     1.279    36.699     0.200
     1.278    37.371     0.200
     1.341    39.559     0.200
     1.499    43.590     0.200
     0.408    14.555     0.200
     1.111    33.031     0.200
     1.195    34.930     0.200
     1.266    37.805     0.200
     1.257    37.398     0.200
     1.342    39.734     0.200
     1.529    45.078     0.200
     1.806    52.688     0.200
     2.880    83.383     0.200
     2.880    82.852     0.200
     0.451    15.836     0.200
     0.554    17.266     0.200
     0.900    26.164     0.200
     1.175    35.164     0.200
     2.919    83.273     0.200
     0.392    14.507     0.200
     0.823    24.627     0.200
     0.863    26.757     0.200
     0.837    26.037     0.200
     1.023    30.667     0.200
     1.059    31.547     0.200
     1.092    32.467     0.200
     1.143    33.877     0.200
     1.183    35.127     0.200
     1.247    36.917     0.200
     1.341    38.517     0.200
     1.323    38.097     0.200
     0.403    15.004     0.200
     0.845    25.195     0.200
     0.889    27.117     0.200
     1.047    31.766     0.200
     1.072    31.867     0.200
     1.114    33.176     0.200
     1.209    35.348     0.200
     1.265    36.867     0.200
     1.266    37.715     0.200
     1.363    38.977     0.200
     1.803    50.605     0.200
     2.896    84.176     0.200
     0.456    14.828     0.200
     0.629    20.078     0.200
     0.784    24.588     0.200
     0.792    24.679     0.200
     0.993    30.248     0.200
     1.046    31.108     0.200
     1.165    33.498     0.200
     1.441    43.648     0.200
     1.501    44.519     0.200
     1.525    45.559     0.200
     1.576    47.418     0.200
     1.834    54.969     0.200
     2.013    60.788     0.200
     2.287    65.009     0.200
     3.007    84.918     0.200
     0.132     5.936     0.200
     0.152     6.266     0.200
     0.219     7.904     0.200
     0.388    11.834     0.200
     0.400    13.004     0.200
     0.537    16.615     0.200
     0.601    18.664     0.200
     0.697    21.314     0.200
     0.750    22.926     0.200
     0.821    24.455     0.200
     0.897    26.355     0.200
     0.915    27.045     0.200
     1.244    37.266     0.200
     1.256    37.215     0.200
     1.260    37.516     0.200
     1.444    43.055     0.200
     1.479    43.516     0.200
     1.480    43.404     0.200
     1.480    43.664     0.200
     1.480    43.324     0.200
     1.480    43.824     0.200
     1.481    44.055     0.200
     1.481    43.715     0.200
     1.481    43.635     0.200
     1.482    43.766     0.200
     1.483    44.074     0.200
     1.484    43.814     0.200
     1.539    45.404     0.200
     1.628    48.074     0.200
     1.643    48.205     0.200
     1.667    48.084     0.200
     1.678    48.785     0.200
     1.679    48.545     0.200
     2.021    57.975     0.200
     2.036    58.004     0.200
     0.126     6.191     0.200
     0.145     6.332     0.200
     0.222     7.832     0.200
     0.384    12.631     0.200
     0.408    13.121     0.200
     0.540    16.881     0.200
     0.601    18.611     0.200
     0.705    21.271     0.200
     0.743    22.781     0.200
     0.829    24.893     0.200
     0.850    25.682     0.200
     0.896    26.393     0.200
     0.911    26.822     0.200
     1.248    37.422     0.200
     1.256    36.881     0.200
     1.258    37.232     0.200
     1.441    42.092     0.200
     1.478    43.521     0.200
     1.479    43.482     0.200
     1.479    43.162     0.200
     1.478    43.643     0.200
     1.480    43.551     0.200
     1.480    43.502     0.200
     1.480    43.361     0.200
     1.481    43.752     0.200
     1.482    43.631     0.200
     1.483    43.812     0.200
     1.542    45.711     0.200
     1.628    48.102     0.200
     1.641    48.021     0.200
     1.686    48.711     0.200
     2.041    59.492     0.200
     1.329    39.320     0.200
     1.336    40.148     0.200
     1.259    35.898     0.200
     1.489    42.680     0.200
     1.531    44.680     0.200
     1.517    43.766     0.200
     1.579    45.188     0.200
     1.605    46.461     0.200
     1.630    46.672     0.200
     1.767    50.055     0.200
     1.836    53.570     0.200
     2.498    70.328     0.200
     0.925    27.025     0.200
     0.930    28.375     0.200
     1.348    39.225     0.200
     1.532    43.765     0.200
     0.194     8.656     0.200
     0.467    16.430     0.200
     1.204    36.496     0.200
     1.205    36.387     0.200
     1.205    36.547     0.200
     1.205    36.449     0.200
     1.206    36.617     0.200
     1.209    36.816     0.200
     1.232    37.020     0.200
     1.291    38.020     0.200
     1.317    38.246     0.200
     1.310    38.367     0.200
     1.310    38.477     0.200
     1.415    41.430     0.200
     1.454    43.336     0.200
     1.530    44.848     0.200
     1.567    45.996     0.200
     1.875    53.219     0.200
     1.906    54.457     0.200
     1.936    55.246     0.200
     2.126    59.816     0.200
     0.286    12.180     0.200
     0.916    27.328     0.200
     0.917    27.461     0.200
     0.917    27.328     0.200
     1.183    33.906     0.200
     1.182    34.945     0.200
     1.182    35.109     0.200
     1.305    37.625     0.200
     1.604    44.984     0.200
     1.569    44.148     0.200
     1.604    45.641     0.200
     1.708    48.625     0.200
     0.275    11.586     0.200
     0.275    11.422     0.200
     0.275    11.594     0.200
     0.275    11.477     0.200
     0.434    14.992     0.200
     0.434    14.789     0.200
     0.513    16.805     0.200
     0.704    21.945     0.200
     0.704    21.375     0.200
     0.672    21.875     0.200
     0.704    21.391     0.200
     0.746    22.852     0.200
     0.746    22.492     0.200
     0.740    24.031     0.200
     1.034    29.875     0.200
     1.109    32.422     0.200
     1.155    33.281     0.200
     1.230    36.086     0.200
     1.240    36.094     0.200
     1.349    39.180     0.200
     1.478    41.984     0.200
     0.113     8.889     0.200
     0.112     8.889     0.200
     0.112     9.020     0.200
     0.183     9.809     0.200
     0.214    10.119     0.200
     0.350    13.270     0.200
     0.350    13.379     0.200
     0.393    13.809     0.200
     0.393    13.818     0.200
     0.659    20.648     0.200
     0.726    22.809     0.200
     0.727    22.770     0.200
     0.861    25.969     0.200
     0.921    27.619     0.200
     1.003    29.568     0.200
     1.011    30.629     0.200
     1.106    33.039     0.200
     1.130    33.658     0.200
     1.126    34.158     0.200
     1.202    35.129     0.200
     1.202    35.129     0.200
     1.203    35.209     0.200
     1.204    35.309     0.200
     1.354    39.449     0.200
     1.513    43.418     0.200
     0.333    11.496     0.200
     0.409    13.430     0.200
     0.538    17.496     0.200
     1.076    31.418     0.200
     1.103    33.066     0.200
     1.129    33.688     0.200
     1.197    35.648     0.200
     1.228    37.129     0.200
     1.500    43.938     0.200
     1.514    44.207     0.200
     2.064    57.836     0.200
     0.303    12.055     0.200
     0.274    11.096     0.200
     0.304    12.186     0.200
     0.290    12.496     0.200
     0.386    14.855     0.200
     0.638    20.545     0.200
     0.674    21.248     0.200
     0.674    21.645     0.200
     0.674    21.361     0.200
     0.715    23.545     0.200
     0.715    23.736     0.200
     0.751    23.574     0.200
     0.784    25.055     0.200
     0.784    24.676     0.200
     0.814    25.428     0.200
     0.815    25.477     0.200
     0.796    24.041     0.200
     0.800    25.814     0.200
     0.901    28.562     0.200
     0.905    27.904     0.200
     0.901    28.113     0.200
     0.902    27.570     0.200
     0.894    26.820     0.200
     0.904    27.455     0.200
     0.909    27.266     0.200
     0.909    27.000     0.200
     0.942    28.123     0.200
     1.034    31.242     0.200
     1.088    33.477     0.200
     1.106    33.107     0.200
     1.092    33.006     0.200
     1.168    35.002     0.200
     1.201    36.391     0.200
     1.218    37.172     0.200
     1.250    37.672     0.200
     1.217    36.922     0.200
     1.412    41.154     0.200
     1.420    41.225     0.200
     1.460    43.131     0.200
     1.477    44.137     0.200
     1.622    48.219     0.200
     1.766    51.371     0.200
     1.841    54.473     0.200
     1.871    54.105     0.200
     1.924    55.258     0.200
     1.949    57.422     0.200
     1.961    58.027     0.200
     2.285    65.109     0.200
     2.337    67.383     0.200
     2.360    67.111     0.200
     2.521    73.967     0.200
     2.755    79.553     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
    10.089   321.150     0.200
    15.217   476.250     0.200
     2.973    90.812     0.200
     6.079   189.109     0.200
     9.251   288.711     0.200
    18.856   595.141     0.200
    19.228   607.117     0.200
     4.124   124.383     0.200
     5.106   155.258     0.200
    14.978   471.156     0.200
     2.538    76.379     0.200
     2.761    83.051     0.200
     3.389   102.691     0.200
     3.618   110.332     0.200
     5.181   156.852     0.200
     6.778   203.277     0.200
     9.103   280.953     0.200
     3.854   118.223     0.200
     5.703   174.324     0.200
     2.548    81.898     0.200
     2.548    80.758     0.200
     2.853    88.188     0.200
     3.626   112.250     0.200
     4.023   121.742     0.200
     5.266   164.969     0.200
     5.699   177.289     0.200
     5.927   184.555     0.200
     6.245   197.094     0.200
     6.723   210.289     0.200
     7.573   235.258     0.200
     8.683   270.383     0.200
     8.705   270.430     0.200
     8.949   280.664     0.200
     9.238   283.133     0.200
     9.446   290.992     0.200
     9.470   291.102     0.200
     9.735   306.242     0.200
    10.224   325.422     0.200
    12.136   377.828     0.200
    12.892   410.109     0.200
    13.219   424.508     0.200
    13.876   435.102     0.200
    14.785   466.258     0.200
    14.810   467.141     0.200
    14.872   460.234     0.200
    14.926   467.617     0.200
    14.929   467.203     0.200
    18.654   589.914     0.200
    19.255   610.812     0.200
    19.255   603.141     0.200
    20.052   631.117     0.200
    20.140   623.188     0.200
    20.140   627.602     0.200
    28.782   893.383     0.200
     2.985    90.088     0.200
     3.367   100.796     0.200
     5.768   177.707     0.200
     9.612   296.896     0.200
    14.696   453.307     0.200
    19.255   602.496     0.200
    19.277   593.021     0.200
    19.571   613.121     0.200
     3.600   103.230     0.200
     9.832   302.480     0.200
     4.083   127.461     0.200
     5.378   166.055     0.200
    10.303   322.984     0.200
    15.161   469.227     0.200
    19.097   592.961     0.200
     3.140    92.636     0.200
     9.441   288.086     0.200
    14.731   456.601     0.200
    19.009   593.701     0.200
    19.426   602.900     0.200
    19.587   609.711     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.980    29.109     0.200
     1.387    40.230     0.200
     1.438    41.691     0.200
     1.406    40.121     0.200
     1.652    47.543     0.200
     2.930    85.320     0.200
     0.837    25.070     0.200
     0.925    27.650     0.200
     1.117    33.730     0.200
     1.364    41.381     0.200
     1.558    47.650     0.200
     2.182    66.189     0.200
     2.267    67.449     0.200
     1.282    37.301     0.200
     1.508    43.461     0.200
     1.510    44.162     0.200
     1.538    43.912     0.200
     1.780    51.512     0.200
     3.027    83.842     0.200
     1.508    43.363     0.200
     1.528    44.914     0.200
     1.648    47.625     0.200
     0.449    13.891     0.200
     0.506    17.512     0.200
     0.863    24.781     0.200
     0.896    26.078     0.200
     0.966    28.949     0.200
     1.269    37.059     0.200
     1.313    39.449     0.200
     1.392    40.191     0.200
     1.628    47.969     0.200
     1.770    49.918     0.200
     1.886    55.512     0.200
     2.181    63.711     0.200
     2.242    64.809     0.200
     2.612    76.641     0.200
     2.676    80.199     0.200
     2.794    81.410     0.200
     2.924    84.789     0.200
     3.095    88.488     0.200
     3.688   107.160     0.200
     0.378    12.652     0.200
     0.467    16.230     0.200
     1.113    32.953     0.200
     1.177    34.023     0.200
     1.213    35.352     0.200
     1.318    38.523     0.200
     1.583    46.781     0.200
     1.735    50.391     0.200
     1.826    54.102     0.200
     2.135    63.891     0.200
     2.185    64.422     0.200
     2.560    75.332     0.200
     2.625    78.773     0.200
     2.618    77.074     0.200
     2.744    80.402     0.200
     2.744    81.102     0.200
     3.045    90.324     0.200
     3.790   108.602     0.200
     0.319    12.449     0.200
     0.319    12.320     0.200
     0.731    22.359     0.200
     0.811    24.520     0.200
     0.824    24.637     0.200
     1.142    32.930     0.200
     1.246    36.098     0.200
     1.384    39.918     0.200
     1.459    41.418     0.200
     1.506    44.070     0.200
     1.662    47.520     0.200
     1.726    48.988     0.200
     1.898    53.270     0.200
     0.994    30.258     0.200
     1.005    30.230     0.200
     1.279    36.699     0.200
     1.278    37.371     0.200
     1.341    39.559     0.200
     1.499    43.590     0.200
     0.408    14.555     0.200
     1.111    33.031     0.200
     1.195    34.930     0.200
     1.266    37.805     0.200
     1.257    37.398     0.200
     1.342    39.734     0.200
     1.529    45.078     0.200
     1.806    52.688     0.200
     2.880    83.383     0.200
     2.880    82.852     0.200
     0.451    15.836     0.200
     0.554    17.266     0.200
     0.900    26.164     0.200
     1.175    35.164     0.200
     2.919    83.273     0.200
     0.392    14.507     0.200
     0.823    24.627     0.200
     0.863    26.757     0.200
     0.837    26.037     0.200
     1.023    30.667     0.200
     1.059    31.547     0.200
     1.092    32.467     0.200
     1.143    33.877     0.200
     1.183    35.127     0.200
     1.247    36.917     0.200
     1.341    38.517     0.200
     1.323    38.097     0.200
     0.403    15.004     0.200
     0.845    25.195     0.200
     0.889    27.117     0.200
     1.047    31.766     0.200
     1.072    31.867     0.200
     1.114    33.176     0.200
     1.209    35.348     0.200
     1.265    36.867     0.200
     1.266    37.715     0.200
     1.363    38.977     0.200
     1.803    50.605     0.200
     2.896    84.176     0.200
     0.456    14.828     0.200
     0.629    20.078     0.200
     0.784    24.588     0.200
     0.792    24.679     0.200
     0.993    30.248     0.200
     1.046    31.108     0.200
     1.165    33.498     0.200
     1.441    43.648     0.200
     1.501    44.519     0.200
     1.525    45.559     0.200
     1.576    47.418     0.200
     1.834    54.969     0.200
     2.013    60.788     0.200
     2.287    65.009     0.200
     3.007    84.918     0.200
     0.132     5.936     0.200
     0.152     6.266     0.200
     0.219     7.904     0.200
     0.388    11.834     0.200
     0.400    13.004     0.200
     0.537    16.615     0.200
     0.601    18.664     0.200
     0.697    21.314     0.200
     0.750    22.926     0.200
     0.821    24.455     0.200
     0.897    26.355     0.200
     0.915    27.045     0.200
     1.244    37.266     0.200
     1.256    37.215     0.200
     1.260    37.516     0.200
     1.444    43.055     0.200
     1.479    43.516     0.200
     1.480    43.404     0.200
     1.480    43.664     0.200
     1.480    43.324     0.200
     1.480    43.824     0.200
     1.481    44.055     0.200
     1.481    43.715     0.200
     1.481    43.635     0.200
     1.482    43.766     0.200
     1.483    44.074     0.200
     1.484    43.814     0.200
     1.539    45.404     0.200
     1.628    48.074     0.200
     1.643    48.205     0.200
     1.667    48.084     0.200
     1.678    48.785     0.200
     1.679    48.545     0.200
     2.021    57.975     0.200
     2.036    58.004     0.200
     0.126     6.191     0.200
     0.145     6.332     0.200
     0.222     7.832     0.200
     0.384    12.631     0.200
     0.408    13.121     0.200
     0.540    16.881     0.200
     0.601    18.611     0.200
     0.705    21.271     0.200
     0.743    22.781     0.200
     0.829    24.893     0.200
     0.850    25.682     0.200
     0.896    26.393     0.200
     0.911    26.822     0.200
     1.248    37.422     0.200
     1.256    36.881     0.200
     1.258    37.232     0.200
     1.441    42.092     0.200
     1.478    43.521     0.200
     1.479    43.482     0.200
     1.479    43.162     0.200
     1.478    43.643     0.200
     1.480    43.551     0.200
     1.480    43.502     0.200
     1.480    43.361     0.200
     1.481    43.752     0.200
     1.482    43.631     0.200
     1.483    43.812     0.200
     1.542    45.711     0.200
     1.628    48.102     0.200
     1.641    48.021     0.200
     1.686    48.711     0.200
     2.041    59.492     0.200
     1.329    39.320     0.200
     1.336    40.148     0.200
     1.259    35.898     0.200
     1.489    42.680     0.200
     1.531    44.680     0.200
     1.517    43.766     0.200
     1.579    45.188     0.200
     1.605    46.461     0.200
     1.630    46.672     0.200
     1.767    50.055     0.200
     1.836    53.570     0.200
     2.498    70.328     0.200
     0.925    27.025     0.200
     0.930    28.375     0.200
     1.348    39.225     0.200
     1.532    43.765     0.200
     0.194     8.656     0.200
     0.467    16.430     0.200
     1.204    36.496     0.200
     1.205    36.387     0.200
     1.205    36.547     0.200
     1.205    36.449     0.200
     1.206    36.617     0.200
     1.209    36.816     0.200
     1.232    37.020     0.200
     1.291    38.020     0.200
     1.317    38.246     0.200
     1.310    38.367     0.200
     1.310    38.477     0.200
     1.415    41.430     0.200
     1.454    43.336     0.200
     1.530    44.848     0.200
     1.567    45.996     0.200
     1.875    53.219     0.200
     1.906    54.457     0.200
     1.936    55.246     0.200
     2.126    59.816     0.200
     0.286    12.180     0.200
     0.916    27.328     0.200
     0.917    27.461     0.200
     0.917    27.328     0.200
     1.183    33.906     0.200
     1.182    34.945     0.200
     1.182    35.109     0.200
     1.305    37.625     0.200
     1.604    44.984     0.200
     1.569    44.148     0.200
     1.604    45.641     0.200
     1.708    48.625     0.200
     0.275    11.586     0.200
     0.275    11.422     0.200
     0.275    11.594     0.200
     0.275    11.477     0.200
     0.434    14.992     0.200
     0.434    14.789     0.200
     0.513    16.805     0.200
     0.704    21.945     0.200
     0.704    21.375     0.200
     0.672    21.875     0.200
     0.704    21.391     0.200
     0.746    22.852     0.200
     0.746    22.492     0.200
     0.740    24.031     0.200
     1.034    29.875     0.200
     1.109    32.422     0.200
     1.155    33.281     0.200
     1.230    36.086     0.200
     1.240    36.094     0.200
     1.349    39.180     0.200
     1.478    41.984     0.200
     0.113     8.889     0.200
     0.112     8.889     0.200
     0.112     9.020     0.200
     0.183     9.809     0.200
     0.214    10.119     0.200
     0.350    13.270     0.200
     0.350    13.379     0.200
     0.393    13.809     0.200
     0.393    13.818     0.200
     0.659    20.648     0.200
     0.726    22.809     0.200
     0.727    22.770     0.200
     0.861    25.969     0.200
     0.921    27.619     0.200
     1.003    29.568     0.200
     1.011    30.629     0.200
     1.106    33.039     0.200
     1.130    33.658     0.200
     1.126    34.158     0.200
     1.202    35.129     0.200
     1.202    35.129     0.200
     1.203    35.209     0.200
     1.204    35.309     0.200
     1.354    39.449     0.200
     1.513    43.418     0.200
     0.333    11.496     0.200
     0.409    13.430     0.200
     0.538    17.496     0.200
     1.076    31.418     0.200
     1.103    33.066     0.200
     1.129    33.688     0.200
     1.197    35.648     0.200
     1.228    37.129     0.200
     1.500    43.938     0.200
     1.514    44.207     0.200
     2.064    57.836     0.200
     0.303    12.055     0.200
     0.274    11.096     0.200
     0.304    12.186     0.200
     0.290    12.496     0.200
     0.386    14.855     0.200
     0.638    20.545     0.200
     0.674    21.248     0.200
     0.674    21.645     0.200
     0.674    21.361     0.200
     0.715    23.545     0.200
     0.715    23.736     0.200
     0.751    23.574     0.200
     0.784    25.055     0.200
     0.784    24.676     0.200
     0.814    25.428     0.200
     0.815    25.477     0.200
     0.796    24.041     0.200
     0.800    25.814     0.200
     0.901    28.562     0.200
     0.905    27.904     0.200
     0.901    28.113     0.200
     0.902    27.570     0.200
     0.894    26.820     0.200
     0.904    27.455     0.200
     0.909    27.266     0.200
     0.909    27.000     0.200
     0.942    28.123     0.200
     1.034    31.242     0.200
     1.088    33.477     0.200
     1.106    33.107     0.200
     1.092    33.006     0.200
     1.168    35.002     0.200
     1.201    36.391     0.200
     1.218    37.172     0.200
     1.250    37.672     0.200
     1.217    36.922     0.200
     1.412    41.154     0.200
     1.420    41.225     0.200
     1.460    43.131     0.200
     1.477    44.137     0.200
     1.622    48.219     0.200
     1.766    51.371     0.200
     1.841    54.473     0.200
     1.871    54.105     0.200
     1.924    55.258     0.200
     1.949    57.422     0.200
     1.961    58.027     0.200
     2.285    65.109     0.200
     2.337    67.383     0.200
     2.360    67.111     0.200
     2.521    73.967     0.200
     2.755    79.553     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
