#!/bin/bash
gmt begin tofino1.52_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source tofino1.52'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0 -10.0
  1.0 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.948    -0.028     0.200
     0.717     0.032     0.200
     0.683    -0.045     0.200
     0.888    -0.572     0.200
     0.837    -0.123     0.200
     0.861    -0.163     0.200
     0.826     0.497     0.200
     0.925    -0.025     0.200
     0.791     0.504     0.200
     0.840     0.913     0.200
     0.939    -0.220     0.200
     0.799     0.529     0.200
     0.858     0.898     0.200
     0.937    -0.071     0.200
     0.449     0.070     0.200
     0.506     1.277     0.200
     0.863    -0.555     0.200
     0.896    -0.533     0.200
     0.966    -0.222     0.200
     0.378    -0.147     0.200
     0.467     0.455     0.200
     0.744    -0.070     0.200
     0.784    -0.301     0.200
     0.825    -0.695     0.200
     0.319    -0.160     0.200
     0.408     0.523     0.200
     0.503    -0.274     0.200
     0.732    -0.006     0.200
     0.842    -0.300     0.200
     0.850    -0.408     0.200
     0.880    -0.758     0.200
     0.554     0.034     0.200
     0.906    -0.230     0.200
     0.938    -0.360     0.200
     0.879    -0.384     0.200
     0.392     0.494     0.200
     0.493    -0.096     0.200
     0.736     0.249     0.200
     0.823    -0.582     0.200
     0.863    -0.310     0.200
     0.837    -0.460     0.200
     0.403     0.425     0.200
     0.518    -0.048     0.200
     0.845    -0.626     0.200
     0.841    -0.457     0.200
     0.889    -0.333     0.200
     0.896    -0.475     0.200
     0.456    -0.395     0.200
     0.629     0.317     0.200
     0.778    -0.596     0.200
     0.784    -0.438     0.200
     0.806    -0.578     0.200
     0.882     0.781     0.200
     0.993    -0.177     0.200
     0.132    -0.046     0.200
     0.152    -0.033     0.200
     0.219     0.019     0.200
     0.388     0.028     0.200
     0.400     0.079     0.200
     0.537     0.008     0.200
     0.601    -0.094     0.200
     0.687     0.374     0.200
     0.697     0.015     0.200
     0.821     0.025     0.200
     0.846     0.171     0.200
     0.897    -0.140     0.200
     0.915    -0.526     0.200
     0.924     0.136     0.200
     0.918     0.112     0.200
     0.973    -0.114     0.200
     0.984     0.081     0.200
     0.999    -0.391     0.200
     0.126    -0.004     0.200
     0.145    -0.001     0.200
     0.384     0.047     0.200
     0.408    -0.079     0.200
     0.540    -0.129     0.200
     0.601    -0.150     0.200
     0.690     0.289     0.200
     0.705    -0.227     0.200
     0.743     1.149     0.200
     0.829    -0.226     0.200
     0.850     0.270     0.200
     0.896    -0.167     0.200
     0.911    -0.465     0.200
     0.927     0.042     0.200
     0.914    -0.068     0.200
     0.981    -0.288     0.200
     0.990    -0.059     0.200
     0.999    -0.400     0.200
     0.471    -0.194     0.200
     0.656    -0.254     0.200
     0.637    -0.171     0.200
     0.698     0.200     0.200
     0.930    -0.448     0.200
     0.194    -0.481     0.200
     0.387     0.276     0.200
     0.467    -0.079     0.200
     0.485    -0.041     0.200
     0.530     1.368     0.200
     0.641     0.779     0.200
     0.921    -0.333     0.200
     0.286     0.134     0.200
     0.520     0.357     0.200
     0.650    -0.011     0.200
     0.687    -0.058     0.200
     0.979    -0.416     0.200
     0.275     0.003     0.200
     0.275    -0.004     0.200
     0.456     0.518     0.200
     0.456     0.651     0.200
     0.434    -0.066     0.200
     0.513    -0.291     0.200
     0.704    -0.523     0.200
     0.704    -0.406     0.200
     0.672     0.038     0.200
     0.672    -0.212     0.200
     0.704    -0.513     0.200
     0.745    -0.352     0.200
     0.746    -0.612     0.200
     0.746    -0.214     0.200
     0.740    -0.083     0.200
     0.857    -0.296     0.200
     0.113     0.073     0.200
     0.112     0.096     0.200
     0.183     0.001     0.200
     0.183    -0.159     0.200
     0.214    -0.017     0.200
     0.350    -0.200     0.200
     0.393    -0.264     0.200
     0.393    -0.259     0.200
     0.659    -0.320     0.200
     0.726    -0.332     0.200
     0.727    -0.275     0.200
     0.801    -0.379     0.200
     0.861    -0.389     0.200
     0.921    -0.576     0.200
     0.333    -0.285     0.200
     0.448     0.431     0.200
     0.409    -0.093     0.200
     0.538     0.074     0.200
     0.671     0.231     0.200
     0.788    -0.276     0.200
     0.841    -0.259     0.200
     0.906    -0.401     0.200
     0.936    -0.199     0.200
     0.303    -0.047     0.200
     0.274    -0.310     0.200
     0.304    -0.238     0.200
     0.304    -0.036     0.200
     0.290     0.206     0.200
     0.386     0.202     0.200
     0.536    -0.665     0.200
     0.638    -0.309     0.200
     0.674    -0.367     0.200
     0.902    -0.396     0.200
     0.901    -0.348     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.980    -0.292     0.200
     0.302     0.127     0.200
     0.279     0.544     0.200
     0.409     0.137     0.200
     0.744     0.134     0.200
     0.726     0.350     0.200
     0.740    -0.058     0.200
     0.888     0.273     0.200
     0.918     0.529     0.200
     0.238    -0.193     0.200
     0.344    -0.387     0.200
     0.613    -0.407     0.200
     0.632    -0.368     0.200
     0.758    -0.271     0.200
     0.779     0.536     0.200
     0.883     0.136     0.200
     0.877    -0.060     0.200
     0.895     0.079     0.200
     0.947    -0.022     0.200
     0.994    -0.659     0.200
     0.995     0.729     0.200
     0.238    -0.011     0.200
     0.451    -0.118     0.200
     0.682    -0.246     0.200
     0.744    -0.312     0.200
     0.732    -0.362     0.200
     0.731    -0.323     0.200
     0.811    -0.093     0.200
     0.825    -0.498     0.200
     0.824    -0.030     0.200
     0.911     0.208     0.200
     0.502    -0.116     0.200
     0.617     0.142     0.200
     0.752    -0.090     0.200
     0.994     0.331     0.200
     0.108    -0.119     0.200
     0.370    -0.134     0.200
     0.412    -0.166     0.200
     0.418    -0.192     0.200
     0.445    -0.173     0.200
     0.451    -0.116     0.200
     0.538     0.286     0.200
     0.577    -0.217     0.200
     0.558     0.493     0.200
     0.621    -0.017     0.200
     0.665     0.244     0.200
     0.711     0.122     0.200
     0.737     0.067     0.200
     0.797     0.253     0.200
     0.911     0.251     0.200
     0.968     0.332     0.200
     0.240    -0.143     0.200
     0.286    -0.218     0.200
     0.320    -0.076     0.200
     0.343    -0.233     0.200
     0.342    -0.192     0.200
     0.364    -0.287     0.200
     0.380    -0.039     0.200
     0.454    -0.383     0.200
     0.568     0.139     0.200
     0.729     0.191     0.200
     0.754    -0.199     0.200
     0.749     0.391     0.200
     0.761     0.351     0.200
     0.842    -0.380     0.200
     0.865    -0.281     0.200
     0.860     0.408     0.200
     0.882     0.111     0.200
     0.994    -0.071     0.200
     0.359     0.089     0.200
     0.278     0.200     0.200
     0.357     0.071     0.200
     0.329     0.026     0.200
     0.458     0.279     0.200
     0.525     0.134     0.200
     0.645    -0.144     0.200
     0.659    -0.075     0.200
     0.681     0.198     0.200
     0.748     0.409     0.200
     0.803     0.064     0.200
     0.813     0.321     0.200
     0.842     0.157     0.200
     0.842     0.267     0.200
     0.886    -0.253     0.200
     0.888    -0.252     0.200
     0.902     0.597     0.200
     0.995    -0.096     0.200
     0.879    -0.404     0.200
     0.752    -0.185     0.200
     0.867     0.566     0.200
     0.893    -0.432     0.200
     0.122    -0.153     0.200
     0.271    -0.034     0.200
     0.286    -0.048     0.200
     0.316    -0.070     0.200
     0.523     0.148     0.200
     0.565     0.192     0.200
     0.602     0.145     0.200
     0.631     0.368     0.200
     0.704     0.027     0.200
     0.812     0.228     0.200
     0.883     0.611     0.200
     0.984     0.664     0.200
     0.987     0.622     0.200
     0.779    -0.182     0.200
     0.779    -0.342     0.200
     0.842    -0.230     0.200
     0.898     0.291     0.200
     0.218    -0.160     0.200
     0.337    -0.358     0.200
     0.345     0.120     0.200
     0.420    -0.093     0.200
     0.526    -0.151     0.200
     0.535    -0.111     0.200
     0.782    -0.232     0.200
     0.798    -0.044     0.200
     0.792     0.104     0.200
     0.885     0.074     0.200
     0.878     0.376     0.200
     0.885    -0.290     0.200
     0.938    -0.338     0.200
     0.998     0.162     0.200
     0.204    -0.158     0.200
     0.252    -0.071     0.200
     0.281    -0.197     0.200
     0.281    -0.192     0.200
     0.322    -0.376     0.200
     0.392    -0.375     0.200
     0.404    -0.048     0.200
     0.424    -0.072     0.200
     0.642     0.131     0.200
     0.707     0.164     0.200
     0.761    -0.161     0.200
     0.800    -0.175     0.200
     0.800    -0.245     0.200
     0.807     0.333     0.200
     0.831     0.374     0.200
     0.850     0.231     0.200
     0.844     0.374     0.200
     0.877     0.088     0.200
     0.909     0.178     0.200
     0.902     0.026     0.200
     0.935     0.545     0.200
     0.488    -0.008     0.200
     0.520     0.228     0.200
     0.035    -0.167     0.200
     0.066    -0.174     0.200
     0.302     0.041     0.200
     0.299    -0.151     0.200
     0.300    -0.176     0.200
     0.521    -0.325     0.200
     0.710    -0.180     0.200
     0.771     0.370     0.200
     0.829    -0.220     0.200
     0.859     0.315     0.200
     0.859    -0.321     0.200
     0.913     0.196     0.200
     0.934    -0.229     0.200
     0.934    -0.249     0.200
     0.934    -0.139     0.200
     0.299    -0.087     0.200
     0.340    -0.096     0.200
     0.403     0.024     0.200
     0.463    -0.159     0.200
     0.462    -0.140     0.200
     0.659     0.432     0.200
     0.655     0.355     0.200
     0.740     0.494     0.200
     0.740     0.065     0.200
     0.779     0.371     0.200
     0.966    -0.097     0.200
     0.943    -0.183     0.200
     0.955    -0.072     0.200
     0.955    -0.212     0.200
     0.941     0.318     0.200
     0.975    -0.337     0.200
     0.260    -0.120     0.200
     0.401    -0.192     0.200
     0.449    -0.265     0.200
     0.500    -0.337     0.200
     0.566    -0.323     0.200
     0.595     0.034     0.200
     0.596    -0.053     0.200
     0.803     0.291     0.200
     0.961    -0.021     0.200
     0.980     0.307     0.200
     0.076    -0.054     0.200
     0.244    -0.305     0.200
     0.254    -0.247     0.200
     0.358     0.461     0.200
     0.427     0.643     0.200
     0.467     0.097     0.200
     0.516     0.318     0.200
     0.559    -0.128     0.200
     0.560    -0.103     0.200
     0.575     0.003     0.200
     0.576    -0.158     0.200
     0.576     0.061     0.200
     0.609    -0.230     0.200
     0.702     0.095     0.200
     0.806    -0.147     0.200
     0.856    -0.028     0.200
     0.838     0.090     0.200
     0.838    -0.019     0.200
     0.856    -0.055     0.200
     0.857    -0.138     0.200
     0.857    -0.019     0.200
     0.848     0.165     0.200
     0.897    -0.380     0.200
     0.963     0.416     0.200
     0.970     0.252     0.200
     0.505    -0.401     0.200
     0.700     0.270     0.200
     0.900     0.178     0.200
     0.654    -0.184     0.200
     0.679    -0.220     0.200
     0.166    -0.228     0.200
     0.210    -0.206     0.200
     0.320    -0.247     0.200
     0.344    -0.233     0.200
     0.355    -0.128     0.200
     0.414    -0.195     0.200
     0.414    -0.200     0.200
     0.493    -0.294     0.200
     0.593     0.003     0.200
     0.801     0.199     0.200
     0.882    -0.475     0.200
     0.866     0.464     0.200
     0.903    -0.098     0.200
     0.903    -0.067     0.200
     0.912     0.623     0.200
     0.915     0.390     0.200
     0.949     0.186     0.200
     0.212    -0.469     0.200
     0.235    -0.076     0.200
     0.270    -0.058     0.200
     0.219    -0.311     0.200
     0.310     0.094     0.200
     0.354    -0.186     0.200
     0.354    -0.168     0.200
     0.509    -0.264     0.200
     0.459    -0.012     0.200
     0.536    -0.199     0.200
     0.597     0.122     0.200
     0.675     0.060     0.200
     0.695    -0.113     0.200
     0.763    -0.143     0.200
     0.736    -0.105     0.200
     0.782     0.019     0.200
     0.782     0.027     0.200
     0.782     0.046     0.200
     0.836     0.102     0.200
     0.836    -0.028     0.200
     0.836     0.032     0.200
     0.829    -0.021     0.200
     0.799    -0.119     0.200
     0.799    -0.013     0.200
     0.840     0.111     0.200
     0.864    -0.042     0.200
     0.935    -0.012     0.200
     0.965    -0.309     0.200
     0.952    -0.171     0.200
     0.965     0.155     0.200
     0.069    -0.374     0.200
     0.259    -0.068     0.200
     0.393    -0.131     0.200
     0.523     0.229     0.200
     0.587     0.074     0.200
     0.593     0.034     0.200
     0.673     0.043     0.200
     0.724     0.403     0.200
     0.859    -0.000     0.200
     0.860    -0.043     0.200
     0.854     0.248     0.200
     0.947     0.135     0.200
     0.947     0.150     0.200
     0.906     0.494     0.200
     0.950     0.538     0.200
     0.962     0.158     0.200
     0.492    -0.150     0.200
     0.492    -0.140     0.200
     0.490    -0.152     0.200
     0.566    -0.129     0.200
     0.566    -0.309     0.200
     0.599    -0.286     0.200
     0.599    -0.253     0.200
     0.621     0.297     0.200
     0.674    -0.379     0.200
     0.692     0.386     0.200
     0.715    -0.096     0.200
     0.715    -0.049     0.200
     0.784     0.245     0.200
     0.815     0.326     0.200
     0.796    -0.459     0.200
     0.800     0.199     0.200
     0.901    -0.516     0.200
     0.902     0.027     0.200
     0.894    -0.342     0.200
     0.904    -0.011     0.200
     0.894     0.142     0.200
     0.909    -0.485     0.200
     0.909    -0.448     0.200
     0.942    -0.236     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.980    -0.511     0.200
     0.837    -0.498     0.200
     0.925    -0.160     0.200
     0.449    -0.504     0.200
     0.506     1.569     0.200
     0.863    -1.316     0.200
     0.896    -0.818     0.200
     0.966    -0.104     0.200
     0.378    -0.312     0.200
     0.467     0.991     0.200
     0.319    -0.025     0.200
     0.319    -0.154     0.200
     0.731    -0.686     0.200
     0.811    -0.750     0.200
     0.824    -0.750     0.200
     0.994     0.123     0.200
     0.408     0.849     0.200
     0.451     1.184     0.200
     0.554    -0.204     0.200
     0.900    -0.954     0.200
     0.392     0.881     0.200
     0.823    -0.567     0.200
     0.863     0.343     0.200
     0.837     0.485     0.200
     0.403     0.969     0.200
     0.845    -0.653     0.200
     0.889    -0.089     0.200
     0.456     0.482     0.200
     0.629     0.933     0.200
     0.784     0.817     0.200
     0.792     0.756     0.200
     0.993     0.721     0.200
     0.132    -0.539     0.200
     0.152    -0.464     0.200
     0.219    -0.337     0.200
     0.388    -0.753     0.200
     0.400    -0.193     0.200
     0.537    -0.106     0.200
     0.601    -0.049     0.200
     0.697    -0.080     0.200
     0.750     0.252     0.200
     0.821    -0.336     0.200
     0.897    -0.633     0.200
     0.915    -0.422     0.200
     0.126    -0.173     0.200
     0.145    -0.249     0.200
     0.222    -0.460     0.200
     0.384     0.150     0.200
     0.408    -0.291     0.200
     0.540     0.068     0.200
     0.601    -0.108     0.200
     0.705    -0.344     0.200
     0.743     0.313     0.200
     0.829    -0.118     0.200
     0.850     0.130     0.200
     0.896    -0.587     0.200
     0.911    -0.551     0.200
     0.925    -1.043     0.200
     0.930    -0.020     0.200
     0.194     0.847     0.200
     0.467     1.533     0.200
     0.286     1.336     0.200
     0.916    -0.431     0.200
     0.917    -0.291     0.200
     0.917    -0.424     0.200
     0.275     0.253     0.200
     0.275     0.089     0.200
     0.275     0.211     0.200
     0.275     0.094     0.200
     0.434    -0.066     0.200
     0.434    -0.269     0.200
     0.513    -0.285     0.200
     0.704    -0.127     0.200
     0.704    -0.698     0.200
     0.672     0.696     0.200
     0.704    -0.716     0.200
     0.746    -0.414     0.200
     0.746    -0.773     0.200
     0.740     0.935     0.200
     0.113     0.534     0.200
     0.112     0.472     0.200
     0.112     0.603     0.200
     0.183     0.211     0.200
     0.214     0.145     0.200
     0.350     0.117     0.200
     0.350     0.227     0.200
     0.393    -0.064     0.200
     0.393    -0.094     0.200
     0.659    -0.206     0.200
     0.726     0.132     0.200
     0.727     0.091     0.200
     0.861    -0.409     0.200
     0.921    -0.467     0.200
     0.333    -0.308     0.200
     0.409    -0.306     0.200
     0.538     0.345     0.200
     0.303     0.288     0.200
     0.274    -0.127     0.200
     0.304     0.352     0.200
     0.290     0.976     0.200
     0.386     1.022     0.200
     0.638     0.298     0.200
     0.674     0.022     0.200
     0.674     0.269     0.200
     0.674    -0.014     0.200
     0.715     1.175     0.200
     0.715     1.359     0.200
     0.751     0.261     0.200
     0.784     0.827     0.200
     0.784     0.448     0.200
     0.814     0.375     0.200
     0.815     0.388     0.200
     0.796    -0.500     0.200
     0.800     1.160     0.200
     0.901     1.130     0.200
     0.905     0.347     0.200
     0.901     0.656     0.200
     0.902     0.095     0.200
     0.894    -0.446     0.200
     0.904    -0.074     0.200
     0.909    -0.412     0.200
     0.909    -0.670     0.200
     0.942    -0.474     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.861    -0.198     0.200
     0.302    -0.037     0.200
     0.279     1.078     0.200
     0.409     0.418     0.200
     0.681     0.370     0.200
     0.744     0.868     0.200
     0.726     0.738     0.200
     0.740     0.795     0.200
     0.888     0.795     0.200
     0.918     1.124     0.200
     0.238    -0.133     0.200
     0.344    -0.358     0.200
     0.613    -0.335     0.200
     0.632     0.000     0.200
     0.758    -0.303     0.200
     0.883     0.109     0.200
     0.877     0.502     0.200
     0.947     0.873     0.200
     0.994     0.437     0.200
     0.238    -0.112     0.200
     0.451    -0.123     0.200
     0.682    -0.850     0.200
     0.744    -0.171     0.200
     0.732     0.270     0.200
     0.791    -0.452     0.200
     0.939    -0.469     0.200
     0.937    -0.593     0.200
     0.784    -0.813     0.200
     0.825    -0.679     0.200
     0.902     0.273     0.200
     0.825    -0.652     0.200
     0.502    -0.105     0.200
     0.617     0.694     0.200
     0.752    -0.668     0.200
     0.108    -0.313     0.200
     0.370    -0.118     0.200
     0.412    -0.206     0.200
     0.445    -0.252     0.200
     0.451    -0.162     0.200
     0.538     0.751     0.200
     0.577    -0.186     0.200
     0.558     0.780     0.200
     0.621    -0.488     0.200
     0.665     0.194     0.200
     0.737     0.458     0.200
     0.797     0.392     0.200
     0.968     0.940     0.200
     0.240    -0.000     0.200
     0.286    -0.090     0.200
     0.320     0.155     0.200
     0.343     0.201     0.200
     0.342     0.191     0.200
     0.364    -0.134     0.200
     0.380     0.186     0.200
     0.454    -0.261     0.200
     0.568     0.531     0.200
     0.729     0.701     0.200
     0.754     0.282     0.200
     0.749     0.965     0.200
     0.761     0.896     0.200
     0.784     0.657     0.200
     0.842    -0.153     0.200
     0.865     0.268     0.200
     0.860     1.156     0.200
     0.882     1.036     0.200
     0.994    -0.209     0.200
     0.357     0.029     0.200
     0.329     0.511     0.200
     0.458     0.686     0.200
     0.525     0.812     0.200
     0.645     0.078     0.200
     0.659     0.112     0.200
     0.681     0.898     0.200
     0.748     0.718     0.200
     0.803     0.808     0.200
     0.813     0.752     0.200
     0.842     0.669     0.200
     0.886    -0.181     0.200
     0.888    -0.172     0.200
     0.902     1.186     0.200
     0.995     1.293     0.200
     0.842    -0.195     0.200
     0.878    -0.076     0.200
     0.493    -0.799     0.200
     0.736     1.291     0.200
     0.518    -0.538     0.200
     0.846    -0.804     0.200
     0.924    -0.658     0.200
     0.973    -0.553     0.200
     0.999    -1.044     0.200
     0.927    -0.708     0.200
     0.981    -0.740     0.200
     0.990    -0.242     0.200
     0.999    -0.996     0.200
     0.752    -0.449     0.200
     0.867     0.744     0.200
     0.893    -0.049     0.200
     0.471    -1.104     0.200
     0.637    -0.332     0.200
     0.122    -0.256     0.200
     0.271    -0.046     0.200
     0.286    -0.146     0.200
     0.316     0.268     0.200
     0.523     0.088     0.200
     0.602     0.198     0.200
     0.812     0.619     0.200
     0.883     1.575     0.200
     0.984     1.138     0.200
     0.641    -0.051     0.200
     0.666     0.920     0.200
     0.779     1.405     0.200
     0.842     1.344     0.200
     0.921     0.201     0.200
     0.218    -0.216     0.200
     0.337    -0.217     0.200
     0.345     0.032     0.200
     0.420    -0.005     0.200
     0.526     0.203     0.200
     0.535    -0.296     0.200
     0.781    -0.065     0.200
     0.782    -0.413     0.200
     0.798     0.216     0.200
     0.792     0.718     0.200
     0.878     0.987     0.200
     0.885     0.079     0.200
     0.938    -0.329     0.200
     0.204    -0.097     0.200
     0.252    -0.109     0.200
     0.281    -0.091     0.200
     0.281    -0.039     0.200
     0.322    -0.280     0.200
     0.392    -0.364     0.200
     0.404     0.249     0.200
     0.424     0.115     0.200
     0.642     0.550     0.200
     0.707     0.185     0.200
     0.761     0.126     0.200
     0.800     0.574     0.200
     0.800     0.762     0.200
     0.807     1.071     0.200
     0.831     0.818     0.200
     0.850     1.063     0.200
     0.844     0.908     0.200
     0.935     1.379     0.200
     0.488    -0.495     0.200
     0.488     0.122     0.200
     0.520    -0.443     0.200
     0.650    -0.288     0.200
     0.687    -0.410     0.200
     0.687    -0.254     0.200
     0.035    -0.212     0.200
     0.035    -0.052     0.200
     0.066    -0.259     0.200
     0.302     0.205     0.200
     0.299    -0.058     0.200
     0.300    -0.086     0.200
     0.521    -0.255     0.200
     0.710     1.403     0.200
     0.829     0.238     0.200
     0.859     0.264     0.200
     0.859    -0.053     0.200
     0.934     0.496     0.200
     0.934     0.378     0.200
     0.299    -0.048     0.200
     0.340    -0.003     0.200
     0.463    -0.044     0.200
     0.463     0.126     0.200
     0.462     0.049     0.200
     0.659     0.918     0.200
     0.655     0.899     0.200
     0.779     1.195     0.200
     0.966     1.540     0.200
     0.966     1.140     0.200
     0.943     0.082     0.200
     0.941     1.407     0.200
     0.260     0.827     0.200
     0.401    -0.125     0.200
     0.449     0.003     0.200
     0.500    -0.342     0.200
     0.566    -0.622     0.200
     0.595    -0.284     0.200
     0.596    -0.063     0.200
     0.961    -0.171     0.200
     0.076     0.343     0.200
     0.244    -0.346     0.200
     0.244    -0.526     0.200
     0.254    -0.464     0.200
     0.559     0.167     0.200
     0.559    -0.091     0.200
     0.560     0.207     0.200
     0.560    -0.113     0.200
     0.575     0.304     0.200
     0.575     0.133     0.200
     0.576     0.420     0.200
     0.576     0.194     0.200
     0.609    -0.069     0.200
     0.702     0.640     0.200
     0.702     0.254     0.200
     0.806    -0.023     0.200
     0.806    -0.324     0.200
     0.856     0.231     0.200
     0.856    -0.206     0.200
     0.838     1.151     0.200
     0.856    -0.017     0.200
     0.857    -0.045     0.200
     0.857    -0.157     0.200
     0.860     0.132     0.200
     0.897    -0.094     0.200
     0.897    -0.203     0.200
     0.963     0.744     0.200
     0.970     1.007     0.200
     0.505    -0.443     0.200
     0.654    -0.181     0.200
     0.679    -0.025     0.200
     0.788    -0.635     0.200
     0.841    -0.657     0.200
     0.906    -0.768     0.200
     0.166    -0.079     0.200
     0.210    -0.155     0.200
     0.320     0.310     0.200
     0.344     0.079     0.200
     0.355     0.365     0.200
     0.414     0.203     0.200
     0.414     0.395     0.200
     0.493     0.089     0.200
     0.772     0.486     0.200
     0.801     0.945     0.200
     0.866     1.327     0.200
     0.903     0.534     0.200
     0.912     1.564     0.200
     0.949     1.096     0.200
     0.212    -0.784     0.200
     0.235    -0.046     0.200
     0.219    -0.539     0.200
     0.219    -0.309     0.200
     0.270     0.143     0.200
     0.219    -0.307     0.200
     0.310     0.363     0.200
     0.332     0.759     0.200
     0.354    -0.346     0.200
     0.354    -0.269     0.200
     0.509    -0.346     0.200
     0.509    -0.217     0.200
     0.459     0.473     0.200
     0.597     0.176     0.200
     0.675     0.517     0.200
     0.763    -0.167     0.200
     0.763    -0.327     0.200
     0.782     0.144     0.200
     0.836     0.148     0.200
     0.836    -0.212     0.200
     0.836     0.187     0.200
     0.829     0.139     0.200
     0.829    -0.142     0.200
     0.864    -0.273     0.200
     0.935     0.126     0.200
     0.965    -0.480     0.200
     0.069    -0.536     0.200
     0.259    -0.301     0.200
     0.393    -0.090     0.200
     0.523     0.565     0.200
     0.587    -0.177     0.200
     0.593    -0.056     0.200
     0.593    -0.276     0.200
     0.673     0.298     0.200
     0.859     0.160     0.200
     0.860     0.247     0.200
     0.906     0.809     0.200
     0.950     1.463     0.200
     0.492    -0.041     0.200
     0.492     0.104     0.200
     0.492     0.242     0.200
     0.492     0.008     0.200
     0.490     1.342     0.200
     0.536    -0.417     0.200
     0.566     0.243     0.200
     0.566     0.348     0.200
     0.599     0.215     0.200
     0.599     0.268     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00   -0.082
 1.00   -0.082
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00   -0.006
 1.00   -0.006
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.1
 1.00    0.1
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00    0.2
 1.00    0.2
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.0)
     0.050     7.000   Pg = red x; average =  -0.1 (solid red line)
     0.050     5.000   Pn = green x; average =  -0.0 (solid green line)
     0.050    -7.500   Sg = red circles; average =   0.1 (dashed red line)
     0.050    -9.500   Sn = green circles; average =   0.2 (dashed green line)
EOF
gmt end
