#!/bin/bash
gmt begin tofino1.52_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic tofino1.52'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.473
   135.500     1.555
   136.000     1.641
   136.500     1.729
   137.000     1.820
   137.500     1.915
   138.000     2.013
   138.500     2.115
   139.000     2.221
   139.500     2.329
   140.000     2.442
   140.500     2.560
   141.000     2.681
   141.500     2.807
   142.000     2.937
   142.500     3.072
   143.000     3.212
   143.500     3.357
   144.000     3.508
   144.500     3.665
   145.000     3.827
   145.500     3.996
   146.000     4.171
   146.500     4.353
   147.000     4.541
   147.500     4.737
   148.000     4.940
   148.500     5.151
   149.000     5.371
   149.500     5.600
   150.000     5.838
   150.500     6.087
   151.000     6.345
   151.500     6.614
   152.000     6.893
   152.500     7.182
   153.000     7.481
   153.500     7.791
   154.000     8.111
   154.500     8.443
   155.000     8.785
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.643
   145.500     0.326
   146.000     1.355
   146.500     2.427
   147.000     3.534
   147.500     4.669
   148.000     5.832
   148.500     7.019
   149.000     8.231
   149.500     9.465
   150.000    10.720
   150.500    11.998
   151.000    13.295
   151.500    14.612
   152.000    15.949
   152.500    17.303
   153.000    18.675
   153.500    20.065
   154.000    21.473
   154.500    22.898
   155.000    24.340
   155.500    25.799
   156.000    27.275
   156.500    28.768
   157.000    30.278
   157.500    31.804
   158.000    33.346
   158.500    34.906
   159.000    36.481
   159.500    38.073
   160.000    39.682
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.651
   145.500     0.108
   146.000     0.798
   146.500     1.437
   147.000     2.034
   147.500     2.592
   148.000     3.115
   148.500     3.605
   149.000     4.070
   149.500     4.515
   150.000     4.944
   150.500     5.361
   151.000     5.767
   151.500     6.163
   152.000     6.552
   152.500     6.933
   153.000     7.308
   153.500     7.679
   154.000     8.047
   154.500     8.414
   155.000     8.778
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   152.711     5.968     0.200
   144.234    -2.392     0.200
   144.728    -1.250     0.200
   146.354    -0.237     0.200
   144.460    -1.509     0.200
   144.965    -0.220     0.200
   146.566     1.602     0.200
   146.566     0.844     0.200
   146.566    -0.351     0.200
   147.728     3.910     0.200
   149.383     3.809     0.200
   150.453     6.151     0.200
   150.453     3.526     0.200
   151.341     2.750     0.200
   153.304     5.542     0.200
   159.263    -3.246     0.200
   144.593    -1.485     0.200
   145.953     0.311     0.200
   144.085    -2.598     0.200
   144.582    -2.599     0.200
   144.848    -1.576     0.200
   146.202     0.587     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   144.995    -1.213     0.200
   145.226    -0.390     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   145.571     1.701     0.200
   161.026    42.770     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   150.242     6.714     0.200
   151.040     6.475     0.200
   144.234     2.202     0.200
   144.728     3.250     0.200
   144.995     3.381     0.200
   149.837     5.868     0.200
   139.178     0.971     0.200
   150.453     7.424     0.200
   150.722     8.803     0.200
   151.341    10.055     0.200
   151.753     8.267     0.200
   150.009     4.974     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
