#!/bin/bash
gmt begin tofino1.52_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P tofino1.52'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.652
    79.000     8.481
    80.000     7.395
    81.000     6.394
    82.000     5.480
    83.000     4.649
    84.000     3.902
    85.000     3.243
    86.000     2.669
    87.000     2.173
    88.000     1.783
    89.000     1.485
    90.000     1.229
    91.000     1.004
    92.000     0.804
    93.000     0.622
    94.000     0.458
    95.000     0.314
    96.000     0.195
    97.000     0.103
    98.000     0.039
    99.000     0.005
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    19.108     2.335     0.200
    19.539     2.125     0.200
    19.775     2.246     0.200
    20.480     2.774     0.200
    20.685     0.157     0.200
    20.771     2.034     0.200
    21.154     3.097     0.200
    21.156     3.470     0.200
    21.703     2.796     0.200
    21.962     0.433     0.200
    22.897     1.499     0.200
    26.035     2.974     0.200
    26.619     3.793     0.200
    26.837     3.425     0.200
    27.164     3.691     0.200
    27.530     2.009     0.200
    28.797     3.215     0.200
    29.044     2.218     0.200
    29.248     2.010     0.200
    31.330     2.905     0.200
    32.378     3.902     0.200
    32.394     3.259     0.200
    32.549     2.897     0.200
    34.554     1.845     0.200
    36.174     1.112     0.200
    37.056     1.796     0.200
    38.001     1.395     0.200
    39.157     2.090     0.200
    39.941     3.161     0.200
    44.509     1.946     0.200
    45.520     0.911     0.200
    45.520     1.212     0.200
    46.923     1.075     0.200
    48.225     0.763     0.200
    50.564     1.910     0.200
    50.564     2.410     0.200
    53.336     1.459     0.200
    56.394     1.135     0.200
    58.936     1.258     0.200
    61.044     1.789     0.200
    61.966     0.568     0.200
    61.966     0.670     0.200
    62.335     2.092     0.200
    62.335     1.490     0.200
    64.739     1.015     0.200
    64.847     1.008     0.200
    65.446     1.824     0.200
    66.323     1.680     0.200
    66.638     1.964     0.200
    66.582     1.324     0.200
    66.582     1.722     0.200
    66.816     1.831     0.200
    67.507     0.844     0.200
    67.903     1.550     0.200
    68.575     1.739     0.200
    69.793     1.190     0.200
    69.793     1.389     0.200
    69.892     1.782     0.200
    71.372     1.565     0.200
    71.372     1.764     0.200
    72.212     2.517     0.200
    72.721     2.382     0.200
    72.817     2.311     0.200
    72.952     2.615     0.200
    73.007     2.287     0.200
    73.162     2.872     0.200
    73.171     3.120     0.200
    74.066     0.562     0.200
    74.066     1.362     0.200
    74.274     5.350     0.200
    74.602     2.041     0.200
    74.817     3.199     0.200
    74.773     3.453     0.200
    74.773     3.953     0.200
    74.837     3.084     0.200
    74.848     0.515     0.200
    75.249     2.407     0.200
    75.353     2.504     0.200
    75.398     2.348     0.200
    75.409     2.486     0.200
    75.411     1.876     0.200
    75.494     2.398     0.200
    75.588     2.059     0.200
    75.609     2.239     0.200
    75.612     2.319     0.200
    75.639     2.166     0.200
    75.848     2.377     0.200
    75.884     1.964     0.200
    75.886     2.559     0.200
    76.110     2.781     0.200
    76.199     2.378     0.200
    76.219     2.557     0.200
    76.214     2.691     0.200
    76.307     1.659     0.200
    76.525     2.326     0.200
    76.724     2.301     0.200
    76.732     3.257     0.200
    77.128     3.029     0.200
    77.184     3.715     0.200
    77.496     1.964     0.200
    77.496     2.163     0.200
    78.043     2.919     0.200
    78.532     3.213     0.200
    78.529     2.230     0.200
    79.193     2.586     0.200
    79.193     3.187     0.200
    79.367     1.635     0.200
    79.367     2.334     0.200
    79.483     2.801     0.200
    79.639     2.157     0.200
    80.059    -1.119     0.200
    80.453     1.861     0.200
    80.509     2.760     0.200
    80.761     4.107     0.200
    80.808     4.253     0.200
    81.010     3.177     0.200
    81.123     3.175     0.200
    82.365     4.632     0.200
    82.416     1.865     0.200
    82.535     1.746     0.200
    82.929     2.695     0.200
    83.131     1.652     0.200
    83.094     2.241     0.200
    85.441     2.430     0.200
    85.760     2.341     0.200
    86.086     1.929     0.200
    86.335     0.803     0.200
    15.133     6.794     0.200
    16.383     4.096     0.200
    16.953     2.219     0.200
    17.228     2.258     0.200
    18.539     2.509     0.200
    21.153     3.942     0.200
    21.651     2.312     0.200
    23.786     1.606     0.200
    25.694     2.361     0.200
    27.009     2.347     0.200
    27.009     3.526     0.200
    29.013     2.659     0.200
    31.664     2.310     0.200
    36.747     4.065     0.200
    16.615     4.196     0.200
    16.955     2.811     0.200
    19.519    -0.582     0.200
    22.783     0.211     0.200
    23.096     2.076     0.200
    24.406     1.724     0.200
    25.744     2.482     0.200
    25.744     2.862     0.200
    27.741     2.219     0.200
    28.632     0.988     0.200
    36.114     1.794     0.200
    14.493     5.123     0.200
    14.510     9.457     0.200
    14.566     4.663     0.200
    14.603     4.567     0.200
    14.916     4.939     0.200
    15.491     3.290     0.200
    15.768     2.248     0.200
    16.004     3.703     0.200
    16.257     3.087     0.200
    17.417     3.951     0.200
    17.662     2.448     0.200
    17.653     3.070     0.200
    19.469    -1.857     0.200
    20.765    -1.482     0.200
    21.638     0.920     0.200
    21.865     3.236     0.200
    22.800    -3.182     0.200
    24.909     1.598     0.200
    26.408     2.123     0.200
    26.408     2.443     0.200
    27.487     1.148     0.200
    27.743     1.467     0.200
    28.168     1.831     0.200
    28.930     0.692     0.200
    29.846     1.387     0.200
    30.521     1.294     0.200
    30.783     1.583     0.200
    31.325     0.293     0.200
    31.334     0.513     0.200
    33.446     2.380     0.200
    34.694     1.390     0.200
    35.266     0.610     0.200
    64.611     1.199     0.200
    67.195     0.094     0.200
    75.829     1.476     0.200
    76.391     5.579     0.200
    76.638     6.487     0.200
    77.645     1.282     0.200
    83.084     1.434     0.200
    16.145     5.187     0.200
    16.087     4.315     0.200
    16.559     4.658     0.200
    17.219     4.012     0.200
    17.728     2.446     0.200
    18.146     3.732     0.200
    18.355     1.472     0.200
    19.357     1.306     0.200
    20.582    -0.560     0.200
    20.582    -0.211     0.200
    21.164     2.949     0.200
    21.262     4.622     0.200
    21.531     2.681     0.200
    21.600     2.611     0.200
    21.776     1.039     0.200
    21.725     3.302     0.200
    24.067     2.657     0.200
    24.396     2.770     0.200
    24.433     2.722     0.200
    25.778     2.392     0.200
    27.064     2.584     0.200
    27.064     3.087     0.200
    65.250     0.835     0.200
    67.712     0.615     0.200
    80.864     0.036     0.200
    82.273     4.811     0.200
    15.189     4.725     0.200
    15.523     5.466     0.200
    16.137     2.345     0.200
    16.100     3.718     0.200
    16.573     2.806     0.200
    17.077     3.145     0.200
    17.313     4.379     0.200
    17.746     4.317     0.200
    18.164     4.091     0.200
    21.554     3.316     0.200
    21.788     0.847     0.200
    21.788     0.425     0.200
    24.415     3.034     0.200
    25.795     2.670     0.200
    26.619     3.771     0.200
    64.532     4.621     0.200
    64.754     1.154     0.200
    67.408     2.097     0.200
    76.190     2.824     0.200
    82.262     3.152     0.200
    93.366     3.911     0.200
    17.145     1.893     0.200
    20.148     0.479     0.200
    25.631     2.899     0.200
    20.326    -1.195     0.200
    27.033     2.505     0.200
    16.307     4.611     0.200
    17.332     3.786     0.200
    17.372     3.787     0.200
    17.412     3.658     0.200
    17.425     3.839     0.200
    17.444     3.867     0.200
    17.444     3.969     0.200
    17.593     3.729     0.200
    17.613     3.636     0.200
    17.640     3.616     0.200
    17.640     3.960     0.200
    17.647     3.711     0.200
    17.700     3.934     0.200
    17.949     3.849     0.200
    18.098     3.972     0.200
    18.209     3.622     0.200
    18.209     3.169     0.200
    18.311     4.433     0.200
    18.411     2.319     0.200
    18.587     2.741     0.200
    18.700     2.424     0.200
    18.700     1.534     0.200
    18.654     0.959     0.200
    18.654     2.295     0.200
    18.654     2.302     0.200
    18.844     2.782     0.200
    18.844     2.289     0.200
    18.808     2.451     0.200
    18.842     1.789     0.200
    18.879     3.132     0.200
    19.016     3.321     0.200
    19.016     2.251     0.200
    19.151     3.441     0.200
    19.151     3.128     0.200
    19.168     2.620     0.200
    19.191     2.099     0.200
    19.255     2.163     0.200
    19.255     1.983     0.200
    19.255     1.874     0.200
    19.261     2.704     0.200
    19.376    -1.505     0.200
    19.370     3.223     0.200
    19.455     3.316     0.200
    19.455     3.004     0.200
    19.482    -1.702     0.200
    19.473     1.306     0.200
    19.522     3.806     0.200
    19.556    -1.428     0.200
    19.552     1.375     0.200
    19.552     1.234     0.200
    19.513     2.153     0.200
    19.583     2.854     0.200
    19.703    -1.758     0.200
    19.747    -1.268     0.200
    19.748    -1.586     0.200
    19.831    -1.115     0.200
    19.819     2.525     0.200
    20.006    -1.817     0.200
    20.009    -1.090     0.200
    19.982     3.044     0.200
    20.102    -1.522     0.200
    20.128    -1.007     0.200
    20.136    -1.661     0.200
    20.140    -0.750     0.200
    20.140    -1.493     0.200
    20.140    -2.211     0.200
    20.255    -1.731     0.200
    20.271    -2.486     0.200
    20.279    -0.467     0.200
    20.328     2.612     0.200
    20.328     2.167     0.200
    20.461    -1.235     0.200
    20.473    -0.264     0.200
    20.479    -1.676     0.200
    20.461     3.508     0.200
    20.501     3.552     0.200
    20.501     2.935     0.200
    20.562    -1.532     0.200
    20.562    -2.008     0.200
    20.710    -2.085     0.200
    20.745    -1.783     0.200
    20.764    -2.115     0.200
    20.777    -0.319     0.200
    20.798    -1.042     0.200
    20.785     1.916     0.200
    20.792     2.078     0.200
    20.897    -1.690     0.200
    20.979    -0.995     0.200
    20.960     1.114     0.200
    20.960     3.192     0.200
    20.960     2.762     0.200
    20.995    -1.884     0.200
    21.016    -0.799     0.200
    20.995     3.677     0.200
    20.995     3.185     0.200
    21.035    -2.067     0.200
    21.022     2.957     0.200
    21.062     2.802     0.200
    21.178    -1.757     0.200
    21.179    -0.951     0.200
    21.266    -0.471     0.200
    21.295    -2.685     0.200
    21.292     2.473     0.200
    21.336    -2.066     0.200
    21.353    -2.242     0.200
    21.355     0.302     0.200
    21.355    -0.308     0.200
    21.355     3.096     0.200
    21.404    -1.142     0.200
    21.391     4.058     0.200
    21.391     3.277     0.200
    21.369     3.434     0.200
    21.369     2.887     0.200
    21.483     3.234     0.200
    21.536    -1.894     0.200
    21.562     0.710     0.200
    21.612    -2.063     0.200
    21.614    -0.697     0.200
    21.660    -0.869     0.200
    21.660    -1.127     0.200
    21.683    -0.910     0.200
    21.726    -1.589     0.200
    21.774     0.651     0.200
    21.774     0.237     0.200
    21.816    -1.223     0.200
    21.922    -2.434     0.200
    21.922    -0.376     0.200
    21.943    -2.139     0.200
    21.948    -0.024     0.200
    21.958    -0.076     0.200
    22.020    -2.041     0.200
    22.021    -1.170     0.200
    22.080    -1.716     0.200
    22.151    -1.235     0.200
    22.192     3.414     0.200
    22.192     3.219     0.200
    22.287    -1.215     0.200
    22.305     0.226     0.200
    22.248     3.571     0.200
    22.348     0.271     0.200
    22.422    -1.254     0.200
    22.444    -1.302     0.200
    22.472    -0.911     0.200
    22.456     3.060     0.200
    22.581    -1.932     0.200
    22.577     0.575     0.200
    22.626    -1.981     0.200
    22.637    -0.582     0.200
    22.662    -1.908     0.200
    22.672    -1.421     0.200
    22.736    -0.153     0.200
    22.740    -0.875     0.200
    22.781    -1.062     0.200
    22.834    -1.253     0.200
    22.853     0.399     0.200
    22.919    -0.944     0.200
    23.018    -0.433     0.200
    23.061    -0.759     0.200
    23.092    -1.785     0.200
    23.105    -0.491     0.200
    23.110    -1.738     0.200
    23.134     0.407     0.200
    23.165    -2.148     0.200
    23.236    -1.326     0.200
    23.321    -1.569     0.200
    23.323    -1.260     0.200
    23.329     0.068     0.200
    23.363     0.972     0.200
    23.387    -1.826     0.200
    23.446    -0.184     0.200
    23.469    -1.485     0.200
    23.473    -1.671     0.200
    23.473    -2.257     0.200
    23.541    -0.601     0.200
    23.541    -1.460     0.200
    23.566    -0.468     0.200
    23.632     1.524     0.200
    23.639    -0.982     0.200
    23.657     2.380     0.200
    23.657     1.778     0.200
    23.675     1.157     0.200
    23.683    -1.245     0.200
    23.681    -0.095     0.200
    23.720     0.186     0.200
    23.700     2.276     0.200
    23.700     1.658     0.200
    23.820     0.790     0.200
    23.807     2.669     0.200
    23.799     2.542     0.200
    23.845    -0.386     0.200
    23.856    -1.030     0.200
    23.872     0.755     0.200
    23.893     0.228     0.200
    23.914     0.409     0.200
    23.920     2.053     0.200
    24.026     1.780     0.200
    24.026     1.428     0.200
    24.036     0.270     0.200
    24.059     2.865     0.200
    24.059     2.451     0.200
    24.097     0.103     0.200
    24.094     1.749     0.200
    24.140     0.959     0.200
    24.158     1.594     0.200
    24.181    -0.188     0.200
    24.187    -1.282     0.200
    24.219     2.113     0.200
    24.264     0.939     0.200
    24.153     2.763     0.200
    24.327     0.019     0.200
    24.389    -1.256     0.200
    24.380     0.346     0.200
    24.392     3.411     0.200
    24.423     1.622     0.200
    24.501     1.502     0.200
    24.511    -0.189     0.200
    24.530     1.487     0.200
    24.546     0.319     0.200
    24.544     1.786     0.200
    24.582    -0.743     0.200
    24.583     0.033     0.200
    24.610     1.166     0.200
    24.627     1.553     0.200
    24.641     0.602     0.200
    24.655     1.302     0.200
    24.658     1.495     0.200
    24.608     2.425     0.200
    24.721     1.188     0.200
    24.748     1.063     0.200
    24.741     1.824     0.200
    24.774     1.531     0.200
    24.837     1.735     0.200
    24.865     0.862     0.200
    24.844     3.185     0.200
    24.919     1.970     0.200
    24.934     1.248     0.200
    24.975     2.092     0.200
    25.010     1.597     0.200
    25.028    -0.411     0.200
    25.041     1.160     0.200
    25.052     2.125     0.200
    25.181     2.287     0.200
    25.195     1.767     0.200
    25.208     1.210     0.200
    25.222     0.504     0.200
    25.269     2.011     0.200
    25.354     1.420     0.200
    25.409     1.501     0.200
    25.406     1.943     0.200
    25.458     2.354     0.200
    25.458     1.823     0.200
    25.469     1.693     0.200
    25.484     1.835     0.200
    25.510     1.713     0.200
    25.530     2.072     0.200
    25.523     1.452     0.200
    25.612     1.674     0.200
    25.616     2.131     0.200
    25.616     1.998     0.200
    25.645     1.503     0.200
    25.700     1.682     0.200
    25.701     1.730     0.200
    25.701     1.606     0.200
    25.711     1.403     0.200
    25.756     0.541     0.200
    25.837     1.397     0.200
    25.867     0.371     0.200
    25.846     0.609     0.200
    25.907     1.600     0.200
    25.927     1.681     0.200
    25.946     1.729     0.200
    25.945     2.175     0.200
    25.945     2.047     0.200
    26.000     1.524     0.200
    26.016     1.783     0.200
    26.078     1.784     0.200
    26.134     1.483     0.200
    26.184     1.455     0.200
    26.222     1.824     0.200
    26.116     3.619     0.200
    26.217     0.366     0.200
    26.279     1.716     0.200
    26.275     1.853     0.200
    26.278     1.607     0.200
    26.288     1.666     0.200
    26.295     1.821     0.200
    26.326     1.728     0.200
    26.381     1.504     0.200
    26.413     1.460     0.200
    26.460     1.579     0.200
    26.460     1.454     0.200
    26.481     1.758     0.200
    26.493     1.861     0.200
    26.493     1.165     0.200
    26.487     1.352     0.200
    26.505     1.762     0.200
    26.598     1.921     0.200
    26.611     0.668     0.200
    26.607     1.770     0.200
    26.529     2.945     0.200
    26.711     1.558     0.200
    26.726     1.377     0.200
    26.723     2.086     0.200
    26.730     2.067     0.200
    26.759     1.192     0.200
    26.774     1.790     0.200
    26.836     2.651     0.200
    26.860     1.685     0.200
    26.836     2.762     0.200
    26.915     1.709     0.200
    26.926     1.300     0.200
    26.943     1.373     0.200
    26.991     1.230     0.200
    27.034     2.004     0.200
    27.034     1.995     0.200
    27.074     2.205     0.200
    27.152     1.730     0.200
    27.174     0.270     0.200
    27.199     1.354     0.200
    27.219     2.283     0.200
    27.266     1.037     0.200
    27.272     1.636     0.200
    27.309     1.797     0.200
    27.333     1.648     0.200
    27.330     1.585     0.200
    27.347     1.767     0.200
    27.385     1.681     0.200
    27.413     1.538     0.200
    27.522     1.097     0.200
    27.531     2.290     0.200
    27.558     1.576     0.200
    27.620     2.448     0.200
    27.631     1.570     0.200
    27.639     1.605     0.200
    27.778     1.504     0.200
    27.786     1.374     0.200
    27.780     1.422     0.200
    27.828     2.490     0.200
    27.834     1.006     0.200
    27.750     3.202     0.200
    27.877     1.899     0.200
    27.877     1.980     0.200
    27.879     2.632     0.200
    27.878     3.165     0.200
    27.900     2.539     0.200
    27.956     1.525     0.200
    27.978     1.509     0.200
    28.012     0.826     0.200
    28.033     1.766     0.200
    28.052     1.580     0.200
    28.084     1.539     0.200
    28.165     0.951     0.200
    28.184     1.384     0.200
    28.203     2.077     0.200
    28.221     1.108     0.200
    28.216     1.227     0.200
    28.291     1.714     0.200
    28.324     0.866     0.200
    28.380     1.348     0.200
    28.381     1.675     0.200
    28.416     1.623     0.200
    28.415     1.697     0.200
    28.447     2.147     0.200
    28.457     2.097     0.200
    28.516     0.653     0.200
    28.478     2.992     0.200
    28.558     1.768     0.200
    28.584     1.275     0.200
    28.651     1.417     0.200
    28.651     2.176     0.200
    28.734     1.395     0.200
    28.720     1.840     0.200
    28.715     1.499     0.200
    28.719     1.691     0.200
    28.756     2.494     0.200
    28.756     1.900     0.200
    28.761     0.471     0.200
    28.755     2.125     0.200
    28.757     2.281     0.200
    28.781     1.084     0.200
    28.782     1.448     0.200
    28.782     0.776     0.200
    28.782     1.573     0.200
    28.782    -0.239     0.200
    28.841     2.439     0.200
    28.849     1.596     0.200
    28.970     1.579     0.200
    28.980     1.278     0.200
    28.998     1.857     0.200
    29.021     1.382     0.200
    29.070     2.579     0.200
    29.041     1.415     0.200
    29.061     1.219     0.200
    29.080     0.893     0.200
    29.079     1.123     0.200
    29.094     0.889     0.200
    29.111     2.456     0.200
    29.108     1.431     0.200
    29.146     2.136     0.200
    29.179     1.892     0.200
    29.246     0.554     0.200
    29.256     1.722     0.200
    29.258     2.373     0.200
    29.293     2.019     0.200
    29.321     1.060     0.200
    29.337     0.283     0.200
    29.347     0.925     0.200
    29.375     1.794     0.200
    29.451     1.954     0.200
    29.461     1.574     0.200
    29.482     1.836     0.200
    29.482     1.477     0.200
    29.518     2.426     0.200
    29.553     1.217     0.200
    29.554     2.758     0.200
    29.463     2.197     0.200
    29.572     1.479     0.200
    29.570     1.671     0.200
    29.600     0.607     0.200
    29.593     2.474     0.200
    29.597     2.061     0.200
    29.614     2.153     0.200
    29.620     1.861     0.200
    29.624     1.510     0.200
    29.656     1.463     0.200
    29.693     0.653     0.200
    29.712     1.168     0.200
    29.726     2.830     0.200
    29.795     2.369     0.200
    29.799     2.647     0.200
    29.823     2.258     0.200
    29.841     0.633     0.200
    29.871     0.906     0.200
    29.877     2.268     0.200
    29.903     2.317     0.200
    29.923     2.181     0.200
    29.933     2.347     0.200
    29.943     0.870     0.200
    29.942     2.225     0.200
    29.969     2.283     0.200
    29.979     0.568     0.200
    29.998     1.194     0.200
    30.002     2.374     0.200
    30.025     0.876     0.200
    30.042     3.128     0.200
    30.093     2.547     0.200
    30.206     1.705     0.200
    30.246     2.742     0.200
    30.265     0.311     0.200
    30.258     0.995     0.200
    30.250     3.081     0.200
    30.276     3.419     0.200
    30.294     1.185     0.200
    30.293     2.647     0.200
    30.337     2.832     0.200
    30.331     3.012     0.200
    30.345     2.435     0.200
    30.368     2.531     0.200
    30.377     1.180     0.200
    30.416     1.416     0.200
    30.425     1.002     0.200
    30.460     2.245     0.200
    30.475     2.975     0.200
    30.498     1.668     0.200
    30.498     1.121     0.200
    30.489     2.853     0.200
    30.503     3.057     0.200
    30.605     1.271     0.200
    30.611     2.507     0.200
    30.624     3.398     0.200
    30.632     2.697     0.200
    30.666     1.286     0.200
    30.674     1.641     0.200
    30.670     3.579     0.200
    30.707     2.114     0.200
    30.720     3.627     0.200
    30.738     1.288     0.200
    30.776     1.801     0.200
    30.759     3.674     0.200
    30.824     2.913     0.200
    30.861     1.632     0.200
    30.869     2.767     0.200
    30.911     1.208     0.200
    30.919     3.633     0.200
    30.935     1.961     0.200
    31.091     2.353     0.200
    31.103     2.306     0.200
    31.128     1.627     0.200
    31.146     2.530     0.200
    31.156     3.487     0.200
    31.168     0.858     0.200
    31.170     3.678     0.200
    31.201     2.076     0.200
    31.242     2.249     0.200
    31.243     3.575     0.200
    31.256     3.924     0.200
    31.287     2.232     0.200
    31.310     2.721     0.200
    31.323     1.737     0.200
    31.303     3.650     0.200
    31.330     2.211     0.200
    31.333     2.763     0.200
    31.395     1.962     0.200
    31.395     1.712     0.200
    31.398     1.227     0.200
    31.398     1.086     0.200
    31.461     1.684     0.200
    31.521     2.943     0.200
    31.553     2.675     0.200
    31.563     3.872     0.200
    31.582     2.040     0.200
    31.602     2.610     0.200
    31.669     3.529     0.200
    31.683     2.772     0.200
    31.712    -1.282     0.200
    31.726     1.725     0.200
    31.721     3.197     0.200
    31.818     0.703     0.200
    31.846     2.693     0.200
    31.862     0.218     0.200
    31.956     2.255     0.200
    31.991     2.715     0.200
    32.065     3.431     0.200
    32.086     3.196     0.200
    32.100     2.657     0.200
    32.136     1.038     0.200
    32.148     1.812     0.200
    32.178     3.235     0.200
    32.211     2.374     0.200
    32.227     2.890     0.200
    32.247     1.188     0.200
    32.317     2.564     0.200
    32.331    -0.787     0.200
    32.331    -1.545     0.200
    32.434     3.240     0.200
    32.443     2.901     0.200
    32.505     2.166     0.200
    32.545     2.231     0.200
    32.586     0.602     0.200
    32.586     0.134     0.200
    32.603     3.175     0.200
    32.600     1.796     0.200
    32.724     2.474     0.200
    32.776     1.383     0.200
    32.786     0.991     0.200
    32.841     2.269     0.200
    32.866     2.276     0.200
    32.880     3.698     0.200
    32.880     3.682     0.200
    33.092     1.314     0.200
    33.108     3.223     0.200
    33.136     2.896     0.200
    33.179     0.411     0.200
    33.178     0.866     0.200
    33.214     2.501     0.200
    33.247     1.788     0.200
    33.199     3.627     0.200
    33.253     0.807     0.200
    33.256     1.394     0.200
    33.232    -0.558     0.200
    33.283     3.649     0.200
    33.302     1.025     0.200
    33.311     1.351     0.200
    33.348     3.193     0.200
    33.381     1.004     0.200
    33.439     1.416     0.200
    33.431     2.488     0.200
    33.512     2.651     0.200
    33.600     0.491     0.200
    33.605     1.220     0.200
    33.674     0.922     0.200
    33.750     1.383     0.200
    33.738     3.745     0.200
    33.764     0.999     0.200
    33.793     1.093     0.200
    33.793     0.851     0.200
    33.762     2.029     0.200
    33.827     1.037     0.200
    33.879     0.997     0.200
    33.905     2.765     0.200
    33.924     1.100     0.200
    33.947     0.746     0.200
    33.982     1.718     0.200
    33.996     2.806     0.200
    34.032     2.102     0.200
    34.076     2.818     0.200
    34.091     3.037     0.200
    34.309     0.555     0.200
    34.305     1.096     0.200
    34.305     0.815     0.200
    34.337     1.398     0.200
    34.342     2.730     0.200
    34.388     2.402     0.200
    34.471     3.982     0.200
    34.525     2.823     0.200
    34.599     0.916     0.200
    34.743     2.804     0.200
    34.890     1.059     0.200
    34.934     0.910     0.200
    35.088     2.318     0.200
    35.112     0.860     0.200
    35.344     0.680     0.200
    35.364     0.249     0.200
    35.570     0.398     0.200
    35.577     1.255     0.200
    35.810     0.331     0.200
    35.846     1.177     0.200
    35.897     1.305     0.200
    35.897     1.055     0.200
    36.096     0.690     0.200
    36.106    -0.186     0.200
    36.203     1.402     0.200
    36.203     0.887     0.200
    36.190     3.702     0.200
    36.271     0.002     0.200
    36.192     2.074     0.200
    36.192     1.160     0.200
    36.441     1.571     0.200
    36.441     1.673     0.200
    36.441     0.470     0.200
    36.596     0.605     0.200
    36.693     0.423     0.200
    36.698     0.400     0.200
    36.728     0.155     0.200
    36.749     0.419     0.200
    36.778     1.483     0.200
    36.778     1.241     0.200
    36.750     3.525     0.200
    36.959     0.926     0.200
    36.963     1.197     0.200
    36.974     0.425     0.200
    36.974     0.613     0.200
    36.871     3.590     0.200
    37.006     1.438     0.200
    37.019     0.468     0.200
    37.045     1.091     0.200
    36.897     2.664     0.200
    37.099     0.969     0.200
    37.204     1.318     0.200
    37.091     4.116     0.200
    37.091     3.686     0.200
    37.096     3.373     0.200
    37.257     1.593     0.200
    37.266     0.540     0.200
    37.321     0.171     0.200
    37.249     3.460     0.200
    37.435     0.904     0.200
    37.459     1.140     0.200
    37.430     3.035     0.200
    37.499     0.238     0.200
    37.421     2.707     0.200
    37.459     3.779     0.200
    37.527     3.266     0.200
    37.758     1.173     0.200
    37.758     0.322     0.200
    37.835    -0.123     0.200
    37.892     0.833     0.200
    37.975     1.458     0.200
    38.029    -0.208     0.200
    38.113     0.433     0.200
    38.216     0.984     0.200
    38.226     0.628     0.200
    38.332     1.126     0.200
    38.362     1.052     0.200
    38.389     1.396     0.200
    38.453     1.655     0.200
    38.509     0.743     0.200
    38.620     0.822     0.200
    38.717     0.649     0.200
    38.721     0.860     0.200
    38.776     0.033     0.200
    38.818     0.930     0.200
    38.843     1.399     0.200
    39.242     2.674     0.200
    39.707     1.189     0.200
    40.029     0.945     0.200
    40.218     1.560     0.200
    40.218     0.865     0.200
    40.732     1.057     0.200
    40.886     2.847     0.200
    40.916     1.781     0.200
    40.916     2.906     0.200
    40.916     1.289     0.200
    41.130     0.563     0.200
    41.130     1.235     0.200
    41.444     2.008     0.200
    41.831     0.783     0.200
    42.446     2.184     0.200
    42.446     1.411     0.200
    43.187     0.800     0.200
    43.535     2.954     0.200
    43.521     2.234     0.200
    43.736     2.349     0.200
    43.897     1.474     0.200
    43.897     0.935     0.200
    44.707     2.076     0.200
    44.707     1.850     0.200
    44.978     2.113     0.200
    45.183     1.955     0.200
    45.183     1.471     0.200
    45.183     2.463     0.200
    47.202    -0.200     0.200
    47.210     2.849     0.200
    47.981     2.947     0.200
    48.101     1.324     0.200
    48.101     0.652     0.200
    48.781     0.563     0.200
    49.687     2.380     0.200
    50.380     2.128     0.200
    50.425     2.572     0.200
    50.610     1.701     0.200
    50.667     2.926     0.200
    50.790     1.238     0.200
    50.790     1.239     0.200
    50.793     1.192     0.200
    50.793     1.064     0.200
    50.794     1.136     0.200
    50.794     1.019     0.200
    50.794     1.101     0.200
    50.796     1.111     0.200
    50.796     0.971     0.200
    50.798     0.969     0.200
    50.939     2.540     0.200
    51.725     1.988     0.200
    51.725     2.691     0.200
    51.976     1.394     0.200
    52.245     1.434     0.200
    52.353    -0.059     0.200
    52.620     2.037     0.200
    53.051     1.775     0.200
    53.137     1.257     0.200
    53.237     2.424     0.200
    53.327     1.221     0.200
    53.327     1.901     0.200
    53.722     1.493     0.200
    53.776     2.852     0.200
    53.894     1.668     0.200
    54.344     1.542     0.200
    54.831     3.247     0.200
    54.983     1.452     0.200
    56.596     1.748     0.200
    56.587     0.749     0.200
    56.587     1.820     0.200
    56.795     0.526     0.200
    56.697     1.170     0.200
    56.939     1.292     0.200
    57.399     1.920     0.200
    57.649     1.243     0.200
    57.649     0.414     0.200
    57.720     0.783     0.200
    57.820     0.697     0.200
    57.996     1.376     0.200
    58.245     0.820     0.200
    58.271     1.722     0.200
    58.459     0.288     0.200
    58.467     2.550     0.200
    58.565     1.431     0.200
    58.738     1.830     0.200
    58.790     1.504     0.200
    58.804     0.445     0.200
    58.870     1.515     0.200
    58.881     1.375     0.200
    59.068     2.352     0.200
    59.087     3.598     0.200
    59.194     1.409     0.200
    59.282     1.487     0.200
    59.396     1.839     0.200
    59.512     2.658     0.200
    59.680     0.455     0.200
    59.674     1.244     0.200
    59.607     0.405     0.200
    59.692     0.315     0.200
    59.723    -0.348     0.200
    59.723     0.558     0.200
    59.723     0.987     0.200
    59.723    -0.309     0.200
    59.885     0.914     0.200
    59.922     1.000     0.200
    60.147     0.246     0.200
    60.373     0.234     0.200
    60.553     1.548     0.200
    60.680     1.660     0.200
    60.720     1.776     0.200
    61.023     2.602     0.200
    61.023     2.344     0.200
    61.095     1.189     0.200
    61.358     0.901     0.200
    61.689     2.065     0.200
    61.777     1.470     0.200
    61.812     1.833     0.200
    61.828     0.877     0.200
    61.883     3.030     0.200
    61.912     1.702     0.200
    61.929     0.303     0.200
    62.084     0.840     0.200
    62.082     2.263     0.200
    62.116     1.469     0.200
    62.116     1.538     0.200
    62.259     0.585     0.200
    62.259     0.241     0.200
    62.414     0.953     0.200
    62.422     0.155     0.200
    62.440     2.697     0.200
    62.498     1.408     0.200
    62.699     1.537     0.200
    62.745     2.935     0.200
    62.758     2.044     0.200
    62.781     0.991     0.200
    62.802     1.505     0.200
    62.796     3.796     0.200
    62.796     2.593     0.200
    62.796     3.421     0.200
    62.955     2.436     0.200
    62.958     1.931     0.200
    63.211     0.666     0.200
    63.218     1.239     0.200
    63.291     0.759     0.200
    63.328     1.325     0.200
    63.336     5.422     0.200
    63.361     1.065     0.200
    63.361     0.752     0.200
    63.396     1.438     0.200
    63.396     1.336     0.200
    63.572     1.003     0.200
    63.569     0.973     0.200
    63.576     1.101     0.200
    63.616     1.540     0.200
    63.821     0.961     0.200
    63.917     2.542     0.200
    63.936     1.456     0.200
    64.009     3.066     0.200
    64.057     1.544     0.200
    64.070     1.926     0.200
    64.255     0.660     0.200
    64.250     3.720     0.200
    64.380     0.433     0.200
    64.572     1.819     0.200
    64.609     0.591     0.200
    64.646     1.595     0.200
    64.729     1.071     0.200
    64.801     2.535     0.200
    64.822     0.895     0.200
    64.831     0.712     0.200
    64.864     1.200     0.200
    64.867     0.622     0.200
    64.973     0.469     0.200
    64.973     0.313     0.200
    64.959     1.062     0.200
    64.959     1.366     0.200
    64.959     1.140     0.200
    64.878     1.892     0.200
    64.969     0.849     0.200
    65.011     1.437     0.200
    65.054     1.389     0.200
    64.992     1.649     0.200
    64.992     1.298     0.200
    65.174     0.877     0.200
    65.174     1.734     0.200
    65.304     1.659     0.200
    65.304     0.230     0.200
    65.370     1.060     0.200
    65.388     2.100     0.200
    65.416     1.402     0.200
    65.656     0.110     0.200
    65.643     2.233     0.200
    65.791     1.586     0.200
    65.789     1.859     0.200
    65.789     1.741     0.200
    65.813     1.847     0.200
    65.831     0.719     0.200
    66.037     2.005     0.200
    66.037     1.654     0.200
    66.037     1.495     0.200
    66.037     1.643     0.200
    66.037     1.588     0.200
    66.213     0.961     0.200
    66.250    -0.192     0.200
    66.182     0.964     0.200
    66.264     1.539     0.200
    66.308     1.916     0.200
    66.469     2.819     0.200
    66.584     2.186     0.200
    66.744     1.237     0.200
    66.835     1.485     0.200
    66.913     1.294     0.200
    66.913     0.271     0.200
    66.826     3.147     0.200
    67.307     2.587     0.200
    67.466     0.833     0.200
    67.466     1.182     0.200
    67.487     1.131     0.200
    67.509     2.233     0.200
    67.619     1.216     0.200
    67.562     1.458     0.200
    67.635     1.322     0.200
    68.035     0.870     0.200
    68.408     1.215     0.200
    68.408     1.356     0.200
    68.418     0.724     0.200
    68.475     1.739     0.200
    68.616     0.807     0.200
    68.780     2.112     0.200
    68.852     1.801     0.200
    68.897     1.647     0.200
    68.934     3.478     0.200
    69.079     0.875     0.200
    69.111     2.153     0.200
    69.347     1.265     0.200
    69.479     2.999     0.200
    69.613     1.930     0.200
    69.605     1.030     0.200
    69.548     1.602     0.200
    69.548     1.273     0.200
    69.568     3.350     0.200
    69.687     2.522     0.200
    69.638     3.120     0.200
    69.671     2.916     0.200
    69.744     0.768     0.200
    69.889     2.282     0.200
    69.796     1.695     0.200
    70.012     2.116     0.200
    70.023     2.053     0.200
    70.271     2.231     0.200
    70.412     0.668     0.200
    70.427     1.575     0.200
    70.427     2.216     0.200
    70.427     3.278     0.200
    71.063     1.011     0.200
    71.147     1.799     0.200
    71.071     1.148     0.200
    71.102     2.376     0.200
    71.102     1.922     0.200
    71.102     2.376     0.200
    71.261     1.432     0.200
    71.309     1.320     0.200
    71.307     3.134     0.200
    71.345    -0.500     0.200
    71.695     1.391     0.200
    71.712     1.149     0.200
    71.649     2.072     0.200
    71.733     1.223     0.200
    72.173     1.827     0.200
    72.172     1.525     0.200
    72.376     2.045     0.200
    72.415     2.074     0.200
    72.415     1.590     0.200
    72.415     2.887     0.200
    72.485     1.245     0.200
    72.533     1.777     0.200
    72.497     2.689     0.200
    72.581     1.546     0.200
    72.630     1.830     0.200
    72.643     1.554     0.200
    72.699     1.689     0.200
    72.673     2.064     0.200
    72.669     2.111     0.200
    72.920     2.098     0.200
    73.070     2.064     0.200
    73.072     0.979     0.200
    73.212     2.651     0.200
    73.392     1.940     0.200
    73.510     1.551     0.200
    73.510     1.895     0.200
    73.581     0.837     0.200
    73.581     1.102     0.200
    73.821     1.467     0.200
    73.971     1.689     0.200
    73.999     1.307     0.200
    74.095     1.862     0.200
    74.095     1.151     0.200
    74.304     1.646     0.200
    74.271     1.938     0.200
    74.387     1.166     0.200
    74.419     0.776     0.200
    74.461     1.033     0.200
    74.492     1.451     0.200
    74.706     1.913     0.200
    74.732     2.867     0.200
    74.743     2.064     0.200
    74.771     3.083     0.200
    74.909     1.635     0.200
    74.997     0.928     0.200
    74.946     2.026     0.200
    75.046     0.448     0.200
    74.967     1.805     0.200
    75.044     1.860     0.200
    75.106     1.704     0.200
    75.099     1.743     0.200
    75.220     1.742     0.200
    75.225     1.817     0.200
    75.349     1.602     0.200
    75.373     1.861     0.200
    75.388     2.591     0.200
    75.410     1.854     0.200
    75.541     2.272     0.200
    75.593     1.502     0.200
    75.600     3.364     0.200
    75.614     1.880     0.200
    75.604     2.137     0.200
    75.623     1.633     0.200
    75.708     2.144     0.200
    75.748     2.315     0.200
    75.815     2.637     0.200
    75.846     2.754     0.200
    75.855     2.001     0.200
    75.842     2.380     0.200
    75.847     1.954     0.200
    75.892     0.991     0.200
    76.005     1.647     0.200
    76.005     0.248     0.200
    76.012     2.103     0.200
    76.022     4.353     0.200
    76.175     1.779     0.200
    76.217     2.143     0.200
    76.222     2.116     0.200
    76.222     1.264     0.200
    76.261     2.093     0.200
    76.309     1.621     0.200
    76.346     3.411     0.200
    76.378     1.528     0.200
    76.370     2.070     0.200
    76.370     2.672     0.200
    76.474     3.286     0.200
    76.488     2.106     0.200
    76.515     1.155     0.200
    76.515     1.952     0.200
    76.523     1.010     0.200
    76.564     2.576     0.200
    76.599     2.078     0.200
    76.593     2.307     0.200
    76.601     2.967     0.200
    76.594     2.504     0.200
    76.631     1.544     0.200
    76.685     2.197     0.200
    76.685     0.994     0.200
    76.769     2.314     0.200
    76.769     0.314     0.200
    76.770     1.037     0.200
    76.784     2.933     0.200
    76.779     1.661     0.200
    76.810     1.685     0.200
    76.823     1.672     0.200
    76.823     0.813     0.200
    76.861     1.398     0.200
    76.873     2.327     0.200
    76.882     1.383     0.200
    77.108     2.216     0.200
    77.130     2.685     0.200
    77.135     4.455     0.200
    77.182     1.898     0.200
    77.226     1.445     0.200
    77.223     2.262     0.200
    77.272     2.890     0.200
    77.283     3.046     0.200
    77.305     1.607     0.200
    77.238     1.176     0.200
    77.322     2.611     0.200
    77.345     2.780     0.200
    77.342     2.844     0.200
    77.385     2.159     0.200
    77.406     1.435     0.200
    77.497     3.029     0.200
    77.577     2.081     0.200
    77.541     2.388     0.200
    77.688     2.703     0.200
    77.710     2.035     0.200
    77.720     1.082     0.200
    77.740     2.675     0.200
    77.769     1.581     0.200
    77.769     1.706     0.200
    77.773     1.789     0.200
    77.782     0.942     0.200
    77.821     3.419     0.200
    77.861     0.536     0.200
    77.909     2.336     0.200
    77.879     0.195     0.200
    77.946     2.280     0.200
    78.000     1.836     0.200
    78.000     1.523     0.200
    78.022     1.709     0.200
    78.014     2.611     0.200
    78.014     2.447     0.200
    78.040     2.303     0.200
    78.034     2.461     0.200
    78.058     1.907     0.200
    78.058     1.743     0.200
    78.053     1.535     0.200
    78.068     2.309     0.200
    78.112     1.403     0.200
    78.139     2.957     0.200
    78.172     2.170     0.200
    78.172     1.748     0.200
    78.178     0.966     0.200
    78.195     2.043     0.200
    78.278     0.711     0.200
    78.278     0.586     0.200
    78.282     0.767     0.200
    78.282     0.533     0.200
    78.290    -0.241     0.200
    78.314     2.092     0.200
    78.356     2.256     0.200
    78.387     2.083     0.200
    78.385     1.698     0.200
    78.441     2.182     0.200
    78.474     2.558     0.200
    78.507     1.744     0.200
    78.572     1.565     0.200
    78.606     2.375     0.200
    78.544     5.911     0.200
    78.667    -0.060     0.200
    78.861     1.616     0.200
    78.899     1.264     0.200
    78.923     2.002     0.200
    78.878     2.479     0.200
    78.991     2.758     0.200
    79.113     0.990     0.200
    79.181     2.619     0.200
    79.190     1.724     0.200
    79.295     1.571     0.200
    79.378     0.338     0.200
    79.409     1.951     0.200
    79.412     2.061     0.200
    79.532     2.002     0.200
    79.512     2.516     0.200
    79.572     0.738     0.200
    79.650     1.406     0.200
    79.733     1.689     0.200
    79.977     1.890     0.200
    80.056     3.160     0.200
    80.423    -0.371     0.200
    80.449     1.248     0.200
    80.480     2.377     0.200
    80.475     1.004     0.200
    80.596     1.457     0.200
    80.714     2.125     0.200
    80.800     2.568     0.200
    80.864     1.322     0.200
    80.864     1.033     0.200
    80.864     1.025     0.200
    80.884     0.769     0.200
    80.928     3.181     0.200
    80.962     1.704     0.200
    80.920     1.428     0.200
    80.988     2.764     0.200
    81.352     2.527     0.200
    81.563     2.013     0.200
    81.564     1.202     0.200
    81.564     0.866     0.200
    81.666     3.062     0.200
    81.777     1.183     0.200
    81.826     1.924     0.200
    82.085     2.562     0.200
    82.175     2.886     0.200
    82.224     1.834     0.200
    82.314     1.962     0.200
    82.309     2.888     0.200
    82.458     3.110     0.200
    82.459     2.205     0.200
    82.493     2.726     0.200
    82.517     2.301     0.200
    82.581     2.173     0.200
    82.523     2.875     0.200
    82.624     2.541     0.200
    82.657     1.777     0.200
    83.129     1.127     0.200
    83.140     1.273     0.200
    83.178     1.472     0.200
    83.310     1.490     0.200
    83.400     1.934     0.200
    83.459     5.424     0.200
    83.515     1.635     0.200
    83.522     2.202     0.200
    83.547     1.268     0.200
    83.554     2.536     0.200
    83.473     2.153     0.200
    83.564     1.558     0.200
    83.564     1.230     0.200
    83.700     1.687     0.200
    83.649     2.550     0.200
    83.719     0.793     0.200
    83.743     1.173     0.200
    83.828     3.327     0.200
    83.942     1.551     0.200
    83.942     2.848     0.200
    83.942     1.551     0.200
    83.950     2.204     0.200
    83.965     1.335     0.200
    83.976     1.478     0.200
    84.011     6.393     0.200
    84.150     1.689     0.200
    84.146     1.708     0.200
    84.199     1.641     0.200
    84.281     3.521     0.200
    84.374     0.552     0.200
    84.461     2.350     0.200
    84.778     1.714     0.200
    84.797     1.720     0.200
    84.797     2.220     0.200
    84.797     1.415     0.200
    84.797     0.618     0.200
    84.730     1.736     0.200
    84.775     1.430     0.200
    84.812     0.862     0.200
    84.868     0.332     0.200
    84.943     1.679     0.200
    84.943     2.156     0.200
    84.943     0.821     0.200
    85.062     1.783     0.200
    85.046     1.013     0.200
    85.152     0.837     0.200
    85.149     0.888     0.200
    85.210     0.692     0.200
    85.252     0.937     0.200
    85.452     2.338     0.200
    85.350     1.550     0.200
    85.392     1.596     0.200
    85.566     2.267     0.200
    85.584     1.990     0.200
    85.512     0.256     0.200
    85.619     0.960     0.200
    85.682     2.191     0.200
    85.808     2.139     0.200
    85.840     2.305     0.200
    85.774     4.440     0.200
    85.870     1.762     0.200
    85.946     2.087     0.200
    86.042     1.306     0.200
    85.958     1.051     0.200
    86.072     1.964     0.200
    86.128     1.984     0.200
    86.062     0.343     0.200
    86.090     1.721     0.200
    86.210     2.582     0.200
    86.284     1.615     0.200
    86.303     1.825     0.200
    86.310     1.887     0.200
    86.421     4.142     0.200
    86.421     1.790     0.200
    86.505     1.729     0.200
    86.532     2.895     0.200
    86.587     0.413     0.200
    86.589     1.922     0.200
    86.593     0.198     0.200
    86.618     1.873     0.200
    86.633     2.002     0.200
    86.633     2.486     0.200
    86.612     6.501     0.200
    86.612     1.603     0.200
    86.655     4.294     0.200
    86.712     2.013     0.200
    86.717     1.690     0.200
    86.769     0.695     0.200
    86.817    -3.298     0.200
    86.836     1.214     0.200
    86.896     2.239     0.200
    86.896     2.036     0.200
    86.876     2.112     0.200
    86.937    -1.384     0.200
    86.907     5.457     0.200
    86.961     4.501     0.200
    87.064     1.796     0.200
    87.119     0.128     0.200
    87.162     2.419     0.200
    87.242     1.636     0.200
    87.354     1.891     0.200
    87.354     1.195     0.200
    87.432    -0.883     0.200
    87.517     4.309     0.200
    87.540     1.695     0.200
    87.603     2.591     0.200
    87.619    -0.183     0.200
    87.705     1.203     0.200
    87.721     4.828     0.200
    87.819     1.464     0.200
    87.841     0.858     0.200
    87.889     0.530     0.200
    87.910     1.534     0.200
    87.946    -0.844     0.200
    87.946     1.656     0.200
    87.932     3.428     0.200
    88.051     2.768     0.200
    88.099     0.535     0.200
    88.117     2.645     0.200
    88.150     1.089     0.200
    88.198     0.566     0.200
    88.129     2.491     0.200
    88.252     3.143     0.200
    88.275     2.395     0.200
    88.306    -0.446     0.200
    88.366     1.232     0.200
    88.448     1.382     0.200
    88.469     0.481     0.200
    88.573    -1.207     0.200
    88.590     0.710     0.200
    88.625     4.843     0.200
    88.629     0.824     0.200
    88.580     2.595     0.200
    88.691    -2.765     0.200
    88.790     5.373     0.200
    88.821    -0.678     0.200
    88.921     3.755     0.200
    89.008     2.943     0.200
    89.001     2.640     0.200
    89.053     1.833     0.200
    89.162     4.522     0.200
    89.227     3.671     0.200
    89.227     4.413     0.200
    89.256     0.684     0.200
    89.314     1.209     0.200
    89.322     3.368     0.200
    89.380     3.438     0.200
    89.394     2.433     0.200
    89.394     3.253     0.200
    89.414     1.741     0.200
    89.418     2.003     0.200
    89.424     3.395     0.200
    89.515     3.470     0.200
    89.574     5.991     0.200
    89.677     2.031     0.200
    89.678     1.959     0.200
    89.915     1.794     0.200
    89.916     1.274     0.200
    90.074     6.951     0.200
    90.289     3.447     0.200
    90.574     3.028     0.200
    90.574     2.863     0.200
    90.574     3.942     0.200
    90.595    -1.373     0.200
    90.595     1.228     0.200
    90.602     2.397     0.200
    90.678     6.542     0.200
    90.961     1.628     0.200
    91.015     1.172     0.200
    91.242    -0.348     0.200
    91.736     4.032     0.200
    91.813     3.780     0.200
    91.843     6.139     0.200
    92.008     0.172     0.200
    92.131     1.285     0.200
    92.368     1.511     0.200
    92.385     0.828     0.200
    92.287     1.587     0.200
    92.287     1.266     0.200
    92.398     0.973     0.200
    92.951     2.342     0.200
    93.031     2.354     0.200
    94.198     3.375     0.200
    94.198     3.679     0.200
    94.265     3.169     0.200
    94.265     1.669     0.200
    95.224     2.084     0.200
    95.249     5.265     0.200
    96.048     3.224     0.200
    96.978     2.023     0.200
    97.563     0.290     0.200
    97.563     1.008     0.200
    97.539     2.296     0.200
    97.538     2.080     0.200
    97.617     1.919     0.200
    97.685     3.464     0.200
    97.751     1.818     0.200
    97.919     2.366     0.200
    97.920     2.361     0.200
    98.082     2.030     0.200
    98.098     2.257     0.200
    98.142     2.659     0.200
    98.324     2.141     0.200
    98.453     2.368     0.200
    20.190    -0.520     0.200
    26.837     4.002     0.200
    41.445     2.889     0.200
    65.017     1.960     0.200
    72.702     1.421     0.200
    73.613     2.447     0.200
    20.122     0.219     0.200
    26.829     4.165     0.200
    26.822     4.101     0.200
    15.981     4.001     0.200
    16.054     4.463     0.200
    16.211     3.126     0.200
    16.170     2.937     0.200
    16.979     4.779     0.200
    17.447     3.026     0.200
    17.518     2.975     0.200
    21.849     1.278     0.200
    24.209     2.305     0.200
    45.695     1.489     0.200
    76.301     1.425     0.200
    78.027     0.896     0.200
    78.133     0.309     0.200
    80.982     1.506     0.200
    82.388     3.032     0.200
    18.609    -2.965     0.200
    20.374    -0.380     0.200
    20.374    -2.630     0.200
    27.140     3.487     0.200
    39.952    -1.838     0.200
    40.253    -1.392     0.200
    14.917     4.372     0.200
    14.938     4.205     0.200
    14.974     3.934     0.200
    16.195     3.609     0.200
    16.815     2.552     0.200
    16.940     2.518     0.200
    16.908     4.069     0.200
    17.018     4.295     0.200
    17.018     2.718     0.200
    17.025     2.703     0.200
    17.166     3.061     0.200
    17.251     2.821     0.200
    17.300     3.529     0.200
    17.700     2.204     0.200
    17.740     3.359     0.200
    17.805     3.426     0.200
    18.056     3.497     0.200
    18.543     1.112     0.200
    18.597     0.894     0.200
    18.597     0.250     0.200
    18.880    -0.218     0.200
    19.023     1.502     0.200
    19.255     1.454     0.200
    19.277    -2.077     0.200
    19.277    -2.657     0.200
    19.386     1.218     0.200
    19.446     0.298     0.200
    19.457     1.455     0.200
    19.587     1.929     0.200
    19.571     2.186     0.200
    19.571     1.621     0.200
    19.971     2.078     0.200
    20.094     1.139     0.200
    20.114     1.928     0.200
    20.187     1.421     0.200
    20.241     0.982     0.200
    20.244     0.392     0.200
    20.244     0.972     0.200
    20.443     1.069     0.200
    20.630     0.264     0.200
    20.709    -1.723     0.200
    20.709    -1.937     0.200
    20.742    -2.723     0.200
    20.744    -2.304     0.200
    20.744    -1.824     0.200
    20.878     0.399     0.200
    21.277     0.791     0.200
    21.277     0.977     0.200
    21.378     4.109     0.200
    21.528     1.967     0.200
    21.618     0.812     0.200
    21.680     0.496     0.200
    21.722    -2.856     0.200
    21.940     3.365     0.200
    21.974    -0.257     0.200
    22.152     0.728     0.200
    22.286    -3.092     0.200
    22.563    -3.386     0.200
    22.580    -2.458     0.200
    22.611    -1.974     0.200
    22.716     0.113     0.200
    22.743     1.528     0.200
    22.743     1.132     0.200
    22.777     3.613     0.200
    22.777     1.404     0.200
    22.805     1.461     0.200
    22.805     0.779     0.200
    23.068     1.048     0.200
    23.219     0.689     0.200
    23.735    -1.521     0.200
    24.527     1.532     0.200
    25.017    -0.555     0.200
    25.242     0.491     0.200
    25.242    -0.581     0.200
    25.383     0.248     0.200
    25.544     1.226     0.200
    25.544     0.701     0.200
    25.550     1.545     0.200
    25.550     1.315     0.200
    25.693     0.733     0.200
    25.753     1.152     0.200
    25.907     1.005     0.200
    25.984     1.251     0.200
    25.998     0.775     0.200
    25.999     2.686     0.200
    26.044     0.699     0.200
    26.079     1.341     0.200
    26.307     0.695     0.200
    26.389     2.675     0.200
    26.458     1.212     0.200
    26.977     0.655     0.200
    27.051     0.452     0.200
    27.087     1.510     0.200
    27.087     1.386     0.200
    27.095     1.135     0.200
    27.095     0.430     0.200
    27.101     1.545     0.200
    27.101     0.381     0.200
    27.250     1.595     0.200
    27.250     1.043     0.200
    27.336     1.318     0.200
    27.406     0.245     0.200
    27.670     0.484     0.200
    27.753     0.200     0.200
    27.806     1.467     0.200
    27.806     1.234     0.200
    27.803     0.342     0.200
    27.847     0.209     0.200
    28.065     1.321     0.200
    28.223     1.422     0.200
    28.304     0.568     0.200
    28.349     0.734     0.200
    28.378     0.693     0.200
    28.533    -0.062     0.200
    28.594     0.302     0.200
    28.606     0.386     0.200
    28.665     1.413     0.200
    28.691     1.500     0.200
    28.691     1.205     0.200
    28.756     0.484     0.200
    29.382     0.316     0.200
    29.546     0.029     0.200
    30.108     0.349     0.200
    30.170     1.335     0.200
    30.213     0.354     0.200
    30.213     1.251     0.200
    30.437     0.964     0.200
    30.437     1.376     0.200
    30.439     1.213     0.200
    30.439     0.905     0.200
    30.442     0.851     0.200
    30.534     0.461     0.200
    30.534     0.709     0.200
    30.988     1.025     0.200
    31.307     0.896     0.200
    31.307     1.262     0.200
    31.357     0.591     0.200
    31.469     0.302     0.200
    31.648     0.805     0.200
    31.704     1.079     0.200
    31.911     0.551     0.200
    31.966     1.450     0.200
    31.981     0.713     0.200
    32.176     0.959     0.200
    32.214     0.941     0.200
    32.309     0.303     0.200
    32.459     0.607     0.200
    32.459     1.087     0.200
    32.630     0.083     0.200
    32.921     0.771     0.200
    32.969    -0.225     0.200
    32.969     0.757     0.200
    33.315     1.348     0.200
    33.354     0.538     0.200
    33.375     1.457     0.200
    33.575     0.173     0.200
    33.657    -0.123     0.200
    33.664     0.442     0.200
    33.711     0.348     0.200
    33.713     0.944     0.200
    33.797     0.418     0.200
    33.967     0.266     0.200
    34.081     0.627     0.200
    34.111     1.436     0.200
    34.226     0.449     0.200
    34.226     1.374     0.200
    34.327     0.134     0.200
    34.406     0.562     0.200
    34.424     0.636     0.200
    34.424     0.455     0.200
    34.600     0.003     0.200
    34.612     1.456     0.200
    34.627     0.642     0.200
    34.629     0.867     0.200
    34.735     0.008     0.200
    34.779     0.204     0.200
    34.801     0.398     0.200
    34.824     0.276     0.200
    34.926     0.649     0.200
    34.938     0.630     0.200
    34.937    -1.067     0.200
    34.958     0.620     0.200
    34.958     0.135     0.200
    34.989     0.864     0.200
    35.248     1.109     0.200
    35.265     0.699     0.200
    35.281     0.506     0.200
    35.281     0.719     0.200
    35.395     1.427     0.200
    35.422     0.206     0.200
    35.465     0.822     0.200
    35.589     0.523     0.200
    35.605     0.897     0.200
    35.742     0.085     0.200
    35.788     0.526     0.200
    35.820     0.402     0.200
    35.840     0.305     0.200
    35.873     0.589     0.200
    35.873    -0.219     0.200
    35.933     0.318     0.200
    36.308     1.209     0.200
    36.326     1.060     0.200
    36.350     0.644     0.200
    36.617    -1.359     0.200
    36.564     0.432     0.200
    36.581     1.007     0.200
    36.646     1.178     0.200
    36.646     0.549     0.200
    36.692     1.427     0.200
    36.903     1.152     0.200
    37.092     1.793     0.200
    37.109     1.837     0.200
    37.193     1.250     0.200
    37.538     1.532     0.200
    37.742    -0.325     0.200
    37.783     1.086     0.200
    37.936     1.513     0.200
    38.208     1.635     0.200
    38.683     0.907     0.200
    40.307    -0.212     0.200
    42.675    -0.282     0.200
    43.201     1.263     0.200
    43.201     1.543     0.200
    44.476     1.801     0.200
    44.491     2.037     0.200
    46.060     1.790     0.200
    46.360     0.523     0.200
    46.390     1.546     0.200
    46.580     1.294     0.200
    46.580     0.999     0.200
    52.765     0.813     0.200
    59.283     3.677     0.200
    59.283     0.958     0.200
    59.728     2.901     0.200
    59.729     1.253     0.200
    64.795     2.074     0.200
    64.922     1.320     0.200
    67.424     1.015     0.200
    69.673    -2.354     0.200
    73.370     2.215     0.200
    74.060     4.434     0.200
    75.983     2.746     0.200
    76.276    -0.368     0.200
    76.276     3.075     0.200
    77.133     3.743     0.200
    77.235     1.303     0.200
    78.208     0.528     0.200
    78.320     1.437     0.200
    81.356     1.484     0.200
    81.822     1.103     0.200
    82.867     4.287     0.200
    83.962     1.856     0.200
    84.386     4.404     0.200
    86.937     2.314     0.200
    89.620     4.506     0.200
    20.422    -0.431     0.200
    20.442    -1.251     0.200
    25.770     2.218     0.200
    44.725     1.020     0.200
    65.149     0.812     0.200
    67.579     0.233     0.200
    81.583     0.507     0.200
    16.301     1.792     0.200
    16.301     3.785     0.200
    16.639     1.458     0.200
    17.184     0.653     0.200
    18.785    -0.869     0.200
    19.097    -1.688     0.200
    19.097    -1.876     0.200
    19.164    -0.469     0.200
    19.413    -1.587     0.200
    19.413    -0.923     0.200
    19.430     0.341     0.200
    19.430     2.365     0.200
    19.532     4.597     0.200
    20.313    -1.140     0.200
    20.313     0.469     0.200
    20.346    -0.521     0.200
    20.549    -2.951     0.200
    20.873    -1.955     0.200
    21.018     1.141     0.200
    21.346     0.706     0.200
    22.259    -1.548     0.200
    22.343    -3.014     0.200
    22.343    -2.546     0.200
    22.540     0.455     0.200
    22.540     2.268     0.200
    22.572     0.854     0.200
    22.760     0.634     0.200
    23.253    -0.945     0.200
    23.477     1.404     0.200
    23.529    -2.501     0.200
    23.935     1.649     0.200
    24.175     0.015     0.200
    24.212     0.260     0.200
    25.318     0.155     0.200
    25.318     2.500     0.200
    26.484    -0.757     0.200
    26.600    -0.861     0.200
    26.633    -0.709     0.200
    26.633     0.893     0.200
    27.261     1.449     0.200
    29.717    -0.956     0.200
    29.793     0.216     0.200
    32.546     1.679     0.200
    35.776     0.834     0.200
    46.515     3.235     0.200
    48.875     1.683     0.200
    52.260     1.219     0.200
    59.970     0.296     0.200
    60.269     1.205     0.200
    66.635    -0.679     0.200
    67.422     0.286     0.200
    67.939     0.823     0.200
    67.939     0.401     0.200
    74.764    -1.107     0.200
    77.839     0.714     0.200
    77.907     0.459     0.200
    77.930     0.776     0.200
    78.124     4.231     0.200
    79.015     0.994     0.200
    79.120     0.419     0.200
    81.502     1.036     0.200
    82.062     0.658     0.200
    82.062     0.009     0.200
    82.114     0.428     0.200
    82.466     0.275     0.200
    82.466    -0.155     0.200
    83.075    -1.013     0.200
    83.581     1.000     0.200
    94.290     1.069     0.200
    17.265     1.926     0.200
    17.265     2.735     0.200
    17.265     2.244     0.200
    17.331     3.238     0.200
    17.553     2.152     0.200
    17.564     4.675     0.200
    17.633     1.790     0.200
    18.144     1.643     0.200
    18.956     0.917     0.200
    18.937     2.778     0.200
    19.009     0.417     0.200
    19.009     1.927     0.200
    19.232    -0.776     0.200
    19.427     0.969     0.200
    19.426     1.708     0.200
    19.426     1.208     0.200
    19.426     1.528     0.200
    19.419     2.783     0.200
    19.587    -2.178     0.200
    19.587    -2.023     0.200
    19.587    -1.503     0.200
    19.595     0.893     0.200
    19.734     1.476     0.200
    19.742     1.355     0.200
    19.989    -1.834     0.200
    19.989    -0.194     0.200
    19.919     2.657     0.200
    20.062     3.062     0.200
    20.426     1.803     0.200
    20.426     2.229     0.200
    20.447     1.337     0.200
    20.535     1.607     0.200
    20.951    -1.148     0.200
    20.955     2.212     0.200
    21.055    -1.947     0.200
    21.060    -1.801     0.200
    21.060    -1.421     0.200
    21.172     0.573     0.200
    21.296     2.236     0.200
    21.477     2.730     0.200
    21.634     0.873     0.200
    21.693     2.219     0.200
    21.705     2.948     0.200
    21.865     1.666     0.200
    21.984     1.921     0.200
    22.035     0.150     0.200
    22.073     0.106     0.200
    22.510     0.553     0.200
    22.553     2.423     0.200
    22.557     1.713     0.200
    23.073    -0.088     0.200
    23.090     1.040     0.200
    23.171     0.385     0.200
    23.370    -0.101     0.200
    23.426     0.666     0.200
    23.439     0.772     0.200
    23.543     2.270     0.200
    23.543     1.501     0.200
    23.765     0.949     0.200
    24.088     2.412     0.200
    24.674     1.534     0.200
    24.872     1.393     0.200
    24.880     1.925     0.200
    24.880     1.314     0.200
    25.511     1.504     0.200
    25.588     1.108     0.200
    26.317     2.647     0.200
    26.321     1.829     0.200
    26.321     2.109     0.200
    26.322     2.577     0.200
    26.322     1.812     0.200
    27.400     3.449     0.200
    27.400     0.749     0.200
    27.400     3.599     0.200
    27.458     1.237     0.200
    27.458     0.477     0.200
    28.163     2.044     0.200
    28.707     0.455     0.200
    30.057     2.767     0.200
    30.057     2.477     0.200
    30.567     1.283     0.200
    30.796     1.157     0.200
    30.796     0.708     0.200
    30.796     0.947     0.200
    31.789    -0.771     0.200
    31.653     1.046     0.200
    32.017    -0.372     0.200
    32.017     0.103     0.200
    32.397     3.269     0.200
    32.397     1.999     0.200
    32.397     3.969     0.200
    32.670     0.473     0.200
    33.279     0.927     0.200
    33.323     1.421     0.200
    33.323     0.931     0.200
    34.007     0.710     0.200
    34.340     1.032     0.200
    34.778     0.435     0.200
    34.979     1.216     0.200
    35.234     0.734     0.200
    35.234     0.513     0.200
    35.295     1.302     0.200
    35.709     0.502     0.200
    35.987    -0.210     0.200
    35.987     0.264     0.200
    37.314     4.243     0.200
    37.521     0.410     0.200
    40.133     1.664     0.200
    40.644     0.645     0.200
    41.883     1.724     0.200
    41.883     1.275     0.200
    41.883     1.525     0.200
    43.003     1.667     0.200
    43.266     1.770     0.200
    43.266     1.890     0.200
    44.337     1.797     0.200
    45.723     2.207     0.200
    46.386     1.065     0.200
    46.386     0.596     0.200
    47.434     1.220     0.200
    48.193     1.088     0.200
    48.193     1.308     0.200
    49.634     1.847     0.200
    53.123     1.587     0.200
    53.123     1.257     0.200
    55.569     1.767     0.200
    55.569     1.277     0.200
    58.202     1.859     0.200
    58.202     1.639     0.200
    60.509     1.361     0.200
    60.483     3.586     0.200
    61.223     2.137     0.200
    61.223     1.567     0.200
    62.224     0.841     0.200
    62.535     3.992     0.200
    63.857     1.689     0.200
    64.594     3.456     0.200
    64.706     1.160     0.200
    64.832     1.151     0.200
    64.832     0.851     0.200
    65.426     0.193     0.200
    66.213     0.030     0.200
    67.415     1.255     0.200
    67.415     0.847     0.200
    67.415     0.621     0.200
    68.169     1.256     0.200
    70.839     2.440     0.200
    72.115     1.677     0.200
    72.275     1.531     0.200
    72.289     1.046     0.200
    72.290     2.058     0.200
    72.518     1.578     0.200
    72.567     1.626     0.200
    72.567     1.446     0.200
    72.657     3.625     0.200
    72.702     2.308     0.200
    73.102     1.745     0.200
    73.098     2.162     0.200
    73.295     2.095     0.200
    73.314     1.895     0.200
    73.544     1.900     0.200
    73.665     1.658     0.200
    73.861     2.949     0.200
    73.905     1.667     0.200
    73.905     1.106     0.200
    73.929     1.456     0.200
    73.929     1.276     0.200
    73.929     1.026     0.200
    74.082     1.383     0.200
    74.126     1.603     0.200
    74.573     1.745     0.200
    74.580     1.391     0.200
    74.768     1.153     0.200
    74.782     2.393     0.200
    74.825     2.197     0.200
    74.858     2.392     0.200
    74.859     2.319     0.200
    74.859     2.010     0.200
    74.882     1.565     0.200
    75.064     1.437     0.200
    75.082     1.794     0.200
    75.147     2.057     0.200
    75.158     2.194     0.200
    75.165     1.656     0.200
    75.165     0.886     0.200
    75.165     1.456     0.200
    75.251     1.340     0.200
    75.279     1.077     0.200
    75.342     2.205     0.200
    75.366     1.868     0.200
    75.408     2.585     0.200
    75.480     1.687     0.200
    75.488     1.548     0.200
    75.506     1.473     0.200
    75.545     2.042     0.200
    75.568     2.052     0.200
    75.663     1.314     0.200
    75.681     2.174     0.200
    75.696     2.099     0.200
    75.713     1.859     0.200
    75.835     2.043     0.200
    76.023     1.099     0.200
    76.049     1.977     0.200
    76.144     0.795     0.200
    76.303     2.063     0.200
    76.341     1.963     0.200
    76.341     1.758     0.200
    76.341     1.263     0.200
    76.421     1.363     0.200
    76.434     1.890     0.200
    76.476     2.459     0.200
    76.515     0.879     0.200
    76.537     1.564     0.200
    76.539     1.615     0.200
    76.580     2.665     0.200
    76.580     0.532     0.200
    76.245     3.483     0.200
    76.720     1.903     0.200
    76.720     2.094     0.200
    76.801     1.204     0.200
    76.876     1.309     0.200
    76.892     0.502     0.200
    76.892     1.722     0.200
    76.908     4.234     0.200
    76.951     0.810     0.200
    76.987     0.721     0.200
    77.032     1.707     0.200
    77.074     2.007     0.200
    77.083     1.244     0.200
    77.081     2.861     0.200
    77.148     1.589     0.200
    77.292     3.045     0.200
    77.320     0.983     0.200
    77.411     1.760     0.200
    77.403     0.458     0.200
    77.415     2.885     0.200
    77.637     1.429     0.200
    77.637     1.779     0.200
    77.948     0.698     0.200
    77.669     2.940     0.200
    77.690     1.913     0.200
    77.692     1.799     0.200
    77.758     2.737     0.200
    77.784     1.888     0.200
    77.784     1.998     0.200
    77.782    -0.228     0.200
    77.847     1.302     0.200
    77.887     1.554     0.200
    77.878     0.746     0.200
    77.920     3.271     0.200
    77.998     1.879     0.200
    78.106     3.843     0.200
    78.157     0.574     0.200
    78.134     2.085     0.200
    78.134     3.125     0.200
    78.162     3.728     0.200
    78.186     3.499     0.200
    78.198     2.429     0.200
    78.210     0.488     0.200
    78.210     3.563     0.200
    78.214     2.502     0.200
    78.214     3.943     0.200
    78.239     1.502     0.200
    78.280     2.875     0.200
    78.285     2.449     0.200
    78.305     1.811     0.200
    78.469     0.353     0.200
    78.686     0.759     0.200
    78.760     2.292     0.200
    78.815     2.089     0.200
    78.853     2.689     0.200
    79.734     4.116     0.200
    80.038     1.801     0.200
    80.081     1.078     0.200
    80.109     1.835     0.200
    80.590     3.451     0.200
    80.757     0.686     0.200
    81.152     2.295     0.200
    81.152     1.551     0.200
    81.428     2.028     0.200
    81.428     1.668     0.200
    81.703     1.006     0.200
    81.703     1.316     0.200
    82.385     2.146     0.200
    82.378     1.936     0.200
    82.639     4.982     0.200
    83.020     1.435     0.200
    83.020     1.305     0.200
    83.094     1.737     0.200
    83.095     1.292     0.200
    83.378     1.698     0.200
    83.779     2.913     0.200
    83.779     4.104     0.200
    83.983     2.544     0.200
    83.983     1.863     0.200
    84.096     0.287     0.200
    84.598     1.593     0.200
    84.789     0.883     0.200
    85.253     2.324     0.200
    85.253     1.435     0.200
    85.781     0.856     0.200
    86.244     0.562     0.200
    86.265     0.507     0.200
    86.637     1.587     0.200
    86.890     3.699     0.200
    86.890     4.574     0.200
    86.945     0.647     0.200
    87.095     0.958     0.200
    89.338     0.961     0.200
    89.776     0.983     0.200
    90.192     1.900     0.200
    90.493     2.110     0.200
    91.447     3.939     0.200
    93.734     0.521     0.200
    95.448     3.365     0.200
    96.334     3.003     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   101.072     3.701     0.200
   101.436     2.543     0.200
   103.206     1.801     0.200
   103.845     3.640     0.200
   104.467     2.782     0.200
   106.020     0.572     0.200
   106.165     0.684     0.200
   107.935     2.777     0.200
   108.123     3.331     0.200
   108.328     0.688     0.200
   108.400     2.025     0.200
   108.931     4.211     0.200
   109.623     2.312     0.200
   109.701     0.136     0.200
   109.703     0.982     0.200
   109.758     1.064     0.200
   109.872     0.414     0.200
   110.299     2.690     0.200
   110.332     3.807     0.200
   110.768     4.283     0.200
   110.851     3.773     0.200
   111.441     2.910     0.200
   112.417     4.025     0.200
   112.830     3.734     0.200
   113.274     3.533     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    58.936    49.258     0.200
    69.793    31.389     0.200
    74.602    16.440     0.200
    74.773    23.453     0.200
    76.214    17.191     0.200
    18.606   276.127     0.200
    76.190     9.625     0.200
    36.897   140.867     0.200
    53.327    68.323     0.200
    56.587    54.046     0.200
    59.607    47.405     0.200
    66.584    27.991     0.200
    73.392    17.393     0.200
    73.821    13.467     0.200
    74.095    17.565     0.200
    74.997    13.232     0.200
    75.541    10.202     0.200
    75.604    10.137     0.200
    75.708     9.941     0.200
    75.842    10.279     0.200
    75.847     8.048     0.200
    76.222    10.319     0.200
    76.779     7.560     0.200
    77.688    10.766     0.200
    77.740    10.370     0.200
    77.821     8.724     0.200
    77.909     7.930     0.200
    78.034    10.234     0.200
    78.195     7.339     0.200
    78.441    10.682     0.200
    78.606     8.273     0.200
    79.113     7.693     0.200
    79.409     8.865     0.200
    79.412     9.358     0.200
    79.532    10.603     0.200
    79.512    12.414     0.200
    79.977    12.585     0.200
    83.178     9.371     0.200
    83.649     8.151     0.200
    85.840     2.039     0.200
    17.585   278.810     0.200
    83.962     7.756     0.200
    19.489   259.265     0.200
    19.009   266.118     0.200
    73.929    16.626     0.200
    77.604    12.466     0.200
    77.669    12.226     0.200
    77.758    11.441     0.200
    78.134    11.675     0.200
    78.477    11.781     0.200
    78.546    10.197     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
