#!/bin/bash
gmt begin tofino1.52_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times tofino1.52'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   321.190
    25.500   325.731
    26.000   330.261
    26.500   334.779
    27.000   339.284
    27.500   343.773
    28.000   348.241
    28.500   352.695
    29.000   357.138
    29.500   361.573
    30.000   366.000
    30.500   370.419
    31.000   374.831
    31.500   379.235
    32.000   383.631
    32.500   388.016
    33.000   392.391
    33.500   396.753
    34.000   401.101
    34.500   405.434
    35.000   409.751
    35.500   414.054
    36.000   418.341
    36.500   422.613
    37.000   426.870
    37.500   431.111
    38.000   435.336
    38.500   439.545
    39.000   443.737
    39.500   447.913
    40.000   452.071
    40.500   456.212
    41.000   460.337
    41.500   464.444
    42.000   468.534
    42.500   472.607
    43.000   476.662
    43.500   480.700
    44.000   484.720
    44.500   488.723
    45.000   492.707
    45.500   496.674
    46.000   500.623
    46.500   504.553
    47.000   508.466
    47.500   512.360
    48.000   516.237
    48.500   520.095
    49.000   523.935
    49.500   527.757
    50.000   531.561
    50.500   535.346
    51.000   539.113
    51.500   542.862
    52.000   546.593
    52.500   550.306
    53.000   554.001
    53.500   557.678
    54.000   561.338
    54.500   564.979
    55.000   568.601
    55.500   572.205
    56.000   575.791
    56.500   579.358
    57.000   582.907
    57.500   586.438
    58.000   589.950
    58.500   593.445
    59.000   596.921
    59.500   600.379
    60.000   603.819
    60.500   607.241
    61.000   610.644
    61.500   614.028
    62.000   617.395
    62.500   620.743
    63.000   624.074
    63.500   627.386
    64.000   630.681
    64.500   633.958
    65.000   637.217
    65.500   640.458
    66.000   643.681
    66.500   646.886
    67.000   650.073
    67.500   653.241
    68.000   656.392
    68.500   659.524
    69.000   662.639
    69.500   665.735
    70.000   668.813
    70.500   671.873
    71.000   674.915
    71.500   677.938
    72.000   680.944
    72.500   683.931
    73.000   686.900
    73.500   689.851
    74.000   692.782
    74.500   695.695
    75.000   698.589
    75.500   701.465
    76.000   704.322
    76.500   707.162
    77.000   709.983
    77.500   712.786
    78.000   715.571
    78.500   718.338
    79.000   721.087
    79.500   723.818
    80.000   726.529
    80.500   729.222
    81.000   731.895
    81.500   734.549
    82.000   737.184
    82.500   739.800
    83.000   742.398
    83.500   744.977
    84.000   747.536
    84.500   750.074
    85.000   752.593
    85.500   755.091
    86.000   757.571
    86.500   760.034
    87.000   762.478
    87.500   764.899
    88.000   767.284
    88.500   769.649
    89.000   772.003
    89.500   774.348
    90.000   776.685
    90.500   779.015
    91.000   781.340
    91.500   783.659
    92.000   785.973
    92.500   788.284
    93.000   790.590
    93.500   792.894
    94.000   795.194
    94.500   797.489
    95.000   799.779
    95.500   802.062
    96.000   804.340
    96.500   806.611
    97.000   808.876
    97.500   811.134
    98.000   813.385
    98.500   815.628
    99.000   817.864
    99.500   820.092
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1119.030
   116.000  1119.992
   116.500  1120.954
   117.000  1121.916
   117.500  1122.878
   118.000  1123.840
   118.500  1124.802
   119.000  1125.764
   119.500  1126.725
   120.000  1127.686
   120.500  1128.647
   121.000  1129.608
   121.500  1130.569
   122.000  1131.529
   122.500  1132.489
   123.000  1133.448
   123.500  1134.407
   124.000  1135.366
   124.500  1136.324
   125.000  1137.282
   125.500  1138.239
   126.000  1139.195
   126.500  1140.151
   127.000  1141.106
   127.500  1142.061
   128.000  1143.015
   128.500  1143.967
   129.000  1144.919
   129.500  1145.870
   130.000  1146.820
   130.500  1147.769
   131.000  1148.716
   131.500  1149.662
   132.000  1150.607
   132.500  1151.551
   133.000  1152.493
   133.500  1153.434
   134.000  1154.373
   134.500  1155.310
   135.000  1156.245
   135.500  1157.178
   136.000  1158.109
   136.500  1159.038
   137.000  1159.964
   137.500  1160.888
   138.000  1161.809
   138.500  1162.728
   139.000  1163.643
   139.500  1164.556
   140.000  1165.465
   140.500  1166.371
   141.000  1167.274
   141.500  1168.172
   142.000  1169.067
   142.500  1169.957
   143.000  1170.843
   143.500  1171.724
   144.000  1172.600
   144.500  1173.471
   145.000  1174.337
   145.500  1175.196
   146.000  1176.050
   146.500  1176.897
   147.000  1177.738
   147.500  1178.572
   148.000  1179.399
   148.500  1180.218
   149.000  1181.030
   149.500  1181.832
   150.000  1182.625
   150.500  1183.408
   151.000  1184.181
   151.500  1184.944
   152.000  1185.697
   152.500  1186.441
   153.000  1187.174
   153.500  1187.896
   154.000  1188.609
   154.500  1189.310
   155.000  1190.000
   155.500  1190.678
   156.000  1191.345
   156.500  1192.001
   157.000  1192.644
   157.500  1193.275
   158.000  1193.894
   158.500  1194.500
   159.000  1195.094
   159.500  1195.675
   160.000  1196.244
   160.500  1196.799
   161.000  1197.341
   161.500  1197.870
   162.000  1198.386
   162.500  1198.889
   163.000  1199.378
   163.500  1199.854
   164.000  1200.316
   164.500  1200.764
   165.000  1201.198
   165.500  1201.619
   166.000  1202.025
   166.500  1202.418
   167.000  1202.797
   167.500  1203.162
   168.000  1203.513
   168.500  1203.850
   169.000  1204.173
   169.500  1204.481
   170.000  1204.776
   170.500  1205.056
   171.000  1205.322
   171.500  1205.573
   172.000  1205.811
   172.500  1206.034
   173.000  1206.243
   173.500  1206.437
   174.000  1206.617
   174.500  1206.783
   175.000  1206.935
   175.500  1207.072
   176.000  1207.194
   176.500  1207.302
   177.000  1207.396
   177.500  1207.475
   178.000  1207.540
   178.500  1207.591
   179.000  1207.627
   179.500  1207.649
   180.000  1207.656
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   989.955
     1.000   989.963
     1.500   989.977
     2.000   989.997
     2.500   990.022
     3.000   990.052
     3.500   990.089
     4.000   990.131
     4.500   990.178
     5.000   990.232
     5.500   990.290
     6.000   990.355
     6.500   990.424
     7.000   990.500
     7.500   990.581
     8.000   990.668
     8.500   990.760
     9.000   990.858
     9.500   990.961
    10.000   991.070
    10.500   991.184
    11.000   991.305
    11.500   991.430
    12.000   991.561
    12.500   991.698
    13.000   991.840
    13.500   991.988
    14.000   992.141
    14.500   992.300
    15.000   992.464
    15.500   992.634
    16.000   992.809
    16.500   992.990
    17.000   993.176
    17.500   993.368
    18.000   993.565
    18.500   993.768
    19.000   993.976
    19.500   994.190
    20.000   994.409
    20.500   994.634
    21.000   994.864
    21.500   995.099
    22.000   995.340
    22.500   995.586
    23.000   995.838
    23.500   996.095
    24.000   996.357
    24.500   996.625
    25.000   996.898
    25.500   997.177
    26.000   997.461
    26.500   997.750
    27.000   998.044
    27.500   998.344
    28.000   998.649
    28.500   998.960
    29.000   999.276
    29.500   999.597
    30.000   999.923
    30.500  1000.254
    31.000  1000.591
    31.500  1000.933
    32.000  1001.281
    32.500  1001.633
    33.000  1001.991
    33.500  1002.353
    34.000  1002.722
    34.500  1003.095
    35.000  1003.473
    35.500  1003.857
    36.000  1004.245
    36.500  1004.639
    37.000  1005.038
    37.500  1005.441
    38.000  1005.850
    38.500  1006.264
    39.000  1006.683
    39.500  1007.107
    40.000  1007.536
    40.500  1007.971
    41.000  1008.410
    41.500  1008.854
    42.000  1009.303
    42.500  1009.757
    43.000  1010.215
    43.500  1010.679
    44.000  1011.148
    44.500  1011.621
    45.000  1012.100
    45.500  1012.583
    46.000  1013.071
    46.500  1013.564
    47.000  1014.062
    47.500  1014.564
    48.000  1015.071
    48.500  1015.583
    49.000  1016.100
    49.500  1016.622
    50.000  1017.148
    50.500  1017.679
    51.000  1018.214
    51.500  1018.754
    52.000  1019.299
    52.500  1019.849
    53.000  1020.403
    53.500  1020.961
    54.000  1021.524
    54.500  1022.092
    55.000  1022.664
    55.500  1023.241
    56.000  1023.822
    56.500  1024.408
    57.000  1024.998
    57.500  1025.593
    58.000  1026.192
    58.500  1026.795
    59.000  1027.403
    59.500  1028.015
    60.000  1028.632
    60.500  1029.253
    61.000  1029.878
    61.500  1030.507
    62.000  1031.141
    62.500  1031.779
    63.000  1032.421
    63.500  1033.067
    64.000  1033.718
    64.500  1034.373
    65.000  1035.031
    65.500  1035.694
    66.000  1036.361
    66.500  1037.032
    67.000  1037.708
    67.500  1038.387
    68.000  1039.070
    68.500  1039.757
    69.000  1040.449
    69.500  1041.144
    70.000  1041.843
    70.500  1042.546
    71.000  1043.253
    71.500  1043.964
    72.000  1044.679
    72.500  1045.397
    73.000  1046.119
    73.500  1046.845
    74.000  1047.575
    74.500  1048.309
    75.000  1049.046
    75.500  1049.787
    76.000  1050.532
    76.500  1051.280
    77.000  1052.032
    77.500  1052.788
    78.000  1053.547
    78.500  1054.310
    79.000  1055.076
    79.500  1055.846
    80.000  1056.619
    80.500  1057.396
    81.000  1058.177
    81.500  1058.960
    82.000  1059.747
    82.500  1060.538
    83.000  1061.332
    83.500  1062.129
    84.000  1062.929
    84.500  1063.733
    85.000  1064.540
    85.500  1065.351
    86.000  1066.164
    86.500  1066.981
    87.000  1067.801
    87.500  1068.624
    88.000  1069.451
    88.500  1070.280
    89.000  1071.112
    89.500  1071.948
    90.000  1072.786
    90.500  1073.628
    91.000  1074.473
    91.500  1075.320
    92.000  1076.171
    92.500  1077.024
    93.000  1077.880
    93.500  1078.740
    94.000  1079.602
    94.500  1080.467
    95.000  1081.334
    95.500  1082.205
    96.000  1083.078
    96.500  1083.954
    97.000  1084.833
    97.500  1085.714
    98.000  1086.598
    98.500  1087.485
    99.000  1088.374
    99.500  1089.266
   100.000  1090.160
   100.500  1091.057
   101.000  1091.957
   101.500  1092.859
   102.000  1093.763
   102.500  1094.670
   103.000  1095.580
   103.500  1096.491
   104.000  1097.406
   104.500  1098.322
   105.000  1099.241
   105.500  1100.162
   106.000  1101.085
   106.500  1102.011
   107.000  1102.939
   107.500  1103.869
   108.000  1104.801
   108.500  1105.735
   109.000  1106.672
   109.500  1107.611
   110.000  1108.551
   110.500  1109.494
   111.000  1110.439
   111.500  1111.386
   112.000  1112.335
   112.500  1113.286
   113.000  1114.238
   113.500  1115.193
   114.000  1116.149
   114.500  1117.108
   115.000  1118.068
   115.500  1119.030
   116.000  1119.994
   116.500  1120.960
   117.000  1121.927
   117.500  1122.896
   118.000  1123.867
   118.500  1124.840
   119.000  1125.814
   119.500  1126.790
   120.000  1127.767
   120.500  1128.746
   121.000  1129.726
   121.500  1130.708
   122.000  1131.692
   122.500  1132.677
   123.000  1133.664
   123.500  1134.652
   124.000  1135.641
   124.500  1136.632
   125.000  1137.624
   125.500  1138.617
   126.000  1139.612
   126.500  1140.608
   127.000  1141.606
   127.500  1142.604
   128.000  1143.604
   128.500  1144.605
   129.000  1145.607
   129.500  1146.611
   130.000  1147.615
   130.500  1148.621
   131.000  1149.628
   131.500  1150.635
   132.000  1151.644
   132.500  1152.654
   133.000  1153.665
   133.500  1154.677
   134.000  1155.689
   134.500  1156.703
   135.000  1157.718
   135.500  1158.733
   136.000  1159.749
   136.500  1160.766
   137.000  1161.784
   137.500  1162.803
   138.000  1163.823
   138.500  1164.843
   139.000  1165.864
   139.500  1166.885
   140.000  1167.908
   140.500  1168.931
   141.000  1169.954
   141.500  1170.979
   142.000  1172.003
   142.500  1173.029
   143.000  1174.055
   143.500  1175.081
   144.000  1176.108
   144.500  1177.136
   145.000  1178.164
   145.500  1179.192
   146.000  1180.221
   146.500  1181.250
   147.000  1182.279
   147.500  1183.309
   148.000  1184.339
   148.500  1185.370
   149.000  1186.401
   149.500  1187.432
   150.000  1188.463
   150.500  1189.495
   151.000  1190.526
   151.500  1191.558
   152.000  1192.590
   152.500  1193.622
   153.000  1194.655
   153.500  1195.687
   154.000  1196.720
   154.500  1197.752
   155.000  1198.785
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1173.693
   145.500  1175.522
   146.000  1177.406
   146.500  1179.325
   147.000  1181.272
   147.500  1183.241
   148.000  1185.231
   148.500  1187.238
   149.000  1189.260
   149.500  1191.296
   150.000  1193.345
   150.500  1195.406
   151.000  1197.476
   151.500  1199.557
   152.000  1201.646
   152.500  1203.743
   153.000  1205.849
   153.500  1207.962
   154.000  1210.081
   154.500  1212.207
   155.000  1214.340
   155.500  1216.478
   156.000  1218.621
   156.500  1220.769
   157.000  1222.922
   157.500  1225.079
   158.000  1227.240
   158.500  1229.406
   159.000  1231.576
   159.500  1233.749
   160.000  1235.925
   160.500  1238.105
   161.000  1240.288
   161.500  1242.474
   162.000  1244.662
   162.500  1246.853
   163.000  1249.046
   163.500  1251.242
   164.000  1253.439
   164.500  1255.639
   165.000  1257.841
   165.500  1260.044
   166.000  1262.250
   166.500  1264.457
   167.000  1266.665
   167.500  1268.875
   168.000  1271.086
   168.500  1273.298
   169.000  1275.511
   169.500  1277.726
   170.000  1279.942
   170.500  1282.158
   171.000  1284.375
   171.500  1286.593
   172.000  1288.812
   172.500  1291.032
   173.000  1293.252
   173.500  1295.472
   174.000  1297.693
   174.500  1299.915
   175.000  1302.136
   175.500  1304.359
   176.000  1306.581
   176.500  1308.803
   177.000  1311.026
   177.500  1313.249
   178.000  1315.472
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1173.685
   145.500  1175.304
   146.000  1176.848
   146.500  1178.334
   147.000  1179.772
   147.500  1181.164
   148.000  1182.514
   148.500  1183.824
   149.000  1185.100
   149.500  1186.347
   150.000  1187.569
   150.500  1188.769
   151.000  1189.948
   151.500  1191.108
   152.000  1192.249
   152.500  1193.373
   153.000  1194.482
   153.500  1195.575
   154.000  1196.656
   154.500  1197.724
   155.000  1198.778
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   506.830
     1.000   506.866
     1.500   506.926
     2.000   507.010
     2.500   507.118
     3.000   507.250
     3.500   507.406
     4.000   507.586
     4.500   507.790
     5.000   508.018
     5.500   508.270
     6.000   508.545
     6.500   508.844
     7.000   509.166
     7.500   509.513
     8.000   509.882
     8.500   510.276
     9.000   510.692
     9.500   511.132
    10.000   511.595
    10.500   512.081
    11.000   512.590
    11.500   513.122
    12.000   513.677
    12.500   514.255
    13.000   514.855
    13.500   515.478
    14.000   516.123
    14.500   516.791
    15.000   517.481
    15.500   518.192
    16.000   518.926
    16.500   519.681
    17.000   520.458
    17.500   521.257
    18.000   522.077
    18.500   522.918
    19.000   523.780
    19.500   524.664
    20.000   525.567
    20.500   526.492
    21.000   527.437
    21.500   528.402
    22.000   529.388
    22.500   530.393
    23.000   531.419
    23.500   532.464
    24.000   533.528
    24.500   534.612
    25.000   535.715
    25.500   536.837
    26.000   537.977
    26.500   539.137
    27.000   540.315
    27.500   541.511
    28.000   542.725
    28.500   543.957
    29.000   545.207
    29.500   546.474
    30.000   547.759
    30.500   549.061
    31.000   550.380
    31.500   551.716
    32.000   553.068
    32.500   554.437
    33.000   555.822
    33.500   557.223
    34.000   558.640
    34.500   560.073
    35.000   561.521
    35.500   562.984
    36.000   564.463
    36.500   565.957
    37.000   567.465
    37.500   568.988
    38.000   570.525
    38.500   572.077
    39.000   573.642
    39.500   575.222
    40.000   576.815
    40.500   578.421
    41.000   580.041
    41.500   581.674
    42.000   583.320
    42.500   584.978
    43.000   586.649
    43.500   588.333
    44.000   590.028
    44.500   591.736
    45.000   593.455
    45.500   595.187
    46.000   596.929
    46.500   598.683
    47.000   600.448
    47.500   602.224
    48.000   604.011
    48.500   605.808
    49.000   607.616
    49.500   609.434
    50.000   611.263
    50.500   613.101
    51.000   614.949
    51.500   616.806
    52.000   618.674
    52.500   620.550
    53.000   622.435
    53.500   624.330
    54.000   626.233
    54.500   628.145
    55.000   630.066
    55.500   631.995
    56.000   633.932
    56.500   635.877
    57.000   637.830
    57.500   639.791
    58.000   641.759
    58.500   643.735
    59.000   645.718
    59.500   647.708
    60.000   649.706
    60.500   651.710
    61.000   653.721
    61.500   655.739
    62.000   657.763
    62.500   659.793
    63.000   661.830
    63.500   663.873
    64.000   665.922
    64.500   667.976
    65.000   670.037
    65.500   672.103
    66.000   674.174
    66.500   676.251
    67.000   678.333
    67.500   680.419
    68.000   682.511
    68.500   684.608
    69.000   686.710
    69.500   688.816
    70.000   690.927
    70.500   693.042
    71.000   695.161
    71.500   697.284
    72.000   699.412
    72.500   701.544
    73.000   703.679
    73.500   705.818
    74.000   707.961
    74.500   710.107
    75.000   712.257
    75.500   714.410
    76.000   716.567
    76.500   718.726
    77.000   720.889
    77.500   723.054
    78.000   725.223
    78.500   727.394
    79.000   729.568
    79.500   731.745
    80.000   733.924
    80.500   736.105
    81.000   738.289
    81.500   740.475
    82.000   742.664
    82.500   744.854
    83.000   747.047
    83.500   749.241
    84.000   751.438
    84.500   753.636
    85.000   755.836
    85.500   758.037
    86.000   760.240
    86.500   762.445
    87.000   764.651
    87.500   766.858
    88.000   769.067
    88.500   771.277
    89.000   773.488
    89.500   775.701
    90.000   777.914
    90.500   780.128
    91.000   782.344
    91.500   784.560
    92.000   786.777
    92.500   788.994
    93.000   791.213
    93.500   793.432
    94.000   795.652
    94.500   797.872
    95.000   800.092
    95.500   802.314
    96.000   804.535
    96.500   806.757
    97.000   808.979
    97.500   811.201
    98.000   813.424
    98.500   815.646
    99.000   817.869
    99.500   820.092
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.000   411.701
    28.500   417.258
    29.000   422.815
    29.500   428.372
    30.000   433.928
    30.500   439.483
    31.000   445.036
    31.500   450.587
    32.000   456.136
    32.500   461.683
    33.000   467.227
    33.500   472.767
    34.000   478.303
    34.500   483.836
    35.000   489.363
    35.500   494.885
    36.000   500.402
    36.500   505.912
    37.000   511.416
    37.500   516.912
    38.000   522.401
    38.500   527.881
    39.000   533.352
    39.500   538.814
    40.000   544.265
    40.500   549.706
    41.000   555.135
    41.500   560.553
    42.000   565.958
    42.500   571.350
    43.000   576.728
    43.500   582.093
    44.000   587.443
    44.500   592.779
    45.000   598.099
    45.500   603.403
    46.000   608.690
    46.500   613.961
    47.000   619.215
    47.500   623.816
    48.000   628.386
    48.500   632.951
    49.000   637.511
    49.500   642.067
    50.000   646.617
    50.500   651.163
    51.000   655.703
    51.500   660.237
    52.000   664.766
    52.500   669.289
    53.000   673.806
    53.500   678.317
    54.000   682.821
    54.500   687.317
    55.000   691.803
    55.500   696.279
    56.000   700.745
    56.500   705.204
    57.000   709.656
    57.500   714.104
    58.000   718.546
    58.500   722.984
    59.000   727.418
    59.500   731.848
    60.000   736.274
    60.500   740.697
    61.000   745.115
    61.500   749.530
    62.000   753.941
    62.500   758.348
    63.000   762.751
    63.500   767.150
    64.000   771.544
    64.500   775.934
    65.000   780.319
    65.500   784.698
    66.000   789.072
    66.500   793.439
    67.000   797.800
    67.500   802.153
    68.000   806.499
    68.500   810.838
    69.000   815.169
    69.500   819.493
    70.000   823.809
    70.500   828.117
    71.000   832.418
    71.500   836.711
    72.000   840.997
    72.500   845.275
    73.000   849.546
    73.500   853.809
    74.000   858.064
    74.500   862.311
    75.000   866.550
    75.500   870.781
    76.000   875.004
    76.500   879.220
    77.000   883.427
    77.500   887.625
    78.000   891.816
    78.500   895.998
    79.000   900.171
    79.500   904.336
    80.000   908.492
    80.500   912.640
    81.000   916.779
    81.500   920.910
    82.000   925.032
    82.500   929.146
    83.000   933.251
    83.500   937.348
    84.000   941.436
    84.500   945.515
    85.000   949.586
    85.500   953.648
    86.000   957.702
    86.500   961.746
    87.000   965.782
    87.500   969.809
    88.000   973.827
    88.500   977.836
    89.000   981.836
    89.500   985.827
    90.000   989.810
    90.500   993.783
    91.000   997.747
    91.500  1001.703
    92.000  1005.649
    92.500  1009.586
    93.000  1013.515
    93.500  1017.434
    94.000  1021.344
    94.500  1025.246
    95.000  1029.138
    95.500  1033.021
    96.000  1036.895
    96.500  1040.760
    97.000  1044.616
    97.500  1048.463
    98.000  1052.301
    98.500  1056.130
    99.000  1059.949
    99.500  1063.759
   100.000  1067.561
   100.500  1071.353
   101.000  1075.136
   101.500  1078.909
   102.000  1082.674
   102.500  1086.430
   103.000  1090.176
   103.500  1093.913
   104.000  1097.642
   104.500  1101.361
   105.000  1105.072
   105.500  1108.774
   106.000  1112.467
   106.500  1116.151
   107.000  1119.826
   107.500  1123.492
   108.000  1127.149
   108.500  1130.796
   109.000  1134.435
   109.500  1138.064
   110.000  1141.684
   110.500  1145.295
   111.000  1148.896
   111.500  1152.488
   112.000  1156.071
   112.500  1159.645
   113.000  1163.210
   113.500  1166.765
   114.000  1170.311
   114.500  1173.849
   115.000  1177.377
   115.500  1180.896
   116.000  1184.406
   116.500  1187.907
   117.000  1191.399
   117.500  1194.882
   118.000  1198.356
   118.500  1201.821
   119.000  1205.276
   119.500  1208.723
   120.000  1212.160
   120.500  1215.588
   121.000  1219.007
   121.500  1222.416
   122.000  1225.816
   122.500  1229.208
   123.000  1232.589
   123.500  1235.962
   124.000  1239.326
   124.500  1242.681
   125.000  1246.027
   125.500  1249.363
   126.000  1252.691
   126.500  1256.010
   127.000  1259.320
   127.500  1262.621
   128.000  1265.913
   128.500  1269.196
   129.000  1272.471
   129.500  1275.736
   130.000  1278.992
   130.500  1282.240
   131.000  1285.478
   131.500  1288.707
   132.000  1291.927
   132.500  1295.139
   133.000  1298.341
   133.500  1301.534
   134.000  1304.718
   134.500  1307.893
   135.000  1311.059
   135.500  1314.216
   136.000  1317.364
   136.500  1320.502
   137.000  1323.632
   137.500  1326.753
   138.000  1329.864
   138.500  1332.967
   139.000  1336.060
   139.500  1339.144
   140.000  1342.219
   140.500  1345.285
   141.000  1348.342
   141.500  1351.391
   142.000  1354.429
   142.500  1357.459
   143.000  1360.480
   143.500  1363.492
   144.000  1366.495
   144.500  1369.488
   145.000  1372.473
   145.500  1375.448
   146.000  1378.414
   146.500  1381.370
   147.000  1384.318
   147.500  1387.256
   148.000  1390.185
   148.500  1393.104
   149.000  1396.014
   149.500  1398.914
   150.000  1401.805
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   822.315
   100.500   824.538
   101.000   826.761
   101.500   828.983
   102.000   831.206
   102.500   833.429
   103.000   835.652
   103.500   837.875
   104.000   840.098
   104.500   842.320
   105.000   844.543
   105.500   846.766
   106.000   848.989
   106.500   851.212
   107.000   853.435
   107.500   855.657
   108.000   857.880
   108.500   860.103
   109.000   862.326
   109.500   864.549
   110.000   866.772
   110.500   868.994
   111.000   871.217
   111.500   873.440
   112.000   875.663
   112.500   877.886
   113.000   880.109
   113.500   882.331
   114.000   884.554
   114.500   886.777
   115.000   889.000
   115.500   891.223
   116.000   893.446
   116.500   895.668
   117.000   897.891
   117.500   900.114
   118.000   902.337
   118.500   904.560
   119.000   906.783
   119.500   909.005
   120.000   911.228
   120.500   913.451
   121.000   915.674
   121.500   917.897
   122.000   920.120
   122.500   922.343
   123.000   924.565
   123.500   926.788
   124.000   929.011
   124.500   931.234
   125.000   933.457
   125.500   935.679
   126.000   937.902
   126.500   940.125
   127.000   942.348
   127.500   944.571
   128.000   946.794
   128.500   949.016
   129.000   951.239
   129.500   953.462
   130.000   955.685
   130.500   957.908
   131.000   960.131
   131.500   962.354
   132.000   964.576
   132.500   966.799
   133.000   969.022
   133.500   971.245
   134.000   973.468
   134.500   975.691
   135.000   977.913
   135.500   980.136
   136.000   982.359
   136.500   984.582
   137.000   986.805
   137.500   989.027
   138.000   991.250
   138.500   993.473
   139.000   995.696
   139.500   997.919
   140.000  1000.142
   140.500  1002.365
   141.000  1004.587
   141.500  1006.810
   142.000  1009.033
   142.500  1011.256
   143.000  1013.479
   143.500  1015.702
   144.000  1017.924
   144.500  1020.147
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   381.817
    15.000   392.054
    15.500   402.287
    16.000   412.512
    16.500   422.726
    17.000   432.924
    17.500   443.103
    18.000   453.257
    18.500   463.381
    19.000   473.198
    19.500   483.518
    20.000   493.519
    20.500   503.466
    21.000   513.354
    21.500   523.179
    22.000   532.934
    22.500   542.616
    23.000   550.926
    23.500   559.062
    24.000   567.165
    24.500   575.233
    25.000   583.254
    25.500   591.192
    26.000   599.101
    26.500   606.999
    27.000   614.889
    27.500   622.771
    28.000   630.647
    28.500   638.516
    29.000   646.379
    29.500   654.234
    30.000   662.083
    30.500   669.923
    31.000   677.753
    31.500   685.571
    32.000   693.376
    32.500   701.167
    33.000   708.942
    33.500   716.701
    34.000   724.441
    34.500   732.162
    35.000   739.865
    35.500   747.548
    36.000   755.211
    36.500   762.854
    37.000   770.477
    37.500   778.080
    38.000   785.661
    38.500   793.220
    39.000   800.757
    39.500   808.271
    40.000   815.763
    40.500   823.232
    41.000   830.677
    41.500   838.098
    42.000   845.496
    42.500   852.869
    43.000   860.218
    43.500   867.543
    44.000   874.842
    44.500   882.117
    45.000   889.367
    45.500   896.591
    46.000   903.789
    46.500   910.962
    47.000   918.109
    47.500   925.229
    48.000   932.323
    48.500   939.389
    49.000   946.429
    49.500   953.442
    50.000   960.428
    50.500   967.386
    51.000   974.318
    51.500   981.222
    52.000   988.098
    52.500   994.947
    53.000  1001.769
    53.500  1008.565
    54.000  1015.335
    54.500  1022.078
    55.000  1028.795
    55.500  1035.485
    56.000  1042.147
    56.500  1048.782
    57.000  1055.388
    57.500  1061.967
    58.000  1068.517
    58.500  1075.040
    59.000  1081.534
    59.500  1088.002
    60.000  1094.442
    60.500  1100.854
    61.000  1107.238
    61.500  1113.594
    62.000  1119.922
    62.500  1126.221
    63.000  1132.492
    63.500  1138.734
    64.000  1144.949
    64.500  1151.134
    65.000  1157.292
    65.500  1163.421
    66.000  1169.522
    66.500  1175.595
    67.000  1181.640
    67.500  1187.656
    68.000  1193.643
    68.500  1199.602
    69.000  1205.532
    69.500  1211.434
    70.000  1217.307
    70.500  1223.151
    71.000  1228.967
    71.500  1234.753
    72.000  1240.511
    72.500  1246.239
    73.000  1251.937
    73.500  1257.605
    74.000  1263.243
    74.500  1268.851
    75.000  1274.430
    75.500  1279.979
    76.000  1285.499
    76.500  1290.990
    77.000  1296.451
    77.500  1301.882
    78.000  1307.282
    78.500  1312.653
    79.000  1317.993
    79.500  1323.304
    80.000  1328.586
    80.500  1333.838
    81.000  1339.060
    81.500  1344.251
    82.000  1349.410
    82.500  1354.537
    83.000  1359.632
    83.500  1364.696
    84.000  1369.729
    84.500  1374.731
    85.000  1379.702
    85.500  1384.641
    86.000  1389.548
    86.500  1394.424
    87.000  1399.268
    87.500  1404.079
    88.000  1408.857
    88.500  1413.601
    89.000  1418.313
    89.500  1422.991
    90.000  1427.635
    90.500  1432.246
    91.000  1436.823
    91.500  1441.366
    92.000  1445.876
    92.500  1450.351
    93.000  1454.793
    93.500  1459.200
    94.000  1463.583
    94.500  1467.950
    95.000  1472.304
    95.500  1476.646
    96.000  1480.977
    96.500  1485.294
    97.000  1489.594
    97.500  1493.874
    98.000  1498.134
    98.500  1502.374
    99.000  1506.595
    99.500  1510.796
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   715.570
     1.000   715.616
     1.500   715.694
     2.000   715.803
     2.500   715.943
     3.000   716.115
     3.500   716.317
     4.000   716.550
     4.500   716.814
     5.000   717.109
     5.500   717.435
     6.000   717.791
     6.500   718.178
     7.000   718.596
     7.500   719.044
     8.000   719.522
     8.500   720.031
     9.000   720.569
     9.500   721.138
    10.000   721.736
    10.500   722.364
    11.000   723.022
    11.500   723.709
    12.000   724.425
    12.500   725.170
    13.000   725.944
    13.500   726.746
    14.000   727.577
    14.500   728.436
    15.000   729.324
    15.500   730.239
    16.000   731.182
    16.500   732.152
    17.000   733.150
    17.500   734.174
    18.000   735.226
    18.500   736.303
    19.000   737.408
    19.500   738.538
    20.000   739.693
    20.500   740.875
    21.000   742.081
    21.500   743.313
    22.000   744.569
    22.500   745.850
    23.000   747.155
    23.500   748.484
    24.000   749.836
    24.500   751.212
    25.000   752.611
    25.500   754.032
    26.000   755.476
    26.500   756.942
    27.000   758.430
    27.500   759.939
    28.000   761.470
    28.500   763.021
    29.000   764.593
    29.500   766.186
    30.000   767.798
    30.500   769.430
    31.000   771.081
    31.500   772.751
    32.000   774.440
    32.500   776.147
    33.000   777.872
    33.500   779.615
    34.000   781.375
    34.500   783.152
    35.000   784.946
    35.500   786.756
    36.000   788.582
    36.500   790.424
    37.000   792.281
    37.500   794.153
    38.000   796.039
    38.500   797.941
    39.000   799.856
    39.500   801.784
    40.000   803.726
    40.500   805.681
    41.000   807.649
    41.500   809.629
    42.000   811.621
    42.500   813.625
    43.000   815.640
    43.500   817.665
    44.000   819.702
    44.500   821.749
    45.000   823.806
    45.500   825.872
    46.000   827.948
    46.500   830.033
    47.000   832.127
    47.500   834.229
    48.000   836.339
    48.500   838.457
    49.000   840.582
    49.500   842.714
    50.000   844.853
    50.500   846.999
    51.000   849.151
    51.500   851.309
    52.000   853.473
    52.500   855.642
    53.000   857.816
    53.500   859.994
    54.000   862.178
    54.500   864.365
    55.000   866.557
    55.500   868.752
    56.000   870.950
    56.500   873.152
    57.000   875.357
    57.500   877.564
    58.000   879.774
    58.500   881.987
    59.000   884.201
    59.500   886.417
    60.000   888.634
    60.500   890.853
    61.000   893.073
    61.500   895.294
    62.000   897.516
    62.500   899.738
    63.000   901.961
    63.500   904.183
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   927.624
     1.000   927.690
     1.500   927.801
     2.000   927.956
     2.500   928.156
     3.000   928.399
     3.500   928.687
     4.000   929.019
     4.500   929.395
     5.000   929.815
     5.500   930.279
     6.000   930.787
     6.500   931.338
     7.000   931.933
     7.500   932.572
     8.000   933.254
     8.500   933.979
     9.000   934.747
     9.500   935.559
    10.000   936.413
    10.500   937.310
    11.000   938.249
    11.500   939.231
    12.000   940.255
    12.500   941.321
    13.000   942.429
    13.500   943.578
    14.000   944.768
    14.500   946.000
    15.000   947.273
    15.500   948.586
    16.000   949.940
    16.500   951.334
    17.000   952.768
    17.500   954.242
    18.000   955.755
    18.500   957.308
    19.000   958.900
    19.500   960.530
    20.000   962.199
    20.500   963.906
    21.000   965.651
    21.500   967.433
    22.000   969.253
    22.500   971.109
    23.000   973.003
    23.500   974.933
    24.000   976.899
    24.500   978.900
    25.000   980.938
    25.500   983.010
    26.000   985.117
    26.500   987.259
    27.000   989.435
    27.500   991.645
    28.000   993.889
    28.500   996.166
    29.000   998.476
    29.500  1000.818
    30.000  1003.193
    30.500  1005.599
    31.000  1008.037
    31.500  1010.507
    32.000  1013.007
    32.500  1015.538
    33.000  1018.100
    33.500  1020.691
    34.000  1023.311
    34.500  1025.961
    35.000  1028.640
    35.500  1031.348
    36.000  1034.084
    36.500  1036.847
    37.000  1039.638
    37.500  1042.457
    38.000  1045.302
    38.500  1048.174
    39.000  1051.072
    39.500  1053.996
    40.000  1056.946
    40.500  1059.920
    41.000  1062.920
    41.500  1065.944
    42.000  1068.992
    42.500  1072.064
    43.000  1075.160
    43.500  1078.279
    44.000  1081.421
    44.500  1084.586
    45.000  1087.773
    45.500  1090.982
    46.000  1094.212
    46.500  1097.464
    47.000  1100.736
    47.500  1104.030
    48.000  1107.344
    48.500  1110.678
    49.000  1114.031
    49.500  1117.405
    50.000  1120.797
    50.500  1124.208
    51.000  1127.638
    51.500  1131.086
    52.000  1134.552
    52.500  1138.036
    53.000  1141.537
    53.500  1145.055
    54.000  1148.590
    54.500  1152.141
    55.000  1155.709
    55.500  1159.293
    56.000  1162.893
    56.500  1166.508
    57.000  1170.138
    57.500  1173.783
    58.000  1177.442
    58.500  1181.116
    59.000  1184.804
    59.500  1188.506
    60.000  1192.222
    60.500  1195.951
    61.000  1199.693
    61.500  1203.448
    62.000  1207.215
    62.500  1210.995
    63.000  1214.786
    63.500  1218.590
    64.000  1222.405
    64.500  1226.232
    65.000  1230.070
    65.500  1233.919
    66.000  1237.778
    66.500  1241.648
    67.000  1245.528
    67.500  1249.418
    68.000  1253.318
    68.500  1257.228
    69.000  1261.147
    69.500  1265.075
    70.000  1269.012
    70.500  1272.958
    71.000  1276.912
    71.500  1280.875
    72.000  1284.846
    72.500  1288.825
    73.000  1292.811
    73.500  1296.805
    74.000  1300.807
    74.500  1304.815
    75.000  1308.831
    75.500  1312.853
    76.000  1316.882
    76.500  1320.918
    77.000  1324.960
    77.500  1329.007
    78.000  1333.061
    78.500  1337.120
    79.000  1341.186
    79.500  1345.256
    80.000  1349.332
    80.500  1353.412
    81.000  1357.498
    81.500  1361.588
    82.000  1365.683
    82.500  1369.782
    83.000  1373.886
    83.500  1377.994
    84.000  1382.105
    84.500  1386.221
    85.000  1390.340
    85.500  1394.463
    86.000  1398.589
    86.500  1402.719
    87.000  1406.851
    87.500  1410.987
    88.000  1415.125
    88.500  1419.266
    89.000  1423.410
    89.500  1427.556
    90.000  1431.704
    90.500  1435.855
    91.000  1440.007
    91.500  1444.162
    92.000  1448.318
    92.500  1452.476
    93.000  1456.636
    93.500  1460.797
    94.000  1464.959
    94.500  1469.123
    95.000  1473.288
    95.500  1477.454
    96.000  1481.621
    96.500  1485.788
    97.000  1489.957
    97.500  1494.125
    98.000  1498.295
    98.500  1502.465
    99.000  1506.635
    99.500  1510.805
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    28.500   759.531
    29.000   769.771
    29.500   780.010
    30.000   790.248
    30.500   800.484
    31.000   810.716
    31.500   820.946
    32.000   831.171
    32.500   841.390
    33.000   851.604
    33.500   861.810
    34.000   872.008
    34.500   882.197
    35.000   892.376
    35.500   902.542
    36.000   912.696
    36.500   922.835
    37.000   932.959
    37.500   943.066
    38.000   953.155
    38.500   963.223
    39.000   973.270
    39.500   983.294
    40.000   993.293
    40.500  1003.267
    41.000  1013.212
    41.500  1023.130
    42.000  1033.016
    42.500  1042.871
    43.000  1052.694
    43.500  1062.482
    44.000  1072.235
    44.500  1081.951
    45.000  1091.630
    45.500  1100.644
    46.000  1108.810
    46.500  1116.959
    47.000  1125.092
    47.500  1133.208
    48.000  1141.308
    48.500  1149.392
    49.000  1157.457
    49.500  1165.501
    50.000  1173.518
    50.500  1181.492
    51.000  1189.417
    51.500  1197.331
    52.000  1205.239
    52.500  1213.141
    53.000  1221.038
    53.500  1228.931
    54.000  1236.820
    54.500  1244.706
    55.000  1252.588
    55.500  1260.466
    56.000  1268.341
    56.500  1276.213
    57.000  1284.081
    57.500  1291.947
    58.000  1299.809
    58.500  1307.667
    59.000  1315.522
    59.500  1323.374
    60.000  1331.221
    60.500  1339.065
    61.000  1346.904
    61.500  1354.738
    62.000  1362.567
    62.500  1370.391
    63.000  1378.208
    63.500  1386.018
    64.000  1393.823
    64.500  1401.620
    65.000  1409.409
    65.500  1417.191
    66.000  1424.965
    66.500  1432.730
    67.000  1440.486
    67.500  1448.234
    68.000  1455.972
    68.500  1463.701
    69.000  1471.421
    69.500  1479.132
    70.000  1486.832
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     1.609    43.988     0.150
     2.322    34.648     0.150
     2.582    39.309     0.150
     3.081    45.180     0.150
     3.421    49.172     0.150
    10.937   154.910     0.150
    12.433   177.012     0.150
    16.925   231.109     0.150
    17.087   238.109     0.150
    17.691   247.910     0.150
    18.369   255.910     0.150
    26.837   663.910     0.150
    31.330   380.809     0.150
    31.330    10.102     0.150
    31.330   689.910     0.150
    39.941  1285.910     0.150
    44.509   490.910     0.150
    48.225   518.910     0.150
    48.225    10.000     0.150
    48.225    14.000     0.150
    48.225   681.910     0.150
    48.225   941.910     0.150
    48.225   945.910     0.150
    53.336   558.109     0.150
    56.394   579.910     0.150
    56.394    13.102     0.150
    58.936    17.000     0.150
    58.936   597.910     0.150
    58.936     8.000     0.150
    58.936    17.000     0.150
    66.703   649.910     0.150
    72.212     6.000     0.150
    72.705   698.211     0.150
    74.066  1265.910     0.150
    74.274   699.910     0.150
    74.602   698.512     0.150
    74.602   712.910     0.150
    74.602   698.512     0.150
    74.602   712.910     0.150
    74.817   700.910     0.150
    74.817   700.910     0.150
    74.837   700.910     0.150
    75.249   731.910     0.150
    75.249  4301.910     0.150
    75.411   703.012     0.150
    76.214   708.410     0.150
    76.214   722.910     0.150
    76.732   711.910     0.150
    76.732     7.898     0.150
    77.496     6.402     0.150
    78.529   749.910     0.150
    79.483   743.910     0.150
    79.483   750.910     0.150
    79.483   761.910     0.150
    79.639   757.910     0.150
    83.612   753.910     0.150
    90.493   787.711     0.150
     1.434    22.152     0.150
     2.214    32.723     0.150
     3.014    47.141     0.150
     3.448    50.793     0.150
     3.656    52.281     0.150
     4.541    68.352     0.150
     6.554    96.551     0.150
     7.253   109.293     0.150
     7.556   111.043     0.150
    15.080   211.723     0.150
    18.270   252.703     0.150
    18.606   258.621     0.150
    65.156   641.922     0.150
    83.760   750.023     0.150
     0.394    14.369     0.150
     0.394     8.250     0.150
     0.394    14.150     0.150
     0.970    22.850     0.150
     0.970    37.250     0.150
     1.188    25.789     0.150
     1.405    41.551     0.150
     1.367    31.189     0.150
     1.449    45.000     0.150
     1.601    26.359     0.150
     1.601    50.000     0.150
     1.620    50.750     0.150
     1.693    34.381     0.150
     1.741    41.730     0.150
     1.806    56.090     0.150
     1.856    34.000     0.150
     1.856    59.461     0.150
     1.925    59.381     0.150
     1.930    23.449     0.150
    12.841   182.150     0.150
    14.607   208.730     0.150
    15.735   220.311     0.150
    16.984   236.990     0.150
    62.076   625.266     0.150
     0.681    12.891     0.150
     1.246    24.195     0.150
     1.246   -11.273     0.150
     1.811    51.070     0.150
     2.081    58.570     0.150
     2.655    41.797     0.150
     2.973    51.312     0.150
     3.461    57.711     0.150
     4.268   109.789     0.150
     6.079   110.438     0.150
     8.836   124.188     0.150
     8.991   127.117     0.150
     9.974   140.812     0.150
    10.184   142.969     0.150
    10.295   145.070     0.150
    10.557   149.016     0.150
    12.203   177.812     0.150
    12.437   180.781     0.150
    16.040   221.938     0.150
    21.116   284.039     0.150
    64.611   631.336     0.150
    73.907   699.641     0.150
    74.359   701.742     0.150
    74.361   703.938     0.150
    74.410   701.836     0.150
    74.587   702.641     0.150
    74.599   702.336     0.150
    74.640   704.742     0.150
    74.640   704.742     0.150
    74.885   704.242     0.150
    75.174   705.641     0.150
    75.325   705.539     0.150
    75.701   710.242     0.150
    75.829   935.039     0.150
    76.638   713.141     0.150
    76.898   717.242     0.150
    77.098   717.742     0.150
    77.577   721.336     0.150
     0.238     6.250     0.150
     0.238    10.930     0.150
     0.644    12.859     0.150
     0.994    16.109     0.150
     1.736    31.609     0.150
     1.801    52.371     0.150
     1.906    54.309     0.150
     1.935    58.598     0.150
     1.959    56.488     0.150
     2.342    70.801     0.150
     2.465    39.480     0.150
     2.465    76.328     0.150
     2.709    45.879     0.150
     2.709    75.258     0.150
     2.679    77.180     0.150
     2.948    85.098     0.150
     3.459   102.730     0.150
     5.405   150.668     0.150
     5.553    78.078     0.150
     7.178   105.781     0.150
     7.571   119.758     0.150
     7.955   112.320     0.150
     8.535   123.879     0.150
    14.978   206.578     0.150
     0.566     2.492     0.150
     0.566     9.305     0.150
     1.618    24.922     0.150
     2.445    37.406     0.150
     2.498    35.977     0.150
     3.125    45.406     0.150
     3.553    53.047     0.150
     5.501    89.000     0.150
     0.791    25.211     0.150
     1.282    20.691     0.150
     1.439    23.002     0.150
     1.538    24.711     0.150
     1.638    46.711     0.150
     1.946    39.391     0.150
     2.309    35.402     0.150
     2.309    61.131     0.150
     2.692    41.141     0.150
     2.923    43.682     0.150
     2.976    45.242     0.150
     2.976    78.262     0.150
     3.027    83.842     0.150
     3.080    84.342     0.150
     3.065    37.092     0.150
     3.065    70.811     0.150
     3.746    56.961     0.150
     3.705    89.711     0.150
     4.069   110.342     0.150
     4.190    68.711     0.150
     4.190   114.762     0.150
     4.701    72.152     0.150
     5.018    74.922     0.150
     5.018   126.791     0.150
     5.018    72.561     0.150
     5.358   141.092     0.150
     7.125   104.270     0.150
     9.330   239.916     0.150
     9.330   240.322     0.150
     9.330   134.822     0.150
     9.330   239.912     0.150
     9.319   137.852     0.150
    11.107   157.512     0.150
    14.211   204.791     0.150
    15.178   211.387     0.150
    15.178   211.381     0.150
    15.231   212.221     0.150
    15.231   212.242     0.150
    15.231   211.861     0.150
    16.145   241.361     0.150
    16.145   231.311     0.150
    16.785   231.332     0.150
    19.357   266.111     0.150
    20.582   278.021     0.150
    21.776   292.092     0.150
    32.666   392.980     0.150
    67.424   659.441     0.150
    67.712   657.162     0.150
    79.742   733.242     0.150
    80.864   733.211     0.150
     0.799    25.555     0.150
     1.256    21.523     0.150
     1.297    20.445     0.150
     1.556    43.375     0.150
     1.795    48.914     0.150
     1.964    40.086     0.150
     2.327    37.434     0.150
     3.083    36.816     0.150
     3.083    71.094     0.150
     3.722    60.934     0.150
     4.386    69.254     0.150
     4.626   117.285     0.150
     4.713   119.766     0.150
     6.532    94.855     0.150
     7.144   104.625     0.150
     7.660   114.094     0.150
    12.405   181.746     0.150
    15.183   211.516     0.150
    15.236   212.613     0.150
    15.236   212.406     0.150
    16.799   236.445     0.150
    17.206   242.234     0.150
    18.256   257.633     0.150
    18.373   256.113     0.150
    76.190     4.301     0.150
    76.190    13.000     0.150
     0.777    14.520     0.150
     1.257    21.051     0.150
     1.257    35.551     0.150
     2.438    41.840     0.150
     2.438    73.309     0.150
     2.798    84.012     0.150
     2.820    39.238     0.150
     2.820    78.840     0.150
     3.095    49.641     0.150
     3.347    54.301     0.150
     3.435    52.840     0.150
     3.688    55.141     0.150
     3.766    59.000     0.150
     4.562    67.230     0.150
    16.395   225.969     0.150
     0.744    24.273     0.150
     0.902    15.594     0.150
     1.259    34.953     0.150
     1.280    40.742     0.150
     2.056    32.723     0.150
     2.409    41.102     0.150
     2.498    40.844     0.150
     2.498    76.094     0.150
     2.625    43.074     0.150
     2.793    39.641     0.150
     2.793    75.922     0.150
     2.857    84.574     0.150
     3.045    49.121     0.150
     4.705    64.223     0.150
     5.294   164.211     0.150
     7.244   226.051     0.150
     8.389   126.094     0.150
    10.634   150.703     0.150
    15.382   213.812     0.150
    20.148   272.871     0.150
     0.319     7.148     0.150
     0.825    13.898     0.150
     2.319    64.047     0.150
     3.854    56.727     0.150
     3.854    99.570     0.150
     3.854   118.227     0.150
     7.770   191.719     0.150
    10.848   151.707     0.150
    10.848   158.070     0.150
    15.171   209.242     0.150
     2.788    42.480     0.150
     4.908   122.168     0.150
    59.467  4471.848     0.150
    59.468  4472.465     0.150
    59.484  4472.184     0.150
    60.478  4550.859     0.150
    60.488  4548.039     0.150
    60.496  4550.285     0.150
     0.911    28.906     0.150
     0.784    13.247     0.150
     1.142    33.667     0.150
     1.529    25.896     0.150
     1.720    29.086     0.150
     2.252    39.707     0.150
     0.278    13.207     0.150
     0.645    11.837     0.150
     0.888    15.016     0.150
     1.007    16.937     0.150
     1.359    21.986     0.150
     1.398    22.057     0.150
     1.518    47.866     0.150
     1.518    24.047     0.150
     1.905    35.516     0.150
     1.953    29.707     0.150
     1.953    34.896     0.150
     1.953    63.077     0.150
     2.088    52.077     0.150
     2.086    34.457     0.150
     2.822    72.856     0.150
     2.889    43.866     0.150
     2.994    52.097     0.150
     2.994    92.097     0.150
     3.004    52.587     0.150
     3.006    90.727     0.150
     3.152    54.036     0.150
     3.513    60.297     0.150
     3.606   111.467     0.150
     4.187    73.876     0.150
     4.187   127.556     0.150
     4.215   108.787     0.150
     4.746   118.096     0.150
     5.197   163.027     0.150
     5.544    78.467     0.150
     6.901    97.187     0.150
     0.503    15.781     0.150
     0.878    15.062     0.150
     1.437    22.719     0.150
     1.547    47.648     0.150
     1.991    31.039     0.150
     2.314    76.703     0.150
     2.434    77.648     0.150
     2.548    37.984     0.150
     2.880    76.211     0.150
     2.957    43.812     0.150
     3.527    52.703     0.150
     3.608    54.883     0.150
     4.095    65.508     0.150
     4.445    64.711     0.150
     4.445    65.164     0.150
     4.445    65.164     0.150
     4.598    70.273     0.150
     4.606    68.680     0.150
     4.933    72.164     0.150
     5.799    87.500     0.150
     5.989    95.203     0.150
     6.721    91.633     0.150
     6.721  1657.961     0.150
     6.723   184.164     0.150
     6.723   184.164     0.150
     7.518   107.305     0.150
     8.099   116.023     0.150
     8.255   117.391     0.150
     8.252   121.859     0.150
     8.579   122.109     0.150
     8.699   123.570     0.150
     8.845   125.281     0.150
     8.949   127.062     0.150
     8.949   126.469     0.150
     9.131   131.562     0.150
     9.131   131.594     0.150
     9.207   130.094     0.150
     9.207   129.430     0.150
     9.238   237.164     0.150
     9.238   280.273     0.150
     9.238   237.164     0.150
     9.357   132.961     0.150
     9.357   132.078     0.150
     9.379   137.664     0.150
     9.470   133.562     0.150
     9.470   133.570     0.150
     9.620   135.859     0.150
     9.842   301.578     0.150
    10.126   143.320     0.150
    10.343   145.898     0.150
    10.534   149.656     0.150
    10.534   149.461     0.150
    10.551   148.922     0.150
    10.607   149.438     0.150
    10.613   154.102     0.150
    10.661   150.500     0.150
    10.761   151.352     0.150
    10.956   153.734     0.150
    11.070   156.508     0.150
    11.167   157.305     0.150
    11.167   156.758     0.150
    11.167   156.773     0.150
    11.374   164.930     0.150
    11.586   163.375     0.150
    11.586   163.000     0.150
    11.640   164.062     0.150
    11.825   167.211     0.150
    12.009   169.852     0.150
    12.024   168.961     0.150
    12.166   172.148     0.150
    12.136   174.320     0.150
    12.241   170.180     0.150
    12.342   173.984     0.150
    12.385   176.555     0.150
    12.415   175.039     0.150
    12.483   171.344     0.150
    12.612   178.070     0.150
    12.673   183.312     0.150
    12.875   181.453     0.150
    12.875   181.000     0.150
    13.245   415.078     0.150
    13.692   193.734     0.150
    13.876  2359.109     0.150
    14.261   199.430     0.150
    14.730   210.203     0.150
    14.785   205.711     0.150
    14.796   205.211     0.150
    14.797   205.562     0.150
    14.810   205.438     0.150
    14.815   204.969     0.150
    14.822   206.352     0.150
    14.835   205.711     0.150
    14.835   206.305     0.150
    14.847   206.430     0.150
    14.853   206.133     0.150
    14.833   212.258     0.150
    14.859   206.570     0.150
    14.872   206.453     0.150
    14.872   203.484     0.150
    14.872   206.633     0.150
    14.885   206.922     0.150
    14.891   206.867     0.150
    14.910   206.859     0.150
    14.926   206.914     0.150
    14.926   204.648     0.150
    14.929   207.031     0.150
    14.947   207.180     0.150
    14.966   207.461     0.150
    15.118   210.367     0.150
    15.118   209.680     0.150
    15.108   215.648     0.150
    15.233   215.758     0.150
    15.250   218.273     0.150
    15.694   221.688     0.150
    15.987   227.789     0.150
    15.987   227.414     0.150
    16.039   228.531     0.150
    16.146   227.234     0.150
    16.185   229.523     0.150
    16.346   222.562     0.150
    16.346   222.539     0.150
    16.568   233.852     0.150
    16.578   234.930     0.150
    16.671   229.539     0.150
    16.671   230.062     0.150
    16.671   229.219     0.150
    16.921   237.172     0.150
    17.196   240.258     0.150
    17.836   248.602     0.150
    18.347   255.562     0.150
    18.427   257.578     0.150
    18.471   257.750     0.150
    18.587   258.062     0.150
    18.637   260.242     0.150
    18.701   260.602     0.150
    18.719   260.625     0.150
    18.719   260.422     0.150
    19.255   610.812     0.150
    20.140   494.242     0.150
    20.140   623.188     0.150
    20.461   279.391     0.150
    20.792   281.383     0.150
    20.960   284.055     0.150
    20.995   284.758     0.150
    22.228   296.664     0.150
    22.228   296.258     0.150
    22.228   296.289     0.150
    25.458   327.859     0.150
    26.184   334.070     0.150
    26.836  2302.188     0.150
    27.956   350.000     0.150
    27.978   350.258     0.150
    27.978   350.211     0.150
    28.184   351.969     0.150
    28.380   353.648     0.150
    28.756   357.570     0.150
    28.782   893.383     0.150
    30.002   369.055     0.150
    31.168   377.844     0.150
    32.211   388.578     0.150
    34.305   405.258     0.150
    35.577   416.633     0.150
    36.871   430.070     0.150
    36.897    11.102     0.150
    36.897   517.961     0.150
    36.897   532.758     0.150
    36.897   956.062     0.150
    37.099   429.359     0.150
    37.435   432.117     0.150
    37.430   434.211     0.150
    37.892   452.062     0.150
    37.892   435.961     0.150
    38.509   441.031     0.150
    38.721   442.922     0.150
    40.916   463.258     0.150
    44.978   495.359     0.150
    45.787   502.258     0.150
    49.687   532.258     0.150
    52.353   549.883     0.150
    52.620   553.992     0.150
    56.587   594.961     0.150
    56.587   714.461     0.150
    56.587   787.961     0.150
    57.649   589.422     0.150
    58.565   814.758     0.150
    59.087  4428.859     0.150
    59.512   603.859     0.150
    59.692   602.805     0.150
    59.668  4498.820     0.150
    59.669  4498.922     0.150
    59.685  4500.055     0.150
    60.678  4568.523     0.150
    60.688  4569.164     0.150
    60.696  4569.969     0.150
    62.467   621.359     0.150
    62.699   624.289     0.150
    63.361   627.914     0.150
    64.959   638.758     0.150
    64.992     5.797     0.150
    64.992     8.898     0.150
    65.656   642.359     0.150
    65.656   642.391     0.150
    65.725   651.164     0.150
    65.789   644.961     0.150
    66.037  2869.211     0.150
    66.182   646.562     0.150
    66.712   658.023     0.150
    66.826  5020.859     0.150
    67.307   655.312     0.150
    67.635    10.594     0.150
    68.475   661.859     0.150
    69.479  5219.961     0.150
    69.568  5226.758     0.150
    69.638  5226.164     0.150
    69.671  5233.359     0.150
    70.012   671.758     0.150
    70.271   673.461     0.150
    70.427   835.961     0.150
    70.427   934.359     0.150
    70.427  2356.391     0.150
    70.427   675.461     0.150
    71.147   686.359     0.150
    71.147   678.359     0.150
    71.147   686.359     0.150
    71.102   678.664     0.150
    71.102   834.484     0.150
    72.415   687.070     0.150
    72.485  1544.898     0.150
    72.485  1744.438     0.150
    72.497  5443.461     0.150
    72.686   687.898     0.150
    72.686  2895.641     0.150
    73.392   691.961     0.150
    73.392     8.203     0.150
    73.392   707.359     0.150
    73.392  1263.461     0.150
    73.510   692.539     0.150
    73.821     2.000     0.150
    73.821   873.961     0.150
    73.821   967.961     0.150
    73.821  1751.961     0.150
    73.999   694.859     0.150
    73.999  1269.664     0.150
    74.095   695.961     0.150
    74.095   711.664     0.150
    74.095   726.961     0.150
    74.095   768.961     0.150
    74.095   963.961     0.150
    74.095  1593.961     0.150
    74.095  1749.961     0.150
    74.095  1791.961     0.150
    74.095  1821.961     0.150
    74.271   697.055     0.150
    74.387   696.961     0.150
    74.387   975.961     0.150
    74.387  1767.961     0.150
    74.387  2207.961     0.150
    74.387  2213.961     0.150
    74.387   696.961     0.150
    74.387   703.961     0.150
    74.387   975.961     0.150
    74.387  1271.961     0.150
    74.387  1305.961     0.150
    74.461  1755.258     0.150
    74.461   697.250     0.150
    74.492  1320.961     0.150
    74.743   705.898     0.150
    74.743   730.344     0.150
    74.743   743.703     0.150
    74.743   772.398     0.150
    74.743   868.961     0.150
    74.743   699.961     0.150
    74.743   705.859     0.150
    74.743   868.961     0.150
    74.743  1566.961     0.150
    74.909   700.461     0.150
    74.909   706.461     0.150
    74.909  1280.859     0.150
    74.997   700.211     0.150
    74.946     6.000     0.150
    74.946     8.000     0.150
    74.967   700.969     0.150
    75.044   701.422     0.150
    75.071  5638.359     0.150
    75.225   702.461     0.150
    75.225   871.961     0.150
    75.225  1285.164     0.150
    75.225  1573.758     0.150
    75.373   703.359     0.150
    75.388   704.164     0.150
    75.388     7.898     0.150
    75.388  1286.359     0.150
    75.541   704.758     0.150
    75.541  1288.461     0.150
    75.604   704.961     0.150
    75.604  1289.062     0.150
    75.604  1580.664     0.150
    75.623   704.562     0.150
    75.623   710.664     0.150
    75.623   874.562     0.150
    75.623  1289.461     0.150
    75.708  1584.859     0.150
    75.708   705.562     0.150
    75.708  1290.258     0.150
    75.842   706.562     0.150
    75.842  1292.758     0.150
    75.847   706.164     0.150
    75.847   879.562     0.150
    75.847  1292.164     0.150
    76.022   709.531     0.150
    76.217   708.461     0.150
    76.222   708.461     0.150
    76.222   885.562     0.150
    76.222  1296.062     0.150
    76.222  1592.461     0.150
    76.370     6.000     0.150
    76.370  1293.562     0.150
    76.515   709.164     0.150
    76.594   710.961     0.150
    76.594  1595.664     0.150
    76.631   710.164     0.150
    76.631  1294.664     0.150
    76.685   709.992     0.150
    76.769   709.711     0.150
    76.779   711.164     0.150
    76.779  1300.859     0.150
    76.779  1599.664     0.150
    76.823   710.531     0.150
    76.877   712.617     0.150
    76.882   711.414     0.150
    77.259   714.477     0.150
    77.541   721.062     0.150
    77.541  1366.062     0.150
    77.688   717.258     0.150
    77.688   725.359     0.150
    77.688  1311.461     0.150
    77.710   716.781     0.150
    77.740   717.562     0.150
    77.740   725.258     0.150
    77.769   716.562     0.150
    77.769  1307.062     0.150
    77.821   718.758     0.150
    77.821   724.062     0.150
    77.909   718.164     0.150
    77.909   723.758     0.150
    77.879   715.914     0.150
    78.000  1309.758     0.150
    78.000   718.164     0.150
    78.000  1309.758     0.150
    78.034   718.961     0.150
    78.034  1314.758     0.150
    78.112   718.344     0.150
    78.195   719.461     0.150
    78.195   724.758     0.150
    78.195  1314.664     0.150
    78.278   718.453     0.150
    78.441   720.961     0.150
    78.441   729.461     0.150
    78.441  1315.664     0.150
    78.606   722.062     0.150
    78.606   727.961     0.150
    78.544     4.406     0.150
    78.878   722.703     0.150
    78.991   723.562     0.150
    78.991   724.562     0.150
    78.991   723.531     0.150
    79.378   724.281     0.150
    79.512     6.000     0.150
    79.977   734.859     0.150
    80.864   732.969     0.150
    80.920   733.664     0.150
    81.777  1079.961     0.150
    81.777   737.961     0.150
    81.777   919.961     0.150
    81.777  1351.961     0.150
    82.314   741.602     0.150
    82.523   743.602     0.150
    82.657   743.172     0.150
    83.350   755.961     0.150
    83.402   760.961     0.150
    83.462   757.164     0.150
    83.473     6.203     0.150
    83.564  1854.484     0.150
    83.649     8.500     0.150
    84.652   761.359     0.150
    84.797   753.758     0.150
    84.988   764.961     0.150
    85.252   958.461     0.150
    85.566  1391.859     0.150
    86.210   767.961     0.150
    86.633   763.422     0.150
    86.633   763.945     0.150
    86.612   767.859     0.150
    86.612   762.969     0.150
    86.717  1947.461     0.150
    86.817   759.062     0.150
    86.896   969.039     0.150
    87.808   776.109     0.150
    87.905   775.062     0.150
    87.946   769.500     0.150
    87.932  1089.359     0.150
    88.051   771.062     0.150
    88.129     5.898     0.150
    88.129    11.594     0.150
    88.961   779.961     0.150
    89.001   775.461     0.150
    89.088   783.961     0.150
    89.162     8.102     0.150
    89.162    10.602     0.150
    89.227   777.562     0.150
    89.291   777.164     0.150
    89.322   777.664     0.150
    89.394   777.031     0.150
    89.394   777.883     0.150
    89.462   782.562     0.150
    89.610   768.961     0.150
    90.074   784.758     0.150
    90.276   771.164     0.150
    90.574   784.078     0.150
    90.602     8.297     0.150
    90.678   787.164     0.150
    90.751   793.961     0.150
    92.131   795.164     0.150
    92.334   795.164     0.150
    93.562   802.664     0.150
    93.562     9.797     0.150
    93.562    16.500     0.150
    93.829   803.969     0.150
    94.198     7.000     0.150
    94.198    10.500     0.150
    94.198   800.555     0.150
    94.253   807.352     0.150
    95.224   803.703     0.150
    95.249     6.703     0.150
    95.686   813.352     0.150
    95.706   814.094     0.150
    96.225   815.219     0.150
    96.349   816.789     0.150
    97.033   820.078     0.150
   100.761   835.633     0.150
   100.761   835.633     0.150
   110.319  1113.812     0.150
   110.332  1331.008     0.150
   114.190  1119.289     0.150
   114.190  1764.359     0.150
   118.563  1128.211     0.150
   123.854  1138.555     0.150
   130.113  1355.312     0.150
   130.113  1281.164     0.150
   130.113  1151.742     0.150
   130.113  1152.094     0.150
   130.113  1281.133     0.150
   130.113  1355.312     0.150
   130.113  1367.234     0.150
   130.314  1149.891     0.150
   133.814  1364.633     0.150
   133.814  1371.383     0.150
   139.178  1158.469     0.150
   140.492  1163.680     0.150
   146.566  1392.664     0.150
   146.566  1177.461     0.150
   146.566  1392.648     0.150
   147.728  1183.680     0.150
   149.383  1186.258     0.150
   150.453  1187.688     0.150
   150.453  1191.602     0.150
   151.341  1415.758     0.150
   161.026  1240.953     0.150
     0.451     9.250     0.150
     0.938    28.125     0.150
     1.390    23.039     0.150
     1.459    23.305     0.150
     2.095    34.195     0.150
     8.433   126.492     0.150
     8.507   129.234     0.150
     8.938   134.961     0.150
    18.678   458.719     0.150
     1.341    27.437     0.150
     1.425    28.776     0.150
     2.054    33.757     0.150
     2.696    41.486     0.150
     4.166    60.767     0.150
     4.663    71.977     0.150
    59.686  4489.606     0.150
    59.687  4492.204     0.150
    59.702  4491.591     0.150
    60.696  4567.724     0.150
    60.705  4570.696     0.150
    60.714  4574.173     0.150
     2.896    43.695     0.150
     3.517    53.918     0.150
     4.399    67.188     0.150
     4.680    72.586     0.150
    59.673  4493.863     0.150
    59.674  4492.832     0.150
    59.689  4500.223     0.150
    60.682  4572.605     0.150
    60.692  4575.973     0.150
    60.701  4577.598     0.150
     0.456     8.028     0.150
     0.456    14.828     0.150
     0.629    11.528     0.150
     0.629    20.078     0.150
     0.778    24.009     0.150
     0.784    13.479     0.150
     0.784    24.588     0.150
     0.792    13.519     0.150
     0.792    13.519     0.150
     0.792    24.679     0.150
     0.806    24.528     0.150
     0.806    13.668     0.150
     0.806    24.528     0.150
     0.993    17.078     0.150
     0.993    30.248     0.150
     1.046    17.778     0.150
     1.060    17.688     0.150
     1.060    31.679     0.150
     1.148    36.378     0.150
     1.165    20.049     0.150
     1.165    20.049     0.150
     1.165    36.568     0.150
     1.163    19.769     0.150
     1.165    19.618     0.150
     1.165    33.498     0.150
     1.266    21.448     0.150
     1.266    38.729     0.150
     1.343    23.019     0.150
     1.343    23.019     0.150
     1.302    22.938     0.150
     1.311    22.259     0.150
     1.311    38.578     0.150
     1.362    24.719     0.150
     1.379    37.438     0.150
     1.383    23.998     0.150
     1.441    24.628     0.150
     1.441    43.648     0.150
     1.538    28.238     0.150
     1.501    25.378     0.150
     1.501    44.519     0.150
     1.525    25.969     0.150
     1.525    45.559     0.150
     1.585    28.088     0.150
     1.585    28.088     0.150
     1.576    26.588     0.150
     1.576    47.418     0.150
     1.726    28.269     0.150
     1.726    48.648     0.150
     1.728    27.818     0.150
     1.728    52.599     0.150
     1.728    27.818     0.150
     1.728    52.599     0.150
     1.780    31.929     0.150
     1.780    56.038     0.150
     1.908    38.498     0.150
     1.834    30.769     0.150
     1.834    54.969     0.150
     1.978    32.038     0.150
     2.013    33.019     0.150
     2.013    60.788     0.150
     2.063    34.378     0.150
     2.217    42.538     0.150
     2.207    38.538     0.150
     2.228    35.488     0.150
     2.228    35.488     0.150
     2.287    37.918     0.150
     2.308    37.889     0.150
     2.308    37.889     0.150
     2.297    36.729     0.150
     2.534    44.328     0.150
     2.557    47.078     0.150
     2.557    70.208     0.150
     2.569    39.198     0.150
     2.569    39.198     0.150
     2.641    44.198     0.150
     2.703    42.488     0.150
     3.007    50.148     0.150
     3.088    77.648     0.150
     3.088    48.738     0.150
     0.132     3.766     0.150
     0.132     5.936     0.150
     0.152     3.926     0.150
     0.152     6.266     0.150
     0.219     4.865     0.150
     0.219     7.904     0.150
     0.388     7.414     0.150
     0.388    11.834     0.150
     0.400     7.834     0.150
     0.400    13.004     0.150
     0.537     9.805     0.150
     0.537    16.615     0.150
     0.601    10.875     0.150
     0.601    18.664     0.150
     0.687    12.645     0.150
     0.697    12.545     0.150
     0.697    21.314     0.150
     0.750    22.926     0.150
     0.821    14.525     0.150
     0.821    24.455     0.150
     0.897    15.645     0.150
     0.897    26.355     0.150
     0.915    15.535     0.150
     0.915    27.045     0.150
     0.924    16.295     0.150
     0.924    27.975     0.150
     0.918    16.074     0.150
     0.973    16.895     0.150
     0.973    29.385     0.150
     0.984    17.275     0.150
     0.999    17.035     0.150
     0.999    29.484     0.150
     1.008    18.494     0.150
     1.068    31.834     0.150
     1.068    18.445     0.150
     1.068    31.834     0.150
     1.244    21.484     0.150
     1.244    37.266     0.150
     1.256    21.395     0.150
     1.256    37.215     0.150
     1.260    21.205     0.150
     1.260    37.516     0.150
     1.260    21.096     0.150
     1.260    21.096     0.150
     1.276    39.215     0.150
     1.276    22.346     0.150
     1.276    39.215     0.150
     1.365    23.004     0.150
     1.365    23.004     0.150
     1.380    23.615     0.150
     1.444    24.135     0.150
     1.444    43.055     0.150
     1.448    24.676     0.150
     1.480    24.945     0.150
     1.480    43.404     0.150
     1.480    25.064     0.150
     1.480    43.664     0.150
     1.481    44.055     0.150
     1.481    25.004     0.150
     1.481    43.715     0.150
     1.481    24.824     0.150
     1.481    43.635     0.150
     1.482    43.766     0.150
     1.483    25.096     0.150
     1.483    44.074     0.150
     1.484    25.035     0.150
     1.484    43.814     0.150
     1.539    26.016     0.150
     1.539    45.404     0.150
     1.628    27.865     0.150
     1.628    48.074     0.150
     1.643    27.695     0.150
     1.643    48.205     0.150
     1.667    28.125     0.150
     1.667    48.084     0.150
     1.678    27.895     0.150
     1.678    48.785     0.150
     1.679    28.164     0.150
     1.679    48.545     0.150
     1.782    29.285     0.150
     1.782    29.285     0.150
     1.868    31.516     0.150
     1.946    29.725     0.150
     1.946    29.725     0.150
     1.946    51.475     0.150
     2.036    34.455     0.150
     2.036    58.004     0.150
     2.045    34.096     0.150
     2.115    35.404     0.150
     2.215    36.475     0.150
     2.270    36.795     0.150
     2.300    37.574     0.150
     2.388    39.285     0.150
     2.388    39.285     0.150
     2.456    40.484     0.150
     2.587    42.154     0.150
     2.773    44.754     0.150
     2.776    47.125     0.150
     3.396    52.775     0.150
     3.503    54.645     0.150
     3.503    54.645     0.150
     3.765    59.225     0.150
     3.943    60.664     0.150
     5.673    85.525     0.150
     1.071    32.051     0.150
     1.266    21.062     0.150
     1.281    39.721     0.150
     2.027    59.531     0.150
     1.355    22.430     0.150
     1.334    17.258     0.150
     1.334    31.141     0.150
     1.441    20.156     0.150
     2.039    57.219     0.150
     2.426    37.359     0.150
     3.810    57.836     0.150
     4.821    74.180     0.150
     5.460    84.055     0.150
     8.182   123.625     0.150
     9.230   136.961     0.150
    12.663   182.203     0.150
    16.839   236.398     0.150
    22.056   295.805     0.150
    26.982   340.734     0.150
    59.236  4479.297     0.150
    59.237  4482.164     0.150
    59.252  4479.898     0.150
     0.471     9.055     0.150
     0.471    15.146     0.150
     0.471     9.055     0.150
     0.471    15.146     0.150
     0.656    11.896     0.150
     0.656    11.896     0.150
     0.637    11.615     0.150
     0.637    19.955     0.150
     0.698    12.955     0.150
     0.698    12.955     0.150
     0.925    15.725     0.150
     0.925    15.725     0.150
     0.925    27.025     0.150
     0.925    15.725     0.150
     0.925    27.025     0.150
     0.930    16.155     0.150
     0.930    28.375     0.150
     0.930    16.155     0.150
     0.930    28.375     0.150
     1.046    17.675     0.150
     1.046    17.675     0.150
     1.182    19.355     0.150
     1.182    33.065     0.150
     1.182    19.355     0.150
     1.182    33.065     0.150
     1.143    33.625     0.150
     1.143    19.405     0.150
     1.143    33.625     0.150
     1.143    19.405     0.150
     1.143    33.625     0.150
     1.156    19.225     0.150
     1.156    32.845     0.150
     1.156    19.225     0.150
     1.156    32.845     0.150
     1.199    33.945     0.150
     1.199    19.845     0.150
     1.199    33.945     0.150
     1.312    22.035     0.150
     1.312    22.035     0.150
     1.348    21.535     0.150
     1.348    39.225     0.150
     1.348    21.535     0.150
     1.348    39.225     0.150
     1.465    23.345     0.150
     1.465    40.545     0.150
     1.465    23.345     0.150
     1.465    40.545     0.150
     1.480    23.715     0.150
     1.480    41.085     0.150
     1.480    23.715     0.150
     1.480    41.085     0.150
     1.532    24.405     0.150
     1.532    43.765     0.150
     1.532    24.405     0.150
     1.532    43.765     0.150
     1.746    27.625     0.150
     1.747    27.245     0.150
     1.747    27.245     0.150
     1.838    28.885     0.150
     1.838    50.725     0.150
     1.838    28.885     0.150
     1.838    50.725     0.150
     1.965    30.965     0.150
     1.965    30.965     0.150
     2.198    34.015     0.150
     2.198    34.015     0.150
     2.265    34.325     0.150
     2.265    34.325     0.150
     2.275    35.285     0.150
     2.275    60.635     0.150
     2.275    35.285     0.150
     2.275    60.635     0.150
     2.302    34.615     0.150
     2.302    34.615     0.150
     2.302    34.615     0.150
     2.372    36.295     0.150
     2.372    36.295     0.150
     2.370    36.195     0.150
     2.370    36.195     0.150
     2.419    37.035     0.150
     2.419    66.375     0.150
     2.419    37.035     0.150
     2.419    66.375     0.150
     2.613    40.165     0.150
     2.613    40.165     0.150
     2.634    41.035     0.150
     2.634    41.035     0.150
     2.634    41.035     0.150
     2.696    70.495     0.150
     2.696    40.845     0.150
     2.696    70.495     0.150
     2.696    40.845     0.150
     2.731    42.565     0.150
     2.731    42.565     0.150
     2.752    41.985     0.150
     2.752    41.985     0.150
     2.795    42.335     0.150
     2.795    42.335     0.150
     2.812    42.425     0.150
     2.812    42.425     0.150
     2.853    43.085     0.150
     2.853    43.085     0.150
     2.853    42.646     0.150
     2.853    75.905     0.150
     2.853    42.646     0.150
     2.853    75.905     0.150
     2.853    42.635     0.150
     2.853    76.045     0.150
     2.853    42.635     0.150
     2.853    76.045     0.150
     2.854    44.005     0.150
     2.854    44.005     0.150
     2.855    44.365     0.150
     2.855    44.365     0.150
     2.852    43.985     0.150
     2.852    43.985     0.150
     2.911    44.635     0.150
     2.911    44.635     0.150
     2.992    46.405     0.150
     2.992    46.405     0.150
     3.017    46.485     0.150
     3.017    46.485     0.150
     3.017    80.025     0.150
     3.017    46.485     0.150
     3.017    80.025     0.150
     3.082    47.315     0.150
     3.082    47.315     0.150
     3.083    47.045     0.150
     3.083    47.045     0.150
     3.234    49.785     0.150
     3.234    49.785     0.150
     3.260    50.585     0.150
     3.283    49.405     0.150
     3.541    53.955     0.150
     3.541    53.955     0.150
     3.579    54.275     0.150
     3.579    54.275     0.150
     3.624    55.205     0.150
     3.624    55.205     0.150
     3.804    57.285     0.150
     3.804    57.285     0.150
     3.915    56.975     0.150
     3.915    99.025     0.150
     3.915    56.975     0.150
     3.836    57.355     0.150
     4.038    59.055     0.150
     4.038   102.725     0.150
     4.038    59.055     0.150
     4.038   102.725     0.150
     3.962    59.205     0.150
     3.962    59.205     0.150
     4.037    60.855     0.150
     4.037    60.855     0.150
     4.025    60.975     0.150
     4.025    60.975     0.150
     4.417    64.295     0.150
     4.417   112.075     0.150
     4.417    64.295     0.150
     4.417   112.075     0.150
     4.459    64.235     0.150
     4.459   113.025     0.150
     4.459    64.235     0.150
     4.459   113.025     0.150
     4.557    65.745     0.150
     4.557   115.305     0.150
     4.557    65.745     0.150
     4.557   115.305     0.150
     4.484    66.525     0.150
     4.484    66.525     0.150
     4.722    69.835     0.150
     4.722    69.835     0.150
     4.799    69.025     0.150
     4.799   120.985     0.150
     4.799    69.025     0.150
     4.799   120.985     0.150
     4.754    70.815     0.150
     4.754    70.815     0.150
     4.862    69.975     0.150
     4.862   122.555     0.150
     4.862    69.975     0.150
     4.862   122.555     0.150
     5.094    74.455     0.150
     5.094   129.655     0.150
     5.094    74.455     0.150
     5.094   129.655     0.150
     5.131    76.915     0.150
     5.207    77.165     0.150
     5.207    77.165     0.150
     5.554    80.225     0.150
     5.554    80.225     0.150
     5.832    84.065     0.150
     5.832    84.065     0.150
     5.868    86.195     0.150
     5.868    86.195     0.150
     6.418    93.785     0.150
     6.418    93.785     0.150
     7.013    99.095     0.150
     8.497   128.248     0.150
     9.056   131.815     0.150
    10.032   142.155     0.150
    12.928   188.227     0.150
    14.186   199.015     0.150
    16.522   231.065     0.150
    27.140   338.865     0.150
     0.271     7.625     0.150
     0.271    13.176     0.150
     0.286     7.696     0.150
     0.286    13.086     0.150
     0.316     8.216     0.150
     0.602    11.596     0.150
     0.602    20.546     0.150
     0.631    12.266     0.150
     0.704    22.846     0.150
     0.704    13.006     0.150
     0.812    14.536     0.150
     0.812    26.186     0.150
     0.883    15.926     0.150
     1.047    17.596     0.150
     1.112    18.526     0.150
     1.147    19.375     0.150
     1.141    32.576     0.150
     1.141    19.446     0.150
     1.141    18.596     0.150
     1.961    49.206     0.150
     2.558    92.466     0.150
     3.367    57.296     0.150
     3.367    49.966     0.150
     3.367    50.076     0.150
     5.365   136.816     0.150
     5.847    85.116     0.150
     8.248   116.776     0.150
     9.593   135.756     0.150
     9.626   136.016     0.150
     9.649   136.386     0.150
     9.708   137.286     0.150
     9.758   137.716     0.150
     9.814   138.576     0.150
    10.210   144.156     0.150
    10.645   150.268     0.150
    10.645   149.836     0.150
    10.688   150.536     0.150
    10.786   152.456     0.150
    10.832   152.496     0.150
    10.872   153.316     0.150
    11.056   155.605     0.150
    11.069   155.706     0.150
    11.355   159.836     0.150
    11.383   160.046     0.150
    11.458   161.076     0.150
    11.497   161.556     0.150
    11.527   162.596     0.150
    11.667   163.875     0.150
    11.818   166.086     0.150
    11.828   165.906     0.150
    11.917   167.397     0.150
    11.917   167.516     0.150
    12.799   180.396     0.150
    12.936   181.276     0.150
    14.038   197.037     0.150
    14.696   202.796     0.150
    15.712   216.729     0.150
    15.712   216.966     0.150
    18.333   254.864     0.150
    19.241   265.352     0.150
    19.277   258.906     0.150
    20.094   272.743     0.150
    20.244   272.506     0.150
    22.563   293.096     0.150
    34.938   408.436     0.150
    43.201   478.346     0.150
    60.593  4543.474     0.150
    60.593  4544.759     0.150
    60.609  4545.049     0.150
    61.599  4620.936     0.150
    61.608  4617.911     0.150
    61.617  4621.711     0.150
    73.867   694.346     0.150
    74.521   702.256     0.150
    74.521   702.256     0.150
    75.356   716.246     0.150
    75.644   708.946     0.150
    76.017   711.046     0.150
    76.599   712.778     0.150
    76.832   715.129     0.150
    76.975   715.597     0.150
    76.988   715.069     0.150
    77.001   715.810     0.150
    77.070   716.320     0.150
    77.337   717.354     0.150
    77.687   717.271     0.150
    77.721   719.560     0.150
    77.758   721.879     0.150
    77.802   728.812     0.150
    78.242   721.095     0.150
    78.619   723.734     0.150
    78.630   723.620     0.150
    80.831   730.946     0.150
    82.867     8.100     0.150
    84.386     6.600     0.150
    84.386    10.000     0.150
     0.485     9.027     0.150
     0.530    19.996     0.150
     0.530    11.148     0.150
     0.666    13.008     0.150
     0.779    24.637     0.150
     0.842    15.219     0.150
     0.898    30.617     0.150
     0.898    16.520     0.150
     1.115    18.656     0.150
     1.114    18.906     0.150
     1.108    34.289     0.150
     1.174    20.578     0.150
     1.194    20.719     0.150
     1.205    20.156     0.150
     1.206    20.137     0.150
     1.232    20.867     0.150
     1.310    21.930     0.150
     1.425    42.379     0.150
     1.535    25.398     0.150
     1.530    25.289     0.150
     1.896    30.738     0.150
     1.906    30.887     0.150
     2.205    35.156     0.150
     2.268    36.008     0.150
     3.103    49.129     0.150
     3.119    48.906     0.150
     3.449    54.289     0.150
     4.944    74.477     0.150
     0.885    28.125     0.150
     2.488    36.035     0.150
     4.139   106.025     0.150
     0.902    28.109     0.150
     0.286     6.484     0.150
     0.286    12.180     0.150
     0.488     9.648     0.150
     0.650    11.945     0.150
     0.650    20.727     0.150
     0.687    12.539     0.150
     0.916    15.758     0.150
     0.916    15.758     0.150
     0.916    27.352     0.150
     0.917    15.727     0.150
     0.917    15.727     0.150
     0.979    16.836     0.150
     1.090    17.867     0.150
     1.090    30.469     0.150
     1.371    34.461     0.150
     1.371    19.586     0.150
     1.371    34.461     0.150
     1.182    20.219     0.150
     1.379    22.516     0.150
     1.408    22.727     0.150
     1.408    39.117     0.150
     1.535    42.180     0.150
     1.580    25.156     0.150
     1.580    43.969     0.150
     1.580    25.039     0.150
     1.580    44.047     0.150
     1.604    26.148     0.150
     1.604    44.930     0.150
     1.569    26.000     0.150
     1.569    44.148     0.150
     1.604    26.219     0.150
     1.604    45.641     0.150
     1.701    27.336     0.150
     1.701    46.305     0.150
     1.708    27.805     0.150
     1.708    48.625     0.150
     1.921    47.914     0.150
     1.921    27.367     0.150
     1.921    47.914     0.150
     1.943    48.000     0.150
     1.943    27.688     0.150
     1.943    48.000     0.150
     1.823    28.766     0.150
     1.828    28.477     0.150
     1.828    49.891     0.150
     1.887    30.234     0.150
     1.887    52.359     0.150
     1.989    31.891     0.150
     2.024    31.156     0.150
     2.068    31.555     0.150
     2.068    54.828     0.150
     2.043    31.680     0.150
     2.043    55.617     0.150
     2.043    31.891     0.150
     2.043    55.781     0.150
     2.043    31.688     0.150
     2.043    55.938     0.150
     2.045    31.805     0.150
     2.045    55.836     0.150
     2.045    31.914     0.150
     2.167    33.156     0.150
     2.167    57.805     0.150
     2.183    34.695     0.150
     2.183    59.648     0.150
     2.216    59.586     0.150
     2.216    34.469     0.150
     2.216    59.586     0.150
     2.313    35.617     0.150
     2.614    40.898     0.150
     2.632    40.539     0.150
     2.632    71.289     0.150
     2.670    73.047     0.150
     2.790    41.078     0.150
     2.790    41.078     0.150
     2.956    43.469     0.150
     2.956    43.469     0.150
     2.918    44.250     0.150
     2.918    77.969     0.150
     2.929    44.766     0.150
     3.056    79.398     0.150
     3.056    79.398     0.150
     3.055    47.141     0.150
     3.124    47.828     0.150
     3.346    50.852     0.150
     3.471    51.852     0.150
     3.483    52.000     0.150
     3.483    90.281     0.150
     3.484    53.008     0.150
     3.484    92.820     0.150
     3.789    57.328     0.150
     3.812    57.320     0.150
     4.238    63.461     0.150
     4.238   111.008     0.150
     4.325    64.648     0.150
     4.550    66.414     0.150
     4.550   115.430     0.150
     4.796    70.555     0.150
     4.961   126.125     0.150
     5.440   138.289     0.150
     5.639    83.469     0.150
     5.779    85.352     0.150
     5.791    85.328     0.150
     0.035     5.457     0.150
     0.066     5.395     0.150
     0.066     9.168     0.150
     0.302     7.496     0.150
     0.302    12.875     0.150
     0.299     7.258     0.150
     0.299    12.598     0.150
     0.300     7.176     0.150
     0.300    12.477     0.150
     0.521     9.855     0.150
     0.521    17.086     0.150
     0.771    14.027     0.150
     0.859    15.246     0.150
     0.859    14.598     0.150
     0.913    15.895     0.150
     0.934    15.766     0.150
     1.036    17.578     0.150
     1.238    20.887     0.150
     1.931    26.957     0.150
     2.298    36.555     0.150
     2.577    35.965     0.150
     2.577    63.945     0.150
     2.598    64.605     0.150
     2.713    41.516     0.150
     3.338    50.918     0.150
     3.600    55.098     0.150
     3.600    53.367     0.150
     3.683    56.375     0.150
     5.617   160.551     0.150
     8.615   120.867     0.150
     8.750   122.605     0.150
    77.740   713.605     0.150
     0.299     7.844     0.150
     0.299    13.643     0.150
     0.340     8.232     0.150
     0.340    14.264     0.150
     0.403     9.033     0.150
     0.403    15.963     0.150
     0.463     9.543     0.150
     0.462     9.572     0.150
     0.462    16.732     0.150
     0.655    12.643     0.150
     0.779    14.322     0.150
     0.966    16.293     0.150
     0.955    16.312     0.150
     0.955    16.152     0.150
     0.941    16.482     0.150
     0.975    16.303     0.150
     1.094    18.322     0.150
     1.173    19.902     0.150
     1.220    20.793     0.150
     1.294    24.953     0.150
     1.393    22.473     0.150
     1.393    42.812     0.150
     1.499    24.162     0.150
     1.613    25.943     0.150
     1.786    28.264     0.150
     2.233    34.223     0.150
     2.409    36.473     0.150
     2.420    37.133     0.150
     2.768    68.943     0.150
     2.786    69.363     0.150
     2.986    44.293     0.150
     3.395    49.963     0.150
     3.752    56.242     0.150
     3.752    97.742     0.150
     4.266    62.373     0.150
     0.260     6.430     0.150
     0.260    12.020     0.150
     0.401     8.199     0.150
     0.401    14.238     0.150
     0.449     8.859     0.150
     0.449    15.621     0.150
     0.500     9.410     0.150
     0.500     9.410     0.150
     0.500    16.379     0.150
     0.566    10.199     0.150
     0.566    17.449     0.150
     0.595    11.051     0.150
     0.595    11.051     0.150
     0.595    18.750     0.150
     0.596    11.020     0.150
     0.596    18.949     0.150
     0.803    14.301     0.150
     0.803    14.301     0.150
     0.961    16.230     0.150
     0.961    27.852     0.150
     0.980    16.891     0.150
     0.980    16.891     0.150
     1.036    16.832     0.150
     1.036    29.691     0.150
     1.056    17.121     0.150
     1.124    18.789     0.150
     1.124    32.430     0.150
     1.255    20.680     0.150
     1.255    35.691     0.150
     1.245    20.320     0.150
     1.245    35.270     0.150
     1.245    20.352     0.150
     1.245    35.250     0.150
     1.422    22.309     0.150
     1.481    21.238     0.150
     1.423    23.082     0.150
     1.436    23.641     0.150
     1.436    40.672     0.150
     1.441    23.629     0.150
     1.441    23.629     0.150
     1.441    40.480     0.150
     1.461    23.148     0.150
     1.461    23.148     0.150
     1.461    40.309     0.150
     1.550    25.109     0.150
     1.550    25.109     0.150
     1.550    43.148     0.150
     1.631    25.590     0.150
     1.668    27.039     0.150
     1.680    27.410     0.150
     1.687    27.070     0.150
     1.687    26.602     0.150
     1.689    26.789     0.150
     1.747    28.488     0.150
     1.747    27.422     0.150
     1.792    27.570     0.150
     1.792    27.570     0.150
     1.907    30.281     0.150
     1.907    30.281     0.150
     1.874    29.832     0.150
     1.922    30.520     0.150
     2.029    31.789     0.150
     2.084    33.031     0.150
     2.097    32.500     0.150
     2.190    53.910     0.150
     2.205    54.602     0.150
     2.150    33.250     0.150
     2.213    34.289     0.150
     2.253    35.102     0.150
     2.341    36.422     0.150
     2.341    36.422     0.150
     2.422    36.879     0.150
     2.390    63.379     0.150
     2.489    39.121     0.150
     2.560    38.789     0.150
     2.715    42.320     0.150
     2.747    41.941     0.150
     2.984    45.949     0.150
     3.039    80.371     0.150
     3.098    47.148     0.150
     3.098    47.148     0.150
     3.098    83.051     0.150
     3.311    50.711     0.150
     3.781    56.449     0.150
     3.781    97.871     0.150
     3.843    58.059     0.150
     3.843   100.949     0.150
     4.252   111.840     0.150
     4.679    68.789     0.150
     5.367    77.340     0.150
     5.656    81.840     0.150
     0.076     5.652     0.150
     0.076     9.914     0.150
     0.244     6.523     0.150
     0.427    16.984     0.150
     0.516    10.555     0.150
     0.559    10.562     0.150
     0.560    10.602     0.150
     0.575    10.965     0.150
     0.609    11.273     0.150
     0.609    19.574     0.150
     0.702    12.793     0.150
     0.806    14.043     0.150
     0.856    14.824     0.150
     0.857    14.734     0.150
     0.848    15.031     0.150
     0.897    14.984     0.150
     0.963    16.773     0.150
     0.970    16.652     0.150
     1.074    18.344     0.150
     1.259    21.031     0.150
     1.301    21.523     0.150
     1.373    22.723     0.150
     1.391    22.453     0.150
     1.477    23.664     0.150
     1.607    26.113     0.150
     1.662    26.613     0.150
     1.972    30.324     0.150
     2.510    45.621     0.150
     2.914    42.422     0.150
     2.914    42.305     0.150
     4.413    64.492     0.150
     0.275     6.711     0.150
     0.456    17.352     0.150
     0.456    17.359     0.150
     0.434     8.805     0.150
     0.704    21.531     0.150
     0.704    12.484     0.150
     0.745    13.445     0.150
     0.745    22.461     0.150
     0.857    15.062     0.150
     1.091    18.242     0.150
     1.155    19.141     0.150
     1.230    20.094     0.150
     1.209    20.094     0.150
     1.397    22.273     0.150
     1.478    24.531     0.150
     1.731    27.477     0.150
     1.930    31.133     0.150
     2.326    36.156     0.150
     2.326    35.000     0.150
     2.553    39.664     0.150
     2.598    39.984     0.150
     2.669    37.453     0.150
     2.913    44.039     0.150
     3.305    50.406     0.150
     3.748    56.055     0.150
     4.083    72.508     0.150
     4.083    60.094     0.150
     5.378    77.859     0.150
     6.284    91.383     0.150
     7.049   182.180     0.150
     7.659   113.836     0.150
     7.784   110.203     0.150
     9.176   130.031     0.150
     9.712   137.406     0.150
    10.302   145.422     0.150
    10.548   149.172     0.150
    11.426   160.594     0.150
    12.364   175.305     0.150
    12.929   181.164     0.150
    15.075   209.703     0.150
    15.161   209.383     0.150
    15.221   210.242     0.150
    15.254   211.695     0.150
    15.631   213.906     0.150
    15.631   215.695     0.150
    16.511   229.445     0.150
    16.511   230.875     0.150
    16.639   230.273     0.150
    20.242   279.703     0.150
    22.566   295.586     0.150
    23.935   311.727     0.150
    25.318   324.953     0.150
    26.394   333.875     0.150
    26.443   333.594     0.150
    60.916  4569.195     0.150
    60.916  4580.562     0.150
    60.932  4570.617     0.150
    61.913  4650.766     0.150
    61.922  4649.891     0.150
    61.931  4651.391     0.150
    74.087   693.688     0.150
    78.708   719.031     0.150
    82.031   738.031     0.150
     0.113     4.979     0.150
     0.113     8.859     0.150
     0.112     5.029     0.150
     0.214     5.828     0.150
     0.214    10.129     0.150
     0.350     7.498     0.150
     0.393     7.869     0.150
     0.393    13.840     0.150
     0.393     7.908     0.150
     0.393    13.908     0.150
     0.659    12.238     0.150
     0.726    12.930     0.150
     0.726    23.010     0.150
     0.727    12.549     0.150
     0.727    22.818     0.150
     0.861    15.029     0.150
     0.921    15.809     0.150
     1.003    17.020     0.150
     1.130    19.129     0.150
     1.204    20.498     0.150
     1.513    24.889     0.150
     1.559    26.559     0.150
     1.675    27.279     0.150
     2.738    42.180     0.150
    10.818    49.979     0.150
     3.345    49.719     0.150
     3.410    49.770     0.150
     0.936    29.438     0.150
     1.589    24.496     0.150
     1.589    24.578     0.150
     0.772    13.742     0.150
     0.882    27.000     0.150
     1.211    35.391     0.150
     1.339    23.352     0.150
     1.384    23.273     0.150
     1.385    23.594     0.150
     1.544    26.477     0.150
     1.559    27.273     0.150
     1.846    31.164     0.150
     1.880    32.297     0.150
    28.422     6.574     0.150
    28.422    11.484     0.150
     0.219     6.764     0.150
     0.509     9.994     0.150
     0.675    12.504     0.150
     0.675    21.904     0.150
     0.695    12.804     0.150
     0.763    13.594     0.150
     0.836    14.844     0.150
     0.836    25.384     0.150
     0.829    14.504     0.150
     0.965    16.114     0.150
     1.001    17.004     0.150
     1.038    29.444     0.150
     1.050    17.654     0.150
     1.127    18.854     0.150
     1.340    21.784     0.150
   103.881    28.625     0.150
     2.100    33.024     0.150
     2.346    36.094     0.150
   131.972    55.204     0.150
     0.593    11.266     0.150
     0.950    16.716     0.150
     1.470    23.355     0.150
    29.880    25.025     0.150
    74.126    70.886     0.150
   131.050    74.926     0.150
     5.541    80.596     0.150
     6.121    86.716     0.150
     6.121   182.154     0.150
     7.946   112.434     0.150
     7.946   202.955     0.150
     8.663   125.195     0.150
     9.441   240.961     0.150
     9.441   240.966     0.150
    10.991   155.155     0.150
    14.731   202.176     0.150
    80.658   212.796     0.150
    95.318   213.065     0.150
    56.814   214.815     0.150
    15.871   216.735     0.150
    16.069   221.115     0.150
    16.069   221.035     0.150
    18.977   264.735     0.150
    19.009   262.735     0.150
    19.009   524.636     0.150
    97.936   272.535     0.150
    20.426   275.745     0.150
    62.258   283.535     0.150
    18.142   315.405     0.150
    30.057   366.636     0.150
    30.567   371.365     0.150
    30.567   371.336     0.150
    30.567   371.256     0.150
    30.796   372.966     0.150
    32.017   382.466     0.150
    34.778   407.245     0.150
    34.778   407.365     0.150
    43.003   477.376     0.150
    45.723   499.655     0.150
    48.431   522.586     0.150
    60.254  4530.207     0.150
    60.255  4530.424     0.150
    60.271  4531.574     0.150
    68.431   608.455     0.150
    68.431   607.436     0.150
    61.262  4606.379     0.150
    61.272  4606.176     0.150
    61.280  4606.391     0.150
    61.427   612.735     0.150
    45.597   618.966     0.150
    45.597   618.186     0.150
    64.594   636.985     0.150
    72.567     7.540     0.150
    73.098   688.586     0.150
    73.861   693.855     0.150
    74.859   698.796     0.150
    75.165   699.855     0.150
    76.876   709.586     0.150
    76.951   709.535     0.150
    77.847   715.056     0.150
    78.210   716.155     0.150
    78.699   719.916     0.150
    83.020   742.886     0.150
    83.020   742.756     0.150
    84.096    10.700     0.150
   115.198   783.896     0.150
   139.086  1155.930     0.150
   146.202  1175.855     0.150
   150.009  1186.485     0.150
     0.304    12.176     0.150
    28.740     9.215     0.150
    28.740    17.564     0.150
     0.492     9.549     0.150
     0.492     9.582     0.150
     0.599    10.941     0.150
     0.599    10.986     0.150
     0.674    12.018     0.150
     0.784    14.146     0.150
     0.815    14.596     0.150
     0.902    15.486     0.150
     0.904    15.473     0.150
     0.894    15.518     0.150
     1.106    18.836     0.150
    81.091    21.715     0.150
     1.412    23.814     0.150
     1.526    24.807     0.150
     1.699    28.156     0.150
     1.924    31.361     0.150
   104.228    32.855     0.150
     2.695    43.074     0.150
     2.695    73.232     0.150
     2.735    41.496     0.150
    41.572    10.527     0.150
    41.572    18.590     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     0.948    16.738     0.150
     0.980    16.422     0.150
     0.980    29.109     0.150
     1.424    22.910     0.150
     1.576    24.801     0.150
     1.609    26.000     0.150
     1.703    26.711     0.150
     1.813    29.211     0.150
     1.923    30.672     0.150
     2.019    31.449     0.150
     2.101    32.121     0.150
     2.101    57.488     0.150
     2.307    35.352     0.150
     2.555    39.281     0.150
     2.535    38.910     0.150
     2.683    41.262     0.150
     2.718    41.531     0.150
     2.782    42.711     0.150
     2.952    44.020     0.150
     2.932    44.340     0.150
     3.036    46.281     0.150
     3.119    46.961     0.150
     3.162    46.910     0.150
     3.183    47.922     0.150
     3.390    51.672     0.150
     3.490    52.180     0.150
     3.488    53.219     0.150
     3.506    52.852     0.150
     3.616    54.191     0.150
     3.530    54.012     0.150
     3.713    55.910     0.150
     3.804    56.488     0.150
     4.049    60.109     0.150
     4.355    65.211     0.150
     4.315    63.512     0.150
     4.679    70.711     0.150
     4.758    70.910     0.150
     4.792    68.910     0.150
     4.792   121.609     0.150
     4.878    70.211     0.150
     5.430    79.109     0.150
     5.524    80.211     0.150
     5.637    81.512     0.150
     5.884    86.512     0.150
     5.856    84.211     0.150
     5.977    88.809     0.150
     6.826    99.910     0.150
     7.171   102.609     0.150
     8.131   117.711     0.150
     8.679   127.910     0.150
     8.768   129.910     0.150
     9.136   132.012     0.150
     9.199   130.711     0.150
     9.260   136.711     0.150
     9.503   137.512     0.150
     9.762   144.109     0.150
    10.050   143.109     0.150
    10.023   144.012     0.150
    10.515   153.711     0.150
    11.166   161.910     0.150
    11.872   171.410     0.150
    11.876   171.609     0.150
    12.198   177.012     0.150
    12.255   176.109     0.150
    12.555   181.410     0.150
    12.753   182.410     0.150
    13.029   186.809     0.150
    13.129   187.711     0.150
    13.384   192.910     0.150
    13.403   192.109     0.150
    13.425   191.609     0.150
    13.557   193.410     0.150
    13.881   198.410     0.150
    14.199   201.609     0.150
    15.112   210.609     0.150
    15.043   212.910     0.150
    15.213   215.910     0.150
    15.436   217.211     0.150
    15.631   221.910     0.150
    15.963   225.910     0.150
    16.148   227.910     0.150
    16.304   229.211     0.150
    16.494   231.910     0.150
    16.527   231.910     0.150
    16.601   233.410     0.150
    16.934   237.910     0.150
    16.992   237.309     0.150
    17.340   241.910     0.150
    18.544   256.910     0.150
    18.606   258.410     0.150
    18.712   259.910     0.150
    19.108   262.910     0.150
    19.539   267.410     0.150
    19.775   270.109     0.150
    20.480   278.309     0.150
    20.685   277.910     0.150
    20.771   280.711     0.150
    21.154   285.910     0.150
    21.156   286.309     0.150
    21.703   291.512     0.150
    21.962   291.910     0.150
    22.897   302.910     0.150
    26.035   333.711     0.150
    26.619   339.809     0.150
    26.837   341.410     0.150
    26.837    10.398     0.150
    27.164   344.609     0.150
    27.530   346.211     0.150
    28.797   358.711     0.150
    29.044   359.910     0.150
    29.248   361.512     0.150
    31.330   380.809     0.150
    31.330    10.102     0.150
    31.330   689.910     0.150
    32.378   391.012     0.150
    32.394   390.512     0.150
    32.549   391.512     0.150
    34.554   407.910     0.150
    36.174   421.109     0.150
    37.056   429.309     0.150
    38.001   436.910     0.150
    39.157   447.309     0.150
    39.941   454.910     0.150
    39.941  1055.910     0.150
    44.509   490.910     0.150
    44.509   895.910     0.150
    45.520   497.910     0.150
    45.520    11.000     0.150
    45.520   498.211     0.150
    45.520    10.699     0.150
    45.520   609.910     0.150
    45.520   905.910     0.150
    45.520  1099.910     0.150
    46.923   509.109     0.150
    48.225   518.910     0.150
    48.225    10.000     0.150
    48.225    14.000     0.150
    48.225   941.910     0.150
    48.225   637.910     0.150
    48.225  1143.910     0.150
    50.564   537.910     0.150
    50.564   538.410     0.150
    53.336   558.109     0.150
    53.336   674.910     0.150
    56.394   579.910     0.150
    56.394    13.102     0.150
    58.936   597.910     0.150
    58.936     8.000     0.150
    58.936   645.910     0.150
    61.044   612.910     0.150
    61.966   617.910     0.150
    61.966   618.012     0.150
    62.335   621.910     0.150
    62.335   621.309     0.150
    64.739   636.711     0.150
    64.847   637.410     0.150
    64.847  1161.910     0.150
    65.446   642.109     0.150
    66.323   647.609     0.150
    66.638   649.910     0.150
    66.582   648.910     0.150
    66.582   649.309     0.150
    66.816   650.910     0.150
    67.507   654.309     0.150
    67.507  1189.910     0.150
    67.903   657.512     0.150
    68.575   661.910     0.150
    69.793   668.910     0.150
    69.793     9.199     0.150
    69.793   669.109     0.150
    69.793     9.000     0.150
    69.793   699.109     0.150
    69.892   670.109     0.150
    69.892  1215.910     0.150
    71.372   678.910     0.150
    71.372   679.109     0.150
    72.212   684.910     0.150
    72.721   687.809     0.150
    72.817   688.309     0.150
    72.952   689.410     0.150
    73.007   689.410     0.150
    73.007     9.000     0.150
    73.162   690.910     0.150
    73.162     8.801     0.150
    73.171   691.211     0.150
    73.171     9.398     0.150
    74.066   693.910     0.150
    74.066  1265.910     0.150
    74.066   694.711     0.150
    74.274   699.910     0.150
    74.602   698.512     0.150
    74.602   712.910     0.150
    74.817   700.910     0.150
    74.773   700.910     0.150
    74.773   701.410     0.150
    74.773   720.910     0.150
    74.837   700.910     0.150
    74.848   698.410     0.150
    74.848  1275.910     0.150
    75.249   702.609     0.150
    75.353   703.309     0.150
    75.398   703.410     0.150
    75.409   703.609     0.150
    75.411   703.012     0.150
    75.411    10.898     0.150
    75.494   704.012     0.150
    75.588   704.211     0.150
    75.609   704.512     0.150
    75.612   704.609     0.150
    75.639   704.609     0.150
    75.848   706.012     0.150
    75.884   705.809     0.150
    75.886   706.410     0.150
    75.886   884.910     0.150
    76.110   707.910     0.150
    76.199   708.012     0.150
    76.219   708.309     0.150
    76.214   708.410     0.150
    76.214   722.910     0.150
    76.307   707.910     0.150
    76.525   709.809     0.150
    76.724   710.910     0.150
    76.732   711.910     0.150
    76.732     7.898     0.150
    77.128   713.910     0.150
    77.184   714.910     0.150
    77.184  1306.410     0.150
    77.496   714.910     0.150
    77.496   715.109     0.150
    78.043   718.910     0.150
    78.532   721.910     0.150
    78.529   720.910     0.150
    79.193   724.910     0.150
    79.193   725.512     0.150
    79.367   724.910     0.150
    79.367   725.609     0.150
    79.367    13.000     0.150
    79.483   726.711     0.150
    79.483    13.199     0.150
    79.639   726.910     0.150
    80.059   725.910     0.150
    80.453   731.012     0.150
    80.509   732.211     0.150
    80.761   734.910     0.150
    80.808   735.309     0.150
    81.010   735.309     0.150
    81.123   735.910     0.150
    82.365   743.910     0.150
    82.416   741.410     0.150
    82.535   741.910     0.150
    82.929   744.910     0.150
    83.131   744.910     0.150
    83.094   745.309     0.150
    85.441   757.410     0.150
    85.760   758.910     0.150
    86.086   760.109     0.150
    86.335   760.211     0.150
   145.571  1177.211     0.150
   150.242  1189.910     0.150
   151.040  1190.910     0.150
   152.711  1192.910     0.150
     0.717    13.121     0.150
     0.683    12.523     0.150
     0.888    15.332     0.150
     1.153    19.121     0.150
     1.166    19.844     0.150
     1.387    22.621     0.150
     1.387    40.230     0.150
     1.438    23.672     0.150
     1.438    41.691     0.150
     1.406    22.492     0.150
     1.406    40.121     0.150
     1.652    26.871     0.150
     1.652    47.543     0.150
     1.829    28.352     0.150
     1.944    29.492     0.150
     2.120    33.133     0.150
     2.372    36.512     0.150
     2.372    65.184     0.150
     2.467    37.793     0.150
     2.657    40.070     0.150
     2.753    40.500     0.150
     2.754    41.602     0.150
     2.826    42.691     0.150
     2.819    42.641     0.150
     2.849    43.652     0.150
     2.904    44.441     0.150
     2.967    44.402     0.150
     2.930    45.121     0.150
     2.930    85.320     0.150
     3.192    49.273     0.150
     3.211    48.113     0.150
     3.177    48.934     0.150
     3.335    49.691     0.150
     3.632    54.422     0.150
     3.733    56.094     0.150
     3.797    57.344     0.150
     3.920    58.242     0.150
     4.073    59.293     0.150
     4.282    63.000     0.150
     4.212   108.910     0.150
     4.412    66.594     0.150
     4.625    68.750     0.150
     4.647    68.250     0.150
     4.636    69.242     0.150
     4.672    69.621     0.150
     4.742    71.191     0.150
     4.766    70.902     0.150
     4.764    71.320     0.150
     4.783    71.742     0.150
     4.807    72.594     0.150
     4.807    72.523     0.150
     4.840    72.660     0.150
     4.868    72.953     0.150
     4.741    69.473     0.150
     4.892    72.980     0.150
     4.915    73.844     0.150
     4.996    75.023     0.150
     5.146    76.672     0.150
     5.131    76.652     0.150
     5.239    76.820     0.150
     5.222    78.102     0.150
     5.286    78.613     0.150
     5.277    79.062     0.150
     5.337    78.691     0.150
     5.553    83.113     0.150
     5.624    84.250     0.150
     5.688    83.211     0.150
     5.689    83.051     0.150
     5.654    83.371     0.150
     5.762    85.883     0.150
     5.915    86.582     0.150
     5.891    87.633     0.150
     5.964    86.902     0.150
     6.103    88.922     0.150
     6.408    92.102     0.150
     7.014   101.523     0.150
     7.175   102.934     0.150
     7.898   117.871     0.150
     8.293   123.133     0.150
     8.990   129.320     0.150
     9.289   135.723     0.150
    10.755   154.152     0.150
    10.821   154.223     0.150
    11.508   166.621     0.150
    12.800   184.820     0.150
    13.617   192.203     0.150
    13.879   197.230     0.150
    14.122   200.492     0.150
    15.133   218.453     0.150
    15.384   217.371     0.150
    15.450   216.922     0.150
    16.383   231.910     0.150
    16.953   237.211     0.150
    17.228   240.691     0.150
    18.539   256.723     0.150
    19.315   266.223     0.150
    20.456   276.922     0.150
    21.153   286.621     0.150
    21.651   290.344     0.150
    23.786   311.762     0.150
    25.694   329.883     0.150
    27.009   341.742     0.150
    27.009   342.922     0.150
    29.013   359.941     0.150
    31.664   383.023     0.150
    36.747   428.820     0.150
     0.837    14.840     0.150
     0.837    25.070     0.150
     0.861    15.150     0.150
     0.861    26.619     0.150
     0.826    15.119     0.150
     0.925    16.230     0.150
     0.925    27.650     0.150
     1.117    19.100     0.150
     1.117    33.730     0.150
     1.188    20.680     0.150
     1.364    22.801     0.150
     1.364    41.381     0.150
     1.405    23.750     0.150
     1.409    23.650     0.150
     1.367    23.080     0.150
     1.449    23.420     0.150
     1.471    24.391     0.150
     1.558    25.740     0.150
     1.558    47.650     0.150
     1.619    27.131     0.150
     1.570    25.580     0.150
     1.620    26.150     0.150
     1.740    28.801     0.150
     1.693    27.721     0.150
     1.727    27.119     0.150
     1.741    28.061     0.150
     1.806    29.160     0.150
     1.925    30.971     0.150
     1.913    30.420     0.150
     2.021    32.350     0.150
     2.030    32.340     0.150
     2.059    32.850     0.150
     2.182    34.369     0.150
     2.182    66.189     0.150
     2.158    34.051     0.150
     2.182    34.199     0.150
     2.267    35.619     0.150
     2.267    67.449     0.150
     2.263    35.250     0.150
     2.272    35.850     0.150
     2.294    36.080     0.150
     2.360    37.279     0.150
     2.452    37.600     0.150
     2.529    39.770     0.150
     2.520    39.949     0.150
     2.516    38.891     0.150
     2.647    41.660     0.150
     2.682    41.670     0.150
     2.686    41.561     0.150
     2.712    42.090     0.150
     2.841    43.391     0.150
     2.890    44.480     0.150
     2.918    45.240     0.150
     2.997    46.801     0.150
     3.122    47.740     0.150
     3.158    48.449     0.150
     3.252    50.270     0.150
     3.202    48.500     0.150
     3.305    50.461     0.150
     3.360    51.330     0.150
     3.375    51.270     0.150
     3.450    52.789     0.150
     3.449    51.869     0.150
     3.507    53.939     0.150
     3.518    53.949     0.150
     3.517    54.109     0.150
     3.518    54.080     0.150
     3.547    54.721     0.150
     3.641    55.830     0.150
     3.653    56.430     0.150
     3.711    57.400     0.150
     3.796    57.051     0.150
     3.864    59.020     0.150
     3.874    58.391     0.150
     4.184    62.471     0.150
     4.457    67.289     0.150
     4.484    68.061     0.150
     4.873    72.340     0.150
     5.198    76.350     0.150
     5.500    83.721     0.150
     5.849    85.289     0.150
     5.885    86.570     0.150
     7.291   109.770     0.150
     8.047   119.430     0.150
     8.432   125.051     0.150
     9.464   137.010     0.150
     9.577   137.250     0.150
     9.686   138.279     0.150
     9.650   142.811     0.150
     9.943   142.529     0.150
    10.089   148.625     0.150
    10.089   321.150     0.150
    10.957   159.670     0.150
    11.077   161.301     0.150
    11.099   160.631     0.150
    11.614   170.100     0.150
    11.664   169.980     0.150
    11.899   171.221     0.150
    12.326   178.141     0.150
    13.292   191.170     0.150
    13.671   197.420     0.150
    14.174   203.211     0.150
    14.185   203.279     0.150
    15.217   212.051     0.150
    15.217   476.250     0.150
    16.615   235.664     0.150
    16.955   238.561     0.150
    19.519   265.199     0.150
    19.661   270.900     0.150
    19.915   274.650     0.150
    20.065   273.801     0.150
    20.392   278.971     0.150
    22.783   301.141     0.150
    23.096   306.311     0.150
    24.406   318.449     0.150
    25.744   331.369     0.150
    25.744   331.750     0.150
    27.741   349.100     0.150
    28.632   355.811     0.150
    36.114   422.074     0.150
     0.302     7.797     0.150
     0.302    13.117     0.150
     0.279     7.938     0.150
     0.279    13.758     0.150
     0.409     9.219     0.150
     0.409    15.992     0.150
     0.681    21.891     0.150
     0.744    13.492     0.150
     0.744    23.859     0.150
     0.726    13.539     0.150
     0.726    23.422     0.150
     0.740    13.219     0.150
     0.740    23.648     0.150
     0.888    15.586     0.150
     0.888    27.188     0.150
     0.918    16.422     0.150
     0.918    28.500     0.150
     1.072    18.133     0.150
     1.072    31.680     0.150
     1.133    18.961     0.150
     1.133    34.438     0.150
     1.129    19.336     0.150
     1.129    33.766     0.150
     1.427    23.172     0.150
     1.427    41.352     0.150
     1.451    23.156     0.150
     1.484    23.898     0.150
     1.473    24.109     0.150
     1.722    27.328     0.150
     1.811    29.133     0.150
     1.856    28.742     0.150
     1.856    50.961     0.150
     1.844    29.383     0.150
     1.920    30.188     0.150
     1.962    30.508     0.150
     1.998    31.266     0.150
     2.081    33.992     0.150
     2.116    32.539     0.150
     2.150    32.852     0.150
     2.150    57.609     0.150
     2.177    33.867     0.150
     2.183    34.062     0.150
     2.325    36.148     0.150
     2.342    35.820     0.150
     2.342    63.461     0.150
     2.327    36.031     0.150
     2.460    37.602     0.150
     2.541    39.562     0.150
     2.572    39.758     0.150
     2.644    40.117     0.150
     2.690    40.508     0.150
     2.759    42.086     0.150
     2.861    44.445     0.150
     2.877    43.852     0.150
     2.865    43.398     0.150
     2.930    44.266     0.150
     2.970    44.891     0.150
     2.961    44.828     0.150
     2.973    44.242     0.150
     2.973    90.812     0.150
     3.073    46.641     0.150
     3.068    46.352     0.150
     3.068    80.172     0.150
     3.236    49.797     0.150
     3.270    50.070     0.150
     3.357    50.992     0.150
     3.531    53.430     0.150
     3.645    54.680     0.150
     3.696    55.539     0.150
     3.853    58.008     0.150
     3.930    58.883     0.150
     3.937    58.531     0.150
     3.949    59.422     0.150
     3.994    59.438     0.150
     3.994    60.289     0.150
     4.052    60.648     0.150
     4.092    61.250     0.150
     4.086    60.719     0.150
     4.104    61.242     0.150
     4.159    62.430     0.150
     4.170    62.133     0.150
     4.190    62.961     0.150
     4.268    62.391     0.150
     4.250    63.461     0.150
     4.253    64.188     0.150
     4.259    63.859     0.150
     4.254    62.508     0.150
     4.299    64.367     0.150
     4.369    66.070     0.150
     4.365    65.508     0.150
     4.506    67.367     0.150
     4.536    67.812     0.150
     4.696    67.602     0.150
     4.834    72.711     0.150
     4.893    70.398     0.150
     5.074    74.297     0.150
     5.138    76.133     0.150
     5.169    73.836     0.150
     5.277    76.766     0.150
     5.272    78.070     0.150
     5.293    77.836     0.150
     5.401    78.859     0.150
     5.388    79.508     0.150
     5.417    78.891     0.150
     5.408    80.750     0.150
     5.506    80.016     0.150
     5.498    78.211     0.150
     5.498   138.281     0.150
     5.617    82.102     0.150
     6.079    87.586     0.150
     6.079   189.109     0.150
     6.149    87.766     0.150
     6.149   154.492     0.150
     6.326    93.727     0.150
     7.004   101.688     0.150
     7.004   178.789     0.150
     8.017   115.492     0.150
     8.122   120.250     0.150
     8.616   126.445     0.150
     8.781   128.938     0.150
     9.251   134.539     0.150
     9.251   288.711     0.150
     9.266   135.906     0.150
     9.357   133.812     0.150
     9.602   136.938     0.150
     9.863   144.328     0.150
     9.942   140.938     0.150
     9.970   145.977     0.150
    10.020   144.492     0.150
    10.682   154.570     0.150
    10.721   155.750     0.150
    11.047   157.000     0.150
    11.037   159.836     0.150
    11.256   162.930     0.150
    11.601   165.609     0.150
    12.111   175.750     0.150
    12.178   174.602     0.150
    12.247   176.711     0.150
    12.407   179.164     0.150
    12.453   179.570     0.150
    13.057   185.711     0.150
    13.093   187.648     0.150
    13.169   187.688     0.150
    13.312   189.742     0.150
    13.313   189.047     0.150
    13.890   197.320     0.150
    14.445   205.078     0.150
    14.493   207.570     0.150
    14.510   212.141     0.150
    14.566   208.102     0.150
    14.603   208.508     0.150
    14.844   209.469     0.150
    14.854   209.898     0.150
    14.916   213.008     0.150
    15.491   218.867     0.150
    15.768   221.406     0.150
    16.004   225.883     0.150
    16.064   224.602     0.150
    16.257   228.492     0.150
    17.417   243.883     0.150
    17.662   245.406     0.150
    17.653   245.922     0.150
    18.835   258.320     0.150
    18.856   258.891     0.150
    18.856   595.141     0.150
    19.228   262.664     0.150
    19.228   607.117     0.150
    19.225   264.562     0.150
    19.469   261.539     0.150
    20.499   277.328     0.150
    20.765   275.992     0.150
    21.638   287.789     0.150
    21.865   292.531     0.150
    22.800   296.039     0.150
    24.909   320.836     0.150
    26.408   334.945     0.150
    26.408   335.266     0.150
    27.487   343.672     0.150
    27.743   346.281     0.150
    28.168   350.438     0.150
    28.930   356.070     0.150
    29.846   364.891     0.150
    30.521   370.758     0.150
    30.783   373.359     0.150
    31.325   376.852     0.150
    31.334   377.148     0.150
    33.446   397.516     0.150
    34.694   407.352     0.150
    35.266   411.500     0.150
    64.611   634.625     0.150
    67.195   650.141     0.150
    75.325    11.500     0.150
    75.829   703.539     0.150
    75.829    12.500     0.150
    76.391   710.836     0.150
    77.645   713.586     0.150
    83.084   742.961     0.150
   117.471  1121.984     0.150
   144.234  1169.242     0.150
   144.234  1173.836     0.150
   144.728  1171.242     0.150
   144.728  1175.742     0.150
   144.995  1171.742     0.150
   144.995  1176.336     0.150
   146.354  1175.039     0.150
   149.837  1186.859     0.150
     0.238     6.250     0.150
     0.238    10.879     0.150
     0.344     7.430     0.150
     0.344    13.000     0.150
     0.613    10.949     0.150
     0.613    19.160     0.150
     0.632    11.328     0.150
     0.632    20.078     0.150
     0.758    13.148     0.150
     0.758    22.781     0.150
     0.779    14.320     0.150
     0.883    15.320     0.150
     0.883    26.270     0.150
     0.877    15.008     0.150
     0.877    26.461     0.150
     0.895    15.438     0.150
     0.947    16.238     0.150
     0.947    28.879     0.150
     0.994    16.078     0.150
     0.994    29.301     0.150
     0.995    17.551     0.150
     1.003    17.738     0.150
     1.061    17.648     0.150
     1.061    30.910     0.150
     1.067    18.059     0.150
     1.067    31.141     0.150
     1.108    17.879     0.150
     1.108    31.578     0.150
     1.104    19.000     0.150
     1.220    20.199     0.150
     1.220    35.879     0.150
     1.287    21.098     0.150
     1.292    21.148     0.150
     1.277    21.199     0.150
     1.368    22.180     0.150
     1.365    21.949     0.150
     1.365    40.719     0.150
     1.393    22.688     0.150
     1.393    40.801     0.150
     1.431    23.301     0.150
     1.431    41.801     0.150
     1.427    23.109     0.150
     1.427    41.711     0.150
     1.442    43.129     0.150
     1.467    23.730     0.150
     1.528    25.000     0.150
     1.533    24.871     0.150
     1.571    25.910     0.150
     1.571    45.930     0.150
     1.650    26.531     0.150
     1.678    27.199     0.150
     1.705    26.969     0.150
     1.780    28.801     0.150
     1.801    28.539     0.150
     1.907    30.461     0.150
     1.906    30.168     0.150
     1.889    29.809     0.150
     1.889    52.988     0.150
     1.935    30.930     0.150
     1.950    30.531     0.150
     1.959    30.828     0.150
     2.016    31.328     0.150
     2.043    32.621     0.150
     2.176    33.930     0.150
     2.184    33.949     0.150
     2.278    35.301     0.150
     2.325    36.008     0.150
     2.342    36.418     0.150
     2.434    37.371     0.150
     2.478    38.340     0.150
     2.709    41.680     0.150
     2.679    41.328     0.150
     2.713    41.270     0.150
     2.704    41.508     0.150
     2.746    41.598     0.150
     2.767    42.230     0.150
     2.876    43.750     0.150
     2.888    44.410     0.150
     2.933    45.301     0.150
     2.948    44.598     0.150
     2.963    45.258     0.150
     3.007    45.961     0.150
     3.015    46.430     0.150
     3.051    46.738     0.150
     3.312    50.680     0.150
     3.459    52.410     0.150
     3.639    55.621     0.150
     4.124    60.285     0.150
     4.124   107.109     0.150
     4.124   124.383     0.150
     4.213    60.668     0.150
     4.200    61.180     0.150
     4.900    71.828     0.150
     4.940    72.008     0.150
     4.970    72.758     0.150
     5.106    74.695     0.150
     5.106   155.258     0.150
     5.405    79.238     0.150
     5.832    84.938     0.150
    11.247   164.109     0.150
    12.151   172.840     0.150
    14.978   471.156     0.150
    20.013   271.938     0.150
    20.187   273.258     0.150
     0.238     6.445     0.150
     0.238    10.922     0.150
     0.451     9.148     0.150
     0.451    15.727     0.150
     0.682    12.070     0.150
     0.682    20.320     0.150
     0.744    13.031     0.150
     0.744    22.766     0.150
     0.732    12.688     0.150
     0.732    22.711     0.150
     1.015    17.422     0.150
     1.015    30.516     0.150
     1.036    17.109     0.150
     1.036    16.945     0.150
     1.036    29.570     0.150
     1.105    18.766     0.150
     1.105    32.586     0.150
     1.203    19.875     0.150
     1.203    20.297     0.150
     1.351    22.711     0.150
     1.380    22.695     0.150
     1.393    22.422     0.150
     1.393    38.906     0.150
     1.548    24.852     0.150
     1.618    24.992     0.150
     1.603    25.898     0.150
     1.683    26.602     0.150
     1.694    27.008     0.150
     1.677    26.531     0.150
     1.710    26.492     0.150
     1.710    26.938     0.150
     1.770    28.578     0.150
     1.770    28.172     0.150
     1.770    48.766     0.150
     1.775    27.352     0.150
     1.775    47.289     0.150
     1.807    28.742     0.150
     1.879    30.047     0.150
     1.949    30.727     0.150
     2.009    31.922     0.150
     2.137    33.117     0.150
     2.176    33.641     0.150
     2.324    35.516     0.150
     2.445    37.492     0.150
     2.531    39.375     0.150
     2.600    40.281     0.150
     2.723    41.961     0.150
     2.902    44.102     0.150
     2.914    44.445     0.150
     2.982    45.570     0.150
     3.124    44.758     0.150
     3.450    51.477     0.150
     3.507    52.852     0.150
     3.553    53.047     0.150
     3.771    56.102     0.150
     3.782    57.867     0.150
    18.535   254.570     0.150
     0.791    14.461     0.150
     0.791    25.201     0.150
     0.840    15.672     0.150
     0.939    16.242     0.150
     0.939    28.961     0.150
     1.235    21.361     0.150
     1.235    37.730     0.150
     1.253    21.361     0.150
     1.253    38.031     0.150
     1.282    37.301     0.150
     1.439    40.002     0.150
     1.508    24.742     0.150
     1.508    43.461     0.150
     1.510    25.191     0.150
     1.510    44.162     0.150
     1.538    43.912     0.150
     1.638    27.561     0.150
     1.780    29.492     0.150
     1.780    51.512     0.150
     2.053    32.012     0.150
     2.053    57.092     0.150
     2.246    35.811     0.150
     2.246    61.191     0.150
     2.498    39.342     0.150
     2.498    68.941     0.150
     2.590    40.391     0.150
     2.590    71.762     0.150
     2.692    72.412     0.150
     2.738    42.592     0.150
     2.832    44.871     0.150
     2.832    76.221     0.150
     2.822    43.531     0.150
     2.946    44.762     0.150
     2.923    45.111     0.150
     2.923    79.541     0.150
     2.976    45.191     0.150
     2.976    78.291     0.150
     3.027    46.592     0.150
     3.080    48.521     0.150
     3.296    50.742     0.150
     3.296    88.191     0.150
     3.420    52.592     0.150
     3.420    91.672     0.150
     3.746    56.951     0.150
     3.746    97.781     0.150
     3.705    56.891     0.150
     3.836    58.852     0.150
     4.069    61.611     0.150
     4.177    63.242     0.150
     4.177   111.561     0.150
     4.124    62.762     0.150
     4.222    63.992     0.150
     4.368    64.791     0.150
     4.493    69.402     0.150
     4.635    68.252     0.150
     4.635   117.752     0.150
     4.725    69.221     0.150
     4.725   120.592     0.150
     4.694    70.801     0.150
     4.719    71.531     0.150
     4.793    72.582     0.150
     4.761    71.832     0.150
     4.823    72.391     0.150
     4.864    74.512     0.150
     4.897    74.572     0.150
     5.018   127.832     0.150
     5.076    74.922     0.150
     5.234    78.951     0.150
     5.337    78.361     0.150
     5.337   136.191     0.150
     5.358    79.162     0.150
     5.687    84.721     0.150
     5.604    85.082     0.150
     5.723    83.211     0.150
     5.723   145.631     0.150
     5.672    86.111     0.150
     5.784    85.262     0.150
     5.813    87.682     0.150
     6.038    91.541     0.150
     6.369    93.182     0.150
     6.513    94.352     0.150
     6.682    98.871     0.150
     7.125   104.270     0.150
     7.125   103.902     0.150
     7.257   105.512     0.150
     7.655   112.322     0.150
     9.109   131.762     0.150
     9.330   134.816     0.150
     9.330   136.141     0.150
     9.909   141.822     0.150
    10.009   143.072     0.150
    10.088   144.662     0.150
    10.863   160.131     0.150
    11.283   161.121     0.150
    11.243   163.672     0.150
    11.461   168.082     0.150
    11.547   168.402     0.150
    11.998   172.352     0.150
    12.156   174.891     0.150
    12.767   185.916     0.150
    12.822   185.781     0.150
    13.378   191.041     0.150
    13.501   194.980     0.150
    13.941   198.932     0.150
    14.096   201.480     0.150
    14.650   209.262     0.150
    15.495   219.861     0.150
    15.507   220.572     0.150
    16.145   231.391     0.150
    16.087   229.771     0.150
    16.559   236.141     0.150
    17.219   243.801     0.150
    17.296   242.771     0.150
    17.728   248.561     0.150
    18.146   254.992     0.150
    18.355   255.281     0.150
    18.505   257.902     0.150
    18.606   258.492     0.150
    18.606   532.691     0.150
    19.357   266.117     0.150
    19.357   266.291     0.150
    20.582   277.592     0.150
    20.582   277.941     0.150
    21.164   287.391     0.150
    21.262   290.121     0.150
    21.531   291.072     0.150
    21.600   291.742     0.150
    21.776   292.061     0.150
    21.725   293.781     0.150
    24.067   317.152     0.150
    24.396   320.271     0.150
    24.433   320.561     0.150
    25.778   332.451     0.150
    27.064   344.262     0.150
    27.064   344.766     0.150
    65.250   641.637     0.150
    67.712   657.166     0.150
    80.864   733.217     0.150
    82.273   745.441     0.150
     0.799    14.605     0.150
     0.858    15.934     0.150
     0.937    16.344     0.150
     0.937    28.906     0.150
     1.245    21.773     0.150
     1.245    36.766     0.150
     1.256    37.863     0.150
     1.297    37.453     0.150
     1.434    23.055     0.150
     1.434    40.273     0.150
     1.508    24.816     0.150
     1.508    43.363     0.150
     1.528    25.484     0.150
     1.528    44.914     0.150
     1.648    27.754     0.150
     1.648    47.625     0.150
     1.556    25.645     0.150
     1.795    29.543     0.150
     2.072    32.395     0.150
     2.263    36.105     0.150
     2.516    39.895     0.150
     2.608    40.945     0.150
     2.710    42.496     0.150
     2.850    45.406     0.150
     2.972    45.344     0.150
     2.972    79.645     0.150
     2.972    45.164     0.150
     2.972    79.465     0.150
     2.964    45.945     0.150
     2.839    44.945     0.150
     2.941    45.965     0.150
     2.941    45.633     0.150
     3.044    47.023     0.150
     3.098    49.395     0.150
     3.312    51.723     0.150
     3.438    52.645     0.150
     3.764    57.293     0.150
     4.085    62.066     0.150
     4.195    63.516     0.150
     4.195   109.605     0.150
     4.177    62.863     0.150
     4.177   108.816     0.150
     4.241    64.043     0.150
     4.626    67.816     0.150
     4.713    69.863     0.150
     4.737    71.855     0.150
     5.005    73.285     0.150
     5.094    74.824     0.150
     5.329    78.766     0.150
     5.329   136.473     0.150
     5.376    79.094     0.150
     5.691    85.184     0.150
     5.711    83.414     0.150
     6.385    93.336     0.150
     6.696    99.215     0.150
     7.144   104.625     0.150
     7.144   104.066     0.150
     8.306   124.473     0.150
     8.834   130.895     0.150
     9.127   131.496     0.150
     9.019   134.223     0.150
     9.324   136.320     0.150
     9.324   239.570     0.150
     9.324   136.746     0.150
     9.324   134.906     0.150
     9.335   137.953     0.150
    10.090   144.734     0.150
    10.758   157.953     0.150
    10.874   159.656     0.150
    11.256   165.816     0.150
    11.474   168.066     0.150
    11.562   169.516     0.150
    12.836   185.715     0.150
    14.229   202.113     0.150
    14.229   204.148     0.150
    15.189   218.625     0.150
    15.523   223.734     0.150
    16.137   228.566     0.150
    16.137   227.145     0.150
    16.100   229.465     0.150
    16.573   234.594     0.150
    17.077   241.285     0.150
    17.313   245.473     0.150
    17.746   250.773     0.150
    18.164   255.695     0.150
    18.595   258.094     0.150
    18.951   263.633     0.150
    19.352   268.844     0.150
    19.769   273.203     0.150
    20.599   279.543     0.150
    21.554   292.094     0.150
    21.788   292.145     0.150
    21.788   291.723     0.150
    24.415   320.855     0.150
    25.795   333.043     0.150
    26.619   341.594     0.150
    64.532   640.914     0.150
    64.754   638.895     0.150
    67.408   656.895     0.150
    76.190   710.395     0.150
    76.190   717.195     0.150
    82.262   743.895     0.150
    93.366   798.395     0.150
     0.449     8.512     0.150
     0.449    13.891     0.150
     0.506    10.621     0.150
     0.506    17.512     0.150
     0.863    14.711     0.150
     0.863    24.781     0.150
     0.896    15.191     0.150
     0.896    26.078     0.150
     0.966    16.770     0.150
     0.966    28.949     0.150
     1.165    19.789     0.150
     1.165    34.809     0.150
     1.269    21.391     0.150
     1.269    37.059     0.150
     1.313    22.211     0.150
     1.313    39.449     0.150
     1.283    21.590     0.150
     1.392    22.910     0.150
     1.392    40.191     0.150
     1.628    26.602     0.150
     1.628    47.969     0.150
     1.770    28.391     0.150
     1.770    49.918     0.150
     1.886    30.148     0.150
     1.886    55.512     0.150
     2.181    35.012     0.150
     2.181    63.711     0.150
     2.242    36.359     0.150
     2.242    64.809     0.150
     2.538    43.051     0.150
     2.538    76.379     0.150
     2.612    43.871     0.150
     2.612    76.641     0.150
     2.676    41.270     0.150
     2.676    80.199     0.150
     2.657    44.309     0.150
     2.657    42.430     0.150
     2.680    40.238     0.150
     2.794    43.059     0.150
     2.794    48.711     0.150
     2.794    81.410     0.150
     2.798    46.539     0.150
     2.924    45.738     0.150
     2.924    84.789     0.150
     3.095    88.488     0.150
     3.435    52.879     0.150
     3.522    53.578     0.150
     3.569    55.621     0.150
     3.612    55.898     0.150
     3.688    64.090     0.150
     3.688   107.160     0.150
     3.844    58.891     0.150
     4.164    63.340     0.150
     4.210    62.789     0.150
     4.210   109.789     0.150
     4.560    67.410     0.150
     4.560   116.852     0.150
     4.722    69.238     0.150
     5.031    73.570     0.150
     5.718    83.160     0.150
     5.654    83.738     0.150
     6.050    87.590     0.150
     6.233    90.770     0.150
     7.475   109.441     0.150
     8.355   123.898     0.150
    10.650   152.680     0.150
    15.394   217.371     0.150
    17.145   240.359     0.150
    17.575   243.180     0.150
    19.571   269.250     0.150
     0.378     7.453     0.150
     0.378    12.652     0.150
     0.467     9.383     0.150
     0.467    16.230     0.150
     0.744    13.352     0.150
     0.784    13.781     0.150
     0.784    23.801     0.150
     0.825    13.973     0.150
     0.825    24.773     0.150
     0.902    27.883     0.150
     1.113    18.531     0.150
     1.113    32.953     0.150
     1.177    19.902     0.150
     1.177    34.023     0.150
     1.213    20.352     0.150
     1.213    35.352     0.150
     1.259    20.371     0.150
     1.280    21.051     0.150
     1.318    21.652     0.150
     1.318    38.523     0.150
     1.583    25.172     0.150
     1.583    46.781     0.150
     1.735    27.082     0.150
     1.735    50.391     0.150
     1.826    28.812     0.150
     1.826    54.102     0.150
     2.135    33.754     0.150
     2.135    63.891     0.150
     2.185    35.273     0.150
     2.185    36.934     0.150
     2.185    64.422     0.150
     2.560    43.582     0.150
     2.560    75.332     0.150
     2.625    78.773     0.150
     2.625    39.543     0.150
     2.618    42.703     0.150
     2.618    77.074     0.150
     2.677    41.602     0.150
     2.744    41.504     0.150
     2.744    80.402     0.150
     2.744    41.902     0.150
     2.744    46.324     0.150
     2.744    81.102     0.150
     2.761    48.703     0.150
     2.761    83.051     0.150
     2.857    44.801     0.150
     3.045    90.324     0.150
     3.389    51.824     0.150
     3.389   102.691     0.150
     3.509    53.684     0.150
     3.618    55.773     0.150
     3.618    62.730     0.150
     3.618   110.332     0.150
     3.790    57.773     0.150
     3.790   108.602     0.150
     4.198    61.594     0.150
     4.198   108.172     0.150
     4.529    66.184     0.150
     4.529   114.980     0.150
     4.554    67.801     0.150
     4.705   120.133     0.150
     5.017    72.102     0.150
     5.017   128.023     0.150
     5.181   156.852     0.150
     5.699    82.164     0.150
     6.778    98.477     0.150
     6.778   203.277     0.150
     7.507   108.672     0.150
     9.103   280.953     0.150
    12.788   185.254     0.150
    13.964   197.863     0.150
    18.519   257.402     0.150
    20.148   272.879     0.150
     0.319     7.148     0.150
     0.319    12.449     0.150
     0.319    12.320     0.150
     0.731    12.828     0.150
     0.731    22.359     0.150
     0.811    14.238     0.150
     0.811    24.520     0.150
     0.825    13.887     0.150
     0.825    24.109     0.150
     0.824    14.297     0.150
     0.824    24.637     0.150
     0.911    15.770     0.150
     1.061    18.168     0.150
     1.142    19.137     0.150
     1.142    32.930     0.150
     1.229    19.867     0.150
     1.229    34.770     0.150
     1.237    20.508     0.150
     1.246    20.617     0.150
     1.246    36.098     0.150
     1.315    21.918     0.150
     1.357    21.918     0.150
     1.357    22.090     0.150
     1.360    22.219     0.150
     1.384    22.930     0.150
     1.384    39.918     0.150
     1.431    22.887     0.150
     1.459    23.938     0.150
     1.459    41.418     0.150
     1.474    23.148     0.150
     1.474    23.477     0.150
     1.474    41.117     0.150
     1.506    25.070     0.150
     1.506    44.070     0.150
     1.536    24.047     0.150
     1.566    25.160     0.150
     1.582    24.398     0.150
     1.582    43.199     0.150
     1.608    25.977     0.150
     1.608    45.000     0.150
     1.632    25.797     0.150
     1.662    26.719     0.150
     1.662    47.520     0.150
     1.726    27.859     0.150
     1.726    48.988     0.150
     1.758    28.598     0.150
     1.758    48.977     0.150
     1.884    29.898     0.150
     1.898    30.348     0.150
     1.898    53.270     0.150
     1.919    30.078     0.150
     1.994    31.418     0.150
     1.994    54.738     0.150
     2.010    31.398     0.150
     2.026    30.969     0.150
     2.028    31.520     0.150
     2.129    33.297     0.150
     2.129    58.199     0.150
     2.319    36.770     0.150
     2.341    36.270     0.150
     2.341    61.848     0.150
     2.387    36.930     0.150
     2.387    64.438     0.150
     2.406    36.617     0.150
     2.502    39.410     0.150
     2.542    38.547     0.150
     2.538    39.289     0.150
     2.749    41.988     0.150
     2.772    43.027     0.150
     2.832    43.277     0.150
     2.862    44.070     0.150
     2.892    44.148     0.150
     2.892    77.270     0.150
     3.033    46.379     0.150
     3.141    48.070     0.150
     3.141    84.949     0.150
     3.208    48.449     0.150
     3.345    50.668     0.150
     3.742    56.660     0.150
     3.854    56.723     0.150
     3.854    99.574     0.150
     3.854   118.223     0.150
     3.854    57.000     0.150
     3.854   100.000     0.150
     4.042    60.250     0.150
     4.042   107.098     0.150
     5.421    78.809     0.150
     5.478    80.500     0.150
     5.478   141.570     0.150
     5.503    79.320     0.150
     5.703    82.223     0.150
     5.703   174.324     0.150
     5.703    81.508     0.150
     5.849    86.340     0.150
     5.849   151.617     0.150
     5.996    86.270     0.150
     6.316    90.137     0.150
     6.897   100.707     0.150
     6.984    99.660     0.150
     7.241   108.414     0.150
     7.770   112.398     0.150
     7.948   117.320     0.150
    10.848   158.074     0.150
    11.537   168.422     0.150
    12.705   183.590     0.150
    15.853   220.500     0.150
    19.731   269.258     0.150
    25.631   329.723     0.150
     0.502     9.898     0.150
     0.502    17.031     0.150
     0.617    11.750     0.150
     0.617    20.609     0.150
     0.752    13.539     0.150
     0.752    22.750     0.150
     0.994    17.461     0.150
     0.994    30.258     0.150
     1.005    17.051     0.150
     1.005    30.230     0.150
     1.283    21.070     0.150
     1.283    36.000     0.150
     1.279    21.418     0.150
     1.279    36.699     0.150
     1.278    21.309     0.150
     1.278    37.371     0.150
     1.341    22.840     0.150
     1.341    39.559     0.150
     1.385    22.121     0.150
     1.499    24.750     0.150
     1.499    43.590     0.150
     1.650    25.801     0.150
     2.788    42.539     0.150
     2.788    73.250     0.150
     2.788    72.781     0.150
     4.908    70.930     0.150
     6.934   100.379     0.150
     8.391   124.598     0.150
    12.243   176.805     0.150
    12.819   185.855     0.150
    14.090   201.430     0.150
    20.326   272.781     0.150
    27.033   342.379     0.150
     0.108     7.227     0.150
     0.108    12.297     0.150
     0.370     8.906     0.150
     0.370    15.422     0.150
     0.412     9.422     0.150
     0.412    16.258     0.150
     0.418     9.359     0.150
     0.445     9.656     0.150
     0.445    16.656     0.150
     0.451     9.812     0.150
     0.451    16.898     0.150
     0.538    11.289     0.150
     0.538    19.680     0.150
     0.577    11.188     0.150
     0.577    19.430     0.150
     0.558    11.719     0.150
     0.558    20.102     0.150
     0.621    12.141     0.150
     0.621    20.422     0.150
     0.665    12.852     0.150
     0.665    21.898     0.150
     0.711    13.281     0.150
     0.737    13.633     0.150
     0.737    23.828     0.150
     0.797    14.547     0.150
     0.797    25.031     0.150
     0.911    16.195     0.150
     0.968    16.977     0.150
     0.968    29.656     0.150
     1.028    17.961     0.150
     1.028    30.969     0.150
     1.041    17.438     0.150
     1.041    30.500     0.150
     1.052    17.961     0.150
     1.052    31.242     0.150
     1.073    18.820     0.150
     1.105    19.352     0.150
     1.105    33.320     0.150
     1.205    20.008     0.150
     1.197    19.531     0.150
     1.197    34.922     0.150
     1.231    20.719     0.150
     1.281    21.109     0.150
     1.314    21.516     0.150
     1.341    22.492     0.150
     1.502    23.719     0.150
     1.501    23.656     0.150
     1.501    23.742     0.150
     1.503    23.766     0.150
     1.478    24.211     0.150
     1.519    24.750     0.150
     1.613    26.695     0.150
     1.698    26.492     0.150
     1.806    29.000     0.150
     1.857    29.289     0.150
     1.849    29.547     0.150
     1.849    49.961     0.150
     1.938    30.586     0.150
     2.135    33.531     0.150
     2.147    33.352     0.150
     2.147    57.188     0.150
     2.222    34.039     0.150
     2.239    35.086     0.150
     2.347    36.359     0.150
     2.394    38.031     0.150
     2.407    37.742     0.150
     2.514    38.719     0.150
     2.609    40.617     0.150
     2.615    40.320     0.150
     2.633    40.188     0.150
     2.756    42.789     0.150
     3.117    48.086     0.150
     3.629    54.297     0.150
     3.815    56.422     0.150
     3.827    56.820     0.150
     4.163    61.688     0.150
     4.767    70.500     0.150
     5.301    78.031     0.150
     0.240     7.077     0.150
     0.240    12.367     0.150
     0.286     7.347     0.150
     0.286    12.876     0.150
     0.320     8.086     0.150
     0.320    14.146     0.150
     0.343     7.906     0.150
     0.343    14.176     0.150
     0.342     7.966     0.150
     0.342    14.196     0.150
     0.364     8.086     0.150
     0.364    14.227     0.150
     0.380     8.546     0.150
     0.380    14.926     0.150
     0.454     9.267     0.150
     0.454    16.296     0.150
     0.568    11.247     0.150
     0.568    19.606     0.150
     0.729    13.316     0.150
     0.729    23.296     0.150
     0.754    13.367     0.150
     0.754    23.626     0.150
     0.749    13.836     0.150
     0.749    24.106     0.150
     0.761    13.937     0.150
     0.761    24.287     0.150
     0.784    24.676     0.150
     0.842    14.376     0.150
     0.842    25.256     0.150
     0.865    14.756     0.150
     0.865    26.176     0.150
     0.860    15.396     0.150
     0.860    26.977     0.150
     0.882    15.376     0.150
     0.882    27.347     0.150
     0.994    16.796     0.150
     0.994    28.867     0.150
     1.041    17.727     0.150
     1.041    31.646     0.150
     1.098    19.026     0.150
     1.098    32.167     0.150
     1.142    19.276     0.150
     1.218    21.086     0.150
     1.218    35.506     0.150
     1.275    21.307     0.150
     1.317    22.126     0.150
     1.317    38.167     0.150
     1.346    22.327     0.150
     1.346    21.977     0.150
     1.346    22.146     0.150
     1.346    37.597     0.150
     1.348    22.356     0.150
     1.388    39.506     0.150
     1.477    25.336     0.150
     1.477    42.006     0.150
     1.684    26.727     0.150
     1.714    27.626     0.150
     1.833    29.227     0.150
     1.866    29.236     0.150
     1.953    30.426     0.150
     2.049    31.856     0.150
     2.049    55.316     0.150
     2.126    33.156     0.150
     2.152    33.167     0.150
     2.293    36.537     0.150
     2.331    35.776     0.150
     2.331    61.256     0.150
     2.652    40.896     0.150
     0.359     8.286     0.150
     0.278     7.536     0.150
     0.357     8.246     0.150
     0.357    14.036     0.150
     0.329     8.106     0.150
     0.329    14.356     0.150
     0.458     9.736     0.150
     0.458    16.917     0.150
     0.525    10.577     0.150
     0.525    18.736     0.150
     0.645    11.847     0.150
     0.645    20.677     0.150
     0.659    12.036     0.150
     0.659    20.927     0.150
     0.681    12.646     0.150
     0.681    22.307     0.150
     0.748    13.866     0.150
     0.748    23.866     0.150
     0.803    14.197     0.150
     0.803    25.146     0.150
     0.813    14.567     0.150
     0.813    25.286     0.150
     0.842    14.776     0.150
     0.842    25.856     0.150
     0.842    14.886     0.150
     0.886    15.016     0.150
     0.886    26.126     0.150
     0.888    15.016     0.150
     0.888    26.136     0.150
     0.902    16.246     0.150
     0.902    28.136     0.150
     0.995    16.547     0.150
     0.995    30.006     0.150
     1.007    16.957     0.150
     1.007    29.577     0.150
     1.051    17.866     0.150
     1.051    32.236     0.150
     1.167    19.766     0.150
     1.168    19.766     0.150
     1.183    19.597     0.150
     1.183    34.486     0.150
     1.308    20.866     0.150
     1.308    36.266     0.150
     1.359    21.967     0.150
     1.359    38.587     0.150
     1.398    22.047     0.150
     1.417    22.957     0.150
     1.417    40.256     0.150
     1.402    22.646     0.150
     1.402    39.597     0.150
     1.508    24.276     0.150
     1.508    41.927     0.150
     1.508    24.396     0.150
     1.518    24.126     0.150
     1.627    26.016     0.150
     1.627    45.317     0.150
     1.700    26.656     0.150
     1.700    46.547     0.150
     1.773    27.827     0.150
     1.773    47.977     0.150
     1.738    28.317     0.150
     1.738    48.886     0.150
     1.776    27.486     0.150
     1.776    48.626     0.150
     1.831    28.677     0.150
     1.837    29.016     0.150
     1.905    29.626     0.150
     1.894    29.217     0.150
     1.894    50.266     0.150
     1.895    29.817     0.150
     1.895    50.547     0.150
     1.894    29.146     0.150
     1.894    50.646     0.150
     1.894    30.656     0.150
     1.894    52.447     0.150
     1.896    29.286     0.150
     1.896    50.817     0.150
     2.088    29.526     0.150
     2.086    54.866     0.150
     2.104    32.957     0.150
     2.253    35.636     0.150
     2.253    62.396     0.150
     2.281    35.347     0.150
     2.316    36.443     0.150
     2.316    62.988     0.150
     2.513    38.496     0.150
     2.554    38.417     0.150
     2.554    64.156     0.150
     2.790    43.486     0.150
     2.790    75.217     0.150
     2.822    41.927     0.150
     2.801    43.156     0.150
     2.801    74.597     0.150
     2.801    43.266     0.150
     2.873    75.871     0.150
     2.889    43.817     0.150
     2.994    44.307     0.150
     3.004    79.396     0.150
     3.004    46.417     0.150
     3.006    44.927     0.150
     3.006    79.347     0.150
     3.146    47.746     0.150
     3.146    83.547     0.150
     3.183    47.697     0.150
     3.152    48.327     0.150
     3.152    82.697     0.150
     3.388    49.486     0.150
     3.388    86.136     0.150
     3.388    49.917     0.150
     3.513    91.817     0.150
     3.550    92.547     0.150
     3.606    54.386     0.150
     3.606    94.396     0.150
     3.883    57.386     0.150
     3.883    99.746     0.150
     3.943    58.457     0.150
     3.943   100.587     0.150
     3.943    59.276     0.150
     3.943   101.986     0.150
     4.062    60.746     0.150
     4.079    61.256     0.150
     4.130    61.977     0.150
     4.197    63.656     0.150
     4.213    63.506     0.150
     4.215    63.067     0.150
     4.322    64.717     0.150
     4.489    67.016     0.150
     4.556    66.797     0.150
     4.556   116.866     0.150
     4.685    68.718     0.150
     4.746    67.687     0.150
     5.214    74.516     0.150
     5.259    77.417     0.150
     5.197    75.396     0.150
     6.093    89.547     0.150
     6.191    87.727     0.150
     0.408     8.555     0.150
     0.408    14.555     0.150
     0.503     9.242     0.150
     0.732    13.023     0.150
     0.842    14.648     0.150
     0.842    25.688     0.150
     0.850    14.664     0.150
     0.878    26.859     0.150
     0.880    14.859     0.150
     1.076    18.461     0.150
     1.032    17.883     0.150
     1.111    19.211     0.150
     1.111    33.031     0.150
     1.154    19.039     0.150
     1.171    19.367     0.150
     1.195    20.422     0.150
     1.195    34.930     0.150
     1.266    21.438     0.150
     1.266    37.805     0.150
     1.257    21.219     0.150
     1.257    37.398     0.150
     1.342    22.398     0.150
     1.342    39.734     0.150
     1.348    22.078     0.150
     1.348    37.703     0.150
     1.436    23.492     0.150
     1.437    23.344     0.150
     1.416    22.602     0.150
     1.529    24.898     0.150
     1.529    45.078     0.150
     1.547    25.273     0.150
     1.663    26.250     0.150
     1.658    25.039     0.150
     1.806    29.234     0.150
     1.806    52.688     0.150
     1.962    30.969     0.150
     1.964    30.789     0.150
     1.991    31.070     0.150
     2.067    32.500     0.150
     2.083    33.328     0.150
     2.156    34.508     0.150
     2.235    34.883     0.150
     2.314    36.383     0.150
     2.327    36.172     0.150
     2.332    36.320     0.150
     2.332    36.219     0.150
     2.434    38.523     0.150
     2.442    38.023     0.150
     2.520    38.539     0.150
     2.548    39.969     0.150
     2.548    81.898     0.150
     2.548    39.312     0.150
     2.548    80.758     0.150
     2.548    39.133     0.150
     2.550    39.555     0.150
     2.592    40.273     0.150
     2.692    41.898     0.150
     2.708    41.562     0.150
     2.772    42.633     0.150
     2.853    44.523     0.150
     2.853    88.188     0.150
     2.933    44.953     0.150
     2.880    43.984     0.150
     2.880    50.055     0.150
     2.880    76.211     0.150
     2.880    83.383     0.150
     2.880    43.398     0.150
     2.880    82.852     0.150
     2.880    42.688     0.150
     3.003    45.539     0.150
     3.015    47.070     0.150
     3.182    49.055     0.150
     3.198    48.773     0.150
     3.230    49.305     0.150
     3.239    48.570     0.150
     3.273    49.898     0.150
     3.406    50.984     0.150
     3.460    53.039     0.150
     3.509    53.500     0.150
     3.626    55.070     0.150
     3.626   112.250     0.150
     3.626    53.859     0.150
     3.655    55.188     0.150
     3.655    54.594     0.150
     3.752    56.438     0.150
     3.721    55.891     0.150
     3.721    54.930     0.150
     3.740    57.008     0.150
     3.839    58.203     0.150
     3.839    57.234     0.150
     3.839    57.711     0.150
     3.839    57.273     0.150
     3.992    60.523     0.150
     4.023    60.531     0.150
     4.023   121.742     0.150
     4.078    62.891     0.150
     4.088    61.812     0.150
     4.088    60.891     0.150
     4.179    62.883     0.150
     4.321    64.086     0.150
     4.351    64.617     0.150
     4.401    65.055     0.150
     4.324    62.898     0.150
     4.324   109.914     0.150
     4.412    66.500     0.150
     4.496    66.930     0.150
     4.506    68.594     0.150
     4.540    67.539     0.150
     4.598    70.258     0.150
     4.702    69.570     0.150
     4.820    72.523     0.150
     4.820    71.422     0.150
     4.835    69.711     0.150
     4.835   122.820     0.150
     4.933    72.633     0.150
     4.933    72.164     0.150
     4.948    73.781     0.150
     4.935    72.984     0.150
     5.082    72.742     0.150
     5.082    72.531     0.150
     5.082    73.562     0.150
     5.082   128.672     0.150
     5.145    74.242     0.150
     5.145   130.328     0.150
     5.145    73.641     0.150
     5.145   130.422     0.150
     5.266    77.422     0.150
     5.266   164.969     0.150
     5.266    76.398     0.150
     5.246    78.164     0.150
     5.467    80.859     0.150
     5.467    80.742     0.150
     5.657    82.070     0.150
     5.699    84.008     0.150
     5.699   177.289     0.150
     5.732    84.898     0.150
     5.799    87.461     0.150
     5.829    83.734     0.150
     5.829   146.891     0.150
     5.927    86.242     0.150
     5.927   184.555     0.150
     5.934    85.883     0.150
     5.975    85.859     0.150
     6.067    88.961     0.150
     6.245    91.633     0.150
     6.245   197.094     0.150
     6.255    92.055     0.150
     6.276    93.000     0.150
     6.340    95.273     0.150
     6.424    94.273     0.150
     6.459    95.641     0.150
     6.468    95.258     0.150
     6.698    95.812     0.150
     6.723    97.438     0.150
     6.723   210.289     0.150
     6.723    96.781     0.150
     6.723    96.570     0.150
     6.791   100.203     0.150
     6.818   100.867     0.150
     7.059   103.586     0.150
     7.109   102.102     0.150
     7.340   107.094     0.150
     7.371   109.031     0.150
     7.448   110.633     0.150
     7.573   235.258     0.150
     7.631   111.523     0.150
     7.726   112.250     0.150
     7.722   111.469     0.150
     7.947   116.453     0.150
     8.099   116.062     0.150
     8.175   120.453     0.150
     8.252   121.859     0.150
     8.343   119.312     0.150
     8.343   118.844     0.150
     8.408   122.688     0.150
     8.456   123.750     0.150
     8.535   125.141     0.150
     8.683   125.219     0.150
     8.683   270.383     0.150
     8.683   124.344     0.150
     8.699   124.523     0.150
     8.705   124.430     0.150
     8.705   270.430     0.150
     8.845   126.773     0.150
     8.835   130.859     0.150
     8.835   129.578     0.150
     8.878   129.141     0.150
     8.949   280.664     0.150
     8.966   131.281     0.150
     9.238   135.688     0.150
     9.238   283.133     0.150
     9.238   135.539     0.150
     9.238   135.078     0.150
     9.379   137.664     0.150
     9.446   290.992     0.150
     9.470   135.070     0.150
     9.470   291.102     0.150
     9.471   138.484     0.150
     9.669   138.250     0.150
     9.735   139.594     0.150
     9.735   306.242     0.150
     9.834   140.641     0.150
     9.842   140.398     0.150
    10.014   146.383     0.150
    10.224   146.820     0.150
    10.224   325.422     0.150
    10.463   148.883     0.150
    10.551   150.617     0.150
    10.607   151.078     0.150
    10.613   154.062     0.150
    10.781   158.000     0.150
    10.976   161.469     0.150
    11.016   161.328     0.150
    11.091   162.383     0.150
    11.160   158.992     0.150
    11.137   162.180     0.150
    11.145   163.961     0.150
    11.161   160.711     0.150
    11.201   163.758     0.150
    11.324   164.352     0.150
    11.374   164.961     0.150
    11.425   163.398     0.150
    11.542   164.531     0.150
    11.640   166.188     0.150
    11.616   169.609     0.150
    11.639   168.398     0.150
    11.670   166.859     0.150
    11.830   172.203     0.150
    12.029   174.773     0.150
    12.036   175.109     0.150
    12.136   174.258     0.150
    12.136   377.828     0.150
    12.195   172.969     0.150
    12.199   177.430     0.150
    12.305   174.352     0.150
    12.341   177.961     0.150
    12.341   177.711     0.150
    12.385   176.492     0.150
    12.412   177.562     0.150
    12.412   176.211     0.150
    12.378   179.961     0.150
    12.466   176.703     0.150
    12.467   181.383     0.150
    12.472   178.773     0.150
    12.568   178.500     0.150
    12.502   179.391     0.150
    12.541   182.305     0.150
    12.541   182.398     0.150
    12.605   181.164     0.150
    12.605   179.398     0.150
    12.627   178.805     0.150
    12.673   183.359     0.150
    12.757   180.555     0.150
    12.761   181.219     0.150
    12.772   181.164     0.150
    12.809   184.117     0.150
    12.948   186.703     0.150
    12.892   185.078     0.150
    12.892   410.109     0.150
    12.892   184.102     0.150
    13.025   186.188     0.150
    13.053   186.953     0.150
    13.053   187.992     0.150
    13.103   187.711     0.150
    13.158   188.992     0.150
    13.174   188.641     0.150
    13.198   187.781     0.150
    13.190   191.219     0.150
    13.219   424.508     0.150
    13.288   189.898     0.150
    13.245   189.852     0.150
    13.270   190.758     0.150
    13.270   190.641     0.150
    13.292   191.133     0.150
    13.362   189.758     0.150
    13.400   191.391     0.150
    13.450   193.070     0.150
    13.528   193.820     0.150
    13.633   194.312     0.150
    13.599   195.914     0.150
    13.692   195.914     0.150
    13.692   193.758     0.150
    13.736   195.078     0.150
    13.745   194.219     0.150
    13.817   196.609     0.150
    13.807   197.609     0.150
    13.807   196.680     0.150
    13.876   197.398     0.150
    13.876   197.078     0.150
    13.876   196.992     0.150
    13.876   197.898     0.150
    13.876   435.102     0.150
    13.914   200.703     0.150
    13.950   198.938     0.150
    13.945   199.617     0.150
    13.984   198.758     0.150
    14.105   200.820     0.150
    14.138   201.469     0.150
    14.143   201.352     0.150
    14.160   201.562     0.150
    14.117   203.094     0.150
    14.215   202.578     0.150
    14.261   199.781     0.150
    14.256   202.805     0.150
    14.268   204.922     0.150
    14.298   202.688     0.150
    14.280   203.922     0.150
    14.449   205.344     0.150
    14.441   204.852     0.150
    14.484   206.367     0.150
    14.522   208.781     0.150
    14.500   206.023     0.150
    14.500   205.664     0.150
    14.500   204.328     0.150
    14.543   207.930     0.150
    14.571   208.383     0.150
    14.627   206.828     0.150
    14.571   205.273     0.150
    14.604   208.508     0.150
    14.697   207.758     0.150
    14.719   208.312     0.150
    14.730   210.445     0.150
    14.730   210.164     0.150
    14.785   466.258     0.150
    14.759   210.586     0.150
    14.810   467.141     0.150
    14.833   212.258     0.150
    14.808   211.219     0.150
    14.872   367.734     0.150
    14.872   460.234     0.150
    14.926   467.617     0.150
    14.929   467.203     0.150
    14.922   213.945     0.150
    14.948   211.922     0.150
    14.978   211.703     0.150
    15.006   212.320     0.150
    15.003   214.688     0.150
    14.977   212.062     0.150
    14.977   210.539     0.150
    15.047   212.859     0.150
    15.067   213.383     0.150
    15.067   215.922     0.150
    15.108   216.008     0.150
    15.108   215.664     0.150
    15.178   215.750     0.150
    15.193   214.883     0.150
    15.190   214.828     0.150
    15.233   215.758     0.150
    15.246   216.562     0.150
    15.250   218.258     0.150
    15.277   216.359     0.150
    15.277   215.898     0.150
    15.240   214.062     0.150
    15.460   218.641     0.150
    15.399   216.430     0.150
    15.461   217.492     0.150
    15.478   219.133     0.150
    15.453   220.516     0.150
    15.499   220.477     0.150
    15.534   220.719     0.150
    15.528   221.812     0.150
    15.554   219.391     0.150
    15.549   220.422     0.150
    15.637   221.352     0.150
    15.643   222.594     0.150
    15.694   221.664     0.150
    15.809   220.445     0.150
    15.809   220.055     0.150
    15.776   222.750     0.150
    15.776   221.391     0.150
    15.807   222.172     0.150
    15.902   226.250     0.150
    15.955   224.773     0.150
    15.965   225.672     0.150
    15.978   226.875     0.150
    15.987   227.461     0.150
    16.008   227.234     0.150
    16.008   226.961     0.150
    16.045   226.852     0.150
    16.146   227.258     0.150
    16.137   228.078     0.150
    16.137   227.305     0.150
    16.185   229.609     0.150
    16.251   230.000     0.150
    16.269   228.508     0.150
    16.269   228.102     0.150
    16.307   231.969     0.150
    16.347   231.094     0.150
    16.349   229.320     0.150
    16.388   231.562     0.150
    16.419   231.773     0.150
    16.419   230.914     0.150
    16.458   232.242     0.150
    16.568   233.859     0.150
    16.578   234.844     0.150
    16.579   233.859     0.150
    16.676   235.797     0.150
    16.811   235.883     0.150
    16.801   235.758     0.150
    16.801   235.641     0.150
    16.871   237.219     0.150
    16.862   238.000     0.150
    16.889   236.203     0.150
    16.892   238.555     0.150
    16.921   237.859     0.150
    16.921   237.164     0.150
    16.975   239.062     0.150
    17.028   238.781     0.150
    16.990   238.922     0.150
    16.990   237.883     0.150
    17.089   238.758     0.150
    17.085   240.352     0.150
    17.085   240.188     0.150
    17.161   238.516     0.150
    17.161   238.008     0.150
    17.145   239.812     0.150
    17.219   238.203     0.150
    17.211   240.438     0.150
    17.144   239.461     0.150
    17.162   240.164     0.150
    17.162   240.008     0.150
    17.232   241.945     0.150
    17.197   239.711     0.150
    17.196   240.258     0.150
    17.275   242.500     0.150
    17.283   241.914     0.150
    17.304   433.820     0.150
    17.332   244.031     0.150
    17.307   241.273     0.150
    17.372   244.539     0.150
    17.344   242.562     0.150
    17.344   242.023     0.150
    17.412   244.898     0.150
    17.425   245.242     0.150
    17.458   242.938     0.150
    17.444   245.516     0.150
    17.444   245.617     0.150
    17.395   242.664     0.150
    17.442   244.094     0.150
    17.593   247.219     0.150
    17.635   244.969     0.150
    17.613   247.367     0.150
    17.640   247.688     0.150
    17.640   441.086     0.150
    17.640   248.031     0.150
    17.647   247.867     0.150
    17.624   246.078     0.150
    17.700   248.742     0.150
    17.728   246.367     0.150
    17.781   248.539     0.150
    17.836   248.562     0.150
    17.870   249.938     0.150
    17.949   251.734     0.150
    17.918   249.328     0.150
    18.033   250.211     0.150
    18.033   250.062     0.150
    18.033   249.859     0.150
    18.043   251.773     0.150
    18.043   251.391     0.150
    18.098   253.680     0.150
    18.139   249.883     0.150
    18.171   252.609     0.150
    18.171   252.312     0.150
    18.209   254.688     0.150
    18.209   254.234     0.150
    18.253   250.523     0.150
    18.253   249.961     0.150
    18.311   256.727     0.150
    18.293   254.367     0.150
    18.321   254.484     0.150
    18.347   255.562     0.150
    18.411   255.711     0.150
    18.587   258.062     0.150
    18.650   259.359     0.150
    18.700   258.992     0.150
    18.700   258.102     0.150
    18.654   257.023     0.150
    18.654   258.359     0.150
    18.654   589.914     0.150
    18.654   258.367     0.150
    18.719   260.461     0.150
    18.844   260.930     0.150
    18.844   260.438     0.150
    18.808   260.203     0.150
    18.842   259.914     0.150
    18.921   262.922     0.150
    18.879   261.664     0.150
    19.016   263.359     0.150
    19.016   262.289     0.150
    19.151   264.953     0.150
    19.151   264.641     0.150
    19.168   264.320     0.150
    19.191   264.055     0.150
    19.255   264.812     0.150
    19.255   610.812     0.150
    19.255   264.633     0.150
    19.255   603.141     0.150
    19.255   264.523     0.150
    19.261   265.430     0.150
    19.376   262.469     0.150
    19.370   267.133     0.150
    19.455   268.156     0.150
    19.455   267.844     0.150
    19.482   263.438     0.150
    19.473   266.344     0.150
    19.522   269.383     0.150
    19.556   264.516     0.150
    19.552   267.281     0.150
    19.552   267.141     0.150
    19.513   267.633     0.150
    19.583   269.094     0.150
    19.703   265.789     0.150
    19.747   266.766     0.150
    19.748   266.461     0.150
    19.831   267.836     0.150
    19.819   271.344     0.150
    20.006   269.039     0.150
    20.009   269.797     0.150
    20.052   631.117     0.150
    19.982   273.641     0.150
    20.102   270.375     0.150
    20.128   271.180     0.150
    20.136   270.609     0.150
    20.140   271.562     0.150
    20.140   494.234     0.150
    20.140   623.188     0.150
    20.140   270.820     0.150
    20.140   627.602     0.150
    20.140   270.102     0.150
    20.255   271.836     0.150
    20.271   271.250     0.150
    20.279   273.359     0.150
    20.328   276.969     0.150
    20.328   276.523     0.150
    20.461   274.562     0.150
    20.473   275.664     0.150
    20.479   274.320     0.150
    20.461   279.305     0.150
    20.501   279.781     0.150
    20.501   279.164     0.150
    20.562   275.359     0.150
    20.562   274.883     0.150
    20.710   276.414     0.150
    20.745   277.094     0.150
    20.764   276.961     0.150
    20.777   278.898     0.150
    20.798   278.406     0.150
    20.785   281.219     0.150
    20.792   281.461     0.150
    20.897   278.828     0.150
    20.979   280.406     0.150
    20.960   282.312     0.150
    20.960   284.391     0.150
    20.960   283.961     0.150
    20.995   279.688     0.150
    21.016   281.008     0.150
    20.995   285.250     0.150
    20.995   284.758     0.150
    21.035   279.938     0.150
    21.022   284.828     0.150
    21.062   285.102     0.150
    21.178   281.789     0.150
    21.179   282.609     0.150
    21.266   284.023     0.150
    21.295   282.125     0.150
    21.292   287.250     0.150
    21.336   283.188     0.150
    21.353   283.188     0.150
    21.355   285.758     0.150
    21.355   285.148     0.150
    21.355   288.555     0.150
    21.404   284.844     0.150
    21.391   289.898     0.150
    21.391   289.117     0.150
    21.369   289.039     0.150
    21.369   288.492     0.150
    21.483   290.062     0.150
    21.536   285.508     0.150
    21.562   288.391     0.150
    21.612   286.148     0.150
    21.614   287.539     0.150
    21.660   287.859     0.150
    21.660   287.602     0.150
    21.683   288.062     0.150
    21.726   287.852     0.150
    21.774   290.602     0.150
    21.774   290.188     0.150
    21.816   289.180     0.150
    21.922   289.102     0.150
    21.922   291.156     0.150
    21.943   289.617     0.150
    21.948   291.789     0.150
    21.958   291.844     0.150
    22.020   290.539     0.150
    22.021   291.422     0.150
    22.080   291.500     0.150
    22.151   292.742     0.150
    22.192   297.828     0.150
    22.192   297.633     0.150
    22.287   294.211     0.150
    22.305   295.844     0.150
    22.248   298.586     0.150
    22.348   296.344     0.150
    22.422   295.609     0.150
    22.444   295.797     0.150
    22.472   296.484     0.150
    22.456   300.281     0.150
    22.581   296.617     0.150
    22.577   299.078     0.150
    22.626   297.047     0.150
    22.637   298.562     0.150
    22.662   297.500     0.150
    22.672   298.094     0.150
    22.736   300.039     0.150
    22.740   299.359     0.150
    22.781   299.602     0.150
    22.834   299.977     0.150
    22.853   301.828     0.150
    22.919   301.180     0.150
    23.018   302.734     0.150
    23.061   302.867     0.150
    23.092   302.164     0.150
    23.105   303.602     0.150
    23.110   302.406     0.150
    23.134   304.805     0.150
    23.165   302.570     0.150
    23.236   304.141     0.150
    23.321   304.789     0.150
    23.323   305.125     0.150
    23.329   306.516     0.150
    23.363   307.773     0.150
    23.387   305.234     0.150
    23.446   307.492     0.150
    23.469   306.422     0.150
    23.473   306.266     0.150
    23.473   305.680     0.150
    23.541   307.961     0.150
    23.541   307.102     0.150
    23.566   308.328     0.150
    23.632   310.922     0.150
    23.639   308.477     0.150
    23.657   312.000     0.150
    23.657   311.398     0.150
    23.675   310.945     0.150
    23.683   308.617     0.150
    23.681   309.750     0.150
    23.720   310.383     0.150
    23.700   312.297     0.150
    23.700   311.680     0.150
    23.820   311.906     0.150
    23.807   313.664     0.150
    23.799   313.461     0.150
    23.845   310.961     0.150
    23.856   310.414     0.150
    23.872   312.344     0.150
    23.893   312.008     0.150
    23.914   312.383     0.150
    23.920   314.078     0.150
    24.026   314.773     0.150
    24.026   314.422     0.150
    24.036   313.359     0.150
    24.059   316.164     0.150
    24.059   315.750     0.150
    24.097   313.750     0.150
    24.094   315.367     0.150
    24.140   314.992     0.150
    24.158   315.797     0.150
    24.181   314.227     0.150
    24.187   313.180     0.150
    24.219   316.875     0.150
    24.264   316.109     0.150
    24.153   316.922     0.150
    24.327   315.766     0.150
    24.389   315.055     0.150
    24.380   316.570     0.150
    24.392   319.750     0.150
    24.423   318.242     0.150
    24.501   318.836     0.150
    24.511   317.234     0.150
    24.530   319.078     0.150
    24.546   318.055     0.150
    24.544   319.508     0.150
    24.582   317.328     0.150
    24.583   318.109     0.150
    24.610   319.492     0.150
    24.627   320.031     0.150
    24.641   319.203     0.150
    24.655   320.039     0.150
    24.658   320.258     0.150
    24.608   320.734     0.150
    24.721   320.523     0.150
    24.748   320.641     0.150
    24.741   321.344     0.150
    24.774   321.352     0.150
    24.837   322.125     0.150
    24.865   321.508     0.150
    24.844   323.641     0.150
    24.919   323.102     0.150
    24.934   322.523     0.150
    24.975   323.742     0.150
    25.010   323.562     0.150
    25.028   321.719     0.150
    25.041   323.406     0.150
    25.052   324.469     0.150
    25.181   325.805     0.150
    25.195   325.414     0.150
    25.208   324.977     0.150
    25.222   324.391     0.150
    25.269   326.328     0.150
    25.354   326.508     0.150
    25.409   327.086     0.150
    25.406   327.500     0.150
    25.458   328.391     0.150
    25.458   327.859     0.150
    25.469   327.828     0.150
    25.484   328.102     0.150
    25.510   328.219     0.150
    25.530   328.758     0.150
    25.523   328.070     0.150
    25.612   329.102     0.150
    25.616   329.594     0.150
    25.616   329.461     0.150
    25.645   329.234     0.150
    25.700   329.914     0.150
    25.701   329.969     0.150
    25.701   329.844     0.150
    25.711   329.727     0.150
    25.756   329.273     0.150
    25.837   330.867     0.150
    25.867   330.109     0.150
    25.846   330.164     0.150
    25.907   331.703     0.150
    25.927   331.969     0.150
    25.946   332.188     0.150
    25.945   332.625     0.150
    25.945   332.492     0.150
    26.000   332.469     0.150
    26.016   332.875     0.150
    26.078   333.438     0.150
    26.134   333.641     0.150
    26.184   334.062     0.150
    26.222   334.773     0.150
    26.116   335.617     0.150
    26.217   333.273     0.150
    26.279   335.180     0.150
    26.275   335.289     0.150
    26.278   335.070     0.150
    26.288   335.219     0.150
    26.295   335.438     0.150
    26.326   335.617     0.150
    26.381   335.898     0.150
    26.413   336.141     0.150
    26.460   336.680     0.150
    26.460   336.555     0.150
    26.481   337.047     0.150
    26.493   337.266     0.150
    26.493   336.570     0.150
    26.487   336.703     0.150
    26.505   337.273     0.150
    26.598   338.266     0.150
    26.611   337.133     0.150
    26.607   338.195     0.150
    26.529   338.672     0.150
    26.711   338.930     0.150
    26.726   338.883     0.150
    26.723   339.562     0.150
    26.730   339.609     0.150
    26.759   338.992     0.150
    26.774   339.727     0.150
    26.836   341.141     0.150
    26.860   340.398     0.150
    26.836   341.258     0.150
    26.915   340.914     0.150
    26.926   340.602     0.150
    26.943   340.828     0.150
    26.991   341.117     0.150
    27.034   342.281     0.150
    27.034   342.273     0.150
    27.074   342.844     0.150
    27.152   343.070     0.150
    27.174   341.805     0.150
    27.199   343.109     0.150
    27.219   344.219     0.150
    27.266   343.398     0.150
    27.272   344.047     0.150
    27.309   344.547     0.150
    27.333   344.609     0.150
    27.330   344.523     0.150
    27.347   344.852     0.150
    27.385   345.109     0.150
    27.413   345.219     0.150
    27.522   345.750     0.150
    27.531   347.031     0.150
    27.558   346.555     0.150
    27.620   347.984     0.150
    27.631   347.203     0.150
    27.639   347.312     0.150
    27.778   348.453     0.150
    27.786   348.391     0.150
    27.780   348.383     0.150
    27.828   349.883     0.150
    27.834   348.453     0.150
    27.750   349.898     0.150
    27.877   349.734     0.150
    27.877   349.812     0.150
    27.879   350.484     0.150
    27.878   351.008     0.150
    27.900   350.578     0.150
    27.956   350.062     0.150
    27.978   350.242     0.150
    28.012   349.859     0.150
    28.033   350.992     0.150
    28.052   350.969     0.150
    28.084   351.219     0.150
    28.165   351.352     0.150
    28.184   351.953     0.150
    28.203   352.812     0.150
    28.221   352.008     0.150
    28.216   352.078     0.150
    28.291   353.234     0.150
    28.324   352.688     0.150
    28.380   353.664     0.150
    28.381   354.000     0.150
    28.416   354.258     0.150
    28.415   354.320     0.150
    28.447   355.055     0.150
    28.457   355.094     0.150
    28.516   354.180     0.150
    28.478   356.180     0.150
    28.558   355.664     0.150
    28.584   355.406     0.150
    28.651   356.141     0.150
    28.651   356.906     0.150
    28.734   356.859     0.150
    28.720   357.180     0.150
    28.715   356.797     0.150
    28.719   357.023     0.150
    28.756   358.156     0.150
    28.756   357.562     0.150
    28.761   356.180     0.150
    28.755   357.773     0.150
    28.757   357.953     0.150
    28.781   356.969     0.150
    28.782   357.336     0.150
    28.782   893.383     0.150
    28.782   356.664     0.150
    28.782   357.461     0.150
    28.782   355.648     0.150
    28.841   358.852     0.150
    28.849   358.086     0.150
    28.970   359.141     0.150
    28.980   358.930     0.150
    28.998   359.664     0.150
    29.021   359.398     0.150
    29.070   361.031     0.150
    29.041   359.609     0.150
    29.061   359.586     0.150
    29.080   359.430     0.150
    29.079   359.648     0.150
    29.094   359.555     0.150
    29.111   361.266     0.150
    29.108   360.219     0.150
    29.146   361.258     0.150
    29.179   361.305     0.150
    29.246   360.562     0.150
    29.256   361.820     0.150
    29.258   362.492     0.150
    29.293   362.445     0.150
    29.321   361.734     0.150
    29.337   361.102     0.150
    29.347   361.836     0.150
    29.375   362.953     0.150
    29.451   363.781     0.150
    29.461   363.492     0.150
    29.482   363.938     0.150
    29.482   363.578     0.150
    29.518   364.844     0.150
    29.553   363.945     0.150
    29.554   365.500     0.150
    29.463   364.133     0.150
    29.572   364.383     0.150
    29.570   364.555     0.150
    29.600   363.758     0.150
    29.593   365.562     0.150
    29.597   365.180     0.150
    29.614   365.422     0.150
    29.620   365.188     0.150
    29.624   364.875     0.150
    29.656   365.109     0.150
    29.693   364.625     0.150
    29.712   365.305     0.150
    29.726   367.094     0.150
    29.795   367.242     0.150
    29.799   367.562     0.150
    29.823   367.383     0.150
    29.841   365.914     0.150
    29.871   366.453     0.150
    29.877   367.867     0.150
    29.903   368.148     0.150
    29.923   368.188     0.150
    29.933   368.445     0.150
    29.943   367.055     0.150
    29.942   368.406     0.150
    29.969   368.695     0.150
    29.979   367.070     0.150
    29.998   367.867     0.150
    30.002   369.078     0.150
    30.025   367.789     0.150
    30.042   370.188     0.150
    30.093   370.062     0.150
    30.206   370.219     0.150
    30.246   371.609     0.150
    30.265   369.344     0.150
    30.258   369.969     0.150
    30.250   371.984     0.150
    30.276   372.547     0.150
    30.294   370.477     0.150
    30.293   371.930     0.150
    30.337   372.500     0.150
    30.331   372.633     0.150
    30.345   372.180     0.150
    30.368   372.477     0.150
    30.377   371.203     0.150
    30.416   371.781     0.150
    30.425   371.453     0.150
    30.460   373.000     0.150
    30.475   373.867     0.150
    30.498   372.758     0.150
    30.498   372.211     0.150
    30.489   373.867     0.150
    30.503   374.195     0.150
    30.605   373.305     0.150
    30.611   374.602     0.150
    30.624   375.602     0.150
    30.632   374.969     0.150
    30.666   373.859     0.150
    30.674   374.289     0.150
    30.670   376.188     0.150
    30.707   375.055     0.150
    30.720   376.680     0.150
    30.738   374.500     0.150
    30.776   375.352     0.150
    30.759   377.070     0.150
    30.824   376.883     0.150
    30.861   375.930     0.150
    30.869   377.133     0.150
    30.911   375.945     0.150
    30.919   378.438     0.150
    30.935   376.914     0.150
    31.091   378.680     0.150
    31.103   378.734     0.150
    31.128   378.281     0.150
    31.146   379.336     0.150
    31.156   380.383     0.150
    31.168   377.859     0.150
    31.170   380.695     0.150
    31.201   379.367     0.150
    31.242   379.906     0.150
    31.243   381.242     0.150
    31.256   381.703     0.150
    31.287   380.281     0.150
    31.310   380.977     0.150
    31.323   380.109     0.150
    31.303   381.844     0.150
    31.330   380.641     0.150
    31.333   381.219     0.150
    31.395   380.961     0.150
    31.395   380.711     0.150
    31.398   380.258     0.150
    31.398   380.117     0.150
    31.461   381.266     0.150
    31.521   383.055     0.150
    31.553   383.070     0.150
    31.563   384.352     0.150
    31.582   382.688     0.150
    31.602   383.438     0.150
    31.669   384.945     0.150
    31.683   384.305     0.150
    31.712   380.508     0.150
    31.726   383.641     0.150
    31.721   385.070     0.150
    31.818   383.430     0.150
    31.846   385.664     0.150
    31.862   383.328     0.150
    31.956   386.195     0.150
    31.991   386.961     0.150
    32.065   388.328     0.150
    32.086   388.273     0.150
    32.100   387.859     0.150
    32.136   386.555     0.150
    32.148   387.438     0.150
    32.178   389.117     0.150
    32.211   388.547     0.150
    32.227   389.203     0.150
    32.247   387.680     0.150
    32.317   389.672     0.150
    32.331   386.438     0.150
    32.331   385.680     0.150
    32.434   391.367     0.150
    32.443   391.109     0.150
    32.505   390.922     0.150
    32.545   391.336     0.150
    32.586   390.062     0.150
    32.586   389.594     0.150
    32.603   392.789     0.150
    32.600   391.383     0.150
    32.724   393.141     0.150
    32.776   392.508     0.150
    32.786   392.203     0.150
    32.841   393.961     0.150
    32.866   394.188     0.150
    32.880   395.734     0.150
    32.880   395.719     0.150
    33.092   395.203     0.150
    33.108   397.250     0.150
    33.136   397.164     0.150
    33.179   395.055     0.150
    33.178   395.508     0.150
    33.214   397.453     0.150
    33.247   397.031     0.150
    33.199   398.453     0.150
    33.253   396.102     0.150
    33.256   396.719     0.150
    33.232   394.555     0.150
    33.283   399.203     0.150
    33.302   396.750     0.150
    33.311   397.148     0.150
    33.348   399.312     0.150
    33.381   397.414     0.150
    33.439   398.328     0.150
    33.431   399.336     0.150
    33.512   400.203     0.150
    33.600   398.805     0.150
    33.605   399.578     0.150
    33.674   399.883     0.150
    33.750   401.008     0.150
    33.738   403.266     0.150
    33.764   400.742     0.150
    33.793   401.094     0.150
    33.793   400.852     0.150
    33.762   401.758     0.150
    33.827   401.328     0.150
    33.879   401.742     0.150
    33.905   403.734     0.150
    33.924   402.234     0.150
    33.947   402.078     0.150
    33.982   403.359     0.150
    33.996   404.570     0.150
    34.032   404.172     0.150
    34.076   405.273     0.150
    34.091   405.625     0.150
    34.309   405.031     0.150
    34.305   405.539     0.150
    34.305   405.258     0.150
    34.337   406.117     0.150
    34.342   407.492     0.150
    34.388   407.562     0.150
    34.471   409.859     0.150
    34.525   409.172     0.150
    34.599   407.898     0.150
    34.743   411.031     0.150
    34.890   410.555     0.150
    34.934   410.789     0.150
    35.088   413.523     0.150
    35.112   412.273     0.150
    35.344   414.094     0.150
    35.364   413.828     0.150
    35.570   415.750     0.150
    35.577   416.664     0.150
    35.810   417.742     0.150
    35.846   418.898     0.150
    35.897   419.461     0.150
    35.897   419.211     0.150
    36.096   420.555     0.150
    36.106   419.758     0.150
    36.203   422.180     0.150
    36.203   421.664     0.150
    36.190   424.367     0.150
    36.271   421.359     0.150
    36.192   422.758     0.150
    36.192   421.844     0.150
    36.441   424.383     0.150
    36.441   424.484     0.150
    36.441   423.281     0.150
    36.596   424.734     0.150
    36.693   425.383     0.150
    36.698   425.398     0.150
    36.728   425.414     0.150
    36.749   425.852     0.150
    36.778   427.164     0.150
    36.778   426.922     0.150
    36.750   428.969     0.150
    36.959   428.148     0.150
    36.963   428.453     0.150
    36.974   427.773     0.150
    36.974   427.961     0.150
    36.871   430.062     0.150
    37.006   429.062     0.150
    37.019   428.203     0.150
    37.045   429.039     0.150
    36.897   429.359     0.150
    36.897     6.602     0.150
    36.897   567.562     0.150
    36.897   778.461     0.150
    36.897   790.461     0.150
    36.897   921.461     0.150
    37.099   429.383     0.150
    37.204   430.617     0.150
    37.091   432.461     0.150
    37.091   432.031     0.150
    37.096   431.758     0.150
    37.257   431.344     0.150
    37.266   430.367     0.150
    37.321   430.469     0.150
    37.249   433.141     0.150
    37.435   432.164     0.150
    37.459   432.602     0.150
    37.430   434.258     0.150
    37.499   432.039     0.150
    37.421   433.852     0.150
    37.459   435.242     0.150
    37.527   435.305     0.150
    37.758   435.164     0.150
    37.758   434.312     0.150
    37.835   434.523     0.150
    37.892   435.961     0.150
    37.975   437.281     0.150
    38.029   436.070     0.150
    38.113   437.422     0.150
    38.216   438.844     0.150
    38.226   438.570     0.150
    38.332   439.961     0.150
    38.362   440.141     0.150
    38.389   440.711     0.150
    38.453   441.508     0.150
    38.509   441.062     0.150
    38.620   442.078     0.150
    38.717   442.719     0.150
    38.721   442.961     0.150
    38.776   442.594     0.150
    38.818   443.844     0.150
    38.843   444.523     0.150
    39.242   449.141     0.150
    39.707   451.531     0.150
    40.029   453.961     0.150
    40.218   456.148     0.150
    40.218   455.453     0.150
    40.732   459.891     0.150
    40.886   462.953     0.150
    40.916   462.133     0.150
    40.916   463.258     0.150
    40.916   461.641     0.150
    41.130   462.680     0.150
    41.130   463.352     0.150
    41.444   466.703     0.150
    41.831   468.648     0.150
    42.446   475.062     0.150
    42.446   474.289     0.150
    43.187   479.688     0.150
    43.535   484.648     0.150
    43.521   483.812     0.150
    43.736   485.664     0.150
    43.897   486.078     0.150
    43.897   485.539     0.150
    44.707   493.164     0.150
    44.707   599.461     0.150
    44.707   888.062     0.150
    44.707   492.938     0.150
    44.978   495.359     0.150
    45.183   496.828     0.150
    45.183   496.344     0.150
    45.183   497.336     0.150
    45.183   602.688     0.150
    47.202   510.562     0.150
    47.202   621.562     0.150
    47.202   924.961     0.150
    47.210   513.672     0.150
    47.981   519.758     0.150
    48.101   519.062     0.150
    48.101   518.391     0.150
    48.781   523.539     0.150
    49.687   532.281     0.150
    49.687   646.703     0.150
    50.380   537.289     0.150
    50.425   538.078     0.150
    50.610   538.602     0.150
    50.667   540.258     0.150
    50.790   539.492     0.150
    50.790   539.500     0.150
    50.793   539.469     0.150
    50.793   539.344     0.150
    50.794   539.422     0.150
    50.794   974.438     0.150
    50.794   539.305     0.150
    50.794   539.391     0.150
    50.796   539.414     0.150
    50.796   539.273     0.150
    50.798   539.289     0.150
    50.939   541.922     0.150
    51.725   547.258     0.150
    51.725   547.961     0.150
    51.725     6.000     0.150
    51.725   983.359     0.150
    51.725   996.258     0.150
    51.976   548.531     0.150
    52.245   550.578     0.150
    52.353   549.883     0.150
    52.620   553.961     0.150
    53.051   556.883     0.150
    53.137   556.992     0.150
    53.137  1006.508     0.150
    53.237   558.898     0.150
    53.327   558.359     0.150
    53.327     8.398     0.150
    53.327   625.461     0.150
    53.327   675.664     0.150
    53.327  1007.359     0.150
    53.327  1025.461     0.150
    53.327  1145.461     0.150
    53.327  1232.859     0.150
    53.327   559.039     0.150
    53.722   561.531     0.150
    53.776   563.281     0.150
    53.894   562.961     0.150
    53.894   679.961     0.150
    54.344   566.117     0.150
    54.344  1024.180     0.150
    54.831   571.359     0.150
    54.831  1030.062     0.150
    54.831  1257.461     0.150
    54.983   570.664     0.150
    56.596   582.523     0.150
    56.587   581.461     0.150
    56.587     7.898     0.150
    56.587   634.758     0.150
    56.587  1054.258     0.150
    56.587  1069.961     0.150
    56.587  1169.562     0.150
    56.587   582.531     0.150
    56.795   582.711     0.150
    56.697   582.664     0.150
    56.939   584.500     0.150
    57.399   588.383     0.150
    57.649   589.461     0.150
    57.649   588.633     0.150
    57.720   589.508     0.150
    57.820   590.117     0.150
    57.996   592.031     0.150
    58.245   593.219     0.150
    58.271   594.305     0.150
    58.459   594.188     0.150
    58.459  1076.719     0.150
    58.467   596.500     0.150
    58.565   596.062     0.150
    58.565    12.602     0.150
    58.565  1074.164     0.150
    58.738   597.672     0.150
    58.738  1081.148     0.150
    58.790   597.703     0.150
    58.804   596.742     0.150
    58.870   598.273     0.150
    58.881   598.211     0.150
    58.881  2381.859     0.150
    59.068   600.484     0.150
    59.087   601.859     0.150
    59.087  1089.258     0.150
    59.194   600.414     0.150
    59.194   732.062     0.150
    59.194  1088.867     0.150
    59.282   601.102     0.150
    59.396   602.242     0.150
    59.512   603.859     0.150
    59.680   602.812     0.150
    59.674   603.562     0.150
    59.607   602.258     0.150
    59.607     6.406     0.150
    59.607     9.000     0.150
    59.607   649.258     0.150
    59.607   733.961     0.150
    59.607  1091.758     0.150
    59.607  1102.664     0.150
    59.607  1191.359     0.150
    59.607  1328.961     0.150
    59.692   602.758     0.150
    59.723   602.305     0.150
    59.723   603.211     0.150
    59.723  2381.633     0.150
    59.723   603.641     0.150
    59.723  1094.008     0.150
    59.723   602.344     0.150
    59.885   604.680     0.150
    59.922   605.023     0.150
    60.147   605.812     0.150
    60.373   607.344     0.150
    60.553   609.891     0.150
    60.680   610.867     0.150
    60.720   611.258     0.150
    61.023   614.141     0.150
    61.023   613.883     0.150
    61.095   613.219     0.150
    61.095  1111.305     0.150
    61.358   614.711     0.150
    61.689   618.109     0.150
    61.777   618.109     0.150
    61.812   618.703     0.150
    61.828   617.859     0.150
    61.883   620.383     0.150
    61.912   619.250     0.150
    61.929   617.961     0.150
    62.084   619.539     0.150
    62.082   620.953     0.150
    62.116   620.383     0.150
    62.116   620.453     0.150
    62.259   620.461     0.150
    62.259   620.117     0.150
    62.414   621.867     0.150
    62.422   621.117     0.150
    62.440   623.781     0.150
    62.467   761.961     0.150
    62.467  1120.961     0.150
    62.467  1137.961     0.150
    62.467  1373.961     0.150
    62.498   622.883     0.150
    62.699   624.352     0.150
    62.745   626.055     0.150
    62.758   625.250     0.150
    62.758  1135.328     0.150
    62.781   624.352     0.150
    62.802   625.008     0.150
    62.802  1132.422     0.150
    62.796   627.258     0.150
    62.796   626.055     0.150
    62.796   626.883     0.150
    62.955   626.953     0.150
    62.955  1138.859     0.150
    62.958   626.469     0.150
    62.958     7.891     0.150
    62.958  1132.641     0.150
    63.211   626.883     0.150
    63.218   627.500     0.150
    63.291   627.508     0.150
    63.328   628.320     0.150
    63.336   632.469     0.150
    63.336  1140.828     0.150
    63.361   628.273     0.150
    63.361   627.961     0.150
    63.396   628.883     0.150
    63.396   628.781     0.150
    63.572   629.609     0.150
    63.569   629.562     0.150
    63.576   629.734     0.150
    63.576     8.523     0.150
    63.576   770.555     0.150
    63.576  1145.203     0.150
    63.616   630.438     0.150
    63.821   631.211     0.150
    63.917   633.422     0.150
    63.936   632.461     0.150
    64.009   634.555     0.150
    64.057   633.344     0.150
    64.057  1150.734     0.150
    64.070   633.812     0.150
    64.255   633.758     0.150
    64.250   636.789     0.150
    64.380   634.352     0.150
    64.572   636.992     0.150
    64.609   636.008     0.150
    64.646   637.250     0.150
    64.729   637.273     0.150
    64.801   639.203     0.150
    64.822   637.703     0.150
    64.831   637.578     0.150
    64.864   638.281     0.150
    64.867   637.719     0.150
    64.973   638.258     0.150
    64.973   638.102     0.150
    64.959   638.758     0.150
    64.959   639.062     0.150
    64.959   638.836     0.150
    64.959  2366.062     0.150
    64.878   639.062     0.150
    64.969   638.609     0.150
    65.011   639.469     0.150
    65.054   639.703     0.150
    64.992   639.562     0.150
    64.992   786.258     0.150
    64.992  1160.562     0.150
    64.992   639.211     0.150
    65.174   639.969     0.150
    65.174   640.828     0.150
    65.174  1164.258     0.150
    65.174  1415.180     0.150
    65.304   641.594     0.150
    65.304  1166.398     0.150
    65.304   640.164     0.150
    65.370   641.422     0.150
    65.388   642.578     0.150
    65.388   786.250     0.150
    65.388  1166.602     0.150
    65.416   642.062     0.150
    65.656   642.320     0.150
    65.725  1173.562     0.150
    65.643   644.359     0.150
    65.791   644.672     0.150
    65.789   644.930     0.150
    65.789  1171.930     0.150
    65.789  1426.469     0.150
    65.789   644.812     0.150
    65.813   645.070     0.150
    65.831   644.062     0.150
    66.037   646.672     0.150
    66.037  2367.125     0.150
    66.037   646.320     0.150
    66.037   646.164     0.150
    66.037   646.312     0.150
    66.037   646.258     0.150
    66.037  1176.164     0.150
    66.213   646.758     0.150
    66.250   645.844     0.150
    66.182   646.562     0.150
    66.264   647.664     0.150
    66.308   648.320     0.150
    66.469   650.258     0.150
    66.584   650.359     0.150
    66.584   676.164     0.150
    66.584   792.258     0.150
    66.744   650.430     0.150
    66.835   651.258     0.150
    66.913   651.562     0.150
    66.913   650.539     0.150
    66.826   652.859     0.150
    67.307   655.359     0.150
    67.466   654.609     0.150
    67.466   654.961     0.150
    67.466  2358.438     0.150
    67.466  2361.664     0.150
    67.487   655.039     0.150
    67.509   656.281     0.150
    67.619   655.961     0.150
    67.562   655.844     0.150
    67.635   656.164     0.150
    67.635   806.664     0.150
    67.635  1186.359     0.150
    67.635  1451.258     0.150
    68.035   658.234     0.150
    68.408   660.914     0.150
    68.408   661.055     0.150
    68.418   660.484     0.150
    68.475   661.859     0.150
    68.616   661.805     0.150
    68.780   664.133     0.150
    68.852   664.273     0.150
    68.897   664.398     0.150
    68.934   666.461     0.150
    69.079   664.758     0.150
    69.111   666.234     0.150
    69.347   666.805     0.150
    69.479   669.359     0.150
    69.613   669.117     0.150
    69.605   668.164     0.150
    69.605   820.562     0.150
    69.605  1217.359     0.150
    69.605  1486.664     0.150
    69.548   668.383     0.150
    69.548   668.055     0.150
    69.568   670.258     0.150
    69.568  1217.359     0.150
    69.568  1477.258     0.150
    69.687   670.164     0.150
    69.638   670.461     0.150
    69.671   670.461     0.150
    69.744   668.758     0.150
    69.744  1213.562     0.150
    69.889   671.164     0.150
    69.796   670.008     0.150
    70.012   671.758     0.150
    70.023   671.758     0.150
    70.023  1222.664     0.150
    70.271   673.461     0.150
    70.412   672.758     0.150
    70.427  2356.391     0.150
    70.427   673.758     0.150
    70.427  1229.258     0.150
    70.427  1492.461     0.150
    70.427   674.398     0.150
    70.427   675.461     0.150
    71.063   677.062     0.150
    71.147   678.359     0.150
    71.071   677.250     0.150
    71.102   678.664     0.150
    71.102   834.484     0.150
    71.102   678.211     0.150
    71.102   678.664     0.150
    71.102   834.461     0.150
    71.261   678.680     0.150
    71.309   678.859     0.150
    71.307   680.664     0.150
    71.345   677.258     0.150
    71.345  1235.562     0.150
    71.345  1516.562     0.150
    71.695   681.258     0.150
    71.712   681.117     0.150
    71.712     9.891     0.150
    71.649   681.664     0.150
    71.733   681.320     0.150
    72.173   684.562     0.150
    72.172   684.258     0.150
    72.376   685.992     0.150
    72.415   686.258     0.150
    72.415   685.773     0.150
    72.415   687.070     0.150
    72.485   685.844     0.150
    72.485    10.008     0.150
    72.485  1253.289     0.150
    72.533   686.664     0.150
    72.497   687.359     0.150
    72.497  1252.359     0.150
    72.497  1531.961     0.150
    72.581   686.719     0.150
    72.630   687.289     0.150
    72.643   687.094     0.150
    72.699   687.562     0.150
    72.673   687.781     0.150
    72.686  2348.898     0.150
    72.669   687.805     0.150
    72.920   689.281     0.150
    73.070   690.133     0.150
    73.072   689.062     0.150
    73.072  1252.562     0.150
    73.212   691.562     0.150
    73.212  1255.961     0.150
    73.212  1535.859     0.150
    73.392   691.914     0.150
    73.392     8.258     0.150
    73.392   707.367     0.150
    73.392  1263.422     0.150
    73.510   692.219     0.150
    73.510   692.562     0.150
    73.581   691.922     0.150
    73.581   692.188     0.150
    73.821   693.961     0.150
    73.821   705.961     0.150
    73.821  1265.961     0.150
    73.821  1301.961     0.150
    73.821  1554.961     0.150
    73.971   695.062     0.150
    73.971  1264.461     0.150
    73.999   694.844     0.150
    73.999  1269.672     0.150
    74.095   695.961     0.150
    74.095   711.664     0.150
    74.095     7.898     0.150
    74.095   867.961     0.150
    74.095  1268.961     0.150
    74.095  1281.961     0.150
    74.095  1305.961     0.150
    74.095  1551.961     0.150
    74.095  2352.961     0.150
    74.095   695.250     0.150
    74.304   696.961     0.150
    74.271   697.062     0.150
    74.387   696.961     0.150
    74.387     7.000     0.150
    74.387   873.961     0.150
    74.387  1271.961     0.150
    74.387  1305.961     0.150
    74.387  1567.961     0.150
    74.419   696.758     0.150
    74.419  1271.664     0.150
    74.461   697.258     0.150
    74.461   862.562     0.150
    74.461  1270.758     0.150
    74.461  1560.258     0.150
    74.492   697.859     0.150
    74.492   863.859     0.150
    74.492  1273.961     0.150
    74.492  1308.258     0.150
    74.492  1564.461     0.150
    74.706   699.562     0.150
    74.732   700.664     0.150
    74.743   699.930     0.150
    74.743  1284.961     0.150
    74.743  1566.961     0.150
    74.743  2356.641     0.150
    74.771   701.109     0.150
    74.909   700.461     0.150
    74.909     6.000     0.150
    74.909  1280.859     0.150
    74.997   700.258     0.150
    74.997     6.805     0.150
    74.997     8.305     0.150
    74.997   712.562     0.150
    74.997  1278.359     0.150
    74.997  1316.062     0.150
    74.997  1571.359     0.150
    74.946   701.062     0.150
    74.946  1268.359     0.150
    74.946  1284.062     0.150
    74.946  1565.359     0.150
    75.046   700.062     0.150
    74.967   700.961     0.150
    75.044   701.461     0.150
    75.106   701.664     0.150
    75.106   871.562     0.150
    75.106  1276.562     0.150
    75.099   701.664     0.150
    75.071  1281.164     0.150
    75.220   702.359     0.150
    75.220  1281.258     0.150
    75.225   702.461     0.150
    75.225   871.961     0.150
    75.225  1285.164     0.150
    75.225  1573.758     0.150
    75.349   702.961     0.150
    75.373   703.359     0.150
    75.388   704.172     0.150
    75.388     7.852     0.150
    75.388  1286.414     0.150
    75.410   703.562     0.150
    75.541   704.734     0.150
    75.541     7.930     0.150
    75.541  1288.430     0.150
    75.541   712.664     0.150
    75.593   704.258     0.150
    75.600   706.164     0.150
    75.614   704.758     0.150
    75.614   878.062     0.150
    75.614  1284.961     0.150
    75.614  1571.664     0.150
    75.604   704.961     0.150
    75.604     8.000     0.150
    75.604  1289.062     0.150
    75.604  1580.664     0.150
    75.604   712.961     0.150
    75.623   704.562     0.150
    75.623     6.102     0.150
    75.623   874.562     0.150
    75.623  1289.461     0.150
    75.708   705.562     0.150
    75.708     7.797     0.150
    75.708  1290.258     0.150
    75.708  2346.758     0.150
    75.708   713.359     0.150
    75.748   705.961     0.150
    75.815   706.664     0.150
    75.846   706.961     0.150
    75.855   706.258     0.150
    75.855  1285.859     0.150
    75.842   706.562     0.150
    75.842     7.898     0.150
    75.842  1292.758     0.150
    75.842   714.461     0.150
    75.847   706.164     0.150
    75.847     6.094     0.150
    75.847   879.562     0.150
    75.847  1292.164     0.150
    75.847   712.258     0.150
    75.892   705.461     0.150
    76.005   706.758     0.150
    76.005  1288.359     0.150
    76.005   705.359     0.150
    76.012   707.258     0.150
    76.022   709.562     0.150
    76.175   707.859     0.150
    76.217   708.461     0.150
    76.222   708.461     0.150
    76.222     8.203     0.150
    76.222   885.562     0.150
    76.222  1296.062     0.150
    76.222  1592.461     0.150
    76.222  2347.859     0.150
    76.222   716.664     0.150
    76.222   707.609     0.150
    76.261   708.664     0.150
    76.309   708.461     0.150
    76.346   710.461     0.150
    76.378   708.758     0.150
    76.378  1292.359     0.150
    76.378  1586.758     0.150
    76.370   709.258     0.150
    76.370  1293.562     0.150
    76.370   709.859     0.150
    76.370  1584.359     0.150
    76.474   711.062     0.150
    76.488   709.961     0.150
    76.515   709.164     0.150
    76.515   709.961     0.150
    76.515  1868.414     0.150
    76.515  2345.758     0.150
    76.523   709.062     0.150
    76.564   710.859     0.150
    76.564  1296.164     0.150
    76.599   710.562     0.150
    76.593   710.758     0.150
    76.601   711.461     0.150
    76.594   710.961     0.150
    76.594  1595.664     0.150
    76.631   710.211     0.150
    76.631  1294.664     0.150
    76.685   711.164     0.150
    76.685   709.961     0.150
    76.769   711.758     0.150
    76.769   709.758     0.150
    76.770   710.484     0.150
    76.784   712.461     0.150
    76.779   711.164     0.150
    76.779     5.898     0.150
    76.779  1300.859     0.150
    76.779  1599.664     0.150
    76.779   717.062     0.150
    76.810   711.359     0.150
    76.823   711.422     0.150
    76.823     8.461     0.150
    76.823  1300.664     0.150
    76.823   710.562     0.150
    76.861   711.359     0.150
    76.861  1296.258     0.150
    76.861  1594.562     0.150
    76.873   712.359     0.150
    76.882   711.461     0.150
    76.901  2344.852     0.150
    77.108   713.570     0.150
    77.130   714.164     0.150
    77.135   715.961     0.150
    77.182   713.664     0.150
    77.226   713.461     0.150
    77.226  1301.062     0.150
    77.223   714.258     0.150
    77.272   715.164     0.150
    77.272  1305.758     0.150
    77.283   715.383     0.150
    77.305   714.062     0.150
    77.238   713.258     0.150
    77.322   715.164     0.150
    77.345   715.461     0.150
    77.342   715.508     0.150
    77.385   715.062     0.150
    77.406   714.461     0.150
    77.406   894.164     0.150
    77.406  1304.461     0.150
    77.497   716.562     0.150
    77.577   716.062     0.150
    77.541   898.758     0.150
    77.541  1308.164     0.150
    77.541  1616.258     0.150
    77.541   716.164     0.150
    77.688   717.305     0.150
    77.688   725.367     0.150
    77.688  1311.492     0.150
    77.710   716.758     0.150
    77.720   715.859     0.150
    77.720     6.898     0.150
    77.720  1318.258     0.150
    77.740   717.562     0.150
    77.740   725.258     0.150
    77.769   716.633     0.150
    77.769  1307.148     0.150
    77.769   716.758     0.150
    77.769   894.961     0.150
    77.773   716.859     0.150
    77.773   896.258     0.150
    77.782   716.062     0.150
    77.821   718.758     0.150
    77.821   724.062     0.150
    77.861   716.102     0.150
    77.861  1308.469     0.150
    77.861  1609.984     0.150
    77.909   718.164     0.150
    77.909   723.758     0.150
    77.879   715.859     0.150
    77.946   718.312     0.150
    78.000   718.172     0.150
    78.000  1309.773     0.150
    78.000   717.859     0.150
    78.022   718.164     0.150
    78.022  1311.562     0.150
    78.014   719.023     0.150
    78.014   718.859     0.150
    78.040   718.859     0.150
    78.040   901.164     0.150
    78.040  1313.562     0.150
    78.034   718.984     0.150
    78.034     7.828     0.150
    78.034  1314.734     0.150
    78.034   726.758     0.150
    78.058   718.562     0.150
    78.058   899.359     0.150
    78.058  1312.062     0.150
    78.058   718.398     0.150
    78.053   718.164     0.150
    78.068   719.023     0.150
    78.112   718.359     0.150
    78.139   720.062     0.150
    78.139   898.062     0.150
    78.139  1313.461     0.150
    78.139  1334.562     0.150
    78.139  1616.562     0.150
    78.172   719.461     0.150
    78.172  1858.188     0.150
    78.172  2343.961     0.150
    78.172   719.039     0.150
    78.178   718.289     0.150
    78.195   719.461     0.150
    78.195   724.758     0.150
    78.195  1314.664     0.150
    78.278   718.586     0.150
    78.278  2338.359     0.150
    78.278   718.461     0.150
    78.282   718.664     0.150
    78.282   718.430     0.150
    78.290   717.703     0.150
    78.314   720.164     0.150
    78.356   720.562     0.150
    78.356   902.164     0.150
    78.356  1314.961     0.150
    78.387   720.562     0.150
    78.387  1315.461     0.150
    78.385   720.164     0.150
    78.441   720.961     0.150
    78.441   729.461     0.150
    78.441  1315.664     0.150
    78.474   721.516     0.150
    78.507   720.883     0.150
    78.572   721.062     0.150
    78.606   722.062     0.150
    78.606   727.961     0.150
    78.544   725.258     0.150
    78.544   904.062     0.150
    78.667   719.961     0.150
    78.861   722.703     0.150
    78.899   722.562     0.150
    78.923   723.430     0.150
    78.878   723.664     0.150
    78.991   724.562     0.150
    79.113   723.461     0.150
    79.113   730.164     0.150
    79.113  1315.664     0.150
    79.113  1627.758     0.150
    79.181   725.461     0.150
    79.190   724.617     0.150
    79.295   725.039     0.150
    79.295   910.352     0.150
    79.295  1322.430     0.150
    79.378   724.258     0.150
    79.409   726.039     0.150
    79.409   732.953     0.150
    79.409   909.922     0.150
    79.409  1327.289     0.150
    79.409  1637.484     0.150
    79.412   726.164     0.150
    79.412   733.461     0.150
    79.532   726.758     0.150
    79.532   735.359     0.150
    79.512   727.164     0.150
    79.512   737.062     0.150
    79.512  1326.859     0.150
    79.512  1348.562     0.150
    79.512  1639.758     0.150
    79.572   725.711     0.150
    79.572  1326.961     0.150
    79.650   726.805     0.150
    79.650  1328.062     0.150
    79.733   727.539     0.150
    79.977   739.758     0.150
    79.977   916.758     0.150
    79.977  1333.758     0.150
    79.977  1346.859     0.150
    79.977   729.062     0.150
    80.056   730.758     0.150
    80.423   729.203     0.150
    80.449   730.961     0.150
    80.480   732.258     0.150
    80.475  2333.984     0.150
    80.475   730.859     0.150
    80.596   731.961     0.150
    80.714   733.258     0.150
    80.800   734.164     0.150
    80.864   733.258     0.150
    80.864   732.969     0.150
    80.864   732.961     0.150
    80.884   732.812     0.150
    80.928   735.461     0.150
    80.962   734.164     0.150
    80.920   733.664     0.150
    80.988   735.359     0.150
    81.352   737.062     0.150
    81.563   737.664     0.150
    81.564   736.859     0.150
    81.564   736.523     0.150
    81.666   739.258     0.150
    81.777   737.961     0.150
    81.777   919.961     0.150
    81.777  1351.961     0.150
    81.777  1358.961     0.150
    81.777  1395.961     0.150
    81.826   738.961     0.150
    82.085   740.961     0.150
    82.175   741.758     0.150
    82.224   740.961     0.150
    82.314   741.562     0.150
    82.309   742.461     0.150
    82.309   931.664     0.150
    82.309  1356.359     0.150
    82.309  1369.961     0.150
    82.309  1680.164     0.150
    82.458   743.461     0.150
    82.459   742.562     0.150
    82.493   743.258     0.150
    82.517   742.961     0.150
    82.581   743.164     0.150
    82.523   743.562     0.150
    82.624   743.758     0.150
    82.657   743.164     0.150
    83.129   744.961     0.150
    83.140   745.164     0.150
    83.178   745.562     0.150
    83.178   753.461     0.150
    83.178  1364.562     0.150
    83.178  1687.664     0.150
    83.310   746.258     0.150
    83.400   747.164     0.150
    83.459   750.961     0.150
    83.515   747.461     0.150
    83.522   748.062     0.150
    83.547   747.258     0.150
    83.554   748.562     0.150
    83.473   747.758     0.150
    83.473   942.664     0.150
    83.473  1366.664     0.150
    83.564   747.633     0.150
    83.564  1854.484     0.150
    83.564   747.305     0.150
    83.700   748.461     0.150
    83.649   749.062     0.150
    83.649   754.664     0.150
    83.649   946.164     0.150
    83.649  1368.359     0.150
    83.649  1381.461     0.150
    83.719   747.664     0.150
    83.743   748.164     0.150
    83.828   750.758     0.150
    83.942   749.562     0.150
    83.942   750.859     0.150
    83.942   749.562     0.150
    83.950   750.258     0.150
    83.965   749.461     0.150
    83.976   749.664     0.150
    84.011   754.758     0.150
    84.150   750.758     0.150
    84.146   750.758     0.150
    84.199   750.961     0.150
    84.281   753.258     0.150
    84.374   750.758     0.150
    84.461   753.000     0.150
    84.652   945.961     0.150
    84.778   753.961     0.150
    84.797   754.062     0.150
    84.797   754.562     0.150
    84.797   753.758     0.150
    84.797   752.961     0.150
    84.730   753.742     0.150
    84.775   753.664     0.150
    84.812   753.281     0.150
    84.812   949.484     0.150
    84.812  1376.078     0.150
    84.868   753.031     0.150
    84.868  1375.164     0.150
    84.868  1714.258     0.150
    84.943   754.758     0.150
    84.943   755.234     0.150
    84.943   753.898     0.150
    84.943   949.094     0.150
    84.943  1375.188     0.150
    85.062   755.461     0.150
    85.046   754.609     0.150
    85.046   950.852     0.150
    85.046  1377.008     0.150
    85.152   754.961     0.150
    85.149   755.000     0.150
    85.149   951.648     0.150
    85.149  1377.688     0.150
    85.210   755.109     0.150
    85.252   755.562     0.150
    85.252     7.297     0.150
    85.252     8.000     0.150
    85.252  1377.461     0.150
    85.452   757.961     0.150
    85.350   756.664     0.150
    85.350  1382.461     0.150
    85.392   756.922     0.150
    85.566   758.461     0.150
    85.584   758.273     0.150
    85.512   756.180     0.150
    85.619   757.414     0.150
    85.682   758.961     0.150
    85.808   759.531     0.150
    85.840   759.859     0.150
    85.840   759.594     0.150
    85.774   761.664     0.150
    85.774   958.664     0.150
    85.774  1383.758     0.150
    85.774  1390.062     0.150
    85.774  1728.758     0.150
    85.870   759.461     0.150
    85.946   760.164     0.150
    86.042   759.859     0.150
    85.958   759.188     0.150
    86.072   760.664     0.150
    86.128   760.961     0.150
    86.062   758.992     0.150
    86.090   760.508     0.150
    86.210   761.961     0.150
    86.210  1385.961     0.150
    86.210  1729.961     0.150
    86.284   761.359     0.150
    86.303   761.664     0.150
    86.310   761.758     0.150
    86.421   764.562     0.150
    86.421   762.211     0.150
    86.505   762.562     0.150
    86.532   763.859     0.150
    86.587   761.648     0.150
    86.589   763.164     0.150
    86.593   761.461     0.150
    86.618   763.258     0.150
    86.633   763.461     0.150
    86.633   763.945     0.150
    86.612   762.961     0.150
    86.655   765.859     0.150
    86.712   763.859     0.150
    86.717   763.562     0.150
    86.717     6.602     0.150
    86.717   962.664     0.150
    86.717  1388.258     0.150
    86.717  1746.359     0.150
    86.769   762.820     0.150
    86.836   763.664     0.150
    86.896   764.984     0.150
    86.896   969.039     0.150
    86.896   764.781     0.150
    86.876   764.758     0.150
    86.937   761.562     0.150
    86.907   768.258     0.150
    86.961   767.562     0.150
    87.064   765.359     0.150
    87.119   763.961     0.150
    87.162   766.461     0.150
    87.242   766.062     0.150
    87.354   766.859     0.150
    87.354   766.164     0.150
    87.432   764.461     0.150
    87.517   770.062     0.150
    87.540   767.562     0.150
    87.603   768.758     0.150
    87.619   766.062     0.150
    87.619  1393.500     0.150
    87.705   767.859     0.150
    87.721   771.562     0.150
    87.819   768.664     0.150
    87.841   768.164     0.150
    87.889   768.062     0.150
    87.910   769.164     0.150
    87.946   766.961     0.150
    87.946   769.461     0.150
    87.932   771.164     0.150
    87.932   971.859     0.150
    87.932  1388.562     0.150
    87.932  1398.359     0.150
    88.051   771.070     0.150
    88.099   769.062     0.150
    88.117   771.258     0.150
    88.150   769.859     0.150
    88.198   769.562     0.150
    88.129   771.164     0.150
    88.129   975.562     0.150
    88.129  1396.961     0.150
    88.129  1413.562     0.150
    88.252   772.398     0.150
    88.275   771.758     0.150
    88.306   769.062     0.150
    88.366   771.023     0.150
    88.448   771.562     0.150
    88.469   770.758     0.150
    88.573   769.562     0.150
    88.590   771.562     0.150
    88.625   775.859     0.150
    88.629   771.859     0.150
    88.580   773.398     0.150
    88.691   768.562     0.150
    88.790   777.164     0.150
    88.821   771.258     0.150
    88.921   776.164     0.150
    89.008   775.758     0.150
    89.001   775.422     0.150
    89.053   774.859     0.150
    89.162   778.062     0.150
    89.162   991.062     0.150
    89.162  1402.562     0.150
    89.162  1422.461     0.150
    89.162  1436.258     0.150
    89.162  1779.359     0.150
    89.227   777.516     0.150
    89.227   778.258     0.150
    89.256   774.664     0.150
    89.314   775.461     0.150
    89.322   777.656     0.150
    89.380   778.000     0.150
    89.394   777.062     0.150
    89.394   777.883     0.150
    89.414   776.461     0.150
    89.418   776.742     0.150
    89.424   778.164     0.150
    89.515   778.664     0.150
    89.574   781.461     0.150
    89.677   777.984     0.150
    89.678   777.914     0.150
    89.678   987.984     0.150
    89.678  1828.812     0.150
    89.678  2319.211     0.150
    89.915   778.859     0.150
    89.916   778.344     0.150
    90.074   992.664     0.150
    90.074  1421.461     0.150
    90.289   782.258     0.150
    90.574   783.164     0.150
    90.574   783.000     0.150
    90.574   784.078     0.150
    90.595   778.859     0.150
    90.595   781.461     0.150
    90.602   782.664     0.150
    90.602  1000.359     0.150
    90.602  1411.562     0.150
    90.602  1428.461     0.150
    90.602  1797.961     0.150
    90.961   783.562     0.150
    91.015   783.359     0.150
    91.242   782.891     0.150
    91.736   789.562     0.150
    91.813   789.664     0.150
    91.843   792.164     0.150
    92.008   786.961     0.150
    92.131   788.641     0.150
    92.368   789.961     0.150
    92.385   789.359     0.150
    92.287   789.664     0.150
    92.287  1008.258     0.150
    92.287  1421.859     0.150
    92.287  1522.961     0.150
    92.287  1821.562     0.150
    92.287   789.344     0.150
    92.398   789.562     0.150
    92.951   793.484     0.150
    93.031   793.867     0.150
    93.562  1022.258     0.150
    93.562  1430.859     0.150
    93.562  1464.859     0.150
    93.562  1830.461     0.150
    94.198   800.258     0.150
    94.198  1853.461     0.150
    94.198   800.562     0.150
    94.265   800.359     0.150
    94.265   798.859     0.150
    95.224   803.664     0.150
    95.249   806.961     0.150
    95.249  1037.062     0.150
    95.249  1479.164     0.150
    96.048   808.562     0.150
    96.978   811.578     0.150
    97.563   812.484     0.150
    97.563   813.203     0.150
    97.539   814.383     0.150
    97.538   814.164     0.150
    97.617   814.359     0.150
    97.685   816.211     0.150
    97.685  1451.961     0.150
    97.751   814.859     0.150
    97.919   816.164     0.150
    97.920   816.164     0.150
    98.082   816.562     0.150
    98.098   816.859     0.150
    98.142   817.461     0.150
    98.324   817.758     0.150
    98.453   818.562     0.150
   101.072   831.562     0.150
   101.072  1079.945     0.150
   101.436   832.023     0.150
   102.623  1089.133     0.150
   103.206   839.148     0.150
   103.206  1088.461     0.150
   103.206  1793.883     0.150
   103.845   843.828     0.150
   104.467   845.734     0.150
   105.052  1787.188     0.150
   106.020   850.430     0.150
   106.165   851.188     0.150
   107.935   861.148     0.150
   108.123   862.539     0.150
   108.123  1131.969     0.150
   108.123  1500.328     0.150
   108.328   860.805     0.150
   108.328  1133.930     0.150
   108.328  1498.250     0.150
   108.400   862.461     0.150
   108.931   867.008     0.150
   108.931  1138.711     0.150
   108.931  1509.102     0.150
   109.623   868.188     0.150
   109.623  1143.031     0.150
   109.623  1506.438     0.150
   109.701   866.359     0.150
   109.701  1142.930     0.150
   109.701  1506.930     0.150
   109.703   867.211     0.150
   109.758   867.539     0.150
   109.872   867.398     0.150
   110.299   871.570     0.150
   110.299  1146.250     0.150
   110.299  1511.992     0.150
   110.319  1113.859     0.150
   110.332   872.836     0.150
   110.332  1112.312     0.150
   110.332  1141.055     0.150
   110.332  1783.164     0.150
   110.768   875.250     0.150
   110.768  1150.648     0.150
   110.768  1507.711     0.150
   110.851   875.109     0.150
   110.851  1149.188     0.150
   110.851  1516.062     0.150
   111.441   876.867     0.150
   111.441  1156.805     0.150
   111.441  1509.773     0.150
   112.417   882.320     0.150
   112.417  1163.031     0.150
   112.417  1519.188     0.150
   112.830   883.867     0.150
   112.830  1167.141     0.150
   112.830  1519.555     0.150
   113.274   885.641     0.150
   113.274  1117.664     0.150
   113.274  1333.758     0.150
   113.274  1764.414     0.150
   114.190  1119.289     0.150
   114.190  1764.359     0.150
   118.563  1128.258     0.150
   121.927  1133.492     0.150
   123.854  1138.547     0.150
   130.113  1152.086     0.150
   130.113  1281.133     0.150
   130.113  1367.234     0.150
   130.113  1151.758     0.150
   130.314  1149.859     0.150
   133.814  1154.812     0.150
   133.814  1364.633     0.150
   133.814  1371.383     0.150
   133.814  1156.828     0.150
   139.178  1165.742     0.150
   144.460  1172.695     0.150
   144.965  1174.859     0.150
   145.226  1175.141     0.150
   146.566  1179.414     0.150
   146.566  1178.656     0.150
   146.566  1392.656     0.150
   146.566  1177.461     0.150
   147.728  1183.664     0.150
   149.383  1186.258     0.150
   150.453  1190.289     0.150
   150.453  1187.664     0.150
   150.453  1191.562     0.150
   150.722  1193.359     0.150
   151.341  1188.258     0.150
   151.341  1195.562     0.150
   151.341  2577.359     0.150
   151.753  1194.398     0.150
   153.304  1193.961     0.150
   159.263  1192.961     0.150
   161.026  1198.195     0.150
   161.026  1240.945     0.150
   161.026  1196.359     0.150
     0.451    15.836     0.150
     0.554    10.266     0.150
     0.554    17.266     0.150
     0.906    15.773     0.150
     0.900    26.164     0.150
     0.938    16.188     0.150
     0.879    15.109     0.150
     1.080    18.438     0.150
     1.121    18.914     0.150
     1.169    19.969     0.150
     1.249    21.250     0.150
     1.175    19.484     0.150
     1.175    35.164     0.150
     1.193    19.844     0.150
     1.318    22.094     0.150
     1.319    22.055     0.150
     1.400    23.117     0.150
     1.442    23.547     0.150
     1.457    23.586     0.150
     1.568    25.086     0.150
     1.583    25.305     0.150
     1.693    26.961     0.150
     1.855    29.414     0.150
     1.983    31.547     0.150
     2.121    33.539     0.150
     2.202    34.570     0.150
     2.346    36.727     0.150
     2.351    37.320     0.150
     2.467    38.906     0.150
     2.562    38.930     0.150
     2.575    40.023     0.150
     2.575    39.938     0.150
     2.575    39.648     0.150
     2.577    39.977     0.150
     2.638    40.828     0.150
     2.722    42.094     0.150
     2.731    42.430     0.150
     2.919    44.492     0.150
     2.919    50.633     0.150
     2.919    76.789     0.150
     2.919    83.273     0.150
     2.919    44.867     0.150
     2.905    45.273     0.150
     4.918    74.688     0.150
     5.094    74.477     0.150
     5.094   128.719     0.150
     5.157    75.078     0.150
     5.157   130.617     0.150
    13.896   198.492     0.150
    18.678   259.039     0.150
    20.190   272.578     0.150
    26.837   342.766     0.150
    41.445   467.859     0.150
    65.017   640.320     0.150
    72.702   687.602     0.150
    73.613   694.008     0.150
     0.392     8.477     0.150
     0.392    14.507     0.150
     0.493     9.427     0.150
     0.493    16.127     0.150
     0.736    13.446     0.150
     0.736    23.896     0.150
     0.823    14.146     0.150
     0.823    24.627     0.150
     0.863    15.137     0.150
     0.863    26.757     0.150
     0.837    14.477     0.150
     0.837    26.037     0.150
     0.879    15.017     0.150
     1.023    17.477     0.150
     1.023    30.667     0.150
     1.059    18.087     0.150
     1.059    31.547     0.150
     1.092    18.776     0.150
     1.092    32.467     0.150
     1.143    18.677     0.150
     1.143    33.877     0.150
     1.183    20.077     0.150
     1.183    35.127     0.150
     1.158    18.997     0.150
     1.240    21.146     0.150
     1.247    20.937     0.150
     1.247    36.917     0.150
     1.341    22.127     0.150
     1.341    38.517     0.150
     1.323    21.907     0.150
     1.323    38.097     0.150
     1.415    22.736     0.150
     1.415    38.877     0.150
     1.424    23.017     0.150
     1.425    22.587     0.150
     1.513    24.207     0.150
     1.531    24.437     0.150
     1.531    42.827     0.150
     1.649    25.787     0.150
     1.671    25.137     0.150
     1.671    44.507     0.150
     1.788    28.337     0.150
     1.948    30.247     0.150
     1.953    30.097     0.150
     1.982    31.557     0.150
     2.067    32.627     0.150
     2.138    33.257     0.150
     2.314    35.547     0.150
     2.324    35.627     0.150
     2.324    62.797     0.150
     2.419    36.736     0.150
     2.433    37.257     0.150
     2.503    38.057     0.150
     2.534    39.196     0.150
     2.534    67.657     0.150
     2.535    39.087     0.150
     2.534    38.707     0.150
     2.536    39.177     0.150
     2.536    47.047     0.150
     2.574    39.557     0.150
     2.677    40.937     0.150
     2.763    42.417     0.150
     2.834    43.547     0.150
     2.875    43.377     0.150
     2.875    74.727     0.150
     2.875    43.227     0.150
     2.875    76.097     0.150
     2.919    45.457     0.150
     2.989    46.177     0.150
     3.083    47.257     0.150
     3.193    49.146     0.150
     3.221    49.446     0.150
     3.265    49.627     0.150
     3.446    53.367     0.150
     3.494    53.106     0.150
     3.513    53.090     0.150
     3.607    54.776     0.150
     3.642    55.066     0.150
     3.716    55.127     0.150
     3.716    95.937     0.150
     3.735    56.017     0.150
     3.824    57.106     0.150
     3.824    57.677     0.150
     4.328    62.867     0.150
     4.403    66.667     0.150
     4.837    69.577     0.150
     4.916    72.167     0.150
     4.933    73.854     0.150
     5.085    72.907     0.150
     5.085    72.606     0.150
     5.085   128.967     0.150
     5.148    73.867     0.150
     5.148   130.767     0.150
     5.148    73.767     0.150
     5.251    75.997     0.150
     5.832    83.247     0.150
     6.707    96.927     0.150
    13.864   198.077     0.150
    20.122   271.977     0.150
    20.952   284.026     0.150
    26.829   342.207     0.150
     0.403     8.645     0.150
     0.403    15.004     0.150
     0.518     9.906     0.150
     0.518    16.867     0.150
     0.845    14.484     0.150
     0.845    25.195     0.150
     0.841    14.586     0.150
     0.889    15.574     0.150
     0.889    27.117     0.150
     0.896    15.516     0.150
     1.047    18.055     0.150
     1.047    31.766     0.150
     1.072    18.234     0.150
     1.072    31.867     0.150
     1.114    18.797     0.150
     1.114    33.176     0.150
     1.143    18.707     0.150
     1.160    18.945     0.150
     1.209    20.766     0.150
     1.209    35.348     0.150
     1.265    21.227     0.150
     1.265    36.867     0.150
     1.266    21.477     0.150
     1.266    37.715     0.150
     1.363    22.598     0.150
     1.363    38.977     0.150
     1.425    22.676     0.150
     1.427    22.566     0.150
     1.432    23.234     0.150
     1.432    39.598     0.150
     1.540    24.406     0.150
     1.654    25.875     0.150
     1.654    45.125     0.150
     1.803    28.645     0.150
     1.803    50.605     0.150
     1.954    30.305     0.150
     1.953    30.035     0.150
     1.979    31.375     0.150
     2.058    32.734     0.150
     2.077    32.754     0.150
     2.077    57.457     0.150
     2.152    33.477     0.150
     2.152    58.605     0.150
     2.317    35.625     0.150
     2.426    37.484     0.150
     2.539    38.875     0.150
     2.538    39.457     0.150
     2.539    38.836     0.150
     2.541    39.105     0.150
     2.683    41.746     0.150
     2.698    40.574     0.150
     2.852    44.188     0.150
     2.896    43.727     0.150
     2.896    49.000     0.150
     2.896    75.199     0.150
     2.896    84.176     0.150
     2.924    45.465     0.150
     3.218    49.195     0.150
     3.451    53.367     0.150
     3.502    53.438     0.150
     3.626    54.816     0.150
     3.646    55.297     0.150
     3.830    57.754     0.150
     4.033    61.188     0.150
     4.339    63.406     0.150
     4.850    69.984     0.150
     4.919    73.555     0.150
     5.097    73.227     0.150
     5.160    74.254     0.150
     5.845    83.766     0.150
     6.452    96.055     0.150
    13.866   196.625     0.150
    18.670   258.527     0.150
    26.822   341.949     0.150
     0.456     8.028     0.150
     0.456    14.828     0.150
     0.629    11.528     0.150
     0.629    20.078     0.150
     0.778    13.118     0.150
     0.784    13.479     0.150
     0.784    24.588     0.150
     0.792    24.679     0.150
     0.806    13.668     0.150
     0.882    16.179     0.150
     0.993    17.078     0.150
     0.993    30.248     0.150
     1.045    17.799     0.150
     1.045    31.698     0.150
     1.046    17.698     0.150
     1.046    31.769     0.150
     1.046    17.788     0.150
     1.046    31.108     0.150
     1.046    31.858     0.150
     1.046    17.799     0.150
     1.046    31.679     0.150
     1.047    17.788     0.150
     1.047    31.979     0.150
     1.048    17.799     0.150
     1.048    31.778     0.150
     1.049    17.858     0.150
     1.049    32.059     0.150
     1.050    18.469     0.150
     1.050    31.698     0.150
     1.050    18.038     0.150
     1.050    31.889     0.150
     1.060    17.688     0.150
     1.060    31.679     0.150
     1.148    19.578     0.150
     1.165    36.568     0.150
     1.163    35.078     0.150
     1.165    19.618     0.150
     1.165    33.498     0.150
     1.266    21.448     0.150
     1.266    38.729     0.150
     1.302    22.938     0.150
     1.311    22.259     0.150
     1.311    38.578     0.150
     1.362    24.719     0.150
     1.383    23.998     0.150
     1.441    24.628     0.150
     1.441    43.648     0.150
     1.538    28.238     0.150
     1.501    25.378     0.150
     1.501    44.519     0.150
     1.525    25.969     0.150
     1.525    45.559     0.150
     1.576    26.588     0.150
     1.576    47.418     0.150
     1.726    28.269     0.150
     1.726    48.648     0.150
     1.834    30.769     0.150
     1.834    54.969     0.150
     1.978    32.038     0.150
     2.013    33.019     0.150
     2.013    60.788     0.150
     2.063    34.378     0.150
     2.207    38.538     0.150
     2.287    65.009     0.150
     2.297    36.729     0.150
     2.534    44.328     0.150
     2.557    70.208     0.150
     2.641    44.198     0.150
     2.703    42.488     0.150
     2.791    47.698     0.150
     2.985    90.088     0.150
     3.007    84.918     0.150
     3.007    49.668     0.150
     3.088    48.788     0.150
     3.711    57.618     0.150
     3.711    98.588     0.150
     0.132     3.766     0.150
     0.132     5.936     0.150
     0.152     3.926     0.150
     0.152     6.266     0.150
     0.219     4.865     0.150
     0.219     7.904     0.150
     0.388     7.414     0.150
     0.388    11.834     0.150
     0.400     7.834     0.150
     0.400    13.004     0.150
     0.537     9.805     0.150
     0.537    16.615     0.150
     0.601    10.875     0.150
     0.601    18.664     0.150
     0.687    12.645     0.150
     0.697    12.545     0.150
     0.697    21.314     0.150
     0.750    22.926     0.150
     0.821    14.525     0.150
     0.821    24.455     0.150
     0.846    15.045     0.150
     0.846    25.914     0.150
     0.897    15.645     0.150
     0.897    26.355     0.150
     0.915    15.535     0.150
     0.915    27.045     0.150
     0.924    16.295     0.150
     0.924    27.975     0.150
     0.918    16.074     0.150
     0.973    16.895     0.150
     0.973    29.385     0.150
     0.984    17.275     0.150
     0.999    17.035     0.150
     0.999    29.484     0.150
     1.008    18.494     0.150
     1.068    18.445     0.150
     1.244    21.484     0.150
     1.244    37.266     0.150
     1.256    21.395     0.150
     1.256    37.215     0.150
     1.260    21.205     0.150
     1.260    37.516     0.150
     1.276    22.346     0.150
     1.380    23.615     0.150
     1.444    24.135     0.150
     1.444    43.055     0.150
     1.448    24.676     0.150
     1.479    24.865     0.150
     1.479    43.516     0.150
     1.480    24.945     0.150
     1.480    43.404     0.150
     1.480    25.064     0.150
     1.480    43.664     0.150
     1.480    24.895     0.150
     1.480    43.324     0.150
     1.480    25.176     0.150
     1.480    43.824     0.150
     1.481    44.055     0.150
     1.481    25.004     0.150
     1.481    43.715     0.150
     1.481    24.824     0.150
     1.481    43.635     0.150
     1.482    43.766     0.150
     1.483    25.096     0.150
     1.483    44.074     0.150
     1.484    25.035     0.150
     1.484    43.814     0.150
     1.539    26.016     0.150
     1.539    45.404     0.150
     1.628    27.865     0.150
     1.628    48.074     0.150
     1.643    27.695     0.150
     1.643    48.205     0.150
     1.667    28.125     0.150
     1.667    48.084     0.150
     1.678    27.895     0.150
     1.678    48.785     0.150
     1.679    28.164     0.150
     1.679    48.545     0.150
     1.868    31.516     0.150
     1.946    51.475     0.150
     2.021    33.984     0.150
     2.021    57.975     0.150
     2.036    34.455     0.150
     2.036    58.004     0.150
     2.041    32.324     0.150
     2.045    34.096     0.150
     2.115    35.404     0.150
     2.215    36.475     0.150
     2.270    36.795     0.150
     2.300    37.574     0.150
     2.456    40.484     0.150
     2.587    42.154     0.150
     2.773    44.754     0.150
     2.776    45.135     0.150
     2.876    43.676     0.150
     3.066    61.334     0.150
     3.396    52.775     0.150
     3.448    66.984     0.150
     3.503    63.846     0.150
     6.184    91.254     0.150
     0.126     3.742     0.150
     0.126     6.191     0.150
     0.145     3.871     0.150
     0.145     6.332     0.150
     0.222     7.832     0.150
     0.384     7.371     0.150
     0.384    12.631     0.150
     0.408     7.801     0.150
     0.408    13.121     0.150
     0.540     9.721     0.150
     0.540    16.881     0.150
     0.601    10.822     0.150
     0.601    18.611     0.150
     0.690    12.602     0.150
     0.705    12.432     0.150
     0.705    21.271     0.150
     0.743    14.291     0.150
     0.743    22.781     0.150
     0.829    14.402     0.150
     0.829    24.893     0.150
     0.850    15.211     0.150
     0.850    25.682     0.150
     0.896    15.611     0.150
     0.896    26.393     0.150
     0.911    15.541     0.150
     0.911    26.822     0.150
     0.927    16.252     0.150
     0.927    28.002     0.150
     0.914    15.822     0.150
     0.981    16.852     0.150
     0.981    29.393     0.150
     0.990    17.232     0.150
     0.990    30.121     0.150
     0.999    17.012     0.150
     0.999    29.512     0.150
     1.003    18.562     0.150
     1.071    18.422     0.150
     1.248    21.432     0.150
     1.248    37.422     0.150
     1.256    21.322     0.150
     1.256    36.881     0.150
     1.258    21.111     0.150
     1.258    37.232     0.150
     1.281    22.711     0.150
     1.373    23.051     0.150
     1.380    23.592     0.150
     1.441    24.242     0.150
     1.441    42.092     0.150
     1.478    24.902     0.150
     1.478    43.521     0.150
     1.479    24.912     0.150
     1.479    43.482     0.150
     1.479    24.742     0.150
     1.479    43.162     0.150
     1.478    24.961     0.150
     1.478    43.643     0.150
     1.480    25.041     0.150
     1.480    43.551     0.150
     1.480    25.162     0.150
     1.480    43.502     0.150
     1.480    25.082     0.150
     1.480    43.361     0.150
     1.481    25.102     0.150
     1.481    43.752     0.150
     1.482    25.172     0.150
     1.482    43.631     0.150
     1.483    25.041     0.150
     1.483    43.812     0.150
     1.542    26.211     0.150
     1.542    45.711     0.150
     1.628    27.881     0.150
     1.628    48.102     0.150
     1.641    28.111     0.150
     1.641    48.021     0.150
     1.671    28.262     0.150
     1.684    28.582     0.150
     1.686    28.461     0.150
     1.686    48.711     0.150
     1.774    30.832     0.150
     1.786    30.092     0.150
     1.867    31.451     0.150
     2.027    33.291     0.150
     2.041    33.562     0.150
     2.041    59.492     0.150
     2.042    34.732     0.150
     2.301    38.002     0.150
     2.456    40.092     0.150
     2.759    74.531     0.150
     0.752    14.109     0.150
     0.752    24.078     0.150
     0.867    16.641     0.150
     0.867    28.352     0.150
     0.893    16.047     0.150
     0.893    28.258     0.150
     1.063    18.039     0.150
     1.063    32.055     0.150
     1.237    21.359     0.150
     1.237    37.734     0.150
     1.329    23.047     0.150
     1.329    39.320     0.150
     1.336    23.078     0.150
     1.336    40.148     0.150
     1.259    21.016     0.150
     1.259    35.898     0.150
     1.368    23.227     0.150
     1.355    38.961     0.150
     1.489    24.656     0.150
     1.489    42.680     0.150
     1.531    26.156     0.150
     1.531    44.680     0.150
     1.517    25.078     0.150
     1.517    43.766     0.150
     1.579    26.539     0.150
     1.579    45.188     0.150
     1.605    27.539     0.150
     1.605    46.461     0.150
     1.563    24.711     0.150
     1.563    42.930     0.150
     1.630    26.508     0.150
     1.630    46.672     0.150
     1.726    29.211     0.150
     1.767    28.539     0.150
     1.767    50.055     0.150
     1.768    28.609     0.150
     1.768    49.609     0.150
     1.836    30.375     0.150
     1.836    53.570     0.150
     1.958    32.188     0.150
     2.039    32.641     0.150
     2.271    36.781     0.150
     2.271    62.836     0.150
     2.242    35.711     0.150
     2.331    36.586     0.150
     2.331    64.875     0.150
     2.426    67.141     0.150
     2.498    39.500     0.150
     2.498    70.328     0.150
     2.608    41.547     0.150
     2.608    71.938     0.150
     2.663    41.672     0.150
     2.663    71.945     0.150
     2.694    42.859     0.150
     2.683    41.969     0.150
     2.820    44.547     0.150
     2.812    43.078     0.150
     2.898    44.547     0.150
     2.898    78.711     0.150
     2.898    44.750     0.150
     2.898    78.867     0.150
     2.898    44.188     0.150
     2.900    45.055     0.150
     2.953    46.547     0.150
     3.004    46.695     0.150
     3.032    46.398     0.150
     3.061    48.000     0.150
     3.100    46.977     0.150
     3.100    81.727     0.150
     3.100    46.867     0.150
     3.100    81.570     0.150
     3.125    48.758     0.150
     3.380    51.758     0.150
     3.426    52.930     0.150
     3.472    52.891     0.150
     3.740    57.438     0.150
     3.894    59.922     0.150
     3.988    60.570     0.150
     4.112    62.977     0.150
     4.112    63.648     0.150
     4.183    63.617     0.150
     4.326    66.695     0.150
     4.641    70.148     0.150
     4.654    70.375     0.150
     4.654    70.766     0.150
     5.104    76.727     0.150
     5.104    77.289     0.150
     5.801    86.266     0.150
     5.848    88.117     0.150
     5.914    88.836     0.150
     6.214    93.805     0.150
     6.461    94.641     0.150
     6.739    99.758     0.150
     7.112   104.352     0.150
     7.312   109.789     0.150
     8.328   122.359     0.150
     8.905   132.898     0.150
     9.085   131.070     0.150
     9.989   143.227     0.150
    10.638   157.391     0.150
    11.138   163.609     0.150
    11.262   164.789     0.150
    11.398   168.328     0.150
    11.598   170.531     0.150
    11.822   173.156     0.150
    12.108   175.867     0.150
    12.186   176.102     0.150
    12.186   176.938     0.150
    12.210   178.297     0.150
    12.405   179.484     0.150
    12.508   177.609     0.150
    12.719   184.969     0.150
    13.310   192.117     0.150
    14.162   203.977     0.150
    14.162   203.523     0.150
    15.289   213.602     0.150
    15.981   228.219     0.150
    16.054   229.617     0.150
    16.124   225.555     0.150
    16.211   230.297     0.150
    16.170   229.586     0.150
    16.979   241.688     0.150
    17.447   245.781     0.150
    17.518   246.617     0.150
    18.720   260.008     0.150
    20.608   280.703     0.150
    21.849   293.219     0.150
    24.209   318.250     0.150
    45.695   501.750     0.150
    76.301   709.625     0.150
    78.027   718.789     0.150
    78.133   718.789     0.150
    80.982   735.484     0.150
    82.388   744.430     0.150
     0.471     9.055     0.150
     0.471    15.146     0.150
     0.656    11.896     0.150
     0.637    11.615     0.150
     0.637    19.955     0.150
     0.698    12.955     0.150
     0.925    27.025     0.150
     0.930    16.155     0.150
     0.930    28.375     0.150
     1.046    17.675     0.150
     1.182    19.355     0.150
     1.182    33.065     0.150
     1.143    19.405     0.150
     1.156    19.225     0.150
     1.156    32.845     0.150
     1.199    19.845     0.150
     1.312    22.035     0.150
     1.348    21.535     0.150
     1.348    39.225     0.150
     1.465    23.345     0.150
     1.465    40.545     0.150
     1.480    23.715     0.150
     1.480    41.085     0.150
     1.532    24.405     0.150
     1.532    43.765     0.150
     1.746    27.625     0.150
     1.747    27.245     0.150
     1.838    28.885     0.150
     1.838    50.725     0.150
     1.965    30.965     0.150
     2.198    34.015     0.150
     2.265    34.325     0.150
     2.275    35.285     0.150
     2.275    60.635     0.150
     2.372    36.295     0.150
     2.370    36.195     0.150
     2.419    37.035     0.150
     2.419    66.375     0.150
     2.613    40.165     0.150
     2.696    40.990     0.150
     2.696    70.540     0.150
     2.696    40.845     0.150
     2.731    42.565     0.150
     2.752    41.985     0.150
     2.795    42.335     0.150
     2.812    42.425     0.150
     2.853    43.085     0.150
     2.853    42.646     0.150
     2.853    75.905     0.150
     2.853    42.635     0.150
     2.853    76.045     0.150
     2.854    44.005     0.150
     2.855    44.365     0.150
     2.852    43.985     0.150
     2.911    44.635     0.150
     2.992    46.405     0.150
     3.017    80.025     0.150
     3.082    47.315     0.150
     3.083    47.045     0.150
     3.234    49.785     0.150
     3.283    49.405     0.150
     3.541    53.955     0.150
     3.579    54.275     0.150
     3.624    55.205     0.150
     3.804    57.285     0.150
     3.915    56.975     0.150
     3.915    99.025     0.150
     3.836    57.355     0.150
     3.836    57.505     0.150
     4.038    59.055     0.150
     4.038   102.725     0.150
     3.962    59.205     0.150
     4.013    59.515     0.150
     4.037    60.855     0.150
     4.025    60.975     0.150
     4.138    61.965     0.150
     4.417    64.295     0.150
     4.417   112.075     0.150
     4.459    64.235     0.150
     4.459   113.025     0.150
     4.498    66.375     0.150
     4.557    65.745     0.150
     4.557   115.305     0.150
     4.557    64.985     0.150
     4.484    66.525     0.150
     4.722    69.835     0.150
     4.799    69.025     0.150
     4.799   120.985     0.150
     4.799    68.792     0.150
     4.799   120.416     0.150
     4.754    70.815     0.150
     4.862    69.992     0.150
     4.862   123.100     0.150
     4.862    69.975     0.150
     4.862   122.555     0.150
     4.999    73.835     0.150
     5.094    74.455     0.150
     5.094   129.655     0.150
     5.131    76.915     0.150
     5.131    77.315     0.150
     5.207    77.165     0.150
     5.554    80.225     0.150
     5.561    79.885     0.150
     5.832    84.065     0.150
     5.868    86.195     0.150
     6.076    88.146     0.150
     6.246    90.475     0.150
     6.284    89.295     0.150
     6.404    91.955     0.150
     6.418    93.785     0.150
     7.013   102.167     0.150
     7.218   102.565     0.150
     9.056   131.962     0.150
     9.056   131.815     0.150
     9.056   129.875     0.150
     9.647   137.295     0.150
    14.186   202.501     0.150
    14.853   207.265     0.150
    15.911   221.646     0.150
    16.381   227.495     0.150
    17.348   239.995     0.150
    17.529   240.725     0.150
    18.609   252.135     0.150
    20.374   273.995     0.150
    20.374   271.745     0.150
    27.140   344.197     0.150
    39.952   450.005     0.150
    40.253   452.945     0.150
     0.122     6.355     0.150
     0.122    10.916     0.150
     0.271     7.666     0.150
     0.271    13.156     0.150
     0.286     7.696     0.150
     0.286    13.136     0.150
     0.316     8.226     0.150
     0.316    14.496     0.150
     0.523    10.616     0.150
     0.523    18.076     0.150
     0.565    11.206     0.150
     0.602    11.605     0.150
     0.602    19.916     0.150
     0.631    12.266     0.150
     0.704    13.046     0.150
     0.812    14.516     0.150
     0.812    25.226     0.150
     0.883    15.966     0.150
     0.883    28.036     0.150
     0.984    17.386     0.150
     0.984    29.986     0.150
     0.987    17.446     0.150
     1.047    17.596     0.150
     1.047    30.866     0.150
     1.112    18.546     0.150
     1.112    32.766     0.150
     1.147    19.346     0.150
     1.122    19.336     0.150
     1.141    19.446     0.150
     1.141    18.596     0.150
     1.141    33.726     0.150
     1.240    21.306     0.150
     1.257    20.756     0.150
     1.279    21.566     0.150
     1.279    37.666     0.150
     1.279    21.146     0.150
     1.433    23.686     0.150
     1.457    24.105     0.150
     1.476    24.386     0.150
     1.539    25.166     0.150
     1.542    25.116     0.150
     1.542    43.086     0.150
     1.571    24.486     0.150
     1.571    42.796     0.150
     1.586    25.506     0.150
     1.594    25.236     0.150
     1.593    25.176     0.150
     1.593    44.256     0.150
     1.593    44.276     0.150
     1.593    25.486     0.150
     1.595    25.166     0.150
     1.595    44.256     0.150
     1.595    25.146     0.150
     1.595    44.546     0.150
     1.595    25.216     0.150
     1.595    44.436     0.150
     1.600    25.766     0.150
     1.711    26.855     0.150
     1.711    27.496     0.150
     1.765    27.206     0.150
     1.765    47.976     0.150
     1.881    29.866     0.150
     1.881    51.536     0.150
     1.881    30.076     0.150
     1.916    30.256     0.150
     1.961    28.176     0.150
     1.974    30.966     0.150
     2.044    32.193     0.150
     2.044    57.190     0.150
     2.053    32.696     0.150
     2.053    57.756     0.150
     2.053    32.826     0.150
     2.132    33.086     0.150
     2.132    57.236     0.150
     2.180    33.866     0.150
     2.174    33.546     0.150
     2.351    36.466     0.150
     2.386    36.776     0.150
     2.411    36.815     0.150
     2.411    66.631     0.150
     2.401    36.956     0.150
     2.448    37.736     0.150
     2.448    64.786     0.150
     2.503    39.066     0.150
     2.523    38.536     0.150
     2.558    65.616     0.150
     2.552    39.526     0.150
     2.574    39.433     0.150
     2.574    69.345     0.150
     2.704    41.456     0.150
     2.811    42.396     0.150
     2.817    42.948     0.150
     2.827    43.266     0.150
     2.880    44.026     0.150
     2.880    43.816     0.150
     2.880    43.976     0.150
     2.867    44.116     0.150
     3.014    45.036     0.150
     3.014    77.426     0.150
     3.014    45.226     0.150
     3.073    46.756     0.150
     3.200    48.605     0.150
     3.200    48.266     0.150
     3.224    49.186     0.150
     3.381    50.863     0.150
     3.381    87.636     0.150
     3.367    49.996     0.150
     3.367    86.071     0.150
     3.367   100.796     0.150
     3.449    51.699     0.150
     3.531    52.956     0.150
     3.585    53.716     0.150
     3.585    92.846     0.150
     3.585    53.926     0.150
     3.585    93.296     0.150
     3.605    53.535     0.150
     3.605    94.061     0.150
     3.856    57.546     0.150
     3.891    58.156     0.150
     3.891   102.086     0.150
     3.891    58.396     0.150
     4.005    59.146     0.150
     4.313    63.957     0.150
     4.313   110.403     0.150
     4.308    63.316     0.150
     4.308    63.625     0.150
     4.386    65.401     0.150
     4.386   114.534     0.150
     4.665    67.516     0.150
     4.665   117.796     0.150
     4.744    69.666     0.150
     4.890    72.536     0.150
     4.914    71.176     0.150
     4.956    73.601     0.150
     5.022    72.966     0.150
     5.030    73.086     0.150
     5.025    73.986     0.150
     5.092    74.859     0.150
     5.112    74.546     0.150
     5.122    74.826     0.150
     5.241    76.625     0.150
     5.235    75.796     0.150
     5.268    77.056     0.150
     5.300   133.796     0.150
     5.365    77.756     0.150
     5.372    78.736     0.150
     5.558    81.686     0.150
     5.581    80.056     0.150
     5.581   139.416     0.150
     5.706    83.526     0.150
     5.728    83.421     0.150
     5.759    82.806     0.150
     5.768    83.308     0.150
     5.768   177.707     0.150
     5.768    83.417     0.150
     5.768    83.076     0.150
     5.856    85.067     0.150
     5.856   148.681     0.150
     5.847    83.546     0.150
     5.847   145.236     0.150
     5.866    85.086     0.150
     6.032    86.875     0.150
     6.150    89.277     0.150
     6.150   156.146     0.150
     6.323    91.056     0.150
     6.451    94.192     0.150
     6.560    93.566     0.150
     6.584    94.326     0.150
     6.646    96.517     0.150
     6.646   169.042     0.150
     6.661    95.686     0.150
     6.670    98.218     0.150
     6.855    98.546     0.150
     6.820    97.316     0.150
     7.120   105.333     0.150
     7.181   104.255     0.150
     7.202   102.605     0.150
     7.211   104.316     0.150
     7.213   104.576     0.150
     7.365   106.421     0.150
     7.557   109.476     0.150
     7.747   114.934     0.150
     7.744   110.176     0.150
     7.755   110.816     0.150
     7.888   114.858     0.150
     8.049   118.601     0.150
     8.248   116.857     0.150
     8.482   124.039     0.150
     8.551   122.736     0.150
     8.758   124.676     0.150
     8.953   127.186     0.150
     9.244   134.688     0.150
     9.314   132.602     0.150
     9.626   136.536     0.150
     9.612   138.646     0.150
     9.612   296.896     0.150
     9.612   136.846     0.150
     9.856   139.726     0.150
    10.210   144.688     0.150
    10.877   154.936     0.150
    11.232   163.133     0.150
    11.433   161.796     0.150
    12.005   173.921     0.150
    12.631   181.256     0.150
    12.836   180.954     0.150
    12.836   180.056     0.150
    12.936   184.233     0.150
    12.936   184.446     0.150
    13.026   182.636     0.150
    13.062   186.001     0.150
    13.251   185.706     0.150
    13.312   187.003     0.150
    13.312   186.276     0.150
    13.452   192.336     0.150
    13.576   190.156     0.150
    13.906   198.472     0.150
    14.032   196.756     0.150
    14.088   197.186     0.150
    14.196   199.284     0.150
    14.199   198.178     0.150
    14.261   202.972     0.150
    14.437   205.283     0.150
    14.487   206.328     0.150
    14.523   203.656     0.150
    14.696   453.307     0.150
    14.832   206.866     0.150
    14.857   207.383     0.150
    14.917   212.340     0.150
    14.936   209.312     0.150
    14.938   212.447     0.150
    14.974   212.649     0.150
    15.176   212.176     0.150
    15.236   212.826     0.150
    15.347   214.622     0.150
    15.347   214.125     0.150
    15.357   214.366     0.150
    15.353   214.553     0.150
    15.353   213.826     0.150
    15.389   215.402     0.150
    15.931   223.057     0.150
    15.947   222.686     0.150
    15.992   222.676     0.150
    16.086   225.312     0.150
    16.082   223.576     0.150
    16.106   224.046     0.150
    16.157   224.716     0.150
    16.165   224.526     0.150
    16.195   228.079     0.150
    16.205   225.096     0.150
    16.210   225.256     0.150
    16.220   225.135     0.150
    16.311   225.875     0.150
    16.754   232.826     0.150
    16.801   233.697     0.150
    16.815   234.834     0.150
    16.940   236.365     0.150
    16.908   237.517     0.150
    17.018   239.116     0.150
    17.018   237.539     0.150
    17.025   237.609     0.150
    17.100   236.536     0.150
    17.166   239.724     0.150
    17.251   240.530     0.150
    17.295   239.478     0.150
    17.300   240.108     0.150
    17.300   241.849     0.150
    17.335   237.888     0.150
    17.585   243.625     0.150
    17.585   520.656     0.150
    17.700   245.466     0.150
    17.740   247.115     0.150
    17.801   245.353     0.150
    17.805   247.971     0.150
    17.917   246.467     0.150
    18.019   247.781     0.150
    18.056   251.115     0.150
    18.543   254.144     0.150
    18.597   254.520     0.150
    18.597   253.875     0.150
    18.880   256.510     0.150
    19.023   261.449     0.150
    19.023   259.796     0.150
    19.255   262.286     0.150
    19.255   263.896     0.150
    19.255   602.496     0.150
    19.277   258.996     0.150
    19.277   593.021     0.150
    19.277   258.416     0.150
    19.386   263.482     0.150
    19.446   263.216     0.150
    19.457   264.496     0.150
    19.587   266.383     0.150
    19.571   266.471     0.150
    19.571   613.121     0.150
    19.571   265.906     0.150
    19.664   268.403     0.150
    19.759   269.195     0.150
    19.971   270.716     0.150
    20.094   272.766     0.150
    20.094   271.116     0.150
    20.114   272.125     0.150
    20.187   272.406     0.150
    20.241   272.552     0.150
    20.244   271.996     0.150
    20.244   272.576     0.150
    20.288   275.712     0.150
    20.443   274.836     0.150
    20.630   276.046     0.150
    20.709   274.920     0.150
    20.709   274.706     0.150
    20.742   274.276     0.150
    20.744   274.716     0.150
    20.744   275.196     0.150
    20.878   278.866     0.150
    21.277   283.550     0.150
    21.277   283.736     0.150
    21.378   287.953     0.150
    21.528   287.416     0.150
    21.618   287.226     0.150
    21.680   287.576     0.150
    21.722   284.676     0.150
    21.940   293.221     0.150
    21.974   289.966     0.150
    22.152   292.846     0.150
    22.286   290.446     0.150
    22.580   294.201     0.150
    22.611   295.012     0.150
    22.716   298.216     0.150
    22.743   299.912     0.150
    22.743   299.516     0.150
    22.777   302.354     0.150
    22.777   300.146     0.150
    22.805   300.498     0.150
    22.805   299.816     0.150
    23.068   302.858     0.150
    23.219   304.086     0.150
    23.735   306.736     0.150
    24.527   317.019     0.150
    25.017   319.386     0.150
    25.242   322.478     0.150
    25.242   321.406     0.150
    25.383   323.516     0.150
    25.544   325.951     0.150
    25.544   325.426     0.150
    25.550   326.326     0.150
    25.550   326.096     0.150
    25.693   326.806     0.150
    25.753   327.776     0.150
    25.907   329.016     0.150
    25.984   329.966     0.150
    25.998   329.616     0.150
    25.999   331.534     0.150
    26.044   329.956     0.150
    26.079   330.916     0.150
    26.307   332.326     0.150
    26.389   335.045     0.150
    26.458   334.206     0.150
    26.977   338.326     0.150
    27.051   338.786     0.150
    27.087   340.170     0.150
    27.087   340.046     0.150
    27.095   339.861     0.150
    27.095   339.156     0.150
    27.101   340.330     0.150
    27.101   339.166     0.150
    27.250   341.718     0.150
    27.250   341.166     0.150
    27.336   342.206     0.150
    27.406   341.766     0.150
    27.670   344.366     0.150
    27.753   344.826     0.150
    27.806   346.559     0.150
    27.806   346.326     0.150
    27.803   345.406     0.150
    27.847   345.666     0.150
    28.065   348.726     0.150
    28.223   350.238     0.150
    28.304   350.100     0.150
    28.349   350.666     0.150
    28.378   350.886     0.150
    28.533   351.512     0.150
    28.594   352.416     0.150
    28.606   352.605     0.150
    28.665   354.156     0.150
    28.691   354.471     0.150
    28.691   354.176     0.150
    28.756   354.036     0.150
    29.382   359.426     0.150
    29.546   360.586     0.150
    30.108   365.886     0.150
    30.170   367.416     0.150
    30.213   366.819     0.150
    30.213   367.716     0.150
    30.437   369.404     0.150
    30.437   369.816     0.150
    30.439   369.674     0.150
    30.439   369.366     0.150
    30.442   369.336     0.150
    30.534   369.758     0.150
    30.534   370.006     0.150
    30.988   374.326     0.150
    31.307   377.010     0.150
    31.307   377.375     0.150
    31.357   377.146     0.150
    31.469   377.836     0.150
    31.648   379.916     0.150
    31.704   380.686     0.150
    31.911   381.976     0.150
    31.966   383.355     0.150
    31.981   382.746     0.150
    32.176   384.708     0.150
    32.214   385.020     0.150
    32.309   385.216     0.150
    32.459   386.836     0.150
    32.459   387.316     0.150
    32.630   387.806     0.150
    32.921   391.042     0.150
    32.969   390.464     0.150
    32.969   391.446     0.150
    33.315   395.056     0.150
    33.354   394.586     0.150
    33.375   395.686     0.150
    33.575   396.147     0.150
    33.657   396.566     0.150
    33.664   397.188     0.150
    33.711   397.500     0.150
    33.713   398.113     0.150
    33.797   398.320     0.150
    33.967   399.646     0.150
    34.081   400.996     0.150
    34.111   402.062     0.150
    34.226   402.071     0.150
    34.226   402.996     0.150
    34.327   402.633     0.150
    34.406   403.741     0.150
    34.424   403.977     0.150
    34.424   403.796     0.150
    34.600   404.864     0.150
    34.612   406.416     0.150
    34.627   405.736     0.150
    34.629   405.978     0.150
    34.735   406.035     0.150
    34.779   406.608     0.150
    34.801   406.990     0.150
    34.824   407.073     0.150
    34.926   408.319     0.150
    34.938   408.406     0.150
    34.937   406.699     0.150
    34.958   408.571     0.150
    34.958   408.086     0.150
    34.989   409.076     0.150
    35.248   411.556     0.150
    35.265   411.292     0.150
    35.281   411.233     0.150
    35.281   411.446     0.150
    35.395   413.134     0.150
    35.422   412.147     0.150
    35.465   413.136     0.150
    35.589   413.893     0.150
    35.605   414.410     0.150
    35.742   414.771     0.150
    35.788   415.610     0.150
    35.820   415.757     0.150
    35.840   415.834     0.150
    35.873   416.395     0.150
    35.873   415.586     0.150
    35.933   416.644     0.150
    36.308   420.735     0.150
    36.326   420.742     0.150
    36.350   420.527     0.150
    36.617   420.806     0.150
    36.564   422.146     0.150
    36.581   422.866     0.150
    36.646   423.584     0.150
    36.646   422.956     0.150
    36.692   424.230     0.150
    36.903   425.746     0.150
    37.092   427.990     0.150
    37.109   428.186     0.150
    37.193   428.303     0.150
    37.538   431.515     0.150
    37.742   431.375     0.150
    37.783   433.133     0.150
    37.936   434.855     0.150
    38.208   437.266     0.150
    38.683   440.526     0.150
    40.307   452.936     0.150
    42.675   472.266     0.150
    43.201   478.066     0.150
    43.201   478.346     0.150
    44.476   488.846     0.150
    44.491   489.196     0.150
    46.060   501.391     0.150
    46.360   502.476     0.150
    46.390   503.736     0.150
    46.580   504.971     0.150
    46.580   504.676     0.150
    52.765   551.546     0.150
    59.283   600.996     0.150
    59.283   598.276     0.150
    59.728   603.289     0.150
    59.729   601.646     0.150
    64.795   636.371     0.150
    64.922   636.446     0.150
    67.424   652.183     0.150
    69.673   662.846     0.150
    73.370   689.686     0.150
    74.060   695.950     0.150
    75.644    10.200     0.150
    75.983   705.346     0.150
    75.983    16.000     0.150
    76.017    10.100     0.150
    76.276   703.896     0.150
    76.276   707.339     0.150
    77.133   712.846     0.150
    77.235   710.976     0.150
    78.208   715.621     0.150
    78.320   717.146     0.150
    81.356   733.628     0.150
    81.822   735.706     0.150
    82.867   744.346     0.150
    83.962   747.546     0.150
    83.962   753.446     0.150
    84.386   752.246     0.150
    86.937   762.821     0.150
    89.620   777.746     0.150
    89.620  1427.146     0.150
   144.593  1170.403     0.150
   145.953  1174.537     0.150
     0.194     4.109     0.150
     0.194     8.656     0.150
     0.387     7.789     0.150
     0.467     8.656     0.150
     0.467    16.430     0.150
     0.485     9.047     0.150
     0.530    11.148     0.150
     0.641    12.328     0.150
     0.641    21.496     0.150
     0.666    23.180     0.150
     0.779    14.379     0.150
     0.779    14.219     0.150
     0.779    26.398     0.150
     0.842    15.227     0.150
     0.842    27.898     0.150
     0.898    16.508     0.150
     0.921    15.797     0.150
     0.921    28.656     0.150
     1.086    19.199     0.150
     1.101    19.129     0.150
     1.105    19.188     0.150
     1.105    19.367     0.150
     1.115    18.707     0.150
     1.115    34.039     0.150
     1.115    34.168     0.150
     1.114    18.930     0.150
     1.114    34.117     0.150
     1.114    34.219     0.150
     1.108    19.086     0.150
     1.140    20.137     0.150
     1.154    20.797     0.150
     1.174    20.520     0.150
     1.194    20.668     0.150
     1.204    20.066     0.150
     1.204    36.496     0.150
     1.205    20.137     0.150
     1.205    36.387     0.150
     1.205    20.117     0.150
     1.205    36.547     0.150
     1.205    20.180     0.150
     1.205    36.449     0.150
     1.206    20.137     0.150
     1.206    36.617     0.150
     1.209    20.289     0.150
     1.209    36.816     0.150
     1.232    20.848     0.150
     1.232    37.020     0.150
     1.270    21.449     0.150
     1.270    21.578     0.150
     1.299    21.988     0.150
     1.291    21.469     0.150
     1.291    38.020     0.150
     1.317    22.098     0.150
     1.317    38.246     0.150
     1.319    22.496     0.150
     1.310    21.879     0.150
     1.310    38.367     0.150
     1.310    38.477     0.150
     1.415    23.699     0.150
     1.415    41.430     0.150
     1.425    23.777     0.150
     1.442    23.859     0.150
     1.442    23.609     0.150
     1.454    24.168     0.150
     1.454    43.336     0.150
     1.454    24.059     0.150
     1.535    25.336     0.150
     1.530    25.258     0.150
     1.530    44.848     0.150
     1.567    25.848     0.150
     1.567    45.996     0.150
     1.627    27.906     0.150
     1.609    26.047     0.150
     1.804    29.406     0.150
     1.790    28.816     0.150
     1.837    30.547     0.150
     1.875    30.109     0.150
     1.875    53.219     0.150
     1.896    30.836     0.150
     1.916    31.996     0.150
     1.906    30.867     0.150
     1.906    54.457     0.150
     1.936    31.227     0.150
     1.936    55.246     0.150
     2.020    33.488     0.150
     2.066    32.996     0.150
     2.117    34.348     0.150
     2.117    34.648     0.150
     2.122    34.039     0.150
     2.126    33.836     0.150
     2.126    59.816     0.150
     2.205    35.078     0.150
     2.205    60.547     0.150
     2.210    35.438     0.150
     2.213    35.297     0.150
     2.203    35.309     0.150
     2.228    35.457     0.150
     2.228    35.688     0.150
     2.258    34.938     0.150
     2.268    35.938     0.150
     2.307    37.336     0.150
     2.310    37.059     0.150
     2.407    38.547     0.150
     2.407    38.770     0.150
     2.562    40.719     0.150
     2.629    41.488     0.150
     2.629    41.789     0.150
     2.703    41.789     0.150
     2.698    42.336     0.150
     2.766    43.719     0.150
     2.766    43.406     0.150
     2.787    44.156     0.150
     2.796    43.688     0.150
     2.936    47.039     0.150
     2.943    46.277     0.150
     3.128    48.168     0.150
     3.383    51.809     0.150
     3.538    54.098     0.150
     3.604    60.348     0.150
     3.634    55.348     0.150
     3.634    53.938     0.150
     3.703    56.039     0.150
     4.319    63.617     0.150
     4.319    63.496     0.150
     5.096    74.578     0.150
     0.218     6.775     0.150
     0.218    11.666     0.150
     0.337     7.977     0.150
     0.337    14.076     0.150
     0.345     8.307     0.150
     0.345    14.086     0.150
     0.420     8.996     0.150
     0.420    15.596     0.150
     0.526    10.336     0.150
     0.526    18.205     0.150
     0.535    10.406     0.150
     0.535    17.766     0.150
     0.781    23.775     0.150
     0.782    13.596     0.150
     0.782    23.396     0.150
     0.798    14.016     0.150
     0.798    24.436     0.150
     0.792    14.146     0.150
     0.792    24.896     0.150
     0.885    15.215     0.150
     0.878    15.695     0.150
     0.878    27.375     0.150
     0.885    15.025     0.150
     0.885    26.477     0.150
     0.938    15.846     0.150
     0.938    27.557     0.150
     0.998    17.045     0.150
     1.043    18.205     0.150
     1.043    31.605     0.150
     1.079    18.227     0.150
     1.079    31.816     0.150
     1.162    19.605     0.150
     1.162    34.396     0.150
     1.303    20.826     0.150
     1.303    36.965     0.150
     1.284    21.535     0.150
     1.331    21.945     0.150
     1.331    38.396     0.150
     1.349    21.506     0.150
     1.349    39.316     0.150
     1.404    22.705     0.150
     1.413    22.756     0.150
     1.413    40.506     0.150
     1.629    26.285     0.150
     1.629    44.945     0.150
     1.693    27.646     0.150
     1.693    46.855     0.150
     1.768    27.426     0.150
     1.830    28.855     0.150
     1.830    49.436     0.150
     1.830    29.195     0.150
     1.830    49.445     0.150
     1.830    49.477     0.150
     1.830    28.816     0.150
     1.830    49.455     0.150
     1.831    49.775     0.150
     1.831    49.615     0.150
     1.832    29.406     0.150
     1.832    49.486     0.150
     1.849    29.186     0.150
     1.874    29.516     0.150
     1.874    50.795     0.150
     1.958    53.426     0.150
     2.011    31.086     0.150
     2.011    54.125     0.150
     2.145    34.086     0.150
     2.174    34.215     0.150
     2.250    35.406     0.150
     2.943    44.775     0.150
     3.000    79.266     0.150
     3.126    46.576     0.150
     3.126    81.576     0.150
     3.263    48.227     0.150
     3.737    97.057     0.150
     3.788    56.727     0.150
     3.843    98.535     0.150
     0.204     6.867     0.150
     0.204    11.945     0.150
     0.252     7.258     0.150
     0.252    12.461     0.150
     0.281     7.375     0.150
     0.281    12.891     0.150
     0.281     7.414     0.150
     0.281    13.000     0.150
     0.322     7.625     0.150
     0.322    13.461     0.150
     0.392     8.602     0.150
     0.392    15.039     0.150
     0.404     9.125     0.150
     0.404    15.984     0.150
     0.424     9.102     0.150
     0.424    15.875     0.150
     0.642    12.266     0.150
     0.642    21.406     0.150
     0.707    13.031     0.150
     0.707    22.336     0.150
     0.761    13.508     0.150
     0.761    23.648     0.150
     0.800    13.984     0.150
     0.800    24.961     0.150
     0.800    13.914     0.150
     0.800    25.148     0.150
     0.807    14.641     0.150
     0.807    25.711     0.150
     0.831    14.984     0.150
     0.831    25.984     0.150
     0.850    15.078     0.150
     0.850    26.648     0.150
     0.844    15.141     0.150
     0.844    26.352     0.150
     0.877    15.289     0.150
     0.909    15.891     0.150
     0.902    15.531     0.150
     0.935    16.609     0.150
     0.935    29.070     0.150
     1.038    17.984     0.150
     1.038    31.297     0.150
     1.129    18.219     0.150
     1.129    33.375     0.150
     1.167    19.781     0.150
     1.281    21.188     0.150
     1.282    20.906     0.150
     1.282    21.188     0.150
     1.282    38.102     0.150
     1.284    21.227     0.150
     1.321    21.797     0.150
     1.321    38.680     0.150
     1.327    21.656     0.150
     1.358    22.578     0.150
     1.401    23.461     0.150
     1.421    23.219     0.150
     1.434    22.805     0.150
     1.434    39.602     0.150
     1.456    23.477     0.150
     1.459    23.227     0.150
     1.459    40.516     0.150
     1.651    26.156     0.150
     1.662    26.141     0.150
     1.778    28.359     0.150
     1.778    50.000     0.150
     1.795    28.656     0.150
     1.941    29.609     0.150
     2.083    32.641     0.150
     2.131    30.320     0.150
     2.131    33.289     0.150
     2.243    35.469     0.150
     2.410    36.875     0.150
     2.538    68.938     0.150
     2.564    38.961     0.150
     2.568    39.828     0.150
     2.661    41.359     0.150
     2.774    39.297     0.150
     2.803    41.836     0.150
     2.795    39.609     0.150
     3.246    49.047     0.150
     3.869    57.719     0.150
     0.286     6.484     0.150
     0.286    12.180     0.150
     0.488     9.719     0.150
     0.488    16.141     0.150
     0.488    16.758     0.150
     0.520    10.266     0.150
     0.520    17.102     0.150
     0.520    10.477     0.150
     0.650    11.945     0.150
     0.650    20.461     0.150
     0.687    12.539     0.150
     0.687    21.359     0.150
     0.687    21.516     0.150
     0.916    27.328     0.150
     0.917    27.461     0.150
     0.917    27.328     0.150
     0.979    16.836     0.150
     1.090    17.867     0.150
     1.090    30.469     0.150
     1.371    19.609     0.150
     1.183    33.906     0.150
     1.183    33.734     0.150
     1.182    20.219     0.150
     1.182    34.945     0.150
     1.182    35.109     0.150
     1.305    21.781     0.150
     1.305    37.625     0.150
     1.379    22.516     0.150
     1.408    22.727     0.150
     1.408    39.117     0.150
     1.535    42.180     0.150
     1.580    25.156     0.150
     1.580    43.969     0.150
     1.580    25.039     0.150
     1.580    44.047     0.150
     1.604    26.148     0.150
     1.604    44.984     0.150
     1.569    26.000     0.150
     1.569    44.148     0.150
     1.577    26.211     0.150
     1.604    26.219     0.150
     1.604    45.641     0.150
     1.701    27.336     0.150
     1.701    46.305     0.150
     1.708    27.805     0.150
     1.708    48.625     0.150
     1.921    27.367     0.150
     1.943    27.641     0.150
     1.823    28.766     0.150
     1.828    28.477     0.150
     1.828    49.891     0.150
     1.887    30.234     0.150
     1.887    52.359     0.150
     1.989    31.891     0.150
     2.024    31.156     0.150
     2.068    31.555     0.150
     2.068    54.828     0.150
     2.043    31.680     0.150
     2.043    55.617     0.150
     2.043    31.891     0.150
     2.043    55.781     0.150
     2.043    31.688     0.150
     2.043    55.938     0.150
     2.045    31.805     0.150
     2.045    55.836     0.150
     2.045    31.914     0.150
     2.167    33.156     0.150
     2.167    57.805     0.150
     2.183    34.695     0.150
     2.183    59.648     0.150
     2.216    34.469     0.150
     2.313    35.617     0.150
     2.614    40.898     0.150
     2.632    40.539     0.150
     2.632    71.289     0.150
     2.670    73.047     0.150
     2.918    44.250     0.150
     2.918    77.969     0.150
     2.929    44.766     0.150
     2.929    79.531     0.150
     2.929    78.750     0.150
     2.952    45.961     0.150
     3.056    46.328     0.150
     3.055    47.141     0.150
     3.124    47.828     0.150
     3.346    50.852     0.150
     3.471    51.852     0.150
     3.483    52.000     0.150
     3.483    90.281     0.150
     3.484    53.008     0.150
     3.484    92.820     0.150
     3.789    57.328     0.150
     3.812    57.320     0.150
     4.238    63.461     0.150
     4.238   111.008     0.150
     4.325    64.648     0.150
     4.550    66.414     0.150
     4.550   115.430     0.150
     4.796    70.555     0.150
     4.961   126.125     0.150
     5.440   138.289     0.150
     5.639    83.469     0.150
     5.779    85.352     0.150
     5.791    85.328     0.150
     0.035     5.406     0.150
     0.035     9.316     0.150
     0.035     9.477     0.150
     0.066     5.367     0.150
     0.066     9.215     0.150
     0.302     7.445     0.150
     0.302    12.895     0.150
     0.299     7.207     0.150
     0.299    12.547     0.150
     0.300     7.156     0.150
     0.300    12.477     0.150
     0.521     9.805     0.150
     0.521    17.137     0.150
     0.710    12.527     0.150
     0.710    23.258     0.150
     0.771    13.984     0.150
     0.829    14.277     0.150
     0.829    25.195     0.150
     0.859    15.195     0.150
     0.859    25.895     0.150
     0.859    14.547     0.150
     0.859    25.555     0.150
     0.913    15.867     0.150
     0.934    15.695     0.150
     0.934    27.945     0.150
     0.934    15.676     0.150
     0.934    15.785     0.150
     0.934    27.828     0.150
     1.003    17.266     0.150
     1.003    17.375     0.150
     1.003    29.266     0.150
     1.036    17.547     0.150
     1.036    31.047     0.150
     1.036    30.828     0.150
     1.049    18.047     0.150
     1.049    18.156     0.150
     1.049    30.887     0.150
     1.198    20.117     0.150
     1.222    20.297     0.150
     1.219    20.027     0.150
     1.219    34.375     0.150
     1.238    20.887     0.150
     1.238    36.156     0.150
     1.326    21.797     0.150
     1.326    37.328     0.150
     1.356    22.625     0.150
     1.368    21.984     0.150
     1.355    21.848     0.150
     1.411    22.445     0.150
     1.411    39.605     0.150
     1.410    22.445     0.150
     1.410    39.695     0.150
     1.411    22.215     0.150
     1.411    22.395     0.150
     1.411    39.598     0.150
     1.413    22.445     0.150
     1.413    39.668     0.150
     1.413    22.277     0.150
     1.413    39.887     0.150
     1.457    24.297     0.150
     1.490    23.316     0.150
     1.512    24.406     0.150
     1.566    24.527     0.150
     1.566    42.527     0.150
     1.567    25.195     0.150
     1.634    26.117     0.150
     1.804    28.578     0.150
     1.931    48.258     0.150
     1.931    30.816     0.150
     1.944    29.906     0.150
     2.117    33.328     0.150
     2.125    33.035     0.150
     2.212    33.848     0.150
     2.212    34.008     0.150
     2.298    36.316     0.150
     2.324    36.996     0.150
     2.364    36.406     0.150
     2.400    37.406     0.150
     2.514    38.734     0.150
     2.598    36.535     0.150
     2.713    41.457     0.150
     2.821    42.387     0.150
     2.862    43.656     0.150
     2.862    43.945     0.150
     2.977    46.984     0.150
     3.041    46.605     0.150
     3.307    49.957     0.150
     3.357    51.145     0.150
     3.357    51.035     0.150
     3.600    53.281     0.150
     3.600    92.656     0.150
     3.600   103.230     0.150
     3.683    56.457     0.150
     3.713    55.965     0.150
     3.890    57.676     0.150
     3.966    58.375     0.150
     4.012    59.816     0.150
     4.082    59.945     0.150
     4.481    65.605     0.150
     4.662    69.035     0.150
     4.722    69.016     0.150
     4.807    69.887     0.150
     4.833    69.727     0.150
     4.860    70.395     0.150
     4.878    71.234     0.150
     4.896    70.484     0.150
     5.040    74.137     0.150
     5.147    75.027     0.150
     5.233    76.387     0.150
     5.545    80.867     0.150
     5.566    81.695     0.150
     5.599    79.805     0.150
     5.617    80.145     0.150
     5.617    81.324     0.150
     5.617   145.574     0.150
     5.933    84.945     0.150
     6.380    91.637     0.150
     7.004    99.977     0.150
     7.235   104.785     0.150
     7.523   112.223     0.150
     7.591   109.875     0.150
     8.213   117.406     0.150
     8.717   125.285     0.150
     9.832   302.480     0.150
     9.925   141.727     0.150
    11.000   160.430     0.150
    11.770   170.812     0.150
    12.736   181.984     0.150
    19.197   262.008     0.150
    19.489   265.051     0.150
    19.489   523.105     0.150
    20.422   273.566     0.150
    20.442   272.965     0.150
    20.834   280.465     0.150
    25.770   329.555     0.150
    44.725   490.656     0.150
    65.149   638.066     0.150
    67.579   653.039     0.150
    81.583   734.539     0.150
     0.299     7.883     0.150
     0.299    13.613     0.150
     0.340     8.203     0.150
     0.340    14.232     0.150
     0.403     8.992     0.150
     0.463     9.523     0.150
     0.463    16.582     0.150
     0.463    16.752     0.150
     0.462     9.572     0.150
     0.462    16.723     0.150
     0.659    12.703     0.150
     0.659    22.033     0.150
     0.655    12.594     0.150
     0.655    21.953     0.150
     0.740    13.832     0.150
     0.740    13.402     0.150
     0.779    14.303     0.150
     0.779    25.184     0.150
     0.966    16.322     0.150
     0.966    29.854     0.150
     0.966    29.453     0.150
     0.943    16.023     0.150
     0.943    28.014     0.150
     0.955    16.264     0.150
     0.955    16.123     0.150
     0.941    16.453     0.150
     0.941    29.232     0.150
     0.975    16.273     0.150
     1.107    17.832     0.150
     1.107    32.562     0.150
     1.094    18.322     0.150
     1.067    18.002     0.150
     1.067    18.203     0.150
     1.067    31.463     0.150
     1.173    19.912     0.150
     1.173    34.492     0.150
     1.220    20.723     0.150
     1.220    20.752     0.150
     1.220    36.104     0.150
     1.266    20.562     0.150
     1.266    35.623     0.150
     1.278    21.023     0.150
     1.294    21.643     0.150
     1.427    23.482     0.150
     1.393    22.412     0.150
     1.434    22.854     0.150
     1.434    22.732     0.150
     1.434    22.953     0.150
     1.434    39.332     0.150
     1.435    22.922     0.150
     1.436    22.703     0.150
     1.435    22.732     0.150
     1.512    24.344     0.150
     1.499    24.203     0.150
     1.559    25.172     0.150
     1.613    25.992     0.150
     1.604    25.133     0.150
     1.623    25.072     0.150
     1.748    27.902     0.150
     1.748    28.072     0.150
     1.786    28.344     0.150
     1.786    48.672     0.150
     1.802    28.303     0.150
     1.836    28.562     0.150
     1.844    29.582     0.150
     1.844    51.803     0.150
     1.867    30.053     0.150
     1.867    29.193     0.150
     1.867    51.193     0.150
     1.947    30.873     0.150
     1.947    30.572     0.150
     1.947    52.693     0.150
     2.154    30.514     0.150
     2.134    32.412     0.150
     2.233    34.242     0.150
     2.233    58.854     0.150
     2.207    34.264     0.150
     2.252    34.982     0.150
     2.252    34.793     0.150
     2.367    37.523     0.150
     2.367    37.383     0.150
     2.409    36.463     0.150
     2.409    63.922     0.150
     2.420    37.152     0.150
     2.545    39.773     0.150
     2.622    40.533     0.150
     2.622    69.482     0.150
     2.745    38.883     0.150
     2.745    69.002     0.150
     2.768    39.162     0.150
     2.705    42.223     0.150
     2.786    39.443     0.150
     2.986    44.273     0.150
     2.986    76.322     0.150
     3.039    45.684     0.150
     3.031    46.953     0.150
     3.090    47.033     0.150
     3.377    51.732     0.150
     3.395    49.912     0.150
     3.395    87.422     0.150
     3.423    51.934     0.150
     3.488    52.502     0.150
     3.488    52.293     0.150
     3.488    89.873     0.150
     3.609    54.082     0.150
     3.641    55.033     0.150
     3.683    55.662     0.150
     3.712    56.422     0.150
     3.741    56.764     0.150
     3.744    57.922     0.150
     3.752    56.172     0.150
     3.801    56.123     0.150
     3.896    58.652     0.150
     4.042    61.693     0.150
     4.200    60.662     0.150
     4.266   109.492     0.150
     4.305    63.312     0.150
     4.674    69.902     0.150
     4.706    68.373     0.150
     5.079    75.184     0.150
     5.081    74.393     0.150
     5.203    74.672     0.150
     5.204    74.672     0.150
     5.258    76.822     0.150
     5.398    78.662     0.150
     6.278    92.463     0.150
     6.321    94.303     0.150
     0.260     6.430     0.150
     0.260    12.020     0.150
     0.401     8.199     0.150
     0.401    14.238     0.150
     0.449     8.859     0.150
     0.449    15.621     0.150
     0.500     9.422     0.150
     0.500    16.379     0.150
     0.566    10.199     0.150
     0.566    17.449     0.150
     0.595    11.121     0.150
     0.595    18.750     0.150
     0.596    11.020     0.150
     0.596    18.949     0.150
     0.803    14.320     0.150
     0.961    16.230     0.150
     0.961    27.852     0.150
     0.980    16.898     0.150
     1.036    16.832     0.150
     1.036    29.691     0.150
     1.056    17.160     0.150
     1.056    30.121     0.150
     1.124    18.789     0.150
     1.124    32.430     0.150
     1.190    19.270     0.150
     1.242    20.691     0.150
     1.255    20.809     0.150
     1.255    20.680     0.150
     1.255    35.691     0.150
     1.245    20.320     0.150
     1.245    35.270     0.150
     1.245    20.160     0.150
     1.245    20.352     0.150
     1.245    35.250     0.150
     1.373    22.191     0.150
     1.422    22.410     0.150
     1.422    22.309     0.150
     1.481    21.238     0.150
     1.481    37.469     0.150
     1.423    23.082     0.150
     1.436    23.172     0.150
     1.436    23.641     0.150
     1.436    40.672     0.150
     1.441    23.641     0.150
     1.441    40.480     0.150
     1.461    23.191     0.150
     1.461    40.309     0.150
     1.550    25.172     0.150
     1.550    43.148     0.150
     1.631    25.590     0.150
     1.668    27.141     0.150
     1.668    27.039     0.150
     1.668    46.461     0.150
     1.680    27.410     0.150
     1.687    27.070     0.150
     1.687    26.602     0.150
     1.687    25.941     0.150
     1.689    26.789     0.150
     1.747    28.539     0.150
     1.747    28.488     0.150
     1.747    27.422     0.150
     1.767    27.660     0.150
     1.792    27.609     0.150
     1.792    48.199     0.150
     1.859    28.961     0.150
     1.907    30.270     0.150
     1.874    29.832     0.150
     1.909    29.391     0.150
     1.922    30.520     0.150
     1.922    52.891     0.150
     2.029    31.789     0.150
     2.084    33.031     0.150
     2.097    32.500     0.150
     2.150    33.250     0.150
     2.213    34.289     0.150
     2.253    35.199     0.150
     2.253    60.262     0.150
     2.338    36.102     0.150
     2.341    36.469     0.150
     2.341    63.320     0.150
     2.422    36.699     0.150
     2.422    36.879     0.150
     2.422    64.090     0.150
     2.390    35.988     0.150
     2.390    63.379     0.150
     2.489    39.121     0.150
     2.489    67.949     0.150
     2.557    38.949     0.150
     2.560    38.789     0.150
     2.679    70.199     0.150
     2.715    42.672     0.150
     2.715    42.320     0.150
     2.747    41.941     0.150
     2.984    45.949     0.150
     3.039    80.371     0.150
     3.070    81.309     0.150
     3.072    47.301     0.150
     3.098    47.238     0.150
     3.098    83.051     0.150
     3.193    47.762     0.150
     3.228    47.988     0.150
     3.282    50.082     0.150
     3.311    50.711     0.150
     3.353    50.590     0.150
     3.418    52.031     0.150
     3.448    52.898     0.150
     3.457    52.680     0.150
     3.474    51.441     0.150
     3.491    53.121     0.150
     3.490    53.789     0.150
     3.500    53.340     0.150
     3.523    53.730     0.150
     3.549    54.461     0.150
     3.557    54.609     0.150
     3.562    54.410     0.150
     3.569    54.422     0.150
     3.781    56.449     0.150
     3.781    97.871     0.150
     3.843    58.059     0.150
     3.843   100.949     0.150
     3.937    59.930     0.150
     4.252   111.840     0.150
     4.431    66.871     0.150
     4.679    68.789     0.150
     4.679   118.898     0.150
     5.089    73.941     0.150
     5.089   128.789     0.150
     5.367    77.262     0.150
     5.367    77.340     0.150
     5.656    81.840     0.150
     6.943   100.602     0.150
     0.076     5.602     0.150
     0.076    10.012     0.150
     0.244     6.512     0.150
     0.244    11.332     0.150
     0.244    11.152     0.150
     0.254     6.723     0.150
     0.254    11.473     0.150
     0.358     8.602     0.150
     0.427     9.555     0.150
     0.467     9.562     0.150
     0.516    10.523     0.150
     0.559    10.531     0.150
     0.559    18.473     0.150
     0.559    18.215     0.150
     0.560    10.594     0.150
     0.560    18.574     0.150
     0.560    18.254     0.150
     0.575    10.934     0.150
     0.575    19.074     0.150
     0.575    18.902     0.150
     0.576    10.773     0.150
     0.576    19.191     0.150
     0.576    10.992     0.150
     0.576    18.965     0.150
     0.609    11.242     0.150
     0.609    19.633     0.150
     0.702    12.773     0.150
     0.702    22.441     0.150
     0.702    22.055     0.150
     0.806    14.055     0.150
     0.806    24.422     0.150
     0.806    24.121     0.150
     0.856    14.781     0.150
     0.856    25.742     0.150
     0.856    25.305     0.150
     0.838    14.684     0.150
     0.838    26.281     0.150
     0.838    14.574     0.150
     0.856    14.762     0.150
     0.856    25.512     0.150
     0.857    14.684     0.150
     0.857    25.492     0.150
     0.857    14.805     0.150
     0.857    25.383     0.150
     0.860    25.754     0.150
     0.848    15.102     0.150
     0.897    15.012     0.150
     0.897    26.434     0.150
     0.897    26.324     0.150
     0.963    16.754     0.150
     0.963    28.914     0.150
     0.970    16.703     0.150
     0.970    29.371     0.150
     1.030    17.352     0.150
     1.074    18.395     0.150
     1.074    31.824     0.150
     1.115    18.664     0.150
     1.123    19.113     0.150
     1.115    18.664     0.150
     1.259    21.055     0.150
     1.259    36.652     0.150
     1.301    21.492     0.150
     1.311    21.684     0.150
     1.336    22.242     0.150
     1.336    22.473     0.150
     1.336    39.043     0.150
     1.360    22.465     0.150
     1.360    22.121     0.150
     1.373    22.723     0.150
     1.373    39.152     0.150
     1.378    22.293     0.150
     1.391    22.543     0.150
     1.391    39.574     0.150
     1.477    23.684     0.150
     1.508    24.234     0.150
     1.565    25.062     0.150
     1.607    26.133     0.150
     1.662    26.652     0.150
     1.662    46.242     0.150
     1.674    26.664     0.150
     1.674    26.473     0.150
     1.728    27.852     0.150
     1.728    27.504     0.150
     1.737    27.223     0.150
     1.737    46.691     0.150
     1.837    29.562     0.150
     1.837    29.414     0.150
     1.884    30.172     0.150
     1.884    30.422     0.150
     1.972    30.395     0.150
     1.972    52.434     0.150
     2.035    31.422     0.150
     2.103    33.422     0.150
     2.103    33.254     0.150
     2.103    57.555     0.150
     2.132    32.734     0.150
     2.146    33.684     0.150
     2.156    33.254     0.150
     2.158    33.852     0.150
     2.158    33.484     0.150
     2.184    34.465     0.150
     2.184    34.012     0.150
     2.206    33.504     0.150
     2.229    35.164     0.150
     2.230    35.664     0.150
     2.230    35.062     0.150
     2.315    36.422     0.150
     2.374    36.754     0.150
     2.374    63.934     0.150
     2.425    37.672     0.150
     2.462    37.871     0.150
     2.483    37.984     0.150
     2.483    38.164     0.150
     2.504    37.902     0.150
     2.523    38.613     0.150
     2.523    38.145     0.150
     2.543    39.441     0.150
     2.550    39.082     0.150
     2.554    38.684     0.150
     2.578    39.715     0.150
     2.612    40.402     0.150
     2.612    40.145     0.150
     2.601    40.004     0.150
     2.618    40.633     0.150
     2.634    40.414     0.150
     2.676    41.133     0.150
     2.685    41.395     0.150
     2.734    42.824     0.150
     2.747    43.062     0.150
     2.772    41.805     0.150
     2.886    43.684     0.150
     2.875    44.512     0.150
     2.880    44.082     0.150
     2.914    78.242     0.150
     2.953    44.754     0.150
     3.205    47.844     0.150
     3.205    47.562     0.150
     3.300    50.652     0.150
     3.302    49.883     0.150
     3.529    54.324     0.150
     3.659    55.715     0.150
     3.900    58.121     0.150
     4.064    60.492     0.150
     4.071    61.531     0.150
     4.126    60.582     0.150
     4.323    62.402     0.150
     4.332    65.145     0.150
     4.413    64.395     0.150
     5.736    82.555     0.150
     0.275    11.586     0.150
     0.275     6.641     0.150
     0.275    11.422     0.150
     0.275     6.664     0.150
     0.275    11.594     0.150
     0.275    11.477     0.150
     0.456     9.711     0.150
     0.456     9.844     0.150
     0.434     8.750     0.150
     0.434    14.992     0.150
     0.434    14.789     0.150
     0.513     9.711     0.150
     0.513    16.805     0.150
     0.704    12.383     0.150
     0.704    21.945     0.150
     0.704    12.500     0.150
     0.704    21.375     0.150
     0.672    12.422     0.150
     0.672    21.875     0.150
     0.672    12.172     0.150
     0.704    12.414     0.150
     0.704    21.391     0.150
     0.745    13.250     0.150
     0.746    12.992     0.150
     0.746    22.852     0.150
     0.746    13.391     0.150
     0.746    22.492     0.150
     0.740    13.422     0.150
     0.740    24.031     0.150
     0.857    15.102     0.150
     1.034    17.586     0.150
     1.034    17.742     0.150
     1.034    29.875     0.150
     1.091    18.195     0.150
     1.109    18.102     0.150
     1.109    32.422     0.150
     1.154    19.156     0.150
     1.154    32.805     0.150
     1.154    19.172     0.150
     1.155    19.086     0.150
     1.155    33.281     0.150
     1.156    19.031     0.150
     1.156    19.172     0.150
     1.230    20.141     0.150
     1.230    36.086     0.150
     1.209    20.070     0.150
     1.247    19.930     0.150
     1.247    20.070     0.150
     1.247    34.875     0.150
     1.240    21.070     0.150
     1.240    36.094     0.150
     1.352    22.539     0.150
     1.349    22.750     0.150
     1.349    39.180     0.150
     1.342    22.023     0.150
     1.397    22.266     0.150
     1.466    23.570     0.150
     1.478    24.539     0.150
     1.478    41.984     0.150
     1.652    26.766     0.150
     1.653    26.289     0.150
     1.695    27.133     0.150
     1.700    27.727     0.150
     1.721    27.555     0.150
     1.731    27.539     0.150
     1.754    27.945     0.150
     1.840    29.492     0.150
     1.871    29.273     0.150
     1.871    29.406     0.150
     1.898    27.156     0.150
     1.930    31.102     0.150
     1.930    31.172     0.150
     1.962    30.484     0.150
     2.105    32.500     0.150
     2.156    34.766     0.150
     2.156    34.602     0.150
     2.201    34.602     0.150
     2.337    36.023     0.150
     2.405    37.164     0.150
     2.405    37.266     0.150
     2.553    39.570     0.150
     2.615    40.250     0.150
     2.598    39.992     0.150
     2.744    41.586     0.150
     2.855    43.336     0.150
     2.877    43.773     0.150
     2.887    43.977     0.150
     2.913    44.094     0.150
     2.971    46.031     0.150
     3.048    46.430     0.150
     3.305    50.344     0.150
     3.600    53.945     0.150
     3.748    55.961     0.150
     3.861    57.844     0.150
     3.900    57.891     0.150
     3.900    57.516     0.150
     3.945    57.875     0.150
     4.044    60.906     0.150
     4.083    60.086     0.150
     4.083   104.680     0.150
     4.083   127.461     0.150
     4.083    59.742     0.150
     4.083    67.703     0.150
     4.128    61.016     0.150
     4.183    61.852     0.150
     4.205    61.984     0.150
     4.248    63.789     0.150
     4.377    65.266     0.150
     4.394    64.320     0.150
     4.404    64.539     0.150
     4.481    65.156     0.150
     4.559    67.945     0.150
     4.622    68.492     0.150
     4.890    73.039     0.150
     5.070    74.953     0.150
     5.378    77.875     0.150
     5.378   166.055     0.150
     5.378    78.000     0.150
     5.396    77.914     0.150
     5.470    79.555     0.150
     5.737    84.742     0.150
     5.801    83.359     0.150
     5.933    86.422     0.150
     6.002    86.273     0.150
     6.405    91.930     0.150
     6.565    94.672     0.150
     6.547    94.125     0.150
     7.049   105.117     0.150
     7.194   103.766     0.150
     7.340   105.500     0.150
     7.754   111.602     0.150
     7.786   112.836     0.150
     8.833   125.922     0.150
     9.001   129.000     0.150
     9.001   130.531     0.150
     9.262   131.555     0.150
    10.303   147.883     0.150
    10.303   322.984     0.150
    10.540   152.961     0.150
    11.109   157.461     0.150
    11.286   164.055     0.150
    11.865   170.906     0.150
    12.165   173.664     0.150
    12.165   174.305     0.150
    12.364   177.281     0.150
    13.543   192.656     0.150
    13.912   195.523     0.150
    14.000   196.039     0.150
    14.117   198.742     0.150
    14.200   199.453     0.150
    14.472   203.211     0.150
    14.614   203.539     0.150
    14.738   206.523     0.150
    15.161   469.227     0.150
    15.844   221.164     0.150
    16.239   225.242     0.150
    16.301   228.453     0.150
    16.301   230.445     0.150
    16.551   230.656     0.150
    16.639   232.406     0.150
    17.184   238.430     0.150
    17.643   243.625     0.150
    17.737   243.961     0.150
    18.785   255.930     0.150
    19.097   258.531     0.150
    19.097   592.961     0.150
    19.097   258.344     0.150
    19.164   260.484     0.150
    19.413   262.086     0.150
    19.413   262.750     0.150
    19.430   264.977     0.150
    19.430   264.203     0.150
    19.430   266.227     0.150
    19.532   265.836     0.150
    19.532   269.570     0.150
    19.973   271.234     0.150
    19.973   270.633     0.150
    20.242   273.961     0.150
    20.313   272.344     0.150
    20.313   273.953     0.150
    20.346   273.312     0.150
    20.549   273.094     0.150
    20.873   277.594     0.150
    21.018   282.250     0.150
    21.346   285.344     0.150
    22.259   292.859     0.150
    22.343   292.281     0.150
    22.343   292.750     0.150
    22.540   297.844     0.150
    22.540   299.656     0.150
    22.572   298.586     0.150
    22.760   300.352     0.150
    23.253   303.977     0.150
    23.477   308.602     0.150
    23.529   305.172     0.150
    23.935   313.031     0.150
    24.175   313.594     0.150
    24.212   314.172     0.150
    25.318   324.133     0.150
    25.318   326.484     0.150
    26.484   333.781     0.150
    26.600   334.727     0.150
    26.633   335.172     0.150
    26.633   336.773     0.150
    27.261   342.984     0.150
    29.717   362.445     0.150
    29.793   364.289     0.150
    32.546   390.000     0.150
    35.776   417.156     0.150
    46.515   507.805     0.150
    48.875   524.555     0.150
    52.260   549.641     0.150
    59.970   603.805     0.150
    60.269   606.758     0.150
    66.635   646.961     0.150
    67.422   652.930     0.150
    67.939   656.727     0.150
    67.939   656.305     0.150
    74.764   696.008     0.150
    77.839   715.281     0.150
    77.907   715.406     0.150
    77.930   715.852     0.150
    78.124   720.383     0.150
    79.015   722.055     0.150
    79.120   722.055     0.150
    81.502   735.484     0.150
    82.062   738.055     0.150
    82.062   737.406     0.150
    82.114   738.102     0.150
    82.466   739.789     0.150
    82.466   739.359     0.150
    83.075   741.664     0.150
    83.581   746.281     0.150
    94.290   797.484     0.150
     0.113     4.969     0.150
     0.113     8.889     0.150
     0.112     5.029     0.150
     0.112     8.889     0.150
     0.112     9.020     0.150
     0.183     5.629     0.150
     0.183     9.809     0.150
     0.183     5.469     0.150
     0.214     5.828     0.150
     0.214    10.119     0.150
     0.350     7.510     0.150
     0.350    13.270     0.150
     0.350    13.379     0.150
     0.393     7.859     0.150
     0.393    13.809     0.150
     0.393     7.889     0.150
     0.393    13.818     0.150
     0.505     9.479     0.150
     0.505    16.479     0.150
     0.659    11.879     0.150
     0.659    20.648     0.150
     0.700    12.898     0.150
     0.726    12.930     0.150
     0.726    22.809     0.150
     0.727    12.988     0.150
     0.727    22.770     0.150
     0.801    14.049     0.150
     0.861    15.029     0.150
     0.861    25.969     0.150
     0.921    15.840     0.150
     0.921    27.619     0.150
     0.900    15.648     0.150
     1.003    16.959     0.150
     1.003    29.568     0.150
     1.011    17.100     0.150
     1.011    30.629     0.150
     1.011    17.719     0.150
     1.106    18.479     0.150
     1.106    18.709     0.150
     1.106    33.039     0.150
     1.104    18.908     0.150
     1.077    18.039     0.150
     1.130    33.658     0.150
     1.126    19.398     0.150
     1.126    34.158     0.150
     1.127    18.619     0.150
     1.202    20.439     0.150
     1.202    35.129     0.150
     1.202    20.299     0.150
     1.202    35.129     0.150
     1.202    20.510     0.150
     1.203    20.408     0.150
     1.203    35.209     0.150
     1.204    20.449     0.150
     1.204    35.309     0.150
     1.293    21.469     0.150
     1.354    22.289     0.150
     1.354    39.449     0.150
     1.358    22.969     0.150
     1.437    24.270     0.150
     1.437    24.068     0.150
     1.437    23.498     0.150
     1.513    24.809     0.150
     1.513    43.418     0.150
     1.502    24.668     0.150
     1.570    26.148     0.150
     1.674    27.389     0.150
     1.703    26.600     0.150
     1.703    26.709     0.150
     1.786    27.998     0.150
     1.916    30.908     0.150
     1.903    33.090     0.150
     1.902    33.100     0.150
     1.916    30.469     0.150
     1.934    30.309     0.150
     1.934    30.918     0.150
     2.060    31.709     0.150
     2.060    31.529     0.150
     2.109    33.840     0.150
     2.105    33.398     0.150
     2.191    33.668     0.150
     2.283    36.398     0.150
     2.338    35.439     0.150
     2.449    37.078     0.150
     2.548    37.949     0.150
     2.688    40.559     0.150
     2.738    42.100     0.150
     2.832    48.799     0.150
     3.168    46.988     0.150
     3.173    47.219     0.150
     3.552    53.059     0.150
     3.743    54.260     0.150
     3.747    55.078     0.150
     4.171    61.139     0.150
     4.688    68.520     0.150
     4.732    68.279     0.150
     5.558    80.309     0.150
     0.333     6.637     0.150
     0.333    11.496     0.150
     0.448     8.938     0.150
     0.409     7.957     0.150
     0.409    13.430     0.150
     0.538    10.117     0.150
     0.538    17.496     0.150
     0.671    12.359     0.150
     0.654    12.180     0.150
     0.654    21.027     0.150
     0.679    12.578     0.150
     0.679    21.930     0.150
     0.788    13.789     0.150
     0.788    23.918     0.150
     0.841    14.699     0.150
     0.841    25.270     0.150
     0.906    15.598     0.150
     0.906    26.719     0.150
     0.936    16.270     0.150
     1.076    18.199     0.150
     1.076    31.418     0.150
     1.103    19.008     0.150
     1.103    33.066     0.150
     1.129    18.977     0.150
     1.129    18.898     0.150
     1.129    33.688     0.150
     1.197    19.930     0.150
     1.197    35.648     0.150
     1.228    20.938     0.150
     1.228    37.129     0.150
     1.370    22.246     0.150
     1.500    24.836     0.150
     1.500    43.938     0.150
     1.514    25.316     0.150
     1.514    44.207     0.150
     1.667    26.328     0.150
     1.898    29.977     0.150
     1.863    29.770     0.150
     1.981    31.430     0.150
     2.064    57.836     0.150
     2.570    40.918     0.150
     0.166     5.750     0.150
     0.166    10.133     0.150
     0.210     6.055     0.150
     0.210    10.547     0.150
     0.320     7.203     0.150
     0.320    13.070     0.150
     0.344     7.477     0.150
     0.344    13.273     0.150
     0.355     7.984     0.150
     0.355    14.242     0.150
     0.414     8.453     0.150
     0.414    15.023     0.150
     0.414     8.422     0.150
     0.414    15.172     0.150
     0.493     9.562     0.150
     0.493    16.977     0.150
     0.593    11.102     0.150
     0.772    23.930     0.150
     0.801    14.211     0.150
     0.801    25.070     0.150
     0.882    14.695     0.150
     0.866    15.461     0.150
     0.866    27.156     0.150
     0.903    15.375     0.150
     0.903    15.406     0.150
     0.903    27.195     0.150
     0.912    16.211     0.150
     0.912    28.430     0.150
     0.915    16.062     0.150
     0.949    16.305     0.150
     0.949    28.883     0.150
     1.120    19.203     0.150
     1.120    33.875     0.150
     1.125    18.656     0.150
     1.211    20.273     0.150
     1.271    21.477     0.150
     1.281    21.273     0.150
     1.281    37.742     0.150
     1.349    22.547     0.150
     1.349    39.820     0.150
     1.385    22.844     0.150
     1.385    40.680     0.150
     1.544    43.844     0.150
     1.875    29.609     0.150
     1.914    30.992     0.150
     2.052    31.992     0.150
     2.321    35.414     0.150
     2.347    36.914     0.150
     2.734    41.766     0.150
     0.212     6.534     0.150
     0.212    11.234     0.150
     0.235     7.194     0.150
     0.235    12.424     0.150
     0.219    11.734     0.150
     0.219    11.964     0.150
     0.270     7.514     0.150
     0.270    13.134     0.150
     0.219     6.744     0.150
     0.219    11.794     0.150
     0.310     8.014     0.150
     0.310    13.954     0.150
     0.332    14.734     0.150
     0.354     8.224     0.150
     0.354    14.094     0.150
     0.354     8.244     0.150
     0.354    14.174     0.150
     0.509    10.004     0.150
     0.509    17.294     0.150
     0.509    17.424     0.150
     0.459     9.685     0.150
     0.459    17.114     0.150
     0.536    10.404     0.150
     0.597    11.504     0.150
     0.597    19.734     0.150
     0.675    12.524     0.150
     0.675    21.964     0.150
     0.695    12.824     0.150
     0.763    13.604     0.150
     0.763    23.494     0.150
     0.763    23.334     0.150
     0.736    13.244     0.150
     0.782    13.944     0.150
     0.782    13.944     0.150
     0.782    13.964     0.150
     0.782    24.114     0.150
     0.836    14.774     0.150
     0.836    25.424     0.150
     0.836    14.645     0.150
     0.836    25.064     0.150
     0.836    25.464     0.150
     0.836    14.704     0.150
     0.829    14.504     0.150
     0.829    25.165     0.150
     0.829    24.884     0.150
     0.799    14.014     0.150
     0.799    14.125     0.150
     0.840    14.814     0.150
     0.864    15.054     0.150
     0.864    25.724     0.150
     0.935    16.174     0.150
     0.935    28.014     0.150
     0.965    16.125     0.150
     0.965    27.864     0.150
     1.000    16.935     0.150
     1.000    28.954     0.150
     1.001    17.044     0.150
     1.001    29.614     0.150
     1.001    16.984     0.150
     1.001    28.984     0.150
     1.001    29.454     0.150
     1.003    16.994     0.150
     1.003    28.994     0.150
     0.952    16.194     0.150
     0.965    16.584     0.150
     1.050    17.594     0.150
     1.050    30.145     0.150
     1.050    30.384     0.150
     1.070    31.014     0.150
     1.158    19.424     0.150
     1.158    33.294     0.150
     1.158    19.464     0.150
     1.158    33.474     0.150
     1.173    19.764     0.150
     1.173    33.774     0.150
     1.127    18.834     0.150
     1.127    32.954     0.150
     1.127    32.824     0.150
     1.248    20.944     0.150
     1.248    35.895     0.150
     1.275    21.375     0.150
     1.275    36.334     0.150
     1.299    20.884     0.150
     1.371    22.784     0.150
     1.340    21.784     0.150
     1.340    37.395     0.150
     1.365    21.674     0.150
     1.365    36.944     0.150
     1.381    22.824     0.150
     1.463    24.094     0.150
     1.507    24.024     0.150
     1.525    24.594     0.150
     1.575    43.264     0.150
     1.621    26.484     0.150
     1.621    45.254     0.150
     1.641    26.625     0.150
     1.641    45.584     0.150
     1.682    26.344     0.150
     1.696    26.444     0.150
     1.696    45.614     0.150
     1.696    26.494     0.150
     1.839    29.274     0.150
     1.862    29.754     0.150
     1.862    51.834     0.150
     1.860    29.645     0.150
     1.860    51.304     0.150
     1.938    30.364     0.150
     1.938    52.534     0.150
     1.955    31.334     0.150
     1.955    53.154     0.150
     1.980    31.904     0.150
     1.999    31.734     0.150
     1.999    54.884     0.150
     2.022    54.574     0.150
     2.014    31.804     0.150
     2.040    31.794     0.150
     2.142    34.494     0.150
     2.257    35.044     0.150
     2.361    36.354     0.150
     2.361    64.094     0.150
     2.327    35.724     0.150
     2.346    36.104     0.150
     2.346    62.344     0.150
     2.359    37.034     0.150
     2.426    37.324     0.150
     2.441    37.544     0.150
     2.441    65.125     0.150
     2.510    38.814     0.150
     2.510    66.685     0.150
     2.525    39.054     0.150
     2.525    67.174     0.150
     2.564    39.154     0.150
     2.564    67.354     0.150
     2.631    40.574     0.150
     2.821    43.224     0.150
     2.922    43.924     0.150
     2.922    75.564     0.150
     2.964    41.754     0.150
     2.964    74.714     0.150
     3.008    45.594     0.150
     3.008    77.935     0.150
     2.985    42.165     0.150
     3.065    46.375     0.150
     3.131    47.935     0.150
     3.201    49.034     0.150
     3.201    83.074     0.150
     3.430    51.884     0.150
     3.430    88.294     0.150
     3.573    53.864     0.150
     3.580    53.814     0.150
     5.054    73.654     0.150
     6.641    95.594     0.150
     6.991   100.435     0.150
     0.069     5.325     0.150
     0.069     9.226     0.150
     0.259     6.945     0.150
     0.259    11.716     0.150
     0.393     8.426     0.150
     0.393    14.586     0.150
     0.523    10.476     0.150
     0.523    18.155     0.150
     0.587    11.155     0.150
     0.587    18.855     0.150
     0.593    11.275     0.150
     0.593    19.245     0.150
     0.593    19.025     0.150
     0.673    12.386     0.150
     0.673    21.516     0.150
     0.724    13.235     0.150
     0.859    14.876     0.150
     0.859    25.785     0.150
     0.860    14.815     0.150
     0.860    25.846     0.150
     0.854    14.995     0.150
     0.947    16.216     0.150
     0.947    16.256     0.150
     0.906    16.155     0.150
     0.906    27.785     0.150
     0.950    16.735     0.150
     0.950    29.386     0.150
     0.962    16.485     0.150
     1.060    17.766     0.150
     1.256    21.086     0.150
     1.320    21.235     0.150
     1.419    22.405     0.150
     1.470    23.586     0.150
     1.470    23.376     0.150
     1.485    24.186     0.150
     1.409    23.216     0.150
     1.619    26.235     0.150
     1.772    27.716     0.150
     1.817    26.416     0.150
     1.951    29.705     0.150
     1.951    30.355     0.150
     2.021    31.796     0.150
     2.120    32.216     0.150
     2.194    33.565     0.150
     2.402    37.216     0.150
     2.318    33.695     0.150
     2.330    32.995     0.150
     2.469    37.516     0.150
     2.668    40.995     0.150
     2.681    41.046     0.150
     2.727    41.365     0.150
     2.727    41.626     0.150
     2.856    43.195     0.150
     2.907    44.376     0.150
     2.899    43.796     0.150
     3.039    46.336     0.150
     3.111    80.626     0.150
     3.118    47.306     0.150
     3.163    47.766     0.150
     3.140    46.910     0.150
     3.140    81.535     0.150
     3.140    92.636     0.150
     3.140    47.046     0.150
     3.909    57.016     0.150
     4.054    60.626     0.150
     4.131    61.455     0.150
     4.188    60.315     0.150
     4.352    62.955     0.150
     4.817    71.336     0.150
     4.806    69.466     0.150
     4.872    72.075     0.150
     5.046    75.016     0.150
     5.090    74.605     0.150
     5.253    78.065     0.150
     5.332    78.386     0.150
     5.280    75.945     0.150
     5.373    78.966     0.150
     5.541    80.376     0.150
     5.541   138.266     0.150
     5.541    80.235     0.150
     5.541   137.976     0.150
     5.630    81.886     0.150
     6.121    88.255     0.150
     7.946   202.953     0.150
     9.370   137.945     0.150
     9.428   138.905     0.150
     9.463   139.096     0.150
     9.441   137.461     0.150
     9.441   288.086     0.150
     9.522   139.615     0.150
     9.499   135.745     0.150
     9.971   141.966     0.150
     9.971   143.766     0.150
    10.066   142.605     0.150
    10.216   149.336     0.150
    10.297   149.966     0.150
    10.745   157.235     0.150
    10.919   158.995     0.150
    10.927   159.535     0.150
    11.002   159.166     0.150
    11.547   167.185     0.150
    12.253   177.035     0.150
    12.275   172.976     0.150
    12.260   176.636     0.150
    12.373   174.256     0.150
    12.839   181.476     0.150
    13.164   186.176     0.150
    13.291   189.035     0.150
    14.731   456.601     0.150
    14.875   208.386     0.150
    15.034   211.726     0.150
    15.067   211.676     0.150
    15.131   213.596     0.150
    15.155   213.216     0.150
    15.159   213.296     0.150
    15.214   211.535     0.150
    15.215   215.416     0.150
    15.307   215.016     0.150
    15.280   214.865     0.150
    16.429   229.716     0.150
    16.547   231.025     0.150
    17.265   240.079     0.150
    17.265   240.886     0.150
    17.265   240.396     0.150
    17.317   237.626     0.150
    17.331   242.216     0.150
    17.453   241.485     0.150
    17.446   242.416     0.150
    17.446   242.525     0.150
    17.553   243.876     0.150
    17.564   246.535     0.150
    17.633   244.506     0.150
    18.144   250.626     0.150
    18.411   253.586     0.150
    18.890   259.396     0.150
    19.135   260.346     0.150
    18.956   258.846     0.150
    18.937   260.506     0.150
    19.009   258.936     0.150
    19.009   524.636     0.150
    19.009   593.701     0.150
    19.009   260.445     0.150
    19.232   260.176     0.150
    19.377   266.016     0.150
    19.427   264.056     0.150
    19.426   264.785     0.150
    19.426   264.285     0.150
    19.426   602.900     0.150
    19.426   264.605     0.150
    19.426   265.535     0.150
    19.419   265.785     0.150
    19.587   262.660     0.150
    19.587   609.711     0.150
    19.587   262.815     0.150
    19.587   263.336     0.150
    19.595   265.815     0.150
    19.734   267.916     0.150
    19.742   267.876     0.150
    19.915   271.525     0.150
    19.934   271.086     0.150
    19.989   267.376     0.150
    19.989   269.016     0.150
    19.919   271.115     0.150
    20.062   273.065     0.150
    20.426   275.766     0.150
    20.426   276.604     0.150
    20.426   276.936     0.150
    20.426   276.186     0.150
    20.447   275.525     0.150
    20.535   277.436     0.150
    20.535   276.745     0.150
    20.535   278.535     0.150
    20.817   281.516     0.150
    20.951   278.485     0.150
    20.955   281.896     0.150
    21.055   278.815     0.150
    21.060   279.016     0.150
    21.060   279.396     0.150
    21.172   282.596     0.150
    21.296   285.586     0.150
    21.477   288.025     0.150
    21.634   287.855     0.150
    21.693   289.825     0.150
    21.705   290.686     0.150
    21.865   291.115     0.150
    21.984   292.646     0.150
    22.035   291.416     0.150
    22.073   291.775     0.150
    22.510   296.865     0.150
    22.553   299.195     0.150
    22.557   298.525     0.150
    23.073   302.176     0.150
    23.090   303.485     0.150
    23.171   303.676     0.150
    23.370   305.285     0.150
    23.426   306.565     0.150
    23.439   306.785     0.150
    23.543   309.235     0.150
    23.543   308.466     0.150
    23.765   309.945     0.150
    24.088   314.355     0.150
    24.674   318.825     0.150
    24.872   320.485     0.150
    24.880   321.086     0.150
    24.880   320.476     0.150
    25.511   326.396     0.150
    25.588   326.705     0.150
    26.317   334.836     0.150
    26.321   334.056     0.150
    26.321   334.336     0.150
    26.321     7.699     0.150
    26.322   334.811     0.150
    26.322   334.046     0.150
    27.400   345.386     0.150
    27.400   342.686     0.150
    27.400   345.535     0.150
    27.458   343.695     0.150
    27.458   342.936     0.150
    28.163   350.796     0.150
    28.707   354.046     0.150
    30.057   368.325     0.150
    30.057   368.035     0.150
    30.567   371.346     0.150
    30.567     9.640     0.150
    30.796   373.245     0.150
    30.796   372.796     0.150
    30.796   373.035     0.150
    30.796     9.399     0.150
    30.796    13.739     0.150
    31.789   380.056     0.150
    31.653   380.676     0.150
    32.017   382.461     0.150
    32.017   382.936     0.150
    32.397   389.436     0.150
    32.397   388.166     0.150
    32.397   390.136     0.150
    32.670   389.025     0.150
    33.279   394.806     0.150
    33.323   395.676     0.150
    33.323   395.186     0.150
    34.007   400.916     0.150
    34.340   404.126     0.150
    34.778   407.315     0.150
    34.778     9.920     0.150
    34.979   409.825     0.150
    35.234   411.546     0.150
    35.234   411.325     0.150
    35.295   412.636     0.150
    35.709   415.396     0.150
    35.987   417.061     0.150
    35.987   417.535     0.150
    37.314   432.815     0.150
    37.521   430.735     0.150
    40.133   453.865     0.150
    40.644   457.075     0.150
    41.883   468.325     0.150
    41.883   467.876     0.150
    41.883   468.126     0.150
    43.003   477.376     0.150
    43.266   479.605     0.150
    43.266   479.726     0.150
    44.337   488.235     0.150
    45.723   499.660     0.150
    46.386   503.735     0.150
    46.386   503.266     0.150
    47.434   512.075     0.150
    48.193   517.825     0.150
    48.193   518.046     0.150
    48.431    14.140     0.150
    49.634   529.626     0.150
    53.123   555.485     0.150
    53.123   555.155     0.150
    55.569   573.455     0.150
    55.569   572.966     0.150
    58.202   592.205     0.150
    58.202   591.985     0.150
    60.509   607.636     0.150
    60.483   609.686     0.150
    61.223   613.266     0.150
    61.223   612.695     0.150
    62.224   618.711     0.150
    62.535   623.936     0.150
    63.857   630.396     0.150
    64.594   636.988     0.150
    64.706   635.426     0.150
    64.832   636.235     0.150
    64.832   635.936     0.150
    65.426   639.136     0.150
    66.213   644.039     0.150
    67.415   652.916     0.150
    67.415   652.511     0.150
    67.415   652.285     0.150
    68.169   657.666     0.150
    69.718  1475.735     0.150
    70.839   675.325     0.150
    72.115   682.256     0.150
    72.275   683.065     0.150
    72.289   682.666     0.150
    72.290   683.686     0.150
    72.518   684.565     0.150
    72.567   684.905     0.150
    72.567   684.726     0.150
    72.657   687.436     0.150
    72.702   686.386     0.150
    73.102   688.195     0.150
    73.098   688.590     0.150
    73.295   689.686     0.150
    73.314   689.596     0.150
    73.314     8.479     0.150
    73.544   690.955     0.150
    73.665   691.426     0.150
    73.861   693.860     0.150
    73.905   692.836     0.150
    73.905     8.470     0.150
    73.905   692.275     0.150
    73.929   692.766     0.150
    73.929     9.140     0.150
    73.929   692.586     0.150
    73.929   692.336     0.150
    73.929     8.600     0.150
    73.929   707.936     0.150
    74.082   693.586     0.150
    74.126   694.065     0.150
    74.126     8.590     0.150
    74.573   696.806     0.150
    74.580   696.495     0.150
    74.768   697.346     0.150
    74.782   698.666     0.150
    74.825   698.716     0.150
    74.858   699.105     0.150
    74.859   699.035     0.150
    74.859   698.726     0.150
    74.859    14.710     0.150
    74.882   698.416     0.150
    75.064   699.336     0.150
    75.082   699.796     0.150
    75.147   700.436     0.150
    75.158   700.636     0.150
    75.165   700.136     0.150
    75.165   699.365     0.150
    75.165   699.936     0.150
    75.165    14.530     0.150
    75.251   700.315     0.150
    75.279   700.216     0.150
    75.342   701.705     0.150
    75.366   701.506     0.150
    75.408   702.466     0.150
    75.480   701.976     0.150
    75.488   701.886     0.150
    75.506   701.916     0.150
    75.545   702.705     0.150
    75.568   702.846     0.150
    75.663   702.655     0.150
    75.681   703.615     0.150
    75.696   703.626     0.150
    75.713   703.485     0.150
    75.835   704.365     0.150
    76.023   704.495     0.150
    76.049   705.516     0.150
    76.144   704.876     0.150
    76.303   707.046     0.150
    76.341   707.166     0.150
    76.341   706.961     0.150
    76.341   706.466     0.150
    76.421   707.016     0.150
    76.434   707.615     0.150
    76.476   708.426     0.150
    76.515   707.065     0.150
    76.537   707.876     0.150
    76.539   707.936     0.150
    76.580   709.216     0.150
    76.580   707.083     0.150
    76.245   708.136     0.150
    76.720   709.245     0.150
    76.720   709.436     0.150
    76.801   709.006     0.150
    76.876   709.535     0.150
    76.892   708.815     0.150
    76.892   710.035     0.150
    76.908   712.636     0.150
    76.951   709.455     0.150
    76.987   709.568     0.150
    77.032   710.806     0.150
    77.074   711.346     0.150
    77.083   710.632     0.150
    77.081   712.235     0.150
    77.148   711.343     0.150
    77.292   713.605     0.150
    77.320   711.699     0.150
    77.411   712.985     0.150
    77.403   711.639     0.150
    77.415   714.136     0.150
    77.604   724.769     0.150
    77.637   713.916     0.150
    77.637   714.266     0.150
    77.948   714.916     0.150
    77.669   715.607     0.150
    77.669   724.893     0.150
    77.690   714.695     0.150
    77.692   714.596     0.150
    77.758   715.898     0.150
    77.758   724.603     0.150
    77.784   715.195     0.150
    77.784   715.306     0.150
    77.782   713.065     0.150
    77.847   714.961     0.150
    77.887   715.436     0.150
    77.878   714.576     0.150
    77.920   717.336     0.150
    77.998   716.376     0.150
    78.106   718.936     0.150
    78.157   715.949     0.150
    78.134   717.336     0.150
    78.134   718.376     0.150
    78.134   726.926     0.150
    78.134    14.279     0.150
    78.162   719.136     0.150
    78.186   719.035     0.150
    78.198   718.035     0.150
    78.210   716.160     0.150
    78.210   719.235     0.150
    78.214   718.195     0.150
    78.214   719.636     0.150
    78.239   717.336     0.150
    78.280   718.936     0.150
    78.285   718.535     0.150
    78.305   718.006     0.150
    78.469   717.455     0.150
    78.477   728.928     0.150
    78.546   727.726     0.150
    78.686   719.057     0.150
    78.760   720.995     0.150
    78.815   721.096     0.150
    78.853   721.905     0.150
    79.734   728.136     0.150
    80.038   727.466     0.150
    80.081   726.976     0.150
    80.109   727.886     0.150
    80.590   732.086     0.150
    80.757   730.216     0.150
    81.152   733.930     0.150
    81.152   733.186     0.150
    81.428   735.126     0.150
    81.428   734.766     0.150
    81.703   735.556     0.150
    81.703   735.865     0.150
    82.385   740.275     0.150
    82.378   740.025     0.150
    82.639   744.436     0.150
    83.020   742.865     0.150
    83.020   742.735     0.150
    83.020    14.160     0.150
    83.094   743.546     0.150
    83.095   743.105     0.150
    83.378   744.976     0.150
    83.779   748.245     0.150
    83.779   749.436     0.150
    83.983   748.916     0.150
    83.983   748.235     0.150
    84.096   747.235     0.150
    84.598   751.086     0.150
    84.789   751.336     0.150
    85.253   755.105     0.150
    85.253   754.216     0.150
    85.781   756.266     0.150
    86.244   758.256     0.150
    86.265   758.306     0.150
    86.637   761.211     0.150
    86.890   764.561     0.150
    86.890   765.436     0.150
    86.945   761.775     0.150
    87.095   762.815     0.150
    89.338   773.466     0.150
    89.776   775.535     0.150
    90.192   778.396     0.150
    90.493   780.006     0.150
    91.447   786.266     0.150
    93.734   793.405     0.150
    95.448   804.105     0.150
    96.334   807.775     0.150
   144.085  1169.023     0.150
   144.582  1169.888     0.150
   144.848  1171.372     0.150
   146.202  1175.853     0.150
   150.009  1186.485     0.150
     0.303     6.846     0.150
     0.303    12.055     0.150
     0.274     6.266     0.150
     0.274    11.096     0.150
     0.304     6.695     0.150
     0.304    12.186     0.150
     0.304     6.896     0.150
     0.290     6.955     0.150
     0.290    12.496     0.150
     0.386     8.305     0.150
     0.386    14.855     0.150
     0.492     9.564     0.150
     0.492    16.590     0.150
     0.492    16.701     0.150
     0.492     9.576     0.150
     0.492    16.875     0.150
     0.492    16.641     0.150
     0.490     9.506     0.150
     0.490    17.865     0.150
     0.536     9.617     0.150
     0.536    17.266     0.150
     0.566    10.686     0.150
     0.566    18.779     0.150
     0.566    10.506     0.150
     0.566    18.885     0.150
     0.599    10.916     0.150
     0.599    19.436     0.150
     0.599    10.975     0.150
     0.599    19.529     0.150
     0.638    11.535     0.150
     0.638    20.545     0.150
     0.621    11.885     0.150
     0.674    12.049     0.150
     0.674    21.248     0.150
     0.674    11.996     0.150
     0.674    21.645     0.150
     0.674    21.361     0.150
     0.692    12.916     0.150
     0.715    12.775     0.150
     0.715    23.545     0.150
     0.715    12.826     0.150
     0.715    23.736     0.150
     0.751    23.574     0.150
     0.784    14.086     0.150
     0.784    25.055     0.150
     0.784    24.676     0.150
     0.814    25.428     0.150
     0.815    14.615     0.150
     0.815    25.477     0.150
     0.796    13.529     0.150
     0.796    24.041     0.150
     0.800    14.246     0.150
     0.800    25.814     0.150
     0.901    14.967     0.150
     0.901    28.562     0.150
     0.905    27.904     0.150
     0.902    15.658     0.150
     0.901    15.697     0.150
     0.901    28.113     0.150
     0.902    15.525     0.150
     0.902    27.570     0.150
     0.894    15.047     0.150
     0.894    26.820     0.150
     0.904    15.516     0.150
     0.904    27.455     0.150
     0.894    15.555     0.150
     0.909    15.117     0.150
     0.909    27.266     0.150
     0.909    15.150     0.150
     0.909    27.000     0.150
     0.942    15.834     0.150
     0.942    28.123     0.150
     1.034    18.555     0.150
     1.034    31.242     0.150
     1.037    17.635     0.150
     1.037    17.785     0.150
     1.039    17.656     0.150
     1.088    18.896     0.150
     1.088    33.477     0.150
     1.106    18.885     0.150
     1.106    33.107     0.150
     1.092    33.006     0.150
     1.117    19.686     0.150
     1.168    20.104     0.150
     1.168    35.002     0.150
     1.201    21.221     0.150
     1.201    36.391     0.150
     1.218    21.174     0.150
     1.218    37.172     0.150
     1.250    21.332     0.150
     1.250    37.672     0.150
     1.217    21.172     0.150
     1.217    36.922     0.150
     1.291    21.814     0.150
     1.313    22.545     0.150
     1.297    20.895     0.150
     1.412    23.721     0.150
     1.412    41.154     0.150
     1.420    23.447     0.150
     1.420    41.225     0.150
     1.398    23.775     0.150
     1.382    21.705     0.150
     1.460    24.076     0.150
     1.460    24.279     0.150
     1.460    43.131     0.150
     1.449    24.846     0.150
     1.477    24.912     0.150
     1.477    44.137     0.150
     1.526    25.225     0.150
     1.589    26.906     0.150
     1.622    27.342     0.150
     1.622    48.219     0.150
     1.699    29.350     0.150
     1.766    29.045     0.150
     1.766    51.371     0.150
     1.778    27.275     0.150
     1.841    30.750     0.150
     1.841    54.473     0.150
     1.841    29.645     0.150
     1.871    31.285     0.150
     1.871    54.105     0.150
     1.924    55.258     0.150
     1.949    33.072     0.150
     1.949    57.422     0.150
     1.961    33.262     0.150
     1.961    58.027     0.150
     1.966    32.910     0.150
     2.037    31.236     0.150
     2.087    34.486     0.150
     2.196    33.086     0.150
     2.285    65.109     0.150
     2.337    36.334     0.150
     2.337    67.383     0.150
     2.356    38.998     0.150
     2.356    63.074     0.150
     2.360    67.111     0.150
     2.521    39.367     0.150
     2.521    73.967     0.150
     2.499    42.258     0.150
     2.562    39.785     0.150
     2.708    44.195     0.150
     2.708    71.877     0.150
     2.755    42.375     0.150
     2.755    46.209     0.150
     2.755    79.553     0.150
     2.959    78.086     0.150
     3.099    47.045     0.150
     3.121    47.285     0.150
EOF
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jBL  << EOF
    60.000   140.000 P phases in red
EOF
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL  << EOF
    60.000   100.000 S phases in green
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL  << EOF
    60.000    60.000 Readings used for cluster vectors in black
EOF
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    60.000    20.000 Readings not used for cluster vectors in cyan
EOF
gmt end
