#!/bin/bash
gmt begin tofino1.52_rdp_0039 pdf,ps
proj=-JX18/12
reg=-R7/56/0/15
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases tofino1.52 Event 0039'
gmt plot $proj $reg -Wthick,black << EOF
     7.000     8.309
     8.000     7.893
     9.000     7.480
    10.000     7.066
    11.000     6.659
    12.000     6.258
    13.000     5.862
    14.000     5.473
    15.000     5.107
    16.000     4.738
    17.000     4.381
    18.000     4.040
    19.000     3.720
    20.000     3.424
    21.000     3.193
    22.000     2.974
    23.000     2.713
    24.000     2.456
    25.000     2.208
    26.000     1.989
    27.000     1.765
    28.000     1.530
    29.000     1.300
    30.000     1.122
    31.000     1.021
    32.000     1.020
    33.000     1.119
    34.000     1.291
    35.000     1.520
    36.000     1.724
    37.000     1.944
    38.000     2.170
    39.000     2.402
    40.000     2.597
    41.000     2.766
    42.000     2.858
    43.000     2.948
    44.000     3.060
    45.000     3.173
    46.000     3.318
    47.000     3.442
    48.000     3.579
    49.000     3.727
    50.000     3.881
    51.000     4.037
    52.000     4.199
    53.000     4.365
    54.000     4.534
    55.000     4.707
    56.000     4.882
EOF
gmt plot $proj $reg -Wthin,red << EOF
     7.000    30.453
     8.000    28.747
     9.000    27.040
    10.000    25.308
    11.000    23.601
    12.000    21.895
    13.000    20.187
    14.000    18.481
    15.000    16.852
    16.000    15.151
    17.000    13.473
    18.000    11.780
    19.000    10.390
    20.000     9.790
    21.000     9.437
    22.000     8.988
    23.000     8.178
    24.000     7.536
    25.000     6.787
    26.000     6.032
    27.000     5.414
    28.000     5.000
    29.000     4.514
    30.000     4.146
    31.000     3.782
    32.000     3.407
    33.000     3.163
    34.000     3.622
    35.000     4.805
    36.000     5.813
    37.000     6.828
    38.000     7.811
    39.000     8.790
    40.000     9.570
    41.000    10.189
    42.000    10.425
    43.000    10.574
    44.000    10.751
    45.000    10.900
    46.000    11.082
    47.000    11.180
    48.000    11.311
    49.000    11.526
    50.000    11.919
    51.000    12.339
    52.000    12.914
    53.000    13.586
    54.000    14.301
    55.000    15.109
    56.000    15.919
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    37.000     7.147 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    37.000     5.047
    37.000     7.047
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    37.000     7.047
    40.000     7.047
    40.000     5.047
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    37.000     7.047
    34.000     7.047
    34.000     5.047
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    32.000     0.000
    32.000     5.047
EOF
gmt plot $proj $reg -Wthick,red << EOF
    27.000     5.047
    36.000     5.047
EOF
gmt plot $proj $reg -Wthick,red << EOF
    27.000     0.000
    27.000     5.047
EOF
gmt plot $proj $reg -Wthick,red << EOF
    36.000     0.000
    36.000     5.047
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     8.000    14.100 Event 20221126.0350.17
     8.000    13.200 Depth of minimum misfit =  32 km on 15 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     8.000    12.000 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     8.000    11.400 z statistic for depth uncertainty range in red
EOF
gmt end
