#!/bin/bash
gmt begin tofino1.52_rdp_0025 pdf,ps
proj=-JX18/12
reg=-R8/61/0/13
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases tofino1.52 Event 0025'
gmt plot $proj $reg -Wthick,black << EOF
     8.000     8.796
     9.000     8.372
    10.000     7.951
    11.000     7.533
    12.000     7.119
    13.000     6.708
    14.000     6.303
    15.000     5.926
    16.000     5.536
    17.000     5.154
    18.000     4.784
    19.000     4.427
    20.000     4.083
    21.000     3.802
    22.000     3.541
    23.000     3.306
    24.000     3.104
    25.000     2.946
    26.000     2.831
    27.000     2.631
    28.000     2.328
    29.000     2.034
    30.000     1.751
    31.000     1.485
    32.000     1.249
    33.000     1.086
    34.000     0.998
    35.000     1.014
    36.000     1.091
    37.000     1.219
    38.000     1.385
    39.000     1.577
    40.000     1.786
    41.000     2.008
    42.000     2.239
    43.000     2.531
    44.000     2.776
    45.000     3.024
    46.000     3.143
    47.000     3.255
    48.000     3.378
    49.000     3.510
    50.000     3.739
    51.000     3.879
    52.000     4.039
    53.000     4.205
    54.000     4.375
    55.000     4.551
    56.000     4.731
    57.000     4.915
    58.000     5.102
    59.000     5.290
    60.000     5.482
    61.000     5.677
EOF
gmt plot $proj $reg -Wthin,red << EOF
     8.000    14.467
     9.000    13.692
    10.000    12.917
    11.000    12.142
    12.000    11.367
    13.000    10.592
    14.000     9.817
    15.000     9.086
    16.000     8.314
    17.000     7.542
    18.000     6.770
    19.000     5.998
    20.000     5.215
    21.000     4.534
    22.000     3.846
    23.000     3.450
    24.000     3.680
    25.000     3.904
    26.000     4.133
    27.000     3.942
    28.000     3.383
    29.000     2.826
    30.000     2.268
    31.000     1.709
    32.000     1.341
    33.000     1.552
    34.000     1.652
    35.000     1.754
    36.000     1.820
    37.000     1.886
    38.000     1.965
    39.000     2.408
    40.000     2.851
    41.000     3.294
    42.000     3.739
    43.000     4.320
    44.000     4.762
    45.000     5.205
    46.000     5.373
    47.000     5.500
    48.000     5.627
    49.000     5.755
    50.000     6.010
    51.000     6.081
    52.000     6.210
    53.000     6.338
    54.000     6.467
    55.000     6.596
    56.000     6.725
    57.000     7.043
    58.000     7.431
    59.000     7.816
    60.000     8.204
    61.000     8.596
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    42.000     5.392 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    42.000     3.292
    42.000     5.292
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    42.000     5.292
    45.000     5.292
    45.000     3.292
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    42.000     5.292
    39.000     5.292
    39.000     3.292
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    34.000     0.000
    34.000     3.292
EOF
gmt plot $proj $reg -Wthick,red << EOF
    28.000     3.292
    41.000     3.292
EOF
gmt plot $proj $reg -Wthick,red << EOF
    28.000     0.000
    28.000     3.292
EOF
gmt plot $proj $reg -Wthick,red << EOF
    41.000     0.000
    41.000     3.292
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     9.000    12.220 Event 20150108.0202.54
     9.000    11.440 Depth of minimum misfit =  34 km on  3 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     9.000    10.400 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     9.000     9.880 z statistic for depth uncertainty range in red
EOF
gmt end
