#!/bin/bash
gmt begin tofino1.52_rdp_0016 pdf,ps
proj=-JX18/12
reg=-R1/47/0/15
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases tofino1.52 Event 0016'
gmt plot $proj $reg -Wthick,black << EOF
     1.000     7.240
     2.000     6.915
     3.000     6.572
     4.000     6.160
     5.000     5.750
     6.000     5.343
     7.000     4.939
     8.000     4.540
     9.000     4.122
    10.000     3.705
    11.000     3.296
    12.000     2.897
    13.000     2.515
    14.000     2.157
    15.000     1.841
    16.000     1.548
    17.000     1.295
    18.000     1.106
    19.000     0.968
    20.000     0.968
    21.000     0.939
    22.000     0.891
    23.000     0.858
    24.000     0.896
    25.000     1.001
    26.000     1.164
    27.000     1.332
    28.000     1.522
    29.000     1.735
    30.000     1.969
    31.000     2.216
    32.000     2.470
    33.000     2.733
    34.000     2.999
    35.000     3.256
    36.000     3.459
    37.000     3.664
    38.000     3.868
    39.000     4.078
    40.000     4.292
    41.000     4.513
    42.000     4.744
    43.000     4.963
    44.000     5.192
    45.000     5.403
    46.000     5.618
    47.000     5.839
EOF
gmt plot $proj $reg -Wthin,red << EOF
     1.000    40.266
     2.000    38.394
     3.000    36.412
     4.000    34.020
     5.000    31.628
     6.000    29.239
     7.000    26.850
     8.000    24.460
     9.000    21.956
    10.000    19.429
    11.000    16.904
    12.000    14.378
    13.000    11.851
    14.000     9.558
    15.000     7.853
    16.000     6.168
    17.000     4.659
    18.000     3.340
    19.000     3.132
    20.000     3.787
    21.000     3.962
    22.000     3.926
    23.000     3.630
    24.000     3.699
    25.000     4.052
    26.000     4.912
    27.000     6.091
    28.000     7.217
    29.000     8.365
    30.000     9.554
    31.000    11.050
    32.000    12.565
    33.000    14.167
    34.000    15.802
    35.000    17.298
    36.000    18.481
    37.000    19.653
    38.000    20.818
    39.000    21.998
    40.000    23.202
    41.000    24.481
    42.000    25.751
    43.000    26.994
    44.000    28.335
    45.000    29.489
    46.000    30.709
    47.000    31.993
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    24.000     7.370 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    24.000     5.270
    24.000     7.270
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    24.000     7.270
    28.000     7.270
    28.000     5.270
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    24.000     7.270
    20.000     7.270
    20.000     5.270
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    23.000     0.000
    23.000     5.270
EOF
gmt plot $proj $reg -Wthick,red << EOF
    16.000     5.270
    27.000     5.270
EOF
gmt plot $proj $reg -Wthick,red << EOF
    16.000     0.000
    16.000     5.270
EOF
gmt plot $proj $reg -Wthick,red << EOF
    27.000     0.000
    27.000     5.270
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    14.100 Event 20110909.1941.33
     2.000    13.200 Depth of minimum misfit =  23 km on 32 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000    12.000 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     2.000    11.400 z statistic for depth uncertainty range in red
EOF
gmt end
