#!/bin/bash
gmt begin tofino1.52_rdp_0004 pdf,ps
proj=-JX18/12
reg=-R2/67/0/12
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases tofino1.52 Event 0004'
gmt plot $proj $reg -Wthick,black << EOF
     2.000    11.032
     3.000    10.585
     4.000    10.138
     5.000     9.691
     6.000     9.244
     7.000     8.797
     8.000     8.350
     9.000     7.903
    10.000     7.456
    11.000     7.009
    12.000     6.562
    13.000     6.115
    14.000     5.669
    15.000     5.006
    16.000     4.563
    17.000     4.119
    18.000     3.677
    19.000     3.235
    20.000     2.790
    21.000     2.403
    22.000     2.016
    23.000     1.633
    24.000     1.260
    25.000     0.914
    26.000     0.620
    27.000     0.498
    28.000     0.654
    29.000     0.960
    30.000     1.316
    31.000     1.379
    32.000     1.417
    33.000     1.523
    34.000     1.297
    35.000     1.037
    36.000     0.752
    37.000     0.604
    38.000     0.512
    39.000     0.505
    40.000     0.589
    41.000     0.732
    42.000     0.907
    43.000     1.099
    44.000     1.302
    45.000     1.510
    46.000     1.722
    47.000     1.937
    48.000     2.154
    49.000     2.373
    50.000     2.593
    51.000     2.814
    52.000     3.036
    53.000     3.259
    54.000     3.482
    55.000     3.706
    56.000     3.931
    57.000     4.156
    58.000     4.348
    59.000     4.547
    60.000     4.772
    61.000     4.997
    62.000     5.222
    63.000     5.522
    64.000     5.745
    65.000     6.055
    66.000     6.278
    67.000     6.500
EOF
gmt plot $proj $reg -Wthin,red << EOF
     2.000    15.586
     3.000    14.953
     4.000    14.320
     5.000    13.687
     6.000    13.054
     7.000    12.420
     8.000    11.787
     9.000    11.154
    10.000    10.520
    11.000     9.887
    12.000     9.253
    13.000     8.620
    14.000     7.986
    15.000     7.045
    16.000     6.414
    17.000     5.783
    18.000     5.152
    19.000     4.521
    20.000     3.883
    21.000     3.324
    22.000     2.763
    23.000     2.200
    24.000     1.637
    25.000     1.084
    26.000     0.704
    27.000     0.703
    28.000     0.703
    29.000     1.162
    30.000     1.723
    31.000     1.920
    32.000     1.998
    33.000     2.052
    34.000     1.695
    35.000     1.288
    36.000     0.798
    37.000     0.702
    38.000     0.702
    39.000     0.702
    40.000     0.701
    41.000     0.761
    42.000     1.074
    43.000     1.388
    44.000     1.702
    45.000     2.017
    46.000     2.333
    47.000     2.649
    48.000     2.965
    49.000     3.282
    50.000     3.599
    51.000     3.918
    52.000     4.236
    53.000     4.555
    54.000     4.875
    55.000     5.195
    56.000     5.516
    57.000     5.836
    58.000     6.114
    59.000     6.392
    60.000     6.713
    61.000     7.033
    62.000     7.352
    63.000     7.787
    64.000     8.103
    65.000     8.535
    66.000     8.851
    67.000     9.166
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    39.000     4.443 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    39.000     2.343
    39.000     4.343
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    39.000     4.343
    42.000     4.343
    42.000     2.343
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    39.000     4.343
    36.000     4.343
    36.000     2.343
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    27.000     0.000
    27.000     2.343
EOF
gmt plot $proj $reg -Wthick,red << EOF
    22.000     2.343
    47.000     2.343
EOF
gmt plot $proj $reg -Wthick,red << EOF
    22.000     0.000
    22.000     2.343
EOF
gmt plot $proj $reg -Wthick,red << EOF
    47.000     0.000
    47.000     2.343
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     3.000    11.280 Event 20000801.2133.50
     3.000    10.560 Depth of minimum misfit =  27 km on  2 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     3.000     9.600 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     3.000     9.120 z statistic for depth uncertainty range in red
EOF
gmt end
