#!/bin/bash
gmt begin tofino1.52_rdp_0001 pdf,ps
proj=-JX18/12
reg=-R3/60/0/15
gmt basemap $proj $reg -Bxa5f1+l'Focal Depth (km)' -Bya10f1+l'RMS Misfit' -BWeSn+t'Relative Depth Phases tofino1.52 Event 0001'
gmt plot $proj $reg -Wthick,black << EOF
     3.000     7.184
     4.000     6.873
     5.000     6.564
     6.000     6.256
     7.000     5.949
     8.000     5.648
     9.000     5.347
    10.000     5.046
    11.000     4.748
    12.000     4.453
    13.000     4.162
    14.000     3.877
    15.000     3.603
    16.000     3.335
    17.000     3.073
    18.000     2.823
    19.000     2.593
    20.000     2.357
    21.000     2.166
    22.000     1.990
    23.000     1.832
    24.000     1.680
    25.000     1.544
    26.000     1.461
    27.000     1.360
    28.000     1.209
    29.000     1.085
    30.000     1.046
    31.000     1.012
    32.000     1.027
    33.000     1.036
    34.000     1.047
    35.000     1.076
    36.000     1.144
    37.000     1.250
    38.000     1.383
    39.000     1.526
    40.000     1.684
    41.000     1.834
    42.000     1.970
    43.000     2.117
    44.000     2.259
    45.000     2.412
    46.000     2.578
    47.000     2.750
    48.000     2.925
    49.000     3.095
    50.000     3.267
    51.000     3.455
    52.000     3.654
    53.000     3.838
    54.000     4.026
    55.000     4.215
    56.000     4.407
    57.000     4.601
    58.000     4.797
    59.000     4.992
    60.000     5.190
EOF
gmt plot $proj $reg -Wthin,red << EOF
     3.000    28.647
     4.000    27.319
     5.000    25.991
     6.000    24.664
     7.000    23.336
     8.000    22.024
     9.000    20.703
    10.000    19.375
    11.000    18.047
    12.000    16.719
    13.000    15.391
    14.000    14.065
    15.000    12.756
    16.000    11.447
    17.000    10.236
    18.000     9.217
    19.000     8.158
    20.000     6.993
    21.000     6.462
    22.000     6.017
    23.000     5.362
    24.000     4.932
    25.000     4.706
    26.000     4.457
    27.000     4.176
    28.000     3.734
    29.000     3.671
    30.000     3.732
    31.000     3.565
    32.000     3.551
    33.000     3.572
    34.000     3.696
    35.000     3.834
    36.000     4.001
    37.000     4.256
    38.000     4.680
    39.000     5.009
    40.000     5.488
    41.000     6.042
    42.000     6.617
    43.000     7.273
    44.000     7.832
    45.000     8.391
    46.000     8.978
    47.000     9.541
    48.000    10.162
    49.000    10.831
    50.000    11.512
    51.000    12.268
    52.000    13.109
    53.000    13.894
    54.000    14.679
    55.000    15.461
    56.000    16.243
    57.000    17.109
    58.000    17.990
    59.000    18.867
    60.000    19.746
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,blue+a0.+jBC << EOF
    28.000     7.305 Current Depth
EOF
gmt plot $proj $reg -Wthicker,blue << EOF
    28.000     5.205
    28.000     7.205
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    28.000     7.205
    32.000     7.205
    32.000     5.205
EOF
gmt plot $proj $reg -Wthick,blue << EOF
    28.000     7.205
    24.000     7.205
    24.000     5.205
EOF
gmt plot $proj $reg -Wthicker,red << EOF
    31.000     0.000
    31.000     5.205
EOF
gmt plot $proj $reg -Wthick,red << EOF
    23.000     5.205
    40.000     5.205
EOF
gmt plot $proj $reg -Wthick,red << EOF
    23.000     0.000
    23.000     5.205
EOF
gmt plot $proj $reg -Wthick,red << EOF
    40.000     0.000
    40.000     5.205
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     4.000    14.100 Event 19900216.1328.47
     4.000    13.200 Depth of minimum misfit =  31 km on 17 samples
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
     4.000    12.000 RMS error in black
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
     4.000    11.400 z statistic for depth uncertainty range in red
EOF
gmt end
