#!/bin/bash
gmt begin tofino1.52_ot_mislocation pdf,ps
proj=-JX12/10c
reg=-R-4/5/0/19
gmt histogram $proj $reg -W0.5 -F -Gcyan -L1p -Z0 -Bxa1+l'Time (s)' -Bya10f5+l'Counts' -BWeSn+t'Origin Time Mislocation tofino1.52' << EOF
     2.922
    -0.652
    -1.184
     0.289
    -0.469
    -0.641
     0.764
     1.219
    -0.211
    -1.656
    -0.719
    -2.453
    -0.164
    -0.495
    -0.713
     1.102
    -1.766
    -0.453
     0.164
    -0.769
     0.354
     0.299
    -0.742
    -1.984
     0.660
    -0.430
    -0.535
    -0.203
    -1.875
     0.012
    -0.527
    -1.188
    -0.363
    -0.375
    -0.730
     0.121
    -0.406
    -0.152
     1.030
    -0.672
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -0.441    16.997 Median =  -0.4 s
EOF
# Median OT mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -0.4  0.
 -0.4  16.7
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
    -3.800    18.003 Author: all (  40 samples)
EOF
gmt end
