#!/bin/bash
gmt begin tofino1.52_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-25/25/-25/25
gmt basemap $proj $reg -Bxa10f5+l'km' -Bya10f5+l'km' -BWeSn+t'Epicentral Mislocation tofino1.52'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     9.403     9.403
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.421    12.101
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    14.421    12.101 1
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.725     5.434
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    16.725     5.434 2
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.932     6.788
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.662     0.822
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.750     3.277
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.419    -1.150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.467    12.564
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.467    12.564 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.195    20.295
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.195    20.295 8
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.212     6.423
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.551    -3.956
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.438    -1.341
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.974    -6.984
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.974    -6.984 12
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.594    -1.546
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.557    -1.617
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.108    -3.446
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.161     1.919
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.450     7.459
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.494     1.983
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.246     4.213
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.088    -5.570
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.768    -0.040
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.644     1.116
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.802     9.064
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.802     9.064 23
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.702    -2.502
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.753    -2.624
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.381    -0.121
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.979    -0.851
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.938    -0.305
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.734    -8.734
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.734    -8.734 29
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.838    -1.573
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.448    -3.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.408    -1.781
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.156     1.777
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.382     0.420
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.396     2.246
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.570     0.806
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.024    -1.395
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.899     4.265
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.318    -0.465
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.243     2.778
EOF
gmt plot $proj $reg -SE -Gred << EOF
     1.232     1.419     0.000     1.500     1.500
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -23.500    23.500 Author: all (  40 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -23.500   -23.500 Average =   1.9 km at  41.0 deg; median =    4.7 km
EOF
gmt end
