#!/bin/bash
gmt begin tofino1.52_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-25/9/0/10
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depth Mislocation tofino1.52' << EOF
    -3.000
   -19.000
   -18.500
    -6.300
     0.100
     1.900
   -10.700
    -8.200
     4.200
    -0.400
    -2.500
     0.900
    -2.400
     1.700
    -6.600
    -8.600
   -19.700
    -3.600
    -0.000
     0.200
    -3.200
    -3.600
   -11.400
    -2.500
    -7.600
     0.100
     1.400
    -1.500
   -17.000
    -2.200
    -6.100
     1.800
    -1.800
    -3.500
     1.500
    -5.000
     1.800
     2.400
    -5.500
     2.100
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -2.500     7.525 Median =  -2.5 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -2.5  0.
 -2.5   7.3
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -24.000     9.475 Author: all (  40 samples)
EOF
gmt end
