#!/bin/bash
gmt begin tofino1.52_depth_histogram pdf,ps
proj=-JX12/10
reg=-R8/52/0/8
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa25f5+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depths tofino1.52' << EOF
    28.000
    29.000
    22.000
    39.000
    32.000
    32.000
    16.000
    15.000
    19.000
    24.000
    30.000
    27.000
    47.000
    40.000
    38.000
    24.000
    22.000
    27.000
    28.000
    13.000
    18.000
    18.000
    15.000
    28.000
    42.000
    19.000
    40.000
    41.000
    27.000
    36.000
    42.000
    32.000
    36.000
    30.000
    29.000
    24.000
    34.000
    41.000
    37.000
    29.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
     9.000     7.520 Median of constrained depths =  29.0
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
     9.000     7.040 Spread of constrained depths =   9.5
EOF
gmt end
