#!/bin/bash
gmt begin tofino1.52_dcal pdf,ps
proj=-JM16.0c+
reg=-R-130.7/-121.8/45.9/51.4
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration tofino1.52'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
  -126.538    49.376
  -127.884    49.030
>
  -127.120    49.874
  -127.884    49.030
>
  -127.120    49.874
  -127.884    49.030
>
  -126.538    49.376
  -127.626    49.274
>
  -127.120    49.874
  -127.626    49.274
>
  -127.771    50.157
  -127.626    49.274
>
  -125.521    49.468
  -125.894    48.668
>
  -125.521    49.468
  -125.894    48.668
>
  -124.692    49.000
  -125.894    48.668
>
  -124.692    49.000
  -125.894    48.668
>
  -126.538    49.376
  -125.894    48.668
>
  -124.830    49.272
  -125.894    48.668
>
  -124.830    49.272
  -125.894    48.668
>
  -126.032    49.781
  -126.148    49.489
>
  -126.032    49.781
  -126.148    49.489
>
  -126.538    49.376
  -126.148    49.489
>
  -126.538    49.376
  -126.148    49.489
>
  -125.521    49.468
  -126.148    49.489
>
  -125.521    49.468
  -126.148    49.489
>
  -125.493    48.960
  -126.148    49.489
>
  -125.365    50.033
  -126.148    49.489
>
  -125.365    50.033
  -126.148    49.489
>
  -126.570    50.161
  -126.148    49.489
>
  -126.570    50.161
  -126.148    49.489
>
  -127.120    49.874
  -126.148    49.489
>
  -127.120    49.874
  -126.148    49.489
>
  -124.830    49.272
  -126.148    49.489
>
  -124.830    49.272
  -126.148    49.489
>
  -126.055    50.403
  -126.148    49.489
>
  -126.055    50.403
  -126.148    49.489
>
  -124.440    48.572
  -124.773    48.660
>
  -124.440    48.572
  -124.773    48.660
>
  -124.692    49.000
  -124.773    48.660
>
  -124.692    49.000
  -124.773    48.660
>
  -124.830    49.272
  -124.773    48.660
>
  -124.830    49.272
  -124.773    48.660
>
  -123.824    48.612
  -124.773    48.660
>
  -123.824    48.612
  -124.773    48.660
>
  -124.004    49.222
  -124.773    48.660
>
  -124.004    49.222
  -124.773    48.660
>
  -124.078    48.035
  -124.773    48.660
>
  -123.510    48.949
  -124.773    48.660
>
  -123.510    48.949
  -124.773    48.660
>
  -123.451    48.650
  -124.773    48.660
>
  -123.451    48.650
  -124.773    48.660
>
  -123.670    48.150
  -124.773    48.660
>
  -125.521    49.468
  -124.773    48.660
>
  -125.521    49.468
  -124.773    48.660
>
  -123.324    48.414
  -124.773    48.660
>
  -123.324    48.414
  -124.773    48.660
>
  -124.178    47.749
  -124.773    48.660
>
  -125.493    48.960
  -125.820    49.062
>
  -125.493    48.960
  -125.820    49.062
>
  -125.521    49.468
  -125.820    49.062
>
  -125.521    49.468
  -125.820    49.062
>
  -124.830    49.272
  -125.820    49.062
>
  -124.830    49.272
  -125.820    49.062
>
  -124.692    49.000
  -125.820    49.062
>
  -124.692    49.000
  -125.820    49.062
>
  -126.032    49.781
  -125.820    49.062
>
  -126.032    49.781
  -125.820    49.062
>
  -127.120    49.874
  -127.800    49.219
>
  -127.120    49.874
  -127.800    49.219
>
  -126.538    49.376
  -127.800    49.219
>
  -127.771    50.157
  -127.800    49.219
>
  -127.771    50.157
  -127.800    49.219
>
  -127.120    49.874
  -127.828    49.221
>
  -126.538    49.376
  -127.828    49.221
>
  -127.771    50.157
  -127.828    49.221
>
  -127.771    50.157
  -127.828    49.221
>
  -127.120    49.874
  -127.307    49.441
>
  -127.120    49.874
  -127.307    49.441
>
  -126.538    49.376
  -127.307    49.441
>
  -126.538    49.376
  -127.307    49.441
>
  -126.570    50.161
  -127.307    49.441
>
  -126.570    50.161
  -127.307    49.441
>
  -126.032    49.781
  -127.307    49.441
>
  -126.032    49.781
  -127.307    49.441
>
  -127.172    50.403
  -127.307    49.441
>
  -127.172    50.403
  -127.307    49.441
>
  -127.120    49.874
  -127.227    49.502
>
  -127.120    49.874
  -127.227    49.502
>
  -126.538    49.376
  -127.227    49.502
>
  -126.538    49.376
  -127.227    49.502
>
  -127.771    50.157
  -127.227    49.502
>
  -126.570    50.161
  -127.227    49.502
>
  -126.570    50.161
  -127.227    49.502
>
  -126.032    49.781
  -127.227    49.502
>
  -126.032    49.781
  -127.227    49.502
>
  -127.172    50.403
  -127.227    49.502
>
  -125.493    48.960
  -125.675    48.664
>
  -125.493    48.960
  -125.675    48.664
>
  -125.493    48.960
  -125.675    48.664
>
  -124.692    49.000
  -125.675    48.664
>
  -124.692    49.000
  -125.675    48.664
>
  -125.521    49.468
  -125.675    48.664
>
  -125.521    49.468
  -125.675    48.664
>
  -124.440    48.572
  -125.675    48.664
>
  -124.440    48.572
  -125.675    48.664
>
  -124.830    49.272
  -125.675    48.664
>
  -124.830    49.272
  -125.675    48.664
>
  -126.538    49.376
  -125.675    48.664
>
  -127.120    49.874
  -127.480    49.429
>
  -127.120    49.874
  -127.480    49.429
>
  -126.538    49.376
  -127.480    49.429
>
  -126.538    49.376
  -127.480    49.429
>
  -127.771    50.157
  -127.480    49.429
>
  -127.771    50.157
  -127.480    49.429
>
  -127.172    50.403
  -127.480    49.429
>
  -127.172    50.403
  -127.480    49.429
>
  -125.521    49.468
  -125.450    49.371
>
  -125.521    49.468
  -125.450    49.371
>
  -125.908    49.154
  -125.450    49.371
>
  -125.908    49.154
  -125.450    49.371
>
  -125.493    48.960
  -125.450    49.371
>
  -125.493    48.960
  -125.450    49.371
>
  -124.830    49.272
  -125.450    49.371
>
  -124.811    49.219
  -125.450    49.371
>
  -124.811    49.219
  -125.450    49.371
>
  -125.542    48.925
  -125.450    49.371
>
  -125.542    48.925
  -125.450    49.371
>
  -125.653    49.892
  -125.450    49.371
>
  -125.653    49.892
  -125.450    49.371
>
  -125.134    48.834
  -125.450    49.371
>
  -125.134    48.834
  -125.450    49.371
>
  -126.032    49.781
  -125.450    49.371
>
  -126.032    49.781
  -125.450    49.371
>
  -124.692    49.000
  -125.450    49.371
>
  -124.692    49.000
  -125.450    49.371
>
  -125.365    50.033
  -125.450    49.371
>
  -125.365    50.033
  -125.450    49.371
>
  -126.538    49.376
  -125.450    49.371
>
  -124.436    49.697
  -125.450    49.371
>
  -124.436    49.697
  -125.450    49.371
>
  -124.236    49.306
  -125.450    49.371
>
  -124.236    49.306
  -125.450    49.371
>
  -124.262    48.901
  -125.450    49.371
>
  -123.988    49.227
  -125.450    49.371
>
  -123.988    49.227
  -125.450    49.371
>
  -125.493    48.960
  -125.330    49.174
>
  -125.493    48.960
  -125.330    49.174
>
  -125.542    48.925
  -125.330    49.174
>
  -125.542    48.925
  -125.330    49.174
>
  -125.521    49.468
  -125.330    49.174
>
  -125.521    49.468
  -125.330    49.174
>
  -124.811    49.219
  -125.330    49.174
>
  -124.811    49.219
  -125.330    49.174
>
  -124.830    49.272
  -125.330    49.174
>
  -124.830    49.272
  -125.330    49.174
>
  -125.134    48.834
  -125.330    49.174
>
  -125.134    48.834
  -125.330    49.174
>
  -125.908    49.154
  -125.330    49.174
>
  -125.908    49.154
  -125.330    49.174
>
  -124.692    49.000
  -125.330    49.174
>
  -124.692    49.000
  -125.330    49.174
>
  -125.303    49.741
  -125.330    49.174
>
  -125.303    49.741
  -125.330    49.174
>
  -124.236    49.306
  -125.330    49.174
>
  -124.236    49.306
  -125.330    49.174
>
  -124.262    48.901
  -125.330    49.174
>
  -124.262    48.901
  -125.330    49.174
>
  -125.653    49.892
  -125.330    49.174
>
  -125.653    49.892
  -125.330    49.174
>
  -126.032    49.781
  -125.330    49.174
>
  -126.032    49.781
  -125.330    49.174
>
  -124.436    49.697
  -125.330    49.174
>
  -124.440    48.572
  -125.330    49.174
>
  -124.440    48.572
  -125.330    49.174
>
  -124.131    48.820
  -125.330    49.174
>
  -124.131    48.820
  -125.330    49.174
>
  -125.365    50.033
  -125.330    49.174
>
  -125.365    50.033
  -125.330    49.174
>
  -123.988    49.227
  -125.330    49.174
>
  -123.988    49.227
  -125.330    49.174
>
  -124.625    48.298
  -125.330    49.174
>
  -124.625    48.298
  -125.330    49.174
>
  -126.538    49.376
  -126.023    49.503
>
  -126.032    49.781
  -126.023    49.503
>
  -125.908    49.154
  -126.023    49.503
>
  -125.908    49.154
  -126.023    49.503
>
  -125.521    49.468
  -126.023    49.503
>
  -125.521    49.468
  -126.023    49.503
>
  -125.653    49.892
  -126.023    49.503
>
  -125.653    49.892
  -126.023    49.503
>
  -125.303    49.741
  -126.023    49.503
>
  -125.303    49.741
  -126.023    49.503
>
  -125.493    48.960
  -126.023    49.503
>
  -125.493    48.960
  -126.023    49.503
>
  -125.542    48.925
  -126.023    49.503
>
  -125.542    48.925
  -126.023    49.503
>
  -125.365    50.033
  -126.023    49.503
>
  -125.365    50.033
  -126.023    49.503
>
  -126.570    50.161
  -126.023    49.503
>
  -126.570    50.161
  -126.023    49.503
>
  -127.120    49.874
  -126.023    49.503
>
  -127.120    49.874
  -126.023    49.503
>
  -124.830    49.272
  -126.023    49.503
>
  -124.830    49.272
  -126.023    49.503
>
  -124.811    49.219
  -126.023    49.503
>
  -124.811    49.219
  -126.023    49.503
>
  -124.811    49.219
  -126.023    49.503
>
  -125.135    48.836
  -126.023    49.503
>
  -125.135    48.836
  -126.023    49.503
>
  -125.134    48.834
  -126.023    49.503
>
  -125.134    48.834
  -126.023    49.503
>
  -126.055    50.403
  -126.023    49.503
>
  -126.055    50.403
  -126.023    49.503
>
  -126.849    48.671
  -126.023    49.503
>
  -126.849    48.671
  -126.023    49.503
>
  -126.538    49.376
  -127.163    49.371
>
  -126.538    49.376
  -127.163    49.371
>
  -127.120    49.874
  -127.163    49.371
>
  -126.849    48.671
  -127.163    49.371
>
  -126.032    49.781
  -127.163    49.371
>
  -126.032    49.781
  -127.163    49.371
>
  -125.908    49.154
  -127.163    49.371
>
  -126.570    50.161
  -127.163    49.371
>
  -127.771    50.157
  -127.163    49.371
>
  -126.538    49.376
  -127.225    49.324
>
  -127.120    49.874
  -127.225    49.324
>
  -127.120    49.874
  -127.225    49.324
>
  -127.771    50.157
  -127.225    49.324
>
  -126.032    49.781
  -127.225    49.324
>
  -126.570    50.161
  -127.225    49.324
>
  -125.908    49.154
  -127.225    49.324
>
  -126.538    49.376
  -127.138    49.381
>
  -126.538    49.376
  -127.138    49.381
>
  -127.120    49.874
  -127.138    49.381
>
  -127.120    49.874
  -127.138    49.381
>
  -126.849    48.671
  -127.138    49.381
>
  -126.849    48.671
  -127.138    49.381
>
  -126.032    49.781
  -127.138    49.381
>
  -126.032    49.781
  -127.138    49.381
>
  -126.570    50.161
  -127.138    49.381
>
  -126.570    50.161
  -127.138    49.381
>
  -125.908    49.154
  -127.138    49.381
>
  -125.908    49.154
  -127.138    49.381
>
  -127.771    50.157
  -127.138    49.381
>
  -126.538    49.376
  -127.155    49.356
>
  -126.538    49.376
  -127.155    49.356
>
  -127.120    49.874
  -127.155    49.356
>
  -127.120    49.874
  -127.155    49.356
>
  -126.032    49.781
  -127.155    49.356
>
  -126.032    49.781
  -127.155    49.356
>
  -125.908    49.154
  -127.155    49.356
>
  -126.570    50.161
  -127.155    49.356
>
  -126.570    50.161
  -127.155    49.356
>
  -127.771    50.157
  -127.155    49.356
>
  -124.440    48.572
  -124.887    48.227
>
  -124.440    48.572
  -124.887    48.227
>
  -125.134    48.834
  -124.887    48.227
>
  -125.134    48.834
  -124.887    48.227
>
  -124.131    48.820
  -124.887    48.227
>
  -124.692    49.000
  -124.887    48.227
>
  -124.692    49.000
  -124.887    48.227
>
  -124.262    48.901
  -124.887    48.227
>
  -123.824    48.612
  -124.887    48.227
>
  -126.175    48.428
  -124.887    48.227
>
  -124.811    49.219
  -124.887    48.227
>
  -124.811    49.219
  -124.887    48.227
>
  -125.493    48.960
  -125.598    49.072
>
  -125.493    48.960
  -125.598    49.072
>
  -125.542    48.925
  -125.598    49.072
>
  -125.542    48.925
  -125.598    49.072
>
  -125.908    49.154
  -125.598    49.072
>
  -125.908    49.154
  -125.598    49.072
>
  -125.134    48.834
  -125.598    49.072
>
  -125.134    48.834
  -125.598    49.072
>
  -125.521    49.468
  -125.598    49.072
>
  -125.521    49.468
  -125.598    49.072
>
  -124.811    49.219
  -125.598    49.072
>
  -124.811    49.219
  -125.598    49.072
>
  -124.692    49.000
  -125.598    49.072
>
  -124.692    49.000
  -125.598    49.072
>
  -126.538    49.376
  -125.598    49.072
>
  -125.303    49.741
  -125.598    49.072
>
  -125.303    49.741
  -125.598    49.072
>
  -126.175    48.428
  -125.598    49.072
>
  -125.653    49.892
  -125.598    49.072
>
  -125.653    49.892
  -125.598    49.072
>
  -126.617    49.592
  -125.598    49.072
>
  -126.617    49.592
  -125.598    49.072
>
  -124.262    48.901
  -125.598    49.072
>
  -124.262    48.901
  -125.598    49.072
>
  -124.440    48.572
  -125.598    49.072
>
  -124.440    48.572
  -125.598    49.072
>
  -124.236    49.306
  -125.598    49.072
>
  -124.236    49.306
  -125.598    49.072
>
  -126.849    48.671
  -125.598    49.072
>
  -125.365    50.033
  -125.598    49.072
>
  -125.365    50.033
  -125.598    49.072
>
  -124.436    49.697
  -125.598    49.072
>
  -124.131    48.820
  -125.598    49.072
>
  -124.131    48.820
  -125.598    49.072
>
  -125.493    48.960
  -125.600    49.064
>
  -125.493    48.960
  -125.600    49.064
>
  -125.542    48.925
  -125.600    49.064
>
  -125.542    48.925
  -125.600    49.064
>
  -125.908    49.154
  -125.600    49.064
>
  -125.134    48.834
  -125.600    49.064
>
  -125.134    48.834
  -125.600    49.064
>
  -125.521    49.468
  -125.600    49.064
>
  -125.521    49.468
  -125.600    49.064
>
  -124.811    49.219
  -125.600    49.064
>
  -124.811    49.219
  -125.600    49.064
>
  -124.692    49.000
  -125.600    49.064
>
  -124.692    49.000
  -125.600    49.064
>
  -126.538    49.376
  -125.600    49.064
>
  -125.303    49.741
  -125.600    49.064
>
  -125.303    49.741
  -125.600    49.064
>
  -126.175    48.428
  -125.600    49.064
>
  -126.175    48.428
  -125.600    49.064
>
  -125.653    49.892
  -125.600    49.064
>
  -125.653    49.892
  -125.600    49.064
>
  -126.617    49.592
  -125.600    49.064
>
  -126.617    49.592
  -125.600    49.064
>
  -124.262    48.901
  -125.600    49.064
>
  -124.262    48.901
  -125.600    49.064
>
  -124.440    48.572
  -125.600    49.064
>
  -124.440    48.572
  -125.600    49.064
>
  -124.236    49.306
  -125.600    49.064
>
  -124.236    49.306
  -125.600    49.064
>
  -126.849    48.671
  -125.600    49.064
>
  -125.365    50.033
  -125.600    49.064
>
  -125.365    50.033
  -125.600    49.064
>
  -124.436    49.697
  -125.600    49.064
>
  -124.436    49.697
  -125.600    49.064
>
  -124.131    48.820
  -125.600    49.064
>
  -124.131    48.820
  -125.600    49.064
>
  -126.849    48.671
  -127.789    49.095
>
  -126.849    48.671
  -127.789    49.095
>
  -126.538    49.376
  -127.789    49.095
>
  -126.538    49.376
  -127.789    49.095
>
  -127.120    49.874
  -127.789    49.095
>
  -127.120    49.874
  -127.789    49.095
>
  -127.120    49.874
  -127.588    49.513
>
  -127.120    49.874
  -127.588    49.513
>
  -127.771    50.157
  -127.588    49.513
>
  -126.617    49.592
  -127.588    49.513
>
  -126.617    49.592
  -127.588    49.513
>
  -126.538    49.376
  -127.588    49.513
>
  -127.492    50.436
  -127.588    49.513
>
  -127.172    50.403
  -127.588    49.513
>
  -127.172    50.403
  -127.588    49.513
>
  -125.908    49.154
  -125.727    49.183
>
  -125.908    49.154
  -125.727    49.183
>
  -125.493    48.960
  -125.727    49.183
>
  -125.493    48.960
  -125.727    49.183
>
  -125.542    48.925
  -125.727    49.183
>
  -125.542    48.925
  -125.727    49.183
>
  -125.521    49.468
  -125.727    49.183
>
  -125.521    49.468
  -125.727    49.183
>
  -125.136    48.834
  -125.727    49.183
>
  -125.136    48.834
  -125.727    49.183
>
  -126.538    49.376
  -125.727    49.183
>
  -124.811    49.219
  -125.727    49.183
>
  -124.811    49.219
  -125.727    49.183
>
  -126.032    49.781
  -125.727    49.183
>
  -124.692    49.000
  -125.727    49.183
>
  -126.175    48.428
  -125.727    49.183
>
  -126.175    48.428
  -125.727    49.183
>
  -125.365    50.033
  -125.727    49.183
>
  -125.365    50.033
  -125.727    49.183
>
  -124.236    49.306
  -125.727    49.183
>
  -124.236    49.306
  -125.727    49.183
>
  -124.436    49.697
  -125.727    49.183
>
  -124.566    47.947
  -124.680    47.769
>
  -124.566    47.947
  -124.680    47.769
>
  -124.344    48.083
  -124.680    47.769
>
  -124.141    48.062
  -124.680    47.769
>
  -124.141    48.062
  -124.680    47.769
>
  -124.078    48.035
  -124.680    47.769
>
  -124.625    48.298
  -124.680    47.769
>
  -123.809    47.516
  -124.680    47.769
>
  -123.809    47.516
  -124.680    47.769
>
  -123.869    47.392
  -124.680    47.769
>
  -123.670    48.150
  -124.680    47.769
>
  -123.670    48.150
  -124.680    47.769
>
  -123.670    48.150
  -124.680    47.769
>
  -123.504    48.058
  -124.680    47.769
>
  -123.504    48.058
  -124.680    47.769
>
  -123.770    47.117
  -124.680    47.769
>
  -123.673    48.395
  -124.680    47.769
>
  -123.673    48.395
  -124.680    47.769
>
  -125.908    49.154
  -126.011    49.362
>
  -125.908    49.154
  -126.011    49.362
>
  -125.521    49.468
  -126.011    49.362
>
  -125.521    49.468
  -126.011    49.362
>
  -126.538    49.376
  -126.011    49.362
>
  -126.538    49.376
  -126.011    49.362
>
  -126.032    49.781
  -126.011    49.362
>
  -126.032    49.781
  -126.011    49.362
>
  -125.493    48.960
  -126.011    49.362
>
  -125.493    48.960
  -126.011    49.362
>
  -125.542    48.925
  -126.011    49.362
>
  -125.542    48.925
  -126.011    49.362
>
  -125.136    48.834
  -126.011    49.362
>
  -125.134    48.834
  -126.011    49.362
>
  -125.134    48.834
  -126.011    49.362
>
  -124.811    49.219
  -126.011    49.362
>
  -124.811    49.219
  -126.011    49.362
>
  -125.365    50.033
  -126.011    49.362
>
  -125.365    50.033
  -126.011    49.362
>
  -126.849    48.671
  -126.011    49.362
>
  -126.570    50.161
  -126.011    49.362
>
  -126.570    50.161
  -126.011    49.362
>
  -127.120    49.874
  -126.011    49.362
>
  -127.120    49.874
  -126.011    49.362
>
  -124.692    49.000
  -126.011    49.362
>
  -124.692    49.000
  -126.011    49.362
>
  -127.119    50.054
  -126.011    49.362
>
  -125.493    48.960
  -125.268    49.101
>
  -125.493    48.960
  -125.268    49.101
>
  -125.542    48.925
  -125.268    49.101
>
  -125.542    48.925
  -125.268    49.101
>
  -125.134    48.834
  -125.268    49.101
>
  -125.134    48.834
  -125.268    49.101
>
  -125.136    48.834
  -125.268    49.101
>
  -125.136    48.834
  -125.268    49.101
>
  -124.811    49.219
  -125.268    49.101
>
  -124.811    49.219
  -125.268    49.101
>
  -124.692    49.000
  -125.268    49.101
>
  -124.692    49.000
  -125.268    49.101
>
  -125.521    49.468
  -125.268    49.101
>
  -125.521    49.468
  -125.268    49.101
>
  -125.908    49.154
  -125.268    49.101
>
  -125.908    49.154
  -125.268    49.101
>
  -125.303    49.741
  -125.268    49.101
>
  -125.303    49.741
  -125.268    49.101
>
  -124.236    49.306
  -125.268    49.101
>
  -124.236    49.306
  -125.268    49.101
>
  -124.440    48.572
  -125.268    49.101
>
  -124.440    48.572
  -125.268    49.101
>
  -124.131    48.820
  -125.268    49.101
>
  -124.131    48.820
  -125.268    49.101
>
  -124.131    48.820
  -125.268    49.101
>
  -124.131    48.820
  -125.268    49.101
>
  -124.436    49.697
  -125.268    49.101
>
  -124.436    49.697
  -125.268    49.101
>
  -125.653    49.892
  -125.268    49.101
>
  -125.653    49.892
  -125.268    49.101
>
  -123.988    49.227
  -125.268    49.101
>
  -123.988    49.227
  -125.268    49.101
>
  -126.032    49.781
  -125.268    49.101
>
  -126.032    49.781
  -125.268    49.101
>
  -126.538    49.376
  -125.268    49.101
>
  -124.625    48.298
  -125.268    49.101
>
  -126.175    48.428
  -125.268    49.101
>
  -125.365    50.033
  -125.268    49.101
>
  -125.365    50.033
  -125.268    49.101
>
  -126.849    48.671
  -126.522    48.857
>
  -126.849    48.671
  -126.522    48.857
>
  -126.175    48.428
  -126.522    48.857
>
  -126.175    48.428
  -126.522    48.857
>
  -126.175    48.428
  -126.522    48.857
>
  -126.538    49.376
  -126.522    48.857
>
  -126.538    49.376
  -126.522    48.857
>
  -126.538    49.376
  -126.522    48.857
>
  -125.542    48.925
  -126.522    48.857
>
  -125.542    48.925
  -126.522    48.857
>
  -125.493    48.960
  -126.522    48.857
>
  -125.493    48.960
  -126.522    48.857
>
  -125.493    48.960
  -126.522    48.857
>
  -125.136    48.834
  -126.522    48.857
>
  -125.134    48.834
  -126.522    48.857
>
  -125.134    48.834
  -126.522    48.857
>
  -126.032    49.781
  -126.522    48.857
>
  -125.493    48.960
  -125.521    48.990
>
  -125.493    48.960
  -125.521    48.990
>
  -125.493    48.960
  -125.521    48.990
>
  -125.542    48.925
  -125.521    48.990
>
  -125.542    48.925
  -125.521    48.990
>
  -125.908    49.154
  -125.521    48.990
>
  -125.908    49.154
  -125.521    48.990
>
  -125.136    48.834
  -125.521    48.990
>
  -125.136    48.834
  -125.521    48.990
>
  -125.134    48.834
  -125.521    48.990
>
  -125.134    48.834
  -125.521    48.990
>
  -124.811    49.219
  -125.521    48.990
>
  -124.811    49.219
  -125.521    48.990
>
  -126.175    48.428
  -125.521    48.990
>
  -126.175    48.428
  -125.521    48.990
>
  -126.538    49.376
  -125.521    48.990
>
  -124.440    48.572
  -125.521    48.990
>
  -124.440    48.572
  -125.521    48.990
>
  -126.032    49.781
  -125.521    48.990
>
  -126.032    49.781
  -125.521    48.990
>
  -124.413    48.544
  -125.521    48.990
>
  -124.413    48.544
  -125.521    48.990
>
  -124.625    48.298
  -125.521    48.990
>
  -124.131    48.820
  -125.521    48.990
>
  -124.131    48.820
  -125.521    48.990
>
  -124.131    48.820
  -125.521    48.990
>
  -124.131    48.820
  -125.521    48.990
>
  -124.131    48.820
  -125.521    48.990
>
  -125.493    48.960
  -125.423    49.255
>
  -125.493    48.960
  -125.423    49.255
>
  -125.542    48.925
  -125.423    49.255
>
  -125.542    48.925
  -125.423    49.255
>
  -124.811    49.219
  -125.423    49.255
>
  -125.134    48.834
  -125.423    49.255
>
  -125.134    48.834
  -125.423    49.255
>
  -125.134    48.834
  -125.423    49.255
>
  -125.136    48.834
  -125.423    49.255
>
  -125.136    48.834
  -125.423    49.255
>
  -126.032    49.781
  -125.423    49.255
>
  -126.032    49.781
  -125.423    49.255
>
  -125.653    49.892
  -125.423    49.255
>
  -125.653    49.892
  -125.423    49.255
>
  -126.538    49.376
  -125.423    49.255
>
  -126.538    49.376
  -125.423    49.255
>
  -125.365    50.033
  -125.423    49.255
>
  -125.365    50.033
  -125.423    49.255
>
  -126.175    48.428
  -125.423    49.255
>
  -126.175    48.428
  -125.423    49.255
>
  -126.175    48.428
  -125.423    49.255
>
  -124.440    48.572
  -125.423    49.255
>
  -124.440    48.572
  -125.423    49.255
>
  -124.131    48.820
  -125.423    49.255
>
  -124.131    48.820
  -125.423    49.255
>
  -123.988    49.227
  -125.423    49.255
>
  -123.988    49.227
  -125.423    49.255
>
  -124.413    48.544
  -125.423    49.255
>
  -126.175    48.428
  -125.995    48.658
>
  -126.175    48.428
  -125.995    48.658
>
  -125.542    48.925
  -125.995    48.658
>
  -125.542    48.925
  -125.995    48.658
>
  -125.493    48.960
  -125.995    48.658
>
  -125.493    48.960
  -125.995    48.658
>
  -125.908    49.154
  -125.995    48.658
>
  -125.908    49.154
  -125.995    48.658
>
  -126.849    48.671
  -125.995    48.658
>
  -126.849    48.671
  -125.995    48.658
>
  -125.136    48.834
  -125.995    48.658
>
  -125.136    48.834
  -125.995    48.658
>
  -125.134    48.834
  -125.995    48.658
>
  -125.134    48.834
  -125.995    48.658
>
  -126.538    49.376
  -125.995    48.658
>
  -124.811    49.219
  -125.995    48.658
>
  -124.811    49.219
  -125.995    48.658
>
  -124.625    48.298
  -125.995    48.658
>
  -124.625    48.298
  -124.667    48.369
>
  -124.625    48.298
  -124.667    48.369
>
  -124.413    48.544
  -124.667    48.369
>
  -124.413    48.544
  -124.667    48.369
>
  -124.413    48.544
  -124.667    48.369
>
  -124.440    48.572
  -124.667    48.369
>
  -124.440    48.572
  -124.667    48.369
>
  -124.344    48.083
  -124.667    48.369
>
  -124.566    47.947
  -124.667    48.369
>
  -124.141    48.062
  -124.667    48.369
>
  -124.078    48.035
  -124.667    48.369
>
  -125.134    48.834
  -124.667    48.369
>
  -125.134    48.834
  -124.667    48.369
>
  -125.134    48.834
  -124.667    48.369
>
  -125.136    48.834
  -124.667    48.369
>
  -125.136    48.834
  -124.667    48.369
>
  -125.136    48.834
  -124.667    48.369
>
  -124.131    48.820
  -124.667    48.369
>
  -124.131    48.820
  -124.667    48.369
>
  -124.131    48.820
  -124.667    48.369
>
  -124.131    48.820
  -124.667    48.369
>
  -124.131    48.820
  -124.667    48.369
>
  -124.131    48.820
  -124.667    48.369
>
  -124.131    48.820
  -124.667    48.369
>
  -123.799    48.559
  -124.667    48.369
>
  -123.799    48.559
  -124.667    48.369
>
  -123.670    48.150
  -124.667    48.369
>
  -123.670    48.150
  -124.667    48.369
>
  -123.670    48.150
  -124.667    48.369
>
  -125.493    48.960
  -124.667    48.369
>
  -125.493    48.960
  -124.667    48.369
>
  -125.493    48.960
  -124.667    48.369
>
  -124.811    49.219
  -124.667    48.369
>
  -124.811    49.219
  -124.667    48.369
>
  -124.811    49.219
  -124.667    48.369
>
  -123.504    48.058
  -124.667    48.369
>
  -123.504    48.058
  -124.667    48.369
>
  -123.504    48.058
  -124.667    48.369
>
  -123.451    48.649
  -124.667    48.369
>
  -123.451    48.649
  -124.667    48.369
>
  -123.451    48.650
  -124.667    48.369
>
  -123.451    48.650
  -124.667    48.369
>
  -123.451    48.650
  -124.667    48.369
>
  -123.451    48.650
  -124.667    48.369
>
  -123.447    48.653
  -124.667    48.369
>
  -123.702    47.821
  -124.667    48.369
>
  -123.324    48.414
  -124.667    48.369
>
  -123.324    48.414
  -124.667    48.369
>
  -123.324    48.414
  -124.667    48.369
>
  -123.510    48.949
  -124.667    48.369
>
  -123.510    48.949
  -124.667    48.369
>
  -123.988    49.227
  -124.667    48.369
>
  -123.988    49.227
  -124.667    48.369
>
  -125.134    48.834
  -125.186    48.560
>
  -125.134    48.834
  -125.186    48.560
>
  -125.134    48.834
  -125.186    48.560
>
  -125.136    48.834
  -125.186    48.560
>
  -125.136    48.834
  -125.186    48.560
>
  -125.136    48.834
  -125.186    48.560
>
  -124.625    48.298
  -125.186    48.560
>
  -124.625    48.298
  -125.186    48.560
>
  -125.542    48.925
  -125.186    48.560
>
  -125.542    48.925
  -125.186    48.560
>
  -125.542    48.925
  -125.186    48.560
>
  -124.413    48.544
  -125.186    48.560
>
  -124.413    48.544
  -125.186    48.560
>
  -124.811    49.219
  -125.186    48.560
>
  -124.811    49.219
  -125.186    48.560
>
  -124.811    49.219
  -125.186    48.560
>
  -124.811    49.219
  -125.186    48.560
>
  -126.175    48.428
  -125.186    48.560
>
  -126.175    48.428
  -125.186    48.560
>
  -126.175    48.428
  -125.186    48.560
>
  -124.811    49.219
  -125.186    48.560
>
  -124.811    49.219
  -125.186    48.560
>
  -124.131    48.820
  -125.186    48.560
>
  -124.131    48.820
  -125.186    48.560
>
  -124.131    48.820
  -125.186    48.560
>
  -124.131    48.820
  -125.186    48.560
>
  -124.131    48.820
  -125.186    48.560
>
  -124.566    47.947
  -125.186    48.560
>
  -124.566    47.947
  -125.186    48.560
>
  -124.141    48.062
  -125.186    48.560
>
  -125.134    48.834
  -125.218    48.932
>
  -125.134    48.834
  -125.218    48.932
>
  -125.136    48.834
  -125.218    48.932
>
  -125.136    48.834
  -125.218    48.932
>
  -125.136    48.834
  -125.218    48.932
>
  -125.493    48.960
  -125.218    48.932
>
  -125.493    48.960
  -125.218    48.932
>
  -125.493    48.960
  -125.218    48.932
>
  -125.542    48.925
  -125.218    48.932
>
  -125.542    48.925
  -125.218    48.932
>
  -124.697    49.000
  -125.218    48.932
>
  -124.697    49.000
  -125.218    48.932
>
  -124.697    49.000
  -125.218    48.932
>
  -124.811    49.219
  -125.218    48.932
>
  -124.811    49.219
  -125.218    48.932
>
  -124.811    49.219
  -125.218    48.932
>
  -124.811    49.219
  -125.218    48.932
>
  -125.908    49.154
  -125.218    48.932
>
  -125.908    49.154
  -125.218    48.932
>
  -124.413    48.544
  -125.218    48.932
>
  -124.413    48.544
  -125.218    48.932
>
  -124.589    48.371
  -125.218    48.932
>
  -124.131    48.820
  -125.218    48.932
>
  -124.131    48.820
  -125.218    48.932
>
  -124.131    48.820
  -125.218    48.932
>
  -124.131    48.820
  -125.218    48.932
>
  -126.260    49.348
  -125.218    48.932
>
  -123.988    49.227
  -125.218    48.932
>
  -123.988    49.227
  -125.218    48.932
>
  -124.438    49.698
  -125.218    48.932
>
  -124.438    49.698
  -125.218    48.932
>
  -124.427    48.202
  -125.218    48.932
>
  -126.260    49.348
  -126.514    49.059
>
  -126.260    49.348
  -126.514    49.059
>
  -126.849    48.671
  -126.514    49.059
>
  -125.908    49.154
  -126.514    49.059
>
  -125.908    49.154
  -126.514    49.059
>
  -126.617    49.592
  -126.514    49.059
>
  -126.617    49.592
  -126.514    49.059
>
  -126.175    48.428
  -126.514    49.059
>
  -125.542    48.925
  -126.514    49.059
>
  -125.542    48.925
  -126.514    49.059
>
  -125.493    48.960
  -126.514    49.059
>
  -125.493    48.960
  -126.514    49.059
>
  -126.032    49.781
  -126.514    49.059
>
  -126.032    49.781
  -126.514    49.059
>
  -126.677    49.893
  -126.514    49.059
>
  -126.677    49.893
  -126.514    49.059
>
  -127.120    49.874
  -126.514    49.059
>
  -127.120    49.874
  -126.514    49.059
>
  -125.136    48.834
  -126.514    49.059
>
  -125.493    48.960
  -125.424    49.120
>
  -125.493    48.960
  -125.424    49.120
>
  -125.542    48.925
  -125.424    49.120
>
  -125.542    48.925
  -125.424    49.120
>
  -125.908    49.154
  -125.424    49.120
>
  -125.908    49.154
  -125.424    49.120
>
  -125.134    48.834
  -125.424    49.120
>
  -125.134    48.834
  -125.424    49.120
>
  -125.521    49.468
  -125.424    49.120
>
  -125.521    49.468
  -125.424    49.120
>
  -124.811    49.219
  -125.424    49.120
>
  -124.811    49.219
  -125.424    49.120
>
  -124.811    49.219
  -125.424    49.120
>
  -124.811    49.219
  -125.424    49.120
>
  -124.697    49.000
  -125.424    49.120
>
  -124.697    49.000
  -125.424    49.120
>
  -126.260    49.348
  -125.424    49.120
>
  -126.032    49.781
  -125.424    49.120
>
  -124.236    49.306
  -125.424    49.120
>
  -124.236    49.306
  -125.424    49.120
>
  -124.413    48.544
  -125.424    49.120
>
  -124.438    49.698
  -125.424    49.120
>
  -124.438    49.698
  -125.424    49.120
>
  -124.131    48.820
  -125.424    49.120
>
  -124.131    48.820
  -125.424    49.120
>
  -124.131    48.820
  -125.424    49.120
>
  -126.617    49.592
  -125.424    49.120
>
  -126.617    49.592
  -125.424    49.120
>
  -125.365    50.033
  -125.424    49.120
>
  -123.988    49.227
  -125.424    49.120
>
  -123.988    49.227
  -125.424    49.120
>
  -124.427    48.202
  -124.669    48.065
>
  -124.427    48.202
  -124.669    48.065
>
  -124.625    48.298
  -124.669    48.065
>
  -124.625    48.298
  -124.669    48.065
>
  -124.344    48.083
  -124.669    48.065
>
  -124.344    48.083
  -124.669    48.065
>
  -124.479    48.303
  -124.669    48.065
>
  -124.479    48.303
  -124.669    48.065
>
  -124.395    47.947
  -124.669    48.065
>
  -124.395    47.947
  -124.669    48.065
>
  -124.589    48.371
  -124.669    48.065
>
  -124.589    48.371
  -124.669    48.065
>
  -124.259    48.252
  -124.669    48.065
>
  -124.141    48.062
  -124.669    48.065
>
  -124.141    48.062
  -124.669    48.065
>
  -124.141    48.062
  -124.669    48.065
>
  -124.141    48.062
  -124.669    48.065
>
  -124.413    48.544
  -124.669    48.065
>
  -124.413    48.544
  -124.669    48.065
>
  -124.413    48.544
  -124.669    48.065
>
  -124.175    47.749
  -124.669    48.065
>
  -124.175    47.749
  -124.669    48.065
>
  -123.932    47.860
  -124.669    48.065
>
  -124.251    47.540
  -124.669    48.065
>
  -124.251    47.540
  -124.669    48.065
>
  -123.670    48.150
  -124.669    48.065
>
  -123.670    48.150
  -124.669    48.065
>
  -123.702    47.821
  -124.669    48.065
>
  -123.799    48.559
  -124.669    48.065
>
  -123.799    48.559
  -124.669    48.065
>
  -123.799    48.559
  -124.669    48.065
>
  -123.962    47.506
  -124.669    48.065
>
  -123.503    48.059
  -124.669    48.065
>
  -123.504    48.058
  -124.669    48.065
>
  -123.504    48.058
  -124.669    48.065
>
  -123.504    48.058
  -124.669    48.065
>
  -124.131    48.820
  -124.669    48.065
>
  -124.131    48.820
  -124.669    48.065
>
  -124.131    48.820
  -124.669    48.065
>
  -124.131    48.820
  -124.669    48.065
>
  -124.131    48.820
  -124.669    48.065
>
  -124.131    48.820
  -124.669    48.065
>
  -125.134    48.834
  -124.669    48.065
>
  -125.134    48.834
  -124.669    48.065
>
  -125.134    48.834
  -124.669    48.065
>
  -123.812    47.513
  -124.669    48.065
>
  -123.812    47.513
  -124.669    48.065
>
  -123.993    47.360
  -124.669    48.065
>
  -123.869    47.392
  -124.669    48.065
>
  -123.869    47.392
  -124.669    48.065
>
  -124.697    49.000
  -124.669    48.065
>
  -124.697    49.000
  -124.669    48.065
>
  -123.324    48.414
  -124.669    48.065
>
  -123.324    48.414
  -124.669    48.065
>
  -123.613    47.434
  -124.669    48.065
>
  -124.014    47.209
  -124.669    48.065
>
  -126.260    49.348
  -126.254    49.279
>
  -126.260    49.348
  -126.254    49.279
>
  -125.908    49.154
  -126.254    49.279
>
  -125.908    49.154
  -126.254    49.279
>
  -126.617    49.592
  -126.254    49.279
>
  -126.617    49.592
  -126.254    49.279
>
  -126.032    49.781
  -126.254    49.279
>
  -126.032    49.781
  -126.254    49.279
>
  -125.542    48.925
  -126.254    49.279
>
  -125.542    48.925
  -126.254    49.279
>
  -125.493    48.960
  -126.254    49.279
>
  -125.493    48.960
  -126.254    49.279
>
  -125.493    48.960
  -126.254    49.279
>
  -126.677    49.893
  -126.254    49.279
>
  -126.677    49.893
  -126.254    49.279
>
  -126.849    48.671
  -126.254    49.279
>
  -125.136    48.834
  -126.254    49.279
>
  -125.136    48.834
  -126.254    49.279
>
  -125.134    48.834
  -126.254    49.279
>
  -125.134    48.834
  -126.254    49.279
>
  -126.175    48.428
  -126.254    49.279
>
  -124.811    49.219
  -126.254    49.279
>
  -124.811    49.219
  -126.254    49.279
>
  -126.570    50.161
  -126.254    49.279
>
  -126.570    50.161
  -126.254    49.279
>
  -125.365    50.033
  -126.254    49.279
>
  -125.365    50.033
  -126.254    49.279
>
  -127.115    50.061
  -126.254    49.279
>
  -125.134    48.834
  -124.810    48.620
>
  -125.134    48.834
  -124.810    48.620
>
  -124.413    48.544
  -124.810    48.620
>
  -124.413    48.544
  -124.810    48.620
>
  -125.136    48.834
  -124.810    48.620
>
  -125.136    48.834
  -124.810    48.620
>
  -125.136    48.834
  -124.810    48.620
>
  -124.589    48.371
  -124.810    48.620
>
  -124.589    48.371
  -124.810    48.620
>
  -124.479    48.303
  -124.810    48.620
>
  -124.479    48.303
  -124.810    48.620
>
  -124.131    48.820
  -124.810    48.620
>
  -124.131    48.820
  -124.810    48.620
>
  -124.131    48.820
  -124.810    48.620
>
  -124.131    48.820
  -124.810    48.620
>
  -124.131    48.820
  -124.810    48.620
>
  -124.131    48.820
  -124.810    48.620
>
  -124.427    48.202
  -124.810    48.620
>
  -124.427    48.202
  -124.810    48.620
>
  -124.054    48.433
  -124.810    48.620
>
  -124.054    48.433
  -124.810    48.620
>
  -125.493    48.960
  -124.810    48.620
>
  -125.493    48.960
  -124.810    48.620
>
  -125.493    48.960
  -124.810    48.620
>
  -125.493    48.960
  -124.810    48.620
>
  -124.811    49.219
  -124.810    48.620
>
  -124.811    49.219
  -124.810    48.620
>
  -124.811    49.219
  -124.810    48.620
>
  -124.811    49.219
  -124.810    48.620
>
  -124.861    49.256
  -124.810    48.620
>
  -124.861    49.256
  -124.810    48.620
>
  -124.344    48.083
  -124.810    48.620
>
  -123.799    48.559
  -124.810    48.620
>
  -123.799    48.559
  -124.810    48.620
>
  -123.799    48.559
  -124.810    48.620
>
  -123.799    48.559
  -124.810    48.620
>
  -123.799    48.559
  -124.810    48.620
>
  -124.566    47.947
  -124.810    48.620
>
  -124.141    48.062
  -124.810    48.620
>
  -124.141    48.062
  -124.810    48.620
>
  -124.141    48.062
  -124.810    48.620
>
  -124.141    48.062
  -124.810    48.620
>
  -123.719    48.825
  -124.810    48.620
>
  -124.236    49.306
  -124.810    48.620
>
  -124.236    49.306
  -124.810    48.620
>
  -124.236    49.306
  -124.810    48.620
>
  -123.988    49.227
  -124.810    48.620
>
  -123.988    49.227
  -124.810    48.620
>
  -123.988    49.227
  -124.810    48.620
>
  -123.678    48.363
  -124.810    48.620
>
  -123.678    48.363
  -124.810    48.620
>
  -123.834    48.155
  -124.810    48.620
>
  -123.834    48.155
  -124.810    48.620
>
  -125.908    49.154
  -124.810    48.620
>
  -125.908    49.154
  -124.810    48.620
>
  -123.697    49.148
  -124.810    48.620
>
  -123.451    48.650
  -124.810    48.620
>
  -123.452    48.650
  -124.810    48.620
>
  -123.452    48.650
  -124.810    48.620
>
  -123.451    48.650
  -124.810    48.620
>
  -123.451    48.650
  -124.810    48.620
>
  -123.533    48.340
  -124.810    48.620
>
  -123.533    48.340
  -124.810    48.620
>
  -123.448    48.650
  -124.810    48.620
>
  -123.448    48.650
  -124.810    48.620
>
  -123.670    48.150
  -124.810    48.620
>
  -123.488    48.390
  -124.810    48.620
>
  -123.488    48.390
  -124.810    48.620
>
  -123.488    48.390
  -124.810    48.620
>
  -123.488    48.390
  -124.810    48.620
>
  -123.422    48.430
  -124.810    48.620
>
  -123.422    48.430
  -124.810    48.620
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
  -126.538    49.376     0.300
  -127.120    49.874     0.300
  -127.771    50.157     0.300
  -125.521    49.468     0.300
  -124.692    49.000     0.300
  -124.830    49.272     0.300
  -126.032    49.781     0.300
  -125.493    48.960     0.300
  -125.365    50.033     0.300
  -126.570    50.161     0.300
  -126.055    50.403     0.300
  -124.440    48.572     0.300
  -123.824    48.612     0.300
  -124.004    49.222     0.300
  -124.078    48.035     0.300
  -123.510    48.949     0.300
  -123.451    48.650     0.300
  -123.670    48.150     0.300
  -123.324    48.414     0.300
  -124.178    47.749     0.300
  -127.172    50.403     0.300
  -125.908    49.154     0.300
  -124.811    49.219     0.300
  -125.542    48.925     0.300
  -125.653    49.892     0.300
  -125.134    48.834     0.300
  -124.436    49.697     0.300
  -124.236    49.306     0.300
  -124.262    48.901     0.300
  -123.988    49.227     0.300
  -125.303    49.741     0.300
  -124.131    48.820     0.300
  -124.625    48.298     0.300
  -125.135    48.836     0.300
  -126.849    48.671     0.300
  -126.175    48.428     0.300
  -126.617    49.592     0.300
  -127.492    50.436     0.300
  -125.136    48.834     0.300
  -124.566    47.947     0.300
  -124.344    48.083     0.300
  -124.141    48.062     0.300
  -123.809    47.516     0.300
  -123.869    47.392     0.300
  -123.504    48.058     0.300
  -123.770    47.117     0.300
  -123.673    48.395     0.300
  -127.119    50.054     0.300
  -124.131    48.820     0.300
  -124.413    48.544     0.300
  -123.799    48.559     0.300
  -123.451    48.649     0.300
  -123.451    48.650     0.300
  -123.447    48.653     0.300
  -123.702    47.821     0.300
  -124.811    49.219     0.300
  -124.697    49.000     0.300
  -124.589    48.371     0.300
  -126.260    49.348     0.300
  -124.438    49.698     0.300
  -124.427    48.202     0.300
  -126.677    49.893     0.300
  -124.479    48.303     0.300
  -124.395    47.947     0.300
  -124.259    48.252     0.300
  -124.141    48.062     0.300
  -124.141    48.062     0.300
  -124.175    47.749     0.300
  -123.932    47.860     0.300
  -124.251    47.540     0.300
  -123.962    47.506     0.300
  -123.503    48.059     0.300
  -123.504    48.058     0.300
  -123.504    48.058     0.300
  -123.812    47.513     0.300
  -123.812    47.513     0.300
  -123.993    47.360     0.300
  -123.613    47.434     0.300
  -124.014    47.209     0.300
  -127.115    50.061     0.300
  -124.131    48.820     0.300
  -124.054    48.433     0.300
  -124.861    49.256     0.300
  -123.799    48.559     0.300
  -124.566    47.947     0.300
  -123.719    48.825     0.300
  -123.988    49.227     0.300
  -123.678    48.363     0.300
  -123.834    48.155     0.300
  -125.908    49.154     0.300
  -123.697    49.148     0.300
  -123.452    48.650     0.300
  -123.533    48.340     0.300
  -123.448    48.650     0.300
  -123.488    48.390     0.300
  -123.488    48.390     0.300
  -123.422    48.430     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
  -127.884    49.030     0.200
>
  -127.626    49.274     0.200
>
  -125.894    48.668     0.200
>
  -126.148    49.489     0.200
>
  -124.773    48.660     0.200
>
  -125.820    49.062     0.200
>
  -127.800    49.219     0.200
>
  -127.828    49.221     0.200
>
  -127.307    49.441     0.200
>
  -127.227    49.502     0.200
>
  -125.675    48.664     0.200
>
  -127.480    49.429     0.200
>
  -125.450    49.371     0.200
>
  -125.330    49.174     0.200
>
  -126.023    49.503     0.200
>
  -127.163    49.371     0.200
>
  -127.225    49.324     0.200
>
  -127.138    49.381     0.200
>
  -127.155    49.356     0.200
>
  -124.887    48.227     0.200
>
  -125.598    49.072     0.200
>
  -125.600    49.064     0.200
>
  -127.789    49.095     0.200
>
  -127.588    49.513     0.200
>
  -125.727    49.183     0.200
>
  -124.680    47.769     0.200
>
  -126.011    49.362     0.200
>
  -125.268    49.101     0.200
>
  -126.522    48.857     0.200
>
  -125.521    48.990     0.200
>
  -125.423    49.255     0.200
>
  -125.995    48.658     0.200
>
  -124.667    48.369     0.200
>
  -125.186    48.560     0.200
>
  -125.218    48.932     0.200
>
  -126.514    49.059     0.200
>
  -125.424    49.120     0.200
>
  -124.669    48.065     0.200
>
  -126.254    49.279     0.200
>
  -124.810    48.620     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
  -126.157    49.032     0.000   222.000   222.000
  -126.157    49.032     0.000   444.000   444.000
EOF
gmt end
