#!/bin/bash
gmt begin tofino1.52_base pdf,ps
proj=-JM16.0c+
reg=-R-128.0/-124.6/47.7/49.6
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map tofino1.52'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
  -127.884    49.030 1
  -127.626    49.274 2
  -125.894    48.668 3
  -126.148    49.489 4
  -124.773    48.660 5
  -125.820    49.062 6
  -127.800    49.219 7
  -127.828    49.221 8
  -127.307    49.441 9
  -127.227    49.502 10
  -125.675    48.664 11
  -127.480    49.429 12
  -125.450    49.371 13
  -125.330    49.174 14
  -126.023    49.503 15
  -127.163    49.371 16
  -127.225    49.324 17
  -127.138    49.381 18
  -127.155    49.356 19
  -124.887    48.227 20
  -125.598    49.072 21
  -125.600    49.064 22
  -127.789    49.095 23
  -127.588    49.513 24
  -125.727    49.183 25
  -124.680    47.769 26
  -126.011    49.362 27
  -125.268    49.101 28
  -126.522    48.857 29
  -125.521    48.990 30
  -125.423    49.255 31
  -125.995    48.658 32
  -124.667    48.369 33
  -125.186    48.560 34
  -125.218    48.932 35
  -126.514    49.059 36
  -125.424    49.120 37
  -124.669    48.065 38
  -126.254    49.279 39
  -124.810    48.620 40
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
  -127.686    49.138
  -127.884    49.030
>
  -127.397    49.324
  -127.626    49.274
>
  -125.827    48.729
  -125.894    48.668
>
  -126.084    49.496
  -126.148    49.489
>
  -124.736    48.690
  -124.773    48.660
>
  -125.814    49.052
  -125.820    49.062
>
  -127.671    49.332
  -127.800    49.219
>
  -127.662    49.404
  -127.828    49.221
>
  -127.277    49.499
  -127.307    49.441
>
  -127.290    49.466
  -127.227    49.502
>
  -125.695    48.652
  -125.675    48.664
>
  -127.617    49.367
  -127.480    49.429
>
  -125.442    49.357
  -125.450    49.371
>
  -125.322    49.160
  -125.330    49.174
>
  -126.093    49.472
  -126.023    49.503
>
  -127.065    49.389
  -127.163    49.371
>
  -127.206    49.391
  -127.225    49.324
>
  -127.159    49.398
  -127.138    49.381
>
  -127.069    49.394
  -127.155    49.356
>
  -124.929    48.177
  -124.887    48.227
>
  -125.588    49.072
  -125.598    49.072
>
  -125.591    49.074
  -125.600    49.064
>
  -127.641    49.176
  -127.789    49.095
>
  -127.694    49.490
  -127.588    49.513
>
  -125.737    49.159
  -125.727    49.183
>
  -124.661    47.768
  -124.680    47.769
>
  -125.997    49.354
  -126.011    49.362
>
  -125.255    49.098
  -125.268    49.101
>
  -126.641    48.778
  -126.522    48.857
>
  -125.560    48.976
  -125.521    48.990
>
  -125.484    49.229
  -125.423    49.255
>
  -126.055    48.643
  -125.995    48.658
>
  -124.665    48.384
  -124.667    48.369
>
  -125.153    48.564
  -125.186    48.560
>
  -125.224    48.952
  -125.218    48.932
>
  -126.576    49.066
  -126.514    49.059
>
  -125.424    49.107
  -125.424    49.120
>
  -124.644    48.104
  -124.669    48.065
>
  -126.181    49.275
  -126.254    49.279
>
  -124.813    48.645
  -124.810    48.620
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
  -127.884    49.027
  -127.884    49.030
>
  -127.614    49.273
  -127.626    49.274
>
  -125.894    48.669
  -125.894    48.668
>
  -126.149    49.488
  -126.148    49.489
>
  -124.769    48.663
  -124.773    48.660
>
  -125.823    49.060
  -125.820    49.062
>
  -127.799    49.219
  -127.800    49.219
>
  -127.826    49.221
  -127.828    49.221
>
  -127.299    49.440
  -127.307    49.441
>
  -127.223    49.500
  -127.227    49.502
>
  -125.679    48.663
  -125.675    48.664
>
  -127.476    49.429
  -127.480    49.429
>
  -125.451    49.372
  -125.450    49.371
>
  -125.331    49.175
  -125.330    49.174
>
  -126.025    49.503
  -126.023    49.503
>
  -127.162    49.373
  -127.163    49.371
>
  -127.212    49.329
  -127.225    49.324
>
  -127.130    49.381
  -127.138    49.381
>
  -127.144    49.357
  -127.155    49.356
>
  -124.888    48.227
  -124.887    48.227
>
  -125.597    49.072
  -125.598    49.072
>
  -125.596    49.067
  -125.600    49.064
>
  -127.789    49.094
  -127.789    49.095
>
  -127.582    49.517
  -127.588    49.513
>
  -125.727    49.184
  -125.727    49.183
>
  -124.683    47.769
  -124.680    47.769
>
  -126.012    49.362
  -126.011    49.362
>
  -125.270    49.100
  -125.268    49.101
>
  -126.524    48.858
  -126.522    48.857
>
  -125.523    48.989
  -125.521    48.990
>
  -125.424    49.256
  -125.423    49.255
>
  -125.996    48.658
  -125.995    48.658
>
  -124.669    48.368
  -124.667    48.369
>
  -125.185    48.562
  -125.186    48.560
>
  -125.219    48.931
  -125.218    48.932
>
  -126.520    49.053
  -126.514    49.059
>
  -125.426    49.120
  -125.424    49.120
>
  -124.670    48.065
  -124.669    48.065
>
  -126.253    49.280
  -126.254    49.279
>
  -124.813    48.620
  -124.810    48.620
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -127.884    49.030   -17.901     1.738     2.104
  -127.626    49.274    75.556     1.321     2.603
  -125.894    48.668   -24.262     1.236     2.233
  -126.148    49.489   -32.144     1.050     1.819
  -124.773    48.660   -35.640     1.631     2.592
  -125.820    49.062   -45.221     1.377     3.238
  -127.800    49.219   -31.556     1.534     2.423
  -127.828    49.221   -28.180     1.902     3.093
  -127.307    49.441   -21.658     2.064     3.951
  -127.227    49.502   -29.330     2.379     4.473
  -125.675    48.664   -35.127     1.083     2.036
  -127.480    49.429    51.871     0.411     1.777
  -125.450    49.371   -37.149     0.976     1.520
  -125.330    49.174   -36.013     0.923     1.338
  -126.023    49.503   -38.120     1.053     1.679
  -127.163    49.371   -27.044     0.920     1.294
  -127.225    49.324   -26.961     1.938     4.082
  -127.138    49.381   -27.896     1.504     2.451
  -127.155    49.356   -31.736     1.529     2.687
  -124.887    48.227   -50.155     1.890     3.375
  -125.598    49.072   -46.445     0.884     1.522
  -125.600    49.064   -43.250     0.842     1.463
  -127.789    49.095   -24.340     1.737     2.804
  -127.588    49.513   -43.175     1.596     3.729
  -125.727    49.183   -39.728     0.748     1.330
  -124.680    47.769   -43.259     1.129     2.041
  -126.011    49.362   -40.339     0.990     1.950
  -125.268    49.101   -50.806     0.916     1.136
  -126.522    48.857   -60.158     1.190     1.587
  -125.521    48.990   -55.048     1.185     1.796
  -125.423    49.255   -42.199     0.881     1.317
  -125.995    48.658   -36.518     1.092     1.462
  -124.667    48.369   -40.478     0.619     1.158
  -125.186    48.560   -41.171     0.852     1.535
  -125.218    48.932   -62.435     1.283     2.361
  -126.514    49.059   -56.431     2.043     3.672
  -125.424    49.120   -69.422     1.348     1.619
  -124.669    48.065   -43.562     0.898     1.433
  -126.254    49.279   -43.090     0.839     1.872
  -124.810    48.620   -59.055     0.950     1.867
EOF

# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -127.904    47.723   -11.891     0.860     1.056
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -127.882    47.723   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -127.904    47.723     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -127.904    47.723     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -127.904    47.678   5 km
EOF
gmt end
