#!/bin/bash
gmt begin simeonof10.15_xsec_1 pdf,ps
proj=-JX18.0/-5.2
reg=-R-156.3/68.0/0/65.0
gmt basemap $proj $reg -Bxa10f10+l'Distance (km)' -Bya10f10+l'Depth (km)' -BWesN+t'Cross-section simeonof10.15'
# Event    1 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.785    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.785    44.000
   -37.785    50.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    2 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -46.151    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -46.151    46.000
   -46.151    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    3 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.966    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.966    32.000
   -12.966    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    4 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.460    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.460    23.000
    -3.460    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    5 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     6.707    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     6.707    16.000
     6.707    24.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    6 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -9.778    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -9.778    28.000
    -9.778    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    7 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.749    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.749    24.000
     3.749    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    8 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     2.751    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     2.751    24.000
     2.751    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    9 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.600    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.600    28.000
   -11.600    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   10 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -17.007    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -17.007    32.000
   -17.007    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   11 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -54.247    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -54.247    26.000
   -54.247    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   12 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.695    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.695    25.000
     0.695    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   13 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.879    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.879    27.000
   -13.879    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   14 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.030    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.030    33.000
   -29.030    42.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   15 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.179    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.179    30.000
   -37.179    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   16 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -35.091    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -35.091    43.000
   -35.091    49.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   17 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -47.419    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -47.419    46.000
   -47.419    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   18 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.764    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.764     9.000
    14.764    17.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   19 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -39.764    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -39.764    34.000
   -39.764    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   20 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.539    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.539    33.000
   -27.539    69.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   21 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.754    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.754    25.000
    -6.754    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   22 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.000    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.000    30.000
   -23.000    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   23 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.686    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.686    12.000
    -3.686    20.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   24 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -25.912    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -25.912    28.000
   -25.912    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   25 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -56.929    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -56.929    50.000
   -56.929    56.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   26 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -8.434    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -8.434    30.000
    -8.434    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   27 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -28.453    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -28.453    42.000
   -28.453    48.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   28 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.374    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.374    31.000
    -6.374    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   29 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.396    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.396    27.000
    -2.396    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   30 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.934    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.934    27.000
   -12.934    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   31 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.179    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.179    19.000
     3.179    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   32 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -17.116    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -17.116    24.000
   -17.116    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   33 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.010    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.010    19.000
   -11.010    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   34 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.913    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.913    23.000
    18.913    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   35 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -48.602    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -48.602    51.000
   -48.602    57.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   36 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.855    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.855    29.000
    -6.855    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   37 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.698    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.698    16.000
     7.698    24.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   38 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.495    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.495    25.000
    -2.495    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   39 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -22.077    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -22.077     8.000
   -22.077    16.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   40 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -40.634    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -40.634    20.000
   -40.634    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   41 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.001    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.001    21.000
   -10.001    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   42 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -18.805    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -18.805    26.000
   -18.805    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   43 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -48.917    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -48.917    48.000
   -48.917    54.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   44 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -41.161    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -41.161    46.000
   -41.161    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   45 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.831    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.831    27.000
   -19.831    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   46 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.562    44.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.562    41.000
   -36.562    47.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   47 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -130.488    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -130.488    27.000
  -130.488    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   48 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.785    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.785    50.000
   -51.785    56.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   49 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -49.755    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -49.755    48.000
   -49.755    54.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   50 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -30.241    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -30.241    32.000
   -30.241    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   51 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.811    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.811    44.000
   -42.811    50.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   52 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.883    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.883    44.000
   -42.883    50.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   53 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -5.509    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -5.509    28.000
    -5.509    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   54 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.767    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.767    29.000
    -4.767    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   55 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -38.236    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -38.236    24.000
   -38.236    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   56 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.290    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.290    31.000
   -27.290    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   57 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -8.582    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -8.582    26.000
    -8.582    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   58 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -8.578    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -8.578    26.000
    -8.578    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   59 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -69.885    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -69.885    24.000
   -69.885    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   60 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.162    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.162    15.000
    -1.162    23.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   61 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.133    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.133    28.000
    12.133    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   62 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -28.557    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -28.557    13.000
   -28.557    21.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   63 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -5.542    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -5.542    29.000
    -5.542    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   64 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.675    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.675     9.000
    -1.675    17.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   65 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.513    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.513    10.000
     0.513    18.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   66 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.806    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.806    29.000
    -2.806    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   67 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.797    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.797    28.000
    -2.797    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   68 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -25.020    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -25.020    17.000
   -25.020    25.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   69 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -35.377    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -35.377    29.000
   -35.377    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   70 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -43.768    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -43.768    29.000
   -43.768    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   71 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -35.306    41.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -35.306    26.000
   -35.306    45.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   72 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.259    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.259    32.000
   -42.259    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   73 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -48.418    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -48.418    18.000
   -48.418    26.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   74 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -72.289    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -72.289    23.000
   -72.289    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   75 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -24.377    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -24.377    29.000
   -24.377    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   76 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.222    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.222    30.000
    17.222    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   77 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.005    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.005    27.000
    42.005    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   78 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.539    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.539     9.000
     1.539    17.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   79 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -20.323    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -20.323    27.000
   -20.323    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   80 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.664    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.664    30.000
   -36.664    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   81 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.681    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.681    26.000
    -1.681    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   82 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.509    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.509    30.000
    -4.509    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   83 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -87.859    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -87.859    57.000
   -87.859    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   84 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -22.950    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -22.950    10.000
   -22.950    18.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   85 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -8.905    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -8.905    24.000
    -8.905    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   86 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -26.655    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -26.655    47.000
   -26.655    53.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   87 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.776    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.776    29.000
     1.776    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   88 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.917    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.917    48.000
   -44.917    54.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   89 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.724    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.724    23.000
    -1.724    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   90 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -71.057    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -71.057    25.000
   -71.057    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   91 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     4.210    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     4.210    23.000
     4.210    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   92 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.889    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.889    26.000
   -13.889    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   93 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.253    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.253    30.000
    15.253    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   94 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.989    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.989     7.000
     0.989    15.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   95 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.712    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.712    16.000
     3.712    24.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   96 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.996     5.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.996     1.000
     1.996     9.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   97 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     8.860    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     8.860    10.000
     8.860    18.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   98 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     5.971    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     5.971    23.000
     5.971    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   99 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.844    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.844    30.000
   -42.844    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  100 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     4.560    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     4.560    32.000
     4.560    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  101 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.226    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.226    19.000
    -6.226    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  102 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -47.429    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -47.429    27.000
   -47.429    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  103 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -91.158    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -91.158    48.000
   -91.158    54.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  104 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.336    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.336    10.000
   -11.336    18.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  105 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.571    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.571    12.000
   -11.571    20.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  106 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.007    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.007     8.000
    -7.007    16.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  107 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.971    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.971    28.000
    -4.971    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  108 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.491    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.491    28.000
    11.491    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  109 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -30.758    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -30.758    31.000
   -30.758    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  110 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.248    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.248    12.000
     7.248    20.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  111 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -26.019    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -26.019    15.000
   -26.019    23.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  112 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -8.236    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -8.236    10.000
    -8.236    18.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  113 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -151.291    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -151.291    22.000
  -151.291    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  114 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.280    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.280    20.000
     7.280    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  115 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -97.417    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -97.417    21.000
   -97.417    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  116 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.053    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.053    25.000
     0.053    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
     0.053    29.000     0.300
EOF

# Event  117 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -9.053    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -9.053    30.000
    -9.053    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  118 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.045    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.045    42.000
   -37.045    48.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  119 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.491    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.491    29.000
     7.491    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  120 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -15.474    41.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -15.474    38.000
   -15.474    44.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  121 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.619    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.619    30.000
    11.619    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  122 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -17.451    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -17.451    24.000
   -17.451    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  123 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.233    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.233    29.000
    18.233    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  124 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.689    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.689    23.000
    18.689    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  125 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.219    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.219    40.000
   -45.219    46.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  126 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -21.236    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -21.236    23.000
   -21.236    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  127 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -40.152    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -40.152    46.000
   -40.152    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  128 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -33.903    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -33.903    44.000
   -33.903    50.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  129 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.903    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.903    29.000
    -7.903    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  130 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.472    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.472    29.000
   -12.472    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  131 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.918    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.918    29.000
   -27.918    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  132 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.511    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.511    37.000
   -29.511    43.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  133 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     4.667    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     4.667    22.000
     4.667    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  134 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -43.932    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -43.932    45.000
   -43.932    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  135 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -26.970    38.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -26.970    35.000
   -26.970    41.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  136 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -26.911    38.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -26.911    35.000
   -26.911    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  137 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -48.701    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -48.701    45.000
   -48.701    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  138 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -41.058    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -41.058    45.000
   -41.058    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  139 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.983    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.983    17.000
    -6.983    25.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  140 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.486    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.486    50.000
   -51.486    56.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  141 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -34.490    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -34.490    40.000
   -34.490    46.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  142 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.397    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.397    43.000
   -42.397    49.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  143 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.542    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.542    16.000
    20.542    24.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  144 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -24.316    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -24.316    32.000
   -24.316    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  145 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.016    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.016    34.000
   -13.016    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  146 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.093    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.093    27.000
   -11.093    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  147 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.220    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.220    45.000
   -42.220    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  148 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.670    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.670    47.000
   -44.670    53.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  149 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -48.565    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -48.565    45.000
   -48.565    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  150 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.767    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.767    29.000
   -10.767    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  151 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.092    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.092    36.000
   -44.092    42.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  152 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -32.346    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -32.346    36.000
   -32.346    42.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  153 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -49.115    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -49.115    45.000
   -49.115    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  154 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.307    44.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.307    41.000
   -37.307    47.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  155 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -39.197    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -39.197    48.000
   -39.197    54.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  156 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -39.028    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -39.028    44.000
   -39.028    50.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  157 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -47.238    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -47.238    46.000
   -47.238    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  158 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -21.078    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -21.078    24.000
   -21.078    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  159 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -41.513    44.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -41.513    41.000
   -41.513    47.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  160 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -14.121    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -14.121     8.000
   -14.121    16.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  161 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.956    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.956    26.000
    13.956    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  162 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -8.828    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -8.828    29.000
    -8.828    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  163 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.708    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.708    23.000
   -23.708    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  164 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -22.696    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -22.696    33.000
   -22.696    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  165 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.721    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.721    21.000
    -3.721    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  166 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.839    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.839    32.000
   -10.839    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  167 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.571    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.571    27.000
   -19.571    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  168 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -31.298    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -31.298    31.000
   -31.298    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  169 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -43.641    38.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -43.641    35.000
   -43.641    41.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  170 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -30.732    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -30.732    29.000
   -30.732    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  171 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -48.718    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -48.718    46.000
   -48.718    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  172 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.193    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.193    19.000
    26.193    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  173 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -39.550    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -39.550    42.000
   -39.550    48.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  174 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     9.600    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     9.600    30.000
     9.600    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  175 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     9.058    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     9.058    31.000
     9.058    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  176 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -47.993    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -47.993    48.000
   -47.993    54.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  177 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -32.241    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -32.241    30.000
   -32.241    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  178 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.222    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.222    26.000
   -44.222    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  179 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -17.003    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -17.003    14.000
   -17.003    22.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  180 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -54.660    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -54.660    42.000
   -54.660    48.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  181 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.444    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.444    45.000
   -51.444    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  182 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -34.965    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -34.965    40.000
   -34.965    46.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  183 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.851    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.851    21.000
    25.851    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  184 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.646    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.646    42.000
   -42.646    48.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  185 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.053    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.053    29.000
   -23.053    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  186 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -43.593    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -43.593    46.000
   -43.593    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  187 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.078    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.078    21.000
    -7.078    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  188 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -26.948    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -26.948    23.000
   -26.948    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  189 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.757    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.757    47.000
   -51.757    53.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  190 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.496    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.496    40.000
   -45.496    46.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  191 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.393     5.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.393     1.000
    -2.393     9.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  192 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.130    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.130    24.000
   -27.130    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  193 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.261    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.261    26.000
    -7.261    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  194 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     8.635    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     8.635    27.000
     8.635    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  195 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.654    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.654     7.000
   -13.654    15.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  196 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.063    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.063    26.000
    -7.063    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  197 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -21.671    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -21.671    29.000
   -21.671    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  198 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.352    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.352    30.000
    10.352    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    10.352    33.000     0.300
EOF

# Event  199 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.032    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.032    26.000
    24.032    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  200 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.726    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.726    14.000
    29.726    22.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  201 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.675    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.675    30.000
    27.675    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  202 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    35.348    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    35.348    27.000
    35.348    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  203 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.952    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.952    26.000
    36.952    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  204 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.196    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.196    21.000
    25.196    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  205 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.476    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.476    27.000
    15.476    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  206 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    31.580    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    31.580    20.000
    31.580    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  207 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.742    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.742    22.000
    32.742    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  208 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.034    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.034    33.000
    19.034    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  209 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    40.144    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    40.144    16.000
    40.144    24.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  210 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.299    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.299    19.000
    27.299    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  211 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.580    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.580    25.000
    37.580    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  212 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    40.949    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    40.949    19.000
    40.949    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  213 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.309    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.309    27.000
    10.309    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  214 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.754    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.754    22.000
    23.754    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  215 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.365    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.365    25.000
    22.365    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  216 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    39.339    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    39.339    26.000
    39.339    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  217 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.518    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.518    30.000
    26.518    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  218 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.384    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.384    24.000
    17.384    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  219 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.454    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.454    21.000
    38.454    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  220 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.615    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.615    27.000
    23.615    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  221 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.415    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.415    19.000
    30.415    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  222 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.795    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.795    23.000
    20.795    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  223 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.206    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.206    30.000
    23.206    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  224 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.222    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.222    22.000
    11.222    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  225 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.545    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.545    30.000
    26.545    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  226 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    39.592    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    39.592    24.000
    39.592    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  227 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.164    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.164    23.000
    32.164    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  228 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    49.282    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    49.282    21.000
    49.282    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  229 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    44.079    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    44.079    25.000
    44.079    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  230 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.783    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.783    31.000
    24.783    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  231 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    50.543    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    50.543    25.000
    50.543    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  232 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.063    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.063    31.000
    37.063    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  233 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.564    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.564    30.000
    29.564    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  234 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    35.764    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    35.764    29.000
    35.764    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  235 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.686    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.686    26.000
    16.686    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  236 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    40.393    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    40.393    28.000
    40.393    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  237 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.441    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.441    19.000
    17.441    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  238 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.781    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.781    28.000
    12.781    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  239 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.963    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.963    28.000
    14.963    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  240 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.366    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.366    29.000
    43.366    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  241 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.562    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.562    14.000
    42.562    22.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  242 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.016    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.016    27.000
    37.016    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  243 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.103    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.103    28.000
    37.103    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  244 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.515    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.515    29.000
    38.515    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  245 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.436    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.436    31.000
    27.436    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  246 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    47.230    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    47.230    28.000
    47.230    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  247 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.661    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.661    28.000
    42.661    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  248 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.248    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.248    32.000
    29.248    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  249 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.896    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.896    31.000
    32.896    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  250 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.554    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.554    28.000
    42.554    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  251 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    31.570    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    31.570    25.000
    31.570    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  252 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.289    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.289    28.000
    32.289    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  253 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.763    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.763    21.000
    20.763    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  254 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.132    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.132    24.000
    17.132    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  255 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.291    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.291    28.000
     7.291    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  256 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.002    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.002    27.000
    25.002    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  257 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    33.581    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    33.581    29.000
    33.581    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  258 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.816    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.816    28.000
    38.816    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  259 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    47.466    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    47.466    11.000
    47.466    19.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  260 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.705    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.705    23.000
    23.705    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  261 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.605    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.605    34.000
    32.605    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  262 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.382    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.382    30.000
    42.382    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  263 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    41.550    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    41.550    28.000
    41.550    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  264 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.817    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.817    31.000
    26.817    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  265 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.450    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.450    26.000
    42.450    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  266 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.222    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.222    34.000
    32.222    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  267 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    33.291    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    33.291    25.000
    33.291    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  268 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.395    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.395    33.000
    15.395    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  269 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.264    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.264    47.000
    28.264    53.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  270 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.375    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.375    45.000
    22.375    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  271 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.604    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.604    33.000
    24.604    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  272 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     9.402    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     9.402    29.000
     9.402    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  273 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.965    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.965    23.000
    14.965    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  274 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    45.182    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    45.182    24.000
    45.182    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  275 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.753    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.753    27.000
    11.753    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  276 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.010    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.010    24.000
    25.010    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  277 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.936    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.936    19.000
    28.936    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  278 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    31.471    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    31.471    28.000
    31.471    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  279 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.060    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.060    20.000
    43.060    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  280 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.427    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.427    20.000
    30.427    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  281 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.359    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.359    25.000
    30.359    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  282 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.005    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.005    34.000
    19.005    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  283 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    40.852    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    40.852    27.000
    40.852    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  284 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.458    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.458    28.000
    37.458    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  285 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    45.622    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    45.622    28.000
    45.622    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  286 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.583    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.583    28.000
    25.583    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  287 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.885    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.885    29.000
    19.885    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  288 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.726    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.726    28.000
    16.726    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  289 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    41.695    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    41.695    30.000
    41.695    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  290 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.627    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.627    15.000
    25.627    23.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  291 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    60.031    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    60.031    24.000
    60.031    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  292 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.492    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.492    28.000
    28.492    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  293 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.765    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.765    28.000
    27.765    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  294 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.300    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.300    23.000
    25.300    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  295 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.396    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.396    29.000
    37.396    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  296 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.786    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.786    19.000
    36.786    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  297 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    46.147    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    46.147    26.000
    46.147    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  298 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.523    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.523    27.000
    14.523    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  299 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    51.239    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    51.239    18.000
    51.239    26.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  300 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    57.511    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    57.511    26.000
    57.511    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  301 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    35.575    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    35.575    31.000
    35.575    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  302 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.449    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.449    14.000
    25.449    22.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  303 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    33.029    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    33.029    27.000
    33.029    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  304 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.061    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.061    18.000
    14.061    26.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  305 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.708    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.708    31.000
    19.708    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  306 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.310    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.310    34.000
    22.310    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  307 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.423    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.423    26.000
    43.423    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  308 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     5.411    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     5.411    22.000
     5.411    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  309 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -40.367    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -40.367    40.000
   -40.367    46.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  310 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    44.590    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    44.590    27.000
    44.590    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  311 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.579    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.579    24.000
    26.579    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  312 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.307    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.307    16.000
    30.307    24.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  313 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.159    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.159    27.000
    29.159    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  314 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     8.934    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     8.934    34.000
     8.934    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  315 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.324    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.324    22.000
    19.324    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  316 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.384    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.384    30.000
   -27.384    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  317 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    62.971    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    62.971     9.000
    62.971    17.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  318 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.922    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.922    21.000
    32.922    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  319 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.386    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.386    26.000
    36.386    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  320 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    52.834    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    52.834    21.000
    52.834    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  321 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    61.853    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    61.853    15.000
    61.853    23.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  322 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.832    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.832    27.000
    11.832    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  323 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.425    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.425    27.000
    19.425    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  324 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.572    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.572    27.000
    18.572    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  325 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    41.416    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    41.416    29.000
    41.416    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  326 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.365    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.365    28.000
    20.365    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  327 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.682    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.682    24.000
    43.682    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  328 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    54.292    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    54.292    22.000
    54.292    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  329 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    31.113    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    31.113    27.000
    31.113    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  330 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.699    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.699    27.000
    17.699    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  331 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.774    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.774    31.000
    28.774    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  332 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.812    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.812    25.000
    37.812    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  333 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.623    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.623    30.000
    12.623    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  334 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.103    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.103    22.000
    23.103    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  335 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.969    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.969    31.000
    18.969    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  336 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.501    44.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.501    41.000
    27.501    47.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  337 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.411    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.411    31.000
    11.411    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  338 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.958    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.958    30.000
    22.958    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  339 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.733    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.733    28.000
    27.733    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  340 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.537    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.537    25.000
    17.537    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  341 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.173    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.173    12.000
   -29.173    20.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  342 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.216    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.216    43.000
   -37.216    49.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  343 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.685    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.685    16.000
    29.685    24.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  344 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.552    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.552    23.000
    10.552    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  345 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    45.164    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    45.164    20.000
    45.164    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  346 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    58.291    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    58.291    12.000
    58.291    20.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  347 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     6.199    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     6.199    30.000
     6.199    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  348 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.101    41.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.101    38.000
    25.101    44.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  349 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.168    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.168    22.000
    25.168    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  350 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    34.634    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    34.634    25.000
    34.634    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  351 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.064    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.064    20.000
    42.064    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  352 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.700    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.700    34.000
    16.700    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  353 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.420    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.420    15.000
    37.420    23.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  354 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.859    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.859    27.000
    26.859    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  355 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    53.353    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    53.353    11.000
    53.353    19.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  356 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.099    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.099    27.000
    42.099    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  357 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.153    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.153    22.000
    19.153    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  358 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.816    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.816    29.000
    43.816    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  359 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.615    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.615    32.000
    12.615    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  360 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.197    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.197    28.000
    42.197    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  361 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -50.261    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -50.261    47.000
   -50.261    53.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  362 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.853    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.853    29.000
    13.853    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  363 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    21.033    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    21.033    29.000
    21.033    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  364 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.577    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.577    27.000
    42.577    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  365 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.421    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.421    29.000
    18.421    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  366 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -25.940    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -25.940    28.000
   -25.940    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  367 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.724    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.724    31.000
     3.724    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  368 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.997    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.997    30.000
     3.997    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  369 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    21.141    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    21.141    19.000
    21.141    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  370 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.827    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.827    30.000
    28.827    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  371 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -48.057    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -48.057    34.000
   -48.057    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  372 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.489    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.489    44.000
     7.489    50.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  373 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.186    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.186    28.000
    10.186    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  374 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.661    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.661    28.000
    14.661    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  375 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.113    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.113    22.000
    16.113    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  376 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     4.636    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     4.636    29.000
     4.636    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  377 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.775    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.775    28.000
    18.775    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  378 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -80.316    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -80.316    54.000
   -80.316    60.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  379 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     8.616    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     8.616    31.000
     8.616    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  380 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -24.276    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -24.276    30.000
   -24.276    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  381 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    35.186    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    35.186    28.000
    35.186    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  382 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    44.472    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    44.472    29.000
    44.472    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  383 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.281    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.281    34.000
    26.281    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  384 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     6.851    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     6.851    26.000
     6.851    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  385 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     6.969    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     6.969    28.000
     6.969    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  386 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -63.731    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -63.731    23.000
   -63.731    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  387 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.615     1.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.615     0.000
     1.615     5.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  388 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    34.918    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    34.918    25.000
    34.918    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  389 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     5.276    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     5.276    31.000
     5.276    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  390 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.914    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.914    21.000
    32.914    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  391 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.458    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.458    26.000
    27.458    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  392 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.805    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.805    15.000
   -23.805    21.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  393 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.520    42.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.520    39.000
   -36.520    45.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  394 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -70.897    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -70.897     7.000
   -70.897    15.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  395 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     9.167    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     9.167    29.000
     9.167    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  396 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    47.401    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    47.401    24.000
    47.401    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  397 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.518    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.518    29.000
     3.518    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  398 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.851    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.851    34.000
   -37.851    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  399 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.730    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.730    28.000
    37.730    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  400 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.431    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.431    26.000
    12.431    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  401 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.471    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.471    24.000
    25.471    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  402 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.015    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.015    22.000
   -19.015    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  403 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.603    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.603    28.000
    11.603    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  404 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.368    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.368    30.000
    27.368    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  405 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.010    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.010    32.000
     1.010    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  406 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.403    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.403    30.000
    27.403    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  407 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.736    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.736    18.000
    -2.736    26.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  408 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.285    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.285    28.000
    10.285    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  409 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    35.360    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    35.360    28.000
    35.360    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  410 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.845    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.845    25.000
    36.845    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  411 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.580    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.580    30.000
    24.580    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  412 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    50.036    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    50.036    23.000
    50.036    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  413 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.550    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.550    26.000
    12.550    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  414 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.532    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.532    19.000
    12.532    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  415 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -5.922    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -5.922    32.000
    -5.922    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  416 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.270    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.270    34.000
    10.270    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  417 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -32.611    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -32.611    37.000
   -32.611    43.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  418 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.615    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.615    24.000
    22.615    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  419 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -5.536    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -5.536    29.000
    -5.536    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  420 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.425    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.425    25.000
    14.425    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  421 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -8.759    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -8.759    28.000
    -8.759    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  422 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.272    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.272    27.000
     0.272    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  423 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.535    42.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.535    26.000
   -37.535    47.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  424 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -14.399    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -14.399    32.000
   -14.399    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  425 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.505    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.505    28.000
   -42.505    47.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  426 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     5.333    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     5.333    28.000
     5.333    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  427 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -66.895    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -66.895    17.000
   -66.895    25.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  428 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.502    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.502    24.000
    17.502    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  429 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.269    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.269    18.000
    15.269    26.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  430 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.033    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.033    36.000
   -36.033    42.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  431 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    52.497     7.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    52.497     3.000
    52.497    11.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  432 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.308    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.308    28.000
    14.308    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  433 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -35.385    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -35.385    46.000
   -35.385    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  434 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.170    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.170    26.000
   -27.170    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  435 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.669    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.669    37.000
   -11.669    43.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  436 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     9.717    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     9.717    27.000
     9.717    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  437 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.247    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.247    19.000
    25.247    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  438 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -80.652    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -80.652    57.000
   -80.652    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  439 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.507    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.507    31.000
    -1.507    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  440 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.956    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.956    25.000
    -6.956    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  441 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    55.755    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    55.755    28.000
    55.755    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  442 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     8.564    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     8.564    24.000
     8.564    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  443 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.262    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.262    29.000
     1.262    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  444 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.587    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.587    25.000
    36.587    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  445 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    21.157    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    21.157    22.000
    21.157    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  446 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.856    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.856    29.000
    17.856    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  447 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    52.333    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    52.333    18.000
    52.333    26.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  448 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.302    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.302    24.000
    30.302    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  449 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.882    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.882    26.000
    10.882    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  450 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.807    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.807    27.000
    36.807    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  451 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.873    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.873    29.000
    -3.873    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  452 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.685    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.685    30.000
    -2.685    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  453 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -16.720    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -16.720    45.000
   -16.720    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  454 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.349    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.349    25.000
    16.349    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  455 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.084    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.084    33.000
    -6.084    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  456 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -67.016    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -67.016    11.000
   -67.016    19.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  457 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -56.862    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -56.862    27.000
   -56.862    47.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  458 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.419    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.419    33.000
   -27.419    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  459 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.878    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.878    23.000
    16.878    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  460 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.682    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.682    27.000
    13.682    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  461 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.779    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.779    45.000
   -36.779    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  462 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.822    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.822    40.000
    19.822    46.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  463 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    31.354    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    31.354    26.000
    31.354    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  464 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -30.778    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -30.778    37.000
   -30.778    43.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  465 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    57.919    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    57.919    23.000
    57.919    44.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  466 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -52.876    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -52.876    46.000
   -52.876    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  467 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -68.944    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -68.944    49.000
   -68.944    55.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  468 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.801    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.801    18.000
     1.801    26.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
     1.801    22.000     0.300
EOF

# Event  469 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.202    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.202    24.000
   -19.202    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  470 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.350    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.350    16.000
   -19.350    24.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  471 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.571    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.571    21.000
   -11.571    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  472 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -22.853    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -22.853    23.000
   -22.853    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  473 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.375    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.375    34.000
   -29.375    45.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  474 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -17.260    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -17.260    15.000
   -17.260    23.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  475 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -20.136    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -20.136    26.000
   -20.136    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  476 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -25.558    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -25.558    31.000
   -25.558    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  477 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -17.629    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -17.629    25.000
   -17.629    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  478 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -47.700    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -47.700    46.000
   -47.700    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  479 fixed depth, contraint code w
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.409    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.409    25.000
     7.409    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  480 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     2.714    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     2.714    22.000
     2.714    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  481 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -41.933    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -41.933    40.000
   -41.933    46.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  482 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.445    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.445    31.000
   -42.445    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  483 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -48.653    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -48.653    50.000
   -48.653    56.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  484 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     9.957    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     9.957    24.000
     9.957    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  485 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.929    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.929    13.000
   -36.929    21.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  486 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.087    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.087    14.000
    18.087    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  487 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    58.353    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    58.353    14.000
    58.353    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  488 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.940    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.940    22.000
    18.940    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  489 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -26.345    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -26.345    11.000
   -26.345    19.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  490 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -60.149    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -60.149     7.000
   -60.149    15.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  491 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -56.435    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -56.435     9.000
   -56.435    17.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  492 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -84.646    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -84.646    56.000
   -84.646    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  493 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -48.377    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -48.377    12.000
   -48.377    20.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  494 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    48.410    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    48.410     8.000
    48.410    16.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  495 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -8.977    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -8.977    19.000
    -8.977    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    -8.977    23.000     0.300
EOF

# Event  496 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.608    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.608    24.000
    -2.608    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  497 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     4.913    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     4.913    27.000
     4.913    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  498 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -0.618    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -0.618    31.000
    -0.618    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  499 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     4.630    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     4.630    26.000
     4.630    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  500 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.271    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.271    44.000
     1.271    50.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF


# Event numbers
gmt text $proj $reg -F+f8p,Helvetica,black+a0.+jBL << EOF
   -37.585    47.000 1
   -45.951    49.000 2
   -12.766    35.000 3
    -3.260    27.000 4
     6.907    20.000 5
    -9.578    32.000 6
     3.949    28.000 7
     2.951    28.000 8
   -11.400    32.000 9
   -16.807    36.000 10
   -54.047    45.000 11
     0.895    29.000 12
   -13.679    31.000 13
   -28.830    37.000 14
   -36.979    33.000 15
   -34.891    46.000 16
   -47.219    49.000 17
    14.964    13.000 18
   -39.564    36.000 19
   -27.339    39.000 20
    -6.554    28.000 21
   -22.800    35.000 22
    -3.486    16.000 23
   -25.712    32.000 24
   -56.729    53.000 25
    -8.234    33.000 26
   -28.253    45.000 27
    -6.174    34.000 28
    -2.196    30.000 29
   -12.734    31.000 30
     3.379    23.000 31
   -16.916    28.000 32
   -10.810    23.000 33
    19.113    27.000 34
   -48.402    54.000 35
    -6.655    32.000 36
     7.898    20.000 37
    -2.295    29.000 38
   -21.877    12.000 39
   -40.434    24.000 40
    -9.801    28.000 41
   -18.605    30.000 42
   -48.717    51.000 43
   -40.961    49.000 44
   -19.631    31.000 45
   -36.362    44.000 46
  -130.288    31.000 47
   -51.585    53.000 48
   -49.555    51.000 49
   -30.041    36.000 50
   -42.611    47.000 51
   -42.683    47.000 52
    -5.309    32.000 53
    -4.567    33.000 54
   -38.036    28.000 55
   -27.090    34.000 56
    -8.382    29.000 57
    -8.378    29.000 58
   -69.685    27.000 59
    -0.962    19.000 60
    12.333    32.000 61
   -28.357    17.000 62
    -5.342    33.000 63
    -1.475    13.000 64
     0.713    14.000 65
    -2.606    32.000 66
    -2.597    31.000 67
   -24.820    21.000 68
   -35.177    33.000 69
   -43.568    35.000 70
   -35.106    41.000 71
   -42.059    35.000 72
   -48.218    22.000 73
   -72.089    27.000 74
   -24.177    33.000 75
    17.422    34.000 76
    42.205    31.000 77
     1.739    13.000 78
   -20.123    31.000 79
   -36.464    34.000 80
    -1.481    29.000 81
    -4.309    33.000 82
   -87.659    60.000 83
   -22.750    14.000 84
    -8.705    27.000 85
   -26.455    50.000 86
     1.976    32.000 87
   -44.717    51.000 88
    -1.524    27.000 89
   -70.857    29.000 90
     4.410    26.000 91
   -13.689    29.000 92
    15.453    33.000 93
     1.189    11.000 94
     3.912    20.000 95
     2.196     5.000 96
     9.060    14.000 97
     6.171    26.000 98
   -42.644    33.000 99
     4.760    35.000 100
    -6.026    23.000 101
   -47.229    31.000 102
   -90.958    51.000 103
   -11.136    14.000 104
   -11.371    16.000 105
    -6.807    12.000 106
    -4.771    31.000 107
    11.691    32.000 108
   -30.558    34.000 109
     7.448    16.000 110
   -25.819    19.000 111
    -8.036    14.000 112
  -151.091    25.000 113
     7.480    24.000 114
   -97.217    24.000 115
     0.253    29.000 116
    -8.853    34.000 117
   -36.845    45.000 118
     7.691    33.000 119
   -15.274    41.000 120
    11.819    34.000 121
   -17.251    28.000 122
    18.433    33.000 123
    18.889    27.000 124
   -45.019    43.000 125
   -21.036    27.000 126
   -39.952    49.000 127
   -33.703    47.000 128
    -7.703    33.000 129
   -12.272    33.000 130
   -27.718    33.000 131
   -29.311    40.000 132
     4.867    25.000 133
   -43.732    48.000 134
   -26.770    38.000 135
   -26.711    38.000 136
   -48.501    48.000 137
   -40.858    48.000 138
    -6.783    21.000 139
   -51.286    53.000 140
   -34.290    43.000 141
   -42.197    46.000 142
    20.742    20.000 143
   -24.116    35.000 144
   -12.816    37.000 145
   -10.893    30.000 146
   -42.020    48.000 147
   -44.470    50.000 148
   -48.365    48.000 149
   -10.567    32.000 150
   -43.892    39.000 151
   -32.146    39.000 152
   -48.915    48.000 153
   -37.107    44.000 154
   -38.997    51.000 155
   -38.828    47.000 156
   -47.038    49.000 157
   -20.878    28.000 158
   -41.313    44.000 159
   -13.921    12.000 160
    14.156    30.000 161
    -8.628    33.000 162
   -23.508    27.000 163
   -22.496    36.000 164
    -3.521    25.000 165
   -10.639    35.000 166
   -19.371    31.000 167
   -31.098    34.000 168
   -43.441    38.000 169
   -30.532    33.000 170
   -48.518    49.000 171
    26.393    23.000 172
   -39.350    45.000 173
     9.800    34.000 174
     9.258    35.000 175
   -47.793    51.000 176
   -32.041    33.000 177
   -44.022    30.000 178
   -16.803    18.000 179
   -54.460    45.000 180
   -51.244    48.000 181
   -34.765    43.000 182
    26.051    25.000 183
   -42.446    45.000 184
   -22.853    32.000 185
   -43.393    49.000 186
    -6.878    25.000 187
   -26.748    27.000 188
   -51.557    50.000 189
   -45.296    43.000 190
    -2.193     5.000 191
   -26.930    28.000 192
    -7.061    30.000 193
     8.835    30.000 194
   -13.454    11.000 195
    -6.863    29.000 196
   -21.471    32.000 197
    10.552    33.000 198
    24.232    29.000 199
    29.926    18.000 200
    27.875    33.000 201
    35.548    31.000 202
    37.152    30.000 203
    25.396    25.000 204
    15.676    30.000 205
    31.780    24.000 206
    32.942    26.000 207
    19.234    36.000 208
    40.344    20.000 209
    27.499    23.000 210
    37.780    29.000 211
    41.149    23.000 212
    10.509    30.000 213
    23.954    26.000 214
    22.565    28.000 215
    39.539    30.000 216
    26.718    33.000 217
    17.584    27.000 218
    38.654    25.000 219
    23.815    30.000 220
    30.615    23.000 221
    20.995    26.000 222
    23.406    33.000 223
    11.422    25.000 224
    26.745    33.000 225
    39.792    28.000 226
    32.364    27.000 227
    49.482    25.000 228
    44.279    29.000 229
    24.983    34.000 230
    50.743    29.000 231
    37.263    34.000 232
    29.764    34.000 233
    35.964    33.000 234
    16.886    29.000 235
    40.593    32.000 236
    17.641    23.000 237
    12.981    31.000 238
    15.163    31.000 239
    43.566    33.000 240
    42.762    18.000 241
    37.216    31.000 242
    37.303    32.000 243
    38.715    33.000 244
    27.636    34.000 245
    47.430    32.000 246
    42.861    32.000 247
    29.448    35.000 248
    33.096    34.000 249
    42.754    32.000 250
    31.770    29.000 251
    32.489    32.000 252
    20.963    25.000 253
    17.332    27.000 254
     7.491    31.000 255
    25.202    30.000 256
    33.781    33.000 257
    39.016    32.000 258
    47.666    15.000 259
    23.905    27.000 260
    32.805    37.000 261
    42.582    34.000 262
    41.750    32.000 263
    27.017    34.000 264
    42.650    30.000 265
    32.422    37.000 266
    33.491    29.000 267
    15.595    36.000 268
    28.464    50.000 269
    22.575    48.000 270
    24.804    36.000 271
     9.602    32.000 272
    15.165    26.000 273
    45.382    28.000 274
    11.953    30.000 275
    25.210    28.000 276
    29.136    23.000 277
    31.671    32.000 278
    43.260    24.000 279
    30.627    24.000 280
    30.559    29.000 281
    19.205    37.000 282
    41.052    31.000 283
    37.658    32.000 284
    45.822    32.000 285
    25.783    31.000 286
    20.085    32.000 287
    16.926    31.000 288
    41.895    34.000 289
    25.827    19.000 290
    60.231    28.000 291
    28.692    31.000 292
    27.965    32.000 293
    25.500    27.000 294
    37.596    33.000 295
    36.986    23.000 296
    46.347    30.000 297
    14.723    30.000 298
    51.439    22.000 299
    57.711    30.000 300
    35.775    35.000 301
    25.649    18.000 302
    33.229    31.000 303
    14.261    22.000 304
    19.908    34.000 305
    22.510    37.000 306
    43.623    30.000 307
     5.611    25.000 308
   -40.167    43.000 309
    44.790    31.000 310
    26.779    28.000 311
    30.507    20.000 312
    29.359    31.000 313
     9.134    37.000 314
    19.524    26.000 315
   -27.184    34.000 316
    63.171    13.000 317
    33.122    25.000 318
    36.586    30.000 319
    53.034    25.000 320
    62.053    19.000 321
    12.032    30.000 322
    19.625    30.000 323
    18.772    30.000 324
    41.616    33.000 325
    20.565    31.000 326
    43.882    28.000 327
    54.492    26.000 328
    31.313    31.000 329
    17.899    30.000 330
    28.974    34.000 331
    38.012    29.000 332
    12.823    33.000 333
    23.303    26.000 334
    19.169    34.000 335
    27.701    44.000 336
    11.611    34.000 337
    23.158    33.000 338
    27.933    31.000 339
    17.737    28.000 340
   -28.973    16.000 341
   -37.016    46.000 342
    29.885    20.000 343
    10.752    26.000 344
    45.364    24.000 345
    58.491    16.000 346
     6.399    33.000 347
    25.301    41.000 348
    25.368    26.000 349
    34.834    29.000 350
    42.264    24.000 351
    16.900    37.000 352
    37.620    19.000 353
    27.059    31.000 354
    53.553    15.000 355
    42.299    31.000 356
    19.353    26.000 357
    44.016    33.000 358
    12.815    35.000 359
    42.397    32.000 360
   -50.061    50.000 361
    14.053    32.000 362
    21.233    32.000 363
    42.777    31.000 364
    18.621    32.000 365
   -25.740    31.000 366
     3.924    34.000 367
     4.197    33.000 368
    21.341    23.000 369
    29.027    33.000 370
   -47.857    37.000 371
     7.689    47.000 372
    10.386    31.000 373
    14.861    31.000 374
    16.313    25.000 375
     4.836    32.000 376
    18.975    31.000 377
   -80.116    57.000 378
     8.816    34.000 379
   -24.076    34.000 380
    35.386    32.000 381
    44.672    33.000 382
    26.481    37.000 383
     7.051    29.000 384
     7.169    31.000 385
   -63.531    27.000 386
     1.815     1.000 387
    35.118    29.000 388
     5.476    34.000 389
    33.114    25.000 390
    27.658    30.000 391
   -23.605    18.000 392
   -36.320    42.000 393
   -70.697    11.000 394
     9.367    32.000 395
    47.601    28.000 396
     3.718    32.000 397
   -37.651    37.000 398
    37.930    32.000 399
    12.631    29.000 400
    25.671    28.000 401
   -18.815    25.000 402
    11.803    31.000 403
    27.568    33.000 404
     1.210    35.000 405
    27.603    33.000 406
    -2.536    22.000 407
    10.485    31.000 408
    35.560    32.000 409
    37.045    29.000 410
    24.780    33.000 411
    50.236    27.000 412
    12.750    29.000 413
    12.732    23.000 414
    -5.722    36.000 415
    10.470    37.000 416
   -32.411    40.000 417
    22.815    28.000 418
    -5.336    33.000 419
    14.625    29.000 420
    -8.559    32.000 421
     0.472    31.000 422
   -37.335    42.000 423
   -14.199    35.000 424
   -42.305    43.000 425
     5.533    32.000 426
   -66.695    21.000 427
    17.702    27.000 428
    15.469    22.000 429
   -35.833    39.000 430
    52.697     7.000 431
    14.508    32.000 432
   -35.185    49.000 433
   -26.970    30.000 434
   -11.469    40.000 435
     9.917    31.000 436
    25.447    23.000 437
   -80.452    60.000 438
    -1.307    34.000 439
    -6.756    28.000 440
    55.955    32.000 441
     8.764    27.000 442
     1.462    32.000 443
    36.787    29.000 444
    21.357    26.000 445
    18.056    32.000 446
    52.533    22.000 447
    30.502    28.000 448
    11.082    29.000 449
    37.007    31.000 450
    -3.673    32.000 451
    -2.485    33.000 452
   -16.520    48.000 453
    16.549    28.000 454
    -5.884    36.000 455
   -66.816    15.000 456
   -56.662    43.000 457
   -27.219    36.000 458
    17.078    26.000 459
    13.882    30.000 460
   -36.579    48.000 461
    20.022    43.000 462
    31.554    30.000 463
   -30.578    40.000 464
    58.119    36.000 465
   -52.676    49.000 466
   -68.744    52.000 467
     2.001    22.000 468
   -19.002    28.000 469
   -19.150    20.000 470
   -11.371    25.000 471
   -22.653    27.000 472
   -29.175    39.000 473
   -17.060    19.000 474
   -19.936    30.000 475
   -25.358    33.000 476
   -17.429    29.000 477
   -47.500    49.000 478
     7.609    30.000 479
     2.914    35.000 480
   -41.733    43.000 481
   -42.245    34.000 482
   -48.453    53.000 483
    10.157    28.000 484
   -36.729    17.000 485
    18.287    22.000 486
    58.553    22.000 487
    19.140    26.000 488
   -26.145    15.000 489
   -59.949    11.000 490
   -56.235    13.000 491
   -84.446    59.000 492
   -48.177    16.000 493
    48.611    12.000 494
    -8.777    23.000 495
    -2.408    28.000 496
     5.113    31.000 497
    -0.418    34.000 498
     4.830    30.000 499
     1.471    47.000 500
EOF

# Azimuth of the projection plane
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    67.871     0.100 Azimuth =  155
EOF
gmt end
