#!/bin/bash
gmt begin simeonof10.15_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases simeonof10.15'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000    -0.014
     1.500    -3.719
     2.000    -7.424
     2.500   -11.129
     3.000   -14.833
     3.500   -18.540
     4.000   -22.248
     4.500   -25.958
     5.000   -29.671
     5.500   -33.384
     6.000   -37.100
     6.500   -40.818
     7.000   -44.540
     7.500   -48.265
     8.000   -51.992
     8.500   -55.724
     9.000   -59.458
     9.500   -63.197
    10.000   -66.940
    10.500   -70.687
    11.000   -74.438
    11.500   -78.195
    12.000   -81.957
    12.500   -85.724
    13.000   -89.496
    13.500   -93.275
    14.000   -97.058
    14.500  -100.849
    15.000  -104.646
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -86.496 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     2.115
     1.000     0.062
     1.500    -1.678
     2.000    -3.368
     2.500    -5.042
     3.000    -6.709
     3.500    -8.375
     4.000   -10.040
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -13.040 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.505    -5.052     0.200
     9.673    -0.635     0.200
    10.539    10.323     0.200
    10.621     7.271     0.200
    11.215     6.711     0.200
    11.838   -10.419     0.200
     4.468    -4.339     0.200
    11.555    -6.148     0.200
     5.089    -6.283     0.200
     4.624    -7.286     0.200
     4.761    -3.805     0.200
    10.993    -9.535     0.200
     5.126    -5.588     0.200
     4.428    -6.247     0.200
    11.419    -6.513     0.200
     5.210    -8.880     0.200
     5.715    -6.929     0.200
     4.854    -5.664     0.200
     5.000    -4.563     0.200
     5.270    -4.626     0.200
    12.292    -7.649     0.200
     5.283    -3.640     0.200
     5.155    -5.019     0.200
     5.155    -6.523     0.200
     5.055    -6.465     0.200
     5.143    -6.227     0.200
     4.407    -5.475     0.200
     2.615    -6.648     0.200
     4.451    -4.518     0.200
    11.441   -11.435     0.200
     5.022    -5.853     0.200
     5.136    -4.226     0.200
     5.231    -4.409     0.200
     5.147    -6.982     0.200
     5.021    -6.497     0.200
     5.094    -6.842     0.200
     9.886    -6.943     0.200
     5.182    -5.399     0.200
     5.745    -6.650     0.200
    12.349   -13.512     0.200
    12.682    -3.413     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     5.884   -35.428     0.200
     6.254   -38.510     0.200
    15.805  -108.643     0.200
     5.367   -31.786     0.200
     5.557   -28.609     0.200
     6.076   -33.958     0.200
     7.118   -43.909     0.200
     7.898   -51.434     0.200
     8.509   -54.514     0.200
     8.535   -56.356     0.200
     9.286   -61.416     0.200
     9.684   -63.138     0.200
     9.748   -63.217     0.200
     8.814   -58.363     0.200
    15.258  -101.317     0.200
    12.551   -87.711     0.200
    15.269  -104.772     0.200
    12.442   -86.702     0.200
    15.218  -103.782     0.200
     5.600   -34.880     0.200
    12.333   -85.532     0.200
    17.348  -119.910     0.200
    18.681  -129.554     0.200
     5.204   -38.102     0.200
     0.236     5.608     0.200
     0.986     0.835     0.200
     1.425    -1.669     0.200
    12.062   -85.033     0.200
     4.405   -22.543     0.200
     4.656   -26.344     0.200
    12.018   -84.874     0.200
    16.825  -116.520     0.200
    11.879   -82.890     0.200
    16.622  -113.597     0.200
    12.601   -88.529     0.200
     3.466   -13.953     0.200
     4.743   -25.185     0.200
     5.177   -26.025     0.200
     5.231   -26.170     0.200
     5.378   -25.384     0.200
     6.244   -36.618     0.200
     6.342   -35.884     0.200
     6.831   -38.409     0.200
     6.893   -39.147     0.200
     7.122   -41.570     0.200
    12.376   -85.072     0.200
    18.716  -129.589     0.200
    12.514   -90.875     0.200
    17.277  -117.955     0.200
     1.693    -0.994     0.200
     1.296    -2.977     0.200
     3.963   -17.951     0.200
     4.338   -21.500     0.200
     5.338   -35.480     0.200
     5.090   -33.659     0.200
    11.997   -83.455     0.200
     4.803   -29.633     0.200
     3.206   -14.299     0.200
    11.590   -80.860     0.200
    10.575   -71.022     0.200
    10.980   -72.797     0.200
     0.980     0.077     0.200
     3.390   -13.735     0.200
     5.628   -36.956     0.200
    12.383   -88.878     0.200
     0.368     4.574     0.200
     1.693    -3.004     0.200
     3.190   -14.385     0.200
     3.358   -13.032     0.200
     3.692   -18.143     0.200
     5.330   -31.303     0.200
     0.429     4.939     0.200
    10.569   -71.752     0.200
    11.961   -85.025     0.200
    11.961   -85.020     0.200
    11.996   -84.067     0.200
    12.781   -86.491     0.200
    18.304  -128.478     0.200
    19.299  -133.949     0.200
     1.950    -7.657     0.200
     2.570   -10.596     0.200
     3.680   -16.388     0.200
     3.980   -23.897     0.200
     5.333   -37.451     0.200
     5.333   -34.731     0.200
     5.299   -27.393     0.200
     0.468     3.185     0.200
     1.451    -2.822     0.200
     1.409     0.559     0.200
     5.228   -35.764     0.200
    11.986   -86.049     0.200
    11.986   -86.044     0.200
    18.326  -127.487     0.200
     5.270   -36.157     0.200
    10.261   -63.476     0.200
    10.286   -69.367     0.200
    10.933   -70.351     0.200
    11.845   -73.833     0.200
     0.343     5.973     0.200
     3.357   -12.687     0.200
     4.359   -20.944     0.200
    10.305   -73.109     0.200
    10.324   -69.806     0.200
    11.908   -84.656     0.200
    16.994  -117.649     0.200
    18.255  -127.734     0.200
     0.368     5.407     0.200
     1.677    -1.363     0.200
     3.343   -13.336     0.200
     4.384   -24.668     0.200
     4.484   -22.547     0.200
     5.315   -33.526     0.200
    11.523   -80.698     0.200
    12.133   -88.702     0.200
     0.396     5.223     0.200
     1.777    -1.670     0.200
     2.129    -4.562     0.200
     0.772    -0.513     0.200
     2.707   -10.247     0.200
     4.831   -30.530     0.200
     5.126   -30.316     0.200
     5.126   -28.316     0.200
    18.731  -131.455     0.200
    19.791  -138.595     0.200
     3.475   -14.941     0.200
     4.490   -25.517     0.200
     5.576   -30.988     0.200
     6.806   -39.810     0.200
     8.373   -53.867     0.200
     9.574   -65.267     0.200
     9.726   -62.806     0.200
    18.324  -126.091     0.200
     0.728     0.981     0.200
     1.807    -5.732     0.200
     5.111   -34.042     0.200
    12.006   -85.842     0.200
     2.563   -11.089     0.200
     3.923   -23.536     0.200
     5.156   -29.199     0.200
     7.202   -48.223     0.200
    10.913   -80.071     0.200
     2.900   -14.353     0.200
     3.921   -21.499     0.200
     4.656   -26.620     0.200
     5.265   -35.891     0.200
     5.265   -33.246     0.200
     6.807   -42.743     0.200
     6.859   -43.806     0.200
     7.149   -44.103     0.200
     8.392   -55.392     0.200
     9.137   -61.184     0.200
     9.217   -57.847     0.200
     9.506   -67.039     0.200
     9.709   -66.719     0.200
     9.821   -63.969     0.200
    10.089   -63.806     0.200
    10.100   -67.033     0.200
    10.651   -71.107     0.200
    11.081   -73.132     0.200
     3.286   -12.646     0.200
     3.960   -18.198     0.200
    12.104   -86.220     0.200
    18.429  -129.994     0.200
     2.821   -14.041     0.200
     5.231   -33.950     0.200
     9.144   -59.198     0.200
    10.071   -66.025     0.200
    12.091   -85.999     0.200
     1.579    -5.155     0.200
     2.801   -13.513     0.200
     5.053   -30.877     0.200
     6.589   -42.862     0.200
     9.063   -60.943     0.200
    11.711   -83.510     0.200
     5.732   -37.006     0.200
    12.532   -89.142     0.200
    11.449   -85.313     0.200
     1.345    -0.623     0.200
     3.728   -14.888     0.200
     4.270   -19.469     0.200
     4.406   -20.850     0.200
     4.709   -26.792     0.200
     6.270   -38.790     0.200
     7.953   -51.120     0.200
     8.786   -54.571     0.200
     9.899   -62.958     0.200
    10.201   -66.665     0.200
    10.217   -65.725     0.200
    11.291   -76.570     0.200
    16.441  -111.600     0.200
     0.724     1.468     0.200
     5.064   -33.514     0.200
    11.965   -84.338     0.200
    16.752  -116.018     0.200
    20.580  -143.082     0.200
     5.687   -34.843     0.200
     2.907    -9.143     0.200
     3.011    -9.680     0.200
     3.052    -9.924     0.200
     5.729   -37.388     0.200
    12.535   -89.886     0.200
     0.863     1.652     0.200
     4.721   -31.456     0.200
     0.786     1.952     0.200
     4.898   -30.696     0.200
    11.838   -85.724     0.200
     0.591     2.189     0.200
     0.858     2.609     0.200
     2.963   -11.309     0.200
     3.500   -16.302     0.200
     3.639   -16.214     0.200
     4.068   -25.496     0.200
    10.298   -68.042     0.200
    10.371   -70.867     0.200
    10.746   -68.133     0.200
    10.833   -73.351     0.200
    11.008   -81.327     0.200
    11.126   -73.232     0.200
    12.475   -85.538     0.200
    12.606   -83.531     0.200
    12.736   -89.583     0.200
    12.817   -80.599     0.200
    14.716   -99.012     0.200
    15.252  -101.667     0.200
    15.799  -106.057     0.200
    15.966  -106.314     0.200
     1.104     0.074     0.200
     1.719    -7.123     0.200
     2.846    -7.583     0.200
     3.043   -10.768     0.200
     3.682   -20.139     0.200
     4.087   -26.587     0.200
     4.412   -26.556     0.200
     5.118   -30.858     0.200
     5.506   -34.361     0.200
     7.350   -49.914     0.200
     7.376   -49.991     0.200
     7.692   -50.438     0.200
    11.057   -83.926     0.200
    15.818  -112.381     0.200
    17.347  -122.956     0.200
     1.378    -3.583     0.200
     4.754   -30.053     0.200
    11.575   -82.352     0.200
     1.063     2.550     0.200
     0.807     2.315     0.200
     1.136    -0.868     0.200
     1.145    -0.957     0.200
     1.604    -4.811     0.200
     1.604    -4.643     0.200
     2.522    -9.829     0.200
    10.687   -75.119     0.200
     0.706     2.365     0.200
     1.065    -1.403     0.200
     1.796    -7.618     0.200
     2.700   -11.524     0.200
     2.821   -15.545     0.200
     3.572   -20.458     0.200
     3.604   -17.825     0.200
     3.812   -19.883     0.200
     4.133   -21.765     0.200
     4.370   -23.192     0.200
     4.614   -26.593     0.200
     4.971   -27.644     0.200
    11.188   -80.621     0.200
     1.474    -3.607     0.200
     4.468   -30.964     0.200
    11.555   -84.648     0.200
     0.688     1.946     0.200
     0.698     2.360     0.200
     5.531   -36.598     0.200
     1.492     1.167     0.200
     1.971    -7.587     0.200
     1.971    -6.684     0.200
     3.285   -15.336     0.200
     4.369   -24.313     0.200
     4.494   -25.498     0.200
     5.359   -36.285     0.200
     0.595     2.103     0.200
     1.335    -4.356     0.200
     4.678   -30.695     0.200
    11.534   -84.334     0.200
     5.089   -33.533     0.200
    11.999   -87.328     0.200
     4.659   -29.125     0.200
     0.369     6.967     0.200
     1.518    -4.593     0.200
     0.990     2.358     0.200
     0.987     3.356     0.200
     0.990     3.620     0.200
     1.104     3.297     0.200
     5.405   -35.182     0.200
    12.183   -86.390     0.200
     5.735   -30.366     0.200
     0.287     5.772     0.200
     0.713     1.736     0.200
     0.713     1.334     0.200
     1.334    -3.486     0.200
     1.425    -1.949     0.200
     2.367    -7.157     0.200
     2.683   -12.368     0.200
     3.048   -15.150     0.200
     3.718   -20.475     0.200
     3.898   -21.867     0.200
     4.034   -22.752     0.200
     4.122   -23.383     0.200
     4.320   -24.532     0.200
     4.363   -22.796     0.200
     4.624   -32.563     0.200
     4.867   -28.621     0.200
     4.863   -29.083     0.200
     5.025   -28.988     0.200
     5.125   -30.080     0.200
     5.423   -32.729     0.200
     5.586   -34.766     0.200
     5.863   -36.565     0.200
     5.912   -36.441     0.200
     6.694   -42.463     0.200
     6.719   -43.952     0.200
     7.297   -48.011     0.200
     7.331   -47.292     0.200
     7.499   -48.003     0.200
     7.557   -47.597     0.200
     0.885     1.902     0.200
     4.761   -30.879     0.200
     0.409     4.353     0.200
     0.409     4.064     0.200
     0.535     2.147     0.200
     0.538     1.976     0.200
     1.689    -1.075     0.200
     1.873    -2.308     0.200
     2.492    -6.604     0.200
     2.918   -15.625     0.200
     4.344   -25.488     0.200
     5.239   -35.246     0.200
    11.964   -87.651     0.200
     1.999    -7.560     0.200
     5.329   -38.011     0.200
    12.196   -87.482     0.200
     0.751     2.448     0.200
     4.185   -24.373     0.200
    10.993   -78.710     0.200
     0.809     1.123     0.200
     5.127   -32.034     0.200
     5.104   -32.145     0.200
    11.968   -83.469     0.200
     5.106   -32.679     0.200
    12.072   -86.777     0.200
     1.110     2.056     0.200
     1.125     0.706     0.200
     1.154     1.183     0.200
     1.488     0.003     0.200
     5.751   -36.608     0.200
     0.883     1.344     0.200
     1.149     0.008     0.200
     1.179     0.424     0.200
     2.401    -9.174     0.200
     3.355   -14.328     0.200
     5.771   -37.158     0.200
    17.463  -120.650     0.200
     1.121     2.365     0.200
     1.164     2.050     0.200
     1.498     0.776     0.200
     2.363    -6.165     0.200
     5.734   -35.615     0.200
     0.883     1.561     0.200
     2.866    -8.832     0.200
     3.008   -10.530     0.200
     5.776   -37.658     0.200
     5.126   -32.311     0.200
    12.056   -86.789     0.200
     0.541     2.323     0.200
     1.318    -3.154     0.200
     2.351   -12.056     0.200
     4.642   -30.667     0.200
     1.042     1.178     0.200
     1.053     0.869     0.200
     1.089     0.294     0.200
     1.837    -4.941     0.200
     5.757   -35.248     0.200
    12.534   -88.967     0.200
     1.119    -1.845     0.200
     1.825    -5.920     0.200
     2.008    -6.304     0.200
     2.010    -6.346     0.200
     3.432   -20.683     0.200
     0.568     3.981     0.200
     0.947     1.390     0.200
     1.201     0.965     0.200
     1.340    -2.582     0.200
     1.504    -3.908     0.200
     1.631    -4.388     0.200
     1.820    -7.828     0.200
     2.227    -9.050     0.200
     2.483   -10.599     0.200
     0.988     2.499     0.200
     1.003     2.594     0.200
     1.015     1.702     0.200
     1.051     1.463     0.200
     1.378    -0.589     0.200
     1.378     0.114     0.200
     1.372     3.925     0.200
     3.484   -18.276     0.200
     3.743   -18.802     0.200
     4.516   -25.865     0.200
     4.822   -25.903     0.200
     4.842   -26.266     0.200
     4.914   -27.853     0.200
     4.942   -27.787     0.200
     5.790   -32.796     0.200
     5.868   -38.851     0.200
     5.868   -36.224     0.200
     5.949   -34.847     0.200
     6.119   -35.134     0.200
     6.203   -35.749     0.200
     6.293   -36.355     0.200
     6.359   -38.786     0.200
     6.562   -37.622     0.200
     6.983   -41.687     0.200
     7.276   -45.846     0.200
     7.362   -45.931     0.200
     7.633   -47.368     0.200
     7.792   -51.544     0.200
     7.750   -47.681     0.200
     7.879   -48.620     0.200
     7.895   -48.857     0.200
     8.164   -50.650     0.200
     8.441   -53.078     0.200
     8.524   -54.223     0.200
     8.892   -56.341     0.200
     8.941   -57.055     0.200
     9.064   -57.635     0.200
     9.495   -61.662     0.200
     9.676   -62.269     0.200
     9.925   -66.351     0.200
    10.007   -64.132     0.200
    10.030   -66.160     0.200
    10.238   -66.940     0.200
    10.260   -65.547     0.200
    10.310   -67.069     0.200
    10.310   -67.614     0.200
    10.409   -69.023     0.200
    10.391   -66.892     0.200
    10.566   -68.261     0.200
    10.700   -70.139     0.200
    11.021   -72.190     0.200
     1.374    -0.955     0.200
     5.740   -34.795     0.200
    12.502   -91.062     0.200
     1.071     0.955     0.200
     3.191   -15.374     0.200
     3.479   -13.541     0.200
     4.701   -24.012     0.200
     4.764   -24.532     0.200
     5.084   -25.738     0.200
     5.592   -33.065     0.200
     5.681   -29.213     0.200
     6.128   -33.947     0.200
     6.088   -32.379     0.200
     6.200   -34.874     0.200
     6.294   -35.715     0.200
     6.594   -36.275     0.200
     6.594   -37.857     0.200
     6.930   -41.143     0.200
     7.121   -40.055     0.200
     7.138   -40.052     0.200
     7.248   -42.063     0.200
     7.458   -43.896     0.200
     9.168   -59.128     0.200
     9.666   -62.839     0.200
     1.806    -5.767     0.200
     2.688   -12.862     0.200
     0.579     3.253     0.200
     1.414    -3.107     0.200
     4.423   -28.843     0.200
     4.252   -20.980     0.200
     1.402    -4.254     0.200
     1.402    -4.533     0.200
     2.364   -11.012     0.200
     2.745   -12.589     0.200
     3.130   -14.675     0.200
     3.960   -20.597     0.200
     4.732   -31.186     0.200
    11.600   -82.950     0.200
     1.014     1.380     0.200
     1.176     0.151     0.200
     1.176     0.472     0.200
     1.146     0.651     0.200
     1.211     0.612     0.200
     1.211     1.513     0.200
     5.765   -38.106     0.200
     1.056     1.511     0.200
     1.056     1.956     0.200
     1.097     1.446     0.200
     1.097     2.031     0.200
     1.120     1.708     0.200
     1.120     2.044     0.200
     1.231     1.512     0.200
     1.281     0.531     0.200
     1.281     0.898     0.200
     1.404     0.530     0.200
     1.404     0.889     0.200
     1.422    -0.551     0.200
     1.202     0.347     0.200
     1.202     0.117     0.200
     2.100    -7.550     0.200
     3.923   -21.277     0.200
     1.127     0.775     0.200
     1.260     0.283     0.200
     1.251     0.915     0.200
     1.865    -5.083     0.200
     5.443   -37.268     0.200
     1.155     0.750     0.200
     1.215     0.359     0.200
     1.225    -0.796     0.200
     1.225    -0.397     0.200
     1.755    -4.672     0.200
     2.139    -6.570     0.200
     2.612    -9.126     0.200
     2.799   -11.481     0.200
     3.272   -13.171     0.200
     3.272   -15.542     0.200
     3.681   -16.640     0.200
     4.437   -18.896     0.200
     0.624     3.144     0.200
     2.917   -12.730     0.200
     4.326   -27.280     0.200
     1.188    -2.448     0.200
     4.241   -27.819     0.200
    11.279   -81.505     0.200
     0.353     3.687     0.200
     0.363     3.747     0.200
     0.653     2.676     0.200
     1.129    -1.017     0.200
     1.266    -3.168     0.200
     1.266    -3.006     0.200
     2.991   -13.882     0.200
     3.787   -20.010     0.200
     3.828   -20.903     0.200
     3.953   -22.033     0.200
     4.595   -29.611     0.200
     4.785   -27.807     0.200
     5.214   -32.104     0.200
     5.337   -32.389     0.200
     5.506   -34.297     0.200
     5.591   -34.333     0.200
     8.393   -55.033     0.200
     9.045   -60.010     0.200
    10.806   -70.542     0.200
    11.187   -75.200     0.200
    11.296   -76.559     0.200
    11.491   -75.247     0.200
    17.780  -123.692     0.200
     4.437   -29.435     0.200
     0.976     0.028     0.200
     1.229    -2.279     0.200
     1.229    -2.123     0.200
     1.510    -2.968     0.200
     1.698    -2.697     0.200
     1.751    -2.851     0.200
     1.983    -4.799     0.200
     3.760   -19.411     0.200
     4.125   -23.360     0.200
     4.149   -22.637     0.200
     4.388   -29.154     0.200
     4.647   -25.431     0.200
     8.856   -55.942     0.200
     1.869    -8.946     0.200
     2.936   -16.776     0.200
     4.360   -30.554     0.200
     4.316   -22.112     0.200
     4.807   -26.973     0.200
     1.023     1.555     0.200
     5.560   -37.575     0.200
    12.331   -88.396     0.200
     4.352   -29.698     0.200
     0.705     2.383     0.200
     1.423    -3.058     0.200
     4.340   -29.237     0.200
     4.376   -20.442     0.200
     0.349     4.188     0.200
     0.360     3.659     0.200
     0.515     3.924     0.200
     0.515     4.026     0.200
     1.283    -0.540     0.200
     1.042    -0.260     0.200
     3.103   -15.602     0.200
     4.867   -29.199     0.200
     5.477   -37.107     0.200
     0.400     3.454     0.200
     0.400     3.829     0.200
     0.410     3.030     0.200
     0.664     2.298     0.200
     0.664     1.657     0.200
     1.219    -4.088     0.200
     1.219    -2.705     0.200
     1.219    -2.923     0.200
     2.207   -10.784     0.200
     3.210   -15.814     0.200
     3.610   -20.007     0.200
     3.781   -21.098     0.200
     3.941   -20.585     0.200
     3.883   -20.943     0.200
     3.992   -22.406     0.200
     4.386   -24.511     0.200
     4.551   -29.927     0.200
     4.755   -28.808     0.200
     4.994   -27.981     0.200
     5.167   -28.819     0.200
     5.294   -32.592     0.200
     5.460   -35.102     0.200
     5.552   -33.652     0.200
     6.399   -38.099     0.200
     6.499   -41.803     0.200
     6.526   -40.128     0.200
     6.570   -42.032     0.200
     6.973   -44.444     0.200
     7.170   -46.450     0.200
     7.199   -45.246     0.200
     7.201   -45.669     0.200
     7.295   -46.765     0.200
     7.367   -46.090     0.200
     7.377   -47.380     0.200
     7.554   -47.675     0.200
     7.782   -50.738     0.200
     7.872   -50.308     0.200
     8.008   -53.084     0.200
     8.134   -53.729     0.200
     8.146   -52.681     0.200
     8.131   -52.201     0.200
     8.346   -56.471     0.200
     8.453   -57.372     0.200
     8.737   -57.121     0.200
     8.768   -56.507     0.200
     9.000   -60.752     0.200
     9.136   -60.513     0.200
     9.305   -62.560     0.200
     9.449   -63.173     0.200
     9.444   -63.194     0.200
     9.769   -63.038     0.200
    10.837   -69.986     0.200
    11.249   -72.245     0.200
    11.417   -81.388     0.200
    15.812  -117.289     0.200
    16.305  -114.719     0.200
    17.732  -124.029     0.200
     0.356     4.680     0.200
     0.684     1.777     0.200
     1.271    -3.726     0.200
     3.874   -17.330     0.200
     4.584   -31.210     0.200
    11.467   -85.825     0.200
     1.186    -2.440     0.200
     1.772    -7.208     0.200
     4.221   -28.091     0.200
    17.543  -124.295     0.200
     4.123   -18.156     0.200
     4.428   -29.472     0.200
     1.898    -7.442     0.200
     5.299   -34.021     0.200
     0.448     2.721     0.200
     0.530     1.839     0.200
     0.530     2.080     0.200
     0.924     0.716     0.200
     0.992     0.393     0.200
     1.005     0.520     0.200
     1.119    -0.631     0.200
     1.849    -6.363     0.200
     3.230   -12.146     0.200
     5.249   -36.848     0.200
    12.030   -88.795     0.200
     3.754   -18.097     0.200
     5.143   -34.422     0.200
    11.898   -76.268     0.200
    18.379  -129.188     0.200
     0.334     3.594     0.200
     0.334     4.203     0.200
     0.345     3.482     0.200
     0.516     3.923     0.200
     0.516     4.197     0.200
     2.378   -11.618     0.200
     3.377   -16.671     0.200
     4.709   -30.803     0.200
    16.475  -118.857     0.200
     0.699    -0.475     0.200
     0.699    -0.124     0.200
     5.544   -36.896     0.200
    12.283   -90.730     0.200
     0.687     0.172     0.200
     2.105    -8.611     0.200
     5.524   -35.645     0.200
     0.382     4.100     0.200
     0.477     4.502     0.200
     1.094    -1.027     0.200
     1.197    -0.322     0.200
     1.320    -3.151     0.200
     1.251    -0.964     0.200
     1.250    -0.965     0.200
     1.472    -2.221     0.200
     4.713   -32.429     0.200
     0.419     4.070     0.200
     0.662     3.014     0.200
     1.210    -2.519     0.200
     1.386    -1.231     0.200
     4.545   -30.464     0.200
     1.073    -0.422     0.200
     1.925    -5.121     0.200
     2.254    -6.890     0.200
     5.637   -37.053     0.200
     0.488     3.702     0.200
     0.488     3.108     0.200
     0.631     4.463     0.200
     0.724     3.180     0.200
     0.724     3.801     0.200
     0.843     2.373     0.200
     3.120   -18.512     0.200
     0.337     2.947     0.200
     0.459     3.521     0.200
     1.017     0.380     0.200
     1.042     0.763     0.200
     1.070     0.330     0.200
     1.183    -2.132     0.200
     1.237    -0.289     0.200
     1.247    -0.973     0.200
     1.682    -4.829     0.200
     5.077   -35.405     0.200
     0.429     4.017     0.200
     0.656     3.096     0.200
     0.808     0.490     0.200
     1.201    -2.537     0.200
     1.381    -0.862     0.200
     1.443    -1.436     0.200
     1.686    -2.753     0.200
     4.541   -31.159     0.200
    11.400   -85.334     0.200
     1.153     1.229     0.200
     1.307     0.603     0.200
     1.294    -0.127     0.200
     1.336     1.070     0.200
     1.309     1.009     0.200
     5.705   -37.795     0.200
    12.584   -89.023     0.200
     2.923   -14.878     0.200
     5.295   -34.986     0.200
     6.040   -31.701     0.200
     8.627   -49.011     0.200
     9.054   -57.053     0.200
    11.908   -77.619     0.200
     0.498     3.239     0.200
     3.019   -13.982     0.200
     4.142   -20.576     0.200
     4.407   -29.277     0.200
     4.395   -23.489     0.200
     4.639   -24.742     0.200
     6.720   -40.182     0.200
     8.875   -56.520     0.200
    11.400   -81.576     0.200
     3.294   -13.332     0.200
     3.781   -16.672     0.200
     5.270   -34.873     0.200
     6.168   -34.828     0.200
     8.708   -51.463     0.200
    10.252   -61.700     0.200
     0.419     4.094     0.200
     0.851     1.875     0.200
     0.897     2.412     0.200
     0.916     2.323     0.200
     1.069     0.761     0.200
     1.078     0.510     0.200
     1.258    -1.984     0.200
     1.422    -2.542     0.200
     5.217   -33.526     0.200
    11.955   -84.785     0.200
     0.404     4.740     0.200
     0.404     4.545     0.200
     0.827     2.486     0.200
     1.055     0.890     0.200
     4.341   -26.133     0.200
     5.225   -34.576     0.200
     9.656   -62.054     0.200
    11.755   -81.089     0.200
     0.371     5.199     0.200
     0.371     5.019     0.200
     0.808     2.512     0.200
     1.039     1.065     0.200
     1.232    -1.261     0.200
     5.214   -34.199     0.200
     3.135   -14.040     0.200
     3.850   -17.665     0.200
     0.342     3.637     0.200
     0.353     3.049     0.200
     0.527     3.472     0.200
     1.294    -0.732     0.200
     1.517    -2.435     0.200
     1.535    -1.532     0.200
     0.480     1.136     0.200
     0.480     1.172     0.200
     0.514     2.247     0.200
     0.889     1.465     0.200
     0.959     1.292     0.200
     0.971     1.393     0.200
     1.086     0.738     0.200
     1.107     0.141     0.200
     1.496    -2.191     0.200
     5.266   -35.023     0.200
     0.367     5.027     0.200
     0.367     4.652     0.200
     0.805     2.757     0.200
     1.036     1.761     0.200
     5.214   -34.854     0.200
     0.469     3.174     0.200
     0.865     1.774     0.200
     0.924     1.611     0.200
     0.940     1.815     0.200
     1.080     0.593     0.200
     1.087     0.019     0.200
     1.302    -2.139     0.200
     1.934    -3.453     0.200
     5.247   -35.502     0.200
     0.458     2.765     0.200
     0.435     4.214     0.200
     0.894     0.530     0.200
     0.937     1.568     0.200
     0.958     1.271     0.200
     1.070     0.765     0.200
     1.121    -0.660     0.200
     1.249    -0.460     0.200
     1.976    -3.147     0.200
     0.442     3.617     0.200
     0.880     1.744     0.200
     0.928     1.954     0.200
     0.947     1.684     0.200
     1.059     2.194     0.200
     1.097     0.472     0.200
     1.105    -0.029     0.200
     1.958    -4.209     0.200
     2.097    -5.065     0.200
     5.210   -33.896     0.200
    11.962   -86.380     0.200
     0.374     5.436     0.200
     0.374     5.018     0.200
     0.374     5.330     0.200
     0.518     2.757     0.200
     0.518     1.800     0.200
     0.831     3.090     0.200
     0.864     2.857     0.200
     1.062     1.889     0.200
     1.927    -3.394     0.200
     2.055    -4.609     0.200
     3.212   -14.725     0.200
     3.397   -16.357     0.200
     3.713   -17.820     0.200
     4.225   -23.870     0.200
     4.255   -23.779     0.200
     4.311   -24.124     0.200
     5.005   -28.753     0.200
     5.140   -30.596     0.200
     5.198   -33.138     0.200
     9.627   -61.586     0.200
    11.920   -89.584     0.200
    16.464  -118.129     0.200
    18.265  -128.418     0.200
     0.915     1.339     0.200
     0.873     1.084     0.200
     0.958     1.302     0.200
     1.029     1.667     0.200
     3.215   -12.206     0.200
     5.794   -37.544     0.200
    17.539  -122.479     0.200
     0.432     3.559     0.200
     0.511     1.188     0.200
     0.893     1.907     0.200
     0.911     2.110     0.200
     1.023     1.317     0.200
     1.059     0.832     0.200
     1.067     0.412     0.200
     1.921    -2.345     0.200
     3.152   -12.074     0.200
     3.551   -16.562     0.200
     5.235   -33.321     0.200
     0.847     2.276     0.200
     1.102     0.947     0.200
     5.708   -35.291     0.200
     3.353   -14.504     0.200
     4.281   -27.871     0.200
    11.391   -83.367     0.200
    15.879  -111.538     0.200
    17.652  -119.688     0.200
     4.234   -29.212     0.200
     0.878     0.145     0.200
     0.931     1.093     0.200
     1.011     2.174     0.200
     5.730   -38.075     0.200
     0.579     1.833     0.200
     3.484   -14.291     0.200
     3.527   -14.532     0.200
     3.066   -14.379     0.200
     4.108   -20.798     0.200
     4.858   -26.288     0.200
     5.478   -36.405     0.200
    12.312   -89.058     0.200
     3.135   -14.708     0.200
     3.893   -19.089     0.200
     0.930     1.223     0.200
     0.969     1.047     0.200
     3.388   -17.164     0.200
     4.415   -24.993     0.200
     5.150   -30.314     0.200
     5.758   -36.519     0.200
    12.301   -82.297     0.200
    12.488   -92.348     0.200
    12.832   -85.821     0.200
     3.901   -21.993     0.200
     4.633   -26.902     0.200
     5.241   -34.767     0.200
     2.353   -11.458     0.200
     2.353   -11.798     0.200
     3.051   -14.948     0.200
     3.127   -14.965     0.200
     3.352   -17.631     0.200
     1.844    -6.472     0.200
     2.890   -14.086     0.200
     3.907   -20.726     0.200
     0.508     4.872     0.200
     0.667     4.330     0.200
     0.707     3.252     0.200
     0.668     3.585     0.200
     0.676     3.958     0.200
     0.748    -0.010     0.200
     1.444     0.049     0.200
     1.814    -3.687     0.200
     2.244    -8.193     0.200
     2.651    -8.321     0.200
     2.694    -9.307     0.200
     2.694    -9.057     0.200
     4.407   -24.397     0.200
     5.121   -29.828     0.200
     5.713   -38.053     0.200
    12.342   -87.284     0.200
     1.136    -0.855     0.200
     1.200    -0.393     0.200
     5.728   -37.795     0.200
     0.442     3.893     0.200
     0.866     1.936     0.200
     0.917     1.675     0.200
     0.935     1.887     0.200
     1.083     0.658     0.200
     1.091     0.347     0.200
     1.274    -2.046     0.200
     1.800    -6.394     0.200
     5.222   -33.998     0.200
    11.970   -87.851     0.200
     1.217    -2.117     0.200
     3.048   -12.058     0.200
     3.268   -13.750     0.200
     3.623   -17.248     0.200
     3.697   -18.257     0.200
     4.325   -23.242     0.200
     4.816   -27.328     0.200
     9.744   -62.326     0.200
    11.034   -71.111     0.200
    11.276   -73.504     0.200
    11.335   -73.575     0.200
    11.424   -80.555     0.200
     0.519     2.721     0.200
     0.520     3.811     0.200
     4.192   -20.413     0.200
     4.469   -30.734     0.200
     0.373     5.208     0.200
     0.816     2.465     0.200
     1.036     1.245     0.200
     1.046     0.942     0.200
     1.397    -2.657     0.200
     1.769    -5.629     0.200
     1.912    -3.520     0.200
     2.896   -15.412     0.200
     3.197   -12.834     0.200
     3.893   -21.319     0.200
     4.612   -25.483     0.200
     5.210   -35.230     0.200
    11.927   -84.523     0.200
     2.868   -15.338     0.200
     0.832     2.730     0.200
     0.876     3.211     0.200
     0.896     2.956     0.200
     1.789    -5.228     0.200
     0.992     0.352     0.200
     5.699   -34.466     0.200
    12.448   -87.284     0.200
     0.434     2.093     0.200
     0.442     5.215     0.200
     0.813     1.172     0.200
     0.995     0.028     0.200
     1.046     0.862     0.200
     1.292    -2.678     0.200
     1.230    -0.899     0.200
     1.223    -0.317     0.200
     1.452    -2.084     0.200
     1.472    -2.577     0.200
     2.617   -12.268     0.200
     0.347     5.382     0.200
     0.794     2.945     0.200
     0.823     2.779     0.200
     0.847     2.472     0.200
     0.847     2.931     0.200
     0.957     2.174     0.200
     1.026     1.321     0.200
     1.394    -1.093     0.200
     1.761    -5.632     0.200
     2.904   -16.004     0.200
     3.046   -14.514     0.200
     5.208   -34.955     0.200
    11.913   -85.332     0.200
     0.489     2.627     0.200
     0.878     1.487     0.200
     0.942     1.226     0.200
     0.955     1.495     0.200
     1.092     0.631     0.200
     1.098     0.138     0.200
     1.317    -2.104     0.200
     1.839    -5.594     0.200
     2.907   -16.397     0.200
     3.203   -11.813     0.200
     3.584   -17.439     0.200
     5.254   -34.019     0.200
     0.825     1.782     0.200
     1.127    -0.569     0.200
     1.127    -0.360     0.200
     1.200    -0.587     0.200
     2.413    -8.507     0.200
     3.071   -12.220     0.200
     4.318   -24.749     0.200
     5.715   -38.470     0.200
    12.610   -88.403     0.200
     0.416     4.225     0.200
     0.416     3.555     0.200
     0.850     1.825     0.200
     0.914     2.046     0.200
     1.068     0.936     0.200
     1.077     0.341     0.200
     5.215   -34.245     0.200
     0.572     2.131     0.200
     4.996   -35.868     0.200
     0.411     4.825     0.200
     0.838     0.783     0.200
     0.882     2.692     0.200
     1.790    -4.866     0.200
     3.086   -13.964     0.200
     3.701   -17.362     0.200
     3.899   -21.339     0.200
     4.621   -25.924     0.200
     5.222   -34.047     0.200
     8.625   -52.862     0.200
     8.939   -57.310     0.200
     9.653   -63.354     0.200
    10.160   -65.512     0.200
    11.754   -78.337     0.200
    12.307   -81.381     0.200
     1.066     1.187     0.200
     1.167     0.896     0.200
     1.169     0.998     0.200
     5.318   -32.960     0.200
     0.814     1.479     0.200
     0.930     1.209     0.200
     0.938     0.632     0.200
     1.010     0.287     0.200
     2.042    -7.211     0.200
     0.573     2.501     0.200
     0.573     2.271     0.200
     0.563     4.101     0.200
     0.679     3.416     0.200
     0.693     3.458     0.200
     0.765     3.283     0.200
     0.767     2.759     0.200
     1.496    -2.751     0.200
     2.060    -7.468     0.200
     2.826    -9.065     0.200
     2.869    -9.383     0.200
     3.318   -15.499     0.200
     3.369   -13.945     0.200
     3.369   -15.136     0.200
     3.593   -17.114     0.200
     4.933   -30.726     0.200
     5.526   -36.307     0.200
     5.669   -29.551     0.200
    12.175   -87.333     0.200
     0.367     3.585     0.200
     0.522     3.658     0.200
     1.307    -3.567     0.200
     1.241    -0.229     0.200
     1.293    -0.491     0.200
     1.535    -1.529     0.200
     2.643   -11.873     0.200
     3.045   -14.302     0.200
     4.684   -30.089     0.200
     1.089     2.942     0.200
     1.124     3.003     0.200
     1.839    -2.423     0.200
     2.360    -5.378     0.200
     3.579   -13.395     0.200
     5.742   -36.455     0.200
     0.660     2.312     0.200
     0.799     1.585     0.200
     0.919     0.946     0.200
     0.930     0.726     0.200
     0.992     0.423     0.200
     3.120   -15.703     0.200
     3.120   -16.213     0.200
     3.361   -15.917     0.200
     3.503   -13.561     0.200
     4.140   -21.638     0.200
     4.873   -26.673     0.200
     5.480   -35.303     0.200
     9.214   -56.695     0.200
     1.226    -3.335     0.200
     2.839   -11.794     0.200
     4.292   -28.150     0.200
    11.327   -80.371     0.200
     0.909     1.700     0.200
     0.909     1.349     0.200
     3.807   -16.949     0.200
     4.854   -30.789     0.200
     4.854   -30.027     0.200
    11.842   -81.998     0.200
     1.103     1.400     0.200
     3.454   -11.539     0.200
     4.769   -23.085     0.200
     5.735   -34.638     0.200
     0.713     1.743     0.200
     4.029   -17.483     0.200
     5.040   -33.946     0.200
     0.584     4.094     0.200
     3.511   -16.051     0.200
     4.005   -19.127     0.200
     4.384   -22.429     0.200
     8.796   -54.480     0.200
    16.724  -118.105     0.200
     2.691   -13.426     0.200
     3.531   -16.552     0.200
     4.011   -19.782     0.200
     4.513   -27.082     0.200
     9.611   -64.410     0.200
    12.168   -79.663     0.200
     0.987     0.084     0.200
     2.563    -8.894     0.200
     5.212   -34.440     0.200
    12.188   -88.983     0.200
    18.570  -126.287     0.200
     2.822   -10.876     0.200
     5.237   -36.798     0.200
    12.221   -89.075     0.200
     1.104    -2.001     0.200
     1.917    -7.657     0.200
     2.754   -10.727     0.200
     2.840   -11.084     0.200
     3.547   -18.455     0.200
     3.547   -19.088     0.200
     3.652   -19.284     0.200
     3.871   -21.803     0.200
     4.651   -26.644     0.200
     5.292   -34.970     0.200
    12.297   -85.855     0.200
    18.595  -127.637     0.200
     0.997    -0.264     0.200
     2.805    -9.831     0.200
     1.067     0.649     0.200
     2.167    -7.683     0.200
     2.911   -15.351     0.200
     3.883   -17.371     0.200
     5.392   -38.166     0.200
    18.668  -129.072     0.200
     3.503   -17.054     0.200
     3.608   -16.805     0.200
     5.310   -35.085     0.200
     2.789   -11.696     0.200
     5.413   -34.903     0.200
    10.377   -62.141     0.200
    12.243   -80.411     0.200
    12.404   -79.997     0.200
    12.407   -90.867     0.200
    18.709  -129.162     0.200
     1.017     1.024     0.200
     0.605     2.837     0.200
     5.433   -37.019     0.200
     9.907   -65.838     0.200
     1.142    -0.237     0.200
     5.339   -35.483     0.200
     0.865     1.260     0.200
     0.865     0.682     0.200
     1.872    -6.086     0.200
     2.667   -12.668     0.200
     3.553   -15.966     0.200
     3.724   -21.468     0.200
     5.120   -33.179     0.200
     9.589   -64.190     0.200
     0.990     0.768     0.200
     0.972     1.247     0.200
     0.972     0.138     0.200
     1.972    -7.289     0.200
     3.662   -16.811     0.200
     3.777   -20.791     0.200
     4.550   -25.894     0.200
     5.186   -35.039     0.200
    12.162   -88.184     0.200
    18.465  -127.384     0.200
     1.702    -4.813     0.200
     3.600   -19.559     0.200
     5.239   -35.318     0.200
     9.712   -64.724     0.200
     0.929     0.643     0.200
     2.667   -11.953     0.200
     3.729   -19.221     0.200
     4.059   -17.670     0.200
     5.134   -34.535     0.200
    12.101   -86.813     0.200
     1.128     1.575     0.200
     2.751   -10.039     0.200
     3.555   -17.564     0.200
    12.394   -88.776     0.200
     0.983     0.359     0.200
     2.814   -10.335     0.200
     5.215   -34.430     0.200
     5.272   -34.029     0.200
     2.753   -11.146     0.200
     3.684   -21.042     0.200
     5.169   -33.133     0.200
    16.787  -117.879     0.200
     3.546   -15.010     0.200
     5.133   -33.746     0.200
    12.080   -85.133     0.200
     2.829   -11.098     0.200
     3.721   -19.792     0.200
     5.222   -34.219     0.200
     2.453    -8.591     0.200
     2.574    -9.336     0.200
     2.641   -10.019     0.200
     2.802   -11.849     0.200
     2.888   -11.720     0.200
     3.701   -20.565     0.200
     5.260   -34.091     0.200
     2.734   -10.781     0.200
     2.824   -11.071     0.200
     3.642   -18.479     0.200
     5.270   -34.582     0.200
    12.263   -85.570     0.200
    18.564  -127.226     0.200
     1.215    -1.458     0.200
     5.318   -34.907     0.200
    12.357   -88.015     0.200
    18.648  -128.009     0.200
     3.613   -16.580     0.200
     5.383   -36.377     0.200
     2.406    -8.673     0.200
     2.857   -11.719     0.200
     3.582   -19.060     0.200
     3.685   -20.102     0.200
     4.056   -22.982     0.200
     5.178   -34.218     0.200
     9.651   -63.355     0.200
    10.526   -68.199     0.200
    12.183   -81.215     0.200
    12.163   -87.077     0.200
    16.792  -117.990     0.200
    18.464  -127.130     0.200
     2.021    -6.229     0.200
     5.373   -36.014     0.200
     2.473   -10.328     0.200
     2.594    -9.525     0.200
     2.663   -11.214     0.200
     2.913   -12.905     0.200
     3.787   -18.871     0.200
     5.211   -33.168     0.200
    12.198   -78.991     0.200
    12.230   -86.186     0.200
    18.525  -126.816     0.200
     5.353   -36.092     0.200
     2.819   -11.037     0.200
     3.632   -18.132     0.200
     5.305   -36.657     0.200
     2.768    -9.927     0.200
     3.498   -17.682     0.200
     3.498   -17.801     0.200
     3.975   -21.888     0.200
     5.214   -34.447     0.200
    12.165   -84.673     0.200
     2.598    -9.404     0.200
     2.759    -9.939     0.200
     2.841   -11.588     0.200
     3.544   -17.970     0.200
     3.650   -19.300     0.200
     3.688   -18.347     0.200
     4.008   -22.178     0.200
     5.319   -34.811     0.200
    12.305   -82.888     0.200
    12.330   -87.799     0.200
     5.198   -33.976     0.200
    12.154   -84.270     0.200
     0.886     0.928     0.200
     0.886     0.818     0.200
     2.677   -13.039     0.200
     2.551    -9.772     0.200
     2.706   -10.250     0.200
     3.553   -16.396     0.200
     5.135   -32.734     0.200
    12.087   -84.551     0.200
    12.156   -80.918     0.200
     0.905     0.748     0.200
     0.905     0.328     0.200
     3.546   -16.046     0.200
     4.024   -20.710     0.200
     5.155   -33.828     0.200
     6.467   -35.639     0.200
    12.111   -88.895     0.200
     0.558     2.377     0.200
     2.172    -7.982     0.200
     3.547   -18.339     0.200
     4.010   -21.691     0.200
     5.336   -36.229     0.200
     1.154     1.047     0.200
     1.980    -5.253     0.200
     2.473    -7.664     0.200
     2.594    -8.388     0.200
     5.264   -31.760     0.200
     9.741   -59.322     0.200
    10.541   -65.460     0.200
    12.292   -85.393     0.200
    18.585  -127.856     0.200
     2.183    -7.150     0.200
     3.458   -16.294     0.200
     3.564   -17.706     0.200
     3.922   -20.196     0.200
     5.385   -38.176     0.200
    12.374   -88.055     0.200
     5.348   -36.803     0.200
    12.343   -90.370     0.200
     2.825   -13.698     0.200
     3.530   -16.638     0.200
     3.899   -21.836     0.200
     5.321   -36.671     0.200
     9.796   -63.386     0.200
    12.325   -88.960     0.200
     1.840    -5.650     0.200
     2.363    -8.068     0.200
     2.807   -11.584     0.200
     3.526   -17.222     0.200
     3.630   -19.141     0.200
     3.997   -21.858     0.200
     5.252   -36.861     0.200
     8.914   -56.238     0.200
     9.725   -64.447     0.200
    10.466   -66.939     0.200
    12.256   -82.271     0.200
    12.233   -88.885     0.200
     0.610     3.105     0.200
     0.620     2.984     0.200
     3.526   -17.734     0.200
     5.386   -35.901     0.200
    12.407   -88.757     0.200
     0.571     2.753     0.200
     5.364   -35.122     0.200
     5.283   -36.240     0.200
    12.264   -86.978     0.200
     3.543   -17.680     0.200
     5.270   -34.880     0.200
    12.265   -87.347     0.200
     0.568     2.934     0.200
     0.579     2.765     0.200
     2.820   -10.919     0.200
     3.518   -16.900     0.200
     3.980   -20.444     0.200
     5.361   -35.753     0.200
     1.056     0.516     0.200
     2.368    -7.830     0.200
     2.557    -9.809     0.200
     5.285   -33.227     0.200
     9.759   -61.168     0.200
    10.457   -64.481     0.200
    12.273   -86.047     0.200
     2.880   -16.155     0.200
     2.741   -10.472     0.200
     5.363   -35.076     0.200
    12.340   -88.440     0.200
     0.957     0.753     0.200
     0.957     0.583     0.200
     2.798   -10.128     0.200
     5.212   -34.778     0.200
     0.926     1.187     0.200
     2.572    -9.161     0.200
     2.835   -10.183     0.200
     5.145   -32.627     0.200
    16.778  -116.787     0.200
     0.837     0.878     0.200
     0.837     1.619     0.200
     2.668   -12.838     0.200
     3.542   -15.047     0.200
     3.542   -18.457     0.200
     5.115   -34.057     0.200
    10.496   -65.694     0.200
    11.885   -79.341     0.200
    12.052   -86.268     0.200
    12.143   -81.813     0.200
    16.773  -116.401     0.200
    18.362  -126.877     0.200
     0.995    -0.382     0.200
     3.643   -16.123     0.200
     5.223   -35.315     0.200
     5.267   -35.649     0.200
    12.262   -80.602     0.200
     2.800   -10.608     0.200
     3.502   -16.752     0.200
     3.608   -17.465     0.200
     3.966   -20.257     0.200
     4.711   -28.155     0.200
     5.352   -37.174     0.200
    12.352   -88.499     0.200
     1.204     0.772     0.200
     3.523   -15.244     0.200
     3.982   -19.390     0.200
     3.982   -19.632     0.200
     5.390   -35.352     0.200
    10.443   -64.995     0.200
     0.985     2.418     0.200
     5.267   -33.697     0.200
    10.431   -63.081     0.200
    11.921   -75.891     0.200
    12.067   -77.338     0.200
    12.232   -87.028     0.200
     1.702    -4.847     0.200
     1.792    -5.353     0.200
     2.071    -8.824     0.200
     5.261   -36.188     0.200
    12.257   -90.875     0.200
     2.818   -11.437     0.200
     5.362   -36.863     0.200
    12.371   -89.995     0.200
    18.669  -133.466     0.200
     2.179    -8.723     0.200
     2.817   -11.248     0.200
     3.516   -16.980     0.200
     5.356   -36.603     0.200
    12.364   -88.440     0.200
     3.520   -17.587     0.200
     3.992   -21.531     0.200
    12.232   -88.300     0.200
     1.153    -2.276     0.200
     1.967    -5.975     0.200
     2.140    -9.603     0.200
     2.565    -9.960     0.200
     2.632   -10.569     0.200
     2.077    -7.896     0.200
     2.574    -9.698     0.200
     1.072    -0.315     0.200
     1.072    -0.534     0.200
     2.100    -7.763     0.200
     3.624   -16.498     0.200
     3.642   -15.911     0.200
     5.296   -35.039     0.200
     1.928    -7.609     0.200
     2.541    -9.139     0.200
     2.804   -11.141     0.200
     3.537   -18.809     0.200
     3.640   -18.454     0.200
     0.379     3.769     0.200
     0.390     5.016     0.200
     1.026    -0.369     0.200
     1.875    -5.966     0.200
     1.992    -8.134     0.200
     2.431    -9.138     0.200
     2.623   -10.447     0.200
     2.879   -12.448     0.200
     0.336     4.757     0.200
     0.347     4.962     0.200
     0.973     1.027     0.200
     0.973     0.418     0.200
     1.556    -2.377     0.200
     1.631    -2.317     0.200
     1.825    -4.733     0.200
     1.957    -7.387     0.200
     2.398    -7.604     0.200
     2.521    -8.424     0.200
     2.592   -10.441     0.200
     2.749   -10.857     0.200
     2.851   -12.403     0.200
     2.950   -10.781     0.200
     3.306   -17.088     0.200
     3.598   -17.924     0.200
     3.578   -19.489     0.200
     3.742   -18.830     0.200
     3.698   -18.719     0.200
     3.727   -19.153     0.200
     3.752   -18.644     0.200
     3.851   -19.923     0.200
     4.053   -24.136     0.200
     4.151   -22.898     0.200
     4.203   -22.557     0.200
     4.279   -22.813     0.200
     4.451   -26.575     0.200
     4.700   -27.858     0.200
     4.853   -29.729     0.200
     5.044   -32.586     0.200
     5.166   -35.625     0.200
     5.557   -35.177     0.200
     5.555   -32.891     0.200
    12.145   -89.194     0.200
     3.619   -18.993     0.200
     3.619   -17.376     0.200
     3.636   -17.848     0.200
     3.636   -17.207     0.200
     3.988   -21.151     0.200
     4.139   -22.082     0.200
     4.139   -21.121     0.200
     4.214   -23.592     0.200
     4.214   -22.038     0.200
     5.245   -36.100     0.200
     0.855     2.487     0.200
     0.855     1.370     0.200
     3.578   -15.497     0.200
     3.593   -16.510     0.200
     5.195   -32.939     0.200
    12.125   -86.670     0.200
    16.850  -118.243     0.200
    18.437  -128.968     0.200
     0.905     1.371     0.200
     0.905     0.449     0.200
     5.204   -34.847     0.200
    12.151   -85.596     0.200
     5.355   -36.577     0.200
     0.877     0.263     0.200
     2.705    -9.694     0.200
     5.128   -33.974     0.200
    12.078   -85.873     0.200
     0.995     0.054     0.200
     2.566    -9.991     0.200
     2.825   -10.349     0.200
     2.906   -12.205     0.200
     3.803   -22.475     0.200
     3.651   -15.828     0.200
     3.674   -17.070     0.200
     4.171   -22.464     0.200
     5.214   -35.235     0.200
    12.193   -89.544     0.200
     1.032    -0.173     0.200
     2.068    -7.207     0.200
     3.616   -16.599     0.200
     3.637   -17.029     0.200
     3.981   -20.891     0.200
     5.277   -33.768     0.200
    12.258   -86.171     0.200
     2.693   -10.202     0.200
     1.159    -0.914     0.200
     1.977    -5.674     0.200
     2.645    -9.915     0.200
     2.807    -9.686     0.200
     2.889   -11.249     0.200
     3.592   -18.796     0.200
     3.689   -17.666     0.200
     3.697   -17.788     0.200
     3.717   -18.285     0.200
     3.743   -17.656     0.200
     4.156   -21.786     0.200
     4.281   -22.801     0.200
     4.319   -23.526     0.200
     5.288   -34.928     0.200
    18.606  -128.977     0.200
     1.047     1.858     0.200
     5.158   -34.724     0.200
     1.044     1.246     0.200
     2.434    -8.385     0.200
     2.556   -10.216     0.200
     2.707   -12.154     0.200
     3.698   -20.111     0.200
     3.721   -19.082     0.200
     5.195   -32.873     0.200
    18.493  -130.097     0.200
     1.960    -7.074     0.200
     2.477    -9.144     0.200
     2.721   -15.337     0.200
     2.547    -9.551     0.200
     2.705   -11.131     0.200
     2.808   -11.584     0.200
     2.890   -11.644     0.200
     2.906   -11.761     0.200
     2.921   -12.514     0.200
     3.308   -17.830     0.200
     3.670   -19.928     0.200
     3.565   -18.393     0.200
     3.783   -24.123     0.200
     3.649   -17.955     0.200
     4.554   -29.652     0.200
     5.188   -36.168     0.200
    12.152   -91.009     0.200
     2.814   -10.784     0.200
     5.352   -35.662     0.200
     2.904   -11.318     0.200
     3.999   -20.941     0.200
     4.152   -21.443     0.200
     5.310   -35.527     0.200
    12.301   -80.717     0.200
     0.626     2.654     0.200
     0.637     2.780     0.200
     2.248    -8.209     0.200
     2.486    -8.499     0.200
     2.714   -10.154     0.200
     2.786   -11.604     0.200
     2.923   -14.562     0.200
     2.860   -12.430     0.200
     2.886   -12.231     0.200
     2.895   -11.758     0.200
     3.477   -17.851     0.200
     3.477   -18.781     0.200
     3.504   -17.440     0.200
     3.598   -18.125     0.200
     3.573   -18.403     0.200
     3.936   -23.016     0.200
     3.936   -21.258     0.200
     4.037   -23.550     0.200
     4.037   -21.511     0.200
     5.426   -35.381     0.200
    12.435   -89.460     0.200
     2.592    -9.184     0.200
     2.714   -12.488     0.200
     2.848   -11.278     0.200
     2.929   -11.990     0.200
     2.961   -11.460     0.200
     3.340   -14.784     0.200
     3.572   -18.340     0.200
     3.572   -17.102     0.200
     3.600   -17.209     0.200
     3.694   -19.321     0.200
     3.670   -17.789     0.200
     3.675   -18.228     0.200
     4.045   -21.541     0.200
     4.143   -22.416     0.200
     4.307   -23.566     0.200
     5.193   -34.354     0.200
     6.538   -38.273     0.200
    12.178   -86.036     0.200
     0.949     0.851     0.200
     2.817   -11.433     0.200
     2.916   -10.938     0.200
     3.546   -18.890     0.200
     5.185   -34.033     0.200
    12.152   -86.611     0.200
     0.922     1.878     0.200
     0.922     1.269     0.200
     2.908   -11.625     0.200
     2.939   -12.012     0.200
     3.272   -17.337     0.200
     3.558   -17.164     0.200
     3.586   -17.641     0.200
     3.684   -18.863     0.200
     4.298   -23.735     0.200
     5.153   -31.023     0.200
    16.788  -119.032     0.200
    18.421  -129.033     0.200
     2.605   -10.440     0.200
     2.834   -11.316     0.200
     2.920   -12.023     0.200
     3.814   -23.095     0.200
     4.598   -29.354     0.200
     5.242   -35.262     0.200
     1.004     1.012     0.200
     0.741     2.711     0.200
     2.166    -7.803     0.200
     2.622    -9.062     0.200
     2.787   -10.884     0.200
     2.847   -10.549     0.200
     3.644   -16.579     0.200
     3.971   -20.441     0.200
     4.074   -21.544     0.200
     5.486   -36.935     0.200
     2.735    -9.768     0.200
     2.830   -10.546     0.200
     2.910   -11.843     0.200
     3.646   -16.142     0.200
     3.674   -17.215     0.200
     4.118   -21.337     0.200
     4.282   -22.952     0.200
     5.236   -35.230     0.200
     1.825    -5.723     0.200
     2.840   -10.877     0.200
     3.602   -17.620     0.200
     3.946   -21.858     0.200
     4.098   -21.158     0.200
     5.305   -36.134     0.200
    12.278   -88.147     0.200
     2.783    -9.839     0.200
     2.863   -10.762     0.200
     3.503   -16.735     0.200
     3.629   -15.831     0.200
     3.975   -19.616     0.200
     4.073   -20.028     0.200
     4.126   -19.477     0.200
     4.200   -21.138     0.200
     4.421   -22.368     0.200
     4.542   -22.915     0.200
     5.262   -35.147     0.200
     2.889   -11.287     0.200
     3.517   -15.858     0.200
     3.614   -17.044     0.200
     3.614   -16.755     0.200
     3.622   -17.032     0.200
     3.622   -16.821     0.200
     3.982   -19.774     0.200
     4.136   -20.701     0.200
     4.207   -21.314     0.200
     4.686   -28.823     0.200
     5.327   -35.603     0.200
    12.326   -87.561     0.200
     1.936    -5.276     0.200
     1.906    -5.272     0.200
     2.890   -10.774     0.200
     3.616   -16.624     0.200
     3.624   -16.860     0.200
     3.624   -16.590     0.200
     3.985   -18.725     0.200
     4.085   -20.255     0.200
     4.138   -20.478     0.200
     4.210   -21.668     0.200
     5.320   -33.864     0.200
     2.816   -13.473     0.200
     2.880   -10.485     0.200
     2.956   -11.437     0.200
     2.991   -11.667     0.200
     3.675   -16.971     0.200
     3.703   -17.070     0.200
     4.040   -20.826     0.200
     5.323   -37.216     0.200
    10.502   -65.491     0.200
    12.352   -89.872     0.200
     0.905     1.455     0.200
     2.852   -11.703     0.200
     2.936   -11.207     0.200
     2.950   -10.822     0.200
     2.967   -12.812     0.200
     3.589   -19.535     0.200
     3.618   -17.946     0.200
     3.688   -17.532     0.200
     4.165   -23.094     0.200
     4.216   -22.590     0.200
     4.294   -23.617     0.200
     5.108   -33.676     0.200
    12.071   -87.412     0.200
    18.376  -127.157     0.200
     2.260    -6.913     0.200
     2.899   -11.998     0.200
     2.843   -10.012     0.200
     3.557   -15.862     0.200
     3.654   -16.087     0.200
     3.987   -19.509     0.200
     4.089   -20.826     0.200
     4.144   -21.779     0.200
     4.212   -22.241     0.200
     5.410   -35.008     0.200
    12.382   -81.172     0.200
    12.439   -89.830     0.200
    18.733  -128.377     0.200
     0.696     3.536     0.200
     2.872   -11.428     0.200
     2.944   -11.497     0.200
     3.654   -17.411     0.200
     3.579   -17.144     0.200
     3.648   -17.774     0.200
     3.676   -17.628     0.200
     4.230   -22.387     0.200
     5.433   -37.377     0.200
     9.363   -59.915     0.200
     9.912   -63.709     0.200
    10.460   -64.699     0.200
     2.120    -7.686     0.200
     3.469   -18.352     0.200
     3.647   -18.153     0.200
     3.822   -20.021     0.200
     3.988   -21.423     0.200
     4.213   -22.519     0.200
     5.310   -36.544     0.200
    14.032   -93.988     0.200
     1.000     1.453     0.200
     1.000     0.554     0.200
     5.197   -33.649     0.200
     2.827   -11.730     0.200
     3.637   -15.981     0.200
     3.644   -16.798     0.200
     3.665   -16.773     0.200
     5.275   -34.340     0.200
     0.897     0.402     0.200
     3.582   -15.163     0.200
     5.218   -33.792     0.200
     2.177    -8.484     0.200
     2.410    -8.798     0.200
     2.476    -9.422     0.200
     2.507    -9.230     0.200
     2.609    -9.555     0.200
     2.653   -13.178     0.200
     2.766   -10.488     0.200
     2.872   -11.880     0.200
     2.955   -13.150     0.200
     2.986   -12.609     0.200
     3.263   -17.291     0.200
     3.554   -18.701     0.200
     3.604   -17.526     0.200
     3.604   -18.761     0.200
     3.632   -18.291     0.200
     3.698   -20.066     0.200
     3.716   -23.240     0.200
     3.702   -18.148     0.200
     3.730   -19.136     0.200
     4.081   -21.647     0.200
     4.081   -23.757     0.200
     4.343   -24.742     0.200
     5.124   -34.632     0.200
    12.101   -89.710     0.200
    16.051  -117.947     0.200
    16.051  -118.518     0.200
    18.404  -129.345     0.200
     1.972    -6.819     0.200
     2.234    -8.476     0.200
     2.534    -9.989     0.200
     2.564    -9.806     0.200
     2.832   -11.415     0.200
     2.913   -12.256     0.200
     2.945   -11.484     0.200
     3.321   -18.127     0.200
     3.558   -18.461     0.200
     3.657   -18.028     0.200
     3.662   -18.323     0.200
     4.551   -28.114     0.200
     5.187   -34.907     0.200
     9.067   -61.178     0.200
    12.162   -88.958     0.200
    18.465  -131.379     0.200
     1.909    -5.508     0.200
     2.749   -11.707     0.200
     2.852   -15.324     0.200
     2.852   -14.713     0.200
     2.754   -10.087     0.200
     2.832   -10.910     0.200
     2.908   -11.753     0.200
     3.531   -17.633     0.200
     3.558   -17.460     0.200
     3.627   -17.765     0.200
     3.636   -16.497     0.200
     3.928   -22.365     0.200
     3.992   -20.871     0.200
     3.992   -21.031     0.200
     3.992   -20.020     0.200
     4.093   -21.407     0.200
     4.093   -20.496     0.200
     4.147   -20.738     0.200
     4.711   -28.063     0.200
     5.354   -36.069     0.200
     0.821     1.656     0.200
     0.821     1.857     0.200
     1.841    -5.933     0.200
     2.098    -6.440     0.200
     5.105   -33.463     0.200
     0.433     3.526     0.200
     1.046     2.566     0.200
     1.263    -1.798     0.200
     1.327    -1.958     0.200
     1.790    -6.885     0.200
     2.880   -17.019     0.200
     3.221   -11.962     0.200
     5.214   -34.137     0.200
    11.960   -83.943     0.200
     2.196    -7.355     0.200
     2.758    -9.911     0.200
     2.834   -10.898     0.200
     2.910   -11.891     0.200
     3.628   -17.171     0.200
     3.992   -22.834     0.200
     4.093   -22.944     0.200
     5.362   -36.149     0.200
    12.378   -88.897     0.200
     1.013     1.366     0.200
     2.080    -7.092     0.200
     2.832   -10.357     0.200
     2.852   -10.515     0.200
     5.305   -36.016     0.200
    12.274   -85.105     0.200
     1.046     2.105     0.200
     5.310   -34.777     0.200
     2.548    -9.095     0.200
     2.615   -10.596     0.200
     2.645   -10.010     0.200
     2.815   -11.702     0.200
     2.895   -11.164     0.200
     3.402   -16.405     0.200
     3.560   -16.796     0.200
     3.653   -16.627     0.200
     3.658   -17.014     0.200
     4.101   -21.461     0.200
     5.257   -32.999     0.200
     1.407    -3.883     0.200
     2.756   -10.255     0.200
     2.873   -11.731     0.200
     2.959   -12.825     0.200
     2.970   -11.668     0.200
     3.617   -18.407     0.200
     5.048   -34.636     0.200
    12.002   -87.631     0.200
     0.945     2.401     0.200
     0.945     1.962     0.200
     2.005    -6.428     0.200
     2.840   -11.416     0.200
     2.857   -10.735     0.200
     2.872   -10.459     0.200
     3.484   -15.383     0.200
     3.513   -16.303     0.200
     3.583   -15.975     0.200
     4.109   -21.248     0.200
     5.244   -34.010     0.200
     0.581     1.872     0.200
     1.935    -7.398     0.200
     2.547   -10.758     0.200
     3.243   -16.268     0.200
     5.338   -36.258     0.200
     5.987   -30.451     0.200
    12.112   -87.542     0.200
     1.350    -0.625     0.200
     1.350     0.473     0.200
     2.860    -9.830     0.200
     2.976   -14.433     0.200
     2.930   -10.552     0.200
     2.967   -10.036     0.200
     3.556   -15.282     0.200
     3.652   -15.756     0.200
     3.725   -17.002     0.200
     1.072     1.234     0.200
     1.072    -0.336     0.200
     2.129    -7.104     0.200
     2.849   -10.552     0.200
     2.882   -10.972     0.200
     3.478   -15.752     0.200
     3.479   -15.986     0.200
     3.507   -15.625     0.200
     3.577   -15.408     0.200
     3.946   -19.687     0.200
     4.046   -19.965     0.200
     5.336   -35.569     0.200
     3.657   -17.333     0.200
     3.998   -21.478     0.200
     0.659     3.521     0.200
     1.741    -4.458     0.200
     2.436    -7.872     0.200
     2.782   -10.648     0.200
     2.924   -12.646     0.200
     2.951   -12.066     0.200
     2.959   -11.621     0.200
     3.563   -17.649     0.200
     3.632   -16.943     0.200
     3.621   -16.461     0.200
     3.983   -20.305     0.200
     3.992   -21.066     0.200
     4.094   -21.939     0.200
     4.148   -21.256     0.200
     4.216   -23.086     0.200
     5.416   -34.023     0.200
     0.756     2.309     0.200
     1.340    -1.004     0.200
     2.855    -9.602     0.200
     2.925   -11.216     0.200
     3.526   -15.448     0.200
     3.526   -16.088     0.200
     3.552   -14.798     0.200
     3.634   -16.620     0.200
     3.634   -16.268     0.200
     3.649   -16.181     0.200
     3.654   -16.243     0.200
     3.975   -20.189     0.200
     3.975   -20.642     0.200
     4.078   -20.427     0.200
     4.078   -20.302     0.200
     4.134   -20.083     0.200
     4.199   -20.369     0.200
     4.238   -21.571     0.200
     5.494   -34.215     0.200
     0.878     0.630     0.200
     0.878     0.310     0.200
     1.891    -6.051     0.200
     2.680   -12.912     0.200
     2.680   -13.467     0.200
     3.546   -16.067     0.200
     3.738   -19.848     0.200
     3.649   -17.134     0.200
     3.664   -16.201     0.200
     4.026   -21.399     0.200
     4.252   -22.124     0.200
     5.136   -33.578     0.200
     0.947     1.692     0.200
     3.939   -21.470     0.200
     4.037   -21.633     0.200
     5.264   -35.198     0.200
     0.937     0.520     0.200
     0.937     0.620     0.200
     1.954    -7.268     0.200
     3.539   -15.655     0.200
     3.638   -18.302     0.200
     3.666   -18.448     0.200
     4.016   -21.235     0.200
     4.113   -22.642     0.200
     4.241   -22.470     0.200
     5.183   -35.880     0.200
     0.568     2.306     0.200
     0.578     2.931     0.200
     2.803   -10.704     0.200
     3.502   -16.756     0.200
     3.599   -18.455     0.200
     3.964   -20.510     0.200
     4.728   -29.309     0.200
     0.955     1.274     0.200
     0.955     0.735     0.200
     1.937    -6.558     0.200
     5.152   -35.590     0.200
     0.661     2.379     0.200
     0.672     2.147     0.200
     1.580    -3.866     0.200
     2.289    -8.872     0.200
     3.404   -14.877     0.200
     3.862   -18.495     0.200
     4.066   -22.448     0.200
     5.488   -35.859     0.200
     9.384   -59.325     0.200
     0.673     2.998     0.200
     1.266    -2.221     0.200
     3.633   -16.229     0.200
     4.094   -21.533     0.200
     4.149   -20.803     0.200
     4.216   -21.773     0.200
     5.426   -36.075     0.200
     3.551   -17.339     0.200
     3.676   -17.715     0.200
     4.020   -22.516     0.200
     4.172   -22.110     0.200
     5.250   -33.940     0.200
    12.243   -87.906     0.200
     0.930     1.693     0.200
     0.930     1.953     0.200
     2.689   -12.098     0.200
     2.829   -10.486     0.200
     2.912   -11.515     0.200
     3.278   -14.972     0.200
     3.561   -17.659     0.200
     3.660   -17.609     0.200
     3.660   -16.379     0.200
     3.664   -18.529     0.200
     3.717   -17.482     0.200
     3.717   -16.831     0.200
     3.688   -18.117     0.200
     4.136   -22.328     0.200
     4.264   -23.704     0.200
     4.301   -24.000     0.200
     5.155   -34.019     0.200
    12.120   -85.579     0.200
    18.426  -126.975     0.200
     2.076    -7.146     0.200
     2.783   -10.322     0.200
     3.624   -17.661     0.200
     4.067   -21.976     0.200
     5.289   -36.482     0.200
    12.292   -84.299     0.200
    12.267   -89.417     0.200
     0.884     0.830     0.200
     2.796   -10.256     0.200
     4.159   -22.157     0.200
     5.155   -33.722     0.200
    12.103   -85.316     0.200
    18.412  -130.444     0.200
     0.978     1.169     0.200
     0.978     0.979     0.200
     5.194   -32.959     0.200
     2.763   -10.692     0.200
     2.845   -11.430     0.200
     3.588   -17.719     0.200
     4.114   -23.268     0.200
     4.190   -23.392     0.200
     5.237   -35.044     0.200
     0.323     5.192     0.200
     0.333     5.166     0.200
     1.037     0.051     0.200
     1.037    -0.949     0.200
     1.553    -4.440     0.200
     1.621    -3.485     0.200
     1.637    -3.882     0.200
     1.762    -6.439     0.200
     1.880    -7.501     0.200
     1.931    -5.817     0.200
     2.554   -10.040     0.200
     2.673   -11.141     0.200
     2.749   -12.787     0.200
     2.905   -13.707     0.200
     3.011   -13.241     0.200
     3.094   -14.784     0.200
     3.230   -16.706     0.200
     3.126   -14.509     0.200
     3.742   -20.764     0.200
     3.840   -21.310     0.200
     3.845   -20.682     0.200
     3.861   -20.624     0.200
     5.031   -34.863     0.200
    16.629  -118.419     0.200
    18.343  -129.417     0.200
     1.902    -6.747     0.200
     3.755   -23.205     0.200
     4.521   -27.486     0.200
     5.152   -35.677     0.200
     9.621   -63.841     0.200
    12.176   -81.342     0.200
     2.023    -7.064     0.200
     2.778   -10.887     0.200
     2.859   -11.679     0.200
     3.842   -22.050     0.200
     2.041    -7.128     0.200
     2.813   -10.958     0.200
     3.835   -20.486     0.200
     4.154   -22.242     0.200
     5.248   -34.907     0.200
     0.928     1.196     0.200
     0.928     0.657     0.200
     4.160   -21.463     0.200
     4.237   -22.854     0.200
     5.182   -34.929     0.200
     1.261     2.217     0.200
     3.957   -22.723     0.200
     0.457     3.603     0.200
     0.464     1.894     0.200
     0.891     1.187     0.200
     0.942     1.348     0.200
     0.960     1.539     0.200
     1.073     0.987     0.200
     1.107     0.547     0.200
     1.115    -0.027     0.200
     1.256    -1.301     0.200
    11.971   -85.201     0.200
    18.312  -130.571     0.200
     1.039     1.275     0.200
     1.039     1.595     0.200
     2.080    -6.253     0.200
     2.806   -14.434     0.200
     2.790    -9.578     0.200
     3.428   -17.372     0.200
     3.609   -15.797     0.200
     3.626   -15.197     0.200
     3.630   -16.177     0.200
     3.787   -18.963     0.200
     0.865     1.208     0.200
     5.149   -33.906     0.200
     1.186     1.591     0.200
     2.479    -8.742     0.200
     2.908   -12.347     0.200
     3.597   -19.383     0.200
     3.950   -22.687     0.200
     4.038   -21.572     0.200
     5.408   -34.940     0.200
    12.418   -85.521     0.200
     2.767    -9.019     0.200
     2.828    -9.335     0.200
     2.935   -10.070     0.200
     3.529   -15.612     0.200
     3.610   -15.782     0.200
     3.625   -15.850     0.200
     4.046   -18.459     0.200
     5.492   -35.624     0.200
     0.830     2.012     0.200
     0.830     1.364     0.200
     2.825   -11.849     0.200
     3.541   -16.702     0.200
     5.081   -32.851     0.200
    12.020   -84.638     0.200
     0.415     2.824     0.200
     0.425     2.449     0.200
     0.997     0.415     0.200
     0.997    -0.036     0.200
     1.385    -2.444     0.200
     1.490    -4.034     0.200
     1.492    -3.825     0.200
     1.579    -4.565     0.200
     1.582    -3.269     0.200
     2.458    -8.200     0.200
     2.781   -10.751     0.200
     3.529   -17.354     0.200
     3.627   -18.615     0.200
     3.972   -21.731     0.200
     4.071   -22.694     0.200
     4.198   -22.963     0.200
     5.263   -36.717     0.200
    12.234   -87.453     0.200
     0.998     0.849     0.200
     0.998     1.079     0.200
     2.048    -7.453     0.200
     2.887   -11.871     0.200
     3.965   -19.304     0.200
     5.271   -35.738     0.200
    12.240   -89.473     0.200
    18.546  -127.793     0.200
     2.200    -7.186     0.200
     2.820   -12.443     0.200
     3.555   -16.255     0.200
     3.875   -18.050     0.200
     5.419   -36.928     0.200
    12.394   -84.603     0.200
     0.693     2.663     0.200
     1.184    -0.831     0.200
     2.321    -7.948     0.200
     3.470   -15.493     0.200
     3.804   -19.841     0.200
     4.028   -21.272     0.200
     5.537   -35.102     0.200
     1.992    -6.317     0.200
     2.242    -8.146     0.200
     2.743   -10.288     0.200
     1.117     0.186     0.200
     1.117     1.296     0.200
     2.188    -7.461     0.200
     3.921   -19.104     0.200
     4.749   -26.459     0.200
     5.389   -35.821     0.200
    12.378   -86.192     0.200
     1.014    -0.879     0.200
     2.783   -10.064     0.200
     3.528   -18.466     0.200
     3.971   -20.736     0.200
     4.070   -21.835     0.200
     4.197   -22.504     0.200
     5.275   -36.786     0.200
     1.265     1.503     0.200
     2.330    -6.885     0.200
     3.483   -15.656     0.200
     3.937   -19.640     0.200
     4.830   -26.056     0.200
     5.475   -34.686     0.200
    12.500   -87.737     0.200
     0.568     3.008     0.200
     5.364   -35.217     0.200
    12.372   -89.053     0.200
     0.943     0.806     0.200
     1.987    -6.678     0.200
     5.223   -33.362     0.200
     0.550     3.584     0.200
     2.160    -8.774     0.200
     2.382    -8.158     0.200
     2.814   -16.415     0.200
     2.868   -11.260     0.200
     3.510   -18.642     0.200
     3.693   -18.977     0.200
     3.795   -21.187     0.200
     4.030   -22.465     0.200
     4.131   -22.884     0.200
     1.898    -6.780     0.200
     2.302    -8.580     0.200
     2.685   -14.802     0.200
     2.808   -10.458     0.200
     3.574   -17.484     0.200
     3.691   -18.719     0.200
     5.142   -34.876     0.200
    12.092   -85.717     0.200
     0.571     2.379     0.200
     1.669    -4.671     0.200
     2.326    -7.770     0.200
     2.886   -12.113     0.200
     3.633   -18.277     0.200
     3.970   -21.550     0.200
     4.071   -22.131     0.200
     4.195   -22.534     0.200
     4.233   -22.974     0.200
     0.394     3.961     0.200
     0.463     4.991     0.200
     0.463     4.881     0.200
     1.318    -2.729     0.200
     1.183    -0.441     0.200
     1.239    -0.609     0.200
     1.430    -2.269     0.200
     1.461    -2.242     0.200
     1.481    -1.141     0.200
     2.359    -6.452     0.200
     3.059   -14.760     0.200
     4.716   -31.548     0.200
    11.512   -85.700     0.200
     0.895     1.113     0.200
     0.895     0.882     0.200
     1.954    -6.991     0.200
     3.489   -15.118     0.200
     3.671   -19.603     0.200
     3.616   -18.040     0.200
     4.064   -22.884     0.200
     4.193   -20.484     0.200
     5.207   -34.923     0.200
     2.031    -8.370     0.200
     2.747   -10.771     0.200
     3.426   -17.859     0.200
     3.498   -17.827     0.200
     3.596   -18.652     0.200
     3.943   -23.143     0.200
     4.041   -23.172     0.200
     4.169   -23.376     0.200
     5.270   -34.551     0.200
    12.226   -88.575     0.200
    18.534  -129.056     0.200
     0.575     2.385     0.200
     0.586     1.986     0.200
     2.886   -12.454     0.200
     3.464   -17.534     0.200
     3.632   -17.812     0.200
     3.969   -20.368     0.200
     3.969   -21.178     0.200
     4.070   -21.574     0.200
     5.372   -36.830     0.200
    10.433   -66.448     0.200
    12.380   -89.997     0.200
     0.939     1.632     0.200
     0.939     0.922     0.200
     2.753   -10.686     0.200
     3.548   -17.836     0.200
     4.070   -22.230     0.200
     4.167   -23.008     0.200
     4.295   -23.515     0.200
     5.128   -34.429     0.200
    12.100   -88.443     0.200
     0.609     1.868     0.200
     1.483    -4.654     0.200
     4.810   -30.474     0.200
     0.807     0.882     0.200
     1.820    -5.877     0.200
     2.646   -13.672     0.200
     3.166   -13.519     0.200
     3.539   -15.361     0.200
     3.550   -17.268     0.200
     3.697   -19.330     0.200
     5.087   -32.345     0.200
    12.016   -87.126     0.200
     0.808     1.185     0.200
     1.830    -6.039     0.200
     2.656   -12.771     0.200
     3.175   -15.810     0.200
     3.541   -16.281     0.200
     0.961     1.241     0.200
     5.182   -34.636     0.200
    12.154   -85.263     0.200
     2.071    -8.064     0.200
     2.296    -7.935     0.200
     2.791   -10.649     0.200
     2.870   -11.126     0.200
     2.903   -11.252     0.200
     3.462   -17.814     0.200
     3.604   -18.726     0.200
     3.976   -21.747     0.200
     3.976   -22.693     0.200
     4.075   -22.971     0.200
     4.202   -24.271     0.200
     5.281   -37.922     0.200
     1.159    -3.172     0.200
     2.502   -12.151     0.200
     0.164     7.703     0.200
     0.175     7.388     0.200
     0.851     1.343     0.200
     0.851     0.983     0.200
     1.386    -2.374     0.200
     1.442    -2.191     0.200
     1.462    -2.239     0.200
     1.574    -1.829     0.200
     1.598    -3.661     0.200
     1.602    -4.298     0.200
     1.785    -6.975     0.200
     2.376    -9.923     0.200
     2.570   -12.954     0.200
     2.570   -13.946     0.200
     2.616    -9.765     0.200
     2.888   -12.688     0.200
     3.134   -16.420     0.200
     3.494   -19.196     0.200
     3.591   -18.353     0.200
     3.634   -19.094     0.200
     3.664   -19.024     0.200
     3.762   -20.322     0.200
     4.118   -22.719     0.200
     4.213   -24.524     0.200
     4.264   -25.021     0.200
     5.022   -35.830     0.200
    11.976   -88.862     0.200
     0.866     2.502     0.200
     2.842   -10.667     0.200
     3.195   -15.124     0.200
     3.683   -18.079     0.200
     3.711   -19.386     0.200
     4.161   -23.898     0.200
     5.089   -33.805     0.200
    12.040   -87.430     0.200
    18.347  -128.489     0.200
     0.904     1.173     0.200
     0.904     1.353     0.200
     2.325    -8.733     0.200
     4.142   -22.896     0.200
     5.132   -33.162     0.200
     5.200   -35.504     0.200
    12.152   -86.492     0.200
    18.460  -130.690     0.200
     0.819     0.479     0.200
     1.798    -5.994     0.200
     2.327    -8.164     0.200
     2.955   -11.284     0.200
     3.146   -15.573     0.200
     3.714   -18.322     0.200
     4.071   -23.006     0.200
     4.216   -22.759     0.200
     4.296   -23.730     0.200
     5.055   -31.153     0.200
    11.993   -84.163     0.200
    16.717  -119.762     0.200
    18.302  -129.342     0.200
     0.941    -0.068     0.200
     2.345    -9.129     0.200
     3.630   -18.480     0.200
     3.581   -15.749     0.200
     3.684   -17.409     0.200
     3.707   -18.236     0.200
     4.058   -20.471     0.200
     4.058   -21.821     0.200
     4.207   -22.725     0.200
     4.507   -26.311     0.200
     5.142   -33.220     0.200
     9.613   -62.781     0.200
    12.113   -86.884     0.200
    16.770  -120.493     0.200
     0.753     1.999     0.200
     1.022     0.216     0.200
     1.045    -0.030     0.200
     1.293    -2.056     0.200
     1.349    -4.516     0.200
     1.349    -3.407     0.200
     1.355    -1.983     0.200
     1.338    -2.851     0.200
     1.427    -2.851     0.200
     1.458    -3.301     0.200
     2.014    -9.084     0.200
     2.258    -9.323     0.200
     2.795   -13.015     0.200
     2.857   -15.113     0.200
     3.137   -16.856     0.200
     3.142   -14.421     0.200
     5.706   -31.821     0.200
     6.222   -35.472     0.200
     0.848     1.137     0.200
     0.848    -0.063     0.200
     1.880    -6.823     0.200
     2.277    -7.893     0.200
     2.690   -14.047     0.200
     2.785   -11.233     0.200
     3.525   -17.627     0.200
     3.554   -18.183     0.200
     3.627   -18.358     0.200
     4.007   -20.981     0.200
     4.232   -24.417     0.200
     4.444   -27.721     0.200
     4.509   -28.017     0.200
     5.139   -32.347     0.200
    18.387  -127.858     0.200
     1.908    -7.171     0.200
     3.222   -16.164     0.200
     3.951   -19.714     0.200
     5.299   -32.704     0.200
     5.318   -26.431     0.200
     0.554     2.732     0.200
     2.890   -15.125     0.200
     3.578   -17.954     0.200
     3.961   -22.579     0.200
     5.378   -35.649     0.200
    12.362   -87.102     0.200
    18.666  -130.279     0.200
     0.650     3.083     0.200
     2.276   -10.219     0.200
     2.263    -7.397     0.200
     3.429   -18.453     0.200
     5.468   -35.760     0.200
     2.013    -7.286     0.200
     2.829   -11.149     0.200
     2.909   -12.526     0.200
     3.676   -19.424     0.200
     4.022   -22.722     0.200
     4.022   -22.402     0.200
     4.121   -23.279     0.200
     5.220   -36.709     0.200
     0.834     1.865     0.200
     0.834     0.995     0.200
     1.849    -6.197     0.200
     2.661   -12.355     0.200
     2.919   -11.980     0.200
     3.195   -16.463     0.200
     3.546   -17.120     0.200
     3.715   -17.963     0.200
     4.029   -19.713     0.200
     5.108   -34.155     0.200
    12.044   -83.733     0.200
    16.767  -117.349     0.200
    18.355  -125.690     0.200
     0.834     0.437     0.200
     0.834     1.359     0.200
     2.683   -12.771     0.200
     2.683   -13.271     0.200
     2.900   -11.939     0.200
     3.212   -16.847     0.200
     3.526   -16.424     0.200
     3.736   -20.676     0.200
     3.654   -18.658     0.200
     4.008   -19.802     0.200
     4.008   -20.833     0.200
     4.234   -22.969     0.200
     4.500   -26.369     0.200
     5.129   -34.454     0.200
     2.398    -9.571     0.200
     2.807   -11.415     0.200
     3.078   -11.622     0.200
     4.476   -26.902     0.200
    11.261   -80.457     0.200
     1.014     4.365     0.200
     1.110     2.918     0.200
     1.082     4.059     0.200
     1.099     3.670     0.200
     1.493     0.540     0.200
     3.420   -11.258     0.200
     3.547   -11.569     0.200
     5.795   -37.351     0.200
     2.814   -10.210     0.200
     2.892   -11.272     0.200
     3.551   -17.314     0.200
     3.649   -17.688     0.200
     0.821     0.800     0.200
     1.526    -4.176     0.200
     1.826    -5.476     0.200
     3.686   -18.038     0.200
     4.187   -23.148     0.200
     5.087   -35.647     0.200
     1.069     1.254     0.200
     3.538   -16.598     0.200
     3.538   -16.238     0.200
     3.635   -16.744     0.200
     3.978   -21.139     0.200
     4.077   -21.364     0.200
     5.304   -34.943     0.200
    18.595  -128.738     0.200
     1.019     1.461     0.200
     2.057    -6.615     0.200
     2.871   -13.012     0.200
     3.537   -16.857     0.200
     3.635   -17.838     0.200
     3.980   -21.971     0.200
     4.078   -22.383     0.200
     4.205   -22.980     0.200
     5.270   -35.489     0.200
    12.247   -86.541     0.200
    18.551  -128.048     0.200
     1.436    -3.373     0.200
     1.358     1.749     0.200
     1.374     1.033     0.200
     1.402     0.684     0.200
     4.740   -26.983     0.200
     0.478     2.895     0.200
     0.865     1.743     0.200
     0.928     0.994     0.200
     0.942     0.350     0.200
     1.056     0.947     0.200
     1.082     0.773     0.200
     1.086     0.358     0.200
     1.092     0.026     0.200
     1.836    -6.847     0.200
     1.899    -2.876     0.200
     5.255   -32.828     0.200
     2.870   -10.343     0.200
     0.854     0.595     0.200
     1.872    -6.729     0.200
     2.293    -8.977     0.200
     2.673   -14.450     0.200
     2.916   -13.076     0.200
     3.219   -16.006     0.200
     3.730   -22.366     0.200
     4.023   -20.897     0.200
     5.126   -35.384     0.200
     0.634     1.974     0.200
     2.242    -8.328     0.200
     1.822    -5.489     0.200
     2.408    -8.346     0.200
     2.329    -8.109     0.200
     2.648   -13.436     0.200
     3.168   -16.024     0.200
     5.090   -33.915     0.200
    12.018   -87.178     0.200
     1.182    -3.990     0.200
     2.137   -10.861     0.200
     0.560     3.235     0.200
     2.174    -7.968     0.200
     2.852   -11.798     0.200
     5.369   -37.252     0.200
    12.363   -89.742     0.200
     0.883     0.859     0.200
     2.685   -13.468     0.200
     2.890   -10.949     0.200
     3.246   -15.000     0.200
     3.613   -18.689     0.200
     3.689   -19.387     0.200
     3.571   -17.683     0.200
     3.645   -17.943     0.200
     4.119   -21.159     0.200
     4.170   -21.353     0.200
     5.143   -35.250     0.200
    12.093   -87.331     0.200
     1.000     0.706     0.200
     2.037    -6.668     0.200
     2.871   -10.935     0.200
     3.539   -16.326     0.200
     3.681   -18.953     0.200
     3.614   -17.039     0.200
     5.255   -34.460     0.200
    12.229   -87.404     0.200
     0.670     1.999     0.200
     4.814   -29.187     0.200
     0.875     1.160     0.200
     1.428    -3.569     0.200
     1.545    -3.716     0.200
     1.895    -8.450     0.200
     2.687   -12.552     0.200
     5.143   -33.146     0.200
     1.566    -3.903     0.200
     2.056    -8.399     0.200
     2.791   -11.274     0.200
     3.404   -18.514     0.200
     3.536   -17.207     0.200
     3.634   -18.222     0.200
     0.786     0.854     0.200
     1.779    -6.131     0.200
     2.309    -7.838     0.200
     5.048   -33.783     0.200
    11.975   -85.697     0.200
     2.054    -7.540     0.200
     1.104     0.930     0.200
     1.207     1.294     0.200
     1.209     0.994     0.200
     1.281     0.655     0.200
     1.302    -0.170     0.200
     1.305     0.155     0.200
     1.987    -5.971     0.200
     5.318   -31.155     0.200
     0.863     1.270     0.200
     1.891    -5.910     0.200
     2.691   -15.050     0.200
     5.317   -34.994     0.200
    12.312   -86.984     0.200
     2.836   -14.228     0.200
     2.805   -10.249     0.200
     3.490   -16.733     0.200
     3.623   -16.558     0.200
     3.635   -17.393     0.200
     3.976   -20.475     0.200
     3.976   -19.926     0.200
     4.076   -20.757     0.200
     4.129   -21.072     0.200
     4.129   -20.612     0.200
     4.201   -21.608     0.200
     2.788   -10.868     0.200
     3.982   -22.772     0.200
     4.080   -22.641     0.200
     4.244   -24.126     0.200
     5.251   -34.882     0.200
    12.222   -88.640     0.200
    16.869  -120.814     0.200
     5.401   -34.911     0.200
    12.428   -88.765     0.200
     0.887     1.220     0.200
     1.868    -6.085     0.200
     2.336    -7.935     0.200
     5.103   -31.880     0.200
     1.167     1.009     0.200
     3.235   -13.332     0.200
     3.355   -12.767     0.200
     5.460   -37.310     0.200
     0.603     3.537     0.200
     1.251    -2.870     0.200
     1.873    -9.607     0.200
     2.958   -12.372     0.200
     4.324   -30.897     0.200
     1.538    -4.244     0.200
     1.872    -7.980     0.200
     2.305    -8.783     0.200
     2.666   -15.732     0.200
     2.546    -9.444     0.200
     2.701   -11.173     0.200
     2.898   -11.651     0.200
     3.219   -15.886     0.200
     3.518   -19.484     0.200
     3.587   -18.921     0.200
     3.662   -20.656     0.200
     3.724   -23.096     0.200
     3.553   -18.879     0.200
     3.582   -18.223     0.200
     3.670   -18.508     0.200
     3.680   -19.347     0.200
     4.034   -23.677     0.200
     4.260   -24.504     0.200
     4.956   -32.861     0.200
     5.121   -34.735     0.200
     5.490   -32.203     0.200
     5.821   -37.592     0.200
     6.286   -37.891     0.200
     6.443   -40.419     0.200
     6.460   -39.997     0.200
     6.777   -46.041     0.200
     6.842   -44.585     0.200
     6.943   -43.245     0.200
    12.066   -85.992     0.200
     0.424     1.814     0.200
     0.492     2.607     0.200
     0.933     0.793     0.200
     0.987     0.964     0.200
     1.005     0.182     0.200
     1.144     0.492     0.200
     1.151    -0.305     0.200
     1.155    -0.973     0.200
     1.162    -1.040     0.200
     1.302    -1.134     0.200
     1.445    -2.664     0.200
     1.800    -5.535     0.200
     1.968    -4.798     0.200
     2.000    -3.614     0.200
     2.350    -7.115     0.200
     2.509    -7.261     0.200
     2.582    -9.420     0.200
     2.585    -9.002     0.200
     2.849   -15.594     0.200
     3.262   -15.886     0.200
     5.203   -33.314     0.200
     0.974    -0.089     0.200
     0.615     4.590     0.200
     1.247    -2.330     0.200
     4.313   -28.707     0.200
    11.350   -82.302     0.200
     0.695     2.591     0.200
     1.280    -2.521     0.200
     2.620   -11.726     0.200
     2.886   -10.679     0.200
     3.146   -13.935     0.200
     3.746   -18.720     0.200
     4.407   -27.014     0.200
    11.415   -80.690     0.200
    17.702  -122.991     0.200
     0.578     2.266     0.200
     4.369   -30.124     0.200
    11.416   -83.187     0.200
    17.694  -122.874     0.200
     0.769     1.328     0.200
     0.769     1.500     0.200
     0.942    -0.814     0.200
     0.940    -0.837     0.200
     1.051    -1.899     0.200
     1.450    -1.208     0.200
     1.546    -2.219     0.200
     1.580    -2.466     0.200
     1.773    -2.400     0.200
     1.906    -2.723     0.200
     1.919    -1.959     0.200
     2.086    -4.487     0.200
     2.153    -5.322     0.200
     2.281    -7.310     0.200
     2.544   -10.314     0.200
     2.595   -10.444     0.200
     2.684   -10.761     0.200
     3.511   -18.381     0.200
     4.129   -26.492     0.200
     4.821   -27.797     0.200
    11.083   -82.215     0.200
    17.377  -122.144     0.200
     1.426    -4.742     0.200
     2.874   -18.619     0.200
    10.154   -76.522     0.200
     0.882    -0.469     0.200
     0.880    -0.360     0.200
     0.825     2.659     0.200
     0.825     2.079     0.200
     0.948     1.738     0.200
     1.073     0.016     0.200
     1.442    -2.927     0.200
     1.735    -6.422     0.200
     1.859    -4.031     0.200
     1.921    -3.745     0.200
     2.219    -7.580     0.200
     2.534   -10.997     0.200
     3.021   -11.262     0.200
     4.077   -26.352     0.200
     6.714   -35.901     0.200
    11.021   -82.388     0.200
     0.560     3.447     0.200
     1.934    -7.905     0.200
     4.409   -28.901     0.200
     0.745     2.623     0.200
     0.972     0.308     0.200
     0.953     0.997     0.200
     0.999     2.035     0.200
     1.153     1.679     0.200
     1.561    -3.318     0.200
     1.829    -5.900     0.200
     3.140   -16.590     0.200
    10.167   -71.059     0.200
     0.928     2.853     0.200
     0.928     1.822     0.200
     1.910    -6.451     0.200
     4.031   -19.905     0.200
     5.162   -34.181     0.200
    12.125   -86.416     0.200
     1.790    -6.459     0.200
     2.246    -7.132     0.200
     2.306    -7.633     0.200
     2.314    -8.075     0.200
     2.480   -11.101     0.200
     2.599   -14.413     0.200
     3.024   -11.858     0.200
     3.263   -20.285     0.200
    10.565   -77.175     0.200
     0.359     4.117     0.200
     0.672     1.877     0.200
     1.067    -0.725     0.200
     1.259    -3.211     0.200
     1.392    -0.735     0.200
     1.443    -1.384     0.200
     1.446    -1.522     0.200
     1.471    -0.619     0.200
     1.538    -0.812     0.200
     1.669    -2.540     0.200
     1.721    -3.658     0.200
     2.222   -12.513     0.200
     2.309    -6.178     0.200
    10.852   -75.898     0.200
     2.036    -9.970     0.200
     2.080    -6.803     0.200
     3.884   -25.124     0.200
     4.526   -28.751     0.200
     0.460     2.465     0.200
     1.687    -5.242     0.200
     1.746    -6.012     0.200
     1.745    -5.682     0.200
     2.133    -9.873     0.200
     2.133    -9.705     0.200
     2.324   -11.253     0.200
     2.338   -11.070     0.200
     2.383   -10.926     0.200
     2.383   -11.176     0.200
     2.791   -16.725     0.200
     2.791   -16.616     0.200
     3.207   -17.282     0.200
     3.421   -19.927     0.200
     3.443   -19.700     0.200
     3.508   -20.146     0.200
     6.804   -42.674     0.200
    10.014   -74.112     0.200
    14.479  -103.570     0.200
     0.938     1.081     0.200
     1.011     1.452     0.200
     1.006     1.406     0.200
     1.022     1.261     0.200
     1.031     1.915     0.200
     1.823    -5.316     0.200
    12.044   -84.819     0.200
     0.455     2.597     0.200
     0.958     0.806     0.200
     1.281    -1.475     0.200
     1.290    -2.072     0.200
     1.675    -2.699     0.200
     1.693    -2.888     0.200
     1.711    -2.717     0.200
     1.749    -3.033     0.200
     1.822    -3.126     0.200
     1.937    -4.380     0.200
     1.949    -4.591     0.200
     2.021    -9.332     0.200
     2.022    -8.702     0.200
     1.978    -4.914     0.200
     4.451   -27.643     0.200
    16.132  -114.610     0.200
    17.732  -125.503     0.200
     2.045    -9.634     0.200
     2.047    -9.613     0.200
     3.110   -17.616     0.200
     3.885   -25.055     0.200
     4.140   -20.168     0.200
     4.629   -24.687     0.200
     8.189   -53.737     0.200
     8.447   -55.190     0.200
    11.576   -81.035     0.200
    16.149  -115.789     0.200
     1.442    -4.314     0.200
     1.442    -3.974     0.200
     2.218    -7.548     0.200
     2.221    -7.387     0.200
     2.617    -9.344     0.200
     3.363   -14.669     0.200
     3.403   -14.786     0.200
     3.429   -14.859     0.200
     3.655   -15.777     0.200
     3.673   -17.493     0.200
     3.720   -16.966     0.200
     4.555   -23.471     0.200
    10.326   -75.577     0.200
     0.784     0.805     0.200
     0.955     1.168     0.200
     1.000     1.081     0.200
     1.329    -2.893     0.200
     1.420    -5.625     0.200
     1.340    -2.342     0.200
     1.394    -2.685     0.200
     1.386    -2.783     0.200
     1.464    -2.782     0.200
     1.488    -3.477     0.200
     1.756    -7.612     0.200
     1.845    -7.547     0.200
     1.898    -7.694     0.200
     1.996    -8.478     0.200
     2.004    -8.640     0.200
     2.000    -8.348     0.200
     2.045    -8.836     0.200
     2.686   -16.040     0.200
     2.686   -16.645     0.200
     2.807   -13.112     0.200
     2.888   -14.691     0.200
     0.767     1.257     0.200
     1.748    -6.060     0.200
     5.022   -30.579     0.200
    11.945   -83.413     0.200
     1.378    -3.032     0.200
     1.391    -3.804     0.200
     2.036    -6.120     0.200
     2.165    -7.611     0.200
     2.488   -10.472     0.200
     3.223   -13.580     0.200
    10.152   -72.297     0.200
     0.619     2.083     0.200
     1.347    -3.727     0.200
     1.904    -7.765     0.200
     1.965    -6.574     0.200
     2.099    -9.190     0.200
     2.115    -7.798     0.200
     2.114    -8.416     0.200
     2.694   -11.493     0.200
     2.849   -13.375     0.200
     4.891   -31.343     0.200
     0.848     0.599     0.200
     1.878    -6.142     0.200
     0.784     1.378     0.200
     3.637   -18.336     0.200
     5.088   -34.744     0.200
     1.671    -4.378     0.200
     1.951    -6.393     0.200
     2.925   -10.600     0.200
     0.961     0.757     0.200
     1.978    -5.805     0.200
     5.231   -34.433     0.200
     0.932    -0.353     0.200
     1.578    -4.277     0.200
     1.901    -6.225     0.200
     2.333    -7.782     0.200
     5.147   -35.408     0.200
     0.719     2.864     0.200
     1.260     0.918     0.200
     2.309    -7.070     0.200
     2.330    -8.086     0.200
     2.368    -7.495     0.200
     2.775    -9.830     0.200
     3.908   -18.316     0.200
     5.498   -35.508     0.200
    12.515   -90.614     0.200
     1.045     0.381     0.200
     3.618   -16.196     0.200
     3.631   -16.667     0.200
     5.292   -35.950     0.200
     0.869     1.051     0.200
     1.886    -5.540     0.200
     2.295    -7.733     0.200
     5.136   -34.649     0.200
    12.081   -85.036     0.200
     2.119    -7.471     0.200
     3.510   -16.401     0.200
     5.330   -35.263     0.200
    12.328   -85.081     0.200
     1.802    -7.752     0.200
     2.061    -7.547     0.200
     3.497   -17.951     0.200
     5.100   -34.882     0.200
    18.317  -127.779     0.200
     0.756     1.671     0.200
     5.021   -32.965     0.200
    18.252  -126.814     0.200
     0.069     9.744     0.200
     0.661     2.468     0.200
     1.156    -1.698     0.200
     1.300    -1.695     0.200
     1.312    -1.176     0.200
     1.320    -1.220     0.200
     1.400    -0.771     0.200
     1.346    -1.533     0.200
     1.363    -1.142     0.200
     1.467    -0.710     0.200
     1.523    -2.430     0.200
     1.530    -3.160     0.200
     1.544    -3.659     0.200
     2.175    -6.821     0.200
     2.355    -9.076     0.200
     2.969   -13.408     0.200
     4.887   -32.208     0.200
     0.923     1.425     0.200
     0.923     2.112     0.200
     1.856    -5.181     0.200
    12.066   -88.323     0.200
     0.749    -0.407     0.200
     2.919   -11.642     0.200
     3.295   -15.034     0.200
     3.366   -14.868     0.200
     3.665   -16.579     0.200
     4.919   -31.640     0.200
     1.270     1.289     0.200
     1.299     0.494     0.200
     1.339     0.129     0.200
     1.373    -0.522     0.200
     1.373     0.017     0.200
     1.402     1.385     0.200
     1.416     1.380     0.200
     1.416     2.114     0.200
     4.499   -25.639     0.200
    11.267   -76.538     0.200
     1.057     0.157     0.200
     1.133    -0.559     0.200
     1.178    -0.564     0.200
     1.388    -5.033     0.200
     1.515    -3.738     0.200
     1.576    -4.090     0.200
     1.553    -3.419     0.200
     1.587    -3.506     0.200
     1.649    -4.666     0.200
     1.683    -4.591     0.200
     1.583    -2.086     0.200
     1.687    -4.137     0.200
     1.688    -4.076     0.200
     2.007    -9.072     0.200
     2.050    -9.111     0.200
     2.110   -10.110     0.200
     2.153   -10.728     0.200
     2.153   -10.539     0.200
     2.735   -18.806     0.200
     9.886   -74.418     0.200
    14.492  -104.679     0.200
    16.113  -119.712     0.200
    17.054  -125.468     0.200
     0.625     1.586     0.200
     4.755   -30.966     0.200
     5.182   -34.802     0.200
     0.893     1.669     0.200
     1.902    -6.045     0.200
     5.173   -33.574     0.200
    12.121   -87.882     0.200
    16.816  -120.068     0.200
    18.430  -126.540     0.200
     0.458     3.430     0.200
     0.900     0.975     0.200
     0.900     1.085     0.200
     0.950     1.674     0.200
     0.949     1.123     0.200
     0.949     1.291     0.200
     0.969     1.073     0.200
     0.981     1.773     0.200
     1.081     0.240     0.200
     1.107     1.096     0.200
     1.120     0.093     0.200
     1.125    -0.320     0.200
     1.125    -0.167     0.200
     1.135    -0.827     0.200
     1.135    -0.358     0.200
     1.264    -2.778     0.200
     1.338    -2.271     0.200
     1.946    -4.387     0.200
     5.205   -36.032     0.200
    11.966   -87.766     0.200
     0.277     5.275     0.200
     0.960     0.063     0.200
     1.483    -3.015     0.200
     1.467    -3.242     0.200
     1.520    -2.810     0.200
     1.538    -3.598     0.200
     1.535    -2.461     0.200
     1.596    -3.980     0.200
     1.664    -5.914     0.200
     1.664    -5.683     0.200
     1.691    -3.476     0.200
     2.074    -7.251     0.200
     2.266    -8.983     0.200
     2.363   -10.523     0.200
     2.429   -10.715     0.200
     2.594   -10.414     0.200
     5.058   -34.828     0.200
    12.048   -88.283     0.200
     2.861   -10.495     0.200
     3.494   -16.776     0.200
     3.644   -16.917     0.200
     3.886   -18.850     0.200
     3.962   -21.523     0.200
     4.187   -22.170     0.200
     4.876   -27.315     0.200
     0.460     1.272     0.200
     0.522     2.064     0.200
     0.910     1.850     0.200
     0.974     1.686     0.200
     1.105    -0.584     0.200
     1.125     1.095     0.200
     1.128     0.567     0.200
     1.129     0.419     0.200
     1.407    -3.204     0.200
     5.255   -34.808     0.200
     1.578    -7.924     0.200
     1.822    -6.240     0.200
     1.822    -5.873     0.200
     1.932    -6.066     0.200
     2.868   -16.494     0.200
     2.890   -16.107     0.200
     2.926   -15.295     0.200
     3.116   -17.648     0.200
     3.128   -18.451     0.200
     3.403   -15.014     0.200
     3.744   -21.191     0.200
     3.966   -23.923     0.200
     4.124   -24.695     0.200
     4.134   -24.219     0.200
     4.503   -27.538     0.200
     0.500     4.212     0.200
     0.618     4.288     0.200
     0.716     2.800     0.200
     0.770     1.971     0.200
     0.762     2.343     0.200
     1.103    -1.385     0.200
     1.343    -0.746     0.200
     1.424    -1.787     0.200
     1.481    -1.454     0.200
     1.490    -0.736     0.200
     1.686    -5.202     0.200
     1.649    -2.955     0.200
     1.667    -3.390     0.200
     1.716    -3.651     0.200
     1.946    -3.442     0.200
     2.356    -6.757     0.200
     2.554    -8.013     0.200
     2.867   -13.258     0.200
     0.560     4.824     0.200
     0.593     4.159     0.200
     0.653     3.244     0.200
     0.653     3.619     0.200
     0.629     3.801     0.200
     0.629     3.981     0.200
     0.723     2.245     0.200
     0.709     3.203     0.200
     0.758     3.212     0.200
     0.878     1.788     0.200
     1.021    -0.677     0.200
     1.205    -1.733     0.200
     1.272    -1.305     0.200
     1.302    -1.388     0.200
     1.378    -2.209     0.200
     1.378    -1.459     0.200
     1.372    -1.270     0.200
     1.402    -0.856     0.200
     1.601    -3.847     0.200
     1.621    -4.103     0.200
     1.688    -4.833     0.200
     1.681    -3.464     0.200
     1.890    -4.475     0.200
     2.317    -7.603     0.200
     2.383   -10.849     0.200
     2.520    -9.049     0.200
     2.526    -9.116     0.200
     2.707   -13.047     0.200
     2.653   -10.031     0.200
     2.683   -10.306     0.200
     2.801   -12.689     0.200
     2.916   -13.519     0.200
     2.862   -11.535     0.200
     4.487   -31.975     0.200
    11.249   -82.274     0.200
     1.243     0.390     0.200
     1.299     1.706     0.200
     5.755   -36.965     0.200
    12.561   -86.840     0.200
    14.950  -101.517     0.200
    17.450  -118.448     0.200
    18.900  -130.809     0.200
    19.609  -132.456     0.200
     1.048     0.739     0.200
     1.106     0.630     0.200
     2.786   -10.566     0.200
     5.770   -36.006     0.200
    12.499   -91.383     0.200
    17.510  -123.253     0.200
    18.849  -134.921     0.200
     1.058     0.011     0.200
     1.112     0.345     0.200
     1.233     0.440     0.200
     2.704    -9.937     0.200
     1.129     0.931     0.200
     1.183     0.686     0.200
     1.814    -4.776     0.200
     1.830    -4.868     0.200
     2.245    -7.102     0.200
     2.733   -10.225     0.200
     2.893   -11.340     0.200
     5.683   -37.236     0.200
    12.454   -89.633     0.200
    17.405  -119.712     0.200
     0.738     1.687     0.200
     0.893     1.448     0.200
     5.744   -39.212     0.200
    12.465   -89.760     0.200
     0.660     0.830     0.200
     0.695    -0.351     0.200
     0.767     2.230     0.200
     0.885     1.514     0.200
     0.903     1.093     0.200
     0.890     1.998     0.200
     0.935     1.442     0.200
     0.961     0.936     0.200
     0.957     1.178     0.200
     1.053     0.944     0.200
     1.528    -3.914     0.200
     1.545    -3.496     0.200
     1.598    -3.808     0.200
     1.619    -4.267     0.200
     1.663    -3.876     0.200
     1.712    -4.636     0.200
     2.176    -7.546     0.200
     2.524   -11.063     0.200
     3.720   -20.033     0.200
     5.505   -34.958     0.200
    18.588  -133.531     0.200
     0.942     0.936     0.200
     0.959     0.717     0.200
     0.990     0.906     0.200
     1.068     1.070     0.200
     1.125     0.889     0.200
     1.214     0.414     0.200
     2.770   -10.302     0.200
     5.745   -36.696     0.200
     0.756     1.447     0.200
     0.825     1.456     0.200
     0.933     0.463     0.200
     0.886     0.768     0.200
     0.902     1.513     0.200
     0.965    -0.491     0.200
     1.793    -5.909     0.200
     1.816    -5.368     0.200
     5.785   -38.146     0.200
    12.508   -89.512     0.200
    16.906  -124.484     0.200
    16.906  -124.016     0.200
    17.527  -123.963     0.200
    18.859  -133.852     0.200
     0.709     2.389     0.200
     0.870     0.102     0.200
     0.789     1.941     0.200
     0.845     1.280     0.200
     0.860     1.609     0.200
     1.857    -5.977     0.200
     5.765   -36.832     0.200
    12.471   -89.260     0.200
    17.517  -122.648     0.200
    18.824  -134.385     0.200
     0.780     1.124     0.200
     0.849     0.570     0.200
     0.935     0.792     0.200
     0.955    -0.125     0.200
     0.910    -0.081     0.200
     0.910     0.669     0.200
     0.926     1.250     0.200
     0.987     0.197     0.200
     1.798    -5.228     0.200
     1.820    -5.151     0.200
     1.894    -5.701     0.200
     2.882   -12.607     0.200
     5.781   -37.272     0.200
    12.514   -89.901     0.200
    17.518  -120.256     0.200
     0.516     4.715     0.200
     0.666     3.772     0.200
     0.684     3.269     0.200
     0.716     3.021     0.200
     0.684     3.476     0.200
     0.675     3.469     0.200
     0.639     3.309     0.200
     0.754     0.381     0.200
     1.048     1.549     0.200
     1.447    -0.053     0.200
     1.681    -3.982     0.200
     5.717   -37.780     0.200
     5.717   -37.093     0.200
    17.508  -124.007     0.200
    18.710  -131.054     0.200
     0.999     1.432     0.200
     1.031     1.260     0.200
     3.495   -15.280     0.200
     5.878   -39.487     0.200
    12.682   -87.913     0.200
    17.565  -123.109     0.200
    19.023  -134.476     0.200
     5.799   -39.380     0.200
     0.433     3.702     0.200
     0.832     1.034     0.200
     0.832     1.293     0.200
     0.885     1.750     0.200
     0.902     1.424     0.200
     1.015     0.613     0.200
     1.052    -0.712     0.200
     1.057    -0.792     0.200
     1.201    -3.839     0.200
     1.282    -1.247     0.200
     1.355    -2.999     0.200
     1.446    -4.031     0.200
     1.700    -0.580     0.200
     1.913    -4.861     0.200
     1.911    -3.368     0.200
     1.911    -2.373     0.200
     5.244   -33.683     0.200
    18.323  -128.885     0.200
     0.848     1.583     0.200
     0.848     1.923     0.200
     1.422    -3.320     0.200
     5.218   -34.351     0.200
     0.366     5.399     0.200
     0.849     3.424     0.200
     0.850     3.162     0.200
     0.816     2.684     0.200
     0.872     3.264     0.200
     0.982     2.664     0.200
     1.039     1.707     0.200
     1.047     1.140     0.200
     1.158     0.693     0.200
     1.067     1.026     0.200
     1.297    -2.811     0.200
     0.863     1.175     0.200
     5.099   -32.619     0.200
    12.048   -87.687     0.200
     0.859     3.580     0.200
     0.859     3.748     0.200
     0.918     3.470     0.200
     0.922     4.203     0.200
     0.936     4.045     0.200
     1.086     1.835     0.200
     1.076     2.891     0.200
     1.080     2.125     0.200
     1.304    -0.579     0.200
     1.240     2.139     0.200
     2.916   -15.749     0.200
     3.912   -18.405     0.200
     4.413   -22.789     0.200
     5.259   -34.366     0.200
     2.738    -9.465     0.200
     3.572   -19.315     0.200
     1.303    -1.140     0.200
     1.610    -4.071     0.200
     1.790    -5.382     0.200
     2.271    -7.146     0.200
     2.402    -9.207     0.200
     2.401    -9.067     0.200
     5.439   -34.068     0.200
    12.486   -87.565     0.200
    15.632  -101.093     0.200
    16.970  -118.777     0.200
    18.776  -130.003     0.200
    18.982  -134.454     0.200
     0.941     0.255     0.200
     5.196   -34.736     0.200
    12.158   -89.049     0.200
    16.827  -118.092     0.200
    18.464  -130.330     0.200
     1.350     1.647     0.200
     1.371     0.491     0.200
     1.395     1.487     0.200
     1.416     2.417     0.200
     0.831     2.927     0.200
     0.886     2.107     0.200
     1.016     4.523     0.200
     1.372    -0.503     0.200
     2.250    -5.595     0.200
     1.286     1.605     0.200
     1.311     1.527     0.200
     1.349     1.650     0.200
     1.368     2.446     0.200
     1.630    -2.552     0.200
     0.431     7.004     0.200
     0.986    -0.233     0.200
     1.156    -0.652     0.200
     3.854   -25.935     0.200
     1.012     0.734     0.200
     1.258     1.994     0.200
     1.470    -2.096     0.200
     4.706   -26.764     0.200
     3.566   -15.749     0.200
     2.951   -15.894     0.200
     3.744   -19.681     0.200
     5.344   -31.520     0.200
     0.294     6.133     0.200
     2.755   -16.395     0.200
     3.920   -22.350     0.200
     5.189   -32.982     0.200
     5.528   -34.284     0.200
     8.846   -56.951     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     5.367    -9.825     0.200
     0.276     4.668     0.200
     1.263     0.178     0.200
     1.263     0.493     0.200
     1.367     1.301     0.200
     1.427    -1.422     0.200
     1.360     0.846     0.200
     2.815    -8.721     0.200
     0.379     3.371     0.200
     1.401    -1.444     0.200
     1.502     0.153     0.200
     1.176     0.986     0.200
     1.177     0.386     0.200
     2.983    -8.670     0.200
     1.197     0.203     0.200
     1.908    -2.128     0.200
     0.857    -1.031     0.200
     1.670    -1.763     0.200
     1.937    -3.516     0.200
     3.282   -11.243     0.200
     0.749     1.079     0.200
     1.430    -0.533     0.200
     2.080    -5.488     0.200
     0.647     0.965     0.200
     1.337    -0.734     0.200
     1.552    -0.272     0.200
     1.486    -0.055     0.200
     2.160    -5.312     0.200
     2.864    -7.559     0.200
     0.801     0.210     0.200
     1.504    -0.591     0.200
     2.905    -9.669     0.200
     0.635     0.191     0.200
     3.190   -12.011     0.200
     1.704     1.677     0.200
     0.579     1.346     0.200
     0.721     0.319     0.200
     1.494    -0.996     0.200
     2.734    -7.346     0.200
     1.437    -1.528     0.200
     2.046    -1.988     0.200
     0.553     1.611     0.200
     1.105     1.938     0.200
     1.430    -2.444     0.200
     1.764    -2.371     0.200
     1.764    -1.273     0.200
     2.176    -4.444     0.200
     3.223   -10.566     0.200
     0.357     2.409     0.200
     0.702     1.208     0.200
     1.901    -2.010     0.200
     2.307    -6.181     0.200
     0.341     2.189     0.200
     0.700    -0.334     0.200
     1.596    -2.782     0.200
     1.619     0.896     0.200
     1.914    -1.915     0.200
     1.914    -1.697     0.200
     0.145     4.872     0.200
     0.619     0.888     0.200
     1.756    -1.315     0.200
     0.845     0.814     0.200
     0.967    -0.457     0.200
     1.553     1.026     0.200
     1.387    -1.549     0.200
     3.264   -11.183     0.200
     0.642     1.726     0.200
     1.392    -2.323     0.200
     2.275    -4.096     0.200
     2.614    -5.297     0.200
     2.693    -7.730     0.200
     1.405     0.474     0.200
     1.766    -3.733     0.200
     2.083    -3.908     0.200
     2.492    -7.400     0.200
     1.957    -2.964     0.200
     2.936    -8.621     0.200
     0.839     1.354     0.200
     0.844     1.188     0.200
     0.975    -0.145     0.200
     2.863    -8.260     0.200
     0.205     4.842     0.200
     0.207     4.891     0.200
     1.516    -3.438     0.200
     2.415    -5.304     0.200
     1.647    -3.598     0.200
     2.251    -5.458     0.200
     0.589     0.445     0.200
     0.590     0.532     0.200
     0.635     2.364     0.200
     0.635     2.590     0.200
     1.643     0.220     0.200
     1.548    -1.980     0.200
     0.844     0.903     0.200
     1.076     1.527     0.200
     2.826    -9.400     0.200
     3.026    -9.558     0.200
     0.307     3.898     0.200
     0.318     3.528     0.200
     0.499     2.393     0.200
     0.499     2.534     0.200
     1.159    -0.502     0.200
     1.160    -0.532     0.200
     1.467    -1.428     0.200
     0.394     1.944     0.200
     0.406     1.599     0.200
     1.263    -2.734     0.200
     1.219     0.616     0.200
     2.036    -1.695     0.200
     2.202    -4.421     0.200
     2.278    -6.656     0.200
     2.975    -8.385     0.200
     3.288    -5.569     0.200
     0.922     0.223     0.200
     1.065    -1.169     0.200
     1.071    -0.098     0.200
     1.170     1.155     0.200
     1.170    -0.130     0.200
     1.821    -3.571     0.200
     1.194    -0.612     0.200
     1.550    -0.939     0.200
     1.551    -0.948     0.200
     1.182     0.047     0.200
     2.316    -7.456     0.200
     0.888    -0.331     0.200
     0.893     0.224     0.200
     1.012    -0.629     0.200
     0.641     0.352     0.200
     1.358    -0.013     0.200
     1.724     1.270     0.200
     1.724     1.593     0.200
     1.563    -1.413     0.200
     2.263    -4.275     0.200
     0.187     4.005     0.200
     0.194     4.217     0.200
     1.322     0.135     0.200
     1.351     1.436     0.200
     1.633    -0.916     0.200
     2.087    -3.587     0.200
     0.261     4.538     0.200
     0.263     4.448     0.200
     1.465    -2.637     0.200
     1.573    -1.181     0.200
     1.585    -2.062     0.200
     1.845    -3.123     0.200
     0.568     0.702     0.200
     0.570     0.647     0.200
     0.643     2.983     0.200
     0.222     3.049     0.200
     0.218     3.182     0.200
     0.690     1.167     0.200
     1.246     0.548     0.200
     1.245     0.120     0.200
     1.264     0.350     0.200
     1.568    -2.366     0.200
     1.569    -2.402     0.200
     2.019    -2.108     0.200
     2.822    -8.797     0.200
     0.194     4.864     0.200
     0.193     4.901     0.200
     1.223    -1.031     0.200
     1.485    -2.155     0.200
     1.486    -2.178     0.200
     1.553    -0.799     0.200
     2.407    -5.467     0.200
     0.777    -0.043     0.200
     1.331     1.922     0.200
     0.834     0.450     0.200
     1.544    -0.400     0.200
     2.610    -7.585     0.200
     4.185    -6.348     0.200
     0.231     3.954     0.200
     1.353    -0.445     0.200
     1.356     0.176     0.200
     0.231     3.678     0.200
     0.645     1.329     0.200
     1.205     0.011     0.200
     1.205    -0.145     0.200
     1.337    -0.569     0.200
     1.515    -1.393     0.200
     1.770    -4.494     0.200
     0.259     4.355     0.200
     0.270     3.671     0.200
     0.911     1.529     0.200
     0.911     1.263     0.200
     1.468    -0.707     0.200
     1.465    -0.884     0.200
     1.482    -0.981     0.200
     1.783    -2.304     0.200
     0.860     2.262     0.200
     0.865     2.096     0.200
     0.991     0.636     0.200
     1.557     1.289     0.200
     6.046   -15.378     0.200
     0.878     0.717     0.200
     1.019    -1.394     0.200
     1.019    -0.898     0.200
     1.563     1.791     0.200
     0.842     1.960     0.200
     0.986     1.044     0.200
     1.135     1.641     0.200
     1.876     0.816     0.200
     0.877     2.060     0.200
     1.559    -1.727     0.200
     2.100    -4.077     0.200
     2.101    -4.120     0.200
     0.234     3.579     0.200
     0.243     2.895     0.200
     0.825     0.533     0.200
     1.373    -0.469     0.200
     1.370    -1.039     0.200
     1.387    -0.063     0.200
     2.107    -3.036     0.200
     0.346     3.622     0.200
     1.123     0.267     0.200
     1.259     0.221     0.200
     1.277    -0.083     0.200
     1.311     0.070     0.200
     1.509    -2.536     0.200
     0.324     3.713     0.200
     1.381    -0.953     0.200
     1.501    -3.357     0.200
     1.474    -0.309     0.200
     1.661    -2.031     0.200
     1.672    -2.024     0.200
     1.700    -2.504     0.200
     1.803    -2.854     0.200
     0.879     0.628     0.200
     0.883     0.486     0.200
     1.422    -1.239     0.200
     2.872    -8.763     0.200
     2.993    -8.754     0.200
     0.720     0.718     0.200
     0.919     1.546     0.200
     1.119    -0.938     0.200
     1.037     1.208     0.200
     1.177     0.387     0.200
     2.083    -4.806     0.200
     0.916     0.080     0.200
     0.916     0.643     0.200
     1.011     0.715     0.200
     0.715     0.053     0.200
     0.848     0.076     0.200
     1.619    -0.491     0.200
     1.619    -0.073     0.200
     2.214    -5.055     0.200
     5.592   -12.741     0.200
     0.209     4.522     0.200
     0.215     4.231     0.200
     0.726     0.428     0.200
     0.726     0.647     0.200
     1.282     0.454     0.200
     1.299    -0.446     0.200
     1.299     0.179     0.200
     1.310     0.837     0.200
     1.412     0.088     0.200
     1.594    -2.110     0.200
     1.594    -1.431     0.200
     2.382    -5.082     0.200
     0.580     2.161     0.200
     1.174    -0.180     0.200
     1.174     0.210     0.200
     1.302    -0.520     0.200
     1.497    -0.718     0.200
     1.921    -4.569     0.200
     1.970    -2.887     0.200
     1.882    -3.137     0.200
     1.897    -2.507     0.200
     2.016    -4.560     0.200
     1.928    -2.669     0.200
     0.228     4.490     0.200
     0.228     4.304     0.200
     0.609     1.757     0.200
     0.609     2.017     0.200
     0.609     1.879     0.200
     1.231    -0.650     0.200
     1.310    -0.671     0.200
     1.336    -1.539     0.200
     1.356    -1.048     0.200
     1.575    -1.494     0.200
     1.575    -1.342     0.200
     1.574    -3.051     0.200
     2.242    -5.726     0.200
     2.242    -5.021     0.200
     0.868     1.506     0.200
     1.545    -0.106     0.200
     1.545     0.163     0.200
     0.299     1.158     0.200
     0.536     0.563     0.200
     1.916    -1.338     0.200
     0.683     0.264     0.200
     0.824    -0.290     0.200
     0.931     1.072     0.200
     1.102     0.050     0.200
     0.172     4.133     0.200
     1.516    -2.239     0.200
     1.527    -2.674     0.200
     2.051    -3.938     0.200
     2.786    -6.178     0.200
     0.541     1.730     0.200
     0.882     0.750     0.200
     1.308    -0.184     0.200
     1.649    -3.205     0.200
     0.578     1.916     0.200
     1.755    -2.950     0.200
     1.871    -0.932     0.200
     2.054    -5.514     0.200
     2.054    -4.354     0.200
     2.139    -4.840     0.200
     2.201    -6.325     0.200
     2.186    -3.846     0.200
     1.148     0.144     0.200
     1.144     0.013     0.200
     1.308    -0.521     0.200
     4.241    -6.243     0.200
     1.188    -0.964     0.200
     1.129     0.641     0.200
     1.129    -0.851     0.200
     1.129     0.497     0.200
     1.463    -0.119     0.200
     1.838    -3.246     0.200
     1.858    -2.980     0.200
     1.884    -3.319     0.200
     1.983    -2.839     0.200
     2.080    -4.448     0.200
     2.093    -4.740     0.200
     0.643     2.866     0.200
     1.254    -0.076     0.200
     1.220     0.128     0.200
     1.384    -2.144     0.200
     1.384    -2.331     0.200
     1.889    -2.700     0.200
     1.936    -3.148     0.200
     1.933    -2.685     0.200
     1.956    -2.854     0.200
     1.980    -2.123     0.200
     2.077    -2.303     0.200
     2.178    -3.859     0.200
     2.192    -5.312     0.200
     3.058   -10.402     0.200
     3.185   -10.595     0.200
     0.764    -0.362     0.200
     0.764    -0.635     0.200
     0.689     2.171     0.200
     0.690     1.976     0.200
     1.282    -0.125     0.200
     1.282    -1.875     0.200
     4.352    -8.151     0.200
     0.705     1.360     0.200
     0.636     0.210     0.200
     0.634     0.113     0.200
     0.693     0.514     0.200
     0.693     0.073     0.200
     0.853     0.817     0.200
     3.042    -9.260     0.200
     0.708     1.175     0.200
     1.169    -0.699     0.200
     1.319    -1.232     0.200
     0.477     3.227     0.200
     0.969     0.435     0.200
     0.487     1.676     0.200
     0.560     1.723     0.200
     0.812     0.650     0.200
     3.500   -12.452     0.200
     5.143   -11.172     0.200
     0.769     2.536     0.200
     0.917     1.220     0.200
     0.900     1.811     0.200
     0.952     1.749     0.200
     0.779     2.139     0.200
     0.907     1.353     0.200
     0.922     1.035     0.200
     0.969     1.679     0.200
     0.965     1.405     0.200
     1.025     1.008     0.200
     0.757     2.003     0.200
     0.874    -1.383     0.200
     0.915     0.038     0.200
     0.804     0.057     0.200
     0.586     1.214     0.200
     0.934     1.458     0.200
     1.019     0.935     0.200
     1.026     1.520     0.200
     1.142     0.747     0.200
     1.904    -4.890     0.200
     2.095    -2.034     0.200
     3.207   -11.113     0.200
     3.207   -11.273     0.200
     0.981     0.536     0.200
     0.981     0.845     0.200
     1.255    -2.384     0.200
     1.255    -2.185     0.200
     1.282    -0.677     0.200
     1.753    -3.306     0.200
     1.981    -5.741     0.200
     0.388     1.897     0.200
     0.392     1.666     0.200
     0.686    -0.259     0.200
     0.686    -0.064     0.200
     1.061     0.780     0.200
     1.150     1.001     0.200
     1.157     0.635     0.200
     1.273     0.178     0.200
     1.266     0.151     0.200
     1.268    -1.055     0.200
     2.071    -3.112     0.200
     5.270   -12.474     0.200
     0.239     4.816     0.200
     1.226    -0.394     0.200
     1.358    -2.672     0.200
     1.527    -2.155     0.200
     1.559    -0.765     0.200
     1.749    -2.896     0.200
     1.762    -3.384     0.200
     0.746     1.859     0.200
     0.912    -1.540     0.200
     0.912    -1.087     0.200
     1.554    -0.231     0.200
     2.732    -7.836     0.200
     2.732    -8.965     0.200
     3.215   -10.847     0.200
     3.215   -11.687     0.200
     0.880    -0.576     0.200
     0.880     0.995     0.200
     0.828     1.244     0.200
     0.985     0.306     0.200
     1.018     0.249     0.200
     0.974     0.164     0.200
     0.987     0.903     0.200
     1.675    -1.079     0.200
     1.946    -3.593     0.200
     1.865    -2.634     0.200
     2.807    -7.494     0.200
     2.880    -8.261     0.200
     2.978    -8.817     0.200
     3.332   -10.799     0.200
     0.737     2.084     0.200
     1.298    -0.703     0.200
     1.515    -0.062     0.200
     1.515     0.216     0.200
     1.515    -1.022     0.200
     2.015    -2.863     0.200
     2.044    -2.117     0.200
     2.064    -2.893     0.200
     2.160    -2.842     0.200
     2.266    -6.321     0.200
     2.266    -4.169     0.200
     2.280    -4.069     0.200
     2.891    -6.985     0.200
     3.024    -8.609     0.200
     3.169   -10.849     0.200
     3.353   -10.953     0.200
     1.061     0.708     0.200
     1.165     0.180     0.200
     1.151     0.480     0.200
     1.310     0.007     0.200
     1.692    -3.312     0.200
     1.787    -2.614     0.200
     1.875    -1.797     0.200
     1.927    -2.592     0.200
     1.931    -2.036     0.200
     2.022    -2.398     0.200
     2.150    -4.401     0.200
     2.168    -5.143     0.200
     0.733     1.897     0.200
     0.851    -0.397     0.200
     0.894     0.821     0.200
     1.757    -4.390     0.200
     2.739    -8.607     0.200
     2.782    -8.397     0.200
     0.169     5.413     0.200
     0.174     4.923     0.200
     1.177    -1.670     0.200
     1.181    -0.835     0.200
     1.202    -0.176     0.200
     1.314    -1.981     0.200
     1.232    -0.674     0.200
     1.358    -1.978     0.200
     1.408    -0.654     0.200
     1.409    -1.826     0.200
     1.340    -0.145     0.200
     1.400    -1.905     0.200
     1.410    -2.562     0.200
     2.113    -6.674     0.200
     2.209    -6.680     0.200
     2.264    -5.028     0.200
     2.401    -6.136     0.200
     2.468    -5.481     0.200
     0.586     0.547     0.200
     0.591     0.270     0.200
     0.813    -0.641     0.200
     2.064    -3.301     0.200
     3.084    -9.577     0.200
     3.128   -10.344     0.200
     3.128   -10.783     0.200
     3.609   -13.476     0.200
     0.238     4.739     0.200
     0.821     0.995     0.200
     1.093    -0.519     0.200
     1.358    -1.994     0.200
     1.515    -0.601     0.200
     1.526    -1.793     0.200
     1.558    -1.691     0.200
     1.748    -2.994     0.200
     0.766     1.580     0.200
     0.891    -1.184     0.200
     0.891    -0.336     0.200
     1.963    -5.310     0.200
     2.731    -7.650     0.200
     2.775    -8.706     0.200
     3.258   -12.116     0.200
     5.758   -14.469     0.200
     0.451     2.475     0.200
     0.513     2.191     0.200
     0.513     2.550     0.200
     0.915     1.254     0.200
     0.980     0.958     0.200
     0.994     0.970     0.200
     1.108     1.281     0.200
     1.129     0.206     0.200
     1.135    -0.145     0.200
     1.521    -1.290     0.200
     1.973    -3.220     0.200
     0.341     4.615     0.200
     0.352     3.595     0.200
     0.535     3.867     0.200
     0.535     2.987     0.200
     1.116    -0.841     0.200
     1.253    -0.085     0.200
     1.302    -0.935     0.200
     1.306    -0.003     0.200
     1.525    -1.657     0.200
     1.544    -1.824     0.200
     0.454     1.865     0.200
     0.520     2.530     0.200
     0.520     2.360     0.200
     0.916     1.420     0.200
     0.983     0.683     0.200
     0.996     1.132     0.200
     1.128     0.348     0.200
     1.330    -2.266     0.200
     1.490    -1.389     0.200
     3.184   -11.499     0.200
     3.227   -11.379     0.200
     0.830     0.520     0.200
     1.356    -0.225     0.200
     1.338    -1.816     0.200
     1.354    -1.426     0.200
     1.386    -0.110     0.200
     2.152    -5.185     0.200
     0.652     1.685     0.200
     0.652     2.088     0.200
     0.654     2.184     0.200
     1.217    -1.355     0.200
     1.361    -1.404     0.200
     1.932    -2.637     0.200
     1.959    -3.690     0.200
     1.980    -2.353     0.200
     2.181    -5.017     0.200
     1.121    -0.743     0.200
     1.121     0.667     0.200
     1.205    -0.603     0.200
     1.282    -0.706     0.200
     1.423    -3.181     0.200
     1.826    -3.309     0.200
     1.841    -3.421     0.200
     1.871    -3.380     0.200
     2.063    -5.621     0.200
     2.076    -5.134     0.200
     0.438     1.468     0.200
     0.440     1.669     0.200
     0.500     2.911     0.200
     0.500     2.770     0.200
     0.922     0.867     0.200
     0.982     1.293     0.200
     0.997     1.129     0.200
     1.137     0.033     0.200
     1.143    -0.016     0.200
     1.373    -1.619     0.200
     1.524    -2.668     0.200
     1.051     1.692     0.200
     1.060     1.012     0.200
     1.255    -1.669     0.200
     1.420    -2.357     0.200
     1.407    -1.529     0.200
     1.440    -1.084     0.200
     1.441     0.496     0.200
     1.919    -4.006     0.200
     2.003    -5.005     0.200
     2.124    -5.367     0.200
     2.232    -6.429     0.200
     0.859    -0.396     0.200
     0.859     0.414     0.200
     0.803     0.845     0.200
     0.846    -0.569     0.200
     0.960    -0.284     0.200
     0.953    -0.217     0.200
     0.965    -0.039     0.200
     1.752    -2.952     0.200
     2.287    -5.875     0.200
     2.802    -7.952     0.200
     0.817     0.987     0.200
     1.340    -1.561     0.200
     1.355    -0.682     0.200
     1.355    -0.333     0.200
     1.384    -0.850     0.200
     1.384    -0.469     0.200
     1.936    -3.880     0.200
     0.189     4.872     0.200
     1.164    -0.892     0.200
     1.188     0.024     0.200
     1.218    -0.353     0.200
     1.366    -1.863     0.200
     1.326     0.779     0.200
     1.383    -1.212     0.200
     1.393    -2.020     0.200
     0.731     1.040     0.200
     1.266    -0.339     0.200
     1.662    -2.647     0.200
     3.223   -11.379     0.200
     0.635     0.118     0.200
     0.644     1.172     0.200
     1.513    -3.179     0.200
     1.664    -2.731     0.200
     1.697    -0.901     0.200
     0.857     2.947     0.200
     0.862     2.741     0.200
     0.966     1.423     0.200
     0.966     0.978     0.200
     0.929     2.228     0.200
     1.066     1.918     0.200
     1.992    -2.147     0.200
     2.879    -6.907     0.200
     2.879    -7.087     0.200
     0.658     1.046     0.200
     0.658     0.925     0.200
     2.064    -6.058     0.200
     3.012   -10.099     0.200
     5.480   -10.778     0.200
     0.632     1.273     0.200
     0.636     1.033     0.200
     1.116     1.014     0.200
     1.116    -0.386     0.200
     1.324    -1.288     0.200
     2.078    -6.082     0.200
     2.107    -5.863     0.200
     0.177     4.826     0.200
     0.183     4.905     0.200
     1.521    -2.078     0.200
     1.571    -2.347     0.200
     1.552    -0.762     0.200
     1.666    -4.090     0.200
     1.737    -2.287     0.200
     1.745    -2.786     0.200
     1.846    -4.287     0.200
     0.826     0.929     0.200
     0.826     1.309     0.200
     0.901    -0.417     0.200
     0.986     0.373     0.200
     0.966     0.436     0.200
     0.981     0.687     0.200
     1.356    -2.896     0.200
     1.356    -0.675     0.200
     1.656    -0.530     0.200
     1.793    -1.560     0.200
     1.968    -2.498     0.200
     1.969    -1.589     0.200
     2.327    -5.276     0.200
     2.827    -7.358     0.200
     0.141     5.099     0.200
     0.146     4.706     0.200
     0.713     0.593     0.200
     1.253    -0.570     0.200
     1.301     0.115     0.200
     1.323    -0.615     0.200
     1.336    -0.164     0.200
     1.468    -1.068     0.200
     1.474    -1.831     0.200
     1.994    -5.417     0.200
     0.181     4.618     0.200
     1.172    -0.407     0.200
     1.198     1.591     0.200
     1.226     1.085     0.200
     1.390     0.095     0.200
     1.656    -3.586     0.200
     0.263     4.188     0.200
     0.864     1.117     0.200
     1.532     0.378     0.200
     1.890    -5.295     0.200
     0.374     3.131     0.200
     1.623    -0.065     0.200
     2.371    -6.361     0.200
     0.452     1.392     0.200
     0.410     4.334     0.200
     1.020     0.820     0.200
     2.033    -5.946     0.200
     2.377    -6.038     0.200
     2.499    -7.114     0.200
     2.569    -8.455     0.200
     2.728    -9.461     0.200
     0.505     2.797     0.200
     2.367    -5.269     0.200
     2.488    -6.295     0.200
     2.555    -8.102     0.200
     0.495     1.255     0.200
     1.104    -0.783     0.200
     1.709    -3.968     0.200
     2.405    -6.296     0.200
     2.525    -7.875     0.200
     2.593    -8.766     0.200
     0.397     2.792     0.200
     1.613    -1.567     0.200
     1.824    -1.279     0.200
     0.333     3.395     0.200
     1.546     0.200     0.200
     0.539     2.024     0.200
     0.549     1.795     0.200
     1.617    -0.732     0.200
     1.835    -2.706     0.200
     2.280    -2.841     0.200
     0.484     2.634     0.200
     1.661    -2.405     0.200
     2.477    -6.169     0.200
     2.545    -6.966     0.200
     0.348     4.605     0.200
     0.941     0.905     0.200
     1.578    -3.501     0.200
     2.336    -6.680     0.200
     2.459    -6.825     0.200
     2.529    -8.136     0.200
     0.591     1.401     0.200
     1.143    -1.473     0.200
     2.332    -3.157     0.200
     2.517    -5.573     0.200
     0.430     1.995     0.200
     0.441     2.001     0.200
     1.659    -2.818     0.200
     2.398    -5.642     0.200
     0.244     3.167     0.200
     0.254     3.505     0.200
     1.564    -1.420     0.200
     0.450     3.247     0.200
     1.574    -0.936     0.200
     0.349     3.651     0.200
     0.359     3.361     0.200
     1.621    -3.678     0.200
     0.553     3.343     0.200
     0.405     3.178     0.200
     1.009    -0.134     0.200
     1.634    -0.433     0.200
     1.634     1.317     0.200
     0.288     2.963     0.200
     0.929    -0.318     0.200
     1.601    -1.091     0.200
     1.791    -2.073     0.200
     1.911    -5.171     0.200
     1.897    -2.594     0.200
     2.203    -6.538     0.200
     2.326    -5.846     0.200
     2.445    -5.964     0.200
     2.511    -7.476     0.200
     0.374     3.858     0.200
     1.618    -1.207     0.200
     1.817    -1.635     0.200
     0.447     1.648     0.200
     1.045    -1.060     0.200
     0.335     2.302     0.200
     0.958     0.061     0.200
     1.610    -2.628     0.200
     0.343     3.720     0.200
     0.353     3.977     0.200
     0.980     0.808     0.200
     0.980     0.968     0.200
     1.832    -3.832     0.200
     1.962    -3.171     0.200
     2.402    -7.871     0.200
     0.258     3.168     0.200
     0.872     0.337     0.200
     0.872    -0.553     0.200
     1.469    -1.628     0.200
     1.545    -1.497     0.200
     1.733    -1.562     0.200
     1.733    -0.812     0.200
     1.886    -4.537     0.200
     2.807    -9.674     0.200
     0.394     3.232     0.200
     1.010     0.046     0.200
     1.843    -4.011     0.200
     2.382    -7.549     0.200
     1.127    -0.104     0.200
     1.748    -2.023     0.200
     1.953    -4.774     0.200
     0.455     3.024     0.200
     1.061    -1.062     0.200
     1.673     0.826     0.200
     1.879    -0.995     0.200
     2.385    -5.998     0.200
     2.506    -6.579     0.200
     2.575    -8.163     0.200
     0.584     2.505     0.200
     1.816    -3.285     0.200
     2.485    -7.420     0.200
     0.590     2.400     0.200
     1.173    -0.600     0.200
     1.740    -2.787     0.200
     1.956    -4.544     0.200
     2.389    -5.376     0.200
     2.508    -7.173     0.200
     2.574    -7.120     0.200
     2.812    -9.652     0.200
     0.357     4.240     0.200
     0.368     4.417     0.200
     0.994     1.364     0.200
     0.994     0.894     0.200
     1.843    -0.931     0.200
     2.529    -7.821     0.200
     2.599    -8.512     0.200
     0.621     2.553     0.200
     1.229    -1.883     0.200
     1.806    -2.512     0.200
     2.451    -7.018     0.200
     2.569    -7.069     0.200
     2.635    -8.701     0.200
     0.452     4.496     0.200
     1.105    -0.408     0.200
     1.947    -5.232     0.200
     0.501     3.932     0.200
     1.045     0.292     0.200
     1.827    -1.601     0.200
     0.497     2.844     0.200
     1.094    -0.663     0.200
     1.901    -2.063     0.200
     2.384    -7.041     0.200
     2.505    -8.202     0.200
     0.352     3.043     0.200
     1.554    -1.746     0.200
     1.753    -1.702     0.200
     2.437    -5.493     0.200
     2.508    -6.820     0.200
     2.665    -7.561     0.200
     0.531     2.190     0.200
     1.136    -0.332     0.200
     1.730    -2.119     0.200
     1.941    -3.298     0.200
     2.411    -6.855     0.200
     2.530    -7.506     0.200
     0.333     1.897     0.200
     1.544    -2.694     0.200
     1.569    -1.688     0.200
     1.766    -2.452     0.200
     2.334    -6.032     0.200
     2.685    -7.372     0.200
     2.788    -8.611     0.200
     0.266     4.258     0.200
     1.480    -2.497     0.200
     1.558    -1.320     0.200
     1.747    -1.931     0.200
     2.354    -7.337     0.200
     2.816    -9.994     0.200
     0.291     3.538     0.200
     0.301     2.913     0.200
     1.568    -1.529     0.200
     1.759    -3.773     0.200
     1.918    -3.948     0.200
     2.353    -7.198     0.200
     2.548    -8.599     0.200
     2.811    -9.401     0.200
     1.163    -0.647     0.200
     1.964    -5.113     0.200
     2.421    -6.987     0.200
     2.540    -7.424     0.200
     0.514     1.805     0.200
     0.557     2.189     0.200
     0.567     2.551     0.200
     1.113     0.010     0.200
     1.672    -0.211     0.200
     1.888    -3.437     0.200
     2.329    -5.547     0.200
     2.449    -6.183     0.200
     2.515    -7.364     0.200
     2.677    -9.004     0.200
     0.532     2.524     0.200
     0.542     2.450     0.200
     1.109    -0.901     0.200
     1.900    -3.027     0.200
     2.360    -5.630     0.200
     2.480    -5.770     0.200
     2.547    -7.377     0.200
     2.708    -9.293     0.200
     0.521     3.513     0.200
     0.532     3.193     0.200
     1.120     0.239     0.200
     1.922    -4.610     0.200
     2.394    -7.160     0.200
     2.514    -7.267     0.200
     2.581    -8.939     0.200
     0.419     3.594     0.200
     0.429     3.141     0.200
     1.018     0.177     0.200
     1.018    -0.044     0.200
     2.485    -8.239     0.200
     2.554    -8.795     0.200
     2.713    -9.558     0.200
     1.201    -1.100     0.200
     1.986    -4.739     0.200
     2.412    -7.959     0.200
     2.531    -8.026     0.200
     2.596    -7.802     0.200
     1.159    -0.568     0.200
     1.734    -1.978     0.200
     1.949    -4.230     0.200
     2.393    -6.627     0.200
     0.449     3.308     0.200
     1.035     0.777     0.200
     2.351    -5.529     0.200
     2.792    -9.948     0.200
     0.459     3.088     0.200
     0.469     2.248     0.200
     1.067     0.300     0.200
     1.067    -0.290     0.200
     1.680    -1.432     0.200
     1.886    -3.512     0.200
     2.391    -6.565     0.200
     2.581    -7.838     0.200
     1.158    -0.750     0.200
     1.948    -5.511     0.200
     2.394    -6.605     0.200
     2.513    -7.494     0.200
     2.579    -8.478     0.200
     1.868    -2.635     0.200
     0.520     3.670     0.200
     0.531     2.329     0.200
     1.069     0.668     0.200
     1.635    -1.833     0.200
     1.850    -2.412     0.200
     2.309    -6.889     0.200
     2.496    -8.024     0.200
     0.358     3.411     0.200
     1.593    -1.608     0.200
     1.792    -2.635     0.200
     2.347    -6.212     0.200
     0.294     3.935     0.200
     1.593    -1.610     0.200
     1.784    -2.854     0.200
     1.919    -3.832     0.200
     2.377    -6.859     0.200
     0.238     3.569     0.200
     1.519    -1.480     0.200
     1.705    -1.760     0.200
     1.856    -3.976     0.200
     0.386     2.601     0.200
     1.712    -2.334     0.200
     1.828    -3.118     0.200
     2.011    -3.543     0.200
     2.817    -9.387     0.200
     0.461     1.365     0.200
     1.073     0.887     0.200
     1.073     0.457     0.200
     1.688    -1.467     0.200
     2.520    -6.998     0.200
     2.588    -7.707     0.200
     2.837    -9.678     0.200
     0.543     3.222     0.200
     1.125     0.182     0.200
     2.371    -6.349     0.200
     2.491    -6.843     0.200
     2.558    -7.993     0.200
     2.719    -8.264     0.200
     1.987    -2.400     0.200
     2.411    -5.068     0.200
     2.530    -6.822     0.200
     2.595    -6.766     0.200
     2.831    -8.780     0.200
     0.412     3.704     0.200
     0.452     3.132     0.200
     1.064    -0.914     0.200
     1.886    -5.116     0.200
     0.568     1.967     0.200
     0.578     3.019     0.200
     1.157     0.292     0.200
     1.157    -0.809     0.200
     1.947    -4.780     0.200
     2.578    -8.746     0.200
     0.560     2.281     0.200
     0.570     1.216     0.200
     1.149    -0.328     0.200
     1.149    -1.156     0.200
     1.726    -3.901     0.200
     1.940    -4.948     0.200
     2.390    -6.391     0.200
     0.417     3.697     0.200
     0.427     3.365     0.200
     1.012     0.413     0.200
     1.012    -0.157     0.200
     1.630    -1.117     0.200
     1.834    -4.475     0.200
     2.357    -7.038     0.200
     2.479    -7.309     0.200
     0.531     1.519     0.200
     1.751    -3.333     0.200
     2.445    -7.718     0.200
     0.456     3.000     0.200
     1.061    -0.389     0.200
     1.879    -5.014     0.200
     2.384    -7.200     0.200
     2.505    -8.221     0.200
     0.478     2.399     0.200
     1.695    -2.350     0.200
     1.672    -0.053     0.200
     1.880    -4.734     0.200
     2.493    -6.498     0.200
     2.561    -7.712     0.200
     2.721    -8.326     0.200
     2.809    -9.089     0.200
     2.909    -9.342     0.200
     0.301     4.477     0.200
     0.909     0.647     0.200
     1.566    -2.146     0.200
     1.759    -4.661     0.200
     0.399     3.376     0.200
     1.614    -2.511     0.200
     1.614    -0.901     0.200
     1.613    -0.296     0.200
     1.821    -1.590     0.200
     1.816    -3.355     0.200
     2.348    -6.233     0.200
     2.470    -6.604     0.200
     2.539    -8.079     0.200
     2.698    -9.044     0.200
     2.893   -10.085     0.200
     0.303     3.598     0.200
     0.312     3.986     0.200
     1.496     0.795     0.200
     2.278    -4.065     0.200
     2.474    -5.682     0.200
     2.738    -8.332     0.200
     2.837    -9.620     0.200
     2.837    -9.128     0.200
     0.328     2.849     0.200
     0.338     3.040     0.200
     1.533    -2.720     0.200
     1.740    -1.251     0.200
     2.310    -4.885     0.200
     2.433    -5.909     0.200
     2.504    -6.275     0.200
     2.766    -9.095     0.200
     0.579     2.620     0.200
     1.181    -1.291     0.200
     1.799    -4.043     0.200
     1.975    -4.029     0.200
     2.421    -5.865     0.200
     2.540    -7.021     0.200
     2.606    -8.134     0.200
     2.845    -9.880     0.200
     0.256     3.822     0.200
     1.553    -1.172     0.200
     2.816    -9.430     0.200
     0.381     2.867     0.200
     1.629    -2.894     0.200
     1.629    -2.704     0.200
     1.632    -1.193     0.200
     1.632    -0.844     0.200
     1.805    -4.223     0.200
     1.831    -4.294     0.200
     2.499    -7.999     0.200
     2.569    -7.997     0.200
     2.727    -8.854     0.200
     0.443     1.797     0.200
     1.640    -0.872     0.200
     1.846    -3.285     0.200
     2.476    -5.960     0.200
     0.480     3.157     0.200
     1.057    -0.481     0.200
     1.858    -4.030     0.200
     2.464    -7.759     0.200
     0.529     2.111     0.200
     1.750    -2.539     0.200
     1.866    -1.750     0.200
     2.135    -5.980     0.200
     2.578    -7.954     0.200
     0.383     2.265     0.200
     0.394     2.025     0.200
     1.804    -3.660     0.200
     1.904    -4.097     0.200
     1.985    -4.045     0.200
     2.484    -6.931     0.200
     0.411     3.870     0.200
     1.044    -1.395     0.200
     1.691    -1.358     0.200
     1.889    -3.833     0.200
     2.012    -3.261     0.200
     0.333     4.791     0.200
     0.941     0.775     0.200
     1.588    -2.154     0.200
     1.784    -3.674     0.200
     2.353    -7.102     0.200
     0.554     3.509     0.200
     1.142    -0.212     0.200
     1.721    -2.509     0.200
     1.935    -3.647     0.200
     2.387    -6.873     0.200
     2.506    -6.221     0.200
     0.509     3.063     0.200
     0.520     2.944     0.200
     1.110     1.644     0.200
     1.110     0.115     0.200
     1.706    -0.298     0.200
     1.916    -3.479     0.200
     2.394    -6.716     0.200
     2.514    -7.019     0.200
     2.827    -9.983     0.200
     1.192     0.181     0.200
     1.192    -0.659     0.200
     1.739    -2.672     0.200
     1.959    -3.878     0.200
     2.029    -3.209     0.200
     2.551    -8.743     0.200
     0.371     3.843     0.200
     0.382     3.982     0.200
     1.001    -0.452     0.200
     1.001     1.087     0.200
     1.647    -0.368     0.200
     1.844    -2.891     0.200
     1.990    -5.667     0.200
     2.521    -8.563     0.200
     2.750    -9.368     0.200
     2.947   -10.646     0.200
     1.598    -1.862     0.200
     2.557    -8.769     0.200
     2.714    -9.318     0.200
     0.298     3.920     0.200
     1.585    -0.991     0.200
     1.777    -2.428     0.200
     2.367    -6.882     0.200
     2.562    -8.126     0.200
     0.498     4.371     0.200
     0.509     3.979     0.200
     1.146    -0.608     0.200
     1.831    -1.790     0.200
     1.776    -3.240     0.200
     1.980    -5.127     0.200
     0.443     2.035     0.200
     1.651    -1.522     0.200
     1.807    -3.464     0.200
     2.563    -7.024     0.200
     0.752     1.490     0.200
     1.856    -5.093     0.200
     2.081    -5.311     0.200
     0.413     3.570     0.200
     0.424     3.260     0.200
     1.027     0.948     0.200
     1.027     0.548     0.200
     1.654    -2.705     0.200
     2.576    -8.349     0.200
     0.458     3.609     0.200
     1.024    -0.674     0.200
     1.668    -1.925     0.200
     1.616    -0.590     0.200
     1.907    -2.579     0.200
     2.321    -6.054     0.200
     2.511    -6.982     0.200
     2.671    -8.578     0.200
     2.761    -9.356     0.200
     0.415     2.848     0.200
     0.999    -1.076     0.200
     1.628    -2.954     0.200
     1.612    -2.265     0.200
     1.816    -3.513     0.200
     2.530    -7.460     0.200
     2.603    -8.767     0.200
     2.689    -9.077     0.200
     0.519     3.511     0.200
     0.530     2.943     0.200
     1.110    -0.556     0.200
     1.110     0.155     0.200
     1.110     0.514     0.200
     1.698    -2.680     0.200
     1.859    -3.733     0.200
     1.910    -3.709     0.200
     2.380    -6.162     0.200
     2.567    -8.622     0.200
     2.567    -8.501     0.200
     2.728    -9.692     0.200
     2.812    -9.980     0.200
     2.812    -9.781     0.200
     1.104    -1.496     0.200
     1.695    -1.621     0.200
     1.852    -4.217     0.200
     2.500    -6.184     0.200
     2.568    -7.162     0.200
     2.729    -8.196     0.200
     2.813    -9.549     0.200
     0.567     3.027     0.200
     1.187    -0.198     0.200
     1.187    -0.419     0.200
     1.788    -4.653     0.200
     1.783    -2.647     0.200
     1.995    -4.851     0.200
     2.454    -6.922     0.200
     2.574    -8.167     0.200
     2.802    -9.437     0.200
     0.256     4.589     0.200
     1.589    -0.727     0.200
     1.775    -3.404     0.200
     1.880    -4.734     0.200
     2.391    -6.520     0.200
     2.515    -7.979     0.200
     2.742    -9.031     0.200
     0.646     1.676     0.200
     1.238    -2.010     0.200
     1.798    -1.572     0.200
     1.866    -3.382     0.200
     1.866    -3.139     0.200
     2.427    -6.651     0.200
     2.427    -6.139     0.200
     2.545    -7.963     0.200
     2.773    -8.713     0.200
     2.917    -9.762     0.200
     2.952    -9.706     0.200
     1.295    -1.203     0.200
     2.071    -4.953     0.200
     2.807    -9.527     0.200
     2.981   -10.175     0.200
     0.499     3.222     0.200
     1.093     0.193     0.200
     1.093    -0.227     0.200
     1.716    -3.131     0.200
     1.688    -1.818     0.200
     1.825    -3.855     0.200
     1.898    -4.367     0.200
     0.373     2.311     0.200
     0.383     2.291     0.200
     1.644    -0.350     0.200
     0.462     3.124     0.200
     0.473     2.773     0.200
     1.068    -0.641     0.200
     1.679    -2.387     0.200
     1.802    -3.492     0.200
     1.791    -4.066     0.200
     1.885    -4.430     0.200
     2.346    -7.454     0.200
     2.738    -9.174     0.200
     2.827    -9.570     0.200
     2.939   -10.591     0.200
     0.337     2.210     0.200
     1.528    -0.740     0.200
     1.726    -2.490     0.200
     0.296     4.348     0.200
     0.307     2.784     0.200
     0.951     0.762     0.200
     0.951    -0.043     0.200
     1.628    -2.663     0.200
     1.817    -4.431     0.200
     2.538    -7.696     0.200
     2.970   -10.725     0.200
     0.349     4.311     0.200
     0.971     0.248     0.200
     0.971     0.131     0.200
     1.567    -2.759     0.200
     1.677    -2.713     0.200
     1.620    -2.094     0.200
     1.756    -3.198     0.200
     1.811    -3.599     0.200
     1.816    -5.031     0.200
     2.380    -7.286     0.200
     2.503    -7.414     0.200
     2.731    -9.731     0.200
     0.569     2.664     0.200
     0.580     2.413     0.200
     1.165    -0.250     0.200
     1.165    -0.830     0.200
     1.165    -0.609     0.200
     1.909    -5.386     0.200
     1.959    -4.649     0.200
     2.407    -7.359     0.200
     2.526    -7.659     0.200
     2.592    -8.210     0.200
     2.592    -8.072     0.200
     2.933   -10.007     0.200
     2.943   -10.533     0.200
     1.418    -1.115     0.200
     1.418    -0.125     0.200
     1.508     0.011     0.200
     1.605    -0.957     0.200
     1.659    -2.525     0.200
     2.331    -7.110     0.200
     2.400    -7.679     0.200
     2.428    -7.632     0.200
     2.329    -5.450     0.200
     2.453    -6.184     0.200
     2.797    -8.489     0.200
     2.882    -8.752     0.200
     2.894    -8.776     0.200
     0.580     0.639     0.200
     0.591     0.348     0.200
     1.176    -0.703     0.200
     1.968    -4.441     0.200
     2.410    -6.579     0.200
     2.529    -7.664     0.200
     2.595    -8.568     0.200
     0.453     2.038     0.200
     1.661    -2.270     0.200
     1.847    -2.785     0.200
     1.814    -2.516     0.200
     2.312    -6.602     0.200
     2.433    -6.929     0.200
     2.502    -7.847     0.200
     2.661    -8.549     0.200
     2.753    -9.492     0.200
     0.483     0.122     0.200
     1.685    -3.257     0.200
     1.638    -0.427     0.200
     1.848    -1.747     0.200
     2.337    -5.070     0.200
     2.527    -6.389     0.200
     0.430     3.662     0.200
     0.441     2.115     0.200
     1.033     0.642     0.200
     1.033     0.501     0.200
     1.648    -3.890     0.200
     1.648    -1.530     0.200
     1.651    -3.383     0.200
     1.757    -3.160     0.200
     1.836    -4.654     0.200
     1.836    -2.420     0.200
     1.855    -3.557     0.200
     2.373    -6.196     0.200
     2.494    -7.809     0.200
     2.494    -6.262     0.200
     2.563    -8.169     0.200
     2.723    -8.729     0.200
     2.915   -10.601     0.200
     2.928    -9.332     0.200
     0.187     6.114     0.200
     0.860     0.689     0.200
     0.860     0.239     0.200
     1.520    -2.652     0.200
     1.598    -3.388     0.200
     1.598    -1.628     0.200
     1.572    -3.421     0.200
     1.572    -0.692     0.200
     2.603    -8.555     0.200
     0.377     3.267     0.200
     0.386     2.514     0.200
     1.564     0.617     0.200
     1.766    -2.073     0.200
     2.308    -5.628     0.200
     2.431    -5.972     0.200
     2.501    -7.821     0.200
     2.758    -9.393     0.200
     0.523     1.051     0.200
     0.522     1.372     0.200
     0.581     1.122     0.200
     1.094     3.522     0.200
     1.299     0.036     0.200
     0.765     2.178     0.200
     0.776     1.885     0.200
     1.881    -3.202     0.200
     2.016    -3.294     0.200
     2.106    -3.565     0.200
     2.459    -6.576     0.200
     2.459    -4.756     0.200
     2.575    -5.477     0.200
     2.637    -5.970     0.200
     2.802    -8.242     0.200
     2.802    -7.921     0.200
     0.503     2.620     0.200
     0.513     1.432     0.200
     1.536    -0.654     0.200
     1.536    -0.014     0.200
     1.534    -0.434     0.200
     1.603    -1.637     0.200
     1.609    -1.208     0.200
     1.609    -1.079     0.200
     1.652    -1.796     0.200
     1.716    -1.869     0.200
     1.864    -3.310     0.200
     2.336    -5.847     0.200
     2.444    -6.647     0.200
     2.457    -5.885     0.200
     2.457    -5.514     0.200
     2.525    -6.759     0.200
     2.685    -9.016     0.200
     2.771    -9.264     0.200
     0.499     2.819     0.200
     0.510     2.202     0.200
     1.100     0.008     0.200
     1.659    -0.974     0.200
     2.390    -5.635     0.200
     2.578    -6.880     0.200
     1.253     0.816     0.200
     1.253     0.554     0.200
     1.567    -2.752     0.200
     1.693    -4.036     0.200
     1.700    -2.817     0.200
     1.749    -3.906     0.200
     2.031    -3.517     0.200
     2.271    -6.321     0.200
     2.554    -8.271     0.200
     2.618    -8.706     0.200
     1.620    -2.454     0.200
     1.764    -1.938     0.200
     1.785    -3.407     0.200
     1.795    -2.267     0.200
     2.097    -4.052     0.200
     2.221    -5.368     0.200
     2.453    -5.187     0.200
     2.546    -6.625     0.200
     2.569    -5.866     0.200
     0.263     3.654     0.200
     1.345    -1.170     0.200
     1.345    -0.998     0.200
     1.422    -1.110     0.200
     1.422    -0.509     0.200
     1.434    -1.229     0.200
     1.434    -0.955     0.200
     1.443     0.401     0.200
     1.551    -2.360     0.200
     1.551    -1.493     0.200
     1.553    -2.833     0.200
     1.738    -2.952     0.200
     2.809    -9.954     0.200
     0.393     2.830     0.200
     1.333    -1.525     0.200
     1.439    -1.947     0.200
     1.528    -3.107     0.200
     1.531    -2.545     0.200
     2.291    -4.568     0.200
     2.414    -5.436     0.200
     0.328     3.725     0.200
     0.338     3.227     0.200
     1.374    -1.814     0.200
     1.462    -1.430     0.200
     1.471    -0.670     0.200
     1.576    -2.520     0.200
     1.577    -2.395     0.200
     1.587    -1.604     0.200
     1.782    -3.605     0.200
     1.149    -0.797     0.200
     1.601    -2.703     0.200
     1.606    -2.588     0.200
     1.668    -3.452     0.200
     1.935    -4.173     0.200
     2.378    -6.317     0.200
     2.563    -8.613     0.200
     0.316     3.371     0.200
     1.410    -0.996     0.200
     1.494    -0.258     0.200
     1.504    -0.584     0.200
     1.619    -1.877     0.200
     1.614    -2.260     0.200
     1.614    -2.316     0.200
     1.812    -3.031     0.200
     1.186     0.459     0.200
     1.448    -2.890     0.200
     1.592    -1.653     0.200
     1.616    -3.126     0.200
     1.625    -2.325     0.200
     1.925    -3.475     0.200
     2.302    -5.237     0.200
     1.577    -2.407     0.200
     1.703    -2.372     0.200
     1.711    -2.889     0.200
     1.749    -3.928     0.200
     1.758    -3.757     0.200
     2.042    -3.758     0.200
     2.441    -5.433     0.200
     0.437     3.269     0.200
     0.447     3.038     0.200
     1.051     0.514     0.200
     1.051     0.053     0.200
     1.448    -2.748     0.200
     1.555    -1.586     0.200
     1.641    -3.851     0.200
     1.876    -1.944     0.200
     2.056    -3.186     0.200
     2.835    -9.958     0.200
     0.304     4.436     0.200
     0.314     3.971     0.200
     1.384    -2.018     0.200
     1.384    -1.117     0.200
     1.467    -0.921     0.200
     1.467    -0.402     0.200
     1.478    -0.311     0.200
     1.478    -0.180     0.200
     1.588    -2.617     0.200
     1.588    -2.371     0.200
     1.588    -1.330     0.200
     1.593    -0.640     0.200
     1.785    -2.611     0.200
     1.785    -2.300     0.200
     1.929    -4.435     0.200
     2.491    -7.446     0.200
     2.567    -8.028     0.200
     2.567    -7.758     0.200
     2.724    -8.418     0.200
     2.944    -9.975     0.200
     0.450     3.328     0.200
     1.405    -2.066     0.200
     1.514    -1.524     0.200
     1.515    -2.065     0.200
     1.595    -3.533     0.200
     1.599    -2.828     0.200
     1.840    -3.072     0.200
     2.343    -6.826     0.200
     2.454    -7.730     0.200
     2.533    -7.599     0.200
     0.518     2.595     0.200
     0.528     2.286     0.200
     1.113     0.146     0.200
     1.113    -0.004     0.200
     1.588    -1.124     0.200
     1.657    -2.551     0.200
     1.662    -0.812     0.200
     1.915    -3.021     0.200
     2.388    -5.987     0.200
     2.508    -6.436     0.200
     2.736    -8.848     0.200
     0.281     4.182     0.200
     1.339    -1.303     0.200
     1.420    -1.227     0.200
     1.431    -1.108     0.200
     1.545    -3.356     0.200
     1.737    -2.412     0.200
     2.336    -6.712     0.200
     2.687    -8.756     0.200
     0.357     3.438     0.200
     0.368     3.121     0.200
     1.493    -0.213     0.200
     1.608    -2.442     0.200
     1.610    -1.041     0.200
     1.821    -2.967     0.200
     0.369     3.920     0.200
     0.379     3.496     0.200
     0.942     1.460     0.200
     0.942     1.851     0.200
     1.345    -1.853     0.200
     1.576    -0.876     0.200
     1.543    -3.312     0.200
     1.766    -3.896     0.200
     2.435    -6.931     0.200
     2.505    -7.712     0.200
     0.274     4.496     0.200
     0.284     4.146     0.200
     0.873     1.258     0.200
     0.873     1.145     0.200
     1.331    -1.234     0.200
     1.508    -2.762     0.200
     1.421    -1.284     0.200
     1.536    -2.523     0.200
     1.537    -3.544     0.200
     2.329    -6.454     0.200
     2.453    -6.984     0.200
     2.791    -9.951     0.200
     0.396     3.194     0.200
     0.406     3.680     0.200
     0.978     0.150     0.200
     0.978     0.638     0.200
     1.374    -2.224     0.200
     1.479    -1.174     0.200
     1.569    -3.593     0.200
     1.572    -2.550     0.200
     1.799    -3.922     0.200
     0.417     3.353     0.200
     0.428     3.329     0.200
     1.020     0.951     0.200
     1.020     0.481     0.200
     1.418    -2.558     0.200
     1.521    -2.604     0.200
     1.524    -1.999     0.200
     1.524    -1.178     0.200
     1.612    -3.744     0.200
     0.322     3.459     0.200
     1.366    -1.392     0.200
     1.453    -0.181     0.200
     1.462    -0.669     0.200
     1.773    -2.077     0.200
     0.922    -1.436     0.200
     1.565    -0.956     0.200
     2.221    -4.875     0.200
     2.071    -2.922     0.200
     2.292    -2.217     0.200
     2.314    -4.158     0.200
     2.314    -3.369     0.200
     0.454     3.289     0.200
     1.413    -0.728     0.200
     1.523    -0.402     0.200
     1.524    -0.205     0.200
     1.528    -0.215     0.200
     1.604    -2.251     0.200
     1.608    -1.385     0.200
     1.608    -0.346     0.200
     1.669    -3.351     0.200
     1.642    -1.490     0.200
     1.877    -4.641     0.200
     1.849    -2.621     0.200
     2.471    -6.742     0.200
     2.540    -7.340     0.200
     2.700    -8.355     0.200
     2.869    -9.636     0.200
     2.902    -9.828     0.200
     0.268     2.992     0.200
     1.531    -1.287     0.200
     1.896    -4.615     0.200
     2.788    -8.952     0.200
     0.623     2.197     0.200
     1.741    -2.510     0.200
     1.960    -3.717     0.200
     2.233    -6.609     0.200
     2.378    -7.411     0.200
     0.735     2.899     0.200
     1.586    -2.461     0.200
     1.586    -1.742     0.200
     1.719    -1.967     0.200
     1.719    -1.506     0.200
     1.752    -2.269     0.200
     1.762    -2.319     0.200
     1.954    -2.131     0.200
     2.518    -6.624     0.200
     0.197     4.708     0.200
     1.334    -1.240     0.200
     1.334    -0.471     0.200
     1.409    -0.567     0.200
     1.409     0.246     0.200
     1.398    -0.694     0.200
     1.398     0.103     0.200
     1.415    -0.814     0.200
     1.415    -0.607     0.200
     1.528    -1.571     0.200
     1.528    -1.293     0.200
     1.544    -1.847     0.200
     1.547    -3.098     0.200
     1.652    -1.440     0.200
     1.710    -2.657     0.200
     1.825    -4.440     0.200
     0.421     3.128     0.200
     0.431     0.834     0.200
     1.382    -2.041     0.200
     1.478    -2.325     0.200
     1.490    -2.208     0.200
     1.575    -3.141     0.200
     1.578    -2.434     0.200
     2.278    -6.601     0.200
     0.572     2.880     0.200
     0.582     2.520     0.200
     1.098     0.881     0.200
     1.098     1.189     0.200
     1.393    -1.006     0.200
     1.518    -1.127     0.200
     1.525    -0.788     0.200
     1.570    -2.446     0.200
     1.577    -1.564     0.200
     1.636    -1.416     0.200
     1.856    -2.771     0.200
     1.412    -1.592     0.200
     1.412    -0.451     0.200
     1.549    -1.890     0.200
     1.549    -1.445     0.200
     1.575    -1.293     0.200
     1.586    -1.266     0.200
     1.898    -2.083     0.200
     2.186    -5.558     0.200
     0.365     4.939     0.200
     0.922     0.999     0.200
     1.322    -1.333     0.200
     1.425    -0.721     0.200
     1.520    -2.505     0.200
     1.522    -2.496     0.200
     1.522    -2.307     0.200
     2.407    -6.416     0.200
     0.572     1.259     0.200
     1.434    -1.178     0.200
     1.555    -1.075     0.200
     1.613    -2.727     0.200
     1.773    -1.878     0.200
     2.271    -6.326     0.200
     2.329    -4.452     0.200
     0.431     3.431     0.200
     0.442     3.053     0.200
     1.014    -0.278     0.200
     1.395    -2.491     0.200
     1.502    -3.240     0.200
     1.591    -2.634     0.200
     1.621    -0.984     0.200
     1.827    -4.705     0.200
     0.698     1.296     0.200
     1.546    -1.374     0.200
     1.677    -1.719     0.200
     1.677    -1.098     0.200
     1.688    -0.651     0.200
     1.714    -2.980     0.200
     1.714    -1.759     0.200
     2.020    -1.885     0.200
     1.154    -0.198     0.200
     1.490    -2.552     0.200
     1.614    -2.184     0.200
     1.610    -2.744     0.200
     1.671    -4.025     0.200
     1.943    -3.806     0.200
     0.359     2.261     0.200
     1.355    -1.298     0.200
     1.450    -0.106     0.200
     1.456    -1.240     0.200
     1.554    -2.257     0.200
     1.555    -1.967     0.200
     1.166    -1.193     0.200
     1.166    -0.433     0.200
     1.530    -3.092     0.200
     1.645    -2.649     0.200
     1.645    -2.518     0.200
     1.647    -3.514     0.200
     1.647    -2.623     0.200
     1.714    -4.047     0.200
     1.720    -3.857     0.200
     1.763    -3.666     0.200
     1.974    -4.466     0.200
     2.545    -8.493     0.200
     2.559    -7.931     0.200
     0.270     5.293     0.200
     0.885     1.060     0.200
     0.885     0.740     0.200
     1.348    -1.591     0.200
     1.426    -1.535     0.200
     1.438    -1.420     0.200
     1.554    -2.350     0.200
     1.555    -3.385     0.200
     1.743    -3.278     0.200
     1.156    -1.182     0.200
     1.489    -3.425     0.200
     1.609    -2.992     0.200
     1.613    -2.293     0.200
     1.943    -4.358     0.200
     2.385    -7.019     0.200
     0.327     3.712     0.200
     1.318    -1.119     0.200
     1.408    -1.196     0.200
     1.520    -2.112     0.200
     1.520    -2.597     0.200
     2.423    -6.414     0.200
     2.839    -9.568     0.200
     0.403     3.885     0.200
     0.962     0.054     0.200
     1.345    -1.599     0.200
     1.449    -1.015     0.200
     1.451    -0.642     0.200
     1.539    -2.921     0.200
     2.491    -7.543     0.200
     1.159    -0.655     0.200
     1.491    -3.290     0.200
     1.611    -2.807     0.200
     1.670    -4.216     0.200
     1.945    -5.643     0.200
     2.571    -8.614     0.200
     0.290     3.902     0.200
     1.408    -2.252     0.200
     1.487    -1.754     0.200
     1.499    -1.502     0.200
     1.614    -1.948     0.200
     1.613    -2.680     0.200
     1.803    -3.219     0.200
     0.159     5.237     0.200
     0.170     4.474     0.200
     0.609     1.469     0.200
     1.290    -0.320     0.200
     1.299    -0.759     0.200
     1.331    -0.170     0.200
     1.521    -1.835     0.200
     1.535    -2.542     0.200
     0.194     5.161     0.200
     0.807    -1.017     0.200
     1.309    -1.489     0.200
     1.372    -0.456     0.200
     1.389    -0.547     0.200
     1.503    -1.111     0.200
     1.503     0.205     0.200
     1.519    -1.754     0.200
     1.523    -2.653     0.200
     0.204     4.484     0.200
     1.303    -0.022     0.200
     1.369     0.215     0.200
     1.385    -0.107     0.200
     1.513    -0.743     0.200
     1.516    -1.556     0.200
     2.283    -6.879     0.200
     0.340     2.195     0.200
     1.398    -0.431     0.200
     1.398    -0.181     0.200
     1.487    -0.725     0.200
     1.495    -0.558     0.200
     1.495     0.173     0.200
     1.600    -1.407     0.200
     1.600    -1.177     0.200
     1.599    -2.204     0.200
     0.445     3.534     0.200
     0.456     3.258     0.200
     1.031     0.201     0.200
     1.031     0.342     0.200
     1.410    -2.332     0.200
     1.518    -1.941     0.200
     1.518    -1.801     0.200
     1.519    -1.956     0.200
     1.519    -1.652     0.200
     1.601    -3.125     0.200
     1.637    -1.906     0.200
     0.476     3.062     0.200
     0.639     2.409     0.200
     0.953    -1.219     0.200
     1.365    -1.981     0.200
     1.437    -2.206     0.200
     0.221     5.853     0.200
     1.362    -1.122     0.200
     1.430    -0.328     0.200
     1.430     0.192     0.200
     1.446    -1.030     0.200
     1.446    -0.580     0.200
     1.574    -3.022     0.200
     1.847    -4.760     0.200
     0.273     4.054     0.200
     0.283     3.553     0.200
     1.372    -1.711     0.200
     1.450    -0.552     0.200
     1.462    -0.350     0.200
     1.579    -2.403     0.200
     1.578    -2.028     0.200
     0.330     2.088     0.200
     0.915    -0.824     0.200
     1.342    -0.748     0.200
     1.432    -0.430     0.200
     1.439    -0.386     0.200
     1.544    -0.689     0.200
     1.543    -1.947     0.200
     1.958    -5.256     0.200
     0.170     5.421     0.200
     1.339    -1.620     0.200
     1.398    -0.895     0.200
     1.416    -0.645     0.200
     1.550    -1.608     0.200
     1.554    -2.666     0.200
     1.707    -3.675     0.200
     2.327    -7.094     0.200
     2.567    -8.649     0.200
     0.301     3.793     0.200
     0.312     3.684     0.200
     1.402    -2.237     0.200
     1.484    -1.705     0.200
     1.495    -1.395     0.200
     1.607    -2.711     0.200
     1.801    -3.540     0.200
     2.587    -8.664     0.200
     0.253     4.866     0.200
     1.315    -2.467     0.200
     1.391    -0.928     0.200
     1.403    -1.409     0.200
     1.518    -2.787     0.200
     1.522    -3.238     0.200
     1.524    -3.471     0.200
     2.445    -7.430     0.200
     0.469     1.987     0.200
     0.588     1.094     0.200
     0.588     1.273     0.200
     0.931     1.236     0.200
     1.017     0.548     0.200
     1.024     1.007     0.200
     1.140     1.077     0.200
     1.142    -0.007     0.200
     3.203   -11.593     0.200
     0.544     3.557     0.200
     1.096     0.348     0.200
     1.418    -2.555     0.200
     1.873    -3.045     0.200
     2.262    -6.585     0.200
     1.189    -1.666     0.200
     1.464    -2.097     0.200
     1.594    -2.871     0.200
     1.605    -3.335     0.200
     1.634    -2.966     0.200
     2.442    -6.091     0.200
     0.391     4.441     0.200
     0.402     3.654     0.200
     1.007     0.074     0.200
     1.007    -0.086     0.200
     1.641    -2.427     0.200
     0.221     3.582     0.200
     0.231     4.079     0.200
     1.321    -0.429     0.200
     1.390    -0.596     0.200
     1.405    -1.428     0.200
     1.415     0.741     0.200
     1.519    -1.434     0.200
     1.519    -1.094     0.200
     1.530    -0.927     0.200
     1.532    -2.399     0.200
     1.704    -1.305     0.200
     2.461    -6.842     0.200
     2.889   -10.221     0.200
     0.239     4.755     0.200
     0.249     3.480     0.200
     1.308    -0.866     0.200
     1.381    -0.671     0.200
     1.515    -1.554     0.200
     1.518    -2.333     0.200
     1.696    -1.698     0.200
     2.275    -7.131     0.200
     2.670    -8.561     0.200
     2.784    -9.171     0.200
     0.587     1.079     0.200
     0.591     1.945     0.200
     0.591     2.132     0.200
     0.598     1.259     0.200
     1.309     1.158     0.200
     1.377     0.626     0.200
     1.455     0.182     0.200
     1.455     0.893     0.200
     1.514     0.036     0.200
     1.514     0.950     0.200
     1.627    -0.762     0.200
     1.651    -0.994     0.200
     2.547    -7.407     0.200
     2.555    -6.010     0.200
     2.682    -6.908     0.200
     3.178   -11.699     0.200
     0.910     2.311     0.200
     1.023     1.106     0.200
     1.129     2.180     0.200
     1.160     2.071     0.200
     1.237     0.604     0.200
     2.219    -0.622     0.200
     2.955    -5.922     0.200
     2.976    -6.756     0.200
     3.402    -8.763     0.200
     0.501     1.841     0.200
     1.087    -0.089     0.200
     1.454    -2.122     0.200
     1.608    -2.825     0.200
     1.642    -3.210     0.200
     1.648    -2.765     0.200
     2.324    -7.416     0.200
     2.728    -8.748     0.200
     0.208     4.901     0.200
     1.322    -2.018     0.200
     1.386    -1.189     0.200
     1.403    -1.612     0.200
     1.543    -1.855     0.200
     1.534    -2.700     0.200
     1.535    -3.497     0.200
     2.813    -9.614     0.200
     0.491     2.214     0.200
     1.435    -1.536     0.200
     1.548    -0.885     0.200
     1.548    -1.520     0.200
     1.590    -1.460     0.200
     1.623    -1.248     0.200
     2.105    -4.262     0.200
     2.308    -5.934     0.200
     2.878    -9.539     0.200
     2.911    -9.563     0.200
     0.441     3.832     0.200
     1.403    -1.411     0.200
     1.509    -1.456     0.200
     1.509    -0.577     0.200
     1.512    -1.149     0.200
     1.567    -1.897     0.200
     1.596    -2.531     0.200
     1.601    -2.426     0.200
     1.664    -1.022     0.200
     2.296    -6.722     0.200
     2.904   -10.064     0.200
     0.183     3.048     0.200
     0.665     1.922     0.200
     1.509     1.312     0.200
     1.636    -0.629     0.200
     3.158    -9.563     0.200
     0.841     1.862     0.200
     1.566     0.657     0.200
     1.642    -0.620     0.200
     1.693    -0.411     0.200
     1.912    -2.112     0.200
     2.000    -2.466     0.200
     2.125    -4.410     0.200
     0.254     3.981     0.200
     1.329    -2.048     0.200
     1.402    -1.004     0.200
     1.416    -1.067     0.200
     1.525    -2.840     0.200
     1.538    -2.824     0.200
     1.538    -2.825     0.200
     1.559    -2.279     0.200
     2.337    -6.477     0.200
     1.205    -0.220     0.200
     1.520    -2.435     0.200
     1.644    -2.742     0.200
     1.695    -3.436     0.200
     1.704    -2.970     0.200
     2.397    -6.269     0.200
     0.205     4.897     0.200
     1.305    -0.974     0.200
     1.369    -0.623     0.200
     1.367    -0.452     0.200
     1.385    -0.732     0.200
     1.396    -0.713     0.200
     1.499    -1.809     0.200
     1.511    -3.106     0.200
     1.517    -1.474     0.200
     1.525    -1.700     0.200
     1.518    -2.635     0.200
     2.287    -6.813     0.200
     2.454    -8.205     0.200
     0.438     3.315     0.200
     0.729     1.597     0.200
     1.454    -1.043     0.200
     1.511    -1.554     0.200
     1.515    -1.800     0.200
     1.596    -1.004     0.200
     1.600    -1.199     0.200
     1.742    -3.038     0.200
     1.757    -2.970     0.200
     1.117     0.403     0.200
     1.446    -2.070     0.200
     1.566    -2.792     0.200
     1.588    -3.680     0.200
     1.627    -3.433     0.200
     1.635    -3.106     0.200
     2.290    -7.001     0.200
     0.281     3.395     0.200
     1.345    -0.663     0.200
     1.419    -0.499     0.200
     1.424    -0.410     0.200
     1.436    -1.613     0.200
     1.444    -0.625     0.200
     1.537    -2.891     0.200
     1.553    -1.750     0.200
     1.552    -2.311     0.200
     1.580    -0.557     0.200
     1.741    -1.620     0.200
     2.299    -6.956     0.200
     0.422     2.325     0.200
     1.393    -1.512     0.200
     1.487    -1.233     0.200
     1.496    -1.843     0.200
     1.500    -2.009     0.200
     1.505    -1.360     0.200
     1.560    -2.668     0.200
     1.588    -3.040     0.200
     1.592    -2.072     0.200
     1.617    -0.671     0.200
     1.651    -0.953     0.200
     2.293    -6.931     0.200
     0.108     4.572     0.200
     1.343    -0.313     0.200
     1.343     0.437     0.200
     1.344    -1.222     0.200
     1.382    -0.600     0.200
     1.514    -3.039     0.200
     1.496    -0.137     0.200
     1.577    -2.431     0.200
     1.623    -0.269     0.200
     2.412    -6.046     0.200
     3.837   -14.895     0.200
     0.277     3.954     0.200
     1.338    -1.196     0.200
     1.416    -1.058     0.200
     1.437    -0.888     0.200
     1.531    -2.522     0.200
     1.543    -0.854     0.200
     1.546    -2.707     0.200
     1.546    -1.325     0.200
     1.572    -1.803     0.200
     2.293    -7.001     0.200
     2.463    -6.882     0.200
     0.441     2.972     0.200
     1.018     0.170     0.200
     1.403    -2.418     0.200
     1.499    -2.316     0.200
     1.509    -2.593     0.200
     1.511    -2.939     0.200
     1.515    -1.525     0.200
     1.595    -3.396     0.200
     1.600    -2.872     0.200
     1.663    -3.295     0.200
     2.295    -7.405     0.200
     0.162     5.899     0.200
     1.313    -1.579     0.200
     1.368    -1.080     0.200
     1.368    -1.312     0.200
     1.388    -1.934     0.200
     1.400    -0.594     0.200
     1.525    -1.623     0.200
     1.528    -2.133     0.200
     1.530    -2.659     0.200
     1.526    -3.517     0.200
     0.439     3.121     0.200
     1.018     1.145     0.200
     1.405    -2.055     0.200
     1.510    -1.626     0.200
     1.512    -1.294     0.200
     1.568    -2.339     0.200
     1.597    -2.853     0.200
     1.602    -2.667     0.200
     1.665    -2.150     0.200
     1.835    -4.080     0.200
     2.298    -7.270     0.200
     2.472    -7.476     0.200
     2.794    -9.908     0.200
     0.426     1.612     0.200
     0.766     0.564     0.200
     1.362     1.054     0.200
     0.273     3.810     0.200
     1.326    -0.652     0.200
     1.404    -0.524     0.200
     1.416    -0.531     0.200
     1.519    -2.607     0.200
     1.531    -2.190     0.200
     1.534    -2.485     0.200
     1.535    -1.284     0.200
     1.560    -0.461     0.200
     1.720    -2.737     0.200
     0.513     3.321     0.200
     1.091     0.370     0.200
     1.451    -1.664     0.200
     1.566    -1.068     0.200
     1.565    -1.013     0.200
     1.602    -2.259     0.200
     1.637    -3.129     0.200
     1.643    -2.924     0.200
     1.683    -3.659     0.200
     1.720    -2.569     0.200
     2.315    -7.323     0.200
     0.529     3.345     0.200
     1.105     0.185     0.200
     1.458    -1.626     0.200
     1.576    -2.413     0.200
     1.574    -1.952     0.200
     1.607    -2.875     0.200
     1.607    -1.984     0.200
     1.643    -3.044     0.200
     1.649    -2.450     0.200
     1.730    -1.947     0.200
     2.316    -6.423     0.200
     2.373    -6.166     0.200
     2.493    -7.875     0.200
     2.560    -7.408     0.200
     2.721    -9.327     0.200
     2.882   -10.198     0.200
     0.414     3.868     0.200
     0.992     1.589     0.200
     1.388    -2.051     0.200
     1.490    -0.750     0.200
     1.499    -1.072     0.200
     1.556    -2.706     0.200
     1.583    -3.399     0.200
     1.587    -3.587     0.200
     2.291    -6.852     0.200
     2.693    -9.183     0.200
     1.227     0.303     0.200
     1.548    -2.420     0.200
     1.548    -2.280     0.200
     1.678    -2.307     0.200
     1.672    -1.572     0.200
     1.679    -2.518     0.200
     1.723    -4.013     0.200
     1.723    -3.622     0.200
     1.732    -3.359     0.200
     1.732    -3.179     0.200
     1.831    -3.241     0.200
     2.363    -7.023     0.200
     2.424    -6.151     0.200
     2.542    -7.013     0.200
     2.607    -8.004     0.200
     0.253     2.981     0.200
     1.373    -0.852     0.200
     1.445    -0.224     0.200
     1.459    -3.029     0.200
     1.574    -1.003     0.200
     1.570    -2.225     0.200
     1.601    -0.551     0.200
     1.601    -0.281     0.200
     1.583    -1.176     0.200
     1.583    -2.159     0.200
     0.567     1.380     0.200
     0.928    -0.318     0.200
     1.304     0.840     0.200
     1.306     0.054     0.200
     1.345    -0.331     0.200
     1.353     0.263     0.200
     1.456     1.215     0.200
     1.102     0.117     0.200
     1.823    -3.055     0.200
     1.864    -3.604     0.200
     1.875    -4.265     0.200
     2.103    -5.695     0.200
     2.133    -5.805     0.200
     2.982   -11.208     0.200
     4.324    -6.497     0.200
     0.254     4.665     0.200
     0.864     1.232     0.200
     1.342    -1.821     0.200
     1.415    -0.899     0.200
     1.429    -1.907     0.200
     1.438    -1.747     0.200
     1.543    -1.802     0.200
     1.551    -2.967     0.200
     1.551    -3.651     0.200
     1.571    -2.072     0.200
     1.730    -2.568     0.200
     2.349    -7.848     0.200
     2.813   -10.328     0.200
     2.911   -10.326     0.200
     0.380     2.502     0.200
     1.391    -1.010     0.200
     1.486    -0.724     0.200
     1.492    -0.612     0.200
     1.589    -2.626     0.200
     1.593    -2.446     0.200
     1.642    -0.689     0.200
     1.995    -5.390     0.200
     1.113    -0.480     0.200
     1.835    -3.021     0.200
     1.877    -4.019     0.200
     2.077    -5.465     0.200
     2.146    -6.586     0.200
     4.313    -8.059     0.200
     1.272     0.260     0.200
     1.270    -1.227     0.200
     1.386    -1.734     0.200
     1.984    -4.268     0.200
     2.032    -5.119     0.200
     2.235    -6.244     0.200
     0.508     3.714     0.200
     0.508     1.444     0.200
     1.015     0.775     0.200
     1.015    -0.326     0.200
     1.274    -2.016     0.200
     1.733    -2.699     0.200
     1.770    -3.283     0.200
     1.770    -2.633     0.200
     1.807    -2.188     0.200
     1.981    -4.034     0.200
     1.997    -3.970     0.200
     2.037    -6.097     0.200
     1.119    -0.750     0.200
     1.119    -0.340     0.200
     1.162    -0.811     0.200
     1.117    -0.713     0.200
     1.117     0.217     0.200
     1.314    -2.506     0.200
     1.314    -1.539     0.200
     1.394    -2.306     0.200
     1.834    -3.260     0.200
     1.834    -2.537     0.200
     1.866    -3.483     0.200
     1.884    -3.128     0.200
     1.884    -1.738     0.200
     2.084    -5.312     0.200
     2.093    -4.522     0.200
     2.104    -5.657     0.200
     2.130    -5.008     0.200
     4.369    -7.800     0.200
     0.387     3.217     0.200
     1.300    -2.365     0.200
     1.606    -2.546     0.200
     2.874    -7.096     0.200
     1.167    -0.878     0.200
     1.130    -0.265     0.200
     1.212    -1.091     0.200
     1.367    -2.134     0.200
     1.367    -2.648     0.200
     1.397    -0.732     0.200
     1.397    -0.603     0.200
     1.442     0.015     0.200
     1.442     0.265     0.200
     1.843    -2.867     0.200
     1.859    -3.226     0.200
     1.859    -3.124     0.200
     1.867    -3.268     0.200
     1.890    -3.290     0.200
     1.987    -3.062     0.200
     1.987    -2.773     0.200
     1.991    -2.927     0.200
     2.093    -4.650     0.200
     2.103    -4.966     0.200
     2.125    -5.016     0.200
     1.701    -2.728     0.200
     1.760    -1.687     0.200
     2.000    -5.291     0.200
     1.912    -3.153     0.200
     2.253    -6.374     0.200
     2.402    -7.206     0.200
     0.318     3.038     0.200
     1.378    -0.398     0.200
     1.457    -0.658     0.200
     1.457     0.233     0.200
     1.462    -0.525     0.200
     1.472    -0.050     0.200
     1.564    -1.449     0.200
     1.582    -2.524     0.200
     1.618    -0.412     0.200
     1.766    -1.615     0.200
     1.766    -0.516     0.200
     1.933    -3.083     0.200
     2.318    -6.571     0.200
     0.698     1.238     0.200
     1.697    -2.567     0.200
     1.760    -3.102     0.200
     1.774    -3.400     0.200
     1.810    -3.356     0.200
     1.891    -3.359     0.200
     2.244    -6.374     0.200
     2.215    -5.155     0.200
     0.909     1.713     0.200
     2.021    -3.081     0.200
     2.089    -3.496     0.200
     0.496     2.795     0.200
     1.130     0.727     0.200
     1.258    -0.533     0.200
     1.315    -1.480     0.200
     1.315    -1.379     0.200
     1.495     0.369     0.200
     1.495     0.560     0.200
     1.532    -0.050     0.200
     1.828    -3.096     0.200
     1.828    -2.678     0.200
     1.833    -3.918     0.200
     1.869    -3.959     0.200
     2.057    -4.447     0.200
     2.065    -5.841     0.200
     2.065    -5.610     0.200
     0.441     1.672     0.200
     0.551     2.072     0.200
     1.152     0.138     0.200
     1.154    -0.230     0.200
     1.774    -1.963     0.200
     2.485    -6.019     0.200
     2.559    -7.125     0.200
     0.468     2.732     0.200
     1.090     0.728     0.200
     1.090    -1.225     0.200
     1.454    -1.838     0.200
     1.459    -2.128     0.200
     1.790    -1.723     0.200
     1.798    -2.178     0.200
     1.803    -2.336     0.200
     1.832    -2.638     0.200
     1.832    -1.395     0.200
     1.852    -0.910     0.200
     1.933    -1.743     0.200
     1.940    -2.024     0.200
     2.023    -3.300     0.200
     2.031    -4.390     0.200
     0.369     1.543     0.200
     1.639    -2.410     0.200
     2.166    -4.927     0.200
     2.039    -4.219     0.200
     0.132     6.157     0.200
     1.328    -1.776     0.200
     1.312    -1.556     0.200
     1.361    -1.007     0.200
     1.362    -1.227     0.200
     1.382    -1.509     0.200
     1.494    -2.724     0.200
     1.570    -2.930     0.200
     1.528    -1.909     0.200
     1.530    -2.937     0.200
     1.531    -2.530     0.200
     1.723    -3.748     0.200
     0.312     2.202     0.200
     1.587    -1.573     0.200
     1.587    -0.995     0.200
     1.598    -1.658     0.200
     1.598    -0.892     0.200
     1.696    -3.038     0.200
     1.696    -1.632     0.200
     1.959    -4.752     0.200
     2.003    -5.189     0.200
     1.997    -5.431     0.200
     2.087    -5.429     0.200
     1.934    -3.794     0.200
     1.937    -4.033     0.200
     0.260     3.419     0.200
     1.317    -0.202     0.200
     1.388    -0.136     0.200
     1.392    -0.244     0.200
     1.405    -1.341     0.200
     1.414     0.234     0.200
     1.519     0.083     0.200
     1.512    -1.627     0.200
     1.526    -0.598     0.200
     1.526    -1.893     0.200
     1.548    -0.047     0.200
     1.853    -4.176     0.200
     1.409    -1.386     0.200
     1.488    -1.584     0.200
     1.495    -2.935     0.200
     1.502    -2.456     0.200
     1.501    -1.773     0.200
     1.506    -0.751     0.200
     1.622    -1.979     0.200
     1.785    -3.921     0.200
     1.811    -4.540     0.200
     2.275    -7.063     0.200
     2.788    -9.541     0.200
     5.088    -8.670     0.200
     0.497     2.910     0.200
     1.482    -2.933     0.200
     1.581    -3.379     0.200
     1.592    -3.349     0.200
     1.638    -3.967     0.200
     1.677    -3.582     0.200
     1.710    -3.846     0.200
     2.210    -6.177     0.200
     2.356    -7.134     0.200
     0.384     2.212     0.200
     1.368    -1.022     0.200
     1.457    -1.197     0.200
     1.466    -1.359     0.200
     1.471    -0.911     0.200
     1.477     0.371     0.200
     1.541    -2.209     0.200
     1.566    -2.823     0.200
     1.569    -1.477     0.200
     1.588     0.578     0.200
     1.621    -1.015     0.200
     2.129    -5.167     0.200
     2.283    -6.288     0.200
     0.310     3.411     0.200
     1.391    -1.091     0.200
     1.467    -2.184     0.200
     1.483    -1.779     0.200
     1.595    -2.919     0.200
     2.838    -9.662     0.200
     1.527    -2.124     0.200
     1.641    -2.283     0.200
     1.654    -3.455     0.200
     1.654    -2.134     0.200
     1.658    -1.905     0.200
     1.660    -1.861     0.200
     1.672    -2.154     0.200
     1.692    -3.636     0.200
     1.692    -3.003     0.200
     1.703    -2.813     0.200
     2.303    -6.572     0.200
     0.470     2.809     0.200
     1.417    -2.151     0.200
     1.528    -1.377     0.200
     1.528     0.463     0.200
     1.528    -2.228     0.200
     1.607    -2.976     0.200
     1.646    -1.705     0.200
     1.915    -4.479     0.200
     2.298    -6.624     0.200
     2.352    -7.286     0.200
     2.352    -5.517     0.200
     2.792    -9.080     0.200
     0.268     3.841     0.200
     1.337    -1.852     0.200
     1.337    -0.792     0.200
     1.409    -1.380     0.200
     1.409    -0.950     0.200
     1.413    -0.814     0.200
     1.413    -0.554     0.200
     1.426    -0.779     0.200
     1.435    -0.231     0.200
     1.576    -1.627     0.200
     1.541    -0.539     0.200
     1.531    -2.872     0.200
     1.546    -1.502     0.200
     1.545    -2.618     0.200
     1.570    -0.576     0.200
     1.677    -1.445     0.200
     1.709    -0.985     0.200
     0.529     2.674     0.200
     1.105     0.009     0.200
     1.457    -1.973     0.200
     1.563    -2.364     0.200
     1.575    -0.943     0.200
     1.573    -0.342     0.200
     1.642    -3.931     0.200
     2.315    -7.349     0.200
     0.205     4.313     0.200
     0.736     0.068     0.200
     1.236    -1.075     0.200
     1.297    -0.589     0.200
     1.295    -1.770     0.200
     1.295    -0.950     0.200
     1.325     0.294     0.200
     1.453    -0.795     0.200
     1.450    -1.631     0.200
     1.447    -2.653     0.200
     1.452    -1.968     0.200
     1.595    -1.484     0.200
     5.100   -11.882     0.200
     0.128     5.806     0.200
     1.303    -1.224     0.200
     1.303    -0.833     0.200
     1.348    -0.814     0.200
     1.351     0.075     0.200
     1.352    -0.313     0.200
     1.373    -0.096     0.200
     1.428    -0.792     0.200
     1.507     0.408     0.200
     1.520    -1.315     0.200
     1.522    -2.686     0.200
     1.523    -2.693     0.200
     1.562    -0.468     0.200
     2.141    -2.638     0.200
     0.270     4.339     0.200
     1.412    -1.341     0.200
     1.481    -0.571     0.200
     1.484     0.163     0.200
     1.499    -0.039     0.200
     1.607    -2.880     0.200
     1.621    -3.199     0.200
     0.033     9.442     0.200
     1.353    -2.261     0.200
     1.382    -1.440     0.200
     1.387    -1.969     0.200
     1.411    -2.104     0.200
     1.426    -0.768     0.200
     1.626    -3.425     0.200
     1.574    -3.169     0.200
     1.579    -3.627     0.200
     1.586    -3.986     0.200
     2.211    -6.277     0.200
     2.386    -7.788     0.200
     2.772    -9.528     0.200
     4.919    -9.515     0.200
     0.555     1.820     0.200
     0.613     1.257     0.200
     0.648     1.451     0.200
     0.728     1.649     0.200
     0.728     1.954     0.200
     1.075    -1.718     0.200
     1.596    -0.515     0.200
     4.499    -9.639     0.200
     0.194     6.197     0.200
     1.015    -0.022     0.200
     1.136    -0.199     0.200
     1.131    -0.011     0.200
     1.319    -0.498     0.200
     1.338    -1.446     0.200
     1.433    -3.043     0.200
     1.363    -1.135     0.200
     1.470    -1.664     0.200
     1.564    -2.437     0.200
     1.575    -2.928     0.200
     2.424    -7.190     0.200
     0.329     2.920     0.200
     1.360    -1.478     0.200
     1.360    -0.939     0.200
     1.441    -1.915     0.200
     1.441    -1.594     0.200
     1.447    -1.241     0.200
     1.447    -0.940     0.200
     1.464    -0.093     0.200
     1.531    -1.995     0.200
     1.531    -1.464     0.200
     1.559    -2.694     0.200
     1.563    -2.386     0.200
     1.565    -1.804     0.200
     1.603    -0.877     0.200
     1.638    -1.798     0.200
     1.656    -1.958     0.200
     0.308     3.380     0.200
     1.337    -1.181     0.200
     1.416    -0.308     0.200
     1.422    -0.419     0.200
     1.431    -0.249     0.200
     1.439    -0.085     0.200
     1.507    -1.592     0.200
     1.534    -2.139     0.200
     1.542    -2.962     0.200
     1.544    -2.227     0.200
     1.613    -2.119     0.200
     1.578    -0.096     0.200
     2.122    -4.311     0.200
     2.418    -6.682     0.200
     0.488     3.337     0.200
     1.056     1.112     0.200
     1.417    -2.425     0.200
     1.519    -2.703     0.200
     1.531    -2.700     0.200
     1.572    -2.667     0.200
     1.605    -2.951     0.200
     1.611    -1.252     0.200
     1.816    -3.399     0.200
     2.144    -5.410     0.200
     2.290    -6.129     0.200
     2.345    -5.568     0.200
     2.454    -7.461     0.200
     1.700    -4.441     0.200
     1.763    -4.671     0.200
     1.980    -5.072     0.200
     2.067    -6.077     0.200
     2.072    -6.199     0.200
     2.072    -5.371     0.200
     0.998    -0.587     0.200
     1.380     1.906     0.200
     1.560     0.419     0.200
     1.854    -2.033     0.200
     1.865    -2.385     0.200
     1.991    -2.476     0.200
     0.901    -0.437     0.200
     1.184     0.139     0.200
     1.386     2.396     0.200
     1.852    -4.050     0.200
     1.880    -5.016     0.200
     1.918    -4.012     0.200
     2.084    -4.711     0.200
     2.035    -1.368     0.200
     2.794    -6.304     0.200
     0.832     0.140     0.200
     1.460    -1.418     0.200
     1.663    -1.148     0.200
     1.725    -3.779     0.200
     1.776    -3.028     0.200
     1.841    -3.645     0.200
     2.006    -4.559     0.200
     2.199    -5.223     0.200
     2.884    -7.864     0.200
     2.957    -8.819     0.200
     2.971    -9.009     0.200
     3.488   -12.782     0.200
     0.877    -1.155     0.200
     1.298     1.514     0.200
     1.743    -4.059     0.200
     1.878    -4.482     0.200
     3.015    -8.947     0.200
     3.517   -10.854     0.200
     0.865     0.025     0.200
     1.583    -1.339     0.200
     0.790     0.677     0.200
     0.892     0.291     0.200
     0.872     0.716     0.200
     0.929     0.173     0.200
     1.421    -0.796     0.200
     1.621    -0.891     0.200
     1.770    -3.231     0.200
     1.791    -3.646     0.200
     1.840    -2.919     0.200
     1.905    -3.514     0.200
     1.958    -4.458     0.200
     2.421    -5.701     0.200
     0.909    -1.539     0.200
     0.916     1.876     0.200
     1.345     0.893     0.200
     1.661    -0.411     0.200
     2.083    -3.525     0.200
     1.192     0.104     0.200
     1.390    -0.044     0.200
     2.035    -2.821     0.200
     2.889    -8.080     0.200
     1.109    -0.743     0.200
     1.108     0.681     0.200
     1.128     0.879     0.200
     1.158     1.186     0.200
     1.182    -0.320     0.200
     1.182     0.598     0.200
     1.216     0.626     0.200
     1.286     1.194     0.200
     1.376     1.539     0.200
     1.546    -0.000     0.200
     1.546     0.101     0.200
     1.517     0.092     0.200
     1.638    -0.676     0.200
     1.973    -5.006     0.200
     1.973    -4.627     0.200
     1.986    -5.042     0.200
     1.986    -4.702     0.200
     2.045    -5.449     0.200
     2.045    -4.469     0.200
     2.058    -4.895     0.200
     5.878   -12.335     0.200
     0.965     1.009     0.200
     1.031    -1.110     0.200
     1.022     0.462     0.200
     1.091     0.335     0.200
     1.108     0.871     0.200
     1.120     1.601     0.200
     1.131     1.089     0.200
     1.139     0.678     0.200
     1.170     0.678     0.200
     1.367     0.578     0.200
     1.503    -0.571     0.200
     1.535    -0.521     0.200
     1.668    -1.701     0.200
     1.729    -1.713     0.200
     1.827    -3.248     0.200
     1.892    -4.658     0.200
     1.904    -4.883     0.200
     1.976    -4.982     0.200
     0.418     4.247     0.200
     0.894     1.503     0.200
     0.913     1.559     0.200
     1.025     1.546     0.200
     1.069     0.928     0.200
     1.075     0.467     0.200
     1.207    -0.034     0.200
     1.247    -2.117     0.200
     1.259    -2.177     0.200
     1.721    -2.129     0.200
     1.934    -3.751     0.200
     1.932    -1.530     0.200
     1.332    -2.231     0.200
     1.353    -1.705     0.200
     1.353    -1.005     0.200
     1.442    -2.119     0.200
     1.442    -1.240     0.200
     1.420    -0.675     0.200
     1.423    -0.835     0.200
     1.438    -1.168     0.200
     1.438    -0.567     0.200
     1.501    -3.103     0.200
     1.552    -1.246     0.200
     1.565    -2.234     0.200
     1.553    -3.408     0.200
     1.553    -2.947     0.200
     1.564    -1.857     0.200
     1.564    -2.410     0.200
     1.564    -2.137     0.200
     1.579    -2.753     0.200
     1.736    -1.640     0.200
     1.831    -4.308     0.200
     2.158    -4.139     0.200
     2.322    -7.352     0.200
     1.714     0.071     0.200
     1.945    -3.143     0.200
     2.061    -1.305     0.200
     2.368    -4.791     0.200
     5.259   -12.570     0.200
     1.441    -0.024     0.200
     1.496    -2.922     0.200
     1.519    -0.424     0.200
     1.731    -3.876     0.200
     1.738    -3.578     0.200
     1.738    -3.735     0.200
     1.746    -4.087     0.200
     1.925    -3.852     0.200
     1.982    -5.169     0.200
     2.042    -5.687     0.200
     2.077    -5.337     0.200
     1.370    -1.925     0.200
     1.453    -1.367     0.200
     1.468    -1.186     0.200
     1.475    -1.076     0.200
     1.580    -3.220     0.200
     1.549    -3.132     0.200
     1.571    -2.618     0.200
     0.651     1.904     0.200
     1.063    -1.156     0.200
     1.176    -0.580     0.200
     1.494     1.230     0.200
     1.500     0.802     0.200
     1.604    -2.146     0.200
     1.597     0.630     0.200
     1.608    -0.289     0.200
     1.635    -0.774     0.200
     1.903    -2.974     0.200
     2.001    -3.800     0.200
     0.662     1.979     0.200
     0.700     2.449     0.200
     0.700     2.558     0.200
     0.699     2.472     0.200
     0.719     2.841     0.200
     0.895     1.551     0.200
     0.920     1.355     0.200
     1.239    -1.469     0.200
     1.269    -0.380     0.200
     1.344    -1.268     0.200
     1.425    -1.068     0.200
     1.542    -0.854     0.200
     1.558     1.127     0.200
     1.783    -2.770     0.200
     1.770     0.285     0.200
     1.783    -0.262     0.200
     1.915     0.763     0.200
     2.334    -4.461     0.200
     2.351    -5.175     0.200
     0.732     3.123     0.200
     0.711     0.719     0.200
     0.749     0.701     0.200
     0.769     0.139     0.200
     0.829     0.236     0.200
     0.962     1.001     0.200
     0.995     0.342     0.200
     1.726    -1.375     0.200
     1.662     0.329     0.200
     1.795    -2.981     0.200
     2.301    -4.945     0.200
     0.879     0.375     0.200
     0.916     0.186     0.200
     0.988    -0.653     0.200
     1.541     0.207     0.200
     0.852     1.152     0.200
     0.488     1.914     0.200
     0.489     2.042     0.200
     0.419     3.207     0.200
     0.450     3.327     0.200
EOF
gmt end
