#!/bin/bash
gmt begin simeonof10.15_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional simeonof10.15'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.000    40.275
    14.500    39.997
    15.000    39.718
    15.500    39.436
    16.000    39.150
    16.500    38.859
    17.000    38.560
    17.500    38.253
    18.000    37.935
    18.500    37.604
    19.000    37.257
    19.500    36.894
    20.000    36.511
    20.500    36.105
    21.000    35.676
    21.500    35.221
    22.000    34.737
    22.500    34.222
    23.000    33.676
    23.500    32.980
    24.000    31.715
    24.500    30.442
    25.000    29.158
    25.500    27.864
    26.000    26.558
    26.500    25.241
    27.000    23.911
    27.500    22.564
    28.000    21.197
    28.500    19.815
    29.000    18.424
    29.500    17.023
    30.000    15.615
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    18.197 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     0.500     5.802
     1.000     6.918
     1.500     8.034
     2.000     9.150
     2.500    10.266
     3.000    11.382
     3.500    12.497
     4.000    13.611
     4.500    14.724
     5.000    15.836
     5.500    16.947
     6.000    18.056
     6.500    19.164
     7.000    20.270
     7.500    21.375
     8.000    22.477
     8.500    23.578
     9.000    24.677
     9.500    25.773
    10.000    26.867
    10.500    27.959
    11.000    29.047
    11.500    30.133
    12.000    31.216
    12.500    32.297
    13.000    33.281
    13.500    34.036
    14.000    34.767
    14.500    35.471
    15.000    36.147
    15.500    36.736
    16.000    37.256
    16.500    37.719
    17.000    38.124
    17.500    37.329
    18.000    37.656
    18.500    37.925
    19.000    38.136
    19.500    38.289
    20.000    38.385
    20.500    38.421
    21.000    38.397
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    30.281 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     4.827
     1.000     7.259
     1.500     9.888
     2.000    12.549
     2.500    15.219
     3.000    17.894
     3.500    20.569
     4.000    23.246
     4.500    25.922
     5.000    28.597
     5.500    31.271
     6.000    33.944
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    26.597 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    20.016
     1.500    26.326
     2.000    32.636
     2.500    38.946
     3.000    45.257
     3.500    51.565
     4.000    57.872
     4.500    64.177
     5.000    70.479
     5.500    76.781
     6.000    83.080
     6.500    89.377
     7.000    95.670
     7.500   101.960
     8.000   108.248
     8.500   114.531
     9.000   120.812
     9.500   127.088
    10.000   133.360
    10.500   139.628
    11.000   145.892
    11.500   152.150
    12.000   158.403
    12.500   164.651
    13.000   170.894
    13.500   177.130
    14.000   183.362
    14.500   189.586
    15.000   195.804
    15.500   202.016
    16.000   208.220
    16.500   214.418
    17.000   220.607
    17.500   231.192
    18.000   237.458
    18.500   243.710
    19.000   249.950
    19.500   256.175
    20.000   262.387
    20.500   268.584
    21.000   274.766
    21.500   280.933
    22.000   287.084
    22.500   293.219
    23.000   299.337
    23.500   305.439
    24.000   311.523
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    55.872 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    12.130
     1.000    20.092
     1.500    28.367
     2.000    36.692
     2.500    45.033
     3.000    53.381
     3.500    61.730
     4.000    70.080
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    59.730 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    27.357  -302.852     0.150
    28.816   206.458     0.150
    28.816   424.458     0.150
    29.499   418.488     0.150
    26.183  -288.553     0.150
    26.183    61.791     0.150
    26.231  -289.116     0.150
    27.402  -309.786     0.150
    27.923    32.283     0.150
    28.880    29.120     0.150
    29.562    27.056     0.150
    26.541  -296.738     0.150
    26.799    68.672     0.150
    26.799   227.672     0.150
    26.892  -305.833     0.150
    25.638    69.615     0.150
    29.550   201.860     0.150
    26.720  -301.822     0.150
    26.720  -302.025     0.150
    26.732  -301.364     0.150
    28.363  -322.596     0.150
    29.047  -329.978     0.150
    29.645  -336.958     0.150
    24.106    63.067     0.150
    26.481  -300.038     0.150
    26.481    68.291     0.150
    26.258  -298.434     0.150
    27.860   218.994     0.150
    28.818    76.438     0.150
    26.148  -290.246     0.150
    26.383  -293.895     0.150
    27.168  -306.796     0.150
    28.503  -321.821     0.150
    26.177  -290.487     0.150
    26.177    64.193     0.150
    27.822  -312.637     0.150
    27.822    68.887     0.150
    28.881  -325.999     0.150
    28.881    72.626     0.150
    28.881   326.626     0.150
    29.564  -334.165     0.150
    18.765   304.473     0.150
    26.631   227.771     0.150
    28.170  -318.743     0.150
    28.383  -321.078     0.150
    29.310  -333.440     0.150
    29.310   203.817     0.150
    29.310   313.118     0.150
    29.923  -338.053     0.150
    29.923   314.076     0.150
    18.895   302.951     0.150
    26.813   226.654     0.150
    18.792   302.716     0.150
    23.250   259.891     0.150
    24.996   242.622     0.150
    24.996   293.221     0.150
    24.996   458.020     0.150
    26.178  -294.394     0.150
    26.178  -291.794     0.150
    26.178  -295.093     0.150
    26.178  -292.493     0.150
    26.178   235.528     0.150
    26.691   226.743     0.150
    26.691   444.043     0.150
    23.702   283.227     0.150
    24.877   243.716     0.150
    24.877   460.114     0.150
    24.480   245.480     0.150
    26.996  -304.869     0.150
    27.413  -308.833     0.150
    24.561   246.272     0.150
    18.281   309.781     0.150
    24.377   250.234     0.150
    20.425    53.503     0.150
    23.820   286.183     0.150
    24.862   705.417     0.150
    24.862   246.227     0.150
    26.358    69.567     0.150
    27.431  -309.521     0.150
    24.492   245.306     0.150
    25.038    66.749     0.150
    23.792   258.274     0.150
    28.586   668.752     0.150
    12.590   577.217     0.150
    20.386    50.716     0.150
    25.092   243.418     0.150
    25.116   242.869     0.150
    25.116   458.965     0.150
    25.969    67.262     0.150
    27.556   436.874     0.150
    27.800   217.591     0.150
    27.792   434.674     0.150
    28.226   433.300     0.150
    28.252   430.945     0.150
    29.082   425.577     0.150
    29.099   205.834     0.150
    29.099   424.234     0.150
    29.267   205.061     0.150
    29.356   204.464     0.150
    29.356   422.364     0.150
    29.531   203.378     0.150
    29.531   421.538     0.150
    29.702   201.325     0.150
    29.702   419.395     0.150
    29.870   199.627     0.150
    29.989   416.412     0.150
    24.491   244.673     0.150
    11.961   795.060     0.150
    11.961   795.055     0.150
    18.304   737.420     0.150
    23.903   280.426     0.150
    24.408   284.801     0.150
    24.408   461.621     0.150
    24.408   688.051     0.150
    24.410   284.788     0.150
    24.410   461.601     0.150
    24.410   688.038     0.150
    24.497   460.192     0.150
    24.497   284.447     0.150
    24.497   460.197     0.150
    25.101   240.366     0.150
    25.101   455.116     0.150
    25.101   684.091     0.150
    26.312   294.252     0.150
    26.312   445.077     0.150
    26.312   674.402     0.150
    26.405   443.793     0.150
    26.815   300.171     0.150
    27.251   437.315     0.150
    27.351   298.508     0.150
    27.351   666.158     0.150
    27.958   662.604     0.150
    28.348   666.272     0.150
    29.211   420.238     0.150
    23.842   279.776     0.150
    24.348   247.646     0.150
    24.481   245.811     0.150
    24.481   459.213     0.150
    24.527   287.907     0.150
    25.015   241.063     0.150
    25.015   456.540     0.150
    25.597   236.396     0.150
    26.459   442.883     0.150
    26.652   443.031     0.150
    26.987   438.168     0.150
    27.022   439.481     0.150
    27.311   435.465     0.150
    28.019   213.364     0.150
    28.019   303.966     0.150
    28.022   431.127     0.150
    28.405   426.428     0.150
    28.885   429.138     0.150
    29.269   417.022     0.150
    29.690   416.752     0.150
    20.139    49.738     0.150
    20.139   255.039     0.150
    23.839   280.061     0.150
    24.343   247.794     0.150
    24.343   462.255     0.150
    24.345   247.780     0.150
    24.345   462.241     0.150
    24.503   245.908     0.150
    24.503   459.858     0.150
    24.503   245.592     0.150
    24.503   459.272     0.150
    25.023   241.722     0.150
    25.584   287.787     0.150
    26.225    63.317     0.150
    26.225   291.317     0.150
    26.465   442.015     0.150
    26.876   298.537     0.150
    27.314   435.561     0.150
    28.023  -316.202     0.150
    28.023  -316.628     0.150
    28.023   429.122     0.150
    28.024   429.191     0.150
    28.409   426.149     0.150
    29.273   417.790     0.150
    24.654   245.922     0.150
     9.789   605.673     0.150
     9.789   820.736     0.150
    24.434   245.312     0.150
    25.396   241.551     0.150
    26.362  -297.228     0.150
    26.378    35.953     0.150
    26.895  -302.765     0.150
    26.905  -303.818     0.150
    26.905   221.628     0.150
    27.300  -309.461     0.150
    27.638  -310.738     0.150
    27.859  -310.906     0.150
    28.306  -319.466     0.150
    28.856  -327.485     0.150
    29.067    28.010     0.150
    29.201  -331.046     0.150
    29.295  -330.360     0.150
    29.489   197.997     0.150
    29.489  -333.152     0.150
    29.779  -337.515     0.150
    29.889  -338.777     0.150
    19.791   292.801     0.150
    23.993   251.738     0.150
    23.993   285.520     0.150
    23.993   466.738     0.150
    23.994   251.721     0.150
    23.994   285.502     0.150
    23.994   466.721     0.150
    24.999   242.098     0.150
    24.999   289.153     0.150
    24.999   456.692     0.150
    24.999   701.942     0.150
    24.999   455.700     0.150
    25.849   234.886     0.150
    26.006   232.266     0.150
    27.256   302.763     0.150
    27.680   434.838     0.150
    27.840   216.118     0.150
    27.840   302.313     0.150
    24.379   247.926     0.150
    25.704   240.411     0.150
    24.542   246.832     0.150
    20.515    51.915     0.150
    20.657   283.001     0.150
    20.797   281.883     0.150
    20.909   285.642     0.150
    24.115   283.705     0.150
    24.517   248.400     0.150
    24.517   463.742     0.150
    24.624   248.145     0.150
    25.381   240.780     0.150
    24.327   250.028     0.150
    20.896   288.631     0.150
    20.580   286.135     0.150
    24.285   285.994     0.150
    24.441   284.817     0.150
    11.008   591.813     0.150
    20.440    54.301     0.150
    20.440   261.801     0.150
    20.795   262.053     0.150
    21.710   266.298     0.150
    23.270   287.834     0.150
    23.342   472.411     0.150
    23.646   292.298     0.150
    24.113   291.128     0.150
    24.136   293.293     0.150
    24.513   292.368     0.150
    24.817   285.126     0.150
    24.873   290.768     0.150
    25.129   295.812     0.150
    25.231   294.900     0.150
    25.413   298.129     0.150
    25.438   298.831     0.150
    25.873   299.812     0.150
    25.892   300.577     0.150
    26.131   300.544     0.150
    26.277   298.452     0.150
    26.329   300.174     0.150
    26.397   230.966     0.150
    26.397   301.364     0.150
    26.856   303.768     0.150
    26.961   302.986     0.150
    26.997   303.966     0.150
    27.242   295.424     0.150
    28.867   307.709     0.150
    20.514    53.245     0.150
    23.358   256.679     0.150
    23.358   469.836     0.150
    25.687   451.254     0.150
    20.932    54.453     0.150
    24.773   245.240     0.150
    20.505    56.684     0.150
    23.861   279.024     0.150
    24.517   245.785     0.150
    17.312   532.783     0.150
    23.462   475.294     0.150
    24.537   286.629     0.150
    12.581   578.274     0.150
    25.043   245.866     0.150
    25.043   460.392     0.150
    25.032   244.432     0.150
    25.144   245.076     0.150
    25.144   460.377     0.150
    23.139   261.847     0.150
    11.464   586.214     0.150
    17.780   523.486     0.150
    18.681   303.786     0.150
    23.870   284.764     0.150
    23.870   467.231     0.150
    24.437   284.842     0.150
    24.939   243.122     0.150
    24.939   286.886     0.150
    24.939   458.831     0.150
    25.431   454.325     0.150
    24.836   246.036     0.150
    24.836   460.161     0.150
    23.568   257.587     0.150
    23.568   257.275     0.150
    11.417   585.355     0.150
    17.732   522.298     0.150
    23.828   251.729     0.150
    23.828   466.714     0.150
    24.952   456.943     0.150
    24.952   242.443     0.150
    24.952   457.974     0.150
    25.423   237.645     0.150
    25.423   454.747     0.150
    26.709   441.707     0.150
    26.709   442.489     0.150
    17.856   522.210     0.150
    23.987   251.317     0.150
    23.987   465.216     0.150
    24.296   285.156     0.150
    24.799   244.018     0.150
    24.821   244.549     0.150
    23.756   282.247     0.150
    24.266   250.739     0.150
    24.801   244.881     0.150
    25.086   242.577     0.150
    18.444   302.541     0.150
    23.668   280.599     0.150
    24.176   462.450     0.150
    24.698   243.724     0.150
    24.698   457.724     0.150
    24.698   243.935     0.150
    24.571   247.191     0.150
    19.321   249.178     0.150
    24.503   246.743     0.150
    24.503   460.219     0.150
    24.491   245.548     0.150
    27.385  -309.997     0.150
    29.868    26.005     0.150
    24.488   246.395     0.150
    24.385   247.792     0.150
    24.385   460.929     0.150
    24.475   246.060     0.150
    24.475   288.282     0.150
    24.475   461.548     0.150
    25.058   240.908     0.150
    25.058   457.885     0.150
    26.274   229.214     0.150
    24.091   253.405     0.150
    25.072   243.433     0.150
    25.072   457.832     0.150
    11.391   589.242     0.150
    24.749   246.026     0.150
    24.131   252.517     0.150
    25.036   242.686     0.150
    18.703   302.649     0.150
    23.961   251.865     0.150
    24.989   241.371     0.150
    24.994   290.871     0.150
    24.499   246.407     0.150
    24.499   460.477     0.150
    24.499   458.532     0.150
    24.577   293.917     0.150
    24.219   285.113     0.150
    24.274   251.092     0.150
    24.274   250.246     0.150
    24.725   246.733     0.150
    18.395   252.828     0.150
    24.403  1614.367     0.150
    24.403  2125.062     0.150
    29.293   314.716     0.150
     4.550  1147.749     0.150
    18.452   244.668     0.150
    24.419   248.263     0.150
    24.498   249.939     0.150
    24.498   290.688     0.150
    18.703   247.210     0.150
    26.794   302.038     0.150
    24.439   248.588     0.150
    24.456   288.308     0.150
    18.733   247.348     0.150
    18.457   244.662     0.150
    24.873   296.202     0.150
    18.312   306.367     0.150
    24.491   246.156     0.150
    24.321   289.620     0.150
    24.524   246.951     0.150
     4.756   452.463     0.150
    24.331   287.579     0.150
    24.576   247.220     0.150
    24.085   253.538     0.150
    18.613   246.069     0.150
    23.402   256.457     0.150
    22.035   269.525     0.150
    25.918   290.055     0.150
    24.739   286.586     0.150
    24.843   287.550     0.150
    25.348   241.264     0.150
    18.501   307.650     0.150
    24.484   249.367     0.150
    24.368   249.553     0.150
    24.368   248.471     0.150
    22.001   270.303     0.150
    18.306   305.334     0.150
    24.482   246.042     0.150
    25.147   239.844     0.150
    27.316  -308.328     0.150
    24.532   247.157     0.150
    24.532   460.983     0.150
    29.787  -337.581     0.150
    15.123   552.831     0.150
    17.259   234.434     0.150
    22.856   479.947     0.150
    25.910   293.697     0.150
    12.561   846.634     0.150
    20.520   262.443     0.150
    23.778   287.034     0.150
    24.292   468.863     0.150
    24.292   714.764     0.150
    25.027   292.402     0.150
    25.027   462.553     0.150
    25.239   288.288     0.150
    27.649   222.329     0.150
    27.649   306.380     0.150
    28.096   308.538     0.150
    25.048   243.637     0.150
    25.048   459.012     0.150
    24.959   243.605     0.150
    24.959   245.222     0.150
    24.782   243.894     0.150
    24.782   459.046     0.150
    24.106   252.712     0.150
    25.062   243.296     0.150
    19.752   257.057     0.150
    19.752   294.831     0.150
    19.752   506.627     0.150
    23.571   281.914     0.150
    24.083   252.627     0.150
    24.083   468.189     0.150
    25.042   243.248     0.150
    25.042   290.576     0.150
    25.042   458.014     0.150
    24.987   287.491     0.150
    26.195  -293.909     0.150
    27.798  -315.046     0.150
    25.058   242.879     0.150
    24.993   241.279     0.150
    24.993   295.013     0.150
    24.522   245.802     0.150
    24.522   246.263     0.150
    27.379    33.707     0.150
    29.849  -337.196     0.150
    24.481   245.337     0.150
    24.481   246.012     0.150
    22.764   265.701     0.150
    21.114   271.135     0.150
    24.660   247.830     0.150
    24.660   294.237     0.150
    24.660   462.369     0.150
    24.998   292.770     0.150
    18.464   306.906     0.150
    24.876   461.460     0.150
    25.658   238.856     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    18.335    35.082     0.200
    23.511    34.170     0.200
    24.520    30.102     0.200
    25.120    25.591     0.200
    25.120    25.791     0.200
    26.269    23.986     0.200
    27.357    23.095     0.200
    27.869    22.712     0.200
    27.859    22.833     0.200
    28.205    20.888     0.200
    28.816    19.658     0.200
    29.499    17.488     0.200
    29.793    15.059     0.200
    29.945    15.590     0.200
    15.519    36.637     0.200
    18.311    33.655     0.200
    23.846    30.061     0.200
    24.587    28.419     0.200
    26.183    22.791     0.200
    26.231    24.228     0.200
    27.317    21.549     0.200
    27.402    22.558     0.200
    15.823    38.246     0.200
    18.306    35.260     0.200
    23.255    34.507     0.200
    24.453    30.032     0.200
    25.401    26.570     0.200
    26.541    24.157     0.200
    27.110    24.518     0.200
    29.698    17.419     0.200
    15.908    40.007     0.200
    18.356    36.237     0.200
    24.236    33.126     0.200
    25.476    27.158     0.200
    26.611    25.905     0.200
    23.030    36.653     0.200
    23.967    36.021     0.200
    24.272    32.460     0.200
    24.327    32.014     0.200
    24.282    35.049     0.200
    24.953    33.407     0.200
    24.953    32.895     0.200
    25.315    31.983     0.200
    25.634    28.268     0.200
    26.781    25.385     0.200
    26.799    25.672     0.200
    26.885    26.272     0.200
    26.892    27.581     0.200
    27.392    26.851     0.200
    27.415    26.286     0.200
    27.753    25.238     0.200
    27.802    25.271     0.200
    28.072    24.112     0.200
    28.297    24.390     0.200
    28.981    22.208     0.200
    29.368    19.487     0.200
    29.572    20.806     0.200
    29.579    19.828     0.200
    24.205    31.405     0.200
    24.358    31.419     0.200
    25.515    26.206     0.200
    26.178    25.177     0.200
    26.673    25.396     0.200
    26.877    25.114     0.200
    26.917    25.547     0.200
    28.368    22.723     0.200
    29.372    17.898     0.200
    29.651    18.246     0.200
    15.980    39.017     0.200
    24.200    32.586     0.200
    24.207    31.110     0.200
    24.457    32.896     0.200
    25.638    26.615     0.200
    26.242    25.363     0.200
    26.829    25.715     0.200
    26.792    25.647     0.200
    26.845    26.222     0.200
    26.834    25.759     0.200
    28.267    23.432     0.200
    28.950    20.457     0.200
    29.315    18.300     0.200
    29.550    18.462     0.200
    15.967    40.349     0.200
    24.359    31.415     0.200
    24.313    32.557     0.200
    24.320    32.175     0.200
    24.375    32.233     0.200
    25.020    31.832     0.200
    25.577    27.209     0.200
    26.319    25.843     0.200
    26.720    25.866     0.200
    26.720    26.069     0.200
    26.732    24.722     0.200
    26.732    25.620     0.200
    26.946    24.732     0.200
    26.957    26.094     0.200
    28.363    22.897     0.200
    15.832    39.426     0.200
    18.406    35.594     0.200
    24.106    32.067     0.200
    24.501    30.957     0.200
    24.563    30.233     0.200
    25.362    26.417     0.200
    25.362    26.917     0.200
    26.385    25.473     0.200
    26.491    25.236     0.200
    26.491    25.537     0.200
    27.183    23.665     0.200
    27.209    24.856     0.200
    29.674    17.087     0.200
    16.661    37.794     0.200
    24.121    31.840     0.200
    24.436    30.559     0.200
    24.498    29.436     0.200
    26.311    24.782     0.200
    26.481    26.291     0.200
    27.134    23.671     0.200
    27.174    24.211     0.200
    29.630    16.544     0.200
    29.885    17.474     0.200
    25.001    29.840     0.200
    25.615    28.675     0.200
    25.989    27.813     0.200
    26.551    23.749     0.200
    29.329    18.535     0.200
    18.319    35.882     0.200
    24.314    32.925     0.200
    24.414    30.257     0.200
    24.394    32.284     0.200
    24.695    32.765     0.200
    25.067    31.836     0.200
    26.337    25.312     0.200
    26.681    24.302     0.200
    26.576    26.814     0.200
    26.686    24.240     0.200
    26.991    24.674     0.200
    27.448    26.045     0.200
    28.408    22.936     0.200
    29.478    17.660     0.200
    29.690    18.278     0.200
    16.904    38.724     0.200
    18.723    35.390     0.200
    23.784    32.830     0.200
    26.258    26.955     0.200
    26.651    24.871     0.200
    27.585    22.776     0.200
    27.970    24.275     0.200
    28.936    21.209     0.200
    29.623    18.891     0.200
    26.386    24.429     0.200
    27.410    23.881     0.200
    18.343    35.683     0.200
    23.858    34.323     0.200
    23.858    34.623     0.200
    23.906    30.764     0.200
    24.458    32.320     0.200
    24.458    33.019     0.200
    25.071    31.167     0.200
    25.071    31.468     0.200
    25.447    30.437     0.200
    25.447    29.800     0.200
    26.278    25.387     0.200
    26.258    25.820     0.200
    26.732    27.198     0.200
    26.939    25.373     0.200
    26.939    25.673     0.200
    27.361    24.156     0.200
    28.672    21.140     0.200
    28.672    21.941     0.200
    28.688    19.955     0.200
    28.818    21.266     0.200
    18.185    36.033     0.200
    24.075    30.300     0.200
    24.597    28.612     0.200
    25.262    29.041     0.200
    26.148    24.215     0.200
    26.383    25.863     0.200
    27.168    23.173     0.200
    28.503    20.539     0.200
    18.299    34.130     0.200
    23.844    29.414     0.200
    25.496    28.424     0.200
    26.177    24.193     0.200
    26.218    23.714     0.200
    26.980    22.822     0.200
    26.980    23.721     0.200
    27.400    21.772     0.200
    27.822    20.840     0.200
    28.733    20.338     0.200
    28.881    19.016     0.200
    29.564    16.734     0.200
    18.450    39.638     0.200
    18.765    35.371     0.200
    18.765    35.973     0.200
    23.483    32.883     0.200
    23.483    32.665     0.200
    24.339    32.625     0.200
    25.546    29.736     0.200
    25.546    30.134     0.200
    25.917    29.143     0.200
    26.631    24.471     0.200
    27.196    24.478     0.200
    27.196    25.377     0.200
    27.852    22.445     0.200
    29.101    20.254     0.200
    29.237    19.945     0.200
    29.310    18.517     0.200
    29.923    16.963     0.200
    15.687    37.372     0.200
    19.263    36.749     0.200
    22.821    34.122     0.200
    23.974    31.870     0.200
    24.403    32.135     0.200
    25.016    30.774     0.200
    25.391    30.282     0.200
    25.964    28.505     0.200
    26.325    23.930     0.200
    28.766    19.446     0.200
    29.762    17.825     0.200
    17.494    39.507     0.200
    18.895    35.151     0.200
    23.695    32.837     0.200
    26.813    24.253     0.200
    27.727    22.778     0.200
    29.191    21.292     0.200
    17.464    39.413     0.200
    23.250    35.192     0.200
    23.627    31.800     0.200
    24.996    29.221     0.200
    24.996    30.622     0.200
    26.178    26.028     0.200
    26.178    26.727     0.200
    26.691    23.944     0.200
    18.950    37.248     0.200
    25.107    32.400     0.200
    26.866    25.969     0.200
    17.348    38.577     0.200
    18.681    36.223     0.200
    23.702    32.227     0.200
    24.877    29.216     0.200
    24.877    31.114     0.200
    25.060    27.879     0.200
    26.221    26.223     0.200
    26.221    27.528     0.200
    27.640    23.384     0.200
    17.003    37.238     0.200
    18.237    35.331     0.200
    24.480    28.380     0.200
    24.528    29.452     0.200
    25.139    29.230     0.200
    25.519    28.423     0.200
    26.996    24.522     0.200
    27.413    22.208     0.200
    16.782    39.081     0.200
    18.292    36.913     0.200
    24.356    30.817     0.200
    17.030    36.436     0.200
    18.401    35.188     0.200
    24.561    28.862     0.200
    16.825    38.406     0.200
    18.338    35.850     0.200
    20.558    36.986     0.200
    24.223    32.913     0.200
    24.401    30.086     0.200
    26.668    26.135     0.200
    27.088    25.336     0.200
    24.211    31.361     0.200
    26.886    25.991     0.200
    18.485    35.007     0.200
    24.599    31.194     0.200
    18.941    36.448     0.200
    23.753    34.384     0.200
    25.062    31.013     0.200
    25.070    30.821     0.200
    26.360    26.375     0.200
    18.281    36.631     0.200
    24.377    31.032     0.200
    17.304    39.321     0.200
    17.304    39.221     0.200
    18.716    36.725     0.200
    20.425    37.803     0.200
    23.683    35.653     0.200
    23.702    35.355     0.200
    23.820    32.883     0.200
    24.584    32.625     0.200
    24.854    30.361     0.200
    24.862    31.277     0.200
    24.908    32.833     0.200
    24.922    32.474     0.200
    25.200    28.876     0.200
    26.177    25.773     0.200
    26.189    29.739     0.200
    26.358    26.767     0.200
    27.121    27.120     0.200
    27.552    25.920     0.200
    17.277    39.250     0.200
    17.277    40.211     0.200
    18.839    35.970     0.200
    18.839    36.915     0.200
    24.882    30.139     0.200
    24.890    30.273     0.200
    27.431    24.876     0.200
    16.435    38.402     0.200
    18.275    34.390     0.200
    18.275    34.796     0.200
    23.855    30.753     0.200
    23.855    30.933     0.200
    24.492    29.056     0.200
    25.038    26.554     0.200
    16.949    38.935     0.200
    16.949    38.482     0.200
    18.440    36.599     0.200
    24.123    32.300     0.200
    24.123    31.847     0.200
    24.522    29.979     0.200
    18.557    37.608     0.200
    20.648    37.431     0.200
    20.648    36.080     0.200
    24.162    33.524     0.200
    24.603    32.019     0.200
    24.673    31.963     0.200
    24.673    31.361     0.200
    18.312    36.552     0.200
    18.312    36.216     0.200
    24.795    30.739     0.200
    24.795    30.333     0.200
    16.155    41.944     0.200
    24.075    33.812     0.200
    24.880    32.420     0.200
    26.856    28.501     0.200
    16.525    40.422     0.200
    24.042    31.664     0.200
    24.042    32.453     0.200
    24.777    31.587     0.200
    25.318    28.369     0.200
    25.601    30.044     0.200
    26.497    27.684     0.200
    26.537    27.903     0.200
    26.815    25.908     0.200
    26.918    26.606     0.200
    27.266    25.665     0.200
    27.415    26.472     0.200
    28.044    24.392     0.200
    28.096    23.353     0.200
    28.471    22.033     0.200
    28.816    21.355     0.200
    28.909    20.963     0.200
    29.430    20.088     0.200
    29.507    19.439     0.200
    16.402    39.605     0.200
    17.563    39.732     0.200
    17.563    39.884     0.200
    20.386    37.216     0.200
    20.386    36.866     0.200
    23.622    32.852     0.200
    23.916    34.519     0.200
    24.136    32.083     0.200
    24.550    33.342     0.200
    25.092    28.096     0.200
    25.116    29.615     0.200
    25.127    31.637     0.200
    25.311    31.414     0.200
    25.485    30.063     0.200
    25.822    29.245     0.200
    26.160    28.137     0.200
    26.229    28.794     0.200
    26.251    28.944     0.200
    26.423    27.999     0.200
    26.660    27.503     0.200
    26.752    27.524     0.200
    26.940    26.579     0.200
    27.076    26.857     0.200
    27.145    26.035     0.200
    27.352    25.539     0.200
    27.349    26.011     0.200
    27.355    25.539     0.200
    27.446    25.392     0.200
    27.467    25.434     0.200
    27.556    25.014     0.200
    27.654    24.548     0.200
    27.800    23.491     0.200
    27.792    24.284     0.200
    27.792    23.569     0.200
    28.094    23.561     0.200
    28.134    23.315     0.200
    28.226    23.700     0.200
    28.239    22.837     0.200
    28.289    23.192     0.200
    28.665    21.369     0.200
    28.720    22.302     0.200
    28.746    21.566     0.200
    28.922    21.297     0.200
    29.082    21.447     0.200
    29.099    21.334     0.200
    29.108    21.385     0.200
    29.267    20.001     0.200
    29.356    20.134     0.200
    29.521    19.846     0.200
    29.531    20.368     0.200
    29.702    19.025     0.200
    29.800    18.693     0.200
    29.870    18.867     0.200
    29.989    18.072     0.200
    18.728    36.751     0.200
    23.730    33.527     0.200
    24.241    31.309     0.200
    24.905    30.508     0.200
    25.111    28.585     0.200
    25.111    28.413     0.200
    15.886    36.726     0.200
    16.998    36.967     0.200
    18.273    34.414     0.200
    18.273    33.549     0.200
    23.854    31.457     0.200
    23.854    30.397     0.200
    24.360    29.290     0.200
    24.482    29.070     0.200
    24.491    28.772     0.200
    25.036    25.712     0.200
    26.250    26.492     0.200
    27.384    22.953     0.200
    28.939    17.632     0.200
    23.455    34.182     0.200
    23.509    33.689     0.200
    23.903    29.876     0.200
    23.903    29.526     0.200
    23.904    32.477     0.200
    23.911    32.946     0.200
    24.108    32.137     0.200
    24.408    28.731     0.200
    24.410    29.163     0.200
    24.410    29.383     0.200
    24.410    28.713     0.200
    24.338    31.119     0.200
    24.488    28.087     0.200
    24.497    28.392     0.200
    24.497    28.397     0.200
    24.483    30.998     0.200
    24.545    30.658     0.200
    24.709    30.392     0.200
    24.727    30.084     0.200
    25.101    25.616     0.200
    25.121    28.951     0.200
    25.350    28.366     0.200
    25.428    28.675     0.200
    25.443    28.797     0.200
    25.476    28.560     0.200
    25.827    27.271     0.200
    25.840    27.186     0.200
    26.030    26.355     0.200
    26.312    23.602     0.200
    26.341    26.346     0.200
    26.405    25.773     0.200
    26.447    25.759     0.200
    26.675    25.272     0.200
    26.815    25.180     0.200
    26.918    24.654     0.200
    26.926    23.723     0.200
    26.944    23.937     0.200
    26.953    24.406     0.200
    26.972    24.310     0.200
    27.097    23.632     0.200
    27.177    23.679     0.200
    27.251    24.035     0.200
    27.274    22.161     0.200
    27.331    23.928     0.200
    27.351    21.933     0.200
    27.351    22.468     0.200
    27.802    22.494     0.200
    27.906    21.414     0.200
    27.923    21.580     0.200
    28.348    21.422     0.200
    28.417    20.619     0.200
    28.465    20.292     0.200
    28.516    19.307     0.200
    28.797    18.414     0.200
    28.908    18.329     0.200
    29.114    17.656     0.200
    29.211    18.538     0.200
    29.253    17.365     0.200
    29.430    16.724     0.200
    29.541    16.383     0.200
    29.822    16.556     0.200
    29.940    14.866     0.200
    29.940    15.077     0.200
    29.974    14.956     0.200
    18.470    35.038     0.200
    24.609    30.222     0.200
    24.609    30.227     0.200
    18.326    34.391     0.200
    24.506    28.701     0.200
    24.506    28.706     0.200
    24.435    30.231     0.200
    23.301    35.243     0.200
    23.301    35.413     0.200
    23.801    34.157     0.200
    24.965    30.533     0.200
    25.569    29.422     0.200
    26.035    27.647     0.200
    26.928    25.992     0.200
    26.963    26.876     0.200
    27.115    24.808     0.200
    27.391    25.397     0.200
    27.451    24.843     0.200
    27.557    24.069     0.200
    27.653    23.985     0.200
    27.787    23.789     0.200
    27.787    24.071     0.200
    27.913    23.400     0.200
    28.375    22.144     0.200
    28.420    22.941     0.200
    28.512    21.862     0.200
    29.020    20.334     0.200
    29.088    20.214     0.200
    29.797    19.243     0.200
    16.994    36.941     0.200
    18.255    34.596     0.200
    19.335    35.999     0.200
    20.124    34.558     0.200
    23.053    34.153     0.200
    23.502    33.642     0.200
    23.842    28.975     0.200
    23.842    29.475     0.200
    23.947    32.423     0.200
    24.348    28.471     0.200
    24.348    29.342     0.200
    24.348    28.873     0.200
    24.472    27.958     0.200
    24.481    28.510     0.200
    24.481    26.764     0.200
    24.433    31.330     0.200
    24.527    30.852     0.200
    24.751    29.739     0.200
    25.015    25.966     0.200
    24.944    29.735     0.200
    25.172    28.627     0.200
    25.394    27.962     0.200
    25.478    28.367     0.200
    25.530    27.544     0.200
    25.872    26.835     0.200
    25.884    26.837     0.200
    26.070    26.076     0.200
    26.118    26.581     0.200
    26.232    22.887     0.200
    26.398    24.680     0.200
    26.459    24.504     0.200
    26.871    23.763     0.200
    26.966    23.819     0.200
    26.987    23.570     0.200
    26.999    23.607     0.200
    27.022    23.559     0.200
    27.151    22.789     0.200
    27.238    23.141     0.200
    27.311    23.485     0.200
    27.389    22.278     0.200
    27.858    21.264     0.200
    27.980    20.780     0.200
    28.019    21.477     0.200
    28.019    21.884     0.200
    28.022    21.537     0.200
    28.164    19.804     0.200
    28.405    20.628     0.200
    28.477    19.719     0.200
    28.527    19.632     0.200
    28.561    19.409     0.200
    28.829    18.137     0.200
    28.885    18.517     0.200
    28.944    17.944     0.200
    29.104    17.498     0.200
    29.161    17.615     0.200
    29.269    18.073     0.200
    29.289    16.990     0.200
    29.383    16.564     0.200
    29.493    16.480     0.200
    29.577    16.285     0.200
    29.877    16.152     0.200
    29.978    14.378     0.200
    29.978    14.940     0.200
    17.012    37.131     0.200
    17.012    36.709     0.200
    18.281    33.576     0.200
    20.139    35.219     0.200
    23.839    29.464     0.200
    23.839    29.042     0.200
    23.956    30.357     0.200
    24.343    28.825     0.200
    24.345    28.526     0.200
    24.345    28.796     0.200
    24.345    28.807     0.200
    24.494    28.086     0.200
    24.503    28.506     0.200
    24.503    27.373     0.200
    24.535    28.879     0.200
    24.602    30.716     0.200
    24.667    30.707     0.200
    24.731    27.648     0.200
    24.760    29.339     0.200
    24.778    30.019     0.200
    25.023    26.222     0.200
    25.023    25.745     0.200
    25.178    27.886     0.200
    25.402    27.604     0.200
    25.478    28.947     0.200
    25.485    28.542     0.200
    25.498    28.598     0.200
    25.535    26.892     0.200
    25.880    26.776     0.200
    26.080    26.259     0.200
    26.403    23.831     0.200
    26.465    25.374     0.200
    26.729    21.916     0.200
    26.876    23.764     0.200
    26.976    23.624     0.200
    26.996    23.084     0.200
    27.007    24.441     0.200
    27.029    24.737     0.200
    27.156    22.686     0.200
    27.241    22.924     0.200
    27.314    23.339     0.200
    27.400    22.239     0.200
    27.400    22.708     0.200
    27.739    21.605     0.200
    27.863    20.314     0.200
    27.985    20.413     0.200
    28.023    21.564     0.200
    28.023    21.974     0.200
    28.024    21.890     0.200
    28.167    20.023     0.200
    28.409    20.399     0.200
    28.481    19.089     0.200
    28.482    20.770     0.200
    28.569    19.585     0.200
    28.841    17.928     0.200
    28.888    18.635     0.200
    29.273    17.860     0.200
    29.495    16.573     0.200
    29.882    15.735     0.200
    29.988    14.265     0.200
    29.988    15.250     0.200
    17.128    37.526     0.200
    18.475    34.986     0.200
    18.475    34.790     0.200
    24.645    30.099     0.200
    24.654    29.321     0.200
    24.654    30.618     0.200
    24.361    31.703     0.200
    25.125    27.002     0.200
    26.122    27.309     0.200
    27.017    25.529     0.200
    27.031    24.589     0.200
    27.046    24.221     0.200
    27.306    24.342     0.200
    28.902    18.511     0.200
    28.896    19.783     0.200
    29.194    18.477     0.200
    29.271    19.102     0.200
    16.929    37.029     0.200
    18.245    34.227     0.200
    18.245    34.500     0.200
    23.855    32.402     0.200
    23.864    32.542     0.200
    23.942    30.011     0.200
    23.942    30.511     0.200
    24.434    30.922     0.200
    24.426    28.960     0.200
    24.434    28.914     0.200
    24.434    27.109     0.200
    24.448    29.729     0.200
    24.448    29.807     0.200
    24.448    29.604     0.200
    25.116    26.140     0.200
    25.116    26.617     0.200
    25.396    28.566     0.200
    25.501    27.750     0.200
    25.980    26.451     0.200
    26.335    25.189     0.200
    26.362    25.530     0.200
    26.895    23.017     0.200
    26.905    24.463     0.200
    27.300    22.727     0.200
    27.300    23.524     0.200
    27.760    22.566     0.200
    28.306    20.589     0.200
    28.468    19.794     0.200
    28.743    19.400     0.200
    28.856    19.437     0.200
    29.201    18.204     0.200
    29.295    15.968     0.200
    29.392    17.111     0.200
    29.489    15.723     0.200
    29.889    15.442     0.200
    17.505    37.548     0.200
    17.505    37.650     0.200
    18.731    34.427     0.200
    18.731    33.450     0.200
    19.791    35.676     0.200
    23.484    30.482     0.200
    23.993    30.395     0.200
    23.994    30.151     0.200
    23.994    29.705     0.200
    23.994    30.377     0.200
    23.985    30.326     0.200
    24.000    31.687     0.200
    24.329    31.719     0.200
    24.376    31.412     0.200
    24.383    31.409     0.200
    24.852    26.709     0.200
    24.819    30.305     0.200
    24.990    27.616     0.200
    24.960    29.810     0.200
    24.999    27.942     0.200
    24.999    26.223     0.200
    25.004    28.544     0.200
    25.189    28.151     0.200
    25.206    29.411     0.200
    25.849    24.284     0.200
    25.828    28.139     0.200
    26.006    24.938     0.200
    25.909    27.777     0.200
    25.935    26.563     0.200
    26.249    26.819     0.200
    26.301    25.902     0.200
    26.489    26.378     0.200
    26.515    25.309     0.200
    26.904    25.312     0.200
    27.147    23.843     0.200
    27.256    24.060     0.200
    27.409    23.501     0.200
    27.422    22.568     0.200
    27.424    23.046     0.200
    27.432    23.404     0.200
    27.506    23.648     0.200
    27.680    22.916     0.200
    27.786    21.170     0.200
    27.840    21.414     0.200
    27.840    21.586     0.200
    27.840    21.289     0.200
    27.838    22.360     0.200
    28.163    20.535     0.200
    28.237    21.307     0.200
    28.245    21.948     0.200
    28.357    21.328     0.200
    28.372    20.231     0.200
    28.367    21.526     0.200
    28.788    19.314     0.200
    28.845    19.904     0.200
    28.992    18.522     0.200
    29.236    18.250     0.200
    29.296    16.941     0.200
    29.400    16.845     0.200
    29.562    16.107     0.200
    29.582    16.135     0.200
    29.647    17.976     0.200
    29.745    15.878     0.200
    29.841    15.455     0.200
    29.846    16.183     0.200
    16.803    38.503     0.200
    18.324    36.016     0.200
    18.324    35.167     0.200
    20.570    36.357     0.200
    24.245    31.269     0.200
    24.382    30.844     0.200
    24.382    29.989     0.200
    24.752    30.254     0.200
    24.753    30.107     0.200
    24.753    30.377     0.200
    24.753    30.236     0.200
    25.471    26.488     0.200
    25.471    25.763     0.200
    27.065    25.536     0.200
    18.324    36.366     0.200
    24.379    30.524     0.200
    24.761    30.316     0.200
    25.479    26.342     0.200
    15.658    39.925     0.200
    23.194    33.844     0.200
    25.468    29.310     0.200
    25.470    29.290     0.200
    25.704    30.872     0.200
    18.388    35.707     0.200
    24.542    29.863     0.200
    24.471    31.107     0.200
    24.471    30.321     0.200
    16.631    38.856     0.200
    18.429    36.169     0.200
    19.163    37.726     0.200
    20.515    36.915     0.200
    20.515    35.495     0.200
    21.933    33.510     0.200
    23.738    35.555     0.200
    23.747    32.982     0.200
    24.116    32.945     0.200
    24.115    32.105     0.200
    24.324    32.204     0.200
    24.517    31.121     0.200
    24.486    30.988     0.200
    24.554    32.452     0.200
    24.624    30.163     0.200
    24.624    31.087     0.200
    24.940    30.250     0.200
    25.193    30.285     0.200
    25.272    30.803     0.200
    25.287    30.223     0.200
    25.381    27.426     0.200
    25.381    27.600     0.200
    25.606    28.473     0.200
    25.994    27.833     0.200
    26.141    27.987     0.200
    26.140    27.600     0.200
    26.217    27.933     0.200
    26.395    26.434     0.200
    26.510    25.984     0.200
    26.577    27.667     0.200
    26.577    26.026     0.200
    26.577    24.958     0.200
    26.586    26.212     0.200
    26.619    25.875     0.200
    26.786    27.332     0.200
    26.787    27.009     0.200
    26.793    24.934     0.200
    26.831    27.262     0.200
    26.909    25.355     0.200
    26.966    25.574     0.200
    27.133    24.754     0.200
    27.210    25.586     0.200
    27.210    24.791     0.200
    27.208    24.997     0.200
    27.467    24.721     0.200
    27.608    24.218     0.200
    27.665    24.411     0.200
    27.722    22.383     0.200
    27.748    25.049     0.200
    28.211    22.577     0.200
    28.251    22.791     0.200
    28.631    22.535     0.200
    28.740    21.489     0.200
    29.215    20.332     0.200
    29.397    19.990     0.200
    29.681    19.731     0.200
    29.797    17.137     0.200
    29.888    18.729     0.200
    21.920    33.597     0.200
    24.127    32.989     0.200
    24.502    30.501     0.200
    24.636    31.939     0.200
    24.636    31.087     0.200
    24.636    31.667     0.200
    25.388    26.787     0.200
    16.872    38.697     0.200
    21.582    33.432     0.200
    24.327    30.954     0.200
    24.928    27.834     0.200
    16.756    40.339     0.200
    22.383    34.322     0.200
    24.288    32.751     0.200
    24.288    32.728     0.200
    25.006    31.523     0.200
    20.896    35.631     0.200
    21.192    34.937     0.200
    23.597    32.014     0.200
    24.999    30.352     0.200
    25.502    27.326     0.200
    25.502    27.846     0.200
    25.992    25.489     0.200
    25.992    25.262     0.200
    26.230    26.026     0.200
    21.405    35.680     0.200
    21.405    35.817     0.200
    23.983    33.514     0.200
    24.908    31.186     0.200
    24.908    31.861     0.200
    24.908    30.307     0.200
    25.483    31.656     0.200
    26.802    28.367     0.200
    28.242    22.635     0.200
    16.752    39.080     0.200
    18.281    36.035     0.200
    20.580    36.435     0.200
    20.580    35.705     0.200
    24.332    30.473     0.200
    24.285    31.695     0.200
    24.285    31.324     0.200
    24.793    29.566     0.200
    24.793    29.841     0.200
    24.793    29.165     0.200
    25.494    25.464     0.200
    25.494    26.388     0.200
    18.831    38.806     0.200
    22.342    34.905     0.200
    24.320    34.446     0.200
    24.320    33.742     0.200
    24.320    34.141     0.200
    24.960    32.741     0.200
    25.239    29.301     0.200
    26.381    27.239     0.200
    26.381    27.794     0.200
    14.326    40.990     0.200
    17.426    41.466     0.200
    18.874    38.249     0.200
    24.303    33.093     0.200
    25.002    32.460     0.200
    25.091    28.483     0.200
    16.573    37.992     0.200
    17.682    38.534     0.200
    20.147    36.481     0.200
    22.541    33.068     0.200
    23.001    35.137     0.200
    23.962    33.218     0.200
    24.014    33.872     0.200
    24.162    32.064     0.200
    24.162    32.783     0.200
    24.441    31.223     0.200
    24.441    30.231     0.200
    24.948    29.807     0.200
    24.948    29.057     0.200
    24.948    29.128     0.200
    24.948    28.503     0.200
    25.269    28.996     0.200
    25.304    29.494     0.200
    25.597    26.467     0.200
    25.515    29.946     0.200
    25.651    29.025     0.200
    25.804    28.828     0.200
    25.808    28.188     0.200
    25.872    29.477     0.200
    26.045    27.360     0.200
    26.151    28.495     0.200
    26.255    26.890     0.200
    26.279    26.992     0.200
    26.410    26.909     0.200
    26.424    26.643     0.200
    26.428    27.479     0.200
    26.476    25.875     0.200
    26.564    26.713     0.200
    26.648    26.200     0.200
    26.638    26.038     0.200
    26.831    24.871     0.200
    26.811    25.466     0.200
    26.795    25.237     0.200
    26.841    26.958     0.200
    26.841    25.833     0.200
    27.123    23.772     0.200
    27.165    25.206     0.200
    27.267    25.157     0.200
    27.333    24.937     0.200
    27.378    24.822     0.200
    27.420    25.758     0.200
    27.774    24.625     0.200
    27.879    23.640     0.200
    27.995    23.371     0.200
    28.299    21.007     0.200
    28.284    23.282     0.200
    28.420    21.269     0.200
    28.675    21.946     0.200
    28.746    21.058     0.200
    28.806    21.369     0.200
    28.891    19.503     0.200
    29.288    19.754     0.200
    29.429    17.384     0.200
    29.429    16.986     0.200
    29.567    17.307     0.200
    29.993    17.620     0.200
    18.526    38.118     0.200
    18.526    38.907     0.200
    24.366    30.473     0.200
    22.039    32.010     0.200
    16.480    38.472     0.200
    16.870    38.262     0.200
    20.440    35.980     0.200
    20.440    36.496     0.200
    20.702    35.459     0.200
    20.795    34.553     0.200
    20.795    34.975     0.200
    21.710    32.782     0.200
    21.710    33.321     0.200
    22.422    36.162     0.200
    22.752    35.895     0.200
    23.342    32.411     0.200
    23.342    32.232     0.200
    24.136    33.660     0.200
    24.513    32.204     0.200
    24.513    32.603     0.200
    24.817    28.899     0.200
    24.817    28.126     0.200
    24.873    31.862     0.200
    24.876    31.420     0.200
    24.969    30.778     0.200
    25.129    30.937     0.200
    25.231    30.502     0.200
    25.314    27.741     0.200
    25.314    27.592     0.200
    25.297    29.781     0.200
    25.406    30.101     0.200
    25.413    29.950     0.200
    25.438    30.449     0.200
    25.620    26.795     0.200
    25.873    28.586     0.200
    25.892    28.748     0.200
    25.928    28.470     0.200
    26.125    26.764     0.200
    26.131    28.505     0.200
    26.277    27.623     0.200
    26.277    27.350     0.200
    26.329    27.221     0.200
    26.358    26.503     0.200
    26.397    26.341     0.200
    26.397    26.567     0.200
    26.741    24.461     0.200
    26.961    24.716     0.200
    26.961    22.896     0.200
    26.997    26.286     0.200
    27.064    26.044     0.200
    27.208    21.860     0.200
    27.569    24.377     0.200
    28.281    21.802     0.200
    28.699    18.719     0.200
    28.867    18.990     0.200
    28.867    19.881     0.200
    29.238    18.353     0.200
    20.514    35.825     0.200
    20.514    34.745     0.200
    20.835    34.160     0.200
    20.835    34.375     0.200
    21.758    32.669     0.200
    21.758    32.489     0.200
    23.233    33.677     0.200
    23.358    31.285     0.200
    23.516    33.178     0.200
    23.609    33.155     0.200
    23.628    32.074     0.200
    24.519    30.848     0.200
    24.762    30.944     0.200
    24.938    30.713     0.200
    25.189    29.251     0.200
    25.314    29.545     0.200
    25.400    30.018     0.200
    25.391    29.256     0.200
    25.360    26.418     0.200
    25.551    28.900     0.200
    25.615    29.279     0.200
    25.687    25.231     0.200
    25.687    25.080     0.200
    25.829    28.703     0.200
    25.893    28.341     0.200
    25.954    28.039     0.200
    26.112    26.424     0.200
    26.089    27.127     0.200
    26.249    26.862     0.200
    26.249    26.648     0.200
    26.352    27.618     0.200
    26.813    25.263     0.200
    26.914    25.086     0.200
    27.016    25.722     0.200
    28.319    21.824     0.200
    28.838    19.417     0.200
    14.263    39.929     0.200
    16.990    38.672     0.200
    20.237    36.880     0.200
    20.485    34.052     0.200
    20.485    35.369     0.200
    21.389    34.177     0.200
    21.389    35.759     0.200
    23.092    33.312     0.200
    24.827    30.215     0.200
    25.320    30.417     0.200
    25.320    29.160     0.200
    25.320    29.831     0.200
    25.320    29.277     0.200
    25.443    28.784     0.200
    25.491    28.212     0.200
    25.491    27.564     0.200
    25.900    27.272     0.200
    25.972    27.319     0.200
    26.108    26.948     0.200
    26.191    28.288     0.200
    26.191    27.526     0.200
    26.342    27.773     0.200
    26.389    28.066     0.200
    26.843    26.186     0.200
    26.965    26.250     0.200
    27.075    26.717     0.200
    27.600    24.080     0.200
    28.076    22.189     0.200
    28.781    19.663     0.200
    15.328    38.219     0.200
    20.962    34.676     0.200
    20.962    34.131     0.200
    23.464    31.986     0.200
    26.182    26.543     0.200
    28.881    18.819     0.200
    17.825    37.249     0.200
    21.301    34.728     0.200
    23.703    33.436     0.200
    25.454    27.252     0.200
    26.305    26.704     0.200
    26.912    26.584     0.200
    28.209    20.987     0.200
    17.115    38.950     0.200
    17.115    38.739     0.200
    17.197    38.544     0.200
    17.848    38.421     0.200
    18.253    37.095     0.200
    18.816    36.952     0.200
    18.816    34.780     0.200
    19.171    37.014     0.200
    20.932    35.398     0.200
    20.932    35.953     0.200
    22.309    33.994     0.200
    22.309    34.236     0.200
    23.213    32.968     0.200
    23.916    31.957     0.200
    24.274    29.845     0.200
    24.274    31.665     0.200
    24.274    29.962     0.200
    24.788    30.161     0.200
    24.788    29.036     0.200
    24.773    30.482     0.200
    25.717    26.644     0.200
    25.717    26.418     0.200
    26.119    25.205     0.200
    26.614    24.456     0.200
    26.866    24.304     0.200
    26.866    24.194     0.200
    26.866    26.811     0.200
    26.866    25.014     0.200
    27.203    25.044     0.200
    27.203    23.747     0.200
    28.035    23.538     0.200
    29.530    18.922     0.200
    29.788    16.994     0.200
    18.375    38.453     0.200
    18.576    39.260     0.200
    18.920    37.787     0.200
    18.920    38.225     0.200
    20.544    39.218     0.200
    20.505    38.145     0.200
    20.505    38.981     0.200
    22.431    34.815     0.200
    22.431    35.284     0.200
    23.277    33.064     0.200
    23.277    33.564     0.200
    23.757    35.803     0.200
    24.271    34.275     0.200
    24.271    35.134     0.200
    24.271    34.212     0.200
    24.271    33.939     0.200
    25.226    30.141     0.200
    26.356    26.889     0.200
    26.356    28.967     0.200
    18.491    35.612     0.200
    22.853    31.547     0.200
    24.635    29.704     0.200
    24.446    30.689     0.200
    23.954    31.133     0.200
    24.875    28.279     0.200
    18.314    36.467     0.200
    24.803    30.565     0.200
    21.422    34.619     0.200
    22.338    32.483     0.200
    22.484    32.957     0.200
    23.919    31.699     0.200
    25.129    28.886     0.200
    25.695    26.331     0.200
    26.620    26.428     0.200
    29.559    17.866     0.200
    29.707    17.871     0.200
    18.523    36.912     0.200
    24.390    32.385     0.200
    15.460    36.690     0.200
    16.349    36.734     0.200
    18.373    35.515     0.200
    19.399    33.999     0.200
    19.875    33.942     0.200
    22.229    30.477     0.200
    22.229    31.055     0.200
    23.896    29.077     0.200
    24.991    27.867     0.200
    24.991    28.141     0.200
    24.991    27.066     0.200
    25.392    28.073     0.200
    26.710    24.805     0.200
    28.726    19.935     0.200
    29.101    18.747     0.200
    29.648    16.798     0.200
    15.135    38.224     0.200
    15.348    39.139     0.200
    21.528    34.378     0.200
    22.444    32.165     0.200
    24.019    31.144     0.200
    16.767    36.380     0.200
    17.483    35.904     0.200
    18.052    36.281     0.200
    18.309    34.321     0.200
    18.309    34.837     0.200
    18.309    34.439     0.200
    20.180    35.026     0.200
    20.180    35.472     0.200
    20.483    34.436     0.200
    21.824    31.606     0.200
    22.660    30.859     0.200
    23.791    30.706     0.200
    23.861    29.493     0.200
    23.861    30.923     0.200
    24.517    28.668     0.200
    24.517    28.887     0.200
    24.367    29.472     0.200
    24.367    30.308     0.200
    24.367    29.300     0.200
    24.367    29.034     0.200
    25.059    25.941     0.200
    26.282    24.461     0.200
    26.269    24.512     0.200
    26.447    23.899     0.200
    26.992    23.014     0.200
    27.306    22.369     0.200
    27.389    22.172     0.200
    27.844    20.398     0.200
    29.978    14.598     0.200
    14.572    39.925     0.200
    14.609    39.883     0.200
    14.776    42.119     0.200
    15.445    40.971     0.200
    15.522    39.488     0.200
    15.538    39.101     0.200
    15.726    38.569     0.200
    15.765    40.072     0.200
    15.890    41.045     0.200
    16.301    39.146     0.200
    16.395    39.949     0.200
    16.910    39.047     0.200
    16.960    38.369     0.200
    17.515    38.500     0.200
    17.969    39.511     0.200
    18.521    36.671     0.200
    18.521    36.819     0.200
    22.025    33.918     0.200
    22.897    31.687     0.200
    24.598    30.028     0.200
    24.609    32.324     0.200
    24.609    30.926     0.200
    18.465    37.283     0.200
    18.465    38.344     0.200
    20.165    36.508     0.200
    20.165    37.848     0.200
    20.815    34.363     0.200
    20.815    34.828     0.200
    21.695    33.118     0.200
    22.760    32.030     0.200
    23.462    32.469     0.200
    25.033    28.745     0.200
    25.033    31.235     0.200
    25.033    28.655     0.200
    25.033    29.160     0.200
    25.326    27.762     0.200
    26.121    27.956     0.200
    26.152    28.566     0.200
    26.527    28.018     0.200
    26.666    24.352     0.200
    26.666    26.881     0.200
    26.666    24.550     0.200
    29.138    20.714     0.200
    14.591    43.141     0.200
    14.638    43.162     0.200
    14.738    41.922     0.200
    14.838    40.613     0.200
    16.228    40.657     0.200
    18.364    36.830     0.200
    18.364    37.565     0.200
    21.861    34.380     0.200
    24.390    31.388     0.200
    24.817    31.458     0.200
    15.221    40.152     0.200
    15.511    38.423     0.200
    15.696    38.895     0.200
    16.164    39.459     0.200
    16.813    39.038     0.200
    18.291    36.272     0.200
    18.291    36.657     0.200
    21.794    32.974     0.200
    24.376    31.492     0.200
    24.699    30.487     0.200
    24.699    30.208     0.200
    24.699    30.756     0.200
    18.376    35.321     0.200
    18.376    36.192     0.200
    21.868    34.936     0.200
    22.774    32.990     0.200
    24.361    31.173     0.200
    24.919    29.405     0.200
    18.894    38.299     0.200
    25.023    32.969     0.200
    17.396    39.507     0.200
    17.463    38.881     0.200
    17.463    40.730     0.200
    18.375    38.141     0.200
    18.920    36.702     0.200
    18.920    37.178     0.200
    19.500    37.652     0.200
    19.960    36.960     0.200
    20.525    38.383     0.200
    20.534    36.628     0.200
    20.527    37.883     0.200
    20.527    37.403     0.200
    21.023    36.977     0.200
    22.431    34.321     0.200
    23.279    32.822     0.200
    23.779    35.046     0.200
    23.779    33.796     0.200
    23.779    33.245     0.200
    23.779    33.347     0.200
    23.779    34.056     0.200
    24.145    33.292     0.200
    24.669    34.413     0.200
    25.043    31.818     0.200
    25.118    32.123     0.200
    25.249    29.093     0.200
    26.123    26.885     0.200
    26.380    27.695     0.200
    26.380    28.394     0.200
    26.380    26.394     0.200
    26.380    27.454     0.200
    26.550    27.544     0.200
    27.241    26.059     0.200
    27.295    27.183     0.200
    27.655    26.284     0.200
    27.655    24.866     0.200
    17.276    41.206     0.200
    18.882    39.374     0.200
    25.006    32.585     0.200
    14.283    42.177     0.200
    14.388    43.823     0.200
    14.611    44.494     0.200
    15.208    42.901     0.200
    15.834    40.872     0.200
    16.021    43.646     0.200
    16.188    40.808     0.200
    16.323    42.385     0.200
    17.332    39.846     0.200
    16.232    39.426     0.200
    16.751    38.495     0.200
    18.367    35.980     0.200
    24.388    31.822     0.200
    22.355    31.479     0.200
    24.707    30.530     0.200
    26.522    22.566     0.200
    18.335    37.040     0.200
    18.878    37.083     0.200
    23.230    31.834     0.200
    24.230    32.132     0.200
    25.032    30.907     0.200
    29.149    18.934     0.200
    15.224    41.349     0.200
    17.594    41.634     0.200
    17.594    40.759     0.200
    18.278    40.782     0.200
    18.419    37.527     0.200
    18.419    37.982     0.200
    18.673    39.296     0.200
    18.958    36.855     0.200
    18.958    37.701     0.200
    18.958    37.320     0.200
    18.958    38.275     0.200
    20.088    38.445     0.200
    20.368    39.521     0.200
    20.652    37.853     0.200
    21.117    38.164     0.200
    21.117    36.591     0.200
    22.475    33.908     0.200
    22.475    34.404     0.200
    23.302    33.006     0.200
    24.103    34.795     0.200
    24.103    33.436     0.200
    24.103    35.051     0.200
    25.144    31.601     0.200
    26.192    29.789     0.200
    26.192    30.359     0.200
    26.493    29.824     0.200
    14.543    43.538     0.200
    15.183    42.792     0.200
    16.251    41.773     0.200
    18.847    37.062     0.200
    24.204    32.147     0.200
    17.223    39.780     0.200
    17.313    39.938     0.200
    18.188    40.029     0.200
    18.733    37.300     0.200
    18.733    39.168     0.200
    20.843    38.231     0.200
    22.244    35.074     0.200
    22.244    35.664     0.200
    23.093    34.199     0.200
    23.845    34.591     0.200
    24.357    33.547     0.200
    24.357    32.308     0.200
    24.357    33.008     0.200
    24.866    31.947     0.200
    26.390    27.216     0.200
    13.965    43.650     0.200
    14.381    41.405     0.200
    14.440    40.272     0.200
    14.451    40.103     0.200
    15.098    40.679     0.200
    15.226    38.449     0.200
    15.359    38.809     0.200
    15.552    39.149     0.200
    15.563    41.314     0.200
    15.701    38.176     0.200
    15.910    37.919     0.200
    16.667    39.054     0.200
    16.741    38.590     0.200
    18.322    37.601     0.200
    20.576    36.824     0.200
    22.706    31.946     0.200
    23.590    35.375     0.200
    24.252    32.146     0.200
    24.252    32.326     0.200
    24.373    31.778     0.200
    24.378    30.511     0.200
    24.378    29.362     0.200
    24.761    30.190     0.200
    24.761    29.987     0.200
    24.761    29.791     0.200
    25.478    26.619     0.200
    26.688    25.797     0.200
    16.036    37.851     0.200
    17.770    38.210     0.200
    23.663    33.797     0.200
    25.445    28.220     0.200
    19.983    36.439     0.200
    21.419    33.552     0.200
    21.419    33.392     0.200
    22.302    32.702     0.200
    22.302    32.309     0.200
    22.988    35.340     0.200
    23.411    34.688     0.200
    23.919    34.047     0.200
    24.007    31.348     0.200
    24.007    31.043     0.200
    24.370    31.888     0.200
    24.370    31.628     0.200
    24.370    32.237     0.200
    24.874    30.109     0.200
    24.874    29.324     0.200
    26.835    25.636     0.200
    29.336    19.845     0.200
    14.071    41.154     0.200
    14.366    42.142     0.200
    14.599    44.422     0.200
    14.623    44.497     0.200
    14.694    41.282     0.200
    14.925    44.877     0.200
    18.379    38.425     0.200
    18.925    38.008     0.200
    22.435    34.652     0.200
    23.287    33.786     0.200
    24.325    33.224     0.200
    24.325    33.345     0.200
    24.325    33.095     0.200
    25.036    30.394     0.200
    25.036    32.144     0.200
    15.224    41.227     0.200
    20.281    35.618     0.200
    21.099    34.915     0.200
    23.130    33.492     0.200
    23.139    33.673     0.200
    23.139    32.436     0.200
    23.196    34.213     0.200
    25.039    30.991     0.200
    17.039    39.127     0.200
    17.075    38.982     0.200
    17.639    39.326     0.200
    18.646    37.010     0.200
    18.646    37.130     0.200
    24.710    30.878     0.200
    24.710    30.543     0.200
    24.585    30.386     0.200
    24.585    31.651     0.200
    16.923    39.927     0.200
    23.116    35.703     0.200
    25.135    29.347     0.200
    15.969    38.461     0.200
    16.407    39.506     0.200
    16.671    38.271     0.200
    18.219    38.480     0.200
    19.568    37.230     0.200
    20.790    35.634     0.200
    20.790    36.205     0.200
    21.136    35.369     0.200
    22.080    33.409     0.200
    22.080    33.554     0.200
    23.576    32.247     0.200
    24.931    29.210     0.200
    24.931    28.710     0.200
    25.426    29.672     0.200
    25.433    27.543     0.200
    25.433    27.194     0.200
    25.433    27.344     0.200
    25.882    28.890     0.200
    25.895    26.058     0.200
    26.271    26.269     0.200
    26.272    27.453     0.200
    26.272    27.771     0.200
    27.193    23.311     0.200
    27.193    22.510     0.200
    27.193    23.881     0.200
    27.193    22.920     0.200
    27.332    23.387     0.200
    28.045    22.348     0.200
    28.771    21.317     0.200
    28.771    21.937     0.200
    28.861    19.945     0.200
    29.346    20.253     0.200
    15.907    39.768     0.200
    21.038    34.801     0.200
    23.496    32.130     0.200
    25.432    27.179     0.200
    25.852    24.834     0.200
    15.765    38.645     0.200
    16.343    37.230     0.200
    19.845    35.601     0.200
    20.386    35.316     0.200
    20.386    35.826     0.200
    21.280    32.575     0.200
    22.166    31.206     0.200
    22.166    30.991     0.200
    23.304    33.680     0.200
    23.328    34.426     0.200
    23.870    30.282     0.200
    23.870    30.067     0.200
    23.927    30.325     0.200
    24.437    29.242     0.200
    24.437    28.242     0.200
    24.437    28.473     0.200
    24.437    28.653     0.200
    24.548    30.505     0.200
    24.939    27.282     0.200
    24.939    27.542     0.200
    24.939    27.546     0.200
    24.939    27.882     0.200
    25.269    28.638     0.200
    25.431    25.450     0.200
    25.687    28.622     0.200
    26.262    26.983     0.200
    26.631    23.743     0.200
    26.711    22.612     0.200
    26.711    22.411     0.200
    26.711    22.772     0.200
    26.738    25.194     0.200
    26.738    25.343     0.200
    26.841    21.986     0.200
    27.096    24.993     0.200
    27.920    22.001     0.200
    28.526    20.826     0.200
    29.261    18.545     0.200
    29.261    18.795     0.200
    21.252    35.519     0.200
    23.678    32.929     0.200
    23.682    31.800     0.200
    23.682    32.339     0.200
    23.738    32.090     0.200
    25.402    28.799     0.200
    25.402    26.666     0.200
    25.402    29.650     0.200
    29.798    16.867     0.200
    20.631    35.328     0.200
    20.631    34.929     0.200
    21.154    34.149     0.200
    21.154    33.789     0.200
    22.077    32.107     0.200
    22.077    31.924     0.200
    23.647    31.538     0.200
    23.652    30.824     0.200
    23.652    31.253     0.200
    24.762    28.422     0.200
    24.762    28.801     0.200
    25.264    27.121     0.200
    25.264    27.094     0.200
    25.722    24.835     0.200
    25.722    24.710     0.200
    26.026    25.512     0.200
    26.257    25.151     0.200
    26.340    25.230     0.200
    26.423    27.232     0.200
    27.018    21.781     0.200
    27.018    22.589     0.200
    27.018    22.390     0.200
    27.018    22.847     0.200
    27.410    21.730     0.200
    17.716    37.489     0.200
    18.013    37.130     0.200
    18.183    37.568     0.200
    20.891    35.919     0.200
    21.191    34.880     0.200
    21.191    34.423     0.200
    22.391    32.232     0.200
    23.594    31.950     0.200
    23.598    31.628     0.200
    24.994    29.196     0.200
    25.498    27.190     0.200
    25.498    26.999     0.200
    25.498    27.409     0.200
    26.052    25.802     0.200
    25.987    25.445     0.200
    26.234    27.383     0.200
    26.549    23.425     0.200
    26.845    23.221     0.200
    27.278    23.135     0.200
    28.714    21.317     0.200
    17.189    38.372     0.200
    17.971    38.725     0.200
    18.673    36.129     0.200
    18.673    35.785     0.200
    19.318    36.489     0.200
    20.345    37.094     0.200
    20.371    37.444     0.200
    20.371    37.257     0.200
    20.809    35.795     0.200
    22.186    33.484     0.200
    22.186    33.668     0.200
    23.028    32.366     0.200
    23.028    33.515     0.200
    23.795    33.882     0.200
    23.795    33.691     0.200
    23.795    33.581     0.200
    23.795    34.093     0.200
    24.079    33.846     0.200
    24.306    32.220     0.200
    24.306    32.544     0.200
    24.306    32.720     0.200
    24.831    30.396     0.200
    24.836    30.786     0.200
    24.836    30.536     0.200
    24.836    30.216     0.200
    25.155    28.317     0.200
    26.156    27.229     0.200
    26.318    27.445     0.200
    26.318    26.683     0.200
    26.318    25.816     0.200
    27.559    24.956     0.200
    20.955    36.177     0.200
    21.198    34.480     0.200
    22.160    33.257     0.200
    22.344    32.609     0.200
    23.578    32.793     0.200
    23.582    32.480     0.200
    23.582    32.207     0.200
    25.557    27.484     0.200
    25.557    27.198     0.200
    25.557    27.593     0.200
    26.157    25.540     0.200
    21.188    35.647     0.200
    22.151    35.097     0.200
    22.329    34.539     0.200
    22.725    34.523     0.200
    22.929    34.755     0.200
    23.235    35.329     0.200
    23.565    33.275     0.200
    23.568    32.955     0.200
    23.568    33.181     0.200
    23.625    33.264     0.200
    25.210    28.720     0.200
    25.225    28.539     0.200
    25.571    27.677     0.200
    25.571    28.028     0.200
    25.813    27.933     0.200
    26.142    27.295     0.200
    26.157    27.733     0.200
    26.720    26.434     0.200
    28.074    22.725     0.200
    28.758    18.900     0.200
    28.952    20.294     0.200
    29.634    19.073     0.200
    21.346    32.494     0.200
    14.864    40.012     0.200
    14.890    42.011     0.200
    15.259    38.662     0.200
    15.692    41.788     0.200
    15.988    39.978     0.200
    16.477    39.794     0.200
    17.013    38.793     0.200
    17.106    38.239     0.200
    17.350    38.092     0.200
    18.590    35.950     0.200
    18.590    36.352     0.200
    23.835    32.196     0.200
    24.345    31.794     0.200
    24.345    31.137     0.200
    24.345    31.794     0.200
    24.754    30.028     0.200
    25.889    28.852     0.200
    15.339    36.567     0.200
    15.812    36.994     0.200
    16.278    37.129     0.200
    16.305    36.499     0.200
    16.969    37.244     0.200
    17.357    37.537     0.200
    19.269    34.878     0.200
    20.367    35.153     0.200
    20.367    33.723     0.200
    21.127    34.054     0.200
    21.232    32.248     0.200
    21.232    32.381     0.200
    22.119    30.648     0.200
    22.890    32.154     0.200
    23.309    32.330     0.200
    23.499    31.685     0.200
    23.828    30.394     0.200
    23.828    30.269     0.200
    23.828    30.034     0.200
    24.450    29.196     0.200
    24.450    28.172     0.200
    24.450    28.500     0.200
    24.450    29.360     0.200
    24.952    27.646     0.200
    24.952    26.841     0.200
    24.952    27.419     0.200
    24.952    26.646     0.200
    25.253    27.731     0.200
    25.253    27.247     0.200
    25.423    24.942     0.200
    26.063    24.211     0.200
    26.598    23.735     0.200
    26.713    24.633     0.200
    26.713    25.266     0.200
    26.709    22.137     0.200
    26.709    21.825     0.200
    26.709    22.536     0.200
    26.709    22.395     0.200
    26.857    21.809     0.200
    27.080    22.393     0.200
    27.417    23.827     0.200
    27.566    21.612     0.200
    29.114    16.938     0.200
    29.245    17.547     0.200
    17.781    36.746     0.200
    21.279    32.792     0.200
    23.859    30.653     0.200
    23.859    29.067     0.200
    24.970    25.916     0.200
    24.970    27.426     0.200
    23.475    31.812     0.200
    25.457    27.458     0.200
    26.726    24.686     0.200
    29.678    16.554     0.200
    16.606    37.661     0.200
    17.142    37.266     0.200
    21.197    34.623     0.200
    22.121    32.306     0.200
    23.690    31.040     0.200
    23.690    31.271     0.200
    25.254    28.234     0.200
    17.871    37.151     0.200
    18.416    35.082     0.200
    18.416    35.746     0.200
    21.927    32.487     0.200
    24.132    29.615     0.200
    24.439    30.509     0.200
    24.439    30.184     0.200
    24.439    30.290     0.200
    24.571    29.869     0.200
    24.576    29.234     0.200
    27.471    21.556     0.200
    15.079    38.715     0.200
    16.251    37.922     0.200
    16.762    37.369     0.200
    18.367    34.900     0.200
    18.367    36.269     0.200
    24.520    28.872     0.200
    24.583    29.077     0.200
    24.468    30.111     0.200
    24.468    29.651     0.200
    16.809    38.788     0.200
    18.379    37.089     0.200
    18.379    38.112     0.200
    21.876    34.551     0.200
    24.402    32.108     0.200
    24.406    31.242     0.200
    24.406    32.203     0.200
    24.807    30.983     0.200
    24.807    31.046     0.200
    24.807    31.343     0.200
    25.707    30.280     0.200
    17.135    37.138     0.200
    18.825    36.249     0.200
    20.299    35.607     0.200
    20.299    34.857     0.200
    21.294    32.385     0.200
    21.361    32.969     0.200
    21.361    32.457     0.200
    22.233    30.226     0.200
    22.233    30.691     0.200
    22.581    30.642     0.200
    23.472    33.953     0.200
    23.981    28.730     0.200
    23.987    30.040     0.200
    24.296    29.457     0.200
    24.296    29.008     0.200
    24.296    28.555     0.200
    24.296    28.137     0.200
    24.799    27.990     0.200
    24.799    27.842     0.200
    24.799    27.713     0.200
    25.315    25.361     0.200
    26.585    24.241     0.200
    26.585    22.069     0.200
    26.585    23.019     0.200
    26.699    22.515     0.200
    26.770    23.987     0.200
    26.882    24.479     0.200
    26.882    24.600     0.200
    28.064    21.575     0.200
    29.404    17.746     0.200
    18.629    35.058     0.200
    18.629    36.066     0.200
    18.629    34.308     0.200
    22.145    31.824     0.200
    22.145    32.004     0.200
    22.978    30.254     0.200
    23.740    32.863     0.200
    23.740    31.668     0.200
    23.740    33.277     0.200
    24.250    31.370     0.200
    24.638    29.401     0.200
    24.821    28.650     0.200
    24.821    28.470     0.200
    26.245    24.247     0.200
    26.245    24.934     0.200
    27.556    22.542     0.200
    27.592    22.411     0.200
    18.612    35.155     0.200
    18.612    34.252     0.200
    19.295    34.627     0.200
    20.290    36.800     0.200
    20.290    35.720     0.200
    22.128    32.294     0.200
    22.128    31.106     0.200
    22.962    30.269     0.200
    23.756    32.148     0.200
    23.756    33.207     0.200
    23.756    33.057     0.200
    24.102    33.168     0.200
    24.266    30.795     0.200
    24.266    31.205     0.200
    24.266    30.895     0.200
    24.795    28.532     0.200
    24.801    29.281     0.200
    24.801    29.026     0.200
    24.858    28.993     0.200
    25.086    27.277     0.200
    26.122    25.337     0.200
    26.257    24.636     0.200
    26.257    26.066     0.200
    26.257    25.766     0.200
    26.257    25.626     0.200
    27.152    25.392     0.200
    27.572    23.218     0.200
    27.572    24.038     0.200
    15.721    38.084     0.200
    21.350    32.368     0.200
    23.990    29.937     0.200
    24.763    27.179     0.200
    24.763    28.695     0.200
    19.796    35.626     0.200
    23.309    33.594     0.200
    23.822    30.332     0.200
    24.950    28.130     0.200
    24.950    27.886     0.200
    24.950    28.011     0.200
    26.712    25.159     0.200
    29.246    18.241     0.200
    18.772    36.029     0.200
    23.130    31.936     0.200
    24.321    33.117     0.200
    24.911    29.109     0.200
    24.911    29.706     0.200
    17.040    35.918     0.200
    17.215    36.255     0.200
    18.444    34.592     0.200
    18.444    33.373     0.200
    18.444    34.139     0.200
    19.225    35.092     0.200
    19.542    35.202     0.200
    20.084    34.426     0.200
    20.084    36.293     0.200
    20.241    34.050     0.200
    20.661    34.271     0.200
    20.661    33.279     0.200
    21.965    31.377     0.200
    21.965    31.166     0.200
    22.781    29.461     0.200
    23.668    29.896     0.200
    23.668    30.197     0.200
    24.176    30.177     0.200
    24.176    29.247     0.200
    24.176    28.848     0.200
    24.176    29.454     0.200
    24.698    28.122     0.200
    24.916    26.037     0.200
    26.048    24.529     0.200
    26.108    25.222     0.200
    26.108    23.824     0.200
    27.595    21.777     0.200
    27.595    21.925     0.200
    24.571    27.762     0.200
    24.571    27.805     0.200
    24.571    28.930     0.200
    21.217    33.128     0.200
    23.818    30.027     0.200
    24.944    27.354     0.200
    24.944    26.900     0.200
    18.911    38.169     0.200
    24.476    32.176     0.200
    24.968    31.028     0.200
    18.423    36.062     0.200
    23.499    32.743     0.200
    23.882    30.833     0.200
    23.960    32.561     0.200
    23.960    32.243     0.200
    23.960    31.462     0.200
    24.109    31.275     0.200
    24.393    30.391     0.200
    24.571    29.991     0.200
    24.469    30.719     0.200
    24.469    29.832     0.200
    24.469    30.288     0.200
    25.084    29.022     0.200
    27.339    23.494     0.200
    19.655    35.735     0.200
    21.177    34.104     0.200
    21.177    33.623     0.200
    22.101    32.328     0.200
    23.664    31.583     0.200
    23.669    31.037     0.200
    23.669    32.030     0.200
    24.765    28.930     0.200
    24.765    28.329     0.200
    25.267    27.497     0.200
    25.267    27.634     0.200
    25.267    27.497     0.200
    25.517    28.859     0.200
    25.736    24.613     0.200
    25.822    27.291     0.200
    26.349    24.883     0.200
    27.602    24.378     0.200
    28.326    21.621     0.200
    28.444    21.439     0.200
    28.580    20.418     0.200
    16.978    38.275     0.200
    18.442    36.386     0.200
    18.442    35.816     0.200
    18.442    36.612     0.200
    20.521    36.386     0.200
    20.521    36.558     0.200
    20.487    35.968     0.200
    21.948    33.626     0.200
    24.077    33.712     0.200
    24.077    32.282     0.200
    24.077    32.610     0.200
    24.542    31.254     0.200
    24.542    30.364     0.200
    24.586    30.644     0.200
    24.586    30.910     0.200
    26.541    26.849     0.200
    26.541    26.552     0.200
    27.246    25.297     0.200
    27.246    25.625     0.200
    27.771    23.364     0.200
    27.836    22.072     0.200
    28.393    20.819     0.200
    14.610    40.863     0.200
    15.409    40.404     0.200
    15.703    39.260     0.200
    16.080    37.064     0.200
    16.187    37.195     0.200
    16.695    37.388     0.200
    18.298    33.908     0.200
    18.298    35.333     0.200
    24.494    28.218     0.200
    24.404    29.455     0.200
    24.404    29.700     0.200
    24.404    29.106     0.200
    14.200    36.526     0.200
    14.311    36.725     0.200
    16.478    36.715     0.200
    16.787    37.077     0.200
    18.297    34.184     0.200
    18.297    34.059     0.200
    18.297    34.324     0.200
    20.034    34.701     0.200
    20.186    35.966     0.200
    20.186    36.091     0.200
    20.469    34.789     0.200
    20.469    34.508     0.200
    21.812    31.363     0.200
    23.874    29.922     0.200
    23.874    30.422     0.200
    23.874    31.008     0.200
    23.874    29.727     0.200
    23.874    30.633     0.200
    24.380    29.113     0.200
    24.380    29.246     0.200
    24.380    28.465     0.200
    24.380    29.012     0.200
    24.503    28.368     0.200
    24.503    27.399     0.200
    25.068    25.798     0.200
    26.279    21.851     0.200
    26.279    24.757     0.200
    26.279    24.554     0.200
    26.279    25.812     0.200
    14.381    39.735     0.200
    14.897    36.539     0.200
    15.395    40.186     0.200
    15.532    36.616     0.200
    16.058    36.600     0.200
    16.711    36.657     0.200
    18.275    33.889     0.200
    18.275    34.357     0.200
    24.362    29.610     0.200
    24.362    28.352     0.200
    24.362    29.500     0.200
    14.169    41.973     0.200
    15.156    40.239     0.200
    15.259    41.864     0.200
    16.287    39.643     0.200
    17.020    37.447     0.200
    24.543    29.695     0.200
    24.434    30.294     0.200
    24.434    29.313     0.200
    18.273    34.965     0.200
    18.273    33.707     0.200
    19.010    34.909     0.200
    20.147    36.791     0.200
    20.147    36.021     0.200
    20.456    33.803     0.200
    21.789    32.678     0.200
    21.789    31.983     0.200
    23.852    30.251     0.200
    23.852    30.470     0.200
    24.359    29.443     0.200
    24.359    29.295     0.200
    24.359    28.916     0.200
    24.485    29.446     0.200
    24.491    27.997     0.200
    24.491    28.896     0.200
    25.034    26.764     0.200
    26.249    26.187     0.200
    27.385    21.620     0.200
    18.340    35.413     0.200
    18.340    34.949     0.200
    23.908    31.335     0.200
    24.524    28.978     0.200
    18.285    35.663     0.200
    18.285    35.530     0.200
    23.940    29.845     0.200
    24.468    30.201     0.200
    24.468    27.478     0.200
    24.447    28.676     0.200
    24.447    28.527     0.200
    24.447    28.656     0.200
    18.303    33.821     0.200
    21.816    31.924     0.200
    24.488    29.197     0.200
    24.432    28.944     0.200
    15.641    37.894     0.200
    15.663    38.748     0.200
    16.464    37.368     0.200
    16.832    36.777     0.200
    16.979    36.592     0.200
    18.265    34.805     0.200
    18.265    33.965     0.200
    18.265    34.402     0.200
    18.991    35.643     0.200
    20.167    33.927     0.200
    20.441    34.477     0.200
    20.441    34.317     0.200
    21.781    31.954     0.200
    21.781    31.243     0.200
    22.616    30.530     0.200
    22.616    29.932     0.200
    23.878    31.022     0.200
    23.878    29.921     0.200
    23.878    31.393     0.200
    23.878    29.222     0.200
    23.878    29.671     0.200
    24.385    29.116     0.200
    24.385    29.515     0.200
    24.385    29.190     0.200
    24.385    29.394     0.200
    24.469    28.688     0.200
    24.475    28.985     0.200
    25.058    26.311     0.200
    25.058    26.158     0.200
    25.845    27.145     0.200
    26.274    24.260     0.200
    26.274    24.370     0.200
    26.274    25.768     0.200
    26.274    21.870     0.200
    26.274    23.620     0.200
    26.265    24.176     0.200
    27.361    23.781     0.200
    27.361    23.883     0.200
    29.842    16.680     0.200
    17.539    39.523     0.200
    18.215    39.967     0.200
    18.327    36.290     0.200
    18.864    35.771     0.200
    18.864    36.048     0.200
    20.292    37.365     0.200
    20.292    36.634     0.200
    20.589    36.624     0.200
    22.383    33.026     0.200
    23.205    31.133     0.200
    23.205    31.329     0.200
    23.578    34.413     0.200
    23.578    33.210     0.200
    23.578    34.112     0.200
    24.091    32.131     0.200
    24.091    32.491     0.200
    24.091    32.530     0.200
    24.091    32.389     0.200
    25.066    29.917     0.200
    25.072    29.933     0.200
    25.013    28.371     0.200
    26.150    26.302     0.200
    27.804    24.298     0.200
    16.747    37.086     0.200
    17.215    36.879     0.200
    17.328    36.678     0.200
    18.317    35.218     0.200
    18.317    36.226     0.200
    24.394    29.821     0.200
    24.394    27.622     0.200
    24.394    30.243     0.200
    17.209    40.557     0.200
    18.811    37.550     0.200
    24.211    33.175     0.200
    24.211    33.284     0.200
    24.984    32.222     0.200
    18.091    38.444     0.200
    18.682    36.042     0.200
    19.513    36.815     0.200
    20.543    35.360     0.200
    20.931    35.483     0.200
    21.125    35.432     0.200
    22.012    33.706     0.200
    22.087    33.544     0.200
    22.910    32.891     0.200
    22.917    32.755     0.200
    23.509    33.091     0.200
    23.513    32.719     0.200
    23.513    32.520     0.200
    23.570    32.388     0.200
    24.618    31.414     0.200
    24.618    30.625     0.200
    25.050    28.641     0.200
    25.156    28.369     0.200
    25.078    28.957     0.200
    25.078    28.219     0.200
    25.078    28.355     0.200
    25.078    28.566     0.200
    25.581    26.687     0.200
    25.581    26.535     0.200
    25.581    27.285     0.200
    25.581    27.066     0.200
    25.796    26.862     0.200
    26.048    27.435     0.200
    26.047    25.153     0.200
    26.047    24.852     0.200
    26.142    28.436     0.200
    26.142    28.557     0.200
    27.346    22.187     0.200
    27.906    23.750     0.200
    28.265    20.388     0.200
    28.628    22.033     0.200
    14.270    41.294     0.200
    15.191    38.912     0.200
    25.439    27.251     0.200
    18.800    36.577     0.200
    24.124    31.835     0.200
    16.705    39.506     0.200
    20.230    36.448     0.200
    21.659    32.869     0.200
    24.253    30.249     0.200
    24.734    28.851     0.200
    17.413    38.269     0.200
    18.644    36.688     0.200
    20.512    36.786     0.200
    20.514    37.416     0.200
    20.729    36.209     0.200
    22.151    33.739     0.200
    23.962    33.674     0.200
    23.962    33.885     0.200
    24.474    32.307     0.200
    24.474    32.057     0.200
    24.749    31.188     0.200
    25.317    28.862     0.200
    26.077    29.197     0.200
    26.485    28.835     0.200
    26.485    27.235     0.200
    27.408    25.058     0.200
    15.259    38.682     0.200
    21.414    33.563     0.200
    15.184    39.431     0.200
    15.871    39.255     0.200
    16.186    38.933     0.200
    18.838    35.840     0.200
    18.838    36.544     0.200
    20.313    37.099     0.200
    23.181    33.526     0.200
    23.619    34.222     0.200
    23.619    33.019     0.200
    23.619    31.722     0.200
    23.619    33.730     0.200
    24.131    31.743     0.200
    24.131    31.431     0.200
    24.131    31.591     0.200
    25.036    29.857     0.200
    25.036    29.295     0.200
    25.043    28.295     0.200
    25.973    26.451     0.200
    26.184    26.382     0.200
    26.184    27.081     0.200
    26.184    26.112     0.200
    26.184    25.882     0.200
    29.670    16.901     0.200
    18.355    35.544     0.200
    22.998    32.068     0.200
    24.462    30.067     0.200
    24.462    30.200     0.200
    24.462    29.856     0.200
    15.081    38.820     0.200
    15.211    39.313     0.200
    15.617    37.712     0.200
    15.711    37.990     0.200
    16.225    38.169     0.200
    17.285    38.128     0.200
    21.341    32.444     0.200
    15.756    39.179     0.200
    18.362    36.600     0.200
    24.461    30.739     0.200
    26.744    22.659     0.200
    17.506    38.045     0.200
    18.703    34.098     0.200
    18.703    34.466     0.200
    19.809    35.423     0.200
    20.051    35.496     0.200
    20.053    34.378     0.200
    20.950    35.347     0.200
    22.229    30.711     0.200
    23.029    30.265     0.200
    23.451    31.515     0.200
    23.451    31.988     0.200
    23.451    32.219     0.200
    23.451    32.097     0.200
    23.961    29.467     0.200
    23.961    29.940     0.200
    23.961    30.065     0.200
    24.805    26.819     0.200
    24.805    26.717     0.200
    24.989    27.746     0.200
    24.989    27.973     0.200
    25.962    26.312     0.200
    25.962    23.613     0.200
    25.962    24.652     0.200
    25.962    25.613     0.200
    25.962    25.081     0.200
    27.859    21.207     0.200
    16.818    39.733     0.200
    17.358    39.029     0.200
    17.364    40.287     0.200
    17.843    39.088     0.200
    18.946    38.261     0.200
    18.946    37.898     0.200
    23.986    33.437     0.200
    24.502    32.832     0.200
    24.502    32.235     0.200
    18.312    33.908     0.200
    24.418    29.431     0.200
    24.418    28.657     0.200
    24.418    29.149     0.200
    16.361    37.576     0.200
    20.875    35.851     0.200
    20.876    35.625     0.200
    20.876    35.383     0.200
    21.169    34.421     0.200
    22.122    32.337     0.200
    22.652    34.682     0.200
    23.580    31.853     0.200
    23.580    32.790     0.200
    24.718    31.410     0.200
    24.994    28.570     0.200
    24.994    27.769     0.200
    24.994    28.789     0.200
    24.994    28.929     0.200
    25.289    28.055     0.200
    25.294    28.804     0.200
    25.498    27.544     0.200
    25.498    26.719     0.200
    25.498    26.997     0.200
    25.977    24.799     0.200
    26.184    25.782     0.200
    26.227    27.131     0.200
    27.271    23.000     0.200
    27.271    23.199     0.200
    27.271    22.461     0.200
    27.271    22.300     0.200
    27.271    22.859     0.200
    27.392    20.489     0.200
    27.504    22.262     0.200
    17.805    38.569     0.200
    16.708    38.439     0.200
    16.993    36.893     0.200
    17.172    36.337     0.200
    18.273    33.932     0.200
    24.487    28.666     0.200
    24.369    28.735     0.200
    14.056    40.926     0.200
    14.607    39.615     0.200
    15.651    39.040     0.200
    15.729    39.502     0.200
    17.341    38.197     0.200
    19.846    35.069     0.200
    15.704    39.765     0.200
    17.226    39.714     0.200
    17.327    39.865     0.200
    17.807    38.989     0.200
    18.794    37.906     0.200
    24.975    31.397     0.200
    18.260    34.263     0.200
    24.347    29.229     0.200
    24.347    29.055     0.200
    24.347    29.700     0.200
    24.485    28.453     0.200
    16.440    36.917     0.200
    18.354    34.517     0.200
    18.354    34.847     0.200
    20.501    34.587     0.200
    24.531    29.151     0.200
    24.425    29.762     0.200
    24.425    30.037     0.200
    14.279    41.478     0.200
    14.478    41.617     0.200
    18.381    35.900     0.200
    18.934    37.151     0.200
    18.934    36.607     0.200
    22.437    34.165     0.200
    24.509    31.971     0.200
    24.509    31.689     0.200
    24.509    31.500     0.200
    24.975    30.985     0.200
    24.975    30.350     0.200
    24.493    29.306     0.200
    24.493    28.059     0.200
    24.403    28.840     0.200
    24.403    28.270     0.200
    24.403    27.930     0.200
    24.718    28.969     0.200
    24.718    31.074     0.200
    24.718    29.430     0.200
    28.284    20.974     0.200
    16.996    36.887     0.200
    18.298    34.598     0.200
    20.196    36.366     0.200
    20.196    36.061     0.200
    21.813    31.250     0.200
    23.884    30.827     0.200
    23.884    30.429     0.200
    23.884    30.320     0.200
    23.884    30.991     0.200
    24.391    30.018     0.200
    24.391    29.119     0.200
    24.499    29.024     0.200
    24.499    28.508     0.200
    25.079    26.387     0.200
    25.843    27.566     0.200
    25.843    25.553     0.200
    26.268    24.008     0.200
    26.290    24.651     0.200
    26.290    26.151     0.200
    26.290    24.456     0.200
    26.290    25.245     0.200
    27.366    22.938     0.200
    14.177    42.333     0.200
    14.318    40.654     0.200
    14.759    42.192     0.200
    15.435    41.586     0.200
    15.566    41.925     0.200
    15.742    40.341     0.200
    15.870    41.371     0.200
    16.896    39.541     0.200
    16.950    40.165     0.200
    18.496    36.379     0.200
    19.796    37.196     0.200
    24.590    29.930     0.200
    24.646    30.728     0.200
    24.577    31.517     0.200
    24.577    31.142     0.200
    24.577    31.387     0.200
    18.532    34.114     0.200
    18.532    35.368     0.200
    24.090    29.035     0.200
    24.090    30.774     0.200
    24.802    28.305     0.200
    14.100    41.027     0.200
    15.075    39.211     0.200
    15.205    39.258     0.200
    15.610    37.759     0.200
    15.705    38.398     0.200
    16.219    37.752     0.200
    21.334    32.335     0.200
    23.962    29.851     0.200
    23.962    29.161     0.200
    18.877    38.461     0.200
    24.271    34.325     0.200
    18.574    37.908     0.200
    19.483    38.598     0.200
    20.061    37.730     0.200
    23.197    35.152     0.200
    23.673    34.141     0.200
    24.300    31.679     0.200
    24.300    31.458     0.200
    24.300    31.708     0.200
    24.752    30.328     0.200
    24.757    30.202     0.200
    24.757    30.473     0.200
    26.563    25.928     0.200
    26.897    26.519     0.200
    27.492    24.372     0.200
    28.060    21.459     0.200
    16.497    40.173     0.200
    18.139    37.861     0.200
    21.628    34.469     0.200
    25.072    28.187     0.200
    25.072    29.503     0.200
    25.072    28.308     0.200
    15.947    42.762     0.200
    16.241    41.242     0.200
    24.193    33.464     0.200
    24.193    32.993     0.200
    24.193    33.894     0.200
    25.011    30.778     0.200
    26.729    28.469     0.200
    21.755    34.214     0.200
    23.146    34.185     0.200
    24.309    30.441     0.200
    24.801    29.876     0.200
    24.801    29.956     0.200
    24.801    30.417     0.200
    16.149    39.963     0.200
    16.149    39.672     0.200
    18.992    37.963     0.200
    20.251    36.323     0.200
    20.443    36.770     0.200
    20.443    36.889     0.200
    21.681    34.459     0.200
    22.555    32.543     0.200
    22.904    32.744     0.200
    23.461    32.453     0.200
    23.592    31.779     0.200
    23.799    31.359     0.200
    24.162    30.663     0.200
    24.219    32.813     0.200
    24.219    29.613     0.200
    24.219    31.703     0.200
    24.219    31.813     0.200
    24.219    32.672     0.200
    24.269    30.976     0.200
    24.274    31.442     0.200
    24.274    30.856     0.200
    24.331    30.735     0.200
    24.725    30.102     0.200
    24.725    29.579     0.200
    24.725    29.364     0.200
    25.160    29.019     0.200
    25.378    27.985     0.200
    26.030    26.285     0.200
    26.084    25.674     0.200
    26.606    26.248     0.200
    26.606    24.146     0.200
    26.606    25.087     0.200
    26.606    25.248     0.200
    26.606    27.357     0.200
    26.602    24.594     0.200
    27.043    25.376     0.200
    27.650    22.459     0.200
    29.115    18.323     0.200
    29.506    19.257     0.200
    29.857    15.389     0.200
    18.961    36.665     0.200
    20.711    36.135     0.200
    20.712    35.859     0.200
    20.712    36.218     0.200
    22.788    32.079     0.200
    23.522    35.102     0.200
    24.403    29.664     0.200
    24.403    30.430     0.200
    24.341    30.813     0.200
    24.341    30.407     0.200
    24.341    30.610     0.200
    24.341    30.227     0.200
    24.341    30.509     0.200
    24.341    32.048     0.200
    24.843    30.072     0.200
    24.851    29.264     0.200
    24.851    29.311     0.200
    25.409    30.466     0.200
    25.603    25.785     0.200
    26.574    26.986     0.200
    26.708    24.092     0.200
    26.805    24.563     0.200
    26.805    22.961     0.200
    26.805    23.633     0.200
    26.805    24.758     0.200
    27.005    25.371     0.200
    27.005    25.543     0.200
    28.730    20.845     0.200
    29.293    18.326     0.200
    29.293    20.669     0.200
    29.293    18.990     0.200
    29.592    17.783     0.200
    29.874    18.320     0.200
    17.388    38.158     0.200
    18.492    36.113     0.200
    20.827    37.217     0.200
    20.827    36.663     0.200
    21.984    34.601     0.200
    22.891    33.184     0.200
    24.462    31.415     0.200
    24.462    30.689     0.200
    24.392    31.919     0.200
    24.392    32.083     0.200
    24.903    30.253     0.200
    24.903    29.549     0.200
    26.888    24.683     0.200
    18.570    38.161     0.200
    18.570    37.716     0.200
    20.866    37.394     0.200
    24.378    33.503     0.200
    24.531    33.489     0.200
    24.588    31.946     0.200
    24.890    32.318     0.200
    24.890    31.654     0.200
    24.890    31.888     0.200
    26.898    27.093     0.200
    27.031    26.617     0.200
    14.342    43.740     0.200
    14.770    40.802     0.200
    14.777    41.283     0.200
    15.614    39.506     0.200
    15.855    41.161     0.200
    16.152    37.697     0.200
    16.381    39.870     0.200
    16.846    38.141     0.200
    17.420    39.300     0.200
    18.523    36.989     0.200
    22.014    34.438     0.200
    22.924    33.490     0.200
    24.485    31.098     0.200
    24.911    29.558     0.200
    24.911    29.417     0.200
    24.911    29.909     0.200
    15.945    40.745     0.200
    16.396    39.765     0.200
    16.473    40.401     0.200
    16.480    38.948     0.200
    16.974    39.674     0.200
    16.996    39.469     0.200
    22.107    34.538     0.200
    24.904    29.319     0.200
    24.904    30.030     0.200
    24.904    29.319     0.200
    16.914    39.084     0.200
    18.595    36.920     0.200
    18.595    37.193     0.200
    18.595    37.568     0.200
    20.530    37.006     0.200
    20.931    36.846     0.200
    20.932    36.413     0.200
    22.083    34.895     0.200
    22.999    34.339     0.200
    24.429    31.910     0.200
    24.429    31.308     0.200
    24.429    31.113     0.200
    24.429    30.808     0.200
    24.429    31.519     0.200
    24.528    30.332     0.200
    24.532    30.983     0.200
    24.532    30.710     0.200
    24.589    30.527     0.200
    24.942    29.727     0.200
    24.942    29.930     0.200
    24.942    29.329     0.200
    25.782    26.522     0.200
    25.782    26.421     0.200
    26.960    24.544     0.200
    26.960    25.177     0.200
    26.960    24.380     0.200
    26.960    24.935     0.200
    26.996    25.653     0.200
    28.909    20.490     0.200
    14.764    42.683     0.200
    15.751    41.259     0.200
    15.851    41.141     0.200
    16.295    40.005     0.200
    16.414    39.465     0.200
    16.375    41.031     0.200
    17.413    40.161     0.200
    22.008    35.617     0.200
    24.892    28.503     0.200
    24.892    30.995     0.200
    14.048    40.179     0.200
    14.323    39.861     0.200
    16.244    40.101     0.200
    16.326    39.916     0.200
    16.835    40.537     0.200
    16.847    39.977     0.200
    17.361    40.132     0.200
    18.464    35.684     0.200
    21.959    34.651     0.200
    24.839    30.812     0.200
    24.839    30.695     0.200
    18.668    37.978     0.200
    19.090    37.806     0.200
    20.860    37.033     0.200
    20.862    37.061     0.200
    20.862    36.014     0.200
    22.161    33.824     0.200
    24.304    31.981     0.200
    24.304    31.145     0.200
    24.304    32.082     0.200
    24.304    32.441     0.200
    24.640    30.163     0.200
    24.817    30.402     0.200
    24.817    30.824     0.200
    24.817    29.699     0.200
    25.684    27.101     0.200
    25.684    26.874     0.200
    26.852    24.400     0.200
    26.852    25.353     0.200
    26.852    26.056     0.200
    26.852    28.017     0.200
    27.127    25.016     0.200
    14.852    43.663     0.200
    15.689    39.719     0.200
    16.457    41.225     0.200
    16.908    39.527     0.200
    16.979    40.681     0.200
    17.496    38.973     0.200
    22.090    34.371     0.200
    24.554    31.504     0.200
    24.554    31.027     0.200
    24.611    31.235     0.200
    24.893    30.520     0.200
    24.893    30.614     0.200
    24.893    30.872     0.200
    28.951    20.443     0.200
    15.712    37.467     0.200
    15.815    38.191     0.200
    18.476    35.059     0.200
    18.476    35.777     0.200
    21.969    34.416     0.200
    22.872    32.190     0.200
    24.459    31.734     0.200
    24.866    29.787     0.200
    24.866    29.592     0.200
    24.866    28.975     0.200
    27.020    25.047     0.200
    28.930    19.521     0.200
    18.709    37.825     0.200
    18.709    36.356     0.200
    18.709    36.473     0.200
    19.063    38.391     0.200
    19.063    38.625     0.200
    20.803    36.827     0.200
    20.937    37.084     0.200
    20.938    36.455     0.200
    20.938    35.776     0.200
    21.472    36.823     0.200
    22.199    33.484     0.200
    22.729    35.496     0.200
    23.271    36.227     0.200
    24.355    33.179     0.200
    24.355    32.374     0.200
    24.355    31.468     0.200
    24.355    31.780     0.200
    24.355    32.788     0.200
    24.654    30.244     0.200
    24.869    32.686     0.200
    24.869    30.881     0.200
    24.869    29.983     0.200
    25.431    31.124     0.200
    25.431    30.492     0.200
    25.755    27.641     0.200
    26.099    27.326     0.200
    26.415    28.880     0.200
    26.651    27.136     0.200
    26.701    25.905     0.200
    26.918    27.071     0.200
    26.918    27.970     0.200
    26.918    26.103     0.200
    26.918    24.571     0.200
    26.918    24.829     0.200
    27.097    25.095     0.200
    14.157    41.165     0.200
    14.432    40.364     0.200
    15.785    39.544     0.200
    15.885    39.631     0.200
    16.409    40.418     0.200
    16.913    40.305     0.200
    16.931    39.936     0.200
    17.447    40.235     0.200
    22.043    33.965     0.200
    24.882    31.818     0.200
    24.882    30.662     0.200
    14.305    41.163     0.200
    15.215    40.075     0.200
    15.954    41.158     0.200
    16.578    40.197     0.200
    17.025    38.594     0.200
    17.616    38.686     0.200
    18.720    37.516     0.200
    18.720    37.617     0.200
    22.212    35.158     0.200
    24.677    31.144     0.200
    24.677    30.761     0.200
    18.646    37.774     0.200
    22.134    34.231     0.200
    24.577    31.712     0.200
    24.577    31.517     0.200
    24.936    31.454     0.200
    24.936    30.564     0.200
    27.019    25.853     0.200
    27.873    25.189     0.200
    18.375    36.657     0.200
    18.375    37.048     0.200
    21.870    34.524     0.200
    24.379    32.188     0.200
    24.379    30.961     0.200
    24.869    29.870     0.200
    24.869    30.245     0.200
    24.869    30.792     0.200
    25.916    28.057     0.200
    14.156    41.034     0.200
    14.342    39.446     0.200
    14.401    39.658     0.200
    14.433    40.345     0.200
    15.233    39.314     0.200
    15.323    41.473     0.200
    15.647    39.667     0.200
    15.818    41.236     0.200
    16.963    39.999     0.200
    16.949    38.959     0.200
    16.970    38.552     0.200
    24.816    30.167     0.200
    18.465    37.366     0.200
    18.465    38.186     0.200
    21.957    34.666     0.200
    23.146    36.597     0.200
    24.437    31.444     0.200
    24.437    31.092     0.200
    24.911    30.067     0.200
    25.695    26.495     0.200
    26.978    26.340     0.200
    26.978    25.176     0.200
    27.007    24.757     0.200
    28.888    21.303     0.200
    29.564    18.656     0.200
    18.663    37.220     0.200
    22.152    34.710     0.200
    23.065    32.198     0.200
    24.599    31.015     0.200
    24.603    30.526     0.200
    24.603    31.120     0.200
    24.903    30.175     0.200
    24.903    29.714     0.200
    24.903    31.105     0.200
    25.771    27.087     0.200
    27.052    25.482     0.200
    27.052    25.771     0.200
    27.906    24.335     0.200
    28.966    20.537     0.200
    18.522    36.594     0.200
    18.522    37.203     0.200
    22.013    35.288     0.200
    24.488    30.668     0.200
    24.488    28.512     0.200
    24.901    28.494     0.200
    24.901    29.228     0.200
    27.005    25.378     0.200
    18.406    37.392     0.200
    21.898    35.004     0.200
    24.387    31.961     0.200
    24.914    30.161     0.200
    24.914    30.318     0.200
    24.914    30.857     0.200
    25.673    26.710     0.200
    18.696    38.229     0.200
    18.696    38.346     0.200
    22.187    35.000     0.200
    23.096    33.704     0.200
    24.646    30.892     0.200
    24.646    30.704     0.200
    24.863    31.594     0.200
    24.863    30.265     0.200
    24.863    31.015     0.200
    27.098    26.032     0.200
    14.457    40.330     0.200
    15.149    40.599     0.200
    18.494    35.961     0.200
    18.494    38.055     0.200
    21.985    34.868     0.200
    22.892    33.319     0.200
    24.462    29.585     0.200
    24.466    31.389     0.200
    24.466    30.499     0.200
    24.897    30.305     0.200
    15.733    39.103     0.200
    16.190    39.044     0.200
    16.284    39.261     0.200
    16.788    39.837     0.200
    16.897    39.050     0.200
    18.561    36.605     0.200
    18.561    38.035     0.200
    20.873    36.879     0.200
    20.875    36.392     0.200
    22.051    35.354     0.200
    22.961    32.752     0.200
    23.186    35.756     0.200
    23.507    35.631     0.200
    24.393    32.223     0.200
    24.393    33.340     0.200
    24.393    30.098     0.200
    24.514    31.138     0.200
    24.518    31.178     0.200
    24.518    30.319     0.200
    24.905    30.015     0.200
    24.905    30.414     0.200
    25.446    31.255     0.200
    26.288    28.906     0.200
    26.353    28.489     0.200
    26.573    27.546     0.200
    26.789    27.450     0.200
    27.015    27.442     0.200
    27.312    26.032     0.200
    27.577    24.155     0.200
    27.893    25.168     0.200
    28.927    21.175     0.200
    29.349    20.542     0.200
    29.601    19.654     0.200
    14.070    41.756     0.200
    14.702    42.358     0.200
    14.800    39.614     0.200
    15.689    41.341     0.200
    15.790    41.963     0.200
    16.233    40.692     0.200
    16.313    40.284     0.200
    16.835    39.976     0.200
    17.350    40.137     0.200
    18.452    36.843     0.200
    18.452    37.113     0.200
    20.826    35.745     0.200
    21.943    33.394     0.200
    22.852    32.481     0.200
    23.124    34.461     0.200
    23.460    34.554     0.200
    24.415    30.551     0.200
    24.419    30.938     0.200
    24.419    29.853     0.200
    24.421    30.288     0.200
    24.421    30.158     0.200
    24.421    30.448     0.200
    24.931    28.704     0.200
    24.931    28.249     0.200
    25.394    28.846     0.200
    26.728    25.712     0.200
    26.738    24.000     0.200
    26.956    25.703     0.200
    26.985    24.017     0.200
    28.866    19.508     0.200
    16.763    39.147     0.200
    16.782    39.347     0.200
    17.285    39.590     0.200
    18.389    37.542     0.200
    21.883    34.740     0.200
    22.783    33.194     0.200
    24.392    32.025     0.200
    24.866    29.854     0.200
    16.833    38.861     0.200
    18.507    37.275     0.200
    24.470    31.377     0.200
    24.915    29.970     0.200
    16.836    38.779     0.200
    18.573    36.975     0.200
    18.573    37.625     0.200
    20.496    35.890     0.200
    20.962    36.654     0.200
    20.964    35.935     0.200
    22.060    34.864     0.200
    22.980    32.824     0.200
    23.120    32.059     0.200
    24.496    31.481     0.200
    24.496    30.656     0.200
    24.477    30.225     0.200
    24.477    31.825     0.200
    24.477    31.435     0.200
    24.990    29.497     0.200
    25.954    27.230     0.200
    26.948    25.153     0.200
    26.948    26.163     0.200
    15.230    41.422     0.200
    16.433    38.962     0.200
    16.894    38.707     0.200
    17.084    38.286     0.200
    18.564    37.531     0.200
    18.564    37.211     0.200
    20.890    36.993     0.200
    20.892    36.164     0.200
    20.892    35.235     0.200
    22.054    34.434     0.200
    22.965    32.563     0.200
    23.174    34.438     0.200
    23.494    35.960     0.200
    24.409    31.721     0.200
    24.409    32.131     0.200
    24.409    31.821     0.200
    24.511    30.811     0.200
    24.515    30.935     0.200
    24.515    31.425     0.200
    24.921    31.046     0.200
    24.921    30.171     0.200
    25.747    26.702     0.200
    26.012    27.785     0.200
    26.340    26.482     0.200
    26.560    26.527     0.200
    26.928    26.015     0.200
    27.003    24.844     0.200
    27.003    26.964     0.200
    27.053    24.456     0.200
    29.589    17.986     0.200
    15.733    38.824     0.200
    15.877    42.246     0.200
    16.161    42.813     0.200
    16.426    41.413     0.200
    16.443    38.638     0.200
    16.498    41.831     0.200
    16.767    40.189     0.200
    16.869    39.028     0.200
    18.648    37.536     0.200
    22.132    33.584     0.200
    23.059    33.671     0.200
    24.546    31.587     0.200
    24.546    31.292     0.200
    24.508    31.705     0.200
    25.022    31.205     0.200
    26.947    26.199     0.200
    28.646    21.952     0.200
    14.935    41.555     0.200
    15.214    39.864     0.200
    15.923    41.012     0.200
    16.015    41.793     0.200
    16.546    40.859     0.200
    16.953    38.921     0.200
    17.588    40.408     0.200
    18.692    38.164     0.200
    14.859    38.070     0.200
    18.464    36.379     0.200
    18.464    35.894     0.200
    18.464    36.924     0.200
    20.839    36.194     0.200
    20.841    34.736     0.200
    21.955    33.300     0.200
    22.865    32.944     0.200
    24.426    30.547     0.200
    24.426    30.682     0.200
    24.426    29.769     0.200
    24.426    31.129     0.200
    24.426    31.389     0.200
    24.937    29.718     0.200
    24.937    28.868     0.200
    24.937    29.538     0.200
    26.955    23.778     0.200
    26.955    25.758     0.200
    26.988    24.165     0.200
    15.424    41.073     0.200
    16.923    38.820     0.200
    18.699    37.944     0.200
    18.699    37.719     0.200
    24.601    31.995     0.200
    24.601    30.955     0.200
    16.792    37.805     0.200
    18.525    36.382     0.200
    18.525    37.127     0.200
    20.448    35.862     0.200
    20.948    35.882     0.200
    22.011    33.908     0.200
    22.932    33.300     0.200
    24.449    30.276     0.200
    24.449    30.562     0.200
    24.497    30.273     0.200
    25.008    28.171     0.200
    25.008    27.916     0.200
    25.344    28.553     0.200
    26.915    25.959     0.200
    18.629    37.529     0.200
    18.629    36.254     0.200
    22.122    33.063     0.200
    24.602    31.148     0.200
    24.832    30.942     0.200
    16.895    39.787     0.200
    18.603    37.198     0.200
    18.603    36.693     0.200
    24.547    30.952     0.200
    24.547    30.412     0.200
    24.921    30.092     0.200
    24.921    29.852     0.200
    16.851    39.285     0.200
    18.474    36.977     0.200
    20.757    36.946     0.200
    21.968    34.757     0.200
    22.868    33.120     0.200
    24.466    31.050     0.200
    24.470    30.763     0.200
    24.470    30.550     0.200
    24.843    29.853     0.200
    24.843    29.667     0.200
    24.843    30.073     0.200
    25.629    26.328     0.200
    27.038    24.362     0.200
    27.038    26.851     0.200
    16.896    38.230     0.200
    18.627    37.352     0.200
    18.627    37.152     0.200
    22.115    34.668     0.200
    24.556    30.859     0.200
    24.556    29.238     0.200
    24.948    29.038     0.200
    24.948    29.708     0.200
    16.322    39.871     0.200
    18.462    36.701     0.200
    18.462    39.107     0.200
    24.862    30.853     0.200
    24.862    31.699     0.200
    16.779    38.840     0.200
    17.291    38.034     0.200
    18.395    36.141     0.200
    18.395    35.285     0.200
    21.889    33.670     0.200
    24.392    31.544     0.200
    24.392    29.549     0.200
    24.877    30.451     0.200
    24.877    29.939     0.200
    16.795    38.208     0.200
    18.418    35.137     0.200
    18.418    36.622     0.200
    24.877    30.132     0.200
    24.877    29.571     0.200
    28.764    19.483     0.200
    16.905    40.173     0.200
    18.649    35.920     0.200
    18.649    36.710     0.200
    24.571    31.516     0.200
    24.571    29.236     0.200
    24.958    30.600     0.200
    24.958    29.949     0.200
    18.585    38.294     0.200
    18.585    38.464     0.200
    18.899    38.203     0.200
    20.990    37.787     0.200
    20.991    37.508     0.200
    20.991    37.209     0.200
    24.498    32.489     0.200
    24.498    31.889     0.200
    24.498    32.988     0.200
    24.498    32.088     0.200
    24.498    31.677     0.200
    25.010    30.207     0.200
    25.010    30.856     0.200
    25.010    29.856     0.200
    25.280    30.762     0.200
    25.280    32.273     0.200
    25.848    27.927     0.200
    26.849    25.052     0.200
    26.934    26.231     0.200
    27.028    26.760     0.200
    27.028    26.559     0.200
    27.028    25.880     0.200
    27.028    27.059     0.200
    27.028    25.180     0.200
    18.676    36.758     0.200
    24.628    31.128     0.200
    24.866    30.894     0.200
    16.971    38.497     0.200
    18.644    36.887     0.200
    24.590    30.405     0.200
    24.897    30.430     0.200
    18.624    37.242     0.200
    23.028    31.816     0.200
    24.560    31.215     0.200
    24.560    29.850     0.200
    24.931    30.486     0.200
    24.931    30.324     0.200
    18.536    35.806     0.200
    18.536    36.749     0.200
    22.027    34.858     0.200
    24.500    30.873     0.200
    24.500    29.962     0.200
    25.061    29.174     0.200
    24.897    29.838     0.200
    24.897    29.949     0.200
    18.703    37.736     0.200
    18.703    37.615     0.200
    19.532    36.162     0.200
    22.190    35.224     0.200
    23.109    33.492     0.200
    24.615    31.071     0.200
    24.618    31.825     0.200
    24.618    31.158     0.200
    24.675    29.320     0.200
    24.949    30.719     0.200
    24.949    30.866     0.200
    27.027    26.980     0.200
    18.672    37.386     0.200
    18.672    37.761     0.200
    22.160    35.455     0.200
    23.076    33.422     0.200
    24.600    31.603     0.200
    24.600    31.109     0.200
    24.657    29.668     0.200
    18.568    36.691     0.200
    18.568    36.961     0.200
    24.527    30.510     0.200
    24.531    31.678     0.200
    24.531    30.692     0.200
    24.375    31.993     0.200
    24.887    30.779     0.200
    24.887    29.549     0.200
    24.887    30.889     0.200
    25.760    26.506     0.200
    26.892    24.119     0.200
    16.866    39.834     0.200
    18.565    37.274     0.200
    22.055    34.400     0.200
    22.967    33.321     0.200
    24.513    30.991     0.200
    24.513    30.161     0.200
    24.570    29.501     0.200
    24.927    29.321     0.200
    24.927    30.856     0.200
    24.927    29.321     0.200
    17.047    37.962     0.200
    17.468    38.669     0.200
    17.565    38.645     0.200
    17.641    37.686     0.200
    18.669    36.752     0.200
    18.669    37.223     0.200
    18.575    37.669     0.200
    18.575    38.220     0.200
    20.526    36.141     0.200
    20.881    36.614     0.200
    20.883    36.096     0.200
    22.065    34.926     0.200
    22.976    31.794     0.200
    23.775    32.539     0.200
    24.392    30.837     0.200
    24.530    31.047     0.200
    24.530    30.403     0.200
    24.904    29.036     0.200
    26.030    26.515     0.200
    26.914    24.800     0.200
    27.021    26.304     0.200
    16.966    38.681     0.200
    18.645    36.708     0.200
    22.137    34.706     0.200
    23.043    32.758     0.200
    24.610    30.698     0.200
    24.846    29.945     0.200
    27.094    23.805     0.200
    16.838    40.992     0.200
    24.877    30.253     0.200
    14.804    38.612     0.200
    16.778    38.735     0.200
    18.415    36.882     0.200
    18.415    37.158     0.200
    20.391    37.332     0.200
    20.774    36.943     0.200
    20.776    37.614     0.200
    20.776    36.233     0.200
    21.908    34.959     0.200
    22.620    35.075     0.200
    22.813    32.379     0.200
    23.479    35.509     0.200
    24.400    30.995     0.200
    24.400    31.251     0.200
    24.902    29.553     0.200
    24.902    31.073     0.200
    24.902    29.553     0.200
    25.665    27.454     0.200
    26.865    25.952     0.200
    26.968    26.015     0.200
    29.364    19.951     0.200
    16.773    37.985     0.200
    18.362    36.139     0.200
    18.362    37.289     0.200
    20.688    36.458     0.200
    20.689    36.479     0.200
    20.689    36.170     0.200
    21.858    34.287     0.200
    22.754    32.123     0.200
    24.376    30.455     0.200
    24.341    32.167     0.200
    24.341    31.766     0.200
    24.341    31.616     0.200
    24.850    29.423     0.200
    24.850    29.525     0.200
    25.588    26.414     0.200
    26.710    23.422     0.200
    26.794    25.638     0.200
    26.794    23.538     0.200
    26.794    25.118     0.200
    26.794    24.638     0.200
    26.794    26.798     0.200
    26.995    25.843     0.200
    29.408    20.187     0.200
    29.582    17.632     0.200
    16.838    40.377     0.200
    18.504    36.144     0.200
    24.902    30.138     0.200
    16.861    39.714     0.200
    18.565    36.405     0.200
    24.510    28.445     0.200
    24.935    30.170     0.200
    24.935    29.479     0.200
    18.652    36.134     0.200
    24.592    30.361     0.200
    24.908    31.069     0.200
    16.951    40.784     0.200
    18.707    38.512     0.200
    24.622    32.763     0.200
    24.622    31.306     0.200
    24.948    32.606     0.200
    24.948    32.805     0.200
    17.180    38.688     0.200
    18.538    37.621     0.200
    18.538    37.797     0.200
    20.811    36.584     0.200
    20.813    36.706     0.200
    20.813    36.429     0.200
    22.031    34.783     0.200
    22.935    32.845     0.200
    23.218    32.272     0.200
    24.344    33.091     0.200
    24.344    31.091     0.200
    24.344    31.560     0.200
    24.344    31.392     0.200
    24.344    30.060     0.200
    24.518    31.687     0.200
    24.856    30.424     0.200
    24.856    29.947     0.200
    25.421    28.524     0.200
    25.669    27.228     0.200
    26.853    26.013     0.200
    26.853    26.114     0.200
    26.853    24.934     0.200
    27.049    25.847     0.200
    29.425    19.421     0.200
    18.557    36.015     0.200
    18.557    37.015     0.200
    24.505    29.940     0.200
    24.932    29.271     0.200
    14.575    40.405     0.200
    14.846    39.903     0.200
    15.191    40.095     0.200
    15.343    40.194     0.200
    15.692    38.691     0.200
    15.797    37.791     0.200
    16.506    38.546     0.200
    16.935    38.214     0.200
    16.982    38.550     0.200
    17.064    39.195     0.200
    18.669    35.330     0.200
    18.669    37.435     0.200
    20.970    36.200     0.200
    24.598    30.978     0.200
    24.598    31.423     0.200
    24.416    31.232     0.200
    24.929    30.629     0.200
    24.929    30.106     0.200
    24.929    30.469     0.200
    14.293    40.798     0.200
    14.567    40.538     0.200
    14.838    40.321     0.200
    15.183    40.596     0.200
    15.894    40.602     0.200
    18.662    37.054     0.200
    18.662    37.554     0.200
    24.927    30.528     0.200
    24.927    30.329     0.200
    24.927    30.141     0.200
    15.869    41.254     0.200
    16.394    40.679     0.200
    18.589    37.393     0.200
    24.908    28.841     0.200
    24.908    31.318     0.200
    24.908    29.435     0.200
    24.963    26.350     0.200
    24.963    26.710     0.200
    24.927    26.440     0.200
    16.885    38.796     0.200
    18.522    35.243     0.200
    22.919    32.421     0.200
    24.881    29.499     0.200
    24.881    29.632     0.200
    24.881    29.257     0.200
    14.812    41.311     0.200
    16.943    38.116     0.200
    18.437    37.067     0.200
    18.437    36.458     0.200
    20.691    36.376     0.200
    20.693    35.490     0.200
    21.447    36.033     0.200
    21.934    33.723     0.200
    22.715    35.825     0.200
    23.226    33.545     0.200
    23.575    33.111     0.200
    23.822    32.577     0.200
    24.292    31.355     0.200
    24.292    30.902     0.200
    24.456    30.664     0.200
    24.456    31.039     0.200
    24.802    29.623     0.200
    24.802    29.341     0.200
    25.507    28.776     0.200
    25.824    27.010     0.200
    26.083    26.711     0.200
    26.623    25.320     0.200
    26.630    25.316     0.200
    26.766    25.027     0.200
    27.061    24.842     0.200
    27.061    26.506     0.200
    27.068    23.738     0.200
    27.639    23.629     0.200
    28.199    22.462     0.200
    14.946    38.683     0.200
    15.527    39.513     0.200
    15.697    39.508     0.200
    16.323    40.975     0.200
    16.402    39.748     0.200
    16.843    39.420     0.200
    17.357    39.530     0.200
    18.461    37.792     0.200
    21.955    34.266     0.200
    24.838    28.840     0.200
    24.838    32.051     0.200
    14.489    43.213     0.200
    15.200    38.931     0.200
    15.353    41.100     0.200
    16.449    40.467     0.200
    16.523    40.735     0.200
    16.973    38.626     0.200
    17.019    40.687     0.200
    17.047    39.792     0.200
    17.566    38.997     0.200
    18.670    37.261     0.200
    24.588    31.534     0.200
    24.958    31.162     0.200
    15.727    41.157     0.200
    16.165    38.467     0.200
    16.247    40.396     0.200
    16.757    38.161     0.200
    16.768    38.815     0.200
    17.282    39.311     0.200
    17.366    38.227     0.200
    20.729    36.028     0.200
    21.880    34.889     0.200
    24.874    30.163     0.200
    24.874    29.881     0.200
    24.874    29.475     0.200
    15.005    40.085     0.200
    15.730    40.388     0.200
    15.829    41.523     0.200
    16.275    40.189     0.200
    16.354    40.268     0.200
    17.392    39.290     0.200
    18.496    37.360     0.200
    21.988    34.395     0.200
    14.337    40.159     0.200
    14.445    40.679     0.200
    14.808    41.641     0.200
    14.905    40.333     0.200
    15.066    40.283     0.200
    15.297    41.805     0.200
    15.577    42.986     0.200
    15.647    39.606     0.200
    15.795    40.872     0.200
    15.893    41.330     0.200
    16.340    40.343     0.200
    16.419    41.192     0.200
    16.943    39.355     0.200
    16.941    40.317     0.200
    17.457    39.213     0.200
    18.561    36.802     0.200
    18.990    37.483     0.200
    22.052    35.759     0.200
    24.524    31.783     0.200
    24.890    31.651     0.200
    28.940    20.124     0.200
    14.419    42.799     0.200
    14.798    42.248     0.200
    15.685    39.717     0.200
    15.833    40.479     0.200
    15.932    40.492     0.200
    16.378    39.260     0.200
    16.457    40.570     0.200
    16.480    38.231     0.200
    16.979    40.155     0.200
    17.496    39.740     0.200
    17.576    38.595     0.200
    18.600    37.389     0.200
    24.559    30.662     0.200
    24.880    30.096     0.200
    24.880    30.646     0.200
    18.606    37.792     0.200
    18.606    37.419     0.200
    20.990    37.354     0.200
    20.991    37.475     0.200
    20.991    35.575     0.200
    21.330    35.821     0.200
    22.588    35.198     0.200
    23.014    34.065     0.200
    23.128    34.947     0.200
    23.705    34.595     0.200
    24.483    31.930     0.200
    24.483    31.510     0.200
    24.521    31.511     0.200
    24.640    31.952     0.200
    24.995    30.547     0.200
    24.995    29.987     0.200
    24.995    29.829     0.200
    24.995    29.947     0.200
    25.377    29.648     0.200
    25.842    26.654     0.200
    25.842    27.565     0.200
    25.958    28.257     0.200
    26.658    26.493     0.200
    26.955    25.883     0.200
    26.955    27.333     0.200
    27.024    23.969     0.200
    27.019    24.042     0.200
    27.019    24.732     0.200
    28.366    21.766     0.200
    28.868    21.127     0.200
    29.302    21.306     0.200
    29.958    17.941     0.200
    18.461    38.211     0.200
    24.998    29.387     0.200
    18.493    37.672     0.200
    20.888    36.555     0.200
    20.890    36.327     0.200
    20.890    36.077     0.200
    21.982    34.712     0.200
    22.897    32.233     0.200
    24.439    31.264     0.200
    24.439    29.815     0.200
    24.456    30.808     0.200
    24.456    30.508     0.200
    24.456    31.668     0.200
    24.968    28.242     0.200
    24.968    30.672     0.200
    24.968    29.393     0.200
    24.968    29.512     0.200
    25.766    26.329     0.200
    26.814    24.693     0.200
    26.939    26.233     0.200
    26.939    26.403     0.200
    26.956    24.434     0.200
    26.956    24.233     0.200
    29.313    19.583     0.200
    16.819    38.617     0.200
    18.458    35.685     0.200
    24.882    29.438     0.200
    16.930    39.891     0.200
    18.657    36.657     0.200
    24.590    31.203     0.200
    24.924    30.571     0.200
    18.612    37.113     0.200
    24.550    30.783     0.200
    24.931    30.300     0.200
    18.733    36.797     0.200
    18.733    36.539     0.200
    20.988    36.418     0.200
    22.222    35.149     0.200
    22.863    33.427     0.200
    23.137    33.041     0.200
    24.390    31.137     0.200
    24.657    30.734     0.200
    24.661    30.997     0.200
    24.661    29.794     0.200
    24.904    30.320     0.200
    24.904    30.413     0.200
    27.077    25.032     0.200
    26.961    24.677     0.200
    27.158    24.709     0.200
    18.479    36.525     0.200
    18.479    36.853     0.200
    20.844    36.543     0.200
    20.845    36.853     0.200
    21.970    35.200     0.200
    22.880    32.893     0.200
    24.441    31.272     0.200
    24.441    29.757     0.200
    24.931    30.127     0.200
    24.931    29.639     0.200
    24.931    30.127     0.200
    26.966    26.386     0.200
    27.001    23.579     0.200
    26.914    24.978     0.200
    27.181    23.103     0.200
    29.346    18.808     0.200
    18.457    36.611     0.200
    20.430    36.050     0.200
    20.792    36.176     0.200
    20.793    36.115     0.200
    21.949    34.643     0.200
    24.438    30.743     0.200
    24.438    31.266     0.200
    24.892    29.852     0.200
    24.892    29.489     0.200
    24.892    29.852     0.200
    26.008    27.772     0.200
    26.991    24.380     0.200
    26.991    25.923     0.200
    27.016    24.270     0.200
    27.558    22.360     0.200
    28.901    20.512     0.200
    16.781    38.614     0.200
    17.214    38.462     0.200
    18.421    35.470     0.200
    24.408    30.552     0.200
    24.408    30.360     0.200
    24.893    30.998     0.200
    24.893    29.686     0.200
    26.978    25.252     0.200
    18.563    35.458     0.200
    18.563    35.962     0.200
    25.021    29.160     0.200
    25.021    29.160     0.200
    28.671    19.266     0.200
    16.936    39.276     0.200
    17.550    39.454     0.200
    18.571    37.693     0.200
    24.549    31.882     0.200
    24.846    31.629     0.200
    24.846    32.208     0.200
    24.846    32.317     0.200
    17.015    38.983     0.200
    18.821    38.281     0.200
    18.821    36.681     0.200
    19.020    36.888     0.200
    24.974    30.430     0.200
    27.049    26.830     0.200
    16.842    40.278     0.200
    18.524    35.599     0.200
    18.524    36.724     0.200
    22.015    34.951     0.200
    24.919    30.219     0.200
    24.919    30.105     0.200
    18.583    36.676     0.200
    18.583    36.480     0.200
    22.075    33.853     0.200
    24.857    30.948     0.200
    24.857    29.602     0.200
    18.539    37.096     0.200
    24.872    30.549     0.200
    24.872    32.045     0.200
    16.949    38.310     0.200
    18.626    36.414     0.200
    24.567    31.167     0.200
    24.917    31.123     0.200
    14.526    41.953     0.200
    16.398    40.764     0.200
    16.475    39.019     0.200
    16.475    40.619     0.200
    16.908    39.683     0.200
    16.943    38.857     0.200
    16.998    40.181     0.200
    18.053    39.186     0.200
    18.619    37.737     0.200
    18.619    37.382     0.200
    24.917    31.283     0.200
    24.917    31.388     0.200
    24.917    30.933     0.200
    18.645    35.275     0.200
    18.645    38.040     0.200
    24.555    31.261     0.200
    24.992    30.536     0.200
    24.992    30.885     0.200
    29.963    16.793     0.200
    16.736    38.105     0.200
    17.027    38.454     0.200
    17.813    37.919     0.200
    18.376    36.961     0.200
    18.376    37.691     0.200
    20.354    36.924     0.200
    20.757    36.030     0.200
    20.759    35.942     0.200
    21.333    35.212     0.200
    21.869    34.603     0.200
    22.601    34.079     0.200
    23.112    34.063     0.200
    23.461    34.272     0.200
    23.708    32.210     0.200
    23.980    33.132     0.200
    24.359    31.204     0.200
    24.364    30.908     0.200
    24.364    30.576     0.200
    24.403    31.328     0.200
    24.912    29.560     0.200
    24.912    29.232     0.200
    24.912    30.123     0.200
    25.463    27.471     0.200
    25.972    26.221     0.200
    26.116    25.196     0.200
    26.509    25.632     0.200
    26.628    25.668     0.200
    26.947    26.137     0.200
    29.350    19.891     0.200
    16.960    39.642     0.200
    18.733    38.402     0.200
    24.449    33.828     0.200
    24.449    33.168     0.200
    24.639    31.550     0.200
    24.639    30.441     0.200
    24.963    31.977     0.200
    24.963    32.251     0.200
    18.769    37.287     0.200
    22.253    34.822     0.200
    24.062    32.298     0.200
    24.996    30.888     0.200
    24.996    31.740     0.200
    18.607    36.392     0.200
    18.607    36.283     0.200
    22.096    34.160     0.200
    24.916    27.535     0.200
    24.916    28.566     0.200
    18.483    38.498     0.200
    24.926    31.554     0.200
    24.926    32.804     0.200
    24.926    30.984     0.200
    16.425    40.905     0.200
    16.870    38.770     0.200
    15.707    39.945     0.200
    16.333    39.496     0.200
    16.843    39.361     0.200
    16.847    39.885     0.200
    18.470    36.853     0.200
    18.470    38.103     0.200
    24.819    31.068     0.200
    24.819    31.607     0.200
    24.819    31.060     0.200
    18.404    36.611     0.200
    18.404    35.080     0.200
    18.404    37.587     0.200
    20.803    36.055     0.200
    20.804    35.724     0.200
    20.804    34.592     0.200
    21.895    33.955     0.200
    22.804    31.707     0.200
    23.442    33.702     0.200
    24.372    30.317     0.200
    24.376    30.644     0.200
    24.376    29.855     0.200
    24.432    29.609     0.200
    24.430    30.614     0.200
    24.430    29.614     0.200
    24.430    29.810     0.200
    24.430    30.114     0.200
    24.430    30.474     0.200
    24.940    29.756     0.200
    24.940    28.521     0.200
    24.940    28.810     0.200
    24.940    28.459     0.200
    25.374    27.935     0.200
    25.699    25.999     0.200
    26.901    25.781     0.200
    26.901    25.679     0.200
    26.901    23.734     0.200
    26.901    25.578     0.200
    26.901    23.421     0.200
    26.932    25.652     0.200
    26.932    24.628     0.200
    26.932    25.909     0.200
    26.954    23.256     0.200
    28.423    20.222     0.200
    28.842    18.312     0.200
    29.327    19.557     0.200
    29.327    19.659     0.200
    29.519    16.762     0.200
    16.808    37.271     0.200
    18.465    36.201     0.200
    21.957    33.868     0.200
    24.910    28.528     0.200
    24.910    29.239     0.200
    24.910    28.833     0.200
    16.924    39.254     0.200
    18.665    36.011     0.200
    24.589    31.390     0.200
    24.944    30.712     0.200
    18.348    36.856     0.200
    18.348    37.456     0.200
    21.844    36.587     0.200
    24.844    31.308     0.200
    17.200    36.547     0.200
    24.491    28.517     0.200
    24.420    29.251     0.200
    24.420    28.911     0.200
    24.420    29.708     0.200
    15.688    39.013     0.200
    16.501    39.031     0.200
    16.929    38.663     0.200
    18.675    36.565     0.200
    18.675    37.139     0.200
    22.162    34.532     0.200
    24.947    30.615     0.200
    24.947    30.939     0.200
    16.439    40.332     0.200
    18.580    37.370     0.200
    24.847    31.563     0.200
    24.847    30.727     0.200
    26.373    25.097     0.200
    16.915    41.399     0.200
    24.874    31.367     0.200
    18.544    36.989     0.200
    24.503    31.522     0.200
    24.503    31.030     0.200
    24.907    29.752     0.200
    24.907    30.228     0.200
    14.466    39.485     0.200
    15.421    37.431     0.200
    15.391    37.931     0.200
    15.648    41.076     0.200
    16.169    39.600     0.200
    16.251    37.684     0.200
    16.676    39.441     0.200
    16.709    37.867     0.200
    18.308    36.327     0.200
    24.917    30.259     0.200
    24.917    29.919     0.200
    24.917    30.490     0.200
    27.312    24.034     0.200
    17.181    38.835     0.200
    17.488    38.224     0.200
    17.946    38.730     0.200
    18.507    36.312     0.200
    18.507    37.636     0.200
    18.507    36.626     0.200
    20.490    37.036     0.200
    20.776    37.130     0.200
    22.001    35.981     0.200
    23.556    34.989     0.200
    24.328    32.462     0.200
    24.328    31.952     0.200
    24.328    31.403     0.200
    24.499    30.712     0.200
    24.499    32.292     0.200
    24.839    29.565     0.200
    24.839    30.860     0.200
    25.108    31.381     0.200
    26.827    25.297     0.200
    27.053    26.053     0.200
    27.080    25.355     0.200
    27.355    25.080     0.200
    29.437    19.150     0.200
    17.084    37.734     0.200
    18.451    36.104     0.200
    23.556    35.750     0.200
    23.937    33.963     0.200
    23.903    32.118     0.200
    23.903    31.778     0.200
    23.903    32.591     0.200
    24.616    30.713     0.200
    24.616    30.604     0.200
    24.412    31.593     0.200
    24.412    31.464     0.200
    18.839    39.564     0.200
    18.839    39.786     0.200
    22.323    37.357     0.200
    24.988    33.522     0.200
    24.988    33.640     0.200
    18.623    37.553     0.200
    18.623    36.668     0.200
    24.873    31.059     0.200
    18.604    37.426     0.200
    22.093    35.361     0.200
    14.546    41.647     0.200
    16.538    38.828     0.200
    16.962    38.557     0.200
    18.742    37.515     0.200
    18.742    37.616     0.200
    18.742    38.104     0.200
    20.646    36.505     0.200
    22.228    35.410     0.200
    23.151    34.404     0.200
    24.457    31.217     0.200
    24.971    30.594     0.200
    24.971    31.317     0.200
    27.023    25.833     0.200
    17.018    39.454     0.200
    18.832    37.007     0.200
    22.316    36.031     0.200
    16.255    39.231     0.200
    16.775    38.236     0.200
    16.783    39.642     0.200
    18.393    36.534     0.200
    21.887    34.254     0.200
    24.394    31.841     0.200
    24.868    30.272     0.200
    24.868    30.061     0.200
    24.868    29.928     0.200
    16.387    38.677     0.200
    16.907    38.265     0.200
    17.506    37.787     0.200
    18.525    37.155     0.200
    24.824    31.169     0.200
    24.824    30.973     0.200
    24.824    30.728     0.200
    16.814    38.015     0.200
    24.883    31.204     0.200
    24.883    31.604     0.200
    16.528    37.667     0.200
    17.052    37.892     0.200
    18.429    36.600     0.200
    21.921    35.432     0.200
    16.562    40.232     0.200
    17.065    39.388     0.200
    17.110    39.650     0.200
    17.163    39.171     0.200
    17.185    39.011     0.200
    18.218    38.731     0.200
    18.783    37.041     0.200
    18.783    38.022     0.200
    22.274    35.905     0.200
    24.837    30.462     0.200
    16.968    40.509     0.200
    18.754    38.236     0.200
    24.975    32.134     0.200
    16.850    38.406     0.200
    18.543    37.545     0.200
    22.033    34.744     0.200
    24.495    31.667     0.200
    24.495    30.757     0.200
    24.417    30.453     0.200
    24.929    29.481     0.200
    24.929    30.329     0.200
    24.929    29.723     0.200
    25.890    24.978     0.200
    25.747    26.306     0.200
    18.426    36.412     0.200
    18.426    36.812     0.200
    18.932    37.673     0.200
    20.777    36.377     0.200
    20.779    36.148     0.200
    21.359    37.085     0.200
    21.918    34.172     0.200
    22.823    32.416     0.200
    24.405    30.999     0.200
    24.409    30.706     0.200
    24.409    30.881     0.200
    24.389    31.323     0.200
    24.389    31.162     0.200
    24.389    30.422     0.200
    24.389    30.733     0.200
    24.466    31.251     0.200
    24.899    29.468     0.200
    24.899    29.750     0.200
    24.899    30.519     0.200
    24.899    29.609     0.200
    25.367    29.008     0.200
    25.367    31.049     0.200
    25.666    26.320     0.200
    26.752    24.337     0.200
    26.864    26.933     0.200
    26.864    24.234     0.200
    26.864    23.593     0.200
    26.864    23.833     0.200
    26.864    25.042     0.200
    26.975    25.743     0.200
    26.975    25.913     0.200
    28.693    20.990     0.200
    29.369    19.599     0.200
    29.369    19.769     0.200
    16.897    38.863     0.200
    16.974    38.641     0.200
    18.571    37.878     0.200
    18.571    37.478     0.200
    24.537    30.815     0.200
    24.878    29.790     0.200
    24.878    30.257     0.200
    24.878    29.790     0.200
    18.412    37.045     0.200
    18.412    35.659     0.200
    24.413    31.730     0.200
    24.859    29.654     0.200
    16.813    40.480     0.200
    18.473    38.402     0.200
    21.965    35.166     0.200
    22.872    33.214     0.200
    24.444    31.863     0.200
    24.910    31.142     0.200
    16.869    39.277     0.200
    21.994    34.557     0.200
    24.491    31.120     0.200
    24.843    29.457     0.200
    24.843    29.922     0.200
    24.843    29.598     0.200
    25.639    26.628     0.200
    18.343    36.137     0.200
    20.895    35.293     0.200
    20.897    35.065     0.200
    22.444    31.570     0.200
    22.752    32.068     0.200
    22.962    31.951     0.200
    23.302    32.116     0.200
    23.322    31.522     0.200
    23.553    31.865     0.200
    23.822    30.832     0.200
    24.269    28.930     0.200
    24.273    29.889     0.200
    24.273    29.354     0.200
    24.568    30.220     0.200
    24.568    28.720     0.200
    24.568    29.281     0.200
    24.568    29.630     0.200
    24.837    29.379     0.200
    25.157    27.423     0.200
    25.078    28.571     0.200
    25.078    27.841     0.200
    25.078    27.995     0.200
    25.235    27.495     0.200
    25.302    26.701     0.200
    25.548    25.221     0.200
    25.816    24.681     0.200
    26.134    24.295     0.200
    26.355    25.794     0.200
    26.397    24.298     0.200
    26.685    23.421     0.200
    26.795    23.637     0.200
    26.795    24.607     0.200
    26.875    22.679     0.200
    27.161    21.911     0.200
    27.026    21.926     0.200
    27.026    23.332     0.200
    27.026    23.131     0.200
    27.367    21.163     0.200
    27.928    21.104     0.200
    28.511    19.605     0.200
    28.563    19.112     0.200
    28.607    18.995     0.200
    28.762    17.992     0.200
    29.138    16.370     0.200
    29.187    18.212     0.200
    29.381    15.811     0.200
    29.434    16.138     0.200
    29.867    14.887     0.200
    16.801    38.869     0.200
    18.406    36.364     0.200
    18.406    36.641     0.200
    21.901    34.043     0.200
    22.799    32.091     0.200
    24.723    28.860     0.200
    24.852    28.065     0.200
    24.852    29.065     0.200
    24.852    27.944     0.200
    15.859    38.700     0.200
    16.381    41.021     0.200
    16.872    37.949     0.200
    16.877    38.034     0.200
    16.903    40.668     0.200
    18.522    36.771     0.200
    22.014    34.294     0.200
    24.864    29.972     0.200
    16.857    38.996     0.200
    18.533    37.166     0.200
    24.496    30.703     0.200
    24.903    29.949     0.200
    24.903    30.180     0.200
    24.903    29.949     0.200
    17.240    38.209     0.200
    18.448    36.656     0.200
    18.448    36.922     0.200
    21.941    34.514     0.200
    22.844    33.379     0.200
    24.437    32.021     0.200
    24.437    30.513     0.200
    24.876    29.884     0.200
    24.876    30.150     0.200
    19.206    38.582     0.200
    20.735    37.208     0.200
    23.222    35.388     0.200
    25.166    30.317     0.200
    25.510    29.476     0.200
    25.713    29.468     0.200
    25.957    28.477     0.200
    28.166    23.498     0.200
    29.762    19.051     0.200
    14.642    41.570     0.200
    15.648    40.597     0.200
    16.975    37.304     0.200
    18.312    34.261     0.200
    18.312    34.910     0.200
    18.312    34.810     0.200
    21.824    31.786     0.200
    23.935    30.390     0.200
    23.935    30.541     0.200
    24.491    28.036     0.200
    24.491    28.439     0.200
    24.442    29.195     0.200
    24.442    29.093     0.200
    24.442    28.615     0.200
    27.326    23.869     0.200
    29.180    17.564     0.200
    15.078    42.547     0.200
    15.589    43.573     0.200
    15.906    43.228     0.200
    16.352    42.039     0.200
    16.953    40.691     0.200
    17.297    39.748     0.200
    18.400    37.540     0.200
    18.400    37.999     0.200
    21.896    35.652     0.200
    22.793    32.706     0.200
    24.848    31.426     0.200
    24.848    31.407     0.200
    24.848    31.778     0.200
    25.826    28.491     0.200
    18.716    37.814     0.200
    18.716    37.916     0.200
    20.985    37.098     0.200
    20.987    36.716     0.200
    22.205    35.646     0.200
    23.120    33.969     0.200
    24.401    33.778     0.200
    24.401    32.176     0.200
    24.401    31.727     0.200
    24.401    31.477     0.200
    24.401    31.989     0.200
    24.643    31.379     0.200
    24.643    31.051     0.200
    24.643    32.192     0.200
    24.915    31.083     0.200
    24.915    30.481     0.200
    24.915    30.681     0.200
    25.874    26.884     0.200
    25.805    26.984     0.200
    26.061    26.648     0.200
    26.968    27.822     0.200
    26.968    27.420     0.200
    26.968    24.951     0.200
    26.968    24.522     0.200
    27.061    25.826     0.200
    27.141    24.195     0.200
    28.747    22.660     0.200
    29.395    19.545     0.200
    17.027    41.407     0.200
    18.822    39.129     0.200
    18.822    38.156     0.200
    23.231    35.313     0.200
    24.954    31.772     0.200
    24.954    32.088     0.200
    24.954    32.202     0.200
    25.891    28.307     0.200
    21.824    32.877     0.200
    22.722    32.349     0.200
    24.342    31.921     0.200
    24.342    31.018     0.200
    24.361    29.110     0.200
    24.870    28.511     0.200
    24.870    29.956     0.200
    24.870    28.151     0.200
    18.539    35.354     0.200
    18.539    36.132     0.200
    24.514    29.302     0.200
    24.870    27.956     0.200
    24.870    27.735     0.200
    24.870    28.764     0.200
    18.546    37.845     0.200
    18.546    37.320     0.200
    22.038    35.032     0.200
    22.943    33.667     0.200
    24.521    31.243     0.200
    24.521    30.938     0.200
    24.864    30.096     0.200
    24.864    29.561     0.200
    24.864    31.465     0.200
    25.681    26.603     0.200
    17.094    38.486     0.200
    17.596    38.103     0.200
    18.699    36.703     0.200
    18.699    37.691     0.200
    22.192    35.563     0.200
    23.096    33.095     0.200
    24.820    30.357     0.200
    24.820    31.677     0.200
    24.820    30.369     0.200
    15.877    42.167     0.200
    16.057    42.397     0.200
    16.681    41.331     0.200
    18.822    38.363     0.200
    18.822    37.808     0.200
    22.314    36.005     0.200
    24.783    31.411     0.200
    24.783    31.840     0.200
    24.783    32.223     0.200
    26.464    25.318     0.200
    18.497    37.129     0.200
    18.497    36.323     0.200
    21.992    34.147     0.200
    24.498    29.940     0.200
    24.498    29.717     0.200
    24.821    30.207     0.200
    24.821    28.763     0.200
    18.681    38.760     0.200
    18.681    38.365     0.200
    24.867    32.291     0.200
    16.888    38.501     0.200
    18.554    36.806     0.200
    17.024    40.496     0.200
    18.796    39.091     0.200
    18.796    38.896     0.200
    23.202    35.611     0.200
    24.704    33.090     0.200
    24.927    33.212     0.200
    24.927    32.887     0.200
    24.927    33.333     0.200
    26.913    26.179     0.200
    18.670    37.287     0.200
    18.670    37.678     0.200
    24.597    31.283     0.200
    24.601    31.154     0.200
    24.925    30.756     0.200
    24.925    30.119     0.200
    24.925    30.366     0.200
    15.587    38.856     0.200
    16.854    39.450     0.200
    18.488    38.210     0.200
    20.469    37.465     0.200
    20.779    37.185     0.200
    21.982    35.212     0.200
    24.477    31.191     0.200
    24.477    29.699     0.200
    24.855    31.361     0.200
    24.855    30.556     0.200
    15.169    41.377     0.200
    15.323    40.654     0.200
    15.865    40.405     0.200
    15.954    40.978     0.200
    16.108    41.204     0.200
    16.413    39.969     0.200
    16.487    41.190     0.200
    16.983    40.474     0.200
    17.012    40.184     0.200
    17.064    38.790     0.200
    17.530    40.509     0.200
    18.066    39.237     0.200
    18.635    37.624     0.200
    22.121    34.296     0.200
    14.182    39.732     0.200
    15.473    38.921     0.200
    16.782    38.815     0.200
    17.296    38.331     0.200
    18.400    36.999     0.200
    18.400    36.804     0.200
    22.794    31.981     0.200
    24.400    29.312     0.200
    24.870    30.140     0.200
    24.870    29.945     0.200
    17.571    39.387     0.200
    18.675    37.425     0.200
    22.212    30.494     0.200
    23.988    29.386     0.200
    23.993    29.594     0.200
    24.749    27.926     0.200
    16.851    39.331     0.200
    18.460    37.085     0.200
    18.460    36.608     0.200
    22.852    32.021     0.200
    24.460    30.759     0.200
    24.465    30.955     0.200
    24.465    30.420     0.200
    24.521    30.021     0.200
    24.827    28.253     0.200
    24.827    29.799     0.200
    26.822    23.638     0.200
    16.898    37.945     0.200
    18.534    36.855     0.200
    18.534    36.475     0.200
    20.515    35.613     0.200
    20.785    36.442     0.200
    20.787    35.963     0.200
    22.028    33.899     0.200
    22.713    33.042     0.200
    22.928    32.014     0.200
    24.321    31.420     0.200
    24.321    30.560     0.200
    24.524    30.452     0.200
    24.524    29.955     0.200
    24.832    30.554     0.200
    24.832    29.475     0.200
    24.832    28.784     0.200
    25.643    26.094     0.200
    26.082    24.857     0.200
    26.679    25.802     0.200
    26.827    24.872     0.200
    26.827    24.202     0.200
    27.068    26.416     0.200
    18.679    36.383     0.200
    18.679    36.943     0.200
    22.167    33.694     0.200
    24.609    31.356     0.200
    24.609    31.481     0.200
    24.923    30.867     0.200
    24.923    30.178     0.200
    25.134    28.548     0.200
    16.757    39.311     0.200
    18.404    36.792     0.200
    24.381    31.419     0.200
    24.381    31.294     0.200
    24.927    29.400     0.200
    24.927    30.478     0.200
    24.084    31.520     0.200
    24.847    30.812     0.200
    16.753    38.311     0.200
    18.327    36.108     0.200
    18.327    35.983     0.200
    21.824    33.209     0.200
    22.823    34.111     0.200
    24.345    30.277     0.200
    24.350    30.626     0.200
    24.350    30.384     0.200
    24.337    31.533     0.200
    24.846    29.974     0.200
    24.846    30.041     0.200
    24.846    29.615     0.200
    18.338    36.436     0.200
    19.522    35.130     0.200
    21.834    33.367     0.200
    24.839    30.070     0.200
    24.839    30.765     0.200
    24.839    29.843     0.200
    14.662    43.481     0.200
    14.716    43.448     0.200
    15.209    43.415     0.200
    15.478    43.786     0.200
    15.793    43.520     0.200
    16.317    40.359     0.200
    16.821    42.464     0.200
    18.458    38.148     0.200
    24.006    35.098     0.200
    24.434    31.854     0.200
    24.393    33.297     0.200
    24.904    30.366     0.200
    24.904    32.479     0.200
    25.685    26.728     0.200
    26.880    24.859     0.200
    29.849    19.684     0.200
    18.565    35.555     0.200
    24.529    30.921     0.200
    24.885    30.343     0.200
    14.569    37.523     0.200
    14.786    39.871     0.200
    14.938    39.815     0.200
    15.397    37.045     0.200
    15.526    37.169     0.200
    15.517    39.952     0.200
    15.622    40.400     0.200
    16.061    39.360     0.200
    16.142    38.824     0.200
    16.228    37.554     0.200
    16.675    38.173     0.200
    18.282    35.199     0.200
    18.282    35.910     0.200
    21.775    33.728     0.200
    23.301    30.121     0.200
    24.927    27.422     0.200
    24.927    28.148     0.200
    18.347    35.980     0.200
    20.720    36.570     0.200
    20.722    35.752     0.200
    21.841    34.541     0.200
    22.743    32.811     0.200
    23.990    34.284     0.200
    24.347    30.886     0.200
    24.347    31.026     0.200
    24.385    31.148     0.200
    24.385    31.648     0.200
    24.385    31.808     0.200
    24.894    29.231     0.200
    24.894    28.935     0.200
    25.977    28.435     0.200
    26.524    27.237     0.200
    26.953    25.247     0.200
    29.364    20.090     0.200
    16.771    40.183     0.200
    18.397    36.423     0.200
    21.890    34.587     0.200
    22.793    33.569     0.200
    24.388    32.176     0.200
    24.388    30.010     0.200
    24.444    29.891     0.200
    24.894    29.547     0.200
    24.894    29.885     0.200
    16.322    40.599     0.200
    21.955    36.638     0.200
    24.456    31.444     0.200
    24.456    31.128     0.200
    24.850    31.326     0.200
    18.302    34.928     0.200
    18.302    36.217     0.200
    20.677    35.505     0.200
    21.797    34.339     0.200
    24.316    31.141     0.200
    24.316    29.844     0.200
    24.370    31.108     0.200
    24.675    29.245     0.200
    24.878    29.544     0.200
    24.878    30.060     0.200
    17.313    38.498     0.200
    18.417    36.623     0.200
    24.395    32.499     0.200
    21.892    32.103     0.200
    21.892    32.525     0.200
    16.250    39.029     0.200
    16.795    38.082     0.200
    17.500    38.335     0.200
    18.387    34.802     0.200
    18.387    36.153     0.200
    18.387    36.422     0.200
    20.695    36.071     0.200
    20.697    35.113     0.200
    20.697    35.793     0.200
    21.882    33.508     0.200
    22.779    31.409     0.200
    23.176    33.783     0.200
    23.403    33.460     0.200
    23.529    33.718     0.200
    24.047    32.514     0.200
    24.079    30.479     0.200
    24.395    29.582     0.200
    24.331    31.379     0.200
    24.331    30.449     0.200
    24.331    30.879     0.200
    24.331    31.579     0.200
    24.331    30.639     0.200
    24.400    30.355     0.200
    24.400    30.190     0.200
    24.456    30.449     0.200
    24.728    30.264     0.200
    24.841    28.773     0.200
    24.841    29.183     0.200
    24.841    28.983     0.200
    25.459    28.406     0.200
    25.589    26.004     0.200
    25.781    27.084     0.200
    26.035    27.181     0.200
    26.185    26.390     0.200
    26.367    26.377     0.200
    26.582    25.284     0.200
    26.624    25.707     0.200
    26.699    24.250     0.200
    26.803    25.346     0.200
    26.792    24.235     0.200
    26.792    23.865     0.200
    26.812    25.410     0.200
    27.011    24.616     0.200
    27.011    25.556     0.200
    27.100    24.805     0.200
    27.322    24.063     0.200
    27.394    23.185     0.200
    27.526    22.260     0.200
    27.592    22.822     0.200
    27.673    23.108     0.200
    27.937    23.118     0.200
    28.151    21.032     0.200
    28.522    21.399     0.200
    28.737    20.190     0.200
    28.797    19.343     0.200
    28.843    18.983     0.200
    28.944    18.892     0.200
    28.999    18.822     0.200
    29.362    17.679     0.200
    29.420    18.088     0.200
    29.420    18.268     0.200
    29.464    18.185     0.200
    29.598    17.095     0.200
    18.427    35.144     0.200
    20.359    36.748     0.200
    21.938    33.120     0.200
    22.424    33.789     0.200
    22.789    32.031     0.200
    23.957    32.664     0.200
    24.570    30.385     0.200
    24.576    30.115     0.200
    24.466    31.081     0.200
    24.466    30.257     0.200
    24.466    30.851     0.200
    24.632    30.453     0.200
    27.299    23.843     0.200
    28.271    21.338     0.200
    18.666    36.797     0.200
    22.157    34.678     0.200
    23.064    32.546     0.200
    24.619    30.899     0.200
    24.623    30.682     0.200
    24.623    29.725     0.200
    24.679    30.862     0.200
    24.857    30.757     0.200
    24.857    30.690     0.200
    26.424    25.184     0.200
    26.818    24.115     0.200
    29.967    16.169     0.200
    17.041    39.045     0.200
    18.767    37.030     0.200
    18.767    36.124     0.200
    22.257    35.100     0.200
    22.911    33.841     0.200
    23.301    33.442     0.200
    24.702    30.340     0.200
    24.705    31.281     0.200
    24.705    30.304     0.200
    24.762    29.548     0.200
    24.860    29.784     0.200
    24.860    31.467     0.200
    24.860    29.752     0.200
    28.669    18.977     0.200
    16.283    39.526     0.200
    18.504    36.421     0.200
    21.995    34.014     0.200
    22.904    32.596     0.200
    24.915    29.490     0.200
    16.767    39.409     0.200
    18.355    36.776     0.200
    20.687    36.915     0.200
    21.850    34.048     0.200
    24.369    31.737     0.200
    24.369    31.872     0.200
    24.852    30.270     0.200
    24.852    29.600     0.200
    25.587    26.521     0.200
    26.991    24.319     0.200
    27.082    24.639     0.200
    18.373    36.375     0.200
    18.373    37.020     0.200
    20.378    36.349     0.200
    21.869    34.721     0.200
    22.764    34.094     0.200
    24.386    31.941     0.200
    24.390    31.080     0.200
    24.390    31.549     0.200
    24.836    29.412     0.200
    24.836    29.998     0.200
    24.836    29.862     0.200
    15.791    39.121     0.200
    15.936    40.119     0.200
    16.486    40.493     0.200
    17.588    39.190     0.200
    23.747    33.066     0.200
    23.753    32.558     0.200
    16.811    42.806     0.200
    17.492    42.399     0.200
    17.832    41.649     0.200
    18.934    39.097     0.200
    18.934    41.191     0.200
    23.744    37.790     0.200
    24.258    36.240     0.200
    24.258    35.565     0.200
    24.258    36.440     0.200
    25.063    33.008     0.200
    25.068    34.016     0.200
    25.068    33.828     0.200
    26.348    29.509     0.200
    18.600    37.607     0.200
    18.600    37.252     0.200
    24.546    31.340     0.200
    24.546    31.180     0.200
    24.916    30.994     0.200
    24.916    29.979     0.200
    18.332    35.858     0.200
    21.828    33.944     0.200
    24.349    31.367     0.200
    24.349    31.032     0.200
    24.857    29.707     0.200
    24.857    29.537     0.200
    25.583    25.669     0.200
    14.211    41.429     0.200
    14.944    41.329     0.200
    15.105    41.219     0.200
    15.828    41.417     0.200
    16.374    40.801     0.200
    16.452    41.239     0.200
    16.974    40.901     0.200
    18.595    36.969     0.200
    18.595    38.630     0.200
    24.387    33.403     0.200
    24.548    31.744     0.200
    24.548    32.572     0.200
    24.899    31.847     0.200
    24.899    30.698     0.200
    25.888    28.946     0.200
    17.987    38.396     0.200
    18.551    36.883     0.200
    18.551    37.258     0.200
    20.847    36.679     0.200
    22.043    35.260     0.200
    24.514    30.917     0.200
    24.518    31.171     0.200
    24.518    30.749     0.200
    24.883    30.503     0.200
    24.883    30.686     0.200
    24.883    30.792     0.200
    15.726    39.677     0.200
    15.813    39.860     0.200
    16.329    39.726     0.200
    16.843    39.873     0.200
    24.012    34.192     0.200
    16.237    37.139     0.200
    18.350    34.784     0.200
    18.350    35.288     0.200
    21.863    31.817     0.200
    24.532    29.368     0.200
    24.532    28.316     0.200
    24.414    30.078     0.200
    24.414    29.040     0.200
    24.414    29.778     0.200
    21.677    35.128     0.200
    23.433    34.096     0.200
    23.439    33.902     0.200
    24.385    31.902     0.200
    24.385    30.406     0.200
    24.856    29.722     0.200
    24.856    29.183     0.200
    24.856    29.964     0.200
    16.969    40.249     0.200
    17.099    40.459     0.200
    24.640    30.838     0.200
    24.640    29.867     0.200
    14.357    39.809     0.200
    21.826    34.157     0.200
    24.353    32.050     0.200
    24.353    30.679     0.200
    24.841    30.110     0.200
    24.841    29.825     0.200
    24.841    29.950     0.200
    23.766    32.090     0.200
    20.924    37.194     0.200
    24.607    29.211     0.200
    24.611    30.417     0.200
    24.611    29.640     0.200
    24.885    30.085     0.200
    16.262    40.452     0.200
    16.344    38.988     0.200
    21.895    34.577     0.200
    24.401    31.401     0.200
    24.867    31.473     0.200
    24.867    30.645     0.200
    24.867    30.778     0.200
    24.505    31.548     0.200
    21.523    34.741     0.200
    22.413    33.237     0.200
    24.085    32.367     0.200
    24.085    31.632     0.200
    24.142    31.901     0.200
    24.389    32.064     0.200
    24.895    30.637     0.200
    24.895    30.614     0.200
    26.850    26.359     0.200
    27.618    23.715     0.200
    29.699    19.056     0.200
    24.351    29.938     0.200
    24.402    31.558     0.200
    24.402    29.136     0.200
    24.458    29.835     0.200
    24.861    29.872     0.200
    24.861    30.235     0.200
    25.159    27.625     0.200
    27.895    19.210     0.200
    14.807    39.403     0.200
    17.447    38.028     0.200
    18.919    37.035     0.200
    24.856    28.061     0.200
    22.040    34.704     0.200
    14.164    42.515     0.200
    18.509    36.942     0.200
    22.013    33.485     0.200
    24.588    31.182     0.200
    24.609    32.605     0.200
    15.519    37.944     0.200
    15.633    38.885     0.200
    15.740    40.305     0.200
    16.258    40.304     0.200
    16.768    39.593     0.200
    16.778    38.705     0.200
    16.784    39.196     0.200
    21.891    34.385     0.200
    18.613    36.338     0.200
    22.103    34.832     0.200
    24.556    31.022     0.200
    24.560    30.770     0.200
    24.616    31.018     0.200
    24.908    30.581     0.200
    24.908    30.692     0.200
    24.908    30.302     0.200
    16.918    39.629     0.200
    18.628    37.449     0.200
    24.571    31.612     0.200
    24.910    31.359     0.200
    14.130    39.568     0.200
    14.348    41.150     0.200
    14.486    39.890     0.200
    14.684    40.131     0.200
    14.814    37.836     0.200
    14.865    40.393     0.200
    15.027    40.102     0.200
    16.430    38.049     0.200
    17.320    38.741     0.200
    17.588    39.301     0.200
    18.527    36.740     0.200
    22.019    34.670     0.200
    22.924    32.296     0.200
    24.501    30.569     0.200
    24.558    30.484     0.200
    24.876    30.835     0.200
    24.876    30.249     0.200
    25.685    26.282     0.200
    29.059    18.753     0.200
    18.722    37.564     0.200
    22.209    35.635     0.200
    23.130    34.299     0.200
    24.630    31.230     0.200
    24.630    29.922     0.200
    24.960    31.644     0.200
    24.960    31.093     0.200
    27.017    26.591     0.200
    21.859    34.965     0.200
    22.762    33.986     0.200
    24.355    30.451     0.200
    24.360    31.979     0.200
    24.360    30.842     0.200
    24.391    31.942     0.200
    24.901    30.567     0.200
    24.901    30.496     0.200
    18.676    36.465     0.200
    22.178    34.684     0.200
    23.056    33.175     0.200
    24.719    32.510     0.200
    24.724    31.086     0.200
    24.724    31.197     0.200
    24.611    33.401     0.200
    24.611    32.926     0.200
    24.611    33.282     0.200
    24.781    31.546     0.200
    18.252    36.450     0.200
    21.120    34.639     0.200
    22.057    32.416     0.200
    23.578    30.936     0.200
    25.389    27.380     0.200
    24.869    29.242     0.200
    21.829    31.862     0.200
    24.481    27.810     0.200
    24.483    29.186     0.200
    24.483    29.202     0.200
    24.483    29.319     0.200
    15.973    39.124     0.200
    16.350    40.602     0.200
    16.893    39.986     0.200
    23.567    31.833     0.200
    24.512    32.571     0.200
    25.327    29.255     0.200
    25.401    27.782     0.200
    25.401    26.268     0.200
    25.401    27.471     0.200
    25.906    28.003     0.200
    26.222    26.771     0.200
    27.116    25.098     0.200
    28.801    21.419     0.200
    21.187    34.399     0.200
    22.116    33.059     0.200
    22.556    34.244     0.200
    23.665    30.570     0.200
    23.666    31.690     0.200
    23.666    32.356     0.200
    25.286    27.957     0.200
    25.300    27.896     0.200
    25.300    26.857     0.200
    25.300    28.376     0.200
    26.402    25.583     0.200
    26.402    28.783     0.200
    27.380    22.879     0.200
    28.302    21.118     0.200
    28.547    22.110     0.200
    29.827    16.744     0.200
    21.174    34.913     0.200
    22.116    32.642     0.200
    23.619    31.710     0.200
    15.233    38.981     0.200
    17.377    36.692     0.200
    20.867    34.296     0.200
    23.397    32.493     0.200
    23.402    32.273     0.200
    24.489    30.558     0.200
    24.811    28.418     0.200
    25.296    27.429     0.200
    25.309    27.569     0.200
    25.309    27.530     0.200
    25.309    25.792     0.200
    25.309    27.460     0.200
    25.646    24.755     0.200
    26.301    25.513     0.200
    26.301    26.994     0.200
    28.195    20.001     0.200
    28.371    18.764     0.200
    28.379    18.870     0.200
    29.720    16.006     0.200
    29.917    14.993     0.200
    26.506    26.298     0.200
    20.449    36.180     0.200
    23.351    31.576     0.200
    23.351    31.235     0.200
    23.381    32.537     0.200
    24.818    28.134     0.200
    24.818    28.014     0.200
    25.302    27.365     0.200
    25.315    27.305     0.200
    25.315    27.015     0.200
    25.315    27.680     0.200
    25.315    26.925     0.200
    26.130    25.739     0.200
    26.280    24.712     0.200
    26.280    27.402     0.200
    28.700    18.569     0.200
    23.655    34.039     0.200
    22.416    34.459     0.200
    18.431    37.495     0.200
    18.431    37.895     0.200
    23.491    34.047     0.200
    24.048    31.425     0.200
    24.116    32.041     0.200
    24.412    31.872     0.200
    24.416    31.593     0.200
    24.382    33.246     0.200
    24.382    31.455     0.200
    24.382    31.346     0.200
    24.382    32.555     0.200
    24.690    30.802     0.200
    24.692    30.924     0.200
    24.878    32.054     0.200
    24.892    31.591     0.200
    24.892    29.902     0.200
    24.892    30.216     0.200
    26.982    26.669     0.200
    29.376    20.408     0.200
    22.440    35.932     0.200
    14.257    38.951     0.200
    19.914    38.047     0.200
    22.585    36.069     0.200
    26.570    30.093     0.200
    26.583    30.534     0.200
    26.583    29.433     0.200
    26.583    28.843     0.200
    16.511    39.431     0.200
    24.025    32.535     0.200
    25.384    27.968     0.200
    17.644    36.860     0.200
    20.822    33.287     0.200
    20.822    34.334     0.200
    22.035    32.876     0.200
    22.035    32.075     0.200
    22.034    32.279     0.200
    22.091    32.005     0.200
    22.290    32.272     0.200
    23.079    33.990     0.200
    24.642    28.716     0.200
    24.802    27.927     0.200
    25.036    29.353     0.200
    25.036    29.524     0.200
    25.918    24.754     0.200
    25.918    24.144     0.200
    25.918    24.965     0.200
    25.918    24.254     0.200
    26.310    22.877     0.200
    26.393    23.018     0.200
    26.406    22.961     0.200
    26.406    23.860     0.200
    26.406    22.961     0.200
    26.406    22.641     0.200
    26.920    25.168     0.200
    27.749    23.211     0.200
    27.787    19.547     0.200
    27.787    19.145     0.200
    27.787    20.946     0.200
    28.384    16.680     0.200
    28.443    18.170     0.200
    29.308    15.475     0.200
    29.347    18.061     0.200
    29.648    16.630     0.200
    29.731    13.163     0.200
    18.380    36.589     0.200
    23.972    32.351     0.200
    24.480    31.185     0.200
    24.480    30.275     0.200
    24.480    30.853     0.200
    18.408    36.323     0.200
    20.653    35.344     0.200
    20.653    35.586     0.200
    23.713    30.960     0.200
    23.713    31.034     0.200
    23.770    31.303     0.200
    23.901    30.617     0.200
    24.739    28.187     0.200
    24.739    28.086     0.200
    24.739    29.047     0.200
    24.739    27.586     0.200
    24.739    28.789     0.200
    25.228    26.379     0.200
    25.242    26.616     0.200
    25.242    27.319     0.200
    25.242    27.296     0.200
    25.242    26.710     0.200
    25.495    24.406     0.200
    25.727    25.348     0.200
    26.461    24.937     0.200
    26.461    26.531     0.200
    26.461    25.781     0.200
    27.015    21.707     0.200
    27.015    23.339     0.200
    27.015    22.425     0.200
    27.015    22.324     0.200
    28.964    20.828     0.200
    15.515    40.284     0.200
    15.475    38.940     0.200
    16.149    37.908     0.200
    20.837    36.393     0.200
    20.837    36.111     0.200
    20.837    35.502     0.200
    20.837    35.900     0.200
    22.565    35.460     0.200
    23.469    34.440     0.200
    23.770    31.779     0.200
    23.770    31.674     0.200
    23.999    32.524     0.200
    24.876    30.923     0.200
    24.876    32.165     0.200
    24.843    30.261     0.200
    24.843    30.011     0.200
    24.843    29.648     0.200
    24.843    29.050     0.200
    25.334    28.320     0.200
    25.348    28.257     0.200
    25.348    27.960     0.200
    25.348    27.858     0.200
    25.348    28.358     0.200
    26.375    26.400     0.200
    26.406    27.575     0.200
    26.406    26.607     0.200
    27.163    24.077     0.200
    27.163    22.780     0.200
    28.873    21.526     0.200
    26.801    26.218     0.200
    26.164    25.062     0.200
    18.257    35.604     0.200
    24.287    30.972     0.200
    24.455    31.042     0.200
    24.844    29.606     0.200
    24.858    29.544     0.200
    24.858    29.751     0.200
    24.858    30.105     0.200
    15.085    38.468     0.200
    21.079    34.825     0.200
    22.038    35.178     0.200
    22.356    34.934     0.200
    24.706    31.100     0.200
    25.489    29.039     0.200
    26.596    27.836     0.200
    26.596    25.555     0.200
    26.596    24.110     0.200
    26.596    25.555     0.200
    29.852    14.453     0.200
    18.287    37.159     0.200
    18.384    37.779     0.200
    18.384    37.359     0.200
    20.757    36.664     0.200
    24.392    33.262     0.200
    24.396    31.985     0.200
    24.396    32.910     0.200
    24.577    31.350     0.200
    24.843    30.348     0.200
    24.843    30.647     0.200
    24.843    30.747     0.200
    18.321    36.084     0.200
    24.352    30.860     0.200
    24.352    30.696     0.200
    24.826    30.838     0.200
    24.826    30.307     0.200
    18.584    36.867     0.200
    24.521    32.065     0.200
    24.521    29.096     0.200
    24.750    28.998     0.200
    24.948    31.297     0.200
    18.501    36.998     0.200
    18.501    37.627     0.200
    20.819    37.169     0.200
    20.805    34.812     0.200
    24.480    32.560     0.200
    24.484    31.836     0.200
    24.484    32.512     0.200
    24.684    31.675     0.200
    24.864    31.683     0.200
    24.864    30.289     0.200
    24.864    32.496     0.200
    26.395    26.352     0.200
    28.957    19.171     0.200
    18.419    34.948     0.200
    18.419    35.929     0.200
    20.741    35.479     0.200
    24.397    31.585     0.200
    24.401    29.138     0.200
    24.906    29.479     0.200
    24.906    29.479     0.200
    14.988    40.247     0.200
    15.171    40.763     0.200
    15.332    41.163     0.200
    18.813    37.304     0.200
    18.813    37.883     0.200
    24.728    32.468     0.200
    24.900    32.597     0.200
    24.900    31.269     0.200
    24.974    30.903     0.200
    25.831    27.456     0.200
    18.578    36.728     0.200
    18.578    37.864     0.200
    20.854    36.683     0.200
    23.407    33.476     0.200
    24.534    30.568     0.200
    24.538    31.362     0.200
    24.538    30.983     0.200
    24.753    30.813     0.200
    24.888    31.066     0.200
    24.888    30.492     0.200
    24.888    30.835     0.200
    16.781    38.303     0.200
    18.390    35.276     0.200
    18.390    37.610     0.200
    20.750    37.271     0.200
    20.728    35.093     0.200
    24.394    31.192     0.200
    24.580    30.788     0.200
    24.861    29.976     0.200
    24.861    30.218     0.200
    18.628    35.572     0.200
    18.628    36.514     0.200
    24.572    29.427     0.200
    24.572    29.239     0.200
    24.798    28.705     0.200
    24.909    30.539     0.200
    17.480    38.034     0.200
    18.317    36.119     0.200
    18.317    36.568     0.200
    18.317    37.330     0.200
    20.597    36.317     0.200
    20.755    36.109     0.200
    23.184    33.149     0.200
    24.310    30.318     0.200
    24.268    31.134     0.200
    24.268    32.134     0.200
    24.363    30.015     0.200
    24.368    31.084     0.200
    24.368    30.139     0.200
    24.424    30.267     0.200
    24.525    29.664     0.200
    24.777    29.009     0.200
    24.777    30.291     0.200
    24.777    29.908     0.200
    26.703    24.254     0.200
    27.023    23.649     0.200
    27.362    22.627     0.200
    28.482    19.748     0.200
    29.902    15.788     0.200
    18.252    35.375     0.200
    18.252    35.578     0.200
    20.624    35.937     0.200
    23.121    34.962     0.200
    24.286    30.772     0.200
    24.343    30.885     0.200
    24.452    31.145     0.200
    24.850    30.174     0.200
    25.540    25.763     0.200
    26.959    24.828     0.200
    26.959    25.500     0.200
    18.094    36.798     0.200
    18.094    35.313     0.200
    20.522    34.060     0.200
    24.158    29.931     0.200
    24.303    30.000     0.200
    24.853    28.438     0.200
    24.853    28.018     0.200
    18.369    35.753     0.200
    18.369    35.644     0.200
    20.690    35.914     0.200
    20.787    35.543     0.200
    20.779    36.092     0.200
    23.089    35.985     0.200
    24.348    31.390     0.200
    24.348    31.840     0.200
    24.428    30.105     0.200
    24.428    31.855     0.200
    24.548    31.488     0.200
    24.924    31.022     0.200
    24.938    31.157     0.200
    24.938    29.845     0.200
    24.938    30.759     0.200
    24.938    30.181     0.200
    24.938    28.564     0.200
    25.084    29.267     0.200
    25.682    26.075     0.200
    26.491    23.731     0.200
    26.923    25.890     0.200
    16.603    37.668     0.200
    18.154    37.672     0.200
    24.185    30.800     0.200
    24.185    31.132     0.200
    24.906    29.842     0.200
    24.906    29.569     0.200
    24.906    29.260     0.200
    28.647    18.488     0.200
    22.944    34.069     0.200
    23.776    35.634     0.200
    24.809    31.061     0.200
    17.054    38.239     0.200
    20.648    32.689     0.200
    20.637    35.549     0.200
    21.249    36.948     0.200
    22.001    33.452     0.200
    22.001    32.827     0.200
    22.001    33.032     0.200
    23.901    33.629     0.200
    25.119    30.063     0.200
    25.804    25.950     0.200
    25.804    25.331     0.200
    26.143    22.819     0.200
    26.276    22.936     0.200
    26.290    22.678     0.200
    26.290    23.880     0.200
    26.290    25.579     0.200
    26.290    23.630     0.200
    26.290    24.178     0.200
    27.632    19.885     0.200
    27.632    22.014     0.200
    27.866    23.555     0.200
    29.095    17.774     0.200
    29.447    18.782     0.200
    15.347    40.304     0.200
    20.441    35.802     0.200
    24.029    31.360     0.200
    24.880    28.756     0.200
    18.446    36.219     0.200
    24.871    29.040     0.200
    17.526    38.674     0.200
    18.430    37.083     0.200
    18.430    37.363     0.200
    20.746    35.073     0.200
    20.780    36.974     0.200
    22.667    34.221     0.200
    23.181    36.345     0.200
    24.046    30.843     0.200
    24.081    30.280     0.200
    24.430    32.382     0.200
    24.487    31.596     0.200
    24.727    30.653     0.200
    24.839    30.833     0.200
    24.853    30.771     0.200
    24.853    28.821     0.200
    24.853    30.071     0.200
    24.853    30.311     0.200
    25.175    30.220     0.200
    25.683    27.834     0.200
    26.582    25.230     0.200
    26.622    24.514     0.200
    26.818    25.615     0.200
    27.015    24.614     0.200
    27.323    22.763     0.200
    28.789    18.724     0.200
    29.602    16.236     0.200
    16.192    38.348     0.200
    16.583    36.765     0.200
    18.306    34.404     0.200
    18.306    35.084     0.200
    20.262    35.810     0.200
    20.271    34.997     0.200
    23.472    34.100     0.200
    23.472    31.498     0.200
    23.737    31.118     0.200
    23.945    30.849     0.200
    24.383    29.363     0.200
    24.482    28.652     0.200
    24.482    29.508     0.200
    24.438    29.017     0.200
    24.529    29.515     0.200
    24.452    28.652     0.200
    24.452    29.383     0.200
    24.452    28.980     0.200
    24.539    28.638     0.200
    24.563    29.737     0.200
    25.147    25.145     0.200
    25.404    27.674     0.200
    26.358    22.056     0.200
    26.915    23.445     0.200
    27.245    22.720     0.200
    27.316    23.004     0.200
    27.649    20.554     0.200
    27.988    19.838     0.200
    18.347    35.800     0.200
    18.347    35.651     0.200
    20.642    34.733     0.200
    20.819    34.897     0.200
    20.828    35.172     0.200
    23.033    31.411     0.200
    24.308    30.003     0.200
    24.308    30.425     0.200
    24.994    29.223     0.200
    15.101    39.519     0.200
    15.332    41.456     0.200
    17.002    38.980     0.200
    24.741    29.057     0.200
    24.881    30.946     0.200
    28.480    19.456     0.200
    18.368    34.728     0.200
    18.368    34.837     0.200
    18.368    35.237     0.200
    18.368    35.538     0.200
    20.316    34.931     0.200
    20.982    35.794     0.200
    23.947    32.073     0.200
    24.532    29.682     0.200
    24.532    29.317     0.200
    24.560    30.244     0.200
    24.589    29.414     0.200
    24.455    30.808     0.200
    24.455    30.410     0.200
    24.455    30.359     0.200
    24.455    30.519     0.200
    24.622    30.049     0.200
    26.380    27.051     0.200
    26.380    25.660     0.200
    26.380    25.441     0.200
    27.276    22.637     0.200
    27.334    23.855     0.200
    27.334    22.531     0.200
    29.237    17.383     0.200
    29.787    18.384     0.200
    21.456    33.829     0.200
    21.480    34.549     0.200
    21.480    34.189     0.200
    21.490    34.581     0.200
    22.207    33.573     0.200
    22.318    32.175     0.200
    22.856    32.775     0.200
    22.856    32.244     0.200
    22.912    32.267     0.200
    23.047    32.239     0.200
    23.333    32.042     0.200
    23.256    32.864     0.200
    23.467    31.445     0.200
    23.851    29.881     0.200
    23.973    29.709     0.200
    24.291    29.094     0.200
    24.320    28.785     0.200
    24.367    28.741     0.200
    24.529    29.094     0.200
    24.619    27.865     0.200
    24.787    28.970     0.200
    24.868    28.886     0.200
    24.886    28.553     0.200
    24.948    28.076     0.200
    25.297    29.321     0.200
    25.628    26.378     0.200
    25.910    25.197     0.200
    25.910    25.392     0.200
    26.411    23.294     0.200
    26.411    23.950     0.200
    26.411    23.927     0.200
    26.411    23.552     0.200
    26.740    23.015     0.200
    27.058    24.697     0.200
    27.201    21.850     0.200
    27.294    20.759     0.200
    27.786    22.740     0.200
    28.094    19.712     0.200
    28.094    19.415     0.200
    28.094    19.813     0.200
    28.774    18.454     0.200
    29.496    18.046     0.200
    29.903    16.904     0.200
    18.900    36.284     0.200
    18.900    38.159     0.200
    20.512    37.731     0.200
    20.520    36.307     0.200
    23.778    33.034     0.200
    23.778    32.685     0.200
    23.778    33.165     0.200
    23.818    36.427     0.200
    24.278    33.301     0.200
    24.284    29.529     0.200
    24.292    34.039     0.200
    24.292    32.260     0.200
    24.292    31.863     0.200
    24.603    32.946     0.200
    24.710    34.143     0.200
    25.027    30.777     0.200
    25.027    30.893     0.200
    25.027    31.457     0.200
    25.084    30.991     0.200
    25.148    31.209     0.200
    25.239    28.086     0.200
    26.006    29.688     0.200
    26.081    29.054     0.200
    26.124    27.159     0.200
    26.372    26.427     0.200
    26.372    28.558     0.200
    27.649    25.470     0.200
    27.649    25.579     0.200
    28.096    25.038     0.200
    28.372    22.557     0.200
    28.784    20.332     0.200
    29.560    19.108     0.200
    29.760    17.851     0.200
    17.510    39.099     0.200
    18.849    35.879     0.200
    18.849    36.000     0.200
    18.849    35.750     0.200
    20.314    37.546     0.200
    20.322    36.585     0.200
    21.484    37.233     0.200
    23.612    34.042     0.200
    23.612    33.480     0.200
    23.936    33.922     0.200
    23.936    33.051     0.200
    24.110    32.154     0.200
    24.124    31.788     0.200
    24.124    32.179     0.200
    24.124    32.163     0.200
    24.839    30.319     0.200
    25.048    30.137     0.200
    25.048    29.644     0.200
    25.047    29.918     0.200
    25.104    30.021     0.200
    25.484    28.914     0.200
    25.788    27.404     0.200
    25.810    28.652     0.200
    26.180    26.234     0.200
    26.180    26.496     0.200
    26.180    26.894     0.200
    27.771    24.536     0.200
    17.305    39.224     0.200
    24.198    32.145     0.200
    24.198    31.715     0.200
    24.198    31.934     0.200
    25.037    30.367     0.200
    17.313    39.331     0.200
    18.798    37.353     0.200
    18.798    37.713     0.200
    18.798    36.006     0.200
    20.401    37.570     0.200
    20.409    37.198     0.200
    21.376    36.072     0.200
    22.440    35.668     0.200
    23.738    34.405     0.200
    24.236    33.042     0.200
    24.250    32.777     0.200
    24.250    33.309     0.200
    24.250    32.852     0.200
    24.250    33.426     0.200
    24.959    30.828     0.200
    24.959    30.703     0.200
    24.958    30.906     0.200
    25.016    30.381     0.200
    25.057    30.548     0.200
    15.605    38.844     0.200
    18.815    35.266     0.200
    21.466    35.872     0.200
    24.118    32.423     0.200
    24.118    31.929     0.200
    24.118    32.093     0.200
    25.022    29.785     0.200
    16.985    39.033     0.200
    17.258    37.152     0.200
    17.658    37.460     0.200
    18.588    37.053     0.200
    18.588    36.178     0.200
    19.518    37.916     0.200
    19.518    37.682     0.200
    20.279    34.317     0.200
    21.235    35.178     0.200
    23.232    34.563     0.200
    23.726    34.547     0.200
    23.726    33.707     0.200
    23.754    32.521     0.200
    24.264    30.490     0.200
    24.264    31.142     0.200
    24.264    30.334     0.200
    24.264    30.752     0.200
    24.782    29.472     0.200
    24.782    28.746     0.200
    24.782    29.449     0.200
    24.857    29.372     0.200
    25.073    27.322     0.200
    27.566    23.608     0.200
    27.566    22.839     0.200
    28.255    20.882     0.200
    29.995    17.752     0.200
    17.374    39.070     0.200
    24.158    32.667     0.200
    24.158    31.558     0.200
    25.022    28.997     0.200
    16.906    39.345     0.200
    16.906    39.345     0.200
    17.527    38.429     0.200
    17.921    39.408     0.200
    18.204    38.785     0.200
    18.859    37.059     0.200
    18.859    35.763     0.200
    18.859    35.872     0.200
    19.746    35.795     0.200
    20.310    35.571     0.200
    21.501    35.986     0.200
    22.584    34.379     0.200
    23.593    33.372     0.200
    23.593    33.162     0.200
    23.955    35.316     0.200
    23.955    32.156     0.200
    24.092    31.894     0.200
    24.106    31.829     0.200
    24.106    31.810     0.200
    24.106    32.032     0.200
    24.858    29.153     0.200
    25.062    30.066     0.200
    25.062    28.636     0.200
    25.136    28.499     0.200
    26.164    25.990     0.200
    27.778    22.608     0.200
    27.790    24.398     0.200
    29.710    17.704     0.200
    17.517    38.611     0.200
    18.824    34.964     0.200
    18.824    35.261     0.200
    18.824    36.207     0.200
    19.752    37.432     0.200
    20.264    36.306     0.200
    20.321    36.147     0.200
    22.186    34.300     0.200
    23.571    31.711     0.200
    23.571    31.922     0.200
    23.571    31.281     0.200
    23.931    31.845     0.200
    23.961    34.782     0.200
    24.069    31.500     0.200
    24.083    31.838     0.200
    24.083    31.260     0.200
    24.083    31.767     0.200
    24.867    29.469     0.200
    25.042    29.615     0.200
    25.042    29.643     0.200
    24.987    27.686     0.200
    25.099    28.508     0.200
    25.294    29.790     0.200
    25.817    28.520     0.200
    25.927    25.020     0.200
    26.129    26.069     0.200
    26.129    25.709     0.200
    26.129    25.858     0.200
    26.129    26.264     0.200
    26.195    28.934     0.200
    26.195    27.606     0.200
    27.366    23.912     0.200
    27.798    23.477     0.200
    17.409    37.872     0.200
    17.518    40.154     0.200
    18.197    39.019     0.200
    18.863    36.173     0.200
    18.863    37.322     0.200
    18.863    36.345     0.200
    18.863    37.103     0.200
    20.326    37.290     0.200
    20.334    36.603     0.200
    23.614    34.013     0.200
    24.113    32.631     0.200
    24.127    32.773     0.200
    24.127    31.976     0.200
    24.127    32.968     0.200
    24.127    32.429     0.200
    25.058    30.160     0.200
    25.058    29.051     0.200
    15.140    37.313     0.200
    15.632    38.172     0.200
    16.957    37.137     0.200
    17.333    36.612     0.200
    18.710    36.138     0.200
    18.710    35.286     0.200
    19.808    35.395     0.200
    19.808    35.286     0.200
    20.070    34.289     0.200
    21.490    34.885     0.200
    22.672    34.707     0.200
    23.455    31.692     0.200
    23.528    32.805     0.200
    23.951    30.020     0.200
    23.965    30.631     0.200
    23.965    29.701     0.200
    23.965    30.061     0.200
    23.965    29.928     0.200
    24.016    33.181     0.200
    24.016    31.509     0.200
    24.812    26.480     0.200
    24.993    27.857     0.200
    24.992    27.471     0.200
    24.913    29.689     0.200
    25.145    29.086     0.200
    25.969    25.577     0.200
    25.969    24.359     0.200
    25.969    23.327     0.200
    26.027    25.968     0.200
    26.388    26.185     0.200
    26.533    25.272     0.200
    27.666    22.367     0.200
    27.795    21.486     0.200
    27.965    21.771     0.200
    28.394    20.356     0.200
    29.750    15.413     0.200
    29.817    16.459     0.200
    17.565    38.714     0.200
    19.023    35.373     0.200
    19.023    35.576     0.200
    19.023    35.173     0.200
    19.702    38.697     0.200
    20.549    36.465     0.200
    23.911    34.910     0.200
    24.221    30.705     0.200
    24.235    30.643     0.200
    24.235    31.120     0.200
    24.970    32.202     0.200
    25.149    29.777     0.200
    25.149    29.116     0.200
    25.233    28.144     0.200
    26.077    29.497     0.200
    26.351    25.447     0.200
    26.673    26.630     0.200
    27.739    23.910     0.200
    27.779    22.937     0.200
    29.544    16.466     0.200
    17.430    38.392     0.200
    17.494    38.357     0.200
    18.941    36.239     0.200
    18.941    36.364     0.200
    20.512    36.621     0.200
    20.520    34.157     0.200
    21.461    35.200     0.200
    23.749    32.176     0.200
    23.749    31.606     0.200
    24.263    30.294     0.200
    24.263    30.501     0.200
    24.263    29.805     0.200
    25.071    29.119     0.200
    25.071    28.552     0.200
    26.355    26.926     0.200
    15.160    37.926     0.200
    17.016    37.811     0.200
    18.323    34.423     0.200
    18.323    34.727     0.200
    18.323    36.376     0.200
    18.323    35.536     0.200
    19.327    35.008     0.200
    19.919    35.141     0.200
    20.207    36.477     0.200
    20.996    34.310     0.200
    22.206    33.511     0.200
    23.060    32.381     0.200
    23.535    34.220     0.200
    23.535    31.111     0.200
    23.938    30.687     0.200
    23.877    31.052     0.200
    23.877    31.189     0.200
    24.449    29.043     0.200
    24.384    29.407     0.200
    24.384    29.079     0.200
    24.384    29.196     0.200
    24.522    29.142     0.200
    24.522    28.740     0.200
    24.579    28.769     0.200
    24.589    29.672     0.200
    25.131    27.858     0.200
    25.419    26.638     0.200
    25.466    27.336     0.200
    25.496    26.569     0.200
    25.552    26.174     0.200
    25.929    24.753     0.200
    26.291    26.709     0.200
    26.291    24.267     0.200
    26.291    23.740     0.200
    26.372    23.605     0.200
    26.406    24.162     0.200
    26.789    22.714     0.200
    27.301    21.384     0.200
    27.684    20.972     0.200
    28.332    18.613     0.200
    28.374    19.081     0.200
    28.558    18.223     0.200
    28.598    17.664     0.200
    28.984    17.399     0.200
    29.237    16.329     0.200
    29.280    15.937     0.200
    29.295    15.942     0.200
    29.296    16.290     0.200
    29.362    15.643     0.200
    29.554    15.560     0.200
    29.684    14.985     0.200
    29.837    15.115     0.200
    29.849    15.802     0.200
    18.299    36.623     0.200
    21.240    35.237     0.200
    24.401    29.372     0.200
    24.401    30.212     0.200
    24.496    30.345     0.200
    24.496    30.680     0.200
    24.565    29.624     0.200
    24.401    29.712     0.200
    18.266    34.618     0.200
    18.266    34.974     0.200
    18.266    34.099     0.200
    23.864    30.210     0.200
    23.864    30.320     0.200
    24.370    29.024     0.200
    24.370    28.990     0.200
    24.370    28.455     0.200
    24.481    28.212     0.200
    24.481    28.082     0.200
    24.538    29.500     0.200
    26.258    25.685     0.200
    18.356    38.409     0.200
    18.356    38.303     0.200
    20.718    35.335     0.200
    20.726    35.462     0.200
    24.358    32.755     0.200
    24.883    30.750     0.200
    24.883    30.372     0.200
    24.883    30.551     0.200
    29.375    20.065     0.200
    29.828    17.873     0.200
    24.407    31.321     0.200
    24.537    30.451     0.200
    18.910    40.488     0.200
    21.136    36.642     0.200
    21.146    36.226     0.200
    21.136    36.851     0.200
    22.764    34.553     0.200
    22.820    35.613     0.200
    23.554    35.157     0.200
    23.987    34.694     0.200
    24.557    33.135     0.200
    25.339    30.979     0.200
    25.668    30.430     0.200
    25.702    28.556     0.200
    26.076    29.055     0.200
    26.200    27.629     0.200
    26.200    27.549     0.200
    26.431    25.548     0.200
    26.855    27.603     0.200
    27.216    26.567     0.200
    27.477    25.992     0.200
    27.668    25.268     0.200
    27.810    22.510     0.200
    27.810    22.920     0.200
    27.978    25.487     0.200
    27.978    24.397     0.200
    28.843    21.337     0.200
    29.339    19.122     0.200
    29.758    18.515     0.200
    29.783    17.861     0.200
    18.776    36.472     0.200
    18.982    39.012     0.200
    18.982    38.691     0.200
    20.781    38.124     0.200
    21.114    36.467     0.200
    21.382    37.075     0.200
    21.769    37.365     0.200
    22.634    34.980     0.200
    23.191    36.341     0.200
    24.227    35.002     0.200
    24.484    32.562     0.200
    24.484    31.335     0.200
    24.484    31.683     0.200
    24.660    31.225     0.200
    24.660    30.706     0.200
    24.924    31.115     0.200
    24.998    29.563     0.200
    25.317    31.682     0.200
    25.317    30.651     0.200
    25.917    26.542     0.200
    26.822    24.770     0.200
    27.012    26.565     0.200
    27.072    24.503     0.200
    29.325    20.594     0.200
    17.138    38.669     0.200
    18.464    36.433     0.200
    18.464    36.605     0.200
    18.966    39.979     0.200
    20.629    38.285     0.200
    20.791    36.827     0.200
    22.656    36.406     0.200
    23.133    36.138     0.200
    23.880    34.506     0.200
    24.263    33.991     0.200
    24.365    30.844     0.200
    24.365    31.324     0.200
    24.365    32.113     0.200
    24.450    30.978     0.200
    24.450    30.557     0.200
    24.648    31.341     0.200
    24.876    30.186     0.200
    24.876    29.909     0.200
    25.393    29.873     0.200
    25.511    29.345     0.200
    25.658    26.856     0.200
    25.807    29.143     0.200
    26.007    27.576     0.200
    26.108    27.231     0.200
    26.315    27.833     0.200
    26.568    26.988     0.200
    26.564    27.143     0.200
    26.727    24.482     0.200
    26.852    24.904     0.200
    26.852    25.607     0.200
    26.852    25.127     0.200
    26.852    24.670     0.200
    27.007    25.598     0.200
    27.031    24.999     0.200
    27.196    25.513     0.200
    27.340    24.611     0.200
    27.485    23.923     0.200
    27.727    23.193     0.200
    27.911    23.921     0.200
    27.954    22.294     0.200
    28.483    21.349     0.200
    28.487    21.976     0.200
    28.917    20.570     0.200
    29.355    19.390     0.200
    29.636    18.442     0.200
    29.949    17.689     0.200
    14.443    41.631     0.200
    26.783    30.088     0.200
    23.129    29.420     0.200
    23.129    30.514     0.200
    17.838    39.402     0.200
    18.844    39.536     0.200
    18.844    40.258     0.200
    23.983    33.586     0.200
    24.770    34.276     0.200
    21.466    37.627     0.200
    21.466    37.479     0.200
    21.640    40.714     0.200
    22.532    37.712     0.200
    22.534    37.710     0.200
    25.048    34.367     0.200
    26.096    29.852     0.200
    26.096    29.196     0.200
    26.096    29.305     0.200
    26.804    26.287     0.200
    27.586    27.431     0.200
    29.271    22.998     0.200
    22.249    36.925     0.200
    23.909    32.479     0.200
    23.909    32.300     0.200
    23.968    34.118     0.200
    24.826    30.754     0.200
    25.261    28.397     0.200
    25.851    30.071     0.200
    26.269    26.233     0.200
    26.429    25.679     0.200
    18.643    36.752     0.200
    23.617    35.215     0.200
    26.429    26.015     0.200
    27.453    24.485     0.200
    29.854    18.553     0.200
    18.562    36.504     0.200
    18.562    36.683     0.200
    22.103    37.626     0.200
    22.752    37.934     0.200
    23.471    35.966     0.200
    24.051    32.336     0.200
    24.051    31.500     0.200
    24.051    32.500     0.200
    24.645    30.655     0.200
    24.706    30.718     0.200
    25.373    27.199     0.200
    25.354    30.791     0.200
    26.413    26.065     0.200
    26.552    25.653     0.200
    27.307    24.895     0.200
    20.701    39.565     0.200
    22.062    37.879     0.200
    22.714    36.118     0.200
    23.437    35.451     0.200
    23.779    35.372     0.200
    24.103    30.912     0.200
    24.103    31.149     0.200
    24.647    30.220     0.200
    25.319    30.404     0.200
    25.659    31.138     0.200
    26.616    24.300     0.200
    26.616    24.439     0.200
    27.271    24.962     0.200
    16.998    37.840     0.200
    18.511    36.487     0.200
    24.406    31.004     0.200
    24.638    30.218     0.200
    24.630    29.361     0.200
    24.730    29.780     0.200
    25.635    27.041     0.200
    26.608    26.062     0.200
    28.931    18.736     0.200
    29.140    18.961     0.200
    18.554    36.555     0.200
    24.132    33.621     0.200
    24.421    31.897     0.200
    24.669    30.680     0.200
    24.769    29.921     0.200
    24.970    31.120     0.200
    20.618    35.473     0.200
    20.618    35.363     0.200
    23.264    33.681     0.200
    24.235    29.451     0.200
    25.498    24.814     0.200
    26.603    22.712     0.200
    26.697    22.809     0.200
    27.100    23.372     0.200
    21.901    35.529     0.200
    23.623    34.380     0.200
    24.450    29.294     0.200
    24.511    29.087     0.200
    25.148    29.371     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     0.456     5.225     0.200
     4.693    14.278     0.200
     4.713    13.247     0.200
     5.134    14.932     0.200
     5.267    13.681     0.200
     5.347    16.343     0.200
     6.740    18.495     0.200
     8.382    21.226     0.200
     8.583    20.686     0.200
     8.760    21.319     0.200
     8.972    20.838     0.200
    10.019    24.820     0.200
    10.163    26.846     0.200
    10.373    24.693     0.200
    11.691    28.114     0.200
    11.847    26.488     0.200
    11.847    26.288     0.200
    12.323    28.336     0.200
    14.198    29.759     0.200
    15.595    35.956     0.200
     0.395     5.235     0.200
     5.273    13.613     0.200
     5.319    16.976     0.200
     6.701    18.740     0.200
     8.337    21.156     0.200
     8.566    19.574     0.200
     8.740    20.749     0.200
     8.955    21.738     0.200
    10.125    26.487     0.200
    10.360    24.546     0.200
    11.645    28.050     0.200
    11.817    25.439     0.200
    11.817    26.239     0.200
    12.546    28.827     0.200
    14.226    30.430     0.200
     5.141    13.200     0.200
     5.556    18.358     0.200
     6.775    18.829     0.200
     8.448    22.213     0.200
     8.531    20.341     0.200
     8.721    21.224     0.200
     8.924    20.354     0.200
    10.309    24.794     0.200
    10.393    28.407     0.200
    11.606    30.649     0.200
    11.756    29.100     0.200
    11.847    26.643     0.200
    11.847    26.442     0.200
    11.878    27.981     0.200
    13.998    29.737     0.200
     0.737     6.361     0.200
     5.165    14.176     0.200
     6.840    20.329     0.200
     8.518    22.654     0.200
     8.576    21.981     0.200
     8.797    22.297     0.200
     9.029    23.394     0.200
    10.350    26.073     0.200
    10.413    28.535     0.200
    11.826    30.841     0.200
    11.904    26.540     0.200
    12.150    29.965     0.200
    13.994    31.950     0.200
     5.026    14.362     0.200
     6.795    19.819     0.200
     8.490    23.132     0.200
     8.675    21.379     0.200
     8.654    22.624     0.200
     8.870    21.604     0.200
    10.240    25.412     0.200
    10.602    28.794     0.200
    11.797    29.741     0.200
    11.832    26.340     0.200
    11.832    27.258     0.200
    11.832    26.340     0.200
    11.998    29.300     0.200
    13.817    32.370     0.200
    15.664    36.713     0.200
     4.958    13.017     0.200
     6.663    18.706     0.200
     8.353    22.698     0.200
     8.827    21.660     0.200
    10.590    28.296     0.200
    11.660    29.599     0.200
    18.158    35.765     0.200
     4.960    14.021     0.200
     6.734    18.914     0.200
     8.433    22.392     0.200
     8.863    23.378     0.200
    10.174    24.776     0.200
    10.174    26.678     0.200
    10.652    28.190     0.200
    11.739    29.408     0.200
    11.768    24.975     0.200
    11.768    25.975     0.200
    11.933    28.743     0.200
    13.759    31.440     0.200
     5.071    14.116     0.200
     6.805    19.268     0.200
     8.495    22.669     0.200
     8.900    21.826     0.200
    10.538    26.510     0.200
    11.802    29.750     0.200
    11.852    25.375     0.200
    11.852    27.500     0.200
    11.852    29.172     0.200
    12.047    29.392     0.200
     5.251    14.105     0.200
     8.525    22.704     0.200
     9.026    22.453     0.200
     9.085    22.461     0.200
    10.413    25.666     0.200
    10.290    29.199     0.200
    11.381    27.566     0.200
    11.834    30.787     0.200
    11.940    26.041     0.200
    11.940    28.541     0.200
    14.107    30.958     0.200
    16.731    35.638     0.200
     8.561    20.629     0.200
     8.953    20.847     0.200
    10.341    24.648     0.200
    10.331    28.260     0.200
    11.575    27.043     0.200
    11.761    28.879     0.200
    11.866    25.852     0.200
    13.972    31.074     0.200
    15.785    37.120     0.200
     5.768    15.489     0.200
     8.616    23.249     0.200
     9.381    23.322     0.200
     9.607    26.888     0.200
    10.800    26.062     0.200
    11.918    30.020     0.200
    12.184    26.912     0.200
    14.746    31.515     0.200
    18.708    36.282     0.200
     5.108    13.659     0.200
     6.821    19.361     0.200
     8.506    22.602     0.200
     8.533    20.079     0.200
     8.730    20.889     0.200
     8.738    21.693     0.200
    10.491    28.238     0.200
    11.814    29.295     0.200
    11.874    26.098     0.200
    12.087    28.307     0.200
    13.358    31.072     0.200
    13.921    30.603     0.200
    16.744    36.163     0.200
     5.629    16.505     0.200
     5.831    17.427     0.200
     5.884    17.405     0.200
     6.162    17.541     0.200
     6.254    18.420     0.200
     6.349    18.404     0.200
     7.132    20.724     0.200
     7.202    19.655     0.200
     7.288    21.273     0.200
     7.325    19.387     0.200
     7.327    19.626     0.200
     7.349    20.382     0.200
     7.364    22.213     0.200
     7.364    21.611     0.200
     7.520    21.606     0.200
     8.067    23.416     0.200
     8.103    23.727     0.200
     8.216    23.079     0.200
     8.231    21.883     0.200
     8.248    23.511     0.200
     8.270    22.024     0.200
     8.729    22.296     0.200
     8.754    23.034     0.200
     8.889    23.648     0.200
     8.947    22.494     0.200
     8.969    22.028     0.200
     9.108    22.558     0.200
     9.148    23.634     0.200
     9.359    23.935     0.200
     9.359    24.365     0.200
     9.477    23.548     0.200
     9.556    22.594     0.200
     9.590    24.362     0.200
     9.670    23.278     0.200
     9.989    24.645     0.200
    10.119    24.877     0.200
    10.303    26.781     0.200
    10.337    26.886     0.200
    10.416    26.507     0.200
    10.489    24.917     0.200
    10.758    27.249     0.200
    11.251    26.866     0.200
    11.317    26.702     0.200
    11.422    27.456     0.200
    11.558    26.929     0.200
    11.756    27.776     0.200
    12.062    31.232     0.200
    12.235    26.608     0.200
    12.235    27.408     0.200
    12.670    30.117     0.200
    14.500    32.875     0.200
     5.367    14.043     0.200
     5.557    16.465     0.200
     5.893    17.880     0.200
     5.990    18.189     0.200
     6.076    18.047     0.200
     6.282    18.404     0.200
     6.628    20.398     0.200
     6.856    18.783     0.200
     6.930    19.334     0.200
     7.050    21.246     0.200
     7.090    20.895     0.200
     7.825    20.934     0.200
     7.830    19.087     0.200
     7.867    20.704     0.200
     7.958    21.637     0.200
     7.999    20.750     0.200
     8.271    21.524     0.200
     8.455    21.268     0.200
     8.498    21.807     0.200
     8.616    23.190     0.200
     8.622    21.028     0.200
     8.638    22.514     0.200
     8.696    21.873     0.200
     8.839    21.805     0.200
     8.874    23.260     0.200
     9.086    23.852     0.200
     9.204    22.634     0.200
     9.282    23.211     0.200
     9.384    22.389     0.200
     9.400    22.924     0.200
     9.512    22.709     0.200
     9.579    21.986     0.200
     9.849    23.925     0.200
     9.888    23.775     0.200
     9.994    23.507     0.200
    10.115    25.407     0.200
    10.217    24.014     0.200
    10.485    25.285     0.200
    11.048    25.852     0.200
    11.157    26.792     0.200
    11.491    26.974     0.200
    11.500    27.076     0.200
    11.806    28.744     0.200
    11.818    25.769     0.200
    11.913    28.306     0.200
    11.964    27.131     0.200
    11.964    27.233     0.200
    14.276    33.253     0.200
     5.274    15.193     0.200
     5.274    15.295     0.200
     5.451    17.332     0.200
     5.794    17.103     0.200
     5.875    18.469     0.200
     5.885    18.665     0.200
     5.891    18.752     0.200
     5.907    18.743     0.200
     5.912    18.732     0.200
     5.969    18.447     0.200
     6.177    18.898     0.200
     6.522    19.261     0.200
     6.540    19.367     0.200
     6.593    22.311     0.200
     6.748    18.995     0.200
     6.748    19.597     0.200
     6.829    18.724     0.200
     6.945    20.328     0.200
     6.969    20.055     0.200
     7.069    19.666     0.200
     7.118    19.259     0.200
     7.281    20.679     0.200
     7.649    21.440     0.200
     7.656    24.436     0.200
     7.687    21.960     0.200
     7.692    21.601     0.200
     7.718    21.949     0.200
     7.723    21.261     0.200
     7.731    21.641     0.200
     7.754    21.760     0.200
     7.760    21.283     0.200
     7.855    20.081     0.200
     7.855    20.581     0.200
     7.898    19.770     0.200
     8.169    20.935     0.200
     8.349    21.816     0.200
     8.391    21.827     0.200
     8.391    22.327     0.200
     8.509    23.327     0.200
     8.535    21.629     0.200
     8.591    21.488     0.200
     8.768    23.120     0.200
     8.909    22.777     0.200
     8.981    21.671     0.200
     8.981    21.542     0.200
     9.177    22.672     0.200
     9.286    22.482     0.200
     9.407    22.215     0.200
     9.684    22.971     0.200
     9.748    23.564     0.200
     9.785    23.341     0.200
     9.840    25.767     0.200
     9.897    23.684     0.200
    10.004    24.768     0.200
    10.037    25.316     0.200
    10.080    24.311     0.200
    10.116    24.412     0.200
    10.158    28.504     0.200
    10.398    24.778     0.200
    10.627    26.785     0.200
    10.628    26.543     0.200
    10.833    26.539     0.200
    10.874    25.622     0.200
    10.924    26.528     0.200
    10.949    25.943     0.200
    10.963    27.323     0.200
    11.180    26.081     0.200
    11.266    26.679     0.200
    11.264    27.883     0.200
    11.375    28.367     0.200
    11.394    27.444     0.200
    11.407    27.726     0.200
    11.439    25.614     0.200
    11.653    25.732     0.200
    11.699    28.216     0.200
    11.699    29.017     0.200
    11.710    25.999     0.200
    11.790    27.189     0.200
    11.818    28.533     0.200
    11.856    25.786     0.200
    11.856    25.013     0.200
    11.856    25.587     0.200
    12.032    25.998     0.200
    12.139    33.285     0.200
    12.286    29.320     0.200
    12.946    28.549     0.200
    13.824    28.925     0.200
    14.204    31.090     0.200
    15.169    36.719     0.200
    15.600    37.092     0.200
    16.565    35.326     0.200
     0.452     5.158     0.200
     5.083    12.940     0.200
     5.288    15.542     0.200
     5.336    15.194     0.200
     6.621    17.788     0.200
     7.605    19.956     0.200
     7.683    18.782     0.200
     8.281    21.049     0.200
     8.423    20.061     0.200
     8.605    21.535     0.200
     8.814    22.388     0.200
     9.938    22.398     0.200
    10.355    26.348     0.200
    11.207    26.480     0.200
    11.590    27.730     0.200
    11.711    28.086     0.200
    15.624    36.429     0.200
    16.485    34.495     0.200
     0.382     5.226     0.200
     0.382     5.328     0.200
     5.264    12.251     0.200
     5.264    13.048     0.200
     5.475    15.893     0.200
     5.772    15.982     0.200
     5.840    17.985     0.200
     5.849    17.883     0.200
     5.871    17.764     0.200
     5.876    17.649     0.200
     5.925    17.153     0.200
     6.139    17.777     0.200
     6.481    17.756     0.200
     6.548    18.186     0.200
     6.564    19.088     0.200
     6.688    17.626     0.200
     6.802    17.586     0.200
     6.904    18.857     0.200
     6.925    19.588     0.200
     7.025    20.091     0.200
     7.090    18.062     0.200
     7.237    19.117     0.200
     7.603    20.487     0.200
     7.617    22.956     0.200
     7.641    20.936     0.200
     7.678    20.004     0.200
     7.822    19.394     0.200
     7.822    19.597     0.200
     7.871    18.882     0.200
     8.139    20.442     0.200
     8.323    20.546     0.200
     8.323    20.749     0.200
     8.307    20.587     0.200
     8.461    21.711     0.200
     8.504    20.660     0.200
     8.555    20.138     0.200
     8.728    20.921     0.200
     8.898    21.140     0.200
     8.944    20.307     0.200
     8.944    21.010     0.200
    10.088    22.793     0.200
    10.129    25.478     0.200
    10.129    25.775     0.200
    11.632    26.940     0.200
    11.632    27.541     0.200
    11.805    24.529     0.200
    11.805    24.888     0.200
    11.805    24.919     0.200
    11.805    25.021     0.200
    12.136    31.755     0.200
    14.220    29.543     0.200
    15.121    35.105     0.200
    15.508    35.908     0.200
    16.488    34.263     0.200
    16.488    34.966     0.200
     5.566    18.572     0.200
     5.793    20.532     0.200
     5.985    19.909     0.200
     5.987    20.066     0.200
     6.093    19.840     0.200
     6.641    21.506     0.200
     6.688    21.019     0.200
     6.853    20.265     0.200
     6.964    21.290     0.200
     7.057    22.701     0.200
     7.057    22.697     0.200
     7.094    21.773     0.200
     7.183    22.756     0.200
     7.844    24.934     0.200
     7.861    24.166     0.200
     7.887    22.331     0.200
     7.905    24.080     0.200
     8.201    24.060     0.200
     8.451    24.384     0.200
     8.652    23.653     0.200
     8.660    23.785     0.200
     8.825    23.165     0.200
     9.056    26.374     0.200
     9.476    25.429     0.200
     9.475    24.334     0.200
     9.758    25.994     0.200
     9.838    26.715     0.200
    10.135    26.064     0.200
    10.428    28.069     0.200
    10.457    30.015     0.200
    10.869    28.329     0.200
    10.939    28.351     0.200
    11.353    29.351     0.200
    11.959    31.441     0.200
    12.011    27.384     0.200
    12.011    27.681     0.200
    16.072    39.990     0.200
     5.755    18.754     0.200
     5.776    16.451     0.200
     5.776    17.053     0.200
     5.892    18.104     0.200
     6.277    18.415     0.200
     6.335    19.662     0.200
     6.363    18.649     0.200
     6.394    19.852     0.200
     6.622    20.158     0.200
     6.932    21.235     0.200
     7.062    21.719     0.200
     7.106    19.930     0.200
     7.301    20.264     0.200
     7.603    22.398     0.200
     8.149    24.102     0.200
     8.178    23.721     0.200
     8.314    21.834     0.200
     8.314    22.436     0.200
     8.705    22.278     0.200
     8.705    22.579     0.200
     9.009    22.515     0.200
     9.041    23.157     0.200
     9.070    22.835     0.200
     9.206    23.326     0.200
     9.410    23.149     0.200
     9.427    23.520     0.200
     9.427    24.047     0.200
     9.427    23.746     0.200
     9.653    27.011     0.200
     9.653    26.812     0.200
     9.627    25.261     0.200
     9.678    24.047     0.200
     9.856    23.323     0.200
    10.840    26.457     0.200
    12.008    28.725     0.200
    12.008    29.424     0.200
    12.251    27.996     0.200
    12.251    26.496     0.200
    12.251    25.996     0.200
    12.649    33.850     0.200
    14.719    33.287     0.200
    15.258    34.198     0.200
    15.571    36.846     0.200
     0.540     5.089     0.200
     5.274    13.935     0.200
     6.796    18.738     0.200
     7.765    23.140     0.200
     7.793    22.217     0.200
     7.875    21.419     0.200
     8.447    21.688     0.200
     8.615    22.006     0.200
     8.796    22.893     0.200
     9.006    24.046     0.200
     9.431    23.521     0.200
    10.107    25.894     0.200
    10.198    27.453     0.200
    10.402    25.757     0.200
    11.400    26.780     0.200
    11.756    30.525     0.200
    11.895    27.828     0.200
    11.895    28.428     0.200
    14.177    31.462     0.200
     5.802    15.645     0.200
     5.802    15.845     0.200
     5.890    18.237     0.200
     6.004    17.921     0.200
     6.059    17.882     0.200
     6.337    17.351     0.200
     6.428    20.303     0.200
     6.521    20.248     0.200
     7.377    21.675     0.200
     8.907    24.410     0.200
     9.144    23.950     0.200
     9.534    23.801     0.200
     9.767    26.374     0.200
     9.767    26.874     0.200
    10.933    27.373     0.200
    12.214    31.408     0.200
    12.403    30.984     0.200
    12.551    27.486     0.200
    14.588    33.320     0.200
    15.269    35.568     0.200
     0.833     5.803     0.200
     2.796    12.541     0.200
     5.743    16.502     0.200
     8.178    23.127     0.200
     8.318    22.567     0.200
     8.777    22.091     0.200
     8.777    22.790     0.200
     9.051    23.393     0.200
     9.224    24.781     0.200
     9.440    22.360     0.200
     9.440    22.860     0.200
     9.754    24.692     0.200
     9.754    25.092     0.200
     9.867    23.674     0.200
    10.845    26.463     0.200
    12.083    27.510     0.200
    12.083    28.209     0.200
    12.291    27.083     0.200
    12.291    27.683     0.200
    12.442    26.620     0.200
    14.501    32.096     0.200
    15.218    36.129     0.200
     5.855    17.317     0.200
     6.499    23.060     0.200
     8.959    25.135     0.200
     9.199    25.646     0.200
     9.589    25.096     0.200
     9.708    26.913     0.200
     9.785    27.508     0.200
     9.881    26.887     0.200
    10.392    27.029     0.200
    10.558    29.384     0.200
    10.639    29.745     0.200
    10.719    27.908     0.200
    10.831    28.507     0.200
    10.988    28.171     0.200
    11.547    28.849     0.200
    11.985    30.588     0.200
    12.266    32.457     0.200
    12.606    28.487     0.200
    12.606    28.887     0.200
     5.600    15.185     0.200
     5.624    14.796     0.200
     6.242    18.182     0.200
     6.836    18.950     0.200
     7.060    19.736     0.200
     8.067    21.977     0.200
     8.683    23.400     0.200
     9.325    22.800     0.200
     9.752    23.020     0.200
     9.859    28.072     0.200
    10.729    26.521     0.200
    11.745    28.055     0.200
    11.990    31.113     0.200
    12.148    27.534     0.200
    12.333    26.697     0.200
    14.529    33.279     0.200
    14.783    37.312     0.200
    16.819    36.451     0.200
     0.297     5.769     0.200
     5.204    13.632     0.200
     5.231    14.109     0.200
     5.806    16.612     0.200
     6.396    18.022     0.200
     6.615    17.949     0.200
     8.245    20.908     0.200
     8.500    22.066     0.200
     8.888    21.063     0.200
     9.316    22.229     0.200
    10.296    25.002     0.200
    10.127    26.843     0.200
    11.338    26.340     0.200
    11.553    29.235     0.200
    11.702    25.973     0.200
    11.888    26.132     0.200
    14.211    32.118     0.200
    19.358    36.451     0.200
     1.263     7.982     0.200
     1.263     7.788     0.200
     1.283     7.956     0.200
     1.294     8.219     0.200
     1.367     9.276     0.200
     1.395     8.844     0.200
     1.390     7.504     0.200
     1.422     8.230     0.200
     1.427     7.968     0.200
     1.575     8.842     0.200
     1.729    10.343     0.200
     4.095    13.036     0.200
     4.170    12.959     0.200
     4.071    14.222     0.200
     4.120    14.550     0.200
     4.236    13.291     0.200
     4.300    13.449     0.200
     4.202    14.384     0.200
     4.240    14.343     0.200
     4.608    13.855     0.200
     4.609    13.434     0.200
     4.730    13.830     0.200
     4.751    14.076     0.200
     4.780    14.246     0.200
     4.926    14.738     0.200
     5.108    13.909     0.200
     5.419    16.184     0.200
     5.666    17.705     0.200
     5.799    17.152     0.200
     5.822    17.587     0.200
     5.927    17.662     0.200
     6.435    18.730     0.200
     6.461    19.226     0.200
     6.482    19.084     0.200
     6.529    19.235     0.200
     6.718    17.822     0.200
     6.855    20.326     0.200
     6.924    19.720     0.200
     6.934    20.405     0.200
     7.020    20.205     0.200
     8.064    22.017     0.200
     8.387    20.651     0.200
     8.453    22.838     0.200
     8.512    21.794     0.200
     8.690    20.519     0.200
     8.704    23.546     0.200
     8.740    22.631     0.200
     8.905    24.100     0.200
    10.287    25.279     0.200
    11.761    30.669     0.200
    11.973    25.854     0.200
     0.236     4.938     0.200
     0.543     4.733     0.200
     0.908     6.900     0.200
     0.986     6.987     0.200
     0.980     6.961     0.200
     0.995     7.182     0.200
     1.004     7.386     0.200
     1.086     7.820     0.200
     1.111     7.733     0.200
     1.084     7.448     0.200
     1.118     7.946     0.200
     1.122     7.698     0.200
     1.311     7.502     0.200
     1.425     9.869     0.200
     3.694    13.335     0.200
     3.760    15.021     0.200
     3.886    14.347     0.200
     3.956    15.130     0.200
     4.223    13.714     0.200
     4.281    13.342     0.200
     4.319    13.392     0.200
     4.360    13.615     0.200
     4.428    14.127     0.200
     4.498    13.700     0.200
     4.732    15.078     0.200
     4.743    14.341     0.200
     4.861    15.365     0.200
     4.870    14.858     0.200
     4.915    15.239     0.200
     5.062    15.923     0.200
     5.308    14.856     0.200
     5.557    15.644     0.200
     5.836    16.693     0.200
     5.928    17.122     0.200
     5.944    17.726     0.200
     5.950    18.064     0.200
     6.027    17.762     0.200
     6.231    18.585     0.200
     6.550    18.959     0.200
     6.816    18.251     0.200
     6.875    18.766     0.200
     6.964    19.923     0.200
     7.027    19.990     0.200
     7.041    20.330     0.200
     7.126    20.940     0.200
     7.781    21.480     0.200
     8.216    21.915     0.200
     8.463    20.502     0.200
     8.564    21.155     0.200
     8.643    21.829     0.200
     8.823    23.929     0.200
     8.843    20.604     0.200
    10.107    24.549     0.200
    10.161    28.819     0.200
    11.772    30.620     0.200
    12.062    27.168     0.200
     1.193     7.642     0.200
     1.366     7.909     0.200
     1.408     8.325     0.200
     2.406    10.327     0.200
     2.815    13.351     0.200
     3.452    14.752     0.200
     4.142    13.349     0.200
     4.216    13.308     0.200
     4.282    13.915     0.200
     4.166    15.139     0.200
     4.346    13.982     0.200
     4.405    13.566     0.200
     4.656    13.756     0.200
     4.776    14.372     0.200
     4.973    15.059     0.200
     5.132    13.627     0.200
     5.154    13.625     0.200
     5.713    15.414     0.200
     5.845    16.825     0.200
     6.155    17.536     0.200
     6.575    18.541     0.200
     6.941    20.386     0.200
     7.725    23.126     0.200
     8.388    20.597     0.200
     8.558    21.026     0.200
     8.751    23.281     0.200
     8.952    21.832     0.200
     9.898    24.344     0.200
    10.258    26.589     0.200
    10.334    25.409     0.200
    10.411    27.705     0.200
    10.645    27.411     0.200
    11.802    29.466     0.200
    11.847    28.532     0.200
    12.018    25.400     0.200
     1.362     8.148     0.200
     1.397     8.750     0.200
     1.401     8.598     0.200
     1.424     8.782     0.200
     1.438     8.966     0.200
     1.502     9.835     0.200
     1.533     9.313     0.200
     1.552     8.552     0.200
     1.585     8.863     0.200
     1.699     9.419     0.200
     1.886    11.215     0.200
     2.178     9.737     0.200
     2.285    10.259     0.200
     2.619    12.754     0.200
     2.771    13.181     0.200
     2.991    13.622     0.200
     3.015    13.868     0.200
     3.656    15.118     0.200
     3.988    13.868     0.200
     4.071    13.584     0.200
     4.131    13.874     0.200
     4.192    13.825     0.200
     4.245    13.831     0.200
     4.239    15.590     0.200
     4.499    13.969     0.200
     4.371    15.963     0.200
     4.648    14.659     0.200
     4.668    14.481     0.200
     4.814    15.138     0.200
     4.946    13.735     0.200
     4.967    13.284     0.200
     5.287    15.684     0.200
     5.689    17.362     0.200
     6.002    17.620     0.200
     6.356    18.371     0.200
     6.425    18.655     0.200
     6.596    18.117     0.200
     6.708    18.890     0.200
     6.795    20.133     0.200
     8.228    21.516     0.200
     8.399    21.126     0.200
     8.401    22.275     0.200
     8.568    22.385     0.200
     8.598    22.710     0.200
     8.795    22.695     0.200
     8.896    22.933     0.200
     9.722    24.199     0.200
    10.168    25.483     0.200
    10.254    26.789     0.200
    10.507    24.447     0.200
    10.616    28.524     0.200
    11.714    30.050     0.200
    11.708    28.772     0.200
    11.879    25.617     0.200
    16.622    37.268     0.200
    18.188    36.217     0.200
     2.428    10.396     0.200
     2.505    11.240     0.200
     4.298    14.210     0.200
     4.363    14.174     0.200
     4.502    15.041     0.200
     4.568    14.526     0.200
     5.325    16.079     0.200
     7.087    21.348     0.200
     7.867    23.012     0.200
     7.974    23.007     0.200
     8.578    21.704     0.200
     8.617    22.112     0.200
    10.077    25.000     0.200
    10.245    25.461     0.200
    10.780    27.553     0.200
    11.551    28.628     0.200
    11.887    29.198     0.200
    12.154    25.982     0.200
    17.039    38.197     0.200
     2.855    14.445     0.200
     3.408    15.383     0.200
     3.425    15.045     0.200
     3.478    15.095     0.200
     3.535    15.749     0.200
     3.552    15.487     0.200
     4.763    15.827     0.200
     4.821    15.875     0.200
     4.858    16.036     0.200
     4.900    16.363     0.200
     4.967    16.611     0.200
     4.969    16.170     0.200
     5.036    16.409     0.200
     5.401    16.950     0.200
     5.411    17.432     0.200
     5.601    17.851     0.200
     5.798    16.909     0.200
     5.820    17.366     0.200
     6.047    18.382     0.200
     6.096    18.521     0.200
     7.112    21.201     0.200
     7.117    21.549     0.200
     7.343    21.797     0.200
     7.544    23.006     0.200
     7.568    22.256     0.200
     7.667    23.071     0.200
     7.732    22.675     0.200
     8.322    24.060     0.200
     8.476    22.885     0.200
     8.752    23.866     0.200
     8.974    24.358     0.200
     9.091    23.484     0.200
     9.183    25.327     0.200
     9.689    24.971     0.200
     9.770    23.807     0.200
     9.852    25.222     0.200
     9.796    29.171     0.200
    10.373    24.833     0.200
    10.491    27.560     0.200
    10.696    26.290     0.200
    10.948    27.452     0.200
    11.204    26.380     0.200
    11.519    28.421     0.200
    11.617    29.044     0.200
    11.772    28.306     0.200
    11.953    29.144     0.200
    12.189    31.296     0.200
    12.282    31.463     0.200
    12.601    28.581     0.200
     1.126     7.647     0.200
     1.176     8.202     0.200
     1.177     8.071     0.200
     1.209     8.361     0.200
     1.309     9.148     0.200
     1.314     7.736     0.200
     1.488     8.955     0.200
     1.649    10.586     0.200
     4.089    14.115     0.200
     4.013    15.490     0.200
     4.159    14.290     0.200
     4.180    13.868     0.200
     4.061    15.857     0.200
     4.229    14.452     0.200
     4.114    15.809     0.200
     4.291    14.134     0.200
     4.294    13.516     0.200
     4.356    14.527     0.200
     4.743    15.254     0.200
     4.923    15.473     0.200
     5.104    13.256     0.200
     5.127    13.794     0.200
     5.381    15.829     0.200
     5.417    16.239     0.200
     5.674    16.555     0.200
     5.794    17.481     0.200
     5.830    17.344     0.200
     6.448    19.230     0.200
     6.722    18.072     0.200
     6.744    19.018     0.200
     6.884    21.419     0.200
     7.666    21.937     0.200
     7.762    22.063     0.200
     8.414    22.506     0.200
     8.508    23.237     0.200
     8.900    23.453     0.200
     9.859    24.888     0.200
    10.162    26.827     0.200
    10.389    28.644     0.200
    11.633    29.782     0.200
    11.723    30.411     0.200
    11.783    28.914     0.200
    11.956    26.743     0.200
    12.495    29.803     0.200
    14.618    33.912     0.200
    15.916    34.276     0.200
    16.821    35.924     0.200
     1.155     8.745     0.200
     2.983    14.981     0.200
     3.466    15.493     0.200
     3.466    14.963     0.200
     3.541    15.864     0.200
     4.539    15.454     0.200
     4.597    16.230     0.200
     4.635    15.756     0.200
     4.676    15.923     0.200
     4.743    16.497     0.200
     4.746    15.471     0.200
     4.813    16.120     0.200
     5.059    16.835     0.200
     5.187    17.106     0.200
     5.378    17.587     0.200
     5.587    15.357     0.200
     5.610    16.436     0.200
     5.713    18.747     0.200
     5.822    18.341     0.200
     5.873    17.859     0.200
     5.976    18.842     0.200
     6.147    19.459     0.200
     6.244    19.690     0.200
     6.254    19.648     0.200
     6.259    19.709     0.200
     6.275    19.329     0.200
     6.342    19.606     0.200
     6.547    20.102     0.200
     6.831    20.839     0.200
     6.893    20.954     0.200
     7.122    20.574     0.200
     7.188    20.383     0.200
     7.280    22.185     0.200
     7.343    22.285     0.200
     7.357    23.112     0.200
     7.441    22.831     0.200
     7.515    22.158     0.200
     8.096    22.898     0.200
     8.220    23.640     0.200
     8.256    22.448     0.200
     8.530    23.583     0.200
     8.734    23.565     0.200
     8.758    24.439     0.200
     8.790    23.492     0.200
     8.837    26.233     0.200
     8.959    24.359     0.200
     9.139    24.778     0.200
     9.139    26.208     0.200
     9.157    23.963     0.200
     9.350    24.122     0.200
     9.466    24.970     0.200
     9.546    25.088     0.200
     9.775    23.925     0.200
     9.956    25.732     0.200
     9.938    28.265     0.200
     9.938    28.385     0.200
    10.105    25.533     0.200
    10.585    27.238     0.200
    10.732    27.082     0.200
    10.746    27.757     0.200
    11.002    27.785     0.200
    11.268    28.469     0.200
    11.267    28.002     0.200
    11.380    28.566     0.200
    11.611    29.520     0.200
    11.746    29.438     0.200
    11.746    29.278     0.200
    11.976    30.465     0.200
    12.066    31.095     0.200
    12.195    28.985     0.200
    12.195    28.575     0.200
    12.195    31.845     0.200
    12.377    29.365     0.200
    12.376    29.329     0.200
    12.960    30.484     0.200
    13.871    33.900     0.200
    14.473    35.767     0.200
    15.021    35.363     0.200
    15.521    37.275     0.200
    19.508    40.006     0.200
     3.578    12.859     0.200
     5.648    15.279     0.200
     7.292    20.989     0.200
     9.062    23.032     0.200
     9.253    24.305     0.200
    10.046    27.454     0.200
    10.400    24.848     0.200
    10.838    26.409     0.200
    11.141    27.116     0.200
    11.857    28.112     0.200
    12.258    30.136     0.200
    12.357    27.887     0.200
    12.514    27.699     0.200
    15.683    34.849     0.200
    15.683    35.619     0.200
     0.363     5.609     0.200
     0.844     6.928     0.200
     0.808     6.959     0.200
     0.879     7.304     0.200
     0.976     7.640     0.200
     1.156     7.468     0.200
     1.027     7.544     0.200
     1.022     7.038     0.200
     1.337     9.425     0.200
     1.693    10.246     0.200
     2.211     8.914     0.200
     2.031    10.896     0.200
     2.108    10.882     0.200
     2.252    10.894     0.200
     2.406    11.740     0.200
     2.429    11.507     0.200
     2.505    11.638     0.200
     3.285    12.662     0.200
     3.295    13.051     0.200
     3.691    13.207     0.200
     4.113    13.345     0.200
     3.749    13.826     0.200
     4.213    13.624     0.200
     3.875    14.284     0.200
     4.248    13.843     0.200
     4.395    13.833     0.200
     4.755    14.699     0.200
     5.215    13.718     0.200
     5.329    14.835     0.200
     5.890    17.502     0.200
     6.666    17.953     0.200
     6.778    18.174     0.200
     6.881    20.125     0.200
     6.918    20.385     0.200
     7.655    21.928     0.200
     7.798    20.992     0.200
     8.278    20.738     0.200
     8.531    23.079     0.200
     8.743    21.654     0.200
     8.920    22.896     0.200
     8.614    24.089     0.200
     9.242    22.356     0.200
     9.347    22.707     0.200
     9.643    22.243     0.200
     9.923    24.812     0.200
     9.927    23.974     0.200
     9.962    23.131     0.200
    10.147    26.330     0.200
    11.312    27.590     0.200
    11.610    28.950     0.200
    11.745    28.025     0.200
    11.929    26.220     0.200
    13.981    31.510     0.200
    15.626    33.143     0.200
    15.626    35.432     0.200
    16.999    35.386     0.200
    16.999    35.729     0.200
     1.197     8.037     0.200
     1.189     7.871     0.200
     1.211     8.267     0.200
     1.296     9.164     0.200
     1.320     8.816     0.200
     1.266     7.730     0.200
     1.314     8.339     0.200
     1.315     8.185     0.200
     1.521     9.186     0.200
     1.617    10.439     0.200
     1.908    10.793     0.200
     2.392    10.800     0.200
     2.467    10.861     0.200
     2.677    13.043     0.200
     2.673    13.479     0.200
     2.699    13.368     0.200
     3.434    14.484     0.200
     3.448    14.794     0.200
     3.479    14.937     0.200
     3.819    15.211     0.200
     3.890    15.529     0.200
     3.963    15.097     0.200
     4.017    16.017     0.200
     4.247    13.878     0.200
     4.317    14.354     0.200
     4.338    14.084     0.200
     4.448    14.227     0.200
     4.513    14.404     0.200
     4.758    15.586     0.200
     4.763    14.332     0.200
     4.901    15.196     0.200
     5.080    15.825     0.200
     5.252    13.923     0.200
     5.252    14.884     0.200
     5.431    19.686     0.200
     6.584    19.785     0.200
     6.877    20.405     0.200
     7.042    21.129     0.200
     7.070    21.145     0.200
     7.674    22.174     0.200
     7.825    22.849     0.200
     7.918    21.656     0.200
     8.495    23.396     0.200
     9.058    24.776     0.200
     9.709    24.015     0.200
     9.850    24.859     0.200
    10.012    24.796     0.200
    10.570    28.980     0.200
    10.653    29.222     0.200
    10.980    26.667     0.200
    11.785    29.006     0.200
    11.875    30.705     0.200
    11.941    27.402     0.200
    12.115    27.336     0.200
    12.115    25.933     0.200
    12.650    30.189     0.200
    14.095    32.253     0.200
    14.776    34.419     0.200
    15.849    35.610     0.200
     1.185     8.243     0.200
     1.315     8.930     0.200
     1.378     9.066     0.200
     2.038     9.899     0.200
     1.937    11.697     0.200
     2.333    13.534     0.200
     2.335    13.183     0.200
     3.326    16.033     0.200
     3.474    16.057     0.200
     3.499    17.118     0.200
     3.804    16.224     0.200
     3.881    17.183     0.200
     4.008    17.339     0.200
     4.711    14.940     0.200
     5.338    15.996     0.200
     6.289    21.728     0.200
    10.283    27.594     0.200
    11.364    28.279     0.200
    12.237    27.038     0.200
    12.373    31.694     0.200
    12.787    33.074     0.200
    13.608    33.772     0.200
    13.991    34.239     0.200
     1.255     7.937     0.200
     1.313     8.364     0.200
     1.332     8.507     0.200
     1.430     8.112     0.200
     1.466     8.796     0.200
     1.471     8.566     0.200
     1.799     8.681     0.200
     2.080    11.469     0.200
     2.269    12.204     0.200
     2.289    12.120     0.200
     2.486    12.305     0.200
     2.488    12.136     0.200
     2.774    13.533     0.200
     3.708    12.422     0.200
     3.471    14.566     0.200
     4.114    13.933     0.200
     4.202    13.772     0.200
     4.072    16.089     0.200
     4.381    14.443     0.200
     4.375    13.954     0.200
     4.473    15.209     0.200
     4.465    13.082     0.200
     5.090    14.045     0.200
     5.411    16.322     0.200
     6.355    20.833     0.200
     6.804    19.947     0.200
     6.917    19.021     0.200
     7.702    22.653     0.200
     8.358    22.657     0.200
     8.502    23.839     0.200
     8.923    22.225     0.200
     9.122    25.322     0.200
     9.606    24.195     0.200
     9.861    25.243     0.200
     9.932    24.565     0.200
    10.251    24.514     0.200
    10.625    25.597     0.200
    10.472    27.645     0.200
    11.116    26.271     0.200
    11.997    25.452     0.200
    12.976    31.043     0.200
    13.744    32.187     0.200
    13.951    34.059     0.200
    16.023    38.099     0.200
    16.023    37.638     0.200
     1.337    10.035     0.200
     1.331     9.815     0.200
     1.553    11.033     0.200
     1.566    10.649     0.200
     1.552    10.455     0.200
     2.222    13.073     0.200
     2.433    14.319     0.200
     2.930    15.335     0.200
     3.808    14.838     0.200
     3.705    18.218     0.200
     3.897    15.191     0.200
     4.070    14.991     0.200
     4.185    14.219     0.200
     4.201    16.954     0.200
     4.350    18.229     0.200
     4.803    15.870     0.200
     6.611    22.628     0.200
     7.494    22.921     0.200
     8.818    26.613     0.200
    11.403    30.318     0.200
    11.505    33.800     0.200
    11.691    27.764     0.200
    13.439    34.309     0.200
    13.649    34.175     0.200
     1.228     8.816     0.200
     1.260     8.862     0.200
     1.246     8.400     0.200
     1.469     9.339     0.200
     1.486     9.054     0.200
     1.869     9.146     0.200
     2.160    11.287     0.200
     2.880    13.524     0.200
     2.905    13.736     0.200
     3.132    12.746     0.200
     3.206    13.526     0.200
     3.796    13.757     0.200
     3.980    14.402     0.200
     3.994    14.129     0.200
     3.835    14.051     0.200
     4.073    14.938     0.200
     4.157    12.299     0.200
     4.169    16.429     0.200
     4.377    15.704     0.200
     4.317    16.283     0.200
     4.352    16.187     0.200
     5.807    18.938     0.200
     6.082    18.967     0.200
     6.249    19.127     0.200
     6.382    20.690     0.200
     6.517    20.957     0.200
     6.545    20.240     0.200
     6.641    20.563     0.200
     7.974    23.439     0.200
     8.536    23.919     0.200
     8.706    26.216     0.200
    10.732    27.289     0.200
    11.230    30.481     0.200
    11.590    24.584     0.200
    11.590    27.719     0.200
    13.579    33.150     0.200
    17.915    36.469     0.200
     2.864    13.135     0.200
     2.871    13.341     0.200
     2.918    13.948     0.200
     3.220    13.719     0.200
     3.369    13.924     0.200
     3.426    14.463     0.200
     3.486    14.244     0.200
     4.144    15.802     0.200
     4.822    17.032     0.200
     5.007    16.594     0.200
     5.051    16.209     0.200
     5.115    16.755     0.200
     5.135    17.310     0.200
     5.228    15.265     0.200
     5.838    19.477     0.200
     5.840    16.174     0.200
     5.840    17.174     0.200
     6.049    18.864     0.200
     6.491    20.032     0.200
     6.498    20.294     0.200
     6.777    20.649     0.200
     7.058    21.116     0.200
     7.112    21.449     0.200
     7.312    21.841     0.200
     7.430    20.301     0.200
     7.535    21.797     0.200
     7.543    23.077     0.200
     7.564    22.233     0.200
     7.719    20.378     0.200
     8.061    24.017     0.200
     8.242    23.482     0.200
     8.282    24.422     0.200
     8.317    25.186     0.200
     8.499    22.862     0.200
     8.630    24.383     0.200
     8.906    24.389     0.200
     8.946    24.257     0.200
     9.023    24.921     0.200
     9.581    23.515     0.200
     9.673    27.966     0.200
     9.692    28.013     0.200
     9.884    25.398     0.200
     9.900    24.262     0.200
    10.283    25.003     0.200
    10.539    27.344     0.200
    10.575    26.429     0.200
    10.621    26.867     0.200
    10.822    29.812     0.200
    10.980    26.748     0.200
    11.215    26.237     0.200
    11.666    31.386     0.200
    11.780    27.850     0.200
    12.404    27.769     0.200
    12.590    27.749     0.200
    12.702    30.446     0.200
    13.866    32.246     0.200
    14.126    34.473     0.200
    14.400    32.512     0.200
    14.638    33.833     0.200
    14.730    35.527     0.200
    14.894    35.779     0.200
    16.911    38.669     0.200
    19.751    39.810     0.200
     1.504     9.008     0.200
     1.686     9.066     0.200
     1.740     9.613     0.200
     1.708    10.814     0.200
     1.900    11.010     0.200
     1.902    10.902     0.200
     2.262    11.759     0.200
     2.279    12.011     0.200
     2.905    13.595     0.200
     3.021    13.968     0.200
     3.078    14.174     0.200
     3.390    14.319     0.200
     3.463    14.053     0.200
     3.535    14.319     0.200
     3.589    14.626     0.200
     4.009    14.424     0.200
     4.081    14.495     0.200
     4.695    15.777     0.200
     4.796    15.628     0.200
     5.018    14.368     0.200
     5.628    15.821     0.200
     5.884    17.792     0.200
     7.332    22.128     0.200
     9.470    26.209     0.200
    10.780    27.997     0.200
    10.766    26.528     0.200
    12.383    27.837     0.200
    13.673    31.920     0.200
    14.425    34.404     0.200
     0.368     5.742     0.200
     0.807     6.950     0.200
     0.841     7.018     0.200
     0.864     7.104     0.200
     0.945     7.836     0.200
     1.026     7.595     0.200
     1.037     7.387     0.200
     1.230     7.336     0.200
     1.285     8.083     0.200
     1.379     8.101     0.200
     1.771     8.513     0.200
     1.693     9.271     0.200
     1.904    10.524     0.200
     2.209     9.228     0.200
     2.108    10.551     0.200
     2.110    10.371     0.200
     2.291     9.563     0.200
     2.406    11.741     0.200
     2.499    12.141     0.200
     2.501    12.056     0.200
     3.190    12.989     0.200
     3.295    13.180     0.200
     3.319    13.154     0.200
     3.358    14.084     0.200
     3.556    12.391     0.200
     3.692    13.312     0.200
     3.750    13.966     0.200
     3.825    13.841     0.200
     3.875    15.332     0.200
     4.159    13.546     0.200
     4.343    13.820     0.200
     4.392    13.836     0.200
     4.474    14.687     0.200
     4.616    12.749     0.200
     4.752    14.393     0.200
     4.715    16.400     0.200
     4.791    15.965     0.200
     5.213    13.968     0.200
     5.385    15.946     0.200
     5.330    16.778     0.200
     5.888    17.660     0.200
     6.661    18.875     0.200
     6.776    18.370     0.200
     6.870    19.755     0.200
     6.878    19.206     0.200
     6.999    19.862     0.200
     7.064    18.720     0.200
     7.577    20.767     0.200
     7.618    20.585     0.200
     7.796    20.532     0.200
     7.846    19.904     0.200
     7.966    20.818     0.200
     8.275    21.013     0.200
     8.299    20.928     0.200
     8.361    22.181     0.200
     8.435    21.906     0.200
     8.614    23.787     0.200
     8.740    21.723     0.200
     9.015    23.207     0.200
     9.345    22.790     0.200
     9.431    22.067     0.200
     9.488    25.293     0.200
     9.546    23.197     0.200
     9.725    23.773     0.200
     9.709    24.966     0.200
     9.727    24.816     0.200
     9.880    26.317     0.200
     9.800    25.221     0.200
     9.925    23.622     0.200
     9.960    24.325     0.200
    10.063    23.935     0.200
     9.999    25.646     0.200
    10.325    26.057     0.200
    10.336    24.518     0.200
    10.491    26.010     0.200
    10.540    24.734     0.200
    10.553    27.015     0.200
    10.886    26.474     0.200
    11.117    25.247     0.200
    11.224    27.664     0.200
    11.504    28.025     0.200
    11.577    26.469     0.200
    11.637    27.393     0.200
    11.735    28.520     0.200
    11.743    28.096     0.200
    11.830    28.234     0.200
    11.927    25.648     0.200
    12.636    29.822     0.200
    13.225    31.007     0.200
    13.737    30.438     0.200
    13.979    32.168     0.200
    14.304    32.712     0.200
    16.998    35.717     0.200
     0.429     4.943     0.200
     0.857     6.401     0.200
     0.904     6.998     0.200
     0.905     6.995     0.200
     0.924     7.195     0.200
     0.936     7.181     0.200
     1.060     6.555     0.200
     1.083     6.981     0.200
     1.327     8.323     0.200
     1.384     9.306     0.200
     1.486     8.560     0.200
     1.503     8.793     0.200
     1.793     8.080     0.200
     1.910     9.363     0.200
     2.066    10.659     0.200
     2.141    10.463     0.200
     2.320     9.531     0.200
     2.397     9.890     0.200
     2.529    11.723     0.200
     2.528    11.907     0.200
     2.553    11.937     0.200
     2.888     9.304     0.200
     3.213    12.692     0.200
     3.320    13.149     0.200
     3.341    12.679     0.200
     3.382    13.086     0.200
     3.584    12.709     0.200
     3.613    13.035     0.200
     3.658    12.956     0.200
     3.712    12.966     0.200
     3.773    13.638     0.200
     3.936    13.586     0.200
     3.893    11.434     0.200
     3.972    13.549     0.200
     4.371    13.950     0.200
     4.413    13.586     0.200
     4.477    14.181     0.200
     4.497    14.110     0.200
     4.652    15.210     0.200
     4.617    12.926     0.200
     4.713    16.098     0.200
     4.778    15.070     0.200
     4.842    16.762     0.200
     5.219    13.543     0.200
     5.219    13.068     0.200
     5.219    13.648     0.200
     5.219    13.268     0.200
     5.346    16.220     0.200
     5.360    15.660     0.200
     5.413    16.359     0.200
     5.416    15.526     0.200
     5.470    15.764     0.200
     5.838    17.106     0.200
     5.848    17.901     0.200
     5.869    17.481     0.200
     5.875    17.748     0.200
     5.948    18.146     0.200
     5.930    17.666     0.200
     6.139    17.781     0.200
     6.476    18.634     0.200
     6.704    18.154     0.200
     6.720    18.488     0.200
     6.908    18.912     0.200
     6.945    20.270     0.200
     6.992    20.738     0.200
     7.029    20.861     0.200
     7.082    17.814     0.200
     7.609    21.151     0.200
     7.647    21.332     0.200
     7.678    21.421     0.200
     7.683    20.080     0.200
     7.818    19.827     0.200
     7.863    20.375     0.200
     7.998    21.653     0.200
     8.284    21.467     0.200
     8.324    21.381     0.200
     8.348    20.975     0.200
     8.385    22.190     0.200
     8.499    21.154     0.200
     8.637    22.795     0.200
     8.760    21.259     0.200
     8.943    22.079     0.200
     9.054    24.903     0.200
     9.063    22.235     0.200
     9.170    22.747     0.200
     9.370    22.521     0.200
     9.528    24.431     0.200
     9.563    22.821     0.200
     9.653    22.465     0.200
     9.734    25.653     0.200
     9.672    23.540     0.200
     9.752    25.267     0.200
     9.713    23.211     0.200
     9.748    23.879     0.200
     9.825    24.612     0.200
     9.883    25.043     0.200
     9.918    24.402     0.200
     9.996    24.151     0.200
    10.048    24.053     0.200
    10.081    23.174     0.200
    10.357    22.902     0.200
    10.348    23.809     0.200
    10.365    25.510     0.200
    10.562    27.101     0.200
    10.569    23.038     0.200
    10.587    23.552     0.200
    11.142    24.867     0.200
    11.222    26.570     0.200
    11.291    28.173     0.200
    11.398    24.436     0.200
    11.613    24.233     0.200
    11.670    25.164     0.200
    11.749    24.644     0.200
    11.779    25.821     0.200
    11.779    26.611     0.200
    11.962    23.922     0.200
    11.961    24.887     0.200
    11.961    24.885     0.200
    11.996    28.082     0.200
    12.065    28.071     0.200
    12.664    30.364     0.200
    12.781    28.987     0.200
    13.271    29.651     0.200
    13.763    28.323     0.200
    14.000    30.310     0.200
    14.301    33.635     0.200
    15.565    34.423     0.200
    15.868    35.715     0.200
    16.989    36.487     0.200
     0.947     7.684     0.200
     1.034     7.823     0.200
     1.047     7.916     0.200
     1.152     8.587     0.200
     1.664     9.109     0.200
     1.950     8.859     0.200
     2.488    10.708     0.200
     2.570    11.267     0.200
     2.952    10.948     0.200
     3.190    14.719     0.200
     3.747    13.452     0.200
     3.769    13.737     0.200
     3.980    13.075     0.200
     4.535    15.115     0.200
     4.562    14.670     0.200
     4.634    14.959     0.200
     4.651    15.520     0.200
     4.720    13.736     0.200
     5.333    14.799     0.200
     5.333    14.154     0.200
     5.299    18.604     0.200
     5.574    17.865     0.200
     6.054    19.966     0.200
     6.893    18.915     0.200
     7.073    22.241     0.200
     7.225    18.454     0.200
     7.818    21.783     0.200
     7.852    19.273     0.200
     7.968    21.329     0.200
     8.002    21.368     0.200
     8.169    22.276     0.200
     8.539    21.487     0.200
     8.521    22.227     0.200
     8.544    22.321     0.200
     8.904    23.196     0.200
     9.236    25.790     0.200
     9.702    24.263     0.200
     9.899    24.123     0.200
    10.098    27.195     0.200
    10.173    26.139     0.200
    10.222    24.964     0.200
    10.732    26.400     0.200
    11.493    27.430     0.200
    12.135    25.295     0.200
    12.135    25.295     0.200
     0.468     4.819     0.200
     0.938     6.741     0.200
     0.957     6.831     0.200
     1.108     6.890     0.200
     1.356     8.084     0.200
     1.451     8.106     0.200
     1.512     8.384     0.200
     1.531     8.782     0.200
     1.409     9.376     0.200
     1.812     8.079     0.200
     1.925     9.947     0.200
     2.082    10.840     0.200
     2.092    10.552     0.200
     2.342     9.839     0.200
     2.157    10.641     0.200
     2.421    10.389     0.200
     2.540    11.840     0.200
     2.542    11.618     0.200
     2.885     9.198     0.200
     3.179    13.026     0.200
     3.222    12.778     0.200
     3.330    13.152     0.200
     3.558    13.063     0.200
     3.350    13.866     0.200
     3.895    11.517     0.200
     3.719    13.132     0.200
     3.781    13.756     0.200
     3.944    13.719     0.200
     3.980    13.448     0.200
     4.393    13.629     0.200
     4.430    13.523     0.200
     4.497    14.060     0.200
     4.516    14.503     0.200
     4.623    12.204     0.200
     4.658    14.760     0.200
     5.228    13.576     0.200
     5.434    15.686     0.200
     5.489    15.875     0.200
     5.980    18.043     0.200
     6.734    18.183     0.200
     7.098    18.547     0.200
     7.878    20.159     0.200
     8.404    21.257     0.200
     8.380    20.947     0.200
     8.776    21.828     0.200
    10.096    25.101     0.200
    10.393    26.158     0.200
    11.332    28.917     0.200
    11.986    25.657     0.200
    11.986    25.658     0.200
     1.117     8.645     0.200
     1.303     9.106     0.200
     1.345     8.128     0.200
     1.646     9.914     0.200
     1.704    10.275     0.200
     2.160    10.114     0.200
     2.195    10.372     0.200
     2.231     9.766     0.200
     2.279    12.422     0.200
     2.982    13.022     0.200
     3.062    13.525     0.200
     3.108    13.364     0.200
     3.135    13.772     0.200
     3.475    13.067     0.200
     3.500    13.148     0.200
     3.527    14.194     0.200
     3.608    13.913     0.200
     3.715    14.036     0.200
     3.743    14.052     0.200
     4.089    13.129     0.200
     4.162    14.728     0.200
     4.297    13.768     0.200
     4.305    14.275     0.200
     4.444    15.179     0.200
     4.492    16.280     0.200
     4.588    17.279     0.200
     5.157    16.011     0.200
     5.204    16.699     0.200
     6.658    21.090     0.200
     6.772    21.684     0.200
     7.760    19.671     0.200
     8.353    24.198     0.200
     8.677    26.024     0.200
     9.167    22.654     0.200
     9.416    26.284     0.200
     9.569    24.649     0.200
     9.600    23.531     0.200
     9.648    26.022     0.200
     9.956    23.351     0.200
    10.261    26.725     0.200
    10.313    26.703     0.200
    10.933    25.875     0.200
    11.427    29.726     0.200
    11.427    30.486     0.200
    11.633    26.628     0.200
    11.845    29.854     0.200
    12.305    31.862     0.200
    12.797    34.020     0.200
    13.533    30.998     0.200
    13.829    30.918     0.200
    18.013    35.929     0.200
     0.343     5.152     0.200
     0.795     6.474     0.200
     0.822     7.219     0.200
     0.847     7.117     0.200
     0.926     8.072     0.200
     1.015     7.341     0.200
     1.027     7.060     0.200
     1.194     7.349     0.200
     1.265     7.957     0.200
     1.325     9.308     0.200
     1.434     8.134     0.200
     1.445     8.413     0.200
     1.756     7.737     0.200
     2.026    10.727     0.200
     2.042    10.607     0.200
     2.103    10.466     0.200
     2.192     9.213     0.200
     2.403    11.285     0.200
     2.495    11.230     0.200
     3.189    12.734     0.200
     3.294    12.736     0.200
     3.357    13.074     0.200
     3.749    13.682     0.200
     3.916    13.565     0.200
     3.951    13.408     0.200
     4.327    13.709     0.200
     4.359    14.300     0.200
     4.378    13.356     0.200
     4.436    14.223     0.200
     4.460    14.128     0.200
     4.619    14.130     0.200
     4.608    12.753     0.200
     4.694    15.699     0.200
     4.737    14.877     0.200
     4.716    16.018     0.200
     4.819    16.873     0.200
     5.204    14.078     0.200
     5.325    15.259     0.200
     5.331    16.926     0.200
     5.369    15.975     0.200
     5.383    15.212     0.200
     5.434    15.796     0.200
     5.798    16.945     0.200
     5.813    16.672     0.200
     5.829    16.867     0.200
     5.835    17.289     0.200
     6.431    18.329     0.200
     6.640    18.706     0.200
     6.686    17.856     0.200
     6.861    19.041     0.200
     6.882    19.222     0.200
     6.944    19.864     0.200
     7.556    20.956     0.200
     7.559    20.903     0.200
     7.603    20.770     0.200
     7.635    19.816     0.200
     7.782    20.298     0.200
     7.833    20.404     0.200
     7.948    21.184     0.200
     8.252    21.175     0.200
     8.243    21.519     0.200
     8.276    20.630     0.200
     8.276    20.911     0.200
     8.346    20.239     0.200
     8.528    23.045     0.200
     8.864    20.868     0.200
     8.864    21.548     0.200
     8.902    20.526     0.200
     8.902    21.706     0.200
     8.995    24.326     0.200
     9.329    20.639     0.200
     9.467    24.215     0.200
     9.629    21.915     0.200
     9.643    23.200     0.200
     9.684    22.806     0.200
     9.710    21.894     0.200
     9.710    23.144     0.200
     9.725    25.023     0.200
     9.770    25.050     0.200
     9.798    24.580     0.200
     9.860    25.003     0.200
     9.940    24.647     0.200
    10.028    23.001     0.200
    10.049    23.489     0.200
    10.305    25.009     0.200
    10.306    22.739     0.200
    10.324    23.302     0.200
    10.466    26.466     0.200
    10.534    23.881     0.200
    10.740    26.360     0.200
    11.159    26.040     0.200
    11.197    27.806     0.200
    11.344    24.219     0.200
    11.342    25.957     0.200
    11.558    23.456     0.200
    11.618    24.135     0.200
    11.692    24.866     0.200
    11.724    26.698     0.200
    11.724    24.636     0.200
    11.720    25.938     0.200
    11.909    24.679     0.200
    11.908    25.300     0.200
    11.908    24.363     0.200
    12.023    26.049     0.200
    13.726    29.675     0.200
    13.720    29.015     0.200
    13.965    29.963     0.200
    14.298    32.227     0.200
    15.127    34.975     0.200
    15.588    33.156     0.200
    15.885    35.439     0.200
    20.124    35.687     0.200
     0.368     5.090     0.200
     0.791     7.056     0.200
     0.960     7.325     0.200
     1.011     7.863     0.200
     1.006     7.270     0.200
     1.022     7.697     0.200
     1.291     8.305     0.200
     1.320     9.842     0.200
     1.459     8.487     0.200
     1.471     8.723     0.200
     1.677     9.647     0.200
     1.780     7.895     0.200
     2.016    11.105     0.200
     2.031    10.929     0.200
     2.093    10.977     0.200
     2.217     9.183     0.200
     2.309     9.475     0.200
     2.391    11.866     0.200
     2.484    12.107     0.200
     3.175    12.668     0.200
     3.280    13.023     0.200
     3.343    13.384     0.200
     3.565    12.219     0.200
     3.599    13.552     0.200
     3.634    13.094     0.200
     3.810    14.083     0.200
     3.901    14.067     0.200
     3.936    14.028     0.200
     4.351    13.829     0.200
     4.384    14.345     0.200
     4.402    13.557     0.200
     4.461    14.285     0.200
     4.484    14.733     0.200
     4.629    12.044     0.200
     4.643    14.188     0.200
     4.761    14.777     0.200
     4.679    16.614     0.200
     4.700    16.437     0.200
     4.805    17.310     0.200
     5.226    13.076     0.200
     5.349    16.307     0.200
     5.394    16.002     0.200
     5.407    15.513     0.200
     5.458    15.913     0.200
     5.823    17.672     0.200
     5.838    17.485     0.200
     5.853    16.948     0.200
     5.859    17.289     0.200
     6.402    19.069     0.200
     6.666    19.385     0.200
     6.710    17.624     0.200
     6.886    18.448     0.200
     6.969    20.106     0.200
     7.585    21.057     0.200
     7.660    20.119     0.200
     7.806    20.766     0.200
     7.856    19.818     0.200
     7.974    21.538     0.200
     8.267    21.681     0.200
     8.302    20.178     0.200
     8.370    20.270     0.200
     8.514    22.927     0.200
     8.885    21.065     0.200
     8.926    20.587     0.200
     9.021    23.714     0.200
     9.493    24.223     0.200
     9.652    21.722     0.200
     9.734    22.561     0.200
     9.886    24.481     0.200
     9.935    22.914     0.200
     9.966    23.915     0.200
    10.050    23.322     0.200
    10.073    23.132     0.200
    10.331    25.517     0.200
    10.331    22.893     0.200
    10.483    26.272     0.200
    10.559    24.932     0.200
    10.765    26.151     0.200
    10.895    25.349     0.200
    11.126    24.819     0.200
    11.185    25.708     0.200
    11.218    28.120     0.200
    11.369    24.089     0.200
    11.364    26.245     0.200
    11.584    23.939     0.200
    11.644    24.374     0.200
    11.718    24.966     0.200
    11.749    25.247     0.200
    11.749    24.466     0.200
    11.744    25.406     0.200
    11.934    24.792     0.200
    11.934    24.792     0.200
    11.934    24.789     0.200
    12.048    27.114     0.200
    13.229    30.177     0.200
    13.745    29.313     0.200
    13.751    27.923     0.200
    13.989    30.741     0.200
    14.318    32.651     0.200
    15.119    34.615     0.200
    15.119    34.088     0.200
    15.602    34.501     0.200
    15.901    35.889     0.200
    19.346    38.321     0.200
    20.139    35.840     0.200
     1.496     8.142     0.200
     1.657     8.440     0.200
     1.674     8.571     0.200
     1.962     8.319     0.200
     2.410     9.471     0.200
     2.504     9.650     0.200
     2.570     9.910     0.200
     3.755    12.692     0.200
     4.542    14.001     0.200
     4.581    13.937     0.200
     4.647    14.360     0.200
     4.666    15.112     0.200
     4.770    12.939     0.200
     4.949    15.812     0.200
     5.376    15.093     0.200
     5.528    16.522     0.200
     6.873    18.585     0.200
     7.079    20.432     0.200
     7.854    21.284     0.200
     8.029    21.155     0.200
     8.489    21.363     0.200
     8.513    21.916     0.200
     8.555    23.269     0.200
     9.036    21.655     0.200
     9.113    22.934     0.200
     9.225    24.568     0.200
     9.698    24.760     0.200
     9.815    24.805     0.200
     9.917    23.766     0.200
    10.089    25.742     0.200
    10.106    25.637     0.200
    10.167    26.609     0.200
    10.208    24.844     0.200
    10.247    23.993     0.200
    10.529    26.122     0.200
    10.536    26.339     0.200
    10.511    25.730     0.200
    10.758    25.669     0.200
    10.967    27.913     0.200
    11.312    26.344     0.200
    11.392    28.669     0.200
    11.411    28.936     0.200
    11.523    27.743     0.200
    11.784    28.615     0.200
    11.841    27.828     0.200
    11.925    28.311     0.200
    11.950    29.283     0.200
    12.133    28.621     0.200
    12.133    26.617     0.200
    12.234    28.692     0.200
    13.438    31.667     0.200
    13.933    31.974     0.200
    14.169    32.739     0.200
    20.288    37.917     0.200
     0.396     5.552     0.200
     0.895     6.177     0.200
     1.114     7.981     0.200
     1.125     7.700     0.200
     1.273     8.187     0.200
     1.424     9.339     0.200
     1.429     8.380     0.200
     1.448     8.615     0.200
     1.732     7.866     0.200
     1.777     9.769     0.200
     2.116    11.475     0.200
     2.192    11.004     0.200
     2.274     9.683     0.200
     2.340     9.894     0.200
     2.339    10.011     0.200
     2.488    12.017     0.200
     2.510    12.187     0.200
     2.581    12.392     0.200
     3.375    13.739     0.200
     3.524    12.827     0.200
     3.553    12.737     0.200
     3.599    12.981     0.200
     3.769    13.643     0.200
     3.828    13.979     0.200
     3.904    14.349     0.200
     3.993    14.697     0.200
     4.029    14.400     0.200
     4.209    13.568     0.200
     4.312    13.918     0.200
     4.337    14.016     0.200
     4.351    13.453     0.200
     4.416    13.737     0.200
     4.436    14.283     0.200
     4.718    14.393     0.200
     5.157    12.838     0.200
     5.157    13.580     0.200
     5.299    16.929     0.200
     5.355    15.277     0.200
     5.352    16.310     0.200
     5.404    16.520     0.200
     5.409    15.687     0.200
     6.417    18.501     0.200
     6.659    16.199     0.200
     6.841    19.563     0.200
     6.848    20.285     0.200
     6.871    19.724     0.200
     7.549    20.644     0.200
     7.551    20.764     0.200
     7.624    19.789     0.200
     7.757    21.198     0.200
     7.940    21.202     0.200
     8.274    21.250     0.200
     8.298    21.177     0.200
     8.608    22.887     0.200
     8.816    20.926     0.200
     8.882    21.561     0.200
     8.998    24.600     0.200
     9.309    20.984     0.200
     9.473    24.647     0.200
     9.590    21.446     0.200
     9.686    22.373     0.200
     9.862    26.079     0.200
     9.878    22.478     0.200
     9.939    24.317     0.200
     9.986    22.515     0.200
    10.019    23.106     0.200
    10.286    23.986     0.200
    10.299    23.527     0.200
    10.310    25.417     0.200
    10.529    26.341     0.200
    11.081    24.901     0.200
    11.168    26.803     0.200
    11.267    28.658     0.200
    11.300    26.748     0.200
    11.341    24.785     0.200
    11.555    24.727     0.200
    11.612    26.584     0.200
    11.695    26.985     0.200
    11.692    26.145     0.200
    11.722    26.616     0.200
    11.903    25.625     0.200
    11.904    25.536     0.200
    12.004    27.523     0.200
    13.219    31.109     0.200
    13.702    29.954     0.200
    13.726    33.443     0.200
    13.939    30.349     0.200
    14.239    33.657     0.200
    15.810    36.153     0.200
    16.929    34.834     0.200
     0.559     6.051     0.200
     0.720     6.740     0.200
     0.727     6.722     0.200
     0.772     5.646     0.200
     0.831     7.712     0.200
     1.450     9.446     0.200
     1.596     9.715     0.200
     1.597     9.266     0.200
     1.667     9.347     0.200
     1.915    10.152     0.200
     1.945    10.319     0.200
     1.959    10.197     0.200
     2.034    10.532     0.200
     2.707    11.545     0.200
     2.878    12.029     0.200
     3.202    12.116     0.200
     3.267    12.603     0.200
     3.393    13.082     0.200
     4.030    13.858     0.200
     4.073    14.245     0.200
     4.202    15.442     0.200
     4.222    15.485     0.200
     4.296    16.338     0.200
     4.699    14.864     0.200
     4.814    15.125     0.200
     4.831    15.227     0.200
     4.882    15.025     0.200
     4.931    15.484     0.200
     4.959    15.906     0.200
     5.119    15.545     0.200
     5.126    13.262     0.200
     5.229    15.951     0.200
     5.624    17.324     0.200
     5.722    14.360     0.200
     5.722    14.556     0.200
     5.888    16.731     0.200
     5.935    16.964     0.200
     6.294    18.698     0.200
     6.302    18.962     0.200
     6.324    19.029     0.200
     6.331    19.190     0.200
     6.589    19.355     0.200
     7.070    18.953     0.200
     7.190    18.916     0.200
     7.270    19.096     0.200
     7.343    20.885     0.200
     7.423    21.416     0.200
     7.556    19.183     0.200
     7.674    21.973     0.200
     8.012    23.341     0.200
     8.077    22.865     0.200
     8.111    22.596     0.200
     8.282    22.186     0.200
     8.422    22.861     0.200
     8.645    22.050     0.200
     8.668    21.879     0.200
     8.734    22.306     0.200
     8.747    21.560     0.200
     8.841    22.217     0.200
     8.885    24.203     0.200
     9.230    25.395     0.200
     9.231    22.997     0.200
     9.293    25.014     0.200
     9.320    24.638     0.200
     9.394    22.413     0.200
     9.382    21.847     0.200
     9.442    25.547     0.200
     9.518    25.814     0.200
     9.523    23.345     0.200
     9.583    25.576     0.200
     9.823    22.304     0.200
     9.907    24.797     0.200
     9.946    26.718     0.200
     9.930    22.018     0.200
    10.208    23.707     0.200
    10.310    26.092     0.200
    10.397    24.632     0.200
    10.422    23.655     0.200
    10.526    26.730     0.200
    10.544    24.337     0.200
    10.556    24.223     0.200
    10.746    26.161     0.200
    10.775    24.092     0.200
    10.837    24.085     0.200
    10.998    24.696     0.200
    11.193    26.845     0.200
    11.389    26.025     0.200
    11.590    27.440     0.200
    11.595    25.629     0.200
    11.804    25.237     0.200
    12.018    24.841     0.200
    12.086    25.357     0.200
    12.144    25.440     0.200
    12.180    25.200     0.200
    12.220    26.913     0.200
    12.372    25.296     0.200
    12.372    25.159     0.200
    12.372    25.518     0.200
    12.514    28.654     0.200
    12.643    31.179     0.200
    13.296    30.464     0.200
    13.612    31.867     0.200
    14.177    33.089     0.200
    14.210    29.992     0.200
    14.465    31.489     0.200
    14.708    33.496     0.200
    14.815    33.434     0.200
    16.074    34.635     0.200
    16.382    36.093     0.200
    16.949    35.271     0.200
    19.791    36.864     0.200
    20.105    36.113     0.200
     1.213     7.595     0.200
     1.273     8.125     0.200
     1.360     7.863     0.200
     1.292     8.256     0.200
     1.378     9.344     0.200
     1.459     8.958     0.200
     1.494     8.768     0.200
     1.424     8.477     0.200
     1.429     8.207     0.200
     1.573     9.076     0.200
     1.613     9.846     0.200
     2.290    10.197     0.200
     2.208    10.682     0.200
     2.455    11.162     0.200
     2.373    12.088     0.200
     2.375    11.752     0.200
     2.445    11.954     0.200
     2.723    12.867     0.200
     2.734    12.652     0.200
     2.810    12.985     0.200
     3.537    12.948     0.200
     3.432    13.717     0.200
     3.475    13.961     0.200
     3.604    12.457     0.200
     3.590    13.798     0.200
     3.963    14.147     0.200
     4.033    14.850     0.200
     4.216    13.430     0.200
     4.160    15.450     0.200
     4.391    13.842     0.200
     4.390    13.730     0.200
     4.478    14.329     0.200
     4.490    12.936     0.200
     4.784    14.851     0.200
     4.959    17.229     0.200
     4.975    17.398     0.200
     5.114    13.532     0.200
     5.114    13.852     0.200
     5.451    16.169     0.200
     5.576    17.165     0.200
     6.314    19.509     0.200
     6.749    17.448     0.200
     6.806    19.414     0.200
     6.928    21.000     0.200
     7.041    17.340     0.200
     7.712    23.505     0.200
     8.373    22.271     0.200
     8.463    22.302     0.200
     8.487    21.964     0.200
     8.767    21.700     0.200
     8.937    23.531     0.200
     9.128    26.119     0.200
     9.360    23.684     0.200
     9.381    21.734     0.200
     9.574    23.207     0.200
     9.610    25.447     0.200
     9.726    23.706     0.200
     9.955    23.816     0.200
    10.033    23.910     0.200
    10.053    24.616     0.200
    10.273    23.956     0.200
    10.395    25.597     0.200
    10.445    25.920     0.200
    10.581    26.431     0.200
    10.633    24.620     0.200
    10.799    25.995     0.200
    11.272    27.169     0.200
    11.708    25.709     0.200
    11.729    29.185     0.200
    11.811    28.524     0.200
    11.836    26.187     0.200
    11.867    29.234     0.200
    12.006    27.368     0.200
    12.006    26.151     0.200
    12.057    29.300     0.200
    13.387    31.106     0.200
    13.389    33.837     0.200
    13.758    31.741     0.200
    13.968    32.401     0.200
    16.803    37.570     0.200
     1.221     7.645     0.200
     1.362     7.716     0.200
     1.281     8.041     0.200
     1.300     8.174     0.200
     1.462     8.381     0.200
     1.496     8.062     0.200
     1.396     7.994     0.200
     1.437     8.329     0.200
     1.575     8.472     0.200
     1.807     8.400     0.200
     2.046    10.955     0.200
     2.215    11.133     0.200
     2.443    10.747     0.200
     2.456    11.560     0.200
     2.730    13.265     0.200
     4.127    14.012     0.200
     3.969    14.535     0.200
     4.215    13.633     0.200
     4.268    14.266     0.200
     4.113    15.010     0.200
     4.392    14.364     0.200
     4.487    13.075     0.200
     5.111    13.780     0.200
     6.748    19.749     0.200
     6.808    19.647     0.200
     7.040    17.358     0.200
     7.713    21.935     0.200
     7.810    20.633     0.200
     8.324    21.967     0.200
     8.372    20.901     0.200
     8.490    21.838     0.200
     8.937    22.693     0.200
     8.896    24.928     0.200
     9.129    25.587     0.200
     9.572    24.048     0.200
     9.612    24.015     0.200
     9.725    23.341     0.200
     9.879    24.174     0.200
     9.987    24.872     0.200
    10.032    23.389     0.200
    10.054    24.562     0.200
    10.271    25.486     0.200
    10.396    24.875     0.200
    10.581    25.286     0.200
    10.634    25.949     0.200
    10.878    26.709     0.200
    11.130    26.541     0.200
    11.316    26.228     0.200
    11.665    26.982     0.200
    11.728    28.240     0.200
    11.812    27.088     0.200
    12.057    29.033     0.200
    13.389    30.186     0.200
    13.386    32.058     0.200
    13.967    31.901     0.200
    14.137    34.159     0.200
    14.587    34.828     0.200
     1.243     7.789     0.200
     1.987    10.220     0.200
     2.027     9.943     0.200
     2.058    10.549     0.200
     2.301    10.712     0.200
     2.321    11.023     0.200
     2.524    10.411     0.200
     2.563    10.408     0.200
     3.077    11.554     0.200
     3.147    12.060     0.200
     3.266    12.322     0.200
     3.297    11.637     0.200
     3.352    12.520     0.200
     3.303    10.307     0.200
     3.624    12.747     0.200
     3.753    14.958     0.200
     3.923    12.503     0.200
     3.923    12.214     0.200
     4.301    14.190     0.200
     4.479    16.414     0.200
     5.027    17.008     0.200
     5.079    17.333     0.200
     5.156    17.864     0.200
     5.174    17.750     0.200
     5.525    14.226     0.200
     5.576    16.172     0.200
     5.829    16.512     0.200
     5.815    17.132     0.200
     5.816    18.290     0.200
     5.870    16.804     0.200
     5.944    16.604     0.200
     6.711    19.277     0.200
     7.202    20.324     0.200
     7.222    20.563     0.200
     7.422    20.351     0.200
     7.556    19.998     0.200
     7.992    20.551     0.200
     7.989    19.879     0.200
     8.031    19.383     0.200
     8.085    23.814     0.200
     8.210    21.367     0.200
     8.197    19.392     0.200
     8.386    21.883     0.200
     8.566    20.512     0.200
     8.698    22.109     0.200
     8.765    21.966     0.200
     8.836    21.680     0.200
     8.857    23.433     0.200
     8.982    23.612     0.200
     9.085    23.452     0.200
     9.296    23.992     0.200
     9.408    22.414     0.200
     9.451    23.277     0.200
     9.544    23.937     0.200
     9.979    25.362     0.200
    10.297    25.290     0.200
    10.367    23.861     0.200
    10.582    23.736     0.200
    10.606    24.840     0.200
    10.718    26.813     0.200
    10.744    25.130     0.200
    10.913    24.819     0.200
    10.913    24.967     0.200
    10.913    24.424     0.200
    12.815    32.424     0.200
    17.197    36.781     0.200
     1.105     8.675     0.200
     1.359     7.550     0.200
     1.430     8.133     0.200
     1.521     8.489     0.200
     1.559     8.603     0.200
     1.602     8.780     0.200
     1.447     9.714     0.200
     1.764    10.719     0.200
     2.176    11.325     0.200
     2.485    10.483     0.200
     2.900    10.587     0.200
     3.223    14.587     0.200
     3.370    14.343     0.200
     3.666    12.735     0.200
     3.689    13.530     0.200
     3.729    13.555     0.200
     3.921    12.793     0.200
     3.783    15.014     0.200
     3.857    14.567     0.200
     3.866    14.624     0.200
     3.909    15.148     0.200
     4.209    14.055     0.200
     4.305    14.286     0.200
     4.346    14.280     0.200
     4.656    13.352     0.200
     4.857    15.491     0.200
     5.265    13.472     0.200
     5.265    14.417     0.200
     5.431    15.243     0.200
     5.342    19.032     0.200
     5.930    17.357     0.200
     5.931    16.029     0.200
     5.933    16.979     0.200
     6.807    19.079     0.200
     6.859    18.338     0.200
     6.985    18.512     0.200
     6.991    20.666     0.200
     7.114    19.288     0.200
     7.149    18.445     0.200
     7.196    18.388     0.200
     7.732    21.358     0.200
     7.890    21.140     0.200
     7.927    20.687     0.200
     8.392    21.366     0.200
     8.434    21.497     0.200
     8.460    22.482     0.200
     8.458    21.889     0.200
     8.558    23.253     0.200
     8.827    21.590     0.200
     8.644    24.170     0.200
     9.020    22.848     0.200
     9.137    23.040     0.200
     9.151    25.544     0.200
     9.217    21.257     0.200
     9.309    23.114     0.200
     9.328    22.532     0.200
     9.446    23.094     0.200
     9.506    22.114     0.200
     9.627    23.450     0.200
     9.709    23.001     0.200
     9.821    22.980     0.200
    10.014    25.914     0.200
    10.089    25.313     0.200
    10.100    24.493     0.200
    10.112    25.922     0.200
    10.184    28.409     0.200
    10.651    23.869     0.200
    10.678    24.586     0.200
    10.944    26.377     0.200
    10.946    26.106     0.200
    10.974    25.245     0.200
    11.021    26.491     0.200
    11.081    26.368     0.200
    11.261    27.262     0.200
    11.278    27.550     0.200
    11.415    27.543     0.200
    11.422    26.723     0.200
    11.490    25.104     0.200
    11.705    26.799     0.200
    11.728    28.172     0.200
    11.759    26.388     0.200
    11.828    30.072     0.200
    11.836    28.620     0.200
    11.937    28.377     0.200
    12.052    26.431     0.200
    12.052    25.583     0.200
    12.142    28.283     0.200
    12.294    30.329     0.200
    12.379    28.292     0.200
    13.841    31.674     0.200
    13.877    33.147     0.200
    14.071    31.931     0.200
    14.191    31.229     0.200
    14.330    34.327     0.200
    14.480    34.320     0.200
    14.710    33.976     0.200
    15.560    35.363     0.200
    16.272    37.050     0.200
     1.283     9.539     0.200
     1.519     8.991     0.200
     1.507     9.544     0.200
     1.606     9.511     0.200
     1.651     9.955     0.200
     1.682     9.714     0.200
     1.608    10.783     0.200
     1.901    10.538     0.200
     2.306    12.317     0.200
     2.307    12.305     0.200
     2.590    13.243     0.200
     2.677    13.283     0.200
     2.837    10.864     0.200
     3.286    14.601     0.200
     3.330    14.584     0.200
     3.559    13.723     0.200
     3.430    14.628     0.200
     3.430    14.799     0.200
     3.445    14.684     0.200
     3.476    14.783     0.200
     3.707    13.608     0.200
     3.720    13.951     0.200
     3.876    12.919     0.200
     3.816    14.805     0.200
     3.888    15.524     0.200
     3.960    15.067     0.200
     3.965    15.199     0.200
     4.015    15.803     0.200
     4.237    14.335     0.200
     4.328    14.570     0.200
     4.626    13.677     0.200
     4.873    15.791     0.200
     4.891    16.083     0.200
     4.747    17.260     0.200
     4.829    17.572     0.200
     4.885    17.814     0.200
     5.013    18.138     0.200
     5.246    14.803     0.200
     5.451    16.542     0.200
     5.430    17.940     0.200
     5.954    18.645     0.200
     6.537    19.652     0.200
     6.806    19.628     0.200
     6.885    18.698     0.200
     7.032    19.269     0.200
     7.161    19.106     0.200
     7.205    18.405     0.200
     7.747    22.606     0.200
     7.785    22.369     0.200
     7.787    22.659     0.200
     7.910    20.479     0.200
     7.934    21.264     0.200
     8.431    21.848     0.200
     8.486    22.405     0.200
     8.529    22.989     0.200
     8.553    23.111     0.200
     8.660    25.479     0.200
     8.840    21.052     0.200
     8.901    22.749     0.200
     8.743    24.830     0.200
     9.049    23.323     0.200
     9.158    22.427     0.200
     9.216    25.957     0.200
     9.246    23.086     0.200
     9.472    24.154     0.200
     9.702    24.056     0.200
     9.842    23.071     0.200
     9.850    27.429     0.200
     9.868    26.857     0.200
    10.077    25.699     0.200
    10.086    24.201     0.200
    10.147    25.414     0.200
    10.155    24.761     0.200
    10.264    27.242     0.200
    10.350    26.438     0.200
    10.288    27.867     0.200
    10.495    24.345     0.200
    10.567    28.055     0.200
    10.857    28.253     0.200
    10.950    28.042     0.200
    11.235    28.519     0.200
    11.382    27.010     0.200
    11.397    29.299     0.200
    11.760    26.491     0.200
    11.772    30.357     0.200
    11.808    26.893     0.200
    11.819    28.433     0.200
    11.927    27.530     0.200
    11.930    28.698     0.200
    12.004    29.717     0.200
    12.104    27.522     0.200
    12.104    27.272     0.200
    12.104    26.538     0.200
    12.232    29.145     0.200
    12.410    29.137     0.200
    12.642    30.116     0.200
    13.462    33.234     0.200
    13.491    33.463     0.200
    13.525    33.385     0.200
    14.282    33.382     0.200
    14.648    35.731     0.200
    14.778    34.852     0.200
    14.849    34.589     0.200
    15.467    35.558     0.200
    15.789    36.137     0.200
    16.304    35.059     0.200
    16.947    36.991     0.200
    16.947    38.016     0.200
     1.914    10.541     0.200
     2.321    12.163     0.200
     2.605    12.982     0.200
     2.691    13.065     0.200
     2.821    10.219     0.200
     3.345    13.207     0.200
     3.860    13.093     0.200
     3.832    14.889     0.200
     3.903    15.207     0.200
     3.975    14.920     0.200
     3.980    15.201     0.200
     4.363    14.611     0.200
     4.489    14.591     0.200
     4.610    13.088     0.200
     5.231    14.195     0.200
     5.231    14.961     0.200
     6.792    18.034     0.200
     6.874    19.735     0.200
     7.019    19.232     0.200
     7.046    21.092     0.200
     7.146    18.434     0.200
     7.190    17.994     0.200
     7.919    21.162     0.200
     8.417    21.693     0.200
     8.472    22.436     0.200
     8.519    22.590     0.200
     8.596    22.944     0.200
     8.825    22.550     0.200
     8.759    24.520     0.200
     9.035    23.573     0.200
     9.144    23.610     0.200
     9.205    25.994     0.200
     9.233    23.416     0.200
     9.458    23.874     0.200
     9.687    23.270     0.200
     9.827    24.956     0.200
    10.065    26.967     0.200
    10.071    25.449     0.200
    10.135    26.107     0.200
    10.230    24.933     0.200
    10.261    26.909     0.200
    10.335    26.217     0.200
    10.482    26.195     0.200
    10.303    28.330     0.200
    10.674    25.691     0.200
    10.958    26.652     0.200
    11.051    27.290     0.200
    11.230    27.995     0.200
    11.258    27.605     0.200
    11.369    26.522     0.200
    11.386    28.639     0.200
    11.387    27.705     0.200
    11.533    26.872     0.200
    11.698    28.446     0.200
    11.748    25.805     0.200
    11.762    30.220     0.200
    11.795    25.725     0.200
    11.804    29.580     0.200
    11.956    28.389     0.200
    12.091    26.878     0.200
    12.091    26.038     0.200
    12.091    27.839     0.200
    12.156    28.606     0.200
    12.396    28.306     0.200
    12.628    29.085     0.200
    13.036    29.170     0.200
    13.485    31.828     0.200
    13.856    32.023     0.200
    14.266    35.396     0.200
    14.406    34.737     0.200
    14.632    34.457     0.200
    14.766    34.631     0.200
    16.290    36.339     0.200
     0.798     7.305     0.200
     0.853     7.777     0.200
     0.889     8.294     0.200
     1.058     8.373     0.200
     1.069     8.356     0.200
     1.579     8.792     0.200
     1.756    10.608     0.200
     2.174    11.956     0.200
     2.175    11.808     0.200
     2.516    13.028     0.200
     2.574    13.315     0.200
     2.585    13.261     0.200
     2.801    10.515     0.200
     3.353    11.930     0.200
     3.393    12.562     0.200
     3.244    14.252     0.200
     3.285    14.038     0.200
     3.344    14.188     0.200
     3.376    14.073     0.200
     3.386    14.298     0.200
     3.432    14.513     0.200
     3.450    14.731     0.200
     3.769    12.434     0.200
     3.794    14.619     0.200
     3.844    15.252     0.200
     3.878    14.937     0.200
     3.921    15.057     0.200
     3.941    15.146     0.200
     4.177    14.234     0.200
     4.016    15.365     0.200
     4.467    13.822     0.200
     4.551    14.598     0.200
     4.821    17.260     0.200
     5.053    15.067     0.200
     5.442    19.052     0.200
     5.827    17.202     0.200
     6.437    18.463     0.200
     6.589    18.237     0.200
     6.632    18.724     0.200
     6.662    19.661     0.200
     6.670    20.544     0.200
     6.791    19.669     0.200
     6.927    18.783     0.200
     7.601    19.581     0.200
     7.660    21.175     0.200
     8.047    21.087     0.200
     8.074    22.394     0.200
     8.070    20.994     0.200
     8.162    22.917     0.200
     8.221    23.384     0.200
     8.550    22.029     0.200
     8.716    23.330     0.200
     8.795    25.322     0.200
     8.911    23.959     0.200
     9.063    23.080     0.200
     9.144    24.440     0.200
     9.464    22.935     0.200
     9.528    24.104     0.200
     9.660    25.492     0.200
     9.707    25.254     0.200
     9.928    24.501     0.200
    10.104    26.956     0.200
    10.333    26.775     0.200
    10.719    27.138     0.200
    10.916    27.342     0.200
    10.956    28.444     0.200
    11.030    28.567     0.200
    11.146    26.291     0.200
    11.180    26.953     0.200
    11.288    28.007     0.200
    11.360    26.310     0.200
    11.711    24.321     0.200
    11.711    27.442     0.200
    15.960    36.560     0.200
    18.062    36.433     0.200
    18.062    37.107     0.200
     1.553    10.479     0.200
     1.897    10.612     0.200
     1.854    11.727     0.200
     1.869    12.008     0.200
     2.057    11.057     0.200
     1.934    11.500     0.200
     1.936    11.715     0.200
     2.258    12.469     0.200
     2.279    12.496     0.200
     2.851    13.655     0.200
     2.895    13.743     0.200
     2.993    13.855     0.200
     2.999    13.661     0.200
     3.016    13.763     0.200
     3.040    13.877     0.200
     3.324    12.614     0.200
     3.369    14.053     0.200
     3.467    14.208     0.200
     3.519    14.375     0.200
     3.518    14.567     0.200
     3.595    14.716     0.200
     3.631    14.729     0.200
     4.366    14.547     0.200
     4.789    16.348     0.200
     4.831    16.607     0.200
     4.958    16.799     0.200
     5.056    17.685     0.200
     5.115    15.376     0.200
     4.965    17.983     0.200
     5.732    16.837     0.200
     5.732    16.990     0.200
     5.977    20.340     0.200
     7.341    22.077     0.200
     7.475    22.804     0.200
     8.408    23.178     0.200
     8.907    24.206     0.200
     9.505    23.937     0.200
     9.625    27.289     0.200
     9.808    26.146     0.200
     9.984    24.590     0.200
     9.840    27.624     0.200
    10.184    25.296     0.200
    10.305    26.160     0.200
    10.628    26.953     0.200
    10.936    28.768     0.200
    11.413    29.094     0.200
    11.452    27.550     0.200
    11.887    29.310     0.200
    12.198    30.218     0.200
    12.240    28.844     0.200
    12.305    30.695     0.200
    12.493    31.777     0.200
    12.532    27.559     0.200
    12.532    29.415     0.200
    12.353    31.494     0.200
    12.626    30.168     0.200
    14.325    33.122     0.200
    14.771    37.634     0.200
    14.909    34.982     0.200
    15.133    37.799     0.200
    15.215    36.321     0.200
     1.224     7.381     0.200
     1.387     7.060     0.200
     1.868     6.930     0.200
     2.935     9.502     0.200
     2.851    11.568     0.200
     3.073    10.901     0.200
     3.189    13.752     0.200
     3.199    13.411     0.200
     3.264    13.011     0.200
     3.716    10.965     0.200
     3.797    12.422     0.200
     3.649    14.004     0.200
     3.879    12.814     0.200
     4.359    12.281     0.200
     4.276    15.585     0.200
     4.319    14.198     0.200
     4.420    15.182     0.200
     4.466    15.393     0.200
     4.810    15.124     0.200
     4.903    15.654     0.200
     4.952    15.810     0.200
     4.959    15.927     0.200
     5.036    15.981     0.200
     5.071    15.974     0.200
     6.066    16.376     0.200
     6.362    15.873     0.200
     6.396    16.079     0.200
     7.728    20.202     0.200
     7.961    21.767     0.200
     8.137    22.282     0.200
     8.304    20.145     0.200
     8.387    21.546     0.200
     8.443    20.469     0.200
     8.506    21.411     0.200
     8.635    23.760     0.200
     8.661    21.019     0.200
     8.837    20.567     0.200
     9.066    23.247     0.200
     9.090    23.322     0.200
     9.200    22.637     0.200
     9.336    22.039     0.200
     9.353    23.040     0.200
     9.442    24.396     0.200
     9.479    23.217     0.200
     9.526    23.282     0.200
     9.831    23.965     0.200
     9.738    24.769     0.200
     9.958    24.554     0.200
     9.972    24.853     0.200
    10.042    24.072     0.200
    10.120    24.453     0.200
    10.149    24.385     0.200
    10.175    24.583     0.200
    10.408    26.619     0.200
    10.484    25.394     0.200
    10.484    25.962     0.200
    10.517    25.527     0.200
    10.823    26.317     0.200
    10.923    26.492     0.200
    11.055    27.859     0.200
    11.073    27.476     0.200
    11.121    24.264     0.200
    11.140    24.657     0.200
    11.231    26.518     0.200
    11.287    24.709     0.200
    11.301    23.705     0.200
    11.321    28.192     0.200
    11.340    28.205     0.200
    11.414    27.646     0.200
    11.449    25.420     0.200
    11.449    23.279     0.200
    11.449    24.568     0.200
    11.279    29.017     0.200
    11.558    31.240     0.200
    11.830    27.326     0.200
    12.602    31.324     0.200
    13.116    30.041     0.200
    13.122    28.441     0.200
    13.321    32.686     0.200
    13.667    31.856     0.200
    13.791    31.656     0.200
    15.967    36.696     0.200
    15.967    37.297     0.200
    17.717    36.009     0.200
    17.717    36.212     0.200
     1.392     8.652     0.200
     1.345     9.617     0.200
     1.360     9.500     0.200
     1.391     9.598     0.200
     1.412     9.837     0.200
     1.608    10.028     0.200
     2.275    11.998     0.200
     2.494    13.005     0.200
     2.614    13.677     0.200
     2.630    13.448     0.200
     2.691    13.795     0.200
     2.693    13.635     0.200
     3.041    13.211     0.200
     3.187    13.397     0.200
     3.193    13.923     0.200
     3.237    13.901     0.200
     3.082    14.427     0.200
     3.084    15.187     0.200
     3.288    12.778     0.200
     3.353    13.195     0.200
     3.796    14.719     0.200
     3.728    16.264     0.200
     3.728    16.471     0.200
     3.771    15.756     0.200
     3.867    16.245     0.200
     3.871    16.330     0.200
     4.059    15.406     0.200
     3.918    16.678     0.200
     4.093    14.127     0.200
     4.270    16.299     0.200
     4.359    16.946     0.200
     4.406    17.086     0.200
     4.418    17.327     0.200
     4.456    17.775     0.200
     4.494    17.429     0.200
     4.528    17.496     0.200
     4.709    15.410     0.200
     5.209    17.716     0.200
     5.428    19.233     0.200
     5.370    18.991     0.200
     5.721    19.006     0.200
     6.074    19.511     0.200
     5.902    18.479     0.200
     6.270    20.176     0.200
     6.270    19.281     0.200
     6.331    18.959     0.200
     6.406    19.730     0.200
     6.469    19.940     0.200
     6.385    19.801     0.200
     6.506    19.821     0.200
     6.510    21.002     0.200
     6.539    19.993     0.200
     6.623    19.074     0.200
     6.634    19.674     0.200
     6.666    18.952     0.200
     7.294    21.838     0.200
     7.336    21.396     0.200
     7.374    21.718     0.200
     7.396    20.132     0.200
     7.616    21.454     0.200
     7.906    22.562     0.200
     7.953    22.086     0.200
     8.079    22.973     0.200
     8.095    23.474     0.200
     8.102    23.023     0.200
     8.302    22.920     0.200
     8.362    23.138     0.200
     8.366    23.237     0.200
     8.518    22.068     0.200
     8.624    22.978     0.200
     8.716    22.644     0.200
     8.765    22.901     0.200
     8.940    23.070     0.200
     9.163    23.993     0.200
     9.307    24.461     0.200
     9.195    26.438     0.200
     9.466    24.451     0.200
     9.462    24.158     0.200
     9.548    24.693     0.200
     9.575    25.960     0.200
     9.617    24.197     0.200
     9.617    25.642     0.200
     9.640    25.889     0.200
     9.685    24.358     0.200
     9.709    24.649     0.200
     9.708    25.863     0.200
     9.815    26.181     0.200
     9.861    25.407     0.200
     9.899    25.946     0.200
     9.978    25.392     0.200
     9.983    25.567     0.200
     9.988    26.557     0.200
    10.036    27.173     0.200
    10.162    25.211     0.200
    10.201    26.663     0.200
    10.201    26.156     0.200
    10.217    25.751     0.200
    10.392    25.750     0.200
    10.434    25.277     0.200
    10.445    27.086     0.200
    10.476    27.233     0.200
    10.528    26.602     0.200
    10.712    26.934     0.200
    10.702    27.691     0.200
    10.734    27.648     0.200
    10.715    28.625     0.200
    10.864    27.274     0.200
    10.892    27.374     0.200
    10.909    28.210     0.200
    11.035    26.263     0.200
    11.250    26.405     0.200
    11.291    26.415     0.200
    11.282    28.326     0.200
    11.298    28.176     0.200
    11.298    26.535     0.200
    11.310    27.789     0.200
    11.398    26.322     0.200
    11.419    28.988     0.200
    11.419    28.390     0.200
    11.422    28.215     0.200
    11.440    26.824     0.200
    11.590    26.633     0.200
    11.590    26.645     0.200
    11.590    26.965     0.200
    11.638    28.638     0.200
    11.724    29.316     0.200
    11.724    28.070     0.200
    11.880    29.724     0.200
    12.535    29.073     0.200
    12.990    32.487     0.200
    12.990    31.237     0.200
    12.992    32.920     0.200
    13.148    32.431     0.200
    13.338    31.239     0.200
    13.431    31.333     0.200
    13.628    32.096     0.200
    13.762    34.531     0.200
    14.143    34.893     0.200
    14.198    34.533     0.200
    14.384    34.380     0.200
    14.384    33.544     0.200
    15.007    35.199     0.200
    15.311    36.062     0.200
    16.382    37.404     0.200
    16.382    37.772     0.200
    16.441    39.682     0.200
    16.441    37.964     0.200
    17.905    38.019     0.200
    17.905    37.324     0.200
    18.747    41.267     0.200
     1.301     8.379     0.200
     1.301     7.979     0.200
     1.321     8.105     0.200
     1.333     8.344     0.200
     1.405     9.280     0.200
     1.433     9.065     0.200
     1.540     8.502     0.200
     1.467     8.086     0.200
     1.612     9.152     0.200
     1.766     8.557     0.200
     2.083    10.197     0.200
     2.275    10.677     0.200
     2.418    11.289     0.200
     2.421    11.650     0.200
     2.490    12.339     0.200
     2.492    11.779     0.200
     2.857    12.806     0.200
     2.866    12.499     0.200
     2.886    12.494     0.200
     3.416    12.472     0.200
     3.563    12.697     0.200
     3.568    13.239     0.200
     3.481    14.252     0.200
     3.481    14.143     0.200
     3.662    13.000     0.200
     3.685    11.643     0.200
     3.524    13.766     0.200
     3.554    14.092     0.200
     3.624    13.940     0.200
     3.636    13.741     0.200
     4.171    13.625     0.200
     4.155    14.411     0.200
     4.345    13.880     0.200
     4.349    14.525     0.200
     4.379    14.719     0.200
     4.435    14.440     0.200
     4.440    12.536     0.200
     4.741    14.828     0.200
     5.064    13.698     0.200
     5.064    13.924     0.200
     5.627    16.191     0.200
     5.802    17.145     0.200
     5.820    17.450     0.200
     6.097    17.904     0.200
     6.450    18.377     0.200
     6.345    20.408     0.200
     6.702    17.598     0.200
     6.771    19.196     0.200
     6.845    18.968     0.200
     6.915    19.621     0.200
     6.994    17.228     0.200
     7.037    17.445     0.200
     7.712    21.257     0.200
     7.748    19.983     0.200
     7.765    19.847     0.200
     7.909    21.004     0.200
     7.991    21.085     0.200
     8.282    20.925     0.200
     8.328    20.938     0.200
     8.432    21.528     0.200
     8.470    21.890     0.200
     8.674    21.621     0.200
     8.717    21.575     0.200
     8.998    22.601     0.200
     8.856    24.043     0.200
     9.091    22.018     0.200
     8.939    24.492     0.200
     9.163    22.342     0.200
     9.315    22.491     0.200
     9.333    21.539     0.200
     9.526    22.337     0.200
     9.680    24.032     0.200
     9.813    24.040     0.200
     9.833    23.502     0.200
     9.906    24.044     0.200
     9.908    22.820     0.200
     9.947    24.786     0.200
     9.986    24.203     0.200
    10.014    24.371     0.200
    10.061    22.771     0.200
    10.064    24.812     0.200
    10.085    23.085     0.200
    10.045    27.012     0.200
    10.224    24.726     0.200
    10.251    26.475     0.200
    10.354    25.671     0.200
    10.569    25.159     0.200
    10.483    26.469     0.200
    10.897    28.339     0.200
    11.574    30.071     0.200
    11.669    28.508     0.200
    11.674    29.414     0.200
    11.796    28.144     0.200
    11.965    26.632     0.200
    11.965    25.071     0.200
    12.255    27.782     0.200
    12.475    27.804     0.200
    13.449    32.602     0.200
     1.957    11.181     0.200
     2.018    11.438     0.200
     2.892    15.670     0.200
     2.936    15.744     0.200
     3.012    15.731     0.200
     3.035    15.978     0.200
     3.040    15.590     0.200
     3.056    15.770     0.200
     3.081    16.242     0.200
     3.110    16.223     0.200
     3.490    16.685     0.200
     3.509    16.349     0.200
     3.561    16.371     0.200
     3.637    16.798     0.200
     3.674    16.762     0.200
     4.132    16.621     0.200
     4.320    15.370     0.200
     4.491    19.182     0.200
     5.069    16.626     0.200
     5.009    19.386     0.200
     5.687    17.791     0.200
     5.687    18.041     0.200
     5.999    21.625     0.200
     7.237    22.914     0.200
     7.229    21.610     0.200
     7.297    21.891     0.200
     7.434    23.022     0.200
     7.587    21.268     0.200
     8.364    24.420     0.200
     8.875    25.095     0.200
     8.902    25.660     0.200
     8.999    26.112     0.200
     9.266    25.523     0.200
     9.339    25.501     0.200
     9.343    25.334     0.200
     9.578    25.550     0.200
     9.740    26.340     0.200
     9.764    25.791     0.200
     9.887    26.715     0.200
     9.940    26.076     0.200
     9.883    28.934     0.200
    10.139    26.809     0.200
    10.261    26.811     0.200
    10.584    27.967     0.200
    10.686    28.146     0.200
    10.836    28.820     0.200
    10.857    28.865     0.200
    10.899    29.066     0.200
    11.172    29.562     0.200
    11.370    29.981     0.200
    11.407    29.158     0.200
    11.506    29.718     0.200
    11.660    29.695     0.200
    11.678    30.555     0.200
    11.708    31.957     0.200
    11.709    30.841     0.200
    11.756    31.554     0.200
    11.840    30.562     0.200
    11.978    30.589     0.200
    12.093    32.049     0.200
    12.162    30.275     0.200
    12.147    31.170     0.200
    12.153    31.049     0.200
    12.268    30.813     0.200
    12.282    30.295     0.200
    12.260    30.086     0.200
    12.312    27.783     0.200
    12.493    30.978     0.200
    12.395    33.785     0.200
    12.584    31.733     0.200
    12.703    33.054     0.200
    12.821    31.969     0.200
    13.050    31.748     0.200
    13.069    32.151     0.200
    13.437    33.061     0.200
    13.802    35.618     0.200
    13.968    34.696     0.200
    15.151    36.971     0.200
    15.181    37.476     0.200
    15.172    36.386     0.200
    16.715    37.903     0.200
     1.234     9.612     0.200
     1.569    10.706     0.200
     1.712    11.353     0.200
     2.000    11.084     0.200
     1.869    12.385     0.200
     1.885    12.684     0.200
     2.061    11.396     0.200
     1.951    12.243     0.200
     2.271    13.020     0.200
     2.305    13.138     0.200
     2.863    14.282     0.200
     2.907    14.330     0.200
     3.005    14.434     0.200
     3.011    14.327     0.200
     3.028    14.526     0.200
     3.052    14.486     0.200
     3.081    14.989     0.200
     3.460    15.345     0.200
     3.478    14.796     0.200
     3.606    15.406     0.200
     3.643    15.297     0.200
     4.383    17.561     0.200
     4.789    16.937     0.200
     4.832    17.209     0.200
     4.967    17.178     0.200
     5.040    17.532     0.200
     5.111    15.920     0.200
     5.729    17.143     0.200
     5.729    17.367     0.200
     6.836    22.163     0.200
     7.050    22.448     0.200
     7.277    23.012     0.200
     7.279    21.914     0.200
     7.340    22.206     0.200
     7.477    22.974     0.200
     8.407    23.711     0.200
     8.945    25.314     0.200
     9.042    25.628     0.200
     9.309    24.330     0.200
     9.783    25.051     0.200
     9.983    25.562     0.200
     9.851    28.293     0.200
    10.305    26.860     0.200
    10.133    29.002     0.200
    10.493    29.100     0.200
    10.571    28.433     0.200
    10.627    27.663     0.200
    10.879    28.075     0.200
    10.900    27.805     0.200
    10.941    28.766     0.200
    11.215    29.020     0.200
    11.410    29.595     0.200
    11.450    29.492     0.200
    11.797    30.886     0.200
    12.132    32.103     0.200
    12.423    33.053     0.200
    12.535    29.352     0.200
    12.535    28.971     0.200
    12.365    32.019     0.200
    12.627    30.890     0.200
    12.744    31.503     0.200
    12.865    31.737     0.200
    14.554    36.505     0.200
    15.221    37.074     0.200
    16.758    39.714     0.200
     0.863     5.961     0.200
     1.269     6.874     0.200
     1.363     7.650     0.200
     1.516     7.358     0.200
     1.553     8.939     0.200
     1.580     9.117     0.200
     1.599     9.204     0.200
     1.649     9.676     0.200
     1.770     9.089     0.200
     1.824     9.481     0.200
     2.018     8.934     0.200
     2.081     9.313     0.200
     2.160     9.652     0.200
     2.280     8.155     0.200
     2.415    11.099     0.200
     2.593    11.426     0.200
     3.130    12.779     0.200
     3.205    13.311     0.200
     3.232    13.236     0.200
     3.835    14.750     0.200
     4.090    11.483     0.200
     3.878    14.699     0.200
     3.977    14.071     0.200
     4.370    14.756     0.200
     4.370    14.623     0.200
     4.437    15.364     0.200
     4.463    15.000     0.200
     4.721    12.679     0.200
     4.721    12.858     0.200
     4.511    15.075     0.200
     4.518    15.071     0.200
     4.630    15.186     0.200
     5.100    15.632     0.200
     5.100    15.421     0.200
     5.459    16.420     0.200
     5.459    16.522     0.200
     5.408    17.038     0.200
     6.102    17.768     0.200
     6.102    17.658     0.200
     6.383    17.862     0.200
     6.483    18.821     0.200
     6.483    18.270     0.200
     6.547    19.282     0.200
     6.593    19.994     0.200
     6.593    19.705     0.200
     7.441    19.597     0.200
     7.438    19.960     0.200
     7.505    20.997     0.200
     7.505    20.876     0.200
     7.689    20.749     0.200
     7.734    22.737     0.200
     7.734    20.768     0.200
     7.993    20.296     0.200
     7.993    20.914     0.200
     8.023    21.757     0.200
     8.199    21.790     0.200
     8.238    21.524     0.200
     8.355    21.378     0.200
     8.689    21.999     0.200
     8.792    22.942     0.200
     8.840    24.032     0.200
     9.002    21.626     0.200
     9.011    22.272     0.200
     9.189    22.224     0.200
     9.370    23.499     0.200
     9.663    23.162     0.200
    11.517    27.757     0.200
    11.556    28.701     0.200
    11.693    24.545     0.200
    12.155    29.303     0.200
    13.604    31.675     0.200
    13.864    32.998     0.200
    17.991    36.415     0.200
     1.647     8.190     0.200
     2.251    10.877     0.200
     2.251    11.025     0.200
     2.288    10.577     0.200
     2.426    11.685     0.200
     2.464     8.115     0.200
     2.464     9.443     0.200
     2.587    12.555     0.200
     2.663    12.251     0.200
     3.033    13.426     0.200
     3.040    13.588     0.200
     3.061    13.571     0.200
     3.511    11.371     0.200
     3.511    11.520     0.200
     3.659    15.071     0.200
     3.702    13.081     0.200
     3.802    14.675     0.200
     3.802    15.258     0.200
     3.849    14.922     0.200
     4.211    14.491     0.200
     4.192    14.936     0.200
     4.192    14.335     0.200
     4.261    15.642     0.200
     4.270    12.697     0.200
     4.270    12.595     0.200
     4.302    14.207     0.200
     4.285    15.125     0.200
     4.334    15.288     0.200
     4.898    13.637     0.200
     4.898    13.942     0.200
     5.179    16.097     0.200
     5.179    15.979     0.200
     5.205    17.941     0.200
     5.260    16.143     0.200
     5.260    16.268     0.200
     5.595    17.129     0.200
     5.595    16.918     0.200
     5.807    19.135     0.200
     5.807    17.956     0.200
     5.957    17.206     0.200
     5.957    16.510     0.200
     6.107    17.460     0.200
     6.107    17.038     0.200
     6.251    18.120     0.200
     6.314    18.405     0.200
     6.476    19.795     0.200
     6.476    18.724     0.200
     6.485    19.199     0.200
     6.485    18.480     0.200
     6.494    18.768     0.200
     6.550    17.239     0.200
     6.617    18.201     0.200
     6.669    18.746     0.200
     6.712    19.179     0.200
     6.749    19.144     0.200
     6.753    18.768     0.200
     6.785    19.433     0.200
     6.843    17.529     0.200
     6.878    20.278     0.200
     6.883    17.650     0.200
     7.514    19.017     0.200
     7.519    21.349     0.200
     7.540    20.390     0.200
     7.583    21.238     0.200
     7.631    21.414     0.200
     7.631    20.851     0.200
     7.610    20.308     0.200
     7.610    19.393     0.200
     7.759    21.311     0.200
     7.759    21.007     0.200
     7.810    21.264     0.200
     7.810    20.452     0.200
     7.862    21.498     0.200
     8.146    21.148     0.200
     8.146    20.859     0.200
     8.184    20.896     0.200
     8.184    20.600     0.200
     8.256    22.901     0.200
     8.256    21.979     0.200
     8.346    22.505     0.200
     8.343    21.845     0.200
     8.343    21.462     0.200
     8.522    21.945     0.200
     8.559    21.828     0.200
     8.544    22.103     0.200
     8.548    22.094     0.200
     8.750    22.031     0.200
     8.750    21.891     0.200
     8.851    22.922     0.200
     8.851    22.468     0.200
     8.950    22.988     0.200
     8.975    24.008     0.200
     8.966    22.479     0.200
     9.007    21.647     0.200
     9.007    22.015     0.200
     9.042    23.415     0.200
     9.042    22.649     0.200
     9.032    22.529     0.200
     9.032    21.779     0.200
     9.036    25.531     0.200
     9.119    25.036     0.200
     9.171    21.125     0.200
     9.171    23.047     0.200
     9.171    22.461     0.200
     9.174    21.829     0.200
     9.306    23.108     0.200
     9.364    22.648     0.200
     9.364    23.125     0.200
     9.461    24.596     0.200
     9.533    23.000     0.200
     9.645    24.664     0.200
     9.645    23.774     0.200
     9.675    24.246     0.200
     9.740    24.448     0.200
     9.806    25.596     0.200
     9.806    24.354     0.200
     9.830    24.667     0.200
     9.832    23.584     0.200
     9.859    23.020     0.200
     9.892    24.105     0.200
     9.892    23.878     0.200
     9.898    25.013     0.200
     9.921    23.422     0.200
     9.983    25.042     0.200
     9.998    25.657     0.200
    10.081    25.419     0.200
    10.063    24.107     0.200
    10.063    24.614     0.200
    10.123    24.606     0.200
    10.171    24.957     0.200
    10.241    26.739     0.200
    10.241    25.646     0.200
    10.225    24.219     0.200
    10.294    24.083     0.200
    10.294    24.895     0.200
    10.400    23.942     0.200
    10.400    24.075     0.200
    10.412    25.200     0.200
    10.412    25.044     0.200
    10.467    24.207     0.200
    10.467    24.902     0.200
    10.470    26.610     0.200
    10.576    24.736     0.200
    10.584    25.591     0.200
    10.603    25.620     0.200
    10.639    25.024     0.200
    10.662    27.327     0.200
    10.683    24.953     0.200
    10.698    25.655     0.200
    10.677    25.444     0.200
    10.719    26.500     0.200
    10.942    25.264     0.200
    10.942    25.936     0.200
    10.935    27.063     0.200
    10.935    26.657     0.200
    10.941    28.937     0.200
    11.080    27.540     0.200
    11.146    25.939     0.200
    11.169    25.721     0.200
    11.186    27.493     0.200
    11.285    24.779     0.200
    11.350    28.472     0.200
    11.398    28.163     0.200
    11.398    28.265     0.200
    11.367    27.739     0.200
    11.468    27.618     0.200
    11.471    28.432     0.200
    11.500    24.514     0.200
    11.486    27.713     0.200
    11.486    27.463     0.200
    11.537    25.132     0.200
    11.533    25.346     0.200
    11.575    30.602     0.200
    11.575    29.773     0.200
    11.555    25.596     0.200
    11.555    27.128     0.200
    11.586    28.222     0.200
    11.561    27.972     0.200
    11.651    25.091     0.200
    11.671    27.507     0.200
    11.644    28.518     0.200
    11.644    27.542     0.200
    11.675    27.102     0.200
    11.675    27.570     0.200
    11.721    28.285     0.200
    11.838    24.395     0.200
    11.838    25.802     0.200
    11.869    26.999     0.200
    11.900    28.552     0.200
    11.897    28.557     0.200
    11.975    27.801     0.200
    12.108    25.544     0.200
    12.108    27.817     0.200
    12.114    26.930     0.200
    12.114    27.312     0.200
    12.138    27.096     0.200
    12.201    29.068     0.200
    12.304    28.816     0.200
    12.304    29.401     0.200
    12.322    28.628     0.200
    12.337    29.154     0.200
    12.468    27.790     0.200
    12.468    28.727     0.200
    12.606    28.648     0.200
    12.784    27.344     0.200
    12.784    29.040     0.200
    12.790    28.806     0.200
    12.807    31.078     0.200
    13.164    31.404     0.200
    13.168    30.227     0.200
    13.253    28.833     0.200
    13.253    29.794     0.200
    13.570    30.245     0.200
    13.771    30.946     0.200
    13.771    31.407     0.200
    14.273    34.222     0.200
    14.367    31.780     0.200
    14.367    33.873     0.200
    14.531    31.918     0.200
    14.649    34.145     0.200
    15.488    35.085     0.200
    16.007    34.801     0.200
    16.007    36.059     0.200
    16.529    36.586     0.200
    16.650    36.370     0.200
    18.145    36.496     0.200
    18.145    36.097     0.200
    18.145    36.754     0.200
    18.793    39.238     0.200
     0.953     8.279     0.200
     0.967     8.409     0.200
     0.963     8.333     0.200
     0.966     8.515     0.200
     1.062     9.306     0.200
     1.052     8.157     0.200
     1.300     9.522     0.200
     1.353    10.448     0.200
     1.650     9.341     0.200
     1.678    10.176     0.200
     1.710     9.617     0.200
     1.643    10.305     0.200
     1.811    10.678     0.200
     1.851    11.584     0.200
     2.012     9.790     0.200
     1.976    11.225     0.200
     1.978    11.531     0.200
     2.326    12.345     0.200
     2.339    12.581     0.200
     2.414    12.450     0.200
     2.542    11.549     0.200
     2.443    12.823     0.200
     2.622    10.871     0.200
     3.050    10.372     0.200
     3.050    10.677     0.200
     3.040    14.065     0.200
     3.113    14.058     0.200
     3.183    14.033     0.200
     3.212    14.174     0.200
     3.575    14.551     0.200
     3.642    15.102     0.200
     3.667    14.897     0.200
     3.716    14.933     0.200
     3.723    15.206     0.200
     4.073    13.824     0.200
     4.617    15.526     0.200
     4.591    16.998     0.200
     4.715    16.043     0.200
     4.613    17.393     0.200
     4.808    13.939     0.200
     5.417    14.573     0.200
     5.417    15.245     0.200
     5.522    17.033     0.200
     5.522    16.165     0.200
     5.686    17.964     0.200
     5.686    17.823     0.200
     5.917    19.078     0.200
     5.917    18.445     0.200
     5.958    19.724     0.200
     5.958    20.162     0.200
     6.926    21.134     0.200
     6.928    20.176     0.200
     7.007    20.083     0.200
     7.130    21.592     0.200
     7.343    20.810     0.200
     7.906    23.046     0.200
     7.906    22.503     0.200
     8.075    21.407     0.200
     8.062    22.732     0.200
     8.062    22.013     0.200
     8.532    22.537     0.200
     8.529    23.068     0.200
     8.545    23.075     0.200
     8.604    23.141     0.200
     8.502    24.344     0.200
     8.692    25.934     0.200
     8.974    23.273     0.200
     9.281    24.973     0.200
     9.281    23.606     0.200
     9.279    27.084     0.200
     9.286    25.596     0.200
     9.359    25.439     0.200
     9.589    25.140     0.200
     9.655    23.476     0.200
     9.624    26.233     0.200
     9.859    24.601     0.200
     9.859    24.343     0.200
     9.965    24.965     0.200
    10.031    26.456     0.200
    10.151    26.960     0.200
    10.043    28.683     0.200
    10.220    26.743     0.200
    10.294    25.490     0.200
    10.322    29.124     0.200
    10.561    27.006     0.200
    10.885    27.477     0.200
    11.097    28.752     0.200
    11.171    27.761     0.200
    11.428    29.426     0.200
    11.623    29.645     0.200
    11.707    29.859     0.200
    11.787    30.165     0.200
    11.987    29.437     0.200
    11.973    30.340     0.200
    12.083    30.951     0.200
    12.162    30.722     0.200
    12.185    29.414     0.200
    12.284    30.253     0.200
    12.374    30.500     0.200
    12.758    29.688     0.200
    12.777    30.122     0.200
    12.774    32.509     0.200
    13.214    32.039     0.200
    13.705    35.026     0.200
    14.631    35.159     0.200
    14.842    37.294     0.200
    16.413    39.286     0.200
     0.946     6.646     0.200
     1.248     9.100     0.200
     1.654     9.448     0.200
     1.548     8.086     0.200
     1.548     8.773     0.200
     1.701     9.154     0.200
     1.758    10.220     0.200
     2.019     8.752     0.200
     2.019     9.651     0.200
     1.884    10.603     0.200
     2.256    11.533     0.200
     3.109    10.351     0.200
     2.963    12.869     0.200
     3.106    12.747     0.200
     3.134    12.857     0.200
     3.500    13.063     0.200
     3.565    13.968     0.200
     3.639    13.391     0.200
     3.649    13.810     0.200
     3.806    13.640     0.200
     4.121    12.173     0.200
     4.519    15.492     0.200
     4.848    13.130     0.200
     5.451    14.643     0.200
     5.451    14.386     0.200
     5.514    15.923     0.200
     5.696    15.255     0.200
     6.437    18.053     0.200
     6.910    19.044     0.200
     6.903    19.207     0.200
     7.023    18.628     0.200
     7.128    19.728     0.200
     7.311    18.604     0.200
     7.360    19.532     0.200
     7.901    20.937     0.200
     7.883    21.564     0.200
     8.045    21.260     0.200
     8.035    21.498     0.200
     8.092    21.096     0.200
     8.508    22.146     0.200
     8.532    22.222     0.200
     8.988    22.244     0.200
     9.260    24.165     0.200
     9.290    22.728     0.200
     9.257    23.905     0.200
     9.594    23.039     0.200
     9.676    22.584     0.200
     9.619    24.855     0.200
     9.732    23.966     0.200
     9.793    23.418     0.200
     9.974    23.698     0.200
     9.997    24.622     0.200
     9.966    25.377     0.200
    10.088    26.098     0.200
    10.310    24.580     0.200
    10.572    25.294     0.200
    10.573    26.291     0.200
    10.789    25.541     0.200
    11.130    26.562     0.200
    11.146    27.376     0.200
    11.367    26.907     0.200
    11.452    27.590     0.200
    11.448    28.603     0.200
    11.380    29.505     0.200
    11.609    27.672     0.200
    11.589    28.126     0.200
    11.739    27.514     0.200
    11.749    27.675     0.200
    11.833    27.421     0.200
    11.916    28.423     0.200
    12.080    29.922     0.200
    12.523    30.017     0.200
    12.790    29.611     0.200
    12.755    30.259     0.200
    13.986    31.235     0.200
    14.823    34.155     0.200
    16.085    36.258     0.200
    16.415    36.415     0.200
     1.731     8.489     0.200
     2.721    10.678     0.200
     2.826    12.930     0.200
     2.826    13.149     0.200
     2.826    12.649     0.200
     3.065    13.778     0.200
     3.398    12.178     0.200
     3.587    15.235     0.200
     3.645    15.347     0.200
     4.068    12.935     0.200
     4.068    13.052     0.200
     4.313    16.561     0.200
     4.413    14.613     0.200
     4.413    14.925     0.200
     4.354    16.145     0.200
     4.454    16.690     0.200
     4.455    16.356     0.200
     4.644    14.804     0.200
     4.819    16.422     0.200
     4.821    16.354     0.200
     4.836    16.450     0.200
     4.845    16.617     0.200
     4.861    16.604     0.200
     4.861    16.463     0.200
     4.913    18.115     0.200
     4.947    16.847     0.200
     4.990    16.973     0.200
     5.116    17.124     0.200
     5.084    18.104     0.200
     5.446    17.356     0.200
     5.646    16.873     0.200
     5.646    17.177     0.200
     5.702    16.544     0.200
     5.875    18.467     0.200
     5.891    18.272     0.200
     5.805    19.480     0.200
     5.914    18.438     0.200
     5.916    18.544     0.200
     5.951    18.580     0.200
     5.995    16.618     0.200
     6.010    18.675     0.200
     6.043    18.432     0.200
     6.036    16.827     0.200
     6.036    16.679     0.200
     5.963    18.110     0.200
     6.505    20.229     0.200
     6.505    19.979     0.200
     6.637    17.066     0.200
     6.637    18.902     0.200
     6.707    19.336     0.200
     6.708    20.802     0.200
     6.711    20.773     0.200
     6.753    18.991     0.200
     6.763    17.838     0.200
     6.763    17.556     0.200
     6.808    19.969     0.200
     6.841    19.942     0.200
     6.911    18.831     0.200
     6.911    18.136     0.200
     7.033    20.113     0.200
     7.031    20.483     0.200
     7.058    20.259     0.200
     7.058    21.759     0.200
     7.220    19.791     0.200
     7.306    19.261     0.200
     7.306    20.089     0.200
     7.337    19.142     0.200
     7.337    19.392     0.200
     7.515    19.940     0.200
     7.515    21.049     0.200
     7.531    20.092     0.200
     7.718    19.911     0.200
     7.718    20.083     0.200
     7.720    20.256     0.200
     7.724    20.160     0.200
     7.905    19.883     0.200
     7.905    19.562     0.200
     8.003    19.772     0.200
     8.104    19.936     0.200
     8.126    20.607     0.200
     8.166    22.541     0.200
     8.166    23.127     0.200
     8.161    19.786     0.200
     8.161    20.294     0.200
     8.199    20.886     0.200
     8.199    21.589     0.200
     8.267    22.264     0.200
     8.267    22.912     0.200
     8.325    20.611     0.200
     8.330    19.597     0.200
     8.460    21.801     0.200
     8.519    22.102     0.200
     8.519    20.922     0.200
     8.524    21.336     0.200
     8.524    21.156     0.200
     8.567    22.144     0.200
     8.658    23.006     0.200
     8.658    23.694     0.200
     8.685    21.720     0.200
     8.831    21.838     0.200
     8.985    22.130     0.200
     8.985    22.380     0.200
     9.016    22.729     0.200
     9.020    22.912     0.200
     9.020    21.873     0.200
     9.039    24.992     0.200
     9.039    23.781     0.200
     9.042    23.576     0.200
     9.042    23.951     0.200
     9.071    23.015     0.200
     9.071    22.625     0.200
     9.077    21.981     0.200
     9.077    21.793     0.200
     9.067    22.015     0.200
     9.155    23.112     0.200
     9.173    22.542     0.200
     9.222    22.296     0.200
     9.222    22.124     0.200
     9.275    22.852     0.200
     9.275    23.407     0.200
     9.277    23.330     0.200
     9.393    22.709     0.200
     9.420    24.357     0.200
     9.487    22.791     0.200
     9.487    23.502     0.200
     9.467    23.842     0.200
     9.513    24.760     0.200
     9.558    22.797     0.200
     9.558    22.648     0.200
     9.567    23.362     0.200
     9.567    23.585     0.200
     9.638    24.051     0.200
     9.638    23.223     0.200
     9.648    23.785     0.200
     9.634    24.837     0.200
     9.754    25.754     0.200
     9.754    25.598     0.200
     9.749    23.461     0.200
     9.775    24.328     0.200
     9.796    23.474     0.200
     9.835    24.887     0.200
     9.835    25.074     0.200
     9.776    25.857     0.200
     9.776    26.755     0.200
     9.837    23.712     0.200
    10.061    23.055     0.200
    10.061    25.359     0.200
    10.095    24.528     0.200
    10.095    24.507     0.200
    10.095    23.968     0.200
    10.111    24.525     0.200
    10.223    25.069     0.200
    10.222    24.649     0.200
    10.298    26.095     0.200
    10.298    26.665     0.200
    10.329    24.098     0.200
    10.329    24.223     0.200
    10.371    24.606     0.200
    10.359    25.022     0.200
    10.459    23.854     0.200
    10.529    25.122     0.200
    10.535    25.344     0.200
    10.581    25.455     0.200
    10.649    27.075     0.200
    10.649    26.224     0.200
    10.640    26.046     0.200
    10.640    25.819     0.200
    10.638    25.313     0.200
    10.641    26.213     0.200
    10.674    24.346     0.200
    10.685    26.670     0.200
    10.705    24.562     0.200
    10.705    24.414     0.200
    10.746    25.412     0.200
    10.746    24.732     0.200
    10.734    25.403     0.200
    10.832    24.501     0.200
    10.830    24.600     0.200
    10.830    25.412     0.200
    10.847    25.683     0.200
    10.847    24.441     0.200
    10.850    25.650     0.200
    10.850    24.408     0.200
    10.833    26.920     0.200
    10.873    27.227     0.200
    10.873    26.016     0.200
    10.861    27.852     0.200
    10.962    25.279     0.200
    11.008    24.399     0.200
    11.008    24.617     0.200
    11.008    24.836     0.200
    11.022    26.040     0.200
    11.055    26.334     0.200
    11.055    26.764     0.200
    11.126    27.704     0.200
    11.126    28.712     0.200
    11.152    24.877     0.200
    11.152    24.642     0.200
    11.135    27.051     0.200
    11.269    25.332     0.200
    11.269    26.114     0.200
    11.301    25.506     0.200
    11.308    25.305     0.200
    11.301    28.169     0.200
    11.301    30.357     0.200
    11.363    27.631     0.200
    11.457    27.041     0.200
    11.457    27.541     0.200
    11.475    27.368     0.200
    11.467    28.753     0.200
    11.493    28.007     0.200
    11.656    25.110     0.200
    11.763    27.039     0.200
    11.942    27.514     0.200
    11.942    28.022     0.200
    11.986    29.378     0.200
    11.991    30.297     0.200
    12.351    28.726     0.200
    12.475    28.515     0.200
    12.475    28.733     0.200
    12.606    30.477     0.200
    12.724    28.690     0.200
    12.736    29.905     0.200
    12.817    30.368     0.200
    12.923    29.644     0.200
    12.923    30.503     0.200
    13.005    31.088     0.200
    13.025    29.915     0.200
    13.130    30.893     0.200
    13.130    31.885     0.200
    13.262    31.190     0.200
    13.262    31.026     0.200
    13.343    31.049     0.200
    13.343    31.463     0.200
    13.565    32.222     0.200
    13.565    30.660     0.200
    14.041    31.873     0.200
    14.184    32.525     0.200
    14.184    32.923     0.200
    14.430    33.004     0.200
    14.430    33.777     0.200
    14.489    33.354     0.200
    14.489    33.643     0.200
    14.660    33.828     0.200
    14.716    34.392     0.200
    15.252    35.684     0.200
    15.373    34.263     0.200
    15.699    36.524     0.200
    15.799    37.206     0.200
    15.819    37.125     0.200
    15.966    35.430     0.200
    15.966    34.914     0.200
    16.206    36.662     0.200
    16.206    35.459     0.200
    16.303    35.333     0.200
    16.605    37.135     0.200
    17.304    35.694     0.200
    17.304    34.764     0.200
    18.217    38.289     0.200
     0.815     6.500     0.200
     0.920     7.052     0.200
     0.817     6.620     0.200
     1.609     8.947     0.200
     1.719     7.746     0.200
     2.726     9.724     0.200
     2.846    12.484     0.200
     3.080    13.475     0.200
     3.183    13.562     0.200
     3.467    10.487     0.200
     3.467    10.741     0.200
     3.682    12.593     0.200
     3.602    14.651     0.200
     4.087    11.644     0.200
     4.087    11.869     0.200
     4.240    13.501     0.200
     4.412    14.129     0.200
     4.412    13.994     0.200
     4.453    13.140     0.200
     4.453    13.353     0.200
     4.325    15.624     0.200
     4.367    14.795     0.200
     4.673    13.530     0.200
     4.468    15.856     0.200
     4.838    14.717     0.200
     4.838    15.054     0.200
     4.863    15.154     0.200
     5.118    15.925     0.200
     4.872    16.010     0.200
     4.927    16.556     0.200
     4.959    16.348     0.200
     5.003    16.662     0.200
     5.337    16.265     0.200
     5.337    15.890     0.200
     5.506    16.063     0.200
     5.519    16.183     0.200
     5.681    15.911     0.200
     5.687    16.399     0.200
     5.735    15.009     0.200
     5.865    16.928     0.200
     5.865    17.346     0.200
     5.921    17.022     0.200
     5.951    16.398     0.200
     5.958    17.047     0.200
     5.960    17.384     0.200
     5.962    16.893     0.200
     5.998    17.199     0.200
     6.057    17.427     0.200
     6.068    15.660     0.200
     6.068    15.519     0.200
     6.089    17.619     0.200
     6.730    18.327     0.200
     6.738    18.721     0.200
     6.754    18.107     0.200
     6.513    18.796     0.200
     6.513    19.395     0.200
     6.789    17.050     0.200
     6.794    16.115     0.200
     6.794    16.535     0.200
     6.855    18.981     0.200
     6.899    19.496     0.200
     6.899    19.350     0.200
     6.764    20.396     0.200
     6.946    18.724     0.200
     6.946    18.986     0.200
     7.093    19.390     0.200
     7.112    20.229     0.200
     7.350    19.265     0.200
     7.376    18.757     0.200
     7.523    20.947     0.200
     7.564    19.369     0.200
     7.668    20.308     0.200
     7.692    20.539     0.200
     7.692    20.275     0.200
     7.737    19.652     0.200
     7.737    19.820     0.200
     7.762    19.741     0.200
     7.741    19.504     0.200
     7.945    19.358     0.200
     8.040    20.971     0.200
     8.040    19.516     0.200
     8.151    19.872     0.200
     8.191    20.107     0.200
     8.191    18.562     0.200
     8.220    23.586     0.200
     8.326    21.492     0.200
     8.326    21.277     0.200
     8.363    20.323     0.200
     8.363    20.676     0.200
     8.358    19.197     0.200
     8.490    20.415     0.200
     8.548    20.112     0.200
     8.556    20.935     0.200
     8.713    23.477     0.200
     8.713    22.468     0.200
     8.722    20.960     0.200
     8.722    20.712     0.200
     8.859    21.179     0.200
     9.016    21.787     0.200
     9.016    21.453     0.200
     9.064    21.133     0.200
     9.069    22.760     0.200
     9.096    23.287     0.200
     9.087    22.338     0.200
     9.104    23.660     0.200
     9.104    22.586     0.200
     9.122    22.276     0.200
     9.122    22.112     0.200
     9.119    20.957     0.200
     9.119    20.634     0.200
     9.174    22.216     0.200
     9.190    22.403     0.200
     9.247    23.097     0.200
     9.247    21.558     0.200
     9.310    22.710     0.200
     9.310    21.923     0.200
     9.441    22.309     0.200
     9.441    23.250     0.200
     9.441    23.447     0.200
     9.485    22.310     0.200
     9.542    22.891     0.200
     9.542    22.498     0.200
     9.585    22.582     0.200
     9.596    22.617     0.200
     9.687    23.972     0.200
     9.687    22.607     0.200
     9.664    23.932     0.200
     9.767    23.144     0.200
     9.823    22.712     0.200
     9.870    23.431     0.200
     9.870    23.313     0.200
     9.829    24.754     0.200
     9.829    23.658     0.200
     9.861    23.772     0.200
    10.061    24.461     0.200
    10.075    24.201     0.200
    10.119    24.859     0.200
    10.119    23.978     0.200
    10.133    24.240     0.200
    10.133    23.871     0.200
    10.238    24.198     0.200
    10.357    25.180     0.200
    10.380    23.864     0.200
    10.380    23.221     0.200
    10.377    24.382     0.200
    10.427    24.413     0.200
    10.427    23.825     0.200
    10.555    25.736     0.200
    10.624    24.694     0.200
    10.657    24.960     0.200
    10.660    25.778     0.200
    10.670    26.011     0.200
    10.670    25.089     0.200
    10.693    26.585     0.200
    10.693    26.248     0.200
    10.752    24.000     0.200
    10.752    23.211     0.200
    10.752    25.563     0.200
    10.724    26.828     0.200
    10.799    24.863     0.200
    10.799    23.400     0.200
    10.870    26.006     0.200
    10.870    25.049     0.200
    10.846    26.213     0.200
    10.846    25.877     0.200
    10.883    24.029     0.200
    10.898    23.935     0.200
    10.901    22.832     0.200
    10.901    23.853     0.200
    10.899    26.753     0.200
    10.908    26.221     0.200
    10.908    25.682     0.200
    11.057    24.062     0.200
    11.057    23.712     0.200
    11.061    25.939     0.200
    11.084    25.223     0.200
    11.102    26.407     0.200
    11.143    26.229     0.200
    11.202    24.629     0.200
    11.202    28.552     0.200
    11.308    26.312     0.200
    11.308    25.225     0.200
    11.345    25.182     0.200
    11.345    24.584     0.200
    11.364    25.148     0.200
    11.386    27.166     0.200
    11.486    27.596     0.200
    11.507    26.565     0.200
    11.709    25.411     0.200
    11.709    24.438     0.200
    11.804    26.215     0.200
    11.804    26.072     0.200
    11.979    28.141     0.200
    11.979    26.471     0.200
    12.002    28.315     0.200
    12.010    29.544     0.200
    12.534    31.565     0.200
    12.534    26.815     0.200
    12.611    29.573     0.200
    12.753    29.332     0.200
    12.890    28.930     0.200
    12.956    29.753     0.200
    12.956    29.600     0.200
    13.018    29.903     0.200
    13.016    29.179     0.200
    13.135    30.500     0.200
    13.135    31.359     0.200
    13.285    30.937     0.200
    13.285    31.101     0.200
    13.359    31.649     0.200
    13.359    31.063     0.200
    13.520    32.259     0.200
    13.570    31.081     0.200
    13.940    31.431     0.200
    14.078    30.645     0.200
    14.203    30.976     0.200
    14.413    32.857     0.200
    14.497    33.129     0.200
    14.678    33.607     0.200
    14.704    33.147     0.200
    15.718    35.702     0.200
    15.790    35.481     0.200
    15.818    35.448     0.200
    15.818    35.835     0.200
    16.239    34.907     0.200
    16.883    36.467     0.200
    17.347    34.153     0.200
    17.347    35.237     0.200
     1.132     6.450     0.200
     1.159     7.088     0.200
     1.160     7.077     0.200
     1.208     7.913     0.200
     1.378     6.299     0.200
     1.225     7.738     0.200
     1.258     7.687     0.200
     1.281     8.105     0.200
     1.353     8.237     0.200
     1.467     8.145     0.200
     1.487     8.268     0.200
     2.163    10.469     0.200
     2.163     9.563     0.200
     2.419     9.132     0.200
     2.355    10.481     0.200
     2.502    11.719     0.200
     2.521    11.976     0.200
     2.884    12.150     0.200
     2.909    12.942     0.200
     3.114    11.215     0.200
     2.980    12.637     0.200
     3.420    11.013     0.200
     3.672    14.759     0.200
     3.965    12.885     0.200
     4.019    13.154     0.200
     4.147    11.756     0.200
     4.147    12.014     0.200
     4.175    15.428     0.200
     4.363    13.931     0.200
     4.442    13.425     0.200
     4.308    14.894     0.200
     4.557    13.690     0.200
     4.432    14.944     0.200
     4.754    13.252     0.200
     4.754    13.112     0.200
     4.754    12.854     0.200
     4.861    14.507     0.200
     4.910    13.988     0.200
     4.910    14.394     0.200
     5.039    14.728     0.200
     5.307    15.261     0.200
     5.309    15.243     0.200
     5.316    15.648     0.200
     5.381    15.849     0.200
     5.430    16.729     0.200
     5.434    15.176     0.200
     5.721    16.576     0.200
     5.921    16.841     0.200
     5.813    18.285     0.200
     6.005    17.450     0.200
     6.071    16.928     0.200
     6.334    17.923     0.200
     6.351    17.395     0.200
     6.366    17.220     0.200
     6.244    19.044     0.200
     6.497    17.965     0.200
     6.503    19.199     0.200
     6.530    18.345     0.200
     6.642    16.772     0.200
     6.687    17.168     0.200
     7.334    19.518     0.200
     7.386    19.990     0.200
     7.418    19.595     0.200
     7.505    19.970     0.200
     7.552    20.953     0.200
     7.588    21.200     0.200
     7.588    20.223     0.200
     7.902    20.703     0.200
     7.960    20.793     0.200
     7.959    20.978     0.200
     8.024    20.828     0.200
     8.048    21.113     0.200
     8.080    21.087     0.200
     8.320    20.385     0.200
     8.320    20.228     0.200
     8.690    23.442     0.200
     8.719    23.432     0.200
     8.735    22.606     0.200
     8.798    21.828     0.200
     8.818    21.714     0.200
     8.995    20.432     0.200
     9.118    21.597     0.200
     9.197    21.948     0.200
     9.318    23.847     0.200
     9.509    23.292     0.200
     9.493    24.446     0.200
     9.588    23.305     0.200
     9.619    24.191     0.200
     9.638    23.595     0.200
     9.654    23.157     0.200
     9.750    24.331     0.200
     9.861    24.707     0.200
     9.894    23.771     0.200
     9.912    24.363     0.200
     9.966    25.569     0.200
    10.026    24.083     0.200
    10.007    23.331     0.200
    10.227    24.593     0.200
    10.337    25.118     0.200
    10.435    24.885     0.200
    10.464    25.336     0.200
    10.728    25.899     0.200
    10.627    29.129     0.200
    10.875    25.920     0.200
    10.911    26.236     0.200
    11.044    26.258     0.200
    11.086    28.093     0.200
    11.219    27.313     0.200
    11.294    27.595     0.200
    11.266    27.486     0.200
    11.324    26.360     0.200
    11.376    28.048     0.200
    11.442    26.866     0.200
    11.527    27.297     0.200
    11.575    25.112     0.200
    11.575    25.925     0.200
    11.716    27.867     0.200
    11.787    28.843     0.200
    11.815    27.269     0.200
    11.883    27.047     0.200
    11.887    27.929     0.200
    12.105    28.782     0.200
    12.123    28.396     0.200
    12.186    29.252     0.200
    12.369    29.164     0.200
    12.570    28.736     0.200
    13.047    29.965     0.200
    13.936    32.112     0.200
    13.987    32.532     0.200
    14.251    32.685     0.200
     1.026     7.515     0.200
     1.063     8.497     0.200
     1.064     8.487     0.200
     1.263     7.045     0.200
     1.276     8.974     0.200
     1.311     8.814     0.200
     1.337     9.246     0.200
     1.401    10.080     0.200
     1.495     9.317     0.200
     1.557     8.932     0.200
     1.894     9.494     0.200
     2.327     8.982     0.200
     2.241    12.241     0.200
     2.436    12.131     0.200
     2.473    12.373     0.200
     2.599    10.659     0.200
     2.602    13.459     0.200
     2.660    12.750     0.200
     2.999    11.607     0.200
     3.063    11.913     0.200
     2.967    13.885     0.200
     3.154    13.652     0.200
     3.086    13.546     0.200
     3.319    11.308     0.200
     3.813    13.566     0.200
     3.850    13.492     0.200
     3.760    14.301     0.200
     3.947    15.016     0.200
     3.914    14.184     0.200
     4.040    12.352     0.200
     4.248    15.443     0.200
     4.331    14.844     0.200
     4.265    15.393     0.200
     4.319    16.461     0.200
     4.454    15.354     0.200
     4.645    13.564     0.200
     4.753    15.502     0.200
     4.796    15.261     0.200
     4.924    16.431     0.200
     5.203    17.681     0.200
     5.282    16.928     0.200
     5.606    18.187     0.200
     5.723    18.172     0.200
     5.811    18.076     0.200
     5.890    18.935     0.200
     6.237    17.715     0.200
     6.221    19.230     0.200
     6.256    17.763     0.200
     6.383    19.646     0.200
     7.170    20.456     0.200
     7.224    20.643     0.200
     7.396    20.782     0.200
     7.943    22.073     0.200
     8.206    21.649     0.200
     8.578    24.274     0.200
     8.626    24.166     0.200
     8.831    22.932     0.200
     8.882    22.479     0.200
     9.085    22.371     0.200
     9.060    26.070     0.200
     9.203    24.183     0.200
     9.524    24.540     0.200
     9.506    23.942     0.200
     9.782    25.213     0.200
     9.798    25.667     0.200
     9.915    24.240     0.200
    10.044    26.209     0.200
    10.113    25.434     0.200
    10.351    25.834     0.200
    10.603    26.742     0.200
    10.667    27.702     0.200
    10.978    28.157     0.200
     1.215     7.171     0.200
     1.219     6.639     0.200
     1.219     6.779     0.200
     1.604     6.460     0.200
     1.874     8.614     0.200
     1.932     9.604     0.200
     1.975     9.849     0.200
     2.009     9.964     0.200
     2.036    10.466     0.200
     2.202     9.553     0.200
     2.278     9.615     0.200
     2.285     9.765     0.200
     2.275    10.388     0.200
     2.522     9.334     0.200
     2.522     9.034     0.200
     3.067    10.898     0.200
     2.975    12.956     0.200
     2.975    12.538     0.200
     3.083    11.159     0.200
     3.147    11.671     0.200
     3.219    10.195     0.200
     3.219    10.410     0.200
     3.181    12.728     0.200
     3.288    12.028     0.200
     3.307    12.993     0.200
     3.450    11.978     0.200
     3.390    12.541     0.200
     3.611    12.377     0.200
     3.611    11.822     0.200
     3.814    11.802     0.200
     3.814    11.677     0.200
     3.847    12.725     0.200
     3.847    12.428     0.200
     3.830    14.526     0.200
     4.033    13.286     0.200
     4.033    12.567     0.200
     4.108    13.388     0.200
     4.108    13.079     0.200
     4.088    13.377     0.200
     4.088    13.236     0.200
     4.362    13.155     0.200
     4.364    13.982     0.200
     4.456    13.725     0.200
     4.456    12.959     0.200
     4.507    16.008     0.200
     4.511    15.315     0.200
     4.480    16.513     0.200
     4.521    14.399     0.200
     4.609    15.823     0.200
     4.622    17.091     0.200
     4.729    15.215     0.200
     4.729    14.910     0.200
     4.667    15.961     0.200
     4.683    16.501     0.200
     4.802    16.126     0.200
     4.802    13.966     0.200
     4.960    15.211     0.200
     4.960    14.867     0.200
     5.094    15.294     0.200
     5.115    15.660     0.200
     5.115    15.242     0.200
     5.034    15.203     0.200
     5.034    16.234     0.200
     5.159    15.667     0.200
     5.115    17.279     0.200
     5.330    17.170     0.200
     5.330    15.034     0.200
     5.347    15.199     0.200
     5.254    17.289     0.200
     5.285    17.293     0.200
     5.410    15.041     0.200
     5.481    16.978     0.200
     5.481    15.966     0.200
     5.557    17.520     0.200
     5.560    16.555     0.200
     5.595    17.594     0.200
     5.631    17.621     0.200
     5.690    17.710     0.200
     5.701    15.992     0.200
     5.724    17.497     0.200
     5.745    15.736     0.200
     5.745    15.857     0.200
     6.326    17.388     0.200
     6.361    17.919     0.200
     6.375    19.130     0.200
     6.452    17.963     0.200
     6.510    18.700     0.200
     6.510    18.540     0.200
     6.702    18.616     0.200
     6.702    18.839     0.200
     6.730    19.127     0.200
     6.730    19.514     0.200
     6.685    20.436     0.200
     6.685    20.120     0.200
     7.032    20.109     0.200
     7.032    19.410     0.200
     7.135    20.159     0.200
     7.135    19.733     0.200
     7.274    19.761     0.200
     7.298    20.412     0.200
     7.298    20.107     0.200
     7.380    18.776     0.200
     7.380    19.253     0.200
     7.404    19.747     0.200
     7.701    19.999     0.200
     7.701    19.565     0.200
     7.853    19.736     0.200
     7.838    21.898     0.200
     7.875    19.553     0.200
     7.878    20.367     0.200
     7.936    20.669     0.200
     7.936    20.782     0.200
     8.019    21.072     0.200
     8.050    19.362     0.200
     8.217    21.305     0.200
     8.252    20.815     0.200
     8.252    20.561     0.200
     8.329    21.776     0.200
     8.384    20.721     0.200
     8.569    21.979     0.200
     8.569    21.569     0.200
     8.620    21.564     0.200
     8.696    21.895     0.200
     8.696    22.016     0.200
     8.689    23.167     0.200
     8.709    21.280     0.200
     8.704    21.105     0.200
     8.709    23.472     0.200
     8.709    23.215     0.200
     8.712    23.984     0.200
     8.746    22.962     0.200
     8.746    22.345     0.200
     8.767    21.630     0.200
     8.767    20.654     0.200
     8.807    21.656     0.200
     8.949    22.424     0.200
     8.949    22.682     0.200
     8.977    23.200     0.200
     8.977    23.317     0.200
     9.048    23.219     0.200
     9.169    24.723     0.200
     9.159    24.144     0.200
     9.245    22.356     0.200
     9.245    23.567     0.200
     9.283    23.608     0.200
     9.283    23.710     0.200
     9.316    22.299     0.200
     9.398    23.963     0.200
     9.518    22.897     0.200
     9.472    24.396     0.200
     9.538    24.335     0.200
     9.641    23.979     0.200
     9.790    24.746     0.200
     9.790    24.442     0.200
     9.814    23.523     0.200
     9.821    24.566     0.200
     9.858    24.914     0.200
     9.972    25.148     0.200
     9.967    25.381     0.200
    10.002    24.837     0.200
    10.002    24.201     0.200
     9.929    26.300     0.200
    10.042    26.539     0.200
    10.042    25.961     0.200
    10.136    24.183     0.200
    10.268    25.600     0.200
    10.301    25.744     0.200
    10.351    25.818     0.200
    10.351    25.169     0.200
    10.351    24.285     0.200
    10.378    24.992     0.200
    10.388    26.465     0.200
    10.384    24.729     0.200
    10.479    25.100     0.200
    10.506    25.588     0.200
    10.520    25.882     0.200
    10.520    25.554     0.200
    10.505    26.187     0.200
    10.523    23.887     0.200
    10.526    23.920     0.200
    10.526    24.811     0.200
    10.526    24.186     0.200
    10.576    25.637     0.200
    10.595    25.744     0.200
    10.687    24.564     0.200
    10.687    24.185     0.200
    10.687    24.654     0.200
    10.726    27.862     0.200
    10.772    26.888     0.200
    10.834    27.265     0.200
    10.828    25.947     0.200
    10.828    24.650     0.200
    10.858    25.100     0.200
    10.907    25.441     0.200
    10.960    26.081     0.200
    10.984    25.530     0.200
    10.979    26.672     0.200
    10.979    26.004     0.200
    11.047    26.584     0.200
    11.165    27.375     0.200
    11.165    26.770     0.200
    11.183    27.260     0.200
    11.459    27.893     0.200
    11.452    27.834     0.200
    11.452    27.412     0.200
    11.443    29.371     0.200
    11.725    28.071     0.200
    11.715    27.717     0.200
    12.226    28.782     0.200
    12.389    29.674     0.200
    12.418    28.603     0.200
    12.628    29.785     0.200
    12.764    30.425     0.200
    12.914    31.023     0.200
    12.991    31.541     0.200
    12.991    31.072     0.200
    13.091    31.388     0.200
    13.091    30.243     0.200
    13.229    31.243     0.200
    13.322    30.516     0.200
    13.902    33.173     0.200
    14.263    34.269     0.200
    14.853    33.594     0.200
    15.067    36.284     0.200
    15.133    35.253     0.200
    15.439    35.450     0.200
    15.625    37.132     0.200
    15.625    35.007     0.200
    16.278    35.728     0.200
    16.990    37.398     0.200
    16.990    36.351     0.200
     1.027     7.100     0.200
     1.065     6.239     0.200
     1.065     6.554     0.200
     1.071     7.260     0.200
     1.170     7.889     0.200
     1.170     7.928     0.200
     1.572     8.818     0.200
     1.623     8.816     0.200
     1.796     8.118     0.200
     1.821     9.357     0.200
     1.858     9.389     0.200
     1.885     9.316     0.200
     1.943     9.872     0.200
     2.109     9.701     0.200
     2.398     9.832     0.200
     2.700    11.158     0.200
     2.774    11.494     0.200
     2.821     9.821     0.200
     2.821    10.135     0.200
     2.821    10.360     0.200
     2.793    10.993     0.200
     2.791    12.845     0.200
     2.791    12.007     0.200
     2.791    12.314     0.200
     2.984    12.079     0.200
     3.002    12.591     0.200
     3.150    13.039     0.200
     3.210    12.806     0.200
     3.522    11.899     0.200
     3.572    11.068     0.200
     3.570    12.500     0.200
     3.604    12.502     0.200
     3.630    12.500     0.200
     3.632    13.933     0.200
     3.812    13.182     0.200
     3.942    12.962     0.200
     4.093    13.369     0.200
     4.133    13.550     0.200
     4.133    13.423     0.200
     4.197    11.927     0.200
     4.197    12.304     0.200
     4.259    14.752     0.200
     4.370    13.688     0.200
     4.301    14.979     0.200
     4.544    14.252     0.200
     4.580    13.847     0.200
     4.580    13.652     0.200
     4.614    14.320     0.200
     4.793    13.945     0.200
     4.794    13.967     0.200
     4.803    15.212     0.200
     4.971    15.035     0.200
     4.971    15.388     0.200
     4.991    15.535     0.200
     5.021    15.508     0.200
     5.027    15.917     0.200
     5.245    16.105     0.200
     5.287    15.591     0.200
     5.288    15.901     0.200
     5.470    15.681     0.200
     5.470    16.081     0.200
     5.585    16.313     0.200
     5.649    16.509     0.200
     5.639    16.500     0.200
     5.639    16.322     0.200
     5.806    16.667     0.200
     5.816    16.912     0.200
     5.857    15.859     0.200
     5.998    18.007     0.200
     5.998    17.752     0.200
     6.051    17.562     0.200
     6.091    17.109     0.200
     6.093    17.691     0.200
     6.084    17.236     0.200
     6.129    17.110     0.200
     6.151    15.828     0.200
     6.190    16.038     0.200
     6.773    20.145     0.200
     6.773    19.639     0.200
     6.881    19.606     0.200
     6.885    19.839     0.200
     6.915    17.341     0.200
     6.915    17.447     0.200
     6.914    17.359     0.200
     7.032    19.892     0.200
     7.032    19.478     0.200
     7.070    20.229     0.200
     6.995    20.596     0.200
     7.226    19.778     0.200
     7.226    19.551     0.200
     7.244    20.529     0.200
     7.244    20.255     0.200
     7.502    18.810     0.200
     7.502    18.667     0.200
     7.656    21.462     0.200
     7.656    20.704     0.200
     7.829    18.683     0.200
     7.829    18.892     0.200
     7.845    20.013     0.200
     7.800    20.661     0.200
     7.849    20.054     0.200
     7.823    20.482     0.200
     7.891    21.221     0.200
     8.072    22.102     0.200
     8.166    21.800     0.200
     8.166    19.726     0.200
     8.267    19.920     0.200
     8.311    19.533     0.200
     8.353    22.815     0.200
     8.353    22.712     0.200
     8.476    19.300     0.200
     8.459    21.589     0.200
     8.459    21.970     0.200
     8.490    21.416     0.200
     8.664    20.018     0.200
     8.664    20.473     0.200
     8.847    21.422     0.200
     8.945    22.860     0.200
     8.945    22.635     0.200
     9.040    21.678     0.200
     9.137    21.604     0.200
     9.137    21.874     0.200
     9.198    22.964     0.200
     9.194    21.827     0.200
     9.237    24.202     0.200
     9.237    23.358     0.200
     9.254    23.545     0.200
     9.254    23.013     0.200
     9.283    22.636     0.200
     9.298    23.502     0.200
     9.363    23.294     0.200
     9.434    23.082     0.200
     9.434    23.215     0.200
     9.572    23.292     0.200
     9.571    24.219     0.200
     9.715    23.097     0.200
     9.715    22.829     0.200
     9.730    22.103     0.200
     9.771    23.652     0.200
     9.819    24.338     0.200
     9.940    22.975     0.200
     9.994    24.481     0.200
     9.939    25.094     0.200
    10.019    24.603     0.200
    10.170    25.054     0.200
    10.237    25.487     0.200
    10.259    24.837     0.200
    10.259    24.429     0.200
    10.345    26.220     0.200
    10.513    23.989     0.200
    10.561    25.504     0.200
    10.651    26.683     0.200
    10.640    23.966     0.200
    10.752    25.816     0.200
    10.791    26.453     0.200
    10.791    25.629     0.200
    10.843    27.248     0.200
    10.826    27.315     0.200
    10.826    25.942     0.200
    10.855    23.929     0.200
    10.882    24.165     0.200
    10.949    26.601     0.200
    10.998    26.637     0.200
    11.031    26.318     0.200
    11.015    24.855     0.200
    11.187    26.794     0.200
    11.210    27.002     0.200
    11.203    27.466     0.200
    11.203    26.595     0.200
    11.188    23.640     0.200
    11.188    24.050     0.200
    11.188    24.370     0.200
    11.242    26.866     0.200
    11.249    27.410     0.200
    11.436    27.879     0.200
    11.436    27.270     0.200
    11.475    25.386     0.200
    11.475    25.050     0.200
    11.497    25.806     0.200
    11.573    27.705     0.200
    11.611    27.365     0.200
    11.611    27.066     0.200
    11.629    27.395     0.200
    11.812    27.102     0.200
    11.841    28.314     0.200
    11.841    27.986     0.200
    11.932    27.401     0.200
    11.932    27.065     0.200
    12.052    30.072     0.200
    12.052    29.514     0.200
    12.105    28.488     0.200
    12.218    29.025     0.200
    12.263    29.691     0.200
    12.544    30.643     0.200
    12.639    29.461     0.200
    12.627    27.368     0.200
    12.627    27.495     0.200
    12.862    30.085     0.200
    13.079    30.100     0.200
    13.079    30.346     0.200
    13.229    32.372     0.200
    13.294    30.319     0.200
    13.467    32.915     0.200
    13.672    32.067     0.200
    13.711    31.109     0.200
    14.062    32.526     0.200
    14.073    35.286     0.200
    14.141    32.440     0.200
    14.314    34.011     0.200
    14.595    35.481     0.200
    14.595    35.117     0.200
    14.788    34.467     0.200
    14.788    34.192     0.200
    15.328    34.185     0.200
    15.439    34.307     0.200
    15.829    35.943     0.200
    15.904    37.461     0.200
    17.476    35.689     0.200
    17.476    35.390     0.200
     1.194     7.125     0.200
     1.194     6.636     0.200
     1.474     6.264     0.200
     1.550     8.319     0.200
     1.551     8.318     0.200
     1.971     6.763     0.200
     1.971     6.513     0.200
     2.030     9.430     0.200
     1.909     9.499     0.200
     1.938     9.452     0.200
     1.958     9.762     0.200
     2.137    10.021     0.200
     3.042     8.793     0.200
     3.072    11.269     0.200
     2.960    12.030     0.200
     2.984    12.259     0.200
     2.993    12.566     0.200
     3.175    10.899     0.200
     3.120    12.999     0.200
     3.128    12.286     0.200
     3.597    13.950     0.200
     3.824    10.091     0.200
     3.824    10.318     0.200
     3.999    12.340     0.200
     4.221    12.735     0.200
     4.196    14.902     0.200
     4.239    14.877     0.200
     4.468    11.387     0.200
     4.468    11.891     0.200
     4.339    15.168     0.200
     4.339    14.821     0.200
     4.386    15.211     0.200
     4.780    13.572     0.200
     4.727    14.651     0.200
     4.727    15.269     0.200
     4.925    16.031     0.200
     4.925    14.863     0.200
     4.821    15.424     0.200
     5.019    14.892     0.200
     5.099    13.250     0.200
     5.101    13.234     0.200
     4.953    16.230     0.200
     4.988    16.125     0.200
     5.358    15.171     0.200
     5.656    16.227     0.200
     5.849    17.334     0.200
     6.039    18.385     0.200
     6.039    16.483     0.200
     6.175    18.641     0.200
     6.385    17.893     0.200
     6.385    17.018     0.200
     6.455    20.084     0.200
     6.482    19.359     0.200
     6.339    18.364     0.200
     6.339    18.548     0.200
     7.225    18.896     0.200
     7.250    21.751     0.200
     7.393    20.377     0.200
     7.426    20.160     0.200
     7.426    19.648     0.200
     7.628    21.874     0.200
     7.628    21.476     0.200
     7.624    20.214     0.200
     7.840    21.594     0.200
     7.835    20.740     0.200
     8.050    21.105     0.200
     8.066    23.086     0.200
     8.146    19.980     0.200
     8.413    21.189     0.200
     8.552    20.594     0.200
     8.614    23.498     0.200
     8.771    21.311     0.200
     8.827    22.926     0.200
     8.858    23.854     0.200
     8.946    21.635     0.200
     9.175    22.814     0.200
     9.197    23.145     0.200
     9.445    22.571     0.200
     9.461    23.395     0.200
     9.647    22.795     0.200
     9.630    24.966     0.200
     9.638    25.502     0.200
     9.732    23.126     0.200
     9.758    24.899     0.200
     9.937    25.265     0.200
    10.015    24.699     0.200
     9.981    25.325     0.200
    10.060    26.419     0.200
    10.080    24.924     0.200
    10.132    24.395     0.200
    10.188    24.213     0.200
    10.230    24.316     0.200
    10.283    24.258     0.200
    10.591    25.970     0.200
    10.593    26.292     0.200
    10.896    26.621     0.200
    10.950    28.690     0.200
    11.031    26.224     0.200
    11.116    27.580     0.200
    11.165    29.057     0.200
    11.198    28.277     0.200
    11.426    26.342     0.200
    11.555    26.801     0.200
    11.555    25.766     0.200
    11.775    27.905     0.200
    11.832    27.190     0.200
    11.922    29.207     0.200
    11.940    27.190     0.200
    12.258    28.434     0.200
    12.277    27.415     0.200
    16.066    35.394     0.200
     1.182     6.784     0.200
     1.182     7.167     0.200
     2.060     9.502     0.200
     2.316     9.051     0.200
     2.316     9.707     0.200
     3.039     9.585     0.200
     3.039    10.046     0.200
     3.663    12.453     0.200
     4.112    11.952     0.200
     4.112    12.343     0.200
     4.112    12.655     0.200
     4.700    14.834     0.200
     4.878    15.261     0.200
     4.891    13.887     0.200
     4.985    15.728     0.200
     5.275    15.843     0.200
     5.399    16.365     0.200
     5.522    16.324     0.200
     5.531    14.961     0.200
     5.531    14.485     0.200
     5.826    16.948     0.200
     5.851    16.810     0.200
     5.851    17.123     0.200
     6.021    16.354     0.200
     5.927    16.343     0.200
     5.927    16.992     0.200
     6.143    16.988     0.200
     6.264    17.371     0.200
     6.264    18.301     0.200
     6.337    18.542     0.200
     6.628    18.707     0.200
     6.778    18.728     0.200
     6.778    19.228     0.200
     6.883    18.882     0.200
     6.921    18.372     0.200
     7.156    19.136     0.200
     7.157    19.344     0.200
     7.209    18.168     0.200
     7.285    20.308     0.200
     7.516    20.213     0.200
     7.541    18.976     0.200
     8.150    21.988     0.200
     8.185    21.742     0.200
     8.186    21.532     0.200
     8.266    20.243     0.200
     8.266    21.470     0.200
     8.265    20.489     0.200
     8.294    22.089     0.200
     8.468    21.955     0.200
     8.538    23.101     0.200
     8.734    19.576     0.200
     8.817    21.601     0.200
     8.817    22.288     0.200
     8.851    21.498     0.200
     8.851    21.928     0.200
     8.919    23.866     0.200
     9.013    22.345     0.200
     9.013    22.939     0.200
     9.015    22.042     0.200
     9.015    23.097     0.200
     9.012    21.846     0.200
     9.165    22.266     0.200
     9.165    22.594     0.200
     9.169    22.282     0.200
     9.181    21.356     0.200
     9.181    21.848     0.200
     9.230    23.213     0.200
     9.419    22.893     0.200
     9.516    22.673     0.200
     9.618    22.518     0.200
     9.643    24.974     0.200
     9.643    26.490     0.200
     9.699    24.488     0.200
     9.704    23.380     0.200
     9.838    23.225     0.200
    10.005    23.770     0.200
    10.005    24.473     0.200
    10.032    24.883     0.200
    10.128    25.942     0.200
    10.269    25.195     0.200
    10.198    24.603     0.200
    10.266    25.751     0.200
    10.458    26.570     0.200
    10.488    24.912     0.200
    10.497    26.637     0.200
    10.530    24.377     0.200
    10.563    25.079     0.200
    10.591    24.128     0.200
    10.619    26.777     0.200
    10.708    26.568     0.200
    10.705    25.067     0.200
    10.786    25.743     0.200
    10.961    25.786     0.200
    11.064    26.296     0.200
    11.071    25.113     0.200
    11.138    25.061     0.200
    11.138    25.522     0.200
    11.285    25.803     0.200
    11.345    27.428     0.200
    11.493    27.849     0.200
    11.493    27.302     0.200
    11.577    27.806     0.200
    11.609    27.270     0.200
    11.661    27.312     0.200
    11.739    28.872     0.200
    11.816    25.703     0.200
    11.834    26.707     0.200
    12.051    28.663     0.200
    12.051    28.952     0.200
    12.094    28.628     0.200
    12.141    28.452     0.200
    12.210    25.890     0.200
    12.223    26.793     0.200
    12.249    29.783     0.200
    12.249    28.400     0.200
    12.342    27.932     0.200
    12.344    28.244     0.200
    12.345    26.906     0.200
    12.345    27.172     0.200
    12.345    26.476     0.200
    12.383    29.429     0.200
    12.496    30.097     0.200
    12.510    26.896     0.200
    12.510    26.061     0.200
    12.524    29.981     0.200
    12.524    30.388     0.200
    12.528    29.143     0.200
    12.551    29.083     0.200
    12.647    27.694     0.200
    12.771    30.683     0.200
    12.773    27.523     0.200
    12.783    27.976     0.200
    12.810    27.209     0.200
    12.839    30.422     0.200
    12.924    30.649     0.200
    12.962    29.997     0.200
    12.985    30.436     0.200
    13.110    30.704     0.200
    13.137    28.069     0.200
    13.277    29.953     0.200
    13.325    31.274     0.200
    13.425    32.418     0.200
    13.423    32.379     0.200
    13.443    33.073     0.200
    13.456    28.986     0.200
    13.455    30.484     0.200
    13.472    30.815     0.200
    13.778    32.276     0.200
    13.808    31.285     0.200
    13.830    33.775     0.200
    13.911    31.156     0.200
    13.965    29.560     0.200
    13.967    31.500     0.200
    13.980    32.225     0.200
    14.117    32.346     0.200
    14.182    32.289     0.200
    14.238    31.609     0.200
    14.242    31.081     0.200
    14.422    34.042     0.200
    14.422    32.928     0.200
    14.431    32.413     0.200
    14.431    33.257     0.200
    14.486    34.208     0.200
    14.522    33.400     0.200
    14.580    32.949     0.200
    14.636    32.552     0.200
    14.661    32.770     0.200
    14.743    33.186     0.200
    14.763    33.971     0.200
    14.783    34.979     0.200
    14.814    34.660     0.200
    14.963    33.231     0.200
    14.966    35.283     0.200
    15.014    32.966     0.200
    15.018    35.191     0.200
    15.073    34.298     0.200
    15.095    32.837     0.200
    15.098    34.217     0.200
    15.201    33.961     0.200
    15.303    34.294     0.200
    15.428    33.366     0.200
    15.319    34.316     0.200
    15.450    34.717     0.200
    15.469    32.583     0.200
    15.487    34.279     0.200
    15.515    35.223     0.200
    15.546    34.328     0.200
    15.555    36.280     0.200
    15.554    35.307     0.200
    15.640    35.625     0.200
    15.870    36.086     0.200
    15.870    36.484     0.200
    15.898    36.253     0.200
    15.939    36.497     0.200
    15.977    36.672     0.200
    16.112    35.953     0.200
    16.277    35.469     0.200
    16.417    35.897     0.200
    16.420    36.059     0.200
    16.432    36.179     0.200
    16.505    35.449     0.200
    16.521    37.094     0.200
    16.675    35.586     0.200
    16.685    35.862     0.200
    17.019    37.721     0.200
    17.187    37.265     0.200
    17.208    35.957     0.200
    17.261    35.765     0.200
    19.172    38.767     0.200
    20.220    38.605     0.200
    20.771    37.528     0.200
     1.492    11.709     0.200
     1.540    11.995     0.200
     1.540    12.588     0.200
     2.402    12.012     0.200
     2.402    12.395     0.200
     2.866    15.065     0.200
     3.366    13.332     0.200
     3.337    16.525     0.200
     3.710    15.269     0.200
     4.143    16.068     0.200
     4.410    15.545     0.200
     4.410    15.795     0.200
     4.410    15.912     0.200
     4.916    17.505     0.200
     5.160    16.508     0.200
     4.930    19.729     0.200
     4.930    20.347     0.200
     5.388    17.862     0.200
     5.423    17.610     0.200
     5.458    18.106     0.200
     5.575    21.750     0.200
     5.916    19.973     0.200
     6.073    19.635     0.200
     6.073    18.791     0.200
     5.975    21.430     0.200
     6.311    20.149     0.200
     6.749    21.141     0.200
     6.841    21.314     0.200
     6.841    20.978     0.200
     6.877    22.522     0.200
     6.877    21.452     0.200
     7.029    21.947     0.200
     7.320    22.434     0.200
     7.320    23.130     0.200
     7.388    22.137     0.200
     7.523    22.711     0.200
     7.679    21.390     0.200
     7.725    21.886     0.200
     8.268    24.577     0.200
     8.298    24.465     0.200
     8.300    24.016     0.200
     8.453    24.934     0.200
     8.453    23.958     0.200
     8.455    24.165     0.200
     8.575    26.223     0.200
     8.575    25.543     0.200
     8.588    24.743     0.200
     8.588    24.361     0.200
     8.921    25.431     0.200
     8.924    24.911     0.200
     8.924    24.685     0.200
     8.952    25.815     0.200
     8.952    25.925     0.200
     8.992    24.863     0.200
     8.992    24.308     0.200
     9.087    25.889     0.200
     9.087    25.373     0.200
     9.339    26.499     0.200
     9.357    24.957     0.200
     9.357    25.801     0.200
     9.668    26.405     0.200
     9.668    25.655     0.200
     9.672    25.881     0.200
     9.676    27.139     0.200
     9.676    26.960     0.200
     9.372    29.531     0.200
     9.749    25.925     0.200
     9.787    26.835     0.200
     9.787    26.117     0.200
     9.832    26.020     0.200
     9.978    26.645     0.200
     9.978    27.012     0.200
     9.807    29.211     0.200
     9.807    29.820     0.200
    10.146    29.053     0.200
    10.182    26.861     0.200
    10.231    26.372     0.200
    10.231    27.356     0.200
    10.231    27.184     0.200
    10.352    26.916     0.200
    10.352    27.736     0.200
    10.089    30.498     0.200
    10.418    28.333     0.200
    10.418    28.560     0.200
    10.473    29.000     0.200
    10.473    28.836     0.200
    10.529    27.004     0.200
    10.604    28.800     0.200
    10.615    28.704     0.200
    10.615    29.196     0.200
    10.631    27.179     0.200
    10.675    27.759     0.200
    10.675    28.009     0.200
    10.713    27.712     0.200
    10.778    28.639     0.200
    10.948    28.625     0.200
    10.983    29.763     0.200
    11.183    28.187     0.200
    11.183    28.327     0.200
    11.205    29.279     0.200
    11.205    29.419     0.200
    11.263    29.470     0.200
    11.263    29.181     0.200
    11.510    30.618     0.200
    11.499    29.127     0.200
    11.543    29.415     0.200
    11.720    31.358     0.200
    11.750    29.719     0.200
    11.753    30.186     0.200
    11.752    32.905     0.200
    11.752    32.014     0.200
    11.801    30.755     0.200
    11.839    32.001     0.200
    11.839    31.149     0.200
    11.858    28.065     0.200
    11.858    28.487     0.200
    11.931    30.496     0.200
    12.010    31.276     0.200
    12.170    31.814     0.200
    12.206    30.990     0.200
    12.238    32.080     0.200
    12.288    28.281     0.200
    12.331    31.985     0.200
    12.398    29.160     0.200
    12.398    30.590     0.200
    12.398    28.894     0.200
    12.469    32.428     0.200
    12.474    33.467     0.200
    12.548    32.399     0.200
    12.538    32.498     0.200
    12.580    28.875     0.200
    12.580    28.852     0.200
    12.322    32.388     0.200
    12.674    31.415     0.200
    12.700    30.279     0.200
    12.700    30.849     0.200
    12.706    32.022     0.200
    12.753    32.339     0.200
    12.780    32.164     0.200
    12.795    32.951     0.200
    12.832    32.114     0.200
    12.832    32.629     0.200
    12.904    30.421     0.200
    12.911    31.061     0.200
    12.911    32.124     0.200
    13.071    32.964     0.200
    13.142    32.831     0.200
    13.160    30.821     0.200
    13.167    32.221     0.200
    13.177    33.674     0.200
    13.194    33.476     0.200
    13.378    34.243     0.200
    13.383    33.292     0.200
    13.395    33.551     0.200
    13.402    34.150     0.200
    13.455    33.977     0.200
    13.524    31.382     0.200
    13.524    32.788     0.200
    13.641    34.203     0.200
    13.696    34.695     0.200
    13.702    35.929     0.200
    13.765    35.928     0.200
    13.823    34.885     0.200
    13.882    34.285     0.200
    13.882    35.520     0.200
    13.972    34.255     0.200
    14.065    34.661     0.200
    14.059    34.507     0.200
    14.206    34.783     0.200
    14.175    34.673     0.200
    14.292    35.100     0.200
    14.344    36.092     0.200
    14.373    33.853     0.200
    14.373    34.580     0.200
    14.401    34.141     0.200
    14.575    35.525     0.200
    14.602    33.826     0.200
    14.602    35.764     0.200
    14.630    36.294     0.200
    14.728    35.740     0.200
    14.744    34.399     0.200
    14.942    36.199     0.200
    14.969    36.573     0.200
    15.053    35.993     0.200
    15.053    35.758     0.200
    15.042    36.787     0.200
    15.118    36.902     0.200
    15.188    36.822     0.200
    15.175    36.666     0.200
    15.175    37.588     0.200
    15.236    33.950     0.200
    15.260    37.230     0.200
    15.262    36.928     0.200
    15.390    36.500     0.200
    15.547    36.575     0.200
    15.548    37.084     0.200
    15.565    37.022     0.200
    15.648    38.565     0.200
    15.697    37.798     0.200
    15.895    37.805     0.200
    16.184    38.799     0.200
    16.207    37.734     0.200
    16.371    37.437     0.200
    16.370    38.529     0.200
    16.413    38.427     0.200
    16.552    38.500     0.200
    16.804    39.800     0.200
    16.892    39.460     0.200
    17.022    39.288     0.200
    17.187    38.699     0.200
    17.193    38.534     0.200
    17.314    38.683     0.200
    17.410    38.679     0.200
    17.475    37.465     0.200
    19.511    40.513     0.200
     1.358     8.957     0.200
     1.971     9.268     0.200
     1.971     9.428     0.200
     3.285    12.050     0.200
     3.712    13.172     0.200
     4.369    14.545     0.200
     4.494    14.655     0.200
     4.538    14.394     0.200
     4.958    15.333     0.200
     5.062    15.183     0.200
     5.359    14.479     0.200
     5.359    14.885     0.200
     5.359    15.534     0.200
     5.394    15.800     0.200
     5.490    16.661     0.200
     5.490    16.880     0.200
     5.271    19.687     0.200
     5.888    15.780     0.200
     5.851    16.948     0.200
     6.034    20.050     0.200
     6.034    19.486     0.200
     6.416    17.370     0.200
     6.416    18.688     0.200
     6.599    17.998     0.200
     6.900    20.104     0.200
     6.959    19.034     0.200
     7.249    19.190     0.200
     7.885    21.300     0.200
     7.885    21.638     0.200
     7.990    21.913     0.200
     8.044    21.285     0.200
     8.155    22.866     0.200
     8.155    22.646     0.200
     8.495    22.220     0.200
     8.495    22.046     0.200
     8.508    22.666     0.200
     8.562    23.118     0.200
     8.558    22.442     0.200
     8.661    22.861     0.200
     8.927    22.443     0.200
     8.927    22.925     0.200
     9.237    23.091     0.200
     9.237    23.741     0.200
     9.270    23.957     0.200
     9.318    23.726     0.200
     9.729    25.730     0.200
     9.921    23.629     0.200
     9.921    24.546     0.200
    10.192    25.901     0.200
    10.245    24.798     0.200
    10.192    25.317     0.200
    10.517    25.401     0.200
    10.835    26.021     0.200
    11.072    26.623     0.200
    11.593    26.691     0.200
    11.493    28.640     0.200
    11.777    28.240     0.200
    11.862    26.498     0.200
    11.901    27.606     0.200
    11.946    28.970     0.200
    12.039    29.437     0.200
    12.117    29.482     0.200
    12.155    26.239     0.200
    12.243    29.084     0.200
    12.481    28.721     0.200
    13.942    31.164     0.200
    14.171    32.076     0.200
    14.544    34.559     0.200
    14.817    34.192     0.200
    15.779    34.540     0.200
    16.374    35.078     0.200
     1.335     6.208     0.200
     1.335     6.478     0.200
     1.563     8.617     0.200
     2.263     9.523     0.200
     2.263    11.844     0.200
     2.677     9.662     0.200
     3.064    11.169     0.200
     3.730    11.931     0.200
     3.892    12.715     0.200
     4.005    13.081     0.200
     3.769    13.404     0.200
     4.313    13.709     0.200
     4.312    13.490     0.200
     4.271    15.316     0.200
     4.271    15.437     0.200
     4.548    14.562     0.200
     4.678    13.307     0.200
     4.842    14.331     0.200
     4.871    14.675     0.200
     4.871    14.484     0.200
     4.983    15.037     0.200
     4.983    16.014     0.200
     5.240    15.273     0.200
     5.281    15.838     0.200
     5.281    16.280     0.200
     5.381    16.759     0.200
     5.669    17.212     0.200
     5.670    17.233     0.200
     5.798    16.371     0.200
     5.798    16.598     0.200
     5.957    17.501     0.200
     6.197    17.966     0.200
     6.289    18.382     0.200
     6.300    18.259     0.200
     6.300    17.927     0.200
     6.342    17.705     0.200
     6.456    19.479     0.200
     6.580    16.847     0.200
     6.624    17.170     0.200
     6.624    17.280     0.200
     7.240    20.258     0.200
     7.307    19.608     0.200
     7.307    19.878     0.200
     7.328    20.582     0.200
     7.482    19.818     0.200
     7.482    20.373     0.200
     7.492    20.101     0.200
     7.554    21.080     0.200
     7.853    20.846     0.200
     7.853    21.374     0.200
     7.905    21.102     0.200
     7.932    21.187     0.200
     8.038    23.105     0.200
     8.038    21.754     0.200
     8.135    21.140     0.200
     8.259    21.242     0.200
     8.259    21.761     0.200
     8.577    21.720     0.200
     8.577    21.935     0.200
     8.658    23.338     0.200
     8.658    22.978     0.200
     8.667    22.946     0.200
     8.713    22.955     0.200
     8.713    22.490     0.200
     8.892    22.461     0.200
     9.127    22.719     0.200
     9.127    23.035     0.200
     9.142    22.001     0.200
     9.142    23.552     0.200
     9.261    22.816     0.200
     9.261    22.988     0.200
     9.426    21.030     0.200
     9.478    22.852     0.200
     9.515    24.251     0.200
     9.564    23.079     0.200
     9.582    24.793     0.200
     9.575    22.708     0.200
     9.575    23.286     0.200
     9.743    24.214     0.200
     9.854    24.741     0.200
     9.854    23.554     0.200
     9.913    24.345     0.200
     9.975    24.313     0.200
    10.161    25.925     0.200
    10.161    24.683     0.200
    10.260    24.514     0.200
    10.396    24.089     0.200
    10.440    25.154     0.200
    10.664    25.910     0.200
    10.697    25.880     0.200
    10.753    26.107     0.200
    10.833    24.167     0.200
    10.847    25.573     0.200
    10.978    24.914     0.200
    11.067    27.682     0.200
    11.143    27.040     0.200
    11.192    23.657     0.200
    11.236    23.645     0.200
    11.237    26.277     0.200
    11.230    25.780     0.200
    11.252    27.705     0.200
    11.265    26.964     0.200
    11.253    28.100     0.200
    11.340    25.141     0.200
    11.390    25.563     0.200
    11.447    27.737     0.200
    11.534    25.745     0.200
    11.534    25.191     0.200
    11.534    24.507     0.200
    11.589    26.328     0.200
    11.706    27.488     0.200
    11.787    26.537     0.200
    11.830    26.825     0.200
    12.043    26.660     0.200
    12.062    28.025     0.200
    12.153    30.334     0.200
    12.514    29.620     0.200
    13.000    28.137     0.200
    13.290    29.644     0.200
    13.743    31.706     0.200
    13.866    33.419     0.200
    14.130    32.570     0.200
    14.217    32.220     0.200
    15.270    34.871     0.200
    15.724    36.965     0.200
    16.427    34.653     0.200
    17.853    35.544     0.200
    17.853    35.443     0.200
     1.322     8.444     0.200
     1.321     8.219     0.200
     1.340     8.366     0.200
     1.351     8.580     0.200
     1.470     8.487     0.200
     1.497     8.262     0.200
     1.551     8.901     0.200
     1.453     9.277     0.200
     1.478     8.520     0.200
     1.603     9.256     0.200
     1.604     9.251     0.200
     1.620     9.497     0.200
     1.633     9.378     0.200
     1.801     8.652     0.200
     1.801     9.062     0.200
     2.087    10.476     0.200
     2.087    11.187     0.200
     2.287    10.034     0.200
     2.358    10.501     0.200
     2.419    11.194     0.200
     2.255    10.939     0.200
     2.438    10.725     0.200
     2.295    11.781     0.200
     2.420    12.280     0.200
     2.422    12.009     0.200
     2.659     9.654     0.200
     2.495    12.224     0.200
     2.856    12.688     0.200
     2.885    13.020     0.200
     3.144    12.061     0.200
     3.524    12.896     0.200
     3.476    14.079     0.200
     3.706    12.310     0.200
     3.706    12.191     0.200
     3.520    11.783     0.200
     3.520    14.062     0.200
     3.549    14.431     0.200
     3.620    13.948     0.200
     4.006    14.290     0.200
     4.192    13.737     0.200
     4.194    13.723     0.200
     4.257    14.090     0.200
     4.077    15.054     0.200
     4.100    14.546     0.200
     4.150    14.838     0.200
     4.463    12.712     0.200
     4.463    13.151     0.200
     4.267    14.861     0.200
     4.467    14.657     0.200
     4.474    14.159     0.200
     4.465    14.725     0.200
     4.640    14.874     0.200
     4.773    14.884     0.200
     4.772    14.899     0.200
     4.879    15.188     0.200
     5.003    15.327     0.200
     5.089    15.870     0.200
     5.089    13.844     0.200
     5.305    16.189     0.200
     5.337    16.008     0.200
     5.341    16.740     0.200
     5.435    16.761     0.200
     5.493    16.788     0.200
     5.674    16.473     0.200
     5.676    16.454     0.200
     5.748    17.260     0.200
     5.825    17.598     0.200
     6.019    18.107     0.200
     6.036    17.782     0.200
     6.041    18.120     0.200
     6.182    18.033     0.200
     6.264    19.634     0.200
     6.362    18.497     0.200
     6.364    18.997     0.200
     6.363    20.686     0.200
     6.731    19.925     0.200
     6.657    19.042     0.200
     6.768    20.220     0.200
     6.768    19.111     0.200
     6.807    20.525     0.200
     6.807    19.795     0.200
     6.845    19.637     0.200
     6.918    22.738     0.200
     6.837    19.433     0.200
     7.041    19.605     0.200
     7.060    19.446     0.200
     7.138    19.960     0.200
     7.506    20.109     0.200
     7.675    21.235     0.200
     7.725    20.790     0.200
     7.793    20.549     0.200
     7.691    21.443     0.200
     7.774    21.306     0.200
     7.947    22.821     0.200
     7.947    21.924     0.200
     8.086    21.621     0.200
     8.308    21.969     0.200
     8.399    21.533     0.200
     8.703    21.658     0.200
     8.627    22.958     0.200
     8.739    22.363     0.200
     8.942    22.982     0.200
     9.178    24.474     0.200
     9.233    24.296     0.200
     9.571    24.355     0.200
     9.609    25.144     0.200
     9.937    25.800     0.200
     9.937    24.425     0.200
    10.015    25.145     0.200
    10.477    27.619     0.200
    10.757    29.045     0.200
    11.530    28.793     0.200
    11.712    29.581     0.200
    11.999    25.709     0.200
    12.128    29.505     0.200
    12.304    28.096     0.200
     0.881     5.965     0.200
     1.228     6.742     0.200
     1.274     7.709     0.200
     1.339     7.953     0.200
     1.405     8.457     0.200
     1.405     8.448     0.200
     1.465     7.683     0.200
     1.465     7.183     0.200
     1.573     8.762     0.200
     1.585     8.683     0.200
     1.633     9.099     0.200
     1.812     9.362     0.200
     1.845     9.385     0.200
     2.098     9.908     0.200
     2.108     9.383     0.200
     2.136    10.246     0.200
     2.462    11.119     0.200
     2.462    10.860     0.200
     2.462    11.008     0.200
     2.642    11.393     0.200
     2.669    12.126     0.200
     2.673    11.157     0.200
     2.810    12.178     0.200
     2.877    12.225     0.200
     3.149    11.528     0.200
     3.224    12.282     0.200
     3.267    10.654     0.200
     3.267    10.164     0.200
     3.267    10.834     0.200
     3.256    13.312     0.200
     3.259    13.271     0.200
     3.282    13.055     0.200
     3.824    12.655     0.200
     3.826    12.639     0.200
     3.877    12.884     0.200
     3.982    12.878     0.200
     3.889    14.308     0.200
     4.028    11.874     0.200
     4.028    11.476     0.200
     4.027    13.439     0.200
     3.932    14.516     0.200
     3.961    14.807     0.200
     4.087    13.932     0.200
     4.088    13.622     0.200
     4.032    14.955     0.200
     4.060    14.708     0.200
     4.190    13.875     0.200
     4.395    14.833     0.200
     4.395    13.954     0.200
     4.394    13.970     0.200
     4.424    14.658     0.200
     4.512    14.831     0.200
     4.553    14.303     0.200
     4.517    15.079     0.200
     4.659    13.000     0.200
     4.659    12.789     0.200
     4.565    15.168     0.200
     4.984    14.940     0.200
     5.040    15.087     0.200
     5.405    16.433     0.200
     5.744    16.547     0.200
     5.911    16.952     0.200
     6.039    17.448     0.200
     6.051    17.977     0.200
     6.322    16.733     0.200
     6.429    18.977     0.200
     6.496    18.414     0.200
     6.545    18.780     0.200
     6.616    17.404     0.200
     6.620    20.636     0.200
     7.453    20.314     0.200
     7.638    21.108     0.200
     7.935    20.477     0.200
     8.303    20.614     0.200
     8.307    20.426     0.200
     8.307    20.646     0.200
     8.532    21.045     0.200
     8.776    21.394     0.200
     8.827    22.458     0.200
     8.871    22.900     0.200
     9.127    22.073     0.200
     9.310    23.651     0.200
     9.352    24.655     0.200
     9.602    23.364     0.200
     9.658    23.644     0.200
     9.639    24.306     0.200
     9.696    23.972     0.200
    10.107    24.731     0.200
    10.180    25.076     0.200
    10.229    25.330     0.200
    10.454    27.337     0.200
    10.630    25.477     0.200
    10.637    25.183     0.200
    10.946    25.698     0.200
    10.953    25.182     0.200
    10.892    28.077     0.200
    11.086    24.584     0.200
    11.256    26.442     0.200
    11.233    27.293     0.200
    11.171    28.648     0.200
    11.308    27.987     0.200
    11.456    25.642     0.200
    11.636    24.045     0.200
    11.668    28.814     0.200
    11.689    26.880     0.200
    11.896    27.951     0.200
    11.929    26.113     0.200
    12.076    28.205     0.200
    12.391    28.111     0.200
    13.351    30.054     0.200
    15.040    33.193     0.200
    15.247    34.082     0.200
    15.789    34.875     0.200
    16.329    37.755     0.200
    17.933    36.521     0.200
    17.933    36.636     0.200
     0.369     6.397     0.200
     0.945     7.480     0.200
     1.518     7.130     0.200
     1.564     7.803     0.200
     1.572     7.504     0.200
     1.620     7.284     0.200
     1.620     8.006     0.200
     1.787     8.209     0.200
     2.135     6.528     0.200
     2.135     7.696     0.200
     2.367    10.240     0.200
     2.465     9.144     0.200
     2.707     9.493     0.200
     2.804     8.006     0.200
     2.804     8.565     0.200
     2.975    10.441     0.200
     3.031    10.765     0.200
     3.030    10.561     0.200
     3.237    10.879     0.200
     3.389     9.298     0.200
     3.360    11.583     0.200
     3.541    11.243     0.200
     3.633    11.665     0.200
     3.633    11.196     0.200
     3.680    11.948     0.200
     3.680    11.842     0.200
     3.670    11.762     0.200
     3.745    11.784     0.200
     3.930    11.607     0.200
     4.063    13.009     0.200
     4.063    12.642     0.200
     4.275    13.462     0.200
     4.379    13.013     0.200
     4.360    13.328     0.200
     4.446    13.828     0.200
     4.492    13.147     0.200
     4.675    14.083     0.200
     4.750    14.854     0.200
     4.750    14.186     0.200
     4.908    14.010     0.200
     4.868    14.251     0.200
     4.912    14.052     0.200
     4.978    14.051     0.200
     5.003    14.775     0.200
     5.091    14.905     0.200
     5.181    14.266     0.200
     5.160    15.174     0.200
     5.192    15.603     0.200
     5.269    13.159     0.200
     5.222    15.648     0.200
     5.313    13.361     0.200
     5.358    14.894     0.200
     5.427    16.892     0.200
     5.549    16.000     0.200
     5.721    15.790     0.200
     5.847    16.179     0.200
     5.927    16.312     0.200
     6.043    16.323     0.200
     6.092    16.416     0.200
     6.132    17.082     0.200
     6.158    17.007     0.200
     6.206    16.638     0.200
     6.335    18.252     0.200
     6.334    17.536     0.200
     6.519    18.099     0.200
     6.570    17.706     0.200
     6.604    16.826     0.200
     6.676    17.781     0.200
     6.756    18.534     0.200
     6.837    18.050     0.200
     6.948    18.103     0.200
     6.948    16.342     0.200
     7.295    19.083     0.200
     7.369    19.137     0.200
     7.379    18.453     0.200
     7.442    17.552     0.200
     7.449    19.098     0.200
     7.567    18.960     0.200
     7.954    19.531     0.200
     7.954    19.398     0.200
     7.939    20.898     0.200
     7.939    20.155     0.200
     7.970    21.022     0.200
     8.037    20.266     0.200
     8.263    20.290     0.200
     8.263    19.806     0.200
     8.342    19.912     0.200
     8.342    20.267     0.200
     8.351    21.654     0.200
     8.495    21.201     0.200
     8.546    20.731     0.200
     8.659    21.337     0.200
     8.766    21.911     0.200
     8.850    21.671     0.200
     9.132    22.170     0.200
     9.728    21.829     0.200
     9.943    21.821     0.200
     9.937    23.757     0.200
     9.970    22.068     0.200
    10.023    21.858     0.200
    10.103    21.983     0.200
    10.153    24.191     0.200
    10.275    22.479     0.200
    10.275    22.909     0.200
    10.534    23.049     0.200
    10.565    23.218     0.200
    10.591    23.457     0.200
    10.733    23.782     0.200
    10.751    23.820     0.200
    10.931    24.730     0.200
    11.028    26.237     0.200
    11.221    23.711     0.200
    11.718    25.072     0.200
     1.076     8.639     0.200
     1.104     9.521     0.200
     1.320     9.800     0.200
     1.552    10.066     0.200
     1.648    10.009     0.200
     1.644    10.688     0.200
     1.679    10.883     0.200
     1.680    10.873     0.200
     2.006    11.407     0.200
     2.006    10.532     0.200
     1.834    10.877     0.200
     1.854    12.572     0.200
     2.000    12.263     0.200
     2.001    11.809     0.200
     2.073    12.082     0.200
     2.361    12.773     0.200
     2.436    13.898     0.200
     2.445    12.995     0.200
     2.465    13.398     0.200
     3.034    11.847     0.200
     3.061    15.265     0.200
     3.104    15.361     0.200
     3.104    15.471     0.200
     3.134    15.215     0.200
     3.204    14.878     0.200
     3.204    15.042     0.200
     3.216    15.028     0.200
     3.232    15.003     0.200
     3.249    14.939     0.200
     3.276    15.597     0.200
     3.595    15.349     0.200
     3.595    15.149     0.200
     3.663    15.772     0.200
     3.688    15.192     0.200
     3.736    15.366     0.200
     3.820    15.781     0.200
     4.058    14.131     0.200
     4.058    13.940     0.200
     3.855    15.801     0.200
     4.402    15.585     0.200
     4.404    15.567     0.200
     4.484    15.946     0.200
     4.556    16.374     0.200
     4.574    16.626     0.200
     4.795    14.640     0.200
     4.795    15.042     0.200
     4.593    17.841     0.200
     5.077    17.427     0.200
     5.265    18.349     0.200
     5.405    16.396     0.200
     5.405    17.619     0.200
     5.405    15.536     0.200
     5.215    17.939     0.200
     5.481    18.457     0.200
     5.680    18.507     0.200
     5.860    19.117     0.200
     5.915    19.605     0.200
     5.958    19.182     0.200
     5.959    19.160     0.200
     5.915    19.926     0.200
     6.107    19.089     0.200
     5.983    21.269     0.200
     5.983    21.078     0.200
     5.983    20.500     0.200
     6.107    19.683     0.200
     6.388    20.244     0.200
     6.487    20.630     0.200
     6.487    20.302     0.200
     6.451    20.954     0.200
     6.633    21.513     0.200
     6.748    20.635     0.200
     6.925    22.270     0.200
     6.925    21.774     0.200
     6.911    20.920     0.200
     6.930    21.853     0.200
     6.930    21.724     0.200
     6.999    21.971     0.200
     7.007    20.521     0.200
     7.045    21.006     0.200
     7.541    21.570     0.200
     7.559    22.170     0.200
     7.625    22.310     0.200
     7.799    22.587     0.200
     7.907    24.073     0.200
     8.028    23.036     0.200
     8.067    22.651     0.200
     8.067    22.506     0.200
     8.064    23.626     0.200
     8.064    23.419     0.200
     8.116    23.184     0.200
     8.181    24.570     0.200
     8.214    23.645     0.200
     8.528    22.791     0.200
     8.598    23.958     0.200
     8.573    24.351     0.200
     8.602    24.258     0.200
     8.748    23.672     0.200
     8.967    23.977     0.200
     8.967    24.125     0.200
     9.000    24.904     0.200
     9.279    26.668     0.200
     9.289    26.407     0.200
     9.354    26.203     0.200
     9.467    24.682     0.200
     9.467    23.280     0.200
     9.583    25.303     0.200
     9.753    27.521     0.200
     9.849    25.528     0.200
     9.959    26.160     0.200
     9.959    25.191     0.200
    10.034    27.139     0.200
    10.064    29.350     0.200
    10.286    26.485     0.200
    10.343    30.415     0.200
    11.115    28.251     0.200
    11.355    30.368     0.200
    11.627    30.215     0.200
    11.973    30.048     0.200
    12.183    28.499     0.200
    12.183    26.362     0.200
    12.476    31.706     0.200
    12.751    31.606     0.200
    12.769    32.052     0.200
     1.339     7.564     0.200
     1.357     7.620     0.200
     1.436     8.362     0.200
     1.377     9.149     0.200
     1.405     8.414     0.200
     1.520     8.591     0.200
     1.553     8.336     0.200
     1.557     9.464     0.200
     1.557     9.169     0.200
     1.792     8.161     0.200
     1.792     8.805     0.200
     2.019    10.473     0.200
     2.019    11.103     0.200
     2.190    10.978     0.200
     2.228    11.922     0.200
     2.426    10.428     0.200
     2.354    11.876     0.200
     2.357    11.716     0.200
     2.698     9.612     0.200
     2.794    12.458     0.200
     2.822    13.067     0.200
     3.131    11.698     0.200
     3.131    11.803     0.200
     3.522    12.933     0.200
     3.522    13.089     0.200
     3.418    13.995     0.200
     3.462    14.179     0.200
     3.462    14.069     0.200
     3.491    13.485     0.200
     3.562    13.801     0.200
     3.562    14.333     0.200
     3.590    14.064     0.200
     3.608    14.526     0.200
     3.950    14.427     0.200
     4.020    14.942     0.200
     4.044    14.694     0.200
     4.188    14.851     0.200
     4.190    14.712     0.200
     4.177    14.718     0.200
     4.093    14.670     0.200
     4.256    14.273     0.200
     4.345    14.144     0.200
     4.211    14.793     0.200
     4.437    14.842     0.200
     4.454    14.250     0.200
     4.454    14.461     0.200
     4.489    12.880     0.200
     4.489    13.026     0.200
     4.588    15.104     0.200
     4.770    15.138     0.200
     4.772    14.762     0.200
     4.801    14.750     0.200
     4.863    15.754     0.200
     4.863    16.353     0.200
     4.974    16.223     0.200
     5.110    13.867     0.200
     5.281    16.103     0.200
     5.288    16.621     0.200
     5.288    16.311     0.200
     5.327    16.796     0.200
     5.449    17.063     0.200
     5.449    16.924     0.200
     5.439    16.452     0.200
     5.439    17.065     0.200
     5.687    17.350     0.200
     5.689    16.135     0.200
     5.735    17.534     0.200
     5.735    18.625     0.200
     5.789    17.456     0.200
     5.982    18.293     0.200
     5.990    17.201     0.200
     5.990    17.642     0.200
     5.992    17.079     0.200
     5.992    18.034     0.200
     6.130    18.282     0.200
     6.128    19.146     0.200
     6.327    18.603     0.200
     6.327    18.349     0.200
     6.342    19.224     0.200
     6.342    18.759     0.200
     6.478    18.875     0.200
     6.754    19.860     0.200
     6.784    19.473     0.200
     6.787    19.243     0.200
     6.787    20.264     0.200
     6.814    19.612     0.200
     6.912    20.728     0.200
     7.000    19.913     0.200
     7.011    18.875     0.200
     7.471    20.534     0.200
     7.471    20.852     0.200
     7.627    21.559     0.200
     7.632    21.601     0.200
     7.696    20.827     0.200
     7.696    21.018     0.200
     7.756    21.299     0.200
     7.926    22.049     0.200
     8.008    23.004     0.200
     8.008    22.652     0.200
     8.050    21.873     0.200
     8.050    22.104     0.200
     8.254    22.643     0.200
     8.312    23.085     0.200
     8.466    22.451     0.200
     8.466    23.672     0.200
     8.583    22.956     0.200
     8.712    21.839     0.200
     8.712    22.462     0.200
     8.911    22.778     0.200
     8.877    26.066     0.200
     9.033    23.399     0.200
     9.155    24.892     0.200
     9.375    22.485     0.200
     9.542    24.771     0.200
     9.542    24.876     0.200
     9.716    24.207     0.200
     9.913    25.595     0.200
     9.913    25.696     0.200
    10.026    24.377     0.200
    10.235    25.869     0.200
    10.309    26.563     0.200
     0.287     5.532     0.200
     0.296     5.444     0.200
     0.713     5.779     0.200
     0.713     6.052     0.200
     1.062     6.274     0.200
     1.088     6.832     0.200
     1.157     7.255     0.200
     1.219     7.722     0.200
     1.220     7.674     0.200
     1.334     6.546     0.200
     1.334     6.905     0.200
     1.425     7.816     0.200
     1.442     7.869     0.200
     1.474     8.022     0.200
     1.497     8.199     0.200
     1.570     8.441     0.200
     1.697     8.484     0.200
     1.829     8.196     0.200
     1.896     8.399     0.200
     1.960     8.537     0.200
     1.976     8.547     0.200
     1.997     8.895     0.200
     2.241     8.318     0.200
     2.367    10.804     0.200
     2.367    11.257     0.200
     2.367    10.398     0.200
     2.555    10.836     0.200
     2.578    11.548     0.200
     2.683     9.863     0.200
     2.683     9.706     0.200
     2.587    10.965     0.200
     2.705    11.939     0.200
     2.722    11.836     0.200
     2.785    11.836     0.200
     2.978    10.714     0.200
     3.048    11.207     0.200
     3.124    11.402     0.200
     3.123    11.022     0.200
     3.105    12.469     0.200
     3.229    11.261     0.200
     3.263    10.184     0.200
     3.263    10.496     0.200
     3.263     9.961     0.200
     3.175    12.512     0.200
     3.177    12.698     0.200
     3.689    12.166     0.200
     3.689    10.884     0.200
     3.718    12.082     0.200
     3.720    11.924     0.200
     3.780    12.429     0.200
     3.842    12.294     0.200
     3.904    12.833     0.200
     3.898    12.474     0.200
     3.898    12.607     0.200
     3.914    12.707     0.200
     3.821    13.949     0.200
     3.821    13.757     0.200
     3.864    13.414     0.200
     3.864    13.882     0.200
     3.990    12.905     0.200
     3.996    12.562     0.200
     3.894    13.796     0.200
     4.034    12.987     0.200
     4.034    12.882     0.200
     3.960    13.442     0.200
     3.965    13.288     0.200
     3.970    14.011     0.200
     3.974    13.698     0.200
     3.993    13.828     0.200
     4.150    12.414     0.200
     4.122    13.151     0.200
     4.122    12.425     0.200
     4.271    13.151     0.200
     4.297    13.321     0.200
     4.297    13.208     0.200
     4.296    13.129     0.200
     4.320    13.100     0.200
     4.320    13.319     0.200
     4.320    12.757     0.200
     4.421    13.605     0.200
     4.421    13.335     0.200
     4.466    13.527     0.200
     4.363    14.053     0.200
     4.363    14.354     0.200
     4.363    13.268     0.200
     4.424    14.419     0.200
     4.453    14.161     0.200
     4.581    13.530     0.200
     4.499    14.400     0.200
     4.624    12.390     0.200
     4.624    12.109     0.200
     4.624    12.230     0.200
     4.622    14.719     0.200
     4.867    14.402     0.200
     4.863    14.190     0.200
     4.957    14.728     0.200
     4.957    14.310     0.200
     5.025    15.076     0.200
     5.025    14.963     0.200
     5.125    15.559     0.200
     5.125    15.282     0.200
     5.199    14.918     0.200
     5.201    14.111     0.200
     5.282    15.437     0.200
     5.356    15.712     0.200
     5.360    15.854     0.200
     5.374    15.497     0.200
     5.390    15.561     0.200
     5.303    16.333     0.200
     5.423    15.916     0.200
     5.586    15.496     0.200
     5.586    15.652     0.200
     5.651    16.210     0.200
     5.651    15.929     0.200
     5.682    15.991     0.200
     5.682    16.186     0.200
     5.795    16.726     0.200
     5.795    16.464     0.200
     5.769    17.054     0.200
     5.863    16.657     0.200
     5.863    16.337     0.200
     5.912    16.658     0.200
     5.912    16.502     0.200
     5.941    16.748     0.200
     5.968    17.343     0.200
     5.968    16.808     0.200
     6.006    16.628     0.200
     5.996    19.906     0.200
     5.996    17.425     0.200
     6.178    17.112     0.200
     6.178    16.917     0.200
     6.194    17.000     0.200
     6.254    16.077     0.200
     6.304    18.002     0.200
     6.304    17.229     0.200
     6.357    17.785     0.200
     6.357    17.586     0.200
     6.403    17.540     0.200
     6.422    17.553     0.200
     6.422    18.221     0.200
     6.440    17.446     0.200
     6.440    17.202     0.200
     6.443    18.010     0.200
     6.475    17.915     0.200
     6.470    18.021     0.200
     6.470    17.689     0.200
     6.546    15.889     0.200
     6.458    18.340     0.200
     6.458    18.711     0.200
     6.529    17.566     0.200
     6.589    15.853     0.200
     6.589    16.454     0.200
     6.636    17.547     0.200
     6.656    17.687     0.200
     6.656    17.898     0.200
     6.694    17.519     0.200
     6.694    18.043     0.200
     6.719    17.535     0.200
     7.101    18.549     0.200
     7.101    18.400     0.200
     7.202    18.811     0.200
     7.203    19.180     0.200
     7.212    20.007     0.200
     7.230    19.211     0.200
     7.272    19.331     0.200
     7.300    17.461     0.200
     7.317    17.024     0.200
     7.317    19.024     0.200
     7.297    18.930     0.200
     7.297    19.149     0.200
     7.319    20.152     0.200
     7.319    19.680     0.200
     7.330    18.735     0.200
     7.331    20.051     0.200
     7.331    19.625     0.200
     7.461    19.993     0.200
     7.461    19.271     0.200
     7.499    20.485     0.200
     7.499    19.629     0.200
     7.552    19.685     0.200
     7.557    21.358     0.200
     7.557    20.776     0.200
     7.683    20.449     0.200
     7.683    19.719     0.200
     7.838    19.516     0.200
     7.881    19.577     0.200
     7.881    20.823     0.200
     7.944    21.018     0.200
     7.944    20.096     0.200
     8.032    20.778     0.200
     8.032    19.934     0.200
     8.000    21.021     0.200
     8.000    19.993     0.200
     8.062    20.601     0.200
     8.062    20.792     0.200
     8.062    19.781     0.200
     8.088    19.453     0.200
     8.088    20.120     0.200
     8.225    20.685     0.200
     8.251    20.427     0.200
     8.275    20.360     0.200
     8.280    20.350     0.200
     8.261    21.719     0.200
     8.261    21.102     0.200
     8.446    19.336     0.200
     8.446    19.707     0.200
     8.446    20.863     0.200
     8.521    22.251     0.200
     8.521    21.427     0.200
     8.550    19.387     0.200
     8.550    21.422     0.200
     8.645    19.786     0.200
     8.662    23.747     0.200
     8.662    23.415     0.200
     8.683    19.907     0.200
     8.715    19.085     0.200
     8.715    21.112     0.200
     8.722    21.243     0.200
     8.730    22.730     0.200
     8.730    21.405     0.200
     8.868    19.988     0.200
     8.868    21.585     0.200
     8.886    19.231     0.200
     8.867    23.085     0.200
     8.867    22.819     0.200
     9.065    22.449     0.200
     9.065    22.004     0.200
     9.081    21.670     0.200
     9.081    21.947     0.200
     9.148    23.522     0.200
     9.148    22.983     0.200
     9.141    23.082     0.200
     9.141    22.925     0.200
     9.233    21.241     0.200
     9.233    22.346     0.200
     9.376    23.328     0.200
     9.376    22.589     0.200
     9.386    22.580     0.200
     9.288    24.423     0.200
     9.288    24.083     0.200
     9.464    22.942     0.200
     9.465    21.562     0.200
     9.496    24.175     0.200
     9.496    23.335     0.200
     9.533    21.800     0.200
     9.520    23.369     0.200
     9.538    23.449     0.200
     9.550    21.132     0.200
     9.550    22.940     0.200
     9.615    20.823     0.200
     9.615    22.909     0.200
     9.624    23.435     0.200
     9.711    22.682     0.200
     9.729    23.503     0.200
     9.704    24.119     0.200
     9.779    23.912     0.200
     9.779    23.549     0.200
     9.780    23.817     0.200
     9.780    24.121     0.200
     9.824    24.069     0.200
     9.898    22.385     0.200
     9.915    21.968     0.200
     9.899    25.018     0.200
     9.899    24.225     0.200
     9.981    24.467     0.200
     9.989    25.065     0.200
     9.989    24.904     0.200
    10.047    25.168     0.200
    10.047    24.168     0.200
    10.093    22.308     0.200
    10.093    24.605     0.200
    10.122    23.682     0.200
    10.122    24.369     0.200
    10.123    25.561     0.200
    10.123    25.068     0.200
    10.155    23.446     0.200
    10.222    24.997     0.200
    10.304    24.809     0.200
    10.308    23.871     0.200
    10.326    24.049     0.200
    10.353    24.131     0.200
    10.385    24.900     0.200
    10.394    25.288     0.200
    10.444    24.835     0.200
    10.460    26.074     0.200
    10.460    25.082     0.200
    10.598    25.140     0.200
    10.583    26.039     0.200
    10.583    25.332     0.200
    10.615    25.972     0.200
    10.615    25.308     0.200
    10.639    24.546     0.200
    10.651    25.811     0.200
    10.651    24.768     0.200
    10.776    25.981     0.200
    10.768    26.576     0.200
    10.768    25.513     0.200
    10.834    24.515     0.200
    10.834    25.413     0.200
    10.862    26.921     0.200
    10.862    25.273     0.200
    10.915    24.810     0.200
    10.822    26.964     0.200
    10.822    27.175     0.200
    10.973    23.592     0.200
    10.982    27.444     0.200
    11.083    26.912     0.200
    11.091    26.269     0.200
    11.088    27.248     0.200
    11.088    26.193     0.200
    11.116    25.845     0.200
    11.160    27.076     0.200
    11.160    26.311     0.200
    11.194    25.738     0.200
    11.193    26.396     0.200
    11.193    26.560     0.200
    11.197    26.724     0.200
    11.188    24.346     0.200
    11.227    25.705     0.200
    11.235    27.454     0.200
    11.235    27.165     0.200
    11.242    25.644     0.200
    11.290    26.928     0.200
    11.278    27.241     0.200
    11.339    24.907     0.200
    11.361    27.376     0.200
    11.361    26.193     0.200
    11.385    27.079     0.200
    11.423    27.148     0.200
    11.423    27.004     0.200
    11.444    27.608     0.200
    11.444    27.479     0.200
    11.527    23.803     0.200
    11.567    27.791     0.200
    11.611    28.038     0.200
    11.611    26.851     0.200
    11.642    27.064     0.200
    11.641    27.177     0.200
    11.663    27.024     0.200
    11.682    27.744     0.200
    11.682    27.084     0.200
    11.795    27.395     0.200
    11.809    25.474     0.200
    11.809    26.485     0.200
    11.829    26.328     0.200
    11.829    26.660     0.200
    11.818    28.735     0.200
    11.818    27.516     0.200
    11.823    29.515     0.200
    11.823    27.652     0.200
    11.920    27.710     0.200
    12.009    27.497     0.200
    12.009    27.673     0.200
    12.023    27.705     0.200
    12.027    27.152     0.200
    12.049    27.336     0.200
    12.138    29.831     0.200
    12.138    28.253     0.200
    12.156    28.395     0.200
    12.249    28.981     0.200
    12.249    28.517     0.200
    12.300    27.377     0.200
    12.405    28.586     0.200
    12.461    28.334     0.200
    12.473    27.897     0.200
    12.473    28.307     0.200
    12.493    29.725     0.200
    12.493    29.104     0.200
    12.488    27.657     0.200
    12.466    31.344     0.200
    12.500    29.489     0.200
    12.500    29.282     0.200
    12.502    30.389     0.200
    12.502    29.151     0.200
    12.541    29.277     0.200
    12.547    30.125     0.200
    12.905    29.513     0.200
    12.942    29.500     0.200
    12.984    30.036     0.200
    12.976    30.182     0.200
    12.985    29.455     0.200
    12.990    29.836     0.200
    13.055    30.007     0.200
    13.055    29.445     0.200
    13.056    29.818     0.200
    13.056    29.580     0.200
    13.267    29.261     0.200
    13.291    30.534     0.200
    13.291    29.987     0.200
    13.311    31.131     0.200
    13.330    30.285     0.200
    13.372    31.422     0.200
    13.474    30.126     0.200
    13.474    30.017     0.200
    13.486    31.369     0.200
    13.486    30.557     0.200
    13.481    30.944     0.200
    13.535    30.321     0.200
    13.557    30.968     0.200
    13.567    31.938     0.200
    13.567    31.180     0.200
    13.567    31.343     0.200
    13.604    30.713     0.200
    13.657    30.840     0.200
    13.643    31.130     0.200
    13.672    33.425     0.200
    13.672    30.898     0.200
    13.746    30.614     0.200
    13.796    31.040     0.200
    13.819    30.983     0.200
    13.898    32.009     0.200
    13.992    31.337     0.200
    14.071    32.793     0.200
    14.091    31.602     0.200
    14.091    31.118     0.200
    14.110    32.562     0.200
    14.110    31.890     0.200
    14.114    31.170     0.200
    14.118    31.319     0.200
    14.188    34.524     0.200
    14.219    31.737     0.200
    14.285    32.043     0.200
    14.339    33.381     0.200
    14.339    31.271     0.200
    14.487    31.142     0.200
    14.487    31.392     0.200
    14.504    31.695     0.200
    14.493    32.420     0.200
    14.533    32.583     0.200
    14.585    33.772     0.200
    14.585    32.538     0.200
    14.576    34.564     0.200
    14.576    32.189     0.200
    14.741    33.563     0.200
    14.755    33.327     0.200
    14.823    32.123     0.200
    14.881    34.394     0.200
    14.881    33.163     0.200
    14.913    35.132     0.200
    14.913    33.370     0.200
    15.035    35.189     0.200
    15.035    33.169     0.200
    15.021    33.719     0.200
    15.074    33.451     0.200
    15.076    34.283     0.200
    15.189    33.583     0.200
    15.216    34.154     0.200
    15.217    33.995     0.200
    15.325    33.262     0.200
    15.325    34.191     0.200
    15.460    33.861     0.200
    15.458    34.489     0.200
    15.522    35.234     0.200
    15.522    34.199     0.200
    15.550    32.628     0.200
    15.550    33.702     0.200
    15.547    33.584     0.200
    15.547    34.603     0.200
    15.617    33.217     0.200
    15.617    34.506     0.200
    15.702    34.718     0.200
    15.702    34.968     0.200
    15.775    36.109     0.200
    15.775    35.016     0.200
    15.785    34.861     0.200
    15.883    35.922     0.200
    15.883    35.223     0.200
    16.103    34.878     0.200
    16.221    34.809     0.200
    16.235    35.096     0.200
    16.310    35.605     0.200
    16.349    35.926     0.200
    16.349    34.754     0.200
    16.346    34.749     0.200
    16.346    35.308     0.200
    16.481    36.190     0.200
    16.481    34.955     0.200
    16.626    34.951     0.200
    16.734    34.550     0.200
    16.822    33.789     0.200
    16.822    34.660     0.200
    17.025    34.942     0.200
    17.072    35.075     0.200
    17.278    33.255     0.200
    17.278    34.481     0.200
    17.422    35.207     0.200
    17.837    34.450     0.200
    17.837    34.814     0.200
    17.837    34.185     0.200
     1.223     7.210     0.200
     1.320     7.402     0.200
     1.354     8.127     0.200
     1.486     8.531     0.200
     1.567     8.227     0.200
     1.553     8.936     0.200
     1.562     8.997     0.200
     1.694     9.700     0.200
     1.770     8.921     0.200
     2.166     9.783     0.200
     2.211     9.616     0.200
     2.311     9.928     0.200
     2.407    11.026     0.200
     2.407    11.805     0.200
     2.583    11.491     0.200
     2.617    12.220     0.200
     2.751    12.215     0.200
     3.255    12.210     0.200
     3.364    11.741     0.200
     3.219    13.265     0.200
     3.819    14.878     0.200
     3.862    14.892     0.200
     3.990    14.728     0.200
     4.286    13.522     0.200
     4.387    13.878     0.200
     4.387    14.749     0.200
     4.351    14.503     0.200
     4.351    14.312     0.200
     4.421    15.304     0.200
     4.586    14.809     0.200
     4.577    15.430     0.200
     4.761    12.726     0.200
     4.761    12.980     0.200
     4.836    14.721     0.200
     5.147    15.744     0.200
     5.291    16.200     0.200
     5.390    16.044     0.200
     5.509    16.754     0.200
     5.684    16.696     0.200
     5.949    17.286     0.200
     6.016    17.843     0.200
     6.031    18.003     0.200
     6.153    18.850     0.200
     6.128    17.856     0.200
     6.128    17.676     0.200
     6.230    17.951     0.200
     6.427    19.328     0.200
     6.533    17.689     0.200
     6.598    18.628     0.200
     6.598    18.798     0.200
     6.651    19.089     0.200
     6.677    18.272     0.200
     6.721    17.429     0.200
     6.716    18.486     0.200
     6.841    18.237     0.200
     6.794    18.632     0.200
     6.919    18.654     0.200
     6.938    18.356     0.200
     6.985    18.306     0.200
     7.361    19.472     0.200
     7.549    19.538     0.200
     7.597    21.217     0.200
     7.682    21.239     0.200
     7.740    20.542     0.200
     7.784    21.281     0.200
     7.943    20.296     0.200
     8.041    20.994     0.200
     8.248    22.493     0.200
     8.266    21.885     0.200
     8.313    22.627     0.200
     8.313    22.187     0.200
     8.526    22.303     0.200
     8.612    21.458     0.200
     8.734    22.304     0.200
     8.776    22.306     0.200
     8.838    23.030     0.200
     8.973    24.246     0.200
     9.045    20.903     0.200
     9.057    22.685     0.200
     9.132    23.361     0.200
     9.231    22.372     0.200
     9.380    24.252     0.200
     9.416    23.003     0.200
     9.707    23.784     0.200
     9.743    25.133     0.200
     9.801    23.484     0.200
    10.004    24.887     0.200
    10.163    25.850     0.200
    10.285    26.411     0.200
    10.254    26.196     0.200
    10.384    25.482     0.200
    10.447    26.075     0.200
    10.508    26.594     0.200
    10.544    25.322     0.200
    10.726    27.939     0.200
    11.047    26.485     0.200
    11.090    28.780     0.200
    11.124    28.326     0.200
    11.208    28.032     0.200
    11.248    29.001     0.200
    11.333    27.799     0.200
    11.361    27.635     0.200
    11.419    29.178     0.200
    11.470    25.644     0.200
    11.527    29.126     0.200
    11.564    27.585     0.200
    11.742    24.849     0.200
    11.742    24.988     0.200
    11.742    24.328     0.200
    11.785    29.063     0.200
    12.002    28.059     0.200
    13.400    35.153     0.200
    13.457    29.641     0.200
    13.649    31.730     0.200
    14.583    35.530     0.200
    16.418    35.644     0.200
    17.013    35.469     0.200
    18.039    36.440     0.200
    18.039    35.904     0.200
     0.409     5.573     0.200
     0.535     5.115     0.200
     0.538     4.987     0.200
     0.862     7.070     0.200
     0.860     7.095     0.200
     0.880     7.159     0.200
     0.892     7.509     0.200
     0.992     7.801     0.200
     1.041     7.691     0.200
     1.449     7.984     0.200
     1.450     7.954     0.200
     1.803     7.933     0.200
     1.803     8.308     0.200
     1.689     9.599     0.200
     1.689    10.364     0.200
     1.689     9.755     0.200
     1.900    10.806     0.200
     2.244     9.043     0.200
     2.103    11.011     0.200
     2.105    11.170     0.200
     2.337     9.424     0.200
     2.405     9.816     0.200
     2.420    11.902     0.200
     2.492    12.148     0.200
     2.517    12.145     0.200
     2.918     9.491     0.200
     2.918     9.874     0.200
     3.096     9.918     0.200
     3.096    10.825     0.200
     3.136    13.358     0.200
     3.178    13.010     0.200
     3.178    13.479     0.200
     3.209    13.639     0.200
     3.440    12.406     0.200
     3.243    13.581     0.200
     3.274    13.563     0.200
     3.279    13.826     0.200
     3.289    13.849     0.200
     3.307    13.897     0.200
     3.543    12.453     0.200
     3.623    12.985     0.200
     3.679    13.835     0.200
     3.679    14.054     0.200
     3.919    12.030     0.200
     3.919    12.639     0.200
     3.919    12.772     0.200
     3.738    14.438     0.200
     3.768    14.187     0.200
     3.814    14.292     0.200
     3.903    14.616     0.200
     4.192    12.732     0.200
     4.194    13.807     0.200
     4.275    12.982     0.200
     4.275    13.576     0.200
     4.279    13.126     0.200
     4.262    13.147     0.200
     4.262    13.507     0.200
     4.299    13.725     0.200
     4.299    13.592     0.200
     4.323    13.413     0.200
     4.323    13.015     0.200
     4.344    13.378     0.200
     4.486    14.537     0.200
     4.640    12.653     0.200
     4.640    13.285     0.200
     4.787    15.132     0.200
     4.785    14.796     0.200
     4.804    14.487     0.200
     4.804    14.979     0.200
     4.619    15.939     0.200
     4.839    13.979     0.200
     4.844    14.812     0.200
     4.701    16.123     0.200
     5.037    14.739     0.200
     5.037    14.442     0.200
     5.182    14.694     0.200
     5.182    15.545     0.200
     5.239    13.669     0.200
     5.239    13.895     0.200
     5.246    14.977     0.200
     5.246    15.688     0.200
     5.480    15.830     0.200
     5.625    16.513     0.200
     5.694    16.367     0.200
     5.694    17.312     0.200
     5.697    16.505     0.200
     5.697    17.068     0.200
     5.774    16.843     0.200
     5.776    15.653     0.200
     5.771    15.616     0.200
     5.771    16.132     0.200
     5.874    16.801     0.200
     5.879    16.238     0.200
     5.904    17.296     0.200
     5.904    17.976     0.200
     5.871    19.158     0.200
     6.153    17.070     0.200
     6.226    17.463     0.200
     6.226    18.377     0.200
     6.257    17.890     0.200
     6.256    17.218     0.200
     6.490    19.033     0.200
     6.522    17.465     0.200
     6.671    18.975     0.200
     6.676    18.415     0.200
     6.702    18.926     0.200
     6.701    17.976     0.200
     6.701    18.476     0.200
     6.807    18.257     0.200
     6.810    18.194     0.200
     6.875    19.898     0.200
     6.906    19.938     0.200
     6.914    19.585     0.200
     7.014    18.409     0.200
     7.014    19.316     0.200
     7.111    19.652     0.200
     7.144    18.586     0.200
     7.305    18.443     0.200
     7.305    19.123     0.200
     7.394    19.098     0.200
     7.394    19.637     0.200
     7.564    19.207     0.200
     7.564    19.863     0.200
     7.654    19.692     0.200
     7.655    21.093     0.200
     7.656    19.743     0.200
     7.724    21.385     0.200
     7.784    21.035     0.200
     7.829    21.097     0.200
     7.834    20.694     0.200
     7.877    19.571     0.200
     7.877    20.642     0.200
     7.881    19.760     0.200
     7.881    20.705     0.200
     7.957    22.043     0.200
     8.002    21.705     0.200
     7.989    20.739     0.200
     8.302    21.433     0.200
     8.316    20.614     0.200
     8.316    21.763     0.200
     8.339    20.715     0.200
     8.339    20.957     0.200
     8.395    21.551     0.200
     8.369    21.042     0.200
     8.472    21.752     0.200
     8.472    23.877     0.200
     8.518    24.229     0.200
     8.603    23.273     0.200
     8.603    24.280     0.200
     8.895    21.493     0.200
     8.952    21.925     0.200
     8.952    23.410     0.200
     8.952    22.488     0.200
     8.974    22.817     0.200
     9.053    25.582     0.200
     9.058    22.993     0.200
     9.074    21.931     0.200
     9.074    22.181     0.200
     9.147    22.229     0.200
     9.174    22.826     0.200
     9.269    21.540     0.200
     9.278    22.200     0.200
     9.278    22.724     0.200
     9.379    22.333     0.200
     9.379    23.427     0.200
     9.410    23.266     0.200
     9.461    21.694     0.200
     9.526    22.642     0.200
     9.526    24.931     0.200
     9.586    22.641     0.200
     9.670    23.429     0.200
     9.670    23.194     0.200
     9.758    23.124     0.200
     9.758    23.772     0.200
     9.767    23.961     0.200
     9.767    24.312     0.200
     9.801    24.235     0.200
     9.879    25.552     0.200
     9.918    23.784     0.200
     9.717    24.797     0.200
     9.931    23.559     0.200
     9.955    22.769     0.200
     9.994    24.287     0.200
     9.994    23.655     0.200
     9.790    25.069     0.200
     9.997    24.615     0.200
     9.997    25.248     0.200
     9.959    24.621     0.200
     9.959    24.426     0.200
    10.001    24.335     0.200
    10.001    24.765     0.200
    10.021    23.749     0.200
    10.021    23.468     0.200
    10.033    25.212     0.200
    10.094    23.596     0.200
    10.094    23.861     0.200
    10.108    23.863     0.200
    10.231    24.309     0.200
    10.238    25.151     0.200
    10.300    25.483     0.200
    10.332    26.452     0.200
    10.356    24.361     0.200
    10.356    24.806     0.200
    10.365    24.755     0.200
    10.361    24.542     0.200
    10.364    25.008     0.200
    10.364    26.508     0.200
    10.527    25.740     0.200
    10.527    25.943     0.200
    10.575    24.793     0.200
    10.575    25.503     0.200
    10.590    26.295     0.200
    10.526    26.846     0.200
    10.414    27.249     0.200
    10.596    26.755     0.200
    10.688    25.480     0.200
    10.823    25.932     0.200
    10.807    26.434     0.200
    10.911    24.835     0.200
    10.919    26.360     0.200
    10.917    25.117     0.200
    10.930    25.568     0.200
    10.930    24.724     0.200
    10.941    26.594     0.200
    10.981    25.019     0.200
    10.951    26.584     0.200
    10.993    26.511     0.200
    11.049    25.585     0.200
    11.028    26.791     0.200
    11.102    26.620     0.200
    11.151    26.423     0.200
    11.219    28.050     0.200
    11.239    25.575     0.200
    11.239    26.739     0.200
    11.240    27.893     0.200
    11.262    27.334     0.200
    11.362    27.204     0.200
    11.394    27.003     0.200
    11.526    27.130     0.200
    11.557    27.228     0.200
    11.546    28.060     0.200
    11.614    24.710     0.200
    11.627    27.653     0.200
    11.673    26.342     0.200
    11.673    27.639     0.200
    11.705    27.003     0.200
    11.749    28.189     0.200
    11.749    25.550     0.200
    11.767    26.275     0.200
    11.780    27.399     0.200
    11.780    27.884     0.200
    11.805    26.439     0.200
    11.865    26.379     0.200
    11.865    25.700     0.200
    11.856    28.757     0.200
    11.903    26.746     0.200
    11.957    28.222     0.200
    11.964    25.687     0.200
    11.964    26.218     0.200
    11.964    26.054     0.200
    12.018    28.515     0.200
    12.005    27.468     0.200
    12.082    27.542     0.200
    12.094    28.577     0.200
    12.177    28.783     0.200
    12.200    28.228     0.200
    12.280    28.220     0.200
    12.292    27.296     0.200
    12.308    28.050     0.200
    12.308    28.191     0.200
    12.326    29.026     0.200
    12.361    29.218     0.200
    12.512    29.460     0.200
    12.548    29.205     0.200
    12.556    29.465     0.200
    12.524    29.925     0.200
    12.574    28.023     0.200
    12.621    30.139     0.200
    12.631    30.262     0.200
    12.655    29.299     0.200
    12.655    30.127     0.200
    12.768    30.290     0.200
    12.768    30.089     0.200
    12.788    28.910     0.200
    12.628    30.735     0.200
    12.836    31.114     0.200
    12.836    29.872     0.200
    12.882    29.935     0.200
    12.882    30.474     0.200
    12.908    28.674     0.200
    12.908    29.986     0.200
    13.005    30.427     0.200
    13.142    31.557     0.200
    13.158    32.396     0.200
    13.162    31.188     0.200
    13.210    31.576     0.200
    13.209    31.102     0.200
    13.209    30.711     0.200
    13.353    31.609     0.200
    13.531    31.646     0.200
    13.514    32.742     0.200
    13.571    32.731     0.200
    13.571    31.786     0.200
    13.625    31.030     0.200
    13.642    29.698     0.200
    13.648    31.484     0.200
    13.640    31.318     0.200
    13.725    31.217     0.200
    13.728    30.968     0.200
    13.728    31.382     0.200
    13.761    31.627     0.200
    13.847    32.431     0.200
    13.847    32.564     0.200
    13.883    32.110     0.200
    13.906    31.158     0.200
    13.938    33.109     0.200
    13.956    31.796     0.200
    13.956    31.991     0.200
    14.012    31.086     0.200
    14.012    31.453     0.200
    14.057    32.594     0.200
    14.112    33.427     0.200
    14.135    32.328     0.200
    14.215    31.425     0.200
    14.215    31.784     0.200
    14.222    33.675     0.200
    14.326    32.339     0.200
    14.326    33.557     0.200
    14.324    33.448     0.200
    14.443    33.989     0.200
    14.516    32.573     0.200
    14.489    35.571     0.200
    14.505    33.990     0.200
    14.575    32.406     0.200
    14.588    32.543     0.200
    14.611    32.958     0.200
    14.617    31.058     0.200
    14.644    32.935     0.200
    14.644    34.044     0.200
    14.720    33.060     0.200
    14.720    35.091     0.200
    14.745    34.086     0.200
    14.777    34.845     0.200
    14.932    33.666     0.200
    14.929    35.466     0.200
    14.945    31.564     0.200
    15.097    34.009     0.200
    15.158    34.757     0.200
    15.178    34.050     0.200
    15.197    33.864     0.200
    15.226    33.732     0.200
    15.348    34.212     0.200
    15.323    33.950     0.200
    15.426    33.781     0.200
    15.507    33.674     0.200
    15.565    33.596     0.200
    15.597    34.626     0.200
    15.599    34.010     0.200
    15.599    35.237     0.200
    15.681    34.812     0.200
    15.704    35.663     0.200
    15.718    34.871     0.200
    15.757    34.038     0.200
    15.774    34.462     0.200
    15.795    34.936     0.200
    15.825    34.170     0.200
    15.852    34.520     0.200
    15.900    35.736     0.200
    15.934    34.749     0.200
    16.091    34.371     0.200
    16.200    33.470     0.200
    16.200    35.470     0.200
    16.304    35.283     0.200
    16.448    35.122     0.200
    16.448    35.598     0.200
    16.470    35.157     0.200
    16.541    35.414     0.200
    16.531    36.155     0.200
    16.707    35.248     0.200
    16.742    35.412     0.200
    16.875    35.941     0.200
    16.989    34.569     0.200
    17.017    35.318     0.200
    17.017    34.685     0.200
    17.065    33.505     0.200
    17.065    35.294     0.200
    17.208    35.399     0.200
    17.322    35.272     0.200
    17.769    35.115     0.200
     1.304     8.981     0.200
     1.999     9.373     0.200
     1.877    11.644     0.200
     2.908     9.558     0.200
     3.332    11.322     0.200
     3.952    12.744     0.200
     3.952    13.064     0.200
     3.766    15.947     0.200
     4.468    14.559     0.200
     4.533    14.626     0.200
     4.618    14.940     0.200
     4.605    14.986     0.200
     4.706    13.156     0.200
     4.706    13.367     0.200
     4.712    14.627     0.200
     4.983    15.448     0.200
     5.015    15.643     0.200
     5.150    16.194     0.200
     5.329    14.932     0.200
     5.329    14.620     0.200
     5.409    17.217     0.200
     5.467    16.921     0.200
     5.596    16.816     0.200
     5.653    17.501     0.200
     5.937    16.329     0.200
     5.953    18.009     0.200
     6.080    18.628     0.200
     6.173    18.146     0.200
     6.250    17.815     0.200
     6.340    17.220     0.200
     6.459    19.354     0.200
     6.487    19.169     0.200
     6.626    19.702     0.200
     6.958    19.562     0.200
     6.953    19.697     0.200
     6.898    19.448     0.200
     6.977    19.567     0.200
     6.977    20.958     0.200
     6.988    19.883     0.200
     7.124    20.247     0.200
     7.153    19.475     0.200
     7.249    19.283     0.200
     7.872    20.606     0.200
     8.115    22.460     0.200
     8.162    22.824     0.200
     8.207    22.633     0.200
     8.366    23.058     0.200
     8.522    22.273     0.200
     8.576    23.464     0.200
     8.644    22.413     0.200
     8.644    22.913     0.200
     8.701    22.581     0.200
     8.725    22.918     0.200
     9.082    23.766     0.200
     9.248    24.598     0.200
     9.337    23.737     0.200
     9.343    25.005     0.200
     9.330    23.819     0.200
     9.389    23.395     0.200
     9.421    23.569     0.200
     9.563    23.194     0.200
     9.593    22.750     0.200
     9.719    25.497     0.200
     9.788    24.568     0.200
     9.789    25.848     0.200
     9.931    24.055     0.200
    10.096    26.035     0.200
    10.169    27.167     0.200
    10.243    24.911     0.200
    10.240    24.859     0.200
    10.339    26.388     0.200
    10.383    26.813     0.200
    10.524    27.612     0.200
    10.603    26.289     0.200
    10.625    27.309     0.200
    10.639    27.114     0.200
    10.828    27.798     0.200
    10.905    26.652     0.200
    10.892    28.120     0.200
    11.014    27.691     0.200
    11.059    28.230     0.200
    11.100    28.054     0.200
    11.149    27.834     0.200
    11.358    28.975     0.200
    11.370    28.835     0.200
    11.368    29.433     0.200
    11.490    28.297     0.200
    11.619    28.236     0.200
    11.689    29.415     0.200
    11.694    29.010     0.200
    11.863    29.082     0.200
    11.902    30.072     0.200
    11.904    30.021     0.200
    11.994    30.772     0.200
    12.124    30.195     0.200
    12.196    29.029     0.200
    12.196    25.802     0.200
    12.317    29.461     0.200
    12.337    29.923     0.200
    12.343    30.224     0.200
    12.401    29.333     0.200
    12.501    28.457     0.200
    12.687    32.645     0.200
    12.805    30.686     0.200
    12.879    31.640     0.200
    12.946    31.733     0.200
    12.991    32.547     0.200
    13.079    31.485     0.200
    13.119    32.256     0.200
    13.141    31.610     0.200
    13.183    32.250     0.200
    13.617    33.600     0.200
    13.717    31.175     0.200
    13.763    32.998     0.200
    13.960    33.261     0.200
    13.990    35.929     0.200
    14.118    36.056     0.200
    14.176    33.829     0.200
    14.153    35.710     0.200
    14.192    33.858     0.200
    14.204    34.588     0.200
    14.232    34.344     0.200
    14.783    34.041     0.200
    14.758    35.817     0.200
    14.806    33.828     0.200
    14.871    34.292     0.200
    14.941    33.944     0.200
    15.160    33.879     0.200
    15.301    35.663     0.200
    15.584    35.328     0.200
    15.906    35.919     0.200
    16.080    35.624     0.200
    16.099    35.778     0.200
    16.222    36.144     0.200
    16.564    35.961     0.200
    17.297    37.051     0.200
     1.434     7.618     0.200
     1.453     8.248     0.200
     1.544     9.119     0.200
     1.578     9.046     0.200
     1.911     9.678     0.200
     2.141     9.275     0.200
     2.610    11.842     0.200
     2.610    12.812     0.200
     2.610    11.739     0.200
     2.815    12.003     0.200
     2.817    12.480     0.200
     2.859    12.233     0.200
     2.977    12.732     0.200
     3.189    11.155     0.200
     3.324    11.497     0.200
     3.356    11.842     0.200
     3.379    11.532     0.200
     3.398    12.140     0.200
     3.381    13.835     0.200
     3.496    12.511     0.200
     3.430    13.507     0.200
     3.592    11.571     0.200
     3.464    13.622     0.200
     3.619    12.462     0.200
     3.773    12.685     0.200
     3.808    12.662     0.200
     3.878    13.091     0.200
     3.862    13.266     0.200
     4.046    13.048     0.200
     4.046    13.182     0.200
     4.185    12.802     0.200
     4.185    12.699     0.200
     4.185    13.032     0.200
     4.185    12.451     0.200
     4.185    13.242     0.200
     4.111    15.330     0.200
     4.152    14.683     0.200
     4.152    15.414     0.200
     4.184    15.385     0.200
     4.331    13.692     0.200
     4.331    13.833     0.200
     4.322    13.867     0.200
     4.241    15.277     0.200
     4.247    15.368     0.200
     4.281    15.331     0.200
     4.284    15.583     0.200
     4.448    13.897     0.200
     4.448    14.002     0.200
     4.568    15.291     0.200
     4.568    15.102     0.200
     4.624    15.001     0.200
     4.722    14.795     0.200
     4.723    14.771     0.200
     4.742    14.795     0.200
     4.742    14.958     0.200
     4.664    15.840     0.200
     4.857    14.488     0.200
     4.787    16.282     0.200
     4.899    15.562     0.200
     4.899    15.330     0.200
     4.885    16.370     0.200
     4.916    16.497     0.200
     5.046    15.007     0.200
     5.130    15.757     0.200
     5.130    15.889     0.200
     5.191    15.980     0.200
     5.191    16.177     0.200
     5.369    16.083     0.200
     5.369    15.942     0.200
     5.349    17.209     0.200
     5.349    17.427     0.200
     5.417    16.268     0.200
     5.399    16.702     0.200
     5.399    16.415     0.200
     5.447    16.695     0.200
     5.482    16.589     0.200
     5.657    17.467     0.200
     5.657    17.724     0.200
     5.610    18.892     0.200
     5.762    16.899     0.200
     5.763    17.291     0.200
     5.763    17.421     0.200
     5.814    16.790     0.200
     5.814    17.020     0.200
     5.876    17.671     0.200
     5.887    17.251     0.200
     5.887    17.120     0.200
     5.916    17.324     0.200
     5.944    17.980     0.200
     6.005    18.334     0.200
     6.052    16.646     0.200
     5.966    18.712     0.200
     6.098    16.954     0.200
     6.109    18.174     0.200
     6.073    17.784     0.200
     6.073    17.638     0.200
     6.151    17.367     0.200
     6.151    18.467     0.200
     6.141    17.411     0.200
     6.128    18.267     0.200
     6.236    17.649     0.200
     6.315    19.076     0.200
     6.315    19.935     0.200
     6.422    19.880     0.200
     6.422    19.731     0.200
     6.574    18.490     0.200
     6.656    19.591     0.200
     6.656    20.334     0.200
     6.670    19.849     0.200
     6.672    19.852     0.200
     6.675    20.147     0.200
     6.676    19.879     0.200
     6.698    20.024     0.200
     6.740    20.592     0.200
     6.740    19.173     0.200
     6.759    18.668     0.200
     6.759    18.562     0.200
     6.776    19.356     0.200
     6.776    19.571     0.200
     6.795    18.462     0.200
     6.829    17.511     0.200
     6.829    19.525     0.200
     6.844    19.651     0.200
     6.961    18.422     0.200
     6.961    20.868     0.200
     6.955    18.880     0.200
     6.955    19.314     0.200
     6.867    22.547     0.200
     7.020    20.561     0.200
     7.016    20.650     0.200
     6.942    21.174     0.200
     7.157    20.000     0.200
     7.157    19.775     0.200
     7.313    20.235     0.200
     7.369    19.975     0.200
     7.369    20.712     0.200
     7.401    20.792     0.200
     7.401    20.544     0.200
     7.498    21.190     0.200
     7.498    21.719     0.200
     7.522    19.884     0.200
     7.522    19.778     0.200
     7.542    20.428     0.200
     7.542    20.262     0.200
     7.624    19.784     0.200
     7.624    20.085     0.200
     7.727    20.345     0.200
     7.757    20.871     0.200
     7.757    21.295     0.200
     7.840    21.033     0.200
     7.845    21.123     0.200
     7.830    20.526     0.200
     7.931    20.343     0.200
     7.931    20.113     0.200
     7.931    19.993     0.200
     7.986    21.294     0.200
     7.986    21.148     0.200
     8.043    20.480     0.200
     8.129    20.388     0.200
     8.121    23.127     0.200
     8.190    21.686     0.200
     8.187    21.312     0.200
     8.215    20.370     0.200
     8.230    19.914     0.200
     8.230    21.633     0.200
     8.355    20.797     0.200
     8.363    22.576     0.200
     8.409    19.803     0.200
     8.557    21.597     0.200
     8.557    21.182     0.200
     8.615    21.091     0.200
     8.615    21.431     0.200
     8.607    22.841     0.200
     8.602    22.219     0.200
     8.726    21.811     0.200
     8.905    22.015     0.200
     8.939    23.334     0.200
     8.938    21.757     0.200
     8.954    23.288     0.200
     8.977    23.093     0.200
     8.978    23.641     0.200
     9.011    22.195     0.200
     9.024    21.862     0.200
     9.024    21.535     0.200
     9.049    22.112     0.200
     9.049    22.600     0.200
     9.042    23.556     0.200
     9.074    22.531     0.200
     9.096    21.668     0.200
     9.096    21.786     0.200
     9.175    23.217     0.200
     9.213    24.010     0.200
     9.268    22.946     0.200
     9.247    24.075     0.200
     9.247    23.876     0.200
     9.311    22.432     0.200
     9.311    22.669     0.200
     9.321    23.383     0.200
     9.321    23.618     0.200
     9.382    22.699     0.200
     9.386    25.010     0.200
     9.386    24.814     0.200
     9.440    24.601     0.200
     9.440    24.372     0.200
     9.507    24.002     0.200
     9.570    22.925     0.200
     9.570    22.654     0.200
     9.583    23.721     0.200
     9.535    24.599     0.200
     9.535    24.443     0.200
     9.620    23.689     0.200
     9.620    24.006     0.200
     9.599    24.917     0.200
     9.599    25.245     0.200
     9.639    23.544     0.200
     9.639    24.253     0.200
     9.678    23.450     0.200
     9.768    24.685     0.200
     9.749    25.248     0.200
     9.855    24.033     0.200
     9.862    23.702     0.200
     9.874    24.335     0.200
     9.878    23.761     0.200
     9.883    24.194     0.200
     9.883    25.104     0.200
     9.927    24.206     0.200
     9.954    24.821     0.200
     9.983    24.654     0.200
     9.993    24.653     0.200
     9.967    25.970     0.200
     9.967    25.630     0.200
     9.974    25.812     0.200
    10.050    25.186     0.200
    10.127    24.708     0.200
    10.140    25.425     0.200
    10.185    25.765     0.200
    10.183    23.610     0.200
    10.183    24.704     0.200
    10.225    26.179     0.200
    10.295    25.447     0.200
    10.314    26.096     0.200
    10.341    26.932     0.200
    10.509    26.874     0.200
    10.546    26.426     0.200
    10.534    25.730     0.200
    10.593    26.332     0.200
    10.630    26.538     0.200
    10.695    24.342     0.200
    10.701    26.090     0.200
    10.746    26.236     0.200
    10.824    25.280     0.200
    10.824    25.750     0.200
    10.824    24.990     0.200
    10.824    25.410     0.200
    10.921    27.541     0.200
    10.897    28.046     0.200
    10.967    27.269     0.200
    10.940    27.910     0.200
    10.983    28.029     0.200
    10.993    24.530     0.200
    10.993    24.731     0.200
    11.051    28.452     0.200
    11.128    27.172     0.200
    11.126    25.481     0.200
    11.082    29.195     0.200
    11.082    29.545     0.200
    11.281    27.325     0.200
    11.281    27.628     0.200
    11.292    25.880     0.200
    11.292    26.129     0.200
    11.278    28.302     0.200
    11.301    25.218     0.200
    11.298    28.398     0.200
    11.457    28.180     0.200
    11.355    29.861     0.200
    11.515    27.668     0.200
    11.571    28.041     0.200
    11.615    26.917     0.200
    11.605    29.101     0.200
    11.606    29.024     0.200
    11.780    25.992     0.200
    11.831    28.603     0.200
    11.895    30.049     0.200
    11.938    27.219     0.200
    11.938    26.784     0.200
    11.939    30.197     0.200
    11.957    30.478     0.200
    11.979    27.924     0.200
    11.963    30.226     0.200
    12.099    29.219     0.200
    12.103    30.725     0.200
    12.107    29.648     0.200
    12.399    30.104     0.200
    12.434    29.227     0.200
    12.459    28.859     0.200
    12.478    31.754     0.200
    12.577    30.572     0.200
    12.588    30.190     0.200
    12.717    28.984     0.200
    12.752    28.118     0.200
    12.790    30.458     0.200
    12.781    32.280     0.200
    12.850    29.870     0.200
    12.975    29.656     0.200
    12.975    30.247     0.200
    12.958    31.701     0.200
    13.007    31.087     0.200
    13.026    31.757     0.200
    13.061    32.450     0.200
    13.057    33.014     0.200
    13.070    32.808     0.200
    13.136    30.820     0.200
    13.107    33.261     0.200
    13.134    30.473     0.200
    13.142    30.904     0.200
    13.227    30.915     0.200
    13.227    30.661     0.200
    13.217    31.979     0.200
    13.253    32.438     0.200
    13.288    30.585     0.200
    13.354    31.083     0.200
    13.494    30.422     0.200
    13.574    30.118     0.200
    13.582    31.237     0.200
    13.576    31.616     0.200
    13.586    29.422     0.200
    13.566    31.250     0.200
    13.566    30.814     0.200
    13.612    32.260     0.200
    13.615    32.102     0.200
    13.649    33.283     0.200
    13.695    32.685     0.200
    13.703    33.259     0.200
    13.752    33.194     0.200
    13.796    33.991     0.200
    13.880    33.568     0.200
    13.952    33.077     0.200
    13.993    33.193     0.200
    14.034    31.113     0.200
    14.120    33.701     0.200
    14.128    33.929     0.200
    14.222    33.338     0.200
    14.386    33.784     0.200
    14.377    34.330     0.200
    14.542    31.674     0.200
    14.542    33.071     0.200
    14.556    34.398     0.200
    14.636    34.186     0.200
    14.651    35.079     0.200
    14.653    33.769     0.200
    14.653    33.940     0.200
    14.686    33.687     0.200
    14.769    33.714     0.200
    14.784    34.934     0.200
    14.823    35.384     0.200
    14.925    35.514     0.200
    14.917    34.817     0.200
    14.916    35.040     0.200
    15.017    33.792     0.200
    15.186    33.742     0.200
    15.186    34.426     0.200
    15.437    36.094     0.200
    15.506    35.820     0.200
    15.524    36.601     0.200
    15.700    34.771     0.200
    15.692    37.336     0.200
    15.712    34.812     0.200
    15.810    35.650     0.200
    15.827    36.019     0.200
    15.997    36.944     0.200
    15.997    36.115     0.200
    15.998    36.495     0.200
    15.948    35.698     0.200
    16.093    35.234     0.200
    16.210    35.086     0.200
    16.289    36.091     0.200
    16.306    35.670     0.200
    16.534    36.850     0.200
    16.632    37.824     0.200
    16.759    36.445     0.200
    16.841    34.064     0.200
    17.312    36.291     0.200
    17.312    35.509     0.200
    17.312    35.703     0.200
    18.465    38.724     0.200
    19.007    39.418     0.200
    19.428    37.921     0.200
     1.353     8.566     0.200
     1.356     8.746     0.200
     1.370     8.709     0.200
     1.485     9.806     0.200
     1.496     8.900     0.200
     1.528     8.873     0.200
     1.634     8.884     0.200
     1.662     9.158     0.200
     1.854     7.803     0.200
     2.094    10.901     0.200
     2.094    11.111     0.200
     2.258    11.629     0.200
     2.301    12.239     0.200
     2.508    10.868     0.200
     2.884    13.034     0.200
     3.198    12.498     0.200
     3.470    14.621     0.200
     3.997    14.915     0.200
     3.997    14.806     0.200
     4.245    13.885     0.200
     4.258    15.120     0.200
     4.306    14.281     0.200
     4.522    14.845     0.200
     4.554    15.248     0.200
     4.697    15.475     0.200
     5.061    15.781     0.200
     5.127    15.173     0.200
     5.127    14.232     0.200
     5.361    16.217     0.200
     5.398    16.813     0.200
     5.482    15.986     0.200
     5.551    16.460     0.200
     5.718    17.931     0.200
     5.801    17.003     0.200
     5.883    17.974     0.200
     6.076    18.807     0.200
     6.095    18.339     0.200
     6.097    18.212     0.200
     6.240    18.356     0.200
     6.317    20.115     0.200
     6.418    20.084     0.200
     6.423    19.571     0.200
     6.776    17.771     0.200
     6.822    20.159     0.200
     6.863    19.790     0.200
     6.863    20.650     0.200
     6.903    19.669     0.200
     6.895    20.400     0.200
     7.099    19.658     0.200
     7.118    19.275     0.200
     7.194    20.198     0.200
     7.734    21.561     0.200
     7.782    22.327     0.200
     7.829    21.966     0.200
     8.003    22.215     0.200
     8.075    23.362     0.200
     8.144    21.809     0.200
     8.364    22.947     0.200
     8.366    21.749     0.200
     8.556    24.179     0.200
     8.551    23.524     0.200
     8.551    23.356     0.200
     8.686    23.744     0.200
     9.000    23.963     0.200
     9.171    22.209     0.200
     9.195    23.538     0.200
     9.246    23.708     0.200
     9.234    25.637     0.200
     9.292    24.450     0.200
     9.402    21.961     0.200
     9.592    24.402     0.200
     9.628    25.212     0.200
     9.663    24.426     0.200
    10.059    25.518     0.200
    10.101    26.321     0.200
    10.348    25.525     0.200
    10.345    27.366     0.200
    10.439    26.258     0.200
    10.469    28.375     0.200
    10.578    26.523     0.200
    10.867    28.127     0.200
    10.948    26.638     0.200
    11.099    26.656     0.200
    11.415    27.498     0.200
    11.361    29.913     0.200
    11.578    27.286     0.200
    11.587    29.117     0.200
    11.751    25.692     0.200
    11.790    29.083     0.200
    11.769    30.150     0.200
    12.051    28.679     0.200
    12.051    26.211     0.200
    12.159    30.842     0.200
    12.281    30.150     0.200
    12.335    28.772     0.200
    12.355    28.561     0.200
    12.549    30.048     0.200
    12.611    31.022     0.200
    12.735    32.251     0.200
    13.511    30.398     0.200
    15.815    37.346     0.200
    16.741    37.119     0.200
    16.747    39.082     0.200
    17.348    36.315     0.200
    17.805    35.903     0.200
     1.307     7.394     0.200
     1.323     7.782     0.200
     1.522     8.573     0.200
     1.515     8.454     0.200
     1.770     8.254     0.200
     1.770     8.405     0.200
     1.993    10.515     0.200
     1.993    10.984     0.200
     2.166    10.814     0.200
     2.401    10.659     0.200
     2.412    11.227     0.200
     2.333    11.928     0.200
     2.703     9.507     0.200
     2.801    12.746     0.200
     3.106    11.967     0.200
     3.444    14.451     0.200
     3.737    12.012     0.200
     3.737    13.622     0.200
     3.934    14.628     0.200
     4.167    13.806     0.200
     4.169    13.790     0.200
     4.027    14.971     0.200
     4.237    14.268     0.200
     4.405    14.748     0.200
     4.416    14.047     0.200
     4.485    13.286     0.200
     4.485    12.997     0.200
     4.546    14.712     0.200
     4.836    15.563     0.200
     4.940    15.347     0.200
     5.104    13.774     0.200
     5.104    14.067     0.200
     5.246    16.134     0.200
     5.304    16.163     0.200
     5.422    16.480     0.200
     5.410    16.509     0.200
     5.710    17.579     0.200
     5.710    17.245     0.200
     5.753    17.280     0.200
     5.960    17.468     0.200
     5.950    17.081     0.200
     5.939    17.636     0.200
     6.109    18.938     0.200
     6.088    17.533     0.200
     6.088    17.704     0.200
     6.231    19.625     0.200
     6.290    18.354     0.200
     6.313    18.947     0.200
     6.544    19.116     0.200
     6.758    19.657     0.200
     6.758    19.978     0.200
     6.741    18.841     0.200
     6.781    19.328     0.200
     6.962    19.627     0.200
     7.084    19.656     0.200
     7.088    20.663     0.200
     7.435    19.685     0.200
     7.586    21.237     0.200
     7.663    20.725     0.200
     7.727    22.001     0.200
     7.897    21.807     0.200
     8.014    21.387     0.200
     8.211    22.081     0.200
     8.292    22.052     0.200
     8.433    21.894     0.200
     8.433    22.525     0.200
     8.433    22.169     0.200
     8.473    24.020     0.200
     8.543    22.019     0.200
     9.162    22.662     0.200
     9.149    24.419     0.200
     9.566    25.878     0.200
     9.700    23.797     0.200
     9.856    24.621     0.200
    10.013    25.897     0.200
    10.013    24.699     0.200
    10.197    26.371     0.200
    10.189    26.307     0.200
    10.293    26.296     0.200
    10.683    26.453     0.200
    10.785    25.892     0.200
    10.831    26.396     0.200
    10.873    26.414     0.200
    11.167    28.028     0.200
    11.268    29.801     0.200
    11.563    28.058     0.200
    11.652    28.963     0.200
    11.893    28.657     0.200
    11.968    25.923     0.200
    12.119    29.275     0.200
    12.270    28.587     0.200
    13.399    32.488     0.200
    13.730    32.185     0.200
    13.779    32.154     0.200
    13.945    31.831     0.200
    13.942    34.239     0.200
    13.986    34.022     0.200
    14.145    33.853     0.200
    14.390    33.349     0.200
    14.443    32.091     0.200
    14.514    34.858     0.200
    14.646    35.643     0.200
    14.977    34.903     0.200
    17.738    37.029     0.200
     1.479     8.416     0.200
     1.468     8.677     0.200
     1.465     8.449     0.200
     1.482     8.576     0.200
     1.491     8.749     0.200
     1.724     9.510     0.200
     1.597     9.419     0.200
     1.881     8.296     0.200
     1.783     9.597     0.200
     2.191    10.172     0.200
     2.191     9.942     0.200
     2.523    10.211     0.200
     2.352    10.440     0.200
     2.642     8.998     0.200
     2.398    11.268     0.200
     2.519    11.517     0.200
     2.957    12.452     0.200
     2.974    12.520     0.200
     3.230    11.366     0.200
     3.230    11.605     0.200
     3.703    11.330     0.200
     3.703    11.229     0.200
     3.552    13.821     0.200
     3.595    13.983     0.200
     4.261    13.715     0.200
     4.263    13.698     0.200
     4.319    14.031     0.200
     4.075    14.192     0.200
     4.075    13.903     0.200
     4.379    13.985     0.200
     4.445    14.094     0.200
     4.472    13.078     0.200
     4.472    12.609     0.200
     4.531    14.323     0.200
     4.337    14.775     0.200
     4.624    14.695     0.200
     4.780    15.264     0.200
     5.106    13.924     0.200
     5.114    15.150     0.200
     5.413    16.439     0.200
     5.413    15.786     0.200
     5.406    15.464     0.200
     5.487    15.653     0.200
     5.487    15.802     0.200
     5.482    16.296     0.200
     5.623    17.287     0.200
     5.708    15.480     0.200
     5.710    15.471     0.200
     5.829    16.552     0.200
     5.945    17.037     0.200
     6.125    17.714     0.200
     6.188    17.034     0.200
     6.188    17.620     0.200
     6.170    16.778     0.200
     6.188    17.941     0.200
     6.188    18.198     0.200
     6.341    17.681     0.200
     6.323    18.497     0.200
     6.481    17.681     0.200
     6.486    18.360     0.200
     6.486    18.469     0.200
     6.716    18.529     0.200
     6.772    17.605     0.200
     6.852    19.502     0.200
     6.903    18.238     0.200
     6.956    19.481     0.200
     6.985    19.310     0.200
     6.980    19.502     0.200
     7.066    17.385     0.200
     7.105    17.540     0.200
     7.166    19.813     0.200
     7.197    18.694     0.200
     7.831    20.136     0.200
     7.831    18.769     0.200
     7.833    21.104     0.200
     7.866    21.663     0.200
     8.044    21.942     0.200
     8.104    22.859     0.200
     8.206    21.731     0.200
     8.377    20.860     0.200
     8.377    21.102     0.200
     8.411    21.694     0.200
     8.411    20.784     0.200
     8.583    21.563     0.200
     8.577    21.929     0.200
     8.600    22.652     0.200
     9.077    22.955     0.200
     9.077    21.920     0.200
     9.180    23.028     0.200
     9.391    22.282     0.200
     9.399    23.651     0.200
     9.759    24.038     0.200
     9.848    24.486     0.200
     9.949    24.628     0.200
    10.052    24.240     0.200
    10.105    24.575     0.200
    10.126    25.017     0.200
    10.201    24.792     0.200
    10.348    25.762     0.200
    10.377    24.849     0.200
    10.406    25.200     0.200
    10.458    25.144     0.200
    10.528    26.024     0.200
    10.630    25.653     0.200
    10.672    26.411     0.200
    10.780    26.255     0.200
    10.792    26.185     0.200
    10.854    26.035     0.200
    10.889    26.331     0.200
    11.075    26.732     0.200
    11.148    27.036     0.200
    11.391    27.895     0.200
    11.519    25.605     0.200
    11.550    26.987     0.200
    11.575    27.816     0.200
    11.631    28.836     0.200
    11.677    27.362     0.200
    11.706    28.118     0.200
    11.757    27.746     0.200
    11.770    25.504     0.200
    11.789    27.171     0.200
    11.817    28.582     0.200
    11.886    26.767     0.200
    11.904    28.237     0.200
    11.945    28.691     0.200
    12.090    28.336     0.200
    12.342    28.417     0.200
    12.370    27.442     0.200
    12.526    29.674     0.200
    12.544    29.073     0.200
    12.836    29.662     0.200
    12.927    30.978     0.200
    13.016    30.883     0.200
    13.017    30.160     0.200
    13.439    31.014     0.200
    13.525    30.947     0.200
    13.552    31.705     0.200
    13.798    30.699     0.200
    13.891    30.343     0.200
    13.918    32.186     0.200
    13.994    32.988     0.200
    14.095    34.439     0.200
    14.107    35.134     0.200
    14.220    34.381     0.200
    14.367    33.274     0.200
    14.442    34.388     0.200
    14.560    34.915     0.200
    14.624    32.738     0.200
    14.635    33.768     0.200
    14.928    34.831     0.200
    15.153    34.122     0.200
    15.398    36.057     0.200
    15.472    35.354     0.200
    15.611    34.231     0.200
    15.692    35.412     0.200
    15.713    36.312     0.200
    16.093    35.794     0.200
    16.741    35.988     0.200
    16.742    35.679     0.200
    16.742    37.757     0.200
    16.757    35.210     0.200
    17.354    35.188     0.200
    17.813    34.975     0.200
     1.488    10.443     0.200
     1.557    11.626     0.200
     1.692    11.581     0.200
     1.858    10.994     0.200
     1.753    12.437     0.200
     1.920    11.676     0.200
     1.855    12.488     0.200
     2.013    11.840     0.200
     2.019    11.549     0.200
     2.045    12.208     0.200
     2.046    12.192     0.200
     2.080    12.097     0.200
     2.176    13.748     0.200
     2.375    12.520     0.200
     2.278    13.432     0.200
     2.845    14.616     0.200
     2.990    13.359     0.200
     2.917    15.385     0.200
     3.011    14.815     0.200
     3.015    14.923     0.200
     3.039    14.841     0.200
     3.339    13.289     0.200
     3.362    15.060     0.200
     3.442    15.621     0.200
     3.512    15.355     0.200
     3.624    15.677     0.200
     4.382    15.654     0.200
     4.363    17.960     0.200
     4.772    17.098     0.200
     4.774    17.080     0.200
     4.808    16.857     0.200
     4.837    17.264     0.200
     4.852    17.295     0.200
     4.885    17.306     0.200
     4.885    17.811     0.200
     4.919    17.562     0.200
     4.956    19.761     0.200
     5.132    16.398     0.200
     5.363    18.252     0.200
     5.362    18.271     0.200
     5.399    18.305     0.200
     5.436    18.211     0.200
     5.570    18.966     0.200
     5.751    17.726     0.200
     5.778    19.148     0.200
     5.813    19.091     0.200
     5.891    19.512     0.200
     5.891    19.742     0.200
     6.046    19.571     0.200
     5.986    21.937     0.200
     6.208    20.890     0.200
     6.191    19.926     0.200
     6.286    21.022     0.200
     6.316    19.938     0.200
     6.317    19.920     0.200
     6.327    20.407     0.200
     6.410    20.405     0.200
     6.410    20.610     0.200
     6.468    20.557     0.200
     6.722    21.090     0.200
     6.732    21.144     0.200
     6.732    21.400     0.200
     6.854    20.900     0.200
     7.003    21.626     0.200
     7.042    21.551     0.200
     7.267    21.751     0.200
     7.296    22.630     0.200
     7.320    22.232     0.200
     7.361    22.576     0.200
     7.382    22.291     0.200
     7.610    22.674     0.200
     7.828    23.689     0.200
     7.887    22.589     0.200
     8.156    23.353     0.200
     8.275    24.094     0.200
     8.430    24.053     0.200
     8.504    23.710     0.200
     8.551    24.420     0.200
     8.898    24.580     0.200
     8.926    25.150     0.200
     9.211    25.297     0.200
     9.330    24.938     0.200
     9.330    25.797     0.200
     9.804    26.125     0.200
     9.951    27.770     0.200
     9.832    29.348     0.200
    10.004    25.697     0.200
    10.001    28.115     0.200
    10.396    28.413     0.200
    11.236    29.776     0.200
    12.041    31.089     0.200
    12.555    28.379     0.200
    12.766    33.206     0.200
     1.948    10.700     0.200
     2.175    12.887     0.200
     2.401    11.301     0.200
     2.278    13.024     0.200
     2.289    13.180     0.200
     2.857    12.755     0.200
     2.913    14.585     0.200
     2.983    14.400     0.200
     2.989    14.341     0.200
     3.007    14.616     0.200
     3.010    14.514     0.200
     3.035    14.664     0.200
     3.059    14.717     0.200
     3.355    15.392     0.200
     3.355    14.523     0.200
     3.355    14.720     0.200
     3.437    15.219     0.200
     3.506    15.018     0.200
     3.581    15.538     0.200
     3.618    15.447     0.200
     4.144    15.603     0.200
     4.146    15.696     0.200
     4.197    15.455     0.200
     4.220    15.206     0.200
     4.260    16.306     0.200
     4.400    15.099     0.200
     4.400    14.977     0.200
     4.273    17.438     0.200
     4.384    17.360     0.200
     4.447    17.411     0.200
     4.798    16.318     0.200
     4.799    16.517     0.200
     4.866    16.214     0.200
     4.866    16.441     0.200
     4.831    16.032     0.200
     4.831    16.142     0.200
     4.877    16.778     0.200
     4.913    16.479     0.200
     4.913    16.810     0.200
     4.918    16.648     0.200
     4.947    16.790     0.200
     4.944    16.867     0.200
     5.005    17.273     0.200
     5.019    16.479     0.200
     4.946    18.629     0.200
     4.946    18.209     0.200
     5.152    15.725     0.200
     5.152    16.235     0.200
     5.152    16.044     0.200
     5.389    17.633     0.200
     5.387    17.496     0.200
     5.426    18.313     0.200
     5.426    18.113     0.200
     5.431    17.683     0.200
     5.465    17.656     0.200
     5.465    17.408     0.200
     5.423    17.920     0.200
     5.423    18.127     0.200
     5.599    17.932     0.200
     5.599    18.112     0.200
     5.505    19.682     0.200
     5.806    18.727     0.200
     5.806    18.418     0.200
     5.771    16.923     0.200
     5.591    18.680     0.200
     5.842    18.721     0.200
     5.918    19.088     0.200
     6.071    18.582     0.200
     6.071    19.025     0.200
     5.998    20.449     0.200
     5.998    20.568     0.200
     5.998    20.076     0.200
     6.218    20.052     0.200
     6.237    20.010     0.200
     6.237    19.785     0.200
     6.313    19.344     0.200
     6.313    20.097     0.200
     6.355    19.010     0.200
     6.355    19.203     0.200
     6.338    18.887     0.200
     6.340    18.321     0.200
     6.438    18.963     0.200
     6.438    19.562     0.200
     6.477    20.385     0.200
     6.496    19.194     0.200
     6.496    19.909     0.200
     6.495    20.035     0.200
     6.693    20.715     0.200
     6.693    20.522     0.200
     6.761    20.250     0.200
     6.748    19.399     0.200
     6.843    20.864     0.200
     6.843    20.471     0.200
     6.881    20.319     0.200
     7.070    21.013     0.200
     7.095    21.923     0.200
     7.273    21.987     0.200
     7.273    21.116     0.200
     7.295    21.074     0.200
     7.295    21.513     0.200
     7.325    22.870     0.200
     7.325    22.450     0.200
     7.323    22.018     0.200
     7.323    21.873     0.200
     7.317    21.123     0.200
     7.317    20.726     0.200
     7.349    20.998     0.200
     7.411    21.260     0.200
     7.385    21.067     0.200
     7.483    22.677     0.200
     7.516    23.055     0.200
     7.520    22.870     0.200
     7.523    22.008     0.200
     7.638    22.111     0.200
     7.638    22.843     0.200
     7.719    22.571     0.200
     7.721    20.617     0.200
     7.721    20.734     0.200
     7.855    22.940     0.200
     7.916    22.249     0.200
     7.916    22.419     0.200
     7.967    22.260     0.200
     7.967    22.945     0.200
     8.184    23.186     0.200
     8.269    23.062     0.200
     8.269    24.799     0.200
     8.303    24.346     0.200
     8.300    23.072     0.200
     8.338    23.827     0.200
     8.397    23.432     0.200
     8.192    25.614     0.200
     8.419    22.611     0.200
     8.458    23.912     0.200
     8.458    23.545     0.200
     8.235    26.100     0.200
     8.451    21.913     0.200
     8.451    23.691     0.200
     8.489    23.135     0.200
     8.489    23.550     0.200
     8.274    25.391     0.200
     8.532    23.798     0.200
     8.578    25.070     0.200
     8.578    25.482     0.200
     8.585    24.007     0.200
     8.585    23.841     0.200
     8.616    24.063     0.200
     8.925    25.146     0.200
     8.924    23.716     0.200
     8.924    23.834     0.200
     8.955    24.409     0.200
     8.960    25.088     0.200
     8.960    24.662     0.200
     8.991    25.007     0.200
     9.088    25.478     0.200
     9.113    24.273     0.200
     9.113    23.884     0.200
     9.233    24.469     0.200
     9.233    23.914     0.200
     9.339    24.594     0.200
     9.381    25.440     0.200
     9.354    24.436     0.200
     9.423    24.915     0.200
     9.423    25.425     0.200
     9.427    25.536     0.200
     9.427    24.866     0.200
     9.559    25.593     0.200
     9.551    25.186     0.200
     9.551    24.907     0.200
     9.405    27.376     0.200
     9.676    26.246     0.200
     9.681    25.435     0.200
     9.681    25.943     0.200
     9.666    25.703     0.200
     9.478    27.495     0.200
     9.788    25.737     0.200
     9.788    25.159     0.200
     9.851    25.214     0.200
     9.976    25.114     0.200
     9.976    23.426     0.200
    10.029    26.185     0.200
     9.825    27.888     0.200
     9.825    26.608     0.200
     9.825    28.298     0.200
    10.026    24.719     0.200
    10.180    26.524     0.200
    10.180    26.137     0.200
    10.225    26.020     0.200
    10.225    26.209     0.200
    10.225    25.709     0.200
    10.336    27.224     0.200
    10.107    28.292     0.200
    10.350    26.812     0.200
    10.424    27.735     0.200
    10.489    28.150     0.200
    10.523    27.248     0.200
    10.613    27.683     0.200
    10.624    27.749     0.200
    10.624    27.876     0.200
    10.631    26.077     0.200
    10.610    27.083     0.200
    10.671    27.003     0.200
    10.712    26.103     0.200
    10.788    28.182     0.200
    10.902    28.270     0.200
    10.952    28.423     0.200
    10.923    27.167     0.200
    10.945    27.960     0.200
    10.945    27.511     0.200
    10.987    28.079     0.200
    11.097    28.718     0.200
    11.122    28.752     0.200
    11.181    28.742     0.200
    11.182    26.958     0.200
    11.207    28.532     0.200
    11.259    28.375     0.200
    11.419    28.670     0.200
    11.477    30.477     0.200
    11.455    28.370     0.200
    11.473    28.840     0.200
    11.507    29.080     0.200
    11.539    30.456     0.200
    11.559    29.717     0.200
    11.538    29.602     0.200
    11.627    31.000     0.200
    11.627    29.678     0.200
    11.749    28.576     0.200
    11.769    30.624     0.200
    11.761    29.985     0.200
    11.761    29.536     0.200
    11.795    28.161     0.200
    11.843    29.649     0.200
    11.843    29.981     0.200
    11.861    28.465     0.200
    11.970    30.198     0.200
    12.016    30.993     0.200
    12.127    31.438     0.200
    12.127    32.391     0.200
    12.205    30.471     0.200
    12.233    27.652     0.200
    12.250    28.165     0.200
    12.250    28.885     0.200
    12.230    30.811     0.200
    12.298    32.007     0.200
    12.289    28.854     0.200
    12.327    30.067     0.200
    12.341    30.394     0.200
    12.400    28.935     0.200
    12.400    29.089     0.200
    12.400    28.035     0.200
    12.400    31.796     0.200
    12.480    32.107     0.200
    12.545    30.580     0.200
    12.530    30.727     0.200
    12.581    28.403     0.200
    12.607    31.317     0.200
    12.647    34.359     0.200
    12.702    29.903     0.200
    12.713    32.757     0.200
    12.777    32.720     0.200
    12.748    31.336     0.200
    12.784    32.253     0.200
    12.788    31.836     0.200
    12.822    32.113     0.200
    12.822    31.939     0.200
    12.904    29.523     0.200
    12.910    30.429     0.200
    12.973    32.783     0.200
    13.066    32.393     0.200
    13.110    34.366     0.200
    13.138    30.804     0.200
    13.171    31.276     0.200
    13.157    31.089     0.200
    13.170    32.200     0.200
    13.259    33.575     0.200
    13.386    34.113     0.200
    13.390    33.305     0.200
    13.394    31.936     0.200
    13.429    34.219     0.200
    13.393    33.706     0.200
    13.460    33.291     0.200
    13.525    32.713     0.200
    13.601    32.455     0.200
    13.631    34.197     0.200
    13.631    34.545     0.200
    13.688    34.456     0.200
    13.695    34.721     0.200
    13.779    35.208     0.200
    13.830    34.713     0.200
    13.888    33.658     0.200
    13.976    32.416     0.200
    14.022    32.084     0.200
    14.066    30.921     0.200
    14.121    35.901     0.200
    14.123    36.017     0.200
    14.125    33.629     0.200
    14.209    35.663     0.200
    14.200    34.182     0.200
    14.162    34.872     0.200
    14.246    34.733     0.200
    14.343    35.260     0.200
    14.282    35.271     0.200
    14.347    33.875     0.200
    14.372    32.790     0.200
    14.372    33.649     0.200
    14.439    33.916     0.200
    14.497    35.395     0.200
    14.460    34.593     0.200
    14.543    35.148     0.200
    14.580    34.330     0.200
    14.599    34.025     0.200
    14.626    34.566     0.200
    14.619    35.744     0.200
    14.619    35.062     0.200
    14.619    34.259     0.200
    14.734    34.670     0.200
    14.702    35.409     0.200
    14.702    35.008     0.200
    14.744    34.213     0.200
    14.813    34.988     0.200
    14.804    37.585     0.200
    14.804    34.659     0.200
    14.948    35.405     0.200
    14.964    34.821     0.200
    15.059    34.329     0.200
    15.068    34.896     0.200
    15.070    33.733     0.200
    15.045    35.883     0.200
    15.115    36.239     0.200
    15.029    37.376     0.200
    15.122    34.707     0.200
    14.947    36.156     0.200
    15.091    34.663     0.200
    15.188    34.333     0.200
    15.191    33.891     0.200
    15.205    35.988     0.200
    15.205    35.540     0.200
    15.163    36.699     0.200
    15.163    37.150     0.200
    15.239    35.339     0.200
    15.267    36.085     0.200
    15.397    36.552     0.200
    15.552    35.105     0.200
    15.548    36.238     0.200
    15.583    36.003     0.200
    15.637    38.352     0.200
    15.637    35.339     0.200
    15.696    35.754     0.200
    15.746    36.296     0.200
    15.848    36.020     0.200
    15.906    36.760     0.200
    15.888    36.952     0.200
    15.883    36.983     0.200
    15.954    38.168     0.200
    15.954    38.608     0.200
    15.954    35.871     0.200
    16.171    35.300     0.200
    16.215    36.689     0.200
    16.174    35.285     0.200
    16.219    36.642     0.200
    16.309    35.672     0.200
    16.378    36.641     0.200
    16.386    36.910     0.200
    16.312    36.849     0.200
    16.287    37.353     0.200
    16.363    37.294     0.200
    16.419    36.609     0.200
    16.555    36.423     0.200
    16.609    36.355     0.200
    16.701    37.687     0.200
    16.803    37.204     0.200
    16.910    36.893     0.200
    16.825    37.089     0.200
    16.880    37.043     0.200
    17.011    37.388     0.200
    17.131    36.836     0.200
    17.192    37.023     0.200
    17.198    37.569     0.200
    17.314    37.367     0.200
    17.388    37.824     0.200
    17.497    36.870     0.200
    17.683    37.318     0.200
    17.632    38.021     0.200
    17.818    37.964     0.200
    17.924    37.004     0.200
    18.104    38.215     0.200
    18.160    38.293     0.200
    19.615    40.585     0.200
     1.498    10.808     0.200
     1.577    11.818     0.200
     1.713    12.355     0.200
     1.876    13.321     0.200
     2.005    12.400     0.200
     2.070    12.172     0.200
     2.198    14.077     0.200
     2.363    13.205     0.200
     2.299    13.941     0.200
     2.939    15.133     0.200
     3.015    15.286     0.200
     3.037    15.462     0.200
     3.061    15.709     0.200
     3.383    15.651     0.200
     3.464    16.250     0.200
     3.534    16.043     0.200
     3.609    16.438     0.200
     3.646    16.406     0.200
     4.840    18.343     0.200
     4.835    17.724     0.200
     4.907    19.022     0.200
     4.886    18.155     0.200
     5.115    17.442     0.200
     5.351    19.517     0.200
     5.431    18.746     0.200
     5.572    20.278     0.200
     5.734    18.712     0.200
     5.812    20.748     0.200
     6.033    20.228     0.200
     6.195    21.074     0.200
     6.276    20.096     0.200
     6.302    19.918     0.200
     6.327    21.171     0.200
     6.412    20.805     0.200
     6.462    20.938     0.200
     6.710    22.116     0.200
     6.729    21.879     0.200
     6.846    22.380     0.200
     7.058    22.217     0.200
     7.045    22.149     0.200
     7.262    22.948     0.200
     7.287    24.087     0.200
     7.347    21.944     0.200
     7.321    22.842     0.200
     7.603    23.114     0.200
     7.884    23.458     0.200
     7.940    24.167     0.200
     8.151    24.784     0.200
     8.303    26.834     0.200
     8.423    25.528     0.200
     8.458    24.970     0.200
     8.507    25.195     0.200
     8.886    24.818     0.200
     8.953    25.971     0.200
     8.926    26.045     0.200
     9.083    26.236     0.200
     9.316    26.374     0.200
     9.349    27.215     0.200
     9.530    27.415     0.200
     9.646    28.548     0.200
     9.789    26.999     0.200
     9.854    29.139     0.200
     9.996    28.264     0.200
    10.187    27.245     0.200
    10.312    27.380     0.200
    10.390    29.495     0.200
    10.633    28.491     0.200
    11.982    32.423     0.200
    12.544    28.515     0.200
    13.352    36.360     0.200
    14.162    35.417     0.200
    14.561    37.488     0.200
    14.588    37.540     0.200
    15.128    39.309     0.200
    15.154    36.702     0.200
    15.203    38.487     0.200
    15.232    37.859     0.200
    15.511    39.995     0.200
    15.601    40.617     0.200
    16.134    39.422     0.200
    16.182    38.949     0.200
    16.664    41.143     0.200
    16.766    41.106     0.200
     1.602    11.146     0.200
     1.602    10.677     0.200
     1.731    11.271     0.200
     1.795    12.107     0.200
     1.974    11.251     0.200
     1.892    12.235     0.200
     2.100    11.858     0.200
     2.101    11.848     0.200
     2.205    13.002     0.200
     2.418    11.873     0.200
     2.310    12.957     0.200
     2.866    14.387     0.200
     2.938    14.538     0.200
     2.988    14.575     0.200
     3.008    14.634     0.200
     3.023    14.738     0.200
     3.033    14.615     0.200
     3.061    14.419     0.200
     3.085    14.967     0.200
     3.350    12.956     0.200
     3.378    14.917     0.200
     4.160    15.384     0.200
     4.162    15.372     0.200
     4.236    16.048     0.200
     4.399    15.401     0.200
     4.399    14.452     0.200
     4.375    17.758     0.200
     4.404    17.186     0.200
     4.901    17.087     0.200
     4.901    17.189     0.200
     4.893    16.820     0.200
     4.953    16.975     0.200
     4.976    17.141     0.200
     4.960    16.526     0.200
     4.964    19.310     0.200
     5.154    16.889     0.200
     5.154    16.089     0.200
     5.405    17.826     0.200
     5.404    17.845     0.200
     5.450    18.501     0.200
     5.495    18.629     0.200
     5.495    18.367     0.200
     5.639    18.725     0.200
     5.776    17.454     0.200
     5.776    17.329     0.200
     5.834    18.841     0.200
     5.834    19.466     0.200
     5.879    19.307     0.200
     5.879    18.947     0.200
     6.085    18.916     0.200
     6.041    20.633     0.200
     6.041    20.410     0.200
     6.261    20.706     0.200
     6.261    19.679     0.200
     6.271    20.233     0.200
     6.349    20.416     0.200
     6.394    19.821     0.200
     6.479    19.774     0.200
     6.479    20.036     0.200
     6.526    20.804     0.200
     6.740    20.685     0.200
     6.796    20.758     0.200
     6.908    22.577     0.200
     7.046    21.845     0.200
     7.112    21.080     0.200
     7.327    22.133     0.200
     7.327    21.731     0.200
     7.347    22.730     0.200
     7.347    22.621     0.200
     7.396    21.224     0.200
     7.447    22.536     0.200
     7.447    22.095     0.200
     7.666    23.019     0.200
     8.007    23.633     0.200
     8.216    23.659     0.200
     8.486    25.059     0.200
     8.294    25.944     0.200
     8.991    24.948     0.200
     8.993    25.473     0.200
     9.150    25.199     0.200
     9.366    24.898     0.200
     9.414    26.183     0.200
     9.598    26.961     0.200
     9.710    27.704     0.200
     9.764    25.924     0.200
     9.834    26.016     0.200
     9.861    25.427     0.200
     9.846    28.429     0.200
    10.035    25.264     0.200
    10.128    29.660     0.200
    10.364    26.339     0.200
    10.454    28.842     0.200
    10.526    28.072     0.200
    10.616    27.340     0.200
    10.776    28.335     0.200
    10.958    27.593     0.200
    11.012    29.037     0.200
    11.137    28.758     0.200
    11.200    27.940     0.200
    11.269    28.770     0.200
    11.581    30.610     0.200
    12.209    32.042     0.200
    12.233    31.779     0.200
    12.363    31.737     0.200
    12.643    33.108     0.200
    12.745    34.367     0.200
    12.811    32.785     0.200
    12.821    33.115     0.200
    12.924    31.406     0.200
    12.927    30.514     0.200
    13.418    34.881     0.200
    13.488    31.646     0.200
    14.154    34.447     0.200
    14.207    34.976     0.200
    15.092    37.449     0.200
    15.263    37.233     0.200
    15.569    38.585     0.200
    19.593    41.840     0.200
     1.373     8.695     0.200
     1.370     8.583     0.200
     1.387     8.669     0.200
     1.396     9.070     0.200
     1.501     9.596     0.200
     1.688    10.061     0.200
     1.859     8.958     0.200
     1.859     9.470     0.200
     2.107    11.739     0.200
     2.107    11.098     0.200
     2.271    11.452     0.200
     2.315    12.298     0.200
     2.439    12.864     0.200
     2.438    12.814     0.200
     2.681     9.609     0.200
     2.790    13.362     0.200
     2.879    13.273     0.200
     3.579    13.434     0.200
     3.580    13.418     0.200
     3.653    13.211     0.200
     3.734    13.168     0.200
     3.651    15.114     0.200
     4.248    14.201     0.200
     4.249    14.188     0.200
     4.007    14.969     0.200
     4.007    14.820     0.200
     4.310    14.440     0.200
     4.372    14.647     0.200
     4.153    15.194     0.200
     4.156    15.591     0.200
     4.497    13.352     0.200
     4.497    13.879     0.200
     4.566    15.331     0.200
     4.711    15.350     0.200
     4.711    15.624     0.200
     4.827    15.417     0.200
     4.826    15.428     0.200
     4.941    15.900     0.200
     5.071    15.340     0.200
     5.126    14.301     0.200
     5.015    17.569     0.200
     5.370    16.439     0.200
     5.412    16.538     0.200
     5.485    16.997     0.200
     5.563    17.642     0.200
     5.563    17.278     0.200
     5.807    18.307     0.200
     5.612    19.033     0.200
     5.894    18.063     0.200
     6.085    18.865     0.200
     6.085    19.119     0.200
     6.108    18.233     0.200
     6.112    19.151     0.200
     6.112    18.702     0.200
     6.253    18.269     0.200
     6.426    19.517     0.200
     6.434    19.516     0.200
     6.406    20.169     0.200
     6.777    20.099     0.200
     6.828    21.115     0.200
     6.828    19.693     0.200
     6.912    19.730     0.200
     6.912    19.512     0.200
     6.909    19.490     0.200
     6.973    21.650     0.200
     7.111    19.866     0.200
     7.131    19.433     0.200
     7.202    20.648     0.200
     7.575    20.604     0.200
     7.747    22.103     0.200
     7.792    21.170     0.200
     7.792    22.041     0.200
     7.762    21.665     0.200
     7.836    21.935     0.200
     8.011    22.876     0.200
     8.081    23.003     0.200
     8.155    22.136     0.200
     8.155    22.437     0.200
     8.368    20.655     0.200
     8.368    22.971     0.200
     8.380    22.358     0.200
     8.380    22.690     0.200
     8.561    24.804     0.200
     8.698    23.490     0.200
     8.749    22.197     0.200
     8.749    22.532     0.200
     8.809    23.027     0.200
     8.809    22.847     0.200
     8.975    23.038     0.200
     9.010    24.273     0.200
     8.932    25.291     0.200
     9.195    23.076     0.200
     9.242    24.656     0.200
     9.402    22.161     0.200
     9.638    24.927     0.200
     9.638    25.240     0.200
     9.872    25.006     0.200
     9.968    23.962     0.200
    10.059    27.243     0.200
    10.350    27.323     0.200
    10.348    26.592     0.200
    10.549    28.675     0.200
    10.640    27.733     0.200
    10.479    28.241     0.200
    10.880    26.947     0.200
    11.066    28.139     0.200
    11.324    28.443     0.200
    11.595    30.053     0.200
    11.636    28.318     0.200
    11.714    28.662     0.200
    11.778    29.630     0.200
    11.866    26.795     0.200
    12.315    30.956     0.200
    12.317    30.795     0.200
    12.359    27.585     0.200
    12.532    28.881     0.200
    12.550    28.459     0.200
    12.622    31.202     0.200
    12.830    30.000     0.200
    12.999    32.681     0.200
    13.515    29.816     0.200
    13.567    30.937     0.200
    13.795    32.536     0.200
    13.998    31.980     0.200
    14.002    31.588     0.200
    14.132    33.093     0.200
    14.327    32.736     0.200
    14.506    33.763     0.200
    14.620    33.462     0.200
    14.682    34.142     0.200
    14.744    32.483     0.200
    15.605    33.572     0.200
    15.715    34.490     0.200
    15.824    37.352     0.200
    16.147    38.224     0.200
    16.787    38.320     0.200
    17.351    36.113     0.200
    17.808    35.760     0.200
     1.123     7.340     0.200
     1.259     8.000     0.200
     1.318     6.471     0.200
     1.277     8.014     0.200
     1.311     8.145     0.200
     1.335     8.386     0.200
     1.509     8.555     0.200
     1.798     8.388     0.200
     1.930     9.167     0.200
     1.950     8.607     0.200
     2.226    11.217     0.200
     2.351     9.293     0.200
     2.419    11.169     0.200
     2.437    11.761     0.200
     2.656     9.814     0.200
     2.970    11.196     0.200
     3.056    11.420     0.200
     3.117    11.006     0.200
     3.130    11.597     0.200
     3.172    11.627     0.200
     3.211    11.516     0.200
     3.352    11.159     0.200
     3.717    12.098     0.200
     3.787    12.843     0.200
     3.852    11.622     0.200
     3.973    13.409     0.200
     4.024    12.849     0.200
     4.079    11.769     0.200
     4.199    13.405     0.200
     4.301    14.001     0.200
     4.242    14.580     0.200
     4.336    14.208     0.200
     4.514    14.554     0.200
     4.686    13.018     0.200
     4.852    14.858     0.200
     4.903    15.225     0.200
     4.975    15.698     0.200
     5.025    15.245     0.200
     5.242    15.489     0.200
     5.260    16.303     0.200
     5.342    16.426     0.200
     5.527    15.951     0.200
     5.633    16.547     0.200
     5.659    17.566     0.200
     5.742    16.433     0.200
     5.780    17.654     0.200
     5.870    17.155     0.200
     5.884    17.823     0.200
     5.944    16.680     0.200
     5.881    16.967     0.200
     6.278    18.184     0.200
     6.286    17.152     0.200
     6.285    18.598     0.200
     6.314    17.967     0.200
     6.355    18.277     0.200
     6.405    17.087     0.200
     6.442    18.537     0.200
     6.576    17.424     0.200
     6.565    17.988     0.200
     6.622    17.450     0.200
     6.607    17.767     0.200
     6.645    18.751     0.200
     7.022    18.744     0.200
     7.221    19.990     0.200
     7.234    19.619     0.200
     7.282    20.308     0.200
     7.284    19.686     0.200
     7.352    20.176     0.200
     7.455    20.793     0.200
     7.532    21.893     0.200
     7.841    21.446     0.200
     7.897    21.016     0.200
     7.876    21.418     0.200
     8.161    21.520     0.200
     8.255    20.114     0.200
     8.261    21.285     0.200
     8.570    21.478     0.200
     8.731    21.034     0.200
     8.752    21.508     0.200
     8.767    22.564     0.200
     8.883    22.093     0.200
     9.080    24.077     0.200
     9.254    23.633     0.200
     9.445    24.617     0.200
     9.572    23.268     0.200
     9.806    24.874     0.200
     9.848    25.192     0.200
    10.098    24.260     0.200
    10.160    23.990     0.200
    10.397    23.545     0.200
    10.442    24.256     0.200
    10.511    26.498     0.200
     1.204     6.414     0.200
     1.381     7.707     0.200
     1.405     8.083     0.200
     1.451     8.184     0.200
     1.501     6.470     0.200
     1.501     7.140     0.200
     1.473     8.713     0.200
     1.474     8.706     0.200
     1.474     8.956     0.200
     1.661     8.823     0.200
     1.672     8.553     0.200
     1.700     8.945     0.200
     1.719     9.365     0.200
     1.803     9.435     0.200
     2.007     9.276     0.200
     1.935     8.457     0.200
     1.935     9.594     0.200
     2.180     6.810     0.200
     2.180     8.310     0.200
     2.104     9.563     0.200
     2.143     9.391     0.200
     2.713    11.688     0.200
     2.847    10.717     0.200
     2.847    10.523     0.200
     3.165    11.964     0.200
     3.167    11.458     0.200
     3.237    10.167     0.200
     3.256    11.671     0.200
     3.379    12.054     0.200
     3.745    12.351     0.200
     3.843    12.582     0.200
     3.844    12.571     0.200
     3.890    12.823     0.200
     3.948    12.622     0.200
     4.006    11.149     0.200
     4.006    11.760     0.200
     4.011    12.696     0.200
     4.035    12.704     0.200
     4.058    13.278     0.200
     4.097    13.856     0.200
     4.025    14.789     0.200
     4.124    13.718     0.200
     4.143    13.639     0.200
     4.236    13.515     0.200
     4.415    13.372     0.200
     4.409    13.695     0.200
     4.408    13.713     0.200
     4.365    13.869     0.200
     4.642    12.615     0.200
     4.642    12.879     0.200
     4.485    13.577     0.200
     4.585    14.096     0.200
     4.585    14.141     0.200
     4.585    14.426     0.200
     4.628    15.039     0.200
     4.788    14.053     0.200
     4.788    15.223     0.200
     5.006    14.038     0.200
     5.046    15.543     0.200
     5.051    14.985     0.200
     5.253    14.444     0.200
     5.290    16.484     0.200
     5.369    15.901     0.200
     5.369    16.376     0.200
     5.431    15.253     0.200
     5.646    16.870     0.200
     5.646    17.459     0.200
     5.754    15.799     0.200
     5.782    15.742     0.200
     5.933    17.468     0.200
     5.932    16.991     0.200
     5.932    17.521     0.200
     6.052    16.671     0.200
     6.087    17.849     0.200
     6.087    18.093     0.200
     6.045    17.297     0.200
     6.045    18.633     0.200
     6.126    16.836     0.200
     6.126    17.367     0.200
     6.195    17.248     0.200
     6.319    17.356     0.200
     6.556    16.598     0.200
     6.614    17.398     0.200
     6.596    18.849     0.200
     6.628    17.611     0.200
     6.795    18.942     0.200
     6.876    19.141     0.200
     6.889    18.054     0.200
     6.974    18.611     0.200
     6.974    19.223     0.200
     7.321    19.348     0.200
     7.321    20.168     0.200
     7.485    20.356     0.200
     7.496    18.669     0.200
     7.496    20.419     0.200
     7.584    20.412     0.200
     7.674    20.829     0.200
     7.705    21.557     0.200
     7.695    20.004     0.200
     7.947    20.162     0.200
     7.969    21.008     0.200
     7.904    20.295     0.200
     8.110    22.532     0.200
     8.292    20.281     0.200
     8.257    22.089     0.200
     8.266    21.543     0.200
     8.503    22.507     0.200
     8.578    21.566     0.200
     8.718    21.760     0.200
     8.739    22.720     0.200
     8.931    20.818     0.200
     9.114    22.421     0.200
     9.114    22.290     0.200
     9.109    22.920     0.200
     9.304    23.009     0.200
     9.339    23.021     0.200
     9.597    24.189     0.200
     9.680    23.399     0.200
    10.134    24.794     0.200
    11.657    29.312     0.200
    11.654    24.153     0.200
    12.348    29.727     0.200
    12.685    30.385     0.200
    13.356    29.694     0.200
    13.541    31.628     0.200
    13.632    34.362     0.200
    13.757    33.892     0.200
    14.126    32.142     0.200
    14.184    31.298     0.200
    15.672    33.886     0.200
    16.291    35.197     0.200
    17.943    34.837     0.200
    17.943    35.683     0.200
     1.837    10.081     0.200
     2.017    10.442     0.200
     2.018    10.488     0.200
     2.059    10.481     0.200
     2.364     9.758     0.200
     2.813    11.952     0.200
     2.800    13.746     0.200
     2.872    13.793     0.200
     2.943    13.944     0.200
     2.964    13.842     0.200
     2.993    14.101     0.200
     3.359    11.602     0.200
     3.359    13.141     0.200
     3.320    14.399     0.200
     3.320    14.278     0.200
     3.398    14.965     0.200
     3.469    14.432     0.200
     3.666    13.821     0.200
     3.666    13.709     0.200
     3.546    14.765     0.200
     3.582    14.798     0.200
     4.108    14.869     0.200
     4.243    16.507     0.200
     4.325    16.809     0.200
     4.352    16.557     0.200
     4.383    16.979     0.200
     4.705    15.881     0.200
     4.793    16.134     0.200
     4.841    16.277     0.200
     4.834    16.265     0.200
     4.834    16.390     0.200
     4.870    16.276     0.200
     4.920    17.466     0.200
     5.142    14.507     0.200
     5.142    15.678     0.200
     5.375    16.847     0.200
     5.401    16.979     0.200
     5.401    17.664     0.200
     5.518    17.782     0.200
     5.479    19.099     0.200
     5.748    18.043     0.200
     5.757    15.986     0.200
     5.767    18.338     0.200
     5.919    19.263     0.200
     6.038    17.092     0.200
     6.038    18.762     0.200
     6.133    18.924     0.200
     6.133    19.528     0.200
     6.168    19.493     0.200
     6.265    19.707     0.200
     6.265    19.556     0.200
     6.278    19.226     0.200
     6.315    19.074     0.200
     6.357    18.208     0.200
     6.357    18.987     0.200
     6.435    18.350     0.200
     6.435    19.395     0.200
     6.604    19.677     0.200
     6.604    20.099     0.200
     6.690    19.987     0.200
     6.796    20.051     0.200
     6.825    20.894     0.200
     6.825    20.144     0.200
     6.989    21.431     0.200
     6.987    20.794     0.200
     7.056    20.748     0.200
     7.230    21.024     0.200
     7.272    22.268     0.200
     7.272    21.242     0.200
     7.269    20.611     0.200
     7.338    20.524     0.200
     7.338    21.169     0.200
     7.357    21.309     0.200
     7.474    21.478     0.200
     7.579    21.790     0.200
     7.647    21.098     0.200
     7.678    21.203     0.200
     7.769    22.002     0.200
     7.846    22.182     0.200
     7.888    21.734     0.200
     7.888    22.429     0.200
     8.120    21.627     0.200
     8.120    21.830     0.200
     8.215    22.921     0.200
     8.257    22.741     0.200
     8.387    22.133     0.200
     8.243    24.269     0.200
     8.400    22.566     0.200
     8.400    22.207     0.200
     8.425    21.619     0.200
     8.448    22.465     0.200
     8.527    22.629     0.200
     8.572    22.276     0.200
     8.883    23.234     0.200
     8.883    23.024     0.200
     8.878    23.564     0.200
     8.896    24.093     0.200
     8.896    22.774     0.200
     8.896    24.413     0.200
     8.956    23.328     0.200
     9.042    24.632     0.200
     9.042    23.466     0.200
     9.040    23.388     0.200
     9.040    24.363     0.200
     9.314    24.594     0.200
     9.325    23.953     0.200
     9.515    24.627     0.200
     9.372    26.253     0.200
     9.633    24.918     0.200
     9.711    24.626     0.200
     9.805    25.424     0.200
     9.825    24.543     0.200
     9.825    24.176     0.200
     9.941    23.845     0.200
     9.792    26.513     0.200
     9.792    26.955     0.200
     9.964    25.914     0.200
    10.003    24.071     0.200
    10.096    26.998     0.200
    10.317    26.144     0.200
    10.362    27.105     0.200
    10.488    27.205     0.200
    10.644    26.641     0.200
    10.913    27.129     0.200
    10.931    26.807     0.200
    11.234    28.746     0.200
    11.471    28.094     0.200
    11.954    30.527     0.200
    12.047    29.620     0.200
    12.113    29.107     0.200
    12.218    29.824     0.200
    12.329    30.517     0.200
    12.423    30.793     0.200
    12.534    28.383     0.200
    12.818    32.442     0.200
    12.873    30.442     0.200
    13.319    33.916     0.200
    13.385    32.882     0.200
    13.401    32.543     0.200
    13.478    29.882     0.200
    14.024    29.510     0.200
    14.402    34.748     0.200
    14.568    34.687     0.200
    14.673    34.978     0.200
    14.694    35.668     0.200
    14.804    36.764     0.200
    15.153    33.447     0.200
    15.170    37.591     0.200
    15.204    36.002     0.200
    15.333    36.050     0.200
    15.786    36.352     0.200
    15.872    38.325     0.200
    16.149    36.290     0.200
    16.277    37.064     0.200
    16.315    36.597     0.200
    16.316    37.137     0.200
    16.348    37.960     0.200
    17.302    37.376     0.200
    17.887    37.247     0.200
     1.119     6.202     0.200
     1.119     6.394     0.200
     1.124     6.680     0.200
     1.204     7.181     0.200
     1.470     8.549     0.200
     1.825     8.555     0.200
     1.825     8.875     0.200
     2.008     9.450     0.200
     2.010     9.557     0.200
     2.004     9.411     0.200
     2.077     8.203     0.200
     2.080     9.577     0.200
     2.131     9.502     0.200
     2.291     9.926     0.200
     2.518     9.482     0.200
     2.518    11.409     0.200
     2.691    10.289     0.200
     2.765    10.050     0.200
     2.811     9.259     0.200
     2.982    11.123     0.200
     2.982    12.241     0.200
     3.217    11.125     0.200
     3.232    11.255     0.200
     3.300    11.733     0.200
     3.432    10.285     0.200
     3.432    10.137     0.200
     3.513    12.716     0.200
     3.643    12.106     0.200
     3.647    13.270     0.200
     3.842    12.353     0.200
     3.842    13.884     0.200
     3.871    12.594     0.200
     3.866    12.485     0.200
     4.033    12.077     0.200
     4.046    13.046     0.200
     4.033    13.700     0.200
     4.312    13.586     0.200
     4.312    14.023     0.200
     4.562    13.701     0.200
     4.628    14.926     0.200
     4.723    15.107     0.200
     4.789    13.991     0.200
     4.781    14.893     0.200
     4.798    14.831     0.200
     4.865    15.074     0.200
     4.867    14.804     0.200
     4.929    15.034     0.200
     5.029    14.854     0.200
     5.101    15.147     0.200
     5.339    15.952     0.200
     5.339    15.923     0.200
     5.380    15.951     0.200
     5.521    15.581     0.200
     5.585    16.815     0.200
     5.834    17.030     0.200
     6.060    16.894     0.200
     6.166    16.428     0.200
     6.283    17.529     0.200
     6.395    18.571     0.200
     6.504    17.825     0.200
     6.509    18.144     0.200
     6.513    18.744     0.200
     6.872    19.324     0.200
     7.017    20.393     0.200
     7.000    19.267     0.200
     7.200    19.727     0.200
     7.501    19.239     0.200
     7.654    20.382     0.200
     7.713    20.253     0.200
     7.755    20.713     0.200
     7.840    20.968     0.200
     7.898    19.847     0.200
     8.097    20.344     0.200
     8.185    22.287     0.200
     8.346    20.397     0.200
     8.312    22.137     0.200
     8.523    21.659     0.200
     8.564    22.006     0.200
     8.597    21.185     0.200
     8.630    22.791     0.200
     8.682    22.209     0.200
     8.862    22.842     0.200
     8.999    22.395     0.200
     9.118    23.223     0.200
     9.406    23.765     0.200
     9.473    24.179     0.200
     9.535    23.438     0.200
     9.609    23.932     0.200
     9.722    23.806     0.200
     9.803    25.163     0.200
     9.856    24.708     0.200
     9.868    25.333     0.200
     9.953    25.633     0.200
    10.155    22.816     0.200
    10.196    25.531     0.200
    10.259    25.204     0.200
    10.480    23.681     0.200
    11.054    26.340     0.200
    13.724    32.642     0.200
    14.045    33.564     0.200
    15.178    34.417     0.200
    15.702    36.255     0.200
    16.744    37.336     0.200
    16.744    35.289     0.200
     0.568     5.867     0.200
     0.749     6.134     0.200
     0.771     6.128     0.200
     0.806     6.331     0.200
     1.082     4.622     0.200
     1.082     5.848     0.200
     0.947     6.875     0.200
     1.119     7.571     0.200
     1.200     8.484     0.200
     1.340     7.080     0.200
     1.504     7.718     0.200
     1.631     7.895     0.200
     1.820     6.940     0.200
     1.877     7.938     0.200
     1.885     7.347     0.200
     2.098     8.269     0.200
     2.196     8.409     0.200
     2.197     8.390     0.200
     2.281     8.857     0.200
     2.475     7.937     0.200
     2.438     9.375     0.200
     2.483     9.291     0.200
     2.580    10.696     0.200
     2.744     9.910     0.200
     2.672     9.534     0.200
     2.672    10.131     0.200
     2.704    10.893     0.200
     2.714    11.137     0.200
     2.823    10.344     0.200
     3.059     9.171     0.200
     3.014    10.542     0.200
     3.224    10.912     0.200
     3.375    11.439     0.200
     3.375    11.302     0.200
     3.374    10.938     0.200
     3.390    10.761     0.200
     3.606    11.259     0.200
     3.608    11.374     0.200
     3.553    11.310     0.200
     3.667    12.086     0.200
     3.667    11.844     0.200
     3.813    12.930     0.200
     3.813    12.379     0.200
     3.886    13.350     0.200
     3.895    13.286     0.200
     4.085    13.158     0.200
     4.194    13.340     0.200
     4.294    13.080     0.200
     4.294    12.939     0.200
     4.307    12.801     0.200
     4.307    12.918     0.200
     4.385    13.708     0.200
     4.386    12.954     0.200
     4.342    13.917     0.200
     4.529    13.539     0.200
     4.613    13.958     0.200
     4.660    13.680     0.200
     4.854    14.463     0.200
     4.840    14.719     0.200
     4.794    14.198     0.200
     4.895    14.533     0.200
     4.871    14.462     0.200
     4.995    13.088     0.200
     5.083    14.482     0.200
     5.122    14.821     0.200
     5.183    14.614     0.200
     5.183    14.829     0.200
     5.232    15.838     0.200
     5.336    15.436     0.200
     5.597    15.366     0.200
     5.597    15.596     0.200
     5.712    14.871     0.200
     5.810    16.341     0.200
     5.854    15.832     0.200
     5.937    16.237     0.200
     6.017    16.571     0.200
     6.016    15.966     0.200
     6.016    16.150     0.200
     6.077    16.956     0.200
     6.108    16.924     0.200
     6.278    16.899     0.200
     6.298    15.989     0.200
     6.435    17.911     0.200
     6.435    17.430     0.200
     6.506    17.580     0.200
     6.517    17.967     0.200
     6.519    17.392     0.200
     6.632    15.841     0.200
     6.755    17.373     0.200
     6.755    17.740     0.200
     7.095    16.984     0.200
     7.235    18.285     0.200
     7.263    18.428     0.200
     7.263    18.537     0.200
     7.254    18.532     0.200
     7.254    18.641     0.200
     7.340    18.563     0.200
     7.687    19.835     0.200
     7.836    19.521     0.200
     7.951    18.754     0.200
     8.072    20.270     0.200
     8.131    19.631     0.200
     8.377    19.499     0.200
     8.761    22.139     0.200
     8.962    21.141     0.200
     9.333    20.895     0.200
     9.333    21.766     0.200
     9.667    21.756     0.200
     9.686    20.998     0.200
     9.763    22.496     0.200
    10.148    22.027     0.200
     1.378    10.102     0.200
     1.378    10.923     0.200
     1.372    12.419     0.200
     2.083    11.966     0.200
     2.082    12.328     0.200
     2.083    11.609     0.200
     2.454    11.440     0.200
     2.454    12.719     0.200
     2.894    13.567     0.200
     3.049    13.684     0.200
     3.055    13.615     0.200
     3.484    13.704     0.200
     3.484    14.004     0.200
     3.484    14.288     0.200
     3.743    15.478     0.200
     3.743    15.236     0.200
     4.091    16.195     0.200
     4.242    16.345     0.200
     4.516    15.884     0.200
     4.516    16.033     0.200
     4.822    17.468     0.200
     4.822    17.179     0.200
     4.842    16.808     0.200
     4.842    17.304     0.200
     4.914    17.019     0.200
     4.914    17.357     0.200
     4.930    17.812     0.200
     4.942    17.576     0.200
     4.940    17.533     0.200
     4.999    17.166     0.200
     5.257    16.385     0.200
     5.257    16.615     0.200
     5.257    16.767     0.200
     5.437    18.891     0.200
     5.444    19.474     0.200
     5.444    19.335     0.200
     5.449    17.929     0.200
     5.449    18.843     0.200
     5.489    18.528     0.200
     5.521    18.821     0.200
     5.805    19.320     0.200
     5.790    18.987     0.200
     5.790    19.089     0.200
     5.868    18.534     0.200
     5.868    18.278     0.200
     5.868    17.425     0.200
     5.949    19.226     0.200
     5.949    19.803     0.200
     6.131    19.686     0.200
     6.131    19.414     0.200
     6.119    19.794     0.200
     6.119    20.856     0.200
     6.203    20.648     0.200
     6.293    19.280     0.200
     6.337    19.970     0.200
     6.337    20.356     0.200
     6.359    20.186     0.200
     6.417    20.519     0.200
     6.419    19.781     0.200
     6.485    19.364     0.200
     6.485    20.625     0.200
     6.562    21.081     0.200
     6.562    21.444     0.200
     6.722    21.008     0.200
     6.798    20.392     0.200
     6.798    21.495     0.200
     6.871    20.670     0.200
     6.871    22.093     0.200
     6.885    22.184     0.200
     6.885    21.703     0.200
     6.983    21.118     0.200
     6.983    21.970     0.200
     7.074    21.332     0.200
     7.079    22.044     0.200
     7.272    22.240     0.200
     7.322    22.847     0.200
     7.322    23.181     0.200
     7.276    21.595     0.200
     7.341    22.572     0.200
     7.341    23.314     0.200
     7.382    22.371     0.200
     7.382    23.365     0.200
     7.362    21.903     0.200
     7.362    22.468     0.200
     7.525    23.247     0.200
     7.556    22.796     0.200
     7.584    23.786     0.200
     7.633    23.391     0.200
     7.744    21.450     0.200
     7.761    22.941     0.200
     7.792    22.162     0.200
     7.750    23.097     0.200
     7.750    23.919     0.200
     7.879    22.964     0.200
     7.879    23.390     0.200
     7.895    23.207     0.200
     7.895    23.881     0.200
     8.164    23.226     0.200
     8.164    24.211     0.200
     8.257    25.419     0.200
     8.261    24.672     0.200
     8.290    24.927     0.200
     8.303    25.392     0.200
     8.305    24.637     0.200
     8.305    25.600     0.200
     8.308    23.233     0.200
     8.308    25.089     0.200
     8.324    23.071     0.200
     8.324    25.454     0.200
     8.337    23.401     0.200
     8.456    24.285     0.200
     8.456    25.195     0.200
     8.450    23.501     0.200
     8.450    23.798     0.200
     8.480    23.802     0.200
     8.441    24.007     0.200
     8.441    24.714     0.200
     8.524    23.988     0.200
     8.524    24.371     0.200
     8.596    25.937     0.200
     8.596    26.370     0.200
     8.650    24.445     0.200
     8.650    24.622     0.200
     8.913    24.281     0.200
     8.892    24.838     0.200
     8.930    26.218     0.200
     8.930    25.663     0.200
     8.941    24.652     0.200
     8.941    24.792     0.200
     9.046    25.124     0.200
     9.046    24.909     0.200
     9.064    24.732     0.200
     9.064    24.494     0.200
     9.118    25.656     0.200
     9.118    26.631     0.200
     9.319    25.436     0.200
     9.353    25.360     0.200
     9.353    25.960     0.200
     9.421    24.774     0.200
     9.421    25.696     0.200
     9.495    25.706     0.200
     9.495    26.691     0.200
     9.603    25.404     0.200
     9.603    25.894     0.200
     9.603    25.541     0.200
     9.676    26.382     0.200
     9.676    27.229     0.200
     9.690    25.611     0.200
     9.690    28.831     0.200
     9.725    25.702     0.200
     9.799    26.601     0.200
     9.822    26.718     0.200
     9.822    25.571     0.200
     9.910    25.947     0.200
     9.925    26.266     0.200
     9.925    25.994     0.200
    10.007    26.972     0.200
    10.030    24.559     0.200
    10.030    26.122     0.200
     9.658    30.869     0.200
    10.105    24.843     0.200
    10.159    25.986     0.200
    10.159    28.254     0.200
    10.238    26.839     0.200
    10.310    26.682     0.200
    10.310    26.342     0.200
    10.310    27.035     0.200
    10.409    26.786     0.200
    10.409    27.355     0.200
    10.412    27.325     0.200
    10.412    28.780     0.200
    10.391    28.033     0.200
    10.391    28.622     0.200
    10.507    29.412     0.200
    10.556    27.785     0.200
    10.577    28.639     0.200
    10.601    27.510     0.200
    10.566    28.611     0.200
    10.566    29.222     0.200
    10.622    27.165     0.200
    10.622    27.823     0.200
    10.639    27.547     0.200
    10.639    28.438     0.200
    10.702    27.921     0.200
    10.742    27.741     0.200
    10.700    29.555     0.200
    10.864    27.724     0.200
    10.854    29.502     0.200
    10.854    29.364     0.200
    10.934    27.824     0.200
    10.934    27.289     0.200
    10.997    28.510     0.200
    10.997    29.331     0.200
    11.006    28.307     0.200
    11.006    28.457     0.200
    11.007    27.965     0.200
    11.006    28.417     0.200
    11.021    29.148     0.200
    11.021    29.793     0.200
    11.140    28.049     0.200
    11.116    30.116     0.200
    11.234    27.159     0.200
    11.234    28.514     0.200
    11.334    28.524     0.200
    11.334    29.305     0.200
    11.383    29.395     0.200
    11.383    30.438     0.200
    11.376    30.514     0.200
    11.450    30.272     0.200
    11.449    30.865     0.200
    11.449    30.603     0.200
    11.534    29.970     0.200
    11.569    28.819     0.200
    11.574    28.950     0.200
    11.575    29.911     0.200
    11.622    29.934     0.200
    11.721    30.089     0.200
    11.721    30.564     0.200
    11.660    30.773     0.200
    11.660    31.607     0.200
    11.802    29.667     0.200
    11.802    29.558     0.200
    11.863    30.855     0.200
    11.863    30.453     0.200
    11.879    27.776     0.200
    11.879    28.239     0.200
    11.927    31.069     0.200
    11.927    30.731     0.200
    12.003    30.656     0.200
    12.003    31.402     0.200
    12.043    28.280     0.200
    12.058    31.170     0.200
    12.058    30.613     0.200
    12.248    30.741     0.200
    12.257    28.549     0.200
    12.261    29.654     0.200
    12.261    29.537     0.200
    12.239    32.244     0.200
    12.320    28.871     0.200
    12.398    30.349     0.200
    12.398    31.037     0.200
    12.418    31.260     0.200
    12.418    31.640     0.200
    12.422    30.101     0.200
    12.422    29.601     0.200
    12.422    30.617     0.200
    12.473    32.907     0.200
    12.516    30.608     0.200
    12.516    30.799     0.200
    12.559    32.504     0.200
    12.559    32.100     0.200
    12.607    30.662     0.200
    12.608    29.001     0.200
    12.608    30.681     0.200
    12.691    32.566     0.200
    12.724    31.185     0.200
    12.723    30.181     0.200
    12.723    31.351     0.200
    12.705    32.683     0.200
    12.824    32.082     0.200
    12.887    32.721     0.200
    12.940    30.348     0.200
    12.959    30.961     0.200
    12.959    30.743     0.200
    12.936    32.818     0.200
    13.045    32.100     0.200
    13.183    32.349     0.200
    13.205    32.014     0.200
    13.205    32.456     0.200
    13.224    32.108     0.200
    13.213    33.341     0.200
    13.264    34.167     0.200
    13.360    34.655     0.200
    13.352    34.678     0.200
    13.439    32.029     0.200
    13.455    32.684     0.200
    13.500    33.869     0.200
    13.500    34.024     0.200
    13.552    32.083     0.200
    13.552    31.943     0.200
    13.656    33.507     0.200
    13.703    34.418     0.200
    13.703    34.301     0.200
    13.790    35.758     0.200
    13.789    35.072     0.200
    13.809    35.352     0.200
    13.879    33.064     0.200
    13.879    33.951     0.200
    13.984    33.881     0.200
    13.984    33.497     0.200
    14.040    33.514     0.200
    14.036    34.397     0.200
    14.036    36.308     0.200
    14.078    35.765     0.200
    14.155    35.857     0.200
    14.155    34.859     0.200
    14.132    36.146     0.200
    14.193    34.227     0.200
    14.237    35.607     0.200
    14.284    34.759     0.200
    14.284    34.572     0.200
    14.275    36.522     0.200
    14.297    35.264     0.200
    14.297    35.059     0.200
    14.422    35.366     0.200
    14.444    35.793     0.200
    14.444    36.465     0.200
    14.464    36.268     0.200
    14.496    36.803     0.200
    14.536    34.685     0.200
    14.536    35.314     0.200
    14.579    34.858     0.200
    14.579    34.717     0.200
    14.662    35.355     0.200
    14.662    34.886     0.200
    14.703    35.759     0.200
    14.723    36.309     0.200
    14.784    34.154     0.200
    14.762    36.285     0.200
    14.762    36.729     0.200
    14.809    35.020     0.200
    14.925    38.071     0.200
    14.925    37.291     0.200
    14.925    36.881     0.200
    14.941    35.973     0.200
    14.941    36.296     0.200
    14.997    37.175     0.200
    15.030    36.156     0.200
    15.090    34.648     0.200
    15.075    37.859     0.200
    15.130    35.524     0.200
    15.130    34.690     0.200
    15.144    35.519     0.200
    15.168    37.306     0.200
    15.168    37.699     0.200
    15.223    35.151     0.200
    15.239    35.975     0.200
    15.252    37.066     0.200
    15.252    36.844     0.200
    15.252    36.469     0.200
    15.275    36.924     0.200
    15.301    36.345     0.200
    15.295    37.968     0.200
    15.362    38.265     0.200
    15.362    37.876     0.200
    15.376    37.513     0.200
    15.564    35.554     0.200
    15.542    36.785     0.200
    15.577    35.608     0.200
    15.574    36.916     0.200
    15.574    36.592     0.200
    15.746    37.645     0.200
    15.757    38.641     0.200
    15.757    37.635     0.200
    15.823    38.041     0.200
    15.823    37.594     0.200
    15.834    37.263     0.200
    15.834    37.773     0.200
    15.839    37.453     0.200
    16.075    37.695     0.200
    16.109    38.643     0.200
    16.190    37.369     0.200
    16.216    35.615     0.200
    16.289    37.006     0.200
    16.289    38.354     0.200
    16.325    37.674     0.200
    16.369    36.396     0.200
    16.369    37.062     0.200
    16.348    36.905     0.200
    16.361    36.956     0.200
    16.412    36.669     0.200
    16.412    37.554     0.200
    16.458    38.664     0.200
    16.458    38.107     0.200
    16.439    38.421     0.200
    16.573    37.371     0.200
    16.741    37.356     0.200
    16.865    37.998     0.200
    17.015    39.510     0.200
    17.015    38.848     0.200
    17.135    38.209     0.200
    17.192    38.232     0.200
    17.193    38.237     0.200
    17.357    38.158     0.200
    17.408    37.564     0.200
    17.509    38.091     0.200
    17.539    39.192     0.200
    17.594    38.890     0.200
    17.710    38.064     0.200
    17.857    38.474     0.200
    17.973    37.561     0.200
    18.121    37.264     0.200
    18.278    39.659     0.200
     1.374     9.512     0.200
     1.467     9.975     0.200
     1.467    10.264     0.200
     1.611    10.747     0.200
     1.667    11.833     0.200
     1.983    12.016     0.200
     2.337    11.771     0.200
     2.108    13.206     0.200
     2.204    13.197     0.200
     2.788    14.896     0.200
     2.931    15.641     0.200
     2.980    13.601     0.200
     3.353    13.437     0.200
     3.353    13.250     0.200
     3.311    14.613     0.200
     3.634    14.400     0.200
     3.537    15.909     0.200
     3.573    15.225     0.200
     3.978    15.961     0.200
     4.386    15.443     0.200
     4.386    15.091     0.200
     4.319    17.913     0.200
     4.787    16.393     0.200
     4.814    17.453     0.200
     4.848    17.037     0.200
     5.128    15.948     0.200
     5.128    16.436     0.200
     5.471    17.975     0.200
     5.723    18.646     0.200
     5.740    18.123     0.200
     5.740    17.412     0.200
     6.012    19.360     0.200
     5.881    19.646     0.200
     6.085    19.873     0.200
     6.126    19.754     0.200
     6.231    20.783     0.200
     6.310    19.092     0.200
     6.396    19.868     0.200
     6.556    20.431     0.200
     6.647    20.245     0.200
     6.788    20.464     0.200
     6.940    20.635     0.200
     7.189    21.367     0.200
     7.238    22.115     0.200
     7.294    21.095     0.200
     7.623    20.383     0.200
     7.841    22.542     0.200
     8.079    23.046     0.200
     8.362    23.845     0.200
     8.376    23.446     0.200
     8.401    23.517     0.200
     8.236    26.574     0.200
     8.832    23.829     0.200
     8.854    24.607     0.200
     8.855    24.041     0.200
     8.855    25.138     0.200
     8.996    23.659     0.200
     9.301    24.618     0.200
     9.607    25.571     0.200
     9.786    25.622     0.200
    10.356    28.087     0.200
    10.621    27.510     0.200
    10.970    28.783     0.200
    11.212    28.493     0.200
    11.409    30.303     0.200
    12.276    31.208     0.200
    13.372    34.324     0.200
    14.219    35.137     0.200
    14.849    34.820     0.200
    15.152    34.652     0.200
    15.164    35.832     0.200
     1.619    10.749     0.200
     1.619    11.077     0.200
     1.765    10.606     0.200
     1.857    10.958     0.200
     1.891    11.289     0.200
     1.892    11.099     0.200
     1.769    11.459     0.200
     1.941    11.285     0.200
     1.822    12.329     0.200
     1.934    12.841     0.200
     2.214    10.960     0.200
     2.214    11.358     0.200
     2.382    13.974     0.200
     2.671    12.728     0.200
     3.191    12.817     0.200
     3.118    15.889     0.200
     3.145    15.866     0.200
     3.148    16.230     0.200
     3.173    16.156     0.200
     3.526    14.119     0.200
     3.479    15.981     0.200
     3.479    15.840     0.200
     3.628    16.513     0.200
     3.861    15.441     0.200
     4.010    15.965     0.200
     4.229    14.942     0.200
     4.229    14.755     0.200
     4.648    15.835     0.200
     4.648    16.210     0.200
     4.487    19.041     0.200
     4.701    16.928     0.200
     4.733    17.161     0.200
     4.757    17.016     0.200
     4.768    17.366     0.200
     4.768    17.530     0.200
     4.764    17.039     0.200
     4.670    18.693     0.200
     4.976    15.771     0.200
     4.976    16.080     0.200
     5.202    18.090     0.200
     5.200    18.059     0.200
     5.244    18.050     0.200
     5.242    18.103     0.200
     5.242    17.830     0.200
     5.084    19.120     0.200
     5.084    18.456     0.200
     5.288    17.714     0.200
     5.288    17.897     0.200
     5.453    18.272     0.200
     5.453    18.421     0.200
     5.592    17.476     0.200
     5.592    17.164     0.200
     5.446    18.235     0.200
     5.626    18.724     0.200
     5.681    18.831     0.200
     5.731    18.050     0.200
     5.731    18.648     0.200
     5.884    18.635     0.200
     5.884    18.854     0.200
     6.067    19.762     0.200
     6.067    20.536     0.200
     6.128    18.987     0.200
     6.128    20.269     0.200
     6.154    19.837     0.200
     6.008    20.175     0.200
     6.008    20.687     0.200
     6.156    18.765     0.200
     6.088    19.165     0.200
     6.088    20.197     0.200
     6.200    19.509     0.200
     6.319    19.356     0.200
     6.319    19.958     0.200
     6.294    19.250     0.200
     6.294    19.883     0.200
     6.561    20.190     0.200
     6.594    20.326     0.200
     6.594    20.846     0.200
     6.656    21.035     0.200
     6.656    21.222     0.200
     6.594    20.422     0.200
     6.594    21.183     0.200
     6.699    20.592     0.200
     6.699    21.791     0.200
     6.842    20.674     0.200
     6.846    21.519     0.200
     6.930    21.103     0.200
     6.930    21.677     0.200
     7.086    22.255     0.200
     7.131    20.772     0.200
     7.131    21.026     0.200
     7.121    21.328     0.200
     7.138    21.651     0.200
     7.138    22.405     0.200
     7.199    20.608     0.200
     7.199    22.064     0.200
     7.248    21.326     0.200
     7.248    22.408     0.200
     7.296    22.097     0.200
     7.360    22.859     0.200
     7.458    23.408     0.200
     7.458    22.728     0.200
     7.490    21.061     0.200
     7.536    21.037     0.200
     7.532    22.672     0.200
     7.747    22.347     0.200
     7.729    22.146     0.200
     7.729    23.806     0.200
     7.817    23.518     0.200
     8.009    22.231     0.200
     8.009    24.032     0.200
     8.083    24.384     0.200
     8.120    24.413     0.200
     8.232    22.053     0.200
     8.266    22.600     0.200
     8.266    23.889     0.200
     8.277    22.950     0.200
     8.277    24.618     0.200
     8.322    23.101     0.200
     8.322    24.242     0.200
     8.399    22.945     0.200
     8.399    24.203     0.200
     8.393    23.193     0.200
     8.393    24.889     0.200
     8.430    22.787     0.200
     8.394    23.604     0.200
     8.394    24.468     0.200
     8.404    24.991     0.200
     8.743    25.964     0.200
     8.743    25.328     0.200
     8.804    24.254     0.200
     8.804    24.692     0.200
     8.799    24.471     0.200
     8.799    25.370     0.200
     8.902    23.832     0.200
     8.902    24.921     0.200
     8.950    23.896     0.200
     8.950    25.380     0.200
     9.051    24.542     0.200
     9.051    25.061     0.200
     9.152    25.110     0.200
     9.168    25.202     0.200
     9.209    24.735     0.200
     9.209    25.801     0.200
     9.404    26.037     0.200
     9.480    24.757     0.200
     9.480    25.765     0.200
     9.491    26.497     0.200
     9.501    25.695     0.200
     9.501    27.027     0.200
     9.561    24.831     0.200
     9.602    27.186     0.200
     9.644    24.982     0.200
     9.666    25.478     0.200
     9.666    25.888     0.200
     9.789    26.743     0.200
     9.843    24.633     0.200
     9.854    27.993     0.200
     9.966    28.052     0.200
     9.994    26.911     0.200
    10.043    25.715     0.200
    10.043    26.106     0.200
     9.952    28.389     0.200
    10.163    26.928     0.200
    10.188    28.278     0.200
    10.246    28.603     0.200
    10.345    27.539     0.200
    10.321    28.022     0.200
    10.357    27.121     0.200
    10.357    28.606     0.200
    10.432    28.223     0.200
    10.443    29.037     0.200
    10.486    26.734     0.200
    10.486    27.581     0.200
    10.466    28.317     0.200
    10.648    29.379     0.200
    10.740    27.239     0.200
    10.740    27.985     0.200
    10.759    29.052     0.200
    10.759    28.442     0.200
    10.738    29.793     0.200
    10.776    29.612     0.200
    10.803    30.372     0.200
    10.866    27.683     0.200
    10.855    30.347     0.200
    10.948    29.499     0.200
    11.021    27.957     0.200
    11.021    29.528     0.200
    11.075    29.428     0.200
    11.025    30.129     0.200
    11.273    29.642     0.200
    11.249    31.041     0.200
    11.311    28.663     0.200
    11.321    29.881     0.200
    11.355    30.111     0.200
    11.346    31.331     0.200
    11.401    30.970     0.200
    11.401    31.228     0.200
    11.465    31.103     0.200
    11.562    30.602     0.200
    11.584    29.611     0.200
    11.676    31.033     0.200
    11.646    30.854     0.200
    11.646    31.006     0.200
    11.802    30.784     0.200
    11.833    27.903     0.200
    11.838    30.851     0.200
    11.838    31.719     0.200
    12.018    30.558     0.200
    11.973    31.829     0.200
    12.067    28.296     0.200
    12.067    31.398     0.200
    12.142    31.432     0.200
    12.140    32.104     0.200
    12.281    32.039     0.200
    12.300    32.781     0.200
    12.355    30.951     0.200
    12.359    31.838     0.200
    12.395    28.563     0.200
    12.395    29.614     0.200
    12.395    28.454     0.200
    12.443    32.644     0.200
    12.486    31.836     0.200
    12.564    32.316     0.200
    12.538    32.886     0.200
    12.610    31.724     0.200
    12.602    33.398     0.200
    12.650    31.578     0.200
    12.650    32.238     0.200
    12.625    33.005     0.200
    12.718    31.433     0.200
    12.723    29.485     0.200
    12.723    31.950     0.200
    12.804    32.484     0.200
    12.884    31.911     0.200
    12.953    32.248     0.200
    12.991    33.439     0.200
    13.005    32.647     0.200
    12.987    33.911     0.200
    12.954    32.488     0.200
    12.954    33.702     0.200
    13.094    34.006     0.200
    13.218    34.601     0.200
    13.207    33.864     0.200
    13.212    34.831     0.200
    13.280    34.833     0.200
    13.281    34.868     0.200
    13.339    33.509     0.200
    13.414    32.829     0.200
    13.414    33.681     0.200
    13.460    34.105     0.200
    13.510    34.171     0.200
    13.654    34.818     0.200
    13.709    35.236     0.200
    13.793    34.735     0.200
    13.837    34.429     0.200
    13.875    34.627     0.200
    13.952    34.839     0.200
    14.003    33.552     0.200
    14.003    34.470     0.200
    13.955    35.786     0.200
    14.017    34.558     0.200
    13.982    36.030     0.200
    14.061    36.359     0.200
    14.084    35.562     0.200
    14.163    36.046     0.200
    14.189    35.737     0.200
    14.189    36.667     0.200
    14.291    36.201     0.200
    14.413    36.145     0.200
    14.399    36.096     0.200
    14.442    35.989     0.200
    14.557    36.628     0.200
    14.556    37.128     0.200
    14.636    36.438     0.200
    14.781    36.934     0.200
    14.768    35.356     0.200
    14.768    37.297     0.200
    14.873    36.959     0.200
    14.930    36.257     0.200
    14.887    37.747     0.200
    14.946    37.820     0.200
    15.004    34.175     0.200
    15.004    37.187     0.200
    15.002    37.704     0.200
    15.020    37.025     0.200
    15.053    37.335     0.200
    15.089    38.173     0.200
    15.222    36.196     0.200
    15.222    37.118     0.200
    15.362    37.089     0.200
    15.367    38.222     0.200
    15.387    38.344     0.200
    15.468    37.468     0.200
    15.509    37.352     0.200
    15.708    37.594     0.200
    15.708    38.043     0.200
    15.824    37.912     0.200
    15.984    38.590     0.200
    16.003    37.991     0.200
    16.041    37.175     0.200
    16.041    38.113     0.200
    16.123    38.329     0.200
    16.123    38.947     0.200
    16.147    38.209     0.200
    16.184    38.531     0.200
    16.202    38.228     0.200
    16.216    38.649     0.200
    16.216    38.856     0.200
    16.239    39.024     0.200
    16.514    39.370     0.200
    16.616    39.435     0.200
    16.721    38.620     0.200
    17.018    39.004     0.200
    17.127    39.397     0.200
    17.149    37.850     0.200
    17.149    39.522     0.200
    17.301    39.349     0.200
    17.497    39.209     0.200
    17.631    39.198     0.200
    17.737    38.020     0.200
    17.737    39.227     0.200
    18.733    40.199     0.200
    19.796    40.401     0.200
     1.282     8.409     0.200
     1.299     8.397     0.200
     1.573     8.746     0.200
     1.594     9.379     0.200
     1.806     8.265     0.200
     2.385    10.490     0.200
     2.382    11.620     0.200
     2.441    10.695     0.200
     2.441    11.187     0.200
     2.688     9.919     0.200
     2.826    12.766     0.200
     3.456    12.518     0.200
     3.535    12.703     0.200
     3.482    13.035     0.200
     3.482    14.011     0.200
     3.654    13.223     0.200
     3.628    14.083     0.200
     3.654    14.354     0.200
     3.731    11.954     0.200
     3.731    12.102     0.200
     3.969    14.234     0.200
     4.040    15.031     0.200
     4.040    15.149     0.200
     4.125    13.876     0.200
     4.118    14.748     0.200
     4.180    13.400     0.200
     4.195    15.016     0.200
     4.330    13.911     0.200
     4.459    14.564     0.200
     4.486    13.085     0.200
     4.481    13.749     0.200
     4.619    14.492     0.200
     4.880    15.621     0.200
     4.900    16.627     0.200
     4.996    14.371     0.200
     4.982    16.372     0.200
     5.006    16.660     0.200
     5.110    14.659     0.200
     5.110    13.315     0.200
     5.110    13.917     0.200
     5.110    14.761     0.200
     5.320    15.840     0.200
     5.341    15.753     0.200
     5.447    15.631     0.200
     5.477    16.656     0.200
     5.583    17.633     0.200
     5.583    17.899     0.200
     5.692    16.860     0.200
     5.751    16.904     0.200
     5.786    17.652     0.200
     5.844    17.591     0.200
     6.014    17.477     0.200
     6.016    18.671     0.200
     6.137    17.376     0.200
     6.161    17.990     0.200
     6.269    18.273     0.200
     6.353    18.583     0.200
     6.321    18.853     0.200
     6.361    18.628     0.200
     6.426    18.845     0.200
     6.625    19.181     0.200
     6.665    18.939     0.200
     6.686    18.555     0.200
     6.746    18.415     0.200
     6.770    18.138     0.200
     6.816    18.791     0.200
     6.838    18.932     0.200
     6.886    19.069     0.200
     6.922    18.778     0.200
     6.955    18.454     0.200
     7.119    19.815     0.200
     7.662    19.776     0.200
     7.657    20.611     0.200
     7.666    20.597     0.200
     7.711    20.757     0.200
     7.718    20.584     0.200
     7.774    21.079     0.200
     7.791    21.259     0.200
     7.809    20.058     0.200
     7.945    21.020     0.200
     8.024    20.990     0.200
     8.031    21.137     0.200
     8.075    21.807     0.200
     8.286    21.809     0.200
     8.323    21.554     0.200
     8.370    22.069     0.200
     8.398    22.718     0.200
     8.509    22.534     0.200
     8.578    21.935     0.200
     8.611    22.522     0.200
     8.717    20.645     0.200
     8.726    22.313     0.200
     8.736    21.976     0.200
     8.759    21.437     0.200
     8.935    23.237     0.200
     8.935    22.877     0.200
     8.934    22.808     0.200
     8.896    24.830     0.200
     8.896    24.627     0.200
     9.041    22.997     0.200
     9.127    24.293     0.200
     9.133    23.054     0.200
     9.173    22.790     0.200
     9.175    23.958     0.200
     9.202    22.241     0.200
     9.207    22.178     0.200
     9.217    24.045     0.200
     9.377    21.488     0.200
     9.571    23.060     0.200
     9.571    24.162     0.200
     9.565    24.148     0.200
     9.610    24.800     0.200
     9.723    23.809     0.200
     9.859    24.085     0.200
     9.877    23.676     0.200
     9.933    25.086     0.200
     9.948    24.645     0.200
     9.951    23.333     0.200
     9.985    26.027     0.200
    10.022    23.772     0.200
     9.966    25.888     0.200
    10.030    23.697     0.200
    10.052    25.705     0.200
    10.020    25.962     0.200
    10.212    25.764     0.200
    10.269    25.487     0.200
    10.263    26.486     0.200
    10.265    26.574     0.200
    10.315    25.293     0.200
    10.384    25.299     0.200
    10.394    25.486     0.200
    10.444    26.384     0.200
    10.477    27.161     0.200
    10.440    27.467     0.200
    10.440    27.014     0.200
    10.507    26.918     0.200
    10.579    25.755     0.200
    10.614    25.577     0.200
    10.632    26.138     0.200
    10.789    25.379     0.200
    10.795    25.170     0.200
    10.791    27.065     0.200
    10.843    26.755     0.200
    10.857    27.921     0.200
    10.883    26.865     0.200
    10.899    26.712     0.200
    10.931    26.346     0.200
    10.988    26.953     0.200
    11.083    26.508     0.200
    11.095    26.813     0.200
    11.141    26.620     0.200
    11.242    28.128     0.200
    11.259    27.291     0.200
    11.282    28.582     0.200
    11.314    28.735     0.200
    11.400    27.428     0.200
    11.526    28.521     0.200
    11.556    29.287     0.200
    11.565    28.340     0.200
    11.578    28.220     0.200
    11.602    28.065     0.200
    11.586    29.263     0.200
    11.663    27.891     0.200
    11.683    27.963     0.200
    11.685    28.031     0.200
    11.706    28.212     0.200
    11.706    28.616     0.200
    11.726    29.454     0.200
    11.726    28.806     0.200
    11.775    28.621     0.200
    11.793    29.020     0.200
    11.835    29.539     0.200
    11.835    28.437     0.200
    11.857    28.211     0.200
    11.862    28.098     0.200
    11.914    28.421     0.200
    12.004    27.658     0.200
    12.004    25.158     0.200
    12.055    28.280     0.200
    12.102    29.157     0.200
    12.117    28.257     0.200
    12.124    28.197     0.200
    12.137    28.397     0.200
    12.154    29.317     0.200
    12.211    30.104     0.200
    12.245    29.630     0.200
    12.254    29.680     0.200
    12.297    28.794     0.200
    12.312    28.116     0.200
    12.501    29.792     0.200
    12.519    29.041     0.200
    12.544    29.852     0.200
    12.622    30.528     0.200
    12.725    30.737     0.200
    12.763    31.279     0.200
    12.787    30.147     0.200
    12.857    32.543     0.200
    12.926    31.423     0.200
    12.950    30.095     0.200
    12.949    30.524     0.200
    12.962    31.428     0.200
    12.979    31.235     0.200
    12.944    32.231     0.200
    13.385    31.854     0.200
    13.387    32.127     0.200
    13.438    31.146     0.200
    13.469    29.938     0.200
    13.499    31.723     0.200
    13.775    31.640     0.200
    13.852    34.566     0.200
    13.862    33.598     0.200
    13.965    34.033     0.200
    13.963    32.167     0.200
    13.996    34.245     0.200
    14.005    33.650     0.200
    14.035    32.684     0.200
    14.059    33.990     0.200
    14.056    34.767     0.200
    14.136    34.397     0.200
    14.139    34.900     0.200
    14.308    34.131     0.200
    14.369    33.270     0.200
    14.427    34.740     0.200
    14.440    34.678     0.200
    14.563    33.792     0.200
    14.581    33.384     0.200
    14.585    33.967     0.200
    14.606    34.082     0.200
    14.607    35.680     0.200
    14.687    33.594     0.200
    14.778    34.371     0.200
    14.924    34.740     0.200
    14.966    32.249     0.200
    14.969    35.208     0.200
    15.001    34.304     0.200
    15.036    34.459     0.200
    15.075    34.569     0.200
    15.236    34.407     0.200
    15.314    35.641     0.200
    15.505    35.482     0.200
    15.636    35.720     0.200
    15.681    36.115     0.200
    15.895    34.866     0.200
    16.029    35.624     0.200
    16.191    36.989     0.200
    16.708    35.946     0.200
    16.708    36.558     0.200
    16.798    35.320     0.200
    16.821    37.163     0.200
    17.311    36.342     0.200
    18.322    38.031     0.200
     1.222     7.731     0.200
     1.174     6.810     0.200
     1.302     7.984     0.200
     1.369     8.285     0.200
     1.414     7.226     0.200
     1.497     8.838     0.200
     1.497     9.088     0.200
     1.936     7.697     0.200
     1.921     9.051     0.200
     1.970     9.431     0.200
     1.882     9.560     0.200
     1.897     9.675     0.200
     2.016     9.748     0.200
     1.928    10.029     0.200
     2.142     9.949     0.200
     3.002    10.165     0.200
     3.002    10.786     0.200
     2.981    11.647     0.200
     3.014    11.439     0.200
     3.117    11.700     0.200
     3.142    12.008     0.200
     3.201    13.237     0.200
     3.654    13.181     0.200
     3.583    13.718     0.200
     3.780    11.128     0.200
     3.606    13.948     0.200
     3.784    12.724     0.200
     4.161    13.677     0.200
     4.242    13.439     0.200
     4.250    14.092     0.200
     4.423    12.874     0.200
     4.423    12.695     0.200
     4.252    14.411     0.200
     4.252    14.693     0.200
     4.346    13.726     0.200
     4.470    14.564     0.200
     4.364    15.213     0.200
     4.397    14.859     0.200
     4.607    14.967     0.200
     4.720    14.693     0.200
     4.869    14.780     0.200
     4.867    15.228     0.200
     4.742    15.003     0.200
     4.811    15.980     0.200
     5.051    14.494     0.200
     5.299    16.033     0.200
     5.312    16.585     0.200
     5.350    16.322     0.200
     5.586    16.591     0.200
     5.596    17.865     0.200
     5.698    16.405     0.200
     5.791    16.398     0.200
     5.887    18.034     0.200
     5.889    16.723     0.200
     5.951    17.965     0.200
     5.979    17.471     0.200
     6.124    17.094     0.200
     6.093    18.478     0.200
     6.149    18.059     0.200
     6.142    17.710     0.200
     6.326    18.088     0.200
     6.357    17.305     0.200
     6.395    17.904     0.200
     6.420    16.176     0.200
     6.399    17.654     0.200
     6.439    17.970     0.200
     6.358    18.728     0.200
     6.358    20.920     0.200
     6.528    17.902     0.200
     6.418    18.974     0.200
     6.586    18.539     0.200
     6.554    18.209     0.200
     6.775    19.304     0.200
     6.817    18.687     0.200
     6.852    18.263     0.200
     6.851    18.741     0.200
     6.918    18.700     0.200
     7.175    18.701     0.200
     7.193    18.507     0.200
     7.342    19.267     0.200
     7.414    19.943     0.200
     7.520    19.631     0.200
     7.570    19.737     0.200
     7.565    19.767     0.200
     7.578    19.987     0.200
     7.787    20.265     0.200
     7.740    21.086     0.200
     7.907    20.317     0.200
     7.847    20.938     0.200
     8.054    19.662     0.200
     7.991    21.596     0.200
     8.009    20.459     0.200
     8.096    19.512     0.200
     8.285    21.642     0.200
     8.505    21.011     0.200
     8.561    21.362     0.200
     8.533    22.140     0.200
     8.723    21.073     0.200
     9.123    22.632     0.200
     9.083    23.824     0.200
     9.175    23.433     0.200
     9.252    23.860     0.200
     9.396    22.950     0.200
     9.417    22.996     0.200
     9.415    23.876     0.200
     9.498    23.076     0.200
     9.600    23.670     0.200
     9.573    24.092     0.200
     9.578    24.487     0.200
     9.688    23.325     0.200
     9.707    24.409     0.200
     9.806    23.575     0.200
     9.670    24.758     0.200
     9.670    25.669     0.200
    10.002    24.528     0.200
    10.279    25.126     0.200
    10.541    25.187     0.200
    10.697    26.207     0.200
    10.775    27.027     0.200
    11.038    26.673     0.200
    11.170    24.268     0.200
    11.114    28.023     0.200
    11.249    27.374     0.200
    11.388    26.342     0.200
    11.212    27.291     0.200
    11.212    28.869     0.200
    11.418    28.668     0.200
    11.417    27.283     0.200
    11.375    27.878     0.200
    11.498    26.123     0.200
    11.491    28.185     0.200
    11.722    26.507     0.200
    11.659    28.480     0.200
    11.643    28.878     0.200
    11.776    27.154     0.200
    11.872    27.679     0.200
    11.890    28.111     0.200
    12.553    28.046     0.200
    12.608    29.917     0.200
    13.922    31.581     0.200
    14.014    31.400     0.200
    14.046    32.248     0.200
    14.482    33.792     0.200
    15.592    33.272     0.200
    15.548    34.475     0.200
    16.142    34.143     0.200
    16.666    34.655     0.200
    17.770    36.675     0.200
     0.981     5.869     0.200
     1.102     6.079     0.200
     1.186     6.986     0.200
     1.236     7.345     0.200
     1.230     7.339     0.200
     1.402     6.633     0.200
     1.402     6.488     0.200
     1.310     7.988     0.200
     1.336     7.700     0.200
     1.378     8.097     0.200
     1.575     8.398     0.200
     1.574     8.190     0.200
     1.888     8.656     0.200
     1.985     8.956     0.200
     2.364     8.728     0.200
     2.364     8.548     0.200
     2.242    10.351     0.200
     2.242    10.472     0.200
     2.453    11.325     0.200
     2.745    11.085     0.200
     2.745     9.658     0.200
     2.659    11.506     0.200
     3.052    11.715     0.200
     3.130    11.222     0.200
     3.132    11.445     0.200
     3.049    12.403     0.200
     3.198    11.706     0.200
     3.250    11.812     0.200
     3.297    11.415     0.200
     3.380    10.894     0.200
     3.790    13.008     0.200
     3.790    11.674     0.200
     3.795    12.026     0.200
     3.797    12.581     0.200
     3.696    14.277     0.200
     3.739    14.521     0.200
     3.739    14.301     0.200
     3.769    14.066     0.200
     3.922    13.020     0.200
     3.926    13.019     0.200
     3.960    12.667     0.200
     3.988    13.692     0.200
     3.988    13.862     0.200
     3.879    14.141     0.200
     4.072    13.796     0.200
     4.074    13.606     0.200
     4.074    13.298     0.200
     4.118    11.974     0.200
     4.118    11.773     0.200
     4.133    13.794     0.200
     4.133    12.958     0.200
     4.310    14.011     0.200
     4.310    13.323     0.200
     4.378    13.909     0.200
     4.377    13.893     0.200
     4.238    14.678     0.200
     4.238    14.799     0.200
     4.298    15.048     0.200
     4.480    13.605     0.200
     4.387    15.099     0.200
     4.616    14.875     0.200
     4.732    13.105     0.200
     4.732    12.000     0.200
     4.732    12.932     0.200
     4.911    14.770     0.200
     4.938    14.464     0.200
     5.045    15.330     0.200
     5.045    15.068     0.200
     5.014    15.151     0.200
     5.014    14.976     0.200
     5.134    15.984     0.200
     5.299    14.919     0.200
     5.348    16.255     0.200
     5.260    16.825     0.200
     5.441    16.555     0.200
     5.441    16.725     0.200
     5.443    16.625     0.200
     5.448    16.824     0.200
     5.476    16.438     0.200
     5.449    17.325     0.200
     5.628    16.774     0.200
     5.628    16.214     0.200
     5.686    16.821     0.200
     5.734    17.015     0.200
     5.744    17.012     0.200
     5.865    16.865     0.200
     5.865    17.025     0.200
     5.865    16.550     0.200
     5.854    16.500     0.200
     5.965    17.473     0.200
     5.991    17.311     0.200
     5.991    17.770     0.200
     5.991    18.162     0.200
     6.022    17.645     0.200
     6.025    17.654     0.200
     6.261    17.930     0.200
     6.261    17.813     0.200
     6.287    19.695     0.200
     6.287    17.533     0.200
     6.350    17.042     0.200
     6.368    18.403     0.200
     6.368    18.284     0.200
     6.351    19.102     0.200
     6.351    18.426     0.200
     6.458    18.313     0.200
     6.420    18.507     0.200
     6.420    18.017     0.200
     6.482    17.838     0.200
     6.517    18.613     0.200
     6.517    19.074     0.200
     6.519    18.436     0.200
     6.519    19.017     0.200
     6.516    17.934     0.200
     6.612    18.773     0.200
     6.612    19.193     0.200
     6.641    16.829     0.200
     6.673    18.334     0.200
     6.673    18.105     0.200
     6.715    17.864     0.200
     6.718    17.886     0.200
     6.743    18.974     0.200
     6.743    19.366     0.200
     7.128    18.913     0.200
     7.239    20.577     0.200
     7.243    18.444     0.200
     7.278    19.528     0.200
     7.279    19.287     0.200
     7.279    19.678     0.200
     7.279    19.516     0.200
     7.282    20.590     0.200
     7.283    20.522     0.200
     7.306    20.253     0.200
     7.336    20.180     0.200
     7.332    20.448     0.200
     7.376    20.215     0.200
     7.391    19.829     0.200
     7.405    20.338     0.200
     7.414    19.188     0.200
     7.395    20.470     0.200
     7.395    20.181     0.200
     7.554    20.616     0.200
     7.551    20.733     0.200
     7.622    20.937     0.200
     7.622    20.499     0.200
     7.627    19.957     0.200
     7.709    20.865     0.200
     7.919    20.221     0.200
     7.968    20.649     0.200
     7.968    20.856     0.200
     8.001    21.502     0.200
     8.001    21.219     0.200
     7.988    20.924     0.200
     7.988    21.395     0.200
     8.105    21.654     0.200
     8.105    21.418     0.200
     8.192    20.949     0.200
     8.271    21.668     0.200
     8.320    21.256     0.200
     8.332    21.126     0.200
     8.369    21.638     0.200
     8.532    21.637     0.200
     8.532    21.756     0.200
     8.532    21.520     0.200
     8.557    22.164     0.200
     8.557    22.662     0.200
     8.640    21.175     0.200
     8.726    23.462     0.200
     8.726    23.339     0.200
     8.731    21.794     0.200
     8.782    22.188     0.200
     8.782    22.774     0.200
     8.797    22.315     0.200
     8.797    22.020     0.200
     8.813    21.699     0.200
     8.813    21.173     0.200
     8.877    23.050     0.200
     8.877    23.439     0.200
     8.987    21.356     0.200
     9.155    22.992     0.200
     9.184    22.648     0.200
     9.184    22.172     0.200
     9.182    22.502     0.200
     9.182    23.633     0.200
     9.163    24.012     0.200
     9.163    24.602     0.200
     9.323    23.218     0.200
     9.485    23.358     0.200
     9.485    23.014     0.200
     9.485    22.316     0.200
     9.543    24.440     0.200
     9.543    25.253     0.200
     9.570    23.519     0.200
     9.578    24.143     0.200
     9.578    24.553     0.200
     9.583    23.505     0.200
     9.630    22.015     0.200
     9.635    23.596     0.200
     9.649    23.391     0.200
     9.699    22.897     0.200
     9.699    22.514     0.200
     9.706    24.237     0.200
     9.811    24.415     0.200
     9.811    24.766     0.200
     9.882    23.878     0.200
     9.882    23.345     0.200
     9.916    23.733     0.200
     9.914    24.710     0.200
     9.914    24.868     0.200
    10.006    23.773     0.200
    10.043    25.273     0.200
    10.043    25.041     0.200
    10.091    25.459     0.200
    10.146    25.804     0.200
    10.175    23.459     0.200
    10.221    24.804     0.200
    10.228    24.201     0.200
    10.216    25.256     0.200
    10.433    24.378     0.200
    10.477    24.824     0.200
    10.463    26.074     0.200
    10.497    25.552     0.200
    10.493    26.612     0.200
    10.551    25.463     0.200
    10.615    26.764     0.200
    10.726    25.569     0.200
    10.727    24.814     0.200
    10.718    26.528     0.200
    10.693    27.121     0.200
    10.754    25.834     0.200
    10.821    26.844     0.200
    10.697    28.027     0.200
    10.697    28.595     0.200
    10.697    29.556     0.200
    10.887    26.672     0.200
    10.884    26.988     0.200
    10.901    26.176     0.200
    10.915    26.511     0.200
    10.974    27.316     0.200
    10.971    27.389     0.200
    10.974    28.324     0.200
    11.136    27.809     0.200
    11.198    26.991     0.200
    11.198    27.397     0.200
    11.290    27.097     0.200
    11.302    26.768     0.200
    11.302    27.275     0.200
    11.305    26.734     0.200
    11.312    28.536     0.200
    11.431    28.178     0.200
    11.431    27.229     0.200
    11.454    27.331     0.200
    11.498    27.007     0.200
    11.515    27.500     0.200
    11.579    27.620     0.200
    11.600    24.999     0.200
    11.583    27.767     0.200
    11.653    27.992     0.200
    11.710    26.995     0.200
    11.733    28.454     0.200
    11.733    27.833     0.200
    11.750    27.815     0.200
    11.797    27.154     0.200
    11.855    26.934     0.200
    11.848    28.620     0.200
    11.860    29.076     0.200
    11.895    26.970     0.200
    11.908    26.206     0.200
    12.025    28.440     0.200
    12.104    27.823     0.200
    12.123    28.190     0.200
    12.116    28.751     0.200
    12.171    29.935     0.200
    12.221    28.351     0.200
    12.362    28.937     0.200
    12.384    27.962     0.200
    12.418    31.770     0.200
    12.418    29.424     0.200
    12.492    30.206     0.200
    12.510    29.903     0.200
    12.546    29.347     0.200
    12.543    30.419     0.200
    12.554    29.775     0.200
    12.577    28.333     0.200
    12.610    29.500     0.200
    12.651    29.119     0.200
    12.994    29.650     0.200
    13.038    30.107     0.200
    13.058    29.774     0.200
    13.065    29.481     0.200
    13.159    30.009     0.200
    13.177    29.488     0.200
    13.266    30.446     0.200
    13.187    31.883     0.200
    13.340    32.087     0.200
    13.400    30.086     0.200
    13.567    30.953     0.200
    13.586    31.373     0.200
    13.658    30.638     0.200
    13.658    30.103     0.200
    13.661    31.647     0.200
    13.670    31.249     0.200
    13.662    34.941     0.200
    13.662    32.751     0.200
    13.679    32.018     0.200
    13.739    31.883     0.200
    13.773    33.435     0.200
    13.789    32.411     0.200
    13.846    32.302     0.200
    13.923    31.948     0.200
    14.007    31.995     0.200
    14.046    32.573     0.200
    14.101    31.177     0.200
    14.100    32.048     0.200
    14.100    33.378     0.200
    14.168    32.562     0.200
    14.176    32.092     0.200
    14.181    32.563     0.200
    14.192    32.296     0.200
    14.208    32.457     0.200
    14.223    32.417     0.200
    14.226    32.883     0.200
    14.285    33.665     0.200
    14.317    34.200     0.200
    14.387    32.927     0.200
    14.397    35.123     0.200
    14.538    34.371     0.200
    14.562    32.898     0.200
    14.599    34.364     0.200
    14.622    33.277     0.200
    14.637    34.664     0.200
    14.674    34.182     0.200
    14.707    34.059     0.200
    14.787    34.518     0.200
    14.848    33.677     0.200
    14.948    33.273     0.200
    14.976    34.536     0.200
    14.968    34.971     0.200
    15.039    34.731     0.200
    15.039    33.906     0.200
    15.046    34.618     0.200
    15.151    33.678     0.200
    15.160    33.889     0.200
    15.186    34.112     0.200
    15.281    34.599     0.200
    15.308    33.213     0.200
    15.342    33.323     0.200
    15.367    34.248     0.200
    15.515    33.988     0.200
    15.591    34.530     0.200
    15.580    34.470     0.200
    15.624    34.178     0.200
    15.698    34.185     0.200
    15.788    35.183     0.200
    15.677    34.495     0.200
    15.897    35.212     0.200
    15.910    35.634     0.200
    16.001    36.349     0.200
    16.246    34.068     0.200
    16.268    36.573     0.200
    16.304    34.547     0.200
    16.308    35.266     0.200
    16.363    35.670     0.200
    16.417    36.101     0.200
    16.433    35.163     0.200
    16.469    36.607     0.200
    16.469    35.402     0.200
    16.547    36.457     0.200
    16.700    35.380     0.200
    16.697    35.876     0.200
    16.815    36.503     0.200
    16.908    35.723     0.200
    17.141    36.409     0.200
    17.363    34.847     0.200
    17.535    36.459     0.200
    17.918    35.802     0.200
    17.918    36.039     0.200
    18.491    38.202     0.200
    18.781    39.411     0.200
    18.781    37.536     0.200
    18.959    38.981     0.200
    19.516    37.174     0.200
     1.176     9.102     0.200
     1.146     8.492     0.200
     1.146     8.671     0.200
     1.292     9.913     0.200
     1.894     9.870     0.200
     1.894    10.649     0.200
     2.053    11.209     0.200
     1.889    12.383     0.200
     2.867    14.137     0.200
     2.867    14.448     0.200
     2.911    15.924     0.200
     3.008    14.435     0.200
     3.016    14.511     0.200
     3.036    14.521     0.200
     3.342    12.580     0.200
     3.379    15.125     0.200
     3.478    15.409     0.200
     3.719    14.388     0.200
     3.531    15.573     0.200
     3.605    15.853     0.200
     4.880    16.648     0.200
     4.885    17.249     0.200
     4.947    16.753     0.200
     4.947    16.640     0.200
     4.937    17.327     0.200
     4.960    16.145     0.200
     5.144    16.030     0.200
     5.261    16.838     0.200
     5.480    18.373     0.200
     5.623    18.628     0.200
     5.765    17.099     0.200
     5.863    19.052     0.200
     6.072    18.450     0.200
     6.033    19.639     0.200
     6.255    19.466     0.200
     6.255    20.526     0.200
     6.246    20.684     0.200
     6.337    18.944     0.200
     6.378    19.344     0.200
     6.378    19.713     0.200
     6.463    20.097     0.200
     6.725    21.083     0.200
     6.850    21.414     0.200
     7.096    21.564     0.200
     7.311    21.610     0.200
     7.373    21.444     0.200
     7.651    21.854     0.200
     7.675    20.629     0.200
     7.991    23.518     0.200
     8.200    22.798     0.200
     8.306    23.459     0.200
     8.450    23.123     0.200
     8.471    22.861     0.200
     8.508    23.361     0.200
     8.587    27.367     0.200
     8.993    25.886     0.200
     8.977    25.597     0.200
     9.095    25.463     0.200
     9.229    24.680     0.200
     9.354    25.217     0.200
     9.554    25.281     0.200
     9.582    26.025     0.200
     9.668    25.803     0.200
     9.823    25.450     0.200
     9.850    24.988     0.200
     9.979    26.004     0.200
    10.024    25.135     0.200
    10.045    27.856     0.200
    10.221    25.478     0.200
    10.351    26.283     0.200
    10.516    27.168     0.200
    10.522    26.749     0.200
    10.605    26.529     0.200
    10.626    26.784     0.200
    10.670    27.320     0.200
    10.919    27.697     0.200
    10.946    28.035     0.200
    11.257    30.271     0.200
    11.491    28.811     0.200
    11.534    29.301     0.200
    11.585    29.581     0.200
    11.751    29.119     0.200
    12.056    30.160     0.200
    12.223    32.471     0.200
    12.326    31.981     0.200
    12.589    28.382     0.200
    12.781    32.258     0.200
    12.910    31.502     0.200
    13.384    34.219     0.200
    13.620    34.985     0.200
    14.196    34.390     0.200
    14.482    36.823     0.200
    15.194    36.836     0.200
    15.195    34.081     0.200
    15.244    37.030     0.200
    15.281    37.231     0.200
    15.413    37.181     0.200
    15.581    37.256     0.200
    15.863    36.912     0.200
    15.934    37.086     0.200
    16.009    37.534     0.200
    16.232    37.270     0.200
    16.299    38.225     0.200
    16.311    37.508     0.200
    16.393    37.052     0.200
    16.564    38.393     0.200
    16.616    38.468     0.200
    16.706    37.448     0.200
    16.807    37.638     0.200
    17.318    37.068     0.200
    17.337    37.974     0.200
    17.449    38.961     0.200
    17.690    37.559     0.200
    17.928    37.417     0.200
    19.592    40.154     0.200
     1.056     8.430     0.200
     1.056     8.610     0.200
     1.097     8.883     0.200
     1.098     8.759     0.200
     1.120     8.922     0.200
     1.133     9.181     0.200
     1.231     9.862     0.200
     1.281     9.337     0.200
     1.394     8.427     0.200
     1.464     9.021     0.200
     1.404    10.156     0.200
     1.916    11.724     0.200
     2.201    10.971     0.200
     2.277    11.145     0.200
     2.277    11.317     0.200
     2.357    11.304     0.200
     2.357    11.578     0.200
     2.735    11.328     0.200
     2.711    13.169     0.200
     3.059    13.313     0.200
     3.476    14.250     0.200
     3.386    15.183     0.200
     3.529    14.381     0.200
     3.757    13.245     0.200
     3.881    15.978     0.200
     4.331    15.389     0.200
     4.450    16.165     0.200
     4.495    14.173     0.200
     4.870    15.385     0.200
     5.107    15.661     0.200
     5.149    16.675     0.200
     5.188    17.209     0.200
     5.261    16.643     0.200
     5.323    16.978     0.200
     5.398    17.898     0.200
     5.667    17.377     0.200
     5.675    18.452     0.200
     5.835    19.100     0.200
     5.860    18.774     0.200
     5.893    18.455     0.200
     5.991    18.657     0.200
     6.210    19.258     0.200
     6.255    19.790     0.200
     6.362    19.404     0.200
     6.434    20.092     0.200
     6.644    20.540     0.200
     6.642    20.361     0.200
     6.678    20.895     0.200
     6.709    20.143     0.200
     6.879    19.695     0.200
     7.002    19.431     0.200
     7.357    20.905     0.200
     7.484    20.707     0.200
     7.639    19.753     0.200
     7.671    21.170     0.200
     7.746    20.752     0.200
     7.778    21.742     0.200
     7.837    21.156     0.200
     7.933    20.985     0.200
     7.935    21.775     0.200
     7.957    21.013     0.200
     8.112    22.169     0.200
     8.258    22.941     0.200
     8.319    22.234     0.200
     8.431    22.108     0.200
     8.454    22.907     0.200
     8.579    23.841     0.200
     8.680    23.356     0.200
     9.034    25.497     0.200
     9.078    23.889     0.200
     9.155    24.562     0.200
     9.677    25.603     0.200
     9.967    24.981     0.200
     9.998    24.819     0.200
    10.788    26.101     0.200
    10.867    26.855     0.200
     1.422     9.987     0.200
     1.672     9.979     0.200
     1.634    10.107     0.200
     1.831    10.345     0.200
     1.893    10.973     0.200
     3.021    12.616     0.200
     3.164    12.026     0.200
     3.169    13.765     0.200
     3.498    13.020     0.200
     3.502    14.643     0.200
     3.930    15.265     0.200
     4.677    16.633     0.200
     4.728    15.851     0.200
     4.741    16.170     0.200
     4.947    15.497     0.200
     5.262    16.768     0.200
     5.563    16.869     0.200
     5.659    18.191     0.200
     5.855    18.687     0.200
     6.072    19.355     0.200
     6.099    19.609     0.200
     6.127    20.227     0.200
     6.274    19.249     0.200
     6.292    19.497     0.200
     6.570    20.190     0.200
     6.583    20.975     0.200
     6.672    21.002     0.200
     6.912    20.459     0.200
     7.095    21.026     0.200
     7.110    22.039     0.200
     7.225    21.899     0.200
     7.268    22.632     0.200
     7.431    22.777     0.200
     7.713    23.699     0.200
     7.797    22.975     0.200
     7.983    23.451     0.200
     8.085    23.569     0.200
     8.203    24.620     0.200
     8.237    23.602     0.200
     8.250    24.236     0.200
     8.298    23.853     0.200
     8.366    24.249     0.200
     8.376    23.709     0.200
     8.401    24.816     0.200
     8.708    24.377     0.200
     8.778    24.246     0.200
     8.873    25.659     0.200
     8.927    24.657     0.200
     9.139    24.130     0.200
     9.184    25.065     0.200
     9.464    26.715     0.200
     9.532    25.701     0.200
     9.573    25.461     0.200
     9.614    25.596     0.200
     9.637    25.136     0.200
     9.813    24.799     0.200
     9.829    26.485     0.200
    10.134    26.108     0.200
    10.220    26.682     0.200
    10.340    27.696     0.200
    10.457    27.509     0.200
    10.715    28.888     0.200
    10.711    28.154     0.200
    10.729    28.045     0.200
    10.928    29.335     0.200
    11.045    29.320     0.200
    11.225    30.266     0.200
    11.281    28.840     0.200
    11.382    30.387     0.200
    11.533    29.875     0.200
    11.631    31.278     0.200
    11.812    30.129     0.200
    11.976    31.417     0.200
    12.112    31.453     0.200
    12.273    32.982     0.200
    12.367    30.874     0.200
    12.513    33.585     0.200
    12.581    32.651     0.200
    13.178    30.178     0.200
    13.976    33.503     0.200
    14.266    37.769     0.200
    14.383    35.646     0.200
    15.063    38.153     0.200
    15.955    38.974     0.200
    16.192    38.725     0.200
    16.486    38.448     0.200
    17.098    37.496     0.200
    17.120    37.479     0.200
    17.602    38.737     0.200
    17.708    38.733     0.200
     1.202     7.706     0.200
     1.202     7.595     0.200
     1.544     7.520     0.200
     1.516     7.929     0.200
     1.527     7.822     0.200
     1.673     9.582     0.200
     1.722     9.679     0.200
     1.769     9.888     0.200
     1.912     8.398     0.200
     1.912     8.709     0.200
     1.789    10.251     0.200
     1.808    10.091     0.200
     1.893    10.333     0.200
     2.100     8.935     0.200
     2.100     8.714     0.200
     2.114     9.359     0.200
     2.106    10.701     0.200
     2.758    10.200     0.200
     2.771    10.341     0.200
     2.825    10.310     0.200
     2.825    11.351     0.200
     2.791    10.750     0.200
     2.846    10.360     0.200
     2.867    10.257     0.200
     2.786    12.106     0.200
     2.786    13.917     0.200
     2.870    10.884     0.200
     3.009    10.915     0.200
     2.975    12.500     0.200
     3.171    11.413     0.200
     3.121    11.820     0.200
     3.244    11.751     0.200
     3.283    11.525     0.200
     3.344    11.905     0.200
     3.403    11.933     0.200
     3.403    11.714     0.200
     3.330    11.506     0.200
     3.637    12.774     0.200
     3.923    13.392     0.200
     3.923    13.007     0.200
     3.826    13.594     0.200
     3.874    13.396     0.200
     3.984    13.629     0.200
     4.134    13.723     0.200
     4.163    13.692     0.200
     4.163    14.781     0.200
     4.346    13.927     0.200
     4.440    14.624     0.200
     4.440    15.165     0.200
     4.668    14.483     0.200
     4.626    16.026     0.200
     4.704    14.383     0.200
     4.708    15.164     0.200
     4.894    15.151     0.200
     4.894    15.680     0.200
     4.955    15.212     0.200
     4.851    17.614     0.200
     5.140    16.139     0.200
     5.141    16.063     0.200
     5.172    15.842     0.200
     5.339    16.600     0.200
     5.331    16.469     0.200
     5.367    16.522     0.200
     5.386    16.617     0.200
     5.331    16.455     0.200
     5.397    16.049     0.200
     5.471    16.148     0.200
     5.471    17.187     0.200
     5.485    15.918     0.200
     5.485    16.178     0.200
     5.466    17.615     0.200
     5.842    16.447     0.200
     6.054    18.170     0.200
     6.060    18.144     0.200
     6.051    17.031     0.200
     6.087    17.983     0.200
     6.123    18.020     0.200
     6.093    18.466     0.200
     6.286    17.950     0.200
     6.267    19.213     0.200
     6.396    19.134     0.200
     6.449    18.987     0.200
     6.424    18.032     0.200
     6.915    20.290     0.200
     7.008    19.296     0.200
     7.493    21.652     0.200
     7.565    22.175     0.200
     7.614    21.027     0.200
     7.812    20.183     0.200
     7.897    21.258     0.200
     8.245    21.988     0.200
     8.245    20.998     0.200
     8.247    22.163     0.200
     8.267    22.366     0.200
     8.357    23.018     0.200
     8.497    22.656     0.200
     8.463    22.925     0.200
     8.523    22.995     0.200
     8.615    22.751     0.200
     8.719    22.307     0.200
     8.641    23.048     0.200
     9.000    24.032     0.200
     9.124    23.332     0.200
     9.483    23.850     0.200
     9.433    24.754     0.200
     9.549    24.375     0.200
     9.626    25.067     0.200
     9.653    24.344     0.200
     9.697    24.624     0.200
     9.761    26.179     0.200
     9.860    24.687     0.200
     9.928    25.598     0.200
     9.973    24.815     0.200
     9.974    25.568     0.200
     9.901    25.425     0.200
    10.038    25.997     0.200
    11.062    28.188     0.200
    12.202    30.298     0.200
    12.976    30.874     0.200
    13.050    31.133     0.200
    13.056    32.098     0.200
    15.841    36.508     0.200
    16.226    37.496     0.200
    16.758    37.087     0.200
     1.127     7.815     0.200
     1.244     8.619     0.200
     1.260     8.604     0.200
     1.251     8.448     0.200
     1.251     8.702     0.200
     1.308     8.318     0.200
     1.369     9.324     0.200
     1.649     9.065     0.200
     1.657     9.221     0.200
     1.733    10.085     0.200
     1.796     9.910     0.200
     1.822    10.375     0.200
     1.868    10.081     0.200
     1.865    10.607     0.200
     1.865    10.007     0.200
     1.847    10.109     0.200
     2.125     9.328     0.200
     2.050    11.883     0.200
     2.172    12.772     0.200
     2.241    12.343     0.200
     3.008    10.737     0.200
     3.177    14.205     0.200
     3.221    13.743     0.200
     3.320    14.552     0.200
     3.334    14.460     0.200
     3.348    14.286     0.200
     3.370    14.723     0.200
     3.776    13.243     0.200
     3.860    14.018     0.200
     3.697    14.557     0.200
     3.924    13.840     0.200
     3.795    14.760     0.200
     4.016    13.972     0.200
     4.059    13.223     0.200
     3.923    15.003     0.200
     4.453    14.664     0.200
     4.543    14.683     0.200
     4.593    14.966     0.200
     4.653    14.899     0.200
     4.657    15.166     0.200
     4.718    15.221     0.200
     4.722    15.832     0.200
     4.742    15.761     0.200
     4.818    14.138     0.200
     4.820    15.856     0.200
     4.701    16.922     0.200
     4.968    15.289     0.200
     5.138    15.899     0.200
     5.186    16.465     0.200
     5.273    16.474     0.200
     5.443    14.960     0.200
     5.443    14.841     0.200
     5.515    17.526     0.200
     5.592    16.952     0.200
     5.711    18.111     0.200
     5.777    16.548     0.200
     6.063    18.123     0.200
     6.296    17.896     0.200
     6.357    18.203     0.200
     6.605    19.669     0.200
     6.658    19.863     0.200
     7.079    18.762     0.200
     7.001    20.027     0.200
     7.079    20.223     0.200
     7.111    20.452     0.200
     7.209    20.741     0.200
     7.251    20.623     0.200
     7.270    20.592     0.200
     7.371    20.586     0.200
     7.823    22.334     0.200
     7.869    22.568     0.200
     7.995    22.429     0.200
     8.032    22.251     0.200
     8.075    22.835     0.200
     8.240    23.639     0.200
     8.334    24.102     0.200
     8.332    22.775     0.200
     8.838    23.795     0.200
     8.972    24.236     0.200
     9.435    24.715     0.200
     9.468    25.112     0.200
     9.507    23.916     0.200
     9.443    25.160     0.200
     9.842    25.022     0.200
     9.915    25.657     0.200
    10.054    25.240     0.200
    10.192    25.466     0.200
    10.221    27.410     0.200
    10.364    25.550     0.200
    10.498    27.071     0.200
    10.604    27.191     0.200
    10.904    27.171     0.200
    11.178    27.531     0.200
    11.218    28.003     0.200
    11.252    29.431     0.200
    11.427    28.538     0.200
    11.458    28.176     0.200
    11.511    28.913     0.200
    11.487    30.129     0.200
    11.733    28.663     0.200
    12.019    28.965     0.200
    12.013    30.731     0.200
    12.017    30.888     0.200
    12.193    30.426     0.200
    12.185    29.397     0.200
    12.322    26.013     0.200
    12.322    28.304     0.200
    12.436    31.363     0.200
    12.456    30.210     0.200
    12.461    31.524     0.200
    12.524    31.486     0.200
    12.556    31.295     0.200
    12.634    30.480     0.200
    12.808    31.148     0.200
    13.055    31.538     0.200
    13.110    34.430     0.200
    13.202    32.391     0.200
    13.288    32.579     0.200
    13.880    33.021     0.200
    14.231    34.890     0.200
    14.298    33.980     0.200
    14.276    33.310     0.200
    14.642    35.803     0.200
    14.897    36.030     0.200
    14.915    35.626     0.200
    14.907    35.829     0.200
    15.706    37.108     0.200
    15.832    36.822     0.200
    15.883    37.465     0.200
    15.890    37.347     0.200
    16.012    37.931     0.200
    16.029    36.822     0.200
    16.220    38.357     0.200
    16.427    38.126     0.200
    16.519    38.199     0.200
    17.034    38.392     0.200
     1.155     7.695     0.200
     1.155     6.753     0.200
     1.155     7.324     0.200
     1.215     6.992     0.200
     1.225     6.946     0.200
     1.225     7.134     0.200
     1.755     8.791     0.200
     1.755     8.064     0.200
     1.785    10.119     0.200
     1.826    10.094     0.200
     1.871    10.146     0.200
     2.054     8.862     0.200
     1.920    10.217     0.200
     1.951     9.932     0.200
     2.139     9.635     0.200
     2.139    10.123     0.200
     2.201     9.415     0.200
     2.299     9.766     0.200
     2.186    10.643     0.200
     2.612    10.388     0.200
     2.612     9.766     0.200
     2.612     9.997     0.200
     2.799    10.742     0.200
     2.940    10.868     0.200
     2.938    10.313     0.200
     2.938    11.134     0.200
     2.967    11.115     0.200
     2.999    11.309     0.200
     3.096    11.411     0.200
     3.096    11.578     0.200
     3.126    12.151     0.200
     3.253    11.313     0.200
     3.253    11.711     0.200
     3.272    11.576     0.200
     3.212    13.108     0.200
     3.300    12.276     0.200
     3.372    11.309     0.200
     3.372    12.000     0.200
     3.384    12.077     0.200
     3.253    14.084     0.200
     3.425    12.251     0.200
     3.490    12.530     0.200
     3.593    13.089     0.200
     3.593    13.710     0.200
     3.681    12.891     0.200
     3.681    13.129     0.200
     3.846    12.706     0.200
     3.939    12.967     0.200
     3.943    13.174     0.200
     4.065    13.482     0.200
     4.303    14.827     0.200
     4.352    13.802     0.200
     4.352    14.262     0.200
     4.295    14.719     0.200
     4.439    13.738     0.200
     4.439    14.906     0.200
     4.456    13.844     0.200
     4.456    15.063     0.200
     4.398    15.977     0.200
     4.398    16.567     0.200
     4.437    16.885     0.200
     4.437    16.604     0.200
     4.549    14.733     0.200
     4.549    15.143     0.200
     4.673    14.976     0.200
     4.565    16.231     0.200
     4.596    16.393     0.200
     4.867    16.073     0.200
     4.880    15.714     0.200
     4.984    15.648     0.200
     4.984    15.988     0.200
     5.028    15.156     0.200
     5.028    15.706     0.200
     5.094    15.802     0.200
     5.094    16.232     0.200
     4.953    16.863     0.200
     5.100    16.336     0.200
     5.031    16.906     0.200
     5.031    17.976     0.200
     5.118    16.735     0.200
     5.110    16.814     0.200
     5.098    17.107     0.200
     5.098    17.646     0.200
     5.270    15.881     0.200
     5.270    17.041     0.200
     5.315    15.902     0.200
     5.172    17.615     0.200
     5.388    17.301     0.200
     5.373    16.751     0.200
     5.486    17.450     0.200
     5.520    16.613     0.200
     5.554    16.544     0.200
     5.554    17.204     0.200
     5.720    17.277     0.200
     5.720    17.757     0.200
     5.770    17.484     0.200
     5.802    17.365     0.200
     5.802    17.603     0.200
     5.798    17.065     0.200
     5.798    17.526     0.200
     5.932    17.033     0.200
     6.219    18.134     0.200
     6.309    18.255     0.200
     6.387    18.212     0.200
     6.457    17.992     0.200
     6.571    18.981     0.200
     6.535    19.452     0.200
     6.489    20.072     0.200
     6.626    20.694     0.200
     6.747    19.602     0.200
     6.802    19.633     0.200
     6.985    19.356     0.200
     7.107    19.504     0.200
     7.430    20.674     0.200
     7.484    20.240     0.200
     7.545    21.702     0.200
     7.743    20.433     0.200
     7.759    21.241     0.200
     7.804    21.014     0.200
     7.853    20.482     0.200
     7.859    20.386     0.200
     7.970    21.616     0.200
     8.042    20.694     0.200
     8.034    21.936     0.200
     8.254    21.618     0.200
     8.229    22.194     0.200
     8.548    22.829     0.200
     8.587    23.781     0.200
     8.573    23.246     0.200
     8.651    24.768     0.200
     8.675    22.764     0.200
     8.709    22.616     0.200
     8.940    23.102     0.200
     9.048    24.353     0.200
     9.182    23.758     0.200
     9.247    24.062     0.200
     9.512    23.291     0.200
     9.564    24.160     0.200
     9.685    24.949     0.200
     9.767    25.528     0.200
     9.918    25.514     0.200
     9.904    25.649     0.200
     9.926    25.555     0.200
    10.046    24.738     0.200
    10.121    26.240     0.200
    10.304    25.090     0.200
    10.271    26.437     0.200
    10.311    25.151     0.200
    10.360    26.320     0.200
    10.464    27.190     0.200
    10.602    25.945     0.200
    10.599    27.252     0.200
    10.902    28.445     0.200
    10.943    28.515     0.200
    11.156    28.084     0.200
    11.239    29.474     0.200
    11.571    29.753     0.200
    11.589    30.426     0.200
    12.225    30.004     0.200
    12.595    31.000     0.200
    12.737    32.998     0.200
    14.304    34.566     0.200
     1.116     7.331     0.200
     1.148     7.239     0.200
     1.291     6.661     0.200
     1.797     9.246     0.200
     1.861     7.827     0.200
     1.861     8.936     0.200
     1.861     7.626     0.200
     1.965    10.333     0.200
     2.894    11.546     0.200
     2.917    10.205     0.200
     2.917    10.836     0.200
     2.917     9.933     0.200
     3.222    12.554     0.200
     3.575    12.250     0.200
     3.668    12.889     0.200
     3.689    11.404     0.200
     3.689    11.267     0.200
     3.814    12.938     0.200
     3.817    13.050     0.200
     4.038    14.406     0.200
     4.038    13.412     0.200
     4.131    13.202     0.200
     4.228    14.410     0.200
     4.228    14.060     0.200
     4.287    14.815     0.200
     4.287    14.956     0.200
     4.287    14.536     0.200
     4.326    12.530     0.200
     4.326    12.360     0.200
     4.326    12.661     0.200
     4.347    14.242     0.200
     4.347    14.037     0.200
     4.496    15.526     0.200
     4.496    14.711     0.200
     4.597    15.432     0.200
     4.597    14.563     0.200
     4.747    14.663     0.200
     4.782    14.944     0.200
     4.782    16.665     0.200
     4.782    14.485     0.200
     4.836    14.924     0.200
     4.874    15.374     0.200
     5.042    16.314     0.200
     5.178    16.011     0.200
     5.188    17.003     0.200
     5.201    16.255     0.200
     5.232    16.497     0.200
     5.470    16.107     0.200
     5.475    16.957     0.200
     5.575    16.518     0.200
     5.671    16.879     0.200
     5.717    17.429     0.200
     5.806    17.166     0.200
     5.821    17.415     0.200
     5.854    17.833     0.200
     5.856    17.260     0.200
     5.972    16.904     0.200
     5.988    18.172     0.200
     5.999    17.347     0.200
     6.027    18.062     0.200
     6.029    17.564     0.200
     6.205    18.190     0.200
     6.312    16.887     0.200
     6.348    16.907     0.200
     6.431    18.478     0.200
     6.651    18.727     0.200
     6.706    18.518     0.200
     6.731    18.697     0.200
     6.759    20.362     0.200
     6.759    18.813     0.200
     6.855    18.496     0.200
     6.886    20.559     0.200
     6.886    20.390     0.200
     6.886    20.114     0.200
     6.986    19.941     0.200
     7.045    22.562     0.200
     7.053    19.086     0.200
     7.070    17.870     0.200
     7.141    19.774     0.200
     7.233    18.774     0.200
     7.244    20.299     0.200
     7.291    19.859     0.200
     7.442    20.100     0.200
     7.449    21.004     0.200
     7.461    20.286     0.200
     7.633    20.683     0.200
     7.675    21.902     0.200
     7.675    19.742     0.200
     7.725    20.797     0.200
     7.808    19.513     0.200
     7.891    20.155     0.200
     7.963    19.579     0.200
     7.989    19.621     0.200
     8.075    20.750     0.200
     8.173    20.990     0.200
     8.247    21.308     0.200
     8.247    21.207     0.200
     8.247    20.281     0.200
     8.334    20.634     0.200
     8.359    21.639     0.200
     8.411    21.584     0.200
     8.462    20.314     0.200
     8.528    22.298     0.200
     8.543    22.031     0.200
     8.558    22.805     0.200
     8.567    21.491     0.200
     8.662    21.145     0.200
     8.675    22.088     0.200
     8.801    22.041     0.200
     8.801    21.279     0.200
     8.851    21.714     0.200
     8.964    23.404     0.200
     9.014    22.160     0.200
     9.054    23.164     0.200
     9.064    22.582     0.200
     9.128    23.464     0.200
     9.291    22.439     0.200
     9.379    21.940     0.200
     9.425    22.726     0.200
     9.439    24.587     0.200
     9.453    22.977     0.200
     9.455    24.311     0.200
     9.502    22.691     0.200
     9.598    23.413     0.200
     9.709    25.545     0.200
     9.709    24.955     0.200
     9.798    25.245     0.200
     9.826    25.475     0.200
     9.864    24.115     0.200
     9.911    23.139     0.200
     9.976    25.865     0.200
    10.013    23.545     0.200
    10.021    25.622     0.200
    10.030    23.935     0.200
    10.156    24.598     0.200
    10.167    27.003     0.200
    10.167    26.076     0.200
    10.171    26.551     0.200
    10.373    24.756     0.200
    10.373    26.430     0.200
    10.430    24.687     0.200
    10.570    27.052     0.200
    10.578    28.039     0.200
    10.598    27.164     0.200
    10.666    27.260     0.200
    10.704    26.568     0.200
    10.713    23.722     0.200
    10.769    25.426     0.200
    10.916    28.550     0.200
    10.933    26.219     0.200
    10.943    26.231     0.200
    11.006    25.812     0.200
    11.020    28.809     0.200
    11.020    27.979     0.200
    11.043    27.605     0.200
    11.054    26.708     0.200
    11.073    24.579     0.200
    11.134    28.451     0.200
    11.136    24.916     0.200
    11.161    29.103     0.200
    11.166    28.747     0.200
    11.174    25.782     0.200
    11.188    28.340     0.200
    11.193    26.718     0.200
    11.228    28.295     0.200
    11.230    24.398     0.200
    11.230    25.500     0.200
    11.230    23.799     0.200
    11.230    24.178     0.200
    11.230    24.688     0.200
    11.230    24.988     0.200
    11.248    28.288     0.200
    11.248    28.538     0.200
    11.248    26.856     0.200
    11.248    28.797     0.200
    11.252    28.304     0.200
    11.327    27.515     0.200
    11.350    26.676     0.200
    11.381    24.517     0.200
    11.381    24.939     0.200
    11.463    27.879     0.200
    11.526    28.883     0.200
    11.531    24.959     0.200
    11.533    30.354     0.200
    11.533    29.305     0.200
    11.533    28.981     0.200
    11.539    29.482     0.200
    11.610    26.455     0.200
    11.634    28.647     0.200
    11.636    29.979     0.200
    11.661    25.891     0.200
    11.705    26.037     0.200
    11.720    28.650     0.200
    11.767    27.308     0.200
    11.782    28.221     0.200
    11.785    29.172     0.200
    11.794    29.622     0.200
    11.864    30.027     0.200
    11.916    28.185     0.200
    12.044    26.137     0.200
    12.078    29.345     0.200
    12.143    28.659     0.200
    12.150    30.715     0.200
    12.208    31.495     0.200
    12.223    29.991     0.200
    12.240    30.908     0.200
    12.326    26.429     0.200
    12.485    30.970     0.200
    12.487    32.001     0.200
    12.501    32.592     0.200
    12.501    31.252     0.200
    12.581    30.150     0.200
    12.642    30.309     0.200
    12.670    29.452     0.200
    12.670    28.721     0.200
    12.775    29.912     0.200
    12.792    30.268     0.200
    12.810    27.759     0.200
    12.882    29.216     0.200
    12.905    32.601     0.200
    12.967    30.144     0.200
    12.981    30.567     0.200
    13.135    32.367     0.200
    13.135    30.665     0.200
    13.135    30.044     0.200
    13.220    30.645     0.200
    13.228    31.241     0.200
    13.238    32.844     0.200
    13.238    30.655     0.200
    13.242    32.795     0.200
    13.313    32.085     0.200
    13.335    33.369     0.200
    13.532    31.781     0.200
    13.529    33.076     0.200
    13.540    31.660     0.200
    13.583    31.883     0.200
    13.598    31.895     0.200
    13.641    33.040     0.200
    13.669    33.128     0.200
    13.675    33.681     0.200
    13.676    33.459     0.200
    13.743    32.899     0.200
    13.736    33.531     0.200
    13.775    32.639     0.200
    13.777    33.698     0.200
    13.818    32.490     0.200
    13.880    31.904     0.200
    13.891    31.442     0.200
    13.944    29.585     0.200
    14.146    33.403     0.200
    14.149    33.233     0.200
    14.297    33.250     0.200
    14.412    32.366     0.200
    14.437    33.519     0.200
    14.445    33.781     0.200
    14.459    32.800     0.200
    14.495    34.593     0.200
    14.495    33.962     0.200
    14.495    32.933     0.200
    14.495    33.627     0.200
    14.638    34.575     0.200
    14.688    34.585     0.200
    14.745    34.837     0.200
    14.768    33.974     0.200
    14.810    34.546     0.200
    14.810    34.852     0.200
    14.818    35.417     0.200
    14.882    32.058     0.200
    14.961    34.132     0.200
    15.062    34.395     0.200
    15.287    34.680     0.200
    15.367    34.162     0.200
    15.388    35.953     0.200
    15.501    33.279     0.200
    15.519    36.237     0.200
    15.551    34.409     0.200
    15.911    36.875     0.200
    15.951    37.402     0.200
    15.969    37.076     0.200
    15.990    35.311     0.200
    16.029    33.743     0.200
    16.126    34.629     0.200
    16.161    37.240     0.200
    16.244    34.727     0.200
    16.244    36.483     0.200
    16.244    36.083     0.200
    16.244    34.843     0.200
    16.347    37.485     0.200
    16.392    34.773     0.200
    16.552    36.689     0.200
    16.618    34.429     0.200
    17.082    34.506     0.200
    17.656    35.324     0.200
    17.656    34.229     0.200
    19.044    39.282     0.200
     1.034     6.268     0.200
     1.188     5.814     0.200
     1.144     7.245     0.200
     1.231     7.942     0.200
     1.308     7.975     0.200
     1.308     8.334     0.200
     1.694     8.827     0.200
     1.796     7.377     0.200
     1.818     8.323     0.200
     1.924     9.493     0.200
     1.920     9.724     0.200
     2.143    10.132     0.200
     2.842    10.193     0.200
     3.044    13.134     0.200
     3.567    11.665     0.200
     3.607    10.647     0.200
     3.935    12.757     0.200
     4.131    13.364     0.200
     4.241    11.724     0.200
     4.241    12.275     0.200
     4.242    13.698     0.200
     4.407    14.183     0.200
     4.328    15.311     0.200
     4.494    13.487     0.200
     4.469    16.142     0.200
     4.826    15.281     0.200
     5.074    15.133     0.200
     5.111    15.285     0.200
     5.135    15.824     0.200
     5.567    16.085     0.200
     5.672    16.261     0.200
     5.923    16.030     0.200
     5.904    17.414     0.200
     6.139    17.120     0.200
     6.327    17.924     0.200
     6.974    20.327     0.200
     6.869    20.087     0.200
     7.187    18.579     0.200
     7.301    18.958     0.200
     7.337    20.141     0.200
     7.578    21.217     0.200
     7.788    20.766     0.200
     8.149    20.748     0.200
     8.261    21.922     0.200
     8.424    21.989     0.200
     8.531    20.251     0.200
     8.982    23.085     0.200
     9.350    22.600     0.200
     9.350    24.747     0.200
     9.661    23.067     0.200
     9.993    25.260     0.200
    10.026    24.982     0.200
    10.069    25.762     0.200
    10.333    24.842     0.200
    10.494    25.977     0.200
    10.526    25.423     0.200
    10.814    27.053     0.200
    11.075    27.028     0.200
    11.040    28.211     0.200
    11.147    26.639     0.200
    11.279    22.863     0.200
    11.287    30.033     0.200
    11.560    25.877     0.200
    11.689    29.330     0.200
    11.839    29.232     0.200
    12.225    27.457     0.200
    12.688    29.889     0.200
    13.427    33.299     0.200
    13.674    33.633     0.200
    15.868    37.044     0.200
    15.931    35.906     0.200
    17.557    34.780     0.200
     0.353     4.605     0.200
     0.353     3.960     0.200
     0.363     3.995     0.200
     0.653     5.809     0.200
     0.653     6.078     0.200
     0.653     5.969     0.200
     0.917     6.077     0.200
     0.980     5.927     0.200
     1.068     6.719     0.200
     1.129     7.752     0.200
     1.129     7.683     0.200
     1.266     6.286     0.200
     1.266     6.011     0.200
     1.373     7.620     0.200
     1.423     7.428     0.200
     1.524     7.932     0.200
     1.519     8.328     0.200
     2.241     8.465     0.200
     2.241     7.936     0.200
     2.241     7.799     0.200
     2.991    10.996     0.200
     3.249    10.506     0.200
     3.249    10.346     0.200
     3.658    11.854     0.200
     3.787    12.667     0.200
     3.828    12.453     0.200
     3.851    12.884     0.200
     3.851    14.183     0.200
     3.953    13.026     0.200
     3.983    11.346     0.200
     4.032    13.060     0.200
     4.227    13.716     0.200
     4.227    13.107     0.200
     4.238    13.366     0.200
     4.349    13.752     0.200
     4.349    13.611     0.200
     4.354    14.519     0.200
     4.498    14.005     0.200
     4.498    13.659     0.200
     4.595    12.073     0.200
     4.595    12.704     0.200
     4.595    12.450     0.200
     4.785    14.481     0.200
     4.802    14.634     0.200
     4.932    15.177     0.200
     5.034    15.603     0.200
     5.034    15.474     0.200
     5.214    15.534     0.200
     5.214    15.268     0.200
     5.337    15.501     0.200
     5.506    15.792     0.200
     5.506    15.673     0.200
     5.591    16.150     0.200
     5.595    16.551     0.200
     5.676    17.265     0.200
     5.730    16.794     0.200
     5.770    16.593     0.200
     5.837    16.704     0.200
     5.881    17.192     0.200
     5.881    17.041     0.200
     5.883    16.735     0.200
     6.122    17.417     0.200
     6.147    18.017     0.200
     6.209    16.870     0.200
     6.235    18.185     0.200
     6.340    18.000     0.200
     6.378    17.933     0.200
     6.394    18.471     0.200
     6.436    17.943     0.200
     6.545    17.489     0.200
     6.568    17.905     0.200
     6.616    18.557     0.200
     6.627    17.358     0.200
     6.626    20.806     0.200
     7.016    18.810     0.200
     7.120    18.936     0.200
     7.142    19.138     0.200
     7.215    19.080     0.200
     7.239    19.570     0.200
     7.274    18.312     0.200
     7.326    19.953     0.200
     7.414    19.741     0.200
     7.423    19.885     0.200
     7.488    20.984     0.200
     7.597    20.138     0.200
     7.829    20.054     0.200
     7.907    20.415     0.200
     7.969    19.732     0.200
     8.053    19.619     0.200
     8.171    20.910     0.200
     8.180    20.170     0.200
     8.194    20.152     0.200
     8.248    19.242     0.200
     8.261    20.505     0.200
     8.393    19.978     0.200
     8.393    19.318     0.200
     8.439    21.041     0.200
     8.500    20.442     0.200
     8.593    22.971     0.200
     8.621    20.940     0.200
     8.654    21.470     0.200
     8.660    20.579     0.200
     8.673    20.900     0.200
     8.777    22.307     0.200
     8.815    20.003     0.200
     9.015    20.917     0.200
     9.045    21.465     0.200
     9.045    21.274     0.200
     9.061    23.387     0.200
     9.078    23.356     0.200
     9.183    22.165     0.200
     9.275    24.484     0.200
     9.348    22.773     0.200
     9.418    23.235     0.200
     9.432    22.066     0.200
     9.448    23.904     0.200
     9.492    21.325     0.200
     9.495    22.705     0.200
     9.514    22.490     0.200
     9.560    21.003     0.200
     9.612    24.473     0.200
     9.696    24.105     0.200
     9.743    22.576     0.200
     9.743    22.734     0.200
     9.776    22.815     0.200
     9.810    24.824     0.200
     9.895    24.947     0.200
     9.895    24.635     0.200
     9.968    24.832     0.200
    10.036    22.189     0.200
    10.036    25.069     0.200
    10.081    23.495     0.200
    10.092    22.603     0.200
    10.130    24.804     0.200
    10.295    23.954     0.200
    10.337    25.140     0.200
    10.358    24.149     0.200
    10.392    25.874     0.200
    10.368    27.543     0.200
    10.499    25.723     0.200
    10.587    24.441     0.200
    10.597    25.951     0.200
    10.615    25.408     0.200
    10.648    26.709     0.200
    10.648    25.713     0.200
    10.693    26.254     0.200
    10.767    23.330     0.200
    10.775    26.327     0.200
    10.784    24.959     0.200
    10.806    27.511     0.200
    10.806    27.312     0.200
    10.889    27.251     0.200
    10.893    26.983     0.200
    11.010    26.631     0.200
    11.059    25.553     0.200
    11.075    26.957     0.200
    11.150    26.538     0.200
    11.165    23.155     0.200
    11.172    24.743     0.200
    11.187    27.072     0.200
    11.198    27.113     0.200
    11.240    28.156     0.200
    11.240    28.052     0.200
    11.296    24.901     0.200
    11.296    26.299     0.200
    11.296    25.381     0.200
    11.296    23.811     0.200
    11.315    25.548     0.200
    11.354    27.740     0.200
    11.354    27.850     0.200
    11.363    26.231     0.200
    11.363    26.809     0.200
    11.375    26.959     0.200
    11.451    27.690     0.200
    11.478    27.990     0.200
    11.491    27.421     0.200
    11.570    27.072     0.200
    11.598    25.142     0.200
    11.613    27.310     0.200
    11.724    26.052     0.200
    11.737    28.581     0.200
    11.738    28.096     0.200
    11.755    25.528     0.200
    11.770    24.770     0.200
    11.886    27.803     0.200
    11.964    27.250     0.200
    11.982    26.928     0.200
    11.993    28.317     0.200
    12.010    28.216     0.200
    12.018    29.526     0.200
    12.055    29.224     0.200
    12.087    25.702     0.200
    12.227    28.563     0.200
    12.316    30.723     0.200
    12.352    28.019     0.200
    12.380    30.795     0.200
    12.422    30.282     0.200
    12.425    29.458     0.200
    12.425    27.826     0.200
    12.477    28.778     0.200
    12.515    29.129     0.200
    12.518    29.937     0.200
    12.701    30.826     0.200
    12.846    30.525     0.200
    12.880    29.047     0.200
    12.964    29.918     0.200
    13.020    29.720     0.200
    13.043    32.699     0.200
    13.052    29.080     0.200
    13.134    30.375     0.200
    13.226    32.398     0.200
    13.263    29.886     0.200
    13.338    31.715     0.200
    13.292    31.271     0.200
    13.394    31.585     0.200
    13.427    29.820     0.200
    13.427    30.109     0.200
    13.447    33.044     0.200
    13.447    30.523     0.200
    13.476    33.584     0.200
    13.535    30.768     0.200
    13.561    31.671     0.200
    13.561    32.592     0.200
    13.538    30.334     0.200
    13.538    31.133     0.200
    13.538    29.299     0.200
    13.660    31.201     0.200
    13.658    31.835     0.200
    13.658    31.501     0.200
    13.784    31.318     0.200
    13.871    31.367     0.200
    13.934    30.683     0.200
    13.995    31.955     0.200
    13.974    32.159     0.200
    14.028    30.952     0.200
    14.037    28.937     0.200
    14.054    28.983     0.200
    14.045    33.016     0.200
    14.068    30.902     0.200
    14.089    31.708     0.200
    14.202    32.115     0.200
    14.262    32.112     0.200
    14.414    32.180     0.200
    14.425    30.212     0.200
    14.465    30.945     0.200
    14.505    30.685     0.200
    14.491    32.524     0.200
    14.672    32.560     0.200
    14.710    32.847     0.200
    14.842    32.875     0.200
    14.836    32.913     0.200
    14.832    33.016     0.200
    14.935    33.144     0.200
    14.926    35.133     0.200
    14.926    33.084     0.200
    15.021    31.157     0.200
    15.018    33.425     0.200
    15.051    34.217     0.200
    15.118    34.298     0.200
    15.141    32.528     0.200
    15.179    34.701     0.200
    15.245    32.642     0.200
    15.224    35.449     0.200
    15.224    33.441     0.200
    15.386    33.195     0.200
    15.463    32.856     0.200
    15.649    32.774     0.200
    15.772    35.722     0.200
    15.798    35.221     0.200
    15.765    34.846     0.200
    15.838    34.876     0.200
    15.871    35.551     0.200
    16.018    33.406     0.200
    16.166    32.132     0.200
    16.168    33.150     0.200
    16.146    35.745     0.200
    16.225    35.832     0.200
    16.267    33.779     0.200
    16.282    33.117     0.200
    16.313    34.129     0.200
    16.343    33.291     0.200
    17.006    36.322     0.200
    17.224    33.504     0.200
    17.780    34.759     0.200
    17.780    33.435     0.200
    17.780    33.986     0.200
    18.361    37.952     0.200
    18.681    37.286     0.200
    18.681    37.751     0.200
    18.681    38.780     0.200
    19.384    36.827     0.200
     1.188     7.385     0.200
     1.129     7.153     0.200
     1.129     6.704     0.200
     1.129     6.852     0.200
     1.396     6.746     0.200
     1.396     7.008     0.200
     1.463     8.709     0.200
     1.463     8.556     0.200
     1.463     8.775     0.200
     1.960     7.260     0.200
     1.960     7.030     0.200
     1.960     7.158     0.200
     1.903     9.384     0.200
     1.838     9.325     0.200
     1.858     9.070     0.200
     1.884     9.629     0.200
     2.031     9.273     0.200
     1.983    10.024     0.200
     2.080     9.960     0.200
     2.093     9.684     0.200
     2.974    11.602     0.200
     3.022     9.864     0.200
     3.010    11.552     0.200
     3.111    11.463     0.200
     2.958    12.851     0.200
     3.245    12.534     0.200
     3.085    12.592     0.200
     3.095    12.728     0.200
     3.162    13.319     0.200
     3.691    11.943     0.200
     3.729    12.753     0.200
     3.797    11.317     0.200
     3.797    10.645     0.200
     3.797    10.805     0.200
     3.784    13.133     0.200
     3.847    13.093     0.200
     3.930    13.351     0.200
     3.930    13.752     0.200
     3.930    14.041     0.200
     4.143    13.630     0.200
     4.143    13.454     0.200
     4.247    13.404     0.200
     4.247    13.033     0.200
     4.319    13.381     0.200
     4.319    13.530     0.200
     4.216    15.430     0.200
     4.437    11.765     0.200
     4.437    12.007     0.200
     4.246    14.595     0.200
     4.459    14.250     0.200
     4.459    13.930     0.200
     4.315    14.628     0.200
     4.316    15.433     0.200
     4.327    15.438     0.200
     4.360    15.968     0.200
     4.575    14.524     0.200
     4.575    14.293     0.200
     4.701    14.457     0.200
     4.701    14.125     0.200
     4.861    15.544     0.200
     4.707    15.498     0.200
     4.707    15.186     0.200
     4.944    15.100     0.200
     4.944    14.678     0.200
     4.800    15.535     0.200
     4.932    16.509     0.200
     5.292    14.621     0.200
     5.280    16.097     0.200
     5.280    15.867     0.200
     5.324    16.342     0.200
     5.324    16.081     0.200
     5.575    16.396     0.200
     5.682    16.007     0.200
     5.896    16.850     0.200
     5.967    17.261     0.200
     6.132    15.991     0.200
     6.058    18.077     0.200
     6.058    17.901     0.200
     6.127    17.913     0.200
     6.127    17.710     0.200
     6.111    17.436     0.200
     6.111    17.561     0.200
     6.319    17.737     0.200
     6.536    18.239     0.200
     6.762    19.022     0.200
     6.786    18.401     0.200
     6.786    18.644     0.200
     6.829    18.811     0.200
     6.829    18.585     0.200
     6.811    19.264     0.200
     6.811    19.366     0.200
     6.943    18.374     0.200
     6.874    20.113     0.200
     6.874    20.254     0.200
     7.184    18.616     0.200
     7.198    19.587     0.200
     7.243    19.285     0.200
     7.398    19.328     0.200
     7.398    19.589     0.200
     7.553    21.412     0.200
     7.550    20.736     0.200
     7.550    20.599     0.200
     7.705    21.120     0.200
     7.705    20.979     0.200
     7.827    20.739     0.200
     7.827    20.536     0.200
     8.104    20.631     0.200
     8.254    20.840     0.200
     8.254    21.840     0.200
     8.518    21.295     0.200
     8.453    21.938     0.200
     8.510    21.794     0.200
     8.510    22.024     0.200
     8.576    20.759     0.200
     8.634    22.674     0.200
     8.734    20.772     0.200
     8.778    22.056     0.200
     8.787    23.865     0.200
     8.913    21.744     0.200
     9.058    23.380     0.200
     9.058    23.262     0.200
     9.129    22.964     0.200
     9.172    23.039     0.200
     9.168    24.089     0.200
     9.279    22.616     0.200
     9.236    23.250     0.200
     9.405    23.161     0.200
     9.519    23.383     0.200
     9.569    24.245     0.200
     9.613    23.061     0.200
     9.704    23.409     0.200
     9.635    26.194     0.200
     9.635    25.866     0.200
    10.027    24.271     0.200
    10.074    25.497     0.200
    10.195    24.588     0.200
    10.225    24.977     0.200
    10.272    25.489     0.200
    10.247    25.995     0.200
    10.546    25.621     0.200
    10.717    25.330     0.200
    10.703    26.433     0.200
    11.049    26.586     0.200
    11.167    25.742     0.200
    11.290    26.488     0.200
    11.292    27.347     0.200
    11.176    29.604     0.200
    11.361    27.853     0.200
    11.497    27.316     0.200
    11.497    25.116     0.200
    11.497    27.316     0.200
    11.777    27.519     0.200
    11.881    27.797     0.200
    11.899    28.627     0.200
    12.245    29.094     0.200
    12.442    29.298     0.200
    12.762    28.694     0.200
    12.887    30.272     0.200
    12.926    29.654     0.200
    13.089    29.557     0.200
    13.932    32.222     0.200
    14.007    32.636     0.200
    14.446    33.396     0.200
    14.569    33.707     0.200
    14.789    33.097     0.200
    15.511    34.837     0.200
    15.502    34.055     0.200
    16.063    36.646     0.200
    16.060    35.319     0.200
    16.105    36.304     0.200
    16.145    35.845     0.200
    16.588    36.871     0.200
    16.734    36.347     0.200
    17.773    36.121     0.200
    17.773    35.773     0.200
     0.513     4.552     0.200
     0.519     4.730     0.200
     0.984     6.469     0.200
     0.976     5.801     0.200
     0.976     6.110     0.200
     1.185     7.578     0.200
     1.229     6.170     0.200
     1.258     8.137     0.200
     1.258     8.104     0.200
     1.510     7.675     0.200
     1.736     8.168     0.200
     1.698     8.406     0.200
     1.792     8.393     0.200
     1.743     8.451     0.200
     1.751     8.642     0.200
     1.833     8.788     0.200
     1.905     8.325     0.200
     1.967     6.923     0.200
     1.967     7.349     0.200
     1.966     9.170     0.200
     1.983     9.011     0.200
     2.838    10.453     0.200
     2.888    10.998     0.200
     3.004    10.536     0.200
     3.004     9.446     0.200
     3.102    11.254     0.200
     3.565    11.523     0.200
     3.613    11.913     0.200
     3.657    11.310     0.200
     3.671    11.837     0.200
     3.734    12.163     0.200
     3.760    11.009     0.200
     3.760    10.587     0.200
     3.782    12.285     0.200
     3.821    12.548     0.200
     3.972    11.759     0.200
     3.971    13.023     0.200
     4.094    12.311     0.200
     4.131    12.633     0.200
     4.125    13.068     0.200
     4.125    12.958     0.200
     4.139    12.661     0.200
     4.149    14.369     0.200
     4.149    14.201     0.200
     4.310    13.560     0.200
     4.310    13.208     0.200
     4.290    14.362     0.200
     4.372    13.855     0.200
     4.372    13.644     0.200
     4.388    11.698     0.200
     4.388    11.889     0.200
     4.388    12.139     0.200
     4.526    13.684     0.200
     4.647    14.156     0.200
     4.647    14.617     0.200
     4.647    14.480     0.200
     4.728    14.037     0.200
     4.781    14.195     0.200
     4.906    15.145     0.200
     5.077    15.646     0.200
     5.077    15.267     0.200
     5.130    16.167     0.200
     5.130    15.413     0.200
     5.154    14.609     0.200
     5.154    15.296     0.200
     5.392    15.970     0.200
     5.478    16.206     0.200
     5.515    15.882     0.200
     5.515    15.620     0.200
     5.655    15.728     0.200
     5.655    15.900     0.200
     5.699    16.158     0.200
     5.776    16.579     0.200
     5.775    15.902     0.200
     5.813    15.874     0.200
     5.813    16.519     0.200
     5.839    16.484     0.200
     5.852    17.396     0.200
     5.909    16.863     0.200
     5.942    16.906     0.200
     5.942    17.015     0.200
     6.007    17.803     0.200
     6.179    17.247     0.200
     6.179    17.696     0.200
     6.241    17.179     0.200
     6.318    17.748     0.200
     6.345    16.568     0.200
     6.364    17.631     0.200
     6.364    17.471     0.200
     6.583    17.539     0.200
     6.583    17.687     0.200
     6.604    18.448     0.200
     6.605    18.420     0.200
     6.641    17.821     0.200
     6.641    17.642     0.200
     6.745    17.486     0.200
     6.712    18.961     0.200
     6.712    19.391     0.200
     6.712    19.098     0.200
     7.049    18.058     0.200
     7.063    18.599     0.200
     7.073    18.415     0.200
     7.108    18.323     0.200
     7.109    17.971     0.200
     7.109    18.151     0.200
     7.229    19.164     0.200
     7.263    18.815     0.200
     7.353    19.715     0.200
     7.400    19.633     0.200
     7.400    19.016     0.200
     7.427    20.645     0.200
     7.427    19.992     0.200
     7.499    20.552     0.200
     7.499    19.998     0.200
     7.647    20.085     0.200
     7.647    19.901     0.200
     7.695    20.480     0.200
     7.863    19.660     0.200
     7.883    20.268     0.200
     7.883    20.131     0.200
     8.023    18.994     0.200
     8.023    19.982     0.200
     8.034    19.595     0.200
     8.051    20.792     0.200
     8.082    19.881     0.200
     8.264    20.876     0.200
     8.262    21.746     0.200
     8.262    21.226     0.200
     8.326    20.787     0.200
     8.326    20.924     0.200
     8.359    21.013     0.200
     8.359    21.255     0.200
     8.459    20.263     0.200
     8.462    21.865     0.200
     8.462    21.432     0.200
     8.504    20.644     0.200
     8.535    22.110     0.200
     8.536    21.067     0.200
     8.536    21.770     0.200
     8.565    21.251     0.200
     8.633    21.734     0.200
     8.669    20.105     0.200
     8.683    21.984     0.200
     8.683    21.695     0.200
     8.856    21.640     0.200
     8.856    20.953     0.200
     8.856    21.335     0.200
     8.867    23.074     0.200
     8.867    22.218     0.200
     8.875    22.209     0.200
     9.027    22.682     0.200
     9.040    22.313     0.200
     9.070    23.008     0.200
     9.070    22.891     0.200
     9.135    22.598     0.200
     9.135    22.156     0.200
     9.171    22.086     0.200
     9.330    22.924     0.200
     9.330    22.677     0.200
     9.384    22.686     0.200
     9.385    22.694     0.200
     9.408    23.451     0.200
     9.408    22.998     0.200
     9.440    22.864     0.200
     9.439    22.379     0.200
     9.555    23.185     0.200
     9.628    23.756     0.200
     9.573    24.375     0.200
     9.661    22.782     0.200
     9.721    24.324     0.200
     9.729    24.072     0.200
     9.886    25.025     0.200
     9.886    24.486     0.200
     9.908    24.163     0.200
     9.921    22.700     0.200
     9.921    23.856     0.200
     9.968    24.243     0.200
    10.006    22.958     0.200
    10.044    25.175     0.200
    10.044    25.343     0.200
    10.044    24.921     0.200
    10.093    23.711     0.200
    10.091    24.530     0.200
    10.133    23.753     0.200
    10.169    24.639     0.200
    10.187    24.426     0.200
    10.210    24.323     0.200
    10.259    25.397     0.200
    10.427    24.686     0.200
    10.452    25.537     0.200
    10.452    25.021     0.200
    10.477    25.782     0.200
    10.530    25.775     0.200
    10.608    25.978     0.200
    10.666    25.859     0.200
    10.676    25.676     0.200
    10.698    24.530     0.200
    10.740    25.590     0.200
    10.740    25.297     0.200
    10.834    26.052     0.200
    10.857    25.596     0.200
    10.869    26.211     0.200
    10.944    26.685     0.200
    10.944    26.138     0.200
    10.998    26.337     0.200
    11.019    26.207     0.200
    11.037    27.488     0.200
    11.043    26.810     0.200
    11.071    23.829     0.200
    11.115    25.423     0.200
    11.116    26.319     0.200
    11.116    26.854     0.200
    11.135    26.312     0.200
    11.108    27.256     0.200
    11.190    26.991     0.200
    11.190    26.381     0.200
    11.199    27.319     0.200
    11.219    26.064     0.200
    11.219    23.974     0.200
    11.225    26.869     0.200
    11.376    23.384     0.200
    11.376    23.833     0.200
    11.396    26.857     0.200
    11.399    27.214     0.200
    11.399    26.593     0.200
    11.405    27.050     0.200
    11.425    26.974     0.200
    11.425    26.657     0.200
    11.443    28.267     0.200
    11.443    27.396     0.200
    11.386    28.189     0.200
    11.521    26.467     0.200
    11.549    26.977     0.200
    11.628    26.110     0.200
    11.628    26.415     0.200
    11.665    25.474     0.200
    11.665    25.849     0.200
    11.677    27.283     0.200
    11.677    27.470     0.200
    11.692    27.698     0.200
    11.741    28.037     0.200
    11.787    28.217     0.200
    11.787    28.570     0.200
    11.804    27.413     0.200
    11.804    27.581     0.200
    11.822    25.464     0.200
    11.998    28.313     0.200
    11.998    27.887     0.200
    12.025    28.265     0.200
    12.084    28.654     0.200
    12.111    28.961     0.200
    12.145    28.909     0.200
    12.235    28.325     0.200
    12.298    28.682     0.200
    12.297    28.663     0.200
    12.309    29.335     0.200
    12.322    27.518     0.200
    12.395    28.457     0.200
    12.396    30.330     0.200
    12.396    30.041     0.200
    12.426    29.597     0.200
    12.429    29.470     0.200
    12.429    29.095     0.200
    12.658    29.614     0.200
    12.729    29.975     0.200
    12.782    29.588     0.200
    12.782    29.370     0.200
    12.803    30.437     0.200
    12.818    28.810     0.200
    12.831    29.773     0.200
    12.831    29.074     0.200
    12.843    29.243     0.200
    12.852    28.620     0.200
    12.852    29.995     0.200
    12.886    30.142     0.200
    13.051    30.442     0.200
    13.074    30.665     0.200
    13.142    30.737     0.200
    13.198    30.645     0.200
    13.265    30.859     0.200
    13.256    28.496     0.200
    13.256    30.184     0.200
    13.269    30.746     0.200
    13.269    30.249     0.200
    13.272    30.931     0.200
    13.272    30.107     0.200
    13.308    31.233     0.200
    13.308    30.194     0.200
    13.409    33.106     0.200
    13.409    30.797     0.200
    13.409    30.473     0.200
    13.450    31.090     0.200
    13.486    30.555     0.200
    13.491    30.414     0.200
    13.566    30.892     0.200
    13.580    31.374     0.200
    13.576    31.167     0.200
    13.591    31.469     0.200
    13.644    31.549     0.200
    13.656    31.577     0.200
    13.657    31.531     0.200
    13.599    30.891     0.200
    13.699    31.703     0.200
    13.704    31.630     0.200
    13.707    31.808     0.200
    13.861    31.380     0.200
    13.858    32.747     0.200
    13.858    32.044     0.200
    13.888    31.511     0.200
    13.910    31.487     0.200
    13.949    31.846     0.200
    13.991    30.809     0.200
    14.063    31.591     0.200
    14.231    32.481     0.200
    14.246    32.338     0.200
    14.242    31.917     0.200
    14.330    32.231     0.200
    14.399    32.519     0.200
    14.410    32.993     0.200
    14.454    32.837     0.200
    14.504    32.794     0.200
    14.540    32.583     0.200
    14.540    32.911     0.200
    14.629    33.306     0.200
    14.676    32.788     0.200
    14.676    33.257     0.200
    14.702    33.034     0.200
    14.702    33.354     0.200
    14.778    33.618     0.200
    14.826    33.426     0.200
    14.825    32.931     0.200
    14.898    33.385     0.200
    14.921    32.964     0.200
    14.936    33.455     0.200
    14.985    32.960     0.200
    14.992    33.897     0.200
    14.992    33.506     0.200
    15.197    32.862     0.200
    15.246    32.933     0.200
    15.354    33.248     0.200
    15.380    32.639     0.200
    15.394    33.387     0.200
    15.446    33.168     0.200
    15.488    33.254     0.200
    15.501    33.681     0.200
    15.501    33.624     0.200
    15.520    33.820     0.200
    15.618    34.267     0.200
    16.021    34.917     0.200
    16.021    34.289     0.200
    16.019    35.092     0.200
    16.044    34.732     0.200
    16.031    34.448     0.200
    16.056    33.943     0.200
    16.077    36.818     0.200
    16.077    34.302     0.200
    16.092    34.289     0.200
    16.086    35.192     0.200
    16.200    33.996     0.200
    16.200    33.765     0.200
    16.316    34.110     0.200
    16.347    33.715     0.200
    16.471    34.014     0.200
    16.563    34.421     0.200
    16.639    34.680     0.200
    16.930    34.747     0.200
    17.099    34.846     0.200
    17.667    34.814     0.200
    17.667    35.314     0.200
    17.667    34.966     0.200
    17.667    35.564     0.200
     1.220     7.177     0.200
     1.220     7.279     0.200
     1.384     6.954     0.200
     1.384     7.184     0.200
     1.869     6.397     0.200
     1.869     6.827     0.200
     1.869     6.655     0.200
     1.889     8.788     0.200
     1.936     8.712     0.200
     1.933     9.125     0.200
     1.956     9.002     0.200
     2.056     9.472     0.200
     1.980     9.192     0.200
     2.077     9.757     0.200
     2.178     9.788     0.200
     2.192     9.546     0.200
     2.936     9.142     0.200
     2.936     9.271     0.200
     2.936    10.702     0.200
     2.964    10.642     0.200
     3.071    11.331     0.200
     3.058    12.261     0.200
     3.211    11.909     0.200
     3.185    12.620     0.200
     3.262    12.619     0.200
     3.646    12.032     0.200
     3.716    10.141     0.200
     3.716    10.649     0.200
     3.679    11.960     0.200
     3.710    11.751     0.200
     3.732    11.892     0.200
     3.796    12.290     0.200
     3.898    12.760     0.200
     3.898    11.905     0.200
     4.024    13.155     0.200
     4.147    12.682     0.200
     4.130    13.234     0.200
     4.130    13.117     0.200
     4.197    13.015     0.200
     4.360    11.726     0.200
     4.360    11.531     0.200
     4.328    13.576     0.200
     4.328    13.362     0.200
     4.273    14.442     0.200
     4.316    14.341     0.200
     4.316    14.482     0.200
     4.429    13.139     0.200
     4.429    13.327     0.200
     4.346    14.615     0.200
     4.415    14.347     0.200
     4.416    14.793     0.200
     4.428    14.940     0.200
     4.428    14.457     0.200
     4.444    14.602     0.200
     4.460    14.799     0.200
     4.463    14.665     0.200
     4.487    14.824     0.200
     4.599    14.409     0.200
     4.599    14.174     0.200
     4.690    14.440     0.200
     4.690    14.033     0.200
     4.820    14.626     0.200
     4.820    14.309     0.200
     4.807    14.210     0.200
     4.807    14.773     0.200
     4.807    14.878     0.200
     4.923    14.476     0.200
     4.900    15.104     0.200
     5.032    15.443     0.200
     5.068    15.702     0.200
     5.254    15.525     0.200
     5.254    15.315     0.200
     5.304    15.520     0.200
     5.304    15.781     0.200
     5.332    16.205     0.200
     5.332    16.072     0.200
     5.532    16.155     0.200
     5.570    16.281     0.200
     5.570    16.406     0.200
     5.664    16.187     0.200
     5.664    16.324     0.200
     5.743    16.559     0.200
     5.739    17.771     0.200
     5.822    17.511     0.200
     5.939    16.632     0.200
     5.939    16.960     0.200
     5.845    17.719     0.200
     5.907    16.743     0.200
     5.877    17.622     0.200
     6.025    16.145     0.200
     6.066    16.085     0.200
     6.061    16.645     0.200
     6.124    17.548     0.200
     6.124    17.423     0.200
     6.092    17.937     0.200
     6.092    17.437     0.200
     6.132    17.172     0.200
     6.281    17.247     0.200
     6.281    17.614     0.200
     6.306    16.925     0.200
     6.361    15.683     0.200
     6.395    16.481     0.200
     6.476    19.756     0.200
     6.522    17.638     0.200
     6.522    18.294     0.200
     6.736    18.343     0.200
     6.829    18.545     0.200
     6.829    18.319     0.200
     6.809    18.095     0.200
     6.809    18.516     0.200
     6.862    19.232     0.200
     6.862    19.017     0.200
     6.957    18.446     0.200
     7.045    19.407     0.200
     7.116    16.883     0.200
     7.116    18.687     0.200
     6.963    19.253     0.200
     6.963    19.370     0.200
     7.135    18.230     0.200
     7.284    19.735     0.200
     7.235    19.290     0.200
     7.380    19.717     0.200
     7.380    20.573     0.200
     7.524    20.664     0.200
     7.524    19.751     0.200
     7.524    20.365     0.200
     7.562    20.441     0.200
     7.562    20.000     0.200
     7.731    18.945     0.200
     7.731    20.632     0.200
     7.844    19.728     0.200
     7.737    20.618     0.200
     7.819    20.433     0.200
     7.959    21.719     0.200
     8.037    20.541     0.200
     8.136    21.596     0.200
     8.304    21.507     0.200
     8.304    20.296     0.200
     8.304    21.792     0.200
     8.276    21.761     0.200
     8.276    22.015     0.200
     8.387    21.023     0.200
     8.443    19.920     0.200
     8.506    20.533     0.200
     8.505    21.605     0.200
     8.458    21.653     0.200
     8.507    21.387     0.200
     8.611    22.231     0.200
     8.633    22.521     0.200
     8.618    22.365     0.200
     8.718    21.577     0.200
     8.758    22.369     0.200
     8.837    21.580     0.200
     8.837    21.767     0.200
     8.904    22.852     0.200
     9.090    22.654     0.200
     9.065    22.808     0.200
     9.063    22.967     0.200
     9.130    23.401     0.200
     9.216    23.879     0.200
     9.336    23.201     0.200
     9.441    23.161     0.200
     9.483    22.995     0.200
     9.538    21.866     0.200
     9.524    22.896     0.200
     9.518    23.279     0.200
     9.539    24.837     0.200
     9.649    24.081     0.200
     9.734    24.508     0.200
     9.906    24.784     0.200
     9.890    25.116     0.200
     9.971    25.081     0.200
     9.927    25.142     0.200
    10.061    24.490     0.200
    10.081    25.459     0.200
    10.074    25.641     0.200
    10.074    25.973     0.200
    10.107    26.078     0.200
    10.205    24.634     0.200
    10.205    25.654     0.200
    10.265    26.061     0.200
    10.265    27.014     0.200
    10.270    26.178     0.200
    10.409    25.960     0.200
    10.484    25.457     0.200
    10.484    25.727     0.200
    10.475    26.350     0.200
    10.636    24.344     0.200
    10.668    26.921     0.200
    10.689    27.139     0.200
    10.754    27.360     0.200
    10.785    26.416     0.200
    10.784    26.354     0.200
    10.847    26.258     0.200
    10.847    26.098     0.200
    10.992    27.557     0.200
    11.074    26.300     0.200
    11.074    26.792     0.200
    11.011    27.797     0.200
    11.138    27.189     0.200
    11.127    27.495     0.200
    11.230    27.525     0.200
    11.242    27.994     0.200
    11.211    27.378     0.200
    11.299    27.747     0.200
    11.299    26.888     0.200
    11.299    27.602     0.200
    11.299    27.356     0.200
    11.236    28.269     0.200
    11.352    27.130     0.200
    11.352    27.666     0.200
    11.281    27.941     0.200
    11.269    28.029     0.200
    11.391    27.456     0.200
    11.338    27.100     0.200
    11.276    27.816     0.200
    11.276    28.066     0.200
    11.447    25.089     0.200
    11.447    26.601     0.200
    11.544    28.064     0.200
    11.601    28.563     0.200
    11.668    27.398     0.200
    11.666    27.685     0.200
    11.555    28.422     0.200
    11.637    28.475     0.200
    11.749    28.674     0.200
    11.723    28.311     0.200
    11.733    29.327     0.200
    11.812    27.780     0.200
    11.812    28.635     0.200
    11.782    27.930     0.200
    11.830    27.931     0.200
    11.935    28.896     0.200
    11.880    28.293     0.200
    11.958    28.837     0.200
    12.156    28.281     0.200
    12.117    27.991     0.200
    12.247    29.395     0.200
    12.268    29.961     0.200
    12.241    29.478     0.200
    12.307    29.547     0.200
    12.393    28.706     0.200
    12.510    29.474     0.200
    12.603    29.040     0.200
    12.572    29.522     0.200
    12.667    27.996     0.200
    12.658    30.624     0.200
    12.594    30.176     0.200
    12.584    30.412     0.200
    12.801    30.079     0.200
    12.810    29.382     0.200
    12.870    30.063     0.200
    12.950    30.405     0.200
    13.007    29.994     0.200
    13.007    30.639     0.200
    13.125    28.546     0.200
    13.125    28.417     0.200
    13.125    28.772     0.200
    13.005    31.127     0.200
    13.247    31.082     0.200
    13.259    30.913     0.200
    13.285    31.114     0.200
    13.322    31.942     0.200
    13.322    30.172     0.200
    13.322    31.543     0.200
    13.287    31.378     0.200
    13.342    32.334     0.200
    13.533    30.906     0.200
    13.427    32.335     0.200
    13.534    32.349     0.200
    13.566    31.280     0.200
    13.607    32.334     0.200
    13.599    33.027     0.200
    13.624    32.615     0.200
    13.792    32.451     0.200
    13.730    33.352     0.200
    13.776    33.511     0.200
    13.776    34.210     0.200
    13.834    33.837     0.200
    13.776    31.728     0.200
    13.869    34.093     0.200
    13.946    33.233     0.200
    14.006    31.671     0.200
    14.004    31.879     0.200
    14.086    31.891     0.200
    14.155    31.998     0.200
    14.245    32.105     0.200
    14.395    30.682     0.200
    14.395    31.530     0.200
    14.394    33.219     0.200
    14.372    33.167     0.200
    14.474    32.202     0.200
    14.388    34.043     0.200
    14.486    33.430     0.200
    14.554    33.351     0.200
    14.544    33.389     0.200
    14.700    33.493     0.200
    14.683    34.127     0.200
    14.764    33.400     0.200
    14.796    33.086     0.200
    14.822    33.480     0.200
    14.859    34.249     0.200
    14.938    34.660     0.200
    14.951    35.395     0.200
    15.010    34.640     0.200
    15.155    34.637     0.200
    15.345    34.310     0.200
    15.384    34.351     0.200
    15.384    35.011     0.200
    15.525    35.341     0.200
    15.494    35.580     0.200
    15.468    35.084     0.200
    15.556    34.955     0.200
    15.641    35.250     0.200
    15.969    35.798     0.200
    15.969    36.083     0.200
    15.979    36.163     0.200
    16.039    36.193     0.200
    16.086    35.938     0.200
    16.217    35.587     0.200
    16.275    35.509     0.200
    16.292    34.646     0.200
    16.435    35.576     0.200
    16.485    35.180     0.200
    16.536    34.955     0.200
    16.611    36.022     0.200
    16.672    36.512     0.200
    17.716    35.169     0.200
    17.716    36.958     0.200
     1.634     8.791     0.200
     1.819    10.279     0.200
     2.159    10.329     0.200
     3.180    12.326     0.200
     3.904    13.864     0.200
     4.209    13.166     0.200
     4.209    14.475     0.200
     4.553    14.881     0.200
     4.614    15.158     0.200
     4.614    15.021     0.200
     4.636    15.812     0.200
     4.667    16.145     0.200
     4.672    15.961     0.200
     4.672    15.793     0.200
     4.691    15.756     0.200
     4.691    15.865     0.200
     4.704    16.011     0.200
     4.708    15.613     0.200
     4.948    14.611     0.200
     5.145    16.850     0.200
     5.173    17.027     0.200
     5.209    16.530     0.200
     5.209    16.050     0.200
     5.361    17.109     0.200
     5.551    17.416     0.200
     5.593    17.697     0.200
     5.560    15.807     0.200
     5.560    16.389     0.200
     5.560    16.752     0.200
     5.668    17.946     0.200
     5.984    18.618     0.200
     5.994    18.089     0.200
     5.994    18.745     0.200
     6.062    17.882     0.200
     6.062    18.932     0.200
     6.110    18.067     0.200
     5.937    20.080     0.200
     5.937    20.260     0.200
     6.201    18.022     0.200
     6.201    18.577     0.200
     6.241    18.337     0.200
     6.241    18.665     0.200
     6.509    18.782     0.200
     6.509    19.837     0.200
     6.505    19.117     0.200
     6.500    19.045     0.200
     6.500    19.592     0.200
     6.593    19.604     0.200
     6.626    19.478     0.200
     6.626    20.240     0.200
     6.784    19.808     0.200
     6.837    19.533     0.200
     7.040    19.953     0.200
     7.040    20.238     0.200
     7.030    20.986     0.200
     7.070    20.779     0.200
     7.070    21.314     0.200
     7.083    19.192     0.200
     7.083    20.317     0.200
     7.108    19.374     0.200
     7.161    20.129     0.200
     7.153    20.019     0.200
     7.238    20.897     0.200
     7.382    21.577     0.200
     7.443    19.872     0.200
     7.490    19.892     0.200
     7.663    21.045     0.200
     7.635    21.982     0.200
     7.635    21.873     0.200
     7.726    21.737     0.200
     7.726    21.409     0.200
     7.929    22.097     0.200
     8.022    23.016     0.200
     8.053    22.543     0.200
     8.182    22.875     0.200
     8.203    22.173     0.200
     8.203    22.783     0.200
     8.237    22.325     0.200
     8.237    22.560     0.200
     8.221    21.857     0.200
     8.221    22.338     0.200
     8.301    22.796     0.200
     8.326    23.982     0.200
     8.351    22.836     0.200
     8.351    22.976     0.200
     8.368    23.084     0.200
     8.710    23.411     0.200
     8.710    23.528     0.200
     8.751    22.633     0.200
     8.751    23.906     0.200
     8.838    24.223     0.200
     8.863    23.347     0.200
     8.863    23.035     0.200
     9.013    22.964     0.200
     9.013    23.768     0.200
     9.094    23.775     0.200
     9.127    23.867     0.200
     9.127    24.184     0.200
     9.121    23.355     0.200
     9.214    23.297     0.200
     9.310    24.124     0.200
     9.310    24.475     0.200
     9.314    24.205     0.200
     9.314    24.701     0.200
     9.422    25.475     0.200
     9.426    24.501     0.200
     9.428    23.781     0.200
     9.428    24.445     0.200
     9.489    24.921     0.200
     9.489    25.526     0.200
     9.506    24.713     0.200
     9.605    24.435     0.200
     9.622    23.638     0.200
     9.622    24.080     0.200
     9.736    23.952     0.200
     9.736    23.749     0.200
     9.774    25.720     0.200
     9.774    25.470     0.200
     9.801    23.984     0.200
     9.895    25.872     0.200
     9.942    25.124     0.200
    10.004    24.783     0.200
    10.004    24.572     0.200
    10.096    26.069     0.200
    10.112    25.438     0.200
    10.168    26.362     0.200
    10.248    27.190     0.200
    10.263    27.003     0.200
    10.263    26.690     0.200
     9.936    29.020     0.200
     9.936    29.122     0.200
     9.936    28.751     0.200
    10.314    26.063     0.200
    10.360    26.486     0.200
    10.365    26.709     0.200
    10.377    26.668     0.200
    10.377    26.769     0.200
    10.385    25.404     0.200
    10.440    25.732     0.200
    10.440    25.919     0.200
    10.469    25.073     0.200
    10.555    27.199     0.200
    10.651    27.146     0.200
    10.697    27.686     0.200
    10.709    26.492     0.200
    10.709    26.613     0.200
    10.701    26.643     0.200
    10.701    26.882     0.200
    10.761    28.656     0.200
    10.832    26.859     0.200
    10.937    27.478     0.200
    10.936    27.925     0.200
    10.957    28.060     0.200
    11.031    27.890     0.200
    11.165    28.120     0.200
    11.165    28.245     0.200
    11.252    29.515     0.200
    11.271    27.426     0.200
    11.271    27.965     0.200
    11.258    27.479     0.200
    11.269    27.544     0.200
    11.304    28.551     0.200
    11.307    29.311     0.200
    11.377    28.855     0.200
    11.377    28.621     0.200
    11.376    27.705     0.200
    11.470    28.732     0.200
    11.508    28.569     0.200
    11.508    27.533     0.200
    11.588    29.101     0.200
    11.552    30.641     0.200
    11.552    29.977     0.200
    11.573    28.207     0.200
    11.609    28.383     0.200
    11.717    29.137     0.200
    11.761    29.383     0.200
    11.850    29.334     0.200
    11.883    30.214     0.200
    11.883    29.675     0.200
    11.922    28.859     0.200
    11.960    29.595     0.200
    11.997    29.180     0.200
    12.040    28.254     0.200
    12.051    30.579     0.200
    12.096    28.847     0.200
    12.096    29.617     0.200
    12.120    29.344     0.200
    12.148    29.196     0.200
    12.148    30.235     0.200
    12.148    28.911     0.200
    12.148    27.918     0.200
    12.224    30.812     0.200
    12.225    29.826     0.200
    12.309    30.247     0.200
    12.309    29.950     0.200
    12.331    27.617     0.200
    12.357    30.942     0.200
    12.328    29.338     0.200
    12.450    30.330     0.200
    12.458    30.107     0.200
    12.530    29.917     0.200
    12.520    31.527     0.200
    12.520    29.851     0.200
    12.534    30.967     0.200
    12.579    29.687     0.200
    12.657    29.272     0.200
    12.668    28.966     0.200
    12.720    31.862     0.200
    12.865    32.428     0.200
    12.865    31.756     0.200
    12.846    31.130     0.200
    12.917    30.206     0.200
    12.917    30.378     0.200
    12.905    30.094     0.200
    12.905    30.508     0.200
    12.924    29.489     0.200
    12.957    31.339     0.200
    13.008    32.303     0.200
    13.131    32.711     0.200
    13.205    31.855     0.200
    13.190    32.750     0.200
    13.192    32.339     0.200
    13.275    30.301     0.200
    13.439    32.704     0.200
    13.482    33.602     0.200
    13.480    32.780     0.200
    13.539    34.530     0.200
    13.539    33.851     0.200
    13.575    33.033     0.200
    13.632    32.467     0.200
    13.722    31.844     0.200
    13.819    31.827     0.200
    13.869    34.145     0.200
    13.846    33.237     0.200
    13.889    34.652     0.200
    13.970    35.142     0.200
    13.929    33.294     0.200
    13.997    34.598     0.200
    13.978    32.962     0.200
    13.994    33.838     0.200
    14.094    33.761     0.200
    14.099    35.605     0.200
    14.099    35.058     0.200
    14.094    34.175     0.200
    14.243    34.876     0.200
    14.228    33.756     0.200
    14.291    35.091     0.200
    14.325    33.617     0.200
    14.286    34.576     0.200
    14.364    32.948     0.200
    14.399    33.783     0.200
    14.479    33.770     0.200
    14.498    32.760     0.200
    14.500    32.670     0.200
    14.566    34.046     0.200
    14.617    36.416     0.200
    14.617    33.588     0.200
    14.692    33.907     0.200
    14.743    33.966     0.200
    14.818    32.806     0.200
    14.862    34.282     0.200
    14.868    33.783     0.200
    14.941    33.515     0.200
    14.948    33.360     0.200
    14.868    33.786     0.200
    14.974    33.980     0.200
    14.920    36.644     0.200
    14.920    33.737     0.200
    15.011    35.451     0.200
    15.003    35.111     0.200
    15.054    34.731     0.200
    15.142    35.264     0.200
    15.298    34.651     0.200
    15.299    33.754     0.200
    15.315    35.302     0.200
    15.006    36.868     0.200
    15.330    35.230     0.200
    15.330    35.800     0.200
    15.450    34.960     0.200
    15.548    35.624     0.200
    15.593    35.700     0.200
    15.662    36.720     0.200
    15.674    35.592     0.200
    15.776    36.017     0.200
    15.740    36.606     0.200
    15.927    35.722     0.200
    15.960    35.513     0.200
    15.981    35.615     0.200
    16.016    35.996     0.200
    16.072    35.595     0.200
    16.132    35.961     0.200
    16.163    35.628     0.200
    16.133    36.039     0.200
    16.139    36.032     0.200
    16.302    35.837     0.200
    16.359    35.377     0.200
    16.455    35.867     0.200
    16.560    36.533     0.200
    16.659    36.891     0.200
    16.713    37.452     0.200
    16.691    36.426     0.200
    16.881    37.164     0.200
    16.828    37.411     0.200
    16.937    37.639     0.200
    16.943    37.384     0.200
    17.069    37.286     0.200
    17.097    36.316     0.200
    17.136    37.367     0.200
    17.244    37.621     0.200
    17.240    36.794     0.200
    17.290    37.392     0.200
    17.290    37.552     0.200
    17.432    35.782     0.200
    17.432    36.415     0.200
    17.572    37.222     0.200
    17.572    36.675     0.200
    17.682    36.744     0.200
    17.682    37.041     0.200
    17.852    36.976     0.200
    17.971    37.088     0.200
    18.130    35.976     0.200
    18.130    36.871     0.200
     1.279     7.632     0.200
     1.308     7.687     0.200
     1.282     7.062     0.200
     1.425     7.596     0.200
     1.436     8.510     0.200
     1.477     8.988     0.200
     1.553     8.528     0.200
     1.847     7.579     0.200
     1.993     9.553     0.200
     2.061    10.288     0.200
     2.138    10.059     0.200
     2.920     9.849     0.200
     2.920    10.106     0.200
     3.706    11.186     0.200
     3.706    11.475     0.200
     3.748    12.143     0.200
     4.169    12.716     0.200
     4.352    12.379     0.200
     4.352    12.614     0.200
     4.378    13.656     0.200
     4.361    14.330     0.200
     4.458    14.659     0.200
     4.506    15.003     0.200
     4.655    14.714     0.200
     4.730    15.257     0.200
     4.850    14.525     0.200
     4.850    14.924     0.200
     5.278    15.654     0.200
     5.360    15.949     0.200
     5.381    16.418     0.200
     5.700    16.905     0.200
     5.851    16.352     0.200
     5.969    17.325     0.200
     6.030    16.879     0.200
     6.068    16.408     0.200
     6.151    17.318     0.200
     6.187    17.645     0.200
     6.306    17.889     0.200
     6.321    16.977     0.200
     6.365    16.292     0.200
     7.116    17.264     0.200
     7.141    18.953     0.200
     7.027    19.727     0.200
     7.158    19.503     0.200
     7.106    18.543     0.200
     7.416    19.003     0.200
     7.486    19.202     0.200
     7.546    19.002     0.200
     7.554    20.074     0.200
     7.613    21.163     0.200
     7.738    18.995     0.200
     7.838    19.326     0.200
     7.795    21.166     0.200
     7.981    20.762     0.200
     8.039    19.308     0.200
     8.312    21.528     0.200
     8.392    21.463     0.200
     8.331    21.982     0.200
     8.437    20.434     0.200
     8.514    21.985     0.200
     8.506    21.992     0.200
     8.551    21.900     0.200
     8.629    22.392     0.200
     8.658    20.000     0.200
     8.725    22.060     0.200
     8.831    20.969     0.200
     8.831    21.559     0.200
     9.110    23.552     0.200
     9.191    22.802     0.200
     9.335    22.463     0.200
     9.498    23.765     0.200
     9.532    21.959     0.200
     9.543    23.011     0.200
     9.613    22.628     0.200
     9.652    23.881     0.200
     9.845    23.430     0.200
     9.778    24.826     0.200
    10.033    24.761     0.200
    10.116    24.308     0.200
    10.166    25.117     0.200
    10.624    24.970     0.200
    11.137    25.282     0.200
    11.153    26.313     0.200
    11.157    26.934     0.200
    11.233    25.570     0.200
    11.339    27.077     0.200
    11.317    29.254     0.200
    11.288    28.152     0.200
    11.320    27.769     0.200
    11.321    28.716     0.200
    11.321    28.184     0.200
    11.463    23.314     0.200
    11.572    28.297     0.200
    11.674    27.538     0.200
    11.600    28.419     0.200
    11.736    27.551     0.200
    11.812    28.400     0.200
    11.830    28.090     0.200
    11.806    27.216     0.200
    12.409    28.146     0.200
    12.637    29.244     0.200
    12.803    29.895     0.200
    13.090    29.365     0.200
    13.090    29.494     0.200
    13.230    31.398     0.200
    13.254    31.532     0.200
    13.299    33.334     0.200
    13.286    31.222     0.200
    13.332    31.755     0.200
    13.419    31.806     0.200
    13.501    31.666     0.200
    13.568    31.095     0.200
    13.558    31.668     0.200
    13.544    31.283     0.200
    13.593    30.962     0.200
    13.859    32.325     0.200
    13.822    31.737     0.200
    13.954    31.770     0.200
    13.981    30.555     0.200
    14.131    33.593     0.200
    14.357    31.930     0.200
    14.433    34.091     0.200
    14.433    32.931     0.200
    14.453    34.062     0.200
    14.506    33.703     0.200
    15.473    35.242     0.200
    15.504    34.023     0.200
    15.494    35.754     0.200
    15.562    35.698     0.200
    15.562    35.928     0.200
    15.603    35.047     0.200
    15.967    36.186     0.200
    16.041    35.774     0.200
    16.094    34.921     0.200
    16.291    35.847     0.200
    16.455    36.213     0.200
    16.550    37.184     0.200
    16.621    37.376     0.200
    17.725    36.171     0.200
     1.311     7.522     0.200
     1.295     7.290     0.200
     1.370     8.146     0.200
     1.423     7.619     0.200
     1.833     7.801     0.200
     1.833     8.200     0.200
     2.023    10.002     0.200
     2.027    10.167     0.200
     2.152    11.177     0.200
     2.907    10.170     0.200
     2.907    10.400     0.200
     3.693    11.500     0.200
     3.693    11.812     0.200
     3.739    12.249     0.200
     4.340    12.818     0.200
     4.340    12.978     0.200
     4.340    11.407     0.200
     4.378    14.018     0.200
     4.452    14.321     0.200
     4.376    15.622     0.200
     4.376    15.051     0.200
     4.521    14.990     0.200
     4.657    14.714     0.200
     4.727    15.300     0.200
     4.866    15.114     0.200
     4.866    15.434     0.200
     5.271    15.801     0.200
     5.362    15.938     0.200
     5.381    16.345     0.200
     5.696    17.667     0.200
     5.757    16.786     0.200
     5.842    16.593     0.200
     7.039    20.247     0.200
     8.819    22.081     0.200
     9.793    25.715     0.200
    11.309    27.416     0.200
    11.309    26.244     0.200
    11.455    23.571     0.200
    11.336    29.105     0.200
    13.075    30.107     0.200
    13.284    33.567     0.200
    14.418    34.237     0.200
    15.193    36.104     0.200
    15.411    36.466     0.200
    15.464    36.016     0.200
    15.486    34.376     0.200
    15.494    34.954     0.200
    15.552    35.143     0.200
    15.926    35.240     0.200
    16.084    35.304     0.200
    16.360    36.769     0.200
    16.611    37.058     0.200
    16.668    36.101     0.200
    17.135    36.169     0.200
    17.716    36.653     0.200
    17.716    37.043     0.200
     0.349     4.274     0.200
     0.360     4.337     0.200
     0.515     5.438     0.200
     0.515     5.676     0.200
     0.868     5.408     0.200
     1.056     6.724     0.200
     1.111     7.116     0.200
     1.319     6.163     0.200
     1.233     7.444     0.200
     1.283     7.412     0.200
     1.286     7.425     0.200
     1.379     7.927     0.200
     1.506     8.094     0.200
     1.524     7.775     0.200
     2.370     9.886     0.200
     2.370     7.218     0.200
     2.415    11.157     0.200
     3.367    10.211     0.200
     3.717    12.494     0.200
     3.790    12.599     0.200
     3.718    14.453     0.200
     3.718    13.563     0.200
     3.855    12.318     0.200
     3.856    12.655     0.200
     3.868    12.705     0.200
     3.856    13.419     0.200
     3.966    12.925     0.200
     4.011    12.317     0.200
     4.092    10.825     0.200
     4.182    13.132     0.200
     4.222    15.070     0.200
     4.222    14.378     0.200
     4.385    13.995     0.200
     4.505    13.871     0.200
     4.697    13.289     0.200
     4.886    14.646     0.200
     5.011    14.835     0.200
     5.258    15.508     0.200
     5.520    15.536     0.200
     5.614    16.409     0.200
     5.725    15.953     0.200
     5.779    15.684     0.200
     5.865    16.827     0.200
     5.872    16.475     0.200
     5.946    16.122     0.200
     6.276    18.260     0.200
     6.259    18.205     0.200
     6.259    18.357     0.200
     6.347    17.745     0.200
     6.404    16.780     0.200
     6.387    17.033     0.200
     6.553    17.594     0.200
     7.226    19.356     0.200
     7.205    19.526     0.200
     7.327    18.836     0.200
     7.265    19.634     0.200
     7.359    19.289     0.200
     7.450    20.156     0.200
     7.592    20.120     0.200
     7.859    20.734     0.200
     8.147    20.698     0.200
     8.261    20.261     0.200
     8.444    22.150     0.200
     8.679    22.183     0.200
     8.740    20.500     0.200
     8.753    21.593     0.200
     9.072    23.473     0.200
     9.259    22.057     0.200
     9.793    24.236     0.200
    10.028    24.981     0.200
    11.031    26.099     0.200
    11.213    27.762     0.200
    11.758    25.502     0.200
    11.752    28.276     0.200
    12.046    27.517     0.200
    12.064    26.862     0.200
    13.113    29.562     0.200
    13.384    30.731     0.200
    13.567    31.450     0.200
    13.663    30.743     0.200
    15.218    33.853     0.200
    15.258    34.548     0.200
    15.355    32.874     0.200
    15.467    34.062     0.200
    15.622    34.127     0.200
    16.231    34.519     0.200
    16.838    34.406     0.200
    17.841    34.533     0.200
     1.045     7.710     0.200
     1.042     7.267     0.200
     1.093     8.001     0.200
     1.552     8.527     0.200
     1.706     9.275     0.200
     1.714     9.146     0.200
     1.740    10.490     0.200
     1.740     9.431     0.200
     1.822    10.843     0.200
     2.075     9.721     0.200
     3.103    11.653     0.200
     3.103    11.543     0.200
     3.042    14.470     0.200
     3.042    14.009     0.200
     3.188    14.500     0.200
     3.530    14.470     0.200
     3.530    14.149     0.200
     4.129    13.885     0.200
     4.546    14.706     0.200
     4.614    14.963     0.200
     4.620    15.108     0.200
     4.613    15.217     0.200
     4.867    13.778     0.200
     4.867    14.548     0.200
     5.092    16.369     0.200
     5.134    16.058     0.200
     5.477    15.670     0.200
     5.527    17.111     0.200
     5.980    17.671     0.200
     5.944    18.225     0.200
     5.954    18.987     0.200
     6.165    18.337     0.200
     6.144    18.142     0.200
     6.439    18.490     0.200
     6.466    18.833     0.200
     6.547    19.810     0.200
     6.701    19.950     0.200
     6.782    19.220     0.200
     6.966    20.349     0.200
     6.989    20.784     0.200
     7.069    19.707     0.200
     7.093    20.134     0.200
     7.587    21.360     0.200
     7.665    21.501     0.200
     7.854    21.430     0.200
     7.968    22.836     0.200
     8.098    22.676     0.200
     8.124    22.696     0.200
     8.137    21.826     0.200
     8.167    22.035     0.200
     8.244    24.256     0.200
     8.247    22.395     0.200
     8.646    23.040     0.200
     8.458    25.468     0.200
     8.458    24.768     0.200
     8.796    22.485     0.200
     8.929    22.876     0.200
     9.037    23.227     0.200
     9.054    23.770     0.200
     9.251    24.464     0.200
     9.348    24.915     0.200
     9.407    24.298     0.200
     9.422    24.222     0.200
     9.521    24.169     0.200
     9.700    24.846     0.200
     9.717    23.642     0.200
    10.028    24.700     0.200
    10.092    26.235     0.200
    10.206    26.490     0.200
    10.001    27.883     0.200
    10.231    26.444     0.200
    10.212    26.439     0.200
    10.284    26.906     0.200
    10.311    25.256     0.200
    10.312    26.705     0.200
    10.356    25.580     0.200
    10.280    28.604     0.200
    10.583    26.411     0.200
    10.617    25.920     0.200
    10.625    26.309     0.200
    10.854    26.483     0.200
    11.094    28.144     0.200
    11.186    27.054     0.200
    11.232    26.578     0.200
    11.253    29.077     0.200
    11.293    27.323     0.200
    11.424    29.434     0.200
    11.686    27.843     0.200
    11.684    29.484     0.200
    11.767    28.159     0.200
    11.847    29.583     0.200
    11.900    26.872     0.200
    11.916    25.983     0.200
    11.957    27.118     0.200
    12.142    28.173     0.200
    12.147    30.288     0.200
    12.249    28.864     0.200
    12.249    24.767     0.200
    12.288    30.184     0.200
    12.384    30.312     0.200
    12.450    30.073     0.200
    12.574    27.083     0.200
    12.649    30.520     0.200
    12.504    31.500     0.200
    12.940    32.984     0.200
    13.110    32.189     0.200
    13.894    32.493     0.200
    13.918    32.925     0.200
    14.171    35.194     0.200
    14.223    35.422     0.200
    14.615    33.405     0.200
    14.793    36.206     0.200
    15.067    35.601     0.200
    15.216    36.086     0.200
    15.058    36.254     0.200
    15.843    34.345     0.200
    15.886    35.607     0.200
    16.061    35.994     0.200
    16.086    37.100     0.200
    16.372    36.709     0.200
    16.986    36.814     0.200
    17.488    36.617     0.200
    17.598    36.791     0.200
     0.400     4.770     0.200
     0.410     4.385     0.200
     0.664     5.693     0.200
     0.664     5.568     0.200
     0.664     5.794     0.200
     1.089     7.545     0.200
     1.090     7.325     0.200
     1.219     6.165     0.200
     1.219     6.407     0.200
     2.207     8.481     0.200
     2.207     8.223     0.200
     2.207     8.379     0.200
     2.944    10.946     0.200
     3.210    10.674     0.200
     3.210     9.963     0.200
     3.210    10.299     0.200
     3.610    11.704     0.200
     3.781    12.348     0.200
     3.908    12.639     0.200
     3.941    11.246     0.200
     3.941    11.004     0.200
     3.941    10.848     0.200
     3.883    13.527     0.200
     3.883    14.222     0.200
     3.992    12.369     0.200
     3.992    12.666     0.200
     4.021    14.053     0.200
     4.192    12.756     0.200
     4.192    13.217     0.200
     4.302    13.421     0.200
     4.302    13.171     0.200
     4.386    14.649     0.200
     4.386    14.391     0.200
     4.386    14.219     0.200
     4.453    13.358     0.200
     4.453    13.467     0.200
     4.551    12.292     0.200
     4.551    12.042     0.200
     4.551    12.557     0.200
     4.739    14.089     0.200
     4.755    14.232     0.200
     4.897    14.859     0.200
     4.994    15.050     0.200
     5.167    15.263     0.200
     5.294    15.727     0.200
     5.460    15.731     0.200
     5.460    15.535     0.200
     5.548    16.454     0.200
     5.552    15.813     0.200
     5.644    16.738     0.200
     5.682    16.376     0.200
     5.682    16.689     0.200
     5.734    16.561     0.200
     5.734    16.280     0.200
     5.791    16.525     0.200
     5.791    16.236     0.200
     5.839    17.089     0.200
     5.839    16.870     0.200
     6.075    17.330     0.200
     6.100    17.507     0.200
     6.100    17.187     0.200
     6.188    17.920     0.200
     6.295    17.798     0.200
     6.295    17.181     0.200
     6.355    17.815     0.200
     6.401    17.517     0.200
     6.399    18.165     0.200
     6.399    17.790     0.200
     6.399    18.360     0.200
     6.499    16.200     0.200
     6.526    17.723     0.200
     6.570    17.659     0.200
     6.589    17.236     0.200
     6.973    18.373     0.200
     7.073    19.587     0.200
     7.170    18.822     0.200
     7.199    19.660     0.200
     7.228    17.741     0.200
     7.201    19.246     0.200
     7.295    19.504     0.200
     7.377    19.711     0.200
     7.441    20.822     0.200
     7.554    19.872     0.200
     7.782    20.140     0.200
     7.872    20.126     0.200
     7.921    20.348     0.200
     8.008    19.878     0.200
     8.008    19.535     0.200
     8.134    19.845     0.200
     8.146    19.751     0.200
     8.131    21.199     0.200
     8.205    19.596     0.200
     8.210    19.921     0.200
     8.219    20.454     0.200
     8.346    21.939     0.200
     8.346    19.361     0.200
     8.394    21.150     0.200
     8.453    20.320     0.200
     8.546    23.109     0.200
     8.546    22.875     0.200
     8.574    20.943     0.200
     8.613    20.216     0.200
     8.608    21.652     0.200
     8.628    20.191     0.200
     8.737    22.284     0.200
     8.737    22.573     0.200
     8.768    19.805     0.200
     8.968    20.645     0.200
     9.000    21.699     0.200
     9.000    20.715     0.200
     9.015    22.930     0.200
     9.031    23.033     0.200
     9.136    21.598     0.200
     9.305    22.721     0.200
     9.305    22.385     0.200
     9.306    23.730     0.200
     9.306    23.426     0.200
     9.372    23.360     0.200
     9.401    23.767     0.200
     9.449    21.746     0.200
     9.444    20.528     0.200
     9.467    22.555     0.200
     9.467    20.914     0.200
     9.513    20.521     0.200
     9.574    23.623     0.200
     9.652    24.147     0.200
     9.698    22.662     0.200
     9.698    22.412     0.200
     9.729    23.031     0.200
     9.769    24.485     0.200
     9.861    24.758     0.200
     9.861    24.281     0.200
     9.923    24.798     0.200
     9.989    21.569     0.200
     9.994    24.718     0.200
    10.044    21.527     0.200
    10.093    24.859     0.200
    10.232    24.115     0.200
    10.251    23.624     0.200
    10.272    24.403     0.200
    10.290    23.902     0.200
    10.330    25.681     0.200
    10.352    25.657     0.200
    10.455    25.504     0.200
    10.455    25.723     0.200
    10.540    24.213     0.200
    10.552    25.610     0.200
    10.570    24.371     0.200
    10.647    25.782     0.200
    10.624    25.491     0.200
    10.624    25.592     0.200
    10.719    23.069     0.200
    10.737    25.217     0.200
    10.733    26.421     0.200
    10.853    26.263     0.200
    10.853    26.724     0.200
    10.859    26.880     0.200
    10.837    26.272     0.200
    10.837    26.874     0.200
    10.837    26.452     0.200
    10.964    26.732     0.200
    11.012    24.675     0.200
    11.031    26.733     0.200
    11.104    25.443     0.200
    11.118    23.117     0.200
    11.125    24.060     0.200
    11.153    26.764     0.200
    11.208    27.379     0.200
    11.249    27.463     0.200
    11.249    25.401     0.200
    11.249    24.815     0.200
    11.249    27.705     0.200
    11.268    25.262     0.200
    11.321    26.378     0.200
    11.321    26.292     0.200
    11.329    25.637     0.200
    11.314    27.776     0.200
    11.405    27.486     0.200
    11.417    24.152     0.200
    11.451    25.598     0.200
    11.437    28.377     0.200
    11.524    26.636     0.200
    11.551    24.361     0.200
    11.570    26.568     0.200
    11.677    25.975     0.200
    11.693    28.201     0.200
    11.708    26.367     0.200
    11.694    28.303     0.200
    11.694    28.538     0.200
    11.722    24.294     0.200
    11.841    27.361     0.200
    11.918    27.089     0.200
    11.936    27.220     0.200
    11.949    28.562     0.200
    11.964    27.674     0.200
    11.978    29.324     0.200
    12.010    29.244     0.200
    12.040    25.447     0.200
    12.185    28.577     0.200
    12.275    29.584     0.200
    12.275    30.139     0.200
    12.309    28.107     0.200
    12.338    29.078     0.200
    12.337    30.415     0.200
    12.362    25.580     0.200
    12.379    26.968     0.200
    12.377    30.049     0.200
    12.437    27.605     0.200
    12.437    28.417     0.200
    12.472    27.813     0.200
    12.662    30.837     0.200
    12.801    30.769     0.200
    12.820    28.445     0.200
    12.838    29.018     0.200
    12.859    28.306     0.200
    12.923    29.099     0.200
    12.975    29.540     0.200
    13.016    29.023     0.200
    13.004    32.467     0.200
    13.094    30.446     0.200
    13.183    32.166     0.200
    13.220    29.054     0.200
    13.215    29.067     0.200
    13.258    29.103     0.200
    13.351    31.494     0.200
    13.381    29.012     0.200
    13.401    30.186     0.200
    13.410    32.614     0.200
    13.442    31.408     0.200
    13.437    33.220     0.200
    13.493    30.417     0.200
    13.493    29.761     0.200
    13.484    29.949     0.200
    13.504    32.247     0.200
    13.504    29.348     0.200
    13.504    29.802     0.200
    13.516    32.144     0.200
    13.521    31.457     0.200
    13.553    29.015     0.200
    13.618    33.206     0.200
    13.618    29.510     0.200
    13.618    31.331     0.200
    13.617    31.996     0.200
    13.673    31.065     0.200
    13.739    30.626     0.200
    13.827    31.532     0.200
    13.899    31.299     0.200
    13.937    29.648     0.200
    13.953    29.980     0.200
    13.990    30.598     0.200
    14.008    32.862     0.200
    14.001    29.945     0.200
    14.007    28.350     0.200
    14.021    31.394     0.200
    14.047    31.370     0.200
    14.158    32.234     0.200
    14.216    32.104     0.200
    14.369    32.023     0.200
    14.378    31.362     0.200
    14.417    30.709     0.200
    14.451    32.333     0.200
    14.458    32.331     0.200
    14.628    32.148     0.200
    14.628    32.827     0.200
    14.667    32.943     0.200
    14.790    33.008     0.200
    14.800    32.241     0.200
    14.796    32.594     0.200
    14.818    32.446     0.200
    14.896    34.005     0.200
    14.896    32.614     0.200
    14.896    33.731     0.200
    14.892    32.614     0.200
    14.978    33.611     0.200
    14.974    31.571     0.200
    15.009    33.654     0.200
    15.094    32.683     0.200
    15.077    33.853     0.200
    15.141    34.788     0.200
    15.191    32.699     0.200
    15.191    35.074     0.200
    15.199    32.880     0.200
    15.419    33.677     0.200
    15.512    32.881     0.200
    15.602    33.117     0.200
    15.736    35.388     0.200
    15.736    35.599     0.200
    15.767    35.677     0.200
    15.812    33.245     0.200
    15.812    34.916     0.200
    15.832    35.242     0.200
    15.786    34.024     0.200
    15.786    34.500     0.200
    15.786    34.305     0.200
    15.975    34.018     0.200
    16.091    34.135     0.200
    16.121    34.878     0.200
    16.118    33.157     0.200
    16.121    33.747     0.200
    16.114    33.940     0.200
    16.234    34.477     0.200
    16.224    34.521     0.200
    16.366    33.458     0.200
    16.516    34.494     0.200
    16.548    35.853     0.200
    16.850    35.700     0.200
    16.959    35.117     0.200
    17.176    34.535     0.200
    17.732    34.095     0.200
    17.732    33.571     0.200
    17.732    34.220     0.200
    18.322    38.801     0.200
    18.656    37.541     0.200
    18.656    38.986     0.200
    19.343    37.466     0.200
    19.802    36.086     0.200
     0.356     5.220     0.200
     0.684     5.884     0.200
     0.889     5.898     0.200
     1.087     7.149     0.200
     1.150     7.247     0.200
     1.150     7.497     0.200
     1.271     6.051     0.200
     1.532     7.333     0.200
     1.451     8.039     0.200
     1.457     7.998     0.200
     1.550     8.476     0.200
     1.765     8.208     0.200
     1.674     8.699     0.200
     2.706    11.828     0.200
     3.233    10.486     0.200
     3.787    12.589     0.200
     3.970    11.370     0.200
     3.874    14.462     0.200
     3.874    13.822     0.200
     3.966    12.629     0.200
     4.052    12.495     0.200
     4.013    14.615     0.200
     4.251    13.071     0.200
     4.357    13.409     0.200
     4.376    14.686     0.200
     4.584    11.717     0.200
     4.584    12.823     0.200
     4.512    13.266     0.200
     4.956    14.679     0.200
     5.055    15.253     0.200
     5.220    15.223     0.200
     5.518    15.693     0.200
     5.702    16.835     0.200
     5.846    16.452     0.200
     5.884    16.251     0.200
     5.793    16.060     0.200
     5.898    17.025     0.200
     6.205    16.261     0.200
     6.241    17.983     0.200
     6.345    17.442     0.200
     6.354    17.649     0.200
     6.496    16.826     0.200
     6.408    17.788     0.200
     6.460    17.448     0.200
     6.426    17.997     0.200
     6.586    18.040     0.200
     7.171    19.231     0.200
     7.248    19.686     0.200
     7.269    18.724     0.200
     7.229    18.983     0.200
     7.261    19.825     0.200
     7.353    19.685     0.200
     7.433    19.730     0.200
     7.492    19.373     0.200
     7.494    20.665     0.200
     7.614    20.007     0.200
     7.827    19.529     0.200
     7.972    20.126     0.200
     8.176    20.321     0.200
     8.191    21.222     0.200
     8.279    20.801     0.200
     8.638    20.889     0.200
     8.599    22.769     0.200
     8.664    22.006     0.200
     8.814    21.592     0.200
     8.797    22.420     0.200
     9.073    23.003     0.200
     9.180    22.585     0.200
     9.298    24.761     0.200
     9.429    23.921     0.200
     9.490    23.464     0.200
     9.455    24.040     0.200
     9.773    24.124     0.200
     9.829    24.542     0.200
    10.053    24.968     0.200
    10.307    24.885     0.200
    10.350    24.689     0.200
    10.390    26.126     0.200
    10.391    26.731     0.200
    10.514    25.601     0.200
    10.585    25.058     0.200
    10.703    25.979     0.200
    10.772    24.601     0.200
    10.792    25.735     0.200
    10.875    25.500     0.200
    10.792    26.492     0.200
    10.830    27.680     0.200
    10.830    26.530     0.200
    11.145    25.157     0.200
    11.091    26.653     0.200
    11.168    24.462     0.200
    11.107    27.244     0.200
    11.210    26.997     0.200
    11.314    26.492     0.200
    11.467    25.587     0.200
    11.467    22.997     0.200
    11.467    24.637     0.200
    11.461    27.154     0.200
    11.771    25.298     0.200
    11.750    27.632     0.200
    11.754    28.685     0.200
    11.960    26.741     0.200
    11.978    27.018     0.200
    12.069    29.150     0.200
    12.214    27.916     0.200
    12.913    30.189     0.200
    13.252    30.075     0.200
    13.317    31.526     0.200
    13.411    33.532     0.200
    13.539    30.515     0.200
    13.574    31.935     0.200
    13.581    31.653     0.200
    13.676    31.696     0.200
    13.927    30.946     0.200
    13.970    30.032     0.200
    14.023    30.822     0.200
    14.036    30.999     0.200
    14.056    30.776     0.200
    14.428    31.058     0.200
    14.426    31.810     0.200
    14.470    31.680     0.200
    14.831    33.698     0.200
    15.020    34.161     0.200
    15.138    33.990     0.200
    15.257    34.559     0.200
    15.395    35.089     0.200
    15.461    34.135     0.200
    15.490    33.026     0.200
    15.560    34.044     0.200
    15.648    34.730     0.200
    16.165    34.249     0.200
    16.215    34.477     0.200
    16.566    34.591     0.200
    16.677    35.506     0.200
    16.768    35.342     0.200
    17.781    35.051     0.200
     1.046     6.698     0.200
     1.186     6.369     0.200
     1.172     7.285     0.200
     1.169     7.327     0.200
     1.169     6.747     0.200
     1.241     7.874     0.200
     1.319     8.552     0.200
     1.319     8.171     0.200
     1.691     8.382     0.200
     1.772     7.590     0.200
     1.858    10.606     0.200
     1.946     9.346     0.200
     1.950     9.409     0.200
     2.040    10.057     0.200
     2.186     9.822     0.200
     2.820     9.665     0.200
     2.820     9.806     0.200
     3.554    11.687     0.200
     3.586    11.024     0.200
     3.586    10.845     0.200
     3.932    13.270     0.200
     4.135    13.578     0.200
     4.221    12.157     0.200
     4.221    11.952     0.200
     4.235    13.394     0.200
     4.414    14.337     0.200
     4.353    17.467     0.200
     4.353    14.577     0.200
     4.492    13.575     0.200
     4.851    17.260     0.200
     4.851    15.340     0.200
     5.065    15.106     0.200
     5.119    15.544     0.200
     5.138    15.741     0.200
     5.467    15.337     0.200
     5.906    17.199     0.200
     5.945    16.953     0.200
     6.703    18.979     0.200
     6.892    20.436     0.200
     7.622    20.397     0.200
     8.089    21.607     0.200
     8.564    22.507     0.200
     9.181    22.921     0.200
     9.777    26.374     0.200
    10.068    25.268     0.200
    10.657    26.338     0.200
    10.814    27.055     0.200
    10.932    27.640     0.200
    11.267    26.039     0.200
    11.656    28.322     0.200
    12.212    27.371     0.200
    13.778    32.107     0.200
    15.277    34.971     0.200
    15.281    34.714     0.200
    15.304    35.117     0.200
    15.321    35.652     0.200
    15.848    35.597     0.200
    15.883    36.346     0.200
    15.879    35.138     0.200
    15.916    34.802     0.200
    16.505    35.735     0.200
    17.543    36.743     0.200
    17.543    37.374     0.200
     1.271     6.444     0.200
     1.778     8.657     0.200
     1.726     8.969     0.200
     1.739     9.089     0.200
     1.946     9.831     0.200
     1.833     9.850     0.200
     2.000     7.414     0.200
     2.000     7.795     0.200
     1.949     9.730     0.200
     1.965     9.601     0.200
     2.844    12.764     0.200
     3.021    11.112     0.200
     3.040    11.075     0.200
     3.040    10.835     0.200
     2.971    13.277     0.200
     3.145    11.977     0.200
     3.656    12.594     0.200
     3.714    12.369     0.200
     3.799    10.722     0.200
     3.799    11.101     0.200
     4.011    13.232     0.200
     4.162    13.377     0.200
     4.123    15.035     0.200
     4.123    14.904     0.200
     4.352    13.983     0.200
     4.428    12.408     0.200
     4.403    14.236     0.200
     4.566    13.928     0.200
     4.772    15.597     0.200
     4.620    15.033     0.200
     4.823    14.524     0.200
     5.109    15.930     0.200
     5.197    15.430     0.200
     5.166    15.807     0.200
     5.556    16.086     0.200
     5.698    15.839     0.200
     5.735    16.752     0.200
     5.855    17.192     0.200
     5.881    17.525     0.200
     5.942    17.286     0.200
     5.981    17.439     0.200
     6.093    15.851     0.200
     6.222    17.889     0.200
     6.405    17.922     0.200
     6.615    18.471     0.200
     6.627    19.229     0.200
     6.679    18.213     0.200
     6.709    20.355     0.200
     6.709    20.064     0.200
     7.150    18.689     0.200
     7.150    18.170     0.200
     7.271    18.596     0.200
     7.388    20.310     0.200
     7.442    20.234     0.200
     7.529    20.905     0.200
     7.686    20.597     0.200
     7.738    20.073     0.200
     7.903    19.943     0.200
     7.926    21.085     0.200
     8.084    21.249     0.200
     8.299    21.910     0.200
     8.364    21.632     0.200
     8.401    22.471     0.200
     8.500    21.042     0.200
     8.507    22.295     0.200
     8.503    21.503     0.200
     8.546    21.106     0.200
     8.579    21.107     0.200
     8.578    22.887     0.200
     8.676    22.449     0.200
     8.904    23.147     0.200
     9.070    23.884     0.200
     9.082    22.724     0.200
     9.112    23.420     0.200
     9.174    23.138     0.200
     9.372    22.991     0.200
     9.428    23.825     0.200
     9.450    24.437     0.200
     9.483    24.056     0.200
     9.596    24.189     0.200
     9.701    23.935     0.200
     9.547    25.544     0.200
     9.547    25.865     0.200
     9.803    24.037     0.200
     9.924    24.268     0.200
     9.964    25.461     0.200
    10.076    25.205     0.200
    10.130    24.973     0.200
    10.209    25.201     0.200
    10.495    25.851     0.200
    10.570    26.067     0.200
    10.716    25.811     0.200
    10.708    26.198     0.200
    10.783    26.224     0.200
    10.871    24.062     0.200
    10.897    26.615     0.200
    10.987    27.769     0.200
    11.040    27.089     0.200
    11.086    25.054     0.200
    11.053    26.477     0.200
    11.115    26.198     0.200
    11.158    26.092     0.200
    11.156    27.186     0.200
    11.233    27.416     0.200
    11.083    29.913     0.200
    11.083    28.342     0.200
    11.361    28.845     0.200
    11.671    27.186     0.200
    11.709    26.563     0.200
    11.782    27.314     0.200
    11.846    28.490     0.200
    11.827    28.424     0.200
    11.864    28.588     0.200
    12.068    27.598     0.200
    12.124    29.823     0.200
    12.340    29.020     0.200
    12.365    28.755     0.200
    12.433    28.665     0.200
    12.466    30.383     0.200
    12.814    29.464     0.200
    12.861    29.209     0.200
    12.872    30.302     0.200
    13.310    31.481     0.200
    13.315    31.213     0.200
    13.621    32.227     0.200
    13.688    32.081     0.200
    13.811    31.976     0.200
    13.952    32.609     0.200
    13.993    31.530     0.200
    14.102    32.236     0.200
    14.373    34.400     0.200
    14.452    34.402     0.200
    14.718    34.975     0.200
    14.814    33.855     0.200
    15.035    34.327     0.200
    15.288    34.161     0.200
    15.437    34.021     0.200
    15.529    34.026     0.200
    16.058    36.256     0.200
    16.063    35.218     0.200
    16.087    36.775     0.200
    16.111    33.692     0.200
    16.243    35.954     0.200
    16.514    36.857     0.200
    16.681    36.753     0.200
    17.710    34.151     0.200
    17.710    35.987     0.200
     1.579     8.548     0.200
     1.898     8.836     0.200
     2.936    10.889     0.200
     3.187    14.622     0.200
     3.187    13.634     0.200
     3.331    13.566     0.200
     3.681    14.763     0.200
     3.681    14.584     0.200
     3.956    13.431     0.200
     4.410    13.632     0.200
     4.443    14.608     0.200
     4.457    14.359     0.200
     4.498    14.167     0.200
     4.690    13.552     0.200
     4.925    16.298     0.200
     4.980    15.166     0.200
     5.192    15.638     0.200
     5.299    15.021     0.200
     5.396    15.836     0.200
     5.810    18.127     0.200
     5.852    17.518     0.200
     6.009    17.485     0.200
     6.033    17.046     0.200
     6.298    17.866     0.200
     6.385    18.169     0.200
    12.077    27.726     0.200
    12.077    28.325     0.200
    12.152    29.497     0.200
    12.232    29.263     0.200
    12.505    30.614     0.200
    12.907    29.995     0.200
    13.562    30.325     0.200
    14.025    33.256     0.200
    14.084    32.923     0.200
    14.136    32.179     0.200
    14.576    32.340     0.200
    14.688    34.426     0.200
    14.915    34.773     0.200
    15.345    34.960     0.200
    15.513    34.858     0.200
    15.668    35.246     0.200
    15.926    35.730     0.200
    16.105    35.338     0.200
    16.197    36.066     0.200
    16.300    36.602     0.200
    16.810    35.960     0.200
    16.836    36.726     0.200
    16.928    35.391     0.200
    17.314    36.225     0.200
    17.422    36.447     0.200
    17.494    36.881     0.200
     0.448     4.320     0.200
     0.448     4.773     0.200
     0.530     4.860     0.200
     0.530     5.098     0.200
     0.924     6.768     0.200
     0.992     7.154     0.200
     1.005     7.128     0.200
     1.119     7.893     0.200
     1.136     7.667     0.200
     1.141     7.245     0.200
     1.536     8.623     0.200
     1.536     8.242     0.200
     1.849     8.590     0.200
     2.465    10.242     0.200
     2.889    10.732     0.200
     2.889    10.053     0.200
     3.230    13.852     0.200
     3.230    12.632     0.200
     3.373    12.441     0.200
     3.907    12.553     0.200
     3.907    10.973     0.200
     3.725    13.679     0.200
     3.725    13.199     0.200
     4.374    12.959     0.200
     4.468    13.502     0.200
     4.640    13.145     0.200
     4.878    13.875     0.200
     4.939    14.278     0.200
     5.163    15.080     0.200
     5.249    13.086     0.200
     5.249    15.101     0.200
     5.361    15.838     0.200
     5.830    17.145     0.200
     6.025    18.535     0.200
     8.652    24.381     0.200
     9.691    23.649     0.200
    10.191    26.922     0.200
    12.030    27.838     0.200
    12.115    29.494     0.200
    12.191    30.091     0.200
    12.352    27.469     0.200
    12.593    29.951     0.200
    12.611    30.128     0.200
    12.688    30.913     0.200
    12.866    30.008     0.200
    13.665    30.585     0.200
    15.026    34.410     0.200
    15.362    34.018     0.200
    15.463    33.901     0.200
    15.465    34.074     0.200
    15.552    33.878     0.200
    15.695    34.278     0.200
    15.760    33.912     0.200
    15.835    34.407     0.200
    15.862    33.863     0.200
    15.879    34.479     0.200
    16.057    36.710     0.200
    16.149    36.629     0.200
    16.786    36.893     0.200
    16.877    36.757     0.200
    17.265    35.970     0.200
    17.373    36.528     0.200
    17.822    36.141     0.200
     1.868     9.085     0.200
     3.500    15.152     0.200
     3.754    12.288     0.200
     3.754    12.421     0.200
     3.647    15.485     0.200
     3.983    15.018     0.200
     3.983    15.307     0.200
     4.384    14.714     0.200
     4.515    13.205     0.200
     4.515    13.814     0.200
     4.534    15.169     0.200
     4.564    14.780     0.200
     4.706    15.261     0.200
     4.948    16.313     0.200
     5.073    15.817     0.200
     5.143    14.793     0.200
     5.406    16.712     0.200
     6.483    18.434     0.200
     6.383    21.001     0.200
     8.373    22.653     0.200
     8.908    25.437     0.200
     9.608    23.666     0.200
    10.347    26.323     0.200
    10.455    29.990     0.200
    10.693    26.755     0.200
    10.735    29.111     0.200
    11.369    29.351     0.200
    11.612    28.644     0.200
    11.782    28.974     0.200
    11.898    30.449     0.200
    11.898    28.937     0.200
    12.066    29.017     0.200
    12.547    30.898     0.200
    12.565    30.936     0.200
    12.962    32.637     0.200
    13.459    32.937     0.200
    13.555    32.932     0.200
    13.966    33.413     0.200
    14.153    34.827     0.200
    14.199    34.004     0.200
    14.410    34.315     0.200
    14.508    35.183     0.200
    14.610    36.298     0.200
    15.308    36.550     0.200
    17.364    36.543     0.200
     0.334     4.489     0.200
     0.334     4.778     0.200
     0.345     4.751     0.200
     0.516     5.271     0.200
     0.516     6.009     0.200
     1.125     7.562     0.200
     1.126     7.352     0.200
     2.378     8.654     0.200
     3.072    11.345     0.200
     3.377    10.778     0.200
     3.377    10.598     0.200
     3.732    12.221     0.200
     3.711    14.088     0.200
     3.870    12.776     0.200
     3.883    12.848     0.200
     3.849    13.333     0.200
     3.981    12.645     0.200
     3.981    13.130     0.200
     4.026    12.091     0.200
     4.026    12.595     0.200
     4.103    11.707     0.200
     4.103    11.480     0.200
     4.195    13.091     0.200
     4.317    13.593     0.200
     4.214    14.612     0.200
     4.214    14.241     0.200
     4.214    14.487     0.200
     4.401    13.786     0.200
     4.401    14.036     0.200
     4.520    13.748     0.200
     4.520    13.619     0.200
     4.709    12.276     0.200
     4.709    12.835     0.200
     4.709    12.995     0.200
     4.709    13.424     0.200
     4.822    14.603     0.200
     4.867    14.867     0.200
     4.899    14.789     0.200
     5.025    14.955     0.200
     5.274    15.926     0.200
     5.346    16.067     0.200
     5.535    15.896     0.200
     5.576    15.648     0.200
     5.626    16.884     0.200
     5.676    16.057     0.200
     5.739    15.798     0.200
     5.739    16.220     0.200
     5.794    16.926     0.200
     5.880    16.671     0.200
     5.887    16.965     0.200
     5.961    16.955     0.200
     6.203    17.985     0.200
     6.239    17.650     0.200
     6.291    17.919     0.200
     6.261    18.831     0.200
     6.261    18.143     0.200
     6.261    18.385     0.200
     6.302    17.813     0.200
     6.362    18.173     0.200
     6.401    17.470     0.200
     6.419    18.135     0.200
     6.567    17.687     0.200
     6.606    17.173     0.200
     6.642    16.454     0.200
     6.654    17.869     0.200
     7.027    18.449     0.200
     7.212    19.122     0.200
     7.220    19.818     0.200
     7.241    19.651     0.200
     7.241    19.733     0.200
     7.293    20.538     0.200
     7.277    19.566     0.200
     7.373    19.592     0.200
     7.465    20.052     0.200
     7.507    20.148     0.200
     7.546    21.181     0.200
     7.607    19.862     0.200
     7.872    20.046     0.200
     7.915    20.051     0.200
     8.036    20.261     0.200
     8.161    20.336     0.200
     8.161    19.926     0.200
     8.162    20.970     0.200
     8.264    20.474     0.200
     8.272    20.185     0.200
     8.275    19.131     0.200
     8.460    21.707     0.200
     8.477    19.562     0.200
     8.477    19.988     0.200
     8.589    20.566     0.200
     8.648    21.842     0.200
     8.688    21.161     0.200
     8.695    21.914     0.200
     8.731    21.101     0.200
     8.773    21.399     0.200
     8.773    21.258     0.200
     8.768    22.124     0.200
     8.901    20.782     0.200
     9.087    23.341     0.200
     9.104    22.269     0.200
     9.130    23.633     0.200
     9.152    21.487     0.200
     9.134    24.393     0.200
     9.273    21.806     0.200
     9.454    23.820     0.200
     9.464    22.765     0.200
     9.496    24.034     0.200
     9.567    21.046     0.200
     9.576    22.565     0.200
     9.593    22.733     0.200
     9.594    23.573     0.200
     9.642    21.744     0.200
     9.712    24.444     0.200
     9.807    24.244     0.200
     9.849    23.576     0.200
     9.867    24.010     0.200
     9.858    24.654     0.200
     9.858    24.513     0.200
     9.999    24.905     0.200
    10.043    25.017     0.200
    10.102    24.591     0.200
    10.115    22.402     0.200
    10.158    23.853     0.200
    10.181    23.851     0.200
    10.352    25.678     0.200
    10.352    25.132     0.200
    10.385    25.497     0.200
    10.406    23.927     0.200
    10.429    24.496     0.200
    10.516    25.710     0.200
    10.574    26.058     0.200
    10.574    26.371     0.200
    10.623    26.342     0.200
    10.674    24.459     0.200
    10.721    26.054     0.200
    10.721    25.288     0.200
    10.736    26.437     0.200
    10.665    27.534     0.200
    10.665    25.362     0.200
    10.779    26.637     0.200
    10.826    24.066     0.200
    10.834    26.649     0.200
    10.854    26.877     0.200
    10.860    26.478     0.200
    10.999    25.392     0.200
    10.941    27.633     0.200
    11.046    26.776     0.200
    11.087    27.172     0.200
    11.138    25.746     0.200
    11.194    27.575     0.200
    11.194    27.384     0.200
    11.227    24.690     0.200
    11.227    25.050     0.200
    11.228    27.321     0.200
    11.235    23.648     0.200
    11.248    25.857     0.200
    11.279    26.671     0.200
    11.345    27.552     0.200
    11.359    24.133     0.200
    11.359    25.083     0.200
    11.359    24.794     0.200
    11.397    26.601     0.200
    11.467    26.984     0.200
    11.477    28.823     0.200
    11.493    27.341     0.200
    11.483    26.796     0.200
    11.531    24.602     0.200
    11.531    24.821     0.200
    11.531    24.551     0.200
    11.661    24.660     0.200
    11.671    27.146     0.200
    11.729    27.452     0.200
    11.745    28.492     0.200
    11.767    27.785     0.200
    11.774    26.172     0.200
    11.838    25.889     0.200
    11.844    24.887     0.200
    11.994    27.863     0.200
    12.006    28.312     0.200
    12.060    27.477     0.200
    12.072    29.836     0.200
    12.078    27.182     0.200
    12.105    28.868     0.200
    12.112    28.003     0.200
    12.144    27.697     0.200
    12.310    29.549     0.200
    12.310    30.010     0.200
    12.347    29.403     0.200
    12.390    30.287     0.200
    12.420    29.265     0.200
    12.449    29.869     0.200
    12.469    28.653     0.200
    12.465    28.156     0.200
    12.476    28.370     0.200
    12.602    29.061     0.200
    12.631    30.146     0.200
    12.631    29.493     0.200
    12.685    30.835     0.200
    12.878    30.747     0.200
    12.907    30.267     0.200
    12.959    30.619     0.200
    12.998    30.328     0.200
    12.998    29.980     0.200
    13.028    31.469     0.200
    13.087    29.176     0.200
    13.126    30.058     0.200
    13.186    29.754     0.200
    13.239    32.513     0.200
    13.149    30.835     0.200
    13.261    30.019     0.200
    13.319    28.886     0.200
    13.378    29.154     0.200
    13.399    32.339     0.200
    13.423    32.913     0.200
    13.423    32.569     0.200
    13.461    32.173     0.200
    13.518    31.908     0.200
    13.520    30.190     0.200
    13.549    31.003     0.200
    13.554    32.650     0.200
    13.578    28.357     0.200
    13.582    31.921     0.200
    13.654    30.797     0.200
    13.678    29.108     0.200
    13.675    30.401     0.200
    13.675    30.202     0.200
    13.758    32.234     0.200
    13.785    32.421     0.200
    13.785    31.733     0.200
    13.891    31.479     0.200
    13.944    32.980     0.200
    13.960    31.355     0.200
    13.986    31.478     0.200
    13.994    33.982     0.200
    14.070    32.393     0.200
    14.070    31.100     0.200
    14.120    30.616     0.200
    14.106    32.581     0.200
    14.128    29.007     0.200
    14.126    31.325     0.200
    14.161    32.479     0.200
    14.178    33.338     0.200
    14.209    32.090     0.200
    14.218    34.501     0.200
    14.298    33.653     0.200
    14.446    33.134     0.200
    14.495    30.920     0.200
    14.523    30.483     0.200
    14.556    30.967     0.200
    14.618    33.784     0.200
    14.823    33.446     0.200
    14.931    33.221     0.200
    14.942    33.467     0.200
    14.972    33.704     0.200
    15.067    33.484     0.200
    15.102    31.257     0.200
    15.112    34.050     0.200
    15.142    33.039     0.200
    15.170    33.497     0.200
    15.232    33.173     0.200
    15.274    33.112     0.200
    15.309    33.214     0.200
    15.429    32.776     0.200
    15.482    33.623     0.200
    15.518    31.563     0.200
    15.621    32.967     0.200
    15.732    32.240     0.200
    15.906    34.220     0.200
    15.939    34.546     0.200
    15.999    33.007     0.200
    16.031    33.354     0.200
    16.205    33.892     0.200
    16.245    32.630     0.200
    16.258    33.709     0.200
    16.338    36.066     0.200
    16.346    34.342     0.200
    16.449    34.902     0.200
    16.470    34.191     0.200
    16.475    35.455     0.200
    16.475    33.334     0.200
    16.632    33.145     0.200
    16.753    35.577     0.200
    16.753    34.011     0.200
    16.852    33.308     0.200
    17.305    33.745     0.200
    17.856    34.811     0.200
    17.856    34.960     0.200
    18.489    37.901     0.200
    19.509    37.012     0.200
     0.699     5.205     0.200
     0.699     5.471     0.200
     0.724     5.180     0.200
     0.723     4.692     0.200
     0.917     7.241     0.200
     1.019     8.118     0.200
     1.734     9.004     0.200
     1.762     8.780     0.200
     1.763     9.233     0.200
     2.123     9.422     0.200
     2.123     9.133     0.200
     3.185    10.977     0.200
     3.185    11.258     0.200
     4.205    12.636     0.200
     4.205    12.940     0.200
     4.513    14.458     0.200
     4.543    13.730     0.200
     4.594    14.185     0.200
     4.594    14.310     0.200
     4.617    15.274     0.200
     4.668    14.476     0.200
     4.937    13.416     0.200
     4.937    13.799     0.200
     5.106    15.524     0.200
     5.146    14.731     0.200
     5.146    15.176     0.200
     5.281    15.877     0.200
     5.492    16.023     0.200
     5.519    16.028     0.200
     5.519    16.239     0.200
     5.544    14.642     0.200
     5.544    14.853     0.200
     5.544    14.962     0.200
     5.622    16.705     0.200
     5.915    17.624     0.200
     5.911    17.379     0.200
     5.701    20.404     0.200
     6.034    16.670     0.200
     6.121    17.133     0.200
     6.121    17.500     0.200
     6.179    17.580     0.200
     6.179    17.330     0.200
     6.438    17.998     0.200
     6.414    18.196     0.200
     6.414    18.321     0.200
     6.467    19.024     0.200
     6.570    17.419     0.200
     6.570    18.817     0.200
     6.756    18.643     0.200
     6.975    19.169     0.200
     6.991    18.671     0.200
     7.019    19.943     0.200
     7.029    18.568     0.200
     7.088    18.853     0.200
     7.323    19.207     0.200
     7.461    18.609     0.200
     7.551    20.381     0.200
     7.593    20.231     0.200
     7.648    20.376     0.200
     7.864    20.761     0.200
     8.144    21.442     0.200
     8.167    20.883     0.200
     8.193    20.606     0.200
     8.219    21.525     0.200
     8.274    23.342     0.200
     8.633    22.021     0.200
     8.715    22.049     0.200
     8.791    23.147     0.200
     8.790    21.946     0.200
     8.991    22.322     0.200
     9.060    23.200     0.200
     9.090    21.997     0.200
     9.199    22.277     0.200
     9.238    23.064     0.200
     9.366    23.830     0.200
     9.369    25.917     0.200
     9.393    23.427     0.200
     9.442    23.993     0.200
     9.594    23.042     0.200
     9.699    23.220     0.200
     9.709    24.621     0.200
     9.841    25.126     0.200
     9.906    24.666     0.200
     9.982    23.093     0.200
    10.018    25.070     0.200
    10.078    24.519     0.200
    10.106    25.441     0.200
     9.910    27.979     0.200
    10.192    26.742     0.200
    10.180    25.205     0.200
    10.180    25.744     0.200
    10.291    25.675     0.200
    10.302    25.211     0.200
    10.302    24.836     0.200
    10.315    25.333     0.200
    10.298    25.384     0.200
    10.342    24.766     0.200
    10.411    24.668     0.200
    10.429    24.464     0.200
    10.189    28.964     0.200
    10.474    26.261     0.200
    10.579    25.970     0.200
    10.633    27.295     0.200
    10.675    25.698     0.200
    10.677    25.106     0.200
    10.676    26.722     0.200
    10.676    26.932     0.200
    10.778    26.907     0.200
    10.859    26.873     0.200
    10.896    24.362     0.200
    10.909    25.977     0.200
    11.003    26.145     0.200
    11.096    27.125     0.200
    11.169    28.350     0.200
    11.238    27.540     0.200
    11.226    27.732     0.200
    11.226    27.889     0.200
    11.238    26.122     0.200
    11.244    25.621     0.200
    11.304    28.025     0.200
    11.293    26.382     0.200
    11.411    27.891     0.200
    11.471    26.943     0.200
    11.468    28.672     0.200
    11.532    28.863     0.200
    11.550    27.541     0.200
    11.647    28.107     0.200
    11.698    28.503     0.200
    11.857    28.195     0.200
    11.919    28.325     0.200
    11.942    28.328     0.200
    11.976    29.231     0.200
    11.993    26.166     0.200
    12.067    28.886     0.200
    12.098    29.415     0.200
    12.186    28.801     0.200
    12.283    26.009     0.200
    12.284    29.906     0.200
    12.317    28.706     0.200
    12.393    28.881     0.200
    12.400    28.894     0.200
    12.457    30.248     0.200
    12.493    28.933     0.200
    12.563    29.630     0.200
    12.612    27.550     0.200
    12.650    30.769     0.200
    12.412    32.219     0.200
    12.788    31.806     0.200
    12.824    29.949     0.200
    12.874    29.587     0.200
    12.893    28.732     0.200
    12.936    31.415     0.200
    12.936    30.181     0.200
    12.939    30.891     0.200
    13.065    32.130     0.200
    13.145    29.940     0.200
    13.181    31.583     0.200
    13.227    30.263     0.200
    13.460    31.870     0.200
    13.433    31.610     0.200
    13.465    32.324     0.200
    13.798    34.317     0.200
    13.809    34.211     0.200
    13.891    34.378     0.200
    13.955    31.789     0.200
    14.022    34.252     0.200
    13.999    32.551     0.200
    14.090    32.852     0.200
    14.220    33.292     0.200
    14.211    31.441     0.200
    14.373    32.663     0.200
    14.455    32.063     0.200
    14.488    32.694     0.200
    14.475    31.895     0.200
    14.632    33.738     0.200
    14.614    34.193     0.200
    14.721    33.169     0.200
    14.813    33.144     0.200
    14.820    32.375     0.200
    14.896    32.552     0.200
    14.908    31.356     0.200
    14.876    33.772     0.200
    14.948    34.803     0.200
    14.944    33.426     0.200
    14.923    34.453     0.200
    15.078    34.616     0.200
    15.043    34.664     0.200
    15.245    34.859     0.200
    15.251    34.570     0.200
    15.446    35.991     0.200
    15.744    36.228     0.200
    15.755    35.595     0.200
    15.886    34.150     0.200
    15.895    35.050     0.200
    15.838    36.001     0.200
    15.974    35.613     0.200
    16.037    35.500     0.200
    16.103    35.465     0.200
    16.133    33.729     0.200
    16.153    35.918     0.200
    16.251    35.657     0.200
    16.412    35.864     0.200
    16.521    36.735     0.200
    16.710    36.937     0.200
    16.826    36.954     0.200
    16.879    36.331     0.200
    16.883    35.935     0.200
    17.028    35.139     0.200
    17.062    35.328     0.200
    17.171    36.267     0.200
    17.250    36.212     0.200
    17.293    33.932     0.200
    17.293    35.174     0.200
    17.384    35.922     0.200
    17.528    35.182     0.200
    17.642    35.616     0.200
    18.089    36.029     0.200
    19.544    38.336     0.200
     0.687     5.453     0.200
     0.704     4.995     0.200
     0.702     4.907     0.200
     0.779     6.853     0.200
     0.907     7.333     0.200
     0.922     7.218     0.200
     0.969     7.677     0.200
     1.025     7.878     0.200
     1.570     8.063     0.200
     1.718     8.856     0.200
     1.747     9.397     0.200
     1.748     9.311     0.200
     1.748     9.010     0.200
     2.548    10.392     0.200
     2.704    11.175     0.200
     3.164    11.201     0.200
     3.142    14.049     0.200
     3.744    12.927     0.200
     3.849    13.767     0.200
     3.894    13.469     0.200
     3.966    13.446     0.200
     4.184    12.966     0.200
     4.184    13.078     0.200
     4.495    14.023     0.200
     4.495    14.414     0.200
     4.532    13.901     0.200
     4.532    14.066     0.200
     4.587    14.317     0.200
     4.587    14.532     0.200
     4.581    14.673     0.200
     4.601    15.241     0.200
     4.617    14.554     0.200
     4.650    14.849     0.200
     4.476    16.886     0.200
     4.809    15.534     0.200
     4.917    13.856     0.200
     4.968    15.224     0.200
     5.085    15.685     0.200
     5.088    15.777     0.200
     5.106    16.500     0.200
     5.133    15.066     0.200
     5.133    15.210     0.200
     5.275    15.800     0.200
     5.275    16.055     0.200
     5.478    16.096     0.200
     5.510    16.604     0.200
     5.510    16.434     0.200
     5.524    14.868     0.200
     5.524    15.174     0.200
     5.605    16.932     0.200
     5.605    17.162     0.200
     5.640    19.387     0.200
     5.903    17.611     0.200
     5.903    17.445     0.200
     5.907    17.930     0.200
     5.907    17.602     0.200
     5.877    19.075     0.200
     5.996    18.210     0.200
     6.026    16.886     0.200
     6.115    17.469     0.200
     6.166    17.713     0.200
     6.166    17.602     0.200
     6.428    18.345     0.200
     6.428    18.100     0.200
     6.414    18.378     0.200
     6.449    17.844     0.200
     6.529    18.275     0.200
     6.529    19.442     0.200
     6.555    18.678     0.200
     6.555    18.886     0.200
     6.726    18.922     0.200
     6.750    18.938     0.200
     6.750    18.733     0.200
     6.793    19.047     0.200
     6.962    19.295     0.200
     6.973    19.305     0.200
     7.003    20.573     0.200
     7.022    18.706     0.200
     7.032    20.728     0.200
     7.078    18.997     0.200
     7.105    18.777     0.200
     7.214    19.504     0.200
     7.309    19.630     0.200
     7.414    19.134     0.200
     7.442    18.984     0.200
     7.548    20.655     0.200
     7.582    20.220     0.200
     7.640    20.571     0.200
     7.852    20.834     0.200
     7.852    21.234     0.200
     7.914    21.080     0.200
     7.957    20.992     0.200
     7.960    22.602     0.200
     7.977    22.327     0.200
     8.130    21.868     0.200
     8.156    21.231     0.200
     8.174    21.074     0.200
     8.174    21.262     0.200
     8.214    21.495     0.200
     8.258    23.686     0.200
     8.306    21.036     0.200
     8.251    23.801     0.200
     8.345    23.978     0.200
     8.358    23.845     0.200
     8.388    23.867     0.200
     8.625    22.100     0.200
     8.625    21.955     0.200
     8.697    21.955     0.200
     8.697    23.023     0.200
     8.781    21.934     0.200
     8.781    21.524     0.200
     8.775    23.032     0.200
     8.775    23.918     0.200
     8.971    21.972     0.200
     8.971    22.222     0.200
     9.035    22.780     0.200
     9.048    22.553     0.200
     9.048    22.796     0.200
     9.071    22.072     0.200
     9.071    22.631     0.200
     9.179    23.176     0.200
     9.229    23.238     0.200
     9.229    23.755     0.200
     9.254    24.129     0.200
     9.352    23.194     0.200
     9.352    23.368     0.200
     9.354    25.737     0.200
     9.375    23.018     0.200
     9.375    23.685     0.200
     9.425    25.013     0.200
     9.450    22.825     0.200
     9.562    23.066     0.200
     9.575    22.581     0.200
     9.575    22.841     0.200
     9.681    23.858     0.200
     9.681    23.182     0.200
     9.696    23.868     0.200
     9.696    24.461     0.200
     9.510    25.965     0.200
     9.756    22.573     0.200
     9.826    24.417     0.200
     9.826    25.177     0.200
     9.888    24.498     0.200
     9.779    26.620     0.200
     9.962    23.508     0.200
     9.962    23.949     0.200
    10.011    24.839     0.200
    10.059    24.392     0.200
    10.059    24.625     0.200
    10.093    25.108     0.200
    10.093    25.426     0.200
     9.930    28.004     0.200
     9.930    27.254     0.200
    10.177    26.474     0.200
    10.176    26.033     0.200
    10.176    25.682     0.200
    10.219    25.640     0.200
    10.234    24.469     0.200
    10.251    23.621     0.200
    10.279    25.634     0.200
    10.293    25.332     0.200
    10.299    27.001     0.200
    10.278    25.309     0.200
    10.324    23.818     0.200
    10.209    28.738     0.200
    10.392    24.889     0.200
    10.392    24.524     0.200
    10.411    24.203     0.200
    10.468    25.708     0.200
    10.569    26.212     0.200
    10.569    25.836     0.200
    10.620    26.568     0.200
    10.656    24.922     0.200
    10.658    25.104     0.200
    10.677    26.308     0.200
    10.771    26.537     0.200
    10.851    26.941     0.200
    10.878    23.994     0.200
    10.878    25.042     0.200
    10.892    25.670     0.200
    10.892    26.482     0.200
    10.984    26.408     0.200
    11.085    26.117     0.200
    11.165    26.150     0.200
    11.226    27.163     0.200
    11.221    28.618     0.200
    11.221    27.782     0.200
    11.219    26.932     0.200
    11.219    26.553     0.200
    11.295    27.064     0.200
    11.397    27.669     0.200
    11.453    26.040     0.200
    11.465    29.162     0.200
    11.517    27.880     0.200
    11.541    27.949     0.200
    11.530    27.098     0.200
    11.636    28.197     0.200
    11.685    27.840     0.200
    11.798    29.019     0.200
    11.798    28.599     0.200
    11.845    28.475     0.200
    11.901    28.579     0.200
    11.927    27.900     0.200
    11.967    29.089     0.200
    11.976    26.407     0.200
    12.048    27.956     0.200
    12.082    26.784     0.200
    12.082    25.913     0.200
    12.150    29.528     0.200
    12.168    28.283     0.200
    12.267    26.133     0.200
    12.267    26.333     0.200
    12.274    29.747     0.200
    12.297    28.966     0.200
    12.381    29.495     0.200
    12.384    29.382     0.200
    12.449    29.374     0.200
    12.458    29.224     0.200
    12.474    29.886     0.200
    12.543    29.258     0.200
    12.595    27.798     0.200
    12.431    32.050     0.200
    12.639    30.420     0.200
    12.780    30.777     0.200
    12.804    29.980     0.200
    12.848    30.668     0.200
    12.855    29.737     0.200
    12.874    28.938     0.200
    12.926    31.194     0.200
    12.917    30.451     0.200
    12.919    30.838     0.200
    13.052    31.887     0.200
    13.059    31.581     0.200
    13.131    31.215     0.200
    13.161    31.396     0.200
    13.210    30.662     0.200
    13.279    31.431     0.200
    13.453    32.705     0.200
    13.413    31.848     0.200
    13.445    32.484     0.200
    13.446    31.988     0.200
    13.498    32.330     0.200
    13.558    31.427     0.200
    13.652    31.311     0.200
    13.788    33.329     0.200
    13.803    33.135     0.200
    13.813    32.593     0.200
    13.884    33.734     0.200
    13.914    33.299     0.200
    13.900    32.540     0.200
    13.935    31.935     0.200
    14.014    35.449     0.200
    14.014    33.742     0.200
    14.025    33.312     0.200
    13.979    32.520     0.200
    14.069    33.119     0.200
    14.134    33.742     0.200
    14.163    33.026     0.200
    14.209    34.039     0.200
    14.192    32.986     0.200
    14.253    32.157     0.200
    14.312    32.336     0.200
    14.353    32.190     0.200
    14.404    32.650     0.200
    14.438    31.940     0.200
    14.482    32.517     0.200
    14.468    32.877     0.200
    14.454    33.147     0.200
    14.618    33.151     0.200
    14.593    33.233     0.200
    14.701    32.690     0.200
    14.751    31.710     0.200
    14.781    33.314     0.200
    14.798    32.291     0.200
    14.800    33.336     0.200
    14.879    31.865     0.200
    14.891    31.460     0.200
    14.855    33.732     0.200
    14.935    34.028     0.200
    14.926    33.515     0.200
    14.903    34.011     0.200
    14.952    32.928     0.200
    15.065    33.428     0.200
    15.023    34.352     0.200
    15.229    34.328     0.200
    15.235    34.643     0.200
    15.244    34.049     0.200
    15.249    34.116     0.200
    15.465    34.333     0.200
    15.426    34.706     0.200
    15.517    34.124     0.200
    15.636    34.676     0.200
    15.725    34.758     0.200
    15.735    35.049     0.200
    15.869    34.549     0.200
    15.882    34.583     0.200
    15.818    35.421     0.200
    15.954    35.100     0.200
    15.984    35.162     0.200
    16.019    34.867     0.200
    16.052    34.105     0.200
    16.089    34.296     0.200
    16.112    35.083     0.200
    16.132    35.160     0.200
    16.235    34.247     0.200
    16.294    34.415     0.200
    16.395    34.828     0.200
    16.503    34.947     0.200
    16.577    35.347     0.200
    16.698    35.650     0.200
    16.690    36.607     0.200
    16.798    34.866     0.200
    16.805    35.017     0.200
    16.865    34.737     0.200
    16.869    34.743     0.200
    17.010    34.487     0.200
    17.044    35.405     0.200
    17.069    35.400     0.200
    17.175    35.180     0.200
    17.151    35.671     0.200
    17.230    35.469     0.200
    17.272    35.344     0.200
    17.368    34.931     0.200
    17.511    34.947     0.200
    17.625    35.236     0.200
    18.072    34.502     0.200
     0.382     5.367     0.200
     0.477     5.809     0.200
     0.855     6.015     0.200
     0.880     6.279     0.200
     1.040     6.907     0.200
     1.094     7.302     0.200
     1.094     7.452     0.200
     1.197     7.504     0.200
     1.216     7.603     0.200
     1.320     6.821     0.200
     1.251     7.814     0.200
     1.250     7.771     0.200
     1.275     7.985     0.200
     1.472     8.453     0.200
     1.956     8.740     0.200
     2.396     8.776     0.200
     2.385    10.718     0.200
     2.512    11.311     0.200
     2.593    11.180     0.200
     2.971    11.163     0.200
     3.120    11.572     0.200
     3.388    10.196     0.200
     3.794    12.859     0.200
     3.691    13.299     0.200
     3.860    13.008     0.200
     3.921    13.350     0.200
     3.828    14.342     0.200
     4.017    13.356     0.200
     3.991    11.799     0.200
     4.174    13.025     0.200
     4.157    13.020     0.200
     4.293    13.617     0.200
     4.305    13.692     0.200
     4.196    14.526     0.200
     4.492    14.473     0.200
     4.713    12.915     0.200
     4.713    13.171     0.200
     5.255    16.006     0.200
     5.315    16.022     0.200
     5.585    16.222     0.200
     5.700    15.859     0.200
     5.855    16.607     0.200
     5.949    17.136     0.200
     5.953    17.231     0.200
     6.272    18.020     0.200
     6.301    17.073     0.200
     6.221    18.103     0.200
     6.258    17.607     0.200
     6.334    17.613     0.200
     6.534    17.485     0.200
     6.630    18.194     0.200
     7.182    18.838     0.200
     7.214    19.162     0.200
     7.334    19.744     0.200
     7.442    19.914     0.200
     7.576    19.544     0.200
     7.906    20.053     0.200
     8.231    20.126     0.200
     8.269    20.562     0.200
     8.431    22.050     0.200
     8.581    21.037     0.200
     8.629    23.248     0.200
     8.752    21.146     0.200
     8.732    21.961     0.200
     8.947    20.731     0.200
     9.265    21.127     0.200
     9.588    22.326     0.200
    10.010    23.524     0.200
    10.416    24.942     0.200
    10.486    25.411     0.200
    10.805    25.198     0.200
    10.821    26.052     0.200
    11.001    26.262     0.200
    11.056    26.381     0.200
    11.207    23.628     0.200
    11.220    22.834     0.200
    11.469    27.293     0.200
    11.515    23.610     0.200
    11.667    26.890     0.200
    12.054    26.337     0.200
    12.353    30.120     0.200
    13.125    30.167     0.200
    13.200    29.040     0.200
    13.891    31.884     0.200
    13.957    30.590     0.200
    14.419    32.203     0.200
    14.991    32.700     0.200
    16.741    36.344     0.200
    17.843    34.489     0.200
    17.843    33.899     0.200
     0.419     4.792     0.200
     0.662     5.935     0.200
     0.820     5.957     0.200
     1.017     7.178     0.200
     1.081     6.936     0.200
     1.081     7.445     0.200
     1.210     5.835     0.200
     1.386     7.970     0.200
     1.408     7.668     0.200
     1.443     8.007     0.200
     1.447     8.059     0.200
     1.469     8.308     0.200
     1.533     8.625     0.200
     1.701     7.813     0.200
     1.669     8.742     0.200
     1.689     8.536     0.200
     1.849     7.999     0.200
     1.868     8.076     0.200
     2.204     7.866     0.200
     2.582    11.104     0.200
     2.709    11.548     0.200
     2.859    10.313     0.200
     2.936    10.647     0.200
     3.005    10.538     0.200
     3.106    10.742     0.200
     3.205     9.816     0.200
     3.669    12.169     0.200
     3.728    11.938     0.200
     3.732    11.817     0.200
     3.772    12.263     0.200
     3.794    12.270     0.200
     3.887    12.549     0.200
     3.899    12.545     0.200
     3.935    11.017     0.200
     3.885    14.381     0.200
     3.916    13.642     0.200
     3.983    12.615     0.200
     3.986    14.132     0.200
     3.988    14.370     0.200
     3.994    14.205     0.200
     4.042    12.528     0.200
     4.014    14.648     0.200
     4.023    14.919     0.200
     4.052    14.380     0.200
     4.162    13.026     0.200
     4.183    13.520     0.200
     4.183    13.588     0.200
     4.213    13.259     0.200
     4.293    13.020     0.200
     4.389    15.000     0.200
     4.444    13.608     0.200
     4.476    14.831     0.200
     4.545    11.856     0.200
     4.545    12.416     0.200
     4.545    12.676     0.200
     4.613    15.470     0.200
     4.730    14.337     0.200
     4.746    14.224     0.200
     4.888    14.906     0.200
     4.985    15.064     0.200
     5.158    15.243     0.200
     5.285    15.689     0.200
     5.413    16.990     0.200
     5.451    15.156     0.200
     5.543    15.841     0.200
     5.636    16.890     0.200
     5.674    15.649     0.200
     5.725    16.239     0.200
     5.782    16.399     0.200
     5.828    15.858     0.200
     5.831    16.408     0.200
     5.829    16.821     0.200
     5.894    16.543     0.200
     6.067    16.887     0.200
     6.156    15.590     0.200
     6.179    17.509     0.200
     6.288    16.918     0.200
     6.286    17.291     0.200
     6.325    17.678     0.200
     6.358    17.724     0.200
     6.347    18.208     0.200
     6.392    17.762     0.200
     6.418    17.870     0.200
     6.395    18.547     0.200
     6.447    15.630     0.200
     6.453    17.604     0.200
     6.491    16.615     0.200
     6.521    17.486     0.200
     6.517    17.719     0.200
     6.561    18.070     0.200
     6.580    17.520     0.200
     6.963    18.719     0.200
     7.046    18.976     0.200
     7.086    18.999     0.200
     7.089    19.019     0.200
     7.113    18.159     0.200
     7.161    18.940     0.200
     7.197    18.036     0.200
     7.192    19.262     0.200
     7.213    19.252     0.200
     7.221    18.581     0.200
     7.286    19.841     0.200
     7.360    20.061     0.200
     7.368    19.250     0.200
     7.434    19.867     0.200
     7.545    19.849     0.200
     7.774    19.657     0.200
     7.863    20.088     0.200
     7.913    20.528     0.200
     8.002    19.819     0.200
     8.126    20.275     0.200
     8.138    20.005     0.200
     8.122    20.732     0.200
     8.210    20.808     0.200
     8.338    20.145     0.200
     8.385    21.949     0.200
     8.446    20.910     0.200
     8.536    20.884     0.200
     8.565    20.942     0.200
     8.595    20.779     0.200
     8.604    20.807     0.200
     8.621    21.038     0.200
     8.728    22.891     0.200
     8.761    21.344     0.200
     8.795    20.716     0.200
     8.961    21.749     0.200
     8.994    21.703     0.200
     9.006    22.707     0.200
     9.129    21.478     0.200
     9.293    21.741     0.200
     9.299    22.749     0.200
     9.351    22.280     0.200
     9.363    23.484     0.200
     9.381    22.450     0.200
     9.442    22.415     0.200
     9.436    21.851     0.200
     9.449    21.972     0.200
     9.505    21.804     0.200
     9.565    23.300     0.200
     9.642    23.305     0.200
     9.691    23.235     0.200
     9.722    22.998     0.200
     9.760    24.702     0.200
     9.797    22.353     0.200
     9.818    23.032     0.200
     9.913    23.862     0.200
     9.981    22.454     0.200
     9.984    24.734     0.200
    10.028    23.162     0.200
    10.036    23.684     0.200
    10.084    24.497     0.200
    10.262    24.400     0.200
    10.283    24.887     0.200
    10.306    24.597     0.200
    10.321    25.954     0.200
    10.446    25.667     0.200
    10.533    24.346     0.200
    10.638    25.778     0.200
    10.729    26.469     0.200
    10.723    26.359     0.200
    10.836    25.289     0.200
    10.844    27.115     0.200
    11.009    26.451     0.200
    11.143    26.878     0.200
    11.240    23.940     0.200
    11.260    26.047     0.200
    11.315    26.731     0.200
    11.408    23.975     0.200
    11.517    26.723     0.200
    11.564    27.565     0.200
    12.832    29.978     0.200
    13.250    29.287     0.200
    13.373    28.856     0.200
    13.476    29.153     0.200
    13.501    30.041     0.200
    13.614    31.749     0.200
    13.608    30.979     0.200
    14.041    32.328     0.200
    14.446    33.834     0.200
    14.660    34.095     0.200
    14.893    33.837     0.200
    15.410    35.419     0.200
    16.114    36.243     0.200
    16.175    36.014     0.200
    16.301    35.573     0.200
    16.621    36.363     0.200
    17.724    34.490     0.200
    17.724    35.519     0.200
     1.892    10.387     0.200
     1.784    11.411     0.200
     1.925    10.453     0.200
     1.925    10.222     0.200
     1.895    11.868     0.200
     1.905    11.178     0.200
     2.254    10.758     0.200
     2.709    11.740     0.200
     2.956    15.376     0.200
     3.055    14.862     0.200
     3.059    14.759     0.200
     3.083    14.657     0.200
     3.104    15.565     0.200
     3.237    12.314     0.200
     3.435    13.848     0.200
     3.661    15.663     0.200
     3.900    14.400     0.200
     3.998    14.846     0.200
     4.050    14.472     0.200
     4.128    15.141     0.200
     4.275    14.634     0.200
     4.724    15.440     0.200
     4.769    16.345     0.200
     4.781    15.729     0.200
     4.799    16.458     0.200
     4.798    16.623     0.200
     4.859    16.681     0.200
     4.956    17.192     0.200
     5.021    15.235     0.200
     5.232    17.403     0.200
     5.241    17.304     0.200
     5.277    17.239     0.200
     5.285    17.363     0.200
     5.318    17.175     0.200
     5.658    17.662     0.200
     5.637    16.333     0.200
     5.637    16.630     0.200
     5.703    17.840     0.200
     5.769    18.320     0.200
     6.098    19.003     0.200
     6.164    19.458     0.200
     6.309    19.396     0.200
     6.349    19.628     0.200
     6.595    20.274     0.200
     6.619    19.733     0.200
     6.694    20.386     0.200
     6.733    20.441     0.200
     6.881    20.288     0.200
     6.886    21.034     0.200
     6.944    20.528     0.200
     7.149    20.940     0.200
     7.174    21.264     0.200
     7.271    21.123     0.200
     7.336    21.666     0.200
     7.372    21.677     0.200
     7.398    21.723     0.200
     7.490    21.738     0.200
     7.497    21.781     0.200
     7.571    21.607     0.200
     7.773    21.316     0.200
     7.835    21.882     0.200
     8.038    22.387     0.200
     8.078    22.754     0.200
     8.113    22.862     0.200
     8.120    22.676     0.200
     8.274    23.222     0.200
     8.310    22.699     0.200
     8.347    22.565     0.200
     8.407    22.699     0.200
     8.973    23.306     0.200
     9.095    23.795     0.200
     9.211    24.112     0.200
     9.423    25.232     0.200
     9.601    24.995     0.200
     9.688    24.936     0.200
     9.886    24.401     0.200
    10.087    25.027     0.200
    10.205    25.540     0.200
    10.487    27.809     0.200
    10.965    28.859     0.200
    11.414    30.238     0.200
    12.031    31.071     0.200
    12.433    27.884     0.200
    12.567    32.005     0.200
    12.995    30.787     0.200
    13.014    30.944     0.200
    13.506    33.867     0.200
    15.251    36.261     0.200
    17.348    38.827     0.200
    17.534    38.510     0.200
     0.488     5.562     0.200
     0.488     5.452     0.200
     0.631     6.539     0.200
     0.724     6.768     0.200
     0.724     6.739     0.200
     0.841     7.494     0.200
     0.843     7.132     0.200
     0.848     6.792     0.200
     1.403     7.473     0.200
     1.537     8.390     0.200
     1.560     8.619     0.200
     1.562     8.619     0.200
     1.695     9.507     0.200
     1.822     9.697     0.200
     1.900     9.721     0.200
     1.962     8.792     0.200
     1.962     8.476     0.200
     2.537    10.487     0.200
     2.931    12.051     0.200
     2.973    11.857     0.200
     3.004    11.938     0.200
     3.120     9.412     0.200
     3.120     9.814     0.200
     3.069    12.038     0.200
     3.074    12.188     0.200
     3.114    12.356     0.200
     3.142    12.298     0.200
     3.474    12.696     0.200
     3.700    12.732     0.200
     3.700    13.005     0.200
     3.798    13.064     0.200
     4.114    11.669     0.200
     4.114    11.903     0.200
     4.313    13.171     0.200
     4.337    13.046     0.200
     4.359    14.270     0.200
     4.359    13.746     0.200
     4.423    14.080     0.200
     4.430    14.219     0.200
     4.416    14.163     0.200
     4.416    13.699     0.200
     4.501    13.992     0.200
     4.497    15.499     0.200
     4.560    14.588     0.200
     4.662    14.940     0.200
     4.828    12.572     0.200
     4.828    12.704     0.200
     4.822    14.613     0.200
     4.922    14.860     0.200
     4.933    14.951     0.200
     4.927    15.333     0.200
     4.927    14.267     0.200
     5.046    15.261     0.200
     5.281    15.633     0.200
     5.281    15.110     0.200
     5.288    15.537     0.200
     5.422    13.646     0.200
     5.422    13.927     0.200
     5.422    14.337     0.200
     5.433    16.087     0.200
     5.433    16.360     0.200
     5.688    16.639     0.200
     5.678    17.019     0.200
     5.736    17.589     0.200
     5.818    16.742     0.200
     5.800    16.161     0.200
     5.887    16.904     0.200
     5.962    16.719     0.200
     6.210    17.505     0.200
     6.193    17.809     0.200
     6.193    17.703     0.200
     6.294    16.408     0.200
     6.354    18.209     0.200
     6.354    18.553     0.200
     6.361    17.921     0.200
     6.521    18.274     0.200
     6.572    18.683     0.200
     6.753    18.790     0.200
     6.753    18.571     0.200
     6.816    18.998     0.200
     6.816    18.494     0.200
     6.795    17.957     0.200
     6.820    19.356     0.200
     6.857    18.917     0.200
     6.857    18.253     0.200
     6.891    18.861     0.200
     6.891    18.381     0.200
     7.110    19.753     0.200
     7.110    18.980     0.200
     7.173    20.306     0.200
     7.308    17.916     0.200
     7.319    19.728     0.200
     7.366    19.435     0.200
     7.366    19.204     0.200
     7.413    19.741     0.200
     7.644    20.323     0.200
     7.644    19.706     0.200
     7.772    21.312     0.200
     7.790    21.417     0.200
     7.790    21.694     0.200
     7.819    18.947     0.200
     7.823    21.180     0.200
     7.918    21.265     0.200
     7.933    20.898     0.200
     7.938    20.413     0.200
     7.984    20.704     0.200
     7.985    20.916     0.200
     8.041    20.131     0.200
     8.074    21.745     0.200
     8.074    22.897     0.200
     8.135    21.539     0.200
     8.159    21.128     0.200
     8.258    22.028     0.200
     8.352    22.889     0.200
     8.363    21.854     0.200
     8.400    21.324     0.200
     8.397    22.075     0.200
     8.545    21.377     0.200
     8.545    20.498     0.200
     8.560    21.222     0.200
     8.560    20.780     0.200
     8.601    21.976     0.200
     8.601    23.011     0.200
     8.853    21.038     0.200
     8.836    22.359     0.200
     8.836    22.090     0.200
     8.872    21.797     0.200
     8.932    21.469     0.200
     9.004    22.380     0.200
     9.077    22.478     0.200
     9.082    21.798     0.200
     9.099    22.512     0.200
     9.099    22.207     0.200
     9.153    22.502     0.200
     9.167    23.283     0.200
     9.227    22.353     0.200
     9.227    22.072     0.200
     9.250    22.658     0.200
     9.294    22.101     0.200
     9.306    22.315     0.200
     9.441    22.152     0.200
     9.443    21.904     0.200
     9.487    23.712     0.200
     9.528    21.918     0.200
     9.636    23.824     0.200
     9.636    24.195     0.200
     9.739    23.251     0.200
     9.783    24.265     0.200
     9.842    23.117     0.200
     9.889    24.244     0.200
     9.889    24.514     0.200
     9.912    23.817     0.200
     9.947    24.926     0.200
     9.947    24.680     0.200
     9.931    25.905     0.200
     9.983    24.857     0.200
    10.066    23.716     0.200
    10.069    24.622     0.200
    10.118    23.903     0.200
    10.158    23.100     0.200
    10.175    23.609     0.200
    10.256    23.822     0.200
    10.256    23.681     0.200
    10.252    23.023     0.200
    10.208    26.832     0.200
    10.239    25.358     0.200
    10.349    25.195     0.200
    10.413    25.158     0.200
    10.490    24.882     0.200
    10.458    26.201     0.200
    10.458    25.314     0.200
    10.511    24.551     0.200
    10.536    24.253     0.200
    10.544    25.496     0.200
    10.626    25.943     0.200
    10.715    23.869     0.200
    10.715    25.077     0.200
    10.853    25.316     0.200
    10.869    25.881     0.200
    10.936    26.433     0.200
    10.992    26.390     0.200
    11.015    26.755     0.200
    11.074    25.466     0.200
    11.073    26.158     0.200
    11.107    25.457     0.200
    11.197    27.503     0.200
    11.236    27.696     0.200
    11.300    26.545     0.200
    11.323    26.750     0.200
    11.357    26.184     0.200
    11.409    26.249     0.200
    11.418    26.586     0.200
    11.572    27.876     0.200
    11.572    27.161     0.200
    11.636    27.588     0.200
    11.737    26.318     0.200
    11.738    25.869     0.200
    11.743    27.197     0.200
    11.802    25.857     0.200
    11.901    25.621     0.200
    11.901    26.289     0.200
    11.901    26.145     0.200
    11.912    26.590     0.200
    11.950    28.131     0.200
    12.009    27.875     0.200
    12.054    28.677     0.200
    12.090    25.316     0.200
    12.112    27.995     0.200
    12.171    29.621     0.200
    12.204    27.366     0.200
    12.202    27.309     0.200
    12.222    29.291     0.200
    12.265    28.474     0.200
    12.342    28.969     0.200
    12.425    26.897     0.200
    12.440    28.212     0.200
    12.423    29.835     0.200
    12.555    31.016     0.200
    12.660    30.704     0.200
    12.685    28.828     0.200
    12.715    28.995     0.200
    12.733    27.353     0.200
    12.788    28.945     0.200
    12.809    29.799     0.200
    12.841    31.230     0.200
    12.854    30.548     0.200
    12.932    30.341     0.200
    13.033    29.501     0.200
    13.069    29.827     0.200
    13.170    30.054     0.200
    13.226    32.096     0.200
    13.289    31.625     0.200
    13.333    30.421     0.200
    13.337    30.846     0.200
    13.344    30.152     0.200
    13.356    30.930     0.200
    13.460    29.873     0.200
    13.569    30.607     0.200
    13.574    30.977     0.200
    13.656    32.710     0.200
    13.715    31.270     0.200
    13.692    31.638     0.200
    13.813    30.801     0.200
    13.813    30.660     0.200
    13.788    33.783     0.200
    13.788    32.588     0.200
    13.837    31.537     0.200
    13.927    30.551     0.200
    13.949    32.293     0.200
    13.994    32.308     0.200
    13.990    33.038     0.200
    14.056    31.473     0.200
    14.086    30.973     0.200
    14.168    30.737     0.200
    14.200    32.447     0.200
    14.223    30.919     0.200
    14.272    30.720     0.200
    14.258    32.467     0.200
    14.374    31.601     0.200
    14.417    31.057     0.200
    14.417    32.073     0.200
    14.519    31.793     0.200
    14.581    31.564     0.200
    14.569    30.877     0.200
    14.564    31.859     0.200
    14.606    30.859     0.200
    14.697    31.472     0.200
    14.708    30.570     0.200
    14.731    30.219     0.200
    14.730    33.915     0.200
    14.789    32.518     0.200
    14.812    32.893     0.200
    14.806    32.521     0.200
    14.847    32.512     0.200
    14.856    33.490     0.200
    14.932    32.657     0.200
    15.042    32.511     0.200
    15.032    32.983     0.200
    15.050    32.597     0.200
    15.059    32.010     0.200
    15.244    34.259     0.200
    15.312    33.780     0.200
    15.351    33.632     0.200
    15.351    34.145     0.200
    15.525    33.582     0.200
    15.583    33.669     0.200
    15.672    33.576     0.200
    15.711    33.628     0.200
    15.706    32.937     0.200
    15.804    34.176     0.200
    15.836    33.603     0.200
    15.871    34.043     0.200
    15.870    33.795     0.200
    15.889    33.678     0.200
    15.889    34.061     0.200
    16.047    33.676     0.200
    16.051    33.695     0.200
    16.103    35.924     0.200
    16.103    32.909     0.200
    16.118    33.547     0.200
    16.228    34.102     0.200
    16.343    33.752     0.200
    16.675    34.699     0.200
    16.669    34.449     0.200
    16.669    35.226     0.200
    16.735    34.863     0.200
    16.846    33.667     0.200
    16.894    34.293     0.200
    16.887    34.975     0.200
    16.986    35.521     0.200
    17.191    35.641     0.200
    17.191    34.957     0.200
    17.215    34.935     0.200
    17.343    35.206     0.200
    17.465    33.651     0.200
    17.599    34.725     0.200
    17.909    34.036     0.200
     0.337     4.199     0.200
     0.459     5.085     0.200
     1.017     7.072     0.200
     1.042     7.138     0.200
     1.046     7.028     0.200
     1.070     7.193     0.200
     1.183     6.678     0.200
     1.186     6.755     0.200
     1.179     7.706     0.200
     1.351     7.761     0.200
     1.394     7.821     0.200
     1.682     7.848     0.200
     2.144     9.227     0.200
     2.107    10.932     0.200
     2.302     9.801     0.200
     2.726     9.560     0.200
     3.563    12.160     0.200
     3.878    13.783     0.200
     4.159    13.205     0.200
     4.226    13.846     0.200
     4.227    13.228     0.200
     4.286    13.211     0.200
     4.272    14.040     0.200
     4.257    12.933     0.200
     4.383    13.605     0.200
     4.374    13.601     0.200
     4.469    12.381     0.200
     4.541    13.710     0.200
     4.659    14.160     0.200
     4.669    14.162     0.200
     4.712    14.259     0.200
     4.724    15.384     0.200
     4.801    14.520     0.200
     5.077    13.762     0.200
     5.072    15.058     0.200
     5.123    15.125     0.200
     5.205    15.188     0.200
     5.249    15.468     0.200
     5.605    15.969     0.200
     5.603    16.150     0.200
     5.758    16.989     0.200
     5.826    16.055     0.200
     6.137    17.137     0.200
     6.191    17.162     0.200
     6.358    17.832     0.200
     6.565    17.779     0.200
     6.618    18.392     0.200
     6.805    17.729     0.200
     6.956    18.556     0.200
     7.285    18.756     0.200
     7.417    19.784     0.200
     7.407    20.053     0.200
     7.524    18.933     0.200
     7.701    20.400     0.200
     7.772    20.910     0.200
     8.035    20.814     0.200
     8.379    21.177     0.200
     8.506    20.567     0.200
     8.638    21.978     0.200
     8.733    22.173     0.200
     9.120    22.331     0.200
     9.316    21.153     0.200
     9.370    23.269     0.200
     9.632    22.987     0.200
     9.750    23.664     0.200
     9.957    24.018     0.200
    10.036    23.759     0.200
    10.546    25.231     0.200
    11.870    23.501     0.200
    12.441    28.857     0.200
    13.493    30.252     0.200
    14.473    33.521     0.200
    15.985    34.769     0.200
    16.831    33.230     0.200
    18.203    36.637     0.200
     0.429     4.535     0.200
     0.656     5.943     0.200
     0.808     5.692     0.200
     1.004     6.645     0.200
     1.006     6.995     0.200
     1.069     7.325     0.200
     1.069     7.524     0.200
     1.201     5.768     0.200
     1.381     7.754     0.200
     1.403     7.985     0.200
     1.439     7.879     0.200
     1.443     7.835     0.200
     1.527     8.367     0.200
     1.691     7.513     0.200
     1.666     8.330     0.200
     1.858     7.600     0.200
     2.203     7.906     0.200
     2.579    11.078     0.200
     2.729    11.623     0.200
     2.997    10.563     0.200
     3.097    10.566     0.200
     3.203    10.401     0.200
     3.661    11.989     0.200
     3.721    12.221     0.200
     3.725    12.334     0.200
     3.786    12.317     0.200
     3.763    12.502     0.200
     3.880    12.383     0.200
     3.932    10.716     0.200
     3.888    12.821     0.200
     4.035    12.630     0.200
     3.971    12.540     0.200
     4.175    12.928     0.200
     4.206    12.870     0.200
     4.171    13.387     0.200
     4.284    13.640     0.200
     4.433    13.465     0.200
     4.541    11.926     0.200
     4.389    14.565     0.200
     4.737    14.094     0.200
     4.876    15.166     0.200
     4.973    15.628     0.200
     5.149    15.217     0.200
     5.624    17.061     0.200
     5.772    16.325     0.200
     5.713    16.451     0.200
     5.820    16.458     0.200
     5.886    16.415     0.200
     6.150    15.942     0.200
     6.170    16.888     0.200
     6.317    17.780     0.200
     6.275    17.256     0.200
     6.350    17.567     0.200
     6.505    17.865     0.200
     6.551    17.869     0.200
     6.952    18.371     0.200
     7.190    18.313     0.200
     7.150    18.266     0.200
     7.180    18.652     0.200
     7.358    19.098     0.200
     7.426    19.555     0.200
     7.423    19.695     0.200
     7.851    20.179     0.200
     8.120    19.430     0.200
     8.110    20.550     0.200
     8.199    20.291     0.200
     8.374    21.417     0.200
     8.439    20.719     0.200
     8.529    21.499     0.200
     8.527    21.953     0.200
     8.590    21.418     0.200
     8.589    22.087     0.200
     8.754    21.104     0.200
     8.789    20.288     0.200
     8.716    22.115     0.200
     9.012    22.516     0.200
     8.995    22.401     0.200
     9.122    22.328     0.200
     9.353    23.263     0.200
     9.436    22.623     0.200
     9.498    22.561     0.200
     9.715    23.286     0.200
     9.748    24.338     0.200
     9.903    24.435     0.200
     9.973    24.011     0.200
    10.022    24.398     0.200
    10.257    24.470     0.200
    10.301    24.954     0.200
    10.435    25.605     0.200
    11.133    26.951     0.200
    11.904    27.356     0.200
    12.963    30.178     0.200
    15.496    33.731     0.200
    17.716    34.407     0.200
     1.153     8.385     0.200
     1.307     9.306     0.200
     1.294     9.023     0.200
     1.336     9.032     0.200
     1.309     9.208     0.200
     1.902    10.474     0.200
     1.943    11.801     0.200
     2.039    11.987     0.200
     2.123    11.982     0.200
     3.004    13.230     0.200
     3.048    13.535     0.200
     3.075    13.388     0.200
     3.154    13.704     0.200
     3.161    14.130     0.200
     3.173    13.662     0.200
     3.511    13.833     0.200
     3.511    14.161     0.200
     3.612    14.362     0.200
     3.736    14.712     0.200
     4.125    14.758     0.200
     4.188    15.146     0.200
     4.313    14.071     0.200
     4.313    13.911     0.200
     4.504    16.613     0.200
     4.718    15.598     0.200
     4.535    16.537     0.200
     4.787    15.598     0.200
     4.808    15.644     0.200
     4.858    16.162     0.200
     4.919    16.049     0.200
     4.923    15.991     0.200
     4.941    17.289     0.200
     4.987    17.051     0.200
     5.013    17.233     0.200
     5.077    15.159     0.200
     5.077    14.921     0.200
     5.078    16.433     0.200
     5.442    17.548     0.200
     5.512    18.205     0.200
     5.705    16.025     0.200
     5.648    18.972     0.200
     5.919    18.414     0.200
     6.301    19.771     0.200
     6.322    19.760     0.200
     6.342    20.670     0.200
     6.544    19.044     0.200
     6.729    19.913     0.200
     7.081    20.787     0.200
     7.182    21.110     0.200
     7.345    20.023     0.200
     7.337    21.781     0.200
     7.348    21.455     0.200
     7.680    20.066     0.200
     7.674    22.616     0.200
     8.388    23.266     0.200
     8.342    24.931     0.200
     8.423    23.016     0.200
     8.423    24.535     0.200
     8.966    24.476     0.200
     9.316    23.750     0.200
     9.529    24.900     0.200
     9.952    25.404     0.200
     9.977    24.202     0.200
    10.081    26.937     0.200
    10.630    26.930     0.200
    10.868    27.441     0.200
    10.913    27.532     0.200
    10.978    27.339     0.200
    11.442    28.597     0.200
    12.239    30.072     0.200
    12.584    27.804     0.200
    12.716    30.783     0.200
    13.100    31.201     0.200
    13.118    30.989     0.200
    14.498    32.719     0.200
    15.119    32.861     0.200
    17.354    38.982     0.200
    17.905    36.029     0.200
     1.142     8.625     0.200
     1.145     8.213     0.200
     1.551     8.101     0.200
     1.557     8.616     0.200
     1.595     8.857     0.200
     1.904     8.626     0.200
     2.362    10.478     0.200
     2.520    10.411     0.200
     2.923    10.545     0.200
     2.923    10.705     0.200
     3.164    14.105     0.200
     3.207    15.031     0.200
     3.308    13.991     0.200
     3.319    14.775     0.200
     3.551    13.122     0.200
     3.379    14.983     0.200
     3.723    13.728     0.200
     3.763    13.631     0.200
     3.781    13.468     0.200
     3.699    14.788     0.200
     3.947    12.603     0.200
     3.947    12.283     0.200
     3.848    15.534     0.200
     4.243    14.106     0.200
     4.301    14.199     0.200
     4.426    14.275     0.200
     4.448    14.219     0.200
     4.433    13.449     0.200
     4.473    14.379     0.200
     4.508    14.934     0.200
     4.524    14.181     0.200
     4.605    14.927     0.200
     4.684    13.301     0.200
     4.684    13.491     0.200
     4.634    17.059     0.200
     4.716    17.261     0.200
     4.934    15.487     0.200
     4.937    15.441     0.200
     4.738    17.053     0.200
     4.998    14.821     0.200
     5.219    15.555     0.200
     5.295    14.816     0.200
     5.295    14.611     0.200
     5.295    15.662     0.200
     5.328    16.114     0.200
     5.423    16.339     0.200
     5.420    16.243     0.200
     5.882    17.887     0.200
     5.947    16.424     0.200
     6.026    17.359     0.200
     5.881    19.694     0.200
     6.061    17.181     0.200
     6.040    19.477     0.200
     6.040    19.256     0.200
     6.251    18.276     0.200
     6.320    18.078     0.200
     6.348    18.388     0.200
     6.441    18.733     0.200
     6.532    18.697     0.200
     6.598    18.889     0.200
     6.705    18.478     0.200
     6.776    19.302     0.200
     6.834    18.407     0.200
     6.892    18.104     0.200
     6.956    17.932     0.200
     6.987    20.348     0.200
     6.981    18.710     0.200
     7.023    21.012     0.200
     7.148    20.869     0.200
     7.182    18.381     0.200
     7.222    19.835     0.200
     7.228    18.497     0.200
     7.470    19.442     0.200
     7.528    20.625     0.200
     7.574    20.637     0.200
     7.768    22.603     0.200
     7.818    22.012     0.200
     7.923    20.838     0.200
     7.959    20.747     0.200
     7.978    21.042     0.200
     8.047    20.915     0.200
     8.088    22.908     0.200
     8.091    21.973     0.200
     8.121    21.852     0.200
     8.173    21.628     0.200
     8.494    22.884     0.200
     8.545    22.268     0.200
     8.593    23.118     0.200
     8.683    21.669     0.200
     8.543    25.461     0.200
     8.748    22.168     0.200
     8.627    25.186     0.200
     8.627    24.975     0.200
     8.860    21.273     0.200
     8.925    22.612     0.200
     9.054    21.939     0.200
     9.170    22.076     0.200
     9.187    25.532     0.200
     9.245    23.766     0.200
     9.340    22.449     0.200
     9.360    22.422     0.200
     9.479    22.555     0.200
     9.537    21.659     0.200
     9.566    24.301     0.200
     9.663    25.178     0.200
     9.684    23.499     0.200
     9.740    23.595     0.200
     9.740    22.947     0.200
     9.854    24.014     0.200
     9.947    25.029     0.200
    10.034    24.231     0.200
    10.046    23.775     0.200
    10.125    25.425     0.200
    10.179    24.315     0.200
    10.144    25.162     0.200
    10.207    24.956     0.200
    10.168    28.206     0.200
    10.168    28.094     0.200
    10.437    24.926     0.200
    10.449    24.805     0.200
    10.469    25.848     0.200
    10.446    28.544     0.200
    10.685    26.443     0.200
    11.006    26.292     0.200
    11.052    26.965     0.200
    11.176    27.198     0.200
    11.713    28.274     0.200
    11.740    26.912     0.200
    11.908    29.896     0.200
    11.908    26.695     0.200
    11.908    27.586     0.200
    12.087    27.556     0.200
    12.663    29.086     0.200
    12.667    32.575     0.200
    13.388    30.620     0.200
    14.104    32.530     0.200
    14.213    31.998     0.200
    14.356    33.511     0.200
    14.734    35.016     0.200
    14.789    33.278     0.200
    17.032    37.218     0.200
     0.981     6.300     0.200
     1.255     6.078     0.200
     1.255     6.363     0.200
     1.536     7.961     0.200
     1.762     8.537     0.200
     1.701     9.108     0.200
     1.742     8.920     0.200
     1.753     8.999     0.200
     1.859     8.958     0.200
     1.777     9.325     0.200
     1.930     8.490     0.200
     1.847     9.709     0.200
     1.979     7.626     0.200
     1.979     7.766     0.200
     1.965     9.721     0.200
     1.981     9.467     0.200
     2.862    10.724     0.200
     2.911    11.101     0.200
     2.861    12.579     0.200
     3.003    10.845     0.200
     3.019    10.293     0.200
     3.019     9.793     0.200
     3.019     9.985     0.200
     3.037    11.311     0.200
     3.004    12.537     0.200
     3.126    11.342     0.200
     3.068    12.319     0.200
     3.491    11.544     0.200
     3.589    11.784     0.200
     3.637    11.657     0.200
     3.680    11.658     0.200
     3.695    11.764     0.200
     3.757    12.351     0.200
     3.778    11.044     0.200
     3.778    10.856     0.200
     3.807    12.202     0.200
     3.807    12.366     0.200
     3.844    12.184     0.200
     3.995    11.948     0.200
     3.996    12.833     0.200
     3.996    13.157     0.200
     4.117    12.518     0.200
     4.154    12.845     0.200
     4.162    12.734     0.200
     4.150    12.900     0.200
     4.150    13.083     0.200
     4.099    14.630     0.200
     4.142    14.588     0.200
     4.172    14.387     0.200
     4.335    13.441     0.200
     4.239    14.561     0.200
     4.243    14.695     0.200
     4.250    14.694     0.200
     4.271    14.778     0.200
     4.284    14.647     0.200
     4.407    11.966     0.200
     4.407    11.759     0.200
     4.407    12.189     0.200
     4.395    14.023     0.200
     4.395    13.538     0.200
     4.552    13.309     0.200
     4.552    13.696     0.200
     4.753    14.278     0.200
     4.639    14.885     0.200
     4.639    14.596     0.200
     4.807    14.286     0.200
     4.807    14.485     0.200
     4.730    15.329     0.200
     4.864    15.551     0.200
     5.101    15.258     0.200
     5.101    15.547     0.200
     5.155    15.300     0.200
     5.155    15.671     0.200
     5.178    15.155     0.200
     5.178    15.287     0.200
     5.417    16.159     0.200
     5.540    15.199     0.200
     5.540    15.676     0.200
     5.679    15.829     0.200
     5.679    16.208     0.200
     5.577    17.134     0.200
     5.724    16.387     0.200
     5.659    17.336     0.200
     5.838    16.402     0.200
     5.875    17.557     0.200
     5.933    16.860     0.200
     5.968    17.666     0.200
     5.968    17.181     0.200
     6.204    17.246     0.200
     6.204    17.746     0.200
     6.342    17.887     0.200
     6.390    17.749     0.200
     6.390    17.632     0.200
     6.607    18.159     0.200
     6.607    17.948     0.200
     6.629    18.466     0.200
     6.625    18.816     0.200
     6.666    18.141     0.200
     6.666    17.930     0.200
     6.770    17.725     0.200
     6.770    17.925     0.200
     6.720    19.309     0.200
     6.720    19.430     0.200
     6.720    19.075     0.200
     6.826    19.745     0.200
     6.906    21.168     0.200
     7.073    18.544     0.200
     7.089    18.940     0.200
     7.234    19.424     0.200
     7.255    19.071     0.200
     7.255    19.356     0.200
     7.377    19.664     0.200
     7.377    20.269     0.200
     7.425    19.735     0.200
     7.452    20.184     0.200
     7.452    20.317     0.200
     7.522    20.242     0.200
     7.522    20.531     0.200
     7.672    20.004     0.200
     7.672    20.183     0.200
     7.882    20.023     0.200
     7.907    20.135     0.200
     8.044    19.781     0.200
     8.044    20.511     0.200
     8.052    20.846     0.200
     8.075    20.938     0.200
     8.105    20.598     0.200
     8.105    20.762     0.200
     8.287    21.233     0.200
     8.287    21.318     0.200
     8.287    21.510     0.200
     8.351    20.922     0.200
     8.381    21.255     0.200
     8.479    20.761     0.200
     8.488    21.870     0.200
     8.525    20.622     0.200
     8.560    21.863     0.200
     8.560    21.516     0.200
     8.560    22.653     0.200
     8.560    22.125     0.200
     8.589    21.289     0.200
     8.659    21.402     0.200
     8.689    19.968     0.200
     8.705    21.901     0.200
     8.875    22.054     0.200
     8.875    21.913     0.200
     8.897    22.283     0.200
     8.892    22.787     0.200
     9.052    23.328     0.200
     9.052    23.211     0.200
     9.062    22.557     0.200
     9.062    22.827     0.200
     9.096    23.048     0.200
     9.152    22.379     0.200
     9.191    22.587     0.200
     9.250    22.586     0.200
     9.323    22.159     0.200
     9.351    22.680     0.200
     9.351    23.168     0.200
     9.408    23.022     0.200
     9.410    23.703     0.200
     9.433    24.025     0.200
     9.433    23.665     0.200
     9.433    22.923     0.200
     9.433    23.614     0.200
     9.461    23.003     0.200
     9.464    23.059     0.200
     9.575    22.769     0.200
     9.481    25.422     0.200
     9.496    24.220     0.200
     9.521    24.493     0.200
     9.533    24.832     0.200
     9.650    24.136     0.200
     9.650    23.444     0.200
     9.680    23.206     0.200
     9.565    24.700     0.200
     9.754    23.983     0.200
     9.754    24.362     0.200
     9.746    24.451     0.200
     9.746    24.639     0.200
     9.784    23.257     0.200
     9.912    24.505     0.200
     9.912    24.728     0.200
     9.929    24.108     0.200
     9.944    22.786     0.200
     9.944    24.168     0.200
     9.994    24.807     0.200
    10.030    23.571     0.200
    10.068    25.342     0.200
    10.068    25.006     0.200
    10.093    24.449     0.200
    10.112    24.240     0.200
    10.117    25.997     0.200
    10.117    25.735     0.200
    10.152    24.490     0.200
    10.188    24.920     0.200
    10.209    24.967     0.200
    10.283    25.842     0.200
    10.447    25.111     0.200
    10.474    24.773     0.200
    10.502    26.052     0.200
    10.500    25.995     0.200
    10.556    25.702     0.200
    10.634    26.030     0.200
    10.691    26.028     0.200
    10.694    25.403     0.200
    10.722    23.291     0.200
    10.765    25.746     0.200
    10.860    27.042     0.200
    10.860    27.589     0.200
    10.889    26.589     0.200
    10.967    26.701     0.200
    11.005    26.685     0.200
    11.023    26.766     0.200
    11.059    26.614     0.200
    11.044    27.562     0.200
    11.067    27.598     0.200
    11.095    24.239     0.200
    11.140    25.891     0.200
    11.141    26.585     0.200
    11.141    26.854     0.200
    11.151    26.659     0.200
    11.213    26.952     0.200
    11.102    27.771     0.200
    11.243    25.921     0.200
    11.243    24.667     0.200
    11.243    24.230     0.200
    11.246    27.512     0.200
    11.400    22.389     0.200
    11.416    27.124     0.200
    11.416    26.985     0.200
    11.450    27.428     0.200
    11.428    28.004     0.200
    11.468    28.351     0.200
    11.468    28.058     0.200
    11.379    28.264     0.200
    11.545    27.406     0.200
    11.575    27.612     0.200
    11.689    25.551     0.200
    11.702    26.221     0.200
    11.766    28.421     0.200
    11.805    28.364     0.200
    11.825    28.065     0.200
    11.813    28.997     0.200
    11.851    28.797     0.200
    12.014    28.984     0.200
    12.050    29.001     0.200
    12.110    29.783     0.200
    12.136    29.627     0.200
    12.163    29.335     0.200
    12.250    28.785     0.200
    12.250    29.535     0.200
    12.315    28.649     0.200
    12.327    30.938     0.200
    12.346    28.101     0.200
    12.420    28.377     0.200
    12.420    30.588     0.200
    12.421    30.131     0.200
    12.421    30.463     0.200
    12.455    30.354     0.200
    12.452    30.481     0.200
    12.675    30.389     0.200
    12.745    29.642     0.200
    12.794    29.272     0.200
    12.841    29.507     0.200
    12.828    30.742     0.200
    12.850    30.039     0.200
    12.868    30.065     0.200
    12.869    30.403     0.200
    12.877    29.990     0.200
    12.901    30.557     0.200
    13.069    30.997     0.200
    13.167    33.096     0.200
    13.167    31.780     0.200
    13.222    31.022     0.200
    13.256    29.368     0.200
    13.289    31.102     0.200
    13.294    30.498     0.200
    13.294    30.791     0.200
    13.290    32.004     0.200
    13.325    31.418     0.200
    13.424    31.523     0.200
    13.476    31.775     0.200
    13.509    31.461     0.200
    13.516    31.527     0.200
    13.610    31.328     0.200
    13.610    31.871     0.200
    13.591    32.451     0.200
    13.606    31.757     0.200
    13.601    32.065     0.200
    13.673    32.091     0.200
    13.673    31.982     0.200
    13.668    32.402     0.200
    13.669    32.507     0.200
    13.669    32.023     0.200
    13.593    32.034     0.200
    13.720    32.017     0.200
    13.724    31.785     0.200
    13.724    32.320     0.200
    13.729    31.794     0.200
    13.729    32.017     0.200
    13.791    33.389     0.200
    13.874    33.117     0.200
    13.874    32.691     0.200
    13.882    32.389     0.200
    13.882    32.686     0.200
    13.911    31.642     0.200
    13.913    31.837     0.200
    13.932    32.185     0.200
    13.936    32.686     0.200
    13.973    32.045     0.200
    14.016    32.691     0.200
    14.089    33.105     0.200
    14.256    33.303     0.200
    14.257    33.380     0.200
    14.272    33.134     0.200
    14.354    32.469     0.200
    14.423    32.018     0.200
    14.435    33.444     0.200
    14.435    32.702     0.200
    14.479    32.511     0.200
    14.522    33.227     0.200
    14.549    33.378     0.200
    14.637    33.199     0.200
    14.697    33.246     0.200
    14.727    33.514     0.200
    14.793    33.620     0.200
    14.841    33.593     0.200
    14.851    33.519     0.200
    14.921    33.768     0.200
    14.935    33.323     0.200
    14.945    33.509     0.200
    15.014    33.289     0.200
    15.011    33.738     0.200
    15.222    33.679     0.200
    15.272    33.661     0.200
    15.379    32.941     0.200
    15.404    33.163     0.200
    15.418    33.398     0.200
    15.469    33.223     0.200
    15.513    34.071     0.200
    15.508    34.834     0.200
    15.543    34.167     0.200
    15.632    34.533     0.200
    16.037    35.095     0.200
    16.042    34.563     0.200
    16.042    35.157     0.200
    16.067    35.051     0.200
    16.090    35.705     0.200
    16.090    35.209     0.200
    16.117    34.849     0.200
    16.151    35.117     0.200
    16.224    35.007     0.200
    16.372    34.709     0.200
    16.494    34.201     0.200
    16.586    35.105     0.200
    16.661    34.864     0.200
    17.690    34.481     0.200
    17.690    35.407     0.200
    17.690    35.551     0.200
    19.655    36.778     0.200
     1.061     7.634     0.200
     1.142     8.084     0.200
     1.157     8.160     0.200
     1.163     8.368     0.200
     1.266     8.447     0.200
     1.268     8.213     0.200
     1.443     8.068     0.200
     1.651     8.837     0.200
     2.197    11.737     0.200
     2.270    11.981     0.200
     2.390    10.730     0.200
     2.466    11.286     0.200
     2.486    11.195     0.200
     2.546    11.344     0.200
     2.553    11.340     0.200
     3.294    14.747     0.200
     3.294    14.489     0.200
     3.440    14.365     0.200
     3.659    13.967     0.200
     3.659    13.717     0.200
     3.719    13.457     0.200
     3.776    13.875     0.200
     3.781    15.062     0.200
     3.781    14.742     0.200
     3.930    15.084     0.200
     4.252    14.499     0.200
     4.318    14.503     0.200
     4.318    14.237     0.200
     4.344    14.597     0.200
     4.457    13.790     0.200
     4.460    15.206     0.200
     4.460    14.714     0.200
     4.507    14.894     0.200
     4.512    14.476     0.200
     4.512    14.288     0.200
     4.529    14.706     0.200
     4.529    14.316     0.200
     4.620    14.752     0.200
     4.651    12.952     0.200
     4.712    16.637     0.200
     4.904    15.685     0.200
     4.794    17.203     0.200
     4.818    16.908     0.200
     4.974    15.651     0.200
     4.974    16.183     0.200
     4.850    17.156     0.200
     4.879    17.262     0.200
     5.059    15.862     0.200
     5.059    15.291     0.200
     5.270    14.806     0.200
     5.270    14.627     0.200
     5.270    15.298     0.200
     5.270    15.595     0.200
     5.317    16.440     0.200
     5.379    16.535     0.200
     5.450    16.956     0.200
     5.503    16.908     0.200
     5.503    16.588     0.200
     5.580    16.352     0.200
     5.580    17.000     0.200
     5.853    18.064     0.200
     5.861    18.303     0.200
     5.861    17.693     0.200
     5.990    18.286     0.200
     6.036    17.651     0.200
     6.083    17.641     0.200
     6.083    17.852     0.200
     6.158    17.749     0.200
     6.037    19.310     0.200
     6.168    20.109     0.200
     6.168    18.976     0.200
     6.168    19.179     0.200
     6.263    18.715     0.200
     6.376    19.018     0.200
     6.394    18.803     0.200
     6.445    19.183     0.200
     6.445    18.863     0.200
     6.548    19.503     0.200
     6.551    19.562     0.200
     6.562    19.460     0.200
     6.614    19.355     0.200
     6.790    20.092     0.200
     6.790    18.803     0.200
     6.806    19.259     0.200
     6.868    19.106     0.200
     6.868    20.169     0.200
     6.888    18.240     0.200
     6.897    20.001     0.200
     7.005    19.695     0.200
     7.049    19.285     0.200
     7.049    19.152     0.200
     7.060    19.769     0.200
     7.071    20.843     0.200
     7.133    21.193     0.200
     7.168    21.032     0.200
     7.212    21.020     0.200
     7.224    18.739     0.200
     7.224    19.426     0.200
     7.240    20.710     0.200
     7.542    19.967     0.200
     7.542    20.382     0.200
     7.637    21.318     0.200
     7.637    21.177     0.200
     7.666    20.936     0.200
     7.666    21.350     0.200
     7.758    22.084     0.200
     7.782    21.571     0.200
     7.797    22.038     0.200
     7.826    19.972     0.200
     7.862    21.275     0.200
     7.862    22.001     0.200
     7.924    22.227     0.200
     7.927    21.059     0.200
     7.953    20.566     0.200
     7.953    21.941     0.200
     8.027    21.793     0.200
     8.027    22.636     0.200
     8.091    21.764     0.200
     8.091    22.264     0.200
     8.120    22.226     0.200
     8.123    23.001     0.200
     8.123    22.314     0.200
     8.145    21.921     0.200
     8.275    22.258     0.200
     8.502    21.753     0.200
     8.502    23.089     0.200
     8.620    22.424     0.200
     8.620    23.260     0.200
     8.632    22.869     0.200
     8.572    24.656     0.200
     8.594    25.226     0.200
     8.732    22.106     0.200
     8.732    22.653     0.200
     8.632    25.494     0.200
     8.762    22.682     0.200
     8.666    25.201     0.200
     8.680    25.403     0.200
     8.708    24.759     0.200
     8.858    22.038     0.200
     8.858    23.069     0.200
     8.926    22.463     0.200
     8.991    23.723     0.200
     9.064    23.308     0.200
     9.064    23.659     0.200
     9.175    23.897     0.200
     9.175    24.171     0.200
     9.224    23.448     0.200
     9.224    24.925     0.200
     9.237    24.153     0.200
     9.255    23.991     0.200
     9.262    22.643     0.200
     9.272    24.096     0.200
     9.316    23.899     0.200
     9.326    22.826     0.200
     9.353    21.726     0.200
     9.353    23.187     0.200
     9.488    23.034     0.200
     9.488    24.198     0.200
     9.527    22.885     0.200
     9.628    24.587     0.200
     9.628    25.212     0.200
     9.690    24.039     0.200
     9.690    24.625     0.200
     9.703    25.413     0.200
     9.724    24.705     0.200
     9.724    23.611     0.200
     9.724    24.369     0.200
     9.858    24.194     0.200
     9.858    24.733     0.200
     9.778    26.896     0.200
     9.832    27.354     0.200
    10.007    26.063     0.200
     9.882    26.838     0.200
    10.025    24.193     0.200
    10.022    25.382     0.200
    10.022    25.702     0.200
     9.904    27.064     0.200
    10.040    25.440     0.200
    10.064    25.800     0.200
    10.066    24.229     0.200
    10.154    24.891     0.200
    10.157    25.730     0.200
    10.174    25.464     0.200
    10.229    25.374     0.200
    10.234    26.221     0.200
    10.248    25.870     0.200
    10.290    25.756     0.200
    10.252    27.843     0.200
    10.252    27.632     0.200
    10.252    29.406     0.200
    10.422    25.992     0.200
    10.452    26.609     0.200
    10.520    26.399     0.200
    10.545    26.769     0.200
    10.546    26.608     0.200
    10.531    28.934     0.200
    10.702    26.691     0.200
    10.741    26.707     0.200
    10.760    26.566     0.200
    10.800    26.764     0.200
    10.833    27.059     0.200
    10.858    27.046     0.200
    11.014    27.250     0.200
    11.040    27.675     0.200
    11.037    26.474     0.200
    11.162    28.008     0.200
    11.242    27.827     0.200
    11.260    27.383     0.200
    11.277    27.167     0.200
    11.277    27.730     0.200
    11.276    28.199     0.200
    11.297    28.268     0.200
    11.294    27.296     0.200
    11.403    28.349     0.200
    11.405    27.599     0.200
    11.558    27.880     0.200
    11.600    28.623     0.200
    11.602    28.508     0.200
    11.725    29.218     0.200
    11.773    29.317     0.200
    11.802    28.931     0.200
    11.819    28.219     0.200
    11.812    29.018     0.200
    11.812    28.026     0.200
    11.830    28.434     0.200
    11.864    30.842     0.200
    11.940    30.048     0.200
    11.940    28.493     0.200
    11.963    29.058     0.200
    11.984    28.263     0.200
    12.030    29.430     0.200
    12.053    29.049     0.200
    12.052    29.141     0.200
    12.115    26.858     0.200
    12.115    27.749     0.200
    12.242    28.571     0.200
    12.250    29.133     0.200
    12.250    30.101     0.200
    12.250    29.398     0.200
    12.287    29.740     0.200
    12.311    29.039     0.200
    12.344    29.958     0.200
    12.429    28.449     0.200
    12.468    30.111     0.200
    12.564    30.546     0.200
    12.595    30.514     0.200
    12.643    30.210     0.200
    12.661    29.606     0.200
    12.669    30.654     0.200
    12.720    30.561     0.200
    12.786    30.654     0.200
    12.756    31.192     0.200
    12.899    31.095     0.200
    12.893    31.237     0.200
    12.974    30.813     0.200
    12.988    31.632     0.200
    13.031    30.292     0.200
    13.028    30.907     0.200
    13.059    30.910     0.200
    13.135    31.294     0.200
    13.187    31.258     0.200
    13.424    31.990     0.200
    13.465    31.588     0.200
    13.480    30.761     0.200
    13.531    31.283     0.200
    13.551    32.544     0.200
    13.551    32.404     0.200
    13.627    32.847     0.200
    13.680    32.866     0.200
    13.699    32.434     0.200
    13.754    32.082     0.200
    13.788    33.011     0.200
    13.851    32.188     0.200
    13.896    32.808     0.200
    13.898    32.050     0.200
    13.912    32.370     0.200
    13.937    32.984     0.200
    14.025    33.023     0.200
    14.105    32.580     0.200
    14.112    32.696     0.200
    14.126    32.879     0.200
    14.145    33.247     0.200
    14.147    33.634     0.200
    14.181    32.912     0.200
    14.203    33.247     0.200
    14.265    32.890     0.200
    14.315    32.681     0.200
    14.311    33.661     0.200
    14.462    34.020     0.200
    14.479    33.087     0.200
    14.521    33.735     0.200
    14.544    34.329     0.200
    14.609    33.102     0.200
    14.676    33.188     0.200
    14.707    33.242     0.200
    14.708    34.019     0.200
    14.714    33.062     0.200
    14.740    33.664     0.200
    14.745    34.198     0.200
    14.754    34.450     0.200
    14.851    33.981     0.200
    14.992    34.669     0.200
    15.079    34.856     0.200
    15.099    34.908     0.200
    15.127    35.221     0.200
    15.209    34.894     0.200
    15.386    36.340     0.200
    15.309    33.526     0.200
    15.433    35.157     0.200
    15.445    35.276     0.200
    15.422    35.594     0.200
    15.514    36.193     0.200
    15.586    35.748     0.200
    15.689    35.586     0.200
    15.719    36.885     0.200
    15.816    35.407     0.200
    15.817    35.803     0.200
    15.991    35.935     0.200
    16.007    35.756     0.200
    16.097    36.037     0.200
    16.140    36.195     0.200
    16.223    35.662     0.200
    16.319    35.867     0.200
    16.755    37.009     0.200
    16.769    36.644     0.200
    16.832    36.332     0.200
    16.844    36.520     0.200
    16.901    37.831     0.200
    17.046    37.278     0.200
    17.215    37.236     0.200
    17.340    37.588     0.200
    17.439    37.189     0.200
    20.039    37.659     0.200
     0.419     5.046     0.200
     0.851     6.447     0.200
     0.897     6.986     0.200
     0.896     6.875     0.200
     0.916     6.978     0.200
     0.929     7.192     0.200
     1.028     7.690     0.200
     1.258     7.058     0.200
     1.422     7.412     0.200
     1.412     7.830     0.200
     1.447     8.056     0.200
     1.496     8.028     0.200
     1.935    10.538     0.200
     2.075    10.470     0.200
     2.234     9.175     0.200
     2.140    10.518     0.200
     2.314     9.603     0.200
     2.327     9.439     0.200
     2.394     9.616     0.200
     2.391     9.865     0.200
     3.169    12.905     0.200
     3.211    12.128     0.200
     3.307    12.656     0.200
     3.312    12.822     0.200
     3.318    12.660     0.200
     3.321    12.681     0.200
     3.428    12.354     0.200
     3.340    12.915     0.200
     3.352    11.193     0.200
     3.533    12.556     0.200
     3.579    12.538     0.200
     3.646    12.748     0.200
     3.652    12.611     0.200
     3.711    12.769     0.200
     3.800    13.135     0.200
     3.859    13.540     0.200
     3.935    13.549     0.200
     4.129    13.332     0.200
     4.180    13.433     0.200
     4.270    13.004     0.200
     4.334    13.137     0.200
     4.339    13.528     0.200
     4.322    13.189     0.200
     4.393    14.011     0.200
     4.357    13.343     0.200
     4.472    14.206     0.200
     4.493    14.242     0.200
     4.615    11.695     0.200
     4.651    13.212     0.200
     4.769    14.653     0.200
     4.772    14.782     0.200
     4.798    14.578     0.200
     4.823    14.623     0.200
     4.733    15.372     0.200
     4.844    14.118     0.200
     5.052    14.609     0.200
     5.217    15.113     0.200
     5.217    13.234     0.200
     5.180    15.279     0.200
     5.293    15.167     0.200
     5.255    15.693     0.200
     5.465    14.240     0.200
     5.715    17.104     0.200
     5.782    16.062     0.200
     5.874    16.854     0.200
     5.893    16.087     0.200
     5.940    17.276     0.200
     6.159    16.720     0.200
     6.254    16.719     0.200
     6.538    17.535     0.200
     6.695    18.551     0.200
     6.678    18.276     0.200
     6.818    18.506     0.200
     7.012    19.247     0.200
     7.362    19.790     0.200
     7.407    19.684     0.200
     7.566    19.268     0.200
     7.831    20.038     0.200
     7.886    20.301     0.200
     7.993    20.138     0.200
     8.006    21.004     0.200
     8.380    21.532     0.200
     8.520    20.862     0.200
     8.551    22.967     0.200
     8.601    23.273     0.200
     8.635    22.301     0.200
     8.756    21.075     0.200
     8.768    21.816     0.200
     9.048    23.937     0.200
     9.249    22.322     0.200
     9.260    21.644     0.200
     9.442    21.874     0.200
     9.412    23.189     0.200
     9.521    25.298     0.200
     9.743    21.780     0.200
     9.801    24.495     0.200
     9.911    22.876     0.200
     9.971    24.440     0.200
     9.977    25.005     0.200
    10.077    23.538     0.200
    10.042    24.739     0.200
    10.170    24.967     0.200
    10.345    24.165     0.200
    10.340    24.122     0.200
    10.307    24.953     0.200
    10.563    25.049     0.200
    10.540    26.030     0.200
    10.811    25.517     0.200
    10.911    25.317     0.200
    10.961    25.398     0.200
    11.035    27.229     0.200
    11.368    26.793     0.200
    11.586    27.242     0.200
    11.559    27.834     0.200
    11.852    28.645     0.200
    11.854    29.501     0.200
    11.955    26.564     0.200
    11.955    27.194     0.200
    12.012    28.447     0.200
    12.095    29.250     0.200
    12.366    29.310     0.200
    12.539    27.346     0.200
    12.558    28.421     0.200
    12.542    30.631     0.200
    12.535    30.952     0.200
    12.662    30.479     0.200
    12.770    30.439     0.200
    12.858    29.346     0.200
    12.834    29.455     0.200
    12.991    30.429     0.200
    13.348    30.246     0.200
    13.622    30.080     0.200
    14.039    32.099     0.200
    14.124    31.849     0.200
    14.565    31.745     0.200
    14.575    31.921     0.200
    14.779    33.675     0.200
    14.923    33.450     0.200
    15.553    34.066     0.200
    15.983    34.052     0.200
    16.565    35.891     0.200
    16.728    35.129     0.200
    16.841    35.536     0.200
    17.057    34.799     0.200
    17.197    36.136     0.200
    17.309    34.918     0.200
     0.404     5.087     0.200
     0.404     5.337     0.200
     0.827     6.518     0.200
     0.871     7.199     0.200
     0.871     7.184     0.200
     0.891     7.336     0.200
     1.003     7.898     0.200
     1.046     7.236     0.200
     1.055     6.898     0.200
     1.256     7.103     0.200
     1.439     8.180     0.200
     1.441     8.150     0.200
     1.478     7.951     0.200
     1.492     8.273     0.200
     2.004     9.485     0.200
     2.055    10.346     0.200
     2.325     9.605     0.200
     2.390     9.856     0.200
     3.151    12.780     0.200
     3.194    12.605     0.200
     3.323    12.805     0.200
     3.334    13.066     0.200
     3.534    12.785     0.200
     3.579    12.398     0.200
     3.647    12.599     0.200
     3.694    12.977     0.200
     3.783    13.329     0.200
     3.842    13.506     0.200
     3.952    13.615     0.200
     4.180    13.460     0.200
     4.266    13.601     0.200
     4.257    13.049     0.200
     4.257    13.158     0.200
     4.288    13.375     0.200
     4.288    13.492     0.200
     4.315    13.553     0.200
     4.315    13.818     0.200
     4.336    13.209     0.200
     4.341    13.547     0.200
     4.341    13.804     0.200
     4.473    14.058     0.200
     4.495    14.031     0.200
     4.625    12.153     0.200
     4.625    12.333     0.200
     4.634    15.119     0.200
     4.773    13.839     0.200
     4.716    15.545     0.200
     4.794    14.780     0.200
     4.735    15.109     0.200
     4.826    14.645     0.200
     4.769    15.436     0.200
     4.836    14.202     0.200
     4.836    14.038     0.200
     5.035    15.207     0.200
     5.035    15.395     0.200
     5.173    15.174     0.200
     5.173    15.284     0.200
     5.225    12.650     0.200
     5.225    13.963     0.200
     5.225    13.056     0.200
     5.225    14.134     0.200
     5.225    14.470     0.200
     5.241    15.668     0.200
     5.241    15.020     0.200
     5.291    16.094     0.200
     5.467    15.403     0.200
     5.467    15.723     0.200
     5.618    16.543     0.200
     5.683    16.868     0.200
     5.683    17.173     0.200
     5.696    17.138     0.200
     5.767    16.196     0.200
     5.767    16.087     0.200
     5.866    16.500     0.200
     5.866    16.609     0.200
     5.876    16.526     0.200
     5.876    16.737     0.200
     5.886    16.870     0.200
     5.915    18.087     0.200
     5.915    17.634     0.200
     5.965    18.946     0.200
     6.134    17.041     0.200
     6.134    16.909     0.200
     6.147    17.080     0.200
     6.248    17.704     0.200
     6.259    17.804     0.200
     6.411    17.663     0.200
     6.416    17.786     0.200
     6.478    17.737     0.200
     6.520    18.004     0.200
     6.658    18.603     0.200
     6.658    17.728     0.200
     6.669    18.629     0.200
     6.669    18.730     0.200
     6.691    19.485     0.200
     6.719    18.111     0.200
     6.719    18.400     0.200
     6.773    17.862     0.200
     6.794    18.155     0.200
     6.805    17.930     0.200
     6.805    17.766     0.200
     6.863    18.178     0.200
     6.899    19.285     0.200
     6.923    19.518     0.200
     7.005    19.255     0.200
     7.023    20.454     0.200
     7.099    18.745     0.200
     7.131    17.555     0.200
     7.131    17.305     0.200
     7.299    18.979     0.200
     7.299    19.175     0.200
     7.342    20.083     0.200
     7.342    19.528     0.200
     7.391    19.755     0.200
     7.557    19.587     0.200
     7.602    21.189     0.200
     7.634    21.580     0.200
     7.645    20.908     0.200
     7.669    21.307     0.200
     7.669    21.518     0.200
     7.676    20.994     0.200
     7.773    20.700     0.200
     7.816    20.193     0.200
     7.825    20.856     0.200
     7.863    19.822     0.200
     7.863    20.455     0.200
     7.874    20.497     0.200
     7.946    22.243     0.200
     7.991    21.541     0.200
     7.988    20.252     0.200
     8.365    21.405     0.200
     8.365    21.288     0.200
     8.382    20.846     0.200
     8.382    21.729     0.200
     8.461    21.445     0.200
     8.507    21.245     0.200
     8.507    21.018     0.200
     8.479    23.537     0.200
     8.499    23.553     0.200
     8.533    23.761     0.200
     8.572    23.346     0.200
     8.584    23.061     0.200
     8.665    21.166     0.200
     8.618    23.367     0.200
     8.618    23.055     0.200
     8.719    20.400     0.200
     8.759    21.627     0.200
     8.758    22.044     0.200
     8.880    22.209     0.200
     8.885    21.010     0.200
     8.939    23.188     0.200
     8.970    22.797     0.200
     9.043    24.654     0.200
     9.043    23.967     0.200
     9.049    22.855     0.200
     9.061    21.893     0.200
     9.061    21.611     0.200
     9.111    23.124     0.200
     9.111    22.859     0.200
     9.135    21.662     0.200
     9.163    22.897     0.200
     9.255    21.796     0.200
     9.265    21.654     0.200
     9.265    22.115     0.200
     9.366    21.792     0.200
     9.366    22.581     0.200
     9.402    24.215     0.200
     9.447    21.190     0.200
     9.516    24.140     0.200
     9.516    24.804     0.200
     9.574    22.571     0.200
     9.574    23.149     0.200
     9.656    23.256     0.200
     9.656    22.881     0.200
     9.745    23.007     0.200
     9.745    23.742     0.200
     9.681    25.069     0.200
     9.764    23.882     0.200
     9.714    25.688     0.200
     9.793    24.427     0.200
     9.732    25.915     0.200
     9.870    25.694     0.200
     9.919    22.866     0.200
     9.942    23.966     0.200
     9.979    23.636     0.200
     9.979    24.269     0.200
     9.958    25.128     0.200
     9.986    24.919     0.200
     9.994    25.163     0.200
    10.009    23.621     0.200
    10.028    24.667     0.200
    10.028    25.034     0.200
    10.080    24.580     0.200
    10.096    23.622     0.200
    10.152    25.961     0.200
    10.152    26.851     0.200
    10.294    25.198     0.200
    10.324    24.647     0.200
    10.343    25.059     0.200
    10.351    24.424     0.200
    10.429    26.852     0.200
    10.563    25.049     0.200
    10.529    25.811     0.200
    10.579    24.251     0.200
    10.591    25.494     0.200
    10.800    26.871     0.200
    10.906    26.621     0.200
    10.915    25.601     0.200
    10.933    26.618     0.200
    10.950    25.424     0.200
    10.991    28.004     0.200
    11.022    27.542     0.200
    11.093    27.560     0.200
    11.138    25.295     0.200
    11.210    27.357     0.200
    11.223    27.203     0.200
    11.229    26.413     0.200
    11.262    28.024     0.200
    11.262    27.899     0.200
    11.356    27.667     0.200
    11.385    28.070     0.200
    11.549    27.343     0.200
    11.586    26.300     0.200
    11.617    26.340     0.200
    11.662    25.590     0.200
    11.701    26.990     0.200
    11.736    27.970     0.200
    11.755    26.160     0.200
    11.770    24.680     0.200
    11.770    27.985     0.200
    11.770    27.001     0.200
    11.770    26.899     0.200
    11.770    28.477     0.200
    11.853    27.897     0.200
    11.847    27.649     0.200
    11.944    26.849     0.200
    11.953    26.245     0.200
    11.999    29.301     0.200
    12.071    27.791     0.200
    12.086    28.589     0.200
    12.151    27.075     0.200
    12.164    28.566     0.200
    12.244    27.735     0.200
    12.280    26.274     0.200
    12.355    29.741     0.200
    12.498    28.498     0.200
    12.543    28.782     0.200
    12.561    27.505     0.200
    12.608    29.384     0.200
    12.617    29.327     0.200
    12.649    29.625     0.200
    12.643    30.785     0.200
    12.759    30.036     0.200
    12.760    30.544     0.200
    12.827    29.930     0.200
    12.897    29.247     0.200
    12.977    30.817     0.200
    13.127    31.215     0.200
    13.144    32.289     0.200
    13.148    30.936     0.200
    13.202    31.528     0.200
    13.206    30.532     0.200
    13.256    30.457     0.200
    13.443    29.963     0.200
    13.517    31.917     0.200
    13.508    30.743     0.200
    13.568    32.033     0.200
    13.610    30.679     0.200
    13.628    30.469     0.200
    13.637    32.553     0.200
    13.642    31.250     0.200
    13.713    32.021     0.200
    13.714    30.624     0.200
    13.757    32.613     0.200
    13.757    30.261     0.200
    13.787    31.517     0.200
    13.839    30.999     0.200
    13.876    30.660     0.200
    13.891    31.115     0.200
    13.947    31.123     0.200
    13.999    31.026     0.200
    14.044    31.143     0.200
    14.103    31.011     0.200
    14.123    31.403     0.200
    14.174    31.739     0.200
    14.200    31.760     0.200
    14.311    32.827     0.200
    14.315    30.630     0.200
    14.395    31.737     0.200
    14.395    31.948     0.200
    14.439    31.139     0.200
    14.501    32.772     0.200
    14.498    31.644     0.200
    14.564    32.587     0.200
    14.575    32.396     0.200
    14.596    33.028     0.200
    14.614    32.394     0.200
    14.638    32.168     0.200
    14.636    32.235     0.200
    14.731    32.398     0.200
    14.770    31.710     0.200
    14.919    32.874     0.200
    14.921    31.960     0.200
    14.936    32.590     0.200
    14.966    33.083     0.200
    15.085    32.420     0.200
    15.143    33.956     0.200
    15.192    33.234     0.200
    15.218    33.477     0.200
    15.333    34.355     0.200
    15.319    33.390     0.200
    15.412    33.527     0.200
    15.553    34.205     0.200
    15.589    34.058     0.200
    15.666    34.970     0.200
    15.689    33.482     0.200
    15.705    33.270     0.200
    15.768    32.969     0.200
    15.786    33.493     0.200
    15.836    35.017     0.200
    15.923    33.730     0.200
    15.980    33.406     0.200
    16.080    33.711     0.200
    16.188    34.143     0.200
    16.433    35.589     0.200
    16.455    34.930     0.200
    16.478    33.050     0.200
    16.478    35.909     0.200
    16.559    35.988     0.200
    16.695    34.302     0.200
    16.730    34.100     0.200
    16.757    34.168     0.200
    16.848    36.192     0.200
    16.864    34.301     0.200
    17.002    34.425     0.200
    17.002    35.503     0.200
    17.054    34.985     0.200
    17.196    35.145     0.200
    17.309    34.875     0.200
    17.472    35.479     0.200
    17.757    33.490     0.200
    17.757    34.217     0.200
    19.016    36.367     0.200
    19.321    36.006     0.200
     0.371     4.923     0.200
     0.371     5.134     0.200
     0.808     6.440     0.200
     0.844     6.974     0.200
     0.844     6.871     0.200
     0.866     7.018     0.200
     0.880     7.287     0.200
     0.977     7.701     0.200
     1.216     6.859     0.200
     1.288     7.355     0.200
     1.381     7.576     0.200
     1.413     7.748     0.200
     1.413     7.951     0.200
     1.982     9.282     0.200
     2.047    10.344     0.200
     2.303     9.218     0.200
     2.372     9.245     0.200
     2.367     9.504     0.200
     3.148    12.459     0.200
     3.190    12.520     0.200
     3.190    12.090     0.200
     3.221    12.498     0.200
     3.291    12.514     0.200
     3.300    12.643     0.200
     3.319    12.641     0.200
     3.330    12.591     0.200
     3.338    12.777     0.200
     3.359    12.835     0.200
     3.515    12.281     0.200
     3.558    12.250     0.200
     3.627    12.781     0.200
     3.628    12.409     0.200
     3.692    12.469     0.200
     3.840    13.344     0.200
     4.112    13.103     0.200
     4.159    13.139     0.200
     4.224    12.756     0.200
     4.317    13.579     0.200
     4.323    13.291     0.200
     4.286    13.387     0.200
     4.376    13.783     0.200
     4.306    13.174     0.200
     4.476    13.655     0.200
     4.616    12.057     0.200
     4.635    13.573     0.200
     4.633    14.883     0.200
     4.752    14.382     0.200
     4.753    14.620     0.200
     4.715    14.809     0.200
     4.769    14.645     0.200
     4.807    14.444     0.200
     4.733    14.896     0.200
     4.806    13.758     0.200
     5.000    14.806     0.200
     5.214    12.970     0.200
     5.214    13.321     0.200
     5.145    14.843     0.200
     5.268    15.457     0.200
     5.208    15.375     0.200
     5.449    15.365     0.200
     5.659    16.855     0.200
     5.661    16.650     0.200
     5.837    16.472     0.200
     5.842    16.344     0.200
     5.886    17.452     0.200
     5.890    18.313     0.200
     5.890    17.868     0.200
     6.115    16.921     0.200
     6.221    16.974     0.200
     6.224    16.929     0.200
     6.390    18.790     0.200
     6.485    17.794     0.200
     6.666    18.779     0.200
     6.639    17.880     0.200
     6.777    18.190     0.200
     6.739    17.651     0.200
     6.772    18.233     0.200
     6.841    20.398     0.200
     6.977    18.482     0.200
     7.077    19.135     0.200
     7.115    18.034     0.200
     7.307    19.963     0.200
     7.357    20.052     0.200
     7.527    19.569     0.200
     7.642    20.565     0.200
     7.798    20.960     0.200
     7.847    19.916     0.200
     7.797    20.539     0.200
     7.843    19.892     0.200
     7.921    22.115     0.200
     7.953    20.902     0.200
     8.331    21.250     0.200
     8.437    23.460     0.200
     8.475    20.938     0.200
     8.530    22.981     0.200
     8.652    20.925     0.200
     8.615    23.023     0.200
     8.742    21.146     0.200
     8.727    22.144     0.200
     9.042    21.923     0.200
     9.017    24.602     0.200
     9.241    21.881     0.200
     9.249    21.450     0.200
     9.432    21.599     0.200
     9.372    22.487     0.200
     9.490    24.587     0.200
     9.727    22.631     0.200
     9.677    24.501     0.200
     9.709    25.946     0.200
     9.764    24.374     0.200
     9.773    24.545     0.200
     9.968    24.622     0.200
     9.962    24.425     0.200
    10.040    23.578     0.200
     9.923    24.248     0.200
    10.064    23.687     0.200
     9.995    23.593     0.200
    10.148    25.928     0.200
    10.148    25.826     0.200
    10.337    24.925     0.200
    10.294    23.071     0.200
    10.424    26.409     0.200
    10.490    26.249     0.200
    10.953    25.626     0.200
    11.022    26.348     0.200
    11.065    27.247     0.200
    11.324    27.585     0.200
    11.356    27.267     0.200
    11.500    27.316     0.200
    11.564    27.035     0.200
    11.832    27.575     0.200
    11.819    27.236     0.200
    11.967    28.686     0.200
    12.056    28.587     0.200
    12.148    28.719     0.200
    12.323    30.068     0.200
    12.544    28.574     0.200
    12.730    28.960     0.200
    13.614    30.159     0.200
    14.028    32.043     0.200
    14.101    32.736     0.200
    14.184    32.353     0.200
    14.555    30.927     0.200
    14.597    32.222     0.200
    14.740    32.683     0.200
    15.559    33.590     0.200
    16.836    36.359     0.200
    17.174    35.582     0.200
    17.289    34.803     0.200
     1.094     6.736     0.200
     1.189     7.008     0.200
     1.226     7.573     0.200
     1.293     7.940     0.200
     1.358     8.041     0.200
     1.516     8.875     0.200
     1.527     8.583     0.200
     1.579     9.320     0.200
     1.749     9.261     0.200
     1.762     8.915     0.200
     1.762     9.259     0.200
     1.940     8.812     0.200
     2.037     9.145     0.200
     2.083     9.406     0.200
     2.627    12.150     0.200
     2.766    12.172     0.200
     2.832    12.308     0.200
     3.074    11.315     0.200
     3.217    11.776     0.200
     3.330    11.959     0.200
     3.330    12.256     0.200
     3.721    12.603     0.200
     3.809    12.763     0.200
     3.809    12.919     0.200
     3.864    13.019     0.200
     3.850    14.496     0.200
     3.893    13.854     0.200
     3.914    13.002     0.200
     3.925    14.098     0.200
     3.923    14.051     0.200
     3.923    14.551     0.200
     3.987    13.363     0.200
     3.987    13.472     0.200
     3.991    14.126     0.200
     3.994    14.479     0.200
     4.003    14.424     0.200
     4.022    14.535     0.200
     4.036    13.655     0.200
     4.077    13.833     0.200
     4.040    11.490     0.200
     4.156    13.721     0.200
     4.258    13.319     0.200
     4.381    13.825     0.200
     4.462    14.363     0.200
     4.388    14.609     0.200
     4.528    14.772     0.200
     4.536    15.132     0.200
     4.613    15.247     0.200
     4.705    14.782     0.200
     4.666    12.153     0.200
     4.980    15.036     0.200
     4.965    14.634     0.200
     4.965    14.767     0.200
     5.033    15.161     0.200
     5.167    15.232     0.200
     5.261    16.307     0.200
     5.384    14.844     0.200
     5.405    17.232     0.200
     5.427    16.784     0.200
     5.553    16.579     0.200
     5.706    15.931     0.200
     5.821    17.183     0.200
     5.821    17.566     0.200
     5.913    16.938     0.200
     6.004    16.981     0.200
     6.024    18.206     0.200
     6.099    17.782     0.200
     6.407    18.999     0.200
     6.546    18.596     0.200
     6.561    19.312     0.200
     6.611    19.301     0.200
     6.671    18.968     0.200
     6.789    18.542     0.200
     6.809    19.184     0.200
     6.858    18.666     0.200
     7.230    19.382     0.200
     7.418    19.638     0.200
     7.428    20.828     0.200
     7.470    21.414     0.200
     7.563    20.927     0.200
     7.611    20.758     0.200
     7.658    22.653     0.200
     7.812    20.899     0.200
     8.397    22.052     0.200
     8.481    22.167     0.200
     8.735    21.403     0.200
     8.942    20.829     0.200
     9.262    24.237     0.200
     9.231    23.799     0.200
     9.315    24.117     0.200
     9.612    25.665     0.200
    10.033    25.943     0.200
    10.854    27.399     0.200
    11.132    27.950     0.200
    11.288    27.304     0.200
    11.937    28.979     0.200
     0.342     3.992     0.200
     0.353     4.114     0.200
     0.527     5.333     0.200
     0.527     5.534     0.200
     0.872     5.574     0.200
     0.982     6.475     0.200
     1.061     6.920     0.200
     1.117     7.375     0.200
     1.117     7.186     0.200
     1.245     7.327     0.200
     1.294     7.366     0.200
     1.298     7.379     0.200
     1.391     7.867     0.200
     1.517     8.047     0.200
     1.535     7.780     0.200
     1.797     8.011     0.200
     1.961     8.590     0.200
     2.426    10.818     0.200
     2.553    11.240     0.200
     2.634    11.063     0.200
     3.056    11.227     0.200
     3.118    11.014     0.200
     3.210    11.244     0.200
     3.686    13.947     0.200
     3.716    11.857     0.200
     3.742    12.092     0.200
     3.728    14.186     0.200
     3.728    13.735     0.200
     3.789    12.182     0.200
     3.758    13.086     0.200
     3.854    12.782     0.200
     3.866    14.062     0.200
     3.915    12.650     0.200
     3.969    12.169     0.200
     4.085    11.511     0.200
     4.085    10.912     0.200
     4.017    12.266     0.200
     4.167    12.781     0.200
     4.231    15.306     0.200
     4.231    13.935     0.200
     4.286    13.089     0.200
     4.301    13.395     0.200
     4.319    14.156     0.200
     4.387    13.845     0.200
     4.455    14.485     0.200
     4.509    13.587     0.200
     4.692    13.134     0.200
     4.809    14.067     0.200
     4.852    14.244     0.200
     4.894    14.645     0.200
     4.977    14.511     0.200
     5.017    15.075     0.200
     5.259    15.814     0.200
     5.336    15.834     0.200
     5.523    15.671     0.200
     5.568    15.777     0.200
     5.623    16.426     0.200
     5.733    15.980     0.200
     5.867    16.646     0.200
     5.877    16.556     0.200
     6.289    17.071     0.200
     6.277    17.962     0.200
     6.271    19.702     0.200
     6.271    19.082     0.200
     6.351    18.183     0.200
     6.396    17.417     0.200
     6.558    17.491     0.200
     6.599    17.555     0.200
     6.642    17.697     0.200
     7.017    18.292     0.200
     7.230    19.077     0.200
     7.213    19.154     0.200
     7.280    19.841     0.200
     7.325    19.729     0.200
     7.356    18.765     0.200
     7.274    19.530     0.200
     7.452    19.704     0.200
     7.899    20.287     0.200
     8.021    20.800     0.200
     8.154    20.664     0.200
     8.258    20.261     0.200
     8.255    20.801     0.200
     8.735    20.375     0.200
     8.933    20.741     0.200
     9.135    21.383     0.200
     9.135    21.905     0.200
     9.076    23.303     0.200
     9.116    23.899     0.200
     9.256    22.318     0.200
     9.441    24.868     0.200
     9.576    23.118     0.200
    10.505    25.948     0.200
    11.216    27.357     0.200
    11.735    28.839     0.200
    12.061    29.514     0.200
     0.480     4.243     0.200
     0.480     4.272     0.200
     0.514     4.944     0.200
     0.514     5.111     0.200
     0.889     6.803     0.200
     0.959     7.177     0.200
     0.971     7.189     0.200
     1.086     7.960     0.200
     1.107     7.457     0.200
     1.338     7.308     0.200
     1.496     8.089     0.200
     1.533     8.263     0.200
     1.533     8.373     0.200
     1.944    10.899     0.200
     2.070    11.154     0.200
     2.078    10.961     0.200
     3.201    13.682     0.200
     3.231    13.542     0.200
     3.344    13.648     0.200
     3.371    13.616     0.200
     3.501    12.408     0.200
     3.651    12.720     0.200
     3.697    13.899     0.200
     4.198    13.582     0.200
     4.252    13.618     0.200
     4.295    13.670     0.200
     4.402    14.105     0.200
     4.406    13.868     0.200
     4.363    12.994     0.200
     4.410    13.957     0.200
     4.462    14.334     0.200
     4.452    13.907     0.200
     4.561    14.777     0.200
     4.659    12.986     0.200
     4.719    14.063     0.200
     4.634    16.114     0.200
     4.836    14.937     0.200
     4.890    14.838     0.200
     4.880    15.297     0.200
     4.934    14.296     0.200
     5.146    15.136     0.200
     5.266    14.706     0.200
     5.266    14.166     0.200
     5.349    15.397     0.200
     5.531    16.160     0.200
     5.721    16.512     0.200
     5.876    16.031     0.200
     5.962    16.422     0.200
     5.883    18.503     0.200
     5.988    16.642     0.200
     5.991    18.630     0.200
     6.251    17.361     0.200
     6.295    18.150     0.200
     6.339    17.276     0.200
     6.369    17.723     0.200
     6.483    18.854     0.200
     6.632    17.844     0.200
     6.776    19.463     0.200
     6.852    17.734     0.200
     6.884    17.845     0.200
     6.911    18.114     0.200
     6.973    20.800     0.200
     7.099    18.415     0.200
     7.189    17.984     0.200
     7.402    18.896     0.200
     7.455    19.745     0.200
     7.501    19.650     0.200
     7.655    19.700     0.200
     7.714    21.407     0.200
     7.759    20.787     0.200
     7.880    20.891     0.200
     7.920    20.478     0.200
     7.917    20.405     0.200
     7.978    20.392     0.200
     8.069    22.637     0.200
     8.100    20.853     0.200
     8.474    21.150     0.200
     8.540    23.417     0.200
     8.539    24.468     0.200
     8.613    21.181     0.200
     8.715    21.679     0.200
     8.623    23.905     0.200
     8.623    24.038     0.200
     8.819    21.867     0.200
     8.859    22.495     0.200
     9.079    22.919     0.200
     9.142    23.649     0.200
     9.306    22.461     0.200
     9.321    22.078     0.200
     9.434    22.616     0.200
     9.501    21.654     0.200
     9.501    23.452     0.200
     9.706    23.295     0.200
     9.689    25.117     0.200
     9.889    24.628     0.200
     9.875    24.512     0.200
    10.162    27.356     0.200
    10.440    27.599     0.200
    11.018    27.265     0.200
    11.648    28.370     0.200
    12.622    29.650     0.200
    12.625    29.482     0.200
    13.679    31.623     0.200
    14.198    31.603     0.200
     0.367     5.128     0.200
     0.805     6.375     0.200
     0.839     6.725     0.200
     0.862     6.758     0.200
     0.973     7.407     0.200
     1.025     6.908     0.200
     1.036     6.798     0.200
     1.230     6.743     0.200
     1.378     7.632     0.200
     1.409     7.727     0.200
     1.410     8.060     0.200
     1.903    10.003     0.200
     2.109    10.131     0.200
     3.146    12.090     0.200
     3.189    11.987     0.200
     3.219    11.989     0.200
     3.299    12.244     0.200
     3.328    12.274     0.200
     3.514    12.066     0.200
     3.691    12.559     0.200
     3.691    12.270     0.200
     4.111    12.845     0.200
     4.157    13.228     0.200
     4.157    12.744     0.200
     4.211    13.169     0.200
     4.220    13.467     0.200
     4.220    13.080     0.200
     4.261    13.134     0.200
     4.315    13.504     0.200
     4.283    13.566     0.200
     4.283    13.273     0.200
     4.302    13.676     0.200
     4.302    13.129     0.200
     4.474    14.002     0.200
     4.616    12.147     0.200
     4.616    12.327     0.200
     4.633    13.884     0.200
     4.632    14.471     0.200
     4.714    14.824     0.200
     4.732    14.747     0.200
     4.750    14.291     0.200
     4.751    14.243     0.200
     4.751    14.388     0.200
     4.766    15.009     0.200
     4.766    14.118     0.200
     4.806    14.365     0.200
     4.802    14.233     0.200
     4.802    14.100     0.200
     4.995    14.832     0.200
     4.995    14.621     0.200
     5.142    14.626     0.200
     5.214    14.256     0.200
     5.214    13.662     0.200
     5.214    14.002     0.200
     5.204    15.025     0.200
     5.204    14.919     0.200
     5.265    15.211     0.200
     5.265    14.848     0.200
     5.447    15.528     0.200
     5.447    15.001     0.200
     5.583    16.064     0.200
     5.583    15.888     0.200
     5.656    15.807     0.200
     5.656    16.644     0.200
     5.656    16.257     0.200
     5.729    15.964     0.200
     5.729    15.542     0.200
     5.833    16.347     0.200
     5.837    16.299     0.200
     5.886    18.104     0.200
     5.886    17.526     0.200
     6.112    17.446     0.200
     6.111    17.092     0.200
     6.189    17.927     0.200
     6.189    17.084     0.200
     6.218    17.174     0.200
     6.219    17.562     0.200
     6.388    18.583     0.200
     6.394    18.544     0.200
     6.455    18.136     0.200
     6.481    17.500     0.200
     6.481    17.758     0.200
     6.636    17.254     0.200
     6.635    18.078     0.200
     6.635    17.937     0.200
     6.663    19.072     0.200
     6.776    18.283     0.200
     6.735    17.273     0.200
     6.768    18.471     0.200
     6.768    18.132     0.200
     6.839    19.657     0.200
     6.899    20.197     0.200
     6.974    18.520     0.200
     7.064    18.272     0.200
     7.075    19.210     0.200
     7.113    18.482     0.200
     7.113    18.013     0.200
     7.263    18.506     0.200
     7.263    18.955     0.200
     7.302    19.304     0.200
     7.302    19.066     0.200
     7.352    19.717     0.200
     7.352    19.315     0.200
     7.523    19.692     0.200
     7.607    21.490     0.200
     7.620    18.332     0.200
     7.639    21.147     0.200
     7.639    19.581     0.200
     7.796    20.795     0.200
     7.794    20.341     0.200
     7.794    20.134     0.200
     7.846    20.035     0.200
     7.846    19.735     0.200
     7.839    20.820     0.200
     7.839    20.527     0.200
     7.918    21.748     0.200
     7.918    20.279     0.200
     7.968    19.614     0.200
     7.948    20.703     0.200
     7.948    20.593     0.200
     8.361    20.736     0.200
     8.327    21.190     0.200
     8.435    22.176     0.200
     8.435    22.976     0.200
     8.471    20.938     0.200
     8.471    21.415     0.200
     8.528    22.523     0.200
     8.651    21.130     0.200
     8.613    22.455     0.200
     8.696    21.267     0.200
     8.740    21.245     0.200
     8.740    21.651     0.200
     8.724    22.055     0.200
     8.724    22.328     0.200
     8.869    21.925     0.200
     8.874    21.851     0.200
     8.917    21.245     0.200
     8.932    22.840     0.200
     8.932    21.985     0.200
     9.041    22.071     0.200
     9.015    22.244     0.200
     9.017    22.377     0.200
     9.017    22.264     0.200
     9.085    22.701     0.200
     9.085    22.112     0.200
     9.138    22.123     0.200
     9.240    21.661     0.200
     9.248    21.659     0.200
     9.248    22.186     0.200
     9.345    22.376     0.200
     9.345    22.591     0.200
     9.369    23.337     0.200
     9.369    23.150     0.200
     9.431    21.358     0.200
     9.487    24.793     0.200
     9.487    23.199     0.200
     9.553    22.753     0.200
     9.641    22.657     0.200
     9.641    23.114     0.200
     9.725    23.404     0.200
     9.761    23.651     0.200
     9.840    24.041     0.200
     9.968    23.651     0.200
     9.968    23.483     0.200
     9.959    23.745     0.200
     9.918    24.604     0.200
     9.985    24.449     0.200
     9.959    25.214     0.200
    10.063    23.448     0.200
    10.063    23.589     0.200
     9.991    24.248     0.200
    10.074    24.062     0.200
    10.146    25.604     0.200
    10.146    26.643     0.200
    10.197    24.902     0.200
    10.258    25.506     0.200
    10.336    24.065     0.200
    10.323    24.161     0.200
    10.291    24.834     0.200
    10.423    26.613     0.200
    10.540    24.659     0.200
    10.485    26.015     0.200
    10.485    25.719     0.200
    10.552    24.773     0.200
    10.553    25.377     0.200
    10.657    24.433     0.200
    10.765    25.535     0.200
    10.886    25.069     0.200
    10.902    25.352     0.200
    10.910    26.456     0.200
    10.951    28.238     0.200
    10.951    27.320     0.200
    10.986    27.740     0.200
    11.117    25.631     0.200
    11.208    25.657     0.200
    11.180    25.800     0.200
    11.202    25.793     0.200
    11.222    28.687     0.200
    11.222    27.793     0.200
    11.320    27.201     0.200
    11.353    26.979     0.200
    11.516    28.146     0.200
    11.504    27.451     0.200
    11.562    26.880     0.200
    11.588    26.471     0.200
    11.636    26.461     0.200
    11.718    27.140     0.200
    11.664    26.985     0.200
    11.742    29.077     0.200
    11.742    28.256     0.200
    11.742    26.674     0.200
    11.742    24.873     0.200
    11.830    27.239     0.200
    11.816    27.106     0.200
    11.963    28.549     0.200
    12.053    28.742     0.200
    12.147    28.975     0.200
    12.147    27.843     0.200
    12.121    27.640     0.200
    12.233    27.584     0.200
    12.158    28.415     0.200
    12.256    27.833     0.200
    12.320    28.242     0.200
    12.524    28.189     0.200
    12.542    27.938     0.200
    12.509    29.779     0.200
    12.482    30.582     0.200
    12.591    28.893     0.200
    12.604    29.464     0.200
    12.613    30.290     0.200
    12.727    29.317     0.200
    12.726    29.381     0.200
    12.858    29.477     0.200
    12.796    30.028     0.200
    13.120    30.048     0.200
    13.132    32.258     0.200
    13.136    30.991     0.200
    13.169    31.670     0.200
    13.167    31.830     0.200
    13.224    30.684     0.200
    13.506    31.328     0.200
    13.472    32.822     0.200
    13.602    32.174     0.200
    13.529    32.241     0.200
    13.711    31.850     0.200
    13.605    33.581     0.200
    13.598    33.004     0.200
    13.780    32.019     0.200
    13.719    33.416     0.200
    13.806    33.799     0.200
    13.879    31.622     0.200
    13.841    33.472     0.200
    13.916    32.078     0.200
    13.896    34.100     0.200
    13.979    31.653     0.200
    14.027    31.216     0.200
    14.099    31.120     0.200
    14.071    31.866     0.200
    14.164    31.447     0.200
    14.200    31.309     0.200
    14.180    32.327     0.200
    14.305    30.932     0.200
    14.284    33.146     0.200
    14.380    31.636     0.200
    14.490    31.974     0.200
    14.459    32.288     0.200
    14.463    32.752     0.200
    14.595    32.489     0.200
    14.539    32.155     0.200
    14.553    31.731     0.200
    14.631    31.511     0.200
    14.596    32.007     0.200
    14.604    32.575     0.200
    14.721    32.372     0.200
    14.736    32.829     0.200
    14.895    32.376     0.200
    14.890    33.184     0.200
    14.906    33.040     0.200
    14.931    33.201     0.200
    15.063    33.637     0.200
    15.137    33.343     0.200
    15.155    34.184     0.200
    15.185    33.727     0.200
    15.321    33.685     0.200
    15.393    34.898     0.200
    15.393    33.488     0.200
    15.495    33.429     0.200
    15.530    32.722     0.200
    15.555    34.855     0.200
    15.659    33.922     0.200
    15.679    34.083     0.200
    15.685    34.500     0.200
    15.832    34.606     0.200
    15.732    34.306     0.200
    15.755    34.492     0.200
    15.887    34.311     0.200
    15.895    34.109     0.200
    16.055    35.110     0.200
    16.165    35.498     0.200
    16.262    35.946     0.200
    16.431    34.894     0.200
    16.460    34.686     0.200
    16.528    35.757     0.200
    16.534    35.375     0.200
    16.672    35.361     0.200
    16.709    35.438     0.200
    16.729    35.518     0.200
    16.835    35.273     0.200
    16.836    35.547     0.200
    16.975    35.242     0.200
    16.999    35.733     0.200
    16.999    34.530     0.200
    17.028    35.101     0.200
    17.172    35.463     0.200
    17.287    34.662     0.200
    17.445    35.649     0.200
    17.653    35.561     0.200
    17.734    34.651     0.200
     0.493     3.399     0.200
     0.469     4.919     0.200
     0.865     6.452     0.200
     0.924     6.938     0.200
     0.940     6.844     0.200
     0.950     7.129     0.200
     1.053     7.655     0.200
     1.080     7.273     0.200
     1.087     7.006     0.200
     1.302     7.000     0.200
     1.458     7.821     0.200
     1.493     8.228     0.200
     1.934    10.460     0.200
     2.071    10.512     0.200
     2.138    10.133     0.200
     2.276     9.307     0.200
     2.369     9.570     0.200
     2.434     9.711     0.200
     3.158    12.979     0.200
     3.200    11.839     0.200
     3.231    12.936     0.200
     3.301    13.126     0.200
     3.329    13.146     0.200
     3.469    12.028     0.200
     3.342    12.613     0.200
     3.572    12.653     0.200
     3.620    12.525     0.200
     3.695    12.340     0.200
     3.698    12.494     0.200
     3.788    13.511     0.200
     3.923    13.899     0.200
     4.168    13.235     0.200
     4.221    13.351     0.200
     4.304    13.834     0.200
     4.335    13.726     0.200
     4.373    13.017     0.200
     4.377    13.589     0.200
     4.319    13.137     0.200
     4.370    13.591     0.200
     4.433    14.228     0.200
     4.406    13.788     0.200
     4.642    12.531     0.200
     4.807    14.606     0.200
     4.812    14.850     0.200
     4.719    15.782     0.200
     4.862    14.760     0.200
     4.843    13.362     0.200
     4.892    14.403     0.200
     5.100    14.698     0.200
     5.247    13.160     0.200
     5.247    13.609     0.200
     5.227    15.170     0.200
     5.336    15.492     0.200
     5.304    15.265     0.200
     5.503    15.869     0.200
     5.730    17.077     0.200
     5.763    16.917     0.200
     5.831    15.901     0.200
     5.942    16.512     0.200
     5.962    17.672     0.200
     6.208    17.213     0.200
     6.300    17.446     0.200
     6.586    17.845     0.200
     6.740    19.068     0.200
     6.727    17.919     0.200
     6.838    17.775     0.200
     6.867    18.177     0.200
     6.941    20.737     0.200
     7.059    18.785     0.200
     7.359    18.909     0.200
     7.409    19.924     0.200
     7.456    19.888     0.200
     7.614    19.814     0.200
     7.679    22.011     0.200
     7.721    20.948     0.200
     7.895    20.236     0.200
     7.878    20.430     0.200
     7.935    20.567     0.200
     7.995    22.008     0.200
     8.054    21.236     0.200
     8.429    21.624     0.200
     8.569    21.716     0.200
     8.692    21.182     0.200
     8.624    23.729     0.200
     8.792    21.201     0.200
     9.283    22.299     0.200
     9.296    22.013     0.200
     9.477    21.506     0.200
     9.460    23.353     0.200
     9.683    22.837     0.200
     9.782    23.017     0.200
    10.113    23.870     0.200
    10.604    25.715     0.200
    10.589    25.914     0.200
    10.860    26.146     0.200
    11.535    26.812     0.200
    11.999    24.097     0.200
    11.999    27.554     0.200
    16.873    35.405     0.200
    17.239    36.135     0.200
    17.798    36.060     0.200
     0.458     5.177     0.200
     0.435     5.706     0.200
     0.894     6.537     0.200
     0.937     7.059     0.200
     0.958     7.060     0.200
     1.070     7.816     0.200
     1.112     7.476     0.200
     1.444     7.989     0.200
     1.444     8.981     0.200
     2.115    10.334     0.200
     2.381    10.634     0.200
     3.206    12.729     0.200
     3.249    11.669     0.200
     3.279    12.967     0.200
     3.346    12.715     0.200
     3.350    12.826     0.200
     3.390    12.711     0.200
     3.419    13.243     0.200
     3.748    12.669     0.200
     4.321    13.211     0.200
     4.372    13.492     0.200
     5.068    14.877     0.200
     5.190    14.699     0.200
     5.446    14.557     0.200
     5.677    15.371     0.200
     5.736    16.464     0.200
     5.793    16.708     0.200
     5.873    15.277     0.200
     5.909    16.123     0.200
     6.018    14.840     0.200
     6.165    16.726     0.200
     6.249    16.456     0.200
     6.396    16.577     0.200
     6.687    17.730     0.200
     6.680    18.360     0.200
     6.849    16.653     0.200
     6.803    18.364     0.200
     6.826    18.765     0.200
     7.058    18.569     0.200
     7.315    19.497     0.200
     7.383    19.073     0.200
     7.567    18.983     0.200
     7.669    20.776     0.200
     7.795    20.036     0.200
     7.828    19.694     0.200
     7.892    20.712     0.200
     7.942    19.471     0.200
     7.965    20.897     0.200
     8.024    20.838     0.200
     8.391    21.235     0.200
     8.528    21.275     0.200
     8.588    23.628     0.200
     8.673    21.764     0.200
     8.736    21.690     0.200
     8.771    22.868     0.200
     8.996    22.940     0.200
     9.413    23.610     0.200
     9.725    23.002     0.200
     9.800    23.964     0.200
    10.056    24.203     0.200
     9.996    25.265     0.200
    10.209    25.291     0.200
    10.486    25.866     0.200
    10.554    26.240     0.200
    10.815    26.734     0.200
    11.026    26.928     0.200
    11.304    26.792     0.200
    11.478    26.337     0.200
    11.649    26.819     0.200
    11.945    24.084     0.200
    12.019    28.570     0.200
    12.096    28.804     0.200
    12.538    29.314     0.200
    12.701    29.505     0.200
    13.599    30.396     0.200
    13.665    31.608     0.200
    13.602    33.895     0.200
    13.951    31.410     0.200
    14.017    31.947     0.200
    14.241    31.970     0.200
    14.560    31.164     0.200
    14.590    31.726     0.200
    15.067    32.672     0.200
    15.439    31.371     0.200
    15.539    32.702     0.200
    15.685    32.862     0.200
    15.972    32.632     0.200
    16.067    32.415     0.200
    16.560    34.569     0.200
    16.710    34.679     0.200
    16.816    34.747     0.200
    17.046    33.628     0.200
    17.184    33.975     0.200
    17.294    35.290     0.200
     0.474     3.713     0.200
     0.442     5.110     0.200
     0.880     6.605     0.200
     0.928     6.971     0.200
     0.927     6.843     0.200
     0.947     7.010     0.200
     0.959     7.307     0.200
     1.059     7.680     0.200
     1.097     7.511     0.200
     1.266     7.010     0.200
     1.427     7.549     0.200
     1.423     7.819     0.200
     1.459     8.049     0.200
     2.009     9.218     0.200
     1.958    10.376     0.200
     2.085    10.875     0.200
     2.097    10.502     0.200
     2.332     9.391     0.200
     3.187    12.856     0.200
     3.230    13.008     0.200
     3.331    13.273     0.200
     3.338    13.140     0.200
     3.359    13.205     0.200
     3.371    13.306     0.200
     3.582    12.384     0.200
     3.648    12.858     0.200
     3.728    13.630     0.200
     3.818    13.752     0.200
     3.877    13.929     0.200
     3.953    14.169     0.200
     4.183    13.311     0.200
     4.299    13.725     0.200
     4.289    13.470     0.200
     4.335    13.628     0.200
     4.335    13.765     0.200
     4.380    13.303     0.200
     4.494    14.116     0.200
     4.606    12.534     0.200
     4.770    14.026     0.200
     4.775    14.548     0.200
     4.807    14.985     0.200
     4.824    14.521     0.200
     4.859    14.459     0.200
     5.075    14.914     0.200
     5.210    12.934     0.200
     5.210    13.979     0.200
     5.299    15.625     0.200
     5.275    15.560     0.200
     5.465    15.730     0.200
     5.887    16.323     0.200
     5.971    17.801     0.200
     6.136    16.646     0.200
     6.223    16.684     0.200
     6.265    17.020     0.200
     6.414    17.467     0.200
     6.481    16.905     0.200
     6.562    17.758     0.200
     6.661    18.252     0.200
     6.788    18.528     0.200
     6.867    18.729     0.200
     6.837    18.521     0.200
     6.904    19.563     0.200
     6.929    20.027     0.200
     6.944    20.056     0.200
     7.028    19.769     0.200
     7.025    19.092     0.200
     7.103    19.028     0.200
     7.125    17.756     0.200
     7.388    19.741     0.200
     7.429    19.651     0.200
     7.608    20.239     0.200
     7.609    20.619     0.200
     7.643    20.821     0.200
     7.683    21.092     0.200
     7.685    21.036     0.200
     7.814    20.929     0.200
     7.857    19.665     0.200
     7.904    19.933     0.200
     7.959    22.173     0.200
     7.984    20.087     0.200
     7.998    22.221     0.200
     8.382    21.222     0.200
     8.401    20.936     0.200
     8.469    21.936     0.200
     8.539    21.079     0.200
     8.655    21.129     0.200
     8.755    21.019     0.200
     8.654    22.554     0.200
     8.784    22.019     0.200
     8.940    21.756     0.200
     9.006    22.543     0.200
     9.060    22.871     0.200
     9.068    22.927     0.200
     9.120    22.759     0.200
     9.136    22.028     0.200
     9.246    21.383     0.200
     9.259    21.433     0.200
     9.367    21.822     0.200
     9.439    21.203     0.200
     9.573    22.871     0.200
     9.646    22.684     0.200
     9.744    23.158     0.200
     9.814    23.997     0.200
     9.803    24.262     0.200
     9.925    23.032     0.200
     9.935    22.615     0.200
     9.964    24.394     0.200
     9.997    25.791     0.200
    10.015    23.610     0.200
    10.040    23.191     0.200
    10.002    25.429     0.200
    10.075    23.400     0.200
    10.105    23.588     0.200
    10.099    22.345     0.200
    10.041    25.015     0.200
    10.358    24.607     0.200
    10.588    25.410     0.200
    10.828    26.090     0.200
    10.957    26.139     0.200
    11.033    28.130     0.200
    11.054    27.875     0.200
    11.112    26.993     0.200
    11.573    28.192     0.200
    11.731    27.258     0.200
    11.867    27.977     0.200
    11.962    24.294     0.200
    12.557    28.115     0.200
    12.552    27.712     0.200
    13.685    31.667     0.200
    14.128    31.986     0.200
    16.976    34.833     0.200
     0.374     5.100     0.200
     0.374     5.366     0.200
     0.518     4.535     0.200
     0.831     6.704     0.200
     0.864     7.117     0.200
     0.866     6.992     0.200
     0.888     7.217     0.200
     0.902     7.361     0.200
     0.998     7.884     0.200
     1.051     7.449     0.200
     1.062     7.165     0.200
     1.223     6.908     0.200
     1.281     7.469     0.200
     1.374     7.894     0.200
     1.389     7.377     0.200
     1.406     8.063     0.200
     1.408     7.775     0.200
     1.408     8.166     0.200
     1.972     9.155     0.200
     1.927    10.609     0.200
     2.055    10.565     0.200
     2.069    10.504     0.200
     2.133    10.911     0.200
     2.201     9.542     0.200
     2.293     9.481     0.200
     2.357     9.764     0.200
     2.361     9.656     0.200
     3.169    12.879     0.200
     3.212    11.204     0.200
     3.212    12.282     0.200
     3.242    12.969     0.200
     3.307    12.982     0.200
     3.312    13.027     0.200
     3.317    13.093     0.200
     3.322    12.831     0.200
     3.340    12.958     0.200
     3.397    12.124     0.200
     3.352    12.379     0.200
     3.380    13.046     0.200
     3.503    12.399     0.200
     3.503    11.942     0.200
     3.547    12.307     0.200
     3.615    12.711     0.200
     3.619    12.596     0.200
     3.713    13.153     0.200
     3.802    13.398     0.200
     3.880    11.503     0.200
     3.880    11.187     0.200
     3.861    13.664     0.200
     3.937    13.858     0.200
     3.971    13.445     0.200
     4.148    13.271     0.200
     4.148    13.170     0.200
     4.225    13.164     0.200
     4.225    12.973     0.200
     4.235    13.568     0.200
     4.255    13.646     0.200
     4.282    13.483     0.200
     4.282    13.237     0.200
     4.304    12.889     0.200
     4.310    13.342     0.200
     4.311    13.513     0.200
     4.364    13.987     0.200
     4.464    14.279     0.200
     4.599    12.017     0.200
     4.599    12.966     0.200
     4.623    13.918     0.200
     4.740    14.694     0.200
     4.741    14.699     0.200
     4.741    14.250     0.200
     4.761    14.689     0.200
     4.761    14.791     0.200
     4.736    15.714     0.200
     4.795    14.587     0.200
     4.754    15.432     0.200
     4.803    13.482     0.200
     4.803    13.924     0.200
     4.813    15.136     0.200
     5.005    15.111     0.200
     5.005    14.978     0.200
     5.140    15.023     0.200
     5.198    12.997     0.200
     5.198    13.528     0.200
     5.198    13.239     0.200
     5.198    14.766     0.200
     5.210    15.150     0.200
     5.210    15.345     0.200
     5.258    15.870     0.200
     5.258    14.815     0.200
     5.436    15.103     0.200
     5.436    15.665     0.200
     5.586    16.271     0.200
     5.586    16.443     0.200
     5.650    16.463     0.200
     5.650    16.018     0.200
     5.669    16.566     0.200
     5.669    17.027     0.200
     5.736    16.022     0.200
     5.817    16.771     0.200
     5.833    17.062     0.200
     5.833    16.055     0.200
     5.847    16.499     0.200
     5.912    18.200     0.200
     5.912    17.649     0.200
     5.907    18.145     0.200
     6.102    16.440     0.200
     6.115    16.762     0.200
     6.115    17.223     0.200
     6.182    17.737     0.200
     6.215    17.123     0.200
     6.215    16.927     0.200
     6.237    18.044     0.200
     6.237    17.684     0.200
     6.379    17.882     0.200
     6.385    17.953     0.200
     6.446    17.936     0.200
     6.492    18.126     0.200
     6.492    17.927     0.200
     6.627    18.409     0.200
     6.627    18.183     0.200
     6.636    18.361     0.200
     6.636    18.087     0.200
     6.658    19.168     0.200
     6.658    18.926     0.200
     6.689    18.456     0.200
     6.689    17.394     0.200
     6.743    17.727     0.200
     6.743    17.828     0.200
     6.764    17.964     0.200
     6.773    18.427     0.200
     6.773    18.009     0.200
     6.831    18.738     0.200
     6.867    19.142     0.200
     6.891    19.904     0.200
     6.953    20.096     0.200
     6.972    18.834     0.200
     6.972    18.018     0.200
     7.067    19.113     0.200
     7.101    17.605     0.200
     7.101    17.504     0.200
     7.267    19.132     0.200
     7.267    18.686     0.200
     7.316    20.440     0.200
     7.316    19.917     0.200
     7.361    19.980     0.200
     7.361    19.531     0.200
     7.524    19.566     0.200
     7.524    20.003     0.200
     7.570    20.652     0.200
     7.610    21.010     0.200
     7.613    20.651     0.200
     7.613    20.253     0.200
     7.629    20.328     0.200
     7.636    21.370     0.200
     7.636    21.074     0.200
     7.644    20.635     0.200
     7.740    20.725     0.200
     7.785    20.881     0.200
     7.792    20.040     0.200
     7.833    19.399     0.200
     7.842    20.352     0.200
     7.842    20.145     0.200
     7.914    20.671     0.200
     7.956    21.171     0.200
     7.956    20.335     0.200
     7.959    21.555     0.200
     7.959    21.067     0.200
     7.959    20.958     0.200
     8.334    21.690     0.200
     8.351    20.590     0.200
     8.428    21.995     0.200
     8.428    21.467     0.200
     8.476    20.973     0.200
     8.476    21.454     0.200
     8.497    23.049     0.200
     8.516    23.735     0.200
     8.551    23.532     0.200
     8.565    23.394     0.200
     8.636    21.057     0.200
     8.636    20.916     0.200
     8.590    23.699     0.200
     8.601    23.606     0.200
     8.636    23.153     0.200
     8.688    21.819     0.200
     8.688    20.886     0.200
     8.726    22.466     0.200
     8.726    21.935     0.200
     8.729    21.200     0.200
     8.729    20.360     0.200
     8.853    20.896     0.200
     8.857    20.997     0.200
     8.908    21.730     0.200
     8.908    21.629     0.200
     8.939    22.850     0.200
     8.939    22.452     0.200
     9.010    24.482     0.200
     9.010    24.025     0.200
     9.016    22.579     0.200
     9.030    22.224     0.200
     9.030    21.958     0.200
     9.079    22.714     0.200
     9.079    22.194     0.200
     9.103    21.417     0.200
     9.131    22.976     0.200
     9.131    22.418     0.200
     9.226    22.264     0.200
     9.235    22.152     0.200
     9.235    20.840     0.200
     9.335    22.548     0.200
     9.335    20.271     0.200
     9.369    23.599     0.200
     9.369    23.287     0.200
     9.418    21.640     0.200
     9.483    23.851     0.200
     9.483    22.953     0.200
     9.543    22.258     0.200
     9.543    21.301     0.200
     9.627    22.140     0.200
     9.627    22.367     0.200
     9.627    21.277     0.200
     9.714    22.818     0.200
     9.714    21.584     0.200
     9.734    24.754     0.200
     9.734    24.277     0.200
     9.698    24.715     0.200
     9.760    24.532     0.200
     9.760    23.915     0.200
     9.731    25.654     0.200
     9.749    25.325     0.200
     9.837    24.695     0.200
     9.837    24.144     0.200
     9.794    25.754     0.200
     9.887    23.468     0.200
     9.912    23.723     0.200
     9.930    25.100     0.200
     9.952    24.144     0.200
     9.952    23.734     0.200
     9.954    24.472     0.200
     9.954    23.745     0.200
     9.962    24.364     0.200
     9.962    24.508     0.200
     9.977    22.597     0.200
     9.977    22.714     0.200
     9.997    24.499     0.200
     9.997    24.260     0.200
    10.024    23.915     0.200
    10.050    23.834     0.200
    10.050    23.561     0.200
    10.065    22.543     0.200
    10.207    25.209     0.200
    10.169    26.207     0.200
    10.169    25.348     0.200
    10.262    25.271     0.200
    10.262    25.060     0.200
    10.291    26.466     0.200
    10.291    25.650     0.200
    10.312    24.704     0.200
    10.312    24.364     0.200
    10.317    23.980     0.200
    10.322    24.600     0.200
    10.322    23.869     0.200
    10.465    24.505     0.200
    10.446    26.758     0.200
    10.494    26.077     0.200
    10.494    25.764     0.200
    10.508    26.541     0.200
    10.531    24.625     0.200
    10.531    23.843     0.200
    10.546    24.912     0.200
    10.546    24.736     0.200
    10.560    25.634     0.200
    10.644    24.908     0.200
    10.768    26.041     0.200
    10.868    25.890     0.200
    10.875    25.293     0.200
    10.875    25.172     0.200
    10.887    24.970     0.200
    10.887    25.130     0.200
    10.901    26.280     0.200
    10.923    27.276     0.200
    10.938    26.181     0.200
    10.962    27.069     0.200
    10.991    27.000     0.200
    11.006    25.549     0.200
    11.060    26.674     0.200
    11.107    25.564     0.200
    11.177    26.670     0.200
    11.194    26.817     0.200
    11.194    25.457     0.200
    11.197    25.513     0.200
    11.236    27.564     0.200
    11.324    26.829     0.200
    11.353    27.968     0.200
    11.353    27.366     0.200
    11.512    27.362     0.200
    11.517    28.603     0.200
    11.554    26.665     0.200
    11.585    25.438     0.200
    11.630    25.003     0.200
    11.630    25.121     0.200
    11.670    28.557     0.200
    11.706    25.873     0.200
    11.724    27.168     0.200
    11.737    26.213     0.200
    11.737    25.811     0.200
    11.737    26.100     0.200
    11.737    26.522     0.200
    11.814    28.951     0.200
    11.814    28.443     0.200
    11.821    26.677     0.200
    11.913    27.932     0.200
    11.920    23.921     0.200
    11.967    28.773     0.200
    12.039    27.770     0.200
    12.053    29.048     0.200
    12.053    28.880     0.200
    12.118    26.928     0.200
    12.118    27.271     0.200
    12.134    28.321     0.200
    12.134    27.899     0.200
    12.166    29.278     0.200
    12.217    28.037     0.200
    12.248    26.650     0.200
    12.323    29.906     0.200
    12.323    29.523     0.200
    12.469    28.585     0.200
    12.489    29.977     0.200
    12.505    27.667     0.200
    12.512    28.376     0.200
    12.512    27.154     0.200
    12.531    28.868     0.200
    12.578    28.316     0.200
    12.588    28.753     0.200
    12.617    30.786     0.200
    12.617    30.165     0.200
    12.659    29.966     0.200
    12.727    29.840     0.200
    12.727    31.002     0.200
    12.727    30.197     0.200
    12.794    30.661     0.200
    12.794    30.055     0.200
    12.828    31.403     0.200
    12.841    29.439     0.200
    12.864    30.271     0.200
    12.864    29.025     0.200
    12.949    30.359     0.200
    13.102    30.023     0.200
    13.116    31.006     0.200
    13.120    30.302     0.200
    13.176    32.476     0.200
    13.223    30.954     0.200
    13.310    30.302     0.200
    13.411    27.346     0.200
    13.476    32.136     0.200
    13.490    31.779     0.200
    13.490    30.440     0.200
    13.539    34.208     0.200
    13.539    33.122     0.200
    13.584    30.533     0.200
    13.599    30.661     0.200
    13.607    32.464     0.200
    13.611    34.016     0.200
    13.611    32.196     0.200
    13.690    31.278     0.200
    13.690    30.805     0.200
    13.726    33.736     0.200
    13.726    32.841     0.200
    13.762    31.686     0.200
    13.844    33.526     0.200
    13.844    32.600     0.200
    13.864    31.392     0.200
    13.900    33.296     0.200
    13.900    32.780     0.200
    13.914    30.491     0.200
    13.968    31.389     0.200
    13.968    30.839     0.200
    13.974    29.918     0.200
    14.014    30.845     0.200
    14.070    32.425     0.200
    14.091    30.492     0.200
    14.147    31.828     0.200
    14.179    32.717     0.200
    14.179    31.814     0.200
    14.179    30.896     0.200
    14.186    34.738     0.200
    14.186    33.359     0.200
    14.282    31.560     0.200
    14.282    32.994     0.200
    14.286    33.861     0.200
    14.286    32.131     0.200
    14.286    31.127     0.200
    14.366    32.220     0.200
    14.456    32.254     0.200
    14.466    33.617     0.200
    14.474    31.649     0.200
    14.532    29.736     0.200
    14.544    32.368     0.200
    14.544    30.379     0.200
    14.574    32.141     0.200
    14.584    32.541     0.200
    14.603    33.613     0.200
    14.611    33.114     0.200
    14.611    32.181     0.200
    14.704    32.941     0.200
    14.737    34.075     0.200
    14.737    33.509     0.200
    14.886    31.405     0.200
    14.888    34.745     0.200
    14.888    31.526     0.200
    14.903    31.352     0.200
    14.934    33.490     0.200
    15.053    32.490     0.200
    15.119    31.976     0.200
    15.160    33.818     0.200
    15.185    34.391     0.200
    15.185    33.457     0.200
    15.159    33.548     0.200
    15.159    35.677     0.200
    15.288    33.666     0.200
    15.305    32.836     0.200
    15.472    31.550     0.200
    15.557    34.181     0.200
    15.641    32.667     0.200
    15.663    32.631     0.200
    15.674    32.355     0.200
    15.735    35.751     0.200
    15.735    33.451     0.200
    15.753    32.935     0.200
    15.813    32.248     0.200
    15.865    33.009     0.200
    16.048    32.382     0.200
    16.156    33.169     0.200
    16.266    35.219     0.200
    16.410    34.876     0.200
    16.437    34.856     0.200
    16.464    36.216     0.200
    16.526    35.977     0.200
    16.526    34.863     0.200
    16.532    34.523     0.200
    16.663    33.350     0.200
    16.699    34.611     0.200
    16.699    33.709     0.200
    16.724    35.635     0.200
    16.724    33.920     0.200
    16.773    34.950     0.200
    16.820    33.963     0.200
    16.832    34.555     0.200
    16.953    34.175     0.200
    16.979    34.596     0.200
    17.022    34.489     0.200
    17.022    33.110     0.200
    17.164    35.953     0.200
    17.164    33.996     0.200
    17.278    33.858     0.200
    17.426    36.316     0.200
    17.440    33.990     0.200
    17.635    35.885     0.200
    17.725    33.522     0.200
    19.307    37.545     0.200
    19.307    38.428     0.200
    20.009    36.507     0.200
     1.797     9.429     0.200
     1.821     9.660     0.200
     1.986    10.629     0.200
     1.991     9.875     0.200
     2.802    12.206     0.200
     2.893    12.240     0.200
     2.956    12.905     0.200
     2.964    11.908     0.200
     2.732    13.600     0.200
     2.905    14.769     0.200
     3.215    14.561     0.200
     4.000    14.690     0.200
     4.151    14.797     0.200
     4.217    15.495     0.200
     4.453    14.603     0.200
     4.453    14.092     0.200
     4.453    14.396     0.200
     4.312    17.545     0.200
     4.707    15.879     0.200
     4.719    15.168     0.200
     4.739    15.089     0.200
     4.739    15.597     0.200
     4.839    15.162     0.200
     4.839    15.533     0.200
     4.846    16.614     0.200
     4.846    16.493     0.200
     4.911    16.336     0.200
     4.937    16.591     0.200
     4.971    16.862     0.200
     5.188    15.234     0.200
     5.346    16.203     0.200
     5.346    17.777     0.200
     5.347    15.762     0.200
     5.347    17.122     0.200
     5.347    17.361     0.200
     5.347    17.088     0.200
     5.402    17.247     0.200
     5.419    16.952     0.200
     5.419    17.245     0.200
     5.686    17.549     0.200
     5.704    17.844     0.200
     5.794    16.570     0.200
     5.794    16.249     0.200
     5.794    16.761     0.200
     5.854    18.272     0.200
     5.854    18.674     0.200
     5.768    19.561     0.200
     5.768    18.674     0.200
     5.768    19.373     0.200
     6.020    18.431     0.200
     6.044    17.891     0.200
     6.044    18.449     0.200
     6.100    18.526     0.200
     6.190    18.004     0.200
     6.190    17.856     0.200
     6.241    18.375     0.200
     6.241    19.382     0.200
     6.257    18.756     0.200
     6.383    18.652     0.200
     6.472    19.513     0.200
     6.618    19.386     0.200
     6.618    19.218     0.200
     6.776    20.291     0.200
     6.776    19.736     0.200
     6.785    20.271     0.200
     6.785    19.712     0.200
     6.882    20.037     0.200
     6.882    19.619     0.200
     6.988    20.656     0.200
     7.050    20.418     0.200
     7.170    20.300     0.200
     7.174    19.752     0.200
     7.231    20.993     0.200
     7.231    20.286     0.200
     7.244    21.971     0.200
     7.244    20.459     0.200
     7.259    19.970     0.200
     7.432    21.615     0.200
     7.469    21.685     0.200
     7.491    21.684     0.200
     7.532    21.351     0.200
     7.532    21.086     0.200
     7.669    21.786     0.200
     7.653    21.558     0.200
     7.709    20.103     0.200
     7.709    20.435     0.200
     7.776    21.041     0.200
     7.776    20.900     0.200
     7.792    21.613     0.200
     8.062    22.121     0.200
     8.194    22.991     0.200
     8.209    23.626     0.200
     8.211    21.839     0.200
     8.234    24.045     0.200
     8.243    22.956     0.200
     8.278    23.512     0.200
     8.006    24.938     0.200
     8.029    24.585     0.200
     8.338    23.453     0.200
     8.346    22.469     0.200
     8.346    22.231     0.200
     8.356    23.053     0.200
     8.341    23.060     0.200
     8.393    22.349     0.200
     8.141    25.064     0.200
     8.441    21.859     0.200
     8.498    23.996     0.200
     8.498    24.730     0.200
     8.556    24.203     0.200
     8.564    22.975     0.200
     8.564    23.120     0.200
     8.789    23.208     0.200
     8.957    22.960     0.200
     8.957    22.753     0.200
     8.961    22.902     0.200
     8.961    22.726     0.200
     9.023    24.557     0.200
     9.023    24.674     0.200
     9.250    23.813     0.200
     9.250    23.993     0.200
     9.241    23.307     0.200
     9.241    23.439     0.200
     9.290    23.513     0.200
     9.337    23.156     0.200
     9.337    23.371     0.200
     9.392    24.909     0.200
     9.392    23.710     0.200
     9.450    23.670     0.200
     9.454    23.795     0.200
     9.513    23.651     0.200
     9.513    24.651     0.200
     9.575    25.572     0.200
     9.575    25.818     0.200
     9.592    26.747     0.200
     9.339    27.572     0.200
     9.637    24.782     0.200
     9.672    25.173     0.200
     9.672    25.399     0.200
     9.728    24.911     0.200
     9.728    24.482     0.200
     9.535    27.155     0.200
     9.842    23.813     0.200
     9.842    24.273     0.200
     9.904    25.732     0.200
     9.904    25.591     0.200
     9.941    23.611     0.200
     9.941    24.462     0.200
     9.687    28.027     0.200
     9.687    27.726     0.200
    10.024    23.952     0.200
    10.060    26.314     0.200
    10.150    24.905     0.200
    10.150    25.452     0.200
    10.231    25.572     0.200
    10.231    24.837     0.200
    10.310    26.873     0.200
    10.292    26.625     0.200
    10.321    25.876     0.200
    10.407    27.352     0.200
    10.462    26.697     0.200
    10.474    26.981     0.200
    10.542    26.619     0.200
    10.549    26.339     0.200
    10.578    25.173     0.200
    10.599    27.496     0.200
    10.658    26.077     0.200
    10.668    25.242     0.200
    10.751    28.055     0.200
    10.831    28.504     0.200
    10.919    26.227     0.200
    10.919    27.899     0.200
    10.927    26.665     0.200
    11.013    27.877     0.200
    11.133    26.254     0.200
    11.138    26.673     0.200
    11.252    27.351     0.200
    11.279    28.647     0.200
    11.278    28.885     0.200
    11.349    29.410     0.200
    11.431    28.338     0.200
    11.472    29.262     0.200
    11.483    27.975     0.200
    11.489    27.979     0.200
    11.564    29.534     0.200
    11.620    28.990     0.200
    11.713    27.944     0.200
    11.747    29.585     0.200
    11.781    28.988     0.200
    11.800    28.964     0.200
    11.824    30.195     0.200
    11.901    29.990     0.200
    11.956    28.559     0.200
    12.136    30.705     0.200
    12.156    29.833     0.200
    12.162    29.340     0.200
    12.224    27.458     0.200
    12.325    27.946     0.200
    12.325    27.043     0.200
    12.325    28.317     0.200
    12.325    27.286     0.200
    12.314    29.494     0.200
    12.372    30.185     0.200
    12.425    28.781     0.200
    12.456    30.817     0.200
    12.513    26.916     0.200
    12.588    31.131     0.200
    12.603    30.227     0.200
    12.626    27.821     0.200
    12.688    29.726     0.200
    12.741    31.338     0.200
    12.832    32.086     0.200
    12.814    30.928     0.200
    12.846    28.647     0.200
    12.942    32.371     0.200
    13.085    31.390     0.200
    13.074    31.286     0.200
    13.109    32.679     0.200
    13.120    30.399     0.200
    13.185    30.959     0.200
    13.189    32.383     0.200
    13.257    32.448     0.200
    13.250    32.519     0.200
    13.274    32.493     0.200
    13.354    31.861     0.200
    13.456    32.028     0.200
    13.432    32.788     0.200
    13.549    33.079     0.200
    13.601    32.040     0.200
    13.707    33.310     0.200
    13.683    33.389     0.200
    13.716    33.975     0.200
    13.716    33.242     0.200
    13.777    32.879     0.200
    13.884    33.244     0.200
    13.936    33.302     0.200
    13.975    33.027     0.200
    14.010    30.192     0.200
    14.030    33.211     0.200
    14.089    34.206     0.200
    14.084    33.049     0.200
    14.172    32.994     0.200
    14.170    33.911     0.200
    14.204    33.298     0.200
    14.261    32.613     0.200
    14.243    33.397     0.200
    14.360    33.984     0.200
    14.339    33.537     0.200
    14.393    33.789     0.200
    14.479    32.308     0.200
    14.462    33.549     0.200
    14.576    33.215     0.200
    14.621    34.147     0.200
    14.621    32.534     0.200
    14.649    34.678     0.200
    14.692    32.529     0.200
    14.739    33.999     0.200
    14.714    34.255     0.200
    14.714    33.744     0.200
    14.839    34.114     0.200
    14.862    37.427     0.200
    14.862    35.572     0.200
    14.972    34.800     0.200
    14.971    34.663     0.200
    14.993    33.227     0.200
    14.771    36.439     0.200
    15.031    34.503     0.200
    15.071    34.584     0.200
    15.129    33.948     0.200
    15.150    34.626     0.200
    15.148    33.704     0.200
    15.118    35.577     0.200
    15.118    34.339     0.200
    15.191    34.927     0.200
    15.191    34.606     0.200
    15.169    36.694     0.200
    15.215    34.866     0.200
    15.215    35.487     0.200
    15.274    34.979     0.200
    15.274    35.706     0.200
    15.240    36.823     0.200
    15.294    35.275     0.200
    15.294    36.842     0.200
    15.439    35.261     0.200
    15.466    34.946     0.200
    15.466    34.665     0.200
    15.474    34.284     0.200
    15.474    34.991     0.200
    15.482    34.348     0.200
    15.643    34.843     0.200
    15.659    35.038     0.200
    15.659    34.761     0.200
    15.732    36.264     0.200
    15.732    34.831     0.200
    15.695    36.393     0.200
    15.736    34.879     0.200
    15.906    36.107     0.200
    15.906    34.834     0.200
    15.990    36.501     0.200
    15.990    34.794     0.200
    15.991    36.611     0.200
    16.087    36.182     0.200
    16.087    35.131     0.200
    16.124    33.895     0.200
    16.070    36.357     0.200
    16.245    34.965     0.200
    16.224    36.354     0.200
    16.255    37.291     0.200
    16.281    35.961     0.200
    16.281    36.090     0.200
    16.311    36.163     0.200
    16.311    35.620     0.200
    16.380    37.482     0.200
    16.390    37.771     0.200
    16.475    35.964     0.200
    16.541    36.522     0.200
    16.541    35.608     0.200
    16.647    35.420     0.200
    16.760    35.795     0.200
    16.919    37.403     0.200
    16.962    36.232     0.200
    16.942    36.844     0.200
    17.092    36.028     0.200
    17.092    36.942     0.200
    17.265    35.392     0.200
    17.311    35.212     0.200
    17.306    36.419     0.200
    17.410    35.937     0.200
    17.421    35.435     0.200
    17.491    37.213     0.200
    17.539    37.359     0.200
    17.614    35.684     0.200
    17.763    35.373     0.200
    17.882    35.837     0.200
    19.564    39.370     0.200
    19.760    39.200     0.200
     0.432     4.956     0.200
     0.511     3.980     0.200
     0.842     6.416     0.200
     0.893     6.787     0.200
     0.891     6.797     0.200
     0.911     6.883     0.200
     0.923     7.214     0.200
     1.023     7.528     0.200
     1.059     7.185     0.200
     1.067     6.984     0.200
     1.276     7.026     0.200
     1.337     7.428     0.200
     1.430     7.705     0.200
     1.464     7.895     0.200
     1.921    10.398     0.200
     2.048    10.666     0.200
     2.252     9.139     0.200
     2.410     9.649     0.200
     3.152    12.761     0.200
     3.195    12.846     0.200
     3.225    12.839     0.200
     3.296    12.659     0.200
     3.324    12.562     0.200
     3.336    11.296     0.200
     3.551    12.585     0.200
     3.597    12.280     0.200
     3.671    12.516     0.200
     3.694    13.169     0.200
     3.910    12.331     0.200
     3.784    13.246     0.200
     3.842    13.459     0.200
     3.919    13.538     0.200
     4.284    13.520     0.200
     4.284    12.965     0.200
     4.353    13.545     0.200
     4.339    13.471     0.200
     4.412    13.778     0.200
     4.369    13.484     0.200
     4.512    14.170     0.200
     4.634    12.747     0.200
     4.670    13.300     0.200
     4.787    14.553     0.200
     4.791    14.693     0.200
     4.816    14.610     0.200
     4.716    15.438     0.200
     4.861    14.397     0.200
     5.063    14.744     0.200
     5.197    14.779     0.200
     5.235    13.469     0.200
     5.235    15.243     0.200
     5.269    15.280     0.200
     5.311    14.923     0.200
     5.483    15.648     0.200
     5.704    15.226     0.200
     5.725    16.711     0.200
     5.795    15.697     0.200
     5.890    16.680     0.200
     5.905    16.360     0.200
     5.885    19.045     0.200
     5.934    17.587     0.200
     6.174    17.287     0.200
     6.271    18.014     0.200
     6.287    18.309     0.200
     6.549    17.524     0.200
     6.694    17.858     0.200
     6.713    19.090     0.200
     6.802    17.335     0.200
     6.832    18.338     0.200
     7.029    18.467     0.200
     7.325    18.872     0.200
     7.371    19.652     0.200
     7.419    19.827     0.200
     7.582    19.510     0.200
     7.692    21.226     0.200
     7.832    21.185     0.200
     7.849    20.907     0.200
     7.878    20.045     0.200
     7.901    20.787     0.200
     7.968    22.394     0.200
     8.011    20.773     0.200
     8.016    21.037     0.200
     8.393    21.516     0.200
     8.534    20.845     0.200
     8.774    22.133     0.200
     8.784    21.964     0.200
    11.974    27.339     0.200
    12.026    29.015     0.200
    12.111    29.609     0.200
    12.577    29.478     0.200
    12.877    30.707     0.200
    13.716    31.891     0.200
    13.902    31.393     0.200
    13.864    33.684     0.200
    14.015    32.716     0.200
    14.142    33.562     0.200
    14.339    33.602     0.200
    14.408    33.192     0.200
    14.638    31.778     0.200
    14.629    33.092     0.200
    15.572    34.819     0.200
    15.615    35.237     0.200
    15.810    36.263     0.200
    16.099    35.368     0.200
    16.206    36.297     0.200
    16.860    35.943     0.200
    17.775    35.702     0.200
     1.769    10.688     0.200
     1.675    10.979     0.200
     1.916    10.917     0.200
     1.945    11.334     0.200
     1.946    11.549     0.200
     1.865    11.451     0.200
     2.747    12.592     0.200
     2.807    14.202     0.200
     2.851    15.352     0.200
     2.851    15.125     0.200
     2.880    14.336     0.200
     2.978    14.381     0.200
     2.999    15.156     0.200
     3.332    15.237     0.200
     3.332    14.878     0.200
     3.428    15.400     0.200
     3.481    15.781     0.200
     3.594    15.995     0.200
     4.356    15.588     0.200
     4.356    15.029     0.200
     4.716    15.883     0.200
     4.755    17.081     0.200
     5.096    15.949     0.200
     5.096    16.480     0.200
     5.326    18.871     0.200
     5.439    18.284     0.200
     5.674    19.383     0.200
     5.689    19.580     0.200
     5.708    16.310     0.200
     5.708    18.353     0.200
     5.878    20.323     0.200
     6.056    21.051     0.200
     6.091    20.502     0.200
     6.200    19.320     0.200
     6.279    20.122     0.200
     6.532    20.207     0.200
     6.613    21.282     0.200
     6.909    21.354     0.200
     7.153    22.344     0.200
     7.191    21.107     0.200
     7.692    23.081     0.200
     7.768    22.475     0.200
     7.809    23.058     0.200
     8.326    25.536     0.200
     8.341    23.933     0.200
     8.367    24.019     0.200
     8.370    24.079     0.200
     8.799    25.265     0.200
     8.962    25.216     0.200
     9.160    24.896     0.200
     9.266    25.328     0.200
     9.752    26.401     0.200
     9.947    25.617     0.200
     9.804    30.009     0.200
    10.287    28.433     0.200
    10.462    28.007     0.200
    13.957    33.064     0.200
    14.125    35.182     0.200
    14.139    35.206     0.200
    14.325    34.616     0.200
    14.892    34.297     0.200
    16.067    38.324     0.200
    17.241    38.036     0.200
     1.298     7.469     0.200
     1.654     8.690     0.200
     1.781     7.151     0.200
     1.866     8.896     0.200
     2.032     9.717     0.200
     2.044     9.326     0.200
     2.852     9.690     0.200
     2.891    11.056     0.200
     2.912    11.392     0.200
     2.985    11.624     0.200
     3.024    11.446     0.200
     3.169    12.417     0.200
     3.475    12.075     0.200
     3.595    12.217     0.200
     3.635    11.356     0.200
     3.675    12.107     0.200
     3.739    12.715     0.200
     3.739    13.215     0.200
     3.819    12.953     0.200
     3.819    13.144     0.200
     3.858    12.995     0.200
     3.858    13.385     0.200
     3.963    12.404     0.200
     3.963    12.634     0.200
     4.106    13.351     0.200
     4.141    13.128     0.200
     4.281    12.502     0.200
     4.281    12.158     0.200
     4.281    12.717     0.200
     4.325    13.846     0.200
     4.389    13.571     0.200
     4.409    14.238     0.200
     4.509    14.627     0.200
     4.520    14.738     0.200
     4.553    14.576     0.200
     4.580    14.843     0.200
     4.610    14.538     0.200
     4.668    14.006     0.200
     4.750    13.914     0.200
     4.900    14.866     0.200
     4.993    14.882     0.200
     5.208    15.133     0.200
     5.314    15.908     0.200
     5.635    16.063     0.200
     5.693    16.523     0.200
     5.776    16.487     0.200
     5.778    16.279     0.200
     5.840    16.615     0.200
     5.901    16.469     0.200
     5.906    16.985     0.200
     5.957    16.139     0.200
     5.938    17.203     0.200
     5.995    16.292     0.200
     6.000    16.805     0.200
     5.970    16.625     0.200
     6.108    17.511     0.200
     6.111    17.823     0.200
     6.235    17.635     0.200
     6.248    17.076     0.200
     6.291    16.074     0.200
     6.324    16.597     0.200
     6.332    17.457     0.200
     6.389    17.718     0.200
     6.419    17.880     0.200
     6.475    17.613     0.200
     6.701    18.299     0.200
     6.958    18.652     0.200
     7.068    18.276     0.200
     7.086    19.396     0.200
     7.039    19.618     0.200
     7.075    19.062     0.200
     7.189    19.440     0.200
     7.158    19.594     0.200
     7.282    19.922     0.200
     7.351    19.295     0.200
     7.414    19.497     0.200
     7.475    19.722     0.200
     7.665    19.471     0.200
     7.766    18.964     0.200
     7.912    19.489     0.200
     7.904    20.054     0.200
     7.966    19.480     0.200
     8.239    20.870     0.200
     8.319    20.626     0.200
     8.432    19.730     0.200
     8.441    20.276     0.200
     8.491    21.367     0.200
     8.556    21.365     0.200
     8.586    19.832     0.200
     8.652    21.313     0.200
     8.719    21.767     0.200
     8.759    20.774     0.200
     9.008    21.687     0.200
     8.997    21.521     0.200
     9.083    22.896     0.200
     9.120    21.759     0.200
     9.185    23.100     0.200
     9.263    21.913     0.200
     9.302    21.490     0.200
     9.380    21.399     0.200
     9.419    21.697     0.200
     9.460    22.015     0.200
     9.471    22.988     0.200
     9.473    24.210     0.200
     9.503    23.961     0.200
     9.543    22.712     0.200
     9.579    23.410     0.200
     9.691    23.917     0.200
     9.772    22.879     0.200
     9.744    25.497     0.200
     9.806    22.666     0.200
     9.797    23.640     0.200
     9.827    24.402     0.200
     9.864    24.841     0.200
     9.908    22.735     0.200
     9.962    23.497     0.200
    10.044    23.515     0.200
    10.071    23.391     0.200
    10.280    24.496     0.200
    10.278    25.668     0.200
    10.331    24.499     0.200
    10.801    24.269     0.200
    10.850    23.621     0.200
    10.985    25.389     0.200
    11.165    26.741     0.200
    11.155    27.864     0.200
    11.245    24.795     0.200
    11.269    27.685     0.200
    11.238    27.369     0.200
    11.391    23.867     0.200
    11.391    23.637     0.200
    11.391    24.086     0.200
    11.369    27.544     0.200
    11.369    27.751     0.200
    11.648    27.748     0.200
    11.757    27.178     0.200
    12.518    29.607     0.200
    12.732    30.018     0.200
    12.924    29.956     0.200
    13.033    28.726     0.200
    13.162    30.014     0.200
    13.213    30.850     0.200
    13.233    29.811     0.200
    13.334    31.617     0.200
    13.524    31.369     0.200
    13.781    32.276     0.200
    13.880    31.703     0.200
    14.067    32.000     0.200
    14.228    34.443     0.200
    14.302    31.068     0.200
    14.613    33.545     0.200
    14.703    32.259     0.200
    14.873    32.992     0.200
    14.939    33.810     0.200
    15.293    33.998     0.200
    15.405    33.508     0.200
    15.558    33.646     0.200
    15.809    34.353     0.200
    15.879    37.239     0.200
    16.148    35.827     0.200
    16.219    35.123     0.200
    16.382    35.036     0.200
    16.382    34.712     0.200
    16.382    34.841     0.200
    16.605    34.536     0.200
    17.072    34.966     0.200
    17.652    36.591     0.200
    17.652    36.763     0.200
     1.036     6.827     0.200
     1.061     6.698     0.200
     1.151     6.879     0.200
     1.692     8.769     0.200
     1.787     9.079     0.200
     1.816     8.501     0.200
     1.875     9.722     0.200
     2.022    10.236     0.200
     2.150    10.565     0.200
     2.752    10.376     0.200
     2.752    10.579     0.200
     2.835     9.496     0.200
     2.889    10.788     0.200
     3.024    11.972     0.200
     3.052    13.076     0.200
     3.196    12.924     0.200
     3.434    11.046     0.200
     3.507    11.552     0.200
     3.543    12.340     0.200
     3.600    10.450     0.200
     3.562    11.409     0.200
     3.625    12.780     0.200
     3.857    12.934     0.200
     3.857    13.239     0.200
     4.234    12.125     0.200
     4.234    12.562     0.200
     4.131    12.406     0.200
     4.239    13.949     0.200
     4.335    15.694     0.200
     4.408    14.124     0.200
     4.493    14.407     0.200
     4.652    14.189     0.200
     4.833    14.206     0.200
     5.070    14.620     0.200
     5.113    15.267     0.200
     5.135    15.548     0.200
     5.469    15.803     0.200
     5.667    16.275     0.200
     5.748    16.393     0.200
     5.917    16.036     0.200
     5.925    16.773     0.200
     5.906    17.583     0.200
     5.939    17.040     0.200
     6.097    17.275     0.200
     6.135    17.237     0.200
     6.326    18.212     0.200
     6.631    17.669     0.200
     6.617    18.295     0.200
     6.692    18.375     0.200
     6.971    19.639     0.200
     6.981    19.692     0.200
     6.875    19.734     0.200
     7.184    19.852     0.200
     7.296    19.612     0.200
     7.341    20.364     0.200
     7.334    20.193     0.200
     7.366    20.145     0.200
     7.550    20.840     0.200
     7.621    19.989     0.200
     7.784    20.482     0.200
     7.889    20.203     0.200
     8.083    20.783     0.200
     8.345    20.838     0.200
     8.309    21.435     0.200
     8.422    22.301     0.200
     9.077    22.752     0.200
     9.022    22.825     0.200
     9.348    24.913     0.200
     9.657    24.319     0.200
    11.274    22.500     0.200
    11.761    28.699     0.200
    12.045    29.194     0.200
    12.397    30.164     0.200
    12.602    29.289     0.200
    12.682    29.678     0.200
    13.124    32.354     0.200
    13.430    32.653     0.200
    13.426    32.218     0.200
    13.635    32.687     0.200
    13.672    33.742     0.200
    13.788    31.812     0.200
    14.047    34.146     0.200
    14.958    35.279     0.200
    15.289    35.072     0.200
    15.281    35.260     0.200
    15.445    35.232     0.200
    15.647    35.334     0.200
    15.889    36.406     0.200
    15.925    35.737     0.200
    16.366    36.169     0.200
    16.515    36.447     0.200
     1.589    10.185     0.200
     1.757     9.348     0.200
     1.704    10.575     0.200
     1.711    10.550     0.200
     1.897    10.544     0.200
     1.781    10.743     0.200
     1.979    10.653     0.200
     2.738    11.838     0.200
     2.739    12.923     0.200
     2.782    13.555     0.200
     2.812    12.845     0.200
     2.884    12.904     0.200
     2.910    12.886     0.200
     2.929    13.172     0.200
     3.368    11.757     0.200
     3.268    13.169     0.200
     3.362    13.286     0.200
     3.494    13.576     0.200
     3.936    14.096     0.200
     4.045    14.617     0.200
     4.087    13.393     0.200
     4.153    14.046     0.200
     4.391    13.854     0.200
     4.642    15.520     0.200
     4.688    15.156     0.200
     4.666    14.857     0.200
     4.742    15.523     0.200
     4.693    15.550     0.200
     4.777    15.759     0.200
     4.780    15.588     0.200
     4.847    15.266     0.200
     4.906    16.044     0.200
     5.124    14.630     0.200
     5.284    17.252     0.200
     5.289    16.561     0.200
     5.374    16.586     0.200
     5.644    17.477     0.200
     5.635    16.913     0.200
     5.730    15.549     0.200
     5.730    15.685     0.200
     5.782    19.365     0.200
     5.979    17.283     0.200
     5.982    18.255     0.200
     6.045    18.536     0.200
     6.142    17.944     0.200
     6.178    19.221     0.200
     6.213    18.201     0.200
     6.325    18.397     0.200
     6.446    18.806     0.200
     6.565    18.976     0.200
     6.840    19.228     0.200
     7.113    19.915     0.200
     7.128    19.671     0.200
     7.181    21.150     0.200
     7.207    20.348     0.200
     7.306    20.362     0.200
     7.473    20.978     0.200
     7.617    21.381     0.200
     7.721    20.916     0.200
     7.747    21.614     0.200
     8.005    22.003     0.200
     8.293    22.578     0.200
     8.300    22.684     0.200
     9.176    23.416     0.200
     9.777    23.816     0.200
     9.959    23.363     0.200
    12.450    26.461     0.200
     1.177     6.725     0.200
     1.181     7.225     0.200
     1.202     7.364     0.200
     1.314     7.133     0.200
     1.232     7.492     0.200
     1.358     7.886     0.200
     1.408     7.969     0.200
     1.409     8.267     0.200
     1.340     8.236     0.200
     1.400     8.148     0.200
     1.410     7.890     0.200
     1.880     9.260     0.200
     2.113     9.277     0.200
     2.209     9.646     0.200
     2.277    10.190     0.200
     2.264    11.349     0.200
     2.391    11.609     0.200
     2.401    11.172     0.200
     2.595     9.356     0.200
     2.468    11.400     0.200
     3.286    11.692     0.200
     3.370    12.385     0.200
     3.484    13.656     0.200
     3.621    11.314     0.200
     3.621    11.194     0.200
     3.527    14.014     0.200
     3.557    13.664     0.200
     3.625    13.583     0.200
     3.627    13.682     0.200
     3.637    14.064     0.200
     3.638    14.200     0.200
     3.656    13.755     0.200
     3.670    13.637     0.200
     3.963    13.087     0.200
     4.054    13.225     0.200
     4.022    14.637     0.200
     4.168    13.779     0.200
     4.275    13.962     0.200
     4.323    13.781     0.200
     4.297    13.481     0.200
     4.363    12.354     0.200
     4.247    14.541     0.200
     4.440    14.043     0.200
     4.702    14.652     0.200
     4.812    14.470     0.200
     4.979    13.387     0.200
     5.041    16.620     0.200
     5.141    15.167     0.200
     5.289    15.713     0.200
     5.293    16.281     0.200
     5.576    16.627     0.200
     5.830    16.570     0.200
     5.837    16.623     0.200
     5.844    17.100     0.200
     5.974    17.224     0.200
     5.982    16.852     0.200
     6.096    17.595     0.200
     6.180    17.782     0.200
     6.261    17.635     0.200
     6.264    18.077     0.200
     6.326    17.705     0.200
     6.254    18.786     0.200
     6.254    18.036     0.200
     6.501    17.994     0.200
     6.532    19.341     0.200
     6.472    18.116     0.200
     6.596    17.574     0.200
     6.638    18.075     0.200
     6.756    19.403     0.200
     6.787    19.612     0.200
     6.848    19.353     0.200
     6.842    18.525     0.200
     6.887    17.116     0.200
     6.883    19.789     0.200
     6.860    17.849     0.200
     6.931    17.270     0.200
     6.953    18.492     0.200
     6.952    18.740     0.200
     7.311    19.660     0.200
     7.476    20.781     0.200
     7.475    20.487     0.200
     7.515    20.976     0.200
     7.495    20.440     0.200
     7.542    21.010     0.200
     7.534    20.174     0.200
     7.640    21.611     0.200
     7.661    19.915     0.200
     7.764    21.178     0.200
     7.848    21.553     0.200
     7.861    21.334     0.200
     7.890    20.828     0.200
     8.109    21.390     0.200
     8.211    20.389     0.200
     8.338    21.531     0.200
     8.440    20.184     0.200
     8.428    21.685     0.200
     8.566    20.281     0.200
     8.541    21.128     0.200
     8.749    22.781     0.200
     8.774    22.138     0.200
     8.990    22.320     0.200
     8.865    24.611     0.200
     9.033    21.178     0.200
     9.060    20.173     0.200
     9.034    22.903     0.200
     8.949    24.441     0.200
     9.234    20.254     0.200
     9.380    23.917     0.200
     9.567    22.217     0.200
     9.732    24.084     0.200
     9.732    22.517     0.200
     9.817    23.386     0.200
     9.881    23.009     0.200
     9.886    23.066     0.200
    10.079    25.165     0.200
    10.488    27.986     0.200
    11.057    27.802     0.200
    11.371    27.106     0.200
    11.522    28.191     0.200
    11.572    27.303     0.200
    11.661    28.592     0.200
    11.833    25.083     0.200
    11.833    26.483     0.200
    12.041    28.460     0.200
    12.368    28.325     0.200
    13.262    30.975     0.200
    13.812    31.073     0.200
    13.885    31.533     0.200
    13.915    31.104     0.200
    13.978    31.195     0.200
    14.030    33.946     0.200
    14.170    31.959     0.200
    14.287    31.881     0.200
    14.406    33.855     0.200
    14.404    33.464     0.200
    14.417    30.923     0.200
    14.741    32.782     0.200
    14.863    33.397     0.200
    15.095    33.153     0.200
    15.168    33.760     0.200
    15.394    35.398     0.200
    15.546    35.492     0.200
    15.567    34.955     0.200
    15.936    33.787     0.200
    18.156    36.292     0.200
     1.148     8.313     0.200
     1.255     9.019     0.200
     1.624     9.057     0.200
     1.789    10.284     0.200
     1.829    10.046     0.200
     1.829    10.594     0.200
     1.941    12.082     0.200
     2.064    12.052     0.200
     2.134    12.350     0.200
     2.587    11.635     0.200
     2.682    11.849     0.200
     2.748    11.903     0.200
     3.066    11.733     0.200
     3.066    11.425     0.200
     3.084    14.760     0.200
     3.128    15.211     0.200
     3.227    14.994     0.200
     3.230    14.816     0.200
     3.240    14.860     0.200
     3.246    14.676     0.200
     3.255    14.969     0.200
     3.276    15.734     0.200
     3.301    14.699     0.200
     3.772    13.959     0.200
     3.609    15.402     0.200
     3.609    15.603     0.200
     3.863    14.718     0.200
     3.920    14.223     0.200
     3.705    15.441     0.200
     4.005    14.653     0.200
     3.834    15.928     0.200
     4.108    13.779     0.200
     4.108    13.568     0.200
     4.457    15.262     0.200
     4.520    15.313     0.200
     4.550    15.456     0.200
     4.596    15.751     0.200
     4.654    15.849     0.200
     4.662    15.262     0.200
     4.661    15.540     0.200
     4.664    15.024     0.200
     4.707    15.586     0.200
     4.722    16.152     0.200
     4.747    15.764     0.200
     4.534    17.749     0.200
     4.818    16.574     0.200
     4.616    17.800     0.200
     4.858    14.819     0.200
     4.858    14.630     0.200
     4.975    15.937     0.200
     5.094    16.486     0.200
     5.107    16.473     0.200
     5.146    16.590     0.200
     5.166    16.857     0.200
     5.232    16.772     0.200
     5.440    17.181     0.200
     5.478    15.959     0.200
     5.478    15.772     0.200
     5.561    17.418     0.200
     5.647    17.938     0.200
     5.650    17.503     0.200
     5.786    17.675     0.200
     5.773    20.170     0.200
     6.023    18.661     0.200
     6.048    18.816     0.200
     5.857    21.366     0.200
     6.091    19.426     0.200
     6.162    19.365     0.200
     6.179    19.723     0.200
     6.179    19.071     0.200
     6.175    18.265     0.200
     6.104    20.476     0.200
     6.104    20.365     0.200
     6.260    19.044     0.200
     6.281    19.021     0.200
     6.467    19.365     0.200
     6.553    19.866     0.200
     6.574    19.620     0.200
     6.631    19.920     0.200
     6.624    19.742     0.200
     6.750    19.420     0.200
     6.923    19.605     0.200
     6.993    20.483     0.200
     7.030    21.099     0.200
     7.061    20.811     0.200
     7.068    20.560     0.200
     7.096    19.398     0.200
     7.180    20.028     0.200
     7.207    20.151     0.200
     7.212    20.626     0.200
     7.387    19.561     0.200
     7.394    21.575     0.200
     7.431    19.459     0.200
     7.704    21.295     0.200
     7.735    21.911     0.200
     7.798    22.389     0.200
     7.955    21.773     0.200
     8.027    21.844     0.200
     8.050    23.176     0.200
     8.133    22.192     0.200
     8.161    22.033     0.200
     8.211    22.962     0.200
     8.280    22.600     0.200
     8.298    23.057     0.200
     8.316    24.052     0.200
     8.344    23.090     0.200
     8.389    23.320     0.200
     8.707    22.883     0.200
     8.533    25.532     0.200
     8.533    25.872     0.200
     8.773    23.562     0.200
     8.818    23.621     0.200
     8.915    22.981     0.200
     8.940    22.831     0.200
     9.066    23.580     0.200
     9.133    23.563     0.200
     9.159    24.405     0.200
     9.269    24.048     0.200
     9.378    25.400     0.200
     9.437    25.023     0.200
     9.466    23.986     0.200
     9.534    23.803     0.200
     9.561    23.789     0.200
     9.693    24.097     0.200
     9.735    23.688     0.200
     9.801    26.352     0.200
     9.933    25.100     0.200
    10.229    26.120     0.200
    10.278    27.250     0.200
    10.081    28.873     0.200
    10.382    25.739     0.200
    11.161    27.831     0.200
    11.394    30.180     0.200
    11.465    27.514     0.200
    11.591    29.380     0.200
    11.779    29.898     0.200
    11.768    28.649     0.200
    11.927    28.541     0.200
    11.947    30.536     0.200
    11.945    29.481     0.200
    11.950    30.614     0.200
    11.993    29.228     0.200
    12.070    29.155     0.200
    12.070    28.846     0.200
    12.135    30.698     0.200
    12.135    29.897     0.200
    12.135    27.567     0.200
    12.144    30.207     0.200
    12.236    30.422     0.200
    12.312    28.490     0.200
    12.312    26.799     0.200
    12.529    31.296     0.200
    12.868    30.061     0.200
    12.912    30.706     0.200
    12.928    32.991     0.200
    13.056    32.873     0.200
    13.099    32.086     0.200
    13.160    32.361     0.200
    13.215    32.577     0.200
    13.257    30.976     0.200
    14.513    36.548     0.200
    14.671    35.196     0.200
    14.876    37.113     0.200
    14.952    35.085     0.200
    14.960    34.882     0.200
    14.960    35.302     0.200
    15.278    35.094     0.200
    15.292    36.839     0.200
    15.316    36.727     0.200
    15.988    36.453     0.200
    16.942    37.854     0.200
    17.050    37.002     0.200
    17.176    37.573     0.200
     1.093     6.537     0.200
     1.093     6.733     0.200
     1.189     6.651     0.200
     1.293     7.656     0.200
     1.357     8.140     0.200
     1.358     8.178     0.200
     1.515     8.362     0.200
     1.526     7.812     0.200
     1.558     8.689     0.200
     1.658     9.263     0.200
     1.748     9.216     0.200
     1.761     8.956     0.200
     1.940     8.836     0.200
     2.083     9.258     0.200
     2.108     9.633     0.200
     2.627    12.159     0.200
     2.754    12.458     0.200
     2.831    12.255     0.200
     3.074    11.369     0.200
     3.135    11.792     0.200
     3.211    12.024     0.200
     3.217    11.698     0.200
     3.284    10.092     0.200
     3.330    11.850     0.200
     3.809    12.473     0.200
     3.865    12.635     0.200
     3.925    12.464     0.200
     3.850    14.411     0.200
     3.893    14.105     0.200
     3.923    14.450     0.200
     4.040    11.125     0.200
     4.021    14.512     0.200
     4.036    14.202     0.200
     4.156    13.520     0.200
     4.257    13.879     0.200
     4.381    13.534     0.200
     4.387    14.477     0.200
     4.461    14.080     0.200
     4.528    13.710     0.200
     4.479    15.031     0.200
     4.667    12.625     0.200
     4.705    14.237     0.200
     4.980    14.936     0.200
     5.033    14.932     0.200
     5.167    14.941     0.200
     5.261    16.054     0.200
     5.384    15.805     0.200
     5.553    16.903     0.200
     5.706    16.098     0.200
     5.820    17.165     0.200
     5.912    17.304     0.200
     6.003    17.268     0.200
     6.024    16.981     0.200
     6.099    17.583     0.200
     6.320    17.009     0.200
     6.407    17.851     0.200
     6.491    19.091     0.200
     6.546    18.349     0.200
     6.560    19.103     0.200
     6.653    16.321     0.200
     6.610    18.458     0.200
     6.671    18.412     0.200
     6.789    17.984     0.200
     6.858    18.461     0.200
     7.230    19.213     0.200
     7.372    19.420     0.200
     7.380    19.717     0.200
     7.418    19.812     0.200
     7.427    20.314     0.200
     7.469    20.146     0.200
     7.562    20.419     0.200
     7.611    21.158     0.200
     7.658    20.387     0.200
     8.126    20.885     0.200
     8.141    21.083     0.200
     8.292    20.432     0.200
     8.397    22.166     0.200
     8.481    21.514     0.200
     8.645    22.501     0.200
     8.735    21.415     0.200
     8.943    20.278     0.200
     9.003    23.252     0.200
     9.305    22.907     0.200
     9.601    22.758     0.200
    10.598    25.955     0.200
    10.853    28.181     0.200
    11.396    27.706     0.200
    12.263    29.729     0.200
    13.107    30.388     0.200
    14.169    31.978     0.200
    14.216    31.455     0.200
    15.156    34.909     0.200
    15.444    36.005     0.200
    15.641    35.479     0.200
    15.701    35.532     0.200
    16.287    35.851     0.200
    16.302    36.129     0.200
    16.899    36.541     0.200
     1.795     8.417     0.200
     1.795     9.499     0.200
     1.963     9.172     0.200
     2.016    10.620     0.200
     2.774    11.084     0.200
     2.774    11.893     0.200
     2.731    13.559     0.200
     2.929    12.705     0.200
     2.775    13.768     0.200
     2.775    12.632     0.200
     2.922    13.039     0.200
     3.388    12.508     0.200
     3.388    11.367     0.200
     3.258    13.836     0.200
     3.258    13.586     0.200
     4.156    15.446     0.200
     4.186    16.545     0.200
     4.415    14.431     0.200
     4.415    13.271     0.200
     4.355    16.770     0.200
     4.708    14.678     0.200
     4.735    15.290     0.200
     4.821    14.873     0.200
     4.881    15.022     0.200
     4.887    15.952     0.200
     5.041    16.764     0.200
     5.150    15.045     0.200
     5.200    16.469     0.200
     5.323    16.140     0.200
     5.758    16.335     0.200
     5.758    16.050     0.200
     5.758    17.089     0.200
     5.802    18.846     0.200
     5.802    18.725     0.200
     6.184    17.844     0.200
     6.397    19.211     0.200
     6.397    19.002     0.200
     6.751    20.335     0.200
     6.954    20.253     0.200
     6.960    20.763     0.200
     7.022    20.434     0.200
     7.170    19.789     0.200
     7.464    21.963     0.200
     7.657    21.568     0.200
     7.764    21.435     0.200
     8.141    22.891     0.200
     8.188    23.616     0.200
     8.217    23.162     0.200
     8.312    22.906     0.200
     8.337    22.820     0.200
     8.362    23.023     0.200
     8.184    24.445     0.200
     8.530    23.282     0.200
     8.533    23.066     0.200
     8.928    23.345     0.200
     9.206    23.943     0.200
     9.386    24.660     0.200
     9.484    24.369     0.200
     9.557    25.712     0.200
     9.569    26.486     0.200
     9.648    25.932     0.200
     9.729    27.106     0.200
     9.729    26.907     0.200
    10.197    25.249     0.200
    12.301    28.196     0.200
    12.301    27.594     0.200
    12.832    31.803     0.200
    15.103    31.168     0.200
    15.119    32.524     0.200
    15.159    34.609     0.200
    15.200    35.670     0.200
    15.259    35.231     0.200
    15.256    34.439     0.200
    15.715    35.821     0.200
    16.073    35.624     0.200
    17.499    37.241     0.200
     0.994     7.242     0.200
     1.004     7.390     0.200
     1.108     7.988     0.200
     1.129     7.716     0.200
     1.135     7.405     0.200
     1.481     8.097     0.200
     1.483     8.185     0.200
     1.520     8.718     0.200
     1.521     8.345     0.200
     1.521     8.744     0.200
     1.544     8.431     0.200
     1.973    10.797     0.200
     2.451    10.603     0.200
     3.188    13.762     0.200
     3.328    13.487     0.200
     3.340    13.862     0.200
     3.373    14.312     0.200
     3.581    13.276     0.200
     3.657    13.334     0.200
     3.711    13.302     0.200
     3.726    13.948     0.200
     3.901    13.247     0.200
     3.901    12.529     0.200
     3.817    14.260     0.200
     3.951    14.448     0.200
     4.233    14.098     0.200
     4.382    14.441     0.200
     4.358    12.972     0.200
     4.399    14.026     0.200
     4.452    13.902     0.200
     4.540    14.659     0.200
     4.633    13.103     0.200
     4.698    14.411     0.200
     4.865    15.809     0.200
     4.924    15.066     0.200
     5.147    15.259     0.200
     5.241    14.558     0.200
     5.353    16.215     0.200
     5.345    15.944     0.200
     5.510    16.358     0.200
     5.749    17.569     0.200
     5.813    17.327     0.200
     5.951    16.822     0.200
     5.988    16.686     0.200
     6.015    18.576     0.200
     6.245    17.773     0.200
     6.326    18.025     0.200
     6.380    18.292     0.200
     6.634    18.051     0.200
     6.761    19.635     0.200
     6.759    18.566     0.200
     6.906    18.833     0.200
     7.087    19.857     0.200
     7.395    19.299     0.200
     7.460    20.141     0.200
     7.500    20.237     0.200
     7.745    21.443     0.200
     7.859    21.645     0.200
     7.905    21.502     0.200
     7.972    20.994     0.200
     8.016    22.220     0.200
     8.102    21.230     0.200
     8.608    21.207     0.200
     8.797    22.466     0.200
     8.850    22.638     0.200
     9.076    22.924     0.200
     9.282    23.247     0.200
     9.299    22.865     0.200
     9.478    22.738     0.200
     9.492    23.655     0.200
     9.878    24.446     0.200
    12.017    26.102     0.200
    15.749    34.973     0.200
    16.136    33.432     0.200
    16.775    35.302     0.200
    17.361    35.824     0.200
     0.871     5.773     0.200
     1.117     6.814     0.200
     1.117     7.264     0.200
     1.253     7.461     0.200
     1.302     7.521     0.200
     1.306     7.584     0.200
     1.399     8.081     0.200
     1.525     8.241     0.200
     1.794     8.387     0.200
     1.946     8.554     0.200
     2.353     8.678     0.200
     2.353     8.247     0.200
     2.434    11.114     0.200
     2.562    11.196     0.200
     3.051    11.260     0.200
     3.114    11.490     0.200
     3.127    11.804     0.200
     3.352    10.817     0.200
     3.352    10.467     0.200
     3.712    12.275     0.200
     3.736    14.545     0.200
     3.850    12.824     0.200
     3.865    14.350     0.200
     3.874    15.270     0.200
     3.968    13.015     0.200
     4.018    12.329     0.200
     4.079    11.241     0.200
     4.162    12.498     0.200
     4.192    13.197     0.200
     4.297    13.045     0.200
     4.239    15.266     0.200
     4.239    15.565     0.200
     4.333    13.591     0.200
     4.384    13.836     0.200
     4.327    14.526     0.200
     4.508    13.549     0.200
     4.463    15.225     0.200
     4.807    14.527     0.200
     4.849    14.285     0.200
     4.896    14.249     0.200
     4.973    14.678     0.200
     5.018    14.775     0.200
     5.256    15.320     0.200
     5.336    16.427     0.200
     5.522    16.007     0.200
     5.570    15.782     0.200
     5.626    16.280     0.200
     5.776    17.075     0.200
     5.736    15.806     0.200
     5.865    16.851     0.200
     5.878    16.387     0.200
     5.941    16.997     0.200
     6.218    16.291     0.200
     6.284    16.505     0.200
     6.274    18.227     0.200
     6.279    18.461     0.200
     6.279    17.952     0.200
     6.307    17.805     0.200
     6.350    17.474     0.200
     6.398    17.080     0.200
     6.467    18.582     0.200
     6.559    17.196     0.200
     6.601    17.158     0.200
     6.640    17.950     0.200
     7.017    18.386     0.200
     7.229    19.260     0.200
     7.214    19.248     0.200
     7.278    20.130     0.200
     7.320    19.597     0.200
     7.277    19.742     0.200
     7.450    19.768     0.200
     7.597    20.379     0.200
     7.894    18.632     0.200
     7.870    20.191     0.200
     8.155    20.405     0.200
     8.253    20.223     0.200
     8.255    20.659     0.200
     8.448    21.673     0.200
     8.680    21.933     0.200
     8.730    21.005     0.200
     8.761    22.132     0.200
     8.927    20.349     0.200
     9.075    22.808     0.200
     9.114    23.690     0.200
     9.251    22.215     0.200
     9.440    23.738     0.200
     9.570    22.262     0.200
     9.856    24.385     0.200
    10.033    24.142     0.200
    10.395    24.156     0.200
    10.857    26.704     0.200
    11.032    26.362     0.200
    11.077    27.385     0.200
    11.215    27.693     0.200
    11.377    28.033     0.200
    11.478    27.583     0.200
    11.735    28.610     0.200
    11.754    28.427     0.200
    11.824    25.001     0.200
    12.056    26.935     0.200
    12.380    30.713     0.200
    13.103    29.825     0.200
    14.104    31.964     0.200
    14.099    30.123     0.200
    16.734    34.956     0.200
    16.832    34.305     0.200
    17.836    36.188     0.200
     1.110     7.918     0.200
     1.128     7.602     0.200
     1.134     7.267     0.200
     1.330     7.826     0.200
     1.488     8.420     0.200
     1.527     8.902     0.200
     1.528     8.968     0.200
     1.528     8.829     0.200
     1.844     8.583     0.200
     1.971    10.515     0.200
     2.173    11.071     0.200
     2.299    10.281     0.200
     2.458    10.749     0.200
     2.890    10.487     0.200
     3.184    13.314     0.200
     3.227    13.354     0.200
     3.227    11.993     0.200
     3.257    13.344     0.200
     3.325    13.311     0.200
     3.327    13.602     0.200
     3.337    13.561     0.200
     3.355    13.653     0.200
     3.370    12.096     0.200
     3.374    13.827     0.200
     3.722    13.775     0.200
     3.722    13.396     0.200
     3.907    12.721     0.200
     3.907    11.452     0.200
     3.813    13.992     0.200
     4.365    13.664     0.200
     4.389    12.974     0.200
     4.406    13.675     0.200
     4.458    14.196     0.200
     4.639    13.574     0.200
     4.872    14.489     0.200
     4.931    14.260     0.200
     5.153    15.485     0.200
     5.247    14.870     0.200
     5.261    15.792     0.200
     5.352    16.376     0.200
     5.757    16.202     0.200
     5.819    17.036     0.200
     5.880    16.542     0.200
     5.958    17.365     0.200
     5.995    16.863     0.200
     6.016    19.004     0.200
     6.016    18.885     0.200
     6.252    17.894     0.200
     6.333    16.919     0.200
     6.640    18.060     0.200
     6.768    20.032     0.200
     6.766    18.959     0.200
     6.837    20.129     0.200
     6.889    18.321     0.200
     6.913    18.864     0.200
     7.094    19.332     0.200
     7.507    20.436     0.200
     7.653    20.433     0.200
     7.912    21.340     0.200
     7.979    21.009     0.200
     8.108    21.267     0.200
     8.478    21.946     0.200
     8.615    21.474     0.200
     8.649    25.081     0.200
     8.804    23.116     0.200
     9.289    23.812     0.200
     9.499    24.151     0.200
     9.767    26.565     0.200
     9.885    25.235     0.200
    10.187    28.424     0.200
    14.865    32.756     0.200
    15.459    35.223     0.200
    15.614    35.471     0.200
    16.143    37.649     0.200
    16.756    36.065     0.200
    16.781    35.662     0.200
    17.260    36.269     0.200
    17.368    36.253     0.200
    17.817    35.725     0.200
     0.508     6.119     0.200
     0.657     6.729     0.200
     0.667     6.607     0.200
     0.675     6.589     0.200
     0.707     6.753     0.200
     0.668     6.356     0.200
     0.676     6.719     0.200
     0.748     5.669     0.200
     0.783     7.209     0.200
     0.985     4.498     0.200
     0.985     4.390     0.200
     1.444     9.157     0.200
     1.638     8.274     0.200
     1.644     9.245     0.200
     1.814     9.319     0.200
     1.815     8.561     0.200
     1.815     9.421     0.200
     1.852     8.658     0.200
     1.889     9.443     0.200
     1.894     9.073     0.200
     2.244     9.308     0.200
     2.655    10.299     0.200
     2.744    10.474     0.200
     2.651    11.654     0.200
     2.694    12.955     0.200
     2.694    11.463     0.200
     2.694    11.752     0.200
     2.791    11.377     0.200
     2.823    11.732     0.200
     2.836    12.133     0.200
     3.191    13.448     0.200
     3.191    12.159     0.200
     3.282    10.895     0.200
     3.408    11.018     0.200
     3.408    10.787     0.200
     3.340    12.510     0.200
     3.416    13.427     0.200
     3.450    12.792     0.200
     3.855    12.840     0.200
     4.085    13.894     0.200
     4.131    14.609     0.200
     4.213    15.055     0.200
     4.232    14.886     0.200
     4.265    14.977     0.200
     4.265    15.618     0.200
     4.407    13.469     0.200
     4.407    12.766     0.200
     4.407    13.067     0.200
     4.494    13.774     0.200
     4.500    14.404     0.200
     4.574    14.487     0.200
     4.608    14.539     0.200
     4.642    14.278     0.200
     4.778    15.254     0.200
     5.099    15.090     0.200
     5.121    13.677     0.200
     5.171    16.058     0.200
     5.177    15.733     0.200
     5.205    16.076     0.200
     5.214    15.532     0.200
     5.419    16.404     0.200
     5.456    16.110     0.200
     5.381    17.183     0.200
     5.511    15.710     0.200
     5.581    17.763     0.200
     5.581    17.610     0.200
     5.581    17.462     0.200
     5.693    17.001     0.200
     5.713    14.387     0.200
     5.713    14.516     0.200
     5.713    14.906     0.200
     5.713    14.617     0.200
     5.713    15.406     0.200
     5.882    17.167     0.200
     5.954    16.446     0.200
     6.181    16.854     0.200
     6.222    17.992     0.200
     6.396    17.817     0.200
     6.565    19.176     0.200
     6.636    18.699     0.200
     6.841    20.146     0.200
     6.902    20.053     0.200
     6.933    18.489     0.200
     6.959    18.836     0.200
     7.030    19.141     0.200
     7.253    19.804     0.200
     7.280    20.559     0.200
     7.315    20.763     0.200
     7.335    19.354     0.200
     7.402    20.317     0.200
     7.437    21.168     0.200
     7.538    20.019     0.200
     7.554    19.508     0.200
     7.591    18.858     0.200
     8.020    21.129     0.200
     8.084    22.272     0.200
     8.093    21.292     0.200
     8.123    21.017     0.200
     8.033    23.171     0.200
     8.178    22.157     0.200
     8.117    22.766     0.200
     8.261    21.311     0.200
     8.320    23.045     0.200
     8.324    20.342     0.200
     8.438    21.724     0.200
     8.819    21.876     0.200
     9.034    22.836     0.200
     9.141    22.053     0.200
     9.155    22.747     0.200
     9.234    25.040     0.200
     9.371    22.736     0.200
     9.376    23.222     0.200
     9.280    25.147     0.200
     9.410    23.783     0.200
     9.307    24.902     0.200
     9.505    25.119     0.200
     9.569    25.509     0.200
     9.654    26.128     0.200
     9.654    25.628     0.200
     9.874    24.487     0.200
     9.916    24.837     0.200
     9.932    26.396     0.200
     9.933    26.354     0.200
    10.043    25.594     0.200
    10.106    24.822     0.200
    10.129    23.981     0.200
    10.466    25.163     0.200
    11.102    28.030     0.200
    11.313    28.428     0.200
    11.842    27.873     0.200
    12.149    28.518     0.200
    12.149    26.916     0.200
    12.149    28.416     0.200
    12.149    27.576     0.200
    12.192    28.628     0.200
    12.199    30.035     0.200
    12.150    30.202     0.200
    12.342    25.508     0.200
    12.809    30.314     0.200
    13.012    29.598     0.200
    14.218    32.020     0.200
    14.683    33.806     0.200
    14.812    35.140     0.200
    19.809    38.384     0.200
    20.053    36.585     0.200
     1.136     7.476     0.200
     1.200     7.933     0.200
     1.338     8.374     0.200
     1.354     8.741     0.200
     1.944    10.426     0.200
     2.093    10.777     0.200
     2.152    11.478     0.200
     2.153    10.254     0.200
     2.425    10.705     0.200
     3.054    12.435     0.200
     3.054    12.634     0.200
     3.018    13.305     0.200
     3.062    12.618     0.200
     3.168    13.538     0.200
     3.168    13.991     0.200
     3.187    13.582     0.200
     3.186    13.450     0.200
     3.186    13.861     0.200
     3.214    13.641     0.200
     3.521    14.025     0.200
     3.622    14.287     0.200
     3.669    14.358     0.200
     3.669    14.487     0.200
     4.160    15.169     0.200
     4.224    15.098     0.200
     4.315    15.125     0.200
     4.752    15.825     0.200
     4.822    15.633     0.200
     4.841    15.882     0.200
     4.892    15.826     0.200
     4.956    16.051     0.200
     5.018    16.303     0.200
     5.018    16.514     0.200
     5.031    16.336     0.200
     5.098    14.978     0.200
     5.111    16.466     0.200
     5.267    16.539     0.200
     5.406    17.095     0.200
     5.483    17.631     0.200
     5.558    17.907     0.200
     5.728    14.811     0.200
     5.728    15.752     0.200
     5.884    18.064     0.200
     6.075    17.654     0.200
     6.349    19.946     0.200
     6.361    18.905     0.200
     6.585    19.979     0.200
     6.596    20.170     0.200
     6.879    20.145     0.200
     7.050    20.479     0.200
     7.116    20.492     0.200
     7.234    21.194     0.200
     7.377    20.984     0.200
     7.394    20.607     0.200
     7.717    22.328     0.200
     8.420    23.423     0.200
     8.533    22.263     0.200
     9.201    23.464     0.200
     9.346    24.005     0.200
     9.486    25.512     0.200
     9.797    24.289     0.200
    10.003    23.459     0.200
    10.352    26.282     0.200
    10.473    26.319     0.200
    10.658    26.696     0.200
    11.204    28.039     0.200
    11.530    29.603     0.200
    11.757    28.837     0.200
    12.016    29.228     0.200
    12.227    31.047     0.200
    12.272    31.101     0.200
    12.484    29.799     0.200
    12.559    31.578     0.200
    12.622    26.368     0.200
    12.737    31.190     0.200
    12.810    31.728     0.200
    13.148    29.966     0.200
    13.330    32.342     0.200
    14.060    32.996     0.200
    14.169    33.444     0.200
    14.375    34.569     0.200
    14.768    34.122     0.200
    15.191    35.435     0.200
    15.206    34.583     0.200
    15.492    36.264     0.200
    16.001    37.245     0.200
    16.190    35.236     0.200
    16.309    36.579     0.200
    16.726    36.163     0.200
    17.334    36.201     0.200
    17.337    37.761     0.200
     0.485     3.588     0.200
     0.488     3.583     0.200
     0.442     5.190     0.200
     0.866     6.625     0.200
     0.917     7.143     0.200
     0.935     7.129     0.200
     1.048     7.854     0.200
     1.083     7.501     0.200
     1.091     7.255     0.200
     1.274     7.230     0.200
     1.429     8.124     0.200
     1.464     8.295     0.200
     1.465     8.265     0.200
     1.800     8.339     0.200
     1.944    10.455     0.200
     2.071    10.716     0.200
     2.248     9.659     0.200
     3.101    11.526     0.200
     3.173    13.138     0.200
     3.215    11.359     0.200
     3.312    13.029     0.200
     3.316    13.090     0.200
     3.544    12.987     0.200
     3.714    11.876     0.200
     3.804    13.531     0.200
     4.141    13.588     0.200
     4.193    13.647     0.200
     4.239    13.608     0.200
     4.277    13.915     0.200
     4.291    13.264     0.200
     4.345    12.460     0.200
     4.341    13.503     0.200
     4.380    13.866     0.200
     4.504    14.654     0.200
     4.619    12.944     0.200
     4.619    12.561     0.200
     4.663    14.017     0.200
     4.785    15.008     0.200
     4.814    14.551     0.200
     4.735    15.700     0.200
     4.864    14.099     0.200
     5.075    14.854     0.200
     5.222    13.975     0.200
     5.222    13.686     0.200
     5.198    15.329     0.200
     5.307    16.072     0.200
     5.277    15.446     0.200
     5.476    15.152     0.200
     5.702    16.768     0.200
     5.739    16.969     0.200
     5.804    16.127     0.200
     5.893    17.129     0.200
     5.917    16.172     0.200
     5.959    16.909     0.200
     6.146    17.813     0.200
     6.180    17.343     0.200
     6.271    17.843     0.200
     6.305    16.847     0.200
     6.561    17.163     0.200
     6.711    19.323     0.200
     6.698    18.403     0.200
     6.800    18.094     0.200
     6.812    17.610     0.200
     6.877    17.468     0.200
     6.840    18.260     0.200
     7.031    18.811     0.200
     7.088    17.951     0.200
     7.331    19.071     0.200
     7.386    19.801     0.200
     7.430    19.552     0.200
     7.585    19.626     0.200
     7.651    21.268     0.200
     7.692    20.448     0.200
     7.825    20.365     0.200
     7.869    18.846     0.200
     7.849    20.546     0.200
     7.907    20.186     0.200
     7.966    20.642     0.200
     8.007    19.722     0.200
     8.029    20.548     0.200
     8.402    21.402     0.200
     8.478    21.278     0.200
     8.542    20.631     0.200
     8.667    20.640     0.200
     8.639    22.674     0.200
     8.766    21.617     0.200
     8.788    21.838     0.200
     9.007    22.347     0.200
     9.128    21.369     0.200
     9.146    22.364     0.200
     9.257    22.419     0.200
     9.451    21.811     0.200
     9.431    23.282     0.200
     9.658    22.788     0.200
     9.754    22.494     0.200
     9.820    24.177     0.200
    10.005    24.870     0.200
    10.052    23.299     0.200
    10.086    23.791     0.200
    10.064    23.964     0.200
    10.832    25.541     0.200
    11.233    25.157     0.200
    11.865    26.784     0.200
    12.115    27.588     0.200
    12.387    28.369     0.200
    13.365    30.120     0.200
    13.631    30.104     0.200
    14.048    31.990     0.200
    14.588    30.767     0.200
    14.620    31.408     0.200
    15.180    30.800     0.200
    15.333    34.821     0.200
    15.420    35.041     0.200
    15.566    35.880     0.200
    15.714    34.537     0.200
    15.998    33.540     0.200
    16.094    33.815     0.200
    16.200    32.905     0.200
    16.709    33.691     0.200
    16.739    33.941     0.200
    17.211    35.325     0.200
    17.322    34.568     0.200
     1.201     7.305     0.200
     1.217     7.254     0.200
     1.217     6.984     0.200
     1.361     6.900     0.200
     1.650     7.824     0.200
     1.866     8.337     0.200
     1.959     8.716     0.200
     1.961     9.010     0.200
     2.033     9.085     0.200
     2.033     9.655     0.200
     2.678     9.424     0.200
     2.913    10.748     0.200
     3.048    11.024     0.200
     3.071    11.159     0.200
     3.268    12.114     0.200
     3.509    11.206     0.200
     3.579    11.258     0.200
     3.623    11.493     0.200
     3.697    11.304     0.200
     3.697    10.655     0.200
     3.710    12.052     0.200
     3.855    12.167     0.200
     3.875    12.365     0.200
     4.107    13.206     0.200
     4.166    12.577     0.200
     4.325    12.784     0.200
     4.325    14.144     0.200
     4.325    14.284     0.200
     4.307    13.331     0.200
     4.340    11.697     0.200
     4.340    12.104     0.200
     4.340    13.201     0.200
     4.340    12.815     0.200
     4.405    13.123     0.200
     4.469    14.324     0.200
     4.579    14.320     0.200
     4.667    13.910     0.200
     4.791    13.320     0.200
     4.797    13.810     0.200
     4.816    14.144     0.200
     4.816    14.426     0.200
     4.909    14.764     0.200
     4.900    14.341     0.200
     5.077    15.247     0.200
     5.208    15.120     0.200
     5.208    14.481     0.200
     5.209    15.049     0.200
     5.231    14.731     0.200
     5.284    15.662     0.200
     5.310    15.750     0.200
     5.510    15.332     0.200
     5.641    15.801     0.200
     5.720    15.873     0.200
     5.749    16.756     0.200
     5.814    15.978     0.200
     5.855    16.810     0.200
     5.887    17.250     0.200
     5.916    16.026     0.200
     6.003    16.488     0.200
     6.038    16.545     0.200
     6.044    15.486     0.200
     6.101    17.490     0.200
     6.258    17.601     0.200
     6.283    16.753     0.200
     6.321    16.712     0.200
     6.340    15.765     0.200
     6.366    17.237     0.200
     6.374    15.679     0.200
     6.423    17.673     0.200
     6.453    17.183     0.200
     6.499    17.750     0.200
     6.511    16.863     0.200
     6.713    18.162     0.200
     6.789    18.113     0.200
     6.959    19.069     0.200
     6.959    19.440     0.200
     7.076    19.821     0.200
     7.095    17.589     0.200
     7.114    19.476     0.200
     7.114    19.835     0.200
     7.109    18.360     0.200
     7.119    18.447     0.200
     7.301    19.044     0.200
     7.501    19.477     0.200
     7.541    19.872     0.200
     7.709    18.624     0.200
     7.718    20.132     0.200
     7.796    20.250     0.200
     7.824    19.844     0.200
     8.114    20.085     0.200
     8.256    20.910     0.200
     8.282    20.808     0.200
     8.282    20.409     0.200
     8.365    19.976     0.200
     8.423    19.579     0.200
     8.437    21.261     0.200
     8.485    19.357     0.200
     8.483    20.285     0.200
     8.485    20.849     0.200
     8.641    18.902     0.200
     8.696    20.986     0.200
     8.735    21.622     0.200
     8.817    21.554     0.200
     8.817    21.254     0.200
     8.882    20.981     0.200
     9.044    22.311     0.200
     9.072    22.144     0.200
     9.041    23.626     0.200
     9.146    22.430     0.200
     9.193    23.279     0.200
     9.315    21.301     0.200
     9.339    21.913     0.200
     9.461    21.868     0.200
     9.518    21.626     0.200
     9.607    22.888     0.200
     9.714    23.382     0.200
     9.744    24.242     0.200
     9.806    22.615     0.200
     9.885    22.435     0.200
    10.989    28.037     0.200
    11.034    27.793     0.200
    11.056    26.939     0.200
    11.107    27.658     0.200
    11.215    27.723     0.200
    11.285    27.757     0.200
    11.285    27.456     0.200
    11.285    27.617     0.200
    11.276    26.758     0.200
    11.276    23.660     0.200
    11.276    24.051     0.200
    11.276    24.250     0.200
    11.335    27.069     0.200
    11.314    26.965     0.200
    11.424    23.731     0.200
    11.424    24.528     0.200
    11.564    27.904     0.200
    11.809    28.582     0.200
    13.264    30.775     0.200
    13.306    33.471     0.200
    13.583    32.379     0.200
    13.654    33.004     0.200
    13.775    32.212     0.200
    13.783    31.070     0.200
    14.463    33.967     0.200
    15.643    34.313     0.200
    15.955    34.735     0.200
    16.296    34.418     0.200
    16.296    36.172     0.200
    17.693    35.773     0.200
    17.693    35.523     0.200
    18.176    37.091     0.200
    18.176    36.662     0.200
    18.767    38.972     0.200
    20.628    37.233     0.200
     1.121     6.900     0.200
     1.121     6.463     0.200
     1.205     7.090     0.200
     1.282     7.283     0.200
     1.423     6.878     0.200
     1.407     8.303     0.200
     1.480     8.531     0.200
     1.480     8.178     0.200
     1.480     8.655     0.200
     1.709     7.674     0.200
     1.931     8.495     0.200
     1.826     9.085     0.200
     1.841     9.109     0.200
     1.871     9.226     0.200
     2.027     9.701     0.200
     2.027    10.424     0.200
     2.063     9.901     0.200
     2.076     9.694     0.200
     2.756     9.637     0.200
     3.053     9.327     0.200
     3.041    11.048     0.200
     2.937    12.099     0.200
     3.142    11.143     0.200
     3.722    11.633     0.200
     3.829    10.323     0.200
     3.816    12.249     0.200
     3.879    12.240     0.200
     3.959    12.541     0.200
     4.170    13.172     0.200
     4.279    12.783     0.200
     4.149    15.008     0.200
     4.192    15.457     0.200
     4.192    14.606     0.200
     4.342    13.201     0.200
     4.222    14.810     0.200
     4.469    11.913     0.200
     4.469    13.319     0.200
     4.320    14.739     0.200
     4.489    14.905     0.200
     4.593    14.968     0.200
     4.728    14.344     0.200
     4.682    15.133     0.200
     4.682    14.734     0.200
     4.904    15.080     0.200
     4.892    14.453     0.200
     4.776    15.263     0.200
     4.973    14.928     0.200
     5.323    14.983     0.200
     5.299    15.853     0.200
     5.346    15.743     0.200
     5.600    16.069     0.200
     5.710    16.110     0.200
     5.920    17.897     0.200
     5.917    16.945     0.200
     5.983    17.291     0.200
     5.996    16.998     0.200
     6.164    16.377     0.200
     6.074    18.448     0.200
     6.151    16.992     0.200
     6.130    18.024     0.200
     6.350    17.338     0.200
     6.388    17.244     0.200
     6.563    18.472     0.200
     6.791    18.408     0.200
     6.804    19.184     0.200
     6.853    19.148     0.200
     7.231    19.775     0.200
     7.269    19.091     0.200
     7.387    19.266     0.200
     7.425    19.873     0.200
     7.583    20.140     0.200
     7.594    20.690     0.200
     7.571    20.466     0.200
     7.721    21.364     0.200
     7.852    20.921     0.200
     8.272    22.650     0.200
     8.550    21.706     0.200
     8.476    21.686     0.200
     8.535    22.224     0.200
     8.596    22.309     0.200
     8.767    21.573     0.200
     8.816    22.890     0.200
     8.945    22.277     0.200
     9.198    23.855     0.200
     9.600    24.978     0.200
     9.610    25.431     0.200
     9.911    23.837     0.200
    10.265    26.000     0.200
    10.578    26.083     0.200
    11.081    26.902     0.200
    11.042    27.975     0.200
    11.528    24.892     0.200
     0.373     5.299     0.200
     0.816     6.440     0.200
     0.851     7.041     0.200
     0.852     6.922     0.200
     0.874     7.038     0.200
     1.036     7.317     0.200
     1.046     7.040     0.200
     1.231     6.841     0.200
     1.397     7.111     0.200
     1.380     7.684     0.200
     1.412     7.867     0.200
     1.413     8.035     0.200
     1.413     7.933     0.200
     1.453     7.571     0.200
     1.769     7.788     0.200
     1.980     8.776     0.200
     1.912    10.470     0.200
     2.209     9.147     0.200
     2.118    10.438     0.200
     2.896     8.602     0.200
     2.896     9.012     0.200
     3.060    10.955     0.200
     3.154    12.552     0.200
     3.197    11.798     0.200
     3.298    12.531     0.200
     3.302    12.715     0.200
     3.307    12.695     0.200
     3.326    12.612     0.200
     3.337    13.104     0.200
     3.365    13.012     0.200
     3.513    12.221     0.200
     3.556    12.146     0.200
     3.626    12.423     0.200
     3.698    12.683     0.200
     3.893    12.466     0.200
     3.846    13.407     0.200
     3.956    13.699     0.200
     4.110    13.145     0.200
     4.262    13.073     0.200
     4.226    12.884     0.200
     4.286    13.622     0.200
     4.373    13.987     0.200
     4.309    13.403     0.200
     4.473    14.449     0.200
     4.612    13.086     0.200
     4.612    12.566     0.200
     4.632    13.745     0.200
     4.639    14.970     0.200
     4.749    14.262     0.200
     4.750    14.815     0.200
     4.768    14.783     0.200
     4.721    15.243     0.200
     4.740    15.002     0.200
     4.806    13.742     0.200
     4.798    15.005     0.200
     5.003    14.506     0.200
     5.210    13.299     0.200
     5.210    13.914     0.200
     5.145    14.719     0.200
     5.210    15.267     0.200
     5.266    14.860     0.200
     5.446    15.390     0.200
     5.657    16.732     0.200
     5.665    16.916     0.200
     5.735    15.821     0.200
     5.837    16.067     0.200
     5.845    16.414     0.200
     5.892    17.174     0.200
     5.898    17.923     0.200
     6.189    16.851     0.200
     6.220    17.321     0.200
     6.388    18.289     0.200
     6.455    18.403     0.200
     6.774    18.000     0.200
     6.742    17.564     0.200
     6.774    17.880     0.200
     6.977    18.460     0.200
     7.311    19.874     0.200
     7.360    19.865     0.200
     7.608    21.513     0.200
     7.642    20.855     0.200
     7.795    20.416     0.200
     7.844    19.875     0.200
     7.797    20.153     0.200
     7.844    20.303     0.200
     7.920    22.096     0.200
     7.966    20.564     0.200
     8.360    21.510     0.200
     8.436    21.430     0.200
     8.476    20.765     0.200
     8.536    23.454     0.200
     8.621    23.096     0.200
     8.739    20.962     0.200
     8.939    22.458     0.200
     9.017    21.791     0.200
     9.020    22.665     0.200
     9.086    22.597     0.200
     9.112    21.702     0.200
     9.237    21.902     0.200
     9.245    20.460     0.200
     9.344    22.329     0.200
     9.428    21.323     0.200
     9.552    22.699     0.200
     9.638    22.827     0.200
     9.638    22.547     0.200
     9.724    22.967     0.200
     9.764    23.973     0.200
     9.733    24.143     0.200
     9.923    23.625     0.200
     9.927    24.950     0.200
    10.061    23.875     0.200
    10.154    26.103     0.200
    10.263    25.162     0.200
    10.770    26.130     0.200
    10.959    27.539     0.200
    10.991    27.244     0.200
    11.520    28.244     0.200
    11.927    27.718     0.200
    13.610    31.945     0.200
    14.186    33.568     0.200
    15.063    34.222     0.200
    15.392    34.891     0.200
    16.056    34.514     0.200
    16.165    34.349     0.200
     1.137     7.593     0.200
     1.143     7.316     0.200
     1.299     7.325     0.200
     1.299     7.434     0.200
     1.303     7.453     0.200
     1.373     7.878     0.200
     1.461     8.040     0.200
     1.464     8.302     0.200
     1.501     8.601     0.200
     1.502     8.689     0.200
     1.524     8.294     0.200
     1.524     8.442     0.200
     1.546     8.599     0.200
     1.817     8.677     0.200
     2.041     9.658     0.200
     1.985    10.812     0.200
     2.188    11.171     0.200
     2.868    10.599     0.200
     2.868    10.317     0.200
     3.128    12.132     0.200
     3.203    13.321     0.200
     3.203    13.442     0.200
     3.246    12.981     0.200
     3.276    13.551     0.200
     3.346    13.448     0.200
     3.346    13.671     0.200
     3.374    13.152     0.200
     3.374    13.551     0.200
     3.463    12.568     0.200
     3.463    12.939     0.200
     3.561    12.879     0.200
     3.561    13.109     0.200
     3.613    12.680     0.200
     3.613    13.012     0.200
     3.691    13.081     0.200
     3.691    13.222     0.200
     3.742    13.896     0.200
     3.883    12.952     0.200
     3.833    14.085     0.200
     3.890    14.242     0.200
     3.967    14.381     0.200
     4.213    13.790     0.200
     4.213    13.931     0.200
     4.342    13.484     0.200
     4.380    14.329     0.200
     4.422    14.604     0.200
     4.438    13.834     0.200
     4.614    13.115     0.200
     4.614    12.986     0.200
     4.796    14.801     0.200
     4.803    15.436     0.200
     4.845    15.678     0.200
     4.845    16.026     0.200
     4.906    14.724     0.200
     4.906    15.450     0.200
     5.133    15.187     0.200
     5.221    14.218     0.200
     5.236    15.741     0.200
     5.333    15.943     0.200
     5.333    16.135     0.200
     5.329    15.869     0.200
     5.697    16.634     0.200
     5.697    16.763     0.200
     5.730    17.632     0.200
     5.933    16.753     0.200
     5.933    16.971     0.200
     5.975    16.793     0.200
     6.020    18.513     0.200
     6.020    18.412     0.200
     6.228    17.701     0.200
     6.307    17.830     0.200
     6.372    18.454     0.200
     6.505    18.724     0.200
     6.621    18.003     0.200
     6.741    19.180     0.200
     6.741    18.819     0.200
     6.810    18.409     0.200
     6.869    17.773     0.200
     6.890    18.564     0.200
     7.069    19.452     0.200
     7.378    19.195     0.200
     7.448    19.839     0.200
     7.486    19.830     0.200
     7.628    20.264     0.200
     7.726    21.328     0.200
     7.839    20.940     0.200
     7.878    20.883     0.200
     7.886    21.212     0.200
     7.955    21.056     0.200
     8.089    21.000     0.200
     8.456    21.333     0.200
     8.592    21.071     0.200
     8.671    21.911     0.200
     8.778    21.948     0.200
     8.833    22.322     0.200
     9.263    23.059     0.200
     9.279    22.156     0.200
     9.458    22.176     0.200
     9.474    23.850     0.200
     9.770    23.732     0.200
     9.859    24.280     0.200
    10.034    26.042     0.200
    11.006    27.005     0.200
    11.166    28.229     0.200
    11.621    28.815     0.200
    12.082    29.787     0.200
    13.636    32.599     0.200
    15.113    36.531     0.200
    15.587    35.914     0.200
    16.117    35.823     0.200
    16.725    35.102     0.200
     1.051     7.616     0.200
     1.060     7.326     0.200
     1.255     7.365     0.200
     1.420     7.896     0.200
     1.407     8.533     0.200
     1.440     8.534     0.200
     1.441     8.801     0.200
     1.789     8.537     0.200
     1.919     9.938     0.200
     2.003     9.293     0.200
     2.124    10.515     0.200
     3.084    11.536     0.200
     3.155    13.164     0.200
     3.155    13.545     0.200
     3.228    13.043     0.200
     3.228    13.463     0.200
     3.427    12.308     0.200
     3.533    12.905     0.200
     3.533    13.203     0.200
     3.578    12.740     0.200
     3.650    13.029     0.200
     3.698    13.292     0.200
     3.698    13.631     0.200
     3.787    13.381     0.200
     3.846    13.711     0.200
     4.130    13.488     0.200
     4.179    13.574     0.200
     4.229    13.614     0.200
     4.265    13.960     0.200
     4.259    13.806     0.200
     4.334    14.764     0.200
     4.316    14.194     0.200
     4.394    14.299     0.200
     4.394    14.599     0.200
     4.343    14.238     0.200
     4.494    15.008     0.200
     4.622    14.037     0.200
     4.772    15.228     0.200
     4.794    15.700     0.200
     4.837    15.723     0.200
     5.037    15.469     0.200
     5.222    15.470     0.200
     5.174    15.547     0.200
     5.174    15.767     0.200
     5.244    16.544     0.200
     5.466    16.002     0.200
     5.466    16.231     0.200
     5.699    17.856     0.200
     5.769    16.403     0.200
     5.867    17.642     0.200
     5.879    16.848     0.200
     5.920    18.686     0.200
     6.148    17.894     0.200
     6.248    17.879     0.200
     6.410    18.943     0.200
     6.523    18.682     0.200
     6.691    19.511     0.200
     6.670    18.668     0.200
     6.792    18.703     0.200
     7.006    19.836     0.200
     7.346    20.404     0.200
     7.394    20.694     0.200
     7.558    20.168     0.200
     7.825    21.154     0.200
     7.876    20.593     0.200
     7.991    21.525     0.200
     8.367    21.902     0.200
     8.460    23.666     0.200
     8.509    21.567     0.200
     9.049    23.961     0.200
     9.253    23.110     0.200
     9.403    23.920     0.200
     9.516    24.689     0.200
     9.794    25.212     0.200
    10.527    26.670     0.200
    11.551    29.041     0.200
     1.752    10.092     0.200
     1.662    10.861     0.200
     1.898    10.878     0.200
     1.925    10.845     0.200
     1.927    11.269     0.200
     1.853    10.764     0.200
     2.287    11.488     0.200
     2.730    12.197     0.200
     2.802    13.849     0.200
     2.845    14.128     0.200
     2.845    13.798     0.200
     2.874    13.672     0.200
     2.947    13.350     0.200
     2.958    13.810     0.200
     2.962    14.051     0.200
     2.973    13.653     0.200
     2.993    14.307     0.200
     3.328    14.495     0.200
     3.328    14.245     0.200
     3.423    14.282     0.200
     3.581    14.368     0.200
     3.554    14.711     0.200
     3.926    14.069     0.200
     4.031    15.512     0.200
     4.077    14.321     0.200
     4.148    15.722     0.200
     4.350    14.567     0.200
     4.339    16.763     0.200
     4.678    16.034     0.200
     4.523    17.044     0.200
     4.692    15.830     0.200
     4.730    16.664     0.200
     4.763    16.135     0.200
     4.791    17.204     0.200
     4.832    16.292     0.200
     4.892    16.575     0.200
     4.991    16.729     0.200
     5.088    15.852     0.200
     5.088    15.651     0.200
     5.150    16.729     0.200
     5.267    17.728     0.200
     5.270    17.448     0.200
     5.286    18.482     0.200
     5.304    17.554     0.200
     5.322    17.451     0.200
     5.414    17.544     0.200
     5.654    18.135     0.200
     5.665    18.105     0.200
     5.699    16.275     0.200
     5.699    16.611     0.200
     5.787    18.502     0.200
     5.859    19.866     0.200
     5.859    18.616     0.200
     5.963    18.528     0.200
     6.030    19.277     0.200
     6.068    19.074     0.200
     6.338    19.387     0.200
     6.589    19.726     0.200
     6.710    21.788     0.200
     6.732    21.462     0.200
     6.883    20.373     0.200
     6.908    20.153     0.200
     7.131    20.575     0.200
     7.183    20.709     0.200
     7.235    20.685     0.200
     7.360    22.800     0.200
     7.484    21.689     0.200
     7.745    21.637     0.200
     7.784    22.155     0.200
     8.306    22.988     0.200
     8.312    24.746     0.200
     8.318    23.068     0.200
     8.345    23.322     0.200
     8.254    26.207     0.200
     8.775    23.714     0.200
     8.879    24.417     0.200
     9.215    24.217     0.200
     9.253    24.426     0.200
     9.527    26.175     0.200
     9.741    25.680     0.200
     9.865    25.734     0.200
     9.800    28.768     0.200
    10.140    25.655     0.200
    10.266    27.293     0.200
    10.573    27.056     0.200
    10.791    27.618     0.200
    11.353    30.450     0.200
    11.377    29.878     0.200
    11.405    29.002     0.200
    12.325    33.056     0.200
    12.448    27.319     0.200
    12.550    32.440     0.200
    12.769    32.523     0.200
    14.114    34.203     0.200
    14.303    36.706     0.200
    14.494    35.661     0.200
    14.620    36.284     0.200
    15.009    36.927     0.200
    15.073    36.291     0.200
    15.062    36.965     0.200
    15.133    37.732     0.200
    16.050    37.394     0.200
    16.577    38.892     0.200
     0.423     3.943     0.200
     0.434     3.987     0.200
     0.442     5.724     0.200
     0.442     5.974     0.200
     0.813     5.921     0.200
     0.995     6.835     0.200
     1.047     7.158     0.200
     1.165     7.309     0.200
     1.292     6.411     0.200
     1.230     7.389     0.200
     1.223     7.503     0.200
     1.312     8.041     0.200
     1.452     8.029     0.200
     1.526     7.389     0.200
     1.472     7.820     0.200
     1.759     8.053     0.200
     1.921     9.354     0.200
     2.404     8.023     0.200
     2.369    10.585     0.200
     2.617     9.542     0.200
     2.942    10.269     0.200
     3.035    10.980     0.200
     3.090    11.114     0.200
     3.176    11.575     0.200
     3.388     9.768     0.200
     3.690    11.951     0.200
     3.681    14.319     0.200
     3.681    11.158     0.200
     3.768    12.256     0.200
     3.835    12.375     0.200
     3.818    12.686     0.200
     3.895    12.861     0.200
     3.912    12.168     0.200
     3.993    13.016     0.200
     3.942    12.052     0.200
     4.103    11.628     0.200
     4.150    12.167     0.200
     4.104    12.550     0.200
     4.188    14.110     0.200
     4.268    13.035     0.200
     4.278    13.231     0.200
     4.344    12.855     0.200
     4.449    12.855     0.200
     4.702    12.793     0.200
     4.756    14.352     0.200
     4.808    14.148     0.200
     4.962    14.611     0.200
     4.941    14.679     0.200
     5.221    15.535     0.200
     5.268    15.908     0.200
     5.466    16.367     0.200
     5.489    15.504     0.200
     5.532    16.095     0.200
     5.648    15.738     0.200
     5.819    16.985     0.200
     5.808    16.748     0.200
     5.921    16.354     0.200
     6.237    17.901     0.200
     6.281    17.110     0.200
     6.181    17.445     0.200
     6.181    18.015     0.200
     6.205    17.459     0.200
     6.290    17.908     0.200
     6.377    17.860     0.200
     6.309    16.833     0.200
     6.486    17.311     0.200
     6.571    17.623     0.200
     6.517    16.881     0.200
     7.132    18.506     0.200
     7.170    18.891     0.200
     7.183    19.499     0.200
     7.311    19.486     0.200
     7.402    19.964     0.200
     7.530    19.598     0.200
     7.780    19.713     0.200
     7.881    21.004     0.200
     8.145    20.625     0.200
     8.077    20.715     0.200
     8.249    20.587     0.200
     8.184    20.517     0.200
     8.386    21.522     0.200
     8.736    19.758     0.200
     8.683    21.853     0.200
     8.930    20.075     0.200
     9.017    22.282     0.200
     9.103    25.144     0.200
     9.103    22.285     0.200
     9.387    23.907     0.200
     9.531    22.124     0.200
     9.724    24.325     0.200
    10.630    26.222     0.200
    10.769    26.752     0.200
    10.905    27.081     0.200
    15.063    33.135     0.200
    15.595    33.577     0.200
    17.814    35.278     0.200
     0.347     5.405     0.200
     0.557     3.957     0.200
     0.561     3.830     0.200
     0.794     6.764     0.200
     0.823     6.638     0.200
     0.847     6.914     0.200
     0.957     7.481     0.200
     0.957     7.651     0.200
     1.014     7.322     0.200
     1.026     7.024     0.200
     1.217     6.945     0.200
     1.364     7.733     0.200
     1.394     7.993     0.200
     1.395     7.469     0.200
     1.395     7.978     0.200
     1.761     7.542     0.200
     1.968     8.627     0.200
     2.196     8.897     0.200
     2.288     9.274     0.200
     2.352     9.672     0.200
     2.904     9.667     0.200
     2.904     9.247     0.200
     3.046    10.970     0.200
     3.144    12.588     0.200
     3.186    12.675     0.200
     3.186    12.287     0.200
     3.217    12.708     0.200
     3.281    12.669     0.200
     3.287    12.538     0.200
     3.291    12.915     0.200
     3.296    12.665     0.200
     3.315    12.821     0.200
     3.325    12.480     0.200
     3.333    12.867     0.200
     3.354    12.995     0.200
     3.503    12.155     0.200
     3.545    12.222     0.200
     3.613    12.381     0.200
     3.689    13.010     0.200
     3.897    11.878     0.200
     3.897    11.508     0.200
     3.777    13.245     0.200
     3.913    13.715     0.200
     4.201    13.344     0.200
     4.235    13.029     0.200
     4.201    13.298     0.200
     4.247    12.704     0.200
     4.266    13.069     0.200
     4.304    12.955     0.200
     4.282    13.192     0.200
     4.364    13.862     0.200
     4.464    14.351     0.200
     4.612    12.934     0.200
     4.612    12.395     0.200
     4.623    14.073     0.200
     4.631    15.047     0.200
     4.740    14.604     0.200
     4.740    14.675     0.200
     4.752    14.377     0.200
     4.796    14.811     0.200
     4.785    13.852     0.200
     4.713    15.482     0.200
     4.764    15.464     0.200
     4.975    14.660     0.200
     5.126    14.685     0.200
     5.208    12.669     0.200
     5.208    13.675     0.200
     5.185    14.811     0.200
     5.252    15.745     0.200
     5.437    15.986     0.200
     5.565    16.397     0.200
     5.642    16.404     0.200
     5.635    16.856     0.200
     5.709    15.646     0.200
     5.803    17.591     0.200
     5.817    16.180     0.200
     5.817    15.938     0.200
     5.871    17.843     0.200
     5.871    17.393     0.200
     6.101    17.901     0.200
     6.092    16.471     0.200
     6.175    17.362     0.200
     6.202    17.229     0.200
     6.198    17.667     0.200
     6.376    18.138     0.200
     6.382    18.630     0.200
     6.444    18.101     0.200
     6.460    16.959     0.200
     6.625    19.340     0.200
     6.617    17.902     0.200
     6.649    18.636     0.200
     6.767    17.947     0.200
     6.715    17.499     0.200
     6.749    17.995     0.200
     6.827    19.898     0.200
     6.863    20.014     0.200
     6.886    19.944     0.200
     6.958    18.121     0.200
     6.987    20.341     0.200
     7.105    17.357     0.200
     7.245    18.459     0.200
     7.281    19.566     0.200
     7.332    19.921     0.200
     7.506    19.363     0.200
     7.624    20.588     0.200
     7.786    20.262     0.200
     7.778    20.488     0.200
     7.837    20.268     0.200
     7.820    19.718     0.200
     7.904    21.837     0.200
     7.927    20.104     0.200
     8.307    20.920     0.200
     8.451    20.510     0.200
     8.644    21.297     0.200
     8.610    23.076     0.200
     8.610    22.685     0.200
     8.731    21.327     0.200
     8.706    21.751     0.200
     8.912    21.700     0.200
     9.072    23.869     0.200
     9.233    22.010     0.200
     9.351    23.131     0.200
     9.634    24.134     0.200
     9.715    23.468     0.200
    10.032    23.468     0.200
    10.054    23.863     0.200
    10.143    25.894     0.200
    10.273    24.507     0.200
    10.474    24.262     0.200
    10.747    26.375     0.200
    10.893    25.159     0.200
    10.966    27.270     0.200
    11.046    26.555     0.200
    11.819    28.114     0.200
    11.799    27.958     0.200
    11.913    25.284     0.200
    12.227    28.549     0.200
    12.243    27.435     0.200
    12.300    28.816     0.200
    12.494    29.807     0.200
    12.780    31.176     0.200
    13.969    31.309     0.200
    14.484    33.313     0.200
    14.541    32.123     0.200
    14.701    34.496     0.200
    15.052    33.198     0.200
    15.538    34.341     0.200
    16.998    34.471     0.200
    17.014    36.351     0.200
    17.159    36.322     0.200
     0.484     4.162     0.200
     0.485     4.246     0.200
     0.489     4.997     0.200
     0.878     6.645     0.200
     0.938     7.005     0.200
     0.942     7.108     0.200
     0.955     7.069     0.200
     0.965     7.320     0.200
     1.069     7.837     0.200
     1.092     7.587     0.200
     1.098     7.312     0.200
     1.509     8.231     0.200
     1.511     8.157     0.200
     1.511     8.287     0.200
     1.839     8.660     0.200
     2.060     9.089     0.200
     2.290     9.611     0.200
     2.370     9.910     0.200
     2.384     9.960     0.200
     2.907     9.818     0.200
     3.144    11.123     0.200
     3.160    13.453     0.200
     3.203    13.433     0.200
     3.203    12.643     0.200
     3.233    13.442     0.200
     3.303    13.340     0.200
     3.312    13.441     0.200
     3.331    13.453     0.200
     3.345    13.212     0.200
     3.584    12.701     0.200
     3.633    12.561     0.200
     3.709    12.783     0.200
     3.699    13.638     0.200
     3.919    12.266     0.200
     3.919    11.796     0.200
     4.234    13.637     0.200
     4.317    13.950     0.200
     4.339    12.963     0.200
     4.385    13.555     0.200
     4.387    13.325     0.200
     4.421    14.089     0.200
     4.445    14.465     0.200
     4.427    13.504     0.200
     4.543    14.845     0.200
     4.648    12.761     0.200
     4.648    13.721     0.200
     4.702    14.110     0.200
     4.637    15.812     0.200
     4.819    14.806     0.200
     4.719    16.164     0.200
     4.859    14.935     0.200
     4.874    14.403     0.200
     4.911    14.071     0.200
     5.121    14.901     0.200
     5.254    12.814     0.200
     5.254    13.665     0.200
     5.244    15.557     0.200
     5.350    15.731     0.200
     5.325    15.349     0.200
     5.514    15.343     0.200
     5.698    16.416     0.200
     5.745    16.731     0.200
     5.784    16.617     0.200
     5.885    17.283     0.200
     5.939    16.724     0.200
     5.963    16.048     0.200
     5.977    18.261     0.200
     5.977    17.641     0.200
     6.227    16.926     0.200
     6.275    17.699     0.200
     6.317    17.578     0.200
     6.465    18.034     0.200
     6.532    18.802     0.200
     6.607    17.668     0.200
     6.711    19.052     0.200
     6.755    19.293     0.200
     6.745    18.311     0.200
     6.837    18.385     0.200
     6.859    17.441     0.200
     6.887    18.565     0.200
     6.918    17.872     0.200
     6.980    19.538     0.200
     7.079    19.821     0.200
     7.077    19.371     0.200
     7.126    17.902     0.200
     7.154    19.133     0.200
     7.173    17.764     0.200
     7.430    19.845     0.200
     7.477    19.684     0.200
     7.632    19.688     0.200
     7.694    21.187     0.200
     7.863    20.582     0.200
     7.905    19.825     0.200
     7.895    20.649     0.200
     7.954    20.288     0.200
     8.011    21.783     0.200
     8.075    20.659     0.200
     8.449    21.254     0.200
     8.520    22.583     0.200
     8.589    21.002     0.200
     8.701    21.459     0.200
     8.625    23.949     0.200
     8.625    23.099     0.200
     8.803    21.682     0.200
     8.835    21.957     0.200
     9.120    22.496     0.200
     9.292    22.251     0.200
     9.478    23.358     0.200
     9.583    24.052     0.200
     9.793    23.248     0.200
     9.866    24.388     0.200
    10.008    25.080     0.200
    10.123    24.076     0.200
    10.112    24.024     0.200
    10.163    27.207     0.200
    10.163    25.977     0.200
    10.441    27.394     0.200
    10.618    25.567     0.200
    10.955    25.429     0.200
    11.078    27.307     0.200
    11.294    26.891     0.200
    11.543    26.734     0.200
    11.666    26.170     0.200
    11.906    27.596     0.200
    12.014    24.409     0.200
    12.014    27.119     0.200
    12.162    29.129     0.200
    12.338    26.294     0.200
    12.604    29.653     0.200
    12.730    29.614     0.200
    12.658    30.061     0.200
    12.892    30.364     0.200
    13.410    29.137     0.200
    14.045    31.301     0.200
    14.013    32.874     0.200
    14.084    32.058     0.200
    14.179    30.971     0.200
    14.629    31.462     0.200
    14.685    33.396     0.200
    14.981    34.011     0.200
    15.136    33.733     0.200
    15.366    34.079     0.200
    15.458    34.144     0.200
    15.607    34.799     0.200
    16.750    35.537     0.200
    16.778    35.393     0.200
    16.881    36.480     0.200
     1.127     7.283     0.200
     1.200     7.677     0.200
     1.340     8.005     0.200
     1.355     8.578     0.200
     1.355     8.486     0.200
     1.384     8.764     0.200
     1.473     9.645     0.200
     1.933    10.122     0.200
     1.936    10.253     0.200
     2.102    10.714     0.200
     2.142    11.008     0.200
     2.142    11.228     0.200
     2.143    10.184     0.200
     2.152    10.967     0.200
     2.152    11.127     0.200
     2.413     9.711     0.200
     2.654    11.496     0.200
     2.887    11.997     0.200
     3.027    13.042     0.200
     3.071    13.298     0.200
     3.071    12.888     0.200
     3.098    13.371     0.200
     3.257    11.531     0.200
     3.168    13.281     0.200
     3.178    13.169     0.200
     3.184    13.442     0.200
     3.197    13.424     0.200
     3.196    13.308     0.200
     3.224    13.462     0.200
     3.531    13.538     0.200
     3.632    13.950     0.200
     3.745    13.606     0.200
     3.756    14.342     0.200
     4.065    14.227     0.200
     4.148    14.828     0.200
     4.212    14.565     0.200
     4.303    14.939     0.200
     4.318    13.545     0.200
     4.318    13.356     0.200
     4.440    15.841     0.200
     4.521    16.297     0.200
     4.740    15.467     0.200
     4.699    16.093     0.200
     4.811    15.501     0.200
     4.829    15.545     0.200
     4.944    15.301     0.200
     4.981    16.665     0.200
     5.085    14.797     0.200
     5.085    14.525     0.200
     5.099    16.160     0.200
     5.375    16.406     0.200
     5.472    17.083     0.200
     5.548    16.594     0.200
     5.715    15.410     0.200
     5.715    15.711     0.200
     5.748    17.736     0.200
     5.874    17.876     0.200
     6.340    19.316     0.200
     6.350    19.217     0.200
     6.388    20.466     0.200
     6.574    19.457     0.200
     6.589    19.479     0.200
     6.752    19.568     0.200
     6.870    19.682     0.200
     6.891    20.491     0.200
     7.039    19.130     0.200
     7.104    20.541     0.200
     7.227    21.301     0.200
     7.279    20.835     0.200
     7.362    20.015     0.200
     7.385    20.842     0.200
     7.654    18.423     0.200
     7.707    21.820     0.200
     7.731    21.526     0.200
     8.021    22.059     0.200
     8.029    23.153     0.200
     8.109    22.776     0.200
     8.407    22.735     0.200
     8.424    22.146     0.200
     8.440    24.751     0.200
     8.440    23.751     0.200
     8.597    23.085     0.200
     8.692    23.614     0.200
     8.986    24.112     0.200
     9.087    24.473     0.200
     9.188    23.520     0.200
     9.333    23.938     0.200
     9.476    24.904     0.200
     9.518    26.008     0.200
     9.784    24.097     0.200
     9.991    24.206     0.200
    10.340    25.675     0.200
    10.277    26.583     0.200
    10.460    26.126     0.200
    10.558    26.389     0.200
    10.646    26.532     0.200
    10.988    26.556     0.200
    11.456    27.027     0.200
    11.494    27.640     0.200
    12.003    28.425     0.200
    12.262    30.907     0.200
    12.377    29.986     0.200
    12.455    30.770     0.200
    12.610    28.298     0.200
    12.610    26.663     0.200
    12.610    28.298     0.200
    12.516    30.640     0.200
    12.724    31.128     0.200
    12.800    32.814     0.200
    13.117    30.474     0.200
    13.317    31.289     0.200
    13.543    33.277     0.200
    14.029    33.714     0.200
    14.157    32.270     0.200
    14.491    33.226     0.200
    14.491    32.506     0.200
    14.582    32.992     0.200
    14.591    33.722     0.200
    14.628    32.876     0.200
    14.832    35.585     0.200
    14.981    36.006     0.200
    15.051    35.693     0.200
    15.176    36.161     0.200
    15.194    33.133     0.200
    15.543    36.445     0.200
    15.574    38.072     0.200
    15.989    37.098     0.200
    16.087    37.232     0.200
    16.178    34.808     0.200
    16.208    36.350     0.200
    16.297    35.921     0.200
    16.304    35.668     0.200
    16.636    35.951     0.200
    16.714    36.282     0.200
    16.913    38.660     0.200
    17.322    36.003     0.200
    17.324    36.835     0.200
    17.352    38.289     0.200
    17.832    37.115     0.200
    17.926    36.873     0.200
     0.500     3.368     0.200
     0.503     3.614     0.200
     0.416     5.049     0.200
     0.416     5.259     0.200
     0.850     6.463     0.200
     0.894     6.834     0.200
     0.894     6.701     0.200
     0.914     6.943     0.200
     0.927     7.225     0.200
     1.026     7.617     0.200
     1.068     7.320     0.200
     1.077     7.070     0.200
     1.255     6.950     0.200
     1.409     7.655     0.200
     1.443     7.993     0.200
     1.786     8.389     0.200
     2.231     9.075     0.200
     3.084    11.383     0.200
     3.211    12.724     0.200
     3.211    12.833     0.200
     3.242    12.678     0.200
     3.307    12.531     0.200
     3.340    12.520     0.200
     3.352    13.320     0.200
     3.711    12.892     0.200
     3.711    13.142     0.200
     3.891    12.892     0.200
     3.891    12.423     0.200
     3.800    13.140     0.200
     3.935    13.832     0.200
     4.177    13.421     0.200
     4.262    13.787     0.200
     4.266    12.984     0.200
     4.331    13.883     0.200
     4.319    13.626     0.200
     4.391    13.776     0.200
     4.353    13.595     0.200
     4.490    13.438     0.200
     4.613    13.559     0.200
     4.613    13.169     0.200
     4.649    13.858     0.200
     4.766    14.629     0.200
     4.769    14.370     0.200
     4.795    14.681     0.200
     4.733    14.574     0.200
     4.841    14.656     0.200
     5.048    15.042     0.200
     5.215    14.109     0.200
     5.215    13.780     0.200
     5.177    14.986     0.200
     5.290    15.148     0.200
     5.251    15.325     0.200
     5.462    16.076     0.200
     5.626    16.154     0.200
     5.683    16.778     0.200
     5.711    17.087     0.200
     5.778    16.003     0.200
     5.870    16.481     0.200
     5.889    16.249     0.200
     5.938    18.200     0.200
     5.938    17.410     0.200
     6.155    17.130     0.200
     6.214    18.483     0.200
     6.251    17.204     0.200
     6.278    17.549     0.200
     6.408    17.568     0.200
     6.534    17.836     0.200
     6.692    18.855     0.200
     6.675    17.664     0.200
     6.785    17.732     0.200
     6.814    18.526     0.200
     7.009    18.693     0.200
     7.307    18.921     0.200
     7.358    19.332     0.200
     7.403    19.886     0.200
     7.562    19.466     0.200
     7.857    18.941     0.200
     7.828    19.885     0.200
     7.882    20.251     0.200
     7.947    19.586     0.200
     8.002    20.697     0.200
     8.376    20.864     0.200
     8.516    20.863     0.200
     8.753    21.559     0.200
     8.635    23.225     0.200
     8.765    22.376     0.200
     9.052    22.537     0.200
     9.247    22.042     0.200
     9.440    21.866     0.200
     9.408    23.368     0.200
     9.741    23.385     0.200
     9.797    24.902     0.200
    10.170    27.812     0.200
    11.004    26.536     0.200
    11.555    28.052     0.200
    12.092    28.638     0.200
    14.562    32.206     0.200
    14.572    32.339     0.200
    16.078    33.793     0.200
    16.561    35.507     0.200
    16.692    34.237     0.200
    16.725    35.124     0.200
    17.194    35.155     0.200
    17.306    34.866     0.200
    18.295    36.323     0.200
     1.186     6.787     0.200
     1.164     7.518     0.200
     1.188     7.929     0.200
     1.218     8.005     0.200
     1.233     8.206     0.200
     1.366     8.053     0.200
     1.416     8.403     0.200
     1.416     8.165     0.200
     1.326     8.275     0.200
     1.383     8.463     0.200
     1.393     8.170     0.200
     1.648     7.453     0.200
     1.892     8.790     0.200
     2.289    10.483     0.200
     2.983    11.215     0.200
     3.300    12.276     0.200
     3.540    12.848     0.200
     3.640    11.784     0.200
     3.465    14.594     0.200
     3.508    15.085     0.200
     3.538    14.235     0.200
     3.637    14.316     0.200
     3.978    13.387     0.200
     4.046    13.478     0.200
     4.069    13.615     0.200
     4.182    13.670     0.200
     4.003    14.907     0.200
     4.003    14.688     0.200
     4.095    14.871     0.200
     4.284    14.478     0.200
     4.302    13.472     0.200
     4.381    12.599     0.200
     4.228    15.171     0.200
     4.442    13.871     0.200
     4.630    14.794     0.200
     4.665    14.409     0.200
     4.714    14.770     0.200
     4.820    14.854     0.200
     4.996    13.387     0.200
     4.996    13.519     0.200
     5.129    15.891     0.200
     5.182    15.936     0.200
     5.143    15.639     0.200
     5.022    16.949     0.200
     5.304    15.861     0.200
     5.298    15.887     0.200
     5.588    16.977     0.200
     5.700    17.181     0.200
     5.839    17.157     0.200
     5.840    16.571     0.200
     5.844    17.740     0.200
     5.984    17.021     0.200
     6.191    18.282     0.200
     6.174    17.871     0.200
     6.240    20.005     0.200
     6.468    18.109     0.200
     6.611    17.450     0.200
     6.605    19.132     0.200
     6.661    18.802     0.200
     6.640    18.243     0.200
     6.848    18.762     0.200
     6.962    19.707     0.200
     7.317    19.821     0.200
     7.478    20.465     0.200
     7.542    20.515     0.200
     7.774    21.129     0.200
     7.897    21.173     0.200
     8.110    21.798     0.200
     8.432    21.987     0.200
     8.582    21.502     0.200
     8.757    23.011     0.200
     8.846    24.843     0.200
     9.050    21.647     0.200
     9.076    22.217     0.200
     8.930    23.211     0.200
     8.930    24.453     0.200
     9.250    21.744     0.200
     9.389    24.019     0.200
     9.897    24.553     0.200
    10.469    25.158     0.200
    11.846    26.464     0.200
    18.170    35.831     0.200
     0.411     5.361     0.200
     0.514     3.644     0.200
     0.838     6.826     0.200
     0.882     7.312     0.200
     0.902     7.263     0.200
     1.014     8.034     0.200
     1.056     7.735     0.200
     1.065     7.352     0.200
     1.257     7.362     0.200
     1.444     8.240     0.200
     1.790     8.216     0.200
     2.233     9.273     0.200
     3.086    11.092     0.200
     3.201    12.402     0.200
     3.201    12.925     0.200
     3.342    12.908     0.200
     3.429    12.153     0.200
     3.701    13.567     0.200
     3.701    13.247     0.200
     3.790    13.519     0.200
     3.899    12.257     0.200
     3.899    11.444     0.200
     4.263    13.004     0.200
     4.318    13.402     0.200
     4.348    13.406     0.200
     4.621    13.037     0.200
     4.621    12.630     0.200
     4.796    14.647     0.200
     4.840    14.248     0.200
     5.042    15.166     0.200
     5.222    13.893     0.200
     5.222    13.713     0.200
     5.222    14.080     0.200
     5.248    15.940     0.200
     5.705    17.030     0.200
     5.870    16.682     0.200
     5.884    16.593     0.200
     5.926    17.702     0.200
     5.926    18.053     0.200
     6.251    17.561     0.200
     6.411    17.692     0.200
     6.673    18.054     0.200
     6.811    18.479     0.200
     6.863    18.735     0.200
     7.351    19.747     0.200
     7.561    19.952     0.200
     7.677    20.758     0.200
     7.992    21.273     0.200
     8.382    21.688     0.200
     8.625    23.603     0.200
     8.625    23.103     0.200
     8.663    21.070     0.200
     8.939    22.237     0.200
     8.939    22.440     0.200
     8.977    22.618     0.200
     9.135    21.969     0.200
     9.164    23.276     0.200
     9.366    21.593     0.200
     9.653    22.901     0.200
     9.653    22.455     0.200
     9.721    26.302     0.200
     9.745    22.140     0.200
     9.940    23.284     0.200
     9.976    24.198     0.200
    10.034    24.632     0.200
    10.049    24.028     0.200
    10.160    25.989     0.200
    10.160    26.091     0.200
    10.160    26.599     0.200
    10.437    26.505     0.200
    10.531    25.812     0.200
    10.539    26.085     0.200
    10.999    27.186     0.200
    11.554    27.560     0.200
    11.754    28.794     0.200
    11.771    28.684     0.200
    11.771    27.387     0.200
    11.771    29.028     0.200
    11.954    25.441     0.200
    11.954    25.714     0.200
    12.307    29.632     0.200
    12.560    27.792     0.200
    13.122    30.979     0.200
    14.306    33.804     0.200
    14.440    33.668     0.200
    14.612    32.403     0.200
    14.699    34.717     0.200
    15.158    34.811     0.200
    15.158    34.569     0.200
    15.158    34.264     0.200
    15.576    36.187     0.200
    19.313    36.978     0.200
    20.195    36.549     0.200
     1.066     7.613     0.200
     1.157     8.275     0.200
     1.167     8.397     0.200
     1.169     8.332     0.200
     1.175     8.692     0.200
     1.287     9.505     0.200
     1.267     8.546     0.200
     1.266     8.233     0.200
     1.497     8.614     0.200
     1.662     9.478     0.200
     1.705     9.543     0.200
     1.973     9.270     0.200
     2.607    12.733     0.200
     3.223    14.297     0.200
     3.267    14.649     0.200
     3.296    14.709     0.200
     3.366    14.638     0.200
     3.379    14.463     0.200
     3.394    14.821     0.200
     3.413    14.907     0.200
     3.712    13.840     0.200
     3.862    14.384     0.200
     3.948    13.805     0.200
     3.751    14.933     0.200
     3.977    15.489     0.200
     4.372    15.267     0.200
     4.445    14.776     0.200
     4.563    15.059     0.200
     4.698    13.961     0.200
     4.667    15.537     0.200
     4.957    15.647     0.200
     5.029    16.084     0.200
     5.112    15.560     0.200
     5.318    13.637     0.200
     5.318    15.758     0.200
     5.363    16.863     0.200
     5.553    17.477     0.200
     5.633    17.348     0.200
     5.907    18.253     0.200
     5.913    18.468     0.200
     6.033    18.530     0.200
     6.085    18.342     0.200
     6.136    18.590     0.200
     6.205    18.470     0.200
     6.172    19.389     0.200
     6.446    18.967     0.200
     6.499    18.222     0.200
     6.601    18.702     0.200
     6.597    19.325     0.200
     6.876    17.739     0.200
     6.852    19.441     0.200
     6.940    19.892     0.200
     6.923    20.224     0.200
     6.950    19.778     0.200
     7.059    19.912     0.200
     7.097    19.868     0.200
     7.111    19.850     0.200
     7.231    18.523     0.200
     7.266    21.382     0.200
     7.293    20.078     0.200
     7.594    21.034     0.200
     7.679    22.341     0.200
     7.835    22.105     0.200
     7.979    20.974     0.200
     8.081    22.932     0.200
     8.172    21.965     0.200
     8.320    23.264     0.200
     8.555    23.977     0.200
     8.674    23.636     0.200
     8.681    22.750     0.200
     8.813    23.066     0.200
     9.044    24.217     0.200
     9.315    24.886     0.200
     9.309    25.837     0.200
     9.326    24.427     0.200
     9.287    24.643     0.200
     9.376    23.546     0.200
     9.404    24.354     0.200
     9.541    23.347     0.200
     9.577    23.482     0.200
     9.681    25.479     0.200
     9.911    25.169     0.200
     9.786    28.668     0.200
     9.803    27.119     0.200
    10.069    25.959     0.200
    10.061    25.771     0.200
    10.503    29.073     0.200
    10.755    26.707     0.200
    10.848    27.577     0.200
    11.044    27.522     0.200
    11.328    27.487     0.200
    11.352    28.727     0.200
    11.322    28.886     0.200
    11.457    26.113     0.200
    11.609    28.127     0.200
    11.654    29.373     0.200
    11.778    28.256     0.200
    11.824    29.299     0.200
    11.826    29.350     0.200
    11.856    27.170     0.200
    12.037    29.263     0.200
    12.107    30.646     0.200
    12.169    28.671     0.200
    12.169    26.821     0.200
    12.301    30.052     0.200
    12.334    29.998     0.200
    12.302    30.438     0.200
    12.364    30.562     0.200
    12.478    30.278     0.200
    12.483    28.620     0.200
    12.713    28.372     0.200
    12.774    30.457     0.200
    12.836    31.077     0.200
    12.940    31.215     0.200
    12.951    32.127     0.200
    13.041    32.987     0.200
    13.179    32.369     0.200
    13.749    33.466     0.200
    13.897    33.607     0.200
    13.949    35.199     0.200
    14.233    36.252     0.200
    14.760    35.083     0.200
    14.768    35.310     0.200
    14.841    34.170     0.200
    15.046    35.209     0.200
    15.133    37.466     0.200
    15.187    35.689     0.200
    17.270    36.704     0.200
    17.394    37.536     0.200
    17.492    38.145     0.200
     1.513     8.470     0.200
     1.513     8.631     0.200
     1.664     9.316     0.200
     1.697     9.656     0.200
     1.697     9.116     0.200
     1.697     9.347     0.200
     2.042     9.738     0.200
     2.259    10.323     0.200
     2.259    10.643     0.200
     2.489    10.722     0.200
     2.489    11.163     0.200
     2.646    11.154     0.200
     2.646    11.767     0.200
     3.182    11.240     0.200
     3.341    12.732     0.200
     3.786    14.070     0.200
     3.834    13.751     0.200
     3.834    13.930     0.200
     3.900    14.196     0.200
     3.900    14.645     0.200
     4.435    14.685     0.200
     4.435    14.884     0.200
     4.481    14.745     0.200
     4.496    14.467     0.200
     4.519    14.900     0.200
     4.561    14.763     0.200
     4.569    15.689     0.200
     4.848    14.096     0.200
     5.027    16.407     0.200
     5.051    15.359     0.200
     5.087    15.537     0.200
     5.251    16.232     0.200
     5.455    15.435     0.200
     5.476    17.156     0.200
     5.717    16.203     0.200
     5.864    18.041     0.200
     5.892    17.230     0.200
     5.940    18.724     0.200
     5.996    17.567     0.200
     6.092    17.828     0.200
     6.119    18.050     0.200
     6.389    18.540     0.200
     6.504    19.265     0.200
     6.665    19.390     0.200
     6.730    18.570     0.200
     6.919    19.755     0.200
     6.948    20.560     0.200
     7.040    20.877     0.200
     7.043    19.924     0.200
     7.118    21.138     0.200
     7.260    20.890     0.200
     7.534    21.223     0.200
     7.614    21.304     0.200
     7.808    21.573     0.200
     8.066    22.123     0.200
     8.080    21.890     0.200
     8.109    21.528     0.200
     8.118    21.666     0.200
     8.195    21.292     0.200
     8.456    24.737     0.200
     8.595    22.714     0.200
     8.746    22.486     0.200
     9.007    23.156     0.200
     9.199    24.049     0.200
     9.388    23.626     0.200
     9.495    23.808     0.200
     9.510    23.099     0.200
     9.653    25.222     0.200
     9.690    23.236     0.200
     9.773    25.821     0.200
    10.046    25.247     0.200
    10.276    28.675     0.200
    10.288    25.059     0.200
    10.327    25.011     0.200
    10.745    26.719     0.200
    10.818    26.438     0.200
    11.207    27.533     0.200
    11.201    28.716     0.200
    13.781    33.098     0.200
    13.869    31.529     0.200
    13.909    30.104     0.200
    14.830    32.765     0.200
    14.861    32.931     0.200
    15.808    35.265     0.200
    15.956    35.570     0.200
    16.335    37.291     0.200
    16.735    36.213     0.200
    16.950    37.137     0.200
    16.981    37.146     0.200
    17.563    35.480     0.200
     0.573     5.174     0.200
     0.573     5.344     0.200
     0.563     6.232     0.200
     0.679     6.551     0.200
     0.693     6.683     0.200
     0.826     4.316     0.200
     0.827     4.193     0.200
     0.765     6.829     0.200
     0.767     6.629     0.200
     0.798     7.136     0.200
     1.496     7.904     0.200
     1.625     8.807     0.200
     1.646     9.099     0.200
     1.646     7.769     0.200
     2.060     8.046     0.200
     2.253     9.560     0.200
     2.477     9.848     0.200
     2.562    10.085     0.200
     2.826    11.955     0.200
     2.869    11.779     0.200
     2.869    10.989     0.200
     2.899    12.073     0.200
     2.998    13.256     0.200
     3.010    10.456     0.200
     3.318    11.754     0.200
     3.369    12.439     0.200
     3.369    12.039     0.200
     3.458    12.722     0.200
     3.678    12.870     0.200
     3.593    13.112     0.200
     3.796    13.413     0.200
     3.829    13.188     0.200
     4.394    14.073     0.200
     4.368    12.920     0.200
     4.310    15.131     0.200
     4.430    13.966     0.200
     4.398    13.568     0.200
     4.490    13.080     0.200
     4.392    15.034     0.200
     4.526    14.452     0.200
     4.608    14.443     0.200
     4.918    14.661     0.200
     4.933    12.887     0.200
     4.933    13.207     0.200
     5.006    14.952     0.200
     4.996    14.380     0.200
     5.027    15.612     0.200
     5.034    15.276     0.200
     5.082    15.163     0.200
     5.338    15.644     0.200
     5.356    15.079     0.200
     5.526    14.321     0.200
     5.521    16.675     0.200
     5.733    16.359     0.200
     5.699    16.826     0.200
     5.669    17.700     0.200
     5.749    16.599     0.200
     5.845    16.144     0.200
     5.903    17.842     0.200
     5.921    16.689     0.200
     6.033    16.424     0.200
     6.267    17.157     0.200
     6.438    17.551     0.200
     6.551    18.034     0.200
     6.658    18.171     0.200
     6.726    18.796     0.200
     6.818    18.157     0.200
     6.834    17.806     0.200
     6.903    19.315     0.200
     6.910    18.321     0.200
     7.069    18.590     0.200
     7.105    19.673     0.200
     7.161    19.382     0.200
     7.183    18.809     0.200
     7.263    19.870     0.200
     7.342    19.388     0.200
     7.337    19.813     0.200
     7.407    18.046     0.200
     7.424    19.095     0.200
     7.452    19.918     0.200
     7.710    19.840     0.200
     8.008    20.070     0.200
     7.996    20.349     0.200
     8.013    21.040     0.200
     8.081    20.365     0.200
     8.140    20.099     0.200
     8.157    22.688     0.200
     8.223    21.006     0.200
     8.256    20.462     0.200
     8.293    23.379     0.200
     8.293    22.699     0.200
     8.445    21.580     0.200
     8.640    22.129     0.200
     8.612    21.098     0.200
     8.687    22.448     0.200
     8.898    22.383     0.200
     8.955    21.527     0.200
     9.030    21.694     0.200
     9.226    22.864     0.200
     9.322    22.486     0.200
     9.387    22.488     0.200
     9.356    25.220     0.200
     9.408    25.059     0.200
     9.543    23.036     0.200
     9.553    23.630     0.200
     9.622    23.668     0.200
     9.729    22.015     0.200
     9.715    23.685     0.200
     9.679    24.183     0.200
     9.944    23.814     0.200
     9.828    25.869     0.200
     9.828    24.709     0.200
     9.959    24.352     0.200
    10.007    23.655     0.200
     9.970    24.639     0.200
    12.018    28.202     0.200
    12.175    24.917     0.200
    12.175    26.385     0.200
    12.622    29.264     0.200
     0.367     4.573     0.200
     0.522     5.463     0.200
     0.859     5.766     0.200
     0.889     6.183     0.200
     0.969     6.481     0.200
     1.047     6.975     0.200
     1.103     6.832     0.200
     1.113     7.475     0.200
     1.307     6.242     0.200
     1.241     7.587     0.200
     1.293     7.653     0.200
     1.295     7.620     0.200
     1.320     7.834     0.200
     1.551     7.422     0.200
     1.516     8.234     0.200
     1.784     8.240     0.200
     1.858     8.627     0.200
     2.643    10.277     0.200
     3.045    11.420     0.200
     3.106    10.903     0.200
     3.163    11.635     0.200
     3.705    12.214     0.200
     3.778    12.445     0.200
     3.730    13.476     0.200
     3.843    12.503     0.200
     3.844    12.281     0.200
     3.857    12.776     0.200
     3.824    14.202     0.200
     3.868    13.435     0.200
     3.956    12.180     0.200
     4.000    12.494     0.200
     4.079    10.585     0.200
     4.004    12.033     0.200
     4.156    12.919     0.200
     4.176    12.497     0.200
     4.276    13.388     0.200
     4.290    13.867     0.200
     4.234    15.010     0.200
     4.328    13.681     0.200
     4.374    13.166     0.200
     4.496    13.989     0.200
     4.491    14.998     0.200
     4.684    12.937     0.200
     4.684    12.649     0.200
     4.796    13.964     0.200
     4.967    13.347     0.200
     5.004    14.901     0.200
     5.510    16.771     0.200
     5.555    15.663     0.200
     5.610    16.477     0.200
     5.720    16.135     0.200
     5.855    16.440     0.200
     5.864    17.032     0.200
     6.000    17.061     0.200
     6.068    17.724     0.200
     6.265    18.441     0.200
     6.265    18.441     0.200
     6.338    17.895     0.200
     6.290    17.277     0.200
     6.382    17.382     0.200
     6.469    18.380     0.200
     6.545    17.157     0.200
     6.586    17.802     0.200
     6.629    17.585     0.200
     7.003    18.526     0.200
     7.217    19.228     0.200
     7.199    19.061     0.200
     7.347    19.230     0.200
     7.439    19.578     0.200
     7.519    20.895     0.200
     7.533    20.172     0.200
     7.584    19.981     0.200
     8.140    20.752     0.200
     8.249    20.311     0.200
     8.241    20.967     0.200
     8.435    21.486     0.200
     8.563    20.850     0.200
     8.669    21.736     0.200
     8.727    20.422     0.200
     8.747    19.918     0.200
     8.746    21.868     0.200
     8.924    20.143     0.200
     9.063    22.985     0.200
     9.104    23.990     0.200
     9.246    21.042     0.200
     9.428    24.196     0.200
     9.566    22.385     0.200
     9.785    23.633     0.200
    10.392    24.277     0.200
    10.756    26.739     0.200
    11.063    27.125     0.200
    11.203    27.646     0.200
    11.350    27.578     0.200
    11.370    27.842     0.200
    11.505    24.375     0.200
    11.505    25.686     0.200
    11.704    27.491     0.200
    11.742    27.681     0.200
    12.052    27.272     0.200
    12.323    29.070     0.200
    12.367    30.996     0.200
    13.100    29.933     0.200
    13.164    29.930     0.200
    13.647    32.629     0.200
    13.971    33.589     0.200
    14.093    30.421     0.200
    14.107    33.291     0.200
    14.183    31.871     0.200
    15.249    33.462     0.200
    16.232    34.632     0.200
    16.727    34.914     0.200
    16.825    33.701     0.200
    17.829    34.691     0.200
    17.829    34.207     0.200
     1.066     9.411     0.200
     1.081     9.710     0.200
     1.206    10.538     0.200
     1.827    11.539     0.200
     1.839    11.702     0.200
     1.837    13.277     0.200
     2.360    13.205     0.200
     2.813    14.002     0.200
     2.879    15.654     0.200
     2.879    15.537     0.200
     2.977    15.452     0.200
     2.983    15.756     0.200
     2.999    15.715     0.200
     3.028    16.353     0.200
     3.053    15.820     0.200
     3.337    14.015     0.200
     3.337    13.867     0.200
     3.353    15.759     0.200
     3.451    16.229     0.200
     3.502    16.460     0.200
     3.579    16.649     0.200
     4.005    16.394     0.200
     4.155    16.583     0.200
     4.377    16.167     0.200
     4.384    18.401     0.200
     4.700    17.647     0.200
     4.756    17.641     0.200
     4.795    17.717     0.200
     4.810    18.636     0.200
     4.904    18.236     0.200
     4.895    18.510     0.200
     5.062    18.409     0.200
     5.125    17.016     0.200
     5.220    18.211     0.200
     5.338    18.784     0.200
     5.346    19.011     0.200
     5.379    19.894     0.200
     5.412    18.197     0.200
     5.542    19.573     0.200
     5.742    17.356     0.200
     5.742    18.013     0.200
     5.786    20.600     0.200
     5.873    20.239     0.200
     6.032    19.998     0.200
     6.183    20.979     0.200
     6.161    21.860     0.200
     6.267    21.506     0.200
     6.299    21.201     0.200
     6.381    21.195     0.200
     6.707    21.624     0.200
     6.706    22.088     0.200
     6.987    22.162     0.200
     7.013    22.240     0.200
     7.242    23.040     0.200
     7.276    23.452     0.200
     7.348    23.157     0.200
     7.355    23.373     0.200
     7.587    24.168     0.200
     7.685    21.765     0.200
     7.676    23.562     0.200
     7.798    24.640     0.200
     7.861    23.750     0.200
     7.910    24.562     0.200
     8.132    24.737     0.200
     8.216    26.489     0.200
     8.253    25.941     0.200
     8.380    24.686     0.200
     8.416    24.361     0.200
     8.408    26.421     0.200
     8.275    26.207     0.200
     8.435    25.676     0.200
     8.474    25.486     0.200
     8.531    27.013     0.200
     8.881    25.113     0.200
     9.317    25.732     0.200
     9.477    28.484     0.200
     9.794    26.660     0.200
     9.816    26.089     0.200
     9.992    26.052     0.200
     9.824    30.403     0.200
    10.311    27.615     0.200
    10.495    28.760     0.200
    10.580    28.344     0.200
    10.635    28.395     0.200
    10.890    28.741     0.200
    11.460    29.835     0.200
    12.536    28.011     0.200
     1.533     8.265     0.200
     1.697     8.883     0.200
     1.782    10.213     0.200
     2.064     9.783     0.200
     2.280    10.332     0.200
     2.509    10.826     0.200
     3.012    13.636     0.200
     3.012    13.157     0.200
     3.120    11.383     0.200
     3.125    13.640     0.200
     3.124    14.004     0.200
     3.157    13.866     0.200
     3.184    13.884     0.200
     3.361    12.592     0.200
     3.503    13.807     0.200
     3.503    14.288     0.200
     3.644    14.459     0.200
     3.729    14.478     0.200
     4.140    13.581     0.200
     4.140    13.870     0.200
     4.405    14.802     0.200
     4.456    14.999     0.200
     4.508    14.554     0.200
     4.541    15.037     0.200
     4.609    15.537     0.200
     4.519    16.848     0.200
     4.602    16.488     0.200
     4.873    13.926     0.200
     4.873    14.187     0.200
     4.927    15.525     0.200
     5.044    15.814     0.200
     5.048    16.309     0.200
     5.070    17.062     0.200
     5.103    15.603     0.200
     5.258    16.082     0.200
     5.487    17.326     0.200
     5.480    15.134     0.200
     5.740    17.256     0.200
     5.683    19.105     0.200
     5.877    17.859     0.200
     5.896    17.749     0.200
     5.902    18.813     0.200
     5.902    18.463     0.200
     6.005    17.154     0.200
     6.135    17.470     0.200
     6.413    18.486     0.200
     6.521    18.785     0.200
     6.754    20.172     0.200
     6.933    19.629     0.200
     6.967    20.231     0.200
     7.004    18.807     0.200
     7.054    19.525     0.200
     7.556    20.262     0.200
     7.822    21.374     0.200
     8.097    21.695     0.200
     8.130    21.433     0.200
     8.132    21.639     0.200
     8.200    21.775     0.200
     8.222    24.104     0.200
     8.347    24.810     0.200
     8.431    24.204     0.200
     8.431    23.823     0.200
     8.566    23.177     0.200
     8.757    22.167     0.200
     9.020    23.165     0.200
     9.030    23.062     0.200
     9.214    25.462     0.200
     9.320    24.135     0.200
     9.519    23.213     0.200
     9.499    25.968     0.200
     9.641    23.914     0.200
     9.667    24.553     0.200
     9.713    23.164     0.200
     9.624    26.833     0.200
     9.919    23.735     0.200
     9.919    23.514     0.200
    10.019    24.564     0.200
     9.972    26.616     0.200
    12.230    26.806     0.200
    14.410    32.227     0.200
    14.930    36.059     0.200
    15.210    35.950     0.200
    15.360    36.282     0.200
    15.381    37.018     0.200
    15.592    36.986     0.200
    15.684    37.417     0.200
    15.775    36.297     0.200
    15.775    36.457     0.200
    15.854    36.079     0.200
    16.016    36.149     0.200
    16.057    37.260     0.200
    16.068    37.757     0.200
    16.089    37.496     0.200
    16.257    36.828     0.200
    16.647    38.442     0.200
    16.761    38.291     0.200
    16.951    38.683     0.200
    17.107    38.447     0.200
    17.140    38.097     0.200
    17.228    38.013     0.200
    17.331    37.798     0.200
    18.574    38.283     0.200
     1.049     7.065     0.200
     1.135     7.757     0.200
     1.116     7.070     0.200
     1.116     6.798     0.200
     1.187     7.946     0.200
     1.226     6.552     0.200
     1.248     8.199     0.200
     1.324     8.451     0.200
     1.513     8.022     0.200
     1.782     9.183     0.200
     1.845     7.465     0.200
     1.839     9.845     0.200
     1.859     9.892     0.200
     1.884     9.583     0.200
     1.893     9.677     0.200
     1.917     9.764     0.200
     1.985    10.523     0.200
     2.078     9.645     0.200
     2.107    10.093     0.200
     2.124    10.167     0.200
     2.892    10.841     0.200
     2.892     9.979     0.200
     3.413    12.120     0.200
     3.520    12.399     0.200
     3.560    12.329     0.200
     3.597    12.393     0.200
     3.615    11.870     0.200
     3.658    11.407     0.200
     3.658    11.126     0.200
     4.078    13.536     0.200
     4.078    13.301     0.200
     4.160    13.973     0.200
     4.292    12.723     0.200
     4.292    12.254     0.200
     4.285    13.987     0.200
     4.428    14.165     0.200
     4.532    13.900     0.200
     4.772    15.092     0.200
     4.782    16.390     0.200
     4.782    14.089     0.200
     4.919    15.764     0.200
     5.134    15.754     0.200
     5.164    15.708     0.200
     5.408    16.711     0.200
     5.511    15.832     0.200
     5.739    17.295     0.200
     5.794    17.834     0.200
     5.922    17.868     0.200
     5.961    17.763     0.200
     5.962    17.369     0.200
     6.147    17.303     0.200
     6.366    18.314     0.200
     6.589    18.177     0.200
     6.664    18.273     0.200
     6.697    20.104     0.200
     6.788    18.381     0.200
     7.075    19.530     0.200
     7.226    19.501     0.200
     7.391    20.185     0.200
     7.393    20.086     0.200
     7.659    20.936     0.200
     8.105    21.946     0.200
     8.199    22.612     0.200
     8.292    22.108     0.200
     8.369    21.019     0.200
     8.344    21.337     0.200
     8.896    23.103     0.200
     9.064    24.040     0.200
    11.314    28.159     0.200
    11.327    25.557     0.200
    13.127    29.503     0.200
    15.385    34.641     0.200
    15.500    35.098     0.200
    15.694    34.850     0.200
    15.920    37.041     0.200
    15.981    35.210     0.200
    16.419    35.005     0.200
    16.502    35.730     0.200
    16.571    35.661     0.200
    17.034    34.817     0.200
    17.607    35.922     0.200
     1.521     8.387     0.200
     1.552     9.078     0.200
     1.557     8.988     0.200
     1.581     8.961     0.200
     1.666     8.036     0.200
     1.846     9.576     0.200
     1.936     9.263     0.200
     2.230    10.351     0.200
     2.265    10.651     0.200
     2.335    11.025     0.200
     2.393     9.391     0.200
     2.393     9.094     0.200
     2.703    12.317     0.200
     2.703    12.915     0.200
     2.706    12.275     0.200
     2.778    12.534     0.200
     3.016    11.502     0.200
     3.451    11.745     0.200
     3.451    11.085     0.200
     3.440    12.521     0.200
     3.555    12.677     0.200
     3.807    14.695     0.200
     3.807    13.257     0.200
     3.939    13.325     0.200
     3.906    14.864     0.200
     3.907    14.602     0.200
     3.918    14.979     0.200
     4.019    13.261     0.200
     3.953    13.860     0.200
     4.030    13.602     0.200
     4.083    13.679     0.200
     4.130    13.373     0.200
     4.142    13.399     0.200
     4.205    14.020     0.200
     4.220    12.473     0.200
     4.220    12.812     0.200
     4.293    13.939     0.200
     4.292    15.027     0.200
     4.292    14.539     0.200
     4.382    14.552     0.200
     4.444    13.700     0.200
     4.387    15.171     0.200
     4.473    14.233     0.200
     4.441    15.630     0.200
     4.518    15.636     0.200
     4.600    14.713     0.200
     4.613    14.519     0.200
     4.553    15.720     0.200
     4.663    15.192     0.200
     4.854    13.364     0.200
     4.854    13.782     0.200
     4.930    14.704     0.200
     5.189    15.676     0.200
     5.207    15.977     0.200
     5.246    15.647     0.200
     5.303    17.544     0.200
     5.368    16.406     0.200
     5.360    17.887     0.200
     5.609    16.622     0.200
     5.636    17.027     0.200
     5.775    17.632     0.200
     5.950    17.802     0.200
     5.933    17.292     0.200
     6.116    18.447     0.200
     6.100    18.151     0.200
     6.206    17.754     0.200
     6.246    17.161     0.200
     6.251    17.955     0.200
     6.310    18.083     0.200
     6.320    18.420     0.200
     6.474    16.678     0.200
     6.478    18.865     0.200
     6.525    16.750     0.200
     6.461    18.804     0.200
     6.545    16.133     0.200
     6.633    18.659     0.200
     6.604    20.353     0.200
     6.604    19.615     0.200
     6.747    19.073     0.200
     6.786    19.391     0.200
     6.772    19.039     0.200
     6.819    17.229     0.200
     6.858    17.640     0.200
     6.870    19.451     0.200
     6.941    20.014     0.200
     7.008    18.971     0.200
     7.523    20.509     0.200
     7.583    20.238     0.200
     7.582    19.683     0.200
     7.645    20.597     0.200
     7.654    21.604     0.200
     7.679    21.878     0.200
     7.751    21.911     0.200
     7.838    21.639     0.200
     7.865    21.229     0.200
     7.883    22.548     0.200
     8.035    21.468     0.200
     8.141    21.289     0.200
     8.169    20.604     0.200
     8.279    21.036     0.200
     8.332    21.580     0.200
     8.348    21.888     0.200
     8.342    22.700     0.200
     8.499    21.827     0.200
     8.497    20.535     0.200
     8.612    22.713     0.200
     8.701    21.744     0.200
     8.833    23.205     0.200
     8.871    23.216     0.200
     8.929    21.925     0.200
     8.938    22.035     0.200
     8.977    21.741     0.200
     8.990    23.522     0.200
     9.071    24.372     0.200
     9.141    21.066     0.200
     9.157    22.822     0.200
     9.218    23.981     0.200
     9.219    24.837     0.200
     9.325    23.192     0.200
     9.325    22.891     0.200
     9.479    24.594     0.200
     9.489    23.357     0.200
     9.515    23.403     0.200
     9.595    24.588     0.200
     9.643    22.919     0.200
     9.771    23.775     0.200
     9.772    23.609     0.200
     9.804    23.855     0.200
     9.843    25.011     0.200
     9.839    25.995     0.200
     9.855    23.773     0.200
     9.901    24.541     0.200
     9.912    23.461     0.200
    10.025    24.212     0.200
    10.310    24.946     0.200
    10.328    26.507     0.200
    10.475    25.436     0.200
    10.764    28.004     0.200
    10.764    27.074     0.200
    10.810    27.098     0.200
    11.043    28.990     0.200
    11.043    28.412     0.200
    11.190    27.885     0.200
    11.215    26.814     0.200
    11.322    27.184     0.200
    11.668    28.867     0.200
    11.796    27.911     0.200
    11.859    27.515     0.200
    11.842    25.422     0.200
    11.871    29.180     0.200
    12.102    27.703     0.200
    12.278    28.168     0.200
    12.296    28.778     0.200
    13.195    30.390     0.200
    13.300    30.876     0.200
    13.269    31.603     0.200
    13.484    33.581     0.200
    13.652    30.888     0.200
    13.974    33.524     0.200
    14.920    33.146     0.200
    17.035    36.280     0.200
    17.113    35.394     0.200
    18.139    36.135     0.200
     1.356     9.528     0.200
     1.656    11.432     0.200
     1.793    10.491     0.200
     1.793    10.671     0.200
     1.846    11.391     0.200
     1.766    11.574     0.200
     1.940    11.771     0.200
     1.959    11.594     0.200
     1.968    12.025     0.200
     1.969    12.550     0.200
     1.969    11.950     0.200
     2.015    11.991     0.200
     2.327    12.473     0.200
     2.542    13.010     0.200
     2.853    13.799     0.200
     2.864    13.738     0.200
     2.827    16.017     0.200
     2.926    14.572     0.200
     2.945    14.008     0.200
     3.352    13.566     0.200
     3.307    15.881     0.200
     3.307    15.171     0.200
     3.403    14.850     0.200
     3.403    15.341     0.200
     3.454    15.298     0.200
     3.454    15.578     0.200
     3.533    15.457     0.200
     3.533    16.037     0.200
     3.569    15.396     0.200
     3.967    15.924     0.200
     4.071    15.995     0.200
     4.071    16.405     0.200
     4.118    16.167     0.200
     4.118    16.307     0.200
     4.189    16.292     0.200
     4.189    16.422     0.200
     4.383    15.629     0.200
     4.383    15.499     0.200
     4.668    17.052     0.200
     4.719    17.071     0.200
     4.733    17.102     0.200
     4.766    17.159     0.200
     4.769    16.849     0.200
     4.769    17.439     0.200
     4.804    17.226     0.200
     4.833    17.774     0.200
     4.872    17.496     0.200
     4.877    17.305     0.200
     4.932    17.708     0.200
     5.123    16.091     0.200
     5.123    16.511     0.200
     5.190    17.836     0.200
     5.307    18.244     0.200
     5.328    18.514     0.200
     5.346    18.986     0.200
     5.453    18.004     0.200
     5.473    19.014     0.200
     5.696    19.015     0.200
     5.706    19.231     0.200
     5.735    16.900     0.200
     5.735    18.056     0.200
     5.828    19.650     0.200
     5.867    20.035     0.200
     6.003    19.336     0.200
     6.066    20.616     0.200
     6.110    19.840     0.200
     6.110    20.529     0.200
     6.219    21.034     0.200
     6.215    19.605     0.200
     6.215    19.976     0.200
     6.292    19.861     0.200
     6.381    20.998     0.200
     6.631    20.676     0.200
     6.921    20.986     0.200
     7.173    22.396     0.200
     7.205    20.986     0.200
     7.225    22.932     0.200
     7.277    22.251     0.200
     7.325    21.964     0.200
     7.478    22.964     0.200
     7.526    22.589     0.200
     7.702    23.297     0.200
     7.787    22.465     0.200
     7.823    23.159     0.200
     8.064    22.984     0.200
     8.197    24.891     0.200
     8.348    24.007     0.200
     8.352    23.995     0.200
     8.394    23.986     0.200
     8.232    25.565     0.200
     8.382    23.900     0.200
     8.480    24.475     0.200
     8.815    24.660     0.200
     8.843    24.501     0.200
     8.979    24.944     0.200
     9.257    25.321     0.200
     9.292    25.430     0.200
     9.305    28.232     0.200
     9.778    26.145     0.200
     9.628    26.996     0.200
     9.908    26.566     0.200
     9.779    29.852     0.200
     9.974    25.563     0.200
    12.490    27.975     0.200
    14.152    35.066     0.200
    14.165    35.110     0.200
    15.114    34.978     0.200
    16.092    39.506     0.200
    16.618    39.904     0.200
    17.234    38.771     0.200
    17.266    39.820     0.200
    17.848    37.995     0.200
     1.305     7.794     0.200
     1.330     7.919     0.200
     1.253     7.827     0.200
     1.301     8.363     0.200
     1.302     8.210     0.200
     1.323     8.365     0.200
     1.436     8.381     0.200
     1.336     8.538     0.200
     1.491     8.759     0.200
     1.434     9.245     0.200
     1.543     9.286     0.200
     1.468     8.905     0.200
     1.474     8.453     0.200
     1.607     9.446     0.200
     1.741     8.313     0.200
     1.994     9.217     0.200
     2.227    10.006     0.200
     2.298    10.468     0.200
     2.298    10.818     0.200
     2.430    12.502     0.200
     2.434    12.012     0.200
     2.621    10.599     0.200
     3.084    11.211     0.200
     3.468    12.959     0.200
     3.538    12.723     0.200
     3.637    12.995     0.200
     3.663    12.001     0.200
     3.540    13.952     0.200
     3.685    14.257     0.200
     4.058    13.786     0.200
     4.134    13.610     0.200
     4.146    13.590     0.200
     4.029    14.818     0.200
     4.029    13.887     0.200
     4.200    13.926     0.200
     4.257    14.078     0.200
     4.263    14.159     0.200
     4.324    14.410     0.200
     4.324    14.551     0.200
     4.172    14.743     0.200
     4.172    14.903     0.200
     4.254    15.315     0.200
     4.417    12.952     0.200
     4.417    14.608     0.200
     4.403    14.497     0.200
     4.436    14.578     0.200
     4.572    13.975     0.200
     4.583    15.144     0.200
     4.714    14.280     0.200
     4.819    14.801     0.200
     4.942    14.588     0.200
     5.040    12.860     0.200
     5.040    13.866     0.200
     5.040    13.755     0.200
     5.244    15.969     0.200
     5.284    16.617     0.200
     5.379    16.050     0.200
     5.433    17.167     0.200
     5.688    17.187     0.200
     5.764    17.694     0.200
     5.958    17.376     0.200
     5.978    17.684     0.200
     5.988    18.338     0.200
     6.125    17.542     0.200
     6.302    18.146     0.200
     6.304    18.739     0.200
     6.677    17.611     0.200
     6.611    19.638     0.200
     6.707    19.109     0.200
     6.784    19.357     0.200
     6.782    19.273     0.200
     6.970    17.220     0.200
     6.981    19.642     0.200
     7.077    19.370     0.200
     7.446    20.164     0.200
     7.664    20.591     0.200
     7.638    21.540     0.200
     7.723    21.059     0.200
     7.713    21.390     0.200
     7.740    19.479     0.200
     7.886    21.400     0.200
     7.961    22.830     0.200
     7.966    21.361     0.200
     8.026    21.787     0.200
     8.256    22.192     0.200
     8.253    22.377     0.200
     8.303    21.053     0.200
     8.338    22.559     0.200
     8.445    22.457     0.200
     8.568    22.436     0.200
     8.679    22.432     0.200
     8.881    23.643     0.200
     9.065    24.379     0.200
     9.103    23.087     0.200
     8.956    25.916     0.200
     9.308    21.979     0.200
    10.499    28.708     0.200
    10.499    27.679     0.200
    10.720    26.045     0.200
    11.940    25.847     0.200
    12.033    29.679     0.200
    12.162    28.997     0.200
    12.190    29.289     0.200
    12.432    29.318     0.200
    12.451    29.808     0.200
    12.560    30.732     0.200
    12.656    30.977     0.200
    13.897    34.138     0.200
    13.908    33.286     0.200
    14.512    34.500     0.200
    15.304    35.916     0.200
    15.496    34.981     0.200
    15.613    36.527     0.200
    15.964    36.067     0.200
    16.036    35.579     0.200
    16.640    37.190     0.200
    16.641    37.171     0.200
    16.672    35.974     0.200
    17.040    37.145     0.200
    17.153    35.832     0.200
    17.244    36.014     0.200
    18.256    37.788     0.200
    18.256    38.128     0.200
     1.172     7.572     0.200
     1.390     8.460     0.200
     1.400     8.130     0.200
     1.656     8.379     0.200
     2.614    10.065     0.200
     2.992    11.561     0.200
     3.511    13.671     0.200
     3.511    12.102     0.200
     3.641    11.949     0.200
     3.641    11.770     0.200
     3.654    12.590     0.200
     4.005    14.900     0.200
     4.005    13.300     0.200
     4.189    13.969     0.200
     4.313    14.436     0.200
     4.384    12.981     0.200
     4.384    13.362     0.200
     4.454    14.915     0.200
     4.722    15.492     0.200
     4.831    15.740     0.200
     5.000    14.113     0.200
     5.000    14.753     0.200
     5.155    16.384     0.200
     5.310    16.990     0.200
     5.310    16.773     0.200
     8.796    23.198     0.200
     8.932    24.603     0.200
     9.453    23.428     0.200
    10.471    27.441     0.200
    10.471    27.682     0.200
    11.593    29.053     0.200
    11.682    26.817     0.200
    11.682    27.419     0.200
    11.682    26.407     0.200
    11.854    25.957     0.200
    12.061    30.194     0.200
    14.050    34.784     0.200
    15.271    37.030     0.200
    15.421    34.435     0.200
    15.414    34.882     0.200
    15.452    34.767     0.200
    15.489    33.634     0.200
    15.489    35.152     0.200
    15.489    34.890     0.200
    15.547    35.061     0.200
    15.566    35.123     0.200
    15.583    34.505     0.200
    15.731    35.040     0.200
    15.840    35.497     0.200
    15.958    35.508     0.200
    16.143    36.755     0.200
    16.260    36.214     0.200
    16.525    37.079     0.200
    16.574    35.689     0.200
    16.668    36.264     0.200
    16.679    36.626     0.200
    16.724    36.551     0.200
    17.171    36.257     0.200
    18.177    37.038     0.200
    18.177    36.413     0.200
    20.442    37.048     0.200
     1.470     7.838     0.200
     1.532     9.345     0.200
     1.657     8.981     0.200
     1.711     9.270     0.200
     1.721     8.947     0.200
     1.890     7.977     0.200
     1.890     8.212     0.200
     2.381     9.586     0.200
     2.330    11.446     0.200
     2.548    10.254     0.200
     2.454    11.834     0.200
     2.691     9.066     0.200
     2.691     9.269     0.200
     2.792    12.758     0.200
     2.890    12.881     0.200
     3.237    10.722     0.200
     3.607    12.760     0.200
     3.531    14.069     0.200
     3.531    13.334     0.200
     3.531    13.569     0.200
     3.747    11.043     0.200
     3.679    13.649     0.200
     4.011    14.064     0.200
     4.011    13.759     0.200
     4.195    13.155     0.200
     4.108    14.706     0.200
     4.277    13.301     0.200
     4.158    14.777     0.200
     4.237    14.867     0.200
     4.391    13.355     0.200
     4.273    15.187     0.200
     4.399    13.115     0.200
     4.513    12.212     0.200
     4.513    12.650     0.200
     4.605    14.035     0.200
     4.705    13.877     0.200
     4.751    14.650     0.200
     4.827    14.188     0.200
     4.974    14.592     0.200
     4.936    16.381     0.200
     5.107    15.774     0.200
     5.144    13.569     0.200
     5.144    13.787     0.200
     5.144    14.303     0.200
     5.018    16.853     0.200
     5.076    16.909     0.200
     5.405    15.785     0.200
     5.425    15.640     0.200
     5.452    16.052     0.200
     5.511    15.510     0.200
     5.602    16.784     0.200
     6.121    17.108     0.200
     6.147    17.195     0.200
     6.152    18.027     0.200
     6.353    17.612     0.200
     6.257    19.391     0.200
     6.460    18.059     0.200
     6.472    18.474     0.200
     6.499    17.615     0.200
     6.433    19.254     0.200
     6.433    19.497     0.200
     6.800    17.430     0.200
     6.961    18.731     0.200
     6.949    18.710     0.200
     7.093    17.188     0.200
     7.134    17.460     0.200
     7.171    18.829     0.200
     7.613    20.212     0.200
     7.731    20.045     0.200
     7.762    20.542     0.200
     7.766    20.810     0.200
     7.802    20.935     0.200
     7.870    20.785     0.200
     8.113    21.864     0.200
     8.396    20.380     0.200
     8.495    22.132     0.200
     8.772    21.010     0.200
     8.737    22.779     0.200
     8.791    21.109     0.200
     8.847    22.290     0.200
     8.801    24.187     0.200
     9.001    20.729     0.200
     9.001    21.229     0.200
     8.895    24.723     0.200
     8.936    24.191     0.200
     8.936    24.066     0.200
     9.102    22.280     0.200
     9.200    21.835     0.200
     9.215    22.200     0.200
     9.217    23.963     0.200
     9.257    21.331     0.200
     9.343    23.949     0.200
     9.423    21.444     0.200
     9.422    22.399     0.200
     9.611    22.006     0.200
     9.611    22.654     0.200
     9.618    22.565     0.200
     9.784    22.992     0.200
     9.888    24.069     0.200
     9.925    22.872     0.200
     9.925    22.349     0.200
    10.024    23.155     0.200
    10.082    23.584     0.200
    10.074    24.227     0.200
    10.047    26.129     0.200
    10.311    23.446     0.200
    10.483    27.128     0.200
    10.483    26.535     0.200
    10.483    26.652     0.200
    10.483    27.269     0.200
    10.920    26.481     0.200
    11.037    27.647     0.200
    11.592    26.945     0.200
    11.736    26.895     0.200
    11.722    29.204     0.200
    11.784    27.151     0.200
    11.814    27.962     0.200
    11.918    32.699     0.200
    11.919    25.572     0.200
    11.919    25.189     0.200
    11.919    26.072     0.200
    12.086    25.030     0.200
    12.086    26.632     0.200
    12.168    28.465     0.200
    12.573    28.875     0.200
    12.993    31.048     0.200
    13.598    33.241     0.200
    13.947    31.112     0.200
    14.023    31.770     0.200
    14.494    33.426     0.200
    15.284    35.008     0.200
    15.615    34.991     0.200
    15.563    33.919     0.200
    15.563    36.451     0.200
    16.121    34.834     0.200
    16.431    35.280     0.200
    16.795    36.180     0.200
    18.961    38.595     0.200
    18.961    40.259     0.200
     0.987     6.525     0.200
     1.592     8.105     0.200
     1.623     9.265     0.200
     1.781     9.565     0.200
     1.781     9.932     0.200
     1.823     9.106     0.200
     1.998     9.013     0.200
     2.493     9.907     0.200
     2.371    10.972     0.200
     2.493    10.973     0.200
     2.563    11.319     0.200
     2.736     9.730     0.200
     2.736     8.512     0.200
     2.722    11.716     0.200
     2.820    11.826     0.200
     3.347    11.655     0.200
     3.641    12.168     0.200
     3.641    12.418     0.200
     3.544    13.411     0.200
     3.544    12.513     0.200
     3.705    12.672     0.200
     3.785    12.651     0.200
     3.802    11.596     0.200
     3.802    11.486     0.200
     3.647    12.757     0.200
     3.647    12.944     0.200
     3.693    13.769     0.200
     3.893    13.104     0.200
     4.017    13.886     0.200
     4.017    13.355     0.200
     4.167    14.156     0.200
     4.378    14.106     0.200
     4.435    14.216     0.200
     4.280    14.018     0.200
     4.495    13.817     0.200
     4.557    14.574     0.200
     4.576    12.763     0.200
     4.576    12.357     0.200
     4.731    15.177     0.200
     4.921    14.902     0.200
     4.879    16.250     0.200
     4.951    15.296     0.200
     4.968    15.261     0.200
     5.212    13.509     0.200
     5.198    15.727     0.200
     5.522    16.365     0.200
     5.602    16.209     0.200
     5.580    17.824     0.200
     6.056    18.101     0.200
     6.166    17.577     0.200
     6.279    18.818     0.200
     6.253    16.750     0.200
     6.458    18.103     0.200
     6.574    19.278     0.200
     6.597    18.473     0.200
     6.512    19.770     0.200
     6.662    18.407     0.200
     6.884    17.997     0.200
     7.070    20.077     0.200
     7.077    20.108     0.200
     7.217    18.193     0.200
     7.353    21.124     0.200
     7.942    20.003     0.200
     7.940    20.480     0.200
     7.929    21.829     0.200
     8.317    22.548     0.200
     8.526    21.763     0.200
     8.691    21.822     0.200
     8.856    22.239     0.200
     9.094    23.243     0.200
     8.936    23.782     0.200
     9.191    23.360     0.200
     9.289    22.564     0.200
     9.500    21.966     0.200
     9.513    23.990     0.200
     9.685    23.848     0.200
     9.685    23.372     0.200
     9.707    23.937     0.200
     9.872    24.555     0.200
    10.055    24.371     0.200
    10.244    24.208     0.200
    10.527    26.614     0.200
    10.488    28.274     0.200
    10.769    27.451     0.200
    10.997    27.395     0.200
    11.256    29.072     0.200
    11.496    27.986     0.200
    11.769    28.925     0.200
    11.870    28.231     0.200
    12.025    29.938     0.200
    12.188    26.175     0.200
    12.214    29.539     0.200
    12.228    29.101     0.200
    12.656    29.306     0.200
    13.134    29.865     0.200
    13.002    30.557     0.200
    13.659    31.455     0.200
    14.100    33.790     0.200
    14.309    33.551     0.200
    14.385    33.235     0.200
    14.659    35.304     0.200
    14.748    33.720     0.200
    15.022    35.055     0.200
    15.229    34.994     0.200
    15.593    33.387     0.200
    16.271    38.034     0.200
    16.391    36.455     0.200
    16.830    35.691     0.200
    16.838    37.018     0.200
    18.492    37.863     0.200
     1.851     9.363     0.200
     2.077    10.078     0.200
     2.801     9.284     0.200
     4.646    15.270     0.200
     5.284    15.490     0.200
     5.284    16.693     0.200
     8.016    24.120     0.200
     8.017    21.134     0.200
     8.932    23.263     0.200
     9.362    24.171     0.200
     9.574    23.103     0.200
     9.758    24.270     0.200
    10.022    26.158     0.200
    10.077    25.530     0.200
    10.553    26.343     0.200
    10.970    28.811     0.200
    11.104    27.898     0.200
    11.566    28.233     0.200
    11.847    30.169     0.200
    12.267    26.654     0.200
    12.284    29.873     0.200
    12.713    31.904     0.200
    12.869    33.176     0.200
    13.088    32.581     0.200
    13.584    32.656     0.200
    13.732    34.395     0.200
    13.938    33.484     0.200
    14.370    33.802     0.200
    15.086    36.787     0.200
    15.748    37.218     0.200
    16.453    40.637     0.200
    16.890    40.789     0.200
    16.949    39.645     0.200
     1.628     7.644     0.200
     1.646     9.638     0.200
     1.848     8.851     0.200
     2.033     8.156     0.200
     2.377    10.630     0.200
     2.499    10.973     0.200
     2.756     9.423     0.200
     2.756     8.829     0.200
     2.569    10.866     0.200
     2.728    11.324     0.200
     2.822    11.719     0.200
     2.922    12.131     0.200
     3.542    12.514     0.200
     3.824    11.958     0.200
     3.824    11.028     0.200
     3.691    12.506     0.200
     4.013    12.426     0.200
     4.410    13.790     0.200
     4.526    13.099     0.200
     4.600    12.157     0.200
     4.722    14.300     0.200
     5.119    14.834     0.200
     5.237    13.255     0.200
     5.237    13.763     0.200
     5.632    16.035     0.200
     5.980    17.934     0.200
     6.245    16.929     0.200
     6.629    18.299     0.200
     6.609    18.776     0.200
     6.633    19.078     0.200
     6.913    18.670     0.200
     7.003    19.940     0.200
     7.092    18.685     0.200
     7.106    19.367     0.200
     7.207    17.559     0.200
     7.922    21.084     0.200
     7.970    20.339     0.200
     7.970    20.588     0.200
     7.984    22.180     0.200
     8.195    21.805     0.200
     8.245    21.653     0.200
     8.354    22.241     0.200
     8.525    21.343     0.200
     8.556    21.317     0.200
     8.717    21.074     0.200
     8.878    21.874     0.200
     8.885    21.678     0.200
     8.930    23.297     0.200
     9.221    23.107     0.200
     9.204    24.118     0.200
     9.324    22.892     0.200
     9.527    22.870     0.200
     9.711    24.263     0.200
     9.711    22.732     0.200
     9.902    24.350     0.200
    10.192    24.156     0.200
    10.328    25.360     0.200
    10.507    24.513     0.200
    10.778    27.035     0.200
    10.909    26.322     0.200
    11.023    26.303     0.200
    11.204    26.632     0.200
    11.370    27.049     0.200
    11.520    27.199     0.200
    11.676    28.289     0.200
    11.801    28.638     0.200
    11.893    28.644     0.200
    11.962    28.735     0.200
    12.049    27.805     0.200
    12.240    29.142     0.200
    12.238    30.134     0.200
    12.221    26.356     0.200
    12.255    29.542     0.200
    12.488    29.141     0.200
    12.666    30.648     0.200
    12.823    31.228     0.200
    13.043    30.312     0.200
    12.998    29.686     0.200
    13.541    29.644     0.200
    13.685    32.208     0.200
    13.892    32.394     0.200
    14.127    32.884     0.200
    14.135    32.251     0.200
    14.326    33.221     0.200
    14.474    32.780     0.200
    14.680    34.907     0.200
    15.041    34.522     0.200
    15.588    35.401     0.200
    16.862    37.457     0.200
    16.933    37.177     0.200
    18.523    37.645     0.200
     2.128     8.571     0.200
     2.367    11.116     0.200
     2.488    11.219     0.200
     2.555    11.587     0.200
     2.716    11.577     0.200
     2.801    11.197     0.200
     2.831     9.069     0.200
     3.508    13.082     0.200
     3.613    13.294     0.200
     3.659    13.507     0.200
     3.903    11.841     0.200
     3.974    13.525     0.200
     4.200    13.965     0.200
     4.682    13.102     0.200
     5.322    14.675     0.200
     6.199    18.779     0.200
     6.723    18.468     0.200
     8.887    23.908     0.200
     8.975    21.682     0.200
     9.312    22.547     0.200
     9.401    22.634     0.200
     9.417    23.655     0.200
     9.615    22.021     0.200
     9.636    23.366     0.200
     9.796    23.574     0.200
     9.993    24.058     0.200
    10.057    25.348     0.200
    10.118    23.248     0.200
    10.164    24.241     0.200
    10.281    25.202     0.200
    10.409    25.250     0.200
    10.497    24.862     0.200
    10.590    25.779     0.200
    10.991    26.142     0.200
    11.109    26.239     0.200
    11.140    26.375     0.200
    11.602    27.377     0.200
    11.757    28.729     0.200
    11.894    28.228     0.200
    11.934    28.573     0.200
    11.975    29.756     0.200
    12.040    29.717     0.200
    12.142    29.129     0.200
    12.316    26.273     0.200
    12.319    29.708     0.200
    12.581    28.639     0.200
    12.612    28.525     0.200
    12.756    30.260     0.200
    12.774    30.409     0.200
    12.901    31.901     0.200
    12.960    30.463     0.200
    13.118    31.517     0.200
    13.607    30.357     0.200
    13.771    31.928     0.200
    14.395    33.074     0.200
    14.463    32.375     0.200
    14.541    33.425     0.200
    14.574    33.840     0.200
    14.758    34.384     0.200
    15.572    33.345     0.200
    15.572    34.533     0.200
    15.663    35.869     0.200
    15.731    35.415     0.200
    15.773    36.887     0.200
    16.914    35.971     0.200
    17.513    37.827     0.200
     1.104     6.810     0.200
     1.104     6.404     0.200
     1.715     8.889     0.200
     1.715     9.405     0.200
     1.920     9.273     0.200
     1.917     8.403     0.200
     2.112     8.116     0.200
     2.405    10.600     0.200
     2.593    10.605     0.200
     2.754    10.941     0.200
     2.798     9.751     0.200
     2.798     8.462     0.200
     2.840    10.987     0.200
     2.840    11.120     0.200
     3.462    12.872     0.200
     3.547    12.499     0.200
     3.547    11.945     0.200
     3.698    12.042     0.200
     3.722    12.933     0.200
     3.871    11.922     0.200
     4.006    13.161     0.200
     4.014    12.559     0.200
     4.485    14.354     0.200
     4.539    14.445     0.200
     4.598    13.707     0.200
     4.651    13.315     0.200
     4.651    12.385     0.200
     4.661    14.469     0.200
     4.749    14.798     0.200
     4.807    15.258     0.200
     5.007    15.322     0.200
     5.022    15.036     0.200
     5.038    15.332     0.200
     5.056    15.121     0.200
     5.068    15.244     0.200
     5.068    15.624     0.200
     5.292    13.859     0.200
     5.292    14.538     0.200
     5.292    14.156     0.200
     5.292    14.382     0.200
     5.641    16.473     0.200
     5.701    15.692     0.200
     6.059    17.586     0.200
     6.092    17.090     0.200
     6.238    17.207     0.200
     6.568    18.433     0.200
     6.701    18.060     0.200
     6.702    18.684     0.200
     6.721    19.459     0.200
     6.766    18.654     0.200
     6.934    19.029     0.200
     6.977    18.236     0.200
     7.203    19.378     0.200
     7.241    19.595     0.200
     7.309    18.402     0.200
     7.333    20.439     0.200
     7.397    20.215     0.200
     7.971    20.934     0.200
     7.977    21.205     0.200
     7.996    21.138     0.200
     8.036    20.582     0.200
     8.069    21.353     0.200
     8.191    21.000     0.200
     8.319    21.256     0.200
     8.334    22.950     0.200
     8.624    21.730     0.200
     8.671    23.757     0.200
     8.774    21.403     0.200
     8.795    22.951     0.200
     8.845    22.944     0.200
     8.905    23.191     0.200
     8.929    21.533     0.200
     8.926    23.233     0.200
     8.926    22.373     0.200
     8.949    20.861     0.200
     9.097    23.037     0.200
     9.193    23.806     0.200
     9.193    22.713     0.200
     9.288    22.318     0.200
     9.393    22.808     0.200
     9.587    23.482     0.200
     9.612    22.776     0.200
     9.767    23.312     0.200
    10.025    24.550     0.200
    10.480    26.791     0.200
    10.480    24.893     0.200
    10.480    25.893     0.200
    10.682    24.932     0.200
    10.762    25.513     0.200
    11.048    26.091     0.200
    11.080    26.173     0.200
    11.252    27.043     0.200
    11.381    27.479     0.200
    11.872    29.503     0.200
    11.964    29.969     0.200
    12.008    29.301     0.200
    12.053    29.314     0.200
    12.283    29.061     0.200
    12.297    26.445     0.200
    12.747    29.820     0.200
    12.999    29.638     0.200
    13.537    32.887     0.200
    13.942    32.550     0.200
    14.426    32.267     0.200
    14.576    33.797     0.200
    14.725    34.880     0.200
    14.839    33.316     0.200
    15.079    35.443     0.200
    15.326    34.798     0.200
    15.611    33.462     0.200
    15.611    33.149     0.200
    15.698    36.680     0.200
    15.827    35.302     0.200
    15.920    36.214     0.200
    16.374    35.898     0.200
    16.877    38.064     0.200
    16.973    36.478     0.200
    17.491    36.147     0.200
     0.997     7.095     0.200
     1.613     8.524     0.200
     1.613     9.032     0.200
     1.623    10.126     0.200
     1.820     9.097     0.200
     1.820     9.956     0.200
     1.824    11.256     0.200
     2.022     8.965     0.200
     2.359    12.090     0.200
     2.551    13.000     0.200
     2.760    10.603     0.200
     2.805    12.628     0.200
     2.805    13.026     0.200
     2.905    12.901     0.200
     2.905    13.190     0.200
     3.676    13.260     0.200
     3.826    12.010     0.200
     3.809    13.572     0.200
     3.917    13.530     0.200
     4.225    15.259     0.200
     4.316    14.488     0.200
     4.402    14.511     0.200
     4.459    14.774     0.200
     4.509    14.499     0.200
     4.520    13.859     0.200
     4.600    13.431     0.200
     4.582    15.014     0.200
     4.582    15.311     0.200
     4.671    15.148     0.200
     4.671    15.531     0.200
     4.750    15.613     0.200
     4.824    14.763     0.200
     4.895    15.678     0.200
     4.945    15.427     0.200
     5.627    16.562     0.200
     5.970    18.552     0.200
     6.597    19.129     0.200
     6.621    18.790     0.200
     6.616    18.974     0.200
     6.909    19.254     0.200
     7.085    18.461     0.200
     7.091    20.383     0.200
     7.203    18.136     0.200
     7.242    18.763     0.200
     7.914    21.412     0.200
     7.967    20.862     0.200
     7.965    22.691     0.200
     7.970    22.761     0.200
     8.337    22.617     0.200
     8.550    23.592     0.200
     8.716    22.377     0.200
     8.881    23.418     0.200
     9.216    23.930     0.200
     9.313    23.337     0.200
     9.318    24.212     0.200
     9.350    25.338     0.200
     9.525    22.794     0.200
     9.538    24.217     0.200
     9.897    23.922     0.200
    10.079    25.639     0.200
    10.409    25.328     0.200
    10.507    25.862     0.200
    10.469    28.511     0.200
    10.771    27.708     0.200
    10.923    27.726     0.200
    10.988    27.973     0.200
    11.057    26.929     0.200
    11.205    27.302     0.200
    11.520    28.115     0.200
    11.677    29.633     0.200
    11.842    29.191     0.200
    11.964    30.295     0.200
    12.239    30.871     0.200
    12.213    26.588     0.200
    12.213    28.354     0.200
    12.663    30.352     0.200
    13.047    31.370     0.200
    13.684    33.182     0.200
    14.332    33.659     0.200
    14.407    34.079     0.200
    14.683    36.071     0.200
    15.045    35.977     0.200
    15.535    37.056     0.200
    15.592    38.358     0.200
    15.709    37.700     0.200
    16.863    38.405     0.200
    16.897    38.627     0.200
    16.921    37.949     0.200
     1.546     9.064     0.200
     1.744     8.580     0.200
     2.311    11.792     0.200
     2.506    11.924     0.200
     2.747     8.568     0.200
     2.662    12.624     0.200
     2.767    12.142     0.200
     3.498    12.258     0.200
     3.601    13.565     0.200
     3.647    11.406     0.200
     3.975    13.010     0.200
     4.124    13.874     0.200
     4.201    13.953     0.200
     4.468    13.605     0.200
     4.575    12.419     0.200
     5.207    13.374     0.200
     5.069    15.483     0.200
     6.131    17.576     0.200
     6.217    17.500     0.200
     6.537    18.332     0.200
     8.477    22.695     0.200
     9.852    24.276     0.200
    11.461    25.806     0.200
    12.155    28.153     0.200
    12.422    29.695     0.200
    14.407    32.482     0.200
    14.786    37.174     0.200
    15.100    33.826     0.200
    15.531    36.678     0.200
     1.742     8.213     0.200
     1.843     9.442     0.200
     1.835     9.550     0.200
     2.280    11.249     0.200
     2.399    11.748     0.200
     2.467    11.707     0.200
     2.628    12.137     0.200
     2.711    12.142     0.200
     3.417    13.363     0.200
     3.522    13.535     0.200
     3.540    13.723     0.200
     3.568    12.889     0.200
     3.591    13.874     0.200
     3.883    13.900     0.200
     3.883    13.712     0.200
     4.863    16.674     0.200
     4.795    16.027     0.200
     4.877    16.330     0.200
     4.938    16.766     0.200
     5.379    16.050     0.200
     5.690    17.113     0.200
     5.858    18.234     0.200
     6.020    18.424     0.200
     6.108    18.724     0.200
     6.394    18.728     0.200
     6.471    19.505     0.200
     6.471    19.778     0.200
     7.064    17.665     0.200
     7.220    19.865     0.200
     7.402    19.457     0.200
     8.064    20.397     0.200
     8.020    22.679     0.200
     8.119    20.861     0.200
     8.386    21.193     0.200
     8.704    21.245     0.200
     8.652    23.480     0.200
     8.772    22.674     0.200
     8.664    23.710     0.200
     8.714    23.897     0.200
     8.758    24.164     0.200
     8.774    24.263     0.200
     8.795    24.373     0.200
     8.795    22.888     0.200
     8.991    23.479     0.200
     9.272    22.214     0.200
     9.272    21.714     0.200
     9.317    23.629     0.200
     9.471    22.723     0.200
     9.552    25.690     0.200
     9.597    24.893     0.200
     9.886    23.202     0.200
     9.914    26.401     0.200
    10.349    28.035     0.200
    10.349    26.035     0.200
    10.349    27.223     0.200
    10.628    27.683     0.200
    10.632    26.695     0.200
    10.891    27.992     0.200
    10.990    26.062     0.200
    12.087    29.106     0.200
    12.196    28.884     0.200
    12.196    27.282     0.200
    12.362    25.351     0.200
    12.362    26.546     0.200
    12.836    28.660     0.200
    13.307    29.019     0.200
    14.133    31.584     0.200
    15.053    33.757     0.200
    15.448    34.038     0.200
    15.481    34.242     0.200
    16.384    36.051     0.200
    16.998    35.799     0.200
    17.017    37.586     0.200
    18.106    35.449     0.200
     1.661    10.113     0.200
     2.357    11.609     0.200
     2.477    11.856     0.200
     2.545    11.617     0.200
     2.706    12.081     0.200
     2.793    12.447     0.200
     2.893    12.744     0.200
     3.503    12.375     0.200
     3.608    13.550     0.200
     3.654    13.147     0.200
     3.893    12.158     0.200
     3.971    13.465     0.200
     4.070    14.163     0.200
     4.196    14.576     0.200
     4.671    13.436     0.200
     4.966    16.702     0.200
     5.005    16.240     0.200
     5.310    13.894     0.200
     5.310    14.113     0.200
     6.110    18.375     0.200
     6.705    19.189     0.200
     8.270    23.575     0.200
     8.632    22.782     0.200
     8.790    22.392     0.200
     8.949    22.202     0.200
     8.960    22.223     0.200
     8.885    23.651     0.200
     9.388    22.551     0.200
     9.978    25.405     0.200
    10.046    25.444     0.200
    10.398    26.736     0.200
    10.438    28.365     0.200
    10.720    27.432     0.200
    12.031    29.758     0.200
    12.308    29.778     0.200
    12.297    25.426     0.200
    12.759    29.868     0.200
    12.892    31.339     0.200
    13.110    31.369     0.200
    12.956    30.589     0.200
    13.602    30.985     0.200
    14.042    30.492     0.200
    14.389    34.339     0.200
    14.459    33.235     0.200
    14.536    33.706     0.200
    14.749    35.756     0.200
    15.106    35.046     0.200
    15.294    33.092     0.200
    15.655    38.066     0.200
    16.226    35.717     0.200
    18.600    38.786     0.200
    18.600    39.404     0.200
     0.941     6.575     0.200
     1.560     7.085     0.200
     1.768     7.693     0.200
     1.768     9.068     0.200
     1.776     8.019     0.200
     1.976     7.949     0.200
     2.459    11.580     0.200
     2.529     9.661     0.200
     2.742     7.630     0.200
     2.687    10.301     0.200
     3.324    11.791     0.200
     3.517    12.742     0.200
     3.621    12.676     0.200
     3.688    13.201     0.200
     3.666    12.620     0.200
     3.765    12.519     0.200
     3.871    13.023     0.200
     3.992    12.292     0.200
     4.218    13.854     0.200
     4.275    13.406     0.200
     4.359    13.692     0.200
     4.418    14.001     0.200
     4.479    13.735     0.200
     4.575    13.320     0.200
     4.632    13.401     0.200
     4.632    14.331     0.200
     4.935    13.781     0.200
     4.935    14.726     0.200
     5.209    13.936     0.200
     5.494    16.287     0.200
     5.589    15.687     0.200
     5.692    16.332     0.200
     6.548    19.343     0.200
     6.580    16.715     0.200
     6.946    18.300     0.200
     7.043    17.027     0.200
    10.957    26.301     0.200
    13.536    30.288     0.200
    15.573    34.359     0.200
    16.255    37.134     0.200
    16.840    35.398     0.200
    16.857    35.643     0.200
    16.872    35.151     0.200
     1.803     9.052     0.200
     1.910     9.965     0.200
     1.989    10.721     0.200
     2.217     9.720     0.200
     2.451    12.197     0.200
     2.517    12.014     0.200
     2.517    11.538     0.200
     2.679    12.243     0.200
     2.919    11.180     0.200
     2.755    12.247     0.200
     3.452    12.911     0.200
     3.452    14.521     0.200
     3.558    14.575     0.200
     3.576    14.536     0.200
     3.604    12.953     0.200
     3.627    14.882     0.200
     3.914    13.657     0.200
     3.914    14.930     0.200
     4.014    14.535     0.200
     4.014    14.660     0.200
     4.068    14.929     0.200
     4.176    15.644     0.200
     4.900    16.847     0.200
     4.822    16.756     0.200
     4.903    16.591     0.200
     4.935    16.832     0.200
     4.965    17.018     0.200
     4.965    17.158     0.200
     4.999    16.502     0.200
     5.440    18.518     0.200
     5.749    17.305     0.200
     5.817    17.060     0.200
     6.206    17.899     0.200
     6.131    18.569     0.200
     6.536    19.855     0.200
     6.815    19.097     0.200
     7.045    19.630     0.200
     7.095    19.103     0.200
     7.188    20.387     0.200
     7.278    20.237     0.200
     7.315    19.411     0.200
     7.411    20.111     0.200
     7.445    20.665     0.200
     7.510    20.837     0.200
     8.051    23.073     0.200
     8.087    22.355     0.200
     8.524    24.467     0.200
     8.710    21.858     0.200
     8.740    22.054     0.200
     8.727    24.667     0.200
     8.691    24.852     0.200
     8.741    24.295     0.200
     8.785    24.993     0.200
     8.801    24.656     0.200
     8.821    24.657     0.200
     8.821    24.267     0.200
     9.309    23.371     0.200
     9.309    22.871     0.200
     9.380    25.853     0.200
     9.509    22.508     0.200
     9.545    25.772     0.200
     9.667    26.099     0.200
     9.888    25.011     0.200
     9.942    26.505     0.200
    10.377    28.207     0.200
    10.377    27.707     0.200
    10.377    27.895     0.200
    12.082    30.201     0.200
    12.243    29.823     0.200
    12.243    29.128     0.200
    12.243    31.152     0.200
    12.404    29.349     0.200
    12.407    27.517     0.200
    12.407    26.993     0.200
    12.687    31.400     0.200
    14.125    34.571     0.200
    14.528    32.085     0.200
    14.695    34.418     0.200
    14.846    34.267     0.200
    14.959    34.043     0.200
    15.431    38.220     0.200
    15.431    35.314     0.200
    15.522    34.674     0.200
    15.522    37.456     0.200
    15.522    36.159     0.200
    16.038    35.470     0.200
    16.996    37.833     0.200
    16.996    37.661     0.200
    17.066    36.009     0.200
    17.728    37.618     0.200
    18.144    37.411     0.200
     1.017     7.597     0.200
     1.017     6.995     0.200
     1.644     8.529     0.200
     1.627    10.378     0.200
     1.852     9.627     0.200
     1.833     9.036     0.200
     2.347    12.088     0.200
     2.617    11.368     0.200
     2.469    12.716     0.200
     2.791    10.899     0.200
     2.791     9.359     0.200
     2.538    12.308     0.200
     2.697    12.699     0.200
     2.790    12.911     0.200
     3.507    13.428     0.200
     3.978    14.902     0.200
     4.494    14.981     0.200
     4.554    14.167     0.200
     4.633    13.752     0.200
     5.270    15.411     0.200
     6.123    19.690     0.200
     6.316    18.945     0.200
     6.656    18.794     0.200
     6.943    18.394     0.200
     7.999    21.993     0.200
     7.965    23.039     0.200
     8.585    23.323     0.200
     8.916    23.589     0.200
     9.250    24.271     0.200
     9.347    23.734     0.200
     9.559    22.954     0.200
     9.743    24.043     0.200
     9.932    25.161     0.200
    10.113    25.377     0.200
    10.223    26.029     0.200
    10.540    25.978     0.200
    10.729    29.477     0.200
    11.079    28.180     0.200
    11.314    27.720     0.200
    11.278    28.802     0.200
    11.553    28.075     0.200
    11.710    29.457     0.200
    11.876    29.231     0.200
    12.271    30.624     0.200
    12.697    30.461     0.200
    13.078    31.601     0.200
    13.576    32.166     0.200
    14.020    34.352     0.200
    14.361    33.628     0.200
    14.715    36.349     0.200
    14.798    34.077     0.200
    14.892    38.663     0.200
    15.569    35.376     0.200
    15.739    38.548     0.200
    16.330    38.923     0.200
     1.125     6.950     0.200
     1.659     9.326     0.200
     1.824     9.232     0.200
     1.930     9.466     0.200
     1.880    10.423     0.200
     2.223     8.685     0.200
     2.295    10.947     0.200
     2.479    11.644     0.200
     2.642    12.147     0.200
     2.944     8.731     0.200
     4.016    11.964     0.200
     4.663    14.931     0.200
     4.723    14.461     0.200
     4.794    13.474     0.200
     4.794    13.294     0.200
     4.899    15.065     0.200
     4.923    15.959     0.200
     5.027    15.615     0.200
     5.433    14.335     0.200
     5.433    14.100     0.200
     5.830    16.455     0.200
     6.825    18.721     0.200
     6.890    19.076     0.200
     7.111    19.452     0.200
     7.288    20.035     0.200
     7.279    20.604     0.200
     7.405    18.106     0.200
     7.455    20.740     0.200
     7.520    20.155     0.200
     8.168    21.457     0.200
     8.168    21.480     0.200
     8.439    23.234     0.200
     8.754    23.228     0.200
     8.914    22.441     0.200
     9.083    22.686     0.200
     9.322    23.941     0.200
     9.419    23.890     0.200
     9.512    23.951     0.200
     9.521    24.620     0.200
     9.725    22.713     0.200
     9.741    24.338     0.200
     9.907    23.904     0.200
     9.907    24.224     0.200
    10.100    25.727     0.200
    10.169    25.890     0.200
    10.390    25.954     0.200
    10.522    26.518     0.200
    10.702    25.636     0.200
    11.103    26.294     0.200
    11.252    27.555     0.200
    11.397    27.530     0.200
    11.511    27.884     0.200
    11.714    28.569     0.200
    11.869    29.519     0.200
    11.997    29.522     0.200
    12.153    29.629     0.200
    12.431    30.444     0.200
    12.415    26.286     0.200
    12.415    26.661     0.200
    12.439    28.790     0.200
    12.685    28.743     0.200
    12.864    29.687     0.200
    12.882    30.532     0.200
    12.987    32.073     0.200
    13.230    31.688     0.200
    13.718    30.671     0.200
    14.507    33.615     0.200
    14.573    33.301     0.200
    14.539    32.609     0.200
    14.652    34.337     0.200
    14.687    33.693     0.200
    14.723    34.405     0.200
    14.871    35.264     0.200
    14.967    34.419     0.200
    15.049    35.285     0.200
    15.226    35.820     0.200
    15.736    35.493     0.200
    15.776    36.805     0.200
    16.053    36.614     0.200
    16.343    36.372     0.200
    16.437    35.194     0.200
    16.499    36.241     0.200
    17.057    37.796     0.200
    17.081    35.436     0.200
    17.100    38.175     0.200
    17.096    38.195     0.200
    17.118    36.490     0.200
     1.727     9.838     0.200
     1.886     9.812     0.200
     1.940     9.560     0.200
     2.398    11.676     0.200
     2.585    11.719     0.200
     2.758    11.867     0.200
     2.840    10.000     0.200
     2.840     9.562     0.200
     2.746    12.169     0.200
     2.827    12.387     0.200
     3.528    13.780     0.200
     3.528    13.327     0.200
     3.634    13.760     0.200
     3.652    14.091     0.200
     3.680    14.301     0.200
     3.915    12.761     0.200
     3.915    12.261     0.200
     3.991    14.476     0.200
     3.991    13.234     0.200
     4.092    14.389     0.200
     4.217    14.887     0.200
     4.590    15.212     0.200
     4.649    15.475     0.200
     4.697    14.033     0.200
     4.697    13.791     0.200
     4.858    16.372     0.200
     4.904    16.304     0.200
     5.074    16.720     0.200
     4.982    16.521     0.200
     5.048    16.554     0.200
     5.044    16.996     0.200
     5.339    14.862     0.200
     5.339    14.549     0.200
     5.752    17.177     0.200
     6.111    17.971     0.200
     6.123    18.558     0.200
     6.588    22.266     0.200
     6.754    19.569     0.200
     6.753    19.373     0.200
     6.770    20.367     0.200
     7.027    18.850     0.200
     7.217    19.758     0.200
     7.321    18.552     0.200
     7.358    19.471     0.200
     7.385    21.321     0.200
     7.449    21.199     0.200
     8.048    22.254     0.200
     8.082    21.776     0.200
     8.087    21.650     0.200
     8.091    21.955     0.200
     8.371    23.730     0.200
     8.675    23.911     0.200
     8.822    23.149     0.200
     8.999    23.343     0.200
     8.900    24.983     0.200
     8.900    24.272     0.200
     9.037    24.000     0.200
     9.338    23.815     0.200
     9.420    23.786     0.200
     9.444    24.597     0.200
     9.475    23.142     0.200
     9.635    23.931     0.200
     9.662    24.551     0.200
     9.815    24.707     0.200
    10.019    25.651     0.200
    10.071    25.718     0.200
    10.139    25.175     0.200
    10.456    28.936     0.200
    10.456    28.795     0.200
    10.605    26.370     0.200
    11.128    27.857     0.200
    11.298    27.728     0.200
    11.617    28.599     0.200
    11.956    29.206     0.200
    12.052    29.966     0.200
    12.325    30.413     0.200
    12.348    27.942     0.200
    12.348    28.645     0.200
    12.643    28.653     0.200
    13.126    31.742     0.200
    13.608    31.426     0.200
    13.987    33.579     0.200
    14.234    33.804     0.200
    14.543    33.157     0.200
    14.588    33.830     0.200
    14.614    34.505     0.200
    14.832    35.327     0.200
    14.891    35.899     0.200
    14.890    34.308     0.200
    15.120    35.376     0.200
    15.376    35.873     0.200
    15.671    36.584     0.200
    15.777    36.736     0.200
    15.878    34.831     0.200
    15.970    35.686     0.200
    16.425    37.495     0.200
    16.500    36.934     0.200
    16.916    37.990     0.200
    16.960    38.117     0.200
    16.998    36.699     0.200
    17.024    38.452     0.200
    17.066    37.593     0.200
    17.542    36.673     0.200
     1.456     8.707     0.200
     1.564     9.306     0.200
     1.544     9.666     0.200
     1.645     9.488     0.200
     1.730     9.384     0.200
     1.872     8.252     0.200
     2.364    10.263     0.200
     2.350    11.353     0.200
     2.667     9.947     0.200
     2.667     9.119     0.200
     2.546    11.276     0.200
     2.701    12.000     0.200
     2.814    12.330     0.200
     3.220    11.740     0.200
     3.518    12.438     0.200
     3.663    12.778     0.200
     3.553    14.206     0.200
     3.553    13.143     0.200
     3.724    12.014     0.200
     3.724    11.569     0.200
     3.768    13.106     0.200
     3.655    13.766     0.200
     3.701    13.475     0.200
     4.034    14.696     0.200
     4.034    12.743     0.200
     4.130    14.831     0.200
     4.317    14.366     0.200
     4.379    14.259     0.200
     4.260    15.398     0.200
     4.489    13.180     0.200
     4.489    12.852     0.200
     4.532    14.655     0.200
     4.552    15.056     0.200
     4.685    13.970     0.200
     4.806    14.733     0.200
     4.833    14.977     0.200
     4.854    14.768     0.200
     4.956    16.503     0.200
     5.120    14.510     0.200
     5.120    13.814     0.200
     5.093    16.756     0.200
     5.407    15.959     0.200
     5.490    16.919     0.200
     5.446    16.776     0.200
     5.821    17.837     0.200
     5.876    17.055     0.200
     5.920    18.182     0.200
     6.106    18.155     0.200
     6.444    17.866     0.200
     6.479    17.708     0.200
     6.481    18.446     0.200
     6.544    18.403     0.200
     6.447    20.433     0.200
     6.778    18.067     0.200
     6.842    20.044     0.200
     6.941    19.055     0.200
     6.935    19.159     0.200
     6.979    19.481     0.200
     7.014    19.643     0.200
     7.108    19.571     0.200
     7.174    19.335     0.200
     7.221    20.149     0.200
     7.601    20.512     0.200
     7.830    20.785     0.200
     7.838    19.698     0.200
     7.814    20.894     0.200
     7.798    21.555     0.200
     7.853    21.098     0.200
     7.988    20.876     0.200
     8.029    22.127     0.200
     8.181    22.138     0.200
     8.376    20.974     0.200
     8.414    21.243     0.200
     8.478    22.805     0.200
     8.751    20.421     0.200
     8.980    21.448     0.200
     9.081    22.528     0.200
     8.959    25.228     0.200
     9.200    25.772     0.200
     9.334    25.137     0.200
     9.401    23.073     0.200
     9.589    22.974     0.200
     9.685    25.248     0.200
     9.763    23.147     0.200
     9.903    23.438     0.200
     9.963    23.785     0.200
    10.022    26.261     0.200
    10.119    26.236     0.200
    10.288    24.836     0.200
    10.393    25.293     0.200
    10.506    29.768     0.200
    10.865    25.994     0.200
    10.787    27.722     0.200
    11.090    26.650     0.200
    11.172    28.017     0.200
    11.782    27.938     0.200
    11.799    29.368     0.200
    12.067    26.542     0.200
    12.067    27.277     0.200
    12.144    30.844     0.200
    12.318    30.132     0.200
    12.368    27.762     0.200
    12.551    28.240     0.200
    13.015    31.394     0.200
    13.564    31.631     0.200
    13.781    31.938     0.200
    14.001    32.556     0.200
    14.248    34.073     0.200
    14.470    35.104     0.200
    14.570    32.005     0.200
    14.626    32.678     0.200
    14.758    33.522     0.200
    14.953    36.378     0.200
    15.118    35.406     0.200
    15.494    37.460     0.200
    15.622    37.257     0.200
    16.324    37.778     0.200
    16.771    37.436     0.200
    17.165    36.996     0.200
     0.990     7.182     0.200
     1.784     8.787     0.200
     2.078     8.853     0.200
     2.471    11.190     0.200
     2.631    11.117     0.200
     2.723    11.602     0.200
     2.845     8.511     0.200
     3.441    12.286     0.200
     3.591    14.809     0.200
     3.913    14.144     0.200
     4.749    15.169     0.200
     4.775    15.939     0.200
     4.907    16.078     0.200
     5.040    15.747     0.200
     5.316    14.362     0.200
     6.026    18.120     0.200
     6.108    18.311     0.200
     6.311    18.730     0.200
     6.646    19.797     0.200
     6.647    19.559     0.200
     7.130    20.031     0.200
     7.422    19.903     0.200
     7.976    22.088     0.200
     8.010    21.763     0.200
     8.231    23.289     0.200
     8.369    23.276     0.200
     8.582    22.627     0.200
     8.904    23.489     0.200
    15.922    36.433     0.200
    16.361    34.385     0.200
    16.443    35.559     0.200
    16.950    36.469     0.200
    19.058    39.039     0.200
     1.567     9.073     0.200
     1.621     9.736     0.200
     1.756     9.496     0.200
     1.811    10.080     0.200
     1.817    10.408     0.200
     1.972     9.457     0.200
     2.234     9.876     0.200
     2.381    11.399     0.200
     2.467    10.465     0.200
     2.574    11.205     0.200
     2.712     9.995     0.200
     2.712     8.956     0.200
     2.832    11.946     0.200
     3.321    11.301     0.200
     3.559    13.023     0.200
     3.559    12.781     0.200
     3.614    12.357     0.200
     3.678    13.542     0.200
     3.662    13.332     0.200
     3.679    13.523     0.200
     3.708    12.782     0.200
     3.777    12.066     0.200
     3.758    12.473     0.200
     3.733    13.831     0.200
     4.034    13.577     0.200
     4.034    12.998     0.200
     4.131    14.060     0.200
     4.264    13.699     0.200
     4.259    14.240     0.200
     4.296    14.327     0.200
     4.351    14.187     0.200
     4.408    14.515     0.200
     4.468    14.101     0.200
     4.530    14.959     0.200
     4.550    13.148     0.200
     4.550    13.452     0.200
     4.661    14.999     0.200
     4.858    15.880     0.200
     4.894    15.100     0.200
     4.924    15.338     0.200
     4.941    15.264     0.200
     4.953    15.828     0.200
     5.035    16.051     0.200
     5.058    15.967     0.200
     5.095    16.475     0.200
     5.186    14.898     0.200
     5.186    14.390     0.200
     5.203    16.850     0.200
     5.504    16.264     0.200
     5.496    16.635     0.200
     5.575    16.391     0.200
     5.560    17.693     0.200
     5.707    17.982     0.200
     5.920    16.859     0.200
     5.963    17.252     0.200
     6.032    17.804     0.200
     6.252    18.269     0.200
     6.261    19.568     0.200
     6.271    17.928     0.200
     6.431    18.776     0.200
     6.513    19.639     0.200
     6.513    19.889     0.200
     6.548    18.646     0.200
     6.570    18.101     0.200
     6.571    18.415     0.200
     6.573    19.922     0.200
     6.635    18.543     0.200
     6.805    19.286     0.200
     6.857    17.848     0.200
     6.942    19.679     0.200
     7.033    19.084     0.200
     7.071    19.189     0.200
     7.107    19.445     0.200
     7.190    18.372     0.200
     7.200    19.835     0.200
     7.265    19.628     0.200
     7.278    19.930     0.200
     7.712    20.839     0.200
     7.798    21.081     0.200
     7.837    21.001     0.200
     7.842    21.233     0.200
     7.848    21.831     0.200
     7.915    19.220     0.200
     7.913    20.638     0.200
     7.893    21.947     0.200
     7.923    22.534     0.200
     7.911    21.664     0.200
     7.963    21.309     0.200
     7.956    22.004     0.200
     8.134    22.488     0.200
     8.185    21.605     0.200
     8.293    22.142     0.200
     8.466    21.082     0.200
     8.499    21.140     0.200
     8.665    22.003     0.200
     8.667    23.781     0.200
     8.872    23.925     0.200
     8.949    22.391     0.200
     8.954    23.759     0.200
     9.067    23.339     0.200
     9.067    21.613     0.200
     9.164    22.916     0.200
     9.143    23.588     0.200
     9.266    22.213     0.200
     9.311    21.706     0.200
     9.354    22.414     0.200
     9.366    25.618     0.200
     9.486    22.641     0.200
     9.658    23.537     0.200
     9.658    23.248     0.200
     9.680    24.126     0.200
     9.786    23.714     0.200
     9.845    24.517     0.200
     9.926    24.494     0.200
     9.977    24.253     0.200
    10.029    24.455     0.200
    10.104    24.070     0.200
    10.137    24.302     0.200
    10.129    26.429     0.200
    10.179    23.981     0.200
    10.504    27.764     0.200
    11.156    27.194     0.200
    12.025    30.072     0.200
    12.162    26.224     0.200
    12.162    25.716     0.200
    12.195    30.136     0.200
    12.162    29.325     0.200
    12.999    31.374     0.200
    13.842    32.872     0.200
    13.950    31.853     0.200
    14.506    34.667     0.200
    14.667    34.496     0.200
    14.712    33.637     0.200
    14.721    34.009     0.200
    15.124    34.496     0.200
    15.208    35.222     0.200
    15.202    34.761     0.200
    15.298    35.509     0.200
    15.483    35.892     0.200
    15.544    36.168     0.200
    15.605    35.761     0.200
    15.663    36.294     0.200
    15.606    33.876     0.200
    15.699    35.744     0.200
    15.799    35.939     0.200
    16.183    34.894     0.200
    16.807    37.487     0.200
     1.130     6.537     0.200
     1.769     8.395     0.200
     1.876     9.651     0.200
     1.917     9.042     0.200
     2.011     9.575     0.200
     2.176     8.955     0.200
     2.366    10.397     0.200
     2.552    10.397     0.200
     2.794    10.968     0.200
     2.768    11.713     0.200
     2.868     9.370     0.200
     2.868     9.534     0.200
     3.646    12.487     0.200
     3.958    12.246     0.200
     3.878    13.612     0.200
     3.941    11.942     0.200
     4.070    13.724     0.200
     4.552    14.297     0.200
     4.606    14.611     0.200
     4.666    14.423     0.200
     4.722    13.128     0.200
     4.722    12.613     0.200
     4.868    14.493     0.200
     4.817    15.081     0.200
     4.864    15.600     0.200
     4.981    14.963     0.200
     4.904    15.679     0.200
     5.011    14.921     0.200
     4.969    14.571     0.200
     5.127    14.824     0.200
     5.043    15.908     0.200
     5.123    15.530     0.200
     5.263    16.780     0.200
     5.363    14.617     0.200
     5.363    13.984     0.200
     5.406    16.625     0.200
     5.706    16.878     0.200
     5.700    16.564     0.200
     5.743    17.128     0.200
     5.770    17.022     0.200
     6.178    17.529     0.200
     6.123    18.166     0.200
     6.444    19.030     0.200
     6.753    19.526     0.200
     6.772    19.334     0.200
     6.833    19.013     0.200
     7.047    19.903     0.200
     7.146    19.248     0.200
     7.233    19.771     0.200
     7.238    19.982     0.200
     7.248    19.527     0.200
     7.270    20.438     0.200
     7.341    17.983     0.200
     7.400    20.486     0.200
     7.464    20.483     0.200
     7.466    19.563     0.200
     7.913    20.986     0.200
     8.043    21.393     0.200
     8.050    22.356     0.200
     8.081    21.908     0.200
     8.081    21.799     0.200
     8.106    20.959     0.200
     8.126    21.967     0.200
     8.339    22.282     0.200
     8.493    22.207     0.200
     8.665    22.531     0.200
     8.693    22.620     0.200
     8.787    22.529     0.200
     8.708    23.113     0.200
     8.831    23.315     0.200
     8.868    22.570     0.200
     8.785    24.099     0.200
     8.845    21.615     0.200
     9.019    22.122     0.200
     9.035    23.686     0.200
     9.462    23.171     0.200
     9.497    21.870     0.200
     9.570    25.537     0.200
     9.657    21.446     0.200
     9.681    23.119     0.200
     9.838    24.227     0.200
     9.838    23.844     0.200
    10.038    24.998     0.200
    10.096    25.316     0.200
    10.324    25.734     0.200
    10.423    25.306     0.200
    10.449    26.031     0.200
    10.539    25.850     0.200
    10.705    25.657     0.200
    10.823    26.597     0.200
    10.927    27.264     0.200
    11.119    26.336     0.200
    11.151    27.416     0.200
    11.184    27.440     0.200
    11.323    26.944     0.200
    11.662    29.666     0.200
    11.705    30.653     0.200
    12.026    27.197     0.200
    12.078    29.267     0.200
    12.111    30.236     0.200
    12.363    27.313     0.200
    12.363    27.524     0.200
    12.378    29.934     0.200
    12.367    30.112     0.200
    12.943    29.134     0.200
    13.275    32.756     0.200
    13.608    32.883     0.200
    13.818    33.862     0.200
    14.075    29.617     0.200
    14.256    34.208     0.200
    14.446    34.433     0.200
    14.482    33.106     0.200
    14.557    34.282     0.200
    14.795    34.879     0.200
    14.853    34.030     0.200
    14.908    33.404     0.200
    15.016    35.017     0.200
    15.148    35.078     0.200
    15.328    34.929     0.200
    15.395    34.731     0.200
    15.563    33.539     0.200
    15.563    35.312     0.200
    15.768    35.396     0.200
    15.807    36.976     0.200
    15.895    35.408     0.200
    16.384    36.014     0.200
    16.945    36.332     0.200
    17.042    35.085     0.200
    17.559    36.986     0.200
     1.622     9.003     0.200
     1.651     8.930     0.200
     1.634     9.790     0.200
     1.810     9.443     0.200
     1.829     9.659     0.200
     1.836     9.353     0.200
     2.029     8.321     0.200
     2.291     9.524     0.200
     2.367    10.656     0.200
     2.591    10.413     0.200
     2.591    10.710     0.200
     2.559    10.741     0.200
     2.760     9.121     0.200
     2.718    11.404     0.200
     2.813    10.964     0.200
     2.813    11.472     0.200
     2.912    11.807     0.200
     3.378    11.369     0.200
     3.533    12.483     0.200
     3.671    12.557     0.200
     3.735    12.838     0.200
     3.637    12.996     0.200
     3.827    11.720     0.200
     3.683    11.531     0.200
     3.924    13.185     0.200
     4.005    12.781     0.200
     4.230    13.875     0.200
     4.465    14.265     0.200
     4.602    13.335     0.200
     4.717    14.028     0.200
     4.829    14.236     0.200
     4.760    14.260     0.200
     4.950    14.837     0.200
     4.981    14.931     0.200
     4.997    14.971     0.200
     5.116    15.794     0.200
     5.239    14.197     0.200
     5.239    13.791     0.200
     5.631    16.241     0.200
     5.758    17.952     0.200
     5.977    17.191     0.200
     6.020    17.435     0.200
     6.270    18.504     0.200
     6.238    18.290     0.200
     6.628    18.501     0.200
     6.627    18.210     0.200
     6.626    18.759     0.200
     6.692    18.582     0.200
     6.861    18.850     0.200
     6.913    18.937     0.200
     7.090    19.067     0.200
     7.128    19.430     0.200
     7.164    19.606     0.200
     7.207    17.584     0.200
     7.257    20.387     0.200
     7.322    19.620     0.200
     7.899    21.668     0.200
     7.905    21.600     0.200
     7.920    20.524     0.200
     8.191    21.694     0.200
     8.724    22.309     0.200
     8.893    23.697     0.200
     9.123    23.173     0.200
     9.316    22.510     0.200
     9.323    23.320     0.200
     9.365    22.176     0.200
     9.357    25.733     0.200
     9.528    22.252     0.200
     9.542    23.429     0.200
     9.712    23.702     0.200
     9.712    23.312     0.200
     9.844    25.688     0.200
     9.901    24.817     0.200
     9.977    24.722     0.200
    10.031    24.329     0.200
    10.157    24.460     0.200
    10.192    24.324     0.200
    11.025    26.530     0.200
    11.256    27.318     0.200
    11.522    27.377     0.200
    11.778    28.165     0.200
    11.846    27.777     0.200
    11.895    28.361     0.200
    11.965    29.084     0.200
    12.087    28.870     0.200
    12.244    29.453     0.200
    12.219    26.048     0.200
    12.666    28.841     0.200
    14.550    34.243     0.200
    14.769    32.533     0.200
    14.869    35.442     0.200
    15.045    35.756     0.200
    15.029    35.933     0.200
    15.180    35.092     0.200
    15.258    33.482     0.200
    15.538    35.077     0.200
    15.592    34.187     0.200
    15.655    35.157     0.200
    15.708    37.150     0.200
    15.756    34.537     0.200
    15.855    34.258     0.200
    16.147    34.396     0.200
    16.154    36.056     0.200
    16.240    34.493     0.200
    16.301    35.194     0.200
    16.413    34.794     0.200
    16.851    36.435     0.200
    16.865    38.370     0.200
    16.883    35.736     0.200
    16.902    35.686     0.200
    16.928    36.742     0.200
    17.316    36.169     0.200
    17.418    36.772     0.200
     1.618     9.273     0.200
     1.601     9.930     0.200
     1.697     9.603     0.200
     1.753     9.955     0.200
     1.791     9.012     0.200
     1.911     8.212     0.200
     2.173    10.132     0.200
     2.473    10.976     0.200
     2.667     9.862     0.200
     2.667     9.511     0.200
     2.584    11.216     0.200
     2.847    11.974     0.200
     3.619    12.932     0.200
     3.729    12.671     0.200
     3.729    11.656     0.200
     3.698    12.908     0.200
     3.806    13.364     0.200
     4.059    15.622     0.200
     4.059    15.028     0.200
     4.291    14.159     0.200
     4.348    14.488     0.200
     4.409    13.563     0.200
     4.471    14.461     0.200
     4.499    13.016     0.200
     4.600    14.938     0.200
     4.651    15.690     0.200
     4.713    14.362     0.200
     4.835    14.816     0.200
     4.865    15.148     0.200
     4.998    17.013     0.200
     5.134    13.566     0.200
     5.134    14.230     0.200
     5.517    16.172     0.200
     5.506    17.274     0.200
     5.649    17.878     0.200
     5.859    16.29