#!/bin/bash
gmt begin simeonof10.15_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance simeonof10.15'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.500    11.637
     0.600    13.027
     0.700    14.418
     0.800    15.808
     0.900    17.198
     1.000    18.588
     1.100    19.978
     1.200    21.369
     1.300    22.759
     1.400    24.149
     1.500    25.539
     1.600    26.930
     1.700    28.320
     1.800    29.710
     1.900    31.100
     2.000    32.490
     2.100    33.881
     2.200    35.271
     2.300    36.661
     2.400    38.051
     2.500    39.441
     2.600    40.832
     2.700    42.222
     2.800    43.612
     2.900    45.002
     3.000    46.392
     3.100    47.783
     3.200    49.173
     3.300    50.563
     3.400    51.953
     3.500    53.342
     3.600    54.732
     3.700    56.122
     3.800    57.512
     3.900    58.901
     4.000    60.291
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    52.732 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     5.618
     0.200     6.478
     0.300     7.696
     0.400     9.121
     0.500    10.662
     0.600    12.268
     0.700    13.909
     0.800    15.572
     0.900    17.246
     1.000    18.929
     1.100    20.617
     1.200    22.307
     1.300    24.001
     1.400    25.696
     1.500    27.393
     1.600    29.091
     1.700    30.790
     1.800    32.489
     1.900    34.189
     2.000    35.889
     2.100    37.590
     2.200    39.290
     2.300    40.991
     2.400    42.693
     2.500    44.394
     2.600    46.096
     2.700    47.798
     2.800    49.499
     2.900    51.201
     3.000    52.904
     3.100    54.606
     3.200    56.308
     3.300    58.010
     3.400    59.712
     3.500    61.414
     3.600    63.116
     3.700    64.819
     3.800    66.521
     3.900    68.223
     4.000    69.926
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    62.116 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.600    21.969
     0.700    24.399
     0.800    26.828
     0.900    29.257
     1.000    31.686
     1.100    34.115
     1.200    36.544
     1.300    38.973
     1.400    41.402
     1.500    43.831
     1.600    46.260
     1.700    48.689
     1.800    51.118
     1.900    53.547
     2.000    55.976
     2.100    58.405
     2.200    60.834
     2.300    63.263
     2.400    65.692
     2.500    68.121
     2.600    70.550
     2.700    72.979
     2.800    75.408
     2.900    77.838
     3.000    80.267
     3.100    82.696
     3.200    85.125
     3.300    87.554
     3.400    89.982
     3.500    92.410
     3.600    94.839
     3.700    97.267
     3.800    99.695
     3.900   102.123
     4.000   104.552
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    92.839 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     9.497
     0.200    10.946
     0.300    12.993
     0.400    15.384
     0.500    17.965
     0.600    20.649
     0.700    23.390
     0.800    26.164
     0.900    28.957
     1.000    31.762
     1.100    34.576
     1.200    37.395
     1.300    40.218
     1.400    43.044
     1.500    45.872
     1.600    48.702
     1.700    51.533
     1.800    54.366
     1.900    57.199
     2.000    60.032
     2.100    62.867
     2.200    65.702
     2.300    68.537
     2.400    71.372
     2.500    74.208
     2.600    77.044
     2.700    79.881
     2.800    82.717
     2.900    85.554
     3.000    88.391
     3.100    91.227
     3.200    94.064
     3.300    96.901
     3.400    99.738
     3.500   102.575
     3.600   105.412
     3.700   108.249
     3.800   111.086
     3.900   113.923
     4.000   116.760
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   104.412 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    20.585
     1.000    21.975
     1.100    23.365
     1.200    24.756
     1.300    26.146
     1.400    27.536
     1.500    28.926
     1.600    30.316
     1.700    31.707
     1.800    33.097
     1.900    34.487
     2.000    35.877
     2.100    37.267
     2.200    38.658
     2.300    40.048
     2.400    41.438
     2.500    42.828
     2.600    44.218
     2.700    45.609
     2.800    46.999
     2.900    48.389
     3.000    49.779
     3.100    51.169
     3.200    52.559
     3.300    53.950
     3.400    55.340
     3.500    56.730
     3.600    58.120
     3.700    59.510
     3.800    60.900
     3.900    62.290
     4.000    63.679
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     2.030
     0.200     4.047
     0.300     6.067
     0.400     8.088
     0.500    10.109
     0.600    12.131
     0.700    14.152
     0.800    16.173
     0.900    18.195
     1.000    20.216
     1.100    22.159
     1.200    23.876
     1.300    25.582
     1.400    27.287
     1.500    28.992
     1.600    30.697
     1.700    32.403
     1.800    34.108
     1.900    35.813
     2.000    37.518
     2.100    39.223
     2.200    40.929
     2.300    42.634
     2.400    44.339
     2.500    46.045
     2.600    47.750
     2.700    49.455
     2.800    51.160
     2.900    52.865
     3.000    54.570
     3.100    56.275
     3.200    57.980
     3.300    59.685
     3.400    61.390
     3.500    63.094
     3.600    64.799
     3.700    66.504
     3.800    68.209
     3.900    69.913
     4.000    71.617
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.000    37.109
     1.100    39.538
     1.200    41.967
     1.300    44.397
     1.400    46.826
     1.500    49.255
     1.600    51.684
     1.700    54.113
     1.800    56.542
     1.900    58.971
     2.000    61.400
     2.100    63.829
     2.200    66.258
     2.300    68.687
     2.400    71.116
     2.500    73.545
     2.600    75.974
     2.700    78.403
     2.800    80.832
     2.900    83.261
     3.000    85.690
     3.100    88.119
     3.200    90.548
     3.300    92.977
     3.400    95.406
     3.500    97.835
     3.600   100.264
     3.700   102.693
     3.800   105.121
     3.900   107.549
     4.000   109.978
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.544
     0.200     7.066
     0.300    10.594
     0.400    14.123
     0.500    17.651
     0.600    21.180
     0.700    24.710
     0.800    28.013
     0.900    31.185
     1.000    34.357
     1.100    37.364
     1.200    40.207
     1.300    43.049
     1.400    45.891
     1.500    48.733
     1.600    51.575
     1.700    54.417
     1.800    57.259
     1.900    60.101
     2.000    62.943
     2.100    65.785
     2.200    68.627
     2.300    71.469
     2.400    74.312
     2.500    77.153
     2.600    79.995
     2.700    82.837
     2.800    85.678
     2.900    88.520
     3.000    91.361
     3.100    94.203
     3.200    97.045
     3.300    99.886
     3.400   102.728
     3.500   105.569
     3.600   108.410
     3.700   111.252
     3.800   114.093
     3.900   116.934
     4.000   119.775
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100     9.229
     0.200     9.663
     0.300    10.342
     0.400    11.217
     0.500    12.239
     0.600    13.367
     0.700    14.570
     0.800    15.824
     0.900    17.115
     1.000    18.429
     1.100    19.761
     1.200    21.105
     1.300    22.457
     1.400    23.816
     1.500    25.179
     1.600    26.547
     1.700    27.918
     1.800    29.291
     1.900    30.666
     2.000    32.042
     2.100    33.420
     2.200    34.798
     2.300    36.178
     2.400    37.559
     2.500    38.940
     2.600    40.321
     2.700    41.704
     2.800    43.086
     2.900    44.469
     3.000    45.853
     3.100    47.236
     3.200    48.620
     3.300    50.004
     3.400    51.389
     3.500    52.773
     3.600    54.158
     3.700    55.542
     3.800    56.927
     3.900    58.312
     4.000    59.697
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100    15.738
     0.200    16.481
     0.300    17.644
     0.400    19.144
     0.500    20.900
     0.600    22.842
     0.700    24.918
     0.800    27.088
     0.900    29.326
     1.000    31.609
     1.100    33.926
     1.200    36.266
     1.300    38.623
     1.400    40.993
     1.500    43.372
     1.600    45.759
     1.700    48.152
     1.800    50.549
     1.900    52.949
     2.000    55.353
     2.100    57.759
     2.200    60.168
     2.300    62.578
     2.400    64.989
     2.500    67.402
     2.600    69.815
     2.700    72.230
     2.800    74.645
     2.900    77.062
     3.000    79.479
     3.100    81.896
     3.200    84.314
     3.300    86.732
     3.400    89.150
     3.500    91.569
     3.600    93.988
     3.700    96.407
     3.800    98.827
     3.900   101.247
     4.000   103.667
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     0.456    10.546     0.200
     4.693    69.046     0.200
     4.713    68.247     0.200
     5.134    74.847     0.200
     5.267    75.146     0.200
     5.347    78.747     0.200
     6.740    97.146     0.200
     8.382   119.046     0.200
     8.583   120.847     0.200
     8.760   123.546     0.200
     8.972   125.546     0.200
    10.019   141.747     0.200
    10.163   145.447     0.200
    10.373   145.747     0.200
    11.691   164.546     0.200
    11.847   164.747     0.200
    11.847   164.546     0.200
    12.323   172.146     0.200
    14.198   195.447     0.200
    15.595   217.947     0.200
     0.395     9.844     0.200
     5.273    75.144     0.200
     5.319    79.044     0.200
     6.701    96.944     0.200
     8.337   118.444     0.200
     8.566   119.544     0.200
     8.740   122.744     0.200
     8.955   126.244     0.200
    10.125   144.644     0.200
    10.360   145.444     0.200
    11.645   163.944     0.200
    11.817   163.344     0.200
    11.817   164.144     0.200
    12.546   175.244     0.200
    14.226   196.444     0.200
     5.141    73.195     0.200
     5.556    83.195     0.200
     6.775    97.896     0.200
     8.448   120.795     0.200
     8.531   119.896     0.200
     8.721   122.996     0.200
     8.924   124.496     0.200
    10.309   145.096     0.200
    10.393   149.695     0.200
    11.606   166.096     0.200
    11.756   166.295     0.200
    11.847   164.896     0.200
    11.847   164.695     0.200
    11.878   166.596     0.200
    13.998   193.096     0.200
     0.737    14.957     0.200
     5.165    74.457     0.200
     6.840   100.156     0.200
     8.518   122.059     0.200
     8.576   122.059     0.200
     8.797   124.957     0.200
     9.029   128.758     0.200
    10.350   146.855     0.200
    10.413   150.059     0.200
    11.826   168.855     0.200
    11.904   165.457     0.200
    12.150   171.758     0.200
    13.994   195.258     0.200
     5.026    73.016     0.200
     6.795    99.113     0.200
     8.490   122.215     0.200
     8.675   122.613     0.200
     8.654   123.613     0.200
     8.870   125.113     0.200
    10.240   144.914     0.200
    10.602   152.516     0.200
    11.797   167.414     0.200
    11.832   164.414     0.200
    11.832   165.332     0.200
    11.832   164.414     0.200
    11.998   169.312     0.200
    13.817   193.613     0.200
    15.664   219.516     0.200
     4.958    70.875     0.200
     6.663    96.469     0.200
     8.353   120.172     0.200
     8.827   124.672     0.200
    10.590   151.875     0.200
    11.660   165.672     0.200
    18.158   247.672     0.200
     4.960    71.906     0.200
     6.734    97.504     0.200
     8.433   120.805     0.200
     8.863   126.805     0.200
    10.174   143.504     0.200
    10.174   145.406     0.200
    10.652   152.504     0.200
    11.739   166.406     0.200
    11.768   162.305     0.200
    11.768   163.305     0.200
    11.933   168.004     0.200
    13.759   192.004     0.200
     5.071    73.289     0.200
     6.805    98.688     0.200
     8.495   121.805     0.200
     8.900   125.688     0.200
    10.538   149.484     0.200
    11.802   167.484     0.200
    11.852   163.688     0.200
    11.852   165.812     0.200
    11.852   167.484     0.200
    12.047   169.984     0.200
     5.251    75.387     0.200
     8.525   122.188     0.200
     9.026   127.787     0.200
     9.085   128.486     0.200
    10.413   147.188     0.200
    10.290   149.287     0.200
    11.381   160.387     0.200
    11.834   168.887     0.200
    11.940   165.387     0.200
    11.940   167.887     0.200
    14.107   195.586     0.200
    16.731   230.887     0.200
     8.561   120.531     0.200
     8.953   125.328     0.200
    10.341   145.328     0.200
    10.331   148.828     0.200
    11.575   162.125     0.200
    11.761   166.125     0.200
    11.866   164.328     0.200
    13.972   194.125     0.200
    15.785   221.328     0.200
     5.768    82.801     0.200
     8.616   123.801     0.200
     9.381   132.801     0.200
     9.607   139.000     0.200
    10.800   152.102     0.200
    11.918   169.102     0.200
    12.184   169.102     0.200
    14.746   203.602     0.200
    18.708   254.602     0.200
     5.108    73.266     0.200
     6.821    98.961     0.200
     8.506   121.867     0.200
     8.533   119.664     0.200
     8.730   122.766     0.200
     8.738   123.664     0.200
    10.491   150.664     0.200
    11.814   167.164     0.200
    11.874   164.664     0.200
    12.087   169.367     0.200
    13.358   186.961     0.200
    13.921   193.062     0.200
    16.744   231.562     0.200
     5.629    82.190     0.200
     5.831    85.470     0.200
     5.884    86.070     0.200
     6.162    89.450     0.200
     6.254    91.400     0.200
     6.349    92.500     0.200
     7.132   103.950     0.200
     7.202   103.700     0.200
     7.288   106.320     0.200
     7.325   104.870     0.200
     7.327   105.130     0.200
     7.349   106.150     0.200
     7.364   108.150     0.200
     7.364   107.550     0.200
     7.520   109.370     0.200
     8.067   117.560     0.200
     8.103   118.290     0.200
     8.216   118.960     0.200
     8.231   117.940     0.200
     8.248   119.760     0.200
     8.270   118.530     0.200
     8.729   124.160     0.200
     8.754   125.190     0.200
     8.889   127.380     0.200
     8.947   126.910     0.200
     8.969   126.700     0.200
     9.108   128.850     0.200
     9.148   130.390     0.200
     9.359   133.160     0.200
     9.359   133.590     0.200
     9.477   134.150     0.200
     9.556   134.110     0.200
     9.590   136.280     0.200
     9.670   136.130     0.200
     9.989   141.220     0.200
    10.119   142.970     0.200
    10.303   147.020     0.200
    10.337   147.520     0.200
    10.416   148.060     0.200
    10.489   147.320     0.200
    10.758   152.790     0.200
    11.251   158.160     0.200
    11.317   158.770     0.200
    11.422   160.750     0.200
    11.558   161.810     0.200
    11.756   164.970     0.200
    12.062   171.990     0.200
    12.235   169.390     0.200
    12.235   170.190     0.200
    12.670   177.980     0.200
    14.500   202.090     0.200
     5.367    76.680     0.200
     5.557    81.312     0.200
     5.893    86.648     0.200
     5.990    88.094     0.200
     6.076    88.953     0.200
     6.282    91.719     0.200
     6.628    97.750     0.200
     6.856    98.797     0.200
     6.930   100.211     0.200
     7.050   103.523     0.200
     7.090   103.641     0.200
     7.825   112.250     0.200
     7.830   110.461     0.200
     7.867   112.508     0.200
     7.958   114.508     0.200
     7.999   114.094     0.200
     8.271   118.047     0.200
     8.455   119.938     0.200
     8.498   120.977     0.200
     8.616   123.742     0.200
     8.622   121.641     0.200
     8.638   123.320     0.200
     8.696   123.352     0.200
     8.839   124.953     0.200
     8.874   126.820     0.200
     9.086   129.883     0.200
     9.204   130.047     0.200
     9.282   131.531     0.200
     9.384   131.898     0.200
     9.400   132.617     0.200
     9.512   133.711     0.200
     9.579   133.773     0.200
     9.849   138.859     0.200
     9.888   139.172     0.200
     9.994   140.141     0.200
    10.115   143.453     0.200
    10.217   143.250     0.200
    10.485   147.641     0.200
    11.048   154.781     0.200
    11.157   157.000     0.200
    11.491   161.070     0.200
    11.500   161.281     0.200
    11.806   166.523     0.200
    11.818   163.680     0.200
    11.913   167.328     0.200
    11.964   166.750     0.200
    11.964   166.852     0.200
    14.276   199.852     0.200
     5.274    76.746     0.200
     5.274    76.848     0.200
     5.451    80.945     0.200
     5.794    84.715     0.200
     5.875    87.035     0.200
     5.885    87.348     0.200
     5.891    87.496     0.200
     5.907    87.676     0.200
     5.912    87.727     0.200
     5.969    88.105     0.200
     6.177    90.984     0.200
     6.522    95.375     0.200
     6.540    95.688     0.200
     6.593    99.246     0.200
     6.748    97.746     0.200
     6.748    98.348     0.200
     6.829    98.418     0.200
     6.945   101.375     0.200
     6.969   101.387     0.200
     7.069   102.156     0.200
     7.118   102.324     0.200
     7.281   105.645     0.200
     7.649   110.707     0.200
     7.656   113.777     0.200
     7.687   111.668     0.200
     7.692   111.367     0.200
     7.718   112.016     0.200
     7.723   111.387     0.200
     7.731   111.867     0.200
     7.754   112.246     0.200
     7.760   111.836     0.200
     7.855   111.746     0.200
     7.855   112.246     0.200
     7.898   111.938     0.200
     8.169   116.266     0.200
     8.349   119.246     0.200
     8.391   119.746     0.200
     8.391   120.246     0.200
     8.509   122.625     0.200
     8.535   121.234     0.200
     8.591   121.746     0.200
     8.768   125.445     0.200
     8.909   126.746     0.200
     8.981   126.477     0.200
     8.981   126.348     0.200
     9.177   129.766     0.200
     9.286   130.848     0.200
     9.407   131.996     0.200
     9.684   135.984     0.200
     9.748   137.324     0.200
     9.785   137.527     0.200
     9.840   140.598     0.200
     9.897   139.188     0.200
    10.004   141.516     0.200
    10.037   142.445     0.200
    10.080   141.945     0.200
    10.116   142.465     0.200
    10.158   147.047     0.200
    10.398   146.117     0.200
    10.627   150.805     0.200
    10.628   150.566     0.200
    10.833   152.957     0.200
    10.874   152.516     0.200
    10.924   154.016     0.200
    10.949   153.715     0.200
    10.963   155.258     0.200
    11.180   156.547     0.200
    11.266   158.156     0.200
    11.264   159.336     0.200
    11.375   161.117     0.200
    11.394   160.418     0.200
    11.407   160.848     0.200
    11.439   159.105     0.200
    11.653   161.727     0.200
    11.699   164.746     0.200
    11.699   165.547     0.200
    11.710   162.656     0.200
    11.790   164.777     0.200
    11.818   166.445     0.200
    11.856   164.145     0.200
    11.856   163.371     0.200
    11.856   163.945     0.200
    12.032   166.406     0.200
    12.139   174.945     0.200
    12.286   172.695     0.200
    12.946   179.625     0.200
    13.824   190.246     0.200
    14.204   196.848     0.200
    15.169   213.746     0.200
    15.600   219.145     0.200
    16.565   228.645     0.200
     0.452    10.438     0.200
     5.083    72.258     0.200
     5.288    77.258     0.200
     5.336    77.461     0.200
     6.621    95.055     0.200
     7.605   108.711     0.200
     7.683   108.438     0.200
     8.281   117.688     0.200
     8.423   118.359     0.200
     8.605   121.961     0.200
     8.814   125.250     0.200
     9.938   138.375     0.200
    10.355   147.195     0.200
    11.207   157.266     0.200
    11.590   162.984     0.200
    11.711   164.750     0.200
    15.624   218.758     0.200
    16.485   226.875     0.200
     0.382     9.680     0.200
     0.382     9.781     0.200
     5.264    73.680     0.200
     5.264    74.477     0.200
     5.475    79.781     0.200
     5.772    83.336     0.200
     5.840    86.133     0.200
     5.849    86.141     0.200
     5.871    86.273     0.200
     5.876    86.227     0.200
     5.925    86.297     0.200
     6.139    89.422     0.200
     6.481    93.391     0.200
     6.548    94.602     0.200
     6.564    95.688     0.200
     6.688    95.680     0.200
     6.802    96.961     0.200
     6.904    99.430     0.200
     6.925   100.406     0.200
     7.025   102.078     0.200
     7.090   100.797     0.200
     7.237   103.578     0.200
     7.603   109.219     0.200
     7.617   111.852     0.200
     7.641   110.102     0.200
     7.678   109.609     0.200
     7.822   110.680     0.200
     7.822   110.883     0.200
     7.871   110.742     0.200
     8.139   115.430     0.200
     8.323   117.680     0.200
     8.323   117.883     0.200
     8.307   117.531     0.200
     8.461   120.453     0.200
     8.504   119.898     0.200
     8.555   119.977     0.200
     8.728   122.781     0.200
     8.898   124.977     0.200
     8.944   124.680     0.200
     8.944   125.383     0.200
    10.088   140.523     0.200
    10.129   143.680     0.200
    10.129   143.977     0.200
    11.632   162.680     0.200
    11.632   163.281     0.200
    11.805   162.289     0.200
    11.805   162.648     0.200
    11.805   162.680     0.200
    11.805   162.781     0.200
    12.136   173.383     0.200
    14.220   195.492     0.200
    15.121   211.570     0.200
    15.508   216.883     0.200
    16.488   226.680     0.200
    16.488   227.383     0.200
     5.566    83.531     0.200
     5.793    88.133     0.200
     5.985    89.758     0.200
     5.987    89.938     0.200
     6.093    90.945     0.200
     6.641    99.008     0.200
     6.688    99.062     0.200
     6.853   100.242     0.200
     6.964   102.562     0.200
     7.057   105.055     0.200
     7.057   105.055     0.200
     7.094   104.562     0.200
     7.183   106.578     0.200
     7.844   116.477     0.200
     7.861   115.898     0.200
     7.887   114.367     0.200
     7.905   116.336     0.200
     8.201   119.766     0.200
     8.451   123.008     0.200
     8.652   124.617     0.200
     8.660   124.852     0.200
     8.825   126.156     0.200
     9.056   132.055     0.200
     9.476   136.016     0.200
     9.475   134.906     0.200
     9.758   139.867     0.200
     9.838   141.523     0.200
    10.135   144.336     0.200
    10.428   149.758     0.200
    10.457   152.047     0.200
    10.869   155.164     0.200
    10.939   156.008     0.200
    11.353   161.844     0.200
    11.959   171.008     0.200
    12.011   167.555     0.200
    12.011   167.852     0.200
    16.072   227.555     0.200
     5.755    85.910     0.200
     5.776    83.859     0.200
     5.776    84.461     0.200
     5.892    86.859     0.200
     6.277    91.668     0.200
     6.335    93.590     0.200
     6.363    92.910     0.200
     6.394    94.469     0.200
     6.622    97.438     0.200
     6.932   102.129     0.200
     7.062   104.129     0.200
     7.106   102.859     0.200
     7.301   105.469     0.200
     7.603   111.129     0.200
     8.149   119.199     0.200
     8.178   119.160     0.200
     8.314   118.859     0.200
     8.314   119.461     0.200
     8.705   123.859     0.200
     8.705   124.160     0.200
     9.009   127.648     0.200
     9.041   128.660     0.200
     9.070   128.680     0.200
     9.206   130.758     0.200
     9.410   132.961     0.200
     9.427   133.531     0.200
     9.427   134.059     0.200
     9.427   133.758     0.200
     9.653   139.660     0.200
     9.653   139.461     0.200
     9.627   137.609     0.200
     9.678   136.988     0.200
     9.856   138.340     0.200
    10.840   152.961     0.200
    12.008   168.859     0.200
    12.008   169.559     0.200
    12.251   170.961     0.200
    12.251   169.461     0.200
    12.251   168.961     0.200
    12.649   181.461     0.200
    14.719   205.059     0.200
    15.258   212.258     0.200
    15.571   218.559     0.200
     0.540    11.393     0.200
     5.274    75.482     0.200
     6.796    98.053     0.200
     7.765   113.762     0.200
     7.793   113.162     0.200
     7.875   113.322     0.200
     8.447   120.262     0.200
     8.615   122.543     0.200
     8.796   125.543     0.200
     9.006   129.143     0.200
     9.431   133.582     0.200
    10.107   143.842     0.200
    10.198   146.463     0.200
    10.402   147.143     0.200
    11.400   159.812     0.200
    11.756   167.713     0.200
    11.895   166.643     0.200
    11.895   167.242     0.200
    14.177   196.902     0.200
     5.802    83.357     0.200
     5.802    83.558     0.200
     5.890    86.968     0.200
     6.004    87.987     0.200
     6.059    88.588     0.200
     6.337    91.308     0.200
     6.428    95.317     0.200
     6.521    96.348     0.200
     7.377   107.768     0.200
     8.907   128.357     0.200
     9.144   130.657     0.200
     9.534   135.058     0.200
     9.767   140.357     0.200
     9.767   140.857     0.200
    10.933   154.957     0.200
    12.214   173.947     0.200
    12.403   175.728     0.200
    12.551   173.957     0.200
    14.588   203.558     0.200
    15.269   213.758     0.200
     0.833    15.521     0.200
     2.796    45.172     0.200
     5.743    83.521     0.200
     8.178   118.561     0.200
     8.318   119.641     0.200
     8.777   124.521     0.200
     8.777   125.221     0.200
     9.051   129.021     0.200
     9.224   132.422     0.200
     9.440   132.521     0.200
     9.440   133.021     0.200
     9.754   138.521     0.200
     9.754   138.922     0.200
     9.867   138.822     0.200
    10.845   153.021     0.200
    12.083   168.521     0.200
    12.083   169.221     0.200
    12.291   170.521     0.200
    12.291   171.121     0.200
    12.442   171.822     0.200
    14.501   201.322     0.200
    15.218   213.721     0.200
     5.855    85.649     0.200
     6.499    98.899     0.200
     8.959   129.689     0.200
     9.199   132.999     0.200
     9.589   136.999     0.200
     9.708   140.199     0.200
     9.785   141.699     0.200
     9.881   142.199     0.200
    10.392   148.300     0.200
    10.558   152.600     0.200
    10.639   153.899     0.200
    10.719   152.999     0.200
    10.831   154.899     0.200
    10.988   156.399     0.200
    11.547   163.600     0.200
    11.985   170.449     0.200
    12.266   175.600     0.200
    12.606   175.600     0.200
    12.606   175.999     0.200
     5.600    80.531     0.200
     5.624    80.430     0.200
     6.242    91.031     0.200
     6.836    98.727     0.200
     7.060   102.125     0.200
     8.067   116.117     0.200
     8.683   124.727     0.200
     9.325   131.625     0.200
     9.752   136.828     0.200
     9.859   143.125     0.200
    10.729   151.727     0.200
    11.745   165.125     0.200
    11.990   171.031     0.200
    12.148   169.297     0.200
    12.333   170.625     0.200
    14.529   202.828     0.200
    14.783   209.828     0.200
    16.819   232.727     0.200
     0.297     9.240     0.200
     5.204    74.361     0.200
     5.231    75.150     0.200
     5.806    84.371     0.200
     6.396    92.660     0.200
     6.615    95.150     0.200
     8.245   117.131     0.200
     8.500   121.260     0.200
     8.888   124.781     0.200
     9.316   130.941     0.200
    10.296   145.160     0.200
    10.127   145.021     0.200
    11.338   158.650     0.200
    11.553   164.061     0.200
    11.702   162.531     0.200
    11.888   164.861     0.200
    14.211   197.961     0.200
    19.358   262.361     0.200
     1.263    22.725     0.200
     1.263    22.525     0.200
     1.283    22.925     0.200
     1.294    23.325     0.200
     1.367    25.225     0.200
     1.395    25.125     0.200
     1.390    23.725     0.200
     1.422    24.825     0.200
     1.427    24.625     0.200
     1.575    27.225     0.200
     1.729    30.525     0.200
     4.095    60.825     0.200
     4.170    61.625     0.200
     4.071    61.725     0.200
     4.120    62.625     0.200
     4.236    62.725     0.200
     4.300    63.625     0.200
     4.202    63.425     0.200
     4.240    63.825     0.200
     4.608    67.625     0.200
     4.609    67.225     0.200
     4.730    69.025     0.200
     4.751    69.525     0.200
     4.780    70.025     0.200
     4.926    72.225     0.200
     5.108    73.515     0.200
     5.419    79.425     0.200
     5.666    83.825     0.200
     5.799    84.825     0.200
     5.822    85.525     0.200
     5.927    86.825     0.200
     6.435    93.825     0.200
     6.461    94.625     0.200
     6.482    94.725     0.200
     6.529    95.425     0.200
     6.718    96.225     0.200
     6.855   100.325     0.200
     6.924   100.525     0.200
     6.934   101.325     0.200
     7.020   102.125     0.200
     8.064   116.125     0.200
     8.387   118.525     0.200
     8.453   121.485     0.200
     8.512   121.125     0.200
     8.690   121.925     0.200
     8.704   125.125     0.200
     8.740   124.625     0.200
     8.905   128.025     0.200
    10.287   145.325     0.200
    11.761   167.925     0.200
    11.973   165.574     0.200
     0.236     7.695     0.200
     0.543    11.074     0.200
     0.908    17.496     0.200
     0.986    18.496     0.200
     0.980    18.395     0.200
     0.995    18.797     0.200
     1.004    19.098     0.200
     1.086    20.496     0.200
     1.111    20.695     0.200
     1.084    20.098     0.200
     1.118    20.996     0.200
     1.122    20.797     0.200
     1.311    22.797     0.200
     1.425    26.496     0.200
     3.694    56.445     0.200
     3.760    58.895     0.200
     3.886    59.695     0.200
     3.956    61.297     0.200
     4.223    62.996     0.200
     4.281    63.297     0.200
     4.319    63.797     0.200
     4.360    64.496     0.200
     4.428    65.797     0.200
     4.498    66.195     0.200
     4.732    70.297     0.200
     4.743    69.695     0.200
     4.861    72.098     0.200
     4.870    71.695     0.200
     4.915    72.598     0.200
     5.062    74.996     0.200
     5.308    76.797     0.200
     5.557    80.496     0.200
     5.836    84.797     0.200
     5.928    86.297     0.200
     5.944    87.098     0.200
     5.950    87.496     0.200
     6.027    88.098     0.200
     6.231    91.297     0.200
     6.550    95.395     0.200
     6.816    97.797     0.200
     6.875    98.996     0.200
     6.964   101.195     0.200
     7.027   101.996     0.200
     7.041   102.496     0.200
     7.126   104.098     0.200
     7.781   112.285     0.200
     8.216   117.797     0.200
     8.463   119.266     0.200
     8.564   121.098     0.200
     8.643   122.695     0.200
     8.823   126.895     0.200
     8.843   123.797     0.200
    10.107   142.496     0.200
    10.161   147.395     0.200
    11.772   167.996     0.200
    12.062   167.938     0.200
     1.193    21.561     0.200
     1.366    23.851     0.200
     1.408    24.751     0.200
     2.406    38.411     0.200
     2.815    46.201     0.200
     3.452    55.031     0.200
     4.142    61.681     0.200
     4.216    62.511     0.200
     4.282    63.891     0.200
     4.166    63.751     0.200
     4.346    64.701     0.200
     4.405    64.971     0.200
     4.656    68.091     0.200
     4.776    70.111     0.200
     4.973    73.091     0.200
     5.132    73.521     0.200
     5.154    73.771     0.200
     5.713    82.081     0.200
     5.845    85.041     0.200
     6.155    89.361     0.200
     6.575    95.271     0.200
     6.941   101.391     0.200
     7.725   113.281     0.200
     8.388   118.481     0.200
     8.558   120.901     0.200
     8.751   125.401     0.200
     8.952   126.301     0.200
     9.898   139.851     0.200
    10.258   146.301     0.200
    10.334   146.001     0.200
    10.411   149.201     0.200
    10.645   151.641     0.200
    11.802   167.201     0.200
    11.847   166.791     0.200
    12.018   165.651     0.200
     1.362    24.038     0.200
     1.397    25.058     0.200
     1.401    24.948     0.200
     1.424    25.398     0.200
     1.438    25.748     0.200
     1.502    27.368     0.200
     1.533    27.208     0.200
     1.552    26.668     0.200
     1.585    27.358     0.200
     1.699    29.248     0.200
     1.886    33.228     0.200
     2.178    35.158     0.200
     2.285    36.928     0.200
     2.619    43.318     0.200
     2.771    45.518     0.200
     2.991    48.528     0.200
     3.015    49.058     0.200
     3.656    57.778     0.200
     3.988    60.408     0.200
     4.071    61.098     0.200
     4.131    62.078     0.200
     4.192    62.748     0.200
     4.245    63.368     0.200
     4.239    65.058     0.200
     4.499    66.468     0.200
     4.371    66.968     0.200
     4.648    68.898     0.200
     4.668    68.958     0.200
     4.814    71.318     0.200
     4.946    71.458     0.200
     4.967    71.248     0.200
     5.287    77.388     0.200
     5.689    83.758     0.200
     6.002    87.658     0.200
     6.356    92.548     0.200
     6.425    93.638     0.200
     6.596    95.088     0.200
     6.708    97.168     0.200
     6.795    99.428     0.200
     8.228   117.538     0.200
     8.399   119.148     0.200
     8.401   120.318     0.200
     8.568   122.368     0.200
     8.598   123.048     0.200
     8.795   125.328     0.200
     8.896   126.748     0.200
     9.722   137.658     0.200
    10.168   144.148     0.200
    10.254   146.448     0.200
    10.507   147.068     0.200
    10.616   152.408     0.200
    11.714   166.748     0.200
    11.708   165.408     0.200
    11.879   164.248     0.200
    16.622   231.248     0.200
    18.188   248.473     0.200
     2.428    38.735     0.200
     2.505    40.475     0.200
     4.298    64.365     0.200
     4.363    65.085     0.200
     4.502    67.585     0.200
     4.568    67.835     0.200
     5.325    78.225     0.200
     7.087   104.055     0.200
     7.867   114.825     0.200
     7.974   116.065     0.200
     8.578   121.815     0.200
     8.617   122.675     0.200
    10.077   142.595     0.200
    10.245   145.025     0.200
    10.780   153.355     0.200
    11.551   163.425     0.200
    11.887   167.925     0.200
    12.154   167.815     0.200
    17.039   237.045     0.200
     2.855    47.766     0.200
     3.408    55.156     0.200
     3.425    55.016     0.200
     3.478    55.680     0.200
     3.535    57.008     0.200
     3.552    56.938     0.200
     4.763    71.406     0.200
     4.821    72.141     0.200
     4.858    72.727     0.200
     4.900    73.547     0.200
     4.967    74.578     0.200
     4.969    74.156     0.200
     5.036    75.180     0.200
     5.401    79.977     0.200
     5.411    80.578     0.200
     5.601    83.211     0.200
     5.798    84.570     0.200
     5.820    85.289     0.200
     6.047    88.945     0.200
     6.096    89.656     0.200
     7.112   104.195     0.200
     7.117   104.609     0.200
     7.343   107.492     0.200
     7.544   111.047     0.200
     7.568   110.570     0.200
     7.667   112.539     0.200
     7.732   112.906     0.200
     8.322   121.172     0.200
     8.476   121.797     0.200
     8.752   126.000     0.200
     8.974   129.086     0.200
     9.091   129.570     0.200
     9.183   132.492     0.200
     9.689   138.047     0.200
     9.770   137.828     0.200
     9.852   140.195     0.200
     9.796   143.492     0.200
    10.373   145.891     0.200
    10.491   149.992     0.200
    10.696   151.109     0.200
    10.948   155.219     0.200
    11.204   157.133     0.200
    11.519   162.852     0.200
    11.617   164.617     0.200
    11.772   165.680     0.200
    11.953   168.633     0.200
    12.189   173.539     0.200
    12.282   174.789     0.200
    12.601   175.641     0.200
     1.126    20.791     0.200
     1.176    21.932     0.200
     1.177    21.801     0.200
     1.209    22.471     0.200
     1.309    24.422     0.200
     1.314    23.070     0.200
     1.488    26.320     0.200
     1.649    29.832     0.200
     4.089    61.832     0.200
     4.013    62.320     0.200
     4.159    62.820     0.200
     4.180    62.650     0.200
     4.061    63.252     0.200
     4.229    63.801     0.200
     4.114    63.820     0.200
     4.291    64.211     0.200
     4.294    63.621     0.200
     4.356    65.361     0.200
     4.743    70.602     0.200
     4.923    72.922     0.200
     5.104    72.820     0.200
     5.127    73.621     0.200
     5.381    78.621     0.200
     5.417    79.451     0.200
     5.674    82.771     0.200
     5.794    85.092     0.200
     5.830    85.381     0.200
     6.448    94.480     0.200
     6.722    96.521     0.200
     6.744    97.721     0.200
     6.884   101.752     0.200
     7.666   111.400     0.200
     7.762   112.641     0.200
     8.414   120.701     0.200
     8.508   122.521     0.200
     8.900   127.320     0.200
     9.859   139.941     0.200
    10.162   145.422     0.200
    10.389   149.881     0.200
    11.633   165.541     0.200
    11.723   167.221     0.200
    11.783   166.422     0.200
    11.956   166.271     0.200
    12.495   175.621     0.200
    14.618   204.502     0.200
    15.916   220.012     0.200
    16.821   232.221     0.200
     1.155    22.223     0.200
     2.983    49.793     0.200
     3.466    55.943     0.200
     3.466    55.413     0.200
     3.541    57.183     0.200
     4.539    68.423     0.200
     4.597    69.873     0.200
     4.635    69.843     0.200
     4.676    70.493     0.200
     4.743    71.853     0.200
     4.746    70.853     0.200
     4.813    72.293     0.200
     5.059    75.873     0.200
     5.187    77.633     0.200
     5.378    80.343     0.200
     5.587    80.553     0.200
     5.610    81.903     0.200
     5.713    85.423     0.200
     5.822    86.283     0.200
     5.873    86.393     0.200
     5.976    88.583     0.200
     6.147    91.193     0.200
     6.244    92.553     0.200
     6.254    92.633     0.200
     6.259    92.753     0.200
     6.275    92.563     0.200
     6.342    93.623     0.200
     6.547    96.503     0.200
     6.831   100.553     0.200
     6.893   101.393     0.200
     7.122   103.683     0.200
     7.188   104.273     0.200
     7.280   107.143     0.200
     7.343   107.973     0.200
     7.357   108.963     0.200
     7.441   109.673     0.200
     7.515   109.863     0.200
     8.096   117.383     0.200
     8.220   119.563     0.200
     8.256   118.793     0.200
     8.530   123.133     0.200
     8.734   125.493     0.200
     8.758   126.643     0.200
     8.790   126.073     0.200
     8.837   129.363     0.200
     8.959   128.913     0.200
     9.139   131.433     0.200
     9.139   132.863     0.200
     9.157   130.823     0.200
     9.350   133.233     0.200
     9.466   135.443     0.200
     9.546   136.493     0.200
     9.775   138.003     0.200
     9.956   141.913     0.200
     9.938   144.243     0.200
     9.938   144.363     0.200
    10.105   143.463     0.200
    10.585   150.763     0.200
    10.732   152.323     0.200
    10.746   153.163     0.200
    11.002   156.183     0.200
    11.268   159.963     0.200
    11.267   159.493     0.200
    11.380   161.373     0.200
    11.611   165.023     0.200
    11.746   166.513     0.200
    11.746   166.353     0.200
    11.976   170.223     0.200
    12.066   171.903     0.200
    12.195   171.303     0.200
    12.195   170.893     0.200
    12.195   174.163     0.200
    12.377   173.803     0.200
    12.376   173.763     0.200
    12.960   181.723     0.200
    13.871   195.773     0.200
    14.473   204.663     0.200
    15.021   210.663     0.200
    15.521   218.403     0.200
    19.508   267.663     0.200
     3.578    54.617     0.200
     5.648    81.188     0.200
     7.292   106.088     0.200
     9.062   128.787     0.200
     9.253   132.287     0.200
    10.046   144.688     0.200
    10.400   146.217     0.200
    10.838   152.887     0.200
    11.141   157.127     0.200
    11.857   166.486     0.200
    12.258   173.188     0.200
    12.357   172.088     0.200
    12.514   173.736     0.200
    15.683   217.867     0.200
    15.683   218.637     0.200
     0.363     9.844     0.200
     0.844    16.773     0.200
     0.808    16.383     0.200
     0.879    17.562     0.200
     0.976    19.031     0.200
     1.156    20.961     0.200
     1.027    19.531     0.200
     1.022    18.961     0.200
     1.337    25.023     0.200
     1.693    30.000     0.200
     2.211    34.719     0.200
     2.031    34.602     0.200
     2.108    35.484     0.200
     2.252    37.180     0.200
     2.406    39.820     0.200
     2.429    39.852     0.200
     2.505    40.867     0.200
     3.285    50.992     0.200
     3.295    51.500     0.200
     3.691    56.281     0.200
     4.113    61.344     0.200
     3.749    57.578     0.200
     4.213    62.789     0.200
     3.875    59.500     0.200
     4.248    63.414     0.200
     4.395    65.117     0.200
     4.755    70.188     0.200
     5.215    74.578     0.200
     5.329    77.023     0.200
     5.890    86.234     0.200
     6.666    95.742     0.200
     6.778    97.273     0.200
     6.881   100.422     0.200
     6.918   101.117     0.200
     7.655   111.258     0.200
     7.798   112.000     0.200
     8.278   117.344     0.200
     8.531   122.641     0.200
     8.743   123.680     0.200
     8.920   126.992     0.200
     8.614   124.609     0.200
     9.242   130.211     0.200
     9.347   131.789     0.200
     9.643   134.773     0.200
     9.923   140.609     0.200
     9.927   139.820     0.200
     9.962   139.391     0.200
    10.147   144.742     0.200
    11.312   159.602     0.200
    11.610   164.438     0.200
    11.745   165.094     0.200
    11.929   165.438     0.200
    13.981   194.672     0.200
    15.626   215.492     0.200
    15.626   217.781     0.200
    16.999   233.766     0.200
    16.999   234.109     0.200
     1.197    22.000     0.200
     1.189    21.750     0.200
     1.211    22.398     0.200
     1.296    24.289     0.200
     1.320    24.219     0.200
     1.266    22.500     0.200
     1.314    23.672     0.200
     1.315    23.531     0.200
     1.521    26.938     0.200
     1.617    29.312     0.200
     1.908    33.055     0.200
     2.392    38.719     0.200
     2.467    39.648     0.200
     2.677    44.281     0.200
     2.673    44.672     0.200
     2.699    44.867     0.200
     3.434    54.555     0.200
     3.448    55.031     0.200
     3.479    55.539     0.200
     3.819    59.773     0.200
     3.890    60.930     0.200
     3.963    61.344     0.200
     4.017    62.898     0.200
     4.247    63.438     0.200
     4.317    64.734     0.200
     4.338    64.703     0.200
     4.448    66.141     0.200
     4.513    67.070     0.200
     4.758    71.117     0.200
     4.763    69.914     0.200
     4.901    72.391     0.200
     5.080    75.109     0.200
     5.252    75.211     0.200
     5.252    76.172     0.200
     5.431    83.062     0.200
     6.584    96.617     0.200
     6.877   100.664     0.200
     7.042   103.312     0.200
     7.070   103.648     0.200
     7.674   111.734     0.200
     7.825   114.164     0.200
     7.918   114.062     0.200
     8.495   122.531     0.200
     9.058   130.484     0.200
     9.709   137.320     0.200
     9.850   139.812     0.200
    10.012   141.641     0.200
    10.570   152.328     0.200
    10.653   153.539     0.200
    10.980   154.805     0.200
    11.785   166.539     0.200
    11.875   169.289     0.200
    11.941   166.758     0.200
    12.115   168.719     0.200
    12.115   167.312     0.200
    12.650   177.820     0.200
    14.095   196.742     0.200
    14.776   206.852     0.200
    15.849   220.562     0.200
     1.185    22.074     0.200
     1.315    24.281     0.200
     1.378    25.145     0.200
     2.038    33.684     0.200
     1.937    34.305     0.200
     2.333    40.762     0.200
     2.335    40.434     0.200
     3.326    54.844     0.200
     3.474    56.602     0.200
     3.499    57.953     0.200
     3.804    60.613     0.200
     3.881    62.473     0.200
     4.008    64.113     0.200
     4.711    69.922     0.200
     5.338    78.293     0.200
     6.289    95.121     0.200
    10.283   147.602     0.200
    11.364   160.895     0.200
    12.237   169.844     0.200
    12.373   176.082     0.200
    12.787   182.293     0.200
    13.608   192.582     0.200
    13.991   197.512     0.200
     1.255    22.578     0.200
     1.313    23.688     0.200
     1.332    24.055     0.200
     1.430    24.797     0.200
     1.466    25.906     0.200
     1.471    25.727     0.200
     1.799    29.672     0.200
     2.080    35.742     0.200
     2.269    38.680     0.200
     2.289    38.828     0.200
     2.486    41.320     0.200
     2.488    41.172     0.200
     2.774    45.906     0.200
     3.708    55.695     0.200
     3.471    55.070     0.200
     4.114    61.945     0.200
     4.202    62.805     0.200
     4.072    63.609     0.200
     4.381    65.570     0.200
     4.375    65.008     0.200
     4.473    67.406     0.200
     4.465    65.188     0.200
     5.090    73.445     0.200
     5.411    79.469     0.200
     6.355    94.992     0.200
     6.804    99.352     0.200
     6.917    99.742     0.200
     7.702   112.539     0.200
     8.358   120.195     0.200
     8.502   123.055     0.200
     8.923   126.359     0.200
     9.122   131.781     0.200
     9.606   136.297     0.200
     9.861   140.320     0.200
     9.932   140.469     0.200
    10.251   144.148     0.200
    10.625   149.586     0.200
    10.472   149.852     0.200
    11.116   156.000     0.200
    11.997   165.461     0.200
    12.976   182.477     0.200
    13.744   192.578     0.200
    13.951   196.867     0.200
    16.023   225.086     0.200
    16.023   224.625     0.200
     1.337    25.641     0.200
     1.331    25.352     0.200
     1.553    29.156     0.200
     1.566    28.922     0.200
     1.552    28.562     0.200
     2.222    39.000     0.200
     2.433    42.711     0.200
     2.930    49.531     0.200
     3.808    59.281     0.200
     3.705    61.453     0.200
     3.897    60.664     0.200
     4.070    62.492     0.200
     4.185    63.055     0.200
     4.201    65.984     0.200
     4.350    68.992     0.200
     4.803    71.922     0.200
     6.611    99.773     0.200
     7.494   110.375     0.200
     8.818   129.523     0.200
    11.403   163.391     0.200
    11.505   168.062     0.200
    11.691   164.195     0.200
    13.439   191.141     0.200
    13.649   193.461     0.200
     1.228    23.146     0.200
     1.260    23.566     0.200
     1.246    22.945     0.200
     1.469    26.486     0.200
     1.486    26.396     0.200
     1.869    30.955     0.200
     2.160    36.496     0.200
     2.880    47.135     0.200
     2.905    47.635     0.200
     3.132    49.295     0.200
     3.206    50.945     0.200
     3.796    58.055     0.200
     3.980    60.846     0.200
     3.994    60.736     0.200
     3.835    58.805     0.200
     4.073    62.465     0.200
     4.157    60.816     0.200
     4.169    65.086     0.200
     4.377    66.785     0.200
     4.317    66.666     0.200
     4.352    66.975     0.200
     5.807    86.705     0.200
     6.082    89.945     0.200
     6.249    92.055     0.200
     6.382    95.166     0.200
     6.517    97.016     0.200
     6.545    96.615     0.200
     6.641    98.066     0.200
     7.974   116.496     0.200
     8.536   123.535     0.200
     8.706   127.816     0.200
    10.732   152.535     0.200
    11.230   161.535     0.200
    11.590   159.836     0.200
    11.590   162.975     0.200
    13.579   191.615     0.200
    17.915   245.535     0.200
     2.864    46.562     0.200
     2.871    46.841     0.200
     2.918    48.001     0.200
     3.220    51.301     0.200
     3.369    53.241     0.200
     3.426    54.441     0.200
     3.486    54.921     0.200
     4.144    64.161     0.200
     4.822    73.301     0.200
     5.007    75.031     0.200
     5.051    75.151     0.200
     5.115    76.441     0.200
     5.135    77.241     0.200
     5.228    76.271     0.200
     5.838    87.611     0.200
     5.840    84.321     0.200
     5.840    85.321     0.200
     6.049    89.461     0.200
     6.491    95.781     0.200
     6.498    96.121     0.200
     6.777    99.731     0.200
     7.058   103.481     0.200
     7.112   104.451     0.200
     7.312   107.171     0.200
     7.430   107.011     0.200
     7.535   109.731     0.200
     7.543   111.101     0.200
     7.564   110.501     0.200
     7.719   110.461     0.200
     8.061   118.091     0.200
     8.242   119.661     0.200
     8.282   121.071     0.200
     8.317   122.241     0.200
     8.499   122.042     0.200
     8.630   125.101     0.200
     8.906   128.321     0.200
     8.946   128.651     0.200
     9.023   130.221     0.200
     9.581   135.321     0.200
     9.673   140.851     0.200
     9.692   141.121     0.200
     9.884   140.741     0.200
     9.900   139.792     0.200
    10.283   145.011     0.200
    10.539   150.331     0.200
    10.575   149.841     0.200
    10.621   150.812     0.200
    10.822   156.101     0.200
    10.980   154.881     0.200
    11.215   157.121     0.200
    11.666   167.531     0.200
    11.780   165.321     0.200
    12.404   172.521     0.200
    12.590   174.671     0.200
    12.702   178.681     0.200
    13.866   194.062     0.200
    14.126   199.321     0.200
    14.400   200.562     0.200
    14.638   204.661     0.200
    14.730   207.421     0.200
    14.894   209.591     0.200
    16.911   236.021     0.200
    19.751   270.299     0.200
     1.504    26.562     0.200
     1.686    28.742     0.200
     1.740    29.922     0.200
     1.708    30.750     0.200
     1.900    33.180     0.200
     1.902    33.094     0.200
     2.262    38.156     0.200
     2.279    38.602     0.200
     2.905    47.500     0.200
     3.021    49.227     0.200
     3.078    50.094     0.200
     3.390    53.883     0.200
     3.463    54.461     0.200
     3.535    55.570     0.200
     3.589    56.516     0.200
     4.009    61.211     0.200
     4.081    62.125     0.200
     4.695    70.570     0.200
     4.796    71.602     0.200
     5.018    72.930     0.200
     5.628    81.500     0.200
     5.884    86.461     0.200
     7.332   107.695     0.200
     9.470   136.727     0.200
    10.780   153.797     0.200
    10.766   152.172     0.200
    12.383   172.344     0.200
    13.673   191.484     0.200
    14.425   202.742     0.200
     0.368    10.034     0.200
     0.807    16.364     0.200
     0.841    16.834     0.200
     0.864    17.184     0.200
     0.945    18.864     0.200
     1.026    19.574     0.200
     1.037    19.494     0.200
     1.230    21.694     0.200
     1.285    23.084     0.200
     1.379    24.194     0.200
     1.771    29.174     0.200
     1.693    29.024     0.200
     1.904    32.744     0.200
     2.209    35.004     0.200
     2.108    35.154     0.200
     2.110    34.994     0.200
     2.291    36.294     0.200
     2.406    39.824     0.200
     2.499    41.304     0.200
     2.501    41.244     0.200
     3.190    50.214     0.200
     3.295    51.634     0.200
     3.319    51.884     0.200
     3.358    53.274     0.200
     3.556    53.894     0.200
     3.692    56.394     0.200
     3.750    57.724     0.200
     3.825    58.484     0.200
     3.875    60.554     0.200
     4.159    62.084     0.200
     4.343    64.504     0.200
     4.392    65.094     0.200
     4.474    66.904     0.200
     4.616    66.614     0.200
     4.752    69.854     0.200
     4.715    71.424     0.200
     4.791    71.875     0.200
     5.213    74.809     0.200
     5.385    78.794     0.200
     5.330    78.974     0.200
     5.888    86.375     0.200
     6.661    96.614     0.200
     6.776    97.444     0.200
     6.870    99.934     0.200
     6.878    99.474     0.200
     6.999   101.544     0.200
     7.064   101.154     0.200
     7.577   109.194     0.200
     7.618   109.484     0.200
     7.796   111.514     0.200
     7.846   111.464     0.200
     7.966   113.784     0.200
     8.275   117.584     0.200
     8.299   117.774     0.200
     8.361   119.754     0.200
     8.435   120.344     0.200
     8.614   124.314     0.200
     8.740   123.724     0.200
     9.015   128.414     0.200
     9.345   131.844     0.200
     9.431   132.125     0.200
     9.488   136.014     0.200
     9.546   134.604     0.200
     9.725   137.264     0.200
     9.709   138.264     0.200
     9.727   138.334     0.200
     9.880   141.614     0.200
     9.800   139.584     0.200
     9.925   139.444     0.200
     9.960   140.554     0.200
    10.063   141.364     0.200
     9.999   142.334     0.200
    10.325   146.554     0.200
    10.336   145.134     0.200
    10.491   148.444     0.200
    10.540   147.734     0.200
    10.553   150.164     0.200
    10.886   153.514     0.200
    11.117   154.984     0.200
    11.224   158.644     0.200
    11.504   162.274     0.200
    11.577   161.574     0.200
    11.637   163.194     0.200
    11.735   165.464     0.200
    11.743   165.134     0.200
    11.830   166.294     0.200
    11.927   164.834     0.200
    12.636   177.284     0.200
    13.225   185.344     0.200
    13.737   190.744     0.200
    13.979   195.304     0.200
    14.304   199.644     0.200
    16.998   234.084     0.200
     0.429     9.944     0.200
     0.857    16.404     0.200
     0.904    17.544     0.200
     0.905    17.554     0.200
     0.924    17.974     0.200
     0.936    18.104     0.200
     1.060    18.924     0.200
     1.083    19.624     0.200
     1.327    23.804     0.200
     1.384    25.454     0.200
     1.486    25.904     0.200
     1.503    26.334     0.200
     1.793    29.004     0.200
     1.910    31.654     0.200
     2.066    34.764     0.200
     2.141    35.454     0.200
     2.320    36.604     0.200
     2.397    37.864     0.200
     2.529    41.234     0.200
     2.528    41.414     0.200
     2.553    41.734     0.200
     2.888    43.004     0.200
     3.213    50.184     0.200
     3.320    51.894     0.200
     3.341    51.674     0.200
     3.382    52.554     0.200
     3.584    54.534     0.200
     3.613    55.204     0.200
     3.658    55.644     0.200
     3.712    56.284     0.200
     3.773    57.664     0.200
     3.936    59.524     0.200
     3.893    56.864     0.200
     3.972    59.904     0.200
     4.371    64.964     0.200
     4.413    65.084     0.200
     4.477    66.424     0.200
     4.497    66.594     0.200
     4.652    69.494     0.200
     4.617    66.804     0.200
     4.713    71.104     0.200
     4.778    70.834     0.200
     4.842    73.264     0.200
     5.219    74.449     0.200
     5.219    73.974     0.200
     5.219    74.554     0.200
     5.219    74.174     0.200
     5.346    78.604     0.200
     5.360    78.214     0.200
     5.413    79.524     0.200
     5.416    78.734     0.200
     5.470    79.604     0.200
     5.838    85.234     0.200
     5.848    86.144     0.200
     5.869    85.974     0.200
     5.875    86.304     0.200
     5.948    87.554     0.200
     5.930    86.864     0.200
     6.139    89.424     0.200
     6.476    94.214     0.200
     6.704    96.394     0.200
     6.720    96.914     0.200
     6.908    99.524     0.200
     6.945   101.314     0.200
     6.992   102.334     0.200
     7.029   102.894     0.200
     7.082   100.464     0.200
     7.609   109.954     0.200
     7.647   110.574     0.200
     7.678   111.024     0.200
     7.683   109.744     0.200
     7.818   111.064     0.200
     7.863   112.134     0.200
     7.998   114.994     0.200
     8.284   118.144     0.200
     8.324   118.524     0.200
     8.348   118.394     0.200
     8.385   120.044     0.200
     8.499   120.334     0.200
     8.637   123.584     0.200
     8.760   123.484     0.200
     8.943   126.444     0.200
     9.054   130.564     0.200
     9.063   128.004     0.200
     9.170   129.764     0.200
     9.370   131.864     0.200
     9.528   135.624     0.200
     9.563   134.424     0.200
     9.653   135.114     0.200
     9.734   139.244     0.200
     9.672   136.414     0.200
     9.752   139.074     0.200
     9.713   136.564     0.200
     9.748   137.634     0.200
     9.825   139.264     0.200
     9.883   140.374     0.200
     9.918   140.144     0.200
     9.996   140.804     0.200
    10.048   141.314     0.200
    10.081   140.814     0.200
    10.357   143.774     0.200
    10.348   144.574     0.200
    10.365   146.474     0.200
    10.562   150.354     0.200
    10.569   146.374     0.200
    10.587   147.104     0.200
    11.142   154.894     0.200
    11.222   157.534     0.200
    11.291   159.944     0.200
    11.398   157.454     0.200
    11.613   159.754     0.200
    11.670   161.354     0.200
    11.749   161.754     0.200
    11.779   163.284     0.200
    11.779   164.074     0.200
    11.962   163.514     0.200
    11.961   164.476     0.200
    11.961   164.474     0.200
    11.996   168.074     0.200
    12.065   168.864     0.200
    12.664   178.154     0.200
    12.781   178.144     0.200
    13.271   184.524     0.200
    13.763   188.934     0.200
    14.000   193.694     0.200
    14.301   200.524     0.200
    15.565   216.064     0.200
    15.868   220.894     0.200
    16.989   234.749     0.200
     0.947    18.733     0.200
     1.034    19.893     0.200
     1.047    20.133     0.200
     1.152    22.033     0.200
     1.664    28.533     0.200
     1.950    31.613     0.200
     2.488    39.743     0.200
     2.570    41.263     0.200
     2.952    45.403     0.200
     3.190    51.943     0.200
     3.747    57.183     0.200
     3.769    57.723     0.200
     3.980    59.523     0.200
     4.535    68.043     0.200
     4.562    67.903     0.200
     4.634    69.043     0.200
     4.651    69.793     0.200
     4.720    68.823     0.200
     5.333    77.038     0.200
     5.333    76.393     0.200
     5.299    80.443     0.200
     5.574    82.913     0.200
     6.054    90.613     0.200
     6.893    99.353     0.200
     7.073   104.783     0.200
     7.225   102.773     0.200
     7.818   113.023     0.200
     7.852   110.903     0.200
     7.968   114.313     0.200
     8.002   114.753     0.200
     8.169   117.603     0.200
     8.539   121.143     0.200
     8.521   121.663     0.200
     8.544   122.033     0.200
     8.904   127.103     0.200
     9.236   133.573     0.200
     9.702   137.483     0.200
     9.899   139.643     0.200
    10.098   145.043     0.200
    10.173   144.863     0.200
    10.222   144.253     0.200
    10.732   151.643     0.200
    11.493   161.553     0.200
    12.135   166.913     0.200
    12.135   166.913     0.200
     0.468    10.276     0.200
     0.938    17.686     0.200
     0.957    17.996     0.200
     1.108    19.816     0.200
     1.356    23.906     0.200
     1.451    25.036     0.200
     1.512    26.026     0.200
     1.531    26.646     0.200
     1.409    25.816     0.200
     1.812    29.226     0.200
     1.925    32.406     0.200
     2.082    35.136     0.200
     2.092    34.966     0.200
     2.342    37.176     0.200
     2.157    35.816     0.200
     2.421    38.646     0.200
     2.540    41.486     0.200
     2.542    41.286     0.200
     2.885    42.866     0.200
     3.179    50.126     0.200
     3.222    50.376     0.200
     3.330    52.016     0.200
     3.558    54.586     0.200
     3.350    52.966     0.200
     3.895    56.976     0.200
     3.719    56.536     0.200
     3.781    57.886     0.200
     3.944    59.746     0.200
     3.980    59.896     0.200
     4.393    64.896     0.200
     4.430    65.226     0.200
     4.497    66.536     0.200
     4.516    67.206     0.200
     4.623    66.156     0.200
     4.658    69.116     0.200
     5.228    74.586     0.200
     5.434    79.096     0.200
     5.489    79.926     0.200
     5.980    87.826     0.200
     6.734    96.766     0.200
     7.098   101.386     0.200
     7.878   112.096     0.200
     8.404   119.336     0.200
     8.380   118.746     0.200
     8.776   124.246     0.200
    10.096   142.926     0.200
    10.393   147.446     0.200
    11.332   161.166     0.200
    11.986   165.535     0.200
    11.986   165.536     0.200
     1.117    21.676     0.200
     1.303    24.307     0.200
     1.345    23.826     0.200
     1.646    29.117     0.200
     1.704    30.166     0.200
     2.160    35.326     0.200
     2.195    35.986     0.200
     2.231    35.807     0.200
     2.279    39.018     0.200
     2.982    47.816     0.200
     3.062    49.256     0.200
     3.108    49.637     0.200
     3.135    50.357     0.200
     3.475    53.617     0.200
     3.500    53.996     0.200
     3.527    55.357     0.200
     3.608    56.018     0.200
     3.715    57.387     0.200
     3.743    57.727     0.200
     4.089    60.848     0.200
     4.162    63.297     0.200
     4.297    63.916     0.200
     4.305    64.518     0.200
     4.444    67.037     0.200
     4.492    68.707     0.200
     4.588    70.826     0.200
     5.157    76.197     0.200
     5.204    77.426     0.200
     6.658    98.787     0.200
     6.772   100.717     0.200
     7.760   110.227     0.200
     8.353   121.676     0.200
     8.677   127.287     0.200
     9.167   129.637     0.200
     9.416   136.166     0.200
     9.569   136.316     0.200
     9.600   135.566     0.200
     9.648   138.617     0.200
     9.956   139.537     0.200
    10.261   146.467     0.200
    10.313   147.057     0.200
    10.933   153.467     0.200
    11.427   163.076     0.200
    11.427   163.836     0.200
    11.633   162.387     0.200
    11.845   168.086     0.200
    12.305   175.467     0.200
    12.797   183.357     0.200
    13.533   188.926     0.200
    13.829   192.307     0.200
    18.013   246.137     0.200
     0.343     9.152     0.200
     0.795    15.750     0.200
     0.822    16.812     0.200
     0.847    17.000     0.200
     0.926    18.883     0.200
     1.015    19.191     0.200
     1.027    19.051     0.200
     1.194    21.289     0.200
     1.265    22.723     0.200
     1.325    24.770     0.200
     1.434    24.871     0.200
     1.445    25.281     0.200
     1.756    28.230     0.200
     2.026    34.371     0.200
     2.042    34.441     0.200
     2.103    35.012     0.200
     2.192    34.789     0.200
     2.403    39.332     0.200
     2.495    40.352     0.200
     3.189    49.949     0.200
     3.294    51.172     0.200
     3.357    52.250     0.200
     3.749    57.430     0.200
     3.916    59.262     0.200
     3.951    59.512     0.200
     4.327    64.199     0.200
     4.359    65.172     0.200
     4.378    64.449     0.200
     4.436    65.992     0.200
     4.460    66.172     0.200
     4.619    68.031     0.200
     4.608    66.531     0.200
     4.694    70.480     0.200
     4.737    70.152     0.200
     4.716    71.051     0.200
     4.819    73.109     0.200
     5.204    74.812     0.200
     5.325    77.402     0.200
     5.331    79.141     0.200
     5.369    78.633     0.200
     5.383    78.031     0.200
     5.434    79.211     0.200
     5.798    84.609     0.200
     5.813    84.512     0.200
     5.829    84.891     0.200
     5.835    85.383     0.200
     6.431    93.383     0.200
     6.640    96.199     0.200
     6.686    95.883     0.200
     6.861    99.109     0.200
     6.882    99.531     0.200
     6.944   100.902     0.200
     7.556   109.133     0.200
     7.559   109.121     0.200
     7.603   109.492     0.200
     7.635   108.910     0.200
     7.782   111.109     0.200
     7.833   111.812     0.200
     7.948   113.941     0.200
     8.252   117.480     0.200
     8.243   117.711     0.200
     8.276   117.211     0.200
     8.276   117.492     0.200
     8.346   117.633     0.200
     8.528   122.570     0.200
     8.864   124.312     0.200
     8.864   124.992     0.200
     8.902   124.410     0.200
     8.902   125.590     0.200
     8.995   129.301     0.200
     9.329   129.512     0.200
     9.467   134.699     0.200
     9.629   134.289     0.200
     9.643   135.730     0.200
     9.684   135.812     0.200
     9.710   135.211     0.200
     9.710   136.461     0.200
     9.725   138.520     0.200
     9.770   139.070     0.200
     9.798   138.922     0.200
     9.860   140.070     0.200
     9.940   140.652     0.200
    10.028   140.031     0.200
    10.049   140.762     0.200
    10.305   145.270     0.200
    10.306   143.012     0.200
    10.324   143.781     0.200
    10.466   148.602     0.200
    10.534   146.812     0.200
    10.740   151.691     0.200
    11.159   156.270     0.200
    11.197   158.480     0.200
    11.344   156.602     0.200
    11.342   158.312     0.200
    11.558   158.340     0.200
    11.618   159.723     0.200
    11.692   161.312     0.200
    11.724   163.512     0.200
    11.724   161.449     0.200
    11.720   162.711     0.200
    11.909   163.652     0.200
    11.908   164.270     0.200
    11.908   163.332     0.200
    12.023   166.359     0.200
    13.726   189.852     0.200
    13.720   189.133     0.200
    13.965   192.930     0.200
    14.298   199.090     0.200
    15.127   211.512     0.200
    15.588   215.070     0.200
    15.885   220.820     0.200
    20.124   270.539     0.200
     0.368     9.379     0.200
     0.791    16.289     0.200
     0.960    18.531     0.200
     1.011    19.660     0.200
     1.006    19.008     0.200
     1.022    19.621     0.200
     1.291    23.371     0.200
     1.320    25.250     0.200
     1.459    25.520     0.200
     1.471    25.891     0.200
     1.677    29.219     0.200
     1.780    28.668     0.200
     2.016    34.629     0.200
     2.031    34.629     0.200
     2.093    35.398     0.200
     2.217    35.051     0.200
     2.309    36.418     0.200
     2.391    39.770     0.200
     2.484    41.090     0.200
     3.175    49.719     0.200
     3.280    51.301     0.200
     3.343    52.398     0.200
     3.565    53.820     0.200
     3.599    55.551     0.200
     3.634    55.500     0.200
     3.810    58.551     0.200
     3.901    59.590     0.200
     3.936    59.961     0.200
     4.351    64.609     0.200
     4.384    65.500     0.200
     4.402    64.930     0.200
     4.461    66.340     0.200
     4.484    67.059     0.200
     4.629    66.059     0.200
     4.643    68.371     0.200
     4.761    70.340     0.200
     4.679    71.219     0.200
     4.700    71.289     0.200
     4.805    73.379     0.200
     5.226    74.059     0.200
     5.349    78.730     0.200
     5.394    78.949     0.200
     5.407    78.609     0.200
     5.458    79.609     0.200
     5.823    85.621     0.200
     5.838    85.609     0.200
     5.853    85.258     0.200
     5.859    85.668     0.200
     6.402    93.781     0.200
     6.666    97.180     0.200
     6.710    95.930     0.200
     6.886    98.809     0.200
     6.969   101.438     0.200
     7.585   109.570     0.200
     7.660   109.508     0.200
     7.806   111.859     0.200
     7.856   111.500     0.200
     7.974   114.590     0.200
     8.267   118.160     0.200
     8.302   117.059     0.200
     8.370   117.949     0.200
     8.514   122.289     0.200
     8.885   124.758     0.200
     8.926   124.758     0.200
     9.021   128.988     0.200
     9.493   135.008     0.200
     9.652   134.359     0.200
     9.734   136.160     0.200
     9.886   139.848     0.200
     9.935   138.859     0.200
     9.966   140.219     0.200
    10.050   140.609     0.200
    10.073   140.680     0.200
    10.331   146.078     0.200
    10.331   143.461     0.200
    10.483   148.609     0.200
    10.559   148.160     0.200
    10.765   151.781     0.200
    10.895   152.488     0.200
    11.126   154.660     0.200
    11.185   156.238     0.200
    11.218   159.039     0.200
    11.369   156.770     0.200
    11.364   158.859     0.200
    11.584   159.121     0.200
    11.644   160.258     0.200
    11.718   161.711     0.200
    11.749   162.359     0.200
    11.749   161.578     0.200
    11.744   162.461     0.200
    11.934   164.059     0.200
    11.934   164.059     0.200
    11.934   164.059     0.200
    12.048   167.711     0.200
    13.229   184.559     0.200
    13.745   189.719     0.200
    13.751   188.398     0.200
    13.989   193.988     0.200
    14.318   199.738     0.200
    15.119   211.059     0.200
    15.119   210.531     0.200
    15.602   216.578     0.200
    15.901   221.449     0.200
    19.346   264.086     0.200
    20.139   270.859     0.200
     1.496    25.602     0.200
     1.657    27.781     0.200
     1.674    28.102     0.200
     1.962    31.219     0.200
     2.410    37.602     0.200
     2.504    38.867     0.200
     2.570    39.906     0.200
     3.755    56.508     0.200
     4.542    67.008     0.200
     4.581    67.398     0.200
     4.647    68.586     0.200
     4.666    69.570     0.200
     4.770    68.602     0.200
     4.949    73.562     0.200
     5.376    77.836     0.200
     5.528    81.039     0.200
     6.873    98.797     0.200
     7.079   103.039     0.200
     7.854   112.945     0.200
     8.029   114.852     0.200
     8.489   120.430     0.200
     8.513   121.258     0.200
     8.555   123.102     0.200
     9.036   127.102     0.200
     9.113   129.281     0.200
     9.225   132.219     0.200
     9.698   137.938     0.200
     9.815   139.352     0.200
     9.917   139.492     0.200
    10.089   143.477     0.200
    10.106   143.570     0.200
    10.167   145.258     0.200
    10.208   143.977     0.200
    10.247   143.578     0.200
    10.529   148.992     0.200
    10.536   149.289     0.200
    10.511   148.398     0.200
    10.758   151.219     0.200
    10.967   155.898     0.200
    11.312   158.352     0.200
    11.392   161.609     0.200
    11.411   162.102     0.200
    11.523   162.219     0.200
    11.784   166.133     0.200
    11.841   166.016     0.200
    11.925   167.477     0.200
    11.950   168.742     0.200
    12.133   170.211     0.200
    12.133   168.203     0.200
    12.234   171.469     0.200
    13.438   188.492     0.200
    13.933   194.570     0.200
    14.169   198.086     0.200
    20.288   274.680     0.200
     0.396    10.172     0.200
     0.895    16.617     0.200
     1.114    20.984     0.200
     1.125    20.828     0.200
     1.273    23.039     0.200
     1.424    25.953     0.200
     1.429    25.055     0.200
     1.448    25.508     0.200
     1.732    28.078     0.200
     1.777    30.508     0.200
     2.116    36.164     0.200
     2.192    36.586     0.200
     2.274    36.219     0.200
     2.340    37.203     0.200
     2.339    37.305     0.200
     2.488    41.055     0.200
     2.510    41.477     0.200
     2.581    42.516     0.200
     3.375    53.125     0.200
     3.524    53.953     0.200
     3.553    54.195     0.200
     3.599    54.984     0.200
     3.769    57.625     0.200
     3.828    58.656     0.200
     3.904    59.906     0.200
     3.993    61.297     0.200
     4.029    61.414     0.200
     4.209    62.688     0.200
     4.312    64.234     0.200
     4.337    64.633     0.200
     4.351    64.234     0.200
     4.416    65.273     0.200
     4.436    66.055     0.200
     4.718    69.453     0.200
     5.157    73.016     0.200
     5.157    73.758     0.200
     5.299    78.766     0.200
     5.355    77.766     0.200
     5.352    78.773     0.200
     5.404    79.586     0.200
     5.409    78.812     0.200
     6.417    93.383     0.200
     6.659    93.906     0.200
     6.841    99.398     0.200
     6.848   100.203     0.200
     6.871    99.906     0.200
     7.549   108.742     0.200
     7.551   108.883     0.200
     7.624   108.766     0.200
     7.757   111.719     0.200
     7.940   113.859     0.200
     8.274   117.812     0.200
     8.298   118.016     0.200
     8.608   123.344     0.200
     8.816   123.812     0.200
     8.882   125.219     0.200
     8.998   129.609     0.200
     9.309   129.617     0.200
     9.473   135.195     0.200
     9.590   133.367     0.200
     9.686   135.414     0.200
     9.862   141.164     0.200
     9.878   137.758     0.200
     9.939   140.305     0.200
     9.986   139.047     0.200
    10.019   140.023     0.200
    10.286   144.023     0.200
    10.299   143.719     0.200
    10.310   145.734     0.200
    10.529   149.219     0.200
    11.081   154.219     0.200
    11.168   157.133     0.200
    11.267   160.148     0.200
    11.300   158.617     0.200
    11.341   157.133     0.200
    11.555   159.578     0.200
    11.612   162.094     0.200
    11.695   163.469     0.200
    11.692   162.594     0.200
    11.722   163.414     0.200
    11.903   164.539     0.200
    11.904   164.453     0.200
    12.004   167.609     0.200
    13.219   185.375     0.200
    13.702   189.859     0.200
    13.726   193.625     0.200
    13.939   193.016     0.200
    14.239   199.828     0.200
    15.810   220.656     0.200
    16.929   232.391     0.200
     0.559    12.570     0.200
     0.720    15.141     0.200
     0.727    15.211     0.200
     0.772    14.656     0.200
     0.831    17.414     0.200
     1.450    26.367     0.200
     1.596    28.336     0.200
     1.597    27.898     0.200
     1.667    28.805     0.200
     1.915    32.500     0.200
     1.945    33.016     0.200
     1.959    33.055     0.200
     2.034    34.266     0.200
     2.707    43.141     0.200
     2.878    45.617     0.200
     3.202    49.484     0.200
     3.267    50.727     0.200
     3.393    52.680     0.200
     4.030    60.891     0.200
     4.073    61.781     0.200
     4.202    64.484     0.200
     4.222    64.750     0.200
     4.296    66.469     0.200
     4.699    69.695     0.200
     4.814    71.305     0.200
     4.831    71.609     0.200
     4.882    72.000     0.200
     4.931    73.031     0.200
     4.959    73.781     0.200
     5.119    75.289     0.200
     5.126    73.086     0.200
     5.229    76.977     0.200
     5.624    82.961     0.200
     5.722    81.141     0.200
     5.722    81.336     0.200
     5.888    85.445     0.200
     5.935    86.227     0.200
     6.294    92.148     0.200
     6.302    92.508     0.200
     6.324    92.828     0.200
     6.331    93.070     0.200
     6.589    96.250     0.200
     7.070   101.461     0.200
     7.190   102.820     0.200
     7.270   103.938     0.200
     7.343   106.578     0.200
     7.423   108.047     0.200
     7.556   107.367     0.200
     7.674   111.531     0.200
     8.012   116.844     0.200
     8.077   117.125     0.200
     8.111   117.250     0.200
     8.282   118.836     0.200
     8.422   121.141     0.200
     8.645   122.938     0.200
     8.668   123.039     0.200
     8.734   124.234     0.200
     8.747   123.641     0.200
     8.841   125.391     0.200
     8.885   127.891     0.200
     9.230   133.109     0.200
     9.231   130.727     0.200
     9.293   133.469     0.200
     9.320   133.406     0.200
     9.394   132.039     0.200
     9.382   131.336     0.200
     9.442   135.734     0.200
     9.518   136.891     0.200
     9.523   134.484     0.200
     9.583   137.414     0.200
     9.823   136.938     0.200
     9.907   140.414     0.200
     9.946   142.789     0.200
     9.930   137.898     0.200
    10.208   142.836     0.200
    10.310   146.406     0.200
    10.397   145.969     0.200
    10.422   145.281     0.200
    10.526   149.570     0.200
    10.544   147.391     0.200
    10.556   147.406     0.200
    10.746   151.570     0.200
    10.775   149.836     0.200
    10.837   150.555     0.200
    10.998   153.039     0.200
    11.193   157.469     0.200
    11.389   158.930     0.200
    11.590   162.695     0.200
    11.595   160.938     0.200
    11.804   162.984     0.200
    12.018   165.086     0.200
    12.086   166.406     0.200
    12.144   167.164     0.200
    12.180   167.336     0.200
    12.220   169.516     0.200
    12.372   169.680     0.200
    12.372   169.539     0.200
    12.372   169.898     0.200
    12.514   174.695     0.200
    12.643   178.719     0.200
    13.296   185.625     0.200
    13.612   190.719     0.200
    14.177   198.531     0.200
    14.210   195.820     0.200
    14.465   200.297     0.200
    14.708   205.141     0.200
    14.815   206.320     0.200
    16.074   222.219     0.200
    16.382   227.266     0.200
    16.949   233.070     0.200
    19.791   267.828     0.200
    20.105   270.734     0.200
     1.213    21.750     0.200
     1.273    22.980     0.200
     1.360    23.730     0.200
     1.292    23.330     0.200
     1.378    25.420     0.200
     1.459    25.980     0.200
     1.494    26.209     0.200
     1.424    25.100     0.200
     1.429    24.879     0.200
     1.573    27.430     0.200
     1.613    28.670     0.200
     2.290    36.920     0.200
     2.208    36.449     0.200
     2.455    39.811     0.200
     2.373    39.779     0.200
     2.375    39.471     0.200
     2.445    40.490     0.200
     2.723    44.641     0.200
     2.734    44.561     0.200
     2.810    45.779     0.200
     3.537    54.230     0.200
     3.432    53.770     0.200
     3.475    54.520     0.200
     3.604    54.520     0.200
     3.590    55.689     0.200
     3.963    60.391     0.200
     4.033    61.920     0.200
     4.216    62.629     0.200
     4.160    64.000     0.200
     4.391    65.090     0.200
     4.390    64.959     0.200
     4.478    66.590     0.200
     4.490    65.340     0.200
     4.784    70.680     0.200
     4.959    75.100     0.200
     4.975    75.459     0.200
     5.114    73.209     0.200
     5.114    73.529     0.200
     5.451    79.779     0.200
     5.576    82.240     0.200
     6.314    93.189     0.200
     6.749    96.209     0.200
     6.806    98.840     0.200
     6.928   101.850     0.200
     7.041    99.510     0.200
     7.712   113.510     0.200
     8.373   119.980     0.200
     8.463   121.070     0.200
     8.487   121.010     0.200
     8.767   124.010     0.200
     8.937   127.830     0.200
     9.128   132.641     0.200
     9.360   132.910     0.200
     9.381   131.209     0.200
     9.574   134.939     0.200
     9.610   137.600     0.200
     9.726   137.209     0.200
     9.955   139.990     0.200
    10.033   141.000     0.200
    10.053   141.939     0.200
    10.273   143.840     0.200
    10.395   146.910     0.200
    10.445   147.811     0.200
    10.581   149.910     0.200
    10.633   148.709     0.200
    10.799   152.020     0.200
    11.272   158.709     0.200
    11.708   162.340     0.200
    11.729   166.061     0.200
    11.811   166.359     0.200
    11.836   164.311     0.200
    11.867   167.721     0.200
    12.006   167.480     0.200
    12.006   166.260     0.200
    12.057   170.010     0.200
    13.387   187.330     0.200
    13.389   190.090     0.200
    13.758   192.299     0.200
    13.968   195.410     0.200
    16.803   233.666     0.200
     1.221    21.895     0.200
     1.362    23.613     0.200
     1.281    22.992     0.200
     1.300    23.344     0.200
     1.462    25.441     0.200
     1.496    25.523     0.200
     1.396    24.281     0.200
     1.437    25.094     0.200
     1.575    26.852     0.200
     1.807    29.492     0.200
     2.046    34.832     0.200
     2.215    36.984     0.200
     2.443    39.254     0.200
     2.456    40.223     0.200
     2.730    45.121     0.200
     4.127    62.172     0.200
     3.969    60.852     0.200
     4.215    62.824     0.200
     4.268    64.074     0.200
     4.113    63.004     0.200
     4.392    65.613     0.200
     4.487    65.441     0.200
     5.111    73.426     0.200
     6.748    98.492     0.200
     6.808    99.094     0.200
     7.040    99.512     0.200
     7.713   111.941     0.200
     7.810   111.781     0.200
     8.324   119.113     0.200
     8.372   118.602     0.200
     8.490   120.914     0.200
     8.937   126.984     0.200
     8.896   128.742     0.200
     9.129   132.121     0.200
     9.572   135.754     0.200
     9.612   136.184     0.200
     9.725   136.832     0.200
     9.879   139.461     0.200
     9.987   141.422     0.200
    10.032   140.461     0.200
    10.054   141.895     0.200
    10.271   145.344     0.200
    10.396   146.191     0.200
    10.581   148.762     0.200
    10.634   150.043     0.200
    10.878   153.652     0.200
    11.130   156.434     0.200
    11.316   158.281     0.200
    11.665   163.113     0.200
    11.728   165.102     0.200
    11.812   164.934     0.200
    12.057   169.734     0.200
    13.389   186.434     0.200
    13.386   188.273     0.200
    13.967   194.895     0.200
    14.137   199.133     0.200
    14.587   205.055     0.200
     1.243    22.289     0.200
     1.987    33.414     0.200
     2.027    33.602     0.200
     2.058    34.562     0.200
     2.301    37.562     0.200
     2.321    38.109     0.200
     2.524    39.867     0.200
     2.563    40.320     0.200
     3.077    47.461     0.200
     3.147    48.781     0.200
     3.266    50.438     0.200
     3.297    50.117     0.200
     3.352    51.633     0.200
     3.303    48.852     0.200
     3.624    55.039     0.200
     3.753    58.758     0.200
     3.923    58.289     0.200
     3.923    58.000     0.200
     4.301    64.383     0.200
     4.479    68.680     0.200
     5.027    75.672     0.200
     5.079    76.609     0.200
     5.156    78.039     0.200
     5.174    78.133     0.200
     5.525    78.703     0.200
     5.576    81.250     0.200
     5.829    84.531     0.200
     5.815    84.992     0.200
     5.816    86.164     0.200
     5.870    85.312     0.200
     5.944    85.969     0.200
     6.711    97.594     0.200
     7.202   104.367     0.200
     7.222   104.844     0.200
     7.422   106.961     0.200
     7.556   108.180     0.200
     7.992   113.820     0.200
     7.989   113.109     0.200
     8.031   113.102     0.200
     8.085   118.172     0.200
     8.210   117.172     0.200
     8.197   115.047     0.200
     8.386   119.750     0.200
     8.566   120.477     0.200
     8.698   123.617     0.200
     8.765   124.250     0.200
     8.836   124.797     0.200
     8.857   126.789     0.200
     8.982   128.438     0.200
     9.085   129.477     0.200
     9.296   132.477     0.200
     9.408   132.203     0.200
     9.451   133.570     0.200
     9.544   135.320     0.200
     9.979   141.812     0.200
    10.297   145.453     0.200
    10.367   144.844     0.200
    10.582   147.227     0.200
    10.606   148.617     0.200
    10.718   151.891     0.200
    10.744   150.508     0.200
    10.913   152.172     0.200
    10.913   152.320     0.200
    10.913   151.781     0.200
    12.815   181.977     0.200
    17.197   237.469     0.200
     1.105    21.574     0.200
     1.359    23.406     0.200
     1.430    24.816     0.200
     1.521    26.234     0.200
     1.559    26.797     0.200
     1.602    27.477     0.200
     1.447    26.605     0.200
     1.764    31.305     0.200
     2.176    36.715     0.200
     2.485    39.484     0.200
     2.900    44.434     0.200
     3.223    52.203     0.200
     3.370    53.676     0.200
     3.666    55.516     0.200
     3.689    56.586     0.200
     3.729    57.066     0.200
     3.921    58.547     0.200
     3.783    59.156     0.200
     3.857    59.574     0.200
     3.866    59.734     0.200
     3.909    60.766     0.200
     4.209    63.176     0.200
     4.305    64.523     0.200
     4.346    65.004     0.200
     4.656    67.684     0.200
     4.857    72.176     0.200
     5.265    74.918     0.200
     5.265    75.863     0.200
     5.431    78.625     0.200
     5.342    81.375     0.200
     5.930    86.555     0.200
     5.931    85.246     0.200
     5.933    86.215     0.200
     6.807    98.516     0.200
     6.859    98.387     0.200
     6.985   100.023     0.200
     6.991   102.254     0.200
     7.114   102.305     0.200
     7.149   101.875     0.200
     7.196   102.363     0.200
     7.732   111.594     0.200
     7.890   113.215     0.200
     7.927   113.195     0.200
     8.392   119.305     0.200
     8.434   119.926     0.200
     8.460   121.215     0.200
     8.458   120.594     0.200
     8.558   123.125     0.200
     8.827   124.605     0.200
     8.644   125.047     0.200
     9.020   128.113     0.200
     9.137   129.664     0.200
     9.151   132.336     0.200
     9.217   128.816     0.200
     9.309   131.754     0.200
     9.328   131.387     0.200
     9.446   133.324     0.200
     9.506   133.047     0.200
     9.627   135.797     0.200
     9.709   136.305     0.200
     9.821   137.586     0.200
    10.014   142.773     0.200
    10.089   143.055     0.200
    10.100   142.355     0.200
    10.112   143.934     0.200
    10.184   147.254     0.200
    10.651   148.164     0.200
    10.678   149.195     0.200
    10.944   154.094     0.200
    10.946   153.844     0.200
    10.974   153.316     0.200
    11.021   155.105     0.200
    11.081   155.684     0.200
    11.261   158.684     0.200
    11.278   159.164     0.200
    11.415   160.754     0.200
    11.422   160.016     0.200
    11.490   159.195     0.200
    11.705   163.395     0.200
    11.728   165.035     0.200
    11.759   163.613     0.200
    11.828   168.105     0.200
    11.836   166.746     0.200
    11.937   167.684     0.200
    12.052   167.074     0.200
    12.052   166.227     0.200
    12.142   169.977     0.200
    12.294   173.805     0.200
    12.379   172.754     0.200
    13.841   193.195     0.200
    13.877   195.094     0.200
    14.071   196.137     0.200
    14.191   196.844     0.200
    14.330   201.555     0.200
    14.480   203.305     0.200
    14.710   205.645     0.200
    15.560   216.945     0.200
    16.272   226.945     0.200
     1.283    24.512     0.200
     1.519    26.713     0.200
     1.507    27.133     0.200
     1.606    28.252     0.200
     1.651    29.223     0.200
     1.682    29.342     0.200
     1.608    29.543     0.200
     1.901    32.723     0.200
     2.306    39.223     0.200
     2.307    39.232     0.200
     2.590    43.473     0.200
     2.677    44.523     0.200
     2.837    43.973     0.200
     3.286    52.953     0.200
     3.330    53.443     0.200
     3.559    55.252     0.200
     3.430    54.662     0.200
     3.430    54.822     0.200
     3.445    54.883     0.200
     3.476    55.354     0.200
     3.707    56.863     0.200
     3.720    57.363     0.200
     3.876    58.152     0.200
     3.816    59.342     0.200
     3.888    60.893     0.200
     3.960    61.283     0.200
     3.965    61.473     0.200
     4.015    62.652     0.200
     4.237    63.783     0.200
     4.328    65.082     0.200
     4.626    67.662     0.200
     4.873    72.662     0.200
     4.891    73.162     0.200
     4.747    72.652     0.200
     4.829    73.922     0.200
     4.885    74.822     0.200
     5.013    76.643     0.200
     5.246    76.023     0.200
     5.451    80.152     0.200
     5.430    81.303     0.200
     5.954    88.123     0.200
     6.537    95.943     0.200
     6.806    99.053     0.200
     6.885    99.043     0.200
     7.032   101.332     0.200
     7.161   102.672     0.200
     7.205   102.482     0.200
     7.747   113.012     0.200
     7.785   113.223     0.200
     7.787   113.533     0.200
     7.910   112.783     0.200
     7.934   113.854     0.200
     8.431   120.232     0.200
     8.486   121.434     0.200
     8.529   122.523     0.200
     8.553   122.922     0.200
     8.660   126.543     0.200
     8.840   124.213     0.200
     8.901   126.623     0.200
     8.743   126.863     0.200
     9.049   128.922     0.200
     9.158   129.303     0.200
     9.216   133.512     0.200
     9.246   130.992     0.200
     9.472   134.693     0.200
     9.702   137.283     0.200
     9.842   137.922     0.200
     9.850   142.383     0.200
     9.868   142.012     0.200
    10.077   143.293     0.200
    10.086   141.902     0.200
    10.147   143.832     0.200
    10.155   143.273     0.200
    10.264   147.023     0.200
    10.350   147.223     0.200
    10.288   147.922     0.200
    10.495   146.822     0.200
    10.567   151.373     0.200
    10.857   154.953     0.200
    10.950   155.832     0.200
    11.235   159.633     0.200
    11.382   159.832     0.200
    11.397   162.303     0.200
    11.760   163.732     0.200
    11.772   167.732     0.200
    11.808   164.689     0.200
    11.819   166.363     0.200
    11.927   166.719     0.200
    11.930   167.922     0.200
    12.004   169.803     0.200
    12.104   168.773     0.200
    12.104   168.523     0.200
    12.104   167.789     0.200
    12.232   171.893     0.200
    12.410   173.963     0.200
    12.642   177.652     0.200
    13.462   190.332     0.200
    13.491   190.902     0.200
    13.525   191.223     0.200
    14.282   200.053     0.200
    14.648   206.672     0.200
    14.778   207.312     0.200
    14.849   207.877     0.200
    15.467   216.062     0.200
    15.789   220.393     0.200
    16.304   225.322     0.200
    16.947   234.768     0.200
    16.947   235.793     0.200
     1.914    32.883     0.200
     2.321    39.252     0.200
     2.605    43.383     0.200
     2.691    44.473     0.200
     2.821    43.143     0.200
     3.345    52.242     0.200
     3.860    58.143     0.200
     3.832    59.604     0.200
     3.903    60.752     0.200
     3.975    61.312     0.200
     3.980    61.652     0.200
     4.363    65.533     0.200
     4.489    66.982     0.200
     4.610    66.893     0.200
     5.231    75.236     0.200
     5.231    76.002     0.200
     6.792    97.293     0.200
     6.874    99.953     0.200
     7.019   101.143     0.200
     7.046   103.322     0.200
     7.146   101.832     0.200
     7.190   101.902     0.200
     7.919   113.582     0.200
     8.417   119.922     0.200
     8.472   121.303     0.200
     8.519   122.012     0.200
     8.596   123.262     0.200
     8.825   125.543     0.200
     8.759   126.732     0.200
     9.035   129.012     0.200
     9.144   130.322     0.200
     9.205   133.412     0.200
     9.233   131.162     0.200
     9.458   134.252     0.200
     9.687   136.322     0.200
     9.827   139.643     0.200
    10.065   144.422     0.200
    10.071   142.973     0.200
    10.135   144.383     0.200
    10.230   144.322     0.200
    10.261   146.652     0.200
    10.335   146.822     0.200
    10.482   148.523     0.200
    10.303   148.562     0.200
    10.674   150.262     0.200
    10.958   154.533     0.200
    11.051   156.252     0.200
    11.230   159.053     0.200
    11.258   158.982     0.200
    11.369   159.203     0.200
    11.386   161.512     0.200
    11.387   160.592     0.200
    11.533   161.463     0.200
    11.698   164.963     0.200
    11.748   162.902     0.200
    11.762   167.482     0.200
    11.795   163.373     0.200
    11.804   167.332     0.200
    11.956   167.912     0.200
    12.091   167.982     0.200
    12.091   167.143     0.200
    12.091   168.943     0.200
    12.156   170.463     0.200
    12.396   172.973     0.200
    12.628   176.453     0.200
    13.036   181.303     0.200
    13.485   189.203     0.200
    13.856   193.723     0.200
    14.266   201.883     0.200
    14.406   202.854     0.200
    14.632   205.213     0.200
    14.766   206.953     0.200
    16.290   226.443     0.200
     0.798    16.615     0.200
     0.853    17.734     0.200
     0.889    18.664     0.200
     1.058    20.725     0.200
     1.069    20.834     0.200
     1.579    27.225     0.200
     1.756    31.105     0.200
     2.174    37.324     0.200
     2.175    37.195     0.200
     2.516    42.395     0.200
     2.574    43.355     0.200
     2.585    43.426     0.200
     2.801    43.205     0.200
     3.353    51.055     0.200
     3.393    52.154     0.200
     3.244    52.105     0.200
     3.285    52.375     0.200
     3.344    53.215     0.200
     3.376    53.475     0.200
     3.386    53.814     0.200
     3.432    54.564     0.200
     3.450    54.994     0.200
     3.769    56.414     0.200
     3.794    58.895     0.200
     3.844    60.105     0.200
     3.878    60.195     0.200
     3.921    60.814     0.200
     3.941    61.135     0.200
     4.177    62.975     0.200
     4.016    62.234     0.200
     4.467    65.955     0.200
     4.551    67.705     0.200
     4.821    73.516     0.200
     5.053    74.039     0.200
     5.442    82.555     0.200
     5.827    85.205     0.200
     6.437    93.584     0.200
     6.589    95.125     0.200
     6.632    96.115     0.200
     6.662    97.404     0.200
     6.670    98.385     0.200
     6.791    98.914     0.200
     6.927    99.615     0.200
     7.601   108.285     0.200
     7.660   110.564     0.200
     8.047   114.994     0.200
     8.074   116.615     0.200
     8.070   115.176     0.200
     8.162   118.164     0.200
     8.221   119.324     0.200
     8.550   121.805     0.200
     8.716   125.045     0.200
     8.795   127.955     0.200
     8.911   127.945     0.200
     9.063   128.846     0.200
     9.144   131.154     0.200
     9.464   133.385     0.200
     9.528   135.295     0.200
     9.660   138.225     0.200
     9.707   138.535     0.200
     9.928   140.365     0.200
    10.104   144.865     0.200
    10.333   147.355     0.200
    10.719   152.234     0.200
    10.916   154.734     0.200
    10.956   156.305     0.200
    11.030   157.285     0.200
    11.146   156.365     0.200
    11.180   157.426     0.200
    11.288   159.744     0.200
    11.360   158.885     0.200
    11.711   160.994     0.200
    11.711   164.115     0.200
    15.960   222.814     0.200
    18.062   247.221     0.200
    18.062   247.895     0.200
     1.553    28.605     0.200
     1.897    32.746     0.200
     1.854    33.367     0.200
     1.869    33.824     0.200
     2.057    35.066     0.200
     1.934    34.066     0.200
     1.936    34.305     0.200
     2.258    38.816     0.200
     2.279    39.094     0.200
     2.851    46.926     0.200
     2.895    47.527     0.200
     2.993    48.785     0.200
     2.999    48.656     0.200
     3.016    48.957     0.200
     3.040    49.355     0.200
     3.324    51.406     0.200
     3.369    53.367     0.200
     3.467    54.664     0.200
     3.519    55.438     0.200
     3.518    55.617     0.200
     3.595    56.664     0.200
     3.631    57.105     0.200
     4.366    65.496     0.200
     4.789    72.234     0.200
     4.831    72.984     0.200
     4.958    74.664     0.200
     5.056    76.688     0.200
     5.115    75.066     0.200
     4.965    75.926     0.200
     5.732    83.734     0.200
     5.732    83.887     0.200
     5.977    90.094     0.200
     7.341   107.746     0.200
     7.475   110.035     0.200
     8.408   121.297     0.200
     8.907   128.156     0.200
     9.505   134.855     0.200
     9.625   139.617     0.200
     9.808   140.605     0.200
     9.984   141.105     0.200
     9.840   142.457     0.200
    10.184   144.145     0.200
    10.305   146.414     0.200
    10.628   150.977     0.200
    10.936   156.395     0.200
    11.413   162.285     0.200
    11.452   161.195     0.200
    11.887   168.027     0.200
    12.198   172.574     0.200
    12.240   171.688     0.200
    12.305   174.297     0.200
    12.493   177.574     0.200
    12.532   173.809     0.200
    12.532   175.664     0.200
    12.353   175.656     0.200
    12.626   177.516     0.200
    14.325   200.297     0.200
    14.771   210.016     0.200
    14.909   208.965     0.200
    15.133   214.406     0.200
    15.215   213.875     0.200
     1.224    21.668     0.200
     1.387    23.246     0.200
     1.868    28.727     0.200
     2.935    43.758     0.200
     2.851    44.836     0.200
     3.073    46.766     0.200
     3.189    50.965     0.200
     3.199    50.746     0.200
     3.264    51.105     0.200
     3.716    54.328     0.200
     3.797    56.738     0.200
     3.649    56.586     0.200
     3.879    58.078     0.200
     4.359    63.156     0.200
     4.276    65.488     0.200
     4.319    64.605     0.200
     4.420    66.758     0.200
     4.466    67.516     0.200
     4.810    71.258     0.200
     4.903    72.875     0.200
     4.952    73.598     0.200
     4.959    73.797     0.200
     5.036    74.746     0.200
     5.071    75.148     0.200
     6.066    87.168     0.200
     6.362    90.117     0.200
     6.396    90.715     0.200
     7.728   110.387     0.200
     7.961   114.668     0.200
     8.137   117.238     0.200
     8.304   117.059     0.200
     8.387   119.426     0.200
     8.443   118.996     0.200
     8.506   120.676     0.200
     8.635   124.527     0.200
     8.661   122.098     0.200
     8.837   123.695     0.200
     9.066   129.047     0.200
     9.090   129.398     0.200
     9.200   129.996     0.200
     9.336   130.988     0.200
     9.353   132.188     0.200
     9.442   134.586     0.200
     9.479   133.836     0.200
     9.526   134.445     0.200
     9.831   138.688     0.200
     9.738   138.406     0.200
     9.958   140.758     0.200
     9.972   141.227     0.200
    10.042   141.266     0.200
    10.120   142.559     0.200
    10.149   142.828     0.200
    10.175   143.328     0.200
    10.408   148.086     0.200
    10.484   147.746     0.200
    10.484   148.309     0.200
    10.517   148.266     0.200
    10.823   152.625     0.200
    10.923   153.965     0.200
    11.055   156.875     0.200
    11.073   156.695     0.200
    11.121   154.047     0.200
    11.140   154.656     0.200
    11.231   157.586     0.200
    11.287   156.426     0.200
    11.301   155.586     0.200
    11.321   160.309     0.200
    11.340   160.547     0.200
    11.414   160.848     0.200
    11.449   159.027     0.200
    11.449   156.887     0.200
    11.449   158.176     0.200
    11.279   160.648     0.200
    11.558   166.125     0.200
    11.830   165.387     0.200
    12.602   178.387     0.200
    13.116   183.105     0.200
    13.122   181.578     0.200
    13.321   188.137     0.200
    13.667   191.348     0.200
    13.791   192.598     0.200
    15.967   223.035     0.200
    15.967   223.637     0.200
    17.717   242.762     0.200
    17.717   242.965     0.200
     1.392    24.898     0.200
     1.345    25.309     0.200
     1.360    25.367     0.200
     1.391    25.828     0.200
     1.412    26.320     0.200
     1.608    28.797     0.200
     2.275    38.547     0.200
     2.494    42.109     0.200
     2.614    44.180     0.200
     2.630    44.137     0.200
     2.691    45.199     0.200
     2.693    45.059     0.200
     3.041    48.699     0.200
     3.187    50.590     0.200
     3.193    51.180     0.200
     3.237    51.680     0.200
     3.082    50.398     0.200
     3.084    51.180     0.200
     3.288    51.148     0.200
     3.353    52.328     0.200
     3.796    59.020     0.200
     3.728    59.770     0.200
     3.728    59.977     0.200
     3.771    59.758     0.200
     3.867    61.367     0.200
     3.871    61.508     0.200
     4.059    62.770     0.200
     3.918    62.398     0.200
     4.093    61.898     0.200
     4.270    66.129     0.200
     4.359    67.820     0.200
     4.406    68.500     0.200
     4.418    68.887     0.200
     4.456    69.777     0.200
     4.494    69.879     0.200
     4.528    70.340     0.200
     4.709    70.367     0.200
     5.209    78.508     0.200
     5.428    82.578     0.200
     5.370    81.660     0.200
     5.721    85.770     0.200
     6.074    90.398     0.200
     5.902    87.359     0.200
     6.270    93.344     0.200
     6.270    92.449     0.200
     6.331    92.848     0.200
     6.406    94.488     0.200
     6.469    95.438     0.200
     6.385    94.309     0.200
     6.506    95.750     0.200
     6.510    96.969     0.200
     6.539    96.309     0.200
     6.623    96.367     0.200
     6.634    97.098     0.200
     6.666    96.750     0.200
     7.294   106.957     0.200
     7.336   107.008     0.200
     7.374   107.777     0.200
     7.396   106.438     0.200
     7.616   110.328     0.200
     7.906   114.820     0.200
     7.953   114.898     0.200
     8.079   117.250     0.200
     8.095   117.938     0.200
     8.102   117.578     0.200
     8.302   119.809     0.200
     8.362   120.719     0.200
     8.366   120.867     0.200
     8.518   121.469     0.200
     8.624   123.617     0.200
     8.716   124.359     0.200
     8.765   125.188     0.200
     8.940   127.398     0.200
     9.163   130.930     0.200
     9.307   133.070     0.200
     9.195   133.738     0.200
     9.466   134.918     0.200
     9.462   134.578     0.200
     9.548   136.117     0.200
     9.575   137.699     0.200
     9.617   136.430     0.200
     9.617   137.867     0.200
     9.640   138.387     0.200
     9.685   137.387     0.200
     9.709   137.949     0.200
     9.708   139.160     0.200
     9.815   140.719     0.200
     9.861   140.488     0.200
     9.899   141.469     0.200
     9.978   141.840     0.200
     9.983   142.070     0.200
     9.988   143.117     0.200
    10.036   144.297     0.200
    10.162   143.797     0.200
    10.201   145.715     0.200
    10.201   145.207     0.200
    10.217   144.988     0.200
    10.392   147.027     0.200
    10.434   147.039     0.200
    10.445   148.977     0.200
    10.476   149.488     0.200
    10.528   149.469     0.200
    10.712   151.938     0.200
    10.702   152.578     0.200
    10.734   152.910     0.200
    10.715   153.668     0.200
    10.864   154.059     0.200
    10.892   154.488     0.200
    10.909   155.520     0.200
    11.035   155.039     0.200
    11.250   157.688     0.200
    11.291   158.180     0.200
    11.282   159.988     0.200
    11.298   160.020     0.200
    11.298   158.379     0.200
    11.310   159.777     0.200
    11.398   159.340     0.200
    11.419   162.246     0.200
    11.419   161.648     0.200
    11.422   161.508     0.200
    11.440   160.328     0.200
    11.590   161.887     0.200
    11.590   161.898     0.200
    11.590   162.219     0.200
    11.638   164.449     0.200
    11.724   166.133     0.200
    11.724   164.887     0.200
    11.880   168.363     0.200
    12.535   175.359     0.200
    12.990   184.078     0.200
    12.990   182.828     0.200
    12.992   184.539     0.200
    13.148   185.867     0.200
    13.338   186.898     0.200
    13.431   188.078     0.200
    13.628   191.137     0.200
    13.762   195.137     0.200
    14.143   199.938     0.200
    14.198   200.227     0.200
    14.384   202.246     0.200
    14.384   201.410     0.200
    15.007   210.328     0.200
    15.311   214.738     0.200
    16.382   228.582     0.200
    16.382   228.949     0.200
    16.441   231.547     0.200
    16.441   229.828     0.200
    17.905   246.973     0.200
    17.905   246.277     0.200
    18.747   260.047     0.200
     1.301    23.562     0.200
     1.301    23.162     0.200
     1.321    23.523     0.200
     1.333    23.902     0.200
     1.405    25.672     0.200
     1.433    25.793     0.200
     1.540    26.473     0.200
     1.467    25.203     0.200
     1.612    27.963     0.200
     1.766    29.172     0.200
     2.083    34.502     0.200
     2.275    37.223     0.200
     2.418    39.502     0.200
     2.421    39.902     0.200
     2.490    41.402     0.200
     2.492    40.863     0.200
     2.857    46.152     0.200
     2.866    45.943     0.200
     2.886    46.172     0.200
     3.416    52.342     0.200
     3.563    54.273     0.200
     3.568    54.883     0.200
     3.481    54.873     0.200
     3.481    54.764     0.200
     3.662    55.732     0.200
     3.685    54.652     0.200
     3.524    54.893     0.200
     3.554    55.562     0.200
     3.624    56.232     0.200
     3.636    56.172     0.200
     4.171    62.303     0.200
     4.155    62.902     0.200
     4.345    64.582     0.200
     4.349    65.283     0.200
     4.379    65.822     0.200
     4.435    66.193     0.200
     4.440    64.354     0.200
     4.741    70.152     0.200
     5.064    72.797     0.200
     5.064    73.023     0.200
     5.627    81.854     0.200
     5.802    84.854     0.200
     5.820    85.373     0.200
     6.097    89.053     0.200
     6.450    93.652     0.200
     6.345    94.453     0.200
     6.702    95.812     0.200
     6.771    98.213     0.200
     6.845    98.854     0.200
     6.915   100.322     0.200
     6.994    98.854     0.200
     7.037    99.562     0.200
     7.712   111.252     0.200
     7.748   110.402     0.200
     7.765   110.463     0.200
     7.909   113.303     0.200
     7.991   114.342     0.200
     8.282   117.572     0.200
     8.328   118.123     0.200
     8.432   119.934     0.200
     8.470   120.732     0.200
     8.674   122.842     0.200
     8.717   123.303     0.200
     8.998   127.604     0.200
     8.856   127.393     0.200
     9.091   128.113     0.200
     8.939   128.812     0.200
     9.163   129.273     0.200
     9.315   131.193     0.200
     9.333   130.453     0.200
     9.526   133.502     0.200
     9.680   137.002     0.200
     9.813   138.562     0.200
     9.833   138.252     0.200
     9.906   139.643     0.200
     9.908   138.443     0.200
     9.947   140.873     0.200
     9.986   140.742     0.200
    10.014   141.232     0.200
    10.061   140.184     0.200
    10.064   142.264     0.200
    10.085   140.773     0.200
    10.045   144.242     0.200
    10.224   144.043     0.200
    10.251   146.104     0.200
    10.354   146.502     0.200
    10.569   148.502     0.200
    10.483   148.803     0.200
    10.897   155.502     0.200
    11.574   165.143     0.200
    11.669   164.684     0.200
    11.674   165.652     0.200
    11.796   165.803     0.200
    11.965   166.264     0.200
    11.965   164.703     0.200
    12.255   170.803     0.200
    12.475   173.393     0.200
    13.449   189.553     0.200
     1.957    34.016     0.200
     2.018    34.992     0.200
     2.892    49.422     0.200
     2.936    50.008     0.200
     3.012    50.875     0.200
     3.035    51.391     0.200
     3.040    51.062     0.200
     3.056    51.438     0.200
     3.081    52.203     0.200
     3.110    52.516     0.200
     3.490    57.414     0.200
     3.509    57.297     0.200
     3.561    57.922     0.200
     3.637    59.242     0.200
     3.674    59.633     0.200
     4.132    64.836     0.200
     4.320    65.781     0.200
     4.491    71.594     0.200
     5.069    75.781     0.200
     5.009    77.844     0.200
     5.687    84.156     0.200
     5.687    84.406     0.200
     5.999    91.633     0.200
     7.237   107.375     0.200
     7.229   105.977     0.200
     7.297   107.047     0.200
     7.434   109.773     0.200
     7.587   109.812     0.200
     8.364   122.023     0.200
     8.875   128.664     0.200
     8.902   129.547     0.200
     8.999   131.133     0.200
     9.266   133.656     0.200
     9.339   134.484     0.200
     9.343   134.367     0.200
     9.578   137.320     0.200
     9.740   140.008     0.200
     9.764   139.734     0.200
     9.887   142.102     0.200
     9.940   142.070     0.200
     9.883   144.266     0.200
    10.139   145.133     0.200
    10.261   146.562     0.200
    10.584   151.477     0.200
    10.686   152.852     0.200
    10.836   155.281     0.200
    10.857   155.562     0.200
    10.899   156.258     0.200
    11.172   159.938     0.200
    11.370   162.664     0.200
    11.407   162.281     0.200
    11.506   163.992     0.200
    11.660   165.766     0.200
    11.678   166.836     0.200
    11.708   168.594     0.200
    11.709   167.484     0.200
    11.756   168.742     0.200
    11.840   168.734     0.200
    11.978   170.367     0.200
    12.093   173.172     0.200
    12.162   172.211     0.200
    12.147   172.922     0.200
    12.153   172.875     0.200
    12.268   173.984     0.200
    12.282   173.625     0.200
    12.260   173.156     0.200
    12.312   171.461     0.200
    12.493   176.766     0.200
    12.395   178.438     0.200
    12.584   178.586     0.200
    12.703   181.297     0.200
    12.821   181.594     0.200
    13.050   184.047     0.200
    13.069   184.664     0.200
    13.437   189.867     0.200
    13.802   196.688     0.200
    13.968   197.703     0.200
    15.151   213.781     0.200
    15.181   214.641     0.200
    15.172   213.438     0.200
    16.715   232.961     0.200
     1.234    24.018     0.200
     1.569    29.016     0.200
     1.712    31.328     0.200
     2.000    34.418     0.200
     1.869    34.197     0.200
     1.885    34.678     0.200
     2.061    35.447     0.200
     1.951    35.008     0.200
     2.271    39.527     0.200
     2.305    40.037     0.200
     2.863    47.697     0.200
     2.907    48.258     0.200
     3.005    49.508     0.200
     3.011    49.469     0.200
     3.028    49.867     0.200
     3.052    50.107     0.200
     3.081    50.947     0.200
     3.460    55.729     0.200
     3.478    55.389     0.200
     3.606    57.488     0.200
     3.643    57.809     0.200
     4.383    68.707     0.200
     4.789    72.828     0.200
     4.832    73.598     0.200
     4.967    75.148     0.200
     5.040    76.348     0.200
     5.111    75.562     0.200
     5.729    84.002     0.200
     5.729    84.227     0.200
     6.836   101.934     0.200
     7.050   104.719     0.200
     7.277   107.934     0.200
     7.279   106.857     0.200
     7.340   107.867     0.200
     7.477   110.229     0.200
     8.407   121.818     0.200
     8.945   129.707     0.200
     9.042   131.148     0.200
     9.309   132.969     0.200
     9.783   139.219     0.200
     9.983   142.059     0.200
     9.851   143.258     0.200
    10.305   147.117     0.200
    10.133   147.248     0.200
    10.493   151.559     0.200
    10.571   151.797     0.200
    10.627   151.678     0.200
    10.879   155.037     0.200
    10.900   155.008     0.200
    10.941   156.447     0.200
    11.215   159.898     0.200
    11.410   162.748     0.200
    11.450   163.117     0.200
    11.797   168.559     0.200
    12.132   173.688     0.200
    12.423   178.027     0.200
    12.535   175.639     0.200
    12.535   175.258     0.200
    12.365   176.318     0.200
    12.627   178.248     0.200
    12.744   180.229     0.200
    12.865   181.867     0.200
    14.554   206.348     0.200
    15.221   214.707     0.200
    16.758   235.277     0.200
     0.863    16.027     0.200
     1.269    21.688     0.200
     1.363    23.551     0.200
     1.516    25.055     0.200
     1.553    27.059     0.200
     1.580    27.559     0.200
     1.599    27.859     0.200
     1.649    28.918     0.200
     1.770    29.750     0.200
     1.824    30.770     0.200
     2.018    32.488     0.200
     2.081    33.598     0.200
     2.160    34.859     0.200
     2.280    34.758     0.200
     2.415    39.277     0.200
     2.593    41.688     0.200
     3.130    49.309     0.200
     3.205    50.711     0.200
     3.232    50.949     0.200
     3.835    59.508     0.200
     4.090    59.219     0.200
     3.878    59.961     0.200
     3.977    60.488     0.200
     4.370    65.750     0.200
     4.370    65.617     0.200
     4.437    67.148     0.200
     4.463    67.078     0.200
     4.721    67.770     0.200
     4.721    67.949     0.200
     4.511    67.719     0.200
     4.518    67.801     0.200
     4.630    69.219     0.200
     5.100    75.148     0.200
     5.100    74.938     0.200
     5.459    80.129     0.200
     5.459    80.230     0.200
     5.408    80.148     0.200
     6.102    88.980     0.200
     6.102    88.871     0.200
     6.383    92.348     0.200
     6.483    94.480     0.200
     6.483    93.930     0.200
     6.547    95.688     0.200
     6.593    96.930     0.200
     6.593    96.641     0.200
     7.441   106.438     0.200
     7.438   106.758     0.200
     7.505   108.578     0.200
     7.505   108.457     0.200
     7.689   110.480     0.200
     7.734   112.988     0.200
     7.734   111.020     0.200
     7.993   113.578     0.200
     7.993   114.195     0.200
     8.023   115.391     0.200
     8.199   117.469     0.200
     8.238   117.660     0.200
     8.355   118.879     0.200
     8.689   123.395     0.200
     8.792   125.539     0.200
     8.840   127.199     0.200
     9.002   126.680     0.200
     9.011   127.430     0.200
     9.189   129.461     0.200
     9.370   132.848     0.200
     9.663   135.930     0.200
    11.517   162.160     0.200
    11.556   163.559     0.200
    11.693   161.000     0.200
    12.155   171.148     0.200
    13.604   190.438     0.200
    13.864   194.789     0.200
    17.991   246.375     0.200
     1.647    27.406     0.200
     2.251    37.148     0.200
     2.251    37.297     0.200
     2.288    37.281     0.200
     2.426    39.992     0.200
     2.464    36.867     0.200
     2.464    38.195     0.200
     2.587    42.750     0.200
     2.663    43.328     0.200
     3.033    48.820     0.200
     3.040    49.062     0.200
     3.061    49.289     0.200
     3.511    52.344     0.200
     3.511    52.492     0.200
     3.659    57.773     0.200
     3.702    56.289     0.200
     3.802    59.047     0.200
     3.802    59.633     0.200
     3.849    59.844     0.200
     4.211    63.633     0.200
     4.192    63.852     0.200
     4.192    63.250     0.200
     4.261    65.367     0.200
     4.270    62.531     0.200
     4.270    62.430     0.200
     4.302    64.406     0.200
     4.285    65.133     0.200
     4.334    65.867     0.200
     4.898    70.797     0.200
     4.898    71.102     0.200
     5.179    76.539     0.200
     5.179    76.422     0.200
     5.205    78.688     0.200
     5.260    77.523     0.200
     5.260    77.648     0.200
     5.595    82.422     0.200
     5.595    82.211     0.200
     5.807    86.906     0.200
     5.807    85.727     0.200
     5.957    86.727     0.200
     5.957    86.031     0.200
     6.107    88.727     0.200
     6.107    88.305     0.200
     6.251    91.070     0.200
     6.314    92.094     0.200
     6.476    95.367     0.200
     6.476    94.297     0.200
     6.485    94.883     0.200
     6.485    94.164     0.200
     6.494    94.547     0.200
     6.550    93.672     0.200
     6.617    95.422     0.200
     6.669    96.570     0.200
     6.712    97.508     0.200
     6.749    97.906     0.200
     6.753    97.570     0.200
     6.785    98.609     0.200
     6.843    97.383     0.200
     6.878   100.547     0.200
     6.883    97.977     0.200
     7.514   106.703     0.200
     7.519   109.094     0.200
     7.540   108.383     0.200
     7.583   109.727     0.200
     7.631   110.469     0.200
     7.631   109.906     0.200
     7.610   109.117     0.200
     7.610   108.203     0.200
     7.759   111.859     0.200
     7.759   111.555     0.200
     7.810   112.406     0.200
     7.810   111.594     0.200
     7.862   113.250     0.200
     8.146   116.211     0.200
     8.146   115.922     0.200
     8.184   116.398     0.200
     8.184   116.102     0.200
     8.256   119.250     0.200
     8.256   118.328     0.200
     8.346   119.898     0.200
     8.343   119.211     0.200
     8.343   118.828     0.200
     8.522   121.391     0.200
     8.559   121.711     0.200
     8.544   121.812     0.200
     8.548   121.852     0.200
     8.750   124.148     0.200
     8.750   124.008     0.200
     8.851   126.211     0.200
     8.851   125.758     0.200
     8.950   127.430     0.200
     8.975   128.742     0.200
     8.966   127.117     0.200
     9.007   126.758     0.200
     9.007   127.125     0.200
     9.042   128.930     0.200
     9.042   128.164     0.200
     9.032   127.930     0.200
     9.032   127.180     0.200
     9.036   130.977     0.200
     9.119   131.453     0.200
     9.171   128.148     0.200
     9.171   130.070     0.200
     9.171   129.484     0.200
     9.174   128.891     0.200
     9.306   131.711     0.200
     9.364   131.922     0.200
     9.364   132.398     0.200
     9.461   135.008     0.200
     9.533   134.250     0.200
     9.645   137.219     0.200
     9.645   136.328     0.200
     9.675   137.156     0.200
     9.740   138.117     0.200
     9.806   140.031     0.200
     9.806   138.789     0.200
     9.830   139.383     0.200
     9.832   138.320     0.200
     9.859   138.070     0.200
     9.892   139.547     0.200
     9.892   139.320     0.200
     9.898   140.523     0.200
     9.921   139.203     0.200
     9.983   141.547     0.200
     9.998   142.328     0.200
    10.081   143.070     0.200
    10.063   141.539     0.200
    10.063   142.047     0.200
    10.123   142.742     0.200
    10.171   143.656     0.200
    10.241   146.250     0.200
    10.241   145.156     0.200
    10.225   143.547     0.200
    10.294   144.211     0.200
    10.294   145.023     0.200
    10.400   145.312     0.200
    10.400   145.445     0.200
    10.412   146.711     0.200
    10.412   146.555     0.200
    10.467   146.352     0.200
    10.467   147.047     0.200
    10.470   148.797     0.200
    10.576   148.156     0.200
    10.584   149.109     0.200
    10.603   149.352     0.200
    10.639   149.180     0.200
    10.662   151.750     0.200
    10.683   149.625     0.200
    10.698   150.500     0.200
    10.677   150.039     0.200
    10.719   151.594     0.200
    10.942   152.953     0.200
    10.942   153.625     0.200
    10.935   154.672     0.200
    10.935   154.266     0.200
    10.941   156.617     0.200
    11.080   156.844     0.200
    11.146   156.016     0.200
    11.169   156.062     0.200
    11.186   158.039     0.200
    11.285   156.477     0.200
    11.350   160.922     0.200
    11.398   161.180     0.200
    11.398   161.281     0.200
    11.367   160.391     0.200
    11.468   161.445     0.200
    11.471   162.297     0.200
    11.500   158.719     0.200
    11.486   161.758     0.200
    11.486   161.508     0.200
    11.537   159.773     0.200
    11.533   159.938     0.200
    11.575   165.680     0.200
    11.575   164.852     0.200
    11.555   160.438     0.200
    11.555   161.969     0.200
    11.586   163.430     0.200
    11.561   162.891     0.200
    11.651   161.062     0.200
    11.671   163.703     0.200
    11.644   164.406     0.200
    11.644   163.430     0.200
    11.675   163.344     0.200
    11.675   163.812     0.200
    11.721   165.070     0.200
    11.838   162.547     0.200
    11.838   163.953     0.200
    11.869   165.508     0.200
    11.900   167.430     0.200
    11.897   167.398     0.200
    11.975   167.555     0.200
    12.108   166.844     0.200
    12.108   169.117     0.200
    12.114   168.297     0.200
    12.114   168.680     0.200
    12.138   168.750     0.200
    12.201   171.453     0.200
    12.304   172.406     0.200
    12.304   172.992     0.200
    12.322   172.430     0.200
    12.337   173.125     0.200
    12.468   173.297     0.200
    12.468   174.234     0.200
    12.606   175.766     0.200
    12.784   176.531     0.200
    12.784   178.227     0.200
    12.790   178.062     0.200
    12.807   180.539     0.200
    13.164   185.023     0.200
    13.168   183.898     0.200
    13.253   183.500     0.200
    13.253   184.461     0.200
    13.570   188.609     0.200
    13.771   191.648     0.200
    13.771   192.109     0.200
    14.273   200.789     0.200
    14.367   199.438     0.200
    14.367   201.531     0.200
    14.531   201.500     0.200
    14.649   205.102     0.200
    15.488   215.828     0.200
    16.007   221.602     0.200
    16.007   222.859     0.200
    16.529   229.477     0.200
    16.650   230.680     0.200
    18.145   248.250     0.200
    18.145   247.852     0.200
    18.145   248.508     0.200
    18.793   258.547     0.200
     0.953    19.406     0.200
     0.967    19.695     0.200
     0.963    19.570     0.200
     0.966    19.789     0.200
     1.062    21.695     0.200
     1.052    20.430     0.200
     1.300    24.695     0.200
     1.353    26.242     0.200
     1.650    28.602     0.200
     1.678    29.758     0.200
     1.710    29.578     0.200
     1.643    29.477     0.200
     1.811    31.812     0.200
     1.851    33.188     0.200
     2.012    33.266     0.200
     1.976    34.289     0.200
     1.978    34.617     0.200
     2.326    39.492     0.200
     2.339    39.875     0.200
     2.414    40.625     0.200
     2.542    41.219     0.200
     2.443    41.328     0.200
     2.622    41.469     0.200
     3.050    45.969     0.200
     3.050    46.273     0.200
     3.040    49.547     0.200
     3.113    50.391     0.200
     3.183    51.180     0.200
     3.212    51.656     0.200
     3.575    56.266     0.200
     3.642    57.609     0.200
     3.667    57.695     0.200
     3.716    58.297     0.200
     3.723    58.656     0.200
     4.073    61.352     0.200
     4.617    69.406     0.200
     4.591    70.570     0.200
     4.715    71.070     0.200
     4.613    71.227     0.200
     4.808    70.047     0.200
     5.417    77.789     0.200
     5.417    78.461     0.200
     5.522    81.477     0.200
     5.522    80.609     0.200
     5.686    84.320     0.200
     5.686    84.180     0.200
     5.917    88.125     0.200
     5.917    87.492     0.200
     5.958    89.258     0.200
     5.958    89.695     0.200
     6.926   101.961     0.200
     6.928   101.031     0.200
     7.007   101.852     0.200
     7.130   104.797     0.200
     7.343   106.508     0.200
     7.906   115.312     0.200
     7.906   114.766     0.200
     8.075   115.641     0.200
     8.062   116.820     0.200
     8.062   116.102     0.200
     8.532   122.102     0.200
     8.529   122.602     0.200
     8.545   122.797     0.200
     8.604   123.547     0.200
     8.502   123.562     0.200
     8.692   127.375     0.200
     8.974   128.000     0.200
     9.281   133.281     0.200
     9.281   131.914     0.200
     9.279   135.367     0.200
     9.286   133.969     0.200
     9.359   134.656     0.200
     9.589   137.039     0.200
     9.655   136.148     0.200
     9.624   138.539     0.200
     9.859   139.656     0.200
     9.859   139.398     0.200
     9.965   141.258     0.200
    10.031   143.516     0.200
    10.151   145.422     0.200
    10.043   145.891     0.200
    10.220   146.016     0.200
    10.294   145.617     0.200
    10.322   149.586     0.200
    10.561   150.258     0.200
    10.885   154.500     0.200
    11.097   158.258     0.200
    11.171   158.125     0.200
    11.428   162.789     0.200
    11.623   165.289     0.200
    11.707   166.477     0.200
    11.787   167.719     0.200
    11.987   169.328     0.200
    11.973   170.070     0.200
    12.083   171.961     0.200
    12.162   172.656     0.200
    12.185   171.617     0.200
    12.284   173.609     0.200
    12.374   174.906     0.200
    12.758   178.578     0.200
    12.777   179.227     0.200
    12.774   181.578     0.200
    13.214   186.250     0.200
    13.705   194.961     0.200
    14.631   205.906     0.200
    14.842   210.500     0.200
    16.413   230.828     0.200
     0.946    17.684     0.200
     1.248    23.664     0.200
     1.654    28.754     0.200
     1.548    26.156     0.200
     1.548    26.844     0.200
     1.701    29.004     0.200
     1.758    30.734     0.200
     2.019    32.316     0.200
     2.019    33.215     0.200
     1.884    32.586     0.200
     2.256    37.855     0.200
     3.109    46.637     0.200
     2.963    47.445     0.200
     3.106    48.996     0.200
     3.134    49.434     0.200
     3.500    53.914     0.200
     3.565    55.574     0.200
     3.639    55.863     0.200
     3.649    56.395     0.200
     3.806    58.055     0.200
     4.121    60.266     0.200
     4.519    68.234     0.200
     4.848    69.703     0.200
     5.451    78.254     0.200
     5.451    77.996     0.200
     5.514    80.273     0.200
     5.696    81.727     0.200
     6.437    93.176     0.200
     6.910    99.684     0.200
     6.903    99.766     0.200
     7.023   100.586     0.200
     7.128   102.906     0.200
     7.311   103.926     0.200
     7.360   105.426     0.200
     7.901   113.145     0.200
     7.883   113.555     0.200
     8.045   115.145     0.200
     8.035   115.266     0.200
     8.092   115.535     0.200
     8.508   121.434     0.200
     8.532   121.785     0.200
     8.988   127.137     0.200
     9.260   132.234     0.200
     9.290   131.137     0.200
     9.257   131.934     0.200
     9.594   135.004     0.200
     9.676   135.504     0.200
     9.619   137.105     0.200
     9.732   137.535     0.200
     9.793   137.703     0.200
     9.974   140.094     0.200
     9.997   141.293     0.200
     9.966   141.684     0.200
    10.088   143.824     0.200
    10.310   144.895     0.200
    10.572   148.664     0.200
    10.573   149.676     0.200
    10.789   151.453     0.200
    11.130   156.445     0.200
    11.146   157.445     0.200
    11.367   159.555     0.200
    11.452   161.234     0.200
    11.448   162.203     0.200
    11.380   162.305     0.200
    11.609   163.145     0.200
    11.589   163.375     0.200
    11.739   164.504     0.200
    11.749   164.785     0.200
    11.833   165.516     0.200
    11.916   167.484     0.200
    12.080   170.895     0.200
    12.523   176.156     0.200
    12.790   178.875     0.200
    12.755   179.105     0.200
    13.986   194.453     0.200
    14.823   207.145     0.200
    16.085   223.965     0.200
    16.415   227.977     0.200
     1.731    28.688     0.200
     2.721    42.438     0.200
     2.826    45.914     0.200
     2.826    46.133     0.200
     2.826    45.633     0.200
     3.065    49.547     0.200
     3.398    51.828     0.200
     3.587    57.094     0.200
     3.645    57.883     0.200
     4.068    60.406     0.200
     4.068    60.523     0.200
     4.313    66.891     0.200
     4.413    66.117     0.200
     4.413    66.430     0.200
     4.354    66.961     0.200
     4.454    68.672     0.200
     4.455    68.352     0.200
     4.644    69.000     0.200
     4.819    72.664     0.200
     4.821    72.617     0.200
     4.836    72.891     0.200
     4.845    73.156     0.200
     4.861    73.336     0.200
     4.861    73.195     0.200
     4.913    75.453     0.200
     4.947    74.578     0.200
     4.990    75.211     0.200
     5.116    76.828     0.200
     5.084    77.438     0.200
     5.446    80.914     0.200
     5.646    82.758     0.200
     5.646    83.062     0.200
     5.702    83.086     0.200
     5.875    87.031     0.200
     5.891    87.016     0.200
     5.805    87.227     0.200
     5.914    87.453     0.200
     5.916    87.586     0.200
     5.951    88.031     0.200
     5.995    86.578     0.200
     6.010    88.812     0.200
     6.043    88.953     0.200
     6.036    87.266     0.200
     6.036    87.117     0.200
     5.963    87.695     0.200
     6.505    96.141     0.200
     6.505    95.891     0.200
     6.637    94.516     0.200
     6.637    96.352     0.200
     6.707    97.602     0.200
     6.708    99.086     0.200
     6.711    99.094     0.200
     6.753    97.797     0.200
     6.763    96.766     0.200
     6.763    96.484     0.200
     6.808    99.414     0.200
     6.841    99.773     0.200
     6.911    99.484     0.200
     6.911    98.789     0.200
     7.033   102.188     0.200
     7.031   102.531     0.200
     7.058   102.625     0.200
     7.058   104.125     0.200
     7.220   104.047     0.200
     7.306   104.523     0.200
     7.306   105.352     0.200
     7.337   104.766     0.200
     7.337   105.016     0.200
     7.515   107.641     0.200
     7.515   108.750     0.200
     7.531   107.984     0.200
     7.718   109.984     0.200
     7.718   110.156     0.200
     7.720   110.352     0.200
     7.724   110.305     0.200
     7.905   112.133     0.200
     7.905   111.812     0.200
     8.003   113.172     0.200
     8.104   114.516     0.200
     8.126   115.438     0.200
     8.166   117.836     0.200
     8.166   118.422     0.200
     8.161   115.023     0.200
     8.161   115.531     0.200
     8.199   116.562     0.200
     8.199   117.266     0.200
     8.267   118.734     0.200
     8.267   119.383     0.200
     8.325   117.758     0.200
     8.330   116.812     0.200
     8.460   120.531     0.200
     8.519   121.523     0.200
     8.519   120.344     0.200
     8.524   120.812     0.200
     8.524   120.633     0.200
     8.567   122.125     0.200
     8.658   124.047     0.200
     8.658   124.734     0.200
     8.685   123.078     0.200
     8.831   124.891     0.200
     8.985   126.984     0.200
     8.985   127.234     0.200
     9.016   127.945     0.200
     9.020   128.172     0.200
     9.020   127.133     0.200
     9.039   130.477     0.200
     9.039   129.266     0.200
     9.042   129.102     0.200
     9.042   129.477     0.200
     9.071   128.875     0.200
     9.071   128.484     0.200
     9.077   127.914     0.200
     9.077   127.727     0.200
     9.067   127.828     0.200
     9.155   129.953     0.200
     9.173   129.594     0.200
     9.222   129.922     0.200
     9.222   129.750     0.200
     9.275   131.094     0.200
     9.275   131.648     0.200
     9.277   131.594     0.200
     9.393   132.328     0.200
     9.420   134.289     0.200
     9.487   133.508     0.200
     9.487   134.219     0.200
     9.467   134.328     0.200
     9.513   135.773     0.200
     9.558   134.344     0.200
     9.558   134.195     0.200
     9.567   135.008     0.200
     9.567   135.227     0.200
     9.638   136.531     0.200
     9.638   135.703     0.200
     9.648   136.375     0.200
     9.634   137.266     0.200
     9.754   139.578     0.200
     9.754   139.422     0.200
     9.749   137.227     0.200
     9.775   138.406     0.200
     9.796   137.797     0.200
     9.835   139.664     0.200
     9.835   139.852     0.200
     9.776   139.938     0.200
     9.776   140.836     0.200
     9.837   138.508     0.200
    10.061   140.461     0.200
    10.061   142.766     0.200
    10.095   142.336     0.200
    10.095   142.312     0.200
    10.095   141.773     0.200
    10.111   142.523     0.200
    10.223   144.375     0.200
    10.222   143.938     0.200
    10.298   146.273     0.200
    10.298   146.844     0.200
    10.329   144.633     0.200
    10.329   144.758     0.200
    10.371   145.641     0.200
    10.359   145.906     0.200
    10.459   145.914     0.200
    10.529   147.992     0.200
    10.535   148.281     0.200
    10.581   148.938     0.200
    10.649   151.352     0.200
    10.649   150.500     0.200
    10.640   150.211     0.200
    10.640   149.984     0.200
    10.638   149.453     0.200
    10.641   150.391     0.200
    10.674   148.914     0.200
    10.685   151.367     0.200
    10.705   149.484     0.200
    10.705   149.336     0.200
    10.746   150.812     0.200
    10.746   150.133     0.200
    10.734   150.672     0.200
    10.832   150.906     0.200
    10.830   150.984     0.200
    10.830   151.797     0.200
    10.847   152.273     0.200
    10.847   151.031     0.200
    10.850   152.273     0.200
    10.850   151.031     0.200
    10.833   153.344     0.200
    10.873   154.117     0.200
    10.873   152.906     0.200
    10.861   154.602     0.200
    10.962   153.203     0.200
    11.008   152.867     0.200
    11.008   153.086     0.200
    11.008   153.305     0.200
    11.022   154.672     0.200
    11.055   155.352     0.200
    11.055   155.781     0.200
    11.126   157.547     0.200
    11.126   158.555     0.200
    11.152   155.023     0.200
    11.152   154.789     0.200
    11.135   156.992     0.200
    11.269   156.836     0.200
    11.269   157.617     0.200
    11.301   157.383     0.200
    11.308   157.273     0.200
    11.301   160.047     0.200
    11.301   162.234     0.200
    11.363   160.242     0.200
    11.457   160.742     0.200
    11.457   161.242     0.200
    11.475   161.281     0.200
    11.467   162.570     0.200
    11.493   162.133     0.200
    11.656   161.133     0.200
    11.763   164.312     0.200
    11.942   166.883     0.200
    11.942   167.391     0.200
    11.986   169.258     0.200
    11.991   170.234     0.200
    12.351   172.867     0.200
    12.475   174.102     0.200
    12.475   174.320     0.200
    12.606   177.586     0.200
    12.724   177.180     0.200
    12.736   178.531     0.200
    12.817   179.938     0.200
    12.923   180.453     0.200
    12.923   181.312     0.200
    13.005   182.859     0.200
    13.025   181.922     0.200
    13.130   184.117     0.200
    13.130   185.109     0.200
    13.262   185.953     0.200
    13.262   185.789     0.200
    13.343   186.758     0.200
    13.343   187.172     0.200
    13.565   190.523     0.200
    13.565   188.961     0.200
    14.041   195.727     0.200
    14.184   198.055     0.200
    14.184   198.453     0.200
    14.430   201.406     0.200
    14.430   202.180     0.200
    14.489   202.438     0.200
    14.489   202.727     0.200
    14.660   204.906     0.200
    14.716   206.133     0.200
    15.252   213.672     0.200
    15.373   213.664     0.200
    15.699   219.734     0.200
    15.799   221.578     0.200
    15.819   221.734     0.200
    15.966   221.758     0.200
    15.966   221.242     0.200
    16.206   225.781     0.200
    16.206   224.578     0.200
    16.303   225.594     0.200
    16.605   230.914     0.200
    17.304   237.633     0.200
    17.304   236.703     0.200
    18.217   250.883     0.200
     0.815    16.012     0.200
     0.920    17.791     0.200
     0.817    16.152     0.200
     1.609    27.721     0.200
     1.719    27.811     0.200
     2.726    41.531     0.200
     2.846    45.691     0.200
     3.080    49.422     0.200
     3.183    50.711     0.200
     3.467    50.941     0.200
     3.467    51.195     0.200
     3.682    55.557     0.200
     3.602    56.682     0.200
     4.087    59.336     0.200
     4.087    59.561     0.200
     4.240    62.986     0.200
     4.412    65.611     0.200
     4.412    65.477     0.200
     4.453    65.102     0.200
     4.453    65.314     0.200
     4.325    66.102     0.200
     4.367    65.762     0.200
     4.673    68.062     0.200
     4.468    68.002     0.200
     4.838    71.182     0.200
     4.838    71.520     0.200
     4.863    71.902     0.200
     5.118    75.654     0.200
     4.872    72.871     0.200
     4.927    74.051     0.200
     4.959    74.221     0.200
     5.003    75.051     0.200
     5.337    78.551     0.200
     5.337    78.176     0.200
     5.506    80.322     0.200
     5.519    80.592     0.200
     5.681    82.211     0.200
     5.687    82.762     0.200
     5.735    81.932     0.200
     5.865    85.371     0.200
     5.865    85.789     0.200
     5.921    86.121     0.200
     5.951    85.842     0.200
     5.958    86.582     0.200
     5.960    86.941     0.200
     5.962    86.471     0.200
     5.998    87.201     0.200
     6.057    88.111     0.200
     6.068    86.471     0.200
     6.068    86.330     0.200
     6.089    88.682     0.200
     6.730    96.861     0.200
     6.738    97.352     0.200
     6.754    96.922     0.200
     6.513    94.801     0.200
     6.513    95.400     0.200
     6.789    96.281     0.200
     6.794    95.402     0.200
     6.794    95.822     0.200
     6.855    98.980     0.200
     6.899   100.002     0.200
     6.899    99.855     0.200
     6.764    99.332     0.200
     6.946    99.781     0.200
     6.946   100.043     0.200
     7.093   102.162     0.200
     7.112   103.221     0.200
     7.350   105.041     0.200
     7.376   104.832     0.200
     7.523   108.742     0.200
     7.564   107.641     0.200
     7.668   109.791     0.200
     7.692   110.301     0.200
     7.692   110.037     0.200
     7.737   109.941     0.200
     7.737   110.109     0.200
     7.762   110.322     0.200
     7.741   109.842     0.200
     7.945   112.072     0.200
     8.040   114.801     0.200
     8.040   113.346     0.200
     8.151   114.992     0.200
     8.191   115.691     0.200
     8.191   114.146     0.200
     8.220   119.512     0.200
     8.326   118.662     0.200
     8.326   118.447     0.200
     8.363   117.922     0.200
     8.363   118.275     0.200
     8.358   116.730     0.200
     8.490   119.492     0.200
     8.548   119.871     0.200
     8.556   120.789     0.200
     8.713   125.162     0.200
     8.713   124.152     0.200
     8.722   122.742     0.200
     8.722   122.494     0.200
     8.859   124.561     0.200
     9.016   127.002     0.200
     9.016   126.668     0.200
     9.064   126.910     0.200
     9.069   128.592     0.200
     9.096   129.436     0.200
     9.087   128.381     0.200
     9.104   129.902     0.200
     9.104   128.828     0.200
     9.122   128.730     0.200
     9.122   128.566     0.200
     9.119   127.371     0.200
     9.119   127.049     0.200
     9.174   129.271     0.200
     9.190   129.652     0.200
     9.247   131.012     0.200
     9.247   129.473     0.200
     9.310   131.361     0.200
     9.310   130.574     0.200
     9.441   132.480     0.200
     9.441   133.432     0.200
     9.441   133.629     0.200
     9.485   133.002     0.200
     9.542   134.242     0.200
     9.542   133.850     0.200
     9.585   134.441     0.200
     9.596   134.600     0.200
     9.687   137.021     0.200
     9.687   135.656     0.200
     9.664   136.711     0.200
     9.767   137.121     0.200
     9.823   137.342     0.200
     9.870   138.611     0.200
     9.870   138.494     0.200
     9.829   139.461     0.200
     9.829   138.365     0.200
     9.861   138.852     0.200
    10.061   141.871     0.200
    10.075   141.781     0.200
    10.119   142.951     0.200
    10.119   142.070     0.200
    10.133   142.492     0.200
    10.133   142.123     0.200
    10.238   143.672     0.200
    10.357   146.043     0.200
    10.380   145.002     0.200
    10.380   144.359     0.200
    10.377   145.480     0.200
    10.427   146.102     0.200
    10.427   145.514     0.200
    10.555   148.912     0.200
    10.624   148.672     0.200
    10.657   149.326     0.200
    10.660   150.182     0.200
    10.670   150.531     0.200
    10.670   149.609     0.200
    10.693   151.371     0.200
    10.693   151.033     0.200
    10.752   149.471     0.200
    10.752   148.682     0.200
    10.752   151.041     0.200
    10.724   151.980     0.200
    10.799   150.891     0.200
    10.799   149.428     0.200
    10.870   152.861     0.200
    10.870   151.904     0.200
    10.846   152.781     0.200
    10.846   152.445     0.200
    10.883   151.031     0.200
    10.898   151.111     0.200
    10.901   150.041     0.200
    10.901   151.062     0.200
    10.899   153.941     0.200
    10.908   153.512     0.200
    10.908   152.973     0.200
    11.057   153.092     0.200
    11.057   152.742     0.200
    11.061   155.021     0.200
    11.084   154.572     0.200
    11.102   155.971     0.200
    11.143   156.271     0.200
    11.202   155.361     0.200
    11.202   159.281     0.200
    11.308   158.281     0.200
    11.308   157.193     0.200
    11.345   157.582     0.200
    11.345   156.984     0.200
    11.364   157.766     0.200
    11.386   160.047     0.200
    11.486   161.639     0.200
    11.507   160.852     0.200
    11.709   162.051     0.200
    11.709   161.078     0.200
    11.804   163.971     0.200
    11.804   163.828     0.200
    11.979   167.941     0.200
    11.979   166.271     0.200
    12.002   168.379     0.200
    12.010   169.695     0.200
    12.534   177.842     0.200
    12.534   173.092     0.200
    12.611   176.744     0.200
    12.753   178.162     0.200
    12.890   179.352     0.200
    12.956   180.951     0.200
    12.956   180.799     0.200
    13.018   181.824     0.200
    13.016   181.078     0.200
    13.135   183.781     0.200
    13.135   184.641     0.200
    13.285   185.971     0.200
    13.285   186.135     0.200
    13.359   187.551     0.200
    13.359   186.965     0.200
    13.520   190.041     0.200
    13.570   189.447     0.200
    13.940   194.111     0.200
    14.078   194.936     0.200
    14.203   196.730     0.200
    14.413   201.059     0.200
    14.497   202.307     0.200
    14.678   204.902     0.200
    14.704   204.748     0.200
    15.718   219.137     0.200
    15.790   219.754     0.200
    15.818   220.041     0.200
    15.818   220.428     0.200
    16.239   224.410     0.200
    16.883   233.488     0.200
    17.347   236.592     0.200
    17.347   237.676     0.200
     1.132    19.664     0.200
     1.159    20.609     0.200
     1.160    20.609     0.200
     1.208    22.016     0.200
     1.378    22.375     0.200
     1.225    22.039     0.200
     1.258    22.367     0.200
     1.281    23.055     0.200
     1.353    24.031     0.200
     1.467    25.266     0.200
     1.487    25.625     0.200
     2.163    35.711     0.200
     2.163    34.805     0.200
     2.419    37.359     0.200
     2.355    37.961     0.200
     2.502    40.914     0.200
     2.521    41.398     0.200
     2.884    45.805     0.200
     2.909    46.891     0.200
     3.114    47.555     0.200
     2.980    47.414     0.200
     3.420    50.930     0.200
     3.672    57.609     0.200
     3.965    59.156     0.200
     4.019    60.055     0.200
     4.147    60.156     0.200
     4.147    60.414     0.200
     4.175    64.148     0.200
     4.363    64.844     0.200
     4.442    65.266     0.200
     4.308    65.164     0.200
     4.557    66.875     0.200
     4.432    66.664     0.200
     4.754    68.734     0.200
     4.754    68.594     0.200
     4.754    68.336     0.200
     4.861    71.234     0.200
     4.910    71.289     0.200
     4.910    71.695     0.200
     5.039    73.531     0.200
     5.307    77.195     0.200
     5.309    77.195     0.200
     5.316    77.688     0.200
     5.381    78.641     0.200
     5.430    80.094     0.200
     5.434    78.594     0.200
     5.721    83.336     0.200
     5.921    85.938     0.200
     5.813    86.125     0.200
     6.005    87.531     0.200
     6.071    87.781     0.200
     6.334    91.836     0.200
     6.351    91.516     0.200
     6.366    91.508     0.200
     6.244    91.906     0.200
     6.497    93.789     0.200
     6.503    95.086     0.200
     6.530    94.547     0.200
     6.642    94.281     0.200
     6.687    95.211     0.200
     7.334   105.109     0.200
     7.386   106.188     0.200
     7.418   106.164     0.200
     7.505   107.555     0.200
     7.552   109.086     0.200
     7.588   109.750     0.200
     7.588   108.773     0.200
     7.902   112.914     0.200
     7.960   113.688     0.200
     7.959   113.859     0.200
     8.024   114.469     0.200
     8.048   115.031     0.200
     8.080   115.375     0.200
     8.320   117.484     0.200
     8.320   117.328     0.200
     8.690   124.859     0.200
     8.719   125.188     0.200
     8.735   124.539     0.200
     8.798   124.500     0.200
     8.818   124.625     0.200
     8.995   125.406     0.200
     9.118   128.000     0.200
     9.197   129.281     0.200
     9.318   132.586     0.200
     9.509   134.258     0.200
     9.493   135.227     0.200
     9.588   135.195     0.200
     9.619   136.445     0.200
     9.638   136.070     0.200
     9.654   135.820     0.200
     9.750   138.117     0.200
     9.861   139.789     0.200
     9.894   139.234     0.200
     9.912   140.039     0.200
     9.966   141.867     0.200
    10.026   141.086     0.200
    10.007   140.109     0.200
    10.227   143.938     0.200
    10.337   145.750     0.200
    10.435   146.656     0.200
    10.464   147.445     0.200
    10.728   151.094     0.200
    10.627   153.148     0.200
    10.875   152.828     0.200
    10.911   153.570     0.200
    11.044   155.141     0.200
    11.086   157.461     0.200
    11.219   158.234     0.200
    11.294   159.391     0.200
    11.266   158.961     0.200
    11.324   158.516     0.200
    11.376   160.805     0.200
    11.442   160.391     0.200
    11.527   161.820     0.200
    11.575   160.188     0.200
    11.575   161.000     0.200
    11.716   164.594     0.200
    11.787   166.398     0.200
    11.815   165.148     0.200
    11.883   165.719     0.200
    11.887   166.656     0.200
    12.105   170.047     0.200
    12.123   169.875     0.200
    12.186   171.461     0.200
    12.369   173.516     0.200
    12.570   175.430     0.200
    13.047   182.219     0.200
    13.936   194.750     0.200
    13.987   195.758     0.200
    14.251   199.000     0.200
     1.026    19.484     0.200
     1.063    20.902     0.200
     1.064    20.902     0.200
     1.263    21.785     0.200
     1.276    23.863     0.200
     1.311    24.113     0.200
     1.337    24.844     0.200
     1.401    26.426     0.200
     1.495    26.766     0.200
     1.557    27.105     0.200
     1.894    31.594     0.200
     2.327    36.133     0.200
     2.241    38.395     0.200
     2.436    40.562     0.200
     2.473    41.234     0.200
     2.599    40.984     0.200
     2.602    43.824     0.200
     2.660    43.793     0.200
     2.999    46.605     0.200
     3.063    47.652     0.200
     2.967    48.504     0.200
     3.154    50.465     0.200
     3.086    49.555     0.200
     3.319    50.035     0.200
     3.813    58.062     0.200
     3.850    58.426     0.200
     3.760    58.176     0.200
     3.947    61.082     0.200
     3.914    59.855     0.200
     4.040    59.504     0.200
     4.248    65.016     0.200
     4.331    65.383     0.200
     4.265    65.164     0.200
     4.319    66.863     0.200
     4.454    67.332     0.200
     4.645    67.766     0.200
     4.753    70.973     0.200
     4.796    71.234     0.200
     4.924    73.895     0.200
     5.203    78.402     0.200
     5.282    78.574     0.200
     5.606    83.605     0.200
     5.723    84.965     0.200
     5.811    85.895     0.200
     5.890    87.676     0.200
     6.237    90.504     0.200
     6.221    91.832     0.200
     6.256    90.773     0.200
     6.383    94.133     0.200
     7.170   104.133     0.200
     7.224   104.945     0.200
     7.396   107.094     0.200
     7.943   114.766     0.200
     8.206   117.414     0.200
     8.578   124.383     0.200
     8.626   124.832     0.200
     8.831   125.992     0.200
     8.882   126.133     0.200
     9.085   128.395     0.200
     9.060   131.805     0.200
     9.203   131.582     0.200
     9.524   135.684     0.200
     9.506   134.875     0.200
     9.782   139.363     0.200
     9.798   140.004     0.200
     9.915   139.953     0.200
    10.044   143.426     0.200
    10.113   143.453     0.200
    10.351   146.625     0.200
    10.603   150.484     0.200
    10.667   152.184     0.200
    10.978   156.273     0.200
     1.215    21.348     0.200
     1.219    20.867     0.200
     1.219    21.008     0.200
     1.604    25.176     0.200
     1.874    30.488     0.200
     1.932    32.148     0.200
     1.975    32.898     0.200
     2.009    33.406     0.200
     2.036    34.227     0.200
     2.202    35.246     0.200
     2.278    36.195     0.200
     2.285    36.426     0.200
     2.275    36.938     0.200
     2.522    38.766     0.200
     2.522    38.465     0.200
     3.067    46.688     0.200
     2.975    47.676     0.200
     2.975    47.258     0.200
     3.083    47.137     0.200
     3.147    48.398     0.200
     3.219    47.758     0.200
     3.219    47.973     0.200
     3.181    49.855     0.200
     3.288    50.398     0.200
     3.307    51.586     0.200
     3.450    52.238     0.200
     3.390    52.105     0.200
     3.611    54.516     0.200
     3.611    53.961     0.200
     3.814    56.316     0.200
     3.814    56.191     0.200
     3.847    57.625     0.200
     3.847    57.328     0.200
     3.830    59.227     0.200
     4.033    60.355     0.200
     4.033    59.637     0.200
     4.108    61.328     0.200
     4.108    61.020     0.200
     4.088    61.086     0.200
     4.088    60.945     0.200
     4.362    64.062     0.200
     4.364    64.906     0.200
     4.456    65.727     0.200
     4.456    64.961     0.200
     4.507    68.605     0.200
     4.511    67.957     0.200
     4.480    68.797     0.200
     4.521    67.156     0.200
     4.609    69.605     0.200
     4.622    71.027     0.200
     4.729    70.398     0.200
     4.729    70.094     0.200
     4.667    70.426     0.200
     4.683    71.148     0.200
     4.802    72.168     0.200
     4.802    70.008     0.200
     4.960    73.098     0.200
     4.960    72.754     0.200
     5.094    74.746     0.200
     5.115    75.355     0.200
     5.115    74.938     0.200
     5.034    73.945     0.200
     5.034    74.977     0.200
     5.159    75.875     0.200
     5.115    76.969     0.200
     5.330    79.375     0.200
     5.330    77.238     0.200
     5.347    77.602     0.200
     5.254    78.605     0.200
     5.285    78.969     0.200
     5.410    78.176     0.200
     5.481    80.945     0.200
     5.481    79.934     0.200
     5.557    82.375     0.200
     5.560    81.438     0.200
     5.595    82.887     0.200
     5.631    83.336     0.200
     5.690    84.117     0.200
     5.701    82.527     0.200
     5.724    84.297     0.200
     5.745    82.785     0.200
     5.745    82.906     0.200
     6.326    91.211     0.200
     6.361    92.152     0.200
     6.375    93.527     0.200
     6.452    93.258     0.200
     6.510    94.676     0.200
     6.510    94.516     0.200
     6.702    96.828     0.200
     6.702    97.051     0.200
     6.730    97.668     0.200
     6.730    98.055     0.200
     6.685    98.445     0.200
     6.685    98.129     0.200
     7.032   102.168     0.200
     7.032   101.469     0.200
     7.135   103.426     0.200
     7.135   103.000     0.200
     7.274   104.648     0.200
     7.298   105.578     0.200
     7.298   105.273     0.200
     7.380   104.906     0.200
     7.380   105.383     0.200
     7.404   106.148     0.200
     7.701   109.875     0.200
     7.701   109.441     0.200
     7.853   111.375     0.200
     7.838   113.363     0.200
     7.875   111.453     0.200
     7.878   112.309     0.200
     7.936   113.277     0.200
     7.936   113.391     0.200
     8.019   114.648     0.200
     8.050   113.309     0.200
     8.217   117.195     0.200
     8.252   117.117     0.200
     8.252   116.863     0.200
     8.329   118.977     0.200
     8.384   118.566     0.200
     8.569   121.977     0.200
     8.569   121.566     0.200
     8.620   122.156     0.200
     8.696   123.375     0.200
     8.696   123.496     0.200
     8.689   124.566     0.200
     8.709   122.918     0.200
     8.704   122.676     0.200
     8.709   125.105     0.200
     8.709   124.848     0.200
     8.712   125.648     0.200
     8.746   125.027     0.200
     8.746   124.410     0.200
     8.767   123.938     0.200
     8.767   122.961     0.200
     8.807   124.438     0.200
     8.949   126.855     0.200
     8.949   127.113     0.200
     8.977   127.957     0.200
     8.977   128.074     0.200
     9.048   128.809     0.200
     9.169   131.730     0.200
     9.159   131.027     0.200
     9.245   130.246     0.200
     9.245   131.457     0.200
     9.283   131.938     0.200
     9.283   132.039     0.200
     9.316   131.016     0.200
     9.398   133.637     0.200
     9.518   133.977     0.200
     9.472   134.938     0.200
     9.538   135.641     0.200
     9.641   136.488     0.200
     9.790   138.996     0.200
     9.790   138.691     0.200
     9.814   138.055     0.200
     9.821   139.180     0.200
     9.858   139.957     0.200
     9.972   141.527     0.200
     9.967   141.699     0.200
    10.002   141.566     0.200
    10.002   140.930     0.200
     9.929   142.168     0.200
    10.042   143.727     0.200
    10.042   143.148     0.200
    10.136   142.469     0.200
    10.268   145.430     0.200
    10.301   145.957     0.200
    10.351   146.617     0.200
    10.351   145.969     0.200
    10.351   145.078     0.200
    10.378   146.105     0.200
    10.388   147.688     0.200
    10.384   145.914     0.200
    10.479   147.387     0.200
    10.506   148.195     0.200
    10.520   148.656     0.200
    10.520   148.328     0.200
    10.505   148.785     0.200
    10.523   146.691     0.200
    10.526   146.758     0.200
    10.526   147.648     0.200
    10.526   147.023     0.200
    10.576   149.059     0.200
    10.595   149.383     0.200
    10.687   149.277     0.200
    10.687   148.898     0.200
    10.687   149.367     0.200
    10.726   153.039     0.200
    10.772   152.598     0.200
    10.834   153.695     0.200
    10.828   152.309     0.200
    10.828   151.012     0.200
    10.858   151.809     0.200
    10.907   152.730     0.200
    10.960   153.984     0.200
    10.984   153.707     0.200
    10.979   154.797     0.200
    10.979   154.129     0.200
    11.047   155.508     0.200
    11.165   157.668     0.200
    11.165   157.062     0.200
    11.183   157.766     0.200
    11.459   161.621     0.200
    11.452   161.477     0.200
    11.452   161.055     0.200
    11.443   162.906     0.200
    11.725   164.906     0.200
    11.715   164.426     0.200
    12.226   171.461     0.200
    12.389   174.254     0.200
    12.418   173.516     0.200
    12.628   177.148     0.200
    12.764   179.387     0.200
    12.914   181.734     0.200
    12.991   183.148     0.200
    12.991   182.680     0.200
    13.091   184.156     0.200
    13.091   183.012     0.200
    13.229   185.629     0.200
    13.322   185.988     0.200
    13.902   195.406     0.200
    14.263   200.715     0.200
    14.853   206.934     0.200
    15.067   212.117     0.200
    15.133   211.852     0.200
    15.439   215.629     0.200
    15.625   219.473     0.200
    15.625   217.348     0.200
    16.278   225.691     0.200
    16.990   235.672     0.200
    16.990   234.625     0.200
     1.027    19.082     0.200
     1.065    18.662     0.200
     1.065    18.977     0.200
     1.071    19.762     0.200
     1.170    21.541     0.200
     1.170    21.582     0.200
     1.572    27.162     0.200
     1.623    27.762     0.200
     1.796    29.082     0.200
     1.821    30.611     0.200
     1.858    31.070     0.200
     1.885    31.311     0.200
     1.943    32.551     0.200
     2.109    34.311     0.200
     2.398    37.820     0.200
     2.700    42.662     0.200
     2.774    43.861     0.200
     2.821    42.742     0.200
     2.821    43.057     0.200
     2.821    43.281     0.200
     2.793    43.592     0.200
     2.791    45.412     0.200
     2.791    44.574     0.200
     2.791    44.881     0.200
     2.984    46.900     0.200
     3.002    47.621     0.200
     3.150    49.801     0.200
     3.210    50.262     0.200
     3.522    53.002     0.200
     3.572    52.752     0.200
     3.570    54.162     0.200
     3.604    54.561     0.200
     3.630    54.861     0.200
     3.632    56.320     0.200
     3.812    57.662     0.200
     3.942    58.971     0.200
     4.093    61.131     0.200
     4.133    61.781     0.200
     4.133    61.654     0.200
     4.197    60.912     0.200
     4.197    61.289     0.200
     4.259    64.451     0.200
     4.370    64.682     0.200
     4.301    65.172     0.200
     4.544    67.281     0.200
     4.580    67.291     0.200
     4.580    67.096     0.200
     4.614    68.162     0.200
     4.793    69.873     0.200
     4.794    69.912     0.200
     4.803    71.262     0.200
     4.971    73.051     0.200
     4.971    73.404     0.200
     4.991    73.781     0.200
     5.021    74.102     0.200
     5.027    74.582     0.200
     5.245    77.311     0.200
     5.287    77.291     0.200
     5.288    77.611     0.200
     5.470    79.512     0.200
     5.470    79.912     0.200
     5.585    81.492     0.200
     5.649    82.432     0.200
     5.639    82.311     0.200
     5.639    82.133     0.200
     5.806    84.420     0.200
     5.816    84.781     0.200
     5.857    84.211     0.200
     5.998    88.002     0.200
     5.998    87.746     0.200
     6.051    88.182     0.200
     6.091    88.191     0.200
     6.093    88.791     0.200
     6.084    88.230     0.200
     6.129    88.641     0.200
     6.151    87.611     0.200
     6.190    88.271     0.200
     6.773    99.182     0.200
     6.773    98.676     0.200
     6.881    99.912     0.200
     6.885   100.182     0.200
     6.915    98.041     0.200
     6.915    98.146     0.200
     6.914    98.051     0.200
     7.032   101.951     0.200
     7.032   101.537     0.200
     7.070   102.730     0.200
     6.995   102.230     0.200
     7.226   104.102     0.200
     7.226   103.875     0.200
     7.244   105.070     0.200
     7.244   104.797     0.200
     7.502   106.361     0.200
     7.502   106.219     0.200
     7.656   110.811     0.200
     7.656   110.053     0.200
     7.829   110.051     0.200
     7.829   110.260     0.200
     7.845   111.561     0.200
     7.800   111.682     0.200
     7.849   111.650     0.200
     7.823   111.781     0.200
     7.891   113.311     0.200
     8.072   116.301     0.200
     8.166   117.092     0.200
     8.166   115.018     0.200
     8.267   116.391     0.200
     8.311   116.518     0.200
     8.353   120.291     0.200
     8.353   120.188     0.200
     8.476   118.211     0.200
     8.459   120.311     0.200
     8.459   120.691     0.200
     8.490   120.492     0.200
     8.664   121.121     0.200
     8.664   121.576     0.200
     8.847   124.662     0.200
     8.945   127.252     0.200
     8.945   127.027     0.200
     9.040   127.172     0.200
     9.137   128.230     0.200
     9.137   128.500     0.200
     9.198   130.301     0.200
     9.194   129.117     0.200
     9.237   131.992     0.200
     9.237   131.148     0.200
     9.254   131.541     0.200
     9.254   131.010     0.200
     9.283   130.971     0.200
     9.298   132.012     0.200
     9.363   132.559     0.200
     9.434   133.182     0.200
     9.434   133.314     0.200
     9.572   134.992     0.200
     9.571   135.916     0.200
     9.715   136.471     0.200
     9.715   136.203     0.200
     9.730   135.650     0.200
     9.771   137.682     0.200
     9.819   138.922     0.200
     9.940   138.971     0.200
     9.994   141.105     0.200
     9.939   141.082     0.200
    10.019   141.521     0.200
    10.170   143.742     0.200
    10.237   144.951     0.200
    10.259   144.561     0.200
    10.259   144.152     0.200
    10.345   146.941     0.200
    10.513   146.672     0.200
    10.561   148.746     0.200
    10.651   150.980     0.200
    10.640   148.141     0.200
    10.752   151.295     0.200
    10.791   152.381     0.200
    10.791   151.557     0.200
    10.843   153.791     0.200
    10.826   153.650     0.200
    10.826   152.277     0.200
    10.855   150.611     0.200
    10.882   151.162     0.200
    10.949   154.371     0.200
    10.998   154.980     0.200
    11.031   155.051     0.200
    11.015   153.400     0.200
    11.187   157.352     0.200
    11.210   157.820     0.200
    11.203   158.201     0.200
    11.203   157.330     0.200
    11.188   154.201     0.200
    11.188   154.611     0.200
    11.188   154.932     0.200
    11.242   158.061     0.200
    11.249   158.688     0.200
    11.436   161.332     0.200
    11.436   160.723     0.200
    11.475   159.301     0.200
    11.475   158.965     0.200
    11.497   159.977     0.200
    11.573   162.762     0.200
    11.611   162.861     0.200
    11.611   162.562     0.200
    11.629   163.102     0.200
    11.812   164.945     0.200
    11.841   166.502     0.200
    11.841   166.174     0.200
    11.932   166.650     0.200
    11.932   166.314     0.200
    12.052   170.721     0.200
    12.052   170.162     0.200
    12.105   169.750     0.200
    12.218   171.605     0.200
    12.263   172.799     0.200
    12.544   177.035     0.200
    12.639   176.955     0.200
    12.627   174.721     0.200
    12.627   174.848     0.200
    12.862   180.182     0.200
    13.079   182.730     0.200
    13.079   182.977     0.200
    13.229   186.752     0.200
    13.294   185.463     0.200
    13.467   190.070     0.200
    13.672   191.621     0.200
    13.711   191.117     0.200
    14.062   196.625     0.200
    14.073   199.518     0.200
    14.141   197.461     0.200
    14.314   201.051     0.200
    14.595   205.801     0.200
    14.595   205.438     0.200
    14.788   207.041     0.200
    14.788   206.766     0.200
    15.328   213.059     0.200
    15.439   214.480     0.200
    15.829   220.662     0.200
    15.904   223.057     0.200
    17.476   239.631     0.200
    17.476   239.332     0.200
     1.194    21.055     0.200
     1.194    20.566     0.200
     1.474    23.465     0.200
     1.550    26.410     0.200
     1.551    26.414     0.200
     1.971    29.766     0.200
     1.971    29.516     0.200
     2.030    33.117     0.200
     1.909    31.777     0.200
     1.938    32.074     0.200
     1.958    32.617     0.200
     2.137    34.965     0.200
     3.042    44.289     0.200
     3.072    47.117     0.200
     2.960    46.574     0.200
     2.984    47.086     0.200
     2.993    47.496     0.200
     3.175    47.957     0.200
     3.120    49.406     0.200
     3.128    48.785     0.200
     3.597    55.926     0.200
     3.824    54.715     0.200
     3.824    54.941     0.200
     3.999    59.008     0.200
     4.221    61.996     0.200
     4.196    63.867     0.200
     4.239    64.348     0.200
     4.468    63.531     0.200
     4.468    64.035     0.200
     4.339    65.805     0.200
     4.339    65.457     0.200
     4.386    66.395     0.200
     4.780    69.355     0.200
     4.727    69.816     0.200
     4.727    70.434     0.200
     4.925    73.508     0.200
     4.925    72.340     0.200
     4.821    71.688     0.200
     5.019    73.465     0.200
     5.099    72.758     0.200
     5.101    72.758     0.200
     4.953    74.027     0.200
     4.988    74.336     0.200
     5.358    77.695     0.200
     5.656    82.234     0.200
     5.849    85.586     0.200
     6.039    88.855     0.200
     6.039    86.953     0.200
     6.175    90.707     0.200
     6.385    92.406     0.200
     6.385    91.531     0.200
     6.455    95.414     0.200
     6.482    95.008     0.200
     6.339    92.336     0.200
     6.339    92.520     0.200
     7.225   103.215     0.200
     7.250   106.355     0.200
     7.393   106.656     0.200
     7.426   106.816     0.200
     7.426   106.305     0.200
     7.628   110.895     0.200
     7.628   110.496     0.200
     7.624   109.188     0.200
     7.840   113.086     0.200
     7.835   112.176     0.200
     8.050   115.047     0.200
     8.066   117.215     0.200
     8.146   115.047     0.200
     8.413   119.367     0.200
     8.552   120.395     0.200
     8.614   124.027     0.200
     8.771   123.664     0.200
     8.827   125.938     0.200
     8.858   127.227     0.200
     8.946   126.035     0.200
     9.175   129.887     0.200
     9.197   130.477     0.200
     9.445   132.797     0.200
     9.461   133.805     0.200
     9.647   135.375     0.200
     9.630   137.348     0.200
     9.638   137.977     0.200
     9.732   136.695     0.200
     9.758   138.777     0.200
     9.937   141.227     0.200
    10.015   141.574     0.200
     9.981   141.805     0.200
    10.060   143.816     0.200
    10.080   142.555     0.200
    10.132   142.637     0.200
    10.188   143.105     0.200
    10.230   143.695     0.200
    10.283   144.266     0.200
    10.591   149.566     0.200
    10.593   149.914     0.200
    10.896   153.777     0.200
    10.950   156.477     0.200
    11.031   154.957     0.200
    11.116   157.305     0.200
    11.165   159.348     0.200
    11.198   158.957     0.200
    11.426   159.688     0.200
    11.555   161.645     0.200
    11.555   160.609     0.200
    11.775   165.324     0.200
    11.832   165.266     0.200
    11.922   168.336     0.200
    11.940   166.527     0.200
    12.258   171.484     0.200
    12.277   170.688     0.200
    16.066   222.887     0.200
     1.182    20.578     0.200
     1.182    20.961     0.200
     2.060    33.539     0.200
     2.316    36.078     0.200
     2.316    36.734     0.200
     3.039    45.047     0.200
     3.039    45.508     0.200
     3.663    55.195     0.200
     4.112    59.938     0.200
     4.112    60.328     0.200
     4.112    60.641     0.200
     4.700    69.688     0.200
     4.878    72.188     0.200
     4.891    70.969     0.200
     4.985    73.898     0.200
     5.275    77.406     0.200
     5.399    79.367     0.200
     5.522    80.766     0.200
     5.531    79.508     0.200
     5.531    79.031     0.200
     5.826    84.938     0.200
     5.851    85.086     0.200
     5.851    85.398     0.200
     6.021    86.617     0.200
     5.927    85.516     0.200
     5.927    86.164     0.200
     6.143    88.672     0.200
     6.264    90.477     0.200
     6.264    91.406     0.200
     6.337    92.500     0.200
     6.628    96.055     0.200
     6.778    97.828     0.200
     6.778    98.328     0.200
     6.883    99.211     0.200
     6.921    99.141     0.200
     7.156   102.648     0.200
     7.157   102.867     0.200
     7.209   102.297     0.200
     7.285   105.328     0.200
     7.516   107.930     0.200
     7.541   106.984     0.200
     8.150   117.102     0.200
     8.185   117.258     0.200
     8.186   117.062     0.200
     8.266   116.711     0.200
     8.266   117.938     0.200
     8.265   116.945     0.200
     8.294   118.883     0.200
     8.468   120.781     0.200
     8.538   122.742     0.200
     8.734   121.500     0.200
     8.817   124.500     0.200
     8.817   125.188     0.200
     8.851   124.789     0.200
     8.851   125.219     0.200
     8.919   127.953     0.200
     9.013   127.531     0.200
     9.013   128.125     0.200
     9.015   127.250     0.200
     9.015   128.305     0.200
     9.012   127.016     0.200
     9.165   129.227     0.200
     9.165   129.555     0.200
     9.169   129.289     0.200
     9.181   128.500     0.200
     9.181   128.992     0.200
     9.230   130.930     0.200
     9.419   132.812     0.200
     9.516   133.727     0.200
     9.618   134.766     0.200
     9.643   137.508     0.200
     9.643   139.023     0.200
     9.699   137.672     0.200
     9.704   136.625     0.200
     9.838   138.039     0.200
    10.005   140.531     0.200
    10.005   141.234     0.200
    10.032   141.961     0.200
    10.128   144.133     0.200
    10.269   145.039     0.200
    10.198   143.609     0.200
    10.266   145.555     0.200
    10.458   148.617     0.200
    10.488   147.305     0.200
    10.497   149.133     0.200
    10.530   147.266     0.200
    10.563   148.352     0.200
    10.591   147.727     0.200
    10.619   150.695     0.200
    10.708   151.531     0.200
    10.705   150.000     0.200
    10.786   151.617     0.200
    10.961   153.703     0.200
    11.064   155.414     0.200
    11.071   154.312     0.200
    11.138   155.047     0.200
    11.138   155.508     0.200
    11.285   157.500     0.200
    11.345   159.828     0.200
    11.493   161.977     0.200
    11.493   161.430     0.200
    11.577   162.906     0.200
    11.609   162.742     0.200
    11.661   163.391     0.200
    11.739   165.867     0.200
    11.816   163.602     0.200
    11.834   164.805     0.200
    12.051   169.297     0.200
    12.051   169.586     0.200
    12.094   169.766     0.200
    12.141   170.141     0.200
    12.210   168.375     0.200
    12.223   169.430     0.200
    12.249   172.727     0.200
    12.249   171.344     0.200
    12.342   171.961     0.200
    12.344   172.297     0.200
    12.345   170.969     0.200
    12.345   171.234     0.200
    12.345   170.539     0.200
    12.383   173.938     0.200
    12.496   175.930     0.200
    12.510   172.891     0.200
    12.510   172.055     0.200
    12.524   176.133     0.200
    12.524   176.539     0.200
    12.528   175.344     0.200
    12.551   175.555     0.200
    12.647   175.281     0.200
    12.771   179.719     0.200
    12.773   176.586     0.200
    12.783   177.148     0.200
    12.810   176.703     0.200
    12.839   180.250     0.200
    12.924   181.469     0.200
    12.962   181.266     0.200
    12.985   181.969     0.200
    13.110   183.695     0.200
    13.137   181.383     0.200
    13.277   184.891     0.200
    13.325   186.773     0.200
    13.425   189.086     0.200
    13.423   189.023     0.200
    13.443   189.953     0.200
    13.456   186.016     0.200
    13.455   187.508     0.200
    13.472   188.031     0.200
    13.778   193.070     0.200
    13.808   192.422     0.200
    13.830   195.172     0.200
    13.911   193.492     0.200
    13.965   192.531     0.200
    13.967   194.492     0.200
    13.980   195.367     0.200
    14.117   197.086     0.200
    14.182   197.797     0.200
    14.238   197.766     0.200
    14.242   197.289     0.200
    14.422   202.352     0.200
    14.422   201.234     0.200
    14.431   200.820     0.200
    14.431   201.664     0.200
    14.486   203.266     0.200
    14.522   202.867     0.200
    14.580   203.094     0.200
    14.636   203.352     0.200
    14.661   203.867     0.200
    14.743   205.234     0.200
    14.763   206.250     0.200
    14.783   207.500     0.200
    14.814   207.539     0.200
    14.963   207.852     0.200
    14.966   209.938     0.200
    15.014   208.180     0.200
    15.018   210.445     0.200
    15.073   210.203     0.200
    15.095   208.992     0.200
    15.098   210.414     0.200
    15.201   211.359     0.200
    15.303   212.875     0.200
    15.428   213.406     0.200
    15.319   213.094     0.200
    15.450   215.016     0.200
    15.469   213.109     0.200
    15.487   215.016     0.200
    15.515   216.281     0.200
    15.546   215.750     0.200
    15.555   217.805     0.200
    15.554   216.820     0.200
    15.640   218.141     0.200
    15.870   221.289     0.200
    15.870   221.688     0.200
    15.898   221.781     0.200
    15.939   222.508     0.200
    15.977   223.125     0.200
    16.112   223.977     0.200
    16.277   225.422     0.200
    16.417   227.484     0.200
    16.420   227.680     0.200
    16.432   227.945     0.200
    16.505   228.062     0.200
    16.521   229.898     0.200
    16.675   230.188     0.200
    16.685   230.578     0.200
    17.019   236.336     0.200
    17.187   237.836     0.200
    17.208   236.773     0.200
    17.261   237.203     0.200
    19.172   262.508     0.200
    20.220   274.570     0.200
    20.771   279.922     0.200
     1.492    29.125     0.200
     1.540    29.969     0.200
     1.540    30.562     0.200
     2.402    40.039     0.200
     2.402    40.422     0.200
     2.866    48.508     0.200
     3.366    52.617     0.200
     3.337    55.469     0.200
     3.710    58.570     0.200
     4.143    64.414     0.200
     4.410    67.008     0.200
     4.410    67.258     0.200
     4.410    67.375     0.200
     4.916    74.875     0.200
     5.160    76.727     0.200
     4.930    77.258     0.200
     4.930    77.875     0.200
     5.388    80.742     0.200
     5.423    80.898     0.200
     5.458    81.797     0.200
     5.575    86.805     0.200
     5.916    89.016     0.200
     6.073    90.508     0.200
     6.073    89.664     0.200
     5.975    91.156     0.200
     6.311    93.797     0.200
     6.749    99.898     0.200
     6.841   101.148     0.200
     6.841   100.812     0.200
     6.877   102.773     0.200
     6.877   101.703     0.200
     7.029   103.977     0.200
     7.320   107.859     0.200
     7.320   108.555     0.200
     7.388   108.359     0.200
     7.523   110.500     0.200
     7.679   111.000     0.200
     7.725   112.031     0.200
     8.268   121.062     0.200
     8.298   121.305     0.200
     8.300   120.875     0.200
     8.453   123.578     0.200
     8.453   122.602     0.200
     8.455   122.836     0.200
     8.575   126.297     0.200
     8.575   125.617     0.200
     8.588   124.969     0.200
     8.588   124.586     0.200
     8.921   129.539     0.200
     8.924   129.055     0.200
     8.924   128.828     0.200
     8.952   130.289     0.200
     8.952   130.398     0.200
     8.992   129.805     0.200
     8.992   129.250     0.200
     9.087   131.930     0.200
     9.087   131.414     0.200
     9.339   135.484     0.200
     9.357   134.156     0.200
     9.357   135.000     0.200
     9.668   139.234     0.200
     9.668   138.484     0.200
     9.672   138.758     0.200
     9.676   140.055     0.200
     9.676   139.875     0.200
     9.372   138.898     0.200
     9.749   139.695     0.200
     9.787   141.055     0.200
     9.787   140.336     0.200
     9.832   140.758     0.200
     9.978   143.086     0.200
     9.978   143.453     0.200
     9.807   143.664     0.200
     9.807   144.273     0.200
    10.146   147.453     0.200
    10.182   145.688     0.200
    10.231   145.766     0.200
    10.231   146.750     0.200
    10.231   146.578     0.200
    10.352   147.727     0.200
    10.352   148.547     0.200
    10.089   148.234     0.200
    10.418   149.906     0.200
    10.418   150.133     0.200
    10.473   151.219     0.200
    10.473   151.055     0.200
    10.529   149.875     0.200
    10.604   152.547     0.200
    10.615   152.578     0.200
    10.615   153.070     0.200
    10.631   151.242     0.200
    10.675   152.336     0.200
    10.675   152.586     0.200
    10.713   152.734     0.200
    10.778   154.414     0.200
    10.948   156.383     0.200
    10.983   157.938     0.200
    11.183   158.688     0.200
    11.183   158.828     0.200
    11.205   160.047     0.200
    11.205   160.188     0.200
    11.263   160.914     0.200
    11.263   160.625     0.200
    11.510   164.938     0.200
    11.499   163.320     0.200
    11.543   164.125     0.200
    11.720   168.133     0.200
    11.750   166.844     0.200
    11.753   167.344     0.200
    11.752   170.055     0.200
    11.752   169.164     0.200
    11.801   168.469     0.200
    11.839   170.156     0.200
    11.839   169.305     0.200
    11.858   166.453     0.200
    11.858   166.875     0.200
    11.931   169.734     0.200
    12.010   171.430     0.200
    12.170   173.836     0.200
    12.206   173.430     0.200
    12.238   174.898     0.200
    12.288   171.680     0.200
    12.331   175.883     0.200
    12.398   173.844     0.200
    12.398   175.273     0.200
    12.398   173.578     0.200
    12.469   177.945     0.200
    12.474   179.039     0.200
    12.548   178.836     0.200
    12.538   178.820     0.200
    12.580   175.680     0.200
    12.580   175.656     0.200
    12.322   176.188     0.200
    12.674   179.320     0.200
    12.700   178.484     0.200
    12.700   179.055     0.200
    12.706   180.297     0.200
    12.753   181.164     0.200
    12.780   181.305     0.200
    12.795   182.273     0.200
    12.832   181.859     0.200
    12.832   182.375     0.200
    12.904   181.008     0.200
    12.911   181.734     0.200
    12.911   182.797     0.200
    13.071   185.508     0.200
    13.142   186.195     0.200
    13.160   184.398     0.200
    13.167   185.883     0.200
    13.177   187.453     0.200
    13.194   187.445     0.200
    13.378   190.359     0.200
    13.383   189.477     0.200
    13.395   189.867     0.200
    13.402   190.547     0.200
    13.455   190.992     0.200
    13.524   189.203     0.200
    13.524   190.609     0.200
    13.641   193.391     0.200
    13.696   194.523     0.200
    13.702   195.828     0.200
    13.765   196.570     0.200
    13.823   196.195     0.200
    13.882   196.289     0.200
    13.882   197.523     0.200
    13.972   197.312     0.200
    14.065   198.805     0.200
    14.059   198.578     0.200
    14.206   200.562     0.200
    14.175   200.094     0.200
    14.292   201.891     0.200
    14.344   203.484     0.200
    14.373   201.586     0.200
    14.373   202.312     0.200
    14.401   202.203     0.200
    14.575   205.617     0.200
    14.602   204.227     0.200
    14.602   206.164     0.200
    14.630   207.031     0.200
    14.728   207.617     0.200
    14.744   206.461     0.200
    14.942   210.570     0.200
    14.969   211.266     0.200
    15.053   211.656     0.200
    15.053   211.422     0.200
    15.042   212.328     0.200
    15.118   213.328     0.200
    15.188   214.062     0.200
    15.175   213.758     0.200
    15.175   214.680     0.200
    15.236   211.750     0.200
    15.260   215.312     0.200
    15.262   215.039     0.200
    15.390   216.102     0.200
    15.547   218.008     0.200
    15.548   218.531     0.200
    15.565   218.664     0.200
    15.648   221.172     0.200
    15.697   220.984     0.200
    15.895   223.297     0.200
    16.184   227.664     0.200
    16.207   226.875     0.200
    16.371   228.492     0.200
    16.370   229.570     0.200
    16.413   229.969     0.200
    16.552   231.664     0.200
    16.804   235.906     0.200
    16.892   236.594     0.200
    17.022   237.938     0.200
    17.187   239.273     0.200
    17.193   239.172     0.200
    17.314   240.742     0.200
    17.410   241.852     0.200
    17.475   241.398     0.200
    19.511   268.211     0.200
     1.358    24.803     0.200
     1.971    32.272     0.200
     1.971    32.433     0.200
     3.285    50.390     0.200
     3.712    56.493     0.200
     4.369    65.528     0.200
     4.494    67.096     0.200
     4.538    67.353     0.200
     4.958    73.191     0.200
     5.062    74.259     0.200
     5.359    77.017     0.200
     5.359    77.423     0.200
     5.359    78.072     0.200
     5.394    78.743     0.200
     5.490    80.732     0.200
     5.490    80.952     0.200
     5.271    81.202     0.200
     5.888    84.492     0.200
     5.851    85.226     0.200
     6.034    90.463     0.200
     6.034    89.899     0.200
     6.416    92.242     0.200
     6.416    93.560     0.200
     6.599    95.013     0.200
     6.900   100.622     0.200
     6.959   100.242     0.200
     7.249   103.782     0.200
     7.885   113.312     0.200
     7.885   113.651     0.200
     7.990   115.162     0.200
     8.044   115.161     0.200
     8.155   118.032     0.200
     8.155   117.812     0.200
     8.495   121.353     0.200
     8.495   121.179     0.200
     8.508   121.956     0.200
     8.562   123.032     0.200
     8.558   122.312     0.200
     8.661   123.933     0.200
     8.927   126.622     0.200
     8.927   127.104     0.200
     9.237   130.893     0.200
     9.237   131.542     0.200
     9.270   132.133     0.200
     9.318   132.473     0.200
     9.729   139.272     0.200
     9.921   139.412     0.200
     9.921   140.329     0.200
    10.192   144.843     0.200
    10.245   144.362     0.200
    10.192   144.253     0.200
    10.517   148.133     0.200
    10.835   152.463     0.200
    11.072   155.833     0.200
    11.593   161.982     0.200
    11.493   162.763     0.200
    11.777   165.673     0.200
    11.862   164.923     0.200
    11.901   166.492     0.200
    11.946   168.383     0.200
    12.039   169.933     0.200
    12.117   170.893     0.200
    12.155   168.083     0.200
    12.243   171.963     0.200
    12.481   174.372     0.200
    13.942   193.872     0.200
    14.171   197.452     0.200
    14.544   204.293     0.200
    14.817   207.103     0.200
    15.779   218.683     0.200
    16.374   226.162     0.200
     1.335    21.785     0.200
     1.335    22.055     0.200
     1.563    26.859     0.200
     2.263    35.934     0.200
     2.263    38.254     0.200
     2.677    40.906     0.200
     3.064    46.922     0.200
     3.730    55.457     0.200
     3.892    58.141     0.200
     4.005    59.824     0.200
     3.769    57.387     0.200
     4.313    64.043     0.200
     4.312    63.809     0.200
     4.271    65.156     0.200
     4.271    65.277     0.200
     4.548    67.637     0.200
     4.678    67.902     0.200
     4.842    70.836     0.200
     4.871    71.516     0.200
     4.871    71.324     0.200
     4.983    73.184     0.200
     4.983    74.160     0.200
     5.240    76.426     0.200
     5.281    77.465     0.200
     5.281    77.906     0.200
     5.381    79.551     0.200
     5.669    83.375     0.200
     5.670    83.406     0.200
     5.798    84.035     0.200
     5.798    84.262     0.200
     5.957    87.016     0.200
     6.197    90.281     0.200
     6.289    91.773     0.200
     6.300    91.785     0.200
     6.300    91.453     0.200
     6.342    91.715     0.200
     6.456    94.824     0.200
     6.580    93.637     0.200
     6.624    94.477     0.200
     6.624    94.586     0.200
     7.240   104.754     0.200
     7.307   104.887     0.200
     7.307   105.156     0.200
     7.328   106.105     0.200
     7.482   107.137     0.200
     7.482   107.691     0.200
     7.492   107.535     0.200
     7.554   109.234     0.200
     7.853   112.496     0.200
     7.853   113.023     0.200
     7.905   113.355     0.200
     7.932   113.758     0.200
     8.038   116.914     0.200
     8.038   115.562     0.200
     8.135   116.078     0.200
     8.259   117.625     0.200
     8.259   118.145     0.200
     8.577   121.816     0.200
     8.577   122.031     0.200
     8.658   124.375     0.200
     8.658   124.016     0.200
     8.667   124.086     0.200
     8.713   124.637     0.200
     8.713   124.172     0.200
     8.892   126.227     0.200
     9.127   129.234     0.200
     9.127   129.551     0.200
     9.142   128.684     0.200
     9.142   130.234     0.200
     9.261   130.887     0.200
     9.261   131.059     0.200
     9.426   131.035     0.200
     9.478   133.465     0.200
     9.515   135.297     0.200
     9.564   134.695     0.200
     9.582   136.613     0.200
     9.575   134.445     0.200
     9.575   135.023     0.200
     9.743   137.914     0.200
     9.854   139.734     0.200
     9.854   138.547     0.200
     9.913   140.035     0.200
     9.975   140.727     0.200
    10.161   144.504     0.200
    10.161   143.266     0.200
    10.260   144.246     0.200
    10.396   145.406     0.200
    10.440   146.984     0.200
    10.664   150.355     0.200
    10.697   150.715     0.200
    10.753   151.594     0.200
    10.833   150.594     0.200
    10.847   152.156     0.200
    10.978   153.023     0.200
    11.067   156.836     0.200
    11.143   157.074     0.200
    11.192   154.273     0.200
    11.236   154.766     0.200
    11.237   157.414     0.200
    11.230   156.836     0.200
    11.252   159.016     0.200
    11.265   158.426     0.200
    11.253   159.426     0.200
    11.340   157.477     0.200
    11.390   158.484     0.200
    11.447   161.324     0.200
    11.534   160.344     0.200
    11.534   159.789     0.200
    11.534   159.105     0.200
    11.589   161.574     0.200
    11.706   164.094     0.200
    11.787   164.086     0.200
    11.830   164.887     0.200
    12.043   167.207     0.200
    12.062   168.785     0.200
    12.153   172.156     0.200
    12.514   175.664     0.200
    13.000   179.844     0.200
    13.290   184.734     0.200
    13.743   192.086     0.200
    13.866   195.234     0.200
    14.130   197.465     0.200
    14.217   198.137     0.200
    15.270   213.066     0.200
    15.724   220.465     0.200
    16.427   226.359     0.200
    17.853   243.887     0.200
    17.853   243.785     0.200
     1.322    23.877     0.200
     1.321    23.637     0.200
     1.340    24.006     0.200
     1.351    24.348     0.200
     1.470    25.637     0.200
     1.497    25.727     0.200
     1.551    27.006     0.200
     1.453    26.236     0.200
     1.478    25.768     0.200
     1.603    27.961     0.200
     1.604    27.967     0.200
     1.620    28.406     0.200
     1.633    28.438     0.200
     1.801    29.666     0.200
     1.801    30.076     0.200
     2.087    34.826     0.200
     2.087    35.537     0.200
     2.287    36.727     0.200
     2.358    38.018     0.200
     2.419    39.426     0.200
     2.255    37.256     0.200
     2.438    39.176     0.200
     2.295    38.566     0.200
     2.420    40.527     0.200
     2.422    40.277     0.200
     2.659    40.688     0.200
     2.495    41.336     0.200
     2.856    46.018     0.200
     2.885    46.688     0.200
     3.144    48.756     0.200
     3.524    54.018     0.200
     3.476    54.646     0.200
     3.706    55.557     0.200
     3.706    55.438     0.200
     3.520    52.857     0.200
     3.520    55.137     0.200
     3.549    55.848     0.200
     3.620    56.197     0.200
     4.006    61.037     0.200
     4.192    62.662     0.200
     4.194    62.666     0.200
     4.257    63.768     0.200
     4.077    62.637     0.200
     4.100    62.396     0.200
     4.150    63.268     0.200
     4.463    64.797     0.200
     4.463    65.236     0.200
     4.267    64.656     0.200
     4.467    66.787     0.200
     4.474    66.367     0.200
     4.465    66.826     0.200
     4.640    69.018     0.200
     4.773    70.586     0.200
     4.772    70.586     0.200
     4.879    72.127     0.200
     5.003    73.717     0.200
     5.089    75.256     0.200
     5.089    73.230     0.200
     5.305    78.098     0.200
     5.337    78.287     0.200
     5.341    79.066     0.200
     5.435    80.188     0.200
     5.493    80.887     0.200
     5.674    82.689     0.200
     5.676    82.688     0.200
     5.748    84.336     0.200
     5.825    85.576     0.200
     6.019    88.348     0.200
     6.036    88.227     0.200
     6.041    88.617     0.200
     6.182    90.176     0.200
     6.264    92.736     0.200
     6.362    92.746     0.200
     6.364    93.268     0.200
     6.363    94.938     0.200
     6.731    98.477     0.200
     6.657    96.727     0.200
     6.768    99.197     0.200
     6.768    98.088     0.200
     6.807    99.967     0.200
     6.807    99.236     0.200
     6.845    99.518     0.200
     6.918   103.477     0.200
     6.837    99.227     0.200
     7.041   101.768     0.200
     7.060   101.836     0.200
     7.138   103.256     0.200
     7.506   107.707     0.200
     7.675   110.807     0.200
     7.725   110.938     0.200
     7.793   111.496     0.200
     7.691   111.197     0.200
     7.774   112.027     0.200
     7.947   115.566     0.200
     7.947   114.670     0.200
     8.086   115.986     0.200
     8.308   118.926     0.200
     8.399   119.547     0.200
     8.703   123.219     0.200
     8.627   123.637     0.200
     8.739   124.348     0.200
     8.942   127.336     0.200
     9.178   131.576     0.200
     9.233   132.047     0.200
     9.571   136.047     0.200
     9.609   137.277     0.200
     9.937   141.768     0.200
     9.937   140.393     0.200
    10.015   142.018     0.200
    10.477   149.887     0.200
    10.757   154.576     0.200
    11.530   163.348     0.200
    11.712   166.256     0.200
    11.999   165.736     0.200
    12.128   171.037     0.200
    12.304   171.688     0.200
     0.881    16.250     0.200
     1.228    21.068     0.200
     1.274    22.578     0.200
     1.339    23.578     0.200
     1.405    24.850     0.200
     1.405    24.848     0.200
     1.465    24.777     0.200
     1.465    24.277     0.200
     1.573    27.117     0.200
     1.585    27.178     0.200
     1.633    28.158     0.200
     1.812    30.508     0.200
     1.845    30.918     0.200
     2.098    34.387     0.200
     2.108    33.988     0.200
     2.136    35.178     0.200
     2.462    39.848     0.200
     2.462    39.588     0.200
     2.462    39.736     0.200
     2.642    42.227     0.200
     2.669    43.268     0.200
     2.673    42.348     0.200
     2.810    44.967     0.200
     2.877    45.797     0.200
     3.149    48.277     0.200
     3.224    49.908     0.200
     3.267    48.777     0.200
     3.267    48.287     0.200
     3.267    48.957     0.200
     3.256    51.307     0.200
     3.259    51.307     0.200
     3.282    51.357     0.200
     3.824    57.287     0.200
     3.826    57.287     0.200
     3.877    58.127     0.200
     3.982    59.348     0.200
     3.889    59.688     0.200
     4.028    58.887     0.200
     4.028    58.488     0.200
     4.027    60.438     0.200
     3.932    60.398     0.200
     3.961    61.037     0.200
     4.087    61.627     0.200
     4.088    61.328     0.200
     4.032    62.008     0.200
     4.060    62.088     0.200
     4.190    62.768     0.200
     4.395    66.127     0.200
     4.395    65.248     0.200
     4.394    65.250     0.200
     4.424    66.287     0.200
     4.512    67.488     0.200
     4.553    67.438     0.200
     4.517    67.787     0.200
     4.659    67.367     0.200
     4.659    67.156     0.200
     4.565    68.438     0.200
     4.984    73.098     0.200
     5.040    73.908     0.200
     5.405    79.508     0.200
     5.744    83.578     0.200
     5.911    85.928     0.200
     6.039    87.928     0.200
     6.051    88.598     0.200
     6.322    90.508     0.200
     6.429    94.008     0.200
     6.496    94.227     0.200
     6.545    95.158     0.200
     6.616    94.607     0.200
     6.620    97.887     0.200
     7.453   107.287     0.200
     7.638   110.248     0.200
     7.935   113.078     0.200
     8.303   117.508     0.200
     8.307   117.367     0.200
     8.307   117.588     0.200
     8.532   120.617     0.200
     8.776   123.807     0.200
     8.827   125.467     0.200
     8.871   126.428     0.200
     9.127   128.588     0.200
     9.310   132.297     0.200
     9.352   133.787     0.200
     9.602   135.418     0.200
     9.658   136.357     0.200
     9.639   136.787     0.200
     9.696   137.127     0.200
    10.107   142.678     0.200
    10.180   143.877     0.200
    10.229   144.697     0.200
    10.454   149.338     0.200
    10.630   149.527     0.200
    10.637   149.318     0.200
    10.946   153.438     0.200
    10.953   152.998     0.200
    10.892   155.188     0.200
    11.086   153.957     0.200
    11.256   157.797     0.200
    11.233   158.377     0.200
    11.171   159.008     0.200
    11.308   159.947     0.200
    11.456   159.338     0.200
    11.636   159.838     0.200
    11.668   164.977     0.200
    11.689   163.287     0.200
    11.896   166.777     0.200
    11.929   165.328     0.200
    12.076   169.127     0.200
    12.391   172.717     0.200
    13.351   185.857     0.200
    15.040   208.707     0.200
    15.247   212.018     0.200
    15.789   219.127     0.200
    16.329   228.312     0.200
    17.933   245.797     0.200
    17.933   245.912     0.200
     0.369    10.699     0.200
     0.945    18.512     0.200
     1.518    24.844     0.200
     1.564    26.051     0.200
     1.572    25.852     0.200
     1.620    26.191     0.200
     1.620    26.914     0.200
     1.787    29.062     0.200
     2.135    31.449     0.200
     2.135    32.617     0.200
     2.367    37.859     0.200
     2.465    37.910     0.200
     2.707    41.078     0.200
     2.804    40.730     0.200
     2.804    41.289     0.200
     2.975    45.164     0.200
     3.031    46.141     0.200
     3.030    45.922     0.200
     3.237    48.660     0.200
     3.389    48.852     0.200
     3.360    50.797     0.200
     3.541    52.562     0.200
     3.633    54.062     0.200
     3.633    53.594     0.200
     3.680    54.891     0.200
     3.680    54.785     0.200
     3.670    54.590     0.200
     3.745    55.484     0.200
     3.930    57.465     0.200
     4.063    60.430     0.200
     4.063    60.062     0.200
     4.275    63.355     0.200
     4.379    64.121     0.200
     4.360    64.207     0.200
     4.446    65.711     0.200
     4.492    65.566     0.200
     4.675    68.641     0.200
     4.750    70.281     0.200
     4.750    69.613     0.200
     4.908    71.285     0.200
     4.868    71.062     0.200
     4.912    71.371     0.200
     4.978    72.141     0.200
     5.003    73.160     0.200
     5.091    74.312     0.200
     5.181    74.730     0.200
     5.160    75.387     0.200
     5.192    76.199     0.200
     5.269    74.652     0.200
     5.222    76.586     0.200
     5.313    75.363     0.200
     5.358    77.426     0.200
     5.427    80.227     0.200
     5.549    80.762     0.200
     5.721    82.555     0.200
     5.847    84.410     0.200
     5.927    85.484     0.200
     6.043    86.840     0.200
     6.092    87.512     0.200
     6.132    88.641     0.200
     6.158    88.871     0.200
     6.206    89.062     0.200
     6.335    92.180     0.200
     6.334    91.449     0.200
     6.519    94.172     0.200
     6.570    94.383     0.200
     6.604    93.891     0.200
     6.676    95.688     0.200
     6.756    97.375     0.200
     6.837    97.832     0.200
     6.948    99.191     0.200
     6.948    97.430     0.200
     7.295   104.211     0.200
     7.369   105.137     0.200
     7.379   104.570     0.200
     7.442   104.402     0.200
     7.449   106.027     0.200
     7.567   107.270     0.200
     7.954   112.359     0.200
     7.954   112.227     0.200
     7.939   113.551     0.200
     7.939   112.809     0.200
     7.970   114.031     0.200
     8.037   114.059     0.200
     8.263   116.723     0.200
     8.263   116.238     0.200
     8.342   117.262     0.200
     8.342   117.617     0.200
     8.351   119.109     0.200
     8.495   120.340     0.200
     8.546   120.461     0.200
     8.659   122.391     0.200
     8.766   124.211     0.200
     8.850   124.949     0.200
     9.132   128.742     0.200
     9.728   135.352     0.200
     9.943   137.852     0.200
     9.937   139.723     0.200
     9.970   138.422     0.200
    10.023   138.820     0.200
    10.103   139.883     0.200
    10.153   142.672     0.200
    10.275   142.391     0.200
    10.275   142.820     0.200
    10.534   145.980     0.200
    10.565   146.512     0.200
    10.591   147.051     0.200
    10.733   149.031     0.200
    10.751   149.281     0.200
    10.931   152.289     0.200
    11.028   154.930     0.200
    11.221   154.660     0.200
    11.718   161.820     0.200
     1.076    21.199     0.200
     1.104    22.410     0.200
     1.320    25.207     0.200
     1.552    28.180     0.200
     1.648    29.238     0.200
     1.644    29.879     0.200
     1.679    30.473     0.200
     1.680    30.477     0.200
     2.006    34.820     0.200
     2.006    33.945     0.200
     1.834    32.277     0.200
     1.854    34.207     0.200
     2.000    35.598     0.200
     2.001    35.160     0.200
     2.073    36.277     0.200
     2.361    40.320     0.200
     2.436    42.328     0.200
     2.445    41.527     0.200
     2.465    42.160     0.200
     3.034    47.250     0.200
     3.061    50.988     0.200
     3.104    51.590     0.200
     3.104    51.699     0.200
     3.134    51.789     0.200
     3.204    52.270     0.200
     3.204    52.438     0.200
     3.216    52.559     0.200
     3.232    52.727     0.200
     3.249    52.859     0.200
     3.276    53.828     0.200
     3.595    57.297     0.200
     3.595    57.098     0.200
     3.663    58.520     0.200
     3.688    58.227     0.200
     3.736    58.969     0.200
     3.820    60.359     0.200
     4.058    61.488     0.200
     4.058    61.297     0.200
     3.855    60.789     0.200
     4.402    66.957     0.200
     4.404    66.957     0.200
     4.484    68.270     0.200
     4.556    69.539     0.200
     4.574    70.000     0.200
     4.795    70.598     0.200
     4.795    71.000     0.200
     4.593    71.438     0.200
     5.077    76.680     0.200
     5.265    79.797     0.200
     5.405    79.477     0.200
     5.405    80.699     0.200
     5.405    78.617     0.200
     5.215    78.797     0.200
     5.481    82.418     0.200
     5.680    84.789     0.200
     5.860    87.508     0.200
     5.915    88.637     0.200
     5.958    88.711     0.200
     5.959    88.707     0.200
     5.915    88.957     0.200
     6.107    90.359     0.200
     5.983    91.090     0.200
     5.983    90.898     0.200
     5.983    90.320     0.200
     6.107    90.949     0.200
     6.388    94.797     0.200
     6.487    96.328     0.200
     6.487    96.000     0.200
     6.451    96.238     0.200
     6.633    98.918     0.200
     6.748    99.379     0.200
     6.925   103.090     0.200
     6.925   102.594     0.200
     6.911   101.570     0.200
     6.930   102.727     0.200
     6.930   102.598     0.200
     6.999   103.648     0.200
     7.007   102.297     0.200
     7.045   103.227     0.200
     7.541   109.570     0.200
     7.559   110.387     0.200
     7.625   111.297     0.200
     7.799   113.598     0.200
     7.907   116.348     0.200
     8.028   116.727     0.200
     8.067   116.789     0.200
     8.067   116.645     0.200
     8.064   117.738     0.200
     8.064   117.531     0.200
     8.116   117.898     0.200
     8.181   120.039     0.200
     8.214   119.500     0.200
     8.528   122.309     0.200
     8.598   124.297     0.200
     8.573   124.398     0.200
     8.602   124.648     0.200
     8.748   125.758     0.200
     8.967   128.617     0.200
     8.967   128.766     0.200
     9.000   129.938     0.200
     9.279   134.949     0.200
     9.289   134.809     0.200
     9.354   135.359     0.200
     9.467   135.168     0.200
     9.467   133.766     0.200
     9.583   137.137     0.200
     9.753   141.340     0.200
     9.849   140.469     0.200
     9.959   142.379     0.200
     9.959   141.410     0.200
    10.034   144.238     0.200
    10.064   146.797     0.200
    10.286   146.520     0.200
    10.343   151.117     0.200
    11.115   157.957     0.200
    11.355   162.887     0.200
    11.627   165.898     0.200
    11.973   169.770     0.200
    12.183   170.680     0.200
    12.183   168.543     0.200
    12.476   177.297     0.200
    12.751   180.410     0.200
    12.769   181.070     0.200
     1.339    23.186     0.200
     1.357    23.455     0.200
     1.436    25.115     0.200
     1.377    25.217     0.200
     1.405    24.807     0.200
     1.520    26.326     0.200
     1.553    26.455     0.200
     1.557    27.637     0.200
     1.557    27.342     0.200
     1.792    29.076     0.200
     1.792    29.721     0.200
     2.019    34.035     0.200
     2.019    34.666     0.200
     2.190    36.535     0.200
     2.228    37.926     0.200
     2.426    38.736     0.200
     2.354    39.346     0.200
     2.357    39.227     0.200
     2.698    41.096     0.200
     2.794    45.066     0.200
     2.822    46.006     0.200
     3.131    48.236     0.200
     3.131    48.342     0.200
     3.522    54.035     0.200
     3.522    54.191     0.200
     3.418    53.887     0.200
     3.462    54.576     0.200
     3.462    54.467     0.200
     3.491    54.227     0.200
     3.562    55.365     0.200
     3.562    55.896     0.200
     3.590    55.955     0.200
     3.608    56.637     0.200
     3.950    60.525     0.200
     4.020    61.855     0.200
     4.044    61.887     0.200
     4.188    63.727     0.200
     4.190    63.605     0.200
     4.177    63.467     0.200
     4.093    62.436     0.200
     4.256    63.945     0.200
     4.345    64.855     0.200
     4.211    63.936     0.200
     4.437    66.627     0.200
     4.454    66.227     0.200
     4.454    66.438     0.200
     4.489    65.266     0.200
     4.489    65.412     0.200
     4.588    68.646     0.200
     4.770    70.807     0.200
     4.772    70.445     0.200
     4.801    70.775     0.200
     4.863    72.506     0.200
     4.863    73.105     0.200
     4.974    74.266     0.200
     5.110    73.506     0.200
     5.281    77.736     0.200
     5.288    78.336     0.200
     5.288    78.025     0.200
     5.327    78.967     0.200
     5.449    80.656     0.200
     5.449    80.518     0.200
     5.439    79.926     0.200
     5.439    80.539     0.200
     5.687    83.723     0.200
     5.689    82.525     0.200
     5.735    84.467     0.200
     5.735    85.559     0.200
     5.789    85.016     0.200
     5.982    88.105     0.200
     5.990    87.105     0.200
     5.990    87.547     0.200
     5.992    87.006     0.200
     5.992    87.961     0.200
     6.130    89.816     0.200
     6.128    90.656     0.200
     6.327    92.436     0.200
     6.327    92.182     0.200
     6.342    93.236     0.200
     6.342    92.771     0.200
     6.478    94.477     0.200
     6.754    98.676     0.200
     6.784    98.637     0.200
     6.787    98.445     0.200
     6.787    99.467     0.200
     6.814    99.137     0.200
     6.912   101.387     0.200
     7.000   101.605     0.200
     7.011   100.695     0.200
     7.471   107.717     0.200
     7.471   108.035     0.200
     7.627   110.566     0.200
     7.632   110.666     0.200
     7.696   110.637     0.200
     7.696   110.828     0.200
     7.756   111.807     0.200
     7.926   114.547     0.200
     8.008   116.455     0.200
     8.008   116.104     0.200
     8.050   115.816     0.200
     8.050   116.047     0.200
     8.254   118.967     0.200
     8.312   120.086     0.200
     8.466   121.246     0.200
     8.466   122.467     0.200
     8.583   123.115     0.200
     8.712   123.506     0.200
     8.712   124.129     0.200
     8.911   126.766     0.200
     8.877   129.666     0.200
     9.033   128.816     0.200
     9.155   131.736     0.200
     9.375   131.887     0.200
     9.542   136.127     0.200
     9.542   136.232     0.200
     9.716   137.596     0.200
     9.913   141.275     0.200
     9.913   141.377     0.200
    10.026   141.377     0.200
    10.235   145.316     0.200
    10.309   146.865     0.200
     0.287     8.883     0.200
     0.296     8.902     0.200
     0.713    14.102     0.200
     0.713    14.375     0.200
     1.062    18.672     0.200
     1.088    19.523     0.200
     1.157    20.754     0.200
     1.219    21.953     0.200
     1.220    21.914     0.200
     1.334    22.113     0.200
     1.334    22.473     0.200
     1.425    24.445     0.200
     1.442    24.695     0.200
     1.474    25.223     0.200
     1.497    25.664     0.200
     1.570    26.762     0.200
     1.697    28.293     0.200
     1.829    29.543     0.200
     1.896    30.523     0.200
     1.960    31.414     0.200
     1.976    31.602     0.200
     1.997    32.195     0.200
     2.241    34.473     0.200
     2.367    38.422     0.200
     2.367    38.875     0.200
     2.367    38.016     0.200
     2.555    40.652     0.200
     2.578    41.633     0.200
     2.683    41.172     0.200
     2.683    41.016     0.200
     2.587    41.152     0.200
     2.705    43.512     0.200
     2.722    43.602     0.200
     2.785    44.332     0.200
     2.978    45.473     0.200
     3.048    46.773     0.200
     3.124    47.863     0.200
     3.123    47.473     0.200
     3.105    48.703     0.200
     3.229    48.945     0.200
     3.263    48.262     0.200
     3.263    48.574     0.200
     3.263    48.039     0.200
     3.175    49.562     0.200
     3.177    49.773     0.200
     3.689    55.215     0.200
     3.689    53.934     0.200
     3.718    55.473     0.200
     3.720    55.332     0.200
     3.780    56.543     0.200
     3.842    57.133     0.200
     3.904    58.395     0.200
     3.898    57.965     0.200
     3.898    58.098     0.200
     3.914    58.383     0.200
     3.821    58.543     0.200
     3.821    58.352     0.200
     3.864    58.504     0.200
     3.864    58.973     0.200
     3.990    59.473     0.200
     3.996    59.195     0.200
     3.894    59.242     0.200
     4.034    60.062     0.200
     4.034    59.957     0.200
     3.960    59.652     0.200
     3.965    59.555     0.200
     3.970    60.344     0.200
     3.974    60.074     0.200
     3.993    60.422     0.200
     4.150    60.844     0.200
     4.122    61.254     0.200
     4.122    60.527     0.200
     4.271    62.992     0.200
     4.297    63.465     0.200
     4.297    63.352     0.200
     4.296    63.258     0.200
     4.320    63.512     0.200
     4.320    63.734     0.200
     4.320    63.172     0.200
     4.421    65.195     0.200
     4.421    64.926     0.200
     4.466    65.645     0.200
     4.363    64.973     0.200
     4.363    65.273     0.200
     4.363    64.188     0.200
     4.424    66.043     0.200
     4.453    66.125     0.200
     4.581    66.984     0.200
     4.499    66.902     0.200
     4.624    66.352     0.200
     4.624    66.070     0.200
     4.624    66.191     0.200
     4.622    68.652     0.200
     4.867    71.203     0.200
     4.863    70.945     0.200
     4.957    72.574     0.200
     4.957    72.156     0.200
     5.025    73.723     0.200
     5.025    73.609     0.200
     5.125    75.363     0.200
     5.125    75.086     0.200
     5.199    75.594     0.200
     5.201    74.805     0.200
     5.282    77.082     0.200
     5.356    78.215     0.200
     5.360    78.402     0.200
     5.374    78.215     0.200
     5.390    78.465     0.200
     5.303    78.215     0.200
     5.423    79.203     0.200
     5.586    80.684     0.200
     5.586    80.840     0.200
     5.651    82.152     0.200
     5.651    81.871     0.200
     5.682    82.305     0.200
     5.682    82.500     0.200
     5.795    84.352     0.200
     5.795    84.090     0.200
     5.769    84.383     0.200
     5.863    85.074     0.200
     5.863    84.754     0.200
     5.912    85.652     0.200
     5.912    85.496     0.200
     5.941    86.082     0.200
     5.968    86.992     0.200
     5.968    86.457     0.200
     6.006    86.723     0.200
     5.996    89.875     0.200
     5.996    87.395     0.200
     6.178    89.215     0.200
     6.178    89.020     0.200
     6.194    89.289     0.200
     6.254    89.062     0.200
     6.304    91.574     0.200
     6.304    90.801     0.200
     6.357    91.973     0.200
     6.357    91.773     0.200
     6.403    92.262     0.200
     6.422    92.504     0.200
     6.422    93.172     0.200
     6.440    92.602     0.200
     6.440    92.352     0.200
     6.443    93.203     0.200
     6.475    93.473     0.200
     6.470    93.523     0.200
     6.470    93.191     0.200
     6.546    92.285     0.200
     6.458    93.703     0.200
     6.458    94.074     0.200
     6.529    93.762     0.200
     6.589    92.742     0.200
     6.589    93.344     0.200
     6.636    94.984     0.200
     6.656    95.363     0.200
     6.656    95.574     0.200
     6.694    95.633     0.200
     6.694    96.156     0.200
     6.719    95.945     0.200
     7.101   101.422     0.200
     7.101   101.273     0.200
     7.202   102.859     0.200
     7.203   103.242     0.200
     7.212   104.172     0.200
     7.230   103.582     0.200
     7.272   104.195     0.200
     7.300   102.652     0.200
     7.317   102.414     0.200
     7.317   104.414     0.200
     7.297   104.082     0.200
     7.297   104.301     0.200
     7.319   105.562     0.200
     7.319   105.090     0.200
     7.330   104.273     0.200
     7.331   105.602     0.200
     7.331   105.176     0.200
     7.461   107.062     0.200
     7.461   106.340     0.200
     7.499   107.992     0.200
     7.499   107.137     0.200
     7.552   107.812     0.200
     7.557   109.543     0.200
     7.557   108.961     0.200
     7.683   110.113     0.200
     7.683   109.383     0.200
     7.838   110.984     0.200
     7.881   111.543     0.200
     7.881   112.789     0.200
     7.944   113.723     0.200
     7.944   112.801     0.200
     8.032   114.512     0.200
     8.032   113.668     0.200
     8.000   114.383     0.200
     8.000   113.355     0.200
     8.062   114.684     0.200
     8.062   114.875     0.200
     8.062   113.863     0.200
     8.088   113.844     0.200
     8.088   114.512     0.200
     8.225   116.676     0.200
     8.251   116.719     0.200
     8.275   116.934     0.200
     8.280   116.973     0.200
     8.261   118.125     0.200
     8.261   117.508     0.200
     8.446   117.902     0.200
     8.446   118.273     0.200
     8.446   119.430     0.200
     8.521   121.695     0.200
     8.521   120.871     0.200
     8.550   119.164     0.200
     8.550   121.199     0.200
     8.645   120.672     0.200
     8.662   124.832     0.200
     8.662   124.500     0.200
     8.683   121.234     0.200
     8.715   120.793     0.200
     8.715   122.820     0.200
     8.722   123.023     0.200
     8.730   124.613     0.200
     8.730   123.289     0.200
     8.868   123.473     0.200
     8.868   125.070     0.200
     8.886   122.934     0.200
     8.867   126.562     0.200
     8.867   126.297     0.200
     9.065   128.242     0.200
     9.065   127.797     0.200
     9.081   127.645     0.200
     9.081   127.922     0.200
     9.148   130.285     0.200
     9.148   129.746     0.200
     9.141   129.762     0.200
     9.141   129.605     0.200
     9.233   128.984     0.200
     9.233   130.090     0.200
     9.376   132.742     0.200
     9.376   132.004     0.200
     9.386   132.113     0.200
     9.288   132.812     0.200
     9.288   132.473     0.200
     9.464   133.383     0.200
     9.465   132.023     0.200
     9.496   134.992     0.200
     9.496   134.152     0.200
     9.533   133.055     0.200
     9.520   134.473     0.200
     9.538   134.762     0.200
     9.550   132.582     0.200
     9.550   134.391     0.200
     9.615   133.035     0.200
     9.615   135.121     0.200
     9.624   135.742     0.200
     9.711   136.012     0.200
     9.729   137.035     0.200
     9.704   137.363     0.200
     9.779   138.035     0.200
     9.779   137.672     0.200
     9.780   137.945     0.200
     9.780   138.250     0.200
     9.824   138.715     0.200
     9.898   137.895     0.200
     9.915   137.672     0.200
     9.899   140.543     0.200
     9.899   139.750     0.200
     9.981   140.945     0.200
     9.989   141.633     0.200
     9.989   141.473     0.200
    10.047   142.422     0.200
    10.047   141.422     0.200
    10.093   140.094     0.200
    10.093   142.391     0.200
    10.122   141.805     0.200
    10.122   142.492     0.200
    10.123   143.695     0.200
    10.123   143.203     0.200
    10.155   141.957     0.200
    10.222   144.293     0.200
    10.304   145.062     0.200
    10.308   144.164     0.200
    10.326   144.559     0.200
    10.353   144.945     0.200
    10.385   146.090     0.200
    10.394   146.582     0.200
    10.444   146.715     0.200
    10.460   148.145     0.200
    10.460   147.152     0.200
    10.598   148.824     0.200
    10.583   149.543     0.200
    10.583   148.836     0.200
    10.615   149.844     0.200
    10.615   149.180     0.200
    10.639   148.703     0.200
    10.651   150.113     0.200
    10.651   149.070     0.200
    10.776   151.742     0.200
    10.768   152.242     0.200
    10.768   151.180     0.200
    10.834   150.945     0.200
    10.834   151.844     0.200
    10.862   153.684     0.200
    10.862   152.035     0.200
    10.915   152.184     0.200
    10.822   153.262     0.200
    10.822   153.473     0.200
    10.973   151.652     0.200
    10.982   155.602     0.200
    11.083   156.254     0.200
    11.091   155.703     0.200
    11.088   156.645     0.200
    11.088   155.590     0.200
    11.116   155.570     0.200
    11.160   157.312     0.200
    11.160   156.547     0.200
    11.194   156.371     0.200
    11.193   157.023     0.200
    11.193   157.188     0.200
    11.197   157.395     0.200
    11.188   154.914     0.200
    11.227   156.723     0.200
    11.235   158.562     0.200
    11.235   158.273     0.200
    11.242   156.836     0.200
    11.290   158.684     0.200
    11.278   158.852     0.200
    11.339   157.234     0.200
    11.361   159.965     0.200
    11.361   158.781     0.200
    11.385   159.941     0.200
    11.423   160.453     0.200
    11.423   160.309     0.200
    11.444   161.164     0.200
    11.444   161.035     0.200
    11.527   158.324     0.200
    11.567   162.773     0.200
    11.611   163.535     0.200
    11.611   162.348     0.200
    11.642   162.922     0.200
    11.641   163.023     0.200
    11.663   163.137     0.200
    11.682   164.074     0.200
    11.682   163.414     0.200
    11.795   165.047     0.200
    11.809   163.285     0.200
    11.809   164.297     0.200
    11.829   164.375     0.200
    11.829   164.707     0.200
    11.818   166.652     0.200
    11.818   165.434     0.200
    11.823   167.492     0.200
    11.823   165.629     0.200
    11.920   166.820     0.200
    12.009   167.645     0.200
    12.009   167.820     0.200
    12.023   168.016     0.200
    12.027   167.512     0.200
    12.049   167.949     0.200
    12.138   171.484     0.200
    12.138   169.906     0.200
    12.156   170.254     0.200
    12.249   171.922     0.200
    12.249   171.457     0.200
    12.300   170.922     0.200
    12.405   173.355     0.200
    12.461   173.758     0.200
    12.473   173.453     0.200
    12.473   173.863     0.200
    12.493   175.523     0.200
    12.493   174.902     0.200
    12.488   173.395     0.200
    12.466   176.824     0.200
    12.500   175.363     0.200
    12.500   175.156     0.200
    12.502   176.293     0.200
    12.502   175.055     0.200
    12.541   175.629     0.200
    12.547   176.551     0.200
    12.905   180.113     0.200
    12.942   180.535     0.200
    12.984   181.555     0.200
    12.976   181.613     0.200
    12.985   180.992     0.200
    12.990   181.430     0.200
    13.055   182.363     0.200
    13.055   181.801     0.200
    13.056   182.184     0.200
    13.056   181.945     0.200
    13.267   184.082     0.200
    13.291   185.645     0.200
    13.291   185.098     0.200
    13.311   186.473     0.200
    13.330   185.848     0.200
    13.372   187.473     0.200
    13.474   187.363     0.200
    13.474   187.254     0.200
    13.486   188.754     0.200
    13.486   187.941     0.200
    13.481   188.266     0.200
    13.535   188.273     0.200
    13.557   189.184     0.200
    13.567   190.262     0.200
    13.567   189.504     0.200
    13.567   189.672     0.200
    13.604   189.473     0.200
    13.657   190.223     0.200
    13.643   190.344     0.200
    13.672   192.973     0.200
    13.672   190.445     0.200
    13.746   191.027     0.200
    13.796   192.039     0.200
    13.819   192.246     0.200
    13.898   194.195     0.200
    13.992   194.625     0.200
    14.071   197.004     0.200
    14.091   196.043     0.200
    14.091   195.559     0.200
    14.110   197.223     0.200
    14.110   196.551     0.200
    14.114   195.879     0.200
    14.118   196.074     0.200
    14.188   200.094     0.200
    14.219   197.672     0.200
    14.285   198.754     0.200
    14.339   200.715     0.200
    14.339   198.605     0.200
    14.487   200.203     0.200
    14.487   200.453     0.200
    14.504   200.961     0.200
    14.493   201.555     0.200
    14.533   202.180     0.200
    14.585   203.984     0.200
    14.585   202.750     0.200
    14.576   204.664     0.200
    14.576   202.289     0.200
    14.741   205.586     0.200
    14.755   205.523     0.200
    14.823   205.109     0.200
    14.881   208.055     0.200
    14.881   206.824     0.200
    14.913   209.172     0.200
    14.913   207.410     0.200
    15.035   210.652     0.200
    15.035   208.633     0.200
    15.021   209.020     0.200
    15.074   209.363     0.200
    15.076   210.219     0.200
    15.189   210.844     0.200
    15.216   211.723     0.200
    15.217   211.582     0.200
    15.325   212.102     0.200
    15.325   213.031     0.200
    15.460   214.285     0.200
    15.458   214.887     0.200
    15.522   216.375     0.200
    15.522   215.340     0.200
    15.550   214.094     0.200
    15.550   215.168     0.200
    15.547   215.012     0.200
    15.547   216.031     0.200
    15.617   215.465     0.200
    15.617   216.754     0.200
    15.702   217.965     0.200
    15.702   218.215     0.200
    15.775   220.203     0.200
    15.775   219.109     0.200
    15.785   219.074     0.200
    15.883   221.273     0.200
    15.883   220.574     0.200
    16.103   222.805     0.200
    16.221   224.109     0.200
    16.235   224.555     0.200
    16.310   225.945     0.200
    16.349   226.715     0.200
    16.349   225.543     0.200
    16.346   225.512     0.200
    16.346   226.070     0.200
    16.481   228.523     0.200
    16.481   227.289     0.200
    16.626   228.973     0.200
    16.734   229.836     0.200
    16.822   230.102     0.200
    16.822   230.973     0.200
    17.025   233.621     0.200
    17.072   234.305     0.200
    17.278   234.895     0.200
    17.278   236.121     0.200
    17.422   238.523     0.200
    17.837   242.613     0.200
    17.837   242.977     0.200
    17.837   242.348     0.200
     1.223    21.484     0.200
     1.320    22.805     0.200
     1.354    23.924     0.200
     1.486    25.875     0.200
     1.567    26.514     0.200
     1.553    27.064     0.200
     1.562    27.225     0.200
     1.694    29.465     0.200
     1.770    29.574     0.200
     2.166    35.064     0.200
     2.211    35.414     0.200
     2.311    36.895     0.200
     2.407    39.115     0.200
     2.407    39.895     0.200
     2.583    41.635     0.200
     2.617    42.764     0.200
     2.751    44.314     0.200
     3.255    50.195     0.200
     3.364    50.994     0.200
     3.219    50.834     0.200
     3.819    59.445     0.200
     3.862    59.965     0.200
     3.990    61.295     0.200
     4.286    63.545     0.200
     4.387    65.074     0.200
     4.387    65.945     0.200
     4.351    65.285     0.200
     4.351    65.094     0.200
     4.421    66.895     0.200
     4.586    68.324     0.200
     4.577    68.844     0.200
     4.761    68.285     0.200
     4.761    68.539     0.200
     4.836    71.154     0.200
     5.147    75.805     0.200
     5.291    77.945     0.200
     5.390    78.945     0.200
     5.509    81.045     0.200
     5.684    83.025     0.200
     5.949    86.705     0.200
     6.016    88.045     0.200
     6.031    88.385     0.200
     6.153    90.654     0.200
     6.128    89.375     0.200
     6.128    89.195     0.200
     6.230    90.654     0.200
     6.427    94.334     0.200
     6.533    93.934     0.200
     6.598    95.625     0.200
     6.598    95.795     0.200
     6.651    96.705     0.200
     6.677    96.195     0.200
     6.721    95.865     0.200
     6.716    96.865     0.200
     6.841    98.074     0.200
     6.794    97.924     0.200
     6.919    99.404     0.200
     6.938    99.324     0.200
     6.985    99.824     0.200
     7.361   105.375     0.200
     7.549   107.635     0.200
     7.597   109.875     0.200
     7.682   110.885     0.200
     7.740   110.865     0.200
     7.784   112.115     0.200
     7.943   112.994     0.200
     8.041   114.834     0.200
     8.248   118.744     0.200
     8.266   118.344     0.200
     8.313   119.635     0.200
     8.313   119.195     0.200
     8.526   121.805     0.200
     8.612   121.955     0.200
     8.734   124.234     0.200
     8.776   124.725     0.200
     8.838   126.174     0.200
     8.973   128.955     0.200
     9.045   126.455     0.200
     9.057   128.385     0.200
     9.132   129.934     0.200
     9.231   130.094     0.200
     9.380   133.715     0.200
     9.416   132.885     0.200
     9.707   137.064     0.200
     9.743   138.834     0.200
     9.801   137.865     0.200
    10.004   141.635     0.200
    10.163   144.455     0.200
    10.285   146.434     0.200
    10.254   145.855     0.200
    10.384   146.664     0.200
    10.447   147.994     0.200
    10.508   149.225     0.200
    10.544   148.365     0.200
    10.726   153.115     0.200
    11.047   155.404     0.200
    11.090   158.205     0.200
    11.124   158.145     0.200
    11.208   158.824     0.200
    11.248   160.264     0.200
    11.333   160.055     0.200
    11.361   160.215     0.200
    11.419   162.434     0.200
    11.470   159.504     0.200
    11.527   163.645     0.200
    11.564   162.535     0.200
    11.742   161.875     0.200
    11.742   162.014     0.200
    11.742   161.354     0.200
    11.785   166.594     0.200
    12.002   168.125     0.200
    13.400   191.525     0.200
    13.457   186.684     0.200
    13.649   191.014     0.200
    14.583   205.715     0.200
    16.418   227.244     0.200
    17.013   234.014     0.200
    18.039   246.955     0.200
    18.039   246.420     0.200
     0.409    10.344     0.200
     0.535    11.359     0.200
     0.538    11.266     0.200
     0.862    17.125     0.200
     0.860    17.133     0.200
     0.880    17.430     0.200
     0.892    17.922     0.200
     0.992    19.383     0.200
     1.041    19.844     0.200
     1.449    24.891     0.200
     1.450    24.875     0.200
     1.803    28.977     0.200
     1.803    29.352     0.200
     1.689    29.305     0.200
     1.689    30.070     0.200
     1.689    29.461     0.200
     1.900    32.977     0.200
     2.244    35.234     0.200
     2.103    35.555     0.200
     2.105    35.734     0.200
     2.337    36.695     0.200
     2.405    37.883     0.200
     2.420    40.141     0.200
     2.492    41.227     0.200
     2.517    41.516     0.200
     2.918    43.547     0.200
     2.918    43.930     0.200
     3.096    46.047     0.200
     3.096    46.953     0.200
     3.136    49.953     0.200
     3.178    50.102     0.200
     3.178    50.570     0.200
     3.209    51.086     0.200
     3.440    52.555     0.200
     3.243    51.430     0.200
     3.274    51.773     0.200
     3.279    52.094     0.200
     3.289    52.227     0.200
     3.307    52.492     0.200
     3.543    53.805     0.200
     3.623    55.266     0.200
     3.679    56.766     0.200
     3.679    56.984     0.200
     3.919    57.766     0.200
     3.919    58.375     0.200
     3.919    58.508     0.200
     3.738    58.062     0.200
     3.768    58.156     0.200
     3.814    58.797     0.200
     3.903    60.164     0.200
     4.192    61.656     0.200
     4.194    62.750     0.200
     4.275    62.875     0.200
     4.275    63.469     0.200
     4.279    63.062     0.200
     4.262    62.891     0.200
     4.262    63.250     0.200
     4.299    63.891     0.200
     4.299    63.758     0.200
     4.323    63.867     0.200
     4.323    63.469     0.200
     4.344    64.070     0.200
     4.486    66.883     0.200
     4.640    66.797     0.200
     4.640    67.430     0.200
     4.787    70.992     0.200
     4.785    70.641     0.200
     4.804    70.555     0.200
     4.804    71.047     0.200
     4.619    69.844     0.200
     4.839    70.445     0.200
     4.844    71.336     0.200
     4.701    70.984     0.200
     5.037    73.523     0.200
     5.037    73.227     0.200
     5.182    75.172     0.200
     5.182    76.023     0.200
     5.239    74.812     0.200
     5.239    75.039     0.200
     5.246    76.203     0.200
     5.246    76.914     0.200
     5.480    79.781     0.200
     5.625    82.156     0.200
     5.694    82.812     0.200
     5.694    83.758     0.200
     5.697    82.984     0.200
     5.697    83.547     0.200
     5.774    84.227     0.200
     5.776    83.055     0.200
     5.771    82.961     0.200
     5.771    83.477     0.200
     5.874    85.352     0.200
     5.879    84.844     0.200
     5.904    86.195     0.200
     5.904    86.875     0.200
     5.871    87.672     0.200
     6.153    88.875     0.200
     6.226    90.117     0.200
     6.226    91.031     0.200
     6.257    90.914     0.200
     6.256    90.227     0.200
     6.490    94.773     0.200
     6.522    93.578     0.200
     6.671    96.820     0.200
     6.676    96.328     0.200
     6.702    97.133     0.200
     6.701    96.172     0.200
     6.701    96.672     0.200
     6.807    97.695     0.200
     6.810    97.672     0.200
     6.875   100.125     0.200
     6.906   100.531     0.200
     6.914   100.266     0.200
     7.014   100.266     0.200
     7.014   101.172     0.200
     7.111   102.633     0.200
     7.144   101.961     0.200
     7.305   103.695     0.200
     7.305   104.375     0.200
     7.394   105.391     0.200
     7.394   105.930     0.200
     7.564   107.484     0.200
     7.564   108.141     0.200
     7.654   109.016     0.200
     7.655   110.430     0.200
     7.656   109.094     0.200
     7.724   111.523     0.200
     7.784   111.875     0.200
     7.829   112.461     0.200
     7.834   112.117     0.200
     7.877   111.492     0.200
     7.877   112.562     0.200
     7.881   111.727     0.200
     7.881   112.672     0.200
     7.957   114.898     0.200
     8.002   115.094     0.200
     7.989   113.977     0.200
     8.302   118.312     0.200
     8.316   117.664     0.200
     8.316   118.812     0.200
     8.339   118.031     0.200
     8.339   118.273     0.200
     8.395   119.516     0.200
     8.369   118.711     0.200
     8.472   120.617     0.200
     8.472   122.742     0.200
     8.518   123.633     0.200
     8.603   123.664     0.200
     8.603   124.672     0.200
     8.895   125.297     0.200
     8.952   126.391     0.200
     8.952   127.875     0.200
     8.952   126.953     0.200
     8.974   127.547     0.200
     9.053   131.234     0.200
     9.058   128.695     0.200
     9.074   127.820     0.200
     9.074   128.070     0.200
     9.147   128.977     0.200
     9.174   129.891     0.200
     9.269   129.711     0.200
     9.278   130.477     0.200
     9.278   131.000     0.200
     9.379   131.781     0.200
     9.379   132.875     0.200
     9.410   133.078     0.200
     9.461   132.102     0.200
     9.526   133.812     0.200
     9.526   136.102     0.200
     9.586   134.516     0.200
     9.670   136.273     0.200
     9.670   136.039     0.200
     9.758   137.000     0.200
     9.758   137.648     0.200
     9.767   137.945     0.200
     9.767   138.297     0.200
     9.801   138.617     0.200
     9.879   140.844     0.200
     9.918   139.523     0.200
     9.717   138.195     0.200
     9.931   139.453     0.200
     9.955   138.945     0.200
     9.994   140.914     0.200
     9.994   140.281     0.200
     9.790   139.312     0.200
     9.997   141.281     0.200
     9.997   141.914     0.200
     9.959   140.844     0.200
     9.959   140.648     0.200
    10.001   141.047     0.200
    10.001   141.477     0.200
    10.021   140.695     0.200
    10.021   140.414     0.200
    10.033   142.297     0.200
    10.094   141.391     0.200
    10.094   141.656     0.200
    10.108   141.828     0.200
    10.231   143.703     0.200
    10.238   144.633     0.200
    10.300   145.680     0.200
    10.332   147.023     0.200
    10.356   145.211     0.200
    10.356   145.656     0.200
    10.365   145.711     0.200
    10.361   145.453     0.200
    10.364   145.953     0.200
    10.364   147.453     0.200
    10.527   148.594     0.200
    10.527   148.797     0.200
    10.575   148.203     0.200
    10.575   148.914     0.200
    10.590   149.875     0.200
    10.526   149.688     0.200
    10.414   148.781     0.200
    10.596   150.406     0.200
    10.688   150.203     0.200
    10.823   152.234     0.200
    10.807   152.547     0.200
    10.911   152.164     0.200
    10.919   153.781     0.200
    10.917   152.523     0.200
    10.930   153.117     0.200
    10.930   152.281     0.200
    10.941   154.273     0.200
    10.981   153.164     0.200
    10.951   154.383     0.200
    10.993   154.797     0.200
    11.049   154.523     0.200
    11.028   155.484     0.200
    11.102   156.180     0.200
    11.151   156.555     0.200
    11.219   158.977     0.200
    11.239   156.734     0.200
    11.239   157.898     0.200
    11.240   159.062     0.200
    11.262   158.766     0.200
    11.362   159.797     0.200
    11.394   159.969     0.200
    11.526   161.641     0.200
    11.557   162.102     0.200
    11.546   162.805     0.200
    11.614   160.250     0.200
    11.627   163.344     0.200
    11.673   162.570     0.200
    11.673   163.867     0.200
    11.705   163.602     0.200
    11.749   165.305     0.200
    11.749   162.664     0.200
    11.767   163.602     0.200
    11.780   164.875     0.200
    11.780   165.359     0.200
    11.805   164.203     0.200
    11.865   164.844     0.200
    11.865   164.164     0.200
    11.856   167.117     0.200
    11.903   165.656     0.200
    11.957   167.758     0.200
    11.964   165.305     0.200
    11.964   165.836     0.200
    11.964   165.672     0.200
    12.018   168.766     0.200
    12.005   167.562     0.200
    12.082   168.539     0.200
    12.094   169.711     0.200
    12.177   170.891     0.200
    12.200   170.602     0.200
    12.280   171.523     0.200
    12.292   170.742     0.200
    12.308   171.680     0.200
    12.308   171.820     0.200
    12.326   172.875     0.200
    12.361   173.477     0.200
    12.512   175.477     0.200
    12.548   175.641     0.200
    12.556   175.992     0.200
    12.524   176.086     0.200
    12.574   174.766     0.200
    12.621   177.430     0.200
    12.631   177.664     0.200
    12.655   176.984     0.200
    12.655   177.812     0.200
    12.768   179.289     0.200
    12.768   179.086     0.200
    12.788   178.148     0.200
    12.628   178.102     0.200
    12.836   180.914     0.200
    12.836   179.672     0.200
    12.882   180.273     0.200
    12.882   180.812     0.200
    12.908   179.305     0.200
    12.908   180.617     0.200
    13.005   182.195     0.200
    13.142   184.922     0.200
    13.158   185.953     0.200
    13.162   184.789     0.200
    13.210   185.734     0.200
    13.209   185.250     0.200
    13.209   184.859     0.200
    13.353   187.438     0.200
    13.531   189.555     0.200
    13.514   190.453     0.200
    13.571   191.102     0.200
    13.571   190.156     0.200
    13.625   190.031     0.200
    13.642   188.898     0.200
    13.648   190.750     0.200
    13.640   190.500     0.200
    13.725   191.383     0.200
    13.728   191.172     0.200
    13.728   191.586     0.200
    13.761   192.219     0.200
    13.847   194.023     0.200
    13.847   194.156     0.200
    13.883   194.125     0.200
    13.906   193.438     0.200
    13.938   195.766     0.200
    13.956   194.664     0.200
    13.956   194.859     0.200
    14.012   194.602     0.200
    14.012   194.969     0.200
    14.057   196.641     0.200
    14.112   198.109     0.200
    14.135   197.281     0.200
    14.215   197.312     0.200
    14.215   197.672     0.200
    14.222   199.648     0.200
    14.326   199.523     0.200
    14.326   200.742     0.200
    14.324   200.609     0.200
    14.443   202.539     0.200
    14.516   201.969     0.200
    14.489   204.656     0.200
    14.505   203.258     0.200
    14.575   202.500     0.200
    14.588   202.781     0.200
    14.611   203.469     0.200
    14.617   201.633     0.200
    14.644   203.836     0.200
    14.644   204.945     0.200
    14.720   204.844     0.200
    14.720   206.875     0.200
    14.745   206.164     0.200
    14.777   207.297     0.200
    14.932   207.922     0.200
    14.929   209.688     0.200
    14.945   205.977     0.200
    15.097   210.195     0.200
    15.158   211.656     0.200
    15.178   211.172     0.200
    15.197   211.219     0.200
    15.226   211.422     0.200
    15.348   213.320     0.200
    15.323   212.773     0.200
    15.426   213.797     0.200
    15.507   214.641     0.200
    15.565   215.242     0.200
    15.597   216.641     0.200
    15.599   216.047     0.200
    15.599   217.273     0.200
    15.681   217.812     0.200
    15.704   218.930     0.200
    15.718   218.297     0.200
    15.757   217.922     0.200
    15.774   218.547     0.200
    15.795   219.266     0.200
    15.825   218.852     0.200
    15.852   219.508     0.200
    15.900   221.289     0.200
    15.934   220.695     0.200
    16.091   222.156     0.200
    16.200   222.523     0.200
    16.200   224.523     0.200
    16.304   225.555     0.200
    16.448   227.070     0.200
    16.448   227.547     0.200
    16.470   227.367     0.200
    16.541   228.445     0.200
    16.531   229.070     0.200
    16.707   230.219     0.200
    16.742   230.797     0.200
    16.875   232.867     0.200
    16.989   232.836     0.200
    17.017   233.906     0.200
    17.017   233.273     0.200
    17.065   232.656     0.200
    17.065   234.445     0.200
    17.208   236.211     0.200
    17.322   237.414     0.200
    17.769   242.477     0.200
     1.304    24.195     0.200
     1.999    32.703     0.200
     1.877    33.547     0.200
     2.908    43.492     0.200
     3.332    50.203     0.200
     3.952    58.867     0.200
     3.952    59.188     0.200
     3.766    59.898     0.200
     4.468    66.703     0.200
     4.533    67.523     0.200
     4.618    68.836     0.200
     4.605    68.727     0.200
     4.706    68.078     0.200
     4.706    68.289     0.200
     4.712    69.617     0.200
     4.983    73.594     0.200
     5.015    74.164     0.200
     5.150    76.289     0.200
     5.329    77.117     0.200
     5.329    76.805     0.200
     5.409    80.336     0.200
     5.467    80.727     0.200
     5.596    82.117     0.200
     5.653    83.477     0.200
     5.937    85.609     0.200
     5.953    87.477     0.200
     6.080    89.578     0.200
     6.173    90.180     0.200
     6.250    90.758     0.200
     6.340    91.203     0.200
     6.459    94.727     0.200
     6.487    94.867     0.200
     6.626    97.023     0.200
     6.958   100.758     0.200
     6.953   100.836     0.200
     6.898    99.945     0.200
     6.977   100.992     0.200
     6.977   102.383     0.200
     6.988   101.438     0.200
     7.124   103.383     0.200
     7.153   102.953     0.200
     7.249   103.883     0.200
     7.872   112.477     0.200
     8.115   117.164     0.200
     8.162   118.078     0.200
     8.207   118.414     0.200
     8.366   120.695     0.200
     8.522   121.727     0.200
     8.576   123.547     0.200
     8.644   123.289     0.200
     8.644   123.789     0.200
     8.701   124.125     0.200
     8.725   124.734     0.200
     9.082   129.758     0.200
     9.248   132.523     0.200
     9.337   132.703     0.200
     9.343   134.039     0.200
     9.330   132.703     0.200
     9.389   132.969     0.200
     9.421   133.508     0.200
     9.563   134.789     0.200
     9.593   134.695     0.200
     9.719   138.914     0.200
     9.788   138.789     0.200
     9.789   140.086     0.200
     9.931   139.953     0.200
    10.096   143.859     0.200
    10.169   145.844     0.200
    10.243   144.445     0.200
    10.240   144.359     0.200
    10.339   147.047     0.200
    10.383   147.984     0.200
    10.524   150.430     0.200
    10.603   150.023     0.200
    10.625   151.297     0.200
    10.639   151.266     0.200
    10.828   154.156     0.200
    10.905   153.914     0.200
    10.892   155.234     0.200
    11.014   156.219     0.200
    11.059   157.289     0.200
    11.100   157.594     0.200
    11.149   157.945     0.200
    11.358   161.523     0.200
    11.370   161.523     0.200
    11.368   162.094     0.200
    11.490   162.383     0.200
    11.619   163.828     0.200
    11.689   165.828     0.200
    11.694   165.477     0.200
    11.863   167.523     0.200
    11.902   168.969     0.200
    11.904   168.945     0.200
    11.994   170.742     0.200
    12.124   171.680     0.200
    12.196   171.359     0.200
    12.196   168.133     0.200
    12.317   173.195     0.200
    12.337   173.898     0.200
    12.343   174.266     0.200
    12.401   174.055     0.200
    12.501   174.344     0.200
    12.687   180.703     0.200
    12.805   180.117     0.200
    12.879   181.938     0.200
    12.946   182.812     0.200
    12.991   184.156     0.200
    13.079   184.117     0.200
    13.119   185.359     0.200
    13.141   184.969     0.200
    13.183   186.094     0.200
    13.617   192.516     0.200
    13.717   191.258     0.200
    13.763   193.609     0.200
    13.960   196.180     0.200
    13.990   199.195     0.200
    14.118   200.812     0.200
    14.176   199.258     0.200
    14.153   200.875     0.200
    14.192   199.484     0.200
    14.204   200.344     0.200
    14.232   200.438     0.200
    14.783   206.555     0.200
    14.758   208.047     0.200
    14.806   206.617     0.200
    14.871   207.836     0.200
    14.941   208.305     0.200
    15.160   210.797     0.200
    15.301   214.227     0.200
    15.584   217.195     0.200
    15.906   221.547     0.200
    16.080   223.273     0.200
    16.099   223.656     0.200
    16.222   225.453     0.200
    16.564   229.258     0.200
    17.297   238.906     0.200
     1.434    24.350     0.200
     1.453    25.210     0.200
     1.544    27.140     0.200
     1.578    27.460     0.200
     1.911    31.979     0.200
     2.141    34.260     0.200
     2.610    42.300     0.200
     2.610    43.270     0.200
     2.610    42.197     0.200
     2.815    44.850     0.200
     2.817    45.359     0.200
     2.859    45.600     0.200
     2.977    47.470     0.200
     3.189    48.370     0.200
     3.324    50.290     0.200
     3.356    51.010     0.200
     3.379    50.960     0.200
     3.398    51.790     0.200
     3.381    53.290     0.200
     3.496    53.309     0.200
     3.430    53.540     0.200
     3.592    53.489     0.200
     3.464    54.050     0.200
     3.619    54.700     0.200
     3.773    56.720     0.200
     3.808    57.100     0.200
     3.878    58.350     0.200
     3.862    58.340     0.200
     4.046    60.260     0.200
     4.046    60.395     0.200
     4.185    61.640     0.200
     4.185    61.537     0.200
     4.185    61.870     0.200
     4.185    61.289     0.200
     4.185    62.080     0.200
     4.111    63.310     0.200
     4.152    63.140     0.200
     4.152    63.870     0.200
     4.184    64.210     0.200
     4.331    64.229     0.200
     4.331    64.370     0.200
     4.322    64.300     0.200
     4.241    64.770     0.200
     4.247    64.930     0.200
     4.281    65.290     0.200
     4.284    65.580     0.200
     4.448    65.800     0.200
     4.448    65.905     0.200
     4.568    68.600     0.200
     4.568    68.411     0.200
     4.624    68.960     0.200
     4.722    69.896     0.200
     4.723    69.890     0.200
     4.742    70.140     0.200
     4.742    70.302     0.200
     4.664    70.270     0.200
     4.857    71.170     0.200
     4.787    72.149     0.200
     4.899    72.729     0.200
     4.899    72.498     0.200
     4.885    73.380     0.200
     4.916    73.870     0.200
     5.046    73.899     0.200
     5.130    75.630     0.200
     5.130    75.762     0.200
     5.191    76.560     0.200
     5.191    76.757     0.200
     5.369    78.739     0.200
     5.369    78.598     0.200
     5.349    79.630     0.200
     5.349    79.848     0.200
     5.417    79.479     0.200
     5.399    79.710     0.200
     5.399    79.423     0.200
     5.447    80.260     0.200
     5.482    80.569     0.200
     5.657    83.489     0.200
     5.657    83.746     0.200
     5.610    84.359     0.200
     5.762    84.140     0.200
     5.763    84.550     0.200
     5.763    84.680     0.200
     5.814    84.640     0.200
     5.814    84.870     0.200
     5.876    86.239     0.200
     5.887    85.950     0.200
     5.887    85.819     0.200
     5.916    86.359     0.200
     5.944    87.350     0.200
     6.005    88.410     0.200
     6.052    87.270     0.200
     5.966    88.340     0.200
     6.098    88.120     0.200
     6.109    89.470     0.200
     6.073    88.660     0.200
     6.073    88.515     0.200
     6.151    89.149     0.200
     6.151    90.250     0.200
     6.141    89.080     0.200
     6.128    89.779     0.200
     6.236    90.420     0.200
     6.315    92.770     0.200
     6.315    93.628     0.200
     6.422    94.819     0.200
     6.422    94.670     0.200
     6.574    95.210     0.200
     6.656    97.270     0.200
     6.656    98.013     0.200
     6.670    97.693     0.200
     6.672    97.710     0.200
     6.675    98.040     0.200
     6.676    97.790     0.200
     6.698    98.189     0.200
     6.740    99.250     0.200
     6.740    97.830     0.200
     6.759    97.540     0.200
     6.759    97.434     0.200
     6.776    98.430     0.200
     6.776    98.645     0.200
     6.795    97.760     0.200
     6.829    97.210     0.200
     6.829    99.225     0.200
     6.844    99.520     0.200
     6.961    99.660     0.200
     6.961   102.105     0.200
     6.955   100.050     0.200
     6.955   100.484     0.200
     6.867   102.689     0.200
     7.020   102.479     0.200
     7.016   102.529     0.200
     6.942   102.189     0.200
     7.157   103.520     0.200
     7.157   103.295     0.200
     7.313   105.580     0.200
     7.369   105.970     0.200
     7.369   106.707     0.200
     7.401   107.160     0.200
     7.401   106.912     0.200
     7.498   108.689     0.200
     7.498   109.218     0.200
     7.522   107.670     0.200
     7.522   107.564     0.200
     7.542   108.439     0.200
     7.542   108.273     0.200
     7.624   108.760     0.200
     7.624   109.062     0.200
     7.727   110.521     0.200
     7.757   111.399     0.200
     7.757   111.823     0.200
     7.840   112.529     0.200
     7.845   112.670     0.200
     7.830   111.899     0.200
     7.931   112.899     0.200
     7.931   112.670     0.200
     7.931   112.550     0.200
     7.986   114.489     0.200
     7.986   114.343     0.200
     8.043   114.340     0.200
     8.129   115.250     0.200
     8.121   117.899     0.200
     8.190   117.267     0.200
     8.187   116.859     0.200
     8.215   116.239     0.200
     8.230   115.960     0.200
     8.230   117.680     0.200
     8.355   118.300     0.200
     8.363   120.170     0.200
     8.409   117.939     0.200
     8.557   121.460     0.200
     8.557   121.045     0.200
     8.615   121.630     0.200
     8.615   121.970     0.200
     8.607   123.279     0.200
     8.602   122.609     0.200
     8.726   123.649     0.200
     8.905   125.939     0.200
     8.939   127.649     0.200
     8.938   126.060     0.200
     8.954   127.779     0.200
     8.977   127.859     0.200
     8.978   128.410     0.200
     9.011   127.350     0.200
     9.024   127.170     0.200
     9.024   126.843     0.200
     9.049   127.710     0.200
     9.049   128.197     0.200
     9.042   129.080     0.200
     9.074   128.430     0.200
     9.096   127.819     0.200
     9.096   127.938     0.200
     9.175   130.290     0.200
     9.213   131.529     0.200
     9.268   131.100     0.200
     9.247   131.989     0.200
     9.247   131.791     0.200
     9.311   131.090     0.200
     9.311   131.327     0.200
     9.321   132.160     0.200
     9.321   132.395     0.200
     9.382   132.189     0.200
     9.386   134.550     0.200
     9.386   134.354     0.200
     9.440   134.760     0.200
     9.440   134.531     0.200
     9.507   134.946     0.200
     9.570   134.609     0.200
     9.570   134.338     0.200
     9.583   135.550     0.200
     9.535   135.870     0.200
     9.535   135.715     0.200
     9.620   135.960     0.200
     9.620   136.277     0.200
     9.599   136.939     0.200
     9.599   137.268     0.200
     9.639   136.029     0.200
     9.639   136.738     0.200
     9.678   136.390     0.200
     9.768   138.680     0.200
     9.749   139.020     0.200
     9.855   139.040     0.200
     9.862   138.790     0.200
     9.874   139.562     0.200
     9.878   139.040     0.200
     9.883   139.529     0.200
     9.883   140.439     0.200
     9.927   140.050     0.200
     9.954   140.979     0.200
     9.983   141.160     0.200
     9.993   141.270     0.200
     9.967   142.290     0.200
     9.967   141.950     0.200
     9.974   142.210     0.200
    10.050   142.468     0.200
    10.127   142.893     0.200
    10.140   143.759     0.200
    10.185   144.627     0.200
    10.183   142.450     0.200
    10.183   143.544     0.200
    10.225   145.507     0.200
    10.295   145.587     0.200
    10.314   146.458     0.200
    10.341   147.607     0.200
    10.509   149.519     0.200
    10.546   149.494     0.200
    10.534   148.656     0.200
    10.593   149.957     0.200
    10.630   150.595     0.200
    10.695   149.150     0.200
    10.701   150.967     0.200
    10.746   151.641     0.200
    10.824   151.600     0.200
    10.824   152.069     0.200
    10.824   151.310     0.200
    10.824   151.729     0.200
    10.921   154.994     0.200
    10.897   155.216     0.200
    10.967   155.251     0.200
    10.940   155.575     0.200
    10.983   156.203     0.200
    10.993   152.819     0.200
    10.993   153.020     0.200
    11.051   157.418     0.200
    11.128   157.040     0.200
    11.126   155.325     0.200
    11.082   158.520     0.200
    11.082   158.870     0.200
    11.281   158.970     0.200
    11.281   159.272     0.200
    11.292   157.660     0.200
    11.292   157.909     0.200
    11.278   159.915     0.200
    11.301   157.103     0.200
    11.298   160.241     0.200
    11.457   161.888     0.200
    11.355   162.370     0.200
    11.515   162.045     0.200
    11.571   163.072     0.200
    11.615   162.469     0.200
    11.605   164.527     0.200
    11.606   164.469     0.200
    11.780   163.463     0.200
    11.831   166.675     0.200
    11.895   168.861     0.200
    11.938   166.540     0.200
    11.938   166.105     0.200
    11.939   169.522     0.200
    11.957   170.014     0.200
    11.979   167.718     0.200
    11.963   169.837     0.200
    12.099   170.411     0.200
    12.103   171.962     0.200
    12.107   170.940     0.200
    12.399   174.802     0.200
    12.434   174.336     0.200
    12.459   174.258     0.200
    12.478   177.368     0.200
    12.577   177.346     0.200
    12.588   177.095     0.200
    12.717   177.389     0.200
    12.752   176.937     0.200
    12.790   179.717     0.200
    12.781   181.432     0.200
    12.850   179.830     0.200
    12.975   181.069     0.200
    12.975   181.660     0.200
    12.958   182.919     0.200
    13.007   182.881     0.200
    13.026   183.770     0.200
    13.061   184.874     0.200
    13.057   185.394     0.200
    13.070   185.337     0.200
    13.136   184.120     0.200
    13.107   186.215     0.200
    13.134   183.745     0.200
    13.142   184.273     0.200
    13.227   185.270     0.200
    13.227   185.016     0.200
    13.217   186.225     0.200
    13.253   187.102     0.200
    13.288   185.653     0.200
    13.354   186.930     0.200
    13.494   187.896     0.200
    13.574   188.523     0.200
    13.582   189.743     0.200
    13.576   190.054     0.200
    13.586   187.969     0.200
    13.566   189.569     0.200
    13.566   189.134     0.200
    13.612   191.108     0.200
    13.615   190.987     0.200
    13.649   192.568     0.200
    13.695   192.503     0.200
    13.703   193.170     0.200
    13.752   193.680     0.200
    13.796   194.994     0.200
    13.880   195.552     0.200
    13.952   195.896     0.200
    13.993   196.489     0.200
    14.034   194.887     0.200
    14.120   198.478     0.200
    14.128   198.800     0.200
    14.222   199.312     0.200
    14.386   201.664     0.200
    14.377   202.106     0.200
    14.542   201.380     0.200
    14.542   202.776     0.200
    14.556   204.270     0.200
    14.636   204.987     0.200
    14.651   206.061     0.200
    14.653   204.770     0.200
    14.653   204.940     0.200
    14.686   205.069     0.200
    14.769   206.073     0.200
    14.784   207.469     0.200
    14.823   208.363     0.200
    14.925   209.689     0.200
    14.917   208.902     0.200
    14.916   209.109     0.200
    15.017   209.043     0.200
    15.186   210.960     0.200
    15.186   211.645     0.200
    15.437   216.249     0.200
    15.506   216.774     0.200
    15.524   217.767     0.200
    15.700   217.995     0.200
    15.692   220.457     0.200
    15.712   218.170     0.200
    15.810   220.153     0.200
    15.827   220.725     0.200
    15.997   223.624     0.200
    15.997   222.795     0.200
    15.998   223.186     0.200
    15.948   221.813     0.200
    16.093   223.037     0.200
    16.210   224.252     0.200
    16.289   226.180     0.200
    16.306   225.964     0.200
    16.534   229.804     0.200
    16.632   231.921     0.200
    16.759   232.027     0.200
    16.841   230.600     0.200
    17.312   238.327     0.200
    17.312   237.545     0.200
    17.312   237.739     0.200
    18.465   254.210     0.200
    19.007   261.226     0.200
    19.428   264.640     0.200
     1.353    24.355     0.200
     1.356    24.574     0.200
     1.370    24.703     0.200
     1.485    27.133     0.200
     1.496    26.363     0.200
     1.528    26.703     0.200
     1.634    27.953     0.200
     1.662    28.555     0.200
     1.854    29.434     0.200
     2.094    35.332     0.200
     2.094    35.543     0.200
     2.258    37.984     0.200
     2.301    39.094     0.200
     2.508    40.133     0.200
     2.884    46.695     0.200
     3.198    49.824     0.200
     3.470    55.113     0.200
     3.997    61.555     0.200
     3.997    61.445     0.200
     4.245    63.422     0.200
     4.258    64.812     0.200
     4.306    64.535     0.200
     4.522    67.613     0.200
     4.554    68.395     0.200
     4.697    70.293     0.200
     5.061    74.844     0.200
     5.127    75.004     0.200
     5.127    74.062     0.200
     5.361    78.785     0.200
     5.398    79.812     0.200
     5.482    79.965     0.200
     5.551    81.242     0.200
     5.718    84.664     0.200
     5.801    84.703     0.200
     5.883    86.633     0.200
     6.076    89.715     0.200
     6.095    89.465     0.200
     6.097    89.363     0.200
     6.240    91.172     0.200
     6.317    93.832     0.200
     6.418    94.984     0.200
     6.423    94.523     0.200
     6.776    96.844     0.200
     6.822    99.766     0.200
     6.863    99.883     0.200
     6.863   100.742     0.200
     6.903   100.223     0.200
     6.895   100.863     0.200
     7.099   102.504     0.200
     7.118   102.344     0.200
     7.194   104.152     0.200
     7.734   111.812     0.200
     7.782   113.145     0.200
     7.829   113.332     0.200
     8.003   115.613     0.200
     8.075   117.594     0.200
     8.144   116.855     0.200
     8.364   120.555     0.200
     8.366   119.375     0.200
     8.556   124.023     0.200
     8.551   123.312     0.200
     8.551   123.145     0.200
     8.686   125.105     0.200
     9.000   128.992     0.200
     9.171   129.234     0.200
     9.195   130.844     0.200
     9.246   131.613     0.200
     9.234   133.395     0.200
     9.292   132.883     0.200
     9.402   131.684     0.200
     9.592   136.344     0.200
     9.628   137.574     0.200
     9.663   137.195     0.200
    10.059   142.902     0.200
    10.101   144.203     0.200
    10.348   146.285     0.200
    10.345   148.094     0.200
    10.439   148.082     0.200
    10.469   150.543     0.200
    10.578   149.965     0.200
    10.867   154.945     0.200
    10.948   154.402     0.200
    11.099   156.184     0.200
    11.415   160.715     0.200
    11.361   162.492     0.200
    11.578   162.402     0.200
    11.587   164.332     0.200
    11.751   162.832     0.200
    11.790   166.672     0.200
    11.769   167.492     0.200
    12.051   169.312     0.200
    12.051   166.844     0.200
    12.159   172.742     0.200
    12.281   173.465     0.200
    12.335   172.723     0.200
    12.355   172.742     0.200
    12.549   176.492     0.200
    12.611   178.195     0.200
    12.735   180.863     0.200
    13.511   188.074     0.200
    15.815   221.902     0.200
    16.741   232.484     0.200
    16.747   234.523     0.200
    17.348   238.766     0.200
    17.805   243.684     0.200
     1.307    22.648     0.200
     1.323    23.219     0.200
     1.522    26.340     0.200
     1.515    26.129     0.200
     1.770    28.908     0.200
     1.770    29.059     0.200
     1.993    33.770     0.200
     1.993    34.238     0.200
     2.166    36.090     0.200
     2.401    38.680     0.200
     2.412    39.369     0.200
     2.333    39.158     0.200
     2.703    41.049     0.200
     2.801    45.430     0.200
     3.106    48.209     0.200
     3.444    54.639     0.200
     3.737    55.629     0.200
     3.737    57.238     0.200
     3.934    60.539     0.200
     4.167    62.438     0.200
     4.169    62.439     0.200
     4.027    61.969     0.200
     4.237    63.719     0.200
     4.405    66.158     0.200
     4.416    65.578     0.200
     4.485    65.629     0.200
     4.485    65.340     0.200
     4.546    67.770     0.200
     4.836    72.000     0.200
     4.940    73.000     0.200
     5.104    73.340     0.200
     5.104    73.633     0.200
     5.246    77.359     0.200
     5.304    78.059     0.200
     5.422    79.760     0.200
     5.410    79.648     0.200
     5.710    84.219     0.200
     5.710    83.885     0.200
     5.753    84.420     0.200
     5.960    87.020     0.200
     5.950    86.520     0.200
     5.939    86.939     0.200
     6.109    90.229     0.200
     6.088    88.578     0.200
     6.088    88.750     0.200
     6.231    92.340     0.200
     6.290    91.760     0.200
     6.313    92.619     0.200
     6.544    95.488     0.200
     6.758    98.520     0.200
     6.758    98.840     0.200
     6.741    97.510     0.200
     6.781    98.459     0.200
     6.962   100.879     0.200
     7.084   102.328     0.200
     7.088   103.379     0.200
     7.435   106.449     0.200
     7.586   109.770     0.200
     7.663   110.148     0.200
     7.727   112.180     0.200
     7.897   113.959     0.200
     8.014   114.908     0.200
     8.211   117.908     0.200
     8.292   118.818     0.200
     8.433   120.309     0.200
     8.433   120.939     0.200
     8.433   120.584     0.200
     8.473   122.898     0.200
     8.543   121.719     0.200
     9.162   129.578     0.200
     9.149   131.189     0.200
     9.566   137.510     0.200
     9.700   137.000     0.200
     9.856   139.639     0.200
    10.013   142.750     0.200
    10.013   141.549     0.200
    10.197   145.369     0.200
    10.189   145.219     0.200
    10.293   146.420     0.200
    10.683   151.119     0.200
    10.785   151.750     0.200
    10.831   152.789     0.200
    10.873   153.299     0.200
    11.167   158.350     0.200
    11.268   161.299     0.200
    11.563   163.000     0.200
    11.652   164.939     0.200
    11.893   167.449     0.200
    11.968   165.590     0.200
    12.119   170.709     0.200
    12.270   171.779     0.200
    13.399   188.859     0.200
    13.730   192.408     0.200
    13.779   192.959     0.200
    13.945   194.568     0.200
    13.942   196.939     0.200
    13.986   197.238     0.200
    14.145   198.920     0.200
    14.390   201.279     0.200
    14.443   200.639     0.200
    14.514   204.238     0.200
    14.646   206.559     0.200
    14.977   209.689     0.200
    17.738   244.029     0.200
     1.479    25.672     0.200
     1.468    25.812     0.200
     1.465    25.543     0.200
     1.482    25.871     0.200
     1.491    26.152     0.200
     1.724    29.629     0.200
     1.597    28.051     0.200
     1.881    30.250     0.200
     1.783    30.402     0.200
     2.191    35.742     0.200
     2.191    35.512     0.200
     2.523    39.652     0.200
     2.352    37.891     0.200
     2.642    39.832     0.200
     2.398    39.250     0.200
     2.519    40.910     0.200
     2.957    46.961     0.200
     2.974    47.223     0.200
     3.230    49.062     0.200
     3.230    49.301     0.200
     3.703    54.543     0.200
     3.703    54.441     0.200
     3.552    55.270     0.200
     3.595    55.941     0.200
     4.261    63.441     0.200
     4.263    63.441     0.200
     4.319    64.430     0.200
     4.075    61.742     0.200
     4.075    61.453     0.200
     4.379    65.090     0.200
     4.445    65.973     0.200
     4.472    65.270     0.200
     4.472    64.801     0.200
     4.531    67.203     0.200
     4.337    65.383     0.200
     4.624    68.652     0.200
     4.780    71.043     0.200
     5.106    73.512     0.200
     5.114    74.832     0.200
     5.413    79.613     0.200
     5.413    78.961     0.200
     5.406    78.551     0.200
     5.487    79.691     0.200
     5.487    79.840     0.200
     5.482    80.270     0.200
     5.623    82.902     0.200
     5.708    82.094     0.200
     5.710    82.102     0.200
     5.829    84.582     0.200
     5.945    86.410     0.200
     6.125    89.191     0.200
     6.188    89.242     0.200
     6.188    89.828     0.200
     6.170    88.781     0.200
     6.188    90.160     0.200
     6.188    90.418     0.200
     6.341    91.680     0.200
     6.323    92.281     0.200
     6.481    93.312     0.200
     6.486    94.051     0.200
     6.486    94.160     0.200
     6.716    96.902     0.200
     6.772    96.633     0.200
     6.852    99.461     0.200
     6.903    98.793     0.200
     6.956   100.660     0.200
     6.985   100.820     0.200
     6.980   100.961     0.200
     7.066    99.840     0.200
     7.105   100.453     0.200
     7.166   103.441     0.200
     7.197   102.680     0.200
     7.831   111.520     0.200
     7.831   110.152     0.200
     7.833   112.520     0.200
     7.866   113.453     0.200
     8.044   115.812     0.200
     8.104   117.430     0.200
     8.206   117.492     0.200
     8.377   118.621     0.200
     8.377   118.863     0.200
     8.411   119.852     0.200
     8.411   118.941     0.200
     8.583   121.730     0.200
     8.577   122.020     0.200
     8.600   123.020     0.200
     9.077   128.883     0.200
     9.077   127.848     0.200
     9.180   130.160     0.200
     9.391   131.871     0.200
     9.399   133.332     0.200
     9.759   137.922     0.200
     9.848   139.410     0.200
     9.949   140.730     0.200
    10.052   141.551     0.200
    10.105   142.500     0.200
    10.126   143.191     0.200
    10.201   143.832     0.200
    10.348   146.520     0.200
    10.377   145.953     0.200
    10.406   146.633     0.200
    10.458   147.191     0.200
    10.528   148.891     0.200
    10.630   149.711     0.200
    10.672   150.953     0.200
    10.780   152.062     0.200
    10.792   152.133     0.200
    10.854   152.703     0.200
    10.889   153.410     0.200
    11.075   155.980     0.200
    11.148   157.133     0.200
    11.391   160.832     0.200
    11.519   160.031     0.200
    11.550   161.781     0.200
    11.575   162.891     0.200
    11.631   164.570     0.200
    11.677   163.633     0.200
    11.706   164.730     0.200
    11.757   164.953     0.200
    11.770   162.863     0.200
    11.789   164.750     0.200
    11.817   166.492     0.200
    11.886   165.473     0.200
    11.904   167.152     0.200
    11.945   168.090     0.200
    12.090   169.430     0.200
    12.342   172.453     0.200
    12.370   171.801     0.200
    12.526   175.852     0.200
    12.544   175.461     0.200
    12.836   179.461     0.200
    12.927   181.840     0.200
    13.016   182.781     0.200
    13.017   182.070     0.200
    13.439   187.852     0.200
    13.525   188.781     0.200
    13.552   189.852     0.200
    13.798   191.723     0.200
    13.891   192.453     0.200
    13.918   194.613     0.200
    13.994   196.293     0.200
    14.095   198.930     0.200
    14.107   199.762     0.200
    14.220   200.332     0.200
    14.367   200.941     0.200
    14.442   202.922     0.200
    14.560   204.832     0.200
    14.624   203.402     0.200
    14.635   204.562     0.200
    14.928   209.043     0.200
    15.153   210.961     0.200
    15.398   215.750     0.200
    15.472   215.910     0.200
    15.611   216.410     0.200
    15.692   218.543     0.200
    15.713   219.680     0.200
    16.093   223.602     0.200
    16.741   231.352     0.200
    16.742   231.062     0.200
    16.742   233.141     0.200
    16.757   230.762     0.200
    17.354   237.711     0.200
    17.813   242.852     0.200
     1.488    27.812     0.200
     1.557    29.791     0.200
     1.692    31.331     0.200
     1.858    32.682     0.200
     1.753    32.892     0.200
     1.920    34.081     0.200
     1.855    34.132     0.200
     2.013    35.331     0.200
     2.019    35.111     0.200
     2.045    36.072     0.200
     2.046    36.071     0.200
     2.080    36.371     0.200
     2.176    39.142     0.200
     2.375    40.241     0.200
     2.278    40.012     0.200
     2.845    47.821     0.200
     2.990    48.251     0.200
     2.917    49.432     0.200
     3.011    49.951     0.200
     3.015    50.111     0.200
     3.039    50.312     0.200
     3.339    52.251     0.200
     3.362    54.291     0.200
     3.442    55.791     0.200
     3.512    56.342     0.200
     3.624    57.972     0.200
     4.382    66.791     0.200
     4.363    68.882     0.200
     4.772    72.791     0.200
     4.774    72.791     0.200
     4.808    72.972     0.200
     4.837    73.711     0.200
     4.852    73.922     0.200
     4.885    74.312     0.200
     4.885    74.816     0.200
     4.919    74.972     0.200
     4.956    77.592     0.200
     5.132    76.291     0.200
     5.363    80.842     0.200
     5.362    80.845     0.200
     5.399    81.312     0.200
     5.436    81.651     0.200
     5.570    83.972     0.200
     5.751    84.835     0.200
     5.778    86.581     0.200
     5.813    86.932     0.200
     5.891    88.262     0.200
     5.891    88.491     0.200
     6.046    90.132     0.200
     5.986    91.791     0.200
     6.208    93.342     0.200
     6.191    92.172     0.200
     6.286    94.382     0.200
     6.316    93.643     0.200
     6.317    93.642     0.200
     6.327    94.241     0.200
     6.410    95.211     0.200
     6.410    95.416     0.200
     6.468    96.041     0.200
     6.722    99.541     0.200
     6.732    99.711     0.200
     6.732    99.967     0.200
     6.854   100.882     0.200
     7.003   103.352     0.200
     7.042   103.731     0.200
     7.267   106.552     0.200
     7.296   107.771     0.200
     7.320   107.661     0.200
     7.361   108.481     0.200
     7.382   108.441     0.200
     7.610   111.481     0.200
     7.828   115.041     0.200
     7.887   114.632     0.200
     8.156   118.531     0.200
     8.275   120.661     0.200
     8.430   122.432     0.200
     8.504   122.951     0.200
     8.551   124.211     0.200
     8.898   128.422     0.200
     8.926   129.321     0.200
     9.211   132.791     0.200
     9.330   133.821     0.200
     9.330   134.680     0.200
     9.804   140.541     0.200
     9.951   143.901     0.200
     9.832   144.092     0.200
    10.004   142.441     0.200
    10.001   144.821     0.200
    10.396   149.731     0.200
    11.236   160.901     0.200
    12.041   171.611     0.200
    12.555   174.892     0.200
    12.766   182.182     0.200
     1.948    33.428     0.200
     2.175    38.268     0.200
     2.401    39.316     0.200
     2.278    39.607     0.200
     2.289    39.887     0.200
     2.857    46.098     0.200
     2.913    48.576     0.200
     2.983    49.207     0.200
     2.989    49.227     0.200
     3.007    49.707     0.200
     3.010    49.646     0.200
     3.035    50.086     0.200
     3.059    50.416     0.200
     3.355    54.547     0.200
     3.355    53.678     0.200
     3.355    53.875     0.200
     3.437    55.326     0.200
     3.506    55.938     0.200
     3.581    57.326     0.200
     3.618    57.666     0.200
     4.144    63.967     0.200
     4.146    64.076     0.200
     4.197    64.438     0.200
     4.220    64.457     0.200
     4.260    66.018     0.200
     4.400    66.447     0.200
     4.400    66.326     0.200
     4.273    67.307     0.200
     4.384    68.518     0.200
     4.447    69.307     0.200
     4.798    72.311     0.200
     4.799    72.527     0.200
     4.866    72.996     0.200
     4.866    73.223     0.200
     4.831    72.406     0.200
     4.831    72.516     0.200
     4.877    73.697     0.200
     4.913    73.816     0.200
     4.913    74.146     0.200
     4.918    74.045     0.200
     4.947    74.518     0.200
     4.944    74.566     0.200
     5.005    75.678     0.200
     5.019    75.047     0.200
     4.946    76.348     0.200
     4.946    75.928     0.200
     5.152    75.848     0.200
     5.152    76.357     0.200
     5.152    76.166     0.200
     5.389    80.518     0.200
     5.387    80.365     0.200
     5.426    81.637     0.200
     5.426    81.438     0.200
     5.431    81.057     0.200
     5.465    81.428     0.200
     5.465    81.180     0.200
     5.423    81.207     0.200
     5.423    81.414     0.200
     5.599    83.268     0.200
     5.599    83.447     0.200
     5.505    83.928     0.200
     5.806    86.486     0.200
     5.806    86.178     0.200
     5.771    84.273     0.200
     5.591    83.928     0.200
     5.842    86.896     0.200
     5.918    88.146     0.200
     6.071    89.428     0.200
     6.071    89.871     0.200
     5.998    90.447     0.200
     5.998    90.566     0.200
     5.998    90.074     0.200
     6.218    92.617     0.200
     6.237    92.797     0.200
     6.237    92.572     0.200
     6.313    93.018     0.200
     6.313    93.771     0.200
     6.355    93.178     0.200
     6.355    93.371     0.200
     6.338    92.855     0.200
     6.340    92.307     0.200
     6.438    94.098     0.200
     6.438    94.697     0.200
     6.477    95.967     0.200
     6.496    95.008     0.200
     6.496    95.723     0.200
     6.495    95.826     0.200
     6.693    98.826     0.200
     6.693    98.633     0.200
     6.761    99.152     0.200
     6.748    98.145     0.200
     6.843   100.717     0.200
     6.843   100.324     0.200
     6.881   100.625     0.200
     7.070   103.520     0.200
     7.095   104.727     0.200
     7.273   106.867     0.200
     7.273   105.996     0.200
     7.295   106.207     0.200
     7.295   106.646     0.200
     7.325   108.348     0.200
     7.325   107.928     0.200
     7.323   107.477     0.200
     7.323   107.332     0.200
     7.317   106.518     0.200
     7.317   106.121     0.200
     7.349   106.758     0.200
     7.411   107.746     0.200
     7.385   107.246     0.200
     7.483   110.008     0.200
     7.516   110.768     0.200
     7.520   110.627     0.200
     7.523   109.797     0.200
     7.638   111.246     0.200
     7.638   111.979     0.200
     7.719   112.646     0.200
     7.721   110.717     0.200
     7.721   110.834     0.200
     7.855   114.607     0.200
     7.916   114.627     0.200
     7.916   114.797     0.200
     7.967   115.236     0.200
     7.967   115.922     0.200
     8.184   118.697     0.200
     8.269   119.557     0.200
     8.269   121.297     0.200
     8.303   121.236     0.200
     8.300   119.938     0.200
     8.338   121.127     0.200
     8.397   121.428     0.200
     8.192   121.217     0.200
     8.419   120.857     0.200
     8.458   122.617     0.200
     8.458   122.250     0.200
     8.235   122.207     0.200
     8.451   120.537     0.200
     8.451   122.314     0.200
     8.489   122.207     0.200
     8.489   122.621     0.200
     8.274   121.947     0.200
     8.532   123.363     0.200
     8.578   125.178     0.200
     8.578   125.590     0.200
     8.585   124.197     0.200
     8.585   124.031     0.200
     8.616   124.617     0.200
     8.925   129.307     0.200
     8.924   127.857     0.200
     8.924   127.975     0.200
     8.955   128.914     0.200
     8.960   129.646     0.200
     8.960   129.221     0.200
     8.991   129.928     0.200
     9.088   131.535     0.200
     9.113   130.627     0.200
     9.113   130.238     0.200
     9.233   132.217     0.200
     9.233   131.662     0.200
     9.339   133.576     0.200
     9.381   134.922     0.200
     9.354   133.596     0.200
     9.423   134.877     0.200
     9.423   135.387     0.200
     9.427   135.547     0.200
     9.427   134.877     0.200
     9.559   137.146     0.200
     9.551   136.646     0.200
     9.551   136.367     0.200
     9.405   137.137     0.200
     9.676   139.162     0.200
     9.681   138.416     0.200
     9.681   138.924     0.200
     9.666   138.506     0.200
     9.478   138.098     0.200
     9.788   139.967     0.200
     9.788   139.389     0.200
     9.851   140.176     0.200
     9.976   141.535     0.200
     9.976   139.848     0.200
    10.029   143.225     0.200
     9.825   142.547     0.200
     9.825   141.268     0.200
     9.825   142.957     0.200
    10.026   141.727     0.200
    10.180   145.326     0.200
    10.180   144.939     0.200
    10.225   145.348     0.200
    10.225   145.537     0.200
    10.225   145.037     0.200
    10.336   147.848     0.200
    10.107   146.236     0.200
    10.350   147.596     0.200
    10.424   149.383     0.200
    10.489   150.555     0.200
    10.523   150.051     0.200
    10.613   151.537     0.200
    10.624   151.736     0.200
    10.624   151.863     0.200
    10.631   150.143     0.200
    10.610   150.906     0.200
    10.671   151.535     0.200
    10.712   151.115     0.200
    10.788   154.078     0.200
    10.902   155.498     0.200
    10.952   156.238     0.200
    10.923   154.635     0.200
    10.945   155.688     0.200
    10.945   155.238     0.200
    10.987   156.297     0.200
    11.097   158.217     0.200
    11.122   158.549     0.200
    11.181   159.221     0.200
    11.182   157.455     0.200
    11.207   159.320     0.200
    11.259   159.768     0.200
    11.419   161.926     0.200
    11.477   164.410     0.200
    11.455   162.047     0.200
    11.473   162.732     0.200
    11.507   163.367     0.200
    11.539   165.121     0.200
    11.559   164.609     0.200
    11.538   164.246     0.200
    11.627   166.688     0.200
    11.627   165.365     0.200
    11.749   165.682     0.200
    11.769   167.973     0.200
    11.761   167.236     0.200
    11.761   166.787     0.200
    11.795   165.811     0.200
    11.843   167.857     0.200
    11.843   168.189     0.200
    11.861   166.887     0.200
    11.970   169.883     0.200
    12.016   171.223     0.200
    12.127   172.957     0.200
    12.127   173.910     0.200
    12.205   172.908     0.200
    12.233   170.416     0.200
    12.250   171.127     0.200
    12.250   171.848     0.200
    12.230   173.537     0.200
    12.298   175.529     0.200
    12.289   172.268     0.200
    12.327   173.920     0.200
    12.341   174.416     0.200
    12.400   173.646     0.200
    12.400   173.801     0.200
    12.400   172.746     0.200
    12.400   176.508     0.200
    12.480   177.746     0.200
    12.545   176.984     0.200
    12.530   176.947     0.200
    12.581   175.227     0.200
    12.607   178.445     0.200
    12.647   181.947     0.200
    12.702   178.137     0.200
    12.713   181.121     0.200
    12.777   181.822     0.200
    12.748   180.109     0.200
    12.784   181.445     0.200
    12.788   181.070     0.200
    12.822   181.746     0.200
    12.822   181.572     0.200
    12.904   180.117     0.200
    12.910   181.090     0.200
    12.973   184.178     0.200
    13.066   184.867     0.200
    13.110   187.357     0.200
    13.138   184.129     0.200
    13.171   184.979     0.200
    13.157   184.627     0.200
    13.170   185.898     0.200
    13.259   188.312     0.200
    13.386   190.322     0.200
    13.390   189.566     0.200
    13.394   188.246     0.200
    13.429   190.938     0.200
    13.393   190.000     0.200
    13.460   190.371     0.200
    13.525   190.555     0.200
    13.601   191.180     0.200
    13.631   193.268     0.200
    13.631   193.615     0.200
    13.688   194.193     0.200
    13.695   194.537     0.200
    13.779   196.010     0.200
    13.830   196.109     0.200
    13.888   195.732     0.200
    13.976   195.521     0.200
    14.022   195.721     0.200
    14.066   195.068     0.200
    14.121   200.697     0.200
    14.123   200.836     0.200
    14.125   198.467     0.200
    14.209   201.484     0.200
    14.200   199.896     0.200
    14.162   200.145     0.200
    14.246   200.982     0.200
    14.343   202.643     0.200
    14.282   201.939     0.200
    14.347   201.307     0.200
    14.372   200.508     0.200
    14.372   201.367     0.200
    14.439   202.416     0.200
    14.497   204.576     0.200
    14.460   203.344     0.200
    14.543   204.859     0.200
    14.580   204.480     0.200
    14.599   204.391     0.200
    14.626   205.248     0.200
    14.619   206.348     0.200
    14.619   205.666     0.200
    14.619   204.863     0.200
    14.734   206.621     0.200
    14.702   206.986     0.200
    14.702   206.586     0.200
    14.744   206.275     0.200
    14.813   207.854     0.200
    14.804   210.348     0.200
    14.804   207.422     0.200
    14.948   209.844     0.200
    14.964   209.445     0.200
    15.059   210.072     0.200
    15.068   210.734     0.200
    15.070   209.598     0.200
    15.045   211.457     0.200
    15.115   212.627     0.200
    15.029   212.762     0.200
    15.122   211.180     0.200
    14.947   210.592     0.200
    15.091   210.779     0.200
    15.188   211.582     0.200
    15.191   211.172     0.200
    15.205   213.428     0.200
    15.205   212.980     0.200
    15.163   213.646     0.200
    15.163   214.098     0.200
    15.239   213.176     0.200
    15.267   214.246     0.200
    15.397   216.240     0.200
    15.552   216.592     0.200
    15.548   217.688     0.200
    15.583   217.852     0.200
    15.637   220.836     0.200
    15.637   217.822     0.200
    15.696   218.922     0.200
    15.746   220.057     0.200
    15.848   220.971     0.200
    15.906   222.387     0.200
    15.888   222.363     0.200
    15.883   222.336     0.200
    15.954   224.348     0.200
    15.954   224.787     0.200
    15.954   222.051     0.200
    16.171   224.018     0.200
    16.215   225.922     0.200
    16.174   224.035     0.200
    16.219   225.918     0.200
    16.309   226.002     0.200
    16.378   227.777     0.200
    16.386   228.131     0.200
    16.312   227.207     0.200
    16.287   227.420     0.200
    16.363   228.252     0.200
    16.419   228.217     0.200
    16.555   229.619     0.200
    16.609   230.178     0.200
    16.701   232.592     0.200
    16.803   233.299     0.200
    16.910   234.234     0.200
    16.825   233.439     0.200
    16.880   234.027     0.200
    17.011   235.908     0.200
    17.131   236.756     0.200
    17.192   237.654     0.200
    17.198   238.271     0.200
    17.314   239.422     0.200
    17.388   240.736     0.200
    17.497   241.064     0.200
    17.683   243.676     0.200
    17.632   243.791     0.200
    17.818   245.900     0.200
    17.924   246.182     0.200
    18.104   249.492     0.200
    18.160   250.225     0.200
    19.615   269.496     0.200
     1.498    28.293     0.200
     1.577    30.223     0.200
     1.713    32.352     0.200
     1.876    35.213     0.200
     2.005    35.793     0.200
     2.070    36.332     0.200
     2.198    39.723     0.200
     2.363    40.781     0.200
     2.299    40.771     0.200
     2.939    49.432     0.200
     3.015    50.473     0.200
     3.037    50.902     0.200
     3.061    51.432     0.200
     3.383    55.133     0.200
     3.464    56.672     0.200
     3.534    57.281     0.200
     3.609    58.553     0.200
     3.646    58.951     0.200
     4.840    74.822     0.200
     4.835    74.143     0.200
     4.907    76.281     0.200
     4.886    75.172     0.200
     5.115    77.133     0.200
     5.351    81.963     0.200
     5.431    82.121     0.200
     5.572    85.303     0.200
     5.734    85.627     0.200
     5.812    88.572     0.200
     6.033    90.633     0.200
     6.195    93.371     0.200
     6.276    93.342     0.200
     6.302    93.463     0.200
     6.327    95.002     0.200
     6.412    95.633     0.200
     6.462    96.352     0.200
     6.710   100.422     0.200
     6.729   100.412     0.200
     6.846   102.271     0.200
     7.058   104.582     0.200
     7.045   104.361     0.200
     7.262   107.691     0.200
     7.287   109.121     0.200
     7.347   107.682     0.200
     7.321   108.281     0.200
     7.603   111.842     0.200
     7.884   115.463     0.200
     7.940   116.822     0.200
     8.151   119.902     0.200
     8.303   123.732     0.200
     8.423   123.822     0.200
     8.458   123.672     0.200
     8.507   124.473     0.200
     8.886   128.521     0.200
     8.953   130.451     0.200
     8.926   130.213     0.200
     9.083   132.232     0.200
     9.316   135.092     0.200
     9.349   136.312     0.200
     9.530   138.633     0.200
     9.646   141.121     0.200
     9.789   141.232     0.200
     9.854   144.133     0.200
     9.996   144.912     0.200
    10.187   146.133     0.200
    10.312   147.723     0.200
    10.390   150.742     0.200
    10.633   152.582     0.200
    11.982   172.252     0.200
    12.544   174.908     0.200
    13.352   192.182     0.200
    14.162   200.691     0.200
    14.561   207.412     0.200
    14.588   207.781     0.200
    15.128   215.852     0.200
    15.154   213.543     0.200
    15.203   215.902     0.200
    15.232   215.621     0.200
    15.511   221.012     0.200
    15.601   222.682     0.200
    16.134   227.701     0.200
    16.182   227.793     0.200
    16.664   235.611     0.200
    16.766   236.762     0.200
     1.602    29.836     0.200
     1.602    29.367     0.200
     1.731    31.477     0.200
     1.795    33.055     0.200
     1.974    34.285     0.200
     1.892    34.316     0.200
     2.100    36.363     0.200
     2.101    36.367     0.200
     2.205    38.734     0.200
     2.418    40.086     0.200
     2.310    39.914     0.200
     2.866    47.836     0.200
     2.938    48.824     0.200
     2.988    49.445     0.200
     3.008    49.734     0.200
     3.023    50.016     0.200
     3.033    50.016     0.200
     3.061    50.145     0.200
     3.085    50.965     0.200
     3.350    52.047     0.200
     3.378    54.336     0.200
     4.160    63.934     0.200
     4.162    63.938     0.200
     4.236    65.484     0.200
     4.399    66.734     0.200
     4.399    65.785     0.200
     4.375    68.816     0.200
     4.404    68.586     0.200
     4.901    74.285     0.200
     4.901    74.387     0.200
     4.893    73.926     0.200
     4.953    74.777     0.200
     4.976    75.207     0.200
     4.960    74.406     0.200
     4.964    77.234     0.200
     5.154    77.035     0.200
     5.154    76.234     0.200
     5.405    80.906     0.200
     5.404    80.910     0.200
     5.450    82.105     0.200
     5.495    82.758     0.200
     5.495    82.496     0.200
     5.639    84.535     0.200
     5.776    84.855     0.200
     5.776    84.730     0.200
     5.834    86.926     0.200
     5.834    87.551     0.200
     5.879    87.914     0.200
     5.879    87.555     0.200
     6.085    89.926     0.200
     6.041    91.137     0.200
     6.041    90.914     0.200
     6.261    93.777     0.200
     6.261    92.750     0.200
     6.271    93.414     0.200
     6.349    94.508     0.200
     6.394    94.438     0.200
     6.479    95.387     0.200
     6.479    95.648     0.200
     6.526    96.965     0.200
     6.740    99.336     0.200
     6.796   100.066     0.200
     6.908   103.195     0.200
     7.046   104.074     0.200
     7.112   104.074     0.200
     7.327   107.637     0.200
     7.327   107.234     0.200
     7.347   108.465     0.200
     7.347   108.355     0.200
     7.396   107.535     0.200
     7.447   109.445     0.200
     7.447   109.004     0.200
     7.666   112.484     0.200
     8.007   117.074     0.200
     8.216   119.535     0.200
     8.486   124.086     0.200
     8.294   122.734     0.200
     8.991   129.867     0.200
     8.993   130.426     0.200
     9.150   131.977     0.200
     9.366   134.195     0.200
     9.414   136.047     0.200
     9.598   138.965     0.200
     9.710   141.016     0.200
     9.764   139.867     0.200
     9.834   140.777     0.200
     9.861   140.508     0.200
     9.846   143.336     0.200
    10.035   142.375     0.200
    10.128   147.855     0.200
    10.364   147.285     0.200
    10.454   150.836     0.200
    10.526   150.914     0.200
    10.616   151.227     0.200
    10.776   154.086     0.200
    10.958   155.477     0.200
    11.012   157.547     0.200
    11.137   158.727     0.200
    11.200   158.645     0.200
    11.269   160.277     0.200
    11.581   165.766     0.200
    12.209   174.516     0.200
    12.233   174.535     0.200
    12.363   176.016     0.200
    12.643   180.656     0.200
    12.745   183.098     0.200
    12.811   182.285     0.200
    12.821   182.734     0.200
    12.924   182.227     0.200
    12.927   181.367     0.200
    13.418   191.465     0.200
    13.488   189.055     0.200
    14.154   199.625     0.200
    14.207   200.777     0.200
    15.092   213.574     0.200
    15.263   215.355     0.200
    15.569   220.277     0.200
    19.593   270.496     0.200
     1.373    24.719     0.200
     1.370    24.566     0.200
     1.387    24.855     0.200
     1.396    25.367     0.200
     1.501    27.117     0.200
     1.688    29.758     0.200
     1.859    30.656     0.200
     1.859    31.168     0.200
     2.107    36.328     0.200
     2.107    35.688     0.200
     2.271    37.957     0.200
     2.315    39.309     0.200
     2.439    41.328     0.200
     2.438    41.266     0.200
     2.681    40.898     0.200
     2.790    45.918     0.200
     2.879    46.867     0.200
     3.579    55.199     0.200
     3.580    55.199     0.200
     3.653    55.836     0.200
     3.734    56.746     0.200
     3.651    57.727     0.200
     4.248    63.773     0.200
     4.249    63.777     0.200
     4.007    61.727     0.200
     4.007    61.578     0.200
     4.310    64.738     0.200
     4.372    65.668     0.200
     4.153    63.656     0.200
     4.156    64.086     0.200
     4.497    65.828     0.200
     4.497    66.355     0.200
     4.566    68.617     0.200
     4.711    70.328     0.200
     4.711    70.602     0.200
     4.827    71.746     0.200
     4.826    71.742     0.200
     4.941    73.559     0.200
     5.071    74.516     0.200
     5.126    74.117     0.200
     5.015    76.098     0.200
     5.370    79.105     0.200
     5.412    79.699     0.200
     5.485    81.008     0.200
     5.563    82.566     0.200
     5.563    82.203     0.200
     5.807    86.078     0.200
     5.612    84.527     0.200
     5.894    86.848     0.200
     6.085    89.879     0.200
     6.085    90.133     0.200
     6.108    89.508     0.200
     6.112    90.477     0.200
     6.112    90.027     0.200
     6.253    91.246     0.200
     6.426    94.508     0.200
     6.434    94.598     0.200
     6.406    94.926     0.200
     6.777    99.188     0.200
     6.828   100.797     0.200
     6.828    99.375     0.200
     6.912   100.398     0.200
     6.912   100.180     0.200
     6.909   100.117     0.200
     6.973   103.027     0.200
     7.111   102.848     0.200
     7.131   102.656     0.200
     7.202   104.699     0.200
     7.575   109.008     0.200
     7.747   112.508     0.200
     7.792   112.098     0.200
     7.792   112.969     0.200
     7.762   112.246     0.200
     7.836   113.387     0.200
     8.011   116.367     0.200
     8.081   117.309     0.200
     8.155   117.309     0.200
     8.155   117.609     0.200
     8.368   118.309     0.200
     8.368   120.625     0.200
     8.380   120.148     0.200
     8.380   120.480     0.200
     8.561   124.707     0.200
     8.698   124.996     0.200
     8.749   124.297     0.200
     8.749   124.633     0.200
     8.809   125.828     0.200
     8.809   125.648     0.200
     8.975   127.777     0.200
     9.010   129.418     0.200
     8.932   129.527     0.200
     9.195   130.379     0.200
     9.242   132.508     0.200
     9.402   131.887     0.200
     9.638   137.398     0.200
     9.638   137.711     0.200
     9.872   140.207     0.200
     9.968   140.289     0.200
    10.059   144.629     0.200
    10.350   148.105     0.200
    10.348   147.355     0.200
    10.549   151.777     0.200
    10.640   151.906     0.200
    10.479   150.527     0.200
    10.880   153.918     0.200
    11.066   157.277     0.200
    11.324   160.598     0.200
    11.595   165.367     0.200
    11.636   164.105     0.200
    11.714   165.367     0.200
    11.778   167.078     0.200
    11.866   165.266     0.200
    12.315   174.676     0.200
    12.317   174.539     0.200
    12.359   171.816     0.200
    12.532   175.129     0.200
    12.550   174.918     0.200
    12.622   178.496     0.200
    12.830   179.727     0.200
    12.999   184.379     0.200
    13.515   187.539     0.200
    13.567   189.266     0.200
    13.795   193.527     0.200
    13.998   195.336     0.200
    14.002   194.996     0.200
    14.132   198.016     0.200
    14.327   199.938     0.200
    14.506   203.047     0.200
    14.620   204.078     0.200
    14.682   205.477     0.200
    14.744   204.547     0.200
    15.605   215.688     0.200
    15.715   217.887     0.200
    15.824   222.016     0.200
    16.147   226.656     0.200
    16.787   234.227     0.200
    17.351   238.598     0.200
    17.808   243.578     0.200
     1.123    20.445     0.200
     1.259    22.688     0.200
     1.318    21.852     0.200
     1.277    22.922     0.200
     1.311    23.445     0.200
     1.335    23.969     0.200
     1.509    26.164     0.200
     1.798    29.367     0.200
     1.930    31.688     0.200
     1.950    31.367     0.200
     2.226    37.195     0.200
     2.351    36.734     0.200
     2.419    39.398     0.200
     2.437    40.203     0.200
     2.656    40.805     0.200
     2.970    45.852     0.200
     3.056    47.078     0.200
     3.117    47.383     0.200
     3.130    48.125     0.200
     3.172    48.648     0.200
     3.211    48.984     0.200
     3.352    50.273     0.200
     3.717    55.477     0.200
     3.787    57.039     0.200
     3.852    56.578     0.200
     3.973    59.773     0.200
     4.024    59.812     0.200
     4.079    59.367     0.200
     4.199    62.406     0.200
     4.301    64.195     0.200
     4.242    64.078     0.200
     4.336    64.805     0.200
     4.514    67.227     0.200
     4.686    67.703     0.200
     4.852    71.484     0.200
     4.903    72.445     0.200
     4.975    73.758     0.200
     5.025    73.883     0.200
     5.242    76.664     0.200
     5.260    77.688     0.200
     5.342    78.766     0.200
     5.527    80.453     0.200
     5.633    82.289     0.200
     5.659    83.602     0.200
     5.742    83.445     0.200
     5.780    85.102     0.200
     5.870    85.656     0.200
     5.884    86.484     0.200
     5.944    86.047     0.200
     5.881    85.594     0.200
     6.278    91.453     0.200
     6.286    90.508     0.200
     6.285    91.945     0.200
     6.314    91.656     0.200
     6.355    92.445     0.200
     6.405    91.836     0.200
     6.442    93.719     0.200
     6.576    94.172     0.200
     6.565    94.602     0.200
     6.622    94.727     0.200
     6.607    94.875     0.200
     6.645    96.297     0.200
     7.022   100.695     0.200
     7.221   104.258     0.200
     7.234   104.039     0.200
     7.282   105.289     0.200
     7.284   104.695     0.200
     7.352   105.977     0.200
     7.455   107.789     0.200
     7.532   109.797     0.200
     7.841   112.945     0.200
     7.897   113.172     0.200
     7.876   113.336     0.200
     8.161   116.758     0.200
     8.255   116.453     0.200
     8.261   117.695     0.200
     8.570   121.492     0.200
     8.731   122.922     0.200
     8.752   123.648     0.200
     8.767   124.875     0.200
     8.883   125.758     0.200
     9.080   130.039     0.200
     9.254   131.625     0.200
     9.445   134.836     0.200
     9.572   134.977     0.200
     9.806   139.305     0.200
     9.848   140.117     0.200
    10.098   142.102     0.200
    10.160   142.562     0.200
    10.397   144.875     0.200
    10.442   146.117     0.200
    10.511   149.156     0.200
     1.204    20.463     0.200
     1.381    23.822     0.200
     1.405    24.482     0.200
     1.451    25.113     0.200
     1.501    23.982     0.200
     1.501    24.652     0.200
     1.473    25.902     0.200
     1.474    25.902     0.200
     1.474    26.152     0.200
     1.661    28.203     0.200
     1.672    28.062     0.200
     1.700    28.783     0.200
     1.719    29.422     0.200
     1.803    30.473     0.200
     2.007    32.693     0.200
     1.935    31.043     0.200
     1.935    32.180     0.200
     2.180    32.252     0.200
     2.180    33.752     0.200
     2.104    34.113     0.200
     2.143    34.402     0.200
     2.713    43.354     0.200
     2.847    43.943     0.200
     2.847    43.750     0.200
     3.165    48.902     0.200
     3.167    48.412     0.200
     3.237    47.943     0.200
     3.256    49.672     0.200
     3.379    51.482     0.200
     3.745    56.053     0.200
     3.843    57.428     0.200
     3.844    57.434     0.200
     3.890    58.223     0.200
     3.948    58.693     0.200
     4.006    57.902     0.200
     4.006    58.514     0.200
     4.011    59.502     0.200
     4.035    59.793     0.200
     4.058    60.633     0.200
     4.097    61.672     0.200
     4.025    61.764     0.200
     4.124    61.842     0.200
     4.143    61.982     0.200
     4.236    62.943     0.200
     4.415    64.893     0.200
     4.409    65.152     0.200
     4.408    65.156     0.200
     4.365    64.803     0.200
     4.642    66.783     0.200
     4.642    67.047     0.200
     4.485    65.922     0.200
     4.585    67.604     0.200
     4.585    67.643     0.200
     4.585    67.928     0.200
     4.628    69.043     0.200
     4.788    69.934     0.200
     4.788    71.104     0.200
     5.006    72.463     0.200
     5.046    74.434     0.200
     5.051    73.934     0.200
     5.253    75.742     0.200
     5.290    78.223     0.200
     5.369    78.553     0.200
     5.369    79.027     0.200
     5.431    78.633     0.200
     5.646    82.764     0.200
     5.646    83.354     0.200
     5.754    82.953     0.200
     5.782    83.223     0.200
     5.933    86.703     0.200
     5.932    86.223     0.200
     5.932    86.752     0.200
     6.052    87.303     0.200
     6.087    88.883     0.200
     6.087    89.127     0.200
     6.045    87.842     0.200
     6.045    89.178     0.200
     6.126    88.322     0.200
     6.126    88.854     0.200
     6.195    89.543     0.200
     6.319    91.104     0.200
     6.556    93.104     0.200
     6.614    94.582     0.200
     6.596    95.822     0.200
     6.628    94.963     0.200
     6.795    98.242     0.200
     6.876    99.383     0.200
     6.889    98.453     0.200
     6.974    99.992     0.200
     6.974   100.604     0.200
     7.321   104.783     0.200
     7.321   105.604     0.200
     7.485   107.703     0.200
     7.496   106.152     0.200
     7.496   107.902     0.200
     7.584   108.912     0.200
     7.674   110.383     0.200
     7.705   111.473     0.200
     7.695   109.803     0.200
     7.947   112.902     0.200
     7.969   114.002     0.200
     7.904   112.533     0.200
     8.110   117.172     0.200
     8.292   117.043     0.200
     8.257   118.453     0.200
     8.266   118.002     0.200
     8.503   121.742     0.200
     8.578   121.672     0.200
     8.718   123.502     0.200
     8.739   124.703     0.200
     8.931   125.043     0.200
     9.114   128.783     0.200
     9.114   128.652     0.200
     9.109   129.223     0.200
     9.304   131.592     0.200
     9.339   132.002     0.200
     9.597   136.184     0.200
     9.680   136.363     0.200
    10.134   143.062     0.200
    11.657   165.354     0.200
    11.654   160.152     0.200
    12.348   173.822     0.200
    12.685   178.422     0.200
    13.356   185.553     0.200
    13.541   189.652     0.200
    13.632   193.453     0.200
    13.757   194.434     0.200
    14.126   196.992     0.200
    14.184   196.822     0.200
    15.672   216.773     0.200
    16.291   225.312     0.200
    17.943   244.232     0.200
    17.943   245.078     0.200
     1.837    31.523     0.200
     2.017    33.982     0.200
     2.018    34.043     0.200
     2.059    34.514     0.200
     2.364    37.344     0.200
     2.813    44.783     0.200
     2.800    46.424     0.200
     2.872    47.314     0.200
     2.943    48.283     0.200
     2.964    48.434     0.200
     2.993    49.033     0.200
     3.359    50.805     0.200
     3.359    52.344     0.200
     3.320    53.145     0.200
     3.320    53.023     0.200
     3.398    54.623     0.200
     3.469    54.914     0.200
     3.666    56.604     0.200
     3.666    56.492     0.200
     3.546    56.145     0.200
     3.582    56.604     0.200
     4.108    62.814     0.200
     4.243    66.023     0.200
     4.325    67.283     0.200
     4.352    67.344     0.200
     4.383    68.135     0.200
     4.705    70.783     0.200
     4.793    72.074     0.200
     4.841    72.773     0.200
     4.834    72.674     0.200
     4.834    72.799     0.200
     4.870    73.104     0.200
     4.920    74.885     0.200
     5.142    74.514     0.200
     5.142    75.686     0.200
     5.375    79.574     0.200
     5.401    80.014     0.200
     5.401    80.699     0.200
     5.518    82.174     0.200
     5.479    83.043     0.200
     5.748    85.123     0.200
     5.757    83.168     0.200
     5.767    85.645     0.200
     5.919    88.334     0.200
     6.038    87.555     0.200
     6.038    89.225     0.200
     6.133    90.494     0.200
     6.133    91.098     0.200
     6.168    91.475     0.200
     6.265    92.814     0.200
     6.265    92.664     0.200
     6.278    92.494     0.200
     6.315    92.768     0.200
     6.357    92.395     0.200
     6.357    93.174     0.200
     6.435    93.443     0.200
     6.435    94.488     0.200
     6.604    96.744     0.200
     6.604    97.166     0.200
     6.690    98.064     0.200
     6.796    99.363     0.200
     6.825   100.543     0.200
     6.825    99.793     0.200
     6.989   102.994     0.200
     6.987   102.334     0.200
     7.056   103.094     0.200
     7.230   105.395     0.200
     7.272   107.135     0.200
     7.272   106.109     0.200
     7.269   105.443     0.200
     7.338   106.154     0.200
     7.338   106.799     0.200
     7.357   107.164     0.200
     7.474   108.703     0.200
     7.579   110.234     0.200
     7.647   110.334     0.200
     7.678   110.805     0.200
     7.769   112.664     0.200
     7.846   113.744     0.200
     7.888   113.783     0.200
     7.888   114.479     0.200
     8.120   116.385     0.200
     8.120   116.588     0.200
     8.215   118.793     0.200
     8.257   119.104     0.200
     8.387   120.004     0.200
     8.243   120.463     0.200
     8.400   120.594     0.200
     8.400   120.234     0.200
     8.425   119.934     0.200
     8.448   121.055     0.200
     8.527   122.145     0.200
     8.572   122.314     0.200
     8.883   126.904     0.200
     8.883   126.693     0.200
     8.878   127.168     0.200
     8.896   127.904     0.200
     8.896   126.586     0.200
     8.896   128.225     0.200
     8.956   127.844     0.200
     9.042   130.154     0.200
     9.042   128.988     0.200
     9.040   128.885     0.200
     9.040   129.859     0.200
     9.314   133.293     0.200
     9.325   132.773     0.200
     9.515   135.664     0.200
     9.372   135.623     0.200
     9.633   137.334     0.200
     9.711   137.953     0.200
     9.805   139.854     0.200
     9.825   139.203     0.200
     9.825   138.836     0.200
     9.941   139.854     0.200
     9.792   140.783     0.200
     9.792   141.225     0.200
     9.964   142.193     0.200
    10.003   140.805     0.200
    10.096   144.814     0.200
    10.317   146.543     0.200
    10.362   148.033     0.200
    10.488   149.604     0.200
    10.644   150.854     0.200
    10.913   154.484     0.200
    10.931   154.373     0.200
    11.234   159.844     0.200
    11.471   161.963     0.200
    11.954   170.033     0.200
    12.047   170.213     0.200
    12.113   170.463     0.200
    12.218   172.414     0.200
    12.329   174.395     0.200
    12.423   175.773     0.200
    12.534   174.660     0.200
    12.818   182.023     0.200
    12.873   180.664     0.200
    13.319   189.354     0.200
    13.385   189.084     0.200
    13.401   188.934     0.200
    13.478   187.174     0.200
    14.024   193.164     0.200
    14.402   202.814     0.200
    14.568   204.693     0.200
    14.673   206.213     0.200
    14.694   207.145     0.200
    14.804   209.523     0.200
    15.153   210.283     0.200
    15.170   214.623     0.200
    15.204   213.434     0.200
    15.333   214.984     0.200
    15.786   220.574     0.200
    15.872   223.555     0.200
    16.149   224.754     0.200
    16.277   227.014     0.200
    16.315   226.994     0.200
    16.316   227.543     0.200
    16.348   228.744     0.200
    17.302   239.293     0.200
    17.887   245.984     0.200
     1.119    19.266     0.200
     1.119    19.457     0.200
     1.124    19.797     0.200
     1.204    21.227     0.200
     1.470    25.707     0.200
     1.825    29.848     0.200
     1.825    30.168     0.200
     2.008    32.887     0.200
     2.010    33.008     0.200
     2.004    32.797     0.200
     2.077    32.445     0.200
     2.080    33.848     0.200
     2.131    34.367     0.200
     2.291    36.656     0.200
     2.518    38.867     0.200
     2.518    40.789     0.200
     2.691    41.691     0.200
     2.765    42.316     0.200
     2.811    42.059     0.200
     2.982    45.926     0.200
     2.982    47.043     0.200
     3.217    48.668     0.200
     3.232    48.969     0.200
     3.300    50.242     0.200
     3.432    50.336     0.200
     3.432    50.188     0.200
     3.513    53.719     0.200
     3.643    54.617     0.200
     3.647    55.828     0.200
     3.842    57.188     0.200
     3.842    58.719     0.200
     3.871    57.766     0.200
     3.866    57.605     0.200
     4.033    59.137     0.200
     4.046    60.266     0.200
     4.033    60.766     0.200
     4.312    63.906     0.200
     4.312    64.344     0.200
     4.562    66.938     0.200
     4.628    68.938     0.200
     4.723    70.219     0.200
     4.789    69.879     0.200
     4.781    70.688     0.200
     4.798    70.828     0.200
     4.865    71.848     0.200
     4.867    71.605     0.200
     4.929    72.559     0.200
     5.029    73.539     0.200
     5.101    74.676     0.200
     5.339    78.258     0.200
     5.339    78.227     0.200
     5.380    78.738     0.200
     5.521    80.008     0.200
     5.585    81.988     0.200
     5.834    85.117     0.200
     6.060    87.617     0.200
     6.166    88.387     0.200
     6.283    90.848     0.200
     6.395    93.195     0.200
     6.504    93.727     0.200
     6.509    94.105     0.200
     6.513    94.746     0.200
     6.872    99.516     0.200
     7.017   102.277     0.200
     7.000   100.957     0.200
     7.200   103.746     0.200
     7.501   106.777     0.200
     7.654   109.707     0.200
     7.713   110.258     0.200
     7.755   111.219     0.200
     7.840   112.457     0.200
     7.898   112.016     0.200
     8.097   114.836     0.200
     8.185   117.809     0.200
     8.346   117.797     0.200
     8.312   119.137     0.200
     8.523   121.117     0.200
     8.564   121.945     0.200
     8.597   121.516     0.200
     8.630   123.508     0.200
     8.682   123.527     0.200
     8.862   126.258     0.200
     8.999   127.418     0.200
     9.118   129.629     0.200
     9.406   133.527     0.200
     9.473   134.727     0.200
     9.535   134.707     0.200
     9.609   136.066     0.200
     9.722   137.258     0.200
     9.803   139.559     0.200
     9.856   139.727     0.200
     9.868   140.488     0.200
     9.953   141.789     0.200
    10.155   141.328     0.200
    10.196   144.516     0.200
    10.259   144.926     0.200
    10.480   145.988     0.200
    11.054   155.336     0.200
    13.724   192.797     0.200
    14.045   197.469     0.200
    15.178   211.543     0.200
    15.702   219.496     0.200
    16.744   232.738     0.200
    16.744   230.691     0.200
     0.568    12.500     0.200
     0.749    14.879     0.200
     0.771    15.129     0.200
     0.806    15.738     0.200
     1.082    17.250     0.200
     1.082    18.477     0.200
     0.947    17.930     0.200
     1.119    20.629     0.200
     1.200    22.488     0.200
     1.340    22.719     0.200
     1.504    25.270     0.200
     1.631    26.930     0.200
     1.820    28.180     0.200
     1.877    29.844     0.200
     1.885    29.348     0.200
     2.098    32.758     0.200
     2.196    34.031     0.200
     2.197    34.027     0.200
     2.281    35.477     0.200
     2.475    36.816     0.200
     2.438    37.828     0.200
     2.483    38.270     0.200
     2.580    40.809     0.200
     2.744    41.930     0.200
     2.672    40.719     0.200
     2.672    41.316     0.200
     2.704    42.449     0.200
     2.714    42.809     0.200
     2.823    43.289     0.200
     3.059    44.867     0.200
     3.014    45.719     0.200
     3.224    48.539     0.200
     3.375    50.828     0.200
     3.375    50.691     0.200
     3.374    50.309     0.200
     3.390    50.316     0.200
     3.606    53.344     0.200
     3.608    53.477     0.200
     3.553    52.777     0.200
     3.667    54.879     0.200
     3.667    54.637     0.200
     3.813    57.430     0.200
     3.813    56.879     0.200
     3.886    58.699     0.200
     3.895    58.738     0.200
     4.085    60.828     0.200
     4.194    62.289     0.200
     4.294    63.188     0.200
     4.294    63.047     0.200
     4.307    63.066     0.200
     4.307    63.184     0.200
     4.385    64.879     0.200
     4.386    64.137     0.200
     4.342    64.590     0.200
     4.529    66.398     0.200
     4.613    67.797     0.200
     4.660    68.066     0.200
     4.854    71.109     0.200
     4.840    71.207     0.200
     4.794    70.148     0.200
     4.895    71.660     0.200
     4.871    71.309     0.200
     4.995    71.375     0.200
     5.083    73.797     0.200
     5.122    74.590     0.200
     5.183    75.098     0.200
     5.183    75.312     0.200
     5.232    76.898     0.200
     5.336    77.707     0.200
     5.597    80.680     0.200
     5.597    80.910     0.200
     5.712    81.527     0.200
     5.810    84.148     0.200
     5.854    84.148     0.200
     5.937    85.520     0.200
     6.017    86.789     0.200
     6.016    86.168     0.200
     6.016    86.352     0.200
     6.077    87.879     0.200
     6.108    88.199     0.200
     6.278    90.168     0.200
     6.298    89.488     0.200
     6.435    93.008     0.200
     6.435    92.527     0.200
     6.506    93.508     0.200
     6.517    94.020     0.200
     6.519    93.469     0.200
     6.632    93.238     0.200
     6.755    96.199     0.200
     6.755    96.566     0.200
     7.095    99.777     0.200
     7.235   102.719     0.200
     7.263   103.188     0.200
     7.263   103.297     0.200
     7.254   103.188     0.200
     7.254   103.297     0.200
     7.340   104.219     0.200
     7.687   109.547     0.200
     7.836   110.969     0.200
     7.951   111.539     0.200
     8.072   114.469     0.200
     8.131   114.520     0.200
     8.377   117.258     0.200
     8.761   124.379     0.200
     8.962   125.727     0.200
     9.333   129.816     0.200
     9.333   130.688     0.200
     9.667   134.566     0.200
     9.686   134.039     0.200
     9.763   136.430     0.200
    10.148   140.457     0.200
     1.378    26.189     0.200
     1.378    27.010     0.200
     1.372    28.430     0.200
     2.083    36.270     0.200
     2.082    36.623     0.200
     2.083    35.920     0.200
     2.454    40.080     0.200
     2.454    41.359     0.200
     2.894    47.340     0.200
     3.049    49.270     0.200
     3.055    49.270     0.200
     3.484    54.359     0.200
     3.484    54.660     0.200
     3.484    54.943     0.200
     3.743    59.160     0.200
     3.743    58.918     0.200
     4.091    63.939     0.200
     4.242    65.850     0.200
     4.516    68.590     0.200
     4.516    68.738     0.200
     4.822    73.740     0.200
     4.822    73.451     0.200
     4.842    73.311     0.200
     4.842    73.807     0.200
     4.914    74.371     0.200
     4.914    74.709     0.200
     4.930    75.350     0.200
     4.942    75.246     0.200
     4.940    75.182     0.200
     4.999    75.510     0.200
     5.257    77.730     0.200
     5.257    77.961     0.200
     5.257    78.113     0.200
     5.437    82.336     0.200
     5.444    83.000     0.200
     5.444    82.861     0.200
     5.449    81.520     0.200
     5.449    82.434     0.200
     5.489    82.590     0.200
     5.521    83.250     0.200
     5.805    87.061     0.200
     5.790    86.551     0.200
     5.790    86.652     0.200
     5.868    87.010     0.200
     5.868    86.754     0.200
     5.868    85.900     0.200
     5.949    88.650     0.200
     5.949    89.227     0.200
     6.131    91.230     0.200
     6.131    90.959     0.200
     6.119    91.199     0.200
     6.119    92.262     0.200
     6.203    93.041     0.200
     6.293    92.721     0.200
     6.337    93.920     0.200
     6.337    94.307     0.200
     6.359    94.391     0.200
     6.417    95.410     0.200
     6.419    94.689     0.200
     6.485    95.041     0.200
     6.485    96.303     0.200
     6.562    97.660     0.200
     6.562    98.023     0.200
     6.722    99.449     0.200
     6.798    99.721     0.200
     6.798   100.824     0.200
     6.871   100.859     0.200
     6.871   102.283     0.200
     6.885   102.529     0.200
     6.885   102.049     0.200
     6.983   102.609     0.200
     6.983   103.461     0.200
     7.074   103.881     0.200
     7.079   104.660     0.200
     7.272   107.109     0.200
     7.322   108.291     0.200
     7.322   108.625     0.200
     7.276   106.510     0.200
     7.341   108.240     0.200
     7.341   108.982     0.200
     7.382   108.520     0.200
     7.382   109.514     0.200
     7.362   107.820     0.200
     7.362   108.385     0.200
     7.525   111.061     0.200
     7.556   110.971     0.200
     7.584   112.291     0.200
     7.633   112.471     0.200
     7.744   111.820     0.200
     7.761   113.510     0.200
     7.792   113.094     0.200
     7.750   113.541     0.200
     7.750   114.363     0.200
     7.879   114.910     0.200
     7.879   115.336     0.200
     7.895   115.340     0.200
     7.895   116.014     0.200
     8.164   118.500     0.200
     8.164   119.484     0.200
     8.257   121.779     0.200
     8.261   121.080     0.200
     8.290   121.670     0.200
     8.303   122.291     0.200
     8.305   121.551     0.200
     8.305   122.514     0.200
     8.308   120.189     0.200
     8.308   122.045     0.200
     8.324   120.211     0.200
     8.324   122.594     0.200
     8.337   120.689     0.200
     8.456   122.971     0.200
     8.456   123.881     0.200
     8.450   122.109     0.200
     8.450   122.406     0.200
     8.480   122.760     0.200
     8.441   122.510     0.200
     8.441   123.217     0.200
     8.524   123.461     0.200
     8.524   123.844     0.200
     8.596   126.250     0.200
     8.596   126.684     0.200
     8.650   125.391     0.200
     8.650   125.568     0.200
     8.913   128.301     0.200
     8.892   128.605     0.200
     8.930   130.430     0.200
     8.930   129.875     0.200
     8.941   128.990     0.200
     8.941   129.131     0.200
     9.046   130.689     0.200
     9.046   130.475     0.200
     9.064   130.510     0.200
     9.064   130.271     0.200
     9.118   132.061     0.200
     9.118   133.035     0.200
     9.319   134.186     0.200
     9.353   134.510     0.200
     9.353   135.109     0.200
     9.421   134.721     0.200
     9.421   135.643     0.200
     9.495   136.510     0.200
     9.495   137.494     0.200
     9.603   137.471     0.200
     9.603   137.961     0.200
     9.603   137.607     0.200
     9.676   139.301     0.200
     9.676   140.148     0.200
     9.690   138.689     0.200
     9.690   141.910     0.200
     9.725   139.189     0.200
     9.799   140.949     0.200
     9.822   141.340     0.200
     9.822   140.193     0.200
     9.910   141.600     0.200
     9.925   142.090     0.200
     9.925   141.818     0.200
    10.007   143.750     0.200
    10.030   141.609     0.200
    10.030   143.172     0.200
     9.658   143.580     0.200
    10.105   142.770     0.200
    10.159   144.541     0.200
    10.159   146.809     0.200
    10.238   146.312     0.200
    10.310   147.000     0.200
    10.310   146.660     0.200
    10.310   147.354     0.200
    10.409   148.260     0.200
    10.409   148.828     0.200
    10.412   148.830     0.200
    10.412   150.285     0.200
    10.391   149.291     0.200
    10.391   149.881     0.200
    10.507   152.025     0.200
    10.556   150.971     0.200
    10.577   152.074     0.200
    10.601   151.221     0.200
    10.566   151.910     0.200
    10.566   152.521     0.200
    10.622   151.121     0.200
    10.622   151.779     0.200
    10.639   151.699     0.200
    10.639   152.590     0.200
    10.702   152.811     0.200
    10.742   153.100     0.200
    10.700   154.424     0.200
    10.864   154.510     0.200
    10.854   156.170     0.200
    10.854   156.031     0.200
    10.934   155.420     0.200
    10.934   154.885     0.200
    10.997   156.850     0.200
    10.997   157.670     0.200
    11.006   156.750     0.200
    11.006   156.900     0.200
    11.007   156.420     0.200
    11.006   156.859     0.200
    11.021   157.760     0.200
    11.021   158.404     0.200
    11.140   158.051     0.200
    11.116   159.842     0.200
    11.234   158.260     0.200
    11.234   159.615     0.200
    11.334   160.791     0.200
    11.334   161.572     0.200
    11.383   162.230     0.200
    11.383   163.273     0.200
    11.376   163.273     0.200
    11.450   163.891     0.200
    11.449   164.480     0.200
    11.449   164.219     0.200
    11.534   164.566     0.200
    11.569   163.832     0.200
    11.574   164.020     0.200
    11.575   164.996     0.200
    11.622   165.561     0.200
    11.721   166.871     0.200
    11.721   167.346     0.200
    11.660   166.850     0.200
    11.660   167.684     0.200
    11.802   167.400     0.200
    11.802   167.291     0.200
    11.863   169.301     0.200
    11.863   168.898     0.200
    11.879   166.400     0.200
    11.879   166.863     0.200
    11.927   170.260     0.200
    11.927   169.922     0.200
    12.003   170.730     0.200
    12.003   171.477     0.200
    12.043   168.820     0.200
    12.058   171.891     0.200
    12.058   171.334     0.200
    12.248   173.676     0.200
    12.257   171.590     0.200
    12.261   172.740     0.200
    12.261   172.623     0.200
    12.239   175.078     0.200
    12.320   172.641     0.200
    12.398   175.029     0.200
    12.398   175.717     0.200
    12.418   176.180     0.200
    12.418   176.561     0.200
    12.422   175.061     0.200
    12.422   174.561     0.200
    12.422   175.576     0.200
    12.473   178.469     0.200
    12.516   176.670     0.200
    12.516   176.861     0.200
    12.559   179.070     0.200
    12.559   178.666     0.200
    12.607   177.791     0.200
    12.608   176.141     0.200
    12.608   177.820     0.200
    12.691   180.668     0.200
    12.724   179.680     0.200
    12.723   178.660     0.200
    12.723   179.830     0.200
    12.705   180.951     0.200
    12.824   181.732     0.200
    12.887   183.111     0.200
    12.940   181.359     0.200
    12.959   182.189     0.200
    12.959   181.971     0.200
    12.936   183.777     0.200
    13.045   184.336     0.200
    13.183   186.195     0.200
    13.205   186.121     0.200
    13.205   186.562     0.200
    13.224   186.430     0.200
    13.213   187.533     0.200
    13.264   188.961     0.200
    13.360   190.562     0.200
    13.352   190.492     0.200
    13.439   188.859     0.200
    13.455   189.705     0.200
    13.500   191.420     0.200
    13.500   191.574     0.200
    13.552   190.230     0.200
    13.552   190.090     0.200
    13.656   192.877     0.200
    13.703   194.330     0.200
    13.703   194.213     0.200
    13.790   196.689     0.200
    13.789   195.984     0.200
    13.809   196.508     0.200
    13.879   195.029     0.200
    13.879   195.916     0.200
    13.984   197.070     0.200
    13.984   196.686     0.200
    14.040   197.361     0.200
    14.036   198.199     0.200
    14.036   200.109     0.200
    14.078   200.055     0.200
    14.155   201.041     0.200
    14.155   200.043     0.200
    14.132   201.068     0.200
    14.193   199.855     0.200
    14.237   201.752     0.200
    14.284   201.449     0.200
    14.284   201.262     0.200
    14.275   203.113     0.200
    14.297   202.109     0.200
    14.297   201.904     0.200
    14.422   203.670     0.200
    14.444   204.359     0.200
    14.444   205.031     0.200
    14.464   205.059     0.200
    14.496   205.971     0.200
    14.536   204.320     0.200
    14.536   204.949     0.200
    14.579   205.000     0.200
    14.579   204.859     0.200
    14.662   206.461     0.200
    14.662   205.992     0.200
    14.703   207.340     0.200
    14.723   208.123     0.200
    14.784   206.689     0.200
    14.762   208.561     0.200
    14.762   209.004     0.200
    14.809   207.838     0.200
    14.925   212.240     0.200
    14.925   211.461     0.200
    14.925   211.051     0.200
    14.941   210.330     0.200
    14.941   210.652     0.200
    14.997   212.193     0.200
    15.030   211.557     0.200
    15.090   210.750     0.200
    15.075   213.785     0.200
    15.130   212.090     0.200
    15.130   211.256     0.200
    15.144   212.250     0.200
    15.168   214.320     0.200
    15.168   214.713     0.200
    15.223   212.807     0.200
    15.239   213.811     0.200
    15.252   215.061     0.200
    15.252   214.830     0.200
    15.252   214.455     0.200
    15.275   215.189     0.200
    15.301   214.912     0.200
    15.295   216.461     0.200
    15.362   217.541     0.200
    15.362   217.152     0.200
    15.376   216.953     0.200
    15.564   217.191     0.200
    15.542   218.164     0.200
    15.577   217.396     0.200
    15.574   218.660     0.200
    15.574   218.336     0.200
    15.746   221.402     0.200
    15.757   222.529     0.200
    15.757   221.523     0.200
    15.823   222.699     0.200
    15.823   222.252     0.200
    15.834   222.041     0.200
    15.834   222.551     0.200
    15.839   222.295     0.200
    16.075   225.295     0.200
    16.109   226.631     0.200
    16.190   226.309     0.200
    16.216   224.854     0.200
    16.289   227.100     0.200
    16.289   228.447     0.200
    16.325   228.186     0.200
    16.369   227.420     0.200
    16.369   228.086     0.200
    16.348   227.686     0.200
    16.361   227.889     0.200
    16.412   228.199     0.200
    16.412   229.084     0.200
    16.458   230.730     0.200
    16.458   230.174     0.200
    16.439   230.260     0.200
    16.573   230.773     0.200
    16.741   232.719     0.200
    16.865   234.811     0.200
    17.015   238.080     0.200
    17.015   237.418     0.200
    17.135   238.170     0.200
    17.192   238.867     0.200
    17.193   238.877     0.200
    17.357   240.717     0.200
    17.408   240.717     0.200
    17.509   242.420     0.200
    17.539   243.869     0.200
    17.594   244.217     0.200
    17.710   244.734     0.200
    17.857   246.861     0.200
    17.973   247.301     0.200
    18.121   248.740     0.200
    18.278   252.967     0.200
     1.374    25.551     0.200
     1.467    27.094     0.200
     1.467    27.383     0.200
     1.611    29.543     0.200
     1.667    31.281     0.200
     1.983    35.152     0.200
     2.337    39.043     0.200
     2.108    37.801     0.200
     2.204    38.922     0.200
     2.788    47.434     0.200
     2.931    49.844     0.200
     2.980    48.383     0.200
     3.353    52.570     0.200
     3.353    52.383     0.200
     3.311    53.254     0.200
     3.634    56.812     0.200
     3.537    57.184     0.200
     3.573    56.922     0.200
     3.978    62.383     0.200
     4.386    66.633     0.200
     4.386    66.281     0.200
     4.319    68.312     0.200
     4.787    72.262     0.200
     4.814    73.633     0.200
     4.848    73.613     0.200
     5.128    75.793     0.200
     5.128    76.281     0.200
     5.471    81.820     0.200
     5.723    85.434     0.200
     5.740    85.113     0.200
     5.740    84.402     0.200
     6.012    89.523     0.200
     5.881    88.281     0.200
     6.085    90.883     0.200
     6.126    91.242     0.200
     6.231    93.504     0.200
     6.310    92.730     0.200
     6.396    94.504     0.200
     6.556    96.934     0.200
     6.647    97.820     0.200
     6.788    99.684     0.200
     6.940   101.621     0.200
     7.189   105.262     0.200
     7.238   106.582     0.200
     7.294   106.211     0.200
     7.623   109.344     0.200
     7.841   114.051     0.200
     8.079   117.332     0.200
     8.362   121.434     0.200
     8.376   121.191     0.200
     8.401   121.551     0.200
     8.236   122.684     0.200
     8.832   126.902     0.200
     8.854   127.934     0.200
     8.855   127.383     0.200
     8.855   128.480     0.200
     8.996   128.641     0.200
     9.301   133.160     0.200
     9.607   137.684     0.200
     9.786   139.820     0.200
    10.356   148.941     0.200
    10.621   151.453     0.200
    10.970   156.801     0.200
    11.212   159.332     0.200
    11.409   163.441     0.200
    12.276   174.473     0.200
    13.372   190.371     0.200
    14.219   201.070     0.200
    14.849   208.113     0.200
    15.152   211.473     0.200
    15.164   212.801     0.200
     1.619    29.645     0.200
     1.619    29.973     0.200
     1.765    31.203     0.200
     1.857    32.633     0.200
     1.891    33.359     0.200
     1.892    33.184     0.200
     1.769    32.105     0.200
     1.941    33.934     0.200
     1.822    33.586     0.200
     1.934    35.414     0.200
     2.214    36.793     0.200
     2.214    37.191     0.200
     2.382    41.773     0.200
     2.671    43.895     0.200
     3.191    50.055     0.200
     3.118    52.273     0.200
     3.145    52.574     0.200
     3.148    52.965     0.200
     3.173    53.184     0.200
     3.526    55.266     0.200
     3.479    56.586     0.200
     3.479    56.445     0.200
     3.628    58.855     0.200
     3.861    60.496     0.200
     4.010    62.766     0.200
     4.229    64.293     0.200
     4.229    64.105     0.200
     4.648    70.074     0.200
     4.648    70.449     0.200
     4.487    71.406     0.200
     4.701    71.785     0.200
     4.733    72.395     0.200
     4.757    72.535     0.200
     4.768    73.004     0.200
     4.768    73.168     0.200
     4.764    72.633     0.200
     4.670    73.195     0.200
     4.976    73.836     0.200
     4.976    74.145     0.200
     5.202    78.793     0.200
     5.200    78.746     0.200
     5.244    79.246     0.200
     5.242    79.273     0.200
     5.242    79.000     0.200
     5.084    78.453     0.200
     5.084    77.789     0.200
     5.288    79.426     0.200
     5.288    79.609     0.200
     5.453    81.906     0.200
     5.453    82.055     0.200
     5.592    82.734     0.200
     5.592    82.422     0.200
     5.446    81.785     0.200
     5.626    84.375     0.200
     5.681    85.129     0.200
     5.731    84.934     0.200
     5.731    85.531     0.200
     5.884    87.305     0.200
     5.884    87.523     0.200
     6.067    90.566     0.200
     6.067    91.340     0.200
     6.128    90.496     0.200
     6.128    91.777     0.200
     6.154    91.660     0.200
     6.008    90.285     0.200
     6.008    90.797     0.200
     6.156    90.605     0.200
     6.088    90.215     0.200
     6.088    91.246     0.200
     6.200    91.859     0.200
     6.319    93.094     0.200
     6.319    93.695     0.200
     6.294    92.695     0.200
     6.294    93.328     0.200
     6.561    96.754     0.200
     6.594    97.273     0.200
     6.594    97.793     0.200
     6.656    98.715     0.200
     6.656    98.902     0.200
     6.594    97.375     0.200
     6.594    98.137     0.200
     6.699    98.773     0.200
     6.699    99.973     0.200
     6.842   100.516     0.200
     6.846   101.414     0.200
     6.930   101.977     0.200
     6.930   102.551     0.200
     7.086   104.953     0.200
     7.131   103.996     0.200
     7.131   104.250     0.200
     7.121   104.426     0.200
     7.138   104.953     0.200
     7.138   105.707     0.200
     7.199   104.625     0.200
     7.199   106.074     0.200
     7.248   105.906     0.200
     7.248   106.988     0.200
     7.296   107.246     0.200
     7.360   108.746     0.200
     7.458   110.445     0.200
     7.458   109.762     0.200
     7.490   108.465     0.200
     7.536   108.977     0.200
     7.532   110.566     0.200
     7.747   112.754     0.200
     7.729   112.344     0.200
     7.729   114.004     0.200
     7.817   114.742     0.200
     8.009   115.695     0.200
     8.009   117.496     0.200
     8.083   118.715     0.200
     8.120   119.172     0.200
     8.232   118.125     0.200
     8.266   119.066     0.200
     8.266   120.355     0.200
     8.277   119.543     0.200
     8.277   121.211     0.200
     8.322   120.215     0.200
     8.322   121.355     0.200
     8.399   120.965     0.200
     8.399   122.223     0.200
     8.393   121.145     0.200
     8.393   122.840     0.200
     8.430   121.164     0.200
     8.394   121.566     0.200
     8.394   122.430     0.200
     8.404   123.066     0.200
     8.743   127.996     0.200
     8.743   127.359     0.200
     8.804   126.996     0.200
     8.804   127.434     0.200
     8.799   127.156     0.200
     8.799   128.055     0.200
     8.902   127.715     0.200
     8.902   128.805     0.200
     8.950   128.344     0.200
     8.950   129.828     0.200
     9.051   130.164     0.200
     9.051   130.684     0.200
     9.152   131.910     0.200
     9.168   132.195     0.200
     9.209   132.203     0.200
     9.209   133.270     0.200
     9.404   135.777     0.200
     9.480   135.383     0.200
     9.480   136.391     0.200
     9.491   137.262     0.200
     9.501   136.574     0.200
     9.501   137.906     0.200
     9.561   136.406     0.200
     9.602   139.238     0.200
     9.644   137.523     0.200
     9.666   138.285     0.200
     9.666   138.695     0.200
     9.789   140.984     0.200
     9.843   139.496     0.200
     9.854   142.992     0.200
     9.966   144.355     0.200
     9.994   143.535     0.200
    10.043   142.914     0.200
    10.043   143.305     0.200
     9.952   144.523     0.200
    10.163   145.535     0.200
    10.188   147.172     0.200
    10.246   148.172     0.200
    10.345   148.262     0.200
    10.321   148.469     0.200
    10.357   147.984     0.200
    10.357   149.469     0.200
    10.432   149.961     0.200
    10.443   150.910     0.200
    10.486   149.105     0.200
    10.486   149.953     0.200
    10.466   150.453     0.200
    10.648   153.641     0.200
    10.740   152.574     0.200
    10.740   153.320     0.200
    10.759   154.605     0.200
    10.759   153.996     0.200
    10.738   155.105     0.200
    10.776   155.371     0.200
    10.803   156.445     0.200
    10.866   154.484     0.200
    10.855   157.027     0.200
    10.948   157.266     0.200
    11.021   156.574     0.200
    11.021   158.145     0.200
    11.075   158.668     0.200
    11.025   158.793     0.200
    11.273   161.195     0.200
    11.249   162.316     0.200
    11.311   160.656     0.200
    11.321   161.996     0.200
    11.355   162.625     0.200
    11.346   163.742     0.200
    11.401   164.016     0.200
    11.401   164.273     0.200
    11.465   164.895     0.200
    11.562   165.527     0.200
    11.584   164.797     0.200
    11.676   167.297     0.200
    11.646   166.766     0.200
    11.646   166.918     0.200
    11.802   168.520     0.200
    11.833   165.996     0.200
    11.838   169.004     0.200
    11.838   169.871     0.200
    12.018   170.812     0.200
    11.973   171.559     0.200
    12.067   169.113     0.200
    12.067   172.215     0.200
    12.142   173.125     0.200
    12.140   173.773     0.200
    12.281   175.363     0.200
    12.300   176.320     0.200
    12.355   175.129     0.200
    12.359   176.070     0.200
    12.395   173.215     0.200
    12.395   174.266     0.200
    12.395   173.105     0.200
    12.443   177.855     0.200
    12.486   177.543     0.200
    12.564   178.938     0.200
    12.538   179.207     0.200
    12.610   178.879     0.200
    12.602   180.461     0.200
    12.650   179.203     0.200
    12.650   179.863     0.200
    12.625   180.340     0.200
    12.718   179.848     0.200
    12.723   177.965     0.200
    12.723   180.430     0.200
    12.804   181.902     0.200
    12.884   182.262     0.200
    12.953   183.406     0.200
    12.991   185.039     0.200
    13.005   184.414     0.200
    12.987   185.465     0.200
    12.954   183.664     0.200
    12.954   184.879     0.200
    13.094   186.816     0.200
    13.218   188.855     0.200
    13.207   187.992     0.200
    13.212   189.012     0.200
    13.280   189.809     0.200
    13.281   189.863     0.200
    13.339   189.180     0.200
    13.414   189.375     0.200
    13.414   190.227     0.200
    13.460   191.184     0.200
    13.510   191.836     0.200
    13.654   194.164     0.200
    13.709   195.219     0.200
    13.793   195.703     0.200
    13.837   195.906     0.200
    13.875   196.543     0.200
    13.952   197.660     0.200
    14.003   196.965     0.200
    14.003   197.883     0.200
    13.955   198.637     0.200
    14.017   198.141     0.200
    13.982   199.203     0.200
    14.061   200.453     0.200
    14.084   199.922     0.200
    14.163   201.328     0.200
    14.189   201.324     0.200
    14.189   202.254     0.200
    14.291   202.980     0.200
    14.413   204.340     0.200
    14.399   204.129     0.200
    14.442   204.523     0.200
    14.557   206.508     0.200
    14.556   206.996     0.200
    14.636   207.234     0.200
    14.781   209.434     0.200
    14.768   207.695     0.200
    14.768   209.637     0.200
    14.873   210.527     0.200
    14.930   210.492     0.200
    14.887   211.477     0.200
    14.946   212.242     0.200
    15.004   209.273     0.200
    15.004   212.285     0.200
    15.002   212.773     0.200
    15.020   212.305     0.200
    15.053   213.000     0.200
    15.089   214.262     0.200
    15.222   213.836     0.200
    15.222   214.758     0.200
    15.362   216.363     0.200
    15.367   217.559     0.200
    15.387   217.906     0.200
    15.468   217.984     0.200
    15.509   218.340     0.200
    15.708   220.906     0.200
    15.708   221.355     0.200
    15.824   222.574     0.200
    15.984   225.125     0.200
    16.003   224.742     0.200
    16.041   224.375     0.200
    16.041   225.312     0.200
    16.123   226.484     0.200
    16.123   227.102     0.200
    16.147   226.645     0.200
    16.184   227.395     0.200
    16.202   227.301     0.200
    16.216   227.895     0.200
    16.216   228.102     0.200
    16.239   228.531     0.200
    16.514   232.094     0.200
    16.616   233.348     0.200
    16.721   233.754     0.200
    17.018   237.602     0.200
    17.127   239.270     0.200
    17.149   237.977     0.200
    17.149   239.648     0.200
    17.301   241.254     0.200
    17.497   243.395     0.200
    17.631   244.953     0.200
    17.737   245.016     0.200
    17.737   246.223     0.200
    18.733   258.812     0.200
    19.796   271.422     0.200
     1.282    23.367     0.200
     1.299    23.555     0.200
     1.573    27.102     0.200
     1.594    27.977     0.200
     1.806    29.336     0.200
     2.385    38.328     0.200
     2.382    39.422     0.200
     2.441    39.180     0.200
     2.441    39.672     0.200
     2.688    41.289     0.200
     2.826    45.750     0.200
     3.456    52.852     0.200
     3.535    53.961     0.200
     3.482    53.672     0.200
     3.482    54.648     0.200
     3.654    55.867     0.200
     3.628    56.422     0.200
     3.654    57.000     0.200
     3.731    55.500     0.200
     3.731    55.648     0.200
     3.969    60.555     0.200
     4.040    62.180     0.200
     4.040    62.297     0.200
     4.125    62.016     0.200
     4.118    62.805     0.200
     4.180    62.180     0.200
     4.195    63.969     0.200
     4.330    64.438     0.200
     4.459    66.602     0.200
     4.486    65.438     0.200
     4.481    66.047     0.200
     4.619    68.398     0.200
     4.880    72.570     0.200
     4.900    73.805     0.200
     4.996    72.680     0.200
     4.982    74.508     0.200
     5.006    75.078     0.200
     5.110    74.289     0.200
     5.110    72.945     0.200
     5.110    73.547     0.200
     5.110    74.391     0.200
     5.320    77.922     0.200
     5.341    78.086     0.200
     5.447    79.195     0.200
     5.477    80.578     0.200
     5.583    82.781     0.200
     5.583    83.047     0.200
     5.692    83.289     0.200
     5.751    84.016     0.200
     5.786    85.180     0.200
     5.844    85.789     0.200
     6.014    87.656     0.200
     6.016    88.875     0.200
     6.137    89.000     0.200
     6.161    89.891     0.200
     6.269    91.430     0.200
     6.353    92.719     0.200
     6.321    92.617     0.200
     6.361    92.859     0.200
     6.426    93.836     0.200
     6.625    96.500     0.200
     6.665    96.719     0.200
     6.686    96.578     0.200
     6.746    97.141     0.200
     6.770    97.141     0.200
     6.816    98.328     0.200
     6.838    98.727     0.200
     6.886    99.430     0.200
     6.922    99.555     0.200
     6.955    99.625     0.200
     7.119   102.898     0.200
     7.662   109.195     0.200
     7.657   109.969     0.200
     7.666   110.055     0.200
     7.711   110.742     0.200
     7.718   110.656     0.200
     7.774   111.797     0.200
     7.791   112.180     0.200
     7.809   111.188     0.200
     7.945   113.742     0.200
     8.024   114.625     0.200
     8.031   114.859     0.200
     8.075   116.047     0.200
     8.286   118.508     0.200
     8.323   118.680     0.200
     8.370   119.750     0.200
     8.398   120.727     0.200
     8.509   121.836     0.200
     8.578   122.039     0.200
     8.611   123.016     0.200
     8.717   122.375     0.200
     8.726   124.148     0.200
     8.736   123.930     0.200
     8.759   123.648     0.200
     8.935   127.508     0.200
     8.935   127.148     0.200
     8.934   127.070     0.200
     8.896   128.648     0.200
     8.896   128.445     0.200
     9.041   128.500     0.200
     9.127   130.805     0.200
     9.133   129.641     0.200
     9.173   129.836     0.200
     9.175   131.031     0.200
     9.202   129.625     0.200
     9.207   129.625     0.200
     9.217   131.609     0.200
     9.377   130.922     0.200
     9.571   134.750     0.200
     9.571   135.852     0.200
     9.565   135.766     0.200
     9.610   136.945     0.200
     9.723   137.281     0.200
     9.859   139.141     0.200
     9.877   138.945     0.200
     9.933   141.008     0.200
     9.948   140.742     0.200
     9.951   139.461     0.200
     9.985   142.555     0.200
    10.022   140.727     0.200
     9.966   142.195     0.200
    10.030   140.750     0.200
    10.052   143.016     0.200
    10.020   142.898     0.200
    10.212   144.938     0.200
    10.269   145.328     0.200
    10.263   146.258     0.200
    10.265   146.367     0.200
    10.315   145.672     0.200
    10.384   146.477     0.200
    10.394   146.781     0.200
    10.444   148.266     0.200
    10.477   149.430     0.200
    10.440   149.305     0.200
    10.440   148.852     0.200
    10.507   149.539     0.200
    10.579   149.211     0.200
    10.614   149.438     0.200
    10.632   150.211     0.200
    10.789   151.289     0.200
    10.795   151.148     0.200
    10.791   152.992     0.200
    10.843   153.297     0.200
    10.857   154.617     0.200
    10.883   153.875     0.200
    10.899   153.898     0.200
    10.931   153.906     0.200
    10.988   155.188     0.200
    11.083   155.852     0.200
    11.095   156.297     0.200
    11.141   156.641     0.200
    11.242   159.320     0.200
    11.259   158.680     0.200
    11.282   160.242     0.200
    11.314   160.766     0.200
    11.400   160.461     0.200
    11.526   163.031     0.200
    11.556   164.148     0.200
    11.565   163.305     0.200
    11.578   163.336     0.200
    11.602   163.461     0.200
    11.586   164.469     0.200
    11.663   164.000     0.200
    11.683   164.305     0.200
    11.685   164.398     0.200
    11.706   164.820     0.200
    11.706   165.227     0.200
    11.726   166.297     0.200
    11.726   165.648     0.200
    11.775   166.031     0.200
    11.793   166.648     0.200
    11.835   167.648     0.200
    11.835   166.547     0.200
    11.857   166.586     0.200
    11.862   166.531     0.200
    11.914   167.461     0.200
    12.004   167.750     0.200
    12.004   165.250     0.200
    12.055   168.961     0.200
    12.102   170.391     0.200
    12.117   169.656     0.200
    12.124   169.680     0.200
    12.137   170.031     0.200
    12.154   171.148     0.200
    12.211   172.602     0.200
    12.245   172.531     0.200
    12.254   172.680     0.200
    12.297   172.305     0.200
    12.312   171.797     0.200
    12.501   175.680     0.200
    12.519   175.141     0.200
    12.544   176.242     0.200
    12.622   177.828     0.200
    12.725   179.242     0.200
    12.763   180.227     0.200
    12.787   179.375     0.200
    12.857   182.586     0.200
    12.926   182.266     0.200
    12.950   181.219     0.200
    12.949   181.641     0.200
    12.962   182.695     0.200
    12.979   182.695     0.200
    12.944   183.289     0.200
    13.385   188.055     0.200
    13.387   188.352     0.200
    13.438   187.969     0.200
    13.469   187.125     0.200
    13.499   189.258     0.200
    13.775   192.398     0.200
    13.852   196.219     0.200
    13.862   195.367     0.200
    13.965   197.008     0.200
    13.963   195.117     0.200
    13.996   197.578     0.200
    14.005   197.086     0.200
    14.035   196.477     0.200
    14.059   198.055     0.200
    14.056   198.805     0.200
    14.136   199.359     0.200
    14.139   199.898     0.200
    14.308   201.102     0.200
    14.369   200.961     0.200
    14.427   203.102     0.200
    14.440   203.195     0.200
    14.563   203.742     0.200
    14.581   203.547     0.200
    14.585   204.180     0.200
    14.606   204.539     0.200
    14.607   206.148     0.200
    14.687   204.992     0.200
    14.778   206.828     0.200
    14.924   208.906     0.200
    14.966   206.906     0.200
    14.969   209.891     0.200
    15.001   209.359     0.200
    15.036   209.930     0.200
    15.075   210.500     0.200
    15.236   212.211     0.200
    15.314   214.359     0.200
    15.505   216.430     0.200
    15.636   218.195     0.200
    15.681   219.109     0.200
    15.895   220.359     0.200
    16.029   222.680     0.200
    16.191   225.938     0.200
    16.708   230.930     0.200
    16.708   231.539     0.200
    16.798   231.352     0.200
    16.821   233.461     0.200
    17.311   238.359     0.200
    18.322   251.852     0.200
     1.222    21.988     0.200
     1.174    20.508     0.200
     1.302    23.176     0.200
     1.369    24.258     0.200
     1.414    23.727     0.200
     1.497    26.305     0.200
     1.497    26.555     0.200
     1.936    30.285     0.200
     1.921    31.465     0.200
     1.970    32.418     0.200
     1.882    31.527     0.200
     1.897    31.816     0.200
     2.016    33.277     0.200
     1.928    32.527     0.200
     2.142    34.945     0.200
     3.002    45.195     0.200
     3.002    45.816     0.200
     2.981    46.438     0.200
     3.014    46.617     0.200
     3.117    48.078     0.200
     3.142    48.676     0.200
     3.201    50.598     0.200
     3.654    55.828     0.200
     3.583    55.535     0.200
     3.780    55.246     0.200
     3.606    56.027     0.200
     3.784    56.887     0.200
     4.161    62.238     0.200
     4.242    62.945     0.200
     4.250    63.688     0.200
     4.423    64.488     0.200
     4.423    64.309     0.200
     4.252    64.035     0.200
     4.252    64.316     0.200
     4.346    64.445     0.200
     4.470    66.727     0.200
     4.364    66.145     0.200
     4.397    66.168     0.200
     4.607    68.727     0.200
     4.720    69.777     0.200
     4.869    71.598     0.200
     4.867    72.027     0.200
     4.742    70.348     0.200
     4.811    72.125     0.200
     5.051    73.438     0.200
     5.299    77.875     0.200
     5.312    78.578     0.200
     5.350    78.758     0.200
     5.586    81.777     0.200
     5.596    83.176     0.200
     5.698    82.906     0.200
     5.791    83.977     0.200
     5.887    86.738     0.200
     5.889    85.445     0.200
     5.951    87.418     0.200
     5.979    87.246     0.200
     6.124    88.566     0.200
     6.093    89.586     0.200
     6.149    89.816     0.200
     6.142    89.387     0.200
     6.326    91.918     0.200
     6.357    91.496     0.200
     6.395    92.535     0.200
     6.420    91.098     0.200
     6.399    92.328     0.200
     6.439    93.117     0.200
     6.358    92.926     0.200
     6.358    95.117     0.200
     6.528    94.078     0.200
     6.418    93.875     0.200
     6.586    95.395     0.200
     6.554    94.695     0.200
     6.775    98.367     0.200
     6.817    98.246     0.200
     6.852    98.227     0.200
     6.851    98.688     0.200
     6.918    99.438     0.200
     7.175   102.438     0.200
     7.193   102.445     0.200
     7.342   104.945     0.200
     7.414   106.465     0.200
     7.520   107.395     0.200
     7.570   108.078     0.200
     7.565   108.047     0.200
     7.578   108.418     0.200
     7.787   111.137     0.200
     7.740   111.406     0.200
     7.907   112.586     0.200
     7.847   112.516     0.200
     8.054   113.656     0.200
     7.991   114.848     0.200
     8.009   113.926     0.200
     8.096   113.988     0.200
     8.285   118.328     0.200
     8.505   120.266     0.200
     8.561   121.266     0.200
     8.533   121.715     0.200
     8.723   122.867     0.200
     9.123   129.098     0.200
     9.083   129.828     0.200
     9.175   130.508     0.200
     9.252   131.828     0.200
     9.396   132.598     0.200
     9.417   132.895     0.200
     9.415   133.746     0.200
     9.498   133.918     0.200
     9.600   135.707     0.200
     9.573   135.805     0.200
     9.578   136.266     0.200
     9.688   136.387     0.200
     9.707   137.688     0.200
     9.806   138.008     0.200
     9.670   137.605     0.200
     9.670   138.516     0.200
    10.002   141.246     0.200
    10.279   145.078     0.200
    10.541   148.195     0.200
    10.697   151.035     0.200
    10.775   152.766     0.200
    11.038   155.488     0.200
    11.170   154.617     0.200
    11.114   157.727     0.200
    11.249   158.645     0.200
    11.388   159.238     0.200
    11.212   158.137     0.200
    11.212   159.715     0.200
    11.418   161.918     0.200
    11.417   160.516     0.200
    11.375   160.625     0.200
    11.498   160.309     0.200
    11.491   162.285     0.200
    11.722   163.305     0.200
    11.659   164.535     0.200
    11.643   164.746     0.200
    11.776   164.586     0.200
    11.872   166.227     0.200
    11.890   166.867     0.200
    12.553   174.535     0.200
    12.608   177.047     0.200
    13.922   194.047     0.200
    14.014   194.945     0.200
    14.046   196.168     0.200
    14.482   202.797     0.200
    15.592   215.227     0.200
    15.548   215.926     0.200
    16.142   222.516     0.200
    16.666   229.145     0.200
    17.770   244.055     0.200
     0.981    17.320     0.200
     1.102    18.941     0.200
     1.186    20.830     0.200
     1.236    21.770     0.200
     1.230    21.697     0.200
     1.402    22.990     0.200
     1.402    22.846     0.200
     1.310    23.281     0.200
     1.336    23.291     0.200
     1.378    24.180     0.200
     1.575    26.781     0.200
     1.574    26.561     0.200
     1.888    30.691     0.200
     1.985    32.121     0.200
     2.364    36.311     0.200
     2.364    36.131     0.200
     2.242    36.510     0.200
     2.242    36.631     0.200
     2.453    39.951     0.200
     2.745    43.121     0.200
     2.745    41.693     0.200
     2.659    42.541     0.200
     3.052    47.330     0.200
     3.130    47.752     0.200
     3.132    47.990     0.200
     3.049    47.990     0.200
     3.198    49.031     0.200
     3.250    49.740     0.200
     3.297    49.891     0.200
     3.380    50.340     0.200
     3.790    57.240     0.200
     3.790    55.906     0.200
     3.795    56.318     0.200
     3.797    56.891     0.200
     3.696    57.410     0.200
     3.739    58.150     0.200
     3.739    57.930     0.200
     3.769    58.051     0.200
     3.922    58.791     0.200
     3.926    58.840     0.200
     3.960    58.885     0.200
     3.988    60.230     0.200
     3.988    60.400     0.200
     3.879    59.410     0.200
     4.072    61.320     0.200
     4.074    61.150     0.200
     4.074    60.842     0.200
     4.118    60.031     0.200
     4.118    59.830     0.200
     4.133    62.031     0.200
     4.133    61.195     0.200
     4.310    64.311     0.200
     4.310    63.623     0.200
     4.378    65.000     0.200
     4.377    64.969     0.200
     4.238    64.141     0.200
     4.238    64.262     0.200
     4.298    65.211     0.200
     4.480    65.891     0.200
     4.387    66.291     0.200
     4.616    68.748     0.200
     4.732    68.330     0.200
     4.732    67.225     0.200
     4.732    68.156     0.200
     4.911    72.076     0.200
     4.938    72.086     0.200
     5.045    74.211     0.200
     5.045    73.949     0.200
     5.014    73.670     0.200
     5.014    73.494     0.200
     5.134    75.900     0.200
     5.299    76.758     0.200
     5.348    78.670     0.200
     5.260    78.211     0.200
     5.441    80.051     0.200
     5.441    80.221     0.200
     5.443    80.150     0.200
     5.448    80.404     0.200
     5.476    80.340     0.200
     5.449    80.910     0.200
     5.628    82.451     0.200
     5.628    81.891     0.200
     5.686    83.182     0.200
     5.734    83.930     0.200
     5.744    84.045     0.200
     5.865    85.311     0.200
     5.865    85.471     0.200
     5.865    84.996     0.200
     5.854    84.811     0.200
     5.965    87.090     0.200
     5.991    87.221     0.200
     5.991    87.680     0.200
     5.991    88.072     0.200
     6.022    87.920     0.200
     6.025    87.961     0.200
     6.261    91.000     0.200
     6.261    90.883     0.200
     6.287    93.061     0.200
     6.287    90.898     0.200
     6.350    91.141     0.200
     6.368    92.721     0.200
     6.368    92.602     0.200
     6.351    93.221     0.200
     6.351    92.545     0.200
     6.458    93.684     0.200
     6.420    93.430     0.200
     6.420    92.939     0.200
     6.482    93.480     0.200
     6.517    94.670     0.200
     6.517    95.131     0.200
     6.519    94.510     0.200
     6.519    95.090     0.200
     6.516    93.980     0.200
     6.612    95.930     0.200
     6.612    96.350     0.200
     6.641    94.330     0.200
     6.673    96.211     0.200
     6.673    95.982     0.200
     6.715    96.230     0.200
     6.718    96.287     0.200
     6.743    97.660     0.200
     6.743    98.053     0.200
     7.128   102.100     0.200
     7.239   105.051     0.200
     7.243   102.971     0.200
     7.278   104.457     0.200
     7.279   104.230     0.200
     7.279   104.621     0.200
     7.279   104.459     0.200
     7.282   105.570     0.200
     7.283   105.520     0.200
     7.306   105.520     0.200
     7.336   105.789     0.200
     7.332   106.008     0.200
     7.376   106.291     0.200
     7.391   106.080     0.200
     7.405   106.760     0.200
     7.414   105.711     0.200
     7.395   106.770     0.200
     7.395   106.480     0.200
     7.554   108.770     0.200
     7.551   108.852     0.200
     7.622   109.881     0.200
     7.622   109.443     0.200
     7.627   108.961     0.200
     7.709   110.832     0.200
     7.919   112.631     0.200
     7.968   113.641     0.200
     7.968   113.848     0.200
     8.001   114.871     0.200
     8.001   114.588     0.200
     7.988   114.141     0.200
     7.988   114.611     0.200
     8.105   116.240     0.200
     8.105   116.004     0.200
     8.192   116.551     0.200
     8.271   118.186     0.200
     8.320   118.352     0.200
     8.332   118.365     0.200
     8.369   119.305     0.200
     8.532   121.211     0.200
     8.532   121.330     0.200
     8.532   121.094     0.200
     8.557   122.020     0.200
     8.557   122.518     0.200
     8.640   122.002     0.200
     8.726   125.291     0.200
     8.726   125.168     0.200
     8.731   123.680     0.200
     8.782   124.670     0.200
     8.782   125.256     0.200
     8.797   124.980     0.200
     8.797   124.686     0.200
     8.813   124.551     0.200
     8.813   124.025     0.200
     8.877   126.641     0.200
     8.877   127.029     0.200
     8.987   126.230     0.200
     9.155   129.830     0.200
     9.184   129.830     0.200
     9.184   129.354     0.200
     9.182   129.650     0.200
     9.182   130.781     0.200
     9.163   130.941     0.200
     9.163   131.531     0.200
     9.323   132.018     0.200
     9.485   134.051     0.200
     9.485   133.707     0.200
     9.485   133.010     0.200
     9.543   135.811     0.200
     9.543   136.623     0.200
     9.570   135.201     0.200
     9.578   135.920     0.200
     9.578   136.330     0.200
     9.583   135.340     0.200
     9.630   134.395     0.200
     9.635   136.037     0.200
     9.649   135.996     0.200
     9.699   136.090     0.200
     9.699   135.707     0.200
     9.706   137.504     0.200
     9.811   138.910     0.200
     9.811   139.262     0.200
     9.882   139.201     0.200
     9.882   138.668     0.200
     9.916   139.451     0.200
     9.914   140.410     0.200
     9.914   140.568     0.200
    10.006   140.541     0.200
    10.043   142.480     0.200
    10.043   142.248     0.200
    10.091   143.221     0.200
    10.146   144.209     0.200
    10.175   142.201     0.200
    10.221   144.080     0.200
    10.228   143.559     0.200
    10.216   144.475     0.200
    10.433   146.131     0.200
    10.477   147.092     0.200
    10.463   148.178     0.200
    10.497   148.051     0.200
    10.493   149.068     0.200
    10.551   148.590     0.200
    10.615   150.643     0.200
    10.726   150.736     0.200
    10.727   149.998     0.200
    10.718   151.607     0.200
    10.693   151.904     0.200
    10.754   151.338     0.200
    10.821   153.131     0.200
    10.697   152.861     0.200
    10.697   153.430     0.200
    10.697   154.391     0.200
    10.887   153.721     0.200
    10.884   153.998     0.200
    10.901   153.391     0.200
    10.915   153.891     0.200
    10.974   155.389     0.200
    10.971   155.416     0.200
    10.974   156.391     0.200
    11.136   157.764     0.200
    11.198   157.670     0.200
    11.198   158.080     0.200
    11.290   158.855     0.200
    11.302   158.656     0.200
    11.302   159.170     0.200
    11.305   158.664     0.200
    11.312   160.541     0.200
    11.431   161.580     0.200
    11.431   160.631     0.200
    11.454   161.002     0.200
    11.498   161.188     0.200
    11.515   161.885     0.200
    11.579   162.746     0.200
    11.600   160.375     0.200
    11.583   162.943     0.200
    11.653   163.980     0.200
    11.710   163.648     0.200
    11.733   165.381     0.200
    11.733   164.760     0.200
    11.750   164.941     0.200
    11.797   164.830     0.200
    11.855   165.279     0.200
    11.848   166.883     0.200
    11.860   167.486     0.200
    11.895   165.779     0.200
    11.908   165.168     0.200
    12.025   168.768     0.200
    12.104   169.080     0.200
    12.123   169.660     0.200
    12.116   170.146     0.200
    12.171   171.967     0.200
    12.221   170.965     0.200
    12.362   173.197     0.200
    12.384   172.480     0.200
    12.418   176.691     0.200
    12.418   174.346     0.200
    12.492   175.990     0.200
    12.510   175.891     0.200
    12.546   175.756     0.200
    12.543   176.795     0.200
    12.554   176.279     0.200
    12.577   175.111     0.200
    12.610   176.654     0.200
    12.651   176.760     0.200
    12.994   181.285     0.200
    13.038   182.260     0.200
    13.058   182.166     0.200
    13.065   181.951     0.200
    13.159   183.578     0.200
    13.177   183.264     0.200
    13.266   185.256     0.200
    13.187   185.770     0.200
    13.340   187.766     0.200
    13.400   186.469     0.200
    13.567   189.281     0.200
    13.586   189.926     0.200
    13.658   190.031     0.200
    13.658   189.496     0.200
    13.661   191.074     0.200
    13.670   190.777     0.200
    13.662   194.381     0.200
    13.662   192.191     0.200
    13.679   191.650     0.200
    13.739   192.217     0.200
    13.773   194.162     0.200
    13.789   193.330     0.200
    13.846   193.887     0.200
    13.923   194.426     0.200
    14.007   195.463     0.200
    14.046   196.484     0.200
    14.101   195.734     0.200
    14.100   196.596     0.200
    14.100   197.926     0.200
    14.168   197.906     0.200
    14.176   197.529     0.200
    14.181   198.051     0.200
    14.192   197.920     0.200
    14.208   198.264     0.200
    14.223   198.402     0.200
    14.226   198.906     0.200
    14.285   200.371     0.200
    14.317   201.285     0.200
    14.387   200.826     0.200
    14.397   203.137     0.200
    14.538   204.023     0.200
    14.562   202.838     0.200
    14.599   204.729     0.200
    14.622   203.914     0.200
    14.637   205.473     0.200
    14.674   205.426     0.200
    14.707   205.691     0.200
    14.787   207.086     0.200
    14.848   206.955     0.200
    14.948   207.713     0.200
    14.976   209.305     0.200
    14.968   209.648     0.200
    15.039   210.230     0.200
    15.039   209.406     0.200
    15.046   210.199     0.200
    15.151   210.492     0.200
    15.160   210.805     0.200
    15.186   211.336     0.200
    15.281   212.930     0.200
    15.308   211.859     0.200
    15.342   212.359     0.200
    15.367   213.580     0.200
    15.515   215.043     0.200
    15.591   216.475     0.200
    15.580   216.293     0.200
    15.624   216.516     0.200
    15.698   217.379     0.200
    15.788   219.430     0.200
    15.677   217.449     0.200
    15.897   220.727     0.200
    15.910   221.307     0.200
    16.001   223.082     0.200
    16.246   223.660     0.200
    16.268   226.426     0.200
    16.304   224.820     0.200
    16.308   225.580     0.200
    16.363   226.629     0.200
    16.417   227.689     0.200
    16.433   226.941     0.200
    16.469   228.805     0.200
    16.469   227.600     0.200
    16.547   229.555     0.200
    16.700   230.270     0.200
    16.697   230.725     0.200
    16.815   232.734     0.200
    16.908   233.041     0.200
    17.141   236.449     0.200
    17.363   237.471     0.200
    17.535   241.088     0.200
    17.918   244.906     0.200
    17.918   245.143     0.200
    18.491   253.992     0.200
    18.781   258.580     0.200
    18.781   256.705     0.200
    18.959   260.229     0.200
    19.516   264.920     0.200
     1.176    22.822     0.200
     1.146    21.863     0.200
     1.146    22.043     0.200
     1.292    24.992     0.200
     1.894    31.973     0.200
     1.894    32.752     0.200
     2.053    35.162     0.200
     1.889    34.422     0.200
     2.867    47.592     0.200
     2.867    47.902     0.200
     2.911    49.893     0.200
     3.008    49.543     0.200
     3.016    49.703     0.200
     3.036    49.953     0.200
     3.342    51.582     0.200
     3.379    54.562     0.200
     3.478    56.002     0.200
     3.719    57.793     0.200
     3.531    56.783     0.200
     3.605    57.922     0.200
     4.880    73.602     0.200
     4.885    74.262     0.200
     4.947    74.482     0.200
     4.947    74.373     0.200
     4.937    74.943     0.200
     4.960    74.033     0.200
     5.144    76.062     0.200
     5.261    78.232     0.200
     5.480    82.322     0.200
     5.623    84.252     0.200
     5.765    84.381     0.200
     5.863    87.473     0.200
     6.072    89.312     0.200
     6.033    90.043     0.200
     6.255    92.463     0.200
     6.255    93.523     0.200
     6.246    93.572     0.200
     6.337    92.902     0.200
     6.378    93.773     0.200
     6.378    94.143     0.200
     6.463    95.523     0.200
     6.725    99.562     0.200
     6.850   101.352     0.200
     7.096   104.373     0.200
     7.311   106.932     0.200
     7.373   107.482     0.200
     7.651   111.143     0.200
     7.675   110.193     0.200
     7.991   116.773     0.200
     8.200   118.492     0.200
     8.306   120.393     0.200
     8.450   121.732     0.200
     8.471   121.713     0.200
     8.508   122.652     0.200
     8.587   127.582     0.200
     8.993   130.832     0.200
     8.977   130.363     0.200
     9.095   131.602     0.200
     9.229   132.383     0.200
     9.354   134.373     0.200
     9.554   136.773     0.200
     9.582   137.842     0.200
     9.668   138.623     0.200
     9.823   140.082     0.200
     9.850   139.932     0.200
     9.979   142.453     0.200
    10.024   142.113     0.200
    10.045   145.082     0.200
    10.221   144.762     0.200
    10.351   147.082     0.200
    10.516   149.893     0.200
    10.522   149.543     0.200
    10.605   150.293     0.200
    10.626   150.783     0.200
    10.670   151.842     0.200
    10.919   155.123     0.200
    10.946   155.773     0.200
    11.257   161.643     0.200
    11.491   162.912     0.200
    11.534   163.902     0.200
    11.585   164.783     0.200
    11.751   166.252     0.200
    12.056   170.852     0.200
    12.223   175.113     0.200
    12.326   175.822     0.200
    12.589   175.291     0.200
    12.781   181.412     0.200
    12.910   182.162     0.200
    13.384   190.412     0.200
    13.620   193.932     0.200
    14.196   200.062     0.200
    14.482   205.832     0.200
    15.194   214.152     0.200
    15.195   211.402     0.200
    15.244   214.932     0.200
    15.281   215.562     0.200
    15.413   217.053     0.200
    15.581   219.082     0.200
    15.863   222.033     0.200
    15.934   223.033     0.200
    16.009   224.363     0.200
    16.232   226.693     0.200
    16.299   228.432     0.200
    16.311   227.852     0.200
    16.393   228.363     0.200
    16.564   231.693     0.200
    16.616   232.373     0.200
    16.706   232.412     0.200
    16.807   233.773     0.200
    17.318   239.172     0.200
    17.337   240.293     0.200
    17.449   242.588     0.200
    17.690   244.002     0.200
    17.928   246.633     0.200
    19.592   268.787     0.200
     1.056    20.750     0.200
     1.056    20.930     0.200
     1.097    21.688     0.200
     1.098    21.578     0.200
     1.120    21.992     0.200
     1.133    22.406     0.200
     1.231    24.227     0.200
     1.281    24.281     0.200
     1.394    24.695     0.200
     1.464    26.109     0.200
     1.404    26.539     0.200
     1.916    34.086     0.200
     2.201    36.656     0.200
     2.277    37.719     0.200
     2.277    37.891     0.200
     2.357    38.812     0.200
     2.357    39.086     0.200
     2.735    43.242     0.200
     2.711    44.812     0.200
     3.059    49.008     0.200
     3.476    54.812     0.200
     3.386    54.695     0.200
     3.529    55.562     0.200
     3.757    57.086     0.200
     3.881    61.266     0.200
     4.331    65.930     0.200
     4.450    68.102     0.200
     4.495    66.625     0.200
     4.870    72.219     0.200
     5.107    75.258     0.200
     5.149    76.766     0.200
     5.188    77.758     0.200
     5.261    78.039     0.200
     5.323    79.102     0.200
     5.398    80.898     0.200
     5.667    83.516     0.200
     5.675    84.680     0.200
     5.835    87.195     0.200
     5.860    87.156     0.200
     5.893    87.227     0.200
     5.991    88.570     0.200
     6.210    91.727     0.200
     6.255    92.781     0.200
     6.362    93.648     0.200
     6.434    95.172     0.200
     6.644    98.078     0.200
     6.642    97.875     0.200
     6.678    98.828     0.200
     6.709    98.438     0.200
     6.879    99.969     0.200
     7.002   101.141     0.200
     7.357   106.758     0.200
     7.484   108.047     0.200
     7.639   108.898     0.200
     7.671   110.695     0.200
     7.746   111.148     0.200
     7.778   112.508     0.200
     7.837   112.609     0.200
     7.933   113.562     0.200
     7.935   114.375     0.200
     7.957   113.867     0.200
     8.112   116.836     0.200
     8.258   119.312     0.200
     8.319   119.320     0.200
     8.431   120.500     0.200
     8.454   121.570     0.200
     8.579   123.961     0.200
     8.680   124.656     0.200
     9.034   130.922     0.200
     9.078   129.828     0.200
     9.155   131.406     0.200
     9.677   138.539     0.200
     9.967   141.297     0.200
     9.998   141.492     0.200
    10.788   151.992     0.200
    10.867   153.672     0.200
     1.422    26.586     0.200
     1.672    29.492     0.200
     1.634    29.172     0.200
     1.831    31.711     0.200
     1.893    33.070     0.200
     3.021    47.875     0.200
     3.164    48.945     0.200
     3.169    50.750     0.200
     3.498    53.836     0.200
     3.502    55.516     0.200
     3.930    61.125     0.200
     4.677    71.219     0.200
     4.728    71.031     0.200
     4.741    71.500     0.200
     4.947    73.227     0.200
     5.262    78.180     0.200
     5.563    81.789     0.200
     5.659    84.227     0.200
     5.855    87.016     0.200
     6.072    90.211     0.200
     6.099    90.789     0.200
     6.127    91.727     0.200
     6.274    92.469     0.200
     6.292    92.930     0.200
     6.570    96.859     0.200
     6.583    97.797     0.200
     6.672    98.867     0.200
     6.912   101.117     0.200
     7.095   103.828     0.200
     7.110   105.016     0.200
     7.225   106.211     0.200
     7.268   107.445     0.200
     7.431   109.500     0.200
     7.713   113.711     0.200
     7.797   113.961     0.200
     7.983   116.617     0.200
     8.085   117.922     0.200
     8.203   120.352     0.200
     8.237   119.727     0.200
     8.250   120.516     0.200
     8.298   120.688     0.200
     8.366   121.875     0.200
     8.376   121.461     0.200
     8.401   122.859     0.200
     8.708   126.000     0.200
     8.778   126.680     0.200
     8.873   129.211     0.200
     8.927   128.836     0.200
     9.139   130.781     0.200
     9.184   132.242     0.200
     9.464   137.156     0.200
     9.532   136.938     0.200
     9.573   137.180     0.200
     9.614   137.797     0.200
     9.637   137.602     0.200
     9.813   139.320     0.200
     9.829   141.188     0.200
    10.134   144.375     0.200
    10.220   145.945     0.200
    10.340   148.359     0.200
    10.457   149.539     0.200
    10.715   153.930     0.200
    10.711   153.148     0.200
    10.729   153.258     0.200
    10.928   156.867     0.200
    11.045   158.219     0.200
    11.225   161.258     0.200
    11.281   160.492     0.200
    11.382   163.219     0.200
    11.533   164.461     0.200
    11.631   167.008     0.200
    11.812   167.977     0.200
    11.976   171.180     0.200
    12.112   172.805     0.200
    12.273   176.211     0.200
    12.367   175.195     0.200
    12.513   179.609     0.200
    12.581   179.469     0.200
    13.178   183.969     0.200
    13.976   196.602     0.200
    14.266   204.250     0.200
    14.383   203.500     0.200
    15.063   213.938     0.200
    15.955   225.172     0.200
    16.192   227.688     0.200
    16.486   230.836     0.200
    17.098   237.031     0.200
    17.120   237.266     0.200
    17.602   244.156     0.200
    17.708   245.391     0.200
     1.202    21.734     0.200
     1.202    21.623     0.200
     1.544    25.533     0.200
     1.516    25.623     0.200
     1.527    25.643     0.200
     1.673    29.104     0.200
     1.722    29.773     0.200
     1.769    30.533     0.200
     1.912    30.713     0.200
     1.912    31.023     0.200
     1.789    31.133     0.200
     1.808    31.193     0.200
     1.893    32.424     0.200
     2.100    33.443     0.200
     2.100    33.223     0.200
     2.114    34.023     0.200
     2.106    35.283     0.200
     2.758    42.383     0.200
     2.771    42.674     0.200
     2.825    43.283     0.200
     2.825    44.324     0.200
     2.791    43.324     0.200
     2.846    43.574     0.200
     2.867    43.713     0.200
     2.786    44.613     0.200
     2.786    46.424     0.200
     2.870    44.373     0.200
     3.009    46.033     0.200
     2.975    47.223     0.200
     3.171    48.424     0.200
     3.121    48.244     0.200
     3.244    49.604     0.200
     3.283    49.834     0.200
     3.344    50.934     0.200
     3.403    51.643     0.200
     3.403    51.424     0.200
     3.330    50.363     0.200
     3.637    55.223     0.200
     3.923    59.168     0.200
     3.923    58.783     0.200
     3.826    58.244     0.200
     3.874    58.604     0.200
     3.984    60.123     0.200
     4.134    61.963     0.200
     4.163    62.273     0.200
     4.163    63.363     0.200
     4.346    64.643     0.200
     4.440    66.443     0.200
     4.440    66.984     0.200
     4.668    68.963     0.200
     4.626    70.014     0.200
     4.704    69.283     0.200
     4.708    70.104     0.200
     4.894    72.264     0.200
     4.894    72.793     0.200
     4.955    73.033     0.200
     4.851    74.223     0.200
     5.140    76.123     0.200
     5.141    76.053     0.200
     5.172    76.193     0.200
     5.339    78.904     0.200
     5.331    78.684     0.200
     5.367    79.154     0.200
     5.386    79.473     0.200
     5.331    78.664     0.200
     5.397    79.033     0.200
     5.471    79.994     0.200
     5.471    81.033     0.200
     5.485    79.934     0.200
     5.485    80.193     0.200
     5.466    81.404     0.200
     5.842    84.623     0.200
     6.054    88.824     0.200
     6.060    88.863     0.200
     6.051    87.643     0.200
     6.087    89.014     0.200
     6.123    89.473     0.200
     6.093    89.574     0.200
     6.286    91.303     0.200
     6.267    92.344     0.200
     6.396    93.773     0.200
     6.449    94.244     0.200
     6.424    92.994     0.200
     6.915   100.984     0.200
     7.008   101.084     0.200
     7.493   109.094     0.200
     7.565   110.453     0.200
     7.614   109.883     0.200
     7.812   111.354     0.200
     7.897   113.414     0.200
     8.245   118.213     0.200
     8.245   117.223     0.200
     8.247   118.404     0.200
     8.267   118.844     0.200
     8.357   120.543     0.200
     8.497   121.812     0.200
     8.463   121.684     0.200
     8.523   122.463     0.200
     8.615   123.293     0.200
     8.719   124.062     0.200
     8.641   123.893     0.200
     9.000   129.062     0.200
     9.124   129.812     0.200
     9.483   134.514     0.200
     9.433   134.834     0.200
     9.549   135.812     0.200
     9.626   137.404     0.200
     9.653   136.994     0.200
     9.697   137.793     0.200
     9.761   140.084     0.200
     9.860   139.754     0.200
     9.928   141.453     0.200
     9.973   141.203     0.200
     9.974   141.963     0.200
     9.901   140.973     0.200
    10.038   143.143     0.200
    11.062   157.283     0.200
    12.202   172.693     0.200
    12.976   182.303     0.200
    13.050   183.424     0.200
    13.056   184.463     0.200
    15.841   221.373     0.200
    16.226   226.854     0.200
    16.758   232.648     0.200
     1.127    20.964     0.200
     1.244    23.134     0.200
     1.260    23.305     0.200
     1.251    23.044     0.200
     1.251    23.305     0.200
     1.308    23.584     0.200
     1.369    25.305     0.200
     1.649    28.314     0.200
     1.657    28.555     0.200
     1.733    30.314     0.200
     1.796    30.864     0.200
     1.822    31.634     0.200
     1.868    31.875     0.200
     1.865    32.375     0.200
     1.865    31.774     0.200
     1.847    31.665     0.200
     2.125    34.125     0.200
     2.050    35.805     0.200
     2.172    38.114     0.200
     2.241    38.495     0.200
     3.008    45.844     0.200
     3.177    51.285     0.200
     3.221    51.334     0.200
     3.320    53.294     0.200
     3.334    53.364     0.200
     3.348    53.354     0.200
     3.370    54.055     0.200
     3.776    57.314     0.200
     3.860    59.064     0.200
     3.697    57.705     0.200
     3.924    59.634     0.200
     3.795    59.044     0.200
     4.016    60.834     0.200
     4.059    60.594     0.200
     3.923    60.785     0.200
     4.453    66.625     0.200
     4.543    67.694     0.200
     4.593    68.564     0.200
     4.653    69.205     0.200
     4.657    69.515     0.200
     4.718    70.285     0.200
     4.722    70.935     0.200
     4.742    71.104     0.200
     4.818    70.364     0.200
     4.820    72.104     0.200
     4.701    71.785     0.200
     4.968    73.265     0.200
     5.138    75.864     0.200
     5.186    76.984     0.200
     5.273    78.004     0.200
     5.443    78.483     0.200
     5.443    78.364     0.200
     5.515    81.884     0.200
     5.592    82.214     0.200
     5.711    84.754     0.200
     5.777    83.964     0.200
     6.063    88.875     0.200
     6.296    91.375     0.200
     6.357    92.384     0.200
     6.605    96.754     0.200
     6.658    97.564     0.200
     7.079   101.375     0.200
     7.001   101.734     0.200
     7.079   102.834     0.200
     7.111   103.435     0.200
     7.209   104.875     0.200
     7.251   105.245     0.200
     7.270   105.435     0.200
     7.371   106.604     0.200
     7.823   113.625     0.200
     7.869   114.395     0.200
     7.995   115.734     0.200
     8.032   115.984     0.200
     8.075   117.064     0.200
     8.240   119.805     0.200
     8.334   121.354     0.200
     8.332   120.004     0.200
     8.838   126.935     0.200
     8.972   128.935     0.200
     9.435   134.824     0.200
     9.468   135.604     0.200
     9.507   134.864     0.200
     9.443   135.364     0.200
     9.842   139.875     0.200
     9.915   141.364     0.200
    10.054   142.574     0.200
    10.192   144.404     0.200
    10.221   146.685     0.200
    10.364   146.495     0.200
    10.498   149.584     0.200
    10.604   150.935     0.200
    10.904   154.424     0.200
    11.178   157.975     0.200
    11.218   158.915     0.200
    11.252   160.745     0.200
    11.427   161.895     0.200
    11.458   161.895     0.200
    11.511   163.245     0.200
    11.487   164.185     0.200
    11.733   165.584     0.200
    12.019   169.225     0.200
    12.013   170.924     0.200
    12.017   171.125     0.200
    12.193   172.714     0.200
    12.185   171.594     0.200
    12.322   169.814     0.200
    12.322   172.104     0.200
    12.436   176.495     0.200
    12.456   175.574     0.200
    12.461   176.944     0.200
    12.524   177.645     0.200
    12.556   177.824     0.200
    12.634   177.924     0.200
    12.808   180.614     0.200
    13.055   183.895     0.200
    13.110   187.424     0.200
    13.202   186.455     0.200
    13.288   187.654     0.200
    13.880   195.004     0.200
    14.231   200.964     0.200
    14.298   200.834     0.200
    14.276   199.915     0.200
    14.642   206.674     0.200
    14.897   209.875     0.200
    14.915   209.685     0.200
    14.907   209.794     0.200
    15.706   220.395     0.200
    15.832   221.584     0.200
    15.883   222.814     0.200
    15.890   222.785     0.200
    16.012   224.794     0.200
    16.029   223.884     0.200
    16.220   227.645     0.200
    16.427   229.824     0.200
    16.519   230.975     0.200
    17.034   237.185     0.200
     1.155    21.168     0.200
     1.155    20.227     0.200
     1.155    20.797     0.200
     1.215    21.168     0.200
     1.225    21.238     0.200
     1.225    21.426     0.200
     1.755    29.266     0.200
     1.755    28.539     0.200
     1.785    30.945     0.200
     1.826    31.398     0.200
     1.871    31.977     0.200
     2.054    32.828     0.200
     1.920    32.629     0.200
     1.951    32.695     0.200
     2.139    34.598     0.200
     2.139    35.086     0.200
     2.201    35.098     0.200
     2.299    36.598     0.200
     2.186    36.148     0.200
     2.612    40.867     0.200
     2.612    40.246     0.200
     2.612    40.477     0.200
     2.799    43.406     0.200
     2.940    45.176     0.200
     2.938    44.605     0.200
     2.938    45.426     0.200
     2.967    45.738     0.200
     2.999    46.309     0.200
     3.096    47.539     0.200
     3.096    47.707     0.200
     3.126    48.637     0.200
     3.253    49.277     0.200
     3.253    49.676     0.200
     3.272    49.766     0.200
     3.212    50.586     0.200
     3.300    50.789     0.200
     3.372    50.656     0.200
     3.372    51.348     0.200
     3.384    51.566     0.200
     3.253    52.047     0.200
     3.425    52.219     0.200
     3.490    53.258     0.200
     3.593    55.016     0.200
     3.593    55.637     0.200
     3.681    55.848     0.200
     3.681    56.086     0.200
     3.846    57.586     0.200
     3.939    58.938     0.200
     3.943    59.188     0.200
     4.065    60.926     0.200
     4.303    65.047     0.200
     4.352    64.586     0.200
     4.352    65.047     0.200
     4.295    64.848     0.200
     4.439    65.539     0.200
     4.439    66.707     0.200
     4.456    65.848     0.200
     4.456    67.066     0.200
     4.398    67.297     0.200
     4.398    67.887     0.200
     4.437    68.668     0.200
     4.437    68.387     0.200
     4.549    67.816     0.200
     4.549    68.227     0.200
     4.673    69.508     0.200
     4.565    69.508     0.200
     4.596    70.027     0.200
     4.867    72.867     0.200
     4.880    72.668     0.200
     4.984    73.816     0.200
     4.984    74.156     0.200
     5.028    73.828     0.200
     5.028    74.379     0.200
     5.094    75.246     0.200
     5.094    75.676     0.200
     4.953    74.668     0.200
     5.100    75.855     0.200
     5.031    75.617     0.200
     5.031    76.688     0.200
     5.118    76.457     0.200
     5.110    76.445     0.200
     5.098    76.598     0.200
     5.098    77.137     0.200
     5.270    77.379     0.200
     5.270    78.539     0.200
     5.315    77.926     0.200
     5.172    77.969     0.200
     5.388    80.176     0.200
     5.373    79.457     0.200
     5.486    81.469     0.200
     5.520    81.027     0.200
     5.554    81.355     0.200
     5.554    82.016     0.200
     5.720    84.027     0.200
     5.720    84.508     0.200
     5.770    84.816     0.200
     5.802    85.078     0.200
     5.802    85.316     0.200
     5.798    84.727     0.200
     5.798    85.188     0.200
     5.932    86.258     0.200
     6.219    90.707     0.200
     6.309    91.879     0.200
     6.387    92.746     0.200
     6.457    93.348     0.200
     6.571    95.668     0.200
     6.535    95.719     0.200
     6.489    95.797     0.200
     6.626    98.016     0.200
     6.747    98.336     0.200
     6.802    99.016     0.200
     6.985   100.867     0.200
     7.107   102.438     0.200
     7.430   107.379     0.200
     7.484   107.578     0.200
     7.545   109.758     0.200
     7.743   110.789     0.200
     7.759   111.789     0.200
     7.804   112.086     0.200
     7.853   112.129     0.200
     7.859   112.098     0.200
     7.970   114.629     0.200
     8.042   114.547     0.200
     8.034   115.695     0.200
     8.254   117.945     0.200
     8.229   118.227     0.200
     8.548   122.578     0.200
     8.587   123.988     0.200
     8.573   123.297     0.200
     8.651   125.727     0.200
     8.675   123.996     0.200
     8.709   124.246     0.200
     8.940   127.438     0.200
     9.048   129.938     0.200
     9.182   130.906     0.200
     9.247   131.977     0.200
     9.512   134.297     0.200
     9.564   135.777     0.200
     9.685   137.977     0.200
     9.767   139.508     0.200
     9.918   141.258     0.200
     9.904   141.227     0.200
     9.926   141.387     0.200
    10.046   141.977     0.200
    10.121   144.355     0.200
    10.304   145.336     0.200
    10.271   146.297     0.200
    10.311   145.477     0.200
    10.360   147.227     0.200
    10.464   149.309     0.200
    10.602   149.668     0.200
    10.599   150.938     0.200
    10.902   155.668     0.200
    10.943   156.219     0.200
    11.156   158.277     0.200
    11.239   160.637     0.200
    11.571   164.789     0.200
    11.589   165.668     0.200
    12.225   172.668     0.200
    12.595   177.988     0.200
    12.737   181.637     0.200
    14.304   201.496     0.200
     1.116    20.350     0.200
     1.148    20.631     0.200
     1.291    21.725     0.200
     1.797    30.221     0.200
     1.861    29.551     0.200
     1.861    30.660     0.200
     1.861    29.350     0.200
     1.965    33.260     0.200
     2.894    45.320     0.200
     2.917    44.250     0.200
     2.917    44.881     0.200
     2.917    43.979     0.200
     3.222    50.150     0.200
     3.575    53.971     0.200
     3.668    55.689     0.200
     3.689    54.449     0.200
     3.689    54.312     0.200
     3.814    57.449     0.200
     3.817    57.594     0.200
     4.038    61.529     0.200
     4.038    60.535     0.200
     4.131    61.412     0.200
     4.228    63.750     0.200
     4.228    63.400     0.200
     4.287    64.850     0.200
     4.287    64.990     0.200
     4.287    64.570     0.200
     4.326    63.020     0.200
     4.326    62.850     0.200
     4.326    63.150     0.200
     4.347    64.971     0.200
     4.347    64.766     0.200
     4.496    67.990     0.200
     4.496    67.176     0.200
     4.597    69.080     0.200
     4.597    68.211     0.200
     4.747    70.055     0.200
     4.782    70.750     0.200
     4.782    72.471     0.200
     4.782    70.291     0.200
     4.836    71.355     0.200
     4.874    72.250     0.200
     5.042    75.150     0.200
     5.178    76.436     0.200
     5.188    77.551     0.200
     5.201    76.949     0.200
     5.232    77.551     0.200
     5.470    79.947     0.200
     5.475    80.846     0.200
     5.575    81.578     0.200
     5.671    83.055     0.200
     5.717    84.150     0.200
     5.806    84.926     0.200
     5.821    85.350     0.200
     5.854    86.150     0.200
     5.856    85.598     0.200
     5.972    86.602     0.200
     5.988    88.051     0.200
     5.999    87.355     0.200
     6.027    88.400     0.200
     6.029    87.926     0.200
     6.205    90.602     0.200
     6.312    90.551     0.200
     6.348    90.984     0.200
     6.431    93.525     0.200
     6.651    96.350     0.200
     6.706    96.775     0.200
     6.731    97.250     0.200
     6.759    99.240     0.200
     6.759    97.691     0.200
     6.855    98.500     0.200
     6.886   100.920     0.200
     6.886   100.750     0.200
     6.886   100.475     0.200
     6.986   101.467     0.200
     7.045   104.779     0.200
     7.053   101.400     0.200
     7.070   100.377     0.200
     7.141   103.109     0.200
     7.233   103.186     0.200
     7.244   104.836     0.200
     7.291   104.939     0.200
     7.442   106.943     0.200
     7.449   107.934     0.200
     7.461   107.354     0.200
     7.633   109.760     0.200
     7.675   111.471     0.200
     7.675   109.311     0.200
     7.725   110.945     0.200
     7.808   110.631     0.200
     7.891   112.238     0.200
     7.963   112.512     0.200
     7.989   112.850     0.200
     8.075   114.982     0.200
     8.173   116.365     0.200
     8.247   117.551     0.200
     8.247   117.449     0.200
     8.247   116.523     0.200
     8.334   117.891     0.200
     8.359   119.191     0.200
     8.411   119.738     0.200
     8.462   119.066     0.200
     8.528   121.814     0.200
     8.543   121.730     0.200
     8.558   122.676     0.200
     8.567   121.471     0.200
     8.662   122.236     0.200
     8.675   123.330     0.200
     8.801   124.750     0.200
     8.801   123.988     0.200
     8.851   125.002     0.200
     8.964   128.012     0.200
     9.014   127.348     0.200
     9.054   128.820     0.200
     9.064   128.359     0.200
     9.128   129.990     0.200
     9.291   130.863     0.200
     9.379   131.389     0.200
     9.425   132.713     0.200
     9.439   134.744     0.200
     9.453   133.295     0.200
     9.455   134.650     0.200
     9.502   133.574     0.200
     9.598   135.426     0.200
     9.709   138.850     0.200
     9.709   138.260     0.200
     9.798   139.586     0.200
     9.826   140.146     0.200
     9.864   139.225     0.200
     9.911   138.801     0.200
     9.976   142.287     0.200
    10.013   140.396     0.200
    10.021   142.562     0.200
    10.030   140.982     0.200
    10.156   143.119     0.200
    10.167   145.650     0.200
    10.167   144.723     0.200
    10.171   145.244     0.200
    10.373   145.805     0.200
    10.373   147.480     0.200
    10.430   146.402     0.200
    10.570   150.406     0.200
    10.578   151.488     0.200
    10.598   150.840     0.200
    10.666   151.732     0.200
    10.704   151.479     0.200
    10.713   148.744     0.200
    10.769   151.105     0.200
    10.916   155.939     0.200
    10.933   153.805     0.200
    10.943   153.938     0.200
    11.006   154.250     0.200
    11.020   157.410     0.200
    11.020   156.580     0.200
    11.043   156.479     0.200
    11.054   155.711     0.200
    11.073   153.799     0.200
    11.134   158.379     0.200
    11.136   154.879     0.200
    11.161   159.350     0.200
    11.166   159.051     0.200
    11.174   156.178     0.200
    11.188   158.908     0.200
    11.193   157.338     0.200
    11.228   159.330     0.200
    11.230   155.449     0.200
    11.230   156.551     0.200
    11.230   154.850     0.200
    11.230   155.229     0.200
    11.230   155.738     0.200
    11.230   156.039     0.200
    11.248   159.551     0.200
    11.248   159.801     0.200
    11.248   158.119     0.200
    11.248   160.061     0.200
    11.252   159.609     0.200
    11.327   159.699     0.200
    11.350   159.131     0.200
    11.381   157.328     0.200
    11.381   157.750     0.200
    11.463   161.652     0.200
    11.526   163.391     0.200
    11.531   159.531     0.200
    11.533   164.949     0.200
    11.533   163.900     0.200
    11.533   163.576     0.200
    11.539   164.137     0.200
    11.610   161.945     0.200
    11.634   164.418     0.200
    11.636   165.771     0.200
    11.661   161.973     0.200
    11.705   162.635     0.200
    11.720   165.426     0.200
    11.767   164.625     0.200
    11.782   165.721     0.200
    11.785   166.699     0.200
    11.794   167.256     0.200
    11.864   168.484     0.200
    11.916   167.248     0.200
    12.044   166.689     0.200
    12.078   170.295     0.200
    12.143   170.371     0.200
    12.150   172.510     0.200
    12.208   173.961     0.200
    12.223   172.635     0.200
    12.240   173.754     0.200
    12.326   170.277     0.200
    12.485   176.666     0.200
    12.487   177.721     0.200
    12.501   178.480     0.200
    12.501   177.141     0.200
    12.581   176.971     0.200
    12.642   177.844     0.200
    12.670   177.311     0.200
    12.670   176.580     0.200
    12.775   179.000     0.200
    12.792   179.545     0.200
    12.810   177.248     0.200
    12.882   179.547     0.200
    12.905   183.199     0.200
    12.967   181.465     0.200
    12.981   182.051     0.200
    13.135   185.650     0.200
    13.135   183.949     0.200
    13.135   183.328     0.200
    13.220   184.918     0.200
    13.228   185.609     0.200
    13.238   187.330     0.200
    13.238   185.141     0.200
    13.242   187.330     0.200
    13.313   187.449     0.200
    13.335   188.992     0.200
    13.532   189.705     0.200
    13.529   190.963     0.200
    13.540   189.674     0.200
    13.583   190.395     0.200
    13.598   190.586     0.200
    13.641   192.232     0.200
    13.669   192.650     0.200
    13.675   193.270     0.200
    13.676   193.062     0.200
    13.743   193.279     0.200
    13.736   193.830     0.200
    13.775   193.389     0.200
    13.777   194.473     0.200
    13.818   193.750     0.200
    13.880   193.887     0.200
    13.891   193.551     0.200
    13.944   192.311     0.200
    14.146   198.488     0.200
    14.149   198.350     0.200
    14.297   200.100     0.200
    14.412   200.551     0.200
    14.437   201.994     0.200
    14.445   202.350     0.200
    14.459   201.535     0.200
    14.495   203.750     0.200
    14.495   203.119     0.200
    14.495   202.090     0.200
    14.495   202.783     0.200
    14.638   205.402     0.200
    14.688   205.988     0.200
    14.745   206.906     0.200
    14.768   206.316     0.200
    14.810   207.381     0.200
    14.810   207.688     0.200
    14.818   208.346     0.200
    14.882   205.727     0.200
    14.961   208.729     0.200
    15.062   210.166     0.200
    15.287   213.080     0.200
    15.367   213.492     0.200
    15.388   215.531     0.200
    15.501   214.172     0.200
    15.519   217.340     0.200
    15.551   215.891     0.200
    15.911   222.559     0.200
    15.951   223.553     0.200
    15.969   223.439     0.200
    15.990   221.914     0.200
    16.029   220.801     0.200
    16.126   222.816     0.200
    16.161   225.840     0.200
    16.244   224.295     0.200
    16.244   226.051     0.200
    16.244   225.650     0.200
    16.244   224.410     0.200
    16.347   228.250     0.200
    16.392   226.062     0.200
    16.552   229.850     0.200
    16.618   228.359     0.200
    17.082   233.852     0.200
    17.656   241.375     0.200
    17.656   240.279     0.200
    19.044   261.527     0.200
     1.034    18.336     0.200
     1.188    19.676     0.200
     1.144    20.596     0.200
     1.231    22.307     0.200
     1.308    23.236     0.200
     1.308    23.596     0.200
     1.694    28.596     0.200
     1.796    28.336     0.200
     1.818    29.537     0.200
     1.924    31.947     0.200
     1.920    32.127     0.200
     2.143    35.137     0.200
     2.842    43.357     0.200
     3.044    48.656     0.200
     3.567    53.287     0.200
     3.607    52.736     0.200
     3.935    58.676     0.200
     4.131    61.576     0.200
     4.241    61.215     0.200
     4.241    61.766     0.200
     4.242    63.207     0.200
     4.407    65.607     0.200
     4.328    65.816     0.200
     4.494    65.936     0.200
     4.469    68.297     0.200
     4.826    71.596     0.200
     5.074    74.346     0.200
     5.111    74.936     0.200
     5.135    75.746     0.200
     5.567    81.057     0.200
     5.672    82.447     0.200
     5.923    85.146     0.200
     5.904    86.316     0.200
     6.139    88.766     0.200
     6.327    91.766     0.200
     6.974   101.717     0.200
     6.869   100.246     0.200
     7.187   102.447     0.200
     7.301   104.156     0.200
     7.337   105.766     0.200
     7.578   109.646     0.200
     7.788   111.656     0.200
     8.149   115.846     0.200
     8.261   118.326     0.200
     8.424   120.297     0.200
     8.531   119.807     0.200
     8.982   127.906     0.200
     9.350   131.717     0.200
     9.350   133.867     0.200
     9.661   135.816     0.200
     9.993   141.877     0.200
    10.026   141.986     0.200
    10.069   143.266     0.200
    10.333   145.426     0.200
    10.494   148.447     0.200
    10.526   148.256     0.200
    10.814   153.256     0.200
    11.075   156.277     0.200
    11.040   157.047     0.200
    11.147   156.727     0.200
    11.279   154.486     0.200
    11.287   161.756     0.200
    11.560   160.787     0.200
    11.689   165.746     0.200
    11.839   167.396     0.200
    12.225   170.117     0.200
    12.688   177.957     0.200
    13.427   189.996     0.200
    13.674   193.207     0.200
    15.868   222.227     0.200
    15.931   221.816     0.200
    17.557   239.672     0.200
     0.353     8.725     0.200
     0.353     8.080     0.200
     0.363     8.234     0.200
     0.653    13.424     0.200
     0.653    13.693     0.200
     0.653    13.584     0.200
     0.917    16.773     0.200
     0.980    17.363     0.200
     1.068    19.184     0.200
     1.129    20.924     0.200
     1.129    20.863     0.200
     1.266    21.064     0.200
     1.266    20.789     0.200
     1.373    23.645     0.200
     1.423    24.033     0.200
     1.524    25.713     0.200
     1.519    26.055     0.200
     2.241    34.623     0.200
     2.241    34.094     0.200
     2.241    33.957     0.200
     2.991    45.906     0.200
     3.249    48.424     0.200
     3.249    48.264     0.200
     3.658    54.539     0.200
     3.787    56.863     0.200
     3.828    57.123     0.200
     3.851    57.824     0.200
     3.851    59.123     0.200
     3.953    59.154     0.200
     3.983    57.824     0.200
     4.032    60.113     0.200
     4.227    63.043     0.200
     4.227    62.434     0.200
     4.238    62.824     0.200
     4.349    64.504     0.200
     4.349    64.363     0.200
     4.354    65.324     0.200
     4.498    66.494     0.200
     4.498    66.148     0.200
     4.595    65.693     0.200
     4.595    66.324     0.200
     4.595    66.070     0.200
     4.785    70.326     0.200
     4.802    70.674     0.200
     4.932    72.734     0.200
     5.034    74.354     0.200
     5.034    74.225     0.200
     5.214    76.385     0.200
     5.214    76.119     0.200
     5.337    77.781     0.200
     5.506    80.043     0.200
     5.506    79.924     0.200
     5.591    81.398     0.200
     5.595    81.844     0.200
     5.676    83.498     0.200
     5.730    83.658     0.200
     5.770    83.924     0.200
     5.837    84.822     0.200
     5.881    85.824     0.200
     5.881    85.674     0.200
     5.883    85.395     0.200
     6.122    88.865     0.200
     6.147    89.748     0.200
     6.209    89.334     0.200
     6.235    90.949     0.200
     6.340    91.986     0.200
     6.378    92.363     0.200
     6.394    93.084     0.200
     6.436    93.049     0.200
     6.545    93.865     0.200
     6.568    94.549     0.200
     6.616    95.771     0.200
     6.627    94.693     0.200
     6.626    98.135     0.200
     7.016   100.684     0.200
     7.120   102.025     0.200
     7.142   102.480     0.200
     7.215   103.283     0.200
     7.239   104.049     0.200
     7.274   103.201     0.200
     7.326   105.447     0.200
     7.414   106.260     0.200
     7.423   106.512     0.200
     7.488   108.369     0.200
     7.597   108.799     0.200
     7.829   111.416     0.200
     7.907   112.688     0.200
     7.969   112.727     0.200
     8.053   113.598     0.200
     8.171   116.264     0.200
     8.180   115.631     0.200
     8.194   115.773     0.200
     8.248   115.500     0.200
     8.261   116.916     0.200
     8.393   117.924     0.200
     8.393   117.264     0.200
     8.439   119.520     0.200
     8.500   119.637     0.200
     8.593   123.248     0.200
     8.621   121.551     0.200
     8.654   122.467     0.200
     8.660   121.643     0.200
     8.673   122.119     0.200
     8.777   124.732     0.200
     8.815   122.879     0.200
     9.015   126.123     0.200
     9.045   127.023     0.200
     9.045   126.832     0.200
     9.061   129.123     0.200
     9.078   129.293     0.200
     9.183   129.332     0.200
     9.275   132.725     0.200
     9.348   131.867     0.200
     9.418   133.145     0.200
     9.432   132.135     0.200
     9.448   134.160     0.200
     9.492   132.092     0.200
     9.495   133.512     0.200
     9.514   133.520     0.200
     9.560   132.572     0.200
     9.612   136.648     0.200
     9.696   137.252     0.200
     9.743   136.273     0.200
     9.743   136.432     0.200
     9.776   136.898     0.200
     9.810   139.311     0.200
     9.895   140.424     0.200
     9.895   140.111     0.200
     9.968   141.158     0.200
    10.036   139.312     0.200
    10.036   142.191     0.200
    10.081   141.139     0.200
    10.092   140.371     0.200
    10.130   143.018     0.200
    10.295   144.094     0.200
    10.337   145.773     0.200
    10.358   145.023     0.200
    10.392   147.148     0.200
    10.368   148.533     0.200
    10.499   148.248     0.200
    10.587   147.994     0.200
    10.597   149.623     0.200
    10.615   149.287     0.200
    10.648   150.975     0.200
    10.648   149.979     0.200
    10.693   151.045     0.200
    10.767   148.977     0.200
    10.775   152.070     0.200
    10.784   150.812     0.200
    10.806   153.623     0.200
    10.806   153.424     0.200
    10.889   154.324     0.200
    10.893   154.102     0.200
    11.010   155.123     0.200
    11.059   154.617     0.200
    11.075   156.199     0.200
    11.150   156.662     0.200
    11.165   153.451     0.200
    11.172   155.123     0.200
    11.187   157.623     0.200
    11.198   157.793     0.200
    11.240   159.324     0.200
    11.240   159.221     0.200
    11.296   156.725     0.200
    11.296   158.123     0.200
    11.296   157.205     0.200
    11.296   155.635     0.200
    11.315   157.594     0.200
    11.354   160.244     0.200
    11.354   160.354     0.200
    11.363   158.834     0.200
    11.363   159.412     0.200
    11.375   159.709     0.200
    11.451   161.324     0.200
    11.478   161.939     0.200
    11.491   161.523     0.200
    11.570   162.094     0.200
    11.598   160.490     0.200
    11.613   162.838     0.200
    11.724   162.867     0.200
    11.737   165.551     0.200
    11.738   165.080     0.200
    11.755   162.711     0.200
    11.770   162.123     0.200
    11.886   166.510     0.200
    11.964   166.873     0.200
    11.982   166.764     0.200
    11.993   168.273     0.200
    12.010   168.369     0.200
    12.018   169.773     0.200
    12.055   169.900     0.200
    12.087   166.760     0.200
    12.227   171.248     0.200
    12.316   174.449     0.200
    12.352   172.172     0.200
    12.380   175.273     0.200
    12.422   175.244     0.200
    12.425   174.463     0.200
    12.425   172.830     0.200
    12.477   174.387     0.200
    12.515   175.176     0.200
    12.518   176.021     0.200
    12.701   179.043     0.200
    12.846   180.443     0.200
    12.880   179.361     0.200
    12.964   181.213     0.200
    13.020   181.664     0.200
    13.043   184.906     0.200
    13.052   181.398     0.200
    13.134   183.652     0.200
    13.226   186.748     0.200
    13.263   184.666     0.200
    13.338   187.369     0.200
    13.292   186.385     0.200
    13.394   187.891     0.200
    13.427   186.514     0.200
    13.427   186.803     0.200
    13.447   189.975     0.200
    13.447   187.445     0.200
    13.476   190.850     0.200
    13.535   188.717     0.200
    13.561   189.922     0.200
    13.561   190.850     0.200
    13.538   188.324     0.200
    13.538   189.123     0.200
    13.538   187.289     0.200
    13.660   190.615     0.200
    13.658   191.225     0.200
    13.658   190.891     0.200
    13.784   192.174     0.200
    13.871   193.236     0.200
    13.934   193.297     0.200
    13.995   195.271     0.200
    13.974   195.234     0.200
    14.028   194.662     0.200
    14.037   192.748     0.200
    14.054   192.998     0.200
    14.045   196.924     0.200
    14.068   195.074     0.200
    14.089   196.121     0.200
    14.202   197.848     0.200
    14.262   198.545     0.200
    14.414   200.393     0.200
    14.425   198.553     0.200
    14.465   199.748     0.200
    14.505   199.957     0.200
    14.491   201.631     0.200
    14.672   203.777     0.200
    14.710   204.516     0.200
    14.842   206.084     0.200
    14.836   206.047     0.200
    14.832   206.105     0.200
    14.935   207.436     0.200
    14.926   209.324     0.200
    14.926   207.275     0.200
    15.021   206.449     0.200
    15.018   208.688     0.200
    15.051   209.859     0.200
    15.118   210.725     0.200
    15.141   209.225     0.200
    15.179   211.846     0.200
    15.245   210.549     0.200
    15.224   213.113     0.200
    15.224   211.105     0.200
    15.386   212.750     0.200
    15.463   213.312     0.200
    15.649   215.395     0.200
    15.772   219.783     0.200
    15.798   219.584     0.200
    15.765   218.824     0.200
    15.838   219.703     0.200
    15.871   220.766     0.200
    16.018   220.342     0.200
    16.166   220.783     0.200
    16.168   221.830     0.200
    16.146   224.174     0.200
    16.225   225.182     0.200
    16.267   223.617     0.200
    16.282   223.123     0.200
    16.313   224.498     0.200
    16.343   224.010     0.200
    17.006   234.781     0.200
    17.224   234.504     0.200
    17.780   242.248     0.200
    17.780   240.924     0.200
    17.780   241.475     0.200
    18.361   252.225     0.200
    18.681   255.299     0.200
    18.681   255.764     0.200
    18.681   256.793     0.200
    19.384   263.033     0.200
     1.188    21.250     0.200
     1.129    20.328     0.200
     1.129    19.879     0.200
     1.129    20.027     0.200
     1.396    23.039     0.200
     1.396    23.301     0.200
     1.463    25.777     0.200
     1.463    25.629     0.200
     1.463    25.848     0.200
     1.960    30.129     0.200
     1.960    29.898     0.200
     1.960    30.027     0.200
     1.903    31.598     0.200
     1.838    30.777     0.200
     1.858    30.750     0.200
     1.884    31.617     0.200
     2.031    32.969     0.200
     1.983    33.160     0.200
     2.080    34.230     0.200
     2.093    34.109     0.200
     2.974    46.309     0.200
     3.022    45.129     0.200
     3.010    46.676     0.200
     3.111    47.770     0.200
     2.958    47.367     0.200
     3.245    50.398     0.200
     3.085    48.590     0.200
     3.095    48.848     0.200
     3.162    50.219     0.200
     3.691    55.012     0.200
     3.729    56.270     0.200
     3.797    55.629     0.200
     3.797    54.957     0.200
     3.797    55.117     0.200
     3.784    57.289     0.200
     3.847    57.988     0.200
     3.930    59.219     0.200
     3.930    59.609     0.200
     3.930    59.898     0.200
     4.143    61.980     0.200
     4.143    61.805     0.200
     4.247    62.969     0.200
     4.247    62.598     0.200
     4.319    63.789     0.200
     4.319    63.938     0.200
     4.216    64.629     0.200
     4.437    63.547     0.200
     4.437    63.789     0.200
     4.246    64.141     0.200
     4.459    66.289     0.200
     4.459    65.969     0.200
     4.315    64.980     0.200
     4.316    65.801     0.200
     4.327    65.938     0.200
     4.360    66.848     0.200
     4.575    67.910     0.200
     4.575    67.680     0.200
     4.701    69.320     0.200
     4.701    68.988     0.200
     4.861    72.277     0.200
     4.707    70.430     0.200
     4.707    70.117     0.200
     4.944    72.801     0.200
     4.944    72.379     0.200
     4.800    71.551     0.200
     4.932    74.070     0.200
     5.292    76.379     0.200
     5.280    77.719     0.200
     5.280    77.488     0.200
     5.324    78.469     0.200
     5.324    78.207     0.200
     5.575    81.453     0.200
     5.682    82.320     0.200
     5.896    85.652     0.200
     5.967    86.898     0.200
     6.132    87.551     0.200
     6.058    88.777     0.200
     6.058    88.602     0.200
     6.127    89.410     0.200
     6.127    89.207     0.200
     6.111    88.750     0.200
     6.111    88.875     0.200
     6.319    91.480     0.200
     6.536    94.520     0.200
     6.762    97.934     0.200
     6.786    97.590     0.200
     6.786    97.832     0.200
     6.829    98.500     0.200
     6.829    98.273     0.200
     6.811    98.750     0.200
     6.811    98.852     0.200
     6.943    99.398     0.200
     6.874   100.328     0.200
     6.874   100.469     0.200
     7.184   102.457     0.200
     7.198   103.590     0.200
     7.243   103.812     0.200
     7.398   105.660     0.200
     7.398   105.922     0.200
     7.553   109.559     0.200
     7.550   108.840     0.200
     7.550   108.703     0.200
     7.705   111.039     0.200
     7.705   110.898     0.200
     7.827   112.078     0.200
     7.827   111.875     0.200
     8.104   115.199     0.200
     8.254   117.160     0.200
     8.254   118.160     0.200
     8.518   120.699     0.200
     8.453   120.590     0.200
     8.510   121.109     0.200
     8.510   121.340     0.200
     8.576   120.840     0.200
     8.634   123.430     0.200
     8.734   122.699     0.200
     8.778   124.500     0.200
     8.787   126.410     0.200
     8.913   125.758     0.200
     9.058   129.090     0.200
     9.058   128.973     0.200
     9.129   129.500     0.200
     9.172   130.078     0.200
     9.168   131.078     0.200
     9.279   130.898     0.200
     9.236   131.039     0.200
     9.405   132.918     0.200
     9.519   134.469     0.200
     9.569   135.910     0.200
     9.613   135.250     0.200
     9.704   136.660     0.200
     9.635   138.629     0.200
     9.635   138.301     0.200
    10.027   141.289     0.200
    10.074   143.059     0.200
    10.195   143.559     0.200
    10.225   144.309     0.200
    10.272   145.367     0.200
    10.247   145.578     0.200
    10.546   148.688     0.200
    10.717   150.398     0.200
    10.703   151.340     0.200
    11.049   155.527     0.200
    11.167   156.059     0.200
    11.290   158.238     0.200
    11.292   159.129     0.200
    11.176   160.027     0.200
    11.361   160.438     0.200
    11.497   161.480     0.200
    11.497   159.281     0.200
    11.497   161.480     0.200
    11.777   164.957     0.200
    11.881   166.449     0.200
    11.899   167.488     0.200
    12.245   171.988     0.200
    12.442   174.500     0.200
    12.762   177.629     0.200
    12.887   180.660     0.200
    12.926   180.500     0.200
    13.089   182.301     0.200
    13.932   194.809     0.200
    14.007   196.098     0.200
    14.446   201.980     0.200
    14.569   203.730     0.200
    14.789   205.688     0.200
    15.511   215.848     0.200
    15.502   214.957     0.200
    16.063   224.105     0.200
    16.060   222.738     0.200
    16.105   224.250     0.200
    16.145   224.258     0.200
    16.588   230.449     0.200
    16.734   231.629     0.200
    17.773   243.527     0.200
    17.773   243.180     0.200
     0.513    10.539     0.200
     0.519    10.781     0.200
     0.984    17.949     0.200
     0.976    17.191     0.200
     0.976    17.500     0.200
     1.185    21.410     0.200
     1.229    20.512     0.200
     1.258    22.816     0.200
     1.258    22.789     0.200
     1.510    25.301     0.200
     1.736    28.430     0.200
     1.698    28.219     0.200
     1.792    29.309     0.200
     1.743    28.789     0.200
     1.751    29.078     0.200
     1.833    30.180     0.200
     1.905    30.551     0.200
     1.967    29.879     0.200
     1.967    30.305     0.200
     1.966    32.109     0.200
     1.983    32.148     0.200
     2.838    43.570     0.200
     2.888    44.695     0.200
     3.004    45.590     0.200
     3.004    44.500     0.200
     3.102    47.449     0.200
     3.565    53.125     0.200
     3.613    54.078     0.200
     3.657    53.988     0.200
     3.671    54.680     0.200
     3.734    55.738     0.200
     3.760    54.891     0.200
     3.760    54.469     0.200
     3.782    56.418     0.200
     3.821    57.141     0.200
     3.972    58.109     0.200
     3.971    59.359     0.200
     4.094    60.090     0.200
     4.131    60.840     0.200
     4.125    61.211     0.200
     4.125    61.102     0.200
     4.139    60.969     0.200
     4.149    62.789     0.200
     4.149    62.621     0.200
     4.310    63.852     0.200
     4.310    63.500     0.200
     4.290    64.430     0.200
     4.372    64.871     0.200
     4.372    64.660     0.200
     4.388    62.910     0.200
     4.388    63.102     0.200
     4.388    63.352     0.200
     4.526    66.500     0.200
     4.647    68.391     0.200
     4.647    68.852     0.200
     4.647    68.715     0.200
     4.728    69.219     0.200
     4.781    69.988     0.200
     4.906    72.398     0.200
     5.077    74.898     0.200
     5.077    74.520     0.200
     5.130    76.031     0.200
     5.130    75.277     0.200
     5.154    74.750     0.200
     5.154    75.438     0.200
     5.392    78.891     0.200
     5.478    80.137     0.200
     5.515    80.238     0.200
     5.515    79.977     0.200
     5.655    81.719     0.200
     5.655    81.891     0.200
     5.699    82.668     0.200
     5.776    83.980     0.200
     5.775    83.301     0.200
     5.813    83.711     0.200
     5.813    84.355     0.200
     5.839    84.629     0.200
     5.852    85.691     0.200
     5.909    85.820     0.200
     5.942    86.250     0.200
     5.942    86.359     0.200
     6.007    87.902     0.200
     6.179    89.359     0.200
     6.179    89.809     0.200
     6.241    90.012     0.200
     6.318    91.480     0.200
     6.345    90.609     0.200
     6.364    91.898     0.200
     6.364    91.738     0.200
     6.583    94.359     0.200
     6.583    94.508     0.200
     6.604    95.512     0.200
     6.605    95.500     0.200
     6.641    95.320     0.200
     6.641    95.141     0.200
     6.745    96.199     0.200
     6.712    97.289     0.200
     6.712    97.719     0.200
     6.712    97.426     0.200
     7.049   100.320     0.200
     7.063   101.027     0.200
     7.073   100.961     0.200
     7.108   101.270     0.200
     7.109   100.930     0.200
     7.109   101.109     0.200
     7.229   103.531     0.200
     7.263   103.574     0.200
     7.353   105.520     0.200
     7.400   105.988     0.200
     7.400   105.371     0.200
     7.427   107.320     0.200
     7.427   106.668     0.200
     7.499   108.070     0.200
     7.499   107.516     0.200
     7.647   109.320     0.200
     7.647   109.137     0.200
     7.695   110.281     0.200
     7.863   111.418     0.200
     7.883   112.262     0.200
     7.883   112.125     0.200
     8.023   112.621     0.200
     8.023   113.609     0.200
     8.034   113.352     0.200
     8.051   114.750     0.200
     8.082   114.199     0.200
     8.264   117.320     0.200
     8.262   118.160     0.200
     8.262   117.641     0.200
     8.326   117.949     0.200
     8.326   118.086     0.200
     8.359   118.559     0.200
     8.359   118.801     0.200
     8.459   118.980     0.200
     8.462   120.621     0.200
     8.462   120.188     0.200
     8.504   119.887     0.200
     8.535   121.715     0.200
     8.536   120.680     0.200
     8.536   121.383     0.200
     8.565   121.207     0.200
     8.633   122.484     0.200
     8.669   121.270     0.200
     8.683   123.309     0.200
     8.683   123.020     0.200
     8.856   124.988     0.200
     8.856   124.301     0.200
     8.856   124.684     0.200
     8.867   126.551     0.200
     8.867   125.695     0.200
     8.875   125.781     0.200
     9.027   128.031     0.200
     9.040   127.809     0.200
     9.070   128.859     0.200
     9.070   128.742     0.200
     9.135   129.199     0.200
     9.135   128.758     0.200
     9.171   129.109     0.200
     9.330   131.809     0.200
     9.330   131.562     0.200
     9.384   132.199     0.200
     9.385   132.219     0.200
     9.408   133.238     0.200
     9.408   132.785     0.200
     9.440   133.027     0.200
     9.439   132.527     0.200
     9.555   134.695     0.200
     9.628   136.113     0.200
     9.573   136.090     0.200
     9.661   135.531     0.200
     9.721   137.770     0.200
     9.729   137.605     0.200
     9.886   140.398     0.200
     9.886   139.859     0.200
     9.908   139.793     0.200
     9.921   138.480     0.200
     9.921   139.637     0.200
     9.968   140.570     0.200
    10.006   139.730     0.200
    10.044   142.391     0.200
    10.044   142.559     0.200
    10.044   142.137     0.200
    10.093   141.496     0.200
    10.091   142.293     0.200
    10.133   142.000     0.200
    10.169   143.309     0.200
    10.187   143.309     0.200
    10.210   143.469     0.200
    10.259   145.117     0.200
    10.427   146.371     0.200
    10.452   147.512     0.200
    10.452   146.996     0.200
    10.477   148.043     0.200
    10.530   148.660     0.200
    10.608   149.777     0.200
    10.666   150.328     0.200
    10.676   150.270     0.200
    10.698   149.371     0.200
    10.740   150.930     0.200
    10.740   150.637     0.200
    10.834   152.488     0.200
    10.857   152.301     0.200
    10.869   153.051     0.200
    10.944   154.398     0.200
    10.944   153.852     0.200
    10.998   154.680     0.200
    11.019   154.801     0.200
    11.037   156.289     0.200
    11.043   155.680     0.200
    11.071   153.031     0.200
    11.115   155.133     0.200
    11.116   156.039     0.200
    11.116   156.574     0.200
    11.135   156.258     0.200
    11.108   156.891     0.200
    11.190   157.578     0.200
    11.190   156.969     0.200
    11.199   158.012     0.200
    11.219   156.988     0.200
    11.219   154.898     0.200
    11.225   157.859     0.200
    11.376   156.141     0.200
    11.376   156.590     0.200
    11.396   159.848     0.200
    11.399   160.238     0.200
    11.399   159.617     0.200
    11.405   160.141     0.200
    11.425   160.301     0.200
    11.425   159.984     0.200
    11.443   161.809     0.200
    11.443   160.938     0.200
    11.386   161.059     0.200
    11.521   160.914     0.200
    11.549   161.754     0.200
    11.628   161.809     0.200
    11.628   162.113     0.200
    11.665   161.609     0.200
    11.665   161.984     0.200
    11.677   163.559     0.200
    11.677   163.746     0.200
    11.692   164.148     0.200
    11.741   165.051     0.200
    11.787   165.770     0.200
    11.787   166.129     0.200
    11.804   165.168     0.200
    11.804   165.336     0.200
    11.822   163.430     0.200
    11.998   168.328     0.200
    11.998   167.902     0.200
    12.025   168.598     0.200
    12.084   169.672     0.200
    12.111   170.293     0.200
    12.145   170.645     0.200
    12.235   171.102     0.200
    12.298   172.199     0.200
    12.297   172.172     0.200
    12.309   172.980     0.200
    12.322   171.312     0.200
    12.395   173.102     0.200
    12.396   174.988     0.200
    12.396   174.699     0.200
    12.426   174.613     0.200
    12.429   174.520     0.200
    12.429   174.145     0.200
    12.658   177.336     0.200
    12.729   178.520     0.200
    12.782   178.750     0.200
    12.782   178.531     0.200
    12.803   179.852     0.200
    12.818   178.391     0.200
    12.831   179.512     0.200
    12.831   178.812     0.200
    12.843   179.117     0.200
    12.852   178.602     0.200
    12.852   179.977     0.200
    12.886   180.527     0.200
    13.051   182.750     0.200
    13.074   183.234     0.200
    13.142   184.105     0.200
    13.198   184.660     0.200
    13.265   185.656     0.200
    13.256   183.191     0.200
    13.256   184.879     0.200
    13.269   185.590     0.200
    13.269   185.094     0.200
    13.272   185.820     0.200
    13.272   184.996     0.200
    13.308   186.539     0.200
    13.308   185.500     0.200
    13.409   189.590     0.200
    13.409   187.281     0.200
    13.409   186.957     0.200
    13.450   188.051     0.200
    13.486   187.934     0.200
    13.491   187.852     0.200
    13.566   189.211     0.200
    13.580   189.852     0.200
    13.576   189.602     0.200
    13.591   190.074     0.200
    13.644   190.773     0.200
    13.656   190.938     0.200
    13.657   190.910     0.200
    13.599   189.590     0.200
    13.699   191.570     0.200
    13.704   191.551     0.200
    13.707   191.770     0.200
    13.861   193.137     0.200
    13.858   194.469     0.200
    13.858   193.766     0.200
    13.888   193.582     0.200
    13.910   193.812     0.200
    13.949   194.637     0.200
    13.991   194.086     0.200
    14.063   195.711     0.200
    14.231   198.559     0.200
    14.246   198.590     0.200
    14.242   198.121     0.200
    14.330   199.461     0.200
    14.399   200.551     0.200
    14.410   201.156     0.200
    14.454   201.516     0.200
    14.504   202.055     0.200
    14.540   202.270     0.200
    14.540   202.598     0.200
    14.629   204.023     0.200
    14.676   204.059     0.200
    14.676   204.527     0.200
    14.702   204.602     0.200
    14.702   204.922     0.200
    14.778   206.074     0.200
    14.826   206.441     0.200
    14.825   205.938     0.200
    14.898   207.242     0.200
    14.921   207.094     0.200
    14.936   207.758     0.200
    14.985   207.840     0.200
    14.992   208.859     0.200
    14.992   208.469     0.200
    15.197   210.211     0.200
    15.246   210.859     0.200
    15.354   212.430     0.200
    15.380   212.125     0.200
    15.394   213.035     0.200
    15.446   213.418     0.200
    15.488   213.996     0.200
    15.501   214.574     0.200
    15.501   214.516     0.200
    15.520   214.941     0.200
    15.618   216.527     0.200
    16.021   221.879     0.200
    16.021   221.250     0.200
    16.019   222.031     0.200
    16.044   221.969     0.200
    16.031   221.535     0.200
    16.056   221.316     0.200
    16.077   224.441     0.200
    16.077   221.926     0.200
    16.092   222.086     0.200
    16.086   222.910     0.200
    16.200   223.051     0.200
    16.200   222.820     0.200
    16.316   224.520     0.200
    16.347   224.488     0.200
    16.471   226.227     0.200
    16.563   227.711     0.200
    16.639   228.852     0.200
    16.930   232.320     0.200
    17.099   234.395     0.200
    17.667   240.988     0.200
    17.667   241.488     0.200
    17.667   241.141     0.200
    17.667   241.738     0.200
     1.220    21.410     0.200
     1.220    21.512     0.200
     1.384    23.102     0.200
     1.384    23.332     0.200
     1.869    28.211     0.200
     1.869    28.641     0.200
     1.869    28.469     0.200
     1.889    30.832     0.200
     1.936    31.301     0.200
     1.933    31.680     0.200
     1.956    31.832     0.200
     2.056    33.461     0.200
     1.980    32.301     0.200
     2.077    34.000     0.200
     2.178    35.211     0.200
     2.192    35.129     0.200
     2.936    43.410     0.200
     2.936    43.539     0.200
     2.936    44.969     0.200
     2.964    45.234     0.200
     3.071    47.172     0.200
     3.058    47.949     0.200
     3.211    49.379     0.200
     3.185    49.789     0.200
     3.262    50.691     0.200
     3.646    54.582     0.200
     3.716    53.512     0.200
     3.716    54.020     0.200
     3.679    54.898     0.200
     3.710    55.051     0.200
     3.732    55.449     0.200
     3.796    56.590     0.200
     3.898    58.250     0.200
     3.898    57.395     0.200
     4.024    60.109     0.200
     4.147    61.082     0.200
     4.130    61.430     0.200
     4.130    61.312     0.200
     4.197    62.000     0.200
     4.360    62.605     0.200
     4.360    62.410     0.200
     4.328    64.090     0.200
     4.328    63.875     0.200
     4.273    64.309     0.200
     4.316    64.711     0.200
     4.316    64.852     0.200
     4.429    64.820     0.200
     4.429    65.008     0.200
     4.346    65.332     0.200
     4.415    65.871     0.200
     4.416    66.332     0.200
     4.428    66.609     0.200
     4.428    66.129     0.200
     4.444    66.469     0.200
     4.460    66.852     0.200
     4.463    66.750     0.200
     4.487    67.191     0.200
     4.599    68.082     0.200
     4.599    67.848     0.200
     4.690    69.172     0.200
     4.690    68.766     0.200
     4.820    70.879     0.200
     4.820    70.562     0.200
     4.807    70.309     0.200
     4.807    70.871     0.200
     4.807    70.977     0.200
     4.923    71.930     0.200
     4.900    72.289     0.200
     5.032    74.172     0.200
     5.068    74.840     0.200
     5.254    76.840     0.200
     5.254    76.629     0.200
     5.304    77.422     0.200
     5.304    77.684     0.200
     5.332    78.430     0.200
     5.332    78.297     0.200
     5.532    80.719     0.200
     5.570    81.289     0.200
     5.570    81.414     0.200
     5.664    82.289     0.200
     5.664    82.426     0.200
     5.743    83.582     0.200
     5.739    84.750     0.200
     5.822    85.449     0.200
     5.939    85.941     0.200
     5.939    86.270     0.200
     5.845    85.930     0.200
     5.907    85.684     0.200
     5.877    86.211     0.200
     6.025    86.453     0.200
     6.066    86.871     0.200
     6.061    87.375     0.200
     6.124    89.012     0.200
     6.124    88.887     0.200
     6.092    89.031     0.200
     6.092    88.531     0.200
     6.132    88.738     0.200
     6.281    90.551     0.200
     6.281    90.918     0.200
     6.306    90.512     0.200
     6.361    89.922     0.200
     6.395    91.113     0.200
     6.476    95.332     0.200
     6.522    93.750     0.200
     6.522    94.406     0.200
     6.736    96.957     0.200
     6.829    98.238     0.200
     6.829    98.012     0.200
     6.809    97.559     0.200
     6.809    97.980     0.200
     6.862    99.309     0.200
     6.862    99.094     0.200
     6.957    99.637     0.200
     7.045   101.625     0.200
     7.116    99.922     0.200
     7.116   101.727     0.200
     6.963   100.512     0.200
     6.963   100.629     0.200
     7.135   101.500     0.200
     7.284   104.734     0.200
     7.235   103.727     0.200
     7.380   105.840     0.200
     7.380   106.695     0.200
     7.524   108.465     0.200
     7.524   107.559     0.200
     7.524   108.172     0.200
     7.562   108.691     0.200
     7.562   108.250     0.200
     7.731   109.160     0.200
     7.731   110.848     0.200
     7.844   111.270     0.200
     7.737   110.910     0.200
     7.819   111.684     0.200
     7.959   114.602     0.200
     8.037   114.328     0.200
     8.136   116.547     0.200
     8.304   118.410     0.200
     8.304   117.199     0.200
     8.304   118.695     0.200
     8.276   118.340     0.200
     8.276   118.594     0.200
     8.387   118.895     0.200
     8.443   118.449     0.200
     8.506   119.793     0.200
     8.505   120.859     0.200
     8.458   120.363     0.200
     8.507   120.664     0.200
     8.611   122.727     0.200
     8.633   123.266     0.200
     8.618   122.938     0.200
     8.718   123.312     0.200
     8.758   124.574     0.200
     8.837   124.711     0.200
     8.837   124.898     0.200
     8.904   126.758     0.200
     9.090   128.738     0.200
     9.065   128.602     0.200
     9.063   128.730     0.200
     9.130   129.949     0.200
     9.216   131.434     0.200
     9.336   132.148     0.200
     9.441   133.336     0.200
     9.483   133.660     0.200
     9.538   133.176     0.200
     9.524   134.039     0.200
     9.518   134.352     0.200
     9.539   136.160     0.200
     9.649   136.680     0.200
     9.734   138.109     0.200
     9.906   140.383     0.200
     9.890   140.527     0.200
     9.971   141.441     0.200
     9.927   140.988     0.200
    10.061   141.898     0.200
    10.081   143.102     0.200
    10.074   143.199     0.200
    10.074   143.531     0.200
    10.107   144.023     0.200
    10.205   143.730     0.200
    10.205   144.750     0.200
    10.265   145.859     0.200
    10.265   146.812     0.200
    10.270   146.031     0.200
    10.409   147.430     0.200
    10.484   147.801     0.200
    10.484   148.070     0.200
    10.475   148.594     0.200
    10.636   148.469     0.200
    10.668   151.422     0.200
    10.689   151.879     0.200
    10.754   152.859     0.200
    10.785   152.273     0.200
    10.784   152.207     0.200
    10.847   152.840     0.200
    10.847   152.680     0.200
    10.992   155.836     0.200
    11.074   155.531     0.200
    11.074   156.023     0.200
    11.011   156.297     0.200
    11.138   157.172     0.200
    11.127   157.344     0.200
    11.230   158.582     0.200
    11.242   159.184     0.200
    11.211   158.207     0.200
    11.299   159.609     0.200
    11.299   158.750     0.200
    11.299   159.465     0.200
    11.299   159.219     0.200
    11.236   159.391     0.200
    11.352   159.609     0.200
    11.352   160.145     0.200
    11.281   159.590     0.200
    11.269   159.539     0.200
    11.391   160.387     0.200
    11.338   159.410     0.200
    11.276   159.410     0.200
    11.276   159.660     0.200
    11.447   158.680     0.200
    11.447   160.191     0.200
    11.544   162.781     0.200
    11.601   163.945     0.200
    11.668   163.562     0.200
    11.666   163.828     0.200
    11.555   163.270     0.200
    11.637   164.281     0.200
    11.749   165.785     0.200
    11.723   165.121     0.200
    11.733   166.246     0.200
    11.812   165.629     0.200
    11.812   166.484     0.200
    11.782   165.422     0.200
    11.830   165.988     0.200
    11.935   168.180     0.200
    11.880   166.934     0.200
    11.958   168.391     0.200
    12.156   170.137     0.200
    12.117   169.395     0.200
    12.247   172.316     0.200
    12.268   173.125     0.200
    12.241   172.332     0.200
    12.307   173.168     0.200
    12.393   173.332     0.200
    12.510   175.465     0.200
    12.603   176.113     0.200
    12.572   176.234     0.200
    12.667   175.824     0.200
    12.658   178.340     0.200
    12.594   177.152     0.200
    12.584   177.270     0.200
    12.801   179.469     0.200
    12.810   178.879     0.200
    12.870   180.262     0.200
    12.950   181.527     0.200
    13.007   181.781     0.200
    13.007   182.426     0.200
    13.125   181.711     0.200
    13.125   181.582     0.200
    13.125   181.938     0.200
    13.005   182.891     0.200
    13.247   185.680     0.200
    13.259   185.641     0.200
    13.285   186.148     0.200
    13.322   187.410     0.200
    13.322   185.641     0.200
    13.322   187.012     0.200
    13.287   186.438     0.200
    13.342   188.031     0.200
    13.533   188.840     0.200
    13.427   189.031     0.200
    13.534   190.289     0.200
    13.566   189.594     0.200
    13.607   191.133     0.200
    13.599   191.723     0.200
    13.624   191.605     0.200
    13.792   193.406     0.200
    13.730   193.582     0.200
    13.776   194.277     0.200
    13.776   194.980     0.200
    13.834   195.277     0.200
    13.776   192.488     0.200
    13.869   195.949     0.200
    13.946   195.988     0.200
    14.006   195.117     0.200
    14.004   195.301     0.200
    14.086   196.277     0.200
    14.155   197.188     0.200
    14.245   198.344     0.200
    14.395   198.672     0.200
    14.395   199.520     0.200
    14.394   201.199     0.200
    14.372   200.887     0.200
    14.474   201.109     0.200
    14.388   201.949     0.200
    14.486   202.484     0.200
    14.554   203.191     0.200
    14.544   203.113     0.200
    14.700   205.047     0.200
    14.683   205.480     0.200
    14.764   205.699     0.200
    14.796   205.754     0.200
    14.822   206.453     0.200
    14.859   207.648     0.200
    14.938   208.988     0.200
    14.951   209.867     0.200
    15.010   209.805     0.200
    15.155   211.500     0.200
    15.345   213.391     0.200
    15.384   213.887     0.200
    15.384   214.543     0.200
    15.525   216.520     0.200
    15.494   216.391     0.200
    15.468   215.590     0.200
    15.556   216.488     0.200
    15.641   217.777     0.200
    15.969   222.160     0.200
    15.969   222.445     0.200
    15.979   222.637     0.200
    16.039   223.367     0.200
    16.086   223.660     0.200
    16.217   224.844     0.200
    16.275   225.438     0.200
    16.292   224.777     0.200
    16.435   227.371     0.200
    16.485   227.559     0.200
    16.536   227.934     0.200
    16.611   229.871     0.200
    16.672   231.074     0.200
    17.716   241.910     0.200
    17.716   243.699     0.200
     1.634    27.859     0.200
     1.819    31.508     0.200
     2.159    35.523     0.200
     3.180    49.434     0.200
     3.904    59.418     0.200
     4.209    62.281     0.200
     4.209    63.590     0.200
     4.553    68.020     0.200
     4.614    69.008     0.200
     4.614    68.871     0.200
     4.636    69.918     0.200
     4.667    70.605     0.200
     4.672    70.488     0.200
     4.672    70.320     0.200
     4.691    70.500     0.200
     4.691    70.609     0.200
     4.704    70.910     0.200
     4.708    70.551     0.200
     4.948    72.355     0.200
     5.145    76.887     0.200
     5.173    77.398     0.200
     5.209    77.320     0.200
     5.209    76.840     0.200
     5.361    79.668     0.200
     5.551    82.195     0.200
     5.593    82.969     0.200
     5.560    80.688     0.200
     5.560    81.270     0.200
     5.560    81.633     0.200
     5.668    84.094     0.200
     5.984    88.445     0.200
     5.994    88.039     0.200
     5.994    88.695     0.200
     6.062    88.621     0.200
     6.062    89.672     0.200
     6.110    89.371     0.200
     5.937    89.359     0.200
     5.937    89.539     0.200
     6.201    90.391     0.200
     6.201    90.945     0.200
     6.241    91.168     0.200
     6.241    91.496     0.200
     6.509    94.738     0.200
     6.509    95.793     0.200
     6.505    95.035     0.200
     6.500    94.898     0.200
     6.500    95.445     0.200
     6.593    96.539     0.200
     6.626    96.809     0.200
     6.626    97.570     0.200
     6.784    98.980     0.200
     6.837    99.320     0.200
     7.040   102.109     0.200
     7.040   102.395     0.200
     7.030   103.031     0.200
     7.070   103.289     0.200
     7.070   103.824     0.200
     7.083   101.848     0.200
     7.083   102.973     0.200
     7.108   102.320     0.200
     7.161   103.695     0.200
     7.153   103.500     0.200
     7.238   105.359     0.200
     7.382   107.730     0.200
     7.443   106.730     0.200
     7.490   107.301     0.200
     7.663   110.469     0.200
     7.635   111.078     0.200
     7.635   110.969     0.200
     7.726   111.898     0.200
     7.726   111.570     0.200
     7.929   114.629     0.200
     8.022   116.629     0.200
     8.053   116.520     0.200
     8.182   118.359     0.200
     8.203   117.898     0.200
     8.203   118.508     0.200
     8.237   118.449     0.200
     8.237   118.684     0.200
     8.221   117.801     0.200
     8.221   118.281     0.200
     8.301   119.668     0.200
     8.326   121.141     0.200
     8.351   120.289     0.200
     8.351   120.430     0.200
     8.368   120.738     0.200
     8.710   125.051     0.200
     8.710   125.168     0.200
     8.751   124.758     0.200
     8.751   126.031     0.200
     8.838   127.367     0.200
     8.863   126.781     0.200
     8.863   126.469     0.200
     9.013   128.141     0.200
     9.013   128.945     0.200
     9.094   129.898     0.200
     9.127   130.379     0.200
     9.127   130.695     0.200
     9.121   129.797     0.200
     9.214   130.820     0.200
     9.310   132.770     0.200
     9.310   133.121     0.200
     9.314   132.898     0.200
     9.314   133.395     0.200
     9.422   135.434     0.200
     9.426   134.500     0.200
     9.428   133.809     0.200
     9.428   134.473     0.200
     9.489   135.660     0.200
     9.489   136.266     0.200
     9.506   135.648     0.200
     9.605   136.520     0.200
     9.622   135.930     0.200
     9.622   136.371     0.200
     9.736   137.570     0.200
     9.736   137.367     0.200
     9.774   139.781     0.200
     9.774   139.531     0.200
     9.801   138.359     0.200
     9.895   141.352     0.200
     9.942   141.145     0.200
    10.004   141.531     0.200
    10.004   141.320     0.200
    10.096   143.895     0.200
    10.112   143.449     0.200
    10.168   145.027     0.200
    10.248   146.789     0.200
    10.263   146.770     0.200
    10.263   146.457     0.200
     9.936   144.969     0.200
     9.936   145.070     0.200
     9.936   144.699     0.200
    10.314   146.422     0.200
    10.360   147.383     0.200
    10.365   147.672     0.200
    10.377   147.770     0.200
    10.377   147.871     0.200
    10.385   146.594     0.200
    10.440   147.570     0.200
    10.440   147.758     0.200
    10.469   147.246     0.200
    10.555   150.375     0.200
    10.651   151.449     0.200
    10.697   152.520     0.200
    10.709   151.461     0.200
    10.709   151.582     0.200
    10.701   151.520     0.200
    10.701   151.758     0.200
    10.761   154.242     0.200
    10.832   153.270     0.200
    10.937   155.117     0.200
    10.936   155.543     0.200
    10.957   155.926     0.200
    11.031   156.621     0.200
    11.165   158.418     0.200
    11.165   158.543     0.200
    11.252   160.828     0.200
    11.271   158.961     0.200
    11.271   159.500     0.200
    11.258   158.855     0.200
    11.269   159.059     0.200
    11.304   160.469     0.200
    11.307   161.270     0.200
    11.377   161.629     0.200
    11.377   161.395     0.200
    11.376   160.461     0.200
    11.470   162.590     0.200
    11.508   162.871     0.200
    11.508   161.836     0.200
    11.588   164.336     0.200
    11.552   165.449     0.200
    11.552   164.785     0.200
    11.573   163.266     0.200
    11.609   163.855     0.200
    11.717   165.879     0.200
    11.761   166.629     0.200
    11.850   167.621     0.200
    11.883   168.891     0.200
    11.883   168.352     0.200
    11.922   167.988     0.200
    11.960   169.172     0.200
    11.997   169.180     0.200
    12.040   168.758     0.200
    12.051   171.215     0.200
    12.096   170.008     0.200
    12.096   170.777     0.200
    12.120   170.789     0.200
    12.148   170.969     0.200
    12.148   172.008     0.200
    12.148   170.684     0.200
    12.148   169.691     0.200
    12.224   173.469     0.200
    12.225   172.496     0.200
    12.309   173.898     0.200
    12.309   173.602     0.200
    12.331   171.520     0.200
    12.357   175.145     0.200
    12.328   173.207     0.200
    12.450   175.625     0.200
    12.458   175.492     0.200
    12.530   176.137     0.200
    12.520   177.641     0.200
    12.520   175.965     0.200
    12.534   177.242     0.200
    12.579   176.480     0.200
    12.657   176.977     0.200
    12.668   176.797     0.200
    12.720   180.301     0.200
    12.865   182.559     0.200
    12.865   181.887     0.200
    12.846   181.039     0.200
    12.917   180.949     0.200
    12.917   181.121     0.200
    12.905   180.699     0.200
    12.905   181.113     0.200
    12.924   180.309     0.200
    12.957   182.543     0.200
    13.008   184.109     0.200
    13.131   185.945     0.200
    13.205   185.953     0.200
    13.190   186.676     0.200
    13.192   186.289     0.200
    13.275   185.219     0.200
    13.439   189.539     0.200
    13.482   190.941     0.200
    13.480   190.094     0.200
    13.539   192.531     0.200
    13.539   191.852     0.200
    13.575   191.449     0.200
    13.632   191.559     0.200
    13.722   191.980     0.200
    13.819   193.094     0.200
    13.869   196.000     0.200
    13.846   194.820     0.200
    13.889   196.742     0.200
    13.970   198.168     0.200
    13.929   195.840     0.200
    13.997   197.938     0.200
    13.978   196.086     0.200
    13.994   197.148     0.200
    14.094   198.234     0.200
    14.099   200.141     0.200
    14.099   199.594     0.200
    14.094   198.652     0.200
    14.243   201.094     0.200
    14.228   199.797     0.200
    14.291   201.871     0.200
    14.325   200.789     0.200
    14.286   201.297     0.200
    14.364   200.570     0.200
    14.399   201.820     0.200
    14.479   202.738     0.200
    14.498   201.953     0.200
    14.500   201.887     0.200
    14.566   204.031     0.200
    14.617   207.000     0.200
    14.617   204.172     0.200
    14.692   205.363     0.200
    14.743   206.020     0.200
    14.818   205.730     0.200
    14.862   207.719     0.200
    14.868   207.289     0.200
    14.941   207.871     0.200
    14.948   207.805     0.200
    14.868   207.293     0.200
    14.974   208.727     0.200
    14.920   210.758     0.200
    14.920   207.852     0.200
    15.011   210.629     0.200
    15.003   210.199     0.200
    15.054   210.406     0.200
    15.142   211.973     0.200
    15.298   213.180     0.200
    15.299   212.289     0.200
    15.315   214.023     0.200
    15.006   211.988     0.200
    15.330   214.129     0.200
    15.330   214.699     0.200
    15.450   215.262     0.200
    15.548   217.066     0.200
    15.593   217.668     0.200
    15.662   219.496     0.200
    15.674   218.508     0.200
    15.776   220.121     0.200
    15.740   220.289     0.200
    15.927   221.590     0.200
    15.960   221.770     0.200
    15.981   222.113     0.200
    16.016   222.906     0.200
    16.072   223.156     0.200
    16.132   224.227     0.200
    16.163   224.254     0.200
    16.133   224.309     0.200
    16.139   224.375     0.200
    16.302   226.086     0.200
    16.359   226.281     0.200
    16.455   227.898     0.200
    16.560   229.793     0.200
    16.659   231.297     0.200
    16.713   232.492     0.200
    16.691   231.211     0.200
    16.881   234.168     0.200
    16.828   233.793     0.200
    16.937   235.293     0.200
    16.943   235.105     0.200
    17.069   236.484     0.200
    17.097   235.844     0.200
    17.136   237.340     0.200
    17.244   238.855     0.200
    17.240   237.984     0.200
    17.290   239.168     0.200
    17.290   239.328     0.200
    17.432   239.219     0.200
    17.432   239.852     0.200
    17.572   242.281     0.200
    17.572   241.734     0.200
    17.682   243.090     0.200
    17.682   243.387     0.200
    17.852   245.305     0.200
    17.971   246.805     0.200
    18.130   247.559     0.200
    18.130   248.453     0.200
     1.279    22.559     0.200
     1.308    22.957     0.200
     1.282    22.027     0.200
     1.425    24.227     0.200
     1.436    25.270     0.200
     1.477    26.227     0.200
     1.553    26.656     0.200
     1.847    29.137     0.200
     1.993    32.816     0.200
     2.061    34.340     0.200
     2.138    35.008     0.200
     2.920    43.930     0.200
     2.920    44.188     0.200
     3.706    54.430     0.200
     3.706    54.719     0.200
     3.748    55.879     0.200
     4.169    61.367     0.200
     4.352    63.172     0.200
     4.352    63.406     0.200
     4.378    64.750     0.200
     4.361    65.227     0.200
     4.458    66.680     0.200
     4.506    67.590     0.200
     4.655    69.039     0.200
     4.730    70.457     0.200
     4.850    71.129     0.200
     4.850    71.527     0.200
     5.278    77.250     0.200
     5.360    78.500     0.200
     5.381    79.219     0.200
     5.700    83.430     0.200
     5.851    84.629     0.200
     5.969    86.988     0.200
     6.030    87.250     0.200
     6.068    87.227     0.200
     6.151    89.098     0.200
     6.187    89.848     0.200
     6.306    91.477     0.200
     6.321    90.738     0.200
     6.365    90.566     0.200
     7.116   100.309     0.200
     7.141   102.289     0.200
     7.027   101.727     0.200
     7.158   103.039     0.200
     7.106   101.469     0.200
     7.416   105.547     0.200
     7.486   106.566     0.200
     7.546   107.066     0.200
     7.554   108.227     0.200
     7.613   110.008     0.200
     7.738   109.297     0.200
     7.838   110.797     0.200
     7.795   112.137     0.200
     7.981   113.906     0.200
     8.039   113.117     0.200
     8.312   118.527     0.200
     8.392   119.398     0.200
     8.331   119.199     0.200
     8.437   118.898     0.200
     8.514   121.340     0.200
     8.506   121.258     0.200
     8.551   121.688     0.200
     8.629   123.090     0.200
     8.658   121.039     0.200
     8.725   123.879     0.200
     8.831   124.027     0.200
     8.831   124.617     0.200
     9.110   129.867     0.200
     9.191   130.059     0.200
     9.335   131.406     0.200
     9.498   134.609     0.200
     9.532   133.199     0.200
     9.543   134.379     0.200
     9.613   134.816     0.200
     9.652   136.520     0.200
     9.845   138.316     0.200
     9.778   138.930     0.200
    10.033   141.848     0.200
    10.116   142.359     0.200
    10.166   143.750     0.200
    10.624   148.957     0.200
    11.137   155.250     0.200
    11.153   156.469     0.200
    11.157   157.137     0.200
    11.233   156.656     0.200
    11.339   159.398     0.200
    11.317   161.328     0.200
    11.288   159.887     0.200
    11.320   159.879     0.200
    11.321   160.828     0.200
    11.321   160.297     0.200
    11.463   157.090     0.200
    11.572   163.340     0.200
    11.674   163.770     0.200
    11.600   163.789     0.200
    11.736   164.508     0.200
    11.812   166.250     0.200
    11.830   166.148     0.200
    11.806   164.988     0.200
    12.409   172.957     0.200
    12.637   176.719     0.200
    12.803   179.309     0.200
    13.090   182.129     0.200
    13.090   182.258     0.200
    13.230   185.797     0.200
    13.254   186.207     0.200
    13.299   188.527     0.200
    13.286   186.270     0.200
    13.332   187.340     0.200
    13.419   188.406     0.200
    13.501   189.219     0.200
    13.568   189.438     0.200
    13.558   189.887     0.200
    13.544   189.340     0.200
    13.593   189.598     0.200
    13.859   194.059     0.200
    13.822   193.039     0.200
    13.954   194.609     0.200
    13.981   193.719     0.200
    14.131   198.508     0.200
    14.357   199.477     0.200
    14.433   202.527     0.200
    14.433   201.367     0.200
    14.453   202.727     0.200
    14.506   202.988     0.200
    15.473   215.816     0.200
    15.504   214.949     0.200
    15.494   216.566     0.200
    15.562   217.309     0.200
    15.562   217.539     0.200
    15.603   217.129     0.200
    15.967   222.520     0.200
    16.041   222.977     0.200
    16.094   222.738     0.200
    16.291   225.969     0.200
    16.455   228.238     0.200
    16.550   230.328     0.200
    16.621   231.340     0.200
    17.725   243.027     0.200
     1.311    22.816     0.200
     1.295    22.406     0.200
     1.370    24.133     0.200
     1.423    24.223     0.200
     1.833    29.195     0.200
     1.833    29.594     0.200
     2.023    33.605     0.200
     2.027    33.824     0.200
     2.152    36.285     0.200
     2.907    44.094     0.200
     2.907    44.324     0.200
     3.693    54.594     0.200
     3.693    54.906     0.200
     3.739    55.883     0.200
     4.340    63.465     0.200
     4.340    63.625     0.200
     4.340    62.055     0.200
     4.378    65.113     0.200
     4.452    66.273     0.200
     4.376    66.695     0.200
     4.376    66.125     0.200
     4.521    67.754     0.200
     4.657    69.066     0.200
     4.727    70.465     0.200
     4.866    71.895     0.200
     4.866    72.215     0.200
     5.271    77.316     0.200
     5.362    78.516     0.200
     5.381    79.145     0.200
     5.696    84.145     0.200
     5.757    83.965     0.200
     5.842    84.766     0.200
     7.039   102.395     0.200
     8.819   124.996     0.200
     9.793   139.996     0.200
    11.309   159.395     0.200
    11.309   158.223     0.200
    11.455   157.246     0.200
    11.336   161.395     0.200
    13.075   182.695     0.200
    13.284   188.594     0.200
    14.418   202.496     0.200
    15.193   213.406     0.200
    15.411   216.316     0.200
    15.464   216.484     0.200
    15.486   215.094     0.200
    15.494   215.766     0.200
    15.552   216.633     0.200
    15.926   221.094     0.200
    16.084   223.004     0.200
    16.360   227.695     0.200
    16.611   230.906     0.200
    16.668   230.613     0.200
    17.135   236.133     0.200
    17.716   243.395     0.200
    17.716   243.785     0.200
     0.349     8.344     0.200
     0.360     8.535     0.200
     0.515    11.445     0.200
     0.515    11.684     0.200
     0.868    15.535     0.200
     1.056    19.043     0.200
     1.111    20.082     0.200
     1.319    21.555     0.200
     1.233    21.832     0.200
     1.283    22.383     0.200
     1.286    22.434     0.200
     1.379    24.016     0.200
     1.506    25.664     0.200
     1.524    25.562     0.200
     2.370    37.543     0.200
     2.370    34.875     0.200
     2.415    39.344     0.200
     3.367    49.504     0.200
     3.717    55.875     0.200
     3.790    56.832     0.200
     3.718    57.844     0.200
     3.718    56.953     0.200
     3.855    57.305     0.200
     3.856    57.652     0.200
     3.868    57.844     0.200
     3.856    58.422     0.200
     3.966    59.203     0.200
     4.011    59.125     0.200
     4.092    58.574     0.200
     4.182    61.934     0.200
     4.222    64.344     0.200
     4.222    63.652     0.200
     4.385    65.172     0.200
     4.505    66.445     0.200
     4.697    68.105     0.200
     4.886    71.664     0.200
     5.011    73.312     0.200
     5.258    76.875     0.200
     5.520    79.953     0.200
     5.614    81.922     0.200
     5.725    82.766     0.200
     5.779    83.125     0.200
     5.865    85.273     0.200
     5.872    85.004     0.200
     5.946    85.516     0.200
     6.276    91.504     0.200
     6.259    91.242     0.200
     6.259    91.395     0.200
     6.347    91.812     0.200
     6.404    91.516     0.200
     6.387    91.574     0.200
     6.553    94.062     0.200
     7.226   103.684     0.200
     7.205   103.613     0.200
     7.327   104.344     0.200
     7.265   104.414     0.200
     7.359   105.172     0.200
     7.450   107.094     0.200
     7.592   108.723     0.200
     7.859   112.445     0.200
     8.147   115.773     0.200
     8.261   116.672     0.200
     8.444   120.695     0.200
     8.679   123.473     0.200
     8.740   122.492     0.200
     8.753   123.742     0.200
     9.072   129.344     0.200
     9.259   130.105     0.200
     9.793   138.516     0.200
    10.028   142.004     0.200
    11.031   154.832     0.200
    11.213   158.613     0.200
    11.758   162.723     0.200
    11.752   165.422     0.200
    12.046   168.094     0.200
    12.064   167.652     0.200
    13.113   182.594     0.200
    13.384   186.922     0.200
    13.567   189.773     0.200
    13.663   190.195     0.200
    15.218   211.445     0.200
    15.258   212.613     0.200
    15.355   212.062     0.200
    15.467   214.562     0.200
    15.622   216.434     0.200
    16.231   223.934     0.200
    16.838   230.902     0.200
    17.841   242.742     0.200
     1.045    19.910     0.200
     1.042    19.430     0.200
     1.093    20.758     0.200
     1.552    26.641     0.200
     1.706    29.188     0.200
     1.714    29.148     0.200
     1.740    30.797     0.200
     1.740    29.738     0.200
     1.822    32.109     0.200
     2.075    33.938     0.200
     3.103    47.867     0.200
     3.103    47.758     0.200
     3.042    49.969     0.200
     3.042    49.508     0.200
     3.188    51.699     0.200
     3.530    55.668     0.200
     3.530    55.348     0.200
     4.129    62.070     0.200
     4.546    67.758     0.200
     4.614    68.809     0.200
     4.620    69.027     0.200
     4.613    69.047     0.200
     4.867    70.570     0.200
     4.867    71.340     0.200
     5.092    75.797     0.200
     5.134    75.969     0.200
     5.477    79.586     0.200
     5.527    81.609     0.200
     5.980    87.457     0.200
     5.944    87.598     0.200
     5.954    88.469     0.200
     6.165    90.277     0.200
     6.144    89.840     0.200
     6.439    93.629     0.200
     6.466    94.289     0.200
     6.547    96.219     0.200
     6.701    98.148     0.200
     6.782    98.367     0.200
     6.966   101.641     0.200
     6.989   102.348     0.200
     7.069   102.207     0.200
     7.093   102.910     0.200
     7.587   109.898     0.200
     7.665   110.957     0.200
     7.854   113.090     0.200
     7.968   115.828     0.200
     8.098   117.180     0.200
     8.124   117.508     0.200
     8.137   116.789     0.200
     8.167   117.340     0.200
     8.244   120.469     0.200
     8.247   118.641     0.200
     8.646   123.938     0.200
     8.458   124.168     0.200
     8.458   123.469     0.200
     8.796   125.129     0.200
     8.929   127.078     0.200
     9.037   128.688     0.200
     9.054   129.430     0.200
     9.251   132.418     0.200
     9.348   134.008     0.200
     9.407   134.078     0.200
     9.422   134.180     0.200
     9.521   135.277     0.200
     9.700   138.039     0.200
     9.717   137.039     0.200
    10.028   141.730     0.200
    10.092   144.008     0.200
    10.206   145.590     0.200
    10.001   144.590     0.200
    10.231   145.840     0.200
    10.212   145.609     0.200
    10.284   146.918     0.200
    10.311   145.590     0.200
    10.312   147.047     0.200
    10.356   146.438     0.200
    10.280   148.570     0.200
    10.583   149.918     0.200
    10.617   149.820     0.200
    10.625   150.297     0.200
    10.854   153.148     0.200
    11.094   157.609     0.200
    11.186   157.590     0.200
    11.232   157.660     0.200
    11.253   160.398     0.200
    11.293   159.109     0.200
    11.424   162.758     0.200
    11.686   164.219     0.200
    11.684   165.840     0.200
    11.767   165.480     0.200
    11.847   167.840     0.200
    11.900   165.750     0.200
    11.916   165.047     0.200
    11.957   166.660     0.200
    12.142   169.867     0.200
    12.147   172.039     0.200
    12.249   171.809     0.200
    12.249   167.711     0.200
    12.288   173.590     0.200
    12.384   174.828     0.200
    12.450   175.367     0.200
    12.574   173.820     0.200
    12.649   178.129     0.200
    12.504   177.418     0.200
    12.940   183.988     0.200
    13.110   185.188     0.200
    13.894   194.641     0.200
    13.918   195.348     0.200
    14.171   200.570     0.200
    14.223   201.398     0.200
    14.615   203.957     0.200
    14.793   208.840     0.200
    15.067   211.438     0.200
    15.216   213.660     0.200
    15.058   211.980     0.200
    15.843   219.238     0.200
    15.886   221.000     0.200
    16.061   223.430     0.200
    16.086   224.820     0.200
    16.372   227.770     0.200
    16.986   235.039     0.200
    17.488   240.707     0.200
    17.598   242.160     0.200
     0.400     9.438     0.200
     0.410     9.172     0.200
     0.664    13.438     0.200
     0.664    13.312     0.200
     0.664    13.539     0.200
     1.089    20.258     0.200
     1.090    20.047     0.200
     1.219    20.391     0.200
     1.219    20.633     0.200
     2.207    34.234     0.200
     2.207    33.977     0.200
     2.207    34.133     0.200
     2.944    45.305     0.200
     3.210    48.133     0.200
     3.210    47.422     0.200
     3.210    47.758     0.200
     3.610    53.836     0.200
     3.781    56.469     0.200
     3.908    58.242     0.200
     3.941    57.234     0.200
     3.941    56.992     0.200
     3.941    56.836     0.200
     3.883    58.836     0.200
     3.883    59.531     0.200
     3.992    58.953     0.200
     3.992    59.250     0.200
     4.021    60.977     0.200
     4.192    61.672     0.200
     4.192    62.133     0.200
     4.302    63.625     0.200
     4.302    63.375     0.200
     4.386    65.836     0.200
     4.386    65.578     0.200
     4.386    65.406     0.200
     4.453    65.328     0.200
     4.453    65.438     0.200
     4.551    65.406     0.200
     4.551    65.156     0.200
     4.551    65.672     0.200
     4.739    69.398     0.200
     4.755    69.719     0.200
     4.897    72.008     0.200
     4.994    73.336     0.200
     5.167    75.562     0.200
     5.294    77.508     0.200
     5.460    79.453     0.200
     5.460    79.258     0.200
     5.548    81.195     0.200
     5.552    80.609     0.200
     5.644    82.609     0.200
     5.682    82.688     0.200
     5.682    83.000     0.200
     5.734    83.477     0.200
     5.734    83.195     0.200
     5.791    84.102     0.200
     5.791    83.812     0.200
     5.839    85.227     0.200
     5.839    85.008     0.200
     6.075    88.227     0.200
     6.100    88.695     0.200
     6.100    88.375     0.200
     6.188    90.133     0.200
     6.295    91.266     0.200
     6.295    90.648     0.200
     6.355    91.977     0.200
     6.401    92.219     0.200
     6.399    92.836     0.200
     6.399    92.461     0.200
     6.399    93.031     0.200
     6.499    92.039     0.200
     6.526    93.883     0.200
     6.570    94.336     0.200
     6.589    94.133     0.200
     6.973    99.742     0.200
     7.073   102.125     0.200
     7.170   102.500     0.200
     7.199   103.672     0.200
     7.228   102.094     0.200
     7.201   103.281     0.200
     7.295   104.633     0.200
     7.377   105.797     0.200
     7.441   107.656     0.200
     7.554   108.031     0.200
     7.782   110.953     0.200
     7.872   111.992     0.200
     7.921   112.789     0.200
     8.008   113.336     0.200
     8.008   112.992     0.200
     8.134   114.766     0.200
     8.146   114.820     0.200
     8.131   116.086     0.200
     8.205   115.352     0.200
     8.210   115.727     0.200
     8.219   116.375     0.200
     8.346   119.336     0.200
     8.346   116.758     0.200
     8.394   119.109     0.200
     8.453   118.969     0.200
     8.546   122.836     0.200
     8.546   122.602     0.200
     8.574   121.000     0.200
     8.613   120.727     0.200
     8.608   122.109     0.200
     8.628   120.875     0.200
     8.737   124.242     0.200
     8.737   124.531     0.200
     8.768   122.133     0.200
     8.968   125.305     0.200
     9.000   126.734     0.200
     9.000   125.750     0.200
     9.015   128.141     0.200
     9.031   128.422     0.200
     9.136   128.219     0.200
     9.305   131.312     0.200
     9.305   130.977     0.200
     9.306   132.336     0.200
     9.306   132.031     0.200
     9.372   132.734     0.200
     9.401   133.477     0.200
     9.449   132.016     0.200
     9.444   130.742     0.200
     9.467   133.031     0.200
     9.467   131.391     0.200
     9.513   131.539     0.200
     9.574   135.352     0.200
     9.652   136.781     0.200
     9.698   135.836     0.200
     9.698   135.586     0.200
     9.729   136.570     0.200
     9.769   138.492     0.200
     9.861   139.836     0.200
     9.861   139.359     0.200
     9.923   140.594     0.200
     9.989   138.141     0.200
     9.994   141.344     0.200
    10.044   138.742     0.200
    10.093   142.648     0.200
    10.232   143.523     0.200
    10.251   143.250     0.200
    10.272   144.273     0.200
    10.290   143.992     0.200
    10.330   146.234     0.200
    10.352   146.461     0.200
    10.455   147.516     0.200
    10.455   147.734     0.200
    10.540   147.219     0.200
    10.552   148.758     0.200
    10.570   147.727     0.200
    10.647   150.031     0.200
    10.624   149.477     0.200
    10.624   149.578     0.200
    10.719   148.164     0.200
    10.737   150.523     0.200
    10.733   151.672     0.200
    10.853   152.914     0.200
    10.853   153.375     0.200
    10.859   153.602     0.200
    10.837   152.734     0.200
    10.837   153.336     0.200
    10.837   152.914     0.200
    10.964   154.688     0.200
    11.012   153.188     0.200
    11.031   155.469     0.200
    11.104   155.031     0.200
    11.118   152.859     0.200
    11.125   153.891     0.200
    11.153   156.914     0.200
    11.208   158.172     0.200
    11.249   158.734     0.200
    11.249   156.672     0.200
    11.249   156.086     0.200
    11.249   158.977     0.200
    11.268   156.758     0.200
    11.321   158.492     0.200
    11.321   158.406     0.200
    11.329   157.844     0.200
    11.314   159.812     0.200
    11.405   160.578     0.200
    11.417   157.383     0.200
    11.451   159.227     0.200
    11.437   161.844     0.200
    11.524   161.125     0.200
    11.551   159.156     0.200
    11.570   161.594     0.200
    11.677   162.242     0.200
    11.693   164.656     0.200
    11.708   163.000     0.200
    11.694   164.773     0.200
    11.694   165.008     0.200
    11.722   161.094     0.200
    11.841   165.547     0.200
    11.918   166.172     0.200
    11.936   166.516     0.200
    11.949   168.008     0.200
    11.964   167.297     0.200
    11.978   169.109     0.200
    12.010   169.406     0.200
    12.040   165.953     0.200
    12.185   170.773     0.200
    12.275   172.836     0.200
    12.275   173.391     0.200
    12.309   171.750     0.200
    12.338   173.062     0.200
    12.337   174.391     0.200
    12.362   169.844     0.200
    12.379   171.430     0.200
    12.377   174.484     0.200
    12.437   172.742     0.200
    12.437   173.555     0.200
    12.472   173.359     0.200
    12.662   178.602     0.200
    12.801   180.156     0.200
    12.820   178.055     0.200
    12.838   178.836     0.200
    12.859   178.367     0.200
    12.923   179.914     0.200
    12.975   180.961     0.200
    13.016   180.914     0.200
    13.004   184.219     0.200
    13.094   183.258     0.200
    13.183   186.008     0.200
    13.220   183.328     0.200
    13.215   183.281     0.200
    13.258   183.828     0.200
    13.351   187.305     0.200
    13.381   185.164     0.200
    13.401   186.578     0.200
    13.410   189.109     0.200
    13.442   188.273     0.200
    13.437   190.031     0.200
    13.493   187.875     0.200
    13.493   187.219     0.200
    13.484   187.312     0.200
    13.504   189.836     0.200
    13.504   186.938     0.200
    13.504   187.391     0.200
    13.516   189.875     0.200
    13.521   189.242     0.200
    13.553   187.180     0.200
    13.618   192.133     0.200
    13.618   188.438     0.200
    13.618   190.258     0.200
    13.617   190.906     0.200
    13.673   190.633     0.200
    13.739   190.961     0.200
    13.827   192.898     0.200
    13.899   193.500     0.200
    13.937   192.289     0.200
    13.953   192.812     0.200
    13.990   193.859     0.200
    14.008   196.336     0.200
    14.001   193.336     0.200
    14.007   191.812     0.200
    14.021   195.023     0.200
    14.047   195.297     0.200
    14.158   197.453     0.200
    14.216   198.000     0.200
    14.369   199.703     0.200
    14.378   199.148     0.200
    14.417   198.961     0.200
    14.451   200.977     0.200
    14.458   201.055     0.200
    14.628   202.852     0.200
    14.628   203.531     0.200
    14.667   204.102     0.200
    14.790   205.602     0.200
    14.800   204.953     0.200
    14.796   205.266     0.200
    14.818   205.367     0.200
    14.896   207.836     0.200
    14.896   206.445     0.200
    14.896   207.562     0.200
    14.892   206.406     0.200
    14.978   208.398     0.200
    14.974   206.312     0.200
    15.009   208.805     0.200
    15.094   208.836     0.200
    15.077   209.805     0.200
    15.141   211.484     0.200
    15.191   209.977     0.200
    15.191   212.352     0.200
    15.199   210.258     0.200
    15.419   213.617     0.200
    15.512   213.906     0.200
    15.602   215.188     0.200
    15.736   219.023     0.200
    15.736   219.234     0.200
    15.767   219.680     0.200
    15.812   217.773     0.200
    15.812   219.445     0.200
    15.832   220.000     0.200
    15.786   218.250     0.200
    15.786   218.727     0.200
    15.786   218.531     0.200
    15.975   220.445     0.200
    16.091   221.914     0.200
    16.121   223.008     0.200
    16.118   221.258     0.200
    16.121   221.883     0.200
    16.114   221.992     0.200
    16.234   223.930     0.200
    16.224   223.859     0.200
    16.366   224.445     0.200
    16.516   227.234     0.200
    16.548   228.969     0.200
    16.850   232.344     0.200
    16.959   233.023     0.200
    17.176   234.984     0.200
    17.732   241.031     0.200
    17.732   240.508     0.200
    17.732   241.156     0.200
    18.322   252.617     0.200
    18.656   255.258     0.200
    18.656   256.703     0.200
    19.343   263.203     0.200
    19.802   267.172     0.200
     0.356     9.380     0.200
     0.684    13.870     0.200
     0.889    16.270     0.200
     1.087    19.830     0.200
     1.150    20.670     0.200
     1.150    20.920     0.200
     1.271    20.890     0.200
     1.532    25.210     0.200
     1.451    24.970     0.200
     1.457    25.000     0.200
     1.550    26.560     0.200
     1.765    28.800     0.200
     1.674    28.230     0.200
     2.706    43.410     0.200
     3.233    48.220     0.200
     3.787    56.780     0.200
     3.970    57.700     0.200
     3.874    59.670     0.200
     3.874    59.030     0.200
     3.966    58.910     0.200
     4.052    59.780     0.200
     4.013    61.450     0.200
     4.251    62.680     0.200
     4.357    64.250     0.200
     4.376    65.750     0.200
     4.584    65.214     0.200
     4.584    66.320     0.200
     4.512    65.920     0.200
     4.956    72.520     0.200
     5.055    74.240     0.200
     5.220    76.140     0.200
     5.518    80.090     0.200
     5.702    83.380     0.200
     5.846    84.680     0.200
     5.884    84.920     0.200
     5.793    83.670     0.200
     5.898    85.860     0.200
     6.205    88.670     0.200
     6.241    90.820     0.200
     6.345    91.490     0.200
     6.354    91.800     0.200
     6.496    92.640     0.200
     6.408    92.570     0.200
     6.460    92.840     0.200
     6.426    92.990     0.200
     6.586    94.900     0.200
     7.171   102.920     0.200
     7.248   104.270     0.200
     7.269   103.550     0.200
     7.229   103.340     0.200
     7.261   104.560     0.200
     7.353   105.490     0.200
     7.433   106.470     0.200
     7.492   106.810     0.200
     7.494   108.120     0.200
     7.614   108.860     0.200
     7.827   110.870     0.200
     7.972   113.160     0.200
     8.176   115.730     0.200
     8.191   116.810     0.200
     8.279   117.420     0.200
     8.638   121.700     0.200
     8.599   123.120     0.200
     8.664   123.120     0.200
     8.814   124.450     0.200
     8.797   125.080     0.200
     9.073   128.890     0.200
     9.180   129.720     0.200
     9.298   133.270     0.200
     9.429   133.960     0.200
     9.490   134.210     0.200
     9.455   134.380     0.200
     9.773   138.170     0.200
     9.829   139.250     0.200
    10.053   142.290     0.200
    10.307   145.170     0.200
    10.350   145.470     0.200
    10.390   147.380     0.200
    10.391   148.000     0.200
    10.514   148.300     0.200
    10.585   148.590     0.200
    10.703   150.880     0.200
    10.772   150.310     0.200
    10.792   151.680     0.200
    10.875   152.410     0.200
    10.792   152.440     0.200
    10.830   154.070     0.200
    10.830   152.920     0.200
    11.145   155.220     0.200
    11.091   156.080     0.200
    11.168   154.790     0.200
    11.107   156.860     0.200
    11.210   157.820     0.200
    11.314   158.530     0.200
    11.467   159.410     0.200
    11.467   156.820     0.200
    11.467   158.460     0.200
    11.461   160.900     0.200
    11.771   162.670     0.200
    11.750   164.760     0.200
    11.754   165.850     0.200
    11.960   166.310     0.200
    11.978   166.800     0.200
    12.069   170.000     0.200
    12.214   170.450     0.200
    12.913   180.880     0.200
    13.252   184.730     0.200
    13.317   186.930     0.200
    13.411   190.040     0.200
    13.539   188.520     0.200
    13.574   190.350     0.200
    13.581   190.140     0.200
    13.676   191.300     0.200
    13.927   193.470     0.200
    13.970   193.060     0.200
    14.023   194.470     0.200
    14.036   194.800     0.200
    14.056   194.810     0.200
    14.428   199.430     0.200
    14.426   200.160     0.200
    14.470   200.550     0.200
    14.831   206.780     0.200
    15.020   209.450     0.200
    15.138   210.650     0.200
    15.257   212.610     0.200
    15.395   214.750     0.200
    15.461   214.560     0.200
    15.490   213.800     0.200
    15.560   215.630     0.200
    15.648   217.340     0.200
    16.165   222.900     0.200
    16.215   223.710     0.200
    16.566   227.920     0.200
    16.677   230.130     0.200
    16.768   231.020     0.200
    17.781   242.550     0.200
     1.046    18.900     0.200
     1.186    20.211     0.200
     1.172    20.961     0.200
     1.169    20.971     0.200
     1.169    20.391     0.200
     1.241    22.361     0.200
     1.319    23.941     0.200
     1.319    23.561     0.200
     1.691    28.121     0.200
     1.772    28.271     0.200
     1.858    32.291     0.200
     1.946    32.051     0.200
     1.950    32.160     0.200
     2.040    33.861     0.200
     2.186    35.332     0.200
     2.820    42.570     0.200
     2.820    42.711     0.200
     3.554    53.160     0.200
     3.586    52.871     0.200
     3.586    52.691     0.200
     3.932    59.160     0.200
     4.135    61.832     0.200
     4.221    61.416     0.200
     4.221    61.211     0.200
     4.235    62.820     0.200
     4.414    65.852     0.200
     4.353    68.271     0.200
     4.353    65.381     0.200
     4.492    66.002     0.200
     4.851    73.871     0.200
     4.851    71.951     0.200
     5.065    74.211     0.200
     5.119    75.281     0.200
     5.138    75.701     0.200
     5.467    79.141     0.200
     5.906    86.121     0.200
     5.945    86.332     0.200
     6.703    97.201     0.200
     6.892   100.871     0.200
     7.622   109.342     0.200
     8.089   116.002     0.200
     8.564   122.451     0.200
     9.181   130.061     0.200
     9.777   140.471     0.200
    10.068   142.762     0.200
    10.657   150.701     0.200
    10.814   153.252     0.200
    10.932   155.221     0.200
    11.267   157.521     0.200
    11.656   164.352     0.200
    12.212   169.891     0.200
    13.778   192.900     0.200
    15.277   213.252     0.200
    15.281   213.041     0.200
    15.304   213.711     0.200
    15.321   214.451     0.200
    15.848   220.541     0.200
    15.883   221.695     0.200
    15.879   220.441     0.200
    15.916   220.541     0.200
    16.505   228.352     0.200
    17.543   241.471     0.200
    17.543   242.102     0.200
     1.271    21.273     0.200
     1.778    29.404     0.200
     1.726    29.113     0.200
     1.739    29.385     0.200
     1.946    32.543     0.200
     1.833    31.244     0.200
     2.000    30.754     0.200
     2.000    31.135     0.200
     1.949    32.475     0.200
     1.965    32.533     0.200
     2.844    45.953     0.200
     3.021    46.373     0.200
     3.040    46.555     0.200
     3.040    46.314     0.200
     2.971    47.953     0.200
     3.145    48.674     0.200
     3.656    55.264     0.200
     3.714    55.715     0.200
     3.799    55.055     0.200
     3.799    55.434     0.200
     4.011    60.043     0.200
     4.162    61.943     0.200
     4.123    63.154     0.200
     4.123    63.023     0.200
     4.352    64.773     0.200
     4.428    64.084     0.200
     4.403    65.623     0.200
     4.566    67.215     0.200
     4.772    71.283     0.200
     4.620    68.953     0.200
     4.823    70.805     0.200
     5.109    75.555     0.200
     5.197    76.074     0.200
     5.166    76.094     0.200
     5.556    80.924     0.200
     5.698    82.334     0.200
     5.735    83.674     0.200
     5.855    85.523     0.200
     5.881    86.154     0.200
     5.942    86.623     0.200
     5.981    87.234     0.200
     6.093    86.953     0.200
     6.222    90.504     0.200
     6.405    92.664     0.200
     6.615    95.664     0.200
     6.627    96.564     0.200
     6.679    96.154     0.200
     6.709    98.654     0.200
     6.709    98.363     0.200
     7.150   102.135     0.200
     7.150   101.613     0.200
     7.271   103.443     0.200
     7.388   106.523     0.200
     7.442   107.084     0.200
     7.529   108.764     0.200
     7.686   110.293     0.200
     7.738   110.373     0.200
     7.903   112.174     0.200
     7.926   113.584     0.200
     8.084   115.584     0.200
     8.299   118.754     0.200
     8.364   119.244     0.200
     8.401   120.514     0.200
     8.500   120.234     0.200
     8.507   121.574     0.200
     8.503   120.734     0.200
     8.546   120.834     0.200
     8.579   121.225     0.200
     8.578   122.994     0.200
     8.676   123.693     0.200
     8.904   127.055     0.200
     9.070   129.734     0.200
     9.082   128.715     0.200
     9.112   129.754     0.200
     9.174   130.193     0.200
     9.372   132.363     0.200
     9.428   133.854     0.200
     9.450   134.715     0.200
     9.483   134.725     0.200
     9.596   136.174     0.200
     9.701   137.145     0.200
     9.547   136.953     0.200
     9.547   137.273     0.200
     9.803   138.443     0.200
     9.924   140.084     0.200
     9.964   141.744     0.200
    10.076   142.793     0.200
    10.130   143.193     0.200
    10.209   144.344     0.200
    10.495   148.324     0.200
    10.570   149.424     0.200
    10.716   150.863     0.200
    10.708   151.164     0.200
    10.783   152.064     0.200
    10.871   150.924     0.200
    10.897   153.783     0.200
    10.987   155.984     0.200
    11.040   155.924     0.200
    11.086   154.424     0.200
    11.053   155.465     0.200
    11.115   155.904     0.200
    11.158   156.305     0.200
    11.156   157.373     0.200
    11.233   158.504     0.200
    11.083   159.254     0.200
    11.083   157.684     0.200
    11.361   161.424     0.200
    11.671   163.385     0.200
    11.709   163.203     0.200
    11.782   164.814     0.200
    11.846   166.734     0.200
    11.827   166.443     0.200
    11.864   167.043     0.200
    12.068   168.434     0.200
    12.124   171.314     0.200
    12.340   173.033     0.200
    12.365   173.055     0.200
    12.433   173.764     0.200
    12.466   175.863     0.200
    12.814   179.004     0.200
    12.861   179.293     0.200
    12.872   180.514     0.200
    13.310   186.805     0.200
    13.315   186.594     0.200
    13.621   191.184     0.200
    13.688   191.824     0.200
    13.811   193.154     0.200
    13.952   195.434     0.200
    13.993   194.824     0.200
    14.102   196.805     0.200
    14.373   202.135     0.200
    14.452   203.055     0.200
    14.718   206.734     0.200
    14.814   206.734     0.200
    15.035   209.783     0.200
    15.288   212.574     0.200
    15.437   214.174     0.200
    15.529   215.244     0.200
    16.058   223.654     0.200
    16.063   222.674     0.200
    16.087   224.514     0.200
    16.111   221.703     0.200
    16.243   225.514     0.200
    16.514   229.574     0.200
    16.681   231.424     0.200
    17.710   240.828     0.200
    17.710   242.664     0.200
     1.579    26.977     0.200
     1.898    30.986     0.200
     2.936    45.156     0.200
     3.187    51.816     0.200
     3.187    50.828     0.200
     3.331    52.438     0.200
     3.681    57.717     0.200
     3.681    57.537     0.200
     3.956    59.598     0.200
     4.410    65.098     0.200
     4.443    66.457     0.200
     4.457    66.367     0.200
     4.498    66.656     0.200
     4.690    68.287     0.200
     4.925    73.768     0.200
     4.980    73.287     0.200
     5.192    76.227     0.200
     5.299    76.861     0.200
     5.396    78.807     0.200
     5.810    85.928     0.200
     5.852    85.816     0.200
     6.009    87.607     0.200
     6.033    87.457     0.200
     6.298    91.367     0.200
     6.385    92.678     0.200
    12.077   168.668     0.200
    12.077   169.268     0.200
    12.152   171.307     0.200
    12.232   172.008     0.200
    12.505   176.547     0.200
    12.907   180.617     0.200
    13.562   188.588     0.200
    14.025   196.928     0.200
    14.084   197.287     0.200
    14.136   197.146     0.200
    14.576   202.438     0.200
    14.688   205.838     0.200
    14.915   208.828     0.200
    15.345   214.037     0.200
    15.513   215.896     0.200
    15.668   218.088     0.200
    15.926   221.588     0.200
    16.105   223.277     0.200
    16.197   225.088     0.200
    16.300   226.828     0.200
    16.810   232.137     0.200
    16.836   233.197     0.200
    16.928   232.938     0.200
    17.314   238.277     0.200
    17.422   239.758     0.200
    17.494   241.037     0.200
     0.448     9.547     0.200
     0.448    10.006     0.200
     0.530    11.047     0.200
     0.530    11.285     0.200
     0.924    17.547     0.200
     0.992    18.736     0.200
     1.005    18.855     0.200
     1.119    20.957     0.200
     1.136    20.926     0.200
     1.141    20.566     0.200
     1.536    26.547     0.200
     1.536    26.166     0.200
     1.849    30.166     0.200
     2.465    39.006     0.200
     2.889    44.445     0.200
     2.889    43.766     0.200
     3.230    51.547     0.200
     3.230    50.326     0.200
     3.373    51.807     0.200
     3.907    58.146     0.200
     3.907    56.566     0.200
     3.725    57.146     0.200
     3.725    56.666     0.200
     4.374    64.006     0.200
     4.468    65.646     0.200
     4.640    67.297     0.200
     4.878    70.807     0.200
     4.939    71.916     0.200
     5.163    75.336     0.200
     5.249    74.340     0.200
     5.249    76.355     0.200
     5.361    78.406     0.200
     5.830    85.176     0.200
     6.025    88.846     0.200
     8.652   125.346     0.200
     9.691   136.746     0.200
    10.191   145.846     0.200
    12.030   168.227     0.200
    12.115   170.877     0.200
    12.191   172.355     0.200
    12.352   171.615     0.200
    12.593   176.906     0.200
    12.611   177.297     0.200
    12.688   178.977     0.200
    12.866   180.156     0.200
    13.665   190.057     0.200
    15.026   209.766     0.200
    15.362   213.297     0.200
    15.463   214.355     0.200
    15.465   214.557     0.200
    15.552   215.365     0.200
    15.695   217.436     0.200
    15.760   217.836     0.200
    15.835   219.207     0.200
    15.862   218.967     0.200
    15.879   219.785     0.200
    16.057   224.096     0.200
    16.149   225.086     0.200
    16.786   232.785     0.200
    16.877   233.717     0.200
    17.265   237.457     0.200
    17.373   239.266     0.200
    17.822   244.127     0.200
     1.868    30.887     0.200
     3.500    55.996     0.200
     3.754    56.094     0.200
     3.754    56.227     0.200
     3.647    58.047     0.200
     3.983    61.496     0.200
     3.983    61.785     0.200
     4.384    65.875     0.200
     4.515    65.895     0.200
     4.515    66.504     0.200
     4.534    68.086     0.200
     4.564    68.047     0.200
     4.706    70.176     0.200
     4.948    74.055     0.200
     5.073    75.023     0.200
     5.143    74.812     0.200
     5.406    79.805     0.200
     6.483    94.086     0.200
     6.383    95.496     0.200
     8.373   120.367     0.200
     8.908   129.395     0.200
     9.608   135.797     0.200
    10.347   147.066     0.200
    10.455   151.996     0.200
    10.693   151.547     0.200
    10.735   154.387     0.200
    11.369   162.023     0.200
    11.612   164.156     0.200
    11.782   166.465     0.200
    11.898   169.297     0.200
    11.898   167.785     0.200
    12.066   169.824     0.200
    12.547   177.316     0.200
    12.565   177.566     0.200
    12.962   183.906     0.200
    13.459   190.004     0.200
    13.555   191.117     0.200
    13.966   196.395     0.200
    14.153   199.996     0.200
    14.199   199.707     0.200
    14.410   202.484     0.200
    14.508   204.496     0.200
    14.610   206.797     0.200
    15.308   215.195     0.200
    17.364   239.176     0.200
     0.334     8.391     0.200
     0.334     8.680     0.200
     0.345     8.781     0.200
     0.516    11.293     0.200
     0.516    12.031     0.200
     1.125    20.691     0.200
     1.126    20.492     0.200
     2.378    36.410     0.200
     3.072    47.191     0.200
     3.377    50.191     0.200
     3.377    50.012     0.200
     3.732    55.773     0.200
     3.711    57.391     0.200
     3.870    57.941     0.200
     3.883    58.164     0.200
     3.849    58.250     0.200
     3.981    59.102     0.200
     3.981    59.586     0.200
     4.026    59.070     0.200
     4.026    59.574     0.200
     4.103    59.590     0.200
     4.103    59.363     0.200
     4.195    62.051     0.200
     4.317    63.973     0.200
     4.214    63.793     0.200
     4.214    63.422     0.200
     4.214    63.668     0.200
     4.401    65.141     0.200
     4.401    65.391     0.200
     4.520    66.500     0.200
     4.520    66.371     0.200
     4.709    67.234     0.200
     4.709    67.793     0.200
     4.709    67.953     0.200
     4.709    68.383     0.200
     4.822    70.871     0.200
     4.867    71.664     0.200
     4.899    71.965     0.200
     5.025    73.602     0.200
     5.274    77.469     0.200
     5.346    78.457     0.200
     5.535    80.492     0.200
     5.576    80.715     0.200
     5.626    82.543     0.200
     5.676    82.297     0.200
     5.739    82.770     0.200
     5.739    83.191     0.200
     5.794    84.543     0.200
     5.880    85.297     0.200
     5.887    85.668     0.200
     5.961    86.520     0.200
     6.203    90.371     0.200
     6.239    90.461     0.200
     6.291    91.340     0.200
     6.261    91.891     0.200
     6.261    91.203     0.200
     6.261    91.445     0.200
     6.302    91.355     0.200
     6.362    92.418     0.200
     6.401    92.168     0.200
     6.419    93.043     0.200
     6.567    94.328     0.200
     6.606    94.262     0.200
     6.642    93.969     0.200
     6.654    95.527     0.200
     7.027   100.453     0.200
     7.212   103.289     0.200
     7.220   104.070     0.200
     7.241   104.152     0.200
     7.241   104.238     0.200
     7.293   105.652     0.200
     7.277   104.492     0.200
     7.373   105.633     0.200
     7.465   107.168     0.200
     7.507   107.754     0.200
     7.546   109.238     0.200
     7.607   108.641     0.200
     7.872   111.914     0.200
     7.915   112.422     0.200
     8.036   114.043     0.200
     8.161   115.570     0.200
     8.161   115.160     0.200
     8.162   116.215     0.200
     8.264   116.918     0.200
     8.272   116.715     0.200
     8.275   115.703     0.200
     8.460   120.430     0.200
     8.477   118.492     0.200
     8.477   118.918     0.200
     8.589   120.801     0.200
     8.648   122.770     0.200
     8.688   122.555     0.200
     8.695   123.383     0.200
     8.731   122.992     0.200
     8.773   123.781     0.200
     8.773   123.641     0.200
     8.768   124.441     0.200
     8.901   124.660     0.200
     9.087   129.391     0.200
     9.104   128.508     0.200
     9.130   130.184     0.200
     9.152   128.293     0.200
     9.134   130.992     0.200
     9.273   130.020     0.200
     9.454   134.145     0.200
     9.464   133.207     0.200
     9.496   134.852     0.200
     9.567   132.695     0.200
     9.576   134.320     0.200
     9.593   134.680     0.200
     9.594   135.535     0.200
     9.642   134.262     0.200
     9.712   137.781     0.200
     9.807   138.695     0.200
     9.849   138.512     0.200
     9.867   139.160     0.200
     9.858   139.691     0.200
     9.858   139.551     0.200
     9.999   141.590     0.200
    10.043   142.215     0.200
    10.102   142.477     0.200
    10.115   140.441     0.200
    10.158   142.398     0.200
    10.181   142.668     0.200
    10.352   146.480     0.200
    10.352   145.934     0.200
    10.385   146.688     0.200
    10.406   145.363     0.200
    10.429   146.203     0.200
    10.516   148.434     0.200
    10.574   149.461     0.200
    10.574   149.773     0.200
    10.623   150.316     0.200
    10.674   149.020     0.200
    10.721   151.172     0.200
    10.721   150.406     0.200
    10.736   151.723     0.200
    10.665   151.992     0.200
    10.665   149.820     0.200
    10.779   152.430     0.200
    10.826   150.410     0.200
    10.834   153.078     0.200
    10.854   153.547     0.200
    10.860   153.215     0.200
    10.999   153.750     0.200
    10.941   155.312     0.200
    11.046   155.688     0.200
    11.087   156.559     0.200
    11.138   155.727     0.200
    11.194   158.211     0.200
    11.194   158.020     0.200
    11.227   155.711     0.200
    11.227   156.070     0.200
    11.228   158.352     0.200
    11.235   154.758     0.200
    11.248   157.125     0.200
    11.279   158.293     0.200
    11.345   159.945     0.200
    11.359   156.691     0.200
    11.359   157.641     0.200
    11.359   157.352     0.200
    11.397   159.605     0.200
    11.467   160.809     0.200
    11.477   162.758     0.200
    11.493   161.461     0.200
    11.483   160.801     0.200
    11.531   159.172     0.200
    11.531   159.391     0.200
    11.531   159.121     0.200
    11.661   160.742     0.200
    11.671   163.344     0.200
    11.729   164.328     0.200
    11.745   165.555     0.200
    11.767   165.109     0.200
    11.774   163.570     0.200
    11.838   164.039     0.200
    11.844   163.102     0.200
    11.994   167.828     0.200
    12.006   168.426     0.200
    12.060   168.215     0.200
    12.072   170.715     0.200
    12.078   168.133     0.200
    12.105   170.137     0.200
    12.112   169.352     0.200
    12.144   169.414     0.200
    12.310   173.211     0.200
    12.310   173.672     0.200
    12.347   173.492     0.200
    12.390   174.879     0.200
    12.420   174.211     0.200
    12.449   175.145     0.200
    12.469   174.164     0.200
    12.465   173.625     0.200
    12.476   173.969     0.200
    12.602   176.129     0.200
    12.631   177.555     0.200
    12.631   176.898     0.200
    12.685   178.863     0.200
    12.878   181.031     0.200
    12.907   180.887     0.200
    12.959   181.848     0.200
    12.998   182.020     0.200
    12.998   181.672     0.200
    13.028   183.504     0.200
    13.087   181.902     0.200
    13.126   183.242     0.200
    13.186   183.633     0.200
    13.239   187.016     0.200
    13.149   184.281     0.200
    13.261   184.773     0.200
    13.319   184.320     0.200
    13.378   185.270     0.200
    13.399   188.703     0.200
    13.423   189.562     0.200
    13.423   189.219     0.200
    13.461   189.262     0.200
    13.518   189.660     0.200
    13.520   187.973     0.200
    13.549   189.117     0.200
    13.554   190.824     0.200
    13.578   186.816     0.200
    13.582   190.422     0.200
    13.654   190.141     0.200
    13.678   188.730     0.200
    13.675   189.992     0.200
    13.675   189.793     0.200
    13.758   192.793     0.200
    13.785   193.293     0.200
    13.785   192.605     0.200
    13.891   193.590     0.200
    13.944   195.711     0.200
    13.960   194.266     0.200
    13.986   194.695     0.200
    13.994   197.289     0.200
    14.070   196.590     0.200
    14.070   195.297     0.200
    14.120   195.391     0.200
    14.106   197.203     0.200
    14.128   193.883     0.200
    14.126   196.180     0.200
    14.161   197.734     0.200
    14.178   198.793     0.200
    14.209   197.914     0.200
    14.218   200.430     0.200
    14.298   200.512     0.200
    14.446   201.715     0.200
    14.495   200.074     0.200
    14.523   199.961     0.200
    14.556   200.840     0.200
    14.618   204.371     0.200
    14.823   206.426     0.200
    14.931   207.465     0.200
    14.942   207.844     0.200
    14.972   208.422     0.200
    15.067   209.320     0.200
    15.102   207.492     0.200
    15.112   210.410     0.200
    15.142   209.750     0.200
    15.170   210.531     0.200
    15.232   210.930     0.200
    15.274   211.355     0.200
    15.309   211.875     0.200
    15.429   212.836     0.200
    15.482   214.301     0.200
    15.518   212.652     0.200
    15.621   215.262     0.200
    15.732   215.828     0.200
    15.906   219.844     0.200
    15.939   220.555     0.200
    15.999   219.719     0.200
    16.031   220.441     0.200
    16.205   223.008     0.200
    16.245   222.215     0.200
    16.258   223.441     0.200
    16.338   226.727     0.200
    16.346   225.094     0.200
    16.449   226.867     0.200
    16.470   226.398     0.200
    16.475   227.715     0.200
    16.475   225.594     0.200
    16.632   227.238     0.200
    16.753   231.090     0.200
    16.753   229.523     0.200
    16.852   229.973     0.200
    17.305   235.691     0.200
    17.856   243.191     0.200
    17.856   243.340     0.200
    18.489   253.672     0.200
    19.509   264.684     0.200
     0.699    13.367     0.200
     0.699    13.633     0.200
     0.724    13.633     0.200
     0.723    13.125     0.200
     0.917    17.945     0.200
     1.019    20.008     0.200
     1.734    29.234     0.200
     1.762    29.344     0.200
     1.763    29.812     0.200
     2.123    34.195     0.200
     2.123    33.906     0.200
     3.185    48.141     0.200
     3.185    48.422     0.200
     4.205    61.703     0.200
     4.205    62.008     0.200
     4.513    67.125     0.200
     4.543    66.742     0.200
     4.594    67.797     0.200
     4.594    67.922     0.200
     4.617    69.156     0.200
     4.668    68.953     0.200
     4.937    71.031     0.200
     4.937    71.414     0.200
     5.106    75.109     0.200
     5.146    74.781     0.200
     5.146    75.227     0.200
     5.281    77.508     0.200
     5.492    80.117     0.200
     5.519    80.438     0.200
     5.519    80.648     0.200
     5.544    79.336     0.200
     5.544    79.547     0.200
     5.544    79.656     0.200
     5.622    82.312     0.200
     5.915    86.648     0.200
     5.911    86.359     0.200
     5.701    86.938     0.200
     6.034    87.086     0.200
     6.121    88.570     0.200
     6.121    88.938     0.200
     6.179    89.688     0.200
     6.179    89.438     0.200
     6.438    93.133     0.200
     6.414    93.047     0.200
     6.414    93.172     0.200
     6.467    94.492     0.200
     6.570    94.086     0.200
     6.570    95.484     0.200
     6.756    97.484     0.200
     6.975   100.562     0.200
     6.991   100.258     0.200
     7.019   101.852     0.200
     7.029   100.602     0.200
     7.088   101.570     0.200
     7.323   104.664     0.200
     7.461   105.680     0.200
     7.551   108.500     0.200
     7.593   108.844     0.200
     7.648   109.625     0.200
     7.864   112.539     0.200
     8.144   116.484     0.200
     8.167   116.188     0.200
     8.193   116.219     0.200
     8.219   117.445     0.200
     8.274   119.898     0.200
     8.633   122.773     0.200
     8.715   123.750     0.200
     8.791   125.742     0.200
     8.790   124.531     0.200
     8.991   127.242     0.200
     9.060   128.930     0.200
     9.090   128.078     0.200
     9.199   129.625     0.200
     9.238   130.867     0.200
     9.366   133.133     0.200
     9.369   135.258     0.200
     9.393   133.047     0.200
     9.442   134.180     0.200
     9.594   135.008     0.200
     9.699   136.406     0.200
     9.709   137.922     0.200
     9.841   139.969     0.200
     9.906   140.273     0.200
     9.982   139.578     0.200
    10.018   141.977     0.200
    10.078   142.125     0.200
    10.106   143.383     0.200
     9.910   143.625     0.200
    10.192   145.680     0.200
    10.180   144.008     0.200
    10.180   144.547     0.200
    10.291   145.766     0.200
    10.302   145.438     0.200
    10.302   145.062     0.200
    10.315   145.711     0.200
    10.298   145.562     0.200
    10.342   145.453     0.200
    10.411   146.164     0.200
    10.429   146.172     0.200
    10.189   147.867     0.200
    10.474   148.492     0.200
    10.579   149.430     0.200
    10.633   151.383     0.200
    10.675   150.273     0.200
    10.677   149.711     0.200
    10.676   151.305     0.200
    10.676   151.516     0.200
    10.778   152.688     0.200
    10.859   153.602     0.200
    10.896   151.516     0.200
    10.909   153.281     0.200
    11.003   154.555     0.200
    11.096   156.617     0.200
    11.169   158.695     0.200
    11.238   158.688     0.200
    11.226   158.742     0.200
    11.226   158.898     0.200
    11.238   157.273     0.200
    11.244   156.844     0.200
    11.304   159.945     0.200
    11.293   158.172     0.200
    11.411   161.055     0.200
    11.471   160.812     0.200
    11.468   162.500     0.200
    11.532   163.438     0.200
    11.550   162.328     0.200
    11.647   164.023     0.200
    11.698   165.023     0.200
    11.857   166.570     0.200
    11.919   167.414     0.200
    11.942   167.695     0.200
    11.976   168.992     0.200
    11.993   166.125     0.200
    12.067   169.703     0.200
    12.098   170.602     0.200
    12.186   171.008     0.200
    12.283   169.352     0.200
    12.284   173.266     0.200
    12.317   172.445     0.200
    12.393   173.508     0.200
    12.400   173.602     0.200
    12.457   175.617     0.200
    12.493   174.727     0.200
    12.563   176.242     0.200
    12.612   174.734     0.200
    12.650   178.398     0.200
    12.412   177.062     0.200
    12.788   181.047     0.200
    12.824   179.602     0.200
    12.874   179.828     0.200
    12.893   179.188     0.200
    12.936   182.383     0.200
    12.936   181.148     0.200
    12.939   181.883     0.200
    13.065   184.594     0.200
    13.145   183.344     0.200
    13.181   185.406     0.200
    13.227   184.617     0.200
    13.460   188.953     0.200
    13.433   188.375     0.200
    13.465   189.461     0.200
    13.798   195.344     0.200
    13.809   195.359     0.200
    13.891   196.484     0.200
    13.955   194.641     0.200
    14.022   197.891     0.200
    13.999   195.922     0.200
    14.090   197.281     0.200
    14.220   199.234     0.200
    14.211   197.289     0.200
    14.373   200.391     0.200
    14.455   200.758     0.200
    14.488   201.773     0.200
    14.475   200.812     0.200
    14.632   204.492     0.200
    14.614   204.734     0.200
    14.721   204.961     0.200
    14.813   206.008     0.200
    14.820   205.328     0.200
    14.896   206.383     0.200
    14.908   205.336     0.200
    14.876   207.375     0.200
    14.948   209.250     0.200
    14.944   207.828     0.200
    14.923   208.609     0.200
    15.078   210.570     0.200
    15.043   210.219     0.200
    15.245   212.766     0.200
    15.251   212.555     0.200
    15.446   216.250     0.200
    15.744   219.961     0.200
    15.755   219.461     0.200
    15.886   219.539     0.200
    15.895   220.539     0.200
    15.838   220.836     0.200
    15.974   222.031     0.200
    16.037   222.656     0.200
    16.103   223.391     0.200
    16.133   222.000     0.200
    16.153   224.422     0.200
    16.251   225.305     0.200
    16.412   227.391     0.200
    16.521   229.531     0.200
    16.710   231.945     0.200
    16.826   233.312     0.200
    16.879   233.312     0.200
    16.883   232.961     0.200
    17.028   233.852     0.200
    17.062   234.445     0.200
    17.171   236.648     0.200
    17.250   237.523     0.200
    17.293   235.742     0.200
    17.293   236.984     0.200
    17.384   238.797     0.200
    17.528   239.734     0.200
    17.642   241.500     0.200
    18.089   247.133     0.200
    19.544   266.414     0.200
     0.687    13.465     0.200
     0.704    13.212     0.200
     0.702    13.104     0.200
     0.779    15.944     0.200
     0.907    17.914     0.200
     0.922    17.975     0.200
     0.969    18.984     0.200
     1.025    19.845     0.200
     1.570    26.385     0.200
     1.718    28.904     0.200
     1.747    29.786     0.200
     1.748    29.715     0.200
     1.748    29.414     0.200
     2.548    40.124     0.200
     2.704    42.734     0.200
     3.164    48.124     0.200
     3.142    50.715     0.200
     3.744    56.614     0.200
     3.849    58.684     0.200
     3.894    58.914     0.200
     3.966    59.725     0.200
     4.184    61.794     0.200
     4.184    61.906     0.200
     4.495    66.484     0.200
     4.495    66.875     0.200
     4.532    66.794     0.200
     4.532    66.959     0.200
     4.587    67.845     0.200
     4.587    68.060     0.200
     4.581    68.135     0.200
     4.601    68.935     0.200
     4.617    68.432     0.200
     4.650    69.114     0.200
     4.476    69.124     0.200
     4.809    71.654     0.200
     4.917    71.234     0.200
     4.968    73.194     0.200
     5.085    75.024     0.200
     5.088    75.154     0.200
     5.106    76.084     0.200
     5.133    74.965     0.200
     5.133    75.109     0.200
     5.275    77.354     0.200
     5.275    77.609     0.200
     5.478    80.024     0.200
     5.510    80.904     0.200
     5.510    80.734     0.200
     5.524    79.328     0.200
     5.524    79.635     0.200
     5.605    82.345     0.200
     5.605    82.574     0.200
     5.640    85.204     0.200
     5.903    86.504     0.200
     5.903    86.338     0.200
     5.907    86.864     0.200
     5.907    86.536     0.200
     5.877    87.664     0.200
     5.996    88.185     0.200
     6.026    87.204     0.200
     6.115    88.831     0.200
     6.166    89.664     0.200
     6.166    89.554     0.200
     6.428    93.354     0.200
     6.428    93.109     0.200
     6.414    93.234     0.200
     6.449    93.104     0.200
     6.529    94.465     0.200
     6.529    95.632     0.200
     6.555    95.175     0.200
     6.555    95.383     0.200
     6.726    97.414     0.200
     6.750    97.715     0.200
     6.750    97.510     0.200
     6.793    98.324     0.200
     6.962   100.544     0.200
     6.973   100.685     0.200
     7.003   102.298     0.200
     7.022   100.654     0.200
     7.032   102.792     0.200
     7.078   101.599     0.200
     7.105   101.694     0.200
     7.214   103.694     0.200
     7.309   104.925     0.200
     7.414   105.654     0.200
     7.442   105.834     0.200
     7.548   108.734     0.200
     7.582   108.704     0.200
     7.640   109.734     0.200
     7.852   112.465     0.200
     7.852   112.864     0.200
     7.914   113.435     0.200
     7.957   113.854     0.200
     7.960   115.493     0.200
     7.977   115.419     0.200
     8.130   116.744     0.200
     8.156   116.409     0.200
     8.174   116.465     0.200
     8.174   116.653     0.200
     8.214   117.354     0.200
     8.258   120.059     0.200
     8.306   117.965     0.200
     8.251   120.095     0.200
     8.345   121.364     0.200
     8.358   121.385     0.200
     8.388   121.754     0.200
     8.625   122.754     0.200
     8.625   122.609     0.200
     8.697   123.444     0.200
     8.697   124.512     0.200
     8.781   124.404     0.200
     8.781   123.994     0.200
     8.775   125.435     0.200
     8.775   126.320     0.200
     8.971   126.664     0.200
     8.971   126.914     0.200
     9.035   128.215     0.200
     9.048   128.145     0.200
     9.048   128.388     0.200
     9.071   127.935     0.200
     9.071   128.494     0.200
     9.179   130.290     0.200
     9.229   130.944     0.200
     9.229   131.461     0.200
     9.254   132.124     0.200
     9.352   132.334     0.200
     9.352   132.508     0.200
     9.354   134.897     0.200
     9.375   132.425     0.200
     9.375   133.092     0.200
     9.425   135.007     0.200
     9.450   133.104     0.200
     9.562   134.654     0.200
     9.575   134.324     0.200
     9.575   134.584     0.200
     9.681   136.834     0.200
     9.681   136.158     0.200
     9.696   137.024     0.200
     9.696   137.617     0.200
     9.510   136.944     0.200
     9.756   136.425     0.200
     9.826   139.084     0.200
     9.826   139.844     0.200
     9.888   139.893     0.200
     9.779   140.744     0.200
     9.962   139.765     0.200
     9.962   140.206     0.200
    10.011   141.664     0.200
    10.059   141.784     0.200
    10.059   142.018     0.200
    10.093   142.895     0.200
    10.093   143.213     0.200
     9.930   143.885     0.200
     9.930   143.135     0.200
    10.177   145.241     0.200
    10.176   144.784     0.200
    10.176   144.434     0.200
    10.219   144.895     0.200
    10.234   143.904     0.200
    10.251   143.254     0.200
    10.279   145.594     0.200
    10.293   145.455     0.200
    10.299   147.192     0.200
    10.278   145.254     0.200
    10.324   144.305     0.200
    10.209   147.874     0.200
    10.392   146.164     0.200
    10.392   145.799     0.200
    10.411   145.705     0.200
    10.468   147.873     0.200
    10.569   149.555     0.200
    10.569   149.179     0.200
    10.620   150.506     0.200
    10.656   149.283     0.200
    10.658   149.481     0.200
    10.677   150.906     0.200
    10.771   152.235     0.200
    10.851   153.572     0.200
    10.878   150.944     0.200
    10.878   151.992     0.200
    10.892   152.784     0.200
    10.892   153.596     0.200
    10.984   154.596     0.200
    11.085   155.479     0.200
    11.165   156.448     0.200
    11.226   158.169     0.200
    11.221   159.564     0.200
    11.221   158.729     0.200
    11.219   157.862     0.200
    11.219   157.475     0.200
    11.295   158.871     0.200
    11.397   160.670     0.200
    11.453   159.699     0.200
    11.465   162.954     0.200
    11.517   162.283     0.200
    11.541   162.636     0.200
    11.530   161.657     0.200
    11.636   163.989     0.200
    11.685   164.205     0.200
    11.798   166.704     0.200
    11.798   166.284     0.200
    11.845   166.704     0.200
    11.901   167.466     0.200
    11.927   167.091     0.200
    11.967   168.746     0.200
    11.976   166.173     0.200
    12.048   168.553     0.200
    12.082   167.784     0.200
    12.082   166.914     0.200
    12.150   171.322     0.200
    12.168   170.284     0.200
    12.267   169.284     0.200
    12.267   169.484     0.200
    12.274   172.989     0.200
    12.297   172.469     0.200
    12.381   173.976     0.200
    12.384   173.903     0.200
    12.449   174.654     0.200
    12.458   174.613     0.200
    12.474   175.457     0.200
    12.543   175.637     0.200
    12.595   174.784     0.200
    12.431   177.124     0.200
    12.639   177.920     0.200
    12.780   179.921     0.200
    12.804   179.403     0.200
    12.848   180.608     0.200
    12.855   179.760     0.200
    12.874   179.175     0.200
    12.926   182.043     0.200
    12.917   181.194     0.200
    12.919   181.599     0.200
    13.052   184.209     0.200
    13.059   183.978     0.200
    13.131   184.456     0.200
    13.161   184.982     0.200
    13.210   184.825     0.200
    13.279   186.394     0.200
    13.453   189.705     0.200
    13.413   188.375     0.200
    13.445   189.389     0.200
    13.446   188.897     0.200
    13.498   189.847     0.200
    13.558   189.648     0.200
    13.652   190.628     0.200
    13.788   194.233     0.200
    13.803   194.215     0.200
    13.813   193.788     0.200
    13.884   195.759     0.200
    13.914   195.670     0.200
    13.900   194.749     0.200
    13.935   194.560     0.200
    14.014   198.994     0.200
    14.014   197.287     0.200
    14.025   196.983     0.200
    13.979   195.650     0.200
    14.069   197.310     0.200
    14.134   198.684     0.200
    14.163   198.313     0.200
    14.209   199.862     0.200
    14.192   198.602     0.200
    14.253   198.485     0.200
    14.312   199.358     0.200
    14.353   199.693     0.200
    14.404   200.742     0.200
    14.438   200.434     0.200
    14.482   201.521     0.200
    14.468   201.721     0.200
    14.454   201.824     0.200
    14.618   203.744     0.200
    14.593   203.535     0.200
    14.701   204.254     0.200
    14.751   203.859     0.200
    14.781   205.808     0.200
    14.798   204.979     0.200
    14.800   206.056     0.200
    14.879   205.499     0.200
    14.891   205.234     0.200
    14.855   207.095     0.200
    14.935   208.321     0.200
    14.926   207.696     0.200
    14.903   207.927     0.200
    14.952   207.412     0.200
    15.065   209.235     0.200
    15.023   209.671     0.200
    15.229   212.056     0.200
    15.235   212.435     0.200
    15.244   211.941     0.200
    15.249   212.071     0.200
    15.465   214.811     0.200
    15.426   214.726     0.200
    15.517   215.208     0.200
    15.636   217.146     0.200
    15.725   218.273     0.200
    15.735   218.676     0.200
    15.869   219.734     0.200
    15.882   219.930     0.200
    15.818   220.019     0.200
    15.954   221.280     0.200
    15.984   221.697     0.200
    16.019   221.810     0.200
    16.052   221.432     0.200
    16.089   222.061     0.200
    16.112   223.113     0.200
    16.132   223.425     0.200
    16.235   223.712     0.200
    16.294   224.571     0.200
    16.395   226.154     0.200
    16.503   227.537     0.200
    16.577   228.799     0.200
    16.698   230.516     0.200
    16.690   231.378     0.200
    16.798   230.904     0.200
    16.805   231.136     0.200
    16.865   231.551     0.200
    16.869   231.606     0.200
    17.010   232.997     0.200
    17.044   234.310     0.200
    17.069   234.599     0.200
    17.175   235.608     0.200
    17.151   235.821     0.200
    17.230   236.540     0.200
    17.272   236.914     0.200
    17.368   237.616     0.200
    17.511   239.300     0.200
    17.625   240.914     0.200
    18.072   245.402     0.200
     0.382     9.827     0.200
     0.477    11.377     0.200
     0.855    15.997     0.200
     0.880    16.547     0.200
     1.040    19.047     0.200
     1.094    20.067     0.200
     1.094    20.217     0.200
     1.197    21.467     0.200
     1.216    21.797     0.200
     1.320    22.227     0.200
     1.251    22.407     0.200
     1.250    22.357     0.200
     1.275    22.867     0.200
     1.472    25.637     0.200
     1.956    31.567     0.200
     2.396    36.737     0.200
     2.385    38.547     0.200
     2.512    40.627     0.200
     2.593    41.437     0.200
     2.971    45.837     0.200
     3.120    47.977     0.200
     3.388    49.737     0.200
     3.794    57.137     0.200
     3.691    56.367     0.200
     3.860    58.057     0.200
     3.921    59.107     0.200
     3.828    59.017     0.200
     4.017    60.237     0.200
     3.991    58.377     0.200
     4.174    61.737     0.200
     4.157    61.527     0.200
     4.293    63.717     0.200
     4.305    63.937     0.200
     4.196    63.487     0.200
     4.492    66.897     0.200
     4.713    67.911     0.200
     4.713    68.167     0.200
     5.255    77.337     0.200
     5.315    78.047     0.200
     5.585    81.397     0.200
     5.700    82.377     0.200
     5.855    84.937     0.200
     5.949    86.557     0.200
     5.953    86.697     0.200
     6.272    91.217     0.200
     6.301    90.607     0.200
     6.221    90.697     0.200
     6.258    90.637     0.200
     6.334    91.527     0.200
     6.534    93.737     0.200
     6.630    95.567     0.200
     7.182   102.657     0.200
     7.214   103.347     0.200
     7.334   105.327     0.200
     7.442   106.757     0.200
     7.576   107.957     0.200
     7.906   112.317     0.200
     8.231   116.187     0.200
     8.269   117.067     0.200
     8.431   120.437     0.200
     8.581   121.177     0.200
     8.629   123.947     0.200
     8.752   123.277     0.200
     8.732   123.867     0.200
     8.947   125.147     0.200
     9.265   129.247     0.200
     9.588   134.217     0.200
    10.010   140.347     0.200
    10.416   146.497     0.200
    10.486   147.787     0.200
    10.805   151.297     0.200
    10.821   152.337     0.200
    11.001   154.647     0.200
    11.056   155.407     0.200
    11.207   154.417     0.200
    11.220   153.767     0.200
    11.469   161.137     0.200
    11.515   157.993     0.200
    11.667   163.047     0.200
    12.054   167.007     0.200
    12.353   174.277     0.200
    13.125   183.337     0.200
    13.200   183.087     0.200
    13.891   193.987     0.200
    13.957   193.467     0.200
    14.419   200.477     0.200
    14.991   207.647     0.200
    16.741   231.707     0.200
    17.843   242.717     0.200
    17.843   242.127     0.200
     0.419     9.682     0.200
     0.662    13.662     0.200
     0.820    15.521     0.200
     1.017    19.051     0.200
     1.081    19.551     0.200
     1.081    20.061     0.200
     1.210    19.961     0.200
     1.386    24.150     0.200
     1.408    24.102     0.200
     1.443    24.852     0.200
     1.447    24.941     0.200
     1.469    25.451     0.200
     1.533    26.512     0.200
     1.701    27.662     0.200
     1.669    28.221     0.200
     1.689    28.242     0.200
     1.849    29.582     0.200
     1.868    29.871     0.200
     2.204    33.582     0.200
     2.582    41.230     0.200
     2.709    43.162     0.200
     2.859    43.682     0.200
     2.936    44.912     0.200
     3.005    45.611     0.200
     3.106    46.992     0.200
     3.205    47.221     0.200
     3.669    54.980     0.200
     3.728    55.441     0.200
     3.732    55.371     0.200
     3.772    56.281     0.200
     3.794    56.541     0.200
     3.887    57.912     0.200
     3.899    58.041     0.200
     3.935    56.941     0.200
     3.885    59.721     0.200
     3.916    59.342     0.200
     3.983    59.092     0.200
     3.986    60.650     0.200
     3.988    60.912     0.200
     3.994    60.820     0.200
     4.042    59.701     0.200
     4.014    61.492     0.200
     4.023    61.871     0.200
     4.052    61.672     0.200
     4.162    61.602     0.200
     4.183    62.332     0.200
     4.183    62.400     0.200
     4.213    62.422     0.200
     4.293    63.121     0.200
     4.389    66.221     0.200
     4.444    65.471     0.200
     4.476    67.070     0.200
     4.545    64.900     0.200
     4.545    65.461     0.200
     4.545    65.721     0.200
     4.613    69.301     0.200
     4.730    69.541     0.200
     4.746    69.611     0.200
     4.888    71.951     0.200
     4.985    73.242     0.200
     5.158    75.441     0.200
     5.285    77.361     0.200
     5.413    80.162     0.200
     5.451    78.771     0.200
     5.543    80.531     0.200
     5.636    82.662     0.200
     5.674    81.861     0.200
     5.725    83.051     0.200
     5.782    83.871     0.200
     5.828    83.871     0.200
     5.831    84.451     0.200
     5.829    84.852     0.200
     5.894    85.320     0.200
     6.067    87.691     0.200
     6.156    87.432     0.200
     6.179    89.621     0.200
     6.288    90.301     0.200
     6.286    90.650     0.200
     6.325    91.492     0.200
     6.358    91.922     0.200
     6.347    92.281     0.200
     6.392    92.361     0.200
     6.418    92.771     0.200
     6.395    93.182     0.200
     6.447    90.871     0.200
     6.453    92.912     0.200
     6.491    92.371     0.200
     6.521    93.592     0.200
     6.517    93.771     0.200
     6.561    94.641     0.200
     6.580    94.311     0.200
     6.963    99.980     0.200
     7.046   101.201     0.200
     7.086   101.691     0.200
     7.089   101.752     0.200
     7.113   101.172     0.200
     7.161   102.512     0.200
     7.197   102.021     0.200
     7.192   103.191     0.200
     7.213   103.422     0.200
     7.221   102.852     0.200
     7.286   104.871     0.200
     7.360   105.951     0.200
     7.368   105.230     0.200
     7.434   106.621     0.200
     7.545   107.900     0.200
     7.774   110.381     0.200
     7.863   111.852     0.200
     7.913   112.871     0.200
     8.002   113.201     0.200
     8.126   115.111     0.200
     8.138   114.980     0.200
     8.122   115.512     0.200
     8.210   116.621     0.200
     8.338   117.451     0.200
     8.385   119.801     0.200
     8.446   119.471     0.200
     8.536   120.502     0.200
     8.565   120.900     0.200
     8.595   121.082     0.200
     8.604   121.221     0.200
     8.621   121.641     0.200
     8.728   124.742     0.200
     8.761   123.582     0.200
     8.795   123.352     0.200
     8.961   126.320     0.200
     8.994   126.662     0.200
     9.006   127.811     0.200
     9.129   128.012     0.200
     9.293   130.191     0.200
     9.299   131.271     0.200
     9.351   131.400     0.200
     9.363   132.752     0.200
     9.381   131.932     0.200
     9.442   132.602     0.200
     9.436   131.971     0.200
     9.449   132.242     0.200
     9.505   132.730     0.200
     9.565   134.922     0.200
     9.642   135.832     0.200
     9.691   136.332     0.200
     9.722   136.451     0.200
     9.760   138.602     0.200
     9.797   136.682     0.200
     9.818   137.611     0.200
     9.913   139.551     0.200
     9.981   138.932     0.200
     9.984   141.252     0.200
    10.028   140.191     0.200
    10.036   140.801     0.200
    10.084   142.182     0.200
    10.262   144.162     0.200
    10.283   144.891     0.200
    10.306   144.871     0.200
    10.321   146.400     0.200
    10.446   147.570     0.200
    10.533   147.262     0.200
    10.638   149.922     0.200
    10.729   151.672     0.200
    10.723   151.502     0.200
    10.836   151.742     0.200
    10.844   153.662     0.200
    11.009   154.932     0.200
    11.143   156.922     0.200
    11.240   155.111     0.200
    11.260   157.451     0.200
    11.315   158.781     0.200
    11.408   157.107     0.200
    11.517   161.131     0.200
    11.564   162.521     0.200
    12.832   179.730     0.200
    13.250   183.912     0.200
    13.373   184.922     0.200
    13.476   186.412     0.200
    13.501   187.592     0.200
    13.614   190.621     0.200
    13.608   189.781     0.200
    14.041   196.191     0.200
    14.446   202.422     0.200
    14.660   205.182     0.200
    14.893   207.641     0.200
    15.410   215.252     0.200
    16.114   224.291     0.200
    16.175   224.781     0.200
    16.301   225.807     0.200
    16.621   230.332     0.200
    17.724   241.332     0.200
    17.724   242.361     0.200
     1.892    32.461     0.200
     1.784    32.234     0.200
     1.925    32.922     0.200
     1.925    32.691     0.200
     1.895    33.984     0.200
     1.905    33.414     0.200
     2.254    37.062     0.200
     2.709    43.352     0.200
     2.956    49.871     0.200
     3.055    50.512     0.200
     3.059    50.453     0.200
     3.083    50.633     0.200
     3.104    51.793     0.200
     3.237    50.094     0.200
     3.435    53.934     0.200
     3.661    58.383     0.200
     3.900    59.914     0.200
     3.998    61.504     0.200
     4.050    61.734     0.200
     4.128    63.312     0.200
     4.275    64.523     0.200
     4.724    70.574     0.200
     4.769    72.004     0.200
     4.781    71.523     0.200
     4.799    72.461     0.200
     4.798    72.621     0.200
     4.859    73.383     0.200
     4.956    75.031     0.200
     5.021    73.832     0.200
     5.232    78.461     0.200
     5.241    78.461     0.200
     5.277    78.824     0.200
     5.285    79.043     0.200
     5.318    79.234     0.200
     5.658    83.691     0.200
     5.637    82.117     0.200
     5.637    82.414     0.200
     5.703    84.395     0.200
     5.769    85.645     0.200
     6.098    90.172     0.200
     6.164    91.395     0.200
     6.309    93.023     0.200
     6.349    93.723     0.200
     6.595    97.234     0.200
     6.619    96.973     0.200
     6.694    98.504     0.200
     6.733    99.012     0.200
     6.881   100.594     0.200
     6.886   101.395     0.200
     6.944   101.562     0.200
     7.149   104.371     0.200
     7.174   104.984     0.200
     7.271   105.973     0.200
     7.336   107.273     0.200
     7.372   107.711     0.200
     7.398   108.062     0.200
     7.490   109.145     0.200
     7.497   109.273     0.200
     7.571   109.961     0.200
     7.773   112.023     0.200
     7.835   113.312     0.200
     8.038   116.191     0.200
     8.078   117.023     0.200
     8.113   117.543     0.200
     8.120   117.441     0.200
     8.274   119.781     0.200
     8.310   119.672     0.200
     8.347   119.973     0.200
     8.407   120.812     0.200
     8.973   128.023     0.200
     9.095   129.934     0.200
     9.211   131.602     0.200
     9.423   135.203     0.200
     9.601   137.043     0.200
     9.688   137.992     0.200
     9.886   139.773     0.200
    10.087   142.742     0.200
    10.205   144.633     0.200
    10.487   150.191     0.200
    10.965   156.824     0.200
    11.414   163.441     0.200
    12.031   171.473     0.200
    12.433   172.973     0.200
    12.567   178.664     0.200
    12.995   182.441     0.200
    13.014   182.812     0.200
    13.506   191.484     0.200
    15.251   214.242     0.200
    17.348   241.273     0.200
    17.534   243.133     0.200
     0.488    11.254     0.200
     0.488    11.145     0.200
     0.631    13.902     0.200
     0.724    15.215     0.200
     0.724    15.191     0.200
     0.841    17.312     0.200
     0.843    16.965     0.200
     0.848    16.691     0.200
     1.403    23.852     0.200
     1.537    26.332     0.200
     1.560    26.828     0.200
     1.562    26.844     0.200
     1.695    29.293     0.200
     1.822    30.965     0.200
     1.900    31.895     0.200
     1.962    31.684     0.200
     1.962    31.367     0.200
     2.537    40.094     0.200
     2.931    46.254     0.200
     2.973    46.555     0.200
     3.004    46.992     0.200
     3.120    45.824     0.200
     3.120    46.227     0.200
     3.069    47.852     0.200
     3.074    48.062     0.200
     3.114    48.691     0.200
     3.142    48.965     0.200
     3.474    53.242     0.200
     3.700    55.914     0.200
     3.700    56.188     0.200
     3.798    57.383     0.200
     4.114    59.684     0.200
     4.114    59.918     0.200
     4.313    63.504     0.200
     4.337    63.660     0.200
     4.359    65.145     0.200
     4.359    64.621     0.200
     4.423    65.695     0.200
     4.430    65.922     0.200
     4.416    65.703     0.200
     4.416    65.238     0.200
     4.501    66.523     0.200
     4.497    67.984     0.200
     4.560    67.805     0.200
     4.662    69.344     0.200
     4.828    68.914     0.200
     4.828    69.047     0.200
     4.822    70.883     0.200
     4.922    72.305     0.200
     4.933    72.520     0.200
     4.927    72.832     0.200
     4.927    71.766     0.200
     5.046    74.152     0.200
     5.281    77.262     0.200
     5.281    76.738     0.200
     5.288    77.242     0.200
     5.422    76.922     0.200
     5.422    77.203     0.200
     5.422    77.613     0.200
     5.433    79.492     0.200
     5.433    79.766     0.200
     5.688    83.023     0.200
     5.678    83.281     0.200
     5.736    84.523     0.200
     5.818    84.633     0.200
     5.800    83.852     0.200
     5.887    85.602     0.200
     5.962    86.297     0.200
     6.210    89.977     0.200
     6.193    90.082     0.200
     6.193    89.977     0.200
     6.294    89.855     0.200
     6.354    92.363     0.200
     6.354    92.707     0.200
     6.361    92.156     0.200
     6.521    94.379     0.200
     6.572    95.383     0.200
     6.753    97.594     0.200
     6.753    97.375     0.200
     6.816    98.543     0.200
     6.816    98.039     0.200
     6.795    97.254     0.200
     6.820    98.941     0.200
     6.857    98.941     0.200
     6.857    98.277     0.200
     6.891    99.281     0.200
     6.891    98.801     0.200
     7.110   102.723     0.200
     7.110   101.949     0.200
     7.173   104.012     0.200
     7.308   103.203     0.200
     7.319   105.141     0.200
     7.366   105.395     0.200
     7.366   105.164     0.200
     7.413   106.254     0.200
     7.644   109.523     0.200
     7.644   108.906     0.200
     7.772   112.012     0.200
     7.790   112.324     0.200
     7.790   112.602     0.200
     7.819   110.195     0.200
     7.823   112.473     0.200
     7.918   113.664     0.200
     7.933   113.473     0.200
     7.938   113.055     0.200
     7.984   113.883     0.200
     7.985   114.102     0.200
     8.041   113.973     0.200
     8.074   115.973     0.200
     8.074   117.125     0.200
     8.135   116.473     0.200
     8.159   116.340     0.200
     8.258   118.402     0.200
     8.352   120.352     0.200
     8.363   119.453     0.200
     8.400   119.352     0.200
     8.397   120.074     0.200
     8.545   121.102     0.200
     8.545   120.223     0.200
     8.560   121.113     0.200
     8.560   120.672     0.200
     8.601   122.344     0.200
     8.601   123.379     0.200
     8.853   124.352     0.200
     8.836   125.473     0.200
     8.836   125.203     0.200
     8.872   125.332     0.200
     8.932   125.711     0.200
     9.004   127.457     0.200
     9.077   128.410     0.200
     9.082   127.781     0.200
     9.099   128.703     0.200
     9.099   128.398     0.200
     9.153   129.312     0.200
     9.167   130.266     0.200
     9.227   130.031     0.200
     9.227   129.750     0.200
     9.250   130.605     0.200
     9.294   130.562     0.200
     9.306   130.922     0.200
     9.441   132.332     0.200
     9.443   132.105     0.200
     9.487   134.426     0.200
     9.528   133.109     0.200
     9.636   136.273     0.200
     9.636   136.645     0.200
     9.739   136.902     0.200
     9.783   138.434     0.200
     9.842   137.977     0.200
     9.889   139.652     0.200
     9.889   139.922     0.200
     9.912   139.484     0.200
     9.947   141.004     0.200
     9.947   140.758     0.200
     9.931   141.805     0.200
     9.983   141.359     0.200
    10.066   141.191     0.200
    10.069   142.133     0.200
    10.118   141.980     0.200
    10.158   141.645     0.200
    10.175   142.355     0.200
    10.256   143.512     0.200
    10.256   143.371     0.200
    10.252   142.664     0.200
    10.208   145.965     0.200
    10.239   144.852     0.200
    10.349   145.965     0.200
    10.413   146.676     0.200
    10.490   147.305     0.200
    10.458   148.242     0.200
    10.458   147.355     0.200
    10.511   147.211     0.200
    10.536   147.211     0.200
    10.544   148.539     0.200
    10.626   149.945     0.200
    10.715   148.914     0.200
    10.715   150.125     0.200
    10.853   151.969     0.200
    10.869   152.727     0.200
    10.936   154.059     0.200
    10.992   154.664     0.200
    11.015   155.301     0.200
    11.074   154.703     0.200
    11.073   155.379     0.200
    11.107   155.070     0.200
    11.197   158.176     0.200
    11.236   158.824     0.200
    11.300   158.414     0.200
    11.323   158.891     0.200
    11.357   158.719     0.200
    11.409   159.387     0.200
    11.418   159.832     0.200
    11.572   162.922     0.200
    11.572   162.207     0.200
    11.636   163.383     0.200
    11.737   163.293     0.200
    11.738   162.852     0.200
    11.743   164.242     0.200
    11.802   163.590     0.200
    11.901   164.504     0.200
    11.901   165.172     0.200
    11.901   165.027     0.200
    11.912   165.598     0.200
    11.950   167.586     0.200
    12.009   168.016     0.200
    12.054   169.348     0.200
    12.090   166.402     0.200
    12.112   169.344     0.200
    12.171   171.660     0.200
    12.204   169.789     0.200
    12.202   169.711     0.200
    12.222   171.926     0.200
    12.265   171.602     0.200
    12.342   173.004     0.200
    12.425   171.902     0.200
    12.440   173.387     0.200
    12.423   174.812     0.200
    12.555   177.531     0.200
    12.660   178.449     0.200
    12.685   176.863     0.200
    12.715   177.379     0.200
    12.733   175.953     0.200
    12.788   178.184     0.200
    12.809   179.277     0.200
    12.841   181.090     0.200
    12.854   180.555     0.200
    12.932   181.254     0.200
    13.033   181.590     0.200
    13.069   182.340     0.200
    13.170   183.742     0.200
    13.226   186.441     0.200
    13.289   186.711     0.200
    13.333   186.016     0.200
    13.337   186.492     0.200
    13.344   185.879     0.200
    13.356   186.793     0.200
    13.460   186.953     0.200
    13.569   188.961     0.200
    13.574   189.387     0.200
    13.656   192.078     0.200
    13.715   191.324     0.200
    13.692   191.418     0.200
    13.813   192.004     0.200
    13.813   191.855     0.200
    13.788   194.691     0.200
    13.788   193.496     0.200
    13.837   193.016     0.200
    13.927   193.082     0.200
    13.949   195.078     0.200
    13.994   195.621     0.200
    13.990   196.297     0.200
    14.056   195.504     0.200
    14.086   195.352     0.200
    14.168   196.074     0.200
    14.200   198.164     0.200
    14.223   196.906     0.200
    14.272   197.277     0.200
    14.258   198.855     0.200
    14.374   199.344     0.200
    14.417   199.305     0.200
    14.417   200.324     0.200
    14.519   201.230     0.200
    14.581   201.727     0.200
    14.569   200.898     0.200
    14.564   201.820     0.200
    14.606   201.316     0.200
    14.697   202.980     0.200
    14.708   202.211     0.200
    14.731   202.129     0.200
    14.730   205.812     0.200
    14.789   205.102     0.200
    14.812   205.750     0.200
    14.806   205.309     0.200
    14.847   205.777     0.200
    14.856   206.863     0.200
    14.932   206.914     0.200
    15.042   208.047     0.200
    15.032   208.402     0.200
    15.050   208.230     0.200
    15.059   207.754     0.200
    15.244   212.152     0.200
    15.312   212.469     0.200
    15.351   212.781     0.200
    15.351   213.297     0.200
    15.525   214.762     0.200
    15.583   215.527     0.200
    15.672   216.465     0.200
    15.711   216.977     0.200
    15.706   216.227     0.200
    15.804   218.605     0.200
    15.836   218.406     0.200
    15.871   219.262     0.200
    15.870   219.004     0.200
    15.889   219.102     0.200
    15.889   219.484     0.200
    16.047   220.949     0.200
    16.051   221.008     0.200
    16.103   223.852     0.200
    16.103   220.836     0.200
    16.118   221.641     0.200
    16.228   223.477     0.200
    16.343   224.477     0.200
    16.675   229.301     0.200
    16.669   228.973     0.200
    16.669   229.758     0.200
    16.735   230.160     0.200
    16.846   230.266     0.200
    16.894   231.449     0.200
    16.887   232.047     0.200
    16.986   233.746     0.200
    17.191   236.266     0.200
    17.191   235.570     0.200
    17.215   235.832     0.200
    17.343   237.602     0.200
    17.465   237.469     0.200
    17.599   240.109     0.200
    17.909   243.039     0.200
     0.337     8.129     0.200
     0.459    10.441     0.200
     1.017    18.941     0.200
     1.042    19.301     0.200
     1.046    19.238     0.200
     1.070    19.680     0.200
     1.183    20.480     0.200
     1.186    20.598     0.200
     1.179    21.461     0.200
     1.351    23.531     0.200
     1.394    24.090     0.200
     1.682    27.480     0.200
     2.144    34.250     0.200
     2.107    35.520     0.200
     2.302    36.660     0.200
     2.726    41.371     0.200
     3.563    53.738     0.200
     3.878    59.039     0.200
     4.159    61.738     0.200
     4.226    63.160     0.200
     4.227    62.559     0.200
     4.286    63.230     0.200
     4.272    63.891     0.200
     4.257    62.609     0.200
     4.383    64.758     0.200
     4.374    64.641     0.200
     4.469    64.539     0.200
     4.541    66.699     0.200
     4.659    68.531     0.200
     4.669    68.648     0.200
     4.712    69.250     0.200
     4.724    70.508     0.200
     4.801    70.551     0.200
     5.077    73.012     0.200
     5.072    74.250     0.200
     5.123    74.910     0.200
     5.205    75.930     0.200
     5.249    76.719     0.200
     5.605    81.379     0.200
     5.603    81.539     0.200
     5.758    84.180     0.200
     5.826    84.039     0.200
     6.137    88.758     0.200
     6.191    89.410     0.200
     6.358    92.031     0.200
     6.565    94.391     0.200
     6.618    95.629     0.200
     6.805    97.141     0.200
     6.956    99.738     0.200
     7.285   103.770     0.200
     7.417   106.340     0.200
     7.407   106.488     0.200
     7.524   106.738     0.200
     7.701   110.270     0.200
     7.772   111.609     0.200
     8.035   114.578     0.200
     8.379   118.961     0.200
     8.506   119.828     0.200
     8.638   122.781     0.200
     8.733   124.090     0.200
     9.120   128.758     0.200
     9.316   129.871     0.200
     9.370   132.621     0.200
     9.632   135.391     0.200
     9.750   137.449     0.200
     9.957   140.211     0.200
    10.036   140.879     0.200
    10.546   148.309     0.200
    11.870   162.020     0.200
    12.441   174.039     0.200
    13.493   187.719     0.200
    14.473   202.418     0.200
    15.985   221.309     0.200
    16.831   229.645     0.200
    18.203   249.070     0.200
     0.429     9.539     0.200
     0.656    13.602     0.200
     0.808    15.121     0.200
     1.004    18.359     0.200
     1.006    18.730     0.200
     1.069    19.801     0.200
     1.069    20.000     0.200
     1.201    19.789     0.200
     1.381    23.871     0.200
     1.403    24.359     0.200
     1.439    24.668     0.200
     1.443    24.680     0.200
     1.527    26.191     0.200
     1.691    27.250     0.200
     1.666    27.770     0.200
     1.858    29.281     0.200
     2.203    33.621     0.200
     2.579    41.180     0.200
     2.729    43.469     0.200
     2.997    45.539     0.200
     3.097    46.711     0.200
     3.203    47.781     0.200
     3.661    54.711     0.200
     3.721    55.641     0.200
     3.725    55.801     0.200
     3.786    56.500     0.200
     3.763    56.410     0.200
     3.880    57.660     0.200
     3.932    56.602     0.200
     3.888    58.191     0.200
     4.035    59.719     0.200
     3.971    58.879     0.200
     4.175    61.648     0.200
     4.206    61.949     0.200
     4.171    62.059     0.200
     4.284    63.629     0.200
     4.433    65.199     0.200
     4.541    64.922     0.200
     4.389    65.781     0.200
     4.737    69.379     0.200
     4.876    72.070     0.200
     4.973    73.668     0.200
     5.149    75.309     0.200
     5.624    82.691     0.200
     5.772    83.680     0.200
     5.713    83.121     0.200
     5.820    84.379     0.200
     5.886    85.102     0.200
     6.150    87.711     0.200
     6.170    88.891     0.200
     6.317    91.500     0.200
     6.275    90.488     0.200
     6.350    91.668     0.200
     6.505    93.781     0.200
     6.551    94.320     0.200
     6.952    99.500     0.200
     7.190   102.219     0.200
     7.150   101.711     0.200
     7.180   102.441     0.200
     7.358   104.961     0.200
     7.426   106.211     0.200
     7.423   106.320     0.200
     7.851   111.801     0.200
     8.120   114.191     0.200
     8.110   115.191     0.200
     8.199   115.969     0.200
     8.374   119.141     0.200
     8.439   119.199     0.200
     8.529   121.031     0.200
     8.527   121.469     0.200
     8.590   121.660     0.200
     8.589   122.320     0.200
     8.754   123.258     0.200
     8.789   122.859     0.200
     8.716   123.828     0.200
     9.012   127.691     0.200
     8.995   127.379     0.200
     9.122   128.781     0.200
     9.353   132.410     0.200
     9.436   132.738     0.200
     9.498   133.398     0.200
     9.715   136.660     0.200
     9.748   138.102     0.200
     9.903   140.000     0.200
     9.973   140.398     0.200
    10.022   141.359     0.200
    10.257   144.168     0.200
    10.301   145.168     0.200
    10.435   147.379     0.200
    11.133   156.871     0.200
    11.904   166.281     0.200
    12.963   181.461     0.200
    15.496   214.570     0.200
    17.716   241.156     0.200
     1.153    21.836     0.200
     1.307    24.559     0.200
     1.294    24.129     0.200
     1.336    24.617     0.200
     1.309    24.488     0.200
     1.902    32.668     0.200
     1.943    34.477     0.200
     2.039    35.785     0.200
     2.123    36.758     0.200
     3.004    48.285     0.200
     3.048    49.105     0.200
     3.075    49.277     0.200
     3.154    50.508     0.200
     3.161    51.016     0.200
     3.173    50.688     0.200
     3.511    54.809     0.200
     3.511    55.137     0.200
     3.612    56.508     0.200
     3.736    58.316     0.200
     4.125    62.898     0.200
     4.188    64.016     0.200
     4.313    64.406     0.200
     4.313    64.246     0.200
     4.504    69.176     0.200
     4.718    70.656     0.200
     4.535    69.457     0.200
     4.787    71.457     0.200
     4.808    71.758     0.200
     4.858    72.855     0.200
     4.919    73.457     0.200
     4.923    73.438     0.200
     4.941    74.945     0.200
     4.987    75.246     0.200
     5.013    75.738     0.200
     5.077    74.406     0.200
     5.077    74.168     0.200
     5.078    75.695     0.200
     5.442    81.059     0.200
     5.512    82.535     0.200
     5.705    82.602     0.200
     5.648    84.879     0.200
     5.919    87.488     0.200
     6.301    93.309     0.200
     6.322    93.535     0.200
     6.342    94.676     0.200
     6.544    95.418     0.200
     6.729    98.445     0.200
     7.081   103.426     0.200
     7.182   104.926     0.200
     7.345   105.738     0.200
     7.337   107.398     0.200
     7.348   107.207     0.200
     7.680   109.688     0.200
     7.674   112.168     0.200
     8.388   121.156     0.200
     8.342   122.277     0.200
     8.423   121.309     0.200
     8.423   122.828     0.200
     8.966   129.105     0.200
     9.316   132.469     0.200
     9.529   136.105     0.200
     9.952   141.547     0.200
     9.977   140.629     0.200
    10.081   144.578     0.200
    10.630   150.977     0.200
    10.868   154.266     0.200
    10.913   154.887     0.200
    10.978   155.457     0.200
    11.442   162.129     0.200
    12.239   172.906     0.200
    12.584   174.656     0.200
    12.716   179.176     0.200
    13.100   184.078     0.200
    13.118   184.078     0.200
    14.498   201.906     0.200
    15.119   209.301     0.200
    17.354   241.508     0.200
    17.905   244.977     0.200
     1.142    21.951     0.200
     1.145    21.580     0.200
     1.551    26.201     0.200
     1.557    26.781     0.200
     1.595    27.471     0.200
     1.904    30.840     0.200
     2.362    38.041     0.200
     2.520    39.820     0.200
     2.923    44.660     0.200
     2.923    44.820     0.200
     3.164    51.031     0.200
     3.207    52.461     0.200
     3.308    52.590     0.200
     3.319    53.510     0.200
     3.551    54.561     0.200
     3.379    54.410     0.200
     3.723    57.180     0.200
     3.763    57.541     0.200
     3.781    57.590     0.200
     3.699    57.961     0.200
     3.947    58.660     0.200
     3.947    58.340     0.200
     3.848    60.441     0.200
     4.243    63.621     0.200
     4.301    64.391     0.200
     4.426    65.930     0.200
     4.448    66.121     0.200
     4.433    65.180     0.200
     4.473    66.580     0.200
     4.508    67.541     0.200
     4.524    66.980     0.200
     4.605    68.670     0.200
     4.684    67.961     0.200
     4.684    68.150     0.200
     4.634    71.141     0.200
     4.716    72.301     0.200
     4.934    73.070     0.200
     4.937    73.051     0.200
     4.738    72.350     0.200
     4.998    73.150     0.200
     5.219    76.461     0.200
     5.295    76.605     0.200
     5.295    76.400     0.200
     5.295    77.451     0.200
     5.328    78.291     0.200
     5.423    79.621     0.200
     5.420    79.490     0.200
     5.882    86.531     0.200
     5.947    85.830     0.200
     6.026    87.680     0.200
     5.881    88.320     0.200
     6.061    87.910     0.200
     6.040    89.961     0.200
     6.040    89.740     0.200
     6.251    91.221     0.200
     6.320    91.830     0.200
     6.348    92.471     0.200
     6.441    93.900     0.200
     6.532    94.920     0.200
     6.598    95.891     0.200
     6.705    96.730     0.200
     6.776    98.381     0.200
     6.834    98.160     0.200
     6.892    98.531     0.200
     6.956    99.111     0.200
     6.987   101.881     0.200
     6.981   100.180     0.200
     7.023   102.971     0.200
     7.148   104.291     0.200
     7.182   102.191     0.200
     7.222   104.111     0.200
     7.228   102.850     0.200
     7.470   106.621     0.200
     7.528   108.480     0.200
     7.574   109.021     0.200
     7.768   113.250     0.200
     7.818   113.250     0.200
     7.923   113.301     0.200
     7.959   113.631     0.200
     7.978   114.150     0.200
     8.047   114.820     0.200
     8.088   117.291     0.200
     8.091   116.391     0.200
     8.121   116.621     0.200
     8.173   117.010     0.200
     8.494   122.010     0.200
     8.545   121.990     0.200
     8.593   123.400     0.200
     8.683   123.000     0.200
     8.543   125.160     0.200
     8.748   124.260     0.200
     8.627   125.861     0.200
     8.627   125.650     0.200
     8.860   124.670     0.200
     8.925   126.771     0.200
     9.054   127.600     0.200
     9.170   129.090     0.200
     9.187   132.740     0.200
     9.245   131.650     0.200
     9.340   131.451     0.200
     9.360   131.650     0.200
     9.479   133.180     0.200
     9.537   132.961     0.200
     9.566   135.941     0.200
     9.663   137.941     0.200
     9.684   136.510     0.200
     9.740   137.260     0.200
     9.740   136.611     0.200
     9.854   139.010     0.200
     9.947   141.111     0.200
    10.034   141.330     0.200
    10.046   141.010     0.200
    10.125   143.580     0.200
    10.179   143.100     0.200
    10.144   143.541     0.200
    10.207   144.070     0.200
    10.168   146.861     0.200
    10.168   146.750     0.200
    10.437   146.721     0.200
    10.449   146.750     0.200
    10.469   148.021     0.200
    10.446   150.451     0.200
    10.685   151.141     0.200
    11.006   154.730     0.200
    11.052   155.941     0.200
    11.176   157.621     0.200
    11.713   164.961     0.200
    11.740   163.920     0.200
    11.908   168.861     0.200
    11.908   165.660     0.200
    11.908   166.551     0.200
    12.087   168.611     0.200
    12.663   176.861     0.200
    12.667   180.400     0.200
    13.388   186.861     0.200
    14.104   197.121     0.200
    14.213   197.861     0.200
    14.356   201.041     0.200
    14.734   206.961     0.200
    14.789   205.871     0.200
    17.032   235.986     0.200
     0.981    17.746     0.200
     1.255    20.719     0.200
     1.255    21.004     0.200
     1.536    25.887     0.200
     1.762    29.098     0.200
     1.701    28.957     0.200
     1.742    29.246     0.200
     1.753    29.457     0.200
     1.859    30.648     0.200
     1.777    30.059     0.200
     1.930    31.016     0.200
     1.847    31.258     0.200
     1.979    30.727     0.200
     1.979    30.867     0.200
     1.965    32.648     0.200
     1.981    32.586     0.200
     2.862    44.129     0.200
     2.911    45.078     0.200
     2.861    45.969     0.200
     3.003    45.887     0.200
     3.019    45.527     0.200
     3.019    45.027     0.200
     3.019    45.219     0.200
     3.037    46.758     0.200
     3.004    47.598     0.200
     3.126    47.828     0.200
     3.068    48.117     0.200
     3.491    52.289     0.200
     3.589    53.668     0.200
     3.637    54.098     0.200
     3.680    54.605     0.200
     3.695    54.879     0.200
     3.757    56.199     0.200
     3.778    55.129     0.200
     3.778    54.941     0.200
     3.807    56.629     0.200
     3.807    56.793     0.200
     3.844    57.047     0.200
     3.995    58.566     0.200
     3.996    59.469     0.200
     3.996    59.793     0.200
     4.117    60.566     0.200
     4.154    61.328     0.200
     4.162    61.309     0.200
     4.150    61.336     0.200
     4.150    61.520     0.200
     4.099    62.469     0.200
     4.142    62.926     0.200
     4.172    63.078     0.200
     4.335    64.027     0.200
     4.239    64.027     0.200
     4.243    64.207     0.200
     4.250    64.289     0.200
     4.271    64.617     0.200
     4.284    64.637     0.200
     4.407    63.395     0.200
     4.407    63.188     0.200
     4.407    63.617     0.200
     4.395    65.316     0.200
     4.395    64.832     0.200
     4.552    66.426     0.200
     4.552    66.812     0.200
     4.753    69.746     0.200
     4.639    69.027     0.200
     4.639    68.738     0.200
     4.807    70.379     0.200
     4.807    70.578     0.200
     4.730    70.527     0.200
     4.864    72.316     0.200
     5.101    74.789     0.200
     5.101    75.078     0.200
     5.155    75.457     0.200
     5.155    75.828     0.200
     5.178    75.586     0.200
     5.178    75.719     0.200
     5.417    79.379     0.200
     5.540    79.855     0.200
     5.540    80.332     0.200
     5.679    82.105     0.200
     5.679    82.484     0.200
     5.577    82.219     0.200
     5.724    83.188     0.200
     5.659    83.379     0.200
     5.838    84.535     0.200
     5.875    86.117     0.200
     5.933    86.098     0.200
     5.968    87.309     0.200
     5.968    86.824     0.200
     6.204    89.648     0.200
     6.204    90.148     0.200
     6.342    91.898     0.200
     6.390    92.316     0.200
     6.390    92.199     0.200
     6.607    95.258     0.200
     6.607    95.047     0.200
     6.629    95.828     0.200
     6.625    96.129     0.200
     6.666    95.938     0.200
     6.666    95.727     0.200
     6.770    96.727     0.200
     6.770    96.926     0.200
     6.720    97.727     0.200
     6.720    97.848     0.200
     6.720    97.492     0.200
     6.826    99.398     0.200
     6.906   101.766     0.200
     7.073   101.086     0.200
     7.089   101.668     0.200
     7.234   103.848     0.200
     7.255   103.738     0.200
     7.255   104.023     0.200
     7.377   105.758     0.200
     7.377   106.363     0.200
     7.425   106.387     0.200
     7.452   107.148     0.200
     7.452   107.281     0.200
     7.522   108.027     0.200
     7.522   108.316     0.200
     7.672   109.539     0.200
     7.672   109.719     0.200
     7.882   112.008     0.200
     7.907   112.410     0.200
     8.044   113.656     0.200
     8.044   114.387     0.200
     8.052   114.809     0.200
     8.075   115.176     0.200
     8.105   115.188     0.200
     8.105   115.352     0.200
     8.287   117.941     0.200
     8.287   118.027     0.200
     8.287   118.219     0.200
     8.351   118.383     0.200
     8.381   119.059     0.200
     8.479   119.707     0.200
     8.488   120.926     0.200
     8.525   120.105     0.200
     8.560   121.758     0.200
     8.560   121.410     0.200
     8.560   122.547     0.200
     8.560   122.020     0.200
     8.589   121.523     0.200
     8.659   122.449     0.200
     8.689   121.367     0.200
     8.705   123.488     0.200
     8.875   125.629     0.200
     8.875   125.488     0.200
     8.897   126.113     0.200
     8.892   126.559     0.200
     9.052   128.969     0.200
     9.052   128.852     0.200
     9.062   128.309     0.200
     9.062   128.578     0.200
     9.096   129.199     0.200
     9.152   129.188     0.200
     9.191   129.848     0.200
     9.250   130.527     0.200
     9.323   130.957     0.200
     9.351   131.809     0.200
     9.351   132.297     0.200
     9.408   132.809     0.200
     9.410   133.516     0.200
     9.433   134.105     0.200
     9.433   133.746     0.200
     9.433   133.008     0.200
     9.433   133.699     0.200
     9.461   133.418     0.200
     9.464   133.508     0.200
     9.575   134.508     0.200
     9.481   136.066     0.200
     9.496   135.039     0.200
     9.521   135.598     0.200
     9.533   136.078     0.200
     9.650   136.746     0.200
     9.650   136.055     0.200
     9.680   136.168     0.200
     9.565   136.328     0.200
     9.754   137.816     0.200
     9.754   138.195     0.200
     9.746   138.188     0.200
     9.746   138.375     0.200
     9.784   137.438     0.200
     9.912   140.176     0.200
     9.912   140.398     0.200
     9.929   139.977     0.200
     9.944   138.836     0.200
     9.944   140.219     0.200
     9.994   141.434     0.200
    10.030   140.625     0.200
    10.068   142.836     0.200
    10.068   142.500     0.200
    10.093   142.238     0.200
    10.112   142.242     0.200
    10.117   144.059     0.200
    10.117   143.797     0.200
    10.152   142.969     0.200
    10.188   143.816     0.200
    10.209   144.102     0.200
    10.283   145.848     0.200
    10.447   147.023     0.200
    10.474   147.008     0.200
    10.502   148.609     0.200
    10.500   148.527     0.200
    10.556   148.887     0.200
    10.634   150.129     0.200
    10.691   150.793     0.200
    10.694   150.207     0.200
    10.722   148.418     0.200
    10.765   151.379     0.200
    10.860   153.777     0.200
    10.860   154.324     0.200
    10.889   153.668     0.200
    10.967   154.684     0.200
    11.005   155.113     0.200
    11.023   155.406     0.200
    11.059   155.668     0.200
    11.044   156.441     0.200
    11.067   156.746     0.200
    11.095   153.719     0.200
    11.140   155.891     0.200
    11.141   156.605     0.200
    11.141   156.875     0.200
    11.151   156.797     0.200
    11.213   157.805     0.200
    11.102   157.328     0.200
    11.243   157.129     0.200
    11.243   155.875     0.200
    11.243   155.438     0.200
    11.246   158.754     0.200
    11.400   155.426     0.200
    11.416   160.352     0.200
    11.416   160.215     0.200
    11.450   161.051     0.200
    11.428   161.367     0.200
    11.468   162.188     0.200
    11.468   161.895     0.200
    11.379   161.059     0.200
    11.545   162.137     0.200
    11.575   162.688     0.200
    11.689   161.961     0.200
    11.702   162.789     0.200
    11.766   165.734     0.200
    11.805   166.129     0.200
    11.825   166.066     0.200
    11.813   166.855     0.200
    11.851   167.102     0.200
    12.014   169.191     0.200
    12.050   169.621     0.200
    12.110   171.102     0.200
    12.136   171.254     0.200
    12.163   171.281     0.200
    12.250   171.738     0.200
    12.250   172.488     0.200
    12.315   172.359     0.200
    12.327   174.793     0.200
    12.346   172.176     0.200
    12.420   173.316     0.200
    12.420   175.527     0.200
    12.421   175.086     0.200
    12.421   175.418     0.200
    12.455   175.703     0.200
    12.452   175.797     0.200
    12.675   178.309     0.200
    12.745   178.371     0.200
    12.794   178.574     0.200
    12.841   179.359     0.200
    12.828   180.449     0.200
    12.850   180.004     0.200
    12.868   180.234     0.200
    12.869   180.586     0.200
    12.877   180.262     0.200
    12.901   181.113     0.200
    13.069   183.512     0.200
    13.167   186.758     0.200
    13.167   185.441     0.200
    13.222   185.324     0.200
    13.256   184.066     0.200
    13.289   186.180     0.200
    13.294   185.637     0.200
    13.294   185.930     0.200
    13.290   187.102     0.200
    13.325   186.918     0.200
    13.424   188.176     0.200
    13.476   189.035     0.200
    13.509   189.109     0.200
    13.516   189.258     0.200
    13.610   190.156     0.200
    13.610   190.699     0.200
    13.591   191.059     0.200
    13.606   190.535     0.200
    13.601   190.793     0.200
    13.673   191.656     0.200
    13.673   191.547     0.200
    13.668   191.910     0.200
    13.669   192.027     0.200
    13.669   191.543     0.200
    13.593   190.668     0.200
    13.720   192.125     0.200
    13.724   191.949     0.200
    13.724   192.484     0.200
    13.729   192.016     0.200
    13.729   192.238     0.200
    13.791   194.328     0.200
    13.874   195.027     0.200
    13.874   194.602     0.200
    13.882   194.387     0.200
    13.882   194.684     0.200
    13.911   193.980     0.200
    13.913   194.203     0.200
    13.932   194.773     0.200
    13.936   195.316     0.200
    13.973   195.109     0.200
    14.016   196.258     0.200
    14.089   197.523     0.200
    14.256   199.676     0.200
    14.257   199.758     0.200
    14.272   199.684     0.200
    14.354   199.977     0.200
    14.423   200.336     0.200
    14.435   201.906     0.200
    14.435   201.164     0.200
    14.479   201.480     0.200
    14.522   202.699     0.200
    14.549   203.168     0.200
    14.637   204.008     0.200
    14.697   204.762     0.200
    14.727   205.383     0.200
    14.793   206.254     0.200
    14.841   206.793     0.200
    14.851   206.832     0.200
    14.921   207.891     0.200
    14.935   207.609     0.200
    14.945   207.922     0.200
    15.014   208.504     0.200
    15.011   208.918     0.200
    15.222   211.324     0.200
    15.272   211.887     0.200
    15.379   212.418     0.200
    15.404   212.934     0.200
    15.418   213.324     0.200
    15.469   213.742     0.200
    15.513   215.113     0.200
    15.508   215.816     0.200
    15.543   215.551     0.200
    15.632   216.957     0.200
    16.037   222.246     0.200
    16.042   221.777     0.200
    16.042   222.367     0.200
    16.067   222.555     0.200
    16.090   223.477     0.200
    16.090   222.980     0.200
    16.117   222.938     0.200
    16.151   223.598     0.200
    16.224   224.344     0.200
    16.372   225.770     0.200
    16.494   226.691     0.200
    16.586   228.664     0.200
    16.661   229.297     0.200
    17.690   240.926     0.200
    17.690   241.852     0.200
    17.690   241.996     0.200
    19.655   266.156     0.200
     1.061    20.016     0.200
     1.142    21.414     0.200
     1.157    21.656     0.200
     1.163    21.945     0.200
     1.266    23.227     0.200
     1.268    23.008     0.200
     1.443    24.906     0.200
     1.651    28.109     0.200
     2.197    37.375     0.200
     2.270    38.469     0.200
     2.390    38.625     0.200
     2.466    40.062     0.200
     2.486    40.203     0.200
     2.546    41.055     0.200
     2.553    41.133     0.200
     3.294    53.188     0.200
     3.294    52.930     0.200
     3.440    54.508     0.200
     3.659    56.664     0.200
     3.659    56.414     0.200
     3.719    56.859     0.200
     3.776    57.945     0.200
     3.781    59.188     0.200
     3.781    58.867     0.200
     3.930    60.945     0.200
     4.252    64.125     0.200
     4.318    64.898     0.200
     4.318    64.633     0.200
     4.344    65.297     0.200
     4.457    65.805     0.200
     4.460    67.258     0.200
     4.460    66.766     0.200
     4.507    67.492     0.200
     4.512    67.133     0.200
     4.512    66.945     0.200
     4.529    67.555     0.200
     4.529    67.164     0.200
     4.620    68.664     0.200
     4.651    67.234     0.200
     4.712    71.625     0.200
     4.904    72.914     0.200
     4.794    73.148     0.200
     4.818    73.133     0.200
     4.974    73.703     0.200
     4.974    74.234     0.200
     4.850    73.758     0.200
     4.879    74.203     0.200
     5.059    74.898     0.200
     5.059    74.328     0.200
     5.270    76.305     0.200
     5.270    76.125     0.200
     5.270    76.797     0.200
     5.270    77.094     0.200
     5.317    78.484     0.200
     5.379    79.305     0.200
     5.450    80.555     0.200
     5.503    81.125     0.200
     5.503    80.805     0.200
     5.580    81.469     0.200
     5.580    82.117     0.200
     5.853    86.367     0.200
     5.861    86.695     0.200
     5.861    86.086     0.200
     5.990    88.188     0.200
     6.036    88.086     0.200
     6.083    88.625     0.200
     6.083    88.836     0.200
     6.158    89.617     0.200
     6.037    89.766     0.200
     6.168    92.086     0.200
     6.168    90.953     0.200
     6.168    91.156     0.200
     6.263    91.805     0.200
     6.376    93.430     0.200
     6.394    93.422     0.200
     6.445    94.398     0.200
     6.445    94.078     0.200
     6.548    95.914     0.200
     6.551    96.016     0.200
     6.562    96.039     0.200
     6.614    96.539     0.200
     6.790    99.328     0.200
     6.790    98.039     0.200
     6.806    98.688     0.200
     6.868    99.258     0.200
     6.868   100.320     0.200
     6.888    98.625     0.200
     6.897   100.492     0.200
     7.005   101.445     0.200
     7.049   101.547     0.200
     7.049   101.414     0.200
     7.060   102.164     0.200
     7.071   103.367     0.200
     7.133   104.430     0.200
     7.168   104.688     0.200
     7.212   105.188     0.200
     7.224   103.039     0.200
     7.224   103.727     0.200
     7.240   105.195     0.200
     7.542   107.984     0.200
     7.542   108.398     0.200
     7.637   110.445     0.200
     7.637   110.305     0.200
     7.666   110.398     0.200
     7.666   110.812     0.200
     7.758   112.617     0.200
     7.782   112.383     0.200
     7.797   113.031     0.200
     7.826   111.305     0.200
     7.862   113.023     0.200
     7.862   113.750     0.200
     7.924   114.703     0.200
     7.927   113.562     0.200
     7.953   113.383     0.200
     7.953   114.758     0.200
     8.027   115.469     0.200
     8.027   116.312     0.200
     8.091   116.188     0.200
     8.091   116.688     0.200
     8.120   116.984     0.200
     8.123   117.797     0.200
     8.123   117.109     0.200
     8.145   116.969     0.200
     8.275   118.828     0.200
     8.502   120.969     0.200
     8.502   122.305     0.200
     8.620   123.016     0.200
     8.620   123.852     0.200
     8.632   123.602     0.200
     8.572   124.695     0.200
     8.594   125.523     0.200
     8.732   124.008     0.200
     8.732   124.555     0.200
     8.632   126.227     0.200
     8.762   124.930     0.200
     8.666   126.336     0.200
     8.680   126.695     0.200
     8.708   126.383     0.200
     8.858   125.414     0.200
     8.858   126.445     0.200
     8.926   126.625     0.200
     8.991   128.648     0.200
     9.064   129.086     0.200
     9.064   129.438     0.200
     9.175   130.969     0.200
     9.175   131.242     0.200
     9.224   131.094     0.200
     9.224   132.570     0.200
     9.237   131.953     0.200
     9.255   131.992     0.200
     9.262   130.727     0.200
     9.272   132.297     0.200
     9.316   132.617     0.200
     9.326   131.656     0.200
     9.353   130.875     0.200
     9.353   132.336     0.200
     9.488   133.758     0.200
     9.488   134.922     0.200
     9.527   134.062     0.200
     9.628   136.945     0.200
     9.628   137.570     0.200
     9.690   137.117     0.200
     9.690   137.703     0.200
     9.703   138.648     0.200
     9.724   138.188     0.200
     9.724   137.094     0.200
     9.724   137.852     0.200
     9.858   139.242     0.200
     9.858   139.781     0.200
     9.778   141.008     0.200
     9.832   142.094     0.200
    10.007   142.844     0.200
     9.882   142.164     0.200
    10.025   141.188     0.200
    10.022   142.336     0.200
    10.022   142.656     0.200
     9.904   142.648     0.200
    10.040   142.609     0.200
    10.064   143.250     0.200
    10.066   141.703     0.200
    10.154   143.383     0.200
    10.157   144.258     0.200
    10.174   144.195     0.200
    10.229   144.742     0.200
    10.234   145.656     0.200
    10.248   145.469     0.200
    10.290   145.844     0.200
    10.252   147.484     0.200
    10.252   147.273     0.200
    10.252   149.047     0.200
    10.422   147.617     0.200
    10.452   148.586     0.200
    10.520   149.172     0.200
    10.545   149.828     0.200
    10.546   149.680     0.200
    10.531   151.836     0.200
    10.702   151.578     0.200
    10.741   152.055     0.200
    10.760   152.141     0.200
    10.800   152.797     0.200
    10.833   153.477     0.200
    10.858   153.758     0.200
    11.014   155.781     0.200
    11.040   156.508     0.200
    11.037   155.273     0.200
    11.162   158.266     0.200
    11.242   159.016     0.200
    11.260   158.789     0.200
    11.277   158.773     0.200
    11.277   159.336     0.200
    11.276   159.789     0.200
    11.297   160.109     0.200
    11.294   159.102     0.200
    11.403   161.422     0.200
    11.405   160.695     0.200
    11.558   162.758     0.200
    11.600   163.992     0.200
    11.602   163.898     0.200
    11.725   166.047     0.200
    11.773   166.703     0.200
    11.802   166.656     0.200
    11.819   166.148     0.200
    11.812   166.859     0.200
    11.812   165.867     0.200
    11.830   166.484     0.200
    11.864   169.289     0.200
    11.940   169.383     0.200
    11.940   167.828     0.200
    11.963   168.664     0.200
    11.984   168.117     0.200
    12.030   169.820     0.200
    12.053   169.711     0.200
    12.052   169.789     0.200
    12.115   168.234     0.200
    12.115   169.125     0.200
    12.242   171.430     0.200
    12.250   172.086     0.200
    12.250   173.062     0.200
    12.250   172.359     0.200
    12.287   173.125     0.200
    12.311   172.703     0.200
    12.344   174.008     0.200
    12.429   173.500     0.200
    12.468   175.609     0.200
    12.564   177.172     0.200
    12.595   177.500     0.200
    12.643   177.750     0.200
    12.661   177.359     0.200
    12.669   178.500     0.200
    12.720   179.000     0.200
    12.786   179.867     0.200
    12.756   180.055     0.200
    12.899   181.625     0.200
    12.893   181.703     0.200
    12.974   182.219     0.200
    12.988   183.203     0.200
    13.031   182.367     0.200
    13.028   182.945     0.200
    13.059   183.312     0.200
    13.135   184.578     0.200
    13.187   185.148     0.200
    13.424   188.648     0.200
    13.465   188.727     0.200
    13.480   188.078     0.200
    13.531   189.195     0.200
    13.551   190.680     0.200
    13.551   190.539     0.200
    13.627   191.875     0.200
    13.680   192.516     0.200
    13.699   192.305     0.200
    13.754   192.594     0.200
    13.788   193.914     0.200
    13.851   193.828     0.200
    13.896   194.969     0.200
    13.898   194.234     0.200
    13.912   194.727     0.200
    13.937   195.633     0.200
    14.025   196.695     0.200
    14.105   197.180     0.200
    14.112   197.383     0.200
    14.126   197.734     0.200
    14.145   198.320     0.200
    14.147   198.734     0.200
    14.181   198.406     0.200
    14.203   198.992     0.200
    14.265   199.359     0.200
    14.315   199.734     0.200
    14.311   200.664     0.200
    14.462   202.797     0.200
    14.479   202.062     0.200
    14.521   203.195     0.200
    14.544   204.055     0.200
    14.609   203.594     0.200
    14.676   204.453     0.200
    14.707   204.867     0.200
    14.708   205.656     0.200
    14.714   204.773     0.200
    14.740   205.680     0.200
    14.745   206.273     0.200
    14.754   206.633     0.200
    14.851   207.297     0.200
    14.992   209.625     0.200
    15.079   210.828     0.200
    15.099   211.117     0.200
    15.127   211.758     0.200
    15.209   212.383     0.200
    15.386   215.898     0.200
    15.309   212.180     0.200
    15.433   215.258     0.200
    15.445   215.523     0.200
    15.422   215.570     0.200
    15.514   217.242     0.200
    15.586   217.641     0.200
    15.689   218.672     0.200
    15.719   220.328     0.200
    15.816   219.977     0.200
    15.817   220.391     0.200
    15.991   222.555     0.200
    16.007   222.562     0.200
    16.097   223.891     0.200
    16.140   224.555     0.200
    16.223   224.984     0.200
    16.319   226.305     0.200
    16.755   232.539     0.200
    16.769   232.336     0.200
    16.832   232.766     0.200
    16.844   233.086     0.200
    16.901   235.070     0.200
    17.046   236.211     0.200
    17.215   238.141     0.200
    17.340   239.945     0.200
    17.439   240.703     0.200
    20.039   271.516     0.200
     0.419     9.941     0.200
     0.851    16.382     0.200
     0.897    17.452     0.200
     0.896    17.332     0.200
     0.916    17.672     0.200
     0.929    18.032     0.200
     1.028    19.691     0.200
     1.258    21.742     0.200
     1.422    24.002     0.200
     1.412    24.312     0.200
     1.447    24.941     0.200
     1.496    25.492     0.200
     1.935    33.122     0.200
     2.075    34.682     0.200
     2.234    35.242     0.200
     2.140    35.492     0.200
     2.314    36.612     0.200
     2.327    36.592     0.200
     2.394    37.552     0.200
     2.391    37.771     0.200
     3.169    49.882     0.200
     3.211    49.602     0.200
     3.307    51.252     0.200
     3.312    51.472     0.200
     3.318    51.382     0.200
     3.321    51.441     0.200
     3.428    52.362     0.200
     3.340    51.892     0.200
     3.352    50.312     0.200
     3.533    53.782     0.200
     3.579    54.302     0.200
     3.646    55.292     0.200
     3.652    55.231     0.200
     3.711    56.072     0.200
     3.800    57.481     0.200
     3.859    58.572     0.200
     3.935    59.472     0.200
     4.129    61.521     0.200
     4.180    62.212     0.200
     4.270    62.832     0.200
     4.334    63.712     0.200
     4.339    64.162     0.200
     4.322    63.632     0.200
     4.393    65.282     0.200
     4.357    64.191     0.200
     4.472    66.392     0.200
     4.493    66.672     0.200
     4.615    65.552     0.200
     4.651    67.492     0.200
     4.769    70.302     0.200
     4.772    70.472     0.200
     4.798    70.572     0.200
     4.823    70.912     0.200
     4.733    70.602     0.200
     4.844    70.652     0.200
     5.052    73.562     0.200
     5.217    75.991     0.200
     5.217    74.112     0.200
     5.180    75.731     0.200
     5.293    76.932     0.200
     5.255    77.021     0.200
     5.465    78.012     0.200
     5.715    83.802     0.200
     5.782    83.532     0.200
     5.874    85.402     0.200
     5.893    84.862     0.200
     5.940    86.602     0.200
     6.159    88.592     0.200
     6.254    89.702     0.200
     6.538    93.832     0.200
     6.695    96.682     0.200
     6.678    96.212     0.200
     6.818    98.072     0.200
     7.012   101.082     0.200
     7.362   105.702     0.200
     7.407   106.122     0.200
     7.566   107.562     0.200
     7.831   111.432     0.200
     7.886   112.332     0.200
     7.993   113.412     0.200
     8.006   114.432     0.200
     8.380   119.322     0.200
     8.520   120.292     0.200
     8.551   122.752     0.200
     8.601   123.652     0.200
     8.635   123.072     0.200
     8.756   123.252     0.200
     8.768   124.142     0.200
     9.048   129.521     0.200
     9.249   130.262     0.200
     9.260   129.712     0.200
     9.442   132.062     0.200
     9.412   133.021     0.200
     9.521   136.412     0.200
     9.743   135.481     0.200
     9.801   138.872     0.200
     9.911   138.542     0.200
     9.971   140.802     0.200
     9.977   141.432     0.200
    10.077   141.132     0.200
    10.042   141.932     0.200
    10.170   143.652     0.200
    10.345   144.892     0.200
    10.340   144.792     0.200
    10.307   145.231     0.200
    10.563   148.322     0.200
    10.540   149.032     0.200
    10.811   151.682     0.200
    10.911   152.652     0.200
    10.961   153.312     0.200
    11.035   156.012     0.200
    11.368   159.452     0.200
    11.586   162.452     0.200
    11.559   162.722     0.200
    11.852   166.962     0.200
    11.854   167.842     0.200
    11.955   166.082     0.200
    11.955   166.712     0.200
    12.012   168.622     0.200
    12.095   170.402     0.200
    12.366   173.622     0.200
    12.539   173.682     0.200
    12.558   174.972     0.200
    12.542   177.002     0.200
    12.535   177.231     0.200
    12.662   178.242     0.200
    12.770   179.462     0.200
    12.858   179.402     0.200
    12.834   179.231     0.200
    12.991   182.032     0.200
    13.348   186.021     0.200
    13.622   189.052     0.200
    14.039   195.932     0.200
    14.124   196.672     0.200
    14.565   201.722     0.200
    14.575   202.012     0.200
    14.779   206.142     0.200
    14.923   207.602     0.200
    15.553   215.572     0.200
    15.983   220.572     0.200
    16.565   229.202     0.200
    16.728   230.342     0.200
    16.841   232.072     0.200
    17.057   233.852     0.200
    17.197   236.822     0.200
    17.309   236.912     0.200
     0.404     9.805     0.200
     0.404    10.055     0.200
     0.827    16.172     0.200
     0.871    17.367     0.200
     0.871    17.344     0.200
     0.891    17.734     0.200
     1.003    19.602     0.200
     1.046    19.438     0.200
     1.055    19.211     0.200
     1.256    21.758     0.200
     1.439    24.977     0.200
     1.441    24.961     0.200
     1.478    25.195     0.200
     1.492    25.688     0.200
     2.004    32.867     0.200
     2.055    34.328     0.200
     2.325    36.742     0.200
     2.390    37.742     0.200
     3.151    49.555     0.200
     3.194    49.875     0.200
     3.323    51.578     0.200
     3.334    51.977     0.200
     3.534    54.031     0.200
     3.579    54.164     0.200
     3.647    55.156     0.200
     3.694    56.086     0.200
     3.783    57.477     0.200
     3.842    58.344     0.200
     3.952    59.734     0.200
     4.180    62.242     0.200
     4.266    63.391     0.200
     4.257    62.727     0.200
     4.257    62.836     0.200
     4.288    63.414     0.200
     4.288    63.531     0.200
     4.315    63.906     0.200
     4.315    64.172     0.200
     4.336    63.805     0.200
     4.341    64.203     0.200
     4.341    64.461     0.200
     4.473    66.258     0.200
     4.495    66.484     0.200
     4.625    66.125     0.200
     4.625    66.305     0.200
     4.634    69.203     0.200
     4.773    69.539     0.200
     4.716    70.586     0.200
     4.794    70.727     0.200
     4.735    70.367     0.200
     4.826    70.961     0.200
     4.769    71.086     0.200
     4.836    70.633     0.200
     4.836    70.469     0.200
     5.035    73.961     0.200
     5.035    74.148     0.200
     5.173    75.547     0.200
     5.173    75.656     0.200
     5.225    73.625     0.200
     5.225    74.938     0.200
     5.225    74.031     0.200
     5.225    75.109     0.200
     5.225    75.445     0.200
     5.241    76.836     0.200
     5.241    76.188     0.200
     5.291    77.836     0.200
     5.467    79.203     0.200
     5.467    79.523     0.200
     5.618    82.109     0.200
     5.683    83.188     0.200
     5.683    83.492     0.200
     5.696    83.609     0.200
     5.767    83.492     0.200
     5.767    83.383     0.200
     5.866    84.953     0.200
     5.866    85.062     0.200
     5.876    85.102     0.200
     5.876    85.312     0.200
     5.886    85.562     0.200
     5.915    87.117     0.200
     5.915    86.664     0.200
     5.965    88.562     0.200
     6.134    88.625     0.200
     6.134    88.492     0.200
     6.147    88.812     0.200
     6.248    90.617     0.200
     6.259    90.844     0.200
     6.411    92.477     0.200
     6.416    92.664     0.200
     6.478    93.336     0.200
     6.520    94.094     0.200
     6.658    96.305     0.200
     6.658    95.430     0.200
     6.669    96.453     0.200
     6.669    96.555     0.200
     6.691    97.570     0.200
     6.719    96.523     0.200
     6.719    96.812     0.200
     6.773    96.906     0.200
     6.794    97.438     0.200
     6.805    97.344     0.200
     6.805    97.180     0.200
     6.863    98.266     0.200
     6.899    99.797     0.200
     6.923   100.312     0.200
     7.005   101.008     0.200
     7.023   102.414     0.200
     7.099   101.586     0.200
     7.131   100.773     0.200
     7.131   100.523     0.200
     7.299   104.156     0.200
     7.299   104.352     0.200
     7.342   105.766     0.200
     7.342   105.211     0.200
     7.391   106.008     0.200
     7.557   107.773     0.200
     7.602   109.906     0.200
     7.634   110.664     0.200
     7.645   110.125     0.200
     7.669   110.805     0.200
     7.669   111.016     0.200
     7.676   110.578     0.200
     7.773   111.406     0.200
     7.816   111.406     0.200
     7.825   112.172     0.200
     7.863   111.586     0.200
     7.863   112.219     0.200
     7.874   112.391     0.200
     7.946   114.977     0.200
     7.991   114.797     0.200
     7.988   113.469     0.200
     8.365   119.023     0.200
     8.365   118.906     0.200
     8.382   118.664     0.200
     8.382   119.547     0.200
     8.461   120.180     0.200
     8.507   120.523     0.200
     8.507   120.297     0.200
     8.479   122.484     0.200
     8.499   122.734     0.200
     8.533   123.344     0.200
     8.572   123.383     0.200
     8.584   123.234     0.200
     8.665   122.289     0.200
     8.618   123.938     0.200
     8.618   123.625     0.200
     8.719   122.156     0.200
     8.759   123.844     0.200
     8.758   124.250     0.200
     8.880   125.844     0.200
     8.885   124.695     0.200
     8.939   127.508     0.200
     8.970   127.477     0.200
     9.043   130.188     0.200
     9.043   129.500     0.200
     9.049   128.453     0.200
     9.061   127.633     0.200
     9.061   127.352     0.200
     9.111   129.453     0.200
     9.111   129.188     0.200
     9.135   128.266     0.200
     9.163   129.828     0.200
     9.255   129.805     0.200
     9.265   129.773     0.200
     9.265   130.234     0.200
     9.366   131.094     0.200
     9.366   131.883     0.200
     9.402   133.938     0.200
     9.447   131.438     0.200
     9.516   135.195     0.200
     9.516   135.859     0.200
     9.574   134.297     0.200
     9.574   134.875     0.200
     9.656   135.938     0.200
     9.656   135.562     0.200
     9.745   136.734     0.200
     9.745   137.469     0.200
     9.681   138.047     0.200
     9.764   137.828     0.200
     9.714   139.047     0.200
     9.793   138.711     0.200
     9.732   139.492     0.200
     9.870   140.875     0.200
     9.919   138.625     0.200
     9.942   139.984     0.200
     9.979   140.094     0.200
     9.979   140.727     0.200
     9.958   141.336     0.200
     9.986   141.461     0.200
     9.994   141.797     0.200
    10.009   140.430     0.200
    10.028   141.695     0.200
    10.028   142.062     0.200
    10.080   142.219     0.200
    10.096   141.445     0.200
    10.152   144.438     0.200
    10.152   145.328     0.200
    10.294   145.328     0.200
    10.324   145.125     0.200
    10.343   145.758     0.200
    10.351   145.219     0.200
    10.429   148.562     0.200
    10.563   148.320     0.200
    10.529   148.688     0.200
    10.579   147.703     0.200
    10.591   149.094     0.200
    10.800   152.906     0.200
    10.906   153.891     0.200
    10.915   152.984     0.200
    10.933   154.211     0.200
    10.950   153.211     0.200
    10.991   156.266     0.200
    11.022   156.172     0.200
    11.093   157.016     0.200
    11.138   155.281     0.200
    11.210   158.172     0.200
    11.223   158.180     0.200
    11.229   157.461     0.200
    11.262   159.453     0.200
    11.262   159.328     0.200
    11.356   160.188     0.200
    11.385   160.938     0.200
    11.549   162.125     0.200
    11.586   161.508     0.200
    11.617   161.914     0.200
    11.662   161.688     0.200
    11.701   163.547     0.200
    11.736   164.930     0.200
    11.755   163.336     0.200
    11.770   162.031     0.200
    11.770   165.336     0.200
    11.770   164.352     0.200
    11.770   164.250     0.200
    11.770   165.828     0.200
    11.853   166.219     0.200
    11.847   165.906     0.200
    11.944   166.234     0.200
    11.953   165.734     0.200
    11.999   169.328     0.200
    12.071   168.664     0.200
    12.086   169.633     0.200
    12.151   168.875     0.200
    12.164   170.516     0.200
    12.244   170.625     0.200
    12.280   169.586     0.200
    12.355   173.922     0.200
    12.498   174.352     0.200
    12.543   175.156     0.200
    12.561   174.094     0.200
    12.608   176.516     0.200
    12.617   176.562     0.200
    12.649   177.242     0.200
    12.643   178.328     0.200
    12.759   178.938     0.200
    12.760   179.453     0.200
    12.827   179.625     0.200
    12.897   179.750     0.200
    12.977   182.258     0.200
    13.127   184.406     0.200
    13.144   185.680     0.200
    13.148   184.367     0.200
    13.202   185.594     0.200
    13.206   184.641     0.200
    13.256   185.156     0.200
    13.443   186.844     0.200
    13.517   189.656     0.200
    13.508   188.383     0.200
    13.568   190.375     0.200
    13.610   189.508     0.200
    13.628   189.508     0.200
    13.637   191.695     0.200
    13.642   190.453     0.200
    13.713   192.047     0.200
    13.714   190.672     0.200
    13.757   193.156     0.200
    13.757   190.805     0.200
    13.787   192.406     0.200
    13.839   192.500     0.200
    13.876   192.594     0.200
    13.891   193.227     0.200
    13.947   193.883     0.200
    13.999   194.391     0.200
    14.044   195.031     0.200
    14.103   195.594     0.200
    14.123   196.219     0.200
    14.174   197.148     0.200
    14.200   197.469     0.200
    14.311   199.836     0.200
    14.315   197.688     0.200
    14.395   199.727     0.200
    14.395   199.938     0.200
    14.439   199.641     0.200
    14.501   202.000     0.200
    14.498   200.836     0.200
    14.564   202.547     0.200
    14.575   202.492     0.200
    14.596   203.359     0.200
    14.614   202.938     0.200
    14.638   202.992     0.200
    14.636   203.039     0.200
    14.731   204.305     0.200
    14.770   204.070     0.200
    14.919   206.977     0.200
    14.921   206.086     0.200
    14.936   206.891     0.200
    14.966   207.742     0.200
    15.085   208.461     0.200
    15.143   210.680     0.200
    15.192   210.523     0.200
    15.218   211.070     0.200
    15.333   213.297     0.200
    15.319   212.164     0.200
    15.412   213.391     0.200
    15.553   215.711     0.200
    15.589   215.984     0.200
    15.666   217.797     0.200
    15.689   216.578     0.200
    15.705   216.547     0.200
    15.768   216.977     0.200
    15.786   217.719     0.200
    15.836   219.828     0.200
    15.923   219.555     0.200
    15.980   219.898     0.200
    16.080   221.359     0.200
    16.188   223.055     0.200
    16.433   227.359     0.200
    16.455   226.961     0.200
    16.478   225.352     0.200
    16.478   228.211     0.200
    16.559   229.227     0.200
    16.695   229.133     0.200
    16.730   229.336     0.200
    16.757   229.719     0.200
    16.848   232.812     0.200
    16.864   231.109     0.200
    17.002   232.836     0.200
    17.002   233.914     0.200
    17.054   234.008     0.200
    17.196   235.820     0.200
    17.309   236.875     0.200
    17.472   239.383     0.200
    17.757   240.711     0.200
    17.757   241.438     0.200
    19.016   258.281     0.200
    19.321   261.484     0.200
     0.371     9.250     0.200
     0.371     9.461     0.200
     0.808    15.875     0.200
     0.844    16.820     0.200
     0.844    16.727     0.200
     0.866    17.125     0.200
     0.880    17.555     0.200
     0.977    19.102     0.200
     1.216    21.055     0.200
     1.288    22.383     0.200
     1.381    23.695     0.200
     1.413    24.242     0.200
     1.413    24.445     0.200
     1.982    32.414     0.200
     2.047    34.234     0.200
     2.303    36.094     0.200
     2.372    36.922     0.200
     2.367    37.125     0.200
     3.148    49.195     0.200
     3.190    49.750     0.200
     3.190    49.320     0.200
     3.221    50.086     0.200
     3.291    50.922     0.200
     3.300    51.156     0.200
     3.319    51.375     0.200
     3.330    51.453     0.200
     3.338    51.727     0.200
     3.359    52.031     0.200
     3.515    53.305     0.200
     3.558    53.773     0.200
     3.627    55.109     0.200
     3.628    54.750     0.200
     3.692    55.555     0.200
     3.840    58.156     0.200
     4.112    61.094     0.200
     4.159    61.680     0.200
     4.224    62.055     0.200
     4.317    63.953     0.200
     4.323    63.742     0.200
     4.286    63.406     0.200
     4.376    64.852     0.200
     4.306    63.430     0.200
     4.476    65.891     0.200
     4.616    65.930     0.200
     4.635    67.664     0.200
     4.633    68.953     0.200
     4.752    69.836     0.200
     4.753    70.086     0.200
     4.715    69.836     0.200
     4.769    70.297     0.200
     4.807    70.547     0.200
     4.733    70.133     0.200
     4.806    69.844     0.200
     5.000    73.156     0.200
     5.214    73.820     0.200
     5.214    74.172     0.200
     5.145    74.891     0.200
     5.268    76.930     0.200
     5.208    76.156     0.200
     5.449    78.953     0.200
     5.659    82.891     0.200
     5.661    82.711     0.200
     5.837    84.586     0.200
     5.842    84.516     0.200
     5.886    86.141     0.200
     5.890    87.055     0.200
     5.890    86.609     0.200
     6.115    88.281     0.200
     6.221    89.570     0.200
     6.224    89.562     0.200
     6.390    93.359     0.200
     6.485    93.477     0.200
     6.666    96.570     0.200
     6.639    95.352     0.200
     6.777    97.281     0.200
     6.739    96.297     0.200
     6.772    97.266     0.200
     6.841   100.234     0.200
     6.977    99.906     0.200
     7.077   101.727     0.200
     7.115   101.062     0.200
     7.307   105.234     0.200
     7.357   105.906     0.200
     7.527   107.406     0.200
     7.642   109.750     0.200
     7.798   111.961     0.200
     7.847   111.492     0.200
     7.797   111.531     0.200
     7.843   111.414     0.200
     7.921   114.555     0.200
     7.953   113.711     0.200
     8.331   118.477     0.200
     8.437   121.922     0.200
     8.475   119.836     0.200
     8.530   122.523     0.200
     8.652   121.891     0.200
     8.615   123.555     0.200
     8.742   123.164     0.200
     8.727   123.992     0.200
     9.042   127.445     0.200
     9.017   129.836     0.200
     9.241   129.727     0.200
     9.249   129.383     0.200
     9.432   131.672     0.200
     9.372   131.859     0.200
     9.490   135.336     0.200
     9.727   136.141     0.200
     9.677   137.430     0.200
     9.709   139.250     0.200
     9.764   138.320     0.200
     9.773   138.594     0.200
     9.968   140.953     0.200
     9.962   140.680     0.200
    10.040   140.742     0.200
     9.923   140.047     0.200
    10.064   141.133     0.200
     9.995   140.234     0.200
    10.148   144.352     0.200
    10.148   144.250     0.200
    10.337   145.555     0.200
    10.294   143.203     0.200
    10.424   148.062     0.200
    10.490   148.664     0.200
    10.953   153.445     0.200
    11.022   154.977     0.200
    11.065   156.375     0.200
    11.324   159.734     0.200
    11.356   159.797     0.200
    11.500   161.523     0.200
    11.564   161.992     0.200
    11.832   165.656     0.200
    11.819   165.164     0.200
    11.967   168.336     0.200
    12.056   169.281     0.200
    12.148   170.484     0.200
    12.323   173.883     0.200
    12.544   174.961     0.200
    12.730   177.516     0.200
    13.614   189.031     0.200
    14.028   195.750     0.200
    14.101   197.297     0.200
    14.184   197.883     0.200
    14.555   200.781     0.200
    14.597   202.570     0.200
    14.740   204.695     0.200
    15.559   215.164     0.200
    16.836   232.836     0.200
    17.174   236.000     0.200
    17.289   236.562     0.200
     1.094    19.500     0.200
     1.189    20.883     0.200
     1.226    21.883     0.200
     1.293    23.031     0.200
     1.358    23.891     0.200
     1.516    26.570     0.200
     1.527    26.406     0.200
     1.579    27.742     0.200
     1.749    29.672     0.200
     1.762    29.477     0.200
     1.762    29.820     0.200
     1.940    31.453     0.200
     2.037    32.922     0.200
     2.083    33.711     0.200
     2.627    42.812     0.200
     2.766    44.453     0.200
     2.832    45.359     0.200
     3.074    47.188     0.200
     3.217    49.320     0.200
     3.330    50.820     0.200
     3.330    51.117     0.200
     3.721    56.023     0.200
     3.809    57.211     0.200
     3.809    57.367     0.200
     3.864    58.117     0.200
     3.850    59.430     0.200
     3.893    59.289     0.200
     3.914    58.680     0.200
     3.925    59.898     0.200
     3.923    59.836     0.200
     3.923    60.336     0.200
     3.987    59.891     0.200
     3.987    60.000     0.200
     3.991    60.703     0.200
     3.994    61.086     0.200
     4.003    61.141     0.200
     4.022    61.469     0.200
     4.036    60.758     0.200
     4.077    61.406     0.200
     4.040    58.633     0.200
     4.156    62.219     0.200
     4.258    63.008     0.200
     4.381    64.953     0.200
     4.462    66.430     0.200
     4.388    65.812     0.200
     4.528    67.617     0.200
     4.536    68.070     0.200
     4.613    69.078     0.200
     4.705    69.688     0.200
     4.666    66.609     0.200
     4.980    73.156     0.200
     4.965    72.570     0.200
     4.965    72.703     0.200
     5.033    73.891     0.200
     5.167    75.531     0.200
     5.261    77.703     0.200
     5.384    77.672     0.200
     5.405    80.312     0.200
     5.427    80.117     0.200
     5.553    81.383     0.200
     5.706    82.523     0.200
     5.821    85.109     0.200
     5.821    85.492     0.200
     5.913    85.938     0.200
     6.004    87.047     0.200
     6.024    88.508     0.200
     6.099    88.961     0.200
     6.407    93.773     0.200
     6.546    94.992     0.200
     6.561    95.883     0.200
     6.611    96.453     0.200
     6.671    96.820     0.200
     6.789    97.773     0.200
     6.809    98.641     0.200
     6.858    98.703     0.200
     7.230   103.758     0.200
     7.418   106.211     0.200
     7.428   107.508     0.200
     7.470   108.586     0.200
     7.563   109.188     0.200
     7.611   109.578     0.200
     7.658   112.023     0.200
     7.812   112.070     0.200
     8.397   120.047     0.200
     8.481   121.141     0.200
     8.735   123.336     0.200
     8.942   125.188     0.200
     9.262   132.328     0.200
     9.231   131.523     0.200
     9.315   132.820     0.200
     9.612   137.836     0.200
    10.033   143.031     0.200
    10.854   154.062     0.200
    11.132   157.859     0.200
    11.288   159.031     0.200
    11.937   168.289     0.200
     0.342     7.986     0.200
     0.353     8.236     0.200
     0.527    11.486     0.200
     0.527    11.688     0.200
     0.872    15.748     0.200
     0.982    17.938     0.200
     1.061    19.297     0.200
     1.117    20.406     0.200
     1.117    20.217     0.200
     1.245    21.857     0.200
     1.294    22.467     0.200
     1.298    22.527     0.200
     1.391    24.098     0.200
     1.517    25.748     0.200
     1.535    25.697     0.200
     1.797    28.977     0.200
     1.961    31.477     0.200
     2.426    39.127     0.200
     2.553    41.037     0.200
     2.634    41.797     0.200
     3.056    46.887     0.200
     3.118    47.396     0.200
     3.210    48.707     0.200
     3.686    56.957     0.200
     3.716    55.227     0.200
     3.742    55.758     0.200
     3.728    57.688     0.200
     3.728    57.236     0.200
     3.789    56.396     0.200
     3.758    56.947     0.200
     3.854    57.758     0.200
     3.866    59.178     0.200
     3.915    58.338     0.200
     3.969    58.486     0.200
     4.085    59.188     0.200
     4.085    58.588     0.200
     4.017    59.146     0.200
     4.167    61.406     0.200
     4.231    64.688     0.200
     4.231    63.316     0.200
     4.286    63.107     0.200
     4.301    63.588     0.200
     4.319    64.557     0.200
     4.387    65.037     0.200
     4.455    66.477     0.200
     4.509    66.207     0.200
     4.692    67.887     0.200
     4.809    70.188     0.200
     4.852    70.867     0.200
     4.894    71.758     0.200
     4.977    72.598     0.200
     5.017    73.627     0.200
     5.259    77.188     0.200
     5.336    78.107     0.200
     5.523    80.127     0.200
     5.568    80.758     0.200
     5.623    82.047     0.200
     5.733    82.887     0.200
     5.867    85.117     0.200
     5.877    85.146     0.200
     6.289    90.467     0.200
     6.277    91.217     0.200
     6.271    92.887     0.200
     6.271    92.268     0.200
     6.351    92.297     0.200
     6.396    92.057     0.200
     6.558    94.027     0.200
     6.599    94.566     0.200
     6.642    95.207     0.200
     7.017   100.178     0.200
     7.230   103.447     0.200
     7.213   103.326     0.200
     7.280   104.797     0.200
     7.325   105.207     0.200
     7.356   104.607     0.200
     7.274   104.418     0.200
     7.452   106.668     0.200
     7.899   112.467     0.200
     8.021   114.406     0.200
     8.154   115.816     0.200
     8.258   116.637     0.200
     8.255   117.137     0.200
     8.735   122.316     0.200
     8.933   124.986     0.200
     9.135   127.986     0.200
     9.135   128.508     0.200
     9.076   129.217     0.200
     9.116   130.287     0.200
     9.256   130.338     0.200
     9.441   135.047     0.200
     9.576   134.867     0.200
    10.505   148.547     0.200
    11.216   158.248     0.200
    11.735   165.787     0.200
    12.061   170.268     0.200
     0.480     9.840     0.200
     0.480     9.879     0.200
     0.514    10.941     0.200
     0.514    11.109     0.200
     0.889    17.180     0.200
     0.959    18.371     0.200
     0.971    18.520     0.200
     1.086    20.629     0.200
     1.107    20.379     0.200
     1.338    22.922     0.200
     1.496    25.551     0.200
     1.533    26.152     0.200
     1.533    26.262     0.200
     1.944    33.582     0.200
     2.070    35.312     0.200
     2.078    35.211     0.200
     3.201    51.039     0.200
     3.231    51.250     0.200
     3.344    52.672     0.200
     3.371    52.961     0.200
     3.501    53.270     0.200
     3.651    55.332     0.200
     3.697    57.039     0.200
     4.198    62.570     0.200
     4.252    63.242     0.200
     4.295    63.789     0.200
     4.402    65.480     0.200
     4.406    65.281     0.200
     4.363    63.910     0.200
     4.410    65.422     0.200
     4.462    66.410     0.200
     4.452    65.859     0.200
     4.561    68.000     0.200
     4.659    67.359     0.200
     4.719    69.129     0.200
     4.634    70.191     0.200
     4.836    71.379     0.200
     4.890    71.910     0.200
     4.880    72.242     0.200
     4.934    71.871     0.200
     5.146    75.191     0.200
     5.266    76.160     0.200
     5.266    75.621     0.200
     5.349    77.820     0.200
     5.531    80.711     0.200
     5.721    83.281     0.200
     5.876    84.602     0.200
     5.962    86.000     0.200
     5.883    87.152     0.200
     5.988    86.520     0.200
     5.991    88.539     0.200
     6.251    90.312     0.200
     6.295    91.609     0.200
     6.339    91.250     0.200
     6.369    92.051     0.200
     6.483    94.512     0.200
     6.632    95.242     0.200
     6.776    98.539     0.200
     6.852    97.699     0.200
     6.884    98.180     0.200
     6.911    98.770     0.200
     6.973   102.180     0.200
     7.099   101.262     0.200
     7.189   101.879     0.200
     7.402   105.281     0.200
     7.455   106.742     0.200
     7.501   107.191     0.200
     7.655   109.039     0.200
     7.714   111.430     0.200
     7.759   111.332     0.200
     7.880   112.852     0.200
     7.920   112.910     0.200
     7.917   112.801     0.200
     7.978   113.500     0.200
     8.069   116.801     0.200
     8.100   115.379     0.200
     8.474   120.039     0.200
     8.540   123.082     0.200
     8.539   124.121     0.200
     8.613   121.699     0.200
     8.715   123.379     0.200
     8.623   124.539     0.200
     8.623   124.672     0.200
     8.819   124.789     0.200
     8.859   125.879     0.200
     9.079   128.871     0.200
     9.142   130.340     0.200
     9.306   131.062     0.200
     9.321   130.859     0.200
     9.434   132.711     0.200
     9.501   132.531     0.200
     9.501   134.332     0.200
     9.706   136.562     0.200
     9.689   138.191     0.200
     9.889   140.031     0.200
     9.875   139.750     0.200
    10.162   145.941     0.200
    10.440   149.430     0.200
    11.018   155.840     0.200
    11.648   164.301     0.200
    12.622   176.949     0.200
    12.625   176.812     0.200
    13.679   191.262     0.200
    14.198   197.289     0.200
     0.367     9.406     0.200
     0.805    15.770     0.200
     0.839    16.520     0.200
     0.862    16.816     0.200
     0.973    18.758     0.200
     1.025    18.867     0.200
     1.036    18.887     0.200
     1.230    21.098     0.200
     1.378    23.719     0.200
     1.409    24.172     0.200
     1.410    24.520     0.200
     1.903    32.207     0.200
     2.109    34.738     0.200
     3.146    48.809     0.200
     3.189    49.199     0.200
     3.219    49.559     0.200
     3.299    50.738     0.200
     3.328    51.117     0.200
     3.514    53.070     0.200
     3.691    55.629     0.200
     3.691    55.340     0.200
     4.111    60.816     0.200
     4.157    61.746     0.200
     4.157    61.262     0.200
     4.211    62.309     0.200
     4.220    62.719     0.200
     4.220    62.332     0.200
     4.261    62.859     0.200
     4.315    63.859     0.200
     4.283    63.547     0.200
     4.283    63.254     0.200
     4.302    63.879     0.200
     4.302    63.332     0.200
     4.474    66.219     0.200
     4.616    66.020     0.200
     4.616    66.199     0.200
     4.633    67.957     0.200
     4.632    68.527     0.200
     4.714    69.836     0.200
     4.732    69.969     0.200
     4.750    69.727     0.200
     4.751    69.688     0.200
     4.751    69.832     0.200
     4.766    70.629     0.200
     4.766    69.738     0.200
     4.806    70.449     0.200
     4.802    70.277     0.200
     4.802    70.145     0.200
     4.995    73.129     0.200
     4.995    72.918     0.200
     5.142    74.637     0.200
     5.214    75.102     0.200
     5.214    74.508     0.200
     5.214    74.848     0.200
     5.204    75.758     0.200
     5.204    75.652     0.200
     5.265    76.656     0.200
     5.265    76.293     0.200
     5.447    79.098     0.200
     5.447    78.570     0.200
     5.583    81.219     0.200
     5.583    81.043     0.200
     5.656    81.812     0.200
     5.656    82.648     0.200
     5.656    82.262     0.200
     5.729    82.816     0.200
     5.729    82.395     0.200
     5.833    84.422     0.200
     5.837    84.418     0.200
     5.886    86.797     0.200
     5.886    86.219     0.200
     6.112    88.773     0.200
     6.111    88.406     0.200
     6.189    90.148     0.200
     6.189    89.305     0.200
     6.218    89.734     0.200
     6.219    90.137     0.200
     6.388    93.129     0.200
     6.394    93.156     0.200
     6.455    93.469     0.200
     6.481    93.129     0.200
     6.481    93.387     0.200
     6.636    94.695     0.200
     6.635    95.508     0.200
     6.635    95.367     0.200
     6.663    96.832     0.200
     6.776    97.359     0.200
     6.735    95.867     0.200
     6.768    97.457     0.200
     6.768    97.117     0.200
     6.839    99.469     0.200
     6.899   100.707     0.200
     6.974    99.906     0.200
     7.064   100.707     0.200
     7.075   101.777     0.200
     7.113   101.496     0.200
     7.113   101.027     0.200
     7.263   103.270     0.200
     7.263   103.719     0.200
     7.302   104.520     0.200
     7.302   104.281     0.200
     7.352   105.520     0.200
     7.352   105.117     0.200
     7.523   107.488     0.200
     7.607   110.270     0.200
     7.620   107.258     0.200
     7.639   110.297     0.200
     7.639   108.730     0.200
     7.796   111.777     0.200
     7.794   111.297     0.200
     7.794   111.090     0.200
     7.846   111.598     0.200
     7.846   111.297     0.200
     7.839   112.297     0.200
     7.839   112.004     0.200
     7.918   114.156     0.200
     7.918   112.688     0.200
     7.968   112.602     0.200
     7.948   113.457     0.200
     7.948   113.348     0.200
     8.361   118.309     0.200
     8.327   118.367     0.200
     8.435   120.609     0.200
     8.435   121.410     0.200
     8.471   119.789     0.200
     8.471   120.266     0.200
     8.528   122.047     0.200
     8.651   122.086     0.200
     8.613   122.969     0.200
     8.696   122.750     0.200
     8.740   123.246     0.200
     8.740   123.652     0.200
     8.724   123.859     0.200
     8.724   124.133     0.200
     8.869   125.430     0.200
     8.874   125.406     0.200
     8.917   125.312     0.200
     8.932   127.078     0.200
     8.932   126.223     0.200
     9.041   127.574     0.200
     9.015   127.445     0.200
     9.017   127.609     0.200
     9.017   127.496     0.200
     9.085   128.727     0.200
     9.085   128.137     0.200
     9.138   128.762     0.200
     9.240   129.496     0.200
     9.248   129.578     0.200
     9.248   130.105     0.200
     9.345   131.430     0.200
     9.345   131.645     0.200
     9.369   132.668     0.200
     9.369   132.480     0.200
     9.431   131.418     0.200
     9.487   135.508     0.200
     9.487   133.914     0.200
     9.553   134.238     0.200
     9.641   135.168     0.200
     9.641   135.625     0.200
     9.725   136.895     0.200
     9.761   137.559     0.200
     9.840   138.871     0.200
     9.968   139.977     0.200
     9.968   139.809     0.200
     9.959   139.969     0.200
     9.918   140.348     0.200
     9.985   140.977     0.200
     9.959   141.438     0.200
    10.063   140.879     0.200
    10.063   141.020     0.200
     9.991   140.840     0.200
    10.074   141.621     0.200
    10.146   144.008     0.200
    10.146   145.047     0.200
    10.197   143.898     0.200
    10.258   145.211     0.200
    10.336   144.684     0.200
    10.323   144.629     0.200
    10.291   144.926     0.200
    10.423   148.246     0.200
    10.540   147.656     0.200
    10.485   148.379     0.200
    10.485   148.082     0.200
    10.552   147.918     0.200
    10.553   148.535     0.200
    10.657   148.801     0.200
    10.765   151.160     0.200
    10.886   152.109     0.200
    10.902   152.582     0.200
    10.910   153.777     0.200
    10.951   156.039     0.200
    10.951   155.121     0.200
    10.986   155.941     0.200
    11.117   155.367     0.200
    11.208   156.457     0.200
    11.180   156.266     0.200
    11.202   156.516     0.200
    11.222   159.648     0.200
    11.222   158.754     0.200
    11.320   159.305     0.200
    11.353   159.469     0.200
    11.516   162.539     0.200
    11.504   161.703     0.200
    11.562   161.812     0.200
    11.588   161.707     0.200
    11.636   162.258     0.200
    11.718   163.891     0.200
    11.664   163.105     0.200
    11.742   166.109     0.200
    11.742   165.289     0.200
    11.742   163.707     0.200
    11.742   161.906     0.200
    11.830   165.297     0.200
    11.816   164.996     0.200
    11.963   168.152     0.200
    12.053   169.395     0.200
    12.147   170.727     0.200
    12.147   169.594     0.200
    12.121   169.090     0.200
    12.233   170.340     0.200
    12.158   170.297     0.200
    12.256   170.855     0.200
    12.320   172.012     0.200
    12.524   174.344     0.200
    12.542   174.309     0.200
    12.509   175.762     0.200
    12.482   176.250     0.200
    12.591   175.832     0.200
    12.604   176.551     0.200
    12.613   177.484     0.200
    12.727   177.840     0.200
    12.726   177.895     0.200
    12.858   179.535     0.200
    12.796   179.359     0.200
    13.120   183.156     0.200
    13.132   185.504     0.200
    13.136   184.293     0.200
    13.169   185.348     0.200
    13.167   185.488     0.200
    13.224   185.012     0.200
    13.506   188.945     0.200
    13.472   190.043     0.200
    13.602   190.906     0.200
    13.529   190.125     0.200
    13.711   191.855     0.200
    13.605   192.355     0.200
    13.598   191.695     0.200
    13.780   192.836     0.200
    13.719   193.516     0.200
    13.806   194.910     0.200
    13.879   193.594     0.200
    13.841   195.000     0.200
    13.916   194.480     0.200
    13.896   196.266     0.200
    13.979   194.789     0.200
    14.027   194.910     0.200
    14.099   195.656     0.200
    14.071   196.074     0.200
    14.164   196.742     0.200
    14.200   197.027     0.200
    14.180   197.809     0.200
    14.305   197.871     0.200
    14.284   199.836     0.200
    14.380   199.453     0.200
    14.490   201.066     0.200
    14.459   201.027     0.200
    14.463   201.531     0.200
    14.595   202.816     0.200
    14.539   201.824     0.200
    14.553   201.562     0.200
    14.631   202.254     0.200
    14.596   202.340     0.200
    14.604   203.000     0.200
    14.721   204.172     0.200
    14.736   204.801     0.200
    14.895   206.199     0.200
    14.890   206.953     0.200
    14.906   206.992     0.200
    14.931   207.445     0.200
    15.063   209.426     0.200
    15.137   209.996     0.200
    15.155   211.047     0.200
    15.185   210.941     0.200
    15.321   212.477     0.200
    15.393   214.539     0.200
    15.393   213.129     0.200
    15.495   214.254     0.200
    15.530   213.957     0.200
    15.555   216.387     0.200
    15.659   216.660     0.200
    15.679   217.062     0.200
    15.685   217.539     0.200
    15.832   219.367     0.200
    15.732   217.902     0.200
    15.755   218.352     0.200
    15.887   219.711     0.200
    15.895   219.609     0.200
    16.055   222.477     0.200
    16.165   224.145     0.200
    16.262   225.727     0.200
    16.431   226.645     0.200
    16.460   226.773     0.200
    16.528   228.641     0.200
    16.534   228.328     0.200
    16.672   229.918     0.200
    16.709   230.434     0.200
    16.729   230.750     0.200
    16.835   231.742     0.200
    16.836   232.020     0.200
    16.975   233.336     0.200
    16.999   234.109     0.200
    16.999   232.906     0.200
    17.028   233.816     0.200
    17.172   235.855     0.200
    17.287   236.398     0.200
    17.445   239.227     0.200
    17.653   241.570     0.200
    17.734   241.602     0.200
     0.493     9.156     0.200
     0.469    10.387     0.200
     0.865    16.547     0.200
     0.924    17.727     0.200
     0.940    17.809     0.200
     0.950    18.219     0.200
     1.053    19.945     0.200
     1.080    19.879     0.200
     1.087    19.695     0.200
     1.302    22.195     0.200
     1.458    24.836     0.200
     1.493    25.656     0.200
     1.934    33.027     0.200
     2.071    34.676     0.200
     2.138    35.078     0.200
     2.276    35.867     0.200
     2.369    37.219     0.200
     2.434    38.117     0.200
     3.158    49.828     0.200
     3.200    49.188     0.200
     3.231    50.637     0.200
     3.301    51.648     0.200
     3.329    51.996     0.200
     3.469    52.516     0.200
     3.342    51.617     0.200
     3.572    54.336     0.200
     3.620    54.766     0.200
     3.695    55.457     0.200
     3.698    55.648     0.200
     3.788    57.719     0.200
     3.923    59.676     0.200
     4.168    61.879     0.200
     4.221    62.605     0.200
     4.304    64.066     0.200
     4.335    64.316     0.200
     4.373    64.047     0.200
     4.377    64.668     0.200
     4.319    63.539     0.200
     4.370    64.586     0.200
     4.433    65.957     0.200
     4.406    65.207     0.200
     4.642    66.707     0.200
     4.807    70.707     0.200
     4.812    71.008     0.200
     4.719    70.848     0.200
     4.862    71.496     0.200
     4.843    69.879     0.200
     4.892    71.496     0.200
     5.100    74.219     0.200
     5.247    74.387     0.200
     5.247    74.836     0.200
     5.227    76.168     0.200
     5.336    77.758     0.200
     5.304    77.168     0.200
     5.503    80.086     0.200
     5.730    83.945     0.200
     5.763    84.168     0.200
     5.831    83.945     0.200
     5.942    85.855     0.200
     5.962    87.246     0.200
     6.208    89.656     0.200
     6.300    90.969     0.200
     6.586    94.707     0.200
     6.740    97.719     0.200
     6.727    96.418     0.200
     6.838    97.578     0.200
     6.867    98.316     0.200
     6.941   101.738     0.200
     7.059   101.168     0.200
     7.359   104.789     0.200
     7.409   106.387     0.200
     7.456   106.898     0.200
     7.614   108.668     0.200
     7.679   111.629     0.200
     7.721   111.047     0.200
     7.895   112.367     0.200
     7.878   112.367     0.200
     7.935   113.168     0.200
     7.995   115.309     0.200
     8.054   115.227     0.200
     8.429   119.988     0.200
     8.569   121.719     0.200
     8.692   122.617     0.200
     8.624   124.367     0.200
     8.792   123.809     0.200
     9.283   130.629     0.200
     9.296   130.496     0.200
     9.477   132.098     0.200
     9.460   133.746     0.200
     9.683   135.836     0.200
     9.782   137.168     0.200
    10.113   141.887     0.200
    10.604   149.469     0.200
    10.589   149.488     0.200
    10.860   152.879     0.200
    11.535   161.426     0.200
    11.999   164.121     0.200
    11.999   167.578     0.200
    16.873   232.309     0.200
    17.239   237.309     0.200
    17.798   243.758     0.200
     0.458    10.527     0.200
     0.435    10.777     0.200
     0.894    16.969     0.200
     0.937    17.996     0.200
     0.958    18.238     0.200
     1.070    20.297     0.200
     1.112    20.449     0.200
     1.444    24.836     0.200
     1.444    25.828     0.200
     2.115    35.016     0.200
     2.381    38.418     0.200
     3.206    50.148     0.200
     3.249    49.586     0.200
     3.279    51.238     0.200
     3.346    51.758     0.200
     3.350    51.918     0.200
     3.390    52.277     0.200
     3.419    53.137     0.200
     3.748    56.406     0.200
     4.321    63.637     0.200
     4.372    64.516     0.200
     5.068    74.016     0.200
     5.190    75.266     0.200
     5.446    78.117     0.200
     5.677    81.617     0.200
     5.736    83.406     0.200
     5.793    84.316     0.200
     5.873    83.816     0.200
     5.909    85.086     0.200
     6.018    85.066     0.200
     6.165    88.668     0.200
     6.249    89.387     0.200
     6.396    91.219     0.200
     6.687    95.766     0.200
     6.680    96.316     0.200
     6.849    96.586     0.200
     6.803    97.758     0.200
     6.826    98.426     0.200
     7.058   100.938     0.200
     7.315   104.867     0.200
     7.383   105.238     0.200
     7.567   107.289     0.200
     7.669   110.277     0.200
     7.795   111.008     0.200
     7.828   111.047     0.200
     7.892   112.809     0.200
     7.942   112.156     0.200
     7.965   113.848     0.200
     8.024   114.477     0.200
     8.391   119.156     0.200
     8.528   120.797     0.200
     8.588   123.855     0.200
     8.673   122.977     0.200
     8.736   123.637     0.200
     8.771   125.227     0.200
     8.996   127.926     0.200
     9.413   133.457     0.200
     9.725   136.496     0.200
     9.800   138.328     0.200
    10.056   141.559     0.200
     9.996   141.918     0.200
    10.209   144.426     0.200
    10.486   148.238     0.200
    10.554   149.406     0.200
    10.815   152.949     0.200
    11.026   155.598     0.200
    11.304   158.707     0.200
    11.478   160.289     0.200
    11.649   162.758     0.200
    11.945   163.480     0.200
    12.019   168.828     0.200
    12.096   169.969     0.200
    12.538   175.637     0.200
    12.701   177.727     0.200
    13.599   189.098     0.200
    13.665   191.078     0.200
    13.602   192.629     0.200
    13.951   194.219     0.200
    14.017   195.527     0.200
    14.241   198.168     0.200
    14.560   201.078     0.200
    14.590   201.988     0.200
    15.067   208.508     0.200
    15.439   211.539     0.200
    15.539   214.039     0.200
    15.685   215.906     0.200
    15.972   219.027     0.200
    16.067   219.918     0.200
    16.560   227.828     0.200
    16.710   229.688     0.200
    16.816   230.988     0.200
    17.046   232.559     0.200
    17.184   234.508     0.200
    17.294   237.105     0.200
     0.474     9.240     0.200
     0.442    10.270     0.200
     0.880    16.871     0.200
     0.928    17.801     0.200
     0.927    17.660     0.200
     0.947    18.061     0.200
     0.959    18.500     0.200
     1.059    20.041     0.200
     1.097    20.311     0.200
     1.266    21.779     0.200
     1.427    24.201     0.200
     1.423    24.420     0.200
     1.459    25.070     0.200
     2.009    32.660     0.200
     1.958    33.230     0.200
     2.085    35.211     0.200
     2.097    34.971     0.200
     2.332    36.609     0.200
     3.187    50.051     0.200
     3.230    50.701     0.200
     3.331    52.141     0.200
     3.338    52.090     0.200
     3.359    52.400     0.200
     3.371    52.650     0.200
     3.582    54.189     0.200
     3.648    55.430     0.200
     3.728    57.141     0.200
     3.818    58.311     0.200
     3.877    59.170     0.200
     3.953    60.301     0.200
     4.183    62.131     0.200
     4.299    63.891     0.200
     4.289    63.520     0.200
     4.335    64.221     0.200
     4.335    64.359     0.200
     4.380    64.420     0.200
     4.494    66.561     0.200
     4.606    66.291     0.200
     4.770    69.689     0.200
     4.775    70.270     0.200
     4.807    71.080     0.200
     4.824    70.820     0.200
     4.859    71.160     0.200
     5.075    74.141     0.200
     5.210    73.734     0.200
     5.210    74.779     0.200
     5.299    77.461     0.200
     5.275    77.121     0.200
     5.465    79.510     0.200
     5.887    85.029     0.200
     5.971    87.480     0.200
     6.136    88.250     0.200
     6.223    89.311     0.200
     6.265    90.131     0.200
     6.414    92.320     0.200
     6.481    92.541     0.200
     6.562    94.340     0.200
     6.661    95.980     0.200
     6.788    97.750     0.200
     6.867    98.871     0.200
     6.837    98.311     0.200
     6.904   100.131     0.200
     6.929   100.891     0.200
     6.944   101.090     0.200
     7.028   101.791     0.200
     7.025   101.070     0.200
     7.103   101.920     0.200
     7.125   100.910     0.200
     7.388   105.961     0.200
     7.429   106.350     0.200
     7.608   109.020     0.200
     7.609   109.420     0.200
     7.643   110.010     0.200
     7.683   110.750     0.200
     7.685   110.721     0.200
     7.814   112.121     0.200
     7.857   111.359     0.200
     7.904   112.170     0.200
     7.959   115.051     0.200
     7.984   113.260     0.200
     7.998   115.561     0.200
     8.382   119.041     0.200
     8.401   118.971     0.200
     8.469   120.770     0.200
     8.539   120.730     0.200
     8.655   122.131     0.200
     8.755   123.189     0.200
     8.654   123.541     0.200
     8.784   124.529     0.200
     8.940   126.090     0.200
     9.006   127.641     0.200
     9.060   128.600     0.200
     9.068   128.750     0.200
     9.120   129.189     0.200
     9.136   128.650     0.200
     9.246   129.279     0.200
     9.259   129.480     0.200
     9.367   131.131     0.200
     9.439   131.359     0.200
     9.573   134.590     0.200
     9.646   135.250     0.200
     9.744   136.871     0.200
     9.814   138.529     0.200
     9.803   138.660     0.200
     9.925   138.859     0.200
     9.935   138.551     0.200
     9.964   140.680     0.200
     9.997   142.461     0.200
    10.015   140.480     0.200
    10.040   140.359     0.200
    10.002   142.150     0.200
    10.075   140.980     0.200
    10.105   141.510     0.200
    10.099   140.201     0.200
    10.041   142.189     0.200
    10.358   145.480     0.200
    10.588   148.971     0.200
    10.828   152.451     0.200
    10.957   154.010     0.200
    11.033   156.881     0.200
    11.054   156.881     0.200
    11.112   156.670     0.200
    11.573   163.250     0.200
    11.731   164.160     0.200
    11.867   166.461     0.200
    11.962   163.891     0.200
    12.557   174.660     0.200
    12.552   174.189     0.200
    13.685   191.371     0.200
    14.128   196.859     0.200
    16.976   232.939     0.200
     0.374     9.461     0.200
     0.374     9.727     0.200
     0.518    10.582     0.200
     0.831    16.402     0.200
     0.864    17.203     0.200
     0.866    17.094     0.200
     0.888    17.574     0.200
     0.902    17.883     0.200
     0.998    19.531     0.200
     1.051    19.711     0.200
     1.062    19.555     0.200
     1.223    21.184     0.200
     1.281    22.422     0.200
     1.374    23.934     0.200
     1.389    23.582     0.200
     1.406    24.477     0.200
     1.408    24.203     0.200
     1.408    24.594     0.200
     1.972    32.164     0.200
     1.927    33.102     0.200
     2.055    34.543     0.200
     2.069    34.652     0.200
     2.133    35.805     0.200
     2.201    35.223     0.200
     2.293    36.242     0.200
     2.357    37.273     0.200
     2.361    37.211     0.200
     3.169    49.863     0.200
     3.212    48.684     0.200
     3.212    49.762     0.200
     3.242    50.805     0.200
     3.307    51.574     0.200
     3.312    51.684     0.200
     3.317    51.805     0.200
     3.322    51.594     0.200
     3.340    51.941     0.200
     3.397    51.762     0.200
     3.352    51.492     0.200
     3.380    52.492     0.200
     3.503    53.281     0.200
     3.503    52.824     0.200
     3.547    53.703     0.200
     3.615    54.902     0.200
     3.619    54.824     0.200
     3.713    56.484     0.200
     3.802    57.762     0.200
     3.880    56.781     0.200
     3.880    56.465     0.200
     3.861    58.723     0.200
     3.937    59.805     0.200
     3.971    59.781     0.200
     4.148    61.684     0.200
     4.148    61.582     0.200
     4.225    62.473     0.200
     4.225    62.281     0.200
     4.235    62.992     0.200
     4.255    63.305     0.200
     4.282    63.453     0.200
     4.282    63.207     0.200
     4.304    63.121     0.200
     4.310    63.645     0.200
     4.311    63.824     0.200
     4.364    64.914     0.200
     4.464    66.371     0.200
     4.599    65.684     0.200
     4.599    66.633     0.200
     4.623    67.863     0.200
     4.740    70.004     0.200
     4.741    70.031     0.200
     4.741    69.582     0.200
     4.761    70.254     0.200
     4.761    70.355     0.200
     4.736    70.984     0.200
     4.795    70.543     0.200
     4.754    70.914     0.200
     4.803    69.531     0.200
     4.803    69.973     0.200
     4.813    71.305     0.200
     5.005    73.523     0.200
     5.005    73.391     0.200
     5.140    75.012     0.200
     5.198    73.652     0.200
     5.198    74.184     0.200
     5.198    73.895     0.200
     5.198    75.422     0.200
     5.210    75.953     0.200
     5.210    76.148     0.200
     5.258    77.234     0.200
     5.258    76.180     0.200
     5.436    78.543     0.200
     5.436    79.105     0.200
     5.586    81.461     0.200
     5.586    81.633     0.200
     5.650    82.402     0.200
     5.650    81.957     0.200
     5.669    82.723     0.200
     5.669    83.184     0.200
     5.736    82.961     0.200
     5.817    84.652     0.200
     5.833    85.133     0.200
     5.833    84.125     0.200
     5.847    84.734     0.200
     5.912    87.191     0.200
     5.912    86.641     0.200
     5.907    87.074     0.200
     6.102    87.656     0.200
     6.115    88.121     0.200
     6.115    88.582     0.200
     6.182    89.883     0.200
     6.215    89.652     0.200
     6.215    89.457     0.200
     6.237    90.824     0.200
     6.237    90.465     0.200
     6.379    92.324     0.200
     6.385    92.461     0.200
     6.446    93.164     0.200
     6.492    93.883     0.200
     6.492    93.684     0.200
     6.627    95.742     0.200
     6.627    95.516     0.200
     6.636    95.805     0.200
     6.636    95.531     0.200
     6.658    96.871     0.200
     6.658    96.629     0.200
     6.689    96.512     0.200
     6.689    95.449     0.200
     6.743    96.422     0.200
     6.743    96.523     0.200
     6.764    96.895     0.200
     6.773    97.473     0.200
     6.773    97.055     0.200
     6.831    98.453     0.200
     6.867    99.281     0.200
     6.891   100.324     0.200
     6.953   101.242     0.200
     6.972   100.203     0.200
     6.972    99.387     0.200
     7.067   101.582     0.200
     7.101   100.473     0.200
     7.101   100.371     0.200
     7.267   103.934     0.200
     7.267   103.488     0.200
     7.316   105.812     0.200
     7.316   105.289     0.200
     7.361   105.883     0.200
     7.361   105.434     0.200
     7.524   107.371     0.200
     7.524   107.809     0.200
     7.570   108.992     0.200
     7.610   109.824     0.200
     7.613   109.492     0.200
     7.613   109.094     0.200
     7.629   109.355     0.200
     7.636   110.484     0.200
     7.636   110.188     0.200
     7.644   109.844     0.200
     7.740   111.055     0.200
     7.785   111.734     0.200
     7.792   110.973     0.200
     7.833   110.812     0.200
     7.842   111.871     0.200
     7.842   111.664     0.200
     7.914   113.023     0.200
     7.956   114.023     0.200
     7.956   113.188     0.200
     7.959   114.434     0.200
     7.959   113.953     0.200
     7.959   113.844     0.200
     8.334   118.949     0.200
     8.351   118.043     0.200
     8.428   120.352     0.200
     8.428   119.824     0.200
     8.476   119.883     0.200
     8.476   120.363     0.200
     8.497   122.203     0.200
     8.516   123.121     0.200
     8.551   123.324     0.200
     8.565   123.344     0.200
     8.636   121.844     0.200
     8.636   121.703     0.200
     8.590   123.941     0.200
     8.601   123.984     0.200
     8.636   123.934     0.200
     8.688   123.203     0.200
     8.688   122.270     0.200
     8.726   124.293     0.200
     8.726   123.762     0.200
     8.729   123.062     0.200
     8.729   122.223     0.200
     8.853   124.211     0.200
     8.857   124.363     0.200
     8.908   125.684     0.200
     8.908   125.582     0.200
     8.939   127.172     0.200
     8.939   126.773     0.200
     9.010   129.633     0.200
     9.010   129.176     0.200
     9.016   127.793     0.200
     9.030   127.602     0.200
     9.030   127.336     0.200
     9.079   128.664     0.200
     9.079   128.145     0.200
     9.103   127.652     0.200
     9.131   129.531     0.200
     9.131   128.973     0.200
     9.226   129.934     0.200
     9.235   129.922     0.200
     9.235   128.609     0.200
     9.335   131.484     0.200
     9.335   129.207     0.200
     9.369   132.941     0.200
     9.369   132.629     0.200
     9.418   131.543     0.200
     9.483   134.523     0.200
     9.483   133.625     0.200
     9.543   133.621     0.200
     9.543   132.664     0.200
     9.627   134.484     0.200
     9.627   134.711     0.200
     9.627   133.621     0.200
     9.714   136.184     0.200
     9.714   134.949     0.200
     9.734   138.352     0.200
     9.734   137.875     0.200
     9.698   137.895     0.200
     9.760   138.434     0.200
     9.760   137.816     0.200
     9.731   139.211     0.200
     9.749   139.102     0.200
     9.837   139.492     0.200
     9.837   138.941     0.200
     9.794   140.055     0.200
     9.887   138.852     0.200
     9.912   139.395     0.200
     9.930   140.984     0.200
     9.952   140.281     0.200
     9.952   139.871     0.200
     9.954   140.633     0.200
     9.954   139.906     0.200
     9.962   140.621     0.200
     9.962   140.766     0.200
     9.977   139.031     0.200
     9.977   139.148     0.200
     9.997   141.164     0.200
     9.997   140.926     0.200
    10.024   140.895     0.200
    10.050   141.121     0.200
    10.050   140.848     0.200
    10.065   139.996     0.200
    10.207   144.328     0.200
    10.169   144.883     0.200
    10.169   144.023     0.200
    10.262   145.031     0.200
    10.262   144.820     0.200
    10.291   146.562     0.200
    10.291   145.746     0.200
    10.312   145.043     0.200
    10.312   144.703     0.200
    10.317   144.383     0.200
    10.322   145.055     0.200
    10.322   144.324     0.200
    10.465   146.633     0.200
    10.446   148.664     0.200
    10.494   148.543     0.200
    10.494   148.230     0.200
    10.508   149.164     0.200
    10.531   147.523     0.200
    10.531   146.742     0.200
    10.546   147.984     0.200
    10.546   147.809     0.200
    10.560   148.875     0.200
    10.644   149.125     0.200
    10.768   151.699     0.200
    10.868   152.723     0.200
    10.875   152.203     0.200
    10.875   152.082     0.200
    10.887   152.023     0.200
    10.887   152.184     0.200
    10.901   153.492     0.200
    10.923   154.742     0.200
    10.938   153.824     0.200
    10.962   154.996     0.200
    10.991   155.262     0.200
    11.006   153.992     0.200
    11.060   155.746     0.200
    11.107   155.184     0.200
    11.177   157.102     0.200
    11.194   157.453     0.200
    11.194   156.094     0.200
    11.197   156.180     0.200
    11.236   158.684     0.200
    11.324   158.977     0.200
    11.353   160.453     0.200
    11.353   159.852     0.200
    11.512   161.703     0.200
    11.517   163.004     0.200
    11.554   161.500     0.200
    11.585   160.629     0.200
    11.630   160.723     0.200
    11.630   160.840     0.200
    11.670   164.750     0.200
    11.706   162.480     0.200
    11.724   163.984     0.200
    11.737   163.184     0.200
    11.737   162.781     0.200
    11.737   163.070     0.200
    11.737   163.492     0.200
    11.814   166.824     0.200
    11.814   166.316     0.200
    11.821   164.629     0.200
    11.913   166.957     0.200
    11.920   163.031     0.200
    11.967   168.430     0.200
    12.039   168.262     0.200
    12.053   169.711     0.200
    12.053   169.543     0.200
    12.118   168.344     0.200
    12.118   168.688     0.200
    12.134   169.922     0.200
    12.134   169.500     0.200
    12.166   171.254     0.200
    12.217   170.605     0.200
    12.248   169.586     0.200
    12.323   173.711     0.200
    12.323   173.328     0.200
    12.469   174.102     0.200
    12.489   175.727     0.200
    12.505   173.602     0.200
    12.512   174.395     0.200
    12.512   173.172     0.200
    12.531   175.102     0.200
    12.578   175.102     0.200
    12.588   175.660     0.200
    12.617   178.031     0.200
    12.617   177.410     0.200
    12.659   177.691     0.200
    12.727   178.359     0.200
    12.727   179.531     0.200
    12.727   178.727     0.200
    12.794   179.973     0.200
    12.794   179.367     0.200
    12.828   181.105     0.200
    12.841   179.297     0.200
    12.864   180.395     0.200
    12.864   179.148     0.200
    12.949   181.473     0.200
    13.102   182.918     0.200
    13.116   184.070     0.200
    13.120   183.414     0.200
    13.176   186.234     0.200
    13.223   185.270     0.200
    13.310   185.633     0.200
    13.411   183.852     0.200
    13.476   189.402     0.200
    13.490   189.203     0.200
    13.490   187.863     0.200
    13.539   192.211     0.200
    13.539   191.125     0.200
    13.584   189.059     0.200
    13.599   189.359     0.200
    13.607   191.258     0.200
    13.611   192.852     0.200
    13.611   191.031     0.200
    13.690   191.043     0.200
    13.690   190.570     0.200
    13.726   193.922     0.200
    13.726   193.027     0.200
    13.762   192.285     0.200
    13.844   195.082     0.200
    13.844   194.156     0.200
    13.864   193.180     0.200
    13.900   195.512     0.200
    13.900   194.996     0.200
    13.914   192.867     0.200
    13.968   194.395     0.200
    13.968   193.844     0.200
    13.974   192.992     0.200
    14.014   194.387     0.200
    14.070   196.625     0.200
    14.091   194.934     0.200
    14.147   196.926     0.200
    14.179   198.184     0.200
    14.179   197.281     0.200
    14.179   196.363     0.200
    14.186   200.293     0.200
    14.186   198.914     0.200
    14.282   198.234     0.200
    14.282   199.668     0.200
    14.286   200.582     0.200
    14.286   198.852     0.200
    14.286   197.848     0.200
    14.366   199.871     0.200
    14.456   200.953     0.200
    14.466   202.434     0.200
    14.474   200.555     0.200
    14.532   199.320     0.200
    14.544   202.094     0.200
    14.544   200.105     0.200
    14.574   202.223     0.200
    14.584   202.730     0.200
    14.603   204.035     0.200
    14.611   203.621     0.200
    14.611   202.688     0.200
    14.704   204.539     0.200
    14.737   206.055     0.200
    14.737   205.488     0.200
    14.886   205.125     0.200
    14.888   208.492     0.200
    14.888   205.273     0.200
    14.903   205.270     0.200
    14.934   207.773     0.200
    15.053   208.164     0.200
    15.119   208.410     0.200
    15.160   210.738     0.200
    15.185   211.602     0.200
    15.185   210.668     0.200
    15.159   210.453     0.200
    15.159   212.582     0.200
    15.288   212.082     0.200
    15.305   211.449     0.200
    15.472   212.113     0.200
    15.557   215.727     0.200
    15.641   215.195     0.200
    15.663   215.414     0.200
    15.674   215.270     0.200
    15.735   219.383     0.200
    15.735   217.082     0.200
    15.753   216.777     0.200
    15.813   216.781     0.200
    15.865   218.152     0.200
    16.048   219.656     0.200
    16.156   221.711     0.200
    16.266   225.047     0.200
    16.410   226.387     0.200
    16.437   226.676     0.200
    16.464   228.352     0.200
    16.526   228.832     0.200
    16.526   227.719     0.200
    16.532   227.457     0.200
    16.663   227.809     0.200
    16.699   229.484     0.200
    16.699   228.582     0.200
    16.724   230.805     0.200
    16.724   229.090     0.200
    16.773   230.691     0.200
    16.820   230.254     0.200
    16.832   230.980     0.200
    16.953   232.020     0.200
    16.979   232.738     0.200
    17.022   233.133     0.200
    17.022   231.754     0.200
    17.164   236.254     0.200
    17.164   234.297     0.200
    17.278   235.488     0.200
    17.426   239.672     0.200
    17.440   237.512     0.200
    17.635   241.680     0.200
    17.725   240.371     0.200
    19.307   262.859     0.200
    19.307   263.742     0.200
    20.009   270.012     0.200
     1.797    30.402     0.200
     1.821    30.914     0.200
     1.986    33.801     0.200
     1.991    33.113     0.200
     2.802    44.902     0.200
     2.893    46.004     0.200
     2.956    47.402     0.200
     2.964    46.492     0.200
     2.732    45.484     0.200
     2.905    48.672     0.200
     3.215    52.082     0.200
     4.000    61.371     0.200
     4.151    63.242     0.200
     4.217    64.711     0.200
     4.453    66.574     0.200
     4.453    66.062     0.200
     4.453    66.367     0.200
     4.312    67.871     0.200
     4.707    70.812     0.200
     4.719    70.234     0.200
     4.739    70.395     0.200
     4.739    70.902     0.200
     4.839    71.633     0.200
     4.839    72.004     0.200
     4.846    73.164     0.200
     4.846    73.043     0.200
     4.911    73.652     0.200
     4.937    74.211     0.200
     4.971    74.871     0.200
     5.188    75.773     0.200
     5.346    78.594     0.200
     5.346    80.168     0.200
     5.347    78.164     0.200
     5.347    79.523     0.200
     5.347    79.758     0.200
     5.347    79.484     0.200
     5.402    80.293     0.200
     5.419    80.191     0.200
     5.419    80.484     0.200
     5.686    83.906     0.200
     5.704    84.414     0.200
     5.794    84.191     0.200
     5.794    83.871     0.200
     5.794    84.383     0.200
     5.854    86.594     0.200
     5.854    86.996     0.200
     5.768    86.871     0.200
     5.768    85.984     0.200
     5.768    86.684     0.200
     6.020    88.684     0.200
     6.044    88.422     0.200
     6.044    88.980     0.200
     6.100    89.715     0.200
     6.190    90.242     0.200
     6.190    90.094     0.200
     6.241    91.203     0.200
     6.241    92.211     0.200
     6.257    91.773     0.200
     6.383    93.145     0.200
     6.472    95.043     0.200
     6.618    96.621     0.200
     6.618    96.453     0.200
     6.776    99.371     0.200
     6.776    98.816     0.200
     6.785    99.453     0.200
     6.785    98.895     0.200
     6.882   100.352     0.200
     6.882    99.934     0.200
     6.988   102.211     0.200
     7.050   102.691     0.200
     7.170   103.973     0.200
     7.174   103.473     0.200
     7.231   105.383     0.200
     7.231   104.676     0.200
     7.244   106.504     0.200
     7.244   104.992     0.200
     7.259   104.680     0.200
     7.432   108.352     0.200
     7.469   108.844     0.200
     7.491   109.102     0.200
     7.532   109.254     0.200
     7.532   108.988     0.200
     7.669   111.281     0.200
     7.653   110.863     0.200
     7.709   110.062     0.200
     7.709   110.395     0.200
     7.776   111.781     0.200
     7.776   111.641     0.200
     7.792   112.551     0.200
     8.062   116.199     0.200
     8.194   118.621     0.200
     8.209   119.422     0.200
     8.211   117.656     0.200
     8.234   120.133     0.200
     8.243   119.152     0.200
     8.278   120.113     0.200
     8.006   118.371     0.200
     8.029   118.281     0.200
     8.338   120.762     0.200
     8.346   119.871     0.200
     8.346   119.633     0.200
     8.356   120.566     0.200
     8.341   120.395     0.200
     8.393   120.293     0.200
     8.141   120.074     0.200
     8.441   120.363     0.200
     8.498   123.172     0.200
     8.498   123.906     0.200
     8.556   124.051     0.200
     8.564   122.922     0.200
     8.564   123.066     0.200
     8.789   125.773     0.200
     8.957   127.492     0.200
     8.957   127.285     0.200
     8.961   127.473     0.200
     8.961   127.297     0.200
     9.023   129.852     0.200
     9.023   129.969     0.200
     9.250   131.762     0.200
     9.250   131.941     0.200
     9.241   131.145     0.200
     9.241   131.277     0.200
     9.290   131.926     0.200
     9.337   132.113     0.200
     9.337   132.328     0.200
     9.392   134.512     0.200
     9.392   133.312     0.200
     9.450   133.945     0.200
     9.454   134.121     0.200
     9.513   134.672     0.200
     9.513   135.672     0.200
     9.575   137.312     0.200
     9.575   137.559     0.200
     9.592   138.680     0.200
     9.339   136.562     0.200
     9.637   137.246     0.200
     9.672   138.051     0.200
     9.672   138.277     0.200
     9.728   138.434     0.200
     9.728   138.004     0.200
     9.535   138.434     0.200
     9.842   138.672     0.200
     9.842   139.133     0.200
     9.904   141.312     0.200
     9.904   141.172     0.200
     9.941   139.621     0.200
     9.941   140.473     0.200
     9.687   141.074     0.200
     9.687   140.773     0.200
    10.024   140.934     0.200
    10.060   143.715     0.200
    10.150   143.352     0.200
    10.150   143.898     0.200
    10.231   144.973     0.200
    10.231   144.238     0.200
    10.310   147.191     0.200
    10.292   146.730     0.200
    10.321   146.328     0.200
    10.407   148.801     0.200
    10.462   148.793     0.200
    10.474   149.211     0.200
    10.542   149.641     0.200
    10.549   149.445     0.200
    10.578   148.613     0.200
    10.599   151.191     0.200
    10.658   150.457     0.200
    10.668   149.742     0.200
    10.751   153.516     0.200
    10.831   154.906     0.200
    10.919   153.656     0.200
    10.919   155.320     0.200
    10.927   154.184     0.200
    11.013   156.402     0.200
    11.133   156.180     0.200
    11.138   156.656     0.200
    11.252   158.656     0.200
    11.279   160.277     0.200
    11.278   160.496     0.200
    11.349   161.855     0.200
    11.431   161.734     0.200
    11.472   163.141     0.200
    11.483   161.977     0.200
    11.489   162.055     0.200
    11.564   164.484     0.200
    11.620   164.594     0.200
    11.713   164.637     0.200
    11.747   166.672     0.200
    11.781   166.473     0.200
    11.800   166.664     0.200
    11.824   168.180     0.200
    11.901   168.875     0.200
    11.956   168.082     0.200
    12.136   172.336     0.200
    12.156   171.691     0.200
    12.162   171.273     0.200
    12.224   170.117     0.200
    12.325   171.773     0.200
    12.325   170.871     0.200
    12.325   172.145     0.200
    12.325   171.113     0.200
    12.314   173.195     0.200
    12.372   174.566     0.200
    12.425   173.781     0.200
    12.456   176.176     0.200
    12.513   172.938     0.200
    12.588   178.035     0.200
    12.603   177.301     0.200
    12.626   175.168     0.200
    12.688   177.801     0.200
    12.741   180.027     0.200
    12.832   181.840     0.200
    12.814   180.469     0.200
    12.846   178.562     0.200
    12.942   183.406     0.200
    13.085   184.086     0.200
    13.074   183.855     0.200
    13.109   185.664     0.200
    13.120   183.512     0.200
    13.185   184.828     0.200
    13.189   186.301     0.200
    13.257   187.156     0.200
    13.250   187.145     0.200
    13.274   187.402     0.200
    13.354   187.703     0.200
    13.456   189.055     0.200
    13.432   189.535     0.200
    13.549   191.199     0.200
    13.601   190.762     0.200
    13.707   193.270     0.200
    13.683   193.066     0.200
    13.716   194.039     0.200
    13.716   193.312     0.200
    13.777   193.660     0.200
    13.884   195.273     0.200
    13.936   195.930     0.200
    13.975   196.109     0.200
    14.010   193.691     0.200
    14.030   196.945     0.200
    14.089   198.629     0.200
    14.084   197.406     0.200
    14.172   198.387     0.200
    14.170   199.277     0.200
    14.204   199.062     0.200
    14.261   199.043     0.200
    14.243   199.617     0.200
    14.360   201.570     0.200
    14.339   200.871     0.200
    14.393   201.750     0.200
    14.479   201.277     0.200
    14.462   202.324     0.200
    14.576   203.312     0.200
    14.621   204.773     0.200
    14.621   203.160     0.200
    14.649   205.633     0.200
    14.692   203.980     0.200
    14.739   206.004     0.200
    14.714   205.973     0.200
    14.714   205.461     0.200
    14.839   207.289     0.200
    14.862   210.871     0.200
    14.862   209.016     0.200
    14.972   209.520     0.200
    14.971   209.371     0.200
    14.993   208.195     0.200
    14.771   208.816     0.200
    15.031   209.910     0.200
    15.071   210.465     0.200
    15.129   210.504     0.200
    15.150   211.422     0.200
    15.148   210.477     0.200
    15.118   212.004     0.200
    15.118   210.766     0.200
    15.191   212.211     0.200
    15.191   211.891     0.200
    15.169   213.711     0.200
    15.215   212.422     0.200
    15.215   213.043     0.200
    15.274   213.223     0.200
    15.274   213.949     0.200
    15.240   214.672     0.200
    15.294   213.754     0.200
    15.294   215.320     0.200
    15.439   215.434     0.200
    15.466   215.434     0.200
    15.466   215.152     0.200
    15.474   214.863     0.200
    15.474   215.570     0.200
    15.482   215.023     0.200
    15.643   217.395     0.200
    15.659   217.781     0.200
    15.659   217.504     0.200
    15.732   219.852     0.200
    15.732   218.418     0.200
    15.695   219.555     0.200
    15.736   218.523     0.200
    15.906   221.734     0.200
    15.906   220.461     0.200
    15.990   223.102     0.200
    15.990   221.395     0.200
    15.991   223.223     0.200
    16.087   223.922     0.200
    16.087   222.871     0.200
    16.124   222.062     0.200
    16.070   223.895     0.200
    16.245   224.539     0.200
    16.224   225.688     0.200
    16.255   226.988     0.200
    16.281   225.961     0.200
    16.281   226.090     0.200
    16.311   226.512     0.200
    16.311   225.969     0.200
    16.380   228.637     0.200
    16.390   229.043     0.200
    16.475   228.227     0.200
    16.541   229.551     0.200
    16.541   228.637     0.200
    16.647   229.695     0.200
    16.760   231.383     0.200
    16.919   234.852     0.200
    16.962   234.184     0.200
    16.942   234.555     0.200
    17.092   235.488     0.200
    17.092   236.406     0.200
    17.265   236.875     0.200
    17.311   237.230     0.200
    17.306   238.375     0.200
    17.410   239.113     0.200
    17.421   238.742     0.200
    17.491   241.328     0.200
    17.539   242.035     0.200
    17.614   241.234     0.200
    17.763   242.672     0.200
    17.882   244.516     0.200
    19.564   267.680     0.200
    19.760   269.797     0.200
     0.432    10.000     0.200
     0.511     9.949     0.200
     0.842    16.242     0.200
     0.893    17.211     0.200
     0.891    17.199     0.200
     0.911    17.512     0.200
     0.923    17.980     0.200
     1.023    19.473     0.200
     1.059    19.543     0.200
     1.067    19.441     0.200
     1.276    21.922     0.200
     1.337    23.031     0.200
     1.430    24.391     0.200
     1.464    24.980     0.200
     1.921    32.820     0.200
     2.048    34.570     0.200
     2.252    35.422     0.200
     2.410    37.770     0.200
     3.152    49.551     0.200
     3.195    50.133     0.200
     3.225    50.480     0.200
     3.296    51.121     0.200
     3.324    51.352     0.200
     3.336    50.230     0.200
     3.551    54.031     0.200
     3.597    54.262     0.200
     3.671    55.352     0.200
     3.694    56.281     0.200
     3.910    57.961     0.200
     3.784    57.402     0.200
     3.842    58.301     0.200
     3.919    59.270     0.200
     4.284    63.512     0.200
     4.284    62.961     0.200
     4.353    64.340     0.200
     4.339    64.109     0.200
     4.412    65.270     0.200
     4.369    64.473     0.200
     4.512    66.820     0.200
     4.634    66.820     0.200
     4.670    67.801     0.200
     4.787    70.422     0.200
     4.791    70.602     0.200
     4.816    70.812     0.200
     4.716    70.473     0.200
     4.861    71.121     0.200
     5.063    73.832     0.200
     5.197    75.430     0.200
     5.235    74.566     0.200
     5.235    76.340     0.200
     5.269    76.770     0.200
     5.311    76.902     0.200
     5.483    79.641     0.200
     5.704    81.793     0.200
     5.725    83.520     0.200
     5.795    83.320     0.200
     5.890    85.422     0.200
     5.905    85.270     0.200
     5.885    87.723     0.200
     5.934    86.840     0.200
     6.174    89.332     0.200
     6.271    91.199     0.200
     6.287    91.680     0.200
     6.549    93.949     0.200
     6.694    95.980     0.200
     6.713    97.430     0.200
     6.802    96.711     0.200
     6.832    98.070     0.200
     7.029   100.500     0.200
     7.325   104.359     0.200
     7.371   105.672     0.200
     7.419   106.410     0.200
     7.582   107.992     0.200
     7.692   110.992     0.200
     7.832   112.590     0.200
     7.849   112.500     0.200
     7.878   111.980     0.200
     7.901   112.992     0.200
     7.968   115.383     0.200
     8.011   114.262     0.200
     8.016   114.590     0.200
     8.393   119.461     0.200
     8.534   120.441     0.200
     8.774   124.531     0.200
     8.784   124.473     0.200
    11.974   167.070     0.200
    12.026   169.359     0.200
    12.111   170.949     0.200
    12.577   176.250     0.200
    12.877   180.980     0.200
    13.716   191.961     0.200
    13.902   193.633     0.200
    13.864   195.480     0.200
    14.015   196.270     0.200
    14.142   198.602     0.200
    14.339   200.941     0.200
    14.408   201.332     0.200
    14.638   202.602     0.200
    14.629   203.812     0.200
    15.572   216.543     0.200
    15.615   217.461     0.200
    15.810   220.770     0.200
    16.099   223.242     0.200
    16.206   225.422     0.200
    16.860   232.699     0.200
    17.775   243.141     0.200
     1.769    31.332     0.200
     1.675    30.523     0.200
     1.916    33.281     0.200
     1.945    34.031     0.200
     1.946    34.262     0.200
     1.865    33.211     0.200
     2.747    44.645     0.200
     2.807    46.961     0.200
     2.851    48.621     0.200
     2.851    48.395     0.200
     2.880    47.941     0.200
     2.978    49.133     0.200
     2.999    50.152     0.200
     3.332    54.121     0.200
     3.332    53.762     0.200
     3.428    55.402     0.200
     3.481    56.402     0.200
     3.594    57.934     0.200
     4.356    66.422     0.200
     4.356    65.863     0.200
     4.716    70.914     0.200
     4.755    72.574     0.200
     5.096    75.422     0.200
     5.096    75.953     0.200
     5.326    81.023     0.200
     5.439    81.762     0.200
     5.674    85.602     0.200
     5.689    85.973     0.200
     5.708    82.918     0.200
     5.708    84.961     0.200
     5.878    88.922     0.200
     6.056    91.723     0.200
     6.091    91.582     0.200
     6.200    91.672     0.200
     6.279    93.395     0.200
     6.532    96.434     0.200
     6.613    98.453     0.200
     6.909   101.984     0.200
     7.153   105.824     0.200
     7.191   105.023     0.200
     7.692   112.852     0.200
     7.768   113.133     0.200
     7.809   114.191     0.200
     8.326   122.703     0.200
     8.341   121.273     0.200
     8.367   121.664     0.200
     8.370   121.762     0.200
     8.799   127.953     0.200
     8.962   129.801     0.200
     9.160   131.793     0.200
     9.266   133.461     0.200
     9.752   140.203     0.200
     9.947   141.703     0.200
     9.804   144.422     0.200
    10.287   148.484     0.200
    10.462   150.094     0.200
    13.957   195.941     0.200
    14.125   200.023     0.200
    14.139   200.203     0.200
    14.325   201.793     0.200
    14.892   208.090     0.200
    16.067   225.824     0.200
    17.241   239.234     0.200
     1.298    22.617     0.200
     1.654    27.996     0.200
     1.781    27.938     0.200
     1.866    30.676     0.200
     2.032    33.426     0.200
     2.044    33.176     0.200
     2.852    42.969     0.200
     2.891    44.797     0.200
     2.912    45.379     0.200
     2.985    46.457     0.200
     3.024    46.738     0.200
     3.169    49.398     0.200
     3.475    52.629     0.200
     3.595    54.168     0.200
     3.635    53.777     0.200
     3.675    54.996     0.200
     3.739    56.348     0.200
     3.739    56.848     0.200
     3.819    57.516     0.200
     3.819    57.707     0.200
     3.858    58.016     0.200
     3.858    58.406     0.200
     3.963    58.656     0.200
     3.963    58.887     0.200
     4.106    61.266     0.200
     4.141    61.457     0.200
     4.281    62.461     0.200
     4.281    62.117     0.200
     4.281    62.676     0.200
     4.325    64.316     0.200
     4.389    64.789     0.200
     4.409    65.688     0.200
     4.509    67.246     0.200
     4.520    67.488     0.200
     4.553    67.707     0.200
     4.580    68.289     0.200
     4.610    68.336     0.200
     4.668    68.477     0.200
     4.750    69.348     0.200
     4.900    72.047     0.200
     4.993    73.148     0.200
     5.208    75.906     0.200
     5.314    77.926     0.200
     5.635    81.828     0.200
     5.693    82.957     0.200
     5.776    83.887     0.200
     5.778    83.707     0.200
     5.840    84.766     0.200
     5.901    85.336     0.200
     5.906    85.906     0.200
     5.957    85.656     0.200
     5.938    86.496     0.200
     5.995    86.258     0.200
     6.000    86.828     0.200
     5.970    86.297     0.200
     6.108    88.797     0.200
     6.111    89.137     0.200
     6.235    90.398     0.200
     6.248    89.988     0.200
     6.291    89.496     0.200
     6.324    90.398     0.200
     6.332    91.355     0.200
     6.389    92.277     0.200
     6.419    92.789     0.200
     6.475    93.176     0.200
     6.701    96.496     0.200
     6.958    99.848     0.200
     7.068   100.758     0.200
     7.086   102.086     0.200
     7.039   101.758     0.200
     7.075   101.629     0.200
     7.189   103.336     0.200
     7.158   103.129     0.200
     7.282   104.898     0.200
     7.351   105.078     0.200
     7.414   106.016     0.200
     7.475   106.957     0.200
     7.665   108.918     0.200
     7.766   109.598     0.200
     7.912   111.816     0.200
     7.904   112.297     0.200
     7.966   112.438     0.200
     8.239   117.016     0.200
     8.319   117.707     0.200
     8.432   118.129     0.200
     8.441   118.777     0.200
     8.491   120.457     0.200
     8.556   121.219     0.200
     8.586   120.027     0.200
     8.652   122.277     0.200
     8.719   123.516     0.200
     8.759   122.996     0.200
     9.008   126.809     0.200
     8.997   126.516     0.200
     9.083   128.898     0.200
     9.120   128.188     0.200
     9.185   130.289     0.200
     9.263   130.008     0.200
     9.302   130.047     0.200
     9.380   130.867     0.200
     9.419   131.617     0.200
     9.460   132.418     0.200
     9.471   133.516     0.200
     9.473   134.766     0.200
     9.503   134.855     0.200
     9.543   134.078     0.200
     9.579   135.195     0.200
     9.691   137.008     0.200
     9.772   136.918     0.200
     9.744   139.207     0.200
     9.806   137.098     0.200
     9.797   137.977     0.200
     9.827   139.086     0.200
     9.864   139.957     0.200
     9.908   138.367     0.200
     9.962   139.758     0.200
    10.044   140.727     0.200
    10.071   140.926     0.200
    10.280   144.469     0.200
    10.278   145.617     0.200
    10.331   145.059     0.200
    10.801   150.316     0.200
    10.850   150.238     0.200
    10.985   153.578     0.200
    11.165   157.039     0.200
    11.155   158.039     0.200
    11.245   156.027     0.200
    11.269   159.195     0.200
    11.238   158.516     0.200
    11.391   156.797     0.200
    11.391   156.566     0.200
    11.391   157.016     0.200
    11.369   160.219     0.200
    11.369   160.426     0.200
    11.648   163.676     0.200
    11.757   164.387     0.200
    12.518   175.695     0.200
    12.732   178.598     0.200
    12.924   180.777     0.200
    13.033   180.816     0.200
    13.162   183.617     0.200
    13.213   185.047     0.200
    13.233   184.246     0.200
    13.334   187.227     0.200
    13.524   189.195     0.200
    13.781   193.098     0.200
    13.880   193.688     0.200
    14.067   196.156     0.200
    14.228   200.488     0.200
    14.302   197.977     0.200
    14.613   204.078     0.200
    14.703   203.848     0.200
    14.873   206.559     0.200
    14.939   208.148     0.200
    15.293   212.469     0.200
    15.405   213.289     0.200
    15.558   215.207     0.200
    15.809   218.848     0.200
    15.879   222.543     0.200
    16.148   224.277     0.200
    16.219   224.398     0.200
    16.382   226.211     0.200
    16.382   225.887     0.200
    16.382   226.016     0.200
    16.605   228.316     0.200
    17.072   234.195     0.200
    17.652   242.594     0.200
    17.652   242.766     0.200
     1.036    18.922     0.200
     1.061    19.078     0.200
     1.151    20.312     0.200
     1.692    28.516     0.200
     1.787    29.938     0.200
     1.816    29.688     0.200
     1.875    31.609     0.200
     2.022    33.828     0.200
     2.150    35.656     0.200
     2.752    42.492     0.200
     2.752    42.695     0.200
     2.835    42.578     0.200
     2.889    44.500     0.200
     3.024    47.258     0.200
     3.052    48.688     0.200
     3.196    50.219     0.200
     3.434    51.117     0.200
     3.507    52.477     0.200
     3.543    53.688     0.200
     3.600    52.461     0.200
     3.562    52.977     0.200
     3.625    55.086     0.200
     3.857    57.945     0.200
     3.857    58.250     0.200
     4.234    61.539     0.200
     4.234    61.977     0.200
     4.131    60.617     0.200
     4.239    63.422     0.200
     4.335    66.289     0.200
     4.408    65.562     0.200
     4.493    66.836     0.200
     4.652    68.477     0.200
     4.833    70.609     0.200
     5.070    73.789     0.200
     5.113    74.930     0.200
     5.135    75.469     0.200
     5.469    79.625     0.200
     5.667    82.406     0.200
     5.748    83.477     0.200
     5.917    85.086     0.200
     5.925    85.922     0.200
     5.906    86.508     0.200
     5.939    86.352     0.200
     6.097    88.430     0.200
     6.135    88.828     0.200
     6.326    92.031     0.200
     6.631    95.047     0.200
     6.617    95.516     0.200
     6.692    96.469     0.200
     6.971   100.992     0.200
     6.981   101.156     0.200
     6.875    99.969     0.200
     7.184   103.695     0.200
     7.296   104.758     0.200
     7.341   106.039     0.200
     7.334   105.781     0.200
     7.366   106.102     0.200
     7.550   108.945     0.200
     7.621   108.930     0.200
     7.784   111.320     0.200
     7.889   112.266     0.200
     8.083   115.109     0.200
     8.345   118.219     0.200
     8.309   118.398     0.200
     8.422   120.586     0.200
     9.077   128.680     0.200
     9.022   128.109     0.200
     9.348   134.000     0.200
     9.657   137.016     0.200
    11.274   154.070     0.200
    11.761   165.945     0.200
    12.045   169.758     0.200
    12.397   174.836     0.200
    12.602   176.352     0.200
    12.682   177.672     0.200
    13.124   185.508     0.200
    13.430   189.375     0.200
    13.426   188.898     0.200
    13.635   191.812     0.200
    13.672   193.297     0.200
    13.788   192.719     0.200
    14.047   198.070     0.200
    14.958   209.836     0.200
    15.289   213.492     0.200
    15.281   213.586     0.200
    15.445   215.477     0.200
    15.647   217.938     0.200
    15.889   221.836     0.200
    15.925   221.586     0.200
    16.366   227.156     0.200
    16.515   229.180     0.200
     1.589    28.726     0.200
     1.757    29.856     0.200
     1.704    30.456     0.200
     1.711    30.516     0.200
     1.897    32.686     0.200
     1.781    31.526     0.200
     1.979    33.746     0.200
     2.738    43.786     0.200
     2.739    44.886     0.200
     2.782    46.026     0.200
     2.812    45.656     0.200
     2.884    46.556     0.200
     2.910    46.846     0.200
     2.929    47.356     0.200
     3.368    51.066     0.200
     3.268    51.306     0.200
     3.362    52.526     0.200
     3.494    54.346     0.200
     3.936    60.026     0.200
     4.045    61.826     0.200
     4.087    61.086     0.200
     4.153    62.516     0.200
     4.391    65.096     0.200
     4.642    69.696     0.200
     4.688    69.866     0.200
     4.666    69.306     0.200
     4.742    70.866     0.200
     4.693    70.316     0.200
     4.777    71.506     0.200
     4.780    71.366     0.200
     4.847    71.826     0.200
     4.906    73.296     0.200
     5.124    74.426     0.200
     5.284    78.916     0.200
     5.289    78.286     0.200
     5.374    79.306     0.200
     5.644    83.346     0.200
     5.635    82.676     0.200
     5.730    82.420     0.200
     5.730    82.556     0.200
     5.782    86.846     0.200
     5.979    87.056     0.200
     5.982    88.066     0.200
     6.045    89.086     0.200
     6.142    89.616     0.200
     6.178    91.316     0.200
     6.213    90.706     0.200
     6.325    92.206     0.200
     6.446    94.036     0.200
     6.565    95.586     0.200
     6.840    99.056     0.200
     7.113   102.926     0.200
     7.128   102.856     0.200
     7.181   104.956     0.200
     7.207   104.456     0.200
     7.306   105.626     0.200
     7.473   108.186     0.200
     7.617   110.266     0.200
     7.721   111.026     0.200
     7.747   112.016     0.200
     8.005   115.416     0.200
     8.293   119.356     0.200
     8.300   119.546     0.200
     9.176   130.496     0.200
     9.777   137.916     0.200
     9.959   139.586     0.200
    12.450   171.748     0.200
     1.177    20.455     0.200
     1.181    21.005     0.200
     1.202    21.395     0.200
     1.314    22.465     0.200
     1.232    21.875     0.200
     1.358    23.735     0.200
     1.408    24.395     0.200
     1.409    24.705     0.200
     1.340    23.875     0.200
     1.400    24.485     0.200
     1.410    24.345     0.200
     1.880    31.195     0.200
     2.113    33.935     0.200
     2.209    35.425     0.200
     2.277    36.765     0.200
     2.264    37.775     0.200
     2.391    39.515     0.200
     2.401    39.195     0.200
     2.595    39.645     0.200
     2.468    40.205     0.200
     3.286    50.045     0.200
     3.370    51.715     0.200
     3.484    54.315     0.200
     3.621    53.575     0.200
     3.621    53.455     0.200
     3.527    55.175     0.200
     3.557    55.175     0.200
     3.625    55.885     0.200
     3.627    56.015     0.200
     3.637    56.505     0.200
     3.638    56.655     0.200
     3.656    56.415     0.200
     3.670    56.465     0.200
     3.963    59.335     0.200
     4.054    60.535     0.200
     4.022    61.575     0.200
     4.168    62.415     0.200
     4.275    63.855     0.200
     4.323    64.235     0.200
     4.297    63.625     0.200
     4.363    63.275     0.200
     4.247    64.105     0.200
     4.440    65.855     0.200
     4.702    69.525     0.200
     4.812    70.625     0.200
     4.979    71.494     0.200
     5.041    75.445     0.200
     5.141    75.165     0.200
     5.289    77.435     0.200
     5.293    78.055     0.200
     5.576    81.695     0.200
     5.830    84.605     0.200
     5.837    84.735     0.200
     5.844    85.305     0.200
     5.974    86.945     0.200
     5.982    86.665     0.200
     6.096    88.735     0.200
     6.180    89.905     0.200
     6.261    90.695     0.200
     6.264    91.175     0.200
     6.326    91.535     0.200
     6.254    91.775     0.200
     6.254    91.025     0.200
     6.501    93.865     0.200
     6.532    95.565     0.200
     6.472    93.645     0.200
     6.596    94.545     0.200
     6.638    95.545     0.200
     6.756    98.245     0.200
     6.787    98.815     0.200
     6.848    99.265     0.200
     6.842    98.375     0.200
     6.887    97.485     0.200
     6.883   100.115     0.200
     6.860    97.905     0.200
     6.931    98.155     0.200
     6.953    99.635     0.200
     6.952    99.875     0.200
     7.311   104.975     0.200
     7.476   108.025     0.200
     7.475   107.725     0.200
     7.515   108.675     0.200
     7.495   107.905     0.200
     7.542   109.025     0.200
     7.534   108.095     0.200
     7.640   110.775     0.200
     7.661   109.315     0.200
     7.764   111.785     0.200
     7.848   113.135     0.200
     7.861   113.075     0.200
     7.890   112.905     0.200
     8.109   116.025     0.200
     8.211   116.215     0.200
     8.338   118.835     0.200
     8.440   118.675     0.200
     8.428   120.035     0.200
     8.566   120.245     0.200
     8.541   120.805     0.200
     8.749   124.885     0.200
     8.774   124.535     0.200
     8.990   127.235     0.200
     8.865   128.065     0.200
     9.033   126.595     0.200
     9.060   125.905     0.200
     9.034   128.325     0.200
     8.949   128.875     0.200
     9.234   128.015     0.200
     9.380   133.385     0.200
     9.567   133.865     0.200
     9.732   137.655     0.200
     9.732   136.095     0.200
     9.817   137.955     0.200
     9.881   138.325     0.200
     9.886   138.435     0.200
    10.079   142.785     0.200
    10.488   150.375     0.200
    11.057   156.835     0.200
    11.371   159.805     0.200
    11.522   162.655     0.200
    11.572   162.345     0.200
    11.661   164.675     0.200
    11.833   163.175     0.200
    11.833   164.575     0.200
    12.041   168.975     0.200
    12.368   172.665     0.200
    13.262   185.745     0.200
    13.812   192.265     0.200
    13.885   193.575     0.200
    13.915   193.495     0.200
    13.978   194.315     0.200
    14.030   197.675     0.200
    14.170   197.325     0.200
    14.287   198.605     0.200
    14.406   201.975     0.200
    14.404   201.555     0.200
    14.417   199.175     0.200
    14.741   204.805     0.200
    14.863   206.845     0.200
    15.095   209.315     0.200
    15.168   210.775     0.200
    15.394   215.045     0.200
    15.546   216.915     0.200
    15.567   216.625     0.200
    15.936   219.765     0.200
    18.156   248.175     0.200
     1.148    21.705     0.200
     1.255    23.664     0.200
     1.624    28.014     0.200
     1.789    31.164     0.200
     1.829    31.385     0.200
     1.829    31.934     0.200
     1.941    34.734     0.200
     2.064    36.135     0.200
     2.134    37.254     0.200
     2.587    41.824     0.200
     2.682    43.145     0.200
     2.748    43.975     0.200
     3.066    47.514     0.200
     3.066    47.205     0.200
     3.084    50.754     0.200
     3.128    51.715     0.200
     3.227    52.654     0.200
     3.230    52.514     0.200
     3.240    52.674     0.200
     3.246    52.555     0.200
     3.255    52.955     0.200
     3.276    53.965     0.200
     3.301    53.225     0.200
     3.772    57.975     0.200
     3.609    57.514     0.200
     3.609    57.715     0.200
     3.863    59.795     0.200
     3.920    59.975     0.200
     3.705    58.674     0.200
     4.005    61.395     0.200
     3.834    60.674     0.200
     4.108    61.715     0.200
     4.108    61.504     0.200
     4.457    67.275     0.200
     4.520    68.064     0.200
     4.550    68.555     0.200
     4.596    69.385     0.200
     4.654    70.164     0.200
     4.662    69.664     0.200
     4.661    69.934     0.200
     4.664    69.455     0.200
     4.707    70.514     0.200
     4.722    71.264     0.200
     4.747    71.164     0.200
     4.534    70.664     0.200
     4.818    72.805     0.200
     4.616    71.674     0.200
     4.858    71.514     0.200
     4.858    71.324     0.200
     4.975    73.994     0.200
     5.094    75.934     0.200
     5.107    76.074     0.200
     5.146    76.645     0.200
     5.166    77.145     0.200
     5.232    77.834     0.200
     5.440    80.664     0.200
     5.478    79.883     0.200
     5.478    79.695     0.200
     5.561    82.314     0.200
     5.647    83.844     0.200
     5.650    83.434     0.200
     5.786    85.195     0.200
     5.773    87.535     0.200
     6.023    88.945     0.200
     6.048    89.395     0.200
     5.857    89.715     0.200
     6.091    90.514     0.200
     6.162    91.275     0.200
     6.179    91.834     0.200
     6.179    91.184     0.200
     6.175    90.324     0.200
     6.104    91.715     0.200
     6.104    91.604     0.200
     6.260    92.094     0.200
     6.281    92.324     0.200
     6.467    94.834     0.200
     6.553    96.334     0.200
     6.574    96.334     0.200
     6.631    97.305     0.200
     6.624    97.045     0.200
     6.750    98.195     0.200
     6.923   100.395     0.200
     6.993   102.094     0.200
     7.030   103.145     0.200
     7.061   103.215     0.200
     7.068   103.045     0.200
     7.096   102.205     0.200
     7.180   103.824     0.200
     7.207   104.254     0.200
     7.212   104.795     0.200
     7.387   105.764     0.200
     7.394   107.865     0.200
     7.431   106.184     0.200
     7.704   111.195     0.200
     7.735   112.184     0.200
     7.798   113.395     0.200
     7.955   114.604     0.200
     8.027   115.514     0.200
     8.050   117.115     0.200
     8.133   117.104     0.200
     8.161   117.275     0.200
     8.211   118.785     0.200
     8.280   119.225     0.200
     8.298   119.895     0.200
     8.316   121.104     0.200
     8.344   120.465     0.200
     8.389   121.225     0.200
     8.707   124.494     0.200
     8.533   125.115     0.200
     8.533   125.455     0.200
     8.773   125.945     0.200
     8.818   126.525     0.200
     8.915   127.014     0.200
     8.940   127.164     0.200
     9.066   129.375     0.200
     9.133   130.145     0.200
     9.159   131.295     0.200
     9.269   132.215     0.200
     9.378   134.844     0.200
     9.437   135.154     0.200
     9.466   134.455     0.200
     9.534   135.064     0.200
     9.561   135.365     0.200
     9.693   137.215     0.200
     9.735   137.295     0.200
     9.801   140.725     0.200
     9.933   141.014     0.200
    10.229   145.494     0.200
    10.278   147.195     0.200
    10.081   146.514     0.200
    10.382   146.895     0.200
    11.161   158.084     0.200
    11.394   163.145     0.200
    11.465   161.314     0.200
    11.591   164.645     0.200
    11.779   167.354     0.200
    11.768   165.984     0.200
    11.927   167.734     0.200
    11.947   169.955     0.200
    11.945   168.875     0.200
    11.950   170.074     0.200
    11.993   169.184     0.200
    12.070   170.014     0.200
    12.070   169.705     0.200
    12.135   172.314     0.200
    12.135   171.514     0.200
    12.135   169.184     0.200
    12.144   171.924     0.200
    12.236   173.215     0.200
    12.312   172.174     0.200
    12.312   170.482     0.200
    12.529   177.514     0.200
    12.868   180.234     0.200
    12.912   181.385     0.200
    12.928   183.865     0.200
    13.056   185.234     0.200
    13.099   184.955     0.200
    13.160   185.934     0.200
    13.215   186.795     0.200
    13.257   185.684     0.200
    14.513   205.914     0.200
    14.671   206.404     0.200
    14.876   210.715     0.200
    14.952   209.574     0.200
    14.960   209.465     0.200
    14.960   209.885     0.200
    15.278   213.385     0.200
    15.292   215.295     0.200
    15.316   215.465     0.200
    15.988   223.035     0.200
    16.942   235.564     0.200
    17.050   235.975     0.200
    17.176   238.014     0.200
     1.093    19.297     0.200
     1.093    19.492     0.200
     1.189    20.523     0.200
     1.293    22.742     0.200
     1.357    23.977     0.200
     1.358    24.023     0.200
     1.515    26.047     0.200
     1.526    25.625     0.200
     1.558    26.867     0.200
     1.658    28.617     0.200
     1.748    29.617     0.200
     1.761    29.508     0.200
     1.940    31.477     0.200
     2.083    33.562     0.200
     2.108    34.234     0.200
     2.627    42.812     0.200
     2.754    44.594     0.200
     2.831    45.297     0.200
     3.074    47.242     0.200
     3.135    48.383     0.200
     3.211    49.492     0.200
     3.217    49.242     0.200
     3.284    48.414     0.200
     3.330    50.711     0.200
     3.809    56.922     0.200
     3.865    57.734     0.200
     3.925    58.266     0.200
     3.850    59.336     0.200
     3.893    59.531     0.200
     3.923    60.227     0.200
     4.040    58.273     0.200
     4.021    61.438     0.200
     4.036    61.297     0.200
     4.156    62.016     0.200
     4.257    63.562     0.200
     4.381    64.664     0.200
     4.387    65.672     0.200
     4.461    66.141     0.200
     4.528    66.555     0.200
     4.479    67.297     0.200
     4.667    67.086     0.200
     4.705    69.141     0.200
     4.980    73.055     0.200
     5.033    73.664     0.200
     5.167    75.234     0.200
     5.261    77.445     0.200
     5.384    78.633     0.200
     5.553    81.703     0.200
     5.706    82.688     0.200
     5.820    85.086     0.200
     5.912    86.297     0.200
     6.003    87.328     0.200
     6.024    87.281     0.200
     6.099    88.758     0.200
     6.320    90.758     0.200
     6.407    92.625     0.200
     6.491    94.836     0.200
     6.546    94.742     0.200
     6.560    95.664     0.200
     6.653    93.961     0.200
     6.610    95.602     0.200
     6.671    96.258     0.200
     6.789    97.211     0.200
     6.858    98.492     0.200
     7.230   103.586     0.200
     7.372   105.453     0.200
     7.380   105.836     0.200
     7.418   106.383     0.200
     7.427   106.992     0.200
     7.469   107.312     0.200
     7.562   108.672     0.200
     7.611   109.977     0.200
     7.658   109.758     0.200
     8.126   115.711     0.200
     8.141   116.094     0.200
     8.292   117.195     0.200
     8.397   120.156     0.200
     8.481   120.484     0.200
     8.645   123.391     0.200
     8.735   123.352     0.200
     8.943   124.641     0.200
     9.003   128.312     0.200
     9.305   131.492     0.200
     9.601   134.805     0.200
    10.598   149.633     0.200
    10.853   154.836     0.200
    11.396   160.703     0.200
    12.263   172.844     0.200
    13.107   183.352     0.200
    14.169   197.336     0.200
    14.216   197.352     0.200
    15.156   211.781     0.200
    15.444   216.234     0.200
    15.641   218.008     0.200
    15.701   218.758     0.200
    16.287   225.922     0.200
    16.302   226.375     0.200
    16.899   233.758     0.200
     1.795    29.359     0.200
     1.795    30.441     0.200
     1.963    32.078     0.200
     2.016    34.148     0.200
     2.774    43.461     0.200
     2.774    44.270     0.200
     2.731    45.430     0.200
     2.929    46.891     0.200
     2.775    46.148     0.200
     2.775    45.012     0.200
     2.922    47.141     0.200
     3.388    52.051     0.200
     3.388    50.910     0.200
     3.258    51.852     0.200
     3.258    51.602     0.200
     4.156    63.949     0.200
     4.186    65.398     0.200
     4.415    65.949     0.200
     4.415    64.789     0.200
     4.355    67.590     0.200
     4.708    69.621     0.200
     4.735    70.551     0.200
     4.821    71.129     0.200
     4.881    71.988     0.200
     4.887    72.988     0.200
     5.041    75.590     0.200
     5.150    75.148     0.200
     5.200    77.148     0.200
     5.323    78.262     0.200
     5.758    83.535     0.200
     5.758    83.250     0.200
     5.758    84.289     0.200
     5.802    86.551     0.200
     5.802    86.430     0.200
     6.184    90.012     0.200
     6.397    93.859     0.200
     6.397    93.660     0.200
     6.751    99.121     0.200
     6.954   101.410     0.200
     6.960   101.988     0.200
     7.022   102.379     0.200
     7.170   103.469     0.200
     7.464   109.070     0.200
     7.657   110.930     0.200
     7.764   112.039     0.200
     8.141   117.898     0.200
     8.188   119.172     0.200
     8.217   119.051     0.200
     8.312   119.910     0.200
     8.337   120.109     0.200
     8.362   120.609     0.200
     8.184   119.949     0.200
     8.530   122.828     0.200
     8.533   122.648     0.200
     8.928   127.531     0.200
     9.206   131.379     0.200
     9.386   134.199     0.200
     9.484   135.051     0.200
     9.557   137.238     0.200
     9.569   138.160     0.200
     9.648   138.520     0.200
     9.729   140.648     0.200
     9.729   140.449     0.200
    10.197   144.250     0.200
    12.301   171.750     0.200
    12.301   171.148     0.200
    12.832   181.551     0.200
    15.103   207.422     0.200
    15.119   208.969     0.200
    15.159   211.520     0.200
    15.200   213.051     0.200
    15.259   213.301     0.200
    15.256   212.480     0.200
    15.715   219.219     0.200
    16.073   223.199     0.200
    17.499   241.449     0.200
     0.994    18.844     0.200
     1.004    19.109     0.200
     1.108    20.922     0.200
     1.129    20.891     0.200
     1.135    20.648     0.200
     1.481    25.375     0.200
     1.483    25.492     0.200
     1.520    26.453     0.200
     1.521    26.094     0.200
     1.521    26.492     0.200
     1.544    26.445     0.200
     1.973    33.820     0.200
     2.451    39.203     0.200
     3.188    50.961     0.200
     3.328    52.328     0.200
     3.340    52.844     0.200
     3.373    53.680     0.200
     3.581    55.070     0.200
     3.657    56.016     0.200
     3.711    56.609     0.200
     3.726    57.430     0.200
     3.901    58.773     0.200
     3.901    58.055     0.200
     3.817    58.805     0.200
     3.951    60.555     0.200
     4.233    63.500     0.200
     4.382    65.578     0.200
     4.358    63.828     0.200
     4.399    65.359     0.200
     4.452    65.852     0.200
     4.540    67.641     0.200
     4.633    67.172     0.200
     4.698    69.234     0.200
     4.865    72.578     0.200
     4.924    72.523     0.200
     5.147    75.320     0.200
     5.241    75.719     0.200
     5.353    78.680     0.200
     5.345    78.320     0.200
     5.510    80.664     0.200
     5.749    84.664     0.200
     5.813    85.164     0.200
     5.951    86.273     0.200
     5.988    86.570     0.200
     6.015    88.773     0.200
     6.245    90.648     0.200
     6.326    91.844     0.200
     6.380    92.742     0.200
     6.634    95.469     0.200
     6.761    98.531     0.200
     6.759    97.445     0.200
     6.906    99.430     0.200
     7.087   102.562     0.200
     7.395   105.602     0.200
     7.460   107.195     0.200
     7.500   107.766     0.200
     7.745   111.828     0.200
     7.859   113.359     0.200
     7.905   113.750     0.200
     7.972   114.023     0.200
     8.016   115.766     0.200
     8.102   115.781     0.200
     8.608   121.664     0.200
     8.797   125.133     0.200
     8.850   125.922     0.200
     9.076   128.844     0.200
     9.282   131.570     0.200
     9.299   131.383     0.200
     9.478   133.344     0.200
     9.492   134.422     0.200
     9.878   139.719     0.200
    12.017   166.336     0.200
    15.749   218.766     0.200
    16.136   221.742     0.200
    16.775   231.062     0.200
    17.361   238.422     0.200
     0.871    15.939     0.200
     1.117    19.850     0.200
     1.117    20.299     0.200
     1.253    22.089     0.200
     1.302    22.720     0.200
     1.306    22.829     0.200
     1.399    24.409     0.200
     1.525    26.039     0.200
     1.794    29.319     0.200
     1.946    31.270     0.200
     2.353    36.140     0.200
     2.353    35.709     0.200
     2.434    39.520     0.200
     2.562    41.089     0.200
     3.051    46.869     0.200
     3.114    47.829     0.200
     3.127    48.299     0.200
     3.352    49.939     0.200
     3.352    49.589     0.200
     3.712    55.600     0.200
     3.736    58.140     0.200
     3.850    57.749     0.200
     3.865    59.449     0.200
     3.874    60.479     0.200
     3.968    59.319     0.200
     4.018    59.220     0.200
     4.079    58.839     0.200
     4.162    61.069     0.200
     4.192    62.119     0.200
     4.297    63.189     0.200
     4.239    64.739     0.200
     4.239    65.039     0.200
     4.333    64.159     0.200
     4.384    64.999     0.200
     4.327    65.020     0.200
     4.508    66.159     0.200
     4.463    67.310     0.200
     4.807    70.629     0.200
     4.849    70.869     0.200
     4.896    71.390     0.200
     4.973    72.709     0.200
     5.018    73.339     0.200
     5.256    76.659     0.200
     5.336    78.699     0.200
     5.522    80.449     0.200
     5.570    80.779     0.200
     5.626    81.939     0.200
     5.776    84.479     0.200
     5.736    82.739     0.200
     5.865    85.299     0.200
     5.878    84.979     0.200
     5.941    86.329     0.200
     6.218    88.850     0.200
     6.284    89.839     0.200
     6.274    91.449     0.200
     6.279    91.739     0.200
     6.279    91.229     0.200
     6.307    91.409     0.200
     6.350    91.579     0.200
     6.398    91.749     0.200
     6.467    94.049     0.200
     6.559    93.739     0.200
     6.601    94.189     0.200
     6.640    95.439     0.200
     7.017   100.270     0.200
     7.229   103.619     0.200
     7.214   103.439     0.200
     7.278   105.060     0.200
     7.320   105.020     0.200
     7.277   104.669     0.200
     7.450   106.709     0.200
     7.597   109.039     0.200
     7.894   110.759     0.200
     7.870   112.029     0.200
     8.155   115.569     0.200
     8.253   116.539     0.200
     8.255   116.999     0.200
     8.448   120.259     0.200
     8.680   123.229     0.200
     8.730   122.879     0.200
     8.761   124.369     0.200
     8.927   124.529     0.200
     9.075   128.709     0.200
     9.114   130.049     0.200
     9.251   130.180     0.200
     9.440   133.899     0.200
     9.570   133.949     0.200
     9.856   139.399     0.200
    10.033   141.229     0.200
    10.395   145.470     0.200
    10.857   153.399     0.200
    11.032   155.109     0.200
    11.077   156.649     0.200
    11.215   158.569     0.200
    11.377   160.799     0.200
    11.478   161.529     0.200
    11.735   165.560     0.200
    11.754   165.600     0.200
    11.824   162.989     0.200
    12.056   167.629     0.200
    12.380   175.189     0.200
    13.103   182.739     0.200
    14.104   196.560     0.200
    14.099   194.659     0.200
    16.734   230.239     0.200
    16.832   230.729     0.200
    17.836   244.339     0.200
     1.110    20.871     0.200
     1.128    20.771     0.200
     1.134    20.502     0.200
     1.330    23.342     0.200
     1.488    25.781     0.200
     1.527    26.721     0.200
     1.528    26.801     0.200
     1.528    26.662     0.200
     1.844    30.102     0.200
     1.971    33.512     0.200
     2.173    36.432     0.200
     2.299    37.111     0.200
     2.458    39.432     0.200
     2.890    44.211     0.200
     3.184    50.471     0.200
     3.227    51.012     0.200
     3.227    49.650     0.200
     3.257    51.352     0.200
     3.325    52.111     0.200
     3.327    52.432     0.200
     3.337    52.502     0.200
     3.355    52.811     0.200
     3.370    51.422     0.200
     3.374    53.201     0.200
     3.722    57.211     0.200
     3.722    56.832     0.200
     3.907    58.311     0.200
     3.907    57.041     0.200
     3.813    58.492     0.200
     4.365    64.602     0.200
     4.389    64.191     0.200
     4.406    65.092     0.200
     4.458    66.221     0.200
     4.639    67.711     0.200
     4.872    71.342     0.200
     4.931    71.801     0.200
     5.153    75.621     0.200
     5.247    76.102     0.200
     5.261    77.191     0.200
     5.352    78.832     0.200
     5.757    83.381     0.200
     5.819    84.941     0.200
     5.880    85.162     0.200
     5.958    86.900     0.200
     5.995    86.822     0.200
     6.016    89.211     0.200
     6.016    89.092     0.200
     6.252    90.852     0.200
     6.333    90.822     0.200
     6.640    95.551     0.200
     6.768    99.012     0.200
     6.766    97.922     0.200
     6.837    99.912     0.200
     6.889    98.721     0.200
     6.913    99.541     0.200
     7.094   102.121     0.200
     7.507   108.041     0.200
     7.653   109.742     0.200
     7.912   113.672     0.200
     7.979   114.121     0.200
     8.108   115.891     0.200
     8.478   120.881     0.200
     8.615   122.012     0.200
     8.649   126.012     0.200
     8.804   125.861     0.200
     9.289   132.211     0.200
     9.499   135.002     0.200
     9.767   140.551     0.200
     9.885   140.592     0.200
    10.187   147.311     0.200
    14.865   206.230     0.200
    15.459   215.631     0.200
    15.614   217.682     0.200
    16.143   226.041     0.200
    16.756   231.611     0.200
    16.781   231.502     0.200
    17.260   237.691     0.200
    17.368   238.932     0.200
    17.817   243.650     0.200
     0.508    12.043     0.200
     0.657    14.395     0.200
     0.667    14.395     0.200
     0.675    14.465     0.200
     0.707    15.004     0.200
     0.668    14.152     0.200
     0.676    14.613     0.200
     0.748    14.395     0.200
     0.783    16.352     0.200
     0.985    15.992     0.200
     0.985    15.883     0.200
     1.444    26.012     0.200
     1.638    27.395     0.200
     1.644    28.434     0.200
     1.814    30.484     0.200
     1.815    29.742     0.200
     1.815    30.602     0.200
     1.852    30.273     0.200
     1.889    31.492     0.200
     1.894    31.172     0.200
     2.244    35.492     0.200
     2.655    41.281     0.200
     2.744    42.492     0.200
     2.651    42.594     0.200
     2.694    44.395     0.200
     2.694    42.902     0.200
     2.694    43.191     0.200
     2.791    43.953     0.200
     2.823    44.672     0.200
     2.836    45.234     0.200
     3.191    50.691     0.200
     3.191    49.402     0.200
     3.282    49.191     0.200
     3.408    50.793     0.200
     3.408    50.562     0.200
     3.340    51.484     0.200
     3.416    53.293     0.200
     3.450    53.055     0.200
     3.855    57.832     0.200
     4.085    61.562     0.200
     4.131    62.812     0.200
     4.213    64.215     0.200
     4.232    64.273     0.200
     4.265    64.754     0.200
     4.265    65.395     0.200
     4.407    64.895     0.200
     4.407    64.191     0.200
     4.407    64.492     0.200
     4.494    66.223     0.200
     4.500    66.914     0.200
     4.574    67.871     0.200
     4.608    68.312     0.200
     4.642    68.453     0.200
     4.778    71.012     0.200
     5.099    74.602     0.200
     5.121    73.434     0.200
     5.171    76.402     0.200
     5.177    76.145     0.200
     5.205    76.824     0.200
     5.214    76.383     0.200
     5.419    79.645     0.200
     5.456    79.781     0.200
     5.381    79.984     0.200
     5.511    80.023     0.200
     5.581    82.895     0.200
     5.581    82.742     0.200
     5.581    82.594     0.200
     5.693    83.434     0.200
     5.713    81.062     0.200
     5.713    81.191     0.200
     5.713    81.582     0.200
     5.713    81.293     0.200
     5.713    82.082     0.200
     5.882    85.805     0.200
     5.954    85.934     0.200
     6.181    88.984     0.200
     6.222    90.602     0.200
     6.396    92.453     0.200
     6.565    95.793     0.200
     6.636    96.145     0.200
     6.841    99.984     0.200
     6.902   100.602     0.200
     6.933    99.402     0.200
     6.959   100.043     0.200
     7.030   101.184     0.200
     7.253   104.441     0.200
     7.280   105.512     0.200
     7.315   106.133     0.200
     7.335   104.953     0.200
     7.402   106.703     0.200
     7.437   107.953     0.200
     7.538   107.992     0.200
     7.554   107.664     0.200
     7.591   107.441     0.200
     8.020   114.723     0.200
     8.084   116.613     0.200
     8.093   115.742     0.200
     8.123   115.812     0.200
     8.033   116.914     0.200
     8.178   117.594     0.200
     8.117   117.492     0.200
     8.261   117.723     0.200
     8.320   120.145     0.200
     8.324   117.484     0.200
     8.438   120.191     0.200
     8.819   124.793     0.200
     9.034   128.262     0.200
     9.141   128.723     0.200
     9.155   129.582     0.200
     9.234   132.805     0.200
     9.371   132.094     0.200
     9.376   132.645     0.200
     9.280   133.441     0.200
     9.410   133.594     0.200
     9.307   133.512     0.200
     9.505   136.043     0.200
     9.569   137.184     0.200
     9.654   138.793     0.200
     9.654   138.293     0.200
     9.874   139.715     0.200
     9.916   140.555     0.200
     9.932   142.305     0.200
     9.933   142.273     0.200
    10.043   142.793     0.200
    10.106   142.754     0.200
    10.129   142.191     0.200
    10.466   147.305     0.200
    11.102   157.594     0.200
    11.313   160.453     0.200
    11.842   166.074     0.200
    12.149   170.293     0.200
    12.149   168.691     0.200
    12.149   170.191     0.200
    12.149   169.352     0.200
    12.192   170.914     0.200
    12.199   172.395     0.200
    12.150   171.992     0.200
    12.342   169.543     0.200
    12.809   179.793     0.200
    13.012   181.453     0.200
    14.218   197.941     0.200
    14.683   205.160     0.200
    14.812   207.992     0.200
    19.809   269.555     0.200
    20.053   270.602     0.200
     1.136    20.730     0.200
     1.200    21.938     0.200
     1.338    23.988     0.200
     1.354    24.539     0.200
     1.944    33.109     0.200
     2.093    35.199     0.200
     2.152    36.590     0.200
     2.153    35.379     0.200
     2.425    39.000     0.200
     3.054    48.070     0.200
     3.054    48.270     0.200
     3.018    48.520     0.200
     3.062    48.348     0.200
     3.168    50.508     0.200
     3.168    50.961     0.200
     3.187    50.777     0.200
     3.186    50.629     0.200
     3.186    51.039     0.200
     3.214    51.148     0.200
     3.521    55.117     0.200
     3.622    56.559     0.200
     3.669    57.180     0.200
     3.669    57.309     0.200
     4.160    63.711     0.200
     4.224    64.391     0.200
     4.315    65.480     0.200
     4.752    71.277     0.200
     4.822    71.910     0.200
     4.841    72.379     0.200
     4.892    72.918     0.200
     4.956    73.891     0.200
     5.018    74.859     0.200
     5.018    75.070     0.200
     5.031    75.051     0.200
     5.098    74.469     0.200
     5.111    76.117     0.200
     5.267    78.000     0.200
     5.406    80.180     0.200
     5.483    81.617     0.200
     5.558    82.770     0.200
     5.728    81.656     0.200
     5.728    82.598     0.200
     5.884    86.730     0.200
     6.075    88.551     0.200
     6.349    94.039     0.200
     6.361    93.141     0.200
     6.585    96.820     0.200
     6.596    97.141     0.200
     6.879   100.418     0.200
     7.050   102.758     0.200
     7.116   103.539     0.200
     7.234   105.609     0.200
     7.377   107.070     0.200
     7.394   106.898     0.200
     7.717   112.391     0.200
     8.420   121.680     0.200
     8.533   121.848     0.200
     9.201   130.840     0.200
     9.346   133.070     0.200
     9.486   136.211     0.200
     9.797   138.617     0.200
    10.003   140.199     0.200
    10.352   147.090     0.200
    10.473   148.539     0.200
    10.658   151.078     0.200
    11.204   158.789     0.200
    11.530   164.160     0.200
    11.757   166.039     0.200
    12.016   169.449     0.200
    12.227   173.738     0.200
    12.272   174.320     0.200
    12.484   175.488     0.200
    12.559   178.141     0.200
    12.622   173.664     0.200
    12.737   179.828     0.200
    12.810   181.219     0.200
    13.148   183.398     0.200
    13.330   187.898     0.200
    14.060   197.070     0.200
    14.169   198.801     0.200
    14.375   202.320     0.200
    14.768   206.461     0.200
    15.191   212.711     0.200
    15.206   212.039     0.200
    15.492   217.059     0.200
    16.001   223.980     0.200
    16.190   224.168     0.200
    16.309   226.910     0.200
    16.726   231.359     0.200
    17.334   238.488     0.200
    17.337   240.078     0.200
     0.485     9.250     0.200
     0.488     9.273     0.200
     0.442    10.352     0.200
     0.866    16.734     0.200
     0.917    17.844     0.200
     0.935    18.039     0.200
     1.048    20.078     0.200
     1.083    20.141     0.200
     1.091    19.992     0.200
     1.274    22.094     0.200
     1.429    24.805     0.200
     1.464    25.375     0.200
     1.465    25.359     0.200
     1.800    29.344     0.200
     1.944    33.141     0.200
     2.071    34.883     0.200
     2.248    35.891     0.200
     3.101    47.719     0.200
     3.173    50.164     0.200
     3.215    48.883     0.200
     3.312    51.680     0.200
     3.316    51.789     0.200
     3.544    54.352     0.200
     3.714    55.219     0.200
     3.804    57.922     0.200
     4.141    61.914     0.200
     4.193    62.578     0.200
     4.239    63.078     0.200
     4.277    63.828     0.200
     4.291    63.344     0.200
     4.345    63.172     0.200
     4.341    64.164     0.200
     4.380    64.984     0.200
     4.504    67.219     0.200
     4.619    66.852     0.200
     4.619    66.469     0.200
     4.663    68.430     0.200
     4.785    70.844     0.200
     4.814    70.734     0.200
     4.735    70.961     0.200
     4.864    70.859     0.200
     5.075    74.078     0.200
     5.222    74.922     0.200
     5.222    74.633     0.200
     5.198    75.992     0.200
     5.307    78.008     0.200
     5.277    77.031     0.200
     5.476    79.055     0.200
     5.702    83.305     0.200
     5.739    83.945     0.200
     5.804    83.859     0.200
     5.893    85.898     0.200
     5.917    85.219     0.200
     5.959    86.445     0.200
     6.146    89.531     0.200
     6.180    89.461     0.200
     6.271    91.031     0.200
     6.305    90.430     0.200
     6.561    93.734     0.200
     6.711    97.641     0.200
     6.698    96.570     0.200
     6.800    97.445     0.200
     6.812    97.109     0.200
     6.877    97.719     0.200
     6.840    98.078     0.200
     7.031   100.859     0.200
     7.088   100.672     0.200
     7.331   104.625     0.200
     7.386   105.992     0.200
     7.430   106.258     0.200
     7.585   108.148     0.200
     7.651   110.555     0.200
     7.692   110.211     0.200
     7.825   111.680     0.200
     7.869   110.672     0.200
     7.849   112.148     0.200
     7.907   112.461     0.200
     7.966   113.609     0.200
     8.007   113.164     0.200
     8.029   114.250     0.200
     8.402   119.453     0.200
     8.478   120.211     0.200
     8.542   120.312     0.200
     8.667   121.781     0.200
     8.639   123.492     0.200
     8.766   123.914     0.200
     8.788   124.398     0.200
     9.007   127.461     0.200
     9.128   127.898     0.200
     9.146   129.102     0.200
     9.257   130.453     0.200
     9.451   132.102     0.200
     9.431   133.344     0.200
     9.658   135.492     0.200
     9.754   136.328     0.200
     9.820   138.773     0.200
    10.005   141.633     0.200
    10.052   140.609     0.200
    10.086   141.500     0.200
    10.064   141.414     0.200
    10.832   151.945     0.200
    11.233   156.242     0.200
    11.865   165.250     0.200
    12.115   168.969     0.200
    12.387   172.922     0.200
    13.365   186.094     0.200
    13.631   189.172     0.200
    14.048   195.930     0.200
    14.588   201.008     0.200
    14.620   202.023     0.200
    15.180   207.953     0.200
    15.333   213.758     0.200
    15.420   214.992     0.200
    15.566   217.539     0.200
    15.714   217.922     0.200
    15.998   220.234     0.200
    16.094   221.633     0.200
    16.200   221.961     0.200
    16.709   228.680     0.200
    16.739   229.289     0.200
    17.211   236.172     0.200
    17.322   236.711     0.200
     1.201    21.324     0.200
     1.217    21.453     0.200
     1.217    21.184     0.200
     1.361    22.781     0.200
     1.650    27.074     0.200
     1.866    30.113     0.200
     1.959    31.574     0.200
     1.961    31.895     0.200
     2.033    32.805     0.200
     2.033    33.375     0.200
     2.678    40.672     0.200
     2.913    44.742     0.200
     3.048    46.594     0.200
     3.071    46.992     0.200
     3.268    50.254     0.200
     3.509    52.152     0.200
     3.579    53.023     0.200
     3.623    53.773     0.200
     3.697    54.453     0.200
     3.697    53.805     0.200
     3.710    55.344     0.200
     3.855    57.152     0.200
     3.875    57.582     0.200
     4.107    61.133     0.200
     4.166    61.191     0.200
     4.325    63.254     0.200
     4.325    64.613     0.200
     4.325    64.754     0.200
     4.307    63.594     0.200
     4.340    62.348     0.200
     4.340    62.754     0.200
     4.340    63.852     0.200
     4.340    63.465     0.200
     4.405    64.531     0.200
     4.469    66.473     0.200
     4.579    67.762     0.200
     4.667    68.375     0.200
     4.791    69.234     0.200
     4.797    69.793     0.200
     4.816    70.352     0.200
     4.816    70.633     0.200
     4.909    72.055     0.200
     4.900    71.523     0.200
     5.077    74.492     0.200
     5.208    75.895     0.200
     5.208    75.254     0.200
     5.209    75.844     0.200
     5.231    75.773     0.200
     5.284    77.332     0.200
     5.310    77.723     0.200
     5.510    79.633     0.200
     5.641    81.633     0.200
     5.720    82.625     0.200
     5.749    83.852     0.200
     5.814    83.824     0.200
     5.855    85.133     0.200
     5.887    85.953     0.200
     5.916    85.062     0.200
     6.003    86.543     0.200
     6.038    87.012     0.200
     6.044    86.023     0.200
     6.101    88.691     0.200
     6.258    90.633     0.200
     6.283    90.074     0.200
     6.321    90.473     0.200
     6.340    89.754     0.200
     6.366    91.523     0.200
     6.374    90.062     0.200
     6.423    92.625     0.200
     6.453    92.492     0.200
     6.499    93.594     0.200
     6.511    92.844     0.200
     6.713    96.504     0.200
     6.789    97.344     0.200
     6.959   100.281     0.200
     6.959   100.652     0.200
     7.076   102.395     0.200
     7.095   100.383     0.200
     7.114   102.492     0.200
     7.114   102.852     0.200
     7.109   101.324     0.200
     7.119   101.531     0.200
     7.301   104.242     0.200
     7.501   107.012     0.200
     7.541   107.875     0.200
     7.709   108.582     0.200
     7.718   110.203     0.200
     7.796   111.234     0.200
     7.824   111.152     0.200
     8.114   114.773     0.200
     8.256   117.254     0.200
     8.282   117.453     0.200
     8.282   117.055     0.200
     8.365   117.594     0.200
     8.423   117.875     0.200
     8.437   119.715     0.200
     8.485   118.375     0.200
     8.483   119.281     0.200
     8.485   119.863     0.200
     8.641   119.742     0.200
     8.696   122.465     0.200
     8.735   123.555     0.200
     8.817   124.453     0.200
     8.817   124.152     0.200
     8.882   124.633     0.200
     9.044   127.852     0.200
     9.072   128.012     0.200
     9.041   129.133     0.200
     9.146   129.164     0.200
     9.193   130.562     0.200
     9.315   130.004     0.200
     9.339   130.902     0.200
     9.461   132.273     0.200
     9.518   132.703     0.200
     9.607   135.004     0.200
     9.714   136.742     0.200
     9.744   137.953     0.200
     9.806   137.055     0.200
     9.885   137.793     0.200
    10.989   156.273     0.200
    11.034   156.555     0.200
    11.056   155.965     0.200
    11.107   157.273     0.200
    11.215   158.602     0.200
    11.285   159.453     0.200
    11.285   159.152     0.200
    11.285   159.312     0.200
    11.276   158.352     0.200
    11.276   155.254     0.200
    11.276   155.645     0.200
    11.276   155.844     0.200
    11.335   159.352     0.200
    11.314   159.004     0.200
    11.424   157.055     0.200
    11.424   157.852     0.200
    11.564   162.852     0.200
    11.809   166.395     0.200
    13.264   185.562     0.200
    13.306   188.754     0.200
    13.583   190.895     0.200
    13.654   192.352     0.200
    13.775   192.965     0.200
    13.783   191.922     0.200
    14.463   202.754     0.200
    15.643   216.863     0.200
    15.955   220.930     0.200
    16.296   224.598     0.200
    16.296   226.352     0.200
    17.693   242.254     0.200
    17.693   242.004     0.200
    18.176   249.203     0.200
    18.176   248.773     0.200
    18.767   257.984     0.200
    20.628   277.965     0.200
     1.121    19.977     0.200
     1.121    19.539     0.200
     1.205    21.156     0.200
     1.282    22.238     0.200
     1.423    23.488     0.200
     1.407    24.719     0.200
     1.480    25.797     0.200
     1.480    25.449     0.200
     1.480    25.926     0.200
     1.709    27.617     0.200
     1.931    31.027     0.200
     1.826    30.398     0.200
     1.841    30.598     0.200
     1.871    31.059     0.200
     2.027    33.355     0.200
     2.027    34.078     0.200
     2.063    33.977     0.200
     2.076    33.918     0.200
     2.756    41.797     0.200
     3.053    44.957     0.200
     3.041    46.539     0.200
     2.937    46.379     0.200
     3.142    47.809     0.200
     3.722    55.066     0.200
     3.829    55.008     0.200
     3.816    56.777     0.200
     3.879    57.508     0.200
     3.959    58.746     0.200
     4.170    61.836     0.200
     4.279    62.719     0.200
     4.149    63.426     0.200
     4.192    64.379     0.200
     4.192    63.527     0.200
     4.342    63.867     0.200
     4.222    64.078     0.200
     4.469    64.070     0.200
     4.469    65.477     0.200
     4.320    65.156     0.200
     4.489    67.289     0.200
     4.593    68.566     0.200
     4.728    69.516     0.200
     4.682    69.777     0.200
     4.682    69.379     0.200
     4.904    72.309     0.200
     4.892    71.547     0.200
     4.776    70.996     0.200
     4.973    72.957     0.200
     5.323    77.098     0.200
     5.299    77.688     0.200
     5.346    78.129     0.200
     5.600    81.418     0.200
     5.710    82.746     0.200
     5.920    86.988     0.200
     5.917    85.996     0.200
     5.983    87.117     0.200
     5.996    86.977     0.200
     6.164    88.316     0.200
     6.074    89.328     0.200
     6.151    88.777     0.200
     6.130    89.559     0.200
     6.350    91.438     0.200
     6.388    91.797     0.200
     6.563    95.066     0.200
     6.791    97.656     0.200
     6.804    98.586     0.200
     6.853    99.117     0.200
     7.231   104.156     0.200
     7.269   103.918     0.200
     7.387   105.469     0.200
     7.425   106.527     0.200
     7.583   108.629     0.200
     7.594   109.316     0.200
     7.571   108.816     0.200
     7.721   111.469     0.200
     7.852   112.559     0.200
     8.272   119.188     0.200
     8.550   121.488     0.200
     8.476   120.605     0.200
     8.535   121.828     0.200
     8.596   122.629     0.200
     8.767   123.879     0.200
     8.816   125.777     0.200
     8.945   126.668     0.200
     9.198   131.199     0.200
     9.600   137.008     0.200
     9.610   137.578     0.200
     9.911   139.496     0.200
    10.265   145.797     0.200
    10.578   149.527     0.200
    11.081   156.219     0.200
    11.042   156.836     0.200
    11.528   159.426     0.200
     0.373     9.652     0.200
     0.816    15.963     0.200
     0.851    16.973     0.200
     0.852    16.863     0.200
     0.874    17.232     0.200
     1.036    19.402     0.200
     1.046    19.252     0.200
     1.231    21.203     0.200
     1.397    23.412     0.200
     1.380    23.793     0.200
     1.412    24.342     0.200
     1.413    24.523     0.200
     1.413    24.422     0.200
     1.453    24.523     0.200
     1.769    28.434     0.200
     1.980    31.883     0.200
     1.912    32.783     0.200
     2.209    34.922     0.200
     2.118    35.152     0.200
     2.896    42.402     0.200
     2.896    42.812     0.200
     3.060    46.662     0.200
     3.154    49.363     0.200
     3.197    49.104     0.200
     3.298    51.014     0.200
     3.302    51.252     0.200
     3.307    51.283     0.200
     3.326    51.422     0.200
     3.337    52.043     0.200
     3.365    52.283     0.200
     3.513    53.213     0.200
     3.556    53.643     0.200
     3.626    54.742     0.200
     3.698    55.842     0.200
     3.893    57.902     0.200
     3.846    58.293     0.200
     3.956    59.863     0.200
     4.110    61.104     0.200
     4.262    62.812     0.200
     4.226    62.203     0.200
     4.286    63.643     0.200
     4.373    65.023     0.200
     4.309    63.693     0.200
     4.473    66.652     0.200
     4.612    66.902     0.200
     4.612    66.383     0.200
     4.632    67.803     0.200
     4.639    69.113     0.200
     4.749    69.684     0.200
     4.750    70.252     0.200
     4.768    70.422     0.200
     4.721    70.342     0.200
     4.740    70.312     0.200
     4.806    69.832     0.200
     4.798    71.002     0.200
     5.003    72.893     0.200
     5.210    74.098     0.200
     5.210    74.713     0.200
     5.145    74.764     0.200
     5.210    76.072     0.200
     5.266    76.312     0.200
     5.446    78.943     0.200
     5.657    82.752     0.200
     5.665    83.023     0.200
     5.735    82.752     0.200
     5.837    84.184     0.200
     5.845    84.623     0.200
     5.892    85.934     0.200
     5.898    86.752     0.200
     6.189    89.082     0.200
     6.220    89.912     0.200
     6.388    92.832     0.200
     6.455    93.732     0.200
     6.774    97.053     0.200
     6.742    96.242     0.200
     6.774    96.934     0.200
     6.977    99.883     0.200
     7.311   105.193     0.200
     7.360   105.752     0.200
     7.608   110.303     0.200
     7.642   110.033     0.200
     7.795   111.383     0.200
     7.844   111.412     0.200
     7.797   111.143     0.200
     7.844   111.842     0.200
     7.920   114.523     0.200
     7.966   113.533     0.200
     8.360   119.072     0.200
     8.436   119.873     0.200
     8.476   119.684     0.200
     8.536   123.072     0.200
     8.621   123.703     0.200
     8.739   122.943     0.200
     8.939   126.773     0.200
     9.017   127.014     0.200
     9.020   127.934     0.200
     9.086   128.633     0.200
     9.112   128.043     0.200
     9.237   129.703     0.200
     9.245   128.354     0.200
     9.344   131.373     0.200
     9.428   131.354     0.200
     9.552   134.172     0.200
     9.638   135.303     0.200
     9.638   135.023     0.200
     9.724   136.443     0.200
     9.764   137.922     0.200
     9.733   137.723     0.200
     9.923   139.422     0.200
     9.927   140.793     0.200
    10.061   141.283     0.200
    10.154   144.604     0.200
    10.263   144.934     0.200
    10.770   151.812     0.200
    10.959   155.434     0.200
    10.991   155.514     0.200
    11.520   162.684     0.200
    11.927   166.912     0.200
    13.610   190.773     0.200
    14.186   199.123     0.200
    15.063   210.002     0.200
    15.392   214.514     0.200
    16.056   221.883     0.200
    16.165   222.992     0.200
     1.137    20.859     0.200
     1.143    20.660     0.200
     1.299    22.480     0.200
     1.299    22.590     0.200
     1.303    22.660     0.200
     1.373    23.902     0.200
     1.461    25.090     0.200
     1.464    25.391     0.200
     1.501    26.121     0.200
     1.502    26.223     0.200
     1.524    26.082     0.200
     1.524    26.230     0.200
     1.546    26.641     0.200
     1.817    29.883     0.200
     2.041    33.480     0.200
     1.985    33.980     0.200
     2.188    36.711     0.200
     2.868    44.062     0.200
     2.868    43.781     0.200
     3.128    48.633     0.200
     3.203    50.699     0.200
     3.203    50.820     0.200
     3.246    50.859     0.200
     3.276    51.781     0.200
     3.346    52.500     0.200
     3.346    52.723     0.200
     3.374    52.531     0.200
     3.374    52.930     0.200
     3.463    52.980     0.200
     3.463    53.352     0.200
     3.561    54.441     0.200
     3.561    54.672     0.200
     3.613    54.840     0.200
     3.613    55.172     0.200
     3.691    56.160     0.200
     3.691    56.301     0.200
     3.742    57.562     0.200
     3.883    58.262     0.200
     3.833    58.812     0.200
     3.890    59.641     0.200
     3.967    60.672     0.200
     4.213    62.961     0.200
     4.213    63.102     0.200
     4.342    64.152     0.200
     4.380    65.449     0.200
     4.422    66.211     0.200
     4.438    65.621     0.200
     4.614    66.961     0.200
     4.614    66.832     0.200
     4.796    70.770     0.200
     4.803    71.492     0.200
     4.845    72.223     0.200
     4.845    72.570     0.200
     4.906    71.973     0.200
     4.906    72.699     0.200
     5.133    75.090     0.200
     5.221    75.152     0.200
     5.236    76.840     0.200
     5.333    78.180     0.200
     5.333    78.371     0.200
     5.329    78.062     0.200
     5.697    83.121     0.200
     5.697    83.250     0.200
     5.730    84.500     0.200
     5.933    85.992     0.200
     5.933    86.211     0.200
     5.975    86.520     0.200
     6.020    88.762     0.200
     6.020    88.660     0.200
     6.228    90.383     0.200
     6.307    91.430     0.200
     6.372    92.812     0.200
     6.505    94.641     0.200
     6.621    95.270     0.200
     6.741    97.852     0.200
     6.741    97.492     0.200
     6.810    97.883     0.200
     6.869    97.930     0.200
     6.890    98.973     0.200
     7.069   101.941     0.200
     7.378   105.301     0.200
     7.448   106.762     0.200
     7.486   107.191     0.200
     7.628   109.281     0.200
     7.726   111.492     0.200
     7.839   112.422     0.200
     7.878   112.820     0.200
     7.886   113.242     0.200
     7.955   113.891     0.200
     8.089   115.402     0.200
     8.456   120.012     0.200
     8.592   121.340     0.200
     8.671   123.102     0.200
     8.778   124.383     0.200
     8.833   125.402     0.200
     9.263   131.152     0.200
     9.279   130.441     0.200
     9.458   132.551     0.200
     9.474   134.410     0.200
     9.770   137.742     0.200
     9.859   139.340     0.200
    10.034   143.141     0.200
    11.006   155.449     0.200
    11.166   158.539     0.200
    11.621   164.430     0.200
    12.082   170.789     0.200
    13.636   191.730     0.200
    15.113   212.902     0.200
    15.587   217.812     0.200
    16.117   223.902     0.200
    16.725   230.281     0.200
     1.051    19.877     0.200
     1.060    19.697     0.200
     1.255    22.016     0.200
     1.420    24.467     0.200
     1.407    24.957     0.200
     1.440    25.336     0.200
     1.441    25.617     0.200
     1.789    29.416     0.200
     1.919    32.336     0.200
     2.003    32.666     0.200
     2.124    35.307     0.200
     3.084    47.527     0.200
     3.155    49.986     0.200
     3.155    50.367     0.200
     3.228    50.717     0.200
     3.228    51.137     0.200
     3.427    52.307     0.200
     3.533    54.137     0.200
     3.533    54.436     0.200
     3.578    54.496     0.200
     3.650    55.627     0.200
     3.698    56.447     0.200
     3.698    56.787     0.200
     3.787    57.576     0.200
     3.846    58.596     0.200
     4.130    61.686     0.200
     4.179    62.346     0.200
     4.229    62.967     0.200
     4.265    63.736     0.200
     4.259    63.506     0.200
     4.334    65.346     0.200
     4.316    64.557     0.200
     4.394    65.576     0.200
     4.394    65.877     0.200
     4.343    64.926     0.200
     4.494    67.447     0.200
     4.622    67.977     0.200
     4.772    70.916     0.200
     4.794    71.646     0.200
     4.837    72.166     0.200
     5.037    74.256     0.200
     5.222    76.416     0.200
     5.174    75.926     0.200
     5.174    76.146     0.200
     5.244    77.736     0.200
     5.466    79.787     0.200
     5.466    80.016     0.200
     5.699    84.367     0.200
     5.769    83.727     0.200
     5.867    86.105     0.200
     5.879    85.457     0.200
     5.920    87.777     0.200
     6.148    89.646     0.200
     6.248    90.797     0.200
     6.410    93.746     0.200
     6.523    94.807     0.200
     6.691    97.596     0.200
     6.670    96.506     0.200
     6.792    97.967     0.200
     7.006   101.596     0.200
     7.346   106.127     0.200
     7.394   106.977     0.200
     7.558   108.367     0.200
     7.825   112.477     0.200
     7.876   112.506     0.200
     7.991   114.777     0.200
     8.367   119.547     0.200
     8.460   122.396     0.200
     8.509   120.867     0.200
     9.049   129.566     0.200
     9.253   131.096     0.200
     9.403   133.656     0.200
     9.516   135.746     0.200
     9.794   139.506     0.200
    10.527   149.516     0.200
    11.551   163.836     0.200
     1.752    30.533     0.200
     1.662    30.254     0.200
     1.898    33.023     0.200
     1.925    33.314     0.200
     1.927    33.754     0.200
     1.853    32.385     0.200
     2.287    38.174     0.200
     2.730    44.055     0.200
     2.802    46.545     0.200
     2.845    47.334     0.200
     2.845    47.004     0.200
     2.874    47.215     0.200
     2.947    47.744     0.200
     2.958    48.324     0.200
     2.962    48.623     0.200
     2.973    48.344     0.200
     2.993    49.234     0.200
     3.328    53.334     0.200
     3.328    53.084     0.200
     3.423    54.234     0.200
     3.581    56.154     0.200
     3.554    56.184     0.200
     3.926    59.885     0.200
     4.031    62.555     0.200
     4.077    61.895     0.200
     4.148    64.123     0.200
     4.350    65.334     0.200
     4.339    67.395     0.200
     4.678    70.623     0.200
     4.523    69.824     0.200
     4.692    70.584     0.200
     4.730    71.863     0.200
     4.763    71.725     0.200
     4.791    73.113     0.200
     4.832    72.684     0.200
     4.892    73.664     0.200
     4.991    74.975     0.200
     5.088    75.234     0.200
     5.088    75.033     0.200
     5.150    76.824     0.200
     5.267    79.193     0.200
     5.270    78.953     0.200
     5.286    80.164     0.200
     5.304    79.453     0.200
     5.322    79.555     0.200
     5.414    80.725     0.200
     5.654    84.113     0.200
     5.665    84.215     0.200
     5.699    82.777     0.200
     5.699    83.113     0.200
     5.787    86.033     0.200
     5.859    88.234     0.200
     5.859    86.984     0.200
     5.963    88.113     0.200
     6.030    89.645     0.200
     6.068    89.885     0.200
     6.338    93.354     0.200
     6.589    96.623     0.200
     6.710   100.094     0.200
     6.732   100.023     0.200
     6.883   100.703     0.200
     6.908   100.773     0.200
     7.131   103.795     0.200
     7.183   104.533     0.200
     7.235   105.123     0.200
     7.360   108.693     0.200
     7.484   109.023     0.200
     7.745   112.023     0.200
     7.784   112.994     0.200
     8.306   119.914     0.200
     8.312   121.744     0.200
     8.318   120.135     0.200
     8.345   120.703     0.200
     8.254   122.533     0.200
     8.775   126.113     0.200
     8.879   128.033     0.200
     9.215   131.754     0.200
     9.253   132.404     0.200
     9.527   137.354     0.200
     9.741   139.354     0.200
     9.865   140.863     0.200
     9.800   143.135     0.200
    10.140   143.994     0.200
    10.266   147.094     0.200
    10.573   150.443     0.200
    10.791   153.545     0.200
    11.353   162.934     0.200
    11.377   162.645     0.200
    11.405   162.094     0.200
    12.325   176.885     0.200
    12.448   172.584     0.200
    12.550   178.895     0.200
    12.769   181.533     0.200
    14.114   198.914     0.200
    14.303   203.623     0.200
    14.494   204.805     0.200
    14.620   206.904     0.200
    15.009   212.084     0.200
    15.073   212.193     0.200
    15.062   212.734     0.200
    15.133   214.334     0.200
    16.050   224.703     0.200
    16.577   232.344     0.200
     0.423     8.879     0.200
     0.434     9.051     0.200
     0.442    10.879     0.200
     0.442    11.129     0.200
     0.813    15.410     0.200
     0.995    18.449     0.200
     1.047    19.379     0.200
     1.165    20.910     0.200
     1.292    21.488     0.200
     1.230    21.738     0.200
     1.223    21.770     0.200
     1.312    23.348     0.200
     1.452    24.969     0.200
     1.526    25.199     0.200
     1.472    25.000     0.200
     1.759    28.578     0.200
     1.921    31.777     0.200
     2.404    36.078     0.200
     2.369    38.230     0.200
     2.617    40.078     0.200
     2.942    44.598     0.200
     3.035    46.398     0.200
     3.090    47.180     0.200
     3.176    48.641     0.200
     3.388    49.301     0.200
     3.690    55.020     0.200
     3.681    57.277     0.200
     3.681    54.117     0.200
     3.768    56.230     0.200
     3.835    57.129     0.200
     3.818    57.238     0.200
     3.895    58.320     0.200
     3.912    57.820     0.200
     3.993    59.609     0.200
     3.942    58.059     0.200
     4.103    59.508     0.200
     4.150    60.598     0.200
     4.104    60.449     0.200
     4.188    62.980     0.200
     4.268    62.848     0.200
     4.278    63.160     0.200
     4.344    63.551     0.200
     4.449    64.770     0.200
     4.702    67.668     0.200
     4.756    69.859     0.200
     4.808    70.258     0.200
     4.962    72.520     0.200
     4.941    72.340     0.200
     5.221    76.469     0.200
     5.268    77.391     0.200
     5.466    80.160     0.200
     5.489    79.559     0.200
     5.532    80.648     0.200
     5.648    81.648     0.200
     5.819    84.891     0.200
     5.808    84.527     0.200
     5.921    85.449     0.200
     6.237    90.688     0.200
     6.281    90.410     0.200
     6.181    89.578     0.200
     6.181    90.148     0.200
     6.205    89.867     0.200
     6.290    91.309     0.200
     6.377    92.277     0.200
     6.309    90.457     0.200
     6.486    93.000     0.200
     6.571    94.301     0.200
     6.517    92.938     0.200
     7.132   101.730     0.200
     7.170   102.570     0.200
     7.183   103.320     0.200
     7.311   104.801     0.200
     7.402   106.348     0.200
     7.530   107.469     0.200
     7.780   110.508     0.200
     7.881   112.980     0.200
     8.145   115.680     0.200
     8.077   114.969     0.200
     8.249   116.848     0.200
     8.184   116.020     0.200
     8.386   119.391     0.200
     8.736   121.707     0.200
     8.683   123.180     0.200
     8.930   124.289     0.200
     9.017   127.508     0.200
     9.103   131.379     0.200
     9.103   128.520     0.200
     9.387   133.457     0.200
     9.531   133.348     0.200
     9.724   137.809     0.200
    10.630   150.277     0.200
    10.769   152.430     0.200
    10.905   154.348     0.200
    15.063   208.918     0.200
    15.595   215.570     0.200
    17.814   243.168     0.200
     0.347     9.457     0.200
     0.557    10.457     0.200
     0.561    10.377     0.200
     0.794    16.027     0.200
     0.823    16.238     0.200
     0.847    16.797     0.200
     0.957    18.648     0.200
     0.957    18.818     0.200
     1.014    19.158     0.200
     1.026    18.998     0.200
     1.217    21.148     0.200
     1.364    23.648     0.200
     1.394    24.258     0.200
     1.395    23.748     0.200
     1.395    24.258     0.200
     1.761    28.088     0.200
     1.968    31.598     0.200
     2.196    34.527     0.200
     2.288    35.979     0.200
     2.352    37.117     0.200
     2.904    43.559     0.200
     2.904    43.139     0.200
     3.046    46.518     0.200
     3.144    49.277     0.200
     3.186    49.857     0.200
     3.186    49.469     0.200
     3.217    50.248     0.200
     3.281    50.957     0.200
     3.287    50.898     0.200
     3.291    51.318     0.200
     3.296    51.127     0.200
     3.315    51.508     0.200
     3.325    51.287     0.200
     3.333    51.768     0.200
     3.354    52.139     0.200
     3.503    53.037     0.200
     3.545    53.588     0.200
     3.613    54.547     0.200
     3.689    56.059     0.200
     3.897    57.357     0.200
     3.897    56.988     0.200
     3.777    57.318     0.200
     3.913    59.377     0.200
     4.201    62.367     0.200
     4.235    62.447     0.200
     4.201    62.328     0.200
     4.247    62.268     0.200
     4.266    62.857     0.200
     4.304    63.188     0.200
     4.282    63.158     0.200
     4.364    64.787     0.200
     4.464    66.447     0.200
     4.612    66.758     0.200
     4.612    66.219     0.200
     4.623    68.027     0.200
     4.631    69.088     0.200
     4.740    69.918     0.200
     4.740    69.988     0.200
     4.752    69.828     0.200
     4.796    70.777     0.200
     4.785    69.697     0.200
     4.713    70.479     0.200
     4.764    71.059     0.200
     4.975    72.719     0.200
     5.126    74.508     0.200
     5.208    73.451     0.200
     5.208    74.457     0.200
     5.185    75.318     0.200
     5.252    77.037     0.200
     5.437    79.438     0.200
     5.565    81.338     0.200
     5.642    82.248     0.200
     5.635    82.617     0.200
     5.709    82.268     0.200
     5.803    85.309     0.200
     5.817    84.059     0.200
     5.817    83.818     0.200
     5.871    86.357     0.200
     5.871    85.908     0.200
     6.101    89.098     0.200
     6.092    87.568     0.200
     6.175    89.428     0.200
     6.202    89.607     0.200
     6.198    89.998     0.200
     6.376    92.547     0.200
     6.382    93.107     0.200
     6.444    93.297     0.200
     6.460    92.348     0.200
     6.625    96.648     0.200
     6.617    95.127     0.200
     6.649    96.229     0.200
     6.767    96.918     0.200
     6.715    95.857     0.200
     6.749    96.758     0.200
     6.827    99.568     0.200
     6.863   100.107     0.200
     6.886   100.309     0.200
     6.958    99.318     0.200
     6.987   101.877     0.200
     7.105   100.268     0.200
     7.245   103.008     0.200
     7.281   104.537     0.200
     7.332   105.488     0.200
     7.506   106.957     0.200
     7.624   109.559     0.200
     7.786   111.127     0.200
     7.778   111.258     0.200
     7.837   111.729     0.200
     7.820   110.979     0.200
     7.904   114.078     0.200
     7.927   112.617     0.200
     8.307   117.867     0.200
     8.451   119.139     0.200
     8.644   122.168     0.200
     8.610   123.559     0.200
     8.610   123.168     0.200
     8.731   123.219     0.200
     8.706   123.348     0.200
     8.912   125.707     0.200
     9.072   129.738     0.200
     9.233   129.758     0.200
     9.351   132.258     0.200
     9.634   136.559     0.200
     9.715   136.838     0.200
    10.032   140.547     0.200
    10.054   141.188     0.200
    10.143   144.258     0.200
    10.273   144.398     0.200
    10.474   146.498     0.200
    10.747   151.787     0.200
    10.893   152.277     0.200
    10.966   155.248     0.200
    11.046   155.457     0.200
    11.819   166.037     0.200
    11.799   165.658     0.200
    11.913   164.309     0.200
    12.227   171.238     0.200
    12.243   170.309     0.200
    12.300   172.357     0.200
    12.494   175.617     0.200
    12.780   180.318     0.200
    13.969   194.328     0.200
    14.484   202.338     0.200
    14.541   201.818     0.200
    14.701   206.059     0.200
    15.052   208.857     0.200
    15.538   215.668     0.200
    16.998   232.832     0.200
    17.014   234.908     0.200
    17.159   236.568     0.200
     0.484     9.807     0.200
     0.485     9.907     0.200
     0.489    10.707     0.200
     0.878    16.887     0.200
     0.938    17.947     0.200
     0.942    18.097     0.200
     0.955    18.217     0.200
     0.965    18.587     0.200
     1.069    20.317     0.200
     1.092    20.327     0.200
     1.098    20.127     0.200
     1.509    25.847     0.200
     1.511    25.787     0.200
     1.511    25.917     0.200
     1.839    30.127     0.200
     2.060    33.127     0.200
     2.290    36.337     0.200
     2.370    37.567     0.200
     2.384    37.777     0.200
     2.907    43.747     0.200
     3.144    47.817     0.200
     3.160    50.327     0.200
     3.203    50.807     0.200
     3.203    50.017     0.200
     3.233    51.167     0.200
     3.303    51.887     0.200
     3.312    52.087     0.200
     3.331    52.327     0.200
     3.345    52.247     0.200
     3.584    54.527     0.200
     3.633    54.957     0.200
     3.709    56.067     0.200
     3.699    56.807     0.200
     3.919    58.007     0.200
     3.919    57.537     0.200
     4.234    63.047     0.200
     4.317    64.327     0.200
     4.339    63.597     0.200
     4.385    64.727     0.200
     4.387    64.527     0.200
     4.421    65.677     0.200
     4.445    66.337     0.200
     4.427    65.167     0.200
     4.543    67.867     0.200
     4.648    67.007     0.200
     4.648    67.967     0.200
     4.702    68.977     0.200
     4.637    69.927     0.200
     4.819    71.047     0.200
     4.719    71.237     0.200
     4.859    71.637     0.200
     4.874    71.277     0.200
     4.911    71.377     0.200
     5.121    74.667     0.200
     5.254    74.126     0.200
     5.254    74.977     0.200
     5.244    76.757     0.200
     5.350    78.167     0.200
     5.325    77.487     0.200
     5.514    79.697     0.200
     5.698    82.907     0.200
     5.745    83.777     0.200
     5.784    84.117     0.200
     5.885    85.957     0.200
     5.939    86.037     0.200
     5.963    85.637     0.200
     5.977    88.007     0.200
     5.977    87.387     0.200
     6.227    89.597     0.200
     6.275    90.927     0.200
     6.317    91.297     0.200
     6.465    93.477     0.200
     6.532    95.027     0.200
     6.607    94.777     0.200
     6.711    97.367     0.200
     6.755    98.127     0.200
     6.745    97.027     0.200
     6.837    98.167     0.200
     6.859    97.487     0.200
     6.887    98.937     0.200
     6.918    98.607     0.200
     6.980   100.997     0.200
     7.079   102.437     0.200
     7.077   101.957     0.200
     7.126   101.057     0.200
     7.154   102.617     0.200
     7.173   101.477     0.200
     7.430   106.557     0.200
     7.477   106.937     0.200
     7.632   108.757     0.200
     7.694   110.977     0.200
     7.863   112.347     0.200
     7.905   112.077     0.200
     7.895   112.787     0.200
     7.954   113.117     0.200
     8.011   115.267     0.200
     8.075   114.897     0.200
     8.449   119.857     0.200
     8.520   122.017     0.200
     8.589   121.237     0.200
     8.701   122.997     0.200
     8.625   124.607     0.200
     8.625   123.757     0.200
     8.803   124.417     0.200
     8.835   125.067     0.200
     9.120   128.927     0.200
     9.292   130.687     0.200
     9.478   133.967     0.200
     9.583   135.887     0.200
     9.793   137.537     0.200
     9.866   139.527     0.200
    10.008   141.877     0.200
    10.123   142.217     0.200
    10.112   142.027     0.200
    10.163   145.807     0.200
    10.163   144.577     0.200
    10.441   149.237     0.200
    10.618   149.477     0.200
    10.955   153.277     0.200
    11.078   156.587     0.200
    11.294   158.687     0.200
    11.543   161.437     0.200
    11.666   162.307     0.200
    11.906   166.537     0.200
    12.014   164.607     0.200
    12.014   167.317     0.200
    12.162   171.057     0.200
    12.338   170.277     0.200
    12.604   176.737     0.200
    12.730   178.177     0.200
    12.658   177.777     0.200
    12.892   180.817     0.200
    13.410   185.637     0.200
    14.045   195.207     0.200
    14.013   196.407     0.200
    14.084   196.417     0.200
    14.179   196.437     0.200
    14.629   202.177     0.200
    14.685   204.767     0.200
    14.981   208.837     0.200
    15.136   210.367     0.200
    15.366   213.397     0.200
    15.458   214.537     0.200
    15.607   216.937     0.200
    16.750   231.007     0.200
    16.778   231.197     0.200
    16.881   233.477     0.200
     1.127    20.439     0.200
     1.200    21.680     0.200
     1.340    23.641     0.200
     1.355    24.391     0.200
     1.355    24.301     0.200
     1.384    24.910     0.200
     1.473    26.830     0.200
     1.933    32.680     0.200
     1.936    32.850     0.200
     2.102    35.240     0.200
     2.142    36.000     0.200
     2.142    36.221     0.200
     2.143    35.189     0.200
     2.152    36.080     0.200
     2.152    36.240     0.200
     2.413    37.869     0.200
     2.654    42.471     0.200
     2.887    45.689     0.200
     3.027    48.369     0.200
     3.071    49.141     0.200
     3.071    48.730     0.200
     3.098    49.529     0.200
     3.257    49.539     0.200
     3.168    50.250     0.200
     3.178    50.250     0.200
     3.184    50.600     0.200
     3.197    50.730     0.200
     3.196    50.600     0.200
     3.224    51.080     0.200
     3.531    54.750     0.200
     3.632    56.340     0.200
     3.745    57.311     0.200
     3.756    58.180     0.200
     4.065    61.660     0.200
     4.148    63.230     0.200
     4.212    63.721     0.200
     4.303    65.160     0.200
     4.318    63.939     0.200
     4.318    63.750     0.200
     4.440    67.650     0.200
     4.521    69.061     0.200
     4.740    70.779     0.200
     4.699    70.930     0.200
     4.811    71.641     0.200
     4.829    71.900     0.200
     4.944    73.000     0.200
     4.981    74.789     0.200
     5.085    74.141     0.200
     5.085    73.869     0.200
     5.099    75.670     0.200
     5.375    79.129     0.200
     5.472    80.939     0.200
     5.548    81.340     0.200
     5.715    82.109     0.200
     5.715    82.410     0.200
     5.748    84.811     0.200
     5.874    86.420     0.200
     6.340    93.301     0.200
     6.350    93.320     0.200
     6.388    95.010     0.200
     6.574    96.180     0.200
     6.589    96.369     0.200
     6.752    98.359     0.200
     6.870    99.850     0.200
     6.891   100.910     0.200
     7.039   101.270     0.200
     7.104   103.449     0.200
     7.227   105.641     0.200
     7.279   105.779     0.200
     7.362   105.930     0.200
     7.385   107.020     0.200
     7.654   107.750     0.200
     7.707   111.760     0.200
     7.731   111.750     0.200
     8.021   115.660     0.200
     8.029   116.850     0.200
     8.109   117.410     0.200
     8.407   120.850     0.200
     8.424   120.459     0.200
     8.440   123.240     0.200
     8.440   122.240     0.200
     8.597   123.410     0.200
     8.692   125.051     0.200
     8.986   128.980     0.200
     9.087   130.520     0.200
     9.188   130.750     0.200
     9.333   132.859     0.200
     9.476   135.490     0.200
     9.518   137.080     0.200
     9.784   138.279     0.200
     9.991   140.801     0.200
    10.340   146.340     0.200
    10.277   146.520     0.200
    10.460   148.199     0.200
    10.558   149.600     0.200
    10.646   150.770     0.200
    10.988   154.789     0.200
    11.456   160.721     0.200
    11.494   161.779     0.200
    12.003   168.500     0.200
    12.262   174.010     0.200
    12.377   174.430     0.200
    12.455   176.119     0.200
    12.610   175.459     0.200
    12.610   173.824     0.200
    12.610   175.459     0.200
    12.516   176.699     0.200
    12.724   179.619     0.200
    12.800   182.189     0.200
    13.117   183.551     0.200
    13.317   186.699     0.200
    13.543   191.320     0.200
    14.029   197.430     0.200
    14.157   197.480     0.200
    14.491   202.340     0.200
    14.491   201.619     0.200
    14.582   203.160     0.200
    14.591   204.000     0.200
    14.628   203.590     0.200
    14.832   208.670     0.200
    14.981   210.830     0.200
    15.051   211.340     0.200
    15.176   213.260     0.200
    15.194   210.449     0.200
    15.543   217.830     0.200
    15.574   219.820     0.200
    15.989   223.689     0.200
    16.087   224.971     0.200
    16.178   223.600     0.200
    16.208   225.500     0.200
    16.297   226.109     0.200
    16.304   225.939     0.200
    16.636   230.090     0.200
    16.714   231.340     0.200
    16.913   236.029     0.200
    17.322   238.150     0.200
    17.324   239.010     0.200
    17.352   240.789     0.200
    17.832   245.209     0.200
    17.926   246.070     0.200
     0.500     9.198     0.200
     0.503     9.479     0.200
     0.416     9.898     0.200
     0.416    10.108     0.200
     0.850    16.378     0.200
     0.894    17.268     0.200
     0.894    17.128     0.200
     0.914    17.608     0.200
     0.927    18.038     0.200
     1.026    19.588     0.200
     1.068    19.778     0.200
     1.077    19.638     0.200
     1.255    21.598     0.200
     1.409    24.098     0.200
     1.443    24.838     0.200
     1.786    29.229     0.200
     2.231    35.108     0.200
     3.084    47.368     0.200
     3.211    50.198     0.200
     3.211    50.308     0.200
     3.242    50.508     0.200
     3.307    51.128     0.200
     3.340    51.498     0.200
     3.352    52.438     0.200
     3.711    56.198     0.200
     3.711    56.448     0.200
     3.891    58.298     0.200
     3.891    57.828     0.200
     3.800    57.488     0.200
     3.935    59.758     0.200
     4.177    62.168     0.200
     4.262    63.528     0.200
     4.266    62.768     0.200
     4.331    64.428     0.200
     4.319    64.028     0.200
     4.391    65.018     0.200
     4.353    64.398     0.200
     4.490    65.838     0.200
     4.613    67.398     0.200
     4.613    67.008     0.200
     4.649    68.108     0.200
     4.766    70.248     0.200
     4.769    70.028     0.200
     4.795    70.638     0.200
     4.733    69.808     0.200
     4.841    71.148     0.200
     5.048    73.948     0.200
     5.215    74.967     0.200
     5.215    74.638     0.200
     5.177    75.398     0.200
     5.290    76.878     0.200
     5.251    76.608     0.200
     5.462    79.818     0.200
     5.626    81.808     0.200
     5.683    83.098     0.200
     5.711    83.738     0.200
     5.778    83.428     0.200
     5.870    84.988     0.200
     5.889    84.979     0.200
     5.938    87.498     0.200
     5.938    86.708     0.200
     6.155    88.958     0.200
     6.214    90.998     0.200
     6.251    90.148     0.200
     6.278    90.808     0.200
     6.408    92.348     0.200
     6.534    94.088     0.200
     6.692    96.948     0.200
     6.675    95.558     0.200
     6.785    96.918     0.200
     6.814    98.048     0.200
     7.009   100.488     0.200
     7.307   104.188     0.200
     7.358   105.198     0.200
     7.403   106.278     0.200
     7.562   107.718     0.200
     7.857   110.628     0.200
     7.828   111.238     0.200
     7.882   112.238     0.200
     7.947   112.328     0.200
     8.002   114.078     0.200
     8.376   118.608     0.200
     8.516   120.248     0.200
     8.753   123.708     0.200
     8.635   123.998     0.200
     8.765   124.658     0.200
     9.052   128.178     0.200
     9.247   129.958     0.200
     9.440   132.028     0.200
     9.408   133.158     0.200
     9.741   137.058     0.200
     9.797   139.238     0.200
    10.170   146.498     0.200
    11.004   154.958     0.200
    11.555   162.898     0.200
    12.092   169.748     0.200
    14.562   202.148     0.200
    14.572   202.398     0.200
    16.078   221.418     0.200
    16.561   228.778     0.200
    16.692   229.038     0.200
    16.725   230.308     0.200
    17.194   235.808     0.200
    17.306   236.828     0.200
    18.295   249.828     0.200
     1.186    20.625     0.200
     1.164    21.105     0.200
     1.188    21.797     0.200
     1.218    22.215     0.200
     1.233    22.598     0.200
     1.366    23.996     0.200
     1.416    24.926     0.200
     1.416    24.688     0.200
     1.326    23.746     0.200
     1.383    24.605     0.200
     1.393    24.426     0.200
     1.648    26.688     0.200
     1.892    30.867     0.200
     2.289    37.195     0.200
     2.983    46.027     0.200
     3.300    50.785     0.200
     3.540    54.156     0.200
     3.640    54.258     0.200
     3.465    55.035     0.200
     3.508    56.027     0.200
     3.538    55.527     0.200
     3.637    56.758     0.200
     3.978    59.805     0.200
     4.046    60.695     0.200
     4.069    61.098     0.200
     4.182    62.477     0.200
     4.003    61.625     0.200
     4.003    61.406     0.200
     4.095    62.656     0.200
     4.284    64.477     0.200
     4.302    63.676     0.200
     4.381    63.727     0.200
     4.228    64.516     0.200
     4.442    65.707     0.200
     4.630    68.828     0.200
     4.665    68.848     0.200
     4.714    69.777     0.200
     4.820    71.105     0.200
     4.996    71.695     0.200
     4.996    71.828     0.200
     5.129    75.746     0.200
     5.182    76.406     0.200
     5.143    75.656     0.200
     5.022    75.555     0.200
     5.304    77.758     0.200
     5.298    77.715     0.200
     5.588    82.188     0.200
     5.700    83.695     0.200
     5.839    85.297     0.200
     5.840    84.727     0.200
     5.844    85.938     0.200
     5.984    86.855     0.200
     6.191    90.527     0.200
     6.174    89.918     0.200
     6.240    92.828     0.200
     6.468    93.586     0.200
     6.611    94.605     0.200
     6.605    96.215     0.200
     6.661    96.535     0.200
     6.640    95.727     0.200
     6.848    98.676     0.200
     6.962   100.957     0.200
     7.317   105.215     0.200
     7.478   107.738     0.200
     7.542   108.535     0.200
     7.774   111.855     0.200
     7.897   113.328     0.200
     8.110   116.445     0.200
     8.432   120.387     0.200
     8.582   121.648     0.200
     8.757   125.207     0.200
     8.846   128.078     0.200
     9.050   127.258     0.200
     9.076   128.137     0.200
     8.930   127.426     0.200
     8.930   128.668     0.200
     9.250   129.695     0.200
     9.389   133.586     0.200
     9.897   140.055     0.200
    10.469   147.328     0.200
    11.846   164.707     0.200
    18.170   247.875     0.200
     0.411    10.156     0.200
     0.514     9.648     0.200
     0.838    16.602     0.200
     0.882    17.609     0.200
     0.902    17.789     0.200
     1.014    19.867     0.200
     1.056    20.055     0.200
     1.065    19.781     0.200
     1.257    22.031     0.200
     1.444    25.086     0.200
     1.790    29.102     0.200
     2.233    35.336     0.200
     3.086    47.102     0.200
     3.201    49.758     0.200
     3.201    50.281     0.200
     3.342    51.906     0.200
     3.429    52.164     0.200
     3.701    56.758     0.200
     3.701    56.438     0.200
     3.790    57.750     0.200
     3.899    57.758     0.200
     3.899    56.945     0.200
     4.263    62.750     0.200
     4.318    63.797     0.200
     4.348    64.148     0.200
     4.621    66.961     0.200
     4.621    66.555     0.200
     4.796    70.617     0.200
     4.840    70.727     0.200
     5.042    74.008     0.200
     5.222    74.828     0.200
     5.222    74.648     0.200
     5.222    75.016     0.200
     5.248    77.180     0.200
     5.705    83.602     0.200
     5.870    85.180     0.200
     5.884    85.258     0.200
     5.926    86.859     0.200
     5.926    87.211     0.200
     6.251    90.508     0.200
     6.411    92.508     0.200
     6.673    95.930     0.200
     6.811    97.961     0.200
     6.863    98.828     0.200
     7.351   105.531     0.200
     7.561   108.188     0.200
     7.677   110.352     0.200
     7.992   114.539     0.200
     8.382   119.500     0.200
     8.625   124.258     0.200
     8.625   123.758     0.200
     8.663   122.164     0.200
     8.939   126.555     0.200
     8.939   126.758     0.200
     8.977   127.375     0.200
     9.135   128.570     0.200
     9.164   130.219     0.200
     9.366   130.891     0.200
     9.653   135.555     0.200
     9.653   135.109     0.200
     9.721   139.750     0.200
     9.745   135.859     0.200
     9.940   139.281     0.200
     9.976   140.617     0.200
    10.034   141.734     0.200
    10.049   141.305     0.200
    10.160   144.555     0.200
    10.160   144.656     0.200
    10.160   145.164     0.200
    10.437   148.305     0.200
    10.531   148.711     0.200
    10.539   149.078     0.200
    10.999   155.539     0.200
    11.554   162.391     0.200
    11.754   165.961     0.200
    11.771   166.055     0.200
    11.771   164.758     0.200
    11.771   166.398     0.200
    11.954   164.945     0.200
    11.954   165.219     0.200
    12.307   173.258     0.200
    12.560   174.367     0.200
    13.122   184.117     0.200
    14.306   200.758     0.200
    14.440   202.188     0.200
    14.612   202.930     0.200
    14.699   206.258     0.200
    15.158   211.703     0.200
    15.158   211.461     0.200
    15.158   211.156     0.200
    15.576   217.961     0.200
    19.313   262.359     0.200
    20.195   272.219     0.200
     1.066    20.050     0.200
     1.157    21.780     0.200
     1.167    22.020     0.200
     1.169    21.980     0.200
     1.175    22.400     0.200
     1.287    24.520     0.200
     1.267    23.330     0.200
     1.266    23.010     0.200
     1.497    26.080     0.200
     1.662    28.870     0.200
     1.705    29.440     0.200
     1.973    32.300     0.200
     2.607    43.160     0.200
     3.223    51.910     0.200
     3.267    52.770     0.200
     3.296    53.170     0.200
     3.366    53.920     0.200
     3.379    53.890     0.200
     3.394    54.430     0.200
     3.413    54.740     0.200
     3.712    57.160     0.200
     3.862    59.450     0.200
     3.948    59.880     0.200
     3.751    58.710     0.200
     3.977    61.900     0.200
     4.372    66.290     0.200
     4.445    66.650     0.200
     4.563    68.310     0.200
     4.698    68.790     0.200
     4.667    70.000     0.200
     4.957    73.500     0.200
     5.029    74.770     0.200
     5.112    75.220     0.200
     5.318    75.699     0.200
     5.318    77.820     0.200
     5.363    79.450     0.200
     5.553    82.280     0.200
     5.633    83.080     0.200
     5.907    87.190     0.200
     5.913    87.470     0.200
     6.033    88.930     0.200
     6.085    89.350     0.200
     6.136    90.200     0.200
     6.205    90.880     0.200
     6.172    91.420     0.200
     6.446    94.190     0.200
     6.499    94.070     0.200
     6.601    95.740     0.200
     6.597    96.310     0.200
     6.876    97.980     0.200
     6.852    99.400     0.200
     6.940   100.880     0.200
     6.923   101.010     0.200
     6.950   100.890     0.200
     7.059   102.290     0.200
     7.097   102.690     0.200
     7.111   102.840     0.200
     7.231   102.910     0.200
     7.266   106.180     0.200
     7.293   105.190     0.200
     7.594   109.660     0.200
     7.679   111.960     0.200
     7.835   113.540     0.200
     7.979   114.090     0.200
     8.081   117.240     0.200
     8.172   117.330     0.200
     8.320   120.360     0.200
     8.555   123.810     0.200
     8.674   124.860     0.200
     8.681   124.060     0.200
     8.813   125.910     0.200
     9.044   129.760     0.200
     9.315   133.590     0.200
     9.309   134.470     0.200
     9.326   133.260     0.200
     9.287   133.020     0.200
     9.376   132.960     0.200
     9.404   134.100     0.200
     9.541   134.690     0.200
     9.577   135.250     0.200
     9.681   138.460     0.200
     9.911   140.830     0.200
     9.786   142.870     0.200
     9.803   141.520     0.200
    10.069   143.470     0.200
    10.061   143.180     0.200
    10.503   151.640     0.200
    10.755   152.220     0.200
    10.848   154.170     0.200
    11.044   156.410     0.200
    11.328   159.690     0.200
    11.352   161.200     0.200
    11.322   161.010     0.200
    11.457   159.820     0.200
    11.609   163.600     0.200
    11.654   165.370     0.200
    11.778   165.710     0.200
    11.824   167.290     0.200
    11.826   167.360     0.200
    11.856   165.530     0.200
    12.037   169.740     0.200
    12.107   171.940     0.200
    12.169   170.680     0.200
    12.169   168.830     0.200
    12.301   173.600     0.200
    12.334   173.940     0.200
    12.302   174.000     0.200
    12.364   174.850     0.200
    12.478   175.900     0.200
    12.483   174.300     0.200
    12.713   176.730     0.200
    12.774   179.530     0.200
    12.836   180.870     0.200
    12.940   182.220     0.200
    12.951   183.260     0.200
    13.041   185.180     0.200
    13.179   186.170     0.200
    13.749   193.920     0.200
    13.897   195.790     0.200
    13.949   197.980     0.200
    14.233   202.350     0.200
    14.760   207.330     0.200
    14.768   207.650     0.200
    14.841   207.360     0.200
    15.046   210.790     0.200
    15.133   214.070     0.200
    15.187   212.920     0.200
    17.270   238.240     0.200
    17.394   240.520     0.200
    17.492   242.280     0.200
     1.513    26.125     0.200
     1.513    26.285     0.200
     1.664    28.738     0.200
     1.697    29.457     0.200
     1.697    28.918     0.200
     1.697    29.148     0.200
     2.042    33.566     0.200
     2.259    36.688     0.200
     2.259    37.008     0.200
     2.489    39.766     0.200
     2.489    40.207     0.200
     2.646    42.035     0.200
     2.646    42.648     0.200
     3.182    48.375     0.200
     3.341    51.727     0.200
     3.786    58.258     0.200
     3.834    58.488     0.200
     3.834    58.668     0.200
     3.900    59.707     0.200
     3.900    60.156     0.200
     4.435    66.438     0.200
     4.435    66.637     0.200
     4.481    67.035     0.200
     4.496    66.938     0.200
     4.519    67.637     0.200
     4.561    67.988     0.200
     4.569    69.008     0.200
     4.848    70.668     0.200
     5.027    75.066     0.200
     5.051    74.309     0.200
     5.087    74.906     0.200
     5.251    77.508     0.200
     5.455    79.098     0.200
     5.476    81.066     0.200
     5.717    82.926     0.200
     5.864    86.469     0.200
     5.892    85.988     0.200
     5.940    88.047     0.200
     5.996    87.535     0.200
     6.092    88.918     0.200
     6.119    89.457     0.200
     6.389    93.105     0.200
     6.504    95.168     0.200
     6.665    97.176     0.200
     6.730    97.105     0.200
     6.919   100.496     0.200
     6.948   101.648     0.200
     7.040   103.035     0.200
     7.043   102.117     0.200
     7.118   104.207     0.200
     7.260   105.617     0.200
     7.534   109.148     0.200
     7.614   110.156     0.200
     7.808   112.688     0.200
     8.066   116.258     0.200
     8.080   116.188     0.200
     8.109   116.156     0.200
     8.118   116.398     0.200
     8.195   116.926     0.200
     8.456   123.418     0.200
     8.595   123.016     0.200
     8.746   124.547     0.200
     9.007   128.266     0.200
     9.199   131.406     0.200
     9.388   133.188     0.200
     9.495   134.617     0.200
     9.510   134.078     0.200
     9.653   137.867     0.200
     9.690   136.316     0.200
     9.773   139.875     0.200
    10.046   142.488     0.200
    10.276   148.598     0.200
    10.288   145.117     0.200
    10.327   145.527     0.200
    10.745   152.117     0.200
    10.818   152.688     0.200
    11.207   158.316     0.200
    11.201   159.426     0.200
    13.781   193.926     0.200
    13.869   193.375     0.200
    13.909   192.418     0.200
    14.830   205.828     0.200
    14.861   206.355     0.200
    15.808   219.746     0.200
    15.956   221.777     0.200
    16.335   227.926     0.200
    16.735   231.516     0.200
    16.950   234.945     0.200
    16.981   235.316     0.200
    17.563   240.445     0.200
     0.573    11.858     0.200
     0.573    12.028     0.200
     0.563    12.798     0.200
     0.679    14.478     0.200
     0.693    14.768     0.200
     0.826    13.958     0.200
     0.827    13.848     0.200
     0.765    15.758     0.200
     0.767    15.578     0.200
     0.798    16.448     0.200
     1.496    25.368     0.200
     1.625    27.768     0.200
     1.646    28.308     0.200
     1.646    26.978     0.200
     2.060    32.088     0.200
     2.253    35.858     0.200
     2.477    38.758     0.200
     2.562    39.988     0.200
     2.826    44.938     0.200
     2.869    45.258     0.200
     2.869    44.468     0.200
     2.899    45.908     0.200
     2.998    48.238     0.200
     3.010    45.578     0.200
     3.318    50.478     0.200
     3.369    51.758     0.200
     3.369    51.358     0.200
     3.458    53.078     0.200
     3.678    55.788     0.200
     3.593    55.048     0.200
     3.796    57.718     0.200
     3.829    57.878     0.200
     4.394    65.348     0.200
     4.368    63.898     0.200
     4.310    65.428     0.200
     4.430    65.667     0.200
     4.398    64.898     0.200
     4.490    65.478     0.200
     4.392    66.288     0.200
     4.526    67.268     0.200
     4.608    68.218     0.200
     4.918    72.058     0.200
     4.933    70.458     0.200
     4.933    70.778     0.200
     5.006    73.368     0.200
     4.996    72.688     0.200
     5.027    74.278     0.200
     5.034    74.018     0.200
     5.082    74.468     0.200
     5.338    77.938     0.200
     5.356    77.588     0.200
     5.526    78.812     0.200
     5.521    81.108     0.200
     5.733    83.258     0.200
     5.699    83.338     0.200
     5.669    83.858     0.200
     5.749    83.688     0.200
     5.845    84.358     0.200
     5.903    86.728     0.200
     5.921    85.788     0.200
     6.033    86.828     0.200
     6.267    90.298     0.200
     6.438    92.688     0.200
     6.551    94.488     0.200
     6.658    95.868     0.200
     6.726    97.288     0.200
     6.818    97.728     0.200
     6.834    97.558     0.200
     6.903    99.868     0.200
     6.910    98.958     0.200
     7.069   101.088     0.200
     7.105   102.588     0.200
     7.161   102.948     0.200
     7.183   102.638     0.200
     7.263   104.628     0.200
     7.342   105.068     0.200
     7.337   105.438     0.200
     7.407   104.488     0.200
     7.424   105.738     0.200
     7.452   106.888     0.200
     7.710   109.818     0.200
     8.008   113.518     0.200
     7.996   113.658     0.200
     8.013   114.548     0.200
     8.081   114.667     0.200
     8.140   115.098     0.200
     8.157   117.878     0.200
     8.223   116.968     0.200
     8.256   116.808     0.200
     8.293   120.158     0.200
     8.293   119.478     0.200
     8.445   120.128     0.200
     8.640   122.958     0.200
     8.612   121.598     0.200
     8.687   123.828     0.200
     8.898   126.228     0.200
     8.955   126.028     0.200
     9.030   127.078     0.200
     9.226   130.528     0.200
     9.322   131.278     0.200
     9.387   132.038     0.200
     9.356   134.408     0.200
     9.408   134.848     0.200
     9.543   134.398     0.200
     9.553   135.108     0.200
     9.622   135.958     0.200
     9.729   135.558     0.200
     9.715   137.058     0.200
     9.679   137.138     0.200
     9.944   139.858     0.200
     9.828   140.558     0.200
     9.828   139.398     0.200
     9.959   140.578     0.200
    10.007   140.438     0.200
     9.970   140.988     0.200
    12.018   168.458     0.200
    12.175   167.000     0.200
    12.175   168.468     0.200
    12.622   176.558     0.200
     0.367     8.854     0.200
     0.522    11.555     0.200
     0.859    15.785     0.200
     0.889    16.555     0.200
     0.969    17.785     0.200
     1.047    19.195     0.200
     1.103    19.705     0.200
     1.113    20.465     0.200
     1.307    21.495     0.200
     1.241    22.075     0.200
     1.293    22.745     0.200
     1.295    22.735     0.200
     1.320    23.235     0.200
     1.551    25.525     0.200
     1.516    25.925     0.200
     1.784    29.065     0.200
     1.858    30.305     0.200
     2.643    41.115     0.200
     3.045    46.955     0.200
     3.106    47.155     0.200
     3.163    48.545     0.200
     3.705    55.455     0.200
     3.778    56.535     0.200
     3.730    57.005     0.200
     3.843    57.345     0.200
     3.844    57.135     0.200
     3.857    57.785     0.200
     3.824    58.825     0.200
     3.868    58.575     0.200
     3.956    58.345     0.200
     4.000    59.175     0.200
     4.079    58.185     0.200
     4.004    58.755     0.200
     4.156    61.425     0.200
     4.176    61.235     0.200
     4.276    63.285     0.200
     4.290    63.935     0.200
     4.234    64.425     0.200
     4.328    64.185     0.200
     4.374    64.215     0.200
     4.496    66.455     0.200
     4.491    67.405     0.200
     4.684    67.604     0.200
     4.684    67.315     0.200
     4.796    69.935     0.200
     4.967    71.315     0.200
     5.004    73.295     0.200
     5.510    81.075     0.200
     5.555    80.485     0.200
     5.610    81.945     0.200
     5.720    82.885     0.200
     5.855    84.765     0.200
     5.864    85.465     0.200
     6.000    87.085     0.200
     6.068    88.535     0.200
     6.265    91.555     0.200
     6.265    91.555     0.200
     6.338    91.854     0.200
     6.290    90.685     0.200
     6.382    91.865     0.200
     6.469    93.875     0.200
     6.545    93.535     0.200
     6.586    94.655     0.200
     6.629    94.945     0.200
     7.003   100.255     0.200
     7.217   103.445     0.200
     7.199   103.075     0.200
     7.347   104.965     0.200
     7.439   106.395     0.200
     7.519   108.645     0.200
     7.533   108.085     0.200
     7.584   108.485     0.200
     8.140   115.745     0.200
     8.249   116.575     0.200
     8.241   117.145     0.200
     8.435   119.925     0.200
     8.563   120.775     0.200
     8.669   122.905     0.200
     8.727   122.265     0.200
     8.747   121.995     0.200
     8.746   123.935     0.200
     8.924   124.285     0.200
     9.063   128.745     0.200
     9.104   130.235     0.200
     9.246   128.945     0.200
     9.428   134.225     0.200
     9.566   134.025     0.200
     9.785   137.825     0.200
    10.392   145.555     0.200
    10.756   152.265     0.200
    11.063   156.235     0.200
    11.203   158.385     0.200
    11.350   160.035     0.200
    11.370   160.535     0.200
    11.505   158.635     0.200
    11.505   159.945     0.200
    11.704   164.075     0.200
    11.742   164.715     0.200
    12.052   167.915     0.200
    12.323   172.875     0.200
    12.367   175.315     0.200
    13.100   182.815     0.200
    13.164   183.555     0.200
    13.647   191.895     0.200
    13.971   196.635     0.200
    14.093   194.885     0.200
    14.107   197.915     0.200
    14.183   197.385     0.200
    15.249   211.415     0.200
    16.232   224.055     0.200
    16.727   230.115     0.200
    16.825   230.055     0.200
    17.829   242.760     0.200
    17.829   242.275     0.200
     1.066    21.852     0.200
     1.081    22.328     0.200
     1.206    24.609     0.200
     1.827    32.859     0.200
     1.839    33.164     0.200
     1.837    34.719     0.200
     2.360    40.742     0.200
     2.813    46.828     0.200
     2.879    49.250     0.200
     2.879    49.133     0.200
     2.977    50.195     0.200
     2.983    50.562     0.200
     2.999    50.719     0.200
     3.028    51.695     0.200
     3.053    51.445     0.200
     3.337    52.953     0.200
     3.337    52.805     0.200
     3.353    54.891     0.200
     3.451    56.500     0.200
     3.502    57.328     0.200
     3.579    58.414     0.200
     4.005    63.133     0.200
     4.155    65.070     0.200
     4.377    67.250     0.200
     4.384    69.562     0.200
     4.700    72.492     0.200
     4.756    73.141     0.200
     4.795    73.680     0.200
     4.810    74.773     0.200
     4.904    75.469     0.200
     4.895    75.641     0.200
     5.062    77.484     0.200
     5.125    76.828     0.200
     5.220    79.125     0.200
     5.338    81.078     0.200
     5.346    81.398     0.200
     5.379    82.664     0.200
     5.412    81.359     0.200
     5.542    84.242     0.200
     5.742    84.367     0.200
     5.742    85.023     0.200
     5.786    88.125     0.200
     5.873    88.773     0.200
     6.032    90.391     0.200
     6.183    93.133     0.200
     6.161    93.758     0.200
     6.267    94.641     0.200
     6.299    94.711     0.200
     6.381    95.664     0.200
     6.707    99.891     0.200
     6.706   100.352     0.200
     6.987   103.695     0.200
     7.013   104.078     0.200
     7.242   107.555     0.200
     7.276   108.359     0.200
     7.348   108.914     0.200
     7.355   109.211     0.200
     7.587   112.711     0.200
     7.685   111.445     0.200
     7.676   113.141     0.200
     7.798   115.641     0.200
     7.861   115.492     0.200
     7.910   116.875     0.200
     8.132   119.633     0.200
     8.216   122.375     0.200
     8.253   122.258     0.200
     8.380   122.484     0.200
     8.416   122.570     0.200
     8.408   124.539     0.200
     8.275   122.773     0.200
     8.435   124.109     0.200
     8.474   124.383     0.200
     8.531   126.570     0.200
     8.881   128.758     0.200
     9.317   134.461     0.200
     9.477   139.078     0.200
     9.794   140.953     0.200
     9.816   140.641     0.200
     9.992   142.664     0.200
     9.824   145.055     0.200
    10.311   147.945     0.200
    10.495   151.234     0.200
    10.580   151.812     0.200
    10.635   152.508     0.200
    10.890   155.828     0.200
    11.460   163.578     0.200
    12.536   174.305     0.200
     1.533    26.150     0.200
     1.697    28.689     0.200
     1.782    31.010     0.200
     2.064    33.869     0.200
     2.280    36.939     0.200
     2.509    40.109     0.200
     3.012    48.789     0.200
     3.012    48.311     0.200
     3.120    47.789     0.200
     3.125    50.109     0.200
     3.124    50.459     0.200
     3.157    50.709     0.200
     3.184    51.039     0.200
     3.361    51.820     0.200
     3.503    54.689     0.200
     3.503    55.170     0.200
     3.644    56.990     0.200
     3.729    57.990     0.200
     4.140    61.891     0.200
     4.140    62.180     0.200
     4.405    66.209     0.200
     4.456    67.000     0.200
     4.508    67.160     0.200
     4.541    68.029     0.200
     4.609    69.330     0.200
     4.519    69.590     0.200
     4.602    70.199     0.200
     4.873    70.789     0.200
     4.873    71.051     0.200
     4.927    73.020     0.200
     5.044    74.680     0.200
     5.048    75.221     0.200
     5.070    76.230     0.200
     5.103    75.150     0.200
     5.258    77.439     0.200
     5.487    81.359     0.200
     5.480    79.084     0.200
     5.740    84.240     0.200
     5.683    85.430     0.200
     5.877    86.439     0.200
     5.896    86.551     0.200
     5.902    87.689     0.200
     5.902    87.340     0.200
     6.005    87.230     0.200
     6.135    89.061     0.200
     6.413    93.320     0.200
     6.521    94.891     0.200
     6.754    98.990     0.200
     6.933   100.539     0.200
     6.967   101.539     0.200
     7.004   100.539     0.200
     7.054   101.850     0.200
     7.556   108.439     0.200
     7.822   112.660     0.200
     8.097   116.189     0.200
     8.130   116.311     0.200
     8.132   116.539     0.200
     8.200   117.471     0.200
     8.222   120.061     0.200
     8.347   122.221     0.200
     8.431   122.590     0.200
     8.431   122.209     0.200
     8.566   123.141     0.200
     8.757   124.359     0.200
     9.020   128.430     0.200
     9.030   128.439     0.200
     9.214   132.990     0.200
     9.320   132.900     0.200
     9.519   134.301     0.200
     9.499   136.820     0.200
     9.641   136.420     0.200
     9.667   137.369     0.200
     9.713   136.520     0.200
     9.624   139.150     0.200
     9.919   139.490     0.200
     9.919   139.270     0.200
    10.019   141.480     0.200
     9.972   142.990     0.200
    12.230   169.525     0.200
    14.410   200.391     0.200
    14.930   210.289     0.200
    15.210   213.449     0.200
    15.360   215.529     0.200
    15.381   216.520     0.200
    15.592   218.949     0.200
    15.684   220.449     0.200
    15.775   220.391     0.200
    15.775   220.551     0.200
    15.854   221.090     0.200
    16.016   223.061     0.200
    16.057   224.650     0.200
    16.068   225.270     0.200
    16.089   225.250     0.200
    16.257   226.551     0.200
    16.647   232.709     0.200
    16.761   233.891     0.200
    16.951   236.500     0.200
    17.107   238.090     0.200
    17.140   238.119     0.200
    17.228   239.064     0.200
    17.331   240.051     0.200
    18.574   255.039     0.200
     1.049    19.312     0.200
     1.135    21.004     0.200
     1.116    20.094     0.200
     1.116    19.822     0.200
     1.187    21.803     0.200
     1.226    20.854     0.200
     1.248    22.764     0.200
     1.324    23.902     0.200
     1.513    25.674     0.200
     1.782    29.982     0.200
     1.845    28.992     0.200
     1.839    31.303     0.200
     1.859    31.582     0.200
     1.884    31.572     0.200
     1.893    31.764     0.200
     1.917    32.133     0.200
     1.985    33.684     0.200
     2.078    33.893     0.200
     2.107    34.684     0.200
     2.124    34.953     0.200
     2.892    44.594     0.200
     2.892    43.732     0.200
     3.413    51.953     0.200
     3.520    53.473     0.200
     3.560    53.873     0.200
     3.597    54.373     0.200
     3.615    54.062     0.200
     3.658    54.094     0.200
     3.658    53.812     0.200
     4.078    61.123     0.200
     4.078    60.893     0.200
     4.160    62.523     0.200
     4.292    62.812     0.200
     4.292    62.344     0.200
     4.285    63.992     0.200
     4.428    65.844     0.200
     4.532    66.783     0.200
     4.772    70.783     0.200
     4.782    72.193     0.200
     4.782    69.893     0.200
     4.919    73.174     0.200
     5.134    75.662     0.200
     5.164    75.973     0.200
     5.408    79.822     0.200
     5.511    80.143     0.200
     5.739    84.264     0.200
     5.794    85.453     0.200
     5.922    86.973     0.200
     5.961    87.322     0.200
     5.962    86.943     0.200
     6.147    89.033     0.200
     6.366    92.604     0.200
     6.589    95.072     0.200
     6.664    96.043     0.200
     6.697    98.254     0.200
     6.788    97.594     0.200
     7.075   102.094     0.200
     7.226   103.832     0.200
     7.391   106.443     0.200
     7.393   106.363     0.200
     7.659   110.312     0.200
     8.105   116.533     0.200
     8.199   118.293     0.200
     8.292   118.873     0.200
     8.369   118.684     0.200
     8.344   118.713     0.200
     8.896   126.924     0.200
     9.064   129.822     0.200
    11.314   160.193     0.200
    11.327   157.742     0.200
    13.127   182.693     0.200
    15.385   214.184     0.200
    15.500   215.982     0.200
    15.694   218.004     0.200
    15.920   222.822     0.200
    15.981   221.703     0.200
    16.419   226.613     0.200
    16.502   228.312     0.200
    16.571   229.043     0.200
    17.034   233.604     0.200
    17.607   241.393     0.200
     1.521    26.137     0.200
     1.552    27.188     0.200
     1.557    27.156     0.200
     1.581    27.406     0.200
     1.666    27.477     0.200
     1.846    31.117     0.200
     1.936    31.859     0.200
     2.230    36.379     0.200
     2.265    37.078     0.200
     2.335    38.277     0.200
     2.393    37.316     0.200
     2.393    37.020     0.200
     2.703    43.859     0.200
     2.703    44.457     0.200
     2.706    43.859     0.200
     2.778    44.949     0.200
     3.016    46.699     0.200
     3.451    52.020     0.200
     3.451    51.359     0.200
     3.440    52.668     0.200
     3.555    54.168     0.200
     3.807    59.117     0.200
     3.807    57.680     0.200
     3.939    59.289     0.200
     3.906    60.449     0.200
     3.907    60.199     0.200
     3.918    60.707     0.200
     4.019    60.168     0.200
     3.953    59.988     0.200
     4.030    60.637     0.200
     4.083    61.328     0.200
     4.130    61.566     0.200
     4.142    61.738     0.200
     4.205    63.090     0.200
     4.220    61.719     0.200
     4.220    62.059     0.200
     4.293    64.039     0.200
     4.292    65.117     0.200
     4.292    64.629     0.200
     4.382    65.688     0.200
     4.444    65.566     0.200
     4.387    66.367     0.200
     4.473    66.438     0.200
     4.441    67.457     0.200
     4.518    68.359     0.200
     4.600    68.398     0.200
     4.613    68.348     0.200
     4.553    68.859     0.200
     4.663    69.609     0.200
     4.854    70.012     0.200
     4.854    70.430     0.200
     4.930    72.238     0.200
     5.189    76.227     0.200
     5.207    76.746     0.200
     5.246    76.867     0.200
     5.303    79.430     0.200
     5.368    79.047     0.200
     5.360    80.438     0.200
     5.609    82.078     0.200
     5.636    82.797     0.200
     5.775    85.027     0.200
     5.950    87.238     0.200
     5.933    86.527     0.200
     6.116    89.816     0.200
     6.100    89.340     0.200
     6.206    90.180     0.200
     6.246    90.047     0.200
     6.251    90.906     0.200
     6.310    91.719     0.200
     6.320    92.180     0.200
     6.474    92.227     0.200
     6.478    94.469     0.200
     6.525    92.898     0.200
     6.461    94.199     0.200
     6.545    92.508     0.200
     6.633    96.066     0.200
     6.604    97.418     0.200
     6.604    96.680     0.200
     6.747    97.816     0.200
     6.786    98.578     0.200
     6.772    98.066     0.200
     6.819    96.809     0.200
     6.858    97.668     0.200
     6.870    99.629     0.200
     6.941   101.020     0.200
     7.008   100.758     0.200
     7.523   108.297     0.200
     7.583   108.727     0.200
     7.582   108.168     0.200
     7.645   109.809     0.200
     7.654   110.930     0.200
     7.679   111.496     0.200
     7.751   112.367     0.200
     7.838   113.109     0.200
     7.865   113.008     0.200
     7.883   114.547     0.200
     8.035   115.238     0.200
     8.141   116.297     0.200
     8.169   115.938     0.200
     8.279   117.656     0.200
     8.332   118.816     0.200
     8.348   119.309     0.200
     8.342   120.047     0.200
     8.499   121.008     0.200
     8.497   119.699     0.200
     8.612   123.219     0.200
     8.701   123.289     0.200
     8.833   126.289     0.200
     8.871   126.738     0.200
     8.929   126.129     0.200
     8.938   126.340     0.200
     8.977   126.508     0.200
     8.990   128.438     0.200
     9.071   130.227     0.200
     9.141   127.738     0.200
     9.157   129.680     0.200
     9.218   131.559     0.200
     9.219   132.418     0.200
     9.325   132.020     0.200
     9.325   131.719     0.200
     9.479   135.219     0.200
     9.489   134.090     0.200
     9.515   134.438     0.200
     9.595   136.566     0.200
     9.643   135.457     0.200
     9.771   137.809     0.200
     9.772   137.648     0.200
     9.804   138.270     0.200
     9.843   139.879     0.200
     9.839   140.816     0.200
     9.855   138.777     0.200
     9.901   140.090     0.200
     9.912   139.129     0.200
    10.025   141.207     0.200
    10.310   145.270     0.200
    10.328   147.039     0.200
    10.475   147.680     0.200
    10.764   153.617     0.200
    10.764   152.688     0.200
    10.810   153.246     0.200
    11.043   157.867     0.200
    11.043   157.289     0.200
    11.190   158.469     0.200
    11.215   157.688     0.200
    11.322   159.316     0.200
    11.668   165.027     0.200
    11.796   165.566     0.200
    11.859   165.906     0.200
    11.842   163.617     0.200
    11.871   167.719     0.200
    12.102   168.930     0.200
    12.278   171.457     0.200
    12.296   172.277     0.200
    13.195   184.379     0.200
    13.300   186.090     0.200
    13.269   186.449     0.200
    13.484   190.938     0.200
    13.652   190.207     0.200
    13.974   196.598     0.200
    14.920   207.258     0.200
    17.035   235.078     0.200
    17.113   235.098     0.200
    18.139   247.816     0.200
     1.356    25.349     0.200
     1.656    30.759     0.200
     1.793    31.419     0.200
     1.793    31.599     0.200
     1.846    32.929     0.200
     1.766    32.179     0.200
     1.940    34.408     0.200
     1.959    34.459     0.200
     1.968    34.988     0.200
     1.969    35.528     0.200
     1.969    34.929     0.200
     2.015    35.509     0.200
     2.327    39.629     0.200
     2.542    42.679     0.200
     2.853    47.089     0.200
     2.864    47.158     0.200
     2.827    49.009     0.200
     2.926    48.719     0.200
     2.945    48.379     0.200
     3.352    52.679     0.200
     3.307    54.479     0.200
     3.307    53.769     0.200
     3.403    54.568     0.200
     3.403    55.059     0.200
     3.454    55.608     0.200
     3.454    55.889     0.200
     3.533    56.688     0.200
     3.533    57.269     0.200
     3.569    57.049     0.200
     3.967    62.219     0.200
     4.071    63.509     0.200
     4.071    63.919     0.200
     4.118    64.219     0.200
     4.118    64.358     0.200
     4.189    65.179     0.200
     4.189    65.309     0.200
     4.383    66.778     0.200
     4.383    66.648     0.200
     4.668    71.528     0.200
     4.719    72.139     0.200
     4.733    72.339     0.200
     4.766    72.778     0.200
     4.769    72.509     0.200
     4.769    73.099     0.200
     4.804    73.288     0.200
     4.833    74.179     0.200
     4.872    74.358     0.200
     4.877    74.219     0.200
     4.932    75.269     0.200
     5.123    75.879     0.200
     5.123    76.299     0.200
     5.190    78.398     0.200
     5.307    80.179     0.200
     5.328    80.688     0.200
     5.346    81.379     0.200
     5.453    81.639     0.200
     5.473    82.889     0.200
     5.696    85.488     0.200
     5.706    85.818     0.200
     5.735    83.822     0.200
     5.735    84.979     0.200
     5.828    87.669     0.200
     5.867    88.498     0.200
     6.003    89.389     0.200
     6.066    91.408     0.200
     6.110    91.139     0.200
     6.110    91.828     0.200
     6.219    93.608     0.200
     6.215    92.139     0.200
     6.215    92.509     0.200
     6.292    93.288     0.200
     6.381    95.459     0.200
     6.631    98.059     0.200
     6.921   101.759     0.200
     7.173   106.108     0.200
     7.205   105.068     0.200
     7.225   107.248     0.200
     7.277   107.169     0.200
     7.325   107.448     0.200
     7.478   110.229     0.200
     7.526   110.419     0.200
     7.702   113.179     0.200
     7.787   113.339     0.200
     7.823   114.459     0.200
     8.064   117.089     0.200
     8.197   120.549     0.200
     8.348   121.429     0.200
     8.352   121.459     0.200
     8.394   121.938     0.200
     8.232   121.639     0.200
     8.382   121.719     0.200
     8.480   123.438     0.200
     8.815   127.528     0.200
     8.843   127.698     0.200
     8.979   129.729     0.200
     9.257   133.349     0.200
     9.292   133.868     0.200
     9.305   136.818     0.200
     9.778   140.259     0.200
     9.628   139.349     0.200
     9.908   142.188     0.200
     9.779   143.979     0.200
     9.974   141.959     0.200
    12.490   173.729     0.200
    14.152   200.219     0.200
    14.165   200.419     0.200
    15.114   211.358     0.200
    16.092   227.299     0.200
    16.618   233.839     0.200
    17.234   239.889     0.200
    17.266   241.318     0.200
    17.848   246.278     0.200
     1.305    23.025     0.200
     1.330    23.436     0.200
     1.253    22.455     0.200
     1.301    23.545     0.200
     1.302    23.404     0.200
     1.323    23.805     0.200
     1.436    25.135     0.200
     1.336    24.125     0.200
     1.491    26.154     0.200
     1.434    25.984     0.200
     1.543    27.295     0.200
     1.468    26.035     0.200
     1.474    25.654     0.200
     1.607    28.195     0.200
     1.741    28.635     0.200
     1.994    32.484     0.200
     2.227    35.996     0.200
     2.298    37.285     0.200
     2.298    37.635     0.200
     2.430    40.855     0.200
     2.434    40.416     0.200
     2.621    41.186     0.200
     3.084    47.205     0.200
     3.468    53.426     0.200
     3.538    54.006     0.200
     3.637    55.436     0.200
     3.663    54.746     0.200
     3.540    55.266     0.200
     3.685    57.266     0.200
     4.058    61.145     0.200
     4.134    61.855     0.200
     4.146    61.975     0.200
     4.029    61.836     0.200
     4.029    60.904     0.200
     4.200    62.936     0.200
     4.257    63.756     0.200
     4.263    63.904     0.200
     4.324    64.875     0.200
     4.324    65.016     0.200
     4.172    63.426     0.200
     4.172    63.586     0.200
     4.254    64.965     0.200
     4.417    64.496     0.200
     4.417    66.154     0.200
     4.403    65.885     0.200
     4.436    66.346     0.200
     4.572    67.324     0.200
     4.583    68.625     0.200
     4.714    69.295     0.200
     4.819    71.035     0.200
     4.942    72.266     0.200
     5.040    71.680     0.200
     5.040    72.686     0.200
     5.040    72.574     0.200
     5.244    77.166     0.200
     5.284    78.285     0.200
     5.379    78.824     0.200
     5.433    80.574     0.200
     5.688    83.564     0.200
     5.764    84.965     0.200
     5.958    86.904     0.200
     5.978    87.445     0.200
     5.988    88.215     0.200
     6.125    89.025     0.200
     6.302    91.686     0.200
     6.304    92.305     0.200
     6.677    95.535     0.200
     6.611    96.785     0.200
     6.707    97.385     0.200
     6.784    98.525     0.200
     6.782    98.416     0.200
     6.970    98.555     0.200
     6.981   101.105     0.200
     7.077   101.955     0.200
     7.446   107.055     0.200
     7.664   110.025     0.200
     7.638   110.676     0.200
     7.723   111.186     0.200
     7.713   111.404     0.200
     7.740   109.805     0.200
     7.886   113.436     0.200
     7.961   115.734     0.200
     7.966   114.324     0.200
     8.026   115.445     0.200
     8.256   118.545     0.200
     8.253   118.686     0.200
     8.303   117.945     0.200
     8.338   119.865     0.200
     8.445   121.006     0.200
     8.568   122.426     0.200
     8.679   123.715     0.200
     8.881   127.285     0.200
     9.065   130.166     0.200
     9.103   129.324     0.200
     8.956   130.436     0.200
     9.308   130.605     0.200
    10.499   151.234     0.200
    10.499   150.205     0.200
    10.720   151.145     0.200
    11.940   165.186     0.200
    12.033   170.105     0.200
    12.162   170.926     0.200
    12.190   171.545     0.200
    12.432   174.404     0.200
    12.451   175.105     0.200
    12.560   177.305     0.200
    12.656   178.676     0.200
    13.897   196.314     0.200
    13.908   195.596     0.200
    14.512   203.855     0.200
    15.304   214.516     0.200
    15.496   215.824     0.200
    15.613   218.725     0.200
    15.964   222.365     0.200
    16.036   222.715     0.200
    16.640   231.375     0.200
    16.641   231.375     0.200
    16.672   230.535     0.200
    17.040   235.996     0.200
    17.153   236.006     0.200
    17.244   237.246     0.200
    18.256   250.836     0.200
    18.256   251.176     0.200
     1.172    21.244     0.200
     1.390    24.684     0.200
     1.400    24.463     0.200
     1.656    27.703     0.200
     2.614    40.574     0.200
     2.992    46.473     0.200
     3.511    54.643     0.200
     3.511    53.074     0.200
     3.641    54.443     0.200
     3.641    54.264     0.200
     3.654    55.232     0.200
     4.005    61.643     0.200
     4.005    60.043     0.200
     4.189    62.854     0.200
     4.313    64.773     0.200
     4.384    64.143     0.200
     4.384    64.523     0.200
     4.454    66.893     0.200
     4.722    70.604     0.200
     4.831    72.113     0.200
     5.000    72.463     0.200
     5.000    73.104     0.200
     5.155    76.543     0.200
     5.310    78.953     0.200
     5.310    78.744     0.200
     8.796   125.844     0.200
     8.932   128.844     0.200
     9.453   133.744     0.200
    10.471   149.643     0.200
    10.471   149.883     0.200
    11.593   164.344     0.200
    11.682   163.143     0.200
    11.682   163.744     0.200
    11.682   162.732     0.200
    11.854   164.293     0.200
    12.061   170.943     0.200
    14.050   198.744     0.200
    15.271   215.244     0.200
    15.421   214.404     0.200
    15.414   214.764     0.200
    15.452   215.094     0.200
    15.489   214.387     0.200
    15.489   215.904     0.200
    15.489   215.643     0.200
    15.547   216.494     0.200
    15.566   216.773     0.200
    15.583   216.354     0.200
    15.731   218.623     0.200
    15.840   220.354     0.200
    15.958   221.732     0.200
    16.143   225.143     0.200
    16.260   225.973     0.200
    16.525   229.924     0.200
    16.574   229.104     0.200
    16.668   230.783     0.200
    16.679   231.273     0.200
    16.724   231.719     0.200
    17.171   236.643     0.200
    18.177   249.168     0.200
    18.177   248.543     0.200
    20.442   275.604     0.200
     1.470    24.992     0.200
     1.532    27.219     0.200
     1.657    28.320     0.200
     1.711    29.234     0.200
     1.721    29.031     0.200
     1.890    30.039     0.200
     1.890    30.273     0.200
     2.381    37.375     0.200
     2.330    38.633     0.200
     2.548    39.984     0.200
     2.454    40.469     0.200
     2.691    40.469     0.200
     2.691    40.672     0.200
     2.792    45.344     0.200
     2.890    46.609     0.200
     3.237    48.500     0.200
     3.607    54.852     0.200
     3.531    55.273     0.200
     3.531    54.539     0.200
     3.531    54.773     0.200
     3.747    54.773     0.200
     3.679    56.578     0.200
     4.011    60.875     0.200
     4.011    60.570     0.200
     4.195    62.109     0.200
     4.108    62.641     0.200
     4.277    63.211     0.200
     4.158    63.305     0.200
     4.237    64.312     0.200
     4.391    64.594     0.200
     4.273    65.055     0.200
     4.399    64.453     0.200
     4.513    64.875     0.200
     4.513    65.312     0.200
     4.605    67.773     0.200
     4.705    68.789     0.200
     4.751    70.094     0.200
     4.827    70.516     0.200
     4.974    72.633     0.200
     4.936    73.984     0.200
     5.107    75.375     0.200
     5.144    73.594     0.200
     5.144    73.812     0.200
     5.144    74.328     0.200
     5.018    75.414     0.200
     5.076    76.148     0.200
     5.405    78.859     0.200
     5.425    78.953     0.200
     5.452    79.680     0.200
     5.511    79.820     0.200
     5.602    82.164     0.200
     6.121    88.539     0.200
     6.147    88.930     0.200
     6.152    89.820     0.200
     6.353    91.750     0.200
     6.257    92.414     0.200
     6.460    93.445     0.200
     6.472    94.000     0.200
     6.499    93.461     0.200
     6.433    94.328     0.200
     6.433    94.570     0.200
     6.800    96.789     0.200
     6.961    99.969     0.200
     6.949    99.805     0.200
     7.093    99.969     0.200
     7.134   100.711     0.200
     7.171   102.516     0.200
     7.613   109.055     0.200
     7.731   110.266     0.200
     7.762   111.125     0.200
     7.766   111.445     0.200
     7.802   111.984     0.200
     7.870   112.625     0.200
     8.113   116.539     0.200
     8.396   118.359     0.200
     8.495   121.266     0.200
     8.772   123.383     0.200
     8.737   124.742     0.200
     8.791   123.703     0.200
     8.847   125.539     0.200
     8.801   126.898     0.200
     9.001   125.773     0.200
     9.001   126.273     0.200
     8.895   128.531     0.200
     8.936   128.469     0.200
     8.936   128.344     0.200
     9.102   128.500     0.200
     9.200   129.203     0.200
     9.215   129.734     0.200
     9.217   131.531     0.200
     9.257   129.359     0.200
     9.343   132.984     0.200
     9.423   131.414     0.200
     9.422   132.352     0.200
     9.611   134.172     0.200
     9.611   134.820     0.200
     9.618   134.805     0.200
     9.784   137.172     0.200
     9.888   139.461     0.200
     9.925   138.695     0.200
     9.925   138.172     0.200
    10.024   140.133     0.200
    10.082   141.242     0.200
    10.074   141.789     0.200
    10.047   143.375     0.200
    10.311   143.773     0.200
    10.483   149.469     0.200
    10.483   148.875     0.200
    10.483   148.992     0.200
    10.483   149.609     0.200
    10.920   153.914     0.200
    11.037   156.445     0.200
    11.592   162.219     0.200
    11.736   163.859     0.200
    11.722   166.000     0.200
    11.784   164.672     0.200
    11.814   165.828     0.200
    11.918   171.781     0.200
    11.919   164.672     0.200
    11.919   164.289     0.200
    11.919   165.172     0.200
    12.086   166.070     0.200
    12.086   167.672     0.200
    12.168   170.469     0.200
    12.573   175.602     0.200
    12.993   182.672     0.200
    13.598   191.930     0.200
    13.947   193.875     0.200
    14.023   195.422     0.200
    14.494   202.570     0.200
    15.284   213.375     0.200
    15.615   217.219     0.200
    15.563   215.539     0.200
    15.563   218.070     0.200
    16.121   222.969     0.200
    16.431   227.031     0.200
    16.795   232.172     0.200
    18.961   259.875     0.200
    18.961   261.539     0.200
     0.987    18.039     0.200
     1.592    26.680     0.200
     1.623    28.211     0.200
     1.781    30.344     0.200
     1.781    30.711     0.200
     1.823    30.375     0.200
     1.998    32.336     0.200
     2.493    39.000     0.200
     2.371    38.641     0.200
     2.493    40.070     0.200
     2.563    41.234     0.200
     2.736    41.664     0.200
     2.736    40.445     0.200
     2.722    43.477     0.200
     2.820    44.734     0.200
     3.347    50.719     0.200
     3.641    54.656     0.200
     3.641    54.906     0.200
     3.544    54.766     0.200
     3.544    53.867     0.200
     3.705    55.914     0.200
     3.785    56.820     0.200
     3.802    55.969     0.200
     3.802    55.859     0.200
     3.647    55.320     0.200
     3.647    55.508     0.200
     3.693    56.867     0.200
     3.893    58.539     0.200
     4.017    60.766     0.200
     4.017    60.234     0.200
     4.167    62.789     0.200
     4.378    65.195     0.200
     4.435    65.969     0.200
     4.280    63.961     0.200
     4.495    66.273     0.200
     4.557    67.758     0.200
     4.576    66.164     0.200
     4.576    65.758     0.200
     4.731    70.391     0.200
     4.921    72.328     0.200
     4.879    73.188     0.200
     4.951    73.078     0.200
     4.968    73.234     0.200
     5.212    74.336     0.200
     5.198    76.391     0.200
     5.522    80.805     0.200
     5.602    81.586     0.200
     5.580    82.945     0.200
     6.056    88.773     0.200
     6.166    89.539     0.200
     6.279    92.094     0.200
     6.253    89.719     0.200
     6.458    93.469     0.200
     6.574    96.000     0.200
     6.597    95.461     0.200
     6.512    95.766     0.200
     6.662    96.148     0.200
     6.884    98.336     0.200
     7.070   102.586     0.200
     7.077   102.695     0.200
     7.217   102.414     0.200
     7.353   106.938     0.200
     7.942   112.688     0.200
     7.940   113.141     0.200
     7.929   114.359     0.200
     8.317   119.609     0.200
     8.526   121.258     0.200
     8.691   123.250     0.200
     8.856   125.594     0.200
     9.094   129.367     0.200
     8.936   128.070     0.200
     9.191   130.617     0.200
     9.289   130.961     0.200
     9.500   132.836     0.200
     9.513   135.008     0.200
     9.685   136.867     0.200
     9.685   136.391     0.200
     9.707   137.219     0.200
     9.872   139.766     0.200
    10.055   141.711     0.200
    10.244   143.750     0.200
    10.527   149.469     0.200
    10.488   150.664     0.200
    10.769   153.125     0.200
    10.997   155.734     0.200
    11.256   160.430     0.200
    11.496   162.141     0.200
    11.769   166.273     0.200
    11.870   166.758     0.200
    12.025   170.266     0.200
    12.188   168.414     0.200
    12.214   172.078     0.200
    12.228   171.805     0.200
    12.656   177.000     0.200
    13.134   183.141     0.200
    13.002   182.289     0.200
    13.659   190.859     0.200
    14.100   198.336     0.200
    14.309   200.539     0.200
    14.385   201.109     0.200
    14.659   206.375     0.200
    14.748   205.828     0.200
    15.022   210.359     0.200
    15.229   212.711     0.200
    15.593   215.359     0.200
    16.271   227.914     0.200
    16.391   227.734     0.200
    16.830   232.094     0.200
    16.838   233.523     0.200
    18.492   253.664     0.200
     1.851    30.961     0.200
     2.077    34.312     0.200
     2.801    41.977     0.200
     4.646    69.492     0.200
     5.284    77.156     0.200
     5.284    78.359     0.200
     8.016   117.672     0.200
     8.017   114.695     0.200
     8.932   127.500     0.200
     9.362   133.422     0.200
     9.574   134.836     0.200
     9.758   138.141     0.200
    10.022   143.109     0.200
    10.077   143.133     0.200
    10.553   149.500     0.200
    10.970   156.828     0.200
    11.104   157.477     0.200
    11.566   163.211     0.200
    11.847   168.422     0.200
    12.267   169.805     0.200
    12.284   173.227     0.200
    12.713   180.266     0.200
    12.869   183.359     0.200
    13.088   185.320     0.200
    13.584   191.180     0.200
    13.732   194.648     0.200
    13.938   196.141     0.200
    14.370   201.500     0.200
    15.086   212.836     0.200
    15.748   220.992     0.200
    16.453   232.648     0.200
    16.890   237.891     0.200
    16.949   237.445     0.200
     1.628    26.641     0.200
     1.646    28.844     0.200
     1.848    30.414     0.200
     2.033    31.875     0.200
     2.377    38.375     0.200
     2.499    40.141     0.200
     2.756    41.586     0.200
     2.756    40.992     0.200
     2.569    40.844     0.200
     2.728    43.156     0.200
     2.822    44.656     0.200
     2.922    46.227     0.200
     3.542    53.844     0.200
     3.824    56.586     0.200
     3.824    55.656     0.200
     3.691    55.586     0.200
     4.013    59.258     0.200
     4.410    65.258     0.200
     4.526    65.922     0.200
     4.600    65.836     0.200
     4.722    69.406     0.200
     5.119    74.578     0.200
     5.237    74.375     0.200
     5.237    74.883     0.200
     5.632    81.766     0.200
     5.980    87.727     0.200
     6.245    89.812     0.200
     6.629    95.656     0.200
     6.609    95.906     0.200
     6.633    96.484     0.200
     6.913    99.344     0.200
     7.003   101.664     0.200
     7.092   101.453     0.200
     7.106   102.297     0.200
     7.207   101.664     0.200
     7.922   113.531     0.200
     7.970   113.352     0.200
     7.970   113.594     0.200
     7.984   115.352     0.200
     8.195   117.445     0.200
     8.245   117.867     0.200
     8.354   119.727     0.200
     8.525   120.828     0.200
     8.556   121.164     0.200
     8.717   122.805     0.200
     8.878   125.484     0.200
     8.885   125.367     0.200
     8.930   127.516     0.200
     9.221   130.711     0.200
     9.204   131.531     0.200
     9.324   131.703     0.200
     9.527   134.055     0.200
     9.711   137.586     0.200
     9.711   136.055     0.200
     9.902   139.906     0.200
    10.192   143.094     0.200
    10.328   145.883     0.200
    10.507   147.125     0.200
    10.778   152.812     0.200
    10.909   153.625     0.200
    11.023   154.945     0.200
    11.204   157.383     0.200
    11.370   159.742     0.200
    11.520   161.633     0.200
    11.676   164.547     0.200
    11.801   166.352     0.200
    11.893   167.438     0.200
    11.962   168.328     0.200
    12.049   168.422     0.200
    12.240   171.984     0.200
    12.238   172.945     0.200
    12.221   168.977     0.200
    12.255   172.562     0.200
    12.488   174.875     0.200
    12.666   178.461     0.200
    12.823   180.875     0.200
    13.043   182.523     0.200
    12.998   181.375     0.200
    13.541   187.664     0.200
    13.685   191.914     0.200
    13.892   194.508     0.200
    14.127   197.742     0.200
    14.135   197.203     0.200
    14.326   200.406     0.200
    14.474   201.688     0.200
    14.680   206.227     0.200
    15.041   210.047     0.200
    15.588   217.312     0.200
    16.862   234.242     0.200
    16.933   234.781     0.200
    18.523   253.812     0.200
     2.128    33.406     0.200
     2.367    38.742     0.200
     2.488    40.250     0.200
     2.555    41.406     0.200
     2.716    43.273     0.200
     2.801    43.883     0.200
     2.831    42.109     0.200
     3.508    54.023     0.200
     3.613    55.461     0.200
     3.659    56.211     0.200
     3.903    57.391     0.200
     3.974    59.906     0.200
     4.200    62.977     0.200
     4.682    67.742     0.200
     5.322    76.781     0.200
     6.199    91.117     0.200
     6.723    96.922     0.200
     8.887   127.617     0.200
     8.975   126.422     0.200
     9.312   131.219     0.200
     9.401   132.344     0.200
     9.417   133.547     0.200
     9.615   134.227     0.200
     9.636   135.812     0.200
     9.796   137.898     0.200
     9.993   140.680     0.200
    10.057   142.711     0.200
    10.118   141.328     0.200
    10.164   142.852     0.200
    10.281   145.180     0.200
    10.409   146.727     0.200
    10.497   147.359     0.200
    10.590   149.359     0.200
    10.991   154.406     0.200
    11.109   155.883     0.200
    11.140   156.383     0.200
    11.602   162.773     0.200
    11.757   165.930     0.200
    11.894   167.031     0.200
    11.934   167.844     0.200
    11.975   169.508     0.200
    12.040   170.227     0.200
    12.142   170.828     0.200
    12.316   170.000     0.200
    12.319   173.469     0.200
    12.581   175.453     0.200
    12.612   175.711     0.200
    12.756   179.117     0.200
    12.774   179.477     0.200
    12.901   182.461     0.200
    12.960   181.703     0.200
    13.118   184.602     0.200
    13.607   189.148     0.200
    13.771   192.633     0.200
    14.395   201.062     0.200
    14.463   201.156     0.200
    14.541   203.117     0.200
    14.574   203.922     0.200
    14.758   206.609     0.200
    15.572   215.070     0.200
    15.572   216.258     0.200
    15.663   218.656     0.200
    15.731   218.992     0.200
    15.773   220.961     0.200
    16.914   233.352     0.200
    17.513   242.203     0.200
     1.104    19.695     0.200
     1.104    19.289     0.200
     1.715    28.898     0.200
     1.715    29.414     0.200
     1.920    31.680     0.200
     1.917    30.773     0.200
     2.112    32.766     0.200
     2.405    38.664     0.200
     2.593    40.867     0.200
     2.754    43.078     0.200
     2.798    42.398     0.200
     2.798    41.109     0.200
     2.840    44.125     0.200
     2.840    44.258     0.200
     3.462    53.273     0.200
     3.547    53.898     0.200
     3.547    53.344     0.200
     3.698    55.203     0.200
     3.722    56.367     0.200
     3.871    57.094     0.200
     4.006    59.906     0.200
     4.014    59.398     0.200
     4.485    66.695     0.200
     4.539    67.414     0.200
     4.598    67.367     0.200
     4.651    67.594     0.200
     4.651    66.664     0.200
     4.661    68.859     0.200
     4.749    70.219     0.200
     4.807    71.359     0.200
     5.007    73.758     0.200
     5.022    73.648     0.200
     5.038    74.125     0.200
     5.056    74.125     0.200
     5.068    74.391     0.200
     5.068    74.773     0.200
     5.292    75.617     0.200
     5.292    76.297     0.200
     5.292    75.914     0.200
     5.292    76.141     0.200
     5.641    82.305     0.200
     5.701    82.227     0.200
     6.059    88.297     0.200
     6.092    88.180     0.200
     6.238    90.000     0.200
     6.568    95.086     0.200
     6.701    96.266     0.200
     6.702    96.898     0.200
     6.721    97.891     0.200
     6.766    97.609     0.200
     6.934    99.953     0.200
     6.977    99.656     0.200
     7.203   103.438     0.200
     7.241   104.094     0.200
     7.309   103.695     0.200
     7.333   106.016     0.200
     7.397   106.539     0.200
     7.971   113.953     0.200
     7.977   114.297     0.200
     7.996   114.453     0.200
     8.036   114.367     0.200
     8.069   115.523     0.200
     8.191   116.586     0.200
     8.319   118.344     0.200
     8.334   120.203     0.200
     8.624   122.375     0.200
     8.671   124.953     0.200
     8.774   123.797     0.200
     8.795   125.586     0.200
     8.845   126.164     0.200
     8.905   127.109     0.200
     8.929   125.734     0.200
     8.926   127.398     0.200
     8.926   126.539     0.200
     8.949   125.297     0.200
     9.097   129.203     0.200
     9.193   131.094     0.200
     9.193   130.000     0.200
     9.288   130.703     0.200
     9.393   132.430     0.200
     9.587   135.359     0.200
     9.612   134.945     0.200
     9.767   137.297     0.200
    10.025   141.547     0.200
    10.480   149.094     0.200
    10.480   147.195     0.200
    10.480   148.195     0.200
    10.682   149.594     0.200
    10.762   151.109     0.200
    11.048   155.023     0.200
    11.080   155.477     0.200
    11.252   158.359     0.200
    11.381   160.297     0.200
    11.872   168.047     0.200
    11.964   169.594     0.200
    12.008   169.430     0.200
    12.053   169.977     0.200
    12.283   172.398     0.200
    12.297   169.945     0.200
    12.747   178.578     0.200
    12.999   181.336     0.200
    13.537   190.867     0.200
    13.942   195.250     0.200
    14.426   200.617     0.200
    14.576   203.898     0.200
    14.725   206.719     0.200
    14.839   206.484     0.200
    15.079   211.414     0.200
    15.326   213.648     0.200
    15.611   215.641     0.200
    15.611   215.328     0.200
    15.698   219.875     0.200
    15.827   220.000     0.200
    15.920   222.000     0.200
    16.374   226.977     0.200
    16.877   235.023     0.200
    16.973   234.555     0.200
    17.491   240.266     0.200
     0.997    18.734     0.200
     1.613    27.344     0.200
     1.613    27.852     0.200
     1.623    29.062     0.200
     1.820    30.336     0.200
     1.820    31.195     0.200
     1.824    32.547     0.200
     2.022    32.562     0.200
     2.359    39.617     0.200
     2.551    42.766     0.200
     2.760    42.812     0.200
     2.805    45.367     0.200
     2.805    45.766     0.200
     2.905    46.797     0.200
     2.905    47.086     0.200
     3.676    56.164     0.200
     3.826    56.664     0.200
     3.809    58.023     0.200
     3.917    59.242     0.200
     4.225    64.562     0.200
     4.316    64.852     0.200
     4.402    65.883     0.200
     4.459    66.812     0.200
     4.509    67.117     0.200
     4.520    66.602     0.200
     4.600    67.117     0.200
     4.582    68.484     0.200
     4.582    68.781     0.200
     4.671    69.664     0.200
     4.671    70.047     0.200
     4.750    71.047     0.200
     4.824    71.055     0.200
     4.895    72.805     0.200
     4.945    73.141     0.200
     5.627    82.227     0.200
     5.970    88.227     0.200
     6.597    96.117     0.200
     6.621    96.062     0.200
     6.616    96.188     0.200
     6.909    99.883     0.200
     7.085   101.141     0.200
     7.091   103.141     0.200
     7.203   102.195     0.200
     7.242   103.273     0.200
     7.914   113.766     0.200
     7.967   113.836     0.200
     7.965   115.641     0.200
     7.970   115.766     0.200
     8.337   119.914     0.200
     8.550   123.375     0.200
     8.716   124.094     0.200
     8.881   127.062     0.200
     9.216   131.477     0.200
     9.313   132.023     0.200
     9.318   132.953     0.200
     9.350   134.453     0.200
     9.525   133.953     0.200
     9.538   135.523     0.200
     9.897   139.422     0.200
    10.079   143.266     0.200
    10.409   146.805     0.200
    10.507   148.477     0.200
    10.469   150.688     0.200
    10.771   153.406     0.200
    10.923   155.195     0.200
    10.988   156.203     0.200
    11.057   155.961     0.200
    11.205   158.070     0.200
    11.520   162.555     0.200
    11.677   165.906     0.200
    11.842   167.391     0.200
    11.964   169.914     0.200
    12.239   173.695     0.200
    12.213   169.109     0.200
    12.213   170.875     0.200
    12.663   178.125     0.200
    13.047   183.625     0.200
    13.684   192.875     0.200
    14.332   200.914     0.200
    14.407   202.211     0.200
    14.683   207.422     0.200
    15.045   211.555     0.200
    15.535   218.344     0.200
    15.592   220.312     0.200
    15.709   221.023     0.200
    16.863   235.195     0.200
    16.897   235.812     0.200
    16.921   235.414     0.200
     1.546    27.109     0.200
     1.744    28.930     0.200
     2.311    38.766     0.200
     2.506    41.164     0.200
     2.747    40.625     0.200
     2.662    43.695     0.200
     2.767    44.430     0.200
     3.498    53.078     0.200
     3.601    55.586     0.200
     3.647    53.961     0.200
     3.975    59.398     0.200
     4.124    62.000     0.200
     4.201    62.977     0.200
     4.468    65.750     0.200
     4.575    65.805     0.200
     5.207    74.141     0.200
     5.069    74.641     0.200
     6.131    89.125     0.200
     6.217    90.047     0.200
     6.537    94.625     0.200
     8.477   121.617     0.200
     9.852   139.250     0.200
    11.461   159.555     0.200
    12.155   170.008     0.200
    12.422   174.656     0.200
    14.407   200.617     0.200
    14.786   209.727     0.200
    15.100   210.039     0.200
    15.531   217.930     0.200
     1.742    28.539     0.200
     1.843    30.953     0.200
     1.835    30.961     0.200
     2.280    37.852     0.200
     2.399    39.750     0.200
     2.467    40.492     0.200
     2.628    42.805     0.200
     2.711    43.773     0.200
     3.417    53.234     0.200
     3.522    54.633     0.200
     3.540    55.031     0.200
     3.568    54.523     0.200
     3.591    55.781     0.200
     3.883    59.211     0.200
     3.883    59.023     0.200
     4.863    73.430     0.200
     4.795    71.984     0.200
     4.877    73.242     0.200
     4.938    74.391     0.200
     5.379    78.820     0.200
     5.690    83.516     0.200
     5.858    86.602     0.200
     6.020    88.680     0.200
     6.108    90.000     0.200
     6.394    93.352     0.200
     6.471    95.016     0.200
     6.471    95.289     0.200
     7.064   100.102     0.200
     7.220   104.125     0.200
     7.402   105.836     0.200
     8.064   114.500     0.200
     8.020   116.273     0.200
     8.119   115.609     0.200
     8.386   119.055     0.200
     8.704   122.820     0.200
     8.652   124.453     0.200
     8.772   125.039     0.200
     8.664   124.820     0.200
     8.714   125.594     0.200
     8.758   126.375     0.200
     8.774   126.656     0.200
     8.795   127.016     0.200
     8.795   125.531     0.200
     8.991   128.406     0.200
     9.272   130.414     0.200
     9.272   129.914     0.200
     9.317   132.359     0.200
     9.471   133.250     0.200
     9.552   137.164     0.200
     9.597   136.891     0.200
     9.886   138.570     0.200
     9.914   142.102     0.200
    10.349   148.812     0.200
    10.349   146.812     0.200
    10.349   148.000     0.200
    10.628   151.711     0.200
    10.632   150.766     0.200
    10.891   155.086     0.200
    10.990   154.312     0.200
    12.087   170.164     0.200
    12.196   171.211     0.200
    12.196   169.609     0.200
    12.362   169.609     0.200
    12.362   170.805     0.200
    12.836   178.453     0.200
    13.307   184.312     0.200
    14.133   196.516     0.200
    15.053   209.422     0.200
    15.448   214.312     0.200
    15.481   214.906     0.200
    16.384   227.250     0.200
    16.998   234.164     0.200
    17.017   236.180     0.200
    18.106   246.742     0.200
     1.661    29.500     0.200
     2.357    39.109     0.200
     2.477    40.766     0.200
     2.545    41.320     0.200
     2.706    43.656     0.200
     2.793    45.039     0.200
     2.893    46.500     0.200
     3.503    53.258     0.200
     3.608    55.656     0.200
     3.654    55.789     0.200
     3.893    57.594     0.200
     3.971    59.805     0.200
     4.070    61.664     0.200
     4.196    63.547     0.200
     4.671    67.945     0.200
     4.966    74.656     0.200
     5.005    74.648     0.200
     5.310    75.859     0.200
     5.310    76.078     0.200
     6.110    89.680     0.200
     6.705    97.438     0.200
     8.270   120.086     0.200
     8.632   123.516     0.200
     8.790   124.977     0.200
     8.949   126.641     0.200
     8.960   126.789     0.200
     8.885   127.336     0.200
     9.388   132.109     0.200
     9.978   141.844     0.200
    10.046   142.680     0.200
    10.398   148.086     0.200
    10.438   150.180     0.200
    10.720   152.539     0.200
    12.031   170.156     0.200
    12.308   173.414     0.200
    12.297   168.938     0.200
    12.759   178.766     0.200
    12.892   181.789     0.200
    13.110   184.359     0.200
    12.956   181.789     0.200
    13.602   189.719     0.200
    14.042   194.367     0.200
    14.389   202.258     0.200
    14.459   201.969     0.200
    14.536   203.336     0.200
    14.749   207.875     0.200
    15.106   211.336     0.200
    15.294   211.570     0.200
    15.655   220.758     0.200
    16.226   225.078     0.200
    18.600   255.844     0.200
    18.600   256.461     0.200
     0.941    17.562     0.200
     1.560    25.289     0.200
     1.768    28.328     0.200
     1.768    29.703     0.200
     1.776    28.750     0.200
     1.976    31.008     0.200
     2.459    40.273     0.200
     2.529    39.180     0.200
     2.742    39.633     0.200
     2.687    41.656     0.200
     3.324    50.578     0.200
     3.517    53.781     0.200
     3.621    54.930     0.200
     3.688    56.242     0.200
     3.666    55.398     0.200
     3.765    56.461     0.200
     3.871    58.203     0.200
     3.992    58.883     0.200
     4.218    63.078     0.200
     4.275    63.297     0.200
     4.359    64.562     0.200
     4.418    65.562     0.200
     4.479    66.008     0.200
     4.575    66.711     0.200
     4.632    67.453     0.200
     4.632    68.383     0.200
     4.935    71.367     0.200
     4.935    72.312     0.200
     5.209    74.727     0.200
     5.494    80.398     0.200
     5.589    80.906     0.200
     5.692    82.758     0.200
     6.548    95.758     0.200
     6.580    93.508     0.200
     6.946    99.359     0.200
     7.043    99.219     0.200
    10.957   154.172     0.200
    13.536   188.258     0.200
    15.573   216.094     0.200
    16.255   226.828     0.200
    16.840   231.922     0.200
    16.857   232.367     0.200
    16.872   232.047     0.200
     1.803    30.094     0.200
     1.910    32.258     0.200
     1.989    33.938     0.200
     2.217    35.594     0.200
     2.451    40.797     0.200
     2.517    41.383     0.200
     2.517    40.906     0.200
     2.679    43.508     0.200
     2.919    45.242     0.200
     2.755    44.398     0.200
     3.452    53.195     0.200
     3.452    54.805     0.200
     3.558    56.094     0.200
     3.576    56.273     0.200
     3.604    55.008     0.200
     3.627    57.203     0.200
     3.914    59.328     0.200
     3.914    60.602     0.200
     4.014    61.383     0.200
     4.014    61.508     0.200
     4.068    62.406     0.200
     4.176    64.383     0.200
     4.900    74.031     0.200
     4.822    73.023     0.200
     4.903    73.812     0.200
     4.935    74.422     0.200
     4.965    74.961     0.200
     4.965    75.102     0.200
     4.999    74.844     0.200
     5.440    82.008     0.200
     5.749    84.398     0.200
     5.817    84.945     0.200
     6.206    90.328     0.200
     6.131    90.117     0.200
     6.536    96.133     0.200
     6.815    98.633     0.200
     7.045   101.844     0.200
     7.095   101.906     0.200
     7.188   104.266     0.200
     7.278   105.172     0.200
     7.315   104.781     0.200
     7.411   106.602     0.200
     7.445   107.547     0.200
     7.510   108.477     0.200
     8.051   117.023     0.200
     8.087   116.734     0.200
     8.524   123.945     0.200
     8.710   123.508     0.200
     8.740   124.055     0.200
     8.727   126.508     0.200
     8.691   126.273     0.200
     8.741   126.297     0.200
     8.785   127.516     0.200
     8.801   127.367     0.200
     8.821   127.602     0.200
     8.821   127.211     0.200
     9.309   132.008     0.200
     9.309   131.508     0.200
     9.380   135.312     0.200
     9.509   133.477     0.200
     9.545   137.164     0.200
     9.667   138.914     0.200
     9.888   140.406     0.200
     9.942   142.531     0.200
    10.377   149.305     0.200
    10.377   148.805     0.200
    10.377   148.992     0.200
    12.082   171.203     0.200
    12.243   172.703     0.200
    12.243   172.008     0.200
    12.243   174.031     0.200
    12.404   174.102     0.200
    12.407   172.305     0.200
    12.407   171.781     0.200
    12.687   179.453     0.200
    14.125   199.406     0.200
    14.528   201.625     0.200
    14.695   205.906     0.200
    14.846   207.523     0.200
    14.959   208.617     0.200
    15.431   218.305     0.200
    15.431   215.398     0.200
    15.522   215.820     0.200
    15.522   218.602     0.200
    15.522   217.305     0.200
    16.038   222.633     0.200
    16.996   236.180     0.200
    16.996   236.008     0.200
    17.066   235.172     0.200
    17.728   244.508     0.200
    18.144   249.148     0.200
     1.017    19.469     0.200
     1.017    18.867     0.200
     1.644    27.719     0.200
     1.627    29.367     0.200
     1.852    31.242     0.200
     1.833    30.422     0.200
     2.347    39.477     0.200
     2.617    41.914     0.200
     2.469    41.523     0.200
     2.791    43.469     0.200
     2.791    41.930     0.200
     2.538    41.922     0.200
     2.697    44.172     0.200
     2.790    45.469     0.200
     3.507    54.359     0.200
     3.978    61.328     0.200
     4.494    67.422     0.200
     4.554    67.312     0.200
     4.633    67.820     0.200
     5.270    76.914     0.200
     6.123    91.148     0.200
     6.316    92.648     0.200
     6.656    96.469     0.200
     6.943    99.422     0.200
     7.999   115.344     0.200
     7.965   115.992     0.200
     8.585   123.508     0.200
     8.916   127.633     0.200
     9.250   132.219     0.200
     9.347   132.812     0.200
     9.559   134.508     0.200
     9.743   137.742     0.200
     9.932   141.062     0.200
    10.113   143.391     0.200
    10.223   145.328     0.200
    10.540   148.977     0.200
    10.729   154.688     0.200
    11.079   157.477     0.200
    11.314   159.758     0.200
    11.278   160.414     0.200
    11.553   162.898     0.200
    11.710   166.109     0.200
    11.876   167.828     0.200
    12.271   173.828     0.200
    12.697   178.633     0.200
    13.078   184.219     0.200
    13.576   190.602     0.200
    14.020   197.969     0.200
    14.361   201.227     0.200
    14.715   208.070     0.200
    14.798   206.773     0.200
    14.892   212.453     0.200
    15.569   217.062     0.200
    15.739   222.219     0.200
    16.330   229.492     0.200
     1.125    20.078     0.200
     1.659    28.688     0.200
     1.824    30.516     0.200
     1.930    31.984     0.200
     1.880    32.367     0.200
     2.223    34.625     0.200
     2.295    37.727     0.200
     2.479    40.578     0.200
     2.642    42.977     0.200
     2.944    43.086     0.200
     4.016    58.828     0.200
     4.663    69.344     0.200
     4.723    69.578     0.200
     4.794    69.422     0.200
     4.794    69.242     0.200
     4.899    72.234     0.200
     4.923    73.414     0.200
     5.027    74.281     0.200
     5.433    77.742     0.200
     5.433    77.508     0.200
     5.830    84.492     0.200
     6.825    98.367     0.200
     6.890    99.477     0.200
     7.111   102.438     0.200
     7.288   105.086     0.200
     7.279   105.555     0.200
     7.405   104.523     0.200
     7.455   107.734     0.200
     7.520   107.914     0.200
     8.168   116.781     0.200
     8.168   116.797     0.200
     8.439   121.719     0.200
     8.754   125.383     0.200
     8.914   126.469     0.200
     9.083   128.688     0.200
     9.322   132.727     0.200
     9.419   133.805     0.200
     9.512   134.953     0.200
     9.521   135.734     0.200
     9.725   136.203     0.200
     9.741   138.016     0.200
     9.907   139.523     0.200
     9.907   139.844     0.200
    10.100   143.594     0.200
    10.169   144.562     0.200
    10.390   147.203     0.200
    10.522   149.305     0.200
    10.702   150.523     0.200
    11.103   155.867     0.200
    11.252   158.867     0.200
    11.397   160.531     0.200
    11.511   162.219     0.200
    11.714   165.273     0.200
    11.869   168.031     0.200
    11.997   169.531     0.200
    12.153   171.453     0.200
    12.431   175.516     0.200
    12.415   171.172     0.200
    12.415   171.547     0.200
    12.439   173.953     0.200
    12.685   176.781     0.200
    12.864   179.812     0.200
    12.882   180.867     0.200
    12.987   183.633     0.200
    13.230   186.086     0.200
    13.718   190.758     0.200
    14.507   202.906     0.200
    14.573   203.367     0.200
    14.539   202.281     0.200
    14.652   205.328     0.200
    14.687   205.086     0.200
    14.723   206.227     0.200
    14.871   208.805     0.200
    14.967   209.086     0.200
    15.049   210.906     0.200
    15.226   213.508     0.200
    15.736   219.133     0.200
    15.776   220.906     0.200
    16.053   223.953     0.200
    16.343   227.094     0.200
    16.437   227.016     0.200
    16.499   228.781     0.200
    17.057   236.852     0.200
    17.081   234.773     0.200
    17.100   237.734     0.200
    17.096   237.703     0.200
    17.118   236.258     0.200
     1.727    29.992     0.200
     1.886    31.820     0.200
     1.940    32.195     0.200
     2.398    39.664     0.200
     2.585    41.883     0.200
     2.758    44.055     0.200
     2.840    43.148     0.200
     2.840    42.711     0.200
     2.746    44.219     0.200
     2.827    45.375     0.200
     3.528    54.953     0.200
     3.528    54.500     0.200
     3.634    56.164     0.200
     3.652    56.711     0.200
     3.680    57.242     0.200
     3.915    58.453     0.200
     3.915    57.953     0.200
     3.991    61.055     0.200
     3.991    59.812     0.200
     4.092    62.141     0.200
     4.217    64.094     0.200
     4.590    68.781     0.200
     4.649    69.734     0.200
     4.697    68.852     0.200
     4.697    68.609     0.200
     4.858    73.070     0.200
     4.904    73.539     0.200
     5.074    75.930     0.200
     4.982    74.664     0.200
     5.048    75.469     0.200
     5.044    75.859     0.200
     5.339    77.172     0.200
     5.339    76.859     0.200
     5.752    84.305     0.200
     6.111    89.289     0.200
     6.123    90.008     0.200
     6.588    99.148     0.200
     6.754    98.383     0.200
     6.753    98.180     0.200
     6.770    99.375     0.200
     7.027   100.852     0.200
     7.217   103.984     0.200
     7.321   103.992     0.200
     7.358   105.344     0.200
     7.385   107.500     0.200
     7.449   108.125     0.200
     8.048   116.172     0.200
     8.082   116.094     0.200
     8.087   116.023     0.200
     8.091   116.383     0.200
     8.371   121.422     0.200
     8.675   125.148     0.200
     8.822   126.102     0.200
     8.999   128.359     0.200
     8.900   128.852     0.200
     8.900   128.141     0.200
     9.037   129.461     0.200
     9.338   132.789     0.200
     9.420   133.719     0.200
     9.444   134.812     0.200
     9.475   133.719     0.200
     9.635   136.375     0.200
     9.662   137.312     0.200
     9.815   139.250     0.200
    10.019   142.570     0.200
    10.071   143.250     0.200
    10.139   143.500     0.200
    10.456   150.953     0.200
    10.456   150.812     0.200
    10.605   150.133     0.200
    11.128   157.719     0.200
    11.298   159.570     0.200
    11.617   164.172     0.200
    11.956   168.734     0.200
    12.052   170.609     0.200
    12.325   174.250     0.200
    12.348   172.047     0.200
    12.348   172.750     0.200
    12.643   176.195     0.200
    13.126   184.922     0.200
    13.608   190.234     0.200
    13.987   196.812     0.200
    14.234   199.914     0.200
    14.543   202.875     0.200
    14.588   204.070     0.200
    14.614   205.055     0.200
    14.832   208.414     0.200
    14.891   209.672     0.200
    14.890   208.070     0.200
    15.120   211.828     0.200
    15.376   215.312     0.200
    15.671   219.469     0.200
    15.777   220.859     0.200
    15.878   220.125     0.200
    15.970   222.055     0.200
    16.425   229.172     0.200
    16.500   229.492     0.200
    16.916   235.398     0.200
    16.960   236.039     0.200
    16.998   235.070     0.200
    17.024   237.125     0.200
    17.066   236.758     0.200
    17.542   241.391     0.200
     1.456    25.703     0.200
     1.564    27.562     0.200
     1.544    27.680     0.200
     1.645    28.680     0.200
     1.730    29.578     0.200
     1.872    30.102     0.200
     2.364    37.852     0.200
     2.350    38.773     0.200
     2.667    41.070     0.200
     2.667    40.242     0.200
     2.546    40.992     0.200
     2.701    43.523     0.200
     2.814    45.164     0.200
     3.220    49.312     0.200
     3.518    53.492     0.200
     3.663    55.523     0.200
     3.553    55.672     0.200
     3.553    54.609     0.200
     3.724    55.469     0.200
     3.724    55.023     0.200
     3.768    57.078     0.200
     3.655    56.422     0.200
     3.701    56.664     0.200
     4.034    61.773     0.200
     4.034    59.820     0.200
     4.130    63.031     0.200
     4.317    64.750     0.200
     4.379    65.359     0.200
     4.260    65.109     0.200
     4.489    65.570     0.200
     4.489    65.242     0.200
     4.532    67.539     0.200
     4.552    68.180     0.200
     4.685    68.641     0.200
     4.806    70.820     0.200
     4.833    71.383     0.200
     4.854    71.414     0.200
     4.956    74.344     0.200
     5.120    74.266     0.200
     5.120    73.570     0.200
     5.093    76.195     0.200
     5.407    79.055     0.200
     5.490    80.984     0.200
     5.446    80.328     0.200
     5.821    85.766     0.200
     5.876    85.625     0.200
     5.920    87.266     0.200
     6.106    89.414     0.200
     6.444    93.062     0.200
     6.479    93.320     0.200
     6.481    94.078     0.200
     6.544    94.773     0.200
     6.447    95.672     0.200
     6.778    97.172     0.200
     6.842    99.891     0.200
     6.941   100.062     0.200
     6.935   100.094     0.200
     6.979   100.922     0.200
     7.014   101.492     0.200
     7.108   102.516     0.200
     7.174   103.055     0.200
     7.221   104.422     0.200
     7.601   109.211     0.200
     7.830   112.164     0.200
     7.838   111.172     0.200
     7.814   112.078     0.200
     7.798   112.562     0.200
     7.853   112.742     0.200
     7.988   114.102     0.200
     8.029   115.828     0.200
     8.181   117.609     0.200
     8.376   118.719     0.200
     8.414   119.430     0.200
     8.478   121.742     0.200
     8.751   122.539     0.200
     8.980   126.250     0.200
     9.081   128.500     0.200
     8.959   129.773     0.200
     9.200   133.133     0.200
     9.334   134.062     0.200
     9.401   132.781     0.200
     9.589   134.875     0.200
     9.685   138.273     0.200
     9.763   137.078     0.200
     9.903   139.000     0.200
     9.963   140.055     0.200
    10.022   143.219     0.200
    10.119   144.328     0.200
    10.288   144.898     0.200
    10.393   146.578     0.200
    10.506   152.375     0.200
    10.865   152.789     0.200
    10.787   153.602     0.200
    11.090   156.070     0.200
    11.172   158.391     0.200
    11.782   165.430     0.200
    11.799   167.062     0.200
    12.067   167.359     0.200
    12.067   168.094     0.200
    12.144   172.570     0.200
    12.318   173.883     0.200
    12.368   172.094     0.200
    12.551   174.711     0.200
    13.015   183.281     0.200
    13.564   189.922     0.200
    13.781   192.766     0.200
    14.001   195.945     0.200
    14.248   200.344     0.200
    14.470   203.969     0.200
    14.570   202.039     0.200
    14.626   203.359     0.200
    14.758   205.742     0.200
    14.953   210.875     0.200
    15.118   211.828     0.200
    15.494   218.281     0.200
    15.622   219.570     0.200
    16.324   228.281     0.200
    16.771   233.148     0.200
    17.165   237.312     0.200
     0.990    18.734     0.200
     1.784    29.602     0.200
     2.078    33.102     0.200
     2.471    40.031     0.200
     2.631    41.820     0.200
     2.723    43.383     0.200
     2.845    41.711     0.200
     3.441    52.445     0.200
     3.591    56.719     0.200
     3.913    59.805     0.200
     4.749    70.594     0.200
     4.775    71.664     0.200
     4.907    73.344     0.200
     5.040    74.562     0.200
     5.316    76.398     0.200
     6.026    88.445     0.200
     6.108    89.594     0.200
     6.311    92.383     0.200
     6.646    97.352     0.200
     6.647    97.125     0.200
     7.130   103.234     0.200
     7.422   106.516     0.200
     7.976   115.164     0.200
     8.010   115.234     0.200
     8.231   119.344     0.200
     8.369   120.945     0.200
     8.582   122.781     0.200
     8.904   127.398     0.200
    15.922   222.242     0.200
    16.361   225.312     0.200
    16.443   227.445     0.200
    16.950   234.273     0.200
    19.058   261.445     0.200
     1.567    27.359     0.200
     1.621    28.648     0.200
     1.756    29.992     0.200
     1.811    31.219     0.200
     1.817    31.609     0.200
     1.972    32.469     0.200
     2.234    35.945     0.200
     2.381    39.180     0.200
     2.467    39.250     0.200
     2.574    41.242     0.200
     2.712    41.648     0.200
     2.712    40.609     0.200
     2.832    45.000     0.200
     3.321    50.055     0.200
     3.559    54.555     0.200
     3.559    54.312     0.200
     3.614    54.531     0.200
     3.678    56.469     0.200
     3.662    56.070     0.200
     3.679    56.453     0.200
     3.708    56.055     0.200
     3.777    56.148     0.200
     3.758    56.328     0.200
     3.733    57.391     0.200
     4.034    60.648     0.200
     4.034    60.070     0.200
     4.131    62.273     0.200
     4.264    63.461     0.200
     4.259    63.945     0.200
     4.296    64.461     0.200
     4.351    64.961     0.200
     4.408    65.953     0.200
     4.468    66.242     0.200
     4.530    67.828     0.200
     4.550    66.250     0.200
     4.550    66.555     0.200
     4.661    69.391     0.200
     4.858    72.578     0.200
     4.894    72.211     0.200
     4.924    72.805     0.200
     4.941    72.922     0.200
     4.953    73.633     0.200
     5.035    74.812     0.200
     5.058    75.000     0.200
     5.095    75.930     0.200
     5.186    75.422     0.200
     5.186    74.914     0.200
     5.203    77.570     0.200
     5.504    80.492     0.200
     5.496    80.773     0.200
     5.575    81.453     0.200
     5.560    82.578     0.200
     5.707    84.578     0.200
     5.920    85.945     0.200
     5.963    86.844     0.200
     6.032    88.195     0.200
     6.252    91.234     0.200
     6.261    92.633     0.200
     6.271    91.109     0.200
     6.431    93.828     0.200
     6.513    95.648     0.200
     6.513    95.898     0.200
     6.548    95.062     0.200
     6.570    94.773     0.200
     6.571    95.102     0.200
     6.573    96.625     0.200
     6.635    95.969     0.200
     6.805    98.695     0.200
     6.857    97.875     0.200
     6.942   100.695     0.200
     7.033   101.164     0.200
     7.071   101.703     0.200
     7.107   102.383     0.200
     7.190   102.281     0.200
     7.200   103.859     0.200
     7.265   104.414     0.200
     7.278   104.859     0.200
     7.712   110.844     0.200
     7.798   112.078     0.200
     7.837   112.453     0.200
     7.842   112.750     0.200
     7.848   113.414     0.200
     7.915   111.594     0.200
     7.913   112.984     0.200
     7.893   114.055     0.200
     7.923   114.992     0.200
     7.911   113.984     0.200
     7.963   114.234     0.200
     7.956   114.852     0.200
     8.134   117.414     0.200
     8.185   117.125     0.200
     8.293   118.922     0.200
     8.466   119.883     0.200
     8.499   120.320     0.200
     8.665   123.125     0.200
     8.667   124.922     0.200
     8.872   127.461     0.200
     8.949   126.828     0.200
     8.954   128.250     0.200
     9.067   129.148     0.200
     9.067   127.422     0.200
     9.164   129.859     0.200
     9.143   130.289     0.200
     9.266   130.352     0.200
     9.311   130.359     0.200
     9.354   131.578     0.200
     9.366   134.914     0.200
     9.486   133.344     0.200
     9.658   136.250     0.200
     9.658   135.961     0.200
     9.680   137.094     0.200
     9.786   137.922     0.200
     9.845   139.414     0.200
     9.926   140.328     0.200
     9.977   140.680     0.200
    10.029   141.492     0.200
    10.104   141.984     0.200
    10.137   142.602     0.200
    10.129   144.633     0.200
    10.179   142.773     0.200
    10.504   150.352     0.200
    11.156   157.383     0.200
    12.025   170.398     0.200
    12.162   168.148     0.200
    12.162   167.641     0.200
    12.195   172.453     0.200
    12.162   171.258     0.200
    12.999   183.070     0.200
    13.842   194.414     0.200
    13.950   194.648     0.200
    14.506   203.953     0.200
    14.667   205.664     0.200
    14.712   205.328     0.200
    14.721   205.805     0.200
    15.124   210.992     0.200
    15.208   212.695     0.200
    15.202   212.164     0.200
    15.298   214.039     0.200
    15.483   216.578     0.200
    15.544   217.562     0.200
    15.605   217.875     0.200
    15.663   219.078     0.200
    15.606   215.992     0.200
    15.699   218.953     0.200
    15.799   220.312     0.200
    16.183   223.750     0.200
    16.807   233.625     0.200
     1.130    19.727     0.200
     1.769    29.039     0.200
     1.876    31.547     0.200
     1.917    31.414     0.200
     2.011    33.039     0.200
     2.176    34.344     0.200
     2.366    38.008     0.200
     2.552    40.180     0.200
     2.794    43.570     0.200
     2.768    44.016     0.200
     2.868    42.836     0.200
     2.868    43.000     0.200
     3.646    55.039     0.200
     3.958    58.438     0.200
     3.878    58.867     0.200
     3.941    57.938     0.200
     4.070    61.219     0.200
     4.552    67.414     0.200
     4.606    68.367     0.200
     4.666    68.875     0.200
     4.722    68.234     0.200
     4.722    67.719     0.200
     4.868    71.297     0.200
     4.817    71.297     0.200
     4.864    72.367     0.200
     4.981    73.086     0.200
     4.904    72.906     0.200
     5.011    73.398     0.200
     4.969    72.555     0.200
     5.127    74.656     0.200
     5.043    74.758     0.200
     5.123    75.320     0.200
     5.263    78.195     0.200
     5.363    77.203     0.200
     5.363    76.570     0.200
     5.406    79.711     0.200
     5.706    83.469     0.200
     5.700    83.086     0.200
     5.743    84.148     0.200
     5.770    84.359     0.200
     6.178    89.625     0.200
     6.123    89.625     0.200
     6.444    94.227     0.200
     6.753    98.328     0.200
     6.772    98.359     0.200
     6.833    98.758     0.200
     7.047   102.141     0.200
     7.146   102.641     0.200
     7.233   104.180     0.200
     7.238   104.445     0.200
     7.248   104.109     0.200
     7.270   105.281     0.200
     7.341   103.656     0.200
     7.400   106.844     0.200
     7.464   107.594     0.200
     7.466   106.688     0.200
     7.913   113.328     0.200
     8.043   115.258     0.200
     8.050   116.297     0.200
     8.081   116.219     0.200
     8.081   116.109     0.200
     8.106   115.555     0.200
     8.126   116.797     0.200
     8.339   119.594     0.200
     8.493   121.320     0.200
     8.665   123.648     0.200
     8.693   124.070     0.200
     8.787   125.070     0.200
     8.708   124.734     0.200
     8.831   126.375     0.200
     8.868   126.055     0.200
     8.785   126.625     0.200
     8.845   124.836     0.200
     9.019   127.375     0.200
     9.035   129.125     0.200
     9.462   133.594     0.200
     9.497   132.695     0.200
     9.570   137.219     0.200
     9.657   134.148     0.200
     9.681   136.094     0.200
     9.838   139.039     0.200
     9.838   138.656     0.200
    10.038   142.141     0.200
    10.096   143.141     0.200
    10.324   146.219     0.200
    10.423   146.938     0.200
    10.449   147.969     0.200
    10.539   148.836     0.200
    10.705   150.586     0.200
    10.823   152.898     0.200
    10.927   154.781     0.200
    11.119   156.094     0.200
    11.151   157.547     0.200
    11.184   157.961     0.200
    11.323   159.086     0.200
    11.662   165.766     0.200
    11.705   167.250     0.200
    12.026   167.539     0.200
    12.078   170.219     0.200
    12.111   171.570     0.200
    12.363   171.586     0.200
    12.363   171.797     0.200
    12.378   174.391     0.200
    12.367   174.430     0.200
    12.943   180.180     0.200
    13.275   187.680     0.200
    13.608   191.688     0.200
    13.818   195.117     0.200
    14.075   193.867     0.200
    14.256   200.578     0.200
    14.446   203.016     0.200
    14.482   202.109     0.200
    14.557   204.156     0.200
    14.795   207.539     0.200
    14.853   207.367     0.200
    14.908   207.375     0.200
    15.016   210.258     0.200
    15.148   211.859     0.200
    15.328   213.805     0.200
    15.395   214.391     0.200
    15.563   215.156     0.200
    15.563   216.930     0.200
    15.768   219.414     0.200
    15.807   221.438     0.200
    15.895   220.906     0.200
    16.384   227.211     0.200
    16.945   234.086     0.200
    17.042   233.961     0.200
    17.559   241.898     0.200
     1.622    27.930     0.200
     1.651    28.195     0.200
     1.634    28.859     0.200
     1.810    30.570     0.200
     1.829    31.000     0.200
     1.836    30.781     0.200
     2.029    32.000     0.200
     2.291    36.258     0.200
     2.367    38.281     0.200
     2.591    40.648     0.200
     2.591    40.945     0.200
     2.559    40.602     0.200
     2.760    41.328     0.200
     2.718    43.117     0.200
     2.813    43.789     0.200
     2.813    44.297     0.200
     2.912    45.789     0.200
     3.378    50.789     0.200
     3.533    53.711     0.200
     3.671    55.398     0.200
     3.735    56.430     0.200
     3.637    55.438     0.200
     3.827    56.383     0.200
     3.683    54.508     0.200
     3.924    58.977     0.200
     4.005    59.516     0.200
     4.230    63.242     0.200
     4.465    66.367     0.200
     4.602    67.039     0.200
     4.717    69.070     0.200
     4.829    70.586     0.200
     4.760    69.812     0.200
     4.950    72.609     0.200
     4.981    73.062     0.200
     4.997    73.289     0.200
     5.116    75.492     0.200
     5.239    75.336     0.200
     5.239    74.930     0.200
     5.631    81.961     0.200
     5.758    85.148     0.200
     5.977    86.945     0.200
     6.020    87.688     0.200
     6.270    91.680     0.200
     6.238    91.086     0.200
     6.628    95.852     0.200
     6.627    95.547     0.200
     6.626    96.086     0.200
     6.692    96.672     0.200
     6.861    98.922     0.200
     6.913    99.609     0.200
     7.090   101.812     0.200
     7.128   102.609     0.200
     7.164   103.211     0.200
     7.207   101.688     0.200
     7.257   105.078     0.200
     7.322   105.070     0.200
     7.899   113.852     0.200
     7.905   113.852     0.200
     7.920   112.945     0.200
     8.191   117.281     0.200
     8.724   124.117     0.200
     8.893   127.477     0.200
     9.123   129.641     0.200
     9.316   131.227     0.200
     9.323   132.117     0.200
     9.365   131.469     0.200
     9.357   134.930     0.200
     9.528   133.445     0.200
     9.542   134.789     0.200
     9.712   137.039     0.200
     9.712   136.648     0.200
     9.844   140.562     0.200
     9.901   140.367     0.200
     9.977   141.156     0.200
    10.031   141.391     0.200
    10.157   142.992     0.200
    10.192   143.266     0.200
    11.025   155.188     0.200
    11.256   158.672     0.200
    11.522   161.836     0.200
    11.778   165.609     0.200
    11.846   166.016     0.200
    11.895   167.180     0.200
    11.965   168.711     0.200
    12.087   169.922     0.200
    12.244   172.336     0.200
    12.219   168.641     0.200
    12.666   176.656     0.200
    14.550   204.039     0.200
    14.769   204.883     0.200
    14.869   208.961     0.200
    15.045   211.328     0.200
    15.029   211.320     0.200
    15.180   212.242     0.200
    15.258   211.539     0.200
    15.538   216.406     0.200
    15.592   216.141     0.200
    15.655   217.852     0.200
    15.708   220.461     0.200
    15.756   218.406     0.200
    15.855   219.281     0.200
    16.147   222.836     0.200
    16.154   224.570     0.200
    16.240   224.016     0.200
    16.301   225.422     0.200
    16.413   226.336     0.200
    16.851   233.086     0.200
    16.865   235.180     0.200
    16.883   232.758     0.200
    16.902   232.930     0.200
    16.928   234.297     0.200
    17.316   238.250     0.200
    17.418   240.039     0.200
     1.618    28.156     0.200
     1.601    28.617     0.200
     1.697    29.406     0.200
     1.753    30.406     0.200
     1.791    29.914     0.200
     1.911    30.516     0.200
     2.173    35.492     0.200
     2.473    39.836     0.200
     2.667    40.984     0.200
     2.667    40.633     0.200
     2.584    41.375     0.200
     2.847    45.203     0.200
     3.619    55.164     0.200
     3.729    56.188     0.200
     3.729    55.172     0.200
     3.698    56.062     0.200
     3.806    57.781     0.200
     4.059    62.984     0.200
     4.059    62.391     0.200
     4.291    64.234     0.200
     4.348    65.234     0.200
     4.409    65.016     0.200
     4.471    66.641     0.200
     4.499    65.523     0.200
     4.600    68.625     0.200
     4.651    69.961     0.200
     4.713    69.367     0.200
     4.835    71.242     0.200
     4.865    71.922     0.200
     4.998    75.336     0.200
     5.134    73.477     0.200
     5.134    74.141     0.200
     5.517    80.555     0.200
     5.506    81.531     0.200
     5.649    83.805     0.200
     5.859    84.672     0.200
     6.211    91.516     0.200
     6.487    95.414     0.200
     6.511    94.336     0.200
     6.502    96.984     0.200
     6.801    98.742     0.200
     7.004   101.375     0.200
     7.267   105.117     0.200
     7.859   113.195     0.200
     7.856   113.156     0.200
     7.861   113.828     0.200
     8.073   116.875     0.200
     8.407   119.297     0.200
     8.520   123.203     0.200
     8.785   126.477     0.200
     8.981   130.883     0.200
     9.106   128.945     0.200
     9.255   131.531     0.200
     9.428   133.516     0.200
     9.391   134.797     0.200
     9.788   138.586     0.200
     9.875   140.094     0.200
     9.976   141.586     0.200
    10.081   142.227     0.200
    10.228   145.352     0.200
    10.405   146.711     0.200
    10.530   153.188     0.200
    10.669   152.641     0.200
    10.917   154.406     0.200
    10.954   154.664     0.200
    11.106   156.031     0.200
    11.176   157.828     0.200
    11.141   157.492     0.200
    11.344   160.805     0.200
    11.419   161.047     0.200
    11.683   165.352     0.200
    11.735   165.594     0.200
    11.933   167.852     0.200
    12.101   167.281     0.200
    12.138   171.172     0.200
    12.387   176.984     0.200
    12.555   176.883     0.200
    12.573   176.555     0.200
    13.047   182.844     0.200
    13.042   184.133     0.200
    14.019   196.188     0.200
    14.225   198.938     0.200
    14.325   200.711     0.200
    14.586   205.555     0.200
    14.953   210.117     0.200
    15.497   217.602     0.200
    15.620   219.562     0.200
    16.123   224.586     0.200
    16.323   228.141     0.200
    16.766   232.758     0.200
    16.786   233.758     0.200
     1.128    20.172     0.200
     1.678    29.570     0.200
     1.788    30.844     0.200
     1.897    32.203     0.200
     1.974    33.477     0.200
     2.026    34.383     0.200
     2.203    36.344     0.200
     2.326    38.383     0.200
     2.464    40.125     0.200
     2.445    40.352     0.200
     2.511    41.008     0.200
     2.765    44.164     0.200
     2.673    43.062     0.200
     2.751    43.953     0.200
     2.912    44.781     0.200
     3.450    52.914     0.200
     3.552    54.547     0.200
     3.555    54.453     0.200
     3.555    54.984     0.200
     3.574    55.086     0.200
     3.601    55.531     0.200
     3.984    58.914     0.200
     3.984    58.742     0.200
     3.912    59.312     0.200
     4.098    61.461     0.200
     4.013    60.414     0.200
     4.639    68.625     0.200
     4.639    69.023     0.200
     4.699    69.344     0.200
     4.764    68.711     0.200
     4.764    69.258     0.200
     4.885    73.234     0.200
     4.916    72.852     0.200
     5.003    73.477     0.200
     4.934    73.211     0.200
     4.965    73.742     0.200
     5.048    74.555     0.200
     5.125    75.547     0.200
     5.125    75.844     0.200
     5.156    75.805     0.200
     5.171    76.242     0.200
     5.171    76.406     0.200
     5.289    77.953     0.200
     5.404    77.836     0.200
     5.404    79.531     0.200
     5.805    85.125     0.200
     5.747    84.391     0.200
     6.152    90.266     0.200
     6.131    89.641     0.200
     6.439    94.461     0.200
     6.453    93.602     0.200
     6.526    97.016     0.200
     6.802    98.531     0.200
     6.786    98.867     0.200
     6.866    99.664     0.200
     7.174   105.336     0.200
     7.267   105.406     0.200
     7.241   104.992     0.200
     7.339   106.164     0.200
     7.416   105.258     0.200
     7.473   107.086     0.200
     7.555   109.031     0.200
     8.074   116.273     0.200
     8.141   115.875     0.200
     8.142   116.695     0.200
     8.089   116.383     0.200
     8.080   116.508     0.200
     8.146   117.656     0.200
     8.363   120.672     0.200
     8.417   120.961     0.200
     8.509   122.141     0.200
     8.698   124.156     0.200
     8.729   124.477     0.200
     8.711   125.281     0.200
     8.691   125.008     0.200
     8.740   125.516     0.200
     8.885   126.773     0.200
     8.821   126.211     0.200
     8.821   125.797     0.200
     9.056   127.992     0.200
     9.045   129.242     0.200
     9.161   130.414     0.200
     9.297   132.312     0.200
     9.393   133.453     0.200
     9.364   133.422     0.200
     9.483   133.867     0.200
     9.497   134.383     0.200
     9.535   133.938     0.200
     9.531   137.656     0.200
     9.594   137.602     0.200
     9.697   135.094     0.200
     9.716   136.906     0.200
     9.878   138.984     0.200
     9.992   142.258     0.200
    10.017   143.961     0.200
     9.942   143.211     0.200
     9.957   141.906     0.200
    10.138   143.891     0.200
    10.004   143.133     0.200
    10.200   144.305     0.200
    10.356   148.156     0.200
    10.491   148.375     0.200
    10.376   147.414     0.200
    10.376   147.062     0.200
    10.579   149.602     0.200
    10.698   151.805     0.200
    10.659   151.062     0.200
    10.941   154.914     0.200
    11.089   157.172     0.200
    11.159   158.352     0.200
    11.633   164.820     0.200
    11.676   166.695     0.200
    11.838   168.195     0.200
    11.989   170.742     0.200
    12.071   170.633     0.200
    12.132   171.992     0.200
    12.230   173.391     0.200
    12.259   173.312     0.200
    12.397   174.117     0.200
    12.394   171.414     0.200
    12.661   177.172     0.200
    12.644   179.352     0.200
    12.855   179.836     0.200
    12.897   180.984     0.200
    13.291   188.062     0.200
    13.845   194.695     0.200
    14.055   197.336     0.200
    14.296   202.664     0.200
    14.473   203.312     0.200
    14.515   202.867     0.200
    14.572   204.688     0.200
    14.656   205.406     0.200
    14.690   205.812     0.200
    14.658   206.102     0.200
    14.976   209.133     0.200
    15.036   211.805     0.200
    15.193   213.195     0.200
    15.200   213.383     0.200
    15.349   214.703     0.200
    15.512   216.422     0.200
    15.519   214.055     0.200
    15.743   220.352     0.200
    16.475   229.836     0.200
    16.991   235.711     0.200
    17.592   242.508     0.200
    18.696   257.016     0.200
     1.620    27.648     0.200
     1.618    28.266     0.200
     1.700    28.969     0.200
     1.798    30.000     0.200
     1.817    30.211     0.200
     2.261    35.656     0.200
     2.365    38.227     0.200
     2.488    40.445     0.200
     2.488    40.688     0.200
     2.558    41.297     0.200
     2.740    40.508     0.200
     2.740    41.547     0.200
     2.814    44.445     0.200
     2.814    44.828     0.200
     3.348    49.961     0.200
     3.538    55.406     0.200
     3.538    54.766     0.200
     3.707    56.625     0.200
     3.642    55.609     0.200
     3.806    56.305     0.200
     3.806    55.945     0.200
     3.687    56.969     0.200
     3.786    57.211     0.200
     3.894    58.680     0.200
     4.012    59.906     0.200
     4.012    60.109     0.200
     4.110    61.461     0.200
     4.379    64.750     0.200
     4.436    65.938     0.200
     4.497    67.148     0.200
     4.579    66.305     0.200
     4.559    67.734     0.200
     4.649    68.711     0.200
     4.686    69.695     0.200
     4.730    69.336     0.200
     4.923    72.445     0.200
     4.953    73.102     0.200
     4.970    73.156     0.200
     5.085    75.156     0.200
     5.215    75.305     0.200
     5.215    75.102     0.200
     5.228    77.398     0.200
     5.193    76.211     0.200
     5.604    82.359     0.200
     5.947    87.398     0.200
     5.992    86.766     0.200
     6.161    89.469     0.200
     6.459    94.055     0.200
     6.600    95.430     0.200
     6.599    95.578     0.200
     6.663    96.234     0.200
     6.833    98.914     0.200
     6.887    99.352     0.200
     6.970   100.859     0.200
     7.062   101.367     0.200
     7.070   102.930     0.200
     7.135   102.555     0.200
     7.181   101.547     0.200
     7.219   102.445     0.200
     7.228   103.961     0.200
     7.294   104.875     0.200
     7.297   105.406     0.200
     7.353   106.156     0.200
     7.736   111.141     0.200
     7.826   112.461     0.200
     7.870   113.602     0.200
     7.876   113.758     0.200
     7.942   113.750     0.200
     7.926   114.266     0.200
     8.316   119.609     0.200
     8.495   120.859     0.200
     8.528   122.000     0.200
     8.694   122.664     0.200
     8.695   124.477     0.200
     8.859   124.664     0.200
     8.862   127.297     0.200
     8.931   128.211     0.200
     8.931   128.430     0.200
     9.096   129.906     0.200
     9.193   130.102     0.200
     9.291   130.609     0.200
     9.295   131.195     0.200
     9.340   130.867     0.200
     9.515   134.445     0.200
     9.688   136.305     0.200
     9.688   136.680     0.200
     9.793   139.906     0.200
     9.875   138.789     0.200
     9.955   141.359     0.200
    10.006   141.195     0.200
    10.058   142.141     0.200
    10.166   143.484     0.200
    10.245   144.320     0.200
    10.482   150.609     0.200
    10.482   149.539     0.200
    10.576   147.320     0.200
    10.764   152.695     0.200
    11.000   155.109     0.200
    11.045   157.570     0.200
    11.185   157.727     0.200
    11.431   161.570     0.200
    11.656   164.289     0.200
    11.873   166.664     0.200
    11.873   168.805     0.200
    11.932   169.508     0.200
    12.223   172.711     0.200
    12.190   168.359     0.200
    12.231   171.734     0.200
    12.188   172.391     0.200
    12.459   173.836     0.200
    12.658   178.750     0.200
    12.996   182.641     0.200
    13.135   183.141     0.200
    13.163   184.766     0.200
    13.642   189.586     0.200
    13.871   194.352     0.200
    14.103   197.406     0.200
    14.268   199.734     0.200
    14.313   200.266     0.200
    14.697   205.758     0.200
    14.695   204.898     0.200
    14.741   205.477     0.200
    15.026   211.219     0.200
    15.327   214.234     0.200
    15.572   219.430     0.200
    15.587   215.953     0.200
    16.834   234.430     0.200
     1.861    31.859     0.200
     2.070    33.969     0.200
     3.675    56.852     0.200
     4.634    67.586     0.200
     5.272    76.266     0.200
     5.670    82.414     0.200
     6.224    91.984     0.200
     6.529    94.125     0.200
     6.666    96.469     0.200
     6.950   101.602     0.200
     7.244   103.438     0.200
     8.007   114.750     0.200
     8.753   124.547     0.200
     8.922   127.039     0.200
     8.910   129.109     0.200
     8.910   128.758     0.200
     9.162   130.305     0.200
     9.350   132.938     0.200
     9.401   132.500     0.200
     9.746   137.805     0.200
     9.746   137.680     0.200
    10.009   142.602     0.200
    10.114   142.797     0.200
    10.362   147.320     0.200
    10.541   149.164     0.200
    10.463   149.258     0.200
    10.745   153.109     0.200
    11.026   156.430     0.200
    11.091   156.430     0.200
    11.238   158.891     0.200
    11.554   163.484     0.200
    11.838   167.711     0.200
    11.882   168.070     0.200
    11.927   168.945     0.200
    12.124   171.297     0.200
    12.259   169.609     0.200
    12.259   170.930     0.200
    12.525   175.266     0.200
    12.721   179.047     0.200
    12.980   182.898     0.200
    13.523   190.266     0.200
    13.720   191.711     0.200
    14.011   194.641     0.200
    14.356   202.414     0.200
    14.503   203.867     0.200
    14.807   206.359     0.200
    14.955   208.438     0.200
    15.072   212.211     0.200
    15.222   213.227     0.200
    15.264   214.266     0.200
    15.620   218.820     0.200
    15.583   216.500     0.200
    16.256   225.789     0.200
    16.200   225.781     0.200
    16.970   234.945     0.200
    16.875   233.805     0.200
     1.553    27.492     0.200
     1.610    28.211     0.200
     1.742    29.797     0.200
     1.805    30.320     0.200
     1.960    31.227     0.200
     2.521    41.211     0.200
     2.498    41.758     0.200
     2.707    41.406     0.200
     2.726    44.438     0.200
     2.829    45.633     0.200
     2.927    47.609     0.200
     3.557    55.070     0.200
     3.667    56.180     0.200
     3.660    56.406     0.200
     3.772    55.688     0.200
     3.706    56.781     0.200
     4.032    61.641     0.200
     4.182    64.250     0.200
     4.258    65.078     0.200
     4.397    65.891     0.200
     4.457    65.859     0.200
     4.544    66.086     0.200
     4.694    70.469     0.200
     4.844    72.133     0.200
     4.883    71.852     0.200
     5.046    74.250     0.200
     5.179    74.820     0.200
     5.179    74.586     0.200
     5.545    82.930     0.200
     5.565    80.969     0.200
     5.692    84.188     0.200
     5.908    85.383     0.200
     6.185    91.492     0.200
     6.535    96.570     0.200
     6.559    95.820     0.200
     6.504    96.180     0.200
     6.848   100.297     0.200
     7.022   100.539     0.200
     7.043   102.336     0.200
     7.896   114.102     0.200
     7.903   113.789     0.200
     7.944   114.961     0.200
     8.121   117.531     0.200
     8.455   119.711     0.200
     8.489   121.891     0.200
     8.657   123.148     0.200
     8.820   125.281     0.200
     8.827   126.516     0.200
     8.935   127.617     0.200
     9.154   130.086     0.200
     9.256   131.586     0.200
     9.254   131.203     0.200
     9.288   133.469     0.200
     9.302   130.820     0.200
     9.466   133.508     0.200
     9.476   134.156     0.200
     9.650   136.039     0.200
     9.836   139.531     0.200
     9.919   140.867     0.200
    10.021   141.703     0.200
    10.128   143.406     0.200
    10.350   146.086     0.200
    10.449   147.352     0.200
    10.476   149.898     0.200
    10.503   150.758     0.200
    10.709   149.992     0.200
    10.714   153.586     0.200
    10.852   153.070     0.200
    10.929   154.133     0.200
    10.963   155.172     0.200
    11.011   157.961     0.200
    11.187   158.422     0.200
    11.463   162.008     0.200
    11.621   165.086     0.200
    11.732   165.742     0.200
    11.782   166.508     0.200
    11.837   166.648     0.200
    11.909   169.062     0.200
    11.981   168.188     0.200
    12.149   172.438     0.200
    12.420   173.383     0.200
    12.449   174.148     0.200
    12.771   180.820     0.200
    12.994   183.750     0.200
    13.500   189.281     0.200
    13.625   190.766     0.200
    14.070   197.781     0.200
    14.274   200.961     0.200
    14.343   202.766     0.200
    14.361   200.742     0.200
    14.629   205.781     0.200
    15.474   217.508     0.200
     0.980    17.678     0.200
     1.562    26.488     0.200
     1.753    29.858     0.200
     1.809    30.808     0.200
     1.832    29.288     0.200
     1.962    30.398     0.200
     2.225    35.478     0.200
     2.458    38.908     0.200
     2.693    40.378     0.200
     2.693    39.908     0.200
     3.311    50.348     0.200
     3.581    52.978     0.200
     3.666    55.878     0.200
     3.759    55.178     0.200
     3.759    54.508     0.200
     3.856    57.918     0.200
     4.339    64.448     0.200
     4.455    64.678     0.200
     4.517    67.078     0.200
     4.532    65.648     0.200
     4.607    68.248     0.200
     4.655    68.928     0.200
     4.707    69.408     0.200
     4.860    71.398     0.200
     4.912    72.048     0.200
     5.049    74.018     0.200
     5.085    73.588     0.200
     5.169    74.247     0.200
     5.169    73.948     0.200
     5.169    74.118     0.200
     5.198    75.618     0.200
     5.238    75.338     0.200
     5.489    80.108     0.200
     5.561    80.248     0.200
     5.562    81.468     0.200
     5.706    83.588     0.200
     5.910    85.518     0.200
     6.252    90.858     0.200
     6.293    90.088     0.200
     6.532    94.978     0.200
     6.532    94.418     0.200
     6.570    95.188     0.200
     6.622    95.858     0.200
     6.792    97.588     0.200
     6.842    97.338     0.200
     7.021   101.268     0.200
     7.060   101.298     0.200
     7.136   100.698     0.200
     7.154   102.918     0.200
     7.188   102.738     0.200
     7.278   103.858     0.200
     7.320   105.018     0.200
     7.794   111.818     0.200
     7.830   112.758     0.200
     7.900   112.658     0.200
     7.893   113.428     0.200
     7.917   112.978     0.200
     7.916   113.668     0.200
     7.947   113.728     0.200
     8.055   114.228     0.200
     8.184   117.788     0.200
     8.485   119.538     0.200
     8.531   123.058     0.200
     8.648   122.138     0.200
     8.811   124.408     0.200
     8.814   124.098     0.200
     8.866   126.348     0.200
     8.843   125.018     0.200
     8.947   126.778     0.200
     8.937   126.268     0.200
     8.952   126.678     0.200
     8.976   126.578     0.200
     9.053   128.778     0.200
     9.053   127.808     0.200
     9.295   129.448     0.200
     9.290   132.898     0.200
     9.358   132.438     0.200
     9.458   131.548     0.200
     9.447   134.378     0.200
     9.472   132.118     0.200
     9.641   135.678     0.200
     9.666   136.458     0.200
     9.763   138.268     0.200
     9.777   138.558     0.200
     9.960   139.358     0.200
    10.011   139.988     0.200
    10.087   141.088     0.200
    10.341   145.028     0.200
    10.489   148.718     0.200
    10.512   149.248     0.200
    10.526   147.278     0.200
    10.526   149.268     0.200
    10.706   148.468     0.200
    10.808   151.128     0.200
    10.979   154.178     0.200
    11.012   153.718     0.200
    11.396   160.528     0.200
    11.775   165.488     0.200
    11.826   165.528     0.200
    11.896   167.108     0.200
    11.987   167.078     0.200
    11.987   166.648     0.200
    12.150   167.941     0.200
    12.150   167.468     0.200
    12.171   170.458     0.200
    12.176   170.778     0.200
    12.614   175.848     0.200
    13.929   192.878     0.200
    14.233   197.618     0.200
    14.414   200.788     0.200
    14.485   202.578     0.200
    14.846   207.108     0.200
    15.117   209.538     0.200
    15.160   208.968     0.200
    15.186   210.408     0.200
    15.254   212.278     0.200
    15.280   212.318     0.200
    15.467   214.668     0.200
    15.524   216.158     0.200
    15.587   217.738     0.200
    15.592   216.178     0.200
    15.642   217.988     0.200
    15.627   215.922     0.200
    15.686   216.948     0.200
    16.076   223.458     0.200
    16.309   225.358     0.200
    16.787   232.953     0.200
    16.795   232.228     0.200
    16.832   231.518     0.200
    16.863   232.928     0.200
    16.971   233.258     0.200
    17.108   235.548     0.200
    18.915   258.503     0.200
     1.469    25.818     0.200
     1.545    27.938     0.200
     1.711    29.858     0.200
     1.733    29.288     0.200
     1.886    31.578     0.200
     2.145    35.478     0.200
     2.378    39.288     0.200
     2.446    40.238     0.200
     2.469    41.598     0.200
     2.469    42.188     0.200
     2.679    42.668     0.200
     2.541    41.938     0.200
     2.541    42.668     0.200
     2.696    44.218     0.200
     2.696    44.598     0.200
     2.807    45.648     0.200
     2.807    46.188     0.200
     2.905    46.888     0.200
     2.905    47.178     0.200
     3.601    55.668     0.200
     3.546    56.288     0.200
     3.546    55.268     0.200
     3.736    56.968     0.200
     3.782    57.568     0.200
     3.648    55.828     0.200
     3.694    57.838     0.200
     4.026    60.748     0.200
     4.271    63.778     0.200
     4.122    63.138     0.200
     4.331    64.898     0.200
     4.173    63.638     0.200
     4.392    65.108     0.200
     4.455    66.808     0.200
     4.545    68.108     0.200
     4.565    68.268     0.200
     4.607    68.598     0.200
     4.698    69.238     0.200
     4.755    70.788     0.200
     4.820    71.098     0.200
     4.847    71.548     0.200
     4.868    72.168     0.200
     4.970    73.848     0.200
     5.106    75.718     0.200
     5.133    73.957     0.200
     5.133    76.088     0.200
     5.403    79.558     0.200
     5.457    80.478     0.200
     5.503    80.398     0.200
     5.605    82.658     0.200
     5.834    86.218     0.200
     5.932    87.708     0.200
     6.119    89.488     0.200
     6.150    90.508     0.200
     6.158    90.198     0.200
     6.457    94.478     0.200
     6.473    95.068     0.200
     6.493    94.178     0.200
     6.495    94.298     0.200
     6.558    95.548     0.200
     6.447    96.688     0.200
     6.792    99.648     0.200
     6.856    99.748     0.200
     6.955   101.008     0.200
     6.948   101.168     0.200
     6.954   100.038     0.200
     7.121   102.138     0.200
     7.174   103.638     0.200
     7.235   105.488     0.200
     7.613   109.838     0.200
     7.765   113.268     0.200
     7.783   112.878     0.200
     7.790   112.388     0.200
     7.827   112.798     0.200
     7.808   113.528     0.200
     7.867   113.418     0.200
     8.043   116.228     0.200
     8.108   117.448     0.200
     8.194   117.958     0.200
     8.389   120.078     0.200
     8.427   120.398     0.200
     8.425   121.638     0.200
     8.491   122.488     0.200
     8.585   123.988     0.200
     8.764   124.718     0.200
     8.740   125.378     0.200
     8.849   126.798     0.200
     9.046   130.208     0.200
     8.950   131.288     0.200
     9.205   130.628     0.200
     9.776   137.988     0.200
    10.074   142.338     0.200
    10.628   150.818     0.200
    10.923   156.258     0.200
    11.103   156.918     0.200
    11.185   158.548     0.200
    11.313   160.748     0.200
    11.420   160.428     0.200
    11.812   166.978     0.200
    11.922   169.278     0.200
    12.071   171.578     0.200
    12.080   166.538     0.200
    12.141   172.748     0.200
    12.546   177.568     0.200
    13.026   184.098     0.200
    14.014   197.428     0.200
    14.257   202.498     0.200
    14.344   201.998     0.200
    14.639   205.488     0.200
    14.879   210.008     0.200
    15.029   211.098     0.200
    15.418   216.858     0.200
    15.625   217.358     0.200
    15.731   221.008     0.200
    16.103   224.248     0.200
    16.168   224.638     0.200
    16.251   228.018     0.200
    16.759   232.518     0.200
    16.771   232.848     0.200
     1.010    18.348     0.200
     1.613    27.308     0.200
     1.643    28.658     0.200
     1.802    30.278     0.200
     1.857    31.568     0.200
     1.843    31.458     0.200
     2.016    32.398     0.200
     2.279    36.118     0.200
     2.382    39.028     0.200
     2.578    40.718     0.200
     2.609    41.248     0.200
     2.742    41.748     0.200
     2.574    40.958     0.200
     2.732    43.328     0.200
     2.829    44.928     0.200
     3.550    54.878     0.200
     3.721    56.458     0.200
     3.810    56.218     0.200
     3.802    57.098     0.200
     3.653    55.798     0.200
     3.699    57.438     0.200
     3.911    58.758     0.200
     4.120    61.578     0.200
     4.173    62.308     0.200
     4.394    65.328     0.200
     4.450    66.108     0.200
     4.510    66.648     0.200
     4.585    66.478     0.200
     4.573    68.188     0.200
     4.706    69.678     0.200
     4.814    70.338     0.200
     4.936    72.318     0.200
     4.902    72.478     0.200
     4.967    73.138     0.200
     4.982    73.158     0.200
     5.021    74.768     0.200
     5.222    75.322     0.200
     5.201    76.018     0.200
     5.548    80.998     0.200
     5.541    80.988     0.200
     5.616    82.068     0.200
     5.964    86.908     0.200
     6.169    89.568     0.200
     6.677    96.258     0.200
     6.677    96.588     0.200
     6.847    98.968     0.200
     6.897    98.328     0.200
     6.987   101.298     0.200
     7.114   102.928     0.200
     7.091   102.508     0.200
     7.229   102.258     0.200
     7.954   113.418     0.200
     7.954   113.398     0.200
     8.228   117.698     0.200
     8.509   120.538     0.200
     8.540   121.338     0.200
     8.702   123.148     0.200
     8.869   124.988     0.200
     8.858   127.698     0.200
     8.940   129.198     0.200
     9.205   130.438     0.200
     9.299   130.668     0.200
     9.349   130.738     0.200
     9.512   132.628     0.200
     9.695   136.108     0.200
     9.886   139.308     0.200
     9.960   140.488     0.200
    10.064   141.778     0.200
    10.176   143.228     0.200
    12.205   168.528     0.200
    12.205   169.318     0.200
     1.713    29.055     0.200
     1.905    32.165     0.200
     1.953    31.955     0.200
     1.961    33.125     0.200
     2.099    32.735     0.200
     2.366    37.525     0.200
     2.663    42.155     0.200
     2.696    42.685     0.200
     2.760    41.375     0.200
     2.760    40.775     0.200
     3.450    51.655     0.200
     3.719    55.875     0.200
     3.747    55.305     0.200
     3.791    58.065     0.200
     3.835    56.475     0.200
     3.835    56.335     0.200
     3.991    60.375     0.200
     4.062    59.475     0.200
     4.453    66.075     0.200
     4.467    66.675     0.200
     4.518    67.165     0.200
     4.577    67.695     0.200
     4.617    67.035     0.200
     4.640    68.985     0.200
     4.727    70.265     0.200
     4.802    71.355     0.200
     4.878    71.415     0.200
     4.861    71.905     0.200
     5.000    73.375     0.200
     5.055    73.765     0.200
     5.036    74.365     0.200
     5.046    74.155     0.200
     5.233    75.775     0.200
     5.260    75.619     0.200
     5.260    75.255     0.200
     5.260    75.815     0.200
     5.347    78.145     0.200
     5.625    82.555     0.200
     5.634    82.495     0.200
     5.678    82.655     0.200
     5.717    83.865     0.200
     5.860    86.515     0.200
     6.069    89.005     0.200
     6.197    89.015     0.200
     6.180    90.485     0.200
     6.355    92.625     0.200
     6.407    93.605     0.200
     6.418    93.465     0.200
     6.552    95.065     0.200
     6.624    97.975     0.200
     6.681    96.735     0.200
     6.681    96.745     0.200
     6.722    97.705     0.200
     6.745    97.655     0.200
     6.746    97.775     0.200
     6.913    99.695     0.200
     6.950    99.525     0.200
     7.068   102.895     0.200
     7.189   103.915     0.200
     7.214   104.015     0.200
     7.281   103.315     0.200
     7.377   106.295     0.200
     7.433   106.925     0.200
     7.464   108.085     0.200
     7.860   112.665     0.200
     7.914   113.575     0.200
     7.952   114.175     0.200
     7.977   114.655     0.200
     8.005   112.815     0.200
     8.011   114.025     0.200
     8.068   115.875     0.200
     8.087   116.265     0.200
     8.165   116.245     0.200
     8.268   118.925     0.200
     8.301   119.275     0.200
     8.319   120.195     0.200
     8.441   120.795     0.200
     8.576   122.005     0.200
     8.600   121.795     0.200
     8.685   123.865     0.200
     8.712   125.115     0.200
     8.743   123.765     0.200
     8.784   125.405     0.200
     8.895   125.495     0.200
     8.922   126.715     0.200
     8.973   127.475     0.200
     8.973   127.225     0.200
     8.995   129.065     0.200
     9.100   129.105     0.200
     9.170   130.475     0.200
     9.170   129.525     0.200
     9.287   133.405     0.200
     9.370   131.825     0.200
     9.397   131.655     0.200
     9.426   135.425     0.200
     9.557   133.995     0.200
     9.588   136.035     0.200
     9.736   137.475     0.200
     9.736   137.715     0.200
     9.914   141.095     0.200
     9.943   140.965     0.200
     9.991   141.785     0.200
    10.061   141.175     0.200
    10.101   142.185     0.200
    10.226   144.285     0.200
    10.437   147.665     0.200
    10.528   150.175     0.200
    10.643   151.255     0.200
    10.664   149.935     0.200
    10.810   151.605     0.200
    10.827   152.115     0.200
    10.878   154.655     0.200
    11.077   156.815     0.200
    11.217   158.065     0.200
    11.614   164.975     0.200
    11.943   165.515     0.200
    12.047   169.735     0.200
    12.118   168.435     0.200
    12.244   172.975     0.200
    12.286   172.435     0.200
    12.278   170.075     0.200
    12.278   169.865     0.200
    12.719   178.645     0.200
    13.047   181.405     0.200
    13.224   186.605     0.200
    13.907   194.415     0.200
    13.965   194.975     0.200
    14.318   199.875     0.200
    14.372   198.675     0.200
    14.507   203.135     0.200
    14.534   204.175     0.200
    14.505   202.745     0.200
    14.787   205.165     0.200
    14.882   207.205     0.200
    15.109   210.745     0.200
    15.274   212.875     0.200
    15.263   212.475     0.200
    15.590   216.555     0.200
    15.804   218.775     0.200
    16.352   226.035     0.200
    17.004   235.185     0.200
    17.469   240.485     0.200
     1.061    19.070     0.200
     1.674    28.770     0.200
     1.673    29.140     0.200
     1.863    31.350     0.200
     1.879    30.690     0.200
     1.917    32.670     0.200
     2.076    33.190     0.200
     2.339    37.080     0.200
     2.385    39.200     0.200
     2.506    40.990     0.200
     2.572    40.920     0.200
     2.575    41.410     0.200
     2.638    41.910     0.200
     2.783    42.880     0.200
     2.734    43.530     0.200
     2.734    43.720     0.200
     2.824    44.970     0.200
     2.924    46.120     0.200
     3.538    54.170     0.200
     3.538    54.040     0.200
     3.688    56.060     0.200
     3.712    56.870     0.200
     3.778    57.220     0.200
     3.853    56.470     0.200
     3.970    59.180     0.200
     4.006    59.870     0.200
     4.452    66.130     0.200
     4.567    67.580     0.200
     4.629    68.810     0.200
     4.631    66.740     0.200
     4.718    69.980     0.200
     4.767    71.330     0.200
     4.813    71.970     0.200
     4.870    70.860     0.200
     4.960    73.710     0.200
     4.921    73.140     0.200
     5.024    73.650     0.200
     5.038    73.980     0.200
     5.003    74.150     0.200
     5.033    74.480     0.200
     5.063    75.210     0.200
     5.096    75.650     0.200
     5.163    76.580     0.200
     5.270    75.189     0.200
     5.270    76.170     0.200
     5.270    75.780     0.200
     5.270    76.710     0.200
     5.672    83.040     0.200
     5.811    86.130     0.200
     6.024    87.770     0.200
     6.061    88.150     0.200
     6.235    89.510     0.200
     6.321    93.410     0.200
     6.356    92.730     0.200
     6.534    94.110     0.200
     6.550    96.970     0.200
     6.550    95.850     0.200
     6.654    96.710     0.200
     6.679    96.800     0.200
     6.734    97.490     0.200
     6.903    99.840     0.200
     6.950    99.400     0.200
     7.046   102.010     0.200
     7.152   103.820     0.200
     7.282   103.140     0.200
     7.365   105.430     0.200
     7.380   105.840     0.200
     7.434   107.260     0.200
     7.819   112.070     0.200
     7.899   113.610     0.200
     8.007   115.450     0.200
     8.029   114.970     0.200
     8.061   115.860     0.200
     8.240   118.130     0.200
     8.286   118.400     0.200
     8.298   119.800     0.200
     8.399   120.740     0.200
     8.595   122.190     0.200
     8.627   123.650     0.200
     8.686   123.880     0.200
     8.751   123.660     0.200
     8.769   124.830     0.200
     8.790   126.160     0.200
     8.910   126.300     0.200
     8.922   125.150     0.200
     8.884   127.900     0.200
     8.899   127.530     0.200
     8.946   128.040     0.200
     8.921   127.770     0.200
     8.921   127.320     0.200
     9.055   128.770     0.200
     9.164   131.470     0.200
     9.250   131.970     0.200
     9.349   131.950     0.200
     9.363   131.990     0.200
     9.401   131.880     0.200
     9.563   134.470     0.200
     9.582   134.310     0.200
     9.745   136.970     0.200
     9.745   136.590     0.200
     9.875   140.650     0.200
     9.891   141.450     0.200
     9.940   139.670     0.200
    10.006   141.410     0.200
    10.066   141.420     0.200
    10.112   142.190     0.200
    10.475   148.470     0.200
    10.475   149.060     0.200
    10.723   153.250     0.200
    10.757   152.510     0.200
    10.834   154.680     0.200
    10.892   153.170     0.200
    11.234   157.980     0.200
    11.229   160.960     0.200
    11.308   161.200     0.200
    11.510   163.930     0.200
    11.551   162.010     0.200
    11.706   165.500     0.200
    11.925   167.900     0.200
    11.926   165.830     0.200
    11.927   170.300     0.200
    12.014   170.260     0.200
    12.100   168.970     0.200
    12.100   170.160     0.200
    12.129   172.980     0.200
    12.263   169.470     0.200
    12.263   169.340     0.200
    12.267   172.870     0.200
    12.268   173.150     0.200
    12.554   177.890     0.200
    12.721   177.980     0.200
    12.992   181.720     0.200
    13.182   186.810     0.200
    13.209   183.890     0.200
    13.520   190.700     0.200
    14.003   195.470     0.200
    14.003   194.070     0.200
    14.172   197.750     0.200
    14.496   202.430     0.200
    14.567   204.670     0.200
    14.769   206.310     0.200
    14.814   208.500     0.200
    14.844   206.580     0.200
    14.860   207.280     0.200
    15.066   211.660     0.200
    15.220   214.090     0.200
    15.319   215.470     0.200
    15.380   215.820     0.200
    15.575   218.220     0.200
    15.615   217.800     0.200
    15.597   215.964     0.200
    15.727   221.660     0.200
    15.797   220.690     0.200
    15.893   221.220     0.200
    16.261   227.910     0.200
    16.868   234.945     0.200
    18.564   254.920     0.200
     1.839    30.939     0.200
     1.839    31.109     0.200
     1.996    33.259     0.200
     2.007    33.259     0.200
     2.026    32.739     0.200
     2.184    35.139     0.200
     2.485    40.469     0.200
     2.604    42.149     0.200
     2.806    41.859     0.200
     2.670    42.699     0.200
     2.832    44.699     0.200
     2.832    45.589     0.200
     2.909    46.169     0.200
     2.909    46.729     0.200
     3.009    47.489     0.200
     3.009    47.839     0.200
     3.534    54.079     0.200
     3.605    55.069     0.200
     3.885    56.909     0.200
     3.711    56.619     0.200
     3.730    57.249     0.200
     3.730    57.379     0.200
     3.757    57.809     0.200
     4.065    60.779     0.200
     4.546    67.749     0.200
     4.595    68.649     0.200
     4.638    69.219     0.200
     4.672    67.879     0.200
     4.952    72.779     0.200
     5.113    75.379     0.200
     4.971    74.339     0.200
     5.085    75.989     0.200
     5.318    76.153     0.200
     5.318    76.359     0.200
     5.115    76.219     0.200
     5.149    76.649     0.200
     5.229    77.419     0.200
     5.750    84.939     0.200
     6.144    90.309     0.200
     6.190    90.289     0.200
     6.757    97.369     0.200
     7.313   103.379     0.200
     7.348   105.609     0.200
     8.071   115.419     0.200
     8.159   117.349     0.200
     8.652   124.549     0.200
     8.803   124.879     0.200
     8.948   127.569     0.200
     8.989   127.799     0.200
     8.889   128.249     0.200
     8.951   129.299     0.200
     8.970   128.749     0.200
     9.402   133.639     0.200
     9.619   135.589     0.200
     9.796   138.459     0.200
    10.013   141.609     0.200
    10.044   142.419     0.200
    10.157   143.629     0.200
    10.291   145.949     0.200
    10.397   147.249     0.200
    10.497   147.939     0.200
    10.580   149.099     0.200
    10.526   151.269     0.200
    10.902   153.769     0.200
    10.980   155.579     0.200
    11.000   155.419     0.200
    11.132   157.099     0.200
    11.268   158.939     0.200
    11.591   163.709     0.200
    11.741   166.099     0.200
    11.781   166.189     0.200
    11.964   168.449     0.200
    12.019   169.829     0.200
    12.169   172.119     0.200
    12.357   171.759     0.200
    12.767   179.489     0.200
    12.785   179.499     0.200
    13.049   182.179     0.200
    13.560   189.219     0.200
    14.734   205.469     0.200
    14.888   207.229     0.200
    15.644   219.909     0.200
    16.272   227.519     0.200
     1.173    20.507     0.200
     1.740    29.997     0.200
     1.956    32.708     0.200
     2.389    39.708     0.200
     2.508    41.647     0.200
     2.574    41.948     0.200
     2.881    42.237     0.200
     2.736    44.188     0.200
     2.812    45.208     0.200
     2.912    46.347     0.200
     3.508    53.267     0.200
     3.613    55.857     0.200
     3.651    56.657     0.200
     3.659    55.827     0.200
     3.908    59.468     0.200
     3.957    57.657     0.200
     3.968    60.097     0.200
     4.069    61.747     0.200
     4.123    62.438     0.200
     4.583    67.987     0.200
     4.740    68.737     0.200
     4.997    72.958     0.200
     4.945    73.607     0.200
     4.957    74.747     0.200
     5.086    75.237     0.200
     4.989    74.978     0.200
     5.053    76.097     0.200
     5.383    77.001     0.200
     5.383    77.147     0.200
     6.095    89.867     0.200
     7.072   101.198     0.200
     7.366   104.797     0.200
     7.403   105.127     0.200
     8.127   116.218     0.200
     8.132   115.958     0.200
     8.125   116.757     0.200
     8.694   124.228     0.200
     8.720   125.757     0.200
     8.866   125.557     0.200
     8.794   127.427     0.200
     9.044   128.247     0.200
     8.875   128.037     0.200
     9.077   130.137     0.200
     9.383   133.307     0.200
     9.464   133.978     0.200
     9.490   134.587     0.200
     9.520   134.357     0.200
     9.679   135.347     0.200
     9.708   136.867     0.200
     9.859   139.027     0.200
    10.064   142.497     0.200
    10.114   142.997     0.200
     9.953   142.347     0.200
    10.223   144.208     0.200
    10.011   143.807     0.200
    10.466   148.637     0.200
    10.431   149.448     0.200
    11.048   155.917     0.200
    11.171   157.577     0.200
    11.339   159.867     0.200
    11.477   161.517     0.200
    11.660   164.747     0.200
    11.812   167.147     0.200
    11.969   169.037     0.200
    12.032   169.728     0.200
    12.093   170.527     0.200
    12.216   171.417     0.200
    12.375   175.208     0.200
    12.408   174.097     0.200
    12.394   172.700     0.200
    12.689   177.417     0.200
    12.823   179.938     0.200
    12.841   180.188     0.200
    12.953   183.067     0.200
    13.166   184.877     0.200
    12.952   182.547     0.200
    13.623   191.537     0.200
    13.644   190.517     0.200
    13.833   194.537     0.200
    14.030   196.667     0.200
    14.278   199.337     0.200
    14.435   201.747     0.200
    14.580   203.927     0.200
    14.809   208.647     0.200
    15.159   211.567     0.200
    15.711   217.728     0.200
    15.815   220.218     0.200
    16.470   230.627     0.200
    16.524   229.948     0.200
    17.112   237.688     0.200
    18.692   256.958     0.200
     0.994    17.979     0.200
     0.994    17.659     0.200
     1.577    27.059     0.200
     1.647    28.089     0.200
     1.823    30.969     0.200
     1.843    29.699     0.200
     1.976    30.479     0.200
     2.239    35.639     0.200
     2.406    38.458     0.200
     2.538    39.929     0.200
     2.529    40.259     0.200
     2.699    40.179     0.200
     2.699    39.149     0.200
     2.757    42.939     0.200
     2.857    44.379     0.200
     2.956    45.329     0.200
     2.956    45.549     0.200
     3.325    50.389     0.200
     3.582    53.579     0.200
     3.582    52.819     0.200
     3.678    56.079     0.200
     3.766    55.179     0.200
     3.759    56.559     0.200
     3.702    55.429     0.200
     3.731    55.729     0.200
     3.755    56.559     0.200
     3.870    58.208     0.200
     4.056    59.879     0.200
     4.352    64.589     0.200
     4.318    63.919     0.200
     4.467    65.749     0.200
     4.541    65.439     0.200
     4.529    67.119     0.200
     4.619    68.169     0.200
     4.669    68.989     0.200
     4.722    70.039     0.200
     4.875    72.249     0.200
     4.939    72.239     0.200
     4.974    72.609     0.200
     5.063    73.589     0.200
     5.056    73.689     0.200
     5.085    74.229     0.200
     5.178    74.273     0.200
     5.178    73.329     0.200
     5.178    74.589     0.200
     5.116    74.999     0.200
     5.503    80.379     0.200
     5.573    80.699     0.200
     5.577    81.019     0.200
     5.721    84.409     0.200
     5.923    84.929     0.200
     5.962    86.349     0.200
     6.205    89.239     0.200
     6.267    91.589     0.200
     6.280    91.129     0.200
     6.291    90.579     0.200
     6.433    93.779     0.200
     6.570    93.739     0.200
     6.554    95.109     0.200
     6.540    95.579     0.200
     6.540    94.729     0.200
     6.585    95.919     0.200
     6.804    97.929     0.200
     6.853    97.458     0.200
     6.946   100.669     0.200
     7.071   101.639     0.200
     7.055   100.969     0.200
     7.075   102.099     0.200
     7.167   102.909     0.200
     7.265   103.879     0.200
     7.724   110.529     0.200
     7.807   112.129     0.200
     7.837   112.439     0.200
     7.910   111.449     0.200
     7.908   113.669     0.200
     7.931   113.299     0.200
     7.961   113.689     0.200
     7.930   113.779     0.200
     8.065   114.279     0.200
     8.140   115.999     0.200
     8.197   118.149     0.200
     8.304   118.599     0.200
     8.496   119.559     0.200
     8.546   122.299     0.200
     8.586   123.239     0.200
     8.658   121.469     0.200
     8.668   123.049     0.200
     8.819   124.259     0.200
     8.825   123.099     0.200
     8.856   126.619     0.200
     8.893   126.539     0.200
     8.962   127.059     0.200
     8.975   127.279     0.200
     9.065   128.579     0.200
     9.161   128.958     0.200
     9.153   130.029     0.200
     9.264   129.349     0.200
     9.303   133.269     0.200
     9.355   131.789     0.200
     9.468   131.049     0.200
     9.484   132.349     0.200
     9.651   135.279     0.200
     9.651   134.339     0.200
     9.777   138.759     0.200
     9.790   139.169     0.200
     9.916   139.379     0.200
     9.970   139.389     0.200
    10.269   145.289     0.200
    10.447   146.789     0.200
    10.549   146.579     0.200
    10.526   148.179     0.200
    10.526   147.829     0.200
    10.526   149.939     0.200
    10.791   150.079     0.200
    10.807   151.479     0.200
    10.989   154.519     0.200
    11.611   160.399     0.200
    11.839   165.649     0.200
    11.915   168.129     0.200
    12.000   167.829     0.200
    12.183   170.579     0.200
    12.163   167.579     0.200
    12.163   166.589     0.200
    12.302   169.958     0.200
    12.455   175.489     0.200
    12.624   176.599     0.200
    13.040   181.229     0.200
    13.933   192.779     0.200
    14.075   195.458     0.200
    14.271   199.379     0.200
    14.347   199.019     0.200
    14.490   202.679     0.200
    14.623   205.458     0.200
    15.630   217.473     0.200
    16.202   225.849     0.200
    16.792   232.104     0.200
    16.823   231.039     0.200
    16.844   231.719     0.200
     1.229    21.517     0.200
     1.806    30.677     0.200
     1.953    32.377     0.200
     2.046    33.807     0.200
     2.021    34.037     0.200
     2.229    35.587     0.200
     2.497    39.397     0.200
     2.451    40.787     0.200
     2.569    42.357     0.200
     2.861    42.827     0.200
     2.635    42.887     0.200
     2.798    44.997     0.200
     2.870    46.167     0.200
     3.561    55.337     0.200
     3.667    56.687     0.200
     3.941    57.887     0.200
     3.919    59.177     0.200
     3.713    57.887     0.200
     4.019    60.897     0.200
     4.121    62.097     0.200
     4.175    63.337     0.200
     4.244    64.817     0.200
     4.595    68.037     0.200
     4.703    68.417     0.200
     4.727    68.937     0.200
     4.766    70.427     0.200
     5.003    72.917     0.200
     4.986    73.827     0.200
     5.133    76.227     0.200
     5.005    75.707     0.200
     5.373    77.206     0.200
     5.373    77.447     0.200
     5.802    84.997     0.200
     5.834    86.287     0.200
     6.174    90.297     0.200
     6.140    91.067     0.200
     7.071   101.487     0.200
     7.402   105.777     0.200
     8.124   114.607     0.200
     8.134   114.987     0.200
     8.724   124.257     0.200
     8.857   125.797     0.200
     9.043   127.167     0.200
     9.385   133.797     0.200
     9.456   134.327     0.200
     9.495   135.147     0.200
     9.516   134.537     0.200
     9.674   136.517     0.200
     9.712   138.017     0.200
     9.850   139.677     0.200
    10.066   142.897     0.200
    10.099   143.137     0.200
    10.212   144.557     0.200
    10.345   146.437     0.200
    10.551   149.277     0.200
    11.055   156.547     0.200
    11.492   162.137     0.200
    11.480   162.207     0.200
    11.646   164.247     0.200
    11.796   166.347     0.200
    11.976   168.967     0.200
    12.019   169.487     0.200
    12.075   170.197     0.200
    12.221   171.787     0.200
    12.360   173.957     0.200
    12.406   172.187     0.200
    12.698   178.177     0.200
    12.935   181.897     0.200
    13.143   184.317     0.200
    13.614   190.817     0.200
    13.824   193.407     0.200
    14.790   207.267     0.200
    15.689   219.277     0.200
    15.692   219.097     0.200
    15.929   222.077     0.200
    16.015   223.597     0.200
    16.550   230.797     0.200
    16.989   235.297     0.200
    17.043   235.507     0.200
    17.075   235.147     0.200
     1.105    19.199     0.200
     1.947    31.370     0.200
     2.053    32.500     0.200
     2.321    36.310     0.200
     2.617    41.169     0.200
     2.713    40.390     0.200
     2.713    40.089     0.200
     3.626    53.089     0.200
     3.743    56.640     0.200
     3.787    55.089     0.200
     3.777    56.040     0.200
     3.829    57.750     0.200
     4.094    59.399     0.200
     4.325    63.779     0.200
     4.419    65.430     0.200
     4.470    66.009     0.200
     4.528    66.830     0.200
     4.569    65.729     0.200
     4.591    67.810     0.200
     4.679    69.219     0.200
     4.759    70.319     0.200
     4.829    70.399     0.200
     4.822    71.229     0.200
     4.988    73.120     0.200
     4.997    73.209     0.200
     5.142    75.469     0.200
     5.211    74.633     0.200
     5.211    74.310     0.200
     5.211    75.250     0.200
     5.268    75.209     0.200
     5.304    77.359     0.200
     5.577    81.199     0.200
     5.589    81.020     0.200
     5.629    81.549     0.200
     5.684    82.859     0.200
     5.822    85.600     0.200
     5.997    87.029     0.200
     6.021    88.479     0.200
     6.139    89.149     0.200
     6.321    89.890     0.200
     6.311    91.629     0.200
     6.371    93.339     0.200
     6.633    95.649     0.200
     6.632    94.949     0.200
     6.631    96.989     0.200
     6.682    96.580     0.200
     6.864    98.899     0.200
     7.021   101.290     0.200
     7.098   101.209     0.200
     7.135   102.350     0.200
     7.146   102.649     0.200
     7.196   102.600     0.200
     7.232   102.149     0.200
     7.328   105.120     0.200
     7.398   105.890     0.200
     7.419   106.569     0.200
     7.819   111.439     0.200
     7.866   113.000     0.200
     7.875   113.439     0.200
     7.911   113.770     0.200
     7.919   113.770     0.200
     7.929   112.469     0.200
     7.956   112.410     0.200
     7.962   113.129     0.200
     8.030   114.319     0.200
     8.021   114.890     0.200
     8.041   115.609     0.200
     8.116   115.279     0.200
     8.253   118.209     0.200
     8.272   118.310     0.200
     8.400   119.449     0.200
     8.551   121.250     0.200
     8.666   123.390     0.200
     8.736   124.479     0.200
     8.847   125.100     0.200
     8.873   125.109     0.200
     8.958   127.520     0.200
     9.008   126.689     0.200
     9.060   128.410     0.200
     9.121   129.890     0.200
     9.121   129.080     0.200
     9.214   130.129     0.200
     9.321   131.580     0.200
     9.349   131.299     0.200
     9.379   133.600     0.200
     9.508   133.049     0.200
     9.539   134.969     0.200
     9.687   136.189     0.200
     9.687   136.049     0.200
     9.730   137.239     0.200
     9.867   139.009     0.200
     9.894   138.890     0.200
     9.943   140.000     0.200
    10.012   140.040     0.200
    10.052   141.379     0.200
    10.562   148.089     0.200
    10.562   148.199     0.200
    10.844   151.680     0.200
    11.146   157.439     0.200
    12.003   169.589     0.200
    12.070   167.089     0.200
    12.198   171.189     0.200
    12.230   168.489     0.200
    12.230   168.629     0.200
    12.670   176.959     0.200
    13.080   180.660     0.200
    13.485   187.250     0.200
    13.661   191.080     0.200
    13.859   193.160     0.200
    13.923   192.689     0.200
    14.490   202.589     0.200
    15.235   212.290     0.200
    15.686   215.633     0.200
    15.686   218.419     0.200
     1.827    30.486     0.200
     2.129    33.656     0.200
     2.296    38.605     0.200
     2.484    39.746     0.200
     2.645    42.046     0.200
     2.731    42.646     0.200
     2.873    42.756     0.200
     2.873    42.355     0.200
     3.441    52.855     0.200
     3.546    54.506     0.200
     3.592    54.806     0.200
     3.909    58.546     0.200
     3.941    57.756     0.200
     3.941    56.926     0.200
     4.009    59.776     0.200
     4.062    61.446     0.200
     4.572    67.276     0.200
     4.632    68.266     0.200
     4.695    69.216     0.200
     4.716    68.176     0.200
     4.805    71.105     0.200
     4.894    73.696     0.200
     4.937    72.256     0.200
     5.084    75.585     0.200
     5.088    74.976     0.200
     5.213    75.696     0.200
     5.353    76.625     0.200
     5.353    76.835     0.200
     5.344    78.546     0.200
     5.644    81.976     0.200
     5.663    82.116     0.200
     5.741    83.206     0.200
     6.078    87.726     0.200
     6.137    87.826     0.200
     6.359    91.776     0.200
     6.591    94.936     0.200
     6.734    96.656     0.200
     6.798    97.946     0.200
     7.025   100.116     0.200
     7.185   102.696     0.200
     7.318   103.426     0.200
     7.357   104.416     0.200
     8.083   115.416     0.200
     8.080   116.466     0.200
     8.630   123.116     0.200
     8.665   123.875     0.200
     8.832   125.375     0.200
     8.961   127.136     0.200
     8.997   126.906     0.200
     9.232   130.956     0.200
     9.283   131.576     0.200
     9.330   132.605     0.200
     9.429   133.646     0.200
     9.432   134.105     0.200
     9.478   133.315     0.200
     9.641   135.196     0.200
     9.652   136.085     0.200
     9.826   138.855     0.200
     9.826   138.476     0.200
     9.846   139.596     0.200
     9.942   141.396     0.200
    10.092   142.266     0.200
    10.304   144.105     0.200
    10.404   147.256     0.200
    10.525   147.335     0.200
    11.104   155.946     0.200
    11.422   160.146     0.200
    12.323   170.906     0.200
    12.357   174.056     0.200
    12.778   179.436     0.200
    12.895   181.146     0.200
    14.099   195.556     0.200
    14.661   205.456     0.200
    14.878   207.396     0.200
    16.238   225.346     0.200
    16.249   226.526     0.200
    16.345   226.466     0.200
    16.408   228.186     0.200
    16.962   235.306     0.200
    16.979   235.286     0.200
    16.994   234.105     0.200
    17.010   236.076     0.200
    17.525   241.686     0.200
     1.094    19.394     0.200
     1.715    29.084     0.200
     1.692    29.464     0.200
     1.836    30.204     0.200
     1.901    31.564     0.200
     2.381    38.204     0.200
     2.384    38.814     0.200
     2.505    40.804     0.200
     2.680    42.084     0.200
     2.573    41.184     0.200
     2.813    41.914     0.200
     2.733    43.554     0.200
     2.819    44.594     0.200
     2.919    45.734     0.200
     3.527    54.024     0.200
     3.632    55.594     0.200
     3.819    58.054     0.200
     3.678    56.454     0.200
     3.886    57.414     0.200
     3.900    59.194     0.200
     4.011    59.984     0.200
     4.093    61.144     0.200
     4.219    63.144     0.200
     4.492    66.544     0.200
     4.547    67.074     0.200
     4.606    67.754     0.200
     4.665    67.634     0.200
     4.669    69.174     0.200
     4.758    70.074     0.200
     4.809    70.744     0.200
     5.064    74.374     0.200
     4.906    72.854     0.200
     5.077    74.494     0.200
     4.987    74.144     0.200
     5.048    75.394     0.200
     5.205    76.284     0.200
     5.305    76.343     0.200
     5.166    76.244     0.200
     5.647    81.924     0.200
     5.644    82.134     0.200
     5.711    83.014     0.200
     6.065    87.864     0.200
     6.179    90.254     0.200
     6.130    89.764     0.200
     6.709    96.624     0.200
     6.720    97.514     0.200
     6.842    98.444     0.200
     6.943    99.924     0.200
     6.988    99.744     0.200
     7.193   103.834     0.200
     7.320   103.644     0.200
     8.044   114.204     0.200
     8.046   115.444     0.200
     8.605   123.424     0.200
     8.634   122.294     0.200
     8.787   124.434     0.200
     8.943   127.334     0.200
     8.775   126.174     0.200
     8.960   125.934     0.200
     8.825   126.864     0.200
     8.869   128.344     0.200
     8.906   127.284     0.200
     9.297   131.214     0.200
     9.385   131.534     0.200
     9.403   132.084     0.200
     9.599   133.694     0.200
     9.621   135.194     0.200
     9.780   137.534     0.200
     9.814   138.974     0.200
     9.979   140.234     0.200
    10.224   144.414     0.200
    10.040   142.774     0.200
    10.265   144.674     0.200
    10.088   143.654     0.200
    11.391   160.274     0.200
    11.880   167.284     0.200
    12.023   168.954     0.200
    12.301   172.684     0.200
    12.304   170.124     0.200
    12.304   171.184     0.200
    12.884   180.724     0.200
    13.100   183.294     0.200
    14.210   198.604     0.200
    14.740   205.014     0.200
    14.794   207.224     0.200
    14.848   206.624     0.200
    15.336   212.674     0.200
    15.612   216.734     0.200
    15.836   220.704     0.200
    15.930   222.384     0.200
    16.382   227.174     0.200
    16.459   229.004     0.200
    16.928   234.014     0.200
    16.959   232.424     0.200
    16.982   233.354     0.200
    17.499   240.654     0.200
     1.753    29.984     0.200
     1.970    31.774     0.200
     2.228    35.834     0.200
     2.228    36.464     0.200
     2.314    37.754     0.200
     2.437    39.714     0.200
     2.461    38.544     0.200
     2.530    40.444     0.200
     2.665    42.374     0.200
     2.752    41.015     0.200
     2.752    41.185     0.200
     2.768    43.964     0.200
     2.867    45.004     0.200
     3.317    51.174     0.200
     3.498    53.214     0.200
     3.498    53.354     0.200
     3.617    55.034     0.200
     3.647    55.074     0.200
     3.672    55.935     0.200
     3.686    56.454     0.200
     3.761    56.964     0.200
     3.812    55.914     0.200
     3.812    55.714     0.200
     3.975    59.414     0.200
     4.237    63.305     0.200
     4.356    64.685     0.200
     4.539    67.874     0.200
     4.581    66.294     0.200
     4.630    68.734     0.200
     4.646    68.984     0.200
     4.680    69.414     0.200
     4.821    70.904     0.200
     4.896    72.404     0.200
     4.952    72.614     0.200
     5.006    73.994     0.200
     5.054    74.265     0.200
     5.160    75.895     0.200
     5.186    76.734     0.200
     5.214    74.733     0.200
     5.214    75.114     0.200
     5.214    75.704     0.200
     5.485    80.364     0.200
     5.505    80.604     0.200
     5.522    81.475     0.200
     5.588    80.954     0.200
     5.677    84.024     0.200
     5.919    86.604     0.200
     5.974    86.734     0.200
     6.009    87.845     0.200
     6.215    90.174     0.200
     6.200    89.935     0.200
     6.217    91.084     0.200
     6.433    92.334     0.200
     6.445    94.814     0.200
     6.445    94.274     0.200
     6.540    94.564     0.200
     6.549    94.794     0.200
     6.578    95.095     0.200
     6.814    98.845     0.200
     6.821    99.015     0.200
     6.876    99.515     0.200
     6.940   100.854     0.200
     7.018   100.845     0.200
     7.028   101.765     0.200
     7.040   101.034     0.200
     7.169   101.314     0.200
     7.209   102.164     0.200
     7.243   103.734     0.200
     7.273   104.824     0.200
     7.691   110.654     0.200
     7.846   113.475     0.200
     7.859   113.444     0.200
     7.866   113.685     0.200
     7.907   113.414     0.200
     7.928   111.904     0.200
     7.935   111.664     0.200
     8.125   117.475     0.200
     8.190   117.435     0.200
     8.193   118.015     0.200
     8.271   118.424     0.200
     8.474   120.284     0.200
     8.488   121.624     0.200
     8.512   120.685     0.200
     8.575   123.305     0.200
     8.670   123.924     0.200
     8.690   122.384     0.200
     8.812   126.274     0.200
     8.848   124.084     0.200
     8.857   126.964     0.200
     8.860   125.044     0.200
     8.897   126.714     0.200
     8.924   126.395     0.200
     9.079   128.814     0.200
     9.125   130.624     0.200
     9.179   129.044     0.200
     9.278   130.774     0.200
     9.298   134.284     0.200
     9.331   130.345     0.200
     9.356   134.244     0.200
     9.418   134.714     0.200
     9.497   132.645     0.200
     9.499   133.074     0.200
     9.683   136.015     0.200
     9.683   135.784     0.200
     9.753   138.914     0.200
     9.783   139.274     0.200
     9.861   138.824     0.200
     9.956   140.954     0.200
     9.999   141.074     0.200
    10.026   142.034     0.200
    10.446   147.515     0.200
    10.446   148.074     0.200
    10.467   149.044     0.200
    10.704   152.784     0.200
    10.727   151.154     0.200
    10.960   154.904     0.200
    10.996   154.975     0.200
    10.992   155.954     0.200
    11.181   157.944     0.200
    11.484   163.234     0.200
    11.893   168.314     0.200
    11.999   168.834     0.200
    12.165   168.464     0.200
    12.165   168.924     0.200
    12.232   171.814     0.200
    12.648   176.435     0.200
    12.958   180.604     0.200
    13.111   182.504     0.200
    13.999   194.114     0.200
    14.551   204.214     0.200
    14.670   204.754     0.200
    14.856   207.314     0.200
    15.541   215.333     0.200
    15.541   216.004     0.200
    18.474   253.944     0.200
     1.136    20.170     0.200
     1.750    29.850     0.200
     1.730    29.670     0.200
     1.870    31.210     0.200
     1.941    32.279     0.200
     2.005    33.590     0.200
     2.147    34.029     0.200
     2.412    37.619     0.200
     2.411    38.999     0.200
     2.530    40.880     0.200
     2.598    41.260     0.200
     2.710    42.630     0.200
     2.820    41.880     0.200
     2.759    43.579     0.200
     2.759    43.869     0.200
     2.841    44.670     0.200
     2.941    45.850     0.200
     3.497    52.960     0.200
     3.544    53.880     0.200
     3.668    55.649     0.200
     3.688    55.939     0.200
     3.696    56.100     0.200
     3.719    56.510     0.200
     3.844    57.840     0.200
     3.895    56.979     0.200
     3.927    59.029     0.200
     4.040    60.680     0.200
     4.008    59.579     0.200
     4.507    66.430     0.200
     4.518    66.999     0.200
     4.571    67.760     0.200
     4.617    68.119     0.200
     4.630    68.460     0.200
     4.677    67.720     0.200
     4.693    69.510     0.200
     4.781    70.420     0.200
     4.843    71.479     0.200
     4.932    71.859     0.200
     4.892    72.470     0.200
     4.918    72.680     0.200
     5.054    74.069     0.200
     5.000    73.670     0.200
     5.089    74.460     0.200
     5.100    74.689     0.200
     5.038    74.760     0.200
     5.031    74.079     0.200
     5.061    74.729     0.200
     5.178    75.739     0.200
     5.235    76.840     0.200
     5.319    76.148     0.200
     5.319    76.499     0.200
     5.386    78.880     0.200
     5.675    82.749     0.200
     5.677    82.640     0.200
     5.733    83.369     0.200
     5.739    83.510     0.200
     5.890    86.590     0.200
     6.093    88.460     0.200
     6.229    90.840     0.200
     6.396    92.340     0.200
     6.435    93.829     0.200
     6.434    94.399     0.200
     6.602    95.199     0.200
     6.595    96.800     0.200
     6.735    97.170     0.200
     6.734    97.239     0.200
     6.798    98.170     0.200
     6.757    98.069     0.200
     6.967   100.399     0.200
     7.007   100.430     0.200
     7.117   103.329     0.200
     7.198   103.619     0.200
     7.228   104.090     0.200
     7.301   103.329     0.200
     7.338   103.829     0.200
     7.430   106.800     0.200
     7.459   107.079     0.200
     7.507   108.079     0.200
     7.896   112.920     0.200
     7.965   114.409     0.200
     8.062   115.399     0.200
     8.067   114.029     0.200
     8.130   116.420     0.200
     8.105   115.770     0.200
     8.133   116.890     0.200
     8.084   115.880     0.200
     8.221   117.670     0.200
     8.313   119.439     0.200
     8.353   119.680     0.200
     8.477   121.159     0.200
     8.629   122.850     0.200
     8.655   123.649     0.200
     8.706   124.909     0.200
     8.802   124.999     0.200
     8.758   125.619     0.200
     8.954   126.670     0.200
     8.882   127.319     0.200
     8.979   125.869     0.200
     8.918   127.180     0.200
     8.918   127.369     0.200
     9.225   130.680     0.200
     9.225   130.239     0.200
     9.318   132.029     0.200
     9.400   133.100     0.200
     9.425   132.579     0.200
     9.455   131.760     0.200
     9.615   134.390     0.200
     9.643   135.260     0.200
     9.795   138.180     0.200
     9.795   138.069     0.200
     9.835   138.560     0.200
    10.051   142.300     0.200
    10.119   143.140     0.200
    10.160   143.609     0.200
    10.403   147.069     0.200
    10.473   148.380     0.200
    10.473   147.930     0.200
    10.755   152.109     0.200
    12.305   172.880     0.200
    12.330   170.467     0.200
    12.330   171.140     0.200
    12.776   179.569     0.200
    12.993   181.520     0.200
    14.024   194.779     0.200
    14.594   204.680     0.200
    14.870   206.119     0.200
    15.332   213.479     0.200
     1.544    26.903     0.200
     1.569    27.764     0.200
     1.731    29.894     0.200
     1.785    30.894     0.200
     1.766    30.033     0.200
     1.961    32.703     0.200
     2.220    36.644     0.200
     2.334    39.613     0.200
     2.550    42.184     0.200
     2.528    41.843     0.200
     2.685    44.413     0.200
     2.788    45.474     0.200
     2.887    46.993     0.200
     3.674    57.073     0.200
     3.518    55.854     0.200
     3.621    56.383     0.200
     3.856    59.503     0.200
     3.667    58.264     0.200
     3.995    62.644     0.200
     4.144    63.363     0.200
     4.404    65.934     0.200
     4.456    66.423     0.200
     4.465    67.033     0.200
     4.527    67.693     0.200
     4.640    70.323     0.200
     4.679    69.833     0.200
     5.045    75.713     0.200
     5.181    76.233     0.200
     5.198    75.442     0.200
     5.198    76.843     0.200
     5.575    82.693     0.200
     6.006    87.913     0.200
     6.194    90.684     0.200
     6.220    91.383     0.200
     6.546    96.573     0.200
     6.931   102.533     0.200
     7.023   102.953     0.200
     7.020   102.123     0.200
     7.243   104.264     0.200
     7.687   110.703     0.200
     7.870   113.583     0.200
     7.901   113.483     0.200
     8.118   118.304     0.200
     8.811   126.033     0.200
    10.142   144.403     0.200
    12.154   168.464     0.200
    12.154   171.163     0.200
    14.673   205.543     0.200
    14.711   206.083     0.200
    14.725   208.163     0.200
    15.202   214.953     0.200
    15.488   219.054     0.200
    15.802   222.963     0.200
    16.843   235.283     0.200
    16.826   235.593     0.200
    17.142   239.243     0.200
     1.604    27.629     0.200
     1.558    27.560     0.200
     1.747    29.390     0.200
     1.894    30.779     0.200
     2.153    34.709     0.200
     2.386    38.249     0.200
     2.454    39.359     0.200
     2.354    38.560     0.200
     2.478    40.689     0.200
     2.677    41.029     0.200
     2.677    41.310     0.200
     2.706    43.119     0.200
     2.816    45.220     0.200
     2.816    45.589     0.200
     2.914    46.399     0.200
     2.914    46.749     0.200
     3.241    49.369     0.200
     3.607    55.020     0.200
     3.683    55.970     0.200
     3.683    56.369     0.200
     3.553    55.329     0.200
     3.736    55.629     0.200
     3.736    55.779     0.200
     3.789    57.470     0.200
     3.655    55.869     0.200
     3.701    57.260     0.200
     4.032    60.629     0.200
     4.032    60.829     0.200
     4.129    62.299     0.200
     4.277    63.600     0.200
     4.180    62.949     0.200
     4.337    64.799     0.200
     4.398    65.589     0.200
     4.258    64.149     0.200
     4.460    65.760     0.200
     4.503    66.020     0.200
     4.551    67.680     0.200
     4.575    68.029     0.200
     4.618    69.399     0.200
     4.768    70.999     0.200
     4.853    71.680     0.200
     4.978    73.799     0.200
     5.117    75.549     0.200
     5.135    74.224     0.200
     5.135    73.930     0.200
     5.039    75.089     0.200
     5.065    75.609     0.200
     5.097    76.020     0.200
     5.412    79.339     0.200
     5.427    79.720     0.200
     5.470    80.129     0.200
     5.508    80.310     0.200
     5.617    83.069     0.200
     5.842    85.529     0.200
     5.895    86.129     0.200
     5.943    87.310     0.200
     6.129    89.379     0.200
     6.162    90.390     0.200
     6.171    90.890     0.200
     6.192    90.899     0.200
     6.355    92.220     0.200
     6.466    94.249     0.200
     6.499    93.600     0.200
     6.484    94.669     0.200
     6.460    95.229     0.200
     6.460    94.989     0.200
     6.735    97.560     0.200
     6.796    97.499     0.200
     6.864    99.579     0.200
     6.961   100.339     0.200
     6.958   100.680     0.200
     6.998   101.379     0.200
     7.089   100.640     0.200
     7.129   101.249     0.200
     7.194   103.869     0.200
     7.187   102.869     0.200
     7.244   104.129     0.200
     7.624   109.350     0.200
     7.768   111.839     0.200
     7.772   111.819     0.200
     7.789   112.199     0.200
     7.802   113.169     0.200
     7.848   111.369     0.200
     7.837   112.359     0.200
     7.855   111.619     0.200
     7.875   113.419     0.200
     7.889   112.589     0.200
     8.052   115.069     0.200
     8.111   115.760     0.200
     8.205   117.100     0.200
     8.395   119.399     0.200
     8.438   120.649     0.200
     8.500   121.899     0.200
     8.592   122.220     0.200
     8.611   122.189     0.200
     8.768   123.109     0.200
     8.752   124.369     0.200
     8.782   124.520     0.200
     8.860   125.879     0.200
     8.999   127.430     0.200
     8.874   127.999     0.200
     9.056   128.260     0.200
     9.099   128.199     0.200
     8.956   128.329     0.200
     8.956   127.810     0.200
     9.198   129.010     0.200
     9.207   129.339     0.200
     9.417   131.659     0.200
     9.419   132.539     0.200
     9.604   135.329     0.200
     9.604   135.069     0.200
     9.683   137.069     0.200
     9.707   137.979     0.200
     9.781   138.039     0.200
    10.077   141.339     0.200
    10.401   148.229     0.200
    10.504   149.629     0.200
    10.504   149.520     0.200
    10.785   153.379     0.200
    11.582   163.430     0.200
    11.604   163.499     0.200
    11.822   166.659     0.200
    11.872   167.459     0.200
    11.922   169.029     0.200
    12.087   167.329     0.200
    12.156   171.729     0.200
    12.568   175.489     0.200
    13.014   182.859     0.200
    13.495   188.379     0.200
    13.930   194.529     0.200
    14.479   203.829     0.200
    15.039   208.289     0.200
    16.763   231.339     0.200
    16.767   231.939     0.200
    16.776   230.470     0.200
    16.790   232.600     0.200
    16.907   234.609     0.200
    17.185   236.600     0.200
     0.905    16.750     0.200
     1.568    27.640     0.200
     1.759    30.070     0.200
     1.918    31.300     0.200
     2.178    35.220     0.200
     2.507    40.780     0.200
     2.353    38.910     0.200
     2.476    40.520     0.200
     2.694    41.650     0.200
     2.694    41.510     0.200
     2.548    41.390     0.200
     2.704    43.460     0.200
     2.811    45.310     0.200
     2.910    46.380     0.200
     3.630    55.700     0.200
     3.707    56.390     0.200
     3.754    56.450     0.200
     3.754    56.290     0.200
     3.546    55.350     0.200
     3.813    57.790     0.200
     3.648    56.140     0.200
     4.024    61.050     0.200
     4.024    61.180     0.200
     4.301    64.110     0.200
     4.301    64.250     0.200
     4.121    62.570     0.200
     4.360    65.280     0.200
     4.172    63.030     0.200
     4.421    66.050     0.200
     4.250    64.160     0.200
     4.484    67.120     0.200
     4.522    66.070     0.200
     4.574    67.970     0.200
     4.727    69.630     0.200
     4.848    71.540     0.200
     4.791    71.330     0.200
     4.877    71.840     0.200
     5.003    74.500     0.200
     5.155    74.319     0.200
     5.155    74.610     0.200
     5.141    76.190     0.200
     5.029    75.570     0.200
     5.452    80.190     0.200
     5.437    79.990     0.200
     5.531    80.740     0.200
     5.492    80.190     0.200
     5.641    83.630     0.200
     5.866    85.590     0.200
     5.918    86.280     0.200
     5.968    87.380     0.200
     6.154    89.170     0.200
     6.186    90.080     0.200
     6.193    90.350     0.200
     6.491    95.430     0.200
     6.522    93.950     0.200
     6.524    94.780     0.200
     6.508    94.200     0.200
     6.467    95.650     0.200
     6.467    95.460     0.200
     6.758    98.030     0.200
     6.818    97.590     0.200
     6.888    99.380     0.200
     6.985   100.330     0.200
     6.983   100.410     0.200
     6.989   101.320     0.200
     7.151   101.620     0.200
     7.210   103.640     0.200
     7.269   104.760     0.200
     7.649   109.890     0.200
     7.871   111.250     0.200
     7.877   111.340     0.200
     7.861   113.230     0.200
     7.900   113.090     0.200
     7.843   112.350     0.200
     8.076   115.450     0.200
     8.229   117.900     0.200
     8.419   119.800     0.200
     8.525   121.530     0.200
     8.632   122.790     0.200
     8.616   122.790     0.200
     8.790   123.420     0.200
     8.776   125.730     0.200
     9.022   129.650     0.200
     9.081   130.410     0.200
     9.122   128.860     0.200
     9.228   130.300     0.200
     9.222   129.120     0.200
     9.307   132.750     0.200
     9.438   132.320     0.200
     9.382   134.300     0.200
     9.442   133.450     0.200
     9.625   136.050     0.200
     9.625   135.580     0.200
     9.707   138.380     0.200
     9.731   138.790     0.200
     9.803   138.850     0.200
    10.099   141.820     0.200
    10.673   150.110     0.200
    11.138   157.270     0.200
    11.213   156.980     0.200
    11.441   160.300     0.200
    11.696   163.980     0.200
    11.753   164.590     0.200
    11.947   167.060     0.200
    12.111   168.330     0.200
    12.111   165.912     0.200
    12.111   169.390     0.200
    12.161   169.720     0.200
    12.411   172.070     0.200
    12.694   179.210     0.200
    12.979   181.490     0.200
    13.007   181.020     0.200
    13.600   189.680     0.200
    14.494   204.550     0.200
    14.630   204.990     0.200
    14.668   205.400     0.200
    14.681   205.220     0.200
    15.159   212.580     0.200
    15.444   216.610     0.200
    15.523   216.260     0.200
    15.654   217.450     0.200
    15.758   219.870     0.200
    16.197   224.860     0.200
    16.279   227.520     0.200
    16.786   232.620     0.200
    16.800   233.400     0.200
    17.314   238.860     0.200
     1.163    20.680     0.200
     1.778    29.460     0.200
     1.751    30.110     0.200
     1.897    31.680     0.200
     1.964    32.070     0.200
     2.172    34.330     0.200
     2.421    39.520     0.200
     2.540    41.410     0.200
     2.607    41.710     0.200
     2.833    42.310     0.200
     2.833    42.170     0.200
     2.769    44.110     0.200
     2.848    45.190     0.200
     2.948    46.450     0.200
     3.547    54.310     0.200
     3.547    53.910     0.200
     3.653    55.900     0.200
     3.699    55.810     0.200
     3.722    57.390     0.200
     3.867    58.460     0.200
     3.910    57.610     0.200
     3.910    56.400     0.200
     4.010    60.210     0.200
     4.110    61.200     0.200
     4.164    62.330     0.200
     4.235    63.600     0.200
     4.450    66.060     0.200
     4.542    67.390     0.200
     4.594    68.000     0.200
     4.653    68.440     0.200
     4.693    67.580     0.200
     4.716    70.010     0.200
     4.803    70.630     0.200
     4.954    72.500     0.200
     4.920    72.370     0.200
     5.077    74.410     0.200
     5.112    74.880     0.200
     5.066    74.970     0.200
     4.999    74.430     0.200
     5.061    75.270     0.200
     5.336    76.729     0.200
     5.336    76.500     0.200
     5.177    76.380     0.200
     5.754    83.120     0.200
     6.118    89.410     0.200
     6.139    89.890     0.200
     6.227    90.680     0.200
     6.757    96.680     0.200
     6.784    98.560     0.200
     7.027   100.640     0.200
     7.358   104.229     0.200
     8.082   113.970     0.200
     8.088   114.740     0.200
     8.677   123.460     0.200
     8.819   124.860     0.200
     8.970   126.729     0.200
     8.837   127.330     0.200
     8.999   126.740     0.200
     8.917   127.910     0.200
     9.247   131.410     0.200
     9.339   131.920     0.200
     9.418   132.680     0.200
     9.447   133.400     0.200
     9.474   132.890     0.200
     9.664   136.110     0.200
     9.813   138.810     0.200
    10.020   141.060     0.200
    10.067   142.440     0.200
     9.996   142.130     0.200
    10.473   149.010     0.200
    12.318   174.110     0.200
    12.354   169.371     0.200
    12.354   172.050     0.200
    14.604   204.710     0.200
    15.054   209.100     0.200
    15.112   210.520     0.200
    15.277   212.010     0.200
    15.310   212.890     0.200
    15.332   214.390     0.200
    15.368   212.320     0.200
    15.441   214.540     0.200
     1.154    21.376     0.200
     1.734    29.886     0.200
     1.983    33.686     0.200
     1.983    34.275     0.200
     2.116    34.815     0.200
     2.384    38.516     0.200
     2.384    39.256     0.200
     2.760    43.176     0.200
     2.760    42.136     0.200
     3.804    59.105     0.200
     3.836    58.076     0.200
     3.836    57.866     0.200
     3.891    59.695     0.200
     4.006    61.235     0.200
     4.480    67.546     0.200
     4.621    68.166     0.200
     4.652    70.216     0.200
     4.739    71.025     0.200
     5.012    74.186     0.200
     5.205    77.366     0.200
     5.264    77.245     0.200
     5.264    76.976     0.200
     5.367    79.386     0.200
     5.639    83.326     0.200
     5.688    84.186     0.200
     5.742    84.936     0.200
     6.060    88.966     0.200
     6.080    89.275     0.200
     6.097    89.626     0.200
     6.296    91.525     0.200
     6.374    92.806     0.200
     6.566    95.766     0.200
     6.649    98.275     0.200
     6.911    99.836     0.200
     6.924   100.246     0.200
     6.958   100.766     0.200
     7.253   103.676     0.200
     7.389   106.716     0.200
     7.937   114.806     0.200
     7.965   114.996     0.200
     7.972   115.496     0.200
     7.981   115.626     0.200
     8.012   114.815     0.200
     8.021   116.076     0.200
     8.104   116.916     0.200
     8.334   119.916     0.200
     8.588   122.516     0.200
     8.610   123.056     0.200
     8.729   125.346     0.200
     8.748   124.866     0.200
     8.798   125.426     0.200
     8.855   126.565     0.200
     8.897   127.266     0.200
     9.122   130.206     0.200
     9.180   131.376     0.200
     9.180   130.876     0.200
     9.180   131.576     0.200
     9.272   132.306     0.200
     9.347   133.016     0.200
     9.381   133.126     0.200
     9.405   133.836     0.200
     9.441   135.386     0.200
     9.441   137.275     0.200
     9.518   136.936     0.200
     9.598   137.006     0.200
     9.741   138.476     0.200
     9.741   137.876     0.200
     9.788   139.485     0.200
     9.809   139.445     0.200
     9.952   141.876     0.200
     9.994   142.266     0.200
    10.541   149.976     0.200
    11.313   159.266     0.200
    11.947   169.976     0.200
    12.014   170.326     0.200
    12.021   167.846     0.200
    12.132   170.476     0.200
    12.132   169.376     0.200
    12.134   171.445     0.200
    12.202   173.105     0.200
    12.292   171.344     0.200
    12.292   171.046     0.200
    12.295   172.766     0.200
    12.313   173.695     0.200
    12.434   174.866     0.200
    12.544   175.485     0.200
    12.583   175.846     0.200
    12.606   178.226     0.200
    12.709   179.336     0.200
    12.727   179.985     0.200
    13.883   195.695     0.200
    13.958   197.176     0.200
    15.265   216.576     0.200
    15.265   216.156     0.200
    15.677   217.770     0.200
    15.677   219.376     0.200
    16.062   224.896     0.200
    16.062   224.855     0.200
    16.062   224.855     0.200
    16.372   229.166     0.200
    16.832   234.476     0.200
    16.931   234.846     0.200
    18.899   260.105     0.200
     1.113    20.075     0.200
     1.672    29.105     0.200
     1.768    29.716     0.200
     1.955    32.825     0.200
     1.888    31.705     0.200
     2.183    34.605     0.200
     2.329    38.285     0.200
     2.515    40.655     0.200
     2.745    43.216     0.200
     2.677    42.945     0.200
     2.894    42.855     0.200
     2.757    44.226     0.200
     2.857    45.205     0.200
     3.458    53.035     0.200
     3.458    53.295     0.200
     3.564    54.775     0.200
     3.610    55.415     0.200
     3.890    58.955     0.200
     3.967    57.936     0.200
     3.922    58.636     0.200
     3.922    58.855     0.200
     4.147    62.615     0.200
     4.563    67.565     0.200
     4.619    68.525     0.200
     4.668    69.016     0.200
     4.679    69.216     0.200
     4.745    68.605     0.200
     4.742    70.266     0.200
     4.831    71.445     0.200
     4.865    72.275     0.200
     4.898    72.516     0.200
     4.983    72.655     0.200
     4.914    73.115     0.200
     4.945    73.556     0.200
     5.031    74.655     0.200
     4.975    74.365     0.200
     5.269    77.795     0.200
     5.385    77.504     0.200
     5.385    77.266     0.200
     5.406    79.625     0.200
     5.703    83.186     0.200
     5.785    84.285     0.200
     5.731    84.846     0.200
     5.894    85.945     0.200
     6.131    89.125     0.200
     6.143    88.936     0.200
     6.420    92.985     0.200
     6.435    93.146     0.200
     6.643    96.245     0.200
     6.782    97.926     0.200
     6.757    98.966     0.200
     6.768    98.155     0.200
     6.846    98.865     0.200
     7.014   101.565     0.200
     7.065   101.455     0.200
     7.247   104.205     0.200
     7.225   104.205     0.200
     7.359   103.705     0.200
     7.397   105.125     0.200
     7.477   107.436     0.200
     7.456   106.665     0.200
     7.535   108.436     0.200
     7.910   113.306     0.200
     8.122   115.995     0.200
     8.122   116.125     0.200
     8.126   116.516     0.200
     8.166   117.195     0.200
     8.343   119.995     0.200
     8.397   120.516     0.200
     8.406   120.235     0.200
     8.490   121.676     0.200
     8.678   124.315     0.200
     8.709   123.985     0.200
     8.791   126.045     0.200
     8.866   125.985     0.200
     8.751   126.146     0.200
     8.832   126.835     0.200
     8.832   126.726     0.200
     9.037   127.455     0.200
     9.027   128.995     0.200
     9.142   129.815     0.200
     9.464   133.896     0.200
     9.477   133.525     0.200
     9.516   134.125     0.200
     9.677   135.266     0.200
     9.696   136.525     0.200
     9.859   139.535     0.200
     9.859   138.835     0.200
     9.859   139.245     0.200
     9.997   142.846     0.200
    10.054   141.995     0.200
     9.910   141.125     0.200
    10.120   143.035     0.200
     9.968   142.625     0.200
    10.181   143.545     0.200
    10.343   145.775     0.200
    10.233   145.556     0.200
    10.387   149.235     0.200
    10.560   148.306     0.200
    11.139   155.815     0.200
    11.201   157.035     0.200
    12.379   174.436     0.200
    12.374   170.985     0.200
    12.374   171.125     0.200
    14.674   205.936     0.200
    14.837   207.655     0.200
    14.923   208.285     0.200
    16.975   235.636     0.200
     1.109    19.844     0.200
     1.747    29.723     0.200
     1.687    29.383     0.200
     1.935    31.742     0.200
     1.900    32.293     0.200
     1.900    31.854     0.200
     2.155    33.402     0.200
     2.155    34.172     0.200
     2.417    37.652     0.200
     2.360    38.594     0.200
     2.480    40.684     0.200
     2.547    40.822     0.200
     2.856    41.812     0.200
     2.708    43.223     0.200
     2.790    44.162     0.200
     3.495    53.844     0.200
     3.495    52.812     0.200
     3.859    58.492     0.200
     3.600    55.152     0.200
     3.928    57.434     0.200
     3.928    56.803     0.200
     3.928    57.572     0.200
     3.646    54.572     0.200
     3.646    54.773     0.200
     3.959    61.732     0.200
     3.959    59.582     0.200
     3.959    59.213     0.200
     4.059    60.902     0.200
     4.113    61.742     0.200
     4.185    63.172     0.200
     4.525    66.643     0.200
     4.532    66.934     0.200
     4.587    67.713     0.200
     4.635    68.133     0.200
     4.647    67.844     0.200
     4.647    68.283     0.200
     4.708    67.703     0.200
     4.708    67.922     0.200
     4.798    70.812     0.200
     4.843    72.303     0.200
     4.882    72.152     0.200
     4.882    72.322     0.200
     4.950    72.014     0.200
     5.072    74.104     0.200
     5.021    74.543     0.200
     5.104    74.943     0.200
     4.952    74.312     0.200
     5.242    76.104     0.200
     5.242    77.463     0.200
     5.348    76.477     0.200
     5.348    75.812     0.200
     5.384    79.992     0.200
     5.679    82.613     0.200
     5.752    84.043     0.200
     5.721    84.652     0.200
     5.879    87.014     0.200
     5.879    87.213     0.200
     6.103    88.643     0.200
     6.210    91.344     0.200
     6.094    88.953     0.200
     6.397    93.184     0.200
     6.397    93.523     0.200
     6.422    93.764     0.200
     6.411    94.232     0.200
     6.614    94.473     0.200
     6.750    96.094     0.200
     6.750    97.172     0.200
     6.750    97.672     0.200
     7.125   102.533     0.200
     7.214   101.822     0.200
     7.216   103.863     0.200
     7.324   102.672     0.200
     7.362   103.953     0.200
     7.445   106.963     0.200
     7.510   108.922     0.200
     8.043   114.594     0.200
     8.086   113.553     0.200
     8.088   115.322     0.200
     8.675   123.434     0.200
     8.829   124.902     0.200
     9.002   127.912     0.200
     8.789   126.854     0.200
     8.870   128.732     0.200
     9.244   131.332     0.200
     9.339   132.492     0.200
     9.427   132.133     0.200
     9.444   133.723     0.200
     9.641   135.264     0.200
     9.663   136.783     0.200
     9.823   138.934     0.200
     9.823   138.393     0.200
    10.020   141.953     0.200
    10.308   145.104     0.200
    10.523   148.883     0.200
    10.425   150.033     0.200
    11.103   155.514     0.200
    11.167   157.582     0.200
    11.432   161.133     0.200
    11.477   162.043     0.200
    11.628   164.283     0.200
    11.782   166.582     0.200
    11.814   166.873     0.200
    11.921   168.523     0.200
    11.961   168.582     0.200
    12.001   169.742     0.200
    12.065   170.533     0.200
    12.169   171.283     0.200
    12.204   172.412     0.200
    12.341   173.434     0.200
    12.344   173.822     0.200
    12.343   170.684     0.200
    12.343   172.572     0.200
    12.926   182.184     0.200
    13.142   184.633     0.200
    13.595   191.344     0.200
    13.797   193.623     0.200
    14.067   196.732     0.200
    14.252   199.523     0.200
    14.463   201.943     0.200
    14.563   203.953     0.200
    14.635   205.533     0.200
    14.783   207.453     0.200
    14.837   208.412     0.200
    14.889   207.123     0.200
    15.654   219.162     0.200
    15.687   219.434     0.200
    15.877   221.643     0.200
    15.972   222.562     0.200
    16.423   229.312     0.200
    16.500   230.082     0.200
    16.936   234.732     0.200
    17.001   234.854     0.200
    17.023   234.123     0.200
    17.540   241.283     0.200
    18.644   254.857     0.200
     1.120    19.898     0.200
     1.740    28.709     0.200
     1.929    32.129     0.200
     1.984    32.889     0.200
     1.922    32.348     0.200
     2.140    33.697     0.200
     2.404    37.658     0.200
     2.394    38.768     0.200
     2.514    40.197     0.200
     2.703    42.188     0.200
     2.581    40.598     0.200
     2.825    42.158     0.200
     2.825    41.639     0.200
     2.742    43.008     0.200
     2.825    44.488     0.200
     3.530    53.559     0.200
     3.635    54.688     0.200
     3.840    58.238     0.200
     3.899    57.059     0.200
     3.899    56.629     0.200
     3.995    59.459     0.200
     4.424    65.338     0.200
     4.568    67.447     0.200
     4.627    68.379     0.200
     4.680    67.709     0.200
     4.690    69.408     0.200
     4.778    70.309     0.200
     4.834    71.598     0.200
     4.929    71.809     0.200
     4.880    72.668     0.200
     5.052    73.568     0.200
     4.987    73.549     0.200
     5.048    74.527     0.200
     5.228    76.729     0.200
     5.321    76.178     0.200
     5.321    75.738     0.200
     5.668    82.447     0.200
     5.731    84.129     0.200
     6.088    88.889     0.200
     6.205    90.678     0.200
     6.129    89.098     0.200
     6.387    92.369     0.200
     6.422    93.469     0.200
     6.597    95.697     0.200
     6.577    96.459     0.200
     6.731    96.219     0.200
     6.730    97.119     0.200
     6.795    97.748     0.200
     6.964   100.188     0.200
     7.006   100.879     0.200
     7.111   103.668     0.200
     7.195   103.709     0.200
     7.338   103.959     0.200
     7.362   106.219     0.200
     7.426   106.549     0.200
     7.499   107.389     0.200
     7.885   112.568     0.200
     8.062   113.527     0.200
     8.066   115.869     0.200
     8.096   115.908     0.200
     8.126   116.338     0.200
     8.305   118.748     0.200
     8.348   119.828     0.200
     8.626   121.078     0.200
     8.653   123.549     0.200
     8.803   124.697     0.200
     8.831   126.248     0.200
     8.978   127.518     0.200
     8.905   128.158     0.200
     9.223   130.857     0.200
     9.317   131.059     0.200
     9.401   132.938     0.200
     9.423   132.277     0.200
     9.616   134.158     0.200
     9.641   135.668     0.200
     9.796   137.658     0.200
     9.796   138.119     0.200
     9.998   140.219     0.200
    10.054   142.619     0.200
    10.497   147.879     0.200
    10.460   149.459     0.200
    11.077   155.488     0.200
    11.144   157.799     0.200
    11.410   160.869     0.200
    12.080   170.799     0.200
    12.310   173.059     0.200
    12.325   170.459     0.200
    12.325   171.018     0.200
    12.776   178.709     0.200
    14.602   204.658     0.200
    14.870   208.268     0.200
    15.106   210.898     0.200
    15.343   215.158     0.200
    15.656   217.678     0.200
    16.903   234.158     0.200
     1.018    18.242     0.200
     1.018    18.480     0.200
     1.635    27.842     0.200
     1.637    28.271     0.200
     1.823    31.111     0.200
     1.877    31.961     0.200
     1.840    31.012     0.200
     2.043    32.541     0.200
     2.305    36.512     0.200
     2.363    38.582     0.200
     2.485    40.461     0.200
     2.605    41.131     0.200
     2.554    40.852     0.200
     2.772    41.641     0.200
     2.772    42.061     0.200
     2.713    43.432     0.200
     2.807    44.932     0.200
     2.906    45.941     0.200
     3.392    51.531     0.200
     3.526    53.842     0.200
     3.526    54.371     0.200
     3.630    55.471     0.200
     3.647    55.842     0.200
     3.749    57.002     0.200
     3.676    56.531     0.200
     3.840    56.342     0.200
     3.840    56.742     0.200
     3.829    57.602     0.200
     3.938    59.012     0.200
     3.997    59.842     0.200
     3.997    60.092     0.200
     4.335    64.191     0.200
     4.422    65.561     0.200
     4.479    66.461     0.200
     4.539    67.221     0.200
     4.615    66.881     0.200
     4.601    68.342     0.200
     4.690    69.191     0.200
     4.730    69.992     0.200
     4.772    70.631     0.200
     4.913    72.051     0.200
     4.995    74.182     0.200
     5.025    74.561     0.200
     5.055    75.082     0.200
     5.129    75.641     0.200
     5.252    75.211     0.200
     5.252    75.422     0.200
     5.272    77.432     0.200
     5.575    81.041     0.200
     5.566    81.172     0.200
     5.645    81.971     0.200
     5.618    82.111     0.200
     5.770    84.941     0.200
     5.991    87.102     0.200
     6.034    87.301     0.200
     6.098    89.092     0.200
     6.284    91.402     0.200
     6.229    91.311     0.200
     6.314    91.672     0.200
     6.314    92.102     0.200
     6.502    94.352     0.200
     6.518    95.842     0.200
     6.641    95.141     0.200
     6.642    96.031     0.200
     6.619    95.342     0.200
     6.639    96.230     0.200
     6.705    96.621     0.200
     6.875    98.861     0.200
     6.927    98.432     0.200
     7.013   101.422     0.200
     7.114   102.281     0.200
     7.259   102.592     0.200
     7.338   105.012     0.200
     7.397   106.342     0.200
     7.779   111.271     0.200
     7.984   111.951     0.200
     7.983   112.441     0.200
     7.992   114.031     0.200
     8.027   115.371     0.200
     8.205   118.051     0.200
     8.537   121.061     0.200
     8.569   120.980     0.200
     8.585   122.611     0.200
     8.732   123.512     0.200
     8.899   124.572     0.200
     8.833   126.922     0.200
     8.905   127.230     0.200
     8.914   127.441     0.200
     9.137   129.842     0.200
     9.137   127.801     0.200
     9.234   129.131     0.200
     9.329   130.621     0.200
     9.337   131.002     0.200
     9.379   130.441     0.200
     9.542   132.541     0.200
     9.556   133.391     0.200
     9.725   136.842     0.200
     9.725   135.721     0.200
     9.915   139.172     0.200
    10.466   148.641     0.200
    12.256   172.441     0.200
    12.233   168.541     0.200
    14.001   194.441     0.200
    14.561   204.141     0.200
    15.057   211.281     0.200
    15.042   210.201     0.200
    15.256   212.891     0.200
    15.193   211.682     0.200
    15.241   213.402     0.200
    15.272   212.811     0.200
    15.363   215.311     0.200
    15.552   217.811     0.200
    15.604   219.121     0.200
    15.720   218.832     0.200
    15.770   219.262     0.200
    15.868   221.451     0.200
    16.135   224.271     0.200
    16.167   224.832     0.200
    16.272   226.912     0.200
    16.254   225.332     0.200
    16.862   232.592     0.200
     1.201    21.266     0.200
     1.829    30.885     0.200
     1.769    30.336     0.200
     2.035    33.285     0.200
     1.986    32.855     0.200
     2.225    35.066     0.200
     2.491    39.275     0.200
     2.412    39.545     0.200
     2.531    41.285     0.200
     2.880    42.945     0.200
     2.880    43.275     0.200
     2.759    43.896     0.200
     2.833    45.016     0.200
     2.933    46.156     0.200
     3.575    53.215     0.200
     3.526    53.746     0.200
     3.526    54.105     0.200
     3.632    55.186     0.200
     3.651    56.035     0.200
     3.678    56.246     0.200
     3.700    56.695     0.200
     3.957    58.246     0.200
     3.957    58.465     0.200
     3.920    59.545     0.200
     4.005    60.275     0.200
     3.985    59.445     0.200
     3.985    59.977     0.200
     4.595    68.266     0.200
     4.648    69.016     0.200
     4.706    70.156     0.200
     4.742    69.396     0.200
     4.769    70.605     0.200
     4.857    71.855     0.200
     4.922    72.846     0.200
     5.007    72.936     0.200
     4.890    72.596     0.200
     5.130    74.795     0.200
     5.165    75.586     0.200
     5.034    75.045     0.200
     5.111    75.135     0.200
     5.314    77.756     0.200
     5.386    77.891     0.200
     5.386    77.215     0.200
     5.756    83.986     0.200
     5.807    83.635     0.200
     6.172    89.156     0.200
     6.197    91.016     0.200
     6.294    91.826     0.200
     6.475    94.076     0.200
     6.510    94.266     0.200
     6.503    94.586     0.200
     6.618    97.846     0.200
     6.811    98.436     0.200
     6.810    98.445     0.200
     6.806    98.807     0.200
     6.874    99.385     0.200
     6.834    99.246     0.200
     7.042   101.666     0.200
     7.079   101.406     0.200
     7.195   104.227     0.200
     7.312   105.516     0.200
     7.307   105.836     0.200
     7.410   105.176     0.200
     7.443   107.576     0.200
     7.506   107.965     0.200
     7.587   109.057     0.200
     7.974   114.125     0.200
     8.133   114.625     0.200
     8.141   115.756     0.200
     8.184   117.246     0.200
     8.212   118.096     0.200
     8.152   117.465     0.200
     8.392   119.945     0.200
     8.430   120.736     0.200
     8.555   122.135     0.200
     8.705   123.795     0.200
     8.730   124.785     0.200
     8.870   124.826     0.200
     8.913   126.227     0.200
     8.809   126.676     0.200
     9.019   127.865     0.200
     8.870   127.775     0.200
     8.889   127.346     0.200
     9.051   126.846     0.200
     9.300   132.045     0.200
     9.392   132.436     0.200
     9.500   133.945     0.200
     9.526   133.135     0.200
     9.552   137.307     0.200
     9.685   134.875     0.200
     9.717   137.057     0.200
     9.863   139.146     0.200
     9.863   138.125     0.200
     9.908   140.445     0.200
    10.040   143.316     0.200
    10.072   141.365     0.200
    10.189   144.195     0.200
    10.446   148.445     0.200
    12.364   173.646     0.200
    12.407   171.146     0.200
    14.070   195.445     0.200
    14.645   205.545     0.200
    15.156   211.477     0.200
    15.075   211.375     0.200
    15.107   209.756     0.200
    15.313   211.855     0.200
    15.232   212.285     0.200
    15.363   213.545     0.200
    15.384   215.266     0.200
    15.430   215.266     0.200
    15.490   215.676     0.200
    15.724   217.807     0.200
    15.811   218.215     0.200
    15.812   220.615     0.200
    15.933   221.365     0.200
    16.023   222.945     0.200
    16.242   224.295     0.200
    16.351   225.525     0.200
    16.354   227.266     0.200
    16.351   226.715     0.200
    16.407   226.557     0.200
    16.427   227.635     0.200
    16.481   227.926     0.200
    16.555   229.115     0.200
    16.847   230.977     0.200
    16.947   235.771     0.200
    17.051   235.705     0.200
    17.080   235.746     0.200
    17.103   236.076     0.200
    17.128   236.125     0.200
    17.229   236.896     0.200
    17.503   240.006     0.200
    17.599   241.666     0.200
    17.673   242.535     0.200
     1.159    20.750     0.200
     1.789    30.250     0.200
     1.734    30.041     0.200
     1.978    33.121     0.200
     1.949    32.830     0.200
     2.190    33.461     0.200
     2.454    38.711     0.200
     2.393    39.320     0.200
     2.512    41.041     0.200
     2.752    43.191     0.200
     2.578    41.531     0.200
     2.863    42.961     0.200
     2.863    42.830     0.200
     2.740    43.910     0.200
     2.818    45.201     0.200
     3.516    53.850     0.200
     3.622    55.900     0.200
     3.668    55.111     0.200
     3.939    57.961     0.200
     4.083    61.240     0.200
     3.978    60.361     0.200
     3.978    60.180     0.200
     4.079    61.680     0.200
     4.133    62.260     0.200
     4.203    63.551     0.200
     4.552    67.121     0.200
     4.616    68.490     0.200
     4.662    68.541     0.200
     4.675    68.781     0.200
     4.721    69.041     0.200
     4.977    72.590     0.200
     4.927    72.500     0.200
     5.133    75.090     0.200
     4.968    74.271     0.200
     5.030    74.680     0.200
     5.364    77.529     0.200
     5.364    77.080     0.200
     5.719    83.471     0.200
     5.718    83.250     0.200
     5.778    83.551     0.200
     5.769    84.260     0.200
     6.107    89.861     0.200
     6.437    92.451     0.200
     6.646    95.760     0.200
     6.778    97.820     0.200
     6.843    98.951     0.200
     6.843    99.031     0.200
     7.011   101.121     0.200
     7.052   101.301     0.200
     7.267   104.590     0.200
     7.384   104.521     0.200
     7.474   107.740     0.200
     8.107   114.180     0.200
     8.112   114.551     0.200
     8.145   117.051     0.200
     8.176   117.740     0.200
     8.355   120.000     0.200
     8.674   123.080     0.200
     8.700   123.160     0.200
     8.846   125.340     0.200
     9.024   126.111     0.200
     8.886   128.461     0.200
     9.270   129.760     0.200
     9.840   139.361     0.200
    10.305   144.641     0.200
    10.441   149.461     0.200
    12.348   174.760     0.200
    12.374   170.660     0.200
    14.063   197.561     0.200
    14.635   205.361     0.200
    15.036   211.410     0.200
    15.142   212.381     0.200
    15.194   213.641     0.200
    15.309   213.410     0.200
    15.346   214.531     0.200
    15.402   215.250     0.200
    15.386   214.631     0.200
    15.469   215.801     0.200
    15.675   218.951     0.200
    15.694   219.740     0.200
    15.765   219.441     0.200
    15.799   219.930     0.200
    15.995   222.400     0.200
    16.317   227.201     0.200
    16.313   226.611     0.200
    16.450   228.760     0.200
    16.507   228.641     0.200
    16.937   234.736     0.200
    17.024   235.510     0.200
    17.092   237.371     0.200
    17.568   242.500     0.200
    17.644   243.170     0.200
     1.035    18.645     0.200
     1.664    28.125     0.200
     1.640    28.406     0.200
     1.871    30.746     0.200
     1.846    31.086     0.200
     2.074    32.686     0.200
     2.351    38.156     0.200
     2.472    40.314     0.200
     2.665    41.936     0.200
     2.541    40.756     0.200
     2.801    41.926     0.200
     2.701    43.045     0.200
     2.792    44.336     0.200
     2.891    45.455     0.200
     3.423    51.756     0.200
     3.507    53.314     0.200
     3.611    55.016     0.200
     3.628    55.285     0.200
     3.870    56.465     0.200
     3.657    55.615     0.200
     3.861    58.076     0.200
     3.976    59.885     0.200
     4.075    60.846     0.200
     4.202    62.895     0.200
     4.454    65.695     0.200
     4.510    66.555     0.200
     4.560    67.016     0.200
     4.571    67.545     0.200
     4.646    67.064     0.200
     4.874    70.885     0.200
     5.027    73.545     0.200
     4.974    73.746     0.200
     5.160    74.615     0.200
     5.003    74.246     0.200
     5.283    75.494     0.200
     5.301    77.875     0.200
     5.596    81.445     0.200
     5.677    82.855     0.200
     5.641    82.115     0.200
     6.022    86.545     0.200
     6.313    92.105     0.200
     6.206    90.365     0.200
     6.534    94.576     0.200
     6.737    96.975     0.200
     6.958    99.045     0.200
     7.044   101.045     0.200
     7.136   102.465     0.200
     7.291   103.186     0.200
     7.965   113.836     0.200
     8.016   114.596     0.200
     8.015   115.256     0.200
     8.021   115.666     0.200
     7.984   114.535     0.200
     8.058   115.076     0.200
     8.288   116.555     0.200
     8.297   117.295     0.200
     8.569   121.406     0.200
     8.601   121.805     0.200
     8.607   122.596     0.200
     8.931   125.855     0.200
     8.982   127.416     0.200
     8.892   126.445     0.200
     9.169   130.195     0.200
     9.266   131.266     0.200
     9.240   130.564     0.200
     9.361   130.586     0.200
     9.369   132.564     0.200
     9.411   132.855     0.200
     9.588   135.465     0.200
     9.757   137.326     0.200
     9.947   139.725     0.200
    10.237   144.705     0.200
    10.553   148.686     0.200
    10.822   152.025     0.200
    12.264   169.025     0.200
    15.304   213.676     0.200
    15.394   213.865     0.200
    15.584   217.395     0.200
    15.633   217.814     0.200
    15.688   217.225     0.200
    15.698   218.115     0.200
    15.653   218.186     0.200
    15.748   218.686     0.200
    15.802   219.336     0.200
    15.900   220.936     0.200
    16.156   224.365     0.200
    16.198   225.225     0.200
    16.300   226.205     0.200
    16.286   226.525     0.200
    16.346   227.635     0.200
    16.425   228.295     0.200
    16.454   227.676     0.200
    16.804   232.145     0.200
    16.890   233.500     0.200
    16.908   232.395     0.200
    16.928   233.475     0.200
    16.948   233.295     0.200
    16.973   234.486     0.200
    17.362   240.086     0.200
    17.464   240.855     0.200
    17.544   241.586     0.200
     1.067    19.230     0.200
     1.678    28.279     0.200
     1.680    29.230     0.200
     1.799    29.990     0.200
     1.886    31.240     0.200
     2.079    32.410     0.200
     2.342    37.039     0.200
     2.391    39.189     0.200
     2.641    41.580     0.200
     2.512    40.830     0.200
     2.581    41.250     0.200
     2.781    42.129     0.200
     2.781    41.980     0.200
     2.830    44.779     0.200
     2.930    46.270     0.200
     3.428    51.320     0.200
     3.543    54.129     0.200
     3.718    56.350     0.200
     3.780    57.770     0.200
     3.852    57.230     0.200
     3.852    56.109     0.200
     3.693    54.900     0.200
     3.862    58.240     0.200
     4.011    60.029     0.200
     4.454    66.070     0.200
     4.568    67.760     0.200
     4.630    67.129     0.200
     4.630    67.379     0.200
     4.719    69.869     0.200
     4.818    70.891     0.200
     4.965    73.020     0.200
     5.026    73.990     0.200
     5.039    73.930     0.200
     4.925    73.330     0.200
     5.068    75.420     0.200
     5.270    76.199     0.200
     5.314    78.209     0.200
     5.609    82.061     0.200
     5.606    81.709     0.200
     5.673    81.400     0.200
     6.026    86.969     0.200
     6.062    88.160     0.200
     6.142    88.900     0.200
     6.325    92.289     0.200
     6.239    89.410     0.200
     6.361    91.969     0.200
     6.536    93.811     0.200
     6.672    96.480     0.200
     6.657    96.770     0.200
     6.557    95.629     0.200
     6.683    96.680     0.200
     6.736    97.430     0.200
     6.736    97.510     0.200
     6.905    99.680     0.200
     6.951    99.260     0.200
     7.049   102.230     0.200
     7.172   103.570     0.200
     7.156   102.920     0.200
     7.210   103.930     0.200
     7.163   103.580     0.200
     7.283   102.949     0.200
     7.302   106.420     0.200
     7.367   106.189     0.200
     7.437   106.789     0.200
     7.823   111.969     0.200
     8.007   112.939     0.200
     8.009   113.709     0.200
     8.033   114.689     0.200
     8.064   115.760     0.200
     8.013   115.020     0.200
     8.243   117.529     0.200
     8.288   118.020     0.200
     8.404   120.260     0.200
     8.567   122.270     0.200
     8.596   121.400     0.200
     8.751   123.469     0.200
     8.909   126.209     0.200
     8.845   127.439     0.200
     8.951   127.379     0.200
     8.926   127.730     0.200
     8.926   127.529     0.200
     9.060   128.350     0.200
     9.165   129.730     0.200
     9.165   128.420     0.200
     9.260   130.189     0.200
     9.349   131.549     0.200
     9.365   130.879     0.200
     9.401   131.549     0.200
     9.562   132.930     0.200
     9.583   135.250     0.200
     9.744   136.830     0.200
     9.776   137.539     0.200
     9.941   139.359     0.200
    10.066   141.410     0.200
    10.112   142.619     0.200
    10.003   142.219     0.200
    10.479   148.430     0.200
    12.266   172.930     0.200
    12.265   169.330     0.200
    14.000   194.129     0.200
    14.564   204.930     0.200
    15.064   209.699     0.200
    15.082   210.689     0.200
    15.251   210.410     0.200
    15.222   211.340     0.200
    15.315   211.520     0.200
    15.298   212.811     0.200
    15.379   213.219     0.200
    15.575   216.400     0.200
    15.613   216.719     0.200
    15.659   217.020     0.200
    15.663   219.010     0.200
    15.602   216.719     0.200
    15.893   220.730     0.200
    16.201   225.410     0.200
    16.286   226.119     0.200
    16.431   227.859     0.200
    16.893   232.980     0.200
    16.921   233.850     0.200
    16.944   233.760     0.200
    16.980   235.580     0.200
    17.141   235.141     0.200
    17.461   240.660     0.200
    17.592   242.311     0.200
    18.565   254.289     0.200
     1.158    20.652     0.200
     1.787    30.191     0.200
     1.734    29.852     0.200
     1.948    32.652     0.200
     2.187    34.621     0.200
     2.451    38.521     0.200
     2.394    39.492     0.200
     2.513    41.521     0.200
     2.579    41.711     0.200
     2.861    43.242     0.200
     2.820    45.311     0.200
     3.518    54.021     0.200
     3.518    54.432     0.200
     3.624    55.611     0.200
     3.670    56.641     0.200
     3.936    57.102     0.200
     3.980    60.021     0.200
     3.980    60.191     0.200
     4.081    61.492     0.200
     4.135    62.271     0.200
     4.560    67.492     0.200
     4.613    68.732     0.200
     4.673    68.131     0.200
     4.719    68.521     0.200
     4.719    68.641     0.200
     4.881    71.451     0.200
     4.925    72.271     0.200
     4.970    74.002     0.200
     5.067    74.912     0.200
     5.032    75.051     0.200
     5.275    76.412     0.200
     5.361    77.365     0.200
     5.361    76.961     0.200
     5.423    78.732     0.200
     5.715    83.352     0.200
     5.775    83.322     0.200
     5.923    86.002     0.200
     6.251    91.551     0.200
     6.466    94.602     0.200
     6.791    98.912     0.200
     7.265   105.352     0.200
     8.110   117.291     0.200
     8.807   127.631     0.200
     9.021   126.822     0.200
     8.888   127.922     0.200
     9.361   132.582     0.200
     9.442   132.912     0.200
     9.467   134.352     0.200
     9.657   135.311     0.200
    10.042   142.172     0.200
     9.966   142.281     0.200
    10.024   143.512     0.200
    10.289   146.361     0.200
    12.371   171.771     0.200
    12.801   178.951     0.200
    12.819   177.832     0.200
    12.965   182.871     0.200
    13.626   190.561     0.200
    14.271   199.941     0.200
    14.488   202.762     0.200
    14.485   204.402     0.200
    14.576   203.441     0.200
    14.789   205.951     0.200
    14.854   205.922     0.200
    14.878   206.092     0.200
    14.913   206.391     0.200
    15.033   210.572     0.200
    15.192   211.531     0.200
    15.344   214.752     0.200
    15.691   218.111     0.200
    15.673   218.701     0.200
    15.772   219.582     0.200
    16.448   228.752     0.200
    17.021   234.502     0.200
    17.064   236.932     0.200
    17.089   237.232     0.200
     1.056    19.090     0.200
     1.678    28.570     0.200
     1.867    31.990     0.200
     1.868    30.650     0.200
     1.921    32.609     0.200
     2.085    33.811     0.200
     2.347    37.359     0.200
     2.580    40.670     0.200
     2.799    42.391     0.200
     2.799    42.580     0.200
     3.434    52.459     0.200
     3.520    52.129     0.200
     3.670    54.170     0.200
     3.789    57.699     0.200
     3.869    57.189     0.200
     3.869    57.000     0.200
     3.979    59.779     0.200
     4.374    65.320     0.200
     4.456    66.070     0.200
     4.462    66.320     0.200
     4.518    67.471     0.200
     4.578    68.129     0.200
     4.646    67.590     0.200
     4.646    67.391     0.200
     4.730    70.311     0.200
     4.773    71.129     0.200
     4.816    71.990     0.200
     4.881    71.500     0.200
     4.959    72.869     0.200
     5.003    73.529     0.200
     5.035    74.410     0.200
     5.172    76.699     0.200
     5.285    76.684     0.200
     5.285    76.561     0.200
     5.285    76.020     0.200
     5.315    78.301     0.200
     5.616    82.320     0.200
     5.609    82.119     0.200
     5.684    83.199     0.200
     5.660    83.129     0.200
     5.813    86.260     0.200
     6.033    88.209     0.200
     6.142    90.051     0.200
     6.217    89.070     0.200
     6.357    92.340     0.200
     6.544    94.910     0.200
     6.661    97.170     0.200
     6.681    96.561     0.200
     6.682    97.391     0.200
     6.912   100.240     0.200
     6.963    99.869     0.200
     7.055   102.209     0.200
     7.157   103.289     0.200
     7.182   103.629     0.200
     7.156   103.439     0.200
     7.218   104.150     0.200
     7.295   103.250     0.200
     7.311   105.980     0.200
     7.376   106.129     0.200
     7.909   114.039     0.200
     7.954   114.820     0.200
     7.960   115.230     0.200
     8.020   113.359     0.200
     8.021   114.510     0.200
     7.996   116.189     0.200
     8.004   114.879     0.200
     8.035   115.051     0.200
     8.074   114.830     0.200
     8.069   115.959     0.200
     8.247   118.570     0.200
     8.297   118.301     0.200
     8.307   118.439     0.200
     8.403   120.359     0.200
     8.577   122.699     0.200
     8.607   122.270     0.200
     8.626   123.760     0.200
     8.694   124.820     0.200
     8.766   123.939     0.200
     8.779   124.949     0.200
     8.866   125.990     0.200
     8.881   125.801     0.200
     8.903   126.289     0.200
     8.925   126.301     0.200
     8.935   125.850     0.200
     8.948   127.680     0.200
     9.058   128.240     0.200
     9.176   130.189     0.200
     9.176   128.539     0.200
     9.271   131.180     0.200
     9.363   132.100     0.200
     9.375   132.119     0.200
     9.414   132.539     0.200
     9.413   135.459     0.200
     9.576   133.879     0.200
     9.554   135.789     0.200
     9.594   135.510     0.200
     9.759   137.789     0.200
     9.759   137.250     0.200
     9.788   138.490     0.200
     9.881   140.500     0.200
     9.899   141.170     0.200
     9.953   140.379     0.200
    10.457   148.391     0.200
    10.457   148.129     0.200
    10.598   150.590     0.200
    10.738   150.680     0.200
    11.130   157.439     0.200
    11.330   160.141     0.200
    11.950   169.490     0.200
    12.020   169.859     0.200
    12.110   170.891     0.200
    12.110   169.141     0.200
    12.284   173.590     0.200
    12.273   169.840     0.200
    12.734   178.141     0.200
    12.974   180.439     0.200
    13.733   192.609     0.200
    13.938   195.680     0.200
    14.176   199.410     0.200
    14.185   198.670     0.200
    14.584   204.990     0.200
    14.969   209.850     0.200
    15.579   215.033     0.200
    16.885   233.840     0.200
     1.069    19.326     0.200
     1.635    27.867     0.200
     1.728    28.807     0.200
     1.856    30.807     0.200
     1.914    31.816     0.200
     1.850    31.076     0.200
     1.983    33.127     0.200
     1.983    33.357     0.200
     2.148    34.758     0.200
     2.309    37.027     0.200
     2.309    37.707     0.200
     2.496    40.467     0.200
     2.709    42.848     0.200
     2.657    42.137     0.200
     2.657    42.566     0.200
     2.880    42.646     0.200
     2.880    42.996     0.200
     3.496    53.406     0.200
     3.449    52.537     0.200
     3.554    54.127     0.200
     3.600    54.178     0.200
     3.949    57.646     0.200
     3.937    58.887     0.200
     3.915    57.758     0.200
     4.015    60.008     0.200
     4.444    65.848     0.200
     4.530    66.867     0.200
     4.588    67.887     0.200
     4.638    68.246     0.200
     4.648    68.637     0.200
     4.725    67.947     0.200
     4.725    68.117     0.200
     4.800    70.646     0.200
     4.826    71.367     0.200
     4.953    72.258     0.200
     4.828    71.188     0.200
     4.910    72.537     0.200
     5.074    74.287     0.200
     4.971    73.467     0.200
     5.104    74.387     0.200
     5.232    76.836     0.200
     5.363    75.916     0.200
     5.363    76.717     0.200
     5.366    79.227     0.200
     5.665    82.457     0.200
     5.681    82.986     0.200
     5.687    83.307     0.200
     5.756    83.236     0.200
     5.851    86.447     0.200
     6.096    88.518     0.200
     6.053    88.057     0.200
     6.187    90.336     0.200
     6.140    89.746     0.200
     6.380    93.227     0.200
     6.373    92.688     0.200
     6.392    92.746     0.200
     6.609    95.387     0.200
     6.494    95.146     0.200
     6.750    97.037     0.200
     6.751    97.277     0.200
     6.726    97.486     0.200
     6.815    97.977     0.200
     7.038   101.836     0.200
     7.118   102.678     0.200
     7.207   103.947     0.200
     7.181   104.406     0.200
     7.370   104.037     0.200
     7.380   105.787     0.200
     7.445   105.746     0.200
     7.412   105.867     0.200
     7.869   112.518     0.200
     8.021   115.348     0.200
     8.096   114.127     0.200
     8.094   115.617     0.200
     8.022   115.896     0.200
     8.087   115.527     0.200
     8.129   116.727     0.200
     8.305   119.117     0.200
     8.364   119.678     0.200
     8.370   120.076     0.200
     8.448   120.607     0.200
     8.646   122.848     0.200
     8.679   123.656     0.200
     8.843   124.508     0.200
     8.845   126.816     0.200
     8.747   125.537     0.200
     8.828   126.746     0.200
     8.828   126.076     0.200
     9.010   126.627     0.200
     8.985   128.656     0.200
     9.100   129.707     0.200
     9.247   130.547     0.200
     9.247   130.086     0.200
     9.345   131.646     0.200
     9.441   132.787     0.200
     9.447   133.207     0.200
     9.490   133.076     0.200
     9.476   136.928     0.200
     9.536   136.986     0.200
     9.653   134.627     0.200
     9.591   137.527     0.200
     9.667   135.967     0.200
     9.837   138.246     0.200
     9.837   137.496     0.200
     9.861   138.977     0.200
     9.933   141.617     0.200
     9.961   142.576     0.200
    10.026   141.836     0.200
    10.101   142.848     0.200
    10.156   143.008     0.200
    10.317   145.607     0.200
    10.297   147.227     0.200
    10.228   145.137     0.200
    10.394   147.387     0.200
    10.382   148.646     0.200
    10.382   148.146     0.200
    10.727   150.367     0.200
    10.881   153.607     0.200
    11.174   158.576     0.200
    11.329   159.977     0.200
    11.408   161.557     0.200
    11.668   163.787     0.200
    12.039   167.428     0.200
    12.087   170.656     0.200
    12.073   171.107     0.200
    12.364   174.146     0.200
    12.340   169.547     0.200
    12.365   172.928     0.200
    12.381   174.146     0.200
    12.809   179.717     0.200
    12.901   180.348     0.200
    13.231   186.387     0.200
    14.253   199.896     0.200
    14.447   202.307     0.200
    14.664   205.447     0.200
    14.800   207.947     0.200
    14.977   210.947     0.200
    15.299   214.768     0.200
     1.572    27.225     0.200
     1.593    28.225     0.200
     1.760    30.475     0.200
     1.792    30.955     0.200
     1.985    32.814     0.200
     2.245    36.184     0.200
     2.347    39.033     0.200
     2.546    40.783     0.200
     2.540    41.824     0.200
     2.742    42.395     0.200
     2.742    41.934     0.200
     2.798    45.523     0.200
     2.897    47.004     0.200
     3.524    55.295     0.200
     3.524    55.104     0.200
     3.696    56.564     0.200
     3.628    56.715     0.200
     3.806    56.693     0.200
     3.806    57.193     0.200
     3.773    57.244     0.200
     3.674    57.895     0.200
     3.880    58.334     0.200
     3.999    61.193     0.200
     3.999    61.014     0.200
     4.097    62.363     0.200
     4.149    63.205     0.200
     4.225    63.984     0.200
     4.366    64.943     0.200
     4.367    65.193     0.200
     4.425    66.154     0.200
     4.476    66.164     0.200
     4.486    67.414     0.200
     4.577    67.244     0.200
     4.548    68.014     0.200
     4.638    68.844     0.200
     4.668    69.254     0.200
     4.791    70.424     0.200
     4.853    73.424     0.200
     4.942    73.154     0.200
     5.070    76.475     0.200
     5.001    75.754     0.200
     5.212    75.664     0.200
     5.209    78.455     0.200
     5.518    80.584     0.200
     5.505    80.693     0.200
     5.595    82.533     0.200
     5.554    82.234     0.200
     5.706    84.484     0.200
     5.933    87.523     0.200
     6.035    88.533     0.200
     6.151    90.705     0.200
     6.250    90.984     0.200
     6.251    91.484     0.200
     6.588    95.404     0.200
     6.483    96.193     0.200
     6.652    96.283     0.200
     6.823    98.674     0.200
     6.879   100.664     0.200
     6.955   102.465     0.200
     7.051   103.055     0.200
     7.050   102.135     0.200
     7.212   102.545     0.200
     7.336   105.773     0.200
     7.938   112.375     0.200
     7.934   113.314     0.200
     7.901   114.705     0.200
     7.967   115.674     0.200
     8.208   120.064     0.200
     8.518   121.994     0.200
     8.521   122.684     0.200
     8.852   124.363     0.200
     8.840   127.385     0.200
     8.920   129.295     0.200
     9.086   129.693     0.200
     9.184   130.443     0.200
     9.287   132.234     0.200
     9.286   130.943     0.200
     9.498   133.205     0.200
     9.506   134.244     0.200
     9.446   135.914     0.200
     9.683   136.895     0.200
     9.683   136.465     0.200
     9.866   139.074     0.200
    10.483   148.693     0.200
    10.470   150.594     0.200
    10.470   150.754     0.200
    10.738   151.955     0.200
    10.898   154.594     0.200
    10.996   156.455     0.200
    11.349   161.854     0.200
    11.655   165.984     0.200
    11.870   167.975     0.200
    12.011   169.135     0.200
    12.177   168.693     0.200
    12.651   178.885     0.200
    13.982   196.395     0.200
    14.537   204.795     0.200
    14.663   207.145     0.200
    16.864   236.875     0.200
    18.483   253.744     0.200
     1.512    26.254     0.200
     1.542    27.084     0.200
     1.701    29.283     0.200
     1.919    31.023     0.200
     2.180    35.174     0.200
     2.377    38.734     0.200
     2.413    38.363     0.200
     2.481    39.484     0.200
     2.572    41.154     0.200
     2.572    42.674     0.200
     2.580    41.385     0.200
     2.680    40.564     0.200
     2.680    40.805     0.200
     2.728    43.404     0.200
     2.728    43.984     0.200
     2.835    44.875     0.200
     3.568    57.863     0.200
     3.628    55.725     0.200
     3.671    56.094     0.200
     3.716    57.385     0.200
     3.707    56.514     0.200
     3.741    55.564     0.200
     3.741    56.125     0.200
     4.045    62.154     0.200
     4.143    61.885     0.200
     4.215    63.484     0.200
     4.271    63.684     0.200
     4.298    64.113     0.200
     4.300    64.334     0.200
     4.408    65.555     0.200
     4.419    66.184     0.200
     4.511    65.363     0.200
     4.511    66.113     0.200
     4.571    68.354     0.200
     4.723    69.604     0.200
     4.805    71.434     0.200
     4.845    71.674     0.200
     4.892    72.504     0.200
     5.005    74.783     0.200
     5.050    75.264     0.200
     5.145    74.607     0.200
     5.145    74.814     0.200
     5.148    77.014     0.200
     5.442    80.295     0.200
     5.452    80.113     0.200
     5.507    81.113     0.200
     5.527    80.725     0.200
     5.652    83.404     0.200
     5.867    86.203     0.200
     5.977    88.154     0.200
     6.202    90.555     0.200
     6.198    91.244     0.200
     6.210    92.295     0.200
     6.379    92.863     0.200
     6.520    94.645     0.200
     6.521    94.834     0.200
     6.518    94.934     0.200
     6.755    98.385     0.200
     6.758    98.354     0.200
     6.812    97.754     0.200
     6.889    99.895     0.200
     6.990   101.404     0.200
     7.005   101.674     0.200
     7.020   101.703     0.200
     7.145   101.574     0.200
     7.215   103.604     0.200
     7.224   103.965     0.200
     7.273   105.344     0.200
     7.658   110.363     0.200
     7.746   111.764     0.200
     7.791   112.773     0.200
     7.839   112.824     0.200
     7.860   113.443     0.200
     7.866   113.164     0.200
     7.870   111.385     0.200
     7.868   113.184     0.200
     7.903   113.773     0.200
     8.080   115.965     0.200
     8.134   116.783     0.200
     8.416   119.795     0.200
     8.451   121.104     0.200
     8.528   122.764     0.200
     8.615   124.004     0.200
     8.623   122.004     0.200
     8.784   124.084     0.200
     8.790   124.783     0.200
     8.787   125.814     0.200
     9.018   128.564     0.200
     9.018   126.625     0.200
     9.088   129.773     0.200
     9.117   128.443     0.200
     9.220   129.863     0.200
     9.218   130.254     0.200
     9.394   133.904     0.200
     9.430   131.924     0.200
     9.438   132.625     0.200
     9.616   135.863     0.200
     9.616   135.305     0.200
     9.633   135.715     0.200
     9.714   137.994     0.200
     9.733   138.574     0.200
     9.798   138.104     0.200
     9.933   140.064     0.200
     9.988   141.305     0.200
    10.074   142.184     0.200
    10.092   142.453     0.200
    10.129   142.684     0.200
    10.240   144.854     0.200
    10.456   149.844     0.200
    10.517   149.975     0.200
    10.623   150.975     0.200
    10.798   153.703     0.200
    10.929   152.854     0.200
    10.947   154.395     0.200
    10.966   154.914     0.200
    10.972   156.014     0.200
    11.614   163.703     0.200
    11.797   167.264     0.200
    11.797   166.994     0.200
    11.853   167.854     0.200
    11.946   169.264     0.200
    11.946   167.264     0.200
    11.946   168.914     0.200
    12.110   167.613     0.200
    12.110   168.395     0.200
    12.160   171.965     0.200
    12.584   175.904     0.200
    13.029   182.984     0.200
    14.338   200.814     0.200
    14.478   203.064     0.200
     1.561    26.844     0.200
     1.561    27.094     0.200
     1.856    30.164     0.200
     2.113    34.045     0.200
     2.347    37.395     0.200
     2.333    38.555     0.200
     2.416    38.504     0.200
     2.416    38.725     0.200
     2.513    40.455     0.200
     2.530    41.025     0.200
     2.668    40.424     0.200
     2.668    40.525     0.200
     2.799    45.365     0.200
     2.897    46.295     0.200
     3.203    48.975     0.200
     3.503    53.404     0.200
     3.574    54.785     0.200
     3.542    55.125     0.200
     3.658    56.504     0.200
     3.722    54.924     0.200
     3.722    55.074     0.200
     3.689    57.125     0.200
     3.715    57.244     0.200
     4.024    60.924     0.200
     4.024    61.164     0.200
     4.243    63.285     0.200
     4.247    63.145     0.200
     4.366    64.945     0.200
     4.286    64.695     0.200
     4.428    66.025     0.200
     4.485    64.924     0.200
     4.485    65.094     0.200
     4.519    66.945     0.200
     4.532    67.645     0.200
     4.571    68.385     0.200
     4.719    70.035     0.200
     4.939    72.875     0.200
     5.072    75.805     0.200
     5.115    73.619     0.200
     5.115    73.754     0.200
     5.090    75.834     0.200
     5.120    76.404     0.200
     5.391    78.844     0.200
     5.478    79.814     0.200
     5.569    82.344     0.200
     5.804    84.664     0.200
     5.864    85.414     0.200
     5.879    85.824     0.200
     6.122    90.105     0.200
     6.188    91.014     0.200
     6.272    92.525     0.200
     6.437    93.645     0.200
     6.424    94.824     0.200
     6.424    94.686     0.200
     6.703    96.734     0.200
     6.713    97.314     0.200
     6.917    99.715     0.200
     7.059   101.686     0.200
     7.094   102.275     0.200
     7.753   111.674     0.200
     7.772   112.115     0.200
     7.793   111.795     0.200
     7.820   110.164     0.200
     7.835   112.814     0.200
     7.978   113.375     0.200
     8.011   114.764     0.200
     8.078   116.465     0.200
     8.077   115.545     0.200
     8.159   116.686     0.200
     8.402   118.734     0.200
     8.460   121.545     0.200
     8.557   121.244     0.200
     8.589   121.484     0.200
     8.764   123.605     0.200
     8.813   125.395     0.200
     8.969   125.725     0.200
     8.969   124.924     0.200
     8.908   128.535     0.200
     8.922   128.334     0.200
     8.949   128.525     0.200
     8.949   127.764     0.200
     9.168   127.795     0.200
     9.185   128.775     0.200
     9.226   128.535     0.200
     9.241   131.205     0.200
     9.247   130.414     0.200
     9.389   131.084     0.200
     9.393   130.594     0.200
     9.586   134.215     0.200
     9.582   134.025     0.200
     9.582   133.844     0.200
     9.639   136.754     0.200
     9.668   136.705     0.200
     9.752   136.424     0.200
     9.860   139.705     0.200
     9.895   138.455     0.200
     9.958   139.594     0.200
    10.003   142.125     0.200
    10.051   140.545     0.200
    10.059   144.064     0.200
    10.368   147.625     0.200
    10.388   145.715     0.200
    10.496   150.025     0.200
    10.496   149.525     0.200
    10.680   150.824     0.200
    10.776   153.244     0.200
    10.887   154.545     0.200
    10.903   153.215     0.200
    11.011   156.734     0.200
    11.403   159.875     0.200
    11.498   159.385     0.200
    11.565   162.564     0.200
    11.779   166.164     0.200
    11.885   167.025     0.200
    11.885   165.424     0.200
    11.885   164.734     0.200
    11.885   166.914     0.200
    12.052   166.074     0.200
    12.052   167.025     0.200
    12.143   170.725     0.200
    12.542   174.584     0.200
    13.928   193.424     0.200
    14.472   202.824     0.200
    14.741   207.105     0.200
    15.268   212.725     0.200
    15.569   216.318     0.200
    16.110   224.135     0.200
    18.950   259.400     0.200
     0.995    18.031     0.200
     1.604    27.672     0.200
     1.712    29.020     0.200
     1.627    28.840     0.200
     1.792    30.602     0.200
     1.828    31.750     0.200
     2.011    32.109     0.200
     2.272    36.180     0.200
     2.369    38.590     0.200
     2.572    40.539     0.200
     2.492    40.910     0.200
     2.746    42.031     0.200
     2.746    41.750     0.200
     2.561    41.590     0.200
     2.817    44.500     0.200
     3.539    54.582     0.200
     3.643    56.012     0.200
     3.689    56.680     0.200
     3.905    58.492     0.200
     4.012    60.832     0.200
     4.012    61.090     0.200
     4.303    63.871     0.200
     4.110    62.031     0.200
     4.163    62.621     0.200
     4.386    65.082     0.200
     4.390    65.051     0.200
     4.238    63.961     0.200
     4.447    66.160     0.200
     4.496    66.410     0.200
     4.507    66.930     0.200
     4.586    66.820     0.200
     4.659    68.930     0.200
     4.698    69.051     0.200
     4.743    70.871     0.200
     4.811    70.352     0.200
     4.890    72.859     0.200
     4.963    73.070     0.200
     5.097    75.652     0.200
     5.223    75.473     0.200
     5.072    76.551     0.200
     5.240    77.730     0.200
     5.534    80.992     0.200
     5.614    82.512     0.200
     5.591    82.480     0.200
     5.741    84.449     0.200
     5.959    86.492     0.200
     6.068    88.840     0.200
     6.252    91.500     0.200
     6.285    92.121     0.200
     6.160    90.930     0.200
     6.586    96.309     0.200
     6.608    96.121     0.200
     6.673    96.520     0.200
     6.514    95.629     0.200
     6.843    98.590     0.200
     6.896    98.410     0.200
     6.981   101.250     0.200
     7.072   102.059     0.200
     7.110   103.270     0.200
     7.082   102.371     0.200
     7.228   102.520     0.200
     7.748   110.961     0.200
     7.953   113.391     0.200
     7.952   114.500     0.200
     7.960   114.512     0.200
     7.939   114.121     0.200
     8.172   117.742     0.200
     8.224   118.371     0.200
     8.558   123.242     0.200
     8.702   123.602     0.200
     8.868   124.789     0.200
     8.875   126.961     0.200
     8.931   128.711     0.200
     9.202   130.609     0.200
     9.299   131.469     0.200
     9.305   131.371     0.200
     9.511   133.809     0.200
     9.525   134.152     0.200
     9.695   137.031     0.200
     9.695   136.262     0.200
     9.884   139.461     0.200
     9.962   141.941     0.200
    10.175   143.039     0.200
    10.314   146.992     0.200
    10.395   147.129     0.200
    10.493   148.242     0.200
    10.482   150.230     0.200
    10.895   154.301     0.200
    10.909   154.500     0.200
    10.974   154.652     0.200
    11.032   156.422     0.200
    11.781   166.480     0.200
    12.200   167.879     0.200
    12.667   178.211     0.200
    13.533   189.211     0.200
    13.979   194.531     0.200
    14.537   204.430     0.200
    15.577   218.570     0.200
     1.073    18.805     0.200
     1.073    18.477     0.200
     1.688    29.027     0.200
     1.870    31.895     0.200
     1.893    31.086     0.200
     2.343    37.656     0.200
     2.399    38.844     0.200
     2.576    41.234     0.200
     2.520    41.824     0.200
     2.777    42.504     0.200
     2.777    42.395     0.200
     2.588    41.324     0.200
     2.748    43.996     0.200
     2.837    43.805     0.200
     2.837    45.055     0.200
     2.937    46.816     0.200
     3.550    55.707     0.200
     3.550    55.344     0.200
     3.780    56.855     0.200
     3.654    55.227     0.200
     3.654    55.895     0.200
     3.849    57.305     0.200
     3.700    56.254     0.200
     4.018    60.605     0.200
     4.018    59.895     0.200
     4.117    61.445     0.200
     4.243    63.625     0.200
     4.556    66.426     0.200
     4.568    67.156     0.200
     4.627    66.324     0.200
     4.630    67.945     0.200
     4.719    69.504     0.200
     4.870    70.156     0.200
     4.822    71.926     0.200
     4.970    73.777     0.200
     4.932    73.074     0.200
     5.014    74.344     0.200
     5.167    77.676     0.200
     5.074    75.684     0.200
     5.267    75.023     0.200
     5.267    75.695     0.200
     5.672    83.316     0.200
     5.671    83.355     0.200
     6.027    86.484     0.200
     6.146    88.996     0.200
     6.158    89.855     0.200
     6.327    92.574     0.200
     6.365    91.715     0.200
     6.565    97.305     0.200
     7.158   103.266     0.200
     7.390   105.156     0.200
     7.439   106.684     0.200
     8.921   125.426     0.200
     8.955   128.164     0.200
     9.256   131.316     0.200
     9.346   131.465     0.200
     9.560   134.516     0.200
     9.561   136.387     0.200
     9.742   137.406     0.200
     9.742   136.137     0.200
     9.940   139.516     0.200
    10.355   146.656     0.200
    10.535   148.824     0.200
    12.262   172.305     0.200
    12.265   168.055     0.200
    12.702   178.797     0.200
    13.995   195.805     0.200
    14.560   204.605     0.200
    14.756   205.594     0.200
    15.236   214.496     0.200
    18.565   254.266     0.200
     1.125    20.172     0.200
     1.702    29.012     0.200
     1.867    31.184     0.200
     1.947    32.102     0.200
     2.001    33.133     0.200
     1.916    31.992     0.200
     2.165    33.945     0.200
     2.371    38.973     0.200
     2.491    40.715     0.200
     2.558    41.164     0.200
     2.558    41.512     0.200
     2.857    42.973     0.200
     2.857    42.793     0.200
     2.719    43.395     0.200
     2.900    45.633     0.200
     3.502    53.973     0.200
     3.608    54.902     0.200
     3.608    55.074     0.200
     3.677    56.895     0.200
     3.966    60.074     0.200
     3.966    59.785     0.200
     4.067    61.004     0.200
     4.120    61.812     0.200
     4.532    66.625     0.200
     4.540    66.945     0.200
     4.595    68.082     0.200
     4.655    68.645     0.200
     4.711    68.074     0.200
     4.806    71.215     0.200
     4.854    71.652     0.200
     4.895    72.332     0.200
     4.957    72.273     0.200
     4.876    72.723     0.200
     5.035    74.215     0.200
     4.958    73.832     0.200
     5.352    76.441     0.200
     5.352    76.602     0.200
     5.396    79.445     0.200
     5.690    82.762     0.200
     5.759    84.352     0.200
     5.736    84.305     0.200
     5.892    86.102     0.200
     6.112    88.582     0.200
     6.223    91.434     0.200
     6.408    92.715     0.200
     6.763    98.473     0.200
     7.035   100.402     0.200
     7.238   104.844     0.200
     7.231   104.273     0.200
     7.453   107.645     0.200
     7.458   107.555     0.200
     7.903   112.492     0.200
     8.091   115.254     0.200
     8.094   115.375     0.200
     8.074   115.652     0.200
     8.116   116.863     0.200
     8.075   115.465     0.200
     8.682   124.082     0.200
     8.833   125.203     0.200
     9.008   127.695     0.200
     8.795   127.023     0.200
     9.027   129.055     0.200
     8.876   127.574     0.200
     8.876   127.383     0.200
     9.251   130.973     0.200
     9.251   131.102     0.200
     9.345   130.832     0.200
     9.431   133.273     0.200
     9.451   132.875     0.200
     9.669   137.164     0.200
     9.827   138.375     0.200
     9.827   138.684     0.200
    10.027   141.273     0.200
    10.085   142.465     0.200
    10.313   145.984     0.200
    10.527   148.953     0.200
    10.618   149.363     0.200
    10.431   149.875     0.200
    10.714   152.793     0.200
    11.107   157.262     0.200
    11.139   157.215     0.200
    11.929   168.582     0.200
    12.352   169.375     0.200
    12.367   173.574     0.200
    12.806   179.184     0.200
    13.143   184.395     0.200
    13.628   189.953     0.200
    14.633   205.172     0.200
    16.935   234.949     0.200
     1.204    22.969     0.200
     1.832    32.777     0.200
     1.769    31.918     0.200
     2.038    35.598     0.200
     1.987    33.637     0.200
     2.411    40.469     0.200
     2.530    43.207     0.200
     2.595    43.035     0.200
     2.884    44.848     0.200
     2.884    44.695     0.200
     2.831    47.008     0.200
     3.523    55.746     0.200
     3.629    57.098     0.200
     3.924    60.816     0.200
     3.961    59.848     0.200
     3.961    60.016     0.200
     3.982    61.246     0.200
     3.982    61.887     0.200
     4.084    62.969     0.200
     4.138    63.828     0.200
     4.600    69.668     0.200
     4.652    70.086     0.200
     4.697    71.059     0.200
     4.710    70.875     0.200
     4.746    70.047     0.200
     4.746    70.316     0.200
     4.861    73.906     0.200
     4.926    74.195     0.200
     5.012    74.746     0.200
     4.887    74.719     0.200
     5.134    76.676     0.200
     4.969    75.828     0.200
     5.114    77.828     0.200
     5.390    79.066     0.200
     5.390    78.828     0.200
     5.468    82.367     0.200
     5.757    85.488     0.200
     5.811    86.578     0.200
     5.815    87.059     0.200
     5.969    89.695     0.200
     6.106    91.086     0.200
     6.297    92.996     0.200
     6.479    95.809     0.200
     6.838   100.168     0.200
     7.083   102.625     0.200
     7.199   106.117     0.200
     7.447   109.676     0.200
     7.510   109.816     0.200
     7.590   111.016     0.200
     8.137   117.258     0.200
     8.145   117.188     0.200
     8.211   120.059     0.200
     8.188   119.406     0.200
     8.155   118.887     0.200
     8.558   123.688     0.200
     8.734   125.426     0.200
     8.917   128.797     0.200
     8.806   128.875     0.200
     9.055   128.848     0.200
     8.886   129.848     0.200
     8.886   129.316     0.200
     9.104   130.797     0.200
     9.304   133.746     0.200
     9.304   132.707     0.200
     9.396   133.746     0.200
     9.409   136.266     0.200
     9.472   135.277     0.200
     9.504   135.746     0.200
     9.530   134.797     0.200
     9.689   136.836     0.200
     9.721   138.137     0.200
     9.867   140.445     0.200
    10.077   143.266     0.200
    10.119   145.398     0.200
    10.341   146.719     0.200
    10.359   147.008     0.200
    10.472   150.066     0.200
    10.654   152.195     0.200
    10.443   151.148     0.200
    10.796   153.375     0.200
    11.344   161.836     0.200
    11.439   162.688     0.200
    11.817   168.488     0.200
    11.854   168.719     0.200
    11.983   170.676     0.200
    12.230   172.617     0.200
    12.368   175.746     0.200
    12.411   172.598     0.200
    12.411   174.656     0.200
    12.667   178.766     0.200
    12.834   182.418     0.200
    13.840   196.148     0.200
    14.035   199.117     0.200
    14.073   198.547     0.200
    14.649   207.047     0.200
    16.559   231.398     0.200
    17.055   237.328     0.200
    17.084   236.777     0.200
    17.677   244.188     0.200
     1.621    27.609     0.200
     1.800    30.492     0.200
     1.808    30.852     0.200
     1.861    31.582     0.200
     2.039    32.719     0.200
     2.298    36.770     0.200
     2.444    39.590     0.200
     2.514    40.012     0.200
     2.531    39.891     0.200
     2.672    42.469     0.200
     2.768    43.969     0.200
     2.794    42.391     0.200
     2.867    45.359     0.200
     3.387    51.980     0.200
     3.489    53.289     0.200
     3.638    55.789     0.200
     3.751    57.320     0.200
     3.829    57.480     0.200
     3.859    56.992     0.200
     3.859    57.391     0.200
     3.935    59.332     0.200
     3.961    58.891     0.200
     3.961    59.242     0.200
     4.224    63.082     0.200
     4.421    65.449     0.200
     4.422    65.719     0.200
     4.481    66.570     0.200
     4.532    67.469     0.200
     4.631    67.691     0.200
     4.631    67.582     0.200
     4.718    70.582     0.200
     4.753    69.930     0.200
     4.892    72.270     0.200
     4.961    73.219     0.200
     4.997    73.680     0.200
     5.021    74.219     0.200
     5.016    73.930     0.200
     5.124    76.441     0.200
     5.141    75.332     0.200
     5.267    75.910     0.200
     5.267    76.359     0.200
     5.267    76.480     0.200
     5.556    81.410     0.200
     5.573    81.391     0.200
     5.592    81.969     0.200
     5.651    82.762     0.200
     5.750    84.039     0.200
     5.988    87.320     0.200
     6.038    88.520     0.200
     6.082    89.211     0.200
     6.196    90.531     0.200
     6.272    91.000     0.200
     6.285    92.312     0.200
     6.476    94.289     0.200
     6.476    94.820     0.200
     6.501    94.570     0.200
     6.611    96.031     0.200
     6.622    96.289     0.200
     6.645    96.449     0.200
     6.708    96.922     0.200
     6.935    99.562     0.200
     7.009   101.602     0.200
     7.088   102.141     0.200
     7.100   102.840     0.200
     7.143   103.691     0.200
     7.238   104.461     0.200
     7.268   103.680     0.200
     7.272   105.730     0.200
     7.338   106.230     0.200
     7.869   113.730     0.200
     7.918   115.402     0.200
     7.930   113.820     0.200
     7.934   113.891     0.200
     7.934   114.449     0.200
     7.979   114.621     0.200
     7.990   113.539     0.200
     7.994   113.129     0.200
     8.147   116.949     0.200
     8.196   117.449     0.200
     8.256   119.180     0.200
     8.262   120.062     0.200
     8.539   121.910     0.200
     8.747   125.641     0.200
     8.737   124.789     0.200
     8.745   124.199     0.200
     8.798   126.352     0.200
     8.841   126.941     0.200
     8.857   126.902     0.200
     8.880   127.090     0.200
     8.907   125.340     0.200
     8.910   126.062     0.200
     8.996   127.449     0.200
     9.142   128.691     0.200
     9.142   128.289     0.200
     9.198   131.551     0.200
     9.341   131.281     0.200
     9.342   131.922     0.200
     9.367   134.910     0.200
     9.389   131.730     0.200
     9.490   135.340     0.200
     9.553   133.641     0.200
     9.562   134.160     0.200
     9.738   136.691     0.200
     9.738   137.062     0.200
     9.756   137.562     0.200
     9.852   140.449     0.200
    10.012   142.352     0.200
    10.007   142.332     0.200
    10.056   141.602     0.200
    10.109   142.691     0.200
    10.431   149.090     0.200
    10.431   147.691     0.200
    10.431   147.281     0.200
    10.713   151.469     0.200
    11.064   157.621     0.200
    11.554   164.891     0.200
    11.921   167.492     0.200
    11.965   169.270     0.200
    12.067   170.691     0.200
    12.067   168.691     0.200
    12.067   169.402     0.200
    12.232   169.039     0.200
    12.232   169.492     0.200
    12.277   173.391     0.200
    12.707   178.180     0.200
    12.946   180.789     0.200
    13.923   195.520     0.200
    14.153   197.672     0.200
    14.587   204.691     0.200
    14.924   207.441     0.200
    15.353   214.789     0.200
    15.541   216.980     0.200
    16.170   224.742     0.200
    16.171   225.551     0.200
    16.171   225.832     0.200
    16.481   229.492     0.200
    16.888   234.867     0.200
    19.009   260.914     0.200
    19.009   261.742     0.200
     1.064    18.953     0.200
     1.671    28.133     0.200
     1.702    28.211     0.200
     1.681    28.773     0.200
     1.792    29.543     0.200
     1.886    30.633     0.200
     2.071    32.621     0.200
     2.335    36.422     0.200
     2.567    39.781     0.200
     2.517    40.824     0.200
     2.634    40.902     0.200
     2.773    41.504     0.200
     2.836    44.312     0.200
     3.421    51.441     0.200
     3.710    55.633     0.200
     3.654    56.012     0.200
     3.772    57.434     0.200
     3.843    56.383     0.200
     3.854    57.723     0.200
     3.965    59.133     0.200
     4.018    60.223     0.200
     4.117    61.531     0.200
     4.244    63.531     0.200
     4.356    64.582     0.200
     4.446    65.672     0.200
     4.500    66.582     0.200
     4.548    66.812     0.200
     4.560    67.062     0.200
     4.622    66.801     0.200
     4.623    68.484     0.200
     4.711    69.531     0.200
     4.764    69.754     0.200
     4.863    70.793     0.200
     4.812    70.484     0.200
     4.985    72.793     0.200
     5.017    73.461     0.200
     5.031    73.492     0.200
     4.960    72.883     0.200
     5.159    75.652     0.200
     5.261    75.336     0.200
     5.261    75.184     0.200
     5.193    76.094     0.200
     5.601    81.645     0.200
     5.599    81.234     0.200
     5.664    82.273     0.200
     5.662    82.703     0.200
     5.811    84.801     0.200
     6.159    89.551     0.200
     6.246    91.352     0.200
     6.528    94.281     0.200
     6.664    95.914     0.200
     6.663    95.922     0.200
     6.727    96.781     0.200
     6.677    96.664     0.200
     6.942    98.594     0.200
     7.158   103.031     0.200
     8.009   114.633     0.200
     8.280   118.051     0.200
     9.251   129.633     0.200
     9.393   130.793     0.200
    10.220   142.992     0.200
    10.349   146.352     0.200
    12.257   167.527     0.200
    16.857   231.273     0.200
     1.157    20.156     0.200
     1.157    19.855     0.200
     1.786    29.875     0.200
     1.732    29.625     0.200
     1.975    33.027     0.200
     1.947    31.805     0.200
     2.187    34.508     0.200
     2.451    38.484     0.200
     2.750    42.836     0.200
     2.861    42.758     0.200
     2.861    42.477     0.200
     2.740    43.367     0.200
     2.818    44.367     0.200
     3.516    53.367     0.200
     3.668    56.027     0.200
     3.937    57.906     0.200
     3.969    59.484     0.200
     4.080    61.035     0.200
     3.978    59.156     0.200
     3.978    59.266     0.200
     4.560    67.305     0.200
     4.660    68.707     0.200
     4.673    68.418     0.200
     4.719    68.277     0.200
     4.735    69.977     0.200
     4.823    71.145     0.200
     4.880    71.918     0.200
     4.974    72.375     0.200
     4.924    72.695     0.200
     4.886    72.527     0.200
     5.066    74.867     0.200
     4.968    73.695     0.200
     5.000    74.176     0.200
     5.030    74.586     0.200
     5.275    76.867     0.200
     5.362    76.711     0.200
     5.362    76.867     0.200
     5.422    79.547     0.200
     5.715    83.117     0.200
     5.775    83.887     0.200
     5.767    84.645     0.200
     5.922    86.527     0.200
     6.250    91.117     0.200
     6.434    93.227     0.200
     6.588    96.758     0.200
     6.791    98.445     0.200
     6.841    98.926     0.200
     7.050   100.496     0.200
     7.157   103.695     0.200
     7.408   107.027     0.200
     7.931   113.406     0.200
     8.105   115.125     0.200
     8.110   115.445     0.200
     8.107   116.195     0.200
     8.352   119.977     0.200
     8.408   120.328     0.200
     8.698   123.625     0.200
     8.844   124.867     0.200
     8.805   126.566     0.200
     9.022   126.484     0.200
     8.866   127.375     0.200
     8.886   127.156     0.200
     8.886   126.945     0.200
     9.056   129.215     0.200
     9.443   132.277     0.200
     9.467   133.008     0.200
     9.658   134.285     0.200
     9.685   137.137     0.200
     9.838   138.055     0.200
     9.838   138.375     0.200
    10.022   143.266     0.200
    10.442   148.957     0.200
    11.028   154.957     0.200
    11.119   155.715     0.200
    11.455   161.066     0.200
    11.827   165.586     0.200
    11.946   168.168     0.200
    12.346   173.457     0.200
    12.371   170.141     0.200
    12.371   171.996     0.200
    12.383   174.277     0.200
    12.801   179.758     0.200
    12.976   182.777     0.200
    14.062   195.457     0.200
    14.271   199.047     0.200
    14.634   205.258     0.200
    14.790   206.297     0.200
    14.913   207.426     0.200
    15.033   211.066     0.200
    15.140   211.484     0.200
    15.673   218.555     0.200
    16.314   227.066     0.200
    17.021   234.867     0.200
    17.565   241.996     0.200
    17.641   242.645     0.200
     1.149    20.391     0.200
     1.778    29.910     0.200
     1.726    30.180     0.200
     1.887    31.582     0.200
     1.940    32.250     0.200
     2.179    34.500     0.200
     2.443    38.031     0.200
     2.390    38.891     0.200
     2.675    41.613     0.200
     2.576    41.180     0.200
     2.857    43.090     0.200
     2.857    42.641     0.200
     2.817    44.750     0.200
     3.516    54.191     0.200
     3.516    53.930     0.200
     3.622    55.441     0.200
     3.691    56.543     0.200
     3.878    58.613     0.200
     3.932    57.691     0.200
     3.932    57.230     0.200
     3.961    59.602     0.200
     3.979    59.293     0.200
     3.979    59.512     0.200
     4.080    61.102     0.200
     4.134    61.750     0.200
     4.552    67.191     0.200
     4.606    68.070     0.200
     4.653    68.672     0.200
     4.665    68.891     0.200
     4.714    67.992     0.200
     4.728    69.742     0.200
     4.872    71.980     0.200
     4.916    72.801     0.200
     4.967    72.051     0.200
     5.058    74.820     0.200
     4.969    73.461     0.200
     5.001    74.301     0.200
     5.031    74.832     0.200
     5.356    76.695     0.200
     5.356    76.930     0.200
     5.414    79.891     0.200
     5.707    82.992     0.200
     5.758    84.203     0.200
     6.109    89.230     0.200
     6.242    90.461     0.200
     6.197    90.730     0.200
     6.426    93.980     0.200
     6.457    93.863     0.200
     6.450    93.902     0.200
     6.584    97.090     0.200
     6.782    98.613     0.200
     6.834    99.012     0.200
     7.043   100.590     0.200
     7.254   104.680     0.200
     7.480   107.422     0.200
     7.923   113.383     0.200
     8.098   115.570     0.200
     8.103   116.891     0.200
     8.096   117.270     0.200
     8.099   115.730     0.200
     8.401   121.902     0.200
     8.503   122.270     0.200
     8.691   123.562     0.200
     8.724   124.621     0.200
     8.838   125.473     0.200
     9.015   127.820     0.200
     8.887   127.492     0.200
     9.048   129.863     0.200
     9.260   131.590     0.200
     9.354   132.242     0.200
     9.436   133.723     0.200
     9.460   133.020     0.200
     9.652   134.582     0.200
     9.679   136.371     0.200
     9.832   138.793     0.200
    10.035   140.711     0.200
    10.088   143.051     0.200
    10.295   144.680     0.200
    10.320   145.070     0.200
    10.434   146.492     0.200
    10.532   148.820     0.200
    10.443   148.891     0.200
    11.448   160.621     0.200
    12.341   173.492     0.200
    12.364   170.617     0.200
    12.364   173.172     0.200
    13.142   184.281     0.200
    12.964   182.211     0.200
    13.624   190.250     0.200
    14.477   203.871     0.200
    14.630   204.793     0.200
    15.136   211.301     0.200
    15.793   222.930     0.200
    16.501   231.461     0.200
     1.632    28.176     0.200
     1.630    29.004     0.200
     1.756    29.676     0.200
     1.834    30.926     0.200
     2.042    32.465     0.200
     2.303    36.426     0.200
     2.357    38.926     0.200
     2.479    40.605     0.200
     2.548    41.105     0.200
     2.603    41.234     0.200
     2.775    41.805     0.200
     2.775    41.574     0.200
     2.801    44.695     0.200
     2.900    45.883     0.200
     3.390    51.176     0.200
     3.520    54.203     0.200
     3.520    54.062     0.200
     3.670    56.375     0.200
     3.694    56.895     0.200
     3.842    56.605     0.200
     3.842    56.715     0.200
     3.937    59.344     0.200
     3.992    60.004     0.200
     4.090    61.625     0.200
     4.143    62.324     0.200
     4.217    63.645     0.200
     4.417    65.434     0.200
     4.421    65.734     0.200
     4.478    66.824     0.200
     4.528    67.164     0.200
     4.539    67.273     0.200
     4.617    66.902     0.200
     4.601    68.633     0.200
     4.690    69.543     0.200
     4.727    69.934     0.200
     4.769    70.266     0.200
     4.843    70.914     0.200
     4.908    73.332     0.200
     4.913    72.516     0.200
     4.964    72.812     0.200
     4.990    74.402     0.200
     4.995    73.562     0.200
     5.128    74.625     0.200
     5.254    75.375     0.200
     5.269    76.902     0.200
     5.564    81.402     0.200
     5.646    81.523     0.200
     5.614    82.363     0.200
     5.766    84.445     0.200
     6.138    89.945     0.200
     6.224    91.645     0.200
     6.281    90.945     0.200
     6.310    92.125     0.200
     6.309    92.043     0.200
     6.511    94.504     0.200
     6.705    96.945     0.200
     6.927    98.402     0.200
     7.012   100.723     0.200
     7.111   102.312     0.200
     7.110   102.875     0.200
     7.221   101.785     0.200
     7.260   102.902     0.200
     7.334   105.242     0.200
     7.776   111.453     0.200
     7.869   111.312     0.200
     7.985   112.375     0.200
     7.983   112.652     0.200
     7.949   113.383     0.200
     7.959   113.293     0.200
     7.989   113.176     0.200
     8.264   116.652     0.200
     8.357   118.723     0.200
     8.537   120.516     0.200
     8.569   121.484     0.200
     8.580   123.676     0.200
     8.650   123.176     0.200
     8.733   123.254     0.200
     8.737   123.703     0.200
     8.900   125.375     0.200
     8.909   127.973     0.200
     8.901   126.582     0.200
     9.011   128.082     0.200
     9.234   130.234     0.200
     9.331   130.953     0.200
     9.337   131.664     0.200
     9.380   132.023     0.200
     9.370   134.492     0.200
     9.434   135.414     0.200
     9.543   133.184     0.200
     9.557   134.312     0.200
     9.727   137.605     0.200
     9.727   137.324     0.200
     9.835   139.355     0.200
     9.856   139.152     0.200
     9.916   139.703     0.200
     9.992   141.035     0.200
     9.985   142.152     0.200
    10.026   143.574     0.200
    10.046   141.605     0.200
    10.096   142.363     0.200
    10.207   143.234     0.200
    10.197   144.824     0.200
    10.225   143.805     0.200
    10.345   145.625     0.200
    10.427   146.914     0.200
    10.461   149.004     0.200
    10.461   149.164     0.200
    10.523   147.984     0.200
    10.551   149.473     0.200
    10.689   150.773     0.200
    10.743   152.305     0.200
    10.926   153.934     0.200
    10.940   153.703     0.200
    11.006   154.863     0.200
    11.039   155.383     0.200
    11.222   157.633     0.200
    11.388   159.164     0.200
    11.679   161.703     0.200
    11.860   166.312     0.200
    12.259   173.004     0.200
    12.232   168.004     0.200
    12.501   173.652     0.200
    13.561   189.152     0.200
    14.142   196.934     0.200
    14.346   199.926     0.200
    14.420   200.285     0.200
    14.493   202.055     0.200
    14.565   204.105     0.200
    14.699   205.074     0.200
    15.060   210.215     0.200
    15.260   211.426     0.200
    15.723   220.645     0.200
    16.428   230.766     0.200
    16.880   235.043     0.200
    17.512   240.715     0.200
     1.153    20.215     0.200
     1.751    29.703     0.200
     1.759    30.184     0.200
     1.942    33.086     0.200
     1.955    32.824     0.200
     1.967    32.727     0.200
     2.140    33.895     0.200
     2.406    37.445     0.200
     2.445    40.195     0.200
     2.565    42.145     0.200
     2.632    42.676     0.200
     2.806    44.445     0.200
     2.793    44.906     0.200
     2.875    46.184     0.200
     3.578    55.375     0.200
     3.832    58.977     0.200
     3.683    57.477     0.200
     3.729    57.594     0.200
     3.917    59.184     0.200
     4.042    60.926     0.200
     4.196    63.793     0.200
     4.494    67.156     0.200
     4.507    67.375     0.200
     4.618    68.453     0.200
     4.655    68.523     0.200
     4.768    71.484     0.200
     4.841    71.574     0.200
     4.918    72.773     0.200
     4.897    72.645     0.200
     5.041    74.656     0.200
     5.076    75.266     0.200
     5.048    75.164     0.200
     5.033    76.594     0.200
     5.229    77.133     0.200
     5.298    77.395     0.200
     5.385    79.195     0.200
     5.673    83.426     0.200
     5.718    83.195     0.200
     5.750    83.855     0.200
     5.896    86.227     0.200
     6.085    89.227     0.200
     6.218    90.984     0.200
     6.394    93.133     0.200
     6.261    92.695     0.200
     6.442    93.746     0.200
     6.627    95.793     0.200
     6.787    98.863     0.200
     6.990    99.984     0.200
     7.109   101.965     0.200
     7.228   104.004     0.200
     7.284   103.816     0.200
     7.247   104.305     0.200
     7.504   108.445     0.200
     7.898   113.336     0.200
     8.018   115.176     0.200
     8.044   115.984     0.200
     8.051   115.695     0.200
     8.104   116.844     0.200
     8.083   117.133     0.200
     8.127   117.414     0.200
     8.098   116.895     0.200
     8.204   116.914     0.200
     8.308   119.215     0.200
     8.341   119.266     0.200
     8.360   119.113     0.200
     8.479   121.355     0.200
     8.617   122.395     0.200
     8.640   123.383     0.200
     8.752   124.914     0.200
     8.781   124.613     0.200
     8.717   124.836     0.200
     8.825   125.316     0.200
     8.962   127.996     0.200
     9.031   128.895     0.200
     9.137   130.043     0.200
     9.302   131.855     0.200
     9.326   133.266     0.200
     9.380   132.805     0.200
     9.411   134.086     0.200
     9.437   134.227     0.200
     9.466   135.465     0.200
     9.540   135.863     0.200
     9.596   134.965     0.200
     9.628   136.574     0.200
     9.637   137.195     0.200
     9.955   142.414     0.200
     9.949   141.766     0.200
     9.983   141.895     0.200
    10.028   142.453     0.200
    10.100   143.883     0.200
    10.139   143.996     0.200
    10.265   145.336     0.200
    10.306   147.926     0.200
    10.475   148.035     0.200
    10.563   148.863     0.200
    10.506   150.195     0.200
    10.679   151.906     0.200
    10.697   153.273     0.200
    10.963   155.133     0.200
    10.915   155.086     0.200
    10.789   154.195     0.200
    10.981   155.195     0.200
    11.056   155.074     0.200
    11.128   156.074     0.200
    11.216   158.824     0.200
    11.346   159.977     0.200
    11.397   159.516     0.200
    11.385   160.445     0.200
    11.574   161.375     0.200
    11.726   164.383     0.200
    11.762   164.793     0.200
    11.769   163.465     0.200
    11.918   166.676     0.200
    11.978   166.824     0.200
    12.136   170.953     0.200
    12.611   175.023     0.200
    12.741   176.883     0.200
    12.868   181.074     0.200
    12.941   181.895     0.200
    13.080   184.184     0.200
    13.560   188.266     0.200
    14.194   196.934     0.200
    14.723   203.773     0.200
    14.793   206.125     0.200
    14.802   205.395     0.200
    14.855   206.926     0.200
    14.995   209.586     0.200
    15.073   209.316     0.200
    15.303   212.477     0.200
    15.341   212.766     0.200
    15.612   215.844     0.200
    15.844   218.805     0.200
    15.933   220.336     0.200
    16.270   224.566     0.200
    16.392   226.043     0.200
    16.991   232.176     0.200
    17.415   238.266     0.200
    17.510   240.094     0.200
    17.584   240.625     0.200
     1.061    19.109     0.200
     1.675    28.391     0.200
     1.673    28.945     0.200
     1.879    31.383     0.200
     2.077    32.898     0.200
     2.341    37.102     0.200
     2.384    38.797     0.200
     2.505    40.922     0.200
     2.574    41.141     0.200
     2.784    41.672     0.200
     2.823    44.586     0.200
     3.427    51.836     0.200
     3.536    53.836     0.200
     3.641    55.547     0.200
     3.780    57.461     0.200
     3.687    56.211     0.200
     3.855    56.266     0.200
     3.861    58.016     0.200
     4.005    59.961     0.200
     4.157    62.000     0.200
     4.231    63.320     0.200
     4.365    65.078     0.200
     4.454    66.062     0.200
     4.509    66.789     0.200
     4.557    67.547     0.200
     4.568    67.352     0.200
     4.633    67.117     0.200
     4.631    68.789     0.200
     4.769    69.438     0.200
     4.814    70.758     0.200
     4.961    73.406     0.200
     5.026    73.992     0.200
     5.040    73.891     0.200
     4.919    73.195     0.200
     5.031    74.695     0.200
     5.165    75.281     0.200
     5.272    75.531     0.200
     5.311    77.180     0.200
     5.604    81.508     0.200
     5.673    81.250     0.200
     5.662    82.461     0.200
     5.812    85.047     0.200
     6.025    87.109     0.200
     6.139    89.383     0.200
     6.146    90.758     0.200
     6.322    90.047     0.200
     6.357    92.430     0.200
     6.358    92.516     0.200
     6.671    96.016     0.200
     6.655    96.281     0.200
     6.680    96.117     0.200
     6.736    97.398     0.200
     6.952    99.312     0.200
     7.048   101.172     0.200
     7.153   102.469     0.200
     7.246   101.906     0.200
     8.010   113.172     0.200
     7.997   114.531     0.200
     8.031   114.469     0.200
     8.007   114.320     0.200
     8.241   116.727     0.200
     8.300   117.727     0.200
     8.401   118.859     0.200
     8.597   120.742     0.200
     8.924   125.188     0.200
     8.947   126.883     0.200
     9.056   127.906     0.200
     9.261   130.891     0.200
     9.351   132.250     0.200
     9.365   131.906     0.200
     9.403   131.969     0.200
     9.405   133.117     0.200
     9.564   133.570     0.200
     9.584   135.000     0.200
     9.746   137.062     0.200
     9.876   140.227     0.200
     9.942   140.195     0.200
    10.008   141.586     0.200
    10.067   141.758     0.200
    10.230   143.336     0.200
    10.446   145.812     0.200
    10.540   147.859     0.200
    10.820   151.859     0.200
    10.755   152.359     0.200
    10.942   154.031     0.200
    10.957   154.422     0.200
    11.026   154.727     0.200
    11.059   154.898     0.200
    11.091   155.508     0.200
    11.318   158.797     0.200
    11.354   159.312     0.200
    11.403   160.133     0.200
    11.553   161.906     0.200
    11.576   161.711     0.200
    11.708   164.469     0.200
    11.739   164.727     0.200
    11.842   166.820     0.200
    11.926   167.836     0.200
    11.992   168.219     0.200
    12.270   172.422     0.200
    12.529   173.852     0.200
    12.561   174.297     0.200
    12.704   176.000     0.200
    13.564   187.859     0.200
    13.721   191.289     0.200
    13.715   189.922     0.200
    13.924   192.750     0.200
    14.421   198.719     0.200
    14.384   200.188     0.200
    14.497   199.859     0.200
    14.759   204.266     0.200
    14.811   205.047     0.200
    14.961   207.281     0.200
     1.072    19.453     0.200
     1.072    19.594     0.200
     1.695    29.180     0.200
     1.803    30.797     0.200
     1.883    32.016     0.200
     1.880    32.039     0.200
     2.100    33.969     0.200
     2.363    37.930     0.200
     2.595    40.805     0.200
     2.595    41.375     0.200
     2.493    40.008     0.200
     2.493    41.109     0.200
     2.662    42.195     0.200
     2.662    42.484     0.200
     2.693    42.953     0.200
     2.693    43.156     0.200
     2.561    41.273     0.200
     2.808    42.547     0.200
     2.721    44.148     0.200
     2.809    45.125     0.200
     2.909    45.625     0.200
     2.909    46.844     0.200
     3.520    53.906     0.200
     3.624    55.898     0.200
     3.624    56.484     0.200
     3.642    56.188     0.200
     3.642    56.312     0.200
     3.879    57.953     0.200
     3.670    55.766     0.200
     3.885    58.969     0.200
     3.987    60.438     0.200
     4.087    62.398     0.200
     4.140    63.195     0.200
     4.213    63.914     0.200
     4.213    64.273     0.200
     4.477    66.812     0.200
     4.532    67.859     0.200
     4.581    68.133     0.200
     4.592    68.250     0.200
     4.657    68.055     0.200
     4.657    68.328     0.200
     4.744    70.625     0.200
     4.790    70.703     0.200
     4.895    72.047     0.200
     4.832    71.273     0.200
     5.017    73.797     0.200
     5.017    74.000     0.200
     5.049    74.312     0.200
     5.049    74.555     0.200
     4.976    73.188     0.200
     5.187    75.727     0.200
     5.296    76.750     0.200
     5.331    79.156     0.200
     5.625    82.727     0.200
     5.697    83.523     0.200
     5.676    83.297     0.200
     5.830    85.438     0.200
     6.048    87.984     0.200
     6.214    88.914     0.200
     6.343    91.445     0.200
     6.695    96.680     0.200
     6.677    96.344     0.200
     6.699    97.250     0.200
     6.976   100.055     0.200
     7.071   102.164     0.200
     7.173   103.344     0.200
     7.270   103.164     0.200
     7.172   103.008     0.200
     7.308   103.938     0.200
     7.326   105.578     0.200
     7.397   106.430     0.200
     7.839   112.656     0.200
     8.033   114.297     0.200
     8.034   114.406     0.200
     8.013   115.695     0.200
     8.051   115.258     0.200
     8.085   116.234     0.200
     8.020   115.500     0.200
     8.263   118.586     0.200
     8.322   118.859     0.200
     8.420   120.250     0.200
     8.621   122.062     0.200
     8.710   124.930     0.200
     8.643   124.500     0.200
     8.777   125.047     0.200
     8.948   127.438     0.200
     8.901   128.688     0.200
     9.285   132.156     0.200
     9.271   132.734     0.200
     9.375   133.195     0.200
     9.389   133.086     0.200
     9.588   134.383     0.200
     9.770   138.656     0.200
     9.770   138.125     0.200
     9.897   140.312     0.200
     9.966   140.844     0.200
    10.032   142.227     0.200
    10.455   149.383     0.200
    10.737   154.094     0.200
    10.966   155.133     0.200
    10.981   154.203     0.200
    11.260   159.406     0.200
    11.427   160.656     0.200
    11.732   165.477     0.200
    12.016   169.125     0.200
    12.293   174.258     0.200
    12.288   169.578     0.200
    12.877   181.695     0.200
    13.095   184.133     0.200
    12.973   182.883     0.200
    13.586   189.078     0.200
    14.443   201.328     0.200
    14.520   202.453     0.200
    16.458   228.195     0.200
     1.514    25.914     0.200
     1.621    27.984     0.200
     1.566    27.664     0.200
     1.701    29.375     0.200
     1.759    29.930     0.200
     1.928    30.531     0.200
     2.188    35.375     0.200
     2.346    38.422     0.200
     2.489    39.891     0.200
     2.469    40.352     0.200
     2.541    40.930     0.200
     2.705    40.344     0.200
     2.697    43.250     0.200
     2.804    44.539     0.200
     2.902    45.789     0.200
     3.537    53.602     0.200
     3.718    56.531     0.200
     3.765    54.750     0.200
     3.640    55.570     0.200
     3.685    55.383     0.200
     4.015    60.383     0.200
     4.112    61.672     0.200
     4.163    62.250     0.200
     4.312    64.141     0.200
     4.241    63.695     0.200
     4.371    65.109     0.200
     4.423    65.477     0.200
     4.433    65.609     0.200
     4.495    66.844     0.200
     4.534    65.734     0.200
     4.610    68.016     0.200
     4.651    68.477     0.200
     4.738    69.312     0.200
     4.859    71.352     0.200
     4.798    70.703     0.200
     4.907    72.055     0.200
     4.938    73.453     0.200
     5.013    73.586     0.200
     5.020    74.562     0.200
     5.167    74.281     0.200
     5.151    75.211     0.200
     5.542    80.383     0.200
     5.499    80.477     0.200
     5.648    82.445     0.200
     5.977    87.273     0.200
     6.163    89.633     0.200
     6.193    89.859     0.200
     6.172    89.984     0.200
     6.198    90.555     0.200
     6.257    91.875     0.200
     6.390    92.242     0.200
     6.501    94.352     0.200
     6.533    93.883     0.200
     6.517    94.320     0.200
     6.463    94.000     0.200
     6.829    97.461     0.200
     6.898    99.172     0.200
     6.996    99.273     0.200
     6.996   100.406     0.200
     7.123   100.531     0.200
     7.162   101.352     0.200
     7.218   102.789     0.200
     7.658   109.594     0.200
     7.764   110.820     0.200
     7.889   112.477     0.200
     7.882   111.242     0.200
     7.833   111.602     0.200
     7.871   112.281     0.200
     7.848   112.156     0.200
     7.910   113.000     0.200
     8.040   114.500     0.200
     8.086   115.820     0.200
     8.146   116.875     0.200
     8.151   115.383     0.200
     8.238   116.711     0.200
     8.466   120.031     0.200
     8.466   121.016     0.200
     8.643   122.383     0.200
     8.627   122.891     0.200
     8.801   123.594     0.200
     8.783   125.023     0.200
     8.893   125.742     0.200
     9.133   128.375     0.200
     9.090   128.070     0.200
     9.240   129.562     0.200
     9.233   129.602     0.200
     9.284   129.977     0.200
     9.256   130.531     0.200
     9.316   133.305     0.200
     9.317   132.820     0.200
     9.450   131.453     0.200
     9.454   132.664     0.200
     9.636   134.664     0.200
     9.742   137.094     0.200
     9.815   138.141     0.200
     9.909   139.852     0.200
    10.009   140.680     0.200
    10.110   141.727     0.200
    10.079   142.945     0.200
    10.262   143.961     0.200
    10.336   144.727     0.200
    10.438   145.484     0.200
    10.433   147.000     0.200
    10.487   148.453     0.200
    10.684   150.227     0.200
    10.853   152.727     0.200
    10.767   152.430     0.200
    10.913   153.484     0.200
    10.949   154.305     0.200
    10.964   155.664     0.200
    10.987   154.422     0.200
    11.141   157.172     0.200
    11.208   156.414     0.200
    11.147   156.984     0.200
    11.224   157.672     0.200
    11.306   159.625     0.200
    11.452   160.391     0.200
    11.429   160.359     0.200
    11.612   163.375     0.200
    11.635   163.273     0.200
    11.707   164.711     0.200
    11.764   165.070     0.200
    11.827   165.672     0.200
    11.958   168.039     0.200
    12.397   172.953     0.200
    12.422   173.305     0.200
    12.583   175.641     0.200
    12.990   182.766     0.200
    12.998   181.492     0.200
    13.502   187.844     0.200
     0.379    10.211     0.200
     0.390    10.188     0.200
     1.026    19.094     0.200
     1.679    29.039     0.200
     1.875    31.719     0.200
     2.431    39.547     0.200
     2.623    41.688     0.200
     2.695    41.758     0.200
     2.879    44.883     0.200
     2.978    47.094     0.200
     3.342    50.469     0.200
     3.601    54.602     0.200
     3.765    54.742     0.200
     3.751    56.008     0.200
     4.073    60.789     0.200
     4.073    60.391     0.200
     4.172    62.031     0.200
     4.478    66.289     0.200
     4.690    69.078     0.200
     4.747    70.023     0.200
     4.903    72.617     0.200
     5.080    75.070     0.200
     5.234    75.094     0.200
     5.582    80.672     0.200
     5.606    82.039     0.200
     5.746    83.469     0.200
     6.220    92.492     0.200
     6.572    94.320     0.200
     6.581    95.039     0.200
     6.860    97.852     0.200
     7.154   100.398     0.200
     7.916   110.961     0.200
     7.918   111.359     0.200
     7.936   112.812     0.200
     7.953   112.539     0.200
     7.979   113.031     0.200
     8.159   115.250     0.200
     8.213   116.492     0.200
     8.328   118.172     0.200
     8.477   120.852     0.200
     8.505   119.352     0.200
     8.575   121.602     0.200
     8.604   122.320     0.200
     8.661   123.141     0.200
     8.682   123.641     0.200
     8.986   127.070     0.200
     9.175   129.648     0.200
     9.259   130.953     0.200
     9.274   131.914     0.200
     9.319   131.641     0.200
     9.391   133.328     0.200
     9.493   133.367     0.200
     9.654   136.008     0.200
     9.850   139.000     0.200
     9.916   139.750     0.200
    10.138   142.117     0.200
    10.269   145.461     0.200
    10.449   146.617     0.200
    10.764   150.688     0.200
    10.825   152.484     0.200
    10.865   152.242     0.200
    11.068   156.367     0.200
    11.625   161.047     0.200
    12.471   172.352     0.200
    13.479   187.234     0.200
    14.620   202.031     0.200
    14.720   203.820     0.200
    14.843   205.867     0.200
    14.980   208.328     0.200
    15.484   214.422     0.200
    15.642   216.258     0.200
    15.707   217.359     0.200
    15.802   218.758     0.200
    16.118   221.633     0.200
    16.254   223.922     0.200
    16.854   231.039     0.200
    17.273   235.930     0.200
    17.371   236.648     0.200
    17.449   237.508     0.200
     0.336     9.016     0.200
     0.347     8.961     0.200
     0.973    17.859     0.200
     0.973    18.047     0.200
     1.556    26.336     0.200
     1.631    28.250     0.200
     1.746    29.781     0.200
     1.825    30.469     0.200
     1.957    31.227     0.200
     2.220    35.359     0.200
     2.452    38.734     0.200
     2.398    39.102     0.200
     2.519    39.805     0.200
     2.549    40.227     0.200
     2.549    40.398     0.200
     2.692    40.359     0.200
     2.692    40.625     0.200
     2.521    40.305     0.200
     2.521    40.891     0.200
     2.619    41.586     0.200
     2.592    41.320     0.200
     2.749    43.438     0.200
     2.851    45.125     0.200
     2.851    45.289     0.200
     2.950    46.367     0.200
     2.950    46.617     0.200
     3.306    50.297     0.200
     3.598    54.508     0.200
     3.661    55.820     0.200
     3.757    55.258     0.200
     3.578    54.961     0.200
     3.578    54.516     0.200
     3.698    56.516     0.200
     3.727    56.625     0.200
     3.752    56.938     0.200
     4.053    60.555     0.200
     4.247    63.258     0.200
     4.151    61.984     0.200
     4.203    62.602     0.200
     4.329    64.102     0.200
     4.334    64.375     0.200
     4.279    64.039     0.200
     4.451    65.891     0.200
     4.530    65.461     0.200
     4.530    65.867     0.200
     4.513    67.086     0.200
     4.602    68.148     0.200
     4.649    68.664     0.200
     4.754    69.516     0.200
     4.700    69.211     0.200
     4.876    71.414     0.200
     4.923    72.008     0.200
     4.853    71.008     0.200
     4.973    73.102     0.200
     5.044    73.758     0.200
     5.166    74.578     0.200
     5.166    74.188     0.200
     5.055    74.609     0.200
     5.191    74.531     0.200
     5.488    80.047     0.200
     5.557    80.188     0.200
     5.555    81.211     0.200
     5.698    83.016     0.200
     5.905    85.680     0.200
     6.022    87.914     0.200
     6.202    89.406     0.200
     6.205    90.859     0.200
     6.258    91.102     0.200
     6.415    91.078     0.200
     6.554    94.531     0.200
     6.553    94.125     0.200
     6.534    92.961     0.200
     6.617    95.656     0.200
     6.563    94.109     0.200
     6.526    95.258     0.200
     6.526    93.938     0.200
     6.787    98.016     0.200
     6.839    97.391     0.200
     6.927    99.336     0.200
     7.016   100.477     0.200
     7.054   101.484     0.200
     7.034   100.477     0.200
     7.133   100.781     0.200
     7.171   101.625     0.200
     7.052   100.539     0.200
     7.183   103.000     0.200
     7.314   104.695     0.200
     7.271   103.680     0.200
     7.781   109.398     0.200
     7.846   110.359     0.200
     7.896   110.734     0.200
     7.895   110.797     0.200
     7.946   113.391     0.200
     7.911   111.609     0.200
     7.886   112.320     0.200
     8.051   113.391     0.200
     7.908   112.281     0.200
     8.120   115.047     0.200
     8.168   115.516     0.200
     8.179   115.336     0.200
     8.283   117.000     0.200
     8.449   118.602     0.200
     8.481   119.070     0.200
     8.645   121.188     0.200
     8.523   120.477     0.200
     8.650   122.117     0.200
     8.809   123.289     0.200
     8.811   123.570     0.200
     8.834   125.289     0.200
     8.940   126.375     0.200
     9.146   128.391     0.200
     9.243   129.531     0.200
     9.132   129.391     0.200
     9.249   130.211     0.200
     9.291   129.516     0.200
     9.285   133.625     0.200
     9.455   131.625     0.200
     9.468   132.664     0.200
     9.440   133.641     0.200
     9.639   135.555     0.200
     9.827   137.711     0.200
     9.906   139.398     0.200
     9.957   140.219     0.200
    10.079   140.641     0.200
    10.118   141.758     0.200
    10.806   151.891     0.200
    11.019   155.258     0.200
    11.238   156.734     0.200
    11.146   158.211     0.200
    11.450   159.406     0.200
    11.517   162.906     0.200
    11.725   163.555     0.200
    11.772   164.055     0.200
    12.145   167.227     0.200
    12.145   167.406     0.200
    12.145   167.227     0.200
    12.442   171.516     0.200
    14.144   198.258     0.200
     0.992    18.203     0.200
     1.613    28.023     0.200
     1.801    29.969     0.200
     1.816    30.258     0.200
     2.026    32.797     0.200
     2.286    36.648     0.200
     2.348    37.914     0.200
     2.348    38.102     0.200
     2.470    39.984     0.200
     2.470    40.211     0.200
     2.539    40.469     0.200
     2.587    40.898     0.200
     2.769    40.680     0.200
     2.698    42.969     0.200
     2.794    44.211     0.200
     2.893    45.352     0.200
     3.374    50.602     0.200
     3.516    53.383     0.200
     3.619    55.250     0.200
     3.619    55.531     0.200
     3.636    55.383     0.200
     3.636    55.742     0.200
     3.665    55.641     0.200
     3.735    57.008     0.200
     3.835    55.859     0.200
     3.813    57.789     0.200
     3.921    59.070     0.200
     3.921    59.281     0.200
     3.988    59.547     0.200
     4.139    61.742     0.200
     4.214    63.383     0.200
     4.404    65.297     0.200
     4.407    65.633     0.200
     4.464    66.102     0.200
     4.464    66.578     0.200
     4.525    66.242     0.200
     4.609    66.680     0.200
     4.709    69.914     0.200
     4.829    70.734     0.200
     4.749    69.570     0.200
     4.906    72.984     0.200
     4.981    73.438     0.200
     4.988    73.234     0.200
     4.988    73.734     0.200
     4.893    72.602     0.200
     5.017    74.281     0.200
     5.111    74.430     0.200
     5.245    74.539     0.200
     5.251    77.484     0.200
     5.546    81.320     0.200
     5.633    80.711     0.200
     5.593    81.672     0.200
     5.747    84.562     0.200
     5.974    87.492     0.200
     6.076    89.070     0.200
     6.222    90.180     0.200
     6.263    90.531     0.200
     6.291    91.609     0.200
     6.289    91.703     0.200
     6.497    93.797     0.200
     6.627    94.984     0.200
     6.600    94.133     0.200
     6.616    95.109     0.200
     6.916    97.531     0.200
     6.996    99.633     0.200
     7.090   101.469     0.200
     7.209   101.344     0.200
     7.089   101.719     0.200
     7.757   111.008     0.200
     7.918   111.672     0.200
     7.974   112.797     0.200
     7.971   112.359     0.200
     7.929   113.719     0.200
     7.971   114.094     0.200
     8.008   114.344     0.200
     7.938   114.281     0.200
     8.186   117.203     0.200
     8.241   117.547     0.200
     8.248   117.250     0.200
     8.338   118.961     0.200
     8.523   120.578     0.200
     8.556   121.000     0.200
     8.560   121.414     0.200
     8.722   123.828     0.200
     8.887   125.188     0.200
     8.888   125.398     0.200
     8.907   126.672     0.200
     8.881   125.609     0.200
     8.992   127.367     0.200
     9.222   129.000     0.200
     9.190   130.023     0.200
     9.321   130.367     0.200
     9.324   130.844     0.200
     9.369   132.602     0.200
     9.354   132.789     0.200
     9.532   133.133     0.200
     9.544   134.633     0.200
     9.817   138.609     0.200
    10.179   143.852     0.200
    10.209   144.242     0.200
    10.531   149.250     0.200
    10.672   150.023     0.200
    10.740   150.930     0.200
    10.846   150.641     0.200
    11.063   156.414     0.200
    11.247   158.117     0.200
    11.456   160.898     0.200
    11.507   161.367     0.200
    11.556   162.812     0.200
    11.664   161.523     0.200
    12.064   169.234     0.200
    13.033   182.078     0.200
    13.629   188.922     0.200
    15.719   218.672     0.200
    16.144   222.938     0.200
    16.301   224.484     0.200
    16.423   224.539     0.200
    16.902   233.914     0.200
     1.496    26.414     0.200
     1.692    28.086     0.200
     1.927    30.711     0.200
     2.182    35.039     0.200
     2.278    37.391     0.200
     2.415    38.289     0.200
     2.485    39.539     0.200
     2.485    40.117     0.200
     2.402    38.984     0.200
     2.629    41.414     0.200
     2.629    42.391     0.200
     2.746    40.188     0.200
     2.746    41.016     0.200
     2.738    43.430     0.200
     2.738    43.805     0.200
     2.837    44.695     0.200
     2.837    45.445     0.200
     3.272    48.969     0.200
     3.475    52.484     0.200
     3.475    52.617     0.200
     3.576    54.188     0.200
     3.576    54.719     0.200
     3.593    54.797     0.200
     3.623    55.000     0.200
     3.649    55.695     0.200
     3.801    55.188     0.200
     3.801    55.938     0.200
     3.955    58.188     0.200
     3.955    58.805     0.200
     4.181    62.609     0.200
     4.317    64.211     0.200
     4.324    64.078     0.200
     4.434    65.469     0.200
     4.442    65.398     0.200
     4.565    65.188     0.200
     4.565    65.609     0.200
     4.594    68.297     0.200
     4.621    68.398     0.200
     4.758    70.969     0.200
     4.919    72.297     0.200
     4.880    72.164     0.200
     4.988    73.688     0.200
     5.020    74.609     0.200
     5.020    74.938     0.200
     5.132    76.078     0.200
     5.195    74.898     0.200
     5.195    74.367     0.200
     5.434    79.758     0.200
     5.434    80.305     0.200
     5.463    79.766     0.200
     5.458    80.211     0.200
     5.555    81.117     0.200
     5.617    82.727     0.200
     5.875    85.398     0.200
     5.952    87.281     0.200
     6.148    89.125     0.200
     6.159    89.375     0.200
     6.159    90.156     0.200
     6.152    90.617     0.200
     6.201    90.477     0.200
     6.393    92.984     0.200
     6.393    93.617     0.200
     6.491    94.484     0.200
     6.491    94.609     0.200
     6.543    94.508     0.200
     6.778    97.914     0.200
     6.847    97.680     0.200
     6.954   100.516     0.200
     6.974   100.859     0.200
     7.039   101.164     0.200
     7.181   101.570     0.200
     7.181   102.969     0.200
     7.267   104.797     0.200
     7.634   109.711     0.200
     7.806   111.547     0.200
     7.797   112.617     0.200
     7.829   112.000     0.200
     7.854   112.609     0.200
     7.897   111.516     0.200
     7.908   112.031     0.200
     7.902   113.844     0.200
     7.928   112.758     0.200
     8.076   115.547     0.200
     8.150   115.438     0.200
     8.214   117.078     0.200
     8.424   120.891     0.200
     8.479   119.664     0.200
     8.668   122.797     0.200
     8.751   125.156     0.200
     8.819   123.508     0.200
     8.865   126.039     0.200
     8.879   127.484     0.200
     8.879   126.969     0.200
     9.045   129.789     0.200
     9.071   128.969     0.200
     9.147   128.445     0.200
     9.244   130.078     0.200
     9.264   130.258     0.200
     9.305   129.648     0.200
     9.466   132.539     0.200
     9.472   132.031     0.200
     9.661   136.188     0.200
     9.661   134.984     0.200
     9.700   138.055     0.200
     9.737   138.750     0.200
     9.829   138.336     0.200
     9.940   140.680     0.200
     9.973   140.461     0.200
    10.037   141.539     0.200
    10.007   142.859     0.200
    10.130   141.680     0.200
    10.175   143.414     0.200
    10.427   148.289     0.200
    10.427   150.695     0.200
    10.752   151.289     0.200
    11.174   156.781     0.200
    11.644   163.711     0.200
    12.125   167.539     0.200
    12.125   167.938     0.200
    12.199   170.906     0.200
    12.204   170.867     0.200
    12.222   172.188     0.200
    12.620   175.625     0.200
    13.462   187.828     0.200
    13.549   187.977     0.200
    13.637   190.570     0.200
    13.967   196.297     0.200
    14.004   195.289     0.200
    14.001   198.398