#!/bin/bash
gmt begin simeonof10.15_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source simeonof10.15'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0 -10.0
  1.0 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.651     0.932     0.200
     0.848     0.505     0.200
     0.711     0.154     0.200
     0.837     0.501     0.200
     0.802     0.268     0.200
     0.669     0.056     0.200
     0.615     0.079     0.200
     0.778     0.524     0.200
     0.803    -0.526     0.200
     0.562    -0.386     0.200
     0.901     0.071     0.200
     0.732    -0.433     0.200
     0.276    -0.260     0.200
     0.694     0.389     0.200
     0.294    -0.205     0.200
     0.710     0.008     0.200
     0.777    -0.206     0.200
     0.679    -0.211     0.200
     0.686    -0.419     0.200
     0.970     0.361     0.200
     0.996     0.520     0.200
     0.614     0.350     0.200
     0.616     0.126     0.200
     0.552    -0.240     0.200
     0.810    -0.655     0.200
     0.820    -0.326     0.200
     0.896     0.556     0.200
     0.320    -0.228     0.200
     0.718    -0.407     0.200
     0.857    -0.061     0.200
     0.749    -0.155     0.200
     0.647    -0.139     0.200
     0.506     0.050     0.200
     0.856     0.889     0.200
     0.996    -0.175     0.200
     0.801    -0.597     0.200
     0.955     0.370     0.200
     0.980     0.360     0.200
     0.973    -0.120     0.200
     0.635    -0.271     0.200
     0.842     0.212     0.200
     0.579    -0.022     0.200
     0.721    -0.177     0.200
     0.728    -0.355     0.200
     0.899    -0.623     0.200
     0.988    -0.435     0.200
     0.452    -0.230     0.200
     0.553    -0.191     0.200
     0.357     0.054     0.200
     0.702     0.197     0.200
     0.341    -0.202     0.200
     0.700    -0.112     0.200
     0.145     0.454     0.200
     0.619    -0.507     0.200
     0.845    -0.411     0.200
     0.967    -0.485     0.200
     0.647    -0.068     0.200
     0.724    -0.184     0.200
     0.936    -0.178     0.200
     0.839    -0.138     0.200
     0.844    -0.225     0.200
     0.975    -0.321     0.200
     0.205    -0.178     0.200
     0.207    -0.245     0.200
     0.059    -0.017     0.200
     0.050    -0.084     0.200
     0.786    -0.300     0.200
     0.589    -0.192     0.200
     0.590    -0.184     0.200
     0.591    -0.266     0.200
     0.847     0.263     0.200
     0.855     0.125     0.200
     0.858     0.324     0.200
     0.844     0.447     0.200
     0.307    -0.205     0.200
     0.318    -0.403     0.200
     0.499    -0.191     0.200
     0.394     0.066     0.200
     0.406    -0.125     0.200
     0.607    -1.348     0.200
     0.808    -0.484     0.200
     0.807    -0.538     0.200
     0.807    -0.706     0.200
     0.699     0.344     0.200
     0.706     0.263     0.200
     0.922    -0.677     0.200
     0.570    -0.174     0.200
     0.570    -0.142     0.200
     0.688    -0.291     0.200
     0.698    -0.124     0.200
     0.888     0.024     0.200
     0.893     0.063     0.200
     0.641     0.024     0.200
     0.595     0.136     0.200
     0.187    -0.055     0.200
     0.194    -0.195     0.200
     0.757    -0.144     0.200
     0.261     0.056     0.200
     0.263     0.019     0.200
     0.881    -0.466     0.200
     0.568     0.077     0.200
     0.570     0.068     0.200
     0.222    -0.094     0.200
     0.218     0.005     0.200
     0.690    -0.166     0.200
     0.690     0.254     0.200
     0.194    -0.322     0.200
     0.193    -0.317     0.200
     0.885    -0.206     0.200
     0.885    -0.016     0.200
     0.777    -0.165     0.200
     0.777     0.007     0.200
     0.536    -1.200     0.200
     0.632    -0.400     0.200
     0.751     0.138     0.200
     0.851    -0.461     0.200
     0.231    -0.081     0.200
     0.809    -0.284     0.200
     0.809    -0.053     0.200
     0.231     0.019     0.200
     0.229    -0.438     0.200
     0.645    -0.097     0.200
     0.645     0.123     0.200
     0.259    -0.165     0.200
     0.270    -0.277     0.200
     0.911    -0.245     0.200
     0.911    -0.436     0.200
     0.860     0.013     0.200
     0.865    -0.108     0.200
     0.991     0.034     0.200
     0.991    -0.226     0.200
     0.878    -0.097     0.200
     0.883    -0.048     0.200
     0.842     0.769     0.200
     0.986    -0.113     0.200
     0.986     0.086     0.200
     0.877    -0.174     0.200
     0.883    -0.226     0.200
     0.234     0.050     0.200
     0.243    -0.070     0.200
     0.825    -0.221     0.200
     0.346    -0.158     0.200
     0.541     0.060     0.200
     0.324    -0.045     0.200
     0.879    -0.579     0.200
     0.883    -0.374     0.200
     0.883    -0.011     0.200
     0.720    -0.847     0.200
     0.720    -0.621     0.200
     0.874    -0.570     0.200
     0.878    -0.461     0.200
     0.916     0.078     0.200
     0.995     0.702     0.200
     0.711     0.152     0.200
     0.715    -0.071     0.200
     0.715     0.179     0.200
     0.848    -0.287     0.200
     0.848     0.014     0.200
     0.209     0.035     0.200
     0.215    -0.058     0.200
     0.726    -0.005     0.200
     0.579     0.049     0.200
     0.580    -0.276     0.200
     0.228    -0.372     0.200
     0.228    -0.224     0.200
     0.239    -0.356     0.200
     0.609    -0.139     0.200
     0.609    -0.280     0.200
     0.868     0.415     0.200
     0.299     0.003     0.200
     0.536    -0.151     0.200
     0.683    -0.075     0.200
     0.824    -0.088     0.200
     0.931     0.236     0.200
     0.059    -1.745     0.200
     0.153    -1.107     0.200
     0.172    -0.238     0.200
     0.249    -0.598     0.200
     0.308    -1.733     0.200
     0.311    -0.989     0.200
     0.857    -1.695     0.200
     0.541    -0.104     0.200
     0.882    -0.111     0.200
     0.275    -1.677     0.200
     0.374    -1.465     0.200
     0.372    -0.885     0.200
     0.478    -0.995     0.200
     0.499    -0.999     0.200
     0.485    -0.628     0.200
     0.515    -0.560     0.200
     0.578    -0.445     0.200
     0.998    -2.263     0.200
     0.621    -0.079     0.200
     0.624    -0.359     0.200
     0.684     0.012     0.200
     0.543    -0.204     0.200
     0.543    -0.103     0.200
     0.544    -0.050     0.200
     0.643    -0.381     0.200
     0.643    -0.213     0.200
     0.644    -0.244     0.200
     0.764    -0.031     0.200
     0.708     0.052     0.200
     0.705    -0.049     0.200
     0.848     0.820     0.200
     0.689    -0.175     0.200
     0.690    -0.365     0.200
     0.705    -0.265     0.200
     0.705     0.083     0.200
     0.636    -0.134     0.200
     0.634    -0.161     0.200
     0.693    -0.087     0.200
     0.853     0.379     0.200
     0.985     0.238     0.200
     0.974     0.215     0.200
     0.704     0.232     0.200
     0.708    -0.170     0.200
     0.477    -0.457     0.200
     0.482     0.314     0.200
     0.969    -0.298     0.200
     0.969    -0.468     0.200
     0.487    -0.251     0.200
     0.487     0.032     0.200
     0.560     0.002     0.200
     0.560     0.172     0.200
     0.246     0.432     0.200
     0.255    -0.307     0.200
     0.812     0.252     0.200
     0.812     0.002     0.200
     0.757    -0.261     0.200
     0.874    -0.483     0.200
     0.915     0.129     0.200
     0.804    -0.011     0.200
     0.466    -0.415     0.200
     0.465    -0.225     0.200
     0.586    -0.177     0.200
     0.586     0.022     0.200
     0.934     0.575     0.200
     0.498     0.023     0.200
     0.498    -0.087     0.200
     0.503    -0.217     0.200
     0.981    -0.738     0.200
     0.981    -0.637     0.200
     0.388     0.063     0.200
     0.392    -0.317     0.200
     0.392     0.090     0.200
     0.686    -0.046     0.200
     0.686     0.133     0.200
     0.239     0.152     0.200
     0.821    -0.532     0.200
     0.746     0.858     0.200
     0.912    -0.210     0.200
     0.902     1.121     0.200
     0.925     0.750     0.200
     0.958     0.637     0.200
     0.880    -0.171     0.200
     0.880     0.137     0.200
     0.847     0.017     0.200
     0.850    -0.339     0.200
     0.828     0.364     0.200
     0.976     0.278     0.200
     0.985     0.290     0.200
     0.990     0.145     0.200
     0.974    -0.129     0.200
     0.987     0.035     0.200
     0.737    -0.195     0.200
     0.692     0.025     0.200
     0.733     0.271     0.200
     0.851    -0.389     0.200
     0.884     0.405     0.200
     0.894     0.228     0.200
     0.878    -0.118     0.200
     0.891     0.098     0.200
     0.931     0.186     0.200
     0.174     0.135     0.200
     0.579    -0.300     0.200
     0.579    -0.100     0.200
     0.586     0.042     0.200
     0.591     0.109     0.200
     0.813    -0.135     0.200
     0.813    -0.274     0.200
     0.238    -0.232     0.200
     0.821    -0.602     0.200
     0.766     0.335     0.200
     0.891    -0.535     0.200
     0.917    -0.180     0.200
     0.919     0.550     0.200
     0.930     0.248     0.200
     0.902     0.068     0.200
     0.917     0.276     0.200
     0.969     0.236     0.200
     0.450    -0.603     0.200
     0.451    -0.198     0.200
     0.513     0.034     0.200
     0.915    -0.099     0.200
     0.977    -0.088     0.200
     0.980    -0.025     0.200
     0.341    -0.155     0.200
     0.352    -0.350     0.200
     0.535     0.200     0.200
     0.453    -0.426     0.200
     0.454    -0.260     0.200
     0.520     0.036     0.200
     0.520     0.295     0.200
     0.916    -0.225     0.200
     0.978    -0.134     0.200
     0.983    -0.036     0.200
     0.996    -0.176     0.200
     0.830    -0.215     0.200
     0.652    -0.284     0.200
     0.654    -0.632     0.200
     0.519    -0.308     0.200
     0.520    -0.036     0.200
     0.438    -0.657     0.200
     0.440    -0.526     0.200
     0.500     0.095     0.200
     0.500     0.236     0.200
     0.922    -0.257     0.200
     0.979    -0.150     0.200
     0.982    -0.072     0.200
     0.997    -0.157     0.200
     0.832     0.344     0.200
     0.859    -0.132     0.200
     0.859     0.149     0.200
     0.803     0.277     0.200
     0.846    -0.433     0.200
     0.849    -0.655     0.200
     0.960     0.354     0.200
     0.964     0.273     0.200
     0.992     0.330     0.200
     0.953    -0.170     0.200
     0.965     0.237     0.200
     0.817    -0.395     0.200
     0.825    -0.223     0.200
     0.185    -0.276     0.200
     0.189    -0.161     0.200
     0.572     0.232     0.200
     0.428    -0.688     0.200
     0.731     0.010     0.200
     0.635    -0.300     0.200
     0.644     0.245     0.200
     0.814     0.360     0.200
     0.930     0.252     0.200
     0.938     0.262     0.200
     0.857     0.110     0.200
     0.862    -0.013     0.200
     0.966    -0.016     0.200
     0.966     0.132     0.200
     0.929     1.179     0.200
     0.658    -0.107     0.200
     0.658     0.102     0.200
     0.661    -0.569     0.200
     0.660    -0.278     0.200
     0.799     0.343     0.200
     0.913     0.137     0.200
     0.919     0.194     0.200
     0.930     0.200     0.200
     0.994     0.074     0.200
     0.992    -0.021     0.200
     0.632    -0.038     0.200
     0.636    -0.159     0.200
     0.177    -0.038     0.200
     0.183    -0.123     0.200
     0.909    -0.454     0.200
     0.909    -0.193     0.200
     0.873    -0.311     0.200
     0.826     0.468     0.200
     0.877    -0.589     0.200
     0.901    -0.357     0.200
     0.901    -0.117     0.200
     0.976     0.390     0.200
     0.986     0.206     0.200
     0.992     0.167     0.200
     0.966    -0.045     0.200
     0.981     0.132     0.200
     0.141     0.078     0.200
     0.146    -0.215     0.200
     0.713    -0.112     0.200
     0.713    -0.003     0.200
     0.177    -0.483     0.200
     0.181    -0.072     0.200
     0.263    -0.101     0.200
     0.272     0.462     0.200
     0.272     0.063     0.200
     0.864    -0.175     0.200
     0.374     0.397     0.200
     0.385     0.239     0.200
     0.987    -0.193     0.200
     0.452     0.353     0.200
     0.410    -0.296     0.200
     0.421     0.331     0.200
     0.505     0.059     0.200
     0.495     0.495     0.200
     0.506    -0.089     0.200
     0.397     0.201     0.200
     0.333     0.085     0.200
     0.910    -0.669     0.200
     0.539    -0.268     0.200
     0.484     0.080     0.200
     0.348    -0.033     0.200
     0.591     0.136     0.200
     0.430     0.101     0.200
     0.441     0.546     0.200
     0.595     0.068     0.200
     0.605     0.068     0.200
     0.546     0.157     0.200
     0.244     0.248     0.200
     0.254    -0.001     0.200
     0.865    -0.156     0.200
     0.865    -0.352     0.200
     0.450     0.057     0.200
     0.349     0.560     0.200
     0.359     0.285     0.200
     0.972    -0.246     0.200
     0.972    -0.543     0.200
     0.553    -0.187     0.200
     0.563     0.120     0.200
     0.405    -0.012     0.200
     0.288     0.550     0.200
     0.929    -0.166     0.200
     0.929    -0.572     0.200
     0.577     0.022     0.200
     0.587    -0.126     0.200
     0.374     0.137     0.200
     0.983    -0.453     0.200
     0.447     0.358     0.200
     0.335     0.307     0.200
     0.958    -0.901     0.200
     0.343    -0.115     0.200
     0.353    -0.002     0.200
     0.258     0.159     0.200
     0.268    -0.002     0.200
     0.872    -0.476     0.200
     0.872    -0.336     0.200
     0.394    -0.089     0.200
     0.493    -0.141     0.200
     0.504     0.523     0.200
     0.455    -0.058     0.200
     0.466     0.081     0.200
     0.584    -0.030     0.200
     0.590    -0.046     0.200
     0.357    -0.465     0.200
     0.368    -0.192     0.200
     0.621     0.265     0.200
     0.452     0.024     0.200
     0.501    -0.246     0.200
     0.497     0.011     0.200
     0.343     0.028     0.200
     0.352    -0.425     0.200
     0.921    -0.030     0.200
     0.531     0.010     0.200
     0.333     0.222     0.200
     0.927    -0.635     0.200
     0.266     0.318     0.200
     0.886    -0.486     0.200
     0.886    -0.255     0.200
     0.291     0.158     0.200
     0.301    -0.327     0.200
     0.905    -0.364     0.200
     0.558     0.123     0.200
     0.514     0.086     0.200
     0.557     0.176     0.200
     0.567    -0.489     0.200
     0.532     0.089     0.200
     0.532    -0.020     0.200
     0.542    -0.336     0.200
     0.521    -0.031     0.200
     0.532    -0.207     0.200
     0.419    -0.020     0.200
     0.429    -0.312     0.200
     0.610     0.168     0.200
     0.620    -0.185     0.200
     0.571     0.194     0.200
     0.449    -0.439     0.200
     0.459     0.031     0.200
     0.469    -0.330     0.200
     0.568     0.069     0.200
     0.579    -0.040     0.200
     0.461     0.165     0.200
     0.520    -0.179     0.200
     0.520     0.001     0.200
     0.531    -0.539     0.200
     0.358     0.644     0.200
     0.368     0.172     0.200
     0.957    -0.212     0.200
     0.957     0.087     0.200
     0.294     0.299     0.200
     0.926    -0.194     0.200
     0.229    -0.032     0.200
     0.238    -0.252     0.200
     0.837    -0.067     0.200
     0.837     0.193     0.200
     0.386     0.008     0.200
     0.461     0.340     0.200
     0.543     0.035     0.200
     0.613     0.134     0.200
     0.412     0.261     0.200
     0.985    -0.468     0.200
     0.452    -0.191     0.200
     0.568    -0.003     0.200
     0.578    -0.299     0.200
     0.560     0.091     0.200
     0.570    -0.430     0.200
     0.417     0.212     0.200
     0.427    -0.021     0.200
     0.531     0.198     0.200
     0.456    -0.165     0.200
     0.478     0.451     0.200
     0.488     0.103     0.200
     0.301    -0.007     0.200
     0.909    -0.539     0.200
     0.399    -0.109     0.200
     0.303    -0.271     0.200
     0.855    -0.324     0.200
     0.328     0.149     0.200
     0.338    -0.458     0.200
     0.905    -0.472     0.200
     0.579     0.028     0.200
     0.256     0.192     0.200
     0.877    -0.440     0.200
     0.381     0.209     0.200
     0.443     0.051     0.200
     0.480     0.007     0.200
     0.529     0.367     0.200
     0.540     0.225     0.200
     0.383     0.536     0.200
     0.394     0.128     0.200
     0.400     0.533     0.200
     0.411    -0.323     0.200
     0.333     0.032     0.200
     0.941    -0.695     0.200
     0.554     0.206     0.200
     0.509     0.031     0.200
     0.520    -0.396     0.200
     0.626    -0.002     0.200
     0.637    -0.133     0.200
     0.371     0.192     0.200
     0.382    -0.245     0.200
     0.335     0.208     0.200
     0.345     0.225     0.200
     0.949    -0.502     0.200
     0.298     0.020     0.200
     0.922    -0.512     0.200
     0.922    -0.321     0.200
     0.498    -0.105     0.200
     0.509    -0.253     0.200
     0.443     0.450     0.200
     0.752     0.043     0.200
     0.413     0.249     0.200
     0.424    -0.160     0.200
     0.458     0.203     0.200
     0.415     0.329     0.200
     0.999    -0.445     0.200
     0.519     0.200     0.200
     0.530    -0.496     0.200
     0.512     0.418     0.200
     0.567     0.209     0.200
     0.256     0.112     0.200
     0.905    -0.487     0.200
     0.696     0.139     0.200
     0.707    -0.091     0.200
     0.499     0.312     0.200
     0.509     0.001     0.200
     0.373     0.578     0.200
     0.383    -0.056     0.200
     1.000    -0.123     0.200
     1.000    -0.233     0.200
     0.462     0.065     0.200
     0.473     0.150     0.200
     0.337    -0.095     0.200
     0.346    -0.295     0.200
     0.897     0.060     0.200
     0.296     0.490     0.200
     0.307     0.361     0.200
     0.951    -0.668     0.200
     0.349     0.181     0.200
     0.359    -0.089     0.200
     0.971    -0.771     0.200
     0.569     0.250     0.200
     0.580     0.007     0.200
     0.215     0.395     0.200
     0.224    -0.095     0.200
     0.821    -0.112     0.200
     0.821     0.089     0.200
     0.580     0.330     0.200
     0.591     0.067     0.200
     0.453     0.198     0.200
     0.463    -0.122     0.200
     0.430     0.275     0.200
     0.441     0.075     0.200
     0.187    -0.232     0.200
     0.198    -0.207     0.200
     0.860    -0.512     0.200
     0.377     0.224     0.200
     0.386    -0.399     0.200
     0.945    -0.650     0.200
     0.945     0.190     0.200
     0.523    -0.055     0.200
     0.522     0.183     0.200
     0.581    -0.162     0.200
     0.581     0.486     0.200
     0.776     0.040     0.200
     0.513     0.408     0.200
     0.499     0.306     0.200
     0.510     0.117     0.200
     0.659     0.311     0.200
     0.670    -0.198     0.200
     0.767     0.511     0.200
     0.263     0.272     0.200
     0.273     0.144     0.200
     0.878    -0.289     0.200
     0.393    -0.053     0.200
     0.947    -0.025     0.200
     0.328     0.347     0.200
     0.338     0.032     0.200
     0.937    -0.213     0.200
     0.937    -0.103     0.200
     0.568     0.134     0.200
     0.578    -0.143     0.200
     0.316     0.116     0.200
     0.955    -0.316     0.200
     0.955     0.106     0.200
     0.661     0.235     0.200
     0.672     0.006     0.200
     0.673     0.513     0.200
     0.437     0.292     0.200
     0.447     0.000     0.200
     0.304     0.069     0.200
     0.930    -0.695     0.200
     0.930    -0.294     0.200
     0.450    -0.002     0.200
     0.461    -0.076     0.200
     0.518     0.309     0.200
     0.528     0.138     0.200
     0.281     0.058     0.200
     0.884    -0.334     0.200
     0.357     0.546     0.200
     0.368     0.012     0.200
     0.978    -0.394     0.200
     0.978    -0.054     0.200
     0.369    -0.269     0.200
     0.942    -0.308     0.200
     0.274    -0.059     0.200
     0.284    -0.314     0.200
     0.396     0.305     0.200
     0.406     0.010     0.200
     0.978    -0.453     0.200
     0.978    -0.344     0.200
     0.417     0.243     0.200
     0.428    -0.027     0.200
     0.874    -0.060     0.200
     0.922    -0.856     0.200
     0.268    -0.009     0.200
     0.623     0.322     0.200
     0.735     0.312     0.200
     0.746    -0.110     0.200
     0.197     0.114     0.200
     0.207    -0.212     0.200
     0.421     0.673     0.200
     0.431     0.321     0.200
     0.582    -0.203     0.200
     0.693    -0.145     0.200
     0.703     0.284     0.200
     0.365    -0.085     0.200
     0.431     0.256     0.200
     0.442     0.021     0.200
     0.698     0.450     0.200
     0.568    -0.182     0.200
     0.578    -0.032     0.200
     0.359     0.264     0.200
     0.370    -0.227     0.200
     0.943    -0.204     0.200
     0.943    -0.008     0.200
     0.550     0.486     0.200
     0.561    -0.144     0.200
     0.270     0.190     0.200
     0.280    -0.116     0.200
     0.885    -0.600     0.200
     0.885    -0.170     0.200
     0.571     0.342     0.200
     0.582    -0.058     0.200
     0.327     0.242     0.200
     0.336    -0.067     0.200
     0.895    -0.403     0.200
     0.403     0.244     0.200
     0.413    -0.021     0.200
     0.962    -0.361     0.200
     0.962    -0.620     0.200
     0.575     0.456     0.200
     0.586     0.137     0.200
     0.290     0.112     0.200
     0.301    -0.087     0.200
     0.939    -0.127     0.200
     0.159    -0.146     0.200
     0.170    -0.136     0.200
     0.609    -0.226     0.200
     0.609    -0.375     0.200
     0.194     0.076     0.200
     0.203     0.230     0.200
     0.807    -0.516     0.200
     0.807    -0.227     0.200
     0.204    -0.070     0.200
     0.808     0.216     0.200
     0.340     0.311     0.200
     0.350     0.225     0.200
     0.961     0.116     0.200
     0.445     0.067     0.200
     0.456    -0.081     0.200
     0.476    -0.170     0.200
     0.639     0.031     0.200
     0.953    -0.913     0.200
     0.953    -0.951     0.200
     0.221    -0.085     0.200
     0.231    -0.773     0.200
     0.866     0.339     0.200
     0.866    -0.371     0.200
     0.273     0.120     0.200
     0.283    -0.014     0.200
     0.904    -0.081     0.200
     0.330     0.343     0.200
     0.915    -0.467     0.200
     0.170     0.057     0.200
     0.180     0.054     0.200
     0.819    -0.298     0.200
     0.301     0.280     0.200
     0.312    -0.161     0.200
     0.941    -0.391     0.200
     0.253     0.277     0.200
     0.263    -0.272     0.200
     0.469     0.082     0.200
     0.588    -0.870     0.200
     0.588     0.059     0.200
     0.931     0.463     0.200
     0.544     0.248     0.200
     0.554    -0.065     0.200
     0.650    -0.024     0.200
     0.391     0.138     0.200
     0.402     0.083     0.200
     0.221     0.141     0.200
     0.231     0.128     0.200
     0.834    -0.383     0.200
     0.834     0.027     0.200
     0.239     0.323     0.200
     0.834    -0.015     0.200
     0.587     0.100     0.200
     0.591     0.131     0.200
     0.591    -0.182     0.200
     0.598    -0.505     0.200
     0.501     0.355     0.200
     0.208     0.055     0.200
     0.821    -0.322     0.200
     0.491     0.420     0.200
     0.441     0.049     0.200
     0.183    -0.017     0.200
     0.665    -0.217     0.200
     0.777    -0.623     0.200
     0.841     0.068     0.200
     0.254     0.025     0.200
     0.854    -0.203     0.200
     0.634     0.269     0.200
     0.205     0.297     0.200
     0.805    -0.135     0.200
     0.438    -0.247     0.200
     0.729    -0.058     0.200
     0.560    -0.090     0.200
     0.281     0.039     0.200
     0.883    -0.275     0.200
     0.422     0.094     0.200
     0.108    -0.133     0.200
     0.670     0.222     0.200
     0.277     0.260     0.200
     0.875    -0.081     0.200
     0.441     0.047     0.200
     0.162    -0.030     0.200
     0.439     0.135     0.200
     0.426     0.180     0.200
     0.766     0.363     0.200
     0.273     0.177     0.200
     0.863     0.063     0.200
     0.513     0.144     0.200
     0.529     0.073     0.200
     0.414     0.108     0.200
     0.992    -0.317     0.200
     0.645     0.382     0.200
     0.253    -0.006     0.200
     0.887    -0.123     0.200
     0.567    -0.434     0.200
     0.928     0.107     0.200
     0.254    -0.083     0.200
     0.864    -0.204     0.200
     0.380     0.134     0.200
     0.974    -0.499     0.200
     0.615    -0.148     0.200
     0.695     0.300     0.200
     0.508    -0.282     0.200
     0.578     0.018     0.200
     0.578     0.096     0.200
     0.387    -0.164     0.200
     0.560    -0.004     0.200
     0.745     0.865     0.200
     0.972    -0.064     0.200
     0.953     0.297     0.200
     0.988     0.192     0.200
     0.318    -0.194     0.200
     0.318    -0.094     0.200
     0.928     0.037     0.200
     0.928    -0.082     0.200
     0.698     0.323     0.200
     0.909     0.357     0.200
     0.496     0.012     0.200
     0.441    -0.209     0.200
     0.551     0.153     0.200
     0.938     0.056     0.200
     0.468     0.066     0.200
     0.468    -0.074     0.200
     0.369    -0.109     0.200
     0.132    -0.007     0.200
     0.767    -0.346     0.200
     0.312    -0.269     0.200
     0.260     0.107     0.200
     0.848     0.017     0.200
     0.198     0.002     0.200
     0.784    -0.218     0.200
     0.497     0.304     0.200
     0.384     0.115     0.200
     0.961     0.148     0.200
     0.310     0.083     0.200
     0.932    -0.281     0.200
     0.470     0.304     0.200
     0.268     0.446     0.200
     0.869    -0.037     0.200
     0.529     0.355     0.200
     0.205    -0.139     0.200
     0.736    -0.132     0.200
     0.128    -0.113     0.200
     0.756     0.001     0.200
     0.270     0.051     0.200
     0.923    -0.183     0.200
     0.033     0.180     0.200
     0.749    -0.569     0.200
     0.555    -0.546     0.200
     0.613    -0.948     0.200
     0.613    -0.667     0.200
     0.648    -0.731     0.200
     0.648    -0.598     0.200
     0.743    -1.485     0.200
     0.743    -1.336     0.200
     0.728    -0.495     0.200
     0.194     0.061     0.200
     0.625    -0.157     0.200
     0.329     0.327     0.200
     0.922    -0.273     0.200
     0.308    -0.042     0.200
     0.893     0.031     0.200
     0.488     0.137     0.200
     0.998    -0.161     0.200
     0.998     0.069     0.200
     0.901    -0.144     0.200
     0.832    -0.369     0.200
     0.738     0.340     0.200
     0.865    -0.328     0.200
     0.890     0.642     0.200
     0.908     0.446     0.200
     0.939     0.279     0.200
     0.879    -0.037     0.200
     0.893     0.231     0.200
     0.790     0.274     0.200
     0.892    -0.036     0.200
     0.872    -0.078     0.200
     0.942     0.373     0.200
     0.959     0.152     0.200
     0.929    -0.134     0.200
     0.943     0.106     0.200
     0.990     0.270     0.200
     0.756     0.563     0.200
     0.909    -0.409     0.200
     0.825     0.586     0.200
     0.933     0.143     0.200
     0.902     0.590     0.200
     0.965     0.202     0.200
     0.709     0.208     0.200
     0.789     0.335     0.200
     0.863     0.685     0.200
     0.884     0.500     0.200
     0.845     0.027     0.200
     0.860     0.488     0.200
     0.916     0.394     0.200
     0.780     0.582     0.200
     0.916    -0.483     0.200
     0.849     0.452     0.200
     0.935     0.610     0.200
     0.955     0.455     0.200
     0.910     0.067     0.200
     0.926     0.443     0.200
     0.987     0.345     0.200
     0.999    -0.664     0.200
     0.848    -0.035     0.200
     0.894     0.187     0.200
     0.893     0.123     0.200
     0.913     0.142     0.200
     0.926     0.367     0.200
     0.863    -0.228     0.200
     0.941    -0.013     0.200
     0.651     0.034     0.200
     0.352    -0.554     0.200
     0.662    -0.334     0.200
     0.700     0.412     0.200
     0.699     0.181     0.200
     0.719     0.146     0.200
     0.831     0.261     0.200
     0.856    -0.011     0.200
     0.886    -0.199     0.200
     0.732     0.051     0.200
     0.711    -0.697     0.200
     0.749    -0.644     0.200
     0.769    -1.055     0.200
     0.835    -1.301     0.200
     0.829    -0.544     0.200
     0.879    -0.488     0.200
     0.962    -0.030     0.200
     0.995    -0.510     0.200
     0.916    -0.592     0.200
     0.958    -0.566     0.200
     0.852     0.130     0.200
     0.619     0.028     0.200
     0.488     0.055     0.200
     0.489     0.005     0.200
     0.419    -0.047     0.200
     0.450    -0.431     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.456    -0.253     0.200
     0.395    -0.381     0.200
     0.737    -0.344     0.200
     0.452    -0.256     0.200
     0.382    -0.399     0.200
     0.382    -0.298     0.200
     0.540    -0.209     0.200
     0.833    -0.403     0.200
     0.297    -0.362     0.200
     0.236    -0.632     0.200
     0.543    -0.731     0.200
     0.908     0.702     0.200
     0.986     0.638     0.200
     0.980     0.641     0.200
     0.995     0.811     0.200
     0.363    -0.459     0.200
     0.844     0.653     0.200
     0.808     0.707     0.200
     0.879     0.930     0.200
     0.976     1.058     0.200
     0.368    -0.068     0.200
     0.807     0.807     0.200
     0.841     0.830     0.200
     0.864     0.873     0.200
     0.945     1.395     0.200
     0.429    -0.668     0.200
     0.857     0.224     0.200
     0.904     0.764     0.200
     0.905     0.742     0.200
     0.924     0.903     0.200
     0.936     0.844     0.200
     0.947     0.827     0.200
     0.468    -0.509     0.200
     0.938     0.525     0.200
     0.957     0.555     0.200
     0.343    -0.874     0.200
     0.795     0.281     0.200
     0.822     0.998     0.200
     0.847     0.853     0.200
     0.926     1.610     0.200
     0.368    -0.720     0.200
     0.791     0.939     0.200
     0.960     0.854     0.200
     0.396     0.076     0.200
     0.895    -0.027     0.200
     0.559     0.431     0.200
     0.720     0.879     0.200
     0.727     0.866     0.200
     0.772    -0.280     0.200
     0.831     1.580     0.200
     0.798     0.458     0.200
     0.853     0.768     0.200
     0.889     1.169     0.200
     0.863    -0.578     0.200
     0.953     0.545     0.200
     0.967     0.628     0.200
     0.963     0.560     0.200
     0.966     0.714     0.200
     0.946    -0.003     0.200
     0.815     0.502     0.200
     0.920     0.799     0.200
     0.817     0.709     0.200
     0.881    -0.526     0.200
     0.369    -0.199     0.200
     0.945     0.713     0.200
     0.287    -0.331     0.200
     0.296    -0.399     0.200
     0.713    -0.131     0.200
     0.713     0.142     0.200
     0.409    -0.194     0.200
     0.535    -0.633     0.200
     0.538    -0.766     0.200
     0.862     0.845     0.200
     0.860     0.889     0.200
     0.880     0.899     0.200
     0.892     1.204     0.200
     0.992     1.267     0.200
     0.568     0.103     0.200
     0.749     0.054     0.200
     0.771     0.005     0.200
     0.806     0.107     0.200
     0.947     0.441     0.200
     0.981    -0.826     0.200
     0.353    -0.726     0.200
     0.353    -1.370     0.200
     0.363    -1.335     0.200
     0.653     0.168     0.200
     0.653     0.438     0.200
     0.653     0.328     0.200
     0.917    -0.181     0.200
     0.980    -0.471     0.200
     0.513    -0.713     0.200
     0.519    -0.548     0.200
     0.984     0.117     0.200
     0.976    -0.459     0.200
     0.976    -0.151     0.200
     0.349    -0.913     0.200
     0.360    -0.853     0.200
     0.515     0.101     0.200
     0.515     0.339     0.200
     0.868    -0.709     0.200
     0.400    -0.836     0.200
     0.410    -1.219     0.200
     0.664    -0.101     0.200
     0.664    -0.226     0.200
     0.664     0.000     0.200
     0.356    -0.265     0.200
     0.684     0.126     0.200
     0.889    -0.327     0.200
     0.448    -0.799     0.200
     0.448    -0.350     0.200
     0.530    -0.436     0.200
     0.530    -0.197     0.200
     0.924     0.582     0.200
     0.992     0.831     0.200
     0.334    -1.099     0.200
     0.334    -0.810     0.200
     0.345    -0.826     0.200
     0.516    -0.299     0.200
     0.516     0.440     0.200
     0.699    -0.446     0.200
     0.699    -0.180     0.200
     0.724    -0.515     0.200
     0.723    -1.002     0.200
     0.917     1.084     0.200
     0.687    -0.169     0.200
     0.704    -0.655     0.200
     0.702    -0.742     0.200
     0.779     0.988     0.200
     0.907     1.198     0.200
     0.922     1.052     0.200
     0.969     1.402     0.200
     0.382    -0.177     0.200
     0.477     0.267     0.200
     0.855    -0.165     0.200
     0.880     0.039     0.200
     0.419    -0.739     0.200
     0.662     0.181     0.200
     0.820    -0.155     0.200
     0.488    -0.316     0.200
     0.488    -0.426     0.200
     0.631     0.554     0.200
     0.724     0.690     0.200
     0.724     0.658     0.200
     0.841     1.173     0.200
     0.843     0.871     0.200
     0.848     0.542     0.200
     0.337    -0.992     0.200
     0.459    -0.183     0.200
     0.429    -0.864     0.200
     0.656     0.267     0.200
     0.808    -0.350     0.200
     0.981    -0.053     0.200
     0.419    -0.496     0.200
     0.851     0.306     0.200
     0.897     0.772     0.200
     0.896     0.678     0.200
     0.916     0.722     0.200
     0.929     0.889     0.200
     0.404    -0.606     0.200
     0.404    -0.356     0.200
     0.827     0.369     0.200
     0.871     0.985     0.200
     0.871     0.988     0.200
     0.891     1.083     0.200
     0.371    -0.641     0.200
     0.371    -0.430     0.200
     0.808     0.382     0.200
     0.844     0.864     0.200
     0.844     0.776     0.200
     0.866     0.862     0.200
     0.880     1.082     0.200
     0.977     1.262     0.200
     0.342    -0.938     0.200
     0.353    -0.830     0.200
     0.527     0.069     0.200
     0.527     0.270     0.200
     0.872    -0.524     0.200
     0.982     0.076     0.200
     0.480    -0.915     0.200
     0.480    -0.889     0.200
     0.514    -0.303     0.200
     0.514    -0.135     0.200
     0.889     0.696     0.200
     0.959     0.930     0.200
     0.971     0.913     0.200
     0.367    -0.439     0.200
     0.805     0.323     0.200
     0.839     0.623     0.200
     0.862     0.610     0.200
     0.973     0.977     0.200
     0.493    -1.946     0.200
     0.469    -0.411     0.200
     0.865     0.359     0.200
     0.924     0.733     0.200
     0.940     0.605     0.200
     0.950     0.846     0.200
     0.458    -0.554     0.200
     0.435    -0.045     0.200
     0.894     0.238     0.200
     0.937     0.695     0.200
     0.958     0.654     0.200
     0.474    -1.768     0.200
     0.442    -0.368     0.200
     0.880     0.430     0.200
     0.928     0.714     0.200
     0.927     0.604     0.200
     0.947     0.711     0.200
     0.959     0.961     0.200
     0.374    -0.539     0.200
     0.374    -0.274     0.200
     0.518    -1.087     0.200
     0.831     0.577     0.200
     0.864     0.943     0.200
     0.866     0.832     0.200
     0.888     0.995     0.200
     0.902     1.090     0.200
     0.998     1.383     0.200
     0.432    -0.340     0.200
     0.511    -1.390     0.200
     0.842     0.372     0.200
     0.893     0.649     0.200
     0.891     0.680     0.200
     0.911     0.706     0.200
     0.923     0.990     0.200
     0.994     0.561     0.200
     0.871    -0.322     0.200
     0.508     0.444     0.200
     0.657     0.881     0.200
     0.667     0.766     0.200
     0.675     0.756     0.200
     0.707     0.852     0.200
     0.668     0.535     0.200
     0.676     0.863     0.200
     0.748    -0.270     0.200
     0.783     1.114     0.200
     0.985    -1.883     0.200
     0.985    -1.994     0.200
     0.485    -1.792     0.200
     0.488    -1.802     0.200
     0.442    -0.169     0.200
     0.866     0.514     0.200
     0.917     0.942     0.200
     0.935     0.887     0.200
     0.373    -0.503     0.200
     0.816     0.282     0.200
     0.851     0.836     0.200
     0.852     0.732     0.200
     0.874     0.790     0.200
     0.423    -1.389     0.200
     0.434    -1.354     0.200
     0.442     0.379     0.200
     0.442     0.629     0.200
     0.813    -0.111     0.200
     0.995     0.288     0.200
     0.347    -0.182     0.200
     0.557    -1.649     0.200
     0.561    -1.784     0.200
     0.794     0.734     0.200
     0.823     0.568     0.200
     0.847     0.795     0.200
     0.957     1.083     0.200
     0.957     1.253     0.200
     0.484    -1.125     0.200
     0.485    -1.045     0.200
     0.489    -0.314     0.200
     0.878     0.538     0.200
     0.938     0.799     0.200
     0.942     0.877     0.200
     0.955     0.807     0.200
     0.965     1.015     0.200
     0.500    -2.028     0.200
     0.503    -1.788     0.200
     0.416    -0.296     0.200
     0.416    -0.086     0.200
     0.850     0.387     0.200
     0.894     0.680     0.200
     0.894     0.565     0.200
     0.914     0.745     0.200
     0.927     0.979     0.200
     0.411    -0.255     0.200
     0.514    -1.978     0.200
     0.838     0.687     0.200
     0.882     1.102     0.200
     0.902     1.013     0.200
     0.573    -0.561     0.200
     0.573    -0.391     0.200
     0.563     0.465     0.200
     0.679     0.656     0.200
     0.693     0.771     0.200
     0.826    -1.783     0.200
     0.827    -1.911     0.200
     0.765     0.797     0.200
     0.767     0.614     0.200
     0.798     0.987     0.200
     0.367    -0.617     0.200
     0.522     0.114     0.200
     0.859    -0.331     0.200
     0.889     0.009     0.200
     0.969     0.090     0.200
     0.987    -0.561     0.200
     0.997    -0.372     0.200
     0.941     0.211     0.200
     0.990    -0.180     0.200
     0.980    -0.476     0.200
     0.994    -0.281     0.200
     0.994    -0.601     0.200
     0.905    -0.545     0.200
     0.995    -0.602     0.200
     0.379     0.066     0.200
     0.390    -0.072     0.200
     0.336    -0.511     0.200
     0.347    -0.675     0.200
     0.973     0.163     0.200
     0.973     0.350     0.200
     0.992     0.147     0.200
     0.995    -0.463     0.200
     0.949    -0.511     0.200
     0.483    -1.877     0.200
     0.486    -1.938     0.200
     0.433    -0.348     0.200
     0.433    -0.039     0.200
     0.323    -0.449     0.200
     0.333    -0.541     0.200
     0.873    -0.244     0.200
     0.873    -0.096     0.200
     0.928    -0.362     0.200
     0.928     0.084     0.200
     0.898    -0.991     0.200
     0.947     0.023     0.200
     0.457    -0.300     0.200
     0.464    -0.708     0.200
     0.891     0.652     0.200
     0.942     0.850     0.200
     0.941     0.868     0.200
     0.960     0.921     0.200
     0.865    -0.652     0.200
     0.612    -0.916     0.200
     0.830     0.261     0.200
     0.830     0.093     0.200
     0.415    -0.847     0.200
     0.425    -1.268     0.200
     0.997    -0.124     0.200
     0.998    -0.431     0.200
     0.998    -0.212     0.200
     0.572    -0.876     0.200
     0.922     0.699     0.200
     0.709    -0.482     0.200
     0.383    -0.794     0.200
     0.394    -0.626     0.200
     0.463     0.202     0.200
     0.463     0.474     0.200
     0.871    -0.422     0.200
     0.950     0.114     0.200
     0.865    -0.857     0.200
     0.865    -0.739     0.200
     0.953    -0.177     0.200
     0.164    -0.433     0.200
     0.175    -0.514     0.200
     0.851     0.106     0.200
     0.851    -0.051     0.200
     0.941    -0.527     0.200
     0.753    -0.723     0.200
     0.753    -1.114     0.200
     0.848    -0.408     0.200
     0.478    -0.252     0.200
     0.865     0.492     0.200
     0.928     0.872     0.200
     0.942     0.735     0.200
     0.786    -0.443     0.200
     0.424    -0.968     0.200
     0.492    -0.099     0.200
     0.933     0.270     0.200
     0.987     0.681     0.200
     0.782    -0.244     0.200
     0.800    -0.497     0.200
     0.769    -0.415     0.200
     0.769    -0.466     0.200
     0.940    -0.629     0.200
     0.993     0.343     0.200
     0.751     0.318     0.200
     0.744     0.703     0.200
     0.882    -0.535     0.200
     0.880    -0.219     0.200
     0.825     0.919     0.200
     0.825     0.759     0.200
     0.948     0.977     0.200
     0.999     0.094     0.200
     0.359    -0.054     0.200
     0.672     0.138     0.200
     0.871    -0.437     0.200
     0.978    -0.345     0.200
     0.460    -1.495     0.200
     0.460    -0.815     0.200
     0.461    -0.580     0.200
     0.455    -1.148     0.200
     0.455    -1.148     0.200
     0.958    -0.907     0.200
     0.958    -0.454     0.200
     0.784    -0.967     0.200
     0.955     0.287     0.200
     1.000     0.181     0.200
     0.069    -0.545     0.200
     0.661    -0.062     0.200
     0.458    -0.466     0.200
     0.900     0.305     0.200
     0.950     0.708     0.200
     0.949     0.651     0.200
     0.969     0.900     0.200
     0.981     0.882     0.200
     0.981     1.104     0.200
     0.277     0.070     0.200
     0.960     0.086     0.200
     0.460    -0.888     0.200
     0.522     0.094     0.200
     0.500    -0.153     0.200
     0.618     0.036     0.200
     0.716     0.207     0.200
     0.770     0.143     0.200
     0.762     0.257     0.200
     0.830    -0.014     0.200
     0.842     0.476     0.200
     0.888     0.636     0.200
     0.995     0.504     0.200
     0.593     0.418     0.200
     0.653     0.297     0.200
     0.629     0.391     0.200
     0.723    -0.113     0.200
     0.709     0.493     0.200
     0.758     0.484     0.200
     0.878     0.387     0.200
     0.660    -0.105     0.200
     0.695    -0.638     0.200
     0.767     0.948     0.200
     0.885     1.089     0.200
     0.903     1.077     0.200
     0.890     1.285     0.200
     0.957     1.246     0.200
     0.870    -0.824     0.200
     0.942    -1.641     0.200
     0.516     0.471     0.200
     0.684     0.600     0.200
     0.716     0.850     0.200
     0.684     0.700     0.200
     0.675     0.609     0.200
     0.792     1.088     0.200
     0.639     0.452     0.200
     0.754    -0.370     0.200
     0.849     1.318     0.200
     0.970     1.832     0.200
     0.965    -0.225     0.200
     0.433    -0.333     0.200
     0.832     0.475     0.200
     0.883     0.750     0.200
     0.885     0.511     0.200
     0.902     0.775     0.200
     0.914     1.014     0.200
     0.366    -0.661     0.200
     0.849     0.759     0.200
     0.850     0.788     0.200
     0.816     0.186     0.200
     0.872     0.944     0.200
     0.982     1.117     0.200
     0.936     0.582     0.200
     0.946     0.598     0.200
     0.385    -0.172     0.200
     0.431     0.307     0.200
     0.457     0.522     0.200
     0.568     0.732     0.200
     0.572     0.411     0.200
     0.601     0.593     0.200
     0.610     0.627     0.200
     0.684     0.662     0.200
     0.986    -0.450     0.200
     0.294    -0.233     0.200
     0.294    -0.131     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.276     0.623     0.200
     0.379     0.645     0.200
     0.857    -1.376     0.200
     0.749     0.185     0.200
     0.647    -0.449     0.200
     0.801    -0.536     0.200
     0.635    -1.267     0.200
     0.579    -0.795     0.200
     0.721    -0.843     0.200
     0.553    -0.476     0.200
     0.357    -0.308     0.200
     0.702     0.136     0.200
     0.341    -0.637     0.200
     0.700    -1.415     0.200
     0.145     0.344     0.200
     0.619    -0.408     0.200
     0.845     0.300     0.200
     0.967    -0.568     0.200
     0.642     0.296     0.200
     0.839     0.189     0.200
     0.844     0.044     0.200
     0.975    -0.862     0.200
     0.205     0.177     0.200
     0.207     0.241     0.200
     0.589    -0.786     0.200
     0.590    -0.692     0.200
     0.635     1.289     0.200
     0.635     1.515     0.200
     0.844     0.067     0.200
     0.307    -0.113     0.200
     0.318    -0.377     0.200
     0.499    -0.104     0.200
     0.499     0.037     0.200
     0.394     0.036     0.200
     0.406    -0.272     0.200
     0.922    -0.300     0.200
     0.888    -1.462     0.200
     0.893    -0.886     0.200
     0.641    -1.080     0.200
     0.187    -0.326     0.200
     0.194    -0.013     0.200
     0.261     0.372     0.200
     0.263     0.308     0.200
     0.568    -0.753     0.200
     0.570    -0.806     0.200
     0.643     1.538     0.200
     0.222    -0.493     0.200
     0.218    -0.408     0.200
     0.690     0.136     0.200
     0.194     0.045     0.200
     0.193     0.060     0.200
     0.777    -0.762     0.200
     0.834    -0.136     0.200
     0.231     0.660     0.200
     0.231    -0.114     0.200
     0.645     0.033     0.200
     0.259     0.165     0.200
     0.270    -0.395     0.200
     0.911     1.065     0.200
     0.911     0.800     0.200
     0.860     0.852     0.200
     0.865     0.686     0.200
     0.991    -0.408     0.200
     0.878     0.438     0.200
     0.842    -0.142     0.200
     0.986    -1.060     0.200
     0.877     1.021     0.200
     0.234     0.313     0.200
     0.243    -0.282     0.200
     0.825     0.009     0.200
     0.346     0.287     0.200
     0.324    -0.129     0.200
     0.879     0.338     0.200
     0.883     0.213     0.200
     0.720    -0.380     0.200
     0.919     1.096     0.200
     0.916    -0.576     0.200
     0.916    -0.014     0.200
     0.715    -1.361     0.200
     0.848    -1.311     0.200
     0.209     0.099     0.200
     0.215    -0.113     0.200
     0.726    -0.656     0.200
     0.726    -0.437     0.200
     0.580     0.381     0.200
     0.228    -0.258     0.200
     0.228    -0.443     0.200
     0.609    -0.043     0.200
     0.609     0.216     0.200
     0.609     0.078     0.200
     0.868     0.689     0.200
     0.299    -0.894     0.200
     0.536    -0.962     0.200
     0.683    -1.179     0.200
     0.824    -1.502     0.200
     0.931     0.162     0.200
     0.172     0.150     0.200
     0.541     0.272     0.200
     0.882     0.459     0.200
     0.578     0.451     0.200
     0.643     1.228     0.200
     0.764    -1.160     0.200
     0.764    -1.434     0.200
     0.689     0.815     0.200
     0.690     0.618     0.200
     0.705     0.383     0.200
     0.636    -1.020     0.200
     0.634    -1.129     0.200
     0.693    -0.507     0.200
     0.693    -0.949     0.200
     0.853     0.312     0.200
     0.708    -0.104     0.200
     0.477     0.814     0.200
     0.969     0.188     0.200
     0.487    -0.682     0.200
     0.560    -0.235     0.200
     0.812     0.106     0.200
     0.769     1.118     0.200
     0.917     0.478     0.200
     0.900     0.992     0.200
     0.952     1.163     0.200
     0.779     0.768     0.200
     0.907     0.562     0.200
     0.922     0.312     0.200
     0.969     1.139     0.200
     0.965     0.872     0.200
     0.757     1.326     0.200
     0.874    -1.673     0.200
     0.915    -0.168     0.200
     0.804    -0.465     0.200
     0.586    -0.791     0.200
     0.934     0.931     0.200
     0.981     0.143     0.200
     0.981     0.452     0.200
     0.388    -0.733     0.200
     0.392    -0.937     0.200
     0.686    -1.446     0.200
     0.686    -1.251     0.200
     0.239     0.574     0.200
     0.746     0.939     0.200
     0.912    -1.815     0.200
     0.912    -1.362     0.200
     0.880    -1.856     0.200
     0.880    -0.286     0.200
     0.828    -0.188     0.200
     0.985    -0.664     0.200
     0.974    -0.826     0.200
     0.987    -0.065     0.200
     0.737     1.093     0.200
     0.733     0.971     0.200
     0.851    -0.858     0.200
     0.894     0.478     0.200
     0.169    -0.658     0.200
     0.174    -1.073     0.200
     0.586    -0.785     0.200
     0.591    -1.041     0.200
     0.813    -1.184     0.200
     0.238    -0.076     0.200
     0.821     0.067     0.200
     0.766     0.599     0.200
     0.891    -1.639     0.200
     0.891    -0.791     0.200
     0.451    -0.216     0.200
     0.513    -0.116     0.200
     0.513     0.243     0.200
     0.915     0.704     0.200
     0.980     0.678     0.200
     0.994     0.738     0.200
     0.341     0.453     0.200
     0.352    -0.460     0.200
     0.535     1.256     0.200
     0.535     0.376     0.200
     0.454    -0.696     0.200
     0.520     0.359     0.200
     0.520     0.189     0.200
     0.916     0.918     0.200
     0.983     0.455     0.200
     0.996     0.947     0.200
     0.830     0.067     0.200
     0.652     0.089     0.200
     0.652     0.491     0.200
     0.654     0.592     0.200
     0.438    -1.187     0.200
     0.440    -0.981     0.200
     0.500     0.630     0.200
     0.500     0.489     0.200
     0.922     0.390     0.200
     0.982     1.060     0.200
     0.997     0.951     0.200
     0.859    -0.987     0.200
     0.859    -0.176     0.200
     0.803     0.023     0.200
     0.846    -1.206     0.200
     0.960    -0.578     0.200
     0.953    -0.518     0.200
     0.965    -0.321     0.200
     0.817     0.458     0.200
     0.189    -0.034     0.200
     0.731     0.217     0.200
     0.635    -1.120     0.200
     0.644    -0.028     0.200
     0.857     0.845     0.200
     0.862     0.639     0.200
     0.966    -0.681     0.200
     0.966    -1.126     0.200
     0.929     0.108     0.200
     0.658    -0.149     0.200
     0.658    -0.270     0.200
     0.632    -0.134     0.200
     0.636    -0.361     0.200
     0.177     0.154     0.200
     0.183     0.334     0.200
     0.826    -0.498     0.200
     0.826    -0.119     0.200
     0.901    -1.754     0.200
     0.986    -0.720     0.200
     0.966    -0.706     0.200
     0.981    -0.431     0.200
     0.141     0.078     0.200
     0.146    -0.224     0.200
     0.713    -0.439     0.200
     0.181    -0.409     0.200
     0.263     0.040     0.200
     0.864     0.471     0.200
     0.374     0.529     0.200
     0.452    -0.298     0.200
     0.410     1.485     0.200
     0.505     0.732     0.200
     0.495    -0.773     0.200
     0.397     0.705     0.200
     0.333     0.374     0.200
     0.539     0.560     0.200
     0.549     0.370     0.200
     0.484     0.858     0.200
     0.348     0.831     0.200
     0.941     0.409     0.200
     0.591     0.182     0.200
     0.430     0.172     0.200
     0.441     0.221     0.200
     0.244    -0.655     0.200
     0.254    -0.206     0.200
     0.450     1.326     0.200
     0.349     0.999     0.200
     0.359     0.781     0.200
     0.553     1.590     0.200
     0.405     0.295     0.200
     0.288     0.010     0.200
     0.929    -0.508     0.200
     0.374     1.137     0.200
     0.447    -0.112     0.200
     0.335    -0.203     0.200
     0.958    -0.009     0.200
     0.343     0.352     0.200
     0.353     0.705     0.200
     0.980     0.601     0.200
     0.980     0.761     0.200
     0.258     0.258     0.200
     0.872    -0.003     0.200
     0.872    -0.893     0.200
     0.394     0.271     0.200
     0.455     1.051     0.200
     0.584     1.166     0.200
     0.590     0.878     0.200
     0.357     0.849     0.200
     0.368     1.121     0.200
     0.994     1.168     0.200
     0.994     0.698     0.200
     0.621     1.158     0.200
     0.452     1.812     0.200
     0.501     1.551     0.200
     0.497     0.539     0.200
     0.352     0.300     0.200
     0.531     0.165     0.200
     0.333    -0.332     0.200
     0.266     0.492     0.200
     0.291     0.014     0.200
     0.301    -0.512     0.200
     0.514     0.166     0.200
     0.557     0.379     0.200
     0.567     0.793     0.200
     0.532     0.504     0.200
     0.542     0.487     0.200
     0.521     1.346     0.200
     0.532     1.087     0.200
     0.419     0.679     0.200
     0.429     0.304     0.200
     0.449     0.479     0.200
     0.459     0.444     0.200
     0.469    -0.323     0.200
     0.520     1.592     0.200
     0.531     0.308     0.200
     0.358     1.133     0.200
     0.294     1.030     0.200
     0.238    -0.492     0.200
     0.386    -0.040     0.200
     0.461    -1.150     0.200
     0.543     1.258     0.200
     0.412     1.519     0.200
     0.452     0.069     0.200
     0.568    -0.047     0.200
     0.578     1.064     0.200
     0.560     0.401     0.200
     0.570    -0.608     0.200
     0.417     0.768     0.200
     0.427     0.515     0.200
     0.531    -0.336     0.200
     0.456    -0.029     0.200
     0.478     0.370     0.200
     0.301     0.224     0.200
     0.909     0.021     0.200
     0.399     0.046     0.200
     0.303     0.036     0.200
     0.312     0.511     0.200
     0.328     0.300     0.200
     0.338     0.554     0.200
     0.579     1.114     0.200
     0.256     0.124     0.200
     0.381     0.415     0.200
     0.443     0.020     0.200
     0.480     0.862     0.200
     0.529     0.610     0.200
     0.383     0.188     0.200
     0.394     0.001     0.200
     0.411     1.495     0.200
     0.333     0.707     0.200
     0.941     0.223     0.200
     0.554     1.684     0.200
     0.509     0.926     0.200
     0.520     0.867     0.200
     0.371     0.973     0.200
     0.382     1.192     0.200
     0.298     0.461     0.200
     0.498     1.969     0.200
     0.509     1.646     0.200
     0.443     0.264     0.200
     0.752     0.645     0.200
     0.413     0.984     0.200
     0.424     0.745     0.200
     0.458     1.184     0.200
     0.415     0.681     0.200
     0.999    -1.026     0.200
     0.519     1.331     0.200
     0.530     0.824     0.200
     0.567     1.340     0.200
     0.256     0.890     0.200
     0.646     0.625     0.200
     0.499     0.715     0.200
     0.373     0.525     0.200
     0.383     0.524     0.200
     0.462     0.829     0.200
     0.473     0.541     0.200
     0.337     0.072     0.200
     0.296     0.384     0.200
     0.307    -1.064     0.200
     0.951     0.402     0.200
     0.951    -0.403     0.200
     0.349     0.380     0.200
     0.971    -0.183     0.200
     0.971    -0.300     0.200
     0.569     0.984     0.200
     0.580     0.784     0.200
     0.580    -1.065     0.200
     0.591    -1.303     0.200
     0.453    -0.028     0.200
     0.483    -1.451     0.200
     0.430     1.182     0.200
     0.441    -0.298     0.200
     0.187     0.124     0.200
     0.860    -0.198     0.200
     0.860    -0.648     0.200
     0.377     0.993     0.200
     0.386     0.295     0.200
     0.523    -1.202     0.200
     0.522    -0.888     0.200
     0.581    -0.823     0.200
     0.765     0.753     0.200
     0.776     0.462     0.200
     0.503     0.977     0.200
     0.513    -0.167     0.200
     0.499     0.812     0.200
     0.510     0.251     0.200
     0.263     0.023     0.200
     0.393     0.231     0.200
     0.328     0.666     0.200
     0.338     0.251     0.200
     0.316     0.072     0.200
     0.437     0.825     0.200
     0.447     0.662     0.200
     0.304     1.183     0.200
     0.314     0.811     0.200
     0.450     0.630     0.200
     0.518     0.758     0.200
     0.528     0.501     0.200
     0.281     0.231     0.200
     0.357     1.059     0.200
     0.368     0.804     0.200
     0.369     0.629     0.200
     0.379     0.290     0.200
     0.942     1.065     0.200
     0.942     1.456     0.200
     0.274     0.296     0.200
     0.284     0.059     0.200
     0.873     0.598     0.200
     0.873     0.485     0.200
     0.396     0.244     0.200
     0.406     0.806     0.200
     0.978    -0.066     0.200
     0.978     0.423     0.200
     0.417     0.793     0.200
     0.428     0.837     0.200
     0.322     0.623     0.200
     0.922    -2.066     0.200
     0.454     1.621     0.200
     0.268     0.020     0.200
     0.623     1.029     0.200
     0.735     1.646     0.200
     0.197    -0.284     0.200
     0.421     1.074     0.200
     0.431    -1.170     0.200
     0.572     1.282     0.200
     0.582     0.969     0.200
     0.365     1.160     0.200
     0.922     0.368     0.200
     0.572    -0.146     0.200
     0.431     0.957     0.200
     0.442     0.644     0.200
     0.698    -0.167     0.200
     0.359    -0.106     0.200
     0.270     0.874     0.200
     0.885     0.391     0.200
     0.885     0.071     0.200
     0.327     0.357     0.200
     0.403     1.114     0.200
     0.962    -0.179     0.200
     0.290     0.215     0.200
     0.159     0.090     0.200
     0.170    -0.504     0.200
     0.609    -0.100     0.200
     0.194    -0.085     0.200
     0.807    -1.943     0.200
     0.204    -0.404     0.200
     0.340    -0.002     0.200
     0.445     0.920     0.200
     0.456     0.715     0.200
     0.476     0.171     0.200
     0.639     0.497     0.200
     0.953    -1.856     0.200
     0.221     1.575     0.200
     0.273     0.355     0.200
     0.283    -0.038     0.200
     0.330    -0.346     0.200
     0.915    -1.019     0.200
     0.170     0.235     0.200
     0.301     0.363     0.200
     0.312     0.354     0.200
     0.253     0.427     0.200
     0.469    -0.589     0.200
     0.588    -0.812     0.200
     0.588    -0.632     0.200
     0.931     0.748     0.200
     0.544     1.600     0.200
     0.391     0.897     0.200
     0.402     0.205     0.200
     0.221    -0.320     0.200
     0.231     0.289     0.200
     0.239     0.700     0.200
     0.249    -0.465     0.200
     0.587    -0.336     0.200
     0.591     0.546     0.200
     0.591     0.733     0.200
     0.598    -0.118     0.200
     0.910    -0.348     0.200
     0.501    -0.069     0.200
     0.208    -0.125     0.200
     0.491     0.529     0.200
     0.441     1.524     0.200
     0.183     0.617     0.200
     0.665     0.695     0.200
     0.841     0.453     0.200
     0.254    -0.085     0.200
     0.205     0.228     0.200
     0.438     0.151     0.200
     0.729     0.128     0.200
     0.281     0.096     0.200
     0.422     0.104     0.200
     0.108    -0.130     0.200
     0.277     0.307     0.200
     0.441     0.333     0.200
     0.162    -0.077     0.200
     0.439     0.470     0.200
     0.426    -0.181     0.200
     0.766    -0.087     0.200
     0.273     0.119     0.200
     0.513     1.208     0.200
     0.529     1.561     0.200
     0.414     1.052     0.200
     0.992     1.428     0.200
     0.253    -0.581     0.200
     0.567     0.046     0.200
     0.928    -0.443     0.200
     0.254    -0.323     0.200
     0.864     0.363     0.200
     0.380     0.049     0.200
     0.508     1.574     0.200
     0.508    -0.695     0.200
     0.387    -0.092     0.200
     0.318     0.306     0.200
     0.698     0.345     0.200
     0.909    -0.118     0.200
     0.496     0.593     0.200
     0.441    -0.638     0.200
     0.551     0.314     0.200
     0.468     0.473     0.200
     0.369    -0.539     0.200
     0.132    -0.144     0.200
     0.312    -0.727     0.200
     0.260     0.239     0.200
     0.497     0.979     0.200
     0.384    -0.018     0.200
     0.310    -0.086     0.200
     0.470     0.831     0.200
     0.268     0.430     0.200
     0.529     0.733     0.200
     0.205    -0.356     0.200
     0.736    -1.030     0.200
     0.128    -0.341     0.200
     0.270     1.093     0.200
     0.033     0.271     0.200
     0.555     0.335     0.200
     0.613    -0.250     0.200
     0.648    -0.055     0.200
     0.728     0.113     0.200
     0.728     0.418     0.200
     0.194     0.547     0.200
     0.329     0.377     0.200
     0.308     0.170     0.200
     0.488     1.279     0.200
     0.998    -0.473     0.200
     0.901    -0.749     0.200
     0.832    -0.288     0.200
     0.877    -1.479     0.200
     0.865    -0.385     0.200
     0.790    -0.065     0.200
     0.892    -0.067     0.200
     0.872     0.250     0.200
     0.929    -0.081     0.200
     0.909    -1.890     0.200
     0.916     1.398     0.200
     0.965     0.603     0.200
     0.418     1.336     0.200
     0.894     0.892     0.200
     0.913     1.019     0.200
     0.651     0.436     0.200
     0.662     0.554     0.200
     0.700     1.031     0.200
     0.700     1.140     0.200
     0.699     1.060     0.200
     0.719     1.421     0.200
     0.895     0.174     0.200
     0.920     0.036     0.200
     0.732     1.693     0.200
     0.711    -0.735     0.200
     0.749    -0.755     0.200
     0.769    -1.314     0.200
     0.829    -1.222     0.200
     0.962    -0.016     0.200
     0.995    -0.513     0.200
     0.879    -0.490     0.200
     0.916    -0.550     0.200
     0.988    -1.166     0.200
     0.852    -0.238     0.200
     0.488     0.022     0.200
     0.489    -0.103     0.200
     0.419     0.300     0.200
     0.450     1.069     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.236    -1.023     0.200
     0.986     1.523     0.200
     0.980    -0.258     0.200
     0.368    -0.952     0.200
     0.429     0.480     0.200
     0.468    -0.287     0.200
     0.343    -0.233     0.200
     0.368    -0.123     0.200
     0.396     0.627     0.200
     0.772    -1.531     0.200
     0.728    -0.798     0.200
     0.724    -0.338     0.200
     0.863     0.754     0.200
     0.786     0.351     0.200
     0.591    -0.610     0.200
     0.858     1.725     0.200
     0.807     0.153     0.200
     0.706     0.449     0.200
     0.688    -0.397     0.200
     0.698     0.094     0.200
     0.595    -0.517     0.200
     0.369     0.039     0.200
     0.990    -0.337     0.200
     0.987     0.631     0.200
     0.990     0.887     0.200
     0.287    -0.778     0.200
     0.713     0.052     0.200
     0.713    -0.351     0.200
     0.885     1.167     0.200
     0.409    -0.620     0.200
     0.409    -0.909     0.200
     0.535    -1.321     0.200
     0.538    -1.466     0.200
     0.751     0.130     0.200
     0.809    -0.983     0.200
     0.883    -0.998     0.200
     0.883    -1.886     0.200
     0.541    -0.829     0.200
     0.568     0.870     0.200
     0.947     1.477     0.200
     0.988    -0.252     0.200
     0.579     0.262     0.200
     0.624     0.090     0.200
     0.353    -1.135     0.200
     0.363    -0.953     0.200
     0.653     0.797     0.200
     0.976     0.759     0.200
     0.705    -0.342     0.200
     0.349    -0.421     0.200
     0.360    -0.824     0.200
     0.515     0.996     0.200
     0.515     1.097     0.200
     0.400    -1.319     0.200
     0.400    -0.944     0.200
     0.410    -1.621     0.200
     0.664     0.251     0.200
     0.664    -0.390     0.200
     0.356    -0.383     0.200
     0.684     0.044     0.200
     0.448    -0.572     0.200
     0.530    -0.796     0.200
     0.530    -0.556     0.200
     0.924     0.992     0.200
     0.992     1.207     0.200
     0.334    -1.913     0.200
     0.334    -1.303     0.200
     0.345    -1.875     0.200
     0.516     0.561     0.200
     0.516     0.835     0.200
     0.699    -1.803     0.200
     0.699    -1.451     0.200
     0.687    -1.251     0.200
     0.382    -0.766     0.200
     0.477     0.732     0.200
     0.419    -0.343     0.200
     0.662     1.026     0.200
     0.488    -0.554     0.200
     0.488    -1.147     0.200
     0.631     1.686     0.200
     0.724     1.314     0.200
     0.724     1.935     0.200
     0.843     1.549     0.200
     0.337    -1.826     0.200
     0.459     0.062     0.200
     0.429    -0.038     0.200
     0.656     1.190     0.200
     0.808    -0.304     0.200
     0.498     0.312     0.200
     0.419    -0.346     0.200
     0.851     1.386     0.200
     0.897     2.310     0.200
     0.916     2.372     0.200
     0.404    -0.153     0.200
     0.404    -0.349     0.200
     0.827     1.700     0.200
     0.371     0.149     0.200
     0.371    -0.030     0.200
     0.808     1.678     0.200
     0.342    -0.563     0.200
     0.353    -1.040     0.200
     0.527     0.865     0.200
     0.480    -1.833     0.200
     0.480    -1.794     0.200
     0.514    -0.479     0.200
     0.889     1.491     0.200
     0.959     1.863     0.200
     0.971     2.047     0.200
     0.367    -0.078     0.200
     0.367    -0.453     0.200
     0.805     1.897     0.200
     0.469    -0.287     0.200
     0.865     1.539     0.200
     0.924     1.855     0.200
     0.940     2.169     0.200
     0.458    -1.570     0.200
     0.435    -0.432     0.200
     0.894     0.238     0.200
     0.937     1.654     0.200
     0.958     1.520     0.200
     0.442    -0.440     0.200
     0.880     1.522     0.200
     0.928     2.135     0.200
     0.947     2.009     0.200
     0.374     0.283     0.200
     0.374    -0.135     0.200
     0.374     0.177     0.200
     0.518    -0.675     0.200
     0.518    -1.632     0.200
     0.831     2.389     0.200
     0.864     2.450     0.200
     0.915     0.244     0.200
     0.873    -0.293     0.200
     0.958     0.531     0.200
     0.432    -0.271     0.200
     0.511    -1.843     0.200
     0.893     1.913     0.200
     0.911     2.245     0.200
     0.847    -1.806     0.200
     0.878    -1.333     0.200
     0.931    -0.007     0.200
     0.579    -0.654     0.200
     0.930     0.642     0.200
     0.969     0.760     0.200
     0.508     1.229     0.200
     0.667     2.252     0.200
     0.707     1.527     0.200
     0.668     1.543     0.200
     0.676     1.958     0.200
     0.748    -1.340     0.200
     0.442     0.062     0.200
     0.866     1.682     0.200
     0.917     1.835     0.200
     0.935     2.180     0.200
     0.519    -0.321     0.200
     0.520     0.772     0.200
     0.373    -0.246     0.200
     0.816     1.527     0.200
     0.832     1.277     0.200
     0.876     2.110     0.200
     0.896     1.998     0.200
     0.992    -1.595     0.200
     0.434    -1.792     0.200
     0.442     1.397     0.200
     0.813     0.459     0.200
     0.995     0.503     0.200
     0.347     0.015     0.200
     0.794     1.992     0.200
     0.823     2.085     0.200
     0.847     1.969     0.200
     0.847     2.428     0.200
     0.957     2.443     0.200
     0.489    -0.548     0.200
     0.878     1.373     0.200
     0.942     1.621     0.200
     0.955     1.989     0.200
     0.825    -0.330     0.200
     0.416     0.104     0.200
     0.416    -0.565     0.200
     0.850     1.442     0.200
     0.914     2.179     0.200
     0.572    -0.937     0.200
     0.411     0.151     0.200
     0.838     0.135     0.200
     0.882     2.431     0.200
     0.814    -0.514     0.200
     0.930     0.100     0.200
     0.938    -0.415     0.200
     0.573    -0.497     0.200
     0.573    -0.727     0.200
     0.563     0.930     0.200
     0.679     1.373     0.200
     0.693     1.539     0.200
     0.765     1.988     0.200
     0.767     1.511     0.200
     0.367    -0.814     0.200
     0.522     0.794     0.200
     0.660    -0.622     0.200
     0.799    -0.386     0.200
     0.919    -0.111     0.200
     0.930    -0.250     0.200
     0.992    -0.069     0.200
     0.909     0.879     0.200
     0.909     0.528     0.200
     0.713    -0.676     0.200
     0.584     1.116     0.200
     0.987    -0.298     0.200
     0.997    -1.098     0.200
     0.605    -0.385     0.200
     0.865     0.104     0.200
     0.865    -0.474     0.200
     0.990     0.011     0.200
     0.972     0.623     0.200
     0.972    -0.487     0.200
     0.929    -0.434     0.200
     0.983     0.082     0.200
     0.886     0.068     0.200
     0.886    -0.043     0.200
     0.905     0.029     0.200
     0.905    -0.391     0.200
     0.558    -0.673     0.200
     0.610     0.307     0.200
     0.620     0.271     0.200
     0.571    -0.334     0.200
     0.568    -0.169     0.200
     0.579    -0.254     0.200
     0.957    -0.381     0.200
     0.957    -0.550     0.200
     0.926     0.087     0.200
     0.837    -0.347     0.200
     0.837     0.393     0.200
     0.995    -0.566     0.200
     0.985     1.760     0.200
     0.379    -1.457     0.200
     0.390    -0.058     0.200
     0.336    -0.770     0.200
     0.347    -0.408     0.200
     0.973     1.557     0.200
     0.973     0.948     0.200
     0.855     1.523     0.200
     0.855     0.406     0.200
     0.905    -0.019     0.200
     0.905    -0.941     0.200
     0.877    -0.798     0.200
     0.995    -0.395     0.200
     0.626    -0.019     0.200
     0.637     0.190     0.200
     0.949     0.590     0.200
     0.922     1.279     0.200
     0.922     0.670     0.200
     0.741     0.360     0.200
     0.905     0.596     0.200
     0.696     1.117     0.200
     1.000    -0.398     0.200
     1.000    -1.297     0.200
     0.897    -1.578     0.200
     0.821    -0.490     0.200
     0.821    -0.289     0.200
     0.433    -0.195     0.200
     0.945     1.312     0.200
     0.945     0.872     0.200
     0.581    -0.871     0.200
     0.659     0.162     0.200
     0.756    -1.177     0.200
     0.878    -0.429     0.200
     0.878    -0.750     0.200
     0.947     1.150     0.200
     0.937    -0.094     0.200
     0.937     0.006     0.200
     0.568    -0.669     0.200
     0.578     0.039     0.200
     0.955     0.923     0.200
     0.955     0.384     0.200
     0.661    -0.562     0.200
     0.672    -0.714     0.200
     0.673    -0.125     0.200
     0.930     1.026     0.200
     0.930     1.286     0.200
     0.884     0.216     0.200
     0.978     0.327     0.200
     0.978     0.137     0.200
     0.323     0.068     0.200
     0.333     0.187     0.200
     0.928     0.246     0.200
     0.928    -0.293     0.200
     0.457    -0.174     0.200
     0.464    -1.792     0.200
     0.891     1.089     0.200
     0.942     1.672     0.200
     0.960     1.997     0.200
     0.865    -0.475     0.200
     0.830     1.000     0.200
     0.830     0.352     0.200
     0.415    -0.883     0.200
     0.425    -1.154     0.200
     0.997     1.294     0.200
     0.997     0.842     0.200
     0.998     0.156     0.200
     0.998     0.386     0.200
     0.693    -0.573     0.200
     0.568    -0.233     0.200
     0.943    -0.301     0.200
     0.550     0.476     0.200
     0.571    -0.701     0.200
     0.394    -1.030     0.200
     0.463     0.831     0.200
     0.463     0.722     0.200
     0.895     0.448     0.200
     0.895     0.217     0.200
     0.575    -0.799     0.200
     0.586    -1.114     0.200
     0.939     1.293     0.200
     0.939     0.583     0.200
     0.609    -1.049     0.200
     0.807    -0.173     0.200
     0.808     0.009     0.200
     0.961    -0.131     0.200
     0.164    -0.641     0.200
     0.175    -0.720     0.200
     0.851     0.957     0.200
     0.851     0.598     0.200
     0.866     1.492     0.200
     0.904     0.442     0.200
     0.904     0.622     0.200
     0.819    -0.749     0.200
     0.941    -0.522     0.200
     0.753     0.107     0.200
     0.848     0.389     0.200
     0.848    -0.811     0.200
     0.554    -0.472     0.200
     0.650     0.721     0.200
     0.834     0.347     0.200
     0.834    -0.523     0.200
     0.834    -0.817     0.200
     0.834     0.105     0.200
     0.821    -0.148     0.200
     0.478    -0.307     0.200
     0.865     1.556     0.200
     0.928     1.300     0.200
     0.942     0.757     0.200
     0.854    -0.375     0.200
     0.634    -1.168     0.200
     0.560     0.073     0.200
     0.883    -0.295     0.200
     0.670    -1.265     0.200
     0.875     0.216     0.200
     0.786    -0.221     0.200
     0.863     0.236     0.200
     0.887     0.097     0.200
     0.603     1.255     0.200
     0.424    -1.688     0.200
     0.492    -0.335     0.200
     0.933     1.138     0.200
     0.987     1.741     0.200
     0.974    -0.699     0.200
     0.615     2.005     0.200
     0.695     0.061     0.200
     0.578    -0.861     0.200
     0.769     0.504     0.200
     0.769     0.676     0.200
     0.942    -0.349     0.200
     0.940    -0.390     0.200
     0.882    -0.481     0.200
     0.880    -0.382     0.200
     0.825     2.234     0.200
     0.825     1.654     0.200
     0.948     2.009     0.200
     0.560     0.316     0.200
     0.745    -0.599     0.200
     0.972    -1.247     0.200
     0.953    -0.803     0.200
     0.999     0.574     0.200
     0.928     1.772     0.200
     0.928     0.741     0.200
     0.359     0.095     0.200
     0.672     0.353     0.200
     0.460    -1.622     0.200
     0.938     0.413     0.200
     0.455    -0.626     0.200
     0.958     1.411     0.200
     0.784    -1.061     0.200
     0.955     0.922     0.200
     1.000     1.094     0.200
     0.767    -0.093     0.200
     0.619    -0.635     0.200
     0.848    -1.081     0.200
     0.784    -0.111     0.200
     0.961    -0.214     0.200
     0.932    -0.740     0.200
     0.719    -0.448     0.200
     0.869    -0.205     0.200
     0.756     0.109     0.200
     0.069    -1.050     0.200
     0.661     0.460     0.200
     0.923     0.437     0.200
     0.923     1.124     0.200
     0.749    -1.624     0.200
     0.625    -0.549     0.200
     0.893     0.726     0.200
     0.458    -0.561     0.200
     0.900     0.877     0.200
     0.900     0.986     0.200
     0.950     1.993     0.200
     0.949     1.459     0.200
     0.949     1.627     0.200
     0.969     1.534     0.200
     0.981     2.293     0.200
     0.277    -0.324     0.200
     0.960     0.635     0.200
     0.460    -1.913     0.200
     0.522    -0.636     0.200
     0.910     2.021     0.200
     0.974     2.385     0.200
     0.500     0.596     0.200
     0.618     1.833     0.200
     0.716     1.088     0.200
     0.770     0.712     0.200
     0.762     1.007     0.200
     0.560     1.508     0.200
     0.593     1.045     0.200
     0.653     0.716     0.200
     0.653     1.091     0.200
     0.629     1.026     0.200
     0.629     1.205     0.200
     0.723     0.350     0.200
     0.709     1.106     0.200
     0.758     1.543     0.200
     0.878     1.257     0.200
     0.738    -0.877     0.200
     0.893     0.046     0.200
     0.660    -0.795     0.200
     0.695    -1.697     0.200
     0.767     1.339     0.200
     0.885     1.553     0.200
     0.903     1.243     0.200
     0.890     2.013     0.200
     0.935     1.817     0.200
     0.961     1.506     0.200
     0.957     1.751     0.200
     0.942    -1.242     0.200
     0.959    -1.269     0.200
     0.990    -0.878     0.200
     0.756    -0.589     0.200
     0.825    -0.052     0.200
     0.933    -0.204     0.200
     0.886    -0.251     0.200
     0.902     0.574     0.200
     0.965    -0.940     0.200
     0.709     0.405     0.200
     0.870    -0.619     0.200
     0.789     0.566     0.200
     0.845     0.358     0.200
     0.860     0.759     0.200
     0.780    -0.867     0.200
     0.849    -0.891     0.200
     0.935    -0.057     0.200
     0.955    -0.758     0.200
     0.910    -1.050     0.200
     0.910    -0.300     0.200
     0.926     0.362     0.200
     0.987    -0.220     0.200
     0.516     1.159     0.200
     0.666     1.643     0.200
     0.684     1.371     0.200
     0.716     1.376     0.200
     0.684     1.538     0.200
     0.675     1.485     0.200
     0.639     0.973     0.200
     0.754    -0.898     0.200
     0.999     1.203     0.200
     0.433    -0.020     0.200
     0.832     0.577     0.200
     0.832     0.836     0.200
     0.885     1.718     0.200
     0.902     1.516     0.200
     0.848     0.779     0.200
     0.848     1.119     0.200
     0.366    -0.466     0.200
     0.849     2.665     0.200
     0.850     2.441     0.200
     0.816     1.619     0.200
     0.872     2.698     0.200
     0.982     2.914     0.200
     0.863    -0.257     0.200
     0.859     0.442     0.200
     0.859     0.610     0.200
     0.918     0.819     0.200
     0.922     1.556     0.200
     0.936     1.496     0.200
     0.941    -0.868     0.200
     0.831    -1.596     0.200
     0.886    -1.917     0.200
     0.431     1.040     0.200
     0.986    -0.279     0.200
     0.294     0.153     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00   -0.059
 1.00   -0.059
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00    0.080
 1.00    0.080
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.2
 1.00    0.2
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00    0.3
 1.00    0.3
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.0)
     0.050     7.000   Pg = red x; average =  -0.1 (solid red line)
     0.050     5.000   Pn = green x; average =   0.1 (solid green line)
     0.050    -7.500   Sg = red circles; average =   0.2 (dashed red line)
     0.050    -9.500   Sn = green circles; average =   0.3 (dashed green line)
EOF
gmt end
