#!/bin/bash
gmt begin simeonof10.15_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic simeonof10.15'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.473
   135.500     1.556
   136.000     1.641
   136.500     1.729
   137.000     1.821
   137.500     1.916
   138.000     2.014
   138.500     2.116
   139.000     2.221
   139.500     2.330
   140.000     2.443
   140.500     2.560
   141.000     2.681
   141.500     2.807
   142.000     2.937
   142.500     3.072
   143.000     3.213
   143.500     3.358
   144.000     3.509
   144.500     3.665
   145.000     3.828
   145.500     3.996
   146.000     4.171
   146.500     4.353
   147.000     4.542
   147.500     4.738
   148.000     4.941
   148.500     5.152
   149.000     5.372
   149.500     5.601
   150.000     5.839
   150.500     6.088
   151.000     6.346
   151.500     6.615
   152.000     6.894
   152.500     7.183
   153.000     7.482
   153.500     7.792
   154.000     8.113
   154.500     8.444
   155.000     8.786
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.637
   145.500     0.332
   146.000     1.362
   146.500     2.435
   147.000     3.541
   147.500     4.677
   148.000     5.839
   148.500     7.027
   149.000     8.239
   149.500     9.473
   150.000    10.729
   150.500    12.006
   151.000    13.304
   151.500    14.621
   152.000    15.957
   152.500    17.312
   153.000    18.684
   153.500    20.074
   154.000    21.482
   154.500    22.907
   155.000    24.350
   155.500    25.809
   156.000    27.285
   156.500    28.778
   157.000    30.287
   157.500    31.814
   158.000    33.356
   158.500    34.916
   159.000    36.491
   159.500    38.083
   160.000    39.692
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.646
   145.500     0.112
   146.000     0.801
   146.500     1.440
   147.000     2.036
   147.500     2.594
   148.000     3.117
   148.500     3.608
   149.000     4.072
   149.500     4.517
   150.000     4.946
   150.500     5.363
   151.000     5.769
   151.500     6.165
   152.000     6.553
   152.500     6.934
   153.000     7.309
   153.500     7.681
   154.000     8.049
   154.500     8.415
   155.000     8.780
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   144.639    -0.605     0.200
   144.705    -1.720     0.200
   150.210     0.355     0.200
   154.854     0.215     0.200
   144.568    -0.638     0.200
   144.907    -0.225     0.200
   144.578    -1.831     0.200
   144.826    -0.260     0.200
   145.186     1.119     0.200
   144.499    -1.958     0.200
   144.911    -0.070     0.200
   138.667     0.566     0.200
   140.221    -2.867     0.200
   141.209    -4.252     0.200
   144.487    -3.349     0.200
   144.628    -2.694     0.200
   144.968    -0.283     0.200
   150.515     0.167     0.200
   150.815     1.101     0.200
   150.984     0.841     0.200
   151.148     1.390     0.200
   156.354    -1.815     0.200
   157.716    -0.549     0.200
   144.816    -0.426     0.200
   150.996     0.918     0.200
   141.532    -4.116     0.200
   144.537    -3.321     0.200
   144.930    -0.102     0.200
   144.694    -2.695     0.200
   152.259     1.530     0.200
   144.496    -2.569     0.200
   144.944    -0.447     0.200
   150.490    -0.396     0.200
   151.778     3.131     0.200
   144.520    -2.099     0.200
   144.859    -0.685     0.200
   144.800    -0.363     0.200
   144.513    -3.162     0.200
   144.588    -2.293     0.200
   155.516     2.634     0.200
   144.613    -2.952     0.200
   144.581    -0.497     0.200
   144.934    -0.097     0.200
   150.479     0.250     0.200
   150.769    -3.168     0.200
   144.732    -0.097     0.200
   144.466    -3.092     0.200
   144.645    -0.903     0.200
   144.698    -1.994     0.200
   147.679     0.849     0.200
   149.831    -0.037     0.200
   150.184    -0.594     0.200
   150.502    -1.091     0.200
   151.479     0.708     0.200
   152.007     0.011     0.200
   152.825    -0.496     0.200
   153.805    -2.011     0.200
   154.517     0.386     0.200
   154.545    -0.052     0.200
   156.580    -0.181     0.200
   157.490     2.957     0.200
   144.627    -0.697     0.200
   144.641    -2.721     0.200
   144.765    -1.732     0.200
   139.827    -1.866     0.200
   139.827    -1.468     0.200
   144.497    -2.679     0.200
   144.895     0.632     0.200
   144.778    -1.964     0.200
   147.602     0.547     0.200
   149.740     0.678     0.200
   150.094    -0.483     0.200
   150.413    -0.483     0.200
   151.390    -1.486     0.200
   151.459    -0.387     0.200
   152.735     1.505     0.200
   153.716    -0.115     0.200
   154.436     1.073     0.200
   154.457    -0.456     0.200
   156.232    -0.856     0.200
   157.407    -1.761     0.200
   144.501    -2.410     0.200
   147.905     0.621     0.200
   150.235     0.471     0.200
   153.501     0.365     0.200
   153.880     0.427     0.200
   154.633    -1.630     0.200
   155.450     2.254     0.200
   144.627    -1.575     0.200
   149.915     0.585     0.200
   144.676    -0.974     0.200
   144.464    -2.862     0.200
   144.864    -2.241     0.200
   150.301    -0.156     0.200
   144.614    -2.509     0.200
   144.361    -2.822     0.200
   155.836    -1.124     0.200
   159.791    -2.605     0.200
   159.837    -4.156     0.200
   144.563    -0.957     0.200
   144.435    -2.226     0.200
   144.892    -1.919     0.200
   138.150     0.002     0.200
   144.201    -2.953     0.200
   144.201    -3.812     0.200
   144.824    -1.023     0.200
   150.201     1.090     0.200
   150.506     0.513     0.200
   151.107     1.805     0.200
   151.826     0.644     0.200
   153.148    -0.159     0.200
   153.899     0.054     0.200
   144.252    -1.161     0.200
   144.758    -1.933     0.200
   144.758    -2.151     0.200
   144.310    -1.279     0.200
   144.900    -0.283     0.200
   149.795    -1.267     0.200
   153.390    -0.776     0.200
   153.390     0.769     0.200
   156.236    -3.204     0.200
   144.941    -0.558     0.200
   140.022    -2.114     0.200
   144.227    -0.903     0.200
   144.537    -2.224     0.200
   144.807    -0.015     0.200
   144.784    -1.862     0.200
   148.331     1.192     0.200
   153.298     0.764     0.200
   156.272    -0.843     0.200
   140.010    -1.987     0.200
   144.252    -1.408     0.200
   144.513    -2.281     0.200
   144.828    -0.400     0.200
   144.759    -3.996     0.200
   149.725     0.327     0.200
   153.320    -0.043     0.200
   156.248    -1.938     0.200
   156.248    -1.348     0.200
   159.402    -4.178     0.200
   136.030    -1.768     0.200
   140.090     0.003     0.200
   144.036    -2.866     0.200
   144.535    -1.062     0.200
   144.535    -1.640     0.200
   144.835    -0.277     0.200
   144.972    -0.161     0.200
   148.619     1.364     0.200
   149.899     0.663     0.200
   149.899     0.273     0.200
   153.491    -0.806     0.200
   153.491    -0.510     0.200
   155.772    -2.074     0.200
   157.621    -0.753     0.200
   144.450    -2.459     0.200
   135.062    -1.496     0.200
   139.627    -0.876     0.200
   144.336    -0.565     0.200
   144.631    -0.686     0.200
   144.631    -0.405     0.200
   145.995    -2.880     0.200
   147.264     1.333     0.200
   147.487    -1.638     0.200
   149.449     0.044     0.200
   149.449     2.364     0.200
   153.047    -0.673     0.200
   153.047    -1.353     0.200
   157.317    -1.718     0.200
   159.303    -5.769     0.200
   144.613    -2.084     0.200
   154.147    -0.985     0.200
   144.852    -0.683     0.200
   144.589    -2.391     0.200
   144.717    -1.447     0.200
   144.411    -3.102     0.200
   144.161    -3.356     0.200
   144.132    -2.530     0.200
   153.891     0.498     0.200
   155.638    -0.074     0.200
   144.161    -4.145     0.200
   145.528    -2.192     0.200
   144.199    -2.114     0.200
   144.484    -2.557     0.200
   144.672    -1.740     0.200
   144.528    -0.432     0.200
   144.835    -0.150     0.200
   144.109    -0.821     0.200
   144.109    -1.087     0.200
   145.719    -0.789     0.200
   139.292     0.045     0.200
   144.127    -0.966     0.200
   144.127    -0.591     0.200
   144.576    -3.171     0.200
   144.795    -3.725     0.200
   147.433     0.021     0.200
   148.820     1.983     0.200
   149.875     0.295     0.200
   151.398     0.041     0.200
   153.472     0.156     0.200
   153.472    -1.551     0.200
   153.472    -0.055     0.200
   157.366    -0.203     0.200
   157.366    -1.066     0.200
   159.636    -4.262     0.200
   159.707    -4.583     0.200
   144.027    -1.610     0.200
   144.027    -1.270     0.200
   144.147    -0.969     0.200
   145.196     1.325     0.200
   147.342     1.229     0.200
   149.290     1.025     0.200
   149.661     1.041     0.200
   153.259     0.669     0.200
   153.259     1.093     0.200
   156.811    -0.608     0.200
   157.224     1.547     0.200
   159.988    -4.104     0.200
   144.876    -2.069     0.200
   144.876    -1.573     0.200
   144.700    -2.786     0.200
   144.640    -0.495     0.200
   144.377    -1.210     0.200
   144.377    -0.710     0.200
   147.969     2.030     0.200
   159.894    -2.125     0.200
   144.658    -2.022     0.200
   144.658    -1.553     0.200
   144.660    -2.554     0.200
   144.660    -1.980     0.200
   146.529     0.923     0.200
   144.440    -3.224     0.200
   143.983    -1.683     0.200
   143.983    -1.120     0.200
   144.227    -1.655     0.200
   145.158     1.326     0.200
   146.205     0.936     0.200
   146.595     1.206     0.200
   149.624     0.964     0.200
   149.624     0.409     0.200
   149.624     1.269     0.200
   150.480     0.211     0.200
   150.480     1.398     0.200
   153.221     1.079     0.200
   153.221    -0.280     0.200
   156.857    -0.533     0.200
   156.857    -1.065     0.200
   146.265     0.471     0.200
   144.897    -2.169     0.200
   144.897    -1.733     0.200
   144.837    -2.608     0.200
   144.837    -2.038     0.200
   144.400    -2.386     0.200
   144.400    -2.792     0.200
   144.038    -1.191     0.200
   145.172     1.153     0.200
   153.235     0.393     0.200
   156.717    -1.047     0.200
   144.453    -1.054     0.200
   144.453    -1.499     0.200
   144.556     0.236     0.200
   144.556    -0.654     0.200
   144.462    -1.276     0.200
   144.462    -1.500     0.200
   145.076    -0.183     0.200
   144.268    -2.865     0.200
   144.333    -1.256     0.200
   144.687    -1.922     0.200
   144.687    -2.050     0.200
   145.291     1.229     0.200
   146.465     1.248     0.200
   153.352     0.604     0.200
   156.069    -0.124     0.200
   144.542    -1.860     0.200
   144.542    -1.744     0.200
   144.851    -2.256     0.200
   144.457    -2.274     0.200
   144.707    -2.256     0.200
   144.707    -2.444     0.200
   144.722    -2.297     0.200
   153.362    -0.024     0.200
   156.238    -1.389     0.200
   144.760    -2.984     0.200
   144.760    -2.660     0.200
   144.658    -2.368     0.200
   144.697    -1.064     0.200
   144.687    -1.874     0.200
   144.256    -1.287     0.200
   144.256    -0.916     0.200
   144.418    -0.557     0.200
   144.547    -0.473     0.200
   144.753    -2.001     0.200
   144.753    -1.739     0.200
   147.583     1.981     0.200
   156.269    -1.599     0.200
   157.393     0.928     0.200
   144.302    -2.126     0.200
   144.302    -1.954     0.200
   144.725    -0.501     0.200
   144.694    -2.704     0.200
   144.694    -2.446     0.200
   144.289    -4.053     0.200
   144.289    -3.818     0.200
   144.188    -1.356     0.200
   144.719    -2.424     0.200
   147.150    -1.156     0.200
   144.668    -1.590     0.200
   144.314    -2.063     0.200
   159.770    -3.177     0.200
   144.306    -2.296     0.200
   144.306    -2.468     0.200
   144.719    -1.102     0.200
   144.617    -2.728     0.200
   144.541    -2.446     0.200
   145.759     0.301     0.200
   148.251     0.020     0.200
   149.329    -1.476     0.200
   144.194    -1.618     0.200
   144.194    -1.457     0.200
   144.722    -2.907     0.200
   144.722    -2.407     0.200
   153.550    -0.963     0.200
   144.753    -2.185     0.200
   144.313    -3.978     0.200
   144.779    -2.669     0.200
   144.638    -2.567     0.200
   144.711    -1.676     0.200
   144.663    -2.864     0.200
   144.294    -1.247     0.200
   144.294    -1.060     0.200
   144.583    -0.547     0.200
   144.715    -1.659     0.200
   144.715    -1.839     0.200
   144.880    -0.116     0.200
   146.551    -2.523     0.200
   159.346    -5.615     0.200
   144.407    -3.687     0.200
   144.534    -0.291     0.200
   144.482    -0.323     0.200
   144.500    -1.571     0.200
   144.500    -1.368     0.200
   144.273    -4.166     0.200
   144.337    -1.454     0.200
   144.337    -0.034     0.200
   144.727    -0.381     0.200
   144.652    -1.850     0.200
   144.652    -2.690     0.200
   146.249    -1.099     0.200
   146.875    -1.125     0.200
   147.658    -0.770     0.200
   153.495     0.226     0.200
   156.404    -1.360     0.200
   159.141    -3.568     0.200
   159.867    -3.414     0.200
   159.924    -4.072     0.200
   135.225    -1.624     0.200
   137.926     0.432     0.200
   143.089    -3.317     0.200
   143.224    -3.164     0.200
   143.393    -4.438     0.200
   144.360    -3.162     0.200
   144.402    -0.703     0.200
   144.402    -1.063     0.200
   144.624    -0.502     0.200
   144.624    -0.338     0.200
   144.624    -0.760     0.200
   144.857     0.735     0.200
   146.821     1.301     0.200
   147.943     2.254     0.200
   148.453     1.667     0.200
   148.535     1.478     0.200
   148.660     2.173     0.200
   149.559     1.594     0.200
   149.841     1.186     0.200
   150.196     0.775     0.200
   151.059     0.216     0.200
   151.557     2.114     0.200
   153.476     1.361     0.200
   153.788    -1.640     0.200
   153.788     2.267     0.200
   153.792    -0.895     0.200
   153.792    -2.356     0.200
   153.792     1.566     0.200
   153.792    -0.426     0.200
   156.219    -1.840     0.200
   156.219    -2.074     0.200
   157.800    -0.189     0.200
   157.800     1.811     0.200
   158.855    -5.066     0.200
   159.582    -4.006     0.200
   159.637    -4.804     0.200
   144.197    -1.894     0.200
   144.109    -3.863     0.200
   144.109    -3.762     0.200
   158.617    -2.932     0.200
   159.398    -3.552     0.200
   139.400    -3.094     0.200
   144.296    -4.298     0.200
   144.296    -3.931     0.200
   147.785     0.586     0.200
   143.330    -2.205     0.200
   144.102    -4.324     0.200
   144.102    -4.456     0.200
   144.888    -1.103     0.200
   144.888    -0.314     0.200
   146.366     1.776     0.200
   147.075     2.262     0.200
   154.028    -1.218     0.200
   154.028    -1.757     0.200
   155.956    -0.655     0.200
   155.956    -0.788     0.200
   158.669    -5.523     0.200
   159.449    -4.188     0.200
   144.130    -3.067     0.200
   144.130    -2.286     0.200
   144.270    -3.185     0.200
   144.033    -3.003     0.200
   144.033    -3.152     0.200
   144.954     0.131     0.200
   144.954    -0.798     0.200
   146.441     1.091     0.200
   155.926    -2.135     0.200
   158.591    -3.420     0.200
   159.320    -3.239     0.200
   159.371    -3.111     0.200
   156.077    -1.359     0.200
   144.257    -3.591     0.200
   144.257    -3.818     0.200
   144.724    -0.878     0.200
   146.925     2.720     0.200
   144.061    -3.662     0.200
   144.923    -0.339     0.200
   147.119     2.178     0.200
   148.953     4.379     0.200
   144.315    -2.619     0.200
   144.235    -3.716     0.200
   144.163    -2.763     0.200
   144.259    -3.756     0.200
   144.358    -4.093     0.200
   144.105    -4.456     0.200
   144.152    -3.695     0.200
   144.152    -3.450     0.200
   158.660    -2.174     0.200
   144.013    -3.495     0.200
   144.244    -3.701     0.200
   144.244    -3.280     0.200
   144.144    -4.391     0.200
   144.144    -0.415     0.200
   144.831    -0.688     0.200
   147.040     1.612     0.200
   148.766     0.275     0.200
   148.889     1.116     0.200
   150.427     1.054     0.200
   137.849    -1.126     0.200
   144.285    -4.526     0.200
   144.285    -3.001     0.200
   146.895     0.263     0.200
   148.605     0.357     0.200
   149.634    -0.349     0.200
   150.265    -0.275     0.200
   159.581    -3.503     0.200
   144.073    -3.259     0.200
   144.908     0.113     0.200
   148.822     0.969     0.200
   148.948     0.265     0.200
   151.833     1.784     0.200
   144.286    -3.189     0.200
   144.347    -2.439     0.200
   144.347    -3.917     0.200
   144.083    -3.934     0.200
   144.083    -4.078     0.200
   144.893    -0.805     0.200
   144.893    -0.405     0.200
   148.210     0.372     0.200
   150.485     0.031     0.200
   151.849    -0.247     0.200
   156.065    -2.948     0.200
   158.565    -5.067     0.200
   159.292    -4.541     0.200
   159.347    -4.804     0.200
   144.920     0.026     0.200
   150.473     1.197     0.200
   144.083    -2.473     0.200
   144.166    -1.416     0.200
   144.166    -0.616     0.200
   144.147    -2.131     0.200
   144.149    -4.239     0.200
   144.110    -4.279     0.200
   144.257    -2.335     0.200
   144.312    -3.779     0.200
   144.312    -3.375     0.200
   144.669    -0.905     0.200
   158.793    -3.754     0.200
   159.575    -3.838     0.200
   144.394    -2.900     0.200
   158.882    -4.268     0.200
   159.664    -3.157     0.200
   144.070    -3.309     0.200
   144.212    -3.779     0.200
   144.212    -3.623     0.200
   144.774    -0.828     0.200
   145.964    -1.962     0.200
   149.706    -1.234     0.200
   144.153    -3.174     0.200
   144.041    -2.921     0.200
   144.049    -3.562     0.200
   144.049    -3.124     0.200
   144.216    -3.285     0.200
   144.216    -3.145     0.200
   144.344    -2.545     0.200
   144.344    -3.092     0.200
   158.865    -2.130     0.200
   159.646    -4.859     0.200
   144.301    -3.200     0.200
   144.301    -3.544     0.200
   144.025    -1.748     0.200
   144.069    -3.162     0.200
   144.908    -1.329     0.200
   159.890    -2.620     0.200
   144.198    -3.831     0.200
   159.456    -4.234     0.200
   144.311    -2.781     0.200
   144.185    -2.549     0.200
   144.346    -3.304     0.200
   144.633    -0.758     0.200
   158.816    -2.594     0.200
   144.111    -3.109     0.200
   146.207     1.755     0.200
   158.769    -3.374     0.200
   159.552    -2.842     0.200
   144.175    -3.632     0.200
   144.253    -3.052     0.200
   146.927    -1.217     0.200
   144.545    -1.675     0.200
   144.545    -1.225     0.200
   143.945    -4.455     0.200
   144.353    -2.952     0.200
   144.168    -1.911     0.200
   144.303    -3.182     0.200
   144.678    -0.746     0.200
   156.198    -1.678     0.200
   158.788    -3.731     0.200
   159.570    -3.889     0.200
   144.249    -2.897     0.200
   144.293    -2.341     0.200
   144.293    -2.583     0.200
   144.672    -1.697     0.200
   144.672    -2.117     0.200
   153.421     2.484     0.200
   149.624    -0.830     0.200
   155.926    -1.318     0.200
   158.545    -4.411     0.200
   159.326    -4.655     0.200
   144.200    -2.751     0.200
   144.200    -2.595     0.200
   144.496    -2.021     0.200
   147.746    -0.146     0.200
   143.965    -4.280     0.200
   144.272    -3.310     0.200
   144.715     0.342     0.200
   144.263    -1.994     0.200
   144.345    -3.521     0.200
   153.911    -0.815     0.200
   144.432     0.058     0.200
   144.595    -1.290     0.200
   146.797     0.517     0.200
   148.642     0.785     0.200
   149.958    -0.283     0.200
   150.179     0.068     0.200
   144.374    -2.756     0.200
   144.610    -0.800     0.200
   144.467    -0.932     0.200
   144.540    -1.876     0.200
   144.540    -1.509     0.200
   144.390    -2.755     0.200
   144.390     0.081     0.200
   144.421    -0.221     0.200
   144.714    -1.938     0.200
   144.351    -2.343     0.200
   144.205    -2.905     0.200
   144.643    -3.534     0.200
   144.643    -2.659     0.200
   144.820    -1.799     0.200
   144.698    -0.317     0.200
   144.743     0.069     0.200
   144.999     0.897     0.200
   145.207    -0.447     0.200
   145.799    -2.260     0.200
   144.837    -1.376     0.200
   145.732    -0.547     0.200
   145.732    -0.754     0.200
   146.315     0.942     0.200
   149.062     0.557     0.200
   144.580    -3.488     0.200
   144.580    -2.914     0.200
   139.331     0.537     0.200
   144.821    -1.945     0.200
   144.821    -3.312     0.200
   147.430     0.035     0.200
   148.163     0.378     0.200
   153.419    -0.538     0.200
   156.904    -1.982     0.200
   142.885    -3.305     0.200
   144.639    -2.581     0.200
   153.609    -0.015     0.200
   156.807    -0.761     0.200
   158.838    -4.568     0.200
   159.558    -3.439     0.200
   159.626    -4.509     0.200
   144.484    -0.102     0.200
   144.497    -1.738     0.200
   149.365     2.034     0.200
   150.066     1.672     0.200
   135.519    -1.747     0.200
   135.519    -1.872     0.200
   144.116    -2.412     0.200
   144.246    -2.604     0.200
   144.508    -1.302     0.200
   144.480    -2.464     0.200
   144.713    -0.760     0.200
   146.700    -0.781     0.200
   148.409     2.375     0.200
   144.506    -2.494     0.200
   144.340    -2.962     0.200
   144.340    -3.337     0.200
   144.638    -1.714     0.200
   145.907    -0.626     0.200
   145.907    -0.206     0.200
   146.679     0.259     0.200
   147.983     0.338     0.200
   144.324    -2.349     0.200
   144.324    -2.882     0.200
   144.660    -1.147     0.200
   143.685    -1.535     0.200
   144.333    -0.709     0.200
   144.673    -2.134     0.200
   144.331    -2.889     0.200
   144.641    -0.552     0.200
   144.400    -0.825     0.200
   144.607    -1.921     0.200
   144.113    -2.145     0.200
   144.680    -3.842     0.200
   144.680    -3.475     0.200
   149.656    -1.247     0.200
   159.830    -1.030     0.200
   135.668    -1.977     0.200
   144.153    -2.283     0.200
   144.867    -0.593     0.200
   144.867    -1.632     0.200
   148.197     1.090     0.200
   148.282     0.692     0.200
   150.279     0.548     0.200
   150.279     1.839     0.200
   153.872    -1.816     0.200
   153.872     0.825     0.200
   153.872    -1.615     0.200
   155.476     0.125     0.200
   155.657    -2.852     0.200
   155.657    -0.766     0.200
   157.978     1.332     0.200
   157.978    -2.276     0.200
   159.680    -0.695     0.200
   159.722    -3.655     0.200
   144.298    -2.448     0.200
   159.912    -2.742     0.200
   144.281    -2.924     0.200
   144.530    -0.805     0.200
   144.488    -1.655     0.200
   144.846    -0.424     0.200
   155.947    -1.992     0.200
   144.295    -3.921     0.200
   144.295    -5.210     0.200
   144.299    -2.245     0.200
   142.977    -2.892     0.200
   144.347    -2.405     0.200
   144.347    -2.030     0.200
   144.679    -0.465     0.200
   144.787    -0.262     0.200
   144.973     0.042     0.200
   149.528     0.393     0.200
   153.646     0.009     0.200
   155.698    -1.626     0.200
   159.928    -3.244     0.200
   159.969    -3.883     0.200
   144.282    -2.154     0.200
   144.282    -2.420     0.200
   144.497    -1.453     0.200
   144.531    -2.825     0.200
   144.531    -2.559     0.200
   153.449     1.189     0.200
   144.059    -3.226     0.200
   155.533    -1.912     0.200
   144.127    -3.146     0.200
   155.614    -0.899     0.200
   144.316    -1.204     0.200
   144.650    -0.163     0.200
   144.693    -2.687     0.200
   147.414     0.820     0.200
   148.374     0.057     0.200
   148.926     0.398     0.200
   149.795     1.887     0.200
   150.387     1.367     0.200
   144.708    -4.304     0.200
   144.760    -1.570     0.200
   144.650    -4.725     0.200
   139.430    -3.292     0.200
   143.897    -4.373     0.200
   144.752    -0.811     0.200
   155.883    -1.360     0.200
   159.207     0.817     0.200
   159.746     0.263     0.200
   159.746    -1.182     0.200
   144.277    -2.701     0.200
   144.464    -0.414     0.200
   144.706    -0.823     0.200
   153.875    -0.144     0.200
   156.158    -1.618     0.200
   158.778    -4.019     0.200
   159.506    -2.470     0.200
   159.560    -3.673     0.200
   145.618    -1.854     0.200
   137.644    -1.242     0.200
   144.096    -3.028     0.200
   144.668    -0.672     0.200
   146.375    -1.846     0.200
   148.190     0.300     0.200
   159.770    -3.233     0.200
   144.655    -0.431     0.200
   144.708    -0.329     0.200
   159.666    -3.496     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   153.611     6.556     0.200
   150.678     5.092     0.200
   150.515     5.066     0.200
   150.832     4.671     0.200
   151.764     4.770     0.200
   150.581     4.684     0.200
   150.439     4.344     0.200
   150.170     4.707     0.200
   150.480     4.621     0.200
   152.810     6.704     0.200
   150.413     4.517     0.200
   151.390     5.514     0.200
   149.854     2.970     0.200
   148.157     3.172     0.200
   148.258     1.980     0.200
   145.103    -0.383     0.200
   153.361     6.833     0.200
   147.870     2.584     0.200
   149.899     4.617     0.200
   145.244    -1.105     0.200
   153.045     6.812     0.200
   153.665     6.952     0.200
   145.542    -0.336     0.200
   150.788     4.039     0.200
   153.241     7.032     0.200
   145.026    -1.106     0.200
   153.875     7.345     0.200
   145.371    -0.650     0.200
   150.079     3.593     0.200
   149.385     3.409     0.200
   144.940    -1.628     0.200
   150.414     3.696     0.200
   144.982    -1.597     0.200
   147.299     2.309     0.200
   150.445     3.429     0.200
   153.221     7.025     0.200
   153.221     6.571     0.200
   150.002     2.847     0.200
   144.941    -1.617     0.200
   148.553     3.761     0.200
   150.563     4.859     0.200
   144.974    -1.598     0.200
   144.991    -1.386     0.200
   145.003    -1.405     0.200
   153.322     6.532     0.200
   153.564     7.193     0.200
   153.762     6.966     0.200
   150.730     4.600     0.200
   146.528     1.390     0.200
   148.171     3.315     0.200
   149.265     3.949     0.200
   147.397     2.855     0.200
   149.898     4.371     0.200
   145.024     0.166     0.200
   147.785     2.304     0.200
   149.298     4.338     0.200
   151.712     5.279     0.200
   154.030     7.213     0.200
   148.704     3.502     0.200
   149.811     4.742     0.200
   147.050     2.266     0.200
   148.274     3.742     0.200
   148.975     3.368     0.200
   151.836     5.749     0.200
   154.102     7.056     0.200
   153.902     7.409     0.200
   148.669     4.034     0.200
   148.605     3.947     0.200
   148.210     3.552     0.200
   153.533     6.937     0.200
   153.860     7.313     0.200
   147.453     2.749     0.200
   149.902     3.285     0.200
   151.138     5.313     0.200
   153.166     5.803     0.200
   153.421     6.897     0.200
   148.812     3.756     0.200
   150.544     4.453     0.200
   144.985    -1.538     0.200
   153.185     6.668     0.200
   144.994    -1.658     0.200
   146.807     1.589     0.200
   153.549     7.031     0.200
   145.148    -0.981     0.200
   145.148    -1.138     0.200
   149.518     4.588     0.200
   149.518     4.416     0.200
   147.410     2.916     0.200
   147.797     3.166     0.200
   148.580     3.722     0.200
   149.710     4.566     0.200
   149.822     4.748     0.200
   148.650     3.012     0.200
   150.669     5.003     0.200
   151.730     4.863     0.200
   152.170     4.946     0.200
   153.011     5.195     0.200
   145.518    -0.348     0.200
   148.333     2.608     0.200
   148.535     2.778     0.200
   153.666     7.194     0.200
   147.983     3.416     0.200
   145.381    -0.071     0.200
   148.197     2.309     0.200
   145.234    -0.344     0.200
   148.442     3.721     0.200
   149.339     4.466     0.200
   150.466     2.948     0.200
   153.324     7.033     0.200
   145.015    -1.797     0.200
   153.344     6.345     0.200
   145.083    -0.882     0.200
   154.253     6.912     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   151.101    10.574     0.200
   163.700    51.678     0.200
   151.082    14.305     0.200
   156.444    28.166     0.200
   156.244    28.667     0.200
   155.781    26.866     0.200
   148.984     7.917     0.200
   158.405    34.410     0.200
   156.181    27.237     0.200
   155.649    26.387     0.200
   155.836    26.876     0.200
   155.836    27.126     0.200
   159.791    36.795     0.200
   160.347    38.573     0.200
   146.880     2.552     0.200
   150.201    11.090     0.200
   155.598    26.319     0.200
   160.318    38.699     0.200
   160.709    40.733     0.200
   149.795    11.708     0.200
   156.236    27.570     0.200
   163.164    48.058     0.200
   153.298    19.190     0.200
   156.272    28.231     0.200
   163.825    50.672     0.200
   156.248    28.062     0.200
   156.248    27.659     0.200
   156.298    26.435     0.200
   155.772    26.676     0.200
   155.772    26.199     0.200
   160.618    39.747     0.200
   160.618    39.130     0.200
   163.006    50.201     0.200
   156.469    29.323     0.200
   157.317    29.837     0.200
   157.317    30.891     0.200
   160.020    37.570     0.200
   160.095    37.939     0.200
   160.724    39.988     0.200
   161.557    43.220     0.200
   157.610    32.277     0.200
   155.638    26.127     0.200
   158.930    33.973     0.200
   159.705    37.096     0.200
   160.203    37.777     0.200
   160.203    39.399     0.200
   160.905    41.753     0.200
   155.669    25.373     0.200
   160.264    38.798     0.200
   161.056    41.527     0.200
   147.677     4.656     0.200
   146.207     2.085     0.200
   146.246     2.250     0.200
   146.633     2.686     0.200
   147.342     3.908     0.200
   148.553     7.254     0.200
   156.811    29.693     0.200
   163.635    49.167     0.200
   156.969    30.087     0.200
   156.969    30.399     0.200
   145.607     1.711     0.200
   146.677     2.503     0.200
   146.778     2.813     0.200
   147.060     3.220     0.200
   155.873    26.026     0.200
   160.406    40.500     0.200
   146.168     2.015     0.200
   146.205     2.225     0.200
   146.595     2.761     0.200
   147.299     3.926     0.200
   148.864     9.956     0.200
   156.857    29.365     0.200
   157.182    32.467     0.200
   160.670    42.485     0.200
   144.922    -1.142     0.200
   144.941    -1.192     0.200
   145.585     1.366     0.200
   146.243     2.225     0.200
   146.612     2.719     0.200
   147.356     3.742     0.200
   156.717    29.676     0.200
   155.906    28.150     0.200
   155.906    28.048     0.200
   145.520     1.554     0.200
   145.907     1.453     0.200
   146.590     2.235     0.200
   146.693     2.663     0.200
   153.581    20.100     0.200
   155.925    27.518     0.200
   155.925    27.992     0.200
   160.492    40.215     0.200
   156.864    30.078     0.200
   155.782    24.925     0.200
   145.679     0.962     0.200
   146.465     2.767     0.200
   146.744     2.177     0.200
   146.744     2.728     0.200
   153.352    20.303     0.200
   156.069    26.677     0.200
   160.201    38.927     0.200
   160.717    40.559     0.200
   160.717    40.250     0.200
   153.548    20.406     0.200
   160.670    41.062     0.200
   153.322    19.356     0.200
   156.258    27.338     0.200
   145.668     0.948     0.200
   146.327     2.008     0.200
   146.413     2.851     0.200
   146.721     2.151     0.200
   146.721     2.620     0.200
   153.334    20.568     0.200
   156.269    26.748     0.200
   160.695    40.982     0.200
   146.838     2.214     0.200
   155.661    26.586     0.200
   155.661    26.937     0.200
   145.504     1.438     0.200
   145.941     1.403     0.200
   146.470     2.475     0.200
   146.931     2.781     0.200
   147.490     3.477     0.200
   159.506    37.660     0.200
   160.202    39.372     0.200
   160.202    39.482     0.200
   160.202    38.364     0.200
   161.032    41.381     0.200
   155.793    26.762     0.200
   160.671    40.117     0.200
   145.490     1.752     0.200
   145.641     0.191     0.200
   145.924     1.542     0.200
   146.467     2.139     0.200
   146.468     2.189     0.200
   147.498     3.471     0.200
   153.550    20.236     0.200
   156.984    28.808     0.200
   160.238    36.938     0.200
   145.308     1.077     0.200
   145.704     1.172     0.200
   146.363     2.027     0.200
   146.450     2.577     0.200
   156.239    27.815     0.200
   156.239    27.916     0.200
   160.661    40.495     0.200
   163.753    52.890     0.200
   153.495    20.002     0.200
   156.404    27.865     0.200
   157.507    33.050     0.200
   159.867    39.293     0.200
   160.481    41.406     0.200
   160.481    41.230     0.200
   145.729     1.627     0.200
   146.135     1.748     0.200
   147.240     3.334     0.200
   156.219    27.590     0.200
   147.073     2.802     0.200
   146.884     2.438     0.200
   145.965     2.160     0.200
   144.954    -1.970     0.200
   147.145     2.774     0.200
   154.102    21.275     0.200
   158.591    34.510     0.200
   159.320    36.003     0.200
   159.908    36.315     0.200
   160.651    40.850     0.200
   156.071    27.336     0.200
   146.895     2.503     0.200
   147.108     3.061     0.200
   146.018     1.796     0.200
   147.101     2.679     0.200
   147.461     3.459     0.200
   159.896    36.751     0.200
   146.104     1.536     0.200
   146.787     2.561     0.200
   147.313     3.207     0.200
   158.737    33.008     0.200
   159.465    36.207     0.200
   159.518    35.603     0.200
   160.063    37.169     0.200
   160.813    40.280     0.200
   153.966    21.314     0.200
   158.816    34.375     0.200
   159.598    36.249     0.200
   160.915    40.819     0.200
   145.798     1.685     0.200
   146.880     2.401     0.200
   158.776    32.986     0.200
   160.854    40.237     0.200
   145.791     1.759     0.200
   146.198     1.637     0.200
   146.879     2.797     0.200
   156.198    28.171     0.200
   159.515    37.383     0.200
   159.570    36.240     0.200
   160.881    41.195     0.200
   153.813    20.989     0.200
   156.304    27.257     0.200
   158.695    32.145     0.200
   159.479    34.515     0.200
   160.815    40.091     0.200
   144.983    -0.877     0.200
   146.120     1.548     0.200
   146.627     2.620     0.200
   145.433     0.971     0.200
   145.983     1.901     0.200
   147.026     3.351     0.200
   147.463     3.653     0.200
   145.416     0.075     0.200
   146.062     1.331     0.200
   146.989     2.557     0.200
   145.784     1.237     0.200
   146.369     2.321     0.200
   147.430     3.754     0.200
   153.419    19.555     0.200
   156.904    30.690     0.200
   145.975     1.858     0.200
   146.552     2.732     0.200
   146.831     2.301     0.200
   146.979     2.931     0.200
   158.838    34.029     0.200
   161.037    40.580     0.200
   163.501    52.383     0.200
   145.518    -0.114     0.200
   158.596    34.457     0.200
   158.596    35.176     0.200
   159.337    34.750     0.200
   160.036    37.916     0.200
   160.138    38.205     0.200
   160.872    40.222     0.200
   160.872    40.443     0.200
   160.872    40.880     0.200
   161.811    43.347     0.200
   164.112    52.007     0.200
   146.857     2.314     0.200
   156.187    28.231     0.200
   145.360     1.399     0.200
   146.495     2.646     0.200
   156.241    27.239     0.200
   145.422     1.367     0.200
   147.395     3.379     0.200
   155.680    25.931     0.200
   145.495     1.440     0.200
   145.883     1.707     0.200
   155.947    27.457     0.200
   155.668    25.805     0.200
   145.408     0.950     0.200
   145.586     1.808     0.200
   145.966     1.769     0.200
   147.394     3.272     0.200
   155.698    27.296     0.200
   157.772    33.166     0.200
   159.928    36.905     0.200
   159.969    38.375     0.200
   160.462    40.155     0.200
   160.462    40.366     0.200
   160.462    39.944     0.200
   161.157    43.279     0.200
   162.668    47.404     0.200
   155.667    26.645     0.200
   160.661    41.706     0.200
   155.533    24.213     0.200
   155.614    24.128     0.200
   145.327     1.246     0.200
   156.215    27.668     0.200
   160.645    43.193     0.200
   153.324    20.023     0.200
   156.266    28.333     0.200
   156.266    26.773     0.200
   159.155    34.299     0.200
   159.207    33.488     0.200
   159.746    39.001     0.200
   159.746    36.728     0.200
   156.158    26.682     0.200
   159.560    36.468     0.200
   160.109    38.190     0.200
   160.109    38.436     0.200
   160.864    41.134     0.200
   159.666    36.199     0.200
   160.266    38.994     0.200
   161.016    43.176     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   139.091     2.295     0.200
   140.854     3.096     0.200
   141.235     3.410     0.200
   147.671     3.852     0.200
   150.496     6.209     0.200
   153.798     9.290     0.200
   147.615     3.490     0.200
   150.139     5.611     0.200
   150.426     6.962     0.200
   151.402     6.360     0.200
   150.369     6.472     0.200
   151.660     7.090     0.200
   150.454     6.076     0.200
   150.815     6.800     0.200
   150.984     6.540     0.200
   151.148     7.089     0.200
   150.363     5.195     0.200
   151.710     6.332     0.200
   150.946     6.214     0.200
   151.112     6.861     0.200
   151.822     6.183     0.200
   153.116     7.771     0.200
   140.190     1.686     0.200
   144.591     3.867     0.200
   150.490     5.604     0.200
   150.793     8.134     0.200
   152.281     6.879     0.200
   153.129     7.135     0.200
   150.870     5.827     0.200
   150.342     5.374     0.200
   152.151     6.808     0.200
   152.983     8.185     0.200
   147.796     3.653     0.200
   150.712     6.981     0.200
   152.751     7.410     0.200
   150.479     6.750     0.200
   153.900    10.192     0.200
   151.548     7.304     0.200
   144.986     2.183     0.200
   147.597     3.466     0.200
   149.827     6.145     0.200
   151.462     6.714     0.200
   153.781     8.702     0.200
   154.451     9.759     0.200
   140.769     1.326     0.200
   148.956     5.433     0.200
   152.735     8.505     0.200
   153.716     8.189     0.200
   154.436     9.573     0.200
   154.457     8.145     0.200
   150.617     5.345     0.200
   138.222     0.844     0.200
   138.470     2.690     0.200
   138.927     2.153     0.200
   144.708     4.032     0.200
   151.131     5.881     0.200
   153.501     7.267     0.200
   149.915     5.647     0.200
   149.915     7.527     0.200
   150.267     6.473     0.200
   150.584     7.479     0.200
   153.492     7.833     0.200
   150.013     5.291     0.200
   149.660     5.039     0.200
   153.236     8.652     0.200
   153.492     8.190     0.200
   153.654     7.767     0.200
   153.649     8.173     0.200
   150.301     5.758     0.200
   150.134     5.510     0.200
   150.201     5.590     0.200
   149.729     5.105     0.200
   153.324     7.939     0.200
   138.438     1.295     0.200
   148.999     4.636     0.200
   149.795     5.783     0.200
   153.390     7.999     0.200
   149.835     6.339     0.200
   137.954     1.663     0.200
   149.703     5.609     0.200
   153.298     7.287     0.200
   137.966     1.784     0.200
   149.725     5.827     0.200
   153.320     7.957     0.200
   153.320     8.094     0.200
   153.519     8.121     0.200
   149.766     5.726     0.200
   137.883     2.022     0.200
   138.272     1.588     0.200
   139.963     2.266     0.200
   147.870     3.936     0.200
   149.899     5.937     0.200
   149.899     5.656     0.200
   151.102     6.174     0.200
   151.919     7.468     0.200
   151.919     7.085     0.200
   153.334     7.927     0.200
   153.491     8.092     0.200
   153.656     7.988     0.200
   153.620     8.427     0.200
   149.449     5.411     0.200
   153.047     7.725     0.200
   153.120     7.143     0.200
   135.281     0.785     0.200
   149.141     5.094     0.200
   152.738     7.712     0.200
   153.364     7.207     0.200
   152.863     6.883     0.200
   153.891     8.449     0.200
   150.196     5.750     0.200
   148.209     4.106     0.200
   153.348     8.255     0.200
   139.060     1.109     0.200
   139.999     2.158     0.200
   146.392     3.786     0.200
   148.523     4.266     0.200
   149.875     4.904     0.200
   150.329     5.141     0.200
   150.543     6.606     0.200
   153.472     9.144     0.200
   154.972    11.529     0.200
   138.647     1.340     0.200
   147.871     4.413     0.200
   149.633     5.297     0.200
   151.100     6.406     0.200
   153.259     8.368     0.200
   153.370     7.879     0.200
   153.370     8.164     0.200
   147.969     4.370     0.200
   148.427     4.967     0.200
   149.749     5.772     0.200
   150.074     6.348     0.200
   150.950     6.813     0.200
   151.327     6.966     0.200
   147.829     4.452     0.200
   148.246     4.243     0.200
   149.251     5.482     0.200
   149.624     5.987     0.200
   149.624     5.206     0.200
   149.624     5.394     0.200
   150.264     5.727     0.200
   150.480     5.765     0.200
   150.823     6.968     0.200
   151.069     5.669     0.200
   151.069     6.903     0.200
   152.602     7.857     0.200
   153.221     8.056     0.200
   149.684     5.269     0.200
   153.281     7.504     0.200
   147.872     4.469     0.200
   148.981     5.319     0.200
   149.274     5.477     0.200
   149.638     6.037     0.200
   151.048     6.713     0.200
   153.235     8.065     0.200
   153.235     8.237     0.200
   153.585     7.321     0.200
   153.585     8.469     0.200
   147.886     4.304     0.200
   148.342     4.735     0.200
   149.429     5.517     0.200
   149.662     5.655     0.200
   149.987     5.091     0.200
   149.987     5.741     0.200
   149.987     6.011     0.200
   150.863     6.545     0.200
   151.242     6.916     0.200
   153.581     8.425     0.200
   153.581     8.695     0.200
   153.581     7.975     0.200
   153.581     8.324     0.200
   153.197     7.797     0.200
   153.212     8.238     0.200
   147.664     3.981     0.200
   148.115     4.628     0.200
   149.202     5.332     0.200
   149.433     5.312     0.200
   149.758     5.745     0.200
   151.018     6.568     0.200
   153.352     7.952     0.200
   153.352     8.096     0.200
   153.548     7.352     0.200
   153.548     9.207     0.200
   153.395     7.735     0.200
   153.651     8.066     0.200
   147.615     3.806     0.200
   148.347     4.897     0.200
   149.767     5.844     0.200
   150.923     6.016     0.200
   152.687     7.427     0.200
   153.362     7.421     0.200
   153.362     7.984     0.200
   153.362     7.273     0.200
   153.407     8.435     0.200
   147.578     3.893     0.200
   149.728     4.902     0.200
   147.583     3.641     0.200
   148.056     4.329     0.200
   149.150     5.011     0.200
   149.401     4.967     0.200
   149.739     5.859     0.200
   150.610     6.055     0.200
   150.610     6.395     0.200
   153.334     7.690     0.200
   153.334     7.998     0.200
   153.334     7.139     0.200
   153.334     7.869     0.200
   153.690     8.090     0.200
   148.076     4.278     0.200
   149.209     5.038     0.200
   149.564     5.329     0.200
   149.967     5.832     0.200
   150.810     6.363     0.200
   150.983     5.992     0.200
   153.695     8.070     0.200
   153.439     7.522     0.200
   148.077     4.124     0.200
   149.206     5.209     0.200
   149.206     4.959     0.200
   149.555     5.152     0.200
   149.953     5.529     0.200
   149.953     5.850     0.200
   150.798     6.670     0.200
   151.482     6.564     0.200
   153.550     8.264     0.200
   153.550     8.662     0.200
   147.621     3.954     0.200
   148.093     4.283     0.200
   149.187     4.560     0.200
   149.187     5.177     0.200
   149.438     5.408     0.200
   149.775     5.958     0.200
   150.647     6.475     0.200
   153.370     8.184     0.200
   153.495     7.826     0.200
   148.535     3.971     0.200
   150.858     6.010     0.200
   151.962     8.012     0.200
   150.359     6.159     0.200
   148.787     4.296     0.200
   148.913     4.304     0.200
   148.517     4.299     0.200
   148.720     4.445     0.200
   150.254     6.076     0.200
   148.711     4.635     0.200
   148.771     4.646     0.200
   148.902     4.911     0.200
   149.813     5.460     0.200
   150.084     5.704     0.200
   150.432     6.308     0.200
   151.299     6.409     0.200
   151.759     6.282     0.200
   148.759     4.723     0.200
   150.419     5.993     0.200
   151.284     7.151     0.200
   148.779     4.676     0.200
   148.845     4.679     0.200
   148.975     4.727     0.200
   149.883     4.846     0.200
   150.157     5.156     0.200
   150.506     6.838     0.200
   150.506     5.963     0.200
   151.178     6.223     0.200
   151.372     7.098     0.200
   148.832     4.887     0.200
   151.230     6.970     0.200
   153.900     8.412     0.200
   151.352     6.802     0.200
   154.000     8.966     0.200
   149.778     5.433     0.200
   149.634     4.991     0.200
   150.265     5.265     0.200
   151.130     6.146     0.200
   148.822     4.489     0.200
   148.948     4.974     0.200
   150.483     6.020     0.200
   148.730     4.793     0.200
   148.824     4.450     0.200
   148.948     4.630     0.200
   149.839     5.265     0.200
   150.127     5.411     0.200
   150.485     5.981     0.200
   151.142     6.035     0.200
   151.348     6.262     0.200
   151.849     6.403     0.200
   154.081     8.266     0.200
   148.503     4.369     0.200
   148.628     4.556     0.200
   149.525     5.371     0.200
   150.163     6.072     0.200
   151.027     6.510     0.200
   151.528     6.576     0.200
   153.760     7.425     0.200
   148.510     4.501     0.200
   148.728     4.717     0.200
   149.618     4.887     0.200
   149.906     5.368     0.200
   150.265     5.835     0.200
   150.922     6.222     0.200
   151.127     6.492     0.200
   153.862     8.121     0.200
   147.996     3.679     0.200
   148.510     4.619     0.200
   148.597     4.516     0.200
   148.722     4.723     0.200
   149.617     5.335     0.200
   149.901     5.513     0.200
   150.258     5.763     0.200
   150.258     6.003     0.200
   150.918     6.177     0.200
   151.121     6.455     0.200
   151.623     6.662     0.200
   153.854     8.026     0.200
   153.898     9.037     0.200
   153.860     7.992     0.200
   153.126     8.326     0.200
   147.306     4.124     0.200
   148.408     3.995     0.200
   148.964     5.342     0.200
   150.421     5.289     0.200
   153.421     7.304     0.200
   154.140     9.323     0.200
   153.911     8.723     0.200
   153.776     7.995     0.200
   147.929     3.750     0.200
   148.264     4.099     0.200
   148.439     4.574     0.200
   148.520     4.411     0.200
   148.646     4.767     0.200
   149.826     5.393     0.200
   150.181     6.034     0.200
   150.844     6.103     0.200
   151.045     6.424     0.200
   153.777     8.087     0.200
   153.777     7.922     0.200
   153.777     7.692     0.200
   153.429     7.495     0.200
   153.116     8.179     0.200
   153.116     7.616     0.200
   147.594     4.115     0.200
   147.804     4.048     0.200
   147.901     4.088     0.200
   148.722     4.955     0.200
   149.462     5.913     0.200
   150.059     5.847     0.200
   150.308     6.306     0.200
   153.060     7.770     0.200
   149.062     4.600     0.200
   151.445     5.900     0.200
   152.656     7.235     0.200
   147.985     4.443     0.200
   148.163     4.347     0.200
   149.822     5.968     0.200
   149.822     5.741     0.200
   150.436     6.129     0.200
   150.672     6.104     0.200
   153.419     7.360     0.200
   147.603     3.591     0.200
   147.603     3.822     0.200
   147.788     3.676     0.200
   148.028     4.319     0.200
   148.166     4.604     0.200
   148.353     4.380     0.200
   150.012     5.281     0.200
   150.012     5.973     0.200
   150.622     6.058     0.200
   150.861     6.437     0.200
   153.609     8.083     0.200
   153.609     7.305     0.200
   135.258     0.453     0.200
   153.827     8.453     0.200
   152.987     8.966     0.200
   152.476     6.620     0.200
   152.476     7.043     0.200
   148.315     4.106     0.200
   148.570     4.360     0.200
   147.659     4.348     0.200
   147.943     4.199     0.200
   148.167     4.332     0.200
   149.233     5.153     0.200
   149.488     5.502     0.200
   149.828     6.103     0.200
   150.515     6.267     0.200
   151.142     6.750     0.200
   147.726     3.575     0.200
   148.008     4.099     0.200
   148.229     4.457     0.200
   149.298     5.394     0.200
   149.551     5.409     0.200
   149.890     6.151     0.200
   153.485     8.194     0.200
   147.837     3.963     0.200
   148.837     4.797     0.200
   149.353     6.605     0.200
   150.847     6.737     0.200
   153.819     9.300     0.200
   153.700     8.418     0.200
   150.152     5.407     0.200
   147.860     4.249     0.200
   148.107     4.315     0.200
   148.301     4.266     0.200
   149.403     5.330     0.200
   149.637     5.657     0.200
   149.962     6.212     0.200
   153.556     8.314     0.200
   150.104     5.741     0.200
   148.013     4.170     0.200
   148.225     4.360     0.200
   148.392     4.477     0.200
   149.528     5.510     0.200
   149.742     5.601     0.200
   150.054     6.255     0.200
   150.784     6.460     0.200
   153.716     9.593     0.200
   153.716     9.397     0.200
   147.833     3.712     0.200
   153.449     8.314     0.200
   153.889     8.332     0.200
   153.889     8.676     0.200
   147.643     4.197     0.200
   147.917     4.025     0.200
   149.208     5.314     0.200
   149.795     6.328     0.200
   153.390     7.467     0.200
   136.659     1.544     0.200
   147.576     3.912     0.200
   149.141     4.955     0.200
   149.729     5.906     0.200
   150.421     6.339     0.200
   153.324     8.573     0.200
   150.831     5.734     0.200
   139.364     0.938     0.200
   150.278     6.264     0.200
   153.875     7.953     0.200
   141.576     1.486     0.200
   138.582     2.337     0.200
   150.152     6.124     0.200
   148.032     4.852     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
