#!/bin/bash
gmt begin simeonof10.15_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P simeonof10.15'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.644
    79.000     8.474
    80.000     7.389
    81.000     6.389
    82.000     5.475
    83.000     4.644
    84.000     3.898
    85.000     3.240
    86.000     2.666
    87.000     2.170
    88.000     1.781
    89.000     1.484
    90.000     1.228
    91.000     1.003
    92.000     0.802
    93.000     0.621
    94.000     0.457
    95.000     0.313
    96.000     0.194
    97.000     0.103
    98.000     0.039
    99.000     0.005
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    18.335    -1.317     0.200
    23.511     2.797     0.200
    24.520     1.293     0.200
    25.120    -1.671     0.200
    25.120    -1.470     0.200
    26.269    -0.273     0.200
    27.357     1.742     0.200
    27.869     2.760     0.200
    27.859     2.853     0.200
    28.205     1.864     0.200
    28.816     2.331     0.200
    29.499     2.074     0.200
    29.793     0.473     0.200
    29.945     1.432     0.200
    30.099     1.365     0.200
    30.871     1.955     0.200
    31.582     2.095     0.200
    31.637     1.211     0.200
    31.740    -0.996     0.200
    31.816     2.539     0.200
    31.937     1.776     0.200
    32.992     2.834     0.200
    33.277     2.150     0.200
    33.422    -1.417     0.200
    34.382     1.759     0.200
    34.836     1.537     0.200
    35.564    -2.529     0.200
    35.628     1.523     0.200
    35.781     1.309     0.200
    37.502     1.762     0.200
    39.234     2.007     0.200
    41.328     2.385     0.200
    43.038    -0.236     0.200
    44.151     1.312     0.200
    44.226    -1.793     0.200
    44.226    -1.193     0.200
    44.488    -2.387     0.200
    44.829     0.799     0.200
    45.019     1.392     0.200
    45.056     1.495     0.200
    45.500     0.577     0.200
    46.371     0.414     0.200
    46.380    -0.956     0.200
    46.470    -0.765     0.200
    47.357     0.112     0.200
    47.616    -0.098     0.200
    47.722     1.685     0.200
    48.413     1.044     0.200
    48.962     0.331     0.200
    49.808    -0.120     0.200
    49.886    -0.316     0.200
    50.429    -0.522     0.200
    50.429    -0.325     0.200
    50.459    -0.248     0.200
    50.791    -0.251     0.200
    50.867    -0.521     0.200
    50.919    -0.314     0.200
    51.097    -0.253     0.200
    51.494    -0.020     0.200
    51.928    -0.258     0.200
    53.676    -0.059     0.200
    53.911    -0.275     0.200
    54.092     0.403     0.200
    54.391    -0.271     0.200
    54.660    -0.327     0.200
    54.762    -0.364     0.200
    55.146     0.067     0.200
    55.408    -0.723     0.200
    55.547    -0.923     0.200
    55.612     0.209     0.200
    55.787    -0.244     0.200
    56.219     0.568     0.200
    56.326     0.408     0.200
    56.385     1.387     0.200
    56.536    -0.290     0.200
    57.425     0.122     0.200
    57.588    -1.022     0.200
    57.946    -0.735     0.200
    58.716     0.990     0.200
    58.833    -0.122     0.200
    59.000    -0.878     0.200
    59.322     1.296     0.200
    61.080    -0.329     0.200
    61.631    -1.055     0.200
    62.982     1.113     0.200
    63.298    -0.082     0.200
    63.499    -0.608     0.200
    64.229     0.092     0.200
    64.408     0.717     0.200
    64.519     0.996     0.200
    64.585    -0.035     0.200
    64.880    -0.458     0.200
    65.232    -0.443     0.200
    65.373     0.246     0.200
    65.535     0.097     0.200
    65.593    -0.779     0.200
    65.962     1.051     0.200
    67.391     0.142     0.200
    67.577     0.364     0.200
    67.635     0.400     0.200
    67.662    -0.367     0.200
    67.995     0.238     0.200
    68.035     0.586     0.200
    68.160     0.501     0.200
    68.535     1.356     0.200
    68.573     0.422     0.200
    68.582     0.361     0.200
    68.750    -0.182     0.200
    69.399     0.293     0.200
    69.477    -0.188     0.200
    69.634     0.342     0.200
    69.873     0.472     0.200
    69.985     0.385     0.200
    70.124     0.233     0.200
    70.400     0.849     0.200
    70.422     1.514     0.200
    70.423     2.408     0.200
    70.442     2.493     0.200
    70.674     2.476     0.200
    70.689     2.487     0.200
    70.852     0.897     0.200
    70.852     1.098     0.200
    71.196    -1.391     0.200
    71.353     0.861     0.200
    71.527     1.811     0.200
    71.977     0.814     0.200
    72.080     0.697     0.200
    72.135     2.166     0.200
    72.672     1.269     0.200
    72.710     1.740     0.200
    72.759     0.451     0.200
    72.958     0.769     0.200
    73.921     0.107     0.200
    74.034     0.151     0.200
    74.128     0.099     0.200
    74.433    -0.574     0.200
    74.505     0.704     0.200
    74.605     0.126     0.200
    74.629     0.488     0.200
    74.639     1.229     0.200
    74.849     0.618     0.200
    74.973     0.099     0.200
    75.190     0.249     0.200
    75.326    -0.030     0.200
    75.355     0.201     0.200
    75.411     0.479     0.200
    75.428    -0.116     0.200
    75.428     1.084     0.200
    75.558     0.839     0.200
    75.580     0.211     0.200
    75.599    -0.094     0.200
    75.670     0.697     0.200
    75.799     2.760     0.200
    75.906     2.051     0.200
    75.994     0.851     0.200
    76.189     0.640     0.200
    76.232     0.795     0.200
    76.295     0.140     0.200
    76.370     0.314     0.200
    76.555     0.671     0.200
    76.560     0.240     0.200
    76.740    -0.074     0.200
    76.877     0.654     0.200
    76.897     0.338     0.200
    76.987     0.234     0.200
    77.083     0.493     0.200
    77.089     0.561     0.200
    77.104    -0.122     0.200
    77.185    -0.077     0.200
    77.357     0.459     0.200
    77.451    -0.568     0.200
    77.451     0.232     0.200
    77.518     0.958     0.200
    77.522     0.636     0.200
    77.539     0.440     0.200
    77.570    -0.229     0.200
    77.609     0.549     0.200
    77.758     0.724     0.200
    77.772     0.543     0.200
    77.837     0.083     0.200
    77.970     0.141     0.200
    78.002     1.365     0.200
    78.067     0.006     0.200
    78.086     0.702     0.200
    78.133     0.640     0.200
    78.188    -0.665     0.200
    78.250     0.594     0.200
    78.362     1.073     0.200
    78.678    -0.369     0.200
    78.678     0.431     0.200
    78.716     0.221     0.200
    78.943     0.477     0.200
    78.943    -0.823     0.200
    79.014     0.190     0.200
    79.270     0.790     0.200
    79.353     0.439     0.200
    79.379     0.798     0.200
    79.396     0.603     0.200
    79.447     0.725     0.200
    79.456     0.578     0.200
    79.582     0.695     0.200
    79.586     0.668     0.200
    79.659     0.275     0.200
    79.659     0.675     0.200
    79.658    -0.018     0.200
    79.850     1.439     0.200
    80.025     0.796     0.200
    80.083     2.982     0.200
    80.414     0.700     0.200
    80.607     0.166     0.200
    80.656     0.601     0.200
    80.675     0.801     0.200
    80.693    -0.295     0.200
    80.694    -0.300     0.200
    80.751     0.397     0.200
    81.059    -2.045     0.200
    81.088     0.000     0.200
    81.264     0.665     0.200
    81.312     1.409     0.200
    81.312     0.510     0.200
    81.330    -0.684     0.200
    81.343     1.246     0.200
    81.362     0.847     0.200
    81.388     1.008     0.200
    81.459     1.635     0.200
    81.734     1.183     0.200
    81.734     1.583     0.200
    82.144     0.026     0.200
    82.147     0.014     0.200
    82.290     1.265     0.200
    82.295     1.237     0.200
    82.491     0.818     0.200
    82.441     0.979     0.200
    82.749    -0.026     0.200
    82.689     0.986     0.200
    82.925     1.362     0.200
    82.924    -0.530     0.200
    82.944     1.366     0.200
    82.990     1.628     0.200
    83.227     0.202     0.200
    83.459     0.706     0.200
    83.501     0.393     0.200
    83.569     0.643     0.200
    83.504     0.179     0.200
    83.706     0.941     0.200
    83.756     2.689     0.200
    84.076     0.557     0.200
    84.130     0.778     0.200
    84.155     1.952     0.200
    84.368     0.370     0.200
    84.750    -0.358     0.200
    85.383     1.474     0.200
    85.481    -0.011     0.200
    86.156     1.643     0.200
    86.454     0.379     0.200
    86.850    -0.757     0.200
    87.441    -0.620     0.200
    87.377     0.987     0.200
    87.377     0.687     0.200
    87.534     0.533     0.200
    87.591     2.661     0.200
    87.875    -0.296     0.200
    88.299     1.297     0.200
    90.956    -0.134     0.200
    91.275     0.589     0.200
    92.374     0.304     0.200
    92.802     0.327     0.200
    92.808     0.200     0.200
    94.490    -0.436     0.200
    96.202    -0.449     0.200
    15.519     2.230     0.200
    18.311    -2.612     0.200
    23.846    -0.279     0.200
    24.587    -0.032     0.200
    26.183    -1.509     0.200
    26.231     0.055     0.200
    27.317     0.278     0.200
    27.402     1.518     0.200
    31.710    -0.644     0.200
    33.345    -1.953     0.200
    33.345    -1.453     0.200
    34.422     1.801     0.200
    35.487    -1.078     0.200
    35.721     0.221     0.200
    36.969    -0.132     0.200
    38.573     1.637     0.200
    39.284     1.789     0.200
    41.390     2.176     0.200
    41.937     1.301     0.200
    42.889    -0.237     0.200
    43.719    -0.325     0.200
    44.100     0.715     0.200
    44.411    -1.474     0.200
    44.778     1.104     0.200
    44.966     1.008     0.200
    45.005     1.495     0.200
    45.156     0.800     0.200
    46.313     0.570     0.200
    46.332    -1.273     0.200
    46.454     1.868     0.200
    47.291    -0.167     0.200
    47.661    -0.642     0.200
    47.669     1.896     0.200
    49.016     0.519     0.200
    49.019    -0.301     0.200
    49.885    -1.101     0.200
    51.945    -0.583     0.200
    52.271    -2.004     0.200
    52.271    -1.104     0.200
    52.941    -0.852     0.200
    54.015     0.168     0.200
    54.015     0.568     0.200
    54.126     1.364     0.200
    54.426    -0.320     0.200
    55.176     0.053     0.200
    55.420    -0.202     0.200
    55.485    -1.066     0.200
    55.728    -0.609     0.200
    56.319     0.068     0.200
    56.366    -0.765     0.200
    56.343     1.294     0.200
    57.148    -0.611     0.200
    57.360    -0.310     0.200
    57.528    -0.988     0.200
    57.745     0.482     0.200
    57.883    -0.486     0.200
    58.656     0.521     0.200
    58.755    -1.569     0.200
    58.755    -1.169     0.200
    58.922    -1.026     0.200
    59.260    -0.662     0.200
    61.017    -0.487     0.200
    61.203    -0.249     0.200
    61.571    -0.736     0.200
    62.918     0.153     0.200
    63.230     0.488     0.200
    63.421    -0.478     0.200
    63.673     0.158     0.200
    64.173     0.173     0.200
    64.337     1.301     0.200
    64.818    -0.337     0.200
    64.820    -0.251     0.200
    65.308    -0.519     0.200
    65.481    -0.634     0.200
    65.535    -0.583     0.200
    65.884     0.666     0.200
    68.526     0.329     0.200
    68.536     0.168     0.200
    68.682    -0.939     0.200
    68.831    -0.471     0.200
    69.356     0.179     0.200
    69.409    -0.450     0.200
    69.830     0.355     0.200
    69.942     0.271     0.200
    70.005     0.183     0.200
    70.081     0.319     0.200
    70.334     0.873     0.200
    70.371    -1.356     0.200
    70.583     0.349     0.200
    70.571     0.427     0.200
    70.701     0.135     0.200
    71.102     0.399     0.200
    71.899     2.802     0.200
    72.906     0.898     0.200
    73.871     0.723     0.200
    73.938     0.833     0.200
    73.978    -0.301     0.200
    74.031     0.789     0.200
    74.449     0.354     0.200
    74.534     0.860     0.200
    74.547    -0.216     0.200
    74.574     0.129     0.200
    74.589     0.843     0.200
    74.796     0.246     0.200
    75.112     0.521     0.200
    75.269     0.619     0.200
    75.309    -0.010     0.200
    75.355     0.328     0.200
    75.368     0.151     0.200
    75.503     0.775     0.200
    75.504     1.070     0.200
    75.534     0.101     0.200
    75.624     0.084     0.200
    75.832     1.696     0.200
    75.948     0.735     0.200
    76.133     0.581     0.200
    76.176     0.737     0.200
    76.235    -0.195     0.200
    76.280     0.750     0.200
    76.688     0.542     0.200
    76.768     1.090     0.200
    76.768     1.590     0.200
    76.819     0.801     0.200
    76.819     0.901     0.200
    76.927     0.297     0.200
    77.052     0.691     0.200
    77.127    -0.528     0.200
    77.308     0.259     0.200
    77.373    -1.309     0.200
    77.472     0.440     0.200
    77.473     0.534     0.200
    77.483     0.080     0.200
    77.508     0.941     0.200
    77.517    -0.112     0.200
    77.554     0.583     0.200
    77.601     0.221     0.200
    77.714     0.592     0.200
    77.723     0.139     0.200
    77.921    -0.061     0.200
    77.943     0.520     0.200
    77.989     0.463     0.200
    78.038     0.489     0.200
    78.085     0.330     0.200
    78.201     0.386     0.200
    78.308     0.998     0.200
    78.871     0.401     0.200
    79.224     0.669     0.200
    79.408     0.461     0.200
    79.535     0.374     0.200
    79.787     0.409     0.200
    79.973     1.400     0.200
    80.343     0.406     0.200
    80.641    -0.192     0.200
    80.684     0.582     0.200
    80.684     0.082     0.200
    80.998     0.406     0.200
    81.173     2.174     0.200
    81.236     1.641     0.200
    81.252    -0.343     0.200
    81.324     0.974     0.200
    81.532     1.076     0.200
    81.657     2.414     0.200
    81.729     1.037     0.200
    81.930     0.980     0.200
    82.071     0.238     0.200
    82.484     1.381     0.200
    82.663     0.950     0.200
    82.685     1.034     0.200
    82.734     0.081     0.200
    82.848     1.489     0.200
    82.868     0.083     0.200
    82.934     0.743     0.200
    83.142    -0.034     0.200
    83.153     0.609     0.200
    83.302     1.844     0.200
    83.418     1.246     0.200
    83.643     1.094     0.200
    83.672     0.946     0.200
    83.940     0.774     0.200
    84.405     1.011     0.200
    84.535     1.556     0.200
    84.807     0.985     0.200
    84.923     1.406     0.200
    85.417     0.437     0.200
    85.495     0.646     0.200
    85.926     0.512     0.200
    86.115     3.175     0.200
    86.414     1.205     0.200
    86.785     0.089     0.200
    87.378     0.410     0.200
    87.525     0.804     0.200
    87.974     0.765     0.200
    88.441     0.457     0.200
    91.100     0.031     0.200
    92.298     0.483     0.200
    92.790     0.213     0.200
    92.796    -0.214     0.200
    96.127    -0.376     0.200
    15.823     2.866     0.200
    18.306    -2.053     0.200
    23.255     1.556     0.200
    24.453    -0.065     0.200
    25.401    -1.086     0.200
    26.541    -0.507     0.200
    27.110     1.370     0.200
    29.698     1.423     0.200
    31.664     2.372     0.200
    31.736    -0.656     0.200
    33.668    -1.562     0.200
    34.271     1.208     0.200
    34.582     1.714     0.200
    35.841    -1.424     0.200
    36.058     1.825     0.200
    38.228     2.410     0.200
    38.979     1.900     0.200
    41.051     2.416     0.200
    42.676    -0.360     0.200
    43.665    -0.253     0.200
    43.964    -0.754     0.200
    43.964    -0.654     0.200
    44.408     0.689     0.200
    44.766    -2.165     0.200
    44.766    -1.365     0.200
    45.087     1.275     0.200
    45.280     1.350     0.200
    45.313     1.482     0.200
    46.489     0.613     0.200
    46.700    -0.438     0.200
    47.106     0.092     0.200
    47.372    -0.284     0.200
    47.641     0.228     0.200
    48.697     0.172     0.200
    48.751     0.063     0.200
    49.776    -0.173     0.200
    52.760    -1.134     0.200
    54.372    -0.249     0.200
    54.480     0.864     0.200
    54.480     1.064     0.200
    54.793    -0.407     0.200
    55.688    -0.856     0.200
    55.913    -0.069     0.200
    56.108    -0.562     0.200
    56.131    -0.029     0.200
    56.384    -0.833     0.200
    57.496    -0.410     0.200
    57.716    -0.259     0.200
    58.087    -0.258     0.200
    58.087     0.142     0.200
    58.103     1.034     0.200
    59.262    -0.231     0.200
    61.224    -1.458     0.200
    61.760    -0.771     0.200
    62.761    -0.776     0.200
    63.263     0.894     0.200
    63.583     0.776     0.200
    63.758    -0.875     0.200
    63.967     0.046     0.200
    64.694     0.986     0.200
    64.801    -1.208     0.200
    64.801    -0.608     0.200
    64.946    -0.505     0.200
    64.988    -0.125     0.200
    65.019    -0.627     0.200
    65.344    -0.337     0.200
    65.366    -0.529     0.200
    65.637     0.373     0.200
    65.715     0.166     0.200
    66.236     0.920     0.200
    68.635     0.352     0.200
    68.821     0.696     0.200
    71.117     0.096     0.200
    71.117     0.696     0.200
    72.237    -0.638     0.200
    72.237     0.062     0.200
    72.321    -0.141     0.200
    72.935     1.208     0.200
    72.935     1.608     0.200
    73.047     0.545     0.200
    74.141     0.423     0.200
    74.615     0.263     0.200
    74.720     1.159     0.200
    74.722     0.044     0.200
    74.732     0.689     0.200
    74.872     0.879     0.200
    74.872     0.979     0.200
    75.523     0.132     0.200
    75.644     1.436     0.200
    75.732     1.338     0.200
    76.189     0.334     0.200
    76.341     1.071     0.200
    76.341     0.471     0.200
    77.117     0.092     0.200
    77.316     2.276     0.200
    77.388    -0.430     0.200
    77.433     1.020     0.200
    77.580     0.897     0.200
    77.597     1.205     0.200
    77.695    -0.145     0.200
    77.846     0.216     0.200
    78.046     1.008     0.200
    78.093     0.745     0.200
    78.203     0.438     0.200
    78.320     0.586     0.200
    79.080     0.407     0.200
    79.333    -0.276     0.200
    79.524     0.887     0.200
    79.646     0.122     0.200
    80.194     1.160     0.200
    80.740    -0.775     0.200
    80.805     1.583     0.200
    81.148    -0.647     0.200
    81.034     0.657     0.200
    81.034     0.157     0.200
    81.590    -0.590     0.200
    81.590    -0.690     0.200
    81.714     1.059     0.200
    81.803     1.588     0.200
    82.043    -0.672     0.200
    82.043    -0.172     0.200
    82.292     0.023     0.200
    83.029     2.988     0.200
    83.500     1.761     0.200
    83.550     1.606     0.200
    83.634     1.076     0.200
    84.267     0.646     0.200
    84.339     1.483     0.200
    84.499    -0.030     0.200
    85.026     0.716     0.200
    85.107     1.312     0.200
    85.630    -0.096     0.200
    87.487     0.206     0.200
    92.956     0.261     0.200
    15.908     3.719     0.200
    18.356    -1.982     0.200
    24.236     1.436     0.200
    25.476    -1.345     0.200
    26.611     0.381     0.200
    35.918    -2.085     0.200
    43.704    -0.194     0.200
    44.036    -0.854     0.200
    44.036    -0.154     0.200
    44.842    -2.302     0.200
    44.842    -1.700     0.200
    45.316     0.931     0.200
    46.525    -0.903     0.200
    46.785    -0.639     0.200
    47.698    -0.148     0.200
    50.037     1.303     0.200
    50.165     0.332     0.200
    54.447    -0.448     0.200
    54.447     0.052     0.200
    55.312     0.288     0.200
    55.769    -0.792     0.200
    57.184     0.931     0.200
    57.796    -0.478     0.200
    58.168    -0.984     0.200
    58.167     0.821     0.200
    59.008     1.162     0.200
    59.344    -1.161     0.200
    59.344    -0.661     0.200
    61.306     0.424     0.200
    62.842    -0.488     0.200
    63.643    -0.195     0.200
    63.840    -0.493     0.200
    63.840    -0.294     0.200
    64.053    -0.091     0.200
    64.234    -0.078     0.200
    64.411    -0.342     0.200
    64.887    -0.342     0.200
    65.100    -0.329     0.200
    65.421    -0.711     0.200
    66.314     0.441     0.200
    68.704     0.139     0.200
    68.821     1.107     0.200
    70.739     1.201     0.200
    71.199     1.016     0.200
    71.199     1.414     0.200
    72.319     1.279     0.200
    74.217     0.282     0.200
    74.259     0.341     0.200
    74.423     0.486     0.200
    74.692    -0.178     0.200
    74.792    -0.255     0.200
    74.807     0.655     0.200
    75.372     1.298     0.200
    75.487     0.339     0.200
    75.600     0.094     0.200
    75.735     0.823     0.200
    75.800     0.447     0.200
    76.123     0.609     0.200
    76.417     0.739     0.200
    76.716     0.549     0.200
    77.034     0.455     0.200
    77.248     0.256     0.200
    77.466     1.232     0.200
    77.504     0.320     0.200
    77.649     0.613     0.200
    77.668     0.305     0.200
    77.798     0.081     0.200
    77.917     0.320     0.200
    78.086     0.280     0.200
    78.117     0.211     0.200
    78.140     0.780     0.200
    78.140     1.178     0.200
    78.223     0.523     0.200
    78.176    -0.418     0.200
    78.176     0.183     0.200
    78.273     0.445     0.200
    78.391     0.293     0.200
    78.456     1.138     0.200
    79.150     0.222     0.200
    79.403     0.542     0.200
    79.526    -0.628     0.200
    79.557     1.602     0.200
    79.594     0.501     0.200
    79.716     0.339     0.200
    80.685     1.116     0.200
    80.808     1.058     0.200
    80.920     1.263     0.200
    81.092     0.742     0.200
    81.216     0.082     0.200
    82.438     0.653     0.200
    83.565     1.316     0.200
    83.714     1.055     0.200
    84.347     0.826     0.200
    84.579     0.654     0.200
    87.461     1.216     0.200
    87.461     1.216     0.200
    23.030     1.631     0.200
    23.967     2.739     0.200
    24.272    -0.047     0.200
    24.327    -0.352     0.200
    24.282     2.566     0.200
    24.953     2.644     0.200
    24.953     2.132     0.200
    25.315     2.154     0.200
    25.634    -0.735     0.200
    26.781    -0.603     0.200
    26.799    -0.267     0.200
    26.885     0.561     0.200
    26.892     1.891     0.200
    27.392     2.500     0.200
    27.415     1.997     0.200
    27.753     1.868     0.200
    27.802     2.033     0.200
    28.072     1.617     0.200
    28.297     2.514     0.200
    28.981     2.232     0.200
    29.368     0.594     0.200
    29.572     2.485     0.200
    29.579     1.526     0.200
    30.334     2.141     0.200
    30.346     2.136     0.200
    30.895     1.992     0.200
    31.057     2.360     0.200
    31.112     1.874     0.200
    31.318     2.562     0.200
    31.428     2.495     0.200
    31.583     1.731     0.200
    31.968     2.547     0.200
    32.237     2.680     0.200
    32.381     2.216     0.200
    32.467     2.863     0.200
    32.768     2.533     0.200
    33.687     1.814     0.200
    33.866    -1.750     0.200
    34.029     1.835     0.200
    34.039     0.750     0.200
    34.343     0.612     0.200
    34.359     0.978     0.200
    34.407     1.562     0.200
    35.223     2.516     0.200
    35.320     1.683     0.200
    35.869     0.968     0.200
    36.071    -2.568     0.200
    36.522     1.378     0.200
    36.630     1.460     0.200
    37.126    -1.259     0.200
    37.241     2.264     0.200
    37.986     1.957     0.200
    38.411    -0.625     0.200
    38.744    -0.216     0.200
    39.412    -0.005     0.200
    41.378     1.755     0.200
    41.381     1.401     0.200
    42.050     1.328     0.200
    42.262     1.498     0.200
    42.501    -0.050     0.200
    43.590    -0.461     0.200
    44.201    -0.373     0.200
    44.308     0.969     0.200
    44.635     0.758     0.200
    44.746     0.472     0.200
    44.995    -2.214     0.200
    45.078    -0.670     0.200
    45.312    -0.033     0.200
    45.315     0.947     0.200
    45.438     0.970     0.200
    45.509     0.792     0.200
    45.509     0.909     0.200
    45.554     1.252     0.200
    45.654     0.866     0.200
    45.690     0.676     0.200
    45.716     0.773     0.200
    46.059     0.967     0.200
    46.182     0.696     0.200
    46.498    -1.190     0.200
    46.704     0.801     0.200
    46.882    -0.793     0.200
    46.887     0.463     0.200
    47.091     1.872     0.200
    47.155     0.072     0.200
    47.321     0.876     0.200
    47.483    -0.082     0.200
    47.883    -0.386     0.200
    48.214     1.359     0.200
    48.373     2.132     0.200
    48.553    -0.961     0.200
    48.466     0.311     0.200
    48.502     0.533     0.200
    48.545    -0.594     0.200
    49.665    -0.873     0.200
    50.124     1.040     0.200
    50.189     0.494     0.200
    50.223     0.887     0.200
    50.351    -0.082     0.200
    51.140     0.471     0.200
    51.512    -0.013     0.200
    51.512    -0.814     0.200
    51.587    -1.378     0.200
    51.597    -1.252     0.200
    51.637    -0.748     0.200
    52.005    -0.098     0.200
    52.604    -1.341     0.200
    52.790    -0.919     0.200
    52.857    -0.818     0.200
    53.162    -1.063     0.200
    53.316    -0.698     0.200
    53.380    -0.365     0.200
    53.485     0.560     0.200
    53.619    -0.479     0.200
    54.604     0.393     0.200
    55.288    -0.057     0.200
    55.495     0.455     0.200
    55.535     0.164     0.200
    55.595    -0.565     0.200
    55.790    -0.862     0.200
    55.790    -1.171     0.200
    55.907    -1.105     0.200
    56.002    -0.880     0.200
    56.288    -0.725     0.200
    56.445     1.755     0.200
    56.738     1.072     0.200
    57.114     0.102     0.200
    57.151     1.642     0.200
    57.363     1.649     0.200
    57.345     1.772     0.200
    57.415     2.782     0.200
    57.693    -1.280     0.200
    57.738     0.004     0.200
    57.808    -0.883     0.200
    57.756     1.380     0.200
    58.011     1.087     0.200
    58.189    -1.159     0.200
    58.344     0.756     0.200
    59.190     0.675     0.200
    59.230     0.602     0.200
    59.297    -0.865     0.200
    59.355    -1.064     0.200
    59.355    -0.763     0.200
    59.475     0.204     0.200
    59.371    -1.176     0.200
    59.840    -0.609     0.200
    60.358     2.842     0.200
    60.602     3.173     0.200
    60.999    -1.325     0.200
    61.330    -0.071     0.200
    61.851    -0.984     0.200
    61.876     0.542     0.200
    62.864    -0.766     0.200
    63.504     0.491     0.200
    63.511     1.640     0.200
    63.826     0.169     0.200
    63.968    -0.769     0.200
    64.140     0.501     0.200
    64.403     0.779     0.200
    64.393     0.840     0.200
    64.727    -0.940     0.200
    64.798     1.195     0.200
    64.971    -0.426     0.200
    64.936     0.798     0.200
    65.119    -0.394     0.200
    65.204     0.057     0.200
    65.421    -0.548     0.200
    65.384     0.389     0.200
    65.638    -0.252     0.200
    65.604    -0.034     0.200
    65.704     0.240     0.200
    65.801    -0.700     0.200
    66.462     0.451     0.200
    66.422    -0.294     0.200
    67.711    -0.379     0.200
    68.668    -0.486     0.200
    69.002     1.039     0.200
    69.053    -0.876     0.200
    69.165     0.428     0.200
    69.373    -0.861     0.200
    69.776    -0.548     0.200
    69.814     0.021     0.200
    69.827     1.339     0.200
    69.968     0.871     0.200
    70.141     0.408     0.200
    70.106     2.521     0.200
    70.123     2.021     0.200
    70.461     2.652     0.200
    70.354     2.504     0.200
    70.370     2.306     0.200
    70.740    -0.248     0.200
    70.746     0.317     0.200
    70.966     0.178     0.200
    70.925     1.125     0.200
    70.907    -1.164     0.200
    71.023     0.031     0.200
    71.140     0.520     0.200
    71.127     0.599     0.200
    71.215     0.064     0.200
    71.211     0.891     0.200
    71.335     2.142     0.200
    71.301     0.845     0.200
    72.007     2.096     0.200
    72.120     1.420     0.200
    72.280     1.460     0.200
    72.449     1.454     0.200
    72.325     1.192     0.200
    72.404     3.118     0.200
    72.432     2.556     0.200
    72.846     1.092     0.200
    72.699     3.362     0.200
    73.064     0.799     0.200
    73.103     0.567     0.200
    73.113     1.012     0.200
    73.457    -0.517     0.200
    74.021    -0.028     0.200
    74.050     0.001     0.200
    74.159     0.568     0.200
    74.126     0.557     0.200
    74.213     0.052     0.200
    74.239     0.101     0.200
    74.313     0.270     0.200
    74.328     0.482     0.200
    74.380    -1.023     0.200
    74.403     0.343     0.200
    74.496    -0.694     0.200
    74.690     0.279     0.200
    74.769     0.323     0.200
    74.800     0.142     0.200
    74.803     0.125     0.200
    74.924     0.423     0.200
    75.001     0.379     0.200
    74.879     1.082     0.200
    75.020     1.372     0.200
    75.083     1.310     0.200
    75.145     0.046     0.200
    75.086     2.390     0.200
    75.256     1.310     0.200
    75.352     0.758     0.200
    75.399     0.290     0.200
    75.452     0.183     0.200
    75.493     0.649     0.200
    75.599     0.644     0.200
    75.646    -0.028     0.200
    75.510     1.551     0.200
    75.727     0.657     0.200
    75.764     0.597     0.200
    75.839     0.667     0.200
    76.086     0.659     0.200
    76.168     0.396     0.200
    76.366     0.566     0.200
    76.414     0.700     0.200
    76.414     0.399     0.200
    76.430     0.809     0.200
    76.515     1.225     0.200
    76.519     0.601     0.200
    76.570     1.512     0.200
    76.698     0.689     0.200
    76.769     0.392     0.200
    77.014     0.510     0.200
    77.061     0.246     0.200
    76.985    -0.928     0.200
    77.228     0.504     0.200
    77.241     0.537     0.200
    77.250     0.783     0.200
    77.222    -0.157     0.200
    77.295     0.232     0.200
    77.274     2.046     0.200
    77.358     0.377     0.200
    77.365     0.639     0.200
    77.382     0.246     0.200
    77.389     0.509     0.200
    77.471     0.647     0.200
    77.478     0.306     0.200
    77.394    -0.324     0.200
    77.613     0.851     0.200
    77.641     0.499     0.200
    77.659     0.795     0.200
    77.719     0.364     0.200
    77.724     0.135     0.200
    77.771     0.370     0.200
    77.785     1.492     0.200
    77.786     0.790     0.200
    77.876     0.986     0.200
    77.889     0.414     0.200
    77.907     0.814     0.200
    77.970     1.465     0.200
    77.827     1.262     0.200
    78.025     0.860     0.200
    78.057     0.381     0.200
    78.090     0.298     0.200
    78.271     0.794     0.200
    78.301     0.728     0.200
    78.331     0.663     0.200
    78.331     1.663     0.200
    78.400     0.983     0.200
    78.451     1.198     0.200
    78.457    -1.032     0.200
    78.527     1.083     0.200
    78.535     0.535     0.200
    78.589     0.838     0.200
    78.646     1.126     0.200
    78.730     0.861     0.200
    78.796     1.401     0.200
    78.871     0.286     0.200
    78.902     0.514     0.200
    78.956     2.223     0.200
    78.987     1.151     0.200
    79.022     1.358     0.200
    79.097     0.344     0.200
    79.066    -0.381     0.200
    79.102     1.722     0.200
    79.117     0.441     0.200
    79.124     0.798     0.200
    79.249     0.616     0.200
    79.353     0.550     0.200
    79.367     0.669     0.200
    79.383     0.385     0.200
    79.469    -0.641     0.200
    79.469    -0.086     0.200
    79.518     0.046     0.200
    79.522    -0.271     0.200
    79.523     1.021     0.200
    79.538     0.240     0.200
    79.537     1.447     0.200
    79.562     0.310     0.200
    79.597     0.719     0.200
    79.695     0.188     0.200
    79.747     0.407     0.200
    79.794     0.648     0.200
    79.838     0.412     0.200
    79.851    -0.659     0.200
    79.967     0.716     0.200
    79.993     1.072     0.200
    80.018     0.439     0.200
    80.029     0.876     0.200
    80.073     0.141     0.200
    80.073     1.141     0.200
    80.084     0.084     0.200
    80.103    -0.024     0.200
    80.292     0.961     0.200
    80.263    -0.884     0.200
    80.329     0.762     0.200
    80.359    -1.402     0.200
    80.450     0.312     0.200
    80.450     1.113     0.200
    80.309     2.668     0.200
    80.611     0.248     0.200
    80.589     0.762     0.200
    80.745     0.530     0.200
    80.836     0.544     0.200
    80.848     0.979     0.200
    80.896     0.822     0.200
    80.891     0.250     0.200
    80.906     0.169     0.200
    80.922     0.282     0.200
    80.884    -1.216     0.200
    80.973    -1.686     0.200
    80.972     1.120     0.200
    81.066     0.517     0.200
    81.083     1.328     0.200
    81.173    -1.752     0.200
    81.179     0.112     0.200
    81.182     0.200     0.200
    81.054     0.780     0.200
    81.241    -1.116     0.200
    81.289     0.131     0.200
    81.288     1.637     0.200
    81.277     0.296     0.200
    81.277     0.393     0.200
    81.360     0.854     0.200
    81.389     1.100     0.200
    81.444     0.809     0.200
    81.519     1.210     0.200
    81.622     0.867     0.200
    81.654     0.798     0.200
    81.666     0.032     0.200
    81.729     1.800     0.200
    81.737     1.260     0.200
    81.768     1.099     0.200
    81.798     0.937     0.200
    81.821     0.819     0.200
    81.739    -0.647     0.200
    81.957     1.102     0.200
    81.787     0.598     0.200
    81.941     0.685     0.200
    82.001     0.872     0.200
    81.984     1.560     0.200
    82.162     1.829     0.200
    82.010     1.427     0.200
    82.232     0.259     0.200
    82.232     0.658     0.200
    82.227    -0.016     0.200
    82.322     0.191     0.200
    82.364     1.967     0.200
    82.272     0.451     0.200
    82.398    -0.206     0.200
    82.513     1.189     0.200
    82.638     0.542     0.200
    82.757     1.220     0.200
    82.836     1.508     0.200
    82.809     1.254     0.200
    82.946     1.544     0.200
    83.084     0.228     0.200
    83.094     0.175     0.200
    83.095     0.668     0.200
    83.061    -0.654     0.200
    83.166     1.302     0.200
    83.177     0.145     0.200
    83.270     0.267     0.200
    83.274     0.545     0.200
    83.304     1.589     0.200
    83.271     0.262     0.200
    83.366     0.770     0.200
    83.515     1.203     0.200
    83.529    -0.070     0.200
    83.554     0.801     0.200
    83.598     0.777     0.200
    83.586     1.036     0.200
    83.677     0.975     0.200
    83.721     0.644     0.200
    83.728     1.011     0.200
    83.723    -0.064     0.200
    83.672     1.199     0.200
    83.921     0.922     0.200
    83.958     0.734     0.200
    83.926     0.397     0.200
    84.023    -0.597     0.200
    84.073     1.150     0.200
    84.179     0.611     0.200
    84.309     0.450     0.200
    84.354     0.420     0.200
    84.355     0.816     0.200
    84.365     0.865     0.200
    84.518     0.992     0.200
    84.547     0.542     0.200
    84.549     0.732     0.200
    84.550     0.425     0.200
    84.556     1.695     0.200
    84.731     1.211     0.200
    84.786     0.535     0.200
    84.825     0.841     0.200
    84.848     0.827     0.200
    85.033     0.399     0.200
    85.042     0.749     0.200
    85.046    -0.068     0.200
    85.067     0.429     0.200
    85.127     0.823     0.200
    85.140     0.561     0.200
    85.197     0.974     0.200
    85.235     1.286     0.200
    85.235     1.419     0.200
    85.275     0.784     0.200
    85.319     0.265     0.200
    85.348     0.919     0.200
    85.389     0.317     0.200
    85.482     0.850     0.200
    85.578     1.572     0.200
    85.585     0.239     0.200
    85.620     1.065     0.200
    85.622     1.353     0.200
    85.709     0.226     0.200
    85.733    -0.197     0.200
    85.736    -0.413     0.200
    85.739     0.074     0.200
    85.833     0.408     0.200
    85.860     0.375     0.200
    85.863    -1.142     0.200
    86.073     1.122     0.200
    86.076     2.106     0.200
    86.156     0.909     0.200
    86.101    -1.019     0.200
    86.197     1.510     0.200
    86.209     1.449     0.200
    86.320     0.205     0.200
    86.388     1.566     0.200
    86.425     0.587     0.200
    86.677    -1.049     0.200
    87.115    -0.088     0.200
    87.224     0.982     0.200
    87.418     0.045     0.200
    87.523     0.143     0.200
    87.548     0.421     0.200
    87.683    -0.730     0.200
    87.678    -0.705     0.200
    87.599     0.774     0.200
    87.599     0.774     0.200
    87.599     1.008     0.200
    87.820     0.220     0.200
    87.861     0.922     0.200
    88.146    -1.929     0.200
    88.312     0.887     0.200
    88.362     1.048     0.200
    88.521    -0.199     0.200
    88.582     1.113     0.200
    88.737    -0.720     0.200
    88.894    -2.458     0.200
    88.987     0.106     0.200
    89.171     0.241     0.200
    89.459     0.391     0.200
    89.822     1.691     0.200
    90.006     1.331     0.200
    90.811     0.582     0.200
    91.221    -0.321     0.200
    91.430     0.711     0.200
    91.398     1.161     0.200
    91.670     0.495     0.200
    92.176     2.258     0.200
    92.470     1.999     0.200
    92.892    -0.049     0.200
    92.971     0.587     0.200
    93.084    -0.233     0.200
    93.108     0.954     0.200
    93.987     0.910     0.200
    94.077     0.697     0.200
    94.211    -2.117     0.200
    94.396     0.034     0.200
    94.441    -0.173     0.200
    95.001    -0.739     0.200
    96.460     0.313     0.200
    96.722     0.426     0.200
    24.205     0.286     0.200
    24.358     0.689     0.200
    25.515    -1.542     0.200
    26.178    -0.839     0.200
    26.673     0.690     0.200
    26.877     0.951     0.200
    26.917     1.491     0.200
    28.368     2.617     0.200
    29.372     0.593     0.200
    29.651     1.724     0.200
    31.393     2.541     0.200
    32.826     2.162     0.200
    33.760     2.022     0.200
    34.392     1.540     0.200
    34.481     2.771     0.200
    35.182     2.719     0.200
    35.296     2.736     0.200
    36.597     1.597     0.200
    38.061     2.191     0.200
    41.431     0.663     0.200
    42.478    -0.387     0.200
    44.089    -0.391     0.200
    44.089    -0.289     0.200
    44.872    -1.645     0.200
    44.872    -1.544     0.200
    45.000    -0.862     0.200
    45.466     0.639     0.200
    46.361    -1.311     0.200
    46.734    -1.740     0.200
    47.149     1.321     0.200
    47.801    -0.649     0.200
    48.513    -0.043     0.200
    49.595    -1.230     0.200
    50.143     0.907     0.200
    50.271    -0.061     0.200
    51.562    -1.273     0.200
    52.565    -1.237     0.200
    54.484     0.190     0.200
    55.407     0.517     0.200
    55.641    -0.363     0.200
    57.659     0.500     0.200
    58.040    -0.970     0.200
    58.040    -0.173     0.200
    58.247     0.978     0.200
    59.339    -0.313     0.200
    59.771    -0.189     0.200
    61.180    -0.009     0.200
    61.703    -1.040     0.200
    61.741     0.405     0.200
    62.715     0.182     0.200
    63.430     0.138     0.200
    63.737     0.508     0.200
    63.830    -0.604     0.200
    64.294     0.554     0.200
    64.821     0.013     0.200
    65.276    -0.740     0.200
    65.654    -0.592     0.200
    66.336     1.027     0.200
    68.534     0.330     0.200
    68.910     1.585     0.200
    69.624    -0.436     0.200
    70.873    -0.075     0.200
    70.844     0.698     0.200
    72.312     0.258     0.200
    72.312     0.656     0.200
    72.963     0.389     0.200
    73.016     2.076     0.200
    73.016     2.178     0.200
    74.069    -0.012     0.200
    74.099     0.710     0.200
    74.231    -2.062     0.200
    74.263     0.455     0.200
    74.545     0.112     0.200
    74.630     0.622     0.200
    74.657    -0.036     0.200
    74.657     0.466     0.200
    74.945     0.797     0.200
    75.002    -0.030     0.200
    75.212     0.859     0.200
    75.318     0.051     0.200
    75.454     0.573     0.200
    75.498    -0.386     0.200
    75.498     0.013     0.200
    75.510     0.548     0.200
    75.630     0.464     0.200
    75.952     0.624     0.200
    76.132     0.496     0.200
    76.269     0.717     0.200
    76.269     0.615     0.200
    76.367     0.865     0.200
    76.557     0.483     0.200
    76.874     0.399     0.200
    76.912    -0.418     0.200
    76.912    -0.020     0.200
    77.088     0.295     0.200
    77.122     0.404     0.200
    77.324     1.564     0.200
    77.340     0.383     0.200
    77.479     0.702     0.200
    77.503     0.565     0.200
    77.634     0.243     0.200
    77.729     0.505     0.200
    77.729     0.404     0.200
    77.752     0.279     0.200
    77.824     1.479     0.200
    77.920     0.344     0.200
    77.952     0.163     0.200
    78.055     0.596     0.200
    78.106     0.313     0.200
    78.135     0.753     0.200
    78.135     0.854     0.200
    78.162    -0.193     0.200
    78.224     0.359     0.200
    78.258     1.171     0.200
    78.306    -1.196     0.200
    78.503     1.216     0.200
    78.759     1.310     0.200
    78.953     0.242     0.200
    78.961     1.799     0.200
    78.981     0.088     0.200
    78.983     1.179     0.200
    79.212     0.828     0.200
    79.233     0.509     0.200
    79.240     0.172     0.200
    79.378    -0.578     0.200
    79.382     0.895     0.200
    79.397     0.613     0.200
    79.426     0.260     0.200
    79.546     0.402     0.200
    80.143     0.771     0.200
    80.462     0.555     0.200
    80.687     0.347     0.200
    80.749     0.122     0.200
    80.734     0.898     0.200
    80.808    -1.796     0.200
    80.858     0.735     0.200
    80.968     1.145     0.200
    81.045     0.039     0.200
    81.194     0.149     0.200
    81.194     0.251     0.200
    81.305     0.458     0.200
    81.380     1.056     0.200
    81.515     0.648     0.200
    81.816     0.460     0.200
    82.248     1.591     0.200
    82.363    -0.008     0.200
    82.497     0.495     0.200
    82.935     1.016     0.200
    82.952    -0.073     0.200
    83.386     1.684     0.200
    83.580     0.688     0.200
    83.598     0.096     0.200
    83.808     0.518     0.200
    83.872     0.592     0.200
    83.924     0.930     0.200
    84.216     0.440     0.200
    85.433     1.321     0.200
    87.668     1.074     0.200
    87.668     1.074     0.200
    93.145    -0.479     0.200
    93.154    -0.320     0.200
    15.980     2.743     0.200
    24.200     0.936     0.200
    24.207    -0.523     0.200
    24.457     1.899     0.200
    25.638    -1.336     0.200
    26.242    -1.006     0.200
    26.829     0.900     0.200
    26.792     0.734     0.200
    26.845     1.451     0.200
    26.834     0.957     0.200
    28.267     2.522     0.200
    28.950     1.445     0.200
    29.315     0.308     0.200
    29.550     1.128     0.200
    30.848     0.846     0.200
    31.086     2.550     0.200
    31.290     2.256     0.200
    31.392     2.953     0.200
    31.916     2.250     0.200
    31.942     2.220     0.200
    32.431    -0.274     0.200
    32.354     2.606     0.200
    32.627     2.810     0.200
    32.732     3.088     0.200
    33.848    -1.642     0.200
    34.002     3.024     0.200
    34.314     1.315     0.200
    34.378     2.761     0.200
    35.077     1.721     0.200
    35.194     2.717     0.200
    35.552     2.336     0.200
    36.072    -2.317     0.200
    36.494     1.576     0.200
    36.603     2.642     0.200
    37.215     2.442     0.200
    37.958     2.156     0.200
    38.684     0.348     0.200
    38.711     2.821     0.200
    38.766     2.658     0.200
    41.342     0.985     0.200
    42.441     0.006     0.200
    43.282    -0.804     0.200
    43.523    -0.751     0.200
    44.209    -0.364     0.200
    44.776     0.211     0.200
    44.996    -0.739     0.200
    45.104    -1.301     0.200
    45.550     0.962     0.200
    46.441    -1.055     0.200
    46.657     0.349     0.200
    46.857    -1.216     0.200
    46.840     0.218     0.200
    47.055     1.735     0.200
    47.108    -0.071     0.200
    47.275     0.725     0.200
    47.908    -0.192     0.200
    48.254     1.431     0.200
    48.456     0.778     0.200
    48.493    -0.406     0.200
    49.331    -2.337     0.200
    49.599    -0.880     0.200
    50.163     1.339     0.200
    50.249     0.687     0.200
    50.377    -0.281     0.200
    51.451    -0.166     0.200
    51.535    -0.994     0.200
    52.542    -1.483     0.200
    52.728    -1.863     0.200
    52.859    -0.831     0.200
    52.938    -0.910     0.200
    53.318    -0.713     0.200
    53.343    -0.396     0.200
    54.709     0.531     0.200
    55.226    -0.101     0.200
    55.517    -0.197     0.200
    55.742    -0.614     0.200
    55.854    -1.114     0.200
    55.951    -0.312     0.200
    56.384     1.698     0.200
    57.381     0.534     0.200
    57.648    -1.349     0.200
    57.648    -0.451     0.200
    57.714     0.188     0.200
    57.764     0.032     0.200
    58.142     0.188     0.200
    58.361     0.651     0.200
    59.283    -0.556     0.200
    59.212     0.941     0.200
    59.263     0.886     0.200
    59.465    -0.008     0.200
    59.871     0.297     0.200
    60.932    -1.057     0.200
    61.283     0.568     0.200
    61.867     0.628     0.200
    62.817    -0.828     0.200
    63.532     0.027     0.200
    63.847     0.349     0.200
    63.956    -0.662     0.200
    64.353    -0.269     0.200
    64.413     0.539     0.200
    64.941    -0.007     0.200
    64.952     0.722     0.200
    65.071    -0.553     0.200
    65.368    -0.678     0.200
    65.420     0.187     0.200
    65.650     0.099     0.200
    65.750    -0.642     0.200
    66.460     0.997     0.200
    67.665    -0.358     0.200
    68.609     0.220     0.200
    69.011    -0.584     0.200
    69.022     1.351     0.200
    69.734    -1.054     0.200
    69.760    -0.612     0.200
    69.860     1.174     0.200
    70.678     0.469     0.200
    70.685     0.425     0.200
    70.905     0.388     0.200
    70.977     1.353     0.200
    70.951     0.909     0.200
    71.155     0.374     0.200
    71.326     0.234     0.200
    72.224     1.838     0.200
    72.051     1.075     0.200
    72.438     0.565     0.200
    73.047     0.545     0.200
    73.141     1.390     0.200
    73.141     1.690     0.200
    73.046    -0.049     0.200
    73.993     0.382     0.200
    74.103     0.344     0.200
    74.159    -0.789     0.200
    74.182     0.477     0.200
    74.271     0.061     0.200
    74.149     0.469     0.200
    74.347     0.218     0.200
    74.637     0.334     0.200
    74.712     0.303     0.200
    74.746     0.503     0.200
    74.751     0.173     0.200
    74.945     0.650     0.200
    75.091     0.109     0.200
    75.071     0.728     0.200
    75.053     1.231     0.200
    75.296     0.831     0.200
    75.393     0.072     0.200
    75.285     1.695     0.200
    75.460    -0.110     0.200
    75.546     0.496     0.200
    75.596     0.008     0.200
    75.672     0.777     0.200
    75.635     0.383     0.200
    75.705     0.486     0.200
    76.027     0.548     0.200
    76.230     0.095     0.200
    76.313     0.624     0.200
    76.360     0.252     0.200
    76.446    -0.232     0.200
    76.464     0.566     0.200
    76.465     1.161     0.200
    76.440     1.301     0.200
    76.642     0.558     0.200
    76.957     0.580     0.200
    77.012     0.073     0.200
    77.172     0.775     0.200
    77.196     0.739     0.200
    77.330     0.289     0.200
    77.340     0.033     0.200
    77.420     0.181     0.200
    77.419     0.590     0.200
    77.319     1.848     0.200
    77.554     0.637     0.200
    77.583     0.273     0.200
    77.663     0.427     0.200
    77.714     0.042     0.200
    77.735     0.825     0.200
    77.831     0.290     0.200
    77.825     0.523     0.200
    77.918     0.808     0.200
    77.891     0.955     0.200
    77.949     0.833     0.200
    77.969     0.721     0.200
    77.999     0.660     0.200
    78.032     0.372     0.200
    78.132     0.622     0.200
    77.892     1.154     0.200
    78.184     0.635     0.200
    78.285    -0.028     0.200
    78.303     0.574     0.200
    78.260     1.108     0.200
    78.344     0.747     0.200
    78.287     0.761     0.200
    78.398     1.549     0.200
    78.412    -1.727     0.200
    78.472     0.939     0.200
    78.523     0.159     0.200
    78.591     0.887     0.200
    78.618     0.635     0.200
    78.740     1.062     0.200
    78.849     0.365     0.200
    78.907     0.543     0.200
    78.931     0.915     0.200
    79.046     1.585     0.200
    79.044     0.294     0.200
    79.058     0.217     0.200
    79.069     1.358     0.200
    79.308     0.849     0.200
    79.329     0.039     0.200
    79.469    -0.326     0.200
    79.480     1.914     0.200
    79.485    -0.314     0.200
    79.503     0.487     0.200
    79.483    -0.104     0.200
    79.622     0.639     0.200
    79.692     0.262     0.200
    79.717     1.128     0.200
    79.785    -0.242     0.200
    79.985     0.677     0.200
    80.034     0.408     0.200
    80.031     0.424     0.200
    80.057     0.787     0.200
    80.281     1.077     0.200
    80.562    -0.433     0.200
    80.533     1.122     0.200
    80.787    -0.033     0.200
    80.846     0.847     0.200
    80.860    -0.528     0.200
    80.855     1.202     0.200
    80.912    -1.303     0.200
    80.978     0.944     0.200
    81.120     0.089     0.200
    81.089     1.150     0.200
    81.301     0.626     0.200
    81.326     1.093     0.200
    81.387     0.670     0.200
    81.463     1.072     0.200
    81.567     1.717     0.200
    81.598     0.858     0.200
    81.667    -0.010     0.200
    81.766     1.166     0.200
    81.947     1.216     0.200
    81.922     1.345     0.200
    81.936     1.275     0.200
    81.940    -0.848     0.200
    82.140     1.705     0.200
    82.210     0.836     0.200
    82.210     1.437     0.200
    82.350     0.102     0.200
    82.481     1.420     0.200
    82.582     0.794     0.200
    83.035     0.541     0.200
    83.041     0.011     0.200
    83.048     0.478     0.200
    83.010     0.371     0.200
    83.306     2.141     0.200
    83.204     0.272     0.200
    83.454     1.384     0.200
    83.299     1.478     0.200
    83.482     1.237     0.200
    83.523     1.025     0.200
    83.508     2.106     0.200
    83.566     1.204     0.200
    83.667     1.287     0.200
    83.776     0.729     0.200
    83.722     0.006     0.200
    83.858     1.313     0.200
    83.911     1.039     0.200
    84.025     1.460     0.200
    84.125     0.748     0.200
    84.305     0.534     0.200
    84.469     1.100     0.200
    84.499     0.749     0.200
    84.683     1.124     0.200
    84.800     0.733     0.200
    85.271     0.371     0.200
    85.526     1.899     0.200
    85.536     0.451     0.200
    85.600     1.034     0.200
    85.684     0.513     0.200
    85.685    -0.192     0.200
    85.693     0.571     0.200
    86.148     2.422     0.200
    86.470     0.232     0.200
    87.069     0.106     0.200
    87.665     1.327     0.200
    87.665     1.327     0.200
    89.396     1.257     0.200
    92.899    -0.003     0.200
    93.164    -0.025     0.200
    93.172    -0.063     0.200
    94.078     0.368     0.200
    95.003    -0.673     0.200
    96.729     0.469     0.200
    15.967     4.090     0.200
    24.359     0.170     0.200
    24.313     1.194     0.200
    24.320     0.828     0.200
    24.375     1.027     0.200
    25.020     2.281     0.200
    25.577    -0.901     0.200
    26.319    -0.323     0.200
    26.720     0.761     0.200
    26.720     0.964     0.200
    26.732    -0.350     0.200
    26.732     0.549     0.200
    26.946     0.229     0.200
    26.957     1.622     0.200
    28.363     2.253     0.200
    31.178     2.124     0.200
    31.384     2.810     0.200
    31.494     2.338     0.200
    32.006     2.341     0.200
    32.304     2.627     0.200
    32.548     0.082     0.200
    32.447     1.969     0.200
    32.533     2.924     0.200
    32.834     1.784     0.200
    33.823    -1.045     0.200
    33.752     1.572     0.200
    34.095     2.598     0.200
    34.424     1.742     0.200
    34.473     2.325     0.200
    35.170     2.306     0.200
    35.289     2.284     0.200
    35.385     2.456     0.200
    36.588     2.156     0.200
    36.695     2.242     0.200
    37.132    -0.968     0.200
    37.306     2.051     0.200
    38.801     0.447     0.200
    38.821     1.282     0.200
    38.876     2.817     0.200
    41.447     1.508     0.200
    42.559     0.435     0.200
    43.306    -0.621     0.200
    44.568     1.249     0.200
    45.249     1.234     0.200
    45.443     0.696     0.200
    45.443     0.696     0.200
    45.624     0.965     0.200
    46.503    -0.959     0.200
    46.845    -1.533     0.200
    46.952     0.422     0.200
    47.157     1.119     0.200
    47.220    -0.169     0.200
    47.818    -0.313     0.200
    48.147     1.141     0.200
    48.532     1.171     0.200
    49.709     0.164     0.200
    50.057     1.420     0.200
    50.158     0.757     0.200
    50.286    -0.212     0.200
    51.522     0.586     0.200
    52.801    -2.021     0.200
    53.251    -0.332     0.200
    54.547     0.193     0.200
    54.654     0.020     0.200
    55.431    -0.193     0.200
    55.778    -0.985     0.200
    56.457     1.560     0.200
    57.299     0.692     0.200
    57.678    -1.176     0.200
    57.678    -0.777     0.200
    57.673     0.061     0.200
    57.822     0.810     0.200
    58.177    -0.883     0.200
    58.282     0.592     0.200
    59.126     0.717     0.200
    59.163     1.061     0.200
    59.427     0.036     0.200
    60.668     3.122     0.200
    61.042     0.086     0.200
    61.317    -0.281     0.200
    61.827     0.278     0.200
    61.842    -1.526     0.200
    62.852    -0.478     0.200
    63.438     0.237     0.200
    63.761     0.196     0.200
    63.921    -0.649     0.200
    64.342     0.483     0.200
    64.724    -0.509     0.200
    64.873     0.617     0.200
    64.937    -0.300     0.200
    65.108    -0.510     0.200
    65.318     0.630     0.200
    65.623    -0.743     0.200
    65.702     0.449     0.200
    65.794    -0.844     0.200
    68.676     0.885     0.200
    68.856     0.662     0.200
    68.938     0.856     0.200
    69.032    -1.330     0.200
    69.756    -1.407     0.200
    69.810     0.461     0.200
    70.756     0.073     0.200
    70.860     0.648     0.200
    71.009     1.540     0.200
    70.977     0.029     0.200
    71.091     1.043     0.200
    71.078     1.122     0.200
    71.162     0.612     0.200
    71.162     1.010     0.200
    71.285     0.870     0.200
    71.285     1.268     0.200
    71.941     0.917     0.200
    72.282     0.878     0.200
    72.282     1.277     0.200
    72.401     1.167     0.200
    72.287     0.845     0.200
    73.061     1.247     0.200
    73.061     1.646     0.200
    73.101     1.711     0.200
    73.110     0.959     0.200
    73.105     0.690     0.200
    74.054     0.411     0.200
    74.210     0.203     0.200
    74.241     0.318     0.200
    74.332     0.790     0.200
    74.405     0.260     0.200
    74.686     0.334     0.200
    74.772     0.133     0.200
    74.797     0.089     0.200
    74.798     0.084     0.200
    75.001     0.613     0.200
    74.953     1.585     0.200
    75.035     0.715     0.200
    75.035     0.918     0.200
    75.143     0.389     0.200
    75.355     0.579     0.200
    75.333     1.997     0.200
    75.460     0.170     0.200
    75.508    -0.007     0.200
    75.429     2.449     0.200
    75.604     0.443     0.200
    75.595     0.702     0.200
    75.638     0.050     0.200
    75.725     0.705     0.200
    75.772     0.484     0.200
    75.828     0.166     0.200
    76.094     0.647     0.200
    76.169     0.221     0.200
    76.271     0.243     0.200
    76.364     0.914     0.200
    76.369     1.382     0.200
    76.410     0.852     0.200
    76.506     1.107     0.200
    76.501     0.338     0.200
    76.520     0.628     0.200
    76.700     0.513     0.200
    76.771     0.413     0.200
    76.884     0.779     0.200
    77.016     0.431     0.200
    77.051     0.238     0.200
    77.051     0.637     0.200
    77.231     0.431     0.200
    77.242     0.161     0.200
    77.249     0.829     0.200
    77.051     1.236     0.200
    77.376    -0.088     0.200
    77.391    -0.067     0.200
    77.465     0.714     0.200
    77.482     0.419     0.200
    77.621     0.841     0.200
    77.645     0.705     0.200
    77.720     0.698     0.200
    77.777     1.174     0.200
    77.783     0.742     0.200
    77.776     0.281     0.200
    77.862     0.700     0.200
    77.869     0.661     0.200
    77.894     0.319     0.200
    77.964     0.633     0.200
    77.964     0.531     0.200
    77.986     1.009     0.200
    77.778     0.166     0.200
    78.025     0.999     0.200
    78.062     0.588     0.200
    78.095     0.205     0.200
    78.207     0.786     0.200
    78.207     1.184     0.200
    78.223     1.098     0.200
    78.197     0.545     0.200
    78.254     0.228     0.200
    78.248     0.458     0.200
    78.367     0.607     0.200
    78.400     0.820     0.200
    78.441    -1.509     0.200
    78.488    -0.766     0.200
    78.488    -0.469     0.200
    78.448     0.954     0.200
    78.525     1.027     0.200
    78.651     1.337     0.200
    78.645     1.164     0.200
    78.796     1.538     0.200
    78.900     0.967     0.200
    78.944     0.122     0.200
    78.989     1.179     0.200
    79.024     1.286     0.200
    79.103     1.556     0.200
    79.125     1.030     0.200
    79.124     0.343     0.200
    79.234     0.635     0.200
    79.382     0.333     0.200
    79.375     0.665     0.200
    79.408     0.190     0.200
    79.519    -0.117     0.200
    79.518    -0.410     0.200
    79.534     0.501     0.200
    79.539     1.873     0.200
    79.585     1.726     0.200
    79.568     0.613     0.200
    79.681     0.703     0.200
    79.689     0.561     0.200
    79.750     0.830     0.200
    79.767     0.235     0.200
    79.746     0.350     0.200
    79.835    -0.130     0.200
    79.979     1.589     0.200
    80.090     1.489     0.200
    80.317     0.768     0.200
    80.347    -0.393     0.200
    80.436    -0.372     0.200
    80.600    -0.253     0.200
    80.720    -0.897     0.200
    80.720    -0.499     0.200
    80.749     0.448     0.200
    80.789     1.031     0.200
    80.826     0.242     0.200
    80.819    -1.424     0.200
    80.888     0.506     0.200
    80.913     0.973     0.200
    81.024     1.185     0.200
    81.159     2.762     0.200
    81.188     0.112     0.200
    81.228     2.398     0.200
    81.212     0.482     0.200
    81.212     0.209     0.200
    81.243     1.117     0.200
    81.288     0.576     0.200
    81.368     0.654     0.200
    81.405     0.956     0.200
    81.621     0.316     0.200
    81.691     1.343     0.200
    81.658     0.725     0.200
    81.708     0.856     0.200
    81.739     0.695     0.200
    81.929     1.294     0.200
    81.998     2.329     0.200
    81.998     0.328     0.200
    82.122     1.682     0.200
    82.193     1.108     0.200
    82.385     1.306     0.200
    82.416     1.144     0.200
    82.483     1.793     0.200
    82.456     0.033     0.200
    82.748     2.913     0.200
    83.072    -0.268     0.200
    83.080     0.694     0.200
    83.093     0.125     0.200
    83.517     0.441     0.200
    83.541     0.315     0.200
    83.567     0.182     0.200
    83.528     1.385     0.200
    83.528     0.768     0.200
    83.662    -0.302     0.200
    83.668    -0.336     0.200
    83.907     1.942     0.200
    83.945     1.249     0.200
    84.061     1.657     0.200
    84.175     0.874     0.200
    84.334     0.772     0.200
    84.347     0.704     0.200
    84.534     1.259     0.200
    85.215     1.193     0.200
    85.379     0.219     0.200
    85.578     1.023     0.200
    85.573     1.549     0.200
    85.725     0.293     0.200
    85.855     0.651     0.200
    85.843    -0.188     0.200
    86.040     1.733     0.200
    86.067     0.599     0.200
    86.170     0.892     0.200
    86.245     1.023     0.200
    86.306     0.425     0.200
    86.407    -0.572     0.200
    86.433    -0.202     0.200
    87.100    -0.164     0.200
    87.514     0.741     0.200
    87.672    -0.219     0.200
    87.802     0.362     0.200
    87.555     1.138     0.200
    87.555     1.138     0.200
    87.555     0.575     0.200
    87.846     0.952     0.200
    88.147     0.522     0.200
    88.296     0.613     0.200
    88.895     0.197     0.200
    89.189     0.614     0.200
    89.474     0.774     0.200
    91.407     1.276     0.200
    92.833    -0.320     0.200
    92.948     2.150     0.200
    93.031    -0.131     0.200
    93.056    -0.245     0.200
    94.277     0.036     0.200
    15.832     3.733     0.200
    18.406    -2.005     0.200
    24.106     0.697     0.200
    24.501     0.594     0.200
    24.563     0.029     0.200
    25.362    -1.730     0.200
    25.362    -1.230     0.200
    26.385     0.003     0.200
    26.491     0.047     0.200
    26.491     0.348     0.200
    27.183     0.320     0.200
    27.209     1.582     0.200
    29.674     0.630     0.200
    31.212     1.346     0.200
    32.062     1.574     0.200
    33.089     2.582     0.200
    33.666    -1.444     0.200
    35.540     2.352     0.200
    35.807    -1.637     0.200
    35.977     0.611     0.200
    35.977     0.912     0.200
    37.163    -0.999     0.200
    39.027     0.096     0.200
    42.785     0.337     0.200
    43.245    -1.882     0.200
    43.770    -0.416     0.200
    43.917    -0.298     0.200
    44.731    -1.808     0.200
    44.731    -0.908     0.200
    45.188     0.563     0.200
    46.530    -1.024     0.200
    46.709    -1.124     0.200
    47.204     1.104     0.200
    47.412     1.084     0.200
    47.472     0.024     0.200
    48.788    -0.343     0.200
    49.886     0.073     0.200
    49.909     0.695     0.200
    50.037    -0.277     0.200
    52.590    -2.206     0.200
    54.333     0.003     0.200
    54.333     0.403     0.200
    55.741    -1.162     0.200
    57.060     0.043     0.200
    57.774    -1.592     0.200
    58.140    -0.456     0.200
    58.043     0.922     0.200
    58.909     0.982     0.200
    61.817    -1.391     0.200
    62.814    -0.359     0.200
    63.517     0.280     0.200
    63.744    -0.420     0.200
    63.982     0.013     0.200
    64.400    -0.729     0.200
    64.636     0.932     0.200
    65.072    -0.310     0.200
    65.775    -0.555     0.200
    67.532     0.336     0.200
    67.553     0.303     0.200
    67.776     0.596     0.200
    68.176     0.784     0.200
    68.714     1.021     0.200
    68.696     1.235     0.200
    69.688    -1.112     0.200
    70.611     1.232     0.200
    71.097     0.278     0.200
    71.097     0.778     0.200
    72.222     1.110     0.200
    72.917     1.374     0.200
    74.680    -0.352     0.200
    74.798     0.361     0.200
    74.858     1.017     0.200
    75.497    -0.564     0.200
    75.811     0.442     0.200
    75.968     0.945     0.200
    77.034     0.014     0.200
    77.019     0.694     0.200
    77.247     0.117     0.200
    77.449     1.085     0.200
    77.508     0.155     0.200
    77.659     0.512     0.200
    77.672     0.139     0.200
    77.696    -0.092     0.200
    77.801    -0.081     0.200
    77.922     0.250     0.200
    78.042     0.981     0.200
    78.082     0.761     0.200
    78.389     0.261     0.200
    78.312    -1.514     0.200
    78.312    -0.914     0.200
    78.444     1.355     0.200
    79.671     1.039     0.200
    80.568    -0.801     0.200
    80.796     0.681     0.200
    80.887    -2.502     0.200
    81.829     1.002     0.200
    82.374     0.648     0.200
    83.585     1.377     0.200
    86.116     1.648     0.200
    87.378     0.582     0.200
    87.378     0.582     0.200
    16.661     1.571     0.200
    24.121     0.989     0.200
    24.436     0.512     0.200
    24.498    -0.452     0.200
    26.311    -0.398     0.200
    26.481     1.561     0.200
    27.134     0.682     0.200
    27.174     1.328     0.200
    29.630     0.452     0.200
    29.885     2.099     0.200
    31.178     1.485     0.200
    31.419     1.864     0.200
    31.567     1.356     0.200
    32.148     1.451     0.200
    32.714    -0.207     0.200
    32.688     2.524     0.200
    33.625    -1.655     0.200
    33.625    -1.257     0.200
    34.658     0.992     0.200
    34.713     1.916     0.200
    35.786    -0.921     0.200
    35.993    -0.089     0.200
    36.828     0.782     0.200
    36.936     2.864     0.200
    38.292     1.398     0.200
    39.044     1.392     0.200
    41.679     0.295     0.200
    43.182    -0.927     0.200
    43.699    -0.590     0.200
    43.905    -0.747     0.200
    43.905    -0.044     0.200
    44.441    -2.038     0.200
    44.710    -2.189     0.200
    44.710    -2.088     0.200
    44.771    -0.278     0.200
    45.363     0.524     0.200
    45.215     0.797     0.200
    46.481     0.606     0.200
    46.662    -1.308     0.200
    46.987    -0.348     0.200
    47.169    -0.169     0.200
    47.577    -0.341     0.200
    47.604     1.150     0.200
    48.785    -0.272     0.200
    49.818     0.045     0.200
    49.826     1.084     0.200
    49.917     0.295     0.200
    50.045    -0.676     0.200
    51.498     0.380     0.200
    51.810    -0.947     0.200
    52.570    -0.598     0.200
    53.010     0.453     0.200
    54.315    -0.001     0.200
    54.424     0.804     0.200
    54.424     0.905     0.200
    54.995    -0.432     0.200
    55.189     0.271     0.200
    55.674    -0.619     0.200
    55.903     0.538     0.200
    56.438     2.118     0.200
    57.058     0.125     0.200
    57.441    -0.782     0.200
    57.441    -0.485     0.200
    57.432     0.283     0.200
    57.706     0.252     0.200
    58.073    -0.223     0.200
    58.040     0.008     0.200
    58.884     0.922     0.200
    59.042    -0.972     0.200
    59.042    -0.769     0.200
    58.926     0.833     0.200
    59.213    -0.152     0.200
    61.210    -0.717     0.200
    61.144     2.126     0.200
    61.749    -1.163     0.200
    62.748    -0.846     0.200
    63.520     0.135     0.200
    63.710    -0.518     0.200
    63.710    -0.315     0.200
    63.932     0.018     0.200
    64.104    -0.110     0.200
    64.330    -0.491     0.200
    64.649    -0.781     0.200
    64.632     0.932     0.200
    64.767    -0.444     0.200
    65.006    -0.703     0.200
    65.083     1.100     0.200
    65.509     0.740     0.200
    65.707    -1.332     0.200
    66.182     0.511     0.200
    68.641     0.861     0.200
    68.696     1.012     0.200
    68.900    -0.758     0.200
    69.626    -1.250     0.200
    69.626    -0.453     0.200
    69.523     1.386     0.200
    70.619     1.068     0.200
    70.947     0.673     0.200
    71.067     0.946     0.200
    72.189     1.196     0.200
    72.886     1.047     0.200
    72.886     1.445     0.200
    73.820     0.543     0.200
    74.136     0.698     0.200
    74.186     0.405     0.200
    74.269     1.923     0.200
    74.281     0.850     0.200
    74.610     0.442     0.200
    74.610     0.340     0.200
    74.715     0.333     0.200
    74.721     0.898     0.200
    74.728     0.258     0.200
    74.824     0.702     0.200
    74.824     0.906     0.200
    74.716     1.926     0.200
    75.299     1.460     0.200
    75.424    -0.254     0.200
    75.398     0.394     0.200
    75.517     0.213     0.200
    75.517     0.112     0.200
    75.545     0.549     0.200
    75.545     0.150     0.200
    75.656     0.716     0.200
    76.060     0.312     0.200
    76.178     0.939     0.200
    76.131     2.208     0.200
    76.335     1.047     0.200
    76.413     0.308     0.200
    76.460     0.637     0.200
    76.642     0.311     0.200
    76.952    -0.438     0.200
    76.952     0.265     0.200
    76.962     0.213     0.200
    76.918    -0.248     0.200
    77.175     0.211     0.200
    76.960     1.518     0.200
    77.380     0.958     0.200
    77.435     0.056     0.200
    77.586     0.410     0.200
    77.599     0.233     0.200
    77.658     0.610     0.200
    77.710     0.318     0.200
    77.710     0.521     0.200
    77.729     0.012     0.200
    77.782    -0.079     0.200
    77.782     0.624     0.200
    77.849     0.148     0.200
    78.019     0.306     0.200
    78.009     1.451     0.200
    78.048     0.041     0.200
    78.046     0.248     0.200
    78.157     0.233     0.200
    78.206    -0.039     0.200
    78.278     0.169     0.200
    78.278     0.271     0.200
    78.316     0.457     0.200
    78.374     0.838     0.200
    78.828     0.637     0.200
    78.861     2.457     0.200
    79.020     0.083     0.200
    79.168    -0.225     0.200
    79.313    -0.017     0.200
    79.339     0.544     0.200
    79.444    -0.230     0.200
    79.485     1.546     0.200
    79.528     0.412     0.200
    79.615     0.838     0.200
    79.641     1.494     0.200
    79.760    -0.450     0.200
    79.829     2.675     0.200
    79.919     2.188     0.200
    79.982     2.250     0.200
    80.022     0.632     0.200
    80.181     0.777     0.200
    80.575    -1.344     0.200
    80.554     0.976     0.200
    80.578    -0.359     0.200
    80.677     0.815     0.200
    80.788     1.219     0.200
    80.971     0.748     0.200
    81.100     1.856     0.200
    81.169     0.490     0.200
    81.224     0.200     0.200
    81.380     0.073     0.200
    81.482     2.329     0.200
    81.550     0.869     0.200
    81.580     0.708     0.200
    81.774     1.289     0.200
    81.774     1.688     0.200
    81.927     0.485     0.200
    81.931     1.463     0.200
    82.277     0.648     0.200
    82.320     1.423     0.200
    82.215     1.871     0.200
    82.345     1.294     0.200
    82.262     1.727     0.200
    82.580     1.469     0.200
    82.651     0.698     0.200
    82.753     2.170     0.200
    82.949     1.650     0.200
    83.023     0.772     0.200
    83.116     0.287     0.200
    83.411     0.767     0.200
    83.404     0.806     0.200
    83.404     1.009     0.200
    83.433     1.654     0.200
    83.422     2.710     0.200
    83.499     1.817     0.200
    83.441    -0.384     0.200
    83.332     0.972     0.200
    83.511     1.755     0.200
    83.622     0.386     0.200
    83.649    -0.453     0.200
    83.753     0.514     0.200
    84.254     0.755     0.200
    84.488     1.571     0.200
    84.960     0.897     0.200
    85.116     1.117     0.200
    85.603     3.188     0.200
    86.067     1.388     0.200
    86.099     1.230     0.200
    86.153     1.361     0.200
    86.220     0.633     0.200
    86.470     1.905     0.200
    86.466    -0.277     0.200
    86.573     1.901     0.200
    87.445     1.954     0.200
    89.518     2.863     0.200
    92.598    -0.438     0.200
    25.001     2.083     0.200
    25.615     2.512     0.200
    25.989     2.628     0.200
    26.551     0.049     0.200
    29.329     2.451     0.200
    30.014     2.287     0.200
    30.610     1.720     0.200
    32.290     2.642     0.200
    32.881     2.472     0.200
    33.272     2.857     0.200
    33.409     2.367     0.200
    33.806     2.409     0.200
    34.022     2.534     0.200
    34.716     2.529     0.200
    35.055     1.606     0.200
    35.398     1.357     0.200
    35.436     1.334     0.200
    36.027     2.265     0.200
    36.129     2.394     0.200
    36.252     1.342     0.200
    36.641     1.825     0.200
    38.262     2.307     0.200
    39.015     2.000     0.200
    39.645     1.039     0.200
    42.419    -0.069     0.200
    44.473     0.885     0.200
    46.578    -0.454     0.200
    46.867    -0.014     0.200
    49.204     1.032     0.200
    49.332     0.052     0.200
    49.536    -0.408     0.200
    50.705    -0.458     0.200
    54.489     0.060     0.200
    57.362     1.009     0.200
    58.005    -1.010     0.200
    58.187     1.321     0.200
    58.193     1.179     0.200
    58.807     0.202     0.200
    62.476     0.421     0.200
    62.677     0.080     0.200
    62.821     0.423     0.200
    63.460     0.287     0.200
    64.362    -0.439     0.200
    64.943    -0.833     0.200
    68.005     1.211     0.200
    68.790     0.201     0.200
    69.906     0.805     0.200
    73.115     0.473     0.200
    74.164    -0.480     0.200
    74.715     0.118     0.200
    74.768     0.312     0.200
    74.822     0.700     0.200
    75.486     0.783     0.200
    75.515     0.014     0.200
    75.533    -0.088     0.200
    76.360     0.898     0.200
    76.723     0.147     0.200
    77.051     0.198     0.200
    77.261     0.226     0.200
    77.375     0.488     0.200
    77.548    -0.085     0.200
    77.716     0.281     0.200
    77.736     0.574     0.200
    77.841    -0.013     0.200
    77.968    -0.116     0.200
    78.163    -0.296     0.200
    78.403     0.673     0.200
    78.505    -0.286     0.200
    79.575     1.355     0.200
    79.931     1.128     0.200
    80.035     0.568     0.200
    80.053     1.271     0.200
    80.166     1.461     0.200
    80.262     0.141     0.200
    81.088     1.525     0.200
    82.868     0.381     0.200
    83.576     0.730     0.200
    84.197     0.561     0.200
    84.448     1.090     0.200
    85.725     1.396     0.200
    91.975    -0.232     0.200
    92.286    -0.372     0.200
    92.292    -0.199     0.200
    95.796    -0.286     0.200
    18.319    -2.127     0.200
    24.314     1.693     0.200
    24.414    -0.719     0.200
    24.394     1.257     0.200
    24.695     2.509     0.200
    25.067     2.536     0.200
    26.337    -0.675     0.200
    26.681    -0.777     0.200
    26.576     1.459     0.200
    26.686    -0.825     0.200
    26.991     0.424     0.200
    27.448     3.024     0.200
    28.408     2.549     0.200
    29.478     0.256     0.200
    29.690     1.472     0.200
    31.167    -0.673     0.200
    31.372     1.021     0.200
    31.957     2.379     0.200
    32.349     2.435     0.200
    32.592    -0.591     0.200
    32.881     1.885     0.200
    33.125     2.150     0.200
    33.799    -1.725     0.200
    34.227     1.956     0.200
    34.483     1.342     0.200
    34.518     2.044     0.200
    35.215     2.030     0.200
    35.334     2.005     0.200
    35.981    -1.648     0.200
    36.184    -0.889     0.200
    36.633     1.882     0.200
    36.740     2.971     0.200
    38.097     2.475     0.200
    38.846     0.186     0.200
    38.868     1.793     0.200
    38.924     2.031     0.200
    41.494     1.234     0.200
    43.301    -1.465     0.200
    43.301    -0.965     0.200
    43.657    -0.937     0.200
    44.634    -0.166     0.200
    44.634     0.131     0.200
    44.905    -1.525     0.200
    44.968    -0.820     0.200
    45.395     0.885     0.200
    46.514    -1.034     0.200
    46.825    -1.468     0.200
    47.000     0.369     0.200
    47.774    -0.060     0.200
    48.100     1.619     0.200
    48.624    -1.420     0.200
    48.655    -1.157     0.200
    49.746    -0.706     0.200
    50.114     0.809     0.200
    51.695    -0.689     0.200
    52.766    -1.644     0.200
    52.766    -0.941     0.200
    52.701    -1.457     0.200
    53.206     0.112     0.200
    54.511    -0.430     0.200
    54.619     0.786     0.200
    55.387     0.235     0.200
    55.388     0.023     0.200
    55.777    -0.964     0.200
    55.996    -0.334     0.200
    56.473     2.460     0.200
    57.257     0.902     0.200
    57.674    -0.137     0.200
    57.628     0.186     0.200
    57.801    -1.125     0.200
    58.176    -0.760     0.200
    58.240     1.000     0.200
    59.083     0.633     0.200
    59.117     0.896     0.200
    59.398    -1.045     0.200
    59.728     0.474     0.200
    61.315    -0.254     0.200
    62.393    -0.398     0.200
    62.851    -0.252     0.200
    63.393    -0.050     0.200
    63.718     0.303     0.200
    63.893    -0.550     0.200
    64.089     0.163     0.200
    64.303    -0.040     0.200
    64.606    -0.817     0.200
    64.832     1.005     0.200
    64.921    -0.074     0.200
    65.108    -0.389     0.200
    65.421    -0.616     0.200
    65.797    -1.040     0.200
    66.375     0.544     0.200
    68.689    -0.077     0.200
    68.863     0.942     0.200
    68.895     0.639     0.200
    69.025    -1.167     0.200
    69.749    -1.145     0.200
    70.815     0.834     0.200
    71.061     0.444     0.200
    71.048     0.523     0.200
    71.133     0.910     0.200
    71.254     1.173     0.200
    72.290     0.947     0.200
    72.372     1.457     0.200
    73.114     0.556     0.200
    74.018     0.741     0.200
    74.168     0.362     0.200
    74.215    -0.309     0.200
    74.342     0.649     0.200
    74.369     0.491     0.200
    74.415     0.226     0.200
    74.691    -0.277     0.200
    74.782     1.000     0.200
    74.801    -0.312     0.200
    74.804     0.169     0.200
    75.007     0.999     0.200
    75.007     1.202     0.200
    75.364     0.944     0.200
    75.473     0.115     0.200
    75.513     0.087     0.200
    75.578     0.717     0.200
    75.599     0.597     0.200
    75.599     0.094     0.200
    75.639     0.365     0.200
    75.639     0.068     0.200
    75.731     0.544     0.200
    75.785     0.530     0.200
    75.827    -0.710     0.200
    76.108     0.896     0.200
    76.369     0.410     0.200
    76.358     0.472     0.200
    76.416     0.944     0.200
    76.416     1.045     0.200
    76.508     1.321     0.200
    76.708     0.585     0.200
    77.026     0.501     0.200
    77.051     0.655     0.200
    77.240     0.400     0.200
    77.290     0.515     0.200
    77.455     0.297     0.200
    77.468     1.122     0.200
    77.493     0.481     0.200
    77.634     0.796     0.200
    77.656     0.569     0.200
    77.789     1.027     0.200
    77.787     0.140     0.200
    77.836    -0.034     0.200
    77.836     0.263     0.200
    77.872     1.667     0.200
    77.905     0.285     0.200
    77.968     1.234     0.200
    78.074     0.646     0.200
    78.106     0.368     0.200
    78.194     0.879     0.200
    78.209     0.599     0.200
    78.227     0.500     0.200
    78.260     0.412     0.200
    78.370     0.802     0.200
    78.408     1.195     0.200
    78.438    -0.368     0.200
    78.532     1.408     0.200
    78.652     1.348     0.200
    78.804     1.117     0.200
    78.906     0.455     0.200
    78.970    -0.294     0.200
    78.999     1.344     0.200
    79.033     1.359     0.200
    79.100     0.291     0.200
    79.112     1.427     0.200
    79.133     1.107     0.200
    79.136     0.498     0.200
    79.232     0.773     0.200
    79.388     0.717     0.200
    79.367    -0.467     0.200
    79.549     1.843     0.200
    79.581     0.872     0.200
    79.679     0.338     0.200
    79.701     0.614     0.200
    79.727     0.280     0.200
    79.756     0.422     0.200
    79.820    -0.928     0.200
    79.840    -0.139     0.200
    79.975     1.233     0.200
    80.075     0.492     0.200
    80.088     0.121     0.200
    80.088     0.621     0.200
    80.106     0.528     0.200
    80.292     0.023     0.200
    80.292    -0.477     0.200
    80.345    -2.264     0.200
    80.366     1.125     0.200
    80.434     0.762     0.200
    80.434     1.262     0.200
    80.510     1.456     0.200
    80.600     0.369     0.200
    80.710     0.280     0.200
    80.710     0.780     0.200
    80.752     0.855     0.200
    80.827     0.658     0.200
    80.774    -1.858     0.200
    80.889     0.426     0.200
    80.875     0.798     0.200
    80.986     1.102     0.200
    81.201     0.163     0.200
    81.168     0.737     0.200
    81.372     0.154     0.200
    81.557     2.073     0.200
    81.628     1.402     0.200
    81.671     1.676     0.200
    81.695     0.846     0.200
    81.725     0.685     0.200
    81.853    -0.181     0.200
    81.917     1.382     0.200
    82.100     1.920     0.200
    82.357     1.574     0.200
    82.383     1.437     0.200
    82.469     0.991     0.200
    82.787     1.336     0.200
    82.978     1.743     0.200
    82.985     1.310     0.200
    83.072    -0.144     0.200
    83.540     1.448     0.200
    83.553     1.381     0.200
    83.544     1.423     0.200
    83.623     1.919     0.200
    83.655     2.354     0.200
    83.658     0.041     0.200
    83.719     0.525     0.200
    83.943     1.381     0.200
    84.060     0.784     0.200
    84.349     0.819     0.200
    84.354     0.892     0.200
    84.363     1.451     0.200
    84.507     1.120     0.200
    84.529     0.506     0.200
    84.535     0.773     0.200
    84.642     0.732     0.200
    84.836     0.458     0.200
    85.121     1.028     0.200
    85.238     0.841     0.200
    85.306     0.300     0.200
    85.474     0.370     0.200
    85.574     0.564     0.200
    85.721    -0.562     0.200
    85.813    -0.021     0.200
    86.022     1.949     0.200
    86.026     1.930     0.200
    86.048     1.317     0.200
    86.186     1.341     0.200
    86.221     1.465     0.200
    86.277     1.688     0.200
    86.427     1.157     0.200
    86.453     1.225     0.200
    87.797    -0.793     0.200
    89.209     0.645     0.200
    92.796    -0.022     0.200
    93.009    -0.206     0.200
    93.015     0.071     0.200
    94.328     0.325     0.200
    94.908     0.267     0.200
    16.904     1.820     0.200
    18.723    -2.110     0.200
    23.784     0.513     0.200
    26.258     1.021     0.200
    26.651    -0.024     0.200
    27.585     0.388     0.200
    27.970     2.942     0.200
    28.936     2.551     0.200
    29.623     2.158     0.200
    30.216     1.609     0.200
    30.955     1.689     0.200
    31.893     2.226     0.200
    32.555     2.420     0.200
    33.010     2.439     0.200
    33.660     2.072     0.200
    34.656     1.838     0.200
    35.058     1.368     0.200
    35.039     2.531     0.200
    35.626    -1.516     0.200
    35.729     1.604     0.200
    35.856     2.511     0.200
    36.271     1.964     0.200
    36.491     2.083     0.200
    36.716    -0.833     0.200
    37.153     2.454     0.200
    37.252     1.616     0.200
    37.443     1.295     0.200
    38.048     1.386     0.200
    39.442     1.194     0.200
    42.052     0.665     0.200
    43.888     1.105     0.200
    43.918     1.065     0.200
    44.550    -1.094     0.200
    44.713     1.308     0.200
    44.829     1.078     0.200
    45.034     1.049     0.200
    45.739     2.063     0.200
    46.675    -1.293     0.200
    46.675    -0.493     0.200
    46.822     0.752     0.200
    47.273     0.535     0.200
    47.579    -0.048     0.200
    48.221     0.686     0.200
    49.240    -0.638     0.200
    54.138    -0.713     0.200
    54.138    -0.413     0.200
    54.265     0.362     0.200
    54.265     0.463     0.200
    55.867    -1.206     0.200
    56.763     1.511     0.200
    56.792     2.502     0.200
    57.780     0.232     0.200
    58.266    -0.375     0.200
    58.599     1.401     0.200
    59.124    -0.343     0.200
    59.199     0.636     0.200
    61.962    -1.401     0.200
    63.232     0.323     0.200
    63.540    -0.909     0.200
    63.882     0.536     0.200
    63.970     0.054     0.200
    64.376     0.490     0.200
    64.575    -0.811     0.200
    64.716    -0.728     0.200
    64.812    -0.856     0.200
    65.201    -0.286     0.200
    65.575    -0.901     0.200
    65.929    -0.284     0.200
    66.037     0.719     0.200
    68.418     1.227     0.200
    68.943    -0.143     0.200
    69.767    -0.739     0.200
    69.774     0.315     0.200
    70.249     0.301     0.200
    70.310     0.327     0.200
    71.048     0.833     0.200
    72.105     0.072     0.200
    72.105     0.272     0.200
    73.316     0.878     0.200
    74.379    -0.050     0.200
    74.460     0.183     0.200
    74.624     0.331     0.200
    74.849     0.024     0.200
    74.944     0.377     0.200
    74.978     0.483     0.200
    75.001    -0.150     0.200
    75.573     0.759     0.200
    75.725     0.089     0.200
    75.754     0.223     0.200
    75.759     0.698     0.200
    75.759     0.598     0.200
    75.908     2.347     0.200
    75.908     0.647     0.200
    76.041     0.289     0.200
    76.365     0.548     0.200
    76.389     0.108     0.200
    76.577     1.044     0.200
    76.625     0.276     0.200
    76.912     0.555     0.200
    77.154    -0.205     0.200
    77.154     0.295     0.200
    77.236     0.436     0.200
    77.447     0.352     0.200
    77.607     0.963     0.200
    77.721     0.426     0.200
    77.887     0.603     0.200
    77.889     0.792     0.200
    77.921     0.511     0.200
    78.014     0.195     0.200
    78.137     0.313     0.200
    78.309     0.360     0.200
    78.334     0.221     0.200
    78.352     0.923     0.200
    78.454     0.462     0.200
    78.500     0.307     0.200
    78.608     0.211     0.200
    79.640     0.668     0.200
    79.739     1.527     0.200
    79.750    -0.029     0.200
    79.760     1.617     0.200
    79.824     0.570     0.200
    79.903     1.640     0.200
    79.965     1.246     0.200
    79.951     0.583     0.200
    80.165     1.228     0.200
    80.195     1.964     0.200
    80.353     1.031     0.200
    80.380     0.368     0.200
    80.475     0.977     0.200
    80.481     0.865     0.200
    80.588     1.210     0.200
    80.669     0.016     0.200
    80.703     1.136     0.200
    80.960     0.265     0.200
    81.358     1.450     0.200
    81.671     0.694     0.200
    81.713     1.572     0.200
    81.749     0.983     0.200
    81.816    -0.173     0.200
    81.883     0.978     0.200
    81.919     1.886     0.200
    82.385     0.444     0.200
    82.462     0.043     0.200
    82.876     0.890     0.200
    83.102     1.322     0.200
    83.167    -0.614     0.200
    83.272     0.244     0.200
    83.288    -0.239     0.200
    83.827     0.493     0.200
    84.014     1.038     0.200
    84.021     1.004     0.200
    84.696     0.081     0.200
    85.626     0.328     0.200
    85.723     1.549     0.200
    86.128     1.946     0.200
    86.133    -1.081     0.200
    86.124     0.562     0.200
    86.380     1.201     0.200
    86.496     1.634     0.200
    86.961     0.257     0.200
    96.219     1.314     0.200
    26.386    -0.460     0.200
    27.410     1.729     0.200
    33.489    -0.952     0.200
    34.648     2.287     0.200
    35.600    -1.204     0.200
    37.257     1.306     0.200
    44.524    -1.181     0.200
    46.495    -0.773     0.200
    46.573     0.118     0.200
    47.350     0.551     0.200
    49.444     2.414     0.200
    57.695    -1.246     0.200
    58.010    -0.849     0.200
    59.054     0.480     0.200
    63.326    -0.952     0.200
    63.296     0.949     0.200
    63.898     0.276     0.200
    64.340    -0.922     0.200
    64.417     1.271     0.200
    64.606     0.137     0.200
    64.986    -0.633     0.200
    65.342    -1.252     0.200
    65.702    -1.076     0.200
    66.001     1.099     0.200
    68.475     1.723     0.200
    68.688     0.394     0.200
    70.391     1.391     0.200
    74.144     0.181     0.200
    74.616    -0.358     0.200
    74.715    -0.132     0.200
    74.741     0.421     0.200
    75.522     0.220     0.200
    75.670     0.669     0.200
    75.924     1.918     0.200
    76.109     0.365     0.200
    76.256     0.030     0.200
    76.343     0.936     0.200
    76.402     1.405     0.200
    76.634     0.394     0.200
    76.668     0.302     0.200
    76.990     0.384     0.200
    77.202     0.295     0.200
    77.378    -0.191     0.200
    77.471     0.187     0.200
    77.634     0.577     0.200
    77.637     0.365     0.200
    77.765     0.051     0.200
    77.887     0.075     0.200
    78.058     0.123     0.200
    78.085    -0.024     0.200
    78.201     0.231     0.200
    78.356     0.370     0.200
    78.383     0.917     0.200
    79.385     0.521     0.200
    79.537     0.797     0.200
    79.676     0.747     0.200
    82.994     1.459     0.200
    83.031     2.266     0.200
    83.312     0.814     0.200
    83.608     0.295     0.200
    92.399     1.021     0.200
    18.343    -1.841     0.200
    23.858     2.453     0.200
    23.858     2.753     0.200
    23.906    -0.985     0.200
    24.458     1.977     0.200
    24.458     2.676     0.200
    25.071     2.398     0.200
    25.071     2.699     0.200
    25.447     2.642     0.200
    25.447     2.006     0.200
    26.278    -0.235     0.200
    26.258     0.145     0.200
    26.732     2.777     0.200
    26.939     1.504     0.200
    26.939     1.805     0.200
    27.361     1.422     0.200
    28.672     2.011     0.200
    28.672     2.811     0.200
    28.688     0.870     0.200
    28.818     2.543     0.200
    30.101     1.345     0.200
    30.101     1.544     0.200
    31.228     1.395     0.200
    31.245     2.948     0.200
    31.367     0.879     0.200
    31.638     1.790     0.200
    31.638     2.189     0.200
    31.708     1.571     0.200
    31.784     2.113     0.200
    31.940     1.238     0.200
    32.109     2.172     0.200
    32.109     2.051     0.200
    32.362     1.434     0.200
    32.362     2.332     0.200
    32.449     1.571     0.200
    32.854     3.162     0.200
    33.008     2.781     0.200
    33.194     3.158     0.200
    33.194     3.357     0.200
    33.364     1.669     0.200
    33.427    -1.875     0.200
    33.531     1.222     0.200
    33.531     2.120     0.200
    33.612     2.054     0.200
    33.612     1.914     0.200
    33.840     0.031     0.200
    34.018     1.111     0.200
    34.554     1.947     0.200
    34.554     1.845     0.200
    34.616     1.739     0.200
    34.739     2.455     0.200
    34.851     1.187     0.200
    35.370     1.304     0.200
    35.370     1.906     0.200
    35.566    -0.982     0.200
    35.746     2.411     0.200
    35.779     1.094     0.200
    35.882     1.691     0.200
    36.019     1.583     0.200
    36.056     2.093     0.200
    36.109     1.973     0.200
    36.109     2.172     0.200
    36.588     1.954     0.200
    36.588     2.384     0.200
    36.655     2.039     0.200
    37.155     1.954     0.200
    37.204     0.975     0.200
    37.204     1.147     0.200
    37.185     2.145     0.200
    37.185     1.997     0.200
    38.510     1.620     0.200
    38.510     2.120     0.200
    38.510     0.299     0.200
    38.904     0.317     0.200
    39.238     1.413     0.200
    39.238     1.624     0.200
    40.592    -0.722     0.200
    41.882     0.792     0.200
    41.882     1.265     0.200
    41.884     1.004     0.200
    44.147     0.860     0.200
    44.491    -2.091     0.200
    44.552    -1.187     0.200
    44.871     1.376     0.200
    45.015     1.257     0.200
    45.015     1.128     0.200
    45.015     1.428     0.200
    46.379     0.755     0.200
    46.389    -0.420     0.200
    46.481    -0.843     0.200
    46.476    -0.706     0.200
    46.541     0.988     0.200
    46.658    -0.234     0.200
    46.889     0.859     0.200
    46.879    -1.060     0.200
    47.356    -0.184     0.200
    47.718     1.204     0.200
    48.203    -0.542     0.200
    48.470    -0.671     0.200
    48.985    -0.811     0.200
    49.363    -0.848     0.200
    49.601     0.008     0.200
    49.622     1.573     0.200
    49.668     1.477     0.200
    49.697     0.005     0.200
    50.129    -0.631     0.200
    50.154    -1.465     0.200
    50.154    -0.864     0.200
    50.462     1.163     0.200
    50.760    -0.042     0.200
    50.760     0.259     0.200
    50.794     1.901     0.200
    50.870     0.207     0.200
    51.322    -0.075     0.200
    51.540     0.074     0.200
    51.617    -0.134     0.200
    51.846     0.317     0.200
    52.350    -1.929     0.200
    52.818    -0.114     0.200
    52.870    -0.314     0.200
    52.880     0.981     0.200
    52.791     0.306     0.200
    53.723    -0.670     0.200
    54.144    -1.120     0.200
    54.144    -0.721     0.200
    54.094     0.246     0.200
    54.205     0.634     0.200
    54.668    -1.048     0.200
    54.769    -0.661     0.200
    54.769    -0.560     0.200
    54.869    -0.386     0.200
    54.869    -0.187     0.200
    54.967     0.406     0.200
    55.151    -0.425     0.200
    55.151    -0.225     0.200
    55.281    -0.359     0.200
    55.281    -0.160     0.200
    55.415    -1.325     0.200
    55.415    -0.927     0.200
    55.555    -0.829     0.200
    55.555    -0.645     0.200
    55.651    -0.114     0.200
    55.676    -0.124     0.200
    55.689     0.709     0.200
    55.689     0.810     0.200
    55.795    -0.323     0.200
    55.892     0.239     0.200
    55.894     0.037     0.200
    55.921    -0.029     0.200
    55.952    -0.176     0.200
    55.952    -0.075     0.200
    56.099     0.059     0.200
    56.109    -0.001     0.200
    56.335    -0.914     0.200
    56.335    -0.613     0.200
    56.393     1.671     0.200
    56.500     3.211     0.200
    56.810    -1.291     0.200
    56.810    -0.990     0.200
    56.843    -0.626     0.200
    56.835     0.536     0.200
    57.026    -0.856     0.200
    57.026    -0.598     0.200
    57.086     0.254     0.200
    57.224     0.745     0.200
    57.225    -0.426     0.200
    57.212     0.561     0.200
    57.596    -0.140     0.200
    57.589     2.711     0.200
    57.817     0.607     0.200
    57.912    -0.260     0.200
    58.034     0.082     0.200
    58.034     0.184     0.200
    58.300    -0.780     0.200
    58.300     0.021     0.200
    58.454     2.948     0.200
    58.532    -0.195     0.200
    58.662     1.000     0.200
    58.714     1.138     0.200
    59.004    -0.673     0.200
    58.983    -1.727     0.200
    58.983    -0.348     0.200
    59.320     0.336     0.200
    61.639    -1.089     0.200
    62.512    -0.158     0.200
    62.981     0.832     0.200
    63.229    -0.512     0.200
    63.302    -0.456     0.200
    63.298     0.531     0.200
    63.754     0.218     0.200
    63.815    -0.326     0.200
    63.815    -0.548     0.200
    63.880    -0.115     0.200
    64.237    -1.058     0.200
    64.418     0.187     0.200
    64.435    -1.652     0.200
    64.409     0.918     0.200
    64.409     1.106     0.200
    64.590    -0.071     0.200
    64.630     0.171     0.200
    64.888    -0.206     0.200
    64.874    -0.119     0.200
    65.240    -0.597     0.200
    65.380    -0.404     0.200
    65.380     0.096     0.200
    65.543     0.312     0.200
    65.601    -0.731     0.200
    65.681     0.172     0.200
    65.877     0.708     0.200
    65.964     0.831     0.200
    66.438     0.290     0.200
    67.119     0.252     0.200
    67.419     0.054     0.200
    67.586     0.397     0.200
    67.643     0.437     0.200
    68.043     0.721     0.200
    68.085     0.158     0.200
    68.168     0.436     0.200
    68.474     1.025     0.200
    68.581     0.624     0.200
    68.591     0.591     0.200
    68.591     0.282     0.200
    68.702     0.498     0.200
    68.757     0.158     0.200
    69.386     0.552     0.200
    69.408     0.120     0.200
    69.310     1.419     0.200
    69.484    -1.051     0.200
    69.484    -0.652     0.200
    69.454    -0.166     0.200
    69.642     0.672     0.200
    69.659     0.770     0.200
    69.882     0.795     0.200
    69.883     0.620     0.200
    70.051     0.263     0.200
    69.946     1.501     0.200
    70.128     0.587     0.200
    70.303     0.813     0.200
    70.399     1.428     0.200
    70.395     1.051     0.200
    70.416     2.923     0.200
    70.418    -1.090     0.200
    70.435     2.810     0.200
    70.682     0.906     0.200
    70.701     0.687     0.200
    70.665     0.106     0.200
    70.652     0.185     0.200
    70.668     2.692     0.200
    70.772    -0.246     0.200
    70.784     0.482     0.200
    70.682     2.701     0.200
    70.679     0.323     0.200
    70.906     0.542     0.200
    70.855     1.751     0.200
    70.925     0.632     0.200
    71.154     0.540     0.200
    71.273     1.079     0.200
    71.439     0.018     0.200
    71.596     1.269     0.200
    71.732     0.449     0.200
    71.728     1.104     0.200
    71.778     0.094     0.200
    71.827     0.858     0.200
    71.876     0.584     0.200
    71.980     1.460     0.200
    72.143     1.285     0.200
    72.051     2.039     0.200
    72.075     0.591     0.200
    72.229     0.472     0.200
    72.195     1.246     0.200
    72.159     0.889     0.200
    72.521     0.231     0.200
    72.672     0.791     0.200
    72.717     0.853     0.200
    72.722     0.639     0.200
    72.718     1.057     0.200
    72.767     0.938     0.200
    72.698     2.481     0.200
    72.728     2.501     0.200
    72.749     2.574     0.200
    72.937     0.659     0.200
    72.937     0.799     0.200
    72.940     0.744     0.200
    72.841     2.430     0.200
    72.967     0.483     0.200
    72.996     2.807     0.200
    73.170     0.482     0.200
    73.239     0.371     0.200
    73.241    -0.035     0.200
    73.284     0.508     0.200
    73.373     0.734     0.200
    73.502     0.596     0.200
    73.599     0.927     0.200
    73.929     0.219     0.200
    73.929    -0.081     0.200
    73.997     0.471     0.200
    74.021     0.485     0.200
    74.042     0.162     0.200
    74.109    -0.027     0.200
    74.208     0.491     0.200
    74.273     0.344     0.200
    74.513     1.187     0.200
    74.540     0.283     0.200
    74.428     1.011     0.200
    74.503     1.575     0.200
    74.613     0.238     0.200
    74.637     0.697     0.200
    74.857     0.828     0.200
    74.875    -0.576     0.200
    74.981     0.309     0.200
    75.107     0.475     0.200
    75.046     1.435     0.200
    75.222     0.887     0.200
    75.272     0.131     0.200
    75.334     0.779     0.200
    75.364     0.305     0.200
    75.403     0.383     0.200
    75.419     0.185     0.200
    75.419     0.517     0.200
    75.566     0.946     0.200
    75.606     0.216     0.200
    75.679     0.603     0.200
    75.595     2.078     0.200
    75.783     2.207     0.200
    75.907     2.496     0.200
    75.907     2.223     0.200
    76.002     0.755     0.200
    76.042     0.581     0.200
    76.093     0.879     0.200
    76.111     0.847     0.200
    76.197     0.947     0.200
    76.240     0.999     0.200
    76.303     1.547     0.200
    76.432     0.841     0.200
    76.531     0.352     0.200
    76.563     0.464     0.200
    76.568     0.434     0.200
    76.642     0.558     0.200
    76.729     0.391     0.200
    76.748     0.408     0.200
    76.748     0.549     0.200
    76.837    -0.275     0.200
    76.850     0.653     0.200
    76.885     0.557     0.200
    76.795     2.460     0.200
    77.077     0.232     0.200
    77.091     0.794     0.200
    77.097     0.384     0.200
    77.107     0.327     0.200
    77.156     0.052     0.200
    77.193     0.026     0.200
    77.277     0.553     0.200
    77.304     0.300     0.200
    77.365     0.457     0.200
    77.478    -0.162     0.200
    77.527     0.856     0.200
    77.523     0.405     0.200
    77.530     0.636     0.200
    77.577     0.474     0.200
    77.617     0.951     0.200
    77.659     0.319     0.200
    77.676     1.127     0.200
    77.562     0.160     0.200
    77.767     0.017     0.200
    77.781     0.440     0.200
    77.780     0.943     0.200
    77.780     1.943     0.200
    77.899     0.580     0.200
    77.936     0.777     0.200
    77.952     0.590     0.200
    77.979     0.339     0.200
    78.011     0.860     0.200
    78.010     0.267     0.200
    78.030     0.955     0.200
    78.077    -1.706     0.200
    78.094     0.499     0.200
    78.095     0.996     0.200
    78.141     0.538     0.200
    78.195    -0.863     0.200
    78.250     0.636     0.200
    78.256     1.003     0.200
    78.280     1.166     0.200
    78.370     1.170     0.200
    78.396     0.528     0.200
    78.483     0.827     0.200
    78.495     1.182     0.200
    78.621     1.077     0.200
    78.649     1.329     0.200
    78.735     0.157     0.200
    78.767     0.506     0.200
    78.857     1.091     0.200
    78.899     0.759     0.200
    78.926     0.112     0.200
    78.965     1.696     0.200
    78.982     0.604     0.200
    78.993     1.245     0.200
    79.022     0.384     0.200
    79.208     1.030     0.200
    79.211     0.651     0.200
    79.224    -0.217     0.200
    79.278     0.882     0.200
    79.306     0.843     0.200
    79.331     0.144     0.200
    79.349    -0.200     0.200
    79.361     0.233     0.200
    79.387     0.892     0.200
    79.388     1.687     0.200
    79.404     0.405     0.200
    79.404     0.644     0.200
    79.408     1.775     0.200
    79.445     0.776     0.200
    79.464     0.669     0.200
    79.454     0.728     0.200
    79.481     1.798     0.200
    79.516     1.586     0.200
    79.516     1.785     0.200
    79.542     0.349     0.200
    79.541    -0.745     0.200
    79.590     0.588     0.200
    79.595     0.160     0.200
    79.592     0.976     0.200
    79.592     1.175     0.200
    79.622     0.810     0.200
    79.662     0.096     0.200
    79.666    -0.323     0.200
    79.662    -1.408     0.200
    79.703     1.175     0.200
    79.665     0.579     0.200
    79.741     1.666     0.200
    79.749    -0.477     0.200
    79.780    -0.047     0.200
    79.801     1.210     0.200
    79.858     0.534     0.200
    79.924     0.277     0.200
    79.984     2.280     0.200
    79.945     1.061     0.200
    80.051    -0.514     0.200
    80.065     0.415     0.200
    80.077    -0.152     0.200
    80.105     0.247     0.200
    80.119     0.124     0.200
    80.160     1.601     0.200
    80.200    -0.315     0.200
    80.200     0.185     0.200
    80.357     1.240     0.200
    80.371     1.864     0.200
    80.331     0.980     0.200
    80.424     0.459     0.200
    80.326     2.310     0.200
    80.420     0.499     0.200
    80.458     1.496     0.200
    80.360     0.325     0.200
    80.512     0.259     0.200
    80.455     0.917     0.200
    80.454     1.119     0.200
    80.611     0.177     0.200
    80.615     0.259     0.200
    80.566     1.118     0.200
    80.689     0.749     0.200
    80.701     0.072     0.200
    80.702    -0.352     0.200
    80.729    -0.305     0.200
    80.736     0.806     0.200
    80.766     0.000     0.200
    80.815     0.165     0.200
    80.814    -0.399     0.200
    80.829     1.434     0.200
    80.844     0.288     0.200
    80.750     0.133     0.200
    80.892     0.258     0.200
    80.925     1.176     0.200
    80.934     1.569     0.200
    80.925    -0.203     0.200
    80.959     1.155     0.200
    80.980     0.808     0.200
    80.987     0.935     0.200
    80.994     1.430     0.200
    81.058     0.713     0.200
    81.067     0.272     0.200
    81.073     1.243     0.200
    81.076     1.293     0.200
    81.084     0.310     0.200
    81.091     0.753     0.200
    81.096     0.187     0.200
    81.119     1.065     0.200
    81.133     0.802     0.200
    81.138    -0.032     0.200
    81.152     0.670     0.200
    81.226     0.927     0.200
    81.272     0.579     0.200
    81.319     0.807     0.200
    81.317     1.712     0.200
    81.371     1.427     0.200
    81.260     0.016     0.200
    81.379     1.587     0.200
    81.396     0.896     0.200
    81.393     1.790     0.200
    81.384     0.758     0.200
    81.446     0.658     0.200
    81.414     0.598     0.200
    81.467     1.422     0.200
    81.472    -0.305     0.200
    81.480     1.025     0.200
    81.530     0.886     0.200
    81.661     0.894     0.200
    81.651     1.948     0.200
    81.657     1.419     0.200
    81.739     1.985     0.200
    81.801     0.619     0.200
    81.835     0.877     0.200
    81.721     1.379     0.200
    81.716     0.206     0.200
    81.912     0.872     0.200
    81.990     0.162     0.200
    82.103    -0.431     0.200
    82.147     0.939     0.200
    82.165     1.337     0.200
    82.254     0.679     0.200
    82.282    -0.868     0.200
    82.281    -0.258     0.200
    82.304     1.218     0.200
    82.445     1.083     0.200
    82.528     0.836     0.200
    82.589     0.269     0.200
    82.622     0.666     0.200
    82.680     0.275     0.200
    82.693     0.289     0.200
    82.709     0.905     0.200
    82.652     0.904     0.200
    82.748     1.005     0.200
    82.812     0.271     0.200
    82.748     1.707     0.200
    82.896     1.039     0.200
    82.912     1.251     0.200
    82.899     0.431     0.200
    82.932     0.151     0.200
    82.930     1.461     0.200
    82.950     1.158     0.200
    82.998     0.910     0.200
    82.998     1.211     0.200
    83.043    -0.202     0.200
    83.064     0.216     0.200
    83.209    -0.201     0.200
    83.233     1.495     0.200
    83.271     0.497     0.200
    83.271     0.696     0.200
    83.286    -0.579     0.200
    83.222     0.751     0.200
    83.364     0.919     0.200
    83.355     1.263     0.200
    83.378     0.948     0.200
    83.418     0.441     0.200
    83.508     0.276     0.200
    83.504     0.597     0.200
    83.509     0.975     0.200
    83.530     0.185     0.200
    83.558     0.624     0.200
    83.578     1.222     0.200
    83.659     0.304     0.200
    83.662     2.487     0.200
    83.740     1.013     0.200
    83.736     1.008     0.200
    83.806     0.352     0.200
    83.857    -0.011     0.200
    83.893     0.505     0.200
    84.046    -0.471     0.200
    84.074    -1.898     0.200
    84.083    -1.059     0.200
    84.137     0.534     0.200
    84.138     1.059     0.200
    84.145     0.622     0.200
    84.159     1.953     0.200
    84.211     1.189     0.200
    84.270     1.087     0.200
    84.280    -0.462     0.200
    84.289     0.933     0.200
    84.227     0.408     0.200
    84.314     0.524     0.200
    84.329     0.087     0.200
    84.376     0.549     0.200
    84.435     0.272     0.200
    84.498    -0.265     0.200
    84.506     1.117     0.200
    84.569     0.252     0.200
    84.556    -0.457     0.200
    84.594     0.647     0.200
    84.616     0.316     0.200
    84.648     0.875     0.200
    84.615     1.643     0.200
    84.697     0.332     0.200
    84.758    -0.077     0.200
    84.810    -0.738     0.200
    84.816     0.348     0.200
    84.863     0.294     0.200
    84.867    -0.926     0.200
    84.880     0.310     0.200
    84.948     0.967     0.200
    84.928    -0.234     0.200
    85.083     0.131     0.200
    85.150     0.755     0.200
    85.174     0.831     0.200
    85.184     0.587     0.200
    85.167     0.568     0.200
    85.241     0.998     0.200
    85.292     0.140     0.200
    85.358     0.152     0.200
    85.413     1.539     0.200
    85.488    -0.433     0.200
    85.499    -0.549     0.200
    85.552    -0.854     0.200
    85.611     0.654     0.200
    85.599     1.414     0.200
    85.682     0.504     0.200
    85.674     0.644     0.200
    85.735     1.040     0.200
    85.679     2.315     0.200
    85.779     0.823     0.200
    85.792     0.755     0.200
    85.890     0.269     0.200
    85.885     0.598     0.200
    85.957     0.461     0.200
    85.999     0.833     0.200
    86.060     1.230     0.200
    86.074     0.860     0.200
    86.011     0.772     0.200
    86.085     0.805     0.200
    86.069     0.490     0.200
    86.099     1.541     0.200
    86.227    -0.290     0.200
    86.289    -1.407     0.200
    86.365     0.930     0.200
    86.414     1.288     0.200
    86.438    -0.382     0.200
    86.463     1.448     0.200
    86.487     1.127     0.200
    86.517     0.285     0.200
    86.526     1.138     0.200
    86.525    -1.168     0.200
    86.623     0.033     0.200
    86.629     0.411     0.200
    86.768    -0.447     0.200
    86.785     1.671     0.200
    86.773    -0.472     0.200
    86.848    -0.278     0.200
    86.852     2.241     0.200
    86.857     0.216     0.200
    87.076     1.450     0.200
    87.070     1.482     0.200
    87.266    -0.131     0.200
    87.295     0.650     0.200
    87.308     0.525     0.200
    87.368    -0.863     0.200
    87.425     1.365     0.200
    87.448     0.150     0.200
    87.369     1.031     0.200
    87.369     0.981     0.200
    87.541    -0.096     0.200
    87.598    -0.069     0.200
    87.976     1.129     0.200
    88.005     1.190     0.200
    87.984     1.090     0.200
    88.306     0.668     0.200
    88.345     0.783     0.200
    88.477     0.758     0.200
    88.701     0.503     0.200
    88.723    -0.499     0.200
    88.753     0.961     0.200
    88.927     0.243     0.200
    89.163     0.730     0.200
    89.434     0.462     0.200
    89.628     1.454     0.200
    89.739    -0.269     0.200
    89.989     0.168     0.200
    90.497     0.299     0.200
    90.765     0.997     0.200
    90.765     1.247     0.200
    90.789     0.244     0.200
    91.115     0.628     0.200
    91.181     3.120     0.200
    91.241     1.844     0.200
    91.272    -0.302     0.200
    91.479     1.137     0.200
    91.638     2.002     0.200
    91.976     1.441     0.200
    92.147     1.150     0.200
    92.358    -0.327     0.200
    92.375     0.095     0.200
    92.832    -0.014     0.200
    92.795    -0.042     0.200
    92.801     0.431     0.200
    93.706    -1.542     0.200
    93.706    -0.644     0.200
    94.399     2.276     0.200
    94.644     0.050     0.200
    95.002     0.515     0.200
    94.986    -1.412     0.200
    95.141    -0.450     0.200
    95.405     0.672     0.200
    95.457     0.438     0.200
    95.846     0.336     0.200
    96.047    -0.342     0.200
    96.203     0.039     0.200
    96.164     0.215     0.200
    96.611     0.861     0.200
    96.652     1.504     0.200
    97.393     0.152     0.200
    97.964     0.752     0.200
    18.185    -0.541     0.200
    24.075     0.264     0.200
    24.597    -0.090     0.200
    25.262     2.054     0.200
    26.148    -0.458     0.200
    26.383     1.812     0.200
    27.168     1.217     0.200
    28.503     2.243     0.200
    32.191     2.728     0.200
    33.473    -0.940     0.200
    33.361     2.888     0.200
    33.427     1.917     0.200
    33.861     2.585     0.200
    34.434     2.046     0.200
    34.661     1.231     0.200
    34.705     2.451     0.200
    35.581     2.165     0.200
    35.707     2.325     0.200
    35.951     0.173     0.200
    35.930     1.033     0.200
    36.473     1.823     0.200
    37.070    -1.065     0.200
    37.706     0.545     0.200
    38.384    -1.066     0.200
    38.347     2.002     0.200
    39.629     0.027     0.200
    40.743    -0.596     0.200
    41.468     0.549     0.200
    43.568    -0.201     0.200
    44.259     1.061     0.200
    44.303     0.803     0.200
    44.590    -1.993     0.200
    44.713    -1.767     0.200
    45.092     1.118     0.200
    45.201     1.356     0.200
    46.305    -0.060     0.200
    46.285    -0.701     0.200
    46.288    -0.724     0.200
    47.513     0.416     0.200
    47.426     1.491     0.200
    48.351     1.531     0.200
    48.885     0.831     0.200
    48.788    -0.900     0.200
    49.164     2.492     0.200
    49.410     1.515     0.200
    49.407     1.425     0.200
    49.855     1.230     0.200
    50.999     0.991     0.200
    51.648     0.734     0.200
    52.313     1.186     0.200
    53.268     1.032     0.200
    53.945    -0.465     0.200
    54.200     0.719     0.200
    54.304     1.164     0.200
    54.669    -0.534     0.200
    55.118    -1.228     0.200
    55.497    -0.860     0.200
    55.727    -0.105     0.200
    56.272     2.202     0.200
    56.611    -0.526     0.200
    56.976     0.995     0.200
    57.372     0.806     0.200
    57.529    -0.702     0.200
    57.855     0.208     0.200
    57.957     0.595     0.200
    58.811     1.134     0.200
    58.887     0.907     0.200
    59.073     1.320     0.200
    59.488    -1.048     0.200
    61.573    -0.553     0.200
    63.145     0.238     0.200
    63.448     0.436     0.200
    63.768    -0.377     0.200
    64.005     0.564     0.200
    64.155    -0.217     0.200
    64.352    -1.938     0.200
    64.547     0.720     0.200
    64.601    -0.136     0.200
    64.806    -0.674     0.200
    64.829    -0.528     0.200
    65.458     0.395     0.200
    65.530    -0.470     0.200
    66.057     0.741     0.200
    68.620     1.026     0.200
    68.615     1.060     0.200
    68.726    -0.131     0.200
    69.451    -0.629     0.200
    69.561     0.297     0.200
    70.226     1.210     0.200
    70.557     1.194     0.200
    70.564     0.750     0.200
    70.721     0.588     0.200
    70.787     0.589     0.200
    71.035     0.582     0.200
    71.619     0.361     0.200
    71.765     0.581     0.200
    72.047     0.590     0.200
    72.049     1.577     0.200
    72.116     0.379     0.200
    72.873     0.675     0.200
    73.752     0.996     0.200
    73.960     0.076     0.200
    74.012     0.269     0.200
    74.108     0.271     0.200
    74.434    -0.083     0.200
    74.538    -0.088     0.200
    74.552     0.533     0.200
    74.675     1.322     0.200
    74.897     0.337     0.200
    75.126     0.336     0.200
    75.205     0.061     0.200
    75.341     0.181     0.200
    75.369    -0.878     0.200
    75.480     0.982     0.200
    75.568     0.380     0.200
    75.891     0.636     0.200
    75.949     0.705     0.200
    76.032     2.333     0.200
    76.001    -0.494     0.200
    76.000     1.013     0.200
    76.115     0.760     0.200
    76.160     1.607     0.200
    76.236     1.373     0.200
    76.450     0.357     0.200
    76.468     0.512     0.200
    76.474     0.426     0.200
    76.544     0.426     0.200
    76.653     0.516     0.200
    76.775     1.122     0.200
    76.788     0.448     0.200
    77.005     0.828     0.200
    77.001     0.351     0.200
    77.012     0.189     0.200
    77.063     0.231     0.200
    77.204     1.113     0.200
    77.212     0.168     0.200
    77.263     0.381     0.200
    77.416     0.729     0.200
    77.429     0.477     0.200
    77.428     0.564     0.200
    77.481     0.559     0.200
    77.484     0.848     0.200
    77.557     0.241     0.200
    77.605     1.073     0.200
    77.677     0.366     0.200
    77.813     0.611     0.200
    77.850     0.709     0.200
    77.847     0.420     0.200
    77.876     0.259     0.200
    77.925     0.986     0.200
    77.943     0.887     0.200
    77.987     0.552     0.200
    78.002     0.867     0.200
    78.035     0.375     0.200
    78.149    -0.553     0.200
    78.145     0.574     0.200
    78.164     1.067     0.200
    78.199     1.174     0.200
    78.283     1.206     0.200
    78.406     1.232     0.200
    78.652     0.171     0.200
    78.761     1.473     0.200
    78.794     1.494     0.200
    78.844     0.014     0.200
    78.871     2.070     0.200
    78.890     1.365     0.200
    78.914     0.233     0.200
    79.119     0.510     0.200
    79.138     0.010     0.200
    79.169     0.739     0.200
    79.268    -0.201     0.200
    79.281     0.225     0.200
    79.291     1.570     0.200
    79.293     1.366     0.200
    79.312     1.764     0.200
    79.357     0.609     0.200
    79.394     0.612     0.200
    79.385     1.591     0.200
    79.464     1.230     0.200
    79.464     1.730     0.200
    79.481     0.537     0.200
    79.581     0.991     0.200
    79.582    -0.411     0.200
    79.660     1.165     0.200
    79.705     1.247     0.200
    79.805     1.380     0.200
    79.805     1.880     0.200
    79.846     0.157     0.200
    79.887     2.256     0.200
    80.004    -0.698     0.200
    80.004     0.598     0.200
    79.998     0.136     0.200
    80.061     1.197     0.200
    80.009     0.088     0.200
    80.064     1.481     0.200
    80.064     1.981     0.200
    80.266     1.293     0.200
    80.274     1.949     0.200
    80.328     0.903     0.200
    80.342    -0.316     0.200
    80.331     1.544     0.200
    80.446     0.923     0.200
    80.419     0.189     0.200
    80.568     0.668     0.200
    80.517     0.145     0.200
    80.570     0.861     0.200
    80.552     0.958     0.200
    80.606    -0.005     0.200
    80.606    -0.481     0.200
    80.681     1.065     0.200
    80.634    -0.580     0.200
    80.720    -0.614     0.200
    80.905     0.369     0.200
    80.958     1.185     0.200
    80.989     0.099     0.200
    80.985     0.249     0.200
    80.995     0.691     0.200
    81.020     1.063     0.200
    81.221     0.688     0.200
    81.285     1.449     0.200
    81.294     1.402     0.200
    81.298     0.984     0.200
    81.307     1.731     0.200
    81.379     0.950     0.200
    81.432     0.874     0.200
    81.575     0.813     0.200
    81.774     0.866     0.200
    81.774     1.468     0.200
    81.751     0.783     0.200
    81.800     1.128     0.200
    82.170     0.494     0.200
    82.205    -0.600     0.200
    82.435     0.903     0.200
    82.587     1.816     0.200
    82.778     1.223     0.200
    82.785     1.582     0.200
    82.847    -0.036     0.200
    82.970     1.522     0.200
    83.236     1.254     0.200
    83.318     0.534     0.200
    83.281     0.816     0.200
    83.445     0.877     0.200
    83.656     0.798     0.200
    84.078     0.942     0.200
    84.153     1.955     0.200
    84.229     0.819     0.200
    84.256     0.534     0.200
    84.386     0.477     0.200
    84.383     0.414     0.200
    84.445     1.048     0.200
    84.558     0.446     0.200
    84.633     0.346     0.200
    84.784     0.165     0.200
    84.827     1.151     0.200
    85.026     0.334     0.200
    85.215     0.109     0.200
    85.598     0.803     0.200
    85.809     0.252     0.200
    85.962     0.998     0.200
    86.079     1.316     0.200
    86.150    -0.728     0.200
    89.710     0.167     0.200
    92.490     0.659     0.200
    92.991     0.053     0.200
    92.997     0.323     0.200
    96.359     0.429     0.200
    18.299    -2.145     0.200
    23.844    -0.930     0.200
    25.496     2.324     0.200
    26.177    -0.122     0.200
    26.218    -0.493     0.200
    26.980     0.642     0.200
    26.980     1.540     0.200
    27.400     0.726     0.200
    27.822     0.947     0.200
    28.733     2.969     0.200
    28.881     2.060     0.200
    29.564     1.691     0.200
    30.165     1.311     0.200
    30.165     1.811     0.200
    30.338     0.956     0.200
    31.407     1.359     0.200
    31.705     1.734     0.200
    31.705     2.133     0.200
    31.751     0.932     0.200
    31.849     2.087     0.200
    31.849     1.837     0.200
    31.981     1.413     0.200
    32.422     2.443     0.200
    33.070     3.106     0.200
    33.335    -1.527     0.200
    33.278     0.969     0.200
    33.278     1.571     0.200
    33.425     0.682     0.200
    33.425     1.081     0.200
    33.432     1.621     0.200
    33.432     1.824     0.200
    33.592     1.487     0.200
    33.592     1.636     0.200
    33.661     1.634     0.200
    33.661     2.235     0.200
    33.708     3.221     0.200
    34.086     2.265     0.200
    34.347     3.681     0.200
    34.620     1.750     0.200
    34.668     1.115     0.200
    34.807     1.711     0.200
    34.807     2.313     0.200
    34.894     0.675     0.200
    34.935     2.073     0.200
    34.892     2.977     0.200
    34.892     3.078     0.200
    35.480    -0.679     0.200
    35.420     2.434     0.200
    35.420     2.731     0.200
    35.410     3.520     0.200
    35.719     0.368     0.200
    35.719     1.727     0.200
    35.810     2.091     0.200
    35.810     2.294     0.200
    35.939     1.985     0.200
    35.939     2.188     0.200
    36.083     1.821     0.200
    36.123     2.122     0.200
    36.163     2.073     0.200
    36.163     2.276     0.200
    36.529     2.011     0.200
    36.654     1.906     0.200
    36.707     2.158     0.200
    36.836    -1.366     0.200
    36.956    -0.855     0.200
    37.238     0.853     0.200
    37.222     2.058     0.200
    37.222     2.159     0.200
    37.392     2.448     0.200
    37.473     0.136     0.200
    38.151    -0.182     0.200
    38.459     0.878     0.200
    38.575     1.654     0.200
    38.575     1.858     0.200
    39.282     2.660     0.200
    39.282     1.839     0.200
    39.396    -0.109     0.200
    40.521    -1.541     0.200
    40.999     1.316     0.200
    41.235     0.982     0.200
    41.935     2.434     0.200
    41.935     1.247     0.200
    41.937     1.635     0.200
    42.788     0.915     0.200
    44.025     1.054     0.200
    44.069     0.896     0.200
    44.102     0.645     0.200
    44.161    -0.140     0.200
    44.404    -1.976     0.200
    44.486    -1.028     0.200
    44.858     1.402     0.200
    44.967     1.195     0.200
    44.967     1.038     0.200
    44.967     1.234     0.200
    45.169     1.129     0.200
    45.883     1.793     0.200
    46.300     0.410     0.200
    46.318    -0.835     0.200
    46.383    -0.244     0.200
    46.471    -0.928     0.200
    46.801    -1.412     0.200
    46.801    -1.130     0.200
    46.954     1.187     0.200
    46.931     1.770     0.200
    47.288    -0.410     0.200
    47.670     1.226     0.200
    48.120    -0.256     0.200
    48.117     1.664     0.200
    48.501    -0.758     0.200
    48.652     1.354     0.200
    48.672    -1.393     0.200
    49.015    -0.590     0.200
    49.176     1.929     0.200
    49.368     2.168     0.200
    49.403     0.004     0.200
    49.571     1.419     0.200
    49.629     0.180     0.200
    49.637     1.281     0.200
    50.164    -1.881     0.200
    50.164    -1.584     0.200
    50.184    -1.029     0.200
    50.184    -0.826     0.200
    50.493     0.136     0.200
    50.581     0.467     0.200
    50.668    -0.182     0.200
    50.765     1.184     0.200
    50.791     0.145     0.200
    50.880     0.326     0.200
    50.859     2.874     0.200
    51.333     0.077     0.200
    51.548     0.284     0.200
    51.628     0.191     0.200
    51.849    -0.031     0.200
    52.079     1.359     0.200
    52.725    -0.025     0.200
    52.934    -0.129     0.200
    52.934     0.089     0.200
    53.035     1.394     0.200
    53.131     0.002     0.200
    53.740    -0.755     0.200
    54.008     0.157     0.200
    54.118     0.552     0.200
    54.661    -0.895     0.200
    54.661    -0.793     0.200
    54.769    -0.972     0.200
    54.769    -0.870     0.200
    54.896     0.115     0.200
    54.889    -0.841     0.200
    54.889    -0.341     0.200
    55.171    -0.219     0.200
    55.276    -1.627     0.200
    55.276    -0.924     0.200
    55.472    -0.832     0.200
    55.472    -0.965     0.200
    55.412    -1.609     0.200
    55.412    -0.812     0.200
    55.714    -0.340     0.200
    55.660    -0.325     0.200
    55.901    -0.212     0.200
    55.903     0.078     0.200
    55.929    -0.991     0.200
    55.960    -0.057     0.200
    56.103    -0.211     0.200
    56.103    -0.102     0.200
    56.125    -0.110     0.200
    56.232    -1.453     0.200
    56.232    -0.047     0.200
    56.330     1.823     0.200
    56.361    -1.399     0.200
    56.361    -1.102     0.200
    56.760     0.772     0.200
    56.835    -1.762     0.200
    56.835    -1.161     0.200
    56.940    -0.810     0.200
    56.863    -0.651     0.200
    56.863     0.755     0.200
    57.026     0.487     0.200
    57.145     0.538     0.200
    57.145    -0.159     0.200
    57.515    -0.958     0.200
    57.741     0.850     0.200
    57.829    -0.266     0.200
    58.059    -1.383     0.200
    58.059    -0.781     0.200
    58.326    -0.244     0.200
    58.590     0.814     0.200
    58.655     0.464     0.200
    58.655     1.253     0.200
    58.913     0.276     0.200
    58.971    -1.694     0.200
    59.258     0.285     0.200
    60.701    -0.638     0.200
    61.178     3.153     0.200
    61.558    -1.013     0.200
    63.145    -0.518     0.200
    63.135     0.004     0.200
    63.135     1.582     0.200
    63.227    -0.524     0.200
    63.226     0.448     0.200
    63.226     0.323     0.200
    63.662    -0.430     0.200
    63.799    -0.337     0.200
    64.160    -0.407     0.200
    64.344     0.091     0.200
    64.358    -2.104     0.200
    64.332     0.668     0.200
    64.332     0.863     0.200
    64.499    -0.459     0.200
    64.556    -0.093     0.200
    64.805    -0.314     0.200
    64.818     0.996     0.200
    65.162    -0.838     0.200
    65.295    -0.099     0.200
    65.467     0.491     0.200
    65.467     0.194     0.200
    65.521    -0.561     0.200
    65.607    -0.273     0.200
    65.809     0.585     0.200
    65.876     0.653     0.200
    67.051     0.252     0.200
    67.331     0.168     0.200
    67.350     0.149     0.200
    67.519     0.486     0.200
    67.575     0.431     0.200
    67.975     0.610     0.200
    68.100     0.529     0.200
    68.400     1.354     0.200
    68.513     0.345     0.200
    68.513     0.517     0.200
    68.523    -0.114     0.200
    68.523     0.308     0.200
    68.669    -0.523     0.200
    69.251     1.363     0.200
    69.343     0.194     0.200
    69.396    -0.785     0.200
    69.396    -0.684     0.200
    69.396    -1.035     0.200
    69.450     0.337     0.200
    69.396     0.968     0.200
    69.396     1.671     0.200
    69.565     0.924     0.200
    69.815     0.529     0.200
    69.817     0.575     0.200
    69.888     1.142     0.200
    69.986     0.236     0.200
    70.059     0.988     0.200
    70.225     0.475     0.200
    70.233     0.120     0.200
    70.334    -0.898     0.200
    70.372    -0.028     0.200
    70.617     0.684     0.200
    70.639     0.345     0.200
    70.688     1.050     0.200
    70.731     0.187     0.200
    70.765     1.581     0.200
    70.842     0.513     0.200
    70.859     0.542     0.200
    71.089     0.614     0.200
    71.310     0.982     0.200
    71.652     1.193     0.200
    71.889     1.794     0.200
    72.070     1.354     0.200
    72.070     1.714     0.200
    72.007     3.090     0.200
    72.104     1.189     0.200
    72.104     1.080     0.200
    72.039    -0.103     0.200
    71.982     1.237     0.200
    72.190    -1.006     0.200
    72.604     0.768     0.200
    72.646     1.279     0.200
    72.649     0.854     0.200
    72.654     0.772     0.200
    72.699     0.689     0.200
    72.859     0.512     0.200
    72.859     0.661     0.200
    72.862     0.996     0.200
    72.893     0.516     0.200
    73.101     0.398     0.200
    73.175     0.546     0.200
    73.220     0.486     0.200
    73.116     1.615     0.200
    73.428     0.443     0.200
    73.528     0.566     0.200
    73.528     0.941     0.200
    73.858     0.137     0.200
    73.947     0.315     0.200
    73.964     0.411     0.200
    73.964     0.739     0.200
    74.036     0.595     0.200
    74.136     0.290     0.200
    74.200     0.248     0.200
    74.436    -0.030     0.200
    74.436     1.049     0.200
    74.394     0.009     0.200
    74.444     1.620     0.200
    74.534     0.197     0.200
    74.561     0.745     0.200
    74.561     0.402     0.200
    74.576     0.753     0.200
    74.782     0.462     0.200
    74.905     0.350     0.200
    75.028     0.422     0.200
    75.014     1.421     0.200
    75.150     0.821     0.200
    75.191     0.299     0.200
    75.256     0.031     0.200
    75.296     0.301     0.200
    75.323     0.850     0.200
    75.341     0.337     0.200
    75.341     0.462     0.200
    75.355    -0.638     0.200
    75.425     0.715     0.200
    75.490     1.085     0.200
    75.490     0.718     0.200
    75.535     0.651     0.200
    75.611     0.596     0.200
    75.628     0.570     0.200
    75.731     0.652     0.200
    75.812     0.641     0.200
    75.826     2.265     0.200
    75.869     0.641     0.200
    75.934     0.424     0.200
    75.935     0.646     0.200
    75.968     0.755     0.200
    76.019     0.964     0.200
    76.037     0.462     0.200
    76.094     0.419     0.200
    76.110     0.422     0.200
    76.120     0.889     0.200
    76.120     0.631     0.200
    76.163     0.849     0.200
    76.201     0.424     0.200
    76.222     1.719     0.200
    76.309     0.424     0.200
    76.320     0.425     0.200
    76.358     1.037     0.200
    76.364     2.309     0.200
    76.453     0.499     0.200
    76.489     0.616     0.200
    76.495     0.671     0.200
    76.569     0.650     0.200
    76.655     0.249     0.200
    76.674     0.453     0.200
    76.755     0.500     0.200
    76.776     0.551     0.200
    76.812     0.474     0.200
    77.015     0.737     0.200
    77.015     0.432     0.200
    77.024     0.517     0.200
    77.034     0.532     0.200
    77.082     0.276     0.200
    77.114     0.279     0.200
    77.157     0.942     0.200
    77.198     0.808     0.200
    77.230     0.228     0.200
    77.163     1.207     0.200
    77.294     0.469     0.200
    77.258     1.170     0.200
    77.306     0.904     0.200
    77.450     0.505     0.200
    77.460     0.544     0.200
    77.459     0.846     0.200
    77.397     0.897     0.200
    77.503     0.507     0.200
    77.504     0.694     0.200
    77.541     0.695     0.200
    77.588     0.229     0.200
    77.595     0.584     0.200
    77.606     1.227     0.200
    77.701     1.202     0.200
    77.701     1.499     0.200
    77.710     0.445     0.200
    77.626     1.117     0.200
    77.824     0.618     0.200
    77.860     0.715     0.200
    77.882     0.397     0.200
    77.908     0.447     0.200
    77.935     1.002     0.200
    77.954     0.896     0.200
    78.021     0.922     0.200
    78.025     0.500     0.200
    78.072     0.436     0.200
    78.110    -1.073     0.200
    78.031     1.467     0.200
    78.180     0.640     0.200
    78.203     1.208     0.200
    78.413     0.853     0.200
    78.420     1.216     0.200
    78.420     1.115     0.200
    78.550     0.995     0.200
    78.575     1.564     0.200
    78.649     0.453     0.200
    78.659     0.196     0.200
    78.624     0.092     0.200
    78.697     0.394     0.200
    78.784     1.210     0.200
    78.784     1.311     0.200
    78.816     1.435     0.200
    78.819     0.919     0.200
    78.849     0.154     0.200
    78.892     1.722     0.200
    78.908     0.633     0.200
    78.908     0.734     0.200
    78.953     0.383     0.200
    79.005     0.797     0.200
    79.135     1.084     0.200
    79.137     0.675     0.200
    79.148     0.017     0.200
    79.210     0.877     0.200
    79.236     0.841     0.200
    79.255     0.033     0.200
    79.255     0.134     0.200
    79.271    -0.158     0.200
    79.283     0.379     0.200
    79.313     0.917     0.200
    79.315     1.702     0.200
    79.334     0.604     0.200
    79.336     1.897     0.200
    79.363     1.044     0.200
    79.395     0.768     0.200
    79.408     1.769     0.200
    79.432     1.169     0.200
    79.452    -0.438     0.200
    79.463     0.398     0.200
    79.502     1.393     0.200
    79.502     1.033     0.200
    79.502     0.908     0.200
    79.519     0.194     0.200
    79.519     0.296     0.200
    79.522     0.580     0.200
    79.544     0.664     0.200
    79.571     1.411     0.200
    79.573     0.900     0.200
    79.584     0.241     0.200
    79.588    -0.282     0.200
    79.588    -0.180     0.200
    79.643     0.851     0.200
    79.656     1.950     0.200
    79.667     0.393     0.200
    79.693     0.253     0.200
    79.728     1.271     0.200
    79.773     0.315     0.200
    79.846     0.424     0.200
    79.911     2.241     0.200
    79.966     0.772     0.200
    79.982     0.687     0.200
    79.999     0.094     0.200
    80.035     1.605     0.200
    80.032     0.307     0.200
    80.076     1.680     0.200
    80.106     1.118     0.200
    80.116     0.967     0.200
    80.248     0.857     0.200
    80.282     1.273     0.200
    80.299     1.980     0.200
    80.270     0.930     0.200
    80.351     0.698     0.200
    80.294     0.211     0.200
    80.366    -0.278     0.200
    80.366    -0.176     0.200
    80.397     1.546     0.200
    80.438     0.327     0.200
    80.533     1.828     0.200
    80.537     0.099     0.200
    80.608     0.705     0.200
    80.628     0.176     0.200
    80.629    -0.246     0.200
    80.656    -0.296     0.200
    80.622     0.529     0.200
    80.680     0.622     0.200
    80.741    -0.247     0.200
    80.749     0.170     0.200
    80.762     0.794     0.200
    80.778     0.213     0.200
    80.829     0.081     0.200
    80.825     0.060     0.200
    80.841    -0.924     0.200
    80.852     1.117     0.200
    80.868     1.535     0.200
    80.886     1.132     0.200
    80.921    -0.347     0.200
    80.928     0.802     0.200
    80.985     0.912     0.200
    81.006     1.299     0.200
    81.011     0.281     0.200
    81.018     0.835     0.200
    81.029     0.177     0.200
    81.048     1.078     0.200
    81.062     0.101     0.200
    81.079     0.707     0.200
    81.135     0.717     0.200
    81.158     0.890     0.200
    81.087     0.204     0.200
    81.225     1.535     0.200
    81.153     1.095     0.200
    81.293     0.878     0.200
    81.295     1.561     0.200
    81.302     1.523     0.200
    81.302     1.625     0.200
    81.218     1.073     0.200
    81.318     1.841     0.200
    81.323     0.718     0.200
    81.378     0.723     0.200
    81.391     1.154     0.200
    81.397    -0.173     0.200
    81.453     0.826     0.200
    81.559     2.267     0.200
    81.565     0.237     0.200
    81.585     0.926     0.200
    81.646     1.807     0.200
    81.731     0.235     0.200
    81.758     0.920     0.200
    81.682     1.320     0.200
    81.845     0.681     0.200
    81.762     1.796     0.200
    82.078     0.856     0.200
    82.084     1.506     0.200
    82.011     0.491     0.200
    82.177     0.618     0.200
    82.202    -0.212     0.200
    82.123    -0.697     0.200
    82.245     0.664     0.200
    82.303    -0.637     0.200
    82.454     1.024     0.200
    82.509     0.286     0.200
    82.541     0.617     0.200
    82.481     1.329     0.200
    82.600     0.211     0.200
    82.585     0.888     0.200
    82.647     1.094     0.200
    82.770    -0.072     0.200
    82.781    -0.130     0.200
    82.818     0.381     0.200
    82.831     0.902     0.200
    82.731     0.529     0.200
    82.837     1.580     0.200
    82.855     0.191     0.200
    82.851     1.430     0.200
    82.921     0.148     0.200
    82.921     1.640     0.200
    82.921     0.945     0.200
    82.963    -0.069     0.200
    82.983     0.223     0.200
    83.128     0.074     0.200
    83.141     1.210     0.200
    83.135     1.042     0.200
    83.206    -0.325     0.200
    83.204     0.995     0.200
    83.225     1.575     0.200
    83.219     0.607     0.200
    83.267     1.060     0.200
    83.333     0.818     0.200
    83.427     0.936     0.200
    83.428     0.531     0.200
    83.428     0.632     0.200
    83.359     0.142     0.200
    83.449     0.218     0.200
    83.481     0.257     0.200
    83.481     0.655     0.200
    83.520     1.559     0.200
    83.630     0.497     0.200
    83.658     0.350     0.200
    83.658     1.053     0.200
    83.580     0.549     0.200
    83.677     1.003     0.200
    83.725     0.306     0.200
    83.646     0.739     0.200
    83.776     0.245     0.200
    83.960     0.810     0.200
    83.960     0.105     0.200
    83.997    -0.083     0.200
    83.997     0.800     0.200
    84.055     0.925     0.200
    84.064     0.480     0.200
    84.126     1.165     0.200
    84.193    -0.082     0.200
    84.204     1.128     0.200
    84.160     0.996     0.200
    84.243     0.369     0.200
    84.158     0.823     0.200
    84.295     0.609     0.200
    84.204     2.567     0.200
    84.350     0.444     0.200
    84.411    -0.983     0.200
    84.423     0.958     0.200
    84.470     0.519     0.200
    84.515     0.597     0.200
    84.523     1.748     0.200
    84.579     1.038     0.200
    84.615     0.272     0.200
    84.671    -0.091     0.200
    84.781     0.050     0.200
    84.784     0.339     0.200
    84.794     0.586     0.200
    84.842     0.345     0.200
    84.884     0.964     0.200
    84.943     0.940     0.200
    84.999     0.214     0.200
    85.070     0.907     0.200
    85.085     0.231     0.200
    85.115     0.729     0.200
    85.121     1.050     0.200
    85.180     0.614     0.200
    85.214     0.185     0.200
    85.110     2.502     0.200
    85.276     0.035     0.200
    85.347     1.005     0.200
    85.321     0.349     0.200
    85.404    -0.064     0.200
    85.416    -0.382     0.200
    85.482     0.545     0.200
    85.517     1.364     0.200
    85.530     1.204     0.200
    85.595     0.586     0.200
    85.587     2.625     0.200
    85.620     1.010     0.200
    85.671     1.050     0.200
    85.698     1.076     0.200
    85.713    -0.003     0.200
    85.713     0.794     0.200
    85.806     0.743     0.200
    85.913     0.511     0.200
    85.920     0.973     0.200
    85.984     0.456     0.200
    86.000     1.579     0.200
    86.018     1.391     0.200
    86.013     0.912     0.200
    86.023     0.811     0.200
    86.038     0.893     0.200
    86.148    -0.854     0.200
    86.356    -0.432     0.200
    86.354     1.337     0.200
    86.401     1.105     0.200
    86.454     0.336     0.200
    86.465     1.219     0.200
    86.551     0.340     0.200
    86.687     0.500     0.200
    86.725     2.020     0.200
    86.772     0.390     0.200
    86.980    -0.328     0.200
    87.182     0.998     0.200
    87.185    -1.619     0.200
    87.188    -0.921     0.200
    87.227     0.578     0.200
    87.290    -0.828     0.200
    87.301     0.119     0.200
    87.301    -0.482     0.200
    87.336     1.651     0.200
    87.365     0.114     0.200
    87.384     0.772     0.200
    87.454    -0.221     0.200
    87.512     0.202     0.200
    87.551     0.617     0.200
    87.551     0.718     0.200
    87.388     0.299     0.200
    87.388     1.799     0.200
    87.388     1.056     0.200
    87.892     0.491     0.200
    87.996     0.898     0.200
    87.996     1.695     0.200
    88.220     0.339     0.200
    88.222    -0.072     0.200
    88.267    -0.017     0.200
    88.521     0.916     0.200
    88.841     0.616     0.200
    89.106     0.666     0.200
    89.374     1.410     0.200
    89.540     0.429     0.200
    89.651     0.111     0.200
    89.836    -0.048     0.200
    89.905     0.223     0.200
    89.986    -0.655     0.200
    90.408    -1.419     0.200
    90.720     1.300     0.200
    91.089     0.418     0.200
    91.214     0.835     0.200
    91.422     1.168     0.200
    91.595     2.073     0.200
    92.269     0.454     0.200
    92.292    -0.151     0.200
    92.798     0.410     0.200
    92.804     0.485     0.200
    93.484     0.150     0.200
    93.895    -0.334     0.200
    93.968     1.625     0.200
    94.432     1.996     0.200
    94.893    -0.117     0.200
    96.120    -0.111     0.200
    96.108    -0.156     0.200
    96.170     0.163     0.200
    96.519    -0.192     0.200
    96.678     0.431     0.200
    18.450    -0.328     0.200
    36.891     1.249     0.200
    37.276    -0.679     0.200
    41.492     2.702     0.200
    41.657     1.279     0.200
    45.273     1.321     0.200
    45.390     1.394     0.200
    45.595     2.069     0.200
    46.300     2.109     0.200
    47.383     1.339     0.200
    47.810     0.018     0.200
    50.148     0.889     0.200
    57.309     1.650     0.200
    58.279    -1.771     0.200
    58.293     1.132     0.200
    59.127     1.228     0.200
    59.502    -0.163     0.200
    63.599    -1.028     0.200
    63.761     0.601     0.200
    64.370     0.000     0.200
    64.887     1.123     0.200
    65.051    -0.443     0.200
    65.253    -0.856     0.200
    65.568    -0.894     0.200
    66.465     0.437     0.200
    68.942     1.012     0.200
    72.478     1.275     0.200
    72.478     1.572     0.200
    73.260     0.636     0.200
    74.362     0.176     0.200
    74.838     0.211     0.200
    74.928     0.094     0.200
    74.951     0.463     0.200
    75.618    -0.178     0.200
    75.746    -0.013     0.200
    75.877     0.836     0.200
    75.930    -0.065     0.200
    76.252     0.405     0.200
    76.397     2.085     0.200
    76.562     1.147     0.200
    76.853     0.199     0.200
    76.855     0.097     0.200
    77.172     0.109     0.200
    77.386     0.112     0.200
    77.614    -0.166     0.200
    77.639     0.095     0.200
    77.779     0.510     0.200
    77.802     0.287     0.200
    77.933    -0.142     0.200
    78.051    -0.004     0.200
    78.219     0.165     0.200
    78.251     0.089     0.200
    78.323     0.594     0.200
    78.354     0.222     0.200
    78.516     0.331     0.200
    79.246     0.014     0.200
    79.281     0.128     0.200
    79.533     0.350     0.200
    79.674     0.580     0.200
    79.695     0.673     0.200
    79.726     0.208     0.200
    80.029     0.760     0.200
    80.252     0.658     0.200
    81.061     1.224     0.200
    82.568     1.179     0.200
    82.929     1.506     0.200
    83.120     1.521     0.200
    84.907     0.906     0.200
    85.620     0.338     0.200
    86.302     1.260     0.200
    18.765    -1.555     0.200
    18.765    -0.953     0.200
    23.483     0.418     0.200
    23.483     0.199     0.200
    24.339     2.330     0.200
    25.546     2.552     0.200
    25.546     2.950     0.200
    25.917     2.928     0.200
    26.631     0.138     0.200
    27.196     1.656     0.200
    27.196     2.554     0.200
    27.852     1.406     0.200
    29.101     2.677     0.200
    29.237     2.749     0.200
    29.310     1.524     0.200
    29.923     1.697     0.200
    30.275     2.332     0.200
    30.671     1.518     0.200
    31.856     1.548     0.200
    32.038     1.751     0.200
    32.038     2.051     0.200
    32.142    -0.667     0.200
    32.196     1.471     0.200
    32.196     2.362     0.200
    32.375     3.076     0.200
    32.793     3.135     0.200
    33.038     1.991     0.200
    33.038     2.390     0.200
    33.185     1.710     0.200
    33.185     2.608     0.200
    33.314     2.391     0.200
    33.363     0.247     0.200
    33.363     0.575     0.200
    33.430     2.570     0.200
    33.430     2.968     0.200
    33.635     2.481     0.200
    33.638     2.765     0.200
    33.760     1.699     0.200
    33.760     1.898     0.200
    33.959     2.890     0.200
    34.080     1.918     0.200
    34.080     2.020     0.200
    34.960     2.237     0.200
    35.135     2.803     0.200
    35.195     1.288     0.200
    35.195     2.187     0.200
    35.331    -1.521     0.200
    35.350     0.458     0.200
    35.333     1.156     0.200
    35.334     1.795     0.200
    35.687     0.565     0.200
    35.799     2.979     0.200
    35.837     1.777     0.200
    35.837     2.077     0.200
    36.159     2.022     0.200
    36.327     1.587     0.200
    36.327     1.888     0.200
    36.484     1.427     0.200
    36.562     1.579     0.200
    36.562     2.079     0.200
    36.580     2.424     0.200
    36.990     2.657     0.200
    37.118     2.243     0.200
    37.320    -0.323     0.200
    37.320    -0.429     0.200
    37.556     2.139     0.200
    37.590     2.446     0.200
    37.703     0.849     0.200
    38.049     1.129     0.200
    38.334     1.398     0.200
    38.471     1.118     0.200
    38.564     1.307     0.200
    38.788     0.764     0.200
    38.920     2.831     0.200
    39.719     1.805     0.200
    39.774     1.895     0.200
    42.342     1.377     0.200
    43.573     0.860     0.200
    43.670     0.730     0.200
    44.153    -1.004     0.200
    44.197     0.043     0.200
    44.197     0.840     0.200
    44.545     0.939     0.200
    44.545     0.658     0.200
    44.545     1.162     0.200
    45.357     0.703     0.200
    46.281    -0.484     0.200
    46.548    -0.936     0.200
    46.584    -0.515     0.200
    46.584     0.485     0.200
    46.675    -0.475     0.200
    46.614     0.601     0.200
    46.967    -0.762     0.200
    46.940     0.618     0.200
    46.983    -0.584     0.200
    47.022     0.410     0.200
    47.145    -1.244     0.200
    47.250     1.332     0.200
    47.391    -0.864     0.200
    47.375     0.963     0.200
    47.918     0.650     0.200
    47.847     0.093     0.200
    48.047     1.253     0.200
    48.082     1.776     0.200
    48.114     0.029     0.200
    48.974    -0.872     0.200
    49.163     2.419     0.200
    49.303     0.698     0.200
    49.490    -0.808     0.200
    50.093     0.638     0.200
    50.093     0.188     0.200
    51.084     1.013     0.200
    51.171     0.360     0.200
    51.263     1.669     0.200
    51.263     1.868     0.200
    51.354     0.937     0.200
    51.386     0.199     0.200
    51.838    -0.089     0.200
    52.056     0.125     0.200
    52.133    -0.024     0.200
    52.389     0.474     0.200
    52.519    -0.303     0.200
    52.976     0.066     0.200
    53.642    -1.406     0.200
    53.670    -0.965     0.200
    53.839     0.498     0.200
    54.239    -0.475     0.200
    54.593     0.612     0.200
    54.524     0.057     0.200
    54.611    -0.658     0.200
    55.190    -0.777     0.200
    55.190    -0.308     0.200
    55.724    -0.914     0.200
    55.992    -0.968     0.200
    55.993    -0.438     0.200
    56.344    -0.846     0.200
    56.485     0.521     0.200
    56.408     0.047     0.200
    56.410    -0.049     0.200
    56.613    -0.125     0.200
    56.724     1.516     0.200
    56.815     0.472     0.200
    56.990     1.109     0.200
    57.163    -1.292     0.200
    57.163    -1.167     0.200
    57.163    -0.702     0.200
    57.472     0.530     0.200
    57.788    -1.087     0.200
    58.081    -0.244     0.200
    58.280     1.065     0.200
    58.292     0.781     0.200
    58.467    -0.637     0.200
    58.467    -0.637     0.200
    58.483    -0.753     0.200
    58.898     0.162     0.200
    59.426    -1.655     0.200
    61.004     0.367     0.200
    61.831    -1.082     0.200
    62.570     0.268     0.200
    62.732     0.025     0.200
    63.394    -0.700     0.200
    63.576    -0.607     0.200
    63.740    -0.184     0.200
    64.069     0.651     0.200
    64.072    -0.471     0.200
    64.068     0.525     0.200
    64.461     0.011     0.200
    64.459    -0.905     0.200
    64.459    -0.206     0.200
    64.469    -0.166     0.200
    64.469    -0.268     0.200
    64.585    -0.730     0.200
    64.585    -0.882     0.200
    64.585    -0.351     0.200
    64.676    -0.321     0.200
    64.786    -0.239     0.200
    64.785    -0.029     0.200
    64.888    -0.204     0.200
    65.059    -0.513     0.200
    65.345     0.275     0.200
    65.486     0.347     0.200
    65.525     0.171     0.200
    65.745     0.251     0.200
    65.783     0.310     0.200
    65.783    -0.018     0.200
    65.783     0.431     0.200
    65.805    -1.138     0.200
    65.819     0.020     0.200
    67.416     0.080     0.200
    67.441    -1.079     0.200
    67.702    -0.024     0.200
    67.718     0.173     0.200
    67.892     0.382     0.200
    67.946     0.243     0.200
    68.111     0.704     0.200
    68.304     0.093     0.200
    68.346     0.631     0.200
    68.384     0.295     0.200
    68.469     0.358     0.200
    68.858     0.037     0.200
    68.883     0.669     0.200
    68.893     0.318     0.200
    68.893     0.427     0.200
    69.015     1.459     0.200
    69.590    -0.494     0.200
    69.590    -0.724     0.200
    69.872     0.467     0.200
    69.943     0.134     0.200
    70.005     0.952     0.200
    70.182     0.588     0.200
    70.206     0.421     0.200
    70.372     0.208     0.200
    70.334     2.935     0.200
    70.426     0.576     0.200
    70.356     2.806     0.200
    70.445     0.248     0.200
    70.521     0.095     0.200
    70.590     2.675     0.200
    70.602     2.698     0.200
    70.713    -1.574     0.200
    70.924    -0.654     0.200
    71.041     1.636     0.200
    71.110    -0.184     0.200
    71.235     0.603     0.200
    71.476     0.503     0.200
    71.489     1.924     0.200
    71.660     0.675     0.200
    71.698     0.670     0.200
    71.698     2.412     0.200
    71.749     0.062     0.200
    71.771     0.513     0.200
    71.828     1.490     0.200
    71.972     1.325     0.200
    72.041     0.507     0.200
    72.182     0.665     0.200
    72.404     1.641     0.200
    72.404     1.391     0.200
    72.536     0.453     0.200
    72.596     2.399     0.200
    72.629     2.498     0.200
    72.649     2.482     0.200
    72.741     2.435     0.200
    72.973     0.843     0.200
    72.899     2.799     0.200
    73.022     0.692     0.200
    73.068     0.761     0.200
    73.164     0.829     0.200
    73.217     0.616     0.200
    73.227     0.455     0.200
    73.306     0.473     0.200
    73.562     0.484     0.200
    73.616     0.870     0.200
    73.617     0.465     0.200
    73.718     2.472     0.200
    73.761     0.565     0.200
    74.071     1.606     0.200
    74.204     0.832     0.200
    74.271     0.041     0.200
    74.281     0.382     0.200
    74.375     0.232     0.200
    74.379     0.389     0.200
    74.483     0.367     0.200
    74.543     0.858     0.200
    74.539     0.323     0.200
    74.629    -0.689     0.200
    74.629    -0.490     0.200
    74.738     0.329     0.200
    74.825     0.024     0.200
    74.874     0.640     0.200
    74.874     0.331     0.200
    74.921     0.399     0.200
    75.111     0.576     0.200
    75.217     0.464     0.200
    75.319     0.891     0.200
    75.385     0.500     0.200
    75.466     0.338     0.200
    75.489     0.923     0.200
    75.526     0.490     0.200
    75.556     0.018     0.200
    75.602     1.856     0.200
    75.605     0.541     0.200
    75.628    -0.592     0.200
    75.641     0.429     0.200
    75.595     3.224     0.200
    75.665     0.096     0.200
    75.741     0.751     0.200
    75.806     0.987     0.200
    75.806     0.878     0.200
    75.807     0.775     0.200
    75.851     0.335     0.200
    75.850     0.691     0.200
    75.908     0.588     0.200
    75.943     0.636     0.200
    75.983     0.580     0.200
    75.982     0.387     0.200
    75.982    -0.613     0.200
    76.046     0.633     0.200
    76.127     0.704     0.200
    76.182     0.756     0.200
    76.248     0.572     0.200
    76.263     0.686     0.200
    76.300     0.674     0.200
    76.307     0.538     0.200
    76.366     0.706     0.200
    76.409     0.491     0.200
    76.425     0.350     0.200
    76.429     0.651     0.200
    76.468     1.326     0.200
    76.493     0.984     0.200
    76.516     0.497     0.200
    76.606     1.439     0.200
    76.624     0.353     0.200
    76.636     0.496     0.200
    76.691     0.962     0.200
    76.758     0.488     0.200
    76.758     0.586     0.200
    76.825     0.612     0.200
    76.825     0.412     0.200
    76.830     0.583     0.200
    76.901     0.681     0.200
    76.986     0.365     0.200
    77.016     0.235     0.200
    77.011     0.566     0.200
    77.063     1.211     0.200
    77.110     0.634     0.200
    77.152     0.470     0.200
    77.152    -0.429     0.200
    77.332     0.762     0.200
    77.362     0.493     0.200
    77.370     0.446     0.200
    77.370     0.548     0.200
    77.405     0.250     0.200
    77.415     0.398     0.200
    77.485     1.303     0.200
    77.514     0.942     0.200
    77.560     0.185     0.200
    77.646     0.404     0.200
    77.646     0.506     0.200
    77.646    -0.596     0.200
    77.785     0.433     0.200
    77.785     0.534     0.200
    77.814     0.473     0.200
    77.834     0.462     0.200
    77.829     0.788     0.200
    77.829    -0.313     0.200
    77.843     0.811     0.200
    77.850     0.874     0.200
    77.877     1.421     0.200
    77.939     0.273     0.200
    78.065     0.276     0.200
    78.065    -0.724     0.200
    78.175     0.664     0.200
    78.112     0.619     0.200
    78.239     0.312     0.200
    78.239    -0.587     0.200
    78.250     1.051     0.200
    78.261     0.396     0.200
    78.261    -0.706     0.200
    78.271     0.934     0.200
    78.309     0.527     0.200
    78.335    -0.616     0.200
    78.353     0.886     0.200
    78.389     0.485     0.200
    78.326     0.693     0.200
    78.326     1.096     0.200
    78.432     0.346     0.200
    78.510     0.918     0.200
    78.539     0.557     0.200
    78.518     0.872     0.200
    78.618     0.123     0.200
    78.613     1.348     0.200
    78.770     0.589     0.200
    78.902     1.365     0.200
    78.905     0.847     0.200
    78.969    -0.106     0.200
    79.054     0.627     0.200
    79.153     1.287     0.200
    79.239     1.416     0.200
    79.226     1.688     0.200
    79.238     0.823     0.200
    79.318     0.184     0.200
    79.318    -0.714     0.200
    79.464    -0.108     0.200
    79.468     0.471     0.200
    79.476     1.023     0.200
    79.500     0.395     0.200
    79.567    -0.370     0.200
    79.576    -0.419     0.200
    79.576    -0.118     0.200
    79.585     0.035     0.200
    79.579     0.764     0.200
    79.579    -0.333     0.200
    79.592     0.691     0.200
    79.624     0.321     0.200
    79.640     0.893     0.200
    79.622    -0.468     0.200
    79.662     1.556     0.200
    79.643     0.469     0.200
    79.648     0.992     0.200
    79.656     1.647     0.200
    79.676     1.639     0.200
    79.746     1.828     0.200
    79.758     0.492     0.200
    79.758    -0.406     0.200
    79.759     0.735     0.200
    79.804     1.107     0.200
    79.838     0.662     0.200
    79.841     0.142     0.200
    79.885     1.906     0.200
    79.894     0.057     0.200
    79.888     0.488     0.200
    79.911     0.962     0.200
    79.929     0.665     0.200
    79.956    -0.478     0.200
    80.013     1.243     0.200
    80.051     1.350     0.200
    80.053     0.998     0.200
    80.066     1.014     0.200
    80.115     1.291     0.200
    80.112     1.680     0.200
    80.144     0.708     0.200
    80.172     1.233     0.200
    80.179     1.158     0.200
    80.194    -0.261     0.200
    80.252     2.303     0.200
    80.286     1.524     0.200
    80.302     1.674     0.200
    80.301     0.159     0.200
    80.327    -0.477     0.200
    80.338     1.311     0.200
    80.363     0.498     0.200
    80.371     0.286     0.200
    80.454     1.138     0.200
    80.487     0.661     0.200
    80.554     0.301     0.200
    80.610     1.103     0.200
    80.652     1.376     0.200
    80.640     1.943     0.200
    80.691     0.819     0.200
    80.691     1.969     0.200
    80.705    -0.402     0.200
    80.733     1.344     0.200
    80.733     1.445     0.200
    80.776     2.116     0.200
    80.770     0.253     0.200
    80.802     0.974     0.200
    80.802     1.474     0.200
    80.866     1.261     0.200
    80.874     1.249     0.200
    80.871    -0.093     0.200
    80.902     1.442     0.200
    80.964     0.042     0.200
    80.968    -0.340     0.200
    80.995    -0.353     0.200
    81.048     2.665     0.200
    81.075    -0.179     0.200
    81.192     1.400     0.200
    81.225     1.123     0.200
    81.294     0.855     0.200
    81.300     1.024     0.200
    81.324     0.898     0.200
    81.347     0.345     0.200
    81.305     1.698     0.200
    81.357     0.723     0.200
    81.385     0.074     0.200
    81.414     0.921     0.200
    81.394     0.927     0.200
    81.397     1.322     0.200
    81.401     0.186     0.200
    81.401    -0.111     0.200
    81.420     0.988     0.200
    81.473     0.906     0.200
    81.574     0.575     0.200
    81.589     0.694     0.200
    81.611     1.279     0.200
    81.615     1.356     0.200
    81.634     1.658     0.200
    81.668     1.880     0.200
    81.581    -2.162     0.200
    81.679     0.321     0.200
    81.668     0.979     0.200
    81.687     0.780     0.200
    81.710     1.155     0.200
    81.720    -0.496     0.200
    81.724     1.483     0.200
    81.746     0.669     0.200
    81.773     1.023     0.200
    81.781     1.183     0.200
    81.802     0.874     0.200
    81.901     0.754     0.200
    82.011     0.877     0.200
    82.061     1.115     0.200
    82.219     0.883     0.200
    82.312     0.995     0.200
    82.360     1.387     0.200
    82.440     1.329     0.200
    82.440     2.130     0.200
    82.490     0.569     0.200
    82.494     0.149     0.200
    82.504    -2.003     0.200
    82.658     1.193     0.200
    82.790     0.350     0.200
    82.786     1.029     0.200
    82.815     0.619     0.200
    82.846     1.718     0.200
    82.878     0.289     0.200
    82.945     1.905     0.200
    82.945     2.187     0.200
    82.994     0.453     0.200
    82.992     0.459     0.200
    83.024     0.294     0.200
    82.941     1.325     0.200
    83.030     0.463     0.200
    83.030     0.264     0.200
    83.042     0.204     0.200
    83.042     1.102     0.200
    83.091     0.288     0.200
    83.168    -0.049     0.200
    83.230    -1.767     0.200
    83.230    -1.267     0.200
    83.217     0.299     0.200
    83.230     1.132     0.200
    83.230     0.734     0.200
    83.244    -0.069     0.200
    83.260     0.288     0.200
    83.187     0.065     0.200
    83.187     0.182     0.200
    83.255     1.101     0.200
    83.255     1.402     0.200
    83.230     1.480     0.200
    83.408    -0.023     0.200
    83.451     0.394     0.200
    83.451     0.093     0.200
    83.464     1.025     0.200
    83.466     0.717     0.200
    83.466     1.018     0.200
    83.410    -0.074     0.200
    83.560    -0.364     0.200
    83.579     0.436     0.200
    83.579     0.936     0.200
    83.593    -1.638     0.200
    83.559     0.526     0.200
    83.691     0.862     0.200
    83.726     0.092     0.200
    83.794     0.232     0.200
    83.837     1.454     0.200
    83.866     0.965     0.200
    83.889     0.151     0.200
    83.888     1.356     0.200
    83.938    -0.402     0.200
    83.962     1.377     0.200
    84.006     0.752     0.200
    84.006     1.252     0.200
    83.937     1.032     0.200
    84.017     0.996     0.200
    84.075     0.813     0.200
    84.075     1.012     0.200
    84.011     2.228     0.200
    84.146     1.041     0.200
    84.179     0.374     0.200
    84.215    -0.313     0.200
    84.181     0.111     0.200
    84.303     1.442     0.200
    84.313     1.193     0.200
    84.293     0.793     0.200
    84.366     1.023     0.200
    84.408    -0.289     0.200
    84.462     1.240     0.200
    84.482     0.436     0.200
    84.518     0.883     0.200
    84.562     0.430     0.200
    84.570     0.393     0.200
    84.587     0.146     0.200
    84.587     1.306     0.200
    84.626     1.912     0.200
    84.623     1.125     0.200
    84.682     1.130     0.200
    84.686     0.308     0.200
    84.786     0.503     0.200
    84.879     0.405     0.200
    84.824    -0.920     0.200
    84.943     0.513     0.200
    84.943     1.013     0.200
    84.988     0.787     0.200
    85.020     0.431     0.200
    85.051     1.325     0.200
    85.051     1.505     0.200
    85.064     0.905     0.200
    85.084     0.208     0.200
    85.176    -0.152     0.200
    85.229     0.279     0.200
    85.248     0.287     0.200
    85.274     0.855     0.200
    85.274     0.956     0.200
    85.347     0.294     0.200
    85.353     0.860     0.200
    85.512     0.069     0.200
    85.432     1.216     0.200
    85.526     1.603     0.200
    85.533     0.283     0.200
    85.525     0.606     0.200
    85.525     0.805     0.200
    85.584     0.315     0.200
    85.584     0.713     0.200
    85.605     1.309     0.200
    85.649     1.989     0.200
    85.666     0.005     0.200
    85.855     0.166     0.200
    85.849     0.769     0.200
    85.889     0.602     0.200
    85.971     0.893     0.200
    85.976     1.070     0.200
    86.007     0.517     0.200
    86.019     0.835     0.200
    86.098     0.665     0.200
    86.123    -0.356     0.200
    86.146     0.609     0.200
    86.218     0.275     0.200
    86.245     0.242     0.200
    86.212     1.144     0.200
    86.171     0.097     0.200
    86.312     2.013     0.200
    86.408     1.240     0.200
    86.420     0.811     0.200
    86.418     0.832     0.200
    86.443    -0.731     0.200
    86.443     1.067     0.200
    86.614    -0.452     0.200
    86.629     0.527     0.200
    86.733     1.044     0.200
    86.761     1.512     0.200
    86.844     0.344     0.200
    86.852     0.357     0.200
    86.872     1.470     0.200
    86.901     0.830     0.200
    86.881     1.187     0.200
    86.941     1.135     0.200
    87.000     0.147     0.200
    87.036    -0.886     0.200
    87.133     1.701     0.200
    87.358    -0.822     0.200
    87.495     0.448     0.200
    87.585    -0.182     0.200
    87.615     0.076     0.200
    87.660    -0.039     0.200
    87.980     0.134     0.200
    88.043     2.137     0.200
    88.429    -0.290     0.200
    88.464     0.246     0.200
    88.525     0.662     0.200
    88.569     2.320     0.200
    88.874     1.812     0.200
    88.894    -0.576     0.200
    89.126     3.035     0.200
    89.827     3.250     0.200
    89.836    -0.093     0.200
    90.151     0.837     0.200
    90.222     0.304     0.200
    90.337     3.771     0.200
    90.562     0.604     0.200
    90.655     2.988     0.200
    90.833     0.866     0.200
    90.851     3.377     0.200
    91.035     3.126     0.200
    91.126    -1.095     0.200
    91.184     0.813     0.200
    91.184     1.547     0.200
    91.511     2.120     0.200
    92.095     0.116     0.200
    92.291    -0.491     0.200
    92.801     0.395     0.200
    93.324    -0.653     0.200
    95.474     0.785     0.200
    95.655     0.456     0.200
    95.657     0.249     0.200
    95.915     0.175     0.200
    96.474     0.816     0.200
    96.600    -0.237     0.200
    15.687     2.330     0.200
    19.263     0.404     0.200
    22.821     0.997     0.200
    23.974     0.925     0.200
    24.403     2.282     0.200
    25.016     2.497     0.200
    25.391     2.975     0.200
    25.964     2.693     0.200
    26.325    -0.931     0.200
    28.766     1.219     0.200
    29.762     2.389     0.200
    34.556     2.602     0.200
    34.799     1.873     0.200
    35.313     2.609     0.200
    35.846     0.775     0.200
    35.819     2.146     0.200
    36.047     3.100     0.200
    36.597     2.513     0.200
    37.114     1.866     0.200
    37.811     2.190     0.200
    37.948     1.882     0.200
    38.040     2.172     0.200
    38.247     0.385     0.200
    41.924     0.618     0.200
    44.115    -1.713     0.200
    44.577    -1.812     0.200
    45.071     0.956     0.200
    45.071     0.360     0.200
    46.447    -0.504     0.200
    46.407     1.063     0.200
    47.430     0.424     0.200
    47.539     1.379     0.200
    49.553    -0.113     0.200
    49.770     1.136     0.200
    49.868     0.089     0.200
    51.975     0.720     0.200
    53.988    -0.003     0.200
    54.180    -0.784     0.200
    57.667    -0.736     0.200
    63.303    -0.988     0.200
    63.374     0.645     0.200
    63.840     0.266     0.200
    63.981    -1.757     0.200
    63.963    -0.042     0.200
    64.488     0.516     0.200
    64.630     0.091     0.200
    64.961    -0.664     0.200
    66.051     0.890     0.200
    68.551     1.468     0.200
    68.637    -0.472     0.200
    70.472     1.615     0.200
    74.108    -0.490     0.200
    74.581     0.961     0.200
    74.703     0.654     0.200
    75.420     0.421     0.200
    75.487     0.338     0.200
    75.631     1.310     0.200
    75.735    -0.079     0.200
    75.990     2.965     0.200
    76.307     0.860     0.200
    76.374    -0.518     0.200
    76.946    -0.151     0.200
    77.159    -0.143     0.200
    77.425    -0.033     0.200
    77.583     0.185     0.200
    77.590    -0.053     0.200
    77.718    -0.371     0.200
    77.840    -0.146     0.200
    78.038    -0.348     0.200
    78.151     0.023     0.200
    78.199    -0.142     0.200
    78.308     0.355     0.200
    79.618     1.287     0.200
    79.675     0.168     0.200
    79.675     0.867     0.200
    80.092     1.605     0.200
    80.415     0.932     0.200
    80.431     0.088     0.200
    80.490     1.141     0.200
    80.539     0.818     0.200
    80.539     0.912     0.200
    80.650     1.224     0.200
    81.114     1.241     0.200
    81.222     0.917     0.200
    81.225     0.899     0.200
    83.735     0.364     0.200
    84.448     1.139     0.200
    92.810    -0.650     0.200
    96.169     0.456     0.200
    17.494     1.822     0.200
    18.895    -2.583     0.200
    23.695    -0.094     0.200
    26.813    -0.604     0.200
    27.727     0.386     0.200
    29.191     2.955     0.200
    32.296    -1.237     0.200
    34.899     2.389     0.200
    35.184     1.653     0.200
    36.379     2.730     0.200
    36.944     1.918     0.200
    38.162     1.930     0.200
    38.299     2.179     0.200
    38.394     2.278     0.200
    38.733     0.492     0.200
    42.163     2.019     0.200
    42.407     0.474     0.200
    44.540    -0.657     0.200
    44.713     0.467     0.200
    44.713     0.762     0.200
    47.199    -0.433     0.200
    47.643    -1.187     0.200
    49.533     1.379     0.200
    49.959     0.439     0.200
    55.174    -1.071     0.200
    56.254    -1.424     0.200
    59.002    -0.453     0.200
    62.832    -1.079     0.200
    63.658    -0.551     0.200
    63.658    -0.751     0.200
    63.845     0.019     0.200
    64.337    -1.009     0.200
    64.325     0.370     0.200
    64.882    -0.568     0.200
    65.029    -0.726     0.200
    65.322    -0.425     0.200
    65.708     0.180     0.200
    66.058    -0.571     0.200
    66.035     0.972     0.200
    68.356     1.352     0.200
    69.869    -0.832     0.200
    74.514     0.299     0.200
    74.983     0.983     0.200
    75.115     0.627     0.200
    75.722     0.442     0.200
    75.877     0.057     0.200
    75.887     0.695     0.200
    75.870     2.392     0.200
    76.045     0.895     0.200
    76.517     0.518     0.200
    76.712     0.316     0.200
    76.750     0.600     0.200
    77.002     0.280     0.200
    77.002     0.081     0.200
    77.055     0.384     0.200
    77.380     0.361     0.200
    77.591     0.283     0.200
    77.736     1.170     0.200
    77.868     0.239     0.200
    77.868     0.039     0.200
    78.034     0.315     0.200
    78.040     0.581     0.200
    78.161     0.111     0.200
    78.285     0.125     0.200
    78.380     0.599     0.200
    78.415     0.808     0.200
    78.490     0.995     0.200
    78.510     0.983     0.200
    78.604     0.266     0.200
    78.757     0.323     0.200
    79.791     0.477     0.200
    79.790     0.782     0.200
    80.101     0.398     0.200
    80.846     1.102     0.200
    83.146     1.022     0.200
    83.281    -0.174     0.200
    84.212     0.460     0.200
    86.831     1.218     0.200
    90.265    -1.048     0.200
    92.285     0.784     0.200
    92.293     0.447     0.200
    95.648     0.634     0.200
    17.464     2.487     0.200
    23.250     2.235     0.200
    23.627    -0.396     0.200
    24.996     0.518     0.200
    24.996     1.919     0.200
    26.178     0.403     0.200
    26.178     1.102     0.200
    26.691    -0.325     0.200
    35.215     1.777     0.200
    35.495    -1.328     0.200
    37.597     1.490     0.200
    38.714     0.849     0.200
    40.056     0.857     0.200
    42.390     0.566     0.200
    43.977    -0.434     0.200
    44.419    -1.670     0.200
    44.671     0.417     0.200
    44.671     0.214     0.200
    46.894    -0.929     0.200
    46.708    -0.776     0.200
    46.759    -0.373     0.200
    47.118    -0.278     0.200
    47.911     0.912     0.200
    47.911     1.960     0.200
    49.453     0.912     0.200
    49.981     0.694     0.200
    54.003    -0.241     0.200
    54.766     0.514     0.200
    56.108    -1.140     0.200
    57.287    -1.613     0.200
    57.287    -0.712     0.200
    59.014     0.808     0.200
    63.512    -0.527     0.200
    63.738     0.380     0.200
    63.890     0.379     0.200
    64.190    -0.891     0.200
    64.227     1.165     0.200
    64.569    -0.173     0.200
    64.735    -0.750     0.200
    64.887    -0.447     0.200
    65.176    -0.318     0.200
    65.565    -0.040     0.200
    65.914    -1.784     0.200
    68.266     0.781     0.200
    68.962    -0.110     0.200
    74.373    -0.202     0.200
    74.470     0.193     0.200
    74.841     0.482     0.200
    74.974     0.717     0.200
    75.744    -0.207     0.200
    75.905     1.175     0.200
    76.016     0.543     0.200
    76.061     0.088     0.200
    76.473     0.750     0.200
    76.570     0.797     0.200
    76.605     0.400     0.200
    76.860     0.060     0.200
    76.860     0.460     0.200
    76.917     0.040     0.200
    77.243    -0.088     0.200
    77.593     1.354     0.200
    77.733    -0.027     0.200
    77.899    -0.153     0.200
    77.908    -0.104     0.200
    78.150    -0.144     0.200
    78.274     0.868     0.200
    78.349     1.053     0.200
    78.346    -0.132     0.200
    78.369     1.042     0.200
    78.612     1.404     0.200
    79.399     0.491     0.200
    79.401     1.188     0.200
    79.659     0.280     0.200
    79.746     0.805     0.200
    79.781     0.713     0.200
    79.766     0.596     0.200
    79.825     1.429     0.200
    79.884     1.608     0.200
    79.965     0.521     0.200
    79.966     0.785     0.200
    80.214     1.108     0.200
    80.335     0.915     0.200
    80.342     0.896     0.200
    80.466     1.454     0.200
    80.697     2.083     0.200
    80.804     0.415     0.200
    81.030     0.939     0.200
    81.038     0.975     0.200
    81.679     0.470     0.200
    81.757     0.757     0.200
    81.891     0.553     0.200
    82.879     0.591     0.200
    83.004     0.946     0.200
    84.085     0.696     0.200
    84.675     0.606     0.200
    92.337    -0.460     0.200
    95.697    -0.186     0.200
    18.950    -1.953     0.200
    25.107     1.426     0.200
    26.866    -0.398     0.200
    35.218     1.727     0.200
    36.406     3.006     0.200
    38.779     0.755     0.200
    42.191     2.636     0.200
    42.453     0.347     0.200
    44.111    -1.389     0.200
    44.683     0.829     0.200
    44.683     1.033     0.200
    47.065    -1.166     0.200
    47.689    -0.725     0.200
    50.057     1.099     0.200
    50.454     0.793     0.200
    56.298    -1.551     0.200
    59.165    -0.309     0.200
    63.701    -0.676     0.200
    63.841    -0.399     0.200
    64.380    -1.033     0.200
    64.758    -0.508     0.200
    64.911    -1.003     0.200
    65.365    -0.553     0.200
    65.755    -0.368     0.200
    69.146    -0.622     0.200
    74.562    -0.149     0.200
    75.162     0.177     0.200
    75.195    -0.408     0.200
    75.928    -0.912     0.200
    75.934     0.452     0.200
    76.093     0.646     0.200
    76.205     0.508     0.200
    76.244    -0.512     0.200
    76.662     0.820     0.200
    76.759     1.271     0.200
    77.049     0.336     0.200
    77.049     0.436     0.200
    77.104    -0.572     0.200
    77.429    -0.596     0.200
    77.782     0.333     0.200
    77.918    -0.623     0.200
    78.085    -0.547     0.200
    78.092    -0.186     0.200
    78.335    -0.736     0.200
    78.532    -0.722     0.200
    78.789    -0.138     0.200
    79.508     0.941     0.200
    79.842    -0.287     0.200
    79.933     0.422     0.200
    79.953     0.812     0.200
    80.072     0.840     0.200
    80.326     1.293     0.200
    80.447     1.002     0.200
    80.456     0.973     0.200
    80.720     0.688     0.200
    80.561     1.189     0.200
    80.581     1.398     0.200
    80.826     0.588     0.200
    80.944     0.959     0.200
    80.869     0.888     0.200
    81.027     1.094     0.200
    81.155     0.675     0.200
    81.333     0.472     0.200
    81.604    -0.216     0.200
    81.665     0.364     0.200
    81.500     0.703     0.200
    81.739     1.073     0.200
    83.067     0.036     0.200
    84.265     0.394     0.200
    95.597     0.755     0.200
    17.348     1.419     0.200
    18.681    -1.189     0.200
    23.702    -0.168     0.200
    24.877    -0.183     0.200
    24.877     1.716     0.200
    25.060    -1.049     0.200
    26.221     0.322     0.200
    26.221     1.627     0.200
    27.640     1.277     0.200
    32.966     2.498     0.200
    33.419     2.892     0.200
    33.421     2.834     0.200
    33.484     2.674     0.200
    33.863     2.201     0.200
    34.858     2.420     0.200
    35.081     2.337     0.200
    35.119     1.417     0.200
    35.119     1.314     0.200
    35.519    -1.027     0.200
    36.108     2.673     0.200
    36.266     1.367     0.200
    36.343     2.620     0.200
    36.900     2.074     0.200
    37.494     0.934     0.200
    38.253     1.555     0.200
    38.346     1.600     0.200
    38.600     0.011     0.200
    39.123     1.384     0.200
    39.227     1.216     0.200
    41.538     1.945     0.200
    42.277    -0.230     0.200
    43.996     0.216     0.200
    44.762     1.686     0.200
    46.614     0.599     0.200
    46.669    -0.277     0.200
    47.828     1.004     0.200
    49.520     1.295     0.200
    49.881    -0.070     0.200
    50.095     0.627     0.200
    54.015     0.464     0.200
    54.808     0.999     0.200
    54.827     0.461     0.200
    56.030    -0.464     0.200
    56.040    -1.069     0.200
    56.000    -0.100     0.200
    57.469     2.197     0.200
    57.827    -0.729     0.200
    58.864    -1.766     0.200
    59.014    -0.802     0.200
    59.456    -1.781     0.200
    61.407     0.116     0.200
    63.445    -0.510     0.200
    63.780     0.484     0.200
    63.862     0.149     0.200
    64.124    -0.978     0.200
    64.279     1.706     0.200
    64.490    -0.276     0.200
    64.490    -0.878     0.200
    64.704     0.224     0.200
    64.808    -0.649     0.200
    65.108    -0.301     0.200
    65.801     0.257     0.200
    65.840    -1.726     0.200
    65.931     1.381     0.200
    67.533    -0.727     0.200
    68.870    -0.608     0.200
    68.937     0.977     0.200
    69.097     1.382     0.200
    69.666    -1.242     0.200
    69.705     0.226     0.200
    69.895     1.159     0.200
    70.181     0.404     0.200
    70.743     0.870     0.200
    71.655    -0.446     0.200
    71.994     1.313     0.200
    72.412     2.320     0.200
    73.235     0.936     0.200
    74.099     0.344     0.200
    74.099     0.579     0.200
    74.294     0.027     0.200
    74.321     0.441     0.200
    74.321     0.675     0.200
    74.384     0.627     0.200
    74.414     0.452     0.200
    74.414     0.631     0.200
    74.592     0.377     0.200
    74.592     0.682     0.200
    74.613     0.780     0.200
    74.649     0.450     0.200
    74.649     0.676     0.200
    74.691    -0.601     0.200
    74.719     0.472     0.200
    74.719     0.831     0.200
    74.763     0.708     0.200
    74.786     0.655     0.200
    74.786     0.881     0.200
    74.785     0.401     0.200
    74.785     0.627     0.200
    74.787     0.830     0.200
    74.836     1.274     0.200
    74.856    -0.032     0.200
    74.865     0.980     0.200
    74.867     0.833     0.200
    74.914     0.836     0.200
    74.921     0.297     0.200
    74.938     0.196     0.200
    74.944     0.521     0.200
    74.944     0.982     0.200
    75.002     0.625     0.200
    75.002     0.938     0.200
    75.013     1.029     0.200
    75.060     0.634     0.200
    75.064     0.673     0.200
    75.071     1.087     0.200
    75.074     0.732     0.200
    75.122     0.333     0.200
    75.123     0.576     0.200
    75.162     0.737     0.200
    75.163     0.734     0.200
    75.194     0.675     0.200
    75.242     0.252     0.200
    75.242     0.533     0.200
    75.260     1.429     0.200
    75.260     0.205     0.200
    75.260     0.431     0.200
    75.260     0.575     0.200
    75.271     0.194     0.200
    75.271     0.428     0.200
    75.299     0.636     0.200
    75.310     0.217     0.200
    75.310     0.576     0.200
    75.350     0.726     0.200
    75.354     0.489     0.200
    75.359     0.132     0.200
    75.359     0.546     0.200
    75.393     0.474     0.200
    75.491     0.070     0.200
    75.491     0.484     0.200
    75.494     1.024     0.200
    75.505     0.131     0.200
    75.531     1.474     0.200
    75.533     0.671     0.200
    75.652    -0.109     0.200
    75.668     0.403     0.200
    75.668    -0.801     0.200
    75.680     0.681     0.200
    75.680     0.986     0.200
    75.749     0.982     0.200
    75.758     0.384     0.200
    75.758     0.689     0.200
    75.761     0.973     0.200
    75.824     0.909     0.200
    75.858     0.215     0.200
    75.968     0.086     0.200
    75.993     0.845     0.200
    76.095     0.463     0.200
    76.309     0.647     0.200
    76.397    -0.055     0.200
    76.492     0.613     0.200
    76.534    -0.228     0.200
    76.697     0.348     0.200
    76.782     0.770     0.200
    76.782     0.176     0.200
    76.820     0.556     0.200
    76.832     0.191     0.200
    76.837     0.560     0.200
    76.870     0.273     0.200
    76.905     0.483     0.200
    77.017     0.444     0.200
    77.062    -0.103     0.200
    77.157     0.263     0.200
    77.256     0.708     0.200
    77.310     0.606     0.200
    77.336    -0.040     0.200
    77.349     0.581     0.200
    77.377     0.232     0.200
    77.388     0.068     0.200
    77.422     0.174     0.200
    77.518     0.138     0.200
    77.570     0.151     0.200
    77.644     0.138     0.200
    77.764     0.468     0.200
    77.797     0.185     0.200
    77.810     0.212     0.200
    77.816     0.384     0.200
    77.848     0.501     0.200
    77.913     1.141     0.200
    78.061     0.023     0.200
    78.158     0.575     0.200
    78.193     0.687     0.200
    78.233     0.160     0.200
    78.258     0.127     0.200
    78.268     0.773     0.200
    78.288     0.857     0.200
    78.362     0.755     0.200
    78.398     0.455     0.200
    78.425     0.102     0.200
    78.433     0.964     0.200
    78.516     0.701     0.200
    78.521     0.877     0.200
    78.533     1.209     0.200
    78.582     1.337     0.200
    78.757     1.079     0.200
    78.765     0.637     0.200
    78.901     0.888     0.200
    78.913     1.218     0.200
    78.990     0.635     0.200
    79.048     0.978     0.200
    79.159     1.272     0.200
    79.198     1.057     0.200
    79.205    -1.982     0.200
    79.234     1.661     0.200
    79.248     0.887     0.200
    79.328     0.349     0.200
    79.477     0.604     0.200
    79.481     0.732     0.200
    79.567     0.448     0.200
    79.587     1.438     0.200
    79.600     0.868     0.200
    79.610    -0.186     0.200
    79.654     0.575     0.200
    79.660     1.339     0.200
    79.662     0.827     0.200
    79.680     1.533     0.200
    79.749     0.262     0.200
    79.787     0.457     0.200
    79.840     1.667     0.200
    79.914     1.870     0.200
    80.069     0.326     0.200
    80.115     0.581     0.200
    80.174     0.760     0.200
    80.225     1.485     0.200
    80.409     0.494     0.200
    80.447     1.497     0.200
    80.621     1.318     0.200
    80.695     2.864     0.200
    80.879     0.401     0.200
    80.869     0.330     0.200
    81.080     1.010     0.200
    81.329     0.487     0.200
    81.362     0.411     0.200
    81.387    -0.219     0.200
    81.389     0.974     0.200
    81.479     1.092     0.200
    81.592     0.398     0.200
    81.608     1.611     0.200
    81.629     2.046     0.200
    81.635     1.829     0.200
    81.670     0.680     0.200
    81.734     0.384     0.200
    81.804     0.678     0.200
    81.809     1.549     0.200
    82.288     0.036     0.200
    82.332    -1.487     0.200
    82.510     0.779     0.200
    82.760    -0.524     0.200
    82.795     0.692     0.200
    82.992     0.876     0.200
    83.074    -0.047     0.200
    83.051     0.070     0.200
    83.251     1.637     0.200
    83.322     0.170     0.200
    83.521     1.145     0.200
    83.549     1.004     0.200
    83.735     0.548     0.200
    83.801     0.712     0.200
    83.911     0.765     0.200
    84.086     1.758     0.200
    84.360     0.466     0.200
    84.506     0.127     0.200
    84.605     1.128     0.200
    84.739     0.952     0.200
    84.939     1.446     0.200
    85.157     0.453     0.200
    85.193    -0.326     0.200
    85.635     1.900     0.200
    86.023    -0.054     0.200
    86.874     0.613     0.200
    92.455    -0.342     0.200
    93.515    -0.229     0.200
    95.815    -0.264     0.200
    17.003     1.611     0.200
    18.237    -0.688     0.200
    24.480     0.027     0.200
    24.528     1.223     0.200
    25.139     2.575     0.200
    25.519     2.757     0.200
    26.996     2.759     0.200
    27.413     1.575     0.200
    32.943     2.956     0.200
    33.220     2.645     0.200
    34.694     1.699     0.200
    35.445     2.013     0.200
    36.094     2.403     0.200
    36.732     1.901     0.200
    37.247     1.162     0.200
    38.274     0.453     0.200
    41.428     2.127     0.200
    41.953     0.190     0.200
    43.867     1.106     0.200
    44.945     0.399     0.200
    44.944     0.803     0.200
    46.238    -2.015     0.200
    46.522     0.248     0.200
    47.242    -0.164     0.200
    47.690     1.071     0.200
    47.690     1.260     0.200
    49.651    -0.504     0.200
    49.802    -0.037     0.200
    53.999    -0.315     0.200
    63.059    -0.727     0.200
    63.177     0.090     0.200
    63.737    -1.007     0.200
    63.738    -0.117     0.200
    64.076    -0.536     0.200
    64.076    -0.536     0.200
    64.277     0.348     0.200
    64.718    -0.634     0.200
    68.349     0.794     0.200
    69.309    -0.669     0.200
    70.286     1.125     0.200
    73.880    -0.066     0.200
    74.352     0.988     0.200
    75.407     0.898     0.200
    75.991     0.561     0.200
    76.369     0.512     0.200
    79.391     1.141     0.200
    79.798     1.352     0.200
    79.861     1.470     0.200
    80.183     1.073     0.200
    80.261     1.032     0.200
    80.306     0.853     0.200
    80.421     1.314     0.200
    80.418     1.030     0.200
    80.635     0.428     0.200
    80.768     0.537     0.200
    80.832     0.155     0.200
    80.925     0.969     0.200
    80.987     0.909     0.200
    80.989     0.818     0.200
    81.138     0.388     0.200
    81.320    -0.180     0.200
    83.546     0.866     0.200
    84.209     1.188     0.200
    16.782     2.491     0.200
    18.292    -0.645     0.200
    24.356     0.212     0.200
    34.537     2.721     0.200
    38.024    -0.335     0.200
    46.473    -0.002     0.200
    47.268     0.977     0.200
    47.268     2.366     0.200
    54.443     0.465     0.200
    55.969    -0.465     0.200
    59.305    -0.629     0.200
    64.062    -0.210     0.200
    64.222     0.818     0.200
    64.348    -0.009     0.200
    64.348     0.341     0.200
    76.354     0.632     0.200
    76.645     0.486     0.200
    80.284     1.331     0.200
    80.347     1.693     0.200
    80.793     1.043     0.200
    81.385     1.032     0.200
    83.716     1.440     0.200
    85.153     1.385     0.200
    17.030     0.366     0.200
    18.401    -1.316     0.200
    24.561    -0.028     0.200
    32.642    -0.046     0.200
    44.094    -0.258     0.200
    45.035     1.171     0.200
    45.035     0.906     0.200
    55.898    -1.648     0.200
    63.308    -1.217     0.200
    63.986    -1.361     0.200
    64.314    -0.733     0.200
    64.314    -0.659     0.200
    76.608     0.014     0.200
    80.004     0.960     0.200
    80.066     1.402     0.200
    80.390     0.860     0.200
    80.464     0.779     0.200
    80.514     0.810     0.200
    80.513     0.817     0.200
    80.625     0.941     0.200
    80.632     1.361     0.200
    80.852     0.388     0.200
    80.982     0.433     0.200
    81.050    -0.006     0.200
    81.082     0.752     0.200
    81.197     0.711     0.200
    81.356     0.109     0.200
    83.754     0.965     0.200
    16.825     1.882     0.200
    18.338    -1.560     0.200
    20.558     1.236     0.200
    24.223     2.101     0.200
    24.401    -0.272     0.200
    26.668     1.676     0.200
    27.088     1.997     0.200
    31.266     1.601     0.200
    32.359     2.401     0.200
    32.556     2.352     0.200
    34.568     0.932     0.200
    37.572     2.576     0.200
    37.836     0.539     0.200
    38.065     0.395     0.200
    45.308     1.324     0.200
    46.175     0.628     0.200
    46.513    -1.407     0.200
    47.293     2.131     0.200
    47.293     1.988     0.200
    47.683    -0.033     0.200
    49.759    -0.445     0.200
    50.023     1.321     0.200
    51.512    -0.226     0.200
    53.351     0.148     0.200
    54.437    -0.167     0.200
    55.316     0.784     0.200
    56.003    -0.787     0.200
    57.230    -0.269     0.200
    59.148    -0.677     0.200
    59.313    -1.739     0.200
    63.418    -0.971     0.200
    63.628     0.046     0.200
    64.215     0.486     0.200
    64.386    -0.236     0.200
    64.386    -0.011     0.200
    64.860    -0.661     0.200
    66.293     0.216     0.200
    68.680     0.682     0.200
    68.805     0.855     0.200
    72.510     0.956     0.200
    74.192     0.087     0.200
    74.667     0.927     0.200
    74.763     0.167     0.200
    74.782     0.458     0.200
    75.574     0.898     0.200
    76.242     1.094     0.200
    76.317     0.267     0.200
    76.392     1.242     0.200
    76.683    -0.583     0.200
    76.691    -0.152     0.200
    77.009    -0.246     0.200
    77.244    -0.361     0.200
    77.480    -0.183     0.200
    77.625     0.205     0.200
    77.644    -0.097     0.200
    77.893     1.016     0.200
    78.093    -0.193     0.200
    78.430     1.239     0.200
    79.051     0.729     0.200
    80.279     1.182     0.200
    80.341     1.506     0.200
    80.788     0.892     0.200
    80.904     1.251     0.200
    81.120     0.420     0.200
    81.189     0.797     0.200
    81.252     0.338     0.200
    81.318     0.293     0.200
    81.368     0.592     0.200
    81.470     0.706     0.200
    81.624     0.474     0.200
    83.759     1.093     0.200
    85.183     1.068     0.200
    96.310     0.295     0.200
    24.211    -0.003     0.200
    26.886     1.590     0.200
    31.069     2.686     0.200
    34.122     2.506     0.200
    34.369     2.800     0.200
    34.375     1.456     0.200
    37.378     2.133     0.200
    44.558    -1.802     0.200
    45.504     1.055     0.200
    46.422    -0.387     0.200
    47.105     2.116     0.200
    49.573    -0.216     0.200
    50.807     1.141     0.200
    55.958    -0.411     0.200
    59.395     0.977     0.200
    63.376    -0.813     0.200
    64.054    -0.329     0.200
    64.316    -0.101     0.200
    64.316    -0.851     0.200
    64.354     0.049     0.200
    66.402     0.795     0.200
    73.324     1.239     0.200
    74.710     0.545     0.200
    75.508     0.344     0.200
    76.323     0.896     0.200
    76.614    -0.452     0.200
    78.361     1.288     0.200
    78.984     0.759     0.200
    80.411     0.984     0.200
    80.474     1.424     0.200
    80.917     0.693     0.200
    81.031     1.147     0.200
    81.240     0.377     0.200
    81.376     0.416     0.200
    81.436     0.656     0.200
    81.537     0.814     0.200
    81.597     0.644     0.200
    81.742     0.379     0.200
    83.645     1.035     0.200
    85.164     1.845     0.200
    18.485    -2.656     0.200
    24.599     0.952     0.200
    32.565     3.662     0.200
    32.770     3.017     0.200
    38.283     1.125     0.200
    41.959     1.233     0.200
    46.593    -1.626     0.200
    47.505     3.189     0.200
    56.031    -1.761     0.200
    64.120    -1.305     0.200
    64.441    -1.106     0.200
    64.441    -0.505     0.200
    64.810    -0.866     0.200
    75.552    -0.293     0.200
    75.866    -0.089     0.200
    76.445     0.320     0.200
    76.735     0.307     0.200
    77.558    -0.043     0.200
    77.714     0.288     0.200
    77.723     0.039     0.200
    77.973    -0.151     0.200
    78.101     0.337     0.200
    78.231     0.517     0.200
    78.332    -0.040     0.200
    79.102     0.526     0.200
    80.371     0.844     0.200
    81.233     0.237     0.200
    81.281     0.981     0.200
    81.173     1.506     0.200
    18.941    -1.842     0.200
    23.753     0.951     0.200
    25.062     0.921     0.200
    25.070     0.749     0.200
    26.360    -0.336     0.200
    31.209     2.659     0.200
    31.827     2.628     0.200
    32.007     1.770     0.200
    32.839     2.956     0.200
    33.721    -1.615     0.200
    35.146     0.767     0.200
    35.701    -1.115     0.200
    36.316     2.956     0.200
    37.324     0.587     0.200
    38.724     0.053     0.200
    40.096    -0.019     0.200
    40.524    -0.170     0.200
    42.363     1.125     0.200
    42.575     2.382     0.200
    44.442    -1.215     0.200
    44.623    -1.370     0.200
    44.757     0.868     0.200
    44.758     0.661     0.200
    46.976    -0.638     0.200
    46.882    -0.280     0.200
    47.264    -0.090     0.200
    47.804     2.509     0.200
    49.597     0.139     0.200
    50.135     0.740     0.200
    50.135     1.139     0.200
    50.422    -0.205     0.200
    52.137     0.386     0.200
    54.203     0.202     0.200
    54.900     0.834     0.200
    54.920     1.460     0.200
    56.336    -1.165     0.200
    59.090    -1.637     0.200
    59.238     0.217     0.200
    63.234     0.077     0.200
    63.741    -0.674     0.200
    63.922     0.134     0.200
    64.419    -0.823     0.200
    64.788    -0.332     0.200
    64.788    -0.309     0.200
    64.851     0.053     0.200
    64.971    -0.427     0.200
    65.404    -1.037     0.200
    65.936    -0.416     0.200
    66.119     0.450     0.200
    67.816    -1.041     0.200
    68.425     0.633     0.200
    69.955    -0.748     0.200
    70.298     1.153     0.200
    71.770     0.756     0.200
    71.951    -0.660     0.200
    72.673     0.796     0.200
    75.061     0.742     0.200
    75.153     0.512     0.200
    75.191    -0.304     0.200
    75.216     0.346     0.200
    75.802     0.292     0.200
    75.965     0.260     0.200
    76.347     0.483     0.200
    76.695     0.620     0.200
    76.789     0.587     0.200
    77.079     0.406     0.200
    77.128     0.279     0.200
    77.453     0.156     0.200
    77.684    -0.730     0.200
    77.939     0.047     0.200
    78.094     1.082     0.200
    78.105     0.768     0.200
    78.105     0.430     0.200
    78.108    -0.394     0.200
    78.355    -0.059     0.200
    78.456     0.583     0.200
    78.490     0.890     0.200
    78.553    -0.046     0.200
    78.565     0.884     0.200
    78.585     0.773     0.200
    78.719     0.437     0.200
    78.730     0.875     0.200
    78.830     1.324     0.200
    78.953    -0.153     0.200
    79.443     0.769     0.200
    79.588     0.880     0.200
    79.976     0.578     0.200
    80.019     0.450     0.200
    80.015     1.265     0.200
    80.152     0.823     0.200
    80.470     0.418     0.200
    80.405     0.960     0.200
    80.465     0.942     0.200
    80.526     0.912     0.200
    80.535     0.669     0.200
    80.743     0.651     0.200
    80.640     1.105     0.200
    80.661     1.192     0.200
    80.935     0.829     0.200
    80.950     0.492     0.200
    80.950     0.953     0.200
    81.585     0.775     0.200
    83.235     1.758     0.200
    85.465     0.336     0.200
    85.407     2.095     0.200
    86.215     0.945     0.200
    92.449    -0.685     0.200
    92.286    -0.196     0.200
    95.639     0.808     0.200
    18.281    -1.521     0.200
    24.377    -0.167     0.200
    30.803     2.022     0.200
    31.306     1.690     0.200
    32.415     2.062     0.200
    34.168     1.965     0.200
    34.360     1.703     0.200
    34.572     2.124     0.200
    34.604     1.625     0.200
    34.613     2.288     0.200
    35.117     2.019     0.200
    35.852     2.185     0.200
    36.400     2.152     0.200
    37.752     1.548     0.200
    38.068     0.391     0.200
    38.187     1.519     0.200
    38.619     1.810     0.200
    41.622     2.379     0.200
    41.626     1.347     0.200
    41.744     0.220     0.200
    42.096     1.932     0.200
    45.267     1.773     0.200
    45.268     1.619     0.200
    46.211     0.674     0.200
    47.343     1.419     0.200
    47.343     1.584     0.200
    47.619    -0.835     0.200
    48.711     0.344     0.200
    49.359    -0.349     0.200
    49.728    -0.572     0.200
    51.533    -0.198     0.200
    52.218    -0.116     0.200
    54.356    -0.053     0.200
    55.912    -0.117     0.200
    64.004     0.136     0.200
    64.136     0.872     0.200
    64.300    -0.005     0.200
    64.300     0.396     0.200
    65.958     0.086     0.200
    66.140     0.722     0.200
    66.205     0.445     0.200
    71.767     1.177     0.200
    76.305     1.482     0.200
    76.596     0.934     0.200
    81.303     1.335     0.200
    92.971     0.488     0.200
    17.304     1.251     0.200
    17.304     1.151     0.200
    18.716    -1.721     0.200
    20.425     0.637     0.200
    23.683     2.042     0.200
    23.702     1.793     0.200
    23.820    -0.381     0.200
    24.584     1.305     0.200
    24.854    -0.268     0.200
    24.862     0.668     0.200
    24.908     2.344     0.200
    24.922     2.020     0.200
    25.200    -0.860     0.200
    26.177    -1.417     0.200
    26.189     2.579     0.200
    26.358     0.052     0.200
    27.121     2.433     0.200
    27.552     2.396     0.200
    30.139     1.821     0.200
    30.338     2.178     0.200
    30.493     1.671     0.200
    31.143     1.938     0.200
    31.426     2.156     0.200
    31.715     2.184     0.200
    31.878    -0.477     0.200
    31.857     2.321     0.200
    31.885     0.563     0.200
    32.124    -0.729     0.200
    32.157     0.834     0.200
    32.709     0.635     0.200
    32.936     1.543     0.200
    33.073     2.342     0.200
    33.137     0.167     0.200
    33.655    -0.147     0.200
    33.762     1.913     0.200
    34.047     2.450     0.200
    34.155     1.919     0.200
    34.249     1.986     0.200
    34.575     2.180     0.200
    34.620     2.482     0.200
    34.753     1.997     0.200
    34.976     0.299     0.200
    34.965     1.905     0.200
    35.025     1.766     0.200
    35.282     2.482     0.200
    35.338     1.688     0.200
    35.508     0.052     0.200
    35.517     2.120     0.200
    35.660    -0.939     0.200
    35.820     2.129     0.200
    37.250     1.439     0.200
    38.150     2.557     0.200
    38.547     0.219     0.200
    38.547     0.789     0.200
    38.585     1.394     0.200
    39.021     2.039     0.200
    40.079    -0.005     0.200
    40.560     0.112     0.200
    40.635     1.376     0.200
    41.422     1.758     0.200
    42.005     2.091     0.200
    42.015     1.780     0.200
    42.222     0.056     0.200
    42.270     2.707     0.200
    43.272     0.853     0.200
    44.494    -1.158     0.200
    44.584    -0.780     0.200
    44.863     1.273     0.200
    44.864     1.069     0.200
    44.864     1.289     0.200
    44.864     1.389     0.200
    45.198     1.378     0.200
    46.017    -0.819     0.200
    46.630     1.015     0.200
    46.763    -0.406     0.200
    46.891    -0.388     0.200
    46.891    -0.074     0.200
    47.309     0.631     0.200
    47.717     1.071     0.200
    47.717     1.291     0.200
    48.690    -0.663     0.200
    48.870     0.366     0.200
    49.107     0.158     0.200
    49.428     1.593     0.200
    49.428     1.592     0.200
    49.645     1.143     0.200
    49.794     0.720     0.200
    50.085    -0.207     0.200
    50.208    -0.217     0.200
    50.208     0.513     0.200
    50.611    -0.133     0.200
    51.538     0.800     0.200
    51.808    -0.477     0.200
    51.861    -0.532     0.200
    51.987    -0.910     0.200
    52.947    -0.235     0.200
    53.721    -1.176     0.200
    53.987    -0.078     0.200
    53.991    -0.296     0.200
    54.154     0.405     0.200
    54.154     0.635     0.200
    54.173     0.396     0.200
    54.272    -1.346     0.200
    54.299     0.075     0.200
    54.296    -0.942     0.200
    54.372    -0.254     0.200
    54.507    -0.604     0.200
    54.685     0.512     0.200
    54.852    -0.285     0.200
    54.936     0.353     0.200
    54.956     0.463     0.200
    54.983    -0.293     0.200
    55.407    -0.203     0.200
    56.133     0.001     0.200
    56.148    -1.115     0.200
    56.148    -1.816     0.200
    56.379     0.087     0.200
    56.432    -1.097     0.200
    56.722    -1.220     0.200
    56.828     0.099     0.200
    57.157     0.273     0.200
    57.341     0.373     0.200
    57.341    -0.827     0.200
    57.568     0.763     0.200
    57.816     1.130     0.200
    58.524     0.252     0.200
    58.613     1.251     0.200
    58.635     1.599     0.200
    59.005    -1.074     0.200
    59.158     0.366     0.200
    59.555    -1.794     0.200
    62.865    -0.459     0.200
    62.910     0.505     0.200
    63.268     0.922     0.200
    63.555    -0.870     0.200
    63.657    -0.779     0.200
    63.917     0.640     0.200
    63.996     0.324     0.200
    63.995     0.231     0.200
    63.995     0.021     0.200
    64.109    -0.441     0.200
    64.233    -0.653     0.200
    64.412     0.590     0.200
    64.586    -0.542     0.200
    64.586    -0.322     0.200
    64.744     0.322     0.200
    64.744     0.002     0.200
    64.766    -0.620     0.200
    64.774     0.129     0.200
    64.837    -0.883     0.200
    64.837    -0.663     0.200
    64.837    -0.383     0.200
    64.856     0.133     0.200
    64.883     0.009     0.200
    64.986     0.077     0.200
    65.216    -0.346     0.200
    65.220    -0.234     0.200
    65.698     0.336     0.200
    65.895    -0.040     0.200
    65.895     0.270     0.200
    65.869    -0.364     0.200
    65.828     0.526     0.200
    66.073     0.825     0.200
    67.485    -0.134     0.200
    67.657    -0.663     0.200
    67.766     0.152     0.200
    67.953     0.413     0.200
    68.010     0.296     0.200
    68.369     0.021     0.200
    68.455     1.028     0.200
    68.957     0.595     0.200
    68.957    -0.105     0.200
    69.055     0.489     0.200
    69.056    -0.621     0.200
    69.777    -0.173     0.200
    69.786    -1.129     0.200
    69.786    -0.959     0.200
    69.990     0.011     0.200
    70.252     0.209     0.200
    70.300     1.415     0.200
    70.347     1.030     0.200
    70.420     0.079     0.200
    70.648    -0.208     0.200
    71.093    -0.514     0.200
    71.762    -0.654     0.200
    72.136     0.205     0.200
    72.351     1.522     0.200
    72.351     1.262     0.200
    72.800    -1.951     0.200
    73.307    -0.951     0.200
    73.352     0.163     0.200
    73.575     0.471     0.200
    73.560     0.556     0.200
    74.390     0.005     0.200
    74.471     0.232     0.200
    74.405     2.315     0.200
    74.860     0.377     0.200
    74.956     0.524     0.200
    74.988     0.441     0.200
    75.005    -0.162     0.200
    75.024    -0.469     0.200
    75.212     0.647     0.200
    75.439     0.743     0.200
    75.609     0.269     0.200
    75.680     0.463     0.200
    75.730    -0.624     0.200
    75.742     0.507     0.200
    75.765     0.474     0.200
    75.765     0.274     0.200
    75.917     1.005     0.200
    75.917     1.005     0.200
    75.932    -0.181     0.200
    75.988     0.504     0.200
    75.943     2.458     0.200
    76.158     0.633     0.200
    76.169    -0.228     0.200
    76.398     0.671     0.200
    76.467     0.979     0.200
    76.588     0.996     0.200
    76.630    -0.242     0.200
    76.878     0.657     0.200
    76.925     0.592     0.200
    76.991     0.721     0.200
    77.085     0.593     0.200
    77.105     0.581     0.200
    77.243    -0.295     0.200
    77.346     0.632     0.200
    77.465     0.466     0.200
    77.475    -0.494     0.200
    77.511     0.405     0.200
    77.618     1.306     0.200
    77.660     0.175     0.200
    77.610    -0.394     0.200
    77.727    -0.300     0.200
    77.866     0.425     0.200
    77.894     0.472     0.200
    77.893    -0.024     0.200
    77.935     0.741     0.200
    78.024     0.652     0.200
    78.039     0.668     0.200
    78.060     0.451     0.200
    78.143    -0.512     0.200
    78.204     0.850     0.200
    78.251     0.589     0.200
    78.203    -0.001     0.200
    78.287     0.893     0.200
    78.315    -0.363     0.200
    78.341    -0.505     0.200
    78.362     1.078     0.200
    78.381     1.070     0.200
    78.436     0.768     0.200
    78.451     0.886     0.200
    78.463     1.018     0.200
    78.511    -0.448     0.200
    78.520     0.806     0.200
    78.531     1.142     0.200
    78.544     0.974     0.200
    78.602     0.152     0.200
    78.611     1.004     0.200
    78.629     1.405     0.200
    78.635     0.969     0.200
    78.694     0.843     0.200
    78.738     1.306     0.200
    78.846     0.908     0.200
    78.922     1.591     0.200
    78.948     0.751     0.200
    78.975     1.302     0.200
    78.983     1.056     0.200
    79.004     1.343     0.200
    78.961     0.081     0.200
    79.073     1.337     0.200
    79.113     1.348     0.200
    79.130     0.654     0.200
    79.219     1.165     0.200
    79.243     1.036     0.200
    79.247     1.615     0.200
    79.301    -0.132     0.200
    79.322     1.703     0.200
    79.387    -0.552     0.200
    79.417     1.849     0.200
    79.567     0.669     0.200
    79.575     0.097     0.200
    79.645    -0.052     0.200
    79.669     1.016     0.200
    79.707     0.178     0.200
    79.727     0.899     0.200
    79.747     0.893     0.200
    79.767     1.083     0.200
    79.766     0.691     0.200
    79.829    -0.253     0.200
    79.867     0.344     0.200
    79.867     0.853     0.200
    79.867     0.743     0.200
    79.886     0.641     0.200
    79.925     1.125     0.200
    79.923    -0.159     0.200
    80.000     1.521     0.200
    80.082    -0.019     0.200
    80.180     0.549     0.200
    80.196     0.566     0.200
    80.198    -0.049     0.200
    80.202     2.050     0.200
    80.260     0.221     0.200
    80.331     0.739     0.200
    80.336    -1.388     0.200
    80.369     0.334     0.200
    80.389     1.028     0.200
    80.521     0.416     0.200
    80.521     0.206     0.200
    80.533     0.950     0.200
    80.510     0.973     0.200
    80.516     0.942     0.200
    80.624     1.266     0.200
    80.638     1.387     0.200
    80.669    -0.180     0.200
    80.781     2.123     0.200
    80.786     1.197     0.200
    80.868     0.460     0.200
    80.880     0.296     0.200
    80.994     0.688     0.200
    81.059    -1.568     0.200
    80.995     1.013     0.200
    80.995     0.983     0.200
    81.124     1.535     0.200
    81.162     0.690     0.200
    81.197    -0.036     0.200
    81.203     1.522     0.200
    81.227     2.134     0.200
    81.231     0.686     0.200
    81.284     1.146     0.200
    81.299     1.566     0.200
    81.316     0.273     0.200
    81.317     1.166     0.200
    81.338     0.659     0.200
    81.392     1.074     0.200
    81.408    -0.015     0.200
    81.416     0.944     0.200
    81.450    -0.133     0.200
    81.463    -0.706     0.200
    81.464     0.491     0.200
    81.476     1.228     0.200
    81.491     0.158     0.200
    81.546     2.219     0.200
    81.563     1.367     0.200
    81.649     2.233     0.200
    81.682     1.539     0.200
    81.723     1.704     0.200
    81.745     1.966     0.200
    81.794     1.550     0.200
    81.812     0.752     0.200
    81.825    -0.098     0.200
    81.844     1.083     0.200
    81.855     0.027     0.200
    81.966     1.043     0.200
    81.983     1.126     0.200
    82.012     0.759     0.200
    82.033     1.290     0.200
    82.033     1.429     0.200
    82.127     1.198     0.200
    82.296     1.310     0.200
    82.426     0.663     0.200
    82.426    -2.309     0.200
    82.502     1.018     0.200
    82.672     1.352     0.200
    82.714     2.033     0.200
    82.722    -0.949     0.200
    82.884     0.048     0.200
    82.928     0.112     0.200
    82.958    -0.675     0.200
    82.991     0.376     0.200
    83.018    -0.066     0.200
    83.181    -0.389     0.200
    83.282     0.383     0.200
    83.347     1.139     0.200
    83.322    -1.114     0.200
    83.382    -0.782     0.200
    83.401    -0.032     0.200
    83.477     1.379     0.200
    83.536     0.924     0.200
    83.534     0.195     0.200
    83.547    -0.552     0.200
    83.653     1.182     0.200
    83.678     1.158     0.200
    83.790     1.284     0.200
    83.841     1.021     0.200
    83.867     0.346     0.200
    84.007     0.472     0.200
    84.030     0.759     0.200
    84.032     2.249     0.200
    84.056     0.444     0.200
    84.056     0.963     0.200
    84.056     0.814     0.200
    84.160     1.493     0.200
    84.166     1.066     0.200
    84.277     1.720     0.200
    84.468     1.034     0.200
    84.533     0.703     0.200
    84.565     0.513     0.200
    84.564     1.566     0.200
    84.624     0.963     0.200
    84.639     0.428     0.200
    84.710     0.610     0.200
    84.890     1.104     0.200
    85.013     0.368     0.200
    85.168     0.809     0.200
    85.308     0.980     0.200
    85.318     0.478     0.200
    85.388     0.881     0.200
    85.314     1.031     0.200
    85.513     1.189     0.200
    85.555     0.318     0.200
    85.614     0.296     0.200
    85.638     0.428     0.200
    85.782     0.719     0.200
    85.792     1.901     0.200
    85.792     1.671     0.200
    85.891     2.410     0.200
    86.054     0.377     0.200
    86.162     1.270     0.200
    86.260     0.317     0.200
    86.389     0.455     0.200
    86.476    -0.181     0.200
    86.665     0.340     0.200
    86.886     1.021     0.200
    87.125     0.854     0.200
    87.175    -0.885     0.200
    87.023     0.951     0.200
    87.023     1.400     0.200
    87.023     0.701     0.200
    87.366     0.389     0.200
    87.935    -0.438     0.200
    88.617     0.239     0.200
    89.051    -1.304     0.200
    89.286    -0.405     0.200
    89.837     0.416     0.200
    90.314    -0.210     0.200
    90.392    -0.073     0.200
    91.279     0.215     0.200
    91.700     0.592     0.200
    92.433    -0.035     0.200
    92.484     0.255     0.200
    93.656    -0.674     0.200
    94.572    -2.114     0.200
    95.440     0.549     0.200
    95.841     0.221     0.200
    95.843     0.313     0.200
    17.277     1.621     0.200
    17.277     2.582     0.200
    18.839    -1.921     0.200
    18.839    -0.976     0.200
    24.882     0.104     0.200
    24.890     0.256     0.200
    27.431     1.547     0.200
    30.374     1.175     0.200
    31.310     0.512     0.200
    31.570     1.964     0.200
    31.752     1.837     0.200
    32.266    -0.353     0.200
    32.580     1.947     0.200
    33.891    -0.966     0.200
    34.594     2.684     0.200
    34.891     1.480     0.200
    34.891     1.627     0.200
    40.488    -0.072     0.200
    41.854     1.074     0.200
    46.493     0.480     0.200
    47.544     1.393     0.200
    47.544     1.604     0.200
    54.401     0.153     0.200
    56.386    -0.131     0.200
    63.795    -0.764     0.200
    64.160     1.036     0.200
    64.473    -0.393     0.200
    64.806    -0.086     0.200
    64.806    -0.066     0.200
    65.016    -0.346     0.200
    65.492    -0.242     0.200
    66.136    -0.288     0.200
    77.100     0.575     0.200
    81.205     0.464     0.200
    16.435     3.284     0.200
    18.275    -1.529     0.200
    18.275    -1.123     0.200
    23.855     0.900     0.200
    23.855     1.079     0.200
    24.492     0.829     0.200
    25.038    -0.270     0.200
    35.479    -1.328     0.200
    37.486     0.429     0.200
    38.266     0.873     0.200
    40.528    -0.439     0.200
    44.981     0.496     0.200
    44.981     0.496     0.200
    44.981     0.293     0.200
    46.309    -1.189     0.200
    46.605    -0.299     0.200
    47.296     0.001     0.200
    47.647     1.691     0.200
    54.008     0.339     0.200
    54.358    -0.207     0.200
    55.454    -1.417     0.200
    55.718    -1.638     0.200
    62.080    -0.815     0.200
    63.128    -0.997     0.200
    63.233     0.704     0.200
    63.805    -0.824     0.200
    63.802     0.448     0.200
    64.140    -0.670     0.200
    64.140    -0.521     0.200
    64.438    -0.658     0.200
    64.441    -0.738     0.200
    64.487    -0.838     0.200
    64.337     1.143     0.200
    65.635    -0.457     0.200
    65.817    -0.629     0.200
    69.381    -0.524     0.200
    70.339     0.990     0.200
    71.187     0.645     0.200
    73.278     0.861     0.200
    73.536     0.842     0.200
    74.378    -0.875     0.200
    74.416     0.303     0.200
    74.541     0.580     0.200
    74.783     0.679     0.200
    75.274     0.154     0.200
    75.287     0.579     0.200
    75.322     0.575     0.200
    75.470     0.530     0.200
    75.589     0.043     0.200
    75.829     1.775     0.200
    75.829     1.673     0.200
    76.100     1.129     0.200
    76.143     0.885     0.200
    76.434     0.340     0.200
    76.434     0.254     0.200
    76.469     0.540     0.200
    77.273     0.217     0.200
    77.437     0.597     0.200
    77.439     0.394     0.200
    77.689     0.194     0.200
    77.887     0.195     0.200
    78.051     0.185     0.200
    78.150     0.136     0.200
    78.356     0.596     0.200
    79.189     0.627     0.200
    79.295     0.550     0.200
    79.315     0.635     0.200
    79.488     0.693     0.200
    79.807    -0.130     0.200
    80.081     0.787     0.200
    80.249     0.883     0.200
    80.372     0.323     0.200
    80.373     0.719     0.200
    80.488     1.202     0.200
    80.484     1.020     0.200
    80.709     0.212     0.200
    80.953     0.513     0.200
    80.998     0.479     0.200
    81.008     0.521     0.200
    81.054     0.478     0.200
    80.979     0.876     0.200
    82.434     0.612     0.200
    83.599     1.174     0.200
    84.894     0.578     0.200
    85.671     1.141     0.200
    16.949     2.095     0.200
    16.949     1.642     0.200
    18.440    -0.977     0.200
    24.123     0.972     0.200
    24.123     0.519     0.200
    24.522    -0.330     0.200
    31.379     2.016     0.200
    32.460     2.955     0.200
    32.664     2.188     0.200
    33.704    -1.752     0.200
    34.425     2.422     0.200
    34.684     1.652     0.200
    34.658     2.421     0.200
    35.841    -1.505     0.200
    36.467     2.268     0.200
    37.729     0.076     0.200
    37.820     2.972     0.200
    38.255     2.279     0.200
    44.765    -1.855     0.200
    45.196     1.318     0.200
    46.290     1.108     0.200
    46.835     0.031     0.200
    47.591    -0.479     0.200
    49.929     1.362     0.200
    54.366    -0.309     0.200
    56.047    -2.156     0.200
    63.539     0.251     0.200
    64.025    -0.349     0.200
    64.138    -0.734     0.200
    64.108    -0.387     0.200
    64.108    -0.567     0.200
    64.143     0.481     0.200
    64.444    -0.490     0.200
    64.444    -0.161     0.200
    64.662     0.587     0.200
    64.817     0.035     0.200
    64.820    -0.326     0.200
    64.861    -0.711     0.200
    66.009    -0.362     0.200
    68.719     1.010     0.200
    69.732    -0.961     0.200
    70.631     0.932     0.200
    72.068     1.037     0.200
    72.475     1.097     0.200
    72.681     1.578     0.200
    72.716     1.135     0.200
    73.208     1.455     0.200
    74.249     0.372     0.200
    74.719    -0.733     0.200
    74.723     0.823     0.200
    74.832    -0.213     0.200
    74.842     0.434     0.200
    75.091     0.290     0.200
    75.156     0.517     0.200
    75.296     0.519     0.200
    75.321     0.569     0.200
    75.538    -0.576     0.200
    75.733     0.106     0.200
    75.770     0.805     0.200
    75.770     0.805     0.200
    75.852    -0.369     0.200
    75.867     0.649     0.200
    76.055     0.176     0.200
    76.449     0.737     0.200
    76.458    -1.316     0.200
    76.740     0.156     0.200
    76.757    -0.205     0.200
    76.762     1.368     0.200
    77.076    -0.301     0.200
    77.218     0.506     0.200
    77.310    -0.315     0.200
    77.493     0.660     0.200
    77.550    -0.353     0.200
    77.700     0.104     0.200
    77.714    -0.370     0.200
    77.964    -0.555     0.200
    78.133     0.097     0.200
    78.163    -0.465     0.200
    78.399     0.930     0.200
    78.433     0.043     0.200
    79.107     0.338     0.200
    79.188     0.903     0.200
    79.328     0.084     0.200
    79.354     0.220     0.200
    79.453     0.048     0.200
    79.579     0.763     0.200
    79.599     0.652     0.200
    79.643    -0.185     0.200
    79.853     0.775     0.200
    79.853    -0.280     0.200
    80.022    -0.037     0.200
    80.088     0.107     0.200
    80.136     0.576     0.200
    80.365     1.013     0.200
    80.678     0.233     0.200
    80.599     0.759     0.200
    80.700     0.118     0.200
    80.723     0.592     0.200
    80.722     0.703     0.200
    80.834     1.003     0.200
    81.221     0.143     0.200
    81.266     0.806     0.200
    81.269     0.289     0.200
    81.283    -0.086     0.200
    81.276     0.800     0.200
    81.407     0.761     0.200
    83.184     1.563     0.200
    83.841     1.428     0.200
    85.247     0.130     0.200
    92.833     0.132     0.200
    96.187     0.326     0.200
    18.557    -1.299     0.200
    20.648     0.094     0.200
    20.648    -1.258     0.200
    24.162     0.736     0.200
    24.603     0.355     0.200
    24.673     0.479     0.200
    24.673    -0.122     0.200
    33.827    -1.529     0.200
    36.028     2.181     0.200
    37.756     0.635     0.200
    45.210    -0.140     0.200
    45.210     1.059     0.200
    47.372     2.112     0.200
    50.554     0.819     0.200
    50.554     0.814     0.200
    54.459    -0.279     0.200
    54.792     0.120     0.200
    64.158    -0.238     0.200
    64.224    -0.475     0.200
    64.585    -0.532     0.200
    64.585    -0.430     0.200
    64.942    -0.760     0.200
    64.945    -0.579     0.200
    64.994    -1.102     0.200
    65.025    -0.602     0.200
    65.417    -0.248     0.200
    66.119    -1.071     0.200
    66.119    -0.970     0.200
    66.119    -1.169     0.200
    71.251    -0.369     0.200
    72.589     0.997     0.200
    74.390     0.099     0.200
    74.861    -0.633     0.200
    74.861    -1.172     0.200
    76.880     0.339     0.200
    79.991    -0.236     0.200
    80.176     0.564     0.200
    81.329     0.348     0.200
    83.974     0.443     0.200
    85.387     0.261     0.200
    92.766    -0.010     0.200
    96.116     0.302     0.200
    18.312    -1.462     0.200
    18.312    -1.798     0.200
    24.795     0.740     0.200
    24.795     0.334     0.200
    45.372     0.558     0.200
    50.686     0.613     0.200
    50.686     0.612     0.200
    54.830    -0.056     0.200
    56.015    -1.282     0.200
    57.228     3.195     0.200
    59.343    -0.500     0.200
    62.399    -1.659     0.200
    63.431    -0.816     0.200
    64.108    -0.733     0.200
    64.292     0.467     0.200
    64.390    -0.726     0.200
    64.390    -0.328     0.200
    64.875    -0.680     0.200
    66.098    -0.618     0.200
    74.699    -0.854     0.200
    76.687     0.190     0.200
    81.430     0.433     0.200
    83.748     0.435     0.200
    93.006    -0.461     0.200
    16.155     3.633     0.200
    24.075    -0.406     0.200
    24.880     0.255     0.200
    26.856     1.498     0.200
    47.121     2.981     0.200
    47.802     0.159     0.200
    51.256    -0.745     0.200
    54.804    -0.273     0.200
    59.229    -0.670     0.200
    59.787    -1.058     0.200
    63.851    -1.122     0.200
    64.063    -0.403     0.200
    64.172    -1.120     0.200
    64.724    -1.198     0.200
    66.000    -0.447     0.200
    66.275     1.326     0.200
    70.377    -0.960     0.200
    70.993    -0.318     0.200
    74.037     0.739     0.200
    74.450    -1.596     0.200
    76.410    -0.827     0.200
    79.907     1.190     0.200
    80.307     1.438     0.200
    80.372     1.489     0.200
    80.472     1.050     0.200
    80.690     1.074     0.200
    80.775     0.927     0.200
    80.810     0.933     0.200
    80.815     0.908     0.200
    80.816     0.802     0.200
    80.922     1.440     0.200
    80.925     1.125     0.200
    81.488     0.529     0.200
    81.484     0.657     0.200
    83.447     0.735     0.200
    85.006     0.170     0.200
    16.525     3.145     0.200
    24.042    -0.908     0.200
    24.042    -0.119     0.200
    24.777     0.891     0.200
    25.318    -0.931     0.200
    25.601     1.476     0.200
    26.497     1.467     0.200
    26.537     1.790     0.200
    26.815     0.533     0.200
    26.918     1.506     0.200
    27.266     1.497     0.200
    27.415     2.707     0.200
    28.044     2.344     0.200
    28.096     1.448     0.200
    28.471     1.165     0.200
    28.816     1.444     0.200
    28.909     1.313     0.200
    29.430     1.893     0.200
    29.507     1.460     0.200
    30.417     2.055     0.200
    31.138     1.650     0.200
    31.138     2.058     0.200
    31.255     0.923     0.200
    31.275     1.471     0.200
    31.356     0.818     0.200
    31.488     1.228     0.200
    31.436     1.171     0.200
    31.628     1.846     0.200
    31.811     1.645     0.200
    31.842     1.151     0.200
    32.217     1.295     0.200
    32.312     1.627     0.200
    32.312     1.009     0.200
    32.416     1.217     0.200
    32.451     1.615     0.200
    32.463     2.150     0.200
    32.663     1.821     0.200
    32.682     1.629     0.200
    32.838     3.092     0.200
    32.838     2.529     0.200
    32.918     1.612     0.200
    32.929     2.029     0.200
    33.013     1.782     0.200
    33.124     1.930     0.200
    33.158     0.293     0.200
    33.193     1.838     0.200
    33.165     0.607     0.200
    33.197     1.928     0.200
    33.346     1.316     0.200
    33.317     2.356     0.200
    33.460    -1.967     0.200
    33.460    -0.936     0.200
    33.586     2.045     0.200
    33.715     1.137     0.200
    33.704     1.353     0.200
    33.761     1.267     0.200
    33.745     1.869     0.200
    33.852     2.571     0.200
    33.859     2.270     0.200
    33.893     1.717     0.200
    33.893     1.274     0.200
    33.964     1.056     0.200
    33.962     1.579     0.200
    34.025     0.689     0.200
    34.058     2.456     0.200
    34.211     1.706     0.200
    34.211     1.504     0.200
    34.211     1.709     0.200
    34.261     1.253     0.200
    34.293     1.165     0.200
    34.300     0.467     0.200
    34.400     1.621     0.200
    34.419     0.696     0.200
    34.419     1.104     0.200
    34.463     1.754     0.200
    34.511     1.660     0.200
    34.509     1.831     0.200
    34.513     2.314     0.200
    34.725     1.564     0.200
    34.803     1.245     0.200
    34.830     1.668     0.200
    34.902     1.439     0.200
    35.015     1.173     0.200
    35.075     0.999     0.200
    35.101     1.460     0.200
    35.272     1.033     0.200
    35.328     1.323     0.200
    35.395     1.986     0.200
    35.395     2.492     0.200
    35.489     1.367     0.200
    35.489     1.575     0.200
    35.689     1.151     0.200
    35.698     2.214     0.200
    35.706     2.002     0.200
    35.717     2.225     0.200
    35.786     1.100     0.200
    35.809     0.894     0.200
    35.828     0.563     0.200
    36.077     0.807     0.200
    36.248     1.974     0.200
    36.399     2.203     0.200
    36.388     2.078     0.200
    36.410     1.827     0.200
    36.677     0.714     0.200
    36.678     2.043     0.200
    36.685     1.464     0.200
    36.697     1.014     0.200
    36.750     0.993     0.200
    36.871     1.253     0.200
    36.871     0.747     0.200
    36.844     1.194     0.200
    36.844     1.809     0.200
    36.985     0.432     0.200
    37.046     0.882     0.200
    37.039     2.258     0.200
    37.105     1.668     0.200
    37.190     0.772     0.200
    37.159     0.834     0.200
    37.167     1.829     0.200
    37.408     1.966     0.200
    37.459     1.736     0.200
    37.460     1.542     0.200
    37.551     0.819     0.200
    37.608     1.761     0.200
    37.692     1.331     0.200
    37.780     1.135     0.200
    37.826     1.028     0.200
    37.806     1.189     0.200
    37.913     0.473     0.200
    37.962     0.165     0.200
    38.032     1.540     0.200
    38.155     1.864     0.200
    38.162     1.988     0.200
    38.276     1.940     0.200
    38.345     1.157     0.200
    38.458     0.932     0.200
    38.511     2.086     0.200
    38.617     0.854     0.200
    38.699     2.197     0.200
    38.712     1.788     0.200
    38.758     2.027     0.200
    38.881     0.232     0.200
    38.915     0.781     0.200
    38.961     2.190     0.200
    39.035     2.222     0.200
    39.148     1.258     0.200
    39.253     1.652     0.200
    39.306     0.674     0.200
    39.625     1.812     0.200
    39.705     1.291     0.200
    39.716     1.081     0.200
    39.831     0.641     0.200
    39.795     1.885     0.200
    40.065     2.018     0.200
    40.102     0.864     0.200
    40.102     1.559     0.200
    40.173     1.303     0.200
    40.235     1.871     0.200
    40.296     1.345     0.200
    40.393     1.192     0.200
    40.482     1.520     0.200
    40.531     1.774     0.200
    40.591     1.291     0.200
    40.600     1.508     0.200
    40.649     1.963     0.200
    40.847     1.515     0.200
    40.858     1.222     0.200
    40.963     1.892     0.200
    41.066     1.870     0.200
    41.241     1.563     0.200
    41.270     1.351     0.200
    41.502     1.529     0.200
    41.602     1.949     0.200
    41.621     1.374     0.200
    41.821     1.058     0.200
    41.855     1.127     0.200
    41.890     1.861     0.200
    41.896     1.437     0.200
    41.956     1.538     0.200
    42.403     1.625     0.200
    42.427     1.689     0.200
    42.418     1.923     0.200
    42.442     1.839     0.200
    42.485     1.489     0.200
    42.485     1.882     0.200
    42.507     2.146     0.200
    42.706     1.119     0.200
    42.745     0.553     0.200
    42.799     1.932     0.200
    42.958     1.986     0.200
    43.117     0.792     0.200
    43.194     0.710     0.200
    43.225     1.275     0.200
    43.277     1.323     0.200
    43.273     1.839     0.200
    43.684     1.383     0.200
    44.106     1.154     0.200
    44.106     1.296     0.200
    44.129     1.081     0.200
    44.466     1.413     0.200
    44.541     1.564     0.200
    44.599     1.702     0.200
    44.741     0.999     0.200
    44.877     1.478     0.200
    44.897     1.531     0.200
    44.943     1.806     0.200
    45.001     1.385     0.200
    45.372     1.592     0.200
    45.436     0.872     0.200
    45.434     0.070     0.200
    45.433     1.673     0.200
    46.425     1.468     0.200
    46.561     1.288     0.200
    46.660     0.697     0.200
    46.725     0.991     0.200
    46.784     1.001     0.200
    46.913     0.393     0.200
    47.081     1.007     0.200
    47.214     0.653     0.200
    47.215     1.077     0.200
    47.252     0.837     0.200
    47.282     1.346     0.200
    47.440     0.881     0.200
    47.492     0.217     0.200
    47.511     0.131     0.200
    47.507     0.424     0.200
    47.541     0.947     0.200
    47.582     0.484     0.200
    47.934     0.128     0.200
    47.925     0.591     0.200
    47.944     0.899     0.200
    48.266     0.481     0.200
    48.366     0.927     0.200
    48.556     0.753     0.200
    48.743    -0.305     0.200
    48.759     0.583     0.200
    48.914     0.104     0.200
    49.185     1.041     0.200
    50.111     1.140     0.200
    50.412     1.981     0.200
    51.300    -0.251     0.200
    51.563    -0.719     0.200
    54.648     1.063     0.200
    54.660     0.962     0.200
    55.342    -1.363     0.200
    55.280     1.585     0.200
    55.601    -0.626     0.200
    58.908    -1.389     0.200
    59.066     0.118     0.200
    59.066     0.618     0.200
    60.268    -0.961     0.200
    61.893    -1.383     0.200
    61.992    -1.947     0.200
    63.696    -0.790     0.200
    63.608     0.591     0.200
    63.899    -0.228     0.200
    63.967    -0.373     0.200
    63.967    -0.373     0.200
    64.120     0.224     0.200
    64.538    -0.714     0.200
    64.538    -0.406     0.200
    64.560     0.036     0.200
    65.840    -0.465     0.200
    65.840    -0.724     0.200
    65.840    -0.164     0.200
    65.856    -0.647     0.200
    69.327    -1.786     0.200
    70.210    -0.018     0.200
    70.826    -0.879     0.200
    70.826    -0.010     0.200
    72.283     1.442     0.200
    72.283     1.301     0.200
    73.265     0.114     0.200
    73.265    -0.187     0.200
    73.773    -0.276     0.200
    74.249     0.560     0.200
    74.292    -1.009     0.200
    74.300    -0.655     0.200
    74.300    -1.405     0.200
    74.303    -0.852     0.200
    74.318    -0.842     0.200
    74.335    -0.362     0.200
    74.337    -0.791     0.200
    74.357    -0.288     0.200
    74.853     0.734     0.200
    75.033     0.298     0.200
    75.345    -0.403     0.200
    75.606     0.401     0.200
    75.963     0.565     0.200
    75.973    -0.096     0.200
    75.978     0.075     0.200
    76.147     2.417     0.200
    76.255    -0.398     0.200
    76.264    -0.252     0.200
    76.266    -0.358     0.200
    76.583    -0.358     0.200
    76.818    -0.584     0.200
    77.051    -0.399     0.200
    77.194    -0.100     0.200
    77.215    -0.316     0.200
    77.262     1.026     0.200
    77.464    -0.510     0.200
    77.557     0.567     0.200
    77.560     0.350     0.200
    77.632    -0.353     0.200
    77.664    -0.628     0.200
    77.733     1.059     0.200
    77.917     1.005     0.200
    78.011     1.227     0.200
    78.097     0.670     0.200
    78.284     1.444     0.200
    78.483     0.874     0.200
    78.633     0.870     0.200
    78.948     0.070     0.200
    79.675    -0.097     0.200
    79.825     1.287     0.200
    79.844     0.283     0.200
    79.765     1.011     0.200
    79.871     0.137     0.200
    80.162     1.164     0.200
    80.228     1.512     0.200
    80.545     1.404     0.200
    80.632     0.741     0.200
    80.664     0.666     0.200
    80.670     0.936     0.200
    80.671     0.730     0.200
    80.791    -0.210     0.200
    80.774     1.279     0.200
    80.780     1.449     0.200
    81.341     0.658     0.200
    81.366     0.937     0.200
    81.366     1.128     0.200
    81.388     0.752     0.200
    83.312     1.207     0.200
    83.326     0.135     0.200
    83.625     0.449     0.200
    84.815     1.592     0.200
    84.844     0.033     0.200
    84.845     0.653     0.200
    86.028     1.153     0.200
    89.029     0.900     0.200
    89.844     0.293     0.200
    16.402     2.863     0.200
    17.563     1.997     0.200
    17.563     2.149     0.200
    20.386     0.611     0.200
    20.386     0.261     0.200
    23.622    -0.263     0.200
    23.916     2.147     0.200
    24.136     0.268     0.200
    24.550     2.585     0.200
    25.092    -1.269     0.200
    25.116     0.311     0.200
    25.127     2.363     0.200
    25.311     2.614     0.200
    25.485     1.715     0.200
    25.822     1.777     0.200
    26.160     1.552     0.200
    26.229     2.393     0.200
    26.251     2.599     0.200
    26.423     2.109     0.200
    26.660     2.240     0.200
    26.752     2.505     0.200
    26.940     2.060     0.200
    27.076     2.702     0.200
    27.145     2.066     0.200
    27.352     2.128     0.200
    27.349     2.590     0.200
    27.355     2.135     0.200
    27.446     2.233     0.200
    27.467     2.334     0.200
    27.556     2.155     0.200
    27.654     1.957     0.200
    27.800     1.298     0.200
    27.792     2.070     0.200
    27.792     1.355     0.200
    28.094     2.176     0.200
    28.134     2.040     0.200
    28.226     2.679     0.200
    28.239     1.852     0.200
    28.289     2.343     0.200
    28.665     1.563     0.200
    28.720     2.649     0.200
    28.746     1.986     0.200
    28.922     2.208     0.200
    29.082     2.803     0.200
    29.099     2.739     0.200
    29.108     2.814     0.200
    29.267     1.874     0.200
    29.356     2.259     0.200
    29.521     2.434     0.200
    29.531     2.982     0.200
    29.702     2.121     0.200
    29.800     2.065     0.200
    29.870     2.436     0.200
    29.989     1.976     0.200
    30.165     2.199     0.200
    30.379     1.412     0.200
    30.379     1.677     0.200
    30.421     1.742     0.200
    30.535     2.274     0.200
    30.734     1.530     0.200
    31.206     2.370     0.200
    31.225     1.645     0.200
    31.668     1.684     0.200
    31.792     1.170     0.200
    31.944     1.459     0.200
    31.944     2.126     0.200
    31.964     2.081     0.200
    32.052     2.265     0.200
    32.120     1.751     0.200
    32.178     0.916     0.200
    32.178     1.326     0.200
    32.333    -1.095     0.200
    32.258     2.264     0.200
    32.298     0.831     0.200
    32.269     3.046     0.200
    32.350     2.152     0.200
    32.422     0.612     0.200
    32.734     1.763     0.200
    32.789     1.043     0.200
    32.959     0.940     0.200
    32.946     2.215     0.200
    32.969     2.839     0.200
    33.133     1.157     0.200
    33.207     2.859     0.200
    33.215     1.936     0.200
    33.303     0.867     0.200
    33.310     2.375     0.200
    33.346     1.340     0.200
    33.396     1.111     0.200
    33.396     0.412     0.200
    33.428     1.687     0.200
    33.450     3.038     0.200
    33.593    -1.410     0.200
    33.593    -1.690     0.200
    33.512     1.943     0.200
    33.539     0.644     0.200
    33.568     1.552     0.200
    33.601     1.744     0.200
    33.696     2.468     0.200
    33.776     2.693     0.200
    33.813     1.459     0.200
    33.806     2.847     0.200
    33.875     0.945     0.200
    33.878     2.476     0.200
    33.924     1.642     0.200
    33.917     2.132     0.200
    33.974     1.990     0.200
    33.962     1.178     0.200
    34.010     2.766     0.200
    34.063     1.542     0.200
    34.140     2.431     0.200
    34.144     2.562     0.200
    34.186     0.727     0.200
    34.209     1.839     0.200
    34.272     0.821     0.200
    34.303     1.299     0.200
    34.339     1.894     0.200
    34.379     2.521     0.200
    34.480     0.900     0.200
    34.462     1.634     0.200
    34.512     0.598     0.200
    34.543     0.620     0.200
    34.496     2.500     0.200
    34.594     1.202     0.200
    34.588     2.103     0.200
    34.588     2.273     0.200
    34.673     0.800     0.200
    34.694     1.279     0.200
    34.828     1.537     0.200
    34.812     2.426     0.200
    34.812     2.117     0.200
    34.884     1.004     0.200
    34.912     0.961     0.200
    34.872     2.405     0.200
    34.993     0.989     0.200
    34.974     2.325     0.200
    34.974     2.009     0.200
    34.999     1.785     0.200
    35.006     1.609     0.200
    35.120     0.767     0.200
    35.087     2.174     0.200
    35.142     1.224     0.200
    35.175     0.785     0.200
    35.154     1.256     0.200
    35.168     2.758     0.200
    35.168     2.073     0.200
    35.217     1.176     0.200
    35.203     1.803     0.200
    35.239     0.119     0.200
    35.253     1.201     0.200
    35.260     1.766     0.200
    35.274     1.471     0.200
    35.383     1.750     0.200
    35.409     0.844     0.200
    35.482     0.254     0.200
    35.482     0.934     0.200
    35.391     2.458     0.200
    35.562    -1.630     0.200
    35.562    -0.860     0.200
    35.487     1.077     0.200
    35.432     1.927     0.200
    35.491     1.561     0.200
    35.508     1.505     0.200
    35.553     1.270     0.200
    35.616     1.052     0.200
    35.613     2.089     0.200
    35.648     2.126     0.200
    35.708     1.118     0.200
    35.743     2.518     0.200
    35.773     1.576     0.200
    35.765     1.899     0.200
    35.811     0.983     0.200
    35.779     1.616     0.200
    35.933     1.183     0.200
    35.891     1.996     0.200
    35.951     1.347     0.200
    35.915     2.420     0.200
    36.036     1.148     0.200
    36.058     1.011     0.200
    36.016     2.376     0.200
    36.016     1.800     0.200
    36.091     0.729     0.200
    36.112     0.789     0.200
    36.059     2.180     0.200
    36.092     2.529     0.200
    36.103     2.356     0.200
    36.141     1.250     0.200
    36.239     0.957     0.200
    36.210     2.319     0.200
    36.215     2.326     0.200
    36.279     1.066     0.200
    36.328     1.410     0.200
    36.305     2.387     0.200
    36.373     1.309     0.200
    36.336     1.820     0.200
    36.416     0.890     0.200
    36.417     2.723     0.200
    36.422     2.248     0.200
    36.439     2.880     0.200
    36.530     0.632     0.200
    36.497     2.223     0.200
    36.643     1.068     0.200
    36.654     1.085     0.200
    36.624     1.426     0.200
    36.664     0.957     0.200
    36.687     0.901     0.200
    36.728     0.662     0.200
    36.704     1.976     0.200
    36.741     1.989     0.200
    36.812     1.029     0.200
    36.898     0.759     0.200
    36.937     1.343     0.200
    36.987     0.445     0.200
    37.050     0.819     0.200
    37.097     0.349     0.200
    37.040     1.395     0.200
    37.100     0.745     0.200
    37.100     1.103     0.200
    37.198     0.191     0.200
    37.142     2.255     0.200
    37.196     0.660     0.200
    37.207     1.167     0.200
    37.222     1.647     0.200
    37.292     0.869     0.200
    37.372     0.844     0.200
    37.431     1.191     0.200
    37.553    -0.807     0.200
    37.416     2.317     0.200
    37.471     0.736     0.200
    37.441     1.446     0.200
    37.441     2.356     0.200
    37.536     2.011     0.200
    37.560     1.448     0.200
    37.612     1.034     0.200
    37.667     0.809     0.200
    37.656     1.124     0.200
    37.613     2.544     0.200
    37.678     0.777     0.200
    37.645     1.967     0.200
    37.683     1.430     0.200
    37.683     1.556     0.200
    37.732     0.875     0.200
    37.769     0.885     0.200
    37.790     1.042     0.200
    37.793     1.213     0.200
    37.847     0.956     0.200
    37.786     2.020     0.200
    37.811     2.031     0.200
    37.834     1.301     0.200
    37.866     1.178     0.200
    37.828     2.167     0.200
    37.892     1.066     0.200
    37.911     1.356     0.200
    37.977     1.685     0.200
    38.046     1.240     0.200
    38.046     1.851     0.200
    37.993     2.637     0.200
    38.051     0.671     0.200
    38.090     1.001     0.200
    38.152     1.135     0.200
    38.152     0.535     0.200
    38.127     1.059     0.200
    38.144     0.837     0.200
    38.175     0.651     0.200
    38.231     0.724     0.200
    38.252     2.215     0.200
    38.298     1.572     0.200
    38.303     1.138     0.200
    38.304     1.905     0.200
    38.389     1.031     0.200
    38.426     0.671     0.200
    38.403     0.955     0.200
    38.481     0.478     0.200
    38.436     2.011     0.200
    38.500     1.121     0.200
    38.537     1.670     0.200
    38.537     1.967     0.200
    38.656     1.481     0.200
    38.667     0.762     0.200
    38.699     0.823     0.200
    38.744     0.674     0.200
    38.757     0.585     0.200
    38.804     0.608     0.200
    38.775     1.398     0.200
    38.775     1.560     0.200
    38.832     0.749     0.200
    38.810     1.620     0.200
    38.826     0.852     0.200
    38.886     0.786     0.200
    38.896     1.035     0.200
    38.993    -0.824     0.200
    38.900     1.517     0.200
    38.936     0.620     0.200
    38.991     1.949     0.200
    38.979     2.157     0.200
    38.979     2.653     0.200
    39.014     0.607     0.200
    39.063     0.837     0.200
    39.063     1.181     0.200
    39.048     1.552     0.200
    39.196     0.403     0.200
    39.166     1.933     0.200
    39.200     1.133     0.200
    39.296     1.197     0.200
    39.353     0.909     0.200
    39.384     0.621     0.200
    39.382     0.968     0.200
    39.436     2.176     0.200
    39.436     1.957     0.200
    39.484     0.510     0.200
    39.477     1.331     0.200
    39.477     1.686     0.200
    39.517     0.188     0.200
    39.555     0.781     0.200
    39.542     0.802     0.200
    39.558     0.571     0.200
    39.582     2.110     0.200
    39.585     2.147     0.200
    39.618     1.958     0.200
    39.672     1.351     0.200
    39.720     2.214     0.200
    39.807     1.159     0.200
    39.956    -0.652     0.200
    39.865     0.720     0.200
    39.879     0.471     0.200
    39.879     0.123     0.200
    39.867     0.936     0.200
    39.898     0.727     0.200
    39.895     1.511     0.200
    40.034     0.451     0.200
    40.055     0.537     0.200
    40.087     1.732     0.200
    40.104     1.883     0.200
    40.166     1.192     0.200
    40.207     1.003     0.200
    40.229     1.088     0.200
    40.209     1.733     0.200
    40.209     2.183     0.200
    40.255     1.854     0.200
    40.384     0.620     0.200
    40.384     1.354     0.200
    40.374     1.794     0.200
    40.435     0.288     0.200
    40.467     2.038     0.200
    40.491     1.472     0.200
    40.501     2.143     0.200
    40.580     1.291     0.200
    40.598     1.700     0.200
    40.631     1.118     0.200
    40.758     0.813     0.200
    40.729     2.145     0.200
    40.729     1.994     0.200
    40.767     1.142     0.200
    40.784     1.142     0.200
    40.784     0.739     0.200
    40.815     1.323     0.200
    40.880     0.599     0.200
    40.916     1.631     0.200
    40.975     0.784     0.200
    41.011     0.822     0.200
    41.092     0.849     0.200
    41.103     1.672     0.200
    41.235     0.639     0.200
    41.234     1.419     0.200
    41.245     0.572     0.200
    41.305     1.734     0.200
    41.367     0.856     0.200
    41.463     0.799     0.200
    41.486     0.389     0.200
    41.544     1.392     0.200
    41.625     1.786     0.200
    41.682     0.723     0.200
    41.691     0.950     0.200
    41.697     1.009     0.200
    41.697     2.347     0.200
    41.835     0.949     0.200
    41.851     0.719     0.200
    41.912     1.417     0.200
    42.002     0.581     0.200
    42.031     0.639     0.200
    42.080     1.175     0.200
    42.128     0.852     0.200
    42.153    -0.298     0.200
    42.153    -0.040     0.200
    42.134     0.985     0.200
    42.223     2.232     0.200
    42.235     1.198     0.200
    42.300     0.516     0.200
    42.296     0.793     0.200
    42.365     1.011     0.200
    42.427     0.609     0.200
    42.426     0.835     0.200
    42.479    -0.042     0.200
    42.487     2.694     0.200
    42.582     2.541     0.200
    42.583     1.917     0.200
    42.619     0.763     0.200
    42.648     0.167     0.200
    42.736     0.981     0.200
    42.736     0.707     0.200
    42.732     1.268     0.200
    42.738     1.077     0.200
    42.811     1.181     0.200
    42.869     0.460     0.200
    42.956     0.734     0.200
    42.952     0.611     0.200
    43.068     0.520     0.200
    43.074     1.299     0.200
    43.122     0.922     0.200
    43.220    -0.479     0.200
    43.176     1.281     0.200
    43.200     1.087     0.200
    43.190     1.410     0.200
    43.190     1.990     0.200
    43.252     0.618     0.200
    43.267     1.207     0.200
    43.330     0.523     0.200
    43.386    -0.114     0.200
    43.386     0.557     0.200
    43.406    -0.326     0.200
    43.509     0.648     0.200
    43.552     0.089     0.200
    43.584     0.270     0.200
    43.637    -0.036     0.200
    43.710     0.875     0.200
    43.721     0.678     0.200
    43.782     0.929     0.200
    43.949    -0.363     0.200
    43.877     0.749     0.200
    43.986     0.683     0.200
    44.079     0.242     0.200
    44.144     0.783     0.200
    44.307    -0.732     0.200
    44.307    -0.551     0.200
    44.217     0.713     0.200
    44.239     0.531     0.200
    44.285     0.564     0.200
    44.485    -1.448     0.200
    44.371     0.400     0.200
    44.462     0.591     0.200
    44.470     0.379     0.200
    44.496     0.465     0.200
    44.498     0.560     0.200
    44.525     0.563     0.200
    44.638     0.727     0.200
    44.638     0.508     0.200
    44.638     0.627     0.200
    44.637     0.931     0.200
    44.705     0.500     0.200
    44.727     0.196     0.200
    44.878    -0.034     0.200
    44.870     0.381     0.200
    44.920     0.546     0.200
    45.022     0.597     0.200
    45.033     0.479     0.200
    45.067     0.808     0.200
    45.067     2.081     0.200
    45.075     0.771     0.200
    45.088     0.469     0.200
    45.103     0.667     0.200
    45.137     0.047     0.200
    45.137     0.556     0.200
    45.190     1.360     0.200
    45.190     2.074     0.200
    45.244     1.004     0.200
    45.343     0.293     0.200
    45.364     0.707     0.200
    45.424     0.631     0.200
    45.503     0.754     0.200
    45.520     0.822     0.200
    45.592     0.638     0.200
    45.788     0.010     0.200
    45.785     0.172     0.200
    45.795     0.738     0.200
    45.846     0.679     0.200
    45.870     0.732     0.200
    46.023     0.673     0.200
    46.073     0.108     0.200
    46.203     0.770     0.200
    46.207     0.708     0.200
    46.271    -1.006     0.200
    46.239     0.762     0.200
    46.235     0.586     0.200
    46.261     0.110     0.200
    46.299    -0.198     0.200
    46.321     0.338     0.200
    46.396     0.270     0.200
    46.407     0.213     0.200
    46.635     0.140     0.200
    46.534    -0.631     0.200
    46.508     0.615     0.200
    46.522     0.625     0.200
    46.547     0.430     0.200
    46.561     0.685     0.200
    46.743    -0.603     0.200
    46.743    -0.343     0.200
    46.655    -0.039     0.200
    46.696    -0.715     0.200
    46.838    -0.451     0.200
    46.838     0.089     0.200
    46.756     0.559     0.200
    46.922    -0.409     0.200
    46.792     0.501     0.200
    46.834    -0.004     0.200
    46.834     0.679     0.200
    46.864     0.250     0.200
    46.996     0.281     0.200
    47.129     0.681     0.200
    47.074     0.216     0.200
    47.073     1.341     0.200
    47.103     0.284     0.200
    47.103     0.680     0.200
    47.112     0.781     0.200
    47.250     0.831     0.200
    47.250     0.271     0.200
    47.166     0.096     0.200
    47.281    -0.023     0.200
    47.323     1.124     0.200
    47.393     0.880     0.200
    47.470     0.377     0.200
    47.471     0.195     0.200
    47.514     0.071     0.200
    47.538     0.576     0.200
    47.787    -0.063     0.200
    47.787     0.353     0.200
    47.851     0.604     0.200
    47.864     0.486     0.200
    47.864     0.905     0.200
    47.902     0.296     0.200
    47.930     1.629     0.200
    47.968     0.794     0.200
    48.131     0.098     0.200
    48.013     0.476     0.200
    48.005     0.672     0.200
    48.073     0.612     0.200
    48.257     0.229     0.200
    48.257     0.119     0.200
    48.247     1.029     0.200
    48.183     1.083     0.200
    48.269     0.516     0.200
    48.300     0.463     0.200
    48.359     0.088     0.200
    48.393     0.029     0.200
    48.679     0.555     0.200
    48.705     0.185     0.200
    48.712     0.252     0.200
    48.736     0.494     0.200
    48.754    -0.003     0.200
    48.814     0.562     0.200
    49.057     1.131     0.200
    49.045     0.339     0.200
    49.119    -0.600     0.200
    49.203     1.462     0.200
    49.181     0.989     0.200
    49.181     0.989     0.200
    49.128    -0.094     0.200
    49.226     1.780     0.200
    49.192     0.346     0.200
    49.190     0.163     0.200
    49.217     0.044     0.200
    49.331     0.685     0.200
    49.331     0.361     0.200
    49.462     0.684     0.200
    49.501     1.853     0.200
    49.613     1.674     0.200
    49.529     0.135     0.200
    49.544    -0.050     0.200
    49.599     0.574     0.200
    49.599     0.751     0.200
    49.620     0.636     0.200
    49.668     0.074     0.200
    49.775     1.469     0.200
    49.718    -0.045     0.200
    49.718    -0.196     0.200
    49.815     1.909     0.200
    49.936     1.230     0.200
    50.006     0.993     0.200
    50.006     1.043     0.200
    49.980     0.541     0.200
    50.034     0.331     0.200
    50.057     0.664     0.200
    50.078     0.234     0.200
    50.131     0.861     0.200
    50.154     0.238     0.200
    50.342     1.686     0.200
    50.379     1.388     0.200
    50.337     0.234     0.200
    50.335    -0.618     0.200
    50.458    -0.032     0.200
    50.395     0.588     0.200
    50.403     0.272     0.200
    50.437     0.094     0.200
    50.448    -0.099     0.200
    50.498    -0.034     0.200
    50.528     0.216     0.200
    50.554     0.149     0.200
    50.654     1.646     0.200
    50.588    -0.392     0.200
    50.695     1.652     0.200
    50.695     0.813     0.200
    50.709     1.156     0.200
    50.805     1.815     0.200
    50.864    -0.639     0.200
    50.858     0.863     0.200
    50.873    -0.000     0.200
    50.930     0.940     0.200
    50.954     0.873     0.200
    51.046     0.889     0.200
    50.965     0.935     0.200
    51.047    -0.429     0.200
    51.167     1.090     0.200
    51.214     0.597     0.200
    51.226     0.544     0.200
    51.318     1.217     0.200
    51.264     0.661     0.200
    51.313     0.046     0.200
    51.323    -0.141     0.200
    51.320     0.979     0.200
    51.399     1.601     0.200
    51.523    -0.338     0.200
    51.619     1.463     0.200
    51.644    -0.486     0.200
    51.661     0.522     0.200
    51.695     0.264     0.200
    51.806     0.826     0.200
    52.038     1.673     0.200
    52.117    -0.654     0.200
    52.099     0.745     0.200
    52.332    -1.012     0.200
    52.236     0.001     0.200
    52.463    -0.297     0.200
    52.542     0.328     0.200
    52.474    -0.665     0.200
    52.700    -0.270     0.200
    53.000     0.248     0.200
    53.000    -0.252     0.200
    53.000     0.573     0.200
    53.000     0.068     0.200
    52.967     1.067     0.200
    53.339     0.780     0.200
    53.610    -0.758     0.200
    54.027     0.212     0.200
    54.027     0.560     0.200
    54.027    -0.138     0.200
    54.064     0.245     0.200
    54.200     0.052     0.200
    54.245     0.630     0.200
    54.367     0.634     0.200
    54.483     0.191     0.200
    54.554    -0.276     0.200
    54.629    -0.521     0.200
    54.764     0.555     0.200
    54.783     0.416     0.200
    54.765    -0.085     0.200
    54.885    -0.421     0.200
    54.943    -0.395     0.200
    54.928    -1.263     0.200
    55.662    -0.019     0.200
    55.848    -0.666     0.200
    55.985    -1.438     0.200
    55.884    -0.411     0.200
    56.064    -1.002     0.200
    56.250    -0.898     0.200
    56.253    -1.103     0.200
    56.260     0.841     0.200
    56.669     0.590     0.200
    56.635     0.177     0.200
    56.659    -0.039     0.200
    56.637    -0.413     0.200
    56.637    -0.858     0.200
    56.682    -1.406     0.200
    56.724    -0.807     0.200
    56.972     0.240     0.200
    57.205     0.588     0.200
    57.429    -1.090     0.200
    57.429    -0.790     0.200
    57.429    -1.240     0.200
    57.473     0.721     0.200
    57.659     0.390     0.200
    57.738     0.934     0.200
    57.840     0.020     0.200
    57.931    -0.438     0.200
    58.058    -0.155     0.200
    58.058    -0.609     0.200
    58.408     1.145     0.200
    58.776    -0.432     0.200
    58.958    -1.285     0.200
    59.088    -0.160     0.200
    59.036     0.773     0.200
    60.817    -1.358     0.200
    62.342    -0.941     0.200
    62.367    -0.411     0.200
    62.591    -1.904     0.200
    62.717     0.252     0.200
    63.005    -0.814     0.200
    63.097     0.328     0.200
    63.391     0.259     0.200
    63.782     0.198     0.200
    63.946     0.715     0.200
    63.946     0.315     0.200
    63.946     0.065     0.200
    64.009     0.106     0.200
    64.060    -0.064     0.200
    64.164     1.883     0.200
    64.258     1.069     0.200
    64.334    -0.680     0.200
    64.545     0.692     0.200
    64.667     0.223     0.200
    64.721     0.045     0.200
    64.719    -0.144     0.200
    64.719     0.224     0.200
    64.724     0.522     0.200
    64.724     0.022     0.200
    64.855    -1.028     0.200
    64.855    -0.528     0.200
    64.855    -0.798     0.200
    65.002    -0.956     0.200
    65.646     1.090     0.200
    65.789     0.019     0.200
    65.799     1.253     0.200
    65.800    -0.552     0.200
    65.800    -0.004     0.200
    65.981     0.883     0.200
    66.032     0.157     0.200
    66.032    -0.043     0.200
    66.193    -0.228     0.200
    66.456     0.268     0.200
    66.902     0.255     0.200
    66.911     0.389     0.200
    66.979     0.235     0.200
    67.194     0.306     0.200
    67.209    -0.225     0.200
    67.288    -0.455     0.200
    67.662    -0.250     0.200
    67.950     0.044     0.200
    68.122     0.258     0.200
    68.223     0.450     0.200
    68.288     1.045     0.200
    68.467     0.073     0.200
    68.616     0.193     0.200
    68.701     0.065     0.200
    69.127    -1.482     0.200
    69.124    -0.268     0.200
    69.124     0.032     0.200
    69.124     0.183     0.200
    69.194     0.597     0.200
    69.267     0.159     0.200
    69.352    -0.239     0.200
    69.786     0.546     0.200
    69.858    -0.299     0.200
    69.858    -0.799     0.200
    69.858    -1.249     0.200
    69.847     0.287     0.200
    70.123     1.174     0.200
    70.163     0.930     0.200
    70.466     0.974     0.200
    70.775     0.096     0.200
    70.839     0.017     0.200
    70.929    -0.103     0.200
    71.032    -0.149     0.200
    71.031    -0.231     0.200
    71.072     0.289     0.200
    71.072    -0.021     0.200
    71.359    -0.257     0.200
    71.429     0.310     0.200
    71.490     0.316     0.200
    71.636     1.186     0.200
    71.636     0.956     0.200
    71.749     0.993     0.200
    71.869    -0.615     0.200
    71.869    -0.725     0.200
    71.886     1.198     0.200
    71.896    -0.092     0.200
    71.968     1.071     0.200
    72.079     0.724     0.200
    72.107     1.375     0.200
    72.293     0.442     0.200
    72.293     1.182     0.200
    72.293     1.512     0.200
    72.293     0.882     0.200
    72.388     0.187     0.200
    72.491     1.716     0.200
    72.539     1.047     0.200
    72.539     0.847     0.200
    72.569     0.248     0.200
    72.640     1.658     0.200
    72.663     0.141     0.200
    72.720     0.532     0.200
    72.862    -1.940     0.200
    73.029     1.360     0.200
    73.026     0.614     0.200
    73.142    -1.997     0.200
    73.146     1.040     0.200
    73.157     0.910     0.200
    73.198    -0.431     0.200
    73.299     0.501     0.200
    73.330    -0.007     0.200
    73.330    -0.107     0.200
    73.370    -0.745     0.200
    73.378     0.249     0.200
    73.499     0.059     0.200
    73.598    -0.687     0.200
    74.200     0.989     0.200
    74.443     0.294     0.200
    74.522    -0.683     0.200
    74.522     0.017     0.200
    74.567     0.058     0.200
    74.621     0.269     0.200
    74.533     3.052     0.200
    74.723     0.294     0.200
    74.781     0.316     0.200
    74.692     0.535     0.200
    74.863    -0.257     0.200
    74.886    -0.516     0.200
    74.894    -0.737     0.200
    74.894    -0.957     0.200
    74.907     0.359     0.200
    74.783     3.407     0.200
    74.938     0.810     0.200
    74.990     0.427     0.200
    74.990    -0.393     0.200
    75.080     0.290     0.200
    75.160     0.629     0.200
    75.161     0.312     0.200
    75.355     0.609     0.200
    75.392    -0.005     0.200
    75.410     0.489     0.200
    75.573     0.854     0.200
    75.724     0.195     0.200
    75.724     0.295     0.200
    75.731     0.994     0.200
    75.731     0.453     0.200
    75.809     0.609     0.200
    75.807     1.917     0.200
    75.807     1.717     0.200
    75.861     0.809     0.200
    75.894     0.522     0.200
    75.896     0.009     0.200
    75.917     0.292     0.200
    75.975     0.558     0.200
    76.028     0.158     0.200
    76.037     0.206     0.200
    76.056     0.500     0.200
    76.107     0.508     0.200
    76.104     0.525     0.200
    76.164     0.287     0.200
    76.164     0.687     0.200
    76.213     0.307     0.200
    76.265     0.709     0.200
    76.265     0.909     0.200
    76.265     0.459     0.200
    76.342     0.472     0.200
    76.511     1.216     0.200
    76.522     0.855     0.200
    76.522     0.755     0.200
    76.613     0.441     0.200
    76.621     0.795     0.200
    76.679     0.165     0.200
    76.719     0.338     0.200
    76.719    -0.082     0.200
    76.784     0.476     0.200
    76.794     0.820     0.200
    76.851    -0.007     0.200
    76.974     0.801     0.200
    77.010     0.503     0.200
    77.022     0.732     0.200
    77.068     0.475     0.200
    77.076     0.328     0.200
    77.231     0.362     0.200
    77.231    -0.238     0.200
    77.231    -0.138     0.200
    77.254     0.233     0.200
    77.276    -1.594     0.200
    77.276    -0.794     0.200
    77.394     0.347     0.200
    77.426     1.765     0.200
    77.454     0.713     0.200
    77.750     0.657     0.200
    77.771     0.843     0.200
    77.884     0.311     0.200
    77.773     0.389     0.200
    77.851     0.678     0.200
    77.988     1.134     0.200
    78.026     0.923     0.200
    78.026     1.223     0.200
    78.024     0.638     0.200
    78.051     0.386     0.200
    78.060     0.634     0.200
    78.200     1.561     0.200
    78.097     0.792     0.200
    78.107     1.395     0.200
    78.229     0.718     0.200
    78.246     1.105     0.200
    78.302     0.196     0.200
    78.375     0.197     0.200
    78.390     0.862     0.200
    78.277     0.723     0.200
    78.424     0.819     0.200
    78.465     1.096     0.200
    78.475     0.239     0.200
    78.488     1.265     0.200
    78.499     1.196     0.200
    78.498     0.211     0.200
    78.556     1.094     0.200
    78.584     1.238     0.200
    78.600    -0.751     0.200
    78.658     0.973     0.200
    78.667     0.280     0.200
    78.687     0.871     0.200
    78.691     0.774     0.200
    78.754     0.803     0.200
    78.761     1.494     0.200
    78.779     0.565     0.200
    78.901     1.495     0.200
    79.048     1.589     0.200
    79.057     0.377     0.200
    79.105     0.578     0.200
    79.024     0.503     0.200
    79.156     0.998     0.200
    79.162     0.167     0.200
    79.221     0.242     0.200
    79.218     0.928     0.200
    79.221     0.433     0.200
    79.262     0.758     0.200
    79.347     0.854     0.200
    79.372     0.922     0.200
    79.456     1.659     0.200
    79.463     1.925     0.200
    79.448     1.206     0.200
    79.551     0.142     0.200
    79.626     0.009     0.200
    79.737     0.235     0.200
    79.737     0.535     0.200
    79.811     0.634     0.200
    79.829     1.237     0.200
    79.860     0.367     0.200
    79.880     0.560     0.200
    79.893    -0.613     0.200
    79.875     1.384     0.200
    79.897     1.564     0.200
    79.911     0.594     0.200
    79.911     0.893     0.200
    79.911     1.008     0.200
    79.911     1.194     0.200
    79.918     1.755     0.200
    79.923    -0.072     0.200
    79.950     1.180     0.200
    79.934     1.567     0.200
    79.972    -0.207     0.200
    79.992     0.454     0.200
    80.012     1.044     0.200
    80.087    -0.018     0.200
    80.094     1.003     0.200
    80.148     1.510     0.200
    80.145     0.026     0.200
    80.196     1.353     0.200
    80.277     1.317     0.200
    80.265     1.078     0.200
    80.305     0.564     0.200
    80.326     0.954     0.200
    80.353     1.605     0.200
    80.355     0.597     0.200
    80.374     0.797     0.200
    80.397     0.430     0.200
    80.403     0.737     0.200
    80.386     0.927     0.200
    80.387     0.922     0.200
    80.414     0.279     0.200
    80.395     0.879     0.200
    80.413     0.986     0.200
    80.280     0.237     0.200
    80.431     1.288     0.200
    80.459     0.139     0.200
    80.455     0.948     0.200
    80.461     1.026     0.200
    80.500     0.814     0.200
    80.521     1.505     0.200
    80.494     0.751     0.200
    80.524     0.287     0.200
    80.616     1.096     0.200
    80.684     1.630     0.200
    80.757     0.440     0.200
    80.800     1.208     0.200
    80.825     0.879     0.200
    80.814     0.785     0.200
    80.848     2.423     0.200
    81.039     0.938     0.200
    81.071     0.767     0.200
    81.098     1.027     0.200
    81.085     0.993     0.200
    81.094     0.941     0.200
    81.140     0.709     0.200
    81.156     0.113     0.200
    81.156     0.313     0.200
    81.216     0.971     0.200
    81.208     1.039     0.200
    81.216     0.194     0.200
    81.207     0.542     0.200
    81.284     0.335     0.200
    81.317     1.359     0.200
    81.326    -0.090     0.200
    81.385     0.577     0.200
    81.431    -0.846     0.200
    81.375     0.460     0.200
    81.522     0.382     0.200
    81.561     0.664     0.200
    81.572     0.610     0.200
    81.599     0.565     0.200
    81.632    -0.006     0.200
    81.634     1.179     0.200
    81.662     1.133     0.200
    81.689     1.291     0.200
    81.835     1.342     0.200
    81.830     0.549     0.200
    81.872     1.625     0.200
    81.944     0.748     0.200
    81.935     1.496     0.200
    81.983     1.646     0.200
    82.020     1.151     0.200
    82.042     0.733     0.200
    82.135     0.547     0.200
    82.083    -0.931     0.200
    82.234     1.372     0.200
    82.225     1.374     0.200
    82.476     1.062     0.200
    82.495    -0.338     0.200
    82.504    -0.384     0.200
    82.486     1.110     0.200
    82.861     1.460     0.200
    82.861     0.930     0.200
    82.762     2.063     0.200
    82.812    -0.173     0.200
    83.000     1.138     0.200
    83.030     0.884     0.200
    83.072    -0.370     0.200
    83.215     1.830     0.200
    83.215     1.615     0.200
    83.215     0.999     0.200
    83.257     1.315     0.200
    83.286     0.464     0.200
    83.286    -0.036     0.200
    83.128     0.167     0.200
    83.128    -0.423     0.200
    83.292     0.630     0.200
    83.414     1.005     0.200
    83.437     0.386     0.200
    83.480     1.264     0.200
    83.714     0.765     0.200
    83.828     1.079     0.200
    83.951     0.913     0.200
    83.850     1.136     0.200
    84.003     0.584     0.200
    83.878     2.865     0.200
    84.040     0.699     0.200
    84.129     0.445     0.200
    84.134     1.121     0.200
    84.134     1.021     0.200
    84.146     1.208     0.200
    84.237     0.820     0.200
    84.268     1.138     0.200
    84.268     0.838     0.200
    84.294     0.708     0.200
    84.329     0.830     0.200
    84.211     3.606     0.200
    84.502     0.754     0.200
    84.545     0.534     0.200
    84.574     0.690     0.200
    84.565     0.437     0.200
    84.565     1.137     0.200
    84.630     0.607     0.200
    84.723     0.938     0.200
    84.744     0.331     0.200
    84.851     0.394     0.200
    84.942     1.035     0.200
    85.048     0.606     0.200
    85.108     1.702     0.200
    85.187     1.098     0.200
    85.303     0.027     0.200
    85.309     0.499     0.200
    85.319     0.949     0.200
    85.319     1.449     0.200
    85.319     1.622     0.200
    85.367     0.811     0.200
    85.313    -0.182     0.200
    85.385     1.330     0.200
    85.491    -0.010     0.200
    85.341     1.080     0.200
    85.510     0.295     0.200
    85.608     0.619     0.200
    85.531     0.883     0.200
    85.713     1.989     0.200
    85.794     0.185     0.200
    86.093     0.387     0.200
    86.110     2.021     0.200
    86.027     1.724     0.200
    86.107     1.536     0.200
    86.229     0.435     0.200
    86.274     1.016     0.200
    86.405     0.372     0.200
    86.506    -0.124     0.200
    86.564    -0.209     0.200
    86.675    -0.457     0.200
    86.748     0.137     0.200
    86.792     0.475     0.200
    86.889     0.097     0.200
    86.773     0.467     0.200
    86.883     2.028     0.200
    86.994     0.689     0.200
    87.121    -0.929     0.200
    87.044     1.842     0.200
    87.351     0.157     0.200
    87.480    -0.067     0.200
    87.575     0.080     0.200
    87.575     1.580     0.200
    87.648    -0.563     0.200
    87.747     0.057     0.200
    87.747     0.877     0.200
    87.747     1.027     0.200
    87.856     0.434     0.200
    87.785     0.774     0.200
    87.979     1.422     0.200
    88.234     0.695     0.200
    88.431     1.913     0.200
    88.420     0.867     0.200
    88.601     1.612     0.200
    88.692    -1.620     0.200
    88.670     0.717     0.200
    89.071    -0.221     0.200
    89.372    -0.412     0.200
    89.729     1.918     0.200
    89.831     0.492     0.200
    89.831     0.233     0.200
    90.105    -0.079     0.200
    90.132     0.716     0.200
    90.515     0.889     0.200
    90.717     0.273     0.200
    90.956     0.383     0.200
    91.561     0.896     0.200
    91.860     1.251     0.200
    92.014     0.967     0.200
    92.308     0.109     0.200
    92.309    -1.266     0.200
    92.214    -0.624     0.200
    92.214    -0.224     0.200
    92.214    -0.404     0.200
    92.221    -0.419     0.200
    92.227    -0.061     0.200
    92.684    -0.155     0.200
    93.732     0.059     0.200
    93.796     1.941     0.200
    94.673    -0.947     0.200
    94.807     0.589     0.200
    94.808    -0.778     0.200
    94.761     0.049     0.200
    94.890     0.730     0.200
    94.964     0.412     0.200
    94.964     0.194     0.200
    95.057     1.047     0.200
    95.251    -0.201     0.200
    95.575     0.401     0.200
    95.582     0.320     0.200
    95.584     0.542     0.200
    95.810     0.601     0.200
    95.906     1.754     0.200
    96.065     1.048     0.200
    96.389     0.258     0.200
    96.428     0.442     0.200
    99.058     0.241     0.200
    99.080    -0.554     0.200
    18.728    -0.863     0.200
    23.730     0.943     0.200
    24.241     0.023     0.200
    24.905     0.921     0.200
    25.111    -0.472     0.200
    25.111    -0.644     0.200
    32.856     2.383     0.200
    44.129     0.100     0.200
    44.779     0.813     0.200
    44.778     0.231     0.200
    47.489    -0.520     0.200
    47.805     1.803     0.200
    50.121    -0.523     0.200
    54.401     0.615     0.200
    56.105    -1.335     0.200
    59.059    -0.398     0.200
    63.826     0.628     0.200
    63.926    -0.136     0.200
    64.189    -1.212     0.200
    64.553    -0.449     0.200
    64.553    -0.168     0.200
    64.668    -0.096     0.200
    64.769    -0.755     0.200
    65.551    -0.738     0.200
    65.784    -0.433     0.200
    68.929     0.088     0.200
    69.732    -1.005     0.200
    71.000    -0.504     0.200
    71.926    -1.234     0.200
    72.267     1.221     0.200
    73.028    -2.007     0.200
    73.252    -0.929     0.200
    73.293     0.227     0.200
    73.480    -0.970     0.200
    74.357    -0.005     0.200
    74.749    -0.975     0.200
    74.757    -0.520     0.200
    75.414     0.390     0.200
    75.731     0.477     0.200
    76.006     0.310     0.200
    76.461     0.316     0.200
    76.555     0.792     0.200
    76.845     0.349     0.200
    77.872     2.201     0.200
    77.872     2.100     0.200
    78.048     0.224     0.200
    78.331     0.790     0.200
    78.596     1.054     0.200
    78.674     0.666     0.200
    78.709     0.583     0.200
    78.956     0.513     0.200
    79.055     0.610     0.200
    79.209     0.730     0.200
    79.805     0.486     0.200
    79.989     0.342     0.200
    80.093     0.735     0.200
    80.135     1.010     0.200
    80.154     0.098     0.200
    80.316     0.727     0.200
    80.321     0.007     0.200
    80.352     0.737     0.200
    80.903     0.584     0.200
    81.692     0.099     0.200
    81.959     0.742     0.200
    84.045     0.597     0.200
    85.243     0.654     0.200
    85.999     2.202     0.200
    15.886     1.992     0.200
    16.998     1.238     0.200
    18.273    -1.730     0.200
    18.273    -2.594     0.200
    23.854     1.322     0.200
    23.854     0.262     0.200
    24.360     0.445     0.200
    24.482     0.537     0.200
    24.491     0.262     0.200
    25.036    -1.397     0.200
    26.250     2.557     0.200
    27.384     2.051     0.200
    28.939     1.027     0.200
    30.322    -0.162     0.200
    30.867     1.191     0.200
    31.591     1.925     0.200
    31.841     0.818     0.200
    33.052     2.095     0.200
    33.417     2.232     0.200
    33.625     1.931     0.200
    33.711     0.048     0.200
    35.664     1.692     0.200
    35.729     2.030     0.200
    36.694     2.388     0.200
    37.221     2.018     0.200
    37.326     1.434     0.200
    37.485     0.625     0.200
    38.265     0.582     0.200
    38.472     1.071     0.200
    39.156     2.831     0.200
    39.165    -0.829     0.200
    39.359     0.923     0.200
    41.943    -0.086     0.200
    41.922     0.343     0.200
    42.879     0.525     0.200
    44.981     0.585     0.200
    44.981     0.185     0.200
    44.981     0.384     0.200
    44.980     0.525     0.200
    45.771    -0.227     0.200
    46.306    -1.378     0.200
    46.602    -0.101     0.200
    47.295     0.797     0.200
    47.647     1.985     0.200
    47.872    -0.120     0.200
    49.003     1.128     0.200
    49.623     0.260     0.200
    49.792     0.426     0.200
    49.818     0.258     0.200
    49.870    -0.507     0.200
    50.259     0.282     0.200
    50.259     0.283     0.200
    50.571    -1.023     0.200
    51.775     0.197     0.200
    52.035    -0.258     0.200
    54.006    -1.365     0.200
    54.020     0.833     0.200
    54.020     0.563     0.200
    54.086    -0.135     0.200
    54.368    -0.148     0.200
    54.356     0.367     0.200
    55.567    -0.123     0.200
    55.715    -1.568     0.200
    56.764     2.411     0.200
    58.884     0.096     0.200
    59.267    -0.110     0.200
    61.949    -0.766     0.200
    63.648     0.035     0.200
    63.802    -1.010     0.200
    63.800     0.329     0.200
    64.137    -0.582     0.200
    64.137    -0.532     0.200
    64.335     0.819     0.200
    64.435    -1.234     0.200
    64.438    -0.152     0.200
    64.438    -0.302     0.200
    64.484    -1.153     0.200
    64.484    -0.943     0.200
    65.633    -0.446     0.200
    65.633    -0.481     0.200
    65.633    -0.136     0.200
    66.760    -0.528     0.200
    67.978    -0.529     0.200
    68.405     0.596     0.200
    69.378    -0.943     0.200
    69.621     0.054     0.200
    70.138    -1.020     0.200
    70.338     0.859     0.200
    70.741    -0.595     0.200
    70.741    -0.175     0.200
    72.096     0.933     0.200
    72.096     0.302     0.200
    72.337     0.798     0.200
    72.695    -2.332     0.200
    72.910    -1.006     0.200
    72.946    -0.024     0.200
    73.101    -0.636     0.200
    73.101     0.184     0.200
    73.139    -1.061     0.200
    73.535     0.509     0.200
    73.942    -0.275     0.200
    74.244     3.359     0.200
    74.375    -0.876     0.200
    74.375    -0.952     0.200
    74.383    -0.647     0.200
    74.383    -0.787     0.200
    74.413     0.318     0.200
    74.512    -0.294     0.200
    74.990     0.141     0.200
    75.005     0.052     0.200
    75.170    -0.094     0.200
    75.319     0.349     0.200
    75.467     0.399     0.200
    75.724     0.327     0.200
    75.827     1.239     0.200
    75.964     1.063     0.200
    75.970     0.226     0.200
    75.970     0.326     0.200
    75.932     1.032     0.200
    76.140     0.658     0.200
    76.240     1.191     0.200
    76.431     0.436     0.200
    76.432     0.307     0.200
    76.896     0.288     0.200
    76.905     0.136     0.200
    77.473     0.523     0.200
    78.353    -0.136     0.200
    79.485     0.564     0.200
    79.485     0.214     0.200
    79.670     1.084     0.200
    79.777     1.879     0.200
    80.410    -0.331     0.200
    80.687    -0.097     0.200
    80.978     0.343     0.200
    81.721     1.128     0.200
    82.766     0.737     0.200
    82.811     1.899     0.200
    82.811     0.729     0.200
    83.180     1.993     0.200
    83.432     0.426     0.200
    83.596     0.802     0.200
    83.680     0.025     0.200
    83.915     0.626     0.200
    84.209     1.229     0.200
    84.460     2.057     0.200
    84.891     0.586     0.200
    89.588     0.677     0.200
    92.828     0.530     0.200
    23.455     2.852     0.200
    23.509     2.494     0.200
    23.903    -0.320     0.200
    23.903    -0.670     0.200
    23.904     2.283     0.200
    23.911     2.769     0.200
    24.108     2.462     0.200
    24.408    -0.177     0.200
    24.410     0.259     0.200
    24.410     0.479     0.200
    24.410    -0.191     0.200
    24.338     2.031     0.200
    24.488    -0.616     0.200
    24.497    -0.289     0.200
    24.497    -0.284     0.200
    24.483     2.281     0.200
    24.545     2.099     0.200
    24.709     2.255     0.200
    24.727     1.993     0.200
    25.101    -1.508     0.200
    25.121     1.876     0.200
    25.350     1.887     0.200
    25.428     2.399     0.200
    25.443     2.559     0.200
    25.476     2.409     0.200
    25.827     2.036     0.200
    25.840     1.986     0.200
    26.030     1.652     0.200
    26.312    -0.356     0.200
    26.341     2.463     0.200
    26.405     2.061     0.200
    26.447     2.157     0.200
    26.675     2.277     0.200
    26.815     2.558     0.200
    26.918     2.307     0.200
    26.926     1.397     0.200
    26.944     1.660     0.200
    26.953     2.152     0.200
    26.972     2.108     0.200
    27.097     1.766     0.200
    27.177     2.027     0.200
    27.251     2.584     0.200
    27.274     0.771     0.200
    27.331     2.694     0.200
    27.351     0.754     0.200
    27.351     1.289     0.200
    27.802     2.546     0.200
    27.906     1.751     0.200
    27.923     1.963     0.200
    28.348     2.982     0.200
    28.417     2.371     0.200
    28.465     2.175     0.200
    28.516     1.334     0.200
    28.797     1.222     0.200
    28.908     1.447     0.200
    29.114     1.349     0.200
    29.211     2.505     0.200
    29.253     1.448     0.200
    29.430     1.306     0.200
    29.541     1.276     0.200
    29.822     2.242     0.200
    29.940     0.884     0.200
    29.940     1.094     0.200
    29.974     1.071     0.200
    30.266     2.841     0.200
    30.290     1.040     0.200
    30.821     1.640     0.200
    30.827     1.823     0.200
    31.358     1.436     0.200
    31.536     1.845     0.200
    31.552     1.845     0.200
    31.552     1.594     0.200
    31.708    -0.795     0.200
    31.701     0.731     0.200
    31.701     0.609     0.200
    31.701     1.428     0.200
    31.959     1.332     0.200
    31.959     1.140     0.200
    31.931     2.577     0.200
    31.990     2.041     0.200
    32.101     2.914     0.200
    32.518     1.562     0.200
    32.679     1.542     0.200
    32.679     1.542     0.200
    32.761     2.346     0.200
    32.804     1.788     0.200
    32.824     0.225     0.200
    32.859     2.411     0.200
    32.881     2.205     0.200
    32.943     2.031     0.200
    32.941     2.272     0.200
    32.978     1.632     0.200
    33.018     2.367     0.200
    33.267     2.438     0.200
    33.267     3.057     0.200
    33.393    -1.337     0.200
    33.393    -1.037     0.200
    33.356     1.035     0.200
    33.382     2.072     0.200
    33.437     2.317     0.200
    33.461     2.324     0.200
    33.557     1.711     0.200
    33.597     0.773     0.200
    33.593     1.883     0.200
    33.593     1.766     0.200
    33.751    -0.858     0.200
    33.665     2.075     0.200
    33.690     2.017     0.200
    33.721     2.226     0.200
    33.725     2.681     0.200
    33.730     2.567     0.200
    33.842    -0.549     0.200
    33.772     2.092     0.200
    33.825     2.262     0.200
    33.954     1.680     0.200
    33.977     2.007     0.200
    34.010     2.346     0.200
    34.214     1.532     0.200
    34.215     1.987     0.200
    34.273     2.135     0.200
    34.273     0.978     0.200
    34.383     2.155     0.200
    34.393     1.889     0.200
    34.482     2.172     0.200
    34.542     2.073     0.200
    34.559     2.316     0.200
    34.559     2.631     0.200
    34.603     1.695     0.200
    34.613     1.044     0.200
    34.613     0.837     0.200
    34.613     1.619     0.200
    34.613     1.968     0.200
    34.757     2.097     0.200
    34.782     1.403     0.200
    34.820     2.767     0.200
    34.844     1.201     0.200
    34.844     1.658     0.200
    34.844     1.336     0.200
    34.844     1.336     0.200
    34.875     1.367     0.200
    34.899     2.384     0.200
    34.971     0.882     0.200
    34.968     1.740     0.200
    35.133     2.401     0.200
    35.133     2.669     0.200
    35.153     0.279     0.200
    35.195     2.857     0.200
    35.197     2.120     0.200
    35.302     1.269     0.200
    35.386     2.141     0.200
    35.400     2.701     0.200
    35.544    -1.302     0.200
    35.544    -1.732     0.200
    35.526     2.113     0.200
    35.554     1.407     0.200
    35.593     1.104     0.200
    35.706    -1.722     0.200
    35.645     2.083     0.200
    35.678     2.486     0.200
    35.777     0.565     0.200
    35.777    -0.135     0.200
    35.750     2.896     0.200
    35.750     2.205     0.200
    35.764     1.243     0.200
    35.786     2.560     0.200
    35.806     2.416     0.200
    35.821     0.180     0.200
    35.830     1.421     0.200
    35.850     2.463     0.200
    35.957     2.049     0.200
    35.960     2.946     0.200
    36.006     0.774     0.200
    36.061     2.839     0.200
    36.091     2.338     0.200
    36.105     2.381     0.200
    36.107     2.592     0.200
    36.134     2.305     0.200
    36.144     1.252     0.200
    36.146     2.990     0.200
    36.152     1.562     0.200
    36.285     2.333     0.200
    36.293     1.095     0.200
    36.359     2.776     0.200
    36.398     1.030     0.200
    36.410     2.390     0.200
    36.426     3.046     0.200
    36.452     1.454     0.200
    36.451     2.318     0.200
    36.467     2.495     0.200
    36.521     1.423     0.200
    36.539     1.116     0.200
    36.571     1.062     0.200
    36.652     2.065     0.200
    36.666     0.749     0.200
    36.666     0.917     0.200
    36.702     0.919     0.200
    36.770     1.073     0.200
    36.768     2.881     0.200
    36.793     1.855     0.200
    36.828     2.518     0.200
    36.867     0.758     0.200
    36.862     1.848     0.200
    36.904     1.347     0.200
    36.943     1.188     0.200
    37.136     0.541     0.200
    37.141     1.242     0.200
    37.163     1.090     0.200
    37.192     1.018     0.200
    37.192     1.120     0.200
    37.191     2.518     0.200
    37.233     0.900     0.200
    37.287     1.368     0.200
    37.299     1.172     0.200
    37.310     1.076     0.200
    37.321     0.677     0.200
    37.356     1.231     0.200
    37.364     1.983     0.200
    37.378     1.260     0.200
    37.428     0.641     0.200
    37.529     0.634     0.200
    37.489     2.415     0.200
    37.517     2.270     0.200
    37.526     1.318     0.200
    37.536     2.298     0.200
    37.614     0.850     0.200
    37.641     0.396     0.200
    37.641     1.124     0.200
    37.640     0.934     0.200
    37.717     1.926     0.200
    37.751     2.855     0.200
    37.773     0.536     0.200
    37.774     1.999     0.200
    37.866     1.989     0.200
    37.897     1.029     0.200
    37.920     0.993     0.200
    37.977     0.964     0.200
    37.972     2.112     0.200
    38.002     0.586     0.200
    38.003     1.021     0.200
    38.003     2.112     0.200
    38.107     1.488     0.200
    38.118     1.037     0.200
    38.118     1.189     0.200
    38.136     1.018     0.200
    38.165     2.235     0.200
    38.234     0.676     0.200
    38.236     0.729     0.200
    38.251    -0.261     0.200
    38.251     0.364     0.200
    38.257     0.497     0.200
    38.287     0.517     0.200
    38.358     0.974     0.200
    38.397     1.044     0.200
    38.419     0.696     0.200
    38.513     0.467     0.200
    38.438     0.935     0.200
    38.515     2.679     0.200
    38.562     0.628     0.200
    38.578     0.809     0.200
    38.597     0.410     0.200
    38.646     0.607     0.200
    38.654     1.135     0.200
    38.659     2.115     0.200
    38.659     2.334     0.200
    38.685     0.590     0.200
    38.756     0.350     0.200
    38.887     1.245     0.200
    38.889     0.647     0.200
    38.905     0.707     0.200
    38.916     0.372     0.200
    39.013     0.487     0.200
    39.025     1.439     0.200
    39.025     1.875     0.200
    39.031     0.304     0.200
    39.067     0.917     0.200
    39.114     0.858     0.200
    39.114     1.183     0.200
    39.218    -1.634     0.200
    39.221     0.727     0.200
    39.224     0.196     0.200
    39.238     0.213     0.200
    39.245     0.385     0.200
    39.317     1.688     0.200
    39.342     0.362     0.200
    39.342     0.234     0.200
    39.368     0.633     0.200
    39.373     0.289     0.200
    39.384     0.689     0.200
    39.412     2.568     0.200
    39.433     0.098     0.200
    39.507     0.481     0.200
    39.591     0.876     0.200
    39.661     0.055     0.200
    39.700     0.249     0.200
    39.707     1.543     0.200
    39.707     2.298     0.200
    39.752     0.709     0.200
    39.838     0.115     0.200
    39.850     1.584     0.200
    39.850     2.006     0.200
    39.878     1.841     0.200
    39.878     2.322     0.200
    39.891     0.649     0.200
    39.898     0.459     0.200
    39.949     0.426     0.200
    39.950     0.777     0.200
    40.020     0.142     0.200
    40.058     0.076     0.200
    40.140     0.266     0.200
    40.160     0.853     0.200
    40.179     2.428     0.200
    40.219     0.101     0.200
    40.238     0.111     0.200
    40.278     0.695     0.200
    40.306     0.285     0.200
    40.339     1.197     0.200
    40.384     0.530     0.200
    40.412     0.256     0.200
    40.428     0.795     0.200
    40.474    -0.052     0.200
    40.473     1.638     0.200
    40.511     0.631     0.200
    40.542    -0.064     0.200
    40.618     1.090     0.200
    40.713     0.122     0.200
    40.721    -0.155     0.200
    40.727     0.432     0.200
    40.765     0.146     0.200
    40.788     1.028     0.200
    40.790     0.947     0.200
    40.852     0.207     0.200
    40.992     0.137     0.200
    40.994    -0.021     0.200
    41.019     0.744     0.200
    41.025     0.848     0.200
    41.044     0.484     0.200
    41.140     0.827     0.200
    41.147     0.168     0.200
    41.162     0.628     0.200
    41.183     0.288     0.200
    41.197     0.387     0.200
    41.230     0.676     0.200
    41.280    -0.397     0.200
    41.271    -0.183     0.200
    41.274     1.155     0.200
    41.274     2.204     0.200
    41.310     0.445     0.200
    41.333     1.739     0.200
    41.333     2.203     0.200
    41.355    -0.001     0.200
    41.377     0.843     0.200
    41.402     0.992     0.200
    41.475    -0.031     0.200
    41.490     0.029     0.200
    41.519     1.762     0.200
    41.519     2.014     0.200
    41.546    -0.163     0.200
    41.547     0.791     0.200
    41.563     0.562     0.200
    41.587     0.952     0.200
    41.655    -0.243     0.200
    41.683     0.558     0.200
    41.699     0.889     0.200
    41.716    -0.223     0.200
    41.820     0.485     0.200
    41.835     0.253     0.200
    41.857     0.602     0.200
    41.878     1.934     0.200
    41.880     1.028     0.200
    41.880     0.829     0.200
    41.880     1.299     0.200
    41.891     0.206     0.200
    41.889    -0.514     0.200
    41.929     0.416     0.200
    41.929     0.237     0.200
    41.928     0.046     0.200
    41.961     0.585     0.200
    41.977     0.688     0.200
    42.057     0.193     0.200
    42.069     0.135     0.200
    42.149     0.297     0.200
    42.185     0.047     0.200
    42.187     0.644     0.200
    42.197     0.915     0.200
    42.234     1.945     0.200
    42.239     1.945     0.200
    42.262     0.469     0.200
    42.265     0.857     0.200
    42.277     0.069     0.200
    42.290     0.964     0.200
    42.309    -0.365     0.200
    42.306     0.754     0.200
    42.328     0.531     0.200
    42.352     2.150     0.200
    42.415     0.302     0.200
    42.497    -0.524     0.200
    42.529     1.148     0.200
    42.603     0.634     0.200
    42.611     0.279     0.200
    42.637     0.678     0.200
    42.660     1.072     0.200
    42.681    -0.132     0.200
    42.684     0.985     0.200
    42.704     0.337     0.200
    42.745    -0.222     0.200
    42.805     0.948     0.200
    42.860     0.391     0.200
    42.869     1.661     0.200
    42.879     2.499     0.200
    42.915     0.184     0.200
    42.939    -0.297     0.200
    42.945     0.155     0.200
    43.073     1.106     0.200
    43.077    -0.110     0.200
    43.089     0.931     0.200
    43.098     0.079     0.200
    43.103     0.123     0.200
    43.121     1.137     0.200
    43.141     0.844     0.200
    43.184     0.433     0.200
    43.193    -0.145     0.200
    43.198     0.412     0.200
    43.285     0.439     0.200
    43.293    -0.208     0.200
    43.306     0.829     0.200
    43.479    -1.519     0.200
    43.453     0.918     0.200
    43.465     0.025     0.200
    43.550     0.626     0.200
    43.573     0.005     0.200
    43.581    -0.022     0.200
    43.628     0.439     0.200
    43.631     0.581     0.200
    43.647     0.215     0.200
    43.732     2.187     0.200
    43.797    -0.346     0.200
    43.809     0.858     0.200
    43.821     1.067     0.200
    43.829     0.549     0.200
    43.866     0.296     0.200
    43.903     0.005     0.200
    43.929     0.357     0.200
    43.947    -0.013     0.200
    44.032     0.653     0.200
    44.044     0.195     0.200
    44.055     0.708     0.200
    44.111     0.470     0.200
    44.221    -0.218     0.200
    44.143     0.051     0.200
    44.246     0.322     0.200
    44.252     0.156     0.200
    44.280     0.677     0.200
    44.292     0.888     0.200
    44.296    -0.259     0.200
    44.298     0.011     0.200
    44.468    -1.994     0.200
    44.425     0.598     0.200
    44.546    -0.618     0.200
    44.473     0.325     0.200
    44.513     0.225     0.200
    44.599     0.414     0.200
    44.608     0.432     0.200
    44.627     0.256     0.200
    44.657     0.412     0.200
    44.675     0.810     0.200
    44.675     1.392     0.200
    44.677    -0.078     0.200
    44.677     0.040     0.200
    44.685     0.835     0.200
    44.699     0.623     0.200
    44.699     1.303     0.200
    44.727     0.144     0.200
    44.736    -0.002     0.200
    44.744     0.921     0.200
    44.854     0.462     0.200
    44.856     1.402     0.200
    44.856     2.125     0.200
    44.904     0.255     0.200
    44.925     0.352     0.200
    45.019     0.703     0.200
    45.020     0.841     0.200
    45.020     1.011     0.200
    45.020     0.611     0.200
    44.938     0.440     0.200
    45.076     0.152     0.200
    45.101     0.528     0.200
    45.107     0.488     0.200
    45.117     0.032     0.200
    45.130     0.127     0.200
    45.169    -0.202     0.200
    45.169     0.447     0.200
    45.342    -0.137     0.200
    45.368     0.090     0.200
    45.429    -0.339     0.200
    45.440    -0.302     0.200
    45.453     0.567     0.200
    45.463     0.392     0.200
    45.468     0.052     0.200
    45.606     0.229     0.200
    45.641    -0.133     0.200
    45.644    -0.066     0.200
    45.751    -0.635     0.200
    45.767     0.141     0.200
    45.781    -0.043     0.200
    45.811     0.224     0.200
    45.826    -0.210     0.200
    45.838    -0.064     0.200
    45.837     0.543     0.200
    45.847     0.717     0.200
    45.910     0.507     0.200
    45.972     0.088     0.200
    45.974     0.172     0.200
    46.009     0.092     0.200
    46.064    -0.725     0.200
    46.082    -0.395     0.200
    46.140     0.253     0.200
    46.153     0.449     0.200
    46.199    -0.286     0.200
    46.219    -0.435     0.200
    46.229    -0.238     0.200
    46.232    -0.696     0.200
    46.329     0.560     0.200
    46.357    -0.446     0.200
    46.339     0.617     0.200
    46.387     0.292     0.200
    46.406    -0.049     0.200
    46.406     0.622     0.200
    46.453     0.516     0.200
    46.544     0.150     0.200
    46.482    -0.864     0.200
    46.483    -0.086     0.200
    46.493    -0.129     0.200
    46.640    -0.386     0.200
    46.596     0.066     0.200
    46.645     0.697     0.200
    46.645     0.527     0.200
    46.613    -0.424     0.200
    46.616    -0.401     0.200
    46.681     0.230     0.200
    46.681     0.526     0.200
    46.684     0.109     0.200
    46.688    -0.315     0.200
    46.735     0.531     0.200
    46.755     0.273     0.200
    46.864    -0.684     0.200
    46.791    -0.644     0.200
    46.848    -1.076     0.200
    46.849    -0.057     0.200
    46.989    -0.537     0.200
    47.002    -0.395     0.200
    47.010     0.518     0.200
    47.043    -0.103     0.200
    47.064     0.051     0.200
    47.077     0.099     0.200
    47.145    -0.832     0.200
    47.145    -0.902     0.200
    47.098     0.633     0.200
    47.168     0.568     0.200
    47.230    -1.177     0.200
    47.256    -1.155     0.200
    47.258    -0.029     0.200
    47.349    -0.689     0.200
    47.339    -0.515     0.200
    47.347    -0.080     0.200
    47.348     0.052     0.200
    47.388    -0.361     0.200
    47.477     0.631     0.200
    47.477     0.777     0.200
    47.486     0.220     0.200
    47.503     0.212     0.200
    47.523    -1.437     0.200
    47.595     0.659     0.200
    47.591     0.055     0.200
    47.627     0.453     0.200
    47.627     0.273     0.200
    47.601     0.538     0.200
    47.602     1.496     0.200
    47.602     1.496     0.200
    47.641     0.086     0.200
    47.711    -1.228     0.200
    47.737     0.007     0.200
    47.741    -0.336     0.200
    47.785    -0.373     0.200
    47.850    -0.376     0.200
    47.907     0.436     0.200
    47.932     0.071     0.200
    47.954    -0.909     0.200
    47.974     0.487     0.200
    48.012     0.420     0.200
    48.054     0.529     0.200
    48.056    -1.319     0.200
    48.184    -0.156     0.200
    48.151    -0.733     0.200
    48.177    -0.595     0.200
    48.318    -0.455     0.200
    48.318    -0.585     0.200
    48.298     1.903     0.200
    48.344     0.187     0.200
    48.348     0.401     0.200
    48.358    -1.176     0.200
    48.416     0.237     0.200
    48.565     2.101     0.200
    48.493     0.766     0.200
    48.526     0.472     0.200
    48.628    -0.256     0.200
    48.674     0.064     0.200
    48.791    -0.543     0.200
    48.781     0.336     0.200
    48.798     0.390     0.200
    48.808     0.437     0.200
    48.814     0.600     0.200
    48.819     0.629     0.200
    48.860     0.177     0.200
    48.962     0.369     0.200
    48.962     0.266     0.200
    49.168     0.220     0.200
    49.203    -2.011     0.200
    49.200    -0.137     0.200
    49.200     0.629     0.200
    49.200     1.242     0.200
    49.233     0.674     0.200
    49.306     0.086     0.200
    49.369    -0.003     0.200
    49.381     0.169     0.200
    49.382    -0.030     0.200
    49.421    -0.210     0.200
    49.662     1.303     0.200
    49.591     0.201     0.200
    49.591     0.076     0.200
    49.597     0.328     0.200
    49.690     0.112     0.200
    49.707     0.255     0.200
    49.704     0.213     0.200
    49.729    -0.260     0.200
    49.728     0.615     0.200
    49.738     0.665     0.200
    49.740     0.077     0.200
    49.769    -0.027     0.200
    49.800    -0.634     0.200
    49.829    -0.274     0.200
    49.845    -0.434     0.200
    49.997     0.527     0.200
    50.015     0.817     0.200
    50.059    -0.552     0.200
    50.062     0.124     0.200
    50.079     0.561     0.200
    50.083     0.165     0.200
    50.136    -0.141     0.200
    50.144    -0.399     0.200
    50.144     0.170     0.200
    50.180     0.148     0.200
    50.307     0.737     0.200
    50.277    -0.300     0.200
    50.307     0.736     0.200
    50.307     0.736     0.200
    50.278     0.052     0.200
    50.351    -0.420     0.200
    50.466     0.551     0.200
    50.474     0.809     0.200
    50.480     0.557     0.200
    50.508     0.612     0.200
    50.540     0.719     0.200
    50.550    -0.454     0.200
    50.546     0.277     0.200
    50.548    -0.264     0.200
    50.571     0.578     0.200
    50.582     0.483     0.200
    50.603     0.392     0.200
    50.616     0.281     0.200
    50.620    -1.521     0.200
    50.812     0.601     0.200
    50.816     1.166     0.200
    50.840     0.970     0.200
    50.898     0.933     0.200
    50.986     0.635     0.200
    50.904     0.212     0.200
    50.905     0.506     0.200
    50.944     1.017     0.200
    50.983     0.476     0.200
    50.983     1.237     0.200
    51.046     0.908     0.200
    51.136    -0.546     0.200
    51.258     1.161     0.200
    51.268    -0.141     0.200
    51.353     0.670     0.200
    51.269     1.456     0.200
    51.288     1.374     0.200
    51.324     1.170     0.200
    51.357     1.118     0.200
    51.407     0.066     0.200
    51.419     1.259     0.200
    51.448     0.063     0.200
    51.446     1.593     0.200
    51.583    -0.529     0.200
    51.677     0.443     0.200
    51.634     1.397     0.200
    51.640     1.436     0.200
    51.644     0.884     0.200
    51.676     1.526     0.200
    51.681     0.857     0.200
    51.737     0.993     0.200
    51.739     1.325     0.200
    51.861     1.621     0.200
    51.908     0.077     0.200
    52.006    -0.186     0.200
    52.136     1.512     0.200
    52.148    -0.746     0.200
    52.167     1.556     0.200
    52.176     1.031     0.200
    52.181     0.410     0.200
    52.328    -1.095     0.200
    52.505    -0.567     0.200
    52.521     1.044     0.200
    52.580     0.021     0.200
    52.596    -0.520     0.200
    52.606     0.905     0.200
    52.695     0.370     0.200
    52.785     0.324     0.200
    52.710    -0.482     0.200
    52.906    -1.047     0.200
    52.998     0.465     0.200
    52.998     0.856     0.200
    52.998     0.040     0.200
    52.988     0.184     0.200
    53.026    -0.732     0.200
    53.035     0.399     0.200
    53.035     0.950     0.200
    53.134    -0.648     0.200
    53.297     1.494     0.200
    53.387    -1.122     0.200
    53.430     0.081     0.200
    53.480    -0.724     0.200
    53.703    -0.414     0.200
    53.870    -0.178     0.200
    53.967    -0.841     0.200
    53.985     0.032     0.200
    54.072    -0.917     0.200
    54.084     0.232     0.200
    54.084    -0.004     0.200
    54.073    -0.314     0.200
    54.182     0.283     0.200
    54.109    -0.133     0.200
    54.180    -0.778     0.200
    54.377    -0.033     0.200
    54.408    -0.430     0.200
    54.421     0.110     0.200
    54.421     0.110     0.200
    54.380    -0.686     0.200
    54.456    -1.048     0.200
    54.651    -0.273     0.200
    54.703    -0.841     0.200
    54.846     0.017     0.200
    54.875    -0.990     0.200
    54.957    -0.438     0.200
    54.977    -0.368     0.200
    55.007    -0.147     0.200
    55.133    -0.164     0.200
    55.248    -0.075     0.200
    55.351    -0.408     0.200
    55.353    -0.647     0.200
    55.513    -0.785     0.200
    55.505    -0.013     0.200
    55.510    -0.387     0.200
    55.565    -0.611     0.200
    55.752    -0.926     0.200
    55.776    -1.005     0.200
    55.776    -0.975     0.200
    55.776    -1.096     0.200
    55.776    -0.956     0.200
    55.800     0.495     0.200
    55.813     0.512     0.200
    55.828     0.426     0.200
    56.074     0.473     0.200
    56.089    -0.213     0.200
    56.124    -0.588     0.200
    56.183    -0.271     0.200
    56.189    -1.336     0.200
    56.216     0.263     0.200
    56.283     0.092     0.200
    56.348    -1.239     0.200
    56.342    -1.198     0.200
    56.397    -1.427     0.200
    56.508     0.013     0.200
    56.527     0.617     0.200
    56.552    -0.503     0.200
    56.604     1.733     0.200
    56.822     0.722     0.200
    56.794    -0.837     0.200
    56.947    -0.759     0.200
    57.206     0.310     0.200
    57.181     1.877     0.200
    57.391     0.604     0.200
    57.422    -0.164     0.200
    57.577    -1.128     0.200
    57.804     0.302     0.200
    57.860     1.060     0.200
    57.841    -0.208     0.200
    57.968     0.364     0.200
    58.268     0.204     0.200
    58.652     1.179     0.200
    58.713     0.958     0.200
    58.807    -0.600     0.200
    58.804     0.366     0.200
    58.950    -0.319     0.200
    58.953    -1.213     0.200
    58.953    -0.338     0.200
    59.169    -2.102     0.200
    59.317     0.074     0.200
    60.393    -0.612     0.200
    60.736    -0.239     0.200
    61.310    -0.126     0.200
    61.940    -1.276     0.200
    62.018    -0.507     0.200
    62.469     0.301     0.200
    62.710    -0.795     0.200
    62.823     0.354     0.200
    62.976     0.101     0.200
    63.084    -0.311     0.200
    63.288     0.332     0.200
    63.490    -0.326     0.200
    63.490    -0.603     0.200
    63.717     0.097     0.200
    63.748     0.348     0.200
    63.797    -0.929     0.200
    63.797     0.142     0.200
    63.797    -0.129     0.200
    63.797     0.771     0.200
    63.863     0.037     0.200
    63.872    -0.522     0.200
    63.863    -0.495     0.200
    63.864    -0.621     0.200
    63.864    -0.621     0.200
    63.906     0.004     0.200
    63.937     0.002     0.200
    64.016     0.036     0.200
    64.103     0.264     0.200
    64.143     0.101     0.200
    64.168    -0.743     0.200
    64.183     0.191     0.200
    64.188     0.107     0.200
    64.194    -0.234     0.200
    64.194    -0.283     0.200
    64.194    -0.283     0.200
    64.156     0.493     0.200
    64.395     1.049     0.200
    64.374     0.138     0.200
    64.415     0.320     0.200
    64.506     0.227     0.200
    64.506     0.214     0.200
    64.508     0.424     0.200
    64.484     0.610     0.200
    64.524     0.858     0.200
    64.513    -0.139     0.200
    64.513    -0.399     0.200
    64.554    -0.452     0.200
    64.554    -0.586     0.200
    64.874     0.525     0.200
    64.979     2.593     0.200
    64.980     0.057     0.200
    65.049    -0.119     0.200
    65.272     0.676     0.200
    65.339     0.014     0.200
    65.334     0.454     0.200
    65.366     0.280     0.200
    65.500     0.669     0.200
    65.500     0.289     0.200
    65.522     0.758     0.200
    65.527     0.254     0.200
    65.620     0.206     0.200
    65.702    -0.552     0.200
    65.702    -0.557     0.200
    65.717    -0.150     0.200
    65.870     0.557     0.200
    65.880     0.271     0.200
    66.240     0.480     0.200
    66.240    -0.250     0.200
    66.337     0.232     0.200
    66.430     0.045     0.200
    66.399    -0.223     0.200
    66.654     0.569     0.200
    66.809     0.789     0.200
    66.822    -0.206     0.200
    67.089     0.319     0.200
    67.276     0.557     0.200
    67.888     0.138     0.200
    67.960     0.213     0.200
    68.048     0.049     0.200
    68.463     1.056     0.200
    68.548     0.225     0.200
    68.548     0.585     0.200
    68.548     0.925     0.200
    68.622     0.320     0.200
    68.685     0.311     0.200
    68.659     0.631     0.200
    68.764     0.251     0.200
    68.771     0.226     0.200
    68.935     2.063     0.200
    69.270     0.298     0.200
    69.453     1.909     0.200
    69.443    -0.721     0.200
    69.443    -0.230     0.200
    69.443    -0.830     0.200
    69.554     0.143     0.200
    69.599     0.307     0.200
    69.844    -0.006     0.200
    69.690     0.146     0.200
    69.738     0.064     0.200
    69.955     0.171     0.200
    69.968     0.018     0.200
    70.023     0.594     0.200
    70.082     0.122     0.200
    70.176    -0.057     0.200
    70.208     0.195     0.200
    70.208     0.070     0.200
    70.231     0.477     0.200
    70.260    -0.150     0.200
    70.335     0.692     0.200
    70.347    -0.249     0.200
    70.392     0.648     0.200
    70.417     0.632     0.200
    70.659     0.521     0.200
    70.730    -0.915     0.200
    70.764     0.623     0.200
    70.741     0.369     0.200
    70.773     1.555     0.200
    70.811     0.396     0.200
    70.811     0.436     0.200
    70.853     0.609     0.200
    70.910     0.622     0.200
    71.025     0.670     0.200
    71.057     1.243     0.200
    71.233     0.939     0.200
    71.326     0.934     0.200
    71.319     0.370     0.200
    71.319     0.600     0.200
    71.318    -0.033     0.200
    71.277     1.190     0.200
    71.390    -0.709     0.200
    71.647    -0.760     0.200
    71.808    -0.226     0.200
    71.856     1.231     0.200
    71.951     0.716     0.200
    72.166     0.801     0.200
    72.166     1.352     0.200
    72.166     1.132     0.200
    72.450     0.950     0.200
    72.644    -1.214     0.200
    72.724     0.297     0.200
    72.952     0.351     0.200
    72.976    -1.285     0.200
    73.016     0.979     0.200
    73.205    -1.039     0.200
    73.189     0.086     0.200
    73.189     0.556     0.200
    73.364     0.258     0.200
    73.590     0.699     0.200
    73.466     1.726     0.200
    73.830     1.784     0.200
    73.886     0.393     0.200
    73.887     0.461     0.200
    73.999     0.107     0.200
    73.999    -0.293     0.200
    74.014     0.455     0.200
    73.995     2.588     0.200
    74.070    -0.258     0.200
    74.165     0.196     0.200
    74.230     0.359     0.200
    74.204     0.666     0.200
    74.353     0.243     0.200
    74.439    -0.532     0.200
    74.439    -0.527     0.200
    74.447    -0.502     0.200
    74.447    -0.602     0.200
    74.465    -0.790     0.200
    74.501     1.480     0.200
    74.501     0.790     0.200
    74.471     0.339     0.200
    74.570     0.281     0.200
    74.570     0.381     0.200
    74.604     0.384     0.200
    74.668     0.367     0.200
    74.838     0.534     0.200
    74.900     0.477     0.200
    75.059     0.366     0.200
    75.047     0.628     0.200
    75.064     0.829     0.200
    75.179     0.885     0.200
    75.230     0.274     0.200
    75.202     2.065     0.200
    75.291     0.624     0.200
    75.348     0.694     0.200
    75.360     0.027     0.200
    75.377     0.532     0.200
    75.459     0.560     0.200
    75.524     0.887     0.200
    75.606     0.520     0.200
    75.659     0.513     0.200
    75.659     0.293     0.200
    75.786     0.691     0.200
    75.786     0.791     0.200
    75.890     2.195     0.200
    75.890     2.055     0.200
    75.985     0.315     0.200
    75.999     0.377     0.200
    76.024     1.332     0.200
    76.030     0.796     0.200
    76.112     0.832     0.200
    76.197     0.847     0.200
    76.222     1.556     0.200
    76.300     1.565     0.200
    76.277    -0.105     0.200
    76.311     0.543     0.200
    76.389     1.061     0.200
    76.488     0.521     0.200
    76.488     0.526     0.200
    76.493     0.775     0.200
    76.524    -0.300     0.200
    76.589     0.629     0.200
    76.686     0.480     0.200
    76.705     0.377     0.200
    76.795    -1.130     0.200
    76.922     1.156     0.200
    77.050    -0.169     0.200
    77.005     1.334     0.200
    77.064     0.455     0.200
    77.149     0.439     0.200
    77.163     0.569     0.200
    77.234     0.700     0.200
    77.222     1.277     0.200
    77.271     0.822     0.200
    77.476     1.055     0.200
    77.504     0.575     0.200
    77.533     1.530     0.200
    77.533     0.930     0.200
    77.533     0.010     0.200
    77.534     0.723     0.200
    77.592     1.193     0.200
    77.592     1.789     0.200
    77.592     1.399     0.200
    77.588     1.095     0.200
    77.598     0.736     0.200
    77.694     0.580     0.200
    77.725     0.762     0.200
    77.726     0.554     0.200
    77.769     1.077     0.200
    77.837     0.605     0.200
    77.799     0.709     0.200
    77.799    -0.440     0.200
    77.856     0.706     0.200
    77.893     0.829     0.200
    77.935     0.590     0.200
    77.967     0.813     0.200
    77.957    -0.532     0.200
    77.942     0.852     0.200
    78.035     0.037     0.200
    78.055     1.125     0.200
    78.083     1.072     0.200
    78.144     1.157     0.200
    78.154    -0.021     0.200
    78.154     0.079     0.200
    78.156     1.213     0.200
    78.147    -0.084     0.200
    78.185     0.508     0.200
    78.220     0.913     0.200
    78.237     1.439     0.200
    78.286     1.346     0.200
    78.274     0.353     0.200
    78.401     0.863     0.200
    78.404     1.095     0.200
    78.421     0.801     0.200
    78.440     1.096     0.200
    78.526     1.525     0.200
    78.529     0.566     0.200
    78.534     0.881     0.200
    78.555     1.366     0.200
    78.555     1.142     0.200
    78.546     2.011     0.200
    78.578     0.938     0.200
    78.610     0.821     0.200
    78.626     0.574     0.200
    78.682     0.867     0.200
    78.698     0.426     0.200
    78.701     0.925     0.200
    78.713     0.297     0.200
    78.724     0.637     0.200
    78.735     0.836     0.200
    78.746     0.873     0.200
    78.763     0.220     0.200
    78.854     1.007     0.200
    78.957     1.156     0.200
    79.037     0.519     0.200
    79.029     0.362     0.200
    79.032     0.744     0.200
    79.169     0.795     0.200
    79.165     1.021     0.200
    79.228     1.473     0.200
    79.237     0.723     0.200
    79.263     0.386     0.200
    79.318     0.145     0.200
    79.364     1.332     0.200
    79.361    -0.053     0.200
    79.361     0.827     0.200
    79.403     0.621     0.200
    79.422     0.617     0.200
    79.451    -0.268     0.200
    79.517     1.200     0.200
    79.500    -1.009     0.200
    79.519     0.988     0.200
    79.530     0.933     0.200
    79.522     0.973     0.200
    79.553     0.705     0.200
    79.553     1.187     0.200
    79.553     0.866     0.200
    79.574     0.141     0.200
    79.569     0.068     0.200
    79.597     1.267     0.200
    79.561     0.600     0.200
    79.706     1.574     0.200
    79.738     0.976     0.200
    79.740     0.193     0.200
    79.800     1.844     0.200
    79.816     0.981     0.200
    79.816     0.511     0.200
    79.821     0.653     0.200
    79.803     0.548     0.200
    79.845     1.421     0.200
    79.816     0.920     0.200
    79.881     0.455     0.200
    79.926     1.384     0.200
    79.907     1.184     0.200
    79.892     0.969     0.200
    79.870    -0.202     0.200
    79.941     0.403     0.200
    79.915     1.342     0.200
    79.945     0.843     0.200
    79.922    -0.695     0.200
    79.922     3.005     0.200
    79.980     1.190     0.200
    79.980     0.790     0.200
    79.958     1.110     0.200
    79.993     1.024     0.200
    80.010     0.331     0.200
    80.022     1.064     0.200
    80.082     1.142     0.200
    80.026     0.241     0.200
    80.052     1.802     0.200
    80.061     1.254     0.200
    80.064     1.278     0.200
    80.118     1.750     0.200
    80.158     0.532     0.200
    80.234     1.622     0.200
    80.264     1.060     0.200
    80.295     0.395     0.200
    80.312     1.105     0.200
    80.345     0.924     0.200
    80.388     0.995     0.200
    80.381     0.434     0.200
    80.435     0.743     0.200
    80.436     0.838     0.200
    80.528    -1.356     0.200
    80.507     0.956     0.200
    80.547     1.345     0.200
    80.551     1.421     0.200
    80.603     0.444     0.200
    80.611     0.798     0.200
    80.612     0.797     0.200
    80.598     0.169     0.200
    80.602     1.346     0.200
    80.651     2.088     0.200
    80.654     0.668     0.200
    80.709     0.474     0.200
    80.709     0.254     0.200
    80.742     0.002     0.200
    80.742     0.571     0.200
    80.742     0.202     0.200
    80.742     0.321     0.200
    80.749     1.119     0.200
    80.742     0.898     0.200
    80.751    -0.549     0.200
    80.809    -0.066     0.200
    80.818     0.495     0.200
    80.857     1.479     0.200
    80.857     0.886     0.200
    80.857     0.885     0.200
    80.853     1.508     0.200
    80.872     0.467     0.200
    80.897     1.372     0.200
    80.910     0.203     0.200
    80.952     1.078     0.200
    80.984     1.189     0.200
    81.009     1.468     0.200
    80.990     1.177     0.200
    81.032     0.903     0.200
    81.032     0.903     0.200
    81.011     0.764     0.200
    80.977     0.535     0.200
    81.062    -0.206     0.200
    81.072     0.541     0.200
    81.099     0.719     0.200
    81.061     1.300     0.200
    81.117     1.003     0.200
    81.120     1.088     0.200
    81.112     0.730     0.200
    81.109     1.246     0.200
    81.164     0.650     0.200
    81.268     0.801     0.200
    81.268     1.701     0.200
    81.268     1.501     0.200
    81.337     1.337     0.200
    81.350     0.901     0.200
    81.328     1.781     0.200
    81.378     1.417     0.200
    81.431     0.538     0.200
    81.450     0.639     0.200
    81.453     0.221     0.200
    81.453     0.521     0.200
    81.497     0.690     0.200
    81.601     0.138     0.200
    81.622     1.426     0.200
    81.671     0.869     0.200
    81.659     0.095     0.200
    81.756     1.723     0.200
    81.791     0.953     0.200
    81.728     0.812     0.200
    81.812     0.528     0.200
    81.888     1.420     0.200
    81.888     1.730     0.200
    81.829     0.489     0.200
    81.881     1.366     0.200
    82.025     0.711     0.200
    81.972     1.127     0.200
    82.032    -0.527     0.200
    82.035    -0.345     0.200
    82.039     0.438     0.200
    82.112     0.752     0.200
    82.122     1.000     0.200
    82.136     0.920     0.200
    82.247     0.545     0.200
    82.256     1.398     0.200
    82.256     1.498     0.200
    82.393     1.385     0.200
    82.377    -0.460     0.200
    82.546     0.285     0.200
    82.498     0.608     0.200
    82.567    -0.054     0.200
    82.580     0.811     0.200
    82.638     0.410     0.200
    82.684     0.272     0.200
    82.683     0.113     0.200
    82.801    -0.036     0.200
    82.811     0.612     0.200
    82.811    -0.388     0.200
    82.811     0.112     0.200
    82.823    -0.150     0.200
    82.809     1.023     0.200
    82.829     1.217     0.200
    82.857     0.273     0.200
    82.880     1.546     0.200
    82.880     2.172     0.200
    82.880     1.752     0.200
    82.913     1.583     0.200
    82.933    -0.923     0.200
    82.904     0.231     0.200
    82.927    -0.290     0.200
    83.000    -0.069     0.200
    83.021     0.322     0.200
    83.021     0.322     0.200
    83.119     0.719     0.200
    83.068     0.299     0.200
    83.140     0.730     0.200
    83.149     0.261     0.200
    83.101     0.502     0.200
    83.198    -0.993     0.200
    83.188     0.311     0.200
    83.223     1.080     0.200
    83.247     0.555     0.200
    83.278    -0.255     0.200
    83.238     0.993     0.200
    83.267     0.452     0.200
    83.264     0.567     0.200
    83.278     1.399     0.200
    83.247     0.617     0.200
    83.320     0.158     0.200
    83.320     0.499     0.200
    83.396     0.791     0.200
    83.427     0.549     0.200
    83.466     1.129     0.200
    83.466     1.439     0.200
    83.491     1.113     0.200
    83.487     0.220     0.200
    83.458     1.139     0.200
    83.538     1.061     0.200
    83.536     1.122     0.200
    83.568     1.026     0.200
    83.519     1.049     0.200
    83.636     0.958     0.200
    83.640     0.135     0.200
    83.628     0.950     0.200
    83.664     1.107     0.200
    83.642     1.078     0.200
    83.642     1.097     0.200
    83.663     0.421     0.200
    83.672     0.176     0.200
    83.718     2.270     0.200
    83.697     0.975     0.200
    83.749     0.440     0.200
    83.723     1.015     0.200
    83.692     0.463     0.200
    83.737     1.222     0.200
    83.811     1.815     0.200
    83.908    -2.121     0.200
    83.959     0.987     0.200
    83.957     1.119     0.200
    84.029    -1.458     0.200
    84.031     0.842     0.200
    84.074     0.023     0.200
    84.096     1.013     0.200
    84.096     1.123     0.200
    84.103     0.645     0.200
    84.111    -0.875     0.200
    84.178     0.044     0.200
    84.212     0.821     0.200
    84.223    -0.994     0.200
    84.223     1.256     0.200
    84.232    -1.502     0.200
    84.247     0.646     0.200
    84.284     0.356     0.200
    84.284     0.557     0.200
    84.251     1.225     0.200
    84.334     0.165     0.200
    84.360     0.569     0.200
    84.378     0.071     0.200
    84.398    -0.750     0.200
    84.393     0.305     0.200
    84.335    -0.661     0.200
    84.340    -0.686     0.200
    84.431    -1.647     0.200
    84.477     2.580     0.200
    84.463     0.749     0.200
    84.474     1.094     0.200
    84.503     1.148     0.200
    84.539    -1.914     0.200
    84.510     0.203     0.200
    84.574     0.190     0.200
    84.578     0.898     0.200
    84.578     0.668     0.200
    84.124    -2.129     0.200
    84.654    -0.014     0.200
    84.683     0.469     0.200
    84.701    -0.668     0.200
    84.752     1.193     0.200
    84.769     1.106     0.200
    84.782     1.472     0.200
    84.774    -0.417     0.200
    84.805     0.329     0.200
    84.828     0.472     0.200
    84.842     0.039     0.200
    84.887    -0.987     0.200
    84.903     1.510     0.200
    84.925     1.633     0.200
    84.935    -0.146     0.200
    84.950    -1.301     0.200
    84.956     0.917     0.200
    84.956     0.936     0.200
    84.957     0.914     0.200
    84.954    -0.071     0.200
    84.974     0.367     0.200
    84.975    -2.308     0.200
    84.998     1.230     0.200
    85.026     0.629     0.200
    85.018    -0.143     0.200
    85.032     0.810     0.200
    85.027     0.213     0.200
    85.040     0.545     0.200
    85.110    -0.184     0.200
    85.105     1.223     0.200
    85.125    -0.176     0.200
    85.126     1.219     0.200
    85.126    -0.081     0.200
    85.192    -1.394     0.200
    85.214     1.378     0.200
    85.185     1.532     0.200
    85.316     0.369     0.200
    85.402    -0.149     0.200
    85.429     0.505     0.200
    85.444    -2.061     0.200
    85.457     0.067     0.200
    85.497     1.748     0.200
    85.548     1.264     0.200
    85.586     1.482     0.200
    85.698     0.048     0.200
    85.726     0.687     0.200
    85.736     0.680     0.200
    85.786     0.932     0.200
    85.835     0.691     0.200
    85.856    -1.305     0.200
    85.861    -0.339     0.200
    85.884     0.488     0.200
    85.914     0.398     0.200
    85.975     0.099     0.200
    85.996    -0.506     0.200
    86.027     0.142     0.200
    86.031    -0.281     0.200
    86.082     0.267     0.200
    86.090    -0.069     0.200
    86.205    -0.239     0.200
    86.220    -2.111     0.200
    86.222    -0.323     0.200
    86.239     0.097     0.200
    86.239     0.397     0.200
    86.239     0.947     0.200
    86.306     0.669     0.200
    86.396    -0.877     0.200
    86.396    -0.027     0.200
    86.485     1.388     0.200
    86.485     0.148     0.200
    86.512     0.856     0.200
    86.517    -0.169     0.200
    86.582     1.492     0.200
    86.638     0.739     0.200
    86.654     0.157     0.200
    86.688     1.712     0.200
    86.688    -1.716     0.200
    86.751    -0.814     0.200
    86.800     1.255     0.200
    86.833     0.287     0.200
    86.839     0.057     0.200
    86.892    -0.251     0.200
    86.903    -0.547     0.200
    86.956    -1.676     0.200
    86.952    -0.096     0.200
    86.999     0.877     0.200
    87.002    -1.136     0.200
    87.018    -1.104     0.200
    87.030    -0.174     0.200
    87.049     0.313     0.200
    87.113     0.042     0.200
    87.146     0.561     0.200
    87.146     0.361     0.200
    87.185    -0.998     0.200
    87.184     0.779     0.200
    87.227    -0.630     0.200
    87.238     0.818     0.200
    87.266     0.184     0.200
    87.244     1.986     0.200
    87.320    -0.481     0.200
    87.329     1.348     0.200
    87.331     0.366     0.200
    87.322     1.312     0.200
    87.372    -0.927     0.200
    87.375     0.958     0.200
    87.377     0.548     0.200
    87.402     0.857     0.200
    87.406    -0.893     0.200
    87.409    -0.910     0.200
    87.441    -0.491     0.200
    87.476     0.870     0.200
    87.480     0.052     0.200
    87.523    -0.755     0.200
    87.527    -0.074     0.200
    87.817     1.423     0.200
    87.886    -1.785     0.200
    87.895    -0.330     0.200
    88.011    -0.980     0.200
    88.044     0.266     0.200
    88.110     0.553     0.200
    88.125     2.083     0.200
    88.238     1.156     0.200
    88.233    -1.231     0.200
    88.243    -1.057     0.200
    88.243    -0.178     0.200
    88.380     1.274     0.200
    88.479     0.200     0.200
    88.530    -0.733     0.200
    88.680    -1.440     0.200
    88.760     0.685     0.200
    88.777     0.927     0.200
    88.847     0.874     0.200
    88.874     1.351     0.200
    88.886    -0.205     0.200
    88.930    -0.913     0.200
    89.251     1.282     0.200
    89.287     1.211     0.200
    89.283     0.930     0.200
    89.519    -1.074     0.200
    89.699     0.283     0.200
    89.699     0.763     0.200
    89.901     0.238     0.200
    90.004     1.959     0.200
    90.029    -1.256     0.200
    90.136     0.342     0.200
    90.136    -0.358     0.200
    90.136     0.132     0.200
    90.144    -0.295     0.200
    90.310    -0.068     0.200
    90.517    -0.131     0.200
    90.762     0.339     0.200
    90.824     1.042     0.200
    91.026     0.615     0.200
    91.148    -0.202     0.200
    91.271     0.965     0.200
    91.271     0.465     0.200
    91.630     0.633     0.200
    92.355     0.202     0.200
    92.356     0.847     0.200
    92.703     1.033     0.200
    92.742    -0.226     0.200
    92.815    -0.771     0.200
    92.815    -0.391     0.200
    92.822    -0.306     0.200
    92.828    -0.311     0.200
    92.828    -0.308     0.200
    93.332     0.086     0.200
    93.924     0.320     0.200
    93.924     0.080     0.200
    93.856     0.144     0.200
    94.434     1.821     0.200
    94.968     0.575     0.200
    95.748     0.257     0.200
    96.050     1.903     0.200
    96.167    -1.488     0.200
    96.189    -0.030     0.200
    96.191    -0.038     0.200
    96.612     0.360     0.200
    18.470    -2.635     0.200
    24.609     0.005     0.200
    24.609     0.010     0.200
    31.885    -0.812     0.200
    47.350    -1.744     0.200
    47.350    -1.745     0.200
    54.548     0.132     0.200
    54.548     0.132     0.200
    59.119    -0.846     0.200
    59.122    -0.869     0.200
    64.071    -1.433     0.200
    64.071    -1.433     0.200
    64.398    -1.229     0.200
    64.398    -0.929     0.200
    65.864    -1.113     0.200
    65.864    -1.112     0.200
    71.001    -0.265     0.200
    74.645    -1.194     0.200
    74.645    -1.199     0.200
    76.692    -0.742     0.200
    81.113     1.323     0.200
    81.113     1.322     0.200
    81.976     0.631     0.200
    83.819     0.707     0.200
    18.326    -2.237     0.200
    24.506    -0.423     0.200
    24.506    -0.418     0.200
    24.435     0.926     0.200
    47.182    -1.734     0.200
    47.182    -1.732     0.200
    54.456     0.048     0.200
    54.456     0.048     0.200
    55.814    -1.719     0.200
    55.814    -1.719     0.200
    63.903    -1.229     0.200
    63.903    -1.234     0.200
    64.230    -0.956     0.200
    64.230    -1.056     0.200
    65.741    -1.073     0.200
    65.741    -1.073     0.200
    70.852    -0.341     0.200
    73.211     0.217     0.200
    74.478    -0.937     0.200
    74.478    -0.937     0.200
    76.524    -0.445     0.200
    79.779     0.094     0.200
    81.832     0.458     0.200
    83.658     0.728     0.200
    83.673     0.481     0.200
    84.997     0.948     0.200
    84.997     0.946     0.200
    23.301     1.861     0.200
    23.301     2.031     0.200
    23.801     1.882     0.200
    24.965     1.230     0.200
    25.569     1.682     0.200
    26.035     1.126     0.200
    26.928     1.834     0.200
    26.963     2.812     0.200
    27.115     1.150     0.200
    27.391     2.483     0.200
    27.451     2.091     0.200
    27.557     1.605     0.200
    27.653     1.783     0.200
    27.787     1.954     0.200
    27.787     2.235     0.200
    27.913     1.911     0.200
    28.375     1.928     0.200
    28.420     2.850     0.200
    28.512     2.024     0.200
    29.020     1.912     0.200
    29.088     1.982     0.200
    29.797     3.001     0.200
    30.054     1.809     0.200
    30.377     2.013     0.200
    31.344    -1.997     0.200
    31.344     0.572     0.200
    32.054     1.660     0.200
    32.399     1.486     0.200
    33.065     1.910     0.200
    33.293     2.490     0.200
    33.331     2.148     0.200
    34.020     0.721     0.200
    34.312     1.544     0.200
    34.742     1.303     0.200
    34.837     1.067     0.200
    34.862     1.366     0.200
    34.862     2.167     0.200
    35.151     1.682     0.200
    35.184     0.830     0.200
    35.312     0.642     0.200
    35.412     1.144     0.200
    35.453     1.069     0.200
    35.498     2.055     0.200
    35.833     1.792     0.200
    35.881     1.253     0.200
    35.886     1.274     0.200
    36.050     1.076     0.200
    36.386     1.731     0.200
    36.386     2.723     0.200
    36.465     1.461     0.200
    36.662     2.048     0.200
    36.730     1.023     0.200
    36.812     0.908     0.200
    36.850     1.343     0.200
    36.994     0.916     0.200
    36.974    -0.482     0.200
    37.108     0.844     0.200
    37.183     2.347     0.200
    37.276     1.410     0.200
    37.297     1.093     0.200
    37.398     2.200     0.200
    37.588     1.693     0.200
    37.647     1.611     0.200
    37.674     1.967     0.200
    37.782     0.632     0.200
    37.782     2.171     0.200
    37.819     1.848     0.200
    37.822     0.585     0.200
    37.840     1.455     0.200
    37.903     0.066     0.200
    37.965     0.800     0.200
    38.070     2.047     0.200
    38.146     3.104     0.200
    38.148     1.595     0.200
    38.168     0.578     0.200
    38.178     1.004     0.200
    38.356     1.589     0.200
    38.372     1.552     0.200
    38.406     1.369     0.200
    38.521     1.202     0.200
    38.530     2.068     0.200
    38.551     0.466     0.200
    38.553     0.494     0.200
    38.580     0.819     0.200
    38.561    -0.389     0.200
    38.592     1.094     0.200
    38.637     0.650     0.200
    38.718     0.204     0.200
    38.737     0.745     0.200
    38.749     0.496     0.200
    38.761     1.261     0.200
    38.794     1.592     0.200
    38.794     2.776     0.200
    38.875     1.047     0.200
    38.892     1.063     0.200
    38.938     1.518     0.200
    38.963     1.974     0.200
    39.241     1.325     0.200
    39.276     1.197     0.200
    39.278     0.965     0.200
    39.322     0.588     0.200
    39.420     1.230     0.200
    39.492     2.823     0.200
    39.500     1.727     0.200
    39.596     0.517     0.200
    39.603     0.743     0.200
    39.650     1.641     0.200
    39.703     0.447     0.200
    39.748     0.614     0.200
    39.748     1.088     0.200
    39.759     1.046     0.200
    39.954     0.544     0.200
    39.963     0.275     0.200
    40.007     2.144     0.200
    40.125     0.787     0.200
    40.220     0.473     0.200
    40.236     0.396     0.200
    40.293     0.071     0.200
    40.306     0.461     0.200
    40.495    -0.120     0.200
    40.538     0.211     0.200
    40.543     0.479     0.200
    40.592     0.372     0.200
    40.681    -0.125     0.200
    40.841     0.241     0.200
    40.970     0.023     0.200
    40.973     0.758     0.200
    40.973     1.824     0.200
    40.996     0.739     0.200
    41.043     0.204     0.200
    41.043     0.160     0.200
    41.088     0.298     0.200
    41.091     0.753     0.200
    41.162    -0.080     0.200
    41.303     0.104     0.200
    41.315     0.060     0.200
    41.433     0.389     0.200
    41.511     0.366     0.200
    41.535     0.262     0.200
    41.574     0.038     0.200
    41.593     0.486     0.200
    41.644     0.520     0.200
    41.731     0.951     0.200
    41.859     0.398     0.200
    41.925     0.619     0.200
    41.942     1.011     0.200
    41.942     1.230     0.200
    41.990     0.284     0.200
    42.135    -0.077     0.200
    42.344     0.385     0.200
    42.361     0.101     0.200
    42.422     1.004     0.200
    42.422     3.090     0.200
    42.515     0.327     0.200
    42.648     0.384     0.200
    42.935     0.424     0.200
    42.957     0.243     0.200
    43.008     0.343     0.200
    43.076     0.700     0.200
    43.139     0.591     0.200
    43.273     0.645     0.200
    43.449     1.477     0.200
    43.449     1.936     0.200
    43.587     0.699     0.200
    43.904     0.400     0.200
    43.961     0.020     0.200
    44.269    -0.037     0.200
    44.422     0.611     0.200
    44.523     0.632     0.200
    44.523     0.471     0.200
    44.523     0.372     0.200
    44.522     0.211     0.200
    44.522     0.885     0.200
    45.422     1.095     0.200
    45.802    -0.387     0.200
    46.194    -0.176     0.200
    46.194     0.026     0.200
    46.322     1.381     0.200
    47.030     0.443     0.200
    47.340     0.062     0.200
    48.162     0.412     0.200
    48.173     0.002     0.200
    48.522     0.997     0.200
    48.850     0.858     0.200
    48.950     0.604     0.200
    49.293     0.914     0.200
    49.427     0.174     0.200
    49.487     0.709     0.200
    49.495     0.135     0.200
    49.684     0.508     0.200
    49.686     0.891     0.200
    49.716     1.075     0.200
    49.716     1.074     0.200
    55.092    -0.437     0.200
    56.111     1.999     0.200
    59.661     0.593     0.200
    62.601     0.466     0.200
    62.748    -2.815     0.200
    62.980     1.043     0.200
    62.980     0.244     0.200
    63.057    -0.369     0.200
    63.109     0.686     0.200
    63.173    -0.335     0.200
    63.173    -0.935     0.200
    63.315     0.593     0.200
    63.516     0.113     0.200
    63.570    -0.161     0.200
    63.570    -0.086     0.200
    63.672     1.162     0.200
    63.693     1.073     0.200
    63.757     0.511     0.200
    63.757     0.306     0.200
    66.126     0.095     0.200
    67.764     0.978     0.200
    68.704     0.390     0.200
    69.404     0.544     0.200
    69.733     0.414     0.200
    70.003     0.857     0.200
    70.699     0.610     0.200
    70.699     0.499     0.200
    70.897    -0.801     0.200
    71.350     0.873     0.200
    71.350     1.254     0.200
    71.882    -0.945     0.200
    72.223    -0.191     0.200
    72.451    -0.853     0.200
    73.372    -0.707     0.200
    73.726    -0.762     0.200
    73.726    -0.268     0.200
    73.734    -0.283     0.200
    73.734    -1.433     0.200
    73.838     0.302     0.200
    74.202     0.128     0.200
    74.255     0.217     0.200
    74.418     0.271     0.200
    74.949     0.394     0.200
    75.104     0.700     0.200
    75.351     0.683     0.200
    75.336     0.607     0.200
    75.465     0.726     0.200
    75.568     0.232     0.200
    75.636     0.744     0.200
    75.813     0.533     0.200
    75.858     0.676     0.200
    75.858    -0.550     0.200
    76.296     0.387     0.200
    76.295     0.089     0.200
    76.867     0.658     0.200
    76.867     0.149     0.200
    77.031     0.136     0.200
    77.595     1.272     0.200
    77.611     0.588     0.200
    77.944    -0.066     0.200
    77.995     0.750     0.200
    78.065     0.226     0.200
    78.336     1.262     0.200
    78.400     0.407     0.200
    78.579    -0.079     0.200
    78.757     0.941     0.200
    78.779     1.266     0.200
    78.779     0.916     0.200
    78.825    -0.134     0.200
    78.963     0.729     0.200
    79.068     1.532     0.200
    79.115     0.573     0.200
    79.103     0.643     0.200
    79.144    -0.086     0.200
    79.157     1.145     0.200
    79.212     0.744     0.200
    79.221     1.394     0.200
    79.298    -0.127     0.200
    79.299     0.968     0.200
    79.321     0.647     0.200
    79.541     0.654     0.200
    79.624     0.799     0.200
    79.636     0.336     0.200
    79.661     0.698     0.200
    79.666     1.272     0.200
    79.699     0.192     0.200
    79.773     1.289     0.200
    79.775     0.979     0.200
    79.977    -0.014     0.200
    80.072    -0.028     0.200
    80.072    -0.288     0.200
    80.076    -0.146     0.200
    80.340     0.729     0.200
    80.340     0.630     0.200
    80.365     0.097     0.200
    80.978     1.091     0.200
    81.109     1.618     0.200
    81.139     2.657     0.200
    82.255     1.870     0.200
    82.468    -0.043     0.200
    84.214     0.669     0.200
    84.214     0.418     0.200
    97.970     0.336     0.200
    16.994     1.320     0.200
    18.255    -1.410     0.200
    19.335     0.761     0.200
    20.124    -0.060     0.200
    23.053     2.408     0.200
    23.502     2.802     0.200
    23.842    -1.005     0.200
    23.842    -0.505     0.200
    23.947     2.710     0.200
    24.348    -0.220     0.200
    24.348     0.651     0.200
    24.348     0.182     0.200
    24.472    -0.414     0.200
    24.481     0.161     0.200
    24.481    -1.585     0.200
    24.433     2.857     0.200
    24.527     2.620     0.200
    24.751     2.083     0.200
    25.015    -1.010     0.200
    24.944     2.576     0.200
    25.172     2.058     0.200
    25.394     1.969     0.200
    25.478     2.592     0.200
    25.530     1.906     0.200
    25.872     2.092     0.200
    25.884     2.125     0.200
    26.070     1.853     0.200
    26.118     2.486     0.200
    26.232    -0.910     0.200
    26.398     1.325     0.200
    26.459     1.309     0.200
    26.871     1.667     0.200
    26.966     1.977     0.200
    26.987     1.785     0.200
    26.999     1.852     0.200
    27.022     1.868     0.200
    27.151     1.444     0.200
    27.238     2.032     0.200
    27.311     2.572     0.200
    27.389     1.579     0.200
    27.858     1.848     0.200
    27.980     1.702     0.200
    28.019     2.506     0.200
    28.019     2.913     0.200
    28.022     2.572     0.200
    28.164     1.233     0.200
    28.405     2.723     0.200
    28.477     2.015     0.200
    28.527     2.068     0.200
    28.561     1.938     0.200
    28.829     1.414     0.200
    28.885     1.951     0.200
    28.944     1.543     0.200
    29.104     1.543     0.200
    29.161     1.820     0.200
    29.269     2.581     0.200
    29.289     1.554     0.200
    29.383     1.392     0.200
    29.493     1.617     0.200
    29.577     1.659     0.200
    29.877     2.371     0.200
    29.978     0.883     0.200
    29.978     1.446     0.200
    30.169     1.184     0.200
    30.327     1.001     0.200
    30.875     1.965     0.200
    30.885     1.903     0.200
    31.254     1.764     0.200
    31.396     1.613     0.200
    31.653    -0.940     0.200
    31.576     1.972     0.200
    31.599     1.229     0.200
    31.731     0.777     0.200
    31.742     1.513     0.200
    31.854     1.940     0.200
    31.997     0.598     0.200
    31.997     0.481     0.200
    32.052     2.420     0.200
    32.184     1.840     0.200
    32.558     1.482     0.200
    32.740     1.895     0.200
    32.740     2.051     0.200
    32.822     2.432     0.200
    32.844     1.781     0.200
    32.916     1.739     0.200
    32.921     2.139     0.200
    32.912     2.178     0.200
    33.013     2.113     0.200
    33.005     1.157     0.200
    33.297    -1.286     0.200
    33.297    -1.184     0.200
    33.307     0.837     0.200
    33.307     3.099     0.200
    33.307     3.027     0.200
    33.397     2.345     0.200
    33.423     2.560     0.200
    33.476     2.334     0.200
    33.679    -0.210     0.200
    33.697     1.239     0.200
    33.630     1.794     0.200
    33.630     1.568     0.200
    33.586     2.200     0.200
    33.656     1.993     0.200
    33.791    -1.081     0.200
    33.731     1.669     0.200
    33.767     2.056     0.200
    33.753     1.243     0.200
    33.773     1.279     0.200
    33.998     2.222     0.200
    34.060     2.185     0.200
    34.046     2.279     0.200
    34.158     1.407     0.200
    34.221     2.018     0.200
    34.278     2.404     0.200
    34.331     1.942     0.200
    34.331     1.500     0.200
    34.472     1.617     0.200
    34.472     1.832     0.200
    34.462     1.751     0.200
    34.462     2.378     0.200
    34.664     1.992     0.200
    34.664     2.461     0.200
    34.667     1.938     0.200
    34.824     0.883     0.200
    34.868     2.267     0.200
    34.851     2.302     0.200
    34.886     0.937     0.200
    34.886     1.198     0.200
    34.886     1.196     0.200
    34.886     1.095     0.200
    34.884     2.169     0.200
    34.938     2.101     0.200
    34.938     1.957     0.200
    34.992     0.806     0.200
    35.141     0.449     0.200
    35.110     2.092     0.200
    35.180     2.369     0.200
    35.188     2.129     0.200
    35.198     1.746     0.200
    35.247     2.237     0.200
    35.230     1.867     0.200
    35.263     1.814     0.200
    35.263     2.435     0.200
    35.324     0.996     0.200
    35.455    -1.647     0.200
    35.455    -1.416     0.200
    35.393     2.193     0.200
    35.455     1.937     0.200
    35.466     1.689     0.200
    35.579     1.279     0.200
    35.578     2.644     0.200
    35.613     0.793     0.200
    35.718     0.902     0.200
    35.718     1.062     0.200
    35.609     2.980     0.200
    35.676     2.053     0.200
    35.786     1.255     0.200
    35.746     1.544     0.200
    35.815     2.005     0.200
    35.815     1.868     0.200
    35.856     1.199     0.200
    35.857     2.082     0.200
    35.857     1.500     0.200
    35.867     1.946     0.200
    35.889     1.485     0.200
    35.919     2.273     0.200
    36.011     3.118     0.200
    36.022     1.754     0.200
    36.128     2.164     0.200
    36.167     1.081     0.200
    36.180     1.390     0.200
    36.161     2.910     0.200
    36.185     2.479     0.200
    36.174     1.479     0.200
    36.209     2.066     0.200
    36.314     1.152     0.200
    36.335     2.503     0.200
    36.342     1.585     0.200
    36.423     1.095     0.200
    36.423     2.012     0.200
    36.480     1.678     0.200
    36.461     2.558     0.200
    36.480     2.732     0.200
    36.516     2.195     0.200
    36.517     2.236     0.200
    36.561     1.436     0.200
    36.589     1.222     0.200
    36.591     2.250     0.200
    36.705     0.706     0.200
    36.705     1.085     0.200
    36.703     2.394     0.200
    36.728     0.922     0.200
    36.789     1.048     0.200
    36.829     2.418     0.200
    36.832     2.090     0.200
    36.891     0.900     0.200
    36.881     3.056     0.200
    36.934     0.962     0.200
    36.925     1.895     0.200
    36.970     1.301     0.200
    36.974     2.310     0.200
    37.154     0.757     0.200
    37.172     1.252     0.200
    37.184     1.333     0.200
    37.225     1.267     0.200
    37.225     1.158     0.200
    37.223     1.678     0.200
    37.259     0.733     0.200
    37.257     1.486     0.200
    37.257     1.709     0.200
    37.326     1.020     0.200
    37.339     0.672     0.200
    37.339     1.221     0.200
    37.333     0.992     0.200
    37.333     1.332     0.200
    37.379     1.071     0.200
    37.475     0.234     0.200
    37.460     0.720     0.200
    37.446     2.032     0.200
    37.546     2.461     0.200
    37.581     1.741     0.200
    37.597     1.933     0.200
    37.657     0.474     0.200
    37.645     0.784     0.200
    37.665     1.173     0.200
    37.668     1.030     0.200
    37.807     0.464     0.200
    37.782     1.408     0.200
    37.818     1.652     0.200
    37.841     1.918     0.200
    37.914     0.662     0.200
    37.916     1.619     0.200
    37.952     0.889     0.200
    37.999     0.877     0.200
    38.029     1.098     0.200
    38.032     0.683     0.200
    38.034     1.620     0.200
    38.119     1.034     0.200
    38.121     1.814     0.200
    38.159     1.113     0.200
    38.159     1.672     0.200
    38.176     0.731     0.200
    38.254     0.494     0.200
    38.263     0.450     0.200
    38.259     0.616     0.200
    38.228     1.930     0.200
    38.228     2.059     0.200
    38.272     0.732     0.200
    38.271     0.729     0.200
    38.304     0.562     0.200
    38.389     0.877     0.200
    38.463     1.019     0.200
    38.463     0.819     0.200
    38.424     0.934     0.200
    38.440     0.686     0.200
    38.488     1.489     0.200
    38.587     0.723     0.200
    38.615     0.390     0.200
    38.607     0.669     0.200
    38.580     1.969     0.200
    38.661     0.453     0.200
    38.707     0.518     0.200
    38.700     1.243     0.200
    38.716     2.418     0.200
    38.915     0.556     0.200
    38.932     0.369     0.200
    38.919     0.901     0.200
    38.935     0.872     0.200
    38.940     1.471     0.200
    39.037     0.261     0.200
    39.051     0.314     0.200
    39.150    -2.035     0.200
    39.069     1.056     0.200
    39.069     1.846     0.200
    39.094     0.754     0.200
    39.165     1.475     0.200
    39.165     1.299     0.200
    39.252     0.264     0.200
    39.246     0.325     0.200
    39.262     0.289     0.200
    39.253     0.797     0.200
    39.357     0.365     0.200
    39.357     0.256     0.200
    39.392    -0.057     0.200
    39.393     0.639     0.200
    39.381     1.758     0.200
    39.413     0.587     0.200
    39.456     0.159     0.200
    39.471     2.711     0.200
    39.522     0.365     0.200
    39.681     0.134     0.200
    39.717     0.285     0.200
    39.755     2.884     0.200
    39.755     1.353     0.200
    39.783     0.880     0.200
    39.920    -1.543     0.200
    39.862     0.356     0.200
    39.912     0.266     0.200
    39.894     1.445     0.200
    39.894     1.574     0.200
    39.918     0.655     0.200
    39.934     1.860     0.200
    39.934     1.172     0.200
    39.977     0.583     0.200
    40.038     0.114     0.200
    40.080     0.060     0.200
    40.166     0.379     0.200
    40.242     0.168     0.200
    40.254     0.191     0.200
    40.236     2.413     0.200
    40.307     0.875     0.200
    40.326     0.220     0.200
    40.376     1.066     0.200
    40.411     0.662     0.200
    40.429     0.203     0.200
    40.511    -1.333     0.200
    40.488     0.077     0.200
    40.519     1.134     0.200
    40.523     1.347     0.200
    40.563    -0.038     0.200
    40.649     1.258     0.200
    40.736     0.092     0.200
    40.737     0.277     0.200
    40.756     0.413     0.200
    40.783     0.121     0.200
    40.874     0.162     0.200
    41.018     0.176     0.200
    41.017     0.017     0.200
    41.060     0.467     0.200
    41.220    -0.464     0.200
    41.167    -0.044     0.200
    41.180     0.391     0.200
    41.170     0.433     0.200
    41.211    -0.053     0.200
    41.292    -0.026     0.200
    41.323     0.083     0.200
    41.315     1.507     0.200
    41.380    -0.352     0.200
    41.408     0.721     0.200
    41.394     0.745     0.200
    41.394     2.311     0.200
    41.490     0.187     0.200
    41.509     0.315     0.200
    41.569     0.078     0.200
    41.566     1.514     0.200
    41.566     1.725     0.200
    41.591     0.243     0.200
    41.680    -0.215     0.200
    41.696     0.260     0.200
    41.743    -0.059     0.200
    41.836     0.476     0.200
    41.867     0.476     0.200
    41.905     0.001     0.200
    41.913    -0.633     0.200
    41.941     0.456     0.200
    41.948     0.058     0.200
    41.932     1.085     0.200
    41.932     2.093     0.200
    41.932     1.612     0.200
    41.931     2.024     0.200
    41.991     0.808     0.200
    42.078     0.345     0.200
    42.087     0.308     0.200
    42.177     0.508     0.200
    42.197     0.077     0.200
    42.220     0.584     0.200
    42.277     0.377     0.200
    42.297     0.829     0.200
    42.306     0.253     0.200
    42.293     2.416     0.200
    42.334    -0.339     0.200
    42.348     0.415     0.200
    42.405     2.256     0.200
    42.450     0.337     0.200
    42.521    -0.178     0.200
    42.638     0.410     0.200
    42.636     0.490     0.200
    42.658     0.796     0.200
    42.705    -0.073     0.200
    42.734     0.452     0.200
    42.755    -0.025     0.200
    42.879     0.318     0.200
    42.943     0.160     0.200
    42.926     3.145     0.200
    42.926     1.813     0.200
    42.961    -0.008     0.200
    42.939     2.680     0.200
    42.979     0.145     0.200
    43.103     0.130     0.200
    43.110     1.029     0.200
    43.128     0.454     0.200
    43.135     0.392     0.200
    43.218     0.702     0.200
    43.217     0.016     0.200
    43.219     0.350     0.200
    43.307     0.447     0.200
    43.320    -0.123     0.200
    43.415    -1.111     0.200
    43.498     0.146     0.200
    43.598    -0.054     0.200
    43.611    -0.073     0.200
    43.656     0.449     0.200
    43.670     0.197     0.200
    43.667     0.649     0.200
    43.823    -0.125     0.200
    43.797     0.785     0.200
    43.863     0.446     0.200
    43.886     0.257     0.200
    43.935     0.044     0.200
    43.971    -0.151     0.200
    43.966     0.491     0.200
    44.084     0.649     0.200
    44.079     0.368     0.200
    44.158    -0.476     0.200
    44.171     0.079     0.200
    44.267     0.009     0.200
    44.379    -1.845     0.200
    44.285    -0.020     0.200
    44.323     0.050     0.200
    44.327    -0.417     0.200
    44.345     0.188     0.200
    44.331     0.614     0.200
    44.479    -0.347     0.200
    44.479    -0.706     0.200
    44.409     1.668     0.200
    44.461     0.307     0.200
    44.502     0.377     0.200
    44.536     0.030     0.200
    44.625     0.712     0.200
    44.642     0.278     0.200
    44.697     0.364     0.200
    44.721     0.401     0.200
    44.721     1.268     0.200
    44.760     0.137     0.200
    44.759     0.066     0.200
    44.748     0.640     0.200
    44.748     1.655     0.200
    44.769     0.484     0.200
    44.920     0.247     0.200
    44.889     0.484     0.200
    44.972     0.529     0.200
    44.973     0.579     0.200
    44.973     0.225     0.200
    44.973     0.498     0.200
    44.973     0.428     0.200
    44.911     1.971     0.200
    44.941     0.429     0.200
    44.955     0.311     0.200
    44.966     0.464     0.200
    45.102     0.348     0.200
    45.161     0.057     0.200
    45.155     0.180     0.200
    45.202    -0.363     0.200
    45.209     0.674     0.200
    45.379    -0.126     0.200
    45.397     0.124     0.200
    45.462    -0.281     0.200
    45.475     0.116     0.200
    45.495     0.095     0.200
    45.648     0.431     0.200
    45.671    -0.219     0.200
    45.683     0.392     0.200
    45.771    -0.386     0.200
    45.809    -0.150     0.200
    45.804     0.179     0.200
    45.852    -0.365     0.200
    45.846     0.054     0.200
    45.872    -0.160     0.200
    45.954    -0.535     0.200
    45.953     0.828     0.200
    46.013     0.206     0.200
    46.013     0.366     0.200
    46.013     0.330     0.200
    46.095    -0.370     0.200
    46.111    -0.133     0.200
    46.245     0.581     0.200
    46.283    -0.616     0.200
    46.234    -0.226     0.200
    46.246    -0.253     0.200
    46.265    -0.711     0.200
    46.266    -0.094     0.200
    46.381     0.638     0.200
    46.489     0.693     0.200
    46.498     0.261     0.200
    46.544    -0.418     0.200
    46.446     0.053     0.200
    46.446     0.565     0.200
    46.581     0.544     0.200
    46.581     0.126     0.200
    46.496     0.714     0.200
    46.513    -0.834     0.200
    46.521    -0.070     0.200
    46.529    -0.288     0.200
    46.647    -0.689     0.200
    46.786    -0.455     0.200
    46.715    -0.338     0.200
    46.722     0.448     0.200
    46.722     1.002     0.200
    46.798     0.484     0.200
    46.820    -0.659     0.200
    46.879    -1.072     0.200
    46.888     0.141     0.200
    47.060    -0.488     0.200
    47.017    -0.227     0.200
    47.037    -0.294     0.200
    47.080    -0.166     0.200
    47.108     0.055     0.200
    47.140     0.294     0.200
    47.280     0.193     0.200
    47.262    -1.139     0.200
    47.287    -1.447     0.200
    47.298     0.172     0.200
    47.367    -0.569     0.200
    47.385    -0.054     0.200
    47.385     0.168     0.200
    47.386     0.044     0.200
    47.424    -0.260     0.200
    47.456    -0.477     0.200
    47.575     0.144     0.200
    47.575     0.402     0.200
    47.575     0.281     0.200
    47.524     0.410     0.200
    47.524     0.961     0.200
    47.555    -1.511     0.200
    47.548     0.003     0.200
    47.644     0.417     0.200
    47.657     1.234     0.200
    47.658     1.209     0.200
    47.681     0.079     0.200
    47.741    -1.537     0.200
    47.778    -0.599     0.200
    47.779    -0.066     0.200
    47.820    -0.630     0.200
    47.873    -0.178     0.200
    47.953     0.496     0.200
    47.976     0.176     0.200
    47.987    -0.935     0.200
    48.014     0.107     0.200
    48.015     2.439     0.200
    48.087    -1.236     0.200
    48.096     0.689     0.200
    48.138     0.255     0.200
    48.186    -0.643     0.200
    48.213    -0.419     0.200
    48.378    -1.086     0.200
    48.359     2.240     0.200
    48.389    -1.304     0.200
    48.387     0.174     0.200
    48.395     0.075     0.200
    48.461     0.218     0.200
    48.565     0.465     0.200
    48.634     1.248     0.200
    48.655     0.168     0.200
    48.667    -0.421     0.200
    48.712     0.166     0.200
    48.755    -0.995     0.200
    48.819     0.186     0.200
    48.844     0.431     0.200
    48.859     0.407     0.200
    48.858     0.307     0.200
    48.856    -0.073     0.200
    48.902     0.174     0.200
    49.012     0.440     0.200
    49.044    -0.301     0.200
    49.163    -1.061     0.200
    49.221     0.100     0.200
    49.216     0.052     0.200
    49.245     0.521     0.200
    49.245     0.810     0.200
    49.280     0.561     0.200
    49.344     0.101     0.200
    49.408     0.041     0.200
    49.422     0.540     0.200
    49.426     0.123     0.200
    49.456    -0.393     0.200
    49.622     0.179     0.200
    49.634     0.969     0.200
    49.628     0.003     0.200
    49.645     0.501     0.200
    49.744     0.348     0.200
    49.807    -0.152     0.200
    49.756     0.365     0.200
    49.767    -0.052     0.200
    49.772     0.787     0.200
    49.793     0.149     0.200
    49.782     0.479     0.200
    49.808     0.466     0.200
    49.790    -0.860     0.200
    49.784     0.652     0.200
    49.807    -0.566     0.200
    49.834    -0.593     0.200
    49.872    -0.750     0.200
    49.940    -0.849     0.200
    50.042     0.643     0.200
    50.062     0.679     0.200
    50.095    -0.722     0.200
    50.110    -0.001     0.200
    50.120     0.473     0.200
    50.248     0.685     0.200
    50.218    -0.302     0.200
    50.133    -0.052     0.200
    50.171    -0.145     0.200
    50.248     1.434     0.200
    50.248     0.735     0.200
    50.181    -0.152     0.200
    50.187     0.150     0.200
    50.219     0.164     0.200
    50.307     0.060     0.200
    50.373    -0.114     0.200
    50.507     0.468     0.200
    50.512     0.868     0.200
    50.555    -0.190     0.200
    50.526     0.765     0.200
    50.573     0.051     0.200
    50.561     0.934     0.200
    50.582     0.601     0.200
    50.622     0.812     0.200
    50.630     0.813     0.200
    50.647     0.825     0.200
    50.657     0.526     0.200
    50.772     0.334     0.200
    50.665     0.855     0.200
    50.926     0.994     0.200
    50.926     1.131     0.200
    50.860     1.033     0.200
    50.864     1.017     0.200
    50.887     1.172     0.200
    50.946     0.597     0.200
    50.948     1.092     0.200
    50.949     0.980     0.200
    51.001     0.342     0.200
    50.993     0.669     0.200
    51.006     0.832     0.200
    51.025     0.700     0.200
    51.025     1.236     0.200
    51.159    -0.225     0.200
    51.165     0.127     0.200
    51.337    -0.161     0.200
    51.302     1.492     0.200
    51.315     1.167     0.200
    51.338     0.593     0.200
    51.335     1.662     0.200
    51.373     1.337     0.200
    51.400     0.724     0.200
    51.480     0.246     0.200
    51.471     1.243     0.200
    51.497     0.843     0.200
    51.627     1.016     0.200
    51.599    -0.407     0.200
    51.602     0.305     0.200
    51.677     0.483     0.200
    51.685     0.975     0.200
    51.690     0.607     0.200
    51.722     0.537     0.200
    51.724     0.963     0.200
    51.777     0.155     0.200
    51.784     1.478     0.200
    51.789     1.101     0.200
    51.835     0.681     0.200
    51.918     0.028     0.200
    51.936    -0.517     0.200
    51.913     1.418     0.200
    51.930     0.250     0.200
    51.977     0.119     0.200
    52.038    -0.289     0.200
    52.158     0.099     0.200
    52.240    -1.289     0.200
    52.178     1.028     0.200
    52.199     0.811     0.200
    52.208     0.460     0.200
    52.211     1.250     0.200
    52.229     0.879     0.200
    52.228     1.362     0.200
    52.248     0.679     0.200
    52.308     1.385     0.200
    52.347     0.243     0.200
    52.429    -0.151     0.200
    52.515    -0.210     0.200
    52.564    -0.579     0.200
    52.603     0.064     0.200
    52.618     0.204     0.200
    52.719     0.169     0.200
    52.654     0.806     0.200
    52.658     2.274     0.200
    52.722    -0.461     0.200
    52.704     0.149     0.200
    52.745     1.146     0.200
    52.766     0.866     0.200
    52.808    -0.063     0.200
    52.910    -0.442     0.200
    52.910    -0.051     0.200
    52.824     0.643     0.200
    53.027    -0.627     0.200
    53.041     1.120     0.200
    53.072     0.389     0.200
    53.083     1.207     0.200
    53.126    -0.210     0.200
    53.127    -0.087     0.200
    53.128     0.263     0.200
    53.262     0.062     0.200
    53.382     0.086     0.200
    53.386    -0.919     0.200
    53.369    -0.338     0.200
    53.359     1.789     0.200
    53.418     0.472     0.200
    53.450    -1.127     0.200
    53.506    -0.734     0.200
    53.512     0.525     0.200
    53.565    -0.055     0.200
    53.602     0.093     0.200
    53.756    -0.487     0.200
    53.892    -0.064     0.200
    53.985    -0.223     0.200
    54.001    -0.236     0.200
    54.001    -0.115     0.200
    53.919    -0.769     0.200
    53.978    -0.706     0.200
    54.094    -0.011     0.200
    54.025    -0.367     0.200
    54.022     0.348     0.200
    54.050     0.200     0.200
    54.083    -0.300     0.200
    54.134    -0.554     0.200
    54.180    -0.739     0.200
    54.284    -0.199     0.200
    54.324    -0.509     0.200
    54.337     0.139     0.200
    54.261     0.961     0.200
    54.273     0.924     0.200
    54.287     0.578     0.200
    54.288     0.251     0.200
    54.363     0.165     0.200
    54.404    -0.569     0.200
    54.487    -1.205     0.200
    54.617    -1.736     0.200
    54.755    -0.153     0.200
    54.787     0.282     0.200
    54.886    -0.059     0.200
    54.807     0.248     0.200
    54.905    -1.102     0.200
    55.014     0.004     0.200
    54.999     0.586     0.200
    55.073     0.633     0.200
    55.151     0.030     0.200
    55.165     0.427     0.200
    55.192     0.372     0.200
    55.242    -0.374     0.200
    55.425    -0.946     0.200
    55.370    -0.529     0.200
    55.423    -0.289     0.200
    55.453     0.255     0.200
    55.511    -0.012     0.200
    55.521    -0.092     0.200
    55.546     0.545     0.200
    55.667    -0.576     0.200
    55.689    -1.769     0.200
    55.689    -1.164     0.200
    55.689    -0.770     0.200
    55.689    -1.122     0.200
    55.819     0.199     0.200
    55.833     0.248     0.200
    55.934     0.410     0.200
    56.060     0.191     0.200
    56.075    -0.097     0.200
    56.102    -1.283     0.200
    56.145    -0.579     0.200
    56.262    -1.130     0.200
    56.215    -1.601     0.200
    56.538     1.500     0.200
    56.538     1.222     0.200
    56.473    -0.125     0.200
    56.747     0.422     0.200
    56.894    -0.826     0.200
    57.001    -0.157     0.200
    57.098    -1.741     0.200
    57.138    -0.150     0.200
    57.302    -1.102     0.200
    57.338    -0.400     0.200
    57.727    -0.296     0.200
    57.814     1.178     0.200
    57.818    -0.112     0.200
    58.291    -1.521     0.200
    58.441     0.358     0.200
    58.580     1.147     0.200
    58.654     0.430     0.200
    58.713    -0.581     0.200
    58.860    -0.473     0.200
    58.884    -0.219     0.200
    59.085    -1.810     0.200
    59.255     0.267     0.200
    60.302    -0.023     0.200
    60.653    -0.771     0.200
    61.859    -1.649     0.200
    62.389    -0.075     0.200
    62.660    -0.531     0.200
    62.744     0.224     0.200
    62.911     0.103     0.200
    63.180    -0.340     0.200
    63.216     0.181     0.200
    63.398    -0.723     0.200
    63.438    -0.041     0.200
    63.622    -0.000     0.200
    63.509     0.074     0.200
    63.633     0.245     0.200
    63.693    -0.191     0.200
    63.703    -0.036     0.200
    63.694    -1.033     0.200
    63.776    -0.664     0.200
    63.777    -0.772     0.200
    63.781    -0.250     0.200
    63.856    -0.568     0.200
    63.860    -0.320     0.200
    63.934    -0.184     0.200
    64.028     0.320     0.200
    64.061    -0.168     0.200
    64.087    -1.334     0.200
    64.101    -0.204     0.200
    64.106    -0.115     0.200
    64.112    -0.324     0.200
    64.112    -0.324     0.200
    64.064     0.082     0.200
    64.293    -1.055     0.200
    64.296    -0.188     0.200
    64.364    -0.268     0.200
    64.410    -0.773     0.200
    64.413    -0.091     0.200
    64.413     0.038     0.200
    64.405    -0.035     0.200
    64.431    -0.640     0.200
    64.458    -0.688     0.200
    64.473    -0.588     0.200
    64.423     1.719     0.200
    64.928    -0.787     0.200
    64.970     0.057     0.200
    65.047     0.726     0.200
    65.191     0.125     0.200
    65.249    -0.032     0.200
    65.262     0.304     0.200
    65.293     0.336     0.200
    65.420     0.084     0.200
    65.420     0.264     0.200
    65.443     0.343     0.200
    65.457     0.156     0.200
    65.560    -0.410     0.200
    65.609    -0.760     0.200
    65.609    -0.589     0.200
    65.609    -0.682     0.200
    65.646    -0.104     0.200
    65.718    -0.740     0.200
    65.808     0.082     0.200
    65.801    -0.474     0.200
    65.852     0.679     0.200
    65.871    -0.091     0.200
    66.065     0.222     0.200
    66.169     0.014     0.200
    66.253     0.157     0.200
    66.264     0.444     0.200
    66.327     0.161     0.200
    66.562     0.017     0.200
    66.575     0.229     0.200
    66.734    -0.469     0.200
    66.729     0.165     0.200
    67.016     0.091     0.200
    67.303     0.164     0.200
    67.281    -0.119     0.200
    67.471     0.281     0.200
    67.816     0.049     0.200
    67.888    -0.084     0.200
    67.954    -0.377     0.200
    67.969    -0.046     0.200
    68.104     0.149     0.200
    68.389     0.798     0.200
    68.475     0.106     0.200
    68.475     0.356     0.200
    68.475     0.484     0.200
    68.550    -0.081     0.200
    68.579     0.611     0.200
    68.624    -1.372     0.200
    68.618     0.357     0.200
    68.691     0.010     0.200
    68.700     0.009     0.200
    68.846    -0.258     0.200
    69.034     0.258     0.200
    68.987     1.491     0.200
    69.120     0.260     0.200
    69.198     0.244     0.200
    69.240     1.370     0.200
    69.352    -0.885     0.200
    69.352    -0.744     0.200
    69.337     0.417     0.200
    69.320     0.821     0.200
    69.403     0.003     0.200
    69.518    -0.109     0.200
    70.012     0.775     0.200
    70.012     0.791     0.200
    70.112    -0.263     0.200
    70.177    -0.361     0.200
    70.186    -0.790     0.200
    70.289    -0.543     0.200
    70.324     0.645     0.200
    70.339     0.372     0.200
    70.379    -0.150     0.200
    70.385     0.340     0.200
    70.402     2.495     0.200
    70.571    -0.251     0.200
    70.592     1.005     0.200
    70.642    -0.693     0.200
    70.670     0.503     0.200
    70.667     0.342     0.200
    70.691     1.307     0.200
    70.715    -0.038     0.200
    70.715     0.201     0.200
    70.781     0.422     0.200
    70.788     0.201     0.200
    70.728     0.153     0.200
    70.787     0.094     0.200
    70.839     0.399     0.200
    71.067     0.963     0.200
    71.246     0.085     0.200
    71.303    -0.811     0.200
    71.270     0.249     0.200
    71.269     0.966     0.200
    71.309     0.276     0.200
    71.421     0.886     0.200
    71.467    -0.201     0.200
    71.555    -0.821     0.200
    71.555    -0.520     0.200
    71.661     1.883     0.200
    71.737     0.258     0.200
    71.858    -0.039     0.200
    71.918     0.388     0.200
    71.928     0.883     0.200
    72.008     0.953     0.200
    72.072     0.574     0.200
    72.072     0.926     0.200
    72.070     0.068     0.200
    72.052    -0.321     0.200
    72.129    -0.057     0.200
    72.313     0.843     0.200
    72.306    -0.047     0.200
    72.377     0.484     0.200
    72.309     1.070     0.200
    72.432    -2.467     0.200
    72.490     0.473     0.200
    72.550    -1.072     0.200
    72.550    -0.873     0.200
    72.652     0.404     0.200
    72.884    -0.651     0.200
    72.884    -0.350     0.200
    72.874     0.228     0.200
    72.922     0.320     0.200
    73.015     0.982     0.200
    73.076    -0.091     0.200
    73.076     0.210     0.200
    73.112     0.210     0.200
    73.119    -0.280     0.200
    73.156     0.477     0.200
    73.290     0.569     0.200
    73.519     0.701     0.200
    73.917    -0.030     0.200
    73.937     0.243     0.200
    73.992     0.264     0.200
    74.089     0.498     0.200
    74.024     1.972     0.200
    74.152     0.416     0.200
    74.276     0.369     0.200
    74.232     0.652     0.200
    74.349    -0.363     0.200
    74.349    -0.648     0.200
    74.357    -0.693     0.200
    74.376    -0.934     0.200
    74.388     0.243     0.200
    74.442     1.313     0.200
    74.487     0.062     0.200
    74.528     0.233     0.200
    74.604    -0.005     0.200
    74.604     0.436     0.200
    74.603     0.258     0.200
    74.755     0.700     0.200
    74.816     0.347     0.200
    74.718     1.812     0.200
    74.777     1.773     0.200
    74.965     0.786     0.200
    74.980     0.598     0.200
    75.029    -0.089     0.200
    75.029     1.879     0.200
    75.102     1.117     0.200
    75.102     0.796     0.200
    75.145     0.302     0.200
    75.145     0.024     0.200
    75.118     2.006     0.200
    75.265     0.464     0.200
    75.276     0.799     0.200
    75.294     0.294     0.200
    75.376     0.522     0.200
    75.444     0.835     0.200
    75.477    -0.253     0.200
    75.521     0.390     0.200
    75.575     1.081     0.200
    75.575     0.284     0.200
    75.699     0.714     0.200
    75.699     0.874     0.200
    75.808     2.550     0.200
    75.808     1.750     0.200
    75.920     0.814     0.200
    75.938     1.212     0.200
    75.945     0.745     0.200
    76.029     1.097     0.200
    76.116     0.801     0.200
    76.215     1.538     0.200
    76.232     0.243     0.200
    76.406     0.654     0.200
    76.406     0.455     0.200
    76.406     0.353     0.200
    76.414    -0.671     0.200
    76.450     0.704     0.200
    76.512     0.956     0.200
    76.608     0.416     0.200
    76.608     0.193     0.200
    76.627     0.706     0.200
    76.708    -1.553     0.200
    76.837     1.519     0.200
    76.871     0.532     0.200
    76.880     0.482     0.200
    76.961     0.023     0.200
    76.986     0.682     0.200
    77.204     0.461     0.200
    77.196     0.146     0.200
    77.196    -0.635     0.200
    77.393     0.988     0.200
    77.422     0.728     0.200
    77.448     1.899     0.200
    77.448     0.997     0.200
    77.457     0.847     0.200
    77.478     0.130     0.200
    77.610     0.495     0.200
    77.614     0.748     0.200
    77.637     0.539     0.200
    77.638     0.434     0.200
    77.653     1.052     0.200
    77.608     0.502     0.200
    77.608     1.213     0.200
    77.757     0.989     0.200
    77.776     0.845     0.200
    77.847     0.373     0.200
    77.882     0.977     0.200
    77.887     1.115     0.200
    77.821    -0.113     0.200
    77.821     0.219     0.200
    77.946     0.823     0.200
    77.998     1.532     0.200
    78.064     0.167     0.200
    78.064     0.468     0.200
    78.061     1.239     0.200
    78.076     0.999     0.200
    78.156     1.266     0.200
    78.199     1.024     0.200
    78.446     1.306     0.200
    78.448     0.699     0.200
    78.385     1.293     0.200
    78.457     1.101     0.200
    78.478     1.074     0.200
    78.531     1.058     0.200
    78.595     0.740     0.200
    78.616     0.585     0.200
    78.623     0.081     0.200
    78.619     0.914     0.200
    78.664     0.758     0.200
    78.675     0.600     0.200
    78.744     0.314     0.200
    78.771     1.013     0.200
    78.850    -0.161     0.200
    78.871     0.620     0.200
    78.882     0.521     0.200
    78.894     0.695     0.200
    78.972     0.270     0.200
    79.141     1.444     0.200
    79.056    -1.076     0.200
    79.236     0.285     0.200
    79.286     0.753     0.200
    79.286     0.151     0.200
    79.314     1.099     0.200
    79.334     1.193     0.200
    79.400     1.633     0.200
    79.408    -0.512     0.200
    79.387     0.303     0.200
    79.430     1.665     0.200
    79.459     0.972     0.200
    79.459     0.812     0.200
    79.446     1.281     0.200
    79.520     1.279     0.200
    79.610     1.087     0.200
    79.620     1.033     0.200
    79.563     0.844     0.200
    79.563     0.406     0.200
    79.644     0.932     0.200
    79.648     0.382     0.200
    79.579     0.278     0.200
    79.706     0.866     0.200
    79.727     0.655     0.200
    79.727     0.854     0.200
    79.735     0.616     0.200
    79.751     1.426     0.200
    79.786     1.734     0.200
    79.758     1.186     0.200
    79.799     0.245     0.200
    79.820     1.253     0.200
    79.842     1.036     0.200
    79.854     0.471     0.200
    79.861     1.000     0.200
    79.905     0.893     0.200
    79.877     1.641     0.200
    79.921     0.110     0.200
    79.835     0.762     0.200
    79.975     2.213     0.200
    79.981     0.782     0.200
    79.912     0.431     0.200
    80.030     1.719     0.200
    80.069     0.305     0.200
    80.140     1.125     0.200
    80.083     0.473     0.200
    80.176     1.329     0.200
    80.227     0.957     0.200
    80.257     1.298     0.200
    80.287     0.031     0.200
    80.270     0.624     0.200
    80.350     0.593     0.200
    80.351     0.687     0.200
    80.383     0.714     0.200
    80.397     0.813     0.200
    80.419     1.522     0.200
    80.462     0.993     0.200
    80.475     0.650     0.200
    80.523     1.266     0.200
    80.534     0.810     0.200
    80.527     0.344     0.200
    80.534     0.605     0.200
    80.568     0.626     0.200
    80.547     0.937     0.200
    80.593     2.500     0.200
    80.620     0.947     0.200
    80.620    -0.151     0.200
    80.618     0.156     0.200
    80.654     1.312     0.200
    80.655     1.160     0.200
    80.662     0.523     0.200
    80.600     1.073     0.200
    80.671    -0.024     0.200
    80.672    -0.032     0.200
    80.672     0.070     0.200
    80.672     0.437     0.200
    80.730     0.058     0.200
    80.726     0.238     0.200
    80.720     0.414     0.200
    80.768     1.258     0.200
    80.789     0.583     0.200
    80.782     1.581     0.200
    80.833     1.110     0.200
    80.839     0.078     0.200
    80.905     0.317     0.200
    80.913     1.184     0.200
    80.928    -0.094     0.200
    80.934     0.872     0.200
    80.963     0.616     0.200
    81.009     0.525     0.200
    80.995     0.846     0.200
    81.031     0.655     0.200
    81.033     0.643     0.200
    81.032     0.852     0.200
    81.081     1.187     0.200
    81.087     0.757     0.200
    81.022     0.025     0.200
    81.195    -0.117     0.200
    81.211    -0.503     0.200
    81.203     1.139     0.200
    81.255     1.644     0.200
    81.268     0.295     0.200
    81.227     1.513     0.200
    81.328     0.742     0.200
    81.314     1.453     0.200
    81.364     0.887     0.200
    81.364     0.388     0.200
    81.407     2.035     0.200
    81.528     0.819     0.200
    81.557     1.067     0.200
    81.583     0.829     0.200
    81.696     1.213     0.200
    81.739     0.508     0.200
    81.793     1.523     0.200
    81.793     1.785     0.200
    81.724     1.585     0.200
    81.746     0.833     0.200
    81.817     1.099     0.200
    81.826     1.152     0.200
    81.854     0.604     0.200
    81.783     0.404     0.200
    81.916     2.560     0.200
    81.936     0.877     0.200
    81.847     0.611     0.200
    81.944     0.127     0.200
    81.947    -0.085     0.200
    82.037     0.942     0.200
    81.990     0.501     0.200
    82.163     0.585     0.200
    82.168    -0.085     0.200
    82.083    -0.429     0.200
    82.192     1.131     0.200
    82.277     1.887     0.200
    82.282     0.872     0.200
    82.462     0.323     0.200
    82.483    -0.218     0.200
    82.494     0.853     0.200
    82.388     0.857     0.200
    82.417    -0.441     0.200
    82.422     0.750     0.200
    82.479    -0.067     0.200
    82.553     0.349     0.200
    82.599     0.209     0.200
    82.642     1.385     0.200
    82.712     0.621     0.200
    82.735     0.500     0.200
    82.744     0.655     0.200
    82.771     0.515     0.200
    82.785     1.325     0.200
    82.785     1.142     0.200
    82.785     2.310     0.200
    82.785     2.079     0.200
    82.766     1.142     0.200
    82.819     0.168     0.200
    82.720    -0.298     0.200
    82.720    -0.868     0.200
    82.873     1.084     0.200
    82.797    -0.151     0.200
    82.797     0.118     0.200
    82.783    -0.377     0.200
    82.870    -0.898     0.200
    82.916    -0.334     0.200
    82.936     0.860     0.200
    82.936     0.161     0.200
    82.936     0.360     0.200
    82.936     0.161     0.200
    83.064     0.295     0.200
    82.971    -1.353     0.200
    83.149     0.451     0.200
    83.159     0.710     0.200
    83.179     0.503     0.200
    83.175     0.524     0.200
    83.110     0.803     0.200
    83.225     0.068     0.200
    83.215     0.919     0.200
    83.252    -0.374     0.200
    83.252    -0.823     0.200
    83.321     0.473     0.200
    83.332     0.616     0.200
    83.265     0.469     0.200
    83.273     0.191     0.200
    83.380     0.970     0.200
    83.380     1.142     0.200
    83.402     0.256     0.200
    83.339     0.160     0.200
    83.451     1.008     0.200
    83.447     1.428     0.200
    83.474     0.399     0.200
    83.474     1.391     0.200
    83.441     0.648     0.200
    83.575     0.969     0.200
    83.560     0.895     0.200
    83.583     0.926     0.200
    83.575     0.920     0.200
    83.575     0.990     0.200
    83.504     1.242     0.200
    83.555     0.635     0.200
    83.630     0.787     0.200
    83.560     1.618     0.200
    83.659     0.539     0.200
    83.709     1.185     0.200
    83.626    -0.023     0.200
    83.734     0.887     0.200
    83.891    -0.025     0.200
    83.789     0.194     0.200
    83.894     0.941     0.200
    83.943     0.887     0.200
    83.855     1.439     0.200
    83.855     1.806     0.200
    83.855     1.916     0.200
    84.009     0.952     0.200
    84.009     0.733     0.200
    84.018     1.407     0.200
    84.018     1.009     0.200
    84.160     1.087     0.200
    84.145     0.862     0.200
    84.184     0.559     0.200
    84.188     1.041     0.200
    84.218     0.692     0.200
    84.244    -0.090     0.200
    84.248     0.699     0.200
    84.273     0.014     0.200
    84.304     0.452     0.200
    84.333     0.507     0.200
    84.333     0.784     0.200
    84.376     0.988     0.200
    84.290    -0.453     0.200
    84.290    -0.086     0.200
    84.411     0.912     0.200
    84.413     1.302     0.200
    84.459     0.468     0.200
    84.439     0.973     0.200
    84.487     0.529     0.200
    84.384    -0.362     0.200
    84.515     0.454     0.200
    84.515     0.884     0.200
    84.475     0.270     0.200
    84.568     0.021     0.200
    84.687     0.223     0.200
    84.686     0.926     0.200
    84.690     1.005     0.200
    84.717     0.166     0.200
    84.754     0.181     0.200
    84.754     0.983     0.200
    84.812     1.390     0.200
    84.841     1.386     0.200
    84.865     0.926     0.200
    84.865     0.827     0.200
    84.931    -0.606     0.200
    84.941     0.645     0.200
    84.946     1.020     0.200
    84.953     0.284     0.200
    84.935     0.243     0.200
    84.935     1.172     0.200
    85.038     0.357     0.200
    85.042     1.039     0.200
    85.063     0.730     0.200
    85.063     1.081     0.200
    84.979     1.979     0.200
    85.112     0.886     0.200
    85.158     0.454     0.200
    85.151     1.394     0.200
    85.229     0.402     0.200
    85.180     2.295     0.200
    85.319     0.025     0.200
    85.341     0.345     0.200
    85.357     0.262     0.200
    85.238     1.798     0.200
    85.396     0.469     0.200
    85.357     1.333     0.200
    85.469     0.704     0.200
    85.567     1.518     0.200
    85.518     3.332     0.200
    85.651     0.503     0.200
    85.700     0.957     0.200
    85.774    -0.310     0.200
    85.829     0.524     0.200
    85.750    -0.630     0.200
    85.909     0.127     0.200
    85.938    -0.118     0.200
    85.944    -0.048     0.200
    85.994     0.207     0.200
    86.003    -0.238     0.200
    86.135    -0.490     0.200
    86.155     1.410     0.200
    86.155     0.110     0.200
    86.155     0.348     0.200
    86.219     0.595     0.200
    86.297     1.091     0.200
    86.309    -0.449     0.200
    86.309     0.352     0.200
    86.425     0.681     0.200
    86.430    -0.040     0.200
    86.442     1.410     0.200
    86.517     0.431     0.200
    86.569     0.178     0.200
    86.486     0.217     0.200
    86.563     0.407     0.200
    86.664    -0.585     0.200
    86.746     0.611     0.200
    86.753     0.480     0.200
    86.805     0.223     0.200
    86.772     0.887     0.200
    86.865    -0.065     0.200
    86.915    -0.712     0.200
    86.943     0.051     0.200
    87.018     1.088     0.200
    87.056     0.302     0.200
    87.056     0.505     0.200
    87.051    -0.934     0.200
    87.046     1.449     0.200
    87.097     0.599     0.200
    87.140    -0.505     0.200
    87.152     1.040     0.200
    87.180     0.403     0.200
    87.193     1.438     0.200
    87.237    -0.475     0.200
    87.246     0.785     0.200
    87.285    -0.306     0.200
    87.288    -0.433     0.200
    87.288     0.976     0.200
    87.290     0.371     0.200
    87.291    -0.836     0.200
    87.270     1.364     0.200
    87.319    -0.369     0.200
    87.322    -0.487     0.200
    87.390     0.890     0.200
    87.343    -0.290     0.200
    87.435    -0.732     0.200
    87.438    -0.243     0.200
    87.425     0.518     0.200
    87.554     1.590     0.200
    87.625     0.649     0.200
    87.722     1.406     0.200
    87.744    -0.210     0.200
    87.798    -1.166     0.200
    87.809     0.085     0.200
    87.916     0.476     0.200
    87.924    -0.864     0.200
    87.957     0.281     0.200
    88.053    -0.473     0.200
    88.145    -1.910     0.200
    88.157     0.334     0.200
    88.212     0.683     0.200
    88.353     0.107     0.200
    88.336     0.888     0.200
    88.444    -0.522     0.200
    88.475     0.555     0.200
    88.572    -1.428     0.200
    88.557     0.955     0.200
    88.593    -1.027     0.200
    88.679     0.274     0.200
    88.811     1.352     0.200
    88.840    -0.586     0.200
    89.042    -0.336     0.200
    89.205     0.625     0.200
    89.205     0.969     0.200
    89.226     1.102     0.200
    89.247     1.605     0.200
    89.431    -0.259     0.200
    89.569    -0.814     0.200
    89.607     0.318     0.200
    89.607     0.806     0.200
    89.589     0.101     0.200
    89.589    -0.199     0.200
    89.705    -0.162     0.200
    89.814    -0.148     0.200
    89.859     0.742     0.200
    89.875     0.963     0.200
    89.940    -1.539     0.200
    89.920     0.197     0.200
    90.048     0.362     0.200
    90.048     0.049     0.200
    90.055    -1.975     0.200
    90.222     0.249     0.200
    90.137     1.083     0.200
    90.677     0.058     0.200
    90.766     0.508     0.200
    90.809     0.112     0.200
    90.943     0.016     0.200
    91.062    -0.633     0.200
    91.093     1.128     0.200
    91.214     0.495     0.200
    91.388     1.471     0.200
    91.282     2.544     0.200
    91.793     0.415     0.200
    92.270    -0.083     0.200
    92.271    -0.056     0.200
    92.271    -0.306     0.200
    92.617    -0.803     0.200
    92.658    -0.445     0.200
    92.822    -0.198     0.200
    92.822     0.075     0.200
    92.835    -0.232     0.200
    92.951     0.519     0.200
    93.117    -0.919     0.200
    93.248     0.450     0.200
    93.439    -0.073     0.200
    93.409     0.894     0.200
    93.460    -0.208     0.200
    93.772    -0.366     0.200
    93.840    -1.786     0.200
    94.382    -0.737     0.200
    94.511    -0.425     0.200
    94.511     0.603     0.200
    94.517    -0.248     0.200
    94.517     0.576     0.200
    94.471     1.638     0.200
    94.672    -0.371     0.200
    94.672     0.574     0.200
    94.760    -0.413     0.200
    94.760     0.462     0.200
    94.886     0.168     0.200
    95.089     0.966     0.200
    95.201     0.447     0.200
    95.184    -0.644     0.200
    95.544     0.765     0.200
    95.650     1.538     0.200
    95.784     0.551     0.200
    95.767     1.293     0.200
    95.767     0.644     0.200
    95.741     0.283     0.200
    96.116     0.618     0.200
    96.138    -0.520     0.200
    96.110     0.252     0.200
    96.200     0.027     0.200
    96.643     0.110     0.200
    17.012     1.391     0.200
    17.012     0.969     0.200
    18.281    -2.562     0.200
    20.139     0.461     0.200
    23.839    -0.710     0.200
    23.839    -1.132     0.200
    23.956     0.481     0.200
    24.343    -0.063     0.200
    24.345    -0.358     0.200
    24.345    -0.089     0.200
    24.345    -0.077     0.200
    24.494    -0.417     0.200
    24.503     0.026     0.200
    24.503    -1.107     0.200
    24.535     0.483     0.200
    24.602     2.490     0.200
    24.667     2.649     0.200
    24.731    -0.246     0.200
    24.760     1.520     0.200
    24.778     2.247     0.200
    25.023    -0.920     0.200
    25.023    -1.397     0.200
    25.178     1.148     0.200
    25.402     1.448     0.200
    25.478     2.985     0.200
    25.485     2.599     0.200
    25.498     2.690     0.200
    25.535     1.082     0.200
    25.880     1.868     0.200
    26.080     1.875     0.200
    26.403     0.300     0.200
    26.465     2.008     0.200
    26.729    -0.747     0.200
    26.876     1.493     0.200
    26.976     1.620     0.200
    26.996     1.135     0.200
    27.007     2.521     0.200
    27.029     2.877     0.200
    27.156     1.168     0.200
    27.241     1.635     0.200
    27.314     2.248     0.200
    27.400     1.380     0.200
    27.400     1.848     0.200
    27.739     1.674     0.200
    27.863     0.723     0.200
    27.985     1.157     0.200
    28.023     2.413     0.200
    28.023     2.823     0.200
    28.024     2.742     0.200
    28.167     1.271     0.200
    28.409     2.319     0.200
    28.481     1.207     0.200
    28.482     2.892     0.200
    28.569     1.949     0.200
    28.841     1.048     0.200
    28.888     1.887     0.200
    29.273     2.191     0.200
    29.495     1.528     0.200
    29.882     1.780     0.200
    29.988     0.610     0.200
    29.988     1.594     0.200
    30.172     1.020     0.200
    30.882     1.616     0.200
    30.888     1.552     0.200
    31.586     1.461     0.200
    31.607     1.027     0.200
    31.607     2.234     0.200
    31.678    -1.156     0.200
    31.743     0.372     0.200
    31.743     0.771     0.200
    31.856     1.977     0.200
    32.008     0.055     0.200
    32.055     2.162     0.200
    32.744     2.132     0.200
    32.744     2.402     0.200
    32.825     1.731     0.200
    32.854     1.831     0.200
    32.926     1.730     0.200
    32.918     2.482     0.200
    32.918     2.091     0.200
    32.931     1.721     0.200
    33.007     1.982     0.200
    33.134     2.397     0.200
    33.313    -0.958     0.200
    33.313    -1.364     0.200
    33.317     1.669     0.200
    33.317     2.896     0.200
    33.406     1.739     0.200
    33.433     1.870     0.200
    33.513     1.897     0.200
    33.608     1.614     0.200
    33.563     2.662     0.200
    33.641     0.583     0.200
    33.663     1.986     0.200
    33.680    -0.160     0.200
    33.695     1.007     0.200
    33.772     1.342     0.200
    33.756     1.596     0.200
    33.782     2.175     0.200
    33.785    -1.967     0.200
    34.007     1.649     0.200
    34.047     1.631     0.200
    34.067     1.269     0.200
    34.153     0.807     0.200
    34.159     0.945     0.200
    34.280     1.058     0.200
    34.335     1.535     0.200
    34.335     1.656     0.200
    34.470     1.569     0.200
    34.484     1.402     0.200
    34.463     1.763     0.200
    34.627     2.535     0.200
    34.627     1.836     0.200
    34.671     1.821     0.200
    34.671     2.059     0.200
    34.669     2.170     0.200
    34.669     2.033     0.200
    34.825     2.203     0.200
    34.852     2.895     0.200
    34.875     2.145     0.200
    34.895     1.437     0.200
    34.895     0.555     0.200
    34.895     1.174     0.200
    34.886     1.972     0.200
    34.941     1.923     0.200
    34.941     1.876     0.200
    34.941     1.727     0.200
    35.006     0.663     0.200
    35.162     0.025     0.200
    35.087     2.083     0.200
    35.187     1.883     0.200
    35.193     1.746     0.200
    35.200     1.384     0.200
    35.230     1.915     0.200
    35.254     1.517     0.200
    35.264     2.218     0.200
    35.339     0.693     0.200
    35.371     1.676     0.200
    35.464    -1.411     0.200
    35.464    -1.711     0.200
    35.455     1.634     0.200
    35.467     2.046     0.200
    35.592     1.216     0.200
    35.628     0.746     0.200
    35.587     2.080     0.200
    35.648    -0.847     0.200
    35.679     1.547     0.200
    35.714     0.687     0.200
    35.714     0.339     0.200
    35.747     2.217     0.200
    35.801     1.148     0.200
    35.817     1.972     0.200
    35.817     1.604     0.200
    35.869     1.612     0.200
    35.857     2.065     0.200
    35.857     2.706     0.200
    35.870     2.069     0.200
    35.909     2.632     0.200
    35.921     2.019     0.200
    36.018     3.029     0.200
    36.041     0.718     0.200
    36.024     1.876     0.200
    36.129     2.060     0.200
    36.193     1.396     0.200
    36.174     2.487     0.200
    36.191     2.325     0.200
    36.211     1.056     0.200
    36.329     1.110     0.200
    36.342     1.507     0.200
    36.343     1.633     0.200
    36.437     0.589     0.200
    36.425     1.846     0.200
    36.468     1.538     0.200
    36.493     1.171     0.200
    36.485     2.525     0.200
    36.523     2.024     0.200
    36.519     2.274     0.200
    36.576     0.776     0.200
    36.604     0.433     0.200
    36.597     1.914     0.200
    36.591     1.784     0.200
    36.715     0.690     0.200
    36.709     2.090     0.200
    36.741     0.242     0.200
    36.804     1.078     0.200
    36.827     1.870     0.200
    36.834     2.331     0.200
    36.834     1.695     0.200
    36.862     1.569     0.200
    36.905     0.927     0.200
    36.887     2.587     0.200
    36.946     1.079     0.200
    36.928     1.465     0.200
    36.983     0.898     0.200
    37.169     0.646     0.200
    37.198     0.613     0.200
    37.237     1.274     0.200
    37.237     0.512     0.200
    37.224     1.619     0.200
    37.272     0.458     0.200
    37.259     2.157     0.200
    37.259     1.426     0.200
    37.339     0.623     0.200
    37.355     0.794     0.200
    37.352     1.289     0.200
    37.341     1.247     0.200
    37.341     1.426     0.200
    37.393     1.138     0.200
    37.472     0.769     0.200
    37.447     1.845     0.200
    37.469     0.616     0.200
    37.469    -0.439     0.200
    37.551     1.905     0.200
    37.583     1.947     0.200
    37.600     1.677     0.200
    37.657     0.707     0.200
    37.673     0.365     0.200
    37.678     1.165     0.200
    37.681     0.889     0.200
    37.784     1.489     0.200
    37.818     1.172     0.200
    37.820     1.939     0.200
    37.842     1.812     0.200
    37.929     0.883     0.200
    37.923     1.462     0.200
    37.964     0.733     0.200
    38.014     0.982     0.200
    38.043     0.828     0.200
    38.044     1.050     0.200
    38.037     2.392     0.200
    38.060     1.747     0.200
    38.123     1.286     0.200
    38.169     1.244     0.200
    38.186     0.082     0.200
    38.229     1.075     0.200
    38.231     2.311     0.200
    38.231     1.331     0.200
    38.269     0.172     0.200
    38.273     1.004     0.200
    38.279     0.313     0.200
    38.279     0.141     0.200
    38.288     0.825     0.200
    38.283     0.772     0.200
    38.319     0.736     0.200
    38.401     0.828     0.200
    38.438     0.991     0.200
    38.454     0.828     0.200
    38.456     0.028     0.200
    38.456     0.290     0.200
    38.495     1.452     0.200
    38.600     0.298     0.200
    38.582     1.487     0.200
    38.582     1.772     0.200
    38.619     0.888     0.200
    38.630     0.144     0.200
    38.677     0.056     0.200
    38.722     0.733     0.200
    38.708     1.927     0.200
    38.721     1.843     0.200
    38.721     1.597     0.200
    38.929     0.576     0.200
    38.931     0.863     0.200
    38.948     0.205     0.200
    38.947     0.797     0.200
    38.943     1.685     0.200
    39.050     0.146     0.200
    39.066    -0.074     0.200
    39.077     1.281     0.200
    39.107     0.858     0.200
    39.149    -2.078     0.200
    39.172     1.144     0.200
    39.260    -0.173     0.200
    39.268     0.147     0.200
    39.265     0.827     0.200
    39.277    -0.022     0.200
    39.373     0.185     0.200
    39.407    -0.227     0.200
    39.406     0.552     0.200
    39.384     1.339     0.200
    39.426     0.644     0.200
    39.470     0.243     0.200
    39.475     2.307     0.200
    39.538     0.305     0.200
    39.696     0.048     0.200
    39.732     0.329     0.200
    39.762     1.674     0.200
    39.762     1.440     0.200
    39.876     0.270     0.200
    39.903     1.550     0.200
    39.928     0.141     0.200
    39.931     0.327     0.200
    39.939     1.916     0.200
    39.990     0.739     0.200
    40.053     0.110     0.200
    40.094     0.082     0.200
    40.179     0.558     0.200
    40.256     0.616     0.200
    40.241     1.870     0.200
    40.269     0.058     0.200
    40.320     0.768     0.200
    40.340     0.516     0.200
    40.387     0.967     0.200
    40.424     0.828     0.200
    40.444    -0.158     0.200
    40.504     0.241     0.200
    40.512    -0.587     0.200
    40.527     1.745     0.200
    40.526     1.950     0.200
    40.578    -0.067     0.200
    40.661     1.299     0.200
    40.752    -0.097     0.200
    40.751     0.150     0.200
    40.768     0.745     0.200
    40.798     0.114     0.200
    40.888    -0.162     0.200
    41.032     0.246     0.200
    41.031     0.173     0.200
    41.076     0.428     0.200
    41.181     0.147     0.200
    41.183     0.902     0.200
    41.195     0.586     0.200
    41.245    -0.323     0.200
    41.224    -0.035     0.200
    41.307    -0.063     0.200
    41.340     0.239     0.200
    41.325     1.827     0.200
    41.393     0.149     0.200
    41.397     2.846     0.200
    41.397     1.432     0.200
    41.420     1.297     0.200
    41.506     0.150     0.200
    41.524     0.371     0.200
    41.583     0.091     0.200
    41.574     1.611     0.200
    41.574     1.404     0.200
    41.604     0.623     0.200
    41.712     0.470     0.200
    41.756     0.063     0.200
    41.852     0.552     0.200
    41.879     0.469     0.200
    41.921     0.006     0.200
    41.927    -0.005     0.200
    41.957     0.360     0.200
    41.938     1.408     0.200
    41.938     1.674     0.200
    41.938     1.209     0.200
    41.937     1.996     0.200
    41.963     0.148     0.200
    42.004     0.656     0.200
    42.093     0.184     0.200
    42.103    -0.157     0.200
    42.190     0.348     0.200
    42.214     0.074     0.200
    42.293     0.154     0.200
    42.293     1.672     0.200
    42.309     0.812     0.200
    42.309     0.628     0.200
    42.299     2.357     0.200
    42.318     0.251     0.200
    42.348    -0.090     0.200
    42.363     0.375     0.200
    42.411     1.945     0.200
    42.461     0.663     0.200
    42.535    -0.148     0.200
    42.651     0.810     0.200
    42.648     0.597     0.200
    42.672     0.782     0.200
    42.719     0.380     0.200
    42.747     0.401     0.200
    42.772    -0.338     0.200
    42.894     0.472     0.200
    42.894    -0.118     0.200
    42.931     2.343     0.200
    42.956     0.106     0.200
    42.943     1.927     0.200
    42.975     0.187     0.200
    42.991     0.746     0.200
    43.116     0.160     0.200
    43.121     1.115     0.200
    43.140     0.382     0.200
    43.147     0.696     0.200
    43.233     0.378     0.200
    43.231    -0.142     0.200
    43.230     0.165     0.200
    43.321     0.293     0.200
    43.333    -0.297     0.200
    43.413    -1.021     0.200
    43.510    -0.012     0.200
    43.611    -0.232     0.200
    43.624     0.166     0.200
    43.669     0.481     0.200
    43.684     0.081     0.200
    43.678     0.817     0.200
    43.799     1.076     0.200
    43.837    -0.078     0.200
    43.874     0.520     0.200
    43.901     0.137     0.200
    43.947     0.078     0.200
    43.976     0.603     0.200
    43.985    -0.261     0.200
    44.090     0.421     0.200
    44.097     0.757     0.200
    44.184     0.581     0.200
    44.155    -0.406     0.200
    44.282     0.176     0.200
    44.297    -0.010     0.200
    44.337     0.020     0.200
    44.339    -0.572     0.200
    44.341     0.893     0.200
    44.361     0.066     0.200
    44.388    -1.873     0.200
    44.410     1.680     0.200
    44.472     0.585     0.200
    44.478    -0.488     0.200
    44.478    -0.890     0.200
    44.515     0.492     0.200
    44.550    -0.034     0.200
    44.639     0.682     0.200
    44.654     0.149     0.200
    44.707     0.297     0.200
    44.729     1.130     0.200
    44.755     0.965     0.200
    44.755     0.645     0.200
    44.774     0.243     0.200
    44.771     0.214     0.200
    44.783     0.532     0.200
    44.900     0.311     0.200
    44.916     1.180     0.200
    44.917     0.016     0.200
    44.952     0.249     0.200
    44.968     0.150     0.200
    44.979     0.471     0.200
    45.116    -0.086     0.200
    45.165     0.530     0.200
    45.173    -0.067     0.200
    45.214     0.123     0.200
    45.219     0.836     0.200
    45.390    -0.036     0.200
    45.410     0.250     0.200
    45.473    -0.023     0.200
    45.486     0.155     0.200
    45.508    -0.056     0.200
    45.657     0.998     0.200
    45.683    -0.090     0.200
    45.693     0.063     0.200
    45.786    -0.460     0.200
    45.815     0.127     0.200
    45.822     0.357     0.200
    45.857    -0.182     0.200
    45.866    -0.205     0.200
    45.884     0.131     0.200
    45.980    -0.588     0.200
    45.962     0.788     0.200
    46.023    -0.081     0.200
    46.023    -0.202     0.200
    46.023     0.348     0.200
    46.107    -0.177     0.200
    46.123    -0.115     0.200
    46.270     0.552     0.200
    46.270     0.134     0.200
    46.245    -0.580     0.200
    46.259    -0.423     0.200
    46.308    -1.071     0.200
    46.277    -0.382     0.200
    46.277    -0.260     0.200
    46.390     0.760     0.200
    46.456     0.197     0.200
    46.456    -0.178     0.200
    46.505     0.189     0.200
    46.525    -0.577     0.200
    46.531    -0.102     0.200
    46.562    -0.362     0.200
    46.540    -0.289     0.200
    46.607     0.490     0.200
    46.607    -0.034     0.200
    46.658    -0.358     0.200
    46.728    -0.189     0.200
    46.732     0.485     0.200
    46.789    -0.839     0.200
    46.807     0.795     0.200
    46.833    -0.848     0.200
    46.891    -1.272     0.200
    46.898     0.182     0.200
    47.030    -0.275     0.200
    47.085    -0.984     0.200
    47.085    -1.152     0.200
    47.048    -0.320     0.200
    47.090    -0.008     0.200
    47.116     0.579     0.200
    47.149     1.017     0.200
    47.274    -0.748     0.200
    47.280    -0.758     0.200
    47.299    -1.056     0.200
    47.308     0.340     0.200
    47.380    -0.745     0.200
    47.395    -0.106     0.200
    47.395    -0.219     0.200
    47.396    -0.093     0.200
    47.435    -0.279     0.200
    47.467    -0.583     0.200
    47.531     0.312     0.200
    47.556     0.002     0.200
    47.600     0.348     0.200
    47.600     0.000     0.200
    47.567    -1.515     0.200
    47.653     0.430     0.200
    47.662     1.041     0.200
    47.663     1.363     0.200
    47.663     1.363     0.200
    47.691     0.320     0.200
    47.753    -0.952     0.200
    47.789    -0.372     0.200
    47.788     0.011     0.200
    47.831    -0.425     0.200
    47.887    -0.403     0.200
    47.887    -0.032     0.200
    47.962     0.290     0.200
    47.984     0.094     0.200
    47.999    -0.980     0.200
    48.024     0.478     0.200
    48.099    -1.285     0.200
    48.106    -0.867     0.200
    48.105     0.658     0.200
    48.148     0.419     0.200
    48.197    -0.646     0.200
    48.258    -0.722     0.200
    48.224    -0.392     0.200
    48.363     1.669     0.200
    48.390    -0.946     0.200
    48.401    -1.262     0.200
    48.396     0.571     0.200
    48.402     0.324     0.200
    48.470     0.639     0.200
    48.635     1.137     0.200
    48.575     0.572     0.200
    48.668    -0.491     0.200
    48.678    -0.661     0.200
    48.722     0.148     0.200
    48.767    -1.083     0.200
    48.830     0.428     0.200
    48.852     0.674     0.200
    48.863     0.237     0.200
    48.869     0.611     0.200
    48.867     0.620     0.200
    48.911     0.303     0.200
    49.019     0.684     0.200
    49.019     0.524     0.200
    49.055    -0.251     0.200
    49.174    -0.807     0.200
    49.235    -0.078     0.200
    49.224     0.149     0.200
    49.254     0.778     0.200
    49.254     0.575     0.200
    49.287     0.587     0.200
    49.354     0.045     0.200
    49.418     0.590     0.200
    49.431     0.655     0.200
    49.435     0.724     0.200
    49.467    -0.270     0.200
    49.621     0.128     0.200
    49.638    -0.097     0.200
    49.653     0.868     0.200
    49.621     1.130     0.200
    49.621     1.055     0.200
    49.754     0.509     0.200
    49.763     0.186     0.200
    49.777     0.198     0.200
    49.781     0.748     0.200
    49.791     0.815     0.200
    49.792     0.938     0.200
    49.807    -0.272     0.200
    49.829    -0.229     0.200
    49.829    -0.807     0.200
    49.801    -1.051     0.200
    49.818    -1.050     0.200
    49.845    -0.655     0.200
    49.853    -1.337     0.200
    49.885    -0.627     0.200
    49.952    -0.790     0.200
    50.050     0.419     0.200
    50.070     1.096     0.200
    50.106    -0.614     0.200
    50.118     0.295     0.200
    50.130     0.671     0.200
    50.182    -0.640     0.200
    50.192    -0.076     0.200
    50.229     0.241     0.200
    50.214     0.110     0.200
    50.243     0.606     0.200
    50.244     0.668     0.200
    50.244     0.605     0.200
    50.320    -0.613     0.200
    50.387    -0.282     0.200
    50.522     0.339     0.200
    50.534     1.199     0.200
    50.573    -0.553     0.200
    50.567     0.813     0.200
    50.586    -0.393     0.200
    50.591     1.081     0.200
    50.629     0.891     0.200
    50.638     1.137     0.200
    50.655     1.016     0.200
    50.668     0.714     0.200
    50.673     1.074     0.200
    50.796    -0.221     0.200
    50.863     0.075     0.200
    50.869     1.422     0.200
    50.870     1.289     0.200
    50.894     1.492     0.200
    50.922     1.157     0.200
    50.922     0.688     0.200
    50.955     0.439     0.200
    50.957     1.121     0.200
    50.955     1.237     0.200
    51.000     0.809     0.200
    51.011     0.572     0.200
    51.016     0.878     0.200
    51.035     0.708     0.200
    51.088     0.486     0.200
    51.126     0.309     0.200
    51.173    -0.789     0.200
    51.176     0.388     0.200
    51.310     1.410     0.200
    51.363    -0.117     0.200
    51.323     1.597     0.200
    51.348     0.667     0.200
    51.343     1.651     0.200
    51.380     1.708     0.200
    51.409     1.103     0.200
    51.428     1.108     0.200
    51.478     1.203     0.200
    51.491     0.301     0.200
    51.504     1.527     0.200
    51.614    -0.471     0.200
    51.614     0.235     0.200
    51.686     1.509     0.200
    51.693     1.934     0.200
    51.698    -0.116     0.200
    51.731     0.582     0.200
    51.732     1.929     0.200
    51.790    -0.201     0.200
    51.792     2.004     0.200
    51.796     1.989     0.200
    51.845     0.769     0.200
    51.935     0.072     0.200
    51.920     1.927     0.200
    51.955    -0.873     0.200
    51.941     0.159     0.200
    51.984    -0.238     0.200
    51.989     0.090     0.200
    52.175    -0.329     0.200
    52.187     0.993     0.200
    52.208     0.815     0.200
    52.219     0.566     0.200
    52.219     1.051     0.200
    52.236     1.922     0.200
    52.249    -1.214     0.200
    52.234     1.342     0.200
    52.258     0.621     0.200
    52.316     1.483     0.200
    52.358     0.009     0.200
    52.440    -0.295     0.200
    52.532    -0.427     0.200
    52.573     1.520     0.200
    52.621    -0.377     0.200
    52.627     1.343     0.200
    52.635     1.025     0.200
    52.664     1.035     0.200
    52.664     1.952     0.200
    52.715    -0.016     0.200
    52.754     0.274     0.200
    52.738    -0.765     0.200
    52.717     0.521     0.200
    52.752     1.402     0.200
    52.776     1.232     0.200
    52.820    -0.063     0.200
    52.835     0.294     0.200
    52.919     0.411     0.200
    52.919    -0.265     0.200
    52.919    -0.124     0.200
    53.045    -0.601     0.200
    53.047     1.728     0.200
    53.082     0.318     0.200
    53.092     1.078     0.200
    53.138     0.156     0.200
    53.138     0.647     0.200
    53.141     1.383     0.200
    53.273    -0.026     0.200
    53.408     0.039     0.200
    53.381    -0.341     0.200
    53.362     0.724     0.200
    53.405    -1.421     0.200
    53.428     1.053     0.200
    53.459     1.609     0.200
    53.520    -1.021     0.200
    53.523     0.863     0.200
    53.576     0.315     0.200
    53.613     0.256     0.200
    53.768    -0.296     0.200
    53.889     1.094     0.200
    53.906    -0.429     0.200
    53.931    -0.693     0.200
    53.995    -0.890     0.200
    53.994    -0.247     0.200
    54.007    -0.441     0.200
    54.007     0.094     0.200
    54.007    -0.305     0.200
    54.030     0.417     0.200
    54.032     0.603     0.200
    54.037    -0.510     0.200
    54.060     1.278     0.200
    54.100    -0.603     0.200
    54.103    -0.042     0.200
    54.147    -0.786     0.200
    54.198    -0.998     0.200
    54.271     0.702     0.200
    54.297    -0.653     0.200
    54.283     1.017     0.200
    54.298     0.527     0.200
    54.299     0.462     0.200
    54.330    -0.297     0.200
    54.343     0.151     0.200
    54.343     0.151     0.200
    54.382    -0.310     0.200
    54.418    -0.834     0.200
    54.641    -1.332     0.200
    54.707     1.060     0.200
    54.767     0.130     0.200
    54.798     0.243     0.200
    54.818     0.061     0.200
    54.845    -0.157     0.200
    54.864    -0.340     0.200
    54.886    -0.228     0.200
    54.906    -0.466     0.200
    55.009     0.284     0.200
    55.031     0.014     0.200
    55.083    -0.396     0.200
    55.166    -0.046     0.200
    55.176     0.669     0.200
    55.203     0.844     0.200
    55.262    -0.139     0.200
    55.385    -0.895     0.200
    55.449    -1.082     0.200
    55.434     1.317     0.200
    55.529    -0.375     0.200
    55.537    -0.577     0.200
    55.557     0.569     0.200
    55.580    -0.801     0.200
    55.692    -0.345     0.200
    55.713    -1.297     0.200
    55.713    -1.074     0.200
    55.713    -1.017     0.200
    55.713    -1.567     0.200
    55.837    -0.331     0.200
    55.951     0.019     0.200
    55.951    -0.344     0.200
    56.078    -0.067     0.200
    56.093    -0.296     0.200
    56.160    -0.438     0.200
    56.160    -0.801     0.200
    56.238    -0.316     0.200
    56.286    -1.096     0.200
    56.302    -0.086     0.200
    56.416    -0.676     0.200
    56.489    -0.625     0.200
    56.528    -0.381     0.200
    56.564     1.553     0.200
    56.564     0.951     0.200
    56.565    -0.899     0.200
    56.749     0.341     0.200
    56.917    -0.851     0.200
    56.917    -0.992     0.200
    57.021    -0.701     0.200
    57.122    -1.191     0.200
    57.137     0.094     0.200
    57.325    -0.729     0.200
    57.363    -0.727     0.200
    57.618    -0.802     0.200
    57.730    -0.181     0.200
    57.841    -0.558     0.200
    57.805     1.063     0.200
    58.581     0.477     0.200
    58.650     0.792     0.200
    58.727    -0.341     0.200
    58.869    -0.381     0.200
    58.873    -0.405     0.200
    58.909    -0.315     0.200
    58.979    -0.797     0.200
    59.110    -1.625     0.200
    59.252     0.222     0.200
    59.760     1.024     0.200
    60.324    -0.542     0.200
    60.678    -0.608     0.200
    61.884    -1.283     0.200
    62.415    -0.170     0.200
    62.654    -1.155     0.200
    62.769     0.320     0.200
    62.909     0.446     0.200
    63.132     1.142     0.200
    63.205    -0.690     0.200
    63.217     0.407     0.200
    63.420    -0.740     0.200
    63.432    -0.986     0.200
    63.517    -0.558     0.200
    63.640    -0.092     0.200
    63.659     0.417     0.200
    63.719    -0.216     0.200
    63.719    -0.581     0.200
    63.717     0.044     0.200
    63.690    -0.839     0.200
    63.799    -1.131     0.200
    63.800    -0.646     0.200
    63.800    -0.622     0.200
    63.800    -0.747     0.200
    63.787     0.044     0.200
    63.881    -0.684     0.200
    63.886     0.071     0.200
    63.959    -0.418     0.200
    64.053     0.270     0.200
    64.086    -0.541     0.200
    64.111    -0.950     0.200
    64.126    -0.675     0.200
    64.131    -0.407     0.200
    64.137    -0.260     0.200
    64.137    -0.260     0.200
    64.137    -0.260     0.200
    64.162     0.122     0.200
    64.318    -0.679     0.200
    64.322    -0.006     0.200
    64.321     0.639     0.200
    64.357     0.114     0.200
    64.431    -0.219     0.200
    64.426    -1.250     0.200
    64.426     0.137     0.200
    64.429    -0.267     0.200
    64.429    -0.139     0.200
    64.456    -0.322     0.200
    64.456    -0.674     0.200
    64.477    -0.484     0.200
    64.477    -0.711     0.200
    64.467    -0.962     0.200
    64.921    -0.437     0.200
    64.995     0.143     0.200
    65.041    -0.570     0.200
    65.216    -0.186     0.200
    65.288     0.110     0.200
    65.318     0.240     0.200
    65.445     0.293     0.200
    65.445     0.031     0.200
    65.468     0.058     0.200
    65.482     0.141     0.200
    65.573    -0.122     0.200
    65.585    -0.253     0.200
    65.622    -0.808     0.200
    65.622    -0.679     0.200
    65.622    -0.683     0.200
    65.637    -0.961     0.200
    65.671     0.159     0.200
    65.731    -0.820     0.200
    65.833     0.248     0.200
    65.801    -0.041     0.200
    65.862     0.543     0.200
    65.896    -0.735     0.200
    66.090     0.146     0.200
    66.195     0.117     0.200
    66.278     0.074     0.200
    66.290     0.471     0.200
    66.353     0.195     0.200
    66.588    -0.007     0.200
    66.600     0.309     0.200
    66.754     0.215     0.200
    66.758    -0.289     0.200
    67.042     0.298     0.200
    67.299    -0.695     0.200
    67.329     0.109     0.200
    67.497     0.437     0.200
    67.842    -0.025     0.200
    67.913     0.213     0.200
    67.968    -0.243     0.200
    67.995     0.060     0.200
    68.094     0.412     0.200
    68.130     0.204     0.200
    68.391     1.114     0.200
    68.501     0.282     0.200
    68.501     0.622     0.200
    68.576     0.237     0.200
    68.604     0.581     0.200
    68.644     0.253     0.200
    68.646    -0.584     0.200
    68.717     0.219     0.200
    68.725    -0.462     0.200
    68.837    -0.580     0.200
    68.994     0.988     0.200
    69.145     0.047     0.200
    69.224     0.195     0.200
    69.296     0.559     0.200
    69.231     1.011     0.200
    69.241     0.563     0.200
    69.363     0.215     0.200
    69.374    -0.893     0.200
    69.374    -1.206     0.200
    69.312     0.579     0.200
    69.428     0.189     0.200
    69.543     0.363     0.200
    70.038    -0.242     0.200
    70.037     0.583     0.200
    70.131     0.152     0.200
    70.131    -0.648     0.200
    70.151    -1.054     0.200
    70.202     0.016     0.200
    70.211    -0.002     0.200
    70.302    -0.073     0.200
    70.313    -0.192     0.200
    70.323    -0.022     0.200
    70.405    -0.291     0.200
    70.330    -0.065     0.200
    70.411     0.332     0.200
    70.394    -0.406     0.200
    70.480    -0.271     0.200
    70.597    -0.256     0.200
    70.559     1.236     0.200
    70.693     0.350     0.200
    70.716     0.480     0.200
    70.733    -0.622     0.200
    70.733     0.077     0.200
    70.775    -0.778     0.200
    70.813     0.028     0.200
    70.706    -0.749     0.200
    70.779     0.089     0.200
    70.864     0.231     0.200
    71.047     0.634     0.200
    71.272     0.394     0.200
    71.280     0.376     0.200
    71.327    -0.722     0.200
    71.262    -0.256     0.200
    71.321     0.316     0.200
    71.434     0.831     0.200
    71.493    -0.431     0.200
    71.577    -0.824     0.200
    71.763    -0.183     0.200
    71.871    -0.193     0.200
    71.944     0.339     0.200
    71.953     0.475     0.200
    71.998     0.955     0.200
    72.096     0.511     0.200
    72.086     1.139     0.200
    72.086     0.123     0.200
    72.086     0.572     0.200
    72.040     0.413     0.200
    72.154    -0.060     0.200
    72.332    -0.005     0.200
    72.326     0.688     0.200
    72.403     0.158     0.200
    72.345     0.707     0.200
    72.453    -2.672     0.200
    72.516     0.115     0.200
    72.572    -1.075     0.200
    72.677     0.597     0.200
    72.899     0.213     0.200
    72.905    -0.554     0.200
    72.936    -0.435     0.200
    73.005     0.948     0.200
    73.091    -0.150     0.200
    73.091     0.151     0.200
    73.137     0.144     0.200
    73.145    -0.098     0.200
    73.145     0.211     0.200
    73.216     0.668     0.200
    73.306     0.062     0.200
    73.520     0.921     0.200
    73.835     0.542     0.200
    73.847     0.285     0.200
    73.942     0.049     0.200
    73.942    -0.400     0.200
    73.963     0.377     0.200
    74.018    -0.445     0.200
    74.037     1.513     0.200
    74.114     0.253     0.200
    74.178     0.364     0.200
    74.114     0.623     0.200
    74.245     0.281     0.200
    74.301     0.312     0.200
    74.373    -0.637     0.200
    74.373    -0.660     0.200
    74.380    -0.608     0.200
    74.399    -1.102     0.200
    74.413     0.342     0.200
    74.438     1.259     0.200
    74.511     0.272     0.200
    74.553     0.470     0.200
    74.622     0.284     0.200
    74.629     0.021     0.200
    74.629     0.290     0.200
    74.629     0.199     0.200
    74.629     0.300     0.200
    74.570     1.025     0.200
    74.653     1.250     0.200
    74.780     0.679     0.200
    74.692     1.685     0.200
    74.692     1.326     0.200
    74.732    -0.488     0.200
    74.841     0.526     0.200
    74.990     0.765     0.200
    75.005     0.880     0.200
    75.017    -0.091     0.200
    75.017     1.523     0.200
    75.127     0.964     0.200
    75.127     0.573     0.200
    75.169     0.296     0.200
    75.099     1.139     0.200
    75.201     1.203     0.200
    75.289     0.644     0.200
    75.300     0.882     0.200
    75.319     0.473     0.200
    75.401     0.603     0.200
    75.469     0.614     0.200
    75.500    -0.467     0.200
    75.546     0.474     0.200
    75.600     0.664     0.200
    75.600     0.164     0.200
    75.723     0.601     0.200
    75.723     1.062     0.200
    75.654     1.168     0.200
    75.814     1.845     0.200
    75.946     0.791     0.200
    75.962     1.294     0.200
    75.969     0.779     0.200
    76.041     0.250     0.200
    76.053     1.079     0.200
    76.140     0.984     0.200
    76.140     0.434     0.200
    76.152    -0.149     0.200
    76.239     1.423     0.200
    76.239     1.322     0.200
    76.257     0.323     0.200
    76.261     1.298     0.200
    76.431     0.134     0.200
    76.431     0.486     0.200
    76.430     0.842     0.200
    76.439    -0.221     0.200
    76.474     0.790     0.200
    76.508     0.799     0.200
    76.633     0.195     0.200
    76.633    -0.356     0.200
    76.652     0.383     0.200
    76.732    -1.165     0.200
    76.862     1.201     0.200
    76.895     0.617     0.200
    76.904     0.869     0.200
    76.984    -0.084     0.200
    77.012     0.563     0.200
    77.228     0.850     0.200
    77.204    -0.168     0.200
    77.417     1.119     0.200
    77.447     0.573     0.200
    77.472     1.486     0.200
    77.472     1.282     0.200
    77.482     0.725     0.200
    77.633     0.433     0.200
    77.639     0.724     0.200
    77.661     1.026     0.200
    77.662     0.927     0.200
    77.587     1.141     0.200
    77.587     0.524     0.200
    77.782     0.758     0.200
    77.801     0.814     0.200
    77.835     1.306     0.200
    77.870     0.562     0.200
    77.907     0.962     0.200
    77.912     1.147     0.200
    77.931     1.142     0.200
    77.939     2.283     0.200
    77.969     0.415     0.200
    78.053     1.250     0.200
    78.086     1.121     0.200
    78.087    -0.040     0.200
    78.087     0.062     0.200
    78.095     1.415     0.200
    78.101     1.191     0.200
    78.129     1.428     0.200
    78.169     0.507     0.200
    78.181     1.459     0.200
    78.222     1.611     0.200
    78.259     1.310     0.200
    78.263     0.291     0.200
    78.276     0.021     0.200
    78.348     0.820     0.200
    78.369     1.505     0.200
    78.471     1.299     0.200
    78.473     0.608     0.200
    78.503     0.773     0.200
    78.528     1.330     0.200
    78.556     1.160     0.200
    78.563     1.232     0.200
    78.618     1.428     0.200
    78.641     0.443     0.200
    78.644     0.929     0.200
    78.646     0.875     0.200
    78.688     0.805     0.200
    78.796     0.954     0.200
    78.744     0.537     0.200
    78.895     1.207     0.200
    78.854    -0.954     0.200
    78.906     0.568     0.200
    78.892     0.630     0.200
    78.980     0.643     0.200
    78.970     0.201     0.200
    79.164     1.336     0.200
    79.260    -0.039     0.200
    79.311     0.534     0.200
    79.311    -0.165     0.200
    79.311     0.132     0.200
    79.338     1.290     0.200
    79.357     1.486     0.200
    79.423     1.926     0.200
    79.429    -0.510     0.200
    79.454     1.259     0.200
    79.471     1.063     0.200
    79.478     1.004     0.200
    79.480     0.698     0.200
    79.480     0.580     0.200
    79.546     1.159     0.200
    79.595    -0.346     0.200
    79.633     1.182     0.200
    79.546     0.956     0.200
    79.546     0.656     0.200
    79.665     0.990     0.200
    79.670     0.283     0.200
    79.678     1.403     0.200
    79.751     0.745     0.200
    79.759     1.105     0.200
    79.706     0.786     0.200
    79.771     1.134     0.200
    79.783     2.568     0.200
    79.810     1.629     0.200
    79.823     0.433     0.200
    79.843     1.147     0.200
    79.872     2.390     0.200
    79.850     0.202     0.200
    79.878     0.762     0.200
    79.848     1.420     0.200
    79.892     1.185     0.200
    79.902     1.328     0.200
    79.929     1.583     0.200
    79.944     0.502     0.200
    79.921     0.083     0.200
    80.001     1.996     0.200
    79.999     1.201     0.200
    80.006     0.567     0.200
    80.093     0.798     0.200
    80.098     0.061     0.200
    80.161     1.832     0.200
    80.199     1.123     0.200
    80.234     1.040     0.200
    80.280     0.991     0.200
    80.309     0.235     0.200
    80.255     0.725     0.200
    80.357     0.878     0.200
    80.358     0.969     0.200
    80.404     0.927     0.200
    80.408     0.633     0.200
    80.443     1.514     0.200
    80.443     0.918     0.200
    80.469     1.279     0.200
    80.485    -0.281     0.200
    80.547     0.759     0.200
    80.553     0.223     0.200
    80.534     0.430     0.200
    80.592     1.015     0.200
    80.545     0.767     0.200
    80.613     2.186     0.200
    80.644    -0.261     0.200
    80.643     1.145     0.200
    80.643     0.043     0.200
    80.679     1.151     0.200
    80.603     1.879     0.200
    80.675     0.841     0.200
    80.661     0.249     0.200
    80.670    -0.103     0.200
    80.672    -0.010     0.200
    80.672     0.811     0.200
    80.731    -0.029     0.200
    80.745     0.602     0.200
    80.751     0.037     0.200
    80.753    -0.047     0.200
    80.784     1.331     0.200
    80.784     1.593     0.200
    80.791     1.253     0.200
    80.808     1.464     0.200
    80.813     0.484     0.200
    80.859     1.091     0.200
    80.864     0.161     0.200
    80.938     0.968     0.200
    80.953    -0.112     0.200
    80.959     0.856     0.200
    80.963     0.807     0.200
    80.963     1.139     0.200
    80.984     0.544     0.200
    81.019     0.289     0.200
    81.057     1.035     0.200
    81.038     1.036     0.200
    81.041     1.120     0.200
    81.107     1.470     0.200
    81.112     0.541     0.200
    81.229     1.421     0.200
    81.224    -0.654     0.200
    81.270     1.205     0.200
    81.276     1.097     0.200
    81.292     0.586     0.200
    81.217     1.144     0.200
    81.340     1.438     0.200
    81.337     0.317     0.200
    81.390     0.967     0.200
    81.390     0.070     0.200
    81.364     0.104     0.200
    81.430     0.855     0.200
    81.427     1.621     0.200
    81.381     0.419     0.200
    81.385     0.195     0.200
    81.554     0.603     0.200
    81.583     1.248     0.200
    81.607     1.124     0.200
    81.712     1.294     0.200
    81.765     0.491     0.200
    81.761     0.601     0.200
    81.814     1.835     0.200
    81.814     1.526     0.200
    81.843     1.284     0.200
    81.852     1.135     0.200
    81.857     1.505     0.200
    81.879     0.790     0.200
    81.781     1.563     0.200
    81.936     2.098     0.200
    81.959     0.970     0.200
    81.968    -0.079     0.200
    81.970     0.011     0.200
    82.005     0.769     0.200
    82.048     0.805     0.200
    82.061     0.733     0.200
    82.092     1.273     0.200
    82.187     0.478     0.200
    82.190     1.120     0.200
    82.169     0.549     0.200
    82.178     0.461     0.200
    82.218     1.316     0.200
    82.218     0.914     0.200
    82.303     1.140     0.200
    82.262     1.983     0.200
    82.355     1.196     0.200
    82.410     1.232     0.200
    82.397    -0.325     0.200
    82.443    -0.050     0.200
    82.426     0.286     0.200
    82.432    -0.594     0.200
    82.486     0.314     0.200
    82.496     1.765     0.200
    82.508    -0.169     0.200
    82.519     0.746     0.200
    82.466    -0.082     0.200
    82.623     0.301     0.200
    82.618     1.328     0.200
    82.638     0.725     0.200
    82.647     2.259     0.200
    82.627     1.383     0.200
    82.735     0.418     0.200
    82.759     0.499     0.200
    82.770     1.138     0.200
    82.730     0.240     0.200
    82.730    -0.006     0.200
    82.792     1.028     0.200
    82.796     0.405     0.200
    82.802     1.572     0.200
    82.805     1.268     0.200
    82.805     1.757     0.200
    82.805     2.226     0.200
    82.793     0.502     0.200
    82.843    -0.142     0.200
    82.842     1.104     0.200
    82.885     1.243     0.200
    82.867    -1.064     0.200
    82.940    -0.241     0.200
    82.961     0.653     0.200
    82.961     0.352     0.200
    82.961     0.352     0.200
    82.973     1.287     0.200
    82.980    -0.057     0.200
    83.038     1.240     0.200
    83.066     0.506     0.200
    83.069     2.007     0.200
    83.024     0.525     0.200
    83.089    -0.011     0.200
    83.116     0.847     0.200
    83.124     1.026     0.200
    83.119    -1.187     0.200
    83.185     0.995     0.200
    83.183     0.401     0.200
    83.201     0.302     0.200
    83.203     1.102     0.200
    83.204     0.295     0.200
    83.241     1.102     0.200
    83.267     1.751     0.200
    83.254     0.087     0.200
    83.281     1.090     0.200
    83.288     0.809     0.200
    83.314     1.470     0.200
    83.239    -0.484     0.200
    83.239    -0.707     0.200
    83.344     0.911     0.200
    83.344     0.673     0.200
    83.310     0.406     0.200
    83.358     0.698     0.200
    83.365     1.355     0.200
    83.354    -0.050     0.200
    83.354     0.680     0.200
    83.354     0.321     0.200
    83.404     0.963     0.200
    83.404     1.174     0.200
    83.402     1.877     0.200
    83.427     0.147     0.200
    83.472     1.413     0.200
    83.475     0.901     0.200
    83.488     1.237     0.200
    83.499     0.325     0.200
    83.499     1.376     0.200
    83.494     2.320     0.200
    83.420     0.362     0.200
    83.533    -0.311     0.200
    83.549     2.039     0.200
    83.512     0.899     0.200
    83.566     1.770     0.200
    83.569     0.216     0.200
    83.586     0.919     0.200
    83.600     1.057     0.200
    83.600     0.787     0.200
    83.599     1.066     0.200
    83.575     1.099     0.200
    83.607     0.922     0.200
    83.644     2.352     0.200
    83.645     2.349     0.200
    83.656     0.772     0.200
    83.676     2.510     0.200
    83.685     0.825     0.200
    83.733     1.278     0.200
    83.741     1.660     0.200
    83.772     1.938     0.200
    83.743     0.949     0.200
    83.836     1.071     0.200
    83.795    -0.139     0.200
    83.844     0.673     0.200
    83.858     0.527     0.200
    83.880     0.889     0.200
    83.919     0.825     0.200
    83.864     1.563     0.200
    83.864     1.282     0.200
    83.900     0.132     0.200
    83.935     2.204     0.200
    83.952     1.940     0.200
    83.958     0.269     0.200
    83.967     0.984     0.200
    83.969     1.098     0.200
    84.001     1.088     0.200
    84.001     1.934     0.200
    84.018     2.045     0.200
    84.033     1.049     0.200
    84.042     1.404     0.200
    84.042     0.303     0.200
    84.043     0.688     0.200
    84.152     0.725     0.200
    84.153     1.677     0.200
    84.159     2.631     0.200
    84.171     1.088     0.200
    84.183     0.372     0.200
    84.183     1.083     0.200
    84.182     0.398     0.200
    84.144     0.683     0.200
    84.208     0.758     0.200
    84.214     1.030     0.200
    84.210     1.837     0.200
    84.212     1.960     0.200
    84.220     1.368     0.200
    84.235     2.059     0.200
    84.254     1.005     0.200
    84.272     0.795     0.200
    84.216     0.315     0.200
    84.254    -0.735     0.200
    84.289     2.028     0.200
    84.296     0.812     0.200
    84.310     1.063     0.200
    84.328     0.762     0.200
    84.328     0.653     0.200
    84.327     2.052     0.200
    84.305    -0.073     0.200
    84.357     0.303     0.200
    84.365     0.872     0.200
    84.292     1.632     0.200
    84.292     0.960     0.200
    84.391     1.313     0.200
    84.400     1.183     0.200
    84.437     0.699     0.200
    84.391     0.120     0.200
    84.465     0.857     0.200
    84.411     0.829     0.200
    84.473     1.135     0.200
    84.475     0.678     0.200
    84.483     0.869     0.200
    84.483     0.669     0.200
    84.486     0.591     0.200
    84.489     1.075     0.200
    84.510     0.728     0.200
    84.489    -0.067     0.200
    84.525     1.621     0.200
    84.533     0.772     0.200
    84.541     0.233     0.200
    84.541     0.573     0.200
    84.551     0.861     0.200
    84.051     1.575     0.200
    84.645     2.009     0.200
    84.592     0.317     0.200
    84.592     0.958     0.200
    84.610     2.347     0.200
    84.626     2.062     0.200
    84.649     2.008     0.200
    84.654     1.815     0.200
    84.668     1.184     0.200
    84.680     0.644     0.200
    84.710     1.219     0.200
    84.711     0.117     0.200
    84.715     1.093     0.200
    84.709     2.015     0.200
    84.716     1.532     0.200
    84.741     0.264     0.200
    84.761    -0.135     0.200
    84.772     0.381     0.200
    84.773     1.028     0.200
    84.780     0.872     0.200
    84.777    -0.317     0.200
    84.777     1.347     0.200
    84.803     0.556     0.200
    84.812     1.047     0.200
    84.816     1.909     0.200
    84.817     1.143     0.200
    84.820     0.740     0.200
    84.834     0.996     0.200
    84.863     1.082     0.200
    84.879     1.291     0.200
    84.887     1.373     0.200
    84.887     0.931     0.200
    84.887     0.693     0.200
    84.887     0.930     0.200
    84.900     1.787     0.200
    84.905     1.159     0.200
    84.955     0.294     0.200
    84.950     2.253     0.200
    84.954     2.034     0.200
    84.961     0.210     0.200
    84.961     1.058     0.200
    84.965     0.839     0.200
    84.963     1.060     0.200
    84.969     0.919     0.200
    84.977     0.281     0.200
    84.977     0.383     0.200
    84.987     1.229     0.200
    85.062     0.255     0.200
    85.067     1.026     0.200
    85.089     0.818     0.200
    85.089    -0.084     0.200
    85.123     1.311     0.200
    85.110     0.715     0.200
    85.177     1.280     0.200
    85.182     0.751     0.200
    85.223     1.470     0.200
    85.231     1.611     0.200
    85.253     0.399     0.200
    85.244     1.244     0.200
    85.343    -0.490     0.200
    85.364     0.542     0.200
    85.365     0.959     0.200
    85.377     0.543     0.200
    85.379     0.309     0.200
    85.381    -0.278     0.200
    85.381     0.363     0.200
    85.382     0.882     0.200
    85.383     1.301     0.200
    85.393    -0.198     0.200
    85.399     2.115     0.200
    85.420     0.668     0.200
    85.425     2.264     0.200
    85.466     2.496     0.200
    85.473     0.567     0.200
    85.474    -0.542     0.200
    85.488     1.670     0.200
    85.495     0.214     0.200
    85.486     1.590     0.200
    85.512     1.512     0.200
    85.545     2.364     0.200
    85.550     0.918     0.200
    85.592     1.713     0.200
    85.624     1.870     0.200
    85.634     0.822     0.200
    85.656     1.315     0.200
    85.665     1.707     0.200
    85.675     0.600     0.200
    85.724     1.254     0.200
    85.751     1.903     0.200
    85.754     1.948     0.200
    85.773     0.811     0.200
    85.783     1.904     0.200
    85.798    -0.114     0.200
    85.757    -1.379     0.200
    85.853     0.418     0.200
    85.876     0.524     0.200
    85.905     0.912     0.200
    85.907     0.570     0.200
    85.933     0.023     0.200
    85.937     1.426     0.200
    85.961     0.183     0.200
    85.968     0.150     0.200
    86.017     0.054     0.200
    86.017     0.207     0.200
    86.098     1.112     0.200
    86.100    -0.054     0.200
    86.142    -0.105     0.200
    86.152     1.204     0.200
    86.159     0.008     0.200
    86.180     1.206     0.200
    86.180     0.803     0.200
    86.180     0.456     0.200
    86.183     1.407     0.200
    86.236     0.169     0.200
    86.236     0.791     0.200
    86.237     0.745     0.200
    86.244    -0.010     0.200
    86.270     1.921     0.200
    86.333     0.779     0.200
    86.333    -0.151     0.200
    86.333    -0.752     0.200
    86.302     1.124     0.200
    86.372     1.719     0.200
    86.449     0.979     0.200
    86.453     0.060     0.200
    86.459     2.156     0.200
    86.433     1.039     0.200
    86.510     2.023     0.200
    86.530     1.005     0.200
    86.540     0.777     0.200
    86.540     0.437     0.200
    86.593     0.476     0.200
    86.620     0.461     0.200
    86.550     0.086     0.200
    86.665     0.167     0.200
    86.674     1.539     0.200
    86.675     1.594     0.200
    86.687    -0.488     0.200
    86.728     1.856     0.200
    86.749     0.432     0.200
    86.770     0.710     0.200
    86.775    -0.295     0.200
    86.777     0.576     0.200
    86.783     1.070     0.200
    86.826     0.398     0.200
    86.829     0.513     0.200
    86.829     0.224     0.200
    86.831     1.309     0.200
    86.760     1.258     0.200
    86.888    -0.066     0.200
    86.888     0.654     0.200
    86.909     1.123     0.200
    86.936     1.200     0.200
    86.939    -0.510     0.200
    86.947     0.149     0.200
    86.952     0.265     0.200
    86.957     1.010     0.200
    86.958     1.716     0.200
    86.967     0.049     0.200
    87.020     1.354     0.200
    87.043     1.079     0.200
    87.041     1.532     0.200
    87.076    -1.677     0.200
    87.078     1.108     0.200
    87.078     0.409     0.200
    87.078     0.108     0.200
    87.116     0.064     0.200
    87.115     0.241     0.200
    87.121     0.399     0.200
    87.158     0.623     0.200
    87.156     1.034     0.200
    87.164    -0.603     0.200
    87.176     0.839     0.200
    87.204     0.401     0.200
    87.218     1.332     0.200
    87.261    -0.174     0.200
    87.256     1.362     0.200
    87.270     0.181     0.200
    87.268     1.130     0.200
    87.308    -0.303     0.200
    87.312     1.178     0.200
    87.314     0.569     0.200
    87.315    -0.735     0.200
    87.315     1.642     0.200
    87.299    -1.571     0.200
    87.331     1.108     0.200
    87.342    -0.466     0.200
    87.346    -0.482     0.200
    87.369     1.765     0.200
    87.379     0.357     0.200
    87.414     0.787     0.200
    87.330    -0.408     0.200
    87.431     0.624     0.200
    87.443     0.618     0.200
    87.445    -0.104     0.200
    87.459    -0.732     0.200
    87.461    -0.741     0.200
    87.482     0.079     0.200
    87.402     0.144     0.200
    87.575     1.441     0.200
    87.608    -0.025     0.200
    87.682    -0.094     0.200
    87.648     1.568     0.200
    87.741     1.044     0.200
    87.753    -0.194     0.200
    87.793     2.577     0.200
    87.822    -1.165     0.200
    87.826     1.329     0.200
    87.833     0.386     0.200
    87.882     1.473     0.200
    87.909     0.404     0.200
    87.939     0.192     0.200
    87.939     0.782     0.200
    87.948    -0.660     0.200
    87.981     0.383     0.200
    88.015     0.663     0.200
    88.036     0.385     0.200
    88.064     0.386     0.200
    88.064    -0.132     0.200
    88.078     2.323     0.200
    88.076    -0.125     0.200
    88.076    -0.567     0.200
    88.168    -1.242     0.200
    88.168    -0.004     0.200
    88.168    -1.805     0.200
    88.168     0.098     0.200
    88.176     1.139     0.200
    88.181     0.335     0.200
    88.197     0.839     0.200
    88.228     0.656     0.200
    88.229     0.789     0.200
    88.199     0.114     0.200
    88.328     0.184     0.200
    88.376     0.675     0.200
    88.376     0.015     0.200
    88.328     0.344     0.200
    88.481    -1.480     0.200
    88.481    -0.659     0.200
    88.542    -0.497     0.200
    88.542    -1.068     0.200
    88.457    -0.066     0.200
    88.596    -1.323     0.200
    88.558     0.668     0.200
    88.617    -0.724     0.200
    88.643     0.953     0.200
    88.684     0.025     0.200
    88.734     0.588     0.200
    88.770    -1.741     0.200
    88.863    -0.381     0.200
    88.808     1.080     0.200
    88.867    -0.400     0.200
    88.867    -1.798     0.200
    88.867    -1.939     0.200
    88.797     0.232     0.200
    89.066    -0.334     0.200
    89.230     0.769     0.200
    89.230     0.547     0.200
    89.223     0.930     0.200
    89.293    -0.207     0.200
    89.243     1.237     0.200
    89.435     0.535     0.200
    89.455     0.142     0.200
    89.518     0.648     0.200
    89.523     0.607     0.200
    89.592    -1.391     0.200
    89.629     0.329     0.200
    89.629    -0.179     0.200
    89.573    -0.059     0.200
    89.674    -0.184     0.200
    89.710     0.319     0.200
    89.729    -0.739     0.200
    89.837    -0.043     0.200
    89.882     0.547     0.200
    89.884     1.040     0.200
    89.896     0.931     0.200
    89.963    -1.034     0.200
    89.920     0.040     0.200
    89.972    -1.095     0.200
    89.972    -0.673     0.200
    89.972    -1.775     0.200
    89.972    -1.396     0.200
    90.071     0.065     0.200
    90.071    -0.716     0.200
    90.079    -0.970     0.200
    90.113     1.441     0.200
    90.245     0.452     0.200
    90.684    -0.340     0.200
    90.761     0.352     0.200
    90.949    -0.006     0.200
    90.935     1.545     0.200
    91.075     0.116     0.200
    91.070    -0.880     0.200
    91.114     0.904     0.200
    91.210     0.220     0.200
    91.286     2.342     0.200
    91.409     1.236     0.200
    91.787     0.816     0.200
    92.107     1.513     0.200
    92.277     0.011     0.200
    92.278     0.327     0.200
    92.430     0.427     0.200
    92.625    -0.717     0.200
    92.665    -0.536     0.200
    92.802     0.211     0.200
    92.802    -0.691     0.200
    92.809    -0.656     0.200
    92.815    -0.322     0.200
    92.815    -0.327     0.200
    92.815    -0.452     0.200
    92.957    -0.067     0.200
    93.116     0.564     0.200
    93.254     0.015     0.200
    93.405     0.327     0.200
    93.454    -0.059     0.200
    93.468    -0.651     0.200
    93.600     0.034     0.200
    93.682     0.353     0.200
    93.779    -0.309     0.200
    93.862    -0.672     0.200
    93.836     1.145     0.200
    94.438    -1.119     0.200
    94.527     0.280     0.200
    94.532    -0.253     0.200
    94.447     1.862     0.200
    94.776    -0.380     0.200
    94.838     1.947     0.200
    94.891     0.108     0.200
    95.039     2.129     0.200
    95.197     0.558     0.200
    95.206     0.299     0.200
    95.724    -0.094     0.200
    95.763    -0.333     0.200
    96.146    -0.631     0.200
    96.156    -0.098     0.200
    96.178     0.042     0.200
    96.180    -0.067     0.200
    96.656    -0.007     0.200
    17.128     0.905     0.200
    18.475    -2.140     0.200
    18.475    -2.335     0.200
    24.645     0.588     0.200
    24.654    -0.168     0.200
    24.654     1.129     0.200
    24.361     1.464     0.200
    25.125    -1.274     0.200
    26.122     1.632     0.200
    27.017     2.226     0.200
    27.031     1.322     0.200
    27.046     0.996     0.200
    27.306     1.817     0.200
    28.902     0.379     0.200
    28.896     1.634     0.200
    29.194     1.161     0.200
    29.271     2.002     0.200
    32.927     1.431     0.200
    33.176     2.646     0.200
    33.359     1.875     0.200
    33.445     0.375     0.200
    33.473     1.327     0.200
    34.085     1.953     0.200
    34.174     1.310     0.200
    34.496     0.501     0.200
    34.600     1.598     0.200
    34.649     1.532     0.200
    34.932     0.770     0.200
    34.933     1.159     0.200
    35.306     0.892     0.200
    35.816     2.131     0.200
    36.175     1.233     0.200
    36.207     2.065     0.200
    36.360     0.953     0.200
    36.482     1.563     0.200
    36.543     2.461     0.200
    36.596     1.521     0.200
    36.726     1.924     0.200
    36.830     2.236     0.200
    36.834     2.470     0.200
    37.295     0.776     0.200
    37.231     2.753     0.200
    37.647     0.734     0.200
    37.550     1.131     0.200
    42.060     0.288     0.200
    41.950     0.005     0.200
    41.945     2.538     0.200
    42.210     1.388     0.200
    42.302     1.560     0.200
    42.420     2.748     0.200
    42.984     0.909     0.200
    43.169     0.291     0.200
    44.757     1.049     0.200
    44.940     1.318     0.200
    46.520    -1.383     0.200
    46.734    -0.756     0.200
    47.557     1.258     0.200
    47.968     0.231     0.200
    48.741     0.104     0.200
    54.421     1.071     0.200
    54.433     0.590     0.200
    55.921    -1.774     0.200
    59.016     0.011     0.200
    64.007    -1.288     0.200
    64.349    -0.901     0.200
    64.349    -1.049     0.200
    64.588    -0.178     0.200
    64.591    -0.409     0.200
    64.658    -0.865     0.200
    65.065    -0.079     0.200
    65.755    -0.386     0.200
    65.979     1.217     0.200
    70.306    -0.136     0.200
    70.905     0.037     0.200
    72.227     0.922     0.200
    73.239     0.479     0.200
    73.561     0.170     0.200
    74.577    -0.783     0.200
    75.215     0.553     0.200
    76.263     0.369     0.200
    76.352     0.463     0.200
    76.352     0.775     0.200
    76.642     0.046     0.200
    76.650    -0.126     0.200
    77.628     0.528     0.200
    77.840     0.378     0.200
    77.868     0.150     0.200
    78.296     0.651     0.200
    78.392     0.904     0.200
    78.771     0.661     0.200
    78.854     0.460     0.200
    79.007     0.380     0.200
    79.506     1.141     0.200
    79.669     0.578     0.200
    79.855     0.247     0.200
    79.940     1.584     0.200
    80.148    -0.634     0.200
    80.327     1.303     0.200
    80.452     0.928     0.200
    80.450     0.936     0.200
    80.562     1.339     0.200
    80.800    -0.040     0.200
    81.136     1.080     0.200
    81.140     1.149     0.200
    81.877     1.081     0.200
    83.810     0.732     0.200
    84.921     0.703     0.200
    85.086     0.725     0.200
    16.929     1.143     0.200
    18.245    -2.233     0.200
    18.245    -1.960     0.200
    23.855     1.899     0.200
    23.864     2.062     0.200
    23.942    -0.272     0.200
    23.942     0.228     0.200
    24.434     1.895     0.200
    24.426    -0.090     0.200
    24.434    -0.113     0.200
    24.434    -1.918     0.200
    24.448     0.738     0.200
    24.448     0.816     0.200
    24.448     0.613     0.200
    25.116    -1.133     0.200
    25.116    -0.657     0.200
    25.396     2.020     0.200
    25.501     1.476     0.200
    25.980     1.429     0.200
    26.335     1.103     0.200
    26.362     1.515     0.200
    26.895     0.421     0.200
    26.905     1.894     0.200
    27.300     1.221     0.200
    27.300     2.018     0.200
    27.760     2.313     0.200
    28.306     1.843     0.200
    28.468     1.497     0.200
    28.743     1.869     0.200
    28.856     2.221     0.200
    29.201     1.952     0.200
    29.295    -0.019     0.200
    29.392     1.396     0.200
    29.489     0.280     0.200
    29.889     1.125     0.200
    30.238     0.658     0.200
    30.780     1.085     0.200
    31.307     0.384     0.200
    31.505     0.602     0.200
    31.647     0.504     0.200
    31.647     0.246     0.200
    31.651    -2.017     0.200
    31.651    -1.040     0.200
    31.753     1.061     0.200
    31.908     0.903     0.200
    31.908     1.098     0.200
    32.467     1.936     0.200
    32.640    -0.287     0.200
    32.831     1.086     0.200
    33.217     2.130     0.200
    33.306     1.641     0.200
    33.386    -1.573     0.200
    33.386    -1.034     0.200
    33.542     1.111     0.200
    33.542     1.736     0.200
    33.561     1.943     0.200
    33.782     0.225     0.200
    33.798     0.879     0.200
    33.965     0.436     0.200
    34.232     1.298     0.200
    34.568     1.344     0.200
    34.783     1.757     0.200
    34.794     0.649     0.200
    34.838     2.212     0.200
    34.838     1.986     0.200
    34.914     1.003     0.200
    35.090     0.014     0.200
    35.127     1.491     0.200
    35.536     0.867     0.200
    35.555    -1.585     0.200
    35.555    -1.405     0.200
    35.714     2.644     0.200
    35.767     2.211     0.200
    35.817     0.670     0.200
    36.064     2.062     0.200
    36.240     1.317     0.200
    36.342     0.754     0.200
    36.365     2.692     0.200
    36.397     1.395     0.200
    36.421     2.522     0.200
    36.513     0.968     0.200
    36.607     2.030     0.200
    36.712     1.218     0.200
    36.731     2.019     0.200
    36.824     2.141     0.200
    36.849     1.270     0.200
    36.888     1.507     0.200
    37.079     0.215     0.200
    37.087     1.031     0.200
    37.139     1.047     0.200
    37.240     0.786     0.200
    37.256     0.641     0.200
    37.263     0.585     0.200
    37.497     1.203     0.200
    37.583     0.703     0.200
    37.584     1.110     0.200
    37.572     0.485     0.200
    37.717     1.970     0.200
    37.720     1.300     0.200
    37.839     0.080     0.200
    38.127     1.905     0.200
    38.192     0.258     0.200
    38.192     0.110     0.200
    38.362     0.714     0.200
    38.506     0.363     0.200
    38.588     0.684     0.200
    38.617     2.436     0.200
    38.617     1.717     0.200
    38.850     0.773     0.200
    38.858     0.320     0.200
    38.974     0.086     0.200
    39.012     0.750     0.200
    39.252    -1.171     0.200
    39.312     0.613     0.200
    39.448     0.561     0.200
    39.642     0.815     0.200
    40.354     0.197     0.200
    40.422     1.465     0.200
    40.415    -0.572     0.200
    40.426     0.328     0.200
    40.486     0.092     0.200
    40.614    -0.648     0.200
    40.663    -0.064     0.200
    40.707     0.327     0.200
    40.795     0.102     0.200
    40.986     0.437     0.200
    41.104     0.940     0.200
    41.214     0.217     0.200
    41.251     0.297     0.200
    41.294     1.057     0.200
    41.294     0.338     0.200
    41.417    -0.189     0.200
    41.432    -0.040     0.200
    41.472     0.955     0.200
    41.490    -0.017     0.200
    41.599    -0.120     0.200
    41.599    -0.995     0.200
    41.624    -0.204     0.200
    41.762     0.318     0.200
    41.835     0.687     0.200
    41.832     0.055     0.200
    41.870     0.287     0.200
    41.870    -0.330     0.200
    41.871     0.215     0.200
    42.000     0.599     0.200
    42.012     0.450     0.200
    42.126    -0.077     0.200
    42.271     0.705     0.200
    42.308     1.518     0.200
    42.363     0.840     0.200
    42.556     0.763     0.200
    42.580     1.092     0.200
    42.650     0.798     0.200
    42.685     0.160     0.200
    42.803     0.332     0.200
    42.860     0.289     0.200
    43.141     0.967     0.200
    43.228     0.236     0.200
    43.516    -0.474     0.200
    43.591     0.370     0.200
    43.776     0.483     0.200
    43.809     0.601     0.200
    43.850     0.584     0.200
    43.992     0.619     0.200
    44.258    -0.883     0.200
    44.480    -2.150     0.200
    44.543     0.794     0.200
    44.555     0.371     0.200
    44.581    -0.461     0.200
    44.607     0.306     0.200
    44.674     0.100     0.200
    44.802     1.011     0.200
    44.813     0.802     0.200
    44.871     0.699     0.200
    44.883     0.557     0.200
    45.021     0.291     0.200
    45.021     0.145     0.200
    45.076     0.219     0.200
    45.067     0.378     0.200
    45.067     0.964     0.200
    45.067     0.780     0.200
    45.067     1.256     0.200
    45.067     0.276     0.200
    45.291    -0.334     0.200
    45.715     0.183     0.200
    45.771    -0.568     0.200
    46.027    -0.899     0.200
    46.147    -0.341     0.200
    46.309    -1.532     0.200
    46.441    -0.193     0.200
    46.592     0.255     0.200
    46.633     0.204     0.200
    46.627     0.126     0.200
    46.737    -0.512     0.200
    46.794    -1.476     0.200
    46.798     0.228     0.200
    46.934    -0.275     0.200
    47.296    -0.146     0.200
    47.297    -0.394     0.200
    47.336    -0.414     0.200
    47.369    -0.442     0.200
    47.382    -1.115     0.200
    47.430    -0.631     0.200
    47.559     0.607     0.200
    47.560     0.882     0.200
    47.569     0.087     0.200
    47.657    -0.237     0.200
    47.689    -0.148     0.200
    47.732    -0.417     0.200
    47.794    -0.431     0.200
    47.794    -0.681     0.200
    47.901    -1.062     0.200
    48.125    -0.643     0.200
    48.292    -0.543     0.200
    48.301     0.638     0.200
    48.304    -0.694     0.200
    48.475     0.521     0.200
    48.580    -0.395     0.200
    48.623    -0.241     0.200
    48.669    -1.041     0.200
    48.730     0.896     0.200
    48.761     0.174     0.200
    48.916     0.462     0.200
    48.956    -0.497     0.200
    49.076    -1.017     0.200
    49.121     0.821     0.200
    49.143    -0.055     0.200
    49.143    -0.532     0.200
    49.186     0.917     0.200
    49.255     0.151     0.200
    49.539     0.149     0.200
    49.551     0.571     0.200
    49.713    -0.546     0.200
    49.717     0.822     0.200
    49.717     0.267     0.200
    49.724     1.189     0.200
    49.767    -0.194     0.200
    50.015     0.108     0.200
    50.038     0.262     0.200
    50.129     0.582     0.200
    50.294     0.012     0.200
    50.347     0.866     0.200
    50.317     0.683     0.200
    50.347     1.319     0.200
    50.347     0.865     0.200
    50.492    -0.136     0.200
    50.490    -1.090     0.200
    51.524    -0.482     0.200
    51.596    -0.478     0.200
    51.876    -0.599     0.200
    52.088    -0.253     0.200
    52.445    -0.199     0.200
    52.651    -0.554     0.200
    52.722    -0.186     0.200
    53.011     0.492     0.200
    53.011    -0.289     0.200
    53.908    -0.898     0.200
    54.103     0.890     0.200
    54.103     0.171     0.200
    54.194     1.128     0.200
    54.426     0.819     0.200
    54.439     0.791     0.200
    54.947    -0.785     0.200
    54.988    -0.134     0.200
    55.476    -1.014     0.200
    55.752     0.066     0.200
    55.739    -0.830     0.200
    55.739    -1.158     0.200
    56.155     2.507     0.200
    56.850     0.654     0.200
    57.240    -0.005     0.200
    57.831    -0.657     0.200
    58.806    -0.164     0.200
    58.953    -1.337     0.200
    59.355     0.938     0.200
    60.362    -0.573     0.200
    63.012     0.583     0.200
    63.319     0.156     0.200
    63.460    -1.484     0.200
    63.701    -0.369     0.200
    63.796    -0.297     0.200
    63.828    -0.558     0.200
    63.884    -0.378     0.200
    63.973    -0.461     0.200
    64.100    -1.297     0.200
    64.139    -0.555     0.200
    64.151    -0.732     0.200
    64.151    -0.302     0.200
    64.331    -0.004     0.200
    64.421     1.305     0.200
    64.460     0.130     0.200
    64.497     0.142     0.200
    64.500     0.391     0.200
    64.500     0.281     0.200
    64.536    -0.550     0.200
    64.971     0.220     0.200
    65.155    -0.694     0.200
    65.457     0.075     0.200
    65.705    -0.530     0.200
    65.705    -0.335     0.200
    65.705    -0.030     0.200
    65.721    -0.686     0.200
    65.814    -0.435     0.200
    65.904     0.421     0.200
    65.951     1.086     0.200
    66.787    -0.260     0.200
    68.492     0.896     0.200
    68.498     1.155     0.200
    68.498     0.593     0.200
    69.413    -1.050     0.200
    69.413    -1.323     0.200
    69.519     0.206     0.200
    69.933     0.212     0.200
    70.426     0.057     0.200
    70.495    -1.064     0.200
    71.516     1.049     0.200
    71.620    -1.177     0.200
    71.952     1.031     0.200
    72.167     1.168     0.200
    72.406     1.214     0.200
    72.618    -1.442     0.200
    72.949    -0.905     0.200
    73.168     0.197     0.200
    73.956    -0.030     0.200
    73.956    -0.374     0.200
    74.150     0.262     0.200
    74.183    -0.053     0.200
    74.306     0.381     0.200
    74.405    -0.672     0.200
    74.405    -0.742     0.200
    74.413    -0.889     0.200
    74.432    -0.879     0.200
    74.557     0.641     0.200
    74.796     0.496     0.200
    74.858     0.329     0.200
    75.004     0.592     0.200
    75.023     0.685     0.200
    75.307     0.446     0.200
    75.335     0.291     0.200
    75.417     0.317     0.200
    75.566     0.466     0.200
    75.619     0.559     0.200
    75.748     0.617     0.200
    75.911     1.790     0.200
    75.911     1.993     0.200
    75.986     1.168     0.200
    76.058    -0.044     0.200
    76.071    -0.223     0.200
    76.071     1.183     0.200
    76.155     0.707     0.200
    76.155     0.301     0.200
    76.261     1.200     0.200
    76.446    -0.292     0.200
    76.454     0.278     0.200
    76.455     0.506     0.200
    76.498     0.557     0.200
    76.641     0.455     0.200
    76.659     0.050     0.200
    76.916     0.305     0.200
    76.926     0.846     0.200
    77.018     0.128     0.200
    77.434     0.936     0.200
    77.462     0.046     0.200
    77.488     0.292     0.200
    77.494     0.760     0.200
    77.494     0.346     0.200
    77.655     0.683     0.200
    77.655     0.183     0.200
    77.662     0.480     0.200
    77.690    -0.234     0.200
    77.812     0.555     0.200
    77.924     0.818     0.200
    78.112     0.938     0.200
    78.195     1.302     0.200
    78.250     1.761     0.200
    78.296     0.140     0.200
    78.398     0.547     0.200
    78.481     1.031     0.200
    78.486     0.476     0.200
    78.589     1.097     0.200
    78.660     0.901     0.200
    78.679     0.694     0.200
    78.704     0.725     0.200
    78.812     0.839     0.200
    79.061    -0.220     0.200
    79.387     0.520     0.200
    79.528     0.976     0.200
    79.529    -0.050     0.200
    79.529     0.676     0.200
    79.710     0.564     0.200
    79.715     0.514     0.200
    79.780     0.627     0.200
    79.780     0.487     0.200
    79.780     1.463     0.200
    79.783     0.473     0.200
    79.822     1.259     0.200
    79.872     0.789     0.200
    79.957     1.330     0.200
    79.976     0.124     0.200
    80.211     1.764     0.200
    80.311     0.624     0.200
    80.355    -0.318     0.200
    80.455    -1.551     0.200
    80.617     0.282     0.200
    80.666     2.822     0.200
    80.676     0.964     0.200
    80.676     0.245     0.200
    80.774     0.437     0.200
    81.008     0.999     0.200
    81.065     0.990     0.200
    81.087     0.672     0.200
    81.324     1.512     0.200
    81.329     1.536     0.200
    81.481     1.123     0.200
    81.569     1.219     0.200
    81.636     0.570     0.200
    81.781     1.279     0.200
    81.827     1.258     0.200
    81.865     1.962     0.200
    81.988     2.264     0.200
    82.203     1.194     0.200
    82.339     0.983     0.200
    82.755     1.012     0.200
    82.859     2.276     0.200
    82.859     1.643     0.200
    82.982     0.234     0.200
    83.169     1.672     0.200
    83.232     0.942     0.200
    83.341     0.683     0.200
    83.576     0.879     0.200
    83.590     0.932     0.200
    83.669     0.903     0.200
    83.760     0.639     0.200
    83.903     1.003     0.200
    84.058     0.734     0.200
    84.196     1.009     0.200
    84.295     0.523     0.200
    84.381     0.633     0.200
    84.449     1.728     0.200
    84.873     1.691     0.200
    84.902     1.438     0.200
    84.927     1.195     0.200
    84.927     0.874     0.200
    85.050     1.507     0.200
    86.198     1.505     0.200
    86.198     0.747     0.200
    87.464     1.012     0.200
    90.101    -0.348     0.200
    90.119     1.023     0.200
    92.373     0.575     0.200
    92.877     0.454     0.200
    92.890    -0.389     0.200
    96.011     2.787     0.200
    96.229    -0.111     0.200
    96.253    -0.111     0.200
    17.505     1.248     0.200
    17.505     1.350     0.200
    18.731    -1.699     0.200
    18.731    -2.676     0.200
    19.791     0.336     0.200
    23.484    -0.960     0.200
    23.993     0.241     0.200
    23.994     0.001     0.200
    23.994    -0.444     0.200
    23.994     0.228     0.200
    23.985     0.152     0.200
    24.000     1.551     0.200
    24.329     2.423     0.200
    24.376     2.235     0.200
    24.383     2.249     0.200
    24.852    -1.245     0.200
    24.819     2.266     0.200
    24.990     0.018     0.200
    24.960     2.134     0.200
    24.999     0.366     0.200
    24.999    -1.352     0.200
    25.004     0.981     0.200
    25.189     1.068     0.200
    25.206     2.372     0.200
    25.849    -1.081     0.200
    25.828     2.720     0.200
    26.006    -0.014     0.200
    25.909     2.571     0.200
    25.935     1.425     0.200
    26.249     2.507     0.200
    26.301     1.727     0.200
    26.489     2.699     0.200
    26.515     1.700     0.200
    26.904     2.740     0.200
    27.147     1.924     0.200
    27.256     2.436     0.200
    27.409     2.291     0.200
    27.422     1.392     0.200
    27.424     1.877     0.200
    27.432     2.255     0.200
    27.506     2.700     0.200
    27.680     2.444     0.200
    27.786     0.991     0.200
    27.840     1.383     0.200
    27.840     1.555     0.200
    27.840     1.258     0.200
    27.838     2.322     0.200
    28.163     1.393     0.200
    28.237     2.371     0.200
    28.245     3.032     0.200
    28.357     2.724     0.200
    28.372     1.667     0.200
    28.367     2.949     0.200
    28.788     1.907     0.200
    28.845     2.656     0.200
    28.992     1.686     0.200
    29.236     2.097     0.200
    29.296     0.954     0.200
    29.400     1.150     0.200
    29.562     0.869     0.200
    29.582     0.954     0.200
    29.647     2.979     0.200
    29.745     1.155     0.200
    29.841     1.003     0.200
    29.846     1.745     0.200
    30.032     1.432     0.200
    30.021     2.199     0.200
    30.270     2.951     0.200
    30.305     2.879     0.200
    30.428     1.005     0.200
    30.428     1.474     0.200
    30.465     1.692     0.200
    30.517     1.164     0.200
    30.724     1.544     0.200
    30.780     0.493     0.200
    31.231     2.048     0.200
    31.291     1.086     0.200
    31.710     1.146     0.200
    31.845     0.789     0.200
    31.911     2.922     0.200
    32.022     1.933     0.200
    32.022     1.620     0.200
    32.107    -0.330     0.200
    32.107    -1.119     0.200
    32.182     1.235     0.200
    32.202     0.631     0.200
    32.202     1.099     0.200
    32.186     2.252     0.200
    32.196     2.289     0.200
    32.196     1.492     0.200
    32.371     2.860     0.200
    32.371     2.290     0.200
    32.447     1.445     0.200
    32.447     1.195     0.200
    32.405     2.669     0.200
    32.507     1.973     0.200
    32.818     2.390     0.200
    32.858     2.125     0.200
    32.878     2.248     0.200
    33.002     2.289     0.200
    33.072     1.727     0.200
    33.184     2.965     0.200
    33.307    -0.923     0.200
    33.307    -1.368     0.200
    33.387    -1.915     0.200
    33.388    -1.724     0.200
    33.340     0.194     0.200
    33.334     2.748     0.200
    33.334     1.834     0.200
    33.362     1.609     0.200
    33.366     1.587     0.200
    33.470     1.421     0.200
    33.504     2.681     0.200
    33.568     2.537     0.200
    33.693     2.134     0.200
    33.752     2.560     0.200
    33.752     2.403     0.200
    33.754     2.792     0.200
    33.837     2.052     0.200
    33.921     2.627     0.200
    34.038     2.860     0.200
    34.075     1.921     0.200
    34.073     1.920     0.200
    34.066     2.279     0.200
    34.084     1.846     0.200
    34.084     1.424     0.200
    34.102     3.061     0.200
    34.117     2.206     0.200
    34.202     1.637     0.200
    34.205     2.182     0.200
    34.209     2.871     0.200
    34.430     1.875     0.200
    34.470     1.944     0.200
    34.490     2.170     0.200
    34.561     1.893     0.200
    34.623     2.936     0.200
    34.631     2.892     0.200
    34.707     2.232     0.200
    34.707     2.044     0.200
    34.781     3.251     0.200
    34.884     1.723     0.200
    34.887     1.265     0.200
    34.944     1.519     0.200
    34.960     2.022     0.200
    34.960     1.749     0.200
    35.013     2.294     0.200
    35.070     1.505     0.200
    35.070     1.810     0.200
    35.122     0.732     0.200
    35.122     1.216     0.200
    35.152     1.571     0.200
    35.167     2.643     0.200
    35.172     2.064     0.200
    35.315    -0.988     0.200
    35.315    -1.699     0.200
    35.315    -2.089     0.200
    35.229     2.320     0.200
    35.228     3.146     0.200
    35.351     0.385     0.200
    35.351     1.276     0.200
    35.286     0.939     0.200
    35.291     2.391     0.200
    35.299     2.589     0.200
    35.299     2.746     0.200
    35.324     1.352     0.200
    35.324     0.445     0.200
    35.324     1.115     0.200
    35.324     1.225     0.200
    35.362     1.634     0.200
    35.388     2.738     0.200
    35.481     0.792     0.200
    35.528     2.319     0.200
    35.537     1.860     0.200
    35.542     1.667     0.200
    35.575     2.948     0.200
    35.594     1.495     0.200
    35.587     2.211     0.200
    35.587     2.625     0.200
    35.660     0.944     0.200
    35.660     0.366     0.200
    35.654     1.801     0.200
    35.773     1.757     0.200
    35.811     0.576     0.200
    35.798     1.537     0.200
    35.870     1.920     0.200
    36.028     1.897     0.200
    36.062     1.229     0.200
    36.071     1.957     0.200
    36.104     0.879     0.200
    36.159     1.828     0.200
    36.159     2.273     0.200
    36.164     1.452     0.200
    36.214     2.748     0.200
    36.231     2.672     0.200
    36.275     1.281     0.200
    36.246     2.630     0.200
    36.361     2.110     0.200
    36.457     2.053     0.200
    36.519     0.702     0.200
    36.494     1.988     0.200
    36.531     1.616     0.200
    36.557     0.775     0.200
    36.560     2.392     0.200
    36.658     1.618     0.200
    36.659     1.637     0.200
    36.745     1.913     0.200
    36.766     2.202     0.200
    36.852     2.629     0.200
    36.873     2.520     0.200
    36.905     0.849     0.200
    36.903     1.913     0.200
    36.972     2.306     0.200
    37.085     0.831     0.200
    37.085    -0.068     0.200
    37.084     1.563     0.200
    37.111     1.766     0.200
    37.153     0.725     0.200
    37.180     2.045     0.200
    37.188     1.807     0.200
    37.209     2.412     0.200
    37.211     2.318     0.200
    37.278     1.990     0.200
    37.562     1.855     0.200
    37.590     1.903     0.200
    37.590     2.145     0.200
    37.590     1.778     0.200
    37.597     2.016     0.200
    37.640     1.255     0.200
    37.650     0.776     0.200
    37.689     1.296     0.200
    37.689     0.671     0.200
    37.759     1.418     0.200
    37.759     0.871     0.200
    37.769     2.589     0.200
    37.781     2.240     0.200
    37.834     0.677     0.200
    37.927     2.269     0.200
    37.927     2.420     0.200
    37.958     2.337     0.200
    38.055     1.482     0.200
    38.055     0.372     0.200
    38.038     1.332     0.200
    38.038     1.027     0.200
    38.122     1.597     0.200
    38.147     2.549     0.200
    38.166     2.180     0.200
    38.327     1.334     0.200
    38.410     0.771     0.200
    38.388     2.244     0.200
    38.464     2.153     0.200
    38.502     2.180     0.200
    38.576     2.292     0.200
    38.576     1.980     0.200
    38.599     1.286     0.200
    38.599     0.810     0.200
    38.620     1.331     0.200
    38.631     0.947     0.200
    38.831    -1.225     0.200
    38.767     0.577     0.200
    38.767     0.702     0.200
    38.767     0.241     0.200
    38.771     0.458     0.200
    38.800     0.996     0.200
    38.920     2.218     0.200
    38.920     2.421     0.200
    39.069     0.442     0.200
    39.110     0.278     0.200
    39.096     2.051     0.200
    39.096     2.395     0.200
    39.125     2.891     0.200
    39.161     0.315     0.200
    39.299     2.067     0.200
    39.430     0.211     0.200
    39.503     1.449     0.200
    39.521     0.283     0.200
    39.543     0.558     0.200
    39.571     0.835     0.200
    39.571     1.202     0.200
    39.729    -1.122     0.200
    39.735     0.339     0.200
    39.754     0.530     0.200
    39.727     2.250     0.200
    39.759     0.489     0.200
    39.856     0.449     0.200
    39.856     0.308     0.200
    39.843     2.570     0.200
    39.885    -0.088     0.200
    39.942     0.013     0.200
    40.021     0.690     0.200
    40.213    -0.160     0.200
    40.172     0.190     0.200
    40.172     1.607     0.200
    40.172     2.537     0.200
    40.214     0.467     0.200
    40.326     1.349     0.200
    40.320     1.748     0.200
    40.320     1.967     0.200
    40.346     0.042     0.200
    40.397     0.599     0.200
    40.413     0.274     0.200
    40.533    -0.004     0.200
    40.568     0.097     0.200
    40.617     1.865     0.200
    40.646     0.456     0.200
    40.728    -0.108     0.200
    40.752     0.198     0.200
    40.780     0.796     0.200
    40.818     0.159     0.200
    40.830     1.128     0.200
    40.889     0.603     0.200
    40.870     2.431     0.200
    40.925     0.109     0.200
    40.943     1.426     0.200
    40.943     0.973     0.200
    40.990     0.007     0.200
    41.053    -0.049     0.200
    41.118     1.325     0.200
    41.220     0.168     0.200
    41.236     0.040     0.200
    41.230     0.648     0.200
    41.277     0.135     0.200
    41.361    -0.139     0.200
    41.498    -0.056     0.200
    41.503     0.015     0.200
    41.558     0.319     0.200
    41.655    -0.197     0.200
    41.642     0.807     0.200
    41.658     0.289     0.200
    41.675     0.602     0.200
    41.688     0.116     0.200
    41.757     1.375     0.200
    41.755     1.698     0.200
    41.755     2.175     0.200
    41.755     1.917     0.200
    41.782     0.203     0.200
    41.825     0.253     0.200
    41.862     0.045     0.200
    41.877     1.202     0.200
    41.990     0.415     0.200
    42.002     0.146     0.200
    41.990     1.792     0.200
    41.990     1.026     0.200
    42.055     0.108     0.200
    42.065     0.278     0.200
    42.162    -0.314     0.200
    42.162    -0.501     0.200
    42.198     0.366     0.200
    42.222    -0.163     0.200
    42.334     0.568     0.200
    42.332     0.128     0.200
    42.334     1.366     0.200
    42.334     3.061     0.200
    42.334     1.116     0.200
    42.398    -0.107     0.200
    42.406     0.023     0.200
    42.445     0.456     0.200
    42.445    -0.309     0.200
    42.440     0.044     0.200
    42.462     0.805     0.200
    42.567     0.203     0.200
    42.582     0.361     0.200
    42.653     0.247     0.200
    42.683     0.531     0.200
    42.701    -0.038     0.200
    42.684     1.396     0.200
    42.687     1.416     0.200
    42.687     2.369     0.200
    42.765     0.719     0.200
    42.776     0.541     0.200
    42.779     0.281     0.200
    42.816    -0.068     0.200
    42.802     1.543     0.200
    42.840     0.645     0.200
    42.909     0.325     0.200
    43.073    -1.256     0.200
    43.006    -0.244     0.200
    43.100     0.260     0.200
    43.117     0.318     0.200
    43.148     0.806     0.200
    43.189     0.033     0.200
    43.205     0.429     0.200
    43.261    -0.088     0.200
    43.307     2.175     0.200
    43.304     1.916     0.200
    43.373     0.364     0.200
    43.373     0.216     0.200
    43.418     0.133     0.200
    43.449    -0.034     0.200
    43.441     0.283     0.200
    43.562     1.153     0.200
    43.584    -0.064     0.200
    43.600     0.292     0.200
    43.602    -0.034     0.200
    43.677     0.331     0.200
    43.702     0.003     0.200
    43.710     0.648     0.200
    43.808     0.550     0.200
    43.796     0.566     0.200
    43.798    -0.269     0.200
    43.962     0.398     0.200
    44.151    -1.703     0.200
    44.151    -1.070     0.200
    44.080     0.397     0.200
    44.081    -0.052     0.200
    44.123     0.606     0.200
    44.131     0.512     0.200
    44.238    -1.698     0.200
    44.157     0.228     0.200
    44.137     1.590     0.200
    44.303    -0.296     0.200
    44.323     0.558     0.200
    44.378     0.288     0.200
    44.402     0.234     0.200
    44.419     0.767     0.200
    44.456     0.009     0.200
    44.552     0.558     0.200
    44.553     0.198     0.200
    44.553     0.687     0.200
    44.553     0.320     0.200
    44.553     0.586     0.200
    44.569     0.659     0.200
    44.537     0.460     0.200
    44.557     0.666     0.200
    44.647     0.238     0.200
    44.756     0.202     0.200
    44.749     0.026     0.200
    44.779     0.438     0.200
    44.796    -0.540     0.200
    44.805     0.295     0.200
    44.847    -0.096     0.200
    44.916     0.750     0.200
    44.976     0.273     0.200
    45.022     0.118     0.200
    45.104     0.467     0.200
    45.103     0.187     0.200
    45.143     0.222     0.200
    45.145     0.943     0.200
    45.145     0.576     0.200
    45.176    -0.317     0.200
    45.162     0.662     0.200
    45.162     0.514     0.200
    45.173    -0.204     0.200
    45.173     0.171     0.200
    45.225     0.248     0.200
    45.244    -0.228     0.200
    45.300     1.883     0.200
    45.300     1.164     0.200
    45.346     0.352     0.200
    45.393     0.538     0.200
    45.427     0.183     0.200
    45.442     0.751     0.200
    45.481    -0.653     0.200
    45.583     0.066     0.200
    45.603     0.083     0.200
    45.630     0.094     0.200
    45.651     0.391     0.200
    45.665    -0.711     0.200
    45.676    -0.225     0.200
    45.796    -0.499     0.200
    45.834     0.133     0.200
    45.871     0.160     0.200
    45.905    -0.551     0.200
    45.927    -0.610     0.200
    45.935     0.068     0.200
    45.973     0.222     0.200
    46.046     0.290     0.200
    46.060     0.649     0.200
    46.076    -0.247     0.200
    46.101    -0.367     0.200
    46.087     0.429     0.200
    46.122     0.159     0.200
    46.129     0.114     0.200
    46.142    -0.301     0.200
    46.263    -0.743     0.200
    46.256     0.171     0.200
    46.274    -0.517     0.200
    46.285    -0.110     0.200
    46.304     0.233     0.200
    46.333    -0.051     0.200
    46.335     0.052     0.200
    46.411    -1.006     0.200
    46.389     0.839     0.200
    46.431    -0.450     0.200
    46.540    -0.816     0.200
    46.455    -0.222     0.200
    46.549     0.514     0.200
    46.549     0.115     0.200
    46.461     0.094     0.200
    46.461    -0.023     0.200
    46.607    -0.590     0.200
    46.563    -0.755     0.200
    46.650    -0.484     0.200
    46.584     0.042     0.200
    46.672    -0.787     0.200
    46.694    -0.043     0.200
    46.724    -0.143     0.200
    46.720    -0.090     0.200
    46.729    -0.471     0.200
    46.819     0.942     0.200
    46.863     0.386     0.200
    46.964    -0.438     0.200
    46.891     0.002     0.200
    46.891    -0.154     0.200
    47.002     0.569     0.200
    47.002     0.264     0.200
    46.931     0.604     0.200
    46.931     0.026     0.200
    46.971    -0.179     0.200
    46.983    -0.790     0.200
    46.985     0.132     0.200
    47.109    -0.310     0.200
    47.120    -0.342     0.200
    47.164     0.289     0.200
    47.194    -0.402     0.200
    47.233     0.358     0.200
    47.356    -1.174     0.200
    47.293    -0.687     0.200
    47.335    -0.144     0.200
    47.346    -1.233     0.200
    47.494    -0.613     0.200
    47.496    -0.400     0.200
    47.533     0.039     0.200
    47.540     0.020     0.200
    47.578     1.078     0.200
    47.727    -1.079     0.200
    47.743     0.394     0.200
    47.760    -0.555     0.200
    47.756    -1.016     0.200
    47.905     0.157     0.200
    47.842    -0.461     0.200
    47.836     0.068     0.200
    47.836    -0.182     0.200
    47.836     0.201     0.200
    47.880    -0.108     0.200
    47.917    -0.540     0.200
    47.956    -0.397     0.200
    47.945     0.624     0.200
    47.945     0.757     0.200
    48.040     0.312     0.200
    48.040    -0.009     0.200
    47.976     0.187     0.200
    48.021    -1.473     0.200
    48.043     1.290     0.200
    48.042     0.764     0.200
    48.043     1.290     0.200
    48.080     0.739     0.200
    48.111     0.317     0.200
    48.127     0.247     0.200
    48.159    -1.075     0.200
    48.212    -1.041     0.200
    48.219     0.311     0.200
    48.231    -0.080     0.200
    48.278    -0.501     0.200
    48.330     1.568     0.200
    48.359     0.129     0.200
    48.359    -0.082     0.200
    48.378     0.604     0.200
    48.408     0.154     0.200
    48.423    -0.660     0.200
    48.531    -0.768     0.200
    48.451    -1.062     0.200
    48.458     0.288     0.200
    48.534     0.716     0.200
    48.556    -1.240     0.200
    48.587     0.219     0.200
    48.669    -0.471     0.200
    48.720     2.201     0.200
    48.776     0.369     0.200
    48.816     0.392     0.200
    48.821     0.134     0.200
    48.839    -1.019     0.200
    48.856    -1.094     0.200
    48.949     1.789     0.200
    48.980    -0.722     0.200
    48.889     0.452     0.200
    48.975     0.818     0.200
    48.996    -1.141     0.200
    49.012     0.377     0.200
    49.126    -0.617     0.200
    49.164     0.200     0.200
    49.301     0.834     0.200
    49.218    -0.911     0.200
    49.229     0.227     0.200
    49.269     0.482     0.200
    49.269     0.490     0.200
    49.274     0.188     0.200
    49.289     0.308     0.200
    49.303     0.796     0.200
    49.340     0.239     0.200
    49.364    -1.358     0.200
    49.422     0.511     0.200
    49.422     0.308     0.200
    49.499    -0.202     0.200
    49.623    -0.757     0.200
    49.641    -0.416     0.200
    49.631     0.222     0.200
    49.673     0.590     0.200
    49.673     0.348     0.200
    49.718    -2.090     0.200
    49.711    -0.169     0.200
    49.711    -0.396     0.200
    49.701     0.785     0.200
    49.763    -1.312     0.200
    49.878     0.735     0.200
    49.849     0.053     0.200
    49.878     0.735     0.200
    49.795     0.099     0.200
    49.855    -0.350     0.200
    49.859     0.285     0.200
    49.862     0.467     0.200
    49.914    -0.224     0.200
    49.961    -0.190     0.200
    50.021    -1.154     0.200
    50.057    -0.248     0.200
    50.064     0.688     0.200
    50.081     0.205     0.200
    50.081    -0.201     0.200
    50.081    -0.701     0.200
    50.149    -1.584     0.200
    50.168     0.140     0.200
    50.187     0.315     0.200
    50.209     0.639     0.200
    50.216     0.003     0.200
    50.219     0.628     0.200
    50.250    -1.279     0.200
    50.267    -1.146     0.200
    50.277    -0.744     0.200
    50.321    -0.017     0.200
    50.321    -0.759     0.200
    50.309     0.275     0.200
    50.309    -0.405     0.200
    50.312    -1.483     0.200
    50.343    -0.715     0.200
    50.401    -1.111     0.200
    50.446    -1.299     0.200
    50.470     0.611     0.200
    50.484     0.919     0.200
    50.525     0.375     0.200
    50.542    -0.315     0.200
    50.551    -0.191     0.200
    50.560     0.356     0.200
    50.622    -0.083     0.200
    50.629    -0.999     0.200
    50.633    -0.397     0.200
    50.665    -0.075     0.200
    50.731    -0.567     0.200
    50.738    -0.480     0.200
    50.780    -0.809     0.200
    50.861    -0.887     0.200
    50.950     0.339     0.200
    50.951     1.020     0.200
    50.963    -0.436     0.200
    50.960     0.895     0.200
    51.061    -0.202     0.200
    50.986     0.544     0.200
    51.019     0.769     0.200
    51.027     0.605     0.200
    51.045    -1.045     0.200
    51.067    -0.586     0.200
    51.055    -0.467     0.200
    51.048     0.715     0.200
    51.078     0.954     0.200
    51.077     0.155     0.200
    51.106     0.641     0.200
    51.114     0.458     0.200
    51.121    -0.654     0.200
    51.221     0.885     0.200
    51.221     0.291     0.200
    51.266     0.874     0.200
    51.288    -0.469     0.200
    51.289     1.243     0.200
    51.307     0.946     0.200
    51.323    -0.407     0.200
    51.357     1.068     0.200
    51.382     0.813     0.200
    51.385     0.378     0.200
    51.408     1.259     0.200
    51.452     0.382     0.200
    51.452     0.684     0.200
    51.463     0.771     0.200
    51.513    -0.180     0.200
    51.547    -0.543     0.200
    51.572    -0.058     0.200
    51.622     0.692     0.200
    51.645    -1.257     0.200
    51.655    -0.367     0.200
    51.736     0.155     0.200
    51.732     1.474     0.200
    51.739     1.416     0.200
    51.754     1.597     0.200
    51.781     0.481     0.200
    51.785     1.659     0.200
    51.822     0.069     0.200
    51.837     1.042     0.200
    51.866     0.919     0.200
    51.871     1.038     0.200
    51.886    -0.237     0.200
    51.902     1.856     0.200
    51.934     0.352     0.200
    51.964    -0.597     0.200
    52.089    -0.269     0.200
    52.062     0.286     0.200
    52.090    -0.142     0.200
    52.111     1.078     0.200
    52.113     1.759     0.200
    52.140     1.629     0.200
    52.162     0.522     0.200
    52.171    -0.080     0.200
    52.199     1.576     0.200
    52.205     2.075     0.200
    52.253     0.116     0.200
    52.253    -0.282     0.200
    52.281     0.949     0.200
    52.388    -0.086     0.200
    52.316     1.760     0.200
    52.387     0.213     0.200
    52.424     0.046     0.200
    52.452    -1.006     0.200
    52.439     0.268     0.200
    52.476     0.139     0.200
    52.461     0.522     0.200
    52.505    -0.053     0.200
    52.505    -0.310     0.200
    52.577    -0.282     0.200
    52.615     1.056     0.200
    52.597     3.239     0.200
    52.628     1.553     0.200
    52.641     0.753     0.200
    52.642     1.740     0.200
    52.664    -0.369     0.200
    52.646     2.369     0.200
    52.662     0.746     0.200
    52.696     0.554     0.200
    52.733     1.676     0.200
    52.806     0.064     0.200
    52.893     0.128     0.200
    52.998     1.958     0.200
    53.021    -0.637     0.200
    53.095     0.262     0.200
    53.049     2.339     0.200
    53.057     1.157     0.200
    53.060     1.663     0.200
    53.113    -0.812     0.200
    53.099     1.093     0.200
    53.153     1.978     0.200
    53.165    -0.090     0.200
    53.226    -0.604     0.200
    53.216     0.419     0.200
    53.274    -0.139     0.200
    53.281     0.347     0.200
    53.440     1.444     0.200
    53.541    -0.983     0.200
    53.527     0.500     0.200
    53.525     1.137     0.200
    53.558     0.634     0.200
    53.569     1.324     0.200
    53.576     1.078     0.200
    53.586    -0.034     0.200
    53.644    -0.986     0.200
    53.725    -0.094     0.200
    53.716     0.852     0.200
    53.859    -0.011     0.200
    53.838    -0.536     0.200
    53.954     0.901     0.200
    53.863     1.241     0.200
    53.901    -1.436     0.200
    53.889     1.549     0.200
    53.963     0.797     0.200
    53.985    -1.109     0.200
    54.022    -0.001     0.200
    54.129    -0.201     0.200
    54.142    -0.112     0.200
    54.142    -0.112     0.200
    54.063     0.437     0.200
    54.215     0.098     0.200
    54.178    -0.449     0.200
    54.222    -0.491     0.200
    54.321     1.534     0.200
    54.380    -0.771     0.200
    54.388    -0.892     0.200
    54.483    -0.851     0.200
    54.475     0.411     0.200
    54.477     0.099     0.200
    54.501     0.128     0.200
    54.489    -0.579     0.200
    54.589     0.680     0.200
    54.608    -0.358     0.200
    54.590    -0.773     0.200
    54.616    -0.997     0.200
    54.695    -1.557     0.200
    54.706     1.261     0.200
    54.723     0.705     0.200
    54.743     0.021     0.200
    54.747     0.460     0.200
    54.892    -1.417     0.200
    54.877    -0.730     0.200
    54.889    -0.891     0.200
    54.889    -1.141     0.200
    54.956    -1.345     0.200
    55.144     0.879     0.200
    55.218    -0.317     0.200
    55.241    -0.197     0.200
    55.266    -0.250     0.200
    55.340    -0.439     0.200
    55.449     0.969     0.200
    55.523    -0.437     0.200
    55.518     1.905     0.200
    55.625     0.102     0.200
    55.646    -0.142     0.200
    55.648     0.159     0.200
    55.760    -0.879     0.200
    55.851    -0.484     0.200
    55.868    -0.370     0.200
    55.866    -1.149     0.200
    55.958    -1.225     0.200
    55.958    -0.951     0.200
    55.958    -1.366     0.200
    55.958    -1.624     0.200
    55.958    -0.324     0.200
    55.871     1.256     0.200
    55.962    -0.792     0.200
    56.005     0.258     0.200
    56.026    -1.150     0.200
    56.077    -1.071     0.200
    56.296     0.223     0.200
    56.343    -0.716     0.200
    56.478     1.114     0.200
    56.445    -0.049     0.200
    56.445    -0.674     0.200
    56.571    -0.535     0.200
    56.589    -0.077     0.200
    56.589    -0.725     0.200
    56.604     0.027     0.200
    56.634    -0.412     0.200
    56.695    -1.223     0.200
    56.695    -1.653     0.200
    56.732    -1.315     0.200
    56.813    -0.065     0.200
    56.798     0.144     0.200
    56.954     1.141     0.200
    56.954     0.399     0.200
    56.941     1.815     0.200
    56.974    -0.632     0.200
    57.023    -0.839     0.200
    57.063    -0.942     0.200
    57.130    -1.201     0.200
    57.130    -1.623     0.200
    57.069    -0.743     0.200
    57.234     2.413     0.200
    57.391     0.114     0.200
    57.406    -1.178     0.200
    57.465     0.334     0.200
    57.541    -2.099     0.200
    57.519    -0.718     0.200
    57.641    -0.808     0.200
    57.671     0.238     0.200
    58.079    -1.867     0.200
    58.287     1.367     0.200
    58.282     0.706     0.200
    58.332    -0.697     0.200
    58.488    -0.332     0.200
    58.481     0.279     0.200
    58.681    -0.273     0.200
    58.810    -0.502     0.200
    58.814    -1.025     0.200
    58.814    -0.533     0.200
    58.777    -0.172     0.200
    58.899     0.211     0.200
    59.195    -0.447     0.200
    61.810     0.194     0.200
    61.811    -0.542     0.200
    62.042    -2.327     0.200
    62.251    -0.625     0.200
    62.570     0.346     0.200
    62.589     0.439     0.200
    62.722    -0.325     0.200
    62.921     0.512     0.200
    63.037    -0.862     0.200
    63.079     0.313     0.200
    63.292    -0.708     0.200
    63.332    -0.385     0.200
    63.523    -0.382     0.200
    63.566    -0.359     0.200
    63.600    -0.782     0.200
    63.669     0.058     0.200
    63.669    -0.411     0.200
    63.711    -0.218     0.200
    63.778    -0.637     0.200
    63.961     0.104     0.200
    63.999     0.460     0.200
    64.037    -1.249     0.200
    64.038    -0.661     0.200
    64.038    -0.693     0.200
    64.033    -0.253     0.200
    64.038    -0.359     0.200
    64.061     1.278     0.200
    64.067     0.645     0.200
    64.178    -0.416     0.200
    64.254    -0.953     0.200
    64.380    -0.543     0.200
    64.395     0.219     0.200
    64.409    -0.543     0.200
    64.432    -0.058     0.200
    64.436    -0.073     0.200
    64.424    -0.282     0.200
    64.427    -0.278     0.200
    64.433    -0.055     0.200
    64.433    -0.156     0.200
    64.433    -0.281     0.200
    64.433    -0.281     0.200
    64.504     0.273     0.200
    64.525    -0.441     0.200
    64.557    -0.760     0.200
    64.557    -0.963     0.200
    64.615    -0.280     0.200
    64.640    -0.031     0.200
    64.640     0.648     0.200
    64.751    -0.494     0.200
    64.751    -0.815     0.200
    64.749    -0.052     0.200
    64.914    -0.087     0.200
    64.914    -0.345     0.200
    64.810     1.027     0.200
    65.309     0.022     0.200
    65.484     0.102     0.200
    65.514    -0.046     0.200
    65.534    -0.205     0.200
    65.534    -0.400     0.200
    65.534    -0.401     0.200
    65.549    -0.517     0.200
    65.645    -0.522     0.200
    65.646     0.253     0.200
    65.672     0.366     0.200
    65.729     0.934     0.200
    65.748     0.338     0.200
    65.748     0.018     0.200
    65.783     0.240     0.200
    65.846     0.181     0.200
    65.905    -0.025     0.200
    65.924     0.232     0.200
    66.032     0.289     0.200
    66.214     0.013     0.200
    66.450     0.121     0.200
    66.556     0.257     0.200
    66.635     0.253     0.200
    66.642     0.574     0.200
    66.913     0.250     0.200
    66.940    -0.087     0.200
    66.990    -0.227     0.200
    67.063     0.471     0.200
    67.393     0.301     0.200
    67.682     0.093     0.200
    67.792     1.134     0.200
    67.856     0.384     0.200
    68.105     0.830     0.200
    68.202     0.228     0.200
    68.268     0.255     0.200
    68.348     0.133     0.200
    68.465     0.203     0.200
    68.495     0.349     0.200
    68.825    -0.063     0.200
    68.847     0.449     0.200
    68.857     0.263     0.200
    68.857     0.138     0.200
    68.911     0.606     0.200
    69.000     0.182     0.200
    69.018     2.341     0.200
    69.073     0.311     0.200
    69.088     0.239     0.200
    69.513     0.108     0.200
    69.557    -0.889     0.200
    69.557    -1.194     0.200
    69.581     0.270     0.200
    69.646     0.412     0.200
    69.723     0.096     0.200
    69.744     0.328     0.200
    69.792    -0.028     0.200
    69.837     0.288     0.200
    69.907     0.107     0.200
    70.003     0.566     0.200
    70.066    -1.612     0.200
    70.134    -0.005     0.200
    70.180     0.384     0.200
    70.409    -0.279     0.200
    70.486    -0.186     0.200
    70.552     0.705     0.200
    70.542    -1.031     0.200
    70.542    -0.570     0.200
    70.549     0.781     0.200
    70.634     3.011     0.200
    70.778    -0.175     0.200
    70.766    -0.143     0.200
    70.843     0.954     0.200
    70.861     0.851     0.200
    70.890    -0.142     0.200
    71.007     0.608     0.200
    71.035    -0.228     0.200
    71.041     0.401     0.200
    71.177    -1.638     0.200
    71.162     0.684     0.200
    71.224     0.692     0.200
    71.222     2.206     0.200
    71.573    -0.665     0.200
    71.624     0.302     0.200
    71.631     0.413     0.200
    71.806     0.325     0.200
    71.724     0.295     0.200
    71.755     0.807     0.200
    71.777    -0.284     0.200
    71.857    -0.398     0.200
    71.874     1.567     0.200
    72.021     1.110     0.200
    72.021     0.141     0.200
    72.021     0.977     0.200
    72.021     0.790     0.200
    72.123     0.430     0.200
    72.304     0.241     0.200
    72.309     0.427     0.200
    72.261    -0.027     0.200
    72.372     0.153     0.200
    72.453     0.755     0.200
    72.500     0.467     0.200
    72.513     0.281     0.200
    72.564     1.009     0.200
    72.617    -2.518     0.200
    72.721    -0.933     0.200
    72.759     0.459     0.200
    72.699     2.898     0.200
    72.703     3.077     0.200
    72.792     0.329     0.200
    72.774     2.452     0.200
    72.883     0.553     0.200
    72.915     0.601     0.200
    73.051     0.014     0.200
    73.032     0.206     0.200
    72.932     3.321     0.200
    73.069    -1.192     0.200
    73.214     0.748     0.200
    73.220     0.510     0.200
    73.511     0.141     0.200
    73.511     0.609     0.200
    73.553     0.548     0.200
    73.665     1.527     0.200
    73.942     2.026     0.200
    74.073     1.808     0.200
    74.073     0.910     0.200
    74.168     0.336     0.200
    74.236    -0.037     0.200
    74.289     0.245     0.200
    74.261     1.711     0.200
    74.343     0.369     0.200
    74.295     0.916     0.200
    74.447     0.405     0.200
    74.503     0.432     0.200
    74.558     0.061     0.200
    74.587    -0.501     0.200
    74.587    -0.680     0.200
    74.595    -0.624     0.200
    74.595    -0.984     0.200
    74.614    -1.194     0.200
    74.630     0.330     0.200
    74.603     2.034     0.200
    74.703     0.361     0.200
    74.790     0.473     0.200
    74.709     0.491     0.200
    74.885    -0.097     0.200
    74.885     0.376     0.200
    74.901    -0.290     0.200
    74.983     0.431     0.200
    74.990     0.415     0.200
    75.067     0.651     0.200
    75.121     0.542     0.200
    75.199     1.532     0.200
    75.284     0.903     0.200
    75.287     0.781     0.200
    75.431     0.372     0.200
    75.431    -0.230     0.200
    75.453     0.955     0.200
    75.453     0.634     0.200
    75.566     0.583     0.200
    75.570     0.662     0.200
    75.592     2.137     0.200
    75.592     1.738     0.200
    75.606     0.454     0.200
    75.687     0.592     0.200
    75.741    -0.014     0.200
    75.629     0.624     0.200
    75.771     0.610     0.200
    75.816     0.561     0.200
    75.873     0.533     0.200
    75.873     0.033     0.200
    75.970     0.774     0.200
    75.907     0.718     0.200
    76.080    -0.248     0.200
    76.217     1.574     0.200
    76.265     0.600     0.200
    76.331     0.726     0.200
    76.393     0.778     0.200
    76.433     0.953     0.200
    76.433     0.328     0.200
    76.503     1.556     0.200
    76.570     0.177     0.200
    76.679     0.855     0.200
    76.723     0.213     0.200
    76.723     0.541     0.200
    76.731    -0.060     0.200
    76.789    -0.161     0.200
    76.794     0.608     0.200
    76.865     0.612     0.200
    76.950     0.034     0.200
    76.981     0.155     0.200
    76.975     0.590     0.200
    77.136     1.288     0.200
    77.136     1.187     0.200
    77.091     0.985     0.200
    77.091     1.844     0.200
    77.091     1.242     0.200
    77.162     1.445     0.200
    77.162     0.948     0.200
    77.201    -0.378     0.200
    77.334     0.479     0.200
    77.346    -0.392     0.200
    77.515     0.417     0.200
    77.610    -0.266     0.200
    77.699     1.071     0.200
    77.733     1.254     0.200
    77.733     1.051     0.200
    77.736     0.502     0.200
    77.672     0.937     0.200
    77.867     0.198     0.200
    77.895     0.650     0.200
    77.895     0.548     0.200
    77.904     0.203     0.200
    77.945     0.777     0.200
    77.956     1.015     0.200
    78.029    -0.389     0.200
    78.098    -0.079     0.200
    78.093     0.771     0.200
    78.106     0.832     0.200
    78.140     0.966     0.200
    78.172     1.613     0.200
    78.172     0.909     0.200
    78.097     0.732     0.200
    78.214     1.278     0.200
    78.292     1.152     0.200
    78.301    -1.099     0.200
    78.301    -0.302     0.200
    78.369     1.174     0.200
    78.309    -0.040     0.200
    78.309     0.717     0.200
    78.408     1.146     0.200
    78.345    -0.365     0.200
    78.400     0.355     0.200
    78.460     1.421     0.200
    78.478     0.629     0.200
    78.475     1.536     0.200
    78.403     2.633     0.200
    78.453    -0.218     0.200
    78.609     0.202     0.200
    78.591    -0.098     0.200
    78.591     0.980     0.200
    78.634     0.169     0.200
    78.734     1.017     0.200
    78.721     0.188     0.200
    78.726     0.461     0.200
    78.771     0.538     0.200
    78.781     1.322     0.200
    78.809     0.500     0.200
    78.808     0.906     0.200
    78.826     0.789     0.200
    78.860     0.925     0.200
    78.863     0.105     0.200
    78.786     0.004     0.200
    78.870     0.770     0.200
    78.869     0.978     0.200
    78.828     1.642     0.200
    78.923     0.079     0.200
    78.929     0.959     0.200
    78.934     0.473     0.200
    78.959     0.577     0.200
    78.974     0.888     0.200
    78.987     0.228     0.200
    79.018     0.560     0.200
    79.039     0.341     0.200
    79.085     0.992     0.200
    79.058     1.035     0.200
    79.058     0.887     0.200
    79.173     1.215     0.200
    79.186     0.632     0.200
    79.326     0.572     0.200
    79.339    -0.036     0.200
    79.359     0.893     0.200
    79.399     0.778     0.200
    79.409     0.823     0.200
    79.373    -0.381     0.200
    79.532     1.259     0.200
    79.549     0.211     0.200
    79.558     0.715     0.200
    79.556     0.920     0.200
    79.582     0.783     0.200
    79.592    -0.467     0.200
    79.609     1.032     0.200
    79.609     0.633     0.200
    79.620     0.974     0.200
    79.649     1.517     0.200
    79.646     1.436     0.200
    79.640     1.068     0.200
    79.648     0.726     0.200
    79.648     0.421     0.200
    79.684    -0.032     0.200
    79.712     0.781     0.200
    79.722    -0.172     0.200
    79.724     1.479     0.200
    79.646     1.044     0.200
    79.793     1.093     0.200
    79.778     1.318     0.200
    79.803     0.890     0.200
    79.730     0.296     0.200
    79.852     0.817     0.200
    79.858    -0.412     0.200
    79.875     0.996     0.200
    79.895     1.486     0.200
    79.898     1.770     0.200
    79.979     0.732     0.200
    79.979     1.029     0.200
    80.003     0.465     0.200
    80.011     0.664     0.200
    80.032     1.546     0.200
    80.038     1.211     0.200
    80.060     0.304     0.200
    80.076     0.910     0.200
    80.080     0.084     0.200
    80.104     0.457     0.200
    80.109     0.526     0.200
    80.118    -0.016     0.200
    80.161     1.049     0.200
    80.074     0.031     0.200
    80.160     0.258     0.200
    80.166     1.021     0.200
    80.164     1.030     0.200
    80.165     1.087     0.200
    80.161     1.835     0.200
    80.161     1.609     0.200
    80.217     0.449     0.200
    80.254     1.454     0.200
    80.273     1.351     0.200
    80.241     0.525     0.200
    80.289     2.767     0.200
    80.286     1.373     0.200
    80.318     0.509     0.200
    80.359     0.086     0.200
    80.360     0.078     0.200
    80.360     0.179     0.200
    80.360     0.359     0.200
    80.372    -0.385     0.200
    80.359    -0.212     0.200
    80.407     1.031     0.200
    80.456     0.371     0.200
    80.462     0.430     0.200
    80.502     1.120     0.200
    80.524    -1.198     0.200
    80.544     0.641     0.200
    80.651     0.722     0.200
    80.649     0.847     0.200
    80.649     0.980     0.200
    80.659     0.373     0.200
    80.671     0.718     0.200
    80.729     1.936     0.200
    80.756     0.358     0.200
    80.773    -0.132     0.200
    80.777     0.547     0.200
    80.764     2.217     0.200
    80.786     1.330     0.200
    80.786     0.877     0.200
    80.843     0.694     0.200
    80.853     1.144     0.200
    80.861     1.102     0.200
    80.857     0.317     0.200
    80.857    -0.183     0.200
    80.737     3.061     0.200
    80.888     0.045     0.200
    80.901     0.081     0.200
    80.922     0.876     0.200
    80.918     0.195     0.200
    80.959     0.479     0.200
    80.959     1.476     0.200
    80.987     0.126     0.200
    81.007     1.323     0.200
    81.007    -0.076     0.200
    81.038     0.399     0.200
    81.054     0.266     0.200
    81.060     0.641     0.200
    81.096     0.708     0.200
    81.159    -0.586     0.200
    81.097     0.422     0.200
    81.166    -0.125     0.200
    81.172     1.549     0.200
    81.197     0.172     0.200
    81.218     1.202     0.200
    81.188     0.657     0.200
    81.201     0.392     0.200
    81.240     0.547     0.200
    81.241     1.664     0.200
    81.264     1.152     0.200
    81.253     1.312     0.200
    81.284     0.748     0.200
    81.313    -0.003     0.200
    81.343     1.497     0.200
    81.388     1.299     0.200
    81.339     0.355     0.200
    81.339     0.019     0.200
    81.410     1.182     0.200
    81.437     0.640     0.200
    81.466     1.183     0.200
    81.503     1.195     0.200
    81.553     0.429     0.200
    81.577     2.098     0.200
    81.584     1.560     0.200
    81.623     1.456     0.200
    81.645     0.544     0.200
    81.688     1.513     0.200
    81.730     1.193     0.200
    81.738     1.247     0.200
    81.733     1.579     0.200
    81.786    -0.404     0.200
    81.837     0.930     0.200
    81.933     1.723     0.200
    81.933     1.418     0.200
    81.975     1.404     0.200
    82.004    -0.049     0.200
    82.044     0.772     0.200
    82.055     2.227     0.200
    82.113     0.677     0.200
    82.178     0.746     0.200
    82.198    -0.264     0.200
    82.208    -0.318     0.200
    82.203     1.115     0.200
    82.142     1.017     0.200
    82.227     0.686     0.200
    82.238     1.525     0.200
    82.278     1.017     0.200
    82.321     0.519     0.200
    82.325     0.976     0.200
    82.432     1.058     0.200
    82.453     0.502     0.200
    82.523     1.641     0.200
    82.522    -0.853     0.200
    82.539     1.299     0.200
    82.613     2.068     0.200
    82.512     0.790     0.200
    82.512    -0.093     0.200
    82.612     1.573     0.200
    82.612     0.909     0.200
    82.747     1.042     0.200
    82.755     0.435     0.200
    82.754     1.438     0.200
    82.780     0.805     0.200
    82.772    -0.353     0.200
    82.772    -0.993     0.200
    82.843     0.476     0.200
    82.889     0.339     0.200
    82.915     2.074     0.200
    82.915     1.808     0.200
    82.915     1.105     0.200
    82.919     1.869     0.200
    82.827    -0.276     0.200
    82.958     0.082     0.200
    82.866     0.646     0.200
    82.923     0.155     0.200
    82.996     0.287     0.200
    83.023     0.581     0.200
    83.027     0.915     0.200
    83.056     0.474     0.200
    83.095     0.463     0.200
    83.094     0.358     0.200
    83.109     0.200     0.200
    83.138     1.553     0.200
    83.165     1.115     0.200
    83.194     1.161     0.200
    83.209    -0.015     0.200
    83.191     1.281     0.200
    83.225     0.307     0.200
    83.225     0.502     0.200
    83.225     0.502     0.200
    83.225     0.307     0.200
    83.242     1.968     0.200
    83.270     1.167     0.200
    83.174    -0.183     0.200
    83.275     1.133     0.200
    83.226    -0.083     0.200
    83.327     0.188     0.200
    83.355     0.136     0.200
    83.417     0.217     0.200
    83.469     0.147     0.200
    83.481     1.724     0.200
    83.401     0.151     0.200
    83.544     2.189     0.200
    83.566     0.248     0.200
    83.549    -0.040     0.200
    83.656     0.888     0.200
    83.656     1.098     0.200
    83.644     1.448     0.200
    83.691     0.310     0.200
    83.718     0.870     0.200
    83.730     2.122     0.200
    83.761     0.561     0.200
    83.774     2.596     0.200
    83.757     1.074     0.200
    83.812     3.069     0.200
    83.832     0.692     0.200
    83.884     1.651     0.200
    83.886     0.609     0.200
    83.876     1.368     0.200
    83.833    -0.017     0.200
    83.902     0.676     0.200
    83.972     1.275     0.200
    83.981     0.931     0.200
    83.981     0.649     0.200
    84.018     1.885     0.200
    83.929     1.400     0.200
    84.059     1.112     0.200
    84.039     0.638     0.200
    84.081     0.921     0.200
    84.119    -0.081     0.200
    84.149     0.975     0.200
    84.158     1.110     0.200
    84.182     0.003     0.200
    84.205     1.088     0.200
    84.239     0.634     0.200
    84.171    -0.396     0.200
    84.171    -0.169     0.200
    84.278     0.819     0.200
    84.278     1.077     0.200
    84.303     0.890     0.200
    84.303     0.593     0.200
    84.318     1.015     0.200
    84.333    -0.163     0.200
    84.381     2.221     0.200
    84.285     1.810     0.200
    84.285     1.365     0.200
    84.427     1.167     0.200
    84.448     0.562     0.200
    84.483     2.479     0.200
    84.505     1.272     0.200
    84.528     0.597     0.200
    84.531     0.840     0.200
    84.553     0.328     0.200
    84.615     1.217     0.200
    84.647     1.151     0.200
    84.198     1.689     0.200
    84.707     0.550     0.200
    84.740     2.700     0.200
    84.751     0.531     0.200
    84.844     0.361     0.200
    84.836     1.006     0.200
    84.863     1.649     0.200
    84.860     1.078     0.200
    84.815     0.875     0.200
    84.900     1.545     0.200
    84.942     0.684     0.200
    84.942     0.973     0.200
    84.969     2.202     0.200
    84.984     0.060     0.200
    85.006    -0.151     0.200
    85.018     1.091     0.200
    85.041     1.369     0.200
    85.047     1.127     0.200
    84.966    -0.866     0.200
    85.065     1.004     0.200
    85.065     0.722     0.200
    85.065     1.002     0.200
    85.079     1.279     0.200
    85.112     2.048     0.200
    85.118     1.088     0.200
    85.195     0.104     0.200
    85.180     1.078     0.200
    85.214     0.307     0.200
    85.218     0.788     0.200
    85.219     0.585     0.200
    85.240     0.854     0.200
    85.304     1.067     0.200
    85.312     0.316     0.200
    85.364     0.806     0.200
    85.364     0.962     0.200
    85.436     0.604     0.200
    85.467     1.046     0.200
    85.499     0.191     0.200
    85.493     0.914     0.200
    85.493     0.296     0.200
    85.426     0.082     0.200
    85.561     1.031     0.200
    85.594     0.513     0.200
    85.577     1.403     0.200
    85.604     0.162     0.200
    85.622     1.828     0.200
    85.627    -0.759     0.200
    85.632    -0.275     0.200
    85.672     0.431     0.200
    85.694     1.510     0.200
    85.635     1.162     0.200
    85.751     2.062     0.200
    85.813    -0.328     0.200
    85.918     2.013     0.200
    85.936     0.717     0.200
    85.980     1.105     0.200
    86.007     1.728     0.200
    86.007     1.033     0.200
    86.032     0.650     0.200
    86.047    -0.228     0.200
    86.072     0.783     0.200
    86.097     0.673     0.200
    86.113     1.642     0.200
    86.111     0.551     0.200
    86.111     0.456     0.200
    86.088     0.774     0.200
    86.176    -0.159     0.200
    86.184    -0.007     0.200
    86.209    -0.131     0.200
    86.243     0.010     0.200
    86.268    -0.112     0.200
    86.346     1.199     0.200
    86.379    -0.261     0.200
    86.399     1.842     0.200
    86.399    -0.155     0.200
    86.424     0.629     0.200
    86.459     0.552     0.200
    86.497     0.760     0.200
    86.580    -0.543     0.200
    86.655     2.431     0.200
    86.695    -0.309     0.200
    86.699     0.671     0.200
    86.748     0.533     0.200
    86.779    -0.066     0.200
    86.834     1.754     0.200
    86.878     2.037     0.200
    86.887    -0.647     0.200
    86.930    -0.659     0.200
    86.911     1.035     0.200
    87.005     0.680     0.200
    87.019     0.510     0.200
    87.030     0.558     0.200
    87.053     0.244     0.200
    87.125    -0.303     0.200
    87.141     1.025     0.200
    87.184    -0.689     0.200
    87.195    -0.446     0.200
    87.215     0.059     0.200
    87.204     1.416     0.200
    87.359    -1.796     0.200
    87.370     0.615     0.200
    87.404    -0.652     0.200
    87.428     0.532     0.200
    87.461     0.373     0.200
    87.498    -0.500     0.200
    87.483     1.163     0.200
    87.521     1.245     0.200
    87.525    -0.733     0.200
    87.509     1.345     0.200
    87.553    -0.569     0.200
    87.557    -0.886     0.200
    87.561     0.390     0.200
    87.564     0.682     0.200
    87.583    -0.910     0.200
    87.663     0.208     0.200
    87.664     0.799     0.200
    87.680    -0.277     0.200
    87.657     2.133     0.200
    87.696    -1.154     0.200
    87.733     0.634     0.200
    87.735     1.365     0.200
    87.819     1.467     0.200
    87.906     1.562     0.200
    87.906     0.468     0.200
    87.937    -0.196     0.200
    87.942     1.452     0.200
    87.963     0.268     0.200
    88.063    -1.293     0.200
    88.105     0.773     0.200
    88.114    -1.111     0.200
    88.148    -0.001     0.200
    88.153     2.977     0.200
    88.194     1.194     0.200
    88.227    -0.466     0.200
    88.257    -1.064     0.200
    88.279     0.257     0.200
    88.291    -0.771     0.200
    88.395     0.740     0.200
    88.427    -0.115     0.200
    88.431     2.663     0.200
    88.457     0.212     0.200
    88.461     1.523     0.200
    88.580    -0.937     0.200
    88.636    -0.469     0.200
    88.663     0.403     0.200
    88.717    -0.687     0.200
    88.833     1.267     0.200
    88.859    -0.949     0.200
    88.867     1.212     0.200
    88.880     1.648     0.200
    88.934     0.613     0.200
    88.936     1.595     0.200
    89.018    -0.000     0.200
    89.005     0.162     0.200
    89.073    -1.255     0.200
    89.093    -2.322     0.200
    89.091     0.581     0.200
    89.307    -1.051     0.200
    89.296    -0.131     0.200
    89.551     0.752     0.200
    89.590     1.823     0.200
    89.614    -0.130     0.200
    89.695    -0.865     0.200
    89.633     0.931     0.200
    89.736    -1.089     0.200
    89.804     0.025     0.200
    89.804    -0.296     0.200
    89.808    -1.095     0.200
    90.073    -0.730     0.200
    90.116    -0.536     0.200
    90.202    -2.333     0.200
    90.202    -0.966     0.200
    90.297    -1.479     0.200
    90.297    -0.971     0.200
    90.392     1.625     0.200
    90.392     0.492     0.200
    90.475     0.089     0.200
    90.489     1.157     0.200
    90.498     0.688     0.200
    90.687    -0.990     0.200
    90.732     0.551     0.200
    90.836     1.287     0.200
    90.836     0.225     0.200
    90.881    -0.454     0.200
    90.962    -1.041     0.200
    90.966    -2.089     0.200
    91.392     1.621     0.200
    91.501     0.944     0.200
    91.516     1.626     0.200
    91.713    -1.746     0.200
    92.081    -0.005     0.200
    92.082     1.342     0.200
    92.082     0.131     0.200
    92.156     2.998     0.200
    92.304     0.317     0.200
    92.304    -0.894     0.200
    92.311    -0.725     0.200
    92.317    -0.110     0.200
    92.317    -0.119     0.200
    92.445    -0.263     0.200
    92.460     0.571     0.200
    92.550     0.604     0.200
    92.745     0.608     0.200
    93.051    -0.122     0.200
    93.309    -1.576     0.200
    93.492    -0.460     0.200
    93.447     0.085     0.200
    93.572     0.476     0.200
    94.388    -1.421     0.200
    94.521     0.774     0.200
    94.523    -0.343     0.200
    94.679     0.569     0.200
    94.673     0.516     0.200
    94.770    -0.295     0.200
    94.831    -0.424     0.200
    94.982    -0.131     0.200
    95.164     0.521     0.200
    95.231    -0.139     0.200
    95.396    -0.045     0.200
    95.658     0.095     0.200
    95.680    -0.163     0.200
    95.682     0.157     0.200
    95.782     0.218     0.200
    95.974    -0.697     0.200
    97.112    -1.040     0.200
    16.803     1.790     0.200
    18.324    -1.637     0.200
    18.324    -2.487     0.200
    20.570     0.379     0.200
    24.245     0.252     0.200
    24.382     0.177     0.200
    24.382    -0.678     0.200
    24.752     0.534     0.200
    24.753     0.391     0.200
    24.753     0.660     0.200
    24.753     0.520     0.200
    25.471    -1.375     0.200
    25.471    -2.100     0.200
    27.065     1.875     0.200
    33.736    -2.130     0.200
    34.508     0.903     0.200
    34.546     1.722     0.200
    35.912    -2.614     0.200
    35.886     1.539     0.200
    36.116    -0.862     0.200
    36.334     2.480     0.200
    36.980     1.764     0.200
    37.858     0.739     0.200
    38.043     0.551     0.200
    38.122     2.086     0.200
    38.794     3.112     0.200
    40.942    -0.427     0.200
    41.558     1.365     0.200
    41.718     0.349     0.200
    43.827    -0.616     0.200
    45.328    -0.923     0.200
    45.331     1.006     0.200
    45.331     0.647     0.200
    46.507    -1.522     0.200
    46.531     0.790     0.200
    46.739     0.263     0.200
    46.739     0.102     0.200
    46.967    -0.122     0.200
    47.353    -0.971     0.200
    47.271     1.507     0.200
    47.270     0.614     0.200
    47.271     1.468     0.200
    47.605    -0.093     0.200
    50.644     0.639     0.200
    50.615    -0.705     0.200
    50.644    -0.407     0.200
    51.490     0.106     0.200
    54.778     0.067     0.200
    54.791     0.547     0.200
    56.002    -1.200     0.200
    57.187     1.666     0.200
    59.305    -0.099     0.200
    59.309    -0.127     0.200
    64.095    -0.905     0.200
    64.095    -0.933     0.200
    64.150    -0.966     0.200
    64.150     0.214     0.200
    64.233     0.493     0.200
    64.333    -0.063     0.200
    64.382    -0.486     0.200
    64.382    -0.267     0.200
    64.382    -0.261     0.200
    64.761     0.836     0.200
    64.845    -0.021     0.200
    64.847    -1.122     0.200
    64.867    -0.951     0.200
    65.317    -0.274     0.200
    66.063    -0.381     0.200
    66.063    -0.611     0.200
    66.063    -0.608     0.200
    66.063    -0.381     0.200
    66.078    -0.713     0.200
    66.171    -0.580     0.200
    66.308     0.841     0.200
    67.056    -2.027     0.200
    68.396     0.627     0.200
    70.052     0.676     0.200
    70.529    -0.043     0.200
    70.746     1.836     0.200
    71.137     0.062     0.200
    73.370     1.518     0.200
    73.522     0.329     0.200
    73.948     0.731     0.200
    74.188     0.028     0.200
    74.684    -0.683     0.200
    74.684    -0.552     0.200
    74.691    -1.698     0.200
    74.691    -0.708     0.200
    74.710    -1.254     0.200
    75.265     0.992     0.200
    76.388     1.381     0.200
    76.679     0.683     0.200
    76.687     0.478     0.200
    78.037     0.439     0.200
    78.897     1.264     0.200
    79.844     0.528     0.200
    80.030     0.997     0.200
    80.526    -0.448     0.200
    81.388     0.554     0.200
    81.388     0.554     0.200
    82.126     0.290     0.200
    83.736     1.276     0.200
    83.750     0.961     0.200
    85.195     0.837     0.200
    85.222     1.050     0.200
    85.222     1.052     0.200
    92.977    -0.017     0.200
    92.977    -0.016     0.200
    96.330     0.287     0.200
    18.324    -1.170     0.200
    24.379    -0.021     0.200
    24.761     0.750     0.200
    25.479    -1.370     0.200
    32.329     3.160     0.200
    33.743    -0.982     0.200
    33.743    -0.779     0.200
    34.539     2.163     0.200
    35.920    -1.918     0.200
    36.973     1.781     0.200
    37.158     1.301     0.200
    37.866     0.432     0.200
    40.950    -0.787     0.200
    43.835    -1.413     0.200
    45.338     0.639     0.200
    46.510    -1.132     0.200
    46.740     0.960     0.200
    47.263     1.553     0.200
    50.652     0.554     0.200
    50.652     0.554     0.200
    54.799     0.720     0.200
    56.006    -1.680     0.200
    57.195     0.922     0.200
    59.316    -0.522     0.200
    63.656     0.397     0.200
    64.100    -1.420     0.200
    64.158    -0.442     0.200
    64.241    -0.046     0.200
    64.386    -0.295     0.200
    64.386    -0.272     0.200
    64.770     1.300     0.200
    66.070    -0.517     0.200
    66.316     0.706     0.200
    72.530     0.004     0.200
    74.192     0.025     0.200
    74.689    -1.215     0.200
    74.696    -1.049     0.200
    75.269     1.089     0.200
    75.575     0.334     0.200
    76.247     1.301     0.200
    76.268     1.479     0.200
    76.392     1.078     0.200
    76.392     0.378     0.200
    76.516     0.774     0.200
    76.683    -0.017     0.200
    77.169     0.794     0.200
    77.185     0.205     0.200
    77.963     0.362     0.200
    78.338     1.276     0.200
    78.854     0.641     0.200
    79.051     0.712     0.200
    79.603     0.656     0.200
    80.045     0.258     0.200
    80.036     0.356     0.200
    80.258     0.007     0.200
    80.854    -2.584     0.200
    80.879    -0.122     0.200
    81.396     1.079     0.200
    82.133     1.298     0.200
    83.752     0.189     0.200
    85.228     0.400     0.200
    92.981    -0.586     0.200
    96.334    -0.142     0.200
    15.658     4.052     0.200
    23.194    -0.025     0.200
    25.468     0.919     0.200
    25.470     0.903     0.200
    25.704     3.096     0.200
    33.630     2.521     0.200
    46.496     1.606     0.200
    46.496     1.613     0.200
    51.390    -0.432     0.200
    55.111    -0.337     0.200
    55.111    -0.337     0.200
    55.277    -1.772     0.200
    55.277    -1.765     0.200
    59.277    -0.014     0.200
    59.280    -0.046     0.200
    63.383    -1.721     0.200
    63.383    -1.721     0.200
    63.545    -1.334     0.200
    63.545    -1.256     0.200
    64.092    -0.187     0.200
    64.201    -0.911     0.200
    64.574    -1.007     0.200
    64.659    -1.211     0.200
    66.100    -1.149     0.200
    66.100    -1.157     0.200
    67.710    -0.258     0.200
    70.214    -0.260     0.200
    74.018    -1.700     0.200
    75.846    -0.331     0.200
    79.354     0.516     0.200
    81.907     0.317     0.200
    81.989     0.309     0.200
    82.734     0.453     0.200
    84.633     0.139     0.200
    18.388    -1.668     0.200
    24.542    -0.135     0.200
    24.471     0.926     0.200
    24.471     0.141     0.200
    38.235     1.799     0.200
    38.262    -0.013     0.200
    38.262     0.815     0.200
    41.939     0.541     0.200
    46.782     0.495     0.200
    47.266    -1.431     0.200
    47.550     2.062     0.200
    47.550     1.253     0.200
    53.211     0.211     0.200
    53.560     0.288     0.200
    54.518    -0.234     0.200
    55.899    -2.431     0.200
    63.988    -2.031     0.200
    64.313    -1.383     0.200
    64.313    -1.457     0.200
    64.628    -1.055     0.200
    65.815    -1.461     0.200
    68.648    -0.997     0.200
    70.333    -1.347     0.200
    70.935    -1.065     0.200
    71.873     0.476     0.200
    73.967     1.351     0.200
    74.564    -1.777     0.200
    74.564    -1.023     0.200
    76.607    -0.614     0.200
    81.105    -0.082     0.200
    81.914     0.205     0.200
    83.747     0.089     0.200
    16.631     1.990     0.200
    18.429    -1.766     0.200
    19.163     0.300     0.200
    20.515     0.535     0.200
    20.515    -0.885     0.200
    21.933    -1.583     0.200
    23.738     2.861     0.200
    23.747     0.312     0.200
    24.116     1.210     0.200
    24.115     0.367     0.200
    24.324     0.999     0.200
    24.517     0.409     0.200
    24.486     0.196     0.200
    24.554     1.836     0.200
    24.624    -0.276     0.200
    24.624     0.648     0.200
    24.940     0.622     0.200
    25.193     1.310     0.200
    25.272     2.032     0.200
    25.287     1.492     0.200
    25.381    -1.061     0.200
    25.381    -0.887     0.200
    25.606     0.571     0.200
    25.994     0.943     0.200
    26.141     1.483     0.200
    26.140     1.094     0.200
    26.217     1.629     0.200
    26.395     0.599     0.200
    26.510     0.453     0.200
    26.577     2.314     0.200
    26.577     0.674     0.200
    26.577    -0.395     0.200
    26.586     0.882     0.200
    26.619     0.634     0.200
    26.786     2.533     0.200
    26.787     2.214     0.200
    26.793     0.156     0.200
    26.831     2.584     0.200
    26.909     0.885     0.200
    26.966     1.256     0.200
    27.133     0.882     0.200
    27.210     1.921     0.200
    27.210     1.126     0.200
    27.208     1.327     0.200
    27.467     1.751     0.200
    27.608     1.630     0.200
    27.665     1.980     0.200
    27.722     0.106     0.200
    27.748     2.845     0.200
    28.211     1.645     0.200
    28.251     1.968     0.200
    28.631     2.767     0.200
    28.740     2.022     0.200
    29.215     2.193     0.200
    29.397     2.360     0.200
    29.681     2.900     0.200
    29.797     0.632     0.200
    29.888     2.480     0.200
    30.320     1.898     0.200
    31.387     1.857     0.200
    31.581     0.721     0.200
    31.569     2.348     0.200
    31.856    -0.673     0.200
    32.468     3.191     0.200
    32.671     3.046     0.200
    32.780     0.419     0.200
    32.724     1.026     0.200
    33.118     1.495     0.200
    33.300     1.416     0.200
    33.454     1.280     0.200
    33.689    -1.307     0.200
    33.747     1.430     0.200
    33.866     2.145     0.200
    33.991     0.764     0.200
    33.995     2.284     0.200
    34.001     1.876     0.200
    34.072     1.026     0.200
    34.162     2.006     0.200
    34.323     0.838     0.200
    34.335     1.094     0.200
    34.385     1.952     0.200
    34.431     1.808     0.200
    34.514     0.796     0.200
    34.514     0.558     0.200
    34.529     1.937     0.200
    34.601     1.700     0.200
    34.688     0.608     0.200
    34.689     2.610     0.200
    34.723     1.104     0.200
    34.911     1.513     0.200
    35.159     0.467     0.200
    35.174     2.244     0.200
    35.398     1.186     0.200
    35.531     1.815     0.200
    35.550     1.616     0.200
    35.624     1.572     0.200
    35.698     1.959     0.200
    35.828    -1.977     0.200
    35.828    -1.506     0.200
    35.834     1.916     0.200
    35.894     2.674     0.200
    35.889    -2.000     0.200
    35.930     0.737     0.200
    35.984     0.081     0.200
    35.984     0.362     0.200
    36.021     1.986     0.200
    36.139     1.246     0.200
    36.473     2.506     0.200
    36.521     0.474     0.200
    36.551     1.098     0.200
    36.566     1.696     0.200
    36.936     1.499     0.200
    36.966     1.966     0.200
    36.969     2.352     0.200
    37.064     1.776     0.200
    37.064     0.524     0.200
    37.122     1.704     0.200
    37.148     1.280     0.200
    37.148     1.729     0.200
    37.290     0.494     0.200
    37.299     2.241     0.200
    37.455    -0.242     0.200
    37.495     0.919     0.200
    37.524     1.807     0.200
    37.830     1.657     0.200
    37.980    -1.342     0.200
    37.964     1.465     0.200
    37.964     0.539     0.200
    37.947     1.208     0.200
    38.189     0.860     0.200
    38.189     0.417     0.200
    38.294     1.779     0.200
    38.294     1.374     0.200
    38.460     1.753     0.200
    38.667     1.352     0.200
    38.867     0.809     0.200
    38.933     1.299     0.200
    39.266     0.094     0.200
    39.534     0.515     0.200
    39.683     2.250     0.200
    39.683     1.471     0.200
    39.782     0.316     0.200
    40.200     1.060     0.200
    40.241     1.236     0.200
    40.305     1.027     0.200
    40.588    -0.449     0.200
    40.712    -0.971     0.200
    40.823    -0.286     0.200
    41.123     0.842     0.200
    41.123     1.241     0.200
    41.123     1.562     0.200
    41.446    -0.213     0.200
    41.352     1.358     0.200
    41.549     0.392     0.200
    41.549     0.728     0.200
    41.696     1.848     0.200
    41.696     1.336     0.200
    41.864     0.148     0.200
    41.953     1.925     0.200
    42.046     1.239     0.200
    42.050     2.880     0.200
    42.050     1.405     0.200
    42.142     0.782     0.200
    42.164     1.856     0.200
    42.561    -0.318     0.200
    42.670     1.416     0.200
    42.776     0.423     0.200
    42.930     0.406     0.200
    43.699    -0.115     0.200
    43.699    -0.240     0.200
    44.547     0.852     0.200
    44.524     0.789     0.200
    44.640     0.256     0.200
    44.663     2.318     0.200
    44.663     1.934     0.200
    44.752    -1.943     0.200
    44.773     0.089     0.200
    45.198    -0.094     0.200
    45.191     1.065     0.200
    45.191     0.866     0.200
    45.190     1.075     0.200
    45.662     0.006     0.200
    45.687    -0.054     0.200
    46.295     0.942     0.200
    46.496     0.435     0.200
    46.570    -0.714     0.200
    46.572     0.772     0.200
    46.572     0.464     0.200
    46.822     0.512     0.200
    46.714     0.718     0.200
    47.205     0.092     0.200
    47.391     0.164     0.200
    47.307     0.526     0.200
    47.400    -0.656     0.200
    47.449    -0.132     0.200
    47.406     2.215     0.200
    47.534    -0.116     0.200
    47.582    -0.305     0.200
    47.656    -0.280     0.200
    47.762     0.393     0.200
    47.762     0.194     0.200
    47.752    -0.353     0.200
    47.782    -0.247     0.200
    47.903    -0.795     0.200
    47.934    -0.929     0.200
    47.962    -0.548     0.200
    48.033    -0.820     0.200
    48.117    -0.761     0.200
    48.311    -0.898     0.200
    48.314    -1.276     0.200
    48.340     0.063     0.200
    48.446    -0.445     0.200
    48.460    -0.259     0.200
    48.459    -0.163     0.200
    48.563    -0.651     0.200
    48.562    -1.007     0.200
    48.592    -0.364     0.200
    48.738    -0.342     0.200
    48.811    -0.690     0.200
    48.784     0.549     0.200
    48.855    -0.901     0.200
    48.869     0.412     0.200
    49.044     0.493     0.200
    49.036     0.605     0.200
    49.085    -0.794     0.200
    49.090    -0.188     0.200
    49.109    -0.060     0.200
    49.133    -0.027     0.200
    49.156    -0.305     0.200
    49.271    -0.146     0.200
    49.340    -0.604     0.200
    49.451     0.671     0.200
    49.510    -0.723     0.200
    49.536     0.138     0.200
    49.554    -0.461     0.200
    49.688    -0.516     0.200
    49.755    -0.422     0.200
    49.792    -0.115     0.200
    49.773    -0.201     0.200
    49.871    -0.274     0.200
    49.846     0.569     0.200
    49.940    -0.931     0.200
    49.922     0.200     0.200
    49.971    -0.743     0.200
    49.920    -0.465     0.200
    50.106     0.151     0.200
    50.148     0.197     0.200
    50.210    -0.220     0.200
    50.218    -0.271     0.200
    50.290    -0.191     0.200
    50.278    -1.124     0.200
    50.362    -0.359     0.200
    50.366    -0.158     0.200
    50.421    -0.571     0.200
    50.425    -0.060     0.200
    50.506    -0.147     0.200
    50.544    -0.027     0.200
    50.512     0.959     0.200
    50.613     0.146     0.200
    50.640     0.290     0.200
    50.668     0.134     0.200
    50.674    -0.846     0.200
    50.783    -0.911     0.200
    50.820    -0.298     0.200
    50.828    -0.153     0.200
    50.869    -0.469     0.200
    50.911    -0.517     0.200
    50.933    -1.141     0.200
    50.990    -0.592     0.200
    51.004    -0.556     0.200
    51.042    -0.173     0.200
    51.037    -0.075     0.200
    51.028     0.255     0.200
    51.189    -0.451     0.200
    51.209    -0.698     0.200
    51.256    -0.644     0.200
    51.254    -0.900     0.200
    51.286    -0.150     0.200
    51.368    -0.538     0.200
    51.454    -0.844     0.200
    51.454    -0.526     0.200
    51.481    -0.324     0.200
    51.499    -0.819     0.200
    51.504    -0.943     0.200
    51.599     0.282     0.200
    51.556     1.009     0.200
    51.627    -1.585     0.200
    51.651    -0.914     0.200
    51.636     0.210     0.200
    51.636     0.421     0.200
    51.687    -0.484     0.200
    51.717    -0.656     0.200
    51.771    -0.039     0.200
    51.814    -0.750     0.200
    51.819    -0.555     0.200
    51.881     0.101     0.200
    51.911    -0.277     0.200
    51.915    -0.302     0.200
    51.941    -0.375     0.200
    51.859     0.987     0.200
    51.995    -0.397     0.200
    51.980    -0.221     0.200
    52.025    -0.919     0.200
    52.108    -0.239     0.200
    52.132    -0.557     0.200
    52.142    -0.618     0.200
    52.138    -0.416     0.200
    52.170    -0.905     0.200
    52.210    -0.587     0.200
    52.228    -0.410     0.200
    52.218    -0.963     0.200
    52.254    -1.282     0.200
    52.289    -1.020     0.200
    52.389    -0.703     0.200
    52.455    -0.665     0.200
    52.444    -0.172     0.200
    52.464    -1.436     0.200
    52.462    -0.037     0.200
    52.469    -0.300     0.200
    52.490    -0.318     0.200
    52.513    -0.257     0.200
    52.533    -0.107     0.200
    52.641    -0.345     0.200
    52.645    -0.478     0.200
    52.684    -0.741     0.200
    52.729    -0.999     0.200
    52.707    -0.158     0.200
    52.754    -0.577     0.200
    52.777    -1.112     0.200
    52.783    -0.324     0.200
    52.880    -0.621     0.200
    52.904    -1.253     0.200
    52.905    -0.370     0.200
    52.903    -0.256     0.200
    52.958    -0.188     0.200
    52.975    -0.317     0.200
    52.972    -0.335     0.200
    52.993    -0.175     0.200
    53.012    -0.394     0.200
    53.071    -1.193     0.200
    53.144    -0.133     0.200
    53.133    -0.011     0.200
    53.273    -0.816     0.200
    53.262    -0.315     0.200
    53.250    -0.291     0.200
    53.249    -0.129     0.200
    53.268    -0.449     0.200
    53.280    -0.073     0.200
    53.280     0.088     0.200
    53.317    -0.833     0.200
    53.319    -0.588     0.200
    53.344    -0.876     0.200
    53.388    -1.011     0.200
    53.400    -1.380     0.200
    53.410    -0.872     0.200
    53.403    -0.415     0.200
    53.438    -0.614     0.200
    53.439    -0.669     0.200
    53.500     0.106     0.200
    53.518    -0.304     0.200
    53.544    -0.796     0.200
    53.563    -0.470     0.200
    53.596    -0.285     0.200
    53.618    -0.368     0.200
    53.633    -0.300     0.200
    53.627    -0.029     0.200
    53.690     0.248     0.200
    53.725     0.254     0.200
    53.749    -0.066     0.200
    53.734     0.069     0.200
    53.773    -0.922     0.200
    53.773     0.862     0.200
    53.823    -0.462     0.200
    53.820    -0.599     0.200
    53.837    -0.712     0.200
    53.848    -0.217     0.200
    53.889    -0.774     0.200
    53.904    -0.473     0.200
    53.932    -0.330     0.200
    53.939     0.061     0.200
    53.970    -0.260     0.200
    54.008    -0.682     0.200
    53.983     0.069     0.200
    54.014    -0.165     0.200
    54.032    -0.210     0.200
    54.043    -0.590     0.200
    54.081    -0.337     0.200
    54.081    -0.628     0.200
    54.101    -1.076     0.200
    54.077    -0.171     0.200
    54.073    -0.340     0.200
    54.112    -0.631     0.200
    54.119    -0.616     0.200
    54.135    -0.559     0.200
    54.135    -0.397     0.200
    54.202    -0.637     0.200
    54.265    -0.458     0.200
    54.248    -0.230     0.200
    54.248    -0.806     0.200
    54.293    -0.200     0.200
    54.353    -0.022     0.200
    54.357     0.052     0.200
    54.421    -0.353     0.200
    54.430    -0.169     0.200
    54.445    -0.032     0.200
    54.445     0.384     0.200
    54.450    -0.148     0.200
    54.454     0.119     0.200
    54.449    -0.289     0.200
    54.466     0.553     0.200
    54.503     0.807     0.200
    54.503    -0.539     0.200
    54.513    -0.122     0.200
    54.556     0.189     0.200
    54.573    -0.526     0.200
    54.605     0.042     0.200
    54.628     0.084     0.200
    54.628    -0.225     0.200
    54.598     0.042     0.200
    54.648     0.073     0.200
    54.648    -0.521     0.200
    54.699     0.023     0.200
    54.695    -0.714     0.200
    54.694     0.546     0.200
    54.752    -0.000     0.200
    54.759     0.011     0.200
    54.761    -0.131     0.200
    54.785     0.020     0.200
    54.785    -0.369     0.200
    54.762     0.480     0.200
    54.791     0.083     0.200
    54.815     0.206     0.200
    54.815     0.097     0.200
    54.851    -0.877     0.200
    54.851    -0.609     0.200
    54.814    -0.091     0.200
    54.860    -0.413     0.200
    54.898    -0.271     0.200
    54.934     0.055     0.200
    54.956    -0.335     0.200
    54.976     0.245     0.200
    55.022    -0.061     0.200
    55.022    -0.454     0.200
    55.040    -0.128     0.200
    55.050     0.070     0.200
    55.145    -0.617     0.200
    55.143    -0.003     0.200
    55.162    -0.524     0.200
    55.180    -0.760     0.200
    55.191     0.367     0.200
    55.227     0.471     0.200
    55.209    -0.105     0.200
    55.238    -0.884     0.200
    55.225     0.297     0.200
    55.281    -0.874     0.200
    55.281    -0.472     0.200
    55.276    -0.149     0.200
    55.325    -0.536     0.200
    55.324    -0.256     0.200
    55.347     0.111     0.200
    55.401    -0.406     0.200
    55.380     0.060     0.200
    55.398    -0.270     0.200
    55.411     0.797     0.200
    55.447    -0.694     0.200
    55.470    -0.105     0.200
    55.513    -0.324     0.200
    55.527    -0.141     0.200
    55.581     0.473     0.200
    55.581    -0.371     0.200
    55.577    -0.083     0.200
    55.595     0.352     0.200
    55.608    -0.153     0.200
    55.699     0.960     0.200
    55.859    -0.238     0.200
    55.873    -0.078     0.200
    55.930     0.070     0.200
    55.917    -0.136     0.200
    56.032    -1.080     0.200
    56.032    -1.091     0.200
    56.021    -0.590     0.200
    56.021    -0.729     0.200
    56.016    -0.531     0.200
    56.044    -0.829     0.200
    56.029    -0.589     0.200
    56.074    -0.569     0.200
    56.107    -0.754     0.200
    56.116    -1.340     0.200
    56.163    -1.671     0.200
    56.165     0.856     0.200
    56.194     0.083     0.200
    56.214    -0.137     0.200
    56.289    -0.068     0.200
    56.348    -0.202     0.200
    56.667    -1.819     0.200
    56.411    -0.885     0.200
    56.392    -0.589     0.200
    56.475     0.365     0.200
    56.556    -0.418     0.200
    56.563    -0.777     0.200
    56.601     0.290     0.200
    56.579     0.372     0.200
    56.649    -1.372     0.200
    56.678     0.077     0.200
    56.672    -0.330     0.200
    56.663    -0.518     0.200
    56.775     0.292     0.200
    56.799     0.236     0.200
    56.825    -0.472     0.200
    56.811     0.140     0.200
    56.910     0.122     0.200
    57.074     0.858     0.200
    57.250    -0.687     0.200
    57.228    -0.678     0.200
    57.296     0.171     0.200
    57.308     0.562     0.200
    57.328    -0.732     0.200
    57.391     0.501     0.200
    57.665    -0.393     0.200
    57.679    -1.393     0.200
    57.886     0.072     0.200
    58.611     0.550     0.200
    59.044     0.412     0.200
    59.248    -0.218     0.200
    59.410    -1.173     0.200
    59.530    -0.496     0.200
    60.664    -1.870     0.200
    60.973    -0.045     0.200
    62.261    -0.560     0.200
    63.052     0.069     0.200
    63.317     0.212     0.200
    63.529     0.207     0.200
    64.010    -0.058     0.200
    64.122    -0.312     0.200
    64.123    -0.600     0.200
    64.123    -0.773     0.200
    64.093     0.097     0.200
    64.093    -0.132     0.200
    64.131     0.245     0.200
    64.429    -0.508     0.200
    64.429    -0.495     0.200
    64.599     0.541     0.200
    64.609    -0.613     0.200
    64.627     0.123     0.200
    64.749    -0.695     0.200
    64.599     0.546     0.200
    64.651     0.844     0.200
    64.845    -0.624     0.200
    64.845    -0.514     0.200
    65.733     0.167     0.200
    65.749    -0.234     0.200
    65.994    -0.859     0.200
    65.995    -0.335     0.200
    66.104    -0.561     0.200
    66.229     0.538     0.200
    66.441     0.021     0.200
    66.528     0.062     0.200
    66.543    -0.021     0.200
    67.082    -1.708     0.200
    67.082    -1.507     0.200
    67.296     0.246     0.200
    67.520    -0.061     0.200
    67.555     0.068     0.200
    68.164     0.094     0.200
    68.751     0.275     0.200
    68.751     0.695     0.200
    68.709     1.059     0.200
    69.717    -0.885     0.200
    69.814     0.306     0.200
    69.997     0.000     0.200
    69.983    -0.120     0.200
    70.132    -0.634     0.200
    70.214    -1.139     0.200
    70.501     0.408     0.200
    70.502    -0.395     0.200
    70.622     0.570     0.200
    71.111     0.677     0.200
    71.105    -0.267     0.200
    71.105     0.483     0.200
    71.471     0.692     0.200
    71.524     0.211     0.200
    71.645    -0.824     0.200
    71.786     0.867     0.200
    71.809     0.919     0.200
    71.913     0.955     0.200
    72.009     0.137     0.200
    72.053     1.033     0.200
    72.277     1.283     0.200
    72.461     0.891     0.200
    72.461     1.170     0.200
    72.666     1.588     0.200
    72.701     1.168     0.200
    72.809     1.408     0.200
    72.894     0.196     0.200
    72.915     0.697     0.200
    72.925    -2.068     0.200
    73.096    -0.085     0.200
    73.193     1.734     0.200
    73.292    -0.021     0.200
    73.484    -1.370     0.200
    73.467     0.232     0.200
    73.467     0.732     0.200
    73.736     0.459     0.200
    73.831     0.256     0.200
    73.827     1.015     0.200
    74.235    -0.266     0.200
    74.235    -0.051     0.200
    74.274     0.076     0.200
    74.451     0.468     0.200
    74.613     0.848     0.200
    74.636     0.443     0.200
    74.709     0.142     0.200
    74.704    -0.582     0.200
    74.813     0.278     0.200
    74.827     0.295     0.200
    74.821     1.382     0.200
    75.040     0.362     0.200
    75.062     0.541     0.200
    75.098     0.734     0.200
    75.101     0.228     0.200
    75.145     0.474     0.200
    75.224     0.168     0.200
    75.281     0.675     0.200
    75.307     0.531     0.200
    75.400     1.240     0.200
    75.400     0.875     0.200
    75.479     0.242     0.200
    75.511     0.606     0.200
    75.592     0.696     0.200
    75.616     0.259     0.200
    75.509     2.429     0.200
    75.698    -0.014     0.200
    75.735     0.764     0.200
    75.755     0.646     0.200
    75.821    -0.115     0.200
    75.852     0.110     0.200
    75.904     0.294     0.200
    75.904     0.109     0.200
    76.040     0.536     0.200
    76.276     0.793     0.200
    76.281     0.868     0.200
    76.355     0.822     0.200
    76.355     0.146     0.200
    76.390     0.418     0.200
    76.434     0.596     0.200
    76.549     1.348     0.200
    76.597    -0.025     0.200
    76.725    -0.040     0.200
    76.725     0.331     0.200
    76.747     0.631     0.200
    76.825     1.291     0.200
    76.911     0.301     0.200
    76.927     0.614     0.200
    77.049    -0.070     0.200
    77.166     1.071     0.200
    77.203     0.564     0.200
    77.216     0.892     0.200
    77.280     0.360     0.200
    77.315    -0.399     0.200
    77.545     0.738     0.200
    77.500     0.767     0.200
    77.689     0.385     0.200
    77.717     0.705     0.200
    77.742     0.563     0.200
    77.782     1.329     0.200
    77.790     0.612     0.200
    77.924     0.648     0.200
    77.883     0.442     0.200
    77.985     0.398     0.200
    77.985     0.627     0.200
    78.065     0.856     0.200
    78.087     0.731     0.200
    78.125     0.599     0.200
    78.218     1.070     0.200
    78.385     0.807     0.200
    78.386     0.797     0.200
    78.419    -0.706     0.200
    78.473     0.975     0.200
    78.499    -0.283     0.200
    78.624     0.631     0.200
    78.706     0.213     0.200
    78.763     0.918     0.200
    78.836     0.279     0.200
    78.881     0.203     0.200
    78.935     0.636     0.200
    78.941     0.747     0.200
    78.986     0.727     0.200
    79.092     0.844     0.200
    79.340    -0.089     0.200
    79.422     0.577     0.200
    79.481     0.169     0.200
    79.480     1.062     0.200
    79.665     0.255     0.200
    79.684     0.538     0.200
    79.838     0.735     0.200
    79.838     1.075     0.200
    79.857    -0.168     0.200
    79.788     1.006     0.200
    79.917    -1.193     0.200
    80.023     1.025     0.200
    80.074     0.351     0.200
    80.076     1.377     0.200
    80.167     0.741     0.200
    80.251     0.772     0.200
    80.272    -0.011     0.200
    80.277     0.724     0.200
    80.200     1.178     0.200
    80.262     1.444     0.200
    80.420     0.093     0.200
    80.352     0.858     0.200
    80.473     0.453     0.200
    80.519     1.061     0.200
    80.560     0.245     0.200
    80.638     0.378     0.200
    80.586     0.902     0.200
    80.662    -0.406     0.200
    80.660     0.807     0.200
    80.773     0.389     0.200
    80.764    -1.950     0.200
    80.711     0.636     0.200
    80.709     0.744     0.200
    80.710     0.639     0.200
    80.787     1.127     0.200
    80.821     1.046     0.200
    80.828     1.206     0.200
    80.908     0.577     0.200
    80.993     0.176     0.200
    81.077    -0.234     0.200
    80.976     0.318     0.200
    81.241     1.908     0.200
    81.294     0.828     0.200
    81.266     0.777     0.200
    81.394     0.798     0.200
    81.555     1.945     0.200
    81.603     0.392     0.200
    81.599    -0.187     0.200
    81.801     1.646     0.200
    81.835     0.970     0.200
    82.057     1.805     0.200
    82.083    -0.631     0.200
    82.087     1.043     0.200
    82.230    -0.397     0.200
    82.231     0.590     0.200
    82.433     2.137     0.200
    82.435     2.623     0.200
    82.495     0.313     0.200
    82.544     1.193     0.200
    82.793     0.162     0.200
    82.812    -0.338     0.200
    82.985     1.268     0.200
    83.002     1.579     0.200
    83.168     1.919     0.200
    83.247    -0.486     0.200
    83.269    -0.152     0.200
    83.269     0.198     0.200
    83.399     1.130     0.200
    83.447     1.983     0.200
    83.512     0.345     0.200
    83.569     0.857     0.200
    83.719     1.267     0.200
    83.829     1.099     0.200
    83.883     1.050     0.200
    83.985     0.187     0.200
    84.351     1.038     0.200
    84.421     1.509     0.200
    84.585     0.772     0.200
    84.647     1.569     0.200
    85.012     0.552     0.200
    85.177     1.708     0.200
    85.177     1.171     0.200
    85.231     0.936     0.200
    85.231     0.835     0.200
    86.481     0.812     0.200
    87.360     1.237     0.200
    89.026     0.319     0.200
    89.506     1.210     0.200
    91.295     0.789     0.200
    91.493    -0.151     0.200
    92.134    -0.139     0.200
    92.629     0.195     0.200
    92.631     0.300     0.200
    92.952    -0.531     0.200
    92.837     0.203     0.200
    95.797     0.798     0.200
    96.191     0.527     0.200
    21.920    -1.508     0.200
    24.127     1.283     0.200
    24.502    -0.250     0.200
    24.636     1.531     0.200
    24.636     0.680     0.200
    24.636     1.260     0.200
    25.388    -1.681     0.200
    32.455     1.299     0.200
    33.691    -1.797     0.200
    47.384    -1.203     0.200
    47.393     0.779     0.200
    50.525     0.093     0.200
    54.702     0.296     0.200
    56.026    -1.643     0.200
    64.117    -1.915     0.200
    64.422    -0.287     0.200
    64.422    -1.412     0.200
    64.804    -0.170     0.200
    64.845    -1.032     0.200
    65.429    -0.824     0.200
    65.999    -0.668     0.200
    68.732     0.187     0.200
    70.502    -0.401     0.200
    71.106    -1.227     0.200
    71.106     0.070     0.200
    72.464     0.657     0.200
    73.470     0.085     0.200
    73.470     0.085     0.200
    74.699    -1.043     0.200
    76.717    -0.460     0.200
    80.021     0.089     0.200
    81.277     0.336     0.200
    82.088     0.983     0.200
    83.818     0.901     0.200
    85.228     0.411     0.200
    16.872     1.403     0.200
    21.582    -2.239     0.200
    24.327    -0.505     0.200
    24.928    -2.084     0.200
    32.742     2.634     0.200
    34.839     2.337     0.200
    38.151     0.060     0.200
    47.644     1.107     0.200
    54.261    -0.877     0.200
    54.261     0.672     0.200
    55.490    -2.129     0.200
    63.579    -2.032     0.200
    65.490    -1.677     0.200
    74.155    -1.517     0.200
    80.939    -0.350     0.200
    83.370     0.208     0.200
    84.676    -0.517     0.200
    16.756     2.294     0.200
    22.383    -1.539     0.200
    24.288     0.132     0.200
    24.288     0.109     0.200
    25.006     0.743     0.200
    47.777     1.949     0.200
    50.159     0.342     0.200
    50.159     0.017     0.200
    54.503    -0.080     0.200
    56.278    -2.245     0.200
    59.197    -0.897     0.200
    64.362    -1.639     0.200
    64.725    -0.840     0.200
    64.725    -0.789     0.200
    65.916    -1.102     0.200
    74.921    -1.373     0.200
    80.156     0.606     0.200
    80.964    -0.755     0.200
    84.208     0.702     0.200
    92.347    -0.803     0.200
    20.896    -0.068     0.200
    21.192    -0.498     0.200
    23.597    -0.647     0.200
    24.999     1.267     0.200
    25.502    -0.456     0.200
    25.502     0.064     0.200
    25.992    -1.016     0.200
    25.992    -1.242     0.200
    26.230     0.148     0.200
    30.402     1.914     0.200
    31.267     1.103     0.200
    31.586     2.481     0.200
    31.586     2.133     0.200
    33.721     1.877     0.200
    33.783     1.231     0.200
    36.398    -1.493     0.200
    44.563     0.226     0.200
    45.321    -1.193     0.200
    46.135    -0.727     0.200
    46.142     0.624     0.200
    46.142     0.721     0.200
    46.141     0.350     0.200
    46.492     2.051     0.200
    46.492     2.006     0.200
    46.493     1.939     0.200
    47.147    -0.449     0.200
    47.292     1.398     0.200
    48.055    -0.524     0.200
    48.410    -1.137     0.200
    48.644     1.564     0.200
    50.642     0.306     0.200
    51.408     0.646     0.200
    52.456    -0.014     0.200
    53.044    -0.396     0.200
    53.865     0.217     0.200
    55.014    -0.230     0.200
    55.346     0.213     0.200
    55.346     0.545     0.200
    55.822    -0.345     0.200
    57.836     2.270     0.200
    59.652    -1.207     0.200
    62.243    -1.248     0.200
    63.927    -1.098     0.200
    63.927    -0.391     0.200
    64.100    -0.258     0.200
    64.100    -1.160     0.200
    64.329    -0.161     0.200
    64.474    -0.114     0.200
    64.642    -0.484     0.200
    64.814     0.571     0.200
    64.983    -0.158     0.200
    64.983    -0.525     0.200
    65.128    -0.733     0.200
    65.084    -0.184     0.200
    66.449    -0.257     0.200
    66.449    -0.581     0.200
    66.555    -0.177     0.200
    66.896    -2.331     0.200
    69.638    -0.603     0.200
    70.676     0.189     0.200
    71.309     0.058     0.200
    72.319     0.769     0.200
    72.694     1.451     0.200
    72.872     1.641     0.200
    72.872     0.942     0.200
    73.105     1.443     0.200
    73.448    -0.960     0.200
    73.600     1.985     0.200
    73.831     0.419     0.200
    73.907    -0.452     0.200
    74.555    -0.480     0.200
    74.555    -0.218     0.200
    74.555    -1.121     0.200
    74.766     0.946     0.200
    75.013     0.818     0.200
    75.302     0.353     0.200
    75.578     0.675     0.200
    76.110     1.140     0.200
    76.110    -0.263     0.200
    76.401     0.608     0.200
    76.937     0.760     0.200
    77.775     0.704     0.200
    77.851     0.927     0.200
    77.864     0.769     0.200
    78.027     1.013     0.200
    78.143     1.439     0.200
    78.199     1.222     0.200
    78.630     1.299     0.200
    78.642    -0.843     0.200
    78.775     0.964     0.200
    79.868     0.673     0.200
    80.057     0.128     0.200
    82.090     0.834     0.200
    82.342     1.815     0.200
    83.284     0.499     0.200
    85.158     0.657     0.200
    93.795    -0.303     0.200
    97.140    -0.048     0.200
    21.405    -1.420     0.200
    21.405    -1.283     0.200
    23.983    -0.181     0.200
    24.908    -0.148     0.200
    24.908     0.527     0.200
    24.908    -1.027     0.200
    25.483     1.805     0.200
    26.802     1.978     0.200
    28.242     0.150     0.200
    30.666     0.544     0.200
    30.809     0.646     0.200
    30.995     2.380     0.200
    31.142     0.307     0.200
    31.156     0.530     0.200
    32.180     2.860     0.200
    32.329     1.025     0.200
    32.333     0.560     0.200
    32.684     1.391     0.200
    33.042     1.474     0.200
    33.073     1.953     0.200
    34.300     1.993     0.200
    36.638     0.677     0.200
    36.749     0.470     0.200
    37.035     0.979     0.200
    37.697     0.594     0.200
    37.697    -0.203     0.200
    37.907     1.428     0.200
    38.785     0.145     0.200
    41.097    -0.042     0.200
    41.374    -0.139     0.200
    45.525    -0.424     0.200
    45.556     0.381     0.200
    46.123    -1.322     0.200
    46.432    -0.529     0.200
    47.085     1.011     0.200
    47.085     1.337     0.200
    47.086     1.493     0.200
    47.086     1.333     0.200
    47.077     0.906     0.200
    47.242    -0.070     0.200
    48.065    -1.181     0.200
    48.658    -0.171     0.200
    50.528     0.874     0.200
    51.192    -0.039     0.200
    51.642    -0.908     0.200
    52.068     0.461     0.200
    54.863    -0.937     0.200
    55.069     0.206     0.200
    55.088     0.635     0.200
    57.258     3.292     0.200
    63.766    -0.255     0.200
    63.972     0.433     0.200
    64.020    -0.303     0.200
    64.642     0.179     0.200
    74.368    -0.057     0.200
    76.318     0.492     0.200
    80.908     1.245     0.200
    81.501     1.481     0.200
    83.348     0.779     0.200
    16.752     2.516     0.200
    18.281    -1.529     0.200
    20.580     0.585     0.200
    20.580    -0.146     0.200
    24.332    -0.192     0.200
    24.285     0.911     0.200
    24.285     0.540     0.200
    24.793     0.081     0.200
    24.793     0.357     0.200
    24.793    -0.319     0.200
    25.494    -2.209     0.200
    25.494    -1.285     0.200
    31.718     0.168     0.200
    32.297     2.463     0.200
    34.499     1.724     0.200
    37.992     0.983     0.200
    40.977    -0.913     0.200
    43.866    -0.827     0.200
    45.376     0.718     0.200
    45.376     0.534     0.200
    46.702    -0.019     0.200
    46.968    -0.500     0.200
    46.968    -0.202     0.200
    47.229     1.765     0.200
    50.685     0.174     0.200
    53.389     0.161     0.200
    54.480    -0.210     0.200
    54.816    -0.168     0.200
    55.982    -1.034     0.200
    59.320    -0.569     0.200
    61.710     0.486     0.200
    64.076    -0.344     0.200
    64.161     0.700     0.200
    64.270    -0.064     0.200
    64.356    -0.383     0.200
    64.356    -0.033     0.200
    64.793     0.269     0.200
    64.849    -0.839     0.200
    64.864    -1.030     0.200
    64.852    -0.219     0.200
    66.077    -0.339     0.200
    66.077    -0.564     0.200
    66.186    -0.536     0.200
    68.859     1.080     0.200
    70.528    -0.128     0.200
    70.834    -0.241     0.200
    72.535     0.501     0.200
    73.531    -0.389     0.200
    73.531    -0.180     0.200
    74.162    -0.885     0.200
    74.667    -0.666     0.200
    74.667    -0.817     0.200
    76.735     0.660     0.200
    77.143     1.063     0.200
    80.022    -0.122     0.200
    81.424     0.801     0.200
    82.130     0.568     0.200
    83.715     0.850     0.200
    83.715     1.327     0.200
    93.028     0.162     0.200
    18.831    -0.902     0.200
    22.342    -1.858     0.200
    24.320     1.001     0.200
    24.320     0.298     0.200
    24.320     0.696     0.200
    24.960     0.933     0.200
    25.239    -1.789     0.200
    26.381    -0.869     0.200
    26.381    -0.315     0.200
    33.692    -1.985     0.200
    33.692    -2.258     0.200
    40.564    -1.616     0.200
    44.829     0.587     0.200
    44.829     0.458     0.200
    47.741     2.214     0.200
    50.193     0.857     0.200
    54.183     0.885     0.200
    54.523     0.773     0.200
    55.991    -1.571     0.200
    56.257    -1.918     0.200
    56.840     3.578     0.200
    59.204    -0.946     0.200
    59.222     0.382     0.200
    63.932    -2.719     0.200
    63.942    -0.185     0.200
    64.340    -1.163     0.200
    64.341    -1.404     0.200
    64.341    -1.599     0.200
    64.443    -0.555     0.200
    64.699    -0.840     0.200
    64.699    -0.590     0.200
    64.732    -1.255     0.200
    64.819    -0.528     0.200
    64.819    -0.332     0.200
    64.924    -1.510     0.200
    64.924    -1.252     0.200
    65.925    -0.488     0.200
    65.925    -0.886     0.200
    65.925    -0.785     0.200
    66.036    -0.701     0.200
    69.888    -0.725     0.200
    71.154    -0.330     0.200
    71.995     0.773     0.200
    72.411     0.383     0.200
    73.440     0.184     0.200
    74.503    -0.536     0.200
    74.903    -1.274     0.200
    74.903    -1.149     0.200
    74.903    -0.649     0.200
    74.903    -1.344     0.200
    76.268    -0.073     0.200
    76.992    -0.674     0.200
    76.992     0.333     0.200
    79.202     0.262     0.200
    79.356     0.377     0.200
    80.145    -0.032     0.200
    80.145     0.546     0.200
    80.994     0.588     0.200
    80.994    -0.209     0.200
    84.173     0.169     0.200
    84.173     1.271     0.200
    95.747     1.141     0.200
    14.326     5.830     0.200
    17.426     2.201     0.200
    18.874    -1.289     0.200
    24.303    -0.245     0.200
    25.002     0.912     0.200
    32.801     2.690     0.200
    47.763     1.672     0.200
    50.174     0.257     0.200
    54.520     0.241     0.200
    56.289    -2.153     0.200
    59.214    -1.033     0.200
    64.373    -1.657     0.200
    64.735    -0.971     0.200
    64.735    -0.846     0.200
    74.933    -1.622     0.200
    77.027    -0.262     0.200
    80.170    -0.457     0.200
    80.980     0.075     0.200
    84.214     0.027     0.200
    85.427     0.103     0.200
    25.091    -0.363     0.200
    74.570    -0.603     0.200
    16.573     1.389     0.200
    17.682     1.034     0.200
    20.147     0.038     0.200
    22.541    -1.161     0.200
    23.001     1.412     0.200
    23.962     1.353     0.200
    24.014     2.138     0.200
    24.162     0.705     0.200
    24.162     1.424     0.200
    24.441     0.577     0.200
    24.441    -0.415     0.200
    24.948     0.462     0.200
    24.948    -0.288     0.200
    24.948    -0.218     0.200
    24.948    -0.843     0.200
    25.269     0.479     0.200
    25.304     1.069     0.200
    25.597    -1.198     0.200
    25.515     2.068     0.200
    25.651     1.499     0.200
    25.804     1.702     0.200
    25.808     1.073     0.200
    25.872     2.528     0.200
    26.045     0.865     0.200
    26.151     2.279     0.200
    26.255     0.948     0.200
    26.279     1.113     0.200
    26.410     1.376     0.200
    26.424     1.145     0.200
    26.428     1.993     0.200
    26.476     0.514     0.200
    26.564     1.586     0.200
    26.648     1.297     0.200
    26.638     1.108     0.200
    26.831     0.454     0.200
    26.811     0.996     0.200
    26.795     0.723     0.200
    26.841     2.568     0.200
    26.841     1.443     0.200
    27.123     0.136     0.200
    27.165     1.684     0.200
    27.267     1.907     0.200
    27.333     1.866     0.200
    27.378     1.874     0.200
    27.420     2.923     0.200
    27.774     2.752     0.200
    27.879     2.057     0.200
    27.995     2.105     0.200
    28.299     0.581     0.200
    28.284     2.813     0.200
    28.420     1.177     0.200
    28.675     2.561     0.200
    28.746     1.871     0.200
    28.806     2.350     0.200
    28.891     0.721     0.200
    29.288     2.082     0.200
    29.429     0.107     0.200
    29.429    -0.292     0.200
    29.567     0.417     0.200
    29.993     1.931     0.200
    30.299     1.613     0.200
    30.569     1.916     0.200
    30.750    -0.392     0.200
    30.783     1.921     0.200
    30.845     0.107     0.200
    30.954     2.759     0.200
    31.027     2.402     0.200
    31.027     0.402     0.200
    31.164     1.407     0.200
    31.183     1.378     0.200
    31.228     1.651     0.200
    31.251     2.235     0.200
    31.395     1.874     0.200
    31.447     0.606     0.200
    31.447    -0.058     0.200
    31.592     0.267     0.200
    31.826     2.275     0.200
    31.879     1.781     0.200
    32.003     1.760     0.200
    32.134     2.311     0.200
    32.140     2.992     0.200
    32.140     2.054     0.200
    32.152     3.016     0.200
    32.185     1.356     0.200
    32.222     2.461     0.200
    32.325     2.396     0.200
    32.363     2.304     0.200
    32.367     1.210     0.200
    32.505     2.852     0.200
    32.603     1.980     0.200
    32.752     1.902     0.200
    32.752     1.152     0.200
    32.866     2.735     0.200
    32.997     2.011     0.200
    33.076     2.072     0.200
    33.085     1.871     0.200
    33.085     1.020     0.200
    33.080     1.688     0.200
    33.203     2.947     0.200
    33.211     1.974     0.200
    33.352     2.341     0.200
    33.433     2.377     0.200
    33.480     2.480     0.200
    33.569     2.162     0.200
    33.696     0.407     0.200
    33.791    -1.303     0.200
    33.791    -1.482     0.200
    33.677     1.325     0.200
    33.675     0.701     0.200
    33.736     1.877     0.200
    33.736     1.424     0.200
    34.021     1.698     0.200
    34.082     1.468     0.200
    34.082     1.718     0.200
    34.302     1.163     0.200
    34.293     0.100     0.200
    34.374    -0.363     0.200
    34.325     1.405     0.200
    34.325     0.342     0.200
    34.325     0.981     0.200
    34.325     1.958     0.200
    34.325     1.262     0.200
    34.337     2.173     0.200
    34.370     1.072     0.200
    34.602     1.210     0.200
    34.597     1.990     0.200
    34.594     1.804     0.200
    34.647     1.672     0.200
    34.666     1.374     0.200
    34.694     1.760     0.200
    34.861     1.794     0.200
    35.074     1.995     0.200
    35.212     2.204     0.200
    35.314     2.425     0.200
    35.353     2.094     0.200
    35.543     0.765     0.200
    35.555     2.415     0.200
    35.559     2.099     0.200
    35.574     1.796     0.200
    35.603     2.615     0.200
    35.607     1.681     0.200
    35.681     1.324     0.200
    35.710     1.734     0.200
    35.755     2.191     0.200
    35.820     2.316     0.200
    35.878     2.482     0.200
    36.029    -1.341     0.200
    36.029    -2.310     0.200
    36.029    -1.966     0.200
    35.938     1.212     0.200
    35.999     2.284     0.200
    36.122     1.896     0.200
    36.315     0.650     0.200
    36.315     0.517     0.200
    36.236     2.418     0.200
    36.359     1.937     0.200
    36.619     1.622     0.200
    36.653     2.772     0.200
    36.653     1.952     0.200
    36.653     1.655     0.200
    36.660     1.532     0.200
    36.692     0.837     0.200
    36.692     0.478     0.200
    36.763     1.588     0.200
    36.763     1.033     0.200
    36.840     2.299     0.200
    36.952     2.556     0.200
    36.978     1.572     0.200
    37.178     1.359     0.200
    37.213     1.811     0.200
    37.236     2.571     0.200
    37.386     2.184     0.200
    37.439     1.635     0.200
    37.433     0.753     0.200
    37.474     1.587     0.200
    37.485     0.809     0.200
    37.512     1.485     0.200
    37.517     1.661     0.200
    37.519     2.852     0.200
    37.540     1.382     0.200
    37.539     1.224     0.200
    37.551     1.628     0.200
    37.585     1.497     0.200
    37.589     1.081     0.200
    37.600     1.367     0.200
    37.622     1.361     0.200
    37.637     1.635     0.200
    37.650     1.499     0.200
    37.658     1.205     0.200
    37.753    -0.163     0.200
    37.667     1.360     0.200
    37.763     0.408     0.200
    37.812     0.785     0.200
    37.812     1.340     0.200
    37.819     1.352     0.200
    37.909     1.089     0.200
    38.063     0.237     0.200
    38.064     0.755     0.200
    38.064     0.209     0.200
    37.976     1.378     0.200
    38.130     1.446     0.200
    38.122     2.148     0.200
    38.122     2.476     0.200
    38.340     1.104     0.200
    38.583     1.514     0.200
    38.583     1.795     0.200
    38.779     0.451     0.200
    38.888     0.002     0.200
    38.888     0.369     0.200
    39.044     1.383     0.200
    39.044     1.156     0.200
    39.179     1.257     0.200
    39.329     1.555     0.200
    39.343     1.430     0.200
    39.343     1.625     0.200
    39.406     0.316     0.200
    39.643     0.671     0.200
    39.921     2.227     0.200
    39.921     2.329     0.200
    39.948     1.871     0.200
    40.028     0.036     0.200
    40.758     0.847     0.200
    40.795     2.240     0.200
    40.795     1.740     0.200
    40.951    -0.539     0.200
    40.971    -0.906     0.200
    40.995     1.310     0.200
    40.995     2.021     0.200
    41.118    -0.172     0.200
    41.118    -1.117     0.200
    41.173     0.118     0.200
    41.173     0.008     0.200
    41.347     1.395     0.200
    41.347     1.082     0.200
    41.487     0.113     0.200
    41.487     0.473     0.200
    41.609     2.370     0.200
    41.819     1.364     0.200
    42.404    -0.343     0.200
    42.420    -0.341     0.200
    42.333     2.554     0.200
    42.333     2.734     0.200
    42.341     1.629     0.200
    42.562     0.577     0.200
    42.814     0.629     0.200
    43.140     0.053     0.200
    43.194     1.142     0.200
    43.419     0.937     0.200
    43.816     0.432     0.200
    44.018    -1.674     0.200
    44.018    -0.626     0.200
    44.018    -1.080     0.200
    44.321     2.244     0.200
    44.321     1.955     0.200
    44.488     0.152     0.200
    44.615     0.072     0.200
    44.646    -0.145     0.200
    44.759    -0.100     0.200
    44.953    -1.549     0.200
    45.084    -0.686     0.200
    45.284    -0.254     0.200
    45.521     0.646     0.200
    45.546     0.448     0.200
    45.546     0.651     0.200
    45.546     0.413     0.200
    45.546     1.138     0.200
    45.590    -1.069     0.200
    45.933     0.692     0.200
    45.933     0.879     0.200
    46.389    -0.493     0.200
    46.447     0.452     0.200
    46.447     0.272     0.200
    46.501    -0.256     0.200
    46.591     0.825     0.200
    46.591     0.224     0.200
    46.696     0.049     0.200
    46.998    -0.357     0.200
    46.998    -0.662     0.200
    46.951     0.368     0.200
    46.951     0.197     0.200
    47.070    -0.016     0.200
    47.065     1.716     0.200
    47.066     1.441     0.200
    47.066     2.085     0.200
    47.066     1.304     0.200
    47.274    -0.009     0.200
    47.218    -0.783     0.200
    47.279    -0.178     0.200
    47.375    -0.577     0.200
    47.647    -0.603     0.200
    47.760     1.768     0.200
    47.886    -0.763     0.200
    47.824     1.009     0.200
    47.864    -0.417     0.200
    48.051     0.710     0.200
    48.001    -0.763     0.200
    48.013     0.826     0.200
    48.113    -0.582     0.200
    48.142    -0.143     0.200
    48.221    -0.575     0.200
    48.330    -0.718     0.200
    48.432     0.520     0.200
    48.432     0.856     0.200
    48.482    -1.172     0.200
    48.500     0.113     0.200
    48.500    -0.223     0.200
    48.653    -0.825     0.200
    48.677     0.752     0.200
    48.731    -0.053     0.200
    48.731    -0.209     0.200
    48.762    -1.729     0.200
    48.912     0.458     0.200
    48.968    -1.158     0.200
    49.082    -0.470     0.200
    49.158    -1.054     0.200
    49.289     0.404     0.200
    49.318    -1.600     0.200
    49.351    -1.210     0.200
    49.358    -0.870     0.200
    49.399    -0.754     0.200
    49.402     0.018     0.200
    49.525    -0.208     0.200
    49.878     0.150     0.200
    49.988    -0.503     0.200
    50.067    -0.138     0.200
    50.296    -1.014     0.200
    50.280     0.020     0.200
    50.642    -0.896     0.200
    50.812     1.009     0.200
    50.844     0.848     0.200
    50.844     0.152     0.200
    50.992     0.199     0.200
    51.105    -0.475     0.200
    51.120     2.684     0.200
    51.261     0.024     0.200
    51.261     0.149     0.200
    51.389     0.162     0.200
    51.564    -1.056     0.200
    51.708    -0.268     0.200
    51.731    -0.451     0.200
    51.760    -0.063     0.200
    51.890     0.618     0.200
    51.840    -0.231     0.200
    51.911    -0.797     0.200
    51.936    -0.088     0.200
    52.011     0.199     0.200
    52.011    -0.270     0.200
    52.020    -0.150     0.200
    52.066    -0.804     0.200
    52.091    -1.669     0.200
    52.112    -0.116     0.200
    52.142     0.281     0.200
    52.208     0.694     0.200
    52.156     0.417     0.200
    52.267    -0.947     0.200
    52.330     0.401     0.200
    52.513    -0.240     0.200
    52.581    -0.132     0.200
    52.597    -0.787     0.200
    52.623    -0.904     0.200
    52.623    -1.146     0.200
    52.717    -0.052     0.200
    52.817    -2.558     0.200
    52.767    -0.017     0.200
    52.759     0.530     0.200
    52.907    -0.502     0.200
    52.989    -1.323     0.200
    53.065    -0.316     0.200
    53.126    -0.194     0.200
    53.258    -0.765     0.200
    53.342    -0.922     0.200
    53.358    -0.535     0.200
    53.396    -0.233     0.200
    53.463    -0.335     0.200
    53.471    -0.273     0.200
    53.526    -1.223     0.200
    53.526    -1.036     0.200
    53.563    -0.031     0.200
    53.563    -0.336     0.200
    53.637    -0.369     0.200
    53.628    -0.272     0.200
    53.662    -0.516     0.200
    53.716    -0.977     0.200
    53.767    -0.433     0.200
    53.902    -0.428     0.200
    53.955     0.622     0.200
    54.070    -0.035     0.200
    54.088     0.010     0.200
    54.126    -0.008     0.200
    54.221    -0.137     0.200
    54.256    -1.440     0.200
    54.279    -0.248     0.200
    54.382    -0.523     0.200
    54.415    -0.510     0.200
    54.414     0.491     0.200
    54.447    -0.076     0.200
    54.437    -0.429     0.200
    54.593     0.044     0.200
    54.593    -0.269     0.200
    54.555    -0.408     0.200
    54.579    -1.109     0.200
    54.666     0.706     0.200
    54.655    -1.226     0.200
    54.855     0.167     0.200
    54.870    -0.808     0.200
    54.928     0.413     0.200
    54.928     0.116     0.200
    54.858    -0.283     0.200
    54.916    -0.817     0.200
    55.032    -0.577     0.200
    55.018    -0.286     0.200
    55.077    -0.235     0.200
    55.072     0.156     0.200
    55.128    -0.542     0.200
    55.181    -0.125     0.200
    55.208     0.073     0.200
    55.220     0.232     0.200
    55.492     0.743     0.200
    55.512    -0.092     0.200
    55.652    -0.021     0.200
    55.652    -0.475     0.200
    55.704    -0.779     0.200
    55.733     0.047     0.200
    55.886     0.290     0.200
    55.832    -0.877     0.200
    55.935    -0.412     0.200
    55.935    -0.857     0.200
    55.935    -1.537     0.200
    55.881    -0.240     0.200
    55.969     0.521     0.200
    55.995    -0.338     0.200
    56.205     0.368     0.200
    56.499    -0.034     0.200
    56.656    -0.565     0.200
    57.181     0.310     0.200
    57.181    -0.651     0.200
    57.352     1.202     0.200
    57.541    -0.869     0.200
    57.583    -2.928     0.200
    57.744    -0.157     0.200
    58.009     0.086     0.200
    58.091     0.023     0.200
    58.912     0.183     0.200
    59.186     1.582     0.200
    59.156     0.945     0.200
    59.283    -0.929     0.200
    59.386    -0.712     0.200
    59.386    -0.267     0.200
    59.386    -0.853     0.200
    59.855    -0.328     0.200
    60.837    -0.120     0.200
    61.789     0.626     0.200
    62.331    -0.013     0.200
    62.548     0.231     0.200
    62.752    -0.323     0.200
    63.170    -0.405     0.200
    63.514     0.721     0.200
    63.721    -1.742     0.200
    63.822     0.384     0.200
    64.031    -0.862     0.200
    64.032    -0.493     0.200
    64.032    -0.392     0.200
    64.032    -0.860     0.200
    64.030    -0.049     0.200
    64.052    -0.021     0.200
    63.987    -0.391     0.200
    64.111    -0.452     0.200
    64.240    -1.212     0.200
    64.283    -0.585     0.200
    64.289    -0.779     0.200
    64.289    -0.428     0.200
    64.331    -1.056     0.200
    64.378     0.238     0.200
    64.476     0.369     0.200
    64.604    -0.842     0.200
    64.609    -0.732     0.200
    64.609    -0.240     0.200
    64.609    -0.568     0.200
    64.881    -0.646     0.200
    64.881    -0.794     0.200
    64.894    -0.132     0.200
    64.894    -0.742     0.200
    64.922     0.790     0.200
    64.947    -0.122     0.200
    65.305    -0.147     0.200
    65.363     0.537     0.200
    65.386    -0.510     0.200
    65.585     0.091     0.200
    65.585    -0.440     0.200
    65.585     0.607     0.200
    65.685    -0.034     0.200
    66.152    -0.953     0.200
    66.152    -0.508     0.200
    66.152    -0.907     0.200
    66.260    -0.647     0.200
    66.417     0.246     0.200
    66.407    -0.364     0.200
    66.823    -0.290     0.200
    66.995     0.232     0.200
    67.934    -0.150     0.200
    68.459    -0.867     0.200
    68.546     0.288     0.200
    68.738     0.389     0.200
    68.995     0.993     0.200
    69.670    -1.682     0.200
    70.036     0.462     0.200
    70.036     0.008     0.200
    70.127     0.379     0.200
    70.551    -0.582     0.200
    70.553    -0.592     0.200
    70.835    -0.612     0.200
    70.912    -1.276     0.200
    70.929     1.220     0.200
    70.976     0.031     0.200
    71.166    -0.623     0.200
    71.166    -0.170     0.200
    71.166     0.236     0.200
    71.322     0.910     0.200
    71.891    -1.585     0.200
    71.953     1.260     0.200
    72.052     0.935     0.200
    72.194     0.888     0.200
    72.220     1.397     0.200
    72.280     0.563     0.200
    72.280     0.782     0.200
    72.402     0.951     0.200
    72.420     1.336     0.200
    72.602     1.240     0.200
    72.602     0.670     0.200
    72.744     0.606     0.200
    72.755     0.977     0.200
    72.839     1.212     0.200
    72.905    -0.934     0.200
    72.952     2.046     0.200
    72.960     0.942     0.200
    72.978     0.146     0.200
    73.143     0.670     0.200
    73.224    -1.016     0.200
    73.332     1.631     0.200
    73.411     1.081     0.200
    73.454    -0.974     0.200
    73.574     0.515     0.200
    73.589    -0.077     0.200
    73.589     0.025     0.200
    73.679     1.054     0.200
    73.905     0.714     0.200
    74.095     0.065     0.200
    74.095    -0.083     0.200
    74.095     0.323     0.200
    74.129     0.727     0.200
    74.283     0.001     0.200
    74.317     0.777     0.200
    74.404     0.441     0.200
    74.449     0.807     0.200
    74.498     0.860     0.200
    74.536     0.289     0.200
    74.572     0.592     0.200
    74.572     0.459     0.200
    74.572     0.865     0.200
    74.631    -0.501     0.200
    74.631    -1.251     0.200
    74.631    -0.555     0.200
    74.631    -0.907     0.200
    74.643     0.480     0.200
    74.648     0.450     0.200
    74.681     0.756     0.200
    74.686     0.479     0.200
    74.686     0.627     0.200
    74.872     0.648     0.200
    74.881     0.616     0.200
    74.917     0.689     0.200
    74.943     0.947     0.200
    74.958     0.687     0.200
    74.970     0.585     0.200
    75.002     0.869     0.200
    75.014     0.836     0.200
    75.081     0.948     0.200
    75.139     1.012     0.200
    75.180     0.777     0.200
    75.232     1.234     0.200
    75.232     0.781     0.200
    75.330     0.012     0.200
    75.338     0.879     0.200
    75.367     0.272     0.200
    75.367     0.006     0.200
    75.366     0.633     0.200
    75.467     0.627     0.200
    75.481     0.747     0.200
    75.591     0.706     0.200
    75.607     1.010     0.200
    75.608     0.317     0.200
    75.642     1.225     0.200
    75.726     0.242     0.200
    75.732     0.606     0.200
    75.782     0.524     0.200
    75.782    -0.375     0.200
    75.772     0.683     0.200
    75.940     0.679     0.200
    75.940     0.226     0.200
    76.170     1.524     0.200
    76.170     1.712     0.200
    76.184     0.135     0.200
    76.229     1.174     0.200
    76.229     0.877     0.200
    76.229     0.674     0.200
    76.248     0.567     0.200
    76.248     0.864     0.200
    76.296     0.999     0.200
    76.346     0.833     0.200
    76.382     0.662     0.200
    76.405     1.880     0.200
    76.405     1.583     0.200
    76.435     1.609     0.200
    76.470     0.714     0.200
    76.470     0.214     0.200
    76.523     0.789     0.200
    76.578     0.402     0.200
    76.587     0.194     0.200
    76.587     0.764     0.200
    76.587     0.772     0.200
    76.587    -0.048     0.200
    76.639     0.056     0.200
    76.645     1.125     0.200
    76.684     0.804     0.200
    76.703     1.592     0.200
    76.751     0.026     0.200
    76.751     0.666     0.200
    76.762     0.067     0.200
    76.893     0.223     0.200
    76.947    -1.181     0.200
    77.044     1.377     0.200
    77.086     0.833     0.200
    77.106     1.025     0.200
    77.131     0.892     0.200
    77.181     0.506     0.200
    77.240    -0.201     0.200
    77.326     0.394     0.200
    77.354     1.432     0.200
    77.357     0.316     0.200
    77.374     2.127     0.200
    77.535     0.813     0.200
    77.588     0.916     0.200
    77.647     0.802     0.200
    77.670     0.361     0.200
    77.670     0.767     0.200
    77.773     0.670     0.200
    77.853     1.350     0.200
    77.868     0.213     0.200
    77.885     1.075     0.200
    77.897    -0.078     0.200
    77.938     0.709     0.200
    77.977     0.756     0.200
    78.052     1.158     0.200
    78.068     1.046     0.200
    78.210     0.886     0.200
    78.220     0.415     0.200
    78.235     1.100     0.200
    78.248     0.763     0.200
    78.254     1.121     0.200
    78.291     1.331     0.200
    78.333     1.401     0.200
    78.333     1.588     0.200
    78.390     1.204     0.200
    78.426    -0.138     0.200
    78.452     1.010     0.200
    78.539     0.817     0.200
    78.619     0.675     0.200
    78.701     0.262     0.200
    78.759    -0.269     0.200
    78.795     0.596     0.200
    78.808     0.872     0.200
    78.732     0.632     0.200
    78.834     0.077     0.200
    78.843     0.125     0.200
    78.843     1.679     0.200
    78.853     0.935     0.200
    78.852     1.232     0.200
    78.852     0.834     0.200
    78.957     0.858     0.200
    78.978     0.358     0.200
    78.995     0.148     0.200
    79.042     0.611     0.200
    79.079     0.711     0.200
    79.264    -0.231     0.200
    79.318     0.460     0.200
    79.364     0.281     0.200
    79.364     0.179     0.200
    79.396     1.458     0.200
    79.440     0.412     0.200
    79.451    -0.444     0.200
    79.482     0.339     0.200
    79.537     1.230     0.200
    79.603     0.410     0.200
    79.627     1.081     0.200
    79.833     0.318     0.200
    79.833     0.982     0.200
    79.833    -0.393     0.200
    79.850     1.787     0.200
    79.951     0.631     0.200
    79.969     0.509     0.200
    79.969     0.743     0.200
    80.020     0.917     0.200
    80.028     0.924     0.200
    80.078     1.078     0.200
    80.078     0.851     0.200
    80.016     1.492     0.200
    80.131     1.370     0.200
    80.161     1.272     0.200
    80.178     0.678     0.200
    80.181     1.497     0.200
    80.432     0.946     0.200
    80.519     1.121     0.200
    80.593     0.487     0.200
    80.696     1.303     0.200
    80.747     1.561     0.200
    80.767    -0.349     0.200
    80.804     0.423     0.200
    80.816     0.692     0.200
    80.897     0.658     0.200
    80.938     0.443     0.200
    80.940     0.725     0.200
    80.941     0.627     0.200
    80.949     0.778     0.200
    80.854    -0.782     0.200
    80.988     0.672     0.200
    81.013     1.242     0.200
    81.051     1.239     0.200
    81.051     0.940     0.200
    81.050     1.046     0.200
    81.057    -0.092     0.200
    81.212     2.084     0.200
    81.278    -0.072     0.200
    81.323     0.494     0.200
    81.492     0.251     0.200
    81.569     0.850     0.200
    81.569     0.193     0.200
    81.571     0.876     0.200
    81.617     0.541     0.200
    81.618     0.437     0.200
    81.740    -0.709     0.200
    81.751     0.528     0.200
    81.823     1.153     0.200
    81.950     0.234     0.200
    82.092     0.806     0.200
    82.168     1.363     0.200
    82.168     0.839     0.200
    82.168     1.097     0.200
    82.200     1.876     0.200
    82.175    -0.105     0.200
    82.258    -0.231     0.200
    82.227    -1.432     0.200
    82.548     0.660     0.200
    82.554     0.948     0.200
    82.551    -1.120     0.200
    82.719     1.564     0.200
    82.751     1.399     0.200
    82.768     0.211     0.200
    82.828     0.258     0.200
    82.970     0.371     0.200
    82.970    -0.238     0.200
    83.048     0.659     0.200
    83.179     1.886     0.200
    83.165     1.255     0.200
    83.173    -0.146     0.200
    83.173     1.143     0.200
    83.417     1.159     0.200
    83.415     1.367     0.200
    83.582     2.506     0.200
    83.614     1.171     0.200
    83.608     0.156     0.200
    83.609     1.268     0.200
    83.609     0.565     0.200
    83.884     0.422     0.200
    84.204     0.472     0.200
    84.181     1.345     0.200
    84.405     1.916     0.200
    84.424     0.420     0.200
    84.444     1.315     0.200
    84.477     0.915     0.200
    84.405     1.188     0.200
    84.572     0.771     0.200
    84.618     1.541     0.200
    84.652     0.510     0.200
    84.750     1.673     0.200
    84.802     0.012     0.200
    84.775     0.403     0.200
    84.884     0.675     0.200
    85.039     1.717     0.200
    85.129     1.169     0.200
    85.187     1.078     0.200
    85.188     1.124     0.200
    85.188     0.327     0.200
    85.210     0.222     0.200
    85.805     0.893     0.200
    86.354     0.645     0.200
    87.287    -0.044     0.200
    87.707     1.517     0.200
    87.707     0.517     0.200
    88.203     0.660     0.200
    88.764     0.016     0.200
    88.902     1.964     0.200
    88.895     1.029     0.200
    89.341     1.327     0.200
    89.365     0.394     0.200
    91.462     1.027     0.200
    91.808     1.424     0.200
    92.860    -1.437     0.200
    93.118    -0.157     0.200
    93.191    -0.063     0.200
    93.191     0.648     0.200
    93.198     0.536     0.200
    93.204     0.056     0.200
    93.204     0.181     0.200
    93.204    -0.155     0.200
    93.253     0.371     0.200
    96.173     0.319     0.200
    96.554     0.130     0.200
    96.556     0.395     0.200
    96.556     0.544     0.200
    18.526    -0.692     0.200
    18.526     0.097     0.200
    24.366    -1.666     0.200
    81.011    -0.189     0.200
    22.039    -2.498     0.200
    16.480     2.370     0.200
    16.870     1.803     0.200
    20.440     0.250     0.200
    20.440     0.766     0.200
    20.702    -0.050     0.200
    20.795    -0.877     0.200
    20.795    -0.455     0.200
    21.710    -1.810     0.200
    21.710    -1.271     0.200
    22.422     2.288     0.200
    22.752     2.375     0.200
    23.342    -0.438     0.200
    23.342    -0.618     0.200
    24.136     2.756     0.200
    24.513     2.262     0.200
    24.513     2.660     0.200
    24.817    -0.265     0.200
    24.817    -1.039     0.200
    24.873     2.844     0.200
    24.876     2.410     0.200
    24.969     2.005     0.200
    25.129     2.577     0.200
    25.231     2.408     0.200
    25.314    -0.139     0.200
    25.314    -0.288     0.200
    25.297     1.856     0.200
    25.406     2.460     0.200
    25.413     2.325     0.200
    25.438     2.889     0.200
    25.620    -0.289     0.200
    25.873     2.161     0.200
    25.892     2.373     0.200
    25.928     2.191     0.200
    26.125     1.000     0.200
    26.131     2.757     0.200
    26.277     2.261     0.200
    26.277     1.988     0.200
    26.329     1.994     0.200
    26.358     1.353     0.200
    26.397     1.293     0.200
    26.397     1.520     0.200
    26.741     0.327     0.200
    26.961     1.168     0.200
    26.961    -0.652     0.200
    26.997     2.833     0.200
    27.064     2.772     0.200
    27.208    -1.023     0.200
    27.569     2.468     0.200
    28.281     1.850     0.200
    28.699    -0.074     0.200
    28.867     0.665     0.200
    28.867     1.556     0.200
    29.238     1.066     0.200
    30.134     0.710     0.200
    30.289     0.685     0.200
    30.531     2.188     0.200
    30.591     0.208     0.200
    30.591     1.263     0.200
    30.648     2.120     0.200
    30.761    -0.333     0.200
    30.761    -0.762     0.200
    30.888     0.077     0.200
    30.888     1.648     0.200
    31.302     1.648     0.200
    31.584     2.097     0.200
    31.787     2.572     0.200
    31.892    -1.433     0.200
    31.866     1.716     0.200
    31.993     2.303     0.200
    32.056     2.483     0.200
    32.070     3.196     0.200
    32.150     2.392     0.200
    32.504     2.113     0.200
    32.513     2.484     0.200
    32.635     0.805     0.200
    32.737     2.181     0.200
    32.820     2.369     0.200
    32.917     1.578     0.200
    33.016    -0.082     0.200
    33.256     2.176     0.200
    33.329     2.149     0.200
    33.329     1.704     0.200
    33.334     2.989     0.200
    33.347     2.359     0.200
    33.353     2.249     0.200
    33.398     0.101     0.200
    33.528    -0.163     0.200
    33.528    -0.335     0.200
    33.478     0.036     0.200
    33.478     1.263     0.200
    33.478     1.083     0.200
    33.586     2.103     0.200
    33.627     2.329     0.200
    33.717     1.763     0.200
    33.758     2.273     0.200
    33.794     0.859     0.200
    33.794     1.891     0.200
    33.795     1.975     0.200
    33.795     0.748     0.200
    33.990     0.256     0.200
    33.929     1.799     0.200
    33.981     2.813     0.200
    33.981     1.477     0.200
    33.996     2.591     0.200
    34.282     2.263     0.200
    34.309     0.873     0.200
    34.365     1.864     0.200
    34.375     1.804     0.200
    34.611     1.208     0.200
    34.563     1.382     0.200
    34.837    -0.847     0.200
    34.857     0.897     0.200
    34.890     2.229     0.200
    35.002     2.534     0.200
    35.105     1.730     0.200
    35.230     2.297     0.200
    35.270     1.936     0.200
    35.289     0.788     0.200
    35.293     1.428     0.200
    35.468     1.706     0.200
    35.498     1.770     0.200
    35.597     0.714     0.200
    35.609     2.401     0.200
    35.724     2.315     0.200
    35.823     0.844     0.200
    35.815     2.237     0.200
    35.805     0.931     0.200
    35.899     2.342     0.200
    35.858     0.484     0.200
    36.006    -1.173     0.200
    35.965     2.048     0.200
    35.920     2.159     0.200
    36.093     0.517     0.200
    36.093     1.853     0.200
    36.093     1.689     0.200
    36.245    -0.697     0.200
    36.260     0.901     0.200
    36.260     1.916     0.200
    36.305     1.861     0.200
    36.381     0.642     0.200
    36.381     1.572     0.200
    36.352     1.379     0.200
    36.352     1.887     0.200
    36.352     2.113     0.200
    36.359     1.913     0.200
    36.507     0.927     0.200
    36.507     1.622     0.200
    36.481     1.910     0.200
    36.560     2.399     0.200
    36.701     0.732     0.200
    36.650     2.335     0.200
    36.926    -0.774     0.200
    36.926    -0.532     0.200
    36.862     1.673     0.200
    36.923     1.781     0.200
    36.969    -0.011     0.200
    37.005     1.608     0.200
    37.088     0.680     0.200
    37.088     0.204     0.200
    37.064     1.065     0.200
    37.064     1.729     0.200
    37.074    -0.255     0.200
    37.089     1.815     0.200
    37.153     1.126     0.200
    37.185     1.311     0.200
    37.216     1.633     0.200
    37.276     2.341     0.200
    37.295     1.602     0.200
    37.345     1.098     0.200
    37.586     1.513     0.200
    37.628     1.380     0.200
    37.660     1.981     0.200
    37.724     2.561     0.200
    38.015    -0.858     0.200
    37.981     1.176     0.200
    37.981     1.903     0.200
    38.126     0.949     0.200
    38.126     1.730     0.200
    38.186     0.139     0.200
    38.186     0.624     0.200
    38.186     0.522     0.200
    38.225    -0.270     0.200
    38.225     0.418     0.200
    38.496     0.412     0.200
    38.498     0.376     0.200
    38.696     2.532     0.200
    38.766    -0.355     0.200
    38.766     0.918     0.200
    38.766     0.762     0.200
    38.812     2.251     0.200
    38.930     2.231     0.200
    39.241     1.505     0.200
    39.314    -0.333     0.200
    39.314     0.347     0.200
    39.400    -0.391     0.200
    39.400     0.328     0.200
    39.451     2.401     0.200
    39.515    -0.102     0.200
    39.515     0.765     0.200
    39.515     2.171     0.200
    39.592     2.093     0.200
    39.951     0.072     0.200
    40.028     0.937     0.200
    40.216     2.167     0.200
    40.216     1.925     0.200
    40.434     1.712     0.200
    40.434     2.407     0.200
    40.495     2.035     0.200
    40.526    -0.380     0.200
    40.526     0.104     0.200
    40.526    -0.185     0.200
    40.766    -0.107     0.200
    40.766     0.698     0.200
    40.766     0.597     0.200
    40.919     0.011     0.200
    40.919     0.464     0.200
    40.898     0.055     0.200
    40.898     1.508     0.200
    40.898     2.001     0.200
    40.898     1.657     0.200
    41.108    -0.917     0.200
    41.160     0.797     0.200
    41.160     1.118     0.200
    41.160     1.219     0.200
    41.273     2.874     0.200
    41.273     2.617     0.200
    41.371    -0.581     0.200
    41.349     2.808     0.200
    41.595     0.097     0.200
    41.543     0.071     0.200
    41.543     0.173     0.200
    41.680    -0.230     0.200
    41.711    -0.069     0.200
    41.711     0.790     0.200
    41.711     0.478     0.200
    41.797     0.059     0.200
    41.797     0.661     0.200
    41.931     2.691     0.200
    41.931     2.574     0.200
    41.999    -0.039     0.200
    42.000     0.628     0.200
    41.997     0.218     0.200
    41.997     1.750     0.200
    41.997     1.601     0.200
    42.143     0.026     0.200
    42.143     0.854     0.200
    42.850     0.033     0.200
    42.850     1.268     0.200
    42.883     0.218     0.200
    42.883     0.874     0.200
    43.052    -0.079     0.200
    43.115     0.133     0.200
    43.115     0.501     0.200
    43.171    -0.106     0.200
    43.171     0.090     0.200
    43.216     2.317     0.200
    43.376     0.130     0.200
    43.376     0.356     0.200
    43.580    -0.013     0.200
    43.580     0.385     0.200
    43.614     0.695     0.200
    43.614     0.312     0.200
    43.651     0.099     0.200
    43.651     1.575     0.200
    43.651     1.146     0.200
    43.693     0.499     0.200
    43.693     1.460     0.200
    43.693     1.210     0.200
    43.765     0.153     0.200
    43.765     0.583     0.200
    43.930     0.426     0.200
    43.930     1.059     0.200
    43.901     0.693     0.200
    43.901     2.193     0.200
    43.901     1.990     0.200
    44.155    -0.088     0.200
    44.155     0.701     0.200
    44.355    -0.297     0.200
    44.355    -0.000     0.200
    44.344    -0.091     0.200
    44.344     0.495     0.200
    44.605    -0.968     0.200
    44.605    -0.171     0.200
    44.625    -0.933     0.200
    44.625    -0.129     0.200
    44.704    -0.090     0.200
    44.704     0.464     0.200
    44.926    -0.902     0.200
    44.954    -0.120     0.200
    44.954     0.451     0.200
    44.968    -0.091     0.200
    44.966    -0.022     0.200
    44.966     0.376     0.200
    45.053    -0.408     0.200
    45.111     1.223     0.200
    45.135     0.600     0.200
    45.149     0.122     0.200
    45.149     0.544     0.200
    45.394    -0.681     0.200
    45.394    -0.314     0.200
    45.407     0.380     0.200
    45.407     0.927     0.200
    45.407     1.091     0.200
    45.530    -1.101     0.200
    45.530    -0.437     0.200
    45.636    -0.628     0.200
    45.598     0.042     0.200
    45.598     0.487     0.200
    45.678    -0.057     0.200
    45.767    -0.124     0.200
    45.767     0.134     0.200
    45.767     0.602     0.200
    45.730    -0.475     0.200
    45.730     0.283     0.200
    45.784     0.417     0.200
    45.784     0.847     0.200
    45.737    -0.412     0.200
    45.737    -0.029     0.200
    45.803    -0.518     0.200
    45.803    -0.182     0.200
    45.845     0.115     0.200
    45.820    -0.140     0.200
    45.874     0.489     0.200
    45.868    -0.491     0.200
    45.868     0.087     0.200
    46.044     0.322     0.200
    46.044     1.361     0.200
    46.044     0.912     0.200
    46.044     0.599     0.200
    46.044     0.459     0.200
    46.046    -0.065     0.200
    46.073    -0.920     0.200
    46.073     0.197     0.200
    46.270    -0.154     0.200
    46.270     0.245     0.200
    46.385    -0.453     0.200
    46.385    -0.180     0.200
    46.419    -1.366     0.200
    46.419    -1.070     0.200
    46.457    -0.398     0.200
    46.457     0.797     0.200
    46.457     1.071     0.200
    46.603    -0.601     0.200
    46.603    -0.547     0.200
    46.607    -0.802     0.200
    46.647    -0.335     0.200
    46.647    -0.210     0.200
    46.646    -0.295     0.200
    46.646     0.416     0.200
    46.598    -1.051     0.200
    46.598    -0.699     0.200
    46.653     1.064     0.200
    46.653     1.532     0.200
    46.653     0.507     0.200
    46.654     1.683     0.200
    46.712    -0.065     0.200
    46.712    -0.221     0.200
    46.844    -0.577     0.200
    47.060    -0.785     0.200
    47.060    -0.597     0.200
    47.197     0.318     0.200
    47.211    -0.521     0.200
    47.211     0.158     0.200
    47.298    -0.371     0.200
    47.298     0.683     0.200
    47.340    -1.462     0.200
    47.340    -0.727     0.200
    47.340    -0.876     0.200
    47.370    -0.531     0.200
    47.370     0.040     0.200
    47.387    -0.749     0.200
    47.387     0.087     0.200
    47.393    -1.567     0.200
    47.449    -0.435     0.200
    47.457     0.998     0.200
    47.562    -0.563     0.200
    47.543    -0.750     0.200
    47.504    -0.583     0.200
    47.504    -0.169     0.200
    47.571    -0.410     0.200
    47.625    -1.034     0.200
    47.625    -0.705     0.200
    47.625    -0.815     0.200
    47.770    -0.385     0.200
    47.760     1.507     0.200
    47.852    -0.724     0.200
    47.852    -0.193     0.200
    47.924    -0.062     0.200
    47.924     0.172     0.200
    47.980     0.059     0.200
    47.963    -0.142     0.200
    47.963     0.944     0.200
    48.004    -0.788     0.200
    48.004    -0.116     0.200
    48.032    -2.246     0.200
    48.090     0.337     0.200
    48.056    -0.117     0.200
    48.056     0.375     0.200
    48.170     0.269     0.200
    48.213     0.504     0.200
    48.168     1.215     0.200
    48.168     1.004     0.200
    48.263    -0.020     0.200
    48.297     0.292     0.200
    48.371    -1.442     0.200
    48.454    -0.878     0.200
    48.454     0.029     0.200
    48.488    -0.709     0.200
    48.488    -0.404     0.200
    48.520    -0.160     0.200
    48.520     0.254     0.200
    48.510    -0.331     0.200
    48.510     0.372     0.200
    48.510     0.497     0.200
    48.635    -0.537     0.200
    48.635    -0.217     0.200
    48.635    -0.061     0.200
    48.692    -0.380     0.200
    48.642     0.608     0.200
    48.699    -1.169     0.200
    48.699    -0.825     0.200
    48.754     0.871     0.200
    48.715    -0.929     0.200
    48.715    -0.101     0.200
    48.793    -1.414     0.200
    48.813    -1.347     0.200
    48.813    -0.604     0.200
    48.873    -0.643     0.200
    48.873    -0.135     0.200
    48.975    -0.788     0.200
    48.975    -0.444     0.200
    48.994     0.336     0.200
    48.994     1.008     0.200
    48.994     1.117     0.200
    49.046    -0.554     0.200
    49.163    -0.667     0.200
    49.210    -0.428     0.200
    49.215    -0.781     0.200
    49.215    -0.922     0.200
    49.291    -0.670     0.200
    49.291    -0.451     0.200
    49.380    -0.742     0.200
    49.397    -0.151     0.200
    49.442    -0.471     0.200
    49.493    -0.560     0.200
    49.535    -0.795     0.200
    49.537     0.159     0.200
    49.583    -1.904     0.200
    49.583    -0.583     0.200
    49.618    -1.227     0.200
    49.618    -0.891     0.200
    49.682     0.455     0.200
    49.715    -1.251     0.200
    49.715    -0.665     0.200
    49.711    -0.089     0.200
    49.830    -0.111     0.200
    49.830     1.022     0.200
    49.830     0.889     0.200
    49.887     0.042     0.200
    49.887     0.269     0.200
    49.931    -0.021     0.200
    49.931     1.096     0.200
    49.960    -0.877     0.200
    49.993    -0.362     0.200
    49.993     0.817     0.200
    50.283    -0.918     0.200
    50.283    -0.683     0.200
    50.350    -0.435     0.200
    50.322     1.739     0.200
    50.404    -0.730     0.200
    50.404    -0.379     0.200
    50.428    -0.876     0.200
    50.428    -0.197     0.200
    50.423     0.116     0.200
    50.423     0.014     0.200
    50.442     0.641     0.200
    50.603     0.649     0.200
    50.603     0.040     0.200
    50.562     0.682     0.200
    50.562    -0.177     0.200
    50.580    -0.468     0.200
    50.687    -0.087     0.200
    50.628     0.150     0.200
    50.615     1.208     0.200
    50.666     0.229     0.200
    50.743     0.078     0.200
    50.767    -0.510     0.200
    50.782     1.127     0.200
    50.838     0.385     0.200
    50.844    -0.088     0.200
    50.844    -0.369     0.200
    50.954    -0.708     0.200
    50.910    -0.612     0.200
    50.902     0.048     0.200
    50.902     0.150     0.200
    50.902    -0.108     0.200
    50.984     0.030     0.200
    51.056    -0.138     0.200
    51.056    -0.317     0.200
    51.077     0.056     0.200
    51.073     0.012     0.200
    51.073    -0.238     0.200
    51.105    -0.010     0.200
    51.090     0.587     0.200
    51.136    -0.851     0.200
    51.201     1.261     0.200
    51.196    -0.591     0.200
    51.233     0.868     0.200
    51.253    -1.241     0.200
    51.226     0.292     0.200
    51.233     0.492     0.200
    51.272     0.950     0.200
    51.283     0.134     0.200
    51.283    -0.100     0.200
    51.296     0.308     0.200
    51.296     0.144     0.200
    51.313    -0.907     0.200
    51.313    -1.071     0.200
    51.316     0.090     0.200
    51.383    -0.603     0.200
    51.383    -0.845     0.200
    51.428    -1.448     0.200
    51.484    -0.121     0.200
    51.484    -0.355     0.200
    51.484     0.059     0.200
    51.476     0.018     0.200
    51.499     0.424     0.200
    51.506    -0.010     0.200
    51.506    -0.143     0.200
    51.548     0.868     0.200
    51.589     0.227     0.200
    51.603    -0.152     0.200
    51.669    -0.095     0.200
    51.669    -0.384     0.200
    51.713    -0.703     0.200
    51.713    -0.844     0.200
    51.736    -1.028     0.200
    51.741    -0.832     0.200
    51.743     0.063     0.200
    51.823    -0.526     0.200
    51.855    -0.614     0.200
    51.855    -0.723     0.200
    51.851     0.093     0.200
    51.884    -0.450     0.200
    51.901     0.277     0.200
    51.920    -0.263     0.200
    51.967    -0.780     0.200
    51.962    -0.027     0.200
    51.952     0.708     0.200
    51.952     0.536     0.200
    52.005     0.760     0.200
    52.027     0.080     0.200
    52.027     0.236     0.200
    52.084     0.133     0.200
    52.163    -0.052     0.200
    52.163    -0.232     0.200
    52.215    -0.976     0.200
    52.287     0.511     0.200
    52.283    -0.396     0.200
    52.335    -0.231     0.200
    52.368     0.205     0.200
    52.355    -0.476     0.200
    52.415    -0.150     0.200
    52.398     1.186     0.200
    52.398     1.014     0.200
    52.404     1.345     0.200
    52.492    -0.189     0.200
    52.485     0.678     0.200
    52.484    -0.483     0.200
    52.474    -0.259     0.200
    52.474     0.351     0.200
    52.544    -0.302     0.200
    52.544    -0.575     0.200
    52.620    -0.118     0.200
    52.620     0.007     0.200
    52.675     1.252     0.200
    52.701    -0.144     0.200
    52.716    -0.268     0.200
    52.730    -0.055     0.200
    52.730     0.046     0.200
    52.730    -0.274     0.200
    52.804    -1.818     0.200
    52.815     0.215     0.200
    52.815     0.074     0.200
    52.818    -0.034     0.200
    52.818     0.075     0.200
    52.817    -0.323     0.200
    52.916    -0.530     0.200
    52.916    -0.397     0.200
    52.908    -0.449     0.200
    52.908    -0.324     0.200
    52.959     0.191     0.200
    52.994    -0.344     0.200
    52.978    -0.438     0.200
    53.030     1.813     0.200
    53.027    -0.492     0.200
    53.067    -0.347     0.200
    53.075    -0.553     0.200
    53.075    -0.803     0.200
    53.137    -0.661     0.200
    53.190     0.011     0.200
    53.190    -0.208     0.200
    53.167     0.408     0.200
    53.211    -0.276     0.200
    53.211    -0.105     0.200
    53.245    -0.532     0.200
    53.245    -0.407     0.200
    53.296     0.138     0.200
    53.318     0.215     0.200
    53.318     0.340     0.200
    53.238     0.926     0.200
    53.341    -0.511     0.200
    53.341    -0.753     0.200
    53.348    -0.938     0.200
    53.375    -0.114     0.200
    53.384     0.024     0.200
    53.390    -0.123     0.200
    53.390    -0.341     0.200
    53.433    -0.334     0.200
    53.433    -0.677     0.200
    53.480    -0.351     0.200
    53.480    -0.687     0.200
    53.493    -0.345     0.200
    53.493    -0.243     0.200
    53.570    -0.258     0.200
    53.634    -0.411     0.200
    53.634    -0.279     0.200
    53.653     0.141     0.200
    53.661    -0.304     0.200
    53.661    -0.203     0.200
    53.675     0.027     0.200
    53.687    -1.316     0.200
    53.709    -1.084     0.200
    53.707     0.201     0.200
    53.792     0.014     0.200
    53.792     0.116     0.200
    53.774    -0.049     0.200
    53.823    -0.948     0.200
    53.862    -0.793     0.200
    53.981    -0.169     0.200
    53.981    -0.341     0.200
    54.039    -0.138     0.200
    54.079    -0.680     0.200
    54.079    -0.531     0.200
    54.079    -0.875     0.200
    54.099    -0.110     0.200
    54.119    -1.423     0.200
    54.119    -0.697     0.200
    54.111     0.676     0.200
    54.207    -1.221     0.200
    54.165     0.320     0.200
    54.185    -0.304     0.200
    54.171    -0.933     0.200
    54.223    -0.389     0.200
    54.200    -0.163     0.200
    54.200    -0.381     0.200
    54.277     0.074     0.200
    54.297    -0.100     0.200
    54.297    -0.350     0.200
    54.336    -0.150     0.200
    54.346    -0.431     0.200
    54.365    -0.007     0.200
    54.365     0.118     0.200
    54.365    -0.624     0.200
    54.395    -0.719     0.200
    54.395    -1.032     0.200
    54.389    -0.068     0.200
    54.389    -0.232     0.200
    54.411     0.139     0.200
    54.394    -0.401     0.200
    54.394    -0.550     0.200
    54.441    -0.414     0.200
    54.441     0.313     0.200
    54.464     0.224     0.200
    54.492    -0.044     0.200
    54.569     0.159     0.200
    54.529    -0.189     0.200
    54.529    -0.056     0.200
    54.544     0.260     0.200
    54.544    -0.786     0.200
    54.634     0.982     0.200
    54.660     0.624     0.200
    54.631    -0.332     0.200
    54.629    -0.178     0.200
    54.629    -0.053     0.200
    54.644     0.005     0.200
    54.644     0.115     0.200
    54.656     0.343     0.200
    54.656    -0.407     0.200
    54.686    -0.162     0.200
    54.702    -0.435     0.200
    54.703    -0.017     0.200
    54.703    -0.118     0.200
    54.759    -0.078     0.200
    54.777    -0.251     0.200
    54.777    -0.861     0.200
    54.791    -0.236     0.200
    54.837    -0.601     0.200
    54.828    -0.151     0.200
    54.828    -0.049     0.200
    54.873     0.033     0.200
    54.885     0.543     0.200
    54.903    -0.044     0.200
    54.903    -0.364     0.200
    54.907    -1.277     0.200
    54.928    -0.420     0.200
    54.989     0.441     0.200
    54.950    -0.524     0.200
    54.950    -0.712     0.200
    54.980    -0.701     0.200
    54.980    -0.990     0.200
    55.043    -1.355     0.200
    55.043    -0.808     0.200
    54.982    -0.470     0.200
    54.982    -0.673     0.200
    55.024    -0.316     0.200
    55.043     0.519     0.200
    55.043    -0.035     0.200
    55.045     0.491     0.200
    55.070     0.248     0.200
    55.063    -1.441     0.200
    55.063    -1.191     0.200
    55.063    -1.051     0.200
    55.135    -0.549     0.200
    55.135    -0.736     0.200
    55.220    -0.356     0.200
    55.226     0.135     0.200
    55.295    -0.969     0.200
    55.295    -0.922     0.200
    55.308    -0.061     0.200
    55.337    -0.056     0.200
    55.384    -1.400     0.200
    55.384    -0.962     0.200
    55.393    -0.850     0.200
    55.445     0.150     0.200
    55.445    -0.170     0.200
    55.656    -0.606     0.200
    55.656    -0.966     0.200
    55.684    -0.678     0.200
    55.674    -0.599     0.200
    55.674    -0.880     0.200
    55.754     0.165     0.200
    55.754     0.056     0.200
    55.739     1.616     0.200
    55.719    -0.699     0.200
    55.727    -0.023     0.200
    55.733    -0.270     0.200
    55.759    -0.314     0.200
    55.850    -0.904     0.200
    55.849    -0.525     0.200
    55.832    -0.210     0.200
    55.832    -0.452     0.200
    55.857    -0.861     0.200
    55.857    -1.540     0.200
    55.856     0.070     0.200
    55.856    -0.516     0.200
    56.050    -0.063     0.200
    56.050    -0.391     0.200
    56.050    -0.007     0.200
    56.142    -0.767     0.200
    56.335    -0.146     0.200
    56.335    -0.365     0.200
    56.460    -1.295     0.200
    56.460    -1.475     0.200
    56.583    -1.481     0.200
    56.583    -0.551     0.200
    56.522     0.048     0.200
    56.604    -0.875     0.200
    56.704    -0.702     0.200
    56.723    -1.158     0.200
    56.859    -0.688     0.200
    56.816    -0.070     0.200
    56.816    -0.671     0.200
    56.821     0.104     0.200
    56.896     1.669     0.200
    56.923    -0.300     0.200
    56.923    -1.378     0.200
    57.127    -1.479     0.200
    57.130    -0.618     0.200
    57.409    -0.587     0.200
    57.545     1.580     0.200
    58.043     1.084     0.200
    58.221    -0.487     0.200
    58.457     1.195     0.200
    58.514     0.502     0.200
    58.596    -1.575     0.200
    58.617    -0.602     0.200
    58.665    -0.075     0.200
    58.802     1.245     0.200
    58.888     1.572     0.200
    58.888     0.767     0.200
    58.888     2.798     0.200
    59.197    -0.355     0.200
    59.197     0.231     0.200
    59.197    -0.222     0.200
    59.310     0.704     0.200
    59.423     1.988     0.200
    59.643     0.677     0.200
    60.139    -0.379     0.200
    60.216     1.044     0.200
    60.172    -1.460     0.200
    60.200    -1.284     0.200
    60.200    -1.589     0.200
    61.326    -1.189     0.200
    61.717    -0.341     0.200
    61.829     0.126     0.200
    61.793     0.844     0.200
    62.177     0.533     0.200
    62.142     3.803     0.200
    62.225     0.440     0.200
    62.457    -0.305     0.200
    62.593    -0.740     0.200
    63.103    -0.525     0.200
    63.116    -0.023     0.200
    63.323    -0.925     0.200
    63.377     0.247     0.200
    63.399    -0.573     0.200
    63.400    -0.915     0.200
    63.400    -0.595     0.200
    63.407    -0.076     0.200
    63.424     0.063     0.200
    63.538    -0.016     0.200
    63.568    -0.140     0.200
    63.578     0.099     0.200
    63.584    -0.187     0.200
    63.584    -0.094     0.200
    63.654     0.145     0.200
    63.707     0.185     0.200
    63.712    -0.335     0.200
    63.758     0.069     0.200
    63.761    -0.227     0.200
    63.713     0.032     0.200
    63.713     1.962     0.200
    63.818     0.280     0.200
    63.880    -0.168     0.200
    63.905    -0.234     0.200
    63.905    -0.547     0.200
    64.012    -0.220     0.200
    64.012    -0.110     0.200
    64.012     0.280     0.200
    64.063     1.070     0.200
    64.182     0.487     0.200
    64.393     0.315     0.200
    64.471    -0.988     0.200
    64.471    -0.613     0.200
    64.471    -0.457     0.200
    64.487     0.781     0.200
    64.473     1.268     0.200
    64.500     0.365     0.200
    64.477    -1.070     0.200
    64.597    -0.671     0.200
    64.597    -0.539     0.200
    64.597     0.274     0.200
    64.609     0.209     0.200
    64.655     0.112     0.200
    64.723    -0.703     0.200
    64.756     0.113     0.200
    64.740    -0.646     0.200
    64.863     0.161     0.200
    64.868     0.313     0.200
    64.872    -0.083     0.200
    64.872     0.386     0.200
    64.921    -0.352     0.200
    64.967    -0.195     0.200
    65.091     1.743     0.200
    65.363     0.332     0.200
    65.463     0.191     0.200
    65.405     1.217     0.200
    65.582     0.556     0.200
    65.520     2.029     0.200
    65.835     0.937     0.200
    65.999     0.449     0.200
    66.009    -0.068     0.200
    66.009    -0.139     0.200
    66.009    -0.428     0.200
    65.970     3.268     0.200
    65.888     0.088     0.200
    66.114    -0.337     0.200
    66.114    -0.087     0.200
    66.096    -0.174     0.200
    66.167     0.301     0.200
    66.180    -0.306     0.200
    66.339     0.340     0.200
    66.347    -0.078     0.200
    66.369    -0.787     0.200
    66.369    -0.061     0.200
    66.352     1.117     0.200
    66.541     0.268     0.200
    66.586     0.185     0.200
    66.581    -0.055     0.200
    66.581     0.047     0.200
    66.619     0.237     0.200
    66.691     0.512     0.200
    66.691     1.340     0.200
    66.773     0.211     0.200
    67.114    -0.165     0.200
    67.199     0.375     0.200
    67.283    -0.407     0.200
    67.365     0.567     0.200
    67.446     0.981     0.200
    67.559     0.271     0.200
    67.784     0.227     0.200
    67.784     0.555     0.200
    67.823     0.103     0.200
    67.991    -0.312     0.200
    68.019     0.473     0.200
    67.951     1.372     0.200
    68.279    -0.234     0.200
    68.433     0.347     0.200
    68.599     0.127     0.200
    68.691    -0.129     0.200
    68.894    -0.211     0.200
    68.964     0.747     0.200
    68.992    -0.460     0.200
    69.109    -0.312     0.200
    69.109    -0.906     0.200
    69.109    -0.710     0.200
    69.281     0.131     0.200
    69.395    -0.634     0.200
    69.395     0.077     0.200
    69.415     1.349     0.200
    69.499     0.227     0.200
    69.519     0.106     0.200
    69.624    -0.717     0.200
    69.744    -0.224     0.200
    69.858     0.152     0.200
    69.929    -0.176     0.200
    70.137     0.581     0.200
    70.182     0.930     0.200
    70.148     0.379     0.200
    70.171     0.404     0.200
    70.160    -0.448     0.200
    70.295    -0.660     0.200
    70.330     0.624     0.200
    70.465     0.402     0.200
    70.449    -0.003     0.200
    70.531     1.001     0.200
    70.546     0.050     0.200
    70.635     0.863     0.200
    70.806     0.220     0.200
    70.839     0.044     0.200
    70.901    -0.673     0.200
    70.901    -0.548     0.200
    70.901    -0.782     0.200
    70.829    -0.276     0.200
    71.033     0.344     0.200
    71.044     0.775     0.200
    71.216     0.370     0.200
    71.218     1.620     0.200
    71.352    -1.184     0.200
    71.374     0.178     0.200
    71.600     0.192     0.200
    71.600     0.458     0.200
    71.656     0.980     0.200
    71.779     0.734     0.200
    71.864     0.980     0.200
    71.892     1.162     0.200
    72.011     1.155     0.200
    71.972    -1.498     0.200
    72.135     1.230     0.200
    72.236    -0.088     0.200
    72.241     1.488     0.200
    72.183     0.020     0.200
    72.389    -1.208     0.200
    72.317    -0.798     0.200
    72.418     1.306     0.200
    72.418     0.626     0.200
    72.418     1.118     0.200
    72.649     1.356     0.200
    72.689    -0.992     0.200
    72.772     1.689     0.200
    72.759     2.764     0.200
    72.921    -0.570     0.200
    73.145     1.915     0.200
    73.082     0.379     0.200
    73.110     1.888     0.200
    73.324     0.320     0.200
    73.364     0.482     0.200
    73.364     0.482     0.200
    73.364    -0.229     0.200
    73.391    -0.073     0.200
    73.391     0.060     0.200
    73.359    -0.712     0.200
    73.459     0.408     0.200
    73.523     0.695     0.200
    73.543     0.456     0.200
    73.578     0.375     0.200
    73.584     1.142     0.200
    73.658     0.296     0.200
    73.669    -0.124     0.200
    73.716     0.369     0.200
    73.795     0.021     0.200
    73.797     1.269     0.200
    73.873     0.409     0.200
    73.776     1.521     0.200
    73.890    -0.144     0.200
    73.901     0.466     0.200
    73.910     0.036     0.200
    74.000     0.252     0.200
    74.027    -0.544     0.200
    74.027    -0.669     0.200
    74.027    -0.372     0.200
    74.078     1.251     0.200
    74.079    -0.097     0.200
    74.118     1.552     0.200
    74.247     0.242     0.200
    74.284     0.027     0.200
    74.310     0.806     0.200
    74.385     1.037     0.200
    74.431     0.272     0.200
    74.494     0.408     0.200
    74.491     0.765     0.200
    74.783     0.331     0.200
    74.785     0.119     0.200
    74.892     0.849     0.200
    74.892     0.896     0.200
    75.057     0.150     0.200
    75.088     0.074     0.200
    75.011     1.009     0.200
    75.103     0.023     0.200
    75.103     0.320     0.200
    75.425     1.191     0.200
    75.425     1.535     0.200
    75.508     0.870     0.200
    75.522     0.376     0.200
    75.544     0.685     0.200
    75.593     0.880     0.200
    75.593     0.567     0.200
    75.658     1.042     0.200
    75.532     1.749     0.200
    75.532     2.217     0.200
    75.767     1.573     0.200
    75.784     0.376     0.200
    75.885     0.557     0.200
    75.885     0.526     0.200
    75.885    -0.146     0.200
    75.836     0.954     0.200
    75.941     0.084     0.200
    75.995     1.073     0.200
    76.020    -0.523     0.200
    76.024     1.607     0.200
    76.024     0.348     0.200
    76.028     0.686     0.200
    75.948     1.443     0.200
    76.158     1.300     0.200
    76.132     0.054     0.200
    76.173     2.807     0.200
    76.208     0.484     0.200
    76.297    -1.146     0.200
    76.322     1.019     0.200
    76.363     1.181     0.200
    76.289     1.601     0.200
    76.414     0.493     0.200
    76.445     0.618     0.200
    76.499     1.012     0.200
    76.449     0.634     0.200
    76.500     1.417     0.200
    76.460     0.894     0.200
    76.536     0.102     0.200
    76.631    -0.273     0.200
    76.531     1.632     0.200
    76.672     1.232     0.200
    76.630     0.929     0.200
    76.658    -0.409     0.200
    76.658    -1.565     0.200
    76.801     0.631     0.200
    76.805     0.084     0.200
    76.898     1.029     0.200
    76.907     0.453     0.200
    77.005     0.737     0.200
    77.005     0.448     0.200
    77.005     0.925     0.200
    77.033     0.434     0.200
    77.054     0.579     0.200
    77.085     1.209     0.200
    77.101     0.885     0.200
    77.031    -1.621     0.200
    77.142     0.515     0.200
    77.167     0.888     0.200
    77.167     0.990     0.200
    77.186     0.463     0.200
    77.129     0.355     0.200
    77.220     0.685     0.200
    77.238     0.072     0.200
    77.243     0.747     0.200
    77.262     0.943     0.200
    77.267     0.598     0.200
    77.338     1.011     0.200
    77.351     1.044     0.200
    77.367     0.681     0.200
    77.428     1.074     0.200
    77.457     1.765     0.200
    77.457     1.156     0.200
    77.515     1.074     0.200
    77.534     1.084     0.200
    77.546     1.043     0.200
    77.546     1.215     0.200
    77.561     1.144     0.200
    77.607    -0.039     0.200
    77.628     1.306     0.200
    77.628     1.312     0.200
    77.653     1.227     0.200
    77.710     0.832     0.200
    77.743    -0.570     0.200
    77.774     1.485     0.200
    77.816     1.514     0.200
    77.804     0.830     0.200
    77.822    -0.715     0.200
    77.822    -0.496     0.200
    77.822    -1.012     0.200
    77.725     2.324     0.200
    77.873     1.028     0.200
    77.909     0.670     0.200
    77.916     0.765     0.200
    77.951     1.058     0.200
    78.092     0.523     0.200
    78.112     0.822     0.200
    78.134     0.215     0.200
    78.148     0.258     0.200
    78.152     0.088     0.200
    78.158     0.624     0.200
    78.202     1.123     0.200
    78.213     0.820     0.200
    78.258     0.951     0.200
    78.190     0.190     0.200
    78.295     0.516     0.200
    78.262     0.119     0.200
    78.324    -0.224     0.200
    78.387     0.959     0.200
    78.354     0.883     0.200
    78.529     0.945     0.200
    78.549     0.417     0.200
    78.542    -0.798     0.200
    78.644     0.728     0.200
    78.664     1.140     0.200
    78.690     0.216     0.200
    78.690     0.083     0.200
    78.722    -0.285     0.200
    78.722     0.012     0.200
    78.744     1.278     0.200
    78.759     0.994     0.200
    78.805     0.490     0.200
    78.805     0.787     0.200
    78.747     0.474     0.200
    78.886     0.744     0.200
    78.895    -0.094     0.200
    78.909     1.501     0.200
    78.930     0.766     0.200
    78.943     0.867     0.200
    78.965     0.612     0.200
    78.981    -0.412     0.200
    78.984     0.661     0.200
    79.005     1.387     0.200
    79.021    -0.130     0.200
    79.056     0.391     0.200
    78.973     0.233     0.200
    79.104     0.783     0.200
    79.107     1.016     0.200
    79.178     0.935     0.200
    79.160    -0.396     0.200
    79.199     0.992     0.200
    79.199     0.436     0.200
    79.213    -0.581     0.200
    79.235     0.488     0.200
    79.245     0.933     0.200
    79.284     1.205     0.200
    79.285     1.108     0.200
    79.294     0.332     0.200
    79.315     0.527     0.200
    79.344     1.157     0.200
    79.344     0.415     0.200
    79.344    -0.194     0.200
    79.344     0.923     0.200
    79.368     0.552     0.200
    79.405    -0.730     0.200
    79.420     0.621     0.200
    79.448     0.797     0.200
    79.464    -0.019     0.200
    79.494    -1.507     0.200
    79.532     1.017     0.200
    79.534     0.924     0.200
    79.549     1.345     0.200
    79.550     0.624     0.200
    79.561     1.024     0.200
    79.569     0.278     0.200
    79.592     0.058     0.200
    79.558     0.942     0.200
    79.559     1.480     0.200
    79.727     2.222     0.200
    79.689     1.266     0.200
    79.736     0.678     0.200
    79.765     0.555     0.200
    79.765     0.212     0.200
    79.819     0.477     0.200
    79.899    -0.004     0.200
    79.912     0.915     0.200
    80.024     0.642     0.200
    79.941    -1.498     0.200
    80.032     1.270     0.200
    80.048    -0.033     0.200
    80.089     0.728     0.200
    80.133    -0.173     0.200
    80.104     1.186     0.200
    80.150     0.420     0.200
    80.131    -0.377     0.200
    80.209     1.214     0.200
    80.229     0.045     0.200
    80.258     1.057     0.200
    80.262     0.484     0.200
    80.292    -1.634     0.200
    80.297     0.334     0.200
    80.352     0.035     0.200
    80.358     0.021     0.200
    80.370     0.150     0.200
    80.404     1.072     0.200
    80.345     0.284     0.200
    80.345     1.284     0.200
    80.448     0.929     0.200
    80.455     1.297     0.200
    80.483     1.242     0.200
    80.514     1.173     0.200
    80.576     0.665     0.200
    80.552     1.574     0.200
    80.634    -0.231     0.200
    80.645    -0.131     0.200
    80.645     1.309     0.200
    80.667     1.192     0.200
    80.595    -0.048     0.200
    80.745    -0.054     0.200
    80.711     0.931     0.200
    80.765     1.229     0.200
    80.799     0.650     0.200
    80.827     0.080     0.200
    80.827     0.307     0.200
    80.738     0.291     0.200
    80.738     0.478     0.200
    80.898     0.636     0.200
    80.901     0.411     0.200
    80.964     0.975     0.200
    80.929     0.020     0.200
    80.973     0.719     0.200
    80.988     0.742     0.200
    80.989     0.840     0.200
    81.013     0.813     0.200
    81.032     0.479     0.200
    81.052     1.108     0.200
    81.082     0.641     0.200
    81.002    -1.394     0.200
    81.074     1.286     0.200
    81.095     1.071     0.200
    81.271     0.054     0.200
    81.299    -0.011     0.200
    81.303     0.231     0.200
    81.380     0.802     0.200
    81.387     0.828     0.200
    81.387     1.633     0.200
    81.391     1.400     0.200
    81.391     1.197     0.200
    81.501     0.583     0.200
    81.516     0.736     0.200
    81.436     0.864     0.200
    81.556     0.231     0.200
    81.556    -0.908     0.200
    81.587     0.863     0.200
    81.590    -0.347     0.200
    81.549    -0.240     0.200
    81.634     0.614     0.200
    81.663     0.962     0.200
    81.599    -0.519     0.200
    81.599     0.161     0.200
    81.703     1.730     0.200
    81.706     0.236     0.200
    81.706     0.439     0.200
    81.794     0.543     0.200
    81.731     1.948     0.200
    81.845     1.301     0.200
    81.849     0.834     0.200
    81.849     0.444     0.200
    81.849     1.553     0.200
    81.840     1.311     0.200
    81.842     1.220     0.200
    81.842     0.822     0.200
    81.942     0.697     0.200
    81.966     0.971     0.200
    81.889    -1.093     0.200
    82.000     0.190     0.200
    82.009    -0.455     0.200
    82.051     0.325     0.200
    82.068     0.433     0.200
    82.097     0.280     0.200
    82.142     0.145     0.200
    82.006     0.571     0.200
    82.180    -0.154     0.200
    82.328    -0.021     0.200
    82.328    -0.224     0.200
    82.328    -0.325     0.200
    82.329     0.370     0.200
    82.340     1.331     0.200
    82.362     0.200     0.200
    82.356     0.733     0.200
    82.380     0.115     0.200
    82.380    -0.049     0.200
    82.389     0.558     0.200
    82.453    -0.376     0.200
    82.453    -0.079     0.200
    82.484     0.039     0.200
    82.484     0.148     0.200
    82.484     0.258     0.200
    82.399     0.905     0.200
    82.518     0.782     0.200
    82.533     2.079     0.200
    82.564     1.022     0.200
    82.607     0.116     0.200
    82.620     0.852     0.200
    82.648     0.398     0.200
    82.670     0.390     0.200
    82.720     1.265     0.200
    82.726     0.200     0.200
    82.726     0.396     0.200
    82.638    -0.342     0.200
    82.811     1.112     0.200
    82.812     1.053     0.200
    82.812     0.897     0.200
    82.851     0.748     0.200
    82.851     0.584     0.200
    82.851     1.139     0.200
    82.862     1.033     0.200
    82.772     2.111     0.200
    82.950     0.039     0.200
    82.894     0.129     0.200
    82.932    -0.899     0.200
    83.054     1.104     0.200
    83.080     0.869     0.200
    83.025    -0.448     0.200
    83.202     1.137     0.200
    83.243     0.222     0.200
    83.307     1.823     0.200
    83.367     1.186     0.200
    83.329    -0.955     0.200
    83.525     2.287     0.200
    83.441    -0.496     0.200
    83.558     0.906     0.200
    83.574     0.448     0.200
    83.574     0.323     0.200
    83.574     0.745     0.200
    83.596     0.708     0.200
    83.635     0.708     0.200
    83.581     1.288     0.200
    83.696     0.439     0.200
    83.720     0.873     0.200
    83.720     0.975     0.200
    83.723     0.749     0.200
    83.743     1.935     0.200
    83.760     0.869     0.200
    83.698     1.357     0.200
    83.795     0.487     0.200
    83.761    -0.306     0.200
    83.897     0.568     0.200
    83.951     0.494     0.200
    83.947     1.003     0.200
    83.809    -0.708     0.200
    83.970     0.900     0.200
    83.983     0.944     0.200
    84.087     0.398     0.200
    84.094     1.136     0.200
    84.094     0.463     0.200
    84.108     0.391     0.200
    84.109     0.479     0.200
    84.109     1.088     0.200
    84.024    -1.176     0.200
    84.146     0.197     0.200
    84.146     0.345     0.200
    84.226     0.891     0.200
    84.226     0.212     0.200
    84.226     1.266     0.200
    84.235     0.451     0.200
    84.235     0.716     0.200
    84.282    -0.389     0.200
    84.288    -0.627     0.200
    84.305     0.391     0.200
    84.305     1.204     0.200
    84.209     1.471     0.200
    84.209     1.619     0.200
    84.321     0.012     0.200
    84.289    -1.067     0.200
    84.394     0.042     0.200
    84.447     0.474     0.200
    84.447     1.834     0.200
    84.406     0.260     0.200
    84.514     0.431     0.200
    84.540    -0.095     0.200
    84.563     0.803     0.200
    84.570     0.152     0.200
    84.592     1.690     0.200
    84.622    -0.012     0.200
    84.629     1.001     0.200
    84.630     0.741     0.200
    84.630     0.851     0.200
    84.630     1.054     0.200
    84.730     1.822     0.200
    84.735     1.046     0.200
    84.777     0.905     0.200
    84.797     2.150     0.200
    84.816     0.151     0.200
    84.824     0.074     0.200
    84.824     0.262     0.200
    84.824     1.254     0.200
    84.876     0.741     0.200
    84.974     0.218     0.200
    84.976     0.208     0.200
    84.895     0.618     0.200
    84.982    -0.321     0.200
    84.930     0.042     0.200
    85.042     0.279     0.200
    85.127     0.850     0.200
    85.206     0.354     0.200
    85.206     0.964     0.200
    85.268     1.554     0.200
    85.363    -0.326     0.200
    85.392     0.427     0.200
    85.550    -0.462     0.200
    85.609    -0.153     0.200
    85.640    -0.105     0.200
    85.666     0.695     0.200
    85.878    -0.732     0.200
    85.913     0.145     0.200
    86.010     0.755     0.200
    86.082     1.400     0.200
    86.100     1.220     0.200
    86.135     1.939     0.200
    86.207     0.386     0.200
    86.212    -0.036     0.200
    86.225    -1.099     0.200
    86.266    -0.505     0.200
    86.267    -1.705     0.200
    86.260     1.932     0.200
    86.304     0.111     0.200
    86.311     0.682     0.200
    86.333     0.470     0.200
    86.386     1.397     0.200
    86.417    -0.046     0.200
    86.455    -0.132     0.200
    86.465     0.321     0.200
    86.499     0.552     0.200
    86.512     0.285     0.200
    86.665     0.036     0.200
    86.685     0.038     0.200
    86.747     0.136     0.200
    86.748    -0.667     0.200
    86.776     0.633     0.200
    86.810     0.031     0.200
    86.823    -1.137     0.200
    86.854    -0.480     0.200
    86.858    -0.603     0.200
    86.869     0.846     0.200
    86.883    -0.427     0.200
    86.937    -0.990     0.200
    86.949     1.329     0.200
    86.974     0.436     0.200
    86.986     0.068     0.200
    87.051    -1.246     0.200
    87.082    -0.156     0.200
    87.101    -0.588     0.200
    87.300    -0.951     0.200
    87.530    -1.562     0.200
    87.602     0.491     0.200
    87.744    -0.086     0.200
    87.712     1.070     0.200
    87.830    -0.922     0.200
    87.887     0.764     0.200
    88.028    -1.538     0.200
    88.043    -0.903     0.200
    88.188    -0.888     0.200
    88.196    -1.334     0.200
    88.198    -1.343     0.200
    88.254     0.185     0.200
    88.310    -0.090     0.200
    88.420     0.811     0.200
    88.486    -2.297     0.200
    88.525    -0.981     0.200
    88.525     0.206     0.200
    88.494     1.464     0.200
    88.604     0.420     0.200
    88.668     0.142     0.200
    88.655    -0.001     0.200
    88.539     0.548     0.200
    88.662     0.571     0.200
    88.779     0.822     0.200
    89.041    -0.110     0.200
    89.240    -2.342     0.200
    89.240    -0.154     0.200
    89.312     1.643     0.200
    89.379     0.343     0.200
    89.434    -0.750     0.200
    89.365     0.793     0.200
    89.365     0.394     0.200
    89.411     2.382     0.200
    89.421     0.226     0.200
    89.409     1.061     0.200
    89.584    -1.154     0.200
    89.586    -0.566     0.200
    89.612     0.892     0.200
    89.712    -1.252     0.200
    89.904     0.451     0.200
    90.052    -0.243     0.200
    90.051    -0.137     0.200
    90.313     1.548     0.200
    90.640     0.889     0.200
    90.782     2.053     0.200
    91.351     1.616     0.200
    91.463     1.072     0.200
    91.463     3.299     0.200
    91.694     0.998     0.200
    91.754     1.407     0.200
    92.055     1.256     0.200
    92.211     0.895     0.200
    92.629     0.185     0.200
    92.902     0.527     0.200
    92.903     1.850     0.200
    93.977     0.773     0.200
    93.983    -0.171     0.200
    93.997    -0.045     0.200
    94.386    -0.378     0.200
    94.729     0.205     0.200
    94.884    -0.334     0.200
    94.963    -0.352     0.200
    95.152     0.181     0.200
    95.566    -0.161     0.200
    97.217    -0.057     0.200
    97.356     0.101     0.200
    97.356    -0.438     0.200
    98.704    -0.408     0.200
    98.704     0.373     0.200
    99.355    -1.476     0.200
    20.514     0.615     0.200
    20.514    -0.465     0.200
    20.835    -0.773     0.200
    20.835    -0.558     0.200
    21.758    -1.408     0.200
    21.758    -1.588     0.200
    23.233     1.181     0.200
    23.358    -1.033     0.200
    23.516     1.261     0.200
    23.609     1.472     0.200
    23.628     0.438     0.200
    24.519     1.478     0.200
    24.762     2.198     0.200
    24.938     2.422     0.200
    25.189     1.606     0.200
    25.314     2.226     0.200
    25.400     2.921     0.200
    25.391     2.135     0.200
    25.360    -0.783     0.200
    25.551     2.197     0.200
    25.615     2.743     0.200
    25.687    -1.120     0.200
    25.687    -1.270     0.200
    25.829     2.725     0.200
    25.893     2.530     0.200
    25.954     2.389     0.200
    26.112     1.189     0.200
    26.089     1.832     0.200
    26.249     1.987     0.200
    26.249     1.772     0.200
    26.352     3.016     0.200
    26.813     1.883     0.200
    26.914     1.977     0.200
    27.016     2.886     0.200
    28.319     2.547     0.200
    28.838     1.581     0.200
    30.175     2.967     0.200
    30.260     2.013     0.200
    30.495     1.462     0.200
    30.558     2.700     0.200
    30.617     2.290     0.200
    30.859     1.601     0.200
    31.554     2.583     0.200
    31.739     2.965     0.200
    32.174     1.129     0.200
    32.294     2.727     0.200
    32.472     2.301     0.200
    32.486     2.883     0.200
    32.486     1.731     0.200
    33.203     1.427     0.200
    33.285     1.983     0.200
    33.301     1.849     0.200
    33.303     2.724     0.200
    33.604    -1.206     0.200
    33.604    -1.635     0.200
    33.532     0.815     0.200
    33.588     2.314     0.200
    33.666     1.539     0.200
    33.762     1.625     0.200
    33.762     1.795     0.200
    33.763     1.842     0.200
    33.763     2.043     0.200
    33.906     2.602     0.200
    33.934     2.316     0.200
    33.934     2.603     0.200
    33.947     2.389     0.200
    34.140     2.601     0.200
    34.168     1.897     0.200
    34.231     1.918     0.200
    34.260     2.458     0.200
    34.839     2.481     0.200
    34.839     1.335     0.200
    35.098     3.051     0.200
    35.107     2.535     0.200
    35.229     1.922     0.200
    35.251     2.076     0.200
    35.386     1.945     0.200
    35.426     2.079     0.200
    35.568     0.964     0.200
    35.568     1.101     0.200
    35.557     1.837     0.200
    35.620     2.503     0.200
    35.792     1.752     0.200
    35.849     1.306     0.200
    36.069     1.011     0.200
    36.069     1.281     0.200
    36.074    -1.588     0.200
    36.225     1.631     0.200
    36.225     1.745     0.200
    36.254     1.219     0.200
    36.367     0.121     0.200
    36.300     1.395     0.200
    36.307     1.805     0.200
    36.508     2.544     0.200
    36.590     1.579     0.200
    36.600     2.385     0.200
    37.032     0.788     0.200
    37.081     0.582     0.200
    37.040     1.534     0.200
    37.115     1.226     0.200
    37.147     1.646     0.200
    37.245     1.461     0.200
    37.308     1.374     0.200
    37.679     2.130     0.200
    37.679     2.357     0.200
    37.949     1.057     0.200
    37.949     1.506     0.200
    38.087     0.912     0.200
    38.087     1.301     0.200
    38.176    -0.169     0.200
    38.176    -0.489     0.200
    38.402     1.181     0.200
    38.447     2.139     0.200
    38.659     0.406     0.200
    38.747     0.692     0.200
    38.778     1.494     0.200
    39.197     2.692     0.200
    39.306    -0.168     0.200
    39.415     1.649     0.200
    39.415     2.415     0.200
    39.542     1.742     0.200
    40.185     0.211     0.200
    40.185     1.166     0.200
    40.386     1.159     0.200
    40.386     1.907     0.200
    40.460     1.792     0.200
    40.508    -0.696     0.200
    40.508    -0.017     0.200
    40.759    -0.172     0.200
    40.759    -0.025     0.200
    40.858     1.241     0.200
    40.858     0.525     0.200
    41.135     1.691     0.200
    41.341     1.546     0.200
    41.426     1.970     0.200
    41.534    -0.156     0.200
    41.699     0.006     0.200
    41.887     1.289     0.200
    41.887     0.639     0.200
    41.969    -0.082     0.200
    41.969     0.811     0.200
    42.129     0.425     0.200
    42.919     0.315     0.200
    43.105    -0.005     0.200
    43.616     0.674     0.200
    43.616     0.920     0.200
    43.656     0.680     0.200
    43.656     1.137     0.200
    43.752     0.008     0.200
    43.858     1.845     0.200
    43.858     0.790     0.200
    44.592    -0.732     0.200
    45.374     0.836     0.200
    45.374     0.022     0.200
    45.697    -1.899     0.200
    45.838    -0.149     0.200
    46.079     0.596     0.200
    46.078    -0.350     0.200
    46.242    -0.118     0.200
    46.425    -1.175     0.200
    46.421     0.565     0.200
    46.610     1.583     0.200
    46.611     2.069     0.200
    46.611     1.549     0.200
    46.696    -0.766     0.200
    46.723    -0.435     0.200
    46.723    -0.660     0.200
    47.319    -1.293     0.200
    47.600    -0.623     0.200
    47.603    -1.016     0.200
    47.897    -0.405     0.200
    47.925     0.877     0.200
    47.925     0.593     0.200
    48.042    -0.209     0.200
    48.141    -1.187     0.200
    48.134     0.814     0.200
    48.222    -0.806     0.200
    48.483     0.311     0.200
    48.713    -1.010     0.200
    48.788     0.108     0.200
    48.948    -0.530     0.200
    49.202    -1.245     0.200
    49.790     0.798     0.200
    49.947    -1.176     0.200
    50.417    -1.556     0.200
    50.404    -0.087     0.200
    50.608    -0.309     0.200
    50.581    -0.899     0.200
    50.739    -0.641     0.200
    50.737    -0.045     0.200
    50.837    -0.966     0.200
    50.879     0.148     0.200
    50.879    -0.354     0.200
    51.302    -0.447     0.200
    51.374    -1.451     0.200
    51.278     1.114     0.200
    51.278     0.604     0.200
    51.857    -1.190     0.200
    52.535    -0.212     0.200
    52.715    -0.685     0.200
    52.813    -0.522     0.200
    52.903    -0.562     0.200
    53.484    -0.389     0.200
    53.970    -0.773     0.200
    54.636    -0.393     0.200
    54.678    -0.886     0.200
    54.724    -0.231     0.200
    55.044    -1.075     0.200
    55.054     0.463     0.200
    55.054     0.594     0.200
    55.366    -0.911     0.200
    57.604     1.523     0.200
    58.511     1.174     0.200
    59.271     0.106     0.200
    59.271    -0.329     0.200
    59.271    -0.073     0.200
    59.271     0.097     0.200
    60.262    -0.019     0.200
    61.791    -1.087     0.200
    61.846     0.547     0.200
    63.470    -1.005     0.200
    63.650    -0.767     0.200
    63.650    -0.642     0.200
    63.949    -0.006     0.200
    64.087     0.113     0.200
    64.087    -0.536     0.200
    64.196    -0.001     0.200
    64.119     0.254     0.200
    64.547    -0.379     0.200
    64.547    -0.748     0.200
    64.537     0.217     0.200
    64.672    -0.098     0.200
    64.672    -0.867     0.200
    64.792    -0.786     0.200
    65.151     1.121     0.200
    66.082    -0.676     0.200
    66.082    -0.385     0.200
    66.082    -0.586     0.200
    66.082    -0.385     0.200
    66.250    -0.676     0.200
    66.415    -0.480     0.200
    67.353    -0.526     0.200
    68.346    -0.172     0.200
    69.183    -0.340     0.200
    69.270     0.815     0.200
    69.465    -0.445     0.200
    69.480     0.224     0.200
    70.245    -0.479     0.200
    70.436    -1.271     0.200
    70.436    -1.146     0.200
    71.271     1.286     0.200
    72.105     0.309     0.200
    72.492     0.729     0.200
    72.492     0.879     0.200
    73.457    -0.152     0.200
    73.439     0.285     0.200
    73.439     0.006     0.200
    73.852     1.830     0.200
    74.099    -0.910     0.200
    74.099    -1.131     0.200
    74.099    -1.010     0.200
    74.561     0.300     0.200
    74.851     0.722     0.200
    75.660     0.373     0.200
    75.951    -0.508     0.200
    75.951    -0.201     0.200
    76.056     0.032     0.200
    76.563     1.277     0.200
    77.175     0.600     0.200
    77.309     0.002     0.200
    77.878     0.315     0.200
    79.609     0.456     0.200
    79.609     0.755     0.200
    80.169     1.127     0.200
    80.368     0.655     0.200
    80.548     1.186     0.200
    81.029     0.621     0.200
    81.040     0.962     0.200
    81.054     0.786     0.200
    81.055     0.782     0.200
    81.701     0.760     0.200
    81.925     0.756     0.200
    81.896     0.944     0.200
    81.896     1.218     0.200
    82.867     0.791     0.200
    84.703     0.683     0.200
    84.703     0.880     0.200
    84.703     0.681     0.200
    93.989    -0.021     0.200
    93.989     0.354     0.200
    97.346     1.447     0.200
    47.216     0.868     0.200
    14.263     6.264     0.200
    16.990     1.276     0.200
    20.237     0.036     0.200
    20.485    -2.590     0.200
    20.485    -1.273     0.200
    21.389    -1.675     0.200
    21.389    -0.093     0.200
    23.092    -0.794     0.200
    24.827     0.037     0.200
    25.320     1.513     0.200
    25.320     0.255     0.200
    25.320     0.927     0.200
    25.320     0.372     0.200
    25.443     0.196     0.200
    25.491    -0.249     0.200
    25.491    -0.898     0.200
    25.900    -0.124     0.200
    25.972     0.110     0.200
    26.108     0.098     0.200
    26.191     1.656     0.200
    26.191     0.895     0.200
    26.342     1.537     0.200
    26.389     1.956     0.200
    26.843     1.279     0.200
    26.965     1.667     0.200
    27.075     2.430     0.200
    27.600     1.209     0.200
    28.076     0.622     0.200
    28.781     0.049     0.200
    30.040     1.094     0.200
    30.476    -0.225     0.200
    30.477     0.464     0.200
    30.803     0.351     0.200
    31.504     1.875     0.200
    31.797     2.276     0.200
    32.125     1.983     0.200
    32.422     0.947     0.200
    33.346     0.712     0.200
    33.342     1.268     0.200
    33.350     1.360     0.200
    33.303    -0.070     0.200
    33.377     1.398     0.200
    33.593     0.810     0.200
    33.631     1.500     0.200
    33.723     0.661     0.200
    33.724     1.651     0.200
    33.749     0.445     0.200
    33.979     2.048     0.200
    33.990     1.821     0.200
    34.166     0.077     0.200
    34.310     0.923     0.200
    34.597     1.607     0.200
    35.266     1.453     0.200
    35.513     0.753     0.200
    35.522     1.562     0.200
    35.919     1.052     0.200
    35.859    -0.484     0.200
    35.987     0.464     0.200
    35.987     1.733     0.200
    35.987     0.995     0.200
    36.203     1.514     0.200
    36.232     1.557     0.200
    36.232     0.842     0.200
    36.332     1.417     0.200
    36.384     1.022     0.200
    36.671     1.060     0.200
    36.910     0.214     0.200
    36.959     1.639     0.200
    36.990     1.606     0.200
    37.103     0.865     0.200
    37.714     1.408     0.200
    37.913     0.644     0.200
    38.021     0.137     0.200
    38.021     0.406     0.200
    38.089     0.719     0.200
    38.638    -0.093     0.200
    38.647     1.396     0.200
    38.747     1.158     0.200
    39.142     0.172     0.200
    39.166     1.234     0.200
    39.253    -0.495     0.200
    39.395     2.083     0.200
    39.612    -0.054     0.200
    40.139     0.782     0.200
    40.394     0.018     0.200
    40.394    -0.111     0.200
    40.438     1.371     0.200
    40.440     2.022     0.200
    40.591     0.162     0.200
    40.591     0.393     0.200
    40.591     0.607     0.200
    40.762    -0.013     0.200
    40.865     1.415     0.200
    40.865     0.837     0.200
    41.048     0.636     0.200
    41.324     2.383     0.200
    41.376     0.644     0.200
    41.556     0.295     0.200
    41.674     0.673     0.200
    41.908     2.027     0.200
    41.908     0.910     0.200
    41.919     2.282     0.200
    41.919     1.626     0.200
    41.997     0.800     0.200
    42.704     0.794     0.200
    42.822     0.945     0.200
    42.951     0.289     0.200
    42.999     0.330     0.200
    43.476     0.361     0.200
    43.594     0.106     0.200
    43.610     0.608     0.200
    43.647     1.175     0.200
    43.647     0.491     0.200
    43.880     1.982     0.200
    43.974     0.234     0.200
    44.216     0.573     0.200
    44.454    -0.347     0.200
    44.846     0.385     0.200
    45.336     1.300     0.200
    45.410     0.507     0.200
    45.456     0.413     0.200
    45.742     0.152     0.200
    46.180     0.148     0.200
    46.106     0.200     0.200
    46.106     0.454     0.200
    46.106     0.782     0.200
    46.251    -0.921     0.200
    46.395    -0.513     0.200
    46.480    -1.256     0.200
    46.480    -0.780     0.200
    46.571    -0.157     0.200
    46.571     0.269     0.200
    46.571    -0.587     0.200
    46.596    -0.375     0.200
    46.636     1.429     0.200
    46.636     0.029     0.200
    46.637     1.415     0.200
    46.637     0.165     0.200
    47.075     0.059     0.200
    47.219    -0.833     0.200
    47.371     0.648     0.200
    47.728    -0.090     0.200
    47.907     0.259     0.200
    47.907    -0.433     0.200
    47.921     0.125     0.200
    48.332    -0.769     0.200
    48.417     0.405     0.200
    48.427    -0.470     0.200
    48.499     0.403     0.200
    48.588     0.114     0.200
    49.059    -0.856     0.200
    49.129    -0.816     0.200
    49.468    -0.689     0.200
    49.806    -0.762     0.200
    49.806    -0.426     0.200
    49.857    -0.680     0.200
    50.265    -1.106     0.200
    50.291     0.326     0.200
    50.475     0.474     0.200
    50.503     0.258     0.200
    50.503    -0.254     0.200
    50.551    -0.458     0.200
    50.791    -0.994     0.200
    50.907    -0.024     0.200
    50.912     0.332     0.200
    50.917     0.170     0.200
    50.970    -0.518     0.200
    51.024    -0.167     0.200
    51.096     0.224     0.200
    51.150    -1.418     0.200
    51.214    -1.777     0.200
    51.245     1.031     0.200
    51.349     0.257     0.200
    51.371    -0.768     0.200
    51.371    -0.225     0.200
    51.528    -0.599     0.200
    51.532    -0.593     0.200
    51.540     0.160     0.200
    51.646    -1.131     0.200
    51.658    -0.291     0.200
    51.668     0.342     0.200
    51.712    -0.112     0.200
    51.762    -0.131     0.200
    51.771    -0.073     0.200
    51.838     0.365     0.200
    51.916    -0.119     0.200
    52.163    -0.217     0.200
    52.166     0.430     0.200
    52.177    -0.041     0.200
    52.284    -0.460     0.200
    52.284    -0.269     0.200
    52.319    -0.517     0.200
    52.373    -0.028     0.200
    52.373    -0.442     0.200
    52.497     0.080     0.200
    52.585     0.104     0.200
    52.586     0.291     0.200
    52.586    -0.791     0.200
    52.621     0.326     0.200
    52.621    -0.057     0.200
    52.631     0.211     0.200
    52.680     0.003     0.200
    52.726    -0.553     0.200
    52.726    -0.049     0.200
    52.781    -0.238     0.200
    52.955    -0.630     0.200
    52.984     0.472     0.200
    53.071    -0.600     0.200
    53.071     0.188     0.200
    53.095     0.752     0.200
    53.120     0.621     0.200
    53.192     0.205     0.200
    53.204    -0.939     0.200
    53.204    -0.044     0.200
    53.234    -1.130     0.200
    53.265    -1.126     0.200
    53.271    -0.338     0.200
    53.434     0.102     0.200
    53.485    -0.104     0.200
    53.557     0.380     0.200
    53.582     0.175     0.200
    53.631    -0.173     0.200
    53.823    -0.208     0.200
    53.889    -0.811     0.200
    53.900     0.402     0.200
    54.061    -0.004     0.200
    54.079    -0.560     0.200
    54.142     0.044     0.200
    54.159    -0.736     0.200
    54.214     0.307     0.200
    54.233     0.504     0.200
    54.380     0.263     0.200
    54.431    -0.734     0.200
    54.497    -0.061     0.200
    54.562    -1.011     0.200
    54.597    -0.028     0.200
    54.542     0.345     0.200
    54.694    -0.905     0.200
    54.807    -0.486     0.200
    54.836    -0.183     0.200
    54.932    -1.144     0.200
    54.870     0.691     0.200
    54.870    -0.199     0.200
    54.996    -0.419     0.200
    54.996    -0.200     0.200
    54.976    -1.006     0.200
    55.513    -0.290     0.200
    55.559     0.242     0.200
    55.575     0.036     0.200
    55.610    -0.543     0.200
    55.885    -0.466     0.200
    55.885     0.198     0.200
    58.993    -0.492     0.200
    58.993     0.660     0.200
    60.215     1.740     0.200
    61.480     0.732     0.200
    62.862    -0.827     0.200
    63.082    -1.269     0.200
    63.256    -0.546     0.200
    63.256    -0.722     0.200
    63.801    -0.566     0.200
    63.801     0.656     0.200
    63.910    -0.136     0.200
    64.013     0.765     0.200
    64.202    -0.559     0.200
    64.202     0.121     0.200
    64.359    -0.038     0.200
    64.359    -0.608     0.200
    64.366     0.946     0.200
    65.819    -0.300     0.200
    65.819    -0.187     0.200
    65.819    -0.187     0.200
    67.453    -0.079     0.200
    69.300     2.223     0.200
    69.907     0.180     0.200
    70.075    -0.450     0.200
    70.551     0.041     0.200
    71.578     1.115     0.200
    72.215     1.993     0.200
    73.148     1.051     0.200
    73.546     0.422     0.200
    73.714    -0.809     0.200
    73.714    -0.281     0.200
    73.743     2.242     0.200
    74.168     0.958     0.200
    74.458     0.669     0.200
    75.266     0.099     0.200
    75.266     1.299     0.200
    75.444     1.678     0.200
    75.558     0.574     0.200
    75.977     2.032     0.200
    76.091     0.780     0.200
    76.305    -0.014     0.200
    76.347     1.728     0.200
    76.572     1.289     0.200
    76.705     1.097     0.200
    76.725     0.750     0.200
    76.857     1.422     0.200
    77.009     1.458     0.200
    77.023     1.492     0.200
    77.300     1.731     0.200
    77.581     1.143     0.200
    77.764     1.546     0.200
    77.786     1.325     0.200
    77.931     1.393     0.200
    78.777     1.088     0.200
    79.056     0.628     0.200
    79.245     1.641     0.200
    79.245     1.488     0.200
    79.365     1.335     0.200
    79.881     1.734     0.200
    80.076     1.978     0.200
    80.889     0.722     0.200
    81.063     1.587     0.200
    81.614     0.666     0.200
    81.604     1.243     0.200
    81.803     1.017     0.200
    81.803     1.677     0.200
    81.803     1.267     0.200
    82.482     1.188     0.200
    82.915    -0.932     0.200
    83.040     1.111     0.200
    83.307     1.631     0.200
    84.325     1.227     0.200
    84.325     1.526     0.200
    84.325     1.725     0.200
    94.211     1.051     0.200
    94.224     0.314     0.200
    94.224     0.189     0.200
    97.591     0.010     0.200
    15.328     3.285     0.200
    20.962    -0.846     0.200
    20.962    -1.391     0.200
    23.464    -0.881     0.200
    26.182     0.668     0.200
    28.881     0.271     0.200
    33.800     1.568     0.200
    46.626     1.128     0.200
    55.492    -1.816     0.200
    63.596    -1.806     0.200
    63.781    -0.915     0.200
    67.967    -0.894     0.200
    74.222    -1.654     0.200
    83.000    -0.618     0.200
    17.825    -0.025     0.200
    21.301    -0.370     0.200
    23.703     1.303     0.200
    25.454    -0.394     0.200
    26.305     1.283     0.200
    26.912     2.776     0.200
    28.209     0.705     0.200
    31.634     2.777     0.200
    31.822     1.218     0.200
    33.791     1.732     0.200
    35.179     2.644     0.200
    36.155     1.263     0.200
    40.286     0.728     0.200
    40.822     1.421     0.200
    46.548     1.659     0.200
    46.548     1.159     0.200
    50.725    -0.612     0.200
    51.357     0.703     0.200
    55.337     0.558     0.200
    59.675    -0.606     0.200
    64.190     0.334     0.200
    64.609     0.091     0.200
    65.034    -0.310     0.200
    65.119     0.167     0.200
    65.216    -0.363     0.200
    66.466     0.146     0.200
    68.364     0.492     0.200
    70.724     0.556     0.200
    72.894     1.239     0.200
    74.033     3.599     0.200
    74.632    -0.332     0.200
    80.118     0.837     0.200
    82.053     1.217     0.200
    82.382     1.122     0.200
    83.386     0.292     0.200
    85.229     0.444     0.200
    93.692     0.114     0.200
    97.037     0.350     0.200
    17.115     1.868     0.200
    17.115     1.657     0.200
    17.197     1.397     0.200
    17.848     0.814     0.200
    18.253    -0.723     0.200
    18.816    -0.483     0.200
    18.816    -2.655     0.200
    19.171    -0.170     0.200
    20.932    -0.387     0.200
    20.932     0.167     0.200
    22.309    -0.479     0.200
    22.309    -0.237     0.200
    23.213    -0.516     0.200
    23.916    -0.026     0.200
    24.274    -1.229     0.200
    24.274     0.591     0.200
    24.274    -1.112     0.200
    24.788     0.403     0.200
    24.788    -0.722     0.200
    24.773     0.686     0.200
    25.717    -0.708     0.200
    25.717    -0.934     0.200
    26.119    -1.095     0.200
    26.614    -0.539     0.200
    26.866    -0.021     0.200
    26.866    -0.130     0.200
    26.866     2.487     0.200
    26.866     0.690     0.200
    27.203     1.624     0.200
    27.203     0.327     0.200
    28.035     2.383     0.200
    29.530     1.928     0.200
    29.788     0.727     0.200
    30.585     0.289     0.200
    31.129     1.580     0.200
    31.328     1.709     0.200
    31.619     1.276     0.200
    31.804     1.448     0.200
    32.264    -0.206     0.200
    32.321     2.052     0.200
    32.845    -0.470     0.200
    32.940     0.340     0.200
    33.098     0.637     0.200
    33.274     1.285     0.200
    33.829     1.767     0.200
    33.846     1.647     0.200
    33.945     0.787     0.200
    33.945     1.920     0.200
    33.966     1.697     0.200
    34.120    -1.997     0.200
    34.120    -0.075     0.200
    34.184     0.671     0.200
    34.158     0.896     0.200
    34.346     1.444     0.200
    34.346     1.569     0.200
    34.356     1.412     0.200
    34.436     1.651     0.200
    34.504     1.416     0.200
    34.520     1.734     0.200
    34.582     0.752     0.200
    34.582     1.041     0.200
    34.582     1.697     0.200
    34.655     1.846     0.200
    34.656     1.391     0.200
    34.739     0.993     0.200
    34.994     1.675     0.200
    35.241     1.302     0.200
    35.364     1.432     0.200
    35.971     1.737     0.200
    36.179    -2.066     0.200
    36.388     0.978     0.200
    36.763     0.993     0.200
    36.787     0.934     0.200
    36.787     1.450     0.200
    36.794     1.117     0.200
    37.068     1.151     0.200
    37.081    -0.163     0.200
    37.081     1.704     0.200
    37.081     1.079     0.200
    37.135     1.422     0.200
    37.325     0.992     0.200
    37.339     1.020     0.200
    37.521     1.738     0.200
    37.521     1.238     0.200
    37.603     1.854     0.200
    37.673    -0.701     0.200
    37.603     2.212     0.200
    37.650     1.461     0.200
    37.801    -0.142     0.200
    37.934     0.897     0.200
    38.123     0.997     0.200
    38.337     2.024     0.200
    38.318     0.008     0.200
    38.318    -0.235     0.200
    38.409    -1.107     0.200
    38.409    -0.466     0.200
    38.848     0.612     0.200
    39.374     0.958     0.200
    39.374     0.403     0.200
    39.466     1.495     0.200
    39.570     1.686     0.200
    39.645     1.355     0.200
    40.077     1.635     0.200
    40.247     2.105     0.200
    40.247     1.042     0.200
    40.992    -1.097     0.200
    41.044    -1.231     0.200
    41.044    -0.630     0.200
    40.977     0.252     0.200
    40.977     1.205     0.200
    41.096     1.659     0.200
    41.296     1.600     0.200
    41.605     0.966     0.200
    41.605     0.326     0.200
    41.605    -0.729     0.200
    41.606     0.567     0.200
    41.606    -0.011     0.200
    41.989     1.057     0.200
    41.989     0.463     0.200
    42.019     2.734     0.200
    42.080     0.814     0.200
    42.549     1.660     0.200
    42.549     1.394     0.200
    42.800    -1.869     0.200
    42.920     1.422     0.200
    42.920     1.196     0.200
    43.092     0.778     0.200
    43.873    -2.084     0.200
    44.219    -0.005     0.200
    44.382     0.064     0.200
    44.451     1.650     0.200
    44.451     1.212     0.200
    44.450     0.327     0.200
    44.450     1.147     0.200
    44.919     0.353     0.200
    45.102    -1.546     0.200
    45.145     0.998     0.200
    45.262     0.391     0.200
    45.262    -0.008     0.200
    45.261    -0.285     0.200
    45.363     0.488     0.200
    45.481    -0.744     0.200
    45.391     0.223     0.200
    45.738     0.292     0.200
    45.746    -0.268     0.200
    45.877     0.249     0.200
    46.001    -0.124     0.200
    46.150     0.634     0.200
    46.256     0.766     0.200
    46.256     0.391     0.200
    46.408     0.842     0.200
    46.431    -0.954     0.200
    46.783    -0.865     0.200
    46.783     1.307     0.200
    46.859     0.835     0.200
    46.921     0.351     0.200
    46.962     0.136     0.200
    47.033    -0.048     0.200
    47.195    -0.212     0.200
    47.245     0.822     0.200
    47.245     0.345     0.200
    47.257     1.206     0.200
    47.290     1.179     0.200
    47.290     1.197     0.200
    47.386    -0.049     0.200
    47.386    -0.236     0.200
    47.624    -1.273     0.200
    47.654    -0.547     0.200
    47.785    -0.598     0.200
    47.821     0.201     0.200
    47.821    -0.456     0.200
    47.983    -0.620     0.200
    48.146     0.753     0.200
    48.157     0.778     0.200
    48.157     0.614     0.200
    48.362     0.365     0.200
    48.704     0.575     0.200
    48.704    -0.355     0.200
    48.984     0.870     0.200
    49.189     0.345     0.200
    49.313     0.649     0.200
    49.444     0.157     0.200
    49.444     0.485     0.200
    49.644    -0.306     0.200
    49.646    -0.692     0.200
    49.761     0.161     0.200
    49.761     0.934     0.200
    49.727    -0.285     0.200
    49.784     0.179     0.200
    50.118     0.327     0.200
    50.153     0.286     0.200
    50.369    -1.072     0.200
    50.467    -1.042     0.200
    50.536     1.299     0.200
    50.536    -0.506     0.200
    50.653     0.098     0.200
    50.794     0.251     0.200
    51.105    -0.478     0.200
    51.105    -0.971     0.200
    51.107    -0.901     0.200
    51.422    -0.255     0.200
    51.422     1.667     0.200
    51.692     0.177     0.200
    51.606    -1.141     0.200
    51.678    -0.218     0.200
    51.950     0.459     0.200
    51.901    -0.301     0.200
    51.933     0.433     0.200
    52.065    -0.286     0.200
    52.188    -0.254     0.200
    52.229    -0.162     0.200
    52.326     0.135     0.200
    52.380     0.351     0.200
    52.491    -1.578     0.200
    52.539     0.846     0.200
    52.581    -0.701     0.200
    52.590    -0.022     0.200
    52.694    -1.609     0.200
    52.800     0.552     0.200
    52.954    -0.185     0.200
    53.051    -0.366     0.200
    53.046     0.226     0.200
    53.064    -0.447     0.200
    53.090    -0.386     0.200
    53.092     0.203     0.200
    53.174    -0.491     0.200
    53.254     0.191     0.200
    53.289     0.076     0.200
    53.442    -0.102     0.200
    53.617    -0.923     0.200
    53.666    -0.064     0.200
    53.785     0.437     0.200
    53.806     0.480     0.200
    53.844    -1.153     0.200
    54.007     0.231     0.200
    54.074     0.212     0.200
    54.092     0.559     0.200
    54.092    -0.324     0.200
    54.107    -1.117     0.200
    54.147    -0.540     0.200
    54.147     0.303     0.200
    54.147    -0.282     0.200
    54.301    -0.007     0.200
    54.314    -0.197     0.200
    54.324     0.140     0.200
    54.358    -1.062     0.200
    54.386    -0.333     0.200
    54.502     0.411     0.200
    54.666    -0.966     0.200
    54.666     0.292     0.200
    54.594     0.824     0.200
    54.690    -0.175     0.200
    54.817     0.299     0.200
    54.816    -0.055     0.200
    54.816    -0.493     0.200
    54.849     0.216     0.200
    54.884    -0.003     0.200
    54.883    -0.051     0.200
    55.006     0.313     0.200
    55.006     0.149     0.200
    54.979     0.206     0.200
    55.070    -1.278     0.200
    55.112     0.440     0.200
    55.212    -1.122     0.200
    55.233    -0.366     0.200
    55.420     0.151     0.200
    55.445    -1.260     0.200
    55.445    -0.299     0.200
    55.497    -0.947     0.200
    55.663    -0.451     0.200
    55.674    -1.117     0.200
    55.757     0.759     0.200
    55.883    -0.617     0.200
    55.944    -1.438     0.200
    55.945    -0.219     0.200
    56.040     0.477     0.200
    56.060    -0.048     0.200
    56.104    -0.804     0.200
    56.130    -0.832     0.200
    56.231    -1.000     0.200
    56.222     0.271     0.200
    56.222    -0.674     0.200
    56.482     0.484     0.200
    56.515     0.054     0.200
    56.561    -1.358     0.200
    56.748     0.321     0.200
    56.765    -0.865     0.200
    56.920     0.142     0.200
    57.323     0.788     0.200
    58.108     0.578     0.200
    58.313     0.044     0.200
    58.237    -0.381     0.200
    58.696     0.204     0.200
    59.121     1.024     0.200
    59.522     0.448     0.200
    59.687    -0.187     0.200
    59.654    -0.680     0.200
    59.654    -0.336     0.200
    59.654    -0.055     0.200
    61.427     0.443     0.200
    62.008     0.633     0.200
    62.741    -2.663     0.200
    63.371     0.052     0.200
    63.753    -0.075     0.200
    63.791     0.306     0.200
    64.427     0.005     0.200
    64.470     0.026     0.200
    64.505    -0.663     0.200
    64.505    -0.006     0.200
    64.694    -0.035     0.200
    64.606    -0.113     0.200
    64.606    -0.535     0.200
    64.648    -0.120     0.200
    64.911     0.648     0.200
    64.906     0.379     0.200
    64.906     0.481     0.200
    65.083    -0.116     0.200
    65.122     0.310     0.200
    65.242    -1.194     0.200
    65.242     0.400     0.200
    65.308    -1.506     0.200
    65.308    -0.131     0.200
    65.884     0.190     0.200
    65.982     0.395     0.200
    66.220     0.663     0.200
    66.385    -0.704     0.200
    66.385    -0.563     0.200
    66.385    -0.337     0.200
    66.385    -0.642     0.200
    66.495    -0.699     0.200
    66.591     0.619     0.200
    67.152    -0.576     0.200
    67.404     0.203     0.200
    67.566     0.398     0.200
    69.198     1.132     0.200
    69.402     0.857     0.200
    69.473    -0.776     0.200
    69.587     0.417     0.200
    70.199    -0.400     0.200
    70.199     0.053     0.200
    70.264     0.261     0.200
    70.524    -0.723     0.200
    70.567     0.656     0.200
    70.615     0.474     0.200
    70.698     0.797     0.200
    70.819     0.772     0.200
    70.949     0.092     0.200
    71.122    -0.166     0.200
    71.305    -0.325     0.200
    71.476     0.472     0.200
    71.557     0.202     0.200
    72.209     1.142     0.200
    72.318     0.909     0.200
    72.406    -0.976     0.200
    72.457     1.025     0.200
    72.546     1.088     0.200
    72.679     1.162     0.200
    72.864     1.066     0.200
    72.864     0.605     0.200
    72.864     1.199     0.200
    73.107     1.120     0.200
    73.211     1.979     0.200
    73.283     0.221     0.200
    73.403    -0.988     0.200
    73.493     0.179     0.200
    73.598     1.703     0.200
    73.735    -0.742     0.200
    73.883    -0.664     0.200
    74.051    -0.317     0.200
    74.040     0.175     0.200
    74.711    -0.550     0.200
    74.893     0.679     0.200
    74.919     0.867     0.200
    74.953     0.669     0.200
    75.093    -0.316     0.200
    75.101    -0.061     0.200
    75.188    -0.153     0.200
    75.186     1.061     0.200
    75.292     0.801     0.200
    75.293     0.417     0.200
    75.555     1.413     0.200
    75.577     0.887     0.200
    75.757     1.253     0.200
    75.786     1.090     0.200
    76.071     1.259     0.200
    76.093     1.040     0.200
    76.410     1.038     0.200
    76.452     1.698     0.200
    76.384     0.887     0.200
    76.384     0.785     0.200
    76.759     0.569     0.200
    76.801     1.332     0.200
    76.835     1.389     0.200
    76.835     0.585     0.200
    76.835     0.936     0.200
    76.911     1.505     0.200
    77.076     0.576     0.200
    77.323     0.292     0.200
    77.202     0.972     0.200
    77.229     1.624     0.200
    77.252     0.996     0.200
    77.271     0.982     0.200
    77.382     0.244     0.200
    77.531     1.230     0.200
    77.684     0.981     0.200
    77.698     1.005     0.200
    77.784     1.322     0.200
    77.799    -0.104     0.200
    77.880     1.303     0.200
    77.958     1.752     0.200
    78.028     1.145     0.200
    78.264     1.853     0.200
    78.264     1.571     0.200
    78.440    -0.161     0.200
    78.464     1.428     0.200
    78.459     0.986     0.200
    78.469     0.690     0.200
    78.810     1.649     0.200
    78.982    -0.298     0.200
    78.982     0.522     0.200
    78.992     1.843     0.200
    79.000     1.673     0.200
    79.028     1.603     0.200
    79.041     0.364     0.200
    79.181     1.014     0.200
    79.268     1.936     0.200
    79.320     0.662     0.200
    79.368     1.400     0.200
    79.516    -0.010     0.200
    79.411     1.116     0.200
    79.421     1.373     0.200
    79.790     0.207     0.200
    79.963     1.635     0.200
    79.962     1.094     0.200
    79.962     0.781     0.200
    80.134     3.238     0.200
    80.108     1.582     0.200
    80.168     1.069     0.200
    80.195     1.668     0.200
    80.311     1.418     0.200
    80.313     0.947     0.200
    80.313     0.205     0.200
    80.416     1.321     0.200
    80.412     0.961     0.200
    80.514     1.000     0.200
    80.498     0.710     0.200
    80.498     1.585     0.200
    80.529     1.113     0.200
    80.556     1.091     0.200
    80.655     0.642     0.200
    80.650     1.368     0.200
    80.735     1.534     0.200
    80.758     0.791     0.200
    80.760     1.335     0.200
    80.902     0.522     0.200
    81.024     0.374     0.200
    81.031     0.338     0.200
    80.994     1.128     0.200
    81.009     1.311     0.200
    81.061     0.323     0.200
    81.137     0.668     0.200
    81.154     0.879     0.200
    81.236    -1.639     0.200
    81.140    -1.246     0.200
    81.237    -0.564     0.200
    81.212     0.467     0.200
    81.280     0.773     0.200
    81.471    -0.075     0.200
    81.471     0.199     0.200
    81.390     0.640     0.200
    81.459     0.958     0.200
    81.561     0.370     0.200
    81.679     1.497     0.200
    81.761     1.065     0.200
    81.835     0.979     0.200
    82.131     1.119     0.200
    82.316    -0.043     0.200
    82.529     1.095     0.200
    82.574     1.307     0.200
    82.851     1.969     0.200
    82.867     1.487     0.200
    82.997     1.812     0.200
    83.418     1.435     0.200
    83.448     1.884     0.200
    83.550     0.367     0.200
    83.639     0.576     0.200
    83.874     1.800     0.200
    84.008    -1.677     0.200
    83.999     1.366     0.200
    84.190     1.488     0.200
    84.154    -1.024     0.200
    84.272     0.801     0.200
    84.329     1.586     0.200
    84.435     1.447     0.200
    85.112     2.144     0.200
    85.713     0.639     0.200
    85.713     0.778     0.200
    85.713     1.043     0.200
    86.255     0.764     0.200
    87.081    -0.426     0.200
    88.302    -0.699     0.200
    88.302     0.184     0.200
    90.786     1.775     0.200
    92.615    -0.322     0.200
    92.629    -0.978     0.200
    92.747    -0.897     0.200
    95.970    -0.868     0.200
    99.523     0.706     0.200
    18.375    -1.563     0.200
    18.576    -0.622     0.200
    18.920    -1.859     0.200
    18.920    -1.422     0.200
    20.544     0.800     0.200
    20.505    -0.305     0.200
    20.505     0.531     0.200
    22.431    -1.857     0.200
    22.431    -1.388     0.200
    23.277    -2.686     0.200
    23.277    -2.186     0.200
    23.757     0.930     0.200
    24.271     0.704     0.200
    24.271     1.563     0.200
    24.271     0.641     0.200
    24.271     0.368     0.200
    25.226    -0.982     0.200
    26.356    -1.285     0.200
    26.356     0.793     0.200
    31.819     1.852     0.200
    32.327    -1.266     0.200
    32.835     0.408     0.200
    32.835     2.439     0.200
    33.077     1.938     0.200
    33.709    -1.219     0.200
    33.709    -1.922     0.200
    33.709    -1.493     0.200
    34.331    -0.204     0.200
    34.345     1.423     0.200
    34.361     1.512     0.200
    34.455     1.581     0.200
    34.455     2.041     0.200
    34.846     1.299     0.200
    34.952     1.683     0.200
    35.034     1.534     0.200
    35.137     0.239     0.200
    35.329     1.624     0.200
    35.694    -1.080     0.200
    35.694    -1.448     0.200
    36.102     0.642     0.200
    36.905     2.634     0.200
    37.154    -1.013     0.200
    37.558     0.592     0.200
    37.651     1.940     0.200
    37.694     2.091     0.200
    37.842     2.172     0.200
    37.857     2.581     0.200
    38.301     2.567     0.200
    38.519     1.729     0.200
    38.708     0.407     0.200
    38.847     2.049     0.200
    38.847     1.753     0.200
    39.312     2.241     0.200
    39.961     2.247     0.200
    40.480    -0.107     0.200
    40.525     0.428     0.200
    40.594     1.955     0.200
    40.738     1.061     0.200
    42.106     2.438     0.200
    42.382     0.921     0.200
    42.283    -0.908     0.200
    43.058     2.129     0.200
    43.058     2.402     0.200
    43.355    -0.812     0.200
    43.719     1.016     0.200
    44.306     0.028     0.200
    44.444     0.248     0.200
    44.617    -1.032     0.200
    44.765     0.123     0.200
    44.765     1.212     0.200
    44.765     1.486     0.200
    44.765     1.996     0.200
    44.846     1.345     0.200
    45.913     1.837     0.200
    46.740     1.021     0.200
    46.740     0.904     0.200
    47.009    -0.196     0.200
    47.009    -0.470     0.200
    47.009    -0.024     0.200
    47.261    -0.280     0.200
    47.265    -0.427     0.200
    47.702    -1.120     0.200
    47.798     0.904     0.200
    47.798     2.054     0.200
    48.245    -0.225     0.200
    48.245     0.111     0.200
    48.252     0.564     0.200
    48.921    -0.367     0.200
    49.263     1.894     0.200
    49.618    -0.714     0.200
    49.612     0.155     0.200
    50.140     0.576     0.200
    50.140     0.552     0.200
    50.786    -0.989     0.200
    52.124     0.020     0.200
    52.124     0.489     0.200
    52.359     0.177     0.200
    52.359     0.606     0.200
    52.283     1.685     0.200
    52.646    -0.061     0.200
    52.794    -0.512     0.200
    53.125    -0.232     0.200
    53.479    -0.267     0.200
    54.163     0.612     0.200
    54.197    -1.101     0.200
    54.455    -0.404     0.200
    54.464    -0.294     0.200
    54.535    -0.486     0.200
    54.535    -0.384     0.200
    54.503     1.035     0.200
    54.503     0.777     0.200
    55.248    -0.961     0.200
    55.927    -0.727     0.200
    56.049    -1.211     0.200
    56.143     1.026     0.200
    56.307    -0.447     0.200
    56.316    -0.867     0.200
    56.316    -1.312     0.200
    56.316    -1.203     0.200
    56.380     0.419     0.200
    56.531    -0.251     0.200
    56.893    -0.594     0.200
    56.806     1.131     0.200
    57.324    -0.031     0.200
    57.501    -0.695     0.200
    57.588     1.296     0.200
    57.984    -0.991     0.200
    58.535    -0.742     0.200
    59.211    -0.979     0.200
    59.211    -0.034     0.200
    59.211    -0.698     0.200
    59.171     0.548     0.200
    61.305    -0.562     0.200
    61.545     1.106     0.200
    63.049    -0.747     0.200
    63.234     0.704     0.200
    63.661    -0.389     0.200
    63.981    -2.424     0.200
    63.918     0.887     0.200
    64.068     0.262     0.200
    64.068    -0.097     0.200
    64.398    -0.725     0.200
    64.399    -0.693     0.200
    64.399    -0.880     0.200
    64.190     0.412     0.200
    64.511    -0.593     0.200
    64.294     1.327     0.200
    64.396     1.153     0.200
    64.767    -0.671     0.200
    64.767    -0.195     0.200
    64.772    -0.808     0.200
    64.838     0.122     0.200
    64.934    -0.669     0.200
    64.976    -0.250     0.200
    64.956    -0.702     0.200
    65.085    -0.165     0.200
    65.684    -0.419     0.200
    65.783     0.058     0.200
    65.927    -0.092     0.200
    65.927    -0.085     0.200
    65.927    -0.233     0.200
    65.927     0.017     0.200
    66.077    -0.156     0.200
    66.038     0.130     0.200
    66.112     1.418     0.200
    67.354     0.246     0.200
    67.354    -0.098     0.200
    68.329    -0.699     0.200
    69.151    -0.385     0.200
    69.207    -1.810     0.200
    69.806    -0.681     0.200
    69.937    -0.818     0.200
    70.065    -0.773     0.200
    70.247     0.641     0.200
    70.415    -0.498     0.200
    70.487     1.964     0.200
    70.300     1.653     0.200
    70.826    -0.129     0.200
    70.987    -0.040     0.200
    71.180    -0.002     0.200
    71.180    -0.112     0.200
    71.256     0.098     0.200
    71.387    -0.256     0.200
    71.760     1.488     0.200
    71.873     1.148     0.200
    71.926     1.788     0.200
    71.999     1.311     0.200
    72.010     1.111     0.200
    72.231     1.318     0.200
    72.417     1.309     0.200
    72.417     0.880     0.200
    72.417     1.059     0.200
    72.717    -0.197     0.200
    72.662     1.278     0.200
    72.764     1.770     0.200
    72.882     1.147     0.200
    73.002    -0.319     0.200
    72.974     0.853     0.200
    73.152     1.990     0.200
    73.450    -0.143     0.200
    73.450    -0.393     0.200
    74.570    -0.318     0.200
    74.805     0.797     0.200
    74.957    -0.629     0.200
    74.957    -0.996     0.200
    74.957    -0.754     0.200
    74.957    -0.926     0.200
    74.957    -0.653     0.200
    75.040     0.534     0.200
    75.040    -1.020     0.200
    75.405     0.666     0.200
    75.418     0.592     0.200
    75.620     0.627     0.200
    75.627     0.592     0.200
    75.910     0.575     0.200
    75.944     0.181     0.200
    75.892     1.576     0.200
    75.944     1.794     0.200
    76.101    -0.120     0.200
    76.018     0.712     0.200
    76.163     0.336     0.200
    76.218     0.278     0.200
    76.218    -0.472     0.200
    76.218     0.121     0.200
    76.571     0.213     0.200
    76.633     0.772     0.200
    76.674     0.710     0.200
    76.674     0.538     0.200
    76.768     0.131     0.200
    76.768     0.506     0.200
    76.768     0.803     0.200
    76.917    -0.138     0.200
    77.036     1.091     0.200
    77.059     0.394     0.200
    77.059     0.105     0.200
    77.083     0.633     0.200
    77.105     0.202     0.200
    77.133     0.545     0.200
    77.292     0.097     0.200
    77.338     0.599     0.200
    77.038     1.484     0.200
    77.038     2.383     0.200
    77.481     1.197     0.200
    77.510     0.634     0.200
    77.510     0.736     0.200
    77.571    -0.735     0.200
    77.620     1.024     0.200
    77.693     0.648     0.200
    77.795     1.445     0.200
    77.833     0.615     0.200
    77.833     0.482     0.200
    77.856     0.174     0.200
    78.040     1.042     0.200
    78.084     0.093     0.200
    78.084     0.796     0.200
    78.209     0.582     0.200
    78.230     0.091     0.200
    78.258     0.152     0.200
    78.263    -0.009     0.200
    78.278     0.958     0.200
    78.435     0.615     0.200
    78.470     0.820     0.200
    78.544     0.500     0.200
    78.564     0.851     0.200
    78.736     1.026     0.200
    78.751    -0.614     0.200
    78.810     1.182     0.200
    78.803     1.125     0.200
    78.822     1.091     0.200
    79.094    -0.082     0.200
    78.951    -0.406     0.200
    79.167     0.454     0.200
    79.220     0.440     0.200
    79.269     1.131     0.200
    79.269     0.658     0.200
    79.313     0.720     0.200
    79.422     0.772     0.200
    79.120     0.969     0.200
    79.674    -0.193     0.200
    79.715     0.752     0.200
    79.584     0.798     0.200
    79.749     0.911     0.200
    79.790     0.233     0.200
    79.790     0.061     0.200
    79.895     1.241     0.200
    79.929    -0.182     0.200
    79.948    -0.280     0.200
    79.977     1.195     0.200
    80.002     0.891     0.200
    80.002    -0.281     0.200
    80.002     0.633     0.200
    79.825     0.927     0.200
    80.011     1.482     0.200
    80.185     0.939     0.200
    80.185     0.735     0.200
    80.219     0.252     0.200
    80.070     1.462     0.200
    80.288     0.986     0.200
    80.344     0.520     0.200
    80.366     0.544     0.200
    80.408     0.201     0.200
    80.203     0.748     0.200
    80.440     0.648     0.200
    80.478    -0.028     0.200
    80.527     0.806     0.200
    80.529     0.814     0.200
    80.563     0.649     0.200
    80.461     1.156     0.200
    80.522     0.527     0.200
    80.523     0.827     0.200
    80.530     0.785     0.200
    80.636     1.118     0.200
    80.656     1.013     0.200
    80.710     0.089     0.200
    80.830     0.280     0.200
    80.663     0.326     0.200
    80.845    -1.600     0.200
    80.918     0.211     0.200
    81.029     0.816     0.200
    81.084     0.176     0.200
    80.951     0.520     0.200
    80.951     1.184     0.200
    80.951     0.895     0.200
    81.191     1.365     0.200
    81.227     0.727     0.200
    81.555    -0.446     0.200
    82.132     1.086     0.200
    82.132     0.610     0.200
    82.132     0.383     0.200
    83.311     1.558     0.200
    83.575    -0.427     0.200
    84.098    -0.579     0.200
    84.253    -0.664     0.200
    84.254     0.730     0.200
    84.254     0.027     0.200
    84.505     0.150     0.200
    85.200    -0.009     0.200
    85.447    -0.156     0.200
    85.447     0.422     0.200
    85.447     0.772     0.200
    85.447     0.632     0.200
    86.037    -0.257     0.200
    86.801     0.468     0.200
    86.829     0.763     0.200
    87.858     1.262     0.200
    87.858     1.833     0.200
    92.290     0.824     0.200
    92.298     0.110     0.200
    92.303     0.333     0.200
    92.303     0.763     0.200
    95.657     0.952     0.200
    18.491    -2.046     0.200
    22.853    -2.343     0.200
    24.635    -0.446     0.200
    24.446     0.056     0.200
    54.530    -0.099     0.200
    55.989    -2.430     0.200
    56.901     0.991     0.200
    64.076    -1.507     0.200
    64.681    -0.490     0.200
    65.411    -1.116     0.200
    65.852     0.018     0.200
    65.852    -0.105     0.200
    70.995    -0.143     0.200
    73.093     2.155     0.200
    73.335    -0.252     0.200
    74.649    -1.354     0.200
    83.849     0.395     0.200
    23.954    -0.363     0.200
    24.875    -0.865     0.200
    34.317    -0.098     0.200
    65.902    -0.356     0.200
    81.460    -0.176     0.200
    18.314    -1.546     0.200
    24.803     0.585     0.200
    47.222     0.351     0.200
    56.020    -1.226     0.200
    64.395    -0.960     0.200
    21.422    -0.485     0.200
    22.338    -1.720     0.200
    22.484    -1.092     0.200
    23.919    -0.015     0.200
    25.129     0.266     0.200
    25.695    -0.819     0.200
    26.620     1.711     0.200
    29.559     1.216     0.200
    29.707     1.639     0.200
    30.083     1.754     0.200
    31.959     2.857     0.200
    34.110     2.079     0.200
    45.754    -0.065     0.200
    46.231    -0.303     0.200
    46.874     1.796     0.200
    46.989    -0.228     0.200
    48.165    -0.530     0.200
    51.031     0.763     0.200
    55.037    -0.159     0.200
    55.826    -0.733     0.200
    59.426     0.151     0.200
    63.925    -0.897     0.200
    64.153    -0.063     0.200
    64.153    -0.739     0.200
    66.206    -0.456     0.200
    74.536    -0.598     0.200
    76.452     0.402     0.200
    81.731     0.418     0.200
    82.170     1.186     0.200
    83.428     1.329     0.200
    18.523    -2.864     0.200
    24.390    -0.731     0.200
    54.482    -1.133     0.200
    15.460     2.396     0.200
    16.349     1.495     0.200
    18.373    -0.636     0.200
    19.399    -1.417     0.200
    19.875    -1.104     0.200
    22.229    -2.417     0.200
    22.229    -1.838     0.200
    23.896    -1.042     0.200
    24.991     0.551     0.200
    24.991     0.824     0.200
    24.991    -0.250     0.200
    25.392     1.795     0.200
    26.710     1.997     0.200
    28.726     2.639     0.200
    29.101     2.499     0.200
    29.648     2.086     0.200
    30.169     2.440     0.200
    30.205     2.486     0.200
    30.385     1.318     0.200
    31.186     2.618     0.200
    31.281     0.870     0.200
    31.318     0.880     0.200
    31.836     2.415     0.200
    32.009     1.811     0.200
    32.098     1.706     0.200
    32.237     2.483     0.200
    32.242     2.358     0.200
    32.249     2.238     0.200
    32.369     1.211     0.200
    32.629     0.249     0.200
    32.951     1.055     0.200
    32.985     1.944     0.200
    33.085     1.187     0.200
    33.429     1.373     0.200
    33.533     1.448     0.200
    33.639     1.118     0.200
    33.646     1.762     0.200
    33.679     2.363     0.200
    33.679     1.875     0.200
    33.998     2.204     0.200
    33.998     2.044     0.200
    33.999     2.161     0.200
    34.250     1.996     0.200
    34.295     2.626     0.200
    34.295     2.298     0.200
    34.300     1.995     0.200
    34.611     2.169     0.200
    34.641     2.434     0.200
    34.662     1.617     0.200
    34.948     2.689     0.200
    35.182     1.479     0.200
    35.795     1.336     0.200
    36.026     0.784     0.200
    36.035     2.159     0.200
    36.163     2.160     0.200
    36.197     0.218     0.200
    36.545     0.623     0.200
    36.631     1.531     0.200
    36.638     1.256     0.200
    36.649     1.921     0.200
    36.659     2.294     0.200
    36.712     2.708     0.200
    36.827     2.124     0.200
    36.946     1.526     0.200
    37.151     1.774     0.200
    37.395     0.892     0.200
    37.604     0.142     0.200
    37.659     1.757     0.200
    38.062     2.105     0.200
    38.062     1.120     0.200
    38.298     2.064     0.200
    38.392     0.062     0.200
    38.499     0.563     0.200
    38.692     1.093     0.200
    38.692     0.175     0.200
    38.821     2.202     0.200
    39.084     1.692     0.200
    39.581     2.478     0.200
    39.696     0.993     0.200
    39.846    -0.655     0.200
    39.889     1.943     0.200
    39.889     0.775     0.200
    39.970     1.354     0.200
    40.750     2.496     0.200
    40.750     2.262     0.200
    40.892     1.389     0.200
    41.004     0.554     0.200
    41.267    -0.531     0.200
    41.281    -0.152     0.200
    42.271     1.917     0.200
    42.293     2.510     0.200
    44.252     1.620     0.200
    44.252     0.628     0.200
    44.620     1.972     0.200
    45.645     0.725     0.200
    47.000     1.738     0.200
    47.001     2.100     0.200
    47.140    -0.064     0.200
    48.343     0.337     0.200
    48.948    -0.981     0.200
    50.898     0.415     0.200
    51.099     1.214     0.200
    51.099    -0.852     0.200
    51.817    -0.372     0.200
    51.892    -2.054     0.200
    53.218    -1.172     0.200
    53.808    -1.271     0.200
    54.856     0.278     0.200
    55.649    -0.908     0.200
    57.329     0.845     0.200
    59.228     0.261     0.200
    59.228    -0.785     0.200
    61.528     1.292     0.200
    63.747    -0.189     0.200
    63.989     0.234     0.200
    64.167     0.020     0.200
    64.319     0.560     0.200
    64.890     0.732     0.200
    65.006    -0.879     0.200
    66.010    -0.052     0.200
    66.010     0.159     0.200
    66.010    -0.126     0.200
    66.117     0.292     0.200
    68.236     0.480     0.200
    70.955     0.592     0.200
    73.420     0.817     0.200
    73.420     0.946     0.200
    74.353    -0.746     0.200
    80.811     1.285     0.200
    80.828     1.455     0.200
    80.865     0.558     0.200
    81.577     1.538     0.200
    81.577    -0.071     0.200
    81.970     1.252     0.200
    81.970     2.353     0.200
    83.296     1.343     0.200
    93.450    -0.166     0.200
    96.807     1.786     0.200
    15.135     3.464     0.200
    15.348     4.078     0.200
    21.528    -0.746     0.200
    22.444    -2.047     0.200
    24.019    -0.448     0.200
    31.994    -0.070     0.200
    33.852    -1.022     0.200
    33.852    -1.842     0.200
    34.168    -0.245     0.200
    40.874    -1.097     0.200
    45.702    -0.010     0.200
    46.330    -1.451     0.200
    46.509     0.140     0.200
    46.915     1.866     0.200
    47.381    -0.295     0.200
    50.993     0.658     0.200
    55.041     0.600     0.200
    59.461     0.020     0.200
    64.012    -0.410     0.200
    64.247    -1.254     0.200
    64.403    -0.179     0.200
    65.265    -1.098     0.200
    66.235    -0.278     0.200
    68.480     0.412     0.200
    74.619    -0.417     0.200
    80.037     0.018     0.200
    81.707     0.402     0.200
    83.531     1.109     0.200
    16.767     0.829     0.200
    17.483    -0.162     0.200
    18.052    -0.010     0.200
    18.309    -1.798     0.200
    18.309    -1.282     0.200
    18.309    -1.681     0.200
    20.180     0.302     0.200
    20.180     0.748     0.200
    20.483    -0.034     0.200
    21.824    -1.624     0.200
    22.660    -1.491     0.200
    23.791     0.413     0.200
    23.861    -0.625     0.200
    23.861     0.805     0.200
    24.517     0.225     0.200
    24.517     0.443     0.200
    24.367     0.645     0.200
    24.367     1.481     0.200
    24.367     0.473     0.200
    24.367     0.207     0.200
    25.059    -1.108     0.200
    26.282     0.610     0.200
    26.269     0.626     0.200
    26.447     0.484     0.200
    26.992     1.055     0.200
    27.306     1.256     0.200
    27.389     1.285     0.200
    27.844     0.754     0.200
    29.978     0.913     0.200
    30.328     1.509     0.200
    30.851     1.034     0.200
    30.867     0.937     0.200
    31.592     1.123     0.200
    31.592     0.959     0.200
    31.709    -0.492     0.200
    31.737     0.728     0.200
    32.721     1.205     0.200
    32.721     0.814     0.200
    33.355    -1.100     0.200
    33.355    -0.522     0.200
    33.631     0.470     0.200
    33.631     0.368     0.200
    33.720     1.004     0.200
    34.051     0.645     0.200
    34.257     2.492     0.200
    34.315     0.638     0.200
    34.315     1.067     0.200
    34.654     0.748     0.200
    34.883    -0.094     0.200
    34.883     0.492     0.200
    34.961     0.966     0.200
    35.175     0.060     0.200
    35.176     0.619     0.200
    35.502    -1.625     0.200
    35.611     1.290     0.200
    35.735     0.623     0.200
    36.149     1.617     0.200
    36.693     1.742     0.200
    37.229     0.474     0.200
    37.229    -0.323     0.200
    37.200     1.566     0.200
    37.173    -0.238     0.200
    37.327     0.906     0.200
    37.559     0.786     0.200
    37.560     1.157     0.200
    37.486     0.589     0.200
    37.488     0.599     0.200
    38.282     0.556     0.200
    38.282     0.829     0.200
    38.472     0.867     0.200
    39.065     0.603     0.200
    39.373    -0.052     0.200
    39.373     0.424     0.200
    39.926     1.001     0.200
    40.505     0.202     0.200
    40.406    -0.197     0.200
    40.539    -0.501     0.200
    40.978    -0.329     0.200
    41.690     0.448     0.200
    41.690     0.104     0.200
    41.921    -0.744     0.200
    41.921     0.561     0.200
    41.959     0.699     0.200
    41.959    -0.152     0.200
    42.257    -1.181     0.200
    42.893     0.317     0.200
    43.318    -0.597     0.200
    44.503    -1.471     0.200
    44.897     1.216     0.200
    44.940     0.448     0.200
    44.992     0.033     0.200
    44.980    -0.080     0.200
    44.980     0.928     0.200
    44.979     0.494     0.200
    44.980    -0.194     0.200
    45.784    -0.489     0.200
    45.798    -0.449     0.200
    46.011    -1.096     0.200
    46.117    -0.973     0.200
    46.347    -1.158     0.200
    46.492     0.235     0.200
    46.642     0.414     0.200
    46.642     0.282     0.200
    46.504     0.715     0.200
    47.127    -0.856     0.200
    47.127    -1.090     0.200
    47.385    -0.406     0.200
    47.630    -0.144     0.200
    47.630    -0.823     0.200
    47.625    -1.754     0.200
    47.643     1.593     0.200
    47.644     1.954     0.200
    47.644     1.751     0.200
    47.884     0.258     0.200
    47.884    -0.148     0.200
    48.492    -0.571     0.200
    48.998    -0.184     0.200
    49.007     0.252     0.200
    49.002     0.332     0.200
    49.229    -1.782     0.200
    49.233     0.161     0.200
    49.240     0.423     0.200
    49.506    -0.728     0.200
    49.847    -0.572     0.200
    50.232     1.474     0.200
    50.396    -0.687     0.200
    50.264     0.514     0.200
    50.264     0.545     0.200
    50.578    -0.099     0.200
    51.140    -0.743     0.200
    51.400    -0.374     0.200
    51.311     0.691     0.200
    51.614    -0.228     0.200
    51.614    -0.002     0.200
    51.473     1.127     0.200
    51.784     0.004     0.200
    51.784     0.489     0.200
    51.637     0.793     0.200
    51.963    -0.290     0.200
    52.036    -0.575     0.200
    52.043    -0.566     0.200
    52.258     0.632     0.200
    52.433    -0.208     0.200
    52.499    -0.327     0.200
    52.572    -1.501     0.200
    52.661     0.634     0.200
    53.734    -0.952     0.200
    54.041    -0.012     0.200
    54.041     0.222     0.200
    54.377     0.393     0.200
    54.377     0.213     0.200
    54.492    -1.105     0.200
    55.491    -1.482     0.200
    55.755    -0.898     0.200
    55.755    -1.617     0.200
    56.224    -2.237     0.200
    56.779     1.240     0.200
    56.961    -0.766     0.200
    56.961     0.054     0.200
    57.614     1.444     0.200
    58.914    -0.315     0.200
    58.914    -0.119     0.200
    58.914     0.678     0.200
    58.914    -1.197     0.200
    59.274     0.779     0.200
    61.292     0.494     0.200
    61.954    -1.863     0.200
    62.933     0.703     0.200
    63.244     0.434     0.200
    63.464    -2.415     0.200
    63.684     0.132     0.200
    63.758    -0.326     0.200
    63.758    -0.052     0.200
    63.842    -1.049     0.200
    63.843    -0.813     0.200
    63.843    -1.063     0.200
    63.707    -0.158     0.200
    63.820     0.442     0.200
    63.867    -0.722     0.200
    64.172    -0.791     0.200
    64.178    -0.512     0.200
    64.178    -1.035     0.200
    64.115     0.102     0.200
    64.294    -0.167     0.200
    64.352     0.852     0.200
    64.472     0.278     0.200
    64.472    -0.230     0.200
    64.521    -0.903     0.200
    64.521    -0.254     0.200
    65.180    -0.825     0.200
    65.662    -0.324     0.200
    65.662    -0.394     0.200
    65.662    -0.277     0.200
    65.771    -0.598     0.200
    65.827     0.066     0.200
    65.900     0.611     0.200
    66.392     0.094     0.200
    68.524    -0.280     0.200
    68.529    -0.063     0.200
    68.539    -0.499     0.200
    68.645     0.301     0.200
    68.785     0.369     0.200
    69.417    -0.452     0.200
    69.855    -0.451     0.200
    69.803    -0.202     0.200
    69.842     0.808     0.200
    70.137    -0.020     0.200
    70.204     0.416     0.200
    70.204     0.315     0.200
    70.295     0.472     0.200
    70.363     0.376     0.200
    70.348     1.232     0.200
    70.516    -0.885     0.200
    70.708    -1.069     0.200
    70.724     0.305     0.200
    70.669     0.803     0.200
    70.776    -0.390     0.200
    71.371     0.736     0.200
    71.475     0.914     0.200
    71.719     0.882     0.200
    71.927     0.783     0.200
    71.943     1.029     0.200
    72.126     0.324     0.200
    72.126     0.192     0.200
    72.367     0.912     0.200
    72.649     0.477     0.200
    72.675     0.476     0.200
    72.842     0.365     0.200
    72.876    -0.114     0.200
    72.859     1.840     0.200
    73.035     0.041     0.200
    72.982     0.503     0.200
    73.132    -0.306     0.200
    73.132    -0.314     0.200
    73.178    -2.452     0.200
    73.315     0.668     0.200
    73.586     0.553     0.200
    73.823     0.386     0.200
    73.824     0.184     0.200
    73.983    -0.072     0.200
    74.383     0.546     0.200
    74.416    -0.867     0.200
    74.416    -0.688     0.200
    74.423    -0.772     0.200
    74.454     0.159     0.200
    74.454     0.432     0.200
    74.579     0.225     0.200
    74.800     0.836     0.200
    74.810     0.574     0.200
    74.821     0.356     0.200
    74.838     0.962     0.200
    74.973     0.483     0.200
    75.031     1.144     0.200
    75.046     0.157     0.200
    75.167     0.863     0.200
    75.167     0.972     0.200
    75.211    -0.289     0.200
    75.360    -0.044     0.200
    75.485     0.599     0.200
    75.508     0.779     0.200
    75.543    -0.297     0.200
    75.641     0.290     0.200
    75.641    -0.257     0.200
    75.716    -0.013     0.200
    75.897     0.081     0.200
    75.847     1.601     0.200
    75.942     0.903     0.200
    76.095    -0.059     0.200
    76.095     0.159     0.200
    76.138     0.488     0.200
    76.181     0.244     0.200
    76.181     0.862     0.200
    76.181     0.362     0.200
    76.281     1.498     0.200
    76.337     0.182     0.200
    76.472     0.372     0.200
    76.472     0.317     0.200
    76.472    -0.277     0.200
    76.472     1.212     0.200
    76.520     0.545     0.200
    76.517     1.165     0.200
    76.561     1.412     0.200
    76.673     0.338     0.200
    76.692     0.028     0.200
    76.937     0.500     0.200
    76.946     1.543     0.200
    77.027    -1.002     0.200
    77.042     1.004     0.200
    77.216     1.726     0.200
    77.445     1.001     0.200
    77.458     1.178     0.200
    77.514     0.908     0.200
    77.539     0.781     0.200
    77.549     0.078     0.200
    77.679     0.883     0.200
    77.676    -0.137     0.200
    77.704     0.157     0.200
    77.842     0.965     0.200
    77.846     0.995     0.200
    77.878     1.046     0.200
    77.953     1.332     0.200
    77.953     0.825     0.200
    77.972     1.133     0.200
    78.127     1.334     0.200
    78.127     0.866     0.200
    78.142     1.378     0.200
    78.222     1.702     0.200
    78.222     1.225     0.200
    78.513     0.724     0.200
    78.549     0.635     0.200
    78.682     0.734     0.200
    78.685     1.070     0.200
    78.837     1.069     0.200
    78.837     0.639     0.200
    78.866     0.093     0.200
    78.770     0.749     0.200
    78.916     0.459     0.200
    78.885    -0.203     0.200
    79.061    -0.564     0.200
    79.166    -0.400     0.200
    79.197     0.982     0.200
    79.216     0.387     0.200
    79.343     1.119     0.200
    79.427     1.274     0.200
    79.523     1.041     0.200
    79.523     0.291     0.200
    79.523     0.791     0.200
    79.474     0.966     0.200
    79.655     0.694     0.200
    79.544     0.820     0.200
    79.708     0.888     0.200
    79.708    -0.128     0.200
    79.740     0.422     0.200
    79.788     1.052     0.200
    79.801     0.473     0.200
    79.853     0.209     0.200
    79.886     0.560     0.200
    79.883     1.146     0.200
    79.987    -0.024     0.200
    80.002     0.450     0.200
    79.946     1.410     0.200
    79.938     0.685     0.200
    80.039     0.806     0.200
    80.269     0.965     0.200
    80.345     1.157     0.200
    80.392     0.701     0.200
    80.392     0.701     0.200
    80.522     0.832     0.200
    80.455     0.725     0.200
    80.599     0.593     0.200
    80.503     1.002     0.200
    80.508     1.179     0.200
    80.634     0.472     0.200
    80.753    -0.303     0.200
    80.698     0.170     0.200
    80.989     0.831     0.200
    80.989     0.909     0.200
    80.989     0.714     0.200
    81.074     0.863     0.200
    81.077     0.645     0.200
    81.265    -0.652     0.200
    81.780     0.033     0.200
    81.755     0.814     0.200
    81.755     0.314     0.200
    81.755     0.673     0.200
    82.252     1.948     0.200
    82.390     1.334     0.200
    82.415     0.350     0.200
    82.781     1.023     0.200
    82.805     1.073     0.200
    82.955     1.903     0.200
    83.107     0.962     0.200
    83.219     1.532     0.200
    83.392     1.335     0.200
    83.395     1.205     0.200
    83.244     0.226     0.200
    83.635     0.511     0.200
    83.636     0.499     0.200
    83.636     0.913     0.200
    83.692     0.715     0.200
    83.719     1.262     0.200
    83.761     0.057     0.200
    83.829     1.801     0.200
    84.089     0.687     0.200
    84.162    -0.063     0.200
    84.248     1.272     0.200
    84.375     0.838     0.200
    84.499     1.297     0.200
    84.931     0.476     0.200
    84.931     0.828     0.200
    85.532     0.608     0.200
    87.122     0.913     0.200
    87.385     0.939     0.200
    92.804     0.014     0.200
    96.168     0.751     0.200
    14.572     5.653     0.200
    14.609     5.538     0.200
    14.776     7.447     0.200
    15.445     5.282     0.200
    15.522     3.694     0.200
    15.538     3.287     0.200
    15.726     2.508     0.200
    15.765     3.961     0.200
    15.890     4.779     0.200
    16.301     2.407     0.200
    16.395     3.112     0.200
    16.910     1.721     0.200
    16.960     0.999     0.200
    17.515     0.694     0.200
    17.969     1.403     0.200
    18.521    -1.438     0.200
    18.521    -1.289     0.200
    22.025    -1.323     0.200
    22.897    -2.637     0.200
    24.598    -0.738     0.200
    24.609     1.586     0.200
    24.609     0.188     0.200
    32.485     1.074     0.200
    47.430     1.455     0.200
    54.712    -0.141     0.200
    64.206    -0.639     0.200
    64.138    -0.480     0.200
    64.856     0.283     0.200
    64.859     0.147     0.200
    66.034    -0.530     0.200
    66.034    -0.381     0.200
    71.165    -0.701     0.200
    73.514    -0.357     0.200
    73.514    -0.162     0.200
    74.785    -0.437     0.200
    81.260     0.988     0.200
    83.921     0.779     0.200
    85.308     0.502     0.200
    18.465    -0.628     0.200
    18.465     0.433     0.200
    20.165    -0.158     0.200
    20.165     1.182     0.200
    20.815    -1.762     0.200
    20.815    -1.297     0.200
    21.695    -2.206     0.200
    22.760    -2.204     0.200
    23.462    -0.921     0.200
    25.033    -0.642     0.200
    25.033     1.848     0.200
    25.033    -0.732     0.200
    25.033    -0.227     0.200
    25.326    -0.868     0.200
    26.121     1.400     0.200
    26.152     2.092     0.200
    26.527     2.533     0.200
    26.666    -0.766     0.200
    26.666     1.763     0.200
    26.666    -0.568     0.200
    29.138     2.360     0.200
    30.746    -2.066     0.200
    30.746    -1.436     0.200
    30.795     1.384     0.200
    30.795     2.481     0.200
    30.825     0.779     0.200
    31.138     1.208     0.200
    31.831     0.044     0.200
    32.071     2.505     0.200
    32.457     0.878     0.200
    32.486    -2.149     0.200
    32.761     0.811     0.200
    32.841     0.158     0.200
    33.177     0.189     0.200
    33.263    -0.872     0.200
    33.263    -0.252     0.200
    33.263    -0.391     0.200
    33.563     0.551     0.200
    33.620     1.555     0.200
    33.627     1.560     0.200
    33.698     1.506     0.200
    33.899     2.151     0.200
    34.051     2.065     0.200
    34.052     1.338     0.200
    35.177     2.381     0.200
    35.429     1.820     0.200
    35.599     1.736     0.200
    35.714    -1.268     0.200
    35.714    -1.558     0.200
    35.714    -0.789     0.200
    36.186     1.653     0.200
    36.333     1.891     0.200
    36.333     1.660     0.200
    36.523     1.952     0.200
    36.422     0.286     0.200
    36.594     1.974     0.200
    36.641     2.335     0.200
    36.641     0.121     0.200
    36.641     1.510     0.200
    36.648     2.488     0.200
    37.213     2.819     0.200
    37.280     0.393     0.200
    37.280     0.043     0.200
    37.319     2.351     0.200
    37.374     2.537     0.200
    38.239     2.342     0.200
    38.239     1.590     0.200
    38.239     1.463     0.200
    38.224    -0.366     0.200
    38.225    -0.398     0.200
    38.225     0.302     0.200
    38.388     0.961     0.200
    38.388     0.536     0.200
    38.397     1.909     0.200
    38.397     2.059     0.200
    38.993     0.058     0.200
    39.505     0.945     0.200
    39.715     1.346     0.200
    39.879     2.745     0.200
    40.095    -1.637     0.200
    40.470     1.891     0.200
    40.717     2.180     0.200
    40.750    -1.120     0.200
    40.758     1.955     0.200
    40.812    -0.654     0.200
    40.959     0.333     0.200
    40.959     0.483     0.200
    41.171     1.445     0.200
    41.171     1.167     0.200
    41.080     0.270     0.200
    41.396     1.207     0.200
    41.571    -1.291     0.200
    41.920     0.532     0.200
    42.210     2.571     0.200
    42.246     1.645     0.200
    42.679     0.242     0.200
    43.032    -1.003     0.200
    43.839    -1.530     0.200
    43.961     1.763     0.200
    44.177     2.422     0.200
    44.177     2.167     0.200
    44.817    -1.364     0.200
    44.817    -0.089     0.200
    44.908    -0.811     0.200
    45.664     1.115     0.200
    45.664     1.434     0.200
    45.555     0.227     0.200
    45.738     0.881     0.200
    45.782     0.444     0.200
    45.782    -0.409     0.200
    45.783    -0.553     0.200
    45.783     0.827     0.200
    46.398    -0.811     0.200
    46.398    -0.471     0.200
    46.459    -0.664     0.200
    46.459    -0.855     0.200
    46.647    -0.540     0.200
    46.721     0.836     0.200
    46.930    -0.111     0.200
    46.931     1.582     0.200
    46.936     1.122     0.200
    47.334    -2.260     0.200
    47.571    -0.646     0.200
    47.571    -1.035     0.200
    47.880     0.225     0.200
    48.061    -1.392     0.200
    48.061    -0.271     0.200
    48.141    -0.018     0.200
    48.232     0.420     0.200
    48.231    -0.469     0.200
    48.231     0.351     0.200
    48.269     0.094     0.200
    48.259    -1.449     0.200
    48.429     0.515     0.200
    48.757     0.242     0.200
    48.757     0.866     0.200
    48.792    -0.802     0.200
    48.792    -0.992     0.200
    49.423    -0.862     0.200
    49.556    -1.142     0.200
    50.170    -0.761     0.200
    50.217     0.041     0.200
    50.232     1.015     0.200
    50.857     0.794     0.200
    50.857     0.359     0.200
    50.931     0.084     0.200
    51.036     0.053     0.200
    50.954     1.168     0.200
    50.954     0.568     0.200
    50.954    -0.512     0.200
    51.139     0.555     0.200
    51.235    -1.809     0.200
    51.516    -0.704     0.200
    51.581    -0.283     0.200
    51.598    -1.937     0.200
    52.019    -0.594     0.200
    52.008     0.981     0.200
    52.376    -1.773     0.200
    52.740    -0.187     0.200
    52.735     1.188     0.200
    52.857    -1.943     0.200
    52.947    -0.098     0.200
    52.947     0.348     0.200
    52.993     0.056     0.200
    52.993    -0.921     0.200
    53.056    -1.356     0.200
    53.096    -0.506     0.200
    53.096     0.164     0.200
    53.639     0.026     0.200
    54.052    -0.841     0.200
    54.188    -0.167     0.200
    54.276    -0.216     0.200
    54.420    -2.081     0.200
    54.343     0.495     0.200
    54.365    -1.011     0.200
    54.365    -0.061     0.200
    54.365     0.350     0.200
    54.695    -0.607     0.200
    54.695     0.444     0.200
    54.695    -0.197     0.200
    55.074    -0.358     0.200
    55.136    -0.941     0.200
    55.136    -1.852     0.200
    55.136    -1.401     0.200
    55.197    -0.929     0.200
    55.159     0.088     0.200
    55.288    -0.560     0.200
    55.355    -1.217     0.200
    55.695    -0.901     0.200
    55.873    -2.105     0.200
    56.251    -1.712     0.200
    56.720    -0.679     0.200
    57.348     0.329     0.200
    57.251     2.053     0.200
    58.166     0.625     0.200
    58.922    -1.644     0.200
    58.922     0.206     0.200
    59.592    -0.857     0.200
    59.933     0.477     0.200
    61.381     0.907     0.200
    61.502     0.794     0.200
    62.973    -1.759     0.200
    63.129    -0.397     0.200
    63.237    -0.415     0.200
    63.237    -0.540     0.200
    63.416     0.200     0.200
    63.458    -0.873     0.200
    63.458    -0.723     0.200
    63.640    -0.505     0.200
    63.728    -1.044     0.200
    63.778    -0.619     0.200
    63.740    -0.794     0.200
    63.740    -0.334     0.200
    63.740    -0.174     0.200
    63.771     0.661     0.200
    63.849    -0.503     0.200
    63.904    -0.467     0.200
    64.178     0.085     0.200
    64.204     0.654     0.200
    64.236    -0.495     0.200
    64.236    -0.084     0.200
    64.337    -0.582     0.200
    64.338    -0.616     0.200
    64.338     0.134     0.200
    64.338     0.395     0.200
    64.477    -1.281     0.200
    64.796     1.144     0.200
    65.728    -0.587     0.200
    65.728    -0.297     0.200
    65.834    -1.176     0.200
    65.834    -0.236     0.200
    66.064     0.944     0.200
    66.316    -0.182     0.200
    66.401    -1.129     0.200
    66.401     0.941     0.200
    67.688    -0.816     0.200
    67.694    -0.130     0.200
    68.760    -0.834     0.200
    68.919    -0.000     0.200
    68.920     1.091     0.200
    69.120     0.650     0.200
    69.236    -0.081     0.200
    69.875    -0.522     0.200
    69.850    -0.856     0.200
    70.059     0.549     0.200
    70.126    -1.452     0.200
    70.143     0.246     0.200
    70.192     0.275     0.200
    70.390     0.176     0.200
    70.522     1.415     0.200
    70.560    -0.097     0.200
    70.766     0.611     0.200
    70.929     1.250     0.200
    71.154    -0.814     0.200
    71.502     1.004     0.200
    71.589     0.951     0.200
    71.649     0.850     0.200
    71.727     2.266     0.200
    71.735     1.401     0.200
    71.857     1.448     0.200
    71.965     1.301     0.200
    72.142     1.047     0.200
    72.142     1.237     0.200
    72.374     1.135     0.200
    73.094    -0.273     0.200
    73.094     0.087     0.200
    73.382     1.519     0.200
    73.504     0.960     0.200
    73.616     0.783     0.200
    73.744     0.901     0.200
    73.848     0.003     0.200
    73.853    -0.788     0.200
    73.853    -0.988     0.200
    73.853    -1.309     0.200
    73.861    -0.724     0.200
    73.861    -1.623     0.200
    73.861    -0.373     0.200
    73.985     0.997     0.200
    74.116     0.934     0.200
    74.107     0.454     0.200
    74.357     1.468     0.200
    74.357     1.177     0.200
    74.646     1.193     0.200
    74.646     0.933     0.200
    74.654     0.153     0.200
    74.963     0.555     0.200
    75.138     0.181     0.200
    75.188     0.763     0.200
    75.407     0.199     0.200
    75.466     1.063     0.200
    75.466     0.663     0.200
    75.466     0.333     0.200
    75.622     1.871     0.200
    75.648     0.022     0.200
    75.918     0.446     0.200
    76.204     2.309     0.200
    76.271     0.870     0.200
    76.361     0.961     0.200
    76.381     0.849     0.200
    76.459    -0.307     0.200
    76.539     1.463     0.200
    76.764     1.235     0.200
    77.072     0.140     0.200
    77.102     1.228     0.200
    77.104    -0.062     0.200
    77.104    -0.062     0.200
    77.218     1.498     0.200
    77.581     0.435     0.200
    77.981     1.088     0.200
    77.979     0.800     0.200
    78.129     0.843     0.200
    78.798     0.168     0.200
    78.839     0.955     0.200
    79.023     0.623     0.200
    79.163    -0.146     0.200
    79.319     1.600     0.200
    79.292     0.037     0.200
    79.376     0.717     0.200
    79.359     1.662     0.200
    79.361     1.233     0.200
    79.714     1.701     0.200
    80.535     1.214     0.200
    81.345     1.503     0.200
    81.280    -0.360     0.200
    81.257     0.444     0.200
    81.258     0.806     0.200
    81.475     0.917     0.200
    81.586     1.832     0.200
    81.552     0.281     0.200
    81.552     0.811     0.200
    81.552     0.461     0.200
    81.897     0.492     0.200
    81.931     2.363     0.200
    81.941     0.839     0.200
    82.143     2.427     0.200
    82.266    -0.134     0.200
    82.311     1.521     0.200
    82.352     1.305     0.200
    82.498     1.643     0.200
    82.754    -0.137     0.200
    82.893     0.531     0.200
    83.357     3.003     0.200
    83.362     1.305     0.200
    83.590     1.093     0.200
    83.815     1.432     0.200
    84.331     1.097     0.200
    84.438     0.171     0.200
    84.438     0.750     0.200
    84.438     1.269     0.200
    84.438     0.220     0.200
    84.525     1.435     0.200
    84.578     2.826     0.200
    84.661     1.008     0.200
    84.842     0.806     0.200
    85.069     1.872     0.200
    93.851     0.123     0.200
    93.851    -0.177     0.200
    14.591     8.740     0.200
    14.638     8.669     0.200
    14.738     7.233     0.200
    14.838     5.727     0.200
    16.228     3.895     0.200
    18.364    -1.501     0.200
    18.364    -0.767     0.200
    21.861    -1.143     0.200
    24.390    -0.039     0.200
    24.817     1.124     0.200
    47.055    -1.244     0.200
    47.213     1.746     0.200
    54.872    -0.102     0.200
    56.079    -0.706     0.200
    64.173    -0.833     0.200
    64.453    -0.116     0.200
    64.933    -0.277     0.200
    65.464    -0.538     0.200
    66.150    -0.543     0.200
    74.763    -0.671     0.200
    15.221     4.975     0.200
    15.511     2.843     0.200
    15.696     3.072     0.200
    16.164     3.074     0.200
    16.813     2.004     0.200
    18.291    -1.755     0.200
    18.291    -1.370     0.200
    21.794    -2.255     0.200
    24.376     0.420     0.200
    24.699     0.239     0.200
    24.699    -0.040     0.200
    24.699     0.509     0.200
    46.891    -0.761     0.200
    47.290    -1.356     0.200
    47.321     1.174     0.200
    54.721     0.086     0.200
    64.183    -0.480     0.200
    64.768    -0.456     0.200
    65.331    -1.078     0.200
    65.988    -1.322     0.200
    81.328     0.363     0.200
    18.376    -2.180     0.200
    18.376    -1.309     0.200
    21.868     0.258     0.200
    22.774    -0.747     0.200
    24.361     0.582     0.200
    24.919     0.245     0.200
    34.413     1.507     0.200
    47.115     2.162     0.200
    54.983     0.822     0.200
    64.455    -0.937     0.200
    66.260    -0.021     0.200
    18.894    -1.647     0.200
    25.023     1.021     0.200
    32.815     2.513     0.200
    35.114     2.251     0.200
    47.778     1.713     0.200
    56.301    -2.489     0.200
    64.178    -1.010     0.200
    64.385    -1.935     0.200
    64.749    -1.265     0.200
    64.749    -1.441     0.200
    64.833    -1.157     0.200
    65.748    -1.510     0.200
    65.930    -1.498     0.200
    69.120    -0.811     0.200
    74.944    -1.793     0.200
    80.177     0.319     0.200
    80.967     0.381     0.200
    84.231    -0.209     0.200
    17.396     1.051     0.200
    17.463     0.374     0.200
    17.463     2.223     0.200
    18.375    -0.888     0.200
    18.920    -1.956     0.200
    18.920    -1.480     0.200
    19.500    -0.589     0.200
    19.960    -0.933     0.200
    20.525     0.943     0.200
    20.534    -0.805     0.200
    20.527     0.445     0.200
    20.527    -0.036     0.200
    21.023    -0.039     0.200
    22.431    -1.348     0.200
    23.279    -1.917     0.200
    23.779     1.288     0.200
    23.779     0.038     0.200
    23.779    -0.513     0.200
    23.779    -0.411     0.200
    23.779     0.298     0.200
    24.145     0.462     0.200
    24.669     2.919     0.200
    25.043     1.286     0.200
    25.118     1.783     0.200
    25.249    -0.908     0.200
    26.123    -0.838     0.200
    26.380     0.646     0.200
    26.380     1.345     0.200
    26.380    -0.655     0.200
    26.380     0.406     0.200
    26.550     0.946     0.200
    27.241     1.303     0.200
    27.295     2.571     0.200
    27.655     2.646     0.200
    27.655     1.228     0.200
    30.241    -0.677     0.200
    31.799     1.043     0.200
    32.113     2.718     0.200
    32.329     0.585     0.200
    33.058    -0.064     0.200
    33.294     0.644     0.200
    33.294     0.974     0.200
    33.556    -0.530     0.200
    33.730    -1.411     0.200
    33.730    -0.530     0.200
    33.730    -0.969     0.200
    33.688     0.737     0.200
    33.670     1.137     0.200
    33.805     0.726     0.200
    33.902    -0.287     0.200
    34.181     1.782     0.200
    34.323    -0.071     0.200
    34.339     1.650     0.200
    34.408     2.112     0.200
    34.434     0.867     0.200
    34.463     1.369     0.200
    34.649     3.228     0.200
    34.791     0.350     0.200
    34.825     1.638     0.200
    34.840     1.793     0.200
    34.847    -0.887     0.200
    34.902     0.509     0.200
    34.930     0.882     0.200
    34.998     1.804     0.200
    35.012     2.080     0.200
    35.118     1.552     0.200
    35.118     2.401     0.200
    35.234     2.367     0.200
    35.274     2.292     0.200
    35.386     2.697     0.200
    35.501    -1.149     0.200
    35.490     1.435     0.200
    35.685     0.560     0.200
    35.717    -1.399     0.200
    35.717    -1.089     0.200
    35.638     1.077     0.200
    35.638     1.267     0.200
    35.735     1.311     0.200
    35.757     1.962     0.200
    35.839     1.413     0.200
    35.859     2.328     0.200
    35.947     2.605     0.200
    36.147     2.736     0.200
    36.264     2.129     0.200
    36.265     2.604     0.200
    36.349     2.604     0.200
    36.466     1.515     0.200
    36.546     2.536     0.200
    36.620     3.159     0.200
    36.581     1.210     0.200
    36.883     1.644     0.200
    37.176    -0.456     0.200
    37.259     1.852     0.200
    37.283     2.051     0.200
    37.283     2.243     0.200
    37.283     3.255     0.200
    37.290     3.346     0.200
    37.522    -0.316     0.200
    37.454     1.626     0.200
    37.538     1.434     0.200
    37.629     2.936     0.200
    37.658     3.226     0.200
    37.820     1.192     0.200
    37.926     1.489     0.200
    37.835     1.593     0.200
    38.096     2.236     0.200
    38.190     2.557     0.200
    38.302     1.132     0.200
    38.302     0.827     0.200
    38.302     0.687     0.200
    38.302     1.626     0.200
    38.302     1.337     0.200
    38.297     2.669     0.200
    38.396     0.344     0.200
    38.695     1.030     0.200
    38.618     2.803     0.200
    38.826     2.547     0.200
    38.903     2.970     0.200
    39.293     2.347     0.200
    39.327     2.163     0.200
    39.327     1.317     0.200
    39.327     2.653     0.200
    39.428     2.500     0.200
    39.765     0.962     0.200
    39.940     2.448     0.200
    39.940     1.300     0.200
    40.056     1.359     0.200
    40.257     0.301     0.200
    40.252    -1.356     0.200
    40.296     0.132     0.200
    40.348     2.826     0.200
    40.503    -0.739     0.200
    40.548    -0.107     0.200
    40.571     2.779     0.200
    40.571     1.785     0.200
    40.718     1.569     0.200
    41.602    -1.450     0.200
    41.469     2.004     0.200
    41.556     0.767     0.200
    41.902    -0.086     0.200
    41.767     2.441     0.200
    41.767     1.712     0.200
    42.027     0.718     0.200
    42.027     1.013     0.200
    42.086     1.393     0.200
    42.086     2.764     0.200
    42.306    -1.331     0.200
    42.369     0.304     0.200
    42.369     1.108     0.200
    42.604     0.530     0.200
    43.140    -1.072     0.200
    43.037     2.832     0.200
    43.037     1.709     0.200
    43.268     0.412     0.200
    43.374     0.998     0.200
    43.378    -1.020     0.200
    43.378     0.005     0.200
    44.107    -1.285     0.200
    44.303     0.364     0.200
    44.466    -0.362     0.200
    44.640    -0.950     0.200
    44.692     0.535     0.200
    44.785     0.981     0.200
    44.785     1.090     0.200
    44.785     0.988     0.200
    44.785     1.141     0.200
    44.868     0.934     0.200
    44.921     1.056     0.200
    44.927     1.133     0.200
    44.984    -0.491     0.200
    45.003    -0.894     0.200
    45.023     0.999     0.200
    45.038     1.650     0.200
    45.038     3.148     0.200
    45.119     0.687     0.200
    45.417    -1.602     0.200
    45.766     0.920     0.200
    45.933     1.291     0.200
    46.273     0.563     0.200
    46.721     1.199     0.200
    46.721     0.320     0.200
    46.903     0.114     0.200
    46.903     0.774     0.200
    46.903     0.536     0.200
    46.963    -0.792     0.200
    46.963    -1.232     0.200
    46.903    -1.227     0.200
    47.029    -0.683     0.200
    47.029    -1.007     0.200
    47.266     0.545     0.200
    47.266    -0.755     0.200
    47.225     0.775     0.200
    47.714    -0.614     0.200
    47.714    -0.913     0.200
    47.649    -0.632     0.200
    47.718     0.276     0.200
    47.777     2.023     0.200
    47.777     1.886     0.200
    47.777     2.492     0.200
    48.040    -2.372     0.200
    48.246     0.604     0.200
    48.246    -0.497     0.200
    48.236     0.481     0.200
    48.236    -0.505     0.200
    48.290     0.800     0.200
    48.808    -0.199     0.200
    49.182     1.026     0.200
    49.328     0.268     0.200
    49.283     1.974     0.200
    49.454     0.560     0.200
    49.621    -1.468     0.200
    49.597    -0.067     0.200
    49.621     0.695     0.200
    49.843    -0.249     0.200
    49.851    -2.479     0.200
    49.896     0.817     0.200
    50.161     1.039     0.200
    50.224    -1.019     0.200
    50.200    -0.155     0.200
    50.161     0.687     0.200
    50.257     0.134     0.200
    50.396    -0.063     0.200
    50.771    -0.768     0.200
    50.771    -1.400     0.200
    50.862     0.042     0.200
    51.017     0.633     0.200
    51.201     1.447     0.200
    51.257     0.973     0.200
    51.423    -0.337     0.200
    51.329     1.586     0.200
    51.511    -0.375     0.200
    51.520    -0.812     0.200
    52.022    -0.080     0.200
    51.893     2.673     0.200
    52.001    -0.963     0.200
    52.107     0.275     0.200
    52.107    -0.205     0.200
    52.306     0.700     0.200
    52.355    -0.442     0.200
    52.341     0.548     0.200
    52.519    -1.860     0.200
    52.445    -0.082     0.200
    52.488    -1.052     0.200
    52.631     0.203     0.200
    52.811    -1.839     0.200
    52.701     0.772     0.200
    52.886    -1.119     0.200
    52.969    -0.354     0.200
    53.011     0.249     0.200
    53.466     0.148     0.200
    53.476    -0.510     0.200
    53.514    -1.109     0.200
    53.749    -0.252     0.200
    54.045    -0.011     0.200
    54.148     0.080     0.200
    54.186     1.165     0.200
    54.220    -0.185     0.200
    54.258    -0.324     0.200
    54.355     0.433     0.200
    54.452     0.393     0.200
    54.452    -0.685     0.200
    54.521    -0.757     0.200
    54.526     1.031     0.200
    54.510    -0.264     0.200
    54.631    -0.671     0.200
    54.731     0.107     0.200
    54.959     0.664     0.200
    54.924    -0.193     0.200
    55.012     0.139     0.200
    55.148     0.164     0.200
    55.261    -1.337     0.200
    55.608    -0.877     0.200
    55.544     0.069     0.200
    55.761    -0.407     0.200
    56.019    -0.589     0.200
    56.125    -0.333     0.200
    56.319    -0.365     0.200
    56.330    -1.390     0.200
    56.523    -1.484     0.200
    56.515    -0.474     0.200
    56.555    -1.323     0.200
    56.906    -1.379     0.200
    56.829     0.857     0.200
    57.131     0.722     0.200
    57.515    -0.595     0.200
    57.515    -1.394     0.200
    57.611     1.031     0.200
    57.758     0.712     0.200
    57.713    -0.426     0.200
    57.925    -2.675     0.200
    57.820     0.066     0.200
    57.996    -0.831     0.200
    57.928     0.386     0.200
    58.380    -0.542     0.200
    58.547    -0.891     0.200
    58.653    -1.052     0.200
    58.625     1.233     0.200
    59.233    -0.089     0.200
    59.233     0.212     0.200
    59.382    -0.378     0.200
    59.545    -0.658     0.200
    59.744    -2.087     0.200
    59.821    -0.845     0.200
    60.931     0.870     0.200
    61.317    -0.748     0.200
    61.653    -0.626     0.200
    62.525    -1.850     0.200
    62.676    -0.117     0.200
    62.907    -0.227     0.200
    62.875     0.794     0.200
    63.059    -0.193     0.200
    63.257     0.358     0.200
    63.672    -0.947     0.200
    63.730    -0.848     0.200
    63.853    -1.312     0.200
    63.942     0.036     0.200
    64.090     0.763     0.200
    64.199    -0.179     0.200
    64.253    -1.209     0.200
    64.368    -0.319     0.200
    64.413    -0.957     0.200
    64.392     0.454     0.200
    64.419     0.906     0.200
    64.708    -0.063     0.200
    64.778    -0.439     0.200
    64.778    -0.388     0.200
    64.790    -0.842     0.200
    64.790    -0.518     0.200
    64.855     0.205     0.200
    64.859     0.533     0.200
    64.947    -0.152     0.200
    64.970    -0.530     0.200
    64.975    -0.655     0.200
    64.975     0.076     0.200
    65.079    -0.219     0.200
    65.096    -0.581     0.200
    65.470     0.868     0.200
    65.642     0.014     0.200
    65.697     0.218     0.200
    65.776    -0.691     0.200
    65.812    -0.143     0.200
    65.857    -0.283     0.200
    65.897     0.433     0.200
    65.975    -0.032     0.200
    65.949    -0.024     0.200
    65.949    -0.448     0.200
    66.088    -0.428     0.200
    66.088     0.483     0.200
    66.116     0.124     0.200
    66.129     0.102     0.200
    66.136     0.203     0.200
    66.135     0.681     0.200
    66.234    -0.634     0.200
    66.425     0.094     0.200
    66.853    -0.238     0.200
    66.946     0.297     0.200
    67.219     0.272     0.200
    67.246     0.310     0.200
    67.368    -0.280     0.200
    67.399    -0.169     0.200
    67.479     0.339     0.200
    67.698    -0.027     0.200
    67.933     0.136     0.200
    67.963    -0.386     0.200
    68.499     0.071     0.200
    68.570     0.128     0.200
    68.448     0.922     0.200
    68.652     0.063     0.200
    68.946     0.302     0.200
    68.919     0.684     0.200
    69.149     0.235     0.200
    69.158     0.210     0.200
    69.209    -0.206     0.200
    69.223    -1.998     0.200
    69.150     1.149     0.200
    69.383    -0.194     0.200
    69.797     0.245     0.200
    69.881    -0.243     0.200
    69.833     0.130     0.200
    69.948     0.129     0.200
    69.953    -1.106     0.200
    69.953    -0.904     0.200
    69.992     0.024     0.200
    70.022     0.323     0.200
    70.087    -0.698     0.200
    70.182    -0.843     0.200
    70.133     0.701     0.200
    70.248    -0.504     0.200
    70.269     0.436     0.200
    70.343     0.075     0.200
    70.429     0.552     0.200
    70.322     1.532     0.200
    70.532     0.311     0.200
    70.611    -0.033     0.200
    70.585     0.576     0.200
    70.838     0.528     0.200
    70.838    -0.411     0.200
    70.870    -0.466     0.200
    71.006    -0.256     0.200
    71.006    -1.131     0.200
    71.023     0.503     0.200
    70.969     1.098     0.200
    71.225     0.100     0.200
    71.169     0.707     0.200
    71.270     0.065     0.200
    71.355     0.722     0.200
    71.472     0.133     0.200
    71.522     0.106     0.200
    71.687     0.622     0.200
    71.828     0.425     0.200
    71.782     0.938     0.200
    71.929    -0.045     0.200
    71.945    -0.686     0.200
    71.895     0.922     0.200
    72.032     1.077     0.200
    72.145    -1.397     0.200
    72.115     1.119     0.200
    72.183     0.427     0.200
    72.204     0.269     0.200
    72.439     1.013     0.200
    72.439     1.445     0.200
    72.305     0.947     0.200
    72.729     0.187     0.200
    72.684     1.255     0.200
    72.753     0.775     0.200
    72.824     0.456     0.200
    72.846    -0.177     0.200
    72.965     0.494     0.200
    73.019    -1.400     0.200
    72.996     1.134     0.200
    73.127    -1.340     0.200
    73.253     0.238     0.200
    73.283     0.459     0.200
    73.334     0.286     0.200
    73.439     0.861     0.200
    73.439     0.293     0.200
    73.478    -0.241     0.200
    73.471    -0.966     0.200
    73.543     0.907     0.200
    73.699    -1.007     0.200
    73.772     1.606     0.200
    73.841     0.162     0.200
    73.919     0.771     0.200
    74.108     0.250     0.200
    74.191     0.537     0.200
    74.430     0.443     0.200
    74.450    -0.197     0.200
    74.355     1.655     0.200
    74.528    -0.146     0.200
    74.482     0.809     0.200
    74.285     2.264     0.200
    74.582    -0.059     0.200
    74.626     0.404     0.200
    74.633    -0.159     0.200
    74.815     0.491     0.200
    74.828     0.201     0.200
    74.862     0.577     0.200
    74.917     0.110     0.200
    74.630     1.062     0.200
    74.967    -0.062     0.200
    74.972    -0.745     0.200
    74.972    -0.820     0.200
    74.972    -1.120     0.200
    74.980    -0.464     0.200
    74.986     0.471     0.200
    74.980    -1.166     0.200
    74.994    -1.045     0.200
    75.018     0.434     0.200
    75.051     0.252     0.200
    75.082     0.437     0.200
    75.145     0.072     0.200
    75.181     0.349     0.200
    75.206     0.083     0.200
    75.207    -0.004     0.200
    75.280     0.106     0.200
    75.299     0.598     0.200
    75.366     0.269     0.200
    75.386     0.996     0.200
    75.407     0.445     0.200
    75.450     0.421     0.200
    75.638     0.849     0.200
    75.638     0.148     0.200
    75.778     1.061     0.200
    75.778     0.820     0.200
    75.794    -0.213     0.200
    75.862     0.396     0.200
    75.922     0.530     0.200
    75.956     0.535     0.200
    76.038    -0.030     0.200
    75.915     1.370     0.200
    75.967     2.971     0.200
    76.086     0.617     0.200
    76.111     0.619     0.200
    76.115    -0.172     0.200
    76.175     0.387     0.200
    76.230     0.013     0.200
    76.230    -0.128     0.200
    76.341     0.384     0.200
    76.593     0.714     0.200
    76.593    -0.085     0.200
    76.645     0.623     0.200
    76.686     0.391     0.200
    76.738     0.636     0.200
    76.780     0.963     0.200
    76.780    -0.037     0.200
    76.866     1.477     0.200
    76.904     0.435     0.200
    76.929     0.220     0.200
    77.049     0.844     0.200
    77.070     0.428     0.200
    77.070     0.488     0.200
    77.096     0.582     0.200
    77.117     0.466     0.200
    77.150     1.575     0.200
    77.281     0.453     0.200
    77.046     1.459     0.200
    77.528     0.962     0.200
    77.632     1.181     0.200
    77.636     0.711     0.200
    77.698    -0.888     0.200
    77.807     1.403     0.200
    77.878     0.407     0.200
    78.051     0.531     0.200
    78.052     0.880     0.200
    78.085     0.370     0.200
    78.094     0.206     0.200
    78.097     1.380     0.200
    78.139     0.709     0.200
    78.202     1.709     0.200
    78.220     0.425     0.200
    77.975     1.570     0.200
    78.277     0.062     0.200
    78.284     0.425     0.200
    78.290     0.995     0.200
    78.007     0.192     0.200
    78.428     0.580     0.200
    78.446     0.631     0.200
    78.480     0.594     0.200
    78.555     0.937     0.200
    78.575     0.802     0.200
    78.663     0.863     0.200
    78.686    -0.665     0.200
    78.721     0.901     0.200
    78.746     0.866     0.200
    78.766    -1.102     0.200
    78.821     1.235     0.200
    78.888     0.227     0.200
    78.974     0.156     0.200
    79.114     0.279     0.200
    79.203     0.850     0.200
    79.280     0.224     0.200
    79.280     0.705     0.200
    79.325     0.776     0.200
    79.134     1.077     0.200
    79.434     0.722     0.200
    79.464    -0.095     0.200
    79.540     0.411     0.200
    79.674    -0.364     0.200
    79.711     0.136     0.200
    79.803    -0.628     0.200
    79.803     0.237     0.200
    79.846     0.305     0.200
    79.884     1.089     0.200
    79.898    -0.031     0.200
    79.994    -0.900     0.200
    80.029     0.109     0.200
    80.020     1.691     0.200
    80.020     0.662     0.200
    80.020    -0.037     0.200
    80.203     0.846     0.200
    80.203     0.670     0.200
    80.236     1.496     0.200
    80.249     0.627     0.200
    80.261     1.058     0.200
    80.306     0.715     0.200
    80.456     0.773     0.200
    80.454     0.723     0.200
    80.845     0.259     0.200
    80.859     0.052     0.200
    80.903     0.615     0.200
    80.974     0.890     0.200
    81.138     3.566     0.200
    81.138     2.966     0.200
    81.520     1.008     0.200
    81.680     1.293     0.200
    81.888     1.498     0.200
    81.998     1.419     0.200
    82.501     1.287     0.200
    82.876     1.133     0.200
    82.882     1.703     0.200
    83.014     1.422     0.200
    83.329     2.395     0.200
    83.329     0.895     0.200
    83.373     2.351     0.200
    83.373     0.769     0.200
    83.429     0.679     0.200
    83.468     1.279     0.200
    83.843     0.755     0.200
    84.016     0.669     0.200
    84.219     0.839     0.200
    84.260     0.832     0.200
    84.315     0.850     0.200
    84.343     0.608     0.200
    84.385     0.798     0.200
    84.578     1.122     0.200
    84.872     0.938     0.200
    85.041     0.890     0.200
    85.095     0.619     0.200
    85.123     0.976     0.200
    85.199     0.796     0.200
    85.199     0.587     0.200
    85.373     0.927     0.200
    85.414     0.825     0.200
    85.457     0.910     0.200
    85.463     0.581     0.200
    85.463     1.179     0.200
    85.472     0.832     0.200
    85.480     0.893     0.200
    85.619     0.824     0.200
    85.747     0.769     0.200
    85.986     0.285     0.200
    85.991     1.689     0.200
    86.813     0.315     0.200
    86.836     1.398     0.200
    87.168     0.304     0.200
    87.874     1.236     0.200
    87.874     0.892     0.200
    88.006     0.449     0.200
    92.300     0.617     0.200
    92.314    -0.035     0.200
    92.314     0.453     0.200
    93.408     1.594     0.200
    94.897    -0.531     0.200
    95.286     0.070     0.200
    95.667     0.514     0.200
    95.667     0.853     0.200
    17.276     0.881     0.200
    18.882    -1.428     0.200
    25.006    -0.318     0.200
    47.757     1.594     0.200
    50.180    -0.559     0.200
    54.531    -0.949     0.200
    56.302    -2.460     0.200
    64.386    -1.950     0.200
    64.747    -1.686     0.200
    64.747    -1.663     0.200
    64.844    -1.316     0.200
    65.746    -1.623     0.200
    65.945    -1.470     0.200
    69.115    -0.968     0.200
    74.947    -1.903     0.200
    85.440    -0.643     0.200
    14.283     7.102     0.200
    14.388     8.542     0.200
    14.611     8.773     0.200
    15.208     6.106     0.200
    15.834     3.211     0.200
    16.021     5.751     0.200
    16.188     2.714     0.200
    16.323     4.138     0.200
    17.332     0.654     0.200
    54.570    -0.635     0.200
    56.370    -2.619     0.200
    64.246    -0.967     0.200
    64.454    -1.753     0.200
    64.814    -1.359     0.200
    64.903    -0.808     0.200
    65.814    -1.429     0.200
    65.996    -1.536     0.200
    69.180    -0.423     0.200
    75.014    -1.657     0.200
    81.012     0.483     0.200
    84.288     0.415     0.200
    16.232     2.661     0.200
    16.751     1.207     0.200
    18.367    -2.349     0.200
    24.388     0.389     0.200
    45.394    -0.838     0.200
    47.200     2.759     0.200
    54.888    -1.238     0.200
    56.091    -1.318     0.200
    64.185    -1.639     0.200
    64.364    -1.189     0.200
    64.464    -0.554     0.200
    64.464    -1.179     0.200
    65.476    -1.051     0.200
    66.167    -1.436     0.200
    68.743    -0.298     0.200
    74.776    -0.852     0.200
    83.814     0.442     0.200
    22.355    -2.465     0.200
    24.707     1.085     0.200
    26.522    -2.149     0.200
    55.884    -0.499     0.200
    63.985    -0.891     0.200
    64.202    -0.533     0.200
    64.986    -0.076     0.200
    65.223    -0.235     0.200
    74.599    -0.533     0.200
    18.335    -1.662     0.200
    18.878    -1.251     0.200
    23.230    -2.598     0.200
    24.230    -0.092     0.200
    25.032     0.736     0.200
    32.873     3.695     0.200
    35.160     2.503     0.200
    42.232    -1.946     0.200
    44.737     0.980     0.200
    44.737     0.927     0.200
    46.939    -1.293     0.200
    47.637    -1.379     0.200
    47.833     1.977     0.200
    50.102     0.728     0.200
    54.445     0.515     0.200
    56.250    -1.649     0.200
    56.755    -0.321     0.200
    59.144    -0.514     0.200
    59.144    -1.062     0.200
    59.144    -0.398     0.200
    63.862     0.662     0.200
    64.001    -0.687     0.200
    64.110    -0.371     0.200
    64.332    -1.245     0.200
    64.332    -1.025     0.200
    64.703    -0.651     0.200
    64.703    -0.301     0.200
    64.765    -0.104     0.200
    64.964    -0.854     0.200
    65.701    -0.664     0.200
    65.861    -1.112     0.200
    65.861    -0.833     0.200
    65.861    -0.653     0.200
    65.972    -0.827     0.200
    69.083    -0.002     0.200
    70.522    -0.154     0.200
    71.110    -0.536     0.200
    71.747     0.118     0.200
    72.350     0.804     0.200
    72.350     0.452     0.200
    72.926     0.364     0.200
    73.383    -0.177     0.200
    74.473     3.284     0.200
    74.552    -0.077     0.200
    74.835    -0.918     0.200
    74.862    -0.973     0.200
    74.865    -0.888     0.200
    74.889    -0.842     0.200
    74.889    -0.982     0.200
    74.889    -0.832     0.200
    75.760    -1.338     0.200
    76.705     0.598     0.200
    76.995    -0.489     0.200
    77.503    -1.088     0.200
    77.976     0.823     0.200
    78.372     0.672     0.200
    78.372     0.587     0.200
    78.502     0.715     0.200
    78.673     0.612     0.200
    78.746     1.176     0.200
    79.359     0.870     0.200
    80.115     0.760     0.200
    80.906     0.718     0.200
    84.199     0.367     0.200
    84.199     0.258     0.200
    85.378     0.272     0.200
    85.387     0.376     0.200
    92.316    -0.134     0.200
    95.671     0.454     0.200
    29.149     0.871     0.200
    31.251     1.695     0.200
    31.327     1.338     0.200
    33.237     0.837     0.200
    46.157     0.946     0.200
    67.330    -1.011     0.200
    15.224     4.531     0.200
    17.594     2.243     0.200
    17.594     1.368     0.200
    18.278     0.949     0.200
    18.419    -2.318     0.200
    18.419    -1.863     0.200
    18.673    -0.379     0.200
    18.958    -2.624     0.200
    18.958    -1.778     0.200
    18.958    -2.159     0.200
    18.958    -1.204     0.200
    20.088    -0.198     0.200
    20.368     1.101     0.200
    20.652    -0.333     0.200
    21.117     0.377     0.200
    21.117    -1.195     0.200
    22.475    -2.575     0.200
    22.475    -2.079     0.200
    23.302    -2.572     0.200
    24.103     0.950     0.200
    24.103    -0.409     0.200
    24.103     1.206     0.200
    25.144     0.420     0.200
    26.192     1.334     0.200
    26.192     1.905     0.200
    26.493     2.163     0.200
    31.240     1.698     0.200
    31.298     1.229     0.200
    31.811     2.314     0.200
    32.350    -0.974     0.200
    33.240     1.947     0.200
    34.327    -0.230     0.200
    34.621     3.272     0.200
    35.201     1.589     0.200
    35.294     2.187     0.200
    35.294     2.526     0.200
    35.496     1.594     0.200
    35.573     1.856     0.200
    35.793     0.147     0.200
    35.986     3.294     0.200
    36.531     2.632     0.200
    37.053     2.170     0.200
    37.717     2.551     0.200
    37.709     0.904     0.200
    37.861     1.932     0.200
    38.118     1.689     0.200
    38.681     1.707     0.200
    38.836     0.174     0.200
    38.836     1.098     0.200
    39.912    -0.307     0.200
    41.594    -1.842     0.200
    42.116    -0.501     0.200
    42.511     0.154     0.200
    42.511     0.473     0.200
    43.155    -1.654     0.200
    43.275     0.348     0.200
    43.556     0.973     0.200
    44.365     0.368     0.200
    44.623    -0.950     0.200
    44.568     0.726     0.200
    44.604     2.159     0.200
    44.604     2.013     0.200
    44.793     0.602     0.200
    45.436    -1.172     0.200
    45.472     0.333     0.200
    45.752     2.443     0.200
    46.653    -0.878     0.200
    46.842     0.142     0.200
    46.931    -1.478     0.200
    46.931    -0.737     0.200
    47.265    -0.008     0.200
    47.650    -1.264     0.200
    47.650    -1.149     0.200
    48.276     0.068     0.200
    48.392     0.259     0.200
    48.904    -1.606     0.200
    49.276    -0.336     0.200
    49.632    -1.125     0.200
    49.632    -0.273     0.200
    49.973     1.930     0.200
    49.973     1.471     0.200
    50.305     0.105     0.200
    50.485    -0.076     0.200
    52.270     0.468     0.200
    52.116     1.574     0.200
    53.873    -0.192     0.200
    54.000     0.400     0.200
    54.000     1.189     0.200
    54.340     0.588     0.200
    54.662    -0.337     0.200
    55.188    -1.316     0.200
    56.026    -0.409     0.200
    56.252    -0.353     0.200
    56.254    -1.147     0.200
    56.254    -1.297     0.200
    56.324    -0.586     0.200
    56.639     3.261     0.200
    57.427    -1.072     0.200
    57.934    -0.977     0.200
    58.497    -0.836     0.200
    58.485    -0.960     0.200
    59.068     0.071     0.200
    59.068     0.199     0.200
    59.068     0.074     0.200
    59.323    -0.476     0.200
    59.487    -0.506     0.200
    59.684    -2.203     0.200
    59.712    -0.504     0.200
    61.261    -0.824     0.200
    62.589    -0.948     0.200
    62.834    -0.719     0.200
    63.011    -0.188     0.200
    63.066     1.368     0.200
    63.367    -0.140     0.200
    63.622    -0.792     0.200
    63.653    -0.771     0.200
    63.754     0.813     0.200
    63.928    -0.108     0.200
    63.928     0.431     0.200
    64.037     0.329     0.200
    64.333    -0.804     0.200
    64.334    -1.481     0.200
    64.334    -0.975     0.200
    64.468    -1.058     0.200
    64.671    -0.781     0.200
    64.724    -0.847     0.200
    64.724    -0.472     0.200
    64.705     0.402     0.200
    64.709    -0.157     0.200
    64.709     0.214     0.200
    64.876    -0.936     0.200
    64.927    -0.109     0.200
    64.937    -0.097     0.200
    64.922    -0.657     0.200
    65.042    -0.626     0.200
    65.597    -0.184     0.200
    65.718    -0.791     0.200
    65.779    -0.371     0.200
    65.779    -0.115     0.200
    66.037    -0.643     0.200
    66.037     0.017     0.200
    65.891     0.032     0.200
    65.891    -0.070     0.200
    66.071    -0.269     0.200
    65.958     1.359     0.200
    67.201     0.227     0.200
    67.287    -1.142     0.200
    67.351     0.421     0.200
    68.396    -0.605     0.200
    69.125     0.319     0.200
    69.392    -1.054     0.200
    70.218    -0.565     0.200
    70.352    -0.488     0.200
    70.352    -0.808     0.200
    71.059     0.017     0.200
    71.683     1.329     0.200
    71.729     1.007     0.200
    71.870    -0.706     0.200
    71.778     2.423     0.200
    71.854     0.920     0.200
    71.854     1.459     0.200
    71.947     1.228     0.200
    72.087     1.569     0.200
    72.274     1.584     0.200
    72.274     1.373     0.200
    72.520     1.177     0.200
    72.805     3.195     0.200
    73.008     1.757     0.200
    73.311     0.281     0.200
    73.935     1.334     0.200
    73.975     0.764     0.200
    74.527    -0.213     0.200
    74.885    -0.917     0.200
    74.885    -0.763     0.200
    74.885    -0.777     0.200
    74.892    -0.963     0.200
    74.892    -0.845     0.200
    74.892    -0.572     0.200
    74.995    -0.034     0.200
    75.083     0.015     0.200
    75.129     0.362     0.200
    75.243     0.544     0.200
    75.334     0.520     0.200
    75.359     0.479     0.200
    75.369     0.222     0.200
    75.414     0.262     0.200
    75.578     0.521     0.200
    75.577     0.527     0.200
    75.577     0.738     0.200
    75.859     0.614     0.200
    75.898     0.391     0.200
    75.979     0.527     0.200
    75.713     1.518     0.200
    75.713     2.110     0.200
    75.877     0.911     0.200
    76.166     0.212     0.200
    76.166    -0.038     0.200
    76.166     0.546     0.200
    76.166     0.350     0.200
    76.437     0.625     0.200
    76.624    -0.034     0.200
    76.624     0.677     0.200
    76.624     0.527     0.200
    76.724     1.001     0.200
    76.867    -0.107     0.200
    76.867     0.653     0.200
    76.975     0.984     0.200
    77.014    -0.084     0.200
    77.014     0.366     0.200
    77.086     1.361     0.200
    77.086     1.521     0.200
    76.991     0.955     0.200
    77.261     0.011     0.200
    77.456     0.485     0.200
    77.456     0.766     0.200
    77.499    -0.824     0.200
    77.568     0.960     0.200
    77.568     1.528     0.200
    77.634     0.844     0.200
    77.772     0.553     0.200
    77.702     0.830     0.200
    77.715     0.739     0.200
    77.992     0.988     0.200
    78.028     1.135     0.200
    78.028     0.498     0.200
    78.028     0.637     0.200
    78.086     0.957     0.200
    78.164     0.035     0.200
    78.192     0.153     0.200
    78.235     1.003     0.200
    78.228     0.967     0.200
    78.393     0.523     0.200
    78.395     0.494     0.200
    78.429     0.689     0.200
    78.504     0.903     0.200
    78.525     0.614     0.200
    78.662     0.904     0.200
    78.697     0.673     0.200
    78.766     1.201     0.200
    78.766     1.379     0.200
    79.106     0.254     0.200
    79.106     0.367     0.200
    79.158     1.141     0.200
    79.222     1.169     0.200
    79.225     1.013     0.200
    79.266     0.489     0.200
    79.377     1.013     0.200
    79.377     0.476     0.200
    79.377     0.784     0.200
    79.451     0.502     0.200
    79.605    -0.400     0.200
    79.681    -0.135     0.200
    79.681     0.856     0.200
    79.736     0.609     0.200
    79.832    -0.520     0.200
    79.859     0.299     0.200
    79.879     0.511     0.200
    79.878     0.409     0.200
    79.909     1.036     0.200
    79.903     0.860     0.200
    79.903     0.975     0.200
    80.086     0.875     0.200
    80.158     0.286     0.200
    80.192     0.947     0.200
    80.306     0.290     0.200
    80.306     0.396     0.200
    80.373     0.682     0.200
    80.405    -0.466     0.200
    80.401    -0.809     0.200
    80.461     0.591     0.200
    80.461     0.765     0.200
    80.457     0.331     0.200
    80.501     0.262     0.200
    80.561     1.427     0.200
    80.925     0.118     0.200
    81.023     0.291     0.200
    80.783     1.480     0.200
    81.139     0.317     0.200
    81.315    -1.276     0.200
    81.400    -0.109     0.200
    81.450    -0.873     0.200
    81.411    -0.096     0.200
    81.886     1.376     0.200
    81.865     0.437     0.200
    81.996     1.477     0.200
    82.084     0.385     0.200
    82.285    -0.160     0.200
    82.332    -0.213     0.200
    82.685     1.146     0.200
    82.748     0.020     0.200
    82.875     0.838     0.200
    82.875     1.248     0.200
    83.015     1.225     0.200
    83.049     0.057     0.200
    83.233     0.007     0.200
    83.206     2.407     0.200
    83.428     1.013     0.200
    83.470     1.413     0.200
    83.503    -0.485     0.200
    83.520     0.030     0.200
    83.520     0.268     0.200
    83.578     0.529     0.200
    83.763     0.079     0.200
    83.903     0.873     0.200
    84.018     0.639     0.200
    84.250     1.049     0.200
    84.179     1.597     0.200
    84.579     1.119     0.200
    84.629     0.935     0.200
    84.850     0.063     0.200
    85.158     1.506     0.200
    85.362     0.796     0.200
    85.914     1.304     0.200
    85.991     1.413     0.200
    95.554     1.776     0.200
    14.543     8.193     0.200
    15.183     6.285     0.200
    16.251     3.863     0.200
    18.847    -2.212     0.200
    24.204    -1.140     0.200
    32.897     2.672     0.200
    50.078     0.074     0.200
    54.406    -0.959     0.200
    56.203    -2.401     0.200
    64.064    -1.211     0.200
    64.286    -1.884     0.200
    64.659    -1.478     0.200
    64.659    -1.802     0.200
    64.718    -0.961     0.200
    65.656    -1.704     0.200
    65.816    -1.486     0.200
    74.842    -1.892     0.200
    80.876    -0.664     0.200
    17.223     0.415     0.200
    17.313     0.499     0.200
    18.188    -0.016     0.200
    18.733    -2.616     0.200
    18.733    -0.749     0.200
    20.843    -0.079     0.200
    22.244    -1.933     0.200
    22.244    -1.343     0.200
    23.093    -1.903     0.200
    23.845    -0.211     0.200
    24.357     0.044     0.200
    24.357    -1.195     0.200
    24.357    -0.495     0.200
    24.866    -0.254     0.200
    26.390    -1.022     0.200
    32.741     2.719     0.200
    34.158    -1.002     0.200
    35.008     0.884     0.200
    35.695    -1.954     0.200
    36.912    -0.585     0.200
    38.541    -0.287     0.200
    41.994    -1.030     0.200
    42.216    -0.157     0.200
    44.883     2.964     0.200
    47.695     1.054     0.200
    50.234     0.270     0.200
    54.525    -0.070     0.200
    56.180    -1.767     0.200
    56.858     1.828     0.200
    63.949    -0.651     0.200
    64.140    -0.698     0.200
    64.265    -1.350     0.200
    64.615    -1.018     0.200
    64.615    -0.764     0.200
    64.777    -0.849     0.200
    65.616    -1.259     0.200
    65.904    -1.229     0.200
    68.973    -1.225     0.200
    74.830    -1.101     0.200
    80.086     0.786     0.200
    81.022     1.013     0.200
    84.080     0.517     0.200
    85.331     0.488     0.200
    13.965    10.939     0.200
    14.381     7.878     0.200
    14.440     6.628     0.200
    14.451     6.437     0.200
    15.098     5.874     0.200
    15.226     3.461     0.200
    15.359     3.635     0.200
    15.552     3.713     0.200
    15.563     5.863     0.200
    15.701     2.547     0.200
    15.910     2.031     0.200
    16.667     2.362     0.200
    16.741     1.829     0.200
    18.322    -0.171     0.200
    20.576     0.732     0.200
    22.706    -2.105     0.200
    23.590     2.568     0.200
    24.252     1.018     0.200
    24.252     1.198     0.200
    24.373     0.957     0.200
    24.378    -0.297     0.200
    24.378    -1.446     0.200
    24.761     0.362     0.200
    24.761     0.159     0.200
    24.761    -0.036     0.200
    25.478    -1.356     0.200
    26.688     1.001     0.200
    30.525     1.589     0.200
    32.405     0.085     0.200
    34.539     3.386     0.200
    35.919    -0.968     0.200
    36.483     0.601     0.200
    36.973     1.037     0.200
    38.037     0.356     0.200
    41.091    -1.670     0.200
    41.712     0.803     0.200
    42.672    -1.120     0.200
    44.282     0.608     0.200
    45.338     0.637     0.200
    45.338     1.402     0.200
    45.338     1.134     0.200
    45.338     1.251     0.200
    45.625    -0.461     0.200
    46.507    -1.506     0.200
    46.507    -0.724     0.200
    46.533    -0.742     0.200
    46.738     0.859     0.200
    46.738    -0.532     0.200
    46.738    -0.844     0.200
    46.972    -0.085     0.200
    47.264     1.569     0.200
    47.355    -1.822     0.200
    47.711    -0.614     0.200
    48.455    -1.229     0.200
    48.744     2.268     0.200
    48.956    -0.098     0.200
    50.652     0.750     0.200
    50.884    -0.453     0.200
    51.330    -0.225     0.200
    51.483     0.296     0.200
    51.483     0.398     0.200
    51.524     0.533     0.200
    51.934     0.143     0.200
    52.245    -0.105     0.200
    52.365    -0.031     0.200
    52.380    -0.391     0.200
    52.514     0.910     0.200
    52.514    -0.731     0.200
    52.673     0.406     0.200
    52.822    -0.456     0.200
    52.993    -0.018     0.200
    53.137    -0.695     0.200
    53.688    -0.013     0.200
    53.781     0.123     0.200
    53.885    -0.308     0.200
    54.026    -0.383     0.200
    54.352    -0.199     0.200
    54.461     0.593     0.200
    54.461     0.405     0.200
    54.502    -0.523     0.200
    54.638    -0.068     0.200
    54.798     0.607     0.200
    54.798    -0.182     0.200
    55.137    -1.103     0.200
    55.251    -0.228     0.200
    55.432     0.581     0.200
    55.744    -0.932     0.200
    56.004    -0.929     0.200
    56.004    -1.554     0.200
    56.875    -0.247     0.200
    57.194     1.410     0.200
    59.315    -0.339     0.200
    59.315     0.075     0.200
    59.315    -0.159     0.200
    59.667    -0.339     0.200
    63.655     0.385     0.200
    63.758    -2.398     0.200
    64.039     0.064     0.200
    64.097    -0.965     0.200
    64.098    -0.221     0.200
    64.098    -0.753     0.200
    64.125     0.165     0.200
    64.156     0.035     0.200
    64.156    -0.551     0.200
    64.206    -0.128     0.200
    64.240     0.041     0.200
    64.265     0.024     0.200
    64.334    -0.125     0.200
    64.371    -0.123     0.200
    64.378     0.169     0.200
    64.384    -0.300     0.200
    64.384    -0.401     0.200
    64.563     0.163     0.200
    64.618    -1.037     0.200
    64.703     0.018     0.200
    64.769     0.483     0.200
    64.850    -0.445     0.200
    64.850    -0.046     0.200
    64.852     0.062     0.200
    64.852     0.437     0.200
    64.852    -0.047     0.200
    64.949    -0.525     0.200
    64.949    -0.689     0.200
    65.394    -0.329     0.200
    66.069    -0.929     0.200
    66.069    -0.522     0.200
    68.673     0.442     0.200
    70.972    -0.241     0.200
    71.142    -0.475     0.200
    72.123     0.660     0.200
    72.529     1.503     0.200
    73.259     1.563     0.200
    73.528    -0.510     0.200
    73.528    -0.072     0.200
    74.189     0.014     0.200
    74.631    -0.954     0.200
    74.636    -0.982     0.200
    74.658    -0.911     0.200
    74.662    -0.934     0.200
    74.686    -0.750     0.200
    74.694    -0.677     0.200
    74.694    -0.982     0.200
    74.694    -0.560     0.200
    74.680     3.863     0.200
    75.022     0.485     0.200
    75.058     0.879     0.200
    75.267    -0.223     0.200
    75.553     0.534     0.200
    75.713     0.516     0.200
    75.866     0.044     0.200
    76.108     0.668     0.200
    76.116     0.344     0.200
    76.245     0.586     0.200
    76.245     0.484     0.200
    76.283     0.870     0.200
    76.267     1.774     0.200
    76.316     0.488     0.200
    76.390     0.967     0.200
    76.514     1.660     0.200
    76.557    -0.185     0.200
    76.680     0.072     0.200
    76.717     1.014     0.200
    76.890    -0.065     0.200
    77.167     0.777     0.200
    77.167     1.152     0.200
    77.296    -0.767     0.200
    77.296    -0.345     0.200
    77.516     0.714     0.200
    77.676     0.985     0.200
    77.743     1.141     0.200
    77.961     0.087     0.200
    78.038     0.675     0.200
    78.076     0.956     0.200
    78.151     0.929     0.200
    78.151     1.453     0.200
    78.169     0.538     0.200
    78.428     0.900     0.200
    78.852     0.581     0.200
    78.898     0.741     0.200
    78.960     0.663     0.200
    79.049     0.799     0.200
    79.049     0.909     0.200
    79.073     0.528     0.200
    79.192     1.250     0.200
    79.445     0.711     0.200
    79.457     1.493     0.200
    79.601     0.547     0.200
    79.644     0.475     0.200
    79.644     0.201     0.200
    79.731     0.128     0.200
    79.817     1.153     0.200
    79.848     0.355     0.200
    79.899     0.442     0.200
    79.962     1.571     0.200
    79.963     0.178     0.200
    80.034     0.966     0.200
    80.034    -0.010     0.200
    80.043     0.587     0.200
    80.054     1.583     0.200
    80.054     0.184     0.200
    80.143     1.159     0.200
    80.143     0.105     0.200
    80.249     1.094     0.200
    80.667    -0.611     0.200
    80.768     0.679     0.200
    80.859     1.793     0.200
    80.863     0.745     0.200
    80.863     1.331     0.200
    81.315     0.434     0.200
    81.396     0.228     0.200
    81.396     0.908     0.200
    81.667    -0.684     0.200
    83.750     1.031     0.200
    83.787     2.130     0.200
    84.766     2.565     0.200
    85.226     0.183     0.200
    85.226     0.730     0.200
    85.782     1.720     0.200
    85.836     0.865     0.200
    16.036     1.915     0.200
    17.770     0.758     0.200
    23.663     1.303     0.200
    25.445     0.290     0.200
    31.643     3.444     0.200
    33.785     2.141     0.200
    46.079     0.279     0.200
    46.552     2.404     0.200
    51.350     0.792     0.200
    55.307     0.724     0.200
    55.844    -0.326     0.200
    57.789     2.731     0.200
    59.632    -0.392     0.200
    64.130     0.174     0.200
    65.071    -0.359     0.200
    65.156    -0.938     0.200
    66.425    -0.551     0.200
    68.304     0.350     0.200
    74.015     1.745     0.200
    76.431     0.163     0.200
    82.038     0.814     0.200
    19.983     0.220     0.200
    21.419    -1.436     0.200
    21.419    -1.596     0.200
    22.302    -1.417     0.200
    22.302    -1.810     0.200
    22.988     1.962     0.200
    23.411     1.820     0.200
    23.919     2.461     0.200
    24.007    -0.014     0.200
    24.007    -0.319     0.200
    24.370     1.451     0.200
    24.370     1.191     0.200
    24.370     1.800     0.200
    24.874     0.963     0.200
    24.874     0.178     0.200
    26.835     1.621     0.200
    29.336     2.702     0.200
    31.049     1.724     0.200
    31.049     2.263     0.200
    32.214     2.945     0.200
    33.447     2.568     0.200
    33.913     2.631     0.200
    34.334     1.767     0.200
    36.081     0.420     0.200
    36.671     1.654     0.200
    36.671     1.505     0.200
    36.744     2.309     0.200
    36.744     2.729     0.200
    37.727     0.482     0.200
    38.014    -0.117     0.200
    38.620     1.861     0.200
    38.816     0.170     0.200
    40.866     2.284     0.200
    40.866     1.694     0.200
    41.129     0.309     0.200
    41.404     0.732     0.200
    41.388     1.567     0.200
    41.388     1.987     0.200
    41.743     1.088     0.200
    44.372     2.477     0.200
    44.457     1.398     0.200
    44.943     0.475     0.200
    45.224    -0.442     0.200
    45.523     1.276     0.200
    45.522     0.619     0.200
    45.522     0.340     0.200
    45.523     1.086     0.200
    46.673     1.237     0.200
    46.673     1.417     0.200
    47.001    -1.017     0.200
    47.120     1.446     0.200
    47.120     1.325     0.200
    47.324    -0.199     0.200
    47.832     1.933     0.200
    47.932    -0.501     0.200
    49.073     0.736     0.200
    49.355    -0.195     0.200
    50.780     0.731     0.200
    50.780    -0.240     0.200
    51.224     0.178     0.200
    51.224     0.628     0.200
    52.706     0.662     0.200
    53.550    -0.193     0.200
    53.550    -0.523     0.200
    54.764     0.558     0.200
    55.664    -1.437     0.200
    55.662    -0.750     0.200
    57.225     3.599     0.200
    58.088     1.031     0.200
    59.165    -0.167     0.200
    63.758    -0.612     0.200
    63.710     0.535     0.200
    64.017    -0.690     0.200
    64.017    -0.914     0.200
    63.997     0.402     0.200
    64.106     0.052     0.200
    64.223    -0.241     0.200
    64.652     0.179     0.200
    64.701    -0.513     0.200
    65.031    -0.650     0.200
    65.941    -0.430     0.200
    65.941    -0.716     0.200
    68.284     0.087     0.200
    70.149     1.179     0.200
    70.916    -0.113     0.200
    73.128     1.900     0.200
    73.362     0.227     0.200
    73.446     2.883     0.200
    73.823    -0.832     0.200
    73.823    -0.142     0.200
    73.871     0.890     0.200
    74.294    -0.880     0.200
    74.358    -0.630     0.200
    74.358    -0.554     0.200
    74.366    -0.079     0.200
    74.366    -0.255     0.200
    74.410     0.752     0.200
    74.414     0.984     0.200
    74.907     0.826     0.200
    75.194     0.130     0.200
    75.719     0.482     0.200
    76.024     0.529     0.200
    76.198     0.751     0.200
    76.315     0.051     0.200
    76.430     1.442     0.200
    76.813     0.569     0.200
    76.967     0.277     0.200
    77.171     1.207     0.200
    77.315     0.760     0.200
    77.376     0.937     0.200
    77.623    -0.139     0.200
    77.667     1.068     0.200
    77.682     0.944     0.200
    77.706     1.249     0.200
    77.782     0.962     0.200
    77.782     0.763     0.200
    77.798     1.204     0.200
    77.789     0.362     0.200
    77.840     0.472     0.200
    77.965     1.076     0.200
    78.062     1.801     0.200
    78.524     1.449     0.200
    78.685     0.485     0.200
    78.685     1.126     0.200
    79.129     0.618     0.200
    79.553     0.715     0.200
    79.754     0.723     0.200
    79.887     0.613     0.200
    79.905     0.725     0.200
    80.741     1.564     0.200
    80.741     1.154     0.200
    81.467     0.902     0.200
    83.181     0.575     0.200
    83.353     0.305     0.200
    83.353     0.981     0.200
    84.917     1.055     0.200
    85.202     0.044     0.200
    96.693     0.837     0.200
    14.071     6.737     0.200
    14.366     7.145     0.200
    14.599     8.968     0.200
    14.623     8.995     0.200
    14.694     5.641     0.200
    14.925     8.783     0.200
    18.379    -1.165     0.200
    18.925    -1.211     0.200
    22.435    -1.586     0.200
    23.287    -1.520     0.200
    24.325     0.244     0.200
    24.325     0.365     0.200
    24.325     0.115     0.200
    25.036    -0.764     0.200
    25.036     0.986     0.200
    32.782    -0.278     0.200
    32.782     2.420     0.200
    35.092     1.476     0.200
    38.361     1.822     0.200
    38.375     2.228     0.200
    38.391     2.138     0.200
    38.487     1.988     0.200
    38.634     2.316     0.200
    45.907     2.561     0.200
    47.737    -2.506     0.200
    47.747    -0.342     0.200
    47.748     1.273     0.200
    47.748     1.558     0.200
    50.192     0.587     0.200
    52.085    -0.081     0.200
    54.561     0.574     0.200
    56.354    -1.775     0.200
    56.354    -1.910     0.200
    59.268    -0.631     0.200
    64.233    -0.644     0.200
    64.437    -1.113     0.200
    64.438    -1.109     0.200
    64.438    -1.474     0.200
    64.799    -0.906     0.200
    64.799    -0.906     0.200
    64.889    -0.219     0.200
    65.085    -0.759     0.200
    65.085    -1.476     0.200
    65.798    -1.212     0.200
    65.984    -0.113     0.200
    65.984    -0.658     0.200
    69.165    -0.251     0.200
    70.643    -0.642     0.200
    73.030     2.996     0.200
    74.998    -0.959     0.200
    74.998    -1.235     0.200
    76.608    -0.210     0.200
    77.091    -0.033     0.200
    80.233     0.239     0.200
    81.006     0.809     0.200
    81.006     0.269     0.200
    84.273     0.239     0.200
    85.491    -0.079     0.200
    85.491     0.191     0.200
    92.325    -0.649     0.200
    95.677    -0.096     0.200
    15.224     5.652     0.200
    20.281    -1.429     0.200
    21.099    -1.437     0.200
    23.130    -0.813     0.200
    23.139    -0.622     0.200
    23.139    -1.859     0.200
    23.196    -0.017     0.200
    25.039     1.098     0.200
    34.188     1.446     0.200
    34.188     0.706     0.200
    35.015     2.791     0.200
    37.156     0.290     0.200
    42.315     1.178     0.200
    46.897    -0.016     0.200
    47.183     0.236     0.200
    47.184     0.955     0.200
    47.184     0.371     0.200
    47.358     0.125     0.200
    47.413     0.140     0.200
    47.488     0.545     0.200
    47.551     0.249     0.200
    50.863    -0.004     0.200
    51.216    -0.388     0.200
    54.179     1.371     0.200
    56.827     1.845     0.200
    63.640     0.506     0.200
    65.095    -0.099     0.200
    69.842     1.018     0.200
    81.187     0.878     0.200
    17.039     1.377     0.200
    17.075     1.202     0.200
    17.639     1.115     0.200
    18.646    -1.366     0.200
    18.646    -1.246     0.200
    24.710     0.009     0.200
    24.710    -0.326     0.200
    24.585    -0.803     0.200
    24.585     0.462     0.200
    34.784     2.933     0.200
    34.784    -0.027     0.200
    47.466     1.873     0.200
    47.466     0.318     0.200
    64.926    -0.220     0.200
    65.641    -1.007     0.200
    66.083    -0.648     0.200
    68.957    -0.034     0.200
    74.893    -0.990     0.200
    74.893    -0.785     0.200
    81.247    -0.064     0.200
    16.923     2.277     0.200
    23.116     1.261     0.200
    25.135    -0.429     0.200
    51.061     0.763     0.200
    65.586    -0.004     0.200
    81.599     1.206     0.200
    82.366     0.521     0.200
    15.969     2.300     0.200
    16.407     2.862     0.200
    16.671     1.368     0.200
    18.219     0.440     0.200
    19.568     0.102     0.200
    20.790    -0.513     0.200
    20.790     0.057     0.200
    21.136    -0.474     0.200
    22.080    -1.537     0.200
    22.080    -1.393     0.200
    23.576    -0.856     0.200
    24.931    -0.441     0.200
    24.931    -0.941     0.200
    25.426     1.301     0.200
    25.433    -0.808     0.200
    25.433    -1.158     0.200
    25.433    -1.008     0.200
    25.882     1.707     0.200
    25.895    -1.091     0.200
    26.271     0.107     0.200
    26.272     1.295     0.200
    26.272     1.613     0.200
    27.193    -0.399     0.200
    27.193    -1.200     0.200
    27.193     0.171     0.200
    27.193    -0.790     0.200
    27.332     0.052     0.200
    28.045     0.957     0.200
    28.771     1.939     0.200
    28.771     2.558     0.200
    28.861     0.815     0.200
    29.346     2.480     0.200
    30.048     2.684     0.200
    30.048     1.944     0.200
    30.482     1.555     0.200
    30.482     1.955     0.200
    30.623     0.663     0.200
    30.880     1.073     0.200
    31.132     2.622     0.200
    31.129    -0.804     0.200
    31.129     0.648     0.200
    31.656     2.008     0.200
    31.656     2.258     0.200
    31.805     2.355     0.200
    31.801     0.132     0.200
    31.801     1.341     0.200
    32.189     3.122     0.200
    32.514     1.858     0.200
    32.881     1.798     0.200
    32.881     2.818     0.200
    33.346     2.822     0.200
    33.364     1.675     0.200
    33.545     3.271     0.200
    33.545     2.151     0.200
    33.553     2.098     0.200
    33.553     2.389     0.200
    33.768     1.233     0.200
    33.768     1.282     0.200
    33.768     0.272     0.200
    33.853     2.194     0.200
    33.897    -1.090     0.200
    33.897    -0.641     0.200
    34.104     3.522     0.200
    34.249     3.646     0.200
    34.711    -0.943     0.200
    34.760     0.735     0.200
    34.903    -1.695     0.200
    35.431     2.342     0.200
    35.493     3.832     0.200
    35.781     0.992     0.200
    35.864     2.209     0.200
    36.017     0.433     0.200
    36.080     0.216     0.200
    36.113     1.311     0.200
    36.194     0.713     0.200
    36.194     1.653     0.200
    36.299    -1.580     0.200
    36.299    -0.939     0.200
    36.299    -2.259     0.200
    36.299    -1.218     0.200
    36.767    -1.070     0.200
    36.811     0.257     0.200
    36.811    -0.444     0.200
    36.929     1.186     0.200
    37.209     0.400     0.200
    37.209     0.775     0.200
    37.311    -0.846     0.200
    37.311    -0.446     0.200
    37.311    -1.106     0.200
    37.618     2.286     0.200
    37.950     1.628     0.200
    37.950     2.737     0.200
    38.054     1.156     0.200
    38.054     1.996     0.200
    38.188    -0.401     0.200
    38.213    -0.136     0.200
    38.287    -0.191     0.200
    38.287     0.860     0.200
    38.579     0.007     0.200
    38.579     0.257     0.200
    38.581    -0.006     0.200
    38.581    -0.147     0.200
    39.132     0.732     0.200
    39.132     1.673     0.200
    39.132     3.562     0.200
    39.260     1.157     0.200
    39.403     1.562     0.200
    39.575    -0.022     0.200
    39.575     0.297     0.200
    39.576     0.072     0.200
    39.576    -0.428     0.200
    39.576     0.502     0.200
    39.576    -0.809     0.200
    40.308     2.465     0.200
    40.308     2.246     0.200
    40.553    -1.064     0.200
    40.582    -0.642     0.200
    40.582    -0.270     0.200
    40.766    -0.370     0.200
    40.766    -0.140     0.200
    40.822     0.047     0.200
    40.822     2.137     0.200
    40.822     1.498     0.200
    40.822     2.258     0.200
    40.884    -0.333     0.200
    40.884     0.956     0.200
    40.954    -0.818     0.200
    41.191    -0.481     0.200
    41.337    -1.094     0.200
    41.568     0.017     0.200
    41.568    -0.233     0.200
    41.568    -0.453     0.200
    41.970     0.276     0.200
    41.970    -0.954     0.200
    41.994     0.814     0.200
    42.100    -0.330     0.200
    42.100     0.339     0.200
    42.310     0.166     0.200
    42.728     2.416     0.200
    42.935    -0.491     0.200
    42.935     0.579     0.200
    43.215     0.104     0.200
    43.233    -2.033     0.200
    43.358     0.983     0.200
    43.358     2.885     0.200
    43.424    -0.522     0.200
    43.424    -0.672     0.200
    43.597    -0.168     0.200
    43.605     0.672     0.200
    43.672     0.434     0.200
    43.672    -0.136     0.200
    43.686    -0.071     0.200
    43.748     0.407     0.200
    43.807     1.372     0.200
    43.807     1.593     0.200
    43.810     1.762     0.200
    43.852    -0.164     0.200
    44.271     0.574     0.200
    44.344     3.442     0.200
    44.344     2.772     0.200
    44.344     1.692     0.200
    44.491    -1.531     0.200
    44.491    -1.371     0.200
    44.491    -1.457     0.200
    44.686    -0.964     0.200
    44.683    -0.367     0.200
    44.717    -0.298     0.200
    45.221    -0.947     0.200
    45.239    -0.490     0.200
    45.378     0.262     0.200
    45.378     0.482     0.200
    45.417    -0.821     0.200
    45.417     0.388     0.200
    45.417     0.179     0.200
    45.544    -0.803     0.200
    45.544    -1.203     0.200
    46.013    -1.110     0.200
    46.049    -0.909     0.200
    46.049    -0.670     0.200
    46.049    -0.789     0.200
    46.058     0.473     0.200
    46.089     0.244     0.200
    46.089     0.494     0.200
    46.089     0.191     0.200
    46.089     0.570     0.200
    46.089    -0.240     0.200
    46.089    -0.000     0.200
    46.089     0.531     0.200
    46.174     0.487     0.200
    46.174     0.122     0.200
    46.174    -0.099     0.200
    46.192     1.184     0.200
    46.192    -0.445     0.200
    46.192     0.885     0.200
    46.192     0.104     0.200
    46.192     1.395     0.200
    46.483     0.535     0.200
    46.556     1.420     0.200
    46.780    -0.684     0.200
    46.826     0.523     0.200
    47.002    -0.063     0.200
    47.002    -0.692     0.200
    47.002     0.699     0.200
    47.002    -0.381     0.200
    47.029    -0.335     0.200
    47.029    -0.638     0.200
    47.038    -0.745     0.200
    47.240     0.478     0.200
    47.240    -0.272     0.200
    47.240     0.179     0.200
    47.273     2.569     0.200
    47.273     1.839     0.200
    47.273     2.038     0.200
    47.422     1.767     0.200
    47.422     0.767     0.200
    47.422     0.347     0.200
    47.587     1.458     0.200
    47.587     1.948     0.200
    47.587     2.438     0.200
    47.576    -1.063     0.200
    47.607     1.123     0.200
    47.607     0.123     0.200
    47.614    -0.130     0.200
    47.614    -0.820     0.200
    47.614    -0.271     0.200
    47.614    -1.101     0.200
    47.766    -0.705     0.200
    47.766    -1.596     0.200
    47.899     0.164     0.200
    47.971    -0.892     0.200
    47.971    -0.594     0.200
    48.195     0.102     0.200
    48.333    -0.090     0.200
    48.475     0.842     0.200
    48.511    -0.336     0.200
    48.511     0.703     0.200
    48.555     0.146     0.200
    48.555     1.498     0.200
    48.555    -0.162     0.200
    48.589     0.833     0.200
    48.723    -1.045     0.200
    48.744    -0.553     0.200
    48.950    -0.709     0.200
    49.541     0.685     0.200
    49.808     0.193     0.200
    49.907     0.840     0.200
    50.066    -0.924     0.200
    50.066    -0.684     0.200
    50.102     0.630     0.200
    50.526    -0.896     0.200
    50.572     2.123     0.200
    50.572     0.842     0.200
    50.578     0.781     0.200
    50.578     0.531     0.200
    50.578     1.082     0.200
    50.578     0.971     0.200
    50.673    -0.237     0.200
    50.679     0.018     0.200
    50.739     0.667     0.200
    50.739     0.368     0.200
    50.753    -0.347     0.200
    50.818    -0.333     0.200
    50.927    -0.652     0.200
    51.004    -0.424     0.200
    51.004     0.076     0.200
    51.073    -0.853     0.200
    51.204     2.304     0.200
    51.342    -0.160     0.200
    51.342     0.539     0.200
    51.368     0.209     0.200
    51.402     0.969     0.200
    51.623    -1.567     0.200
    51.623    -0.817     0.200
    51.623    -2.298     0.200
    51.820    -0.236     0.200
    51.820     1.062     0.200
    52.016     0.203     0.200
    52.016     0.703     0.200
    52.016    -0.496     0.200
    52.016    -0.026     0.200
    52.016     0.564     0.200
    52.020    -1.279     0.200
    52.128     0.689     0.200
    52.275     2.158     0.200
    52.391     0.220     0.200
    52.391     0.919     0.200
    52.469     1.019     0.200
    52.497    -0.166     0.200
    52.521    -0.347     0.200
    52.527     0.588     0.200
    52.567     1.216     0.200
    52.567     0.066     0.200
    52.567     1.415     0.200
    52.567     0.656     0.200
    52.739     0.710     0.200
    52.756    -0.535     0.200
    52.756     0.506     0.200
    52.812     2.465     0.200
    52.812     1.156     0.200
    52.812     2.865     0.200
    52.801    -0.716     0.200
    52.801    -0.415     0.200
    52.959    -0.605     0.200
    52.959    -0.367     0.200
    53.094    -0.379     0.200
    53.233     0.498     0.200
    53.309    -1.192     0.200
    53.378    -1.235     0.200
    53.655    -1.097     0.200
    53.766    -0.612     0.200
    53.766     0.155     0.200
    53.766    -0.894     0.200
    53.766     0.397     0.200
    53.784    -1.046     0.200
    54.073    -0.725     0.200
    54.168     0.145     0.200
    54.168    -0.246     0.200
    54.168     0.555     0.200
    54.298     0.547     0.200
    54.720     0.019     0.200
    54.853    -0.124     0.200
    54.919    -0.501     0.200
    54.919     0.025     0.200
    54.919    -0.132     0.200
    54.931     0.310     0.200
    55.041    -0.902     0.200
    55.038    -1.138     0.200
    55.069     0.017     0.200
    55.069    -0.214     0.200
    55.069     0.626     0.200
    55.251    -0.099     0.200
    55.470    -0.384     0.200
    55.470    -1.304     0.200
    55.470    -1.440     0.200
    55.470    -1.764     0.200
    55.646    -0.758     0.200
    55.722    -1.295     0.200
    55.722    -1.308     0.200
    55.722    -0.385     0.200
    55.734    -0.902     0.200
    55.925     0.360     0.200
    55.940    -0.242     0.200
    56.146     1.683     0.200
    56.146     0.652     0.200
    56.146     1.872     0.200
    56.219    -0.595     0.200
    56.276    -1.348     0.200
    56.911     3.441     0.200
    56.967     0.740     0.200
    57.009    -1.256     0.200
    57.009    -0.497     0.200
    57.009    -0.256     0.200
    57.009    -0.897     0.200
    57.029    -1.804     0.200
    57.198    -0.645     0.200
    57.199     1.004     0.200
    57.407    -1.367     0.200
    57.751     0.011     0.200
    57.801    -0.641     0.200
    57.801    -0.501     0.200
    57.834    -1.122     0.200
    58.008     0.905     0.200
    58.008     0.475     0.200
    58.008    -0.394     0.200
    58.199     0.275     0.200
    58.323     2.416     0.200
    58.420    -0.820     0.200
    58.630     0.164     0.200
    58.645    -0.919     0.200
    58.696    -0.594     0.200
    58.742    -0.611     0.200
    58.930     0.277     0.200
    58.930    -0.223     0.200
    58.930     0.078     0.200
    59.021    -2.061     0.200
    59.032    -0.668     0.200
    59.546    -2.251     0.200
    59.546    -0.092     0.200
    59.546    -0.608     0.200
    59.546     0.418     0.200
    59.609     0.984     0.200
    60.040     0.419     0.200
    60.040     0.178     0.200
    60.179    -0.932     0.200
    60.179    -0.643     0.200
    60.232    -0.206     0.200
    60.232    -0.395     0.200
    60.232     0.644     0.200
    60.340     0.069     0.200
    60.563    -0.972     0.200
    60.673    -1.008     0.200
    61.142     0.259     0.200
    61.663     0.526     0.200
    61.962     0.877     0.200
    61.993     0.166     0.200
    62.151    -0.134     0.200
    62.191     2.638     0.200
    62.250    -0.455     0.200
    62.276    -0.967     0.200
    62.393     0.397     0.200
    62.393     1.045     0.200
    62.546    -1.444     0.200
    62.878    -0.859     0.200
    63.012    -0.648     0.200
    63.127    -1.320     0.200
    63.419     0.323     0.200
    63.520    -1.076     0.200
    63.535    -0.205     0.200
    63.589    -1.059     0.200
    63.774    -0.578     0.200
    63.789     0.269     0.200
    63.826    -0.625     0.200
    63.985    -0.064     0.200
    64.006     0.393     0.200
    64.006    -0.463     0.200
    64.055    -0.130     0.200
    64.179    -0.031     0.200
    64.183     0.454     0.200
    64.236    -0.404     0.200
    64.248     1.906     0.200
    64.248    -0.330     0.200
    64.248     1.596     0.200
    64.247     0.010     0.200
    64.328    -0.997     0.200
    64.367    -0.277     0.200
    64.367     0.375     0.200
    64.367    -0.806     0.200
    64.477    -0.641     0.200
    64.535    -1.071     0.200
    64.549     1.137     0.200
    64.689    -0.376     0.200
    64.808     0.247     0.200
    64.808    -0.893     0.200
    64.816     0.594     0.200
    64.950    -0.776     0.200
    64.950     0.173     0.200
    64.974    -0.434     0.200
    64.976    -0.745     0.200
    64.976     0.255     0.200
    65.033    -0.396     0.200
    65.077    -0.512     0.200
    65.162     0.098     0.200
    65.282     0.115     0.200
    65.293     0.044     0.200
    65.293     0.576     0.200
    65.293     0.445     0.200
    65.308     0.099     0.200
    65.347    -0.154     0.200
    65.347    -0.593     0.200
    65.385    -0.551     0.200
    65.435    -1.820     0.200
    65.475    -0.079     0.200
    65.475    -0.219     0.200
    65.485     0.429     0.200
    65.586     0.204     0.200
    65.586    -0.835     0.200
    65.692    -2.072     0.200
    65.840     0.162     0.200
    65.868     0.092     0.200
    65.917    -0.129     0.200
    65.992     1.688     0.200
    65.990     0.067     0.200
    66.004    -0.839     0.200
    66.004     0.450     0.200
    66.039     0.881     0.200
    66.039    -0.708     0.200
    66.158     3.019     0.200
    66.160     0.816     0.200
    66.251    -0.141     0.200
    66.251     0.009     0.200
    66.344    -0.475     0.200
    66.344    -0.360     0.200
    66.450    -0.542     0.200
    66.590     0.654     0.200
    66.587    -0.458     0.200
    66.587     0.583     0.200
    66.607     0.638     0.200
    66.661     1.101     0.200
    66.747    -0.241     0.200
    66.795    -1.055     0.200
    66.795    -1.915     0.200
    66.795    -0.565     0.200
    66.854     0.368     0.200
    66.854     0.497     0.200
    66.945     0.011     0.200
    66.992     0.033     0.200
    67.028     0.000     0.200
    67.178     0.160     0.200
    67.520    -0.091     0.200
    67.531     0.035     0.200
    67.549     1.021     0.200
    67.675    -0.213     0.200
    67.680    -1.844     0.200
    67.679    -0.306     0.200
    67.734     1.297     0.200
    67.734     1.596     0.200
    67.734     0.217     0.200
    67.867     1.439     0.200
    67.883    -2.166     0.200
    67.961     1.305     0.200
    67.961     0.354     0.200
    68.116    -1.017     0.200
    68.182     0.058     0.200
    68.182     0.183     0.200
    68.191     0.965     0.200
    68.191     0.075     0.200
    68.229    -0.022     0.200
    68.396     0.333     0.200
    68.440     0.766     0.200
    68.702    -0.362     0.200
    68.816     0.523     0.200
    68.842     0.260     0.200
    68.896    -1.229     0.200
    68.911     1.300     0.200
    68.911    -0.120     0.200
    68.936     0.472     0.200
    68.936    -0.098     0.200
    68.945    -0.343     0.200
    68.972     0.050     0.200
    68.972     0.528     0.200
    69.005    -2.197     0.200
    69.003    -0.083     0.200
    69.057    -0.031     0.200
    69.097     0.216     0.200
    69.134     0.215     0.200
    69.305     0.584     0.200
    69.320     0.731     0.200
    69.400     0.190     0.200
    69.414     1.778     0.200
    69.414    -0.202     0.200
    69.427     1.041     0.200
    69.442    -0.123     0.200
    69.459     0.816     0.200
    69.520    -0.342     0.200
    69.533    -1.025     0.200
    69.533     0.065     0.200
    69.533    -0.324     0.200
    69.533     0.236     0.200
    69.671     0.022     0.200
    69.681     0.311     0.200
    69.681     1.155     0.200
    69.681    -0.074     0.200
    69.706    -1.444     0.200
    69.708     0.429     0.200
    69.725     0.594     0.200
    69.739     0.259     0.200
    69.754     0.246     0.200
    69.772    -0.601     0.200
    69.821    -0.270     0.200
    69.821     0.740     0.200
    69.879     0.787     0.200
    69.967    -0.118     0.200
    69.967     0.032     0.200
    70.089     0.193     0.200
    70.102     0.663     0.200
    70.102     0.972     0.200
    70.102     0.773     0.200
    70.153     0.183     0.200
    70.153    -0.750     0.200
    70.153     1.410     0.200
    70.155    -1.699     0.200
    70.199    -0.038     0.200
    70.199     1.074     0.200
    70.209     0.672     0.200
    70.209     0.821     0.200
    70.209     1.411     0.200
    70.271    -1.458     0.200
    70.265     1.365     0.200
    70.265    -0.115     0.200
    70.304    -1.742     0.200
    70.356    -1.087     0.200
    70.413     1.319     0.200
    70.407     1.489     0.200
    70.407     0.810     0.200
    70.447     0.167     0.200
    70.447     0.058     0.200
    70.494     1.378     0.200
    70.490    -0.199     0.200
    70.497     1.711     0.200
    70.497     0.323     0.200
    70.519     0.926     0.200
    70.532     1.449     0.200
    70.542     0.307     0.200
    70.596     1.654     0.200
    70.662     2.253     0.200
    70.665     0.834     0.200
    70.721     0.092     0.200
    70.737     2.106     0.200
    70.739     0.687     0.200
    70.775    -1.332     0.200
    70.819     0.700     0.200
    70.883     0.012     0.200
    70.951     0.227     0.200
    70.972     0.769     0.200
    70.971     1.307     0.200
    70.971     0.288     0.200
    70.984     0.396     0.200
    71.012     0.729     0.200
    71.027     0.674     0.200
    71.200     0.080     0.200
    71.200     0.366     0.200
    71.212    -0.603     0.200
    71.250     1.339     0.200
    71.250     0.008     0.200
    71.327    -0.812     0.200
    71.379     0.904     0.200
    71.386     0.665     0.200
    71.329     1.208     0.200
    71.438     0.268     0.200
    71.469     1.941     0.200
    71.530     0.585     0.200
    71.621     0.137     0.200
    71.774    -1.071     0.200
    71.780     0.418     0.200
    71.834     0.160     0.200
    71.915    -0.230     0.200
    72.005     0.819     0.200
    72.025    -0.360     0.200
    72.093     2.111     0.200
    72.091     0.547     0.200
    72.148     0.585     0.200
    72.169     1.470     0.200
    72.169     0.150     0.200
    72.240    -0.866     0.200
    72.231     1.329     0.200
    72.344     1.806     0.200
    72.371     0.410     0.200
    72.375     0.912     0.200
    72.422     1.026     0.200
    72.443     1.060     0.200
    72.549    -0.082     0.200
    72.697     3.121     0.200
    72.684     1.301     0.200
    72.684     1.430     0.200
    72.687     0.806     0.200
    72.694     1.271     0.200
    72.766     0.480     0.200
    72.766     0.865     0.200
    72.766     1.260     0.200
    72.783     2.000     0.200
    72.779     0.686     0.200
    72.801     0.030     0.200
    72.809    -1.053     0.200
    72.822     1.281     0.200
    72.822     0.272     0.200
    72.848     1.087     0.200
    72.848     0.274     0.200
    72.859     0.157     0.200
    72.905     0.187     0.200
    72.954     0.919     0.200
    72.971     1.847     0.200
    72.988    -0.555     0.200
    73.027     1.476     0.200
    73.027     0.707     0.200
    73.111    -1.039     0.200
    73.114     0.779     0.200
    73.118     1.525     0.200
    73.129     1.073     0.200
    73.132     1.035     0.200
    73.166    -0.276     0.200
    73.180     2.650     0.200
    73.342    -0.707     0.200
    73.379     1.234     0.200
    73.511     0.230     0.200
    73.528     1.289     0.200
    73.596    -0.141     0.200
    73.638     0.653     0.200
    73.724    -0.052     0.200
    73.740     0.065     0.200
    73.798     0.174     0.200
    73.813    -0.475     0.200
    73.839     1.060     0.200
    73.877     0.152     0.200
    73.939     0.720     0.200
    73.954     0.401     0.200
    73.959     0.543     0.200
    73.959     0.793     0.200
    73.983     0.832     0.200
    73.990     0.463     0.200
    73.994     0.608     0.200
    74.013     2.258     0.200
    74.066     0.764     0.200
    74.060     0.382     0.200
    74.073     0.308     0.200
    74.084     0.401     0.200
    74.104     0.384     0.200
    74.130     0.392     0.200
    74.180     1.519     0.200
    74.211     0.200     0.200
    74.295     0.424     0.200
    74.296     1.090     0.200
    74.296     0.215     0.200
    74.296    -1.195     0.200
    74.315     0.045     0.200
    74.325     0.027     0.200
    74.325     0.197     0.200
    74.387    -0.626     0.200
    74.391     0.365     0.200
    74.397    -0.581     0.200
    74.401    -0.606     0.200
    74.431    -0.562     0.200
    74.440    -0.533     0.200
    74.453    -0.883     0.200
    74.453    -0.708     0.200
    74.453    -1.008     0.200
    74.453    -0.608     0.200
    74.461    -1.162     0.200
    74.461    -0.951     0.200
    74.461    -0.652     0.200
    74.464    -0.472     0.200
    74.537     0.604     0.200
    74.571     0.957     0.200
    74.632     1.552     0.200
    74.671     0.829     0.200
    74.672     0.409     0.200
    74.708     0.912     0.200
    74.725     0.613     0.200
    74.745     1.468     0.200
    74.737     0.643     0.200
    74.750     0.769     0.200
    74.750     0.230     0.200
    74.853     0.975     0.200
    74.853     1.084     0.200
    74.907     0.721     0.200
    74.907     0.859     0.200
    74.907     0.590     0.200
    74.918     0.798     0.200
    74.918     0.608     0.200
    74.971     2.693     0.200
    74.996     0.085     0.200
    75.066    -0.639     0.200
    75.127     0.793     0.200
    75.127     0.023     0.200
    75.147     2.875     0.200
    75.147     3.577     0.200
    75.147     1.526     0.200
    75.208     0.828     0.200
    75.208     0.418     0.200
    75.208     0.826     0.200
    75.208     0.375     0.200
    75.233     0.032     0.200
    75.246     3.771     0.200
    75.237     0.458     0.200
    75.250     1.026     0.200
    75.301    -0.810     0.200
    75.313     1.292     0.200
    75.314     1.117     0.200
    75.314     1.277     0.200
    75.376     0.558     0.200
    75.482     0.352     0.200
    75.519     3.539     0.200
    75.528     0.758     0.200
    75.528    -0.111     0.200
    75.528     0.287     0.200
    75.536     0.846     0.200
    75.536     1.145     0.200
    75.637     0.714     0.200
    75.699     0.700     0.200
    75.719     0.394     0.200
    75.740     0.775     0.200
    75.762     0.537     0.200
    75.779     0.954     0.200
    75.922     0.914     0.200
    75.939     1.037     0.200
    75.942     0.624     0.200
    75.942     0.134     0.200
    75.947     0.095     0.200
    75.964     0.546     0.200
    75.969     0.750     0.200
    75.969     0.070     0.200
    75.969     0.330     0.200
    76.016    -0.200     0.200
    76.016     0.800     0.200
    76.068     0.951     0.200
    76.080     0.634     0.200
    76.080     0.275     0.200
    76.074     0.569     0.200
    76.074    -0.091     0.200
    76.074     1.350     0.200
    76.074     1.460     0.200
    76.123     2.689     0.200
    76.123     1.089     0.200
    76.123     1.650     0.200
    76.137     1.812     0.200
    76.137     0.353     0.200
    76.137     0.513     0.200
    76.137     0.140     0.200
    76.167     0.552     0.200
    76.185    -0.251     0.200
    76.193     1.893     0.200
    76.208     0.607     0.200
    76.208     0.007     0.200
    76.208     0.116     0.200
    76.308     0.168     0.200
    76.335     0.366     0.200
    76.364     0.524     0.200
    76.415     1.932     0.200
    76.421     1.768     0.200
    76.438     0.206     0.200
    76.438     1.167     0.200
    76.441     0.186     0.200
    76.441     0.335     0.200
    76.449     1.239     0.200
    76.449     1.499     0.200
    76.466     4.006     0.200
    76.507     1.711     0.200
    76.730     0.551     0.200
    76.730     1.211     0.200
    76.726     0.877     0.200
    76.871     0.758     0.200
    76.924     1.958     0.200
    76.924     1.017     0.200
    76.942     0.258     0.200
    76.981     0.739     0.200
    77.013     0.157     0.200
    77.013     0.026     0.200
    77.058    -0.494     0.200
    77.061     0.797     0.200
    77.088     1.734     0.200
    77.151     0.446     0.200
    77.192    -0.346     0.200
    77.223     0.588     0.200
    77.240     0.465     0.200
    77.262     1.060     0.200
    77.322     0.724     0.200
    77.330    -0.086     0.200
    77.330     0.289     0.200
    77.361     0.572     0.200
    77.385     1.140     0.200
    77.425     1.108     0.200
    77.425     1.838     0.200
    77.431     1.482     0.200
    77.431     0.233     0.200
    77.431     0.954     0.200
    77.455     0.352     0.200
    77.459     0.594     0.200
    77.510     2.459     0.200
    77.555     0.320     0.200
    77.556     2.224     0.200
    77.567     1.705     0.200
    77.566     0.964     0.200
    77.586     0.348     0.200
    77.592     0.915     0.200
    77.592     1.454     0.200
    77.605     0.367     0.200
    77.605     0.650     0.200
    77.638     1.157     0.200
    77.641     0.359     0.200
    77.666     0.692     0.200
    77.669     1.536     0.200
    77.683     0.312     0.200
    77.693     0.567     0.200
    77.693     0.409     0.200
    77.702     0.638     0.200
    77.751     1.207     0.200
    77.759     0.795     0.200
    77.834     0.675     0.200
    77.834     2.106     0.200
    77.854     0.755     0.200
    77.854     1.534     0.200
    77.880     1.779     0.200
    77.894     0.852     0.200
    77.935     0.711     0.200
    77.977     2.171     0.200
    77.972     1.232     0.200
    77.972     2.277     0.200
    77.987     1.518     0.200
    77.985     0.623     0.200
    77.985     0.834     0.200
    78.013     0.801     0.200
    78.048     0.237     0.200
    78.050     0.641     0.200
    78.050     1.075     0.200
    78.079     0.764     0.200
    78.135     0.947     0.200
    78.172     1.691     0.200
    78.200     1.681     0.200
    78.243     1.504     0.200
    78.298     1.372     0.200
    78.313     0.522     0.200
    78.330     0.228     0.200
    78.342     1.365     0.200
    78.355     0.579     0.200
    78.370     1.202     0.200
    78.500    -0.735     0.200
    78.500     0.765     0.200
    78.518     1.078     0.200
    78.518     1.877     0.200
    78.518     0.277     0.200
    78.518     0.537     0.200
    78.518     0.977     0.200
    78.518     0.787     0.200
    78.514     0.068     0.200
    78.536     0.519     0.200
    78.552     1.591     0.200
    78.561     1.360     0.200
    78.561     0.899     0.200
    78.574     0.645     0.200
    78.628     1.523     0.200
    78.629    -0.035     0.200
    78.681     0.284     0.200
    78.681     0.636     0.200
    78.740     1.353     0.200
    78.754     0.839     0.200
    78.750     0.678     0.200
    78.750    -0.144     0.200
    78.811     0.963     0.200
    78.811     1.963     0.200
    78.880     0.786     0.200
    78.923     0.250     0.200
    78.936     1.077     0.200
    78.977     1.950     0.200
    79.002     1.114     0.200
    79.006     0.517     0.200
    79.006     2.642     0.200
    79.057     0.916     0.200
    79.057     0.617     0.200
    79.111     1.278     0.200
    79.116     1.063     0.200
    79.116     0.294     0.200
    79.116     0.182     0.200
    79.171     1.259     0.200
    79.171     1.800     0.200
    79.186     1.912     0.200
    79.190     1.457     0.200
    79.220     1.593     0.200
    79.222     1.583     0.200
    79.222     2.313     0.200
    79.222     2.803     0.200
    79.229     1.974     0.200
    79.266     0.621     0.200
    79.266     1.958     0.200
    79.330     0.534     0.200
    79.335     1.623     0.200
    79.357     1.164     0.200
    79.370     1.893     0.200
    79.391     1.422     0.200
    79.394     0.563     0.200
    79.392     0.720     0.200
    79.410     0.676     0.200
    79.432     1.526     0.200
    79.454     0.946     0.200
    79.467     1.433     0.200
    79.482     1.789     0.200
    79.525     0.571     0.200
    79.531     1.332     0.200
    79.533     1.304     0.200
    79.604     1.855     0.200
    79.629     1.455     0.200
    79.635    -0.339     0.200
    79.672     0.799     0.200
    79.673     1.283     0.200
    79.678     1.444     0.200
    79.700    -0.092     0.200
    79.709     1.225     0.200
    79.711     1.411     0.200
    79.742     0.188     0.200
    79.742     0.294     0.200
    79.742     1.810     0.200
    79.761     1.445     0.200
    79.761     0.421     0.200
    79.761    -0.020     0.200
    79.761     0.775     0.200
    79.761     0.167     0.200
    79.761     1.290     0.200
    79.795     1.831     0.200
    79.795     0.876     0.200
    79.819    -0.259     0.200
    79.830     0.806     0.200
    79.847     1.083     0.200
    79.868     1.950     0.200
    79.875     1.312     0.200
    79.875     0.473     0.200
    79.891    -0.216     0.200
    79.950     0.656     0.200
    79.959     1.251     0.200
    79.976     1.759     0.200
    79.976     0.619     0.200
    79.977     0.207     0.200
    80.019     0.364     0.200
    80.064     0.467     0.200
    80.067     1.423     0.200
    80.085     1.186     0.200
    80.123     1.329     0.200
    80.146     0.968     0.200
    80.191     0.553     0.200
    80.271     2.822     0.200
    80.271     0.722     0.200
    80.271     1.831     0.200
    80.272     1.068     0.200
    80.326     0.505     0.200
    80.339     0.905     0.200
    80.373     0.252     0.200
    80.392     0.327     0.200
    80.405     0.682     0.200
    80.420     1.112     0.200
    80.421     1.298     0.200
    80.448     1.169     0.200
    80.469     0.636     0.200
    80.470     1.040     0.200
    80.470     2.126     0.200
    80.474     1.272     0.200
    80.488     2.138     0.200
    80.554     3.164     0.200
    80.550     0.522     0.200
    80.581     0.256     0.200
    80.577     0.428     0.200
    80.596     1.703     0.200
    80.596     1.439     0.200
    80.600     1.437     0.200
    80.619     0.856     0.200
    80.619     0.555     0.200
    80.619     1.116     0.200
    80.622     0.507     0.200
    80.657     0.909     0.200
    80.666     0.279     0.200
    80.723     0.669     0.200
    80.723     0.896     0.200
    80.731     0.976     0.200
    80.785     0.973     0.200
    80.785     0.477     0.200
    80.792     1.000     0.200
    80.796     0.006     0.200
    80.834     1.587     0.200
    80.841     1.026     0.200
    80.905     0.806     0.200
    80.907     2.392     0.200
    80.919     1.551     0.200
    80.952     1.172     0.200
    81.011     0.482     0.200
    81.013     0.563     0.200
    81.023    -0.341     0.200
    81.047     1.764     0.200
    81.060     0.440     0.200
    81.074     0.935     0.200
    81.072     1.038     0.200
    81.089     1.645     0.200
    81.093     1.678     0.200
    81.146    -0.460     0.200
    81.149     0.827     0.200
    81.185     0.556     0.200
    81.197    -1.622     0.200
    81.258     0.774     0.200
    81.301     1.021     0.200
    81.334     1.325     0.200
    81.308     0.343     0.200
    81.325     1.107     0.200
    81.328     1.062     0.200
    81.363     2.989     0.200
    81.354     1.281     0.200
    81.477     1.586     0.200
    81.490    -1.274     0.200
    81.535    -1.511     0.200
    81.509     1.119     0.200
    81.582     0.804     0.200
    81.592     1.105     0.200
    81.604     0.645     0.200
    81.604    -0.835     0.200
    81.604    -0.095     0.200
    81.595     0.964     0.200
    81.628     0.440     0.200
    81.629     0.903     0.200
    81.644     0.654     0.200
    81.665     0.292     0.200
    81.697     0.650     0.200
    81.719    -0.093     0.200
    81.719     0.206     0.200
    81.719    -0.294     0.200
    81.719    -0.760     0.200
    81.730     1.950     0.200
    81.730     2.261     0.200
    81.779     1.062     0.200
    81.779     1.863     0.200
    81.779     2.183     0.200
    81.813     0.743     0.200
    81.843     1.753     0.200
    81.895     0.352     0.200
    81.904    -0.064     0.200
    81.904    -0.769     0.200
    81.934     1.411     0.200
    81.992     2.474     0.200
    81.983     0.721     0.200
    82.006     1.697     0.200
    82.011     0.396     0.200
    82.011     0.021     0.200
    82.011     1.169     0.200
    82.014     1.067     0.200
    82.013     1.563     0.200
    82.017     0.542     0.200
    82.017    -0.425     0.200
    82.089     0.963     0.200
    82.131     0.142     0.200
    82.158     1.098     0.200
    82.179     0.323     0.200
    82.085     1.083     0.200
    82.211     0.964     0.200
    82.241     1.367     0.200
    82.318     2.191     0.200
    82.329     1.064     0.200
    82.345     1.523     0.200
    82.345     1.222     0.200
    82.350     1.439     0.200
    82.409     0.977     0.200
    82.423     0.616     0.200
    82.425     0.003     0.200
    82.472     3.360     0.200
    82.478     1.127     0.200
    82.477     0.833     0.200
    82.494     0.446     0.200
    82.568     0.460     0.200
    82.615     2.112     0.200
    82.605    -0.834     0.200
    82.723     1.953     0.200
    82.729     1.067     0.200
    82.729     1.809     0.200
    82.743     0.599     0.200
    82.737     1.178     0.200
    82.737     3.778     0.200
    82.755     0.486     0.200
    82.762     1.213     0.200
    82.762     0.750     0.200
    82.762     1.711     0.200
    82.792     0.695     0.200
    82.792    -0.328     0.200
    82.780     0.457     0.200
    82.830     0.488     0.200
    82.846    -0.584     0.200
    82.867     1.307     0.200
    82.875     0.051     0.200
    82.878    -0.652     0.200
    82.878     0.448     0.200
    82.903     1.027     0.200
    82.910     0.883     0.200
    82.934    -2.001     0.200
    82.977     1.115     0.200
    82.976     0.575     0.200
    83.004     0.685     0.200
    83.030     0.721     0.200
    83.030     1.711     0.200
    83.033     0.547     0.200
    83.080     0.724     0.200
    83.094     1.926     0.200
    83.113     0.723     0.200
    83.132     1.323     0.200
    83.132     1.466     0.200
    83.132     2.094     0.200
    83.132     2.393     0.200
    83.156     1.706     0.200
    83.152     0.531     0.200
    83.152     0.832     0.200
    83.212     1.317     0.200
    83.212     0.950     0.200
    82.961     1.778     0.200
    83.207     0.547     0.200
    83.207     0.846     0.200
    83.232     3.314     0.200
    83.232     1.614     0.200
    83.232     3.575     0.200
    83.237     0.679     0.200
    83.237     0.970     0.200
    83.237     1.480     0.200
    83.244     2.030     0.200
    83.266     2.744     0.200
    83.257     0.689     0.200
    83.270     0.422     0.200
    83.364     1.135     0.200
    83.364    -0.525     0.200
    83.364    -0.763     0.200
    83.364     0.696     0.200
    83.364     2.133     0.200
    83.376     0.277     0.200
    83.385     1.747     0.200
    83.397     1.284     0.200
    83.460    -0.296     0.200
    83.465     0.480     0.200
    83.465     0.739     0.200
    83.470     0.571     0.200
    83.480     0.953     0.200
    83.570     1.125     0.200
    83.619    -0.484     0.200
    83.628     1.177     0.200
    83.628     0.607     0.200
    83.632     0.078     0.200
    83.669     0.400     0.200
    83.647     1.616     0.200
    83.691     0.126     0.200
    83.729     0.264     0.200
    83.729    -0.225     0.200
    83.768     1.561     0.200
    83.748     1.365     0.200
    83.748     1.653     0.200
    83.831     1.180     0.200
    83.851     0.258     0.200
    83.912     0.624     0.200
    83.914     2.018     0.200
    83.930    -0.254     0.200
    83.934    -0.238     0.200
    83.952    -1.379     0.200
    83.963    -1.212     0.200
    83.971     2.227     0.200
    83.981     0.632     0.200
    83.990     0.768     0.200
    83.998    -0.114     0.200
    84.007     0.073     0.200
    84.017    -0.700     0.200
    84.022     0.904     0.200
    84.022     1.638     0.200
    84.043     0.619     0.200
    84.071     3.116     0.200
    84.080     0.661     0.200
    84.080     1.000     0.200
    84.090    -2.221     0.200
    84.104     2.448     0.200
    84.119     1.772     0.200
    84.112     0.499     0.200
    84.130     1.317     0.200
    84.130     1.516     0.200
    84.130     0.200     0.200
    84.130     0.026     0.200
    84.130     1.876     0.200
    84.146     0.833     0.200
    84.165     1.342     0.200
    84.187     2.040     0.200
    84.187     1.878     0.200
    84.222     1.170     0.200
    84.222     0.610     0.200
    84.224    -2.563     0.200
    84.236     0.978     0.200
    84.237     0.704     0.200
    84.236     0.248     0.200
    84.244     2.008     0.200
    84.246     0.557     0.200
    84.249     3.309     0.200
    84.250     0.953     0.200
    84.320     0.804     0.200
    84.320     0.990     0.200
    84.323     0.518     0.200
    84.323     1.684     0.200
    84.324     1.532     0.200
    84.324     1.208     0.200
    84.300    -0.661     0.200
    84.353    -1.111     0.200
    84.353    -0.315     0.200
    84.353     0.144     0.200
    84.365     2.324     0.200
    84.365     2.163     0.200
    84.378     0.557     0.200
    84.378     1.057     0.200
    84.396     1.392     0.200
    84.396     1.014     0.200
    84.461     0.897     0.200
    84.475    -0.436     0.200
    84.492     0.799     0.200
    84.491     0.662     0.200
    84.521     0.763     0.200
    84.521     0.615     0.200
    84.535     0.414     0.200
    84.538     1.021     0.200
    84.543     1.107     0.200
    84.542     0.425     0.200
    84.587     1.901     0.200
    84.607     0.296     0.200
    84.611     1.138     0.200
    84.611     2.117     0.200
    84.616     0.711     0.200
    84.616     0.542     0.200
    84.616     1.942     0.200
    84.621     0.489     0.200
    84.621     1.669     0.200
    84.651     1.197     0.200
    84.708     0.302     0.200
    84.708     0.919     0.200
    84.715     0.473     0.200
    84.715     0.723     0.200
    84.717     1.350     0.200
    84.717     1.475     0.200
    84.731     0.669     0.200
    84.748     0.031     0.200
    84.748     0.678     0.200
    84.758     0.861     0.200
    84.830     1.119     0.200
    84.830     2.171     0.200
    84.846    -0.506     0.200
    84.860     3.022     0.200
    84.873     2.304     0.200
    84.890     0.723     0.200
    84.906     1.395     0.200
    84.936     1.139     0.200
    84.961     1.446     0.200
    84.996     0.714     0.200
    85.053     0.355     0.200
    85.053     0.954     0.200
    85.053     0.703     0.200
    85.121     2.131     0.200
    85.121     2.752     0.200
    85.150    -0.183     0.200
    85.158     1.529     0.200
    85.159     2.727     0.200
    85.215    -0.358     0.200
    85.222     3.311     0.200
    85.245     1.793     0.200
    85.251     0.411     0.200
    85.251     0.247     0.200
    85.294     0.561     0.200
    85.352     2.458     0.200
    85.352     1.557     0.200
    85.363    -1.436     0.200
    85.400     0.216     0.200
    85.409     0.036     0.200
    85.431     2.967     0.200
    85.439    -1.646     0.200
    85.437     0.437     0.200
    85.437     0.035     0.200
    85.467     0.849     0.200
    85.531     1.349     0.200
    85.614     2.139     0.200
    85.632     0.637     0.200
    85.642    -0.432     0.200
    85.658     1.339     0.200
    85.669     1.323     0.200
    85.695     0.813     0.200
    85.777     0.357     0.200
    85.825     1.700     0.200
    85.835     1.350     0.200
    85.844     1.679     0.200
    85.912    -0.024     0.200
    85.930     0.705     0.200
    85.930     1.927     0.200
    85.969     1.371     0.200
    85.988     0.914     0.200
    86.051     0.708     0.200
    86.090     0.990     0.200
    86.090     0.507     0.200
    86.101     0.803     0.200
    86.134    -0.240     0.200
    86.170    -1.237     0.200
    86.158     0.480     0.200
    86.161    -0.238     0.200
    86.275     2.486     0.200
    86.329     0.454     0.200
    86.431     0.918     0.200
    86.434     0.824     0.200
    86.455     0.241     0.200
    86.475     1.571     0.200
    86.527     0.035     0.200
    86.563     0.992     0.200
    86.582    -1.201     0.200
    86.612     1.059     0.200
    86.638     0.872     0.200
    86.651    -0.712     0.200
    86.667    -0.236     0.200
    86.730     0.559     0.200
    86.737     0.941     0.200
    86.825     1.086     0.200
    86.844    -0.134     0.200
    86.882     0.370     0.200
    86.882     1.329     0.200
    86.889     1.528     0.200
    86.891     0.188     0.200
    86.926     1.125     0.200
    86.938     0.232     0.200
    86.941     0.912     0.200
    86.960     0.404     0.200
    86.972    -0.519     0.200
    86.942    -1.363     0.200
    87.002    -0.359     0.200
    87.044     0.719     0.200
    87.157     0.553     0.200
    87.159     0.128     0.200
    87.193     1.096     0.200
    87.244     1.249     0.200
    87.257    -0.071     0.200
    87.248     0.842     0.200
    87.275     0.533     0.200
    87.285    -0.067     0.200
    87.310    -0.187     0.200
    87.326     2.353     0.200
    87.320    -0.515     0.200
    87.347     0.855     0.200
    87.364    -0.867     0.200
    87.410    -0.402     0.200
    87.413     0.419     0.200
    87.433    -0.385     0.200
    87.454     0.838     0.200
    87.454     1.178     0.200
    87.465     2.182     0.200
    87.504     1.086     0.200
    87.529     1.375     0.200
    87.621    -0.568     0.200
    87.638    -0.460     0.200
    87.640     0.642     0.200
    87.641    -0.400     0.200
    87.648     0.604     0.200
    87.700     0.755     0.200
    87.785    -0.250     0.200
    87.819    -0.007     0.200
    87.831     1.535     0.200
    87.853     0.026     0.200
    87.859     0.498     0.200
    87.885     2.277     0.200
    87.885     1.377     0.200
    87.885     1.787     0.200
    87.896    -0.079     0.200
    87.934     0.440     0.200
    88.028     0.105     0.200
    88.052    -0.167     0.200
    88.056     1.563     0.200
    88.076     0.969     0.200
    88.150    -0.473     0.200
    88.171     0.150     0.200
    88.187     1.141     0.200
    88.240     0.992     0.200
    88.284     0.285     0.200
    88.284     1.086     0.200
    88.284     1.086     0.200
    88.284     0.887     0.200
    88.361     0.320     0.200
    88.371     1.673     0.200
    88.455    -0.944     0.200
    88.498     0.472     0.200
    88.513     0.602     0.200
    88.555     0.806     0.200
    88.601    -0.343     0.200
    88.613     0.549     0.200
    88.846     1.334     0.200
    88.915     0.538     0.200
    88.915     1.448     0.200
    88.952     0.697     0.200
    89.008     0.013     0.200
    89.021     1.263     0.200
    89.021     1.638     0.200
    89.082     0.815     0.200
    89.278     2.704     0.200
    89.280     0.447     0.200
    89.313     1.042     0.200
    89.313    -0.060     0.200
    89.313     0.579     0.200
    89.313     0.712     0.200
    89.313    -0.378     0.200
    89.313     0.831     0.200
    89.335     2.837     0.200
    89.513     2.705     0.200
    89.620     0.504     0.200
    89.667     0.727     0.200
    89.803     1.251     0.200
    89.861     1.468     0.200
    89.907     0.464     0.200
    90.093     0.219     0.200
    90.138     0.874     0.200
    90.195     0.815     0.200
    90.478     1.168     0.200
    90.599     1.207     0.200
    90.649     0.494     0.200
    90.662    -0.329     0.200
    90.662    -0.055     0.200
    90.662     0.255     0.200
    90.873     2.064     0.200
    90.873    -0.235     0.200
    90.873     1.625     0.200
    90.911     3.187     0.200
    90.921     0.718     0.200
    90.921     1.732     0.200
    90.948     3.305     0.200
    90.960     0.540     0.200
    90.960    -0.060     0.200
    91.003     0.250     0.200
    91.137     3.665     0.200
    91.367    -1.230     0.200
    91.366     1.408     0.200
    91.506     1.300     0.200
    91.754     0.880     0.200
    91.754     0.140     0.200
    91.836     0.849     0.200
    91.861     0.882     0.200
    91.861     1.343     0.200
    92.064     1.944     0.200
    92.074     2.175     0.200
    92.549     1.854     0.200
    92.668     1.056     0.200
    92.668    -1.109     0.200
    92.668     0.505     0.200
    92.903     1.969     0.200
    92.903     1.268     0.200
    92.903     1.479     0.200
    93.166     0.543     0.200
    93.173    -0.326     0.200
    93.173    -0.025     0.200
    93.177     1.117     0.200
    93.193     1.034     0.200
    93.297     1.853     0.200
    93.297     1.353     0.200
    93.542     1.224     0.200
    93.542     0.724     0.200
    93.542     1.085     0.200
    93.803    -1.049     0.200
    93.899     1.083     0.200
    93.899    -0.346     0.200
    93.899    -0.465     0.200
    93.950    -0.122     0.200
    93.950     0.106     0.200
    93.986     2.282     0.200
    93.986     1.384     0.200
    93.986     2.643     0.200
    94.022    -0.268     0.200
    94.307    -0.492     0.200
    94.399    -0.111     0.200
    94.417     0.405     0.200
    94.491     0.916     0.200
    94.583     0.203     0.200
    94.585     0.760     0.200
    94.585     0.305     0.200
    94.593    -0.480     0.200
    94.609    -1.304     0.200
    94.681     1.593     0.200
    94.846     2.538     0.200
    94.846     1.898     0.200
    94.863     1.062     0.200
    94.962     0.108     0.200
    94.970    -0.956     0.200
    94.970    -0.835     0.200
    94.970    -0.553     0.200
    94.970    -1.247     0.200
    95.022     1.032     0.200
    95.031     0.994     0.200
    95.090    -0.297     0.200
    95.090    -0.449     0.200
    95.104    -0.776     0.200
    95.207     3.287     0.200
    95.207     2.476     0.200
    95.241    -0.287     0.200
    95.259    -0.595     0.200
    95.259    -1.210     0.200
    95.316     0.692     0.200
    95.316    -0.008     0.200
    95.316     0.303     0.200
    95.340    -0.110     0.200
    95.477     0.557     0.200
    95.529    -0.132     0.200
    95.529    -0.822     0.200
    95.557    -0.133     0.200
    95.632    -1.052     0.200
    95.689    -0.368     0.200
    95.700     1.837     0.200
    95.700     0.628     0.200
    95.700     0.436     0.200
    95.700     3.597     0.200
    95.711    -0.871     0.200
    95.767     2.836     0.200
    95.811    -0.566     0.200
    95.813    -0.268     0.200
    95.910    -0.860     0.200
    95.934    -0.176     0.200
    95.941     0.117     0.200
    95.941     0.470     0.200
    96.099     3.224     0.200
    96.128     1.392     0.200
    96.168     0.144     0.200
    96.213    -1.497     0.200
    96.293     2.443     0.200
    96.293     3.242     0.200
    96.290    -0.074     0.200
    96.384     0.371     0.200
    96.572    -0.490     0.200
    96.706     0.971     0.200
    96.730    -0.050     0.200
    96.777     2.365     0.200
    96.766    -0.610     0.200
    96.793     0.137     0.200
    96.856    -1.062     0.200
    96.862     1.661     0.200
    96.862     2.161     0.200
    96.862     1.173     0.200
    96.944     2.590     0.200
    96.944     0.990     0.200
    96.998     0.847     0.200
    97.077    -1.934     0.200
    97.100    -1.640     0.200
    97.100     0.274     0.200
    97.127     0.361     0.200
    97.152    -0.151     0.200
    97.381    -0.661     0.200
    97.598    -0.446     0.200
    98.053     0.688     0.200
    98.129     0.244     0.200
    98.233    -1.119     0.200
    98.808    -0.994     0.200
    15.907     4.186     0.200
    21.038    -0.534     0.200
    23.496    -0.524     0.200
    25.432    -0.525     0.200
    25.852    -1.777     0.200
    31.659     2.235     0.200
    33.745     1.656     0.200
    46.106     0.210     0.200
    46.551     1.788     0.200
    46.957    -1.512     0.200
    51.343     0.462     0.200
    55.212    -0.045     0.200
    55.621    -1.740     0.200
    57.728     2.424     0.200
    59.480    -0.628     0.200
    63.726    -0.981     0.200
    63.903    -0.771     0.200
    63.903    -0.748     0.200
    64.300     0.194     0.200
    64.409    -0.522     0.200
    64.653    -0.087     0.200
    64.930    -1.020     0.200
    64.898    -0.633     0.200
    66.283    -0.848     0.200
    68.077    -0.514     0.200
    74.354    -1.287     0.200
    75.369     1.469     0.200
    76.204    -0.358     0.200
    81.998     0.570     0.200
    83.103     0.426     0.200
    84.957     0.322     0.200
    15.765     3.772     0.200
    16.343     1.751     0.200
    19.845     0.152     0.200
    20.386     0.305     0.200
    20.386     0.815     0.200
    21.280    -1.648     0.200
    22.166    -2.146     0.200
    22.166    -2.361     0.200
    23.304     1.598     0.200
    23.328     2.405     0.200
    23.870    -0.368     0.200
    23.870    -0.583     0.200
    23.927    -0.181     0.200
    24.437     0.036     0.200
    24.437    -0.964     0.200
    24.437    -0.733     0.200
    24.437    -0.553     0.200
    24.548     1.582     0.200
    24.939    -0.634     0.200
    24.939    -0.374     0.200
    24.939    -0.370     0.200
    24.939    -0.034     0.200
    25.269     1.574     0.200
    25.431    -1.193     0.200
    25.687     2.646     0.200
    26.262     2.518     0.200
    26.631     0.254     0.200
    26.711    -0.664     0.200
    26.711    -0.866     0.200
    26.711    -0.504     0.200
    26.738     1.990     0.200
    26.738     2.139     0.200
    26.841    -0.942     0.200
    27.096     2.748     0.200
    27.920     1.999     0.200
    28.526     2.500     0.200
    29.261     2.273     0.200
    29.261     2.523     0.200
    30.573     2.067     0.200
    30.962     2.484     0.200
    31.217    -0.610     0.200
    31.280     2.242     0.200
    31.347     1.749     0.200
    31.627     1.789     0.200
    32.177     0.151     0.200
    32.177     0.311     0.200
    32.151     2.786     0.200
    32.151     2.067     0.200
    32.293     2.336     0.200
    33.357     2.776     0.200
    33.517    -1.355     0.200
    33.705     3.308     0.200
    33.705     2.109     0.200
    33.705     2.228     0.200
    33.827     3.116     0.200
    34.040     2.702     0.200
    34.242     1.555     0.200
    35.522     0.116     0.200
    35.685     3.061     0.200
    35.845    -1.349     0.200
    35.845    -1.490     0.200
    35.941     0.124     0.200
    35.894     2.815     0.200
    35.972     1.822     0.200
    36.190    -0.486     0.200
    36.318     0.506     0.200
    36.318     0.006     0.200
    36.318     0.656     0.200
    36.318     0.856     0.200
    36.568     1.372     0.200
    36.568     1.581     0.200
    36.617    -0.863     0.200
    36.689     2.040     0.200
    36.689     1.670     0.200
    37.358    -0.893     0.200
    37.358    -1.162     0.200
    37.605     0.323     0.200
    37.694    -0.678     0.200
    38.090     0.178     0.200
    38.540     2.686     0.200
    38.697     0.250     0.200
    39.092     0.579     0.200
    39.092     0.378     0.200
    39.091     0.883     0.200
    40.565    -0.639     0.200
    40.821    -0.318     0.200
    40.802     1.690     0.200
    40.802     2.301     0.200
    40.854    -1.443     0.200
    41.019    -0.449     0.200
    41.019    -0.049     0.200
    41.083     0.372     0.200
    41.083    -0.177     0.200
    41.282     0.457     0.200
    41.282     0.588     0.200
    41.309     2.019     0.200
    41.309     2.679     0.200
    42.043    -0.333     0.200
    42.043    -0.802     0.200
    42.056     0.383     0.200
    42.743    -2.077     0.200
    43.503    -0.545     0.200
    43.576     2.016     0.200
    43.582     1.842     0.200
    43.594     1.964     0.200
    43.836     0.336     0.200
    43.996    -1.274     0.200
    43.996    -1.273     0.200
    43.996    -1.512     0.200
    44.298     3.161     0.200
    44.354    -0.497     0.200
    44.774    -0.280     0.200
    44.768    -1.639     0.200
    44.745    -0.356     0.200
    44.819    -0.089     0.200
    45.049    -0.472     0.200
    45.049    -1.572     0.200
    45.049    -1.162     0.200
    45.049    -0.703     0.200
    45.513    -0.367     0.200
    45.519    -0.799     0.200
    45.609     0.488     0.200
    45.609     0.748     0.200
    45.609     0.515     0.200
    45.852     0.969     0.200
    46.001    -1.407     0.200
    46.001    -0.788     0.200
    46.001    -1.196     0.200
    46.065     0.393     0.200
    46.065     0.223     0.200
    46.065     0.503     0.200
    46.065    -0.048     0.200
    46.207    -0.166     0.200
    46.207     0.414     0.200
    46.696    -0.428     0.200
    46.760     0.838     0.200
    46.893    -1.208     0.200
    46.893    -0.847     0.200
    47.047     1.549     0.200
    47.116     0.062     0.200
    47.116     0.372     0.200
    47.092    -0.348     0.200
    47.134     0.220     0.200
    47.134    -0.060     0.200
    47.138     1.091     0.200
    47.138     0.742     0.200
    47.280    -0.515     0.200
    47.280    -1.204     0.200
    47.463     1.335     0.200
    47.768     2.122     0.200
    47.825    -1.046     0.200
    47.838    -0.444     0.200
    47.942    -0.750     0.200
    47.942    -0.951     0.200
    48.081     1.286     0.200
    48.081     1.936     0.200
    48.062    -0.688     0.200
    48.566    -0.790     0.200
    48.697     0.688     0.200
    48.697     0.387     0.200
    48.975     0.405     0.200
    49.217    -0.171     0.200
    49.314     0.112     0.200
    50.096     0.863     0.200
    50.096     1.363     0.200
    50.184     0.096     0.200
    50.294     0.867     0.200
    50.294     0.056     0.200
    50.294     1.017     0.200
    50.497    -0.966     0.200
    50.497    -0.855     0.200
    50.612    -0.443     0.200
    50.849     0.683     0.200
    50.849     0.682     0.200
    50.873     0.137     0.200
    50.907     0.632     0.200
    51.003    -0.373     0.200
    51.003    -0.223     0.200
    51.051     1.561     0.200
    51.051     1.270     0.200
    51.117    -0.120     0.200
    51.116     0.173     0.200
    51.265    -0.840     0.200
    51.523     0.331     0.200
    51.523     0.642     0.200
    51.634     0.479     0.200
    51.706    -0.837     0.200
    51.706    -1.227     0.200
    51.898     0.428     0.200
    51.972     0.330     0.200
    51.972    -0.189     0.200
    52.078     0.791     0.200
    52.078     0.893     0.200
    52.421     0.375     0.200
    52.449     0.257     0.200
    52.473    -0.239     0.200
    52.481     0.683     0.200
    52.638    -1.755     0.200
    52.743     0.563     0.200
    52.898    -0.176     0.200
    52.898     0.023     0.200
    53.230    -0.021     0.200
    53.309    -0.104     0.200
    53.309    -0.235     0.200
    53.309     0.156     0.200
    53.289    -0.058     0.200
    53.338     0.072     0.200
    53.684     0.244     0.200
    53.684     0.594     0.200
    54.393    -0.621     0.200
    54.447     0.188     0.200
    54.447    -0.101     0.200
    54.447     0.048     0.200
    54.780     0.275     0.200
    54.862    -0.965     0.200
    55.303    -1.599     0.200
    55.303    -0.890     0.200
    55.430    -0.113     0.200
    55.430     0.047     0.200
    55.432    -0.032     0.200
    55.446     0.165     0.200
    55.446     0.655     0.200
    55.506    -0.465     0.200
    55.559    -1.186     0.200
    55.559    -1.272     0.200
    55.559    -1.046     0.200
    55.554    -1.209     0.200
    55.554    -1.058     0.200
    55.589    -0.511     0.200
    56.121    -1.250     0.200
    56.173     1.066     0.200
    56.173     1.205     0.200
    56.750     0.756     0.200
    56.813    -0.787     0.200
    56.813    -1.088     0.200
    56.813    -0.627     0.200
    56.910    -1.193     0.200
    57.158    -0.841     0.200
    57.215    -2.429     0.200
    57.262     0.339     0.200
    57.537     0.701     0.200
    57.537     0.902     0.200
    57.634    -0.882     0.200
    57.634    -0.341     0.200
    57.709    -0.850     0.200
    57.704     0.228     0.200
    58.136     0.697     0.200
    58.208    -0.205     0.200
    58.303    -0.787     0.200
    58.451     0.599     0.200
    58.451     1.000     0.200
    58.529    -0.654     0.200
    58.622    -0.652     0.200
    58.692    -0.686     0.200
    58.783     1.196     0.200
    58.783     1.487     0.200
    58.900    -1.761     0.200
    58.916    -0.437     0.200
    59.139    -0.204     0.200
    59.116     0.978     0.200
    59.257     0.406     0.200
    59.651    -0.813     0.200
    59.845     0.052     0.200
    60.013    -1.196     0.200
    60.013    -0.657     0.200
    60.453    -0.807     0.200
    60.457    -0.833     0.200
    61.119     0.606     0.200
    61.468     0.910     0.200
    61.566     0.648     0.200
    61.710     1.177     0.200
    62.122    -0.989     0.200
    62.162    -0.427     0.200
    62.512     0.160     0.200
    62.784    -0.542     0.200
    62.874     1.310     0.200
    62.936    -0.574     0.200
    63.290    -0.467     0.200
    63.290    -0.766     0.200
    63.290    -0.916     0.200
    63.447    -0.339     0.200
    63.455    -0.301     0.200
    63.490     0.312     0.200
    63.657    -0.870     0.200
    63.657    -0.595     0.200
    63.746     0.385     0.200
    63.736     0.191     0.200
    63.755     0.265     0.200
    63.755     0.535     0.200
    63.761     1.122     0.200
    63.761    -0.028     0.200
    63.904    -0.316     0.200
    63.904    -0.290     0.200
    63.968    -0.137     0.200
    63.968     0.205     0.200
    63.968     0.023     0.200
    64.051    -0.086     0.200
    64.082    -0.335     0.200
    64.090    -0.218     0.200
    64.077    -0.154     0.200
    64.062    -0.157     0.200
    64.062    -1.046     0.200
    64.161    -0.046     0.200
    64.224    -0.449     0.200
    64.224    -0.417     0.200
    64.212     0.063     0.200
    64.263    -0.674     0.200
    64.263    -0.876     0.200
    64.322    -0.160     0.200
    64.322    -1.000     0.200
    64.389     0.301     0.200
    64.608     0.097     0.200
    64.610     0.059     0.200
    64.610     0.278     0.200
    64.637    -0.301     0.200
    64.614    -0.257     0.200
    64.732    -0.049     0.200
    64.821     0.784     0.200
    64.920    -0.513     0.200
    64.978    -0.136     0.200
    64.945    -0.034     0.200
    64.998     0.771     0.200
    64.988     0.395     0.200
    64.988     0.106     0.200
    65.142     0.449     0.200
    65.158    -0.307     0.200
    65.100     0.569     0.200
    65.100    -0.819     0.200
    65.200     0.425     0.200
    65.200     0.126     0.200
    65.200     0.255     0.200
    65.204     0.128     0.200
    65.313    -0.078     0.200
    65.427     0.456     0.200
    65.553     0.939     0.200
    65.553    -0.201     0.200
    65.671    -0.068     0.200
    65.673     1.464     0.200
    65.675     0.011     0.200
    65.787     2.959     0.200
    65.853     0.238     0.200
    65.903    -0.255     0.200
    65.922    -0.538     0.200
    65.922    -0.235     0.200
    65.922    -0.538     0.200
    65.922    -0.409     0.200
    65.963     0.482     0.200
    66.029     0.074     0.200
    66.029    -0.327     0.200
    66.095     0.550     0.200
    66.217     0.569     0.200
    66.360     0.655     0.200
    66.360     0.515     0.200
    66.447    -0.110     0.200
    66.500     0.136     0.200
    66.622    -1.518     0.200
    66.622    -1.178     0.200
    66.629    -0.876     0.200
    66.629    -0.476     0.200
    66.717     0.492     0.200
    66.717     0.261     0.200
    66.927    -0.281     0.200
    66.931     0.161     0.200
    66.971     0.239     0.200
    67.159     0.414     0.200
    67.502     0.183     0.200
    67.557    -0.460     0.200
    67.576    -0.413     0.200
    67.734     0.433     0.200
    67.734     0.783     0.200
    67.778     0.085     0.200
    67.954     0.587     0.200
    67.954     0.128     0.200
    68.010    -0.485     0.200
    68.159     0.414     0.200
    68.168    -0.094     0.200
    68.168     0.617     0.200
    68.168     0.246     0.200
    68.131     2.405     0.200
    68.212    -0.048     0.200
    68.352     0.466     0.200
    68.382     0.289     0.200
    68.591    -0.248     0.200
    68.589    -0.325     0.200
    68.814     0.626     0.200
    68.814     0.456     0.200
    68.824    -0.709     0.200
    68.889     0.216     0.200
    68.889     0.056     0.200
    68.890     0.501     0.200
    68.933     0.234     0.200
    68.933     0.374     0.200
    68.951    -0.164     0.200
    68.917     0.733     0.200
    68.987     0.401     0.200
    68.987     0.542     0.200
    68.990     0.390     0.200
    69.197     0.396     0.200
    69.232     1.083     0.200
    69.311    -0.076     0.200
    69.310    -0.762     0.200
    69.310    -0.562     0.200
    69.310    -1.006     0.200
    69.353     0.663     0.200
    69.367     0.468     0.200
    69.411    -0.147     0.200
    69.588    -0.970     0.200
    69.652     0.251     0.200
    69.660     0.079     0.200
    69.680     0.357     0.200
    69.711     0.586     0.200
    69.868     0.807     0.200
    69.886     0.317     0.200
    69.956    -0.100     0.200
    69.987    -0.870     0.200
    69.987     0.130     0.200
    69.987    -0.039     0.200
    70.067    -0.363     0.200
    70.040     1.204     0.200
    70.040     1.314     0.200
    70.099     1.093     0.200
    70.099     0.643     0.200
    70.180    -0.423     0.200
    70.156     0.012     0.200
    70.232     0.533     0.200
    70.232     0.726     0.200
    70.239     0.353     0.200
    70.183     1.527     0.200
    70.240     0.154     0.200
    70.243     0.658     0.200
    70.373     0.844     0.200
    70.373     0.594     0.200
    70.418     0.394     0.200
    70.450     0.395     0.200
    70.450     0.696     0.200
    70.474     0.600     0.200
    70.474     0.791     0.200
    70.489     0.866     0.200
    70.489     1.247     0.200
    70.497    -0.165     0.200
    70.497    -0.889     0.200
    70.514     0.864     0.200
    70.514     1.245     0.200
    70.525     0.709     0.200
    70.525     0.570     0.200
    70.540    -0.203     0.200
    70.552     0.475     0.200
    70.596     0.005     0.200
    70.600     0.481     0.200
    70.576     0.371     0.200
    70.615     1.040     0.200
    70.862     0.091     0.200
    70.862     0.220     0.200
    70.933     0.587     0.200
    70.885     0.953     0.200
    70.936     0.698     0.200
    70.944     0.622     0.200
    70.944     0.052     0.200
    70.970     0.434     0.200
    70.914     0.875     0.200
    71.048     1.903     0.200
    71.116     0.447     0.200
    71.169    -0.974     0.200
    71.194     0.438     0.200
    71.212     0.477     0.200
    71.422     0.240     0.200
    71.536    -0.988     0.200
    71.581     0.794     0.200
    71.604     0.363     0.200
    71.598     0.591     0.200
    71.712     0.974     0.200
    71.760     0.624     0.200
    71.692     0.146     0.200
    71.816    -0.049     0.200
    71.806     0.892     0.200
    71.812     1.173     0.200
    71.834     1.023     0.200
    71.898    -0.263     0.200
    71.939     0.902     0.200
    71.922     1.684     0.200
    71.950     0.939     0.200
    71.876     2.169     0.200
    71.961     1.323     0.200
    72.014     0.683     0.200
    72.063     0.758     0.200
    72.069     0.712     0.200
    72.061     1.089     0.200
    72.163     0.860     0.200
    72.163    -0.069     0.200
    72.177     1.286     0.200
    72.347     0.524     0.200
    72.368     0.787     0.200
    72.307     1.403     0.200
    72.357     1.094     0.200
    72.357     0.805     0.200
    72.417    -0.966     0.200
    72.546     0.258     0.200
    72.556    -1.291     0.200
    72.576     0.551     0.200
    72.576     0.432     0.200
    72.593     0.001     0.200
    72.592     1.105     0.200
    72.624     0.544     0.200
    72.568     1.135     0.200
    72.708     2.085     0.200
    72.757     0.523     0.200
    72.708    -0.032     0.200
    72.794     0.365     0.200
    72.822     0.759     0.200
    72.822     0.398     0.200
    72.822     0.537     0.200
    72.870    -0.855     0.200
    72.907     1.167     0.200
    72.984     0.268     0.200
    72.995     0.707     0.200
    73.025     0.985     0.200
    72.985     1.464     0.200
    73.108     1.575     0.200
    73.187     0.332     0.200
    73.240     0.456     0.200
    73.293     0.857     0.200
    73.330     0.328     0.200
    73.416     0.453     0.200
    73.355     2.781     0.200
    73.440     1.479     0.200
    73.518     0.630     0.200
    73.542     0.283     0.200
    73.571     0.307     0.200
    73.571     0.829     0.200
    73.536     0.517     0.200
    73.621     1.818     0.200
    73.678     0.143     0.200
    73.704    -0.271     0.200
    73.710     0.095     0.200
    73.710    -0.305     0.200
    73.735     0.290     0.200
    73.743     0.508     0.200
    73.781    -0.423     0.200
    73.790    -0.271     0.200
    73.878     0.652     0.200
    73.887    -0.243     0.200
    73.895     0.330     0.200
    73.895     0.550     0.200
    73.930     0.399     0.200
    74.014     0.298     0.200
    74.018     0.601     0.200
    74.018     0.351     0.200
    74.026     0.175     0.200
    73.972    -0.568     0.200
    74.074     0.555     0.200
    74.043     0.746     0.200
    74.114    -1.164     0.200
    74.148     0.584     0.200
    74.188     0.410     0.200
    74.188     0.262     0.200
    74.197    -0.653     0.200
    74.207    -0.707     0.200
    74.211    -0.635     0.200
    74.233    -0.658     0.200
    74.237    -0.885     0.200
    74.250    -0.861     0.200
    74.255    -0.189     0.200
    74.260     0.281     0.200
    74.260     0.392     0.200
    74.262    -0.706     0.200
    74.262    -0.940     0.200
    74.262    -0.931     0.200
    74.267     0.195     0.200
    74.267     0.374     0.200
    74.270    -0.503     0.200
    74.270    -0.657     0.200
    74.270    -0.876     0.200
    74.273    -1.192     0.200
    74.280     0.356     0.200
    74.296     0.583     0.200
    74.303     0.029     0.200
    74.307    -0.891     0.200
    74.324    -0.688     0.200
    74.328    -0.712     0.200
    74.339    -0.779     0.200
    74.333     0.561     0.200
    74.343     0.602     0.200
    74.486     0.477     0.200
    74.494     0.680     0.200
    74.524     1.249     0.200
    74.551     0.691     0.200
    74.573     0.723     0.200
    74.588     0.779     0.200
    74.538    -0.174     0.200
    74.631     0.629     0.200
    74.754     1.019     0.200
    74.754     0.779     0.200
    74.797     0.868     0.200
    74.797     0.067     0.200
    74.844     0.919     0.200
    74.844     0.563     0.200
    74.825    -0.443     0.200
    74.943    -0.573     0.200
    74.987     0.371     0.200
    75.010     1.536     0.200
    75.084     0.909     0.200
    75.084     0.700     0.200
    75.097     0.635     0.200
    75.043     1.050     0.200
    75.043     1.351     0.200
    75.106     0.885     0.200
    75.118    -1.083     0.200
    75.130    -0.252     0.200
    75.157     0.880     0.200
    75.205     0.822     0.200
    75.101     2.815     0.200
    75.101     2.615     0.200
    75.101     1.975     0.200
    75.221     1.002     0.200
    75.221     0.880     0.200
    75.222     0.916     0.200
    75.248     0.370     0.200
    75.178     0.593     0.200
    75.254    -0.470     0.200
    75.231     1.018     0.200
    75.351     0.676     0.200
    75.324     1.151     0.200
    75.401     0.009     0.200
    75.401     0.392     0.200
    75.465     0.874     0.200
    75.547     1.024     0.200
    75.563     0.461     0.200
    75.563    -0.039     0.200
    75.604     0.856     0.200
    75.632     0.669     0.200
    75.668     0.799     0.200
    75.791     0.159     0.200
    75.792     0.656     0.200
    75.818     1.105     0.200
    75.826     0.658     0.200
    75.826     0.469     0.200
    75.828     0.676     0.200
    75.843     0.691     0.200
    75.847     0.435     0.200
    75.847     0.636     0.200
    75.762     1.822     0.200
    75.762     2.031     0.200
    75.863     0.956     0.200
    75.863     0.846     0.200
    75.911     1.073     0.200
    75.911     0.172     0.200
    75.934     0.635     0.200
    75.933     0.689     0.200
    75.995     0.397     0.200
    75.995     0.505     0.200
    75.995     0.686     0.200
    76.031     1.194     0.200
    76.043     0.613     0.200
    76.052     0.551     0.200
    76.055     1.655     0.200
    76.088    -0.131     0.200
    76.088     0.069     0.200
    76.088     0.459     0.200
    76.016     1.663     0.200
    76.202     0.625     0.200
    76.202     0.490     0.200
    76.255     0.519     0.200
    76.267     1.048     0.200
    76.271     1.930     0.200
    76.271     2.085     0.200
    76.321     1.440     0.200
    76.321     1.831     0.200
    76.364     0.500     0.200
    76.374     0.640     0.200
    76.380     1.410     0.200
    76.506    -0.403     0.200
    76.486     1.210     0.200
    76.572     0.125     0.200
    76.662     1.416     0.200
    76.727     0.748     0.200
    76.727     0.998     0.200
    76.746     0.751     0.200
    76.799     1.044     0.200
    76.799     1.323     0.200
    76.870    -0.511     0.200
    76.870    -0.659     0.200
    76.913     0.950     0.200
    76.939     0.054     0.200
    76.939     0.323     0.200
    76.969    -0.414     0.200
    76.997    -0.771     0.200
    77.032     0.727     0.200
    77.068     0.772     0.200
    77.051     0.706     0.200
    77.103    -0.071     0.200
    77.159    -0.480     0.200
    77.159    -0.670     0.200
    77.196     0.862     0.200
    77.205     1.011     0.200
    77.222     0.403     0.200
    77.262     0.699     0.200
    77.262     0.859     0.200
    77.291     1.259     0.200
    77.351     0.581     0.200
    77.380    -0.521     0.200
    77.379     1.085     0.200
    77.379     1.464     0.200
    77.387     0.672     0.200
    77.407     1.326     0.200
    77.447     1.076     0.200
    77.471     1.164     0.200
    77.409     1.329     0.200
    77.509     0.599     0.200
    77.509     0.773     0.200
    77.517     1.096     0.200
    77.524     0.716     0.200
    77.523     0.442     0.200
    77.523     0.602     0.200
    77.552     0.739     0.200
    77.559     1.333     0.200
    77.568     0.749     0.200
    77.581    -0.542     0.200
    77.591     0.739     0.200
    77.595     1.049     0.200
    77.595     1.617     0.200
    77.633     1.350     0.200
    77.667     1.128     0.200
    77.682     0.963     0.200
    77.719     0.740     0.200
    77.726     1.251     0.200
    77.727     1.474     0.200
    77.740    -0.345     0.200
    77.740     0.544     0.200
    77.760     0.260     0.200
    77.760     0.581     0.200
    77.809     1.254     0.200
    77.821     1.141     0.200
    77.820     1.269     0.200
    77.820     1.625     0.200
    77.849     1.136     0.200
    77.865    -0.359     0.200
    77.870     1.004     0.200
    77.870     1.108     0.200
    77.867     1.584     0.200
    77.911     1.086     0.200
    77.911     1.660     0.200
    77.915     1.418     0.200
    77.948     1.452     0.200
    77.954     1.084     0.200
    77.970     1.269     0.200
    77.978    -0.466     0.200
    77.998     0.990     0.200
    77.999     1.734     0.200
    78.008     1.273     0.200
    78.042     1.233     0.200
    78.077     1.119     0.200
    78.099    -1.025     0.200
    78.089     0.393     0.200
    78.135    -0.189     0.200
    78.167     0.790     0.200
    78.215     1.567     0.200
    78.234     0.541     0.200
    78.292     1.368     0.200
    78.219     1.917     0.200
    78.219     1.815     0.200
    78.219     0.616     0.200
    78.219     0.827     0.200
    78.219     1.026     0.200
    78.360     0.535     0.200
    78.381     0.799     0.200
    78.381    -0.180     0.200
    78.389     0.411     0.200
    78.404     0.165     0.200
    78.404     0.490     0.200
    78.404     0.599     0.200
    78.410     0.354     0.200
    78.424     0.790     0.200
    78.467     0.584     0.200
    78.513     0.451     0.200
    78.533     0.079     0.200
    78.573     0.759     0.200
    78.571     0.260     0.200
    78.571     0.079     0.200
    78.629     1.236     0.200
    78.689     1.119     0.200
    78.689     1.299     0.200
    78.759     1.066     0.200
    78.771     0.993     0.200
    78.861     1.350     0.200
    78.940     0.631     0.200
    78.904     0.681     0.200
    78.918    -0.126     0.200
    78.912    -0.163     0.200
    78.983     0.510     0.200
    78.983     0.209     0.200
    78.983    -0.191     0.200
    78.983     0.409     0.200
    78.987     1.007     0.200
    78.987     0.893     0.200
    79.009     0.763     0.200
    79.020     0.973     0.200
    79.020     1.207     0.200
    79.021     0.918     0.200
    79.046     1.329     0.200
    79.053     1.081     0.200
    79.117    -0.625     0.200
    79.163     0.916     0.200
    79.169     0.427     0.200
    79.197     1.083     0.200
    79.185     2.005     0.200
    79.212     0.348     0.200
    79.212     0.465     0.200
    79.221     0.709     0.200
    79.231     0.951     0.200
    79.255     0.525     0.200
    79.301     0.014     0.200
    79.310     1.173     0.200
    79.310     0.632     0.200
    79.321     0.460     0.200
    79.343     0.391     0.200
    79.349     1.811     0.200
    79.336    -0.720     0.200
    79.336    -0.181     0.200
    79.336    -0.421     0.200
    79.380     1.351     0.200
    79.380     0.441     0.200
    79.380     1.902     0.200
    79.395    -0.441     0.200
    79.417     1.068     0.200
    79.423     1.014     0.200
    79.442    -0.098     0.200
    79.486    -0.070     0.200
    79.486     0.571     0.200
    79.486     0.585     0.200
    79.489     1.175     0.200
    79.491     1.064     0.200
    79.491     0.952     0.200
    79.491     0.833     0.200
    79.491     0.652     0.200
    79.491     0.423     0.200
    79.512     1.045     0.200
    79.525     0.737     0.200
    79.555    -0.165     0.200
    79.591     0.486     0.200
    79.607     0.503     0.200
    79.607     0.304     0.200
    79.619     0.308     0.200
    79.619     0.736     0.200
    79.669     0.116     0.200
    79.679     0.841     0.200
    79.679     0.616     0.200
    79.704     0.355     0.200
    79.704     0.177     0.200
    79.704     0.738     0.200
    79.708     0.759     0.200
    79.784     0.257     0.200
    79.792     1.402     0.200
    79.802     0.760     0.200
    79.828     1.224     0.200
    79.831     0.352     0.200
    79.800     1.707     0.200
    79.915     0.600     0.200
    79.844     1.222     0.200
    79.844     0.632     0.200
    79.967     0.216     0.200
    80.052     0.399     0.200
    80.135     0.594     0.200
    80.157     1.198     0.200
    80.162     1.372     0.200
    80.199     0.085     0.200
    80.296    -1.019     0.200
    80.221     1.887     0.200
    80.221     1.149     0.200
    80.319     0.418     0.200
    80.295     1.428     0.200
    80.360     1.520     0.200
    80.372     0.375     0.200
    80.418    -0.173     0.200
    80.418     0.087     0.200
    80.426     0.633     0.200
    80.436     1.758     0.200
    80.438     0.331     0.200
    80.458     1.194     0.200
    80.458     0.439     0.200
    80.467     0.594     0.200
    80.499     1.430     0.200
    80.499     1.664     0.200
    80.525     0.733     0.200
    80.614    -0.079     0.200
    80.629     0.914     0.200
    80.658     0.339     0.200
    80.714    -0.159     0.200
    80.740     0.831     0.200
    80.724     1.187     0.200
    80.724     0.968     0.200
    80.774     0.853     0.200
    80.747     0.802     0.200
    80.823     1.038     0.200
    80.829     1.296     0.200
    80.845     1.674     0.200
    80.850     0.373     0.200
    80.864     1.623     0.200
    80.884     1.224     0.200
    80.884    -0.417     0.200
    80.858     0.825     0.200
    80.907     0.724     0.200
    80.914     0.402     0.200
    80.939     1.398     0.200
    81.000    -0.401     0.200
    81.162     0.693     0.200
    81.181     0.563     0.200
    81.225     0.519     0.200
    81.225     0.320     0.200
    81.225    -0.010     0.200
    81.311     0.763     0.200
    81.266     1.801     0.200
    81.266     2.262     0.200
    81.340     1.209     0.200
    81.337     1.208     0.200
    81.319     0.721     0.200
    81.371     0.858     0.200
    81.440     1.413     0.200
    81.441     0.454     0.200
    81.429     1.132     0.200
    81.492     0.003     0.200
    81.495    -0.812     0.200
    81.495    -0.243     0.200
    81.500     0.552     0.200
    81.560     0.827     0.200
    81.517     1.049     0.200
    81.517     0.723     0.200
    81.516     1.637     0.200
    81.596     0.887     0.200
    81.596     1.037     0.200
    81.765     0.140     0.200
    81.783     0.869     0.200
    81.817     1.194     0.200
    81.817     1.584     0.200
    81.819     0.279     0.200
    81.876     1.383     0.200
    81.876     1.473     0.200
    81.841     1.365     0.200
    81.874     1.291     0.200
    81.874     1.451     0.200
    81.947     1.290     0.200
    81.949     1.302     0.200
    81.943     0.373     0.200
    81.931     0.485     0.200
    81.912     0.992     0.200
    82.027     0.290     0.200
    82.066    -0.416     0.200
    82.066    -0.246     0.200
    82.161    -0.012     0.200
    82.294     0.293     0.200
    82.337     0.664     0.200
    82.356     0.566     0.200
    82.368     1.054     0.200
    82.398     1.220     0.200
    82.434     0.161     0.200
    82.453     0.901     0.200
    82.344     1.928     0.200
    82.475    -0.253     0.200
    82.579     0.652     0.200
    82.579     0.205     0.200
    82.615     0.319     0.200
    82.654     0.218     0.200
    82.662     1.085     0.200
    82.662     0.970     0.200
    82.662     0.370     0.200
    82.740     1.377     0.200
    82.740     1.558     0.200
    82.747    -0.167     0.200
    82.758     0.427     0.200
    82.774     0.373     0.200
    82.782     0.870     0.200
    82.828     1.900     0.200
    82.836     0.513     0.200
    82.846     1.616     0.200
    82.846     1.165     0.200
    82.846     1.821     0.200
    82.846     0.420     0.200
    82.846     2.131     0.200
    82.899     0.143     0.200
    82.898    -0.650     0.200
    82.949     0.725     0.200
    83.016     0.436     0.200
    82.939     1.538     0.200
    82.939     0.145     0.200
    83.083     0.895     0.200
    83.083     1.284     0.200
    83.223     1.117     0.200
    83.223     0.887     0.200
    83.012     2.097     0.200
    83.236     1.123     0.200
    83.240     0.183     0.200
    83.276     0.796     0.200
    83.276     1.356     0.200
    83.214     1.667     0.200
    83.279     1.015     0.200
    83.279     0.839     0.200
    83.279     1.220     0.200
    83.279     0.483     0.200
    83.279    -0.257     0.200
    83.412     0.556     0.200
    83.445     0.956     0.200
    83.508     1.122     0.200
    83.510     1.139     0.200
    83.483     0.370     0.200
    83.513     0.579     0.200
    83.526     0.563     0.200
    83.543     0.373     0.200
    83.584     1.011     0.200
    83.688     0.581     0.200
    83.697     0.316     0.200
    83.732     1.746     0.200
    83.762     0.883     0.200
    83.828     1.327     0.200
    83.874     0.947     0.200
    83.901     1.083     0.200
    83.972     1.131     0.200
    83.914    -0.559     0.200
    83.914    -0.262     0.200
    84.027     0.979     0.200
    84.028     2.093     0.200
    84.059     0.876     0.200
    84.062     1.267     0.200
    84.098     1.246     0.200
    84.129     0.842     0.200
    84.057     0.842     0.200
    84.057     1.697     0.200
    84.057     0.107     0.200
    84.200     0.569     0.200
    84.200     0.809     0.200
    84.222     0.964     0.200
    84.241     1.262     0.200
    84.286     0.985     0.200
    84.286     1.086     0.200
    84.262     0.526     0.200
    84.299     1.021     0.200
    84.349     0.113     0.200
    84.359     0.822     0.200
    84.368     1.247     0.200
    84.382    -0.101     0.200
    84.439     0.860     0.200
    84.490     1.127     0.200
    84.502     0.962     0.200
    84.531     1.191     0.200
    84.544     1.018     0.200
    84.556     0.357     0.200
    84.567     1.497     0.200
    84.583     1.386     0.200
    84.639     0.831     0.200
    84.654     1.452     0.200
    84.657     1.217     0.200
    84.657     1.447     0.200
    84.618     1.455     0.200
    84.618     0.896     0.200
    84.618     1.615     0.200
    84.671     1.211     0.200
    84.671     1.070     0.200
    84.671     1.380     0.200
    84.736     1.671     0.200
    84.741     1.247     0.200
    84.765     1.660     0.200
    84.823     0.973     0.200
    84.828     0.895     0.200
    84.828     1.221     0.200
    84.829     0.944     0.200
    84.846     0.207     0.200
    84.897     2.192     0.200
    85.094     0.362     0.200
    85.094     0.512     0.200
    85.162     1.727     0.200
    85.223     0.931     0.200
    85.245     0.138     0.200
    85.257     0.150     0.200
    85.278     0.753     0.200
    85.327     0.840     0.200
    85.387     1.376     0.200
    85.448     1.588     0.200
    85.493    -0.036     0.200
    85.550     1.481     0.200
    85.567     1.312     0.200
    85.593     1.042     0.200
    85.681     1.461     0.200
    85.713     1.068     0.200
    85.714    -0.495     0.200
    85.778    -0.738     0.200
    85.816     0.299     0.200
    85.883     1.186     0.200
    85.883     2.330     0.200
    85.956     1.388     0.200
    85.971     0.853     0.200
    85.971     0.202     0.200
    85.971     0.964     0.200
    86.006     1.655     0.200
    86.008     0.901     0.200
    86.079     0.884     0.200
    86.116     0.417     0.200
    86.168    -0.015     0.200
    86.174    -0.298     0.200
    86.174     0.003     0.200
    86.418     0.720     0.200
    86.555     0.897     0.200
    86.555     1.066     0.200
    86.555     1.857     0.200
    86.570     0.676     0.200
    86.499     0.184     0.200
    86.590     1.437     0.200
    86.646     1.685     0.200
    86.703     0.584     0.200
    86.732     1.173     0.200
    86.769     1.234     0.200
    86.859    -0.997     0.200
    86.956    -0.290     0.200
    87.062     1.755     0.200
    87.166     1.694     0.200
    87.166     1.158     0.200
    87.335     0.924     0.200
    87.409     0.167     0.200
    87.428     1.083     0.200
    87.428     1.794     0.200
    88.018     0.402     0.200
    88.109     0.542     0.200
    88.014     1.389     0.200
    88.014     0.787     0.200
    88.014     1.197     0.200
    88.145    -0.058     0.200
    88.294     0.442     0.200
    88.643     0.567     0.200
    88.667     0.696     0.200
    88.667     0.905     0.200
    88.758    -0.324     0.200
    88.758     0.025     0.200
    88.804     1.022     0.200
    88.922     0.247     0.200
    88.873     1.437     0.200
    88.873     0.636     0.200
    88.873     0.838     0.200
    88.873     0.947     0.200
    88.953     0.897     0.200
    88.954     0.707     0.200
    88.954     1.207     0.200
    88.902     1.900     0.200
    89.103     2.455     0.200
    89.125     1.154     0.200
    89.234     0.141     0.200
    89.287     1.895     0.200
    89.479     0.184     0.200
    89.575     0.644     0.200
    89.656     0.894     0.200
    89.694     0.878     0.200
    89.838    -0.962     0.200
    89.957     0.202     0.200
    90.063     0.567     0.200
    90.171     0.829     0.200
    90.311     0.231     0.200
    90.250     0.736     0.200
    90.250     0.406     0.200
    90.466     0.809     0.200
    90.466     0.536     0.200
    90.544     0.326     0.200
    90.689     1.867     0.200
    90.689     2.048     0.200
    90.689     0.939     0.200
    90.979     1.251     0.200
    90.979     1.392     0.200
    91.264     0.841     0.200
    91.448     0.299     0.200
    91.831     0.634     0.200
    92.416     1.350     0.200
    92.416     1.010     0.200
    92.705     0.027     0.200
    92.705     0.416     0.200
    92.748     0.321     0.200
    92.737     0.720     0.200
    92.846     0.822     0.200
    92.810     1.430     0.200
    92.932     0.981     0.200
    92.949     0.530     0.200
    93.114     0.529     0.200
    93.467    -0.514     0.200
    93.454     0.266     0.200
    93.467    -0.120     0.200
    93.580     0.317     0.200
    93.580    -0.177     0.200
    93.650     0.048     0.200
    93.853    -0.203     0.200
    94.211    -0.301     0.200
    94.221     0.034     0.200
    94.248     0.565     0.200
    94.236    -0.455     0.200
    94.387     0.360     0.200
    94.470     1.199     0.200
    94.597    -0.389     0.200
    94.597    -0.688     0.200
    94.588     2.052     0.200
    94.588     1.757     0.200
    94.588     1.448     0.200
    94.720     0.217     0.200
    94.720    -0.654     0.200
    94.731    -0.857     0.200
    94.731    -0.650     0.200
    94.886    -0.018     0.200
    94.886    -0.426     0.200
    94.969    -0.002     0.200
    94.969    -0.209     0.200
    95.007     2.659     0.200
    95.007     1.839     0.200
    95.007     2.050     0.200
    95.160     0.645     0.200
    95.160     0.161     0.200
    95.256    -0.349     0.200
    95.256    -0.773     0.200
    95.426     0.685     0.200
    95.529    -0.392     0.200
    95.569     0.223     0.200
    95.569     0.014     0.200
    95.578    -0.078     0.200
    95.540     1.903     0.200
    95.782     0.072     0.200
    95.899     0.622     0.200
    95.896     2.282     0.200
    96.007     0.019     0.200
    96.179     0.641     0.200
    96.348     0.038     0.200
    96.406     0.010     0.200
    96.369     1.033     0.200
    96.369     0.693     0.200
    96.394     0.719     0.200
    96.394     1.219     0.200
    96.498    -0.046     0.200
    96.726     0.045     0.200
    96.782     0.711     0.200
    96.797     0.744     0.200
    96.802     1.270     0.200
    96.827     0.209     0.200
    96.827     0.359     0.200
    96.837     0.764     0.200
    96.857     1.525     0.200
    97.235     0.683     0.200
    97.235     0.519     0.200
    97.740     0.303     0.200
    98.789     0.926     0.200
    21.252     0.257     0.200
    23.678     0.603     0.200
    23.682    -0.515     0.200
    23.682     0.024     0.200
    23.738    -0.083     0.200
    25.402     0.886     0.200
    25.402    -1.247     0.200
    25.402     1.738     0.200
    29.798     0.890     0.200
    31.687     2.513     0.200
    31.859     1.133     0.200
    33.825     1.897     0.200
    33.825     2.006     0.200
    46.595     1.991     0.200
    51.307     0.542     0.200
    55.262     0.556     0.200
    65.138    -0.247     0.200
    66.383    -0.003     0.200
    66.383     0.458     0.200
    68.294     0.594     0.200
    74.548    -1.456     0.200
    81.993     1.054     0.200
    20.631     0.218     0.200
    20.631    -0.181     0.200
    21.154    -0.499     0.200
    21.154    -0.858     0.200
    22.077    -1.651     0.200
    22.077    -1.834     0.200
    23.647    -0.049     0.200
    23.652    -0.751     0.200
    23.652    -0.322     0.200
    24.762    -0.324     0.200
    24.762     0.055     0.200
    25.264    -0.329     0.200
    25.264    -0.356     0.200
    25.722    -1.422     0.200
    25.722    -1.547     0.200
    26.026     0.049     0.200
    26.257     0.298     0.200
    26.340     0.596     0.200
    26.423     2.817     0.200
    27.018    -1.050     0.200
    27.018    -0.241     0.200
    27.018    -0.440     0.200
    27.018     0.017     0.200
    27.410    -0.042     0.200
    30.641     2.951     0.200
    31.128    -0.339     0.200
    31.689    -0.096     0.200
    31.826     2.667     0.200
    33.506     3.243     0.200
    33.744    -1.132     0.200
    33.744    -1.601     0.200
    33.923     1.745     0.200
    34.588     0.239     0.200
    35.806     0.329     0.200
    35.846     1.019     0.200
    36.128    -0.801     0.200
    36.258     1.788     0.200
    36.258     0.639     0.200
    36.258     1.979     0.200
    36.367     2.264     0.200
    36.611    -0.915     0.200
    37.295    -1.012     0.200
    37.327     0.225     0.200
    37.327     0.999     0.200
    38.217     0.254     0.200
    38.217     2.605     0.200
    38.412     0.128     0.200
    38.412     0.647     0.200
    38.416     0.465     0.200
    38.955    -0.587     0.200
    39.413     0.962     0.200
    39.414     0.757     0.200
    39.414     0.655     0.200
    39.414     0.155     0.200
    39.562    -0.053     0.200
    39.683    -0.019     0.200
    40.477     2.333     0.200
    40.525    -0.419     0.200
    40.753    -0.480     0.200
    40.985    -0.356     0.200
    41.963    -0.508     0.200
    42.039    -0.287     0.200
    42.039    -0.608     0.200
    43.059    -1.166     0.200
    43.420    -0.599     0.200
    44.268    -0.120     0.200
    44.320    -1.073     0.200
    45.371    -0.474     0.200
    45.533    -0.555     0.200
    45.533     1.218     0.200
    45.840    -0.477     0.200
    45.907     0.993     0.200
    45.930     0.612     0.200
    45.930     0.964     0.200
    45.930     0.331     0.200
    45.930     0.827     0.200
    46.000    -1.037     0.200
    46.000    -0.717     0.200
    46.000    -0.838     0.200
    46.117     0.843     0.200
    46.117     0.226     0.200
    46.154     0.256     0.200
    46.154     0.545     0.200
    46.154     0.154     0.200
    46.723     1.713     0.200
    46.723     0.561     0.200
    46.896    -0.389     0.200
    46.951    -0.041     0.200
    46.951    -0.854     0.200
    47.010     0.106     0.200
    47.081     1.890     0.200
    47.081     0.941     0.200
    47.219    -0.555     0.200
    47.591    -0.173     0.200
    47.929    -1.041     0.200
    48.160    -0.576     0.200
    48.661     1.163     0.200
    49.015    -0.628     0.200
    50.813     0.103     0.200
    50.813     0.353     0.200
    50.971    -0.286     0.200
    50.971    -0.098     0.200
    51.043    -0.514     0.200
    51.056    -0.915     0.200
    51.141     0.457     0.200
    51.173     0.551     0.200
    51.173    -0.008     0.200
    52.223     0.563     0.200
    52.223     0.462     0.200
    52.577     0.741     0.200
    53.058     0.387     0.200
    53.254    -0.496     0.200
    53.595    -0.189     0.200
    53.595     0.042     0.200
    53.595     0.643     0.200
    53.595     0.253     0.200
    53.612    -0.084     0.200
    53.775    -0.265     0.200
    54.007     0.936     0.200
    54.746    -0.134     0.200
    54.746     0.073     0.200
    54.947    -0.820     0.200
    55.078     0.364     0.200
    55.078     0.255     0.200
    55.382    -1.026     0.200
    55.567    -0.257     0.200
    55.635    -0.930     0.200
    55.635    -0.973     0.200
    55.635    -0.867     0.200
    55.653     0.664     0.200
    55.684    -0.606     0.200
    55.751     0.020     0.200
    56.192    -0.862     0.200
    56.794    -0.466     0.200
    56.912    -0.848     0.200
    56.912    -0.446     0.200
    56.912    -0.587     0.200
    57.029    -0.080     0.200
    57.167    -0.314     0.200
    57.209    -0.523     0.200
    57.576     0.959     0.200
    57.713    -0.199     0.200
    57.713    -0.309     0.200
    57.760    -1.067     0.200
    58.456     0.797     0.200
    58.669    -0.433     0.200
    58.948    -1.536     0.200
    58.961     0.002     0.200
    59.387     0.376     0.200
    59.387    -0.077     0.200
    60.170     0.063     0.200
    60.493     0.392     0.200
    61.788     0.682     0.200
    61.829     0.610     0.200
    62.188     0.388     0.200
    62.536     0.442     0.200
    62.814    -0.010     0.200
    63.463     1.314     0.200
    63.482    -2.506     0.200
    63.737    -0.228     0.200
    63.738    -0.593     0.200
    63.738    -0.793     0.200
    63.920     0.509     0.200
    63.939    -0.420     0.200
    63.939    -0.245     0.200
    64.068     0.273     0.200
    64.117     0.237     0.200
    64.073     0.399     0.200
    64.178     0.410     0.200
    64.210    -0.098     0.200
    64.210     0.676     0.200
    64.210     0.113     0.200
    64.260    -0.269     0.200
    64.319    -0.262     0.200
    64.414    -0.730     0.200
    64.515     0.111     0.200
    64.652     0.314     0.200
    64.753     0.255     0.200
    64.817    -0.460     0.200
    64.817    -0.159     0.200
    64.826     0.033     0.200
    64.827    -0.029     0.200
    64.827     0.323     0.200
    64.963    -0.526     0.200
    65.133     0.784     0.200
    65.223     0.148     0.200
    65.229    -0.468     0.200
    65.229     0.751     0.200
    65.310     0.803     0.200
    65.312     0.827     0.200
    65.312     0.437     0.200
    65.423     1.324     0.200
    66.181    -0.574     0.200
    66.181    -0.398     0.200
    66.181    -0.004     0.200
    66.287    -0.126     0.200
    66.493     1.031     0.200
    66.705     0.637     0.200
    66.705    -1.323     0.200
    68.142     0.322     0.200
    69.144     0.350     0.200
    69.427    -0.806     0.200
    69.498    -1.240     0.200
    70.265     0.249     0.200
    70.327    -0.430     0.200
    70.356     0.692     0.200
    70.502     0.500     0.200
    70.629    -1.272     0.200
    70.652    -0.112     0.200
    70.661     0.333     0.200
    70.809     0.527     0.200
    70.851     0.474     0.200
    70.964     0.690     0.200
    71.059     0.114     0.200
    71.059     0.423     0.200
    71.059     0.423     0.200
    71.224     0.514     0.200
    71.206     1.320     0.200
    71.167     0.857     0.200
    71.370     0.533     0.200
    71.663    -0.635     0.200
    71.846     0.540     0.200
    71.963     1.237     0.200
    72.054     1.044     0.200
    72.068     1.346     0.200
    72.180     2.465     0.200
    72.213     1.229     0.200
    72.427     1.413     0.200
    72.546    -0.716     0.200
    72.623     0.051     0.200
    72.606     1.318     0.200
    72.606     0.791     0.200
    72.694    -1.593     0.200
    72.839     1.364     0.200
    72.999    -0.701     0.200
    73.052     0.858     0.200
    73.318     0.910     0.200
    73.446     0.840     0.200
    73.481     0.458     0.200
    73.568     0.665     0.200
    73.746     0.197     0.200
    73.746    -0.189     0.200
    73.746    -0.303     0.200
    73.775     0.233     0.200
    73.787    -0.042     0.200
    73.809     0.534     0.200
    73.864    -0.090     0.200
    73.857     1.848     0.200
    73.970    -0.113     0.200
    74.079     0.692     0.200
    74.203    -1.171     0.200
    74.227     0.386     0.200
    74.227     0.148     0.200
    74.264     0.102     0.200
    74.292    -0.888     0.200
    74.301    -0.841     0.200
    74.306    -0.868     0.200
    74.326     0.512     0.200
    74.326     0.395     0.200
    74.327    -0.693     0.200
    74.332    -0.823     0.200
    74.339    -0.861     0.200
    74.345    -0.894     0.200
    74.348    -0.911     0.200
    74.351    -0.035     0.200
    74.357    -0.569     0.200
    74.357    -0.569     0.200
    74.357    -0.327     0.200
    74.357    -0.968     0.200
    74.365    -0.813     0.200
    74.365    -0.492     0.200
    74.365    -1.012     0.200
    74.368    -0.932     0.200
    74.369    -0.936     0.200
    74.382    -0.913     0.200
    74.383    -0.918     0.200
    74.395    -0.986     0.200
    74.402    -0.927     0.200
    74.418    -0.924     0.200
    74.423    -0.950     0.200
    74.434    -0.913     0.200
    74.455    -0.935     0.200
    74.474    -0.945     0.200
    74.519     0.376     0.200
    74.569     0.500     0.200
    74.581     0.535     0.200
    74.607     0.300     0.200
    74.635     1.220     0.200
    74.678     0.475     0.200
    74.845     0.905     0.200
    74.845     0.405     0.200
    75.048     0.036     0.200
    75.134     0.538     0.200
    75.208    -1.188     0.200
    75.238     0.614     0.200
    75.268     1.365     0.200
    75.301     0.477     0.200
    75.453    -0.095     0.200
    75.854     0.813     0.200
    75.858     0.591     0.200
    75.895     0.645     0.200
    75.895     0.274     0.200
    75.898     0.656     0.200
    75.948     0.874     0.200
    75.948     0.675     0.200
    76.114     1.731     0.200
    76.135     0.408     0.200
    76.135     0.111     0.200
    76.240     0.252     0.200
    76.240     0.549     0.200
    76.240     0.088     0.200
    76.337     1.164     0.200
    76.348     1.325     0.200
    76.374     0.854     0.200
    76.374     1.514     0.200
    76.381    -0.295     0.200
    76.386     0.785     0.200
    76.850     1.167     0.200
    76.808     1.701     0.200
    76.808     1.271     0.200
    77.079     1.134     0.200
    77.250     0.973     0.200
    77.296     0.494     0.200
    77.295     0.446     0.200
    77.352     1.549     0.200
    77.352     0.912     0.200
    77.494     1.590     0.200
    77.579     0.832     0.200
    77.601     0.735     0.200
    77.604     0.540     0.200
    77.604     0.669     0.200
    77.695     1.051     0.200
    77.710     1.051     0.200
    77.874     0.668     0.200
    77.914     0.322     0.200
    77.914     0.994     0.200
    77.984     1.457     0.200
    78.010     1.046     0.200
    78.002     0.628     0.200
    78.267    -0.745     0.200
    78.447     1.014     0.200
    78.466     1.289     0.200
    78.480    -0.317     0.200
    78.509     0.224     0.200
    78.587     0.156     0.200
    78.613     0.781     0.200
    78.845     0.566     0.200
    79.008     0.617     0.200
    79.078     0.498     0.200
    79.262     0.053     0.200
    79.300     0.444     0.200
    79.340     0.895     0.200
    79.640     0.833     0.200
    79.640     0.732     0.200
    79.659     0.779     0.200
    79.785     1.441     0.200
    79.785     0.848     0.200
    79.804     0.441     0.200
    79.829     0.636     0.200
    79.829     0.910     0.200
    79.857     1.358     0.200
    79.874     0.556     0.200
    79.924     0.305     0.200
    79.945     1.282     0.200
    80.098     1.363     0.200
    80.230     0.399     0.200
    80.390     0.813     0.200
    80.494     1.087     0.200
    80.578     1.444     0.200
    80.773     1.805     0.200
    80.985     1.404     0.200
    80.985     0.463     0.200
    81.018     0.658     0.200
    81.161     0.470     0.200
    81.382     1.841     0.200
    81.546     1.227     0.200
    81.546     0.528     0.200
    81.546     0.341     0.200
    81.645     0.773     0.200
    81.760     1.619     0.200
    81.744    -0.248     0.200
    81.886     1.217     0.200
    81.838     0.659     0.200
    81.838     0.737     0.200
    82.311     1.027     0.200
    82.725     0.915     0.200
    82.832     0.456     0.200
    82.947     2.019     0.200
    83.181     1.143     0.200
    83.181     0.721     0.200
    83.220     1.530     0.200
    83.232     1.530     0.200
    83.232     0.952     0.200
    83.382     0.972     0.200
    83.449     0.990     0.200
    83.837     1.276     0.200
    83.966     1.606     0.200
    84.004     1.150     0.200
    84.065     0.689     0.200
    84.163     0.436     0.200
    84.305     1.291     0.200
    84.595     1.462     0.200
    84.702     1.208     0.200
    84.940     0.938     0.200
    84.947     1.053     0.200
    84.964     0.916     0.200
    85.238     0.770     0.200
    86.018     0.672     0.200
    88.217     0.954     0.200
    88.430     0.219     0.200
    88.966     0.122     0.200
    89.601     0.963     0.200
    93.710    -0.413     0.200
    93.710    -1.214     0.200
    17.716     0.286     0.200
    18.013    -0.258     0.200
    18.183     0.083     0.200
    20.891     0.454     0.200
    21.191    -0.318     0.200
    21.191    -0.775     0.200
    22.391    -1.794     0.200
    23.594    -0.458     0.200
    23.598    -0.771     0.200
    24.994     0.359     0.200
    25.498    -0.343     0.200
    25.498    -0.534     0.200
    25.498    -0.124     0.200
    26.052    -0.283     0.200
    25.987    -0.811     0.200
    26.234     1.775     0.200
    26.549    -1.350     0.200
    26.845    -0.768     0.200
    27.278     0.308     0.200
    28.714     2.435     0.200
    30.434     1.392     0.200
    31.591     2.080     0.200
    31.762    -0.594     0.200
    31.862    -0.689     0.200
    33.138    -0.427     0.200
    33.500     2.187     0.200
    33.724     1.832     0.200
    33.724     0.133     0.200
    34.000    -0.934     0.200
    36.080    -0.340     0.200
    37.200    -0.250     0.200
    38.000     1.877     0.200
    40.243     2.406     0.200
    40.629    -0.621     0.200
    40.767    -0.267     0.200
    40.767     1.842     0.200
    43.313    -1.242     0.200
    43.749     1.996     0.200
    44.558    -1.181     0.200
    45.333     1.075     0.200
    46.133    -0.340     0.200
    46.133    -0.610     0.200
    46.087     0.150     0.200
    46.138     0.490     0.200
    46.138     0.095     0.200
    46.138     0.513     0.200
    46.138     1.063     0.200
    46.285     0.445     0.200
    46.497     1.601     0.200
    47.209     1.936     0.200
    47.123    -0.501     0.200
    47.142    -0.588     0.200
    47.142    -0.412     0.200
    47.288     1.096     0.200
    48.115    -0.051     0.200
    48.052     0.093     0.200
    48.356    -1.243     0.200
    48.405    -0.503     0.200
    49.680    -0.823     0.200
    50.646    -0.750     0.200
    50.646     0.012     0.200
    51.082     0.489     0.200
    51.371     1.090     0.200
    51.403     0.728     0.200
    51.404     0.626     0.200
    52.210     1.045     0.200
    52.452     0.459     0.200
    53.313     0.763     0.200
    53.821    -0.582     0.200
    53.860     0.426     0.200
    55.009     0.569     0.200
    55.341     0.692     0.200
    55.341     0.590     0.200
    55.818    -0.517     0.200
    56.001     0.574     0.200
    56.015     0.731     0.200
    57.345    -0.577     0.200
    57.376    -0.530     0.200
    57.832     1.205     0.200
    58.705     1.008     0.200
    59.124     1.310     0.200
    59.647     0.292     0.200
    59.647     0.023     0.200
    63.923    -0.580     0.200
    63.923    -0.122     0.200
    64.097    -0.032     0.200
    64.097    -0.044     0.200
    64.324     0.279     0.200
    64.469     0.687     0.200
    64.469     0.316     0.200
    64.578     0.025     0.200
    64.777     0.425     0.200
    64.915     0.528     0.200
    65.054    -0.154     0.200
    65.125    -0.096     0.200
    65.078    -0.086     0.200
    65.079     0.353     0.200
    65.390     0.338     0.200
    65.528     0.504     0.200
    66.444    -0.139     0.200
    66.444     0.021     0.200
    66.550     0.042     0.200
    66.758     0.956     0.200
    68.262     0.250     0.200
    69.406     0.650     0.200
    69.760    -0.146     0.200
    70.590    -0.188     0.200
    70.619     0.937     0.200
    70.765     0.785     0.200
    70.921     0.761     0.200
    71.072     0.792     0.200
    71.113     0.676     0.200
    71.304     0.530     0.200
    71.304     0.448     0.200
    71.486     0.688     0.200
    71.430     1.139     0.200
    71.632     0.788     0.200
    72.106     0.583     0.200
    72.443     0.649     0.200
    72.443     2.692     0.200
    72.475     1.272     0.200
    72.867     0.904     0.200
    72.867     1.244     0.200
    73.628     1.982     0.200
    73.740     0.696     0.200
    73.826     0.850     0.200
    73.826     0.920     0.200
    74.060     1.266     0.200
    74.115     1.861     0.200
    74.400     0.997     0.200
    74.551    -0.181     0.200
    74.551     0.155     0.200
    74.551    -0.216     0.200
    74.559    -0.139     0.200
    74.828     0.684     0.200
    74.839     0.787     0.200
    74.993     0.400     0.200
    75.010     1.508     0.200
    75.531     1.456     0.200
    76.107     0.592     0.200
    76.398     0.256     0.200
    76.398     0.365     0.200
    77.051     1.128     0.200
    77.414     0.907     0.200
    77.730     0.600     0.200
    77.772     0.898     0.200
    77.790     0.415     0.200
    77.848     1.105     0.200
    77.861     0.510     0.200
    78.024     1.003     0.200
    78.171     1.721     0.200
    78.196     1.153     0.200
    78.261     0.890     0.200
    78.627     1.341     0.200
    78.772     0.889     0.200
    78.772     1.072     0.200
    80.053     1.064     0.200
    81.248     0.869     0.200
    82.085     1.027     0.200
    83.282     0.884     0.200
    85.154     0.744     0.200
    93.793    -0.261     0.200
    97.139     0.634     0.200
    17.189     0.917     0.200
    17.971     0.722     0.200
    18.673    -1.759     0.200
    18.673    -2.102     0.200
    19.318    -0.942     0.200
    20.345     0.455     0.200
    20.371     0.826     0.200
    20.371     0.639     0.200
    20.809    -0.454     0.200
    22.186    -1.475     0.200
    22.186    -1.291     0.200
    23.028    -1.692     0.200
    23.028    -0.543     0.200
    23.795     1.204     0.200
    23.795     1.012     0.200
    23.795     0.903     0.200
    23.795     1.415     0.200
    24.079     1.887     0.200
    24.306     0.839     0.200
    24.306     1.163     0.200
    24.306     1.339     0.200
    24.831     0.357     0.200
    24.836     0.761     0.200
    24.836     0.511     0.200
    24.836     0.191     0.200
    25.155    -0.886     0.200
    26.156     0.634     0.200
    26.318     1.275     0.200
    26.318     0.514     0.200
    26.318    -0.353     0.200
    27.559     2.105     0.200
    31.728     1.878     0.200
    31.728     2.956     0.200
    32.077    -0.904     0.200
    32.790     0.544     0.200
    32.790     0.252     0.200
    33.563    -1.100     0.200
    33.684     1.645     0.200
    34.139     2.670     0.200
    34.589     2.865     0.200
    34.769     2.645     0.200
    34.910     2.130     0.200
    35.035     2.049     0.200
    35.035     1.588     0.200
    35.613    -1.321     0.200
    35.613    -1.102     0.200
    35.661     2.165     0.200
    37.335    -1.114     0.200
    37.335    -0.884     0.200
    37.277     1.379     0.200
    37.415     1.311     0.200
    37.415     0.788     0.200
    37.465     1.655     0.200
    37.389     0.783     0.200
    37.391     0.817     0.200
    38.178    -1.485     0.200
    38.537     0.849     0.200
    38.537     1.146     0.200
    38.537     0.959     0.200
    38.356     1.570     0.200
    39.271     2.009     0.200
    39.616     1.141     0.200
    40.447    -0.073     0.200
    41.346    -0.723     0.200
    41.445     1.406     0.200
    41.445     3.176     0.200
    42.032     1.701     0.200
    42.270    -0.631     0.200
    42.677    -0.747     0.200
    42.677    -1.055     0.200
    42.887    -0.296     0.200
    42.887    -0.749     0.200
    43.385    -0.277     0.200
    43.385    -0.004     0.200
    43.385    -0.351     0.200
    43.543     1.020     0.200
    43.824     1.414     0.200
    44.068     0.235     0.200
    44.068    -0.265     0.200
    44.353    -0.450     0.200
    44.465     0.017     0.200
    44.465    -0.343     0.200
    44.465     0.169     0.200
    44.992     1.203     0.200
    44.849     1.891     0.200
    44.849     1.731     0.200
    44.849     1.895     0.200
    44.849     2.831     0.200
    45.207    -0.307     0.200
    44.971     0.522     0.200
    45.635    -0.331     0.200
    45.690    -0.326     0.200
    45.998     1.941     0.200
    46.656    -0.075     0.200
    46.656    -0.305     0.200
    46.372     0.907     0.200
    46.372     1.329     0.200
    46.534     1.577     0.200
    46.708    -1.387     0.200
    46.708    -1.016     0.200
    46.708    -1.164     0.200
    46.641     1.940     0.200
    46.641     2.159     0.200
    46.669     0.070     0.200
    46.844    -0.822     0.200
    46.844    -0.947     0.200
    47.010    -0.050     0.200
    47.010     0.192     0.200
    47.010     0.063     0.200
    46.853    -0.021     0.200
    47.469    -1.441     0.200
    47.469    -1.648     0.200
    47.279     0.357     0.200
    47.737     2.897     0.200
    47.737     2.206     0.200
    47.997     0.287     0.200
    47.997     0.010     0.200
    48.673    -0.977     0.200
    48.673    -1.169     0.200
    48.692     0.129     0.200
    48.809     0.788     0.200
    48.870     1.056     0.200
    49.381     0.786     0.200
    49.518    -1.402     0.200
    49.598     0.697     0.200
    49.598     0.486     0.200
    49.344     2.580     0.200
    49.800     0.854     0.200
    49.800     1.522     0.200
    49.905    -0.032     0.200
    50.179    -0.368     0.200
    50.266     0.626     0.200
    50.156     1.366     0.200
    50.187     1.764     0.200
    50.188     1.217     0.200
    50.897     0.997     0.200
    50.873     1.640     0.200
    51.294     1.721     0.200
    51.230     1.360     0.200
    51.230     1.809     0.200
    51.766    -0.556     0.200
    51.766    -0.404     0.200
    51.823     0.876     0.200
    51.931    -0.730     0.200
    51.988     0.791     0.200
    51.988     1.104     0.200
    52.252     0.018     0.200
    52.232     0.878     0.200
    52.302     0.818     0.200
    52.270     1.394     0.200
    52.433     0.434     0.200
    52.558    -1.582     0.200
    52.880     0.519     0.200
    52.702     0.900     0.200
    53.059    -0.138     0.200
    53.059     0.573     0.200
    52.941     1.835     0.200
    54.127    -0.568     0.200
    54.111     0.748     0.200
    54.111     0.549     0.200
    54.111     0.908     0.200
    54.283     0.844     0.200
    54.450     0.924     0.200
    54.450     1.084     0.200
    54.911     1.141     0.200
    55.823    -1.229     0.200
    55.823    -1.639     0.200
    55.934     0.715     0.200
    56.074    -1.226     0.200
    56.074    -0.945     0.200
    56.089    -2.478     0.200
    56.089    -1.091     0.200
    56.149    -0.931     0.200
    56.664    -1.677     0.200
    56.877    -0.188     0.200
    56.968     0.718     0.200
    56.968     0.898     0.200
    56.793     1.557     0.200
    57.150     0.905     0.200
    57.281    -1.301     0.200
    57.281    -1.500     0.200
    57.281    -0.980     0.200
    57.510    -1.721     0.200
    57.690    -2.181     0.200
    57.749    -1.285     0.200
    57.596     1.478     0.200
    57.686     2.198     0.200
    58.154    -1.036     0.200
    58.154    -0.646     0.200
    58.300    -1.094     0.200
    58.907    -0.808     0.200
    59.134    -0.926     0.200
    59.089    -0.368     0.200
    59.089     0.057     0.200
    59.221    -1.099     0.200
    59.297    -0.566     0.200
    59.497    -1.893     0.200
    59.522    -0.788     0.200
    59.583    -1.058     0.200
    60.534    -1.281     0.200
    60.534    -0.941     0.200
    61.068    -0.890     0.200
    60.919     1.801     0.200
    61.441    -0.034     0.200
    62.551     0.408     0.200
    62.883     1.099     0.200
    63.422    -0.736     0.200
    63.236     0.853     0.200
    63.339     0.879     0.200
    63.610    -0.322     0.200
    63.771    -2.280     0.200
    63.593     0.898     0.200
    63.937    -0.176     0.200
    63.845     0.231     0.200
    63.941    -0.301     0.200
    63.941     0.171     0.200
    64.050    -0.166     0.200
    64.173    -0.703     0.200
    64.174    -1.104     0.200
    64.174    -1.229     0.200
    64.174    -0.928     0.200
    64.272    -0.244     0.200
    64.454    -0.211     0.200
    64.528    -0.550     0.200
    64.528    -0.550     0.200
    64.262     1.202     0.200
    64.375     0.949     0.200
    64.577    -0.973     0.200
    64.368     1.759     0.200
    64.718     0.272     0.200
    64.735    -0.201     0.200
    64.552     1.440     0.200
    64.685     0.278     0.200
    64.688    -0.092     0.200
    64.688     0.259     0.200
    64.827    -0.529     0.200
    64.847    -0.819     0.200
    64.847    -0.826     0.200
    64.857    -0.692     0.200
    64.857    -0.340     0.200
    64.857    -0.512     0.200
    65.390    -0.117     0.200
    65.528    -0.863     0.200
    65.607    -0.571     0.200
    65.837     0.355     0.200
    65.837     0.058     0.200
    65.837     0.167     0.200
    65.864     0.275     0.200
    65.881     0.076     0.200
    65.817    -0.516     0.200
    65.817     0.008     0.200
    65.817    -0.488     0.200
    65.817    -0.113     0.200
    65.798     0.900     0.200
    65.798     1.220     0.200
    65.928    -0.125     0.200
    65.928     0.016     0.200
    66.024     1.154     0.200
    66.531     0.088     0.200
    66.597    -0.224     0.200
    66.691     0.106     0.200
    67.129    -1.604     0.200
    67.129    -1.214     0.200
    67.148     0.147     0.200
    67.443     0.150     0.200
    67.443    -0.190     0.200
    67.553    -0.041     0.200
    67.899     0.013     0.200
    68.201    -0.700     0.200
    68.497     0.686     0.200
    68.629    -0.609     0.200
    68.421     1.364     0.200
    68.893    -0.210     0.200
    68.903    -0.048     0.200
    68.903     0.214     0.200
    68.998     0.465     0.200
    68.997    -0.629     0.200
    68.849    -0.209     0.200
    69.201    -0.426     0.200
    69.419    -0.795     0.200
    69.568    -0.243     0.200
    69.692    -0.129     0.200
    69.692    -0.567     0.200
    69.726    -1.139     0.200
    69.766     0.112     0.200
    70.317     1.937     0.200
    70.590    -0.651     0.200
    70.796    -0.783     0.200
    71.034    -0.267     0.200
    71.015    -0.115     0.200
    71.015     0.162     0.200
    71.217     0.362     0.200
    71.267     0.849     0.200
    71.577     0.417     0.200
    71.673     0.319     0.200
    71.674    -0.017     0.200
    71.643     1.150     0.200
    71.708     1.000     0.200
    71.752     0.963     0.200
    71.817     0.943     0.200
    71.922    -1.187     0.200
    71.884     1.144     0.200
    71.891     1.372     0.200
    72.298     1.204     0.200
    72.298     1.064     0.200
    72.573     0.487     0.200
    72.541     1.242     0.200
    72.713     0.408     0.200
    72.797    -1.108     0.200
    72.909    -1.373     0.200
    73.031     0.343     0.200
    73.011     1.664     0.200
    73.190     0.303     0.200
    72.975     3.639     0.200
    73.228    -0.437     0.200
    73.249    -0.980     0.200
    73.398     0.193     0.200
    73.398     0.552     0.200
    73.208     1.489     0.200
    73.320     0.401     0.200
    73.320     0.401     0.200
    73.477    -2.827     0.200
    73.585    -0.120     0.200
    73.668     0.487     0.200
    73.618     1.347     0.200
    73.855     0.005     0.200
    73.855     0.391     0.200
    73.940     0.554     0.200
    74.050     0.245     0.200
    74.178     0.330     0.200
    74.212    -1.031     0.200
    74.234     0.011     0.200
    74.289    -0.681     0.200
    74.332    -0.432     0.200
    74.332    -0.303     0.200
    74.332    -0.631     0.200
    74.376     0.334     0.200
    74.376     0.455     0.200
    74.395    -0.495     0.200
    74.415     0.028     0.200
    74.561     0.288     0.200
    74.575     0.355     0.200
    74.575     0.059     0.200
    74.444     1.459     0.200
    74.483     0.993     0.200
    74.604    -1.710     0.200
    74.666     0.443     0.200
    74.675    -1.017     0.200
    74.699    -0.052     0.200
    74.683    -0.968     0.200
    74.688    -0.897     0.200
    74.714     0.052     0.200
    74.710    -0.925     0.200
    74.713    -1.140     0.200
    74.720    -0.984     0.200
    74.727    -1.024     0.200
    74.730    -1.044     0.200
    74.737    -0.835     0.200
    74.737    -0.682     0.200
    74.737    -0.784     0.200
    74.737    -0.663     0.200
    74.737    -0.983     0.200
    74.765     0.149     0.200
    74.745    -0.943     0.200
    74.745    -0.630     0.200
    74.803     0.140     0.200
    74.803    -0.005     0.200
    74.803    -0.961     0.200
    74.898    -0.309     0.200
    74.930     0.401     0.200
    74.930     0.268     0.200
    74.950    -0.110     0.200
    74.952     0.014     0.200
    74.953    -0.092     0.200
    74.953     0.029     0.200
    74.968    -0.215     0.200
    75.024     0.257     0.200
    74.909     1.426     0.200
    75.116     0.067     0.200
    75.148     0.846     0.200
    75.155     0.404     0.200
    75.155     0.228     0.200
    75.183    -0.156     0.200
    75.201     0.269     0.200
    75.201     0.382     0.200
    75.228     0.387     0.200
    75.382     0.611     0.200
    75.391     0.848     0.200
    75.391     0.348     0.200
    75.391     0.606     0.200
    75.525     0.582     0.200
    75.525     0.684     0.200
    75.525     0.879     0.200
    75.550     0.035     0.200
    75.550     0.476     0.200
    75.606    -1.185     0.200
    75.676    -1.282     0.200
    75.675     0.520     0.200
    75.691    -0.069     0.200
    75.708     0.634     0.200
    75.708     0.287     0.200
    75.795     0.824     0.200
    75.685     1.690     0.200
    75.829     0.341     0.200
    75.836     0.358     0.200
    75.879    -0.744     0.200
    75.929     0.668     0.200
    75.929     0.527     0.200
    75.991    -0.286     0.200
    75.984    -0.024     0.200
    75.984     0.253     0.200
    75.984     0.136     0.200
    75.894     0.868     0.200
    76.101     0.690     0.200
    76.099     0.199     0.200
    76.099     0.000     0.200
    75.886     1.813     0.200
    75.903     1.137     0.200
    76.182     0.690     0.200
    76.238     1.051     0.200
    76.341    -0.073     0.200
    76.350     0.278     0.200
    76.439     0.810     0.200
    76.439     0.372     0.200
    76.439     0.533     0.200
    76.464     0.368     0.200
    76.489     0.491     0.200
    76.530     0.555     0.200
    76.530     0.754     0.200
    76.530     0.254     0.200
    76.679     0.764     0.200
    76.682     0.296     0.200
    76.682    -0.102     0.200
    76.745     0.742     0.200
    76.807     0.990     0.200
    76.821     0.415     0.200
    76.821     0.290     0.200
    76.821    -0.027     0.200
    76.864    -0.129     0.200
    76.904     1.245     0.200
    76.904     1.632     0.200
    77.029     0.122     0.200
    77.049     0.129     0.200
    77.049     0.379     0.200
    77.010     0.761     0.200
    77.188    -0.148     0.200
    77.350    -0.411     0.200
    77.350    -0.860     0.200
    77.385     1.142     0.200
    77.604    -0.077     0.200
    77.605     0.638     0.200
    77.630     0.666     0.200
    77.672    -0.260     0.200
    77.253     1.786     0.200
    77.804     0.796     0.200
    77.730     0.517     0.200
    77.730     0.408     0.200
    77.730     0.638     0.200
    77.839     0.110     0.200
    77.836     0.262     0.200
    77.853     0.419     0.200
    77.853     1.333     0.200
    77.853     0.654     0.200
    77.853     1.072     0.200
    77.871     0.583     0.200
    77.890     0.606     0.200
    77.971     0.314     0.200
    78.033     0.425     0.200
    78.034    -0.127     0.200
    78.034     0.228     0.200
    78.043     0.800     0.200
    78.088    -0.473     0.200
    78.177     0.996     0.200
    78.194     0.665     0.200
    78.197     0.477     0.200
    78.230     0.465     0.200
    78.260    -0.227     0.200
    78.286    -1.066     0.200
    78.305     0.828     0.200
    78.324     0.739     0.200
    78.474     0.790     0.200
    78.474     1.005     0.200
    78.495     0.722     0.200
    78.546     0.193     0.200
    78.571     1.458     0.200
    78.571     1.110     0.200
    78.582     0.815     0.200
    78.593     0.840     0.200
    78.593     1.180     0.200
    78.596     0.920     0.200
    78.639     1.185     0.200
    78.460     1.091     0.200
    78.668     0.152     0.200
    78.676     0.383     0.200
    78.864     0.525     0.200
    78.866     1.218     0.200
    78.951     0.537     0.200
    78.951     1.107     0.200
    78.993     1.737     0.200
    79.031     0.860     0.200
    79.032     0.634     0.200
    79.044     0.460     0.200
    79.067    -0.143     0.200
    79.067    -0.264     0.200
    78.922     0.029     0.200
    78.988     1.689     0.200
    79.074     0.673     0.200
    79.185     0.525     0.200
    79.215     0.214     0.200
    79.257     1.034     0.200
    79.333    -0.019     0.200
    79.475     0.872     0.200
    79.475     0.708     0.200
    79.525     0.736     0.200
    79.557     0.364     0.200
    79.557     0.219     0.200
    79.590     0.176     0.200
    79.467     2.150     0.200
    79.649     0.150     0.200
    79.671     0.902     0.200
    79.691     1.033     0.200
    79.711     0.225     0.200
    79.706    -0.094     0.200
    79.706     0.047     0.200
    79.706     0.430     0.200
    79.726     0.387     0.200
    79.754     0.732     0.200
    79.774    -0.022     0.200
    79.791     1.181     0.200
    79.828     0.689     0.200
    79.807     0.203     0.200
    79.807     0.703     0.200
    79.807     0.961     0.200
    79.848     0.884     0.200
    79.864    -0.704     0.200
    79.968     1.103     0.200
    79.991     0.706     0.200
    79.991     0.604     0.200
    80.031     1.091     0.200
    80.023     0.830     0.200
    80.121     0.718     0.200
    80.137     0.362     0.200
    80.204     0.258     0.200
    80.215     0.191     0.200
    80.215     0.796     0.200
    80.215     0.456     0.200
    80.252    -0.141     0.200
    80.256     0.299     0.200
    80.309    -0.016     0.200
    80.477     1.185     0.200
    80.462    -0.300     0.200
    80.368     1.186     0.200
    80.611     0.369     0.200
    80.645    -0.308     0.200
    80.579     0.902     0.200
    80.605     0.803     0.200
    80.605     1.362     0.200
    80.664     1.411     0.200
    80.443     3.068     0.200
    80.443     3.181     0.200
    80.856    -0.221     0.200
    80.675     0.627     0.200
    80.675     0.728     0.200
    80.675     0.986     0.200
    80.967     1.845     0.200
    80.970     0.070     0.200
    81.008     0.049     0.200
    81.042     1.367     0.200
    81.206     0.286     0.200
    80.964     1.433     0.200
    81.262     1.447     0.200
    81.238     0.429     0.200
    81.182     0.870     0.200
    81.202     0.697     0.200
    81.354     0.112     0.200
    81.394     0.101     0.200
    81.387     1.067     0.200
    81.409    -0.483     0.200
    81.420     0.589     0.200
    81.425     1.475     0.200
    81.446     0.204     0.200
    81.436    -0.424     0.200
    81.633     1.457     0.200
    81.420     1.042     0.200
    81.609     0.563     0.200
    81.694     1.624     0.200
    81.743     1.583     0.200
    82.182     1.388     0.200
    82.246     1.363     0.200
    82.330     0.570     0.200
    82.621     1.525     0.200
    82.621     1.393     0.200
    82.759     1.401     0.200
    82.421     0.758     0.200
    82.828     0.279     0.200
    82.894     1.225     0.200
    83.123     1.553     0.200
    83.123     2.463     0.200
    83.174     0.802     0.200
    83.213     1.599     0.200
    83.264     1.224     0.200
    83.343    -0.031     0.200
    83.343     0.227     0.200
    83.588     0.958     0.200
    83.762     0.940     0.200
    84.004     0.956     0.200
    83.831     1.854     0.200
    84.088     1.544     0.200
    84.088     1.044     0.200
    84.082     0.432     0.200
    84.075     1.707     0.200
    84.058     0.786     0.200
    84.260     1.266     0.200
    84.323     0.851     0.200
    84.474     0.932     0.200
    84.559     2.014     0.200
    84.582     0.595     0.200
    84.697     0.218     0.200
    84.717     0.415     0.200
    84.777     1.216     0.200
    84.840     1.528     0.200
    84.868     1.554     0.200
    84.885     0.571     0.200
    84.944     1.503     0.200
    85.183     1.636     0.200
    85.237     0.705     0.200
    85.237     0.588     0.200
    85.237     0.907     0.200
    85.237     0.805     0.200
    85.428     1.207     0.200
    85.471     1.219     0.200
    85.492     1.573     0.200
    85.332     1.383     0.200
    85.629     0.313     0.200
    85.791     0.726     0.200
    85.830     1.395     0.200
    85.891     0.817     0.200
    85.888     0.316     0.200
    86.566     0.578     0.200
    86.202     2.761     0.200
    86.713    -0.204     0.200
    86.972     0.742     0.200
    87.464    -1.080     0.200
    87.053     1.527     0.200
    87.614     2.708     0.200
    87.807     0.955     0.200
    87.890     0.087     0.200
    88.558     0.514     0.200
    88.439     1.261     0.200
    89.627     0.592     0.200
    90.459     0.473     0.200
    90.482     1.547     0.200
    92.330     1.229     0.200
    92.505     1.154     0.200
    93.628     3.045     0.200
    95.452     1.166     0.200
    95.452     1.780     0.200
    95.818     1.823     0.200
    95.862     1.421     0.200
    95.862     1.671     0.200
    20.955     0.650     0.200
    21.198    -0.831     0.200
    22.160    -1.129     0.200
    22.344    -1.588     0.200
    23.578     0.215     0.200
    23.582    -0.088     0.200
    23.582    -0.362     0.200
    25.557    -0.025     0.200
    25.557    -0.310     0.200
    25.557     0.085     0.200
    26.157    -0.399     0.200
    30.513    -0.318     0.200
    31.208    -0.161     0.200
    31.531     3.013     0.200
    31.531    -0.627     0.200
    33.673     2.613     0.200
    36.033     0.401     0.200
    36.116     0.144     0.200
    40.653     0.219     0.200
    45.282     0.433     0.200
    46.163     0.239     0.200
    46.191     0.804     0.200
    46.440     2.509     0.200
    46.440     0.087     0.200
    46.559    -0.372     0.200
    47.164    -0.335     0.200
    47.202    -0.580     0.200
    48.081    -0.287     0.200
    50.602    -0.121     0.200
    51.106    -0.063     0.200
    51.483    -0.532     0.200
    51.462     0.167     0.200
    53.780    -0.005     0.200
    55.407     0.618     0.200
    55.407     0.509     0.200
    57.896     3.135     0.200
    59.712     0.479     0.200
    59.712     0.139     0.200
    63.995    -0.407     0.200
    63.967     0.121     0.200
    64.134     0.252     0.200
    64.533     0.377     0.200
    64.642    -0.003     0.200
    65.163    -0.228     0.200
    65.140     0.238     0.200
    66.509     0.244     0.200
    66.509     0.362     0.200
    66.615     0.551     0.200
    68.290     0.954     0.200
    74.123     1.869     0.200
    74.598     0.035     0.200
    74.605     0.174     0.200
    80.107     1.294     0.200
    82.147     0.772     0.200
    82.147     0.659     0.200
    83.305     0.480     0.200
    85.204     0.298     0.200
    85.204     0.188     0.200
    93.816    -0.528     0.200
    97.161     0.477     0.200
    97.161     0.731     0.200
    21.188    -0.388     0.200
    22.151    -0.019     0.200
    22.329    -0.394     0.200
    22.725     0.009     0.200
    22.929     0.466     0.200
    23.235     1.386     0.200
    23.565    -0.116     0.200
    23.568    -0.427     0.200
    23.568    -0.200     0.200
    23.625     0.025     0.200
    25.210    -0.470     0.200
    25.225    -0.613     0.200
    25.571    -0.577     0.200
    25.571    -0.225     0.200
    25.813     0.311     0.200
    26.142     0.534     0.200
    26.157     1.011     0.200
    26.720     1.199     0.200
    28.074     1.152     0.200
    28.758    -0.779     0.200
    28.952     1.157     0.200
    29.634     1.847     0.200
    31.517     3.505     0.200
    31.517     3.193     0.200
    31.598     3.287     0.200
    31.641     0.249     0.200
    31.697     0.359     0.200
    32.080     0.714     0.200
    32.123     0.130     0.200
    32.198     0.822     0.200
    32.826     0.200     0.200
    33.063     0.814     0.200
    33.634     1.328     0.200
    33.658     1.756     0.200
    33.658     2.266     0.200
    33.658     2.106     0.200
    33.714     0.491     0.200
    33.718     0.817     0.200
    33.955     0.782     0.200
    34.029     0.931     0.200
    34.062     0.262     0.200
    34.069    -1.532     0.200
    36.018     0.658     0.200
    36.018    -0.279     0.200
    36.066     0.400     0.200
    36.142     1.131     0.200
    36.373     0.139     0.200
    37.930     0.106     0.200
    38.222    -0.037     0.200
    38.521     1.245     0.200
    40.646    -0.561     0.200
    40.697    -0.188     0.200
    40.697    -0.758     0.200
    41.785    -0.486     0.200
    41.891     0.056     0.200
    42.142    -0.574     0.200
    43.513     0.820     0.200
    43.678     1.278     0.200
    43.888     1.408     0.200
    44.202     1.187     0.200
    45.267    -0.066     0.200
    46.158    -1.348     0.200
    46.158    -1.747     0.200
    46.166    -0.398     0.200
    46.261    -0.046     0.200
    46.261     0.696     0.200
    46.290     0.719     0.200
    46.206     0.794     0.200
    46.206     0.993     0.200
    46.206     0.993     0.200
    46.206     1.451     0.200
    46.425     1.875     0.200
    46.426     2.244     0.200
    46.426     1.740     0.200
    46.543    -0.705     0.200
    47.161     0.082     0.200
    47.207    -0.314     0.200
    47.777     0.987     0.200
    47.979     0.370     0.200
    48.075    -0.125     0.200
    48.294    -0.724     0.200
    48.515     0.553     0.200
    48.481     0.242     0.200
    48.953    -0.590     0.200
    50.587     0.506     0.200
    50.587    -0.885     0.200
    51.100     1.203     0.200
    51.468     0.741     0.200
    51.483     0.240     0.200
    51.444     0.851     0.200
    51.476     0.451     0.200
    53.765     0.500     0.200
    55.417     0.368     0.200
    55.860    -1.170     0.200
    55.860    -0.897     0.200
    57.413    -0.731     0.200
    57.908     1.074     0.200
    59.719     1.011     0.200
    60.478     0.884     0.200
    63.868    -0.470     0.200
    63.965    -0.605     0.200
    63.965    -0.327     0.200
    64.084     0.449     0.200
    64.299     0.544     0.200
    64.540     0.644     0.200
    64.649     0.041     0.200
    64.853     0.114     0.200
    65.115    -0.030     0.200
    65.159     0.134     0.200
    65.145     0.116     0.200
    65.147     0.277     0.200
    66.517    -0.244     0.200
    66.623     0.102     0.200
    68.284     0.424     0.200
    70.509     0.455     0.200
    71.368     0.270     0.200
    71.368     0.192     0.200
    72.434     1.184     0.200
    72.434     1.574     0.200
    72.516     1.414     0.200
    72.547     1.006     0.200
    72.939     0.302     0.200
    73.445     0.701     0.200
    73.897     0.322     0.200
    73.897     0.443     0.200
    74.136     2.295     0.200
    74.596    -0.459     0.200
    74.596    -0.608     0.200
    74.596    -0.026     0.200
    74.604    -0.960     0.200
    75.046     1.005     0.200
    76.140     1.200     0.200
    76.432     0.767     0.200
    76.508     1.189     0.200
    76.557     1.297     0.200
    77.359     1.373     0.200
    78.806     1.153     0.200
    80.108     1.527     0.200
    82.160     0.739     0.200
    82.160     0.321     0.200
    83.297     0.881     0.200
    85.204     1.802     0.200
    85.204     0.060     0.200
    93.831    -0.498     0.200
    93.831    -0.682     0.200
    97.175    -0.234     0.200
    97.175    -0.547     0.200
    21.346    -1.822     0.200
    63.723    -0.338     0.200
    64.525     1.014     0.200
    70.786    -0.754     0.200
    73.236    -0.092     0.200
    14.864     5.167     0.200
    14.890     7.126     0.200
    15.259     3.233     0.200
    15.692     5.771     0.200
    15.988     3.593     0.200
    16.477     2.873     0.200
    17.013     1.377     0.200
    17.106     0.746     0.200
    17.350     0.407     0.200
    18.590    -2.112     0.200
    18.590    -1.710     0.200
    23.835    -0.512     0.200
    24.345     0.382     0.200
    24.345    -0.274     0.200
    24.345     0.382     0.200
    24.754    -0.338     0.200
    25.889     1.428     0.200
    64.114    -2.229     0.200
    64.660    -1.285     0.200
    65.462    -1.718     0.200
    65.808    -1.595     0.200
    80.996    -0.284     0.200
    83.927    -0.500     0.200
    15.339     2.381     0.200
    15.812     2.248     0.200
    16.278     1.906     0.200
    16.305     1.251     0.200
    16.969     1.431     0.200
    17.357     1.445     0.200
    19.269    -0.710     0.200
    20.367     0.431     0.200
    20.367    -0.998     0.200
    21.127    -0.001     0.200
    21.232    -1.708     0.200
    21.232    -1.576     0.200
    22.119    -2.439     0.200
    22.890    -0.097     0.200
    23.309     0.632     0.200
    23.499     0.467     0.200
    23.828     0.006     0.200
    23.828    -0.119     0.200
    23.828    -0.353     0.200
    24.450     0.395     0.200
    24.450    -0.628     0.200
    24.450    -0.300     0.200
    24.450     0.559     0.200
    24.952     0.136     0.200
    24.952    -0.669     0.200
    24.952    -0.091     0.200
    24.952    -0.864     0.200
    25.253     1.001     0.200
    25.253     0.516     0.200
    25.423    -1.347     0.200
    26.063    -0.405     0.200
    26.598     0.534     0.200
    26.713     1.739     0.200
    26.713     2.372     0.200
    26.709    -0.767     0.200
    26.709    -1.079     0.200
    26.709    -0.368     0.200
    26.709    -0.509     0.200
    26.857    -0.700     0.200
    27.080     0.480     0.200
    27.417     2.826     0.200
    27.566     1.017     0.200
    29.114     0.633     0.200
    29.245     1.608     0.200
    30.169     1.145     0.200
    30.297     1.191     0.200
    30.942     1.319     0.200
    31.170    -0.297     0.200
    31.170    -0.079     0.200
    31.322     2.156     0.200
    32.067     1.704     0.200
    32.140    -0.231     0.200
    32.140     0.683     0.200
    32.139     2.710     0.200
    32.139     1.171     0.200
    32.277     2.252     0.200
    32.991     0.925     0.200
    33.078     1.670     0.200
    33.336     2.020     0.200
    33.414     1.732     0.200
    33.495    -1.364     0.200
    33.495    -1.466     0.200
    33.784     0.838     0.200
    34.219     1.004     0.200
    34.219     2.098     0.200
    34.219     1.090     0.200
    34.274     0.664     0.200
    35.533     1.020     0.200
    35.835    -1.770     0.200
    35.835    -1.504     0.200
    35.835    -1.637     0.200
    35.894    -0.036     0.200
    35.902     1.779     0.200
    35.905     1.076     0.200
    36.332     0.586     0.200
    36.332     0.141     0.200
    36.332     0.687     0.200
    36.541     0.605     0.200
    36.541     1.910     0.200
    36.541     2.050     0.200
    36.571    -0.956     0.200
    36.680     1.887     0.200
    36.680     2.215     0.200
    36.680     0.434     0.200
    36.982     0.310     0.200
    36.993    -0.034     0.200
    37.311    -1.633     0.200
    37.311    -0.641     0.200
    37.311    -1.234     0.200
    37.570     0.299     0.200
    37.570     0.471     0.200
    37.570    -0.029     0.200
    37.637     1.163     0.200
    37.700    -0.329     0.200
    38.096     1.877     0.200
    38.107     0.203     0.200
    38.108     0.230     0.200
    38.403     0.751     0.200
    38.522     2.699     0.200
    38.663    -0.211     0.200
    38.663     0.570     0.200
    39.046     0.078     0.200
    39.111     0.623     0.200
    39.111     0.428     0.200
    39.111    -0.096     0.200
    39.111     0.982     0.200
    39.110     0.628     0.200
    39.614     1.269     0.200
    39.863     1.026     0.200
    40.518    -0.145     0.200
    40.774    -0.273     0.200
    40.789     1.503     0.200
    40.789     2.909     0.200
    40.854    -1.628     0.200
    40.989     0.056     0.200
    41.102     0.624     0.200
    41.102    -0.212     0.200
    41.102     0.273     0.200
    41.247     0.707     0.200
    41.291     1.970     0.200
    41.291     2.470     0.200
    41.291    -0.217     0.200
    41.291     2.767     0.200
    41.973    -0.406     0.200
    41.996    -0.039     0.200
    41.996    -0.368     0.200
    42.746    -1.393     0.200
    43.085     0.169     0.200
    43.288     0.492     0.200
    43.456    -0.054     0.200
    43.789     0.121     0.200
    44.007    -1.143     0.200
    44.007    -1.822     0.200
    44.007    -1.244     0.200
    44.282     2.726     0.200
    44.306    -0.516     0.200
    44.727    -0.386     0.200
    44.772    -0.183     0.200
    44.786     1.670     0.200
    44.800     1.664     0.200
    44.804     1.672     0.200
    45.077    -0.676     0.200
    45.058    -1.160     0.200
    45.058    -0.933     0.200
    45.058    -0.668     0.200
    45.466    -0.862     0.200
    45.466    -0.222     0.200
    45.466    -1.276     0.200
    45.526     0.061     0.200
    45.630     0.538     0.200
    45.630     0.639     0.200
    45.630     0.038     0.200
    45.629     0.534     0.200
    45.629     0.213     0.200
    45.830     0.664     0.200
    45.830     1.383     0.200
    45.956    -0.730     0.200
    45.956    -1.176     0.200
    46.023     0.145     0.200
    46.023    -0.167     0.200
    46.023     0.551     0.200
    46.023     0.325     0.200
    46.160    -0.141     0.200
    46.160     0.554     0.200
    46.160     0.109     0.200
    46.261     0.771     0.200
    46.669    -0.900     0.200
    46.669    -0.627     0.200
    46.781     1.296     0.200
    46.781     0.234     0.200
    46.781     0.796     0.200
    46.851    -0.396     0.200
    46.851    -1.185     0.200
    46.851    -1.052     0.200
    46.855    -0.995     0.200
    47.032     1.840     0.200
    47.032     0.981     0.200
    47.069    -0.946     0.200
    47.069     0.608     0.200
    47.069     0.812     0.200
    47.092    -0.774     0.200
    47.180    -0.311     0.200
    47.155     1.574     0.200
    47.155    -0.543     0.200
    47.155     0.090     0.200
    47.162     0.927     0.200
    47.162     0.653     0.200
    47.176     0.289     0.200
    47.278     0.219     0.200
    47.281    -0.900     0.200
    47.456    -1.344     0.200
    47.797    -0.803     0.200
    47.797    -0.358     0.200
    47.896    -0.677     0.200
    47.896    -1.271     0.200
    47.846    -0.786     0.200
    48.074     2.611     0.200
    48.020    -0.562     0.200
    48.364     0.516     0.200
    48.525     0.131     0.200
    48.649     1.121     0.200
    48.649     0.316     0.200
    48.950     0.022     0.200
    48.950     0.843     0.200
    49.153    -0.817     0.200
    49.173    -1.160     0.200
    49.243    -1.209     0.200
    49.867    -0.594     0.200
    50.116     1.535     0.200
    50.116     0.285     0.200
    50.116     1.285     0.200
    50.193     0.356     0.200
    50.323    -0.450     0.200
    50.323     1.472     0.200
    50.323     0.082     0.200
    50.323     1.019     0.200
    50.466    -0.902     0.200
    50.466     0.005     0.200
    50.570     0.492     0.200
    50.904    -0.753     0.200
    50.831     0.498     0.200
    50.863     0.653     0.200
    50.863     0.504     0.200
    50.956    -0.298     0.200
    50.956    -0.001     0.200
    50.956    -0.751     0.200
    51.030     1.645     0.200
    51.030     2.255     0.200
    51.069    -0.586     0.200
    51.087     0.117     0.200
    51.087     0.609     0.200
    51.225    -0.277     0.200
    51.255    -0.745     0.200
    51.536     0.063     0.200
    51.536    -0.398     0.200
    51.536     0.720     0.200
    51.659    -1.212     0.200
    51.659    -0.657     0.200
    51.721    -1.158     0.200
    51.925    -0.790     0.200
    51.925    -0.040     0.200
    51.913     0.447     0.200
    51.913     0.181     0.200
    52.095     1.296     0.200
    52.225    -1.199     0.200
    52.343    -0.956     0.200
    52.376     0.759     0.200
    52.436     0.309     0.200
    52.456    -1.138     0.200
    52.648    -0.288     0.200
    52.704    -0.970     0.200
    52.757     0.789     0.200
    52.746     0.474     0.200
    52.851    -0.102     0.200
    53.023    -0.467     0.200
    53.198     0.360     0.200
    53.301     0.459     0.200
    53.300    -0.106     0.200
    53.300    -0.715     0.200
    53.300    -0.348     0.200
    53.300     0.254     0.200
    53.299     0.404     0.200
    53.711    -0.727     0.200
    53.711    -0.618     0.200
    53.704     1.333     0.200
    53.704    -0.050     0.200
    53.704     0.684     0.200
    53.801    -0.898     0.200
    53.969    -0.803     0.200
    54.385    -0.927     0.200
    54.456    -0.445     0.200
    54.442    -0.248     0.200
    54.442    -1.092     0.200
    54.442    -0.147     0.200
    54.442     0.017     0.200
    54.469    -0.140     0.200
    54.568    -0.663     0.200
    54.710    -0.662     0.200
    54.775    -0.752     0.200
    54.775     0.341     0.200
    54.822    -0.989     0.200
    55.262    -0.974     0.200
    55.262    -0.763     0.200
    55.391    -0.502     0.200
    55.391     0.310     0.200
    55.464    -0.492     0.200
    55.438     0.060     0.200
    55.452    -0.340     0.200
    55.452     0.066     0.200
    55.452     0.410     0.200
    55.524    -0.860     0.200
    55.519    -0.843     0.200
    55.519    -1.671     0.200
    55.519    -1.093     0.200
    55.548    -0.302     0.200
    55.881    -1.105     0.200
    55.995    -0.229     0.200
    56.080    -1.207     0.200
    56.126     0.234     0.200
    56.126     1.374     0.200
    56.774    -0.877     0.200
    56.774    -1.275     0.200
    56.774    -0.564     0.200
    56.867    -1.690     0.200
    57.116    -0.804     0.200
    57.264     0.359     0.200
    57.598     0.136     0.200
    57.593    -0.356     0.200
    57.593    -0.215     0.200
    57.666    -0.706     0.200
    57.712     0.206     0.200
    57.810    -0.981     0.200
    58.143     0.488     0.200
    58.210     0.122     0.200
    58.260    -1.151     0.200
    58.486    -0.696     0.200
    58.472     0.440     0.200
    58.472     1.089     0.200
    58.579    -0.697     0.200
    58.649    -0.343     0.200
    58.857    -1.878     0.200
    58.873    -0.381     0.200
    59.042    -0.370     0.200
    59.156     0.805     0.200
    59.121    -0.421     0.200
    59.121    -0.289     0.200
    59.121    -0.484     0.200
    59.122     0.681     0.200
    59.271     0.646     0.200
    59.858     0.006     0.200
    59.972    -0.679     0.200
    59.972    -0.483     0.200
    60.410    -0.672     0.200
    60.419    -0.838     0.200
    61.073     0.561     0.200
    61.475     0.705     0.200
    61.551     0.396     0.200
    61.730     1.882     0.200
    62.118     0.132     0.200
    62.468     0.360     0.200
    62.740    -0.173     0.200
    62.892    -0.400     0.200
    63.325    -1.952     0.200
    63.309     1.555     0.200
    63.309    -0.843     0.200
    63.403    -0.074     0.200
    63.411    -0.106     0.200
    63.500     0.189     0.200
    63.616    -0.646     0.200
    63.617    -0.808     0.200
    63.683    -0.266     0.200
    63.700     0.441     0.200
    63.706     0.033     0.200
    63.760    -0.023     0.200
    63.861    -0.787     0.200
    63.860    -0.480     0.200
    63.860    -0.660     0.200
    63.948    -0.159     0.200
    63.948    -0.862     0.200
    63.948    -0.339     0.200
    63.948     0.099     0.200
    64.007    -0.006     0.200
    64.038    -0.634     0.200
    64.046    -0.630     0.200
    64.057    -0.555     0.200
    64.117     0.102     0.200
    64.181    -0.489     0.200
    64.230    -0.904     0.200
    64.209    -0.173     0.200
    64.341     0.167     0.200
    64.341    -0.536     0.200
    64.341    -0.872     0.200
    64.374     0.347     0.200
    64.584    -0.524     0.200
    64.586     0.065     0.200
    64.607    -0.373     0.200
    64.607    -0.646     0.200
    64.688    -0.008     0.200
    64.822     0.822     0.200
    64.877    -0.783     0.200
    64.934     0.258     0.200
    64.999     0.173     0.200
    65.007     1.225     0.200
    65.007     0.186     0.200
    65.096     0.091     0.200
    65.119    -0.200     0.200
    65.156    -0.243     0.200
    65.156    -0.025     0.200
    65.156     0.569     0.200
    65.159     0.163     0.200
    65.119     2.598     0.200
    65.119    -0.684     0.200
    65.119    -0.090     0.200
    65.268    -0.261     0.200
    65.443     0.501     0.200
    65.571     1.967     0.200
    65.630    -0.060     0.200
    65.694     0.169     0.200
    65.807     0.396     0.200
    65.860    -0.092     0.200
    65.917     0.595     0.200
    65.906    -0.587     0.200
    65.906    -0.384     0.200
    65.906    -0.438     0.200
    66.013    -0.171     0.200
    66.106     0.332     0.200
    66.205     0.697     0.200
    66.406    -0.094     0.200
    66.368     1.657     0.200
    66.368    -0.085     0.200
    66.368     0.563     0.200
    66.456     0.286     0.200
    66.456     0.098     0.200
    66.592    -0.729     0.200
    66.592     0.435     0.200
    66.582    -1.210     0.200
    66.582    -0.921     0.200
    66.672     0.615     0.200
    66.672     0.318     0.200
    66.884    -0.626     0.200
    66.885     0.460     0.200
    66.883    -0.116     0.200
    67.113     0.495     0.200
    67.456     0.285     0.200
    67.467     0.275     0.200
    67.515    -0.299     0.200
    67.536     0.203     0.200
    67.533    -0.370     0.200
    67.688     0.678     0.200
    67.688     0.826     0.200
    67.908     0.588     0.200
    67.908     0.315     0.200
    67.967    -0.759     0.200
    68.113    -0.041     0.200
    68.122     0.650     0.200
    68.122     0.759     0.200
    68.122     0.228     0.200
    68.166     0.174     0.200
    68.308     0.456     0.200
    68.336     0.298     0.200
    68.548    -0.036     0.200
    68.552    -0.241     0.200
    68.768     0.704     0.200
    68.768     0.298     0.200
    68.843     0.836     0.200
    68.843     0.477     0.200
    68.887     0.473     0.200
    68.887     0.254     0.200
    68.873     0.466     0.200
    68.907    -0.265     0.200
    68.940     0.642     0.200
    68.940     0.838     0.200
    68.944     0.329     0.200
    68.944     0.071     0.200
    68.921     0.759     0.200
    69.193    -0.927     0.200
    69.267     0.136     0.200
    69.267     0.504     0.200
    69.273    -0.041     0.200
    69.273    -0.923     0.200
    69.273    -1.119     0.200
    69.273    -0.658     0.200
    69.246     1.053     0.200
    69.309     1.230     0.200
    69.321     0.486     0.200
    69.368     0.203     0.200
    69.608     0.682     0.200
    69.619     0.373     0.200
    69.619     0.138     0.200
    69.633     0.659     0.200
    69.633    -0.661     0.200
    69.897     0.333     0.200
    69.944     0.649     0.200
    69.944    -0.632     0.200
    70.046     0.093     0.200
    70.055     1.171     0.200
    70.051    -0.510     0.200
    70.055     0.828     0.200
    70.055     1.406     0.200
    70.082     0.698     0.200
    70.185     1.372     0.200
    70.193     0.831     0.200
    70.193     0.440     0.200
    70.227     0.514     0.200
    70.204     1.117     0.200
    70.328     0.955     0.200
    70.328     0.338     0.200
    70.404     0.836     0.200
    70.404     0.523     0.200
    70.428     1.281     0.200
    70.398     0.469     0.200
    70.446     0.108     0.200
    70.446     1.179     0.200
    70.446     1.366     0.200
    70.470     0.948     0.200
    70.479     0.588     0.200
    70.479     0.455     0.200
    70.464    -0.531     0.200
    70.501     0.275     0.200
    70.557    -0.469     0.200
    70.557     0.038     0.200
    70.536     0.531     0.200
    70.582     0.450     0.200
    70.809     0.287     0.200
    70.834     0.205     0.200
    70.834     0.057     0.200
    70.887     0.291     0.200
    70.892     0.846     0.200
    70.892     0.549     0.200
    70.898     0.796     0.200
    70.898     0.514     0.200
    70.893     0.961     0.200
    70.953     0.494     0.200
    70.897     0.937     0.200
    71.032     0.720     0.200
    71.032     1.877     0.200
    71.099     0.406     0.200
    71.167     0.793     0.200
    71.167     0.449     0.200
    71.376     0.389     0.200
    71.372    -0.540     0.200
    71.500    -0.814     0.200
    71.538     0.758     0.200
    71.558     0.220     0.200
    71.579     0.467     0.200
    71.714     0.610     0.200
    71.694     0.722     0.200
    71.770     0.246     0.200
    71.733     0.207     0.200
    71.787     0.859     0.200
    71.831    -0.171     0.200
    71.795     0.513     0.200
    71.795     1.193     0.200
    71.819     0.389     0.200
    71.819     0.874     0.200
    71.895     0.875     0.200
    71.906     1.890     0.200
    71.932     0.986     0.200
    71.943     1.228     0.200
    71.995     0.904     0.200
    71.922     1.855     0.200
    72.019     0.852     0.200
    72.023     0.937     0.200
    72.044     1.264     0.200
    72.117     0.954     0.200
    72.117     0.704     0.200
    72.140     0.952     0.200
    72.159     1.311     0.200
    72.206     0.850     0.200
    72.301     0.699     0.200
    72.324     0.877     0.200
    72.339     1.200     0.200
    72.339     0.957     0.200
    72.339     0.692     0.200
    72.339     0.442     0.200
    72.381    -0.796     0.200
    72.500     0.211     0.200
    72.532     0.743     0.200
    72.521    -1.423     0.200
    72.549     0.122     0.200
    72.580     0.619     0.200
    72.574     1.131     0.200
    72.713     0.551     0.200
    72.748     0.252     0.200
    72.683     1.158     0.200
    72.776     0.892     0.200
    72.776     0.626     0.200
    72.777     0.307     0.200
    72.834    -0.885     0.200
    72.862     1.090     0.200
    72.949     0.920     0.200
    72.949     0.600     0.200
    72.943     0.277     0.200
    72.981     1.112     0.200
    72.981     0.987     0.200
    73.065    -1.547     0.200
    73.092     1.536     0.200
    73.142     0.458     0.200
    73.249     0.978     0.200
    73.249     0.876     0.200
    73.220     0.433     0.200
    73.310     0.009     0.200
    73.310     0.205     0.200
    73.372     0.517     0.200
    73.474     0.754     0.200
    73.497     0.269     0.200
    73.542     0.361     0.200
    73.542     1.158     0.200
    73.495     1.111     0.200
    73.600     1.801     0.200
    73.633     0.249     0.200
    73.667     0.013     0.200
    73.667    -0.378     0.200
    73.667     0.224     0.200
    73.667    -0.191     0.200
    73.664    -0.277     0.200
    73.690     0.532     0.200
    73.700     0.695     0.200
    73.741    -0.525     0.200
    73.833     0.687     0.200
    73.850     0.405     0.200
    73.850     0.624     0.200
    73.847    -0.349     0.200
    73.885     0.562     0.200
    73.969     0.316     0.200
    73.974     0.315     0.200
    73.981     0.242     0.200
    74.029     0.532     0.200
    74.074    -1.869     0.200
    74.050     0.671     0.200
    74.103     0.601     0.200
    74.145     0.522     0.200
    74.145     0.327     0.200
    74.158    -0.861     0.200
    74.167    -1.016     0.200
    74.172    -0.645     0.200
    74.198    -0.898     0.200
    74.210    -0.161     0.200
    74.215     0.394     0.200
    74.222     0.223     0.200
    74.222     0.450     0.200
    74.234     0.542     0.200
    74.233    -0.296     0.200
    74.223    -0.645     0.200
    74.223    -0.840     0.200
    74.223    -0.739     0.200
    74.231    -0.260     0.200
    74.231    -0.494     0.200
    74.231    -0.885     0.200
    74.234    -0.902     0.200
    74.235    -0.908     0.200
    74.252     0.749     0.200
    74.252     0.647     0.200
    74.312     0.440     0.200
    74.340    -0.823     0.200
    74.322     0.583     0.200
    74.443     0.642     0.200
    74.450     0.795     0.200
    74.480     1.062     0.200
    74.508     0.400     0.200
    74.538     0.508     0.200
    74.529     0.810     0.200
    74.529     0.669     0.200
    74.545     0.689     0.200
    74.588     0.736     0.200
    74.588     0.596     0.200
    74.710     0.529     0.200
    74.710     0.841     0.200
    74.754     0.874     0.200
    74.754     0.476     0.200
    74.799     0.512     0.200
    74.799     0.691     0.200
    74.799     1.184     0.200
    74.807    -0.404     0.200
    74.890    -0.104     0.200
    74.897    -0.550     0.200
    74.945    -0.227     0.200
    74.945     0.077     0.200
    74.945     0.218     0.200
    74.994     1.490     0.200
    75.042     0.715     0.200
    75.054     0.745     0.200
    75.054     0.597     0.200
    75.078    -0.792     0.200
    75.056     2.233     0.200
    75.056     0.866     0.200
    75.056     1.131     0.200
    75.114     0.998     0.200
    75.162     0.939     0.200
    75.178     1.012     0.200
    75.178     1.051     0.200
    75.178     0.327     0.200
    75.178     0.991     0.200
    75.148     1.206     0.200
    75.208    -0.345     0.200
    75.205     0.477     0.200
    75.223     1.016     0.200
    75.315    -0.153     0.200
    75.309     0.781     0.200
    75.309     0.640     0.200
    75.358     0.607     0.200
    75.358    -0.081     0.200
    75.358     0.201     0.200
    75.358     0.451     0.200
    75.421     0.888     0.200
    75.503     0.926     0.200
    75.459     2.121     0.200
    75.522     0.558     0.200
    75.560     0.934     0.200
    75.588     0.882     0.200
    75.624     0.660     0.200
    75.749     0.658     0.200
    75.750     1.255     0.200
    75.775     0.906     0.200
    75.717     1.184     0.200
    75.717     0.590     0.200
    75.785     0.550     0.200
    75.783     0.566     0.200
    75.799     0.700     0.200
    75.804     0.642     0.200
    75.804     0.447     0.200
    75.820     1.037     0.200
    75.820     0.905     0.200
    75.801     3.463     0.200
    75.801     1.924     0.200
    75.868     0.981     0.200
    75.868     0.583     0.200
    75.868     1.130     0.200
    75.890     0.607     0.200
    75.914     0.603     0.200
    75.950     0.510     0.200
    75.950     0.651     0.200
    75.950     0.753     0.200
    75.985     0.775     0.200
    75.985     1.267     0.200
    75.999     0.688     0.200
    76.008     0.612     0.200
    76.013     1.655     0.200
    76.045    -0.027     0.200
    76.045     0.278     0.200
    76.045     0.567     0.200
    76.081     1.406     0.200
    76.146    -0.201     0.200
    76.159     0.035     0.200
    76.159     0.816     0.200
    76.159     0.410     0.200
    76.212     0.424     0.200
    76.226     0.842     0.200
    76.226     1.006     0.200
    76.279     1.643     0.200
    76.268     2.126     0.200
    76.268     1.407     0.200
    76.319     0.016     0.200
    76.319     0.704     0.200
    76.330     0.458     0.200
    76.330     0.661     0.200
    76.384     1.050     0.200
    76.461    -0.387     0.200
    76.491    -0.657     0.200
    76.531     0.118     0.200
    76.495     1.226     0.200
    76.495     0.906     0.200
    76.619     1.023     0.200
    76.685     1.399     0.200
    76.702     0.933     0.200
    76.756     0.946     0.200
    76.756     1.344     0.200
    76.831    -0.162     0.200
    76.831    -0.872     0.200
    76.840     0.192     0.200
    76.872     1.014     0.200
    76.895     0.268     0.200
    76.895     0.416     0.200
    76.928     0.145     0.200
    76.923    -0.293     0.200
    76.958    -0.292     0.200
    76.989     0.859     0.200
    77.026     0.769     0.200
    77.057     0.055     0.200
    77.032     0.255     0.200
    77.032     0.779     0.200
    77.127     1.321     0.200
    77.151     0.976     0.200
    77.162     1.072     0.200
    77.179     0.429     0.200
    77.179     0.577     0.200
    77.219     0.940     0.200
    77.249     1.396     0.200
    77.249     0.732     0.200
    77.308     0.481     0.200
    77.335    -0.404     0.200
    77.337     1.684     0.200
    77.337     1.809     0.200
    77.343     0.767     0.200
    77.360     1.733     0.200
    77.404     1.091     0.200
    77.428     1.176     0.200
    77.470     1.230     0.200
    77.454     0.179     0.200
    77.468     0.976     0.200
    77.473     1.361     0.200
    77.479     0.732     0.200
    77.479     0.896     0.200
    77.482     0.574     0.200
    77.482     0.254     0.200
    77.512     1.567     0.200
    77.502    -0.340     0.200
    77.508     0.776     0.200
    77.524     0.888     0.200
    77.536    -0.426     0.200
    77.548     1.707     0.200
    77.547     0.891     0.200
    77.586     2.068     0.200
    77.623     1.198     0.200
    77.638     1.055     0.200
    77.679     1.666     0.200
    77.680     1.612     0.200
    77.693     1.222     0.200
    77.677     1.093     0.200
    77.700     0.620     0.200
    77.740     0.332     0.200
    77.740     0.598     0.200
    77.776     1.232     0.200
    77.779     1.537     0.200
    77.779     1.381     0.200
    77.805     1.177     0.200
    77.820     0.989     0.200
    77.827     0.551     0.200
    77.827     1.075     0.200
    77.827     1.207     0.200
    77.825     0.626     0.200
    77.869     1.192     0.200
    77.869     1.606     0.200
    77.905     1.348     0.200
    77.909     1.279     0.200
    77.927     1.208     0.200
    77.952     1.782     0.200
    77.939     0.509     0.200
    77.939    -0.069     0.200
    77.966     1.080     0.200
    77.966     1.346     0.200
    77.983     0.845     0.200
    78.001     1.194     0.200
    78.036     1.406     0.200
    78.064    -0.265     0.200
    78.075     1.653     0.200
    78.095     0.503     0.200
    78.127     0.969     0.200
    78.126    -1.604     0.200
    78.090     0.352     0.200
    78.170     1.624     0.200
    78.190     0.361     0.200
    78.248     0.891     0.200
    78.248     1.219     0.200
    78.248     1.508     0.200
    78.261     0.942     0.200
    78.261     0.684     0.200
    78.261     1.645     0.200
    78.261     0.153     0.200
    78.326     0.492     0.200
    78.342     0.615     0.200
    78.342    -0.401     0.200
    78.349     0.393     0.200
    78.363     0.894     0.200
    78.367     0.459     0.200
    78.381     0.837     0.200
    78.426     0.868     0.200
    78.472     0.706     0.200
    78.529     0.955     0.200
    78.532     0.123     0.200
    78.532    -0.049     0.200
    78.561    -0.409     0.200
    78.589     1.464     0.200
    78.647     1.224     0.200
    78.719     0.952     0.200
    78.820     1.835     0.200
    78.820     1.343     0.200
    78.835    -0.215     0.200
    78.899     0.823     0.200
    78.941     0.594     0.200
    78.941     0.203     0.200
    78.941     0.477     0.200
    78.905     0.704     0.200
    78.948     1.805     0.200
    78.948     0.570     0.200
    78.948     1.023     0.200
    78.911     0.321     0.200
    78.963     0.884     0.200
    78.964     0.278     0.200
    78.964     0.926     0.200
    78.984     1.070     0.200
    78.979     1.133     0.200
    78.981     1.076     0.200
    79.007    -0.056     0.200
    79.012     0.300     0.200
    79.006     1.532     0.200
    79.013     1.432     0.200
    79.082    -0.072     0.200
    79.123     1.307     0.200
    79.130     0.653     0.200
    79.079     1.047     0.200
    79.081     0.937     0.200
    79.157     1.058     0.200
    79.172     0.787     0.200
    79.172     0.506     0.200
    79.191     0.967     0.200
    79.213     1.715     0.200
    79.215     1.352     0.200
    79.261     1.711     0.200
    79.269     1.582     0.200
    79.269     0.676     0.200
    79.301     1.583     0.200
    79.304     1.554     0.200
    79.333     2.172     0.200
    79.333     0.867     0.200
    79.333     2.578     0.200
    79.314     1.289     0.200
    79.376     1.965     0.200
    79.359    -0.480     0.200
    79.335    -0.750     0.200
    79.335    -0.141     0.200
    79.377     0.772     0.200
    79.397     0.018     0.200
    79.401     1.379     0.200
    79.432     2.300     0.200
    79.446     0.841     0.200
    79.447     1.652     0.200
    79.468     0.232     0.200
    79.458     1.710     0.200
    79.458     1.147     0.200
    79.458     0.686     0.200
    79.458    -0.423     0.200
    79.458     0.327     0.200
    79.458     0.944     0.200
    79.471     1.314     0.200
    79.481     1.549     0.200
    79.516     0.768     0.200
    79.550     0.566     0.200
    79.570     0.269     0.200
    79.579     1.400     0.200
    79.579     0.213     0.200
    79.579     0.650     0.200
    79.576     0.239     0.200
    79.629     1.395     0.200
    79.645     0.167     0.200
    79.645     0.769     0.200
    79.664     0.956     0.200
    79.674     0.908     0.200
    79.687     0.048     0.200
    79.745     0.867     0.200
    79.761     0.674     0.200
    79.759     1.052     0.200
    79.787     1.399     0.200
    79.791     0.102     0.200
    79.795     1.439     0.200
    79.795     1.751     0.200
    79.927     1.127     0.200
    79.892     0.059     0.200
    79.876     0.239     0.200
    80.010     0.490     0.200
    80.096     0.547     0.200
    80.115     1.486     0.200
    80.118     0.869     0.200
    80.175     0.490     0.200
    80.160     1.009     0.200
    80.261    -0.161     0.200
    80.278     0.437     0.200
    80.315     1.528     0.200
    80.282     1.050     0.200
    80.256     1.469     0.200
    80.256     0.242     0.200
    80.256     1.226     0.200
    80.378     1.827     0.200
    80.378     0.171     0.200
    80.391     1.968     0.200
    80.385     0.824     0.200
    80.411     1.365     0.200
    80.398     0.344     0.200
    80.412     0.708     0.200
    80.428     0.640     0.200
    80.452     1.831     0.200
    80.484     0.977     0.200
    80.492     1.441     0.200
    80.494     0.590     0.200
    80.494    -0.238     0.200
    80.494     0.489     0.200
    80.558     0.674     0.200
    80.582     1.334     0.200
    80.574     0.042     0.200
    80.574    -0.130     0.200
    80.554     0.687     0.200
    80.624    -0.605     0.200
    80.616     0.332     0.200
    80.669    -0.155     0.200
    80.695     0.988     0.200
    80.729     0.910     0.200
    80.708     0.839     0.200
    80.708     1.347     0.200
    80.782     1.470     0.200
    80.800     1.985     0.200
    80.818     1.830     0.200
    80.810     0.948     0.200
    80.837     1.287     0.200
    80.825    -0.081     0.200
    80.844     0.482     0.200
    80.859     1.319     0.200
    80.867     1.273     0.200
    80.873     0.367     0.200
    80.892     1.600     0.200
    80.847     1.232     0.200
    80.887     1.635     0.200
    80.959     0.603     0.200
    81.051     0.020     0.200
    81.120     0.185     0.200
    81.123     1.323     0.200
    81.123     0.951     0.200
    81.170     0.609     0.200
    81.232    -0.346     0.200
    81.232    -0.018     0.200
    81.232     0.240     0.200
    81.279     1.102     0.200
    81.298     1.302     0.200
    81.280     1.298     0.200
    81.325    -1.240     0.200
    81.291     1.496     0.200
    81.291     2.238     0.200
    81.291     2.394     0.200
    81.393     1.388     0.200
    81.359     0.694     0.200
    81.431     0.418     0.200
    81.467     0.228     0.200
    81.452     0.186     0.200
    81.478     0.118     0.200
    81.416     0.727     0.200
    81.477    -0.746     0.200
    81.514     0.988     0.200
    81.550     1.095     0.200
    81.524     1.029     0.200
    81.524     0.443     0.200
    81.524     0.552     0.200
    81.533     1.664     0.200
    81.505     0.991     0.200
    81.725     0.283     0.200
    81.770     1.258     0.200
    81.770     1.649     0.200
    81.779    -0.735     0.200
    81.768    -0.883     0.200
    81.800     0.050     0.200
    81.834     1.077     0.200
    81.842     1.571     0.200
    81.899     1.302     0.200
    81.907     1.287     0.200
    81.909     0.992     0.200
    81.898     0.810     0.200
    81.898     2.146     0.200
    81.955     0.532     0.200
    81.872     0.672     0.200
    81.935     0.480     0.200
    82.040     0.821     0.200
    82.039    -0.904     0.200
    82.116     0.096     0.200
    82.251     0.286     0.200
    82.251    -0.018     0.200
    82.296     0.157     0.200
    82.321     1.117     0.200
    82.314     0.458     0.200
    82.351     1.198     0.200
    82.392     0.155     0.200
    82.406     1.167     0.200
    82.433    -0.465     0.200
    82.433    -0.764     0.200
    82.611     0.206     0.200
    82.619     1.167     0.200
    82.619     0.870     0.200
    82.693     1.570     0.200
    82.705    -0.075     0.200
    82.735     0.985     0.200
    82.732     0.338     0.200
    82.732     0.151     0.200
    82.732     0.542     0.200
    82.795     1.891     0.200
    82.813     0.353     0.200
    82.813     1.759     0.200
    82.813     1.127     0.200
    82.813     0.478     0.200
    82.813     2.119     0.200
    82.857    -0.264     0.200
    82.902     0.902     0.200
    82.974     0.527     0.200
    82.974     0.027     0.200
    83.035     0.766     0.200
    83.035     2.008     0.200
    83.030     0.638     0.200
    83.177     0.583     0.200
    83.177     0.841     0.200
    82.965     2.050     0.200
    83.192     3.097     0.200
    83.192    -0.270     0.200
    83.195     1.616     0.200
    83.229     0.008     0.200
    83.229     1.172     0.200
    83.232     1.000     0.200
    83.232     0.125     0.200
    83.232     1.336     0.200
    83.214     0.087     0.200
    83.307     2.209     0.200
    83.307    -0.353     0.200
    83.307     0.116     0.200
    83.371     0.902     0.200
    83.398     1.208     0.200
    83.463     1.125     0.200
    83.484     0.682     0.200
    83.472     0.493     0.200
    83.620    -0.603     0.200
    83.697     1.745     0.200
    83.758     0.552     0.200
    83.853     1.196     0.200
    83.920     1.084     0.200
    83.932     1.227     0.200
    83.912     0.337     0.200
    83.980     1.191     0.200
    83.987     2.185     0.200
    83.944    -0.327     0.200
    83.944    -1.452     0.200
    83.944     0.158     0.200
    84.014     1.242     0.200
    84.018     0.895     0.200
    84.057     1.152     0.200
    84.081     0.956     0.200
    84.081     1.058     0.200
    84.099    -0.236     0.200
    84.160     0.806     0.200
    84.200     1.402     0.200
    84.251     1.195     0.200
    84.321     1.234     0.200
    84.318     0.894     0.200
    84.360     0.769     0.200
    84.375    -0.312     0.200
    84.459     1.207     0.200
    84.459     1.074     0.200
    84.497     0.936     0.200
    84.515     0.367     0.200
    84.470     0.572     0.200
    84.544     0.964     0.200
    84.601     0.913     0.200
    84.601     1.186     0.200
    84.601     2.124     0.200
    84.610     1.294     0.200
    84.610     0.739     0.200
    84.610     1.755     0.200
    84.600     1.042     0.200
    84.623     1.282     0.200
    84.623     0.345     0.200
    84.623     1.595     0.200
    84.694     0.998     0.200
    84.718     1.620     0.200
    84.780     1.064     0.200
    84.791     0.952     0.200
    84.791     0.608     0.200
    84.792     0.700     0.200
    84.792     0.372     0.200
    84.862     2.254     0.200
    85.053     0.614     0.200
    85.178     1.123     0.200
    85.204     0.241     0.200
    85.239     0.757     0.200
    85.285     0.963     0.200
    85.365     1.259     0.200
    85.350     1.531     0.200
    85.411     1.596     0.200
    85.451     0.114     0.200
    85.517     1.564     0.200
    85.492     0.253     0.200
    85.705    -0.578     0.200
    85.775     0.426     0.200
    85.909     1.427     0.200
    85.928     1.044     0.200
    86.133     0.168     0.200
    86.377     0.803     0.200
    86.508     1.291     0.200
    86.522     1.744     0.200
    86.487     0.020     0.200
    86.610     1.776     0.200
    86.663     0.617     0.200
    86.685     2.528     0.200
    86.816    -1.183     0.200
    86.816    -0.910     0.200
    86.766     1.050     0.200
    86.902     0.632     0.200
    86.946    -0.327     0.200
    86.958    -1.518     0.200
    87.143     1.938     0.200
    87.210     1.808     0.200
    87.210     1.425     0.200
    87.296     0.940     0.200
    87.365     0.504     0.200
    87.977     0.662     0.200
    88.059     1.757     0.200
    88.059     0.257     0.200
    88.136    -0.216     0.200
    88.620     0.294     0.200
    88.620     1.153     0.200
    88.605    -0.096     0.200
    88.605     0.693     0.200
    88.719     0.530     0.200
    88.800     0.944     0.200
    88.906     1.051     0.200
    88.909     0.418     0.200
    88.909     1.848     0.200
    88.909     0.043     0.200
    88.903    -0.427     0.200
    88.903     1.573     0.200
    88.903     1.112     0.200
    89.227    -0.059     0.200
    89.440    -0.813     0.200
    89.440     0.750     0.200
    89.538    -0.665     0.200
    89.538     0.796     0.200
    89.609     0.285     0.200
    89.610     0.100     0.200
    89.654     1.297     0.200
    89.689     0.390     0.200
    89.798    -0.517     0.200
    89.917     0.714     0.200
    90.026    -0.413     0.200
    90.270     0.496     0.200
    90.472     0.414     0.200
    90.735     0.543     0.200
    90.932     1.489     0.200
    91.228     0.278     0.200
    91.480    -0.060     0.200
    91.490     0.658     0.200
    91.490     1.408     0.200
    91.490     0.455     0.200
    91.796     0.978     0.200
    92.270     1.108     0.200
    92.434    -0.183     0.200
    92.434     2.043     0.200
    92.434     1.403     0.200
    92.699     0.461     0.200
    92.828     2.427     0.200
    93.086    -0.056     0.200
    93.086    -0.392     0.200
    93.333    -0.350     0.200
    93.431     0.433     0.200
    93.423    -0.428     0.200
    93.494     1.459     0.200
    93.494     0.420     0.200
    93.508    -0.125     0.200
    93.508    -0.821     0.200
    93.556    -0.067     0.200
    93.556    -0.356     0.200
    94.212     0.708     0.200
    94.369    -0.545     0.200
    94.484     0.914     0.200
    94.484    -0.390     0.200
    94.484     0.211     0.200
    94.483    -0.369     0.200
    94.632     1.820     0.200
    94.696     0.050     0.200
    94.775    -0.084     0.200
    94.863    -0.150     0.200
    95.053     2.254     0.200
    95.053     2.364     0.200
    95.136     0.568     0.200
    95.404    -0.108     0.200
    95.507     0.157     0.200
    95.545    -0.088     0.200
    95.760     0.409     0.200
    95.878     1.038     0.200
    95.984     0.939     0.200
    96.036     3.430     0.200
    96.158     0.655     0.200
    96.326     0.169     0.200
    96.385     0.031     0.200
    96.383     2.251     0.200
    96.383     0.282     0.200
    96.431     0.579     0.200
    96.431     1.228     0.200
    96.431    -0.093     0.200
    96.824     0.950     0.200
    96.838     0.884     0.200
    96.868     0.101     0.200
    96.868    -0.298     0.200
    96.878    -0.592     0.200
    96.986     0.069     0.200
    97.210     0.492     0.200
    97.719     0.231     0.200
    98.760    -0.056     0.200
    98.760     0.522     0.200
    17.781     0.275     0.200
    21.279    -1.276     0.200
    23.859     0.159     0.200
    23.859    -1.427     0.200
    24.970    -1.733     0.200
    24.970    -0.223     0.200
    46.724    -0.753     0.200
    46.789     0.497     0.200
    51.012     0.190     0.200
    55.579    -1.634     0.200
    55.579    -0.917     0.200
    59.171    -0.810     0.200
    63.677    -0.739     0.200
    63.677    -0.590     0.200
    63.919    -0.806     0.200
    63.999    -0.357     0.200
    64.108    -0.699     0.200
    64.665    -0.553     0.200
    64.936    -0.659     0.200
    65.954    -0.727     0.200
    65.954    -0.319     0.200
    68.170    -0.068     0.200
    70.890     0.346     0.200
    70.890     0.256     0.200
    73.790    -0.306     0.200
    74.218    -0.604     0.200
    74.232    -0.685     0.200
    74.253    -0.708     0.200
    74.265    -0.476     0.200
    74.271    -0.711     0.200
    74.283    -0.557     0.200
    74.283    -0.351     0.200
    74.291    -0.926     0.200
    74.294    -0.443     0.200
    74.309    -0.632     0.200
    74.309    -0.329     0.200
    75.138    -0.730     0.200
    75.582     0.524     0.200
    75.927     0.354     0.200
    76.218     0.294     0.200
    76.218     0.528     0.200
    76.551     0.216     0.200
    76.891    -0.402     0.200
    77.221     0.454     0.200
    77.514     0.125     0.200
    77.543     0.006     0.200
    77.567     0.798     0.200
    77.583     0.333     0.200
    77.682     0.999     0.200
    77.964     1.782     0.200
    78.440     1.307     0.200
    78.589     1.191     0.200
    79.704     0.999     0.200
    81.549     0.008     0.200
    81.549     0.889     0.200
    83.232     1.195     0.200
    83.232     1.030     0.200
    85.237     0.328     0.200
    85.475     0.912     0.200
    23.475    -1.026     0.200
    25.457    -0.311     0.200
    26.726     0.251     0.200
    29.678     0.238     0.200
    31.635     1.933     0.200
    31.746     0.132     0.200
    33.720     2.303     0.200
    33.720     0.143     0.200
    46.526     1.951     0.200
    46.526    -0.094     0.200
    46.925    -1.677     0.200
    55.233    -0.976     0.200
    55.233     0.133     0.200
    55.621    -1.567     0.200
    55.621    -0.741     0.200
    57.750     2.998     0.200
    59.496    -0.707     0.200
    59.496     0.200     0.200
    63.726    -0.700     0.200
    63.726    -0.366     0.200
    64.314     0.320     0.200
    64.423     0.089     0.200
    64.675     0.306     0.200
    64.927    -0.719     0.200
    66.299    -0.346     0.200
    66.299     0.094     0.200
    71.129     0.005     0.200
    71.129     0.097     0.200
    74.355    -0.765     0.200
    74.355    -1.050     0.200
    82.022     0.530     0.200
    83.094     0.915     0.200
    83.094     0.599     0.200
    16.606     1.232     0.200
    17.142     0.372     0.200
    21.197    -0.688     0.200
    22.121    -2.120     0.200
    23.690    -1.255     0.200
    23.690    -1.024     0.200
    25.254    -0.060     0.200
    31.835     1.992     0.200
    33.942     1.403     0.200
    33.942    -0.087     0.200
    36.392     2.115     0.200
    55.084    -0.494     0.200
    59.405    -0.497     0.200
    59.405    -0.725     0.200
    63.776    -0.868     0.200
    63.776    -0.639     0.200
    63.980    -0.276     0.200
    64.230    -0.422     0.200
    64.339    -0.441     0.200
    64.520     0.101     0.200
    64.849    -0.101     0.200
    65.003    -1.053     0.200
    66.198    -0.886     0.200
    66.198    -0.421     0.200
    66.304    -0.574     0.200
    68.184    -0.119     0.200
    74.394    -1.060     0.200
    74.402    -0.299     0.200
    81.834    -0.157     0.200
    83.224     0.274     0.200
    84.982     0.863     0.200
    17.871    -0.258     0.200
    18.416    -2.393     0.200
    18.416    -1.729     0.200
    21.927    -2.132     0.200
    24.132    -1.560     0.200
    24.439     0.118     0.200
    24.439    -0.207     0.200
    24.439    -0.101     0.200
    24.571    -0.187     0.200
    24.576    -0.807     0.200
    27.471    -0.881     0.200
    32.575    -0.119     0.200
    36.596     0.314     0.200
    50.150    -0.042     0.200
    50.605     0.244     0.200
    55.908    -2.417     0.200
    55.908    -0.770     0.200
    63.902     0.005     0.200
    63.996    -1.557     0.200
    63.996    -1.346     0.200
    64.011     0.274     0.200
    70.929    -0.424     0.200
    73.277    -0.326     0.200
    73.277     0.014     0.200
    74.570    -1.172     0.200
    81.075     0.021     0.200
    81.075     0.740     0.200
    83.768     0.408     0.200
    15.079     4.519     0.200
    16.251     2.290     0.200
    16.762     1.258     0.200
    18.367    -1.999     0.200
    18.367    -0.630     0.200
    24.520    -0.586     0.200
    24.583    -0.221     0.200
    24.468     0.520     0.200
    24.468     0.059     0.200
    54.507    -0.132     0.200
    54.507     0.278     0.200
    55.876    -1.450     0.200
    55.876    -0.715     0.200
    56.061    -0.089     0.200
    63.898    -0.363     0.200
    63.965    -1.243     0.200
    63.965    -0.843     0.200
    64.007    -0.080     0.200
    64.238    -1.098     0.200
    64.289    -0.848     0.200
    64.609    -0.611     0.200
    65.294    -1.513     0.200
    65.800    -0.867     0.200
    65.800    -0.128     0.200
    68.625    -0.215     0.200
    70.915    -0.232     0.200
    73.272     0.249     0.200
    74.541    -1.391     0.200
    74.541    -1.131     0.200
    74.549    -1.205     0.200
    77.689     0.160     0.200
    80.680     0.901     0.200
    81.100     0.786     0.200
    81.100     0.165     0.200
    83.724    -0.511     0.200
    83.724    -0.030     0.200
    16.809     1.344     0.200
    18.379    -1.350     0.200
    18.379    -0.326     0.200
    21.876    -1.077     0.200
    24.402     0.581     0.200
    24.406    -0.273     0.200
    24.406     0.688     0.200
    24.807     0.495     0.200
    24.807     0.557     0.200
    24.807     0.854     0.200
    25.707     2.120     0.200
    34.513     1.785     0.200
    36.535     0.090     0.200
    38.041     0.120     0.200
    41.161    -0.523     0.200
    41.715     0.652     0.200
    42.588    -1.020     0.200
    44.481     1.510     0.200
    45.383     1.314     0.200
    45.369     0.896     0.200
    45.369     1.677     0.200
    45.369     0.997     0.200
    46.584    -1.094     0.200
    46.615     0.881     0.200
    46.615    -0.357     0.200
    46.806     0.309     0.200
    46.806     0.520     0.200
    47.058    -1.358     0.200
    47.058    -0.819     0.200
    47.224     1.724     0.200
    47.438    -0.814     0.200
    47.438    -1.001     0.200
    48.530     0.049     0.200
    49.770    -0.728     0.200
    51.471    -0.025     0.200
    53.000     0.118     0.200
    54.867     0.501     0.200
    54.867     0.212     0.200
    56.089    -0.924     0.200
    57.255     2.694     0.200
    59.397    -0.644     0.200
    62.729     0.434     0.200
    63.080     0.427     0.200
    63.348     0.420     0.200
    64.182    -0.644     0.200
    64.239     0.082     0.200
    64.275     0.603     0.200
    64.348    -0.879     0.200
    64.464    -0.531     0.200
    64.464    -1.430     0.200
    64.657     0.713     0.200
    64.784    -0.482     0.200
    64.935    -0.334     0.200
    65.008     0.523     0.200
    65.476    -0.615     0.200
    65.775    -0.339     0.200
    66.149    -0.600     0.200
    68.747     0.395     0.200
    72.610    -0.037     0.200
    73.450     3.127     0.200
    74.270     0.523     0.200
    74.772    -0.867     0.200
    76.761     0.514     0.200
    77.758     1.154     0.200
    77.999     0.771     0.200
    78.118     1.000     0.200
    78.231     0.426     0.200
    78.425     0.811     0.200
    78.509     1.375     0.200
    78.796     0.056     0.200
    78.980     0.807     0.200
    79.130     0.875     0.200
    80.121     0.142     0.200
    81.449     0.770     0.200
    83.820     1.228     0.200
    83.820     1.084     0.200
    85.312     0.574     0.200
    96.313     0.441     0.200
    17.135     1.148     0.200
    18.825     0.264     0.200
    20.299     0.753     0.200
    20.299     0.003     0.200
    21.294    -1.592     0.200
    21.361    -0.945     0.200
    21.361    -1.457     0.200
    22.233    -2.821     0.200
    22.233    -2.357     0.200
    22.581    -2.032     0.200
    23.472     2.573     0.200
    23.981    -1.360     0.200
    23.987    -0.036     0.200
    24.296     0.169     0.200
    24.296    -0.280     0.200
    24.296    -0.733     0.200
    24.296    -1.151     0.200
    24.799    -0.008     0.200
    24.799    -0.157     0.200
    24.799    -0.286     0.200
    25.315    -1.301     0.200
    26.585     0.913     0.200
    26.585    -1.259     0.200
    26.585    -0.309     0.200
    26.699    -0.511     0.200
    26.770     1.150     0.200
    26.882     1.942     0.200
    26.882     2.063     0.200
    28.064     2.254     0.200
    29.404     2.159     0.200
    30.388     2.200     0.200
    31.107     3.289     0.200
    31.284    -0.640     0.200
    31.491     1.433     0.200
    32.291     0.762     0.200
    33.438    -1.311     0.200
    33.438    -1.010     0.200
    33.502     2.205     0.200
    33.502     1.423     0.200
    33.972     1.750     0.200
    34.127     0.604     0.200
    34.183     2.816     0.200
    34.386     1.865     0.200
    34.386     1.384     0.200
    35.382     1.275     0.200
    35.734    -1.947     0.200
    35.734    -1.084     0.200
    36.026     0.140     0.200
    36.176     0.573     0.200
    36.352     2.234     0.200
    36.648    -0.448     0.200
    36.648    -0.768     0.200
    36.711     1.010     0.200
    36.711     1.650     0.200
    36.827     3.432     0.200
    36.827     1.541     0.200
    36.844     2.131     0.200
    37.741     0.514     0.200
    37.947     0.276     0.200
    37.949     0.232     0.200
    38.570     1.801     0.200
    38.684     0.276     0.200
    38.835     0.510     0.200
    40.611    -1.041     0.200
    40.728    -0.641     0.200
    40.942     2.002     0.200
    40.942     2.861     0.200
    41.161     0.104     0.200
    41.418     0.227     0.200
    41.418     0.559     0.200
    41.452     2.012     0.200
    41.452     1.359     0.200
    41.452     0.910     0.200
    41.722     2.634     0.200
    42.036    -0.460     0.200
    42.036    -0.800     0.200
    42.105     0.111     0.200
    42.613    -1.349     0.200
    43.225    -0.404     0.200
    43.567    -0.536     0.200
    43.902     0.111     0.200
    43.856    -1.109     0.200
    44.418    -0.331     0.200
    44.440     2.491     0.200
    44.646     1.488     0.200
    44.841    -0.489     0.200
    44.889     0.046     0.200
    45.383    -0.054     0.200
    45.465     0.501     0.200
    45.465    -0.210     0.200
    45.465     0.810     0.200
    45.465     0.454     0.200
    45.465     1.282     0.200
    45.581    -0.330     0.200
    45.517     0.789     0.200
    46.030    -1.161     0.200
    46.030    -0.789     0.200
    46.030    -1.559     0.200
    45.996     1.308     0.200
    46.070     0.726     0.200
    46.070    -0.274     0.200
    46.070     0.886     0.200
    46.070     0.297     0.200
    46.070     0.523     0.200
    46.258     0.248     0.200
    46.258     0.486     0.200
    46.258     0.107     0.200
    46.630    -0.445     0.200
    46.630    -0.667     0.200
    46.616     0.540     0.200
    46.895    -0.912     0.200
    46.895    -0.802     0.200
    46.965    -0.507     0.200
    46.990    -0.363     0.200
    46.990     0.079     0.200
    47.189    -0.231     0.200
    47.189     0.480     0.200
    47.189     0.602     0.200
    47.189    -0.688     0.200
    47.190     1.763     0.200
    47.190     1.493     0.200
    47.702    -0.112     0.200
    47.976    -0.686     0.200
    47.976    -1.565     0.200
    47.968    -0.371     0.200
    47.968    -1.063     0.200
    48.065    -0.407     0.200
    48.562    -0.080     0.200
    48.527     0.716     0.200
    48.776     0.103     0.200
    49.119     0.878     0.200
    49.327    -0.158     0.200
    49.414    -1.064     0.200
    49.952     1.434     0.200
    50.613    -0.590     0.200
    50.707     0.627     0.200
    50.707     0.228     0.200
    51.044    -0.434     0.200
    51.171    -0.772     0.200
    51.196     3.247     0.200
    51.259     0.286     0.200
    51.259     0.396     0.200
    51.770    -0.638     0.200
    51.770    -1.236     0.200
    52.054     0.262     0.200
    52.526    -2.048     0.200
    52.613     0.313     0.200
    53.197     0.298     0.200
    53.370     0.027     0.200
    53.471    -0.754     0.200
    54.280    -1.414     0.200
    54.327    -0.058     0.200
    54.327     0.173     0.200
    54.327    -0.358     0.200
    54.327     0.302     0.200
    54.660     0.441     0.200
    54.660     0.093     0.200
    54.853    -1.059     0.200
    55.295    -1.259     0.200
    55.295    -1.149     0.200
    55.295    -0.919     0.200
    55.298     0.016     0.200
    55.507    -0.286     0.200
    55.554    -0.957     0.200
    55.554    -1.218     0.200
    55.554    -1.117     0.200
    55.589    -0.582     0.200
    55.696    -1.440     0.200
    56.045    -0.968     0.200
    56.118    -1.277     0.200
    56.222     0.802     0.200
    56.643     1.007     0.200
    56.796    -1.384     0.200
    56.796    -1.095     0.200
    56.796    -0.782     0.200
    56.796    -0.571     0.200
    56.796    -0.923     0.200
    57.164    -0.683     0.200
    57.131     0.847     0.200
    57.199    -1.831     0.200
    57.626    -0.640     0.200
    57.626    -0.453     0.200
    57.714    -0.708     0.200
    58.001     0.931     0.200
    58.307     0.243     0.200
    58.537    -0.323     0.200
    58.629    -0.350     0.200
    59.049    -0.264     0.200
    59.049    -0.264     0.200
    59.049    -0.694     0.200
    59.705     0.006     0.200
    60.006    -0.656     0.200
    61.332     1.120     0.200
    61.467     0.405     0.200
    62.529     0.389     0.200
    62.799    -0.463     0.200
    63.336    -1.479     0.200
    63.351    -0.077     0.200
    63.468     1.128     0.200
    63.474     0.036     0.200
    63.649    -0.845     0.200
    63.649    -0.709     0.200
    63.621     0.140     0.200
    63.621     0.441     0.200
    63.678     0.063     0.200
    63.775     0.188     0.200
    63.881    -0.168     0.200
    63.881     0.121     0.200
    63.881     0.019     0.200
    63.881     0.641     0.200
    63.916    -0.700     0.200
    63.916    -0.349     0.200
    63.919     0.292     0.200
    63.990    -0.162     0.200
    64.072     0.103     0.200
    64.094    -0.002     0.200
    64.106     0.109     0.200
    64.090    -0.040     0.200
    64.222    -1.011     0.200
    64.236    -0.428     0.200
    64.534     0.002     0.200
    64.536     0.239     0.200
    64.536    -0.191     0.200
    64.582    -0.463     0.200
    64.582    -0.725     0.200
    64.582    -0.123     0.200
    64.692     0.518     0.200
    64.845    -0.294     0.200
    64.845     0.284     0.200
    64.869     1.117     0.200
    64.929    -0.539     0.200
    64.957    -0.411     0.200
    64.957     1.710     0.200
    65.144     1.181     0.200
    65.178     0.242     0.200
    65.214    -0.174     0.200
    65.214     0.248     0.200
    65.223     0.282     0.200
    65.410     3.274     0.200
    65.826    -0.623     0.200
    65.826    -0.522     0.200
    65.826    -0.322     0.200
    65.890     0.106     0.200
    65.916    -0.161     0.200
    65.933    -0.114     0.200
    65.933    -0.353     0.200
    65.996     0.353     0.200
    66.111     0.844     0.200
    66.223     0.588     0.200
    66.612    -1.460     0.200
    66.612    -1.121     0.200
    66.751     0.357     0.200
    66.751     0.189     0.200
    66.939    -0.081     0.200
    66.969     0.340     0.200
    67.196     0.312     0.200
    67.588    -0.523     0.200
    67.617     0.310     0.200
    67.776     0.771     0.200
    67.776     0.571     0.200
    68.021    -0.542     0.200
    68.194     0.395     0.200
    68.194     0.645     0.200
    68.203     0.183     0.200
    68.203     0.574     0.200
    68.420     0.253     0.200
    68.563    -0.062     0.200
    68.600    -0.126     0.200
    68.797     0.481     0.200
    68.847     0.396     0.200
    68.785     0.956     0.200
    68.961    -0.293     0.200
    68.974     0.380     0.200
    69.032     0.318     0.200
    69.285    -0.949     0.200
    69.421    -0.199     0.200
    69.721     0.364     0.200
    69.970    -0.368     0.200
    70.003     0.731     0.200
    70.147     0.447     0.200
    70.209    -0.850     0.200
    70.274     0.987     0.200
    70.280     1.134     0.200
    70.330     0.530     0.200
    70.453    -0.724     0.200
    70.493     0.537     0.200
    70.457     0.558     0.200
    70.528    -0.369     0.200
    70.562     0.686     0.200
    70.562     0.417     0.200
    70.798    -0.070     0.200
    70.876     0.605     0.200
    70.820     0.944     0.200
    70.952     0.547     0.200
    70.978     0.977     0.200
    70.952     1.585     0.200
    71.023     0.617     0.200
    71.243     0.812     0.200
    71.459     0.401     0.200
    71.507    -1.307     0.200
    71.508     0.686     0.200
    71.716     0.826     0.200
    71.735     0.918     0.200
    71.826     1.676     0.200
    71.859     0.997     0.200
    71.868     1.221     0.200
    71.968     1.043     0.200
    72.081     0.588     0.200
    72.081     0.748     0.200
    72.266     1.150     0.200
    72.266     0.739     0.200
    72.266     0.548     0.200
    72.388     0.983     0.200
    72.388     0.702     0.200
    72.387    -0.978     0.200
    72.521    -1.379     0.200
    72.502     1.122     0.200
    72.586     1.281     0.200
    72.607    -0.004     0.200
    72.773     0.255     0.200
    72.773     0.439     0.200
    72.834     0.226     0.200
    72.839    -1.070     0.200
    73.041     0.860     0.200
    73.013     1.592     0.200
    73.069    -2.131     0.200
    73.154     0.670     0.200
    73.208     0.251     0.200
    73.208     0.505     0.200
    73.245     0.234     0.200
    73.309     1.066     0.200
    73.309     0.914     0.200
    73.357     1.775     0.200
    73.430     0.475     0.200
    73.537     0.491     0.200
    73.537     1.717     0.200
    73.568     0.254     0.200
    73.722    -0.068     0.200
    73.722     0.116     0.200
    73.722    -0.169     0.200
    73.758     0.855     0.200
    73.757     0.585     0.200
    73.772    -0.662     0.200
    73.878    -0.583     0.200
    73.919     0.480     0.200
    73.919     0.308     0.200
    73.902     0.877     0.200
    73.908     0.739     0.200
    74.038     0.219     0.200
    74.100     0.242     0.200
    74.101    -1.285     0.200
    74.183    -0.964     0.200
    74.192    -0.915     0.200
    74.198    -0.453     0.200
    74.198     0.602     0.200
    74.197    -1.142     0.200
    74.218    -0.766     0.200
    74.247    -0.738     0.200
    74.247    -0.539     0.200
    74.247    -0.937     0.200
    74.247    -1.039     0.200
    74.255    -0.349     0.200
    74.255    -0.662     0.200
    74.255    -0.884     0.200
    74.248     0.656     0.200
    74.273    -0.786     0.200
    74.281    -0.136     0.200
    74.286     0.306     0.200
    74.257     0.704     0.200
    74.291     0.357     0.200
    74.304    -0.265     0.200
    74.310     0.596     0.200
    74.310     0.455     0.200
    74.317     0.463     0.200
    74.426     1.025     0.200
    74.500     0.448     0.200
    74.514     0.612     0.200
    74.514     0.471     0.200
    74.534     1.297     0.200
    74.586     0.499     0.200
    74.586     0.635     0.200
    74.594     0.349     0.200
    74.638     0.797     0.200
    74.767     0.851     0.200
    74.803     0.837     0.200
    74.803     0.235     0.200
    74.868     0.953     0.200
    74.915     1.495     0.200
    74.976    -0.061     0.200
    74.978    -0.469     0.200
    74.901     1.734     0.200
    74.988     0.275     0.200
    75.090     0.683     0.200
    75.107     0.685     0.200
    75.105    -0.903     0.200
    75.168    -0.067     0.200
    75.172     0.891     0.200
    75.236     1.322     0.200
    75.236     1.342     0.200
    75.236     1.017     0.200
    75.237     1.297     0.200
    75.252     0.453     0.200
    75.282     1.070     0.200
    75.290    -0.369     0.200
    75.355     0.921     0.200
    75.401    -0.205     0.200
    75.405     1.014     0.200
    75.405    -0.029     0.200
    75.405     0.374     0.200
    75.479     1.198     0.200
    75.561     0.948     0.200
    75.559     0.192     0.200
    75.618     0.884     0.200
    75.642     0.917     0.200
    75.683     0.675     0.200
    75.790     0.873     0.200
    75.791     0.066     0.200
    75.822     0.689     0.200
    75.834     0.120     0.200
    75.843     0.749     0.200
    75.853     0.993     0.200
    75.853     0.013     0.200
    75.853     0.524     0.200
    75.845     0.458     0.200
    75.876     0.484     0.200
    75.876     0.777     0.200
    75.922     1.014     0.200
    75.922     0.217     0.200
    76.010     1.420     0.200
    76.057     0.598     0.200
    76.061     1.177     0.200
    76.067     0.922     0.200
    76.094     0.440     0.200
    76.094    -0.259     0.200
    76.149     1.927     0.200
    76.212    -0.135     0.200
    76.213     0.519     0.200
    76.213     0.437     0.200
    76.264     0.976     0.200
    76.264     1.156     0.200
    76.326     1.523     0.200
    76.326     1.812     0.200
    76.384    -0.109     0.200
    76.384     0.379     0.200
    76.397     0.524     0.200
    76.520    -0.576     0.200
    76.530    -0.330     0.200
    76.764    -0.457     0.200
    76.804     1.623     0.200
    76.804     1.244     0.200
    76.856    -0.569     0.200
    76.959     0.247     0.200
    76.962     0.771     0.200
    76.997    -0.266     0.200
    77.039     0.805     0.200
    77.063     0.651     0.200
    77.089     1.301     0.200
    77.139     0.040     0.200
    77.212     0.950     0.200
    77.218     0.762     0.200
    77.232     0.395     0.200
    77.275     0.847     0.200
    77.291     1.448     0.200
    77.291     0.976     0.200
    77.362     1.053     0.200
    77.404     0.620     0.200
    77.409    -0.475     0.200
    77.453     1.135     0.200
    77.477     1.448     0.200
    77.514     0.578     0.200
    77.542     0.861     0.200
    77.542     0.697     0.200
    77.568     0.868     0.200
    77.578    -0.318     0.200
    77.581     0.876     0.200
    77.606     0.906     0.200
    77.610    -0.394     0.200
    77.682     1.006     0.200
    77.698     1.082     0.200
    77.673     0.455     0.200
    77.673     0.564     0.200
    77.842     1.135     0.200
    77.865     1.172     0.200
    77.878     1.028     0.200
    77.885     0.176     0.200
    77.960     1.356     0.200
    77.978     0.537     0.200
    77.980     1.225     0.200
    78.156     0.765     0.200
    78.232     1.560     0.200
    78.247     1.196     0.200
    78.311     1.403     0.200
    78.319     0.068     0.200
    78.400     0.422     0.200
    78.422     0.566     0.200
    78.433     0.912     0.200
    78.478     0.631     0.200
    78.498     0.575     0.200
    78.508     0.329     0.200
    78.560     0.028     0.200
    78.560     0.142     0.200
    78.560    -0.147     0.200
    78.583     0.763     0.200
    78.640    -0.403     0.200
    78.748     1.316     0.200
    78.828    -0.142     0.200
    78.878     0.004     0.200
    78.893     0.013     0.200
    78.975     0.365     0.200
    78.975     0.826     0.200
    78.986     0.476     0.200
    78.986     0.105     0.200
    78.986     0.331     0.200
    79.032     0.850     0.200
    79.037     1.220     0.200
    79.037     0.720     0.200
    79.043     1.714     0.200
    79.070     0.110     0.200
    79.085    -0.141     0.200
    79.079     1.584     0.200
    79.154     1.137     0.200
    79.201     0.988     0.200
    79.201     0.430     0.200
    79.201     0.547     0.200
    79.219     0.909     0.200
    79.235     0.537     0.200
    79.244     1.673     0.200
    79.210    -0.622     0.200
    79.364    -1.062     0.200
    79.451     1.566     0.200
    79.451     0.664     0.200
    79.451     0.145     0.200
    79.451     0.926     0.200
    79.451     1.395     0.200
    79.470     0.060     0.200
    79.539     0.185     0.200
    79.570     0.298     0.200
    79.558     0.484     0.200
    79.582    -0.450     0.200
    79.589     0.218     0.200
    79.589     1.112     0.200
    79.589     0.476     0.200
    79.609     1.875     0.200
    79.609     0.305     0.200
    79.609     1.684     0.200
    79.638     0.875     0.200
    79.638     0.750     0.200
    79.667     1.390     0.200
    79.695     0.487     0.200
    79.695     0.636     0.200
    79.695     0.335     0.200
    79.722     0.279     0.200
    79.681     1.713     0.200
    79.750     1.342     0.200
    79.778     1.573     0.200
    79.778     1.397     0.200
    79.797     0.702     0.200
    79.818     1.773     0.200
    79.816    -0.702     0.200
    79.955     0.230     0.200
    80.121    -0.018     0.200
    80.214     1.595     0.200
    80.261     0.185     0.200
    80.315     0.283     0.200
    80.336     0.481     0.200
    80.384     1.524     0.200
    80.423     0.480     0.200
    80.463     1.323     0.200
    80.497     1.445     0.200
    80.460     0.910     0.200
    80.509     1.337     0.200
    80.518     0.561     0.200
    80.518     0.803     0.200
    80.627     1.018     0.200
    80.627     1.229     0.200
    80.679     0.770     0.200
    80.645     1.102     0.200
    80.701     0.823     0.200
    80.764     1.168     0.200
    80.881     1.064     0.200
    80.937     0.701     0.200
    80.940     0.647     0.200
    81.089    -0.246     0.200
    81.089     0.012     0.200
    81.266     0.656     0.200
    81.307     0.799     0.200
    81.405    -0.521     0.200
    81.405    -0.302     0.200
    81.381     0.752     0.200
    81.492     1.479     0.200
    81.834     1.455     0.200
    81.798     0.305     0.200
    81.869     1.342     0.200
    81.869     1.623     0.200
    82.000     1.322     0.200
    82.021     0.930     0.200
    82.182     0.091     0.200
    82.420     0.965     0.200
    82.675     1.017     0.200
    82.776     0.566     0.200
    82.776     0.406     0.200
    82.799     1.373     0.200
    82.799     0.725     0.200
    82.799     1.033     0.200
    82.834     0.914     0.200
    83.003     0.420     0.200
    83.042     0.847     0.200
    83.269     1.119     0.200
    83.269     0.853     0.200
    83.068     1.854     0.200
    83.323     0.470     0.200
    83.332     0.932     0.200
    83.332     0.811     0.200
    83.385     1.649     0.200
    83.500     0.970     0.200
    83.525     0.531     0.200
    83.564     0.878     0.200
    83.696     1.645     0.200
    83.938     1.269     0.200
    83.955     1.150     0.200
    83.961     1.026     0.200
    84.114     1.101     0.200
    84.183     0.979     0.200
    84.183     0.397     0.200
    84.155     0.480     0.200
    84.266    -0.241     0.200
    84.354     1.222     0.200
    84.422     1.076     0.200
    84.508     0.911     0.200
    84.600     0.921     0.200
    84.711     1.329     0.200
    84.711     1.540     0.200
    84.727     0.993     0.200
    84.796     0.273     0.200
    84.802     0.839     0.200
    84.803     0.791     0.200
    84.803     0.939     0.200
    84.819     1.477     0.200
    84.812     0.393     0.200
    84.831     0.995     0.200
    84.862     1.994     0.200
    85.244     0.492     0.200
    85.264     1.020     0.200
    85.327     0.781     0.200
    85.360     1.298     0.200
    85.423     1.625     0.200
    85.494     0.177     0.200
    85.504     1.594     0.200
    85.978     0.874     0.200
    85.978     0.585     0.200
    86.004     0.743     0.200
    86.614     1.747     0.200
    86.867    -1.282     0.200
    86.867    -0.821     0.200
    87.320     0.794     0.200
    88.014     0.436     0.200
    88.033    -0.120     0.200
    88.976     0.745     0.200
    89.708     0.454     0.200
    91.227     0.171     0.200
    91.227     0.632     0.200
    91.330    -1.212     0.200
    92.588     0.319     0.200
    92.588     0.557     0.200
    93.275    -0.181     0.200
    93.343    -0.355     0.200
    93.343     0.293     0.200
    94.328     0.568     0.200
    94.328    -0.432     0.200
    96.705     0.430     0.200
    98.732     0.509     0.200
    18.629    -1.812     0.200
    18.629    -0.804     0.200
    18.629    -2.562     0.200
    22.145    -2.101     0.200
    22.145    -1.921     0.200
    22.978    -2.775     0.200
    23.740     1.232     0.200
    23.740     0.037     0.200
    23.740     1.646     0.200
    24.250     1.035     0.200
    24.638     0.057     0.200
    24.821    -0.223     0.200
    24.821    -0.403     0.200
    26.245    -0.920     0.200
    26.245    -0.233     0.200
    27.556     0.881     0.200
    27.592     0.849     0.200
    31.768     2.707     0.200
    31.959     0.612     0.200
    32.844     3.435     0.200
    33.478    -1.965     0.200
    34.814     3.093     0.200
    35.534    -1.952     0.200
    35.534    -1.116     0.200
    36.817    -0.956     0.200
    38.122    -1.186     0.200
    38.546     1.072     0.200
    39.316     2.472     0.200
    39.629     1.094     0.200
    40.689     2.442     0.200
    41.286    -1.066     0.200
    41.499     2.528     0.200
    42.222     0.692     0.200
    42.222     1.169     0.200
    42.202    -0.689     0.200
    42.606    -0.627     0.200
    42.606    -0.955     0.200
    42.834    -1.328     0.200
    43.328    -0.518     0.200
    43.328    -0.284     0.200
    44.034    -0.199     0.200
    44.301    -0.926     0.200
    44.807     1.643     0.200
    44.807     1.299     0.200
    44.807     0.944     0.200
    44.807     1.834     0.200
    44.908     0.624     0.200
    45.044     2.127     0.200
    45.956     1.875     0.200
    46.330     1.439     0.200
    46.581     0.217     0.200
    46.581    -0.079     0.200
    46.581     0.632     0.200
    46.641    -0.831     0.200
    46.641    -1.651     0.200
    46.599     0.055     0.200
    46.679     1.506     0.200
    46.758    -0.566     0.200
    46.952    -0.087     0.200
    46.952     0.351     0.200
    47.217     0.646     0.200
    47.393    -1.206     0.200
    47.393    -0.878     0.200
    47.787     2.504     0.200
    47.787     2.222     0.200
    47.950     0.070     0.200
    49.301     1.479     0.200
    50.135     1.640     0.200
    51.704    -0.748     0.200
    51.704     0.041     0.200
    51.874    -0.224     0.200
    52.012     0.808     0.200
    52.012     0.995     0.200
    52.203     1.722     0.200
    52.507    -1.369     0.200
    52.980     0.274     0.200
    54.036     0.148     0.200
    54.036     0.836     0.200
    54.374     0.966     0.200
    54.374     0.466     0.200
    55.706     0.254     0.200
    55.998    -0.357     0.200
    56.010    -1.619     0.200
    56.010    -1.455     0.200
    56.010    -0.978     0.200
    56.072    -0.457     0.200
    56.586    -1.355     0.200
    57.674    -0.893     0.200
    57.533     1.665     0.200
    57.685     0.801     0.200
    58.075    -0.547     0.200
    58.225    -0.933     0.200
    58.832    -0.759     0.200
    59.059    -0.671     0.200
    59.005    -0.511     0.200
    59.005    -0.034     0.200
    59.005    -0.917     0.200
    59.147    -0.846     0.200
    59.422    -1.952     0.200
    59.447    -0.448     0.200
    59.504    -0.219     0.200
    60.456    -0.751     0.200
    60.994    -0.530     0.200
    60.856     1.678     0.200
    62.736    -0.312     0.200
    63.091     0.156     0.200
    63.171     0.947     0.200
    63.349    -0.535     0.200
    63.548    -0.254     0.200
    63.771     0.677     0.200
    63.856    -0.350     0.200
    63.856     0.064     0.200
    63.965    -0.067     0.200
    64.095    -0.972     0.200
    64.095    -1.535     0.200
    64.182     0.253     0.200
    64.386    -0.248     0.200
    64.216     0.552     0.200
    64.216    -0.182     0.200
    64.455    -0.503     0.200
    64.455    -0.456     0.200
    64.306     1.268     0.200
    64.323     1.229     0.200
    64.483     1.383     0.200
    64.636    -0.316     0.200
    64.647    -0.101     0.200
    64.599     0.180     0.200
    64.602    -0.237     0.200
    64.663    -0.080     0.200
    64.773    -0.470     0.200
    64.771    -0.939     0.200
    65.319     0.055     0.200
    65.454    -0.737     0.200
    65.534     0.163     0.200
    65.765     0.175     0.200
    65.765    -0.153     0.200
    65.793    -0.035     0.200
    65.734    -0.182     0.200
    65.734    -0.838     0.200
    65.737     0.833     0.200
    65.845    -0.619     0.200
    65.845    -0.260     0.200
    65.944     1.042     0.200
    66.458    -0.620     0.200
    66.625     0.159     0.200
    66.923     0.300     0.200
    67.076     0.390     0.200
    67.377     0.203     0.200
    67.377    -0.469     0.200
    67.479    -0.395     0.200
    67.643    -0.194     0.200
    67.834     0.217     0.200
    68.127    -0.763     0.200
    68.355     1.751     0.200
    68.555    -0.792     0.200
    68.725     0.359     0.200
    68.828     0.148     0.200
    68.838    -0.467     0.200
    68.838     0.158     0.200
    68.774     0.437     0.200
    69.127    -0.459     0.200
    69.494    -0.423     0.200
    69.952    -0.411     0.200
    69.874    -0.396     0.200
    70.110    -0.122     0.200
    70.055     0.486     0.200
    70.300     0.313     0.200
    70.335    -0.146     0.200
    70.369     0.616     0.200
    70.604    -0.541     0.200
    70.803     0.465     0.200
    70.954    -0.333     0.200
    70.929    -0.472     0.200
    70.949     0.609     0.200
    71.202     0.406     0.200
    71.505     0.648     0.200
    71.460     0.527     0.200
    71.559     1.204     0.200
    71.626     1.023     0.200
    71.635     1.109     0.200
    71.668     1.089     0.200
    71.734     0.769     0.200
    71.800     1.357     0.200
    71.807     1.371     0.200
    71.895     1.222     0.200
    72.029     1.350     0.200
    72.214     1.152     0.200
    72.214     1.261     0.200
    72.214     0.894     0.200
    72.457     1.076     0.200
    72.961     0.554     0.200
    72.910     1.314     0.200
    73.135     0.416     0.200
    73.235    -0.209     0.200
    73.596     0.759     0.200
    73.785     0.497     0.200
    73.868     0.581     0.200
    73.868     1.093     0.200
    73.977     0.659     0.200
    74.133    -0.677     0.200
    74.165    -0.243     0.200
    74.210    -0.425     0.200
    74.259    -0.912     0.200
    74.259    -0.107     0.200
    74.303     0.425     0.200
    74.242     0.500     0.200
    74.245     0.572     0.200
    74.506     0.067     0.200
    74.524    -1.649     0.200
    74.468     0.966     0.200
    74.594    -0.658     0.200
    74.603    -0.706     0.200
    74.608    -0.635     0.200
    74.630    -0.659     0.200
    74.632    -0.776     0.200
    74.640    -0.522     0.200
    74.647    -0.860     0.200
    74.650    -0.880     0.200
    74.657    -0.694     0.200
    74.657    -1.030     0.200
    74.665    -0.653     0.200
    74.665    -1.067     0.200
    74.665    -0.965     0.200
    74.696     0.028     0.200
    74.702    -1.079     0.200
    74.729    -0.327     0.200
    74.729    -0.069     0.200
    74.719    -1.083     0.200
    74.722    -1.102     0.200
    74.718    -0.674     0.200
    74.735    -1.075     0.200
    74.858     0.427     0.200
    74.883     0.122     0.200
    74.884    -0.079     0.200
    74.826     1.605     0.200
    75.073     0.279     0.200
    75.084     0.657     0.200
    75.108     0.172     0.200
    75.153     0.319     0.200
    75.308     0.423     0.200
    75.316     0.378     0.200
    75.316     0.737     0.200
    75.455     0.518     0.200
    75.473     0.242     0.200
    75.526    -0.928     0.200
    75.600     0.551     0.200
    75.633     0.358     0.200
    75.723     0.690     0.200
    75.754     0.374     0.200
    75.832     0.816     0.200
    75.854     0.506     0.200
    75.810     0.730     0.200
    75.909     0.558     0.200
    75.909    -0.012     0.200
    75.909     0.433     0.200
    75.829     1.427     0.200
    76.028     0.751     0.200
    75.961     1.408     0.200
    76.110     1.063     0.200
    76.166     0.760     0.200
    76.171     0.393     0.200
    76.231     0.591     0.200
    76.264     0.662     0.200
    76.273     0.011     0.200
    76.323     0.529     0.200
    76.364     0.900     0.200
    76.364     0.095     0.200
    76.364     0.439     0.200
    76.415     0.610     0.200
    76.457     0.773     0.200
    76.457    -0.032     0.200
    76.545     0.971     0.200
    76.607     0.565     0.200
    76.607    -0.178     0.200
    76.678     1.023     0.200
    76.730     1.059     0.200
    76.730     0.731     0.200
    76.747     0.328     0.200
    76.794     0.368     0.200
    76.829     1.274     0.200
    76.829     1.758     0.200
    76.958    -0.228     0.200
    76.979     0.474     0.200
    76.926     0.846     0.200
    77.270    -1.112     0.200
    77.310     0.985     0.200
    77.310     0.868     0.200
    77.384    -0.943     0.200
    77.527     0.678     0.200
    77.555     0.926     0.200
    77.646     0.608     0.200
    77.730     0.993     0.200
    77.581     1.100     0.200
    77.776     1.061     0.200
    77.816     0.814     0.200
    77.955     0.288     0.200
    77.955    -0.204     0.200
    77.968     1.201     0.200
    78.122     0.726     0.200
    78.123     0.758     0.200
    78.157     0.781     0.200
    78.232     0.960     0.200
    78.232     1.093     0.200
    78.252     1.007     0.200
    78.113     2.146     0.200
    78.399     1.047     0.200
    78.399     0.820     0.200
    78.417     1.284     0.200
    78.423     1.132     0.200
    78.498     1.204     0.200
    78.498     1.329     0.200
    78.508     1.147     0.200
    78.517     1.114     0.200
    78.391     0.826     0.200
    78.569     1.302     0.200
    78.589     0.680     0.200
    78.794     1.294     0.200
    78.793     0.354     0.200
    78.958     1.340     0.200
    78.958     1.239     0.200
    78.966     0.184     0.200
    79.111     0.960     0.200
    79.111     0.859     0.200
    79.177     0.968     0.200
    79.395     0.812     0.200
    79.395     0.913     0.200
    79.481     0.177     0.200
    79.481    -0.550     0.200
    79.475     1.248     0.200
    79.569     0.497     0.200
    79.592     1.083     0.200
    79.621     0.330     0.200
    79.627     0.566     0.200
    79.646     0.711     0.200
    79.675     1.234     0.200
    79.721     1.391     0.200
    79.723     0.951     0.200
    79.723     0.021     0.200
    79.768     1.305     0.200
    79.888     0.831     0.200
    79.907     0.946     0.200
    79.927     0.407     0.200
    79.957     0.267     0.200
    80.041     0.991     0.200
    80.059     0.309     0.200
    80.136     0.919     0.200
    80.136     0.646     0.200
    80.052     1.084     0.200
    80.173    -0.056     0.200
    80.175    -0.183     0.200
    80.222     1.172     0.200
    80.222     0.828     0.200
    80.229     0.364     0.200
    80.257     0.734     0.200
    80.346     0.937     0.200
    80.287     0.924     0.200
    80.530     0.572     0.200
    80.498     0.536     0.200
    80.522     1.045     0.200
    80.522     1.396     0.200
    80.778     1.065     0.200
    80.613     0.794     0.200
    80.613     1.013     0.200
    80.866     0.756     0.200
    80.893     0.424     0.200
    80.927     0.192     0.200
    80.902     1.373     0.200
    80.902     0.935     0.200
    81.123     0.511     0.200
    81.195     0.776     0.200
    81.352    -0.706     0.200
    81.352    -0.245     0.200
    81.355     1.062     0.200
    81.575     1.930     0.200
    81.685     1.504     0.200
    82.097     1.343     0.200
    82.188     1.548     0.200
    82.200     0.243     0.200
    82.701     0.753     0.200
    83.038     1.999     0.200
    83.038     0.432     0.200
    83.038     0.947     0.200
    83.116     0.958     0.200
    83.206     1.318     0.200
    83.266     0.415     0.200
    83.530     1.285     0.200
    83.704     0.821     0.200
    83.943     0.937     0.200
    83.943     0.726     0.200
    83.775     2.125     0.200
    84.005     0.862     0.200
    83.991     1.755     0.200
    84.394     1.057     0.200
    84.481     2.332     0.200
    84.504     1.122     0.200
    84.699     1.231     0.200
    84.810     1.717     0.200
    84.807     1.158     0.200
    85.155     0.943     0.200
    85.155     0.630     0.200
    85.353     0.796     0.200
    85.414     1.830     0.200
    85.551     0.403     0.200
    85.708     1.194     0.200
    85.745     1.395     0.200
    85.781     1.464     0.200
    86.491     1.001     0.200
    86.491     0.876     0.200
    86.634    -0.114     0.200
    87.811    -0.133     0.200
    92.167     0.575     0.200
    92.511     0.954     0.200
    92.511     0.829     0.200
    95.447     0.424     0.200
    95.871     1.411     0.200
    95.871     0.833     0.200
    98.903     0.555     0.200
    18.612    -1.727     0.200
    18.612    -2.630     0.200
    19.295    -1.770     0.200
    20.290     1.175     0.200
    20.290     0.095     0.200
    22.128    -1.648     0.200
    22.128    -2.837     0.200
    22.962    -2.778     0.200
    23.756     0.559     0.200
    23.756     1.618     0.200
    23.756     1.468     0.200
    24.102     2.457     0.200
    24.266     0.502     0.200
    24.266     0.912     0.200
    24.266     0.601     0.200
    24.795    -0.407     0.200
    24.801     0.356     0.200
    24.801     0.101     0.200
    24.858     0.215     0.200
    25.086    -0.912     0.200
    26.122    -0.152     0.200
    26.257    -0.499     0.200
    26.257     0.931     0.200
    26.257     0.632     0.200
    26.257     0.491     0.200
    27.152     2.638     0.200
    27.572     1.602     0.200
    27.572     2.422     0.200
    31.750     1.508     0.200
    32.011    -1.001     0.200
    32.827     2.568     0.200
    33.107     1.009     0.200
    33.107    -0.011     0.200
    33.481    -1.163     0.200
    33.481    -1.457     0.200
    33.640     1.364     0.200
    34.611     1.183     0.200
    34.796     3.448     0.200
    34.796     2.057     0.200
    34.868     1.922     0.200
    35.053     1.557     0.200
    35.543    -1.237     0.200
    35.625     0.216     0.200
    37.110     0.342     0.200
    37.257    -0.708     0.200
    37.320     2.760     0.200
    37.358     0.560     0.200
    37.359     0.778     0.200
    37.424     1.279     0.200
    37.424     1.618     0.200
    37.424     1.468     0.200
    38.107    -1.695     0.200
    38.329     0.842     0.200
    38.329     0.952     0.200
    38.329     0.222     0.200
    38.525     1.016     0.200
    39.232     1.546     0.200
    39.298     1.937     0.200
    39.609     1.054     0.200
    40.388    -0.231     0.200
    41.272    -0.906     0.200
    41.578    -0.492     0.200
    41.482     2.560     0.200
    41.482     1.600     0.200
    41.482     3.530     0.200
    41.717     0.756     0.200
    41.903     0.407     0.200
    41.903     0.637     0.200
    42.060     2.738     0.200
    42.060     1.968     0.200
    42.060     1.058     0.200
    42.202     0.744     0.200
    42.202     1.053     0.200
    42.216    -0.930     0.200
    42.596    -0.323     0.200
    42.596    -0.533     0.200
    42.486     2.858     0.200
    42.819    -0.422     0.200
    43.122     0.846     0.200
    43.344    -1.301     0.200
    44.016     0.222     0.200
    44.286    -0.492     0.200
    44.466    -1.586     0.200
    44.421    -0.221     0.200
    44.421    -0.060     0.200
    44.628    -0.061     0.200
    44.825     1.416     0.200
    44.825     1.302     0.200
    44.826     1.449     0.200
    44.826     1.319     0.200
    44.826     1.609     0.200
    44.923     0.073     0.200
    44.994     1.108     0.200
    45.140    -0.504     0.200
    45.026     2.279     0.200
    45.569    -0.193     0.200
    45.625     0.040     0.200
    45.975     1.650     0.200
    46.313    -0.830     0.200
    46.349     0.476     0.200
    46.349     0.966     0.200
    46.572     0.058     0.200
    46.572     0.189     0.200
    46.572     0.319     0.200
    46.572    -0.161     0.200
    46.629    -0.789     0.200
    46.611     0.051     0.200
    46.660     1.673     0.200
    46.660     1.573     0.200
    46.759    -1.131     0.200
    46.759    -0.805     0.200
    46.938     0.195     0.200
    46.938     0.435     0.200
    47.232     0.100     0.200
    47.384    -1.152     0.200
    47.384    -1.182     0.200
    47.384    -0.882     0.200
    47.768     2.657     0.200
    47.769     2.257     0.200
    47.769     2.632     0.200
    47.933     0.262     0.200
    47.933     0.371     0.200
    48.447     3.164     0.200
    48.595    -0.747     0.200
    48.595    -0.917     0.200
    48.697    -0.427     0.200
    48.697    -0.286     0.200
    49.320     2.705     0.200
    49.538     0.941     0.200
    49.538     0.271     0.200
    49.421     2.029     0.200
    49.813     1.046     0.200
    50.138    -0.095     0.200
    50.120     1.247     0.200
    50.152     1.529     0.200
    50.152     1.178     0.200
    50.836     1.313     0.200
    51.195     1.916     0.200
    51.691    -0.196     0.200
    51.691    -0.346     0.200
    51.859    -0.352     0.200
    51.843     2.672     0.200
    51.992     0.859     0.200
    52.216     1.493     0.200
    52.491    -0.844     0.200
    52.491    -1.193     0.200
    52.658    -0.080     0.200
    52.821     0.564     0.200
    52.990     0.573     0.200
    52.990     0.883     0.200
    54.047     0.518     0.200
    54.047     0.319     0.200
    54.047     0.779     0.200
    54.059    -0.168     0.200
    54.124    -0.272     0.200
    54.182     0.738     0.200
    54.267     0.439     0.200
    54.385     0.916     0.200
    54.861     0.808     0.200
    55.284    -1.054     0.200
    55.737    -1.205     0.200
    55.737    -1.044     0.200
    55.990    -0.630     0.200
    56.003    -1.257     0.200
    56.003    -1.432     0.200
    56.003    -1.227     0.200
    56.064    -1.022     0.200
    56.435    -1.189     0.200
    56.435    -0.968     0.200
    56.469     1.372     0.200
    56.578    -1.148     0.200
    56.738     0.056     0.200
    57.195    -1.375     0.200
    57.195    -1.655     0.200
    57.195    -0.465     0.200
    57.083     1.016     0.200
    57.426     0.263     0.200
    57.604    -2.757     0.200
    57.665    -0.947     0.200
    57.548     1.433     0.200
    57.698     1.177     0.200
    58.068    -0.428     0.200
    58.216    -0.838     0.200
    58.823    -0.868     0.200
    59.050    -0.544     0.200
    59.010     0.113     0.200
    59.010     0.173     0.200
    59.138    -0.830     0.200
    59.214    -0.577     0.200
    59.171     0.906     0.200
    59.413    -1.674     0.200
    59.438    -0.418     0.200
    59.497    -0.403     0.200
    60.449    -0.733     0.200
    60.985    -0.929     0.200
    60.872     1.348     0.200
    61.365     0.304     0.200
    62.315     1.486     0.200
    62.525     0.617     0.200
    62.726    -0.257     0.200
    62.841     0.907     0.200
    63.081     0.084     0.200
    63.186     0.720     0.200
    63.186     1.020     0.200
    63.339    -0.686     0.200
    63.311     0.711     0.200
    63.520    -0.430     0.200
    63.684    -1.972     0.200
    63.566     0.436     0.200
    63.566     0.966     0.200
    63.783    -0.028     0.200
    63.852    -0.077     0.200
    63.861    -0.541     0.200
    63.861     0.069     0.200
    63.861    -0.200     0.200
    63.861     0.489     0.200
    63.970    -0.092     0.200
    64.032    -0.254     0.200
    64.034    -0.665     0.200
    64.087    -0.733     0.200
    64.088    -0.955     0.200
    64.088    -0.729     0.200
    64.189     0.307     0.200
    64.374     0.043     0.200
    64.234     1.070     0.200
    64.319     1.253     0.200
    64.445    -0.671     0.200
    64.445    -0.421     0.200
    64.341     0.221     0.200
    64.341     1.021     0.200
    64.491    -0.866     0.200
    64.496     1.346     0.200
    64.626    -0.081     0.200
    64.636    -0.049     0.200
    64.602     0.055     0.200
    64.605    -0.214     0.200
    64.605     0.307     0.200
    64.653    -0.166     0.200
    64.745    -0.109     0.200
    64.764    -0.659     0.200
    64.764    -0.648     0.200
    64.771    -0.594     0.200
    64.771    -0.384     0.200
    65.309     0.211     0.200
    65.444    -0.660     0.200
    65.525    -0.055     0.200
    65.552    -0.064     0.200
    65.755    -0.071     0.200
    65.755     0.099     0.200
    65.755     0.479     0.200
    65.755     0.238     0.200
    65.782     0.112     0.200
    65.741    -0.581     0.200
    65.741    -0.356     0.200
    65.741    -0.181     0.200
    65.804    -0.014     0.200
    65.752     1.006     0.200
    65.851    -0.391     0.200
    65.851    -0.501     0.200
    65.952     1.162     0.200
    66.100    -0.337     0.200
    66.448    -0.378     0.200
    66.520    -0.180     0.200
    66.613     0.026     0.200
    66.913     0.326     0.200
    67.043    -1.513     0.200
    67.043    -1.223     0.200
    67.066     0.353     0.200
    67.066     0.162     0.200
    67.365     0.249     0.200
    67.365    -0.171     0.200
    67.470    -0.432     0.200
    67.601    -0.109     0.200
    67.631    -0.068     0.200
    67.822    -0.083     0.200
    68.118    -0.492     0.200
    68.167    -0.061     0.200
    68.237    -0.143     0.200
    68.421     0.307     0.200
    68.421    -0.693     0.200
    68.421    -0.353     0.200
    68.369     1.035     0.200
    68.546    -0.560     0.200
    68.731     0.373     0.200
    68.816     0.172     0.200
    68.826    -0.314     0.200
    68.826     0.016     0.200
    68.786     0.634     0.200
    68.877    -0.053     0.200
    68.916     0.476     0.200
    68.910    -1.037     0.200
    69.051    -0.034     0.200
    69.118    -0.380     0.200
    69.464     0.241     0.200
    69.485    -0.508     0.200
    69.616     0.192     0.200
    69.616    -0.048     0.200
    69.639    -0.950     0.200
    69.639    -1.750     0.200
    69.639    -0.740     0.200
    69.692     0.125     0.200
    69.692     0.314     0.200
    69.692    -0.226     0.200
    69.728     0.702     0.200
    69.850    -0.209     0.200
    69.881    -0.437     0.200
    69.942    -0.815     0.200
    69.923     0.601     0.200
    70.102    -0.237     0.200
    70.102    -0.056     0.200
    70.062     0.453     0.200
    70.193    -0.062     0.200
    70.305     0.461     0.200
    70.365     0.193     0.200
    70.272     1.567     0.200
    70.376     0.430     0.200
    70.506    -0.566     0.200
    70.453     0.457     0.200
    70.709    -0.700     0.200
    70.809     0.389     0.200
    70.755     0.918     0.200
    70.892     0.897     0.200
    70.892     0.137     0.200
    70.867     1.060     0.200
    70.947     0.210     0.200
    70.948     0.446     0.200
    70.835     1.853     0.200
    70.930    -0.046     0.200
    70.930     0.384     0.200
    70.930     0.354     0.200
    70.956     0.501     0.200
    71.022     1.095     0.200
    71.131     1.129     0.200
    71.131     0.669     0.200
    71.141     0.474     0.200
    71.190     0.694     0.200
    71.190     0.393     0.200
    71.495     0.410     0.200
    71.495     0.580     0.200
    71.466     0.536     0.200
    71.595     0.385     0.200
    71.595     0.165     0.200
    71.597    -0.053     0.200
    71.565     0.987     0.200
    71.618    -0.492     0.200
    71.633     0.960     0.200
    71.641     1.100     0.200
    71.673     0.995     0.200
    71.741     1.801     0.200
    71.835    -1.206     0.200
    71.849     0.537     0.200
    71.806     1.127     0.200
    71.872     0.190     0.200
    71.902     1.075     0.200
    72.088     0.009     0.200
    72.035     1.295     0.200
    72.220     0.951     0.200
    72.220     1.131     0.200
    72.220     1.311     0.200
    72.399     0.120     0.200
    72.491     0.635     0.200
    72.463     0.961     0.200
    72.631     0.518     0.200
    72.631     0.637     0.200
    72.710    -1.031     0.200
    72.822    -1.394     0.200
    72.950     0.588     0.200
    72.934     1.631     0.200
    72.925     1.996     0.200
    73.107     0.484     0.200
    73.107     0.608     0.200
    73.146    -0.205     0.200
    73.162    -0.805     0.200
    73.139     0.327     0.200
    73.215     0.273     0.200
    73.240     0.234     0.200
    73.315     0.212     0.200
    73.390    -2.853     0.200
    73.471     0.021     0.200
    73.509     0.337     0.200
    73.457     1.154     0.200
    73.538     1.680     0.200
    73.586     0.733     0.200
    73.774     0.264     0.200
    73.858     0.757     0.200
    73.858     0.864     0.200
    73.874     0.809     0.200
    73.968     0.391     0.200
    74.097     0.529     0.200
    74.126    -0.664     0.200
    74.203    -0.815     0.200
    74.249    -0.083     0.200
    74.249    -0.583     0.200
    74.246     0.534     0.200
    74.293     0.402     0.200
    74.250     0.612     0.200
    74.495     0.221     0.200
    74.495     0.431     0.200
    74.518    -1.444     0.200
    74.448     1.432     0.200
    74.584     0.194     0.200
    74.584    -0.017     0.200
    74.588    -0.953     0.200
    74.597    -1.001     0.200
    74.602    -0.931     0.200
    74.623    -0.957     0.200
    74.626    -0.973     0.200
    74.634    -1.216     0.200
    74.641    -0.656     0.200
    74.644    -0.577     0.200
    74.651    -0.716     0.200
    74.651    -0.917     0.200
    74.659    -0.551     0.200
    74.659    -0.752     0.200
    74.684     0.170     0.200
    74.696    -0.977     0.200
    74.713    -1.075     0.200
    74.719     0.089     0.200
    74.714    -0.281     0.200
    74.689    -0.416     0.200
    74.814     0.871     0.200
    74.848     0.397     0.200
    74.870    -0.184     0.200
    74.872     0.165     0.200
    74.873     0.288     0.200
    74.888    -0.387     0.200
    74.832     1.436     0.200
    74.947     0.249     0.200
    75.034     0.209     0.200
    75.064     0.197     0.200
    75.074     0.232     0.200
    75.074     0.430     0.200
    75.099     0.296     0.200
    75.118     0.364     0.200
    75.118     0.627     0.200
    75.144     0.237     0.200
    75.307     0.697     0.200
    75.307     0.806     0.200
    75.444     0.651     0.200
    75.444     0.860     0.200
    75.465     0.359     0.200
    75.520    -0.923     0.200
    75.446     2.498     0.200
    75.591     0.471     0.200
    75.598    -0.571     0.200
    75.624     0.481     0.200
    75.713     0.652     0.200
    75.745     0.490     0.200
    75.778     0.821     0.200
    75.778     0.728     0.200
    75.779     1.096     0.200
    75.779     0.806     0.200
    75.779     0.636     0.200
    75.802    -0.239     0.200
    75.822     0.839     0.200
    75.845     0.518     0.200
    75.815     0.628     0.200
    75.900     0.464     0.200
    75.900     0.204     0.200
    75.914     0.026     0.200
    75.841     2.551     0.200
    75.834     1.280     0.200
    76.014     0.645     0.200
    76.019     0.680     0.200
    75.967     0.984     0.200
    76.040     0.709     0.200
    76.100     0.727     0.200
    76.156     0.779     0.200
    76.162     0.514     0.200
    76.221     0.667     0.200
    76.256    -0.322     0.200
    76.265     0.910     0.200
    76.315     0.645     0.200
    76.345     0.377     0.200
    76.355     0.615     0.200
    76.355     0.917     0.200
    76.355     0.417     0.200
    76.382     0.398     0.200
    76.398     0.546     0.200
    76.406     0.611     0.200
    76.447     0.695     0.200
    76.536     1.291     0.200
    76.570     0.555     0.200
    76.597     0.539     0.200
    76.598     0.042     0.200
    76.598     0.332     0.200
    76.608     0.416     0.200
    76.666     1.059     0.200
    76.722     1.142     0.200
    76.738     0.304     0.200
    76.738     0.404     0.200
    76.738     0.274     0.200
    76.785     0.189     0.200
    76.820     1.390     0.200
    76.820     1.730     0.200
    76.948     0.571     0.200
    76.948     0.174     0.200
    76.944    -1.508     0.200
    76.968     0.555     0.200
    76.931     0.756     0.200
    77.107    -0.325     0.200
    77.163     1.463     0.200
    77.199     0.859     0.200
    77.199     1.099     0.200
    77.264    -0.413     0.200
    77.291    -0.487     0.200
    77.301     0.987     0.200
    77.301     1.217     0.200
    77.303     0.614     0.200
    77.339    -0.424     0.200
    77.378     0.898     0.200
    77.522     0.171     0.200
    77.519     0.766     0.200
    77.546     0.895     0.200
    77.593    -0.442     0.200
    77.651     0.433     0.200
    77.721     0.736     0.200
    77.753     0.332     0.200
    77.762    -0.084     0.200
    77.768     0.813     0.200
    77.768     1.279     0.200
    77.768     1.119     0.200
    77.791     0.705     0.200
    77.807     0.664     0.200
    77.872     1.042     0.200
    77.888     0.157     0.200
    77.950     0.387     0.200
    77.948     0.224     0.200
    77.948     0.661     0.200
    77.951     0.492     0.200
    77.959     0.693     0.200
    77.980     0.800     0.200
    77.980     1.031     0.200
    78.009    -0.559     0.200
    78.095     0.512     0.200
    78.095     1.023     0.200
    78.112     0.481     0.200
    78.114     0.472     0.200
    78.147     0.639     0.200
    78.181    -0.414     0.200
    78.206    -0.552     0.200
    78.205     0.556     0.200
    78.222     0.928     0.200
    78.222     1.069     0.200
    78.242     0.787     0.200
    78.268     1.665     0.200
    78.131     2.162     0.200
    78.133     2.053     0.200
    78.359    -0.097     0.200
    78.390     0.930     0.200
    78.390     1.043     0.200
    78.382     1.326     0.200
    78.406     1.063     0.200
    78.413     0.834     0.200
    78.424     0.905     0.200
    78.466     0.112     0.200
    78.458     1.497     0.200
    78.488     1.187     0.200
    78.488     1.349     0.200
    78.490     1.145     0.200
    78.499     1.218     0.200
    78.508     1.248     0.200
    78.498     1.507     0.200
    78.404     1.095     0.200
    78.546    -0.148     0.200
    78.558     0.984     0.200
    78.582     0.687     0.200
    78.588     1.490     0.200
    78.591     1.322     0.200
    78.589     0.536     0.200
    78.604     1.351     0.200
    78.673     1.612     0.200
    78.782     0.276     0.200
    78.784     1.424     0.200
    78.773     1.674     0.200
    78.787     0.356     0.200
    78.854     0.303     0.200
    78.854     0.437     0.200
    78.870     1.281     0.200
    78.907     1.269     0.200
    78.926    -0.115     0.200
    78.948     0.195     0.200
    78.948     0.577     0.200
    78.959     0.471     0.200
    78.864     0.184     0.200
    78.981    -0.229     0.200
    78.981    -0.058     0.200
    78.993     0.495     0.200
    79.102     0.737     0.200
    79.170     0.750     0.200
    79.179     0.490     0.200
    79.209     0.432     0.200
    79.215     0.193     0.200
    79.255    -0.416     0.200
    79.353    -0.444     0.200
    79.370    -0.247     0.200
    79.388     1.116     0.200
    79.388     0.965     0.200
    79.400     0.728     0.200
    79.452     0.955     0.200
    79.469     1.069     0.200
    79.473     0.150     0.200
    79.473    -0.005     0.200
    79.473     0.326     0.200
    79.403     2.076     0.200
    79.513    -0.122     0.200
    79.563     0.484     0.200
    79.585     1.060     0.200
    79.610     0.847     0.200
    79.620     0.377     0.200
    79.631     1.038     0.200
    79.631     1.134     0.200
    79.640     0.364     0.200
    79.668     1.289     0.200
    79.696    -0.217     0.200
    79.705     0.554     0.200
    79.720     1.075     0.200
    79.720     0.751     0.200
    79.757     0.912     0.200
    79.762     1.318     0.200
    79.881     0.957     0.200
    79.882     0.493     0.200
    79.905     0.929     0.200
    79.921     0.316     0.200
    79.935    -0.311     0.200
    79.945     0.576     0.200
    79.936     1.080     0.200
    80.009     1.289     0.200
    80.035     1.022     0.200
    80.035     1.629     0.200
    80.052     0.669     0.200
    80.052     0.418     0.200
    80.064    -0.006     0.200
    80.081     0.437     0.200
    80.124     0.169     0.200
    80.129     0.800     0.200
    80.166     0.161     0.200
    80.166    -0.099     0.200
    80.169     0.410     0.200
    80.216     0.895     0.200
    80.223     0.239     0.200
    80.250     0.688     0.200
    80.296     1.163     0.200
    80.376     0.277     0.200
    80.397     0.999     0.200
    80.524     0.101     0.200
    80.530     0.284     0.200
    80.558    -0.863     0.200
    80.506     1.035     0.200
    80.583    -0.213     0.200
    80.529     1.289     0.200
    80.430     2.023     0.200
    80.430     3.132     0.200
    80.629     0.353     0.200
    80.628     0.560     0.200
    80.628     0.860     0.200
    80.771     0.460     0.200
    80.885     0.494     0.200
    80.895     1.162     0.200
    80.921     0.228     0.200
    80.921     0.393     0.200
    80.961     1.510     0.200
    80.969     0.800     0.200
    81.025     1.242     0.200
    80.917     1.364     0.200
    81.039    -0.401     0.200
    81.039    -0.276     0.200
    81.053     1.673     0.200
    81.129     1.365     0.200
    81.140     0.131     0.200
    81.151     0.769     0.200
    81.110     0.918     0.200
    81.190     1.444     0.200
    81.276    -0.092     0.200
    81.301     1.071     0.200
    81.313    -0.089     0.200
    81.333     0.403     0.200
    81.339     0.800     0.200
    81.352     1.026     0.200
    81.358    -0.227     0.200
    81.422    -0.080     0.200
    81.523     0.901     0.200
    81.560     1.571     0.200
    81.622     0.996     0.200
    81.671     1.340     0.200
    81.823     0.918     0.200
    81.965     0.970     0.200
    82.095     1.576     0.200
    82.174     1.336     0.200
    82.193     0.434     0.200
    82.244     0.808     0.200
    82.425     1.161     0.200
    82.485     0.149     0.200
    82.549     1.577     0.200
    82.549     1.907     0.200
    82.747     0.087     0.200
    82.785     0.088     0.200
    82.969    -1.362     0.200
    82.907     0.228     0.200
    82.907     1.168     0.200
    83.036     1.926     0.200
    83.036     0.788     0.200
    83.036     1.988     0.200
    83.036     1.097     0.200
    83.101     1.171     0.200
    83.089     1.646     0.200
    83.142     1.642     0.200
    83.192     1.063     0.200
    83.206     0.509     0.200
    83.206     1.419     0.200
    83.239    -0.559     0.200
    83.258     0.128     0.200
    83.258     0.302     0.200
    83.342     0.531     0.200
    83.439     1.303     0.200
    83.501     0.290     0.200
    83.516     0.816     0.200
    83.575     0.912     0.200
    83.690     0.723     0.200
    83.697     1.476     0.200
    83.550     1.439     0.200
    83.831     1.620     0.200
    83.830     1.008     0.200
    83.930     0.949     0.200
    83.930     0.828     0.200
    83.760     1.804     0.200
    83.986     0.713     0.200
    83.997     0.502     0.200
    83.988     1.740     0.200
    84.016     0.668     0.200
    84.016     1.448     0.200
    83.986     0.748     0.200
    84.189     0.989     0.200
    84.251     0.773     0.200
    84.388     0.659     0.200
    84.473     2.356     0.200
    84.497     0.878     0.200
    84.566     1.227     0.200
    84.610     0.744     0.200
    84.646     0.815     0.200
    84.691     1.206     0.200
    84.768     1.709     0.200
    84.796     0.869     0.200
    84.799     0.783     0.200
    84.873     0.913     0.200
    84.873     1.413     0.200
    85.013     1.194     0.200
    85.013     1.010     0.200
    85.026     1.271     0.200
    85.047     1.366     0.200
    85.054     0.596     0.200
    85.111     1.366     0.200
    85.150     0.833     0.200
    85.150     0.882     0.200
    85.161     2.128     0.200
    85.293     0.948     0.200
    85.344     0.964     0.200
    85.399     1.090     0.200
    85.421     1.158     0.200
    85.361     2.079     0.200
    85.361     2.509     0.200
    85.544     0.570     0.200
    85.670     0.383     0.200
    85.704     1.315     0.200
    85.743     1.369     0.200
    85.777     1.602     0.200
    85.804     0.830     0.200
    85.810     0.710     0.200
    86.257     0.020     0.200
    86.482     0.771     0.200
    86.239     2.174     0.200
    86.624    -0.444     0.200
    86.673     1.138     0.200
    86.887     0.452     0.200
    86.930     1.685     0.200
    87.093     2.425     0.200
    87.380    -0.929     0.200
    87.721     0.767     0.200
    87.821     0.210     0.200
    87.959     0.136     0.200
    88.378     0.943     0.200
    88.472     0.265     0.200
    88.875     0.108     0.200
    89.546     0.698     0.200
    89.735     0.408     0.200
    90.386     0.532     0.200
    91.549     0.702     0.200
    92.324     0.745     0.200
    92.324     1.405     0.200
    92.463     0.954     0.200
    92.518     0.419     0.200
    92.532     0.783     0.200
    92.532    -0.242     0.200
    93.766     0.870     0.200
    93.671     2.698     0.200
    94.458     0.191     0.200
    95.131     1.040     0.200
    95.892     1.015     0.200
    15.721     3.395     0.200
    21.350    -1.557     0.200
    23.990    -0.130     0.200
    24.763    -0.912     0.200
    24.763     0.604     0.200
    32.327     3.410     0.200
    34.415     2.866     0.200
    36.016    -0.828     0.200
    41.435     0.152     0.200
    45.434    -0.926     0.200
    46.862    -1.513     0.200
    47.224     2.888     0.200
    50.672     0.503     0.200
    51.432    -1.357     0.200
    54.617     0.023     0.200
    54.779    -1.023     0.200
    54.877    -0.891     0.200
    55.474    -0.662     0.200
    55.519    -0.792     0.200
    55.519    -1.227     0.200
    55.519    -1.933     0.200
    56.052    -0.903     0.200
    56.083    -0.336     0.200
    57.131    -1.097     0.200
    63.614    -1.029     0.200
    63.707    -1.311     0.200
    63.836    -0.231     0.200
    63.885    -0.869     0.200
    63.885    -0.722     0.200
    63.945    -0.950     0.200
    64.490    -0.357     0.200
    64.540    -0.523     0.200
    64.897    -1.018     0.200
    65.782    -1.025     0.200
    65.782    -0.431     0.200
    65.889    -0.432     0.200
    68.168    -0.020     0.200
    69.772     0.756     0.200
    70.755    -0.451     0.200
    70.755    -0.111     0.200
    71.781     1.237     0.200
    73.201    -0.080     0.200
    74.211    -1.149     0.200
    76.182    -0.064     0.200
    81.342     0.716     0.200
    81.342    -0.286     0.200
    83.247     0.686     0.200
    84.764     0.675     0.200
    19.796     0.365     0.200
    23.309     1.804     0.200
    23.822    -0.163     0.200
    24.950     0.522     0.200
    24.950     0.278     0.200
    24.950     0.403     0.200
    26.712     2.169     0.200
    29.246     2.210     0.200
    30.168     1.667     0.200
    30.942     3.397     0.200
    31.074     1.100     0.200
    31.828    -0.080     0.200
    32.141     2.394     0.200
    32.242     1.089     0.200
    32.248     1.210     0.200
    34.218     1.952     0.200
    34.218     0.772     0.200
    35.886    -0.078     0.200
    36.540     2.074     0.200
    37.566     0.429     0.200
    38.660     0.463     0.200
    40.510    -0.665     0.200
    41.244     0.280     0.200
    41.244     0.530     0.200
    41.964    -0.724     0.200
    43.078    -0.747     0.200
    44.298    -1.489     0.200
    45.630     0.215     0.200
    45.630     0.946     0.200
    45.629     0.717     0.200
    45.629     1.599     0.200
    45.829     1.652     0.200
    45.947    -0.744     0.200
    45.947    -1.315     0.200
    46.152     0.865     0.200
    46.152     0.346     0.200
    46.661    -0.291     0.200
    46.842    -0.645     0.200
    47.033     1.809     0.200
    47.033     0.886     0.200
    47.887    -0.790     0.200
    48.949     0.462     0.200
    49.166    -0.293     0.200
    50.862     0.755     0.200
    50.947    -0.258     0.200
    50.947    -0.098     0.200
    51.061    -0.429     0.200
    51.085    -0.254     0.200
    51.085    -0.004     0.200
    51.251    -0.663     0.200
    51.650    -1.230     0.200
    52.508    -0.163     0.200
    52.743     0.840     0.200
    54.770     0.040     0.200
    54.813    -0.714     0.200
    55.253    -0.886     0.200
    55.455    -0.672     0.200
    55.509    -1.023     0.200
    55.509    -0.937     0.200
    55.539    -0.361     0.200
    56.071    -0.724     0.200
    56.765    -1.370     0.200
    57.107    -0.699     0.200
    57.261     3.223     0.200
    57.584    -0.993     0.200
    58.140     1.149     0.200
    59.033    -0.533     0.200
    59.114    -0.154     0.200
    59.963    -1.255     0.200
    62.459     0.409     0.200
    63.608    -0.583     0.200
    63.851    -0.085     0.200
    63.851    -0.409     0.200
    63.941     0.214     0.200
    64.037     0.576     0.200
    64.050    -0.100     0.200
    64.171    -0.407     0.200
    64.221    -0.587     0.200
    64.204     0.299     0.200
    64.576     0.241     0.200
    64.578     0.223     0.200
    64.599    -0.314     0.200
    64.818    -0.013     0.200
    64.868    -0.325     0.200
    64.995     0.773     0.200
    65.006     0.577     0.200
    65.147     1.055     0.200
    65.150     0.642     0.200
    65.900    -0.330     0.200
    66.006    -0.252     0.200
    66.199     1.071     0.200
    66.663     0.490     0.200
    68.104     0.549     0.200
    68.113    -0.220     0.200
    70.203     0.146     0.200
    70.470     0.057     0.200
    70.455    -0.168     0.200
    70.826     0.527     0.200
    71.789     0.687     0.200
    71.812     1.275     0.200
    71.899     1.404     0.200
    71.899     1.135     0.200
    71.936     0.691     0.200
    72.332     0.926     0.200
    72.332     1.348     0.200
    73.085     1.557     0.200
    73.302     0.334     0.200
    73.302     0.106     0.200
    73.492     2.668     0.200
    73.657     0.199     0.200
    73.838    -0.160     0.200
    74.135     0.362     0.200
    74.149    -0.877     0.200
    74.158    -0.931     0.200
    74.163    -0.857     0.200
    74.184    -0.880     0.200
    74.189    -0.909     0.200
    74.196    -0.849     0.200
    74.202    -0.884     0.200
    74.205    -0.901     0.200
    74.214    -0.653     0.200
    74.214    -0.064     0.200
    74.214    -0.855     0.200
    74.222    -0.315     0.200
    74.222    -0.899     0.200
    74.222    -0.438     0.200
    74.225    -0.917     0.200
    74.226    -0.923     0.200
    74.243     0.737     0.200
    74.239    -0.903     0.200
    74.240    -0.906     0.200
    74.252     0.026     0.200
    74.252    -0.873     0.200
    74.259    -0.914     0.200
    74.275    -0.910     0.200
    74.279    -0.935     0.200
    74.291    -0.902     0.200
    74.296    -0.934     0.200
    74.296    -0.934     0.200
    74.312    -0.924     0.200
    74.314    -0.839     0.200
    74.330    -0.933     0.200
    74.536     1.376     0.200
    74.745     0.964     0.200
    74.988     1.464     0.200
    75.033     0.503     0.200
    75.069    -1.006     0.200
    75.196     0.664     0.200
    75.349     0.381     0.200
    75.349     0.115     0.200
    75.349    -0.016     0.200
    75.349     0.885     0.200
    75.412     1.224     0.200
    75.513     0.744     0.200
    75.551     0.606     0.200
    75.579     0.765     0.200
    75.795     0.552     0.200
    75.795     0.234     0.200
    75.795     0.722     0.200
    75.810     0.614     0.200
    75.859     0.970     0.200
    75.859     0.669     0.200
    75.907     0.956     0.200
    76.004     1.044     0.200
    76.036     0.362     0.200
    76.150     0.441     0.200
    76.150     0.555     0.200
    76.217     0.730     0.200
    76.217     1.130     0.200
    76.270     1.231     0.200
    76.270     0.952     0.200
    76.264     2.034     0.200
    76.320     0.405     0.200
    76.481    -1.167     0.200
    76.492     1.230     0.200
    76.747     1.414     0.200
    76.747     0.834     0.200
    76.822    -0.188     0.200
    77.017     0.951     0.200
    77.025     0.301     0.200
    77.152     0.973     0.200
    77.170     0.455     0.200
    77.209     1.234     0.200
    77.240     0.880     0.200
    77.240     0.585     0.200
    77.240     1.303     0.200
    77.298     0.423     0.200
    77.395     0.535     0.200
    77.470     0.934     0.200
    77.473     0.463     0.200
    77.499     0.798     0.200
    77.515     0.906     0.200
    77.538     0.939     0.200
    77.614     0.839     0.200
    77.614     1.284     0.200
    77.629     0.804     0.200
    77.767     1.268     0.200
    77.795     0.636     0.200
    77.818     0.717     0.200
    77.895     1.227     0.200
    77.895     1.516     0.200
    77.956     1.268     0.200
    78.117     0.814     0.200
    78.181     1.028     0.200
    78.358     1.000  