#!/bin/bash
gmt begin simeonof10.15_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times simeonof10.15'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   320.908
    25.500   325.449
    26.000   329.978
    26.500   334.496
    27.000   339.001
    27.500   343.489
    28.000   347.957
    28.500   352.410
    29.000   356.854
    29.500   361.288
    30.000   365.715
    30.500   370.134
    31.000   374.546
    31.500   378.950
    32.000   383.345
    32.500   387.730
    33.000   392.105
    33.500   396.467
    34.000   400.814
    34.500   405.146
    35.000   409.464
    35.500   413.766
    36.000   418.053
    36.500   422.325
    37.000   426.581
    37.500   430.822
    38.000   435.047
    38.500   439.255
    39.000   443.447
    39.500   447.622
    40.000   451.780
    40.500   455.921
    41.000   460.045
    41.500   464.152
    42.000   468.241
    42.500   472.314
    43.000   476.369
    43.500   480.406
    44.000   484.426
    44.500   488.428
    45.000   492.412
    45.500   496.379
    46.000   500.327
    46.500   504.257
    47.000   508.169
    47.500   512.063
    48.000   515.940
    48.500   519.797
    49.000   523.637
    49.500   527.459
    50.000   531.262
    50.500   535.047
    51.000   538.814
    51.500   542.562
    52.000   546.293
    52.500   550.005
    53.000   553.700
    53.500   557.377
    54.000   561.036
    54.500   564.677
    55.000   568.299
    55.500   571.903
    56.000   575.488
    56.500   579.055
    57.000   582.603
    57.500   586.134
    58.000   589.646
    58.500   593.141
    59.000   596.617
    59.500   600.074
    60.000   603.514
    60.500   606.935
    61.000   610.338
    61.500   613.722
    62.000   617.088
    62.500   620.436
    63.000   623.766
    63.500   627.079
    64.000   630.373
    64.500   633.650
    65.000   636.909
    65.500   640.149
    66.000   643.372
    66.500   646.577
    67.000   649.763
    67.500   652.932
    68.000   656.082
    68.500   659.214
    69.000   662.328
    69.500   665.424
    70.000   668.502
    70.500   671.561
    71.000   674.603
    71.500   677.626
    72.000   680.632
    72.500   683.619
    73.000   686.587
    73.500   689.538
    74.000   692.469
    74.500   695.382
    75.000   698.275
    75.500   701.151
    76.000   704.008
    76.500   706.847
    77.000   709.668
    77.500   712.471
    78.000   715.256
    78.500   718.023
    79.000   720.771
    79.500   723.501
    80.000   726.213
    80.500   728.905
    81.000   731.578
    81.500   734.232
    82.000   736.867
    82.500   739.483
    83.000   742.080
    83.500   744.659
    84.000   747.217
    84.500   749.756
    85.000   752.274
    85.500   754.772
    86.000   757.252
    86.500   759.714
    87.000   762.158
    87.500   764.579
    88.000   766.964
    88.500   769.329
    89.000   771.682
    89.500   774.027
    90.000   776.364
    90.500   778.695
    91.000   781.019
    91.500   783.338
    92.000   785.652
    92.500   787.962
    93.000   790.269
    93.500   792.573
    94.000   794.872
    94.500   797.168
    95.000   799.458
    95.500   801.741
    96.000   804.019
    96.500   806.290
    97.000   808.554
    97.500   810.812
    98.000   813.063
    98.500   815.306
    99.000   817.542
    99.500   819.770
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1118.699
   116.000  1119.661
   116.500  1120.623
   117.000  1121.585
   117.500  1122.547
   118.000  1123.509
   118.500  1124.470
   119.000  1125.432
   119.500  1126.394
   120.000  1127.355
   120.500  1128.316
   121.000  1129.277
   121.500  1130.237
   122.000  1131.198
   122.500  1132.157
   123.000  1133.117
   123.500  1134.076
   124.000  1135.035
   124.500  1135.993
   125.000  1136.950
   125.500  1137.908
   126.000  1138.864
   126.500  1139.820
   127.000  1140.775
   127.500  1141.729
   128.000  1142.683
   128.500  1143.636
   129.000  1144.588
   129.500  1145.539
   130.000  1146.488
   130.500  1147.437
   131.000  1148.385
   131.500  1149.331
   132.000  1150.276
   132.500  1151.220
   133.000  1152.162
   133.500  1153.102
   134.000  1154.041
   134.500  1154.978
   135.000  1155.913
   135.500  1156.846
   136.000  1157.777
   136.500  1158.706
   137.000  1159.632
   137.500  1160.556
   138.000  1161.478
   138.500  1162.396
   139.000  1163.312
   139.500  1164.224
   140.000  1165.134
   140.500  1166.040
   141.000  1166.942
   141.500  1167.841
   142.000  1168.735
   142.500  1169.625
   143.000  1170.511
   143.500  1171.392
   144.000  1172.268
   144.500  1173.139
   145.000  1174.005
   145.500  1174.865
   146.000  1175.718
   146.500  1176.565
   147.000  1177.406
   147.500  1178.240
   148.000  1179.067
   148.500  1179.886
   149.000  1180.698
   149.500  1181.500
   150.000  1182.293
   150.500  1183.076
   151.000  1183.849
   151.500  1184.612
   152.000  1185.365
   152.500  1186.108
   153.000  1186.841
   153.500  1187.564
   154.000  1188.276
   154.500  1188.977
   155.000  1189.667
   155.500  1190.346
   156.000  1191.013
   156.500  1191.668
   157.000  1192.311
   157.500  1192.943
   158.000  1193.561
   158.500  1194.168
   159.000  1194.761
   159.500  1195.343
   160.000  1195.911
   160.500  1196.466
   161.000  1197.008
   161.500  1197.537
   162.000  1198.053
   162.500  1198.556
   163.000  1199.045
   163.500  1199.521
   164.000  1199.983
   164.500  1200.431
   165.000  1200.865
   165.500  1201.286
   166.000  1201.692
   166.500  1202.085
   167.000  1202.464
   167.500  1202.829
   168.000  1203.180
   168.500  1203.517
   169.000  1203.839
   169.500  1204.148
   170.000  1204.442
   170.500  1204.723
   171.000  1204.989
   171.500  1205.240
   172.000  1205.478
   172.500  1205.701
   173.000  1205.909
   173.500  1206.104
   174.000  1206.284
   174.500  1206.450
   175.000  1206.601
   175.500  1206.738
   176.000  1206.861
   176.500  1206.969
   177.000  1207.063
   177.500  1207.142
   178.000  1207.207
   178.500  1207.257
   179.000  1207.293
   179.500  1207.315
   180.000  1207.323
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   989.621
     1.000   989.629
     1.500   989.643
     2.000   989.663
     2.500   989.688
     3.000   989.719
     3.500   989.755
     4.000   989.797
     4.500   989.845
     5.000   989.898
     5.500   989.957
     6.000   990.021
     6.500   990.091
     7.000   990.167
     7.500   990.248
     8.000   990.334
     8.500   990.426
     9.000   990.524
     9.500   990.628
    10.000   990.736
    10.500   990.851
    11.000   990.971
    11.500   991.096
    12.000   991.228
    12.500   991.364
    13.000   991.507
    13.500   991.654
    14.000   991.807
    14.500   991.966
    15.000   992.131
    15.500   992.300
    16.000   992.476
    16.500   992.657
    17.000   992.843
    17.500   993.035
    18.000   993.232
    18.500   993.435
    19.000   993.643
    19.500   993.857
    20.000   994.076
    20.500   994.300
    21.000   994.530
    21.500   994.766
    22.000   995.006
    22.500   995.253
    23.000   995.504
    23.500   995.761
    24.000   996.024
    24.500   996.292
    25.000   996.565
    25.500   996.843
    26.000   997.127
    26.500   997.416
    27.000   997.711
    27.500   998.011
    28.000   998.316
    28.500   998.626
    29.000   998.942
    29.500   999.263
    30.000   999.590
    30.500   999.921
    31.000  1000.258
    31.500  1000.600
    32.000  1000.947
    32.500  1001.300
    33.000  1001.657
    33.500  1002.020
    34.000  1002.388
    34.500  1002.761
    35.000  1003.140
    35.500  1003.523
    36.000  1003.912
    36.500  1004.305
    37.000  1004.704
    37.500  1005.108
    38.000  1005.517
    38.500  1005.931
    39.000  1006.350
    39.500  1006.774
    40.000  1007.203
    40.500  1007.637
    41.000  1008.076
    41.500  1008.521
    42.000  1008.969
    42.500  1009.423
    43.000  1009.882
    43.500  1010.346
    44.000  1010.815
    44.500  1011.288
    45.000  1011.767
    45.500  1012.250
    46.000  1012.738
    46.500  1013.231
    47.000  1013.729
    47.500  1014.231
    48.000  1014.738
    48.500  1015.251
    49.000  1015.767
    49.500  1016.289
    50.000  1016.815
    50.500  1017.346
    51.000  1017.881
    51.500  1018.422
    52.000  1018.966
    52.500  1019.516
    53.000  1020.070
    53.500  1020.629
    54.000  1021.192
    54.500  1021.759
    55.000  1022.332
    55.500  1022.908
    56.000  1023.490
    56.500  1024.075
    57.000  1024.666
    57.500  1025.260
    58.000  1025.859
    58.500  1026.463
    59.000  1027.071
    59.500  1027.683
    60.000  1028.299
    60.500  1028.920
    61.000  1029.545
    61.500  1030.175
    62.000  1030.808
    62.500  1031.446
    63.000  1032.088
    63.500  1032.735
    64.000  1033.385
    64.500  1034.040
    65.000  1034.699
    65.500  1035.362
    66.000  1036.029
    66.500  1036.700
    67.000  1037.375
    67.500  1038.054
    68.000  1038.738
    68.500  1039.425
    69.000  1040.116
    69.500  1040.811
    70.000  1041.511
    70.500  1042.214
    71.000  1042.921
    71.500  1043.631
    72.000  1044.346
    72.500  1045.065
    73.000  1045.787
    73.500  1046.513
    74.000  1047.243
    74.500  1047.977
    75.000  1048.714
    75.500  1049.455
    76.000  1050.200
    76.500  1050.948
    77.000  1051.700
    77.500  1052.456
    78.000  1053.215
    78.500  1053.978
    79.000  1054.744
    79.500  1055.514
    80.000  1056.287
    80.500  1057.064
    81.000  1057.844
    81.500  1058.628
    82.000  1059.415
    82.500  1060.206
    83.000  1061.000
    83.500  1061.797
    84.000  1062.598
    84.500  1063.401
    85.000  1064.208
    85.500  1065.019
    86.000  1065.832
    86.500  1066.649
    87.000  1067.469
    87.500  1068.292
    88.000  1069.119
    88.500  1069.948
    89.000  1070.781
    89.500  1071.616
    90.000  1072.455
    90.500  1073.296
    91.000  1074.141
    91.500  1074.988
    92.000  1075.839
    92.500  1076.692
    93.000  1077.549
    93.500  1078.408
    94.000  1079.270
    94.500  1080.135
    95.000  1081.003
    95.500  1081.873
    96.000  1082.746
    96.500  1083.622
    97.000  1084.501
    97.500  1085.382
    98.000  1086.266
    98.500  1087.153
    99.000  1088.042
    99.500  1088.934
   100.000  1089.829
   100.500  1090.726
   101.000  1091.625
   101.500  1092.527
   102.000  1093.432
   102.500  1094.339
   103.000  1095.248
   103.500  1096.160
   104.000  1097.074
   104.500  1097.990
   105.000  1098.909
   105.500  1099.830
   106.000  1100.754
   106.500  1101.679
   107.000  1102.607
   107.500  1103.537
   108.000  1104.469
   108.500  1105.404
   109.000  1106.340
   109.500  1107.279
   110.000  1108.220
   110.500  1109.163
   111.000  1110.108
   111.500  1111.054
   112.000  1112.003
   112.500  1112.954
   113.000  1113.907
   113.500  1114.861
   114.000  1115.818
   114.500  1116.776
   115.000  1117.737
   115.500  1118.699
   116.000  1119.663
   116.500  1120.628
   117.000  1121.596
   117.500  1122.565
   118.000  1123.536
   118.500  1124.508
   119.000  1125.482
   119.500  1126.458
   120.000  1127.436
   120.500  1128.415
   121.000  1129.395
   121.500  1130.377
   122.000  1131.361
   122.500  1132.346
   123.000  1133.332
   123.500  1134.320
   124.000  1135.310
   124.500  1136.301
   125.000  1137.293
   125.500  1138.286
   126.000  1139.281
   126.500  1140.277
   127.000  1141.274
   127.500  1142.273
   128.000  1143.273
   128.500  1144.274
   129.000  1145.276
   129.500  1146.280
   130.000  1147.284
   130.500  1148.290
   131.000  1149.296
   131.500  1150.304
   132.000  1151.313
   132.500  1152.323
   133.000  1153.334
   133.500  1154.345
   134.000  1155.358
   134.500  1156.372
   135.000  1157.386
   135.500  1158.402
   136.000  1159.418
   136.500  1160.435
   137.000  1161.453
   137.500  1162.472
   138.000  1163.491
   138.500  1164.512
   139.000  1165.533
   139.500  1166.554
   140.000  1167.577
   140.500  1168.600
   141.000  1169.623
   141.500  1170.648
   142.000  1171.672
   142.500  1172.698
   143.000  1173.724
   143.500  1174.750
   144.000  1175.777
   144.500  1176.805
   145.000  1177.833
   145.500  1178.861
   146.000  1179.890
   146.500  1180.919
   147.000  1181.948
   147.500  1182.978
   148.000  1184.008
   148.500  1185.039
   149.000  1186.070
   149.500  1187.101
   150.000  1188.132
   150.500  1189.163
   151.000  1190.195
   151.500  1191.227
   152.000  1192.259
   152.500  1193.291
   153.000  1194.324
   153.500  1195.356
   154.000  1196.389
   154.500  1197.421
   155.000  1198.454
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1173.367
   145.500  1175.197
   146.000  1177.080
   146.500  1179.000
   147.000  1180.947
   147.500  1182.917
   148.000  1184.907
   148.500  1186.914
   149.000  1188.936
   149.500  1190.973
   150.000  1193.022
   150.500  1195.082
   151.000  1197.153
   151.500  1199.233
   152.000  1201.323
   152.500  1203.420
   153.000  1205.526
   153.500  1207.638
   154.000  1209.758
   154.500  1211.885
   155.000  1214.017
   155.500  1216.155
   156.000  1218.298
   156.500  1220.446
   157.000  1222.599
   157.500  1224.756
   158.000  1226.918
   158.500  1229.083
   159.000  1231.253
   159.500  1233.426
   160.000  1235.603
   160.500  1237.783
   161.000  1239.965
   161.500  1242.151
   162.000  1244.340
   162.500  1246.531
   163.000  1248.724
   163.500  1250.920
   164.000  1253.117
   164.500  1255.317
   165.000  1257.519
   165.500  1259.722
   166.000  1261.928
   166.500  1264.134
   167.000  1266.343
   167.500  1268.553
   168.000  1270.764
   168.500  1272.976
   169.000  1275.189
   169.500  1277.404
   170.000  1279.620
   170.500  1281.836
   171.000  1284.053
   171.500  1286.271
   172.000  1288.490
   172.500  1290.710
   173.000  1292.930
   173.500  1295.150
   174.000  1297.371
   174.500  1299.593
   175.000  1301.814
   175.500  1304.037
   176.000  1306.259
   176.500  1308.481
   177.000  1310.704
   177.500  1312.927
   178.000  1315.150
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1173.358
   145.500  1174.977
   146.000  1176.520
   146.500  1178.006
   147.000  1179.443
   147.500  1180.834
   148.000  1182.184
   148.500  1183.494
   149.000  1184.770
   149.500  1186.017
   150.000  1187.239
   150.500  1188.439
   151.000  1189.618
   151.500  1190.777
   152.000  1191.918
   152.500  1193.043
   153.000  1194.151
   153.500  1195.245
   154.000  1196.325
   154.500  1197.393
   155.000  1198.447
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   506.496
     1.000   506.533
     1.500   506.593
     2.000   506.677
     2.500   506.785
     3.000   506.917
     3.500   507.073
     4.000   507.253
     4.500   507.457
     5.000   507.685
     5.500   507.936
     6.000   508.211
     6.500   508.510
     7.000   508.833
     7.500   509.179
     8.000   509.549
     8.500   509.942
     9.000   510.359
     9.500   510.799
    10.000   511.262
    10.500   511.748
    11.000   512.257
    11.500   512.790
    12.000   513.345
    12.500   513.922
    13.000   514.523
    13.500   515.146
    14.000   515.791
    14.500   516.459
    15.000   517.148
    15.500   517.860
    16.000   518.594
    16.500   519.349
    17.000   520.126
    17.500   520.925
    18.000   521.745
    18.500   522.586
    19.000   523.449
    19.500   524.332
    20.000   525.236
    20.500   526.160
    21.000   527.106
    21.500   528.071
    22.000   529.057
    22.500   530.062
    23.000   531.088
    23.500   532.133
    24.000   533.197
    24.500   534.281
    25.000   535.384
    25.500   536.506
    26.000   537.647
    26.500   538.806
    27.000   539.984
    27.500   541.181
    28.000   542.395
    28.500   543.627
    29.000   544.877
    29.500   546.144
    30.000   547.429
    30.500   548.731
    31.000   550.050
    31.500   551.386
    32.000   552.739
    32.500   554.108
    33.000   555.493
    33.500   556.894
    34.000   558.311
    34.500   559.744
    35.000   561.192
    35.500   562.656
    36.000   564.135
    36.500   565.628
    37.000   567.137
    37.500   568.660
    38.000   570.197
    38.500   571.749
    39.000   573.315
    39.500   574.894
    40.000   576.487
    40.500   578.094
    41.000   579.714
    41.500   581.347
    42.000   582.992
    42.500   584.651
    43.000   586.322
    43.500   588.006
    44.000   589.702
    44.500   591.409
    45.000   593.129
    45.500   594.860
    46.000   596.603
    46.500   598.357
    47.000   600.122
    47.500   601.898
    48.000   603.685
    48.500   605.482
    49.000   607.290
    49.500   609.109
    50.000   610.937
    50.500   612.775
    51.000   614.623
    51.500   616.481
    52.000   618.348
    52.500   620.225
    53.000   622.110
    53.500   624.005
    54.000   625.908
    54.500   627.820
    55.000   629.741
    55.500   631.670
    56.000   633.607
    56.500   635.552
    57.000   637.505
    57.500   639.466
    58.000   641.435
    58.500   643.410
    59.000   645.394
    59.500   647.384
    60.000   649.382
    60.500   651.386
    61.000   653.397
    61.500   655.415
    62.000   657.439
    62.500   659.470
    63.000   661.506
    63.500   663.549
    64.000   665.598
    64.500   667.653
    65.000   669.713
    65.500   671.779
    66.000   673.850
    66.500   675.927
    67.000   678.009
    67.500   680.096
    68.000   682.188
    68.500   684.285
    69.000   686.387
    69.500   688.493
    70.000   690.603
    70.500   692.719
    71.000   694.838
    71.500   696.961
    72.000   699.089
    72.500   701.221
    73.000   703.356
    73.500   705.495
    74.000   707.638
    74.500   709.785
    75.000   711.934
    75.500   714.088
    76.000   716.244
    76.500   718.404
    77.000   720.566
    77.500   722.732
    78.000   724.900
    78.500   727.072
    79.000   729.246
    79.500   731.422
    80.000   733.601
    80.500   735.783
    81.000   737.967
    81.500   740.153
    82.000   742.341
    82.500   744.532
    83.000   746.724
    83.500   748.919
    84.000   751.115
    84.500   753.313
    85.000   755.513
    85.500   757.715
    86.000   759.918
    86.500   762.123
    87.000   764.329
    87.500   766.536
    88.000   768.745
    88.500   770.955
    89.000   773.166
    89.500   775.378
    90.000   777.592
    90.500   779.806
    91.000   782.021
    91.500   784.238
    92.000   786.455
    92.500   788.672
    93.000   790.891
    93.500   793.110
    94.000   795.330
    94.500   797.550
    95.000   799.770
    95.500   801.992
    96.000   804.213
    96.500   806.435
    97.000   808.657
    97.500   810.879
    98.000   813.102
    98.500   815.325
    99.000   817.547
    99.500   819.770
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.000   411.448
    28.500   417.005
    29.000   422.563
    29.500   428.119
    30.000   433.675
    30.500   439.230
    31.000   444.783
    31.500   450.334
    32.000   455.883
    32.500   461.430
    33.000   466.973
    33.500   472.514
    34.000   478.050
    34.500   483.582
    35.000   489.109
    35.500   494.631
    36.000   500.148
    36.500   505.658
    37.000   511.161
    37.500   516.657
    38.000   522.146
    38.500   527.626
    39.000   533.096
    39.500   538.557
    40.000   544.009
    40.500   549.449
    41.000   554.878
    41.500   560.295
    42.000   565.700
    42.500   571.091
    43.000   576.470
    43.500   581.834
    44.000   587.184
    44.500   592.518
    45.000   597.838
    45.500   603.141
    46.000   608.429
    46.500   613.699
    47.000   618.953
    47.500   623.534
    48.000   628.104
    48.500   632.669
    49.000   637.230
    49.500   641.785
    50.000   646.335
    50.500   650.881
    51.000   655.420
    51.500   659.955
    52.000   664.483
    52.500   669.007
    53.000   673.524
    53.500   678.034
    54.000   682.538
    54.500   687.033
    55.000   691.520
    55.500   695.995
    56.000   700.461
    56.500   704.920
    57.000   709.372
    57.500   713.819
    58.000   718.262
    58.500   722.700
    59.000   727.133
    59.500   731.563
    60.000   735.989
    60.500   740.412
    61.000   744.830
    61.500   749.245
    62.000   753.656
    62.500   758.062
    63.000   762.465
    63.500   766.864
    64.000   771.259
    64.500   775.648
    65.000   780.033
    65.500   784.412
    66.000   788.786
    66.500   793.153
    67.000   797.513
    67.500   801.867
    68.000   806.213
    68.500   810.551
    69.000   814.882
    69.500   819.205
    70.000   823.521
    70.500   827.829
    71.000   832.130
    71.500   836.423
    72.000   840.709
    72.500   844.987
    73.000   849.257
    73.500   853.520
    74.000   857.775
    74.500   862.022
    75.000   866.261
    75.500   870.492
    76.000   874.715
    76.500   878.930
    77.000   883.137
    77.500   887.335
    78.000   891.525
    78.500   895.707
    79.000   899.880
    79.500   904.045
    80.000   908.201
    80.500   912.349
    81.000   916.488
    81.500   920.618
    82.000   924.740
    82.500   928.854
    83.000   932.959
    83.500   937.055
    84.000   941.143
    84.500   945.222
    85.000   949.293
    85.500   953.355
    86.000   957.408
    86.500   961.453
    87.000   965.488
    87.500   969.515
    88.000   973.533
    88.500   977.542
    89.000   981.542
    89.500   985.533
    90.000   989.515
    90.500   993.488
    91.000   997.452
    91.500  1001.407
    92.000  1005.354
    92.500  1009.291
    93.000  1013.219
    93.500  1017.138
    94.000  1021.048
    94.500  1024.949
    95.000  1028.841
    95.500  1032.724
    96.000  1036.598
    96.500  1040.463
    97.000  1044.319
    97.500  1048.166
    98.000  1052.003
    98.500  1055.832
    99.000  1059.651
    99.500  1063.461
   100.000  1067.262
   100.500  1071.054
   101.000  1074.837
   101.500  1078.610
   102.000  1082.375
   102.500  1086.130
   103.000  1089.876
   103.500  1093.614
   104.000  1097.342
   104.500  1101.061
   105.000  1104.772
   105.500  1108.474
   106.000  1112.166
   106.500  1115.850
   107.000  1119.525
   107.500  1123.191
   108.000  1126.847
   108.500  1130.495
   109.000  1134.133
   109.500  1137.762
   110.000  1141.382
   110.500  1144.993
   111.000  1148.594
   111.500  1152.186
   112.000  1155.769
   112.500  1159.342
   113.000  1162.907
   113.500  1166.462
   114.000  1170.008
   114.500  1173.545
   115.000  1177.073
   115.500  1180.592
   116.000  1184.102
   116.500  1187.603
   117.000  1191.095
   117.500  1194.578
   118.000  1198.052
   118.500  1201.516
   119.000  1204.972
   119.500  1208.418
   120.000  1211.855
   120.500  1215.283
   121.000  1218.701
   121.500  1222.110
   122.000  1225.510
   122.500  1228.901
   123.000  1232.283
   123.500  1235.656
   124.000  1239.020
   124.500  1242.374
   125.000  1245.720
   125.500  1249.057
   126.000  1252.384
   126.500  1255.703
   127.000  1259.013
   127.500  1262.314
   128.000  1265.606
   128.500  1268.889
   129.000  1272.163
   129.500  1275.428
   130.000  1278.684
   130.500  1281.931
   131.000  1285.169
   131.500  1288.398
   132.000  1291.619
   132.500  1294.830
   133.000  1298.032
   133.500  1301.225
   134.000  1304.409
   134.500  1307.583
   135.000  1310.749
   135.500  1313.906
   136.000  1317.054
   136.500  1320.192
   137.000  1323.322
   137.500  1326.442
   138.000  1329.554
   138.500  1332.656
   139.000  1335.749
   139.500  1338.833
   140.000  1341.908
   140.500  1344.974
   141.000  1348.031
   141.500  1351.079
   142.000  1354.118
   142.500  1357.147
   143.000  1360.168
   143.500  1363.180
   144.000  1366.182
   144.500  1369.176
   145.000  1372.160
   145.500  1375.135
   146.000  1378.101
   146.500  1381.058
   147.000  1384.005
   147.500  1386.943
   148.000  1389.871
   148.500  1392.790
   149.000  1395.700
   149.500  1398.600
   150.000  1401.491
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   821.993
   100.500   824.216
   101.000   826.439
   101.500   828.661
   102.000   830.884
   102.500   833.107
   103.000   835.330
   103.500   837.553
   104.000   839.776
   104.500   841.998
   105.000   844.221
   105.500   846.444
   106.000   848.667
   106.500   850.890
   107.000   853.113
   107.500   855.335
   108.000   857.558
   108.500   859.781
   109.000   862.004
   109.500   864.227
   110.000   866.450
   110.500   868.672
   111.000   870.895
   111.500   873.118
   112.000   875.341
   112.500   877.564
   113.000   879.787
   113.500   882.010
   114.000   884.232
   114.500   886.455
   115.000   888.678
   115.500   890.901
   116.000   893.124
   116.500   895.346
   117.000   897.569
   117.500   899.792
   118.000   902.015
   118.500   904.238
   119.000   906.461
   119.500   908.684
   120.000   910.906
   120.500   913.129
   121.000   915.352
   121.500   917.575
   122.000   919.798
   122.500   922.021
   123.000   924.243
   123.500   926.466
   124.000   928.689
   124.500   930.912
   125.000   933.135
   125.500   935.358
   126.000   937.580
   126.500   939.803
   127.000   942.026
   127.500   944.249
   128.000   946.472
   128.500   948.695
   129.000   950.917
   129.500   953.140
   130.000   955.363
   130.500   957.586
   131.000   959.809
   131.500   962.031
   132.000   964.254
   132.500   966.477
   133.000   968.700
   133.500   970.923
   134.000   973.146
   134.500   975.369
   135.000   977.591
   135.500   979.814
   136.000   982.037
   136.500   984.260
   137.000   986.483
   137.500   988.706
   138.000   990.928
   138.500   993.151
   139.000   995.374
   139.500   997.597
   140.000   999.820
   140.500  1002.042
   141.000  1004.265
   141.500  1006.488
   142.000  1008.711
   142.500  1010.934
   143.000  1013.157
   143.500  1015.380
   144.000  1017.602
   144.500  1019.825
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   381.422
    15.000   391.659
    15.500   401.892
    16.000   412.116
    16.500   422.330
    17.000   432.527
    17.500   442.705
    18.000   452.858
    18.500   462.981
    19.000   472.864
    19.500   483.115
    20.000   493.113
    20.500   503.058
    21.000   512.945
    21.500   522.766
    22.000   532.519
    22.500   542.198
    23.000   550.463
    23.500   558.597
    24.000   566.699
    24.500   574.767
    25.000   582.786
    25.500   590.722
    26.000   598.630
    26.500   606.528
    27.000   614.418
    27.500   622.300
    28.000   630.176
    28.500   638.045
    29.000   645.907
    29.500   653.763
    30.000   661.611
    30.500   669.451
    31.000   677.280
    31.500   685.098
    32.000   692.903
    32.500   700.694
    33.000   708.469
    33.500   716.226
    34.000   723.966
    34.500   731.687
    35.000   739.389
    35.500   747.072
    36.000   754.734
    36.500   762.377
    37.000   770.000
    37.500   777.602
    38.000   785.182
    38.500   792.741
    39.000   800.277
    39.500   807.791
    40.000   815.282
    40.500   822.750
    41.000   830.195
    41.500   837.616
    42.000   845.013
    42.500   852.386
    43.000   859.734
    43.500   867.058
    44.000   874.357
    44.500   881.631
    45.000   888.880
    45.500   896.104
    46.000   903.302
    46.500   910.474
    47.000   917.620
    47.500   924.740
    48.000   931.833
    48.500   938.899
    49.000   945.938
    49.500   952.950
    50.000   959.935
    50.500   966.893
    51.000   973.824
    51.500   980.728
    52.000   987.603
    52.500   994.452
    53.000  1001.273
    53.500  1008.068
    54.000  1014.838
    54.500  1021.581
    55.000  1028.297
    55.500  1034.986
    56.000  1041.648
    56.500  1048.282
    57.000  1054.888
    57.500  1061.466
    58.000  1068.016
    58.500  1074.537
    59.000  1081.032
    59.500  1087.499
    60.000  1093.938
    60.500  1100.349
    61.000  1106.733
    61.500  1113.089
    62.000  1119.416
    62.500  1125.715
    63.000  1131.985
    63.500  1138.227
    64.000  1144.441
    64.500  1150.626
    65.000  1156.783
    65.500  1162.912
    66.000  1169.012
    66.500  1175.085
    67.000  1181.129
    67.500  1187.144
    68.000  1193.131
    68.500  1199.090
    69.000  1205.019
    69.500  1210.920
    70.000  1216.793
    70.500  1222.637
    71.000  1228.452
    71.500  1234.238
    72.000  1239.995
    72.500  1245.722
    73.000  1251.420
    73.500  1257.087
    74.000  1262.725
    74.500  1268.333
    75.000  1273.911
    75.500  1279.460
    76.000  1284.979
    76.500  1290.469
    77.000  1295.930
    77.500  1301.360
    78.000  1306.760
    78.500  1312.130
    79.000  1317.470
    79.500  1322.780
    80.000  1328.062
    80.500  1333.314
    81.000  1338.536
    81.500  1343.726
    82.000  1348.884
    82.500  1354.011
    83.000  1359.105
    83.500  1364.169
    84.000  1369.201
    84.500  1374.203
    85.000  1379.173
    85.500  1384.112
    86.000  1389.019
    86.500  1393.894
    87.000  1398.737
    87.500  1403.548
    88.000  1408.325
    88.500  1413.070
    89.000  1417.781
    89.500  1422.458
    90.000  1427.102
    90.500  1431.713
    91.000  1436.289
    91.500  1440.832
    92.000  1445.341
    92.500  1449.816
    93.000  1454.257
    93.500  1458.664
    94.000  1463.047
    94.500  1467.413
    95.000  1471.767
    95.500  1476.109
    96.000  1480.440
    96.500  1484.756
    97.000  1489.056
    97.500  1493.336
    98.000  1497.596
    98.500  1501.836
    99.000  1506.057
    99.500  1510.257
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   715.006
     1.000   715.053
     1.500   715.131
     2.000   715.240
     2.500   715.380
     3.000   715.551
     3.500   715.754
     4.000   715.987
     4.500   716.251
     5.000   716.546
     5.500   716.872
     6.000   717.228
     6.500   717.615
     7.000   718.033
     7.500   718.481
     8.000   718.959
     8.500   719.468
     9.000   720.007
     9.500   720.575
    10.000   721.174
    10.500   721.802
    11.000   722.459
    11.500   723.146
    12.000   723.862
    12.500   724.607
    13.000   725.381
    13.500   726.184
    14.000   727.015
    14.500   727.874
    15.000   728.762
    15.500   729.677
    16.000   730.620
    16.500   731.591
    17.000   732.588
    17.500   733.613
    18.000   734.664
    18.500   735.742
    19.000   736.846
    19.500   737.976
    20.000   739.132
    20.500   740.314
    21.000   741.520
    21.500   742.752
    22.000   744.009
    22.500   745.289
    23.000   746.594
    23.500   747.923
    24.000   749.276
    24.500   750.652
    25.000   752.051
    25.500   753.472
    26.000   754.916
    26.500   756.382
    27.000   757.870
    27.500   759.380
    28.000   760.910
    28.500   762.462
    29.000   764.034
    29.500   765.626
    30.000   767.238
    30.500   768.870
    31.000   770.522
    31.500   772.192
    32.000   773.881
    32.500   775.588
    33.000   777.313
    33.500   779.056
    34.000   780.816
    34.500   782.593
    35.000   784.387
    35.500   786.197
    36.000   788.023
    36.500   789.865
    37.000   791.722
    37.500   793.594
    38.000   795.481
    38.500   797.382
    39.000   799.298
    39.500   801.226
    40.000   803.168
    40.500   805.124
    41.000   807.091
    41.500   809.071
    42.000   811.063
    42.500   813.067
    43.000   815.082
    43.500   817.108
    44.000   819.145
    44.500   821.191
    45.000   823.248
    45.500   825.315
    46.000   827.391
    46.500   829.476
    47.000   831.570
    47.500   833.672
    48.000   835.782
    48.500   837.900
    49.000   840.025
    49.500   842.157
    50.000   844.297
    50.500   846.442
    51.000   848.594
    51.500   850.752
    52.000   852.916
    52.500   855.085
    53.000   857.259
    53.500   859.438
    54.000   861.621
    54.500   863.809
    55.000   866.000
    55.500   868.195
    56.000   870.394
    56.500   872.596
    57.000   874.801
    57.500   877.008
    58.000   879.218
    58.500   881.430
    59.000   883.644
    59.500   885.860
    60.000   888.078
    60.500   890.297
    61.000   892.517
    61.500   894.738
    62.000   896.959
    62.500   899.182
    63.000   901.404
    63.500   903.627
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   927.061
     1.000   927.127
     1.500   927.238
     2.000   927.393
     2.500   927.593
     3.000   927.836
     3.500   928.124
     4.000   928.456
     4.500   928.832
     5.000   929.252
     5.500   929.716
     6.000   930.224
     6.500   930.775
     7.000   931.371
     7.500   932.009
     8.000   932.691
     8.500   933.417
     9.000   934.185
     9.500   934.997
    10.000   935.851
    10.500   936.748
    11.000   937.687
    11.500   938.669
    12.000   939.693
    12.500   940.759
    13.000   941.867
    13.500   943.016
    14.000   944.207
    14.500   945.439
    15.000   946.712
    15.500   948.025
    16.000   949.379
    16.500   950.774
    17.000   952.208
    17.500   953.682
    18.000   955.196
    18.500   956.748
    19.000   958.340
    19.500   959.971
    20.000   961.640
    20.500   963.347
    21.000   965.092
    21.500   966.874
    22.000   968.694
    22.500   970.551
    23.000   972.445
    23.500   974.375
    24.000   976.341
    24.500   978.343
    25.000   980.380
    25.500   982.453
    26.000   984.560
    26.500   986.703
    27.000   988.879
    27.500   991.089
    28.000   993.333
    28.500   995.610
    29.000   997.920
    29.500  1000.263
    30.000  1002.637
    30.500  1005.044
    31.000  1007.483
    31.500  1009.952
    32.000  1012.453
    32.500  1014.984
    33.000  1017.545
    33.500  1020.137
    34.000  1022.758
    34.500  1025.408
    35.000  1028.087
    35.500  1030.795
    36.000  1033.531
    36.500  1036.295
    37.000  1039.086
    37.500  1041.905
    38.000  1044.750
    38.500  1047.622
    39.000  1050.521
    39.500  1053.445
    40.000  1056.394
    40.500  1059.369
    41.000  1062.369
    41.500  1065.393
    42.000  1068.442
    42.500  1071.515
    43.000  1074.610
    43.500  1077.730
    44.000  1080.872
    44.500  1084.037
    45.000  1087.224
    45.500  1090.433
    46.000  1093.663
    46.500  1096.915
    47.000  1100.188
    47.500  1103.482
    48.000  1106.796
    48.500  1110.130
    49.000  1113.484
    49.500  1116.857
    50.000  1120.250
    50.500  1123.661
    51.000  1127.091
    51.500  1130.539
    52.000  1134.005
    52.500  1137.489
    53.000  1140.991
    53.500  1144.509
    54.000  1148.044
    54.500  1151.596
    55.000  1155.164
    55.500  1158.748
    56.000  1162.348
    56.500  1165.963
    57.000  1169.593
    57.500  1173.238
    58.000  1176.898
    58.500  1180.572
    59.000  1184.260
    59.500  1187.962
    60.000  1191.678
    60.500  1195.407
    61.000  1199.149
    61.500  1202.904
    62.000  1206.672
    62.500  1210.451
    63.000  1214.243
    63.500  1218.047
    64.000  1221.863
    64.500  1225.689
    65.000  1229.527
    65.500  1233.376
    66.000  1237.236
    66.500  1241.106
    67.000  1244.986
    67.500  1248.876
    68.000  1252.776
    68.500  1256.686
    69.000  1260.605
    69.500  1264.533
    70.000  1268.471
    70.500  1272.417
    71.000  1276.371
    71.500  1280.334
    72.000  1284.305
    72.500  1288.284
    73.000  1292.270
    73.500  1296.264
    74.000  1300.266
    74.500  1304.275
    75.000  1308.290
    75.500  1312.313
    76.000  1316.342
    76.500  1320.377
    77.000  1324.419
    77.500  1328.467
    78.000  1332.521
    78.500  1336.580
    79.000  1340.645
    79.500  1344.716
    80.000  1348.792
    80.500  1352.872
    81.000  1356.958
    81.500  1361.048
    82.000  1365.143
    82.500  1369.243
    83.000  1373.346
    83.500  1377.454
    84.000  1381.566
    84.500  1385.682
    85.000  1389.801
    85.500  1393.924
    86.000  1398.050
    86.500  1402.179
    87.000  1406.312
    87.500  1410.447
    88.000  1414.586
    88.500  1418.727
    89.000  1422.870
    89.500  1427.016
    90.000  1431.165
    90.500  1435.315
    91.000  1439.468
    91.500  1443.623
    92.000  1447.779
    92.500  1451.937
    93.000  1456.097
    93.500  1460.258
    94.000  1464.421
    94.500  1468.584
    95.000  1472.749
    95.500  1476.915
    96.000  1481.082
    96.500  1485.249
    97.000  1489.418
    97.500  1493.587
    98.000  1497.756
    98.500  1501.926
    99.000  1506.096
    99.500  1510.266
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    28.500   759.136
    29.000   769.376
    29.500   779.615
    30.000   789.853
    30.500   800.088
    31.000   810.321
    31.500   820.550
    32.000   830.775
    32.500   840.994
    33.000   851.208
    33.500   861.414
    34.000   871.611
    34.500   881.800
    35.000   891.978
    35.500   902.144
    36.000   912.297
    36.500   922.436
    37.000   932.559
    37.500   942.665
    38.000   952.753
    38.500   962.821
    39.000   972.867
    39.500   982.890
    40.000   992.888
    40.500  1002.861
    41.000  1012.805
    41.500  1022.721
    42.000  1032.607
    42.500  1042.461
    43.000  1052.282
    43.500  1062.069
    44.000  1071.820
    44.500  1081.536
    45.000  1091.213
    45.500  1100.180
    46.000  1108.346
    46.500  1116.495
    47.000  1124.628
    47.500  1132.743
    48.000  1140.843
    48.500  1148.926
    49.000  1156.991
    49.500  1165.034
    50.000  1173.050
    50.500  1181.023
    51.000  1188.947
    51.500  1196.861
    52.000  1204.769
    52.500  1212.671
    53.000  1220.568
    53.500  1228.461
    54.000  1236.350
    54.500  1244.235
    55.000  1252.117
    55.500  1259.995
    56.000  1267.870
    56.500  1275.742
    57.000  1283.610
    57.500  1291.475
    58.000  1299.337
    58.500  1307.196
    59.000  1315.051
    59.500  1322.902
    60.000  1330.750
    60.500  1338.593
    61.000  1346.432
    61.500  1354.266
    62.000  1362.095
    62.500  1369.918
    63.000  1377.735
    63.500  1385.546
    64.000  1393.349
    64.500  1401.146
    65.000  1408.936
    65.500  1416.717
    66.000  1424.491
    66.500  1432.256
    67.000  1440.012
    67.500  1447.759
    68.000  1455.498
    68.500  1463.227
    69.000  1470.946
    69.500  1478.656
    70.000  1486.357
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     8.972   125.546     0.150
    11.847   170.747     0.150
    15.595   217.947     0.150
    20.272   273.747     0.150
    25.403   324.747     0.150
    25.403    12.500     0.150
    28.300   350.646     0.150
    30.871   864.747     0.150
    33.422     1.000     0.150
    33.422   716.747     0.150
    33.422   392.747     0.150
    33.422     1.000     0.150
    33.422   716.747     0.150
    35.564   738.647     0.150
    35.564   410.146     0.150
    35.564   738.647     0.150
    35.781   415.847     0.150
    35.781   745.747     0.150
    43.038   474.747     0.150
    43.680   481.546     0.150
    44.488   483.747     0.150
    45.352   494.747     0.150
    46.470     5.200     0.150
    46.470   501.546     0.150
    46.470     5.200     0.150
    47.352   510.647     0.150
    48.962    30.000     0.150
    52.348   542.747     0.150
    52.348   542.747     0.150
    54.092   560.346     0.150
    54.203   562.747     0.150
    54.203   562.747     0.150
    57.214   584.346     0.150
    57.425     4.399     0.150
    57.425  1047.747     0.150
    57.425   583.947     0.150
    57.425     4.399     0.150
    57.425  1047.747     0.150
    58.833  1081.747     0.150
    58.833   593.546     0.150
    58.833  1081.747     0.150
    59.000   593.947     0.150
    58.989   597.747     0.150
    61.080  1101.647     0.150
    63.748   625.747     0.150
    63.748   625.747     0.150
    64.585  1144.747     0.150
    64.585   632.346     0.150
    64.585  1144.747     0.150
    64.880   633.846     0.150
    65.373   637.747     0.150
    65.962  1162.846     0.150
    68.750   658.747     0.150
    69.313   664.247     0.150
    69.477  1200.747     0.150
    69.477   663.247     0.150
    69.477  1200.747     0.150
    69.590   667.247     0.150
    70.422  1212.747     0.150
    70.649   669.747     0.150
    70.661   669.747     0.150
    71.977  1236.747     0.150
    71.977   679.447     0.150
    71.977  1236.747     0.150
    72.135   706.747     0.150
    72.672   684.046     0.150
    72.672  1246.747     0.150
    72.710  1302.747     0.150
    73.599   689.747     0.150
    73.921   691.747     0.150
    73.989   646.747     0.150
    74.034   690.947     0.150
    74.265   691.546     0.150
    74.338   694.747     0.150
    74.505   694.247     0.150
    74.605   695.747     0.150
    74.612   692.747     0.150
    74.612   693.546     0.150
    74.629   694.747     0.150
    75.190   697.747     0.150
    75.190  1272.747     0.150
    75.411   699.247     0.150
    75.428   698.747     0.150
    75.428     1.200     0.150
    76.232   704.247     0.150
    76.326   720.546     0.150
    76.829   716.747     0.150
    76.829   716.747     0.150
    76.897   707.546     0.150
    76.987   736.747     0.150
    77.451  1300.147     0.150
    77.451  1300.147     0.150
    77.569   727.747     0.150
    77.772   710.947     0.150
    78.002   724.747     0.150
    78.002    -3.000     0.150
    78.002     2.000     0.150
    78.067  1301.346     0.150
    78.067   713.747     0.150
    78.067  1301.346     0.150
    78.188   713.747     0.150
    78.881   718.747     0.150
    79.353   736.747     0.150
    79.447   722.046     0.150
    79.659  1326.747     0.150
    79.659  1326.747     0.150
    80.044   726.846     0.150
    80.111   718.747     0.150
    80.414   727.247     0.150
    80.414  1328.747     0.150
    81.312  1341.747     0.150
    81.312   732.747     0.150
    81.312  1341.747     0.150
    81.362  1322.747     0.150
    81.459  1328.747     0.150
    81.996   732.747     0.150
    81.948   719.447     0.150
    81.948   768.546     0.150
    82.144   735.747     0.150
    82.144  1339.747     0.150
    82.944   741.247     0.150
    83.227   741.546     0.150
    83.459   923.747     0.150
    83.496   742.747     0.150
    84.138   743.947     0.150
    84.609   762.747     0.150
   120.883  1212.346     0.150
   155.361  1199.947     0.150
   158.478  1218.346     0.150
    15.519   217.744     0.150
    23.561   311.844     0.150
    23.846   308.344     0.150
    24.524   317.044     0.150
    26.183     8.000     0.150
    26.183   328.344     0.150
    26.183     8.000     0.150
    26.183    17.000     0.150
    26.183   384.344     0.150
    26.183   653.344     0.150
    27.402   363.344     0.150
    30.937   499.344     0.150
    30.937   593.344     0.150
    31.996   374.844     0.150
    32.862   385.344     0.150
    34.885   406.044     0.150
    35.487   410.744     0.150
    35.487    15.000     0.150
    35.721     7.300     0.150
    35.721   414.044     0.150
    35.721     7.300     0.150
    35.721   506.344     0.150
    37.220   426.344     0.150
    38.573    20.300     0.150
    39.284   467.944     0.150
    41.390   592.344     0.150
    43.605   477.844     0.150
    44.411   484.344     0.150
    45.324   496.344     0.150
    46.395   495.344     0.150
    46.395     5.000     0.150
    46.395   495.344     0.150
    46.395     5.000     0.150
    46.395   648.344     0.150
    47.291   912.344     0.150
    54.126   561.344     0.150
    54.881   566.044     0.150
    56.548   563.244     0.150
    57.360   582.844     0.150
    58.922   593.044     0.150
    58.965   585.844     0.150
    63.673   626.344     0.150
    63.673    16.500     0.150
    63.673   667.844     0.150
    64.510   632.444     0.150
    64.510   632.444     0.150
    64.510    16.600     0.150
    68.682   657.344     0.150
    68.682    16.000     0.150
    69.409   662.344     0.150
    69.409    17.000     0.150
    70.652   686.344     0.150
    70.701   687.344     0.150
    71.150   686.844     0.150
    71.899     9.800     0.150
    71.899   680.744     0.150
    71.899     9.800     0.150
    73.871     9.000     0.150
    73.978   689.944     0.150
    74.449   793.344     0.150
    74.449   703.544     0.150
    74.534   694.344     0.150
    74.574   710.344     0.150
    74.574   693.844     0.150
    74.574   710.344     0.150
    74.741   705.844     0.150
    75.112   697.344     0.150
    75.355   698.544     0.150
    75.355   714.344     0.150
    76.176   703.644     0.150
    76.176   720.344     0.150
    76.768   724.344     0.150
    76.927   707.444     0.150
    77.373   708.344     0.150
    77.373   727.344     0.150
    77.714   712.144     0.150
    78.829   718.344     0.150
    79.327   720.344     0.150
    79.373   719.344     0.150
    79.502   721.344     0.150
    79.979   726.344     0.150
    80.343   726.344     0.150
    80.546   729.344     0.150
    81.199   739.844     0.150
    81.218   730.344     0.150
    81.236   732.344     0.150
    81.532   733.344     0.150
    83.153     7.400     0.150
    83.153   741.344     0.150
    83.153     7.400     0.150
    84.010   741.344     0.150
    84.078   735.844     0.150
    86.414     7.000     0.150
   134.063  1164.344     0.150
   141.164  1167.344     0.150
   144.765  1166.744     0.150
    15.823   222.896     0.150
    24.391   317.096     0.150
    25.157   322.896     0.150
    25.240   325.896     0.150
    25.240   368.195     0.150
    25.240   396.795     0.150
    25.401    16.500     0.150
    25.401   322.996     0.150
    25.401    16.500     0.150
    26.541   333.896     0.150
    26.541    13.000     0.150
    26.541   682.896     0.150
    31.664   408.295     0.150
    33.279   397.195     0.150
    33.668   395.896     0.150
    34.582   446.396     0.150
    35.841   414.795     0.150
    36.058   419.896     0.150
    36.058    14.700     0.150
    45.464   498.096     0.150
    46.700   504.896     0.150
    46.700    14.000     0.150
    47.106   529.695     0.150
    51.757   541.896     0.150
    54.169   559.695     0.150
    54.372   562.996     0.150
    56.428   575.295     0.150
    59.262   597.695     0.150
    63.758   626.896     0.150
    63.967   628.896     0.150
    63.967   670.896     0.150
    65.019   635.896     0.150
    72.237   696.496     0.150
    74.615   695.795     0.150
    75.418   701.496     0.150
    75.523   751.896     0.150
    75.556   685.596     0.150
    75.556    19.600     0.150
    75.556   685.596     0.150
    75.556    19.600     0.150
    76.054   705.096     0.150
    76.461   707.396     0.150
    77.117     4.000     0.150
    77.726   714.195     0.150
    78.153   716.896     0.150
    81.327   740.596     0.150
    81.803   736.896     0.150
    82.580   738.695     0.150
    92.961   790.896     0.150
    15.908   225.656     0.150
    24.236   315.957     0.150
    25.476   324.457     0.150
    26.611   336.457     0.150
    35.918   415.855     0.150
    37.156   426.957     0.150
    46.525   506.059     0.150
    46.525   508.758     0.150
    46.785   506.457     0.150
    64.053   630.457     0.150
    65.100   637.855     0.150
    68.704   661.258     0.150
    72.319   684.457     0.150
    72.319   707.457     0.150
    73.121   748.957     0.150
    74.217   694.656     0.150
    74.807   698.457     0.150
    74.807   707.457     0.150
    75.703   703.156     0.150
    76.261   705.656     0.150
    78.456   719.559     0.150
    81.889   721.457     0.150
    81.889   721.457     0.150
    82.628   728.656     0.150
    92.943   800.656     0.150
   147.853  1186.457     0.150
    16.005   224.414     0.150
    16.005   224.414     0.150
    18.266   247.414     0.150
    19.798   270.914     0.150
    24.265   317.914     0.150
    24.939   323.414     0.150
    25.315   608.414     0.150
    25.634   327.414     0.150
    25.634   371.414     0.150
    25.634   378.914     0.150
    26.781   337.914     0.150
    26.781   385.414     0.150
    26.781   696.414     0.150
    26.799     3.102     0.150
    26.799   338.414     0.150
    26.799     3.102     0.150
    26.799   399.613     0.150
    27.337   346.715     0.150
    27.843   349.715     0.150
    28.297   362.414     0.150
    28.830   360.215     0.150
    30.346  1068.414     0.150
    31.318   409.414     0.150
    31.318   471.914     0.150
    31.318   500.914     0.150
    31.318   908.414     0.150
    31.941   385.414     0.150
    33.316   402.414     0.150
    33.866   399.414     0.150
    33.866   721.414     0.150
    34.343   726.414     0.150
    34.343   405.914     0.150
    34.343   496.414     0.150
    34.343   726.414     0.150
    35.104   433.414     0.150
    36.071   748.414     0.150
    36.071   417.613     0.150
    36.071   494.414     0.150
    36.071   514.812     0.150
    36.071   748.414     0.150
    36.071  1030.613     0.150
    38.811   446.812     0.150
    44.201   487.215     0.150
    44.394   493.113     0.150
    44.746   492.414     0.150
    44.746   642.414     0.150
    44.746   886.414     0.150
    44.995   491.715     0.150
    45.312   613.414     0.150
    45.312   496.430     0.150
    45.540   499.016     0.150
    46.571   510.414     0.150
    46.882   508.016     0.150
    46.882   935.414     0.150
    47.883     6.199     0.150
    49.020   524.414     0.150
    49.899   471.516     0.150
    50.223   960.414     0.150
    50.351   960.414     0.150
    52.857   553.414     0.150
    52.857  1001.414     0.150
    53.316   999.414     0.150
    54.604   567.414     0.150
    54.604   688.414     0.150
    54.709   578.414     0.150
    54.709   578.414     0.150
    54.746   568.516     0.150
    55.495  1052.414     0.150
    55.790   776.414     0.150
    55.790   840.414     0.150
    55.790  1128.414     0.150
    55.790  1248.414     0.150
    55.790  1296.414     0.150
    57.693  1062.414     0.150
    57.693   587.812     0.150
    57.693   645.414     0.150
    57.693   799.414     0.150
    57.693  1062.414     0.150
    57.693  1086.414     0.150
    57.738   712.914     0.150
    58.344  1077.414     0.150
    58.344  1077.414     0.150
    58.344  1179.414     0.150
    59.190  1087.414     0.150
    59.230  1330.414     0.150
    59.297   599.414     0.150
    59.475   601.715     0.150
    59.475  1091.414     0.150
    59.840  1189.414     0.150
    59.840  3493.414     0.150
    61.330   828.414     0.150
    61.330  1108.414     0.150
    61.330  1344.414     0.150
    61.851  1111.414     0.150
    61.876   618.414     0.150
    61.876  1123.414     0.150
    62.864   623.715     0.150
    63.826   911.414     0.150
    63.962   632.812     0.150
    63.968  1139.215     0.150
    63.968   631.016     0.150
    63.968  1139.215     0.150
    63.968  1171.414     0.150
    64.140  1143.414     0.150
    64.140   633.414     0.150
    64.140   871.414     0.150
    64.140  1143.414     0.150
    64.140  1180.414     0.150
    64.603   628.016     0.150
    64.603 -1242.688     0.150
    64.971  1154.414     0.150
    64.971   637.914     0.150
    64.971   677.414     0.150
    64.971   784.414     0.150
    64.971   873.414     0.150
    64.971  1154.414     0.150
    65.119   638.914     0.150
    65.421   640.715     0.150
    65.638     4.000     0.150
    65.638  1160.414     0.150
    65.638   642.414     0.150
    65.638     4.000     0.150
    65.638   880.414     0.150
    65.638  1160.414     0.150
    65.638  1198.414     0.150
    65.638  1588.414     0.150
    66.462  1176.414     0.150
    68.857   657.914     0.150
    69.002  1259.414     0.150
    69.053   663.414     0.150
    69.053   684.414     0.150
    69.053   916.414     0.150
    69.053  1204.414     0.150
    69.053  1248.414     0.150
    69.087  1660.414     0.150
    69.776  1208.414     0.150
    69.776   668.215     0.150
    69.776  1208.414     0.150
    69.814   830.414     0.150
    69.814  1208.414     0.150
    69.814  1282.414     0.150
    69.814  1536.414     0.150
    69.827  1219.414     0.150
    70.740   844.414     0.150
    70.740   936.414     0.150
    70.740  1710.414     0.150
    71.023   676.414     0.150
    71.023   944.414     0.150
    71.023  1229.414     0.150
    71.023  1264.414     0.150
    71.023  1696.414     0.150
    71.211   678.414     0.150
    71.211   938.414     0.150
    71.211  1234.414     0.150
    71.335   680.414     0.150
    71.335   940.414     0.150
    71.335  1237.414     0.150
    71.315   681.715     0.150
    71.323   673.414     0.150
    71.324   674.414     0.150
    71.407   688.324     0.150
    72.026   694.414     0.150
    72.254   689.414     0.150
    72.449  1246.414     0.150
    72.449   686.414     0.150
    72.449   705.414     0.150
    72.449   944.414     0.150
    72.449  1246.414     0.150
    72.546   689.215     0.150
    72.846  1548.414     0.150
    72.846  1752.414     0.150
    73.002   686.914     0.150
    73.151   688.414     0.150
    73.151   688.414     0.150
    73.151  1253.414     0.150
    74.050  1312.414     0.150
    74.126   714.414     0.150
    74.126    33.000     0.150
    74.126   962.414     0.150
    74.213  1322.414     0.150
    74.213  2030.414     0.150
    74.213  2557.414     0.150
    74.213   695.414     0.150
    74.213    10.000     0.150
    74.213  1265.414     0.150
    74.690   698.414     0.150
    74.690  1272.414     0.150
    74.769   870.414     0.150
    74.800   863.414     0.150
    74.800  1273.414     0.150
    74.800  1288.414     0.150
    74.800  1788.414     0.150
    74.800   698.914     0.150
    74.800   698.914     0.150
    74.800   868.414     0.150
    74.800  1273.414     0.150
    74.800  1313.414     0.150
    74.800  1553.414     0.150
    74.800  1788.414     0.150
    74.800   698.914     0.150
    74.800  1273.414     0.150
    74.820   700.414     0.150
    74.751   704.715     0.150
    75.001  1288.414     0.150
    75.083   701.715     0.150
    75.083  1278.812     0.150
    75.083  1329.016     0.150
    75.599  1598.414     0.150
    75.599   704.016     0.150
    75.599  1283.414     0.150
    75.646  1294.414     0.150
    75.646   703.613     0.150
    75.646     4.500     0.150
    75.650   704.914     0.150
    75.650   704.914     0.150
    75.650   872.414     0.150
    75.650  1282.914     0.150
    75.650  1335.414     0.150
    75.668   704.113     0.150
    75.570   713.414     0.150
    75.570  1292.414     0.150
    75.839  1291.414     0.150
    75.839   705.414     0.150
    75.839  1291.414     0.150
    76.280   702.414     0.150
    76.414  1292.414     0.150
    76.462   698.414     0.150
    76.882   708.414     0.150
    77.061     5.199     0.150
    77.061   711.914     0.150
    77.061     5.199     0.150
    77.061   890.414     0.150
    77.061  1296.414     0.150
    77.365     0.199     0.150
    77.365   714.016     0.150
    77.365     0.199     0.150
    77.365  1004.812     0.150
    77.365  1299.215     0.150
    77.365  1362.812     0.150
    77.471   854.812     0.150
    77.471   714.613     0.150
    77.471  1330.414     0.150
    77.511   715.215     0.150
    77.511  1292.414     0.150
    77.724   754.414     0.150
    77.876   772.914     0.150
    77.876   717.215     0.150
    77.876  1307.613     0.150
    77.907  1304.414     0.150
    77.907   717.215     0.150
    77.907   889.414     0.150
    77.907  1304.414     0.150
    77.998   725.414     0.150
    78.271   719.215     0.150
    78.271   894.414     0.150
    78.271   999.414     0.150
    78.271  1311.414     0.150
    78.271  1370.812     0.150
    78.271  1616.812     0.150
    78.301   719.312     0.150
    78.301  1310.812     0.150
    78.451     2.000     0.150
    78.451  1320.016     0.150
    78.457   718.414     0.150
    78.457  1310.414     0.150
    78.535   720.414     0.150
    78.535  1315.715     0.150
    79.469  1320.414     0.150
    79.538   749.613     0.150
    79.794   727.414     0.150
    79.794  1020.414     0.150
    79.794  1326.414     0.150
    79.794  1392.414     0.150
    79.800   730.414     0.150
    79.809   728.215     0.150
    79.838   725.312     0.150
    79.838  1624.414     0.150
    79.838  1854.414     0.150
    79.851  1026.414     0.150
    79.851  1387.914     0.150
    79.851  1640.414     0.150
    80.018   728.414     0.150
    80.018  1331.414     0.150
    80.018  1336.414     0.150
    80.018  1389.414     0.150
    80.029  1331.414     0.150
    80.029   728.914     0.150
    80.029  1023.414     0.150
    80.029  1331.414     0.150
    80.073   728.414     0.150
    80.073   904.414     0.150
    80.073  1016.414     0.150
    80.073  1328.414     0.150
    80.073  1392.414     0.150
    80.745   732.414     0.150
    80.745  1027.914     0.150
    80.745  1336.414     0.150
    80.896  1030.414     0.150
    80.896  1672.414     0.150
    80.896  1872.414     0.150
    80.919   736.613     0.150
    81.622  1347.414     0.150
    81.729   738.914     0.150
    81.729  1349.914     0.150
    81.729  1414.414     0.150
    81.957   739.414     0.150
    81.957  1353.414     0.150
    82.162   741.215     0.150
    82.162  1043.414     0.150
    82.162  1356.414     0.150
    82.162  1417.414     0.150
    82.232   740.016     0.150
    82.232   740.414     0.150
    82.232  1352.414     0.150
    82.513  1356.414     0.150
    82.513   742.414     0.150
    82.513  1356.414     0.150
    82.522   737.215     0.150
    82.781   737.613     0.150
    82.836   744.414     0.150
    82.836  1048.414     0.150
    82.836  1362.414     0.150
    82.929   742.812     0.150
    83.178   757.414     0.150
    83.304   746.914     0.150
    83.361   749.414     0.150
    83.515  1064.414     0.150
    83.515  1708.414     0.150
    83.515  1973.414     0.150
    83.598   747.613     0.150
    83.598  1053.414     0.150
    83.598  1369.414     0.150
    83.598  1438.414     0.150
    83.586  1360.414     0.150
    83.728    13.898     0.150
    83.728   766.414     0.150
    83.723   936.414     0.150
    83.830   751.914     0.150
    85.348   933.914     0.150
    85.622  1364.414     0.150
    86.388  1752.414     0.150
    86.388  2131.414     0.150
    86.500   769.574     0.150
    87.224   980.414     0.150
    87.599  1391.414     0.150
    87.599  2159.414     0.150
    87.599  2159.414     0.150
    88.737    20.000     0.150
    90.006  1457.414     0.150
    90.006  1518.414     0.150
    90.006  1718.414     0.150
    90.327   777.414     0.150
    90.327  1347.414     0.150
    91.786   785.215     0.150
    92.892   812.414     0.150
    92.892   986.914     0.150
    92.892  1010.914     0.150
    92.892  1136.414     0.150
    92.892  1436.414     0.150
    92.892  1540.414     0.150
    92.892  1578.414     0.150
    92.892  1834.414     0.150
    92.892  2060.414     0.150
    93.084   962.414     0.150
    94.211  1427.414     0.150
    94.667   804.215     0.150
    98.066   828.414     0.150
    99.225   839.414     0.150
    99.623  1056.414     0.150
    99.623  1195.414     0.150
    99.623  1476.414     0.150
    99.623  1645.414     0.150
    99.623  2150.414     0.150
   100.844  1456.414     0.150
   100.727   842.414     0.150
   102.173   854.414     0.150
   103.947  1479.414     0.150
   104.266   851.914     0.150
   109.439   870.414     0.150
   113.884  1120.312     0.150
   121.087  1204.414     0.150
   121.087  1215.914     0.150
   121.087  1742.613     0.150
   121.485  1134.715     0.150
   121.485  1298.113     0.150
   123.564  1913.613     0.150
   129.218  2318.414     0.150
   133.874  1141.113     0.150
   140.225  1160.516     0.150
   141.569  1164.414     0.150
   144.487  1833.613     0.150
   144.628  2122.414     0.150
   144.968  1368.516     0.150
   147.847  1174.414     0.150
   147.847  1177.914     0.150
   163.405  1197.414     0.150
   163.405  2704.414     0.150
    11.713   166.672     0.150
    24.358   315.672     0.150
    25.515   323.969     0.150
    26.673    14.000     0.150
    26.673   336.672     0.150
    26.673    14.000     0.150
    26.673   677.672     0.150
    28.368   366.172     0.150
    29.050   361.070     0.150
    31.393   392.773     0.150
    32.457   390.773     0.150
    33.723   395.672     0.150
    33.723   395.672     0.150
    34.106   411.672     0.150
    35.399   410.672     0.150
    35.948   414.672     0.150
    35.948   414.672     0.150
    35.947   422.672     0.150
    36.709   434.672     0.150
    37.321   438.672     0.150
    43.499   481.672     0.150
    45.466   909.672     0.150
    46.734   504.273     0.150
    46.734     7.398     0.150
    54.484   564.672     0.150
    57.660   581.773     0.150
    59.339   598.570     0.150
    61.741   615.672     0.150
    62.715   621.969     0.150
    63.830   627.672     0.150
    63.990   629.672     0.150
    63.990   629.672     0.150
    63.990    12.602     0.150
    64.459   625.969     0.150
    64.821   635.672     0.150
    64.821    11.000     0.150
    64.837   656.172     0.150
    64.970   633.672     0.150
    64.970   635.469     0.150
    65.276   637.875     0.150
    68.901   673.672     0.150
    68.901   673.672     0.150
    69.624   665.672     0.150
    70.873   673.672     0.150
    74.069   692.773     0.150
    74.545   695.672     0.150
    74.545    12.000     0.150
    74.657   696.672     0.150
    74.657    12.000     0.150
    74.657   696.672     0.150
    74.657    12.000     0.150
    74.945   698.672     0.150
    75.454   701.469     0.150
    75.510   701.672     0.150
    75.533   701.469     0.150
    76.321   706.070     0.150
    76.912    14.602     0.150
    78.306   715.672     0.150
    79.954   723.672     0.150
    80.755   726.672     0.150
    81.147   733.469     0.150
    81.857   734.172     0.150
    84.897   753.672     0.150
   144.716  1170.672     0.150
    11.933   169.203     0.150
    15.980   225.504     0.150
    18.200   245.305     0.150
    24.242   318.305     0.150
    24.457   318.305     0.150
    24.892   322.305     0.150
    25.638   325.805     0.150
    25.638   381.805     0.150
    25.638   658.805     0.150
    26.792     9.000     0.150
    26.792   338.305     0.150
    26.792     9.000     0.150
    26.834   338.906     0.150
    27.309   345.605     0.150
    28.267   361.805     0.150
    28.802   358.805     0.150
    29.550   372.504     0.150
    31.290   388.703     0.150
    31.916   393.703     0.150
    31.942   394.305     0.150
    32.206   388.906     0.150
    32.206   397.105     0.150
    32.354   397.504     0.150
    33.848   398.305     0.150
    33.848    15.000     0.150
    33.848   720.305     0.150
    35.287   422.305     0.150
    35.293   417.305     0.150
    35.842   427.305     0.150
    36.072   737.305     0.150
    36.072   416.805     0.150
    36.072    15.500     0.150
    36.072   737.305     0.150
    37.068   425.805     0.150
    43.282   478.305     0.150
    44.209   485.305     0.150
    44.776   491.305     0.150
    44.996   492.105     0.150
    46.857   506.305     0.150
    46.857    11.000     0.150
    52.859    23.000     0.150
    52.859   552.305     0.150
    52.859    23.000     0.150
    54.709   567.203     0.150
    57.714   588.305     0.150
    59.283  1074.504     0.150
    59.283   598.504     0.150
    59.283  1074.504     0.150
    59.263  1088.305     0.150
    59.465   600.305     0.150
    59.465  1094.305     0.150
    61.867   617.305     0.150
    61.867  1118.805     0.150
    62.817   622.203     0.150
    63.956   629.906     0.150
    63.956    11.199     0.150
    64.941   637.004     0.150
    64.941    11.301     0.150
    65.071   634.305     0.150
    68.802   662.805     0.150
    68.802   675.305     0.150
    69.011   662.305     0.150
    69.011    11.000     0.150
    69.734   666.305     0.150
    69.734    12.000     0.150
    70.146   684.105     0.150
    70.393   682.504     0.150
    70.410   682.605     0.150
    70.977   676.305     0.150
    70.951  1231.305     0.150
    71.326   677.305     0.150
    72.438   684.305     0.150
    74.159   693.105     0.150
    74.637     5.199     0.150
    74.637   697.004     0.150
    74.637    12.199     0.150
    74.746   704.305     0.150
    74.746   697.805     0.150
    74.746   704.305     0.150
    74.746   697.805     0.150
    74.746    12.000     0.150
    74.812   699.305     0.150
    75.071   699.305     0.150
    75.546     5.898     0.150
    75.546   762.305     0.150
    75.546   702.504     0.150
    75.596  3307.305     0.150
    75.596   702.203     0.150
    75.596   714.703     0.150
    75.609   702.406     0.150
    75.635   702.305     0.150
    76.230  3309.305     0.150
    76.230  3312.203     0.150
    76.360   706.805     0.150
    76.360    12.500     0.150
    77.012    21.898     0.150
    77.012   710.305     0.150
    77.012   716.305     0.150
    77.012    21.898     0.150
    77.330   713.305     0.150
    77.419   752.703     0.150
    77.419   713.105     0.150
    77.419    12.199     0.150
    77.671   713.305     0.150
    77.671    16.000     0.150
    77.825   715.305     0.150
    77.825    12.801     0.150
    77.891   716.105     0.150
    78.164   716.105     0.150
    78.164   716.105     0.150
    78.260   718.305     0.150
    78.398   724.504     0.150
    78.398    12.102     0.150
    78.398    14.500     0.150
    78.398   752.805     0.150
    78.412   716.305     0.150
    78.523   718.805     0.150
    79.297   724.305     0.150
    79.469   755.805     0.150
    79.469   878.105     0.150
    79.649   724.305     0.150
    79.751   734.305     0.150
    79.985   727.305     0.150
    80.031   727.305     0.150
    80.031  1025.305     0.150
    80.057   738.305     0.150
    80.243   729.805     0.150
    81.234   734.805     0.150
    81.301   733.105     0.150
    81.922   726.305     0.150
    81.922   726.305     0.150
    81.922   738.305     0.150
    82.140   739.805     0.150
    82.180   736.805     0.150
    82.481   741.305     0.150
    82.547   735.105     0.150
    82.802   749.305     0.150
    83.112   746.805     0.150
    83.566    24.801     0.150
    83.566   746.703     0.150
    83.566    24.801     0.150
    84.990   750.305     0.150
    85.807   759.805     0.150
    86.021   760.805     0.150
    86.359   760.805     0.150
    92.899   795.504     0.150
    92.899     9.000     0.150
   121.035  1217.605     0.150
   140.186  1159.305     0.150
   140.186  1335.906     0.150
   144.537  1215.305     0.150
   144.694  1176.305     0.150
   161.360  1208.305     0.150
    10.274   144.484     0.150
    15.598   222.688     0.150
    15.967   226.688     0.150
    18.293   247.688     0.150
    19.863   280.688     0.150
    24.359    13.000     0.150
    24.359   315.688     0.150
    24.359    13.000     0.150
    24.359   613.688     0.150
    25.005   323.688     0.150
    25.577   325.688     0.150
    25.577   360.086     0.150
    25.577   378.086     0.150
    25.382   339.688     0.150
    26.720    17.000     0.150
    26.720    16.797     0.150
    26.720   373.688     0.150
    26.720   393.688     0.150
    26.720   684.688     0.150
    26.732    11.500     0.150
    26.732   393.688     0.150
    27.403   336.188     0.150
    27.403    16.703     0.150
    27.403    27.602     0.150
    28.363    18.094     0.150
    29.047   368.086     0.150
    29.431   368.688     0.150
    29.645   372.586     0.150
    30.400   379.789     0.150
    30.412   380.086     0.150
    30.412     4.398     0.150
    30.412   453.688     0.150
    30.412   480.688     0.150
    30.412   685.688     0.150
    30.601   381.289     0.150
    30.960   382.188     0.150
    31.123   386.391     0.150
    31.384    17.203     0.150
    32.006     6.898     0.150
    32.006    17.297     0.150
    32.304    18.102     0.150
    32.447    17.398     0.150
    33.823    17.000     0.150
    33.823   398.688     0.150
    33.823     9.000     0.150
    33.823    17.000     0.150
    33.823   489.688     0.150
    33.823   566.688     0.150
    34.104   408.688     0.150
    34.473    17.000     0.150
    35.170    17.000     0.150
    35.379   435.688     0.150
    35.379   505.688     0.150
    36.016   415.984     0.150
    36.016   748.086     0.150
    36.016   415.984     0.150
    36.016   513.688     0.150
    36.016   748.086     0.150
    36.016   921.484     0.150
    35.934   427.688     0.150
    36.695    18.000     0.150
    38.052   443.688     0.150
    43.306   850.688     0.150
    43.306   478.688     0.150
    43.306   850.688     0.150
    44.142   487.688     0.150
    44.142   487.688     0.150
    44.680   496.688     0.150
    44.680   496.688     0.150
    44.680   882.688     0.150
    45.012   493.688     0.150
    45.336   503.688     0.150
    45.336   905.688     0.150
    45.336   503.688     0.150
    45.336   905.688     0.150
    45.443   906.688     0.150
    46.503   858.688     0.150
    46.565   515.484     0.150
    46.845   505.891     0.150
    46.845     7.797     0.150
    46.845   665.688     0.150
    50.158   980.688     0.150
    51.522   565.688     0.150
    51.652   552.688     0.150
    52.801    18.000     0.150
    52.801   982.688     0.150
    52.801   550.688     0.150
    52.801    10.398     0.150
    52.801    18.000     0.150
    52.801   982.688     0.150
    52.658   559.688     0.150
    52.845   561.688     0.150
    54.547   565.688     0.150
    54.547   695.688     0.150
    54.547  1144.688     0.150
    54.654   565.688     0.150
    55.778   715.688     0.150
    55.778  1043.688     0.150
    55.778  1111.688     0.150
    55.778  1295.688     0.150
    55.778  1407.688     0.150
    55.778   573.344     0.150
    57.218   593.688     0.150
    57.665   577.688     0.150
    57.665    19.000     0.150
    57.665   577.688     0.150
    57.665    19.000     0.150
    57.678    21.398     0.150
    57.678    21.000     0.150
    57.678   650.086     0.150
    57.678  1072.688     0.150
    57.673    16.297     0.150
    58.282  1077.688     0.150
    59.163  1093.688     0.150
    59.163  1105.688     0.150
    59.427   600.086     0.150
    59.427  1096.688     0.150
    59.296   601.086     0.150
    59.313   602.188     0.150
    59.774   600.688     0.150
    61.317  1119.688     0.150
    61.317  1191.688     0.150
    61.317  1355.688     0.150
    61.317  1395.688     0.150
    61.827   616.688     0.150
    61.842  1124.688     0.150
    62.852   622.789     0.150
    63.445   637.688     0.150
    63.921    18.703     0.150
    63.921   629.688     0.150
    63.921     9.797     0.150
    63.921    18.703     0.150
    63.921  1150.586     0.150
    64.106   630.688     0.150
    64.106   630.984     0.150
    64.106  1152.688     0.150
    64.106  1177.688     0.150
    64.404   631.086     0.150
    64.732   647.688     0.150
    64.873   765.688     0.150
    64.873  1163.688     0.150
    64.937    19.000     0.150
    64.937   636.688     0.150
    64.937     9.500     0.150
    64.937    19.000     0.150
    64.937  1157.688     0.150
    65.108  1163.688     0.150
    65.108  1373.688     0.150
    65.108  1455.688     0.150
    65.108   637.586     0.150
    65.318   710.688     0.150
    65.318   252.602     0.150
    65.623   661.688     0.150
    65.623   640.688     0.150
    65.623    13.000     0.150
    65.623   661.688     0.150
    65.623  1175.688     0.150
    66.408   648.586     0.150
    68.676   661.688     0.150
    68.938  1215.688     0.150
    69.032   661.688     0.150
    69.032    13.000     0.150
    69.032   683.688     0.150
    69.032  1243.688     0.150
    69.756   666.086     0.150
    69.756     9.102     0.150
    69.756  1230.688     0.150
    69.756  1255.688     0.150
    69.901   678.688     0.150
    69.901  1231.688     0.150
    70.128   679.688     0.150
    70.377   680.688     0.150
    70.393   680.688     0.150
    70.753   683.688     0.150
    70.753   960.688     0.150
    70.753  1545.688     0.150
    70.841   682.688     0.150
    70.841  1233.688     0.150
    71.009   676.688     0.150
    71.009     9.000     0.150
    71.091   696.688     0.150
    71.226   676.188     0.150
    71.285  1231.688     0.150
    72.401   684.688     0.150
    72.401     9.000     0.150
    72.401   704.188     0.150
    72.287  1287.688     0.150
    72.452   703.688     0.150
    72.849   695.688     0.150
    72.849   707.688     0.150
    72.849  1275.688     0.150
    72.849  1311.688     0.150
    72.849   695.688     0.150
    72.849   707.688     0.150
    72.849  1275.688     0.150
    73.110   688.688     0.150
    73.110     9.000     0.150
    74.054  1312.688     0.150
    74.062   692.688     0.150
    74.062  1267.688     0.150
    74.062  1295.688     0.150
    74.210   715.586     0.150
    74.210  1327.688     0.150
    74.210   694.391     0.150
    74.210   715.586     0.150
    74.241   694.688     0.150
    74.241    10.000     0.150
    74.686   697.289     0.150
    74.686     9.398     0.150
    74.770   697.688     0.150
    74.798  1290.688     0.150
    74.798  1335.688     0.150
    74.798   697.688     0.150
    74.798  1281.688     0.150
    74.798  1335.688     0.150
    74.798  1575.688     0.150
    74.798  1815.688     0.150
    74.798   697.688     0.150
    74.798     9.500     0.150
    74.953   892.688     0.150
    75.035  1327.688     0.150
    75.143   699.984     0.150
    75.031   693.086     0.150
    75.429  1203.688     0.150
    75.604   702.688     0.150
    75.604   878.688     0.150
    75.604  1332.688     0.150
    75.595   768.188     0.150
    75.595  1297.688     0.150
    75.595   702.891     0.150
    75.595     9.398     0.150
    75.595  1297.688     0.150
    75.638  1297.688     0.150
    75.638   702.484     0.150
    75.638     9.703     0.150
    75.638   714.688     0.150
    75.638  1297.688     0.150
    75.675   702.789     0.150
    75.724   704.484     0.150
    75.828   703.688     0.150
    75.579   711.688     0.150
    76.369   889.688     0.150
    76.410   765.688     0.150
    76.410   707.688     0.150
    76.506   755.789     0.150
    77.318   711.984     0.150
    77.318   711.984     0.150
    77.318  1307.984     0.150
    77.051    19.000     0.150
    77.051   899.688     0.150
    77.051  1309.688     0.150
    77.465    25.500     0.150
    77.465   713.484     0.150
    77.465   723.086     0.150
    77.508   713.789     0.150
    77.456   719.688     0.150
    77.720   713.688     0.150
    77.720    13.000     0.150
    77.862   715.688     0.150
    77.862   895.688     0.150
    77.862  1002.688     0.150
    77.862  1318.688     0.150
    77.869   715.688     0.150
    77.869     9.898     0.150
    77.869  1323.688     0.150
    78.223   718.086     0.150
    78.223   901.688     0.150
    78.223  1320.086     0.150
    78.223  1609.688     0.150
    78.254   717.391     0.150
    78.441   716.688     0.150
    78.441   726.688     0.150
    78.441  1317.688     0.150
    78.488  1322.984     0.150
    78.488  1366.984     0.150
    78.448     9.703     0.150
    78.448    14.203     0.150
    78.824   740.688     0.150
    79.408  1327.688     0.150
    79.525   725.688     0.150
    79.534   833.688     0.150
    79.767   725.688     0.150
    79.767  1379.688     0.150
    79.789   727.688     0.150
    79.742   736.688     0.150
    79.742   760.688     0.150
    79.829   734.688     0.150
    79.829   735.086     0.150
    79.829  1338.688     0.150
    79.957   731.688     0.150
    79.989   734.688     0.150
    79.989   734.688     0.150
    79.989  1359.688     0.150
    79.979   735.688     0.150
    79.999   737.688     0.150
    79.999   737.688     0.150
    80.053   735.688     0.150
    80.053   735.688     0.150
    80.053    16.000     0.150
    80.053   915.688     0.150
    80.074   726.688     0.150
    80.720    11.602     0.150
    81.004   722.688     0.150
    81.299   745.188     0.150
    81.299   932.688     0.150
    81.819   746.688     0.150
    81.929   738.289     0.150
    81.929     9.398     0.150
    81.998   739.688     0.150
    82.122   739.688     0.150
    82.122     9.000     0.150
    82.122  1393.688     0.150
    82.122  1418.688     0.150
    82.193    22.203     0.150
    82.193   739.484     0.150
    82.193     9.203     0.150
    82.193    22.203     0.150
    82.049   746.188     0.150
    82.338   735.688     0.150
    82.483   741.688     0.150
    82.483  1351.688     0.150
    82.293   750.391     0.150
    82.726   730.688     0.150
    82.808   752.688     0.150
    82.808   752.688     0.150
    82.808     9.000     0.150
    83.111   739.688     0.150
    83.163   746.188     0.150
    83.275   755.688     0.150
    83.275   755.688     0.150
    83.205   754.188     0.150
    83.567  1357.891     0.150
    83.567   745.688     0.150
    83.567    12.000     0.150
    83.567  1051.891     0.150
    83.567  1357.891     0.150
    83.528  1075.688     0.150
    83.528  1351.688     0.150
    83.528  1715.688     0.150
    83.604   756.484     0.150
    83.668   951.688     0.150
    83.719   728.688     0.150
    83.827   731.688     0.150
    83.738   755.688     0.150
    84.687   763.484     0.150
    84.808   747.984     0.150
    84.623   760.688     0.150
    85.125   751.688     0.150
    85.633   767.688     0.150
    85.732   766.188     0.150
    85.817   755.484     0.150
    86.433  1402.984     0.150
    86.404   769.688     0.150
    86.404   785.688     0.150
    86.404   980.688     0.150
    86.404  1411.688     0.150
    86.404  1595.688     0.150
    86.404  1765.688     0.150
    86.404  2165.688     0.150
    86.514   770.688     0.150
    86.514   973.688     0.150
    86.514  1480.688     0.150
    87.477   784.688     0.150
    87.477   992.688     0.150
    87.555  1775.688     0.150
    87.555  2183.688     0.150
    87.555  1775.688     0.150
    87.555  2183.688     0.150
    89.976   788.188     0.150
    90.788   790.688     0.150
    90.960   791.688     0.150
    90.960   975.688     0.150
    91.719   783.688     0.150
    91.719    15.703     0.150
    92.833  1021.688     0.150
    92.833  1431.688     0.150
    92.833  1541.688     0.150
    92.833  1549.688     0.150
    92.833  1837.688     0.150
    92.948  1431.688     0.150
    93.031   996.688     0.150
    94.021   804.688     0.150
    94.155   813.688     0.150
    94.155  1437.688     0.150
    95.273   809.688     0.150
    96.663   818.688     0.150
    99.563   832.688     0.150
    99.563  1467.688     0.150
    99.563  1583.688     0.150
    99.563  1623.688     0.150
    99.563  1893.688     0.150
   121.081  1214.484     0.150
   121.081  1227.289     0.150
   125.073  1111.688     0.150
   133.872  1145.688     0.150
   141.544  1161.688     0.150
   150.490  1641.188     0.150
   153.129  1632.688     0.150
   157.706  1219.391     0.150
   157.706  1593.484     0.150
   158.677  1201.688     0.150
   158.677  1241.188     0.150
   163.425  1200.688     0.150
   163.425  1200.688     0.150
   163.425  1483.688     0.150
     6.860   101.986     0.150
    15.832   224.188     0.150
    24.106   558.387     0.150
    24.106   313.387     0.150
    24.106   558.387     0.150
    25.256   324.387     0.150
    25.362    19.801     0.150
    25.362   584.787     0.150
    25.362    19.301     0.150
    25.362   370.387     0.150
    25.362   584.787     0.150
    26.491   590.387     0.150
    26.491   378.387     0.150
    26.491   590.387     0.150
    33.666   396.387     0.150
    33.666    18.000     0.150
    34.436   412.387     0.150
    34.678   406.887     0.150
    34.724   417.387     0.150
    35.807   414.688     0.150
    35.807    17.398     0.150
    36.839   432.387     0.150
    36.945   446.387     0.150
    37.555   439.387     0.150
    38.303   445.387     0.150
    39.075   448.787     0.150
    41.703   471.387     0.150
    42.785     6.500     0.150
    43.770     6.301     0.150
    43.917   484.188     0.150
    44.428   477.387     0.150
    46.709   504.688     0.150
    46.709    12.699     0.150
    52.590   548.387     0.150
    54.333  1024.387     0.150
    59.086   602.586     0.150
    61.276   613.387     0.150
    62.814   622.086     0.150
    63.744   627.387     0.150
    63.982   629.387     0.150
    63.982    10.199     0.150
    65.072   636.986     0.150
    65.408   576.887     0.150
    67.717   652.086     0.150
    68.714   661.486     0.150
    69.688   665.486     0.150
    72.222   682.986     0.150
    74.206   692.387     0.150
    74.422   694.586     0.150
    74.680   695.986     0.150
    74.798   697.387     0.150
    74.798   697.387     0.150
    74.858   698.387     0.150
    76.134   704.188     0.150
    77.019   710.387     0.150
    78.042  1296.986     0.150
    78.042   716.387     0.150
    78.042  1296.986     0.150
    78.230   716.387     0.150
    78.279   716.287     0.150
    78.444   718.986     0.150
    80.489   726.188     0.150
    80.887   728.387     0.150
    81.829   736.887     0.150
   144.859  1172.986     0.150
    14.055   193.930     0.150
    15.370   209.328     0.150
    15.785   221.328     0.150
    18.332   246.828     0.150
    24.121   313.328     0.150
    25.220   323.625     0.150
    26.311    30.000     0.150
    26.481   335.328     0.150
    26.481     9.000     0.150
    26.481   387.328     0.150
    28.602   356.430     0.150
    32.542   380.328     0.150
    33.625   707.328     0.150
    33.625   707.328     0.150
    35.411   424.328     0.150
    35.786   744.328     0.150
    35.786   414.727     0.150
    35.786   489.328     0.150
    35.786   514.328     0.150
    35.786   744.328     0.150
    35.626   426.328     0.150
    35.993   417.328     0.150
    35.993    13.000     0.150
    36.175   424.328     0.150
    37.547   437.328     0.150
    43.182    24.000     0.150
    43.182   476.328     0.150
    43.182    24.000     0.150
    43.182   858.328     0.150
    44.441   485.328     0.150
    44.771   893.328     0.150
    45.363     7.102     0.150
    46.662   503.625     0.150
    46.662   909.328     0.150
    47.169    23.805     0.150
    47.435   512.031     0.150
    48.762   526.227     0.150
    52.570    22.000     0.150
    52.570   549.328     0.150
    52.570    14.797     0.150
    52.570    22.000     0.150
    52.570  1000.031     0.150
    52.811   551.328     0.150
    54.315   562.727     0.150
    54.315  1018.328     0.150
    54.315  1150.328     0.150
    57.562   579.328     0.150
    57.562   579.930     0.150
    58.040  1064.328     0.150
    58.884  1081.828     0.150
    59.042  1078.531     0.150
    59.042  1078.531     0.150
    59.213  1081.328     0.150
    59.213   597.328     0.150
    59.213  1081.328     0.150
    59.535   598.328     0.150
    61.612   613.328     0.150
    61.612   613.328     0.150
    61.612  1113.328     0.150
    63.198   625.828     0.150
    63.198  1137.328     0.150
    63.710    18.203     0.150
    63.710    18.000     0.150
    63.710   673.031     0.150
    63.710  1138.625     0.150
    63.932    25.000     0.150
    63.932   629.328     0.150
    63.932    25.000     0.150
    64.767    20.500     0.150
    64.767  1149.328     0.150
    64.767   634.328     0.150
    64.767    20.500     0.150
    64.767  1149.328     0.150
    65.006     7.602     0.150
    65.006   635.625     0.150
    65.509    21.000     0.150
    65.509   640.328     0.150
    65.509    21.000     0.150
    68.789   672.531     0.150
    68.900    18.000     0.150
    68.900   660.328     0.150
    68.900    18.000     0.150
    70.947   674.328     0.150
    71.067   675.328     0.150
    72.189   682.328     0.150
    72.189  1238.328     0.150
    73.047   687.625     0.150
    73.047   687.625     0.150
    74.136    21.000     0.150
    74.186   693.328     0.150
    74.281   696.930     0.150
    74.553   696.328     0.150
    74.610     6.500     0.150
    74.610    20.500     0.150
    74.610    20.602     0.150
    74.728     7.000     0.150
    74.728   696.328     0.150
    74.728   703.328     0.150
    74.824  1272.328     0.150
    75.299   727.328     0.150
    75.431   706.328     0.150
    75.398   700.328     0.150
    75.638   701.125     0.150
    76.335    23.000     0.150
    76.335   706.328     0.150
    76.335    22.703     0.150
    76.952    16.695     0.150
    77.108   719.031     0.150
    77.108  1291.328     0.150
    77.108   719.031     0.150
    77.108  1291.328     0.150
    77.652   697.328     0.150
    78.009   716.125     0.150
    78.009  1307.227     0.150
    78.046  1293.328     0.150
    78.046   715.125     0.150
    78.046  1293.328     0.150
    78.278  1308.930     0.150
    78.278  1308.930     0.150
    78.374   720.828     0.150
    78.374    10.500     0.150
    78.374   780.727     0.150
    79.293   721.328     0.150
    79.455   727.328     0.150
    79.467   724.828     0.150
    79.571   726.328     0.150
    79.615   724.328     0.150
    79.681   726.828     0.150
    79.829   727.328     0.150
    79.977   724.727     0.150
    80.181   728.328     0.150
    80.241   730.328     0.150
    80.241   732.328     0.150
    80.691   730.328     0.150
    81.301   738.828     0.150
    81.332   735.828     0.150
    81.506   736.328     0.150
    81.506   736.328     0.150
    81.506  1345.328     0.150
    81.550  1388.727     0.150
    81.550  1413.727     0.150
    81.700   740.828     0.150
    81.751   741.328     0.150
    81.931   737.328     0.150
    82.002   739.727     0.150
    82.002   739.727     0.150
    82.002  1349.328     0.150
    82.320   739.328     0.150
    82.332   740.828     0.150
    82.651   740.328     0.150
    82.651  1356.328     0.150
    82.969   749.328     0.150
    83.091   744.328     0.150
    83.116  1359.328     0.150
    83.116   742.328     0.150
    83.116  1359.328     0.150
    83.404    25.797     0.150
    83.404    25.594     0.150
    83.422   824.328     0.150
    83.595   750.828     0.150
    83.622    20.500     0.150
    83.831   749.328     0.150
    83.837   745.328     0.150
    83.965   746.828     0.150
    83.965   817.328     0.150
    84.255   751.828     0.150
    85.492   757.828     0.150
    91.483   787.227     0.150
    92.598   825.328     0.150
    92.906   787.531     0.150
    92.912   790.328     0.150
   115.348  1122.031     0.150
   115.366  1122.328     0.150
   120.995  1224.828     0.150
   144.513  1169.328     0.150
   153.955  1192.328     0.150
   154.691  1200.328     0.150
   158.524  1212.828     0.150
   158.591  1191.328     0.150
     0.747    15.500     0.150
    25.001    12.500     0.150
    25.015   327.301     0.150
    25.615    11.801     0.150
    25.957   335.102     0.150
    28.366   353.000     0.150
    29.189   360.500     0.150
    36.335   416.102     0.150
    37.550   433.102     0.150
    42.419   598.102     0.150
    61.131   607.102     0.150
    65.353   634.203     0.150
    74.630   693.000     0.150
    74.768   695.602     0.150
    75.515   702.000     0.150
    78.403    19.301     0.150
   161.860  1187.602     0.150
    10.304   144.664     0.150
    15.948   222.664     0.150
    15.948   222.664     0.150
    24.314   316.664     0.150
    24.314   627.664     0.150
    25.052   323.664     0.150
    26.681    15.000     0.150
    26.681   603.664     0.150
    26.681   335.664     0.150
    26.681    15.000     0.150
    26.681   374.664     0.150
    26.681   387.664     0.150
    26.681   603.664     0.150
    26.686   335.664     0.150
    30.456   381.766     0.150
    32.050   380.867     0.150
    32.078   380.664     0.150
    32.492   385.562     0.150
    32.577   386.664     0.150
    33.799   397.664     0.150
    33.799   718.664     0.150
    33.799   728.664     0.150
    34.148   414.664     0.150
    35.423   419.664     0.150
    35.430   417.664     0.150
    35.981   416.562     0.150
    35.981   514.664     0.150
    35.981   571.664     0.150
    35.981   750.664     0.150
    35.979   421.664     0.150
    36.184     6.398     0.150
    36.184   419.062     0.150
    36.184     6.398     0.150
    36.184   755.664     0.150
    36.184   925.664     0.150
    37.351   430.664     0.150
    43.301   859.664     0.150
    44.905   490.461     0.150
    45.395   890.664     0.150
    46.825   505.664     0.150
    46.825     8.000     0.150
    46.825   661.664     0.150
    47.774   922.664     0.150
    54.511   564.664     0.150
    54.619   566.664     0.150
    55.387  1019.664     0.150
    57.148   589.164     0.150
    57.674   587.562     0.150
    57.674  1059.961     0.150
    58.240  1068.664     0.150
    59.398  1084.664     0.150
    59.398   598.664     0.150
    59.398  1084.664     0.150
    63.893   629.461     0.150
    63.893  1142.766     0.150
    64.089   630.664     0.150
    64.089  1138.664     0.150
    64.089   660.664     0.150
    64.089  1138.664     0.150
    64.921   636.664     0.150
    64.921   675.664     0.150
    64.921  1153.664     0.150
    65.108   665.664     0.150
    65.620   638.664     0.150
    65.620    15.000     0.150
    65.620   638.664     0.150
    65.620    15.000     0.150
    67.507  1274.664     0.150
    69.025   661.664     0.150
    69.749   666.164     0.150
    70.154   682.664     0.150
    70.386   683.867     0.150
    70.771   676.664     0.150
    71.133   676.664     0.150
    71.254   677.664     0.150
    72.372  1247.664     0.150
    72.372   684.664     0.150
    72.372   705.367     0.150
    72.372  1247.664     0.150
    74.215   693.766     0.150
    74.250   695.164     0.150
    74.691   696.562     0.150
    74.740   697.664     0.150
    74.804   697.664     0.150
    74.804   697.664     0.150
    74.907   702.461     0.150
    75.578   702.664     0.150
    75.639     7.398     0.150
    75.688   702.766     0.150
    76.330   706.766     0.150
    77.051   710.961     0.150
    77.051    17.703     0.150
    77.290   712.164     0.150
    77.725   713.664     0.150
    77.968   763.664     0.150
    77.968   716.664     0.150
    77.968    10.000     0.150
    78.194   717.562     0.150
    78.438  1307.664     0.150
    78.438   717.664     0.150
    78.438  1307.664     0.150
    78.438  1336.664     0.150
    78.454   718.266     0.150
    78.454    12.102     0.150
    78.454   788.461     0.150
    78.892   725.664     0.150
    78.944   725.664     0.150
    79.756   725.664     0.150
    79.756  1323.664     0.150
    79.820   724.664     0.150
    79.975   727.664     0.150
    79.975  1328.664     0.150
    80.522   731.062     0.150
    80.875   734.062     0.150
    81.424   716.664     0.150
    81.671   737.164     0.150
    81.671  1349.664     0.150
    81.695  1421.664     0.150
    81.917   738.164     0.150
    82.100   739.664     0.150
    82.100  1354.664     0.150
    82.469   740.664     0.150
    83.553   746.664     0.150
    84.584   747.664     0.150
    84.721   757.367     0.150
    85.031   752.164     0.150
    85.232   755.461     0.150
    85.555   749.664     0.150
    86.404   763.664     0.150
    91.521   776.664     0.150
    92.796   829.664     0.150
    96.624   813.664     0.150
    96.624   813.664     0.150
   144.558  1160.664     0.150
     7.121   104.390     0.150
     9.907   144.490     0.150
    15.805   227.390     0.150
    15.805   227.390     0.150
    15.805   392.390     0.150
    23.784   310.390     0.150
    24.881   324.590     0.150
    26.258   333.390     0.150
    26.258     8.000     0.150
    35.626   741.390     0.150
    35.626   413.390     0.150
    35.626   741.390     0.150
    37.375   431.690     0.150
    39.442   448.390     0.150
    42.052   469.390     0.150
    42.052   584.390     0.150
    44.550   487.790     0.150
    44.829   544.390     0.150
    59.124   597.190     0.150
    59.124  1183.390     0.150
    63.970   630.290     0.150
    64.716   634.390     0.150
    65.575   639.790     0.150
    65.682   648.390     0.150
    65.682   648.390     0.150
    66.037    16.000     0.150
    69.767   666.390     0.150
    69.767    11.000     0.150
    74.379   694.690     0.150
    74.379   702.390     0.150
    74.379   694.690     0.150
    74.379     7.700     0.150
    74.849   707.190     0.150
    74.849   697.490     0.150
    74.849   707.190     0.150
    74.978   698.690     0.150
    75.939   703.890     0.150
    77.154     5.300     0.150
    78.352   735.690     0.150
    78.352   718.190     0.150
    78.352   727.190     0.150
    78.352    17.500     0.150
    79.705   724.390     0.150
    80.428   741.390     0.150
    81.482   735.390     0.150
    82.385   739.390     0.150
    84.151   748.390     0.150
    92.462   804.390     0.150
   144.906  1172.290     0.150
   150.439  1823.390     0.150
     9.086   233.109     0.150
    10.099   147.367     0.150
    16.668   231.469     0.150
    33.489   394.750     0.150
    33.489    16.000     0.150
    35.272   414.250     0.150
    35.600   412.750     0.150
    38.346   440.250     0.150
    44.524   486.750     0.150
    44.978   491.750     0.150
    57.131   585.250     0.150
    58.661   591.047     0.150
    59.054   596.750     0.150
    62.725   624.250     0.150
    63.326   624.250     0.150
    64.606   633.750     0.150
    64.986   635.453     0.150
    68.688   660.047     0.150
    74.144   692.750     0.150
    74.144    14.898     0.150
    74.144   692.750     0.150
    74.144    14.898     0.150
    74.616   694.953     0.150
    74.741   696.453     0.150
    74.741   696.453     0.150
    76.343   706.148     0.150
    78.383   717.547     0.150
    81.805   734.750     0.150
    83.312   743.750     0.150
    92.713   789.953     0.150
    96.225   815.750     0.150
   101.440   817.250     0.150
   144.598  1182.648     0.150
     0.463    11.746     0.150
     0.463    11.848     0.150
     5.507    81.438     0.150
     6.984   103.676     0.150
    11.062   154.395     0.150
    15.600   219.145     0.150
    16.565   227.746     0.150
    23.906   346.746     0.150
    23.906   565.746     0.150
    23.906   309.746     0.150
    23.906   346.746     0.150
    23.906   565.746     0.150
    24.527   316.746     0.150
    24.780   321.746     0.150
    24.780   322.047     0.150
    25.447   327.348     0.150
    25.508   328.746     0.150
    25.508   329.348     0.150
    25.825   333.246     0.150
    25.825   332.227     0.150
    26.258   382.746     0.150
    26.258   672.746     0.150
    26.258   332.246     0.150
    26.258   382.746     0.150
    26.258   672.746     0.150
    27.361   343.445     0.150
    27.757   350.637     0.150
    27.757   398.637     0.150
    27.757   626.637     0.150
    27.860   349.625     0.150
    27.860   350.746     0.150
    28.818   639.746     0.150
    30.872   376.836     0.150
    30.872   425.836     0.150
    30.872   673.836     0.150
    31.583   387.887     0.150
    31.583   688.887     0.150
    31.784   383.445     0.150
    32.854   716.277     0.150
    33.364   397.547     0.150
    33.427   478.746     0.150
    33.427   393.746     0.150
    33.427   478.746     0.150
    33.456   399.926     0.150
    33.555   403.805     0.150
    33.555   726.965     0.150
    33.624   401.746     0.150
    33.624   402.645     0.150
    33.840   726.746     0.150
    33.840   399.246     0.150
    33.840   726.746     0.150
    33.840   872.746     0.150
    34.262   409.246     0.150
    34.554   730.246     0.150
    34.616   407.746     0.150
    34.806   412.176     0.150
    35.182   415.145     0.150
    35.324   416.746     0.150
    35.324   416.848     0.150
    35.566   513.746     0.150
    35.566   736.746     0.150
    35.566   413.145     0.150
    35.566   513.746     0.150
    35.566   561.746     0.150
    35.566   736.746     0.150
    35.566  1026.746     0.150
    35.746   418.047     0.150
    35.839   419.148     0.150
    35.779    16.801     0.150
    35.779   519.746     0.150
    35.779   757.746     0.150
    35.779   896.746     0.150
    35.779   926.746     0.150
    35.779   417.047     0.150
    35.779    16.801     0.150
    35.779   496.746     0.150
    35.779   519.746     0.150
    35.779   757.746     0.150
    35.779   896.746     0.150
    35.779   926.746     0.150
    35.882   536.105     0.150
    35.882   418.547     0.150
    35.923   422.477     0.150
    36.056   518.895     0.150
    37.155   428.746     0.150
    37.204   767.484     0.150
    38.272   440.246     0.150
    38.510    16.391     0.150
    38.510   459.707     0.150
    39.238   458.965     0.150
    39.238   994.375     0.150
    40.592   815.746     0.150
    40.592  1035.746     0.150
    41.330   465.527     0.150
    41.330     9.598     0.150
    41.330   476.945     0.150
    41.330    14.070     0.150
    41.330   482.824     0.150
    41.330   581.977     0.150
    41.330   807.465     0.150
    41.330   831.625     0.150
    41.330  1029.887     0.150
    41.330   464.547     0.150
    41.882   480.688     0.150
    41.882   486.395     0.150
    43.741   490.348     0.150
    44.491   486.047     0.150
    44.552   487.445     0.150
    44.552   487.434     0.150
    45.015     2.883     0.150
    46.476   896.746     0.150
    46.476   503.145     0.150
    46.476   653.746     0.150
    46.476   896.746     0.150
    46.879    17.461     0.150
    46.879   526.887     0.150
    46.879   506.023     0.150
    47.356   510.547     0.150
    47.356   618.746     0.150
    48.470   521.406     0.150
    48.470    12.340     0.150
    48.643   525.887     0.150
    48.643   945.098     0.150
    48.643  1165.277     0.150
    48.985   946.477     0.150
    48.985  1174.285     0.150
    48.985   522.445     0.150
    48.985   946.445     0.150
    49.363   529.348     0.150
    49.601   540.016     0.150
    49.697   528.746     0.150
    49.697    18.000     0.150
    52.350    23.000     0.150
    52.350   612.746     0.150
    52.350   767.746     0.150
    52.350  1023.746     0.150
    52.350  1063.746     0.150
    52.350  1162.746     0.150
    52.350  1272.746     0.150
    52.350  1312.746     0.150
    52.350  2371.445     0.150
    52.350   546.746     0.150
    52.350   667.746     0.150
    52.350  1312.746     0.150
    52.791   552.246     0.150
    52.791    18.500     0.150
    53.723   569.797     0.150
    54.094  1006.746     0.150
    54.094   561.746     0.150
    54.094   627.746     0.150
    54.094  1006.746     0.150
    54.205   562.945     0.150
    54.668   577.035     0.150
    54.668    16.301     0.150
    54.668  1314.457     0.150
    54.668   564.645     0.150
    54.967   568.246     0.150
    54.967   686.746     0.150
    54.967  1020.746     0.150
    55.555   776.746     0.150
    55.555  1288.746     0.150
    55.555   571.336     0.150
    55.676   572.848     0.150
    56.099   588.285     0.150
    56.099   575.945     0.150
    56.099  1040.645     0.150
    56.835   581.746     0.150
    56.835   714.746     0.150
    56.835   799.746     0.150
    57.041   585.848     0.150
    57.225   583.547     0.150
    57.225   720.746     0.150
    57.212   584.445     0.150
    57.212   716.348     0.150
    57.212  1060.746     0.150
    57.596  2364.348     0.150
    57.817   588.746     0.150
    57.817   801.746     0.150
    57.817  1297.246     0.150
    57.933   598.746     0.150
    58.662   595.047     0.150
    58.662   730.746     0.150
    58.714   595.547     0.150
    58.714  1080.746     0.150
    58.714  1101.746     0.150
    58.714  1308.746     0.150
    58.714   595.578     0.150
    59.004  1078.746     0.150
    59.004   595.746     0.150
    59.004  1078.746     0.150
    59.004  1318.746     0.150
    58.999   594.047     0.150
    58.999    12.301     0.150
    59.225   601.445     0.150
    59.320   598.945     0.150
    59.320    12.301     0.150
    59.525   589.246     0.150
    61.639  2359.246     0.150
    62.981   624.246     0.150
    63.298   626.047     0.150
    63.298   660.746     0.150
    63.298  1217.746     0.150
    63.298   626.117     0.150
    63.754   856.746     0.150
    63.754   628.746     0.150
    63.754   856.746     0.150
    63.880   629.246     0.150
    63.880     7.500     0.150
    63.880   776.746     0.150
    64.237  2357.848     0.150
    64.409   633.746     0.150
    64.590    18.801     0.150
    64.590   784.746     0.150
    64.590   872.746     0.150
    64.590  1155.746     0.150
    64.590   633.945     0.150
    64.590    13.801     0.150
    64.590    18.801     0.150
    64.590   669.746     0.150
    64.590   784.746     0.150
    64.590   872.746     0.150
    64.590  1155.746     0.150
    64.590  1225.746     0.150
    64.888   792.746     0.150
    64.888   870.746     0.150
    64.888  1452.746     0.150
    64.874   635.746     0.150
    65.380    20.000     0.150
    65.380    19.500     0.150
    65.380   876.746     0.150
    65.380  1158.746     0.150
    65.543   640.547     0.150
    65.601  1154.746     0.150
    65.877   643.102     0.150
    65.964   643.746     0.150
    65.964     5.699     0.150
    65.964   883.246     0.150
    65.964   916.746     0.150
    65.964   919.246     0.150
    65.964  1166.746     0.150
    65.964  1236.746     0.150
    68.003   650.547     0.150
    68.581   662.547     0.150
    68.591   659.875     0.150
    68.757   815.746     0.150
    68.757  1247.746     0.150
    68.757   660.746     0.150
    68.757   684.746     0.150
    68.757   815.746     0.150
    68.757  1198.746     0.150
    68.757  1216.746     0.150
    68.757  1247.746     0.150
    69.310   665.445     0.150
    69.310  1210.746     0.150
    69.484    17.699     0.150
    69.484   707.746     0.150
    69.484   820.746     0.150
    69.484   932.746     0.150
    69.484  1257.746     0.150
    69.484  1482.746     0.150
    69.484  1512.746     0.150
    69.484  1680.746     0.150
    69.484   664.047     0.150
    69.484    17.699     0.150
    69.484   689.848     0.150
    69.484   820.746     0.150
    69.484  1207.746     0.150
    69.484  1234.746     0.150
    69.484  1257.746     0.150
    69.484  1482.746     0.150
    69.642  1215.746     0.150
    69.586   674.746     0.150
    70.395   806.746     0.150
    70.418  1228.746     0.150
    70.701   852.746     0.150
    70.701   937.746     0.150
    70.701  1293.746     0.150
    70.701  1512.746     0.150
    70.701  1712.746     0.150
    70.665   700.746     0.150
    70.665   934.746     0.150
    70.652   700.746     0.150
    70.652   934.746     0.150
    70.772   672.746     0.150
    70.772   836.746     0.150
    70.772  1223.746     0.150
    70.772  1688.746     0.150
    71.980  1232.746     0.150
    71.980   681.746     0.150
    71.980   844.746     0.150
    71.980  1232.746     0.150
    72.143   682.547     0.150
    72.143     9.199     0.150
    72.195   682.801     0.150
    72.718  1229.746     0.150
    72.718  1542.746     0.150
    72.718  1762.746     0.150
    72.718   685.746     0.150
    72.718   852.746     0.150
    72.967   686.645     0.150
    72.967   702.746     0.150
    73.241   852.746     0.150
    73.241  1274.746     0.150
    73.328   685.746     0.150
    73.599     8.691     0.150
    73.599    21.930     0.150
    73.599   947.746     0.150
    73.599   956.746     0.150
    73.599   960.746     0.150
    73.599  1230.746     0.150
    73.599  1252.746     0.150
    73.599  1267.746     0.150
    73.599  1282.746     0.150
    73.599  1498.746     0.150
    73.599   690.758     0.150
    74.042  2553.746     0.150
    74.042   693.367     0.150
    74.042   692.645     0.150
    74.042   704.746     0.150
    74.042   712.047     0.150
    74.042   863.746     0.150
    74.042   872.746     0.150
    74.042  1260.746     0.150
    74.042  1286.746     0.150
    74.042  1280.746     0.150
    74.042  1576.746     0.150
    74.042  1782.746     0.150
    74.042  2341.746     0.150
    74.042  2553.746     0.150
    74.042   692.645     0.150
    74.042    12.102     0.150
    74.042  1260.746     0.150
    74.109   692.848     0.150
    74.273  1323.547     0.150
    74.341   696.145     0.150
    74.341   696.145     0.150
    74.341   968.746     0.150
    74.341  1266.746     0.150
    74.341  1296.746     0.150
    74.513   694.145     0.150
    74.513   714.246     0.150
    74.513  2338.348     0.150
    74.513   694.145     0.150
    74.513   714.246     0.150
    74.513  1268.746     0.150
    74.503   868.746     0.150
    74.503   696.738     0.150
    74.637  1278.746     0.150
    74.637   696.645     0.150
    74.637  1278.746     0.150
    74.637  1610.746     0.150
    74.637  1800.746     0.150
    74.637  1862.746     0.150
    74.637   696.645     0.150
    74.857    16.898     0.150
    75.272  1230.746     0.150
    75.272  1269.746     0.150
    75.272  1582.746     0.150
    75.419  1593.746     0.150
    75.419  1793.746     0.150
    75.578   701.645     0.150
    75.606   701.746     0.150
    75.606   981.746     0.150
    75.606  1277.746     0.150
    75.606  1325.746     0.150
    75.729   694.746     0.150
    75.783  1284.746     0.150
    75.907     7.000     0.150
    75.907    17.500     0.150
    76.067   702.445     0.150
    76.240   753.746     0.150
    76.240   937.246     0.150
    76.240  1612.746     0.150
    76.240  1812.746     0.150
    76.240  2381.246     0.150
    76.432   715.348     0.150
    76.531  2330.348     0.150
    76.837    16.500     0.150
    76.837  1343.746     0.150
    76.837  1350.746     0.150
    76.837   708.246     0.150
    76.837     9.500     0.150
    76.837    16.500     0.150
    76.837  1292.746     0.150
    76.837  1315.746     0.150
    76.837  1321.746     0.150
    76.837  1343.746     0.150
    76.837  1350.746     0.150
    77.091    17.398     0.150
    77.193   820.145     0.150
    77.193   710.547     0.150
    77.277   711.547     0.150
    77.335   711.848     0.150
    77.335    20.598     0.150
    77.335   711.848     0.150
    77.335    20.598     0.150
    77.478   771.066     0.150
    77.780   713.945     0.150
    78.011   722.848     0.150
    78.195  1372.746     0.150
    78.195   715.246     0.150
    78.195   892.746     0.150
    78.195  1321.746     0.150
    78.195  1372.746     0.150
    79.454  1014.746     0.150
    79.454  1362.746     0.150
    79.454  1388.746     0.150
    79.454   723.746     0.150
    79.454    10.000     0.150
    79.454   906.746     0.150
    79.454  1014.746     0.150
    79.454  1322.746     0.150
    79.454  1362.746     0.150
    79.454  1388.746     0.150
    79.541  1332.746     0.150
    79.541  1390.746     0.150
    79.541   722.746     0.150
    79.541   903.746     0.150
    79.541  1332.746     0.150
    79.541  1390.746     0.150
    79.572   721.746     0.150
    79.572   726.746     0.150
    79.592   724.711     0.150
    79.592   724.785     0.150
    79.592  1323.848     0.150
    79.662  1322.746     0.150
    79.662   722.746     0.150
    79.662  1322.746     0.150
    79.662  1631.746     0.150
    79.665   724.746     0.150
    79.665  1391.746     0.150
    79.763   722.746     0.150
    79.763   721.746     0.150
    79.780   902.746     0.150
    79.780  1338.746     0.150
    79.780  1632.746     0.150
    79.780   724.746     0.150
    79.780   902.746     0.150
    79.780  1338.746     0.150
    79.780  1632.746     0.150
    79.863   724.746     0.150
    80.051   729.746     0.150
    80.420   917.746     0.150
    80.420   728.746     0.150
    80.420   917.746     0.150
    80.420  1332.746     0.150
    80.599   730.348     0.150
    81.119   753.945     0.150
    81.317   734.746     0.150
    81.317    11.000     0.150
    81.317  1378.746     0.150
    81.260    19.000     0.150
    81.260   769.246     0.150
    81.384  1039.746     0.150
    81.384  1413.746     0.150
    81.384  1661.746     0.150
    81.414  1039.746     0.150
    81.414  1413.746     0.150
    81.414  1661.746     0.150
    81.467  1344.746     0.150
    81.651   736.746     0.150
    81.657   736.246     0.150
    81.657   920.746     0.150
    81.739   758.746     0.150
    81.739   923.746     0.150
    81.739   737.246     0.150
    81.739    11.500     0.150
    81.739    21.500     0.150
    81.739   923.746     0.150
    81.739  1348.746     0.150
    81.739  1352.746     0.150
    81.739  1403.746     0.150
    81.739  1664.746     0.150
    81.995   730.746     0.150
    82.254   737.746     0.150
    82.930  1381.746     0.150
    82.950  1427.746     0.150
    82.950   742.746     0.150
    82.950   940.746     0.150
    82.950  1427.746     0.150
    82.998   742.836     0.150
    83.233   942.746     0.150
    83.233  1439.746     0.150
    83.233   744.547     0.150
    83.233   942.746     0.150
    83.233  1439.746     0.150
    83.222   938.746     0.150
    83.222  1434.746     0.150
    83.222  1906.746     0.150
    83.222   743.746     0.150
    83.222  1358.746     0.150
    83.509  1718.746     0.150
    83.740   746.637     0.150
    84.376     8.301     0.150
    84.816  2533.848     0.150
    84.944   763.277     0.150
    85.196   757.246     0.150
    86.011   757.848     0.150
    86.525   758.445     0.150
    87.369   831.746     0.150
    87.369  1362.746     0.150
    87.369  1632.746     0.150
    87.369   778.355     0.150
    87.369    16.551     0.150
    87.369   764.746     0.150
    88.047   768.746     0.150
    89.163   810.746     0.150
    89.924   793.246     0.150
    90.070   765.547     0.150
    90.497  1412.746     0.150
    91.241   963.746     0.150
    91.241  1812.746     0.150
    92.375    16.500     0.150
    92.375   872.246     0.150
    92.375   976.746     0.150
    92.375  1014.746     0.150
    92.375  1414.746     0.150
    92.375  1432.246     0.150
    92.375  1442.746     0.150
    92.375  1526.746     0.150
    92.375  1542.746     0.150
    92.375  1550.746     0.150
    92.375  1842.746     0.150
    94.399  1165.645     0.150
    95.002  1440.746     0.150
    96.164   979.547     0.150
    96.164  2324.848     0.150
    96.770   800.746     0.150
    98.145   818.746     0.150
    98.145  1200.746     0.150
    98.145  1886.746     0.150
    98.145  2129.746     0.150
    99.181  1073.547     0.150
    99.684  1027.848     0.150
   103.066   871.547     0.150
   104.456  1484.746     0.150
   104.681  1121.246     0.150
   104.971  1491.746     0.150
   108.294   872.746     0.150
   109.054   869.746     0.150
   112.125   881.008     0.150
   115.355  1090.746     0.150
   115.542  1117.547     0.150
   115.542  1206.746     0.150
   115.700  1090.945     0.150
   115.755  1091.547     0.150
   121.951  1236.746     0.150
   124.595  4536.746     0.150
   124.595  4856.746     0.150
   124.595  5440.746     0.150
   124.595  5860.746     0.150
   124.736  1826.746     0.150
   124.736  1868.746     0.150
   129.191   970.746     0.150
   129.191  1150.746     0.150
   129.191  1288.746     0.150
   129.191  1588.746     0.150
   129.191  2321.746     0.150
   134.004  2412.746     0.150
   137.942  1153.848     0.150
   139.916  1156.246     0.150
   139.916  1335.746     0.150
   144.466  1169.746     0.150
   144.645  1181.348     0.150
   144.645  2520.746     0.150
   148.984  1410.746     0.150
   148.984  2013.746     0.150
   148.984  2172.746     0.150
   148.984  2897.746     0.150
   150.184  1181.746     0.150
   156.200  1183.746     0.150
   157.891  1187.246     0.150
   158.012  1202.746     0.150
   158.012  1462.746     0.150
   158.012  1824.746     0.150
   158.012  2256.746     0.150
   158.012  2724.746     0.150
   158.012  3030.746     0.150
   163.693  1487.746     0.150
   163.693  1882.746     0.150
   163.693  1931.746     0.150
   163.693  2052.746     0.150
   163.693  2097.746     0.150
   163.693  2126.746     0.150
   163.693  1194.746     0.150
   163.693  1487.746     0.150
     5.083   149.141     0.150
    11.207   155.758     0.150
    15.624   218.758     0.150
    15.624   218.758     0.150
    15.624   218.758     0.150
    15.624   218.758     0.150
    18.185    15.500     0.150
    24.075   311.258     0.150
    24.336   331.859     0.150
    24.597    11.867     0.150
    24.884   327.750     0.150
    25.262    10.078     0.150
    25.262   333.945     0.150
    25.325   330.195     0.150
    26.383   347.758     0.150
    26.383   333.758     0.150
    26.549   342.320     0.150
    31.175   384.156     0.150
    32.840   392.484     0.150
    33.473   407.758     0.150
    33.473   393.758     0.150
    34.988   411.055     0.150
    35.187   413.086     0.150
    35.187     7.430     0.150
    35.666   410.758     0.150
    35.666   410.758     0.150
    35.666   559.758     0.150
    35.951   431.758     0.150
    35.951   416.258     0.150
    35.951   493.758     0.150
    35.835   418.664     0.150
    38.072   436.758     0.150
    39.049   442.656     0.150
    41.161   452.430     0.150
    41.161   477.531     0.150
    44.590   485.555     0.150
    46.116   505.758     0.150
    46.351   509.656     0.150
    49.957   530.352     0.150
    54.200   561.555     0.150
    54.200   626.555     0.150
    56.847   582.258     0.150
    59.073   596.758     0.150
    63.173   621.758     0.150
    63.173   621.758     0.150
    63.448     5.695     0.150
    63.768   641.758     0.150
    63.768   626.758     0.150
    64.601   632.461     0.150
    64.601    12.297     0.150
    64.829   648.555     0.150
    64.829   633.555     0.150
    66.057     4.000     0.150
    66.057     8.000     0.150
    68.471   660.055     0.150
    68.615   673.758     0.150
    68.726   673.758     0.150
    68.726   658.758     0.150
    68.726   673.758     0.150
    69.289   672.961     0.150
    69.451   677.555     0.150
    69.451   662.758     0.150
    69.451   677.555     0.150
    69.933   676.758     0.150
    70.019   668.859     0.150
    70.721   671.758     0.150
    72.047   679.758     0.150
    72.047   694.758     0.150
    72.873   684.758     0.150
    72.873   699.758     0.150
    73.960   690.555     0.150
    73.960   690.555     0.150
    73.960   705.758     0.150
    74.012   691.055     0.150
    74.012   705.758     0.150
    74.417   694.758     0.150
    74.434   693.156     0.150
    74.434   708.258     0.150
    74.552   694.461     0.150
    74.552   707.961     0.150
    74.552   694.461     0.150
    74.552   707.961     0.150
    75.126   706.758     0.150
    75.468   699.359     0.150
    76.001   712.656     0.150
    76.160   719.156     0.150
    76.236   719.961     0.150
    76.236   704.961     0.150
    76.236   719.961     0.150
    76.450     4.000     0.150
    76.450   712.656     0.150
    76.775   723.258     0.150
    76.775   707.758     0.150
    76.775   723.258     0.150
    77.005   723.961     0.150
    77.204   724.461     0.150
    77.204   710.156     0.150
    77.204   724.461     0.150
    77.813   728.055     0.150
    77.850   728.656     0.150
    77.925   729.055     0.150
    77.943   729.258     0.150
    78.149   728.758     0.150
    78.149   713.758     0.150
    78.149   728.758     0.150
    78.199   731.055     0.150
    79.268   735.555     0.150
    79.466   721.461     0.150
    79.581   734.656     0.150
    79.581   723.156     0.150
    79.581   734.656     0.150
    79.660   723.758     0.150
    79.707   720.758     0.150
    79.800   722.758     0.150
    81.049   731.461     0.150
    83.236   742.758     0.150
    83.445   758.359     0.150
    84.078   762.258     0.150
    84.311   746.555     0.150
    84.311   762.859     0.150
    92.490   800.758     0.150
    96.321   805.758     0.150
   139.892  1156.461     0.150
   139.892  1166.758     0.150
   144.641  1168.758     0.150
   157.431  1211.758     0.150
     5.412    77.797     0.150
     6.499    93.781     0.150
    11.377   157.680     0.150
    11.377   157.883     0.150
    14.220   195.477     0.150
    15.121   211.477     0.150
    15.508   216.883     0.150
    15.508   216.883     0.150
    15.508   216.883     0.150
    15.508   216.883     0.150
    23.844    16.000     0.150
    23.844   352.680     0.150
    23.844   566.680     0.150
    23.844   630.680     0.150
    23.844   307.680     0.150
    23.844    16.000     0.150
    23.844   352.680     0.150
    23.844   566.680     0.150
    23.844   630.680     0.150
    23.902   306.438     0.150
    24.506   318.031     0.150
    25.496   324.086     0.150
    25.559   328.273     0.150
    25.881   332.312     0.150
    26.177   386.680     0.150
    26.177   598.680     0.150
    26.177   672.680     0.150
    26.177   329.680     0.150
    26.177    15.000     0.150
    26.177   369.680     0.150
    26.177   386.680     0.150
    26.177   598.680     0.150
    26.177   672.680     0.150
    27.400   341.477     0.150
    27.822   358.773     0.150
    27.822   631.570     0.150
    27.822   663.570     0.150
    27.925   345.781     0.150
    28.881     7.609     0.150
    28.881   647.672     0.150
    30.939   367.773     0.150
    30.939    14.000     0.150
    30.939   460.773     0.150
    31.313   380.133     0.150
    31.650   383.320     0.150
    31.650     7.453     0.150
    31.849   467.359     0.150
    31.849   725.359     0.150
    32.177   389.828     0.150
    32.177     6.500     0.150
    32.917   393.273     0.150
    33.335   488.680     0.150
    33.335   391.680     0.150
    33.335    15.000     0.150
    33.335   472.680     0.150
    33.335   488.680     0.150
    33.335   553.680     0.150
    33.335   709.680     0.150
    33.592   569.336     0.150
    33.639   411.008     0.150
    33.639   732.258     0.150
    33.708   400.281     0.150
    34.086   572.180     0.150
    34.668   407.906     0.150
    34.668   572.227     0.150
    35.174   416.680     0.150
    35.480   517.680     0.150
    35.480   890.680     0.150
    35.480   411.078     0.150
    35.480    16.602     0.150
    35.480   517.680     0.150
    35.480   559.680     0.150
    35.480   739.680     0.150
    35.480   890.680     0.150
    35.480  1024.680     0.150
    35.410   415.477     0.150
    35.719   514.680     0.150
    35.719   414.180     0.150
    35.719    15.500     0.150
    35.719   514.680     0.150
    35.719   560.977     0.150
    35.719   747.680     0.150
    35.940   420.250     0.150
    35.940     9.188     0.150
    36.064   421.500     0.150
    36.064     9.188     0.150
    36.654   423.680     0.150
    37.238   579.117     0.150
    37.238   427.578     0.150
    37.251   430.250     0.150
    37.251     9.188     0.150
    38.286   438.781     0.150
    39.282   584.352     0.150
    39.282   571.578     0.150
    41.391   463.836     0.150
    41.391    10.602     0.150
    41.391   463.375     0.150
    41.937   595.609     0.150
    41.937   467.477     0.150
    41.937   582.180     0.150
    41.937   595.578     0.150
    43.708   475.180     0.150
    44.161   632.680     0.150
    44.161  1126.680     0.150
    44.161   483.680     0.150
    44.161    15.000     0.150
    44.161   632.680     0.150
    44.161  1076.680     0.150
    44.161  1126.680     0.150
    44.404   483.781     0.150
    44.486   485.383     0.150
    44.486   485.367     0.150
    44.967   492.852     0.150
    44.967     2.320     0.150
    44.967   507.750     0.150
    46.383   501.180     0.150
    46.383    15.500     0.150
    46.383   595.680     0.150
    46.383   613.680     0.150
    46.383   900.680     0.150
    46.700   497.383     0.150
    46.801   505.680     0.150
    46.801   520.250     0.150
    47.288   508.078     0.150
    47.288  1114.680     0.150
    47.658   510.289     0.150
    47.658   511.453     0.150
    47.658   510.578     0.150
    48.120   514.680     0.150
    48.120   932.680     0.150
    48.501   518.758     0.150
    48.501   517.141     0.150
    48.672   934.281     0.150
    49.015   521.180     0.150
    49.629   526.680     0.150
    49.629   634.680     0.150
    49.629   943.680     0.150
    52.725   549.680     0.150
    52.934   553.023     0.150
    53.131   552.680     0.150
    54.008   689.680     0.150
    54.008   756.680     0.150
    54.008   559.281     0.150
    54.008   625.180     0.150
    54.008   689.680     0.150
    54.008   756.680     0.150
    54.118   560.477     0.150
    54.896   565.680     0.150
    55.171   567.281     0.150
    55.171    12.102     0.150
    55.472   774.680     0.150
    55.472  2394.281     0.150
    55.472   568.977     0.150
    55.960   573.078     0.150
    56.103   575.352     0.150
    56.232   645.969     0.150
    56.760   579.680     0.150
    56.760   701.680     0.150
    56.940   579.438     0.150
    57.033   582.977     0.150
    57.145  1049.680     0.150
    57.515   661.680     0.150
    57.741   586.680     0.150
    57.741   711.680     0.150
    58.590   592.578     0.150
    58.590   809.680     0.150
    58.590  1071.680     0.150
    58.515   596.680     0.150
    58.655   592.680     0.150
    58.655    14.500     0.150
    58.655  1068.680     0.150
    58.913   813.680     0.150
    58.913   594.281     0.150
    58.913   813.680     0.150
    58.971  1071.281     0.150
    58.988   592.680     0.150
    59.258  1079.680     0.150
    59.284   588.680     0.150
    61.558  1220.883     0.150
    62.437   613.891     0.150
    62.916   620.680     0.150
    62.916   620.680     0.150
    62.916   661.180     0.150
    63.226   623.680     0.150
    63.226   860.680     0.150
    63.226  1148.680     0.150
    63.662   625.680     0.150
    63.662    17.000     0.150
    63.662   763.680     0.150
    63.662  1134.680     0.150
    63.799   626.680     0.150
    64.358   627.680     0.150
    64.332   631.180     0.150
    64.499   632.461     0.150
    64.499   871.680     0.150
    64.499   631.227     0.150
    64.499   631.180     0.150
    64.499     9.500     0.150
    64.499   771.680     0.150
    64.499   871.680     0.150
    64.499  1144.680     0.150
    64.499  1392.680     0.150
    65.295  1198.680     0.150
    65.295   636.680     0.150
    65.295    12.000     0.150
    65.295  1182.680     0.150
    65.295  1198.680     0.150
    65.467   638.062     0.150
    65.809   642.250     0.150
    65.809   657.477     0.150
    65.809   640.633     0.150
    65.876   641.180     0.150
    65.876   784.680     0.150
    65.876   886.180     0.150
    65.876   908.180     0.150
    65.876   911.180     0.150
    65.876   641.133     0.150
    68.400   904.680     0.150
    68.513   657.578     0.150
    68.627   654.977     0.150
    68.669    10.000     0.150
    68.669  1241.680     0.150
    68.669   657.680     0.150
    68.669    10.000     0.150
    68.669    17.000     0.150
    68.669  1196.680     0.150
    68.669  1241.680     0.150
    69.251   663.180     0.150
    69.251  1208.680     0.150
    69.396   663.500     0.150
    69.396   679.641     0.150
    69.396   822.680     0.150
    69.396  1226.680     0.150
    69.396   661.836     0.150
    69.396   822.680     0.150
    69.396  1201.680     0.150
    69.396  1226.680     0.150
    69.396  1254.680     0.150
    69.396  1472.680     0.150
    69.396  1210.680     0.150
    70.331   670.680     0.150
    70.331   670.680     0.150
    70.331    14.000     0.150
    70.688  1218.680     0.150
    70.688   671.680     0.150
    70.688   691.680     0.150
    70.688   827.680     0.150
    70.688  1218.680     0.150
    70.505   683.461     0.150
    70.524   683.281     0.150
    70.765   672.680     0.150
    70.765  1223.680     0.150
    70.757   684.781     0.150
    70.771   684.781     0.150
    71.310   687.672     0.150
    71.889    14.000     0.150
    71.889   936.680     0.150
    71.889  1288.680     0.150
    71.889   679.680     0.150
    71.889    14.000     0.150
    71.889   936.680     0.150
    71.889  1232.680     0.150
    71.889  1288.680     0.150
    71.815   676.922     0.150
    71.815   689.781     0.150
    72.070   680.680     0.150
    72.104     1.492     0.150
    72.646  1303.680     0.150
    72.646   683.680     0.150
    72.646   699.680     0.150
    72.646  1246.680     0.150
    72.893     7.797     0.150
    72.893   684.383     0.150
    72.893     7.797     0.150
    72.893   701.680     0.150
    72.785   696.781     0.150
    72.816   696.977     0.150
    72.837   697.180     0.150
    73.084   698.977     0.150
    73.528   688.180     0.150
    73.528    14.500     0.150
    73.858  1318.680     0.150
    73.964  2352.680     0.150
    73.964   690.578     0.150
    73.964    17.102     0.150
    73.964   725.680     0.150
    73.964  1251.680     0.150
    73.964  1279.680     0.150
    73.964  1313.680     0.150
    73.964  1577.680     0.150
    73.964  2352.680     0.150
    73.964   690.578     0.150
    73.964    17.102     0.150
    73.964  1251.680     0.150
    74.036   691.180     0.150
    74.036    16.500     0.150
    74.200  1321.578     0.150
    74.251   693.680     0.150
    74.251   693.680     0.150
    74.251   968.680     0.150
    74.436  1262.680     0.150
    74.436  2337.883     0.150
    74.436   692.883     0.150
    74.436    16.797     0.150
    74.436  1262.680     0.150
    74.444   694.578     0.150
    74.444  1270.180     0.150
    74.444   694.539     0.150
    74.561   694.383     0.150
    74.561   711.680     0.150
    74.561   851.680     0.150
    74.561  1267.680     0.150
    74.561  1330.680     0.150
    74.561  1627.680     0.150
    74.561  1795.680     0.150
    74.561   694.383     0.150
    74.561  1267.680     0.150
    74.576   726.578     0.150
    74.576  2354.383     0.150
    74.782   728.180     0.150
    74.782   695.383     0.150
    74.809   692.977     0.150
    75.191  1289.680     0.150
    75.341  1332.078     0.150
    75.341  2346.680     0.150
    75.490    14.000     0.150
    75.490   718.281     0.150
    75.509   699.383     0.150
    75.523   700.680     0.150
    75.523   700.680     0.150
    75.523  1272.680     0.150
    75.826    14.500     0.150
    75.826  1279.680     0.150
    75.826   703.117     0.150
    75.986   700.578     0.150
    75.864   707.680     0.150
    76.163   751.680     0.150
    76.163   822.680     0.150
    76.163  2353.180     0.150
    76.163  2394.180     0.150
    76.222   704.883     0.150
    76.222    16.398     0.150
    76.453     6.500     0.150
    76.453    14.102     0.150
    76.453   722.680     0.150
    76.453  1867.078     0.150
    76.453  2323.578     0.150
    76.453  2327.477     0.150
    76.453  2329.680     0.150
    76.453  2334.680     0.150
    76.453  2343.383     0.150
    76.453  2348.180     0.150
    76.453  2352.281     0.150
    76.453  2356.078     0.150
    76.453  2360.180     0.150
    76.453  2541.383     0.150
    76.674   706.203     0.150
    76.755     8.703     0.150
    76.755  1306.680     0.150
    76.755  1334.680     0.150
    76.755  1352.680     0.150
    76.755   706.680     0.150
    76.755     8.703     0.150
    76.755   718.680     0.150
    76.755    17.797     0.150
    76.755  1306.680     0.150
    76.755  1334.680     0.150
    76.755  1352.680     0.150
    77.015    18.500     0.150
    77.114    18.906     0.150
    77.198   709.477     0.150
    77.198   727.078     0.150
    77.258   709.680     0.150
    77.258   709.680     0.150
    77.258    17.703     0.150
    77.595   711.477     0.150
    77.595    16.703     0.150
    77.684   719.680     0.150
    77.824    13.500     0.150
    77.824    18.602     0.150
    77.824   712.781     0.150
    77.824    13.500     0.150
    77.860    12.500     0.150
    77.860    18.102     0.150
    77.860   713.078     0.150
    77.860    12.500     0.150
    77.935    13.797     0.150
    77.935   730.883     0.150
    77.935   713.781     0.150
    77.935    13.797     0.150
    77.935    17.102     0.150
    77.954    11.297     0.150
    77.954    17.898     0.150
    77.954   713.781     0.150
    77.954    11.297     0.150
    77.954    17.898     0.150
    78.110  1004.680     0.150
    78.110  1342.680     0.150
    78.110   712.680     0.150
    78.110    16.000     0.150
    78.110  1004.680     0.150
    78.110  1300.680     0.150
    78.110  1316.680     0.150
    78.110  1342.680     0.150
    78.110  1604.680     0.150
    78.203    11.906     0.150
    78.203    17.305     0.150
    78.203   715.477     0.150
    78.203    11.906     0.150
    78.203    17.305     0.150
    78.908   720.180     0.150
    79.313   720.680     0.150
    79.334   721.062     0.150
    79.363   721.680     0.150
    79.363    14.000     0.150
    79.363  1316.680     0.150
    79.363  1384.680     0.150
    79.452   720.680     0.150
    79.452    17.000     0.150
    79.452  1315.680     0.150
    79.489   724.680     0.150
    79.502   722.781     0.150
    79.502    17.102     0.150
    79.502  1318.180     0.150
    79.502  1381.781     0.150
    79.571  1016.680     0.150
    79.571   723.180     0.150
    79.571  1016.680     0.150
    79.571  1322.680     0.150
    79.573  1344.680     0.150
    79.573   722.680     0.150
    79.573  1316.680     0.150
    79.573  1344.680     0.150
    79.680   718.180     0.150
    79.693  1390.680     0.150
    79.693   722.680     0.150
    79.693    16.000     0.150
    79.693   902.680     0.150
    79.693  1317.680     0.150
    79.693  1344.680     0.150
    79.693  1390.680     0.150
    79.781   721.383     0.150
    80.619   728.000     0.150
    80.680    14.406     0.150
    80.680   728.312     0.150
    81.225   732.180     0.150
    81.293  1396.680     0.150
    81.293  1406.680     0.150
    81.293  1649.680     0.150
    81.323  1406.680     0.150
    81.323  1649.680     0.150
    81.559   734.680     0.150
    81.559  1344.680     0.150
    81.565  1416.680     0.150
    81.565   732.680     0.150
    81.565   922.680     0.150
    81.565  1344.680     0.150
    81.565  1416.680     0.150
    81.585   732.680     0.150
    81.646     7.000     0.150
    81.646  1028.680     0.150
    81.646  1410.680     0.150
    81.646  1869.680     0.150
    81.646   734.680     0.150
    81.646     7.000     0.150
    81.646   925.680     0.150
    81.646  1028.680     0.150
    81.646  1345.680     0.150
    81.646  1385.680     0.150
    81.646  1410.680     0.150
    81.646  1869.680     0.150
    81.927   727.477     0.150
    82.070   734.680     0.150
    82.758   743.680     0.150
    82.837  1318.680     0.150
    83.141   930.680     0.150
    83.141  1050.680     0.150
    83.141  1354.680     0.150
    83.141   741.883     0.150
    83.141   930.680     0.150
    83.141  1050.680     0.150
    83.141  1354.680     0.150
    83.427   760.680     0.150
    83.427   829.180     0.150
    83.427   909.680     0.150
    83.497   742.680     0.150
    83.520   764.180     0.150
    83.621   742.680     0.150
    83.677    14.898     0.150
    83.677   744.375     0.150
    83.677   744.359     0.150
    83.755   742.680     0.150
    84.055   775.883     0.150
    84.206   741.977     0.150
    84.733   743.680     0.150
    84.784   749.477     0.150
    85.070   750.680     0.150
    85.115   754.180     0.150
    85.875   770.977     0.150
    85.920  1402.383     0.150
    86.401   976.680     0.150
    86.428   759.680     0.150
    86.551   758.078     0.150
    87.388     9.500     0.150
    87.388  2144.680     0.150
    87.388   762.914     0.150
    88.267   765.977     0.150
    89.374    10.000     0.150
    90.408  1398.680     0.150
    91.026   784.883     0.150
    91.273   774.680     0.150
    91.929   791.680     0.150
    92.130   789.578     0.150
    92.292  1134.680     0.150
    92.292  1536.680     0.150
    92.292  1842.680     0.150
    94.555   800.477     0.150
    96.170  1013.180     0.150
    96.170   802.781     0.150
    96.170    13.602     0.150
    99.706  1079.078     0.150
   104.736   840.680     0.150
   105.026   846.680     0.150
   120.812   955.180     0.150
   120.812  1226.781     0.150
   124.645  1138.680     0.150
   134.077  1295.680     0.150
   140.769  1171.477     0.150
   144.556  1169.078     0.150
   144.556  1816.680     0.150
   144.497  2125.680     0.150
   148.956  2164.680     0.150
   150.094  1179.680     0.150
   156.499  1183.680     0.150
   157.801  1192.180     0.150
   157.955  1198.680     0.150
   157.955  1665.680     0.150
   158.405  1202.680     0.150
   163.780  1487.680     0.150
   163.780  1872.680     0.150
   163.780  1926.680     0.150
   163.780  2113.680     0.150
   163.780  1193.680     0.150
   163.780  1208.680     0.150
     5.213    79.836     0.150
     7.147   107.695     0.150
     7.147   179.484     0.150
    24.450   318.758     0.150
    32.535   396.125     0.150
    33.236   400.562     0.150
    36.270   426.992     0.150
    36.709   430.766     0.150
    37.487   437.156     0.150
    37.718   439.406     0.150
    37.933   436.555     0.150
    41.492   469.352     0.150
    41.492     7.500     0.150
    47.810    11.398     0.150
    59.502   602.656     0.150
    63.599   629.453     0.150
    63.761    10.398     0.150
    64.556   625.758     0.150
    65.253   640.453     0.150
    70.111   673.555     0.150
    72.478   699.055     0.150
    74.362   697.555     0.150
    74.362   697.555     0.150
    74.397   698.555     0.150
    74.838   700.352     0.150
    74.951   701.258     0.150
    74.951   710.555     0.150
    74.951   701.258     0.150
    75.746   705.352     0.150
    75.833   705.953     0.150
    76.562   711.156     0.150
    76.562   719.555     0.150
    76.853   721.953     0.150
    78.323   720.453     0.150
    78.323   730.555     0.150
    78.600   721.953     0.150
    78.600   721.953     0.150
    79.052   727.555     0.150
    80.439   733.352     0.150
    80.656   732.156     0.150
    80.826   735.352     0.150
    81.704   738.555     0.150
    82.151   726.453     0.150
    83.865   754.852     0.150
    92.929   794.852     0.150
     0.793    15.859     0.150
     0.793    15.559     0.150
     9.427   134.059     0.150
     9.653   139.660     0.150
    10.126   145.359     0.150
    10.223   144.309     0.150
    11.886   165.859     0.150
    11.886   165.961     0.150
    14.701   209.461     0.150
    15.571   218.559     0.150
    15.571   218.559     0.150
    15.571   218.559     0.150
    15.571   218.559     0.150
    16.800   232.859     0.150
    18.765   261.059     0.150
    18.765   467.059     0.150
    23.483   304.859     0.150
    23.483   620.859     0.150
    24.339   315.859     0.150
    24.931   322.859     0.150
    24.931   323.660     0.150
    25.027   321.059     0.150
    25.027     6.301     0.150
    25.027   535.461     0.150
    25.027   585.160     0.150
    25.101   325.371     0.150
    25.558   330.609     0.150
    25.900   332.719     0.150
    26.016   324.418     0.150
    26.016   324.555     0.150
    25.917   331.559     0.150
    25.972   334.789     0.150
    26.369   336.738     0.150
    26.498   337.289     0.150
    26.553   338.500     0.150
    26.631     5.102     0.150
    26.631   611.359     0.150
    26.601   340.258     0.150
    27.379   346.980     0.150
    27.852   347.461     0.150
    28.170   355.418     0.150
    28.383   354.520     0.150
    28.383   642.480     0.150
    28.456   355.258     0.150
    29.101   360.758     0.150
    29.310     6.102     0.150
    30.518   378.219     0.150
    30.518   696.219     0.150
    31.271   380.230     0.150
    31.271     8.250     0.150
    31.982   381.059     0.150
    31.982   688.059     0.150
    31.982   718.059     0.150
    32.024   386.789     0.150
    32.196   404.129     0.150
    32.196   422.129     0.150
    32.196    76.160     0.150
    32.196   726.129     0.150
    32.375   389.059     0.150
    32.505   390.688     0.150
    32.505   392.461     0.150
    32.793   393.258     0.150
    33.300   397.887     0.150
    33.314   396.660     0.150
    33.354   398.590     0.150
    33.354   399.793     0.150
    33.510   399.348     0.150
    33.757   401.859     0.150
    33.757   402.461     0.150
    33.959   402.758     0.150
    34.411   407.871     0.150
    34.960   410.758     0.150
    35.331   410.242     0.150
    35.350   507.859     0.150
    35.350   734.859     0.150
    35.350   412.359     0.150
    35.350    14.500     0.150
    35.350   488.859     0.150
    35.350   507.859     0.150
    35.350   561.359     0.150
    35.350   734.859     0.150
    35.334     4.902     0.150
    35.687     7.199     0.150
    36.159   421.391     0.150
    36.159   421.359     0.150
    36.161   424.805     0.150
    36.404   424.672     0.150
    36.408   424.191     0.150
    36.458   425.008     0.150
    36.990   428.559     0.150
    37.254   431.355     0.150
    37.556   433.660     0.150
    37.703   432.758     0.150
    37.752   436.211     0.150
    38.049   434.199     0.150
    38.495   442.680     0.150
    38.920   445.121     0.150
    39.719   450.660     0.150
    39.774   451.160     0.150
    40.491   458.859     0.150
    42.342   471.758     0.150
    44.153   484.059     0.150
    44.153   586.859     0.150
    44.254   483.461     0.150
    44.254   483.461     0.150
    44.197   485.559     0.150
    44.545   489.227     0.150
    46.584   597.898     0.150
    46.584   504.801     0.150
    46.967   506.559     0.150
    46.967   916.859     0.150
    46.967  1118.859     0.150
    47.391     7.301     0.150
    47.918   515.359     0.150
    48.047     5.500     0.150
    49.303   526.059     0.150
    49.490   525.961     0.150
    49.878   529.160     0.150
    50.093   537.859     0.150
    50.093     4.602     0.150
    50.351   534.359     0.150
    52.389   549.059     0.150
    53.642   556.359     0.150
    53.839   627.359     0.150
    53.839   683.859     0.150
    53.839   756.859     0.150
    53.839  1015.859     0.150
    53.839   559.758     0.150
    53.839   627.359     0.150
    53.839   683.859     0.150
    53.839   756.859     0.150
    53.839  1015.859     0.150
    54.593   565.359     0.150
    54.611   564.207     0.150
    55.993   578.980     0.150
    56.485   578.859     0.150
    56.485    13.000     0.150
    56.485   710.859     0.150
    56.485   804.859     0.150
    56.408   714.129     0.150
    56.613   579.074     0.150
    56.613   577.961     0.150
    57.163   582.461     0.150
    57.472   585.859     0.150
    57.472  1052.859     0.150
    57.546   576.461     0.150
    58.292   591.859     0.150
    58.292  1067.859     0.150
    58.898   595.461     0.150
    58.898  1069.859     0.150
    59.426   600.680     0.150
    61.004   614.410     0.150
    62.570   620.559     0.150
    62.925   622.559     0.150
    62.925  1119.859     0.150
    63.394   625.059     0.150
    63.576   626.359     0.150
    63.576  1390.859     0.150
    63.740   866.859     0.150
    63.740  1132.859     0.150
    63.740   627.859     0.150
    63.740   866.859     0.150
    63.740  1132.859     0.150
    64.069   630.859     0.150
    64.069   900.859     0.150
    64.069   909.859     0.150
    64.069  1146.859     0.150
    64.068     4.617     0.150
    64.461   632.742     0.150
    64.461   632.859     0.150
    64.461  1150.859     0.150
    64.585   644.859     0.150
    64.585  1189.859     0.150
    64.585   632.859     0.150
    64.585    14.801     0.150
    64.585   668.859     0.150
    64.585  1189.859     0.150
    65.345   642.750     0.150
    65.462   639.559     0.150
    65.525     9.000     0.150
    65.525   679.859     0.150
    65.525   793.859     0.150
    65.525   639.859     0.150
    65.525     9.000     0.150
    65.525    15.000     0.150
    65.525   679.859     0.150
    65.525   793.859     0.150
    65.525  1160.859     0.150
    65.745   641.359     0.150
    65.745    18.500     0.150
    65.745   910.859     0.150
    65.745  1170.859     0.150
    65.783   645.520     0.150
    65.805    20.898     0.150
    65.805  1182.859     0.150
    65.819   643.449     0.150
    67.441   650.859     0.150
    67.441    15.000     0.150
    67.441   683.859     0.150
    68.111   656.859     0.150
    68.111  1242.859     0.150
    68.858   660.859     0.150
    68.858    16.000     0.150
    68.877   662.859     0.150
    68.877  1204.859     0.150
    68.883   659.859     0.150
    68.893   661.551     0.150
    68.903   670.859     0.150
    68.903  1672.859     0.150
    69.590   664.719     0.150
    69.590   664.859     0.150
    69.590   694.859     0.150
    69.590  1208.859     0.150
    69.590  1248.859     0.150
    70.005   668.859     0.150
    70.005   928.859     0.150
    70.005  1256.859     0.150
    70.005  1478.859     0.150
    70.573   672.859     0.150
    70.573  1225.859     0.150
    70.573   672.859     0.150
    70.573  1225.859     0.150
    70.924   672.859     0.150
    71.062   680.559     0.150
    71.828   942.859     0.150
    71.828  1282.859     0.150
    71.828   680.461     0.150
    71.828   942.859     0.150
    71.828  1282.859     0.150
    73.217   687.859     0.150
    73.217    13.000     0.150
    73.217    17.000     0.150
    73.217   846.859     0.150
    73.227     8.102     0.150
    74.071   693.859     0.150
    74.166   694.461     0.150
    74.166   694.461     0.150
    74.166  1298.859     0.150
    74.271   693.508     0.150
    74.271   693.461     0.150
    74.271    12.398     0.150
    74.271   709.359     0.150
    74.271   730.758     0.150
    74.271   746.859     0.150
    74.271  1258.859     0.150
    74.271  1572.859     0.150
    74.271  1776.859     0.150
    74.375     8.602     0.150
    74.379   697.309     0.150
    74.379   694.410     0.150
    74.629   694.930     0.150
    74.738   699.660     0.150
    74.738   869.859     0.150
    74.738   696.480     0.150
    74.874   870.859     0.150
    74.874  1582.859     0.150
    74.874   697.559     0.150
    74.874   710.359     0.150
    74.874   870.859     0.150
    74.874  1272.859     0.150
    74.874  1582.859     0.150
    74.874  1795.859     0.150
    74.874   697.559     0.150
    74.874   710.359     0.150
    74.874   870.859     0.150
    74.874  1272.859     0.150
    75.489   698.930     0.150
    75.556   746.859     0.150
    75.602   881.859     0.150
    75.602  1278.859     0.150
    75.641   704.461     0.150
    75.641    17.203     0.150
    75.641   701.758     0.150
    75.641    17.203     0.150
    75.595   704.660     0.150
    75.806    20.203     0.150
    75.807   703.059     0.150
    75.807   703.020     0.150
    75.851   763.461     0.150
    75.877   702.859     0.150
    75.877   701.961     0.150
    76.307   704.758     0.150
    76.429   706.500     0.150
    76.468   742.461     0.150
    76.468   707.359     0.150
    76.468    12.801     0.150
    76.493   890.258     0.150
    77.016   717.359     0.150
    77.016   709.359     0.150
    77.016   717.359     0.150
    77.016    14.000     0.150
    77.011   709.578     0.150
    77.063   710.637     0.150
    77.063   710.590     0.150
    77.332   714.359     0.150
    77.332   711.609     0.150
    77.362   710.559     0.150
    77.415   710.859     0.150
    77.561   713.258     0.150
    77.814   713.059     0.150
    77.843   713.859     0.150
    77.938   717.359     0.150
    77.939   713.461     0.150
    78.175    12.102     0.150
    78.175    15.203     0.150
    78.224   719.859     0.150
    78.250    12.699     0.150
    78.250    17.301     0.150
    78.271    12.699     0.150
    78.271    17.402     0.150
    78.335  1306.859     0.150
    78.335  1323.859     0.150
    78.335  1376.859     0.150
    78.335   715.859     0.150
    78.335    16.000     0.150
    78.335  1306.859     0.150
    78.335  1323.859     0.150
    78.335  1376.859     0.150
    78.389   716.160     0.150
    78.432   716.359     0.150
    78.510   717.859     0.150
    78.510    12.301     0.150
    78.618  1306.859     0.150
    79.500   723.258     0.150
    79.500    13.602     0.150
    79.500  1322.859     0.150
    79.576   726.559     0.150
    79.576    17.602     0.150
    79.596   722.859     0.150
    79.624    13.500     0.150
    79.624   723.859     0.150
    79.624    13.500     0.150
    79.624  1338.859     0.150
    79.640   724.598     0.150
    79.640   724.609     0.150
    79.640   724.559     0.150
    79.640  1346.859     0.150
    79.757   723.758     0.150
    79.885  1392.859     0.150
    79.885   726.859     0.150
    79.885   729.859     0.150
    79.885  1392.859     0.150
    79.888   724.461     0.150
    80.013   728.359     0.150
    80.240   726.859     0.150
    80.487   728.859     0.150
    80.487    17.000     0.150
    80.487  1329.859     0.150
    80.554  1333.859     0.150
    80.554   728.859     0.150
    80.554    16.000     0.150
    80.554  1030.859     0.150
    80.554  1333.859     0.150
    80.554  1400.859     0.150
    80.796   738.359     0.150
    80.917   731.859     0.150
    81.264   732.859     0.150
    81.264   732.859     0.150
    81.264  1340.859     0.150
    81.414  1333.859     0.150
    81.401   746.969     0.150
    81.668   736.359     0.150
    81.724    18.000     0.150
    82.617   735.859     0.150
    82.846  1382.859     0.150
    82.945   743.109     0.150
    82.994  1357.859     0.150
    83.691  1433.859     0.150
    83.752   745.160     0.150
    83.795   743.859     0.150
    83.870   745.859     0.150
    83.938   952.859     0.150
    84.075   747.750     0.150
    84.562    13.398     0.150
    85.533   754.559     0.150
    85.518   751.180     0.150
    86.027   753.859     0.150
    86.714   758.859     0.150
    86.714  1755.859     0.150
    89.495   772.461     0.150
    89.720   778.359     0.150
    90.576   774.859     0.150
    91.184   780.578     0.150
    92.095  1128.859     0.150
    92.095  1420.859     0.150
    92.095  1456.859     0.150
    92.095  1808.859     0.150
    92.283   776.359     0.150
    92.291   796.559     0.150
    92.291   776.359     0.150
    93.469   811.461     0.150
    96.166   808.859     0.150
   114.788  1163.359     0.150
   137.903  1165.359     0.150
   138.470  1153.859     0.150
   138.470  1192.859     0.150
   144.501  1168.059     0.150
   144.501  1168.059     0.150
   144.501  1170.059     0.150
   153.880  1412.961     0.150
   157.656  1215.859     0.150
   157.943  1183.859     0.150
    14.746   203.242     0.150
    15.687   220.443     0.150
    18.375   248.143     0.150
    23.974   326.643     0.150
    23.974   311.643     0.150
    23.974    15.000     0.150
    24.527   316.943     0.150
    24.527   315.643     0.150
    24.527   532.742     0.150
    24.568   319.613     0.150
    25.157   325.104     0.150
    25.845   331.172     0.150
    26.023   332.943     0.150
    26.687   338.502     0.150
    33.555   398.912     0.150
    41.263   464.643     0.150
    44.577   486.342     0.150
    54.180   560.643     0.150
    56.299   579.223     0.150
    58.780   593.143     0.150
    63.840   629.143     0.150
    64.630   633.643     0.150
    74.108   691.643     0.150
    74.703   696.242     0.150
    75.634   700.643     0.150
    76.058   703.443     0.150
    80.183   727.953     0.150
    81.468   733.443     0.150
    83.581   744.143     0.150
    92.810   790.143     0.150
   144.627  1170.742     0.150
   154.626  1192.643     0.150
     0.957    16.957     0.150
     7.093   106.457     0.150
     7.283   107.157     0.150
     9.321   137.157     0.150
    12.214   173.857     0.150
    12.403   175.657     0.150
    17.494   430.558     0.150
    18.895   464.857     0.150
    23.695   309.357     0.150
    25.054   323.357     0.150
    25.054   322.758     0.150
    25.765   332.058     0.150
    41.551   466.357     0.150
    42.163   471.957     0.150
    44.540   488.558     0.150
    50.400   535.657     0.150
    64.761   630.357     0.150
    64.761   630.357     0.150
    69.094   662.357     0.150
    69.869   667.357     0.150
    69.869     9.000     0.150
    74.514   696.258     0.150
    74.514    12.100     0.150
    75.115   700.058     0.150
    75.115   700.058     0.150
    76.090   705.058     0.150
    76.104   705.058     0.150
    76.712   708.857     0.150
    76.712    12.500     0.150
    78.380    12.900     0.150
    78.490     9.900     0.150
    78.490    12.601     0.150
    78.510     9.899     0.150
    78.510    12.500     0.150
    79.930   725.357     0.150
    79.930   725.657     0.150
    80.846   732.357     0.150
    80.846    11.000     0.150
    92.293   789.357     0.150
    95.648   805.058     0.150
   144.246  1181.657     0.150
   144.246  1181.657     0.150
     5.743    84.221     0.150
     7.162   104.521     0.150
     7.162   104.621     0.150
    17.464   435.422     0.150
    18.792   253.221     0.150
    18.792   460.822     0.150
    26.691   606.521     0.150
    35.495   411.922     0.150
    42.211   473.521     0.150
    42.211   473.922     0.150
    42.211   484.822     0.150
    44.419   485.621     0.150
    48.004   510.822     0.150
    50.332   534.621     0.150
    54.003   560.322     0.150
    63.890   630.221     0.150
    69.721   667.521     0.150
    69.721   667.521     0.150
    70.277   680.121     0.150
    74.373   693.922     0.150
    74.974   698.322     0.150
    75.957   703.121     0.150
    78.240   717.521     0.150
    79.781   725.221     0.150
    80.697   731.521     0.150
    80.697    16.000     0.150
   153.636  1196.721     0.150
     6.114    98.899     0.150
     6.114   130.600     0.150
     6.392    98.899     0.150
     6.392   174.199     0.150
     6.493    98.899     0.150
     6.493   179.499     0.150
     6.499   180.999     0.150
     6.785    98.899     0.150
     6.785   188.800     0.150
     7.337   108.579     0.150
    36.973   431.520     0.150
    65.076   638.100     0.150
    74.562   697.899     0.150
    75.162   701.699     0.150
    76.141   705.499     0.150
    76.149   708.199     0.150
    78.211   718.100     0.150
    78.655   720.699     0.150
    79.936   728.090     0.150
     5.600   168.430     0.150
    10.203   146.625     0.150
    12.148   169.227     0.150
    18.681   254.227     0.150
    18.681   462.625     0.150
    23.702   308.828     0.150
    23.702   559.828     0.150
    27.640   345.930     0.150
    30.056   369.172     0.150
    31.643   389.930     0.150
    33.743   401.961     0.150
    35.519   412.828     0.150
    35.519   741.828     0.150
    37.494   431.625     0.150
    46.873   507.227     0.150
    46.614   508.297     0.150
    46.614   598.148     0.150
    46.669   505.227     0.150
    55.470   585.828     0.150
    58.864   593.828     0.150
    59.014  1207.328     0.150
    59.014   595.828     0.150
    59.014    15.297     0.150
    59.014   595.828     0.150
    59.014  1207.328     0.150
    61.407   624.930     0.150
    61.407   613.125     0.150
    61.407  1205.828     0.150
    63.445   626.125     0.150
    63.780   629.328     0.150
    63.780     9.500     0.150
    63.862   661.727     0.150
    63.862   629.531     0.150
    63.862   661.727     0.150
    64.279   633.828     0.150
    64.704   645.828     0.150
    64.704   635.125     0.150
    64.704  1171.828     0.150
    65.108   637.227     0.150
    65.801   644.438     0.150
    65.801  1170.672     0.150
    67.533   661.828     0.150
    67.533   652.328     0.150
    68.870   660.828     0.150
    69.666   673.930     0.150
    69.666   665.125     0.150
    69.895   858.227     0.150
    69.895   668.930     0.150
    70.549   673.828     0.150
    70.549   673.828     0.150
    70.743   673.828     0.150
    71.541   679.125     0.150
    71.994   681.828     0.150
    74.294   724.328     0.150
    74.294   694.125     0.150
    74.294   703.828     0.150
    74.294   724.328     0.150
    74.294   694.125     0.150
    74.339   695.328     0.150
    74.339   695.328     0.150
    74.339    10.500     0.150
    74.384   887.930     0.150
    74.691   841.602     0.150
    74.763   697.531     0.150
    74.763    10.195     0.150
    74.893   696.227     0.150
    74.893   696.227     0.150
    74.893   696.227     0.150
    75.668   702.430     0.150
    75.668     9.500     0.150
    75.668    13.398     0.150
    75.668   701.227     0.150
    75.668    10.398     0.150
    75.824   703.828     0.150
    75.824     9.703     0.150
    75.865   703.125     0.150
    76.360   707.828     0.150
    76.492   735.828     0.150
    76.492   707.328     0.150
    76.492   717.328     0.150
    77.349   712.125     0.150
    77.792   713.930     0.150
    78.398  1365.828     0.150
    78.398   717.828     0.150
    78.398  1365.828     0.150
    79.198  3295.828     0.150
    79.600   724.828     0.150
    79.600    13.000     0.150
    79.655   723.930     0.150
    79.740   709.828     0.150
    79.740  1630.930     0.150
    79.740   709.828     0.150
    79.740  1630.930     0.150
    80.116   726.727     0.150
    80.658   723.828     0.150
    80.658   732.828     0.150
    80.658   723.828     0.150
    80.658   732.828     0.150
    81.230   734.727     0.150
    81.305   735.031     0.150
    81.400   736.828     0.150
    81.734   737.031     0.150
    81.820   724.828     0.150
    81.919   738.430     0.150
    86.037   759.047     0.150
    24.528   328.100     0.150
    25.139    10.682     0.150
    25.519    11.689     0.150
    29.908   367.471     0.150
    29.908     8.740     0.150
    31.421   385.961     0.150
    32.048  2376.160     0.150
    33.229   395.430     0.150
    34.973   410.580     0.150
    35.971   419.430     0.150
    46.608   503.561     0.150
    55.649   565.861     0.150
    64.277    16.500     0.150
    64.277    23.000     0.150
    68.435   655.061     0.150
    74.477   692.061     0.150
    74.477   692.061     0.150
    74.477    19.000     0.150
    75.407    28.000     0.150
   150.007  1220.061     0.150
     3.977    62.825     0.150
     6.775    99.025     0.150
    10.231   147.025     0.150
    11.802   169.015     0.150
    11.973   298.884     0.150
    45.338   497.675     0.150
    63.385   626.125     0.150
    64.348   632.425     0.150
    65.040   637.225     0.150
    66.292   644.425     0.150
    66.292   673.425     0.150
    66.292  1171.925     0.150
    80.908   731.485     0.150
     3.834    59.395     0.150
     3.919    60.895     0.150
     6.571    96.297     0.150
     6.644    96.996     0.150
     7.164   103.895     0.150
     9.034   131.598     0.150
    10.431   151.297     0.150
    50.340   531.691     0.150
    68.653   656.996     0.150
    69.564   661.695     0.150
     1.255    22.821     0.150
     1.710    30.721     0.150
     6.818   100.001     0.150
    20.558   299.401     0.150
    25.454   321.601     0.150
    34.557   410.221     0.150
    38.577   443.391     0.150
    44.820   487.901     0.150
    47.213   511.218     0.150
    50.623   537.621     0.150
    63.628     9.500     0.150
    64.215     6.700     0.150
    64.215     9.200     0.150
    65.073   635.601     0.150
    74.782   697.101     0.150
    74.785   695.701     0.150
    75.268   698.501     0.150
    78.062   717.101     0.150
    78.365   718.201     0.150
    79.379   721.401     0.150
    80.664   730.901     0.150
     0.379     9.248     0.150
     1.397    42.178     0.150
    66.402    10.000     0.150
    73.660   683.448     0.150
    74.710   697.348     0.150
     0.326     9.335     0.150
     3.717    60.985     0.150
     3.788    61.595     0.150
     3.861    62.055     0.150
     5.348    79.315     0.150
    34.789   412.755     0.150
    55.768   571.915     0.150
    63.442   624.115     0.150
    65.100   635.915     0.150
    78.143   717.515     0.150
     0.776    14.383     0.150
     1.251    23.602     0.150
     1.913    34.469     0.150
     2.078    36.758     0.150
     2.878    45.867     0.150
     3.478    98.109     0.150
     5.282    79.148     0.150
    12.420   181.391     0.150
    23.753   555.391     0.150
    23.753   616.992     0.150
    45.293   498.148     0.150
    49.210   528.266     0.150
    56.069   574.586     0.150
    63.234     9.602     0.150
    63.922    10.500     0.150
    64.397   633.789     0.150
    64.397    11.500     0.150
    64.397    17.000     0.150
    66.119    10.000     0.150
    66.119    14.500     0.150
    66.119   915.289     0.150
    66.119   919.289     0.150
    66.119  1169.789     0.150
    66.119  1186.789     0.150
    66.119  1426.289     0.150
    74.548   698.789     0.150
    74.548     8.500     0.150
    75.191   700.289     0.150
    78.456    10.102     0.150
    78.490     9.805     0.150
    78.565     9.695     0.150
    78.585    10.195     0.150
    78.730    10.000     0.150
    78.830    10.102     0.150
    79.443    10.000     0.150
    81.795   732.688     0.150
    83.327   744.531     0.150
     1.280    38.910     0.150
     4.061   111.740     0.150
     5.826    83.660     0.150
    10.287   147.121     0.150
    10.583   154.682     0.150
    27.118   339.941     0.150
    36.513   424.061     0.150
    44.815   489.121     0.150
    50.569   537.672     0.150
    55.651   569.021     0.150
    63.327   624.721     0.150
    64.982   635.221     0.150
    73.861   692.121     0.150
     1.143    22.293     0.150
     1.594    51.493     0.150
     2.732    44.743     0.150
     3.562    57.303     0.150
     3.562   100.023     0.150
     3.612    57.963     0.150
     3.668    59.363     0.150
     3.692    59.193     0.150
     5.177    77.943     0.150
     5.231    78.523     0.150
     6.960   102.483     0.150
     7.122   105.963     0.150
     8.691   129.543     0.150
    10.322   149.763     0.150
    10.334   150.553     0.150
    15.521   218.312     0.150
    17.304   432.850     0.150
    18.716   255.188     0.150
    19.508   267.663     0.150
    20.425   276.163     0.150
    20.425   291.863     0.150
    23.683   320.903     0.150
    23.820   615.963     0.150
    23.820   633.563     0.150
    24.029   317.053     0.150
    24.791   323.363     0.150
    24.862   536.063     0.150
    24.862     5.450     0.150
    24.862   321.408     0.150
    24.862   536.358     0.150
    24.862   995.558     0.150
    25.200   367.563     0.150
    25.200   545.963     0.150
    25.200   590.563     0.150
    25.200   644.663     0.150
    25.232   327.443     0.150
    25.584   330.743     0.150
    25.600   331.233     0.150
    25.652   332.403     0.150
    25.775   332.163     0.150
    25.944   335.563     0.150
    26.050   335.063     0.150
    26.177   345.163     0.150
    26.177   381.863     0.150
    26.239   336.443     0.150
    26.275   339.433     0.150
    26.358   603.963     0.150
    26.702   343.103     0.150
    27.118   344.073     0.150
    27.552   347.526     0.150
    28.048   356.293     0.150
    28.130   353.143     0.150
    28.900   360.903     0.150
    28.900   360.863     0.150
    29.320   364.373     0.150
    29.680   367.073     0.150
    30.270   372.523     0.150
    30.618   375.683     0.150
    32.648   393.863     0.150
    32.766   394.463     0.150
    32.766   394.463     0.150
    32.766   557.458     0.150
    32.766   778.063     0.150
    32.849   394.923     0.150
    33.365   400.333     0.150
    33.461   400.123     0.150
    33.627   401.563     0.150
    33.910   404.243     0.150
    34.127   410.053     0.150
    34.676   411.623     0.150
    35.025   412.563     0.150
    35.025   785.313     0.150
    35.660   417.063     0.150
    35.660   500.663     0.150
    36.236   424.323     0.150
    36.943   429.773     0.150
    37.824   434.053     0.150
    42.015   471.263     0.150
    42.481   476.253     0.150
    44.494   488.363     0.150
    44.863   493.738     0.150
    44.863   595.577     0.150
    44.864   888.863     0.150
    47.309   512.363     0.150
    47.309   622.163     0.150
    47.309   924.663     0.150
    47.309  1123.163     0.150
    47.717   516.188     0.150
    49.645    12.000     0.150
    49.645   530.863     0.150
    49.645    12.000     0.150
    49.645   959.663     0.150
    51.245   538.633     0.150
    51.538   544.813     0.150
    54.173   625.063     0.150
    54.682   564.733     0.150
    54.936  1021.163     0.150
    54.936   569.363     0.150
    54.936   690.663     0.150
    54.936  1021.163     0.150
    54.936  1249.063     0.150
    54.956   569.674     0.150
    55.407   572.163     0.150
    56.148   630.653     0.150
    56.148   576.601     0.150
    56.148   630.651     0.150
    56.828    10.000     0.150
    56.828   705.363     0.150
    56.828   582.663     0.150
    56.828    10.000     0.150
    56.828   705.363     0.150
    57.157   585.163     0.150
    58.613   596.363     0.150
    58.613  1078.863     0.150
    59.005   810.063     0.150
    59.235   602.863     0.150
    62.910   624.863     0.150
    63.268  1378.863     0.150
    63.268   627.663     0.150
    63.268  1137.363     0.150
    63.268  1378.863     0.150
    63.917   908.363     0.150
    63.917   631.663     0.150
    63.917   665.663     0.150
    63.917   774.863     0.150
    63.917   908.363     0.150
    63.917  1141.863     0.150
    63.917  1395.663     0.150
    63.996   779.863     0.150
    63.996  1140.863     0.150
    63.996   631.863     0.150
    63.996   666.363     0.150
    63.996   779.863     0.150
    63.996  1140.863     0.150
    64.233   632.438     0.150
    64.412   634.863     0.150
    64.586   634.863     0.150
    64.586   635.088     0.150
    64.744   636.763     0.150
    64.837  1151.863     0.150
    65.447   639.923     0.150
    65.698  1202.863     0.150
    65.895   643.923     0.150
    65.920   645.463     0.150
    66.073   645.863     0.150
    66.073  1173.163     0.150
    66.073  1427.863     0.150
    68.410   659.513     0.150
    68.451   659.633     0.150
    69.056   811.863     0.150
    69.056  1241.363     0.150
    69.212   662.663     0.150
    69.212  1198.663     0.150
    69.212   662.663     0.150
    69.212  1198.663     0.150
    69.786   667.263     0.150
    69.786   825.063     0.150
    69.786  1232.363     0.150
    70.347     9.000     0.150
    70.347   686.663     0.150
    70.347   824.363     0.150
    70.347   951.663     0.150
    70.347  1235.363     0.150
    70.347   672.863     0.150
    70.347     9.000     0.150
    70.347   686.663     0.150
    70.347   824.363     0.150
    70.347  1224.863     0.150
    70.347  1235.363     0.150
    70.648  1736.763     0.150
    70.648   673.463     0.150
    70.648  1224.563     0.150
    70.648  1736.763     0.150
    70.648   673.463     0.150
    70.648  1224.563     0.150
    71.012   662.463     0.150
    72.136   682.863     0.150
    73.575     2.700     0.150
    73.575   848.463     0.150
    73.575   691.663     0.150
    73.575   705.363     0.150
    73.575  1283.263     0.150
    73.560   691.663     0.150
    73.560   704.863     0.150
    73.560  1256.863     0.150
    73.560  1544.163     0.150
    74.390   695.963     0.150
    74.390   706.863     0.150
    74.390  1262.863     0.150
    74.390  1573.863     0.150
    74.390  1807.863     0.150
    74.405  1552.363     0.150
    74.481   698.363     0.150
    74.481   708.863     0.150
    74.481  1297.863     0.150
    74.481   698.363     0.150
    74.481   708.863     0.150
    74.481   866.863     0.150
    74.481  1271.863     0.150
    74.481  1297.863     0.150
    74.481  1303.863     0.150
    74.860  1270.863     0.150
    74.860  1565.863     0.150
    74.860  2340.863     0.150
    74.860   699.063     0.150
    74.860  1270.863     0.150
    74.860  1565.863     0.150
    74.988  1273.863     0.150
    74.988   699.863     0.150
    74.988  1273.863     0.150
    74.988   699.863     0.150
    74.988   699.863     0.150
    74.988  1273.863     0.150
    75.609  1244.863     0.150
    75.609  1613.563     0.150
    75.609   703.263     0.150
    75.943   707.363     0.150
    76.158     2.600     0.150
    76.158   706.763     0.150
    76.158   721.263     0.150
    76.158  1311.863     0.150
    76.588   713.863     0.150
    76.588   709.563     0.150
    76.588   713.863     0.150
    76.588   717.863     0.150
    77.085   712.663     0.150
    77.618   718.263     0.150
    77.618   740.863     0.150
    78.406   718.783     0.150
    78.505   718.863     0.150
    78.511  1304.863     0.150
    78.735   721.863     0.150
    78.961  1037.363     0.150
    79.696   724.663     0.150
    79.766   726.893     0.150
    79.867   914.763     0.150
    79.867  1381.263     0.150
    80.000   728.963     0.150
    80.076   726.223     0.150
    80.082   904.863     0.150
    80.082  1326.863     0.150
    80.082  1392.863     0.150
    80.180   729.003     0.150
    80.389   730.663     0.150
    80.510   731.163     0.150
    80.516   731.163     0.150
    80.624   732.163     0.150
    80.638   732.263     0.150
    80.669   783.863     0.150
    80.786   744.863     0.150
    80.786  1336.863     0.150
    80.786  1398.863     0.150
    80.831   730.293     0.150
    81.231  1165.943     0.150
    81.316   734.833     0.150
    81.446   733.643     0.150
    81.542   733.863     0.150
    81.678   736.363     0.150
    81.890   737.563     0.150
    82.280   738.603     0.150
    82.604   740.613     0.150
    82.958   742.423     0.150
    83.224   744.763     0.150
    83.235   743.283     0.150
    83.285   745.213     0.150
    83.909   748.363     0.150
    84.131   747.363     0.150
    84.373   750.563     0.150
    85.208   749.203     0.150
    85.792   778.923     0.150
    86.457   760.603     0.150
    86.888   762.563     0.150
    87.642   765.863     0.150
    91.700   786.101     0.150
    92.433   797.863     0.150
    92.433   788.863     0.150
    92.484   789.397     0.150
    92.484  1077.247     0.150
   120.493  1129.799     0.150
   124.751  1139.301     0.150
   133.835  1154.161     0.150
   155.836  1200.263     0.150
   155.836  1200.263     0.150
   155.836  1190.963     0.150
   155.836  1200.363     0.150
   155.836  1219.213     0.150
   159.060  1240.763     0.150
   159.060  1190.063     0.150
   159.060  1240.763     0.150
   159.791  1246.663     0.150
   159.791  1204.563     0.150
   159.791  1233.763     0.150
   159.791  1246.663     0.150
   159.837  1202.663     0.150
   159.837  1231.563     0.150
   159.837  1244.263     0.150
   159.837  1202.663     0.150
   159.837  1231.563     0.150
   159.837  1244.263     0.150
   160.347  1199.463     0.150
   160.347  1199.463     0.150
   160.347  1236.163     0.150
   160.347  1247.363     0.150
    10.578   154.088     0.150
    11.141   157.088     0.150
    12.340   168.787     0.150
    12.514   173.736     0.150
    12.514   305.814     0.150
    12.514   173.787     0.150
    12.514   305.787     0.150
    16.506  1236.410     0.150
    18.839   255.787     0.150
    24.890     9.801     0.150
    24.890   547.826     0.150
    24.890   320.732     0.150
    24.890     9.799     0.150
    24.890   547.832     0.150
    24.890   320.787     0.150
    24.890     9.801     0.150
    27.431   345.066     0.150
    27.431   344.986     0.150
    32.266   385.887     0.150
    32.580   390.963     0.150
    32.580    11.600     0.150
    33.335   399.258     0.150
    34.594   409.188     0.150
    34.779   411.736     0.150
    41.854   468.688     0.150
    44.698   487.088     0.150
    44.698   880.387     0.150
    44.843   488.887     0.150
    47.519   510.688     0.150
    47.544   514.387     0.150
    47.544   514.623     0.150
    47.544    11.064     0.150
    54.401   564.688     0.150
    56.386   578.727     0.150
    56.386   578.688     0.150
    59.426   598.287     0.150
    64.160    12.299     0.150
    64.473   633.713     0.150
    64.473     8.424     0.150
    64.473   633.688     0.150
    64.473     8.500     0.150
    64.806   636.213     0.150
    64.806     8.424     0.150
    64.806   636.188     0.150
    64.806     8.500     0.150
    65.016   637.287     0.150
    66.136   644.617     0.150
    66.136     9.869     0.150
    66.136   644.611     0.150
    66.136     9.875     0.150
    66.334   645.287     0.150
    77.100   711.449     0.150
    77.100   722.350     0.150
    77.100   711.486     0.150
    77.100   722.387     0.150
    81.205   733.771     0.150
    81.205    11.215     0.150
    81.205   733.787     0.150
    81.205    11.199     0.150
   144.129  1179.287     0.150
   144.129  1179.287     0.150
     3.295    95.281     0.150
     6.116    90.562     0.150
     8.705   126.641     0.150
     9.727   140.414     0.150
     9.772   140.188     0.150
    10.555   150.828     0.150
    11.745   169.438     0.150
    11.929   292.891     0.150
    16.435  1273.586     0.150
    18.275   448.164     0.150
    24.492    11.750     0.150
    24.492   314.883     0.150
    24.492    11.758     0.150
    24.492   531.133     0.150
    25.038    17.797     0.150
    25.038   537.242     0.150
    25.038   569.938     0.150
    30.322   378.359     0.150
    31.591   387.531     0.150
    31.736   391.219     0.150
    34.655   415.109     0.150
    36.150   431.258     0.150
    36.693   435.961     0.150
    38.266   435.820     0.150
    38.266    12.047     0.150
    40.511   467.219     0.150
    41.922   477.938     0.150
    41.921   479.539     0.150
    44.494   490.141     0.150
    44.981   868.938     0.150
    46.309   499.141     0.150
    46.605    15.141     0.150
    47.296   918.938     0.150
    54.087   571.219     0.150
    54.022   563.039     0.150
    54.022   562.562     0.150
    54.369   573.852     0.150
    55.454   567.641     0.150
    55.718   569.312     0.150
    58.666   597.539     0.150
    58.666     9.000     0.150
    58.666  1079.539     0.150
    58.666   597.539     0.150
    58.666     9.000     0.150
    58.666  1079.539     0.150
    58.666  1090.242     0.150
    59.268   603.242     0.150
    59.268     6.297     0.150
    59.268     9.195     0.150
    59.268   735.641     0.150
    59.268  1088.141     0.150
    63.128   621.039     0.150
    63.805   625.742     0.150
    63.802   858.242     0.150
    63.802  1382.938     0.150
    64.487  1134.742     0.150
    64.487  1385.141     0.150
    64.487   630.078     0.150
    64.337    11.297     0.150
    64.337    14.000     0.150
    64.337   779.141     0.150
    64.337   631.141     0.150
    64.337    11.203     0.150
    64.337    14.000     0.150
    64.337   779.141     0.150
    73.536    12.305     0.150
    73.536  1260.141     0.150
    73.536   687.844     0.150
    73.536    12.398     0.150
    73.536  1260.141     0.150
    73.536  1544.438     0.150
    74.416   711.844     0.150
    74.416   692.539     0.150
    74.416   711.844     0.150
    74.541   693.539     0.150
    74.541   693.539     0.150
    74.541   693.539     0.150
    75.470   698.844     0.150
    75.488   698.438     0.150
    75.549   698.844     0.150
    76.100   703.039     0.150
    76.434   704.141     0.150
    76.635   706.344     0.150
    76.635   706.344     0.150
    81.226   729.844     0.150
   112.173  8391.969     0.150
   112.185  8392.914     0.150
   112.190  8393.219     0.150
   160.120  1244.938     0.150
   160.120  1244.938     0.150
   160.120  1249.742     0.150
   160.172  1201.242     0.150
   160.172  1201.242     0.150
   160.172  1208.539     0.150
   160.172  1212.242     0.150
   160.172  1244.438     0.150
   160.172  1244.438     0.150
   160.172  1249.344     0.150
     0.718    21.422     0.150
     2.240    39.211     0.150
     2.467    42.242     0.150
     2.585    43.383     0.150
     3.362    54.039     0.150
     4.934    75.562     0.150
     4.887    76.672     0.150
     6.678    98.883     0.150
     8.543   123.211     0.150
    10.742   154.461     0.150
    11.941   174.109     0.150
    15.849   220.508     0.150
    18.440   251.812     0.150
    18.440   251.812     0.150
    24.522   316.109     0.150
    24.522   316.148     0.150
    37.729   432.812     0.150
    38.689   444.789     0.150
    41.689   476.812     0.150
    44.782   494.711     0.150
    44.782   892.008     0.150
    47.591    10.000     0.150
    47.591   927.508     0.150
    48.778   525.344     0.150
    54.706   563.711     0.150
    55.785   570.508     0.150
    55.785   570.508     0.150
    56.047   573.609     0.150
    56.047   632.508     0.150
    58.924   600.211     0.150
    58.924   600.211     0.150
    63.460   624.711     0.150
    63.460   624.711     0.150
    63.539     9.000     0.150
    64.138   630.508     0.150
    64.143  1390.711     0.150
    64.444   633.008     0.150
    64.662   635.211     0.150
    64.662     3.500     0.150
    64.662     4.703     0.150
    64.662   778.711     0.150
    64.861  1144.211     0.150
    64.861  1394.508     0.150
    66.009   643.008     0.150
    66.242   644.211     0.150
    66.242    11.500     0.150
    66.242    13.500     0.150
    72.475   683.117     0.150
    73.837   696.008     0.150
    73.837   695.914     0.150
    74.719   695.812     0.150
    74.723   697.414     0.150
    74.842   697.711     0.150
    74.842   697.711     0.150
    75.321   705.609     0.150
    75.630   707.414     0.150
    75.753   702.414     0.150
    76.055   704.414     0.150
    76.449   712.508     0.150
    76.740   708.312     0.150
    77.218   716.508     0.150
    78.488   718.312     0.150
    80.678  1020.711     0.150
    80.678  1321.008     0.150
    81.276   733.812     0.150
    85.247   753.508     0.150
    92.833   789.508     0.150
   111.848  8386.797     0.150
   111.859  8387.672     0.150
   111.865  8386.492     0.150
   144.563  1172.203     0.150
   159.014  1196.914     0.150
   159.795  1198.914     0.150
     1.300    24.332     0.150
     2.335    71.004     0.150
     2.595    44.863     0.150
     3.282    54.453     0.150
     3.428    56.371     0.150
     3.770    59.754     0.150
     3.952    62.953     0.150
     4.501    68.973     0.150
     4.867    75.883     0.150
     5.338    80.234     0.150
     5.338    78.293     0.150
     5.338   133.742     0.150
     7.030   104.555     0.150
    11.364   160.844     0.150
    12.237   169.844     0.150
    18.557   254.168     0.150
    24.603   319.137     0.150
    24.673   319.281     0.150
    24.673   319.285     0.150
    32.423   392.754     0.150
    32.423   392.758     0.150
    37.756   435.145     0.150
    38.719   441.691     0.150
    42.826  3232.336     0.150
    42.832  3233.676     0.150
    42.844  3233.262     0.150
    43.990  3320.254     0.150
    44.004  3321.273     0.150
    44.008  3316.438     0.150
    45.210   495.441     0.150
    47.372   514.742     0.150
    54.792   629.703     0.150
    54.792   568.500     0.150
    54.792   629.699     0.150
    63.920   627.191     0.150
    64.585   635.395     0.150
    64.994   776.094     0.150
    64.994  1149.293     0.150
    66.119   644.590     0.150
    74.390   696.492     0.150
    74.861   697.949     0.150
    76.880   710.992     0.150
    80.176   729.344     0.150
    80.176   729.344     0.150
    81.329   735.348     0.150
    83.974   749.207     0.150
    83.974   749.203     0.150
    83.974   749.191     0.150
    85.387   756.148     0.150
    92.766   790.875     0.150
    96.116   806.543     0.150
   111.777  8385.547     0.150
   111.789  8385.188     0.150
   111.794  8386.809     0.150
     3.514    47.188     0.150
     5.090   152.797     0.150
     5.090    73.445     0.150
     5.090   127.695     0.150
     5.090   152.797     0.150
     9.345   144.078     0.150
    11.997   163.141     0.150
    11.997   163.133     0.150
    11.997   296.852     0.150
    13.386   192.219     0.150
    24.795   319.695     0.150
    34.242   787.250     0.150
    34.330   407.930     0.150
    35.426   417.797     0.150
    43.075  3246.648     0.150
    43.081  3244.508     0.150
    43.093  3251.906     0.150
    44.239  3339.625     0.150
    44.253  3339.547     0.150
    44.257  3340.648     0.150
    45.372   496.250     0.150
    47.364   508.656     0.150
    47.364   508.664     0.150
    54.830   567.352     0.150
    56.015   574.648     0.150
    57.228     4.297     0.150
    57.228     6.797     0.150
    57.228   716.148     0.150
    59.343   598.820     0.150
    64.108   630.695     0.150
    64.183   633.102     0.150
    64.390   632.945     0.150
    64.875   635.758     0.150
    66.098   643.727     0.150
    70.788   676.648     0.150
    74.699   696.023     0.150
    74.709   701.148     0.150
    74.709     4.797     0.150
    76.687   708.445     0.150
    80.052   725.828     0.150
    80.052   725.820     0.150
    81.430   734.648     0.150
    83.748   746.727     0.150
    85.241   753.195     0.150
    85.241   753.195     0.150
    93.006   790.195     0.150
   111.708  8376.703     0.150
   111.719  8376.492     0.150
   111.724  8380.555     0.150
     1.191    21.570     0.150
     1.493    25.477     0.150
     1.493    43.375     0.150
     3.219    53.750     0.150
     4.803    71.922     0.150
     4.803   122.617     0.150
    10.136   149.727     0.150
    10.318   150.414     0.150
    11.691   274.141     0.150
    11.691   164.195     0.150
    11.691   274.141     0.150
    16.155   230.469     0.150
    16.522   236.797     0.150
    16.522   236.797     0.150
    24.075   314.773     0.150
    24.880   325.875     0.150
    24.880   322.766     0.150
    26.856   341.922     0.150
    34.350   413.477     0.150
    47.121   514.922     0.150
    54.804   637.453     0.150
    54.804   569.477     0.150
    54.804     4.977     0.150
    54.804   633.711     0.150
    54.804   637.453     0.150
    57.251   585.391     0.150
    57.251    12.703     0.150
    57.251    18.000     0.150
    57.251  1055.094     0.150
    57.251  1075.594     0.150
    57.251  1284.594     0.150
    59.229   600.422     0.150
    59.229     4.719     0.150
    63.851   631.180     0.150
    64.260   639.891     0.150
    64.260     6.703     0.150
    64.260     9.500     0.150
    64.724   636.828     0.150
    64.816   638.391     0.150
    64.816    12.203     0.150
    64.816    17.703     0.150
    66.000   645.859     0.150
    66.000     4.281     0.150
    66.275    13.000     0.150
    66.275   667.391     0.150
    68.899   664.594     0.150
    70.377   672.797     0.150
    70.377     4.969     0.150
    70.847   675.891     0.150
    72.445   691.016     0.150
    73.429   695.016     0.150
    74.450   696.469     0.150
    74.450     4.750     0.150
    74.611   696.594     0.150
    74.611    13.000     0.150
    74.611   863.891     0.150
    74.611  1264.391     0.150
    74.611  1295.594     0.150
    76.287   713.656     0.150
    76.410   708.477     0.150
    76.410     5.219     0.150
    81.484   735.938     0.150
    81.484   741.844     0.150
    81.484   737.797     0.150
    81.484   741.844     0.150
    83.447   748.117     0.150
    83.447     4.828     0.150
    85.006   755.484     0.150
    85.006     4.812     0.150
   153.438  1202.969     0.150
     0.506    19.326     0.150
     1.149    20.396     0.150
     1.228    35.646     0.150
     1.869    53.805     0.150
     2.577    43.885     0.150
     3.667    60.785     0.150
     4.765    73.135     0.150
     4.765    73.096     0.150
     7.431   111.025     0.150
     8.536   123.525     0.150
     8.960   119.736     0.150
     8.960   119.705     0.150
     9.188   134.125     0.150
     9.505   137.246     0.150
     9.565   139.336     0.150
     9.599   139.816     0.150
     9.634   139.646     0.150
     9.906   142.195     0.150
    10.217   147.635     0.150
    10.217   147.615     0.150
    10.599   154.656     0.150
    10.732   152.525     0.150
    10.623   158.436     0.150
    10.623   158.455     0.150
    11.270   161.355     0.150
    11.417   163.936     0.150
    11.417   163.885     0.150
    11.590   286.516     0.150
    11.590   159.836     0.150
    11.590   286.510     0.150
    11.657   169.496     0.150
    12.963   187.676     0.150
    13.053   189.816     0.150
    13.357   190.135     0.150
    16.525   233.260     0.150
    17.915   245.486     0.150
    17.915   245.486     0.150
    24.042   312.230     0.150
    24.777   324.006     0.150
    24.777   320.766     0.150
    24.777   320.760     0.150
    25.318   323.836     0.150
    25.318   323.836     0.150
    26.815   338.855     0.150
    26.918   340.686     0.150
    26.918   340.641     0.150
    29.430   363.555     0.150
    31.436   380.516     0.150
    32.312   388.061     0.150
    32.312   556.010     0.150
    32.463   390.496     0.150
    33.165   395.096     0.150
    33.197   396.775     0.150
    33.605   402.285     0.150
    34.211   405.336     0.150
    34.211   405.316     0.150
    34.211   405.338     0.150
    34.419   406.535     0.150
    34.509   408.035     0.150
    34.509   408.084     0.150
    35.395   415.805     0.150
    35.497   415.236     0.150
    35.497   415.246     0.150
    36.102   786.695     0.150
    36.248   423.156     0.150
    36.388   424.445     0.150
    36.750   426.465     0.150
    36.844   427.475     0.150
    37.788   433.236     0.150
    37.788   433.266     0.150
    37.788   433.260     0.150
    38.276   440.277     0.150
    40.963   462.625     0.150
    43.410  3262.268     0.150
    43.416  3263.689     0.150
    43.428  3275.410     0.150
    43.837   592.160     0.150
    44.577  3346.965     0.150
    44.590  3347.732     0.150
    44.893   494.236     0.150
    45.213   496.445     0.150
    45.434   498.695     0.150
    45.434   500.836     0.150
    45.433   498.496     0.150
    45.433   498.498     0.150
    46.316   507.635     0.150
    46.316   507.635     0.150
    47.248   515.135     0.150
    47.215   603.266     0.150
    47.215   511.936     0.150
    47.215   603.260     0.150
    47.686   518.736     0.150
    51.100   544.436     0.150
    51.100   544.436     0.150
    51.300   541.865     0.150
    51.563   543.316     0.150
    53.203   558.035     0.150
    54.327   568.816     0.150
    54.327   633.125     0.150
    54.660   567.855     0.150
    54.660   567.855     0.150
    54.660   630.336     0.150
    55.342   570.436     0.150
    55.601   573.066     0.150
    55.601   634.105     0.150
    55.601   573.061     0.150
    55.601   634.111     0.150
    57.122   589.736     0.150
    59.066   648.436     0.150
    59.066   598.715     0.150
    59.066   648.465     0.150
    59.066   598.711     0.150
    59.066   648.461     0.150
    59.684   604.936     0.150
    61.992   616.135     0.150
    63.019   623.436     0.150
    63.019   623.436     0.150
    63.696   628.686     0.150
    63.696   628.686     0.150
    63.899   630.566     0.150
    63.967   630.805     0.150
    63.967   630.811     0.150
    64.120     8.801     0.150
    64.120    14.000     0.150
    64.538  1395.236     0.150
    64.560   635.125     0.150
    64.685   641.236     0.150
    64.685     7.699     0.150
    64.685    12.199     0.150
    65.840   643.186     0.150
    66.120   636.436     0.150
    70.210   670.816     0.150
    70.210   670.811     0.150
    70.732   678.436     0.150
    70.732     9.500     0.150
    70.732  1270.436     0.150
    72.520   686.535     0.150
    72.520   686.525     0.150
    73.265   688.996     0.150
    73.773   691.936     0.150
    74.249   700.646     0.150
    74.249   695.535     0.150
    74.292   694.305     0.150
    74.292   694.311     0.150
    74.292   696.736     0.150
    74.292   696.725     0.150
    74.335   695.135     0.150
    74.335   695.135     0.150
    74.357   695.336     0.150
    74.357   695.336     0.150
    74.451   700.436     0.150
    74.853   699.246     0.150
    75.033   699.836     0.150
    75.033   699.836     0.150
    75.248   700.135     0.150
    75.248   700.135     0.150
    75.248   700.135     0.150
    75.345   700.936     0.150
    75.345   700.936     0.150
    75.606   703.236     0.150
    75.963   705.436     0.150
    75.973   704.936     0.150
    75.973   704.826     0.150
    75.978   705.035     0.150
    76.147   708.336     0.150
    76.255   706.135     0.150
    76.264   706.365     0.150
    76.264   706.361     0.150
    76.266   706.236     0.150
    76.266   706.236     0.150
    76.583   708.035     0.150
    76.583   708.035     0.150
    76.818   709.135     0.150
    76.818   709.135     0.150
    77.051   710.635     0.150
    77.194   711.736     0.150
    77.194   711.736     0.150
    77.215   711.635     0.150
    77.215   711.635     0.150
    77.464   712.836     0.150
    77.464   712.836     0.150
    77.560   714.236     0.150
    77.632   713.936     0.150
    77.632   713.936     0.150
    77.664   713.836     0.150
    77.664   713.836     0.150
    77.819   714.936     0.150
    77.819   714.936     0.150
    77.819   714.936     0.150
    78.097   717.543     0.150
    78.356   713.535     0.150
    78.948   721.635     0.150
    78.948   721.635     0.150
    79.488   722.436     0.150
    79.655   731.135     0.150
    79.675   725.436     0.150
    79.675   725.436     0.150
    79.844   726.736     0.150
    79.765   727.035     0.150
    79.871   726.736     0.150
    79.871   726.736     0.150
    80.422   725.436     0.150
    80.563   728.936     0.150
    80.563   728.936     0.150
    80.791   731.336     0.150
    80.791   731.336     0.150
    81.366   735.736     0.150
    83.326   744.986     0.150
    83.625   746.836     0.150
    84.845   753.285     0.150
    84.845   753.285     0.150
    87.848   770.885     0.150
    87.848   770.885     0.150
    89.029   773.811     0.150
    89.844   777.023     0.150
   139.778  1161.135     0.150
   139.778  1161.156     0.150
   139.778  1161.154     0.150
   144.892  1173.033     0.150
     0.959    18.881     0.150
     0.977    19.391     0.150
     0.996    32.771     0.150
     1.403    46.312     0.150
     2.744    79.562     0.150
     3.220    90.691     0.150
     3.369    93.951     0.150
     3.486    54.881     0.150
     4.177    64.991     0.150
     4.221    65.731     0.150
     5.052    76.771     0.150
     5.840    85.301     0.150
     6.498    96.091     0.150
     9.581   135.292     0.150
     9.692   141.141     0.150
    10.143   147.161     0.150
    11.215   157.091     0.150
    11.780   165.281     0.150
    12.132   172.611     0.150
    12.404   172.562     0.150
    12.590  2382.673     0.150
    14.730   207.411     0.150
    16.860   239.068     0.150
    16.860  1246.058     0.150
    16.911  1249.908     0.150
    23.622   554.321     0.150
    23.622   308.511     0.150
    24.136   535.598     0.150
    24.292   318.281     0.150
    25.116  2304.059     0.150
    25.495   329.292     0.150
    25.633   330.731     0.150
    25.804   332.461     0.150
    25.811   332.641     0.150
    25.828   332.021     0.150
    25.828   332.001     0.150
    25.969   321.321     0.150
    25.912   333.821     0.150
    26.160   333.391     0.150
    26.598   339.361     0.150
    27.341   345.792     0.150
    27.800   347.881     0.150
    27.800   541.981     0.150
    27.792   348.696     0.150
    27.792   348.581     0.150
    28.252   353.721     0.150
    28.252   353.658     0.150
    28.252   353.681     0.150
    28.389   354.706     0.150
    28.675   357.871     0.150
    28.674   358.241     0.150
    29.099   360.881     0.150
    29.099   545.381     0.150
    29.099   763.851     0.150
    30.165   369.771     0.150
    31.225   378.581     0.150
    32.052   386.542     0.150
    32.052   554.141     0.150
    32.333   385.651     0.150
    32.333   553.321     0.150
    32.258   388.361     0.150
    32.350   389.031     0.150
    33.207   397.261     0.150
    33.396   396.421     0.150
    33.696   402.221     0.150
    33.831   402.621     0.150
    33.831   402.591     0.150
    33.831   558.631     0.150
    33.989   403.621     0.150
    33.989   403.571     0.150
    33.989   559.771     0.150
    34.812   410.761     0.150
    34.872   411.201     0.150
    34.872   562.521     0.150
    34.974   411.991     0.150
    34.974   562.711     0.150
    35.120   411.741     0.150
    35.168   414.071     0.150
    35.351   410.121     0.150
    35.482   426.121     0.150
    35.482   742.321     0.150
    35.380   415.930     0.150
    35.562   881.821     0.150
    35.562   911.521     0.150
    35.561   415.111     0.150
    35.764   415.521     0.150
    35.764   415.471     0.150
    35.743   418.781     0.150
    35.743   564.881     0.150
    36.016   421.011     0.150
    36.016   565.761     0.150
    36.092   421.861     0.150
    36.210   422.641     0.150
    37.198   427.511     0.150
    37.441   432.171     0.150
    37.656   433.671     0.150
    38.011   438.431     0.150
    38.152   437.361     0.150
    38.490   439.785     0.150
    38.562   443.631     0.150
    38.775   443.371     0.150
    38.810   797.231     0.150
    38.993   554.321     0.150
    39.436   449.681     0.150
    39.694   451.062     0.150
    39.956   566.821     0.150
    40.255   456.671     0.150
    40.388   450.621     0.150
    41.625   467.381     0.150
    41.625   583.411     0.150
    42.235   471.821     0.150
    42.235   586.021     0.150
    42.335  3149.553     0.150
    42.341  3153.790     0.150
    42.353  3209.533     0.150
    43.503  3252.471     0.150
    43.516  3253.641     0.150
    43.520  3288.721     0.150
    44.307     8.100     0.150
    44.307   884.121     0.150
    45.075   494.292     0.150
    46.271   501.901     0.150
    46.407   504.161     0.150
    46.635   505.921     0.150
    46.635   913.321     0.150
    46.838   957.921     0.150
    46.838  1153.042     0.150
    46.838   506.961     0.150
    46.922   507.621     0.150
    46.864   507.801     0.150
    47.129    10.000     0.150
    47.250   511.421     0.150
    48.131   525.821     0.150
    48.131   601.321     0.150
    48.257   518.621     0.150
    48.257   935.721     0.150
    48.247   519.346     0.150
    48.338   518.411     0.150
    48.822   520.701     0.150
    49.057   525.676     0.150
    49.119   524.391     0.150
    49.119    11.470     0.150
    49.203   527.120     0.150
    49.331   527.301     0.150
    49.501   529.786     0.150
    49.613   530.464     0.150
    50.006   532.771     0.150
    50.034   532.351     0.150
    50.337   534.521     0.150
    50.864   537.651     0.150
    50.864   614.792     0.150
    51.644   543.621     0.150
    51.644   618.331     0.150
    51.660   544.193     0.150
    51.669   545.002     0.150
    51.771   544.336     0.150
    51.769   545.675     0.150
    52.038   548.691     0.150
    52.113  3915.142     0.150
    52.236   548.471     0.150
    52.474   549.651     0.150
    52.474    12.270     0.150
    53.000   742.721     0.150
    53.000   999.921     0.150
    53.368   559.181     0.150
    54.367  2804.153     0.150
    54.764     8.000     0.150
    54.764   693.621     0.150
    54.783   567.641     0.150
    54.885   567.521     0.150
    55.662   573.481     0.150
    55.985   573.521     0.150
    55.985   574.401     0.150
    56.659   580.651     0.150
    56.682   579.461     0.150
    56.972  1059.121     0.150
    57.205   585.081     0.150
    57.840   719.321     0.150
    57.840  1064.321     0.150
    58.408    13.700     0.150
    59.088  2386.659     0.150
    62.591   619.621     0.150
    62.717  1118.621     0.150
    63.097     7.700     0.150
    63.097    12.900     0.150
    63.656   626.821     0.150
    63.656   626.821     0.150
    63.782     7.800     0.150
    63.782    11.300     0.150
    63.946   630.851     0.150
    64.009   859.121     0.150
    64.258     8.300     0.150
    64.258  1143.321     0.150
    64.258  1393.621     0.150
    64.719   635.421     0.150
    64.724   635.571     0.150
    64.855   665.821     0.150
    65.473  4906.521     0.150
    65.981    12.200     0.150
    65.981  1167.321     0.150
    65.981  1423.321     0.150
    66.032   644.181     0.150
    66.821   649.851     0.150
    68.288    13.400     0.150
    68.288   929.121     0.150
    68.288  1193.621     0.150
    69.006   660.621     0.150
    69.124   663.661     0.150
    69.194   664.621     0.150
    69.858  1209.721     0.150
    70.123   670.921     0.150
    70.163     8.200     0.150
    70.065   673.721     0.150
    70.065  5253.621     0.150
    70.466   672.821     0.150
    70.333   675.121     0.150
    70.333  5273.121     0.150
    70.658   673.131     0.150
    70.775   673.821     0.150
    70.840   670.321     0.150
    71.188   674.321     0.150
    71.188   674.321     0.150
    71.636   680.121     0.150
    71.749   680.521     0.150
    71.772   679.721     0.150
    71.869   679.721     0.150
    71.869     7.800     0.150
    71.886   681.621     0.150
    71.968   681.921     0.150
    72.079   705.321     0.150
    72.107   683.121     0.150
    72.293   684.021     0.150
    72.491   685.721     0.150
    72.539   685.321     0.150
    72.397   687.421     0.150
    72.397  5428.021     0.150
    72.402   687.821     0.150
    72.402   155.100     0.150
    72.402  1247.621     0.150
    72.402  1529.621     0.150
    72.402  5429.121     0.150
    72.640   686.521     0.150
    72.663     7.000     0.150
    72.663   685.221     0.150
    72.663     7.000     0.150
    72.472   687.921     0.150
    72.472  5434.421     0.150
    72.630   689.221     0.150
    72.630  5446.121     0.150
    73.029   688.621     0.150
    72.871  5463.821     0.150
    73.233   688.321     0.150
    73.330   688.921     0.150
    73.648   692.521     0.150
    73.648   692.471     0.150
    73.864   692.321     0.150
    74.058   692.721     0.150
    74.096   694.021     0.150
    74.096   694.021     0.150
    74.200     9.300     0.150
    74.190   703.621     0.150
    74.412   699.421     0.150
    74.412     7.800     0.150
    74.412    14.800     0.150
    74.522   696.021     0.150
    74.522   864.321     0.150
    74.522   966.321     0.150
    74.522  1291.321     0.150
    74.522  1362.321     0.150
    74.522  1540.321     0.150
    74.522  1606.321     0.150
    74.522  1774.321     0.150
    74.621  1573.507     0.150
    74.990   862.321     0.150
    74.990  1269.321     0.150
    74.990  1548.321     0.150
    74.990   699.121     0.150
    74.990   862.321     0.150
    74.990  1269.321     0.150
    75.080   699.521     0.150
    75.080  1273.821     0.150
    75.124   699.221     0.150
    75.160   700.321     0.150
    75.160   700.321     0.150
    75.177   700.121     0.150
    75.177   700.121     0.150
    75.177   700.121     0.150
    75.355   701.421     0.150
    75.356   700.621     0.150
    75.410   701.621     0.150
    75.573   702.921     0.150
    75.573  1280.121     0.150
    75.724  1284.421     0.150
    75.731   703.121     0.150
    75.731   703.411     0.150
    75.809   704.021     0.150
    75.809  1283.621     0.150
    75.807   705.131     0.150
    75.894   979.721     0.150
    75.894   704.421     0.150
    75.894  1284.021     0.150
    75.896   703.921     0.150
    75.896   703.921     0.150
    75.917   704.321     0.150
    75.917   704.321     0.150
    76.037   725.121     0.150
    76.037   979.521     0.150
    76.055   704.921     0.150
    76.056   705.341     0.150
    76.107   705.621     0.150
    76.104   705.621     0.150
    76.104   705.621     0.150
    76.109   705.121     0.150
    76.109   705.121     0.150
    76.109   705.121     0.150
    76.164   705.711     0.150
    76.213   706.021     0.150
    76.213   706.021     0.150
    76.265   706.721     0.150
    76.342   706.921     0.150
    76.342   706.921     0.150
    76.511   708.621     0.150
    76.613   708.421     0.150
    76.719   708.921     0.150
    76.719  1292.621     0.150
    76.784   709.421     0.150
    76.794   709.821     0.150
    76.851   709.021     0.150
    76.851   709.331     0.150
    76.974   710.821     0.150
    76.974  1625.721     0.150
    77.010   710.121     0.150
    77.022   711.021     0.150
    77.022  1308.621     0.150
    77.022  1616.521     0.150
    77.068   711.021     0.150
    77.068   711.021     0.150
    77.076   710.921     0.150
    77.231   711.271     0.150
    77.254   711.792     0.150
    77.276   717.121     0.150
    77.276  1292.921     0.150
    77.276  1787.921     0.150
    77.394   712.721     0.150
    77.394   712.721     0.150
    77.426   714.321     0.150
    77.454   713.421     0.150
    77.581   713.421     0.150
    77.625   713.921     0.150
    77.625   713.921     0.150
    77.625   713.921     0.150
    77.532   716.321     0.150
    77.750   715.021     0.150
    77.771   715.321     0.150
    77.884   715.421     0.150
    77.884   715.421     0.150
    78.026   716.831     0.150
    78.026   717.121     0.150
    78.051   716.421     0.150
    78.051   716.421     0.150
    78.060   716.721     0.150
    78.060   716.721     0.150
    78.081   716.121     0.150
    78.302   717.621     0.150
    78.302   717.621     0.150
    78.102   895.721     0.150
    78.102  5856.321     0.150
    78.475   718.621     0.150
    78.475   718.621     0.150
    78.498   718.721     0.150
    78.498   718.721     0.150
    78.600  1011.321     0.150
    78.600  1306.321     0.150
    78.600  1324.321     0.150
    78.600  1374.321     0.150
    78.600   718.321     0.150
    78.600   188.000     0.150
    78.600  1374.321     0.150
    78.595   716.621     0.150
    78.667   719.721     0.150
    78.667   719.721     0.150
    78.754   720.721     0.150
    78.754   720.721     0.150
    78.813   718.321     0.150
    79.024   724.021     0.150
    79.551   724.421     0.150
    79.551   724.421     0.150
    79.691   726.921     0.150
    79.811   726.321     0.150
    79.811   726.321     0.150
    79.772   731.221     0.150
    79.897   727.721     0.150
    79.897   727.721     0.150
    79.911   726.812     0.150
    79.918   728.021     0.150
    79.918   728.021     0.150
    79.923   726.251     0.150
    79.950   904.721     0.150
    79.950  1017.221     0.150
    79.950  1330.421     0.150
    79.950  1634.221     0.150
    79.992   727.121     0.150
    79.992   727.121     0.150
    80.145   727.471     0.150
    80.153   726.021     0.150
    80.153  1325.321     0.150
    80.331   731.721     0.150
    80.353   730.171     0.150
    80.355   729.221     0.150
    80.355   729.221     0.150
    80.349   730.421     0.150
    80.413   729.921     0.150
    80.413   729.921     0.150
    80.380   729.921     0.150
    80.440  6027.821     0.150
    80.684   732.021     0.150
    80.684   732.021     0.150
    80.825  1338.521     0.150
    80.904   733.221     0.150
    81.039   733.221     0.150
    81.140   733.531     0.150
    81.140  1343.031     0.150
    81.156   733.011     0.150
    81.213   731.321     0.150
    81.208  1350.621     0.150
    81.317   735.121     0.150
    81.125   737.721     0.150
    81.431   733.531     0.150
    81.310   737.341     0.150
    81.572   735.721     0.150
    81.572   735.721     0.150
    81.599   735.821     0.150
    81.599   735.821     0.150
    81.632   735.421     0.150
    81.632   735.421     0.150
    81.634   736.621     0.150
    81.634   736.621     0.150
    81.830   737.021     0.150
    81.830   737.021     0.150
    82.042   738.321     0.150
    82.042   738.321     0.150
    82.437   752.292     0.150
    82.861  1363.221     0.150
    83.030   743.621     0.150
    83.030   743.621     0.150
    83.215   745.607     0.150
    83.226   745.321     0.150
    83.257   746.021     0.150
    83.480   746.271     0.150
    83.581   752.292     0.150
    84.014   748.121     0.150
    84.146   749.621     0.150
    84.294   749.921     0.150
    84.359   752.221     0.150
    84.502   751.021     0.150
    84.545   751.021     0.150
    84.630   751.521     0.150
    84.723   752.321     0.150
    84.723   752.321     0.150
    84.744   751.821     0.150
    84.744   751.821     0.150
    84.822   750.671     0.150
    84.851   752.421     0.150
    84.851   752.421     0.150
    84.706   758.371     0.150
    84.860   753.821     0.150
    84.942   753.521     0.150
    84.942   753.521     0.150
    84.806   753.231     0.150
    84.883   765.841     0.150
    85.048   753.621     0.150
    85.048   753.621     0.150
    85.040   768.651     0.150
    85.187   754.721     0.150
    85.072   769.121     0.150
    85.303   754.321     0.150
    85.309   754.821     0.150
    85.309   754.821     0.150
    85.319   755.301     0.150
    85.491   755.221     0.150
    85.491   755.221     0.150
    85.510   755.621     0.150
    85.510   755.621     0.150
    85.608   756.421     0.150
    85.531   770.991     0.150
    85.794   756.921     0.150
    85.794   756.921     0.150
    85.916   756.501     0.150
    86.229   759.321     0.150
    86.274   760.121     0.150
    86.274   760.121     0.150
    86.342   761.021     0.150
    86.405   760.121     0.150
    86.405   760.121     0.150
    86.506   760.121     0.150
    86.564   760.321     0.150
    86.675   760.621     0.150
    86.792   762.121     0.150
    86.889   762.221     0.150
    86.773   761.991     0.150
    86.994   763.321     0.150
    87.121   762.321     0.150
    87.351   764.521     0.150
    87.575   765.491     0.150
    87.856   767.221     0.150
    87.958   767.521     0.150
    88.692   769.121     0.150
    88.692   769.121     0.150
    88.670  1735.292     0.150
    89.009   778.321     0.150
    89.071   785.221     0.150
    89.372   773.521     0.150
    89.372   773.521     0.150
    92.308  1003.351     0.150
    92.684  1005.941     0.150
    94.157   807.921     0.150
    99.887   823.062     0.150
   102.245   833.801     0.150
   104.799   845.551     0.150
   115.956  1120.461     0.150
   128.610  2281.321     0.150
   140.264  1167.721     0.150
   140.264  1167.751     0.150
   140.264  1340.181     0.150
   144.201  1183.911     0.150
   144.201  1387.641     0.150
   148.157  1183.011     0.150
   148.506  1158.321     0.150
   148.506  2514.321     0.150
   150.201  1184.191     0.150
   150.201  1188.721     0.150
   150.201  1194.231     0.150
   150.506  1184.081     0.150
   155.598  1217.298     0.150
   159.055  1240.502     0.150
   159.789  1242.809     0.150
   159.829  1245.655     0.150
     0.982    18.773     0.150
     1.834    31.664     0.150
     1.902    58.195     0.150
     2.218    36.734     0.150
     2.164    37.727     0.150
     2.248    38.914     0.150
     2.248    67.523     0.150
     9.795   141.453     0.150
     9.795   141.484     0.150
    12.199   176.352     0.150
    42.548  3202.414     0.150
    42.554  3207.570     0.150
    42.566  3208.594     0.150
    43.716  3283.672     0.150
    43.729  3292.156     0.150
    43.733  3281.406     0.150
    47.805   516.453     0.150
    50.121   531.852     0.150
    50.121   531.852     0.150
    56.736   587.750     0.150
    62.252   615.352     0.150
    73.293   688.766     0.150
    74.357   694.750     0.150
    75.414   701.250     0.150
    75.731   703.156     0.150
    75.950   703.852     0.150
    75.950   703.852     0.150
    76.006   704.555     0.150
    76.555   708.156     0.150
    77.622   712.852     0.150
    78.048   715.953     0.150
    78.956   721.250     0.150
    80.135   728.156     0.150
    80.154   727.352     0.150
    80.229   726.852     0.150
    80.229   726.852     0.150
    80.267   726.156     0.150
    80.321   728.156     0.150
    80.352   729.055     0.150
    80.820   729.156     0.150
    80.820   729.156     0.150
     2.110    62.294     0.150
     2.370    38.764     0.150
     2.501    72.544     0.150
     5.213   133.340     0.150
     5.213    74.834     0.150
     5.213   133.334     0.150
     9.641   136.934     0.150
    11.743   166.754     0.150
    11.927   298.306     0.150
    11.993   169.794     0.150
    18.273   247.634     0.150
    24.360   313.534     0.150
    24.491    12.572     0.150
    24.491   314.534     0.150
    24.491    12.600     0.150
    24.491   530.434     0.150
    25.036   317.834     0.150
    26.240   332.134     0.150
    26.991   336.814     0.150
    27.384    11.335     0.150
    27.384   342.534     0.150
    27.384    11.300     0.150
    27.384   338.454     0.150
    27.384    15.410     0.150
    32.728   566.534     0.150
    34.655   404.375     0.150
    36.176   418.534     0.150
    38.265   435.834     0.150
    38.705   434.024     0.150
    39.165    17.800     0.150
    39.165   555.434     0.150
    41.922   465.834     0.150
    41.922   582.034     0.150
    44.401   478.034     0.150
    46.306   499.234     0.150
    46.602   517.534     0.150
    46.602   502.834     0.150
    46.602   517.534     0.150
    47.295    14.800     0.150
    47.647    11.533     0.150
    47.647   513.034     0.150
    47.647    11.600     0.150
    47.647   601.334     0.150
    50.259   531.334     0.150
    54.086     7.950     0.150
    54.356   639.193     0.150
    55.715   569.634     0.150
    63.802   625.834     0.150
    63.802    13.600     0.150
    63.800    13.500     0.150
    63.800    18.300     0.150
    64.137   628.534     0.150
    64.137    13.900     0.150
    64.335    16.000     0.150
    64.335    22.800     0.150
    65.633   636.434     0.150
    65.633   638.234     0.150
    65.633    14.100     0.150
    65.874   642.634     0.150
    65.874    16.000     0.150
    65.874   665.134     0.150
    65.848  4905.134     0.150
    68.405    14.200     0.150
    68.405    21.200     0.150
    68.405  1191.934     0.150
    69.378   817.734     0.150
    70.523  5259.734     0.150
    70.789  5277.535     0.150
    71.445   675.074     0.150
    72.870  5435.234     0.150
    73.103  5448.134     0.150
    73.334  5473.334     0.150
    73.942   689.534     0.150
    73.942    13.600     0.150
    74.244    18.000     0.150
    74.244  1261.134     0.150
    74.375   691.434     0.150
    74.375    13.600     0.150
    74.413   692.834     0.150
    74.512   692.934     0.150
    74.841   694.334     0.150
    74.841   694.334     0.150
    74.990   696.034     0.150
    74.990   705.734     0.150
    75.005   696.034     0.150
    75.005   703.734     0.150
    75.170   696.834     0.150
    75.170   698.424     0.150
    75.290   697.434     0.150
    75.290   697.434     0.150
    75.319   698.134     0.150
    75.546   699.034     0.150
    75.546   699.034     0.150
    75.546   707.234     0.150
    75.724   700.434     0.150
    75.964   702.534     0.150
    76.140   703.134     0.150
    76.140   717.134     0.150
    76.140   703.084     0.150
    76.240   704.234     0.150
    76.431   704.534     0.150
    76.431   716.834     0.150
    76.432   704.434     0.150
    76.896   707.034     0.150
    76.905   706.934     0.150
    78.582  5859.234     0.150
    79.670   723.134     0.150
    79.747   722.625     0.150
    80.800  6028.734     0.150
    82.351   741.634     0.150
    85.228   749.554     0.150
    92.828   787.634     0.150
    92.828    12.700     0.150
   153.324  1192.734     0.150
   153.324  1205.334     0.150
     0.936    18.074     0.150
     1.793    52.454     0.150
     2.332    38.464     0.150
     2.332    69.534     0.150
     3.213    89.974     0.150
     3.972    59.874     0.150
     4.617   123.294     0.150
     4.656    69.424     0.150
     5.219   133.099     0.150
     5.219   136.714     0.150
     5.930    86.874     0.150
     7.818   111.074     0.150
     8.284   118.174     0.150
     8.348   118.374     0.150
     8.879   122.764     0.150
     8.879   122.774     0.150
     8.943   126.474     0.150
     9.370   131.874     0.150
     9.748   137.674     0.150
    10.357   143.774     0.150
    10.587   147.074     0.150
    11.142   154.874     0.150
    14.301   342.494     0.150
    15.174   213.484     0.150
    15.174   213.474     0.150
    16.989   421.599     0.150
    16.989   234.734     0.150
    16.989   421.604     0.150
    18.304   246.324     0.150
    18.304   246.314     0.150
    18.304   451.744     0.150
    18.304   951.014     0.150
    19.299   258.324     0.150
    23.903    13.700     0.150
    24.497   570.319     0.150
    24.497  2303.969     0.150
    24.892   321.594     0.150
    25.101   583.449     0.150
    25.103   322.854     0.150
    25.443   325.674     0.150
    25.546   327.094     0.150
    25.825   330.004     0.150
    25.825   329.974     0.150
    26.286   323.974     0.150
    26.286   379.974     0.150
    26.286   394.974     0.150
    26.302   336.174     0.150
    26.576   335.510     0.150
    26.790   342.224     0.150
    27.274   340.474     0.150
    27.351   341.114     0.150
    27.351     1.840     0.150
    27.351   617.694     0.150
    27.351   985.354     0.150
    27.830   349.544     0.150
    27.958   350.904     0.150
    27.958   347.740     0.150
    27.958   627.666     0.150
    27.958   347.734     0.150
    27.958   627.654     0.150
    27.958   988.874     0.150
    27.958   347.774     0.150
    27.958   627.674     0.150
    27.958   988.874     0.150
    28.102   349.361     0.150
    28.415   355.864     0.150
    28.822   358.054     0.150
    28.822   358.074     0.150
    28.827   357.624     0.150
    29.623   364.174     0.150
    29.822   364.574     0.150
    30.105   367.364     0.150
    30.105   367.374     0.150
    30.821     2.300     0.150
    31.708   378.174     0.150
    31.959   382.274     0.150
    31.931   383.474     0.150
    31.990     1.390     0.150
    32.600   391.954     0.150
    32.679  2267.974     0.150
    32.824   389.054     0.150
    32.824   389.074     0.150
    32.859   391.474     0.150
    33.084   394.304     0.150
    33.268   395.964     0.150
    33.268   395.974     0.150
    33.290   396.124     0.150
    33.597   396.274     0.150
    33.608   398.174     0.150
    33.608   398.174     0.150
    33.608   398.824     0.150
    33.751   408.474     0.150
    33.751   734.974     0.150
    33.764   398.974     0.150
    33.764   711.974     0.150
    33.842   484.174     0.150
    34.559   406.474     0.150
    34.603   405.874     0.150
    34.613   406.274     0.150
    35.153   409.274     0.150
    35.160   411.546     0.150
    35.195     5.416     0.150
    35.544  1025.814     0.150
    35.544   512.474     0.150
    35.544   880.274     0.150
    35.706   557.374     0.150
    35.777   489.974     0.150
    35.777   911.974     0.150
    35.750   416.274     0.150
    35.786   418.004     0.150
    35.821     7.970     0.150
    35.852   420.414     0.150
    35.852   420.374     0.150
    36.107   419.774     0.150
    36.273   420.944     0.150
    36.410     8.270     0.150
    36.426     7.810     0.150
    36.535   423.994     0.150
    36.535     7.210     0.150
    36.652   423.874     0.150
    36.766   426.474     0.150
    37.157   428.620     0.150
    37.192   427.474     0.150
    37.191   426.274     0.150
    37.191   428.809     0.150
    37.191   426.264     0.150
    37.191   773.394     0.150
    37.191  1037.514     0.150
    37.191   426.274     0.150
    37.191    10.300     0.150
    37.191   773.374     0.150
    37.191  1037.474     0.150
    37.287   428.474     0.150
    37.526   430.414     0.150
    38.055   436.243     0.150
    38.165   437.594     0.150
    38.172   436.184     0.150
    38.238   435.344     0.150
    38.515   441.504     0.150
    38.515   441.474     0.150
    38.878   438.394     0.150
    39.025   443.674     0.150
    40.005   443.874     0.150
    40.339   453.944     0.150
    40.473   449.834     0.150
    41.280   460.074     0.150
    41.333   463.074     0.150
    41.655   463.224     0.150
    41.880  1066.264     0.150
    42.265   469.374     0.150
    42.860   473.784     0.150
    42.965  3239.270     0.150
    42.971  3241.047     0.150
    42.983  3240.287     0.150
    43.073   476.234     0.150
    43.073   476.274     0.150
    43.479   584.718     0.150
    43.479   862.893     0.150
    44.134  3343.978     0.150
    44.147  3345.002     0.150
    44.151  3345.397     0.150
    44.468   892.874     0.150
    44.546     8.200     0.150
    44.546    12.900     0.150
    44.546   486.274     0.150
    45.751   495.774     0.150
    45.974   498.314     0.150
    46.009   498.574     0.150
    46.357   514.974     0.150
    46.357   500.774     0.150
    46.357   514.974     0.150
    46.453   502.474     0.150
    46.645   518.974     0.150
    46.645   504.174     0.150
    46.645   518.974     0.150
    46.864   504.474     0.150
    47.145   506.474     0.150
    47.349    11.000     0.150
    47.347   508.874     0.150
    47.627   511.574     0.150
    47.602   512.474     0.150
    48.628   518.574     0.150
    48.962   521.674     0.150
    49.200   523.174     0.150
    49.200     7.960     0.150
    49.591   526.274     0.150
    49.829   527.754     0.150
    50.307   840.616     0.150
    50.307   532.374     0.150
    50.307   532.374     0.150
    50.351   531.574     0.150
    50.986   537.484     0.150
    51.010   537.304     0.150
    51.136   537.374     0.150
    51.407   539.974     0.150
    51.677   542.364     0.150
    51.644   542.574     0.150
    52.006   544.174     0.150
    52.785    13.100     0.150
    52.766   548.964     0.150
    52.906   549.974     0.150
    52.998   551.714     0.150
    52.998   550.474     0.150
    52.998   566.074     0.150
    53.430   554.974     0.150
    54.084   559.594     0.150
    54.084   559.674     0.150
    54.380   561.174     0.150
    54.553   559.464     0.150
    54.651   563.574     0.150
    54.824   567.154     0.150
    54.957    13.600     0.150
    54.977   565.774     0.150
    55.133   567.074     0.150
    55.513   569.254     0.150
    55.513   569.274     0.150
    56.074   574.474     0.150
    56.124   573.784     0.150
    56.189   573.474     0.150
    56.283   575.574     0.150
    56.604   579.574     0.150
    56.822    10.300     0.150
    56.822   700.974     0.150
    56.822  1042.874     0.150
    56.794   578.274     0.150
    57.206    13.900     0.150
    57.206  1073.374     0.150
    57.391   717.374     0.150
    58.652  1072.774     0.150
    58.713    11.600     0.150
    58.713    16.400     0.150
    58.807  1089.674     0.150
    58.967   594.754     0.150
    59.317    10.800     0.150
    59.317    14.300     0.150
    59.695   601.544     0.150
    62.710   618.974     0.150
    63.288     9.900     0.150
    63.288   662.874     0.150
    63.490  1377.274     0.150
    63.717   857.874     0.150
    63.863    10.200     0.150
    63.863    14.200     0.150
    63.864   626.874     0.150
    63.864    15.300     0.150
    63.906  2351.149     0.150
    64.103   629.944     0.150
    64.194   629.374     0.150
    64.395     7.300     0.150
    64.395    11.000     0.150
    64.395  1158.074     0.150
    64.508   632.774     0.150
    64.508   632.004     0.150
    64.508   631.974     0.150
    64.554   631.494     0.150
    64.554  2360.394     0.150
    64.554   631.574     0.150
    64.554  1402.974     0.150
    64.874    11.600     0.150
    64.874    15.300     0.150
    64.874  1147.974     0.150
    64.980   634.774     0.150
    65.500   638.374     0.150
    65.718   638.044     0.150
    65.811   638.214     0.150
    65.811   638.174     0.150
    65.779  4902.574     0.150
    66.325   642.944     0.150
    67.960   653.904     0.150
    68.463    13.600     0.150
    68.548   658.774     0.150
    68.659   673.774     0.150
    68.659   658.774     0.150
    68.659   673.774     0.150
    68.716   654.574     0.150
    68.716   671.074     0.150
    68.716  1213.874     0.150
    69.309   658.474     0.150
    69.309  1196.574     0.150
    69.443  2344.333     0.150
    69.443   662.274     0.150
    69.443   682.574     0.150
    69.443  1193.774     0.150
    69.599   680.174     0.150
    69.599   664.274     0.150
    69.599   680.174     0.150
    70.260   683.374     0.150
    70.260   667.874     0.150
    70.260   683.374     0.150
    70.392    12.300     0.150
    70.392    22.700     0.150
    70.392  1490.874     0.150
    70.377   666.974     0.150
    70.403   668.644     0.150
    70.457   674.074     0.150
    70.457  5252.174     0.150
    70.709   672.134     0.150
    70.730  1225.974     0.150
    70.730   669.974     0.150
    70.730  1225.974     0.150
    70.722   675.874     0.150
    70.722  5272.074     0.150
    70.910   682.904     0.150
    71.390  1240.074     0.150
    71.390   674.174     0.150
    71.390    14.800     0.150
    71.515   675.834     0.150
    71.515   675.784     0.150
    71.515   675.774     0.150
    71.618   673.754     0.150
    71.647   691.374     0.150
    71.759   672.324     0.150
    71.951   689.974     0.150
    73.761   700.064     0.150
    71.983   670.044     0.150
    72.644   696.774     0.150
    72.804   688.074     0.150
    72.811   688.474     0.150
    72.811  5428.974     0.150
    72.882   688.774     0.150
    72.882  5433.874     0.150
    73.037  5445.574     0.150
    73.297   689.774     0.150
    73.590    11.200     0.150
    73.590   850.074     0.150
    73.607   688.474     0.150
    73.607   703.874     0.150
    73.607   688.474     0.150
    73.607   703.874     0.150
    73.999   845.974     0.150
    73.999  1312.974     0.150
    73.999  1757.974     0.150
    73.999  1865.974     0.150
    73.999   690.474     0.150
    73.999   705.874     0.150
    74.070  1561.441     0.150
    74.182   692.524     0.150
    74.314   696.374     0.150
    74.314    14.800     0.150
    74.314  1301.074     0.150
    74.439  2341.174     0.150
    74.439   692.374     0.150
    74.439   707.674     0.150
    74.501     9.400     0.150
    74.471   693.474     0.150
    74.471   709.374     0.150
    74.471  1321.974     0.150
    74.570    15.200     0.150
    74.838   695.774     0.150
    74.900   696.074     0.150
    74.900  1298.374     0.150
    75.047   697.074     0.150
    75.047   712.874     0.150
    75.047   718.774     0.150
    75.064   697.374     0.150
    75.064   713.374     0.150
    75.179   698.154     0.150
    75.179   698.174     0.150
    75.230   697.834     0.150
    75.230   697.874     0.150
    75.230    14.900     0.150
    75.291   698.474     0.150
    75.348   698.874     0.150
    75.348   714.774     0.150
    75.377     9.000     0.150
    75.377   698.874     0.150
    75.377   707.874     0.150
    75.377   714.774     0.150
    75.377   720.974     0.150
    75.459   699.374     0.150
    75.524   700.074     0.150
    75.564   697.674     0.150
    75.564   970.474     0.150
    75.606     8.700     0.150
    75.606   700.174     0.150
    75.606   708.874     0.150
    75.606   715.574     0.150
    75.606   721.974     0.150
    75.659   700.274     0.150
    75.786   701.474     0.150
    75.786  1282.074     0.150
    75.890  1282.374     0.150
    75.890   703.374     0.150
    76.024   703.374     0.150
    76.024   719.474     0.150
    76.030   702.874     0.150
    76.030    15.000     0.150
    76.197   703.884     0.150
    76.197   703.874     0.150
    76.300   705.174     0.150
    76.300   720.974     0.150
    76.311   704.174     0.150
    76.488   705.174     0.150
    76.488    15.800     0.150
    76.493   705.474     0.150
    76.525   704.874     0.150
    76.686   706.224     0.150
    76.686   706.174     0.150
    76.795   715.674     0.150
    76.795   873.174     0.150
    76.795  1344.974     0.150
    76.795  1784.574     0.150
    76.922   708.274     0.150
    76.922   724.274     0.150
    77.234   709.574     0.150
    77.345   711.064     0.150
    77.533   710.574     0.150
    77.799   712.774     0.150
    78.154   729.974     0.150
    78.154  1302.974     0.150
    78.154  1331.974     0.150
    78.154  1637.974     0.150
    78.154  1857.974     0.150
    78.154   713.974     0.150
    78.154   729.974     0.150
    78.154   888.974     0.150
    78.154  1302.974     0.150
    78.154  1331.974     0.150
    78.516  5856.174     0.150
    78.746   733.694     0.150
    78.814   710.174     0.150
    78.929   719.474     0.150
    79.318   736.044     0.150
    79.361   721.474     0.150
    79.500   895.174     0.150
    79.553   722.765     0.150
    79.553   722.574     0.150
    79.553  1012.674     0.150
    79.700   723.074     0.150
    79.740  1312.674     0.150
    79.800   724.874     0.150
    79.816   723.574     0.150
    79.875   723.874     0.150
    79.881   739.344     0.150
    80.381  1022.374     0.150
    80.381  1847.774     0.150
    80.478   720.374     0.150
    80.651   729.634     0.150
    80.683   728.274     0.150
    80.709   728.174     0.150
    80.742   728.374     0.150
    80.749   729.174     0.150
    80.730  6023.573     0.150
    80.765   727.874     0.150
    81.009   730.874     0.150
    81.054   729.164     0.150
    81.099   730.704     0.150
    81.153   730.374     0.150
    81.350   732.174     0.150
    81.888   735.474     0.150
    81.931   733.324     0.150
    82.264   733.394     0.150
    82.256  1356.074     0.150
    82.377   731.904     0.150
    82.483   733.394     0.150
    82.570   735.274     0.150
    82.691   731.064     0.150
    82.811   739.074     0.150
    82.811   738.674     0.150
    82.880   741.465     0.150
    83.021   740.274     0.150
    83.021   740.274     0.150
    83.021   740.274     0.150
    83.044   732.574     0.150
    83.238   742.074     0.150
    83.384   738.574     0.150
    83.466   743.474     0.150
    83.466   743.474     0.150
    83.536   743.774     0.150
    83.536  1362.674     0.150
    83.697   744.474     0.150
    83.796   744.574     0.150
    83.811   743.204     0.150
    84.031   746.074     0.150
    84.037   742.654     0.150
    84.096   746.574     0.150
    84.096   746.574     0.150
    84.103   746.274     0.150
    84.249   743.274     0.150
    84.247   746.974     0.150
    84.247   746.974     0.150
    84.272   748.274     0.150
    84.272   748.274     0.150
    84.272   748.274     0.150
    84.360   747.474     0.150
    84.393   747.374     0.150
    84.393   747.374     0.150
    84.463   748.174     0.150
    84.463   748.174     0.150
    84.574   748.174     0.150
    84.574   748.174     0.150
    84.578   748.874     0.150
    84.578  1369.474     0.150
    84.654   748.374     0.150
    84.654   748.374     0.150
    84.774   748.574     0.150
    84.774   748.574     0.150
    84.805   749.474     0.150
    84.842   749.374     0.150
    84.903   751.194     0.150
    84.903   751.174     0.150
    84.998   751.274     0.150
    84.998   751.274     0.150
    84.998  1372.374     0.150
    85.018   750.074     0.150
    85.018   750.074     0.150
    85.040   750.874     0.150
    85.040   750.874     0.150
    85.125   750.574     0.150
    85.125   750.574     0.150
    85.185   748.644     0.150
    85.316   752.074     0.150
    85.316   752.074     0.150
    85.429   752.774     0.150
    85.457   748.594     0.150
    85.457   752.474     0.150
    85.457   752.474     0.150
    85.660   750.634     0.150
    85.736   754.474     0.150
    85.786   754.974     0.150
    85.786   754.974     0.150
    85.914   755.074     0.150
    85.914   755.074     0.150
    85.942   751.764     0.150
    85.996   754.574     0.150
    86.027   755.374     0.150
    86.027   755.374     0.150
    86.031   754.974     0.150
    86.077   752.934     0.150
    86.082   755.774     0.150
    86.090   755.474     0.150
    86.205   755.874     0.150
    86.302   753.464     0.150
    86.306   757.274     0.150
    86.344   758.054     0.150
    86.396   757.074     0.150
    86.512   758.474     0.150
    86.654   758.474     0.150
    86.751   757.974     0.150
    86.980   752.254     0.150
    87.002   758.874     0.150
    87.030   759.974     0.150
    87.146   761.314     0.150
    87.146   761.274     0.150
    87.184   761.674     0.150
    87.266   761.474     0.150
    87.266   761.474     0.150
    87.325   763.174     0.150
    87.325   763.174     0.150
    87.375   762.774     0.150
    87.377   762.374     0.150
    87.378   759.974     0.150
    87.378   759.974     0.150
    87.402     9.360     0.150
    87.402   762.774     0.150
    87.402     9.400     0.150
    87.406   761.074     0.150
    87.406   761.074     0.150
    87.409   761.074     0.150
    87.480   762.374     0.150
    87.510   758.044     0.150
    87.512   758.264     0.150
    87.523   761.774     0.150
    87.527   762.474     0.150
    87.886   762.474     0.150
    87.977   761.644     0.150
    88.044   765.274     0.150
    88.238     8.110     0.150
    88.233   764.674     0.150
    88.233   764.674     0.150
    88.243   765.774     0.150
    88.380   767.934     0.150
    88.530   766.574     0.150
    88.550   764.544     0.150
    88.680   766.574     0.150
    88.760    15.780     0.150
    88.760   992.224     0.150
    88.802   765.684     0.150
    88.886   768.774     0.150
    88.930   768.274     0.150
    88.930   768.274     0.150
    89.307   773.974     0.150
    89.283   771.774     0.150
    89.519   770.874     0.150
    89.659   769.874     0.150
    89.659   769.874     0.150
    90.029   773.074     0.150
    90.029   773.074     0.150
    90.144   774.574     0.150
    90.310   775.574     0.150
    90.517   776.474     0.150
    90.824   779.074     0.150
    92.355  1418.704     0.150
    92.356  1025.974     0.150
    92.742  1011.724     0.150
    92.815   786.874     0.150
    93.924   792.474     0.150
   101.671   827.674     0.150
   115.333  1746.974     0.150
   124.462  1135.474     0.150
   125.088  1135.574     0.150
   125.088  1241.974     0.150
   134.239  1150.824     0.150
   134.239  1150.874     0.150
   134.239  1162.074     0.150
   138.046  1159.954     0.150
   138.046  1325.434     0.150
   138.438  1161.274     0.150
   139.876  1155.618     0.150
   148.999  1183.074     0.150
   153.390  1184.354     0.150
   153.390  1193.124     0.150
   153.390  1184.374     0.150
   153.390  1185.874     0.150
   153.390  1193.174     0.150
   163.164  1187.574     0.150
   163.734  1260.874     0.150
     1.516    26.413     0.150
     2.488    70.853     0.150
     2.522    44.103     0.150
     2.530    43.603     0.150
     2.550    44.413     0.150
     3.146    52.733     0.150
     3.303    53.923     0.150
     3.318    55.103     0.150
     3.680    58.643     0.150
     3.748    60.533     0.150
     3.905    63.103     0.150
     3.943    63.163     0.150
     4.720   118.513     0.150
     5.621    82.783     0.150
     9.525   131.343     0.150
    11.493   304.283     0.150
    12.135   291.588     0.150
    12.135   291.583     0.150
    18.470   250.573     0.150
    24.471   318.933     0.150
    25.238   324.303     0.150
    32.878   388.953     0.150
    42.839  3239.559     0.150
    42.845  3241.350     0.150
    42.857  3243.220     0.150
    44.006  3323.728     0.150
    44.019  3325.428     0.150
    44.023  3323.728     0.150
    54.548   627.973     0.150
    55.982   572.453     0.150
    55.982   572.452     0.150
    64.398   632.113     0.150
    76.692   707.253     0.150
    83.833   744.987     0.150
     0.938    31.586     0.150
     2.092    62.926     0.150
     2.342    68.406     0.150
     2.540    72.566     0.150
    18.326   248.266     0.150
    18.326   453.466     0.150
    24.433   315.386     0.150
    42.953  3234.199     0.150
    42.959  3237.788     0.150
    42.971  3241.380     0.150
    44.121  3324.927     0.150
    44.134  3323.227     0.150
    44.138  3327.762     0.150
    50.330   534.406     0.150
    54.456   626.146     0.150
    64.230   629.336     0.150
    76.524   704.996     0.150
    81.061   732.086     0.150
    81.061   732.086     0.150
     0.365    15.236     0.150
     0.412    15.537     0.150
     0.451    15.697     0.150
     0.751    17.357     0.150
     0.951    23.098     0.150
     1.117    40.627     0.150
     1.746    32.377     0.150
     1.829    33.348     0.150
     2.145    36.357     0.150
     2.160    66.387     0.150
     2.195    70.076     0.150
     2.238    38.637     0.150
     2.269    39.107     0.150
     2.269    73.277     0.150
     3.062    91.576     0.150
     3.398    53.357     0.150
     3.418    54.926     0.150
     4.089   111.336     0.150
     4.515    68.557     0.150
     4.591    69.746     0.150
     5.270    71.236     0.150
     5.270    73.066     0.150
     5.270    73.736     0.150
     5.326    77.996     0.150
     6.286    94.977     0.150
     6.658   184.047     0.150
     6.965   102.076     0.150
     7.323   108.146     0.150
     7.408   110.197     0.150
     7.760   201.926     0.150
     7.843   116.637     0.150
     7.843   116.637     0.150
     8.194   119.896     0.150
     8.734   127.518     0.150
     8.734   127.438     0.150
     9.131   134.197     0.150
     9.167   129.637     0.150
     9.548   140.256     0.150
     9.751   141.996     0.150
     9.845   141.977     0.150
     9.971   145.006     0.150
    10.027   144.676     0.150
    10.049   145.717     0.150
    10.286   143.027     0.150
    10.800   157.598     0.150
    11.058   158.316     0.150
    11.271   160.697     0.150
    11.385   164.377     0.150
    11.633   166.527     0.150
    11.633   296.637     0.150
    11.633   163.787     0.150
    12.049   176.256     0.150
    14.421   200.688     0.150
    17.166   232.986     0.150
    18.013   246.188     0.150
    19.401   269.037     0.150
    19.401   285.236     0.150
    19.401   518.137     0.150
    24.319   315.861     0.150
    24.319   531.412     0.150
    24.319   317.037     0.150
    24.496   312.881     0.150
    24.496   529.781     0.150
    24.496   743.631     0.150
    25.569   329.836     0.150
    25.609   331.188     0.150
    26.318   336.117     0.150
    26.484   337.438     0.150
    28.721   356.574     0.150
    29.001   360.256     0.150
    30.384   372.387     0.150
    32.054   387.037     0.150
    32.077   386.047     0.150
    32.166   388.457     0.150
    32.576   390.297     0.150
    32.576   551.996     0.150
    32.576   390.336     0.150
    32.614   391.986     0.150
    33.065   409.137     0.150
    33.116   398.938     0.150
    33.293   388.611     0.150
    33.293   550.762     0.150
    33.412   399.197     0.150
    34.122   405.607     0.150
    34.540   408.836     0.150
    34.540   776.197     0.150
    34.751   408.336     0.150
    34.751   424.938     0.150
    35.151   414.207     0.150
    35.312   415.537     0.150
    35.312   407.188     0.150
    36.669   427.076     0.150
    36.714   425.541     0.150
    36.949   429.977     0.150
    36.988   430.576     0.150
    37.058   426.922     0.150
    37.407   431.410     0.150
    37.524   434.080     0.150
    37.588   435.576     0.150
    37.601   433.119     0.150
    37.819   438.438     0.150
    37.996   435.377     0.150
    38.341   439.643     0.150
    38.392   441.826     0.150
    38.470   433.461     0.150
    38.561   551.938     0.150
    38.561   568.236     0.150
    38.561   797.836     0.150
    38.561   991.336     0.150
    39.241   446.867     0.150
    39.525   449.299     0.150
    40.645   457.404     0.150
    40.759   461.707     0.150
    42.422   466.836     0.150
    42.648   477.357     0.150
    43.513   481.775     0.150
    43.675   482.037     0.150
    43.675   497.637     0.150
    43.899   484.438     0.150
    43.987   486.098     0.150
    44.249  3321.504     0.150
    44.252  3327.930     0.150
    44.549   490.658     0.150
    45.060   494.742     0.150
    45.115   494.742     0.150
    45.269   495.809     0.150
    45.293   496.381     0.150
    45.422   496.887     0.150
    45.683   499.707     0.150
    45.683   501.736     0.150
    45.731   499.916     0.150
    45.802   498.438     0.150
    45.813   500.498     0.150
    46.164   502.311     0.150
    46.194   501.736     0.150
    46.415   504.986     0.150
    46.445   505.086     0.150
    46.446   504.820     0.150
    46.566   506.090     0.150
    46.686   508.137     0.150
    46.856   508.555     0.150
    46.925   510.656     0.150
    47.294   509.438     0.150
    47.294   520.236     0.150
    47.294   509.438     0.150
    47.294   520.236     0.150
    47.697   513.930     0.150
    47.825   515.287     0.150
    48.174   510.387     0.150
    48.174   598.787     0.150
    48.349   519.605     0.150
    48.595   521.377     0.150
    49.487   526.688     0.150
    49.495   531.457     0.150
    49.759   526.236     0.150
    50.093   534.477     0.150
    52.209   549.518     0.150
    52.209   549.438     0.150
    52.209   550.037     0.150
    52.209  1007.537     0.150
    53.288   557.537     0.150
    53.319   557.656     0.150
    53.319   622.666     0.150
    53.319   557.736     0.150
    53.388   558.637     0.150
    53.641   559.848     0.150
    53.654   560.336     0.150
    55.092   570.736     0.150
    56.111     8.400     0.150
    58.137   591.887     0.150
    58.137   592.312     0.150
    58.137   641.287     0.150
    58.705   597.037     0.150
    62.601     9.500     0.150
    62.917   624.037     0.150
    63.089   625.812     0.150
    63.109    10.900     0.150
    63.109    15.701     0.150
    63.172   624.986     0.150
    63.672     6.898     0.150
    63.672    11.000     0.150
    63.690   629.648     0.150
    63.693   629.637     0.150
    63.757   629.316     0.150
    63.757  1147.137     0.150
    63.757  1394.336     0.150
    64.890   637.137     0.150
    64.890   636.637     0.150
    64.890   637.012     0.150
    64.890   637.137     0.150
    64.905   636.457     0.150
    64.998   637.926     0.150
    67.764    15.100     0.150
    68.704   916.438     0.150
    69.404   665.762     0.150
    69.733     9.801     0.150
    70.003   669.617     0.150
    72.914   688.037     0.150
    73.372   688.137     0.150
    73.501   694.236     0.150
    73.501     9.701     0.150
    73.501  1264.336     0.150
    73.501  1551.037     0.150
    73.726   690.137     0.150
    73.838   691.938     0.150
    74.202   693.836     0.150
    74.255   694.236     0.150
    74.418   695.236     0.150
    74.418   706.236     0.150
    74.418   710.736     0.150
    74.741   696.637     0.150
    74.741   696.637     0.150
    74.822   696.938     0.150
    74.822   696.938     0.150
    74.949   698.438     0.150
    74.949   709.137     0.150
    75.104   699.736     0.150
    75.351   701.037     0.150
    75.465   701.736     0.150
    75.568   701.836     0.150
    75.636   702.736     0.150
    75.813   703.537     0.150
    75.862   703.537     0.150
    75.862   703.537     0.150
    76.296   706.137     0.150
    76.295   705.836     0.150
    76.833   709.125     0.150
    76.867   709.637     0.150
    77.031   710.037     0.150
    77.278   711.205     0.150
    77.920   715.387     0.150
    77.944   714.938     0.150
    77.995   716.037     0.150
    78.162   712.787     0.150
    78.220   716.723     0.150
    78.579   718.438     0.150
    79.115   722.037     0.150
    79.144   721.537     0.150
    79.212   722.736     0.150
    79.298   722.336     0.150
    80.595   729.438     0.150
    80.812   730.537     0.150
    80.808   730.236     0.150
    81.109   733.836     0.150
    81.161   732.137     0.150
    81.428   733.736     0.150
    81.802   735.137     0.150
    81.948   736.137     0.150
    82.309   736.637     0.150
    82.355   738.037     0.150
    82.385   738.836     0.150
    82.951   740.836     0.150
    83.143   742.057     0.150
    83.158   742.162     0.150
    83.273   742.537     0.150
    83.512   743.836     0.150
    83.637   745.037     0.150
    83.812   745.438     0.150
    84.051   746.938     0.150
    84.541   749.836     0.150
    84.661   750.438     0.150
    84.773   751.736     0.150
    88.636   770.137     0.150
    92.765   784.537     0.150
    92.765   783.836     0.150
    96.151   799.836     0.150
   122.714  1125.711     0.150
   152.643  1190.736     0.150
     1.687    52.020     0.150
     2.042    61.762     0.150
     3.189    88.312     0.150
     3.540    55.562     0.150
     3.609    56.570     0.150
     3.951    59.473     0.150
     4.608   122.301     0.150
     5.204   136.262     0.150
     7.782   111.102     0.150
     8.243   117.699     0.150
     8.567   124.609     0.150
     8.578   124.840     0.150
     8.995   221.691     0.150
    10.306   143.000     0.150
    10.534   146.812     0.150
    11.102   153.711     0.150
    11.102   153.742     0.150
    11.342   158.320     0.150
    15.127   211.492     0.150
    16.994   235.180     0.150
    16.994   421.062     0.150
    18.255   246.211     0.150
    18.255   246.160     0.150
    18.255   450.961     0.150
    23.845   311.172     0.150
    23.894   312.312     0.150
    23.894   312.320     0.150
    24.348   313.012     0.150
    24.348   531.812     0.150
    24.481   575.855     0.150
    24.481  2303.855     0.150
    24.468   317.000     0.150
    24.595   318.109     0.150
    25.150   323.531     0.150
    25.406   326.070     0.150
    25.435   324.609     0.150
    25.435   324.590     0.150
    25.490   326.211     0.150
    25.490   326.160     0.150
    25.597   324.883     0.150
    25.880   332.512     0.150
    25.880   332.492     0.150
    26.232   329.039     0.150
    26.230   325.109     0.150
    26.230   391.211     0.150
    26.627   335.539     0.150
    26.652   338.211     0.150
    26.652   338.242     0.150
    27.022   340.801     0.150
    27.389   341.871     0.150
    28.019   540.352     0.150
    28.019   630.949     0.150
    28.481   353.242     0.150
    28.885   355.590     0.150
    29.690   360.789     0.150
    30.169   366.199     0.150
    31.731   379.520     0.150
    31.997   381.609     0.150
    32.184     5.203     0.150
    32.184   384.590     0.150
    32.184     5.199     0.150
    32.912   391.289     0.150
    33.124   394.141     0.150
    33.297  2263.621     0.150
    33.297  2263.621     0.150
    33.307   395.570     0.150
    33.586   397.211     0.150
    33.586   468.391     0.150
    33.656   397.652     0.150
    34.146   403.980     0.150
    34.664   406.820     0.150
    34.667   406.262     0.150
    34.886  2259.160     0.150
    34.938   408.910     0.150
    34.938   408.883     0.150
    35.141   408.910     0.150
    35.455   510.012     0.150
    35.455   734.609     0.150
    35.455   887.512     0.150
    35.655   409.512     0.150
    35.655   741.109     0.150
    35.718   512.812     0.150
    35.718   882.211     0.150
    35.815   416.152     0.150
    35.919   417.383     0.150
    36.161   420.133     0.150
    36.703   424.191     0.150
    36.821   426.121     0.150
    36.829   425.320     0.150
    36.861   425.797     0.150
    37.225   427.383     0.150
    37.257   427.930     0.150
    37.257   775.891     0.150
    37.257   788.609     0.150
    38.053   436.672     0.150
    38.263   568.086     0.150
    38.263   784.438     0.150
    38.263   435.531     0.150
    38.263   568.082     0.150
    38.263   784.430     0.150
    38.580   439.711     0.150
    38.580   439.680     0.150
    38.580   794.199     0.150
    38.716   441.172     0.150
    39.150   552.312     0.150
    39.150   799.609     0.150
    40.519   454.852     0.150
    40.523   455.281     0.150
    41.220   459.109     0.150
    41.315   461.871     0.150
    41.394   463.270     0.150
    41.932   467.070     0.150
    41.932   581.883     0.150
    41.932   806.730     0.150
    42.287   471.762     0.150
    43.110   474.211     0.150
    43.110   474.211     0.150
    43.110   584.289     0.150
    44.479     9.000     0.150
    44.479    12.902     0.150
    44.710   486.082     0.150
    44.973   892.012     0.150
    45.954   513.211     0.150
    45.954   497.109     0.150
    46.245   500.520     0.150
    46.283   512.512     0.150
    46.283   499.609     0.150
    46.581   519.312     0.150
    46.581   503.109     0.150
    46.496   502.602     0.150
    46.786   503.680     0.150
    47.280    12.699     0.150
    47.575   527.109     0.150
    47.575   510.711     0.150
    47.873   512.473     0.150
    48.100   535.812     0.150
    48.655   518.840     0.150
    49.012   521.812     0.150
    49.012   521.832     0.150
    49.221   523.051     0.150
    49.622   642.312     0.150
    49.622   953.812     0.150
    49.622   967.812     0.150
    49.807   527.332     0.150
    49.808   527.871     0.150
    50.248   531.512     0.150
    50.248   609.910     0.150
    50.248   531.461     0.150
    50.248   609.859     0.150
    50.373   531.633     0.150
    50.926   536.883     0.150
    51.039   537.133     0.150
    51.159   537.391     0.150
    51.337   555.609     0.150
    51.337   538.812     0.150
    51.690   542.250     0.150
    51.777   542.402     0.150
    52.038   543.883     0.150
    52.719    17.801     0.150
    52.910  1008.012     0.150
    53.126    10.129     0.150
    53.382   554.211     0.150
    54.001   558.395     0.150
    54.001   558.395     0.150
    54.337   561.211     0.150
    54.337   625.910     0.150
    54.404   560.980     0.150
    54.617   571.902     0.150
    54.886     8.500     0.150
    54.886    13.000     0.150
    54.905   564.082     0.150
    55.151   566.973     0.150
    55.425   568.039     0.150
    55.667   587.133     0.150
    55.689   581.551     0.150
    55.934   573.051     0.150
    56.075   573.531     0.150
    56.145   573.473     0.150
    56.215   572.961     0.150
    56.894   578.672     0.150
    57.138    16.000     0.150
    57.302   714.211     0.150
    57.302  1052.211     0.150
    57.302  1073.211     0.150
    58.580    15.199     0.150
    58.580   718.512     0.150
    58.713   813.910     0.150
    58.860  2370.812     0.150
    58.860   592.711     0.150
    59.085   610.082     0.150
    59.255    17.199     0.150
    59.255  1084.910     0.150
    59.757   602.391     0.150
    60.653   618.781     0.150
    61.859   629.121     0.150
    62.389   633.172     0.150
    62.660   618.551     0.150
    62.744   636.992     0.150
    62.911  1124.609     0.150
    63.180   639.430     0.150
    63.216    12.000     0.150
    63.216    16.102     0.150
    63.380   621.441     0.150
    63.693   642.852     0.150
    63.703   625.949     0.150
    63.694   642.461     0.150
    63.777   625.711     0.150
    63.781    11.801     0.150
    63.781    16.301     0.150
    64.112   628.312     0.150
    64.296   647.430     0.150
    64.410  2845.121     0.150
    64.405   648.262     0.150
    64.458   630.281     0.150
    64.819   629.109     0.150
    64.819    13.203     0.150
    64.819    17.801     0.150
    64.970   651.000     0.150
    65.420   653.859     0.150
    65.443   655.152     0.150
    65.560   655.039     0.150
    65.609  2850.859     0.150
    65.625   636.910     0.150
    65.718   637.711     0.150
    65.852   673.711     0.150
    65.871   656.473     0.150
    65.874   652.410     0.150
    65.874  1171.711     0.150
    65.874  1423.711     0.150
    65.874  4901.609     0.150
    65.874     0.359     0.150
    66.575   661.711     0.150
    66.729   662.582     0.150
    68.389    16.398     0.150
    68.466  2348.188     0.150
    68.579   674.410     0.150
    68.579   657.812     0.150
    69.250   658.512     0.150
    69.250  1199.211     0.150
    69.518   679.812     0.150
    69.518   662.910     0.150
    69.751   662.301     0.150
    70.177   683.711     0.150
    70.177   666.711     0.150
    70.177   683.711     0.150
    70.243   666.090     0.150
    70.309   666.961     0.150
    70.309  1217.242     0.150
    70.324    11.602     0.150
    70.642   669.211     0.150
    70.642   696.211     0.150
    70.642   922.211     0.150
    70.642  1216.211     0.150
    70.642  1246.211     0.150
    70.642   669.211     0.150
    70.642   669.211     0.150
    70.642   696.211     0.150
    70.642   826.211     0.150
    70.642   922.211     0.150
    70.642  1216.211     0.150
    70.642  1246.211     0.150
    70.550   682.910     0.150
    70.550  5257.812     0.150
    70.815   684.211     0.150
    70.815  5277.312     0.150
    71.303   673.109     0.150
    71.303   690.012     0.150
    71.304   674.090     0.150
    71.421   675.551     0.150
    71.555   691.109     0.150
    71.858  1236.211     0.150
    72.313   680.852     0.150
    72.896   696.812     0.150
    72.896  5434.910     0.150
    72.903   696.910     0.150
    72.903  5435.512     0.150
    73.076   684.723     0.150
    72.974   697.109     0.150
    72.974  5440.711     0.150
    73.119   685.672     0.150
    73.129   698.410     0.150
    73.129  5452.211     0.150
    73.350   686.410     0.150
    73.350   686.410     0.150
    73.521   687.492     0.150
    73.521   687.512     0.150
    73.521   704.410     0.150
    73.519    12.000     0.150
    73.519   852.012     0.150
    73.372   686.480     0.150
    73.917  1278.211     0.150
    73.917  1355.211     0.150
    73.917  1558.211     0.150
    73.917  1768.211     0.150
    73.917  1840.211     0.150
    73.917  2356.211     0.150
    73.917   689.410     0.150
    73.917   706.812     0.150
    73.917  1258.211     0.150
    73.917   688.012     0.150
    74.087   688.500     0.150
    74.221   695.512     0.150
    74.221    13.199     0.150
    74.221    18.598     0.150
    74.349   691.332     0.150
    74.357   691.262     0.150
    74.388   692.410     0.150
    74.388    17.500     0.150
    74.487   692.812     0.150
    74.487   710.012     0.150
    74.755   695.012     0.150
    74.755   708.512     0.150
    74.816   695.012     0.150
    74.816    17.301     0.150
    74.718   695.891     0.150
    74.965   696.312     0.150
    74.965    12.000     0.150
    74.980   696.211     0.150
    74.980    12.301     0.150
    75.029   697.773     0.150
    75.102   710.602     0.150
    75.102   697.152     0.150
    75.145   696.812     0.150
    75.145   713.512     0.150
    75.265   697.711     0.150
    75.265    11.898     0.150
    75.294   697.711     0.150
    75.294    12.301     0.150
    75.376   698.410     0.150
    75.376   711.312     0.150
    75.444   699.109     0.150
    75.477  1271.012     0.150
    75.521   699.109     0.150
    75.521    17.402     0.150
    75.575   699.289     0.150
    75.699   717.359     0.150
    75.699   700.410     0.150
    75.699   717.312     0.150
    75.808   702.102     0.150
    75.938   720.211     0.150
    75.938   702.312     0.150
    75.938   720.211     0.150
    75.945   718.973     0.150
    75.945   701.910     0.150
    75.945   719.012     0.150
    76.116   702.910     0.150
    76.116    12.199     0.150
    76.116   702.961     0.150
    76.215   720.910     0.150
    76.215   704.211     0.150
    76.215   720.910     0.150
    76.232   702.961     0.150
    76.232    12.840     0.150
    76.406   704.410     0.150
    76.406   704.242     0.150
    76.450   722.109     0.150
    76.450   704.711     0.150
    76.450   722.109     0.150
    76.708   722.312     0.150
    76.708   992.711     0.150
    76.708  1352.512     0.150
    76.708  1586.109     0.150
    76.837   707.711     0.150
    76.837   719.609     0.150
    76.837   724.910     0.150
    76.871   724.609     0.150
    76.871   706.910     0.150
    76.871   724.609     0.150
    76.880   706.910     0.150
    76.880   720.109     0.150
    76.880   725.109     0.150
    77.448   710.512     0.150
    77.448   710.492     0.150
    77.821   709.621     0.150
    77.906   713.734     0.150
    78.064   730.211     0.150
    78.064  1298.211     0.150
    78.064   713.211     0.150
    78.064   730.211     0.150
    78.064  1298.211     0.150
    78.064  1322.211     0.150
    78.064  1368.211     0.150
    78.327   715.812     0.150
    78.366   716.609     0.150
    78.448    18.176     0.150
    78.503   717.609     0.150
    79.083   720.109     0.150
    79.188   721.312     0.150
    79.286   719.902     0.150
    79.408   729.312     0.150
    79.408  1319.410     0.150
    79.459   721.512     0.150
    79.727   722.992     0.150
    79.723   709.312     0.150
    79.723   709.352     0.150
    80.287  1019.312     0.150
    80.287  1330.312     0.150
    80.287  1643.410     0.150
    80.383  1327.012     0.150
    80.599   727.211     0.150
    80.620   726.781     0.150
    80.654   728.410     0.150
    80.672   727.680     0.150
    80.672   727.352     0.150
    80.839   730.012     0.150
    80.914   732.668     0.150
    80.914   732.711     0.150
    80.963   729.410     0.150
    80.826  6020.910     0.150
    81.211   729.633     0.150
    81.255   732.012     0.150
    81.407   733.211     0.150
    81.557  1337.109     0.150
    81.793   735.012     0.150
    82.192   736.410     0.150
    82.785   740.680     0.150
    82.873   739.859     0.150
    82.936   739.312     0.150
    83.175   740.910     0.150
    83.321   741.609     0.150
    83.380   742.410     0.150
    83.380   742.410     0.150
    83.339   741.422     0.150
    83.339   741.512     0.150
    83.339   741.492     0.150
    83.474   742.312     0.150
    83.630   743.492     0.150
    83.733   744.211     0.150
    83.943   745.211     0.150
    84.009   745.609     0.150
    84.009   745.609     0.150
    84.018   745.660     0.150
    84.160   746.512     0.150
    84.160   746.512     0.150
    84.184   746.109     0.150
    84.184   746.109     0.150
    84.188  1386.910     0.150
    84.273   746.012     0.150
    84.304   746.609     0.150
    84.304   746.609     0.150
    84.333   746.812     0.150
    84.376   747.512     0.150
    84.376   747.512     0.150
    84.487   747.609     0.150
    84.487   747.609     0.150
    84.515   747.609     0.150
    84.568   747.512     0.150
    84.568   747.512     0.150
    84.461   746.609     0.150
    84.687   748.312     0.150
    84.687   748.312     0.150
    84.717   748.410     0.150
    84.754   748.609     0.150
    84.812   750.133     0.150
    84.865  2319.062     0.150
    84.931   748.711     0.150
    84.931   748.711     0.150
    84.953   749.711     0.150
    84.953   749.711     0.150
    84.935   749.512     0.150
    85.038   750.211     0.150
    85.038   750.211     0.150
    85.229   751.211     0.150
    85.229   751.211     0.150
    85.341   751.711     0.150
    85.357   751.711     0.150
    85.357   751.711     0.150
    85.238   749.070     0.150
    85.369   750.211     0.150
    85.369   750.211     0.150
    85.369   750.211     0.150
    85.567   754.012     0.150
    85.518   755.859     0.150
    85.651   753.410     0.150
    85.700   754.109     0.150
    85.700   754.109     0.150
    85.749   753.012     0.150
    85.829   754.312     0.150
    85.829   754.312     0.150
    85.909   754.312     0.150
    85.938   754.211     0.150
    85.938   754.211     0.150
    85.944   754.312     0.150
    85.994   754.812     0.150
    86.003   754.410     0.150
    86.118   755.711     0.150
    86.118   755.711     0.150
    86.219   756.312     0.150
    86.309   756.539     0.150
    86.425   757.410     0.150
    86.517   757.609     0.150
    86.569   757.609     0.150
    86.664   757.312     0.150
    86.805   758.812     0.150
    86.915   758.410     0.150
    86.943   759.312     0.150
    87.056   760.301     0.150
    87.097   760.609     0.150
    87.180   760.812     0.150
    87.180   760.812     0.150
    87.237   760.211     0.150
    87.288   761.910     0.150
    87.290   761.312     0.150
    87.291   760.109     0.150
    87.319   760.711     0.150
    87.319   760.711     0.150
    87.322   760.609     0.150
    87.435   760.910     0.150
    87.438   761.410     0.150
    87.425   762.109     0.150
    87.798   762.211     0.150
    87.916   764.410     0.150
    87.916   764.410     0.150
    87.957   764.410     0.150
    88.053   764.109     0.150
    88.145   763.109     0.150
    88.145   763.109     0.150
    88.157   765.410     0.150
    88.229   760.480     0.150
    88.353   766.109     0.150
    88.444   765.910     0.150
    88.593   766.109     0.150
    88.840   767.711     0.150
    88.840   767.711     0.150
    89.042   768.910     0.150
    89.205  1827.133     0.150
    89.431   770.812     0.150
    89.859   773.812     0.150
    89.859   773.812     0.150
    89.940   771.910     0.150
    89.940   771.910     0.150
    89.949   774.531     0.150
    90.055   772.012     0.150
    90.222   775.012     0.150
    93.439   790.891     0.150
    93.439   790.891     0.150
    94.511   795.180     0.150
    94.517   795.180     0.150
    94.672   795.891     0.150
    94.760   796.180     0.150
    95.089   798.188     0.150
    95.544   800.062     0.150
    95.650   801.320     0.150
    95.784   800.941     0.150
    96.116   802.520     0.150
    96.110   802.133     0.150
    96.200  1032.461     0.150
   109.104  1770.332     0.150
   124.367  1135.680     0.150
   124.367  1135.383     0.150
   159.420  1188.379     0.150
   160.200  1189.410     0.150
   160.735  1189.910     0.150
   160.735  1189.109     0.150
   160.735  1189.102     0.150
   163.222  1201.211     0.150
   163.825  2756.512     0.150
     0.849    17.590     0.150
     3.175    92.699     0.150
     3.280    90.969     0.150
     3.936    60.000     0.150
     4.629   121.820     0.150
     5.226    89.555     0.150
     5.226    74.109     0.150
     5.226   135.000     0.150
     5.315    73.250     0.150
     7.806   111.879     0.150
     8.267   118.148     0.150
     8.302   117.078     0.150
     8.885   124.711     0.150
     8.926   124.738     0.150
     9.021   122.469     0.150
     9.354   129.160     0.150
     9.354   129.141     0.150
     9.734   136.148     0.150
    10.331   143.410     0.150
    10.559   148.121     0.150
    11.126   154.641     0.150
    11.364   158.828     0.150
    18.281   246.109     0.150
    18.281   246.461     0.150
    23.510   308.320     0.150
    23.561   308.738     0.150
    23.837   311.840     0.150
    23.967   312.859     0.150
    24.345  2362.258     0.150
    24.503  2303.953     0.150
    24.503   314.461     0.150
    24.503   531.859     0.150
    24.950   322.359     0.150
    25.158   323.871     0.150
    25.498   326.160     0.150
    25.603   327.719     0.150
    25.885   331.258     0.150
    25.885   331.289     0.150
    26.225   325.258     0.150
    26.634   333.859     0.150
    27.400   342.500     0.150
    28.530   351.730     0.150
    28.888   355.789     0.150
    29.882   364.410     0.150
    30.172   366.219     0.150
    30.172   761.508     0.150
    31.678   377.379     0.150
    31.856   382.008     0.150
    32.185   382.461     0.150
    32.185   382.410     0.150
    32.744  2269.359     0.150
    33.313   391.418     0.150
    33.317   396.051     0.150
    33.317   395.781     0.150
    33.663   397.879     0.150
    33.680   478.359     0.150
    33.732   397.035     0.150
    33.785   720.461     0.150
    33.785   867.160     0.150
    34.484   403.371     0.150
    34.627   406.039     0.150
    34.671   406.668     0.150
    34.895   406.961     0.150
    34.895  2259.258     0.150
    34.941   408.648     0.150
    35.162   408.891     0.150
    35.464   409.961     0.150
    35.464   502.559     0.150
    35.464   750.359     0.150
    35.464   904.660     0.150
    35.817   416.098     0.150
    35.921   417.309     0.150
    36.181   417.613     0.150
    36.715   422.469     0.150
    36.709   424.121     0.150
    36.834   425.559     0.150
    37.184   426.469     0.150
    37.237   427.078     0.150
    37.259   428.160     0.150
    38.169   435.738     0.150
    38.279   783.961     0.150
    38.279   783.961     0.150
    38.582   439.641     0.150
    39.077   445.758     0.150
    39.077   445.719     0.150
    39.149   552.258     0.150
    39.373   444.758     0.150
    39.903   450.410     0.150
    39.927   446.258     0.150
    40.387   454.648     0.150
    41.245   459.660     0.150
    41.397   462.629     0.150
    41.938   581.359     0.150
    41.938   466.879     0.150
    41.938   581.309     0.150
    42.232   469.156     0.150
    42.967  3206.980     0.150
    42.973  3205.762     0.150
    42.985  3189.848     0.150
    44.136  3267.930     0.150
    44.149  3269.254     0.150
    44.153  3279.582     0.150
    44.478    11.301     0.150
    44.478    16.898     0.150
    44.806   496.090     0.150
    45.786   496.059     0.150
    45.980   513.461     0.150
    45.980   497.461     0.150
    46.270   500.449     0.150
    46.270   595.559     0.150
    46.308   499.559     0.150
    46.308   904.660     0.150
    46.505   502.320     0.150
    46.607   503.461     0.150
    46.732   504.461     0.150
    46.789   503.559     0.150
    46.789   596.781     0.150
    47.280    17.699     0.150
    47.531   510.531     0.150
    47.600   527.258     0.150
    47.600   511.059     0.150
    47.600   921.859     0.150
    47.663   512.559     0.150
    47.663   601.230     0.150
    47.663  2378.609     0.150
    48.258   515.059     0.150
    48.668   518.449     0.150
    49.019   522.129     0.150
    49.235   523.219     0.150
    50.140   531.637     0.150
    50.196   531.445     0.150
    50.243   531.559     0.150
    50.243   610.461     0.150
    50.244   531.559     0.150
    50.244   610.461     0.150
    50.387   531.730     0.150
    50.387   610.719     0.150
    50.922   537.227     0.150
    51.035   537.719     0.150
    51.052   537.340     0.150
    51.173   537.121     0.150
    51.363   539.258     0.150
    51.363   975.758     0.150
    51.698   541.711     0.150
    51.790   542.348     0.150
    51.914  3865.094     0.150
    52.013  3869.891     0.150
    52.034  3848.816     0.150
    52.717    14.898     0.150
    52.919   993.160     0.150
    53.408   570.961     0.150
    53.408   554.559     0.150
    53.994   622.359     0.150
    54.007   558.996     0.150
    54.418   561.090     0.150
    54.886    11.000     0.150
    54.886    15.102     0.150
    54.886  1044.660     0.150
    54.906   564.949     0.150
    55.166   567.219     0.150
    55.449   568.301     0.150
    55.713  2369.285     0.150
    56.093   573.680     0.150
    56.286   689.258     0.150
    56.302   575.309     0.150
    56.749    15.699     0.150
    56.749    21.398     0.150
    57.805   587.121     0.150
    57.805    15.867     0.150
    58.581    16.500     0.150
    58.581  1068.059     0.150
    58.873  2358.035     0.150
    59.252    16.898     0.150
    60.678   621.680     0.150
    62.654   618.098     0.150
    62.769  1119.738     0.150
    62.909    14.898     0.150
    63.217    13.199     0.150
    63.217    18.500     0.150
    63.393   622.141     0.150
    63.640   852.559     0.150
    63.717   624.961     0.150
    63.800   626.188     0.150
    63.800  2355.633     0.150
    63.787    12.902     0.150
    63.787    18.000     0.150
    64.137   628.758     0.150
    64.076   626.730     0.150
    64.321    13.398     0.150
    64.321    17.500     0.150
    64.321  1164.359     0.150
    64.426  2346.598     0.150
    64.477   868.461     0.150
    64.477  1227.758     0.150
    64.477  1575.461     0.150
    64.814   629.758     0.150
    64.814    15.402     0.150
    64.814  1146.758     0.150
    65.445   637.551     0.150
    65.468   655.180     0.150
    65.622   637.840     0.150
    65.622   632.160     0.150
    65.731   637.859     0.150
    65.862    16.500     0.150
    65.862   913.359     0.150
    65.862  1225.660     0.150
    65.862  1420.961     0.150
    65.896   657.008     0.150
    65.855   652.258     0.150
    65.855  1171.660     0.150
    65.855  1422.559     0.150
    65.855  4901.758     0.150
    68.391    16.102     0.150
    68.501   657.461     0.150
    68.604   674.660     0.150
    68.604   658.160     0.150
    68.604   655.969     0.150
    68.646   812.059     0.150
    68.646   907.859     0.150
    69.246   658.859     0.150
    69.246  1200.059     0.150
    69.374  1478.660     0.150
    69.374  2343.219     0.150
    69.543   663.758     0.150
    69.763   662.250     0.150
    69.802   664.309     0.150
    70.202   683.859     0.150
    70.202   667.461     0.150
    70.202   683.859     0.150
    70.255   666.188     0.150
    70.313   666.359     0.150
    70.313  1278.359     0.150
    70.322   666.438     0.150
    70.323    14.598     0.150
    70.618   666.059     0.150
    70.528   682.461     0.150
    70.528  5257.758     0.150
    70.628   669.301     0.150
    70.665   668.359     0.150
    70.665   668.359     0.150
    70.665   920.359     0.150
    70.665  1214.359     0.150
    70.665  1246.359     0.150
    70.665  1676.359     0.150
    70.665   668.359     0.150
    70.665   685.359     0.150
    70.665  1214.359     0.150
    70.665  1246.359     0.150
    70.665  1492.359     0.150
    70.665  1676.359     0.150
    70.683   668.828     0.150
    70.793   683.758     0.150
    70.793  5277.461     0.150
    71.327   673.559     0.150
    71.327    16.602     0.150
    71.434   675.781     0.150
    71.577   931.961     0.150
    71.577  1223.160     0.150
    72.326   680.980     0.150
    72.572   943.461     0.150
    72.905   683.859     0.150
    72.905   946.258     0.150
    72.874   696.258     0.150
    72.874  5434.859     0.150
    72.880   696.559     0.150
    72.880  5435.258     0.150
    72.951   696.461     0.150
    72.951  5440.656     0.150
    73.091   684.988     0.150
    73.107   697.859     0.150
    73.107  5451.961     0.150
    73.338  5468.859     0.150
    73.545   687.738     0.150
    73.545   687.758     0.150
    73.545    16.703     0.150
    73.520    13.203     0.150
    73.520    19.203     0.150
    73.386   686.398     0.150
    73.942  1276.359     0.150
    73.942  1313.359     0.150
    73.942  1552.359     0.150
    73.942  1762.359     0.150
    73.942  1852.359     0.150
    73.942  2353.359     0.150
    73.942   689.859     0.150
    73.942   706.660     0.150
    73.942  1255.359     0.150
    74.102   689.578     0.150
    74.233   695.758     0.150
    74.233    13.102     0.150
    74.233    18.301     0.150
    74.373   691.621     0.150
    74.380   691.750     0.150
    74.380    17.070     0.150
    74.413   854.359     0.150
    74.413   692.859     0.150
    74.413    17.301     0.150
    74.413   854.359     0.150
    74.438    18.098     0.150
    74.511   693.359     0.150
    74.511    16.699     0.150
    74.780   695.359     0.150
    74.780    16.801     0.150
    74.780  1268.160     0.150
    74.841   695.559     0.150
    74.841   708.258     0.150
    74.841  1268.160     0.150
    74.990   696.660     0.150
    74.990   709.258     0.150
    74.990  1267.859     0.150
    75.005   696.859     0.150
    75.005   709.660     0.150
    75.017   697.570     0.150
    75.127   697.281     0.150
    75.169   697.258     0.150
    75.169    16.301     0.150
    75.169   697.199     0.150
    75.289   698.258     0.150
    75.289   710.758     0.150
    75.319   698.258     0.150
    75.319   710.859     0.150
    75.401   698.859     0.150
    75.401   711.461     0.150
    75.401  1271.859     0.150
    75.469   699.211     0.150
    75.500   979.160     0.150
    75.500  1328.559     0.150
    75.546   699.559     0.150
    75.546   712.258     0.150
    75.546  1274.660     0.150
    75.600   699.551     0.150
    75.600    17.188     0.150
    75.723   700.660     0.150
    75.723    16.598     0.150
    75.654    14.547     0.150
    75.814    16.797     0.150
    75.814   702.449     0.150
    75.814    16.801     0.150
    75.962   719.859     0.150
    75.962   702.758     0.150
    75.962   719.859     0.150
    75.969   702.258     0.150
    75.969    16.801     0.150
    76.041   702.160     0.150
    76.041    17.098     0.150
    76.140  2337.559     0.150
    76.140   703.461     0.150
    76.140    12.699     0.150
    76.140  1284.059     0.150
    76.140  1576.059     0.150
    76.239   721.461     0.150
    76.239   721.461     0.150
    76.257   703.461     0.150
    76.431   704.301     0.150
    76.431  2326.758     0.150
    76.430   721.758     0.150
    76.430   704.961     0.150
    76.430   721.758     0.150
    76.430  1302.559     0.150
    76.474   721.559     0.150
    76.474   705.160     0.150
    76.474   721.559     0.150
    76.474  1285.461     0.150
    76.732   722.859     0.150
    76.862   724.660     0.150
    76.862   707.758     0.150
    76.862   724.660     0.150
    76.895   724.059     0.150
    76.895   707.359     0.150
    76.895   724.059     0.150
    76.895  1289.160     0.150
    76.904   724.461     0.150
    76.904   707.660     0.150
    76.904   724.461     0.150
    77.417    17.250     0.150
    77.447    17.980     0.150
    77.472   711.219     0.150
    77.639    17.992     0.150
    77.835   713.258     0.150
    77.835   713.301     0.150
    78.087   730.359     0.150
    78.087  1000.359     0.150
    78.087  1302.359     0.150
    78.087   713.359     0.150
    78.087   730.359     0.150
    78.087   885.359     0.150
    78.087  1000.359     0.150
    78.087  1302.359     0.150
    78.087  1372.359     0.150
    78.391   716.961     0.150
    78.528   717.859     0.150
    78.675   718.258     0.150
    78.698   717.559     0.150
    79.107   720.961     0.150
    79.214   721.359     0.150
    79.480   721.836     0.150
    79.480   721.758     0.150
    79.665  1848.684     0.150
    79.670   738.359     0.150
    79.751   723.250     0.150
    80.053   727.059     0.150
    80.019   728.160     0.150
    80.309   913.359     0.150
    80.309  1020.059     0.150
    80.404  1326.859     0.150
    80.643   727.379     0.150
    80.675   728.359     0.150
    80.672   727.461     0.150
    80.672   728.281     0.150
    80.672   727.461     0.150
    80.859    19.902     0.150
    80.807   738.559     0.150
    80.807  6021.562     0.150
    80.935   732.641     0.150
    80.935   732.660     0.150
    81.021   729.559     0.150
    81.224   729.789     0.150
    81.276   732.961     0.150
    81.276   731.758     0.150
    81.427   733.059     0.150
    81.814   735.059     0.150
    82.218  1342.758     0.150
    82.355  1343.961     0.150
    82.805   740.930     0.150
    82.805   740.430     0.150
    82.898   738.961     0.150
    82.898   738.961     0.150
    82.961   739.859     0.150
    82.961   739.859     0.150
    83.138   744.148     0.150
    83.185  1347.859     0.150
    83.201   740.961     0.150
    83.344   742.160     0.150
    83.354   741.879     0.150
    83.499   742.559     0.150
    83.515   742.750     0.150
    83.600  1836.910     0.150
    83.600  2321.258     0.150
    83.656   743.871     0.150
    83.730   744.258     0.150
    83.967   745.660     0.150
    83.974   759.258     0.150
    84.033   746.141     0.150
    84.042   745.340     0.150
    84.183   746.859     0.150
    84.183   746.859     0.150
    84.208   746.660     0.150
    84.208   746.660     0.150
    84.296   747.160     0.150
    84.328   747.160     0.150
    84.328   747.160     0.150
    84.400   749.059     0.150
    84.510   748.160     0.150
    84.510   748.160     0.150
    84.469   745.719     0.150
    84.489   747.340     0.150
    84.541  1366.809     0.150
    84.541   747.758     0.150
    84.541  1366.758     0.150
    84.592   748.930     0.150
    84.592   748.160     0.150
    84.592   748.160     0.150
    84.741   749.918     0.150
    84.741   748.859     0.150
    84.777   748.461     0.150
    84.834   750.008     0.150
    84.955   749.961     0.150
    84.955   749.961     0.150
    84.961   749.859     0.150
    84.977   750.160     0.150
    84.977   750.160     0.150
    85.062   750.461     0.150
    85.062   750.461     0.150
    85.067  1357.961     0.150
    85.244   752.289     0.150
    85.364   752.258     0.150
    85.381   752.160     0.150
    85.381   752.160     0.150
    85.391   750.859     0.150
    85.393   751.660     0.150
    85.393   751.660     0.150
    85.675   753.859     0.150
    85.724   754.758     0.150
    85.724   754.758     0.150
    85.961   754.859     0.150
    85.961   754.859     0.150
    85.968   754.859     0.150
    86.011   755.320     0.150
    86.017   755.160     0.150
    86.142   755.461     0.150
    86.333   755.758     0.150
    86.449   758.059     0.150
    86.540   757.961     0.150
    86.593   758.258     0.150
    86.687   757.758     0.150
    86.829   759.160     0.150
    86.939   758.961     0.150
    87.072   760.961     0.150
    87.078   760.559     0.150
    87.078   760.230     0.150
    87.204   761.160     0.150
    87.204   761.160     0.150
    87.312   762.461     0.150
    87.342   760.961     0.150
    87.342   760.961     0.150
    87.346   760.961     0.150
    87.461   761.258     0.150
    87.402   761.871     0.150
    88.181   765.758     0.150
    88.468   764.258     0.150
    88.706   781.160     0.150
    88.863   768.258     0.150
    88.863   768.258     0.150
    89.506   767.961     0.150
    89.573   780.059     0.150
    89.813   767.461     0.150
    89.882   773.961     0.150
    89.882   773.961     0.150
    89.963   772.758     0.150
    89.963   772.758     0.150
    89.939   774.859     0.150
    90.245   775.559     0.150
    92.278   784.789     0.150
    93.862   791.109     0.150
    99.715   818.738     0.150
    99.935   820.648     0.150
   101.624   826.609     0.150
   104.526   839.199     0.150
   110.485  1106.711     0.150
   115.302  1115.859     0.150
   118.589  1120.680     0.150
   122.067  1739.535     0.150
   122.067  1127.719     0.150
   122.067  1739.531     0.150
   124.386  1135.930     0.150
   124.386  1134.668     0.150
   124.386  1148.258     0.150
   124.386  1345.629     0.150
   134.289  1147.336     0.150
   134.289  1146.230     0.150
   134.289  1355.160     0.150
   139.805  1154.430     0.150
   139.805  1154.160     0.150
   139.805  1154.160     0.150
   144.252  1168.688     0.150
   144.252  1381.281     0.150
   149.725  1179.609     0.150
   149.725  1185.121     0.150
   153.320  1184.730     0.150
   153.320  1192.730     0.150
   160.716  1189.781     0.150
   160.716  1246.188     0.150
     1.342    27.695     0.150
     1.646    31.547     0.150
     1.646    54.969     0.150
     1.981    37.148     0.150
     1.986    37.188     0.150
     1.986    64.117     0.150
     2.055    38.102     0.150
     2.337    42.492     0.150
     2.433    43.836     0.150
     3.101    52.562     0.150
     3.212    54.359     0.150
     3.272    55.258     0.150
     3.829    59.016     0.150
     3.594    58.680     0.150
     3.660    60.062     0.150
     3.734    60.680     0.150
     3.819    61.352     0.150
     3.856    62.500     0.150
     4.612    73.570     0.150
     5.376    91.938     0.150
     5.376   167.539     0.150
     5.584    81.719     0.150
     5.220    82.062     0.150
     9.539   136.281     0.150
     9.623   247.148     0.150
    11.569   163.211     0.150
    11.841   716.820     0.150
    11.920   169.141     0.150
    12.133   170.211     0.150
    20.288   496.227     0.150
    23.852   312.672     0.150
    24.361   316.688     0.150
    29.006   356.297     0.150
    32.730   392.438     0.150
    35.522   417.648     0.150
    35.860   419.469     0.150
    35.829   419.930     0.150
    36.360   792.711     0.150
    36.492   422.547     0.150
    40.554   453.688     0.150
    41.769   467.156     0.150
    44.940   494.289     0.150
    44.940   494.797     0.150
    45.137   493.586     0.150
    45.872   499.492     0.150
    46.520   581.336     0.150
    47.665   515.992     0.150
    56.808   578.742     0.150
    56.808    18.695     0.150
    64.006   628.391     0.150
    64.386   634.438     0.150
    64.386    12.805     0.150
    64.386    19.602     0.150
    64.658   633.242     0.150
    68.443   658.039     0.150
    75.499   699.938     0.150
    79.967   724.938     0.150
    80.135   726.242     0.150
    83.170   739.836     0.150
     0.927    18.328     0.150
     0.950    18.672     0.150
     2.129    36.367     0.150
     2.582    42.742     0.150
     3.769   102.414     0.150
     3.904   105.828     0.150
     4.029    61.414     0.150
     4.595    68.234     0.150
     4.791    72.617     0.150
     5.157    88.586     0.150
     5.157   147.414     0.150
     5.157    88.586     0.150
     5.404    89.398     0.150
     6.651    90.648     0.150
     6.651    99.617     0.150
     7.757   111.703     0.150
     8.298   117.977     0.150
     8.816   123.844     0.150
     8.882   125.203     0.150
     9.309   129.617     0.150
     9.686   135.375     0.150
     9.789   243.055     0.150
    10.299   143.734     0.150
    10.529   149.234     0.150
    10.739   156.383     0.150
    11.081   154.258     0.150
    11.300   158.648     0.150
    11.695   168.875     0.150
    11.722   166.977     0.150
    11.903   162.117     0.150
    11.903   298.094     0.150
    18.245   247.383     0.150
    23.864    10.266     0.150
    24.499   319.617     0.150
    25.396     0.672     0.150
    25.501    12.242     0.150
    25.980     5.633     0.150
    26.875   340.016     0.150
    26.875   340.016     0.150
    27.300   342.086     0.150
    27.638   343.016     0.150
    27.859   342.508     0.150
    28.743   354.836     0.150
    29.067   367.203     0.150
    29.170   362.695     0.150
    29.489   542.133     0.150
    29.779   363.016     0.150
    29.779   363.016     0.150
    30.389   373.633     0.150
    31.651   377.562     0.150
    31.651    11.992     0.150
    31.651   377.586     0.150
    31.753   380.648     0.150
    31.908   382.008     0.150
    31.952   384.844     0.150
    32.640   385.742     0.150
    32.640    12.875     0.150
    32.640   552.789     0.150
    33.332   392.773     0.150
    33.332    12.320     0.150
    33.412   390.867     0.150
    33.386   392.227     0.150
    33.507   394.094     0.150
    33.507    12.430     0.150
    33.561   396.617     0.150
    33.561   402.914     0.150
    33.561   396.625     0.150
    33.561   397.344     0.150
    33.561     5.555     0.150
    33.782   486.516     0.150
    33.906   397.336     0.150
    34.566   401.312     0.150
    34.566   401.297     0.150
    34.568   402.812     0.150
    34.568   411.617     0.150
    34.568   402.812     0.150
    34.773   403.797     0.150
    34.795   402.383     0.150
    34.795   405.562     0.150
    34.838   408.422     0.150
    35.090   408.633     0.150
    35.151   403.336     0.150
    35.151    17.586     0.150
    35.714   417.617     0.150
    35.714   426.117     0.150
    35.714   417.648     0.150
    35.714     8.461     0.150
    36.064   419.016     0.150
    36.089   416.484     0.150
    36.089     3.211     0.150
    36.494   419.336     0.150
    36.607   423.633     0.150
    36.731   435.625     0.150
    37.139   425.016     0.150
    37.139   424.992     0.150
    37.240   423.477     0.150
    37.480   429.164     0.150
    37.572   427.898     0.150
    37.958   437.375     0.150
    38.127   441.656     0.150
    38.192   435.133     0.150
    38.479   453.359     0.150
    38.840   437.867     0.150
    39.069   440.727     0.150
    39.180   442.719     0.150
    39.252   572.914     0.150
    39.252   802.414     0.150
    39.252   972.219     0.150
    39.316   445.117     0.150
    39.839   448.211     0.150
    40.657   456.281     0.150
    41.294   461.094     0.150
    41.835   581.344     0.150
    41.835   473.117     0.150
    42.803   471.695     0.150
    43.028  3252.953     0.150
    43.034  3253.398     0.150
    43.046  3240.266     0.150
    44.189   485.352     0.150
    44.199   485.047     0.150
    44.210  3336.109     0.150
    44.213  3335.359     0.150
    44.273   483.305     0.150
    44.581     8.898     0.150
    44.581    12.805     0.150
    44.813   489.016     0.150
    45.694   505.516     0.150
    45.694   505.523     0.150
    46.309   616.516     0.150
    46.309   499.516     0.150
    46.309   616.516     0.150
    46.592   503.516     0.150
    46.950   505.117     0.150
    47.469   509.391     0.150
    47.560   599.539     0.150
    47.569   511.016     0.150
    47.569   511.016     0.150
    47.569   511.023     0.150
    49.767   527.562     0.150
    50.347   533.016     0.150
    50.490   532.148     0.150
    53.813   560.703     0.150
    54.493   562.328     0.150
    54.988    12.500     0.150
    54.988   692.914     0.150
    55.445   570.148     0.150
    55.752     5.508     0.150
    55.868   575.758     0.150
    56.400   586.047     0.150
    56.447   580.672     0.150
    56.850  1043.219     0.150
    63.012    11.000     0.150
    63.319    11.094     0.150
    63.796   626.883     0.150
    63.884     9.500     0.150
    63.884    13.305     0.150
    64.145   628.047     0.150
    64.151   628.812     0.150
    64.421    11.000     0.150
    64.421    16.602     0.150
    64.421  1143.016     0.150
    64.421  1394.516     0.150
    64.536   775.312     0.150
    64.536  1146.617     0.150
    64.536   631.594     0.150
    64.971   635.133     0.150
    65.457   638.156     0.150
    65.705   639.125     0.150
    65.705   639.586     0.150
    65.814   639.953     0.150
    65.951    11.102     0.150
    65.951    15.906     0.150
    65.951   792.414     0.150
    68.492    15.898     0.150
    68.489   656.367     0.150
    68.687   667.719     0.150
    70.426    11.602     0.150
    71.516   676.883     0.150
    72.167   679.117     0.150
    72.406   682.406     0.150
    73.168   685.938     0.150
    73.956   690.312     0.150
    74.317   696.516     0.150
    74.317    10.398     0.150
    74.405   692.242     0.150
    74.405     9.344     0.150
    74.413   692.062     0.150
    74.796     8.398     0.150
    74.796   695.719     0.150
    74.796   704.117     0.150
    74.796    15.797     0.150
    74.858   695.914     0.150
    75.004   697.016     0.150
    75.004    15.602     0.150
    75.023   697.219     0.150
    75.023    15.797     0.150
    75.133   697.242     0.150
    75.133   695.617     0.150
    75.133   709.516     0.150
    75.133   695.578     0.150
    75.133   709.555     0.150
    75.307   698.617     0.150
    75.335   698.617     0.150
    75.335    15.898     0.150
    75.417   699.117     0.150
    75.417    16.000     0.150
    75.566   700.117     0.150
    75.566    15.195     0.150
    75.619   700.516     0.150
    75.748   701.312     0.150
    75.911   703.617     0.150
    75.953   703.016     0.150
    75.986   703.219     0.150
    76.058   702.414     0.150
    76.058    16.102     0.150
    76.071   703.719     0.150
    76.155   703.719     0.150
    76.155   715.414     0.150
    76.261   720.617     0.150
    76.261   704.812     0.150
    76.261   720.617     0.150
    76.455   705.219     0.150
    76.498   714.016     0.150
    76.498   705.516     0.150
    76.498   714.016     0.150
    76.916   707.617     0.150
    76.916   719.312     0.150
    76.926   708.219     0.150
    76.926   719.719     0.150
    77.494   711.312     0.150
    77.655   712.117     0.150
    77.690   711.414     0.150
    78.589   717.719     0.150
    78.679   717.812     0.150
    79.131   721.016     0.150
    79.368   720.312     0.150
    79.368   720.312     0.150
    79.387   721.516     0.150
    79.780   723.617     0.150
    79.783   723.617     0.150
    79.872   724.414     0.150
    79.976   724.312     0.150
    80.676   728.914     0.150
    80.774   728.906     0.150
    81.214   730.219     0.150
    81.329   732.914     0.150
    81.481   733.312     0.150
    81.636   733.617     0.150
    81.995   733.117     0.150
    82.203   737.188     0.150
    83.903     9.406     0.150
    84.873   751.453     0.150
    87.464   763.516     0.150
    96.253  1806.867     0.150
    96.710   810.039     0.150
   124.443  1136.008     0.150
   149.766  1185.633     0.150
     1.728    29.844     0.150
     1.917    32.500     0.150
     2.841    45.320     0.150
     2.855    81.531     0.150
     3.202    87.836     0.150
     3.999    60.961     0.150
     4.857    72.938     0.150
     5.722   146.680     0.150
     5.858    86.844     0.150
     6.992   102.508     0.150
     7.991   116.836     0.150
     8.026   116.820     0.150
     8.033   116.875     0.150
     8.282   118.867     0.150
     8.668   123.078     0.150
     8.734   124.250     0.150
     9.394   132.031     0.150
     9.382   131.375     0.150
     9.823   136.961     0.150
    10.143   141.188     0.150
    10.208   142.875     0.150
    10.775   149.805     0.150
    10.998   153.016     0.150
    11.595   160.938     0.150
    11.857   165.039     0.150
    11.857   165.016     0.150
    12.180   167.320     0.150
    12.372   309.734     0.150
    12.372  2354.289     0.150
    12.504   174.211     0.150
    14.708   205.156     0.150
    17.505   435.812     0.150
    17.505   435.805     0.150
    18.731   251.984     0.150
    18.731   462.320     0.150
    19.791   523.766     0.150
    20.105   270.695     0.150
    23.484   549.438     0.150
    23.484   304.531     0.150
    23.994   310.438     0.150
    23.994   531.734     0.150
    23.994   565.539     0.150
    23.925   312.836     0.150
    24.329   315.664     0.150
    24.852   316.734     0.150
    24.999  2302.336     0.150
    24.999   319.641     0.150
    24.999   533.836     0.150
    24.999   580.938     0.150
    25.346   326.094     0.150
    25.573   327.250     0.150
    25.578   328.250     0.150
    25.849   586.539     0.150
    25.869   330.688     0.150
    25.887   329.336     0.150
    25.887   329.359     0.150
    25.891   327.367     0.150
    26.006   328.438     0.150
    26.006   535.734     0.150
    25.909   330.117     0.150
    25.925   330.594     0.150
    26.004   331.391     0.150
    26.268   333.734     0.150
    26.268   333.719     0.150
    26.389   335.227     0.150
    26.488   335.836     0.150
    26.777   338.625     0.150
    26.807   338.828     0.150
    27.033   341.359     0.150
    27.547   345.531     0.150
    27.598   346.102     0.150
    27.786   345.414     0.150
    27.840   541.008     0.150
    27.840   627.219     0.150
    28.521   354.094     0.150
    28.819   356.891     0.150
    28.881   357.305     0.150
    29.236   359.477     0.150
    29.846   362.984     0.150
    30.270   369.406     0.150
    30.517   369.875     0.150
    30.517   765.734     0.150
    31.615   380.789     0.150
    32.021   384.594     0.150
    32.447   386.820     0.150
    32.507   388.117     0.150
    33.072   392.789     0.150
    33.307   554.297     0.150
    33.307   775.250     0.150
    33.262   395.938     0.150
    33.370   390.734     0.150
    33.387   480.938     0.150
    33.388   467.539     0.150
    33.388   478.938     0.150
    33.388   862.438     0.150
    33.340   393.594     0.150
    33.354   397.008     0.150
    33.754   399.867     0.150
    33.865   401.789     0.150
    34.073   401.695     0.150
    34.367   405.477     0.150
    34.944   408.867     0.150
    34.960   409.266     0.150
    35.013   410.219     0.150
    35.070   410.219     0.150
    35.315   490.539     0.150
    35.315   743.836     0.150
    35.315   756.539     0.150
    35.315   559.891     0.150
    35.228   414.234     0.150
    35.351    13.406     0.150
    35.351   736.938     0.150
    35.299   413.164     0.150
    35.324  2258.086     0.150
    36.159   419.516     0.150
    36.164   419.281     0.150
    36.246   421.125     0.150
    36.557   420.844     0.150
    36.591   422.977     0.150
    37.111   427.656     0.150
    37.153   427.016     0.150
    37.211   429.016     0.150
    37.590  1885.086     0.150
    37.590   568.531     0.150
    37.590   779.320     0.150
    37.590   790.781     0.150
    37.590  1885.086     0.150
    37.689   431.445     0.150
    38.454   439.727     0.150
    38.831    13.195     0.150
    38.831   984.836     0.150
    38.767   794.406     0.150
    38.899   441.594     0.150
    38.920   443.516     0.150
    39.729    12.906     0.150
    39.729   563.234     0.150
    40.326   454.164     0.150
    40.830   458.000     0.150
    41.655   478.234     0.150
    41.655   463.539     0.150
    41.655   478.234     0.150
    42.327   469.859     0.150
    42.765   473.438     0.150
    43.562   480.438     0.150
    43.562   480.477     0.150
    44.151    11.102     0.150
    44.151    16.000     0.150
    44.151   584.234     0.150
    46.263   499.898     0.150
    46.411   516.141     0.150
    46.411   500.836     0.150
    46.411   516.141     0.150
    46.540   501.984     0.150
    46.549   503.000     0.150
    46.650   518.141     0.150
    46.650   503.234     0.150
    46.650   518.141     0.150
    46.964    12.305     0.150
    46.964    17.203     0.150
    46.964   613.938     0.150
    46.964  1109.734     0.150
    47.002   522.438     0.150
    47.002   507.039     0.150
    47.002   522.438     0.150
    47.002   913.836     0.150
    47.002  1098.438     0.150
    46.931   506.539     0.150
    47.164   508.000     0.150
    47.356   508.016     0.150
    47.905   528.039     0.150
    48.040   527.234     0.150
    48.040   514.836     0.150
    48.040   527.234     0.150
    48.040   926.641     0.150
    48.043   515.836     0.150
    48.043   603.039     0.150
    48.043   931.539     0.150
    48.043  2387.891     0.150
    48.531   516.820     0.150
    48.645   518.039     0.150
    48.980  1161.391     0.150
    49.422   525.445     0.150
    49.878   528.945     0.150
    49.878   529.336     0.150
    49.878   609.641     0.150
    49.878   957.266     0.150
    50.295   530.469     0.150
    50.350   530.656     0.150
    50.563   532.258     0.150
    50.861   535.117     0.150
    51.463   541.359     0.150
    51.645   540.594     0.150
    51.736   555.539     0.150
    51.736   542.734     0.150
    51.736   555.539     0.150
    52.388    14.898     0.150
    52.597   557.977     0.150
    53.095    18.133     0.150
    53.527   556.250     0.150
    53.859   573.641     0.150
    53.859   558.234     0.150
    53.859   573.641     0.150
    54.142  2802.336     0.150
    54.142   560.234     0.150
    54.142   625.734     0.150
    54.142  1015.336     0.150
    54.589    14.805     0.150
    54.608   563.297     0.150
    54.892  1020.891     0.150
    55.646   571.031     0.150
    55.958  1043.094     0.150
    56.022   573.195     0.150
    56.329   575.531     0.150
    56.634   576.656     0.150
    56.813    15.102     0.150
    56.798   578.125     0.150
    57.541   793.938     0.150
    57.541  1045.938     0.150
    58.282    13.297     0.150
    58.282    20.195     0.150
    58.488   590.930     0.150
    58.681  1069.336     0.150
    58.814  2819.812     0.150
    58.899    15.000     0.150
    62.042   847.938     0.150
    62.042  1128.938     0.150
    62.251   616.367     0.150
    62.570    12.797     0.150
    62.722    14.227     0.150
    62.921    13.297     0.150
    62.921    18.500     0.150
    63.079  1132.891     0.150
    63.336   622.094     0.150
    63.566    12.102     0.150
    63.566    18.102     0.150
    63.669   662.570     0.150
    63.711   860.438     0.150
    63.978   625.961     0.150
    64.038   628.109     0.150
    64.038  2844.609     0.150
    64.038   628.141     0.150
    64.061    14.000     0.150
    64.061    19.203     0.150
    64.432  2846.852     0.150
    64.436   631.320     0.150
    64.433   631.336     0.150
    64.433   631.141     0.150
    64.557   863.336     0.150
    65.309    13.758     0.150
    65.534   638.297     0.150
    65.534  2352.789     0.150
    65.534  2849.258     0.150
    65.534   638.164     0.150
    65.534  2352.789     0.150
    65.534  2849.258     0.150
    65.645   638.750     0.150
    65.729    15.000     0.150
    65.729    18.500     0.150
    65.729   913.336     0.150
    65.729  1160.438     0.150
    65.748    19.453     0.150
    65.748   640.234     0.150
    65.772   644.641     0.150
    65.772  1167.234     0.150
    65.772  1424.539     0.150
    65.772  4902.836     0.150
    68.105    13.703     0.150
    68.105    19.500     0.150
    68.529   655.898     0.150
    68.825   911.141     0.150
    68.847   660.039     0.150
    68.857   659.688     0.150
    68.880   657.039     0.150
    68.880  1196.234     0.150
    68.911   674.234     0.150
    68.911   660.539     0.150
    68.911   674.234     0.150
    69.672   662.016     0.150
    69.557   673.336     0.150
    69.557  1479.938     0.150
    69.717   663.344     0.150
    69.837   679.734     0.150
    69.837   665.938     0.150
    69.837   679.734     0.150
    69.837  1213.938     0.150
    69.854   664.164     0.150
    70.003    15.703     0.150
    70.170   666.078     0.150
    70.180   680.734     0.150
    70.180   668.141     0.150
    70.180   680.734     0.150
    70.253   666.578     0.150
    70.486   684.641     0.150
    70.486   669.438     0.150
    70.486   684.641     0.150
    70.486  1216.234     0.150
    70.552   669.914     0.150
    70.542   668.938     0.150
    70.542   804.938     0.150
    70.542   918.938     0.150
    70.542  1234.938     0.150
    70.542  1715.938     0.150
    70.634  5265.734     0.150
    70.890   706.938     0.150
    70.890   810.938     0.150
    70.890  1220.938     0.150
    70.890  1260.938     0.150
    70.890  1566.938     0.150
    70.890  1746.938     0.150
    70.890   671.938     0.150
    70.890    15.000     0.150
    70.890  1220.938     0.150
    70.890  1260.938     0.150
    70.890  1274.938     0.150
    71.573   675.539     0.150
    71.573  1281.539     0.150
    71.624   676.781     0.150
    71.806   690.938     0.150
    71.730   685.938     0.150
    72.021   679.875     0.150
    72.021   679.875     0.150
    72.372   681.141     0.150
    72.372  1240.539     0.150
    72.699  5434.539     0.150
    72.703  5435.141     0.150
    72.774  5439.734     0.150
    73.051   684.984     0.150
    72.932  5451.336     0.150
    73.069   949.438     0.150
    73.214    20.805     0.150
    73.214   852.734     0.150
    73.214  1246.234     0.150
    73.172  5469.234     0.150
    73.803   689.969     0.150
    73.803  1265.734     0.150
    73.803  1300.906     0.150
    73.803   689.938     0.150
    73.803  1300.938     0.150
    74.061   689.414     0.150
    74.073    16.898     0.150
    74.064   686.727     0.150
    74.146   695.438     0.150
    74.146    13.797     0.150
    74.146   714.234     0.150
    74.146  1299.734     0.150
    74.236   858.938     0.150
    74.236  1304.938     0.150
    74.236  1354.938     0.150
    74.236  1570.938     0.150
    74.236  1756.938     0.150
    74.236  1858.938     0.150
    74.236  2473.938     0.150
    74.236  9586.938     0.150
    74.236   691.938     0.150
    74.236    12.000     0.150
    74.236  1262.938     0.150
    74.236   691.867     0.150
    74.295   693.188     0.150
    74.558   693.906     0.150
    74.587  2334.414     0.150
    74.587   693.359     0.150
    74.703   695.039     0.150
    74.703   707.734     0.150
    74.703   860.938     0.150
    74.790  1349.195     0.150
    74.790   695.641     0.150
    74.790    15.398     0.150
    74.790  1266.438     0.150
    75.067   697.438     0.150
    75.067    15.703     0.150
    75.121   697.641     0.150
    75.121    15.500     0.150
    75.121  1272.539     0.150
    75.284   698.938     0.150
    75.284    15.703     0.150
    75.284  1275.336     0.150
    75.287   698.836     0.150
    75.287    11.805     0.150
    75.287  1274.336     0.150
    75.431  1243.281     0.150
    75.431   699.234     0.150
    75.431    15.500     0.150
    75.453     8.539     0.150
    75.453   699.617     0.150
    75.566   700.234     0.150
    75.566   712.734     0.150
    75.592   701.555     0.150
    75.606  2339.141     0.150
    75.606   700.336     0.150
    75.606    15.703     0.150
    75.606  1278.641     0.150
    75.687   700.938     0.150
    75.687    15.602     0.150
    75.687  1278.938     0.150
    75.629   700.656     0.150
    75.771   701.430     0.150
    75.816  1279.836     0.150
    75.816   701.641     0.150
    75.816    14.695     0.150
    75.816  1279.836     0.150
    75.873   701.445     0.150
    75.970  1299.930     0.150
    75.970  1333.156     0.150
    75.970   702.734     0.150
    75.970    15.203     0.150
    75.970  1299.938     0.150
    75.970  1333.141     0.150
    76.217   704.938     0.150
    76.433   705.539     0.150
    76.433    15.898     0.150
    76.433  1288.641     0.150
    76.503   706.539     0.150
    76.570   705.555     0.150
    76.679   706.836     0.150
    76.723   706.430     0.150
    76.950   707.578     0.150
    76.981   727.234     0.150
    76.981   888.438     0.150
    76.981  1298.836     0.150
    76.981  1582.938     0.150
    77.162   710.141     0.150
    77.162   709.641     0.150
    77.733   712.898     0.150
    77.733   713.141     0.150
    77.956   714.141     0.150
    78.301    14.000     0.150
    78.301  1374.938     0.150
    78.301  2666.938     0.150
    78.301   713.938     0.150
    78.301    14.000     0.150
    78.301   888.938     0.150
    78.301  1002.938     0.150
    78.301  1323.938     0.150
    78.301  1340.938     0.150
    78.301  1374.938     0.150
    78.309   715.000     0.150
    78.475   717.438     0.150
    78.403  1611.438     0.150
    78.403  5862.039     0.150
    78.559   714.039     0.150
    79.549   737.641     0.150
    79.609   723.141     0.150
    79.609   723.078     0.150
    79.609   723.078     0.150
    79.609   723.078     0.150
    79.648   722.828     0.150
    79.763   723.438     0.150
    79.852  1324.938     0.150
    79.858   723.125     0.150
    79.979   725.250     0.150
    80.109   741.141     0.150
    80.360   726.617     0.150
    80.360   726.617     0.150
    80.360   726.414     0.150
    80.524  1331.234     0.150
    80.649   728.836     0.150
    80.649  1846.641     0.150
    80.797   736.602     0.150
    80.797   736.539     0.150
    80.857   728.758     0.150
    80.737  6028.438     0.150
    80.959  1653.141     0.150
    81.159   729.969     0.150
    81.388   733.039     0.150
    81.410   930.234     0.150
    81.410  1684.539     0.150
    81.623   933.141     0.150
    81.933   735.938     0.150
    81.975   916.734     0.150
    82.147   736.734     0.150
    82.241   735.320     0.150
    82.612  1674.836     0.150
    82.754  1355.336     0.150
    83.194   742.289     0.150
    83.225   741.641     0.150
    83.378   746.336     0.150
    83.566   743.336     0.150
    83.656   744.438     0.150
    83.656   744.438     0.150
    83.836   743.836     0.150
    83.833   744.391     0.150
    83.967   745.516     0.150
    84.039   746.156     0.150
    84.182   746.234     0.150
    84.182   746.234     0.150
    84.205   747.438     0.150
    84.278   747.539     0.150
    84.278   747.539     0.150
    84.303   747.430     0.150
    84.427   748.641     0.150
    84.427   748.641     0.150
    84.448   748.141     0.150
    84.448   748.141     0.150
    84.531   748.836     0.150
    84.553   748.438     0.150
    84.553   748.438     0.150
    84.615  1730.836     0.150
    84.647   749.734     0.150
    84.647   749.734     0.150
    84.751   749.641     0.150
    84.751   749.641     0.150
    84.844   749.938     0.150
    84.844   749.938     0.150
    84.860  1723.039     0.150
    84.942  1370.125     0.150
    84.885   749.734     0.150
    84.885   749.438     0.150
    84.984   750.336     0.150
    85.006   750.234     0.150
    85.018   751.539     0.150
    85.195   751.438     0.150
    85.195   751.438     0.150
    85.180  1728.836     0.150
    85.214   751.734     0.150
    85.214   751.734     0.150
    85.265   751.734     0.150
    85.265   751.734     0.150
    85.312   752.234     0.150
    85.312   752.234     0.150
    85.467   939.039     0.150
    85.467  1382.234     0.150
    85.499   753.039     0.150
    85.499   753.039     0.150
    85.594   753.836     0.150
    85.577  1745.336     0.150
    85.632   753.234     0.150
    85.632   753.234     0.150
    85.936   755.734     0.150
    85.980   756.336     0.150
    85.980   756.336     0.150
    86.111   756.336     0.150
    86.111   756.336     0.150
    86.176   756.039     0.150
    86.184   756.234     0.150
    86.184   756.234     0.150
    86.209   756.234     0.150
    86.219   756.781     0.150
    86.243   756.539     0.150
    86.268   756.539     0.150
    86.379   756.938     0.150
    86.459   758.055     0.150
    86.497   758.539     0.150
    86.580   757.641     0.150
    86.580   757.586     0.150
    86.699   759.438     0.150
    86.748   759.539     0.150
    86.887   759.039     0.150
    86.930   759.234     0.150
    86.911   760.820     0.150
    87.053   760.734     0.150
    87.184   760.438     0.150
    87.215   761.336     0.150
    87.370   762.641     0.150
    87.388   757.594     0.150
    87.461   762.836     0.150
    87.461   762.836     0.150
    87.498   762.141     0.150
    87.483   974.836     0.150
    87.557   762.039     0.150
    87.561   763.336     0.150
    87.564   763.641     0.150
    87.588   763.609     0.150
    87.583   762.141     0.150
    87.663   763.641     0.150
    87.680   763.234     0.150
    87.696   762.438     0.150
    87.870   760.406     0.150
    87.942   758.914     0.150
    88.063   764.039     0.150
    88.148   765.734     0.150
    88.148   765.734     0.150
    88.227   765.641     0.150
    88.291   765.641     0.150
    88.580   766.836     0.150
    88.717   767.734     0.150
    88.859   768.141     0.150
    89.018   769.836     0.150
    89.073   768.836     0.150
    89.073   768.836     0.150
    89.091   772.234     0.150
    89.307   770.141     0.150
    89.485   771.531     0.150
    89.551   771.398     0.150
    89.695   772.141     0.150
    90.044   771.555     0.150
    90.116   774.438     0.150
    90.116   774.438     0.150
    90.305   771.141     0.150
    90.475   776.734     0.150
    90.489    14.664     0.150
    90.687   776.641     0.150
    91.259   778.898     0.150
    91.558   781.125     0.150
    92.082  1436.938     0.150
    92.317  1010.578     0.150
    92.317  1818.164     0.150
    93.492   790.156     0.150
    93.974   793.086     0.150
    94.521   798.906     0.150
    94.521   798.906     0.150
    94.523   798.023     0.150
    94.523   798.023     0.150
    94.679   799.617     0.150
    94.679   799.617     0.150
    94.770   799.008     0.150
    94.770   799.008     0.150
    95.075   801.906     0.150
    95.075   801.906     0.150
    95.782   801.305     0.150
    96.148   806.406     0.150
    97.112  1807.211     0.150
    99.226   816.820     0.150
    99.226  1085.789     0.150
   101.976   831.188     0.150
   104.910  1782.664     0.150
   104.910  1782.656     0.150
   115.728  1748.688     0.150
   115.728  1748.688     0.150
   115.728  1771.438     0.150
   116.022  1118.719     0.150
   116.022  1771.914     0.150
   125.170  1134.781     0.150
   133.951  1133.891     0.150
   136.030  1154.078     0.150
   137.883  1148.219     0.150
   137.883  1335.039     0.150
   138.272  1161.570     0.150
   139.963  1154.406     0.150
   139.963  1155.586     0.150
   139.963  1165.297     0.150
   139.963  1339.156     0.150
   140.090  1154.219     0.150
   140.090  1154.219     0.150
   140.090  1163.266     0.150
   144.535  1170.109     0.150
   144.835  1171.477     0.150
   144.972  1173.070     0.150
   149.899  1398.359     0.150
   153.334  1189.234     0.150
   153.491  1190.570     0.150
   153.491  1206.914     0.150
   153.491  1184.719     0.150
   153.491  1193.617     0.150
   153.491  1206.906     0.150
   155.772  1197.078     0.150
   155.772  1186.648     0.150
   155.772  1198.297     0.150
   157.621  1190.297     0.150
   157.913  1199.719     0.150
   160.618  1190.703     0.150
   160.618  1470.156     0.150
   160.618  1470.156     0.150
   163.603  1472.234     0.150
     5.114   123.869     0.150
     6.689    92.000     0.150
     6.923   102.109     0.150
     8.325   121.080     0.150
     8.487   121.010     0.150
     8.767   123.990     0.150
     8.937   123.811     0.150
     8.937   123.779     0.150
     9.360   132.891     0.150
     9.726   137.240     0.150
     9.726   245.480     0.150
    10.395   142.811     0.150
    10.395   142.760     0.150
    10.633   148.660     0.150
    10.858   148.641     0.150
    11.272   158.750     0.150
    11.314   163.490     0.150
    12.006   300.000     0.150
    12.006   169.520     0.150
    12.006   300.000     0.150
    18.324   454.811     0.150
    18.324   249.010     0.150
    18.324   454.770     0.150
    20.570   289.410     0.150
    31.434   383.949     0.150
    34.177   406.480     0.150
    36.334   423.350     0.150
    43.051  3230.277     0.150
    43.057  3230.744     0.150
    43.069  3233.582     0.150
    44.216  3329.771     0.150
    44.230  3335.293     0.150
    44.234  3335.170     0.150
    46.507   502.709     0.150
    46.531   505.199     0.150
    46.739   506.311     0.150
    47.271   511.670     0.150
    47.271   602.039     0.150
    51.490   542.529     0.150
    54.791   567.250     0.150
    63.755   625.010     0.150
    64.095   629.980     0.150
    64.233    10.100     0.150
    64.233    14.000     0.150
    64.382   632.311     0.150
    64.761     9.000     0.150
    64.761    13.701     0.150
    64.867  1405.109     0.150
    65.317   638.650     0.150
    66.063   643.330     0.150
    66.063   643.330     0.150
    66.171   643.850     0.150
    66.308    10.301     0.150
    68.825   660.510     0.150
    68.825    10.600     0.150
    68.825  1256.510     0.150
    73.522   689.949     0.150
    74.188   693.510     0.150
    74.684   695.850     0.150
    74.674   700.311     0.150
    75.265   700.709     0.150
    76.388   707.510     0.150
    76.388   711.910     0.150
    76.388   715.609     0.150
    77.674   711.621     0.150
    77.697   711.006     0.150
    78.150   713.135     0.150
    78.335   715.580     0.150
    78.426   714.230     0.150
    78.715   717.445     0.150
    78.888   719.146     0.150
    79.047   718.393     0.150
    79.844   730.410     0.150
    79.844  1322.109     0.150
    80.139   726.109     0.150
    92.964   792.209     0.150
     1.362    42.914     0.150
     2.817    46.574     0.150
    12.006   163.184     0.150
    14.274   201.895     0.150
    18.324   250.223     0.150
    35.920   414.105     0.150
    43.054  3247.391     0.150
    43.060  3247.738     0.150
    43.072  3235.891     0.150
    44.219  3335.301     0.150
    44.232  3340.965     0.150
    44.236  3341.266     0.150
    64.241    10.301     0.150
    64.241    14.301     0.150
    64.770    12.000     0.150
    64.770    17.398     0.150
    66.070   641.633     0.150
    66.316    16.398     0.150
    66.316   667.684     0.150
    71.144   673.781     0.150
    74.682   700.484     0.150
    74.682    11.898     0.150
    75.869   712.281     0.150
    77.678   711.555     0.150
    77.751   721.082     0.150
    78.040   712.391     0.150
    80.056   724.781     0.150
     0.841    14.422     0.150
     1.243    35.211     0.150
     1.435    24.062     0.150
     1.458    24.172     0.150
     4.479   121.859     0.150
     5.870   157.344     0.150
     8.581   119.102     0.150
    11.156   158.289     0.150
    84.633   751.070     0.150
     0.452    15.195     0.150
     6.033    86.227     0.150
     7.927   202.445     0.150
     9.151   233.895     0.150
    18.388   250.375     0.150
    42.910  3238.871     0.150
    42.916  3241.582     0.150
    42.928  3240.406     0.150
    44.077  3335.023     0.150
    44.091  3338.156     0.150
    44.095  3324.879     0.150
    79.865   724.250     0.150
     3.816   106.752     0.150
     4.377    65.152     0.150
     5.246    76.012     0.150
     6.204    87.463     0.150
     8.553   122.873     0.150
     8.901   126.572     0.150
     9.049   128.893     0.150
     9.842   137.883     0.150
    10.264   147.062     0.150
    10.288   147.963     0.150
    10.495   146.822     0.150
    11.402   161.562     0.150
    11.930   167.922     0.150
    12.104   168.533     0.150
    16.304   225.406     0.150
    16.322   228.803     0.150
    16.947   421.055     0.150
    19.769   561.900     0.150
    19.964   552.646     0.150
    20.291   585.564     0.150
    20.289   561.707     0.150
    20.289   517.799     0.150
    20.515    10.600     0.150
    20.515   505.223     0.150
    20.515   532.922     0.150
    20.657   569.373     0.150
    20.797   579.131     0.150
    20.889   588.889     0.150
    20.909   584.654     0.150
    20.982   588.191     0.150
    20.982   531.041     0.150
    21.073   586.475     0.150
    21.073   533.684     0.150
    21.286   594.465     0.150
    21.286   538.707     0.150
    21.420   597.949     0.150
    21.420   535.920     0.150
    21.484   600.736     0.150
    21.512   600.041     0.150
    21.512   540.797     0.150
    21.602   600.736     0.150
    21.602   540.797     0.150
    21.933   289.387     0.150
    21.840   597.396     0.150
    21.840   545.676     0.150
    21.874   609.102     0.150
    21.927   613.283     0.150
    21.927   547.070     0.150
    22.128   630.010     0.150
    22.199   612.586     0.150
    22.199   553.344     0.150
    22.480   630.010     0.150
    22.480   558.920     0.150
    22.591   630.707     0.150
    22.591   557.525     0.150
    22.793   645.637     0.150
    22.958   639.768     0.150
    23.084   643.949     0.150
    23.084   574.643     0.150
    23.141   639.768     0.150
    23.141   564.494     0.150
    23.392   663.840     0.150
    24.115   313.562     0.150
    24.935   323.613     0.150
    24.937   321.898     0.150
    25.272   325.723     0.150
    27.045   339.092     0.150
    27.739   345.533     0.150
    27.748   350.033     0.150
    27.890   349.123     0.150
    29.888   367.512     0.150
    31.569   382.213     0.150
    31.856   381.672     0.150
    31.886   382.322     0.150
    31.886   382.312     0.150
    32.586   393.043     0.150
    32.644   393.684     0.150
    32.780   390.912     0.150
    33.689   397.184     0.150
    34.385   406.393     0.150
    35.159   411.592     0.150
    35.531   417.623     0.150
    35.531   417.643     0.150
    35.624   416.742     0.150
    35.828   746.623     0.150
    35.828   922.422     0.150
    35.889   757.723     0.150
    35.984   750.723     0.150
    35.984   927.023     0.150
    36.041   419.701     0.150
    36.336   424.613     0.150
    36.473   424.902     0.150
    36.966   429.857     0.150
    36.966   791.584     0.150
    36.966   428.613     0.150
    37.064   429.193     0.150
    37.879   435.924     0.150
    37.947   435.473     0.150
    38.294   439.633     0.150
    38.460   439.873     0.150
    38.693   439.922     0.150
    39.689   450.016     0.150
    40.241   455.441     0.150
    41.123   462.592     0.150
    41.446   463.822     0.150
    42.921  3232.225     0.150
    42.927  3227.568     0.150
    42.939  3234.178     0.150
    43.699   482.242     0.150
    44.086  3337.424     0.150
    44.100  3315.354     0.150
    44.104  3319.902     0.150
    45.191   495.312     0.150
    46.570   504.422     0.150
    46.572   505.912     0.150
    46.822   507.523     0.150
    46.822   507.662     0.150
    47.582    11.900     0.150
    47.762   514.863     0.150
    49.532   523.812     0.150
    51.599   543.922     0.150
    51.636   544.143     0.150
    53.092   553.918     0.150
    54.279   565.652     0.150
    54.333   563.469     0.150
    54.357   564.012     0.150
    54.628   566.043     0.150
    56.032   576.303     0.150
    57.656   595.723     0.150
    63.196   623.822     0.150
    63.196  1122.223     0.150
    64.131    10.201     0.150
    64.131    14.301     0.150
    64.429   633.023     0.150
    64.651    16.000     0.150
    65.488  4893.422     0.150
    65.733   640.723     0.150
    66.104   643.863     0.150
    66.229     7.400     0.150
    68.751   661.812     0.150
    68.991   657.822     0.150
    69.717   685.023     0.150
    70.501   672.322     0.150
    70.622    10.301     0.150
    70.622  1219.322     0.150
    70.622  1236.223     0.150
    70.622  1490.822     0.150
    71.645   677.973     0.150
    71.809   679.922     0.150
    71.925   678.123     0.150
    72.461   684.863     0.150
    72.536  5422.723     0.150
    72.607  5427.922     0.150
    72.762  5439.523     0.150
    73.254   686.422     0.150
    73.467   690.393     0.150
    73.561   690.480     0.150
    74.235   705.223     0.150
    74.235   693.922     0.150
    74.435   695.262     0.150
    74.635   695.842     0.150
    74.606   700.422     0.150
    74.606  1289.422     0.150
    74.709   697.123     0.150
    74.709   697.203     0.150
    74.813   697.846     0.150
    74.707   694.023     0.150
    75.281   700.922     0.150
    75.307   708.023     0.150
    75.307   700.922     0.150
    75.479   701.590     0.150
    75.592   702.723     0.150
    75.616   702.422     0.150
    75.698   702.623     0.150
    75.852   703.623     0.150
    76.040   705.090     0.150
    76.276   706.723     0.150
    76.281   706.795     0.150
    76.434   707.422     0.150
    76.549   708.822     0.150
    76.747   709.223     0.150
    76.911   709.797     0.150
    76.911   709.783     0.150
    76.927   710.193     0.150
    77.049   729.822     0.150
    77.166   712.023     0.150
    77.203   711.723     0.150
    77.216   712.123     0.150
    77.304   711.922     0.150
    77.304   711.922     0.150
    78.419   866.223     0.150
    78.419   717.223     0.150
    78.419   730.223     0.150
    78.243  5850.123     0.150
    80.544   729.123     0.150
    80.662  1028.623     0.150
    80.662  1850.023     0.150
    80.787   731.912     0.150
    80.927   731.191     0.150
    80.927   730.422     0.150
    80.976   732.092     0.150
    81.266   734.123     0.150
    81.599   734.963     0.150
    82.566   742.322     0.150
    82.544   742.480     0.150
    83.168   745.213     0.150
    83.883   748.043     0.150
    85.177   755.242     0.150
    99.064   819.213     0.150
   153.665  1197.473     0.150
   153.665  1195.123     0.150
     1.509    26.273     0.150
     1.619    29.482     0.150
     5.231   155.062     0.150
     6.214    86.002     0.150
    34.674   410.971     0.150
    41.682   583.512     0.150
    70.502   673.193     0.150
    70.502   717.742     0.150
    71.106   710.113     0.150
     0.889    32.436     0.150
     1.065    18.756     0.150
     1.160    20.596     0.150
     1.188    21.334     0.150
     1.248    22.006     0.150
     6.875    99.945     0.150
     8.843   127.705     0.150
     9.249   131.936     0.150
     9.742   140.814     0.150
    11.423   162.176     0.150
    11.711   165.305     0.150
    63.909   628.219     0.150
     1.081    20.074     0.150
     1.869    59.926     0.150
     7.273   108.797     0.150
    17.433   246.691     0.150
    42.437  3202.570     0.150
    42.443  3203.016     0.150
    42.455  3201.238     0.150
    43.603  3294.172     0.150
    43.616  3295.242     0.150
    43.620  3295.215     0.150
    71.157   675.836     0.150
    73.435   689.785     0.150
    77.018   710.566     0.150
     0.647    23.926     0.150
     1.381    24.215     0.150
     1.868    48.676     0.150
     3.603    53.238     0.150
     3.681    54.746     0.150
     6.385    91.117     0.150
    10.320   146.125     0.150
    10.906   154.477     0.150
    13.445   185.848     0.150
    13.779   191.137     0.150
    14.374   207.047     0.150
    20.896    10.898     0.150
    20.896   293.285     0.150
    26.865   339.066     0.150
    28.133   348.648     0.150
    31.754   383.496     0.150
    36.076   417.477     0.150
    36.398   419.816     0.150
    40.763   461.387     0.150
    43.816  3297.992     0.150
    43.822  3298.426     0.150
    43.834  3305.250     0.150
    44.977  3390.566     0.150
    44.990  3385.910     0.150
    44.995  3391.840     0.150
    46.135   500.586     0.150
    46.135   500.656     0.150
    46.249   513.887     0.150
    46.249   513.898     0.150
    62.097   616.785     0.150
    64.329    11.402     0.150
    64.814     7.098     0.150
    64.814    11.000     0.150
    66.763   651.988     0.150
    70.222  5252.887     0.150
    70.482  5272.586     0.150
    71.879   677.688     0.150
    72.603  5430.988     0.150
    72.614  5432.086     0.150
    72.685  5437.188     0.150
    72.915   682.887     0.150
    72.834  5448.387     0.150
    73.216   685.387     0.150
    73.042  5464.387     0.150
    73.907   691.387     0.150
    74.555   695.785     0.150
    74.555   695.766     0.150
    75.013   699.086     0.150
    75.302   700.285     0.150
    76.937   709.988     0.150
    78.423   719.027     0.150
    78.329  5859.887     0.150
    82.090   736.625     0.150
   111.116  8344.176     0.150
   111.128  8345.457     0.150
   111.133  8346.484     0.150
     0.642    14.457     0.150
     3.193    89.137     0.150
     3.708    58.719     0.150
     3.907    61.137     0.150
     3.970    62.008     0.150
     3.970   108.070     0.150
     3.974    62.410     0.150
     3.867   109.328     0.150
     4.709    70.367     0.150
     7.268   106.137     0.150
     7.394   106.527     0.150
     7.953   114.820     0.150
     9.899   141.387     0.150
    11.176   156.609     0.150
    11.590   281.422     0.150
    13.912   197.809     0.150
    25.452   326.848     0.150
    26.802   338.918     0.150
    28.701   355.160     0.150
    32.101   385.969     0.150
    34.629   407.359     0.150
    36.123   422.000     0.150
    43.459  3258.578     0.150
    43.465  3270.418     0.150
    43.477  3272.750     0.150
    44.625  3341.121     0.150
    44.638  3344.699     0.150
    44.642  3342.602     0.150
    46.123   502.000     0.150
    48.642   523.359     0.150
    51.666   544.340     0.150
    52.644   551.859     0.150
    55.669   576.582     0.150
    58.668   597.539     0.150
    64.020   630.000     0.150
    64.821   637.098     0.150
    64.821     5.602     0.150
    64.821     8.301     0.150
    66.251   649.797     0.150
    74.368   697.930     0.150
    79.900   733.199     0.150
    80.297   733.797     0.150
    80.465   733.000     0.150
    80.680   734.297     0.150
    80.767   732.898     0.150
    80.799   734.297     0.150
    80.805   734.699     0.150
    80.914   733.797     0.150
    81.476   735.699     0.150
   111.691  8377.449     0.150
   111.702  8378.820     0.150
   111.707  8376.859     0.150
   153.360  1199.375     0.150
     1.333    23.912     0.150
     6.886    96.703     0.150
     8.717   123.252     0.150
     9.680   137.043     0.150
    10.251   146.082     0.150
    10.354   146.533     0.150
    10.483   148.832     0.150
    18.281   448.729     0.150
    20.580     7.699     0.150
    20.580    17.699     0.150
    20.580   538.303     0.150
    24.793   318.873     0.150
    24.793   318.523     0.150
    31.718   380.803     0.150
    35.933   418.902     0.150
    37.992   435.803     0.150
    43.101  3230.602     0.150
    43.107  3232.223     0.150
    43.119  3249.691     0.150
    44.265  3338.633     0.150
    44.279  3339.287     0.150
    44.283  3341.627     0.150
    46.702   505.604     0.150
    53.399   567.303     0.150
    53.399   567.303     0.150
    54.816   566.604     0.150
    55.982   574.104     0.150
    57.219   587.803     0.150
    64.161   631.854     0.150
    64.260   633.303     0.150
    64.260     6.500     0.150
    64.260    10.500     0.150
    64.793     8.500     0.150
    64.793    13.699     0.150
    64.852   635.523     0.150
    66.077   643.293     0.150
    66.186   643.752     0.150
    66.327   648.303     0.150
    72.535   684.104     0.150
    73.531   689.133     0.150
    74.162   692.303     0.150
    76.735   708.604     0.150
    77.143   711.303     0.150
    81.424   734.303     0.150
   111.718  8380.443     0.150
   111.729  8383.285     0.150
   111.734  8375.471     0.150
     0.936    28.602     0.150
     1.095    21.531     0.150
     1.097    21.203     0.150
     1.584    49.273     0.150
     1.889    61.016     0.150
     1.903    35.508     0.150
     1.970    61.914     0.150
     2.296    69.820     0.150
     4.924    75.102     0.150
     5.687   171.430     0.150
     8.875   128.664     0.150
     9.343   134.352     0.150
     9.883   144.281     0.150
    10.261   146.547     0.150
    11.660   165.805     0.150
    12.493   171.953     0.150
    12.493   303.789     0.150
    12.493   176.805     0.150
    14.863   212.203     0.150
    20.492   274.664     0.150
    24.320   318.227     0.150
    24.320   317.992     0.150
    35.703   414.766     0.150
    46.983   508.562     0.150
    50.193   537.164     0.150
    50.193   537.117     0.150
    54.523   568.266     0.150
    54.523   568.305     0.150
    55.991   576.570     0.150
    63.932   629.961     0.150
    63.942    10.602     0.150
    63.942    15.398     0.150
    64.341   633.773     0.150
    64.924  1154.961     0.150
    64.948   639.906     0.150
    65.925   644.875     0.150
    66.036   645.688     0.150
    66.119   649.062     0.150
    71.154   678.055     0.150
    71.200   671.766     0.150
    71.200   671.766     0.150
    71.200   671.766     0.150
    71.200   693.781     0.150
    71.200   826.320     0.150
    71.200   927.992     0.150
    71.200  1222.797     0.150
    71.200  1492.953     0.150
    71.200  1690.844     0.150
    71.995   684.188     0.150
    73.440   692.117     0.150
    74.503   697.664     0.150
    74.903   699.312     0.150
    76.268   708.273     0.150
    76.510   708.461     0.150
    76.790   711.664     0.150
    76.992   712.797     0.150
    78.201   718.125     0.150
    78.742   722.391     0.150
    80.994   734.117     0.150
     0.975    18.527     0.150
     0.975    30.748     0.150
     1.569    51.580     0.150
     1.569    29.018     0.150
     1.569    51.578     0.150
     2.028    35.998     0.150
     5.111    75.559     0.150
     5.729   171.303     0.150
     5.729    84.229     0.150
     6.836   101.938     0.150
     7.277   107.938     0.150
    11.704   167.729     0.150
    12.204   179.658     0.150
    13.479   197.547     0.150
    42.439  3202.672     0.150
    42.445  3203.172     0.150
    42.457  3203.715     0.150
    43.605  3291.994     0.150
    43.619  3292.465     0.150
    43.623  3294.186     0.150
    47.763   609.252     0.150
    65.932   643.154     0.150
     0.863    16.082     0.150
     1.438    25.551     0.150
     1.649    50.559     0.150
     1.824    30.770     0.150
     2.280    34.773     0.150
     2.415    39.273     0.150
     2.415    71.234     0.150
     4.090    59.254     0.150
     4.721    68.047     0.150
     7.689   110.508     0.150
     9.959   142.270     0.150
    43.444  3253.895     0.150
    43.450  3253.648     0.150
    43.462  3254.613     0.150
    44.608  3339.695     0.150
    44.621  3340.734     0.150
    44.625  3341.238     0.150
     0.786    14.992     0.150
     1.429    25.148     0.150
     1.453    25.477     0.150
     1.468    25.953     0.150
     1.468    25.953     0.150
     1.647    27.367     0.150
     2.426    70.828     0.150
     2.461    41.297     0.150
     3.434    54.883     0.150
     3.542    56.531     0.150
     4.898   146.672     0.150
     4.898    70.852     0.150
     4.898    70.703     0.150
     6.617    94.719     0.150
     6.883    97.992     0.150
     8.548   121.797     0.150
     8.750   124.180     0.150
     9.533   134.281     0.150
     9.833   138.148     0.150
     9.832   138.328     0.150
    10.123   142.781     0.150
    10.241   146.273     0.150
    10.225   143.523     0.150
    10.467   146.359     0.150
    10.662   151.789     0.150
    10.942   152.992     0.150
    11.080   155.695     0.150
    11.537   159.680     0.150
    11.721   165.031     0.150
    11.838   162.859     0.150
    11.838   163.961     0.150
    13.570   188.703     0.150
    14.649   208.023     0.150
    18.145   451.703     0.150
    18.145   247.867     0.150
    24.578   319.500     0.150
    24.583   318.312     0.150
    25.705   330.883     0.150
    26.225   335.070     0.150
    26.713   339.492     0.150
    26.811   338.328     0.150
    26.841   337.148     0.150
    26.841   337.180     0.150
    27.420   346.117     0.150
    27.420   345.719     0.150
    27.564   344.555     0.150
    27.812   350.250     0.150
    27.926   347.125     0.150
    28.284   353.320     0.150
    29.288   361.570     0.150
    29.567   362.344     0.150
    30.652   373.883     0.150
    30.712   370.211     0.150
    31.022   374.500     0.150
    31.251   379.062     0.150
    31.395   379.906     0.150
    31.447   379.148     0.150
    31.592   380.047     0.150
    31.826   384.188     0.150
    32.265   388.906     0.150
    32.325   388.602     0.150
    32.997   394.180     0.150
    33.080   394.594     0.150
    34.021   402.773     0.150
    34.021   402.750     0.150
    34.082   403.094     0.150
    34.695   409.117     0.150
    35.212   413.594     0.150
    35.212   413.523     0.150
    35.314   414.656     0.150
    35.543   428.453     0.150
    35.523   414.922     0.150
    35.574   416.281     0.150
    35.891   418.359     0.150
    36.029   492.250     0.150
    36.122   421.070     0.150
    36.154   420.922     0.150
    36.154   420.875     0.150
    36.231   421.383     0.150
    36.236   422.539     0.150
    36.692   424.891     0.150
    37.568   434.008     0.150
    37.642   433.680     0.150
    37.748   432.961     0.150
    38.505   442.750     0.150
    38.875   445.438     0.150
    39.948   453.312     0.150
    40.072   451.406     0.150
    40.795   460.602     0.150
    41.347   464.320     0.150
    42.404   471.250     0.150
    42.562   473.438     0.150
    43.267  3251.648     0.150
    43.272  3251.539     0.150
    43.284  3252.891     0.150
    44.018   483.500     0.150
    44.170   484.938     0.150
    44.430  3336.828     0.150
    44.444  3336.422     0.150
    44.448  3338.234     0.150
    45.084    11.398     0.150
    45.290   492.617     0.150
    45.399   493.883     0.150
    45.546   497.258     0.150
    45.546   497.250     0.150
    45.546   497.258     0.150
    45.933   500.594     0.150
    46.389   502.977     0.150
    46.447   504.320     0.150
    46.591   505.828     0.150
    46.998   507.570     0.150
    47.066   510.039     0.150
    47.485   514.047     0.150
    47.485   514.078     0.150
    48.142   516.969     0.150
    48.221   516.000     0.150
    48.432   519.867     0.150
    48.482   518.523     0.150
    49.082   523.891     0.150
    49.082   523.938     0.150
    49.176   523.867     0.150
    49.187   524.133     0.150
    49.571   529.570     0.150
    49.878   530.500     0.150
    50.642   534.750     0.150
    50.844   537.891     0.150
    51.068   538.844     0.150
    51.120   537.977     0.150
    51.261   540.859     0.150
    51.389   542.031     0.150
    51.389   540.148     0.150
    52.267   546.617     0.150
    53.555   557.008     0.150
    53.637   557.211     0.150
    53.698   557.289     0.150
    53.871   558.641     0.150
    53.902   559.961     0.150
    54.129   561.188     0.150
    54.566   562.953     0.150
    54.561   564.281     0.150
    54.928   567.969     0.150
    55.492    11.102     0.150
    55.492   864.547     0.150
    55.512   571.977     0.150
    55.539   572.844     0.150
    55.677   574.547     0.150
    55.704   572.633     0.150
    55.704   572.672     0.150
    55.935   633.852     0.150
    55.935   573.594     0.150
    55.881   574.492     0.150
    56.433   578.141     0.150
    58.332   588.852     0.150
    59.454   600.750     0.150
    60.388   606.453     0.150
    62.032   616.711     0.150
    62.238   616.352     0.150
    63.514     8.297     0.150
    63.721   626.852     0.150
    63.721   663.453     0.150
    63.822    11.703     0.150
    63.822  1134.250     0.150
    63.905   627.102     0.150
    63.905   627.047     0.150
    63.987   629.930     0.150
    64.275   630.547     0.150
    64.289   631.547     0.150
    64.378    11.805     0.150
    64.612   632.844     0.150
    64.612   632.750     0.150
    64.922    12.297     0.150
    65.119   638.773     0.150
    66.152   643.359     0.150
    66.260   644.461     0.150
    66.417     8.898     0.150
    66.417    17.398     0.150
    66.836   646.719     0.150
    66.836   646.648     0.150
    66.995   650.047     0.150
    68.738   661.211     0.150
    68.947   659.352     0.150
    68.947   670.453     0.150
    68.995  1202.453     0.150
    69.127   662.469     0.150
    69.127   662.453     0.150
    69.670   675.953     0.150
    69.670   685.852     0.150
    69.670  1485.852     0.150
    69.909   669.078     0.150
    70.142   668.250     0.150
    70.295   667.812     0.150
    70.295   667.750     0.150
    70.330   668.953     0.150
    70.330   668.953     0.150
    70.210  5253.148     0.150
    70.473   670.188     0.150
    70.473   670.148     0.150
    70.617   670.000     0.150
    70.670   671.242     0.150
    70.670   671.148     0.150
    70.784   672.242     0.150
    70.784   672.148     0.150
    70.841   671.961     0.150
    70.841   671.953     0.150
    70.912   692.852     0.150
    70.912   933.648     0.150
    70.912   672.930     0.150
    70.912   672.930     0.150
    70.912   672.930     0.150
    70.912   692.859     0.150
    70.912   830.344     0.150
    70.912   933.656     0.150
    70.912  1229.062     0.150
    70.912  1501.758     0.150
    70.912  1701.180     0.150
    70.929    12.094     0.150
    71.207   674.891     0.150
    71.207   674.852     0.150
    71.151   675.211     0.150
    71.151   675.148     0.150
    71.353   676.648     0.150
    71.466   676.719     0.150
    71.844   678.047     0.150
    71.953   679.953     0.150
    72.402   684.031     0.150
    72.602   684.898     0.150
    72.573  5430.352     0.150
    72.652  5436.250     0.150
    73.025  5464.250     0.150
    73.496   688.680     0.150
    73.496   688.648     0.150
    73.574   690.562     0.150
    73.589   690.039     0.150
    73.589   690.180     0.150
    73.882   692.469     0.150
    73.882   692.453     0.150
    74.095   693.148     0.150
    74.207   692.750     0.150
    74.401   694.430     0.150
    74.462   694.672     0.150
    74.601   694.898     0.150
    74.601   694.852     0.150
    74.631   694.992     0.150
    74.648   695.594     0.150
    74.666   699.547     0.150
    74.681   697.164     0.150
    74.763   701.547     0.150
    74.881   698.852     0.150
    74.943   698.953     0.150
    75.014   699.250     0.150
    75.139   700.148     0.150
    75.180   700.148     0.150
    75.232   700.398     0.150
    75.232   700.820     0.150
    75.176   698.547     0.150
    75.367   700.492     0.150
    75.467   701.648     0.150
    75.481   701.852     0.150
    75.607   702.008     0.150
    75.607   702.047     0.150
    75.608   702.148     0.150
    75.732   703.148     0.150
    75.782   702.469     0.150
    75.782   703.352     0.150
    75.940   703.922     0.150
    76.184   705.281     0.150
    76.296   706.750     0.150
    76.296   716.250     0.150
    76.405   707.930     0.150
    76.435   708.148     0.150
    76.587   707.320     0.150
    76.645   708.852     0.150
    76.684   708.750     0.150
    76.751   708.383     0.150
    76.762   708.438     0.150
    76.947   717.453     0.150
    77.044   711.352     0.150
    77.086   711.047     0.150
    77.106   711.352     0.150
    77.129   710.547     0.150
    77.181   711.250     0.150
    77.354   713.148     0.150
    77.670   711.555     0.150
    77.670   714.242     0.150
    77.853   714.750     0.150
    77.885   714.188     0.150
    77.897   714.648     0.150
    77.897   714.688     0.150
    78.334   718.453     0.150
    78.291  5858.852     0.150
    78.667   719.781     0.150
    78.781   719.281     0.150
    79.051   720.219     0.150
    79.264   722.094     0.150
    79.451   722.883     0.150
    79.584   727.039     0.150
    79.830   727.047     0.150
    79.850   727.203     0.150
    79.936   722.953     0.150
    79.936  1842.547     0.150
    80.020   727.352     0.150
    80.255   736.961     0.150
    80.432   729.828     0.150
    80.398  6015.750     0.150
    80.837   717.438     0.150
    80.949   732.133     0.150
    81.278   733.031     0.150
    81.569   734.852     0.150
    81.740   734.820     0.150
    82.404   743.438     0.150
    82.970   741.711     0.150
    83.048   743.000     0.150
    83.154   742.234     0.150
    83.154   742.391     0.150
    83.179   744.930     0.150
    83.524   741.797     0.150
    84.434   750.953     0.150
    84.572   750.898     0.150
    84.735   752.547     0.150
    84.802   751.367     0.150
    85.129   754.133     0.150
    85.188   754.352     0.150
    85.628   757.547     0.150
    86.144   752.703     0.150
    86.354   758.680     0.150
    87.707   766.133     0.150
    96.556   807.148     0.150
   111.589  8371.516     0.150
   111.600  8374.031     0.150
   111.605  8373.227     0.150
   158.967  1195.438     0.150
   159.751  1195.875     0.150
     0.635    13.625     0.150
     0.635    13.625     0.150
     1.300    24.703     0.150
     1.678    29.758     0.150
     1.643    29.477     0.150
     2.012    33.266     0.150
     3.575    56.266     0.150
     4.073    61.352     0.150
     4.808    70.047     0.150
     5.417   134.562     0.150
     6.926   101.961     0.150
     7.296   106.547     0.150
     7.343   106.516     0.150
     7.906   114.773     0.150
     8.532   122.094     0.150
     8.529   122.602     0.150
    10.031   142.547     0.150
    12.185   172.789     0.150
    13.983   197.625     0.150
     0.591    11.934     0.150
     0.591    20.910     0.150
     0.955    18.625     0.150
     0.955    33.066     0.150
     1.654    28.750     0.150
     1.548    47.105     0.150
     3.109    46.641     0.150
     2.963    47.523     0.150
     3.500    53.914     0.150
     3.500    94.660     0.150
     4.848    69.699     0.150
     5.514    80.273     0.150
     6.910    99.691     0.150
     7.360   105.422     0.150
     7.883   113.555     0.150
     8.035   115.262     0.150
     8.092   115.535     0.150
     8.988   127.129     0.150
     9.290   131.137     0.150
     9.594   135.004     0.150
     9.974   140.098     0.150
     9.997   141.297     0.150
    11.302   158.004     0.150
     0.844    18.266     0.150
     0.836    16.977     0.150
     1.002    21.133     0.150
     1.076    20.992     0.150
     1.076    21.117     0.150
     1.376    25.414     0.150
     1.543    28.445     0.150
     1.731    50.336     0.150
     1.731    28.742     0.150
     1.822    31.797     0.150
     1.861    32.383     0.150
     1.891    33.367     0.150
     1.891    33.336     0.150
     1.988    34.875     0.150
     2.469    42.742     0.150
     2.406    41.086     0.150
     2.609    44.594     0.150
     2.732    46.352     0.150
     2.721    75.805     0.150
     2.721    42.398     0.150
     2.721    42.633     0.150
     3.026    48.836     0.150
     3.036    49.492     0.150
     3.163    51.305     0.150
     3.243    52.508     0.150
     3.375    53.805     0.150
     3.453    52.008     0.150
     3.453    52.148     0.150
     3.615    56.680     0.150
     3.556    56.906     0.150
     3.676    58.617     0.150
     4.068    60.539     0.150
     4.173    63.734     0.150
     4.359    66.203     0.150
     4.359    66.477     0.150
     4.313   117.594     0.150
     4.313    66.797     0.150
     4.784    72.391     0.150
     4.784    72.539     0.150
     4.818    72.734     0.150
     4.851    73.258     0.150
     4.861   131.281     0.150
     5.048    76.195     0.150
     5.446    81.188     0.150
     5.644    83.836     0.150
     5.644    83.828     0.150
     5.810    86.578     0.150
     5.810    86.930     0.150
     6.654    98.758     0.150
     6.689    98.812     0.150
     6.711    99.188     0.150
     6.841   100.578     0.150
     7.033   102.898     0.150
     7.466   109.117     0.150
     7.466   109.070     0.150
     7.604   110.484     0.150
     7.628   110.562     0.150
     7.628   110.531     0.150
     7.628   110.734     0.150
     7.720   110.312     0.150
     7.724   110.336     0.150
     7.905   112.133     0.150
     8.003   113.195     0.150
     8.325   117.820     0.150
     8.685   123.031     0.150
     8.685   122.969     0.150
     9.374   134.516     0.150
     9.374   134.977     0.150
     9.393   132.336     0.150
     9.567   134.977     0.150
     9.638   136.531     0.150
     9.754   139.531     0.150
     9.727   139.141     0.150
     9.887   138.633     0.150
    10.042   141.023     0.150
    10.095   142.336     0.150
    10.095   142.297     0.150
    10.371   145.594     0.150
    10.632   151.656     0.150
    10.632   151.672     0.150
    10.836   151.555     0.150
    10.850   152.234     0.150
    10.833   151.523     0.150
    11.008   153.336     0.150
    11.092   154.867     0.150
    11.301   157.312     0.150
    11.308   157.336     0.150
    11.301   160.031     0.150
    11.575   163.352     0.150
    12.351   172.930     0.150
    12.817   179.859     0.150
    13.025   181.938     0.150
    13.025   181.859     0.150
    13.130   332.688     0.150
    13.289   186.086     0.150
    13.523   188.578     0.150
    13.715   185.484     0.150
    13.880   192.227     0.150
    13.880   192.195     0.150
    13.880   360.406     0.150
    14.041   194.406     0.150
    14.430   363.672     0.150
    15.819   221.758     0.150
    15.819   221.773     0.150
    16.206   224.531     0.150
    16.419   228.352     0.150
    17.304   431.055     0.150
    18.217   248.914     0.150
    19.319   262.992     0.150
    23.270   307.312     0.150
    23.342  2311.109     0.150
    23.646   311.586     0.150
    24.113   315.602     0.150
    24.817   356.938     0.150
    24.876   321.734     0.150
    25.314   323.133     0.150
    25.591   328.828     0.150
    25.846   327.156     0.150
    26.125   331.633     0.150
    26.856   340.422     0.150
    26.961   341.633     0.150
    26.961   340.992     0.150
    27.242   337.734     0.150
    27.694   344.516     0.150
    29.238   359.531     0.150
    29.642   361.203     0.150
    30.290   368.703     0.150
    30.888   373.133     0.150
    31.302   378.438     0.150
    31.787  2272.984     0.150
    32.204   388.258     0.150
    32.635   389.234     0.150
    33.166   396.219     0.150
    33.528   396.031     0.150
    33.795   398.766     0.150
    33.795  2268.836     0.150
    33.990   400.531     0.150
    34.530   401.633     0.150
    34.530   724.438     0.150
    34.735   407.070     0.150
    34.837   497.336     0.150
    34.890   408.875     0.150
    34.890   408.836     0.150
    35.002   408.391     0.150
    35.597   415.594     0.150
    35.597   415.656     0.150
    35.883   410.531     0.150
    35.883   742.336     0.150
    36.006   416.438     0.150
    36.006   416.492     0.150
    36.093   418.938     0.150
    36.093   756.617     0.150
    36.093   420.258     0.150
    36.381   422.312     0.150
    36.352   421.938     0.150
    36.701   422.633     0.150
    37.981   435.633     0.150
    37.981   436.406     0.150
    38.186   784.781     0.150
    39.259   445.625     0.150
    39.259   447.086     0.150
    39.259   446.836     0.150
    39.451   449.039     0.150
    40.028   451.422     0.150
    40.434   456.633     0.150
    40.434   457.352     0.150
    40.898   460.633     0.150
    41.506   462.891     0.150
    41.997   467.938     0.150
    42.941   475.305     0.150
    42.941   476.586     0.150
    43.580   480.922     0.150
    44.355   487.938     0.150
    44.355   486.836     0.150
    44.605   487.836     0.150
    44.605   488.531     0.150
    45.394    10.500     0.150
    45.394    16.500     0.150
    45.407   495.531     0.150
    45.767   498.531     0.150
    45.767   498.617     0.150
    45.730   497.992     0.150
    45.784   498.531     0.150
    45.845    10.500     0.150
    45.845    14.797     0.150
    45.845   911.234     0.150
    46.044   500.531     0.150
    46.044   502.336     0.150
    46.073   500.609     0.150
    46.270   502.297     0.150
    46.385   502.500     0.150
    46.647   504.734     0.150
    46.646   504.633     0.150
    46.646   505.328     0.150
    46.844   506.484     0.150
    47.340   508.836     0.150
    47.340   917.547     0.150
    47.340   509.531     0.150
    47.370   510.602     0.150
    47.387   510.781     0.150
    47.449   510.680     0.150
    47.457   510.656     0.150
    47.543   511.133     0.150
    47.504   511.031     0.150
    47.571   515.031     0.150
    47.596   511.617     0.150
    47.596   516.234     0.150
    47.625   511.836     0.150
    47.760   512.055     0.150
    47.852   513.531     0.150
    47.852   922.000     0.150
    47.924   515.016     0.150
    47.980   515.352     0.150
    47.980   515.352     0.150
    47.963   515.031     0.150
    47.963   516.078     0.150
    48.056   516.203     0.150
    48.170    12.703     0.150
    48.170    17.703     0.150
    48.168   516.555     0.150
    48.168   934.312     0.150
    48.454   518.984     0.150
    48.488   518.812     0.150
    48.510   519.031     0.150
    48.635   519.836     0.150
    48.642   519.625     0.150
    48.754   532.633     0.150
    48.754   603.031     0.150
    48.706   519.281     0.150
    48.793   520.172     0.150
    48.813   521.047     0.150
    48.873   522.039     0.150
    48.975   522.508     0.150
    48.975   942.398     0.150
    48.975   522.219     0.150
    49.210   524.336     0.150
    49.291   524.922     0.150
    49.291   943.688     0.150
    49.583   527.016     0.150
    49.618   526.977     0.150
    49.618   950.281     0.150
    49.715   527.938     0.150
    49.887   529.953     0.150
    49.931   531.266     0.150
    49.960   528.984     0.150
    49.960   529.562     0.150
    50.038   531.516     0.150
    50.283   532.227     0.150
    50.404   533.453     0.150
    50.428   533.188     0.150
    50.603   535.938     0.150
    50.580   534.734     0.150
    50.580   534.734     0.150
    50.580   964.164     0.150
    50.628   535.633     0.150
    50.628   535.758     0.150
    50.628   535.711     0.150
    50.628   535.805     0.150
    50.615   536.625     0.150
    50.615   536.664     0.150
    50.666   536.008     0.150
    50.666   536.008     0.150
    50.743   536.367     0.150
    50.782   539.531     0.150
    50.910   536.953     0.150
    50.910   536.953     0.150
    50.902   537.633     0.150
    50.984   538.297     0.150
    51.056   538.422     0.150
    51.056   970.602     0.150
    51.073   538.633     0.150
    51.073   971.211     0.150
    51.105   539.094     0.150
    51.105   539.094     0.150
    51.090   540.586     0.150
    51.136   538.516     0.150
    51.136   538.516     0.150
    51.196   539.234     0.150
    51.196   539.234     0.150
    51.233   540.531     0.150
    51.484    16.609     0.150
    51.476   541.984     0.150
    51.603   542.602     0.150
    51.603   542.602     0.150
    51.669   542.945     0.150
    51.669   979.109     0.150
    51.713   542.812     0.150
    51.823   544.008     0.150
    51.823   544.008     0.150
    51.851   544.812     0.150
    51.851   544.812     0.150
    51.884   544.531     0.150
    51.884   544.531     0.150
    51.901   545.336     0.150
    51.920   545.008     0.150
    51.920   545.008     0.150
    51.920   980.781     0.150
    51.962   545.562     0.150
    51.962   545.562     0.150
    51.952   546.703     0.150
    52.027   546.234     0.150
    52.215   546.453     0.150
    52.287   548.438     0.150
    52.287   551.734     0.150
    52.283   547.414     0.150
    52.335   548.133     0.150
    52.335   548.133     0.150
    52.368   548.812     0.150
    52.368   548.812     0.150
    52.415   548.734     0.150
    52.415   548.633     0.150
    52.492   549.328     0.150
    52.484   548.984     0.150
    52.484   548.984     0.150
    52.544   549.562     0.150
    52.675   554.133     0.150
    52.701   550.906     0.150
    52.701   550.906     0.150
    52.716   550.906     0.150
    52.815   552.086     0.150
    52.818   551.938     0.150
    52.817   551.586     0.150
    52.916   552.188     0.150
    52.908   552.281     0.150
    52.908   552.266     0.150
    53.030    12.797     0.150
    53.030    17.000     0.150
    53.030  1001.234     0.150
    53.067   553.359     0.150
    53.067   553.359     0.150
    53.067   996.328     0.150
    53.245   554.438     0.150
    53.318   555.883     0.150
    53.341   554.961     0.150
    53.348   554.867     0.150
    53.348   554.820     0.150
    53.375   555.938     0.150
    53.375   555.938     0.150
    53.384   556.070     0.150
    53.390   555.734     0.150
    53.433   555.711     0.150
    53.433  1004.203     0.150
    53.480   556.438     0.150
    53.480   556.484     0.150
    53.493   556.586     0.150
    53.570   557.117     0.150
    53.634   557.586     0.150
    53.635   555.234     0.150
    53.635    15.297     0.150
    53.635  1002.031     0.150
    53.653   558.078     0.150
    53.661   557.859     0.150
    53.675   558.094     0.150
    53.687   556.938     0.150
    53.707   558.688     0.150
    53.707   558.688     0.150
    53.792   559.133     0.150
    53.774   558.781     0.150
    53.774   558.781     0.150
    53.862   558.695     0.150
    53.862   558.695     0.150
    53.981   560.234     0.150
    53.981   560.312     0.150
    54.119   560.711     0.150
    54.171   560.773     0.150
    54.297   562.352     0.150
    54.336   562.844     0.150
    54.346   562.562     0.150
    54.389   563.141     0.150
    54.394   562.859     0.150
    54.441   564.062     0.150
    54.529   564.336     0.150
    54.660   565.938     0.150
    54.660   565.875     0.150
    54.629   565.062     0.150
    54.759   565.938     0.150
    54.759   565.961     0.150
    54.759   566.016     0.150
    54.777   565.328     0.150
    54.828   566.508     0.150
    54.903   567.031     0.150
    54.903   566.992     0.150
    54.903   566.992     0.150
    54.907   565.859     0.150
    54.989   568.227     0.150
    54.980   566.664     0.150
    55.043   566.734     0.150
    54.982   567.039     0.150
    55.043   568.078     0.150
    55.063   566.836     0.150
    55.112   567.547     0.150
    55.112   567.531     0.150
    55.112   567.375     0.150
    55.445   570.836     0.150
    55.656   571.938     0.150
    55.684   572.047     0.150
    55.754   573.438     0.150
    55.739     8.297     0.150
    55.739  1038.734     0.150
    55.719   572.289     0.150
    55.719   572.289     0.150
    55.727   572.922     0.150
    55.727   572.922     0.150
    55.733   572.852     0.150
    55.733   572.852     0.150
    55.759   572.938     0.150
    56.050   574.953     0.150
    56.050   575.383     0.150
    56.050   575.383     0.150
    56.335   577.016     0.150
    56.583   577.633     0.150
    56.522   578.758     0.150
    56.816   580.695     0.150
    57.127   581.523     0.150
    57.130   582.469     0.150
    58.043     9.703     0.150
    58.383   592.203     0.150
    58.514  1070.734     0.150
    58.617   592.758     0.150
    59.197  2378.086     0.150
    59.197   597.734     0.150
    60.216    10.203     0.150
    60.216    12.500     0.150
    60.216  1117.234     0.150
    60.172   602.734     0.150
    60.172   607.938     0.150
    61.793     9.000     0.150
    61.793    13.203     0.150
    63.400   625.031     0.150
    63.424   626.133     0.150
    63.584   626.938     0.150
    63.654  1559.836     0.150
    63.712   627.672     0.150
    63.712  1138.281     0.150
    63.713   628.031     0.150
    63.845   630.734     0.150
    64.063   631.531     0.150
    64.063     6.500     0.150
    64.063    10.500     0.150
    64.119   629.031     0.150
    64.471   663.633     0.150
    64.471  1218.133     0.150
    64.471  1563.031     0.150
    64.487   633.906     0.150
    64.487  1150.242     0.150
    64.477   637.336     0.150
    64.872   635.531     0.150
    64.872   635.953     0.150
    65.091     9.797     0.150
    65.091    15.000     0.150
    65.091  1151.734     0.150
    65.405   641.938     0.150
    65.835    10.000     0.150
    66.009   642.836     0.150
    66.009   642.531     0.150
    66.114   643.234     0.150
    66.352    10.500     0.150
    66.454   644.234     0.150
    66.454  1170.531     0.150
    67.784   654.344     0.150
    67.784   654.336     0.150
    68.392   654.633     0.150
    68.392   672.133     0.150
    68.392  1190.031     0.150
    68.964   662.367     0.150
    69.109   661.531     0.150
    69.109   678.336     0.150
    69.109  1197.133     0.150
    69.109  1477.938     0.150
    69.214   665.031     0.150
    69.214    10.703     0.150
    69.214    17.703     0.150
    69.415  1203.234     0.150
    70.182   670.062     0.150
    70.182  1218.477     0.150
    70.295   685.031     0.150
    70.295   822.133     0.150
    70.295   926.531     0.150
    70.295  1215.938     0.150
    70.295   669.164     0.150
    70.295   669.164     0.150
    70.295   669.164     0.150
    70.295   822.203     0.150
    70.295   926.555     0.150
    70.295  1215.953     0.150
    70.295  1489.375     0.150
    70.295  1692.055     0.150
    70.330   669.836     0.150
    70.330  1220.094     0.150
    70.465   671.305     0.150
    70.449   670.766     0.150
    70.531   672.312     0.150
    70.635   672.828     0.150
    70.635  1223.867     0.150
    70.667   671.836     0.150
    70.667   671.914     0.150
    70.667  1222.961     0.150
    70.806   673.203     0.150
    70.901   672.938     0.150
    71.044   675.188     0.150
    71.044  1228.531     0.150
    70.987   675.461     0.150
    71.191   676.336     0.150
    71.191   676.414     0.150
    71.218    12.203     0.150
    71.656   679.031     0.150
    71.656  1235.891     0.150
    71.892   680.633     0.150
    72.317   681.234     0.150
    72.418   683.953     0.150
    73.090   687.117     0.150
    73.145   688.836     0.150
    73.364   688.734     0.150
    73.364   688.734     0.150
    73.391   688.438     0.150
    73.391   848.734     0.150
    73.391  1252.734     0.150
    73.391  1514.734     0.150
    73.391  1724.734     0.150
    73.391  1838.734     0.150
    73.797    12.203     0.150
    73.797    16.203     0.150
    73.873   691.531     0.150
    73.873  1259.734     0.150
    74.027   691.734     0.150
    74.247  1254.336     0.150
    74.247   693.633     0.150
    74.326   693.734     0.150
    74.326   693.734     0.150
    74.378   695.336     0.150
    74.378   695.352     0.150
    74.378  1266.602     0.150
    74.378  1267.141     0.150
    74.385    17.797     0.150
    74.431   694.734     0.150
    74.494   695.234     0.150
    74.494  1263.836     0.150
    74.491   695.531     0.150
    74.491   695.516     0.150
    74.618   700.234     0.150
    74.618    13.500     0.150
    74.618  1275.734     0.150
    74.783   696.836     0.150
    74.785   696.633     0.150
    74.893   697.172     0.150
    74.893   697.133     0.150
    75.057   698.234     0.150
    75.103   698.633     0.150
    75.103   698.734     0.150
    75.425     9.000     0.150
    75.425  1565.031     0.150
    75.513   704.938     0.150
    75.513   704.938     0.150
    75.544   701.531     0.150
    75.593   717.234     0.150
    75.593  1271.734     0.150
    75.593   701.734     0.150
    75.767   703.734     0.150
    75.885  2345.359     0.150
    75.941  1273.438     0.150
    75.995   704.531     0.150
    76.020   703.031     0.150
    76.024   703.938     0.150
    76.028   704.336     0.150
    76.297   710.734     0.150
    76.297   721.336     0.150
    76.297   874.234     0.150
    76.297  1280.734     0.150
    76.297  1320.734     0.150
    76.297  1776.734     0.150
    76.363   706.734     0.150
    76.414   706.336     0.150
    76.445   706.633     0.150
    76.499   707.336     0.150
    76.500   707.734     0.150
    76.631   706.500     0.150
    76.672   708.531     0.150
    76.658   706.836     0.150
    77.005   709.633     0.150
    77.005   709.672     0.150
    77.085   710.836     0.150
    77.267   711.266     0.150
    77.428   712.531     0.150
    77.534   713.305     0.150
    77.546   713.469     0.150
    77.628   715.453     0.150
    77.710   713.195     0.150
    77.743  2889.734     0.150
    77.743   712.734     0.150
    77.743   722.734     0.150
    77.743  1298.734     0.150
    77.804   714.438     0.150
    77.822   722.734     0.150
    77.822  1299.234     0.150
    77.822  1313.734     0.150
    78.139   719.031     0.150
    78.190   713.531     0.150
    78.549   718.234     0.150
    78.644   719.031     0.150
    78.690   718.844     0.150
    78.690   718.781     0.150
    78.747   717.625     0.150
    79.107   721.836     0.150
    79.192   735.734     0.150
    79.344  1833.336     0.150
    79.368   722.812     0.150
    79.368   722.836     0.150
    79.442   723.141     0.150
    79.494  1008.438     0.150
    79.494  1829.438     0.150
    79.588   725.008     0.150
    79.588   725.031     0.150
    79.588   724.414     0.150
    79.730   722.008     0.150
    80.119   726.336     0.150
    80.131   724.734     0.150
    80.131  1014.336     0.150
    80.131  1841.734     0.150
    80.297   727.625     0.150
    80.297   727.594     0.150
    80.297   727.633     0.150
    80.765   914.133     0.150
    80.765  1337.234     0.150
    80.817   729.703     0.150
    80.817   729.734     0.150
    80.993   725.961     0.150
    81.291   725.961     0.150
    81.291   727.992     0.150
    81.387   734.734     0.150
    81.329   730.281     0.150
    81.556   733.133     0.150
    81.549   733.734     0.150
    82.000   736.531     0.150
    82.012   732.047     0.150
    82.328   737.836     0.150
    82.340   739.438     0.150
    82.337   734.086     0.150
    82.484   738.938     0.150
    82.533   741.234     0.150
    82.459   734.078     0.150
    82.648   740.031     0.150
    82.648  1354.438     0.150
    82.720   741.438     0.150
    82.812  2332.586     0.150
    82.862   741.836     0.150
    82.862   741.953     0.150
    82.772   739.336     0.150
    82.896   745.438     0.150
    83.321   740.633     0.150
    83.387   742.836     0.150
    83.574   745.234     0.150
    83.696  1364.867     0.150
    83.696   745.633     0.150
    83.696   745.531     0.150
    83.696  1364.836     0.150
    83.626   745.734     0.150
    83.864   746.234     0.150
    83.951   747.016     0.150
    83.951   747.031     0.150
    84.109  1367.664     0.150
    84.109   747.633     0.150
    84.109  1367.633     0.150
    84.146   747.836     0.150
    84.197   747.625     0.150
    84.226   942.938     0.150
    84.226  1370.938     0.150
    84.305   749.438     0.150
    84.209   749.234     0.150
    84.209   749.141     0.150
    84.333   748.734     0.150
    84.447   750.836     0.150
    84.406   749.938     0.150
    84.563   750.336     0.150
    84.629   750.938     0.150
    84.630  2335.281     0.150
    84.824   751.133     0.150
    85.271   753.031     0.150
    85.590   755.633     0.150
    85.666   755.703     0.150
    86.082   952.938     0.150
    86.120   758.234     0.150
    86.137   756.633     0.150
    86.776   761.133     0.150
    86.881   760.438     0.150
    87.724   764.336     0.150
    87.744   765.164     0.150
    87.887   766.633     0.150
    88.525   769.133     0.150
    88.539   769.531     0.150
    89.584   772.695     0.150
    89.877   779.531     0.150
    90.760   783.133     0.150
    93.574   794.758     0.150
    93.983   794.133     0.150
    94.714   799.984     0.150
    98.704   815.336     0.150
   117.545  1748.586     0.150
   120.703  1127.508     0.150
   135.062  1154.031     0.150
   143.706  1168.562     0.150
   144.336  1171.742     0.150
   144.631  1172.414     0.150
   147.264  1178.633     0.150
   147.487  1176.031     0.150
   149.449  1183.234     0.150
   150.516  1184.883     0.150
   153.047  1189.617     0.150
   153.047  1189.617     0.150
   157.317  1190.477     0.150
     0.810    16.305     0.150
     0.810    29.297     0.150
     0.817    29.512     0.150
     1.078    20.652     0.150
     1.104    20.221     0.150
     1.104    36.631     0.150
     1.104    20.578     0.150
     1.537    26.641     0.150
     1.719    27.828     0.150
     1.853    31.652     0.150
     1.891    32.541     0.150
     1.920    33.541     0.150
     2.030    34.701     0.150
     2.156    36.602     0.150
     2.433    40.801     0.150
     2.726    41.533     0.150
     2.846    45.652     0.150
     3.043    48.402     0.150
     3.663    57.631     0.150
     3.692    58.262     0.150
     3.692   104.061     0.150
     4.087    59.596     0.150
     4.325   119.182     0.150
     4.429    67.230     0.150
     4.872    72.801     0.150
     5.506    80.271     0.150
     5.681    82.211     0.150
     5.687    82.820     0.150
     6.764    99.432     0.150
     7.093   102.137     0.150
     7.112   103.285     0.150
     7.350   105.064     0.150
     7.376   104.783     0.150
     7.523   108.652     0.150
     7.564   107.688     0.150
     7.555   107.779     0.150
     8.220   119.424     0.150
     8.548   119.947     0.150
    10.075   141.822     0.150
    12.366   170.896     0.150
    16.035   224.412     0.150
    22.868   302.891     0.150
    24.049   312.531     0.150
    24.074   314.332     0.150
    24.074   314.662     0.150
    32.174   387.121     0.150
    33.308   393.512     0.150
    33.604   394.742     0.150
    33.588   398.402     0.150
    33.763   399.602     0.150
    36.367   420.314     0.150
    37.242   428.381     0.150
    38.778   441.084     0.150
    39.542   448.715     0.150
    40.460   456.229     0.150
    41.425   459.342     0.150
    41.745   463.951     0.150
    47.622   509.182     0.150
    51.278   540.941     0.150
    52.330   546.441     0.150
    53.087   551.041     0.150
    54.757   563.539     0.150
    55.366   568.941     0.150
    64.195   628.441     0.150
    64.119    12.299     0.150
    64.547    11.900     0.150
    64.547   768.641     0.150
    64.537     8.801     0.150
    64.537    13.500     0.150
    65.151     9.199     0.150
    65.151    13.500     0.150
    66.422   648.941     0.150
    69.480     5.600     0.150
    72.492   683.041     0.150
    73.457   687.941     0.150
    73.457    12.000     0.150
    74.561   694.842     0.150
    74.561   706.041     0.150
    74.690   699.742     0.150
    74.690    13.398     0.150
    74.851   696.941     0.150
    74.851   709.141     0.150
    75.660   701.242     0.150
    75.951   702.611     0.150
    79.420   719.541     0.150
    80.617   729.541     0.150
    81.141   732.041     0.150
    81.161   732.041     0.150
    81.896   736.342     0.150
    84.703   748.342     0.150
     0.499    10.695     0.150
     1.054    18.070     0.150
     1.160    20.750     0.150
     1.378    22.438     0.150
     1.378    40.086     0.150
     1.467    25.266     0.150
     1.467    45.078     0.150
     2.419    37.344     0.150
     3.114    47.555     0.150
     3.420    50.969     0.150
     4.019    60.055     0.150
     4.363    64.852     0.150
     4.442    65.266     0.150
     4.557    66.875     0.150
     4.754   141.203     0.150
     4.754    68.594     0.150
     4.861    71.234     0.150
     5.039    73.531     0.150
     5.316    77.688     0.150
     5.381    78.641     0.150
     5.721    83.336     0.150
     5.921    85.938     0.150
     6.334    91.836     0.150
     6.687    95.211     0.150
     7.334   105.109     0.150
     7.418   106.164     0.150
     7.505   107.555     0.150
     7.902   112.914     0.150
     7.959   113.859     0.150
     8.080   115.383     0.150
     9.638   136.062     0.150
    11.278   159.305     0.150
    11.575   162.250     0.150
    13.112   187.469     0.150
    74.276   701.961     0.150
     0.531    12.305     0.150
     0.531    12.301     0.150
     1.064    36.242     0.150
     1.263    21.785     0.150
     1.263    37.305     0.150
     1.276    41.555     0.150
     1.495    48.203     0.150
     1.495    26.766     0.150
     1.495    48.207     0.150
     2.327    62.574     0.150
     2.327    36.133     0.150
     2.327    62.578     0.150
     2.241    38.391     0.150
     2.599    40.988     0.150
     2.999    46.605     0.150
     3.319    50.031     0.150
     3.813    58.066     0.150
     3.914    59.855     0.150
     4.040    59.504     0.150
     4.248    65.016     0.150
     4.331    65.379     0.150
     4.265    65.160     0.150
     4.454    67.328     0.150
     4.645    67.766     0.150
     4.753    70.977     0.150
     4.924    73.891     0.150
     5.203    78.402     0.150
     5.282    78.574     0.150
     5.606    83.602     0.150
     6.221    91.828     0.150
     0.541     8.219     0.150
     0.541    15.059     0.150
     0.541     8.309     0.150
     0.541    15.527     0.150
     1.047    17.898     0.150
     1.098    18.746     0.150
     1.143    19.887     0.150
     1.136    18.391     0.150
     1.145    18.316     0.150
     1.219    39.191     0.150
     1.604    25.188     0.150
     1.874    55.836     0.150
     1.874    30.449     0.150
     1.874    56.266     0.150
     2.009    33.445     0.150
     2.202    35.160     0.150
     3.181    89.336     0.150
     3.288    50.395     0.150
     3.342    51.918     0.150
     3.814    56.348     0.150
     7.298   105.547     0.150
     8.019   114.676     0.150
     8.384   118.547     0.150
     8.384   118.582     0.150
     8.712   125.664     0.150
     9.159   131.082     0.150
     9.472   133.895     0.150
     9.971   140.098     0.150
    10.301   144.828     0.150
    10.687   149.348     0.150
    10.772   152.676     0.150
    10.984   153.723     0.150
    11.329   150.598     0.150
    11.443   162.945     0.150
    11.632   155.625     0.150
    12.481   173.578     0.150
    14.402   200.824     0.150
    16.628   230.406     0.150
    16.990   236.945     0.150
    23.092   302.848     0.150
    25.320   324.746     0.150
    25.972   330.445     0.150
    32.422   385.867     0.150
    33.303   396.445     0.150
    33.990   400.559     0.150
    33.990   400.547     0.150
    34.913   410.199     0.150
    35.513   416.020     0.150
    35.987   419.047     0.150
    37.312   430.473     0.150
    39.166   445.047     0.150
    39.166   446.961     0.150
    39.395   449.523     0.150
    40.440   455.809     0.150
    40.440   455.848     0.150
    40.762   458.754     0.150
    43.880   486.047     0.150
    44.454   488.336     0.150
    45.336   497.074     0.150
    45.456   495.836     0.150
    45.456   495.848     0.150
    45.442   493.148     0.150
    46.395   503.547     0.150
    46.637   506.148     0.150
    47.219   509.648     0.150
    47.219   509.676     0.150
    48.332   518.340     0.150
    48.417   520.172     0.150
    49.059   524.621     0.150
    49.129   524.418     0.150
    49.468   527.133     0.150
    50.475   534.906     0.150
    50.475   535.938     0.150
    50.503   535.945     0.150
    50.503   535.859     0.150
    50.561   535.418     0.150
    50.667   535.098     0.150
    50.907   538.699     0.150
    50.912   539.094     0.150
    50.917   538.973     0.150
    50.970   538.680     0.150
    51.024   539.434     0.150
    51.528   542.781     0.150
    51.658   544.062     0.150
    51.668   544.773     0.150
    51.712   544.648     0.150
    51.762   545.000     0.150
    51.771   545.125     0.150
    51.838   546.059     0.150
    52.166   548.570     0.150
    52.177   548.180     0.150
    52.319   548.758     0.150
    52.497   550.672     0.150
    52.631   551.797     0.150
    52.726   551.641     0.150
    53.071   554.234     0.150
    53.120   555.820     0.150
    53.204   555.770     0.150
    53.271   555.969     0.150
    53.485   557.773     0.150
    53.557   558.789     0.150
    53.582   558.770     0.150
    53.631   557.887     0.150
    53.631   558.777     0.150
    53.823   560.180     0.150
    53.854   558.758     0.150
    53.889   560.027     0.150
    54.233   563.855     0.150
    54.380   564.680     0.150
    54.542   564.598     0.150
    54.657   567.363     0.150
    54.657   567.363     0.150
    54.836   567.547     0.150
    54.902   567.246     0.150
    54.902   567.246     0.150
    54.870   567.746     0.150
    55.559   573.184     0.150
    55.575   573.098     0.150
    55.885   575.480     0.150
    57.476   585.348     0.150
    62.862   622.648     0.150
    63.082   625.547     0.150
    63.832   630.348     0.150
    64.202  1152.047     0.150
    64.366     6.199     0.150
    64.366     9.199     0.150
    65.012   637.547     0.150
    65.012     5.801     0.150
    65.012     8.000     0.150
    65.012  1150.047     0.150
    65.819   642.746     0.150
    65.923   642.246     0.150
    65.923   642.246     0.150
    66.187   648.848     0.150
    67.453   653.148     0.150
    69.153   667.047     0.150
    69.300     4.000     0.150
    69.300     5.801     0.150
    69.300  1200.547     0.150
    69.980   671.945     0.150
    69.980   689.445     0.150
    69.980   672.035     0.150
    69.980   672.035     0.150
    69.980   672.035     0.150
    69.980   689.488     0.150
    69.980   802.785     0.150
    69.980   938.547     0.150
    69.980  1227.605     0.150
    69.980  1445.828     0.150
    69.980  1662.258     0.150
    71.050  5284.746     0.150
    73.063   683.945     0.150
    73.063   683.945     0.150
    73.063   701.047     0.150
    73.437  5456.148     0.150
    73.546   690.848     0.150
    73.546   704.246     0.150
    74.426   700.348     0.150
    75.266   714.047     0.150
    75.444   703.148     0.150
    75.458   700.746     0.150
    75.614   703.848     0.150
    75.977   710.848     0.150
    76.091   705.945     0.150
    76.174   707.848     0.150
    76.174   707.848     0.150
    76.347   708.348     0.150
    76.892   711.590     0.150
    76.934   711.820     0.150
    77.186   713.418     0.150
    77.235   714.539     0.150
    78.777   721.246     0.150
    79.164  5886.848     0.150
    82.192   741.246     0.150
    83.900   747.348     0.150
    88.804   774.547     0.150
   149.141  1186.746     0.150
     0.699    25.367     0.150
     1.071    19.797     0.150
     1.071    33.773     0.150
     1.796    28.998     0.150
     2.700    42.713     0.150
     3.572    52.840     0.150
     3.604    54.570     0.150
     3.812    57.578     0.150
     4.370    64.678     0.150
     4.544    67.320     0.150
     4.614    68.121     0.150
     4.803    71.289     0.150
     5.245    77.318     0.150
     5.287    77.336     0.150
     5.816    84.723     0.150
     6.190    88.199     0.150
     8.490   120.525     0.150
     8.847   124.734     0.150
     9.730   135.629     0.150
     9.725   135.082     0.150
    14.204   205.150     0.150
    16.986   235.551     0.150
    17.476   239.689     0.150
    63.781   627.787     0.150
    64.806   633.451     0.150
     0.570    22.043     0.150
     0.570    22.047     0.150
     1.194    37.227     0.150
     1.474    23.473     0.150
     1.474    43.113     0.150
     3.042    44.098     0.150
     3.072    47.113     0.150
     2.960    83.195     0.150
     3.999    59.012     0.150
     4.221    61.996     0.150
     4.306    62.887     0.150
     4.306    62.891     0.150
     4.780    69.355     0.150
     4.923    74.137     0.150
     5.019    73.461     0.150
     5.358    77.699     0.150
     5.656    82.234     0.150
     5.944    87.945     0.150
     6.938   103.688     0.150
     7.624   109.188     0.150
     8.050   115.047     0.150
     8.146   115.051     0.150
     8.496   123.086     0.150
     9.445   132.797     0.150
    10.019   139.906     0.150
     9.981   141.812     0.150
    11.435   163.035     0.150
    11.523   163.848     0.150
    11.555   162.867     0.150
    26.305   333.734     0.150
    43.708  3277.738     0.150
    43.714  3273.828     0.150
    43.726  3281.109     0.150
    44.869  3358.812     0.150
    44.883  3359.914     0.150
    44.887  3360.141     0.150
    46.353   509.586     0.150
    53.291   559.887     0.150
    66.770   652.188     0.150
    75.076   703.188     0.150
    75.076     7.199     0.150
     2.060    32.227     0.150
     2.060    32.555     0.150
     2.060    58.383     0.150
     3.352    49.297     0.150
     3.809    97.250     0.150
     3.809    55.180     0.150
     3.809    55.758     0.150
     4.891    71.055     0.150
     5.373    76.641     0.150
     5.373    76.812     0.150
     5.373    77.141     0.150
     5.531    79.523     0.150
     6.483    93.648     0.150
     6.483    92.992     0.150
     7.157   100.805     0.150
     9.013   127.539     0.150
     9.169   129.336     0.150
     9.516   132.969     0.150
     9.610   134.406     0.150
     9.704   136.031     0.150
    10.005   140.453     0.150
    10.269   144.164     0.150
    10.269   144.141     0.150
    10.552   147.234     0.150
    11.138   155.039     0.150
    12.510   303.266     0.150
    12.793   176.930     0.150
    13.451   187.414     0.150
    13.456   184.609     0.150
    13.882   194.523     0.150
    13.956   192.117     0.150
    14.312   196.672     0.150
    14.737   204.703     0.150
    15.543   218.797     0.150
    17.154   239.336     0.150
    18.286   253.406     0.150
    18.816   256.609     0.150
    24.274   566.438     0.150
    26.614   337.539     0.150
    27.605   346.086     0.150
    32.264   385.539     0.150
    32.321   553.602     0.150
    32.940   391.938     0.150
    34.184   732.734     0.150
    35.364   413.375     0.150
    35.364   413.336     0.150
    35.771   414.789     0.150
    36.131   413.641     0.150
    36.179   416.641     0.150
    36.179   501.336     0.150
    36.179   571.039     0.150
    36.506   424.094     0.150
    36.506   423.992     0.150
    36.787   425.734     0.150
    37.081   427.141     0.150
    37.694   433.547     0.150
    38.318   437.539     0.150
    40.524   456.961     0.150
    40.992   835.039     0.150
    40.977   460.141     0.150
    41.871   470.977     0.150
    42.640  3207.016     0.150
    42.646  3207.453     0.150
    42.658  3208.359     0.150
    42.740   475.672     0.150
    43.801  3301.078     0.150
    43.815  3300.992     0.150
    43.819  3312.969     0.150
    44.300   488.359     0.150
    44.450   489.266     0.150
    44.551   489.906     0.150
    45.262   493.000     0.150
    45.746   498.109     0.150
    47.394   512.336     0.150
    47.386   510.938     0.150
    47.785     6.703     0.150
    48.157   518.039     0.150
    48.984   523.383     0.150
    49.189   524.344     0.150
    49.353   524.367     0.150
    49.644   528.305     0.150
    49.646   527.938     0.150
    50.369   533.039     0.150
    50.467   533.812     0.150
    50.653   535.555     0.150
    50.653   535.539     0.150
    51.105   539.141     0.150
    51.422   541.734     0.150
    51.678   543.805     0.150
    51.678   542.820     0.150
    51.678   543.734     0.150
    51.933   546.281     0.150
    51.981   545.570     0.150
    52.188   547.492     0.150
    52.229   547.070     0.150
    52.229   547.891     0.150
    52.326   548.906     0.150
    52.380   549.523     0.150
    52.800     5.398     0.150
    52.800     8.102     0.150
    52.800  1001.734     0.150
    52.800  1011.836     0.150
    53.051   553.766     0.150
    53.090   554.039     0.150
    53.092   554.641     0.150
    53.254   555.820     0.150
    53.289   555.961     0.150
    53.666   558.586     0.150
    53.748   557.562     0.150
    54.007   561.375     0.150
    54.074   561.844     0.150
    54.082   560.398     0.150
    54.301   563.281     0.150
    54.386   563.570     0.150
    54.849   567.484     0.150
    54.884   567.516     0.150
    54.883   567.461     0.150
    55.006   568.539     0.150
    54.979   568.414     0.150
    55.070   567.586     0.150
    55.112   569.609     0.150
    55.144   568.438     0.150
    55.233   569.672     0.150
    55.420     4.297     0.150
    55.497   570.992     0.150
    55.663   572.680     0.150
    55.757   574.562     0.150
    56.104   575.484     0.150
    56.222   577.438     0.150
    56.748   581.195     0.150
    56.920   582.234     0.150
    57.323     4.500     0.150
    57.323  1063.539     0.150
    57.627   582.039     0.150
    58.140   579.836     0.150
    58.145   591.125     0.150
    59.654   599.648     0.150
    61.427     7.203     0.150
    61.427  1118.734     0.150
    61.451   614.109     0.150
    63.753     8.305     0.150
    63.753    13.000     0.150
    63.753   666.734     0.150
    64.246   628.539     0.150
    64.246   628.539     0.150
    64.427    11.000     0.150
    64.694   633.664     0.150
    64.832   635.828     0.150
    64.832   635.734     0.150
    64.911    10.195     0.150
    64.906   636.734     0.150
    65.024  4869.734     0.150
    65.083   637.539     0.150
    65.100   639.070     0.150
    65.225   638.797     0.150
    65.225   639.234     0.150
    65.308  1165.039     0.150
    65.748   643.047     0.150
    65.965   642.938     0.150
    65.915   643.211     0.150
    66.303   648.438     0.150
    66.495   645.938     0.150
    66.591     7.602     0.150
    66.591    10.602     0.150
    67.152   650.141     0.150
    67.353   653.469     0.150
    67.353   653.555     0.150
    68.379   659.148     0.150
    68.520   659.844     0.150
    69.010   663.289     0.150
    69.402     5.000     0.150
    69.646   663.234     0.150
    69.963  5241.336     0.150
    69.950   669.625     0.150
    70.409   672.031     0.150
    70.524   671.039     0.150
    70.567   672.641     0.150
    70.705   672.508     0.150
    70.705   672.438     0.150
    70.949   674.438     0.150
    71.020   674.547     0.150
    71.020   674.539     0.150
    70.979   679.086     0.150
    71.097   674.094     0.150
    71.097   674.039     0.150
    71.305   677.641     0.150
    71.453   677.164     0.150
    71.453   677.141     0.150
    71.399   676.734     0.150
    71.399   676.641     0.150
    71.476   678.016     0.150
    71.476   678.016     0.150
    71.476   939.320     0.150
    71.476  1711.359     0.150
    71.476   677.938     0.150
    71.476   697.438     0.150
    71.476   836.039     0.150
    71.476   939.234     0.150
    71.476  1236.734     0.150
    71.476  1512.039     0.150
    71.600   677.656     0.150
    71.600   677.641     0.150
    72.048  5398.734     0.150
    72.110   681.234     0.150
    72.110   681.234     0.150
    73.403   699.539     0.150
    73.493     3.203     0.150
    73.493   701.336     0.150
    73.574   692.219     0.150
    73.735   702.438     0.150
    73.783   690.977     0.150
    73.783   690.938     0.150
    73.883   691.141     0.150
    74.040     8.102     0.150
    74.040   704.734     0.150
    74.040  1265.234     0.150
    74.133   692.477     0.150
    74.711   697.539     0.150
    74.711   696.141     0.150
    74.847   691.039     0.150
    74.893   698.336     0.150
    74.903   699.227     0.150
    74.997   702.938     0.150
    74.997     3.297     0.150
    74.997  1283.336     0.150
    75.039   699.961     0.150
    75.053   699.961     0.150
    75.172   698.484     0.150
    75.188   699.539     0.150
    75.186   700.438     0.150
    75.288   699.344     0.150
    75.555   702.938     0.150
    75.621   703.039     0.150
    75.621   703.039     0.150
    75.757   703.938     0.150
    75.757   715.039     0.150
    75.786   703.938     0.150
    75.868   705.070     0.150
    75.961   702.398     0.150
    76.071   705.734     0.150
    76.093   705.641     0.150
    76.410     3.297     0.150
    76.410  1315.438     0.150
    76.384   707.141     0.150
    76.759   708.938     0.150
    76.911   710.734     0.150
    76.911   721.234     0.150
    77.065   707.875     0.150
    77.229   712.734     0.150
    77.271   712.234     0.150
    77.382   712.141     0.150
    77.531   715.938     0.150
    77.646   715.641     0.150
    77.684   714.539     0.150
    77.698   714.641     0.150
    77.784   715.438     0.150
    77.799   714.039     0.150
    77.958   716.836     0.150
    78.028   716.945     0.150
    78.196   718.258     0.150
    78.220   719.016     0.150
    78.369   716.836     0.150
    78.264   718.539     0.150
    78.436   719.539     0.150
    78.464   719.234     0.150
    78.469   718.539     0.150
    78.538   721.945     0.150
    78.562   719.812     0.150
    78.599   720.344     0.150
    78.675   720.906     0.150
    78.692   720.984     0.150
    78.863   721.828     0.150
    78.860   721.945     0.150
    78.950   722.750     0.150
    78.982   720.438     0.150
    79.041   721.438     0.150
    79.239   724.594     0.150
    79.516   722.797     0.150
    79.421   724.438     0.150
    79.419   724.836     0.150
    79.464   724.789     0.150
    79.570   725.562     0.150
    79.905   727.211     0.150
    80.083   728.156     0.150
    80.149   728.773     0.150
    80.149   728.734     0.150
    80.168   728.234     0.150
    80.313   728.836     0.150
    80.385   723.641     0.150
    80.385  1327.438     0.150
    80.385  1843.141     0.150
    80.487   727.438     0.150
    80.556   730.336     0.150
    80.560   727.031     0.150
    80.650   731.141     0.150
    80.758   731.141     0.150
    81.025   732.039     0.150
    81.182   731.016     0.150
    81.182   731.039     0.150
    81.173   731.406     0.150
    81.173   731.438     0.150
    81.140  1024.938     0.150
    81.140  1653.539     0.150
    81.459   734.938     0.150
    82.002   735.594     0.150
    82.002   735.641     0.150
    81.989   739.141     0.150
    82.490   741.836     0.150
    82.538   752.539     0.150
    82.867  1355.234     0.150
    83.639   744.891     0.150
    83.639   744.836     0.150
    83.832   749.039     0.150
    84.272   944.812     0.150
    84.850   753.836     0.150
    85.713   756.539     0.150
    88.607   772.141     0.150
    92.629   786.914     0.150
    93.658   805.164     0.150
    94.666   811.148     0.150
    98.050   824.594     0.150
    99.523   818.477     0.150
   110.602   880.695     0.150
   111.144   882.914     0.150
   111.151  1109.227     0.150
   111.598  8385.148     0.150
   111.609  8394.172     0.150
   111.614  8397.141     0.150
   120.077  1136.914     0.150
   121.043  1139.508     0.150
   121.479  1131.336     0.150
   121.970  1141.305     0.150
   123.295  1143.141     0.150
   124.454  1146.109     0.150
   143.968  1167.445     0.150
   155.811  1198.953     0.150
   155.811  1215.125     0.150
     1.012    30.180     0.150
     1.540    52.594     0.150
     1.540    30.477     0.150
     3.366    52.688     0.150
     3.337    55.422     0.150
     3.337    55.773     0.150
     4.798    71.867     0.150
     4.941    76.047     0.150
     5.160    76.820     0.150
     4.930    77.188     0.150
     5.801    85.320     0.150
     5.916    86.836     0.150
     5.975    91.250     0.150
     6.228    93.984     0.150
     6.311    93.719     0.150
     8.298   121.219     0.150
     8.952   130.273     0.150
     9.239   133.961     0.150
     9.807   143.680     0.150
    10.352   147.773     0.150
    10.473   151.180     0.150
    10.948   156.305     0.150
    11.205   160.078     0.150
    11.720   169.016     0.150
    11.801   168.398     0.150
    12.247   177.383     0.150
    12.288   171.586     0.150
    12.580   175.680     0.150
    15.209   219.117     0.150
    15.262   215.125     0.150
    18.920   258.930     0.150
    18.920   258.977     0.150
    20.505   282.680     0.150
    20.505   495.977     0.150
    23.757   312.977     0.150
    24.271   317.180     0.150
    26.356   336.578     0.150
    33.077   396.805     0.150
    33.077   397.273     0.150
    33.709   559.648     0.150
    34.846   412.078     0.150
    35.034   413.836     0.150
    35.034   413.875     0.150
    35.137   412.164     0.150
    38.168   439.242     0.150
    41.596   464.539     0.150
    42.390  3196.219     0.150
    42.396  3199.773     0.150
    42.408  3203.125     0.150
    42.919   475.500     0.150
    43.392   481.117     0.150
    43.556  3265.133     0.150
    43.570  3267.453     0.150
    43.574  3265.539     0.150
    46.740   509.773     0.150
    46.891   507.180     0.150
    46.954   507.398     0.150
    48.245   519.359     0.150
    48.245   520.578     0.150
    48.810   526.688     0.150
    50.140   535.578     0.150
    52.124   549.977     0.150
    52.359   551.875     0.150
    52.283     9.000     0.150
    54.163   565.578     0.150
    54.503   568.180     0.150
    56.049   577.375     0.150
    56.316   579.273     0.150
    57.501   588.180     0.150
    59.211   600.078     0.150
    62.453   619.375     0.150
    63.981   630.578     0.150
    63.918    12.797     0.150
    63.918    17.398     0.150
    64.369   635.117     0.150
    64.369   635.078     0.150
    64.396     8.898     0.150
    64.396    13.000     0.150
    64.767   637.477     0.150
    64.838   638.773     0.150
    64.956   638.680     0.150
    65.373  4910.977     0.150
    65.927   645.578     0.150
    66.077   647.680     0.150
    66.038   646.477     0.150
    66.112    15.102     0.150
    66.731   649.789     0.150
    66.731   649.773     0.150
    68.425   661.273     0.150
    68.923   664.117     0.150
    68.923   664.078     0.150
    69.151   665.680     0.150
    69.438   666.508     0.150
    69.655   667.469     0.150
    69.937   670.078     0.150
    69.937  1665.977     0.150
    70.086   673.070     0.150
    70.065   670.875     0.150
    70.110   671.867     0.150
    70.110   671.773     0.150
    70.263   670.930     0.150
    70.270   674.430     0.150
    70.247   673.375     0.150
    70.415   673.297     0.150
    70.300    11.500     0.150
    70.418   672.945     0.150
    70.418   672.875     0.150
    70.510   673.805     0.150
    70.510   673.773     0.150
    70.563   674.336     0.150
    70.563   674.273     0.150
    70.648   674.695     0.150
    70.648   674.680     0.150
    70.907   671.523     0.150
    71.001   676.898     0.150
    71.001   676.875     0.150
    70.947   677.383     0.150
    70.947   677.375     0.150
    71.147   676.297     0.150
    71.147   676.273     0.150
    71.256   679.039     0.150
    71.256   679.039     0.150
    71.256    20.055     0.150
    71.256   939.078     0.150
    71.256  1229.734     0.150
    71.256  1533.445     0.150
    71.256   678.977     0.150
    71.256   836.180     0.150
    71.256   939.078     0.150
    71.256  1229.680     0.150
    71.665   681.078     0.150
    71.665   681.078     0.150
    71.926   684.773     0.150
    71.999   684.773     0.150
    72.128   682.180     0.150
    72.316  5436.375     0.150
    72.882   689.875     0.150
    73.110   687.477     0.150
    73.347   690.789     0.150
    73.347   690.773     0.150
    73.454   690.273     0.150
    73.450   691.875     0.150
    73.450   691.680     0.150
    73.520   693.977     0.150
    74.458   697.500     0.150
    74.458   697.477     0.150
    74.460   698.016     0.150
    74.460   697.977     0.150
    74.570   697.500     0.150
    74.570   698.273     0.150
    74.538   702.273     0.150
    74.819   699.547     0.150
    75.009   700.516     0.150
    75.040   701.773     0.150
    75.405   704.078     0.150
    75.620   705.273     0.150
    75.627   705.273     0.150
    75.910   706.875     0.150
    75.944   706.680     0.150
    75.892    14.000     0.150
    75.892  1288.773     0.150
    75.944   708.273     0.150
    76.018   707.680     0.150
    76.163   708.078     0.150
    76.218   707.578     0.150
    76.165   707.586     0.150
    76.571   710.273     0.150
    77.036   713.773     0.150
    77.059   712.664     0.150
    77.059   712.875     0.150
    77.083   713.578     0.150
    77.292   714.180     0.150
    77.620   716.977     0.150
    77.795   718.375     0.150
    77.856   717.477     0.150
    78.084   718.078     0.150
    78.084   718.680     0.150
    78.258   719.586     0.150
    78.023  5864.680     0.150
    78.710   722.008     0.150
    79.103   725.602     0.150
    79.106   724.984     0.150
    78.951   722.875     0.150
    80.344   731.375     0.150
    80.710   732.977     0.150
    80.663   732.977     0.150
    80.845  1336.180     0.150
    80.845  1649.773     0.150
    80.845  1859.773     0.150
    80.951   735.375     0.150
    81.191   736.773     0.150
    81.227   736.375     0.150
    81.555   736.875     0.150
    81.905   738.695     0.150
    83.575   746.969     0.150
    84.697   753.844     0.150
    85.200   756.078     0.150
    86.792   764.695     0.150
    86.829   764.977     0.150
     0.641    12.992     0.150
     0.641    20.213     0.150
     1.724    31.973     0.150
     1.724    32.301     0.150
     3.162    53.333     0.150
     3.652    59.112     0.150
     3.652    59.302     0.150
     4.747    70.183     0.150
     4.747    70.495     0.150
     6.900   100.652     0.150
    12.155   165.852     0.150
    14.791   205.162     0.150
    15.474   212.803     0.150
    18.491   251.492     0.150
    42.814  3258.507     0.150
    42.820  3261.429     0.150
    42.832  3250.546     0.150
    43.981  3342.763     0.150
    43.994  3349.751     0.150
    43.998  3343.192     0.150
    65.852   640.963     0.150
    66.077   647.353     0.150
     0.595    12.457     0.150
     0.595    20.906     0.150
     1.335    37.879     0.150
     2.263    67.469     0.150
     4.067    60.707     0.150
     5.669    80.566     0.150
     8.892   126.281     0.150
     9.564   134.695     0.150
     9.743   137.914     0.150
     9.913   140.027     0.150
    10.725   149.355     0.150
    11.651   162.023     0.150
    43.493  3267.730     0.150
    43.499  3266.820     0.150
    43.511  3255.184     0.150
    44.659  3352.117     0.150
    44.673  3348.668     0.150
    44.677  3356.578     0.150
   111.739  8374.984     0.150
   111.751  8374.371     0.150
   111.756  8375.160     0.150
     0.757    14.637     0.150
     0.757    14.598     0.150
     1.633    28.438     0.150
     1.633    50.855     0.150
     2.087    34.824     0.150
     2.087    62.562     0.150
     2.255    66.018     0.150
     2.659    40.689     0.150
     3.144    48.754     0.150
     3.524    54.012     0.150
     3.706    55.469     0.150
     4.006    61.137     0.150
     4.006    61.033     0.150
     4.463    64.771     0.150
     4.465    66.824     0.150
     4.640    69.012     0.150
     4.879    72.125     0.150
     5.003    73.713     0.150
     5.305    78.094     0.150
     5.337    78.191     0.150
     5.341    79.064     0.150
     5.493    80.891     0.150
     5.748    84.258     0.150
     5.825    85.574     0.150
     6.019    88.350     0.150
     6.036    88.225     0.150
     6.041    88.621     0.150
     6.182    90.172     0.150
     6.362    94.467     0.150
     6.417    96.406     0.150
     6.364    93.262     0.150
     6.657    96.730     0.150
     6.845    99.514     0.150
     6.837    99.230     0.150
     7.041   101.762     0.150
     7.060   101.836     0.150
     7.138   103.254     0.150
     7.506   107.707     0.150
     7.675   110.805     0.150
     7.725   110.939     0.150
     7.793   111.494     0.150
     7.691   111.195     0.150
     7.774   112.029     0.150
     8.021   112.746     0.150
     8.086   115.986     0.150
     8.308   118.924     0.150
     8.399   119.549     0.150
     8.494   123.236     0.150
     8.627   123.633     0.150
     8.739   124.350     0.150
     8.942   127.340     0.150
     9.233   132.047     0.150
     9.571   136.049     0.150
    10.015   141.920     0.150
    10.477   149.836     0.150
    11.999   170.486     0.150
    43.076  3242.867     0.150
    43.082  3235.057     0.150
    43.094  3249.273     0.150
    44.240  3338.898     0.150
    44.254  3341.521     0.150
    44.258  3342.566     0.150
    66.106   645.277     0.150
     1.465    43.793     0.150
     1.845    30.916     0.150
     1.845    55.371     0.150
     3.149    48.277     0.150
     4.027    60.438     0.150
     3.932    60.488     0.150
     4.190    62.766     0.150
     4.395    66.127     0.150
     4.512    67.488     0.150
     4.553    67.438     0.150
     6.496    94.188     0.150
    10.892   155.088     0.150
    11.636   293.137     0.150
    35.919   417.967     0.150
    43.506  3254.793     0.150
    43.512  3261.918     0.150
    43.524  3264.098     0.150
    44.670  3348.930     0.150
    44.683  3350.734     0.150
    44.687  3347.797     0.150
     0.369    10.672     0.150
     5.091    74.324     0.150
     6.132    88.586     0.150
     6.334    91.406     0.150
     0.643    14.238     0.150
     0.643    14.199     0.150
     0.643    14.199     0.150
     0.643    23.371     0.150
     0.977    19.930     0.150
     0.990    20.250     0.150
     0.987    20.098     0.150
     0.990    20.387     0.150
     1.320    25.203     0.150
     3.595    57.137     0.150
     4.556    69.543     0.150
     4.574    70.004     0.150
     5.077    76.676     0.150
     5.265    79.793     0.150
     5.481    82.422     0.150
     5.860    87.508     0.150
     5.915    88.961     0.150
     6.107    90.359     0.150
     6.107    90.949     0.150
     6.388    94.797     0.150
     6.451    96.238     0.150
     6.748    99.379     0.150
     6.911   101.574     0.150
     7.007   102.297     0.150
     7.045   103.230     0.150
     7.126   102.148     0.150
     7.541   109.574     0.150
     7.559   110.383     0.150
     7.625   111.297     0.150
     7.799   113.598     0.150
     8.116   117.902     0.150
     8.214   119.496     0.150
     8.528   120.648     0.150
     8.602   124.648     0.150
     8.748   125.754     0.150
     9.000   129.938     0.150
     9.644   137.449     0.150
     9.644   137.445     0.150
    11.333   163.199     0.150
    18.523   253.074     0.150
    40.594   456.922     0.150
    42.770  3231.016     0.150
    42.776  3239.770     0.150
    42.788  3227.535     0.150
    44.957   492.305     0.150
    55.987   573.688     0.150
    64.074   630.324     0.150
    64.413   633.246     0.150
    65.813   642.473     0.150
    74.644   696.398     0.150
    83.868   748.086     0.150
     0.690    13.785     0.150
     0.690    23.039     0.150
     2.019    34.039     0.150
     2.019    61.893     0.150
     3.131    88.426     0.150
     3.131    88.428     0.150
     3.522    97.496     0.150
     3.522    97.498     0.150
     3.608    99.916     0.150
     3.950    60.467     0.150
     3.950    60.529     0.150
     4.177    63.469     0.150
     4.345    64.947     0.150
     4.437    66.621     0.150
     4.588    68.650     0.150
     4.974    74.350     0.150
     5.281    77.736     0.150
     5.327    78.963     0.150
     5.789    85.014     0.150
     5.982    88.104     0.150
     6.130    89.816     0.150
     6.754    98.676     0.150
     6.784    98.641     0.150
     6.814    99.141     0.150
     7.000   101.607     0.150
     7.011   100.758     0.150
     7.627   110.564     0.150
     7.632   110.664     0.150
     7.926   114.541     0.150
     8.254   118.965     0.150
     8.583   123.115     0.150
     8.911   126.762     0.150
     9.033   128.814     0.150
     9.569   137.467     0.150
    10.235   145.320     0.150
    10.309   146.869     0.150
     0.713    14.152     0.150
     1.220    21.922     0.150
     1.334    22.133     0.150
     1.442    42.945     0.150
     2.241    34.469     0.150
     3.048    46.793     0.150
     4.581    66.930     0.150
     4.867    71.188     0.150
     4.863    70.996     0.150
     5.282    77.078     0.150
     5.423    79.297     0.150
     5.769    84.297     0.150
     6.458    93.668     0.150
     6.529    93.824     0.150
     6.719    95.879     0.150
     7.838   111.059     0.150
     9.081   127.672     0.150
     9.538   134.727     0.150
     9.824   138.773     0.150
    10.482   147.227     0.150
    10.679   149.301     0.150
    10.982   153.445     0.150
    11.527   278.223     0.150
    12.300   170.852     0.150
    12.466   173.387     0.150
    12.926   180.590     0.150
    14.031   195.004     0.150
    14.071   193.828     0.150
    14.607   201.824     0.150
    14.755   207.602     0.150
    15.021   210.312     0.150
    15.189   210.852     0.150
    15.216   211.703     0.150
    25.961   330.383     0.150
    26.172   332.574     0.150
    26.710   333.398     0.150
    29.216   359.934     0.150
    29.299   356.098     0.150
    30.926   370.680     0.150
    31.052   372.066     0.150
    32.098   385.324     0.150
    33.999   400.953     0.150
    35.505   412.840     0.150
    35.890   415.711     0.150
    36.593   420.383     0.150
    37.550   429.348     0.150
    41.281   461.883     0.150
    43.543  3256.336     0.150
    43.549  3256.906     0.150
    43.561  3256.906     0.150
    44.708  3345.980     0.150
    44.722  3348.738     0.150
    44.726  3349.016     0.150
    48.549   517.367     0.150
    51.572   541.844     0.150
    53.055   550.539     0.150
    53.343   552.703     0.150
    53.427   553.129     0.150
    63.455   626.473     0.150
    63.989   632.672     0.150
    64.319    17.000     0.150
    64.700   631.023     0.150
    64.890     5.801     0.150
    66.301   646.375     0.150
    74.620   698.574     0.150
    79.359   722.375     0.150
    80.357   724.574     0.150
    80.423   725.773     0.150
    80.966   729.773     0.150
    81.531   734.875     0.150
    81.584   733.594     0.150
    81.577   734.344     0.150
    81.970   736.402     0.150
   111.621  8367.762     0.150
   111.633  8374.051     0.150
   111.638  8372.293     0.150
     0.885    16.803     0.150
     0.885    29.943     0.150
     1.567    26.516     0.150
     2.407    39.883     0.150
     3.364    52.984     0.150
     4.586    68.420     0.150
     4.761    78.588     0.150
     4.836    72.795     0.150
     5.509    80.969     0.150
     5.837    86.555     0.150
    10.211   147.525     0.150
    11.421   163.494     0.150
    11.742   285.045     0.150
    25.094   319.619     0.150
    42.356   469.025     0.150
    43.405  3253.137     0.150
    43.410  3258.621     0.150
    43.423  3264.740     0.150
    44.568  3336.918     0.150
    44.581  3338.051     0.150
    44.585  3339.121     0.150
    47.704   515.574     0.150
    48.265   515.895     0.150
    55.913   574.852     0.150
    64.948   634.445     0.150
    74.053   691.395     0.150
   111.462  8366.461     0.150
   111.473  8366.465     0.150
   111.479  8367.373     0.150
     0.409    10.375     0.150
     0.409    10.453     0.150
     0.862    29.977     0.150
     0.860    29.633     0.150
     0.892    17.977     0.150
     0.992    34.133     0.150
     3.679    56.773     0.150
     4.344    63.328     0.150
     5.239    77.469     0.150
     5.239    74.773     0.150
     5.480    78.281     0.150
     5.314    80.461     0.150
     5.625    82.227     0.150
     5.879    84.828     0.150
     5.904    86.836     0.150
     6.153    88.891     0.150
     6.256    90.250     0.150
     6.702    97.086     0.150
     6.810    97.750     0.150
     7.144   102.500     0.150
     8.302   118.289     0.150
     8.339   118.273     0.150
     8.339   118.070     0.150
     8.731   125.742     0.150
     8.765   122.008     0.150
     8.952   126.375     0.150
     8.974   126.414     0.150
     9.758   136.977     0.150
     9.959   140.875     0.150
    10.361   145.477     0.150
    11.210   156.766     0.150
    11.673   163.867     0.150
    11.695   163.055     0.150
    11.802   165.852     0.150
    11.964   165.875     0.150
    12.326   172.820     0.150
    13.265   186.242     0.150
    14.215   197.273     0.150
    14.409   201.719     0.150
    14.449   201.828     0.150
    14.498   203.805     0.150
    14.627   204.539     0.150
    14.945   210.172     0.150
    14.973   209.594     0.150
    15.825   220.211     0.150
    15.992   221.516     0.150
    16.574   228.602     0.150
    18.309   247.977     0.150
    20.049   267.586     0.150
    24.517   314.773     0.150
    24.367   313.672     0.150
    27.306   341.070     0.150
    27.389   340.516     0.150
    27.389   341.773     0.150
    31.709   378.273     0.150
    32.900   390.016     0.150
    32.900   389.977     0.150
    32.915   389.164     0.150
    33.648   395.766     0.150
    33.648   395.773     0.150
    34.602   404.180     0.150
    34.602   404.172     0.150
    34.654   404.609     0.150
    34.654   405.172     0.150
    34.863   406.539     0.150
    34.919   407.281     0.150
    35.175   408.977     0.150
    35.502   410.172     0.150
    35.502   421.570     0.150
    35.793   415.055     0.150
    35.793   415.070     0.150
    36.149   418.875     0.150
    36.693   423.672     0.150
    36.811   422.859     0.150
    37.229   426.977     0.150
    37.559   428.359     0.150
    37.760   431.391     0.150
    38.149   435.203     0.150
    38.282   435.977     0.150
    38.472   437.875     0.150
    43.111   473.836     0.150
    44.090   482.195     0.150
    46.492   502.273     0.150
    46.642   503.672     0.150
    47.517   508.680     0.150
    47.567   508.164     0.150
    47.644   512.977     0.150
    48.188   515.031     0.150
    49.007   521.773     0.150
    49.470   524.547     0.150
    50.264   531.672     0.150
    51.400   539.273     0.150
    51.784   542.570     0.150
    52.258    13.602     0.150
    52.258    18.102     0.150
    52.258   664.070     0.150
    53.073   551.305     0.150
    53.903   556.734     0.150
    54.013   557.406     0.150
    54.377   561.977     0.150
    54.677   561.445     0.150
    55.165   565.812     0.150
    55.491   568.172     0.150
    55.755   570.672     0.150
    56.157   572.492     0.150
    59.274    12.000     0.150
    59.274    17.000     0.150
    63.464   622.172     0.150
    63.464    18.898     0.150
    63.434   624.555     0.150
    63.434   624.477     0.150
    63.820    14.000     0.150
    64.178   628.773     0.150
    64.115   628.977     0.150
    64.352    14.602     0.150
    64.352    24.898     0.150
    64.469   629.352     0.150
    65.485   634.977     0.150
    65.662   639.570     0.150
    65.771   639.070     0.150
    65.811  4900.672     0.150
    65.900    16.500     0.150
    66.392   643.672     0.150
    68.539   656.672     0.150
    68.645   658.070     0.150
    68.785     4.500     0.150
    68.785     7.203     0.150
    69.803   664.773     0.150
    69.842   665.977     0.150
    70.137   666.977     0.150
    70.295   668.477     0.150
    70.363   668.773     0.150
    70.484  5259.172     0.150
    70.708   669.461     0.150
    70.708   669.461     0.150
    70.708   930.383     0.150
    70.708  1696.266     0.150
    70.708   669.477     0.150
    70.708    14.195     0.150
    70.708   689.273     0.150
    70.708   827.070     0.150
    70.708   930.375     0.150
    70.708  1220.875     0.150
    70.708  1245.273     0.150
    70.708  1494.172     0.150
    70.724   670.875     0.150
    70.669   671.070     0.150
    70.749  5292.477     0.150
    71.371   675.273     0.150
    71.621   672.875     0.150
    71.927   678.672     0.150
    72.616   679.070     0.150
    72.949   681.773     0.150
    72.831  5438.070     0.150
    73.035   684.477     0.150
    73.132   684.773     0.150
    73.132   684.773     0.150
    73.063  5468.977     0.150
    73.294  5486.273     0.150
    73.824   689.273     0.150
    73.983   689.977     0.150
    73.983   689.898     0.150
    74.273   695.773     0.150
    74.405   693.461     0.150
    74.416   691.672     0.150
    74.416   691.750     0.150
    74.416   692.477     0.150
    74.423   691.875     0.150
    74.454   699.781     0.150
    74.454   692.875     0.150
    74.454   712.477     0.150
    74.802   694.477     0.150
    74.802   694.477     0.150
    74.821   695.273     0.150
    74.838   695.977     0.150
    74.882   694.273     0.150
    74.882   694.273     0.150
    75.031   697.273     0.150
    75.046   696.375     0.150
    75.211   696.875     0.150
    75.360   697.977     0.150
    75.587   698.875     0.150
    75.587   698.875     0.150
    75.641   699.875     0.150
    75.716   700.070     0.150
    75.847   702.375     0.150
    76.095   702.070     0.150
    76.281   704.773     0.150
    76.383   703.680     0.150
    76.472   704.195     0.150
    76.472   704.672     0.150
    76.472   705.570     0.150
    76.520   705.172     0.150
    76.517   705.875     0.150
    76.692   705.672     0.150
    76.937   707.477     0.150
    76.946   708.570     0.150
    77.027   706.477     0.150
    77.042   708.570     0.150
    77.216   710.273     0.150
    77.514   711.070     0.150
    77.549   710.477     0.150
    77.697   712.820     0.150
    78.512   716.250     0.150
    78.542  5885.070     0.150
    78.885   717.570     0.150
    79.166   718.977     0.150
    79.788   723.773     0.150
    79.801   723.172     0.150
    79.815   723.273     0.150
    79.886   723.773     0.150
    79.987   723.672     0.150
    80.002   724.273     0.150
    80.455   727.070     0.150
    80.698   727.773     0.150
    81.056   731.672     0.150
    81.265   729.977     0.150
    81.374   733.273     0.150
    81.618   734.477     0.150
    81.755   734.070     0.150
    83.692   743.977     0.150
    83.719   743.156     0.150
    83.954   746.570     0.150
    84.147   745.836     0.150
    84.931   750.320     0.150
    87.385   762.570     0.150
   110.521  1778.273     0.150
   112.159  8397.617     0.150
   112.170  8398.977     0.150
   112.175  8385.359     0.150
     1.213    40.516     0.150
     1.742    28.516     0.150
     2.037    36.055     0.150
     2.083    65.227     0.150
     3.733    55.445     0.150
     5.532    79.656     0.150
     6.533    97.062     0.150
     8.212   117.008     0.150
    11.132   156.367     0.150
    11.898   162.719     0.150
    25.314   322.227     0.150
    78.844   719.719     0.150
     0.795    12.810     0.150
     0.795    22.750     0.150
     0.795    12.930     0.150
     0.751    14.995     0.150
     0.751    14.880     0.150
     0.824    15.095     0.150
     0.834    14.850     0.150
     0.851    28.840     0.150
     0.851    16.670     0.150
     0.851    16.661     0.150
     1.578    49.960     0.150
     1.688    29.640     0.150
     2.141    60.470     0.150
     2.141    34.271     0.150
     3.025    47.410     0.150
     3.356    51.021     0.150
     3.468    52.450     0.150
     3.592    53.470     0.150
     3.619    54.770     0.150
     3.878    58.345     0.150
     3.862    58.331     0.150
     4.322    64.295     0.150
     4.624    68.942     0.150
     4.664    70.187     0.150
     4.874    71.529     0.150
     5.046    73.870     0.150
     5.447    80.220     0.150
     5.966    88.287     0.150
     6.098    88.112     0.150
     6.141    89.069     0.150
     6.128    89.779     0.150
     6.236    90.367     0.150
     6.422    94.813     0.150
     6.574    95.120     0.150
     6.798    99.489     0.150
     6.844    99.421     0.150
     7.016   102.555     0.150
     7.313   105.530     0.150
     7.830   111.862     0.150
     7.931   112.870     0.150
     8.043   114.378     0.150
     8.121   117.816     0.150
     8.187   116.920     0.150
     8.355   118.214     0.150
     8.363   120.170     0.150
     8.615   121.885     0.150
     8.607   123.249     0.150
     8.602   122.548     0.150
     8.726   123.568     0.150
     8.726   123.670     0.150
     8.939   127.746     0.150
     8.954   127.770     0.150
     8.978   128.499     0.150
     9.042   129.088     0.150
     9.213   131.430     0.150
     9.382   132.170     0.150
     9.535   135.870     0.150
     9.620   135.970     0.150
     9.749   138.921     0.150
     9.974   142.185     0.150
    10.824   151.569     0.150
    10.993   152.870     0.150
    11.082   158.569     0.150
    11.082   158.640     0.150
    11.575   164.801     0.150
    12.297   173.112     0.150
    12.752   177.060     0.150
    12.762   180.548     0.150
    13.354   186.980     0.150
    14.292   200.952     0.150
    15.621   214.560     0.150
    17.000   235.616     0.150
    17.312   431.645     0.150
    20.163   273.489     0.150
    21.695   286.345     0.150
    22.261   291.489     0.150
    22.734   295.890     0.150
    23.174   300.710     0.150
    23.772   306.700     0.150
    24.537   320.470     0.150
    25.033   320.770     0.150
    25.717   325.479     0.150
    26.335   331.359     0.150
    26.335   331.370     0.150
    26.527   334.663     0.150
    26.666   335.489     0.150
    27.135   337.910     0.150
    30.746   370.569     0.150
    31.138   375.050     0.150
    31.138   375.069     0.150
    31.831   382.270     0.150
    31.831   382.340     0.150
    32.164   383.260     0.150
    32.164   383.270     0.150
    32.579   386.630     0.150
    33.641   401.078     0.150
    33.663   401.109     0.150
    33.877   403.262     0.150
    33.899   403.140     0.150
    34.007   403.966     0.150
    34.244   407.526     0.150
    34.282   407.058     0.150
    34.323   405.470     0.150
    35.520   417.390     0.150
    35.714   751.970     0.150
    35.714   894.270     0.150
    35.848   418.619     0.150
    36.333   418.600     0.150
    36.333   418.569     0.150
    36.594   426.056     0.150
    36.641   421.479     0.150
    36.766   427.910     0.150
    36.851   429.702     0.150
    36.937   429.710     0.150
    37.150   430.935     0.150
    37.280   429.239     0.150
    38.003   438.355     0.150
    38.239   439.770     0.150
    40.717   455.870     0.150
    40.717   455.870     0.150
    40.717   460.960     0.150
    40.959   458.550     0.150
    41.171   458.850     0.150
    41.171   458.870     0.150
    41.571   463.720     0.150
    42.738   480.770     0.150
    44.003  3266.645     0.150
    44.009  3264.644     0.150
    44.021  3265.558     0.150
    44.817   489.970     0.150
    45.171  3362.923     0.150
    45.185  3360.598     0.150
    45.189  3378.828     0.150
    45.664   495.870     0.150
    45.664   495.870     0.150
    45.736   497.470     0.150
    45.783   499.779     0.150
    46.398   504.370     0.150
    46.647   504.149     0.150
    46.647   504.170     0.150
    46.647   504.670     0.150
    46.936   508.069     0.150
    47.433   509.330     0.150
    47.571   511.020     0.150
    47.571   511.069     0.150
    47.707   511.000     0.150
    48.080   514.220     0.150
    48.232   516.470     0.150
    48.232   516.470     0.150
    48.269   516.779     0.150
    48.610   518.270     0.150
    48.696   519.720     0.150
    48.757   520.870     0.150
    48.757   520.870     0.150
    48.792   520.189     0.150
    49.423   525.069     0.150
    49.830   527.760     0.150
    50.170   530.479     0.150
    50.264   532.609     0.150
    50.645   537.080     0.150
    50.857   535.359     0.150
    50.857   535.370     0.150
    50.925   536.310     0.150
    50.939   536.750     0.150
    50.921   537.779     0.150
    50.954   538.270     0.150
    51.269   538.810     0.150
    51.282   538.960     0.150
    51.467   540.500     0.150
    51.724   542.330     0.150
    51.918   543.149     0.150
    52.024   543.989     0.150
    52.039   544.670     0.150
    52.133   544.640     0.150
    52.135   545.689     0.150
    52.209   545.550     0.150
    52.515   547.710     0.150
    52.407   548.930     0.150
    52.539   548.069     0.150
    52.735     6.000     0.150
    52.870   550.109     0.150
    52.947   551.020     0.150
    53.002   552.399     0.150
    53.096   552.460     0.150
    53.151   553.870     0.150
    53.200   552.200     0.150
    53.255   554.439     0.150
    53.306   554.140     0.150
    53.583   558.113     0.150
    53.644   556.580     0.150
    53.854   558.060     0.150
    53.920   558.090     0.150
    53.991   559.050     0.150
    54.007   558.970     0.150
    54.353   561.890     0.150
    54.606   563.430     0.150
    54.636   562.950     0.150
    54.742   564.710     0.150
    55.873   572.770     0.150
    55.926   573.319     0.150
    55.982   573.540     0.150
    56.806   589.670     0.150
    58.166  1074.370     0.150
    58.922   594.680     0.150
    59.933     6.899     0.150
    59.933    10.399     0.150
    61.502     8.000     0.150
    62.061   617.689     0.150
    62.335   618.250     0.150
    63.458   626.270     0.150
    63.437   627.080     0.150
    63.437   627.069     0.150
    63.559   635.569     0.150
    63.771     7.199     0.150
    63.771    10.600     0.150
    63.904   631.170     0.150
    64.178     8.800     0.150
    64.204   632.670     0.150
    64.751   635.270     0.150
    64.796     7.900     0.150
    64.796    11.500     0.150
    65.728   641.745     0.150
    65.834   641.470     0.150
    66.204   645.270     0.150
    66.316   645.470     0.150
    68.685   660.670     0.150
    68.685   660.670     0.150
    68.920     7.500     0.150
    69.120     7.000     0.150
    69.875   667.470     0.150
    70.049   669.029     0.150
    70.049   668.970     0.150
    70.126   924.470     0.150
    70.192   670.270     0.150
    70.390   671.370     0.150
    70.560   670.819     0.150
    70.766   674.069     0.150
    70.929  1496.270     0.150
    71.461   665.910     0.150
    71.727   679.029     0.150
    71.727   679.069     0.150
    72.037   682.170     0.150
    72.142   680.239     0.150
    72.142   683.080     0.150
    72.184   683.370     0.150
    72.490   689.870     0.150
    72.721   689.870     0.150
    73.094   685.960     0.150
    73.094   685.970     0.150
    73.094   685.960     0.150
    73.094   687.270     0.150
    73.264   693.069     0.150
    73.264     0.000     0.150
    73.382   690.670     0.150
    73.744   692.170     0.150
    73.744   711.170     0.150
    73.853   692.069     0.150
    73.861   691.270     0.150
    74.107   693.870     0.150
    74.357   696.370     0.150
    74.337   699.270     0.150
    74.646   697.770     0.150
    75.138   698.060     0.150
    75.138   698.069     0.150
    75.362   699.970     0.150
    75.362   699.970     0.150
    75.466   699.950     0.150
    75.622   704.069     0.150
    75.757   701.120     0.150
    75.841   705.500     0.150
    75.884   702.170     0.150
    75.884   703.779     0.150
    76.204   704.800     0.150
    76.204   704.770     0.150
    76.271   706.770     0.150
    76.361   707.370     0.150
    76.381     8.199     0.150
    76.459   706.670     0.150
    76.539   706.689     0.150
    76.642   709.609     0.150
    76.937   709.698     0.150
    77.075   709.660     0.150
    77.104   708.856     0.150
    77.104   708.870     0.150
    77.121   712.663     0.150
    77.142   710.762     0.150
    77.233   713.203     0.150
    77.398   714.119     0.150
    77.502   713.026     0.150
    77.763   713.149     0.150
    77.786   716.887     0.150
    77.979   715.109     0.150
    77.979   715.069     0.150
    78.148   714.590     0.150
    78.548   717.646     0.150
    78.636   723.729     0.150
    78.745   725.927     0.150
    78.798   720.170     0.150
    78.816   723.898     0.150
    78.816   723.870     0.150
    79.005   720.069     0.150
    79.005   720.069     0.150
    79.131   721.069     0.150
    79.285   729.646     0.150
    79.285   729.670     0.150
    79.267   719.770     0.150
    79.366   727.278     0.150
    79.366   725.800     0.150
    79.893   731.674     0.150
    79.987   730.939     0.150
    79.998   714.404     0.150
    80.535   728.720     0.150
    80.535   728.770     0.150
    80.547   728.819     0.150
    80.606   729.720     0.150
    81.280   731.450     0.150
    81.280   731.470     0.150
    81.258   731.160     0.150
    81.258   731.170     0.150
    81.518   737.290     0.150
    81.552   734.290     0.150
    81.595   734.645     0.150
    82.147   742.660     0.150
    82.477   741.470     0.150
    82.528   747.510     0.150
    82.754   739.840     0.150
    83.044   741.540     0.150
    83.262   740.870     0.150
    83.555   751.870     0.150
    83.595   751.510     0.150
    83.555   743.670     0.150
    83.682   744.420     0.150
    84.438   746.880     0.150
    84.958   757.270     0.150
    85.069   751.560     0.150
    85.201   756.420     0.150
    87.431   770.670     0.150
    89.140   771.470     0.150
    89.140   771.470     0.150
    96.737   805.649     0.150
     3.513    49.152     0.150
     7.565   108.152     0.150
    11.625   166.004     0.150
    12.051   170.824     0.150
    43.038  3230.777     0.150
    43.044  3230.355     0.150
    43.056  3235.258     0.150
    44.201  3319.152     0.150
    44.215  3321.449     0.150
    44.219  3320.879     0.150
     0.645    13.039     0.150
     0.645    21.771     0.150
     1.205    21.988     0.150
     1.205    21.750     0.150
     1.515    46.617     0.150
     1.770    51.609     0.150
     1.993    33.766     0.150
     3.106    48.215     0.150
     4.405    66.156     0.150
     4.416    65.582     0.150
     4.546    67.770     0.150
     4.836    72.002     0.150
     4.940    73.004     0.150
     5.246    77.355     0.150
     5.410    79.648     0.150
     5.753    84.416     0.150
     5.960    87.021     0.150
     5.950    86.516     0.150
     5.939    86.941     0.150
     6.290    91.762     0.150
     6.313    92.619     0.150
     6.544    95.490     0.150
     6.741    97.510     0.150
     6.781    98.455     0.150
     6.962    99.461     0.150
     7.084   102.326     0.150
     7.435   106.447     0.150
     7.586   109.766     0.150
     7.663   110.150     0.150
     7.727   112.176     0.150
     7.897   113.965     0.150
     8.014   114.906     0.150
     8.211   117.910     0.150
     8.543   121.715     0.150
     9.560   136.939     0.150
    30.188   364.988     0.150
    43.063  3250.518     0.150
    43.069  3250.936     0.150
    43.081  3251.848     0.150
    44.228  3341.359     0.150
    44.242  3340.637     0.150
    44.246  3340.268     0.150
    74.615   694.529     0.150
     0.911    17.203     0.150
     1.491    46.492     0.150
     1.783    30.441     0.150
     2.191    35.652     0.150
     2.642    39.816     0.150
     3.703    54.453     0.150
     4.075    61.516     0.150
     4.445    65.973     0.150
     4.624    68.648     0.150
     4.780    71.047     0.150
     5.106    73.434     0.150
     5.406    78.547     0.150
     5.482    80.270     0.150
     5.829    84.520     0.150
     5.945    86.414     0.150
     6.125    89.203     0.150
     6.170    88.777     0.150
     6.716    96.898     0.150
     7.105   100.453     0.150
     7.197   102.680     0.150
     8.583   121.734     0.150
     8.758   126.020     0.150
     8.979   123.641     0.150
    12.072   164.691     0.150
    43.060  3244.039     0.150
    43.066  3245.043     0.150
    43.078  3247.812     0.150
    44.223  3333.145     0.150
    44.236  3336.137     0.150
    44.240  3334.688     0.150
    65.037   637.516     0.150
    65.527   640.562     0.150
    74.840   697.125     0.150
   111.563  8369.715     0.150
   111.574  8371.266     0.150
   111.579  8374.863     0.150
     0.991    19.132     0.150
     0.991    32.044     0.150
     1.488    27.842     0.150
     1.488    47.180     0.150
     1.557    29.722     0.150
     1.557    29.720     0.150
     1.557    50.632     0.150
     2.375    40.243     0.150
     3.339    52.255     0.150
     3.362    54.262     0.150
     3.362    54.260     0.150
     4.382    66.741     0.150
     4.382    66.737     0.150
     4.808    72.968     0.150
     4.837    73.711     0.150
     5.132    76.302     0.150
     5.132    76.305     0.150
     5.399    81.308     0.150
     5.436    81.647     0.150
     5.570    83.967     0.150
     5.778    86.579     0.150
     5.813    86.931     0.150
     6.208    93.342     0.150
     6.191    92.175     0.150
     6.286    94.377     0.150
     6.327    94.241     0.150
     6.468    96.036     0.150
     6.854   100.885     0.150
     7.042   103.816     0.150
     7.267   106.550     0.150
     7.296   107.773     0.150
     7.320   107.664     0.150
     7.382   108.517     0.150
     7.610   111.482     0.150
     7.887   114.633     0.150
     7.939   115.241     0.150
     7.939   115.239     0.150
     8.156   118.532     0.150
     8.275   120.659     0.150
     8.430   122.437     0.150
     8.504   122.955     0.150
     8.926   129.316     0.150
     9.211   132.788     0.150
     9.642   136.481     0.150
    10.648   150.371     0.150
    12.555   306.191     0.150
    42.418  3203.795     0.150
    42.424  3204.451     0.150
    42.436  3199.085     0.150
    43.584  3261.865     0.150
    43.597  3292.539     0.150
    43.601  3261.525     0.150
    47.778   605.877     0.150
    54.513   566.132     0.150
    77.041   714.053     0.150
    85.436   758.520     0.150
     1.132    21.557     0.150
     1.143    21.537     0.150
     1.149    21.496     0.150
     1.179    21.996     0.150
     1.259    23.537     0.150
     1.512    45.848     0.150
     1.512    27.496     0.150
     1.563    29.447     0.150
     1.563    28.875     0.150
     1.696    54.857     0.150
     1.758    32.646     0.150
     2.040    35.236     0.150
     2.073    35.191     0.150
     2.074    35.467     0.150
     2.107    35.777     0.150
     2.401    39.363     0.150
     2.951    47.688     0.150
     4.400    66.324     0.150
     4.415    69.377     0.150
     4.947    74.551     0.150
     5.085    74.527     0.150
     4.946    75.975     0.150
     5.389    78.826     0.150
     5.771    84.217     0.150
     5.771   172.592     0.150
     5.771    84.156     0.150
     5.842    86.973     0.150
     5.918    88.197     0.150
     6.218    92.646     0.150
     7.349   106.697     0.150
     7.855   114.543     0.150
     8.270   112.277     0.150
     8.274   122.719     0.150
     8.303   121.150     0.150
     8.925   129.301     0.150
     8.960   129.646     0.150
     9.427   134.848     0.150
     9.825   141.246     0.150
    10.987   156.326     0.150
    11.097   158.230     0.150
    12.581   305.359     0.150
    12.702   178.051     0.150
    14.619   205.646     0.150
    15.045   211.461     0.150
    15.798   219.371     0.150
    16.009   221.893     0.150
    16.419   228.158     0.150
    18.567   256.664     0.150
    18.920   463.422     0.150
    18.920   257.416     0.150
    20.527   289.246     0.150
    20.527   298.348     0.150
    20.527   499.047     0.150
    20.527   534.246     0.150
    21.023   283.537     0.150
    22.431   296.160     0.150
    23.779   554.047     0.150
    27.655   345.871     0.150
    27.655   349.047     0.150
    30.014   371.047     0.150
    31.332   381.637     0.150
    31.799   386.447     0.150
    32.047   383.154     0.150
    32.258   386.119     0.150
    32.813   395.646     0.150
    32.813   559.430     0.150
    33.169   397.547     0.150
    32.954   398.246     0.150
    33.294   396.848     0.150
    34.050   402.512     0.150
    34.216   408.117     0.150
    34.658   411.336     0.150
    34.654   408.453     0.150
    34.825   412.848     0.150
    34.825   412.916     0.150
    34.997   409.561     0.150
    35.118   411.945     0.150
    34.996   415.836     0.150
    35.685   417.447     0.150
    35.717   765.447     0.150
    36.340   423.508     0.150
    36.871   430.146     0.150
    36.871   430.146     0.150
    36.877   427.688     0.150
    36.961   427.115     0.150
    37.522   435.457     0.150
    37.489   432.877     0.150
    37.525   435.326     0.150
    37.926   435.373     0.150
    38.146   438.232     0.150
    39.765   452.367     0.150
    40.112   454.783     0.150
    40.503   819.146     0.150
    40.646   458.537     0.150
    41.469   468.848     0.150
    41.469   468.938     0.150
    41.902   466.188     0.150
    42.086   473.336     0.150
    42.306     3.100     0.150
    42.374   473.896     0.150
    42.432   472.807     0.150
    42.396  3206.414     0.150
    42.402  3206.863     0.150
    42.414  3206.842     0.150
    42.929   475.768     0.150
    43.562  3294.047     0.150
    43.576  3292.912     0.150
    43.580  3293.658     0.150
    44.606   487.938     0.150
    44.466     4.699     0.150
    44.785   493.396     0.150
    46.151   503.811     0.150
    46.721   508.746     0.150
    46.903   507.848     0.150
    46.963   508.736     0.150
    47.266   512.438     0.150
    47.288   509.947     0.150
    47.288   623.848     0.150
    47.941   515.484     0.150
    48.246   520.047     0.150
    48.290   531.947     0.150
    48.928   521.848     0.150
    48.808   525.367     0.150
    48.808   525.348     0.150
    49.328   527.947     0.150
    52.022   547.947     0.150
    52.022   548.047     0.150
    52.107   548.947     0.150
    52.306     4.600     0.150
    53.344   557.523     0.150
    54.045   562.947     0.150
    54.135   562.113     0.150
    54.796   570.607     0.150
    54.796   568.129     0.150
    54.924   871.646     0.150
    55.544   574.566     0.150
    55.544   574.547     0.150
    56.398   578.434     0.150
    56.563   579.357     0.150
    56.555   584.348     0.150
    56.829     4.100     0.150
    56.829    11.600     0.150
    57.925  1073.047     0.150
    57.925  1171.047     0.150
    57.925  1438.047     0.150
    57.820     4.301     0.150
    57.820     7.600     0.150
    57.820  1069.047     0.150
    59.193   601.848     0.150
    61.116   610.848     0.150
    62.875     8.199     0.150
    64.366   632.508     0.150
    64.413   633.646     0.150
    64.392   634.947     0.150
    64.419    10.201     0.150
    64.778   636.646     0.150
    64.975   674.848     0.150
    65.949   644.246     0.150
    66.060   644.047     0.150
    68.448     2.900     0.150
    68.448     4.500     0.150
    68.946   663.848     0.150
    69.223  1213.246     0.150
    69.249   665.258     0.150
    69.450   667.518     0.150
    69.953   678.047     0.150
    69.953   686.047     0.150
    69.953  1206.047     0.150
    69.953  1255.246     0.150
    69.953  1665.146     0.150
    70.087   669.947     0.150
    70.133   671.646     0.150
    70.133  1222.646     0.150
    70.284   673.428     0.150
    70.269   672.146     0.150
    70.532   673.646     0.150
    70.585   674.246     0.150
    70.694   674.438     0.150
    71.023   676.848     0.150
    70.969   677.146     0.150
    71.169   677.947     0.150
    71.270   937.746     0.150
    71.687   680.947     0.150
    71.945   682.348     0.150
    72.253   685.557     0.150
    72.305  1251.646     0.150
    72.305  1530.947     0.150
    73.772   694.348     0.150
    74.169   695.367     0.150
    74.482   697.646     0.150
    74.582   697.369     0.150
    74.561   701.547     0.150
    74.561     3.600     0.150
    74.953   698.938     0.150
    74.972   699.047     0.150
    74.980   699.316     0.150
    75.051   709.367     0.150
    75.051   700.447     0.150
    75.051   709.348     0.150
    75.051   700.369     0.150
    75.145   699.746     0.150
    75.638   704.447     0.150
    75.794   703.848     0.150
    75.922   705.746     0.150
    75.922   714.547     0.150
    75.956   705.947     0.150
    76.038   705.848     0.150
    75.915     4.000     0.150
    75.915     5.100     0.150
    75.915  1290.146     0.150
    76.175   707.047     0.150
    76.230   706.947     0.150
    76.780  1292.547     0.150
    76.780   711.047     0.150
    76.780  1292.547     0.150
    76.866   712.047     0.150
    77.049   712.447     0.150
    77.096   712.447     0.150
    77.117   712.447     0.150
    77.281   713.348     0.150
    77.281   713.252     0.150
    77.528   715.246     0.150
    77.632   716.047     0.150
    77.807   717.246     0.150
    78.097   718.848     0.150
    78.202   719.746     0.150
    78.277   718.547     0.150
    78.686   720.047     0.150
    78.686   729.047     0.150
    78.766  3131.047     0.150
    78.766   720.047     0.150
    78.766   729.047     0.150
    78.766   895.047     0.150
    78.816   720.840     0.150
    78.839   721.746     0.150
    79.203   723.746     0.150
    79.898   751.146     0.150
    79.994  1324.848     0.150
    80.066   724.348     0.150
    80.066   916.348     0.150
    80.066  1017.246     0.150
    80.066  1325.848     0.150
    80.066  1639.146     0.150
    80.066  1844.348     0.150
    80.859   733.840     0.150
    80.974   734.047     0.150
    81.181   735.186     0.150
    81.517   736.447     0.150
    82.108   740.348     0.150
    82.991   750.768     0.150
    83.843  1375.646     0.150
    84.872  1379.047     0.150
    85.199  1380.217     0.150
    85.199   755.547     0.150
    85.199  1380.246     0.150
    85.463   757.348     0.150
    85.619  1382.967     0.150
    85.619   757.848     0.150
    85.619  1382.947     0.150
    86.836   764.447     0.150
    90.278   776.010     0.150
    92.228   789.727     0.150
    92.314   788.746     0.150
    95.286   799.303     0.150
    95.667   804.746     0.150
   112.090  8419.344     0.150
   112.102  8417.289     0.150
   112.107  8419.766     0.150
   159.663  1227.428     0.150
   160.203  1198.689     0.150
   162.249  1209.047     0.150
     1.121    22.762     0.150
     1.131    22.822     0.150
     1.131    38.182     0.150
     1.135    22.732     0.150
     1.164    23.322     0.150
     1.247    25.281     0.150
     1.912    33.102     0.150
     3.383    55.162     0.150
     4.977    79.531     0.150
     5.115    77.043     0.150
     5.734   173.076     0.150
     5.881    90.463     0.150
     7.380   107.383     0.150
    16.664   236.572     0.150
    42.434  3204.789     0.150
    42.440  3206.840     0.150
    42.452  3207.742     0.150
    43.600  3297.449     0.150
    43.613  3293.957     0.150
    43.617  3293.551     0.150
    64.191   633.805     0.150
    77.040   712.158     0.150
    80.988   734.744     0.150
    84.225   749.912     0.150
     1.052    19.215     0.150
     1.052    19.215     0.150
     1.179    22.227     0.150
     1.190    22.086     0.150
     1.190    37.914     0.150
     1.225    22.625     0.150
     1.306    24.246     0.150
     1.559    28.109     0.150
     1.602    29.371     0.150
     1.731    54.164     0.150
     2.066    35.957     0.150
     3.378    54.305     0.150
     4.953    74.871     0.150
     4.976    75.211     0.150
     5.450    82.102     0.150
     5.776   170.504     0.150
     6.041    90.918     0.150
     6.271    93.410     0.150
     6.336    96.508     0.150
     6.394    94.434     0.150
     6.526    96.969     0.150
     6.740    99.336     0.150
     6.796   100.016     0.150
     7.666   112.480     0.150
     8.329   123.105     0.150
    10.662   151.555     0.150
    12.603   173.637     0.150
    14.635   216.137     0.150
    14.976   213.484     0.150
    15.216   222.414     0.150
    47.746   529.836     0.150
    59.280   599.086     0.150
    64.814   635.734     0.150
    65.021   637.504     0.150
   144.093  1184.504     0.150
     0.825    15.648     0.150
     0.825    26.680     0.150
     1.688    29.754     0.150
     2.107    35.688     0.150
     2.107    63.762     0.150
     3.734    58.328     0.150
     4.007    61.582     0.150
     4.566    68.617     0.150
     4.941    73.555     0.150
     5.126    74.195     0.150
     5.370    79.102     0.150
     5.395    81.676     0.150
     5.412    79.699     0.150
     5.719    87.457     0.150
     5.894    86.844     0.150
     6.108    89.504     0.150
     6.253    91.176     0.150
     6.426    94.508     0.150
     6.434    94.504     0.150
     6.909   100.113     0.150
     7.111   102.844     0.150
     7.131   102.652     0.150
     7.202   104.695     0.150
     7.575   109.008     0.150
     7.762   112.254     0.150
     8.011   116.367     0.150
     8.081   117.312     0.150
     8.698   125.027     0.150
     9.010   129.414     0.150
     8.932   129.547     0.150
     9.304   131.996     0.150
     9.872   140.285     0.150
    10.002   144.957     0.150
    12.056   163.727     0.150
    15.404   213.316     0.150
    18.367   249.852     0.150
    32.260   392.418     0.150
    43.039  3231.875     0.150
    43.045  3230.703     0.150
    43.057  3234.340     0.150
    44.203  3318.926     0.150
    44.216  3323.680     0.150
    44.220  3331.066     0.150
    47.071   507.078     0.150
    50.719   535.426     0.150
    64.949   635.691     0.150
   111.657  8387.910     0.150
   111.668  8381.531     0.150
   111.673  8394.316     0.150
     3.876    56.672     0.150
     7.603   110.203     0.150
    10.366   144.086     0.150
     0.324     3.172     0.150
     0.324     2.854     0.150
     1.284    41.514     0.150
     1.501    44.221     0.150
     1.474    25.883     0.150
     1.935    56.422     0.150
     1.935    56.422     0.150
     2.536    31.953     0.150
     3.237    49.752     0.150
     4.006    58.453     0.150
     4.058    60.633     0.150
     4.236    64.578     0.150
     4.365    64.803     0.150
     4.585    67.602     0.150
     5.051    73.928     0.150
     5.290    78.229     0.150
     5.782    85.627     0.150
     6.116    87.434     0.150
     6.195    91.152     0.150
     6.457    90.992     0.150
     6.457    91.971     0.150
     6.558    93.133     0.150
     6.628    96.803     0.150
     6.756    96.883     0.150
     6.876    99.377     0.150
     6.889   100.229     0.150
    10.793   151.172     0.150
    11.089   159.092     0.150
    11.654   281.703     0.150
    14.943   210.223     0.150
    17.943   441.027     0.150
    26.445   331.082     0.150
    34.037   411.854     0.150
    46.793   518.027     0.150
     1.042    31.834     0.150
     1.422    25.799     0.150
     1.495    27.291     0.150
     1.635    51.043     0.150
     1.693    53.834     0.150
     2.001    33.934     0.150
     2.018    33.984     0.150
     2.018    34.041     0.150
     2.224    65.354     0.150
     3.320    53.146     0.150
     4.110    61.043     0.150
     4.793    72.074     0.150
     4.870    73.105     0.150
     4.920    74.887     0.150
     4.920    74.824     0.150
     5.375    79.574     0.150
     5.518    82.174     0.150
     5.748    85.123     0.150
     5.757   170.969     0.150
     5.767    85.641     0.150
     5.919    88.330     0.150
     6.168    91.475     0.150
     6.278    92.490     0.150
     6.316    89.713     0.150
     6.690    98.061     0.150
     6.987   102.332     0.150
     7.230   105.391     0.150
     7.268   103.984     0.150
     7.269   105.445     0.150
     7.579   110.234     0.150
     7.769   112.668     0.150
     7.846   113.740     0.150
     8.243   120.424     0.150
     8.425   119.934     0.150
     8.419   120.264     0.150
     8.419   120.266     0.150
     8.448   121.049     0.150
     8.527   122.146     0.150
     8.878   126.213     0.150
     9.314   132.094     0.150
     9.325   132.803     0.150
     9.964   140.984     0.150
    15.032   212.604     0.150
    17.470   246.498     0.150
    18.878   257.424     0.150
    36.920   427.963     0.150
    42.415  3179.318     0.150
    42.421  3179.633     0.150
    42.433  3180.607     0.150
    43.581  3262.375     0.150
    43.595  3260.053     0.150
    43.599  3262.797     0.150
    63.862     3.600     0.150
    74.758   697.725     0.150
    78.482   718.877     0.150
    80.906   733.123     0.150
     1.222    40.277     0.150
     1.222    23.016     0.150
     1.825    51.914     0.150
     1.825    51.914     0.150
     2.077    32.457     0.150
     2.375    39.148     0.150
     2.453    41.477     0.150
     2.811    42.086     0.150
     3.432   105.961     0.150
     3.871    60.016     0.150
     9.941   140.496     0.150
    10.480   141.551     0.150
    10.480   253.266     0.150
    15.114   217.039     0.150
    16.744   417.938     0.150
    24.405   315.637     0.150
    25.798   323.672     0.150
    55.277   568.348     0.150
    63.115   621.543     0.150
    64.210   629.766     0.150
    64.614   632.445     0.150
    66.148   641.930     0.150
    73.769   688.316     0.150
    82.263   736.609     0.150
     0.568    12.527     0.150
     0.568    21.996     0.150
     1.201    22.484     0.150
     1.200    39.047     0.150
     1.340    22.688     0.150
     1.340    39.898     0.150
     1.340    39.898     0.150
     1.820    28.215     0.150
     1.820    49.871     0.150
     2.098    32.762     0.150
     2.475    36.754     0.150
     2.483    38.262     0.150
     2.483    68.121     0.150
     2.823    43.289     0.150
     3.014    45.723     0.150
     3.374    50.312     0.150
     3.390    50.406     0.150
     3.553    52.781     0.150
     4.085    60.824     0.150
     4.194    62.305     0.150
     4.342    64.582     0.150
     4.529    66.402     0.150
     4.613    67.801     0.150
     4.840    71.207     0.150
     4.794    70.145     0.150
     4.871    71.309     0.150
     5.122    74.547     0.150
     5.232    76.898     0.150
     5.336    77.711     0.150
     5.810    84.152     0.150
     5.854    84.148     0.150
     5.937    85.520     0.150
     6.077    87.883     0.150
     6.108    88.199     0.150
     6.278    90.094     0.150
     6.298    89.484     0.150
     6.506    93.512     0.150
     6.517    94.016     0.150
     6.519    93.473     0.150
     6.632    93.238     0.150
     6.825    96.957     0.150
     7.235   102.719     0.150
     7.340   104.219     0.150
     8.072   114.465     0.150
     8.761   124.379     0.150
     9.233   129.250     0.150
     1.011    29.471     0.150
     1.011    29.961     0.150
     1.011    19.621     0.150
     1.011    29.961     0.150
     1.004    29.580     0.150
     1.008    29.660     0.150
     1.008    18.928     0.150
     1.008    28.859     0.150
     0.988    21.121     0.150
     1.003    21.080     0.150
     1.015    21.141     0.150
     1.051    21.711     0.150
     1.372    28.461     0.150
     1.372    28.428     0.150
     1.506    30.730     0.150
     1.506    51.971     0.150
     1.567    54.551     0.150
     1.669    34.041     0.150
     1.992    39.279     0.150
     2.454    70.400     0.150
     2.454    68.871     0.150
     2.092    40.320     0.150
     2.092    67.881     0.150
     2.104    40.920     0.150
     2.809    50.250     0.150
     2.823    50.561     0.150
     2.830    50.500     0.150
     2.837    50.721     0.150
     2.859    51.600     0.150
     3.484    92.166     0.150
     3.186    55.320     0.150
     3.186    55.250     0.150
     3.186    93.594     0.150
     3.264    56.340     0.150
     3.335    57.500     0.150
     3.412    58.541     0.150
     4.516    68.561     0.150
     5.521    83.234     0.150
     5.521   143.551     0.150
     5.868    86.760     0.150
     5.811    89.930     0.150
     5.811    90.240     0.150
     6.203    93.012     0.150
     6.359    94.350     0.150
     6.722    98.480     0.150
     7.272   107.154     0.150
     7.276   106.508     0.150
     7.633   112.510     0.150
     8.301   123.400     0.150
     8.110   125.141     0.150
     8.110   122.461     0.150
     8.650   124.551     0.150
     8.892   127.689     0.150
     9.725   139.230     0.150
    10.007   143.760     0.150
    10.260   147.154     0.150
    10.742   153.168     0.150
    11.006   156.816     0.150
    12.320   172.664     0.150
    12.608   175.760     0.150
    12.608   303.285     0.150
    12.940   180.109     0.150
    13.439   188.924     0.150
    14.104   195.260     0.150
    14.104   195.768     0.150
    14.809   210.051     0.150
    15.049   212.471     0.150
    15.049   212.730     0.150
    15.982   225.029     0.150
    17.394   240.971     0.150
    17.594   434.586     0.150
    17.973   247.260     0.150
    18.958   462.035     0.150
    20.367   277.520     0.150
    23.302   304.090     0.150
    33.001   398.260     0.150
    41.092   462.260     0.150
    41.910   468.580     0.150
    42.308  3172.684     0.150
    42.314  3181.480     0.150
    42.326  3178.316     0.150
    42.885   476.439     0.150
    43.476  3264.988     0.150
    43.490  3263.902     0.150
    43.493  3266.303     0.150
    44.604   496.461     0.150
    44.604   493.920     0.150
    46.842   508.090     0.150
    46.931   508.660     0.150
    47.963   521.811     0.150
    48.276   519.180     0.150
    54.340   566.680     0.150
    56.940   586.359     0.150
    57.420   590.461     0.150
    63.066     5.699     0.150
    64.229   633.359     0.150
    64.229    15.201     0.150
    64.724   636.859     0.150
    66.346   646.020     0.150
    67.351   653.020     0.150
    67.748   656.141     0.150
    68.191   658.650     0.150
    68.822   662.250     0.150
    69.200   665.961     0.150
    69.605   666.801     0.150
    69.761   668.480     0.150
    70.420   671.230     0.150
    71.616   682.590     0.150
    71.663   681.840     0.150
    71.683   681.480     0.150
    72.274   673.711     0.150
    73.009   674.721     0.150
    74.391   701.660     0.150
    75.243   702.920     0.150
    75.359   703.520     0.150
    75.859   706.400     0.150
    76.724   711.721     0.150
    76.975   713.170     0.150
    77.715   716.381     0.150
    78.662   721.791     0.150
    79.062   725.115     0.150
    79.069   724.680     0.150
    79.060   723.980     0.150
    79.409   724.791     0.150
    80.373   731.520     0.150
    81.222   741.699     0.150
    82.239   741.270     0.150
    82.500   742.600     0.150
    83.075   742.260     0.150
    83.520   746.670     0.150
    83.842   751.520     0.150
    92.197   791.311     0.150
   112.280  8474.559     0.150
   112.292  8478.086     0.150
   112.297  8469.219     0.150
   153.787  1200.461     0.150
     0.878    25.980     0.150
     0.916    17.684     0.150
     0.995    32.391     0.150
     1.005    33.141     0.150
     1.041    33.352     0.150
     1.611    51.422     0.150
     4.882    75.523     0.150
     5.362    82.203     0.150
     5.840    85.184     0.150
    12.502   172.352     0.150
    15.956   227.293     0.150
    42.434  3166.246     0.150
    42.440  3165.887     0.150
    42.452  3174.551     0.150
    43.601  3269.199     0.150
    43.614  3264.762     0.150
    43.618  3269.645     0.150
     0.715    17.105     0.150
     0.848    27.008     0.150
     1.071    20.977     0.150
     1.068    20.945     0.150
     1.068    35.355     0.150
     1.072    21.156     0.150
     1.072    35.273     0.150
     1.094    21.477     0.150
     1.094    35.504     0.150
     1.769    56.004     0.150
     2.367    70.586     0.150
     3.191    50.004     0.150
     3.191    50.039     0.150
     4.229    64.328     0.150
     4.733    72.367     0.150
     4.764    72.703     0.150
     4.976    73.906     0.150
     5.453   143.719     0.150
     5.592    82.477     0.150
     5.681    84.145     0.150
     5.731   151.859     0.150
     6.067   160.219     0.150
     7.121   104.500     0.150
     7.199   105.996     0.150
     7.817   113.477     0.150
     8.120   116.316     0.150
     9.152   130.566     0.150
     9.404   133.676     0.150
     9.854   140.504     0.150
    10.043   143.297     0.150
    10.163   143.184     0.150
    10.738   155.129     0.150
    11.385   163.867     0.150
    12.355   173.816     0.150
    14.017   196.285     0.150
    14.884   210.215     0.150
    14.939   212.262     0.150
    15.414   218.766     0.150
    15.635   221.691     0.150
    15.824   222.539     0.150
    42.578  3183.926     0.150
    42.584  3180.270     0.150
    42.596  3179.785     0.150
    43.744  3266.008     0.150
    43.758  3270.734     0.150
    43.761  3267.148     0.150
    44.884   496.246     0.150
    63.949     8.301     0.150
    74.516   703.105     0.150
    74.516  1152.305     0.150
     0.726    14.352     0.150
     1.282    23.266     0.150
     1.310    23.891     0.150
     1.310    23.852     0.150
     1.310    42.352     0.150
     1.412    25.711     0.150
     1.460    25.672     0.150
     2.215    65.078     0.150
     2.382    39.656     0.150
     2.688    41.352     0.150
     3.969    60.625     0.150
     7.027   100.375     0.150
     7.952   112.266     0.150
     8.935   127.547     0.150
     9.723   137.250     0.150
    10.265   146.352     0.150
    10.394   146.750     0.150
    10.440   149.352     0.150
    10.632   150.250     0.150
    12.004   300.000     0.150
    12.004   167.750     0.150
    13.963   195.148     0.150
    14.238   203.742     0.150
    14.504   202.656     0.150
    16.170  1239.438     0.150
    17.219   239.695     0.150
    18.322   248.445     0.150
    20.361   276.977     0.150
    24.252   315.148     0.150
    24.252   315.258     0.150
    24.434   316.820     0.150
    29.009   759.555     0.150
    35.251   411.898     0.150
    35.807   417.250     0.150
    39.516   446.859     0.150
    41.356   461.750     0.150
    42.509   470.102     0.150
    43.055  3248.492     0.150
    43.061  3248.945     0.150
    43.073  3239.367     0.150
    44.220  3319.336     0.150
    44.234  3336.586     0.150
    44.238  3335.844     0.150
    45.338   497.172     0.150
    45.338   496.250     0.150
    46.738   507.047     0.150
    46.972   507.922     0.150
    50.884   537.547     0.150
    51.483   542.750     0.150
    51.524   543.352     0.150
    55.744   572.750     0.150
    64.156   631.547     0.150
    64.240     5.102     0.150
    64.265   627.250     0.150
    64.769     7.805     0.150
    64.949   774.750     0.150
    66.315   648.148     0.150
    69.710   667.148     0.150
    69.710   671.852     0.150
    69.710   921.547     0.150
    70.972   937.250     0.150
    73.528   689.648     0.150
    74.189   693.648     0.150
    74.686   696.445     0.150
    74.694   695.547     0.150
    74.680   700.352     0.150
    75.022   698.945     0.150
    75.022    10.000     0.150
    75.058   699.547     0.150
    75.267   699.648     0.150
    75.553   702.047     0.150
    75.553    10.000     0.150
    75.553   700.789     0.150
    75.866   697.828     0.150
    75.866   697.852     0.150
    76.267     9.742     0.150
    76.390   707.250     0.150
    76.390     8.695     0.150
    76.390   707.211     0.150
    76.514   708.648     0.150
    76.717   709.148     0.150
    76.731   706.047     0.150
    76.731   706.047     0.150
    77.167   711.445     0.150
    77.266   711.648     0.150
    77.266   711.648     0.150
    77.296   710.648     0.150
    77.917   714.789     0.150
    77.961   715.148     0.150
    78.151     8.727     0.150
    78.336   717.117     0.150
    78.428   719.969     0.150
    78.474   718.250     0.150
    78.601   726.117     0.150
    78.704   721.211     0.150
    78.852   720.648     0.150
    79.392   723.047     0.150
    79.644   724.852     0.150
    79.663   726.344     0.150
    79.663   726.352     0.150
    79.848   725.750     0.150
    79.962   727.648     0.150
    80.043   727.047     0.150
    80.054   728.148     0.150
    80.143   728.250     0.150
    80.249   728.750     0.150
    80.256   726.516     0.150
    80.256   726.547     0.150
    80.754   729.047     0.150
    80.754   729.047     0.150
    80.863   731.648     0.150
    81.396   733.945     0.150
    81.667   734.445     0.150
    83.750   745.500     0.150
    85.226   753.648     0.150
    92.982   789.102     0.150
   111.741  8380.461     0.150
   111.753  8383.977     0.150
   111.758  8383.062     0.150
   153.659  1194.297     0.150
     1.174    20.516     0.150
     1.497    48.355     0.150
     1.936    51.246     0.150
     1.936    30.215     0.150
     4.250    63.645     0.150
     4.423   136.559     0.150
     5.923    87.297     0.150
     8.900   127.715     0.150
    10.097   141.488     0.150
    10.721   149.098     0.150
    11.047   153.816     0.150
    12.001   165.316     0.150
    13.320   182.906     0.150
    14.743   203.035     0.150
    28.199   346.406     0.150
    29.383   356.738     0.150
    29.760   360.727     0.150
    31.820   378.375     0.150
    32.549   386.195     0.150
    33.785   396.828     0.150
    36.228   418.598     0.150
    37.109   425.227     0.150
    37.220   426.457     0.150
    43.805   482.277     0.150
    43.751  3298.961     0.150
    43.757  3299.273     0.150
    43.769  3299.395     0.150
    44.912  3384.508     0.150
    44.926  3384.066     0.150
    44.930  3385.297     0.150
    46.552   503.387     0.150
    46.552   503.387     0.150
    63.948   630.215     0.150
    66.733   651.516     0.150
    74.573   695.609     0.150
    83.328   744.973     0.150
    93.727   795.652     0.150
   111.162  8361.840     0.150
   111.174  8362.848     0.150
   111.179  8361.582     0.150
     0.609    12.430     0.150
     1.231    21.371     0.150
     1.231    22.330     0.150
     1.575    26.725     0.150
     2.364    36.389     0.150
     2.242    36.543     0.150
     2.580    40.531     0.150
     3.380    50.330     0.150
     3.380    50.277     0.150
     4.118    59.996     0.150
     4.238    64.131     0.150
     4.732   138.500     0.150
     4.732    68.391     0.150
     5.134    75.988     0.150
     5.734    83.873     0.150
     5.854    84.881     0.150
     5.965    87.154     0.150
     7.128   103.020     0.150
     7.376   106.328     0.150
     7.414   105.709     0.150
     7.554   108.832     0.150
     9.916   139.391     0.150
    10.463   150.381     0.150
    11.321   161.270     0.150
    11.431   160.682     0.150
    11.431   163.770     0.150
    11.797   163.955     0.150
    12.131   169.658     0.150
    12.970   181.490     0.150
    13.016   180.852     0.150
    13.098   181.906     0.150
    13.789   193.365     0.150
    18.781   258.701     0.150
    24.370     6.699     0.150
    43.437  3253.029     0.150
    43.443  3256.727     0.150
    43.455  3255.373     0.150
    44.603  3341.670     0.150
    44.617  3342.771     0.150
    44.621  3352.125     0.150
    45.943   497.980     0.150
    59.781   604.430     0.150
    63.710     9.799     0.150
    64.223     9.400     0.150
    64.223    13.400     0.150
    66.223   647.330     0.150
    74.300   695.930     0.150
    74.366   693.891     0.150
    76.024   703.230     0.150
    76.154   706.180     0.150
    78.348   715.760     0.150
    78.536   719.684     0.150
    79.887   725.385     0.150
    93.334   793.559     0.150
   111.723  8374.373     0.150
   111.735  8379.834     0.150
   111.740  8378.377     0.150
   147.813  1181.721     0.150
   148.091  1182.381     0.150
     1.036    30.082     0.150
     2.086    34.982     0.150
     2.086    35.082     0.150
     6.780    98.023     0.150
     7.332   111.082     0.150
     7.883   116.072     0.150
     8.314   123.303     0.150
     9.694   142.412     0.150
    10.438   151.883     0.150
    12.031   174.043     0.150
    12.339   181.232     0.150
    12.472   178.572     0.150
    13.398   192.912     0.150
    14.562   212.232     0.150
    14.961   214.213     0.150
    38.471   443.473     0.150
    42.401  3208.182     0.150
    42.407  3208.227     0.150
    42.419  3187.824     0.150
    43.567  3288.273     0.150
    43.580  3295.607     0.150
    43.584  3288.424     0.150
    51.488   548.002     0.150
    54.561   629.389     0.150
    56.863   588.062     0.150
    74.596   702.062     0.150
    95.677  1042.186     0.150
   153.919  1199.887     0.150
   155.638  1216.988     0.150
     1.463    26.891     0.150
     4.339    64.070     0.150
     5.188    78.172     0.150
     7.493   106.742     0.150
     7.593   107.742     0.150
     7.912   113.039     0.150
     8.296   118.656     0.150
     1.068    34.195     0.150
     1.087    21.109     0.150
     1.087    33.867     0.150
     1.110    36.102     0.150
     1.866    31.969     0.150
     4.744    70.836     0.150
     5.433    80.438     0.150
    11.382   163.461     0.150
    15.794   223.508     0.150
     0.122     1.863     0.150
     0.227     2.664     0.150
     0.172     5.264     0.150
     0.469     5.473     0.150
     0.469    10.443     0.150
     0.515     7.244     0.150
     0.716    11.344     0.150
     0.807    23.633     0.150
     0.807    13.113     0.150
     0.857    26.764     0.150
     1.544    46.023     0.150
     1.769    30.943     0.150
     1.893    32.824     0.150
     2.051    32.904     0.150
     2.051    33.133     0.150
     2.065    32.693     0.150
     2.126    33.764     0.150
     2.126    34.084     0.150
     2.151    34.484     0.150
     2.902    44.334     0.150
     4.431    66.934     0.150
     5.620    82.664     0.150
     5.678    83.684     0.150
     6.106    92.523     0.150
     7.842   112.844     0.150
     8.012   114.414     0.150
     9.519   136.434     0.150
    10.405   147.523     0.150
    10.405   260.484     0.150
    10.405   338.650     0.150
    14.202   203.174     0.150
    26.570   339.113     0.150
    54.179   564.562     0.150
    65.095   639.713     0.150
    69.842   669.484     0.150
    82.091   740.664     0.150
   146.112  1176.867     0.150
   146.112  1177.543     0.150
   162.520  1240.492     0.150
     2.600    42.625     0.150
     2.600    42.975     0.150
     3.458    55.024     0.150
     5.443   135.285     0.150
    12.322   299.189     0.150
    15.421   217.174     0.150
    42.722  3228.522     0.150
    42.727  3230.382     0.150
    42.739  3229.420     0.150
    43.886  3314.071     0.150
    43.900  3317.479     0.150
    43.903  3318.233     0.150
    64.316   630.915     0.150
    64.316   633.725     0.150
    64.635   633.005     0.150
    66.083   645.555     0.150
   111.848  8378.408     0.150
   111.860  8385.105     0.150
   111.865  8376.545     0.150
     0.403     5.137     0.150
     0.374     7.016     0.150
     0.578    11.277     0.150
     0.670    10.656     0.150
     0.900    14.516     0.150
     0.965    15.738     0.150
     1.069    17.906     0.150
     1.069    18.316     0.150
     1.155    38.668     0.150
     1.155    38.328     0.150
     1.785    31.227     0.150
     1.785    55.938     0.150
     1.826    31.676     0.150
     2.054    33.398     0.150
     1.951    60.086     0.150
     2.201    66.176     0.150
     2.299    35.855     0.150
     3.272    49.836     0.150
     3.846   101.836     0.150
     3.846    57.508     0.150
     3.846   102.195     0.150
     4.953   134.668     0.150
     4.953    74.688     0.150
    10.205   147.527     0.150
    10.602   267.930     0.150
    11.547   164.309     0.150
    12.069   170.445     0.150
    33.881   399.168     0.150
    54.645   568.605     0.150
    64.129   633.227     0.150
     0.621    11.250     0.150
     0.621    11.062     0.150
     1.148    19.551     0.150
     1.148    30.650     0.150
     1.148    19.650     0.150
     1.148    19.631     0.150
     1.291    41.600     0.150
     1.390    23.734     0.150
     1.390    25.350     0.150
     1.578    27.609     0.150
     1.861    54.949     0.150
     1.861    29.260     0.150
     1.867    30.740     0.150
     1.903    30.811     0.150
     1.918    31.039     0.150
     2.012    32.740     0.150
     2.917    44.150     0.150
     3.689    55.529     0.150
     3.689    54.449     0.150
     4.287    64.750     0.150
     4.326   138.955     0.150
     4.326    64.680     0.150
     4.326    62.920     0.150
     4.326    63.039     0.150
     4.326    63.189     0.150
     4.782    68.650     0.150
     5.007    73.750     0.150
     6.886    98.051     0.150
     7.083    94.750     0.150
     8.247   114.250     0.150
     8.662   119.850     0.150
     8.801   124.820     0.150
    10.167   145.670     0.150
    11.020   156.615     0.150
    11.228  2236.250     0.150
    11.230   156.510     0.150
    11.327   159.729     0.150
    11.381   275.699     0.150
    11.381  2344.449     0.150
    11.381   157.789     0.150
    12.430   172.525     0.150
    12.875   176.785     0.150
    12.894   181.682     0.150
    13.215   181.043     0.150
    13.313   187.510     0.150
    13.313   187.352     0.150
    13.475   186.459     0.150
    13.521   186.285     0.150
    13.740   190.867     0.150
    13.896   190.098     0.150
    13.924   192.650     0.150
    14.012   193.539     0.150
    14.012   192.061     0.150
    14.289   198.160     0.150
    14.330   195.625     0.150
    14.415   196.980     0.150
    14.478   198.568     0.150
    14.868   204.957     0.150
    15.298   211.320     0.150
    15.376   216.100     0.150
    15.376  1236.027     0.150
    15.376  1235.936     0.150
    15.388   210.865     0.150
    15.391   208.910     0.150
    15.395   209.998     0.150
    15.435   212.926     0.150
    16.119   219.615     0.150
    16.158   220.830     0.150
    16.207   220.879     0.150
    16.244   405.369     0.150
    16.363   222.715     0.150
    16.472   224.418     0.150
    16.552   227.004     0.150
    16.940   230.881     0.150
    17.656   239.699     0.150
    17.656   241.449     0.150
    18.008   249.496     0.150
    18.219   252.301     0.150
    18.219   252.971     0.150
    22.845   303.881     0.150
    23.576  2303.900     0.150
    24.778   322.250     0.150
    24.778   322.260     0.150
    24.778   322.770     0.150
    24.778   323.260     0.150
    25.426  7816.250     0.150
    25.433   324.109     0.150
    26.272   334.100     0.150
    26.934  2292.158     0.150
    27.193   339.869     0.150
    27.193   341.150     0.150
    30.048   371.750     0.150
    30.048   370.840     0.150
    30.785   375.949     0.150
    31.656  2274.125     0.150
    31.805  2275.676     0.150
    31.801   382.000     0.150
    33.545   401.850     0.150
    33.553   399.400     0.150
    33.768  2267.150     0.150
    34.903     8.801     0.150
    34.903   733.250     0.150
    35.423   418.789     0.150
    36.017   752.750     0.150
    36.113   420.619     0.150
    36.113   420.609     0.150
    36.194   420.770     0.150
    36.194    12.350     0.150
    36.299   500.350     0.150
    36.299   760.051     0.150
    36.299   417.631     0.150
    36.657   418.980     0.150
    36.767   511.449     0.150
    36.767   531.750     0.150
    36.767   569.750     0.150
    36.767   763.350     0.150
    36.767   950.051     0.150
    36.811   941.449     0.150
    36.811   425.500     0.150
    36.811   425.650     0.150
    36.811   423.039     0.150
    36.811     8.842     0.150
    37.152   433.367     0.150
    37.209  2251.875     0.150
    39.132   450.051     0.150
    39.576   447.705     0.150
    39.576   449.061     0.150
    39.576   447.350     0.150
    40.308   457.061     0.150
    40.766   458.311     0.150
    41.337   577.949     0.150
    41.337   829.250     0.150
    41.568   463.949     0.150
    43.233     3.100     0.150
    43.233   863.650     0.150
    43.843   489.020     0.150
    43.843  3269.514     0.150
    43.848   489.051     0.150
    43.848  3270.021     0.150
    43.861   489.016     0.150
    43.861  3279.676     0.150
    44.344   490.311     0.150
    44.491   487.250     0.150
    45.005  3367.402     0.150
    45.018  3363.078     0.150
    45.022  3376.488     0.150
    45.544  1090.850     0.150
    46.013     9.199     0.150
    46.013    13.400     0.150
    46.013   918.551     0.150
    46.089   501.811     0.150
    46.089   500.650     0.150
    46.089   500.461     0.150
    46.174   502.490     0.150
    46.192   502.270     0.150
    46.556   506.350     0.150
    47.002   508.461     0.150
    47.002   505.930     0.150
    47.002   510.320     0.150
    47.038   508.051     0.150
    47.607   514.301     0.150
    47.971   514.010     0.150
    48.723   938.410     0.150
    48.950  2381.225     0.150
    50.572   538.010     0.150
    50.572   538.090     0.150
    50.673   536.449     0.150
    50.673   535.350     0.150
    50.673   536.490     0.150
    50.739   537.900     0.150
    50.868   537.279     0.150
    51.004   538.840     0.150
    51.204   544.270     0.150
    51.342  2788.449     0.150
    51.342   542.250     0.150
    51.820   544.211     0.150
    52.016   546.250     0.150
    52.016   546.250     0.150
    52.016   987.984     0.150
    52.016   987.984     0.150
    52.016   547.430     0.150
    52.756   549.910     0.150
    52.812   557.551     0.150
    53.766   559.818     0.150
    53.766   559.818     0.150
    53.766  1017.826     0.150
    53.766  1017.826     0.150
    53.766  1017.826     0.150
    53.766   559.811     0.150
    54.168   563.199     0.150
    54.919   568.076     0.150
    54.919   568.076     0.150
    54.919  1027.680     0.150
    54.919  1027.680     0.150
    54.919   567.619     0.150
    54.919   567.949     0.150
    54.919   567.711     0.150
    55.069   569.189     0.150
    55.251  2804.254     0.150
    55.251   570.449     0.150
    55.251   570.449     0.150
    55.470  1033.787     0.150
    55.470   572.010     0.150
    55.722  2805.051     0.150
    55.722   573.400     0.150
    56.146   578.561     0.150
    56.962   581.449     0.150
    57.250   582.430     0.150
    57.284   583.301     0.150
    57.407  1058.650     0.150
    57.407  1297.449     0.150
    57.751    13.000     0.150
    58.008   593.449     0.150
    58.323   596.551     0.150
    58.630    13.699     0.150
    58.696     8.000     0.150
    58.696   722.650     0.150
    58.807   594.670     0.150
    59.064   600.051     0.150
    59.064   600.061     0.150
    59.546   601.160     0.150
    59.609   883.150     0.150
    59.609  1087.051     0.150
    59.750   601.150     0.150
    59.750     8.900     0.150
    60.040   605.010     0.150
    60.040   602.100     0.150
    60.232   601.090     0.150
    60.340     7.000     0.150
    61.962     7.199     0.150
    62.393   622.150     0.150
    62.597   621.090     0.150
    63.012  1136.090     0.150
    63.419   624.029     0.150
    63.589   855.449     0.150
    63.589  1388.650     0.150
    63.774   628.551     0.150
    63.774   628.500     0.150
    63.826  2836.426     0.150
    63.985     8.600     0.150
    63.985    14.000     0.150
    64.006   631.150     0.150
    64.055   779.949     0.150
    64.055  1147.250     0.150
    64.126   630.881     0.150
    64.152   626.529     0.150
    64.236  1399.660     0.150
    64.248   632.014     0.150
    64.248  1145.814     0.150
    64.248   629.520     0.150
    64.247     7.701     0.150
    64.247   630.080     0.150
    64.306   630.939     0.150
    64.367   633.502     0.150
    64.367  1149.643     0.150
    64.367   633.420     0.150
    64.367   632.859     0.150
    64.549   635.510     0.150
    64.812   635.279     0.150
    64.816   636.721     0.150
    64.816  1157.471     0.150
    64.950  1412.150     0.150
    64.950  1580.551     0.150
    65.091   636.250     0.150
    65.149   636.250     0.150
    65.293   640.461     0.150
    65.308     8.900     0.150
    65.308  1419.150     0.150
    65.347   642.740     0.150
    65.480   646.350     0.150
    65.840   641.570     0.150
    65.992   648.750     0.150
    66.450   646.061     0.150
    66.450   645.199     0.150
    66.607   646.221     0.150
    66.661   647.439     0.150
    66.747   649.670     0.150
    67.709   653.529     0.150
    67.709   655.141     0.150
    68.182  2354.900     0.150
    68.191   658.961     0.150
    68.816   914.250     0.150
    68.816  1204.449     0.150
    68.842   663.020     0.150
    68.936   663.391     0.150
    68.972   663.789     0.150
    69.003   663.820     0.150
    69.305   665.230     0.150
    69.305  1211.750     0.150
    69.408   665.051     0.150
    69.408     8.199     0.150
    69.408    12.500     0.150
    69.408  1261.051     0.150
    69.533  2353.193     0.150
    69.533   921.250     0.150
    69.533  1212.051     0.150
    69.671     5.400     0.150
    70.001   678.850     0.150
    70.186   671.900     0.150
    70.199   661.090     0.150
    70.447   673.051     0.150
    70.490   671.711     0.150
    70.490  1223.900     0.150
    70.519   673.000     0.150
    70.519  1226.330     0.150
    70.532   675.891     0.150
    70.542   673.760     0.150
    70.567  2347.551     0.150
    70.592   674.354     0.150
    70.596   674.840     0.150
    70.665   673.760     0.150
    70.688   673.990     0.150
    70.688   674.000     0.150
    70.688   670.600     0.150
    70.721  1695.020     0.150
    70.721   931.350     0.150
    70.721   673.359     0.150
    70.721   673.359     0.150
    70.721   673.359     0.150
    70.721   694.439     0.150
    70.721   829.150     0.150
    70.721   931.410     0.150
    70.721  1227.100     0.150
    70.721  1499.080     0.150
    70.819   674.631     0.150
    70.972   675.631     0.150
    70.972  1231.189     0.150
    71.014   680.449     0.150
    71.014   680.141     0.150
    71.012   675.830     0.150
    71.027   676.537     0.150
    71.212   680.689     0.150
    71.386   678.000     0.150
    71.386  1236.051     0.150
    71.329   678.170     0.150
    71.692   680.600     0.150
    71.774   945.850     0.150
    71.774  1697.449     0.150
    72.034   682.660     0.150
    72.124   683.471     0.150
    72.148   683.398     0.150
    72.213   683.840     0.150
    72.261   681.600     0.150
    72.277   682.869     0.150
    72.359   684.830     0.150
    72.443   685.184     0.150
    72.477   681.260     0.150
    72.588   686.430     0.150
    72.657   687.051     0.150
    72.657   687.250     0.150
    72.719   690.051     0.150
    72.766   686.051     0.150
    72.766   686.391     0.150
    72.766   686.121     0.150
    72.766   686.359     0.150
    72.766   684.961     0.150
    72.809   953.449     0.150
    72.859   687.539     0.150
    72.954   687.600     0.150
    72.998   688.830     0.150
    73.111   953.449     0.150
    73.114   689.230     0.150
    73.129   684.971     0.150
    73.132     9.600     0.150
    73.132  1267.850     0.150
    73.258   689.529     0.150
    73.258   689.689     0.150
    73.342   691.250     0.150
    73.390   693.750     0.150
    73.379   690.848     0.150
    73.516   691.811     0.150
    73.596   691.781     0.150
    73.596   691.539     0.150
    73.638   691.400     0.150
    73.724   691.170     0.150
    73.813   702.051     0.150
    73.813  1267.250     0.150
    73.813   692.637     0.150
    73.813   691.250     0.150
    73.813   696.250     0.150
    73.813    10.801     0.150
    73.813   868.250     0.150
    73.813  1267.250     0.150
    73.813  1336.250     0.150
    73.813  1612.250     0.150
    73.813  1750.250     0.150
    73.813  1798.250     0.150
    73.813  2561.250     0.150
    73.813 10876.250     0.150
    73.813 11416.250     0.150
    73.813 13276.250     0.150
    73.813 13276.250     0.150
    73.813 14176.250     0.150
    73.813 14296.250     0.150
    73.839   693.174     0.150
    74.013   695.150     0.150
    74.104   694.412     0.150
    74.296   695.670     0.150
    74.296     9.820     0.150
    74.296  1273.250     0.150
    74.296  2354.240     0.150
    74.391   696.436     0.150
    74.453   694.730     0.150
    74.461   694.590     0.150
    74.461   694.760     0.150
    74.461   693.359     0.150
    74.537     8.199     0.150
    74.571   697.525     0.150
    74.584   697.484     0.150
    74.671   697.551     0.150
    74.672   698.082     0.150
    74.708   697.850     0.150
    74.708     4.201     0.150
    74.725   697.689     0.150
    74.725  1273.730     0.150
    74.737   697.830     0.150
    74.750   697.949     0.150
    74.750     4.102     0.150
    74.786   702.990     0.150
    74.853   698.750     0.150
    74.853     4.000     0.150
    74.853  1275.350     0.150
    74.880   701.850     0.150
    74.907   699.850     0.150
    74.907   699.850     0.150
    74.918   698.949     0.150
    75.147   703.311     0.150
    75.208   700.650     0.150
    75.208     3.900     0.150
    75.208   700.650     0.150
    75.208     3.799     0.150
    75.237   700.449     0.150
    75.237  1274.850     0.150
    75.303   701.824     0.150
    75.313   701.924     0.150
    75.314   701.580     0.150
    75.431   701.650     0.150
    75.431     7.400     0.150
    75.431  1284.650     0.150
    75.482   701.750     0.150
    75.482     4.199     0.150
    75.482   701.760     0.150
    75.528   702.350     0.150
    75.528  2348.551     0.150
    75.536  1576.750     0.150
    75.536   705.680     0.150
    75.558   703.350     0.150
    75.641   703.820     0.150
    75.924   708.551     0.150
    75.936   705.330     0.150
    75.939   705.051     0.150
    75.964   705.631     0.150
    75.969   704.850     0.150
    75.969  1280.949     0.150
    75.969  2347.250     0.150
    76.016   884.250     0.150
    76.016  1290.350     0.150
    76.016   705.150     0.150
    76.026   705.949     0.150
    76.137   705.250     0.150
    76.136   706.199     0.150
    76.144   706.430     0.150
    76.193   707.350     0.150
    76.208  1282.150     0.150
    76.308   707.535     0.150
    76.364   706.949     0.150
    76.421   711.551     0.150
    76.421   711.551     0.150
    76.438   707.090     0.150
    76.438   702.320     0.150
    76.441   705.119     0.150
    76.730   709.080     0.150
    76.749   708.480     0.150
    76.788   714.449     0.150
    76.836   710.588     0.150
    76.836   710.689     0.150
    76.871  1310.150     0.150
    76.871   713.551     0.150
    76.871   711.340     0.150
    76.871   713.551     0.150
    76.924   711.551     0.150
    77.058   712.443     0.150
    77.322  1306.969     0.150
    77.343   712.150     0.150
    77.361   713.676     0.150
    77.431   713.850     0.150
    77.474   712.545     0.150
    77.510   717.949     0.150
    77.510   717.949     0.150
    77.605  1306.746     0.150
    77.669   715.250     0.150
    77.669   715.311     0.150
    77.693   714.449     0.150
    77.759   714.441     0.150
    77.772   714.631     0.150
    77.916   715.830     0.150
    78.054   718.961     0.150
    78.160   716.350     0.150
    78.169   717.697     0.150
    78.169   717.650     0.150
    78.355   889.850     0.150
    78.518   716.969     0.150
    78.561   720.051     0.150
    78.628   720.551     0.150
    78.629  1319.150     0.150
    78.672   721.055     0.150
    78.754   716.520     0.150
    78.796   721.963     0.150
    78.956   723.057     0.150
    78.956   723.051     0.150
    79.002   718.189     0.150
    79.091   723.328     0.150
    79.186   724.051     0.150
    79.195   723.980     0.150
    79.222   724.689     0.150
    79.375   725.150     0.150
    79.380   724.996     0.150
    79.392   723.949     0.150
    79.392   723.850     0.150
    79.392   724.061     0.150
    79.410   723.949     0.150
    79.525   721.529     0.150
    79.625   726.553     0.150
    79.635   912.949     0.150
    79.678   726.250     0.150
    79.742   725.350     0.150
    79.761  1017.551     0.150
    79.761  1842.350     0.150
    79.761   726.090     0.150
    79.795   727.250     0.150
    79.819   725.410     0.150
    79.830   912.250     0.150
    79.830  1328.250     0.150
    79.830  1643.250     0.150
    79.875   727.150     0.150
    79.891   727.025     0.150
    79.903   723.250     0.150
    79.903   916.250     0.150
    79.903  1633.250     0.150
    79.903  1838.051     0.150
    79.959   727.551     0.150
    79.976   727.051     0.150
    80.019   726.949     0.150
    80.085   728.150     0.150
    80.123  1335.801     0.150
    80.123  1667.930     0.150
    80.146   728.250     0.150
    80.135   731.561     0.150
    80.544   729.873     0.150
    80.544   730.150     0.150
    80.544   730.311     0.150
    80.550  1025.250     0.150
    80.550  1337.750     0.150
    80.622   730.350     0.150
    80.628   731.051     0.150
    80.723   731.051     0.150
    80.803   732.430     0.150
    80.866   733.219     0.150
    80.903   731.850     0.150
    80.913   733.730     0.150
    81.013   732.551     0.150
    81.082   733.619     0.150
    81.149   733.539     0.150
    81.172   734.320     0.150
    81.197   737.359     0.150
    81.400   734.211     0.150
    81.604  1339.270     0.150
    81.604    10.061     0.150
    81.629   736.980     0.150
    81.644   735.949     0.150
    81.668   739.551     0.150
    81.719   735.922     0.150
    81.719   735.980     0.150
    81.719   735.439     0.150
    81.730   737.750     0.150
    81.779   936.529     0.150
    81.779  1351.260     0.150
    81.902   737.260     0.150
    81.904   736.631     0.150
    81.904   736.641     0.150
    82.006   739.010     0.150
    82.011  1844.650     0.150
    82.011   738.490     0.150
    82.131   736.051     0.150
    82.149   740.141     0.150
    82.160   740.051     0.150
    82.211   739.250     0.150
    82.251   742.150     0.150
    82.345   740.510     0.150
    82.425   739.350     0.150
    82.478   737.020     0.150
    82.604   744.350     0.150
    82.619   744.850     0.150
    82.655   741.721     0.150
    82.754   743.051     0.150
    82.754   742.686     0.150
    82.743   939.980     0.150
    82.762   742.350     0.150
    82.787   742.051     0.150
    82.910   743.146     0.150
    82.910   743.160     0.150
    82.910   742.750     0.150
    83.030   743.350     0.150
    83.030   744.250     0.150
    83.030  1360.750     0.150
    83.107   745.641     0.150
    83.132   744.350     0.150
    83.257   744.449     0.150
    83.257   745.859     0.150
    83.344   744.551     0.150
    83.404   739.750     0.150
    83.480   746.449     0.150
    83.586   743.750     0.150
    83.669   746.180     0.150
    83.647   743.750     0.150
    83.704   744.250     0.150
    83.884   750.051     0.150
    83.931   744.170     0.150
    83.930   750.949     0.150
    83.947   743.932     0.150
    83.978   744.990     0.150
    83.988   749.891     0.150
    84.031   749.350     0.150
    84.076   752.449     0.150
    84.080   748.650     0.150
    84.080  1369.650     0.150
    84.090   755.150     0.150
    84.130   749.551     0.150
    84.125   744.250     0.150
    84.205   751.039     0.150
    84.257   754.150     0.150
    84.261   753.150     0.150
    84.309   755.650     0.150
    84.353   750.850     0.150
    84.378   750.012     0.150
    84.439   737.641     0.150
    84.491   750.750     0.150
    84.491  1372.551     0.150
    84.535   751.750     0.150
    84.579   756.650     0.150
    84.579   752.688     0.150
    84.773   756.350     0.150
    84.850   755.250     0.150
    85.088   756.650     0.150
    85.088   753.189     0.150
    85.150   756.199     0.150
    85.222   757.350     0.150
    85.289   760.250     0.150
    85.409   755.461     0.150
    85.466   756.410     0.150
    85.467   756.439     0.150
    85.505   762.350     0.150
    85.818   758.025     0.150
    85.901   761.619     0.150
    85.977   756.645     0.150
    85.977   758.561     0.150
    86.329   759.721     0.150
    86.434   760.471     0.150
    86.434   975.609     0.150
    86.434  1749.051     0.150
    86.563   760.236     0.150
    87.175   763.277     0.150
    87.400   765.902     0.150
    87.526   766.641     0.150
    87.716   770.949     0.150
    88.187   772.350     0.150
    88.284   769.561     0.150
    88.284   769.789     0.150
    88.288   774.250     0.150
    88.613   772.199     0.150
    89.313   774.150     0.150
    89.313  1419.283     0.150
    89.698   774.410     0.150
    90.662   781.949     0.150
    90.805   785.430     0.150
    90.911   784.141     0.150
    90.980   785.760     0.150
    91.511   788.051     0.150
    91.861   786.250     0.150
    92.468   792.750     0.150
    92.503   792.949     0.150
    92.509   792.551     0.150
    92.805   791.850     0.150
    92.847   794.051     0.150
    92.970   797.420     0.150
    94.962   799.650     0.150
    94.970   800.859     0.150
    95.104   799.455     0.150
    95.340   800.072     0.150
    95.632   801.652     0.150
    95.689   801.512     0.150
    96.214   810.150     0.150
    96.293   808.109     0.150
    97.003   807.480     0.150
    97.100     9.459     0.150
    97.737   810.650     0.150
    98.552   818.750     0.150
    98.552   818.760     0.150
    99.107   819.789     0.150
   100.906   824.506     0.150
   103.416  1795.324     0.150
   105.291   845.971     0.150
   111.204  8406.348     0.150
   111.215  8370.248     0.150
   111.221  8403.258     0.150
   111.521  8396.949     0.150
   111.521  8399.787     0.150
   111.537  8401.117     0.150
   115.411  1754.750     0.150
   121.063  1125.771     0.150
   121.704  1129.479     0.150
   134.536  1145.926     0.150
   134.536  1364.199     0.150
   138.664  1157.430     0.150
   139.292  1156.971     0.150
   139.999  1160.443     0.150
   139.999  1161.320     0.150
   139.999  1344.070     0.150
   142.007  1162.420     0.150
   145.053  1173.025     0.150
   149.875  1185.600     0.150
   153.472  1188.090     0.150
   156.751  1202.971     0.150
   156.921  1202.631     0.150
   157.168  1204.410     0.150
   157.287  1198.311     0.150
   157.663  1198.211     0.150
   157.990  1200.721     0.150
   158.244  1199.301     0.150
   158.297  1199.131     0.150
   159.012  1201.910     0.150
   162.982  1241.090     0.150
   163.635  1475.250     0.150
   163.635  3086.150     0.150
   163.694  1195.250     0.150
   163.694  1205.449     0.150
     0.684    25.406     0.150
     1.868    31.816     0.150
     2.014    34.447     0.150
    11.279   158.666     0.150
    14.615   207.746     0.150
     0.653    23.623     0.150
     0.653    23.123     0.150
     1.129    20.783     0.150
     1.129    36.344     0.150
     1.373    42.904     0.150
     1.427    23.645     0.150
     1.427    44.414     0.150
     1.423    43.873     0.150
     1.519    47.635     0.150
     3.249    48.312     0.150
     3.953    59.113     0.150
     3.983    57.914     0.150
     3.983    57.730     0.150
     4.032    60.020     0.150
     4.354    65.402     0.150
     4.595    66.305     0.150
     4.595   119.385     0.150
     4.595    66.213     0.150
     4.802   124.596     0.150
     4.932    72.674     0.150
     6.394    91.023     0.150
     6.394    93.025     0.150
    10.806   153.385     0.150
    10.806   153.684     0.150
    11.294   161.850     0.150
    11.296   158.145     0.150
    11.464   156.514     0.150
    11.464   274.314     0.150
    11.464   157.523     0.150
    11.464   157.564     0.150
    12.409   170.748     0.150
    12.866   177.992     0.150
    12.906   177.074     0.150
    12.927   177.664     0.150
    13.262   180.174     0.150
    13.531   187.078     0.150
    13.538   339.924     0.150
    13.600   186.482     0.150
    13.720   189.523     0.150
    13.917   191.098     0.150
    13.966   190.869     0.150
    14.048   190.549     0.150
    15.456   212.105     0.150
    15.488   210.273     0.150
    15.559   212.225     0.150
    15.765   216.492     0.150
    15.765   392.518     0.150
    15.838   239.254     0.150
    15.838  1177.252     0.150
    15.838   239.262     0.150
    15.838  1178.859     0.150
    16.138   220.074     0.150
    16.161   220.812     0.150
    16.413   224.232     0.150
    16.563   223.135     0.150
    16.677   227.121     0.150
    16.769   227.838     0.150
    17.009   235.000     0.150
    23.870  2303.049     0.150
    24.939   318.924     0.150
    25.269   323.484     0.150
    25.269   325.283     0.150
    26.631   334.514     0.150
    26.711   334.225     0.150
    26.711   334.234     0.150
    27.429  2287.652     0.150
    31.217   374.344     0.150
    32.177   383.635     0.150
    32.151  2269.100     0.150
    33.517   393.904     0.150
    34.040   402.395     0.150
    34.242  2261.574     0.150
    34.265   401.523     0.150
    35.845   490.924     0.150
    35.845   509.924     0.150
    35.845   917.123     0.150
    35.845   413.895     0.150
    35.845   413.885     0.150
    36.318   564.324     0.150
    36.318   420.084     0.150
    36.318   564.293     0.150
    36.568   422.793     0.150
    36.689   424.555     0.150
    37.605  2247.123     0.150
    38.090   433.434     0.150
    38.092   433.424     0.150
    38.425   440.725     0.150
    38.425   440.744     0.150
    39.092   443.354     0.150
    39.092   443.283     0.150
    39.092   443.164     0.150
    40.821   456.793     0.150
    40.802   458.613     0.150
    41.309  2231.992     0.150
    41.309   463.154     0.150
    42.018   465.754     0.150
    43.576  3266.084     0.150
    43.582  3266.529     0.150
    43.594  3267.361     0.150
    44.742  3353.604     0.150
    44.755  3344.123     0.150
    44.759  3364.846     0.150
    45.513   494.613     0.150
    45.609   496.324     0.150
    45.609   496.225     0.150
    45.609   496.434     0.150
    45.609   496.154     0.150
    45.852   498.623     0.150
    46.065   499.463     0.150
    46.065   499.904     0.150
    46.207   500.324     0.150
    46.207   500.934     0.150
    46.696   503.924     0.150
    46.696   503.953     0.150
    46.760   505.523     0.150
    47.047   601.098     0.150
    47.116   507.645     0.150
    47.116   507.934     0.150
    47.116   507.523     0.150
    47.134   507.834     0.150
    47.825   512.004     0.150
    50.497   532.504     0.150
    50.849  2786.674     0.150
    50.849   536.824     0.150
    51.003   536.934     0.150
    51.051   539.264     0.150
    51.116   538.324     0.150
    51.116   538.334     0.150
    51.394  3848.447     0.150
    51.523   541.623     0.150
    51.523   538.328     0.150
    51.523   541.604     0.150
    51.515  3846.650     0.150
    51.898   544.523     0.150
    52.638   565.523     0.150
    52.743    10.900     0.150
    52.743    16.100     0.150
    52.898   551.293     0.150
    52.974   556.023     0.150
    52.974     7.660     0.150
    53.309   554.383     0.150
    54.447   561.553     0.150
    54.447   562.984     0.150
    54.780   565.395     0.150
    55.303   567.293     0.150
    55.303   567.994     0.150
    55.430   569.693     0.150
    55.446   570.084     0.150
    55.559  2798.100     0.150
    55.559   569.684     0.150
    56.173   576.244     0.150
    56.173   576.305     0.150
    56.813   578.834     0.150
    56.813   578.994     0.150
    57.215   705.023     0.150
    57.262    15.500     0.150
    58.208    18.000     0.150
    58.783   594.805     0.150
    58.783   594.834     0.150
    59.651   600.824     0.150
    59.651   598.684     0.150
    59.845    15.400     0.150
    63.362   621.123     0.150
    63.490    15.100     0.150
    63.657   625.885     0.150
    63.755    10.400     0.150
    63.904   627.824     0.150
    63.968   628.664     0.150
    63.968   628.793     0.150
    64.389   631.703     0.150
    64.608  2354.488     0.150
    64.637   632.623     0.150
    64.637  1400.023     0.150
    64.821    15.301     0.150
    64.821   665.523     0.150
    65.200   637.084     0.150
    66.029   641.684     0.150
    66.500   645.084     0.150
    67.734   653.264     0.150
    68.159   655.924     0.150
    68.168   655.434     0.150
    68.589   674.023     0.150
    68.589   904.324     0.150
    68.890   660.564     0.150
    68.933   660.475     0.150
    68.917     8.301     0.150
    68.917    14.000     0.150
    68.987   661.043     0.150
    68.990   660.283     0.150
    69.197     3.900     0.150
    69.232  1210.225     0.150
    69.311   663.145     0.150
    69.310   661.824     0.150
    69.310     9.100     0.150
    69.310   913.523     0.150
    69.310  1205.523     0.150
    69.310   661.963     0.150
    69.310   662.033     0.150
    69.680   665.324     0.150
    69.680   665.213     0.150
    70.067   666.953     0.150
    70.099   668.135     0.150
    70.232   669.064     0.150
    70.239   668.604     0.150
    70.243   669.104     0.150
    70.418   669.914     0.150
    70.450   669.984     0.150
    70.540   669.975     0.150
    70.540   669.975     0.150
    70.540   929.654     0.150
    70.540  1692.523     0.150
    70.540   669.924     0.150
    70.552   670.764     0.150
    70.600   671.033     0.150
    70.936   673.363     0.150
    70.970   673.305     0.150
    70.914   673.363     0.150
    71.116   674.193     0.150
    71.212   674.664     0.150
    71.834   679.014     0.150
    71.877   678.574     0.150
    72.063   680.123     0.150
    72.368   682.014     0.150
    72.357   682.242     0.150
    72.357   682.225     0.150
    72.357   682.234     0.150
    72.357   682.283     0.150
    72.757   683.984     0.150
    72.822   684.494     0.150
    72.995   685.623     0.150
    73.025   686.014     0.150
    73.101   684.123     0.150
    73.187   686.463     0.150
    73.240   686.914     0.150
    73.293   687.533     0.150
    73.330   687.225     0.150
    73.371   687.424     0.150
    73.371   687.734     0.150
    73.542   688.494     0.150
    73.621   690.484     0.150
    73.710   689.232     0.150
    73.710   689.225     0.150
    73.710   705.924     0.150
    73.710  1255.924     0.150
    73.743   689.914     0.150
    74.188   692.254     0.150
    74.188   699.543     0.150
    74.270   691.824     0.150
    74.270   691.783     0.150
    74.270   691.834     0.150
    74.296   693.135     0.150
    74.333   693.344     0.150
    74.343   693.463     0.150
    74.494   694.414     0.150
    74.551   694.725     0.150
    74.573   694.814     0.150
    74.588   695.023     0.150
    74.631   695.123     0.150
    74.631   710.523     0.150
    74.631   695.033     0.150
    74.754   696.225     0.150
    74.797   696.324     0.150
    74.797   696.334     0.150
    74.844   696.732     0.150
    74.844   696.725     0.150
    74.987   696.854     0.150
    75.010    12.100     0.150
    75.010  1275.225     0.150
    75.084   698.023     0.150
    75.097   697.824     0.150
    75.097   711.324     0.150
    75.097   697.725     0.150
    75.106   698.123     0.150
    75.101   699.984     0.150
    75.222   698.824     0.150
    75.222   698.885     0.150
    75.351   699.324     0.150
    75.351   699.334     0.150
    75.401   699.225     0.150
    75.401   699.424     0.150
    75.792   701.824     0.150
    75.826   702.023     0.150
    75.847   702.123     0.150
    75.847   701.924     0.150
    75.847   702.213     0.150
    75.911   702.824     0.150
    75.911   702.924     0.150
    76.055   704.324     0.150
    76.100   701.363     0.150
    76.202  2331.346     0.150
    76.255   704.324     0.150
    76.267   704.863     0.150
    76.267   704.924     0.150
    76.364   704.924     0.150
    76.364   704.982     0.150
    76.374   705.074     0.150
    76.727   707.225     0.150
    76.746   707.404     0.150
    76.799   707.924     0.150
    76.870   706.824     0.150
    76.880   706.850     0.150
    77.159   708.453     0.150
    77.222   709.734     0.150
    77.291   710.824     0.150
    77.291   710.914     0.150
    77.379   711.225     0.150
    77.509   711.523     0.150
    77.524   711.684     0.150
    77.523   711.324     0.150
    77.667   712.885     0.150
    77.948   714.783     0.150
    77.978   712.924     0.150
    78.008   714.123     0.150
    78.467   716.725     0.150
    78.573   717.584     0.150
    78.771   718.824     0.150
    78.861   719.793     0.150
    79.009   719.873     0.150
    79.212   720.523     0.150
    79.231   721.225     0.150
    79.310   721.924     0.150
    79.380   721.664     0.150
    79.491   722.734     0.150
    79.512   722.924     0.150
    79.591   722.725     0.150
    79.591   722.783     0.150
    79.619   723.123     0.150
    79.619   723.203     0.150
    79.679  1848.824     0.150
    79.687   722.453     0.150
    79.704   723.225     0.150
    79.728   724.057     0.150
    79.784   723.623     0.150
    79.802   724.225     0.150
    79.831   723.924     0.150
    79.915   724.623     0.150
    79.967   724.523     0.150
    80.296  1836.123     0.150
    80.420   727.188     0.150
    80.420   727.225     0.150
    80.420   727.385     0.150
    80.438   727.225     0.150
    80.525   728.023     0.150
    80.614   727.684     0.150
    80.678   728.752     0.150
    80.724   729.613     0.150
    80.724   729.664     0.150
    80.850   729.424     0.150
    80.898   728.408     0.150
    81.225   731.395     0.150
    81.225   731.434     0.150
    81.495   731.693     0.150
    81.495   732.193     0.150
    81.521   735.123     0.150
    81.702   734.494     0.150
    81.943   735.225     0.150
    81.997   732.523     0.150
    82.066   745.854     0.150
    82.066  1349.373     0.150
    82.294   737.123     0.150
    82.662   739.623     0.150
    82.662   739.834     0.150
    82.747   739.023     0.150
    82.774   739.523     0.150
    82.774   739.635     0.150
    82.774   739.523     0.150
    82.846   740.738     0.150
    83.043   738.324     0.150
    83.016   741.023     0.150
    82.939   740.234     0.150
    83.083   741.725     0.150
    83.276   742.604     0.150
    83.214   740.484     0.150
    83.510   744.254     0.150
    83.748   744.861     0.150
    83.914   746.725     0.150
    84.062   747.055     0.150
    84.129   747.023     0.150
    84.129   747.023     0.150
    84.368   748.574     0.150
    84.502   749.064     0.150
    84.544   749.324     0.150
    84.618   750.113     0.150
    84.765   751.004     0.150
    84.829   750.623     0.150
    85.956   756.713     0.150
    87.166   762.924     0.150
    88.014   766.113     0.150
    88.873   770.070     0.150
    88.953   770.613     0.150
    88.954  2021.824     0.150
    90.250   777.924     0.150
    90.466   777.344     0.150
    91.448   781.725     0.150
    91.448   781.664     0.150
    93.454   790.963     0.150
    93.467   790.533     0.150
    94.597   795.555     0.150
    94.620   796.264     0.150
    96.394   804.725     0.150
    96.825   806.773     0.150
    96.827   806.373     0.150
    98.789   815.725     0.150
    98.789   815.734     0.150
    98.789   815.814     0.150
   110.102  1106.742     0.150
   111.690  8372.412     0.150
   111.702  8374.357     0.150
   111.707  8373.936     0.150
   134.589  1150.049     0.150
   138.647  1162.254     0.150
   138.647  1162.293     0.150
   139.767  1156.305     0.150
   141.588  1159.904     0.150
   142.544  1164.193     0.150
   144.940  1170.043     0.150
   147.342  1177.424     0.150
   149.633  1185.264     0.150
   153.259  1186.174     0.150
   160.640  1237.941     0.150
   160.640  1191.924     0.150
     0.543    21.527     0.150
     0.543    21.148     0.150
     0.544    21.328     0.150
     1.396    39.430     0.150
     3.022    45.070     0.150
     4.173    62.469     0.150
     4.216    64.539     0.150
     4.437    63.793     0.150
     4.707    70.488     0.150
     5.682    82.387     0.150
     6.536    94.527     0.150
     6.874   100.344     0.150
     8.363   121.129     0.150
     8.453   120.633     0.150
     8.634   123.375     0.150
     8.913   127.629     0.150
     9.129   129.484     0.150
    11.497   277.031     0.150
    12.021   167.117     0.150
    13.222   187.930     0.150
    13.749   191.059     0.150
    14.011   196.590     0.150
    15.165   212.898     0.150
    43.734  3298.840     0.150
    43.740  3299.289     0.150
    43.752  3299.453     0.150
    44.896  3385.559     0.150
    44.909  3386.668     0.150
    44.913  3386.895     0.150
   111.207  8360.547     0.150
   111.219  8361.852     0.150
   111.224  8360.766     0.150
     0.513    21.434     0.150
     0.519    19.570     0.150
     0.976    27.891     0.150
     0.976    28.352     0.150
     0.976    17.594     0.150
     1.229    20.523     0.150
     1.258    40.141     0.150
     1.258    22.699     0.150
     1.743    53.070     0.150
     1.967    32.590     0.150
     1.967    56.891     0.150
     1.966    57.789     0.150
     3.004    44.453     0.150
     3.760    54.445     0.150
     3.782    56.449     0.150
     3.971    59.430     0.150
     4.131    60.844     0.150
     4.388    62.984     0.150
     4.526    66.461     0.150
     4.728    69.262     0.150
     4.781    70.039     0.150
     5.392    78.891     0.150
     5.699    82.766     0.150
     5.852    85.613     0.150
     5.909    85.738     0.150
     6.383    91.668     0.150
     7.229   103.609     0.150
     7.353   105.516     0.150
     7.863   111.352     0.150
     8.051   114.816     0.150
     8.082   114.160     0.150
    10.666   150.258     0.150
    10.698   149.445     0.150
    10.998   154.586     0.150
    11.108   156.918     0.150
    11.219   156.891     0.150
    11.219   156.891     0.150
    12.235   171.062     0.150
    12.844   179.227     0.150
    13.256   183.211     0.150
    13.887   193.801     0.150
    24.535   315.289     0.150
    24.535   315.270     0.150
    25.105   320.000     0.150
    26.423   335.590     0.150
    27.018   337.648     0.150
    31.032   376.789     0.150
    33.744   396.488     0.150
    35.846   746.488     0.150
    36.642   424.691     0.150
    43.776  3263.215     0.150
    43.782  3263.664     0.150
    43.794  3261.031     0.150
    44.940  3353.941     0.150
    44.953  3355.117     0.150
    44.957  3375.359     0.150
    45.930   499.191     0.150
    45.930   499.301     0.150
    45.981   499.191     0.150
    46.117   500.469     0.150
    46.154   500.738     0.150
    46.896   505.789     0.150
    46.896   505.941     0.150
    47.443   513.711     0.150
    48.573   518.191     0.150
    48.661   521.090     0.150
    50.813   536.551     0.150
    50.971   537.461     0.150
    51.173   539.020     0.150
    54.007   560.859     0.150
    55.567   570.941     0.150
    56.123   573.590     0.150
    63.939   628.391     0.150
    63.939   628.590     0.150
    64.073     9.602     0.150
    64.652   633.879     0.150
    65.133    15.301     0.150
    66.181   642.891     0.150
    66.287   643.879     0.150
    69.144   662.461     0.150
    69.234   662.191     0.150
    69.427   915.891     0.150
    70.173   669.738     0.150
    70.327   668.949     0.150
    70.356   670.191     0.150
    70.502   670.918     0.150
    70.629   824.391     0.150
    70.629   925.391     0.150
    70.629  1220.289     0.150
    70.629  1488.289     0.150
    70.629  1687.090     0.150
    70.629   669.891     0.150
    70.629   669.891     0.150
    70.629   669.891     0.150
    70.629   692.809     0.150
    70.629   824.469     0.150
    70.629   925.418     0.150
    70.629  1220.289     0.150
    70.629  1488.352     0.150
    70.629  1687.109     0.150
    70.661   671.750     0.150
    70.809   672.871     0.150
    70.851   673.039     0.150
    71.224   675.320     0.150
    71.167   675.379     0.150
    71.370   676.211     0.150
    72.180   682.980     0.150
    72.606   684.289     0.150
    73.231   683.789     0.150
    73.481   688.738     0.150
    73.537   688.461     0.150
    73.746   689.988     0.150
    73.857   692.309     0.150
    73.905   690.512     0.150
    74.227   693.000     0.150
    74.227   692.809     0.150
    74.326   693.699     0.150
    74.357   692.691     0.150
    74.357   692.801     0.150
    74.569   695.148     0.150
    74.581   695.230     0.150
    74.635   696.191     0.150
    74.845   697.090     0.150
    74.845   697.051     0.150
    74.854   696.391     0.150
    75.134   698.391     0.150
    75.268     4.902     0.150
    75.453   694.883     0.150
    75.453   694.891     0.150
    75.858   702.590     0.150
    75.895   702.891     0.150
    75.895   702.898     0.150
    75.948   703.488     0.150
    75.948   703.398     0.150
    76.114   705.191     0.150
    76.135   704.031     0.150
    76.337   705.898     0.150
    76.850   708.840     0.150
    76.850   708.789     0.150
    77.261   711.316     0.150
    77.388   711.953     0.150
    77.413   712.211     0.150
    77.620   713.562     0.150
    78.002   714.730     0.150
    78.252   714.496     0.150
    78.266   716.930     0.150
    79.246   720.680     0.150
    79.300   721.691     0.150
    79.318   720.680     0.150
    79.318   720.691     0.150
    79.341   720.270     0.150
    79.441   721.129     0.150
    79.659   723.891     0.150
    79.785   725.289     0.150
    79.874   724.891     0.150
    79.924   724.891     0.150
    80.884   731.711     0.150
    81.737   734.309     0.150
    81.838   735.590     0.150
    82.887   741.941     0.150
    83.382    11.492     0.150
    84.233   747.301     0.150
    86.484   761.430     0.150
    89.602   774.250     0.150
     0.643    23.410     0.150
     0.644    23.602     0.150
     1.220    21.391     0.150
     1.494    48.352     0.150
     2.936    43.410     0.150
     3.716    53.930     0.150
     4.197    63.488     0.150
     4.360    62.629     0.150
     4.360    69.422     0.150
     5.743    83.531     0.150
     6.132    88.711     0.150
     6.963   100.551     0.150
     7.844   111.316     0.150
     9.524   134.035     0.150
    10.824   151.301     0.150
    11.236   159.301     0.150
    11.281   159.613     0.150
    11.447   274.828     0.150
    12.979   182.211     0.150
    13.259   185.551     0.150
    13.861   196.590     0.150
    13.821   195.570     0.150
    13.964   195.613     0.150
    15.341  1136.000     0.150
    15.341  1133.789     0.150
    15.459   216.199     0.150
    26.567   332.879     0.150
    26.788   335.660     0.150
    33.297   390.961     0.150
    40.243   453.031     0.150
    43.815  3284.027     0.150
    43.821  3284.469     0.150
    43.833  3285.387     0.150
    44.976  3382.785     0.150
    44.990  3389.867     0.150
    44.994  3384.129     0.150
    46.247   509.129     0.150
    46.138   501.621     0.150
    46.497   505.391     0.150
    48.978   525.160     0.150
    53.313    10.301     0.150
    53.860   560.070     0.150
    55.740   576.910     0.150
    55.829   575.801     0.150
    56.372   581.320     0.150
    60.405   607.711     0.150
    64.097   630.609     0.150
    65.390     8.102     0.150
    66.550   646.500     0.150
    66.758     7.203     0.150
    74.045   690.871     0.150
    74.215   694.898     0.150
    74.480   696.020     0.150
    74.559   695.172     0.150
    75.531     8.398     0.150
   111.121  8360.738     0.150
   111.133  8343.262     0.150
   111.138  8361.738     0.150
     0.764     6.070     0.150
     0.764    14.875     0.150
     0.705    21.430     0.150
     0.984    19.641     0.150
     1.030    20.918     0.150
     1.023    20.781     0.150
     1.818    31.934     0.150
     1.776    33.211     0.150
     1.776    58.199     0.150
     2.159    36.211     0.150
     1.899    35.191     0.150
     1.970    36.508     0.150
     2.935    50.250     0.150
     2.979    50.469     0.150
     2.979    50.969     0.150
     2.979    86.770     0.150
     3.080    51.848     0.150
     3.078    52.109     0.150
     3.094    52.230     0.150
     3.091    52.469     0.150
     3.106    52.488     0.150
     3.125    52.719     0.150
     3.151    53.230     0.150
     3.464    56.871     0.150
     3.464    56.668     0.150
     3.464    56.816     0.150
     3.690    60.230     0.150
     3.725    60.871     0.150
     4.394    70.270     0.150
     4.476    71.348     0.150
     4.501    71.469     0.150
     4.533    72.129     0.150
     5.173    78.059     0.150
     5.560    83.328     0.150
     5.637    87.469     0.150
     6.593    97.719     0.150
     6.837    99.281     0.150
     7.161   104.371     0.150
     7.929   114.609     0.150
     8.301   119.570     0.150
     8.391   124.168     0.150
     8.391   124.180     0.150
     9.094   129.988     0.150
     9.310   132.758     0.150
     9.426   134.590     0.150
     9.736   137.578     0.150
    10.263   146.789     0.150
     9.936   145.090     0.150
    10.215   149.258     0.150
    10.651   151.543     0.150
    11.307   161.344     0.150
    11.508   162.828     0.150
    11.717   165.828     0.150
    12.226   174.730     0.150
    12.331   173.668     0.150
    12.331   173.660     0.150
    12.720   180.207     0.150
    12.441   178.660     0.150
    13.275   185.309     0.150
    13.994   197.348     0.150
    14.500   204.398     0.150
    14.743   204.871     0.150
    14.763   209.289     0.150
    14.836   210.109     0.150
    15.003   210.168     0.150
    16.672  1208.730     0.150
    16.673  1209.301     0.150
    17.290   423.344     0.150
    18.673   253.984     0.150
    20.809   279.641     0.150
    23.217   312.699     0.150
    23.722   314.539     0.150
    24.306   316.359     0.150
    24.893   320.969     0.150
    27.559   346.539     0.150
    29.966   369.770     0.150
    29.966   369.801     0.150
    32.077   383.559     0.150
    33.563   396.418     0.150
    33.684   716.871     0.150
    34.769   410.531     0.150
    34.910   736.070     0.150
    35.613   889.070     0.150
    35.613   414.180     0.150
    37.415   431.898     0.150
    38.537   572.496     0.150
    41.648   464.598     0.150
    41.648   464.871     0.150
    41.445   465.539     0.150
    41.902   468.941     0.150
    42.032   470.660     0.150
    42.212   471.891     0.150
    42.677   473.469     0.150
    42.615  3184.137     0.150
    42.621  3182.430     0.150
    42.633  3184.137     0.150
    43.782  3267.926     0.150
    43.796  3270.766     0.150
    43.799  3270.395     0.150
    44.465   488.758     0.150
    44.849   493.590     0.150
    44.849   493.680     0.150
    44.849   493.480     0.150
    44.849   493.520     0.150
    44.995   496.391     0.150
    46.656   505.961     0.150
    46.656   505.898     0.150
    46.656   505.980     0.150
    46.656   505.969     0.150
    46.844   506.641     0.150
    46.853   507.469     0.150
    47.737   834.145     0.150
    47.997   516.648     0.150
    47.997   516.680     0.150
    47.997   516.680     0.150
    48.692   521.820     0.150
    48.870   524.160     0.150
    49.800   531.109     0.150
    50.188   534.379     0.150
    51.025   539.508     0.150
    50.873   539.961     0.150
    50.873   540.031     0.150
    51.766   544.469     0.150
    51.766   544.520     0.150
    51.796   546.078     0.150
    51.988   547.430     0.150
    51.988   547.508     0.150
    51.881  3871.828     0.150
    52.232   549.328     0.150
    52.270    14.500     0.150
    54.125   563.391     0.150
    54.111   563.191     0.150
    54.450   565.840     0.150
    55.370   569.859     0.150
    55.823   573.480     0.150
    56.089   573.949     0.150
    56.968   583.570     0.150
    56.968   580.660     0.150
    57.281   583.680     0.150
    57.281   583.781     0.150
    57.754   591.570     0.150
    57.754   714.770     0.150
    57.754  1069.668     0.150
    59.089   597.848     0.150
    59.237   599.461     0.150
    59.210   601.570     0.150
    59.583   600.059     0.150
    62.808   621.680     0.150
    62.883    14.500     0.150
    63.163   623.898     0.150
    63.236   626.758     0.150
    63.610   628.059     0.150
    63.941   630.109     0.150
    63.941   630.629     0.150
    64.264   632.469     0.150
    64.264   632.539     0.150
    64.528   633.770     0.150
    64.375     8.898     0.150
    64.685   669.195     0.150
    64.731   630.070     0.150
    65.837   643.121     0.150
    65.817   642.570     0.150
    65.928   643.281     0.150
    67.677   654.059     0.150
    67.708   653.641     0.150
    68.903   662.168     0.150
    68.903   662.258     0.150
    68.809   661.469     0.150
    68.809   661.539     0.150
    68.849     3.902     0.150
    69.692   665.891     0.150
    69.726   917.371     0.150
    69.726   666.168     0.150
    69.957   667.770     0.150
    69.957   667.809     0.150
    70.000   668.871     0.150
    70.000   668.969     0.150
    70.138   669.770     0.150
    70.138   669.801     0.150
    70.384   671.070     0.150
    70.384   671.121     0.150
    70.452   671.570     0.150
    70.452   671.598     0.150
    70.531   672.168     0.150
    70.531   672.180     0.150
    70.887   674.270     0.150
    70.887   674.371     0.150
    70.833   674.371     0.150
    70.833   674.430     0.150
    71.034   675.031     0.150
    71.034   675.031     0.150
    71.034   697.301     0.150
    71.034   931.398     0.150
    71.034  1224.129     0.150
    71.034  1491.668     0.150
    71.034  1696.371     0.150
    71.034   674.969     0.150
    71.034   697.270     0.150
    71.034   831.469     0.150
    71.034   931.371     0.150
    71.034  1224.070     0.150
    71.033   675.371     0.150
    71.033   675.391     0.150
    71.577   678.371     0.150
    71.577   678.359     0.150
    71.544   678.461     0.150
    71.673   678.441     0.150
    71.817   680.941     0.150
    71.949   680.348     0.150
    71.884   681.551     0.150
    72.298   684.180     0.150
    72.298   684.129     0.150
    72.298   684.051     0.150
    72.713   685.871     0.150
    73.031   687.660     0.150
    73.219   688.270     0.150
    73.219   688.340     0.150
    73.320   689.398     0.150
    73.320   689.359     0.150
    73.548   689.699     0.150
    73.668   691.559     0.150
    73.618   692.098     0.150
    73.505   691.570     0.150
    73.940   693.180     0.150
    74.332   694.469     0.150
    74.332   709.469     0.150
    74.326   694.770     0.150
    74.326   694.789     0.150
    74.330   694.668     0.150
    74.330   694.711     0.150
    74.575   696.629     0.150
    74.737   696.590     0.150
    74.745   696.699     0.150
    74.745   696.270     0.150
    74.745   696.629     0.150
    74.745   696.441     0.150
    74.745    19.297     0.150
    74.803   697.781     0.150
    74.803   697.719     0.150
    74.930   698.781     0.150
    75.148   700.469     0.150
    75.155   700.121     0.150
    75.183   699.668     0.150
    75.228   700.469     0.150
    75.228   700.480     0.150
    75.391   701.871     0.150
    75.525   701.668     0.150
    75.525   701.699     0.150
    75.550   701.949     0.150
    75.675   703.168     0.150
    75.675   703.109     0.150
    75.708   703.469     0.150
    75.889   702.668     0.150
    75.929   704.770     0.150
    75.984   704.371     0.150
    75.984   704.719     0.150
    75.894   704.730     0.150
    75.894   704.648     0.150
    75.902   698.730     0.150
    76.182   705.270     0.150
    76.341   706.371     0.150
    76.439   707.770     0.150
    76.489   707.836     0.150
    76.489   707.770     0.150
    76.530   708.320     0.150
    76.682   708.680     0.150
    76.807   708.070     0.150
    76.807   708.070     0.150
    76.821   709.531     0.150
    77.049   710.668     0.150
    77.350   711.668     0.150
    77.385   713.488     0.150
    77.385   713.469     0.150
    77.419   711.469     0.150
    77.463   711.910     0.150
    77.604   713.520     0.150
    77.836   715.180     0.150
    77.890   715.668     0.150
    78.034   716.148     0.150
    78.305   718.297     0.150
    78.305   718.281     0.150
    78.364   717.051     0.150
    78.487   717.668     0.150
    78.571   720.328     0.150
    79.067   721.480     0.150
    78.922   720.898     0.150
    79.185   722.879     0.150
    79.475   724.730     0.150
    79.711   725.320     0.150
    79.706   724.969     0.150
    79.726   725.570     0.150
    79.864  1013.871     0.150
    79.864  1843.668     0.150
    80.031   727.969     0.150
    80.121   728.070     0.150
    80.121   728.148     0.150
    80.143   726.871     0.150
    80.137   727.770     0.150
    80.137   727.730     0.150
    80.256   728.371     0.150
    80.309   728.270     0.150
    80.462   728.871     0.150
    80.645  1644.270     0.150
    80.605   730.719     0.150
    80.675   730.930     0.150
    80.675   731.398     0.150
    81.008   732.168     0.150
    81.042   733.648     0.150
    81.436   733.918     0.150
    81.436   734.039     0.150
    84.004   748.641     0.150
    84.082   748.551     0.150
    84.559   752.578     0.150
    84.582   751.281     0.150
    84.697   751.500     0.150
    84.777   752.828     0.150
    84.885   752.781     0.150
    85.118   755.160     0.150
    85.629   755.270     0.150
    85.756   755.570     0.150
    86.566   761.078     0.150
    86.383   761.711     0.150
    87.017   763.520     0.150
    92.505   789.570     0.150
    92.505   789.539     0.150
    95.862   805.520     0.150
    97.369   818.062     0.150
    98.989   819.020     0.150
   112.134  8394.230     0.150
   112.146  8393.008     0.150
   112.151  8393.941     0.150
   155.873  1220.070     0.150
   155.873  1220.109     0.150
     1.282    21.977     0.150
     2.013    31.367     0.150
     4.361    65.238     0.150
     6.925    99.656     0.150
     7.027   101.699     0.150
     7.287   101.867     0.150
     7.861   114.137     0.150
    11.463   275.953     0.150
    15.293  1128.789     0.150
    15.293  1133.809     0.150
    15.940   218.305     0.150
    17.725   242.930     0.150
    23.932   309.387     0.150
    24.861   318.020     0.150
    27.345   341.367     0.150
    29.649   361.148     0.150
    29.656   361.688     0.150
    30.346   368.180     0.150
    30.530   369.348     0.150
    31.480   378.066     0.150
    31.708   379.738     0.150
    43.828  3292.789     0.150
    43.834  3295.629     0.150
    43.846  3292.223     0.150
    44.988  3383.664     0.150
    45.002  3384.801     0.150
    45.006  3385.938     0.150
    47.202   510.777     0.150
    50.761  3817.520     0.150
    55.862   575.613     0.150
    55.862   574.590     0.150
    63.967   630.688     0.150
    64.134   632.527     0.150
    64.842   638.727     0.150
    65.112   638.539     0.150
    74.095   699.328     0.150
    74.202   699.930     0.150
    74.532   703.328     0.150
    74.541   703.129     0.150
    74.546   703.129     0.150
    74.567   703.328     0.150
    74.573   703.227     0.150
    74.598   696.059     0.150
    74.749   703.129     0.150
    75.049   704.227     0.150
    75.445   707.129     0.150
    75.596   706.129     0.150
    75.596     6.000     0.150
    76.144   710.430     0.150
    77.202   717.129     0.150
    78.514   724.629     0.150
    79.918   732.930     0.150
    85.213   760.129     0.150
   111.057  8341.109     0.150
   111.068  8341.938     0.150
   111.073  8341.906     0.150
     2.054    33.773     0.150
     4.166    60.465     0.150
     4.340   134.289     0.150
    11.455   274.652     0.150
    15.278  1155.246     0.150
    15.278  1155.344     0.150
    17.716   243.305     0.150
    24.641   317.484     0.150
    24.846   319.535     0.150
    25.766   327.684     0.150
    26.170   330.586     0.150
    30.366   368.953     0.150
    31.677   382.074     0.150
    33.430   396.855     0.150
    33.430   396.164     0.150
    33.658   400.645     0.150
    36.987   426.824     0.150
    37.011   426.633     0.150
    40.169   452.996     0.150
    40.845   457.516     0.150
    40.845   457.973     0.150
    41.133   460.766     0.150
    41.751   466.156     0.150
    42.888   477.273     0.150
    43.841  3299.781     0.150
    43.847  3300.156     0.150
    43.859  3301.070     0.150
    45.001  3388.508     0.150
    45.015  3388.113     0.150
    45.019  3389.789     0.150
    46.261   508.285     0.150
    46.351   503.133     0.150
    50.748  3825.387     0.150
    55.178   577.285     0.150
    55.417   631.129     0.150
    55.417   572.336     0.150
    55.778   577.746     0.150
    55.868   579.516     0.150
    58.780   603.895     0.150
    59.159   601.664     0.150
    59.719   603.320     0.150
    60.688   612.445     0.150
    62.370   624.125     0.150
    62.716   626.055     0.150
    62.999   628.145     0.150
    63.964   631.016     0.150
    64.130   633.594     0.150
    64.130   633.594     0.150
    64.130   633.672     0.150
    64.540   635.996     0.150
    65.399   648.766     0.150
    70.721   672.996     0.150
    77.626   715.895     0.150
    78.332   719.164     0.150
    81.322   736.664     0.150
    83.297   743.754     0.150
    85.818   757.773     0.150
   111.045  8343.938     0.150
   111.056  8342.648     0.150
   111.061  8344.289     0.150
   153.620  1197.820     0.150
     1.111    20.152     0.150
     3.367    51.543     0.150
     4.092    60.543     0.150
     6.291    89.805     0.150
    11.516   161.516     0.150
    13.365   184.312     0.150
    14.927   210.242     0.150
    70.786   671.113     0.150
     0.693    13.559     0.150
     1.045    33.508     0.150
     4.129    61.988     0.150
     5.477   159.812     0.150
     5.954    88.391     0.150
    15.480   217.938     0.150
    42.698  3183.449     0.150
    42.704  3182.883     0.150
    42.716  3179.477     0.150
    43.865  3271.086     0.150
    43.879  3269.902     0.150
    43.883  3269.766     0.150
    50.230   531.520     0.150
     0.400     9.438     0.150
     0.400     9.430     0.150
     0.664    20.875     0.150
     0.664    13.336     0.150
     1.090    31.438     0.150
     1.219    20.461     0.150
     2.207    61.133     0.150
     2.207    34.070     0.150
     2.944    77.609     0.150
     3.908    58.203     0.150
     3.941    57.219     0.150
     3.883    58.812     0.150
     4.386    65.633     0.150
     4.551    65.500     0.150
     5.167    75.617     0.150
     6.399    92.828     0.150
     7.204   100.438     0.150
     7.872   112.062     0.150
     9.923   140.633     0.150
    10.290   143.938     0.150
    10.837   153.336     0.150
    11.249   159.531     0.150
    12.474   174.250     0.150
    12.838   177.359     0.150
    13.504   186.883     0.150
    13.871   190.711     0.150
    13.871   190.508     0.150
    13.918   190.883     0.150
    13.982   193.336     0.150
    15.409   215.281     0.150
    15.440   211.469     0.150
    15.812   381.672     0.150
    15.812  1177.633     0.150
    15.812  1177.578     0.150
    15.786   218.547     0.150
    16.182   224.695     0.150
    16.305   226.703     0.150
    16.629   227.164     0.150
    16.722   227.844     0.150
    22.119   288.789     0.150
    23.828   556.047     0.150
    24.450   573.031     0.150
    24.952   532.734     0.150
    24.952   317.805     0.150
    24.952   533.625     0.150
    25.398   323.016     0.150
    26.598   334.102     0.150
    29.245   358.812     0.150
    29.245   360.805     0.150
    30.646   370.164     0.150
    30.942   375.406     0.150
    32.140   382.531     0.150
    32.991   391.156     0.150
    33.807   400.633     0.150
    34.022   403.031     0.150
    34.022   403.055     0.150
    34.219  2260.484     0.150
    35.533   745.938     0.150
    35.835   494.438     0.150
    35.835   894.133     0.150
    35.835   911.836     0.150
    35.835  1023.633     0.150
    35.835   412.945     0.150
    36.207   418.133     0.150
    36.207   418.164     0.150
    36.541   421.383     0.150
    36.571   420.211     0.150
    38.107   434.984     0.150
    38.403   437.328     0.150
    39.111   443.531     0.150
    39.698   447.805     0.150
    40.774   456.125     0.150
    40.789   457.914     0.150
    40.989   456.773     0.150
    41.973   464.023     0.150
    43.085   475.305     0.150
    43.620  3270.578     0.150
    43.626  3258.219     0.150
    43.638  3259.133     0.150
    44.007   481.453     0.150
    44.007   481.305     0.150
    44.007   588.695     0.150
    44.786  3359.031     0.150
    44.800  3360.133     0.150
    44.804  3358.672     0.150
    45.077   490.422     0.150
    45.466   493.328     0.150
    45.630   496.195     0.150
    45.630   496.164     0.150
    45.668   495.836     0.150
    45.830   497.688     0.150
    45.956   497.406     0.150
    46.023   498.734     0.150
    46.023   499.078     0.150
    46.160   499.508     0.150
    46.669   503.031     0.150
    47.069   505.852     0.150
    47.069   507.383     0.150
    47.092   597.508     0.150
    47.281   507.523     0.150
    47.281   507.445     0.150
    47.755   512.266     0.150
    47.797   511.586     0.150
    47.846    16.602     0.150
    48.364   517.312     0.150
    48.950   521.297     0.150
    49.326   526.125     0.150
    50.193   962.336     0.150
    50.466   531.906     0.150
    50.863   536.305     0.150
    50.863   612.805     0.150
    50.883   538.273     0.150
    50.956   536.203     0.150
    50.919   538.844     0.150
    51.087   537.664     0.150
    51.087   538.188     0.150
    51.536   540.977     0.150
    51.659   541.133     0.150
    51.646   543.984     0.150
    51.646   979.836     0.150
    52.095   546.383     0.150
    52.629   545.336     0.150
    52.746    16.695     0.150
    52.851   550.531     0.150
    53.299  1006.234     0.150
    53.711   556.297     0.150
    53.969   557.992     0.150
    54.456   561.953     0.150
    54.442   561.977     0.150
    54.442   562.336     0.150
    54.775   564.992     0.150
    54.775   628.008     0.150
    55.262   567.195     0.150
    55.262   567.367     0.150
    55.391   568.672     0.150
    55.452   569.227     0.150
    56.126   574.656     0.150
    56.774   578.094     0.150
    57.264    16.797     0.150
    57.712    15.500     0.150
    57.810   585.312     0.150
    58.210    12.602     0.150
    59.042   594.625     0.150
    59.121  2365.141     0.150
    59.858    16.000     0.150
    61.475    16.500     0.150
    63.309   622.906     0.150
    63.500    16.398     0.150
    63.617   624.938     0.150
    63.760     9.500     0.150
    63.861   626.664     0.150
    63.860   626.938     0.150
    64.181   628.023     0.150
    64.374   631.164     0.150
    64.374  1146.242     0.150
    64.586   632.156     0.150
    64.607   869.633     0.150
    64.822    10.203     0.150
    64.822    16.203     0.150
    65.156   635.641     0.150
    65.694   639.492     0.150
    65.906  1161.609     0.150
    65.906  2352.586     0.150
    65.906   640.234     0.150
    66.013   641.164     0.150
    66.013   641.125     0.150
    66.205    17.195     0.150
    67.688   652.656     0.150
    68.113   654.734     0.150
    68.552   905.438     0.150
    68.552  1647.234     0.150
    68.887   660.078     0.150
    68.873   659.992     0.150
    68.921     8.102     0.150
    68.921    13.602     0.150
    69.273   915.633     0.150
    69.273  1205.031     0.150
    69.273   661.102     0.150
    69.633   664.875     0.150
    69.897   666.172     0.150
    70.051   666.305     0.150
    70.082   667.633     0.150
    70.185   668.977     0.150
    70.227   668.375     0.150
    70.404   669.734     0.150
    70.398   669.414     0.150
    70.501   669.766     0.150
    70.501   669.766     0.150
    70.501   928.445     0.150
    70.501  1691.164     0.150
    70.501   669.734     0.150
    70.536   670.273     0.150
    70.582   670.438     0.150
    70.953   672.805     0.150
    70.897   672.867     0.150
    71.032   673.438     0.150
    71.099   673.586     0.150
    71.128   672.031     0.150
    71.128   672.016     0.150
    71.795   677.828     0.150
    72.019   679.438     0.150
    72.140   680.297     0.150
    72.324   681.328     0.150
    72.339   681.719     0.150
    72.339   681.695     0.150
    72.532   682.477     0.150
    72.713   683.344     0.150
    72.943  1507.633     0.150
    73.142   685.773     0.150
    73.220   686.297     0.150
    73.329   687.203     0.150
    73.310   686.328     0.150
    73.310   686.484     0.150
    73.497   686.938     0.150
    73.497   686.945     0.150
    73.497   687.773     0.150
    73.600   689.883     0.150
    73.667   688.438     0.150
    73.667  1255.734     0.150
    73.700   689.328     0.150
    73.974   690.594     0.150
    74.050    16.398     0.150
    74.145   691.664     0.150
    74.223   690.938     0.150
    74.231   691.438     0.150
    74.231   691.141     0.150
    74.312   692.641     0.150
    74.322   692.875     0.150
    74.450   693.734     0.150
    74.508   693.734     0.150
    74.545   694.234     0.150
    74.588   694.531     0.150
    74.710   695.031     0.150
    74.754   695.633     0.150
    74.754   695.695     0.150
    74.799   695.492     0.150
    74.799   696.188     0.150
    74.945   695.625     0.150
    74.994     7.398     0.150
    74.994    16.898     0.150
    75.042   697.133     0.150
    75.042   697.172     0.150
    75.054   697.234     0.150
    75.112   696.336     0.150
    75.178   697.484     0.150
    75.148   698.234     0.150
    75.309   698.734     0.150
    75.358   698.836     0.150
    75.750   701.734     0.150
    75.783   701.234     0.150
    75.783   701.141     0.150
    75.804   701.484     0.150
    75.804   701.523     0.150
    75.868   702.133     0.150
    76.013   703.633     0.150
    76.212   703.531     0.150
    76.226   704.031     0.150
    76.279   705.141     0.150
    76.268   704.781     0.150
    76.268   705.547     0.150
    76.319   703.695     0.150
    76.702   706.875     0.150
    76.756   707.133     0.150
    76.831   706.438     0.150
    76.989    16.805     0.150
    77.162    16.602     0.150
    77.219   709.633     0.150
    77.249   710.336     0.150
    77.249   710.273     0.150
    77.308    16.766     0.150
    77.337   711.133     0.150
    77.404    16.727     0.150
    77.428   711.141     0.150
    77.468   711.133     0.150
    77.468   711.047     0.150
    77.473   711.531     0.150
    77.479    16.711     0.150
    77.482   710.836     0.150
    77.548   712.422     0.150
    77.547    16.547     0.150
    77.623    16.594     0.150
    77.623   712.297     0.150
    77.638    16.477     0.150
    77.677   712.477     0.150
    77.827    16.664     0.150
    77.905   714.047     0.150
    77.927    16.984     0.150
    77.939   713.234     0.150
    78.064  1301.234     0.150
    78.170   714.977     0.150
    78.363   716.031     0.150
    78.363   715.945     0.150
    78.367    16.930     0.150
    78.381    16.828     0.150
    78.426   716.336     0.150
    78.529   717.094     0.150
    78.532   716.195     0.150
    78.647   718.016     0.150
    78.732   718.844     0.150
    78.732   718.836     0.150
    78.812   716.734     0.150
    78.835   717.508     0.150
    78.941   718.531     0.150
    78.964   718.773     0.150
    78.979   719.633     0.150
    79.172   720.336     0.150
    79.191   720.633     0.150
    79.269   721.633     0.150
    79.333   721.367     0.150
    79.359    14.500     0.150
    79.359  1313.031     0.150
    79.335   719.766     0.150
    79.335   720.344     0.150
    79.438   722.656     0.150
    79.432   723.234     0.150
    79.471   722.531     0.150
    79.550   722.133     0.150
    79.550   722.242     0.150
    79.579   723.133     0.150
    79.576  1013.531     0.150
    79.576  1321.633     0.150
    79.576  1632.531     0.150
    79.664   723.133     0.150
    79.664   723.094     0.150
    79.687   723.438     0.150
    79.745   723.531     0.150
    79.761   723.438     0.150
    79.791   723.031     0.150
    79.874   722.953     0.150
    79.874   722.938     0.150
    79.927   724.734     0.150
    80.261  1016.234     0.150
    80.261  1839.836     0.150
    80.256   727.031     0.150
    80.378   726.836     0.150
    80.378   726.531     0.150
    80.378   726.742     0.150
    80.398   726.531     0.150
    80.484   727.633     0.150
    80.494   727.336     0.150
    80.708   728.828     0.150
    80.708   728.773     0.150
    80.959    13.898     0.150
    80.959  1023.133     0.150
    80.959  1333.531     0.150
    81.232   732.336     0.150
    81.232   730.281     0.150
    81.232   730.633     0.150
    81.477   731.227     0.150
    81.477   731.203     0.150
    81.477   731.156     0.150
    81.533   733.273     0.150
    81.533   733.992     0.150
    81.909   735.234     0.150
    81.898   737.836     0.150
    81.955   735.031     0.150
    82.553   742.031     0.150
    82.573   737.633     0.150
    82.619   739.141     0.150
    82.705   738.336     0.150
    82.732   738.836     0.150
    82.732   738.836     0.150
    83.035   740.938     0.150
    83.035   742.133     0.150
    83.198   740.531     0.150
    83.229   741.164     0.150
    84.081   746.438     0.150
    84.497   748.531     0.150
    84.601   748.992     0.150
    84.791   750.734     0.150
    84.862   749.977     0.150
    85.928   755.797     0.150
    88.034   770.531     0.150
    88.059   765.375     0.150
    88.059   766.844     0.150
    88.903   768.664     0.150
    92.699   787.156     0.150
    94.863   794.539     0.150
    96.868  1804.281     0.150
    98.760   814.242     0.150
   111.689  8374.680     0.150
   111.701  8364.258     0.150
   111.706  8374.617     0.150
   134.427  1152.633     0.150
   134.634  1152.961     0.150
   139.730  1154.500     0.150
   139.730  1155.297     0.150
   141.571  1160.922     0.150
   142.506  1163.656     0.150
   143.983  1168.914     0.150
   144.774  1170.156     0.150
   147.299  1177.938     0.150
     0.684    13.900     0.150
     0.684    23.520     0.150
     1.150    37.430     0.150
     1.457    44.930     0.150
     3.233    49.170     0.150
     3.970    58.670     0.150
     4.584   135.489     0.150
    13.915   192.010     0.150
    32.119   380.494     0.150
    34.214   398.731     0.150
    43.585  3254.354     0.150
    43.591  3243.888     0.150
    43.603  3262.509     0.150
    44.751  3344.682     0.150
    44.764  3345.742     0.150
    44.768  3341.421     0.150
    46.724   503.540     0.150
    47.017   505.191     0.150
    50.879   533.620     0.150
    54.813   563.547     0.150
    64.638   631.294     0.150
    74.258   691.770     0.150
    77.402   711.441     0.150
    77.697   713.180     0.150
    77.864   711.652     0.150
    83.992   745.630     0.150
   111.658  8376.994     0.150
   111.669  8374.014     0.150
   111.674  8374.526     0.150
   144.922  1169.189     0.150
   147.889  1180.680     0.150
     1.772    28.182     0.150
     4.221   130.857     0.150
     8.694   124.871     0.150
    11.267   153.158     0.150
    11.267   270.672     0.150
    11.313   164.271     0.150
    25.457   322.295     0.150
    43.946  3302.711     0.150
    43.952  3310.105     0.150
    43.964  3308.068     0.150
    45.109  3396.115     0.150
    45.122  3397.215     0.150
    45.126  3396.402     0.150
    64.911   634.947     0.150
    71.226   675.730     0.150
    75.386   699.871     0.150
   111.208  8339.330     0.150
   111.220  8338.898     0.150
   111.225  8342.158     0.150
     0.482    19.033     0.150
     0.969    31.064     0.150
     1.289    23.484     0.150
     3.777    59.244     0.150
     3.864    60.244     0.150
     4.015    62.293     0.150
     4.174    64.283     0.150
     4.428    62.373     0.150
     4.620    69.043     0.150
    10.873   151.924     0.150
    11.241   156.305     0.150
    11.419   153.525     0.150
    11.419   275.703     0.150
    43.737  3257.436     0.150
    43.743  3257.740     0.150
    43.755  3259.244     0.150
    44.900  3377.480     0.150
    44.914  3378.275     0.150
    44.918  3378.418     0.150
    51.163   539.654     0.150
   111.377  8351.553     0.150
   111.389  8350.381     0.150
   111.394  8349.275     0.150
     5.299    78.248     0.150
    12.077   303.318     0.150
    14.567   203.607     0.150
    24.576   313.342     0.150
    36.752   424.328     0.150
    42.877  3234.023     0.150
    42.883  3234.906     0.150
    42.895  3235.389     0.150
    44.044  3322.539     0.150
    44.058  3322.369     0.150
    44.062  3323.422     0.150
    47.623   514.258     0.150
    54.494   562.982     0.150
    83.768   743.184     0.150
     0.448    15.346     0.150
     2.889    79.047     0.150
     3.725   102.646     0.150
     4.393    62.266     0.150
     4.414    63.785     0.150
     4.640    68.547     0.150
     5.249   153.291     0.150
    12.030   162.496     0.150
    24.526   313.121     0.150
    24.468   312.355     0.150
    42.927  3238.812     0.150
    42.933  3235.898     0.150
    42.945  3236.742     0.150
    44.095  3341.219     0.150
    44.108  3347.039     0.150
    44.112  3345.070     0.150
    65.294   636.246     0.150
    74.541   694.445     0.150
    75.974   702.727     0.150
    79.843   723.246     0.150
     0.255     7.496     0.150
     3.500    55.984     0.150
     5.143    74.746     0.150
    12.066   164.668     0.150
    12.066   290.418     0.150
    22.768   301.797     0.150
    24.298   318.297     0.150
    32.918   394.547     0.150
    33.256   396.504     0.150
    41.422   465.586     0.150
    42.645   475.855     0.150
    43.021  3246.730     0.150
    43.027  3246.332     0.150
    43.039  3248.078     0.150
    44.185  3336.223     0.150
    44.199  3336.934     0.150
    44.203  3339.336     0.150
    45.370   498.625     0.150
    50.695   537.199     0.150
    55.384   572.484     0.150
    56.049   578.406     0.150
    56.129   579.594     0.150
    57.708   588.754     0.150
    59.471   603.004     0.150
    64.464   633.797     0.150
    65.764   646.367     0.150
    66.149   644.695     0.150
    66.392   652.297     0.150
    78.130   717.039     0.150
    78.156   718.758     0.150
    78.248   717.605     0.150
    78.416   718.441     0.150
   111.679  8376.711     0.150
   111.691  8376.066     0.150
   111.696  8376.062     0.150
     0.516    17.992     0.150
     0.516    12.031     0.150
     2.378    36.336     0.150
     3.377    49.965     0.150
     3.711   102.590     0.150
     3.711    57.293     0.150
     4.103    59.344     0.150
     4.195    62.145     0.150
     4.709    67.820     0.150
     7.915   112.430     0.150
     9.152   128.312     0.150
    10.665   152.090     0.150
    10.665   152.070     0.150
    11.359   157.590     0.150
    11.531   276.266     0.150
    13.675   189.793     0.150
    13.675   189.910     0.150
    14.029   189.512     0.150
    14.102   191.094     0.150
    14.688   205.875     0.150
    15.557   210.730     0.150
    15.636   213.602     0.150
    15.982  1181.715     0.150
    16.187   221.508     0.150
    17.856   432.840     0.150
    17.856   243.410     0.150
    23.987   543.992     0.150
    23.987   309.891     0.150
    24.296    12.098     0.150
    24.799    12.199     0.150
    26.770   336.383     0.150
    29.404   360.883     0.150
    32.291   565.691     0.150
    34.183   403.512     0.150
    34.183     9.828     0.150
    35.382   735.293     0.150
    35.734     9.703     0.150
    35.734   501.992     0.150
    35.734   741.293     0.150
    35.734   762.492     0.150
    35.734   893.891     0.150
    35.734  1023.492     0.150
    36.176   430.590     0.150
    36.176   418.461     0.150
    36.711   423.371     0.150
    36.711   424.012     0.150
    36.827   436.141     0.150
    40.878   455.742     0.150
    40.942   459.793     0.150
    40.942   471.363     0.150
    42.036   466.340     0.150
    43.225   475.941     0.150
    43.467  3254.215     0.150
    43.473  3257.750     0.150
    43.485  3253.938     0.150
    44.634  3345.156     0.150
    44.648  3343.266     0.150
    44.651  3349.586     0.150
    45.465   495.012     0.150
    45.465   494.660     0.150
    45.996   499.840     0.150
    46.070   499.781     0.150
    47.189   507.570     0.150
    47.189     0.777     0.150
    47.190   830.809     0.150
    47.702     9.398     0.150
    47.908   513.680     0.150
    48.527   518.930     0.150
    49.119   523.613     0.150
    49.119    10.879     0.150
    50.707   535.020     0.150
    51.044   535.191     0.150
    51.044   535.191     0.150
    51.259   539.141     0.150
    51.259   539.320     0.150
    52.613     7.297     0.150
    54.327   561.570     0.150
    55.295   567.301     0.150
    55.507   569.793     0.150
    55.554   569.281     0.150
    56.101   573.781     0.150
    56.222   575.992     0.150
    58.311   590.602     0.150
    59.071   593.793     0.150
    59.071   593.832     0.150
    60.006   601.031     0.150
    61.332    16.398     0.150
    63.916   627.191     0.150
    64.090    16.699     0.150
    64.236   632.992     0.150
    64.582  1150.793     0.150
    64.692    16.699     0.150
    65.214   636.543     0.150
    65.214   636.703     0.150
    65.826   639.953     0.150
    65.933   640.922     0.150
    65.933   640.852     0.150
    67.776   653.242     0.150
    68.203   655.562     0.150
    68.797   659.672     0.150
    68.847   659.840     0.150
    68.974   660.633     0.150
    69.285   914.590     0.150
    69.285  1206.090     0.150
    69.970   666.000     0.150
    70.003   667.383     0.150
    70.147   667.922     0.150
    70.330   669.172     0.150
    70.457   669.980     0.150
    70.528   669.402     0.150
    70.528   669.402     0.150
    70.528   930.832     0.150
    70.528  1692.070     0.150
    70.528   669.391     0.150
    70.528   824.590     0.150
    70.528   930.793     0.150
    70.528  1220.293     0.150
    70.528  1493.492     0.150
    70.876   672.492     0.150
    70.820   672.590     0.150
    70.952   672.883     0.150
    71.023   673.461     0.150
    71.620   676.723     0.150
    71.826   679.332     0.150
    71.868   679.090     0.150
    72.266   681.402     0.150
    72.266   681.422     0.150
    73.041   685.730     0.150
    73.154   686.230     0.150
    73.208   686.133     0.150
    73.245   686.242     0.150
    73.537   689.570     0.150
    73.722   688.793     0.150
    73.722    12.898     0.150
    73.722    16.398     0.150
    73.757   689.730     0.150
    73.919   690.500     0.150
    73.902   690.832     0.150
    73.908    16.898     0.150
    74.198   692.152     0.150
    74.198   692.270     0.150
    74.198    12.594     0.150
    74.247   691.363     0.150
    74.255   691.590     0.150
    74.255   691.352     0.150
    74.255   691.441     0.150
    74.248   692.633     0.150
    74.257   692.742     0.150
    74.310   692.902     0.150
    74.514   694.090     0.150
    74.594   694.293     0.150
    74.638   694.992     0.150
    74.767   695.793     0.150
    74.734   692.191     0.150
    74.803   695.992     0.150
    74.803   696.000     0.150
    74.868   696.543     0.150
    74.868   696.441     0.150
    74.915    15.199     0.150
    74.988   696.441     0.150
    75.090   697.492     0.150
    75.107   697.590     0.150
    75.107   697.492     0.150
    75.193   696.891     0.150
    75.405   699.590     0.150
    75.633   706.391     0.150
    75.790   701.691     0.150
    75.853   702.090     0.150
    75.845   701.613     0.150
    75.876   701.781     0.150
    75.922   702.590     0.150
    75.922   714.191     0.150
    76.014   701.293     0.150
    76.010   703.531     0.150
    76.061   703.480     0.150
    76.094   703.000     0.150
    76.149   704.750     0.150
    76.264   704.492     0.150
    76.384   704.102     0.150
    76.397   704.793     0.150
    76.397   704.891     0.150
    76.804   708.191     0.150
    76.959   707.691     0.150
    77.232   709.453     0.150
    77.291   710.691     0.150
    77.477   710.020     0.150
    77.514   711.090     0.150
    77.514   711.012     0.150
    77.682   712.590     0.150
    77.682   712.500     0.150
    77.878   713.602     0.150
    77.960   714.391     0.150
    77.960   714.402     0.150
    78.311   715.293     0.150
    78.400   715.902     0.150
    78.583   717.301     0.150
    79.053   716.891     0.150
    79.201   720.793     0.150
    79.219   720.793     0.150
    79.451   721.293     0.150
    79.558  1008.293     0.150
    79.558  1321.090     0.150
    79.609   723.891     0.150
    79.695   723.250     0.150
    79.797   723.793     0.150
    79.816   722.492     0.150
    80.261  1018.191     0.150
    80.261  1846.090     0.150
    80.384   727.770     0.150
    80.426   727.152     0.150
    80.518   727.492     0.150
    80.627   728.562     0.150
    81.089   729.820     0.150
    81.089   729.793     0.150
    81.405   731.180     0.150
    83.323   742.141     0.150
    83.525   743.293     0.150
    84.183   747.090     0.150
    84.600   749.191     0.150
    84.803   750.203     0.150
    85.978   755.902     0.150
    87.423   760.531     0.150
    98.732   814.781     0.150
   111.819  8378.164     0.150
   111.830  8378.043     0.150
   111.836  8374.191     0.150
     0.723    21.773     0.150
     0.769    16.195     0.150
     0.900    17.906     0.150
     0.957    19.312     0.150
     0.952    19.258     0.150
     1.727    31.695     0.150
     2.123    59.289     0.150
     1.924    34.914     0.150
     2.950    49.211     0.150
     3.095    50.844     0.150
     3.867    59.117     0.150
     4.543    66.812     0.150
     5.281    77.594     0.150
     5.544    79.727     0.150
     6.744    98.656     0.150
     8.368   122.812     0.150
     9.910   143.672     0.150
    12.283   168.461     0.150
    12.473   160.656     0.150
    12.864   173.352     0.150
    13.510   190.875     0.150
    14.767   204.867     0.150
    15.260   214.906     0.150
    16.311   226.312     0.150
    16.703   228.094     0.150
    41.593   463.094     0.150
    42.637  3170.609     0.150
    42.643  3171.195     0.150
    42.655  3177.422     0.150
    43.805  3261.836     0.150
    43.818  3253.961     0.150
    43.822  3269.344     0.150
    46.952   506.914     0.150
    50.158   533.562     0.150
    56.725   585.211     0.150
    59.155   600.711     0.150
    64.045   633.992     0.150
    64.455   632.016     0.150
    64.306     9.398     0.150
    64.756   632.523     0.150
    67.613   651.891     0.150
    70.954   673.141     0.150
    70.954   673.141     0.150
    70.954   931.312     0.150
    70.954  1695.102     0.150
    72.214   682.273     0.150
    74.665   694.875     0.150
    74.826    11.898     0.150
    74.826    15.195     0.150
    75.128   697.508     0.150
    75.633   701.461     0.150
    76.021   702.914     0.150
    76.607   706.453     0.150
    76.747   706.586     0.150
    77.776   714.305     0.150
    78.791   720.000     0.150
    79.723   724.820     0.150
    80.059   726.070     0.150
    80.972   729.492     0.150
    81.102   731.031     0.150
    82.563   739.203     0.150
    83.092   745.555     0.150
    83.266   741.820     0.150
    83.452   742.508     0.150
    84.265   747.797     0.150
    86.264   756.375     0.150
    90.400   776.820     0.150
   112.203  8442.359     0.150
   112.215  8444.492     0.150
   112.220  8451.695     0.150
   159.980  1195.812     0.150
     0.687    13.414     0.150
     0.687    21.857     0.150
     0.704    21.292     0.150
     0.965    18.925     0.150
     1.745    31.385     0.150
     1.869    33.164     0.150
     1.869    32.944     0.150
     1.943    33.854     0.150
     2.105    34.225     0.150
     2.105    34.144     0.150
     2.927    48.104     0.150
     2.970    49.114     0.150
     3.000    49.185     0.150
     3.164    48.133     0.150
     3.070    49.895     0.150
     3.070    50.095     0.150
     3.115    50.845     0.150
     3.460    55.215     0.150
     3.460    55.146     0.150
     3.686    58.354     0.150
     3.721    58.954     0.150
     4.531    69.814     0.150
     4.917    71.205     0.150
     5.088    75.334     0.150
     5.106    76.064     0.150
     5.140    76.084     0.150
     5.524    79.425     0.150
     5.524    79.316     0.150
     5.722    87.805     0.150
     5.877    87.696     0.150
     5.996    88.263     0.150
     6.026    87.185     0.150
     6.414    93.185     0.150
     6.962   100.539     0.150
     6.973   102.462     0.150
     7.022   100.560     0.150
     7.309   104.935     0.150
     7.442   105.893     0.150
     7.917   112.834     0.150
     8.214   117.310     0.150
    10.011   141.675     0.150
    10.059   141.805     0.150
     9.930   143.895     0.150
    10.176   144.744     0.150
    10.278   145.289     0.150
    10.892   152.774     0.150
    11.465   160.378     0.150
    12.267   169.435     0.150
    14.981   207.503     0.150
    17.272   233.659     0.150
    18.612   250.885     0.150
    22.962   297.825     0.150
    23.756    11.899     0.150
    25.086   320.084     0.150
    27.572   344.994     0.150
    29.996   365.925     0.150
    32.011   381.725     0.150
    32.011   380.204     0.150
    33.035   395.284     0.150
    33.481   394.095     0.150
    34.868   735.484     0.150
    35.543   412.185     0.150
    35.543   486.784     0.150
    35.543   508.784     0.150
    35.543   561.685     0.150
    35.543   882.185     0.150
    35.543   906.185     0.150
    35.543   412.244     0.150
    37.257   427.314     0.150
    37.320   431.254     0.150
    37.424   430.725     0.150
    41.482   465.814     0.150
    42.596   471.984     0.150
    42.656  3190.371     0.150
    42.662  3190.838     0.150
    42.674  3184.257     0.150
    44.016   483.954     0.150
    43.824  3269.557     0.150
    43.838  3275.129     0.150
    43.842  3272.150     0.150
    44.826   491.794     0.150
    46.572   504.234     0.150
    46.629   503.704     0.150
    46.629   503.604     0.150
    46.759   504.374     0.150
    46.938   507.084     0.150
    46.938   507.135     0.150
    47.232    14.000     0.150
    47.384   600.584     0.150
    47.769   603.685     0.150
    47.769   515.944     0.150
    47.933   514.834     0.150
    47.933   514.834     0.150
    48.697   520.114     0.150
    49.813   530.084     0.150
    50.152   532.814     0.150
    50.836   538.104     0.150
    51.691   542.984     0.150
    51.843   546.925     0.150
    51.992   546.314     0.150
    51.992   546.324     0.150
    52.216    14.900     0.150
    52.216    19.700     0.150
    52.990   553.364     0.150
    54.047   561.154     0.150
    54.047   561.135     0.150
    54.385   563.925     0.150
    55.737   571.614     0.150
    56.738    10.500     0.150
    57.195   581.784     0.150
    57.604   708.885     0.150
    57.698    12.600     0.150
    57.698    18.399     0.150
    59.010   595.984     0.150
    60.800   605.984     0.150
    60.872    14.400     0.150
    62.841    15.000     0.150
    63.783    15.801     0.150
    64.088   629.374     0.150
    64.189   631.164     0.150
    64.319    15.100     0.150
    64.445   631.784     0.150
    64.771   665.385     0.150
    64.771   634.015     0.150
    65.741   640.725     0.150
    65.851   641.185     0.150
    66.913   648.765     0.150
    68.731   660.244     0.150
    68.816   660.584     0.150
    68.826   660.064     0.150
    68.826   658.794     0.150
    69.616   665.475     0.150
    69.639   808.784     0.150
    69.639  1199.084     0.150
    69.639   664.504     0.150
    69.728   666.704     0.150
    69.881   666.484     0.150
    69.923   667.854     0.150
    70.062   668.504     0.150
    70.305   670.024     0.150
    70.376   670.454     0.150
    70.453   670.885     0.150
    70.809   673.055     0.150
    70.755   673.215     0.150
    70.947   673.645     0.150
    70.947   673.645     0.150
    70.947   933.624     0.150
    70.947  1699.715     0.150
    70.947   673.584     0.150
    70.947   693.885     0.150
    70.947   830.484     0.150
    70.947   933.584     0.150
    70.947  1226.784     0.150
    70.947  1274.484     0.150
    70.947  1500.484     0.150
    70.956   674.074     0.150
    71.141   674.294     0.150
    72.220   682.084     0.150
    72.220   682.145     0.150
    72.950   686.124     0.150
    73.139   686.965     0.150
    73.240   687.425     0.150
    73.315   687.895     0.150
    73.457    12.700     0.150
    73.538   690.614     0.150
    73.586   689.975     0.150
    73.774   690.524     0.150
    73.840   691.385     0.150
    74.154   691.715     0.150
    74.154   691.345     0.150
    74.249   693.000     0.150
    74.249   692.984     0.150
    74.249    11.600     0.150
    74.249  1263.484     0.150
    74.246   693.614     0.150
    74.293   693.824     0.150
    74.250   693.715     0.150
    74.335   692.044     0.150
    74.619   694.675     0.150
    74.651   694.784     0.150
    74.651   694.765     0.150
    74.651   694.584     0.150
    74.659   694.885     0.150
    74.659   694.895     0.150
    74.719   695.944     0.150
    74.719   696.044     0.150
    74.848   696.994     0.150
    74.832    11.500     0.150
    75.064   697.984     0.150
    75.099   698.284     0.150
    75.144   698.484     0.150
    75.307   699.885     0.150
    75.444   696.685     0.150
    75.444   700.688     0.150
    75.465   700.385     0.150
    75.465   700.305     0.150
    75.591   701.284     0.150
    75.624   701.484     0.150
    75.624   701.435     0.150
    75.779   702.965     0.150
    75.812   701.385     0.150
    75.845   702.784     0.150
    75.845   702.845     0.150
    75.900   702.984     0.150
    75.900   702.984     0.150
    76.256   704.284     0.150
    76.345   705.484     0.150
    76.355   705.824     0.150
    76.406   706.124     0.150
    76.447   706.385     0.150
    76.447   717.484     0.150
    76.536   707.484     0.150
    76.570   706.874     0.150
    76.722   708.374     0.150
    76.722   708.385     0.150
    76.785   707.784     0.150
    76.948   709.044     0.150
    76.968   709.135     0.150
    76.968   709.104     0.150
    77.199   710.784     0.150
    77.264   709.784     0.150
    77.301   711.484     0.150
    77.303   709.524     0.150
    77.753   713.444     0.150
    77.948   714.385     0.150
    77.951   714.584     0.150
    77.951   714.645     0.150
    78.385   717.095     0.150
    78.854   719.385     0.150
    78.907   720.584     0.150
    79.102   721.294     0.150
    79.197   719.324     0.150
    79.452   723.284     0.150
    79.620   723.584     0.150
    79.620   723.765     0.150
    79.631   724.484     0.150
    79.640   723.784     0.150
    79.720   724.544     0.150
    79.720   724.845     0.150
    79.720   724.885     0.150
    79.905   725.685     0.150
    79.945   725.584     0.150
    80.035   726.484     0.150
    80.052   726.284     0.150
    80.129   726.784     0.150
    80.129   726.744     0.150
    80.169   726.584     0.150
    80.216   727.395     0.150
    80.223   726.784     0.150
    80.250   727.284     0.150
    80.376   727.584     0.150
    80.558  1022.084     0.150
    80.558  1852.284     0.150
    80.529   729.454     0.150
    80.529   729.524     0.150
    80.628   729.305     0.150
    80.628   729.645     0.150
    80.628   729.515     0.150
    80.925   730.664     0.150
    80.925   730.484     0.150
    80.925   730.794     0.150
    80.921   730.484     0.150
    80.969   731.284     0.150
    81.151  1024.484     0.150
    81.332   729.385     0.150
    81.358   732.345     0.150
    81.358   732.324     0.150
    81.369   731.095     0.150
    81.754   734.784     0.150
    82.518   742.185     0.150
    82.687   740.185     0.150
    83.036   742.444     0.150
    83.258   742.584     0.150
    83.986   746.944     0.150
    84.873   751.685     0.150
    85.150   752.984     0.150
    85.293   753.784     0.150
    85.361   755.284     0.150
    86.482   759.595     0.150
    87.093   764.084     0.150
    87.362   764.685     0.150
    98.904   817.154     0.150
    98.904   817.225     0.150
   122.070  1130.760     0.150
   133.969  1152.484     0.150
   144.779  1173.024     0.150
   155.925  1199.135     0.150
   155.925  1218.004     0.150
   160.492  1247.852     0.150
   163.532  3081.284     0.150
    15.247   213.737     0.150
    41.485   459.147     0.150
    41.487   459.607     0.150
    43.467  3257.172     0.150
    43.473  3259.661     0.150
    43.485  3260.325     0.150
    44.635  3352.591     0.150
    44.648  3347.381     0.150
    44.652  3356.675     0.150
    63.614   624.777     0.150
    63.885   626.817     0.150
     1.081    34.592     0.150
    17.724   239.512     0.150
    36.540   420.201     0.150
    38.523   442.021     0.150
    40.791   460.951     0.150
    41.950   465.762     0.150
    43.626  3264.129     0.150
    43.632  3262.965     0.150
    43.644  3261.279     0.150
    44.793  3370.967     0.150
    44.806  3348.949     0.150
    44.810  3357.002     0.150
    45.629   496.361     0.150
    46.661   503.371     0.150
    63.851   644.281     0.150
    66.199    16.900     0.150
    71.789   678.021     0.150
    71.936   678.252     0.150
    73.363   686.582     0.150
    73.657   688.682     0.150
    74.065   690.480     0.150
    74.135   691.672     0.150
    74.135   698.271     0.150
    74.745   695.791     0.150
    75.045   696.082     0.150
    75.741   699.582     0.150
    75.795   700.352     0.150
    76.320   703.441     0.150
    76.862   706.881     0.150
    77.334   711.059     0.150
    79.305   720.756     0.150
    80.306   726.971     0.150
    81.384   733.832     0.150
   111.693  8375.707     0.150
   111.705  8364.172     0.150
   111.710  8380.023     0.150
     1.063    32.824     0.150
     1.088    19.953     0.150
     1.088    33.242     0.150
     1.084    20.383     0.150
     1.084    34.211     0.150
     1.181    21.941     0.150
     1.181    36.301     0.150
     3.531    56.863     0.150
     5.981    90.961     0.150
    12.433   170.723     0.150
    12.433   301.797     0.150
    31.296   380.754     0.150
    42.533  3239.852     0.150
    42.539  3240.301     0.150
    42.551  3241.109     0.150
    43.700  3325.934     0.150
    43.713  3331.020     0.150
    43.717  3326.965     0.150
    44.842   491.336     0.150
    51.849  3875.820     0.150
    52.306   552.223     0.150
    65.891   644.664     0.150
   112.095  8400.375     0.150
   112.107  8402.840     0.150
   112.112  8403.004     0.150
     0.732    12.250     0.150
     0.732    21.258     0.150
     0.734    12.262     0.150
     0.734    20.953     0.150
     1.562    26.832     0.150
     3.474    53.223     0.150
     4.313    63.559     0.150
     5.046    74.191     0.150
     5.422   133.348     0.150
     5.422   155.848     0.150
     5.422    77.242     0.150
     5.422    77.164     0.150
     5.678    83.367     0.150
     5.736    84.539     0.150
     7.251   105.281     0.150
     8.041   113.988     0.150
     8.853   124.445     0.150
     9.099   128.664     0.150
     9.947   141.031     0.150
     9.931   141.773     0.150
     9.931   138.773     0.150
    10.064   141.117     0.150
    10.490   147.344     0.150
    11.481   160.203     0.150
    11.901   164.965     0.150
    12.090   165.504     0.150
    12.090   289.305     0.150
    12.090   166.434     0.150
    12.422   174.293     0.150
    13.590   185.980     0.150
    14.932   206.695     0.150
    17.866   242.957     0.150
    23.668   306.023     0.150
    23.668   306.312     0.150
    24.153   314.281     0.150
    24.176   530.902     0.150
    24.176   770.152     0.150
    24.370   316.473     0.150
    24.698   545.078     0.150
    24.698   316.402     0.150
    26.273   330.203     0.150
    30.062   364.703     0.150
    30.062   364.703     0.150
    31.830   378.902     0.150
    32.914   567.055     0.150
    32.914   795.652     0.150
    33.050   390.352     0.150
    33.270   391.523     0.150
    34.854   408.172     0.150
    34.854    10.961     0.150
    35.087   406.914     0.150
    35.366   407.504     0.150
    35.366   486.004     0.150
    35.366   409.012     0.150
    37.046   424.492     0.150
    37.421   431.395     0.150
    37.434   427.824     0.150
    37.434   429.441     0.150
    38.272   435.875     0.150
    38.483   434.102     0.150
    39.268   446.191     0.150
    41.568   463.312     0.150
    42.377   468.902     0.150
    42.777  3179.672     0.150
    42.784  3180.141     0.150
    42.795  3181.031     0.150
    43.947  3263.148     0.150
    43.961  3263.148     0.150
    43.965  3262.582     0.150
    44.777   841.387     0.150
    44.777   489.293     0.150
    44.777   489.414     0.150
    46.348   501.363     0.150
    46.348   501.344     0.150
    46.416   500.184     0.150
    46.540   501.902     0.150
    46.696   504.453     0.150
    46.741   504.203     0.150
    46.741   504.191     0.150
    47.122    11.000     0.150
    47.758   511.691     0.150
    47.758   512.223     0.150
    47.841   614.328     0.150
    48.697   518.254     0.150
    48.697   518.352     0.150
    49.834   528.074     0.150
    50.070   622.852     0.150
    50.070   529.184     0.150
    50.750   535.754     0.150
    51.374   538.613     0.150
    51.486   540.602     0.150
    51.990   543.973     0.150
    52.060  3870.867     0.150
    52.816   550.363     0.150
    53.571   556.504     0.150
    53.571   556.504     0.150
    53.571   556.375     0.150
    53.888   558.223     0.150
    53.888   558.262     0.150
    54.005   558.004     0.150
    54.226   638.344     0.150
    54.226   625.203     0.150
    55.510   568.574     0.150
    55.510   568.664     0.150
    55.764   571.004     0.150
    55.776   570.383     0.150
    56.295   575.203     0.150
    56.429   585.805     0.150
    56.607  1040.004     0.150
    56.966   579.125     0.150
    57.563    10.199     0.150
    57.563    14.000     0.150
    57.841   585.793     0.150
    59.269   595.742     0.150
    60.759  1097.305     0.150
    63.066    12.102     0.150
    63.455     9.902     0.150
    63.997   628.133     0.150
    64.183    14.102     0.150
    64.223   628.902     0.150
    64.547   631.184     0.150
    65.534   638.145     0.150
    65.534   638.281     0.150
    65.657   638.723     0.150
    65.770    13.000     0.150
    65.770   667.703     0.150
    68.534   657.273     0.150
    68.606  2345.555     0.150
    68.616   657.844     0.150
    68.616   657.922     0.150
    68.696   657.652     0.150
    69.410   662.254     0.150
    69.410   818.004     0.150
    69.489   661.594     0.150
    69.535   663.375     0.150
    69.628   662.254     0.150
    69.687   663.562     0.150
    69.729   664.852     0.150
    69.868   665.625     0.150
    70.103   666.965     0.150
    70.181   667.613     0.150
    70.255   667.914     0.150
    70.613   670.172     0.150
    70.558   670.305     0.150
    70.673   671.824     0.150
    70.719   671.062     0.150
    70.719   671.062     0.150
    70.719   930.781     0.150
    70.719  1223.863     0.150
    70.719  1696.352     0.150
    70.719   671.004     0.150
    70.719   691.504     0.150
    70.719   827.703     0.150
    70.719   930.703     0.150
    70.719  1223.805     0.150
    70.719  1271.805     0.150
    70.719  1497.203     0.150
    70.759   671.062     0.150
    71.274   674.543     0.150
    71.547   677.191     0.150
    71.609   677.043     0.150
    72.020   679.145     0.150
    72.020   679.262     0.150
    72.020   679.242     0.150
    72.936   684.055     0.150
    73.035   684.234     0.150
    73.332   687.691     0.150
    73.366   687.145     0.150
    73.556   687.793     0.150
    73.672   688.762     0.150
    74.027   690.188     0.150
    74.027   690.203     0.150
    74.027   690.102     0.150
    74.027    17.301     0.150
    74.027  1538.703     0.150
    74.027  1748.703     0.150
    74.041   690.484     0.150
    74.045   690.633     0.150
    74.278   692.082     0.150
    74.278   692.043     0.150
    74.422   691.684     0.150
    74.430   692.004     0.150
    74.430   691.934     0.150
    74.430   691.965     0.150
    74.430   692.031     0.150
    74.497   693.105     0.150
    74.497   693.164     0.150
    74.497   693.113     0.150
    74.489   692.422     0.150
    74.657   694.062     0.150
    74.840   695.402     0.150
    74.855   695.543     0.150
    74.862   695.504     0.150
    74.875   695.602     0.150
    75.077   696.602     0.150
    75.083   697.004     0.150
    75.240   697.484     0.150
    75.367   698.402     0.150
    75.401   698.305     0.150
    75.558   699.781     0.150
    75.601   699.602     0.150
    75.620   699.805     0.150
    75.614   700.004     0.150
    75.675   700.203     0.150
    76.030   702.703     0.150
    76.121   702.402     0.150
    76.131   703.102     0.150
    76.184   703.219     0.150
    76.184   703.344     0.150
    76.225   703.703     0.150
    76.311   704.402     0.150
    76.351   704.242     0.150
    76.374   704.094     0.150
    76.453   705.055     0.150
    76.495   705.102     0.150
    76.562   705.203     0.150
    76.565   703.805     0.150
    76.729   705.922     0.150
    76.729   705.965     0.150
    76.729   705.992     0.150
    76.729    18.449     0.150
    76.751   706.215     0.150
    77.035   706.902     0.150
    77.077   709.203     0.150
    77.304   709.102     0.150
    77.542   711.602     0.150
    77.647   711.902     0.150
    77.720   711.402     0.150
    77.720   711.523     0.150
    77.723   711.703     0.150
    78.001   713.645     0.150
    78.001   713.613     0.150
    78.131   724.805     0.150
    78.266   714.703     0.150
    78.627   716.102     0.150
    78.680   717.203     0.150
    78.732   717.918     0.150
    78.752   716.914     0.150
    79.224   720.902     0.150
    79.392   720.305     0.150
    79.417   721.652     0.150
    79.411   720.703     0.150
    79.457   722.602     0.150
    79.457     8.902     0.150
    79.493   721.965     0.150
    79.493   721.992     0.150
    79.552  1322.004     0.150
    79.552  1637.203     0.150
    79.684   722.316     0.150
    79.677   722.805     0.150
    79.717   722.402     0.150
    79.807   723.902     0.150
    79.807   723.934     0.150
    79.825   723.004     0.150
    79.901   723.902     0.150
    79.901   723.914     0.150
    79.994   723.703     0.150
    80.023   724.902     0.150
    80.111   726.203     0.150
    80.329  1018.102     0.150
    80.329  1642.504     0.150
    80.337   726.691     0.150
    80.337   726.742     0.150
    80.516   726.762     0.150
    80.516   726.805     0.150
    80.516   726.984     0.150
    80.693   728.102     0.150
    80.701   727.836     0.150
    80.701   727.602     0.150
    80.701   727.914     0.150
    80.745   729.133     0.150
    80.742   727.902     0.150
    80.806   728.902     0.150
    81.158   729.324     0.150
    81.363    14.973     0.150
    82.491   737.434     0.150
    82.529   735.102     0.150
    82.861   742.336     0.150
    82.984   741.414     0.150
    83.727    11.125     0.150
    83.727   744.215     0.150
    83.784   744.473     0.150
    84.246   748.383     0.150
    84.382   747.383     0.150
    84.572   748.324     0.150
    84.921  1833.754     0.150
    85.099   751.102     0.150
    85.317   751.754     0.150
    85.425   753.941     0.150
    86.397   755.715     0.150
    87.212   761.504     0.150
    92.615   785.703     0.150
    93.794   791.848     0.150
    93.794   791.895     0.150
    98.681   814.344     0.150
   110.614  1134.629     0.150
   112.327  8403.824     0.150
   112.339  8403.281     0.150
   112.344  8404.930     0.150
   144.333  1168.902     0.150
   153.352  1192.523     0.150
   160.717  1234.504     0.150
   160.717  1234.465     0.150
     5.077   149.438     0.150
     5.077    72.949     0.150
    43.099  3234.832     0.150
    43.105  3234.918     0.150
    43.117  3234.832     0.150
    44.267  3323.484     0.150
    44.280  3325.188     0.150
    44.284  3326.324     0.150
     1.439    44.871     0.150
     1.666    50.449     0.150
     2.203    56.961     0.150
     4.541   129.875     0.150
     4.541    64.988     0.150
     7.083   100.051     0.150
    11.400   153.230     0.150
    43.631  3250.562     0.150
    43.637  3256.594     0.150
    43.649  3260.582     0.150
    44.798  3343.984     0.150
    44.811  3343.168     0.150
    44.815  3344.961     0.150
    51.403  3915.520     0.150
    55.498   568.859     0.150
    64.856   632.207     0.150
    65.888   639.148     0.150
   145.003  1169.672     0.150
     1.086    32.957     0.150
     5.703    85.836     0.150
     5.924    87.168     0.150
     6.187    94.508     0.150
     7.488   110.309     0.150
     7.982   119.059     0.150
     8.647   128.129     0.150
     9.045   132.707     0.150
    42.460  3204.695     0.150
    42.465  3205.191     0.150
    42.478  3201.258     0.150
    43.624  3297.238     0.150
    43.637  3298.250     0.150
    43.641  3298.410     0.150
   111.901  8402.961     0.150
   111.913  8404.129     0.150
   111.918  8406.090     0.150
     0.465    14.031     0.150
     1.033    20.250     0.150
     1.142    36.281     0.150
     1.142    21.941     0.150
     1.551    44.271     0.150
     1.965    34.740     0.150
     2.091    36.541     0.150
     2.166    37.260     0.150
     3.207    53.031     0.150
     3.237    52.330     0.150
     3.306    53.301     0.150
     3.336    53.430     0.150
     3.352    54.881     0.150
     3.699   103.160     0.150
     3.792    59.420     0.150
     3.925    61.510     0.150
     9.054   130.760     0.150
     9.150   128.500     0.150
     9.740   247.160     0.150
     9.748   141.980     0.150
    12.087   166.211     0.150
    12.087   300.111     0.150
    42.487   471.080     0.150
    42.879  3194.717     0.150
    42.885  3197.385     0.150
    42.897  3193.236     0.150
    44.046  3274.873     0.150
    44.060  3274.838     0.150
    44.064  3276.248     0.150
    46.506   502.891     0.150
    54.528   628.330     0.150
    63.934    15.199     0.150
    66.065    14.199     0.150
    74.153   692.361     0.150
    74.605   694.621     0.150
    74.925    11.301     0.150
    75.219   697.961     0.150
    75.815   702.260     0.150
    76.181   702.061     0.150
    76.352   704.061     0.150
    76.642   707.590     0.150
    76.650   707.061     0.150
    77.009   709.871     0.150
    77.215   710.660     0.150
    77.448   711.400     0.150
    78.015   714.160     0.150
    83.783   746.291     0.150
   112.023  8379.795     0.150
   112.035  8383.682     0.150
     0.498    21.867     0.150
     0.503    21.105     0.150
     0.981    31.680     0.150
     1.701    50.668     0.150
     1.742    50.879     0.150
     1.979    56.227     0.150
     1.979    30.738     0.150
     2.911    45.051     0.150
     3.589    53.656     0.150
     3.778    55.078     0.150
     4.154    61.250     0.150
     4.142    63.008     0.150
     4.335    64.105     0.150
     4.407    63.461     0.150
     4.753    69.730     0.150
     4.639    69.094     0.150
     5.417    79.367     0.150
     5.724    83.152     0.150
     5.875    86.102     0.150
     5.933    86.090     0.150
     6.629    95.875     0.150
     6.625    96.164     0.150
     7.089   101.707     0.150
     7.234   103.891     0.150
     7.425   106.352     0.150
     8.075   115.191     0.150
     8.705   123.562     0.150
     8.875   125.602     0.150
     8.892   126.586     0.150
     9.152   129.156     0.150
     9.464   133.543     0.150
     9.575   134.473     0.150
     9.565   136.258     0.150
    12.452   175.801     0.150
    13.325   186.848     0.150
    24.765   317.926     0.150
    26.427   343.648     0.150
    30.642   382.828     0.150
    33.716   409.746     0.150
    36.263   427.266     0.150
    38.216   442.598     0.150
    40.985   468.719     0.150
    41.014   458.227     0.150
    43.758  3263.676     0.150
    43.764  3264.113     0.150
    43.776  3264.227     0.150
    43.972   495.746     0.150
    44.921  3352.547     0.150
    44.935  3352.547     0.150
    44.939  3352.547     0.150
    45.535   506.699     0.150
    45.929   500.926     0.150
    45.929   499.699     0.150
    46.918   506.238     0.150
    47.439   522.488     0.150
    48.144   519.516     0.150
    52.797   554.727     0.150
    55.661   571.059     0.150
    56.937   578.988     0.150
    63.965   629.328     0.150
    64.229   631.086     0.150
    65.143   636.828     0.150
    65.143    17.199     0.150
    66.509   648.027     0.150
    66.731   643.766     0.150
    73.772   690.227     0.150
    74.871   696.027     0.150
    76.363   705.527     0.150
    76.875   709.426     0.150
    77.940   714.098     0.150
    78.086   714.227     0.150
    79.065   719.590     0.150
    79.065   719.066     0.150
    79.287   719.715     0.150
    80.653   727.699     0.150
    82.858   737.699     0.150
     0.686    13.633     0.150
     1.651    46.797     0.150
     2.158    35.953     0.150
     3.781    58.844     0.150
     4.620    68.758     0.150
     5.317    78.430     0.150
     5.990    88.172     0.150
     6.158    89.711     0.150
     6.263    91.812     0.150
     6.562    95.945     0.150
     8.858   127.375     0.150
     9.064   231.789     0.150
     9.255   132.086     0.150
     9.703   138.742     0.150
     9.724   248.188     0.150
    10.972   155.570     0.150
    11.276   159.719     0.150
    11.940   303.586     0.150
    12.115   292.219     0.150
    12.786   179.938     0.150
    13.134   183.859     0.150
    14.147   200.289     0.150
    24.077   313.648     0.150
    34.726   562.492     0.150
    35.795   415.078     0.150
    37.683   433.727     0.150
    41.454   463.789     0.150
    42.898  3231.289     0.150
    42.904  3230.453     0.150
    42.916  3230.234     0.150
    43.661   483.156     0.150
    44.063  3337.742     0.150
    44.077  3338.742     0.150
    44.081  3344.359     0.150
    44.735   491.484     0.150
    45.153   495.094     0.150
    45.153   495.109     0.150
    46.565   505.445     0.150
    46.565   505.305     0.150
    46.828   508.477     0.150
    47.444   513.789     0.150
    47.544    12.500     0.150
    49.894   532.383     0.150
    51.671   544.492     0.150
    51.671   544.516     0.150
    52.515    11.297     0.150
    52.515    13.797     0.150
    54.322   563.945     0.150
    54.322   563.938     0.150
    57.238   583.758     0.150
    57.659   590.062     0.150
    57.995    10.297     0.150
    57.995    14.000     0.150
    59.426   601.398     0.150
    63.049   623.844     0.150
    63.159    12.797     0.150
    64.064    13.297     0.150
    64.425   632.789     0.150
    64.561   636.586     0.150
    64.614    11.297     0.150
    64.744   638.594     0.150
    66.073   643.695     0.150
    66.073   643.664     0.150
    66.125   642.516     0.150
    66.196    12.000     0.150
    67.297   650.664     0.150
    69.063  1208.883     0.150
    71.467   677.688     0.150
    71.861   681.062     0.150
    72.431   684.547     0.150
    72.431   684.617     0.150
    72.600   684.180     0.150
    73.734   690.828     0.150
    73.766    12.000     0.150
    74.060   692.055     0.150
    74.230   693.789     0.150
    74.230   693.883     0.150
    74.230   869.586     0.150
    74.230  1262.586     0.150
    74.230  1760.586     0.150
    74.230  1862.586     0.150
    74.449   694.766     0.150
    74.703   696.898     0.150
    74.700   695.992     0.150
    74.700   695.984     0.150
    74.700   696.148     0.150
    74.700   696.125     0.150
    75.743   701.688     0.150
    75.796   702.977     0.150
    76.349   706.844     0.150
    76.462   706.734     0.150
    77.196   711.688     0.150
    77.303   710.883     0.150
    77.973   715.516     0.150
    78.506   718.789     0.150
    79.014   720.945     0.150
    79.425   723.188     0.150
    79.425   724.094     0.150
    79.561   723.195     0.150
    79.673   723.664     0.150
    79.820   726.414     0.150
    80.157   728.094     0.150
    80.241   728.594     0.150
    80.788   729.828     0.150
    80.939   733.984     0.150
    80.939   731.828     0.150
    81.354   733.164     0.150
    81.387   733.273     0.150
    82.063   739.648     0.150
    83.149   745.188     0.150
    83.454   742.766     0.150
    84.006   747.328     0.150
    84.756   751.945     0.150
    85.051   751.844     0.150
    86.475   760.695     0.150
    88.079   766.523     0.150
   111.896  8381.438     0.150
   111.907  8379.586     0.150
   111.912  8377.281     0.150
     0.501     8.962     0.150
     0.501    15.742     0.150
     1.447    23.962     0.150
     6.281    89.752     0.150
    11.955   168.072     0.150
    14.389   201.712     0.150
    42.969  3256.590     0.150
    42.975  3243.345     0.150
    42.987  3241.607     0.150
    44.137  3342.258     0.150
    44.151  3343.691     0.150
    44.154  3343.540     0.150
    68.530   655.425     0.150
    83.635   743.762     0.150
     0.522     8.664     0.150
     0.525     8.414     0.150
     0.525    17.055     0.150
     0.871    31.156     0.150
     0.891    31.875     0.150
     1.003    34.375     0.150
     1.441    43.797     0.150
     2.120    63.344     0.150
     3.534    95.344     0.150
     3.694    56.141     0.150
     4.180    62.172     0.150
     4.257   108.969     0.150
     4.794    70.805     0.150
     5.225   135.133     0.150
     6.147    88.859     0.150
     6.520    94.188     0.150
     6.773    96.820     0.150
     7.874   112.312     0.150
     8.970   127.398     0.150
     9.745   136.703     0.150
     9.958   141.375     0.150
     9.958   141.406     0.150
    10.152   143.438     0.150
    10.152   144.445     0.150
    10.236   145.727     0.150
    10.524   146.984     0.150
    10.529   147.086     0.150
    11.953   164.258     0.150
    11.953   296.836     0.150
    11.953   165.742     0.150
    12.196   169.211     0.150
    12.538   172.312     0.150
    12.858   179.664     0.150
    13.343   188.398     0.150
    13.932   193.430     0.150
    14.471   200.672     0.150
    14.489   198.570     0.150
    15.149   209.227     0.150
    16.478  1220.664     0.150
    16.478  1220.750     0.150
    17.002   418.531     0.150
    18.297   446.188     0.150
    18.297   247.734     0.150
    21.812   285.820     0.150
    24.380   531.781     0.150
    24.380   531.836     0.150
    24.380   313.562     0.150
    24.503   748.281     0.150
    27.374   343.938     0.150
    27.374   344.102     0.150
    27.987   346.633     0.150
    27.987   346.672     0.150
    31.578   381.102     0.150
    31.699   377.562     0.150
    32.886   392.734     0.150
    34.640   407.703     0.150
    34.974   728.234     0.150
    35.510   744.133     0.150
    35.510   906.938     0.150
    35.510   410.523     0.150
    35.749   558.336     0.150
    37.214   426.508     0.150
    37.221   429.938     0.150
    37.500   429.234     0.150
    38.487   437.945     0.150
    40.417  1034.336     0.150
    41.906   467.328     0.150
    42.269     6.000     0.150
    42.315   468.688     0.150
    42.963  3242.477     0.150
    42.969  3242.133     0.150
    42.981  3236.781     0.150
    43.702   480.188     0.150
    44.131  3329.078     0.150
    44.145  3324.711     0.150
    44.149  3345.633     0.150
    44.883   492.586     0.150
    44.994   491.297     0.150
    44.994   491.305     0.150
    44.994   820.633     0.150
    45.005    12.703     0.150
    45.005    18.500     0.150
    45.256   489.297     0.150
    46.145   501.336     0.150
    46.306   500.992     0.150
    46.306   501.352     0.150
    46.306   500.883     0.150
    46.339   500.406     0.150
    46.632   504.125     0.150
    47.318  1115.031     0.150
    47.619   510.273     0.150
    47.630   599.898     0.150
    48.477   516.234     0.150
    49.613   526.883     0.150
    49.642   530.836     0.150
    50.278   531.156     0.150
    50.278   531.383     0.150
    50.957   536.578     0.150
    51.391   540.336     0.150
    52.179   544.531     0.150
    52.269    16.000     0.150
    52.755    13.203     0.150
    52.809   550.508     0.150
    52.964   551.977     0.150
    54.051   559.938     0.150
    54.945   565.992     0.150
    55.488   568.734     0.150
    55.488   568.977     0.150
    56.086   573.844     0.150
    56.590   576.336     0.150
    56.958   579.391     0.150
    56.958   579.336     0.150
    56.958   579.477     0.150
    57.365   579.938     0.150
    57.365  1043.938     0.150
    57.365  1163.531     0.150
    57.627     6.500     0.150
    57.745    16.000     0.150
    57.819   586.078     0.150
    57.835   589.531     0.150
    57.950   587.453     0.150
    57.950  1060.125     0.150
    58.555  1067.438     0.150
    58.684    17.000     0.150
    59.252   596.078     0.150
    59.287    17.203     0.150
    60.199   602.273     0.150
    62.946     6.703     0.150
    62.946  1132.234     0.150
    63.239   623.594     0.150
    63.256     9.797     0.150
    63.256  1125.734     0.150
    63.256   623.703     0.150
    63.721   629.438     0.150
    63.764   626.742     0.150
    64.122   629.461     0.150
    64.173   628.938     0.150
    64.363    11.797     0.150
    64.363  1140.031     0.150
    64.600   669.836     0.150
    64.600   631.797     0.150
    64.953   637.945     0.150
    65.479   638.195     0.150
    65.479   638.391     0.150
    65.668   638.438     0.150
    65.777   639.086     0.150
    65.908    20.703     0.150
    66.641   643.875     0.150
    66.789   646.344     0.150
    68.531   657.828     0.150
    68.651   658.445     0.150
    69.317   662.258     0.150
    69.390   662.078     0.150
    69.416   916.734     0.150
    69.416   661.836     0.150
    69.416   662.141     0.150
    69.657   664.367     0.150
    69.810   664.812     0.150
    69.849   666.203     0.150
    69.989   666.844     0.150
    70.210   668.227     0.150
    70.301   668.758     0.150
    70.369   669.062     0.150
    70.705   670.938     0.150
    70.705   670.938     0.150
    70.705   930.336     0.150
    70.705  1693.367     0.150
    70.705   670.938     0.150
    70.705    14.195     0.150
    70.705   827.438     0.150
    70.705   930.336     0.150
    70.705  1221.336     0.150
    70.705  1245.734     0.150
    70.705  1494.531     0.150
    70.730   671.352     0.150
    70.675   671.344     0.150
    70.836   670.484     0.150
    70.876   672.242     0.150
    71.219   674.492     0.150
    71.219   674.578     0.150
    71.565   677.078     0.150
    71.668   678.875     0.150
    71.725   678.172     0.150
    72.132   680.336     0.150
    72.132   680.445     0.150
    72.353   680.453     0.150
    72.836   684.328     0.150
    73.040   685.047     0.150
    73.433   688.758     0.150
    73.492   687.602     0.150
    73.492   687.672     0.150
    73.535    19.297     0.150
    73.535  1259.031     0.150
    73.780   689.812     0.150
    73.816    17.500     0.150
    73.977   690.031     0.150
    73.977   690.234     0.150
    73.977   704.734     0.150
    73.977    18.602     0.150
    73.977  1294.734     0.150
    73.977  1539.734     0.150
    73.977  1743.734     0.150
    73.977  1875.734     0.150
    74.143   691.453     0.150
    74.148   691.711     0.150
    74.210   691.062     0.150
    74.210   691.992     0.150
    74.306   691.555     0.150
    74.334   691.844     0.150
    74.413   692.031     0.150
    74.421   692.133     0.150
    74.421   692.086     0.150
    74.421   692.031     0.150
    74.449   693.297     0.150
    74.449   693.188     0.150
    74.449    17.969     0.150
    74.473  1262.734     0.150
    74.573   694.195     0.150
    74.586   692.312     0.150
    74.601   693.281     0.150
    74.794   695.633     0.150
    74.797   695.633     0.150
    74.816   695.836     0.150
    74.833   695.734     0.150
    74.877   695.938     0.150
    75.025   697.133     0.150
    75.041   697.133     0.150
    75.041   697.195     0.150
    75.160   697.031     0.150
    75.326   698.531     0.150
    75.355   698.836     0.150
    75.518   698.633     0.150
    75.583   700.234     0.150
    75.636   699.438     0.150
    75.722   700.836     0.150
    75.761   700.938     0.150
    75.857   703.242     0.150
    75.878   702.594     0.150
    75.946   701.773     0.150
    76.000   702.031     0.150
    76.077   702.938     0.150
    76.090   702.336     0.150
    76.133   703.484     0.150
    76.176   721.734     0.150
    76.176   703.836     0.150
    76.291   703.961     0.150
    76.514   705.133     0.150
    76.685   706.328     0.150
    76.932   708.133     0.150
    76.941   708.133     0.150
    77.027   708.562     0.150
    77.027   708.664     0.150
    77.025   707.234     0.150
    77.241   709.102     0.150
    77.453    15.625     0.150
    77.509   710.938     0.150
    77.610   711.438     0.150
    77.616    15.703     0.150
    77.673    15.562     0.150
    77.692    15.820     0.150
    77.700   712.133     0.150
    77.700   712.141     0.150
    77.701   711.734     0.150
    77.714   711.734     0.150
    77.840    15.922     0.150
    77.947   713.891     0.150
    78.122    15.703     0.150
    78.127   714.234     0.150
    78.128   713.438     0.150
    78.216   715.641     0.150
    78.229    16.047     0.150
    78.385   715.234     0.150
    78.602   716.234     0.150
    78.657   716.633     0.150
    78.679    15.906     0.150
    78.707   716.469     0.150
    78.812   717.828     0.150
    78.927   718.219     0.150
    78.896   717.758     0.150
    78.962   719.438     0.150
    79.145   719.391     0.150
    79.147   720.234     0.150
    79.204   720.531     0.150
    79.211   719.938     0.150
    79.185   725.734     0.150
    79.377   721.133     0.150
    79.377   721.102     0.150
    79.397   721.234     0.150
    79.505   722.031     0.150
    79.505   721.992     0.150
    79.523   722.234     0.150
    79.523   722.234     0.150
    79.523   722.484     0.150
    79.597  1014.531     0.150
    79.597  1625.336     0.150
    79.597  1833.336     0.150
    79.696   722.438     0.150
    79.709   723.531     0.150
    79.712  1315.734     0.150
    79.790   724.367     0.150
    79.797   722.711     0.150
    79.797   722.633     0.150
    79.837   722.711     0.150
    79.850   723.797     0.150
    79.882   723.094     0.150
    79.882   723.031     0.150
    79.932   723.438     0.150
    79.968   723.875     0.150
    79.984   723.836     0.150
    79.998   723.680     0.150
    79.998   723.633     0.150
    80.133   725.336     0.150
    80.320   725.242     0.150
    80.352   914.734     0.150
    80.352  1021.531     0.150
    80.352  1841.234     0.150
    80.597   727.531     0.150
    80.660   727.586     0.150
    80.660   727.633     0.150
    80.660   728.047     0.150
    80.677   729.062     0.150
    80.628   731.734     0.150
    80.718   728.336     0.150
    80.711   728.242     0.150
    80.765   725.711     0.150
    81.037   730.438     0.150
    81.055   729.312     0.150
    81.062   729.922     0.150
    81.271   730.508     0.150
    81.978   734.531     0.150
    82.224   735.234     0.150
    82.629   742.633     0.150
    82.834   738.984     0.150
    82.933   740.438     0.150
    82.933   740.641     0.150
    82.977   738.531     0.150
    83.210  1364.234     0.150
    83.259   746.133     0.150
    83.404   738.938     0.150
    83.421   748.750     0.150
    83.627  2320.477     0.150
    83.710   744.625     0.150
    83.740   744.273     0.150
    84.222   748.992     0.150
    84.367   747.656     0.150
    84.439   748.484     0.150
    84.549   748.531     0.150
    84.566   748.531     0.150
    84.780   747.844     0.150
    84.797   749.922     0.150
    84.929   750.531     0.150
    84.985   750.836     0.150
    85.092  1379.867     0.150
    85.212   754.734     0.150
    85.212   754.133     0.150
    85.292   751.977     0.150
    85.432   752.234     0.150
    86.216   756.992     0.150
    86.372   756.688     0.150
    87.351   759.531     0.150
    87.399   763.031     0.150
    87.399   770.031     0.150
    87.399   763.125     0.150
    88.219   771.133     0.150
    88.865   775.438     0.150
    88.904   768.594     0.150
    89.754   787.914     0.150
    92.806   794.938     0.150
    93.896   795.938     0.150
    95.734   807.359     0.150
    96.139   801.734     0.150
   112.147  8390.977     0.150
   112.159  8392.891     0.150
   112.164  8382.984     0.150
   134.258  1148.938     0.150
   134.258  1151.844     0.150
   156.953  1202.617     0.150
   157.376  1203.172     0.150
   157.689  1203.344     0.150
   160.085  1193.992     0.150
   163.761  1262.031     0.150
     0.541     8.656     0.150
     0.541    15.953     0.150
     0.544     8.945     0.150
     0.544    15.477     0.150
     0.844    30.273     0.150
     0.866    30.633     0.150
     3.692    55.547     0.150
     4.694    69.383     0.150
     8.615   123.484     0.150
     9.088   130.750     0.150
    11.227   157.414     0.150
    11.929   167.594     0.150
    11.929   163.539     0.150
    12.258   171.609     0.150
    63.839   624.398     0.150
     0.821    23.070     0.150
     1.659    29.117     0.150
     6.027    89.539     0.150
     8.645   124.477     0.150
    10.407   151.961     0.150
    12.092   173.078     0.150
    14.660   212.391     0.150
     0.527    20.467     0.150
     1.117    37.477     0.150
     1.245    40.428     0.150
     1.298    41.348     0.150
     0.514    18.551     0.150
     1.102    20.609     0.150
     1.533    46.359     0.150
     3.201    51.129     0.150
     3.697    57.102     0.150
     5.991    88.520     0.150
     6.768    96.570     0.150
     9.008   130.539     0.150
    11.853   169.641     0.150
    12.033   163.242     0.150
    12.033   168.980     0.150
    14.722   208.242     0.150
    18.373   248.566     0.150
    24.543   316.152     0.150
    31.913   380.859     0.150
    32.655   394.617     0.150
    34.841   413.492     0.150
    47.584   517.172     0.150
    50.296   531.289     0.150
    50.328   531.922     0.150
    55.861   570.590     0.150
    55.861   570.770     0.150
    63.977   627.215     0.150
    79.492   723.090     0.150
     0.544     9.223     0.150
     0.544    16.359     0.150
     0.548     9.387     0.150
     0.548    16.379     0.150
     0.367     9.449     0.150
     0.839    29.930     0.150
     0.862    30.297     0.150
     0.973    34.059     0.150
     5.214    75.023     0.150
     5.214    76.598     0.150
     5.837    84.449     0.150
     6.111    88.398     0.150
     6.735    95.949     0.150
     7.523   107.492     0.150
     8.327   118.273     0.150
     8.651   122.027     0.150
     9.553   134.160     0.150
     9.725   136.477     0.150
     9.761   137.566     0.150
    10.146   143.977     0.150
    10.899   152.941     0.150
    11.926   163.406     0.150
    11.926   167.508     0.150
    11.926   167.539     0.150
    12.484   173.391     0.150
    13.314   187.625     0.150
    13.419   187.523     0.150
    13.613   191.293     0.150
    14.411   200.207     0.150
    15.555   216.402     0.150
    15.954   221.562     0.150
    16.488  1216.777     0.150
    16.488  1217.422     0.150
    18.273   248.242     0.150
    23.852   562.707     0.150
    23.852   308.906     0.150
    23.852   308.629     0.150
    24.491   544.258     0.150
    24.491   314.668     0.150
    24.548   316.078     0.150
    27.385   341.238     0.150
    32.730   566.184     0.150
    33.320   394.008     0.150
    33.709   396.609     0.150
    34.927   407.977     0.150
    34.951   734.707     0.150
    35.475   495.809     0.150
    35.475   738.707     0.150
    35.475   885.809     0.150
    35.475   408.879     0.150
    35.728   414.547     0.150
    37.222   427.469     0.150
    41.924     9.500     0.150
    41.924     8.578     0.150
    42.240    17.801     0.150
    42.280   467.008     0.150
    42.280   467.047     0.150
    42.978  3232.984     0.150
    42.984  3242.512     0.150
    42.996  3236.781     0.150
    43.682   479.957     0.150
    43.682    11.379     0.150
    44.147  3325.258     0.150
    44.160  3324.945     0.150
    44.164  3329.398     0.150
    44.979   490.836     0.150
    44.979   490.609     0.150
    46.130   501.809     0.150
    46.490   502.359     0.150
    46.602   503.707     0.150
    46.602   502.359     0.150
    47.084   506.008     0.150
    47.293    11.699     0.150
    47.593   510.977     0.150
    47.593   511.066     0.150
    47.593   511.039     0.150
    48.268   514.227     0.150
    49.624   526.289     0.150
    50.257   530.906     0.150
    51.522   541.656     0.150
    52.036   544.609     0.150
    52.241    17.301     0.150
    52.731    14.000     0.150
    54.355   638.547     0.150
    54.355   561.789     0.150
    54.355   626.359     0.150
    54.999   566.117     0.150
    55.449   568.078     0.150
    55.449   567.906     0.150
    55.449    19.961     0.150
    55.691   571.699     0.150
    55.713   570.328     0.150
    56.919   579.109     0.150
    56.919    14.207     0.150
    57.716    12.801     0.150
    57.780   585.148     0.150
    59.214   595.398     0.150
    60.161   601.297     0.150
    60.928    15.801     0.150
    62.767   619.578     0.150
    62.923   620.008     0.150
    62.923    17.801     0.150
    63.767    17.500     0.150
    64.085   629.566     0.150
    64.136   628.109     0.150
    64.340   631.727     0.150
    64.334    11.699     0.150
    64.334    16.699     0.150
    64.455   633.207     0.150
    64.560    13.801     0.150
    64.560   631.297     0.150
    65.443   638.988     0.150
    65.466   639.066     0.150
    65.631   638.727     0.150
    65.813   639.289     0.150
    65.872    13.500     0.150
    67.722   649.699     0.150
    68.404    15.500     0.150
    68.613   658.520     0.150
    68.762     8.000     0.150
    68.762  1202.008     0.150
    69.376   678.609     0.150
    69.619   664.637     0.150
    69.773   664.746     0.150
    69.813   666.047     0.150
    69.811   666.207     0.150
    69.952   667.047     0.150
    70.172   668.207     0.150
    70.264   668.848     0.150
    70.331   669.129     0.150
    70.666   670.047     0.150
    70.666   670.047     0.150
    70.666    13.832     0.150
    70.666   930.086     0.150
    70.666  1693.887     0.150
    70.666   670.008     0.150
    70.666    13.801     0.150
    70.666   825.609     0.150
    70.666   930.008     0.150
    70.666  1221.508     0.150
    70.666  1495.309     0.150
    70.692   671.637     0.150
    70.637   671.398     0.150
    70.838   672.527     0.150
    71.528   677.449     0.150
    71.631   677.078     0.150
    71.687   676.207     0.150
    71.687   676.188     0.150
    72.456   683.109     0.150
    72.575   681.508     0.150
    73.002   685.207     0.150
    73.099   684.816     0.150
    73.273   688.098     0.150
    73.394   689.086     0.150
    73.509   689.508     0.150
    73.509    15.500     0.150
    73.509  1257.508     0.150
    73.656   689.488     0.150
    73.742   690.309     0.150
    73.940   690.508     0.150
    73.940   690.508     0.150
    73.940    11.500     0.150
    73.940    16.301     0.150
    73.940  1262.008     0.150
    73.940  1550.008     0.150
    73.940  1760.008     0.150
    73.940  1874.008     0.150
    74.104   691.738     0.150
    74.110   692.078     0.150
    74.346   691.207     0.150
    74.349   691.109     0.150
    74.382   691.547     0.150
    74.382   691.418     0.150
    74.382   691.246     0.150
    74.412   694.047     0.150
    74.419   691.508     0.150
    74.537   694.707     0.150
    74.537   694.719     0.150
    74.551   694.688     0.150
    74.721    17.801     0.150
    74.760   695.906     0.150
    74.779   695.406     0.150
    75.004   696.609     0.150
    75.169   698.297     0.150
    75.169   698.086     0.150
    75.288   698.207     0.150
    75.318   698.406     0.150
    75.484   698.809     0.150
    75.545   698.168     0.150
    75.599   700.008     0.150
    75.599   699.207     0.150
    75.599   716.508     0.150
    75.684   699.906     0.150
    75.684   699.930     0.150
    75.826   700.809     0.150
    75.826   702.758     0.150
    75.840   701.609     0.150
    75.840   701.586     0.150
    75.962   700.508     0.150
    75.962   700.508     0.150
    76.052   703.207     0.150
    76.052   719.109     0.150
    76.096   704.309     0.150
    76.096   704.348     0.150
    76.139   703.906     0.150
    76.239   704.406     0.150
    76.295   704.906     0.150
    76.295   720.508     0.150
    76.295   705.098     0.150
    76.430   705.137     0.150
    76.430   705.508     0.150
    76.478   706.109     0.150
    76.478   706.109     0.150
    76.519   723.207     0.150
    76.800   706.438     0.150
    76.895   707.609     0.150
    76.986   708.008     0.150
    76.999   709.879     0.150
    76.999   708.609     0.150
    77.020   709.008     0.150
    77.228   709.117     0.150
    77.242    16.891     0.150
    77.416   710.125     0.150
    77.416    16.812     0.150
    77.446    17.262     0.150
    77.472   711.406     0.150
    77.516   710.008     0.150
    77.516   710.289     0.150
    77.655   711.625     0.150
    77.655    16.992     0.150
    77.662   712.207     0.150
    77.800    16.559     0.150
    77.804   712.055     0.150
    77.804    17.289     0.150
    77.911   714.406     0.150
    77.911    16.359     0.150
    77.911   714.418     0.150
    77.930    16.629     0.150
    78.089   715.609     0.150
    78.085    16.891     0.150
    78.100    16.625     0.150
    78.146   715.609     0.150
    78.179    17.289     0.150
    78.179   715.270     0.150
    78.469   717.867     0.150
    78.471    17.094     0.150
    78.554   715.098     0.150
    78.642    16.941     0.150
    78.669   718.301     0.150
    78.795   717.312     0.150
    79.174   720.586     0.150
    79.339   721.508     0.150
    79.370   721.707     0.150
    79.358   722.008     0.150
    79.432   717.406     0.150
    79.483   721.918     0.150
    79.557  1015.707     0.150
    79.557  1323.508     0.150
    79.557  1636.707     0.150
    79.752   723.906     0.150
    79.759   723.809     0.150
    79.759   722.270     0.150
    79.844   724.906     0.150
    79.844   725.066     0.150
    79.929   725.770     0.150
    79.945   724.809     0.150
    79.960   724.309     0.150
    80.247   726.973     0.150
    80.312   905.906     0.150
    80.312  1017.707     0.150
    80.312  1643.809     0.150
    80.312  1849.609     0.150
    80.424   726.828     0.150
    80.424   726.867     0.150
    80.642   729.387     0.150
    80.644   728.406     0.150
    80.685   728.457     0.150
    80.933  1026.609     0.150
    80.976   729.309     0.150
    80.976   729.289     0.150
    81.029   729.148     0.150
    81.233   730.648     0.150
    81.578   733.199     0.150
    81.738   734.570     0.150
    81.861   734.848     0.150
    83.596   742.707     0.150
    83.702   744.996     0.150
    83.744   746.148     0.150
    83.911   744.137     0.150
    84.105   745.938     0.150
    84.184   748.727     0.150
    84.209   746.777     0.150
    84.328   747.949     0.150
    84.401   748.867     0.150
    84.511   749.508     0.150
    84.511   749.539     0.150
    84.889   749.809     0.150
    85.253   752.809     0.150
    85.253   752.816     0.150
    85.514   755.246     0.150
    92.827   786.156     0.150
    96.192   802.246     0.150
   112.177  8389.598     0.150
   112.188  8388.211     0.150
   112.193  8387.375     0.150
   147.578  1180.148     0.150
   156.258  1199.832     0.150
   160.125  1243.828     0.150
     0.493    15.578     0.150
     0.950    32.789     0.150
     1.493    25.637     0.150
    24.415   311.988     0.150
    42.935  3241.770     0.150
    42.941  3245.215     0.150
    42.953  3238.074     0.150
    44.103  3346.121     0.150
    44.117  3347.254     0.150
    44.121  3347.047     0.150
    54.440   561.195     0.150
    55.816   570.695     0.150
     1.407    25.266     0.150
     3.414    53.039     0.150
     3.516    54.789     0.150
     4.112    62.488     0.150
     4.165    63.266     0.150
     4.317    61.809     0.150
     4.278    64.238     0.150
     4.586    64.699     0.150
     4.790    68.957     0.150
     4.845    69.598     0.150
     5.190   132.246     0.150
     5.177    76.238     0.150
     5.265    76.016     0.150
     5.982    85.637     0.150
     6.310    89.988     0.150
     6.555    93.078     0.150
     7.421   105.289     0.150
    15.390   211.086     0.150
    42.992  3236.945     0.150
    42.998  3239.977     0.150
    43.010  3221.969     0.150
    44.160  3340.234     0.150
    44.174  3340.555     0.150
    44.178  3297.895     0.150
    45.057   489.227     0.150
    50.344   531.426     0.150
    65.197   636.109     0.150
    68.531   658.484     0.150
    74.445   692.988     0.150
     0.474    15.801     0.150
     1.459    44.520     0.150
     1.459    25.080     0.150
    42.972  3252.588     0.150
    42.979  3255.814     0.150
    42.990  3258.600     0.150
    44.141  3341.791     0.150
    44.154  3341.717     0.150
    44.158  3343.736     0.150
   112.092  8386.436     0.150
   112.103  8387.885     0.150
   112.108  8388.264     0.150
     0.374     8.484     0.150
     0.518     8.750     0.150
     0.522     8.414     0.150
     0.522    17.742     0.150
     0.888    31.555     0.150
     0.902    17.922     0.150
     1.051    35.473     0.150
     3.169    86.211     0.150
     3.713    56.422     0.150
     3.713    56.398     0.150
     4.255    63.230     0.150
     4.311    63.836     0.150
     4.599    65.703     0.150
     5.140    75.109     0.150
     5.198    74.180     0.150
     5.736    82.977     0.150
     5.847    84.812     0.150
     6.182    89.945     0.150
     7.792   110.996     0.150
     7.833   110.836     0.150
     8.351   117.973     0.150
     8.908   125.781     0.150
     8.908   125.793     0.150
     9.016   127.742     0.150
     9.335   131.504     0.150
     9.714   136.172     0.150
     9.875   142.691     0.150
     9.930   140.992     0.150
     9.930   141.070     0.150
    10.169   144.852     0.150
    10.317   144.344     0.150
    10.508   149.188     0.150
    10.546   147.992     0.150
    10.991   155.301     0.150
    11.107   155.184     0.150
    11.107   155.109     0.150
    13.169   185.605     0.150
    13.176   186.289     0.150
    13.682   187.965     0.150
    13.740   195.324     0.150
    14.179   197.234     0.150
    14.366   201.453     0.150
    14.406   196.820     0.150
    15.053   208.207     0.150
    15.159   212.582     0.150
    15.382   211.961     0.150
    15.521   211.684     0.150
    15.891   215.867     0.150
    15.948   216.715     0.150
    16.464  1227.055     0.150
    16.464   403.781     0.150
    16.464  1226.961     0.150
    16.979   413.957     0.150
    19.307   479.406     0.150
    23.878   556.281     0.150
    23.878    10.398     0.150
    26.265   686.684     0.150
    29.129   359.984     0.150
    29.842   367.184     0.150
    31.666   377.684     0.150
    32.704  2266.680     0.150
    32.814   388.711     0.150
    32.878   393.383     0.150
    34.631   405.914     0.150
    34.856  2259.934     0.150
    34.977   742.281     0.150
    35.133   409.055     0.150
    35.499   486.684     0.150
    35.499   513.082     0.150
    35.499   877.383     0.150
    35.499  1032.484     0.150
    35.499   410.582     0.150
    35.754   509.984     0.150
    35.754   561.762     0.150
    37.508   429.484     0.150
    41.357   465.082     0.150
    42.266   846.883     0.150
    42.992  3222.062     0.150
    42.998  3222.516     0.150
    43.010  3244.773     0.150
    43.671   480.102     0.150
    44.059   483.273     0.150
    44.160  3275.371     0.150
    44.174  3276.395     0.150
    44.178  3270.270     0.150
    44.518    18.500     0.150
    45.005    13.500     0.150
    45.004   491.004     0.150
    45.967   497.652     0.150
    46.275   501.145     0.150
    46.275   501.242     0.150
    46.275   501.184     0.150
    46.586   502.305     0.150
    46.599   503.441     0.150
    47.319    17.500     0.150
    47.532   511.793     0.150
    47.529   509.594     0.150
    47.586   511.523     0.150
    47.586   511.543     0.150
    47.586   511.402     0.150
    47.623   831.855     0.150
    48.264   518.062     0.150
    48.323   520.074     0.150
    49.600   526.555     0.150
    49.658   525.281     0.150
    49.807   528.383     0.150
    50.283   532.223     0.150
    50.962   537.453     0.150
    50.962   537.543     0.150
    51.136   538.234     0.150
    51.560   542.582     0.150
    51.752   542.762     0.150
    51.752   542.691     0.150
    51.875  3865.340     0.150
    52.146   544.363     0.150
    52.267    11.500     0.150
    52.267    19.199     0.150
    52.267  1006.684     0.150
    52.753   550.871     0.150
    52.776   551.203     0.150
    52.757    12.500     0.150
    52.757    17.301     0.150
    53.392   556.031     0.150
    54.043   559.484     0.150
    54.931    15.500     0.150
    54.945   566.484     0.150
    55.130   567.352     0.150
    55.721   570.461     0.150
    55.982   574.113     0.150
    56.061   576.781     0.150
    56.557   578.164     0.150
    56.787    19.000     0.150
    56.929   579.383     0.150
    57.177    17.500     0.150
    57.336  1057.383     0.150
    57.627  1055.383     0.150
    57.741    12.801     0.150
    57.741    18.000     0.150
    58.620  1069.684     0.150
    58.690  1071.184     0.150
    58.903   593.672     0.150
    59.292    17.000     0.150
    60.954    13.301     0.150
    62.949    17.500     0.150
    63.256     9.000     0.150
    63.662  1139.582     0.150
    63.746   626.344     0.150
    63.730   627.191     0.150
    63.809   626.613     0.150
    63.792    17.699     0.150
    63.792  1132.184     0.150
    64.108   629.254     0.150
    64.141   628.883     0.150
    64.323   631.602     0.150
    64.359    14.000     0.150
    64.576   866.184     0.150
    64.847  1149.684     0.150
    65.551  1157.883     0.150
    65.586   639.914     0.150
    65.762   639.602     0.150
    65.762   639.672     0.150
    65.762   639.484     0.150
    65.895    15.000     0.150
    66.601   647.074     0.150
    66.601   646.703     0.150
    66.767   644.871     0.150
    68.089   654.902     0.150
    68.429    17.500     0.150
    68.489  2350.234     0.150
    68.498   657.043     0.150
    68.548   656.961     0.150
    68.635   658.324     0.150
    68.787  1199.684     0.150
    69.138   661.414     0.150
    69.232   659.184     0.150
    69.232  1199.684     0.150
    69.284   662.082     0.150
    69.357   662.723     0.150
    69.387   661.684     0.150
    69.387   679.281     0.150
    69.387   661.691     0.150
    69.641   664.684     0.150
    69.795   664.531     0.150
    69.833   665.914     0.150
    69.889   664.422     0.150
    69.974   666.602     0.150
    70.286   668.562     0.150
    70.353   668.902     0.150
    70.675   670.902     0.150
    70.675   670.902     0.150
    70.675   930.203     0.150
    70.675  1507.621     0.150
    70.675  1694.094     0.150
    70.675   670.883     0.150
    70.675   827.281     0.150
    70.675   930.184     0.150
    70.675  1222.184     0.150
    70.714   671.172     0.150
    70.659   671.211     0.150
    70.779   672.254     0.150
    70.809   671.703     0.150
    70.860   672.055     0.150
    71.335   673.914     0.150
    71.526   676.223     0.150
    71.549   676.621     0.150
    71.549   676.664     0.150
    71.653   677.574     0.150
    71.708   677.812     0.150
    71.708   677.863     0.150
    71.916   679.172     0.150
    72.116   680.352     0.150
    72.116   680.031     0.150
    72.116   679.992     0.150
    72.184    16.230     0.150
    72.512   682.383     0.150
    72.597   683.902     0.150
    72.637   682.973     0.150
    73.023   684.992     0.150
    73.119   685.602     0.150
    73.119   685.293     0.150
    73.415   684.484     0.150
    73.460   687.422     0.150
    73.535    19.000     0.150
    73.535  1258.383     0.150
    73.813   689.941     0.150
    73.835   689.691     0.150
    73.835   688.902     0.150
    73.945   689.832     0.150
    73.945   689.891     0.150
    73.945   689.883     0.150
    73.945   704.984     0.150
    73.945  1257.883     0.150
    73.945  1753.883     0.150
    73.945  1855.883     0.150
    74.124   691.441     0.150
    74.130   691.555     0.150
    74.208   690.184     0.150
    74.359   692.082     0.150
    74.384   691.672     0.150
    74.391   692.184     0.150
    74.391   692.184     0.150
    74.391   691.941     0.150
    74.391   692.012     0.150
    74.417   692.922     0.150
    74.417   699.691     0.150
    74.417  1260.883     0.150
    74.428   692.484     0.150
    74.445   692.582     0.150
    74.449   692.582     0.150
    74.478   694.383     0.150
    74.478    13.000     0.150
    74.478    18.000     0.150
    74.478   694.402     0.150
    74.478    18.852     0.150
    74.541   693.941     0.150
    74.743    16.000     0.150
    74.743  1264.383     0.150
    74.766   695.281     0.150
    74.784   695.781     0.150
    74.801   695.984     0.150
    74.846  1262.184     0.150
    74.846   695.984     0.150
    74.846  1262.184     0.150
    75.010   696.883     0.150
    75.010  1267.781     0.150
    75.010   696.793     0.150
    75.128   697.434     0.150
    75.128   697.402     0.150
    75.176   696.711     0.150
    75.176   697.312     0.150
    75.294   698.582     0.150
    75.323   698.484     0.150
    75.323  1272.281     0.150
    75.470   699.832     0.150
    75.485   698.781     0.150
    75.552   699.883     0.150
    75.552   699.895     0.150
    75.605   700.152     0.150
    75.705   700.504     0.150
    75.851   703.293     0.150
    75.851   700.883     0.150
    75.861   702.645     0.150
    75.894    16.500     0.150
    75.970   702.281     0.150
    76.045   702.984     0.150
    76.058   702.184     0.150
    76.144   703.582     0.150
    76.144   707.883     0.150
    76.144  1283.484     0.150
    76.246   705.281     0.150
    76.259   704.172     0.150
    76.259    15.309     0.150
    76.438   705.082     0.150
    76.483  1280.984     0.150
    76.483   705.484     0.150
    76.483  1280.984     0.150
    76.634   706.031     0.150
    76.634   705.961     0.150
    76.653   705.902     0.150
    76.653   705.934     0.150
    76.901   707.582     0.150
    76.911   708.984     0.150
    76.996   708.223     0.150
    76.995   707.184     0.150
    76.995   707.281     0.150
    77.006   708.984     0.150
    77.248    17.691     0.150
    77.422    17.461     0.150
    77.451    17.684     0.150
    77.479   711.324     0.150
    77.479   711.371     0.150
    77.537   710.914     0.150
    77.585    18.023     0.150
    77.598   713.473     0.150
    77.642    17.820     0.150
    77.661    17.492     0.150
    77.614   726.781     0.150
    77.670   712.281     0.150
    77.670   712.395     0.150
    77.671   711.281     0.150
    77.784    18.180     0.150
    77.804    17.398     0.150
    77.809    17.590     0.150
    77.915    17.484     0.150
    77.934    17.699     0.150
    78.090    18.605     0.150
    78.104    17.879     0.150
    78.184    17.746     0.150
    78.184   715.242     0.150
    78.198    17.539     0.150
    78.473   717.242     0.150
    78.627   717.184     0.150
    78.645    17.684     0.150
    78.648    17.582     0.150
    78.800    17.688     0.150
    78.891   717.914     0.150
    78.891    23.277     0.150
    79.118   720.395     0.150
    79.311   720.133     0.150
    79.348   720.781     0.150
    79.367   721.082     0.150
    79.497   722.242     0.150
    79.497   722.203     0.150
    79.570   721.762     0.150
    79.572    20.598     0.150
    79.572  1008.684     0.150
    79.666   723.082     0.150
    79.684  1324.883     0.150
    79.761   724.184     0.150
    79.761   724.211     0.150
    79.761   724.062     0.150
    79.766   722.684     0.150
    79.805   724.984     0.150
    79.852   724.082     0.150
    79.938   725.043     0.150
    79.955   723.684     0.150
    79.968   724.484     0.150
    80.103   725.082     0.150
    80.325  1017.582     0.150
    80.447   727.371     0.150
    80.447   727.473     0.150
    80.556   891.922     0.150
    80.629   728.438     0.150
    80.629   728.055     0.150
    80.629   727.383     0.150
    80.629   728.191     0.150
    80.654   727.484     0.150
    80.688   728.082     0.150
    80.711   728.434     0.150
    80.763   728.645     0.150
    80.851   729.934     0.150
    80.949   909.484     0.150
    80.949  1028.582     0.150
    80.936   729.805     0.150
    81.002   730.324     0.150
    81.254   730.461     0.150
    81.576   907.031     0.150
    81.952   736.004     0.150
    82.629   737.082     0.150
    82.663   743.883     0.150
    82.825   740.664     0.150
    82.849   738.781     0.150
    82.902   740.953     0.150
    82.902   738.383     0.150
    82.967   739.871     0.150
    82.967   739.883     0.150
    83.177   928.395     0.150
    83.210   740.984     0.150
    83.483   741.082     0.150
    83.576   745.102     0.150
    83.855   744.945     0.150
    83.986   748.082     0.150
    84.338   747.574     0.150
    84.533   748.953     0.150
    84.533   748.883     0.150
    84.533   748.844     0.150
    84.830   752.984     0.150
    84.952   751.082     0.150
    85.059  1380.852     0.150
    85.059   752.223     0.150
    85.168   753.414     0.150
    85.204   751.633     0.150
    85.261   751.961     0.150
    86.185   756.305     0.150
    86.185   756.441     0.150
    86.301   755.082     0.150
    87.427   762.363     0.150
    88.104   762.082     0.150
    88.209   766.543     0.150
    88.746   768.902     0.150
    88.874   769.121     0.150
    92.314  1447.344     0.150
    92.832   787.434     0.150
    92.845   787.242     0.150
    96.209   802.914     0.150
    98.716   814.684     0.150
    98.716   814.684     0.150
    98.716   814.723     0.150
   104.487   844.059     0.150
   110.479  1778.359     0.150
   112.151  8391.930     0.150
   112.163  8390.902     0.150
   112.168  8391.387     0.150
   134.290  1148.609     0.150
   139.820  1155.527     0.150
   144.256  1169.062     0.150
   144.844  1170.156     0.150
   144.844  1170.094     0.150
   147.583  1178.121     0.150
     0.912    17.234     0.150
     0.912    17.238     0.150
     0.912    26.777     0.150
     0.902    18.383     0.150
     0.915    18.293     0.150
     0.873    17.684     0.150
     0.890    17.984     0.150
     0.890    29.922     0.150
     0.956    16.953     0.150
     0.956    27.645     0.150
     0.959    19.773     0.150
     0.959    17.039     0.150
     0.959    26.445     0.150
     1.554    29.703     0.150
     1.675    31.211     0.150
     1.675    53.152     0.150
     1.960    33.594     0.150
     1.743    32.562     0.150
     1.984    34.199     0.150
     2.575    41.754     0.150
     2.689    45.703     0.150
     2.732    46.973     0.150
     2.761    47.234     0.150
     2.834    47.473     0.150
     2.844    47.801     0.150
     2.849    48.434     0.150
     2.859    48.051     0.150
     2.880    48.422     0.150
     3.215    52.473     0.150
     3.215    52.406     0.150
     3.310    54.352     0.150
     3.364    54.582     0.150
     3.441    55.832     0.150
     3.477    56.734     0.150
     4.110    63.344     0.150
     4.110    63.270     0.150
     4.144    65.914     0.150
     4.226    67.121     0.150
     4.283    67.613     0.150
     4.411    69.363     0.150
     4.719    69.133     0.150
     4.753    71.551     0.150
     4.753    71.461     0.150
     4.842    72.984     0.150
     4.918    73.781     0.150
     5.188    75.691     0.150
     5.188    75.754     0.150
     5.386    83.441     0.150
     5.686    82.883     0.150
     5.794    83.934     0.150
     5.794    83.879     0.150
     6.383    93.230     0.150
     6.472    94.996     0.150
     7.170   103.941     0.150
     7.653   110.859     0.150
     7.792   112.539     0.150
     8.209   119.500     0.150
     8.341   120.414     0.150
     8.141   120.062     0.150
     8.441   120.383     0.150
     9.213   134.781     0.150
     9.267   135.703     0.150
     9.687   140.773     0.150
     9.687   143.164     0.150
    10.158   144.105     0.150
    12.513   303.039     0.150
    15.439   216.555     0.150
    16.919  1243.188     0.150
    16.919  1243.129     0.150
    18.864   255.074     0.150
    22.383   292.977     0.150
    23.578   552.273     0.150
    23.578     9.801     0.150
    23.578   309.184     0.150
    24.091   533.902     0.150
    25.517   326.691     0.150
    25.851   329.871     0.150
    25.851   329.852     0.150
    27.804   348.871     0.150
    30.196   372.074     0.150
    30.196   372.242     0.150
    35.003   412.672     0.150
    35.480     9.602     0.150
    35.480   763.773     0.150
    35.480  1034.574     0.150
    35.480   413.133     0.150
    35.441   892.574     0.150
    37.162   429.941     0.150
    37.162   430.422     0.150
    37.163   429.973     0.150
    37.663   434.082     0.150
    37.663   434.441     0.150
    38.787   442.773     0.150
    41.665   465.574     0.150
    41.665   465.594     0.150
    42.387  3182.004     0.150
    42.393  3209.375     0.150
    42.405  3202.559     0.150
    42.782   474.773     0.150
    43.555  3261.047     0.150
    43.569  3262.176     0.150
    43.572  3262.363     0.150
    44.278   487.344     0.150
    44.613   491.184     0.150
    46.739   506.664     0.150
    46.739   506.754     0.150
    46.739   506.551     0.150
    46.828   506.551     0.150
    46.802   506.164     0.150
    46.882   509.094     0.150
    47.164   510.883     0.150
    47.964   835.273     0.150
    48.180   517.961     0.150
    48.180   518.184     0.150
    48.941   522.973     0.150
    48.941   607.762     0.150
    49.966   532.773     0.150
    51.906   545.922     0.150
    52.084    14.000     0.150
    52.238   548.453     0.150
    52.238   549.152     0.150
    53.076   555.234     0.150
    53.954   561.504     0.150
    55.884   574.043     0.150
    56.152   575.863     0.150
    56.152   634.531     0.150
    57.327   584.172     0.150
    57.571    12.801     0.150
    57.571    18.000     0.150
    57.738   584.574     0.150
    57.738   711.473     0.150
    58.463   596.172     0.150
    58.997   645.824     0.150
    60.718    13.199     0.150
    63.040    13.500     0.150
    63.680    12.199     0.150
    63.854   630.184     0.150
    64.233   631.473     0.150
    64.621   634.273     0.150
    64.832   635.602     0.150
    65.823   642.562     0.150
    65.898    13.699     0.150
    67.569   653.113     0.150
    68.229    14.301     0.150
    68.635   660.812     0.150
    68.688  1202.973     0.150
    69.032   663.023     0.150
    69.502   664.152     0.150
    69.756   678.473     0.150
    69.756   666.684     0.150
    69.697   667.562     0.150
    70.250   670.461     0.150
    70.368   669.961     0.150
    71.086   675.672     0.150
    71.086   675.672     0.150
    71.086   935.754     0.150
    71.086  1695.434     0.150
    71.086   675.672     0.150
    71.086   832.574     0.150
    71.086   935.672     0.150
    71.086  1229.773     0.150
    71.086  1501.871     0.150
    71.086  1695.371     0.150
    71.674   677.512     0.150
    72.203   683.645     0.150
    73.237   688.672     0.150
    73.766   692.512     0.150
    73.525   693.973     0.150
    73.903   693.145     0.150
    74.039   693.883     0.150
    74.424   695.172     0.150
    74.424    11.402     0.150
    74.470   696.262     0.150
    74.685   696.703     0.150
    74.792   696.973     0.150
    74.792   696.984     0.150
    74.792   697.023     0.150
    74.891   698.484     0.150
    74.891   698.363     0.150
    74.891   704.973     0.150
    75.140   700.082     0.150
    75.231   700.473     0.150
    75.266   701.074     0.150
    75.294   701.012     0.150
    75.311   700.973     0.150
    75.474    14.398     0.150
    75.474   702.273     0.150
    75.474    14.398     0.150
    75.474   702.332     0.150
    75.623   702.613     0.150
    75.623   702.672     0.150
    75.623   702.574     0.150
    75.635   703.371     0.150
    75.795   703.574     0.150
    75.795   717.371     0.150
    75.737   702.473     0.150
    76.016   704.172     0.150
    76.007    14.199     0.150
    76.007   705.172     0.150
    76.007    14.199     0.150
    76.064   705.273     0.150
    76.064   704.871     0.150
    76.064   705.273     0.150
    76.399   705.363     0.150
    76.410   707.172     0.150
    76.521   708.113     0.150
    76.581   708.414     0.150
    76.621   708.973     0.150
    76.621    13.801     0.150
    76.695   709.371     0.150
    76.873   710.551     0.150
    76.873   710.473     0.150
    76.956   710.074     0.150
    77.134   710.914     0.150
    77.157   711.492     0.150
    77.353   712.574     0.150
    77.398   711.871     0.150
    77.465   714.074     0.150
    77.465   714.074     0.150
    78.663   720.781     0.150
    79.004   721.773     0.150
    79.004   721.734     0.150
    79.055   722.273     0.150
    79.758   725.773     0.150
    79.758   725.852     0.150
    79.778   725.973     0.150
    79.828   722.973     0.150
    79.808   726.734     0.150
    79.849   901.773     0.150
    79.849  1325.973     0.150
    79.849  1639.172     0.150
    80.175   728.691     0.150
    80.204   728.172     0.150
    80.204   728.234     0.150
    80.272   728.973     0.150
    80.272   728.934     0.150
    80.357   728.773     0.150
    80.399   729.574     0.150
    80.495   730.254     0.150
    80.473   729.863     0.150
    80.655  1330.273     0.150
    80.655  1642.473     0.150
    80.655  1849.371     0.150
    80.590   730.793     0.150
    81.054   732.773     0.150
    81.152   731.551     0.150
    81.220  1028.074     0.150
    81.425   732.332     0.150
    81.340   733.621     0.150
    81.340   733.613     0.150
    81.530   735.102     0.150
    81.587   735.273     0.150
    83.113   744.871     0.150
    83.917   747.324     0.150
    85.523   755.973     0.150
    86.649   761.383     0.150
    86.823   763.172     0.150
    86.823   763.172     0.150
    92.261   787.742     0.150
    94.758   798.164     0.150
    98.958   818.672     0.150
   112.315  8418.645     0.150
   112.326  8421.676     0.150
   112.331  8429.652     0.150
   153.690  1196.473     0.150
   159.929  1196.566     0.150
   159.929  1241.312     0.150
     1.464    24.352     0.150
     1.464    41.793     0.150
     3.225    89.582     0.150
     3.296    92.109     0.150
     3.324    91.941     0.150
     6.676    97.902     0.150
    11.974   162.145     0.150
    27.973   346.543     0.150
    32.500   387.172     0.150
    50.291   530.262     0.150
    64.501   629.922     0.150
    74.441   693.211     0.150
    83.652   745.320     0.150
     0.850    25.922     0.150
     1.946    33.121     0.150
     3.428    98.191     0.150
     3.594   101.012     0.150
     5.708   170.715     0.150
     5.878    88.984     0.150
     8.257   123.824     0.150
    12.466   171.223     0.150
    42.467  3180.285     0.150
    42.473  3176.613     0.150
    42.485  3181.645     0.150
    43.635  3260.910     0.150
    43.648  3261.984     0.150
    43.652  3262.133     0.150
    44.734   490.777     0.150
    50.087   533.617     0.150
    64.047   630.594     0.150
    64.254   632.211     0.150
    64.254   632.441     0.150
    65.803   643.172     0.150
    74.811   697.449     0.150
    80.041   727.023     0.150
    84.124   749.027     0.150
    85.301   755.672     0.150
     1.515    26.848     0.150
     1.781    48.336     0.150
     2.015    32.945     0.150
     3.169    88.469     0.150
     3.287    50.957     0.150
     4.281    62.387     0.150
     4.366    65.066     0.150
     4.366    65.477     0.150
     4.438    66.277     0.150
     4.520    67.059     0.150
     4.537    67.656     0.150
     5.125    75.195     0.150
     5.160    75.637     0.150
     5.327    77.797     0.150
     5.914    85.867     0.150
     6.816    97.656     0.150
     6.818    97.637     0.150
     6.897    99.605     0.150
     7.561   107.496     0.150
     7.754   111.078     0.150
     7.799   111.297     0.150
     8.239   117.027     0.150
     8.283   118.066     0.150
     8.450   119.898     0.150
     8.591   121.637     0.150
     8.997   126.488     0.150
     9.772   136.898     0.150
    10.083   140.879     0.150
    10.060   141.957     0.150
    10.278   145.578     0.150
    10.554   147.219     0.150
    11.245   154.418     0.150
    11.303   158.355     0.150
    11.391   156.996     0.150
    11.369   160.195     0.150
    13.033   180.766     0.150
    13.487   187.379     0.150
    13.868   192.176     0.150
    14.505   199.148     0.150
    14.507   201.246     0.150
    15.249   210.086     0.150
    15.249  1133.867     0.150
    15.249  1129.547     0.150
    16.276   223.906     0.150
    16.382   225.977     0.150
    18.091   246.457     0.150
    18.091   250.488     0.150
    23.513   306.906     0.150
    23.693   307.488     0.150
    24.236   313.316     0.150
    24.236   313.289     0.150
    24.633   321.617     0.150
    25.626   325.367     0.150
    26.693   335.977     0.150
    26.800   337.219     0.150
    27.307   341.227     0.150
    27.346   341.309     0.150
    28.045   346.289     0.150
    28.479   351.277     0.150
    28.628   356.137     0.150
    30.326   368.066     0.150
    30.344   368.129     0.150
    30.500   369.367     0.150
    30.750   371.219     0.150
    30.750   371.219     0.150
    31.438   378.797     0.150
    31.709   380.637     0.150
    31.808   379.977     0.150
    33.412   398.387     0.150
    34.033   400.219     0.150
    34.135   401.117     0.150
    34.135   401.148     0.150
    35.584   414.316     0.150
    35.584   414.348     0.150
    35.987   419.496     0.150
    35.987   420.105     0.150
    36.326   420.906     0.150
    36.957   426.297     0.150
    37.108   426.617     0.150
    37.815   434.879     0.150
    37.912   433.957     0.150
    40.160   455.906     0.150
    40.160   455.828     0.150
    41.701   463.816     0.150
    42.157   469.668     0.150
    42.905   475.566     0.150
    43.898  3326.672     0.150
    43.904  3327.121     0.150
    43.916  3328.113     0.150
    44.640   592.316     0.150
    45.058  3413.285     0.150
    45.072  3414.363     0.150
    45.076  3414.676     0.150
    45.243   495.836     0.150
    46.095   500.898     0.150
    46.197   502.297     0.150
    46.197   502.957     0.150
    46.227   502.586     0.150
    46.227   502.016     0.150
    46.261   503.426     0.150
    46.261   503.438     0.150
    46.300   502.316     0.150
    46.411   599.316     0.150
    46.411   504.938     0.150
    46.998   507.488     0.150
    46.998   508.758     0.150
    47.258   509.598     0.150
    47.258     7.578     0.150
    47.919   514.098     0.150
    48.382   519.566     0.150
    50.553   535.316     0.150
    50.553   536.148     0.150
    50.751  3841.430     0.150
    50.872  3835.996     0.150
    50.860   536.426     0.150
    51.036   540.016     0.150
    51.488   542.836     0.150
    52.067   545.848     0.150
    52.163   547.898     0.150
    52.574   540.387     0.150
    52.537   549.617     0.150
    52.537   549.629     0.150
    53.386     6.000     0.150
    53.917   561.027     0.150
    53.917   560.988     0.150
    55.072   629.789     0.150
    55.551   571.527     0.150
    55.551   571.816     0.150
    55.802   573.297     0.150
    56.078  1047.117     0.150
    57.098   583.016     0.150
    57.348   584.516     0.150
    57.495  1175.219     0.150
    57.882   589.059     0.150
    58.486   593.297     0.150
    58.849     4.801     0.150
    58.849     7.301     0.150
    59.344   599.258     0.150
    60.260   605.309     0.150
    60.768   607.516     0.150
    64.069   630.816     0.150
    64.134   632.617     0.150
    64.180   626.539     0.150
    64.400     6.500     0.150
    64.507   634.078     0.150
    64.842     8.000     0.150
    64.962   637.289     0.150
    65.353   638.719     0.150
    65.353   638.605     0.150
    65.461     7.699     0.150
    66.595   647.027     0.150
    66.595   647.207     0.150
    66.595   647.266     0.150
    66.810     9.000     0.150
    69.121   663.676     0.150
    69.448   665.945     0.150
    69.629  1205.816     0.150
    69.629   665.727     0.150
    69.629   665.719     0.150
    69.824     3.500     0.150
    69.824     7.500     0.150
    69.824  1217.617     0.150
    70.481   671.969     0.150
    70.635   672.297     0.150
    70.663   673.516     0.150
    70.806   673.586     0.150
    70.806   673.586     0.150
    70.806   932.777     0.150
    70.806  1497.539     0.150
    70.806  1699.629     0.150
    70.806   673.516     0.150
    70.806   694.316     0.150
    70.806   830.418     0.150
    70.806   932.719     0.150
    70.806  1229.219     0.150
    70.806  1497.516     0.150
    70.810   674.336     0.150
    71.086   675.117     0.150
    71.116   676.207     0.150
    71.293   675.605     0.150
    71.405   677.789     0.150
    71.405   676.836     0.150
    71.529   678.695     0.150
    71.472   678.676     0.150
    71.614   679.168     0.150
    71.675   679.578     0.150
    72.375   683.648     0.150
    72.488   685.656     0.150
    72.517   684.918     0.150
    72.908   687.578     0.150
    73.173   689.309     0.150
    73.311   689.207     0.150
    73.416   690.926     0.150
    73.443   686.316     0.150
    73.644   690.117     0.150
    73.876   702.816     0.150
    73.876   692.016     0.150
    73.863   692.258     0.150
    74.009   693.355     0.150
    74.009   693.316     0.150
    74.360   695.277     0.150
    74.451   695.926     0.150
    74.548   695.316     0.150
    74.548   695.387     0.150
    74.548   695.418     0.150
    74.548   695.496     0.150
    74.533   696.816     0.150
    74.598   696.977     0.150
    74.626   697.168     0.150
    74.689   700.617     0.150
    74.735   698.117     0.150
    74.775   698.016     0.150
    74.817   698.227     0.150
    74.864   698.297     0.150
    74.876   698.496     0.150
    74.914   698.828     0.150
    74.985   708.516     0.150
    74.985   699.418     0.150
    74.985   699.379     0.150
    75.200   699.918     0.150
    75.200   699.938     0.150
    75.223   699.516     0.150
    75.273   700.719     0.150
    75.273   700.766     0.150
    75.276   700.719     0.150
    75.372   700.426     0.150
    75.372   700.418     0.150
    75.375   700.289     0.150
    75.597   701.738     0.150
    75.575     8.801     0.150
    76.008   704.879     0.150
    76.015   705.219     0.150
    76.036   705.117     0.150
    76.036   705.207     0.150
    76.079   705.719     0.150
    76.203   705.398     0.150
    76.265   706.918     0.150
    76.276   705.809     0.150
    76.371   706.406     0.150
    76.428   707.316     0.150
    76.491   707.066     0.150
    76.493   707.668     0.150
    76.498   708.219     0.150
    76.476   707.758     0.150
    76.649   709.477     0.150
    76.911   710.316     0.150
    76.902   709.719     0.150
    76.902   709.758     0.150
    76.902   707.617     0.150
    76.993   711.277     0.150
    76.993   711.316     0.150
    77.067   710.605     0.150
    77.144   710.117     0.150
    77.144   710.117     0.150
    77.504   713.918     0.150
    77.504   714.105     0.150
    77.661   714.277     0.150
    77.775   714.219     0.150
    77.818   715.727     0.150
    78.112   717.527     0.150
    78.638   719.617     0.150
    78.638   719.727     0.150
    79.103   722.367     0.150
    79.187   722.219     0.150
    79.476   724.117     0.150
    79.494   724.219     0.150
    79.818   725.316     0.150
    79.869   726.516     0.150
    79.869   726.777     0.150
    79.878   726.719     0.150
    79.956   727.016     0.150
    79.956   727.016     0.150
    79.956   727.078     0.150
    80.018   722.117     0.150
    80.018   904.117     0.150
    80.018  1020.316     0.150
    80.018  1324.418     0.150
    80.018  1838.617     0.150
    80.105   727.016     0.150
    80.471   730.547     0.150
    80.612   730.160     0.150
    80.612   730.117     0.150
    80.612   729.828     0.150
    80.655  1024.617     0.150
    80.810   731.098     0.150
    80.810   731.117     0.150
    81.177   733.367     0.150
    81.294   733.867     0.150
    81.332   733.387     0.150
    81.871   736.238     0.150
    81.871   736.316     0.150
    81.871   736.559     0.150
    81.961   735.809     0.150
    82.045   736.598     0.150
    82.823   742.418     0.150
    82.981   742.418     0.150
    83.245   744.086     0.150
    83.415   746.086     0.150
    83.482   747.719     0.150
    83.742   746.766     0.150
    84.301   749.957     0.150
    84.462   750.758     0.150
    84.473   751.277     0.150
    84.600   751.438     0.150
    85.150   754.516     0.150
    85.328   754.816     0.150
    85.488   753.016     0.150
    86.406   759.719     0.150
    87.515   765.977     0.150
    88.339   769.918     0.150
    88.339   768.836     0.150
    88.752   769.578     0.150
    89.039   771.918     0.150
    89.900   776.906     0.150
    91.821   785.309     0.150
    99.227   819.207     0.150
   111.050  8360.914     0.150
   111.062  8363.688     0.150
   111.067  8350.539     0.150
   147.490  1181.828     0.150
   159.579  1233.125     0.150
   160.202  1234.727     0.150
     0.692    25.922     0.150
     1.474    25.281     0.150
     1.875    31.836     0.150
     1.897    32.141     0.150
     1.927    32.641     0.150
     1.956    33.508     0.150
     3.933    57.938     0.150
    13.721   194.781     0.150
    16.448   231.102     0.150
    63.725   626.547     0.150
     0.899    15.286     0.150
     0.899    25.336     0.150
     0.891    28.676     0.150
     1.923    33.446     0.150
    42.452  3178.230     0.150
    42.458  3177.802     0.150
    42.470  3174.896     0.150
    64.189   629.282     0.150
     0.169     6.775     0.150
     0.579    20.135     0.150
     1.409    24.675     0.150
     3.527    55.095     0.150
     3.557    97.815     0.150
     4.022   109.575     0.150
     4.022    61.505     0.150
     4.363    63.195     0.150
     4.979   127.869     0.150
     4.979    71.525     0.150
    43.190  3243.778     0.150
    43.196  3248.010     0.150
    43.208  3251.478     0.150
    44.356  3343.177     0.150
    44.369  3341.506     0.150
    44.373  3341.902     0.150
    74.505   695.017     0.150
   111.810  8377.594     0.150
   111.822  8380.621     0.150
   111.827  8389.578     0.150
     0.813    24.045     0.150
     2.057    36.564     0.150
     3.128    51.695     0.150
     3.157    51.684     0.150
     4.642    72.434     0.150
     5.478   160.658     0.150
     5.478    79.754     0.150
    10.081   143.535     0.150
    11.465   161.344     0.150
    11.761   168.514     0.150
    18.644   254.314     0.150
    18.644   254.365     0.150
    23.962   313.215     0.150
    23.962   567.914     0.150
    23.962   313.285     0.150
    24.474   317.924     0.150
    24.806   320.504     0.150
    27.408   344.934     0.150
    27.408   343.375     0.150
    32.623   393.854     0.150
    32.623   555.865     0.150
    34.822   410.625     0.150
    35.774   562.014     0.150
    36.651   426.154     0.150
    37.553   433.615     0.150
    42.088   470.715     0.150
    42.690  3192.270     0.150
    42.696  3189.219     0.150
    42.708  3190.600     0.150
    43.855  3280.236     0.150
    43.869  3277.391     0.150
    43.873  3276.824     0.150
    45.009   494.715     0.150
    45.009   494.865     0.150
    46.714   506.885     0.150
    47.015   509.564     0.150
    46.971   508.094     0.150
    47.448    11.000     0.150
    49.504   531.715     0.150
    50.354   535.805     0.150
    51.396   544.344     0.150
    51.712  3869.465     0.150
    51.846   546.525     0.150
    52.439    12.801     0.150
    53.221   556.504     0.150
    54.277   562.525     0.150
    55.444   570.525     0.150
    56.159   576.314     0.150
    56.159   576.334     0.150
    57.363   583.715     0.150
    57.771   584.615     0.150
    57.771   644.014     0.150
    58.962   599.104     0.150
    59.237   598.934     0.150
    59.659   600.504     0.150
    64.012     6.699     0.150
    64.247   632.205     0.150
    64.418   634.525     0.150
    64.580   634.514     0.150
    64.544    16.102     0.150
    65.434   641.824     0.150
    65.970   643.514     0.150
    68.959   663.465     0.150
    69.817   824.514     0.150
    70.110   669.684     0.150
    70.152   671.094     0.150
    70.290   671.775     0.150
    70.531   673.184     0.150
    70.605   673.715     0.150
    70.681   674.094     0.150
    71.111   937.715     0.150
    71.037   676.305     0.150
    70.983   676.395     0.150
    71.184   677.215     0.150
    71.774   678.984     0.150
    71.970   682.795     0.150
    72.447   685.475     0.150
    72.920   688.334     0.150
    73.365   690.195     0.150
    73.464   690.555     0.150
    73.762   693.734     0.150
    73.674   694.115     0.150
    74.384   695.562     0.150
    74.384   695.514     0.150
    74.384    10.602     0.150
    74.384   865.314     0.150
    74.384   886.314     0.150
    74.384  1539.314     0.150
    74.471   696.574     0.150
    74.475   696.684     0.150
    74.856   698.574     0.150
    75.199   699.875     0.150
    75.223   700.914     0.150
    75.241   701.115     0.150
    75.285   701.215     0.150
    75.285   701.275     0.150
    75.432   701.615     0.150
    75.432   701.615     0.150
    75.450   701.715     0.150
    75.564   703.203     0.150
    75.734   703.615     0.150
    75.762   703.615     0.150
    75.991   705.115     0.150
    76.045   705.074     0.150
    76.069   702.215     0.150
    76.409   707.715     0.150
    76.485   707.814     0.150
    76.498   708.314     0.150
    76.498   708.314     0.150
    76.498   708.375     0.150
    76.583   708.914     0.150
    76.583   708.715     0.150
    76.775   709.385     0.150
    76.874   710.314     0.150
    76.876   710.914     0.150
    76.876   711.004     0.150
    76.922   710.715     0.150
    77.071   710.844     0.150
    77.340   713.215     0.150
    77.350   713.414     0.150
    77.430   712.314     0.150
    77.445   714.215     0.150
    77.890   715.975     0.150
    77.918   715.814     0.150
    77.877   716.125     0.150
    78.108   717.014     0.150
    78.653   720.314     0.150
    78.676   719.674     0.150
    79.009   722.215     0.150
    79.009   722.225     0.150
    79.144   721.514     0.150
    79.784   726.014     0.150
    80.197   727.914     0.150
    80.205   728.615     0.150
    80.290   729.314     0.150
    80.375   728.826     0.150
    80.390   729.414     0.150
    80.406   729.914     0.150
     1.515    26.312     0.150
     1.558    27.102     0.150
     1.578    27.844     0.150
     1.658    28.977     0.150
     0.891    16.602     0.150
     0.914    26.301     0.150
     0.914    15.910     0.150
     0.919    18.109     0.150
     1.594    51.738     0.150
     1.936    32.469     0.150
     1.784    32.270     0.150
     1.784    56.699     0.150
     2.775    80.930     0.150
     2.804    81.480     0.150
     4.724    70.859     0.150
     5.150    75.191     0.150
     7.203   105.621     0.150
     9.729   140.488     0.150
    12.301   171.102     0.150
    12.488   169.449     0.150
    18.838   461.734     0.150
    20.311   272.621     0.150
    23.619   308.672     0.150
    24.131   313.102     0.150
    26.184   332.012     0.150
    33.196   394.352     0.150
    33.196   394.309     0.150
    35.168   411.980     0.150
    35.509     4.500     0.150
    35.509   879.551     0.150
    41.790   467.590     0.150
    42.421  3168.867     0.150
    42.427  3170.340     0.150
    42.439  3175.898     0.150
    43.589  3252.332     0.150
    43.603  3257.359     0.150
    43.606  3262.426     0.150
    44.654   490.551     0.150
    44.654   490.520     0.150
    44.655   490.719     0.150
    44.860   492.551     0.150
    46.733   506.539     0.150
    47.145   507.551     0.150
    47.145   507.520     0.150
    47.145   510.199     0.150
    48.155   517.648     0.150
    48.155   517.961     0.150
    48.787   523.090     0.150
    50.007   532.211     0.150
    52.195   548.309     0.150
    52.195   548.352     0.150
    52.438   549.121     0.150
    53.986   561.250     0.150
    56.145   574.621     0.150
    57.738   583.750     0.150
    57.738   717.449     0.150
    59.020   596.551     0.150
    64.180   632.180     0.150
    64.230    10.398     0.150
    64.230    13.098     0.150
    64.613   633.852     0.150
    65.737   641.121     0.150
    65.848   641.852     0.150
    67.239   650.172     0.150
    68.733   661.160     0.150
    69.759  1216.852     0.150
    69.875   667.352     0.150
    69.920   668.699     0.150
    70.057   669.391     0.150
    70.318   670.941     0.150
    70.373   671.500     0.150
    70.458   671.852     0.150
    70.810   674.121     0.150
    70.757   674.020     0.150
    71.085   935.750     0.150
    71.623   679.328     0.150
    72.226   683.609     0.150
    72.226   683.059     0.150
    72.927   682.648     0.150
    73.155   687.969     0.150
    73.273   685.852     0.150
    73.258   687.941     0.150
    73.558   691.699     0.150
    74.030   693.559     0.150
    74.266   694.602     0.150
    74.268   693.852     0.150
    74.416   695.051     0.150
    74.416     8.699     0.150
    74.416   863.750     0.150
    74.462   695.789     0.150
    74.785   696.449     0.150
    74.792   696.180     0.150
    74.792   696.250     0.150
    74.792   696.199     0.150
    74.885   697.828     0.150
    75.133   699.762     0.150
    75.467   701.750     0.150
    75.467   701.762     0.150
    75.468   701.852     0.150
    75.751   703.352     0.150
    75.788   703.250     0.150
    76.058   704.551     0.150
    76.058   704.648     0.150
    76.407   707.051     0.150
    76.515   707.551     0.150
    76.515   707.551     0.150
    76.614   708.602     0.150
    76.767   708.340     0.150
    76.870   710.148     0.150
    76.870   710.230     0.150
    76.904   709.289     0.150
    77.124   710.500     0.150
    77.124   710.547     0.150
    77.147   711.059     0.150
    77.349   712.449     0.150
    77.351   712.648     0.150
    77.398   711.551     0.150
    77.460   713.352     0.150
    77.918   713.961     0.150
    77.922   715.750     0.150
    78.089   716.352     0.150
    78.089   716.262     0.150
    79.001   721.148     0.150
    79.053   722.352     0.150
    79.595   725.051     0.150
    79.758   725.250     0.150
    79.777   725.352     0.150
    79.796   717.852     0.150
    79.817   726.211     0.150
    80.088   727.648     0.150
    80.201   727.949     0.150
    80.271   728.449     0.150
    80.271   728.449     0.150
    80.271   728.512     0.150
    80.357   728.648     0.150
    80.397   729.148     0.150
    80.521   729.969     0.150
    80.800   731.449     0.150
    81.084   733.137     0.150
    81.115   732.449     0.150
    81.231   732.250     0.150
    81.364   732.820     0.150
    81.767   735.270     0.150
    83.970   745.910     0.150
    85.268   753.691     0.150
    85.507   756.801     0.150
    86.643   759.660     0.150
    98.972   817.828     0.150
     0.450    15.469     0.150
     0.513    11.141     0.150
     4.633    68.672     0.150
     5.241    75.641     0.150
    18.355   248.719     0.150
    42.937  3237.586     0.150
    42.943  3233.438     0.150
    42.954  3254.531     0.150
     0.535    11.779     0.150
     3.736    58.109     0.150
     4.079    58.879     0.150
    13.661   193.850     0.150
    14.600   209.689     0.150
    15.261   215.799     0.150
    16.237   225.759     0.150
     3.588    55.842     0.150
     3.722   103.211     0.150
     4.240    64.201     0.150
     4.321    65.352     0.150
     4.639    67.691     0.150
     6.384    91.221     0.150
    47.557   511.871     0.150
     0.657    14.422     0.150
     0.748    14.492     0.150
     0.748    14.492     0.150
     1.644    52.172     0.150
     1.644    28.492     0.150
     1.815    53.555     0.150
     1.815    30.594     0.150
     2.244    32.492     0.150
     2.724    77.543     0.150
     3.191    49.395     0.150
     3.408    47.395     0.150
     3.450    54.895     0.150
     4.131    66.395     0.150
     4.232    68.492     0.150
     5.121    74.992     0.150
     5.121    64.094     0.150
     6.834    99.633     0.150
     7.086   103.453     0.150
     8.117   117.441     0.150
     9.654   138.312     0.150
     9.654   138.352     0.150
    10.043   142.824     0.150
    15.210   213.492     0.150
    16.967  1189.109     0.150
    16.967  1188.672     0.150
    17.506   434.941     0.150
    23.451   307.793     0.150
    23.451   548.895     0.150
    23.961   531.395     0.150
    33.741   396.812     0.150
    35.267    14.699     0.150
    35.267   487.293     0.150
    35.267   755.992     0.150
    35.267   874.191     0.150
    35.267   408.824     0.150
    35.652   413.094     0.150
    37.625   429.473     0.150
    37.705   430.934     0.150
    38.772   438.293     0.150
    40.092  1027.395     0.150
    40.410   455.074     0.150
    41.787   464.941     0.150
    42.492  3180.008     0.150
    42.498  3188.805     0.150
    42.510  3172.211     0.150
    43.038   586.137     0.150
    43.662  3264.328     0.150
    43.676  3266.199     0.150
    43.680  3265.633     0.150
    44.528   486.094     0.150
    44.528   487.602     0.150
    44.528   487.332     0.150
    45.678   497.094     0.150
    46.502   502.914     0.150
    46.502   502.922     0.150
    46.554   503.621     0.150
    46.966   506.465     0.150
    46.966   506.441     0.150
    46.966   506.434     0.150
    48.010   514.594     0.150
    48.010   514.512     0.150
    48.072   602.691     0.150
    48.072   515.371     0.150
    49.145   525.594     0.150
    49.847   528.734     0.150
    51.915    13.398     0.150
    51.915    17.500     0.150
    52.138   543.293     0.150
    52.267   546.273     0.150
    52.236  3878.527     0.150
    52.353    17.398     0.150
    52.710   551.395     0.150
    53.053   553.332     0.150
    53.075   553.332     0.150
    53.758   557.402     0.150
    54.557    12.500     0.150
    54.557    17.898     0.150
    54.557  1016.395     0.150
    55.182   568.613     0.150
    55.641   570.004     0.150
    55.910   573.934     0.150
    57.080   583.293     0.150
    57.398    13.500     0.150
    57.398   714.691     0.150
    57.398  1060.191     0.150
    57.491   578.395     0.150
    60.567    13.000     0.150
    62.882    12.500     0.150
    63.490    12.199     0.150
    63.618   627.793     0.150
    63.618   625.602     0.150
    63.928   628.363     0.150
    63.988   630.031     0.150
    63.989   627.133     0.150
    63.934   630.492     0.150
    64.020    17.102     0.150
    64.388   630.395     0.150
    64.388   630.293     0.150
    65.265   637.633     0.150
    65.594   638.531     0.150
    65.680   638.992     0.150
    67.352   650.164     0.150
    68.478   657.555     0.150
    68.816   659.262     0.150
    68.816   659.363     0.150
    68.816   659.453     0.150
    69.506   918.395     0.150
    69.622   663.715     0.150
    69.705   664.934     0.150
    69.667   665.172     0.150
    69.804   665.715     0.150
    70.007   665.133     0.150
    70.061   667.203     0.150
    70.119   667.742     0.150
    70.202   668.352     0.150
    70.541   667.594     0.150
    70.555   670.262     0.150
    70.502   670.383     0.150
    70.702   671.434     0.150
    70.840   932.395     0.150
    71.648   678.543     0.150
    71.693   674.191     0.150
    71.970   679.805     0.150
    72.670   678.594     0.150
    72.897   684.324     0.150
    73.017   681.793     0.150
    72.999   684.402     0.150
    73.092   684.895     0.150
    73.176   687.453     0.150
    73.299   688.344     0.150
    73.755   688.773     0.150
    74.007   691.074     0.150
    74.009   691.164     0.150
    74.190   691.395     0.150
    74.190   690.992     0.150
    74.190    14.102     0.150
    74.190    19.102     0.150
    74.190  1769.293     0.150
    74.190  1865.293     0.150
    74.238   691.383     0.150
    74.545   692.883     0.150
    74.545   692.953     0.150
    74.545   692.852     0.150
    74.657   694.262     0.150
    74.743   693.492     0.150
    74.842   696.703     0.150
    74.906   696.254     0.150
    74.994   696.191     0.150
    75.021   696.895     0.150
    75.029   696.691     0.150
    75.031   696.832     0.150
    75.074   697.191     0.150
    75.237   698.094     0.150
    75.242   697.895     0.150
    75.410   698.184     0.150
    75.410   712.383     0.150
    75.410   699.434     0.150
    75.411   696.793     0.150
    75.519   699.492     0.150
    75.560   699.594     0.150
    75.660   702.484     0.150
    75.725   699.824     0.150
    75.726   701.492     0.150
    75.726   699.852     0.150
    75.826   700.895     0.150
    75.922   700.992     0.150
    76.284   703.691     0.150
    76.328   703.684     0.150
    76.347   706.191     0.150
    76.387   705.043     0.150
    76.455   705.793     0.150
    76.631   706.691     0.150
    76.677   706.293     0.150
    76.722   706.191     0.150
    76.906   707.414     0.150
    76.906   707.312     0.150
    77.114   708.895     0.150
    77.228   710.094     0.150
    77.101   710.992     0.150
    77.407   709.395     0.150
    77.685   712.594     0.150
    77.685   712.684     0.150
    77.690   712.957     0.150
    77.754   714.414     0.150
    77.795   714.793     0.150
    77.846   712.492     0.150
    78.434   715.992     0.150
    78.525   715.902     0.150
    78.761   717.895     0.150
    78.761   717.805     0.150
    78.874   717.094     0.150
    79.532   721.895     0.150
    79.557   720.395     0.150
    79.598  1323.395     0.150
    79.598  1837.191     0.150
    79.963   724.395     0.150
    80.028   725.895     0.150
    80.110   724.895     0.150
    80.157   725.793     0.150
    80.269   726.762     0.150
    80.269   726.734     0.150
    80.323   727.191     0.150
    80.323   726.145     0.150
    80.323   726.184     0.150
    80.404  1331.793     0.150
    80.613   728.215     0.150
    80.807   728.992     0.150
    80.807   729.043     0.150
    80.923  1645.715     0.150
    80.980   730.215     0.150
    81.108   729.781     0.150
    83.943   745.594     0.150
    84.001   745.824     0.150
    84.679   751.113     0.150
    84.822   761.293     0.150
    84.909   749.094     0.150
    85.014   750.992     0.150
    85.277   753.441     0.150
    86.412   758.004     0.150
    86.365   756.062     0.150
    86.925   762.793     0.150
    86.925   762.293     0.150
    92.036  1445.453     0.150
    92.309   787.895     0.150
    92.322   785.203     0.150
    95.927   792.691     0.150
   112.490  8403.023     0.150
   112.501  8404.336     0.150
   112.506  8421.312     0.150
   122.370  1130.270     0.150
   122.370  1130.293     0.150
   144.774  1169.332     0.150
   145.380  1168.371     0.150
   146.594  1166.812     0.150
   148.186  1172.992     0.150
   148.342  1169.734     0.150
   149.538  1175.543     0.150
   160.137  1241.953     0.150
   160.178  1244.613     0.150
   160.671  1246.754     0.150
   161.364  1250.414     0.150
   163.654  1258.895     0.150
     4.989    75.980     0.150
     5.064    76.879     0.150
     5.755    86.578     0.150
     5.973    89.809     0.150
     6.393    95.609     0.150
     6.496    96.879     0.150
     8.034   117.609     0.150
    22.449   299.367     0.150
    66.174   646.637     0.150
    66.174   646.848     0.150
     0.488    15.742     0.150
     1.465    25.430     0.150
     5.222   150.969     0.150
     5.984    82.648     0.150
     6.424    94.102     0.150
    10.000   139.094     0.150
    11.118   154.734     0.150
    11.412   158.219     0.150
    11.970   161.008     0.150
    18.312   247.109     0.150
    19.294   256.891     0.150
    21.826   285.523     0.150
    32.671   398.531     0.150
    56.833   577.750     0.150
    63.877   626.055     0.150
    74.806   702.148     0.150
    77.602   710.680     0.150
     0.652    12.953     0.150
     1.217    35.453     0.150
     1.217    21.254     0.150
     1.361    22.754     0.150
     1.476    25.914     0.150
     1.476    25.953     0.150
     1.932    31.465     0.150
     1.980    32.082     0.150
     2.195    63.652     0.150
     2.678    75.875     0.150
     2.913    81.465     0.150
     2.941    82.594     0.150
     3.064    86.715     0.150
     3.071    85.082     0.150
     3.187    87.332     0.150
     3.697    53.852     0.150
     3.875   106.102     0.150
     4.340   107.473     0.150
     4.340    62.723     0.150
     4.816    70.555     0.150
     5.042    70.152     0.150
     5.077    74.555     0.150
     5.812    83.504     0.150
     5.855    85.152     0.150
     5.887    84.852     0.150
     5.876    83.922     0.150
     6.073    87.492     0.150
     6.959    99.555     0.150
     6.959   176.953     0.150
     6.993    99.922     0.150
     7.975   111.484     0.150
     8.282   117.043     0.150
     9.044   127.824     0.150
     9.181   127.375     0.150
     9.259   128.883     0.150
     9.660   135.574     0.150
     9.701   136.742     0.150
     9.744   136.992     0.150
     9.806   137.094     0.150
    11.285   159.145     0.150
    11.424   157.895     0.150
    22.097   293.125     0.150
    24.718   321.254     0.150
    24.718   321.223     0.150
    24.994   366.652     0.150
    24.994   644.152     0.150
    24.994   320.254     0.150
    25.498   323.152     0.150
    25.498   324.543     0.150
    26.184   331.344     0.150
    28.712   354.262     0.150
    34.784   731.152     0.150
    36.072   419.012     0.150
    36.125   419.043     0.150
    36.083   763.453     0.150
    36.383   908.055     0.150
    36.873   769.953     0.150
    36.873   425.484     0.150
    36.873   425.504     0.150
    39.631   448.602     0.150
    39.631   448.664     0.150
    40.243   453.723     0.150
    40.547   455.672     0.150
    40.765   458.965     0.150
    40.813   459.742     0.150
    40.813   458.652     0.150
    42.165   467.793     0.150
    43.467   477.523     0.150
    43.834  3295.867     0.150
    43.840  3297.992     0.150
    43.852  3296.621     0.150
    44.557   487.453     0.150
    44.995  3382.816     0.150
    45.009  3390.527     0.150
    45.013  3390.902     0.150
    46.084     6.500     0.150
    46.109   498.324     0.150
    46.142   501.223     0.150
    46.262   502.754     0.150
    46.262   502.723     0.150
    46.496   504.973     0.150
    47.039   507.375     0.150
    47.039   506.043     0.150
    47.293   510.602     0.150
    47.342   509.691     0.150
    48.029   513.422     0.150
    48.403    10.801     0.150
    48.588   518.465     0.150
    50.033   530.805     0.150
    50.637   535.023     0.150
    50.829  3816.023     0.150
    51.404   541.852     0.150
    52.079   547.344     0.150
    53.308     9.902     0.150
    55.000   568.223     0.150
    55.000   568.262     0.150
    55.332   570.781     0.150
    55.544   571.023     0.150
    55.796   637.262     0.150
    55.796   572.645     0.150
    55.998     9.602     0.150
    55.998  1044.754     0.150
    57.483   639.453     0.150
    57.826    10.898     0.150
    58.268  1061.555     0.150
    58.772     7.500     0.150
    58.772    10.902     0.150
    58.876   595.742     0.150
    59.682  1091.852     0.150
    60.404    11.000     0.150
    60.752   605.453     0.150
    62.033     8.703     0.150
    62.033    14.703     0.150
    62.315   617.043     0.150
    62.663   622.125     0.150
    64.051     9.500     0.150
    64.051    14.699     0.150
    64.074   630.352     0.150
    64.141  1149.852     0.150
    64.320     5.902     0.150
    64.454   633.074     0.150
    64.563   631.453     0.150
    64.877   636.602     0.150
    64.902   635.555     0.150
    64.902  1157.941     0.150
    65.035   672.754     0.150
    65.035   871.754     0.150
    65.035   636.262     0.150
    65.063   637.023     0.150
    65.359   639.625     0.150
    65.359   636.914     0.150
    65.385     8.000     0.150
    65.385    11.301     0.150
    66.430   645.453     0.150
    66.656  1182.055     0.150
    66.746     4.902     0.150
    66.746    11.199     0.150
    66.870   647.691     0.150
    68.248   656.344     0.150
    68.248   656.363     0.150
    68.895   670.254     0.150
    69.392   664.992     0.150
    69.482    10.902     0.150
    69.612   672.754     0.150
    69.612   919.652     0.150
    69.612  1214.152     0.150
    69.612   665.453     0.150
    69.752  1216.453     0.150
    70.337  1225.254     0.150
    70.576   671.352     0.150
    70.605   672.574     0.150
    70.605  1226.652     0.150
    70.751   673.434     0.150
    70.797   932.254     0.150
    71.059   675.352     0.150
    71.059  1231.793     0.150
    71.098   675.504     0.150
    71.400   676.453     0.150
    71.449   673.555     0.150
    71.472   677.852     0.150
    71.472  1236.582     0.150
    71.416   677.863     0.150
    71.618   678.734     0.150
    72.092  1243.742     0.150
    72.101   682.414     0.150
    72.853   686.453     0.150
    72.853   686.504     0.150
    72.914   686.215     0.150
    73.180   688.242     0.150
    73.322   688.543     0.150
    73.588   690.273     0.150
    73.588   690.164     0.150
    73.658   690.441     0.150
    73.725   691.125     0.150
    73.811   691.293     0.150
    73.880  1252.453     0.150
    73.880   691.555     0.150
    73.880     7.199     0.150
    73.880  1565.453     0.150
    73.880  1751.453     0.150
    73.880  1865.453     0.150
    73.880   691.625     0.150
    74.021   692.805     0.150
    74.100   694.602     0.150
    74.170   692.414     0.150
    74.364   694.652     0.150
    74.364   702.723     0.150
    74.537   694.672     0.150
    74.609    11.000     0.150
    74.739   697.043     0.150
    74.740   697.152     0.150
    74.777   697.754     0.150
    74.812   697.523     0.150
    74.824   697.691     0.150
    74.824  1274.633     0.150
    74.970   698.652     0.150
    74.987   698.453     0.150
    74.987  1273.352     0.150
    75.276   700.555     0.150
    75.276  1277.352     0.150
    75.277   699.953     0.150
    75.380   701.434     0.150
    75.517     7.199     0.150
    75.598     8.801     0.150
    75.598   701.953     0.150
    75.598   701.902     0.150
    75.792   702.453     0.150
    76.012   704.254     0.150
    76.038   704.852     0.150
    76.264   706.555     0.150
    76.375   706.453     0.150
    76.375   705.613     0.150
    76.432   707.055     0.150
    76.432  1289.352     0.150
    76.494   707.254     0.150
    76.502   707.086     0.150
    76.911   709.652     0.150
    76.945     8.199     0.150
    76.943   710.254     0.150
    76.994   710.453     0.150
    77.134   710.152     0.150
    77.502   713.492     0.150
    77.581   714.152     0.150
    77.670   713.812     0.150
    77.743   714.754     0.150
    77.768   714.094     0.150
    78.516   718.422     0.150
    78.634   718.965     0.150
    78.702   720.152     0.150
    79.260   723.453     0.150
    79.467   723.852     0.150
    79.716   726.652     0.150
    79.716  1325.652     0.150
    79.752   725.852     0.150
    79.814   725.465     0.150
    79.843   725.863     0.150
    79.870   726.754     0.150
    79.909   722.652     0.150
    79.909  1318.453     0.150
    79.949   726.852     0.150
    79.987  1017.055     0.150
    79.987  1842.754     0.150
    80.053   726.953     0.150
    80.095   727.055     0.150
    80.591   729.852     0.150
    80.614   728.652     0.150
    80.614   730.262     0.150
    80.632   909.953     0.150
    80.632  1338.352     0.150
    80.710   728.852     0.150
    80.841   730.652     0.150
    80.952   732.953     0.150
    81.235   733.594     0.150
    81.235   733.664     0.150
    81.374  1029.453     0.150
    81.651   733.434     0.150
    81.790   735.555     0.150
    81.790   735.574     0.150
    81.790   735.543     0.150
    81.990   735.805     0.150
    82.495   740.152     0.150
    82.676   738.055     0.150
    82.951   741.191     0.150
    82.948   738.953     0.150
    83.259   743.984     0.150
    83.308   744.395     0.150
    83.512   745.242     0.150
    84.388   759.152     0.150
    85.133   753.555     0.150
    87.935   772.852     0.150
    88.275   767.715     0.150
    89.349   772.102     0.150
    89.349   772.242     0.150
    91.923   785.914     0.150
    93.809   793.133     0.150
    99.192   819.223     0.150
   149.953  1187.375     0.150
     3.761    55.137     0.150
     8.945   128.879     0.150
    11.471   163.676     0.150
    44.864  3384.961     0.150
    44.877  3385.801     0.150
    44.881  3392.578     0.150
     0.533     8.402     0.150
     0.533    13.902     0.150
     0.537     8.764     0.150
     0.537    15.383     0.150
     0.851    30.623     0.150
     0.874    30.773     0.150
     3.197    49.143     0.150
     3.893    57.963     0.150
     8.621   123.793     0.150
     8.917   128.902     0.150
    10.154   144.572     0.150
    11.927   160.365     0.150
    16.993   424.096     0.150
    32.719   392.229     0.150
    34.872   410.451     0.150
    42.980  3238.049     0.150
    42.987  3237.385     0.150
    42.998  3240.342     0.150
    44.149  3345.867     0.150
    44.163  3330.975     0.150
    44.167  3337.881     0.150
     1.373    24.012     0.150
     3.742    57.492     0.150
     0.520     8.816     0.150
     0.520    15.355     0.150
     0.407    10.277     0.150
     0.407    17.736     0.150
     0.876    17.666     0.150
     0.896    17.807     0.150
     3.084    86.477     0.150
     3.698    85.986     0.150
     5.683    85.117     0.150
     0.849    25.635     0.150
     1.662    51.834     0.150
     4.350    65.404     0.150
     7.286   108.084     0.150
     8.938   129.494     0.150
    11.451   161.674     0.150
    24.198   312.551     0.150
    42.478  3206.936     0.150
    42.484  3208.004     0.150
    42.496  3214.008     0.150
    43.646  3259.100     0.150
    43.659  3254.408     0.150
    43.663  3253.230     0.150
    47.854   604.834     0.150
    64.023   630.703     0.150
    64.601   634.434     0.150
    64.673   634.549     0.150
    65.779   641.635     0.150
    68.985   662.459     0.150
    76.892   710.033     0.150
    80.865   731.635     0.150
     1.047    19.449     0.150
     2.404    61.250     0.150
     4.188    62.949     0.150
     0.347     9.457     0.150
     0.561    17.777     0.150
     3.689    56.037     0.150
     5.208   151.377     0.150
    11.728   166.758     0.150
    44.971   492.857     0.150
    44.971   492.398     0.150
     0.484    14.807     0.150
     0.489    16.607     0.150
     0.489    10.797     0.150
     3.699    56.767     0.150
     9.850   138.467     0.150
    42.926  3237.610     0.150
    42.932  3238.103     0.150
    42.944  3239.115     0.150
    44.094  3323.738     0.150
    44.108  3323.738     0.150
    44.112  3329.812     0.150
    55.837   570.032     0.150
    76.548   704.732     0.150
    76.553   708.407     0.150
    77.362   709.913     0.150
    77.536   710.751     0.150
    77.637   711.077     0.150
    77.698   711.517     0.150
    77.775   711.978     0.150
    77.917   712.406     0.150
    77.953   713.606     0.150
    78.028   713.490     0.150
    81.054   742.507     0.150
     3.027    82.750     0.150
     5.057    76.449     0.150
     5.965    89.189     0.150
     7.491   109.379     0.150
     7.529   109.891     0.150
    12.723   182.369     0.150
    15.178   214.420     0.150
    17.345   242.240     0.150
    42.449  3200.656     0.150
    42.455  3199.664     0.150
    42.467  3201.271     0.150
    43.613  3287.840     0.150
    43.626  3290.158     0.150
    43.630  3291.658     0.150
    50.372   536.842     0.150
    66.174   646.314     0.150
    81.196   736.391     0.150
     0.500    16.198     0.150
     0.503    15.668     0.150
     1.443    24.808     0.150
    11.952   159.048     0.150
    11.952   167.838     0.150
    18.295   243.898     0.150
    26.034   326.088     0.150
    42.971  3245.447     0.150
    42.977  3249.424     0.150
    42.989  3245.447     0.150
    44.139  3339.826     0.150
    44.153  3340.395     0.150
    44.157  3342.096     0.150
    63.851   624.938     0.150
    65.185   634.268     0.150
    65.690   637.137     0.150
    74.426   692.958     0.150
    81.024   728.398     0.150
    83.631   741.598     0.150
   144.711  1180.967     0.150
    43.173  3253.141     0.150
    43.179  3249.328     0.150
    43.191  3255.484     0.150
    44.339  3338.633     0.150
    44.352  3339.883     0.150
    44.356  3340.094     0.150
    65.215   636.285     0.150
     0.411    10.156     0.150
     0.514    16.406     0.150
     1.056    35.078     0.150
     8.939   126.766     0.150
     9.745   135.836     0.150
    10.160   144.609     0.150
    11.954   296.555     0.150
    15.158   211.117     0.150
    23.884   345.555     0.150
    23.884   555.461     0.150
    23.884   629.961     0.150
    23.884   309.461     0.150
    29.840   363.109     0.150
    34.859  2341.859     0.150
    34.859   405.461     0.150
    34.985   729.859     0.150
    35.521   488.859     0.150
    35.521   410.656     0.150
    35.759   414.477     0.150
    37.205   427.180     0.150
    38.260   433.961     0.150
    40.428  1034.656     0.150
    41.352   462.164     0.150
    41.896   466.508     0.150
    42.280   570.859     0.150
    42.965  3186.812     0.150
    42.971  3186.992     0.150
    42.983  3187.750     0.150
    44.133  3272.211     0.150
    44.147  3273.820     0.150
    44.151  3275.062     0.150
    45.004   491.156     0.150
    45.004   491.234     0.150
    45.004   491.438     0.150
    45.003   491.016     0.150
    45.115   491.656     0.150
    45.257   491.328     0.150
    46.528   502.852     0.150
    46.528   596.008     0.150
    47.128   597.961     0.150
    47.620   601.656     0.150
    47.620   512.039     0.150
    47.620   511.336     0.150
    47.620   511.641     0.150
    50.288   532.430     0.150
    50.967   537.656     0.150
    50.967   537.656     0.150
    51.334   540.117     0.150
    51.496   542.008     0.150
    51.761   542.664     0.150
    51.761   543.086     0.150
    52.506   548.508     0.150
    52.765    11.297     0.150
    54.398   626.258     0.150
    54.398   562.219     0.150
    55.495   568.938     0.150
    58.164   590.156     0.150
    58.997   593.539     0.150
    58.997   593.867     0.150
    59.298    15.898     0.150
    62.694   618.750     0.150
    62.956    16.297     0.150
    63.470    14.102     0.150
    63.774   626.031     0.150
    63.809     6.000     0.150
    63.847   626.555     0.150
    64.133   629.734     0.150
    64.178   629.055     0.150
    64.178   629.258     0.150
    64.374    17.203     0.150
    64.469   631.305     0.150
    64.486   628.555     0.150
    64.610    14.898     0.150
    64.610   631.836     0.150
    65.485   638.367     0.150
    65.485   638.352     0.150
    65.679   638.961     0.150
    65.788   639.281     0.150
    65.850    17.359     0.150
    65.919    15.195     0.150
    68.126   652.359     0.150
    68.535   657.352     0.150
    68.535   658.070     0.150
    68.535   658.164     0.150
    68.662   658.688     0.150
    68.697   674.359     0.150
    69.321   662.500     0.150
    69.424   662.148     0.150
    69.667   664.719     0.150
    69.821   665.000     0.150
    69.859   666.328     0.150
    70.000   666.977     0.150
    70.220   668.289     0.150
    70.312   669.016     0.150
    70.380   669.352     0.150
    70.525   667.461     0.150
    70.712   928.461     0.150
    70.741   671.484     0.150
    70.686   671.688     0.150
    70.887   672.508     0.150
    70.898   672.648     0.150
    71.628   673.859     0.150
    72.143   680.555     0.150
    72.143   680.516     0.150
    72.504   678.461     0.150
    72.623   678.859     0.150
    72.956   681.258     0.150
    73.051   685.250     0.150
    73.148   685.609     0.150
    73.185   682.359     0.150
    73.590   688.719     0.150
    73.983   690.188     0.150
    73.983   690.258     0.150
    73.983   706.156     0.150
    73.983   861.258     0.150
    73.983  1561.258     0.150
    73.983  1753.258     0.150
    74.153   691.781     0.150
    74.159   691.938     0.150
    74.428   692.359     0.150
    74.428   692.320     0.150
    74.428   692.414     0.150
    74.428   692.391     0.150
    74.483    16.797     0.150
    74.590   693.180     0.150
    74.769    16.500     0.150
    74.804   695.758     0.150
    74.822   695.961     0.150
    74.839   695.859     0.150
    74.883   695.961     0.150
    75.031   697.359     0.150
    75.048   697.359     0.150
    75.048   697.320     0.150
    75.165   697.984     0.150
    75.213   697.734     0.150
    75.332   698.656     0.150
    75.868   695.258     0.150
    75.906    12.195     0.150
    75.906    17.000     0.150
    76.007   702.258     0.150
    76.096   703.219     0.150
    76.139   703.555     0.150
    76.182   704.008     0.150
    76.283   704.461     0.150
    76.380   705.156     0.150
    76.520   705.258     0.150
    76.672   706.047     0.150
    76.672   705.984     0.150
    76.672   706.039     0.150
    76.690   706.008     0.150
    76.939   707.555     0.150
    77.043   708.758     0.150
    77.590   712.055     0.150
    77.616   711.656     0.150
    77.952   714.070     0.150
    78.222   715.766     0.150
    79.176    14.500     0.150
    79.385   721.266     0.150
    79.481  1311.055     0.150
    79.532   722.359     0.150
    79.532   722.406     0.150
    79.606   898.055     0.150
    79.606  1008.555     0.150
    79.606  1637.156     0.150
    79.606  1837.859     0.150
    79.720   720.656     0.150
    80.361  1018.359     0.150
    80.361  1850.461     0.150
    80.667   727.961     0.150
    80.667   728.617     0.150
    80.721   728.117     0.150
    80.721   728.414     0.150
    80.721   728.297     0.150
    81.282   730.406     0.150
    82.287   740.758     0.150
    82.650   741.961     0.150
    82.859   740.469     0.150
    83.236   740.828     0.150
    84.568   748.656     0.150
    84.988   750.961     0.150
    85.204   753.297     0.150
    86.470   761.758     0.150
    86.470   758.719     0.150
    87.401   762.414     0.150
    87.401   763.016     0.150
    87.690   765.945     0.150
    90.816   778.258     0.150
    92.083   789.531     0.150
    92.824   786.945     0.150
    98.749   814.578     0.150
   134.061  1152.406     0.150
   139.856  1154.961     0.150
   139.856  1154.969     0.150
   144.294  1169.484     0.150
   153.370  1190.031     0.150
   156.239  1198.055     0.150
   160.127  1186.250     0.150
   162.848  1256.289     0.150
     0.428    14.260     0.150
     2.445    40.900     0.150
     2.520    42.030     0.150
     3.302    49.400     0.150
     4.582    67.380     0.150
     5.433    81.110     0.150
     7.714   112.840     0.150
     8.912   129.540     0.150
    12.169   304.999     0.150
    15.260   218.700     0.150
    16.886   237.170     0.150
    18.496   252.270     0.150
    42.849  3230.597     0.150
    42.855  3228.798     0.150
    42.867  3231.885     0.150
    44.014  3330.219     0.150
    44.028  3318.843     0.150
    44.032  3321.822     0.150
    47.435   509.783     0.150
    85.262   751.053     0.150
     1.011    32.777     0.150
     3.037    45.156     0.150
     3.529    51.469     0.150
     5.919    84.188     0.150
     6.414    92.508     0.150
    14.674   202.387     0.150
     0.827    24.078     0.150
     2.477    70.178     0.150
     2.562    71.708     0.150
     2.899    81.958     0.150
     2.965    48.598     0.150
     2.970    48.778     0.150
     3.458    93.748     0.150
     5.526   157.632     0.150
    38.589   438.298     0.150
    42.677  3166.798     0.150
    42.683  3168.293     0.150
    42.695  3164.363     0.150
    43.847  3265.772     0.150
    43.861  3252.200     0.150
    43.864  3261.258     0.150
    47.931   602.118     0.150
    77.944   712.258     0.150
     1.295    41.155     0.150
     1.516    46.445     0.150
     3.857   103.175     0.150
     4.881    70.445     0.150
     7.854   113.655     0.150
    10.974   152.235     0.150
    14.421   204.175     0.150
    14.468   205.285     0.150
    14.594   209.445     0.150
    14.919   209.375     0.150
     1.079    22.562     0.150
     1.089    22.578     0.150
     1.095    22.570     0.150
     1.081    37.094     0.150
     1.124    23.078     0.150
     2.025    36.711     0.150
     3.337    88.234     0.150
     4.377    67.164     0.150
     5.756    87.930     0.150
     7.292   108.148     0.150
     8.899   130.750     0.150
    47.794   525.914     0.150
    54.487   566.914     0.150
    59.183   597.461     0.150
    64.149   632.000     0.150
    64.722   636.961     0.150
    65.720   643.094     0.150
    65.901   644.758     0.150
    74.915   699.750     0.150
    85.406   757.547     0.150
     1.714    29.609     0.150
     1.782    55.939     0.150
     3.120    47.789     0.150
     4.569    67.150     0.150
     4.585    67.311     0.150
    19.483   265.949     0.150
    35.013   411.641     0.150
    42.699  3168.771     0.150
    42.705  3168.158     0.150
    42.717  3181.088     0.150
    43.867  3253.441     0.150
    43.881  3254.543     0.150
    43.885  3263.137     0.150
    64.069   628.801     0.150
    64.070   628.770     0.150
   144.482  1174.420     0.150
     1.845    29.062     0.150
     1.845    49.373     0.150
     1.839    54.443     0.150
     2.839    43.643     0.150
     3.973    58.613     0.150
    17.607   241.312     0.150
     4.755    68.648     0.150
     6.770    97.559     0.150
     9.219   132.398     0.150
    15.150   209.578     0.150
    15.221   210.246     0.150
    24.109   315.266     0.150
    32.017   388.488     0.150
    37.631   432.078     0.150
    43.312  3268.898     0.150
    43.318  3253.355     0.150
    43.330  3252.645     0.150
    44.475  3336.531     0.150
    44.488  3336.734     0.150
    44.492  3339.488     0.150
    46.946   507.457     0.150
    55.744   573.777     0.150
    56.001   575.629     0.150
    64.474   634.719     0.150
    65.002   671.293     0.150
    66.541   645.918     0.150
    85.267   752.949     0.150
     0.873    26.358     0.150
     1.022    32.959     0.150
     1.103    21.608     0.150
     3.352    52.738     0.150
     3.569   101.049     0.150
     5.473    85.549     0.150
     7.662   112.318     0.150
     8.232   123.479     0.150
    38.706   441.629     0.150
    64.268   632.078     0.150
    65.639   641.398     0.150
    74.824   697.748     0.150
     1.543    27.125     0.150
     2.430    41.205     0.150
    43.125  3246.059     0.150
    43.131  3249.688     0.150
    43.143  3247.977     0.150
    44.289  3334.395     0.150
    44.303  3334.711     0.150
    44.307  3339.742     0.150
     0.177    10.443     0.150
     0.584    14.344     0.150
     0.584     8.143     0.150
     0.584    12.834     0.150
     1.198    22.213     0.150
     1.226    22.453     0.150
     1.335    24.514     0.150
     1.427    41.723     0.150
     2.614    41.744     0.150
     2.614    74.143     0.150
     3.641    98.543     0.150
     4.294    65.113     0.150
     5.000   128.713     0.150
     5.000    73.033     0.150
     6.249    90.543     0.150
    11.680  3769.943     0.150
    11.854   294.393     0.150
    14.425   204.543     0.150
    15.489   215.643     0.150
    18.177   443.443     0.150
    23.596   307.104     0.150
    24.274   751.818     0.150
    24.725   318.654     0.150
    24.725   536.344     0.150
    24.725   754.693     0.150
    25.514   325.793     0.150
    25.508   328.854     0.150
    29.791   363.244     0.150
    29.791   363.254     0.150
    32.363   553.844     0.150
    32.363   553.574     0.150
    32.558   387.523     0.150
    32.567   388.373     0.150
    33.431   400.244     0.150
    33.431   399.744     0.150
    34.059   398.543     0.150
    34.158   730.244     0.150
    35.318   739.344     0.150
    35.812     8.000     0.150
    35.812   495.143     0.150
    35.812   561.043     0.150
    35.812   414.523     0.150
    35.901   417.344     0.150
    36.022   514.543     0.150
    36.022   895.844     0.150
    36.093   921.543     0.150
    36.887   425.934     0.150
    36.878   427.324     0.150
    37.526   431.744     0.150
    37.844   433.094     0.150
    37.844   435.293     0.150
    37.975   781.369     0.150
    40.745  1034.443     0.150
    40.821   460.143     0.150
    41.017   460.633     0.150
    41.017   584.113     0.150
    41.200   461.434     0.150
    41.996   469.053     0.150
    42.428   471.453     0.150
    42.604     8.102     0.150
    42.604   568.043     0.150
    42.604   845.643     0.150
    43.169  3251.070     0.150
    43.175  3249.086     0.150
    43.187  3238.363     0.150
    43.539   480.543     0.150
    43.794   482.383     0.150
    43.794   483.143     0.150
    44.334  3337.902     0.150
    44.348  3337.920     0.150
    44.352  3339.221     0.150
    44.859   491.943     0.150
    44.859    10.049     0.150
    45.346    13.199     0.150
    45.334   497.344     0.150
    45.334   495.684     0.150
    45.334   495.604     0.150
    45.904   499.004     0.150
    46.580   505.043     0.150
    46.580   505.713     0.150
    46.824   506.244     0.150
    46.824   506.193     0.150
    46.976   601.254     0.150
    47.187   508.943     0.150
    47.187   599.643     0.150
    47.163   510.643     0.150
    47.286   834.924     0.150
    47.511   511.793     0.150
    47.511   512.312     0.150
    47.660    13.000     0.150
    48.156   516.473     0.150
    48.156   516.453     0.150
    48.469   527.344     0.150
    48.469   532.543     0.150
    50.623   536.143     0.150
    50.842   536.703     0.150
    50.842   537.053     0.150
    51.302   976.646     0.150
    51.302   542.393     0.150
    51.302   542.803     0.150
    51.450   541.963     0.150
    51.450   542.004     0.150
    52.605   549.943     0.150
    52.605    12.400     0.150
    52.605    16.400     0.150
    53.098    10.199     0.150
    53.098    14.600     0.150
    53.270   554.498     0.150
    53.270  1003.504     0.150
    53.270   556.953     0.150
    53.298   556.893     0.150
    54.846   567.193     0.150
    55.272    11.000     0.150
    55.285    10.270     0.150
    55.576   571.773     0.150
    55.576   571.854     0.150
    55.837   573.803     0.150
    55.837   633.193     0.150
    55.817   573.523     0.150
    56.543   579.344     0.150
    56.602   579.254     0.150
    57.126    12.701     0.150
    57.458   585.824     0.150
    57.472   641.543     0.150
    57.472  1175.244     0.150
    57.472  1293.543     0.150
    58.009   589.674     0.150
    58.079    12.801     0.150
    58.079   713.943     0.150
    58.079  1295.943     0.150
    58.607   593.953     0.150
    58.997   596.713     0.150
    58.960  1082.143     0.150
    59.029   596.643     0.150
    59.186   596.703     0.150
    59.379   599.203     0.150
    59.632    13.701     0.150
    59.632   730.344     0.150
    60.697  1093.844     0.150
    61.295    14.000     0.150
    63.026   623.744     0.150
    63.263   625.943     0.150
    63.290     7.898     0.150
    63.290    12.898     0.150
    63.290   658.344     0.150
    63.596    12.201     0.150
    63.596    14.900     0.150
    63.596   627.613     0.150
    63.886   773.043     0.150
    63.886   869.443     0.150
    64.024   630.164     0.150
    64.024   630.254     0.150
    64.063   632.543     0.150
    64.122     8.100     0.150
    64.216   631.344     0.150
    64.405   633.693     0.150
    64.405  1150.033     0.150
    64.708  1157.193     0.150
    64.708  2365.469     0.150
    64.696    14.299     0.150
    64.795   870.543     0.150
    64.795  1407.844     0.150
    64.795   634.854     0.150
    64.840   638.203     0.150
    65.056   634.354     0.150
    65.339   639.973     0.150
    65.339   641.674     0.150
    65.517   641.453     0.150
    65.517   640.793     0.150
    65.529   641.424     0.150
    65.619   633.043     0.150
    65.619  1156.943     0.150
    65.619  1410.744     0.150
    65.892   642.344     0.150
    65.892  1166.543     0.150
    65.946   642.312     0.150
    65.946   641.812     0.150
    66.055   643.043     0.150
    66.055   643.133     0.150
    66.662   648.613     0.150
    66.662   648.713     0.150
    67.839   655.383     0.150
    68.509  2355.268     0.150
    68.509   659.344     0.150
    68.519   659.793     0.150
    68.519   659.604     0.150
    68.519   659.223     0.150
    68.672   661.703     0.150
    68.821   912.643     0.150
    68.821  1246.844     0.150
    68.924   662.744     0.150
    68.924   662.812     0.150
    69.006   664.143     0.150
    69.116  1192.443     0.150
    69.162   662.994     0.150
    69.345   665.654     0.150
    69.545   672.143     0.150
    69.545   683.943     0.150
    69.545   821.943     0.150
    69.545   922.943     0.150
    69.545  1669.943     0.150
    69.622   667.482     0.150
    69.573   669.443     0.150
    69.807   670.344     0.150
    69.807   669.533     0.150
    69.936   667.344     0.150
    70.089   668.924     0.150
    70.125   670.223     0.150
    70.267   671.143     0.150
    70.267   671.193     0.150
    70.267  1220.824     0.150
    70.419   673.193     0.150
    70.578   673.014     0.150
    70.578  1224.293     0.150
    70.606   683.943     0.150
    70.805   693.744     0.150
    70.805   933.543     0.150
    70.805   674.174     0.150
    70.805   674.174     0.150
    70.805   674.174     0.150
    70.805   693.793     0.150
    70.805   830.643     0.150
    70.805   933.553     0.150
    70.805  1226.443     0.150
    70.805  1501.084     0.150
    70.805  1696.363     0.150
    70.811   675.293     0.150
    71.003   675.643     0.150
    71.003   675.684     0.150
    71.003  1229.354     0.150
    70.948   675.643     0.150
    70.948   675.664     0.150
    71.149   676.643     0.150
    71.149   676.654     0.150
    71.449   677.174     0.150
    71.468   681.543     0.150
    71.775   680.133     0.150
    71.841   681.924     0.150
    71.888   681.393     0.150
    72.095   683.494     0.150
    72.219   682.533     0.150
    72.255   683.816     0.150
    72.255   684.154     0.150
    72.694   685.732     0.150
    72.579   687.943     0.150
    72.767   682.344     0.150
    72.767   946.143     0.150
    72.707   679.443     0.150
    72.707  1242.943     0.150
    72.707  1526.744     0.150
    72.888   687.154     0.150
    72.909   685.744     0.150
    73.091   684.643     0.150
    73.270   689.543     0.150
    73.270  1256.643     0.150
    73.300   689.344     0.150
    73.300   689.354     0.150
    73.394   688.664     0.150
    73.394   688.584     0.150
    73.515   689.334     0.150
    73.658   690.633     0.150
    73.658   691.703     0.150
    73.688   692.943     0.150
    73.688   693.033     0.150
    73.878   691.754     0.150
    73.878   692.744     0.150
    73.876    13.699     0.150
    74.022   692.383     0.150
    74.022   692.316     0.150
    74.022   692.244     0.150
    74.022   692.482     0.150
    74.022   692.244     0.150
    74.022  1563.943     0.150
    74.022  1743.943     0.150
    74.022  1863.943     0.150
    74.022  2349.943     0.150
    74.096   692.982     0.150
    74.348   695.203     0.150
    74.348     8.680     0.150
    74.348    12.480     0.150
    74.398   695.562     0.150
    74.406   695.584     0.150
    74.520   694.383     0.150
    74.528   694.494     0.150
    74.528   694.654     0.150
    74.528   694.473     0.150
    74.601   697.113     0.150
    74.605   695.744     0.150
    74.613   696.344     0.150
    74.618   695.744     0.150
    74.634   695.834     0.150
    74.741   697.254     0.150
    74.854   697.643     0.150
    74.866   697.943     0.150
    74.866   697.943     0.150
    74.817   700.143     0.150
    74.817    13.400     0.150
    74.817   700.053     0.150
    74.725   700.643     0.150
    74.725   696.373     0.150
    74.887   697.982     0.150
    74.890   697.844     0.150
    74.933   698.143     0.150
    74.933   698.104     0.150
    75.036    14.000     0.150
    75.067   698.943     0.150
    75.099  1269.844     0.150
    75.099   699.443     0.150
    75.099  1269.844     0.150
    75.099  1604.344     0.150
    75.099   699.404     0.150
    75.032   716.244     0.150
    75.177   700.859     0.150
    75.277   699.904     0.150
    75.385   700.744     0.150
    75.405   700.744     0.150
    75.405  1278.844     0.150
    75.405  1607.844     0.150
    75.475   702.732     0.150
    75.540   702.764     0.150
    75.647   702.344     0.150
    75.647   702.303     0.150
    75.698   702.143     0.150
    75.698   702.543     0.150
    75.698   702.393     0.150
    75.985   705.434     0.150
    76.077   704.543     0.150
    76.077  2693.844     0.150
    76.148   705.443     0.150
    76.148   705.344     0.150
    76.148   705.354     0.150
    76.145   707.062     0.150
    76.176   705.633     0.150
    76.181   700.543     0.150
    76.181  1246.244     0.150
    76.222   705.943     0.150
    76.222  1607.143     0.150
    76.222   706.043     0.150
    76.233     7.701     0.150
    76.233    13.500     0.150
    76.346   706.744     0.150
    76.369   707.184     0.150
    76.327   716.643     0.150
    76.513   707.344     0.150
    76.513   706.783     0.150
    76.549   707.543     0.150
    76.563   707.344     0.150
    76.619   709.004     0.150
    76.691   708.033     0.150
    76.705   707.764     0.150
    76.705   708.383     0.150
    76.834   710.783     0.150
    76.999   710.043     0.150
    77.015   711.443     0.150
    77.015   711.463     0.150
    77.064   711.406     0.150
    77.098   710.943     0.150
    77.130   710.443     0.150
    77.272   714.043     0.150
    77.272   714.043     0.150
    77.272   713.754     0.150
    77.294   711.363     0.150
    77.531   712.273     0.150
    77.581   712.744     0.150
    77.506   712.324     0.150
    77.662   712.516     0.150
    77.675   717.543     0.150
    77.675   717.543     0.150
    77.772   715.953     0.150
    77.786   714.844     0.150
    77.794   714.143     0.150
    77.815   717.744     0.150
    77.815   714.732     0.150
    77.815   717.043     0.150
    77.921   716.893     0.150
    77.984   716.004     0.150
    78.037   719.453     0.150
    78.169   716.357     0.150
    78.306   716.643     0.150
    78.401   718.676     0.150
    78.434   719.133     0.150
    78.684   719.643     0.150
    78.744   720.643     0.150
    78.837   720.643     0.150
    78.837   719.604     0.150
    79.127   720.664     0.150
    79.224   723.520     0.150
    79.293   723.344     0.150
    79.345   725.994     0.150
    79.477   724.643     0.150
    79.477   724.754     0.150
    79.496   724.643     0.150
    79.589   725.703     0.150
    79.612   726.223     0.150
    79.688   724.344     0.150
    79.849   727.383     0.150
    79.875   725.443     0.150
    79.887   726.043     0.150
    79.888   727.254     0.150
    79.975   726.643     0.150
    80.041   726.344     0.150
    80.081   726.744     0.150
    80.090   726.443     0.150
    80.505  1018.744     0.150
    80.588   730.643     0.150
    80.624   727.924     0.150
    80.684   731.053     0.150
    80.709   731.707     0.150
    80.720   730.170     0.150
    80.720   729.844     0.150
    80.720   731.453     0.150
    80.791   730.143     0.150
    80.803   731.443     0.150
    80.886   730.904     0.150
    80.950   730.443     0.150
    80.994   732.703     0.150
    81.072   733.523     0.150
    81.072     8.920     0.150
    81.052   731.562     0.150
    81.312   735.393     0.150
    81.273   735.643     0.150
    81.273   733.273     0.150
    81.343   733.254     0.150
    81.539   733.693     0.150
    81.539   733.633     0.150
    81.577   736.543     0.150
    81.579   738.643     0.150
    81.769   736.244     0.150
    81.796   737.334     0.150
    81.906   738.043     0.150
    81.942   736.748     0.150
    81.942   738.303     0.150
    82.107   738.543     0.150
    82.102   739.844     0.150
    82.069   738.943     0.150
    82.190   932.033     0.150
    82.190  1357.434     0.150
    82.182   740.143     0.150
    82.322   741.133     0.150
    82.589   740.543     0.150
    82.742   742.543     0.150
    82.872   742.643     0.150
    82.875   742.943     0.150
    82.888   743.143     0.150
    83.027   743.443     0.150
    83.027   744.062     0.150
    82.953   745.043     0.150
    83.066   743.604     0.150
    83.103   743.135     0.150
    83.193   743.744     0.150
    83.210   742.674     0.150
    83.315   745.643     0.150
    83.309   744.643     0.150
    83.460   745.143     0.150
    83.460  1364.943     0.150
    83.533   745.744     0.150
    83.589   929.068     0.150
    83.589   745.883     0.150
    83.599   747.344     0.150
    83.643   745.623     0.150
    83.576   747.443     0.150
    83.576   747.043     0.150
    83.730   748.443     0.150
    83.886   748.264     0.150
    83.886   747.584     0.150
    83.860   748.744     0.150
    84.107   750.943     0.150
    84.111   752.244     0.150
    84.435   749.381     0.150
    84.505  1371.914     0.150
    84.505   750.443     0.150
    84.505  1371.943     0.150
    84.804   753.434     0.150
    84.922   752.643     0.150
    84.922  1374.443     0.150
    84.922   753.424     0.150
    85.061   940.994     0.150
    85.107   753.523     0.150
    85.128   754.994     0.150
    85.136   754.344     0.150
    85.375   753.914     0.150
    85.432   755.104     0.150
    85.551   754.664     0.150
    85.783   756.293     0.150
    86.273   758.943     0.150
    86.761   762.982     0.150
    86.951   766.523     0.150
    86.964   766.113     0.150
    87.592   765.264     0.150
    87.724   767.232     0.150
    87.608   767.643     0.150
    87.608   765.164     0.150
    87.608   767.604     0.150
    87.910   767.969     0.150
    88.105   766.213     0.150
    88.211   769.092     0.150
    88.305   768.344     0.150
    88.536   772.244     0.150
    88.536   769.684     0.150
    88.536   771.033     0.150
    89.046   773.594     0.150
    89.178   771.584     0.150
    89.889   778.643     0.150
    89.889   779.643     0.150
    91.046   784.543     0.150
    92.161   792.643     0.150
    92.415   793.854     0.150
    92.639   786.854     0.150
    93.058   791.744     0.150
    93.072   790.062     0.150
    93.673   792.975     0.150
    93.656   798.344     0.150
    93.742   793.020     0.150
    94.241   798.143     0.150
    94.180   799.143     0.150
    94.838   798.393     0.150
    96.427   807.363     0.150
    96.429   805.453     0.150
    98.940   817.463     0.150
    99.909   821.943     0.150
   101.345   827.664     0.150
   110.470  1109.969     0.150
   111.815  8380.967     0.150
   111.826  8380.500     0.150
   116.089  1749.418     0.150
   118.214  1741.918     0.150
   121.692  1130.594     0.150
   134.251  1362.344     0.150
   146.528  1175.732     0.150
   147.658  1177.623     0.150
   153.495  1192.334     0.150
   159.924  1236.660     0.150
   161.241  1241.643     0.150
   163.636  1206.943     0.150
     0.864    13.969     0.150
     0.864    16.570     0.150
     1.532    46.359     0.150
     1.721    51.594     0.150
     2.691    40.445     0.150
     3.531    54.852     0.150
     3.747    54.766     0.150
     3.747    54.172     0.150
     4.011    60.875     0.150
     4.513    65.273     0.150
     4.567    66.844     0.150
     5.144    73.773     0.150
     5.144    73.539     0.150
     5.946    86.234     0.150
     6.433    91.672     0.150
     6.433   161.375     0.150
     7.722   110.266     0.150
     7.786   111.172     0.150
     7.860   110.273     0.150
     8.809   123.914     0.150
     9.001   126.305     0.150
     9.001   125.773     0.150
     9.784   137.203     0.150
    10.483   148.875     0.150
    11.037   156.359     0.150
    11.918  3651.172     0.150
    11.919   295.570     0.150
    11.919   165.195     0.150
    11.919   162.422     0.150
    12.086   311.039     0.150
    12.086   311.070     0.150
    12.086   167.641     0.150
    16.121  1223.195     0.150
    16.121  1218.531     0.150
    17.136   237.055     0.150
    18.395   247.469     0.150
    18.395   248.203     0.150
    24.403   581.047     0.150
    24.403  2304.109     0.150
    24.341   573.172     0.150
    24.851   533.180     0.150
    24.851     8.859     0.150
    25.409   327.742     0.150
    25.409   326.922     0.150
    26.708   610.172     0.150
    26.805   335.766     0.150
    26.805   337.578     0.150
    27.004   345.820     0.150
    27.004  9691.172     0.150
    29.293   363.273     0.150
    31.341   379.219     0.150
    32.242  2273.328     0.150
    32.444   385.500     0.150
    32.625   388.500     0.150
    32.625   388.594     0.150
    32.625   388.883     0.150
    33.219   393.703     0.150
    33.219     7.930     0.150
    33.879   398.211     0.150
    33.879   398.328     0.150
    34.246   484.672     0.150
    34.246   563.070     0.150
    34.246   719.375     0.150
    34.246   857.570     0.150
    34.479  2262.070     0.150
    34.918   412.875     0.150
    34.918   412.625     0.150
    34.918   412.375     0.150
    35.452   750.773     0.150
    36.047   514.273     0.150
    36.047   557.969     0.150
    36.047   416.555     0.150
    36.108   515.672     0.150
    36.108   559.969     0.150
    36.108   922.375     0.150
    36.210   419.969     0.150
    36.738   425.609     0.150
    36.865   425.844     0.150
    36.865   426.430     0.150
    37.983   435.469     0.150
    38.023   789.695     0.150
    38.023  2247.000     0.150
    38.912   441.570     0.150
    38.912   442.945     0.150
    40.268   453.000     0.150
    40.897   461.234     0.150
    40.897   460.984     0.150
    40.940   471.773     0.150
    40.940   585.969     0.150
    41.445   464.211     0.150
    41.445   464.180     0.150
    41.476   465.102     0.150
    41.697   464.672     0.150
    42.623   468.375     0.150
    42.623   474.305     0.150
    42.666   473.961     0.150
    42.781    13.805     0.150
    43.021  3249.094     0.150
    43.027  3247.281     0.150
    43.039  3260.578     0.150
    43.927   881.750     0.150
    44.185  3350.297     0.150
    44.198  3356.086     0.150
    44.202  3356.234     0.150
    44.976   494.164     0.150
    45.002    17.000     0.150
    45.396   497.469     0.150
    45.439   497.805     0.150
    45.406   892.875     0.150
    45.406   496.352     0.150
    45.406   496.094     0.150
    45.406   496.031     0.150
    45.406   496.383     0.150
    45.500    10.000     0.150
    45.500    14.602     0.150
    46.134   503.234     0.150
    46.555   505.094     0.150
    46.832   507.766     0.150
    46.832   507.719     0.150
    46.929   507.578     0.150
    47.184   930.016     0.150
    47.352   509.828     0.150
    47.734   514.000     0.150
    47.734   514.039     0.150
    47.734   514.094     0.150
    47.862   515.719     0.150
    47.811    13.703     0.150
    48.561   521.734     0.150
    48.682   534.773     0.150
    48.682   629.375     0.150
    48.682   680.969     0.150
    49.140   968.352     0.150
    49.770   527.922     0.150
    49.770   962.445     0.150
    49.901   531.539     0.150
    50.737   537.625     0.150
    51.264   541.383     0.150
    51.364  3876.531     0.150
    51.484  3872.906     0.150
    51.421   987.352     0.150
    51.421   542.398     0.150
    51.421   542.430     0.150
    51.625   543.953     0.150
    51.780   545.281     0.150
    52.406   553.273     0.150
    52.406   552.859     0.150
    52.581   550.875     0.150
    52.782    13.195     0.150
    52.782    18.398     0.150
    53.064   556.141     0.150
    53.064  1025.484     0.150
    53.088   556.398     0.150
    53.088   577.750     0.150
    53.088  1027.125     0.150
    53.096   576.328     0.150
    53.239    14.797     0.150
    53.239    19.602     0.150
    53.510   557.461     0.150
    53.849   558.992     0.150
    54.582   565.141     0.150
    54.582   565.281     0.150
    55.426   569.523     0.150
    55.896   574.195     0.150
    55.871   573.750     0.150
    56.130   573.633     0.150
    56.130  2403.445     0.150
    56.130  1038.773     0.150
    56.130   574.578     0.150
    56.169   574.805     0.150
    56.797   581.750     0.150
    57.364   585.078     0.150
    57.303  1060.172     0.150
    57.663    12.797     0.150
    57.663    15.602     0.150
    57.663  1084.570     0.150
    57.782   585.273     0.150
    57.747   582.602     0.150
    57.768   636.672     0.150
    57.768  1301.172     0.150
    58.261    12.805     0.150
    58.261    18.000     0.150
    58.261  1066.773     0.150
    58.261  1091.172     0.150
    59.124    14.000     0.150
    59.124   726.172     0.150
    59.141   596.570     0.150
    59.285  1087.719     0.150
    59.224  1087.594     0.150
    59.224   600.070     0.150
    59.450  2363.445     0.150
    59.509   596.352     0.150
    59.756    12.898     0.150
    59.756    18.898     0.150
    60.994   611.461     0.150
    61.449    12.305     0.150
    61.449    18.305     0.150
    62.765  1130.953     0.150
    63.076   625.969     0.150
    63.116   624.125     0.150
    63.424    13.703     0.150
    63.424    18.305     0.150
    63.424  1132.570     0.150
    63.543  1164.516     0.150
    63.595  1153.750     0.150
    63.759    12.195     0.150
    63.759    18.500     0.150
    63.759  1161.773     0.150
    64.055  1147.805     0.150
    64.149   630.578     0.150
    64.292   670.625     0.150
    64.292  1154.711     0.150
    64.292   632.062     0.150
    64.292   632.078     0.150
    64.361   633.352     0.150
    64.326    11.102     0.150
    64.326  1150.570     0.150
    64.401   670.625     0.150
    64.502   633.469     0.150
    64.658   634.961     0.150
    64.658  1152.242     0.150
    64.768  1401.211     0.150
    64.821   634.125     0.150
    64.880    13.398     0.150
    64.924   638.133     0.150
    64.988   673.273     0.150
    65.087   666.570     0.150
    65.087  1414.070     0.150
    65.087   636.789     0.150
    65.609   640.602     0.150
    65.609   643.922     0.150
    65.762   642.492     0.150
    65.801   642.484     0.150
    65.921   643.961     0.150
    66.202  2362.375     0.150
    66.311   644.773     0.150
    66.311   644.953     0.150
    66.445    10.500     0.150
    66.445    19.500     0.150
    66.445  1172.969     0.150
    67.336   652.734     0.150
    67.590   654.023     0.150
    68.030  1206.945     0.150
    68.132   657.266     0.150
    68.201   658.141     0.150
    68.357   659.773     0.150
    68.413   666.875     0.150
    68.576   661.719     0.150
    68.576   661.891     0.150
    68.778  2356.547     0.150
    68.787   660.742     0.150
    68.787   662.242     0.150
    68.787   662.281     0.150
    68.832   661.742     0.150
    68.737   824.094     0.150
    68.737  1222.875     0.150
    68.955   664.578     0.150
    68.939    12.602     0.150
    68.939  1207.570     0.150
    68.939  1253.969     0.150
    69.118   920.375     0.150
    69.118  1476.969     0.150
    69.184  1207.094     0.150
    69.324  1198.773     0.150
    69.509   667.820     0.150
    69.555   668.141     0.150
    69.611   667.062     0.150
    69.745   670.273     0.150
    69.842  1216.672     0.150
    69.842  1491.273     0.150
    69.842   666.711     0.150
    69.842   666.672     0.150
    69.842   666.734     0.150
    69.908   668.148     0.150
    69.915   669.984     0.150
    70.109   672.961     0.150
    70.086   838.094     0.150
    70.086  1232.211     0.150
    70.113   865.289     0.150
    70.113  1235.789     0.150
    70.302   672.531     0.150
    70.302   672.375     0.150
    70.302   672.812     0.150
    70.344   669.984     0.150
    70.344  1218.969     0.150
    70.383   671.242     0.150
    70.383  1221.234     0.150
    70.371   660.172     0.150
    70.577   670.945     0.150
    70.523   672.148     0.150
    70.523  1222.930     0.150
    70.579   673.633     0.150
    70.702   674.625     0.150
    70.610   817.352     0.150
    70.610  1242.891     0.150
    70.857   677.078     0.150
    70.857   676.414     0.150
    70.891   673.875     0.150
    70.835   674.023     0.150
    70.835  1226.320     0.150
    70.851    13.102     0.150
    70.851  1232.672     0.150
    70.901   674.469     0.150
    71.073   676.422     0.150
    71.093   678.078     0.150
    71.100   935.172     0.150
    71.100   675.102     0.150
    71.100   675.102     0.150
    71.100   675.102     0.150
    71.100   831.711     0.150
    71.100   935.266     0.150
    71.100  1229.219     0.150
    71.100  1505.078     0.150
    71.100  1703.445     0.150
    71.120   678.359     0.150
    71.145   676.984     0.150
    71.214   808.789     0.150
    71.263   676.609     0.150
    71.263  1231.414     0.150
    71.208   676.664     0.150
    71.252   702.828     0.150
    71.430     1.312     0.150
    71.409   677.500     0.150
    71.538   678.516     0.150
    71.563   679.328     0.150
    71.504   704.250     0.150
    71.504   852.523     0.150
    71.527   860.273     0.150
    71.742  1254.203     0.150
    71.656   704.922     0.150
    71.816   680.328     0.150
    71.992   690.273     0.150
    71.880   703.984     0.150
    71.918   706.922     0.150
    71.928   706.562     0.150
    71.928   857.266     0.150
    72.042   681.422     0.150
    72.057  1239.070     0.150
    72.067   707.781     0.150
    72.067   872.898     0.150
    72.199   683.773     0.150
    72.200   705.172     0.150
    72.213   707.398     0.150
    72.355   684.383     0.150
    72.436   683.984     0.150
    72.424   707.133     0.150
    72.425   876.789     0.150
    72.664   683.539     0.150
    72.664   685.070     0.150
    72.664   685.383     0.150
    72.664   685.492     0.150
    72.673   710.914     0.150
    72.673   857.750     0.150
    72.785   688.078     0.150
    72.892   690.234     0.150
    72.936   958.273     0.150
    72.867   711.859     0.150
    72.975   687.016     0.150
    73.063   957.375     0.150
    73.010   713.664     0.150
    73.010   871.719     0.150
    73.171   688.109     0.150
    73.193   687.719     0.150
    73.120   713.562     0.150
    73.120   870.195     0.150
    73.233   689.062     0.150
    73.359   689.078     0.150
    73.416   689.703     0.150
    73.439   688.555     0.150
    73.439   691.859     0.150
    73.445   691.953     0.150
    73.517   692.516     0.150
    73.422   688.828     0.150
    73.422   715.266     0.150
    73.422   869.531     0.150
    73.562   866.273     0.150
    73.562  1308.773     0.150
    73.498   708.469     0.150
    73.612   692.969     0.150
    73.568   690.219     0.150
    73.628   691.039     0.150
    73.529  1270.945     0.150
    73.618   959.273     0.150
    73.595   716.953     0.150
    73.595   900.898     0.150
    73.595  1277.641     0.150
    73.664   690.492     0.150
    73.658   711.828     0.150
    73.658   871.484     0.150
    73.658  1276.164     0.150
    73.795   691.562     0.150
    73.899   692.031     0.150
    73.899   692.023     0.150
    73.950   692.180     0.150
    73.950   712.195     0.150
    73.950  1282.672     0.150
    73.950   693.250     0.150
    73.959   693.703     0.150
    74.125   721.094     0.150
    74.125   912.672     0.150
    74.125  1281.031     0.150
    74.177   720.594     0.150
    74.177   876.578     0.150
    74.177  1284.125     0.150
    74.308    10.703     0.150
    74.308  1298.172     0.150
    74.308   694.359     0.150
    74.308   694.172     0.150
    74.308    10.703     0.150
    74.308   864.172     0.150
    74.308   887.172     0.150
    74.308  1267.172     0.150
    74.308  1276.172     0.150
    74.308  1298.172     0.150
    74.308  1329.172     0.150
    74.308  1584.172     0.150
    74.308  1803.172     0.150
    74.308  2001.172     0.150
    74.308  2344.172     0.150
    74.308  2355.172     0.150
    74.308  2365.172     0.150
    74.308  2554.172     0.150
    74.308  2573.172     0.150
    74.308  3535.172     0.150
    74.308  7161.172     0.150
    74.308  8121.172     0.150
    74.308  9141.172     0.150
    74.308  9141.172     0.150
    74.308  9381.172     0.150
    74.308  9381.172     0.150
    74.308  9381.172     0.150
    74.308  9681.172     0.150
    74.308 10941.172     0.150
    74.308 12921.172     0.150
    74.308 14301.172     0.150
    74.308 14301.172     0.150
    74.308 14301.172     0.150
    74.308 16221.172     0.150
    74.308 19881.172     0.150
    74.240   714.039     0.150
    74.240   884.500     0.150
    74.240  1283.781     0.150
    74.343   695.016     0.150
    74.302   719.766     0.150
    74.302   881.375     0.150
    74.302  1282.930     0.150
    74.385   715.961     0.150
    74.385   879.055     0.150
    74.476   696.469     0.150
    74.528    10.125     0.150
    74.528  1279.812     0.150
    74.669   696.711     0.150
    74.675   696.883     0.150
    74.657    24.359     0.150
    74.657   809.711     0.150
    74.657  1288.359     0.150
    74.784   697.234     0.150
    74.816  2330.875     0.150
    74.816   696.375     0.150
    74.816   696.414     0.150
    74.824   696.523     0.150
    74.824   696.570     0.150
    74.824   696.633     0.150
    74.824   696.594     0.150
    74.873   696.453     0.150
    74.896   698.133     0.150
    74.894  1293.359     0.150
    74.836    20.734     0.150
    74.836   877.273     0.150
    74.836  1287.953     0.150
    74.851   693.914     0.150
    74.851    29.234     0.150
    74.851   876.602     0.150
    74.851  1289.461     0.150
    74.895   703.203     0.150
    75.101   699.414     0.150
    75.018   699.852     0.150
    75.018   837.883     0.150
    75.018  1288.031     0.150
    75.142   699.570     0.150
    75.153  1263.273     0.150
    75.153  1295.875     0.150
    75.153   699.375     0.150
    75.153  1263.273     0.150
    75.172   699.766     0.150
    75.178   716.570     0.150
    75.178   699.375     0.150
    75.222   717.070     0.150
    75.222   699.773     0.150
    75.293    13.500     0.150
    75.353   700.672     0.150
    75.387   718.469     0.150
    75.387   701.172     0.150
    75.296   701.469     0.150
    75.455   701.523     0.150
    75.367   882.414     0.150
    75.367   884.742     0.150
    75.374  1285.516     0.150
    75.392   891.812     0.150
    75.484   701.570     0.150
    75.484   703.430     0.150
    75.569    20.375     0.150
    75.569   701.742     0.150
    75.674   719.070     0.150
    75.674   702.375     0.150
    75.692   718.469     0.150
    75.692   702.672     0.150
    75.692   702.719     0.150
    75.692   702.773     0.150
    75.692  1278.469     0.150
    75.616    26.969     0.150
    75.616  1299.492     0.150
    75.937   719.570     0.150
    75.937  1272.969     0.150
    75.937   704.070     0.150
    75.937  1272.969     0.150
    75.937   704.133     0.150
    75.988   724.570     0.150
    75.988  2333.875     0.150
    75.988   704.320     0.150
    75.901    16.430     0.150
    76.014    24.367     0.150
    76.014   887.398     0.150
    76.080    20.531     0.150
    76.080   886.961     0.150
    76.080  1300.219     0.150
    76.369   706.375     0.150
    76.369   728.469     0.150
    76.418   706.375     0.150
    76.437   707.172     0.150
    76.437   726.969     0.150
    76.437  2334.469     0.150
    76.385   698.773     0.150
    76.385  1281.570     0.150
    76.461   707.266     0.150
    76.404    10.602     0.150
    76.508   724.773     0.150
    76.508   707.570     0.150
    76.508  1289.672     0.150
    76.508  1312.273     0.150
    76.508  2349.273     0.150
    76.441   707.578     0.150
    76.600   707.703     0.150
    76.637   708.875     0.150
    76.637   731.070     0.150
    76.678   728.375     0.150
    76.678  2332.172     0.150
    76.799   709.023     0.150
    76.842   709.273     0.150
    76.850   725.375     0.150
    76.850  1286.469     0.150
    76.850   708.773     0.150
    76.850  1286.469     0.150
    76.909   731.172     0.150
    76.909  1298.273     0.150
    76.909  2331.070     0.150
    76.971   709.820     0.150
    77.041  2332.836     0.150
    77.088   714.570     0.150
    77.290   711.875     0.150
    77.307   712.172     0.150
    77.307   733.773     0.150
    77.347   712.266     0.150
    77.387   712.773     0.150
    77.425   711.570     0.150
    77.519   712.562     0.150
    77.519   712.539     0.150
    77.546   713.273     0.150
    77.561  1322.070     0.150
    77.561  1656.773     0.150
    77.753   714.484     0.150
    77.689   714.070     0.150
    77.689  1307.773     0.150
    77.689   713.672     0.150
    77.689   714.133     0.150
    77.689   714.023     0.150
    77.796  2331.430     0.150
    77.818  2331.773     0.150
    77.818   714.578     0.150
    77.872   715.609     0.150
    77.948  2333.195     0.150
    77.965   716.070     0.150
    77.965   738.969     0.150
    78.012  1629.773     0.150
    78.037  2332.891     0.150
    78.080   716.273     0.150
    78.080   716.328     0.150
    78.119   718.484     0.150
    78.088   716.172     0.150
    78.088   715.969     0.150
    78.088   715.961     0.150
    78.128  2329.492     0.150
    78.161  1630.469     0.150
    78.154  2330.992     0.150
    78.167  2331.164     0.150
    78.198   732.328     0.150
    78.198  1629.773     0.150
    78.193  2331.664     0.150
    78.235   732.539     0.150
    78.235  1631.875     0.150
    78.268  2333.242     0.150
    78.330   734.828     0.150
    78.330  1635.375     0.150
    78.342   722.266     0.150
    78.396   718.766     0.150
    78.463   718.781     0.150
    78.520   734.359     0.150
    78.520  1637.469     0.150
    78.531   717.773     0.150
    78.603   724.602     0.150
    78.604  1637.469     0.150
    78.648   719.375     0.150
    78.794   726.070     0.150
    78.978   721.070     0.150
    78.978   720.984     0.150
    79.029   727.875     0.150
    79.018  2331.391     0.150
    79.037   721.172     0.150
    79.063   741.750     0.150
    79.063  1665.789     0.150
    79.085   720.281     0.150
    79.132   721.383     0.150
    79.168  2331.289     0.150
    79.168   722.430     0.150
    79.279   721.672     0.150
    79.328   723.273     0.150
    79.413  1997.805     0.150
    79.418  1329.820     0.150
    79.568   724.070     0.150
    79.568   724.141     0.150
    79.588   724.773     0.150
    79.632   744.133     0.150
    79.632   924.148     0.150
    79.620     9.703     0.150
    79.620  1325.273     0.150
    79.800   725.273     0.150
    79.772   725.469     0.150
    79.772   725.359     0.150
    79.791   725.570     0.150
    79.882   727.023     0.150
    79.882   726.969     0.150
    79.900   727.211     0.150
    79.806   725.773     0.150
    79.956  1654.289     0.150
    79.912    10.898     0.150
    79.912   915.570     0.150
    79.912  1843.672     0.150
    79.987   734.469     0.150
    79.987  1653.609     0.150
    79.987   729.664     0.150
    79.984   726.477     0.150
    79.984   726.641     0.150
    80.094   729.102     0.150
    80.080   727.375     0.150
    80.074  1329.070     0.150
    80.074  1844.469     0.150
    80.125   728.609     0.150
    80.168   727.484     0.150
    80.182   728.273     0.150
    80.270   728.570     0.150
    80.327   728.281     0.150
    80.327   727.766     0.150
    80.298   727.633     0.150
    80.337   728.070     0.150
    80.404   715.273     0.150
    80.375   728.969     0.150
    80.385   728.375     0.150
    80.480   729.875     0.150
    80.527   729.875     0.150
    80.787   933.461     0.150
    80.787  1668.383     0.150
    80.830   733.430     0.150
    80.830  1671.812     0.150
    80.802   919.969     0.150
    80.802  1024.070     0.150
    80.802  1860.672     0.150
    80.910   733.469     0.150
    81.009   731.898     0.150
    81.009   731.875     0.150
    81.009   732.031     0.150
    80.996   731.945     0.150
    81.123   735.359     0.150
    81.300   720.875     0.150
    81.206   732.375     0.150
    81.206   732.469     0.150
    81.419   734.875     0.150
    81.477   737.703     0.150
    81.558   741.875     0.150
    81.802   735.211     0.150
    81.802   734.945     0.150
    81.817   733.922     0.150
    82.109   732.273     0.150
    82.177   739.469     0.150
    82.213   739.633     0.150
    82.341   738.328     0.150
    82.441   946.953     0.150
    82.441  1378.039     0.150
    82.441  1700.359     0.150
    82.551   736.875     0.150
    82.761   736.602     0.150
    82.879   741.672     0.150
    82.944   737.375     0.150
    82.993   743.484     0.150
    83.332   743.469     0.150
    83.357   744.180     0.150
    83.357   744.172     0.150
    83.343   747.570     0.150
    83.407   949.844     0.150
    83.407  1700.930     0.150
    83.577   746.172     0.150
    83.707   746.375     0.150
    83.707  1365.070     0.150
    83.707   748.203     0.150
    83.741   743.125     0.150
    83.762   745.062     0.150
    83.847  1828.320     0.150
    83.892   748.070     0.150
    83.966   754.570     0.150
    83.883   746.055     0.150
    84.033   747.273     0.150
    84.070   749.023     0.150
    83.987   744.625     0.150
    84.450   748.195     0.150
    84.768   758.711     0.150
    84.753  1371.953     0.150
    84.753   751.773     0.150
    84.753  1371.969     0.150
    84.777   752.281     0.150
    84.777   752.469     0.150
    84.777   752.633     0.150
    84.923   754.141     0.150
    85.169   753.672     0.150
    85.169  1374.969     0.150
    85.169   754.820     0.150
    85.282  1728.703     0.150
    85.282   756.875     0.150
    85.295   756.812     0.150
    85.361   751.602     0.150
    85.390   756.969     0.150
    85.472   754.438     0.150
    86.075   756.297     0.150
    86.507   763.211     0.150
    86.564   758.867     0.150
    86.627   761.078     0.150
    86.727   757.922     0.150
    86.948   765.875     0.150
    86.854   762.484     0.150
    87.172   988.281     0.150
    87.172  1423.398     0.150
    87.172   766.070     0.150
    87.208   765.562     0.150
    87.349   767.305     0.150
    87.427   766.805     0.150
    87.462   765.141     0.150
    87.462   765.148     0.150
    87.462   764.820     0.150
    87.462   764.812     0.150
    87.683   764.250     0.150
    88.518   771.492     0.150
    88.539  1405.367     0.150
    88.539   769.969     0.150
    88.539   769.883     0.150
    88.539   770.062     0.150
    88.921   768.852     0.150
    89.022   772.094     0.150
    89.292   770.555     0.150
    89.302   771.992     0.150
    89.399   769.633     0.150
    89.875   775.719     0.150
    89.859   775.328     0.150
    90.402   773.609     0.150
    90.457   777.211     0.150
    90.480   775.969     0.150
    90.724   776.359     0.150
    90.924   780.562     0.150
    91.604   783.047     0.150
    92.016   783.375     0.150
    92.623   794.594     0.150
    92.765   786.570     0.150
    92.972   786.773     0.150
    92.972   786.805     0.150
    93.407   793.734     0.150
    93.951   793.953     0.150
    94.118   793.070     0.150
    94.556   794.969     0.150
    94.964   798.031     0.150
    94.964   798.078     0.150
    95.060   795.359     0.150
    95.253   799.742     0.150
    95.614   801.555     0.150
    95.614   801.773     0.150
    95.618   801.289     0.150
    96.321  1806.172     0.150
    96.751   805.641     0.150
    97.134   806.773     0.150
    97.617   811.141     0.150
    98.081   812.680     0.150
    99.207   815.688     0.150
    99.231   818.891     0.150
    99.231   819.109     0.150
    99.622   811.820     0.150
   105.998   857.250     0.150
   111.272   881.859     0.150
   111.630  8393.148     0.150
   111.641  8397.070     0.150
   111.944  8411.148     0.150
   111.944  8414.383     0.150
   111.960  8423.047     0.150
   113.884   891.516     0.150
   115.463  1118.844     0.150
   115.942  1749.875     0.150
   121.509  1130.578     0.150
   124.164  1134.492     0.150
   125.504  1138.328     0.150
   133.772  1142.305     0.150
   133.772  1154.148     0.150
   133.975  1141.445     0.150
   133.975  1153.211     0.150
   135.225  1154.492     0.150
   138.938  1156.648     0.150
   139.430  1153.617     0.150
   139.430  1154.211     0.150
   141.867  1163.172     0.150
   142.843  1166.523     0.150
   147.785  1180.750     0.150
   149.298  1185.242     0.150
   150.196  1177.953     0.150
   153.792  1191.344     0.150
   160.188  1191.484     0.150
   163.011  1194.172     0.150
     2.820    77.219     0.150
     3.705    55.297     0.150
     4.686    68.719     0.150
     5.212    74.430     0.150
     6.056    90.594     0.150
     9.872   139.766     0.150
    10.527   149.477     0.150
    15.579   219.273     0.150
    16.114  1209.023     0.150
    16.114  1209.008     0.150
    18.492   253.695     0.150
    24.462   316.125     0.150
    24.903   320.797     0.150
    25.698   329.367     0.150
    26.888   338.484     0.150
    32.193   384.820     0.150
    33.997   403.469     0.150
    34.460   404.695     0.150
    36.258   420.750     0.150
    38.945   442.820     0.150
    42.955  3240.734     0.150
    42.961  3248.547     0.150
    42.973  3245.156     0.150
    43.982   484.695     0.150
    44.118  3326.617     0.150
    44.131  3319.562     0.150
    44.135  3317.344     0.150
    45.434   496.625     0.150
    46.064   501.078     0.150
    46.687   504.516     0.150
    46.943   508.867     0.150
    47.143   510.820     0.150
    47.833   515.555     0.150
    51.293  3851.992     0.150
    51.740   545.711     0.150
    51.740   545.695     0.150
    52.432   549.266     0.150
    52.673   554.117     0.150
    55.008   568.508     0.150
    56.215   579.711     0.150
    56.257   578.523     0.150
    56.257   576.594     0.150
    56.296   580.055     0.150
    59.338   600.375     0.150
    64.626   635.367     0.150
    64.957   643.867     0.150
    65.211   638.375     0.150
    66.311   645.570     0.150
    66.420   646.125     0.150
    66.547   650.266     0.150
    70.299   671.766     0.150
    71.227   677.664     0.150
    71.227   677.664     0.150
    71.227   677.664     0.150
    71.227  1233.727     0.150
    72.368   684.117     0.150
    73.256   689.875     0.150
    74.432   729.367     0.150
    74.807   698.688     0.150
    74.944   697.828     0.150
    74.944   698.766     0.150
    74.951   698.125     0.150
    75.278   702.469     0.150
    75.278   702.469     0.150
    75.476   702.367     0.150
    75.513   702.766     0.150
    75.799   704.469     0.150
    75.816   704.266     0.150
    75.960   705.570     0.150
    76.351   708.664     0.150
    76.496   708.367     0.150
    76.923   708.664     0.150
    76.923   708.641     0.150
    77.375   714.867     0.150
    80.267   724.266     0.150
    80.267   905.367     0.150
    80.930   918.570     0.150
    80.930  1026.570     0.150
    80.930  1658.766     0.150
    85.486   757.766     0.150
    85.486   758.070     0.150
    92.926   792.492     0.150
    92.926   790.789     0.150
    96.272   806.680     0.150
   111.553  8400.312     0.150
   111.564  8401.641     0.150
   111.569  8447.594     0.150
     3.425    49.062     0.150
     5.284   130.484     0.150
    12.267   296.484     0.150
    24.531   319.797     0.150
    41.775   467.281     0.150
    50.164   532.336     0.150
    64.423   636.586     0.150
    64.423     6.602     0.150
    66.572   651.391     0.150
    85.551   756.578     0.150
     1.834    29.453     0.150
     2.528    39.062     0.150
     3.737    55.156     0.150
     4.164    61.664     0.150
     4.768    72.203     0.150
     4.915    74.133     0.150
     5.616    83.438     0.150
     6.092    90.297     0.150
     6.311    94.336     0.150
     7.389   108.188     0.150
     7.950   116.805     0.150
     8.901   128.156     0.150
    14.342   211.117     0.150
    16.903   237.891     0.150
    34.462   409.086     0.150
    42.782   482.531     0.150
    42.931  3226.766     0.150
    42.937  3227.188     0.150
    42.949  3228.516     0.150
    44.093  3348.523     0.150
    44.107  3320.719     0.150
    44.111  3354.773     0.150
    45.436   498.016     0.150
    46.772   507.594     0.150
    47.138   514.461     0.150
    47.640   515.125     0.150
    51.279  3854.875     0.150
    64.662   643.281     0.150
    65.245   640.477     0.150
    71.435   679.195     0.150
    72.395   685.203     0.150
    74.987   698.781     0.150
    92.967  1457.297     0.150
   111.553  8275.320     0.150
   144.197  1173.531     0.150
   146.984  1180.852     0.150
   148.824  1186.336     0.150
     1.092    15.344     0.150
     1.892    28.672     0.150
     4.128    61.383     0.150
     5.322    73.797     0.150
     5.725    82.039     0.150
    14.398   196.508     0.150
    14.969   204.773     0.150
    42.849  3227.242     0.150
    42.855  3229.469     0.150
    42.867  3229.961     0.150
    71.503   679.359     0.150
     0.506    15.695     0.150
     1.709    28.898     0.150
     2.525    40.125     0.150
     3.670    55.336     0.150
     3.871    56.188     0.150
     4.014    58.047     0.150
     4.113    60.789     0.150
     4.167    61.750     0.150
     5.292   169.617     0.150
     5.705    82.648     0.150
     6.106    88.844     0.150
     8.033   112.656     0.150
     9.193   129.945     0.150
    10.480   147.227     0.150
    10.682   149.617     0.150
    11.381   160.320     0.150
    12.135   173.000     0.150
    18.595   254.148     0.150
    20.932   280.664     0.150
    24.429     7.500     0.150
    24.532   316.953     0.150
    24.942   320.750     0.150
    24.942   320.398     0.150
    26.960   339.234     0.150
    26.996   340.664     0.150
    26.996   340.766     0.150
    34.106   401.414     0.150
    34.358   405.164     0.150
    36.233   759.594     0.150
    38.009   435.750     0.150
    38.085   435.680     0.150
    41.091   469.398     0.150
    42.868   477.164     0.150
    42.880  3229.031     0.150
    42.886  3232.742     0.150
    42.898  3223.211     0.150
    44.041  3307.844     0.150
    44.055  3311.688     0.150
    44.059  3311.422     0.150
    45.449   496.789     0.150
    45.449   496.953     0.150
    46.857   508.297     0.150
    47.057   510.789     0.150
    47.057   511.469     0.150
    47.117   510.344     0.150
    48.518   520.969     0.150
    50.817   538.297     0.150
    50.817   538.273     0.150
    51.235  3854.562     0.150
    55.086   568.297     0.150
    56.382   577.805     0.150
    58.454   593.555     0.150
    59.896   603.977     0.150
    60.834   609.859     0.150
    64.477   633.680     0.150
    64.486     7.500     0.150
    64.749   636.398     0.150
    65.004   637.594     0.150
    65.021    10.805     0.150
    65.330   640.094     0.150
    66.410   646.516     0.150
    66.638   650.398     0.150
    67.773   656.203     0.150
    68.422   660.289     0.150
    69.370   672.297     0.150
    69.664   667.688     0.150
    70.095   694.695     0.150
    73.187   682.094     0.150
    73.314   685.398     0.150
    73.884   691.891     0.150
    74.150   693.094     0.150
    75.013   698.695     0.150
    75.040   698.797     0.150
    75.044   698.797     0.150
    75.929   703.898     0.150
    76.756   705.398     0.150
    78.553   717.766     0.150
    80.392   726.594     0.150
    81.201   734.227     0.150
    82.016   736.844     0.150
    82.016   736.797     0.150
    84.076   750.031     0.150
    85.610   755.000     0.150
    99.473   820.445     0.150
   144.872  1174.609     0.150
   154.044  1195.219     0.150
   154.044  1194.594     0.150
     2.359    39.852     0.150
     2.551    75.945     0.150
     5.237    73.906     0.150
     6.293    93.977     0.150
     7.942   116.516     0.150
     8.183   120.312     0.150
     8.563   125.273     0.150
     8.992   130.766     0.150
    15.601   220.891     0.150
     0.910    32.117     0.150
     1.665    26.047     0.150
     1.747    27.391     0.150
     1.960    30.008     0.150
     5.207    72.984     0.150
     6.569    93.586     0.150
     9.406   132.641     0.150
    24.839   314.961     0.150
    50.722   536.320     0.150
     0.549    10.211     0.150
     1.617    28.453     0.150
     1.843    29.906     0.150
     2.167    33.492     0.150
     2.399    72.422     0.150
     2.658    40.820     0.150
     2.911    42.312     0.150
     2.911    40.375     0.150
     3.514    52.461     0.150
     3.881    58.016     0.150
     3.979    57.211     0.150
     3.979    56.023     0.150
     4.036    61.336     0.150
     4.108    62.352     0.150
     4.146    62.891     0.150
     4.611    67.219     0.150
     4.662    67.820     0.150
     4.672    67.789     0.150
     4.755    67.812     0.150
     4.755    66.914     0.150
     4.840    71.445     0.150
     5.127    74.391     0.150
     5.251    76.344     0.150
     5.392    75.359     0.150
     5.392   165.484     0.150
     5.392    75.820     0.150
     5.392    76.102     0.150
     5.702    82.445     0.150
     5.780    82.734     0.150
     6.116    87.875     0.150
     6.168    88.594     0.150
     6.217    89.586     0.150
     6.629    94.250     0.150
     6.736    96.750     0.150
     6.773    96.266     0.150
     6.774    96.531     0.150
     6.736    96.852     0.150
     6.838    97.750     0.150
     7.137   101.234     0.150
     7.236   102.172     0.150
     7.183   103.406     0.150
     7.273   103.305     0.150
     7.358   103.000     0.150
     7.397   103.664     0.150
     7.468   106.219     0.150
     7.513   107.320     0.150
     7.998   113.469     0.150
     8.042   114.211     0.150
     8.122   113.664     0.150
     8.100   115.203     0.150
     8.276   116.773     0.150
     8.322   117.719     0.150
     8.669   122.164     0.150
     8.871   124.070     0.150
     9.033   125.602     0.150
     9.036   125.461     0.150
     9.272   129.883     0.150
     9.370   131.633     0.150
     9.469   131.945     0.150
     9.681   133.844     0.150
     9.691   135.180     0.150
     9.865   137.812     0.150
     9.865   137.375     0.150
     9.946   140.336     0.150
     9.980   140.531     0.150
    10.051   140.516     0.150
    10.051   140.469     0.150
    10.183   141.273     0.150
    10.349   146.766     0.150
    10.628   151.742     0.150
    10.813   151.430     0.150
    10.990   154.344     0.150
    11.064   153.445     0.150
    11.359   156.141     0.150
    12.048   166.039     0.150
    12.117   168.742     0.150
    12.395   173.109     0.150
    14.133   193.609     0.150
    14.133   193.570     0.150
    14.697   204.609     0.150
    16.252   227.320     0.150
    16.252  1204.883     0.150
    16.252   225.453     0.150
    16.252  1207.938     0.150
    18.668   253.359     0.150
    24.640   315.414     0.150
    24.640   315.422     0.150
    24.817   319.336     0.150
    26.654   332.711     0.150
    26.852   338.719     0.150
    31.095   374.555     0.150
    32.115   384.070     0.150
    32.285   385.719     0.150
    34.586   405.430     0.150
    34.781   406.570     0.150
    35.264   410.516     0.150
    35.264   410.500     0.150
    36.171   419.844     0.150
    36.139   418.570     0.150
    36.761   422.375     0.150
    36.816   424.562     0.150
    36.999   426.109     0.150
    36.999   426.086     0.150
    37.332   428.953     0.150
    37.881   434.930     0.150
    38.209   436.664     0.150
    38.794   439.766     0.150
    39.270   444.844     0.150
    39.270   440.484     0.150
    39.742   449.094     0.150
    40.981   466.211     0.150
    40.981   477.812     0.150
    41.233   461.875     0.150
    41.552   460.602     0.150
    41.881   466.812     0.150
    41.881   467.211     0.150
    42.753   472.766     0.150
    42.776  3227.617     0.150
    42.782  3221.695     0.150
    42.794  3228.883     0.150
    42.892   477.023     0.150
    43.938  3314.664     0.150
    43.952  3311.070     0.150
    43.956  3309.891     0.150
    45.319   495.969     0.150
    46.189   500.836     0.150
    47.245   510.016     0.150
    47.245   510.055     0.150
    47.296   511.211     0.150
    47.801     9.805     0.150
    48.008   515.609     0.150
    48.008   515.602     0.150
    48.008   513.320     0.150
    48.289   516.812     0.150
    48.289   516.836     0.150
    48.476   516.211     0.150
    48.476   516.242     0.150
    48.908   518.844     0.150
    50.016   530.938     0.150
    50.016   530.055     0.150
    50.690   536.914     0.150
    50.690   536.953     0.150
    51.352  3855.945     0.150
    51.378   542.469     0.150
    51.730   544.516     0.150
    51.730   544.516     0.150
    52.851   552.250     0.150
    52.801     9.602     0.150
    53.587   557.984     0.150
    54.983   567.609     0.150
    54.983   567.609     0.150
    56.123   575.961     0.150
    56.123   577.672     0.150
    58.014   585.016     0.150
    58.286     4.805     0.150
    58.286     7.602     0.150
    59.295   597.820     0.150
    60.834   610.406     0.150
    61.233   609.914     0.150
    63.397   627.109     0.150
    64.379     6.102     0.150
    64.767   636.414     0.150
    64.744   634.680     0.150
    64.908     8.703     0.150
    65.287   638.359     0.150
    66.068   643.609     0.150
    66.328   645.289     0.150
    66.438   645.914     0.150
    66.438   645.875     0.150
    66.547     7.000     0.150
    66.547  1181.109     0.150
    67.610   655.633     0.150
    69.062   663.109     0.150
    69.062   663.062     0.150
    69.353   680.812     0.150
    69.449   667.320     0.150
    70.079   676.211     0.150
    70.079   684.516     0.150
    70.079   669.625     0.150
    70.842   677.500     0.150
    71.349   941.516     0.150
    71.349   677.820     0.150
    71.349   677.820     0.150
    71.349   677.820     0.150
    71.349   837.211     0.150
    71.349   941.555     0.150
    71.349  1234.250     0.150
    71.349  1512.422     0.150
    71.349  1711.805     0.150
    71.805   681.852     0.150
    72.254   683.602     0.150
    73.244   690.500     0.150
    73.813   691.312     0.150
    73.813   691.320     0.150
    74.573   696.312     0.150
    74.573   709.109     0.150
    74.573   855.312     0.150
    74.744   705.914     0.150
    74.896   699.320     0.150
    74.958   700.062     0.150
    75.037   699.312     0.150
    75.062   699.516     0.150
    75.062   699.711     0.150
    75.070   699.109     0.150
    75.107   699.516     0.150
    75.123   699.609     0.150
    75.127   699.609     0.150
    75.160   699.914     0.150
    75.090   708.109     0.150
    75.370   702.664     0.150
    75.417   702.812     0.150
    75.438   700.805     0.150
    75.618   709.516     0.150
    75.618   703.414     0.150
    75.650   703.914     0.150
    75.935   711.812     0.150
    75.935   705.516     0.150
    75.956   705.914     0.150
    75.956   711.516     0.150
    75.956   705.914     0.150
    76.078   712.609     0.150
    76.249   707.836     0.150
    76.249   707.812     0.150
    76.392   706.914     0.150
    76.626   709.414     0.150
    76.698   710.594     0.150
    76.698   710.516     0.150
    76.896   712.109     0.150
    77.064   710.570     0.150
    77.097   712.711     0.150
    77.241   711.852     0.150
    77.254   713.359     0.150
    77.455   717.398     0.150
    77.455   712.602     0.150
    77.455   720.914     0.150
    77.549   715.016     0.150
    77.564   715.414     0.150
    77.615   715.539     0.150
    77.648   716.016     0.150
    77.672   714.109     0.150
    77.816   716.336     0.150
    78.082   718.375     0.150
    78.127   718.516     0.150
    78.130   716.516     0.150
    78.130   716.484     0.150
    78.225   719.414     0.150
    78.333   719.016     0.150
    78.340   717.812     0.150
    78.397   720.273     0.150
    78.726   721.820     0.150
    78.945   722.758     0.150
    79.071   723.711     0.150
    79.031   721.266     0.150
    79.167   724.656     0.150
    79.232   724.211     0.150
    79.291   724.414     0.150
    79.467   721.602     0.150
    79.456   723.695     0.150
    79.623   732.312     0.150
    79.840   727.609     0.150
    79.924   727.602     0.150
    80.021   728.211     0.150
    80.021   728.633     0.150
    80.040   728.312     0.150
    80.137   727.094     0.150
    80.137   727.016     0.150
    80.143   724.414     0.150
    80.143  1323.812     0.150
    80.203   730.516     0.150
    80.203   729.422     0.150
    80.345   729.211     0.150
    80.345   729.234     0.150
    80.332   728.711     0.150
    80.424   730.211     0.150
    80.432   730.695     0.150
    80.432   730.609     0.150
    80.521   731.516     0.150
    80.582   730.812     0.150
    80.629   731.312     0.150
    80.632   730.914     0.150
    80.776   733.109     0.150
    81.100   731.812     0.150
    81.130   734.211     0.150
    81.271   734.477     0.150
    81.271   734.312     0.150
    81.271   735.125     0.150
    81.198   733.016     0.150
    81.198   733.016     0.150
    81.198   735.914     0.150
    81.332   735.609     0.150
    81.621   735.695     0.150
    81.731   739.773     0.150
    82.048   737.500     0.150
    82.342   741.984     0.150
    83.139   743.609     0.150
    83.270   744.602     0.150
    83.619   744.336     0.150
    83.619   744.969     0.150
    83.616   747.219     0.150
    83.684   745.086     0.150
    83.938   748.469     0.150
    83.914   750.516     0.150
    84.847   761.914     0.150
    85.013   759.016     0.150
    85.270   753.273     0.150
    85.594   757.516     0.150
    85.888   764.414     0.150
    86.616   767.812     0.150
    86.824   763.570     0.150
    86.751   766.914     0.150
    87.217   763.609     0.150
    87.217   763.641     0.150
    87.634   764.836     0.150
    87.777   766.312     0.150
    88.391   774.711     0.150
    88.428   776.711     0.150
    88.477   767.828     0.150
    90.318   784.211     0.150
    91.200   787.609     0.150
    91.640   788.609     0.150
    92.753   788.750     0.150
    93.780   794.227     0.150
    94.300   801.516     0.150
    99.427   819.914     0.150
    99.427   819.859     0.150
    99.505   816.609     0.150
   111.601  8369.359     0.150
   111.613  8369.617     0.150
   111.618  8342.945     0.150
   148.711  1185.250     0.150
   163.101  1256.312     0.150
     1.699    27.500     0.150
     1.871    30.336     0.150
     2.108    31.609     0.150
     2.823    40.984     0.150
     7.178   106.570     0.150
     7.171   106.320     0.150
    11.964   165.109     0.150
    16.163  1210.805     0.150
    16.163  1208.828     0.150
    42.860  3224.555     0.150
    42.866  3223.570     0.150
    42.878  3231.164     0.150
    44.022  3311.094     0.150
    44.035  3312.828     0.150
    44.039  3313.469     0.150
    45.404   498.359     0.150
    47.708   510.961     0.150
    47.711   510.641     0.150
    51.284  3852.289     0.150
    64.452   634.586     0.150
    79.049   722.711     0.150
    84.070   747.289     0.150
    92.842   793.773     0.150
    92.976  1456.734     0.150
    92.976  1456.734     0.150
    96.185   808.820     0.150
     1.578    26.289     0.150
     1.667    28.961     0.150
     2.336    36.383     0.150
     2.459    37.711     0.150
     2.537    38.227     0.150
     2.537    38.781     0.150
     2.529    38.672     0.150
     2.687    40.883     0.150
     2.789    42.023     0.150
     3.765    54.891     0.150
     3.871    56.180     0.150
     4.418    64.039     0.150
     4.695    70.320     0.150
     5.209    70.219     0.150
     5.539    82.992     0.150
     6.210    92.312     0.150
     6.236    93.773     0.150
     6.562    96.344     0.150
     6.874    96.117     0.150
     7.036   107.781     0.150
     7.168    96.828     0.150
     8.283   120.203     0.150
     8.506   124.602     0.150
    10.485   152.711     0.150
    12.169   164.852     0.150
    14.686   208.750     0.150
    14.725   208.430     0.150
    14.738   215.602     0.150
    15.500   217.992     0.150
    24.463   311.703     0.150
    27.380   340.719     0.150
    27.948   344.672     0.150
    34.488   406.281     0.150
    44.120  3333.883     0.150
    44.133  3336.430     0.150
    44.137  3335.750     0.150
    45.403   500.484     0.150
    50.748   538.148     0.150
    51.334  3853.180     0.150
    64.314   627.984     0.150
    64.368   631.047     0.150
    64.368     7.703     0.150
    64.592   634.953     0.150
    74.904   697.953     0.150
    74.904   697.438     0.150
    76.889   710.352     0.150
    78.909   720.562     0.150
     0.602    10.805     0.150
     1.143    20.602     0.150
     1.803    29.656     0.150
     1.828    29.898     0.150
     1.828    30.672     0.150
     1.989    31.656     0.150
     2.478    38.172     0.150
     2.332    38.352     0.150
     2.711    41.625     0.150
     2.919    42.703     0.150
     3.566    53.477     0.150
     3.992    57.523     0.150
     3.992    56.805     0.150
     4.068    62.227     0.150
     4.139    62.992     0.150
     4.139    63.008     0.150
     4.596    67.711     0.150
     4.652    68.266     0.150
     4.712    69.133     0.150
     4.773    67.867     0.150
     4.773    68.008     0.150
     4.774    70.062     0.150
     4.822    73.008     0.150
     5.137    75.156     0.150
     5.169    75.055     0.150
     5.413    76.273     0.150
     5.413    76.008     0.150
     5.413    75.977     0.150
     5.413    76.602     0.150
     5.764    86.617     0.150
     5.928    86.953     0.150
     6.165    88.914     0.150
     6.448    93.695     0.150
     6.677    95.367     0.150
     6.792    98.133     0.150
     6.814    97.453     0.150
     6.802    96.844     0.150
     6.879    98.688     0.150
     7.282   105.336     0.150
     7.390   103.883     0.150
     8.152   114.688     0.150
     8.154   115.078     0.150
     8.377   119.781     0.150
     8.895   124.984     0.150
     9.051   126.414     0.150
     9.068   126.617     0.150
     9.061   128.586     0.150
     9.123   129.094     0.150
     9.176   130.086     0.150
     9.309   130.508     0.150
     9.309   130.516     0.150
     9.405   132.516     0.150
     9.493   132.938     0.150
     9.888   137.875     0.150
    10.031   141.734     0.150
    10.680   148.602     0.150
    11.231   156.164     0.150
    11.879   165.086     0.150
    12.147   171.156     0.150
    12.407   171.805     0.150
    12.407   169.961     0.150
    12.990   181.023     0.150
    13.862   192.797     0.150
    16.226  1213.781     0.150
    16.226  1213.789     0.150
    23.109   301.398     0.150
    24.710   318.594     0.150
    24.869   320.242     0.150
    25.431   327.938     0.150
    27.097   340.422     0.150
    27.519   345.594     0.150
    32.160   386.195     0.150
    32.717   389.992     0.150
    32.821   392.484     0.150
    34.553   406.078     0.150
    36.212   419.516     0.150
    36.973   426.906     0.150
    36.973   426.898     0.150
    37.927   435.648     0.150
    38.311   441.664     0.150
    40.871   462.703     0.150
    41.047   475.203     0.150
    41.493   466.828     0.150
    41.772   469.695     0.150
    41.872   467.508     0.150
    42.623   472.883     0.150
    42.730   474.984     0.150
    42.752   474.625     0.150
    42.956   479.367     0.150
    42.759  3236.711     0.150
    42.764  3233.758     0.150
    42.777  3232.484     0.150
    43.839   483.398     0.150
    44.017   488.773     0.150
    43.920  3317.594     0.150
    43.933  3327.195     0.150
    43.937  3318.812     0.150
    44.449   490.961     0.150
    44.804   490.812     0.150
    45.039   495.602     0.150
    45.359   496.344     0.150
    45.359   497.766     0.150
    45.358   495.102     0.150
    45.358   495.125     0.150
    45.977   500.102     0.150
    47.161   509.961     0.150
    47.267   512.781     0.150
    47.373   511.602     0.150
    47.373   510.703     0.150
    47.451   514.508     0.150
    47.855   515.008     0.150
    47.858    14.000     0.150
    48.050   517.688     0.150
    48.050   519.961     0.150
    48.266   518.102     0.150
    48.815   527.602     0.150
    48.815   541.906     0.150
    49.253   524.062     0.150
    50.034   534.078     0.150
    50.739   537.703     0.150
    50.739   537.664     0.150
    50.991   539.055     0.150
    50.991   541.117     0.150
    51.322   542.797     0.150
    51.291  3863.680     0.150
    51.567   542.602     0.150
    51.567   542.562     0.150
    51.428   543.078     0.150
    51.957   546.914     0.150
    51.957   549.617     0.150
    51.987   546.211     0.150
    52.114   546.992     0.150
    52.661   551.242     0.150
    52.888   557.352     0.150
    52.888   557.352     0.150
    52.863     4.805     0.150
    53.229   557.148     0.150
    53.274   559.406     0.150
    53.274  1010.602     0.150
    53.731   562.328     0.150
    53.819   562.375     0.150
    53.819   565.734     0.150
    53.974   560.555     0.150
    54.029   561.445     0.150
    54.485   564.648     0.150
    54.713   566.688     0.150
    54.713   568.117     0.150
    54.851   571.602     0.150
    55.051   568.773     0.150
    55.377   573.406     0.150
    55.748   576.398     0.150
    56.103   578.297     0.150
    56.103   579.867     0.150
    56.194   577.133     0.150
    56.194   581.312     0.150
    56.454   581.242     0.150
    57.021   585.305     0.150
    57.703    14.297     0.150
    58.179   592.703     0.150
    58.179    13.398     0.150
    58.349     4.805     0.150
    58.525   595.398     0.150
    58.627   595.008     0.150
    59.615   600.766     0.150
    59.666   601.133     0.150
    59.965   606.695     0.150
    61.306   614.508     0.150
    61.379   614.766     0.150
    63.097   629.805     0.150
    63.097   629.977     0.150
    63.449   629.398     0.150
    63.449   629.531     0.150
    63.717   631.203     0.150
    63.717   631.234     0.150
    64.117   634.805     0.150
    64.450   634.203     0.150
    64.514   634.992     0.150
    64.827   638.875     0.150
    64.833   637.602     0.150
    64.853   640.008     0.150
    64.853   640.031     0.150
    64.787   639.508     0.150
    64.992   641.711     0.150
    64.992   641.672     0.150
    65.025   639.648     0.150
    65.025   639.695     0.150
    64.971    11.797     0.150
    65.153   641.508     0.150
    65.364   639.086     0.150
    65.671   646.461     0.150
    65.942   649.633     0.150
    66.133   647.203     0.150
    66.133   648.914     0.150
    66.133   649.047     0.150
    66.143   649.312     0.150
    66.403   645.797     0.150
    66.513   646.305     0.150
    66.513   646.266     0.150
    66.620     9.000     0.150
    66.620   683.102     0.150
    66.620  1181.906     0.150
    66.806   651.336     0.150
    66.833   652.828     0.150
    67.276   655.953     0.150
    67.276   654.578     0.150
    67.436   659.945     0.150
    67.669   655.953     0.150
    67.856   658.055     0.150
    67.885   657.977     0.150
    67.923   658.016     0.150
    68.505   662.914     0.150
    68.534   662.688     0.150
    68.534   662.594     0.150
    68.938   665.656     0.150
    69.120   663.102     0.150
    69.120   663.094     0.150
    69.120   666.328     0.150
    69.120   666.312     0.150
    69.120   665.117     0.150
    69.427  1213.602     0.150
    69.391   669.008     0.150
    69.391   669.078     0.150
    69.887   670.617     0.150
    69.941   675.703     0.150
    70.153   681.008     0.150
    70.153   670.102     0.150
    70.153   670.102     0.150
    70.153   672.914     0.150
    70.337   674.734     0.150
    70.634   678.305     0.150
    70.544   675.008     0.150
    70.544   675.031     0.150
    70.585   676.508     0.150
    70.585   676.523     0.150
    70.724   677.102     0.150
    70.724   677.156     0.150
    70.781   677.242     0.150
    71.064   678.773     0.150
    71.038   679.008     0.150
    71.038   679.094     0.150
    71.187   680.102     0.150
    71.191   679.195     0.150
    71.112   679.305     0.150
    71.112   679.398     0.150
    71.405   681.203     0.150
    71.420   939.305     0.150
    71.420   678.867     0.150
    71.420   839.172     0.150
    71.420   939.367     0.150
    71.420  1234.305     0.150
    71.420  1510.547     0.150
    71.420  1710.016     0.150
    71.469   681.805     0.150
    71.469   681.812     0.150
    71.415   681.703     0.150
    71.415   681.797     0.150
    71.544   678.086     0.150
    72.122   685.336     0.150
    72.330   688.781     0.150
    72.506   689.453     0.150
    72.469   685.531     0.150
    72.561   690.484     0.150
    72.693   687.055     0.150
    72.877   686.734     0.150
    73.000   689.602     0.150
    73.225   694.648     0.150
    73.308   692.094     0.150
    73.791   695.508     0.150
    73.791   695.547     0.150
    73.890   692.508     0.150
    73.890   692.453     0.150
    73.960   695.477     0.150
    74.088   696.102     0.150
    74.276   699.055     0.150
    74.306   699.625     0.150
    74.488   692.203     0.150
    74.606   696.227     0.150
    74.639    11.398     0.150
    74.639   698.008     0.150
    74.958   700.602     0.150
    74.895   701.805     0.150
    74.895   701.898     0.150
    74.900   701.805     0.150
    74.900   701.844     0.150
    75.020   698.461     0.150
    75.142   699.383     0.150
    75.206   699.453     0.150
    75.211   702.062     0.150
    75.484   703.406     0.150
    75.503   704.242     0.150
    75.551   703.703     0.150
    75.494   703.203     0.150
    75.494     9.398     0.150
    75.684   704.203     0.150
    75.684     3.805     0.150
    75.717   704.703     0.150
    75.717     5.102     0.150
    75.896   704.203     0.150
    75.896   704.195     0.150
    76.003   706.305     0.150
    76.003     4.898     0.150
    76.022   711.906     0.150
    76.022   706.703     0.150
    76.022     5.203     0.150
    76.022   707.008     0.150
    76.155   708.031     0.150
    76.155   706.719     0.150
    76.265   707.805     0.150
    76.397   709.305     0.150
    76.461   707.406     0.150
    76.536   710.281     0.150
    76.601   710.398     0.150
    76.623   709.586     0.150
    76.695   710.008     0.150
    76.748   710.602     0.150
    76.748   710.562     0.150
    76.839   716.008     0.150
    76.839   711.203     0.150
    76.839     4.805     0.150
    76.839   709.602     0.150
    76.965   712.906     0.150
    76.985   711.297     0.150
    76.949   712.602     0.150
    77.167   713.406     0.150
    77.304   712.703     0.150
    77.317   711.805     0.150
    77.317   711.797     0.150
    77.371   712.125     0.150
    77.618   715.406     0.150
    77.633   715.602     0.150
    77.443   715.508     0.150
    77.443   713.438     0.150
    77.716   716.102     0.150
    77.744   715.508     0.150
    78.148   719.617     0.150
    78.199   719.305     0.150
    78.293   719.906     0.150
    78.367   719.086     0.150
    78.403   719.508     0.150
    78.410   719.508     0.150
    78.410   718.664     0.150
    78.486   719.062     0.150
    78.784   721.180     0.150
    78.793   723.164     0.150
    78.896   722.156     0.150
    79.147   726.305     0.150
    79.361   725.102     0.150
    79.414   726.031     0.150
    79.410   723.820     0.150
    79.452   726.914     0.150
    79.523   728.586     0.150
    79.648   725.711     0.150
    79.648   725.703     0.150
    79.633   728.305     0.150
    79.896   730.383     0.150
    79.910   728.602     0.150
    80.093   728.805     0.150
    80.093   731.742     0.150
    80.112   729.305     0.150
    80.207   729.602     0.150
    80.207   731.617     0.150
    80.230   732.102     0.150
    80.377   730.906     0.150
    80.403   730.703     0.150
    80.493   730.305     0.150
    80.503   731.805     0.150
    80.592   732.203     0.150
    80.654   731.703     0.150
    80.699   731.555     0.150
    80.699   731.508     0.150
    80.704   731.406     0.150
    80.726   731.688     0.150
    80.960   732.602     0.150
    81.036   733.531     0.150
    81.115   736.914     0.150
    81.103  1028.305     0.150
    81.202   733.703     0.150
    81.173   733.984     0.150
    81.193   733.703     0.150
    81.193   733.742     0.150
    81.300   738.211     0.150
    81.338   735.695     0.150
    81.338   734.805     0.150
    81.255   736.703     0.150
    81.405   733.906     0.150
    81.405   733.875     0.150
    81.421   734.672     0.150
    81.354   737.602     0.150
    81.583   739.188     0.150
    81.568   734.602     0.150
    81.684   738.234     0.150
    81.544   735.617     0.150
    81.782   740.367     0.150
    81.801   736.547     0.150
    81.873   736.547     0.150
    82.015   737.203     0.150
    82.015   737.164     0.150
    82.429    14.602     0.150
    82.658   744.117     0.150
    82.770   745.844     0.150
    82.910   743.102     0.150
    83.133   742.055     0.150
    83.593   749.367     0.150
    83.685   746.703     0.150
    83.735   750.273     0.150
    83.902   751.523     0.150
    83.928   748.203     0.150
    83.932   749.875     0.150
    84.005   750.422     0.150
    84.232   752.664     0.150
    84.463   754.695     0.150
    84.853   756.758     0.150
    85.253   756.695     0.150
    85.491   759.172     0.150
    85.668   756.906     0.150
    85.668   757.805     0.150
    85.746   759.703     0.150
    86.138   763.047     0.150
    86.316   763.266     0.150
    86.891   766.016     0.150
    87.072   765.852     0.150
    87.324   767.453     0.150
    87.200   766.203     0.150
    87.200   764.008     0.150
    87.200   763.953     0.150
    87.637   767.953     0.150
    88.341   773.648     0.150
    88.490   770.094     0.150
    88.918   775.578     0.150
    89.040   773.656     0.150
    89.503   779.344     0.150
    89.619   779.852     0.150
    89.906   780.742     0.150
    90.411   782.852     0.150
    90.397   784.602     0.150
    90.835   785.367     0.150
    90.682   783.906     0.150
    91.687   788.305     0.150
    91.930   790.445     0.150
    93.761   797.562     0.150
    94.347   800.602     0.150
    99.504   821.102     0.150
   111.538  8372.945     0.150
   111.550  8378.438     0.150
   111.555  8335.688     0.150
   133.642  1148.828     0.150
   145.325  1171.594     0.150
   146.039  1179.047     0.150
   148.274  1184.977     0.150
   163.027  1247.305     0.150
     2.056    31.602     0.150
     3.858    55.828     0.150
     4.633    69.469     0.150
     4.779    73.117     0.150
     5.270    70.812     0.150
     5.270   130.836     0.150
     6.506   101.570     0.150
     7.123   101.930     0.150
    12.247   165.094     0.150
    16.882   229.047     0.150
    18.551   248.273     0.150
    24.519   312.695     0.150
    24.882   315.953     0.150
    25.701   323.297     0.150
    42.898  3225.008     0.150
    42.904  3224.867     0.150
    42.916  3226.938     0.150
    44.060  3315.492     0.150
    44.074  3313.602     0.150
    44.078  3327.227     0.150
    45.403   490.047     0.150
    50.760   534.477     0.150
    59.579   596.492     0.150
    64.533   629.695     0.150
    64.677   629.555     0.150
    65.131   632.172     0.150
    65.689   635.242     0.150
    66.324   640.898     0.150
    74.988   692.945     0.150
    76.974   706.445     0.150
    84.017   743.344     0.150
     0.595    21.414     0.150
     4.016    58.922     0.150
    45.520   496.648     0.150
     0.546    21.445     0.150
     1.142    25.453     0.150
     1.727    30.453     0.150
     2.164    33.539     0.150
    42.834  3234.594     0.150
    42.840  3227.062     0.150
    42.852  3235.102     0.150
    43.995  3317.289     0.150
    44.009  3315.297     0.150
    44.013  3318.125     0.150
    45.409   494.961     0.150
    56.170   577.922     0.150
    56.430   579.781     0.150
    64.524   635.727     0.150
    64.496     3.703     0.150
    64.647   637.102     0.150
    65.368   641.078     0.150
     1.699    31.070     0.150
     4.595    69.516     0.150
     4.744    71.969     0.150
     8.728   125.766     0.150
    13.971   199.719     0.150
    32.430   391.000     0.150
    43.045  3231.383     0.150
    43.050  3231.117     0.150
    43.063  3233.062     0.150
    44.208  3333.344     0.150
    44.221  3339.484     0.150
    44.225  3337.141     0.150
    46.115   502.875     0.150
    51.349  3850.086     0.150
    54.931   566.758     0.150
    64.339     4.898     0.150
    64.895     7.102     0.150
     1.574    27.539     0.150
     1.674    26.812     0.150
     1.862    28.664     0.150
     2.281    36.703     0.150
     2.335    34.875     0.150
     3.909    56.359     0.150
     4.585    65.266     0.150
     5.316    69.242     0.150
     5.316   125.367     0.150
     5.288    80.391     0.150
     5.607    83.914     0.150
     5.771    87.344     0.150
     6.304    93.875     0.150
     6.751    96.664     0.150
     7.958   113.141     0.150
     7.948   117.602     0.150
     7.942   117.695     0.150
     8.570   125.234     0.150
     9.020   131.984     0.150
     9.227   133.383     0.150
     9.510   138.172     0.150
     9.856   142.820     0.150
    10.057   144.953     0.150
    10.557   152.875     0.150
    12.273   159.570     0.150
    12.505   179.453     0.150
    14.776   210.492     0.150
    16.939   230.070     0.150
    18.581   243.594     0.150
    24.569   312.273     0.150
    24.816   314.609     0.150
    32.282   391.000     0.150
    47.227   501.500     0.150
    50.694   533.523     0.150
    56.297   568.648     0.150
    59.534   593.648     0.150
    64.351     5.703     0.150
    64.390   626.648     0.150
    64.489   628.023     0.150
    64.678   628.922     0.150
    65.093   632.000     0.150
    65.688   634.039     0.150
    66.277   639.320     0.150
    68.962   656.672     0.150
    73.755   693.281     0.150
    74.977   692.625     0.150
    76.974   705.797     0.150
    81.478   733.023     0.150
    84.034   744.930     0.150
    85.511   751.570     0.150
     4.708    71.664     0.150
     6.215    92.453     0.150
     7.045   100.898     0.150
     8.069   114.055     0.150
     9.768   137.734     0.150
    15.553   221.023     0.150
    16.098  1146.328     0.150
    16.098  1146.844     0.150
    16.982   236.133     0.150
    20.430   278.000     0.150
    24.683   321.102     0.150
    24.911   323.805     0.150
    24.911   324.383     0.150
    28.109   349.391     0.150
    42.981  3247.547     0.150
    42.987  3232.688     0.150
    42.999  3249.773     0.150
    44.143  3327.406     0.150
    44.157  3337.836     0.150
    44.161  3329.281     0.150
    45.400   498.070     0.150
    45.447   495.375     0.150
    45.447   500.133     0.150
    47.218   508.500     0.150
    47.806   515.672     0.150
    51.290  3853.219     0.150
    56.440   578.898     0.150
    63.831   638.648     0.150
    64.412     8.500     0.150
    64.959   645.953     0.150
    64.959     6.898     0.150
    65.195   637.375     0.150
    67.625   655.602     0.150
    68.274   660.242     0.150
    69.013   665.352     0.150
    69.013     8.297     0.150
    75.254   702.352     0.150
    75.393    10.898     0.150
    75.489   703.453     0.150
    75.775   705.055     0.150
    75.937   705.750     0.150
    76.090   707.555     0.150
    76.473   716.750     0.150
    76.538   710.727     0.150
    76.538   709.750     0.150
    76.538   715.750     0.150
    76.779   712.352     0.150
    76.779   717.648     0.150
    76.946   719.250     0.150
    77.392   721.352     0.150
    77.489   722.953     0.150
    77.975   722.836     0.150
    78.253   718.750     0.150
    78.266   718.773     0.150
    78.292   718.984     0.150
    78.367   719.594     0.150
    78.550   720.539     0.150
    78.834   723.172     0.150
    78.917   721.789     0.150
    78.933   722.609     0.150
    79.082   723.242     0.150
    79.620   727.281     0.150
    79.670   731.234     0.150
    79.690   725.258     0.150
    79.715   724.750     0.150
    79.830   728.727     0.150
    79.833   725.680     0.150
    79.878   722.234     0.150
    79.897   731.492     0.150
    79.922   729.875     0.150
    80.402   736.336     0.150
    80.458   732.977     0.150
    81.106   740.219     0.150
    81.285   735.891     0.150
    85.012   758.344     0.150
   148.767  1185.422     0.150
     1.702    28.797     0.150
     1.957    32.055     0.150
     2.714    42.359     0.150
     2.894    45.609     0.150
     3.495    52.000     0.150
     3.600    53.289     0.150
     3.941    56.547     0.150
     4.059    60.070     0.150
     4.112    60.688     0.150
     4.949    72.547     0.150
     5.363   131.633     0.150
     5.901    87.891     0.150
     6.432    92.430     0.150
     9.147   131.000     0.150
     9.357   131.156     0.150
     9.443   131.930     0.150
    10.003   140.820     0.150
    12.353   171.336     0.150
    33.228   395.305     0.150
    42.809  3224.906     0.150
    42.815  3232.492     0.150
    42.827  3233.242     0.150
    42.923   477.250     0.150
    43.971  3310.992     0.150
    43.984  3313.188     0.150
    43.988  3312.016     0.150
    47.120   511.898     0.150
    47.367   511.219     0.150
    55.071   571.180     0.150
    56.428   579.539     0.150
    56.754   580.445     0.150
    64.467     6.703     0.150
    64.801   636.641     0.150
    66.632   650.336     0.150
    66.632     8.000     0.150
    66.632    11.102     0.150
    74.607   697.438     0.150
    76.808   710.789     0.150
    78.096   717.797     0.150
    78.357   718.758     0.150
    78.454   719.961     0.150
    78.467   719.734     0.150
    78.584   720.586     0.150
    78.752   721.516     0.150
    78.763   721.625     0.150
    78.846   722.305     0.150
    79.133   723.836     0.150
    79.468   725.289     0.150
   111.513  8388.141     0.150
   111.524  8389.172     0.150
   111.529  8382.484     0.150
     4.602    66.969     0.150
     6.518   101.641     0.150
    11.075   159.492     0.150
    15.610   221.250     0.150
    17.958   247.719     0.150
    42.929  3226.734     0.150
    42.935  3225.266     0.150
    42.947  3224.945     0.150
    44.091  3309.898     0.150
    44.105  3307.055     0.150
    44.109  3315.750     0.150
    64.655   635.242     0.150
    71.425   678.445     0.150
    74.971   699.242     0.150
    74.979   699.242     0.150
    83.991   749.117     0.150
   111.548  8374.812     0.150
   111.559  8374.070     0.150
   111.564  8356.297     0.150
     1.618    28.406     0.150
     4.804    70.617     0.150
     5.143    78.031     0.150
     6.985   102.523     0.150
     7.837   114.312     0.150
     9.083   131.984     0.150
    10.068   145.758     0.150
    11.764   166.891     0.150
    11.847   169.492     0.150
    17.199   239.977     0.150
    43.033  3244.508     0.150
    43.039  3244.938     0.150
    43.051  3245.898     0.150
    44.195  3336.609     0.150
    44.209  3334.945     0.150
    44.213  3336.102     0.150
    50.799   537.383     0.150
    64.396     8.195     0.150
    64.948     5.500     0.150
     0.577    21.414     0.150
     0.587    22.312     0.150
     3.450    52.844     0.150
     3.912    58.281     0.150
     4.175    62.688     0.150
     5.404    76.508     0.150
     5.404   132.906     0.150
     5.912    86.070     0.150
    10.376   147.508     0.150
    16.226  1218.266     0.150
    16.226  1231.820     0.150
    20.922   282.773     0.150
    33.651   397.227     0.150
    34.254   402.711     0.150
    38.993   444.836     0.150
    42.767  3232.164     0.150
    42.773  3228.922     0.150
    42.785  3225.656     0.150
    42.854   482.016     0.150
    43.929  3312.898     0.150
    43.942  3312.531     0.150
    43.946  3316.430     0.150
    45.355   495.023     0.150
    45.356   496.773     0.150
    45.545   499.312     0.150
    46.935   508.414     0.150
    47.147   512.938     0.150
    48.879   523.555     0.150
    51.300  3877.367     0.150
    52.854   555.711     0.150
    64.436   636.312     0.150
    64.436     4.703     0.150
    72.284   685.242     0.150
    73.582   691.875     0.150
    75.481     6.805     0.150
    76.750   707.914     0.150
    76.949   713.617     0.150
    77.221   714.555     0.150
    77.602   722.711     0.150
    77.700   724.812     0.150
    77.950   717.656     0.150
    78.177   718.883     0.150
    78.471   720.375     0.150
    78.769   722.617     0.150
    79.483   726.172     0.150
    79.779   726.703     0.150
   144.049  1167.883     0.150
   144.049  1169.055     0.150
     1.620    28.102     0.150
     1.618    28.438     0.150
     1.700    29.648     0.150
     1.999    30.836     0.150
     4.579    66.352     0.150
     4.877    74.977     0.150
     5.578    84.156     0.150
     6.240    92.789     0.150
     6.276    93.359     0.150
     9.503   131.695     0.150
    10.512   151.141     0.150
    12.026   172.711     0.150
    14.533   201.406     0.150
    16.395   230.711     0.150
    16.874   237.031     0.150
    24.897   318.305     0.150
    30.715   370.586     0.150
    32.199   389.648     0.150
    32.519   388.750     0.150
    37.747   432.734     0.150
    41.119   461.125     0.150
    42.952  3245.844     0.150
    42.958  3246.133     0.150
    42.970  3247.086     0.150
    44.114  3317.953     0.150
    44.128  3311.797     0.150
    44.132  3327.625     0.150
    51.299  3856.961     0.150
    51.451   544.164     0.150
    64.407     6.102     0.150
    74.949   697.969     0.150
    75.397   703.305     0.150
    75.397     5.305     0.150
    78.214   720.219     0.150
    78.855   729.672     0.150
    80.039   734.383     0.150
    80.149   736.266     0.150
    80.294   727.086     0.150
    80.479   733.594     0.150
    81.552   738.828     0.150
    92.922   792.820     0.150
     1.045    17.125     0.150
     3.525    65.406     0.150
     3.857    64.008     0.150
     5.272    74.680     0.150
     5.272   164.148     0.150
     5.272    84.406     0.150
     6.018    86.266     0.150
     6.533    99.805     0.150
     7.992   114.430     0.150
     8.562   120.734     0.150
    12.005   168.406     0.150
    12.096   179.398     0.150
    24.711   321.969     0.150
    26.025   332.898     0.150
    32.576   388.969     0.150
    34.019   401.031     0.150
    34.190   404.117     0.150
    35.713   417.680     0.150
    36.180   419.016     0.150
    36.180   419.047     0.150
    42.818   478.875     0.150
    42.897  3225.086     0.150
    42.903  3225.523     0.150
    42.915  3228.945     0.150
    44.059  3314.781     0.150
    44.072  3316.594     0.150
    44.076  3314.062     0.150
    45.423   491.828     0.150
    46.570   501.859     0.150
    51.279  3853.078     0.150
    51.824   541.469     0.150
    64.437     7.703     0.150
    64.975   642.008     0.150
    64.975    10.297     0.150
    65.162   638.258     0.150
    65.271   639.406     0.150
    66.583   653.406     0.150
    66.583     4.602     0.150
    69.023   666.305     0.150
    69.438     7.305     0.150
    73.823   694.430     0.150
    74.504   699.531     0.150
    74.504   701.305     0.150
    74.504     3.703     0.150
    75.339   703.711     0.150
    75.350   703.406     0.150
    75.584   704.906     0.150
    75.888   706.508     0.150
    76.031   708.109     0.150
    76.134   708.977     0.150
    76.633   708.406     0.150
    76.633   710.977     0.150
    76.834   716.609     0.150
    76.875   709.305     0.150
    77.039   716.711     0.150
    77.487   717.406     0.150
    77.584   718.406     0.150
    77.584   717.555     0.150
    77.688   716.719     0.150
    77.839   717.234     0.150
    77.993   718.109     0.150
    78.014   719.445     0.150
    78.057   718.781     0.150
    78.234   720.180     0.150
    78.277   721.367     0.150
    78.349   719.906     0.150
    78.363   720.617     0.150
    78.388   720.156     0.150
    78.463   720.914     0.150
    78.480   720.914     0.150
    78.742   722.688     0.150
    78.742   722.820     0.150
    79.175   726.016     0.150
    79.364   725.625     0.150
    79.660   726.734     0.150
    79.765   728.156     0.150
    80.365   731.500     0.150
    81.567   735.016     0.150
    81.567   735.141     0.150
    82.022   736.719     0.150
    84.033   747.828     0.150
    88.599   774.047     0.150
     4.647    68.703     0.150
     5.190    78.359     0.150
     6.246    93.648     0.150
     7.878   115.039     0.150
     9.130   132.320     0.150
    10.272   147.320     0.150
     0.980    17.588     0.150
     1.637    27.468     0.150
     2.402    37.568     0.150
     2.525    39.538     0.150
     2.595    39.998     0.150
     2.753    42.238     0.150
     2.854    43.518     0.150
     2.854    76.638     0.150
     2.953    44.868     0.150
     3.581    93.088     0.150
     3.581    52.448     0.150
     3.730    54.518     0.150
     3.755    99.378     0.150
     4.056    58.978     0.150
     4.205    61.038     0.150
     4.975    71.358     0.150
     6.266    90.588     0.150
     6.540    93.648     0.150
     8.841   124.998     0.150
     8.894   125.498     0.150
     9.908   138.058     0.150
    10.051   140.338     0.150
    10.107   141.538     0.150
    10.526   146.918     0.150
    11.987   166.738     0.150
    12.150   301.676     0.150
    13.040   180.268     0.150
    15.108   207.518     0.150
    16.076  1204.864     0.150
    16.076  1204.863     0.150
    24.931   318.618     0.150
    32.164   553.006     0.150
    34.709   407.478     0.150
    36.190   419.468     0.150
    41.516   465.058     0.150
    86.912   466.988     0.150
    41.678   464.718     0.150
    42.999  3235.252     0.150
    43.005  3230.523     0.150
    43.017  3227.154     0.150
    44.161  3310.747     0.150
    44.175  3316.728     0.150
    44.179  3311.825     0.150
    45.469   496.238     0.150
    46.617   503.918     0.150
    48.897   521.728     0.150
    50.814   536.728     0.150
    51.270  3854.794     0.150
    54.510   563.248     0.150
    54.687   565.888     0.150
    56.234   577.638     0.150
    58.357    10.400     0.150
    58.357    14.300     0.150
    59.382   599.318     0.150
    59.565   598.268     0.150
    63.210   625.758     0.150
    63.851     7.900     0.150
    64.429     9.800     0.150
    64.598   634.078     0.150
    64.787   636.758     0.150
    64.977   640.278     0.150
    64.977     7.100     0.150
    66.425   645.638     0.150
    66.556    12.400     0.150
    66.556    16.600     0.150
    69.032    10.500     0.150
    70.938   677.278     0.150
    72.213   684.198     0.150
    72.215   681.478     0.150
    73.507   691.818     0.150
    73.990   694.398     0.150
    74.123   699.278     0.150
    74.404     7.300     0.150
    74.881   696.238     0.150
    74.930   695.305     0.150
    75.251   698.578     0.150
    75.407   702.578     0.150
    75.486   699.378     0.150
    75.773   699.878     0.150
    75.773   703.868     0.150
    75.789   701.478     0.150
    75.934   701.878     0.150
    76.088   703.423     0.150
    76.161   704.928     0.150
    76.366   707.438     0.150
    76.535   708.218     0.150
    76.777   708.548     0.150
    76.945   712.478     0.150
    77.532   709.255     0.150
    77.957   716.198     0.150
    78.193   715.298     0.150
    78.363   718.388     0.150
    78.695   720.888     0.150
    78.991   720.508     0.150
    79.180   722.628     0.150
    79.189   719.839     0.150
    79.560   724.198     0.150
    79.651   723.126     0.150
    79.689   723.673     0.150
    79.833   725.178     0.150
    79.922   723.971     0.150
    80.270   726.728     0.150
    80.374   727.178     0.150
    80.458   728.518     0.150
    80.478   728.510     0.150
    80.492   725.259     0.150
    81.061   732.258     0.150
    81.104   721.557     0.150
    81.110   734.868     0.150
    81.110   734.638     0.150
    81.917   736.568     0.150
    82.033   738.358     0.150
    82.250   735.249     0.150
    83.095   750.438     0.150
    83.925   747.608     0.150
    84.825   754.958     0.150
    85.514   756.678     0.150
    86.141   757.588     0.150
    87.267   766.908     0.150
    92.970   791.784     0.150
   111.532  8379.546     0.150
   111.544  8379.272     0.150
   156.178  1215.728     0.150
     0.268    10.088     0.150
     2.378    39.848     0.150
    10.230   144.178     0.150
    13.577   192.418     0.150
    14.584   205.738     0.150
    36.240   421.238     0.150
    43.032  3247.444     0.150
    43.038  3245.204     0.150
    43.050  3246.097     0.150
    44.195  3334.865     0.150
    44.208  3337.564     0.150
    44.212  3334.785     0.150
     2.504    39.428     0.150
     2.742    70.238     0.150
    12.205   302.503     0.150
    42.946  3222.852     0.150
    42.952  3223.760     0.150
    42.964  3225.300     0.150
    44.108  3313.908     0.150
    44.122  3312.890     0.150
    44.126  3315.112     0.150
    51.278  3851.248     0.150
    64.374   633.178     0.150
    65.660   641.495     0.150
    68.915   663.153     0.150
    74.966   698.803     0.150
   111.536  8378.479     0.150
   111.548  8377.131     0.150
     0.493    20.775     0.150
     0.504    20.775     0.150
     1.127    19.295     0.150
     1.748    29.345     0.150
     2.453    38.735     0.150
     2.574    40.635     0.150
     2.641    40.795     0.150
     2.802    43.215     0.150
     2.802    43.705     0.150
     2.888    44.405     0.150
     2.988    45.935     0.150
     3.596    52.505     0.150
     3.701    55.005     0.150
     3.701    55.525     0.150
     4.062    59.345     0.150
     4.162    60.925     0.150
     4.215    61.415     0.150
     5.015    73.575     0.150
     8.892   126.445     0.150
    12.278   307.325     0.150
    16.836   419.125     0.150
    24.637   317.005     0.150
    28.669   353.805     0.150
    30.628   371.445     0.150
    32.345   387.455     0.150
    33.129   394.255     0.150
    34.407   404.165     0.150
    35.162   411.425     0.150
    36.158   420.215     0.150
    41.374   460.135     0.150
    41.712   464.875     0.150
    42.915  3224.506     0.150
    42.920  3230.224     0.150
    42.933  3226.688     0.150
    42.866   476.235     0.150
    44.076  3312.492     0.150
    44.089  3311.995     0.150
    44.093  3319.120     0.150
    44.328   484.645     0.150
    45.498   495.475     0.150
    45.603   496.365     0.150
    45.662   495.175     0.150
    46.270   502.405     0.150
    50.233   531.815     0.150
    53.010   553.295     0.150
    52.962     9.400     0.150
    59.698   600.150     0.150
    64.529     5.100     0.150
    64.749   636.275     0.150
    65.066   636.475     0.150
    65.066    10.200     0.150
    66.676   651.175     0.150
    69.530   663.075     0.150
    70.200   659.695     0.150
    70.433   670.875     0.150
    73.868   688.865     0.150
    75.142   700.635     0.150
    75.535     8.300     0.150
    75.823   701.005     0.150
    75.925   703.975     0.150
    76.190   706.635     0.150
    78.108   717.775     0.150
    78.127   712.749     0.150
    78.347   717.065     0.150
    78.794   721.785     0.150
    79.080   723.422     0.150
    79.331   724.155     0.150
    79.343   721.643     0.150
    79.902   726.935     0.150
    80.442   726.549     0.150
    80.529   728.263     0.150
    80.632   729.679     0.150
    80.951   731.086     0.150
    81.258   732.006     0.150
    81.261   734.291     0.150
    81.283   732.636     0.150
    82.274   741.075     0.150
    83.508   749.135     0.150
    83.611   744.303     0.150
    86.532   758.585     0.150
    92.909   788.675     0.150
   111.444  8375.124     0.150
   111.455  8378.191     0.150
     1.061    18.430     0.150
     3.688    98.980     0.150
     3.853    55.780     0.150
     5.310    80.760     0.150
     5.602    81.520     0.150
     5.661    86.180     0.150
     6.138    88.560     0.150
     6.357    94.920     0.150
     8.007   112.300     0.150
     7.996   114.350     0.150
     9.259   129.970     0.150
     9.940   139.690     0.150
    10.475   148.470     0.150
    10.475   148.440     0.150
    10.607   153.770     0.150
    10.607   153.780     0.150
    10.892   153.160     0.150
    14.003   194.090     0.150
    14.349   198.160     0.150
    16.127  1202.287     0.150
    16.127  1202.121     0.150
    24.409   316.680     0.150
    24.515   317.070     0.150
    24.571   318.560     0.150
    24.921   321.070     0.150
    24.921   321.070     0.150
    26.552   336.010     0.150
    27.003   339.920     0.150
    27.053   340.210     0.150
    30.695   372.410     0.150
    31.147   380.990     0.150
    31.605   380.730     0.150
    33.190   394.870     0.150
    33.190   394.890     0.150
    34.006   405.680     0.150
    34.064   400.430     0.150
    34.064   400.100     0.150
    34.176   407.870     0.150
    34.302   404.020     0.150
    34.303   402.770     0.150
    34.303   726.570     0.150
    35.231   412.070     0.150
    35.231   412.060     0.150
    35.683   412.170     0.150
    36.221   421.170     0.150
    36.221   421.210     0.150
    36.197   773.570     0.150
    36.873   426.520     0.150
    36.873   429.110     0.150
    37.849   434.590     0.150
    38.640   446.190     0.150
    40.834   459.810     0.150
    41.060   471.770     0.150
    41.437   468.410     0.150
    41.857   468.880     0.150
    42.827   479.270     0.150
    42.900  3229.320     0.150
    42.906  3229.686     0.150
    42.918  3225.953     0.150
    44.061  3316.542     0.150
    44.075  3327.949     0.150
    44.079  3314.726     0.150
    44.393   487.420     0.150
    44.393   492.090     0.150
    45.436   495.940     0.150
    46.068   501.990     0.150
    47.021   509.410     0.150
    47.021   511.070     0.150
    47.305   510.670     0.150
    47.898     6.600     0.150
    50.798   537.680     0.150
    51.262  3850.077     0.150
    51.463   542.730     0.150
    52.888     6.900     0.150
    52.888    11.000     0.150
    53.648   562.040     0.150
    55.053   569.360     0.150
    56.339   579.130     0.150
    56.905   584.390     0.150
    57.573   589.470     0.150
    57.977   593.670     0.150
    58.371     6.000     0.150
    58.371     9.000     0.150
    59.102   599.560     0.150
    63.499   637.870     0.150
    64.454     7.000     0.150
    64.470   633.350     0.150
    64.470   634.170     0.150
    64.708   636.570     0.150
    64.708   636.570     0.150
    64.823   636.610     0.150
    64.898   638.750     0.150
    64.992     6.700     0.150
    65.179   638.730     0.150
    65.286  1156.670     0.150
    65.286   638.980     0.150
    66.601     9.500     0.150
    69.326   694.570     0.150
    69.355   665.520     0.150
    69.455     3.600     0.150
    69.455     7.200     0.150
    70.359   672.070     0.150
    70.512   671.710     0.150
    70.552   673.010     0.150
    70.691   673.780     0.150
    70.936    10.500     0.150
    71.004   675.690     0.150
    71.074   676.040     0.150
    71.309   938.470     0.150
    71.309   677.630     0.150
    71.309   677.630     0.150
    71.309   677.630     0.150
    71.309   697.460     0.150
    71.309   835.190     0.150
    71.309   938.550     0.150
    71.309  1232.330     0.150
    71.309  1279.030     0.150
    71.309  1506.960     0.150
    71.309  1706.430     0.150
    71.434   678.270     0.150
    71.379   678.340     0.150
    71.580   679.160     0.150
    72.265   680.670     0.150
    72.267   683.730     0.150
    72.837   687.830     0.150
    73.270   688.670     0.150
    73.746   692.010     0.150
    73.833   694.690     0.150
    73.843   691.980     0.150
    74.514     4.700     0.150
    74.514   697.060     0.150
    74.514   696.770     0.150
    74.849   698.370     0.150
    74.854   698.530     0.150
    75.033   698.720     0.150
    75.033   698.960     0.150
    75.102   700.880     0.150
    75.349   707.370     0.150
    75.349   707.370     0.150
    75.360   699.670     0.150
    75.360   699.670     0.150
    75.385   705.770     0.150
    75.385   705.770     0.150
    75.429   704.770     0.150
    75.429   704.770     0.150
    75.558   709.770     0.150
    75.595   703.970     0.150
    75.777   705.130     0.150
    75.881   705.370     0.150
    75.881   705.410     0.150
    75.899   710.370     0.150
    76.196   706.000     0.150
    76.578   708.970     0.150
    76.626   709.480     0.150
    76.644   707.970     0.150
    76.714   709.740     0.150
    76.714   709.770     0.150
    76.846   711.870     0.150
    77.057   721.670     0.150
    77.116   713.560     0.150
    77.498   713.470     0.150
    77.595   715.570     0.150
    77.595   715.830     0.150
    77.635   714.070     0.150
    77.699   715.950     0.150
    78.004   717.656     0.150
    78.067   717.890     0.150
    78.080   717.370     0.150
    78.154   719.396     0.150
    78.297   717.870     0.150
    78.297   717.880     0.150
    78.359   719.601     0.150
    78.373   717.147     0.150
    78.398   719.703     0.150
    78.490   720.215     0.150
    78.752   719.930     0.150
    78.803   722.390     0.150
    79.024   722.120     0.150
    79.186   723.170     0.150
    79.294   722.272     0.150
    79.374   725.080     0.150
    79.670   723.130     0.150
    79.794   725.359     0.150
    79.981   727.270     0.150
    80.000   727.070     0.150
    80.123   727.623     0.150
    80.120   728.170     0.150
    80.377   729.170     0.150
    80.377   729.230     0.150
    80.391   729.370     0.150
    80.391   731.700     0.150
    80.479   732.830     0.150
    80.507   730.330     0.150
    80.546   730.670     0.150
    80.583   730.670     0.150
    80.595   730.470     0.150
    81.102   731.083     0.150
    81.173   735.400     0.150
    81.294   734.070     0.150
    81.294   734.150     0.150
    81.583   736.270     0.150
    82.569   740.560     0.150
    84.039   753.250     0.150
    85.623   758.620     0.150
    86.189   761.010     0.150
   111.517  8375.537     0.150
   111.529  8372.604     0.150
   159.441  1194.553     0.150
     1.215    20.659     0.150
     1.816    30.939     0.150
     4.220    63.409     0.150
     4.290    64.339     0.150
    32.621   388.729     0.150
    42.862  3234.918     0.150
    42.867  3242.690     0.150
    42.880  3237.377     0.150
    44.022  3328.912     0.150
    44.035  3323.498     0.150
    44.039  3318.653     0.150
    45.703   507.309     0.150
    47.823   516.837     0.150
    47.992   512.869     0.150
    53.010     9.500     0.150
    57.340   586.589     0.150
    63.971   634.009     0.150
    64.586     8.800     0.150
    66.745   654.109     0.150
    75.610   696.009     0.150
    75.610    17.500     0.150
    76.333   708.909     0.150
    76.780   711.609     0.150
    77.397   712.089     0.150
    78.529   720.757     0.150
    78.620   721.524     0.150
    78.787   722.534     0.150
    78.885   723.464     0.150
    78.906   723.361     0.150
    79.359   725.706     0.150
    79.508   726.395     0.150
    81.694   742.079     0.150
    92.869   792.311     0.150
     1.930    29.667     0.150
     2.210    33.627     0.150
     2.736    79.587     0.150
     5.383    76.917     0.150
    14.497   199.978     0.150
    14.597   211.267     0.150
    17.070   239.777     0.150
    42.792  3224.330     0.150
    42.798  3222.810     0.150
    42.810  3222.084     0.150
    43.953  3315.454     0.150
    43.966  3314.439     0.150
    43.970  3315.683     0.150
    47.410   512.732     0.150
     3.766    54.109     0.150
     3.685    54.819     0.150
     4.056    58.739     0.150
     4.281    63.119     0.150
     7.910   109.989     0.150
    10.998   153.409     0.150
    11.041   160.379     0.150
    14.669   199.589     0.150
    16.076  1199.569     0.150
    16.076  1199.684     0.150
    20.421   272.129     0.150
    36.263   418.529     0.150
    36.821   423.689     0.150
    37.321   428.359     0.150
    42.990  3226.827     0.150
    42.996  3226.991     0.150
    43.008  3231.341     0.150
    44.000   483.208     0.150
    44.152  3315.605     0.150
    44.166  3315.222     0.150
    44.170  3314.967     0.150
    46.719   507.089     0.150
    46.719   506.579     0.150
    46.920   506.029     0.150
    46.920   509.849     0.150
    47.537   510.389     0.150
    47.593   513.349     0.150
    47.905   508.879     0.150
    51.263  3850.187     0.150
    52.885     8.900     0.150
    56.249   577.409     0.150
    56.249   577.438     0.150
    58.366     6.200     0.150
    58.366     8.700     0.150
    64.438     5.200     0.150
    64.613   635.279     0.150
    64.613   643.279     0.150
    64.933   636.729     0.150
    64.986     5.800     0.150
    66.567   800.378     0.150
    67.636   654.739     0.150
    68.718   661.708     0.150
    69.064   659.179     0.150
    69.528   666.009     0.150
    70.118   666.759     0.150
    75.255   702.179     0.150
    75.265   701.679     0.150
    75.419     8.100     0.150
    75.501   699.539     0.150
    75.949   704.579     0.150
    76.339   706.979     0.150
    76.619   709.279     0.150
    76.960   715.378     0.150
    77.154   713.101     0.150
    77.501   711.949     0.150
    77.909   716.004     0.150
    78.151   717.708     0.150
    78.179   717.079     0.150
    78.263   718.463     0.150
    78.561   720.353     0.150
    79.096   722.389     0.150
    79.280   723.608     0.150
    79.280   723.838     0.150
    79.575   722.829     0.150
    79.846   724.202     0.150
    80.389   722.003     0.150
    80.459   719.974     0.150
    92.964   792.680     0.150
    96.309   808.134     0.150
   111.524  8374.947     0.150
   111.536  8376.246     0.150
     4.645    68.197     0.150
     5.373    77.247     0.150
    42.807  3238.054     0.150
    42.812  3235.710     0.150
    42.824  3233.264     0.150
    47.469   513.362     0.150
    47.469   513.497     0.150
    65.336   640.537     0.150
    66.515   648.297     0.150
    71.640   680.377     0.150
     1.747    27.910     0.150
     1.786    27.750     0.150
     1.874    29.330     0.150
     2.473    38.229     0.150
     2.594    40.080     0.150
     2.663    40.410     0.150
     2.823    42.589     0.150
     2.913    44.319     0.150
     3.013    45.160     0.150
     3.013    45.310     0.150
     3.626    53.160     0.150
     3.731    54.379     0.150
     3.787    55.169     0.150
     3.749    54.640     0.150
     3.801    55.660     0.150
     4.094    58.890     0.150
     5.008    71.709     0.150
     5.089    72.890     0.150
     5.120    73.430     0.150
     6.631   174.689     0.150
     8.927   125.540     0.150
     9.008   126.709     0.150
    10.085   140.879     0.150
    24.608   316.750     0.150
    24.941   318.689     0.150
    34.376   403.009     0.150
    86.961   463.719     0.150
    42.963  3228.828     0.150
    42.968  3234.136     0.150
    42.980  3226.185     0.150
    42.971   477.989     0.150
    44.123  3315.262     0.150
    44.137  3316.495     0.150
    44.141  3315.258     0.150
    46.807   507.399     0.150
    52.972     9.100     0.150
    59.102   596.330     0.150
    63.940   638.189     0.150
    64.533     8.100     0.150
    66.671   649.290     0.150
    66.671     6.200     0.150
    72.332   684.140     0.150
    75.526   698.790     0.150
    75.526    12.000     0.150
    75.598   703.350     0.150
    75.885   702.790     0.150
    75.885   704.779     0.150
    76.047   703.089     0.150
    77.860   715.969     0.150
    78.006   716.707     0.150
    78.193   717.255     0.150
    78.248   718.197     0.150
    78.357   718.275     0.150
    78.488   719.349     0.150
    78.654   720.446     0.150
    78.752   721.149     0.150
    79.038   722.486     0.150
    79.376   724.188     0.150
    79.376   724.350     0.150
    81.669   733.689     0.150
    84.018   747.859     0.150
   111.435  8379.264     0.150
   111.447  8379.326     0.150
     1.613    25.346     0.150
     1.613    26.946     0.150
     2.416    35.016     0.150
     2.416    40.136     0.150
     2.645    37.146     0.150
     2.831    38.976     0.150
     3.842    55.676     0.150
     4.785    69.315     0.150
     7.157   100.976     0.150
    42.815  3226.681     0.150
    42.821  3226.329     0.150
    42.833  3227.987     0.150
    43.977  3314.687     0.150
    43.991  3314.737     0.150
    43.995  3316.534     0.150
    47.279   511.281     0.150
    56.354   578.996     0.150
    64.383     3.100     0.150
    64.427   635.556     0.150
    64.447   634.031     0.150
    64.536   635.557     0.150
    64.734   635.956     0.150
    64.913   637.206     0.150
    65.143   639.506     0.150
    65.745   642.999     0.150
    66.321   646.639     0.150
    66.431   646.946     0.150
    69.017   664.431     0.150
    81.499   738.642     0.150
     2.813    71.974     0.150
     4.147    61.664     0.150
    15.645   214.764     0.150
    42.866  3229.635     0.150
    42.872  3225.168     0.150
    42.884  3230.866     0.150
    44.028  3316.490     0.150
    44.041  3327.073     0.150
    44.045  3314.017     0.150
    65.208   639.654     0.150
    66.394   647.144     0.150
    66.504   647.954     0.150
    69.027   664.324     0.150
    75.064   699.416     0.150
     0.343    15.345     0.150
     0.921    32.015     0.150
     0.921    17.524     0.150
     0.921    31.624     0.150
     1.554    27.424     0.150
     6.220    89.194     0.150
     8.897   126.725     0.150
     9.287   130.044     0.150
     9.971   141.095     0.150
    10.446   147.424     0.150
    16.156  1202.271     0.150
    16.157  1200.326     0.150
    16.851   419.789     0.150
    20.756   277.194     0.150
    32.251   384.614     0.150
    36.902   424.935     0.150
    41.748   466.624     0.150
    42.952  3241.088     0.150
    42.958  3241.531     0.150
    42.970  3242.768     0.150
    44.115  3329.710     0.150
    44.128  3317.600     0.150
    44.132  3327.240     0.150
    45.384   494.694     0.150
    51.358  3851.022     0.150
    52.790    13.400     0.150
    54.603   565.874     0.150
    56.165   577.754     0.150
    56.771   583.124     0.150
    59.567   600.984     0.150
    63.194   626.225     0.150
    63.763   630.914     0.150
    64.336   632.954     0.150
    64.344     6.699     0.150
    64.579   634.614     0.150
    64.891   646.714     0.150
    64.891     6.801     0.150
    66.477     8.199     0.150
    67.022   651.334     0.150
    74.974   697.424     0.150
    75.331     5.899     0.150
    75.911   697.914     0.150
    76.585   708.414     0.150
    76.927   705.214     0.150
    77.939   716.614     0.150
    78.207   719.384     0.150
    78.897   721.314     0.150
    78.897   722.645     0.150
    79.160   720.681     0.150
    79.845   730.947     0.150
    79.864   727.849     0.150
    80.049   729.690     0.150
    80.427   730.024     0.150
    81.844   737.185     0.150
    85.428   754.274     0.150
    87.529   766.095     0.150
    88.668   769.964     0.150
    99.289   819.124     0.150
   111.619  8376.747     0.150
   111.631  8378.048     0.150
   158.799  1194.198     0.150
     2.820    41.880     0.150
     2.820    73.180     0.150
     3.544    53.960     0.150
     3.895    57.060     0.150
     4.008    59.550     0.150
     4.989    73.770     0.150
    42.855  3222.441     0.150
    42.861  3222.441     0.150
    42.873  3222.441     0.150
    44.016  3311.419     0.150
    44.029  3311.419     0.150
    44.033  3311.419     0.150
    44.030   486.630     0.150
    47.764   514.589     0.150
    56.418   578.720     0.150
    56.456   580.739     0.150
    57.584   587.239     0.150
    58.033   590.529     0.150
    64.502    10.400     0.150
    75.104   699.890     0.150
    92.848   787.789     0.150
   111.475  8369.522     0.150
   111.486  8371.245     0.150
   154.079  1208.204     0.150
     0.927    27.243     0.150
     2.733    44.673     0.150
     3.308    53.173     0.150
     3.795    59.593     0.150
     5.524    80.133     0.150
    42.968  3239.129     0.150
    42.974  3241.438     0.150
    42.986  3240.631     0.150
    44.131  3333.273     0.150
    44.145  3330.956     0.150
    44.149  3336.412     0.150
    64.360   635.173     0.150
    64.360     5.900     0.150
    65.048   636.773     0.150
    66.253   647.813     0.150
    74.888   699.823     0.150
   144.286  1175.804     0.150
     3.553    55.229     0.150
    43.030  3234.482     0.150
    43.036  3245.172     0.150
    43.048  3246.136     0.150
    44.193  3339.216     0.150
    44.207  3340.108     0.150
    44.211  3315.395     0.150
    56.145   578.350     0.150
    57.330   588.829     0.150
    64.238   633.180     0.150
    64.353     5.199     0.150
    65.108   638.810     0.150
    71.756   680.779     0.150
    74.832   698.470     0.150
    75.318   698.529     0.150
     3.546    55.290     0.150
     3.694    60.560     0.150
     4.600    70.020     0.150
     4.643    70.230     0.150
     8.884   127.370     0.150
     9.246   129.850     0.150
    32.216   393.136     0.150
    34.462   408.751     0.150
    43.010  3237.312     0.150
    43.016  3248.262     0.150
    43.028  3226.395     0.150
    44.173  3320.049     0.150
    44.187  3335.990     0.150
    44.191  3342.057     0.150
    45.426   496.880     0.150
    47.160   514.425     0.150
    47.515   509.438     0.150
    74.855   697.110     0.150
     2.833    73.190     0.150
     4.010    60.200     0.150
     4.870    70.970     0.150
     8.917   127.960     0.150
    12.354   299.985     0.150
    32.145   394.908     0.150
    34.457   413.961     0.150
    42.839  3223.536     0.150
    42.845  3223.843     0.150
    42.857  3225.333     0.150
    44.000  3310.087     0.150
    44.013  3314.618     0.150
    44.017  3314.562     0.150
    64.540   635.120     0.150
    66.457   646.920     0.150
   133.672  1159.960     0.150
   144.045  1179.054     0.150
     0.525    12.275     0.150
     1.154    20.786     0.150
     1.774    30.315     0.150
     1.774    52.346     0.150
     1.926    32.876     0.150
     1.980    33.096     0.150
     2.473    40.136     0.150
     2.594    41.666     0.150
     2.615    41.636     0.150
     2.680    42.916     0.150
     2.661    42.226     0.150
     2.661    74.576     0.150
     2.661    42.176     0.150
     2.760    40.576     0.150
     2.822    44.036     0.150
     2.906    44.936     0.150
     2.906    80.136     0.150
     3.006    46.716     0.150
     3.466    52.525     0.150
     3.611    55.275     0.150
     3.611    95.976     0.150
     3.611    54.426     0.150
     3.611    54.775     0.150
     3.735    56.235     0.150
     3.762    56.525     0.150
     3.786    57.565     0.150
     3.836    58.176     0.150
     4.076    60.775     0.150
     4.076    60.406     0.150
     4.076    61.176     0.150
     4.176    62.065     0.150
     4.176    62.076     0.150
     4.229    62.936     0.150
     4.229    62.775     0.150
     4.301    64.065     0.150
     4.301    63.976     0.150
     4.338    64.506     0.150
     4.464    66.985     0.150
     4.589    68.235     0.150
     4.822    71.216     0.150
     4.883    72.525     0.150
     4.889    72.275     0.150
     4.986    73.666     0.150
     4.986    73.976     0.150
     5.040    74.256     0.150
     5.057    74.646     0.150
     5.098    75.126     0.150
     5.098    75.775     0.150
     5.129    75.695     0.150
     5.129    76.376     0.150
     5.264   167.069     0.150
     5.264    76.926     0.150
     5.264    77.275     0.150
     5.264    77.336     0.150
     5.652    83.176     0.150
     5.883    86.355     0.150
     6.201    91.176     0.150
     6.431    93.766     0.150
     6.444    94.296     0.150
     6.649    96.576     0.150
     6.649    97.246     0.150
     6.699    96.976     0.150
     6.744    97.496     0.150
     7.084   102.906     0.150
     7.209   104.266     0.150
     7.239   104.166     0.150
     7.293   105.266     0.150
     7.457   107.235     0.150
     7.881   113.306     0.150
     7.927   115.076     0.150
     8.072   115.996     0.150
     8.084   116.006     0.150
     8.091   116.586     0.150
     8.094   116.286     0.150
     8.173   116.786     0.150
     8.314   119.456     0.150
     8.462   121.346     0.150
     8.710   124.355     0.150
     8.905   127.445     0.150
     8.949   127.775     0.150
     8.965   127.466     0.150
     8.986   128.576     0.150
     8.986   127.746     0.150
     8.986   128.676     0.150
     9.019   128.796     0.150
     9.180   130.855     0.150
     9.307   132.056     0.150
     9.598   137.076     0.150
     9.952   141.836     0.150
    10.064   142.546     0.150
    10.106   142.936     0.150
    10.541   148.576     0.150
    10.541   148.605     0.150
    10.541   149.616     0.150
    12.066   170.166     0.150
    12.132   169.346     0.150
    12.292   170.916     0.150
    12.601   177.466     0.150
    15.677   392.720     0.150
    15.677   217.726     0.150
    16.062   399.226     0.150
    16.062  1219.424     0.150
    16.062   398.656     0.150
    16.062  1219.426     0.150
    16.832   411.326     0.150
    17.066   237.275     0.150
    24.498   534.376     0.150
    24.498   317.806     0.150
    24.498   534.406     0.150
    24.498   317.976     0.150
    24.498   317.985     0.150
    25.280   325.746     0.150
    32.044   385.706     0.150
    32.656   391.256     0.150
    35.617   415.775     0.150
    35.617   426.576     0.150
    35.617   749.076     0.150
    36.230   508.876     0.150
    36.230   925.176     0.150
    36.299   500.076     0.150
    36.299   571.676     0.150
    36.569   425.296     0.150
    36.808   427.206     0.150
    38.034   569.501     0.150
    38.034   437.266     0.150
    38.034   571.206     0.150
    40.747   460.586     0.150
    40.971   451.676     0.150
    41.159   471.376     0.150
    41.664   468.235     0.150
    42.912  3231.662     0.150
    42.918  3232.104     0.150
    42.930  3232.150     0.150
    42.985     9.500     0.150
    44.072  3313.004     0.150
    44.092   486.876     0.150
    44.086  3312.895     0.150
    44.090  3314.346     0.150
    45.175   496.775     0.150
    45.514   498.485     0.150
    45.600   499.706     0.150
    45.684     3.300     0.150
    47.059   511.025     0.150
    47.059   511.065     0.150
    47.036   512.176     0.150
    47.400   512.576     0.150
    47.400   512.536     0.150
    47.567   515.576     0.150
    47.567   514.176     0.150
    47.928   517.266     0.150
    47.991     8.300     0.150
    48.101   517.376     0.150
    48.917   532.676     0.150
    48.917   540.476     0.150
    50.327     4.200     0.150
    50.327     8.500     0.150
    50.825   539.086     0.150
    50.885   539.226     0.150
    50.885   539.836     0.150
    50.982   541.466     0.150
    51.164   542.485     0.150
    51.402   543.315     0.150
    51.572   545.386     0.150
    51.864   547.926     0.150
    52.057   551.176     0.150
    52.985     7.000     0.150
    53.411   557.176     0.150
    54.816   568.636     0.150
    55.154   571.046     0.150
    55.625  1029.976     0.150
    55.638   574.396     0.150
    55.748   574.756     0.150
    55.939   576.806     0.150
    56.152   577.466     0.150
    57.027   585.076     0.150
    57.508     7.500     0.150
    57.650   589.086     0.150
    57.838    10.700     0.150
    58.053   588.775     0.150
    58.053  1062.676     0.150
    58.053  1297.275     0.150
    58.310  1070.476     0.150
    58.469     4.600     0.150
    58.469     6.900     0.150
    59.167   599.906     0.150
    59.287   599.275     0.150
    59.317  1091.476     0.150
    59.556   602.686     0.150
    61.632     7.300     0.150
    63.380   629.525     0.150
    63.590    11.000     0.150
    63.590  1145.176     0.150
    63.950     9.199     0.150
    63.950  1147.976     0.150
    64.270   636.376     0.150
    64.506   635.176     0.150
    64.554     6.699     0.150
    64.570   635.386     0.150
    64.770   637.376     0.150
    64.920   639.275     0.150
    64.925   638.976     0.150
    64.958   639.836     0.150
    64.940   640.676     0.150
    65.030   641.646     0.150
    65.090   639.796     0.150
    65.090     6.300     0.150
    65.090    10.601     0.150
    65.378   640.626     0.150
    65.601   643.775     0.150
    66.067   646.166     0.150
    66.072   647.136     0.150
    66.581   648.146     0.150
    66.702     8.000     0.150
    66.702   678.275     0.150
    66.702   923.275     0.150
    66.702  1441.476     0.150
    67.206   654.466     0.150
    67.584   655.936     0.150
    67.795   657.596     0.150
    67.836   657.706     0.150
    68.367   661.076     0.150
    68.411   661.195     0.150
    68.443   661.146     0.150
    69.034   665.256     0.150
    69.034   665.346     0.150
    69.034   663.346     0.150
    69.034   663.386     0.150
    69.456   667.966     0.150
    69.555     3.700     0.150
    69.555     7.300     0.150
    69.555  1209.275     0.150
    69.680   669.506     0.150
    69.795   669.676     0.150
    70.132   833.876     0.150
    70.132  1213.275     0.150
    70.653   675.466     0.150
    70.793   676.176     0.150
    71.105   678.076     0.150
    71.174   678.485     0.150
    71.384   941.476     0.150
    71.384   679.485     0.150
    71.384   679.485     0.150
    71.384   679.485     0.150
    71.384   698.726     0.150
    71.384   837.886     0.150
    71.384   941.525     0.150
    71.384  1235.996     0.150
    71.384  1281.506     0.150
    71.384  1511.876     0.150
    71.384  1711.605     0.150
    71.534   680.516     0.150
    71.480   680.735     0.150
    71.597   680.156     0.150
    71.681   681.406     0.150
    71.810   682.275     0.150
    72.530   686.355     0.150
    72.531   688.596     0.150
    72.626   689.296     0.150
    72.755   687.836     0.150
    73.237   691.366     0.150
    73.819   700.746     0.150
    73.846   694.275     0.150
    73.943   694.065     0.150
    73.943   693.936     0.150
    74.228   695.936     0.150
    74.228  1267.666     0.150
    74.228   696.605     0.150
    74.219   695.676     0.150
    74.219  1267.176     0.150
    74.238   698.116     0.150
    74.576   697.657     0.150
    74.576   697.576     0.150
    74.576  1273.676     0.150
    74.576  1317.676     0.150
    74.576  1564.676     0.150
    74.576  1762.676     0.150
    74.576  1972.676     0.150
    74.764   699.706     0.150
    74.882   699.326     0.150
    74.948   700.775     0.150
    74.954   700.866     0.150
    75.101   700.176     0.150
    75.101   700.275     0.150
    75.109   700.366     0.150
    75.109   700.386     0.150
    75.135   700.476     0.150
    75.144   701.876     0.150
    75.167   701.576     0.150
    75.256   706.376     0.150
    75.415   703.376     0.150
    75.424   703.576     0.150
    75.620   704.775     0.150
    75.620   704.735     0.150
    75.660   705.275     0.150
    75.660  1284.176     0.150
    75.713   705.286     0.150
    75.713   705.179     0.150
    75.947   706.376     0.150
    75.947   706.466     0.150
    75.962   706.476     0.150
    75.962  1286.775     0.150
    76.262   707.775     0.150
    76.262   707.775     0.150
    76.602     6.500     0.150
    76.612   701.676     0.150
    76.648   710.376     0.150
    76.710   710.376     0.150
    76.777   711.476     0.150
    76.777  1298.976     0.150
    76.777   711.476     0.150
    76.914   712.976     0.150
    77.068   712.275     0.150
    77.120   712.576     0.150
    77.120  1299.576     0.150
    77.122   713.176     0.150
    77.233   713.126     0.150
    77.493   714.536     0.150
    77.493   714.666     0.150
    77.566   715.576     0.150
    77.601   719.176     0.150
    77.601   713.876     0.150
    77.661   716.876     0.150
    77.661   716.855     0.150
    77.665   714.976     0.150
    77.710   715.376     0.150
    77.808   716.926     0.150
    78.088   716.753     0.150
    78.149   719.275     0.150
    78.217   717.990     0.150
    78.371   719.676     0.150
    78.371   719.586     0.150
    78.534   721.386     0.150
    79.144   722.775     0.150
    79.258   724.476     0.150
    79.800   730.676     0.150
    79.830   726.735     0.150
    80.056   728.775     0.150
    80.075   729.076     0.150
    80.366   725.176     0.150
    80.366  1327.076     0.150
    80.447   730.876     0.150
    80.465   731.176     0.150
    80.465   732.456     0.150
    80.552   731.876     0.150
    80.552   731.936     0.150
    80.622   731.576     0.150
    80.655   732.176     0.150
    80.671   731.876     0.150
    80.722   731.315     0.150
    80.763   733.576     0.150
    81.094  1028.576     0.150
    81.169   734.976     0.150
    81.264   735.396     0.150
    81.283   735.473     0.150
    81.283   735.636     0.150
    81.372   735.775     0.150
    81.372   736.146     0.150
    81.388   737.476     0.150
    81.388   735.056     0.150
    81.388   735.666     0.150
    81.504   739.275     0.150
    81.609   736.756     0.150
    82.076   739.416     0.150
    82.270   740.116     0.150
    82.596   744.876     0.150
    82.596   747.775     0.150
    82.939   748.476     0.150
    83.529   746.826     0.150
    83.632  1370.485     0.150
    83.632  1699.045     0.150
    83.633   747.546     0.150
    83.633   747.636     0.150
    83.633   747.536     0.150
    83.927   749.476     0.150
    83.927  1372.676     0.150
    84.128   748.626     0.150
    84.132   750.596     0.150
    84.265   752.936     0.150
    84.651   751.716     0.150
    84.910   752.146     0.150
    84.975   755.076     0.150
    84.975  1379.576     0.150
    85.045   754.985     0.150
    85.203   759.976     0.150
    85.389   756.976     0.150
    85.389  1382.376     0.150
    85.648   757.916     0.150
    85.696   758.366     0.150
    86.118   759.686     0.150
    86.530   765.176     0.150
    86.530   762.166     0.150
    87.353   765.476     0.150
    87.353   765.485     0.150
    87.802   771.601     0.150
    88.579   774.976     0.150
    88.579   770.476     0.150
    88.579   770.426     0.150
    88.646   779.001     0.150
    88.940   773.815     0.150
    89.148   773.676     0.150
    89.596   777.166     0.150
    90.840   785.476     0.150
    91.395   787.976     0.150
    92.911   790.426     0.150
    93.912   796.466     0.150
    94.495   801.976     0.150
    95.935   808.876     0.150
    96.206   814.876     0.150
    96.222   814.525     0.150
    96.251  1809.676     0.150
    96.251   805.775     0.150
    96.251   805.775     0.150
    99.522   821.576     0.150
    99.522   821.576     0.150
   111.420  8379.682     0.150
   111.431  8386.621     0.150
   121.300  1129.351     0.150
   146.426  1180.186     0.150
   148.210  1181.866     0.150
   150.485  1185.176     0.150
   156.065  1189.476     0.150
   156.065  1217.201     0.150
   159.896  1234.676     0.150
   159.896  1234.775     0.150
   163.050  1192.775     0.150
   163.050  2690.875     0.150
     3.967    57.875     0.150
    12.051   173.235     0.150
    12.379   174.535     0.150
    42.786  3221.737     0.150
    42.792  3222.282     0.150
    42.804  3220.712     0.150
    43.947  3306.351     0.150
    43.961  3316.694     0.150
    43.965  3311.433     0.150
    56.160   577.696     0.150
    64.512   634.255     0.150
    64.513   634.685     0.150
    64.798   637.110     0.150
    65.209   641.073     0.150
    66.382   647.718     0.150
    66.382   647.196     0.150
    70.913   675.585     0.150
    75.101   698.935     0.150
     4.843    69.623     0.150
     5.021    72.982     0.150
     5.348    76.412     0.150
     5.752    81.982     0.150
     5.721    85.363     0.150
     6.103    87.113     0.150
     6.548    98.832     0.150
     7.030    98.832     0.150
     7.226   102.643     0.150
     9.013   129.793     0.150
    24.897   318.119     0.150
    34.509   405.623     0.150
    42.824  3224.512     0.150
    42.829  3223.750     0.150
    42.841  3226.695     0.150
    43.985  3314.400     0.150
    43.998  3311.848     0.150
    44.002  3313.373     0.150
    50.770   536.266     0.150
    66.394   646.822     0.150
    66.394   647.344     0.150
    69.052   660.936     0.150
    71.518   678.982     0.150
    81.567   736.588     0.150
    85.627   754.635     0.150
     1.711    28.928     0.150
     3.530    63.258     0.150
     4.095    60.498     0.150
     4.220    62.719     0.150
     5.024    78.299     0.150
     5.376    81.088     0.150
     5.725    87.928     0.150
     5.877    89.498     0.150
     6.419    97.219     0.150
     6.719    98.848     0.150
     6.745   101.158     0.150
     7.218   106.639     0.150
     7.221   108.238     0.150
     8.068   120.309     0.150
     8.466   125.098     0.150
     9.012   132.879     0.150
     9.223   130.879     0.150
     9.316   133.758     0.150
     9.618   140.248     0.150
    12.195   175.838     0.150
    42.852  3291.396     0.150
    42.858  3291.566     0.150
    42.870  3289.000     0.150
    44.013  3376.496     0.150
    44.026  3376.006     0.150
    44.030  3376.184     0.150
    47.085   511.758     0.150
    55.085   571.021     0.150
    66.416   648.158     0.150
    66.416   647.729     0.150
    75.090   700.229     0.150
    77.072   711.648     0.150
    81.599   737.201     0.150
    81.599   737.318     0.150
     4.917    71.672     0.150
     5.252   163.061     0.150
     8.914   127.451     0.150
    16.862   411.842     0.150
    42.916  3230.615     0.150
    42.922  3231.029     0.150
    42.934  3228.816     0.150
    44.078  3324.605     0.150
    44.092  3332.568     0.150
    44.096  3331.287     0.150
    47.262   509.631     0.150
    56.298   578.160     0.150
    74.983   698.980     0.150
    74.991   699.102     0.150
    84.005   749.363     0.150
     4.968    71.576     0.150
     4.962    73.986     0.150
     5.465    77.477     0.150
     5.812    83.426     0.150
     5.966    85.885     0.150
     6.618    97.785     0.150
     8.889   127.307     0.150
    23.134   301.135     0.150
    27.027   338.307     0.150
    30.675   370.996     0.150
    30.965   371.525     0.150
    31.343   376.066     0.150
    32.929   388.846     0.150
    34.182   401.316     0.150
    34.481   403.896     0.150
    36.873   424.477     0.150
    36.894   424.445     0.150
    41.429   464.836     0.150
    42.791  3228.586     0.150
    42.796  3231.025     0.150
    42.808  3234.348     0.150
    43.951  3311.072     0.150
    43.964  3318.111     0.150
    43.969  3318.008     0.150
    46.971   508.855     0.150
    47.122   508.355     0.150
    47.439   512.936     0.150
    48.913   524.266     0.150
    52.054   547.875     0.150
    64.588   635.594     0.150
    64.588   636.166     0.150
    64.528   632.746     0.150
    64.528    11.500     0.150
    65.304   640.334     0.150
    66.479   647.846     0.150
    66.479   647.465     0.150
    66.589   648.195     0.150
    66.699   651.346     0.150
    71.609   679.945     0.150
    75.178   700.406     0.150
    75.178   700.066     0.150
    81.625   738.896     0.150
    92.793   791.348     0.150
     3.939    57.881     0.150
     4.883    71.330     0.150
     5.277    75.961     0.150
     7.491   108.410     0.150
    12.374   298.260     0.150
    32.174   388.561     0.150
    42.811  3224.189     0.150
    42.816  3231.582     0.150
    42.829  3231.449     0.150
    43.971  3339.658     0.150
    43.985  3337.010     0.150
    43.989  3315.160     0.150
    47.398   512.500     0.150
    52.051   547.721     0.150
    64.823   638.760     0.150
   111.483  8546.098     0.150
   111.495  8547.369     0.150
   144.038  1177.529     0.150
   144.038  1173.420     0.150
     1.851    31.596     0.150
     4.759    69.096     0.150
     4.799    69.486     0.150
     4.940    71.916     0.150
     8.235   116.275     0.150
    16.890   404.975     0.150
    34.496   409.055     0.150
    42.885  3224.055     0.150
    42.891  3224.980     0.150
    42.903  3224.377     0.150
    44.047  3316.115     0.150
    44.061  3317.318     0.150
    44.065  3316.396     0.150
    47.278   511.166     0.150
     1.067    19.199     0.150
     3.543    52.000     0.150
     4.011    60.129     0.150
     5.166    74.189     0.150
     5.270    76.219     0.150
     5.666    81.289     0.150
     5.816    83.930     0.150
     6.671    94.740     0.150
     9.744   136.760     0.150
    42.901  3221.166     0.150
    42.907  3225.117     0.150
    42.919  3225.467     0.150
    44.062  3310.242     0.150
    44.076  3317.326     0.150
    44.080  3312.240     0.150
    47.128   507.820     0.150
    64.535   635.000     0.150
    65.293   639.299     0.150
    42.813  3226.598     0.150
    42.819  3222.793     0.150
    42.831  3222.688     0.150
    43.974  3315.689     0.150
    43.987  3318.457     0.150
    43.992  3319.461     0.150
    65.263   640.637     0.150
    66.442   647.631     0.150
    66.442   647.172     0.150
     0.461    19.689     0.150
     1.056    35.119     0.150
     1.056    19.189     0.150
     1.661    27.879     0.150
     2.368    37.359     0.150
     2.557    39.391     0.150
     2.717    41.510     0.150
     2.807    42.879     0.150
     2.807    76.561     0.150
     2.906    44.080     0.150
     3.520    51.289     0.150
     3.520    91.189     0.150
     3.642    53.670     0.150
     3.694    54.561     0.150
     3.988    57.891     0.150
     3.988    57.801     0.150
     4.985    71.959     0.150
     5.014    72.430     0.150
     6.354    90.930     0.150
     8.822   124.570     0.150
     8.903   125.250     0.150
    10.037   140.910     0.150
    10.457   148.350     0.150
    12.110   169.080     0.150
    16.145  1208.191     0.150
    16.145  1207.908     0.150
    29.385   361.840     0.150
    30.712   373.379     0.150
    32.195   384.641     0.150
    34.483   404.859     0.150
    42.885  3226.605     0.150
    42.891  3225.637     0.150
    42.903  3225.080     0.150
    42.832   476.070     0.150
    44.046  3311.418     0.150
    44.060  3310.619     0.150
    44.064  3313.240     0.150
    45.419   498.990     0.150
    45.418   495.240     0.150
    47.029   511.119     0.150
    47.882   512.490     0.150
    51.277  3863.273     0.150
    51.481   542.029     0.150
    52.873   562.391     0.150
    63.840   631.391     0.150
    63.840     8.000     0.150
    64.712   635.289     0.150
    64.977   645.490     0.150
    64.977     9.900     0.150
    66.589   647.391     0.150
    66.589     5.299     0.150
    66.589   918.891     0.150
    71.183   676.814     0.150
    72.828   687.949     0.150
    74.556   696.990     0.150
    74.961   698.490     0.150
    74.997   698.891     0.150
    75.001   698.990     0.150
    75.025   699.090     0.150
    75.124   699.789     0.150
    75.451   704.391     0.150
    75.451     5.199     0.150
    75.598   701.369     0.150
    76.505   710.891     0.150
    76.718   708.221     0.150
    76.718   707.770     0.150
    77.119   712.150     0.150
    78.007   717.207     0.150
    78.158   719.240     0.150
    78.200   718.367     0.150
    78.248   717.109     0.150
    78.364   719.045     0.150
    78.377   719.137     0.150
    78.756   721.301     0.150
    81.278   736.189     0.150
    81.967   737.500     0.150
    82.023   738.600     0.150
    84.047   748.709     0.150
    86.498   759.330     0.150
    92.852   791.789     0.150
    92.865   792.008     0.150
    96.209   807.340     0.150
   111.532  8386.016     0.150
   111.544  8381.324     0.150
   144.149  1167.709     0.150
   159.447  1198.500     0.150
     2.841    43.188     0.150
     2.841    43.777     0.150
     3.949    57.678     0.150
     4.855    73.197     0.150
    32.749   389.797     0.150
    37.389   429.197     0.150
    42.806  3221.930     0.150
    42.811  3223.432     0.150
    42.824  3223.416     0.150
    43.968  3312.281     0.150
    43.981  3311.170     0.150
    43.985  3313.014     0.150
    46.157   500.348     0.150
    47.091   510.047     0.150
    78.820   721.889     0.150
    84.107   749.387     0.150
   111.576  8385.406     0.150
   111.588  8386.707     0.150
     0.368    11.693     0.150
     4.708    71.574     0.150
     6.222    93.145     0.150
     6.483    96.174     0.150
     6.575    97.385     0.150
     7.274   104.184     0.150
     7.929   116.354     0.150
     8.144   119.443     0.150
     8.296   120.523     0.150
     8.950   129.404     0.150
     9.148   132.395     0.150
     9.775   141.635     0.150
    10.137   146.344     0.150
    42.955  3236.119     0.150
    42.961  3236.119     0.150
    42.973  3237.818     0.150
    44.117  3322.916     0.150
    44.131  3322.916     0.150
    44.135  3322.916     0.150
    51.321  3853.994     0.150
   111.582  8373.217     0.150
   111.593  8375.389     0.150
     1.593    28.385     0.150
     1.622    28.254     0.150
     3.268    52.914     0.150
     3.568    58.764     0.150
     4.045    66.465     0.150
     4.194    62.244     0.150
     4.606    70.475     0.150
     4.654    72.725     0.150
     5.145    76.424     0.150
     6.492    98.164     0.150
     6.492    97.754     0.150
     8.476   123.064     0.150
     8.968   133.564     0.150
     9.311   135.295     0.150
    10.517   155.064     0.150
    12.110   300.789     0.150
    16.086  1185.604     0.150
    16.086  1184.754     0.150
    24.392   322.064     0.150
    24.392   319.564     0.150
    24.392   577.264     0.150
    32.191   553.465     0.150
    36.109   416.465     0.150
    36.109   495.363     0.150
    36.109   562.664     0.150
    38.002   433.764     0.150
    41.000   823.363     0.150
    41.331   461.584     0.150
    43.021  3244.699     0.150
    43.027  3245.477     0.150
    43.039  3246.922     0.150
    44.184  3334.719     0.150
    44.197  3333.574     0.150
    44.201  3333.941     0.150
    45.450   495.164     0.150
    47.172   507.863     0.150
    50.787   536.514     0.150
    51.307  3851.441     0.150
    51.412   542.424     0.150
    51.660   544.363     0.150
    52.840    10.100     0.150
    56.829   578.965     0.150
    57.820   712.264     0.150
    64.387     8.400     0.150
    64.721   636.324     0.150
    64.939    10.000     0.150
    65.053   636.465     0.150
    65.147   636.465     0.150
    66.266   644.264     0.150
    66.266   644.953     0.150
    69.247   665.174     0.150
    69.897   685.863     0.150
    69.897  1221.764     0.150
    70.408   671.594     0.150
    70.446   672.725     0.150
    70.587   673.484     0.150
    70.899   675.344     0.150
    70.964   675.764     0.150
    71.152   937.164     0.150
    71.152   676.203     0.150
    71.152   676.203     0.150
    71.152   676.203     0.150
    71.152   695.994     0.150
    71.152   833.805     0.150
    71.152   937.184     0.150
    71.152  1231.014     0.150
    71.152  1277.645     0.150
    71.152  1505.715     0.150
    71.152  1705.193     0.150
    71.326   677.863     0.150
    71.271   678.023     0.150
    71.472   678.953     0.150
    73.671   690.283     0.150
    74.022   695.014     0.150
    74.353   695.264     0.150
    74.353     9.301     0.150
    74.353   862.664     0.150
    74.732   698.033     0.150
    74.738   698.084     0.150
    74.843   696.264     0.150
    74.868   697.465     0.150
    74.868   697.504     0.150
    74.868   696.465     0.150
    74.876   697.564     0.150
    74.876   697.533     0.150
    74.941   698.174     0.150
    75.189   701.064     0.150
    75.217   699.504     0.150
    75.225   701.264     0.150
    75.356     3.799     0.150
    75.397   701.863     0.150
    75.397   701.023     0.150
    75.434   702.164     0.150
    75.721   703.764     0.150
    75.721   703.754     0.150
    76.035   705.064     0.150
    76.035   705.164     0.150
    76.418   707.465     0.150
    76.483   708.064     0.150
    76.685   709.764     0.150
    76.892   710.465     0.150
    76.956   711.824     0.150
    77.013   711.965     0.150
    77.338   712.664     0.150
    77.434   713.965     0.150
    77.434   713.953     0.150
    77.906   716.635     0.150
    77.920   715.764     0.150
    77.920   713.934     0.150
    78.139   717.064     0.150
    78.780   719.936     0.150
    78.862   722.645     0.150
    79.128   721.975     0.150
    79.371   723.646     0.150
    79.779   726.000     0.150
    79.824   725.863     0.150
    79.843   726.764     0.150
    80.217   727.764     0.150
    80.258   726.764     0.150
    80.321   728.150     0.150
    80.321   728.164     0.150
    80.338   729.164     0.150
    80.389   729.363     0.150
    80.424   729.564     0.150
    80.859   724.965     0.150
    80.859   910.363     0.150
    80.859  1024.564     0.150
    80.859  1324.564     0.150
    81.550   735.664     0.150
    82.197   737.922     0.150
    84.154   748.314     0.150
    85.413   754.664     0.150
    85.462   757.264     0.150
    86.035   760.055     0.150
   111.571  8372.879     0.150
   111.583  8374.078     0.150
     1.519    27.234     0.150
     3.542    55.064     0.150
     5.115    73.715     0.150
     5.877    85.635     0.150
     7.830   109.455     0.150
     8.969   124.936     0.150
     9.752   136.424     0.150
    10.368   147.605     0.150
    10.496   149.484     0.150
    10.496   149.936     0.150
    10.680   150.834     0.150
    10.858   151.014     0.150
    12.052   167.025     0.150
    16.110  1200.334     0.150
    16.110  1194.580     0.150
    24.376   314.824     0.150
    24.341   573.324     0.150
    24.341   315.725     0.150
    24.341   315.584     0.150
    33.854   398.734     0.150
    35.450   748.225     0.150
    36.853   426.215     0.150
    40.897   460.455     0.150
    40.930   471.125     0.150
    40.930  1044.424     0.150
    40.910   460.625     0.150
    41.472   465.334     0.150
    43.050  3240.670     0.150
    43.055  3226.338     0.150
    43.068  3252.275     0.150
    43.925   482.855     0.150
    44.213  3335.928     0.150
    44.227  3334.209     0.150
    44.231  3335.604     0.150
    45.412   496.324     0.150
    45.412   496.275     0.150
    45.413   496.535     0.150
    46.797   507.334     0.150
    47.083   507.924     0.150
    47.181   510.955     0.150
    47.701   514.234     0.150
    47.701   514.264     0.150
    47.807     8.600     0.150
    50.738   537.115     0.150
    51.371  3849.670     0.150
    51.430   541.174     0.150
    51.590   543.084     0.150
    51.590   543.475     0.150
    52.548   553.414     0.150
    52.774     7.801     0.150
    53.001   557.105     0.150
    54.569   565.205     0.150
    54.569   565.285     0.150
    54.569   565.264     0.150
    54.906   568.055     0.150
    55.837   573.514     0.150
    58.252     7.699     0.150
    58.252    10.699     0.150
    58.252  1062.225     0.150
    59.428   599.654     0.150
    60.961   606.225     0.150
    62.730   623.355     0.150
    63.423     5.000     0.150
    64.154   633.324     0.150
    64.315    11.400     0.150
    64.467   633.025     0.150
    64.638   635.035     0.150
    64.871    13.000     0.150
    65.058  1400.824     0.150
    65.058   636.674     0.150
    66.182   644.215     0.150
    66.291   645.195     0.150
    66.427    11.701     0.150
    68.753   663.014     0.150
    69.086   665.625     0.150
    69.163   663.875     0.150
    69.312     7.500     0.150
    69.810   817.625     0.150
    69.810  1203.824     0.150
    70.171   670.094     0.150
    70.324   670.154     0.150
    70.362   671.594     0.150
    70.503   672.195     0.150
    70.815   674.094     0.150
    70.880   674.535     0.150
    71.067   676.186     0.150
    71.067   676.186     0.150
    71.067   676.186     0.150
    71.067   696.074     0.150
    71.067   833.674     0.150
    71.067  1230.744     0.150
    71.067  1277.545     0.150
    71.067  1505.264     0.150
    71.067  1704.705     0.150
    71.242   676.625     0.150
    71.187   676.625     0.150
    71.388   677.445     0.150
    72.642   685.625     0.150
    72.642   685.584     0.150
    73.641   690.635     0.150
    74.028   694.225     0.150
    74.273   694.225     0.150
    74.273     7.500     0.150
    74.273   856.725     0.150
    74.590   696.744     0.150
    74.646   696.674     0.150
    74.652   696.945     0.150
    74.783   696.525     0.150
    74.783   696.025     0.150
    74.790   696.744     0.150
    74.790   696.635     0.150
    74.790   696.484     0.150
    74.862   698.584     0.150
    75.108   699.824     0.150
    75.187   700.025     0.150
    75.353   701.025     0.150
    75.353   701.025     0.150
    75.639   702.924     0.150
    75.657   702.824     0.150
    75.954   703.525     0.150
    76.335   706.324     0.150
    76.402   707.125     0.150
    76.402   707.164     0.150
    76.373   698.725     0.150
    76.473   705.924     0.150
    76.603   708.725     0.150
    76.816   709.324     0.150
    77.256   711.625     0.150
    77.353   713.424     0.150
    77.392   711.424     0.150
    77.392   711.324     0.150
    77.838   715.424     0.150
    78.055   715.225     0.150
    78.511   719.686     0.150
    78.784   721.605     0.150
    78.799   721.596     0.150
    78.944   721.225     0.150
    79.156   720.795     0.150
    79.739   725.324     0.150
    79.758   725.424     0.150
    80.134   727.324     0.150
    80.148   727.125     0.150
    80.236   728.324     0.150
    80.236   728.436     0.150
    80.249   727.924     0.150
    80.304   728.025     0.150
    80.341   728.725     0.150
    80.352   728.424     0.150
    80.771   917.525     0.150
    80.771  1026.424     0.150
    80.771  1857.525     0.150
    80.977   732.125     0.150
    81.053   732.225     0.150
    81.491   734.725     0.150
    81.781   735.264     0.150
    83.323   743.135     0.150
    85.382   756.275     0.150
    86.655   761.414     0.150
    87.490   765.115     0.150
    87.858   774.275     0.150
    87.858   774.752     0.150
    99.202   819.195     0.150
   111.638  8374.826     0.150
   111.650  8376.135     0.150
   121.517  1133.150     0.150
     0.995    18.102     0.150
     3.717    55.410     0.150
     5.223    75.570     0.150
    24.902   324.383     0.150
    42.945  3236.711     0.150
    42.951  3232.418     0.150
    42.963  3238.422     0.150
    44.107  3323.781     0.150
    44.121  3324.680     0.150
    44.125  3326.395     0.150
    47.145   515.305     0.150
    51.292  3852.273     0.150
    66.317   646.605     0.150
    66.317   646.250     0.150
     2.080    34.434     0.150
     2.748    41.977     0.150
     3.429    53.266     0.150
     4.170    61.914     0.150
     4.508    65.824     0.150
     4.773    71.867     0.150
     6.369    91.594     0.150
     7.826   110.426     0.150
     9.881   138.156     0.150
    11.139   159.676     0.150
    12.265   172.406     0.150
    14.159   199.984     0.150
    16.116  1206.836     0.150
    16.116  1207.359     0.150
    24.510   321.105     0.150
    32.164   394.156     0.150
    32.164   384.285     0.150
    34.453   412.707     0.150
    34.453   403.797     0.150
    42.904  3243.270     0.150
    42.909  3249.543     0.150
    42.922  3250.449     0.150
    44.065  3333.500     0.150
    44.079  3331.738     0.150
    44.083  3331.008     0.150
    50.780   536.887     0.150
    64.442   634.285     0.150
    64.443   634.406     0.150
    64.715   637.105     0.150
    64.715   636.832     0.150
    65.190   639.832     0.150
    66.385   646.184     0.150
    66.385   647.082     0.150
    66.385   646.566     0.150
    75.035   699.430     0.150
    81.598   736.855     0.150
   111.503  8374.051     0.150
   111.514  8375.605     0.150
     2.001    32.195     0.150
     4.711    68.012     0.150
     5.252    75.633     0.150
    12.101   168.922     0.150
    42.821  3234.105     0.150
    42.827  3242.406     0.150
    42.839  3243.309     0.150
    43.982  3328.906     0.150
    43.995  3330.574     0.150
    43.999  3319.555     0.150
    64.513   634.785     0.150
    66.409   647.633     0.150
    66.409   648.496     0.150
    66.409   647.523     0.150
    75.103   700.559     0.150
   111.510  8374.867     0.150
   111.522  8376.250     0.150
     2.229    35.238     0.150
     8.152   120.605     0.150
     9.867   140.457     0.150
    15.160   210.418     0.150
    42.787  3234.250     0.150
    42.792  3234.691     0.150
    42.805  3235.605     0.150
    43.947  3335.207     0.150
    43.960  3336.332     0.150
    43.965  3336.566     0.150
    47.124   510.207     0.150
    64.591   637.820     0.150
    81.624   741.648     0.150
    92.789   797.371     0.150
    96.129   811.621     0.150
     1.595    27.602     0.150
     2.768    43.199     0.150
     2.794    42.340     0.150
     3.489    53.281     0.150
     3.684    54.652     0.150
     4.187    62.320     0.150
     5.259    76.020     0.150
     9.142   128.332     0.150
     9.240   129.762     0.150
    10.431   147.691     0.150
    12.066   173.199     0.150
    12.232   169.441     0.150
    16.171  1208.297     0.150
    16.171  1208.297     0.150
    16.888   413.914     0.150
    24.344   566.590     0.150
    24.856   320.461     0.150
    25.421   325.141     0.150
    25.421   325.219     0.150
    32.241   381.512     0.150
    33.986   401.691     0.150
    36.726   425.270     0.150
    36.916   426.852     0.150
    37.932   434.512     0.150
    37.932   434.391     0.150
    40.986   469.391     0.150
    42.774   475.992     0.150
    42.774   475.969     0.150
    42.815   472.691     0.150
    42.815     6.098     0.150
    42.814   477.020     0.150
    42.900  3229.527     0.150
    42.906  3229.867     0.150
    42.918  3225.105     0.150
    43.936   484.859     0.150
    44.063  3310.855     0.150
    44.076  3312.441     0.150
    44.080  3325.582     0.150
    45.016   494.891     0.150
    45.381   496.410     0.150
    45.382   495.961     0.150
    45.382   497.449     0.150
    45.521     6.500     0.150
    45.521     9.098     0.150
    46.904   510.289     0.150
    46.982   509.441     0.150
    46.982   510.152     0.150
    47.210   508.363     0.150
    47.830     9.898     0.150
    47.861   516.820     0.150
    47.878   517.289     0.150
    47.878   517.332     0.150
    47.878   517.621     0.150
    49.235   525.250     0.150
    50.735   537.770     0.150
    50.834   538.211     0.150
    51.333  3860.605     0.150
    51.502   542.961     0.150
    51.777   545.812     0.150
    51.777   544.152     0.150
    51.776   545.840     0.150
    52.179   548.891     0.150
    52.476   551.000     0.150
    52.816     5.801     0.150
    52.816     9.500     0.150
    52.816   995.891     0.150
    53.252  1011.691     0.150
    54.639     4.000     0.150
    54.639   566.301     0.150
    54.642   625.691     0.150
    54.976   568.930     0.150
    55.199   571.219     0.150
    55.472   574.992     0.150
    57.338     8.500     0.150
    57.507   588.492     0.150
    57.678   589.391     0.150
    58.298     6.098     0.150
    58.298     9.000     0.150
    59.434   601.422     0.150
    59.546   600.840     0.150
    61.469     8.199     0.150
    62.916   625.039     0.150
    64.299   632.289     0.150
    64.378     5.598     0.150
    64.391   633.301     0.150
    64.652   635.191     0.150
    64.744   636.312     0.150
    64.801   638.789     0.150
    64.919    10.000     0.150
    64.972   638.332     0.150
    65.211  1157.191     0.150
    65.951   645.891     0.150
    65.951   645.082     0.150
    66.291   645.391     0.150
    66.291   645.430     0.150
    66.401   646.020     0.150
    66.522     5.000     0.150
    66.522     8.598     0.150
    66.522  1172.191     0.150
    69.276   665.332     0.150
    69.379     7.898     0.150
    70.433   671.461     0.150
    70.472   672.859     0.150
    70.612   673.629     0.150
    70.868     5.902     0.150
    70.925   675.469     0.150
    70.995   675.871     0.150
    71.245   939.492     0.150
    71.245   678.102     0.150
    71.245   678.102     0.150
    71.245   678.102     0.150
    71.245   697.672     0.150
    71.245   836.020     0.150
    71.245   939.500     0.150
    71.245  1233.582     0.150
    71.245  1279.770     0.150
    71.245  1508.750     0.150
    71.245  1708.332     0.150
    71.354   678.262     0.150
    71.300   678.121     0.150
    71.501   678.941     0.150
    72.211   684.609     0.150
    72.447   686.160     0.150
    72.575   687.102     0.150
    72.758   688.102     0.150
    72.818   688.539     0.150
    72.999   689.621     0.150
    73.667   691.832     0.150
    73.764   691.379     0.150
    73.778   693.312     0.150
    74.055   695.691     0.150
    74.167   695.070     0.150
    74.414   696.289     0.150
    74.458  1272.391     0.150
    74.458   695.391     0.150
    74.458     7.000     0.150
    74.458  1272.391     0.150
    74.458  1318.391     0.150
    74.458  1565.391     0.150
    74.458  1769.391     0.150
    74.458  2027.391     0.150
    74.491   696.789     0.150
    74.770   698.121     0.150
    74.775   698.352     0.150
    74.960   698.391     0.150
    74.960   698.352     0.150
    74.967   698.410     0.150
    74.967   698.199     0.150
    75.303   702.789     0.150
    75.303   702.789     0.150
    75.322   702.230     0.150
    75.371   702.352     0.150
    75.382     9.801     0.150
    75.503   703.289     0.150
    75.503   703.289     0.150
    75.503   703.551     0.150
    75.537   703.391     0.150
    75.537   703.449     0.150
    75.823   705.090     0.150
    75.842   705.891     0.150
    75.842   705.891     0.150
    75.909   705.980     0.150
    75.983   706.090     0.150
    76.086   706.301     0.150
    76.137   706.090     0.150
    76.137   706.191     0.150
    76.137   706.891     0.150
    76.436   699.691     0.150
    76.436  1282.191     0.150
    76.517   708.691     0.150
    76.586   709.129     0.150
    76.612   707.141     0.150
    76.658   707.891     0.150
    76.658   709.539     0.150
    76.786   709.191     0.150
    76.786   709.191     0.150
    76.949   711.191     0.150
    76.949   710.121     0.150
    76.989   712.430     0.150
    77.122   711.969     0.150
    77.438   714.391     0.150
    77.536   715.191     0.150
    77.536   715.121     0.150
    77.576   719.391     0.150
    77.569   713.691     0.150
    77.697   715.891     0.150
    77.968   717.102     0.150
    78.020   717.191     0.150
    78.187   717.004     0.150
    78.234   717.891     0.150
    78.317   717.910     0.150
    78.613   721.102     0.150
    78.696   721.051     0.150
    78.740  1313.391     0.150
    79.049   723.652     0.150
    79.233   724.109     0.150
    79.917   726.789     0.150
    79.936   727.391     0.150
    80.050  1324.590     0.150
    80.202  1022.992     0.150
    80.202  1639.691     0.150
    80.202  1848.691     0.150
    80.302   727.391     0.150
    80.327   728.789     0.150
    80.415   729.590     0.150
    80.480   729.992     0.150
    80.521   730.391     0.150
    80.529   730.090     0.150
    80.937  1026.289     0.150
    80.937  1862.691     0.150
    81.084   732.832     0.150
    81.225   733.621     0.150
    81.225   733.680     0.150
    81.230   734.289     0.150
    81.404   737.410     0.150
    81.515   735.379     0.150
    81.604   739.262     0.150
    81.897   737.492     0.150
    81.897   737.461     0.150
    82.295   740.359     0.150
    82.505   743.492     0.150
    82.505   745.992     0.150
    82.591   744.180     0.150
    83.227   747.012     0.150
    83.506   746.602     0.150
    83.723   748.082     0.150
    83.786   749.859     0.150
    84.836   755.020     0.150
    85.498   755.770     0.150
    85.566   755.539     0.150
    85.869   755.840     0.150
    86.157   760.832     0.150
    86.511   768.258     0.150
    86.706   767.391     0.150
    86.842   765.289     0.150
    88.517   773.391     0.150
    90.812   783.789     0.150
    92.855   793.289     0.150
    94.347   799.289     0.150
    95.869   801.871     0.150
    96.169   813.242     0.150
    99.353   819.852     0.150
   110.877  1769.691     0.150
   111.591  8370.758     0.150
   111.602  8372.031     0.150
   121.471  1128.539     0.150
   158.737  1198.875     0.150
   159.518  1200.371     0.150
   160.063  1233.750     0.150
     2.773    70.383     0.150
    16.115  1263.059     0.150
    42.909  3227.715     0.150
    42.915  3229.410     0.150
    42.927  3228.707     0.150
    44.071  3318.539     0.150
    44.084  3319.289     0.150
    44.088  3315.273     0.150
    64.585   634.492     0.150
    75.025   696.703     0.150
     5.131    73.918     0.150
    42.813  3220.715     0.150
    42.818  3225.184     0.150
    42.830  3227.770     0.150
    43.973  3309.117     0.150
    43.987  3314.523     0.150
    43.991  3315.602     0.150
    51.235  3872.699     0.150
    66.662   650.656     0.150
     1.149    20.363     0.150
     5.913    85.242     0.150
     8.887   127.430     0.150
    16.976   237.062     0.150
    17.635   244.293     0.150
    42.818  3228.820     0.150
    42.824  3228.441     0.150
    42.836  3226.969     0.150
    43.979  3317.051     0.150
    43.992  3320.812     0.150
    43.997  3317.172     0.150
    84.143   750.047     0.150
     3.992    60.035     0.150
     4.617    66.973     0.150
     6.511    97.414     0.150
     6.617    93.664     0.150
     6.641    94.266     0.150
     6.635    95.113     0.150
     8.025   113.223     0.150
     8.139   114.305     0.150
     8.203   115.945     0.150
     9.209   132.273     0.150
    11.083   159.176     0.150
    24.891   324.961     0.150
    42.914  3225.012     0.150
    42.920  3224.020     0.150
    42.932  3227.762     0.150
    44.076  3310.562     0.150
    44.090  3313.629     0.150
    44.094  3312.453     0.150
     2.795    40.125     0.150
     3.871    55.426     0.150
     6.448    93.176     0.150
     6.721    95.824     0.150
     6.722    96.004     0.150
     6.759    96.945     0.150
     9.774   139.273     0.150
    11.421   158.734     0.150
    11.890   165.254     0.150
    11.958   165.875     0.150
    13.748   190.453     0.150
    14.211   194.895     0.150
    14.413   198.477     0.150
    14.432   198.543     0.150
    15.730   216.113     0.150
    16.962   231.914     0.150
     7.158   101.117     0.150
     8.063   113.617     0.150
     8.688   122.312     0.150
     8.753   122.031     0.150
    12.091   167.266     0.150
    12.854   176.727     0.150
    15.729   215.641     0.150
     0.488    14.555     0.150
     1.672    29.305     0.150
     1.803    55.984     0.150
     1.883    57.648     0.150
     2.808    44.953     0.150
     2.808    72.359     0.150
     3.449    51.227     0.150
     3.879    57.977     0.150
     3.670   101.562     0.150
     5.296    76.656     0.150
     6.370    92.023     0.150
     6.544    94.406     0.150
     8.965   127.055     0.150
     9.075   130.258     0.150
    10.615   152.445     0.150
    15.091   208.016     0.150
    15.640   215.805     0.150
    15.751   217.000     0.150
    42.874  3225.719     0.150
    42.880  3227.844     0.150
    42.892  3227.094     0.150
    44.036  3312.125     0.150
    44.049  3312.070     0.150
    44.053  3313.508     0.150
     2.705    67.414     0.150
     6.992    99.664     0.150
     9.717   136.250     0.150
     1.026    33.391     0.150
     1.026    19.109     0.150
     1.600    28.734     0.150
     1.791    31.938     0.150
     1.804    31.852     0.150
     1.992    33.492     0.150
     2.695    43.789     0.150
     3.690    57.930     0.150
     4.356    66.047     0.150
     4.365    66.328     0.150
     4.419    67.297     0.150
     4.466    67.922     0.150
     4.541    67.891     0.150
     4.541    67.578     0.150
     4.541    69.281     0.150
     4.781    72.008     0.150
     5.180    76.188     0.150
     5.939    84.289     0.150
     6.243    88.633     0.150
     6.310    89.328     0.150
     6.570    93.453     0.150
     6.609    94.461     0.150
     6.962    98.773     0.150
     7.076    99.562     0.150
     7.104    99.867     0.150
     7.961   112.609     0.150
     8.199   114.992     0.150
     8.832   126.859     0.150
     8.882   127.211     0.150
     9.472   134.242     0.150
     9.488   133.000     0.150
     9.807   137.328     0.150
    10.529   150.578     0.150
    12.180   173.391     0.150
    12.982   179.547     0.150
    14.683   204.492     0.150
     1.802    30.797     0.150
     2.692    68.477     0.150
     3.757    55.211     0.150
     3.757    93.641     0.150
     4.053    60.602     0.150
     4.530   112.914     0.150
     7.942   111.750     0.150
     8.567   120.320     0.150
    10.482   146.039     0.150
    11.135   152.734     0.150
    11.607   161.000     0.150
    11.634   161.391     0.150
    43.001  3248.906     0.150
    43.007  3242.969     0.150
    43.019  3246.984     0.150
    44.164  3331.273     0.150
    44.177  3334.727     0.150
    44.181  3333.227     0.150
    74.915   696.984     0.150
    76.889   709.555     0.150
     0.992    33.062     0.150
     1.821    31.234     0.150
     2.794    78.430     0.150
     2.794    78.852     0.150
     5.245    72.688     0.150
     7.093    99.930     0.150
     7.378   107.438     0.150
     8.724   121.938     0.150
     8.633   121.109     0.150
     9.840   137.453     0.150
     9.903   136.000     0.150
    11.818   164.328     0.150
    12.803   178.219     0.150
    13.557   186.391     0.150
    16.862   228.617     0.150
    42.923  3244.164     0.150
    42.929  3244.602     0.150
    42.941  3245.422     0.150
    44.085  3334.953     0.150
    44.099  3333.500     0.150
    44.103  3337.312     0.150
    47.168   506.047     0.150
    47.622   513.125     0.150
    54.996   569.453     0.150
    56.274   578.000     0.150
    64.367   633.391     0.150
    65.218   638.453     0.150
    74.959   698.266     0.150
     0.312     6.484     0.150
     0.855    15.391     0.150
     2.629    77.328     0.150
     5.195    82.430     0.150
     7.073   100.281     0.150
    11.957   175.781     0.150
    16.177  1198.539     0.150
    16.177  1198.539     0.150
    24.292   314.898     0.150
    26.628   336.539     0.150
    33.273   395.781     0.150
    33.863   401.219     0.150
    33.863   396.797     0.150
    33.863   401.391     0.150
    37.893   433.219     0.150
    41.753   467.609     0.150
    42.970  3225.312     0.150
    42.976  3223.578     0.150
    42.988  3235.375     0.150
    44.134  3312.297     0.150
    44.147  3313.359     0.150
    44.151  3318.914     0.150
    46.643   509.797     0.150
    46.866   510.578     0.150
    50.687   535.750     0.150
    51.407  3855.883     0.150
    52.740    12.805     0.150
    53.906   560.797     0.150
    53.906   558.875     0.150
    53.906   560.820     0.150
    54.883   567.516     0.150
    58.219    13.000     0.150
    58.219    18.000     0.150
    64.289     8.000     0.150
    64.473   635.484     0.150
    64.839     9.000     0.150
    66.416   650.984     0.150
    66.416    10.602     0.150
    67.546   656.375     0.150
    68.895    10.305     0.150
    69.288     7.898     0.150
    70.026   667.328     0.150
    74.328  1311.188     0.150
    74.328  1557.188     0.150
    74.328  1851.188     0.150
    74.826   696.086     0.150
    75.173   705.289     0.150
    75.196   705.586     0.150
    75.269     9.602     0.150
    75.406   706.086     0.150
    75.406   700.289     0.150
    75.692   704.891     0.150
    75.687   702.891     0.150
    75.852   707.789     0.150
    76.006   709.008     0.150
    76.006   708.891     0.150
    76.247   711.188     0.150
    76.384   714.391     0.150
    76.455   711.234     0.150
    76.455   711.688     0.150
    76.528   713.484     0.150
    76.654   715.391     0.150
    76.696   713.688     0.150
    76.819   710.477     0.150
    77.306   717.391     0.150
    77.405   717.789     0.150
    77.436   717.062     0.150
    77.642   718.047     0.150
    77.815   717.992     0.150
    77.837   718.906     0.150
    77.888   719.492     0.150
    77.968   718.500     0.150
    78.012   719.281     0.150
    78.056   719.164     0.150
    78.176   718.555     0.150
    78.289   719.688     0.150
    78.741   723.656     0.150
    78.841   720.805     0.150
    78.992   725.133     0.150
    79.099   725.477     0.150
    79.143   725.797     0.150
    79.332   726.312     0.150
    79.556   728.633     0.150
    79.585   729.125     0.150
    79.596   729.648     0.150
    79.622   729.062     0.150
    79.627   729.094     0.150
    79.693   729.641     0.150
    79.735   729.609     0.150
    79.740   729.477     0.150
    79.784   730.812     0.150
    79.803   730.648     0.150
    79.828   730.164     0.150
    79.925   731.422     0.150
    79.984   729.195     0.150
    80.039   730.984     0.150
    80.091   731.406     0.150
    80.183   731.797     0.150
    80.194   732.148     0.150
    80.311   733.172     0.150
    80.346   731.805     0.150
    80.366   734.023     0.150
    80.389   733.703     0.150
    80.396   732.758     0.150
    80.894   736.180     0.150
    80.907   736.469     0.150
    81.458   738.062     0.150
    82.160   743.227     0.150
    82.163   742.781     0.150
    83.374   748.867     0.150
    83.880   748.953     0.150
    85.364   753.648     0.150
    90.871   771.203     0.150
   110.759  1110.188     0.150
     0.905    16.852     0.150
     2.745    44.875     0.150
     3.303    53.102     0.150
     3.804    57.883     0.150
     5.575    83.852     0.150
     6.525    97.023     0.150
     6.436    98.953     0.150
     8.110   118.656     0.150
    14.677   216.023     0.150
    14.738   209.047     0.150
    24.461   319.086     0.150
    35.214   418.586     0.150
    36.940   430.898     0.150
    42.961  3229.336     0.150
    42.967  3247.930     0.150
    42.979  3245.133     0.150
    44.124  3334.492     0.150
    44.138  3335.523     0.150
    44.142  3332.273     0.150
    46.897   511.164     0.150
    59.479   598.625     0.150
    64.334     5.797     0.150
    65.130   640.727     0.150
    66.464   650.852     0.150
    75.318   705.352     0.150
    75.318     3.305     0.150
   111.628  8378.828     0.150
   111.640  8380.039     0.150
     3.927    56.516     0.150
     5.938    89.727     0.150
    10.465   144.641     0.150
    14.912   210.844     0.150
    18.670   255.062     0.150
    42.821  3226.453     0.150
    42.827  3229.148     0.150
    42.839  3230.133     0.150
    43.982  3321.344     0.150
    43.995  3320.648     0.150
    44.000  3315.930     0.150
    66.469   647.797     0.150
     1.553    27.797     0.150
     4.968    75.461     0.150
    12.078   170.500     0.150
    43.037  3231.188     0.150
    43.043  3227.664     0.150
    43.055  3228.578     0.150
    44.200  3331.875     0.150
    44.214  3332.188     0.150
    44.218  3332.680     0.150
   111.608  8372.508     0.150
   111.619  8376.172     0.150
     1.721    50.349     0.150
     3.576    96.389     0.150
     4.887    73.819     0.150
     6.604    97.469     0.150
     8.556   123.869     0.150
    14.041   199.260     0.150
    24.909   322.512     0.150
    42.954  3226.818     0.150
    42.960  3224.131     0.150
    42.972  3225.013     0.150
    44.116  3314.150     0.150
    44.129  3320.995     0.150
    44.133  3320.885     0.150
    64.359   634.049     0.150
    65.116   639.223     0.150
     2.796    80.197     0.150
     2.875    81.597     0.150
     4.639    69.977     0.150
     4.936    75.387     0.150
     6.661    96.497     0.150
     6.666    94.537     0.150
     7.137   105.107     0.150
     8.603   125.187     0.150
     9.036   130.727     0.150
     9.234   133.647     0.150
    11.291   162.187     0.150
    14.172   205.097     0.150
    14.173   204.077     0.150
    18.990   259.077     0.150
    24.890   323.057     0.150
    24.890   323.407     0.150
    38.097   437.617     0.150
    42.892  3226.525     0.150
    42.898  3233.634     0.150
    42.910  3227.903     0.150
    44.054  3331.529     0.150
    44.068  3329.034     0.150
    44.072  3332.848     0.150
    55.020   571.207     0.150
    65.258   639.237     0.150
    74.496   695.567     0.150
    76.988   712.652     0.150
    16.174  1173.373     0.150
    16.174  1173.560     0.150
    42.856  3222.275     0.150
    42.862  3225.004     0.150
    42.874  3223.661     0.150
    44.018  3312.963     0.150
    44.031  3329.352     0.150
    44.035  3327.705     0.150
   111.551  8369.872     0.150
   111.563  8370.244     0.150
     1.159    20.152     0.150
     3.000    46.622     0.150
     3.860    57.222     0.150
     4.056    61.002     0.150
     4.210   109.532     0.150
     5.288    76.352     0.150
     8.084   116.062     0.150
     9.202   130.312     0.150
     9.975   140.812     0.150
    10.520   149.352     0.150
    10.697   151.462     0.150
    10.942   154.822     0.150
    11.651   163.862     0.150
    12.152   176.482     0.150
    12.312   298.617     0.150
    12.312   172.083     0.150
    13.981   194.333     0.150
    15.659   217.792     0.150
    16.082  1203.315     0.150
    16.082  1203.315     0.150
    18.919   257.672     0.150
    24.483   317.642     0.150
    24.972   322.442     0.150
    24.972   322.442     0.150
    26.495   335.802     0.150
    26.955   340.452     0.150
    27.024   339.302     0.150
    27.019   339.342     0.150
    27.244   342.392     0.150
    29.302   360.942     0.150
    29.302   360.952     0.150
    31.556   380.992     0.150
    32.345   388.672     0.150
    34.114   402.642     0.150
    34.114   402.612     0.150
    34.381   397.542     0.150
    36.294   418.177     0.150
    36.294   421.442     0.150
    38.057   436.672     0.150
    38.061   435.177     0.150
    38.586   441.922     0.150
    38.586   444.333     0.150
    38.857   444.042     0.150
    39.014   446.842     0.150
    40.762   460.333     0.150
    41.230   460.132     0.150
    42.889  3226.416     0.150
    42.894  3224.933     0.150
    42.906  3225.097     0.150
    42.902   477.892     0.150
    44.049  3312.240     0.150
    44.062  3312.608     0.150
    44.067  3318.894     0.150
    44.078   482.850     0.150
    44.078   486.442     0.150
    45.496   497.492     0.150
    45.497   497.912     0.150
    46.013   502.462     0.150
    46.887   509.802     0.150
    47.067   510.852     0.150
    47.078   510.833     0.150
    47.078   513.382     0.150
    47.078   512.522     0.150
    47.404   521.942     0.150
    47.557   512.312     0.150
    47.726   514.042     0.150
    48.471   521.072     0.150
    50.869   539.342     0.150
    50.869   539.122     0.150
    51.178  3850.288     0.150
    51.423   543.062     0.150
    51.883   547.322     0.150
    52.974     9.500     0.150
    56.165   577.192     0.150
    57.661   588.652     0.150
    58.458     6.200     0.150
    58.458     8.900     0.150
    61.619     8.500     0.150
    62.098   616.842     0.150
    63.938     8.000     0.150
    63.938  1146.642     0.150
    64.473   635.142     0.150
    64.569   635.612     0.150
    64.922   638.102     0.150
    65.055   636.442     0.150
    65.079     7.900     0.150
    66.698   650.742     0.150
    69.052   664.182     0.150
    69.418   821.642     0.150
    69.418   923.942     0.150
    69.418  1212.642     0.150
    69.418  1475.342     0.150
    69.454   667.042     0.150
    69.547     3.500     0.150
    69.547     7.200     0.150
    70.142  1487.242     0.150
    70.457   672.472     0.150
    70.610   673.182     0.150
    70.650   674.572     0.150
    70.790   675.122     0.150
    71.103   677.182     0.150
    71.396   940.442     0.150
    71.396  1517.442     0.150
    71.396   679.042     0.150
    71.396   679.042     0.150
    71.396   679.042     0.150
    71.396   698.602     0.150
    71.396   836.972     0.150
    71.396   940.462     0.150
    71.396  1234.552     0.150
    71.396  1328.382     0.150
    71.396  1517.522     0.150
    71.396  1708.102     0.150
    71.533   679.612     0.150
    71.478   679.752     0.150
    71.679   680.492     0.150
    72.357   688.442     0.150
    72.367   684.692     0.150
    72.469   685.472     0.150
    72.528   685.372     0.150
    73.364   690.042     0.150
    73.416   691.502     0.150
    73.943   692.742     0.150
    73.943   692.792     0.150
    74.592   697.042     0.150
    74.592   696.342     0.150
    74.592   708.342     0.150
    74.948   699.792     0.150
    74.954   699.892     0.150
    74.960   707.002     0.150
    75.049   699.942     0.150
    75.113   697.742     0.150
    75.113   700.382     0.150
    75.121   700.959     0.150
    75.121   700.492     0.150
    75.139   700.642     0.150
    75.466   703.042     0.150
    75.560     9.400     0.150
    75.675   705.142     0.150
    75.675   705.142     0.150
    75.972   705.242     0.150
    76.105   713.455     0.150
    76.123   708.442     0.150
    76.277   707.342     0.150
    76.277   708.442     0.150
    76.527   708.272     0.150
    76.603   708.742     0.150
    76.603   708.762     0.150
    76.661   710.242     0.150
    76.661   717.642     0.150
    76.724   710.242     0.150
    76.724   711.342     0.150
    76.928   720.342     0.150
    76.928   712.442     0.150
    76.928   720.242     0.150
    76.965   712.342     0.150
    77.084  1837.289     0.150
    77.084   711.592     0.150
    77.135   714.442     0.150
    77.135   714.442     0.150
    77.260   712.222     0.150
    77.538   716.942     0.150
    77.538   723.442     0.150
    77.577   714.162     0.150
    77.580   716.942     0.150
    77.580   716.942     0.150
    77.675   715.042     0.150
    77.722   716.063     0.150
    77.722   716.042     0.150
    78.083   716.617     0.150
    78.083     9.076     0.150
    78.163   717.942     0.150
    78.325   717.641     0.150
    78.383   720.126     0.150
    78.383   720.042     0.150
    78.450   720.245     0.150
    78.475     7.534     0.150
    78.550     7.388     0.150
    78.566     7.693     0.150
    78.733   720.417     0.150
    78.749   722.681     0.150
    78.940   723.795     0.150
    79.025   723.729     0.150
    79.152   724.042     0.150
    79.271   724.542     0.150
    79.304     7.493     0.150
    79.349   725.292     0.150
    79.453     8.323     0.150
    79.625   724.192     0.150
    79.698   726.142     0.150
    79.880   729.127     0.150
    80.087   728.842     0.150
    80.164   728.442     0.150
    80.284   731.638     0.150
    80.284   730.942     0.150
    80.348   730.112     0.150
    80.460   730.842     0.150
    80.565   731.542     0.150
    80.592   733.054     0.150
    80.634   732.346     0.150
    80.634   732.342     0.150
    80.648   733.060     0.150
    80.682   732.940     0.150
    80.682   732.842     0.150
    81.186   735.611     0.150
    81.261   734.372     0.150
    81.384   735.142     0.150
    81.664   736.092     0.150
    82.075   737.802     0.150
    83.647   748.194     0.150
    84.100   749.322     0.150
    85.704   757.583     0.150
    87.329   764.802     0.150
    96.228   805.642     0.150
    99.527   820.742     0.150
    99.527   820.712     0.150
    99.612   818.167     0.150
   111.430  8369.992     0.150
   111.442  8375.230     0.150
   144.069  1170.011     0.150
   154.091  1199.542     0.150
   156.043  1215.367     0.150
   158.561  1180.196     0.150
   159.289  1184.910     0.150
   159.343  1187.126     0.150
   159.890  1194.342     0.150
     1.047    30.011     0.150
     1.047    19.341     0.150
     2.668    69.511     0.150
     3.739    94.611     0.150
     4.518   114.411     0.150
     4.518    66.171     0.150
     4.915    72.051     0.150
     5.617    81.371     0.150
     6.326    91.921     0.150
    15.149   215.071     0.150
    43.013  3247.471     0.150
    43.019  3248.604     0.150
    43.031  3249.736     0.150
    44.175  3334.656     0.150
    44.188  3335.881     0.150
    44.192  3336.058     0.150
   144.214  1168.518     0.150
     0.400    17.973     0.150
     1.044    18.533     0.150
     1.691    27.992     0.150
     2.434    38.014     0.150
     2.626    71.393     0.150
     2.785    42.473     0.150
     2.880    43.893     0.150
     2.960    44.844     0.150
     2.979    45.113     0.150
     2.993    45.674     0.150
     3.600    53.203     0.150
     3.698    54.572     0.150
     3.721    55.123     0.150
     3.725    55.133     0.150
     4.071    58.912     0.150
     4.071    59.184     0.150
     4.169    60.463     0.150
     4.222    61.213     0.150
     4.987    71.902     0.150
     5.069    72.854     0.150
     5.195    75.213     0.150
     8.595   125.523     0.150
     8.903   126.293     0.150
     8.988   125.973     0.150
     9.092   128.393     0.150
     9.669   135.803     0.150
     9.868   139.184     0.150
     9.930   139.514     0.150
    10.576   152.014     0.150
    10.576   151.963     0.150
    11.089   159.633     0.150
    13.930   193.523     0.150
    16.061   218.963     0.150
    16.061  1213.236     0.150
    16.062   219.764     0.150
    16.062  1214.695     0.150
    24.439   533.812     0.150
    24.439   314.973     0.150
    29.313   360.713     0.150
    32.129   553.074     0.150
    32.499   387.383     0.150
    34.120   404.264     0.150
    36.322   419.213     0.150
    36.615   423.773     0.150
    36.615   425.252     0.150
    36.808   424.662     0.150
    38.045   435.023     0.150
    40.785   458.113     0.150
    40.785   458.094     0.150
    41.089   449.412     0.150
    41.382   581.781     0.150
    41.382   465.152     0.150
    41.564   466.143     0.150
    86.933   467.562     0.150
    41.679   475.273     0.150
    41.890   467.332     0.150
    42.658   474.912     0.150
    42.922   480.113     0.150
    42.976  3223.623     0.150
    42.981  3224.324     0.150
    42.994  3225.986     0.150
    44.137  3312.189     0.150
    44.151  3312.857     0.150
    44.155  3313.227     0.150
    45.126   491.514     0.150
    46.007   500.424     0.150
    46.642   513.492     0.150
    46.760   506.623     0.150
    46.760   506.594     0.150
    46.956   509.033     0.150
    47.081   601.014     0.150
    47.081   509.693     0.150
    47.291   510.014     0.150
    47.291   509.863     0.150
    47.939   925.514     0.150
    48.095   515.523     0.150
    48.475   520.203     0.150
    50.847   537.533     0.150
    51.181   540.613     0.150
    51.395   541.723     0.150
    51.758   545.332     0.150
    51.758   545.363     0.150
    51.758   545.252     0.150
    53.602   561.014     0.150
    54.052   562.432     0.150
    55.076   629.293     0.150
    55.076   629.312     0.150
    55.076   568.953     0.150
    58.256   591.713     0.150
    58.404   600.113     0.150
    58.404     4.500     0.150
    58.404     7.000     0.150
    59.626   601.014     0.150
    60.748   609.312     0.150
    60.748   609.252     0.150
    63.268   627.213     0.150
    63.894     5.701     0.150
    64.469   632.014     0.150
    64.657   635.412     0.150
    66.376   645.482     0.150
    66.613     8.600     0.150
    66.613   919.312     0.150
    67.353   651.902     0.150
    69.480  1212.312     0.150
    70.016  1221.312     0.150
    70.365   671.354     0.150
    71.268   676.303     0.150
    71.268   676.303     0.150
    71.268   676.303     0.150
    71.268   695.633     0.150
    71.268   860.184     0.150
    71.268   914.293     0.150
    71.268  1232.533     0.150
    71.268  1471.703     0.150
    71.268  1632.332     0.150
    72.232   674.912     0.150
    73.111   683.014     0.150
    73.240   685.912     0.150
    73.780   693.232     0.150
    73.842   692.014     0.150
    74.170   694.893     0.150
    74.463   695.713     0.150
    74.463   968.713     0.150
    74.463  2302.713     0.150
    74.833   697.434     0.150
    74.986   698.312     0.150
    74.993   698.113     0.150
    74.993   698.123     0.150
    75.310   701.312     0.150
    75.380   702.213     0.150
    75.380   702.213     0.150
    75.380   701.973     0.150
    75.546   703.213     0.150
    75.602   701.992     0.150
    75.849   704.912     0.150
    75.849   704.912     0.150
    76.148   706.014     0.150
    76.148   705.982     0.150
    76.148   705.912     0.150
    76.533   708.312     0.150
    76.596   708.713     0.150
    76.596   708.873     0.150
    76.664   709.713     0.150
    76.799   710.613     0.150
    76.955   710.963     0.150
    76.955   710.213     0.150
    77.006   711.312     0.150
    77.121   712.113     0.150
    77.132   711.184     0.150
    77.451   713.912     0.150
    77.470   714.412     0.150
    77.547   714.912     0.150
    77.547   714.973     0.150
    78.034   715.693     0.150
    78.034   715.402     0.150
    78.255   716.344     0.150
    78.674   718.988     0.150
    78.701   720.822     0.150
    78.783   721.713     0.150
    78.971   723.062     0.150
    79.324   723.924     0.150
    79.941   726.713     0.150
    79.959   727.312     0.150
    80.189   725.676     0.150
    80.254   725.014     0.150
    80.254  1024.014     0.150
    80.254  1649.213     0.150
    80.349   725.445     0.150
    80.349   725.412     0.150
    80.437   721.975     0.150
    80.437   722.014     0.150
    80.520   719.256     0.150
    80.539   727.828     0.150
    80.539   727.812     0.150
    80.555   726.908     0.150
    80.555   726.912     0.150
    80.859   725.354     0.150
    81.170   733.773     0.150
    81.625   735.213     0.150
    81.625   734.383     0.150
    81.978   736.764     0.150
    83.976   748.543     0.150
    85.574   757.162     0.150
    86.720   755.223     0.150
    87.417   763.854     0.150
    99.411   820.752     0.150
   111.485  8380.318     0.150
   111.497  8380.189     0.150
   144.198  1168.008     0.150
     0.941    17.424     0.150
     0.941    30.674     0.150
     2.721    40.523     0.150
     9.061   223.713     0.150
    42.978  3243.443     0.150
    42.984  3242.715     0.150
    42.996  3243.309     0.150
    44.141  3331.150     0.150
    44.154  3332.195     0.150
    44.158  3332.332     0.150
    47.160   515.188     0.150
   144.280  1167.932     0.150
    12.359   299.014     0.150
    42.821  3227.541     0.150
    42.827  3236.160     0.150
    42.839  3229.396     0.150
    43.982  3333.199     0.150
    43.995  3336.012     0.150
    44.000  3330.965     0.150
     2.816    42.297     0.150
     4.868    73.078     0.150
     5.719    81.566     0.150
     5.865    84.258     0.150
    12.313   173.066     0.150
    42.862  3227.996     0.150
    42.868  3226.625     0.150
    42.880  3226.477     0.150
    44.023  3318.816     0.150
    44.037  3311.754     0.150
    44.041  3320.125     0.150
     2.886    44.414     0.150
     3.477    52.367     0.150
     3.504    93.086     0.150
     4.783    69.027     0.150
     9.902   138.527     0.150
    34.402   403.867     0.150
    34.529   404.195     0.150
    36.259   419.914     0.150
    42.713   476.465     0.150
    42.749  3229.305     0.150
    42.755  3229.691     0.150
    42.767  3227.457     0.150
    43.910  3314.180     0.150
    43.923  3331.309     0.150
    43.928  3311.027     0.150
    45.456   494.695     0.150
    52.102   545.527     0.150
    52.904   620.367     0.150
    58.390     6.000     0.150
    58.390     8.598     0.150
    64.591   634.805     0.150
    65.013   640.566     0.150
    65.013     8.500     0.150
    65.413   640.094     0.150
    69.494     3.199     0.150
    69.494     7.699     0.150
    75.155   698.965     0.150
    75.179   699.895     0.150
    75.187   699.938     0.150
   111.496  8379.031     0.150
   111.508  8375.652     0.150
   111.513  8375.461     0.150
   143.990  1167.586     0.150
     1.001    18.418     0.150
     3.698    55.707     0.150
    10.515   148.879     0.150
    16.087  1200.555     0.150
    16.087  1200.469     0.150
    26.522   338.199     0.150
    26.966   338.598     0.150
    32.165   382.816     0.150
    32.251   385.648     0.150
    34.364   403.566     0.150
    34.405   403.840     0.150
    36.832   424.508     0.150
    36.855   424.508     0.150
    40.821   461.938     0.150
    42.975  3226.512     0.150
    42.981  3226.953     0.150
    42.993  3230.848     0.150
    44.137  3328.707     0.150
    44.151  3313.480     0.150
    44.155  3329.945     0.150
    46.935   510.078     0.150
    47.038   507.137     0.150
    48.674   521.879     0.150
    51.266  3852.180     0.150
    52.882     8.801     0.150
    64.983     8.301     0.150
    66.569   649.379     0.150
    66.569     8.699     0.150
    74.432   696.277     0.150
    74.949   698.539     0.150
    77.418   714.180     0.150
    77.514   715.078     0.150
    77.985   717.199     0.150
    78.277   718.996     0.150
    78.391   719.895     0.150
    78.574   720.762     0.150
    78.670   721.551     0.150
    79.143   723.859     0.150
    79.293   724.062     0.150
    79.293   724.438     0.150
    81.585   734.809     0.150
    83.954   749.254     0.150
   144.232  1169.570     0.150
     0.345    11.805     0.150
     0.949    28.004     0.150
     2.715    40.727     0.150
     5.185    74.605     0.150
     9.925   139.227     0.150
    16.110  1190.586     0.150
    16.110  1190.398     0.150
    24.494   317.586     0.150
    29.380   361.133     0.150
    42.705   476.285     0.150
    42.837   465.605     0.150
    42.982  3243.492     0.150
    42.988  3243.934     0.150
    43.000  3244.598     0.150
    44.144  3338.402     0.150
    44.158  3340.008     0.150
    44.162  3317.422     0.150
    44.408   486.273     0.150
    46.904   508.234     0.150
    47.797   512.523     0.150
    51.310  3850.562     0.150
    64.373   632.863     0.150
    74.878   697.305     0.150
    76.331   704.766     0.150
    77.880   719.453     0.150
    78.236   723.145     0.150
    79.101   724.215     0.150
    79.251   724.211     0.150
    79.251   722.273     0.150
    80.003   726.273     0.150
    81.544   733.035     0.150
   111.572  8372.766     0.150
   111.584  8374.066     0.150
   144.275  1169.500     0.150
     2.689    40.746     0.150
     2.825    79.594     0.150
     4.035    60.566     0.150
     4.609    67.223     0.150
     4.654    67.605     0.150
     4.804    69.945     0.150
     5.151    73.953     0.150
     5.533    79.074     0.150
     5.506    79.125     0.150
     6.208    89.383     0.150
     6.993    99.703     0.150
    12.115   302.398     0.150
    34.449   404.195     0.150
    36.694   423.336     0.150
    37.740   432.773     0.150
    42.668   475.395     0.150
    43.013  3222.992     0.150
    43.019  3223.441     0.150
    43.031  3234.785     0.150
    44.175  3317.496     0.150
    44.189  3319.699     0.150
    44.193  3320.047     0.150
    45.546   500.293     0.150
    49.779   531.395     0.150
    50.746   536.664     0.150
    51.316  3853.305     0.150
    65.144   638.406     0.150
    69.377   667.895     0.150
    69.377     3.500     0.150
    69.377     7.301     0.150
    74.079   702.293     0.150
    74.354   695.895     0.150
    74.868   698.055     0.150
    75.350   702.496     0.150
    75.350     8.000     0.150
    75.435   710.996     0.150
    75.722   712.496     0.150
    75.883   709.895     0.150
    76.036   713.094     0.150
    76.274   715.496     0.150
    76.484   716.094     0.150
    76.555   716.395     0.150
    76.726   717.496     0.150
    76.957   719.793     0.150
    79.215   723.949     0.150
    79.215     8.340     0.150
    80.226   726.918     0.150
   111.580  8398.121     0.150
   111.591  8376.211     0.150
   111.597  8381.215     0.150
   144.311  1169.289     0.150
   144.670  1174.094     0.150
     1.776    28.520     0.150
     2.673    40.133     0.150
     2.834    42.762     0.150
     2.920    43.770     0.150
     3.446    50.672     0.150
     4.598    66.723     0.150
     4.803    69.680     0.150
    25.021   325.812     0.150
    26.461   334.359     0.150
    42.934  3228.398     0.150
    42.940  3226.234     0.150
    42.952  3229.656     0.150
    44.095  3315.707     0.150
    44.108  3311.961     0.150
    44.112  3313.090     0.150
    64.739   636.410     0.150
    65.268   640.441     0.150
    66.470   650.727     0.150
    66.470   648.172     0.150
    85.635   757.410     0.150
     2.330    37.172     0.150
     2.310    70.812     0.150
     2.563    40.242     0.150
     2.753    80.156     0.150
     5.298   164.680     0.150
     6.740    97.070     0.150
     9.458   137.609     0.150
    42.869  3237.125     0.150
    42.875  3238.219     0.150
    42.887  3245.453     0.150
    44.032  3335.602     0.150
    44.045  3324.617     0.150
    44.049  3336.492     0.150
    54.977   570.461     0.150
    59.556   600.438     0.150
    65.230   638.867     0.150
    69.379     3.398     0.150
    69.379     7.398     0.150
    75.391     4.500     0.150
     0.741    13.607     0.150
     6.627    95.588     0.150
     9.964   141.059     0.150
    24.974   323.818     0.150
    38.202   439.094     0.150
    42.698  3234.053     0.150
    42.704  3229.039     0.150
    42.716  3239.330     0.150
    43.858  3329.088     0.150
    43.871  3327.750     0.150
    43.875  3327.342     0.150
     1.654    28.021     0.150
    25.022   319.391     0.150
    32.178   395.750     0.150
    34.455   413.451     0.150
    42.933  3227.055     0.150
    42.939  3230.047     0.150
    42.951  3229.422     0.150
    44.095  3319.357     0.150
    44.109  3320.465     0.150
    44.113  3320.586     0.150
    47.131   518.975     0.150
    50.798   541.566     0.150
    81.578   739.699     0.150
     1.616    28.121     0.150
     6.325    90.861     0.150
    34.527   409.236     0.150
    42.863  3229.521     0.150
    42.868  3229.008     0.150
    42.881  3229.908     0.150
    44.025  3328.732     0.150
    44.038  3316.459     0.150
    44.042  3318.484     0.150
    92.836   791.689     0.150
   144.167  1169.621     0.150
     3.752    56.156     0.150
     4.531   120.727     0.150
     8.351   121.398     0.150
    12.234   298.594     0.150
    42.906  3225.750     0.150
    42.911  3235.941     0.150
    42.923  3225.617     0.150
    44.068  3313.188     0.150
    44.081  3314.656     0.150
    44.085  3313.660     0.150
   111.574  8373.562     0.150
   111.585  8372.582     0.150
     1.859    54.062     0.150
     3.982    59.863     0.150
     4.082   110.043     0.150
     4.686    67.844     0.150
    16.154  1204.457     0.150
    16.154  1206.871     0.150
    42.845  3230.309     0.150
    42.851  3230.363     0.150
    42.863  3227.184     0.150
    44.007  3320.379     0.150
    44.020  3313.941     0.150
    44.024  3314.160     0.150
    65.219   640.137     0.150
    66.403   648.520     0.150
   144.091  1168.699     0.150
     0.512    18.927     0.150
     6.080    87.647     0.150
    42.851  3229.803     0.150
    42.857  3230.252     0.150
    42.869  3231.161     0.150
    44.013  3324.793     0.150
    44.026  3314.864     0.150
    44.030  3329.297     0.150
     1.904    55.326     0.150
    24.992   323.662     0.150
    42.854  3228.166     0.150
    42.860  3233.803     0.150
    42.872  3241.947     0.150
    44.014  3321.875     0.150
    44.028  3320.158     0.150
    44.032  3323.158     0.150
    50.863   542.271     0.150
    55.156   571.582     0.150
    64.555   635.854     0.150
    64.700   639.055     0.150
    65.301   641.262     0.150
    66.488   647.832     0.150
    75.148   701.881     0.150
    81.663   741.188     0.150
    85.692   759.287     0.150
     0.267     6.406     0.150
     0.905    16.898     0.150
     1.586    27.926     0.150
     2.646    40.285     0.150
     3.706    55.195     0.150
     5.108    74.156     0.150
     8.979   126.277     0.150
     8.992   132.406     0.150
    16.063  1200.910     0.150
    16.063  1199.816     0.150
    16.746   417.582     0.150
    18.376   252.137     0.150
    24.403   320.105     0.150
    24.403   316.129     0.150
    26.514   334.926     0.150
    34.152   402.676     0.150
    34.419   404.535     0.150
    41.434   464.398     0.150
    42.629   477.008     0.150
    43.058  3235.719     0.150
    43.064  3236.047     0.150
    43.076  3236.953     0.150
    44.221  3329.496     0.150
    44.234  3333.020     0.150
    44.238  3333.230     0.150
    45.466   496.195     0.150
    51.304  3849.793     0.150
    64.339   634.148     0.150
    64.940   635.105     0.150
    66.498   650.309     0.150
    68.777   659.656     0.150
    70.241   671.945     0.150
    74.793   696.379     0.150
    74.836   697.168     0.150
    74.904   699.117     0.150
    75.343   705.508     0.150
    76.470   708.945     0.150
    76.808   710.059     0.150
    76.857   712.906     0.150
    77.303   713.707     0.150
    77.399   714.605     0.150
    77.634   713.422     0.150
    77.997   715.141     0.150
    78.048   715.441     0.150
    78.575   718.359     0.150
    78.701   722.156     0.150
    80.200   729.707     0.150
    81.850   737.168     0.150
    83.841   747.688     0.150
    84.264   749.285     0.150
    84.946   753.676     0.150
    85.426   756.605     0.150
    85.432   755.227     0.150
    86.004   759.797     0.150
    86.666   768.000     0.150
    86.666   768.527     0.150
    93.017   793.590     0.150
    96.364   808.703     0.150
   111.570  8375.066     0.150
   111.582  8373.012     0.150
   144.346  1169.652     0.150
   153.816  1198.980     0.150
     0.646    13.973     0.150
     0.657    14.145     0.150
     1.798    31.504     0.150
    16.159  1204.996     0.150
    16.159  1200.414     0.150
    34.478   404.805     0.150
    42.769  3245.285     0.150
    42.775  3241.621     0.150
    42.787  3242.523     0.150
    43.929  3339.961     0.150
    43.942  3335.562     0.150
    43.947  3339.207     0.150
    45.440   500.148     0.150
    51.190  3860.676     0.150
    64.901   648.844     0.150
    66.620   649.504     0.150
    75.216   702.168     0.150
   111.435  8383.820     0.150
   111.447  8387.168     0.150
   143.959  1174.988     0.150
     2.803    76.053     0.150
     7.401   108.123     0.150
    42.750  3221.584     0.150
    42.756  3228.674     0.150
    42.768  3229.650     0.150
    43.909  3336.912     0.150
    43.923  3332.844     0.150
    43.927  3339.439     0.150
    64.680   636.336     0.150
   111.393  8376.307     0.150
   111.404  8377.826     0.150
   143.905  1175.287     0.150
     1.093    19.865     0.150
     1.959    30.266     0.150
     2.925    42.805     0.150
    12.307   299.066     0.150
    14.268   199.465     0.150
    24.916   316.510     0.150
    42.861  3229.193     0.150
    42.867  3232.377     0.150
    42.879  3235.777     0.150
    44.023  3330.238     0.150
    44.036  3322.236     0.150
    44.040  3331.094     0.150
     1.837    30.711     0.150
     2.745    45.910     0.150
     5.941    86.281     0.150
     6.534    99.242     0.150
     7.738   113.730     0.150
     7.939   117.172     0.150
    10.151   142.320     0.150
    32.170   385.793     0.150
    42.971  3245.020     0.150
    42.977  3243.395     0.150
    42.989  3246.113     0.150
    44.133  3331.375     0.150
    44.146  3332.492     0.150
    44.151  3332.766     0.150
    75.419   707.742     0.150
   111.531  8372.508     0.150
   111.542  8374.059     0.150
   144.231  1171.262     0.150
     2.579    70.969     0.150
     2.676    41.008     0.150
     2.786    42.211     0.150
     2.786    77.809     0.150
     4.007    60.441     0.150
     4.635    67.461     0.150
     5.669    81.461     0.150
    11.942   164.848     0.150
    12.726   174.918     0.150
    16.126  1205.922     0.150
    24.924   325.996     0.150
    25.431   321.910     0.150
    26.007   325.699     0.150
    32.515   385.391     0.150
    33.704   394.258     0.150
    34.464   400.520     0.150
    42.896  3226.266     0.150
    42.902  3225.633     0.150
    42.914  3224.316     0.150
    44.058  3309.457     0.150
    44.071  3311.344     0.150
    44.075  3312.094     0.150
    55.059   573.676     0.150
    64.715   637.469     0.150
    65.184   641.168     0.150
    81.588   739.168     0.150
    84.046   752.570     0.150
   111.512  8376.359     0.150
   111.524  8376.262     0.150
     0.897    17.180     0.150
     2.453    40.828     0.150
     2.747    79.953     0.150
     3.820    59.719     0.150
     5.502    79.852     0.150
     8.908   128.539     0.150
     8.879   134.125     0.150
    10.428   154.820     0.150
    15.214   217.031     0.150
    15.502   220.859     0.150
    42.947  3238.820     0.150
    42.953  3239.289     0.150
    42.965  3240.172     0.150
    44.110  3324.945     0.150
    44.124  3325.141     0.150
    44.128  3327.555     0.150
    75.305   705.820     0.150
    75.305     8.398     0.150
    76.861   712.086     0.150
    81.471   736.398     0.150
   144.301  1170.742     0.150
     0.951    17.547     0.150
     1.629    27.914     0.150
     1.628    28.141     0.150
     2.653    40.375     0.150
     4.081    61.250     0.150
     7.852   111.508     0.150
     9.005   127.406     0.150
     9.005   127.406     0.150
     9.783   137.125     0.150
     9.864   138.055     0.150
    10.552   149.445     0.150
    10.730   149.938     0.150
    10.797   150.477     0.150
    11.194   155.805     0.150
    11.566   161.102     0.150
    11.854   165.367     0.150
    13.894   192.539     0.150
    16.051  1200.906     0.150
    16.051   221.070     0.150
    16.051  1200.914     0.150
    16.749   416.906     0.150
    26.495   334.234     0.150
    26.794   338.805     0.150
    26.954   337.781     0.150
    27.435   343.656     0.150
    31.105   375.664     0.150
    32.367   388.008     0.150
    32.367   386.406     0.150
    32.578   394.508     0.150
    36.142     4.797     0.150
    36.142   497.406     0.150
    36.142   921.305     0.150
    36.142   417.141     0.150
    36.142   563.664     0.150
    36.647   423.070     0.150
    38.028   433.859     0.150
    38.580   440.391     0.150
    38.580   440.500     0.150
    40.809   458.117     0.150
    41.036   465.211     0.150
    42.652   473.781     0.150
    42.670   471.797     0.150
    43.043  3243.234     0.150
    43.049  3244.812     0.150
    43.061  3234.891     0.150
    44.017   484.070     0.150
    44.205  3335.750     0.150
    44.219  3332.312     0.150
    44.223  3333.547     0.150
    45.487   494.969     0.150
    45.487   496.734     0.150
    45.486   496.305     0.150
    46.007   500.609     0.150
    46.858   507.852     0.150
    47.196   509.156     0.150
    47.745   514.250     0.150
    47.903    11.000     0.150
    48.485   519.484     0.150
    48.598   520.195     0.150
    49.174   524.906     0.150
    50.824   537.148     0.150
    51.270  3852.867     0.150
    51.378   541.031     0.150
    51.378   541.375     0.150
    51.658   543.734     0.150
    51.867   545.617     0.150
    51.867   545.539     0.150
    53.330   552.305     0.150
    53.798   558.656     0.150
    54.030   560.375     0.150
    54.678   565.867     0.150
    54.678   565.578     0.150
    55.540   571.711     0.150
    56.190   576.859     0.150
    57.833   582.711     0.150
    57.833   634.305     0.150
    61.062   608.406     0.150
    63.164   625.414     0.150
    63.514   628.805     0.150
    64.384   632.570     0.150
    64.552   634.109     0.150
    64.872   636.070     0.150
    64.975    12.797     0.150
    65.850   642.609     0.150
    65.850   642.609     0.150
    66.405   645.398     0.150
    66.540    15.898     0.150
    66.540   915.109     0.150
    68.824   660.398     0.150
    69.188   682.211     0.150
    69.277   664.250     0.150
    69.912   926.406     0.150
    70.285   670.516     0.150
    70.438   670.414     0.150
    70.477   671.695     0.150
    70.617   672.328     0.150
    70.831   673.758     0.150
    70.929   674.320     0.150
    70.994   674.688     0.150
    71.163   936.805     0.150
    71.163   675.789     0.150
    71.163   675.789     0.150
    71.163   675.789     0.150
    71.163   695.555     0.150
    71.163   833.414     0.150
    71.163   936.805     0.150
    71.163  1230.664     0.150
    71.163  1277.250     0.150
    71.163  1505.406     0.150
    71.163  1704.906     0.150
    71.356   676.891     0.150
    71.301   676.961     0.150
    71.503   677.867     0.150
    71.802   678.086     0.150
    72.193   681.695     0.150
    72.296   683.297     0.150
    72.351   683.039     0.150
    72.557   684.406     0.150
    72.757   685.867     0.150
    73.756   690.797     0.150
    73.756   690.961     0.150
    74.050   693.984     0.150
    74.331   692.508     0.150
    74.358   694.695     0.150
    74.358   694.406     0.150
    74.358   709.008     0.150
    74.358   864.008     0.150
    74.402   695.125     0.150
    74.760   696.945     0.150
    74.767   697.047     0.150
    74.835   698.070     0.150
    74.888   697.406     0.150
    74.888   697.117     0.150
    74.928   697.008     0.150
    74.946   698.617     0.150
    75.078   699.414     0.150
    75.196   699.711     0.150
    75.205   700.258     0.150
    75.232   699.805     0.150
    75.275   700.305     0.150
    75.403   701.305     0.150
    75.403   701.320     0.150
    75.387    15.203     0.150
    75.441   701.766     0.150
    75.625   701.656     0.150
    75.625   701.609     0.150
    75.625   701.695     0.150
    75.728   702.805     0.150
    75.744   703.008     0.150
    75.992   704.414     0.150
    76.043   704.258     0.150
    76.344   706.188     0.150
    76.427   706.805     0.150
    76.471   706.766     0.150
    76.490   707.609     0.150
    76.481   694.508     0.150
    76.481   707.281     0.150
    76.559   708.406     0.150
    76.694   709.211     0.150
    76.732   709.047     0.150
    76.902   709.508     0.150
    76.901   709.609     0.150
    77.028   709.859     0.150
    77.441   713.305     0.150
    77.490   711.805     0.150
    77.549   714.117     0.150
    77.929   715.305     0.150
    77.999   716.672     0.150
    78.020   716.805     0.150
    78.150   715.711     0.150
    78.317   716.008     0.150
    78.516   718.406     0.150
    78.596   719.969     0.150
    78.650   718.805     0.150
    78.883   721.609     0.150
    79.037   720.711     0.150
    79.115   722.266     0.150
    79.835   725.508     0.150
    79.854   725.211     0.150
    80.060   727.219     0.150
    80.226   727.508     0.150
    80.244   728.609     0.150
    80.331   728.211     0.150
    80.402   728.211     0.150
    80.434   729.305     0.150
    80.450   728.805     0.150
    80.732   728.211     0.150
    80.876  1026.906     0.150
    81.091   732.039     0.150
    81.298   732.328     0.150
    81.588   734.805     0.150
    81.895   735.281     0.150
    81.895   735.375     0.150
    82.634   739.914     0.150
    84.163   748.836     0.150
    84.660   751.680     0.150
    84.824   751.547     0.150
    84.874   752.758     0.150
    84.990   752.438     0.150
    85.429   755.008     0.150
    85.478   754.852     0.150
    85.727   756.211     0.150
    86.807   761.320     0.150
    86.931   769.609     0.150
    88.604   769.367     0.150
    99.314   818.727     0.150
   144.303  1169.203     0.150
     0.971    17.906     0.150
     2.466    69.180     0.150
     3.778    55.672     0.150
     3.778    94.562     0.150
     4.033    60.406     0.150
     4.551    65.891     0.150
    16.098  1195.633     0.150
    18.465   251.641     0.150
    42.981  3243.031     0.150
    42.987  3244.008     0.150
    42.999  3244.758     0.150
    44.143  3330.977     0.150
    44.157  3332.875     0.150
    44.161  3337.023     0.150
    47.134   512.180     0.150
    55.006   568.141     0.150
    76.899   709.977     0.150
   111.552  8370.836     0.150
   111.563  8372.211     0.150
   144.257  1168.633     0.150
     2.852    42.695     0.150
     3.928    57.875     0.150
    42.821  3227.283     0.150
    42.827  3227.352     0.150
    42.839  3227.189     0.150
    43.982  3315.703     0.150
    43.995  3316.186     0.150
    43.999  3318.754     0.150
    64.548   635.584     0.150
    66.453   648.203     0.150
     4.024    61.211     0.150
    12.340   174.641     0.150
    43.059  3228.500     0.150
    43.065  3249.164     0.150
    43.077  3229.910     0.150
    44.223  3335.957     0.150
    44.236  3337.469     0.150
    44.240  3341.164     0.150
     0.483    14.945     0.150
     0.433    17.227     0.150
     3.221    50.707     0.150
     6.474    94.746     0.150
    18.302   246.703     0.150
    54.430   559.879     0.150
    55.780   569.246     0.150
    63.915   626.527     0.150
    84.962   749.285     0.150
   144.695  1168.902     0.150
     3.992    60.203     0.150
    42.814  3225.547     0.150
    42.820  3226.148     0.150
    42.832  3227.656     0.150
    43.974  3308.742     0.150
    43.988  3317.191     0.150
    43.992  3312.410     0.150
     5.305    73.590     0.150
    42.862  3232.102     0.150
    42.868  3229.645     0.150
    42.880  3234.855     0.150
    47.206   508.375     0.150
   111.590  8373.516     0.150
   111.602  8372.508     0.150
   111.607  8347.148     0.150
     0.472    11.125     0.150
     0.472    18.246     0.150
     0.483    10.715     0.150
     2.337    39.855     0.150
     2.827    43.246     0.150
    16.177  1204.520     0.150
    16.177  1204.605     0.150
    42.859  3228.238     0.150
    42.865  3234.895     0.150
    42.877  3244.535     0.150
    44.021  3339.543     0.150
    44.035  3336.410     0.150
    44.039  3340.785     0.150
    45.387   501.277     0.150
   111.559  8375.082     0.150
   111.571  8376.371     0.150
     1.651    28.742     0.150
     1.757    30.125     0.150
     2.494    40.914     0.150
     3.839   101.008     0.150
    12.242   303.820     0.150
    18.544   253.453     0.150
    34.471   404.156     0.150
    42.912  3240.883     0.150
    42.918  3241.344     0.150
    42.930  3245.609     0.150
    44.074  3329.773     0.150
    44.088  3336.414     0.150
    44.092  3332.375     0.150
    81.568   733.695     0.150
     0.198     9.556     0.150
     0.860    16.326     0.150
     1.520    26.356     0.150
     5.048    72.366     0.150
     9.516   133.796     0.150
    18.308   249.946     0.150
    43.118  3244.360     0.150
    43.123  3245.134     0.150
    43.135  3246.015     0.150
    44.281  3335.909     0.150
    44.294  3335.364     0.150
    44.298  3336.729     0.150
    47.111   506.425     0.150
     1.564    27.916     0.150
     1.687    29.166     0.150
     3.841   105.166     0.150
     3.841    58.055     0.150
     5.244    78.486     0.150
     7.724   110.125     0.150
     8.843   125.555     0.150
    20.774   277.896     0.150
    27.053   341.766     0.150
    32.256   384.875     0.150
    32.933   391.996     0.150
    34.520   405.465     0.150
    36.286   420.766     0.150
    39.164   447.016     0.150
    39.164   447.066     0.150
    42.922  3231.447     0.150
    42.928  3231.969     0.150
    42.940  3247.490     0.150
    44.085  3330.906     0.150
    44.098  3334.354     0.150
    44.102  3332.719     0.150
    45.373   495.076     0.150
    47.636   515.477     0.150
    52.793    10.699     0.150
    52.793    12.699     0.150
    64.354   633.375     0.150
    64.351     9.000     0.150
    64.894     9.801     0.150
    65.171   638.416     0.150
    69.351     3.199     0.150
    69.351     7.699     0.150
    72.154   683.385     0.150
    75.676   702.205     0.150
    76.618   709.516     0.150
    76.745   708.865     0.150
    77.528   707.535     0.150
    78.656   721.176     0.150
    78.833   710.543     0.150
    79.084   712.721     0.150
    79.424   719.297     0.150
    79.623   722.039     0.150
    79.833   722.904     0.150
    79.921   726.143     0.150
   111.615  8371.086     0.150
   111.627  8372.590     0.150
   144.253  1169.984     0.150
   153.891  1198.816     0.150
     1.094    22.316     0.150
     1.610    27.668     0.150
     1.907    35.359     0.150
     1.907    60.848     0.150
     2.033    36.988     0.150
     2.033    63.727     0.150
     2.108    37.957     0.150
     2.108    66.258     0.150
     2.258    39.559     0.150
     2.258    69.340     0.150
     2.388    42.199     0.150
     2.388    72.969     0.150
     2.477    43.348     0.150
     2.477    75.090     0.150
     2.484    76.047     0.150
     2.505    43.770     0.150
     2.505    75.387     0.150
     3.151    52.328     0.150
     3.151    90.930     0.150
     3.151    52.438     0.150
     3.262    54.109     0.150
     3.295    56.090     0.150
     3.643    58.629     0.150
     3.643   103.129     0.150
     3.643    58.449     0.150
     3.996   107.027     0.150
     3.996    59.848     0.150
     3.869    62.109     0.150
     4.486    65.137     0.150
     4.715    73.918     0.150
     5.338    78.168     0.150
     5.609    83.066     0.150
     5.826    89.316     0.150
     8.487   125.289     0.150
     8.571   126.027     0.150
     8.571   125.969     0.150
     9.086   128.848     0.150
    10.111   262.328     0.150
    10.389   151.090     0.150
    11.349   161.477     0.150
    11.931   170.328     0.150
    12.112   171.809     0.150
    13.056   185.488     0.150
    14.266   201.430     0.150
    18.451   249.828     0.150
    20.587   279.129     0.150
    23.903   314.027     0.150
    32.679   393.180     0.150
    35.617   413.000     0.150
    37.514   431.969     0.150
    42.838  3252.035     0.150
    42.844  3246.215     0.150
    42.856  3250.199     0.150
    44.005  3321.512     0.150
    44.019  3322.051     0.150
    44.023  3322.051     0.150
    46.801   506.469     0.150
    46.761   505.840     0.150
    48.471   517.777     0.150
    52.335     6.199     0.150
    54.141   562.590     0.150
    57.814  1068.129     0.150
    59.051   594.348     0.150
    63.898   629.590     0.150
    63.883    16.699     0.150
    64.349   631.629     0.150
    64.433   632.629     0.150
    64.433     9.199     0.150
    64.433    15.699     0.150
    72.263   683.039     0.150
    74.154   691.930     0.150
    74.238   692.227     0.150
    74.587   694.738     0.150
    74.750   696.039     0.150
    74.871   697.988     0.150
    75.202   699.590     0.150
    75.218   699.887     0.150
    75.531   700.027     0.150
    76.001   703.898     0.150
    76.266   704.734     0.150
    76.266   705.227     0.150
    76.498   706.277     0.150
    76.509   706.578     0.150
    76.644   708.289     0.150
    76.691   708.930     0.150
    76.861   707.809     0.150
    77.876   713.336     0.150
    78.301   717.090     0.150
    78.393   718.289     0.150
    78.883   719.141     0.150
    79.102   720.762     0.150
    79.369   722.473     0.150
    79.514   723.484     0.150
    79.572   722.723     0.150
    79.599   723.305     0.150
    79.973   725.988     0.150
    80.058   727.137     0.150
    80.143   726.207     0.150
    83.952   747.418     0.150
    85.655   754.953     0.150
    98.897   817.590     0.150
   112.076  8390.164     0.150
   112.088  8391.688     0.150
   112.093  8387.883     0.150
     0.765    16.480     0.150
     2.459    42.613     0.150
     2.575    44.172     0.150
     3.530    56.340     0.150
     5.499   137.711     0.150
    12.549   307.441     0.150
    24.988   325.918     0.150
    42.687  3238.211     0.150
    42.693  3233.387     0.150
    42.705  3234.812     0.150
    43.846  3320.715     0.150
    43.859  3319.426     0.150
    43.864  3327.316     0.150
    50.849   544.242     0.150
    64.745   639.668     0.150
    65.020   641.793     0.150
    65.438   644.340     0.150
    66.033   648.738     0.150
    66.596   653.371     0.150
    66.596   651.121     0.150
    66.805   650.492     0.150
    69.282   670.016     0.150
    75.335   705.512     0.150
    81.676   741.891     0.150
     0.503    11.006     0.150
     1.821    31.617     0.150
     2.390    39.486     0.150
     4.626    66.486     0.150
     4.688    69.787     0.150
     5.844    84.727     0.150
     6.716    96.457     0.150
    12.919   179.947     0.150
    12.904   179.617     0.150
    36.355   421.236     0.150
    42.834  3227.729     0.150
    42.840  3228.186     0.150
    42.852  3229.086     0.150
    43.996  3313.383     0.150
    44.009  3314.881     0.150
    44.013  3314.906     0.150
    64.462   636.486     0.150
    64.571   636.492     0.150
    69.023   665.469     0.150
    75.053   700.842     0.150
    81.541   737.525     0.150
    84.090   752.061     0.150
    84.090   750.977     0.150
   144.117  1170.900     0.150
     1.567    25.988     0.150
     1.693    28.418     0.150
     1.700    28.430     0.150
     1.741    28.031     0.150
     1.749    28.949     0.150
     1.811    30.410     0.150
     2.436    38.969     0.150
     2.535    39.941     0.150
     2.535    70.891     0.150
     2.554    40.328     0.150
     2.850    78.449     0.150
     2.903    43.359     0.150
     2.924    44.508     0.150
     2.959    45.500     0.150
     5.416    77.949     0.150
    10.449   147.988     0.150
    31.834   381.988     0.150
    34.473   404.820     0.150
    36.332   422.809     0.150
    39.208   445.102     0.150
    42.764  3230.539     0.150
    42.770  3234.891     0.150
    42.782  3240.805     0.150
    43.033   478.500     0.150
    43.924  3328.312     0.150
    43.937  3329.297     0.150
    43.942  3318.227     0.150
    48.520   519.660     0.150
    53.379   561.930     0.150
    64.563   636.430     0.150
    64.563     6.801     0.150
    65.085     5.801     0.150
    73.716   693.969     0.150
    74.039   693.719     0.150
    75.166   700.230     0.150
    75.238   700.441     0.150
    75.256   700.828     0.150
    75.275   700.730     0.150
    75.292   700.828     0.150
    75.296   700.828     0.150
    75.329   700.930     0.150
    75.347   701.031     0.150
    75.510   701.871     0.150
    77.052   713.430     0.150
    77.801   717.730     0.150
     0.756    15.750     0.150
     0.767    23.734     0.150
     3.975    61.172     0.150
     8.921   130.250     0.150
    11.152   156.852     0.150
    12.314   172.891     0.150
    13.485   188.812     0.150
    24.983   325.602     0.150
    33.295   395.078     0.150
    34.490   405.938     0.150
    34.490   405.320     0.150
    42.691  3238.109     0.150
    42.697  3237.320     0.150
    42.709  3239.750     0.150
    43.850  3320.969     0.150
    43.864  3321.023     0.150
    43.868  3328.297     0.150
    45.437   503.289     0.150
    47.310   515.328     0.150
    55.213   573.492     0.150
    64.811   639.000     0.150
    65.011   640.430     0.150
    65.428   643.258     0.150
    66.587   650.398     0.150
    75.325   703.031     0.150
    81.670   742.188     0.150
   143.849  1171.102     0.150
     0.878    16.602     0.150
     3.546    55.359     0.150
    32.224   389.586     0.150
    43.029  3238.703     0.150
    43.035  3239.148     0.150
    43.047  3233.859     0.150
    44.192  3337.180     0.150
    44.206  3336.930     0.150
    44.210  3330.156     0.150
    47.167   515.227     0.150
    65.002   635.477     0.150
    65.075   636.523     0.150
   111.612  8376.906     0.150
   111.624  8376.648     0.150
   144.353  1170.469     0.150
    42.901  3232.658     0.150
    42.907  3233.105     0.150
    42.919  3231.861     0.150
    44.064  3326.952     0.150
    44.078  3331.838     0.150
    44.082  3332.097     0.150
    12.146   162.572     0.150
    18.452   249.948     0.150
    47.158   519.863     0.150
     2.871    42.359     0.150
     1.504    26.820     0.150
     1.647    28.812     0.150
     1.614    28.438     0.150
     2.513    39.570     0.150
     2.519    39.227     0.150
     4.057    64.047     0.150
     4.516    65.227     0.150
     5.171    73.867     0.150
     5.535    79.891     0.150
    10.528   153.352     0.150
    43.015  3240.539     0.150
    43.021  3240.969     0.150
    43.033  3241.789     0.150
    44.178  3333.102     0.150
    44.191  3336.008     0.150
    44.195  3330.891     0.150
    66.294   646.578     0.150
     2.104    33.979     0.150
     2.716    78.438     0.150
     2.991    44.719     0.150
     3.862    59.318     0.150
     9.384   133.539     0.150
    24.837   322.463     0.150
    42.685  3224.840     0.150
    42.690  3225.418     0.150
    42.702  3225.979     0.150
    43.846  3312.826     0.150
    43.859  3313.244     0.150
    43.863  3311.717     0.150
    66.414   647.969     0.150
    73.908   694.289     0.150
     3.992    60.766     0.150
    42.755  3249.543     0.150
    42.761  3243.586     0.150
    42.773  3229.668     0.150
     1.552    46.098     0.150
     3.834    56.641     0.150
     4.946    72.289     0.150
     5.250    75.738     0.150
     9.143   128.699     0.150
    16.113  1191.082     0.150
    16.113  1190.031     0.150
    28.901   354.379     0.150
    29.149   356.871     0.150
    29.785   361.191     0.150
    30.424   367.508     0.150
    31.313   376.441     0.150
    32.273   384.129     0.150
    34.343   401.969     0.150
    37.837   433.008     0.150
    38.062   433.961     0.150
    38.002   434.121     0.150
    42.920  3233.895     0.150
    42.926  3241.977     0.150
    42.938  3248.293     0.150
    44.082  3329.551     0.150
    44.095  3330.512     0.150
    44.099  3335.406     0.150
    53.653   557.500     0.150
    55.896   575.379     0.150
    56.323   578.938     0.150
    64.690   636.219     0.150
    75.010   699.715     0.150
    75.457   703.020     0.150
    76.988   711.289     0.150
    84.020   749.688     0.150
     1.384    23.547     0.150
     1.462    25.348     0.150
     1.478    25.557     0.150
     1.485    26.168     0.150
     1.588    26.357     0.150
     1.588    26.688     0.150
     2.491    39.898     0.150
     2.491    40.098     0.150
     3.561    58.537     0.150
     5.155    74.227     0.150
     5.938    86.258     0.150
     8.633   121.277     0.150
     8.961   135.137     0.150
     8.961   126.268     0.150
     9.029   126.467     0.150
     9.897   138.518     0.150
    10.463   148.807     0.150
    10.510   155.137     0.150
    10.510   149.537     0.150
    10.510   153.777     0.150
    11.956   166.467     0.150
    11.956   166.297     0.150
    12.120   372.100     0.150
    16.787   417.738     0.150
    24.409   315.748     0.150
    24.389   574.338     0.150
    24.389   638.037     0.150
    25.367   325.047     0.150
    27.928   349.127     0.150
    30.327   368.367     0.150
    33.945   399.418     0.150
    34.173   404.457     0.150
    34.271   734.137     0.150
    35.501   419.137     0.150
    36.110   496.238     0.150
    36.110   927.338     0.150
    36.110   417.648     0.150
    36.256   762.938     0.150
    36.838   426.348     0.150
    40.851   460.697     0.150
    41.338   462.707     0.150
    41.438   465.188     0.150
    41.484   464.998     0.150
    43.011  3232.781     0.150
    43.017  3222.689     0.150
    43.029  3231.139     0.150
    44.174  3317.480     0.150
    44.187  3336.203     0.150
    44.191  3322.273     0.150
    45.052   495.938     0.150
    45.444   496.557     0.150
    46.665   505.627     0.150
    46.873   508.508     0.150
    46.873   508.477     0.150
    47.177   509.668     0.150
    47.766   515.027     0.150
    47.863     9.000     0.150
    48.121   516.068     0.150
    50.831   536.938     0.150
    50.783   537.408     0.150
    51.419   541.787     0.150
    51.826   550.137     0.150
    52.838     6.699     0.150
    52.838     8.199     0.150
    54.980   568.537     0.150
    54.980   629.938     0.150
    54.980   568.518     0.150
    55.488   576.438     0.150
    55.929   574.688     0.150
    56.188   577.047     0.150
    56.839   584.738     0.150
    57.424   586.867     0.150
    57.828  1082.338     0.150
    58.260   592.338     0.150
    58.318   594.738     0.150
    58.318     6.000     0.150
    58.318     8.699     0.150
    58.950   596.447     0.150
    59.179   602.938     0.150
    59.339   599.738     0.150
    61.056   608.637     0.150
    63.473     9.301     0.150
    63.813     9.000     0.150
    64.243   632.738     0.150
    64.358   632.957     0.150
    64.555   634.137     0.150
    64.723   636.438     0.150
    64.723   636.467     0.150
    64.937   636.238     0.150
    64.937    10.500     0.150
    64.937    15.199     0.150
    65.057   637.357     0.150
    65.152   637.797     0.150
    65.390   640.338     0.150
    65.854   643.188     0.150
    66.509   648.938     0.150
    66.995   650.988     0.150
    68.834   662.838     0.150
    69.250   665.137     0.150
    69.250   665.207     0.150
    69.385     4.000     0.150
    69.385     7.301     0.150
    69.904   671.938     0.150
    69.904   680.238     0.150
    69.904   684.738     0.150
    70.257   671.217     0.150
    70.410   671.537     0.150
    70.410   671.578     0.150
    70.448   672.738     0.150
    70.448   672.818     0.150
    70.589   673.637     0.150
    70.589   673.678     0.150
    70.805   674.738     0.150
    70.805   674.818     0.150
    70.901   675.438     0.150
    70.901   675.508     0.150
    71.159   673.438     0.150
    71.329   677.938     0.150
    71.329   677.947     0.150
    71.274   678.137     0.150
    71.274   678.227     0.150
    71.475   678.938     0.150
    71.475   678.977     0.150
    71.800   678.117     0.150
    72.730   687.438     0.150
    72.730   687.588     0.150
    73.635   691.738     0.150
    73.635   691.828     0.150
    73.730   692.627     0.150
    73.730   691.328     0.150
    74.025   695.107     0.150
    74.361   698.738     0.150
    74.361   695.043     0.150
    74.361   695.037     0.150
    74.361   712.938     0.150
    74.556   694.498     0.150
    74.742   698.238     0.150
    74.742   698.287     0.150
    74.884   697.637     0.150
    74.957   707.037     0.150
    75.197   699.438     0.150
    75.208   700.438     0.150
    75.233   700.438     0.150
    75.277   700.537     0.150
    75.406   701.438     0.150
    75.443   702.137     0.150
    75.625   701.438     0.150
    75.729   703.037     0.150
    75.746   703.438     0.150
    75.877   704.977     0.150
    75.993   704.238     0.150
    76.044   705.238     0.150
    76.044   703.838     0.150
    76.195   706.238     0.150
    76.445   702.238     0.150
    76.445  1284.938     0.150
    76.459   714.738     0.150
    76.562   708.338     0.150
    76.694   710.037     0.150
    76.900   710.537     0.150
    76.904   709.738     0.150
    77.023   710.359     0.150
    77.346   712.738     0.150
    77.364   713.137     0.150
    77.443   714.037     0.150
    77.684   721.238     0.150
    77.684   721.738     0.150
    78.021   716.838     0.150
    78.138   717.738     0.150
    78.147   716.938     0.150
    79.035   721.637     0.150
    79.096   722.938     0.150
    79.646   725.938     0.150
    79.683  1320.438     0.150
    80.139   720.037     0.150
    80.139  1843.438     0.150
    80.201  1383.738     0.150
    80.241   729.037     0.150
    80.344   727.537     0.150
    80.445   729.238     0.150
    80.866  1857.738     0.150
    80.855   733.617     0.150
    80.944   731.938     0.150
    81.065   733.232     0.150
    81.065   731.938     0.150
    81.055   734.707     0.150
    81.062   734.008     0.150
    81.258   738.537     0.150
    81.258   737.037     0.150
    81.258   737.137     0.150
    81.258   740.637     0.150
    81.868   736.287     0.150
    82.593   747.438     0.150
    82.668   739.838     0.150
    83.890   942.463     0.150
    83.890   747.898     0.150
    83.942   747.867     0.150
    84.134   757.238     0.150
    84.607   752.617     0.150
    84.793   751.738     0.150
    85.208   753.838     0.150
    86.888   768.238     0.150
    86.888   767.938     0.150
    86.924   768.838     0.150
    86.931   764.488     0.150
    87.452   773.562     0.150
    87.452   772.137     0.150
    87.452   771.738     0.150
    87.452   765.037     0.150
    90.920   788.631     0.150
    90.920   787.238     0.150
    92.960   796.738     0.150
    94.397   802.137     0.150
    94.397   801.537     0.150
    95.967   811.363     0.150
    95.967   810.838     0.150
    96.275   814.137     0.150
   101.232   834.762     0.150
   111.573  8374.197     0.150
   111.584  8371.699     0.150
   111.589  8393.057     0.150
   121.452  1736.213     0.150
   144.678  1173.018     0.150
   149.886  1184.557     0.150
     1.031    36.252     0.150
     1.514    26.820     0.150
     2.808    70.852     0.150
     2.808    41.541     0.150
     3.876    56.650     0.150
     4.574    66.031     0.150
    42.880  3222.611     0.150
    42.886  3223.271     0.150
    42.898  3224.010     0.150
    44.042  3314.281     0.150
    44.055  3313.922     0.150
    44.059  3315.672     0.150
   111.560  8371.596     0.150
   111.571  8374.258     0.150
     1.588    28.039     0.150
     1.590    26.988     0.150
     1.590    27.689     0.150
     4.680    68.059     0.150
     5.155    74.453     0.150
    12.103   367.410     0.150
    32.234   389.410     0.150
    43.010  3250.098     0.150
    43.016  3248.965     0.150
    43.028  3244.188     0.150
    44.173  3314.102     0.150
    44.186  3333.727     0.150
    44.191  3315.441     0.150
    47.177   514.258     0.150
    47.177   507.832     0.150
    66.461   649.934     0.150
   144.339  1174.176     0.150
     4.557    66.634     0.150
     8.850   125.794     0.150
    42.974  3250.650     0.150
    42.980  3243.101     0.150
    42.992  3243.703     0.150
    44.136  3334.303     0.150
    44.150  3333.623     0.150
    44.154  3335.598     0.150
    64.401   635.484     0.150
   144.249  1170.503     0.150
     0.379     7.514     0.150
     0.942    17.623     0.150
     1.443    42.594     0.150
     1.680    28.924     0.150
     2.488    40.312     0.150
     3.490    53.354     0.150
     4.673    67.732     0.150
     5.237    74.914     0.150
    11.522   160.033     0.150
    14.712   208.562     0.150
    36.940   428.982     0.150
    42.929  3225.424     0.150
    42.935  3225.406     0.150
    42.947  3237.086     0.150
    44.092  3330.088     0.150
    44.106  3331.105     0.150
    44.110  3331.424     0.150
    64.352     6.000     0.150
    75.346   702.414     0.150
    75.346     8.199     0.150
    81.498   736.148     0.150
   144.258  1168.232     0.150
     1.037    18.199     0.150
     1.760    50.199     0.150
     2.541    64.529     0.150
     2.541    37.590     0.150
     2.541    64.760     0.150
     2.673    41.721     0.150
     3.612    90.430     0.150
     4.391   109.529     0.150
     5.853    84.420     0.150
     8.939   125.170     0.150
    10.435   144.910     0.150
    10.520   147.330     0.150
    10.689   150.330     0.150
    10.689   150.369     0.150
    12.051   292.016     0.150
    24.568   564.330     0.150
    24.837   319.250     0.150
    25.816   326.029     0.150
    26.466   331.590     0.150
    27.437   341.439     0.150
    27.749   344.170     0.150
    29.187   358.900     0.150
    29.434   359.609     0.150
    30.967   372.830     0.150
    31.398   377.090     0.150
    31.706   380.420     0.150
    32.227   384.980     0.150
    33.991   401.029     0.150
    34.054   399.131     0.150
    34.054   399.041     0.150
    34.448   736.830     0.150
    36.256   417.330     0.150
    36.256   498.330     0.150
    36.480   420.619     0.150
    36.510   422.320     0.150
    36.659   423.221     0.150
    41.254   461.869     0.150
    41.162   467.230     0.150
    41.424   463.240     0.150
    42.665   472.779     0.150
    43.141  3241.984     0.150
    43.146  3247.014     0.150
    43.159  3243.338     0.150
    44.302  3327.377     0.150
    44.315  3333.152     0.150
    44.320  3330.312     0.150
    45.627   496.590     0.150
    45.626   496.410     0.150
    46.642   503.330     0.150
    46.821   505.221     0.150
    46.775   505.830     0.150
    48.345   516.711     0.150
    51.046   537.869     0.150
    50.963   537.619     0.150
    51.243   538.500     0.150
    52.770   549.891     0.150
    53.007     5.000     0.150
    53.041   549.029     0.150
    55.951   573.131     0.150
    55.951   573.689     0.150
    57.860   583.430     0.150
    57.891    12.500     0.150
    58.352    10.801     0.150
    58.485     4.500     0.150
    58.485     7.000     0.150
    63.652     6.801     0.150
    63.986     6.500     0.150
    64.306   630.529     0.150
    64.306   630.471     0.150
    64.553   632.330     0.150
    64.856   634.740     0.150
    65.105     7.801     0.150
    66.398   779.561     0.150
    66.985   649.330     0.150
    67.270   649.369     0.150
    68.802   661.430     0.150
    69.377   663.471     0.150
    69.543     3.699     0.150
    69.543     7.199     0.150
    69.948   924.529     0.150
    69.948  1206.330     0.150
    70.541   669.660     0.150
    70.578   671.029     0.150
    70.719   671.740     0.150
    70.925   672.949     0.150
    71.031   673.641     0.150
    71.187   934.430     0.150
    71.187   673.930     0.150
    71.187   673.930     0.150
    71.187   673.930     0.150
    71.187   693.721     0.150
    71.187   831.510     0.150
    71.187   934.510     0.150
    71.187  1228.750     0.150
    71.187  1504.971     0.150
    71.187  1703.949     0.150
    71.456   676.211     0.150
    71.401   676.270     0.150
    71.602   677.090     0.150
    72.398   682.811     0.150
    73.673   690.551     0.150
    73.753   689.869     0.150
    73.847   689.830     0.150
    73.847   690.301     0.150
    74.141   693.340     0.150
    74.359   693.131     0.150
    74.883   695.830     0.150
    74.859   696.320     0.150
    74.915   700.930     0.150
    75.201   698.631     0.150
    75.209   698.930     0.150
    75.209   698.881     0.150
    75.222   697.820     0.150
    75.238   698.730     0.150
    75.281   699.131     0.150
    75.403   700.029     0.150
    75.735   701.830     0.150
    75.735   701.920     0.150
    75.747   701.131     0.150
    76.002   703.740     0.150
    76.051   704.430     0.150
    76.051   703.020     0.150
    76.195   704.170     0.150
    76.599   705.990     0.150
    76.705   708.230     0.150
    76.905   708.131     0.150
    76.917   708.830     0.150
    77.019   708.570     0.150
    77.356   711.230     0.150
    77.377   711.430     0.150
    77.449   712.131     0.150
    77.516   710.930     0.150
    77.622   716.430     0.150
    77.622   716.430     0.150
    77.941   716.430     0.150
    78.171   721.131     0.150
    78.520   717.939     0.150
    78.597   718.689     0.150
    79.054   720.631     0.150
    79.116   720.029     0.150
    79.222   721.590     0.150
    79.633   722.930     0.150
    79.669   723.133     0.150
    79.859   724.529     0.150
    79.878   723.730     0.150
    80.241   725.830     0.150
    80.267   726.631     0.150
    80.352   727.131     0.150
    80.429   727.029     0.150
    80.435   727.033     0.150
    80.476   728.230     0.150
    81.071   730.717     0.150
    81.071   730.930     0.150
    81.071   731.240     0.150
    81.178   731.930     0.150
    81.194   732.070     0.150
    81.318   730.939     0.150
    81.441   738.900     0.150
    81.723   734.990     0.150
    83.667   745.330     0.150
    85.473   755.029     0.150
    85.777   753.340     0.150
   144.290  1167.574     0.150
    12.097   293.410     0.150
    31.389   375.266     0.150
    43.013  3238.699     0.150
    43.018  3239.156     0.150
    43.031  3239.395     0.150
    44.176  3336.020     0.150
    44.189  3336.676     0.150
    44.193  3335.867     0.150
    47.184   515.438     0.150
    54.924   568.277     0.150
     1.479    26.152     0.150
     1.847    29.664     0.150
     2.331    38.621     0.150
     2.777    41.742     0.150
     2.777    70.613     0.150
     3.842    56.383     0.150
     5.250   128.688     0.150
    15.261   220.574     0.150
    15.544   212.863     0.150
    15.609   214.922     0.150
    24.864   324.816     0.150
    42.917  3227.918     0.150
    42.923  3228.414     0.150
    42.935  3225.742     0.150
    44.080  3324.453     0.150
    44.093  3317.965     0.150
    44.097  3318.523     0.150
    47.184   515.469     0.150
     3.835    96.627     0.150
    14.219   194.848     0.150
    42.920  3225.693     0.150
    42.926  3222.314     0.150
    42.938  3227.055     0.150
    44.082  3312.566     0.150
    44.096  3313.842     0.150
    44.100  3312.793     0.150
    64.426   632.098     0.150
    64.426     2.898     0.150
    66.567   649.896     0.150
    66.567    10.801     0.150
    84.003   750.098     0.150
   111.543  8375.014     0.150
   111.555  8376.008     0.150
     0.322     8.578     0.150
     1.462    26.000     0.150
     1.643    28.805     0.150
     5.182    75.406     0.150
    16.815   230.555     0.150
    33.940   401.180     0.150
    39.469   447.359     0.150
    42.984  3228.227     0.150
    42.990  3230.773     0.150
    43.002  3231.688     0.150
    44.147  3315.727     0.150
    44.160  3319.531     0.150
    44.165  3319.500     0.150
    64.370     5.898     0.150
    64.919     6.500     0.150
    69.369     3.195     0.150
    69.369     7.297     0.150
     1.077    20.727     0.150
     0.947    35.055     0.150
     1.212    21.820     0.150
     1.420    24.938     0.150
     1.462    25.734     0.150
     2.071    36.336     0.150
     2.071    64.555     0.150
     3.957    60.195     0.150
    26.459   336.148     0.150
    30.094   368.680     0.150
    30.460   371.359     0.150
    36.986   430.078     0.150
    64.628   646.141     0.150
    64.628     3.195     0.150
    69.602     3.102     0.150
    69.602     7.102     0.150
   145.165  1174.680     0.150
     2.459    71.055     0.150
     3.363    92.355     0.150
     4.608    67.575     0.150
     4.777    71.055     0.150
     4.831    72.105     0.150
     5.213   133.535     0.150
     5.213   151.104     0.150
     5.213    72.755     0.150
     6.422    94.105     0.150
     6.794    99.295     0.150
     7.131   102.155     0.150
    11.672   164.885     0.150
    14.715   200.896     0.150
    20.255   278.355     0.150
    20.460   276.146     0.150
    25.139   317.173     0.150
    25.794   317.425     0.150
    27.326   331.476     0.150
    27.926   350.212     0.150
    31.524   367.755     0.150
    32.828   392.917     0.150
    34.593   403.146     0.150
    35.273   397.135     0.150
    35.489   398.325     0.150
    46.378   500.995     0.150
    47.383   507.785     0.150
    52.337    12.500     0.150
    52.819   545.985     0.150
    54.458   562.655     0.150
    58.991   592.745     0.150
    63.323    12.899     0.150
    63.869    16.400     0.150
    63.944   626.462     0.150
    74.476   692.541     0.150
    74.476   692.485     0.150
    76.605   706.186     0.150
    77.529    15.171     0.150
    77.560   710.625     0.150
    77.659   710.785     0.150
    77.740    16.105     0.150
    77.754   712.283     0.150
    77.880   714.280     0.150
    77.880    16.298     0.150
    77.886    17.033     0.150
    77.916    17.080     0.150
    78.010    16.955     0.150
    78.180    17.331     0.150
    78.391   714.801     0.150
    78.549   717.525     0.150
    78.553    16.061     0.150
    78.726    16.856     0.150
    78.879    17.030     0.150
    78.879   717.545     0.150
    80.021   725.217     0.150
    80.570   727.354     0.150
   149.826  1186.896     0.150
   156.731  1194.795     0.150
     0.454    10.938     0.150
     1.523    26.918     0.150
     1.524    26.418     0.150
     1.524    28.926     0.150
     1.528    26.957     0.150
     1.604    28.148     0.150
     1.793    31.879     0.150
     1.793    52.398     0.150
     2.671    42.148     0.150
    18.573   257.809     0.150
     5.409    78.783     0.150
     7.832   114.254     0.150
    12.091   303.174     0.150
    34.483   404.623     0.150
    43.016  3251.322     0.150
    43.022  3252.559     0.150
    43.034  3248.447     0.150
    44.179  3336.916     0.150
    44.193  3336.199     0.150
    44.197  3337.773     0.150
    64.247   634.523     0.150
     0.612    24.754     0.150
     1.186    21.406     0.150
     2.479    39.535     0.150
     2.725    42.934     0.150
     2.798    43.645     0.150
     2.798    76.926     0.150
     2.873    44.176     0.150
     2.905    43.445     0.150
     3.491    91.414     0.150
     3.518    53.254     0.150
     3.597    54.105     0.150
     3.615    54.574     0.150
     3.615    94.645     0.150
     3.950    57.824     0.150
     3.982    57.734     0.150
     4.038    60.293     0.150
     4.052    60.004     0.150
     4.106    60.855     0.150
     4.175    61.863     0.150
     4.661    68.793     0.150
     4.765    68.434     0.150
     4.938    71.812     0.150
     5.000    72.973     0.150
     5.408   175.680     0.150
     5.408    76.645     0.150
     5.408    77.676     0.150
     8.775   124.594     0.150
     9.315   131.723     0.150
     9.733   138.234     0.150
    10.089   143.086     0.150
    10.412   146.895     0.150
    10.412   148.543     0.150
    12.256   175.625     0.150
    18.716   460.559     0.150
    18.716   256.363     0.150
    24.915   321.453     0.150
    27.061   341.633     0.150
    27.141   340.926     0.150
    32.171   386.184     0.150
    32.711   391.375     0.150
    34.209   404.703     0.150
    34.167   402.234     0.150
    36.260   423.734     0.150
    36.262     2.500     0.150
    36.262   499.434     0.150
    36.262   419.895     0.150
    36.662   423.926     0.150
    36.938   427.004     0.150
    38.711   441.555     0.150
    40.847   459.812     0.150
    41.469   464.965     0.150
    42.767  3234.551     0.150
    42.773  3231.277     0.150
    42.785  3224.688     0.150
    42.983   478.285     0.150
    43.928  3330.078     0.150
    43.941  3304.410     0.150
    43.946  3317.684     0.150
    45.086   496.633     0.150
    45.399   496.523     0.150
    46.973   509.383     0.150
    47.157   510.965     0.150
    47.178   510.953     0.150
    47.317   509.711     0.150
    47.500   515.734     0.150
    47.837   515.234     0.150
    48.233   517.312     0.150
    48.865   532.836     0.150
    49.624   538.355     0.150
    50.783   538.246     0.150
    51.535   542.723     0.150
    51.949   549.535     0.150
    52.912     5.598     0.150
    52.912     6.801     0.150
    53.709   560.016     0.150
    54.763   567.723     0.150
    54.763   566.234     0.150
    55.101   569.934     0.150
    55.557   575.336     0.150
    56.228   577.336     0.150
    56.488   578.926     0.150
    58.227   591.734     0.150
    61.547     9.098     0.150
    63.496   630.535     0.150
    63.870     6.898     0.150
    64.496     8.602     0.150
    64.581   635.133     0.150
    64.903   637.656     0.150
    65.020   639.934     0.150
    65.020     7.402     0.150
    65.020   666.336     0.150
    65.312   641.836     0.150
    66.424   650.035     0.150
    66.563   647.004     0.150
    66.670     9.102     0.150
    68.534   669.844     0.150
    68.967   672.965     0.150
    69.441   666.426     0.150
    69.500     3.699     0.150
    69.500     7.602     0.150
    69.500  1203.133     0.150
    70.191   924.336     0.150
    70.191  1223.035     0.150
    70.593   672.746     0.150
    70.635   674.203     0.150
    70.774   674.793     0.150
    71.008   676.176     0.150
    71.087   676.766     0.150
    71.455   940.535     0.150
    71.455   679.023     0.150
    71.455   679.023     0.150
    71.455   679.023     0.150
    71.455   698.293     0.150
    71.455   837.312     0.150
    71.455   940.625     0.150
    71.455  1238.254     0.150
    71.455  1283.844     0.150
    71.455  1513.926     0.150
    71.455  1713.246     0.150
    71.519   679.355     0.150
    71.464   679.426     0.150
    71.665   680.246     0.150
    72.061  1515.133     0.150
    72.926   688.035     0.150
    72.926   688.195     0.150
    73.553   692.035     0.150
    73.938   692.613     0.150
    74.135   696.734     0.150
    74.667   705.035     0.150
    74.667   697.336     0.150
    74.667   697.535     0.150
    74.667   969.234     0.150
    74.667  1947.234     0.150
    74.667  2307.234     0.150
    74.944   699.562     0.150
    74.949   699.543     0.150
    74.983   698.965     0.150
    75.170   699.734     0.150
    75.178   699.516     0.150
    75.460   703.281     0.150
    75.502   703.035     0.150
    75.532   703.832     0.150
    75.532   703.723     0.150
    75.544     7.898     0.150
    75.747   711.836     0.150
    75.747   705.035     0.150
    75.813   706.262     0.150
    76.033   706.336     0.150
    76.183   716.188     0.150
    76.194   705.133     0.150
    76.297   708.043     0.150
    76.348   706.945     0.150
    76.629   710.023     0.150
    76.796   710.688     0.150
    76.796   710.594     0.150
    76.996   712.535     0.150
    77.159   712.836     0.150
    77.200   713.434     0.150
    77.210   722.434     0.150
    77.210   722.434     0.150
    77.455   711.836     0.150
    77.330   714.824     0.150
    77.342   713.113     0.150
    77.401   712.211     0.150
    77.511   715.594     0.150
    77.649   715.234     0.150
    77.747   716.336     0.150
    77.780   715.109     0.150
    77.983   716.242     0.150
    78.231   717.555     0.150
    78.350   716.930     0.150
    78.397   717.289     0.150
    78.445   719.480     0.150
    78.488   718.055     0.150
    78.812   720.254     0.150
    78.906   720.484     0.150
    78.925   721.266     0.150
    79.335   724.508     0.150
    79.335   724.445     0.150
    79.378   723.172     0.150
    79.528   724.855     0.150
    80.128   728.559     0.150
    80.147   728.977     0.150
    80.321   730.039     0.150
    80.402   724.934     0.150
    80.402  1327.234     0.150
    80.402  1648.734     0.150
    80.402  1848.633     0.150
    80.506   730.734     0.150
    80.526   730.574     0.150
    80.538   731.305     0.150
    80.626   731.566     0.150
    80.690   731.562     0.150
    80.732   732.000     0.150
    81.243   734.156     0.150
    81.302   737.133     0.150
    81.302   732.633     0.150
    81.302   732.594     0.150
    81.302   738.934     0.150
    81.302   732.844     0.150
    81.329   736.914     0.150
    81.441   735.551     0.150
    81.591   736.234     0.150
    81.600   745.805     0.150
    81.909   740.105     0.150
    82.064   737.516     0.150
    82.786   744.273     0.150
    83.646   749.426     0.150
    83.751   749.223     0.150
    83.917   756.535     0.150
    84.868   755.094     0.150
    86.385   759.453     0.150
    86.385   759.395     0.150
    86.267   758.875     0.150
    87.208   763.234     0.150
    87.208   762.535     0.150
    87.208   762.543     0.150
    87.208   763.246     0.150
    87.356   764.273     0.150
    89.922   779.336     0.150
    92.695   787.223     0.150
    92.765   788.133     0.150
    92.765   788.473     0.150
    94.391   804.734     0.150
    96.106   803.586     0.150
   111.489  8391.684     0.150
   111.501  8387.246     0.150
   144.001  1168.152     0.150
   150.544  1188.766     0.150
     2.197    35.852     0.150
     2.350    64.303     0.150
     2.358    68.361     0.150
     4.056    61.201     0.150
     6.601    95.322     0.150
     6.803    96.533     0.150
     6.931    98.951     0.150
    32.157   393.459     0.150
    42.690  3239.443     0.150
    42.696  3233.381     0.150
    42.708  3228.713     0.150
    43.850  3315.592     0.150
    43.863  3314.268     0.150
    43.867  3323.271     0.150
    47.132   518.213     0.150
    47.132   510.330     0.150
    56.355   580.533     0.150
    69.255   668.033     0.150
    72.617   688.873     0.150
    81.641   741.232     0.150
   111.424  8395.584     0.150
   111.436  8399.463     0.150
     1.415    25.426     0.150
     1.544    26.977     0.150
     3.541    55.398     0.150
     3.688    57.738     0.150
     4.129    63.168     0.150
     4.214    63.746     0.150
     4.271    65.117     0.150
     5.341    79.609     0.150
     5.445    77.758     0.150
     5.547    80.078     0.150
     5.773    82.148     0.150
     6.093    89.836     0.150
     6.433    90.676     0.150
     6.436    91.047     0.150
     7.092   102.938     0.150
     7.118   102.988     0.150
     7.553   109.477     0.150
     7.723   106.078     0.150
     7.758   110.496     0.150
     8.371   121.219     0.150
     8.430   119.008     0.150
     8.555   119.898     0.150
    10.017   138.859     0.150
    10.352   145.098     0.150
    10.525   146.699     0.150
    11.224   156.508     0.150
    11.550   161.227     0.150
    12.090   167.496     0.150
    12.109   173.137     0.150
    12.916   180.117     0.150
    13.959   193.129     0.150
    13.996   192.098     0.150
    14.086   192.598     0.150
    14.283   197.137     0.150
    14.544   199.059     0.150
    14.549   200.449     0.150
    14.656   201.117     0.150
    14.968   205.879     0.150
    16.042   219.559     0.150
    16.192   221.566     0.150
    18.329   248.098     0.150
    27.904   344.625     0.150
    34.444   407.930     0.150
    43.084  3246.297     0.150
    43.090  3249.891     0.150
    43.102  3247.836     0.150
    44.248  3333.438     0.150
    44.261  3341.391     0.150
    44.265  3337.102     0.150
    47.159   507.648     0.150
    76.740   709.883     0.150
    81.508   736.078     0.150
     0.997    17.865     0.150
     3.972    59.855     0.150
     4.627    66.484     0.150
     9.735   136.805     0.150
    25.684   323.623     0.150
    42.904  3223.928     0.150
    42.910  3227.783     0.150
    42.922  3226.328     0.150
    44.066  3314.369     0.150
    44.080  3334.818     0.150
    44.084  3312.316     0.150
    66.306   644.895     0.150
     1.738    30.070     0.150
    42.897  3238.047     0.150
    42.903  3244.523     0.150
    42.915  3246.254     0.150
    44.059  3325.117     0.150
    44.072  3328.430     0.150
    44.077  3336.859     0.150
     1.518    27.023     0.150
     1.577    27.645     0.150
     1.877    32.125     0.150
     2.820    42.312     0.150
     5.412    78.125     0.150
     8.066   114.785     0.150
     8.134   115.504     0.150
     8.492   120.445     0.150
     9.630   135.543     0.150
    11.551   161.305     0.150
    12.074   167.355     0.150
    12.141   168.336     0.150
    42.751  3236.363     0.150
    42.756  3239.973     0.150
    42.768  3235.062     0.150
    43.912  3312.586     0.150
    43.926  3317.258     0.150
    43.930  3314.566     0.150
     3.668    54.695     0.150
     4.118    60.539     0.150
     4.898    71.102     0.150
     5.815    88.516     0.150
    15.560   222.500     0.150
    42.634  3230.555     0.150
    42.639  3235.680     0.150
    42.651  3231.930     0.150
    43.795  3316.492     0.150
    43.808  3302.586     0.150
    43.812  3317.984     0.150
    50.159   532.109     0.150
    75.475   704.359     0.150
    81.466   737.445     0.150
   143.965  1169.180     0.150
     1.411    24.818     0.150
     1.420    25.068     0.150
     1.420    43.018     0.150
     1.430    25.139     0.150
     1.565    27.719     0.150
     1.669    29.289     0.150
     1.803    29.059     0.150
     2.242    36.357     0.150
     2.407    37.938     0.150
     2.407    38.998     0.150
     4.501    64.088     0.150
     4.829    70.418     0.150
     5.241   129.463     0.150
    12.188   296.643     0.150
    32.274   384.029     0.150
    42.924  3225.387     0.150
    42.930  3225.832     0.150
    42.942  3226.738     0.150
    44.087  3326.389     0.150
    44.101  3327.469     0.150
    44.105  3315.840     0.150
    65.148   637.979     0.150
    78.173   715.498     0.150
   144.272  1168.113     0.150
     0.562    13.215     0.150
     0.562    13.535     0.150
     0.572    12.984     0.150
     1.891    31.164     0.150
     2.329    40.234     0.150
     2.898    44.777     0.150
     3.921    60.617     0.150
    42.782  3222.117     0.150
    42.788  3224.895     0.150
    42.800  3229.312     0.150
    43.944  3315.520     0.150
    43.957  3322.297     0.150
    43.961  3319.918     0.150
     1.014    18.645     0.150
     1.885    34.926     0.150
     2.287    64.973     0.150
     2.895    43.695     0.150
     3.971    59.715     0.150
     4.919    74.445     0.150
    24.875   325.504     0.150
    42.893  3224.469     0.150
    42.899  3225.008     0.150
    42.911  3225.941     0.150
    44.055  3317.633     0.150
    44.069  3313.293     0.150
    44.073  3316.023     0.150
    47.177   515.953     0.150
    55.001   575.066     0.150
     1.265    24.039     0.150
     2.157    35.750     0.150
     2.330    38.799     0.150
     4.830    71.240     0.150
    25.852   331.186     0.150
    42.704  3240.734     0.150
    42.709  3241.211     0.150
    42.722  3230.283     0.150
    43.864  3312.766     0.150
    43.877  3322.555     0.150
    43.881  3314.750     0.150
    50.791   542.354     0.150
     5.364    77.012     0.150
     6.456    93.012     0.150
     8.882   128.012     0.150
    11.181   156.172     0.150
    42.810  3221.715     0.150
    42.816  3222.449     0.150
    42.828  3224.668     0.150
    43.971  3311.840     0.150
    43.984  3312.855     0.150
    43.989  3313.168     0.150
     4.666    70.875     0.150
     4.843    71.195     0.150
     5.071    76.875     0.150
     6.462    98.672     0.150
    15.229   216.141     0.150
    34.501   408.352     0.150
    42.943  3236.805     0.150
    42.949  3237.250     0.150
    42.961  3251.664     0.150
    44.106  3331.836     0.150
    44.119  3335.672     0.150
    44.123  3335.758     0.150
    51.481   545.180     0.150
    66.262   647.977     0.150
     1.648    28.410     0.150
     3.890    56.750     0.150
     5.065    73.160     0.150
    23.042   304.080     0.150
    24.977   323.539     0.150
    66.467   647.270     0.150
     5.142    73.562     0.150
    43.023  3239.129     0.150
    43.029  3245.332     0.150
    43.041  3246.184     0.150
    44.187  3331.000     0.150
    44.200  3335.629     0.150
    44.204  3329.504     0.150
   144.345  1168.320     0.150
     1.156    35.391     0.150
     2.869    43.363     0.150
     3.944    58.363     0.150
     4.727    68.812     0.150
     6.770    96.480     0.150
     8.145   114.691     0.150
     0.383    14.172     0.150
     0.848    18.143     0.150
     4.114    60.842     0.150
     4.187   113.373     0.150
     8.580   122.422     0.150
    11.512   157.666     0.150
    24.749   314.396     0.150
    43.465  3252.967     0.150
    43.471  3251.977     0.150
    43.483  3249.980     0.150
    44.633  3349.830     0.150
    44.647  3359.680     0.150
    44.650  3352.836     0.150
    54.602   561.852     0.150
    63.875   645.172     0.150
    65.766   637.994     0.150
    81.328   730.373     0.150
     0.895    16.852     0.150
     3.808    56.453     0.150
     4.229   113.262     0.150
    42.959  3227.871     0.150
    42.964  3229.348     0.150
    42.977  3229.238     0.150
    44.122  3330.266     0.150
    44.135  3331.336     0.150
    44.139  3329.516     0.150
    47.213   508.805     0.150
    74.864   695.113     0.150
     1.449    25.256     0.150
     1.451    25.076     0.150
     1.569    27.256     0.150
     2.248    35.726     0.150
     5.534    79.816     0.150
     9.139   128.366     0.150
     9.920   139.026     0.150
     9.938   140.136     0.150
    10.187   141.446     0.150
    10.515   148.146     0.150
    14.916   202.366     0.150
    16.239   223.167     0.150
    16.248   221.096     0.150
    20.787   276.516     0.150
    24.321   315.246     0.150
    24.321   315.256     0.150
    24.524   316.116     0.150
    24.524   533.226     0.150
    27.068   337.246     0.150
    27.068   337.206     0.150
    27.369   340.966     0.150
    30.501   368.486     0.150
    31.220   380.516     0.150
    31.979   382.226     0.150
    34.534   403.386     0.150
    36.093  1028.146     0.150
    36.934   424.146     0.150
    36.934   424.096     0.150
    37.692   431.156     0.150
    37.815   431.706     0.150
    38.118   435.906     0.150
    38.710   445.687     0.150
    40.920   463.056     0.150
    41.586   465.616     0.150
    42.760   475.146     0.150
    42.760   475.096     0.150
    42.790     9.400     0.150
    42.897  3229.140     0.150
    42.902  3246.473     0.150
    42.914  3227.993     0.150
    43.912   483.496     0.150
    44.059  3326.641     0.150
    44.073  3327.956     0.150
    44.077  3328.163     0.150
    44.474   486.326     0.150
    44.474   487.116     0.150
    45.375   493.046     0.150
    45.361   498.006     0.150
    46.138   498.546     0.150
    46.138   498.556     0.150
    46.973   507.786     0.150
    46.973   510.286     0.150
    47.216   509.776     0.150
    47.873   514.306     0.150
    47.805     9.700     0.150
    49.011   522.917     0.150
    50.712   536.667     0.150
    51.519   541.626     0.150
    52.880   551.386     0.150
    52.791     9.800     0.150
    53.543   557.726     0.150
    54.950   568.156     0.150
    54.950   628.156     0.150
    55.998   574.786     0.150
    56.259   576.776     0.150
    57.313    10.100     0.150
    57.892  1178.046     0.150
    57.892  1292.546     0.150
    58.272     7.700     0.150
    58.272    10.800     0.150
    60.709   608.336     0.150
    63.409   630.746     0.150
    63.760    10.500     0.150
    64.010   627.046     0.150
    64.352     8.600     0.150
    64.718   635.486     0.150
    64.893    10.800     0.150
    65.187  1165.046     0.150
    65.187   637.966     0.150
    65.936   643.866     0.150
    66.375   645.226     0.150
    66.496     4.100     0.150
    66.496   679.546     0.150
    67.730   655.016     0.150
    68.309   658.687     0.150
    68.927   663.346     0.150
    69.250   664.176     0.150
    69.353     3.400     0.150
    69.962   927.446     0.150
    69.962  1482.046     0.150
    70.406   670.546     0.150
    70.446   671.866     0.150
    70.586   672.406     0.150
    70.899   674.576     0.150
    70.969   674.726     0.150
    71.226   937.446     0.150
    71.226   676.706     0.150
    71.226   676.706     0.150
    71.226   676.706     0.150
    71.226   696.366     0.150
    71.226   834.426     0.150
    71.226   937.536     0.150
    71.226  1234.726     0.150
    71.226  1281.116     0.150
    71.226  1509.566     0.150
    71.226  1708.716     0.150
    71.328   677.176     0.150
    71.274   677.156     0.150
    71.475   677.976     0.150
    71.871   679.626     0.150
    72.732   685.846     0.150
    73.642   690.736     0.150
    73.739   690.466     0.150
    74.034   693.446     0.150
    74.292   694.426     0.150
    74.292   694.426     0.150
    74.442   694.846     0.150
    74.442     8.600     0.150
    74.442   860.846     0.150
    74.750   697.376     0.150
    74.915   697.546     0.150
    74.940   697.446     0.150
    74.948   697.646     0.150
    74.948   697.746     0.150
    75.275   699.246     0.150
    75.275   699.246     0.150
    75.287   700.246     0.150
    75.311   700.546     0.150
    75.355   700.946     0.150
    75.356     9.600     0.150
    75.487   701.646     0.150
    75.520   702.046     0.150
    75.739   702.946     0.150
    75.806   703.446     0.150
    76.069   704.046     0.150
    76.069   704.046     0.150
    76.120   704.758     0.150
    76.552   706.546     0.150
    76.552   706.546     0.150
    76.569   708.170     0.150
    76.933   709.667     0.150
    76.971   710.146     0.150
    76.984   710.146     0.150
    77.382   713.946     0.150
    77.421   713.146     0.150
    77.519   713.746     0.150
    77.550   712.245     0.150
    78.003   715.636     0.150
    78.208   718.446     0.150
    78.215   716.743     0.150
    79.106   721.930     0.150
    79.917   725.912     0.150
    80.297   727.475     0.150
    80.397   728.701     0.150
    80.461   728.589     0.150
    80.510   729.264     0.150
    80.916  1021.946     0.150
    80.916  1658.446     0.150
    80.916  1862.646     0.150
    81.008   731.590     0.150
    81.057   732.196     0.150
    81.201   732.596     0.150
    81.871   735.816     0.150
    82.712   740.576     0.150
    84.040   745.646     0.150
    85.421   754.816     0.150
    92.860   787.006     0.150
    96.207   803.667     0.150
    99.329   818.246     0.150
    99.329   818.226     0.150
   111.616  8373.173     0.150
   111.628  8377.833     0.150
   144.229  1169.317     0.150
   153.911  1187.236     0.150
     3.947    58.312     0.150
    42.802  3224.379     0.150
    42.808  3225.668     0.150
    42.820  3228.320     0.150
    43.963  3311.783     0.150
    43.976  3328.824     0.150
    43.981  3312.920     0.150
     0.939    17.760     0.150
     2.659    40.159     0.150
     4.493    65.250     0.150
     9.396   135.310     0.150
    37.813   433.550     0.150
    43.039  3243.424     0.150
    43.044  3238.886     0.150
    43.057  3229.747     0.150
    44.201  3330.563     0.150
    44.215  3331.601     0.150
    44.219  3331.230     0.150
    65.064   639.394     0.150
    74.872   698.543     0.150
    83.874   749.308     0.150
     1.166    20.320     0.150
     3.023    50.820     0.150
     4.692    70.453     0.150
     6.062    89.688     0.150
     0.203     9.762     0.150
     1.309    23.062     0.150
     1.372    24.332     0.150
     1.389    24.613     0.150
     1.504    26.551     0.150
     1.519    26.422     0.150
     1.523    26.160     0.150
     2.310    38.051     0.150
     2.476    41.141     0.150
     2.646    40.410     0.150
     5.087   152.832     0.150
     6.087    84.641     0.150
     6.881   100.102     0.150
    14.930   206.211     0.150
    16.753   408.711     0.150
    34.465   408.926     0.150
    43.078  3247.090     0.150
    43.084  3243.684     0.150
    43.096  3248.988     0.150
    44.242  3336.371     0.150
    44.255  3338.512     0.150
    44.259  3337.191     0.150
    47.182   515.223     0.150
    47.799   515.160     0.150
    59.402   596.898     0.150
    66.157   644.184     0.150
    79.908   725.621     0.150
   145.253  1174.488     0.150
     1.513    26.891     0.150
     1.516    26.617     0.150
     1.830    30.836     0.150
     2.086    34.711     0.150
     2.283    38.258     0.150
     2.416    39.883     0.150
     3.477    54.086     0.150
     4.502    65.273     0.150
     4.540    66.195     0.150
     5.098   131.703     0.150
     5.098   154.430     0.150
     6.091    87.734     0.150
     7.741   109.992     0.150
     8.982   126.766     0.150
     9.213   129.391     0.150
     9.278   130.305     0.150
    10.982   153.352     0.150
    11.038   154.164     0.150
    11.298   157.922     0.150
    11.351   158.406     0.150
    11.608   162.422     0.150
    11.749   164.406     0.150
    12.026   297.062     0.150
    12.265   170.906     0.150
    13.918   192.672     0.150
    13.969   192.008     0.150
    13.974   192.852     0.150
    14.108   193.914     0.150
    14.192   196.281     0.150
    14.299   197.758     0.150
    14.563   200.625     0.150
    14.564   200.828     0.150
    14.941   206.164     0.150
    24.361   318.781     0.150
    24.361   312.805     0.150
    43.067  3250.977     0.150
    43.073  3250.820     0.150
    43.085  3251.648     0.150
    44.231  3336.047     0.150
    44.244  3335.000     0.150
    44.248  3338.594     0.150
    78.024   714.102     0.150
     0.350    13.348     0.150
     1.599    27.949     0.150
     2.458    40.828     0.150
     2.710    45.848     0.150
     2.710    44.711     0.150
     4.698    71.828     0.150
     6.205    93.039     0.150
     9.437   136.609     0.150
    12.193   174.449     0.150
    14.964   212.891     0.150
    15.601   377.895     0.150
    34.450   408.141     0.150
    37.199   432.141     0.150
    42.985  3244.598     0.150
    42.991  3247.516     0.150
    43.003  3245.828     0.150
    44.147  3331.828     0.150
    44.161  3332.160     0.150
    44.165  3331.996     0.150
    64.403   635.551     0.150
    72.189   685.719     0.150
    80.082   730.258     0.150
    96.298   809.902     0.150
    96.298   808.949     0.150
   111.559  8373.832     0.150
   111.571  8375.137     0.150
     1.031    18.812     0.150
     3.976    59.953     0.150
     4.644    67.172     0.150
     7.250   529.781     0.150
     9.754   137.633     0.150
    12.261   297.109     0.150
    31.496   378.242     0.150
    42.888  3224.367     0.150
    42.893  3225.539     0.150
    42.905  3225.938     0.150
    44.049  3312.547     0.150
    44.063  3313.477     0.150
    44.067  3313.875     0.150
     1.646    27.039     0.150
     5.781   514.289     0.150
     1.588    46.930     0.150
     3.680    96.359     0.150
     4.118    61.367     0.150
    10.294   142.094     0.150
    24.281   315.266     0.150
    43.143  3245.148     0.150
    43.149  3245.531     0.150
    43.161  3248.734     0.150
    44.306  3335.914     0.150
    44.320  3334.828     0.150
    44.324  3337.367     0.150
    56.060   570.812     0.150
    59.453   596.141     0.150
     1.362    23.097     0.150
     1.362    23.647     0.150
     2.333    37.147     0.150
     2.507    41.607     0.150
     2.634    67.577     0.150
     4.402    64.617     0.150
     5.089   154.061     0.150
     5.089    73.277     0.150
     6.466    97.817     0.150
    10.005   139.487     0.150
    11.875   171.307     0.150
    14.732   202.117     0.150
    16.068  1198.768     0.150
    16.068  1197.872     0.150
    16.738   409.642     0.150
    20.336   274.257     0.150
    36.696   430.607     0.150
    43.076  3230.405     0.150
    43.082  3230.310     0.150
    43.094  3231.218     0.150
    44.240  3334.618     0.150
    44.253  3335.810     0.150
    44.257  3335.492     0.150
    45.455   496.767     0.150
    46.791   507.917     0.150
    47.110   508.167     0.150
    52.817     8.500     0.150
    53.793   558.327     0.150
    57.704    11.100     0.150
    59.462   599.907     0.150
    61.488  1115.917     0.150
    63.797     5.800     0.150
    64.356     8.000     0.150
    64.914     9.100     0.150
    66.464     8.200     0.150
    66.464    12.800     0.150
    69.353     2.900     0.150
    69.353     7.300     0.150
    74.278  1892.917     0.150
    74.278  2132.917     0.150
    74.804   697.181     0.150
    75.194   701.917     0.150
    76.818  1881.417     0.150
    76.882   708.917     0.150
    77.618   714.817     0.150
    77.769   716.033     0.150
    77.789   719.432     0.150
    78.010   720.127     0.150
    78.124   718.215     0.150
    78.137   719.146     0.150
    78.162   720.527     0.150
    78.238   720.718     0.150
    78.537   723.127     0.150
    78.708   720.870     0.150
    78.803   722.396     0.150
    85.392   755.087     0.150
     0.904    17.307     0.150
     1.462    25.916     0.150
     1.579    26.926     0.150
     1.578    27.205     0.150
     2.392    39.156     0.150
     2.567    70.105     0.150
     6.804    97.906     0.150
     6.869    97.926     0.150
    12.091   163.471     0.150
    12.091   285.727     0.150
    18.397   249.301     0.150
    34.441   413.482     0.150
    47.142   519.834     0.150
    54.964   568.285     0.150
     1.432    45.055     0.150
     2.891    44.348     0.150
    10.947   157.805     0.150
    18.460   251.000     0.150
    42.965  3252.598     0.150
    42.971  3252.199     0.150
    42.983  3252.074     0.150
    44.128  3337.684     0.150
    44.142  3338.738     0.150
    44.146  3336.395     0.150
     0.819    15.555     0.150
     1.398    24.824     0.150
     1.397    24.676     0.150
     1.416    25.004     0.150
     8.528   119.797     0.150
    11.345   158.844     0.150
    32.212   392.102     0.150
    75.265     7.500     0.150
    93.054   794.211     0.150
   144.439  1173.883     0.150
     1.479    26.223     0.150
     4.507    63.902     0.150
     4.818    70.393     0.150
     5.156    77.422     0.150
     8.418   121.861     0.150
    18.417   251.551     0.150
    43.025  3247.643     0.150
    43.031  3242.230     0.150
    43.043  3243.143     0.150
    44.187  3337.428     0.150
    44.201  3338.039     0.150
    44.205  3330.348     0.150
    54.997   566.918     0.150
     1.349    24.883     0.150
     2.286    63.852     0.150
     2.414    68.055     0.150
     2.615    80.000     0.150
     3.326    86.461     0.150
     9.691   129.953     0.150
    30.970   375.812     0.150
    55.391   555.609     0.150
     0.263    10.425     0.150
     0.848    15.805     0.150
     4.554    66.335     0.150
     5.437    78.615     0.150
     8.993   125.725     0.150
    10.384   146.725     0.150
    10.464   146.725     0.150
    10.479   148.625     0.150
    10.479   146.215     0.150
    10.704   149.625     0.150
    10.905   152.975     0.150
    11.910   164.925     0.150
    12.076   298.896     0.150
    12.076   166.425     0.150
    16.099   219.565     0.150
    18.387   250.725     0.150
    24.331   626.325     0.150
    24.841   318.625     0.150
    24.841   318.925     0.150
    25.064   321.525     0.150
    25.064   321.525     0.150
    26.792   336.795     0.150
    27.011   339.825     0.150
    27.450   342.375     0.150
    28.737   355.525     0.150
    29.420   361.425     0.150
    30.766   373.325     0.150
    31.352   378.725     0.150
    31.520   380.125     0.150
    32.459   388.225     0.150
    32.625   388.625     0.150
    32.625   388.655     0.150
    33.111   393.925     0.150
    33.863   397.625     0.150
    33.863   397.915     0.150
    34.221   404.025     0.150
    34.209   732.925     0.150
    35.033   409.325     0.150
    35.680   415.215     0.150
    36.032   416.225     0.150
    36.032   495.425     0.150
    36.200   760.625     0.150
    36.200   902.525     0.150
    36.263   421.325     0.150
    36.359   421.905     0.150
    36.748   424.925     0.150
    36.870   426.325     0.150
    36.870   426.435     0.150
    37.327   429.455     0.150
    38.663   440.025     0.150
    38.904   441.225     0.150
    40.907   461.125     0.150
    40.907   461.195     0.150
    42.731   474.125     0.150
    43.025  3248.818     0.150
    43.031  3251.228     0.150
    43.043  3252.129     0.150
    44.189  3337.073     0.150
    44.202  3338.765     0.150
    44.206  3338.282     0.150
    44.669   490.175     0.150
    45.399   495.525     0.150
    46.640   505.865     0.150
    46.821   507.525     0.150
    47.094   507.815     0.150
    47.094   507.825     0.150
    47.725   514.025     0.150
    47.725   514.125     0.150
    50.728   536.725     0.150
    51.448   541.625     0.150
    51.448   541.695     0.150
    51.448    10.720     0.150
    51.614   543.725     0.150
    51.614   543.625     0.150
    52.023   547.035     0.150
    52.319   548.965     0.150
    53.486   556.875     0.150
    54.569   563.405     0.150
    54.569     8.200     0.150
    54.905   567.425     0.150
    54.905   629.625     0.150
    55.412   571.165     0.150
    55.856   573.325     0.150
    56.116   574.525     0.150
    57.753  1290.325     0.150
    58.248    10.300     0.150
    60.979   603.025     0.150
    62.752   623.535     0.150
    63.748     9.300     0.150
    63.748    14.530     0.150
    64.277   631.625     0.150
    64.277   631.595     0.150
    64.488   632.525     0.150
    64.643   634.675     0.150
    64.868    12.500     0.150
    65.071   636.525     0.150
    65.071   636.455     0.150
    66.296   644.325     0.150
    66.430     4.600     0.150
    69.169   663.445     0.150
    69.827   692.225     0.150
    69.827   920.425     0.150
    69.827  1205.825     0.150
    70.176   668.125     0.150
    70.329   669.885     0.150
    70.367   671.085     0.150
    70.508   671.725     0.150
    70.820   673.745     0.150
    70.886   673.965     0.150
    71.085   934.925     0.150
    71.085   674.515     0.150
    71.085   674.605     0.150
    71.085   674.605     0.150
    71.085   694.705     0.150
    71.085   831.775     0.150
    71.085   934.995     0.150
    71.085  1228.465     0.150
    71.085  1275.725     0.150
    71.085  1502.535     0.150
    71.248   676.215     0.150
    71.394   677.315     0.150
    72.648   684.925     0.150
    72.648   685.185     0.150
    72.648   684.995     0.150
    73.373   685.725     0.150
    73.553   689.895     0.150
    73.614   691.265     0.150
    73.648   689.925     0.150
    73.943   693.315     0.150
    74.294   694.025     0.150
    74.294   694.125     0.150
    74.660   696.695     0.150
    74.801   696.125     0.150
    74.809   696.225     0.150
    74.809   696.263     0.150
    74.809   696.225     0.150
    74.809   696.235     0.150
    74.883   698.085     0.150
    75.072   699.261     0.150
    75.128   698.925     0.150
    75.140   699.525     0.150
    75.140   699.575     0.150
    75.164   699.425     0.150
    75.208   699.825     0.150
    75.339   700.625     0.150
    75.374   701.125     0.150
    75.374   701.035     0.150
    75.442   702.285     0.150
    75.660   701.725     0.150
    75.974   704.033     0.150
    76.122   704.725     0.150
    76.405   706.325     0.150
    76.372   704.125     0.150
    76.423   707.053     0.150
    76.623   708.625     0.150
    76.785   708.625     0.150
    76.828   709.325     0.150
    76.837   708.525     0.150
    76.958   709.825     0.150
    77.276   711.825     0.150
    77.293   712.025     0.150
    77.411   711.250     0.150
    77.547   714.725     0.150
    77.858   715.296     0.150
    77.951   716.125     0.150
    78.065   716.099     0.150
    78.065   716.185     0.150
    78.074   715.825     0.150
    78.074   715.867     0.150
    78.255   717.535     0.150
    78.517   717.418     0.150
    78.533   719.335     0.150
    78.806   720.945     0.150
    78.963   720.917     0.150
    79.023   721.582     0.150
    79.154   722.285     0.150
    79.314   723.231     0.150
    79.573   724.685     0.150
    79.758   725.343     0.150
    79.777   725.412     0.150
    79.868   725.826     0.150
    79.868   725.885     0.150
    79.897   726.025     0.150
    80.066   727.232     0.150
    80.058   721.225     0.150
    80.058  1019.125     0.150
    80.058  1316.725     0.150
    80.154   726.924     0.150
    80.167   727.799     0.150
    80.255   727.738     0.150
    80.322   728.084     0.150
    80.339   728.785     0.150
    80.371   728.359     0.150
    80.512   729.266     0.150
    80.787  1025.625     0.150
    80.787  1847.725     0.150
    80.995   731.297     0.150
    80.995   731.425     0.150
    80.995   732.185     0.150
    80.981   731.825     0.150
    81.072   732.328     0.150
    81.218   732.846     0.150
    81.227   731.925     0.150
    81.194   732.025     0.150
    81.787   735.025     0.150
    83.248   743.525     0.150
    83.343   743.985     0.150
    85.287   754.525     0.150
    85.287   754.617     0.150
    85.287   754.715     0.150
    85.287   754.475     0.150
    85.802   756.473     0.150
    86.548   760.585     0.150
    86.631   761.115     0.150
    87.466   764.725     0.150
    88.638   769.225     0.150
    99.215   817.405     0.150
    99.215   817.425     0.150
   139.445  1156.885     0.150
     0.470     9.242     0.150
     1.924    33.473     0.150
     1.924    58.645     0.150
     2.087    36.645     0.150
     2.162    37.562     0.150
     2.162    65.922     0.150
     2.313    39.164     0.150
     2.442    41.402     0.150
     2.442    72.422     0.150
     2.558    43.074     0.150
     2.928    80.242     0.150
     3.331    53.883     0.150
     3.652    56.531     0.150
     3.695   102.145     0.150
     3.695   103.113     0.150
     3.787   102.012     0.150
     3.951    59.684     0.150
     3.920   106.762     0.150
     4.688    69.203     0.150
     4.939    73.645     0.150
     5.299   153.812     0.150
     5.299    77.734     0.150
     5.299    80.074     0.150
     6.037    89.914     0.150
     9.058   131.145     0.150
     9.058   130.914     0.150
    10.163   146.812     0.150
    11.056   157.074     0.150
    11.590   164.293     0.150
    12.091   289.219     0.150
    12.091   170.453     0.150
    18.427   250.273     0.150
    20.549   276.395     0.150
    23.957   312.273     0.150
    24.576     9.883     0.150
    31.528   387.293     0.150
    33.537   393.805     0.150
    33.947   411.191     0.150
    34.828     8.531     0.150
    37.569   432.434     0.150
    38.289   437.953     0.150
    42.385   465.645     0.150
    42.875  3243.027     0.150
    42.881  3236.699     0.150
    42.893  3237.289     0.150
    44.042  3324.102     0.150
    44.055  3325.922     0.150
    44.059  3327.988     0.150
    45.046   493.492     0.150
    48.468   518.031     0.150
    53.113   552.383     0.150
    54.189   562.254     0.150
    63.932    15.000     0.150
    71.115   681.645     0.150
    72.301   682.902     0.150
    73.025   686.684     0.150
    74.155   860.043     0.150
    74.599   693.543     0.150
    74.924    15.500     0.150
    77.450   712.004     0.150
    77.633   713.148     0.150
    78.299   717.012     0.150
    78.394   717.496     0.150
    78.394   717.203     0.150
    78.681   719.602     0.150
    78.931   720.074     0.150
    82.088   738.004     0.150
     1.096    19.809     0.150
     3.961    57.918     0.150
     9.852   138.338     0.150
    18.666   254.598     0.150
    27.951   345.758     0.150
    30.763   371.668     0.150
    42.792  3224.355     0.150
    42.798  3221.996     0.150
    42.810  3224.277     0.150
    43.953  3310.582     0.150
    43.967  3312.203     0.150
    43.971  3311.957     0.150
    56.405   580.031     0.150
    64.420    10.500     0.150
    65.794   643.418     0.150
    66.587   650.199     0.150
    75.085   700.898     0.150
   144.083  1169.043     0.150
     4.817    70.078     0.150
     6.858    98.316     0.150
     7.246   103.137     0.150
     9.604   134.066     0.150
    25.771   328.469     0.150
    42.706  3225.531     0.150
    42.711  3230.805     0.150
    42.724  3222.891     0.150
    43.867  3313.695     0.150
    43.880  3313.215     0.150
    43.884  3321.094     0.150
    66.428   647.508     0.150
    66.428   647.227     0.150
     4.022    60.250     0.150
     6.984    97.980     0.150
     7.965   112.262     0.150
    12.202   293.766     0.150
    24.468   320.582     0.150
    47.133   522.785     0.150
     1.387    24.719     0.150
     5.108    73.969     0.150
    35.002   408.969     0.150
    41.895   467.609     0.150
    42.582   472.019     0.150
    43.057  3264.885     0.150
    43.063  3265.830     0.150
    43.075  3265.246     0.150
    44.220  3332.971     0.150
    44.234  3338.075     0.150
    44.238  3334.972     0.150
    53.469   555.609     0.150
    61.446   615.799     0.150
    63.755     8.700     0.150
    64.315     6.300     0.150
    66.426   648.999     0.150
    66.426     8.000     0.150
    74.266   697.799     0.150
    78.113   718.452     0.150
    78.126   718.336     0.150
    78.151   718.343     0.150
    78.777   720.769     0.150
    78.977   723.002     0.150
   111.638  8376.188     0.150
   111.649  8376.837     0.150
   111.654  8390.577     0.150
   144.400  1170.418     0.150
     0.249     8.066     0.150
     0.834    16.863     0.150
     3.736    97.805     0.150
     5.129    74.215     0.150
    43.036  3226.852     0.150
    43.042  3229.078     0.150
    43.054  3229.246     0.150
    44.199  3316.141     0.150
    44.213  3317.539     0.150
    44.217  3318.457     0.150
   111.650  8373.027     0.150
   111.662  8374.387     0.150
     1.307    21.805     0.150
     1.408    45.094     0.150
     0.910    18.844     0.150
     0.956    21.383     0.150
     0.956    33.582     0.150
     1.122    36.844     0.150
     1.295    41.734     0.150
     1.661    33.512     0.150
     1.661    55.121     0.150
     1.840    60.793     0.150
     2.068    39.621     0.150
     2.068    65.852     0.150
     2.417    67.852     0.150
    20.610    45.352     0.150
    86.826    86.324     0.150
    74.963    51.484     0.150
    74.963    87.164     0.150
     7.409   110.914     0.150
    17.492   246.531     0.150
    32.848   399.719     0.150
    35.153   420.590     0.150
    42.374  3204.727     0.150
    42.380  3203.086     0.150
    42.392  3205.312     0.150
    47.812   525.059     0.150
    64.833   640.074     0.150
    74.963   701.414     0.150
    80.188   730.242     0.150
    19.937    37.839     0.150
    75.057    56.139     0.150
     4.847    73.179     0.150
     4.991    75.398     0.150
    16.895   234.438     0.150
    42.868  3223.903     0.150
    42.874  3221.469     0.150
    42.886  3230.069     0.150
    44.029  3309.169     0.150
    44.043  3310.834     0.150
    44.047  3311.310     0.150
    65.198   640.059     0.150
    19.916    34.312     0.150
     2.317    38.252     0.150
     2.317    38.422     0.150
    86.621    55.342     0.150
    74.758    56.192     0.150
     5.087    73.132     0.150
    12.022   166.242     0.150
    55.437   272.962     0.150
    32.234   387.982     0.150
    33.839   397.482     0.150
    34.456   405.602     0.150
    43.078  3249.435     0.150
    43.084  3260.350     0.150
    43.096  3250.811     0.150
    44.241  3317.040     0.150
    44.255  3319.673     0.150
    44.259  3320.252     0.150
    45.425   495.382     0.150
    47.171   511.122     0.150
    56.071   573.982     0.150
    64.165   630.712     0.150
    74.758   695.642     0.150
    81.496   733.822     0.150
    83.783   746.522     0.150
   111.638  8373.515     0.150
   111.650  8376.212     0.150
   144.421  1172.382     0.150
    19.950    37.863     0.150
     5.304    76.223     0.150
     5.304   133.191     0.150
    12.293   170.602     0.150
    18.595   460.723     0.150
    24.899   321.273     0.150
    34.493   408.684     0.150
    42.866  3224.016     0.150
    42.872  3226.215     0.150
    42.884  3230.496     0.150
    44.028  3316.531     0.150
    44.041  3317.605     0.150
    44.045  3313.695     0.150
    65.295   639.941     0.150
    81.564   736.793     0.150
    84.067   749.652     0.150
    19.952    36.988     0.150
    74.989    55.598     0.150
     5.027    73.648     0.150
     5.270   131.570     0.150
    34.514   168.871     0.150
    12.247   169.051     0.150
    42.898  3224.387     0.150
    42.904  3225.254     0.150
    42.916  3224.098     0.150
    44.060  3312.473     0.150
    44.074  3313.086     0.150
    44.078  3312.801     0.150
    55.010   568.039     0.150
    64.425   635.340     0.150
    64.411     7.301     0.150
    64.534   635.340     0.150
    74.989   697.758     0.150
    75.417     7.203     0.150
    84.017   749.410     0.150
    92.873   792.773     0.150
    92.873   792.777     0.150
     1.436    24.125     0.150
    19.768    28.617     0.150
     1.600    50.727     0.150
     1.611    50.977     0.150
    11.366   160.359     0.150
    66.003   646.117     0.150
    66.110   648.117     0.150
     0.494     9.407     0.150
     0.494    15.847     0.150
    20.317    32.917     0.150
    86.351    50.897     0.150
     4.650    68.217     0.150
     6.834    99.477     0.150
     7.074   103.067     0.150
     8.515   122.767     0.150
    73.303   153.527     0.150
    32.675   396.597     0.150
    42.927  3232.761     0.150
    42.933  3230.322     0.150
    42.945  3246.458     0.150
    44.095  3324.279     0.150
    44.108  3324.166     0.150
    44.112  3324.166     0.150
    55.825   571.227     0.150
    63.913   627.067     0.150
    65.970   646.397     0.150
    74.553   692.597     0.150
    78.660   717.498     0.150
    81.042   730.807     0.150
   144.649  1177.116     0.150
     0.777    24.682     0.150
     0.874    18.123     0.150
    19.515    19.742     0.150
    77.287   129.742     0.150
    50.198   145.393     0.150
    23.439   306.533     0.150
    24.330   314.402     0.150
    46.912   508.812     0.150
    19.929    34.566     0.150
     2.337    37.004     0.150
    86.664    55.035     0.150
     8.476   118.996     0.150
     9.258   130.105     0.150
     9.684   135.023     0.150
    99.835   140.125     0.150
    10.019   140.676     0.150
    73.454   152.344     0.150
    34.490   167.273     0.150
    12.067   162.266     0.150
    43.039  3242.645     0.150
    43.045  3243.891     0.150
    43.057  3246.621     0.150
    44.203  3334.039     0.150
    44.216  3337.871     0.150
    44.220  3338.676     0.150
    81.499   737.555     0.150
    19.956    39.853     0.150
     5.407   129.797     0.150
     8.567   124.273     0.150
    82.904   130.543     0.150
    99.463   143.023     0.150
    73.834   155.943     0.150
    34.518   170.933     0.150
    12.425   298.898     0.150
    16.969   238.274     0.150
    47.139   522.097     0.150
    56.503   580.759     0.150
    64.597   636.249     0.150
    66.474   648.323     0.150
    66.474   648.013     0.150
     0.805    23.688     0.150
    19.930    34.379     0.150
    19.930    60.527     0.150
     4.533    68.520     0.150
     4.681    70.410     0.150
     6.400    91.227     0.150
     6.877    97.379     0.150
     6.880    97.617     0.150
    15.367   217.840     0.150
    15.678   221.418     0.150
    16.041   225.770     0.150
    17.313   240.277     0.150
    32.250   395.484     0.150
    43.074  3247.012     0.150
    43.080  3244.879     0.150
    43.092  3246.777     0.150
    44.238  3337.449     0.150
    44.252  3336.844     0.150
    44.256  3338.055     0.150
    54.885   567.457     0.150
    64.930   633.566     0.150
    64.930   633.570     0.150
    19.622    23.800     0.150
    23.766   309.440     0.150
    43.679  3257.773     0.150
    43.685  3254.272     0.150
    43.697  3258.470     0.150
    65.945   642.910     0.150
    19.983    38.340     0.150
    86.964    54.629     0.150
    75.101    54.949     0.150
    75.101    96.441     0.150
    99.531   142.539     0.150
    73.763   155.641     0.150
    42.802  3223.148     0.150
    42.808  3222.312     0.150
    42.820  3224.488     0.150
    59.654   602.840     0.150
    66.394   647.039     0.150
    66.503   647.371     0.150
   144.069  1175.285     0.150
    19.926    34.977     0.150
    19.926    62.516     0.150
     3.571    54.125     0.150
    86.695    55.312     0.150
    86.695    96.727     0.150
    74.832    55.883     0.150
     7.005    99.328     0.150
     9.686   139.383     0.150
    77.845   141.055     0.150
    34.487   167.883     0.150
    25.622   321.273     0.150
    26.824   333.797     0.150
    43.022  3244.680     0.150
    43.028  3245.461     0.150
    43.040  3246.430     0.150
    44.185  3334.391     0.150
    44.198  3336.773     0.150
    44.202  3333.047     0.150
    81.513   737.633     0.150
    19.951    36.838     0.150
    86.833    55.748     0.150
    86.833    96.407     0.150
     4.760    72.107     0.150
    82.696   130.317     0.150
    42.912  3223.883     0.150
    42.918  3228.045     0.150
    42.930  3225.248     0.150
    44.075  3314.744     0.150
    44.088  3315.573     0.150
    44.092  3319.021     0.150
    19.808    29.109     0.150
    86.341    59.359     0.150
     4.254   114.703     0.150
     4.268   117.859     0.150
     4.814    70.016     0.150
    82.255   123.727     0.150
   100.194   135.586     0.150
    34.365   163.938     0.150
    11.711   292.242     0.150
   118.179   177.242     0.150
    55.216   271.477     0.150
    24.895   321.164     0.150
    26.452   335.125     0.150
    88.049   378.359     0.150
    66.374   404.992     0.150
    38.023   437.094     0.150
    43.352  3249.344     0.150
    43.358  3257.750     0.150
    43.370  3250.227     0.150
    44.518  3339.383     0.150
    44.531  3344.977     0.150
    44.535  3336.195     0.150
    59.255   599.492     0.150
    64.198   634.188     0.150
    64.249     6.203     0.150
    74.664   704.836     0.150
    74.792   702.133     0.150
    75.115     6.203     0.150
    75.244   703.133     0.150
    75.330   705.133     0.150
    77.803   714.422     0.150
    77.827   712.812     0.150
    77.902   714.016     0.150
    77.919   714.367     0.150
    78.085   716.258     0.150
    78.182   715.406     0.150
    78.203   717.352     0.150
    78.656   718.633     0.150
    78.806   718.172     0.150
    80.838   732.938     0.150
    81.510   736.836     0.150
    19.931    34.934     0.150
     4.761    69.145     0.150
     5.143   156.129     0.150
     5.462    78.445     0.150
     5.611    81.363     0.150
    82.562   126.453     0.150
    24.861   320.406     0.150
    38.019   437.508     0.150
    43.022  3228.855     0.150
    43.028  3229.355     0.150
    43.040  3226.500     0.150
    44.185  3315.766     0.150
    44.198  3315.766     0.150
    44.202  3314.062     0.150
    50.747   535.730     0.150
    66.456   648.383     0.150
    66.456    18.000     0.150
    75.305     8.699     0.150
   111.619  8375.121     0.150
   111.630  8376.426     0.150
   111.635  8376.223     0.150
    19.952    36.297     0.150
    86.852    54.531     0.150
     3.764    56.266     0.150
     4.543    65.398     0.150
     4.780    71.773     0.150
     8.368   120.812     0.150
    50.798   159.227     0.150
    34.514   169.344     0.150
    15.287   217.992     0.150
     1.388    23.602     0.150
    19.906    32.932     0.150
    19.906    58.922     0.150
    86.575    55.772     0.150
     8.631   124.052     0.150
    73.360   150.962     0.150
    50.718   155.882     0.150
    11.203   156.442     0.150
    34.466   166.072     0.150
    12.049   170.772     0.150
    24.312   311.680     0.150
    43.116  3241.061     0.150
    43.122  3243.699     0.150
    43.134  3255.786     0.150
    44.280  3338.522     0.150
    44.294  3340.598     0.150
    44.298  3340.763     0.150
    45.432   491.561     0.150
    54.884   563.888     0.150
    19.950    36.469     0.150
     4.614    66.809     0.150
     4.703    68.008     0.150
     4.921    71.551     0.150
     8.910   128.160     0.150
    82.714   128.969     0.150
    50.795   159.559     0.150
     2.039    61.461     0.150
    20.183    37.195     0.150
     2.547    75.555     0.150
     2.632    40.359     0.150
     3.416    95.539     0.150
    11.875   170.430     0.150
    42.847  3228.883     0.150
    42.853  3229.266     0.150
    42.865  3230.070     0.150
    44.012  3324.852     0.150
    44.026  3324.000     0.150
    44.030  3340.367     0.150
    45.140   490.266     0.150
    54.506   564.062     0.150
    99.816   140.320     0.150
    77.824   140.602     0.150
    73.473   152.422     0.150
    34.501   167.484     0.150
    19.947    37.910     0.150
    99.580   141.641     0.150
    66.295   404.960     0.150
    42.854  3226.002     0.150
    42.859  3224.197     0.150
    42.872  3226.766     0.150
    44.015  3341.400     0.150
    44.029  3314.627     0.150
    44.033  3318.324     0.150
    19.950    38.489     0.150
    86.944    55.729     0.150
    86.944    97.139     0.150
     5.330   131.553     0.150
    82.803   129.919     0.150
    16.160  1260.688     0.150
    16.160  1261.269     0.150
    16.918   237.059     0.150
    18.628   254.839     0.150
    42.842  3224.418     0.150
    42.847  3226.459     0.150
    42.860  3227.449     0.150
    44.003  3310.160     0.150
    44.016  3312.405     0.150
    44.021  3317.101     0.150
     1.858    30.094     0.150
    19.952    36.404     0.150
    86.824    54.725     0.150
    86.824    95.285     0.150
    74.961    55.285     0.150
    74.961    96.375     0.150
     3.841    95.955     0.150
     5.251   131.564     0.150
    99.675   141.314     0.150
    77.935   141.984     0.150
    73.617   153.445     0.150
    50.795   159.275     0.150
    34.513   169.014     0.150
    12.222   168.754     0.150
   118.336   182.475     0.150
    14.068   199.605     0.150
    14.404   209.545     0.150
    55.553   275.105     0.150
    24.876   320.564     0.150
    26.871   334.619     0.150
    82.515   405.834     0.150
    66.279   403.545     0.150
    83.032   406.055     0.150
    42.917  3227.271     0.150
    42.922  3227.680     0.150
    42.935  3230.869     0.150
    44.079  3311.951     0.150
    44.092  3315.037     0.150
    44.096  3316.809     0.150
    45.402   497.682     0.150
    45.540   500.125     0.150
    50.755   538.885     0.150
    64.472   634.625     0.150
    64.395     6.400     0.150
    64.511   634.717     0.150
    65.108   638.395     0.150
    66.305   645.904     0.150
    66.305   645.775     0.150
    74.455   698.225     0.150
    74.961   699.215     0.150
    75.395   708.125     0.150
    92.887   791.666     0.150
   111.573  8374.865     0.150
   111.584  8373.924     0.150
    87.068    55.477     0.150
    75.204    55.848     0.150
    99.458   143.668     0.150
    78.141   144.738     0.150
    10.781   158.777     0.150
    42.777  3226.391     0.150
    42.783  3226.844     0.150
    42.795  3228.836     0.150
    43.938  3315.398     0.150
    43.951  3315.969     0.150
    43.955  3314.047     0.150
    47.114   513.559     0.150
    47.464   513.648     0.150
    64.545   643.977     0.150
    66.502   648.273     0.150
    66.502   648.277     0.150
    81.638   739.957     0.150
     1.442    25.602     0.150
     4.470    67.160     0.150
     5.096    73.512     0.150
     5.459    78.949     0.150
     6.165    91.879     0.150
    12.060   299.492     0.150
    15.106   208.711     0.150
    18.366   247.090     0.150
    55.433   273.832     0.150
    24.901   318.199     0.150
    32.191   391.262     0.150
    43.063  3247.504     0.150
    43.068  3246.066     0.150
    43.081  3247.660     0.150
    44.226  3333.480     0.150
    44.239  3335.258     0.150
    44.243  3338.656     0.150
    47.132   514.828     0.150
    75.815   703.332     0.150
   111.585  8373.066     0.150
   111.596  8372.426     0.150
     2.021    61.137     0.150
     2.634    43.445     0.150
     2.797    46.416     0.150
    74.939    53.205     0.150
    74.939    93.705     0.150
     5.460    79.217     0.150
     7.102   104.467     0.150
    99.570   145.627     0.150
    42.704  3229.934     0.150
    42.710  3227.203     0.150
    42.722  3228.467     0.150
    43.868  3316.465     0.150
    43.882  3320.846     0.150
    43.886  3318.629     0.150
    66.127   647.148     0.150
     0.603    11.845     0.150
     2.091    60.666     0.150
     2.133    35.155     0.150
   100.507   128.146     0.150
    77.852   128.845     0.150
    11.357   282.746     0.150
    11.357   159.565     0.150
    43.843  3286.396     0.150
    43.849  3269.481     0.150
    43.861  3294.245     0.150
    45.006  3387.450     0.150
    45.019  3387.649     0.150
    45.023  3383.490     0.150
    59.491   597.052     0.150
    63.782   625.823     0.150
     3.662    53.945     0.150
    86.671    54.945     0.150
    86.671    97.156     0.150
    74.807    55.734     0.150
    74.807    97.656     0.150
     4.204   109.133     0.150
     4.489   112.562     0.150
     4.552    64.352     0.150
     5.121   127.562     0.150
     6.443    91.711     0.150
     7.072   173.242     0.150
    99.834   139.320     0.150
    77.830   140.867     0.150
    73.456   152.305     0.150
    34.478   164.492     0.150
   118.299   180.742     0.150
    14.581   200.773     0.150
    14.704   202.156     0.150
    16.771   231.195     0.150
    18.375   251.695     0.150
    43.045  3244.367     0.150
    43.050  3244.836     0.150
    43.062  3241.320     0.150
    44.208  3331.273     0.150
    44.221  3332.781     0.150
    44.225  3333.273     0.150
    45.427   497.383     0.150
    64.989   636.945     0.150
    66.209   644.062     0.150
     1.508    44.836     0.150
     3.446    49.609     0.150
    74.501    52.516     0.150
     4.832    71.766     0.150
    77.412   140.961     0.150
    11.981   298.227     0.150
    18.318   247.344     0.150
    42.974  3253.188     0.150
    42.980  3257.461     0.150
    42.992  3258.422     0.150
    44.142  3338.484     0.150
    44.155  3334.141     0.150
    44.159  3341.992     0.150
    63.879   627.148     0.150
    63.924   627.539     0.150
    74.875   695.242     0.150
    81.109   730.875     0.150
     6.411    95.859     0.150
     7.066   103.836     0.150
     7.904   115.281     0.150
    99.710   141.609     0.150
    34.492   168.281     0.150
    18.491   251.039     0.150
    24.889   325.672     0.150
    42.952  3248.383     0.150
    42.957  3248.781     0.150
    42.970  3249.516     0.150
    44.114  3332.172     0.150
    44.127  3337.234     0.150
    44.132  3334.047     0.150
    65.094   638.258     0.150
    19.259    25.691     0.150
     3.678    56.160     0.150
     7.967   113.762     0.150
   100.514   128.791     0.150
     9.733   140.762     0.150
     9.982   144.660     0.150
    43.740   363.750     0.150
    55.676   572.061     0.150
     1.245    23.203     0.150
    19.137    29.281     0.150
     1.890    32.730     0.150
     2.008    34.574     0.150
     2.056    35.812     0.150
     2.132    36.691     0.150
     2.235    37.262     0.150
     2.266    37.531     0.150
     3.688    57.492     0.150
     3.694    55.711     0.150
     5.084    74.504     0.150
     5.343    77.684     0.150
     5.815    86.844     0.150
     7.313   104.043     0.150
     7.760   111.062     0.150
   100.425   129.922     0.150
    78.044   129.961     0.150
    10.774   151.613     0.150
    11.251   158.273     0.150
    12.620   174.684     0.150
    12.596   176.594     0.150
     0.508    11.965     0.150
     1.015    18.844     0.150
     2.861    80.025     0.150
    86.278    64.545     0.150
    74.415    65.074     0.150
     4.407    64.484     0.150
     7.412   107.965     0.150
   100.456   130.484     0.150
    77.808   131.094     0.150
    10.046   141.645     0.150
    25.775   321.994     0.150
    28.905   359.615     0.150
    43.850   364.514     0.150
    24.448   371.865     0.150
    33.687   402.594     0.150
    82.304   401.965     0.150
    38.187   440.145     0.150
    40.441   459.535     0.150
    43.759  3264.396     0.150
    43.764  3266.654     0.150
    43.777  3254.529     0.150
    43.941   488.365     0.150
    44.922  3370.502     0.150
    44.935  3354.158     0.150
    44.939  3381.412     0.150
    47.006   510.414     0.150
    47.108   509.994     0.150
    50.798   535.645     0.150
    55.120   566.244     0.150
    63.993   630.145     0.150
    64.565    13.000     0.150
    65.180     4.500     0.150
    69.548     2.000     0.150
    69.548     6.000     0.150
    72.664   684.070     0.150
    73.423   689.984     0.150
    74.281   694.705     0.150
    74.899   697.244     0.150
    75.326     9.301     0.150
    77.195   710.195     0.150
    77.441   711.402     0.150
    77.465   710.957     0.150
    77.654   713.076     0.150
    77.748   713.412     0.150
    78.037   715.893     0.150
    78.064   715.852     0.150
    78.666   719.633     0.150
    80.803   733.844     0.150
    84.900   750.934     0.150
     0.578    23.121     0.150
     1.117    20.012     0.150
    19.274    26.371     0.150
    19.274    26.539     0.150
    86.332    66.082     0.150
     8.029   114.199     0.150
     8.701   124.570     0.150
   100.447   128.891     0.150
    77.901   130.020     0.150
     9.913   142.902     0.150
    72.881   141.371     0.150
    11.649   165.402     0.150
    24.358   372.461     0.150
    82.227   401.062     0.150
    43.800  3299.746     0.150
    43.806  3301.324     0.150
    43.818  3301.449     0.150
    44.962  3382.684     0.150
    44.975  3387.641     0.150
    44.979  3387.945     0.150
    66.334   649.652     0.150
     0.769    26.230     0.150
     0.942    16.031     0.150
     1.051    35.301     0.150
     1.839    55.430     0.150
     1.861    55.949     0.150
     1.919    32.102     0.150
     1.975    59.820     0.150
     2.153    34.469     0.150
     2.684    75.328     0.150
     4.129    69.168     0.150
     4.129   123.336     0.150
     4.129    60.070     0.150
     4.316   112.531     0.150
     4.821    68.828     0.150
     6.716    94.230     0.150
     9.470   135.090     0.150
    15.061   214.020     0.150
    15.101   209.699     0.150
    15.398  1176.453     0.150
    15.398  1176.176     0.150
    17.377   235.473     0.150
    23.402   302.438     0.150
    23.402   529.559     0.150
    23.401   307.328     0.150
    98.807   338.738     0.150
    28.871   357.531     0.150
    24.346   371.289     0.150
    31.788   775.398     0.150
    33.815   781.480     0.150
    81.618   408.230     0.150
    44.037  3274.738     0.150
    44.043  3275.160     0.150
    44.055  3276.195     0.150
    82.239   490.258     0.150
    45.202  3377.516     0.150
    45.215  3390.715     0.150
    45.219  3396.266     0.150
    46.026   497.430     0.150
    46.662   597.219     0.150
    51.227   613.281     0.150
    54.683   558.789     0.150
    56.932   578.898     0.150
    57.446   578.570     0.150
    59.824   598.469     0.150
    65.106     7.801     0.150
    66.049   644.328     0.150
    66.386   648.730     0.150
    66.386   682.531     0.150
    69.438     2.398     0.150
    73.947   709.301     0.150
    74.505   693.031     0.150
    74.567   694.328     0.150
    75.135    11.699     0.150
    75.667   701.129     0.150
    75.959   702.410     0.150
    76.014   690.828     0.150
    77.295   710.051     0.150
    77.590   711.531     0.150
    77.730   713.129     0.150
    81.847   735.211     0.150
    82.887   739.504     0.150
     1.367    42.420     0.150
    18.002    25.029     0.150
    18.002    43.410     0.150
     2.217    58.609     0.150
     2.102    60.148     0.150
     2.409    38.799     0.150
     2.874    42.600     0.150
     4.138    59.750     0.150
     9.633   134.350     0.150
    16.345   223.574     0.150
    22.088   296.625     0.150
    30.635   383.867     0.150
    45.446   508.250     0.150
    19.275    20.355     0.150
     1.073    20.335     0.150
     1.073    35.936     0.150
     1.073    20.345     0.150
     1.859    31.405     0.150
     2.729    41.535     0.150
     3.032    49.215     0.150
     4.077    68.279     0.150
     4.077   118.779     0.150
     4.077    62.095     0.150
     4.349    66.135     0.150
   100.855   125.436     0.150
    49.987   143.055     0.150
    33.822   152.726     0.150
   117.620   166.905     0.150
    25.315   534.545     0.150
    25.929   328.726     0.150
    33.627   397.936     0.150
    43.900     0.030     0.150
    44.090  3289.855     0.150
    44.095  3291.253     0.150
    44.107  3289.704     0.150
    45.255  3401.562     0.150
    45.268  3398.622     0.150
    45.272  3399.742     0.150
    45.798   497.835     0.150
    46.043   499.635     0.150
    46.043   500.206     0.150
    52.914   547.375     0.150
    54.666   564.945     0.150
    55.309   567.755     0.150
    57.423   586.655     0.150
    57.550   590.535     0.150
    61.843   616.175     0.150
    61.796    22.200     0.150
    64.446    12.800     0.150
    66.018   641.936     0.150
    66.360   652.135     0.150
    66.360   681.135     0.150
    67.347   648.885     0.150
    67.797   653.706     0.150
    73.404    12.900     0.150
    74.014   690.035     0.150
    75.070   696.235     0.150
    80.980   731.535     0.150
    82.498   738.375     0.150
    82.879   734.305     0.150
    85.680   752.396     0.150
   145.207  1172.345     0.150
   153.060  1193.166     0.150
    19.278    27.625     0.150
    19.278    49.336     0.150
    95.680    57.336     0.150
     4.409    64.406     0.150
    74.522    66.055     0.150
   100.396   129.016     0.150
    11.466   162.465     0.150
    43.762  3262.742     0.150
    43.767  3275.012     0.150
    43.779  3272.391     0.150
    44.923  3346.617     0.150
    44.937  3350.508     0.150
    44.941  3358.379     0.150
     0.678    14.367     0.150
     0.678    24.172     0.150
    18.595    16.922     0.150
    18.595    28.070     0.150
     1.017    19.625     0.150
     1.701    28.172     0.150
     1.912    33.039     0.150
     3.140    82.961     0.150
     6.763    96.820     0.150
     7.785   111.117     0.150
     8.548   124.617     0.150
     8.699   124.117     0.150
     3.577    53.451     0.150
    86.740    56.090     0.150
    74.877    56.400     0.150
    95.000    66.971     0.150
     5.162    72.500     0.150
     9.034   131.980     0.150
    50.744   157.920     0.150
    11.477   165.430     0.150
    11.786   171.621     0.150
    11.960   171.670     0.150
    11.960   171.580     0.150
    12.125   174.191     0.150
    15.595   216.400     0.150
    79.889   310.850     0.150
    24.416   316.541     0.150
    24.382   319.881     0.150
    24.892   320.740     0.150
    43.004  3241.996     0.150
    43.010  3245.387     0.150
    43.022  3246.609     0.150
    44.167  3330.871     0.150
    44.181  3331.951     0.150
    44.185  3332.209     0.150
    83.143   495.691     0.150
    57.708   591.980     0.150
    59.513   600.250     0.150
    63.807   631.580     0.150
    66.505   650.080     0.150
    66.505   679.781     0.150
    69.380     2.701     0.150
    74.363  2184.480     0.150
    74.840   705.590     0.150
    75.279   703.291     0.150
    75.355     3.400     0.150
    76.564   712.680     0.150
    78.340   719.580     0.150
    78.507     7.527     0.150
    78.602     7.357     0.150
    79.224   723.740     0.150
    81.023   732.590     0.150
    82.615   743.980     0.150
   144.302  1170.125     0.150
     1.370    43.590     0.150
     1.426    45.941     0.150
     1.891    33.422     0.150
     2.215    37.352     0.150
     2.857    76.621     0.150
    96.888    47.809     0.150
     3.154    84.641     0.150
     3.263   104.219     0.150
    86.020    82.719     0.150
    74.162    83.379     0.150
    10.565   150.551     0.150
    10.685   152.551     0.150
    16.753   227.676     0.150
    16.753   227.672     0.150
    22.440   297.809     0.150
    26.434   326.363     0.150
    55.368   565.465     0.150
    66.785   645.480     0.150
    66.785   645.480     0.150
    77.518   132.859     0.150
    14.935   210.562     0.150
     3.058    49.809     0.150
     3.094    50.281     0.150
     3.486    88.430     0.150
     4.805    73.629     0.150
    78.579   119.340     0.150
     8.312   120.262     0.150
     8.512   122.762     0.150
    48.812   136.859     0.150
     9.506   140.961     0.150
    32.595   144.590     0.150
    14.858   205.359     0.150
    14.858   362.859     0.150
    24.690   320.020     0.150
    45.962  3480.781     0.150
    45.976  3481.789     0.150
    45.980  3476.934     0.150
    65.663     3.500     0.150
    76.168   711.059     0.150
    78.646   726.660     0.150
   120.040  1132.012     0.150
     1.484    43.965     0.150
    86.494    63.766     0.150
    86.494    64.148     0.150
    77.999   131.926     0.150
    16.136   223.016     0.150
    17.868   244.988     0.150
    43.648  3262.863     0.150
    43.654  3279.781     0.150
    43.666  3291.109     0.150
    44.809  3374.711     0.150
    44.822  3384.348     0.150
    44.826  3386.523     0.150
    66.422   645.438     0.150
     2.594    68.941     0.150
     2.791    41.621     0.150
     3.146    47.078     0.150
     4.979    72.289     0.150
     6.193    87.121     0.150
     6.415    91.008     0.150
     7.138   101.121     0.150
   101.819   106.039     0.150
    77.873   108.586     0.150
     8.394   117.520     0.150
     8.456   120.387     0.150
     8.660   121.219     0.150
     9.512   132.828     0.150
    32.608   136.168     0.150
     9.889   134.289     0.150
    12.613   174.371     0.150
    12.885   178.109     0.150
    13.393   198.219     0.150
    16.221   220.895     0.150
    16.221   397.395     0.150
    17.430   237.520     0.150
    20.822   276.219     0.150
    20.822   277.320     0.150
    24.802   317.418     0.150
    25.918   327.121     0.150
    25.918   327.219     0.150
    26.028   328.801     0.150
    26.028   328.820     0.150
    28.231   347.621     0.150
    28.231   347.621     0.150
    29.731   360.129     0.150
    30.314   366.320     0.150
    30.314   367.320     0.150
    34.822   406.320     0.150
    34.822    11.789     0.150
    34.822    17.039     0.150
    34.822   407.719     0.150
    35.473   410.820     0.150
    36.619   932.418     0.150
    36.619   419.988     0.150
    36.856   423.520     0.150
    36.941   423.520     0.150
    39.383   445.121     0.150
    39.645   446.020     0.150
    39.755   450.160     0.150
    41.423   461.691     0.150
    42.570   485.828     0.150
    45.400   493.020     0.150
    45.405   492.918     0.150
    45.565   495.078     0.150
    45.565   495.078     0.150
    46.057   498.719     0.150
    46.049   498.020     0.150
    46.739   503.320     0.150
    46.799   506.219     0.150
    47.084   506.320     0.150
    47.248   508.328     0.150
    47.248   508.371     0.150
    47.248   508.418     0.150
    48.686   518.418     0.150
    49.332   523.520     0.150
    49.332   523.520     0.150
    52.335   546.520     0.150
    52.990   551.199     0.150
    53.396   554.320     0.150
    53.564   555.621     0.150
    53.919    11.297     0.150
    53.919    16.098     0.150
    54.577   563.328     0.150
    54.577   562.621     0.150
    54.679   564.898     0.150
    54.656    18.602     0.150
    54.656  1016.219     0.150
    54.815   565.230     0.150
    56.582  1269.121     0.150
    56.687    12.000     0.150
    57.395   583.531     0.150
    57.779   587.508     0.150
    62.765    12.000     0.150
    62.946   621.020     0.150
    63.701   627.301     0.150
    64.212   630.848     0.150
    64.328   630.730     0.150
    64.520   631.020     0.150
    65.000    14.797     0.150
    65.307   638.039     0.150
    65.490   638.539     0.150
    65.942   640.781     0.150
    65.941    12.199     0.150
    65.941    20.398     0.150
    66.463   644.910     0.150
    66.527   643.719     0.150
    66.961   647.219     0.150
    66.961   648.918     0.150
    68.792     4.301     0.150
    68.792     6.203     0.150
    68.792  1198.719     0.150
    69.169   661.020     0.150
    69.348   663.621     0.150
    69.348   663.660     0.150
    69.859   665.359     0.150
    69.859   665.359     0.150
    69.859   920.848     0.150
    69.859  1484.461     0.150
    69.859  1679.371     0.150
    69.859   665.320     0.150
    69.859   687.820     0.150
    69.859   819.320     0.150
    69.859   920.820     0.150
    69.859  1212.020     0.150
    69.859  1484.418     0.150
    70.402   668.320     0.150
    70.588   671.320     0.150
    70.588   671.359     0.150
    70.745   672.219     0.150
    70.745   672.238     0.150
    71.033   673.918     0.150
    71.033   674.008     0.150
    71.042   673.918     0.150
    71.042   673.980     0.150
    71.430   676.219     0.150
    71.430   676.289     0.150
    71.370   676.418     0.150
    71.370   676.461     0.150
    71.576   677.219     0.150
    71.576   677.238     0.150
    72.145   681.090     0.150
    72.751   682.820     0.150
    72.751    20.098     0.150
    73.245   686.570     0.150
    73.245   692.930     0.150
    73.245     7.441     0.150
    73.404   687.621     0.150
    73.477   688.121     0.150
    73.476  1523.820     0.150
    73.581   689.020     0.150
    73.593   690.309     0.150
    73.623   688.020     0.150
    73.627   689.070     0.150
    73.627   689.020     0.150
    73.647   688.020     0.150
    73.650   688.621     0.150
    73.687   689.219     0.150
    73.757   690.004     0.150
    73.898   690.219     0.150
    73.927   692.441     0.150
    74.193   692.309     0.150
    74.193   692.219     0.150
    74.524   690.383     0.150
    74.524   690.418     0.150
    74.666   695.520     0.150
    74.666   695.539     0.150
    74.787   695.918     0.150
    74.951   696.020     0.150
    74.957   696.621     0.150
    74.957   709.820     0.150
    74.967   697.121     0.150
    75.215   698.836     0.150
    75.215   712.012     0.150
    75.298   698.270     0.150
    75.310   697.820     0.150
    75.310   698.410     0.150
    75.314   698.320     0.150
    75.316   699.918     0.150
    75.316    16.602     0.150
    75.483   699.875     0.150
    75.502    12.801     0.150
    75.852   701.840     0.150
    75.852   701.809     0.150
    75.852   715.043     0.150
    75.907   701.250     0.150
    75.915   702.863     0.150
    75.915   715.824     0.150
    76.211   702.121     0.150
    76.458   705.621     0.150
    76.458   705.559     0.150
    76.517   704.520     0.150
    76.799   707.121     0.150
    76.950   707.680     0.150
    76.985   708.828     0.150
    77.629   710.551     0.150
    77.629   710.520     0.150
    77.631   712.031     0.150
    77.747   710.934     0.150
    78.036   712.621     0.150
    78.143   713.988     0.150
    78.445   715.516     0.150
    78.523   718.184     0.150
    78.523   718.219     0.150
    78.523   717.719     0.150
    78.540   716.320     0.150
    78.793   720.477     0.150
    78.793   720.520     0.150
    78.913   719.719     0.150
    78.913   719.801     0.150
    78.979   718.184     0.150
    79.028   718.918     0.150
    79.141   719.320     0.150
    79.403   716.520     0.150
    79.403  1309.621     0.150
    79.403  1827.621     0.150
    79.457   721.629     0.150
    79.630   720.094     0.150
    79.906  1014.520     0.150
    79.906  1638.520     0.150
    79.906  1841.719     0.150
    80.280   735.363     0.150
    80.554   727.449     0.150
    81.098   732.621     0.150
    81.243   731.121     0.150
    81.543   734.219     0.150
    81.675   734.621     0.150
    81.902   733.520     0.150
    81.902   734.719     0.150
    82.011   733.859     0.150
    82.379   736.520     0.150
    82.515   737.418     0.150
    82.513   738.520     0.150
    82.544   737.488     0.150
    25.948   742.480     0.150
    25.948   745.418     0.150
    83.050   740.711     0.150
    83.050   755.121     0.150
    83.063   741.719     0.150
    83.313   743.418     0.150
    83.895   746.770     0.150
    83.859   749.820     0.150
    84.231   747.918     0.150
    84.879   748.340     0.150
    84.995   754.621     0.150
    85.062   749.484     0.150
    85.748   758.320     0.150
    86.137   758.020     0.150
    86.419   756.559     0.150
    89.825   773.230     0.150
    89.825   787.719     0.150
    93.292   789.879     0.150
    98.681   813.520     0.150
    98.681   828.121     0.150
   120.433  1127.098     0.150
   140.724  1156.121     0.150
   146.315  1174.871     0.150
   152.656  1188.691     0.150
     1.949    58.730     0.150
     3.264    90.871     0.150
    86.425    52.000     0.150
     3.508    51.402     0.150
     3.604    56.109     0.150
     4.403    64.223     0.150
    94.682    66.531     0.150
     4.431    64.680     0.150
     4.472    67.531     0.150
     4.489    65.820     0.150
     4.891    73.242     0.150
     4.893    70.051     0.150
     5.381    78.141     0.150
    24.532   313.855     0.150
    24.532   314.652     0.150
    42.920  3187.027     0.150
    42.926  3187.336     0.150
    42.938  3187.020     0.150
    44.087  3272.875     0.150
    44.101  3278.434     0.150
    44.105  3267.398     0.150
    64.630   633.609     0.150
    65.820   639.684     0.150
    70.334   668.543     0.150
    70.334   668.539     0.150
     1.726    51.781     0.150
     3.822    55.211     0.150
    86.272    62.477     0.150
    74.408    63.102     0.150
     8.330   117.492     0.150
   100.434   129.008     0.150
    10.071   139.586     0.150
    10.087   142.289     0.150
    10.517   147.086     0.150
    11.064   156.320     0.150
    11.441   284.750     0.150
    12.836   185.992     0.150
    16.052   221.477     0.150
    18.408   251.141     0.150
    20.653   276.289     0.150
    20.653   276.391     0.150
    23.713   307.758     0.150
    23.713   307.789     0.150
    24.739   316.711     0.150
    25.242   534.578     0.150
    25.242   534.578     0.150
    26.461   333.789     0.150
    43.910   363.781     0.150
    35.615   369.336     0.150
    30.975   372.797     0.150
    30.975   372.789     0.150
    31.193   371.891     0.150
    31.193   371.930     0.150
    31.847   381.820     0.150
    31.847   552.688     0.150
    33.771   395.188     0.150
    65.161   400.836     0.150
    35.922   417.312     0.150
    35.922   417.289     0.150
    83.944   417.852     0.150
    36.137   921.391     0.150
    36.137   416.289     0.150
    36.300     9.039     0.150
    36.300   419.992     0.150
    36.300     9.852     0.150
    36.300   419.992     0.150
    36.672   421.586     0.150
    36.672   421.539     0.150
    37.379   427.391     0.150
    38.387   436.188     0.150
    38.462   436.586     0.150
    40.499   454.688     0.150
    40.640   455.336     0.150
    40.764   455.406     0.150
    40.764   455.688     0.150
    97.547   462.922     0.150
    43.050   578.789     0.150
    43.714  3299.852     0.150
    43.719  3300.250     0.150
    43.732  3301.164     0.150
    44.333   487.781     0.150
    44.300   590.039     0.150
    44.877  3388.016     0.150
    44.891  3387.688     0.150
    44.895  3386.000     0.150
    45.897   595.133     0.150
    45.897   497.688     0.150
    45.897   497.188     0.150
    45.960   499.289     0.150
    46.061   497.289     0.150
    46.218   501.086     0.150
    46.749   599.336     0.150
    46.961   505.469     0.150
    47.006   597.891     0.150
    47.075   507.188     0.150
    48.844   529.391     0.150
    48.844   538.992     0.150
    49.078   525.086     0.150
    50.857   535.688     0.150
    51.086   536.992     0.150
    51.105   536.492     0.150
    51.150   538.586     0.150
    51.824   543.852     0.150
    51.824   542.086     0.150
    52.199   547.086     0.150
    53.050     7.000     0.150
    53.975   558.188     0.150
    54.747   564.086     0.150
    55.071   565.891     0.150
    55.080   630.312     0.150
    55.080   567.891     0.150
    55.080   630.289     0.150
    55.435   568.188     0.150
    55.435   568.586     0.150
    55.622   571.531     0.150
    55.689   631.617     0.150
    55.689   570.688     0.150
    55.689   631.586     0.150
    55.739    10.500     0.150
    55.739    14.203     0.150
    57.361   580.086     0.150
    57.361   713.688     0.150
    58.443  1077.086     0.150
    59.408   597.992     0.150
    60.148    12.000     0.150
    60.618   603.789     0.150
    61.774     9.203     0.150
    63.790   626.188     0.150
    63.997   626.891     0.150
    64.061   629.883     0.150
    64.128   631.641     0.150
    64.232   630.883     0.150
    64.514    12.500     0.150
    64.514  1152.289     0.150
    64.854   632.188     0.150
    65.127    11.500     0.150
    65.288   636.148     0.150
    65.288   638.062     0.150
    66.199   641.586     0.150
    66.199   779.289     0.150
    66.199   643.180     0.150
    66.305   643.891     0.150
    66.305   644.078     0.150
    66.305   641.586     0.150
    68.213   656.039     0.150
    68.213   656.047     0.150
    68.213   656.586     0.150
    68.756   672.586     0.150
    68.862   659.977     0.150
    69.009   662.391     0.150
    69.163   662.961     0.150
    69.224    11.500     0.150
    69.475   661.391     0.150
    69.475   675.789     0.150
    69.789   664.391     0.150
    70.374   670.633     0.150
    70.520   671.328     0.150
    70.681   671.797     0.150
    70.681   671.797     0.150
    70.681   930.039     0.150
    70.681  1477.383     0.150
    70.681  1697.133     0.150
    70.681   671.789     0.150
    70.681   692.789     0.150
    70.681   827.688     0.150
    70.681   929.992     0.150
    70.681  1225.789     0.150
    70.827   673.281     0.150
    71.229   674.672     0.150
    71.243   675.719     0.150
    71.187   675.820     0.150
    71.296   675.258     0.150
    71.296   675.289     0.150
    71.389   676.781     0.150
    72.006   680.492     0.150
    72.028   681.148     0.150
    72.627   684.188     0.150
    72.627   684.398     0.150
    72.627   682.492     0.150
    72.627   684.289     0.150
    72.627   684.633     0.150
    72.775  1241.992     0.150
    73.490   689.086     0.150
    73.592   688.992     0.150
    73.804   688.391     0.150
    73.804   690.258     0.150
    73.804   690.289     0.150
    73.804    11.797     0.150
    73.804  1256.789     0.150
    73.804  1292.789     0.150
    73.804  1556.789     0.150
    73.804  1736.789     0.150
    73.804  1838.789     0.150
    73.804  1982.789     0.150
    73.840   688.492     0.150
    73.917   689.289     0.150
    74.000   690.820     0.150
    74.023   689.188     0.150
    74.255   689.992     0.150
    74.285   693.430     0.150
    74.325   690.688     0.150
    74.325   854.195     0.150
    74.350    12.703     0.150
    74.408   694.586     0.150
    74.408   692.992     0.150
    74.416   692.789     0.150
    74.416   692.891     0.150
    74.416   693.195     0.150
    74.564   691.688     0.150
    74.594   695.648     0.150
    74.605   695.781     0.150
    74.655   695.586     0.150
    74.692   695.688     0.150
    74.734   696.188     0.150
    74.845   696.992     0.150
    74.902   697.188     0.150
    74.914   695.742     0.150
    74.914   694.961     0.150
    75.103   697.992     0.150
    75.191   698.688     0.150
    75.196   698.688     0.150
    75.309   698.742     0.150
    75.309   698.789     0.150
    75.286     8.000     0.150
    75.462   699.789     0.150
    75.462   699.789     0.150
    75.509   700.586     0.150
    75.689   701.891     0.150
    75.689   700.789     0.150
    75.909   703.789     0.150
    75.912   702.617     0.150
    75.917   703.578     0.150
    75.928   702.391     0.150
    75.952   703.188     0.150
    75.956   703.469     0.150
    76.006   702.586     0.150
    76.131   704.781     0.150
    76.170   705.375     0.150
    76.298   704.586     0.150
    76.352   704.688     0.150
    76.392   706.102     0.150
    76.440   704.492     0.150
    76.440   704.492     0.150
    76.446   704.992     0.150
    76.770   708.578     0.150
    76.818   708.281     0.150
    76.832   708.883     0.150
    76.797   708.891     0.150
    76.845   708.812     0.150
    76.906   709.352     0.150
    76.906   709.359     0.150
    77.014   708.188     0.150
    77.407   711.789     0.150
    77.490   712.906     0.150
    77.637   713.188     0.150
    77.638   713.102     0.150
    77.657   712.992     0.150
    77.754   714.047     0.150
    77.832   712.609     0.150
    77.971   715.297     0.150
    78.283  1305.391     0.150
    78.530   717.289     0.150
    78.596   718.688     0.150
    78.670   718.852     0.150
    79.130   721.445     0.150
    79.151   721.789     0.150
    79.352   722.352     0.150
    79.352   722.289     0.150
    79.370   722.086     0.150
    79.436   723.391     0.150
    79.643   723.891     0.150
    79.683   724.547     0.150
    79.714   722.789     0.150
    79.714   724.391     0.150
    79.756   723.688     0.150
    79.772  1325.891     0.150
    79.814  1011.992     0.150
    79.814  1836.188     0.150
    79.838   724.891     0.150
    79.858   724.500     0.150
    79.928   725.586     0.150
    79.931   725.391     0.150
    79.975   725.086     0.150
    80.106   726.188     0.150
    80.422   729.227     0.150
    80.465   727.672     0.150
    80.472   728.289     0.150
    80.480   917.086     0.150
    80.480  1029.086     0.150
    80.480  1850.188     0.150
    80.447   728.586     0.150
    80.527   726.789     0.150
    80.653   729.586     0.150
    80.679   729.586     0.150
    81.002   731.289     0.150
    81.200   739.891     0.150
    81.195   731.992     0.150
    81.465   732.688     0.150
    81.531   732.891     0.150
    81.541   732.391     0.150
    27.401   734.617     0.150
    27.401   735.945     0.150
    27.401   735.992     0.150
    81.607   734.086     0.150
    81.765   733.688     0.150
    81.814   735.633     0.150
    81.814   739.086     0.150
    81.814   735.586     0.150
    81.823   735.086     0.150
    81.901   741.391     0.150
    82.585   732.492     0.150
    82.960   741.867     0.150
    82.960   740.633     0.150
    83.047   742.891     0.150
    83.295   743.117     0.150
    83.295   743.797     0.150
    83.400   743.891     0.150
    83.543   748.188     0.150
    83.644   743.906     0.150
    83.659   744.312     0.150
    83.910   746.891     0.150
    84.108   744.617     0.150
    84.130   747.289     0.150
    84.297   747.922     0.150
    84.339   746.445     0.150
    84.543   749.391     0.150
    84.923   752.891     0.150
    84.931   751.992     0.150
    84.995   751.992     0.150
    85.220   753.367     0.150
    85.397   753.688     0.150
    85.443   752.508     0.150
    85.760   753.617     0.150
    85.793   755.031     0.150
    87.371   761.898     0.150
    87.481   764.680     0.150
    88.154   766.945     0.150
    88.906   767.219     0.150
    89.219   770.188     0.150
    90.486   780.352     0.150
    90.486   783.992     0.150
    93.638   792.391     0.150
    93.638   792.289     0.150
    94.770   798.492     0.150
    96.611   806.406     0.150
    97.004  1805.141     0.150
    97.004   806.188     0.150
    99.009   816.492     0.150
    99.009   817.086     0.150
   121.258  1128.289     0.150
   121.258  1130.438     0.150
   124.661  1136.070     0.150
   125.165  1136.086     0.150
   134.526  1152.492     0.150
   147.430  1176.969     0.150
   156.904  1189.039     0.150
     0.468    20.566     0.150
     1.090    19.707     0.150
     1.368    24.270     0.150
     1.803    30.648     0.150
     1.852    31.398     0.150
     1.852    31.168     0.150
     1.852    57.770     0.150
     1.933    33.707     0.150
     1.933    60.738     0.150
     2.048    34.488     0.150
     2.134    33.637     0.150
     3.110    45.367     0.150
     3.162    48.039     0.150
     3.885    56.707     0.150
     4.019    59.648     0.150
    74.596    64.078     0.150
     4.525   112.711     0.150
     4.525    65.188     0.150
     4.525    62.762     0.150
     4.525    65.270     0.150
     4.525   118.770     0.150
     7.598   108.137     0.150
     8.189   114.770     0.150
     8.219   116.469     0.150
     8.447   118.629     0.150
     8.447   118.668     0.150
     9.214   129.367     0.150
     9.444   132.027     0.150
     9.492   132.309     0.150
    10.070   139.668     0.150
    11.099   157.270     0.150
    11.423   157.168     0.150
    11.423   157.168     0.150
    16.149   396.145     0.150
    16.126   223.039     0.150
    17.855   443.691     0.150
    17.855   443.699     0.150
    20.837   279.289     0.150
    23.770   309.180     0.150
    24.843   317.270     0.150
    25.348   537.078     0.150
    26.375   334.168     0.150
    31.326   376.887     0.150
    31.740   553.246     0.150
    31.740   775.020     0.150
    34.794   497.367     0.150
    35.635   417.469     0.150
    36.242   421.812     0.150
    36.255     9.020     0.150
    36.255   421.270     0.150
    36.266   428.664     0.150
    36.275   412.988     0.150
    36.305     3.500     0.150
    36.305   759.770     0.150
    36.305   907.668     0.150
    36.305   928.168     0.150
    36.305   419.078     0.150
    36.305   419.066     0.150
    36.720   424.270     0.150
    36.836   424.469     0.150
    37.380   430.168     0.150
    38.075   437.168     0.150
    39.465   447.668     0.150
    40.735   457.668     0.150
    40.928   458.340     0.150
    40.959   460.289     0.150
    40.959   460.719     0.150
    41.306   835.270     0.150
    41.306  1048.066     0.150
    43.187   855.668     0.150
    43.646  3299.848     0.150
    43.652  3299.195     0.150
    43.664  3298.648     0.150
    44.412   591.387     0.150
    44.807  3382.695     0.150
    44.821  3384.379     0.150
    44.825  3382.941     0.150
    45.471     6.000     0.150
    45.949    12.699     0.150
    45.972   500.879     0.150
    45.972   500.738     0.150
    45.972   500.770     0.150
    45.972   500.398     0.150
    45.972   500.367     0.150
    46.070   501.270     0.150
    46.227   501.129     0.150
    46.365   504.168     0.150
    46.353   503.957     0.150
    46.654   831.668     0.150
    47.121   508.770     0.150
    47.200   509.969     0.150
    47.200   510.078     0.150
    47.527   511.168     0.150
    48.266    10.301     0.150
    48.266    15.000     0.150
    49.001   603.168     0.150
    49.001   690.367     0.150
    50.222   532.270     0.150
    50.692   538.066     0.150
    50.823   537.469     0.150
    50.823   537.469     0.150
    51.250   541.066     0.150
    51.819   544.406     0.150
    51.928   546.219     0.150
    51.928   546.367     0.150
    52.043   988.898     0.150
    52.298   548.969     0.150
    52.956   554.297     0.150
    52.956   554.297     0.150
    53.187    10.699     0.150
    53.187  1020.668     0.150
    53.769   559.738     0.150
    54.904   567.270     0.150
    55.237   631.449     0.150
    55.237   869.449     0.150
    55.237   570.367     0.150
    55.237   631.469     0.150
    55.620   572.188     0.150
    55.620   571.867     0.150
    55.873   573.469     0.150
    57.550  1167.270     0.150
    57.706    12.000     0.150
    58.654    14.199     0.150
    58.654  1073.168     0.150
    59.554    11.699     0.150
    59.554  1093.469     0.150
    59.657   600.469     0.150
    61.898    11.301     0.150
    61.898    14.000     0.150
    63.185   628.719     0.150
    63.720   625.270     0.150
    63.907  1140.668     0.150
    64.191    10.699     0.150
    64.191  1398.969     0.150
    64.299   634.098     0.150
    64.417   633.363     0.150
    64.667  1148.168     0.150
    64.984   637.680     0.150
    65.048   635.840     0.150
    65.048   636.668     0.150
    65.378   635.270     0.150
    65.378  1155.066     0.150
    65.378  1408.066     0.150
    65.367   639.867     0.150
    65.462   640.648     0.150
    66.378   645.367     0.150
    66.485   646.168     0.150
    66.485   646.363     0.150
    66.510  1172.469     0.150
    66.677     7.699     0.150
    66.677  1180.168     0.150
    66.944   649.566     0.150
    66.944   649.562     0.150
    68.373   658.867     0.150
    68.373   659.258     0.150
    68.947   914.367     0.150
    69.344   665.137     0.150
    69.344  1211.828     0.150
    69.666   665.969     0.150
    69.666   916.066     0.150
    69.973   663.113     0.150
    70.554   672.617     0.150
    70.554  1226.129     0.150
    70.699   673.496     0.150
    70.699  1227.617     0.150
    70.868   674.188     0.150
    70.868   674.188     0.150
    70.868   933.246     0.150
    70.868  1700.289     0.150
    70.868   674.168     0.150
    70.868   831.168     0.150
    70.868   933.168     0.150
    70.868  1228.969     0.150
    70.868  1501.668     0.150
    71.008   675.648     0.150
    71.053   674.770     0.150
    71.053   674.828     0.150
    71.311     6.801     0.150
    71.425   678.027     0.150
    71.368   677.879     0.150
    71.571   678.777     0.150
    72.203   683.527     0.150
    72.319   682.738     0.150
    72.585   677.566     0.150
    72.810   686.566     0.150
    72.810   686.840     0.150
    72.849   686.512     0.150
    72.856   686.066     0.150
    73.278   688.668     0.150
    73.432  1273.844     0.150
    73.550  1279.461     0.150
    73.673   691.180     0.150
    73.768   690.441     0.150
    73.768  1281.191     0.150
    73.778   691.469     0.150
    73.980   692.598     0.150
    73.980  1279.895     0.150
    73.980   692.066     0.150
    73.980     8.500     0.150
    73.980   861.168     0.150
    73.980   960.168     0.150
    73.980  1265.168     0.150
    73.980  1311.168     0.150
    73.980  1742.168     0.150
    73.980  1844.168     0.150
    73.980  1994.168     0.150
    74.008  1281.629     0.150
    74.068   694.770     0.150
    74.462  1276.012     0.150
    74.462   695.598     0.150
    74.501   694.738     0.150
    74.501   694.949     0.150
    74.476    11.699     0.150
    74.559  1281.629     0.150
    74.596   695.469     0.150
    74.604   695.789     0.150
    74.604   695.727     0.150
    74.604   695.469     0.150
    74.744  1284.680     0.150
    74.752  1286.812     0.150
    74.780   697.637     0.150
    74.790   697.957     0.150
    74.834   697.867     0.150
    74.840  1290.273     0.150
    74.871   698.270     0.150
    74.913   698.566     0.150
    74.913   698.566     0.150
    74.955   699.539     0.150
    75.021   699.168     0.150
    75.083  1286.406     0.150
    75.080   699.668     0.150
    75.370   701.168     0.150
    75.373   700.770     0.150
    75.483  1295.457     0.150
    75.483   701.668     0.150
    75.466     9.500     0.150
    75.466  1273.469     0.150
    75.642   702.469     0.150
    75.689   703.168     0.150
    76.095   705.051     0.150
    76.131   705.770     0.150
    76.182   706.168     0.150
    76.182   874.566     0.150
    76.182  1292.969     0.150
    76.246  1303.238     0.150
    76.351   707.562     0.150
    76.529   707.566     0.150
    76.575   708.281     0.150
    76.611   707.867     0.150
    76.611   707.859     0.150
    76.821    12.199     0.150
    76.949   710.641     0.150
    76.999   710.535     0.150
    77.028   710.648     0.150
    77.086   711.508     0.150
    77.236   711.027     0.150
    77.202   710.668     0.150
    77.589   714.066     0.150
    77.589   714.465     0.150
    77.670   714.371     0.150
    77.777   713.578     0.150
    77.822   714.867     0.150
    77.843   714.969     0.150
    78.259   717.387     0.150
    78.714   719.566     0.150
    78.780   720.168     0.150
    79.235   720.270     0.150
    79.337   724.066     0.150
    79.495  1325.770     0.150
    79.539   724.648     0.150
    79.539   724.566     0.150
    79.557   724.770     0.150
    79.877   724.668     0.150
    79.877  1843.969     0.150
    79.877   726.590     0.150
    79.897   726.344     0.150
    79.897   726.270     0.150
    79.943   726.969     0.150
    80.008   721.168     0.150
    80.008  1318.367     0.150
    80.008  1844.668     0.150
    80.024   727.066     0.150
    80.112   727.566     0.150
    80.119   727.566     0.150
    80.163   727.566     0.150
    80.304  1325.867     0.150
    80.293   728.367     0.150
    80.672   908.867     0.150
    80.672  1019.566     0.150
    80.672  1644.969     0.150
    80.672  1859.367     0.150
    80.706   730.590     0.150
    80.706   730.777     0.150
    80.706   728.770     0.150
    80.837   731.770     0.150
    80.867   731.527     0.150
    80.867   731.566     0.150
    80.867   731.633     0.150
    81.181   733.566     0.150
    81.468   735.789     0.150
    27.352   737.477     0.150
    27.352   736.367     0.150
    81.656   735.258     0.150
    81.656   735.270     0.150
    81.656   735.414     0.150
    81.914   736.270     0.150
    81.948   735.148     0.150
    81.948   735.168     0.150
    81.948   735.367     0.150
    81.947   737.316     0.150
    82.171   736.969     0.150
    82.291   738.969     0.150
    82.369   739.117     0.150
    82.935  1360.109     0.150
    83.069   743.027     0.150
    83.069   742.770     0.150
    83.223   743.770     0.150
    83.205   743.227     0.150
    83.241   745.539     0.150
    83.154   743.746     0.150
    83.429   743.598     0.150
    83.446   745.156     0.150
    83.436  