#!/bin/bash
gmt begin simeonof10.15_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-36/36/-36/36
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation simeonof10.15'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000    20.650    20.650
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.919     8.021
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.582    -2.740
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.284    12.123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.709     8.791
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.518    10.805
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.629    12.007
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.909    14.624
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.760    20.931
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.760    20.931 8
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.087    12.911
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.201    22.920
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.201    22.920 10
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.929    -1.430
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.096    14.286
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.928     7.887
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.043    12.482
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.172     5.756
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.585     5.575
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.245    11.845
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.170    32.640
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.170    32.640 18
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.443     4.253
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000    13.982
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.993    18.897
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.871    12.688
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.354    32.975
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.354    32.975 23
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.669     9.464
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.578    18.757
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.728     1.929
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.659    11.082
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.836     9.036
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.680    13.110
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.124    22.731
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    13.124    22.731 30
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.390    22.735
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.390    22.735 31
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.695     4.778
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.546    10.419
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.487    30.518
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.487    30.518 34
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.957    27.749
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.957    27.749 35
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000    25.177
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.000    25.177 36
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.867    19.893
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.405    25.430
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.405    25.430 38
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.371    21.256
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.371    21.256 39
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.018    14.198
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.699    12.899
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.294    20.796
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.294    20.796 42
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.825     6.900
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.694     1.258
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.187    -0.213
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.595     1.021
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.558     1.558
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.820     8.192
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.704     6.359
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.176    30.138
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.176    30.138 50
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.814    -2.363
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.450     5.906
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.231    10.497
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.765    15.681
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.442    17.707
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.342     8.121
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.369    14.591
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.011    15.492
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.488    10.307
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.981    12.826
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.459    13.243
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.840    11.402
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.993     7.767
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.574    16.815
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.230    12.523
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.956     1.221
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.449     7.747
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.440    -2.994
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.483    -4.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.783     8.948
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.496    16.837
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.374     4.984
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.794    -5.431
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.156     2.241
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.785     0.136
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.670     3.159
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.807    -6.014
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.162    19.945
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.162    19.945 78
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.480     4.726
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.768    16.658
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.347     0.466
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.631     2.333
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.031    -4.884
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.960     3.231
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.234    13.424
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.364     2.968
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.181     1.889
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.874     9.190
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.264    10.661
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.988     2.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.905    -8.755
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.614     9.343
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.328    11.100
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.409     8.328
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.179    20.068
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.970     1.104
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.387    16.983
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.229    13.574
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.256     2.454
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.438    -5.983
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.992     7.670
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.718    -3.133
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.504    -4.522
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.402    23.424
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    16.402    23.424 104
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.316    15.640
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.984     3.438
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.553     2.220
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.392    -2.603
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.231     6.231
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.977     9.851
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.919     2.391
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.797     5.668
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.957    -1.932
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.215     4.935
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.330     1.311
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.042    -1.206
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.109     6.629
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.487     5.966
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.846     4.382
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.360     4.439
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.725    -2.707
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.286    27.102
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.286    27.102 122
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.985    -0.314
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.637     5.976
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.323     0.145
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.547    12.077
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.210     1.874
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.722    -4.134
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.275     4.371
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.069     5.042
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.747     5.662
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.060     7.875
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.911    10.619
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.966     6.360
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.509    18.905
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.328    15.656
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.023     3.202
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.428    -0.060
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.734    12.862
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.395    -1.178
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.878    -3.408
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.789    -2.255
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.841     6.391
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.674    10.563
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.535     6.018
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.768     8.464
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.848    -2.875
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.572     2.232
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.715    -8.828
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.784    12.758
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.178    -8.770
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.969    -0.697
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.696   -10.213
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.856    -2.506
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.032    -5.494
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.411     3.745
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.659     2.655
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.682    19.014
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.235     0.720
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.064    13.914
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.880    -1.492
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.102    -4.167
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.641     3.701
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.391     4.475
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.470    15.316
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.704     1.438
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.944    12.746
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.303     0.127
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.822    -1.701
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.810     3.495
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.771     6.803
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.917     7.682
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.156    -1.450
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.079    -4.459
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.429     3.714
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.567    -6.101
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.607    -0.241
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.074   -13.304
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.916    10.758
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.616    -7.787
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.183    -1.005
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.624     2.043
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.507     4.507
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.123    -0.353
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.263     5.457
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.178    -1.178
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.536     4.472
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.674    -6.415
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.133     1.647
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.323    -5.826
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.036     4.459
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.912     9.525
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.566     0.449
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.816    -0.407
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.861     9.379
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.289     6.116
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.300     9.250
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.920     3.227
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.286     5.178
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.143    10.084
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.049     3.497
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.409     5.905
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.257     1.032
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.984    -7.659
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.183     2.351
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.770    -1.030
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.199     5.653
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.038    -8.728
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.361     9.964
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    18.019    -1.260
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.309     3.073
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.225    -1.303
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.577     3.533
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.421   -15.191
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.676    -3.523
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.378   -10.820
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.746    -4.893
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.338    -3.713
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.536    -1.854
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.108    -5.473
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.145    21.849
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.145    21.849 221
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.167     8.088
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.178    -0.222
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.638     9.432
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.725     4.128
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.079    -7.621
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.718     2.048
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.388     9.066
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.040     2.224
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.777    -3.017
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.444     6.557
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.499    -5.758
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.527    -3.429
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.757    -1.116
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.370    -3.390
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.687    -6.053
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.364    19.080
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.372     7.077
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.287     5.263
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.625    -2.050
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.960     1.371
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.515    -2.889
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.279    10.374
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.528     1.415
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.093    -4.922
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.041    -3.002
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.726     3.422
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.228     3.506
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.320     1.450
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.145    -2.318
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.245    -7.065
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.299    -0.901
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.378    -3.777
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.056    -3.209
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.352     6.957
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.563     3.602
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.271    -1.725
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.536     4.812
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.820     4.070
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.206    -0.148
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.479    -6.628
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.996     4.847
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.949     2.128
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.762    -8.873
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.413     4.207
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.204    -0.714
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.832    -3.974
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.535    -4.446
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.260     0.278
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.781   -13.242
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.389   -20.617
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    13.389   -20.617 271
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.467     2.786
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.335    13.339
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.530     1.271
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.686     8.686
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.428    -3.494
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.059    13.276
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.615     0.889
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.453    -3.424
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.859    -5.922
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.317    -4.914
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.889    -3.207
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.632     3.117
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.940    -0.347
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.936    -8.511
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.098     0.749
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.138     5.706
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.518     1.993
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.699    -2.468
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.075    -3.687
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.847     0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.897     0.190
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.453     9.204
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.207    -9.190
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.696     3.150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.904    -4.449
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.569    -0.809
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.244     4.182
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.872    -1.795
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.619    -2.758
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.830    -3.503
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.583     3.438
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.348    -1.639
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.422    12.028
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.900     1.835
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.326    -0.816
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.375    -3.555
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.102    -3.607
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.460     1.407
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.556     3.861
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.604    -1.670
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.763    -3.902
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.414    -6.814
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.755     0.445
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.949     3.866
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.676    18.104
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.676    18.104 316
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.751    -2.324
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.801    -2.994
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.747    -8.747
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.855   -12.005
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.099    -0.872
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.243     5.243
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.464    -5.234
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.490    -5.562
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.191    -9.865
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.101     0.706
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.432    -0.660
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.457     4.882
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.383    -6.093
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.835    -0.398
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.572    -4.085
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.032    -0.175
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.135     7.097
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.999    -5.085
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.697    -1.919
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.571     1.205
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.722    -3.677
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.246    -9.776
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.046     0.704
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.142     6.581
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.106    14.983
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.888    11.966
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.489    -1.498
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.371     5.794
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.569   -11.128
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.359     3.041
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.778     1.545
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.545     3.627
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.054     3.267
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.541    -0.448
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.840    -4.674
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.007   -13.491
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.836     3.141
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.237    -3.300
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.776     0.817
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.359     6.727
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.587     4.380
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.337    -6.378
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.387     0.164
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.043    -5.703
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.835     2.635
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.417     1.333
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.409    -4.452
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.205     0.784
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.133     1.970
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.969     5.389
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.010    -1.725
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.708     5.611
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.973    16.861
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.826    -4.161
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.941     3.713
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.704    -3.517
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.731     4.463
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.204    -9.903
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.850    15.863
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.097     6.956
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.352     2.332
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.750     2.968
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.770     6.526
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.259    13.106
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.544     1.353
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.357    -2.333
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.933   -13.369
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.933   -13.369 383
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.984     7.976
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.545     4.238
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.682     4.768
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.431    13.623
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.897     1.040
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.860    12.662
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.132     0.159
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.313     0.640
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.193     7.449
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.644     2.155
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.107    -0.213
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.714    -1.888
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.041     3.703
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.562    -0.115
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.845    -1.332
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.950     5.776
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.963     7.943
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.280     5.285
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.723     4.640
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.420    -3.189
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.259    -1.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.949    13.070
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.076    -8.159
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.389    -3.915
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.459    -4.439
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.209     0.143
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.693    -2.329
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.760     1.198
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.121    11.264
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.838     8.620
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.020    11.890
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.753     4.787
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.663    -2.693
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.019    -1.704
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.788     9.617
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.724     9.161
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.358    -3.749
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.834    11.583
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.189     8.569
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.182     0.821
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.913     4.944
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.401     5.564
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.405    -0.328
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.485     1.496
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.641     0.793
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.315    -0.902
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.291    -2.855
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.592     7.270
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.880    -3.210
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.594     4.837
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.026     7.555
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.880     1.467
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.770    -1.550
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.717    12.894
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.392     0.657
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.877     2.423
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.791     7.103
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.788    10.139
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.908     3.310
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.024   -13.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.918   -15.446
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.868     2.864
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.990     4.872
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.047    -1.352
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.587    -5.760
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.611     6.836
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.858     1.088
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.131     4.278
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.467     0.061
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.242    -1.602
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.058     2.852
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.481     7.198
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.375    -4.985
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.459     7.430
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.882     1.686
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.173    -5.281
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.055     4.363
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.401     2.541
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.377     0.376
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.835    -3.789
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.273     7.532
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.458   -13.941
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.481    -0.868
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.658   -14.099
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.658   -14.099 467
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.246     2.811
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.927     9.485
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.532     9.670
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.556    15.402
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.829    12.055
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.082    11.415
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.844    12.067
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.878    11.782
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.309    10.060
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.728    20.835
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.728    20.835 477
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.491    28.431
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.491    28.431 478
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.325    14.680
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.467     0.849
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.384    -2.115
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.759    -1.595
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.573    23.748
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.573    23.748 483
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.741     2.310
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.488    -9.488
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.315     0.983
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.448    -1.845
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.824     9.418
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.154     8.850
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.409    -0.077
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.659     2.691
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.733    -5.145
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.723     1.382
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.926    11.996
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.941    17.959
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.215    12.339
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.822    -1.482
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.754     2.727
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.052    14.601
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.823     2.603
EOF
gmt plot $proj $reg -SE -Gred << EOF
     6.615     3.664     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -34.000    34.000 Author: all ( 500 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -34.000   -34.000 Average =   7.6 km at  61.0 deg; median =   10.3 km
EOF
gmt end
