#!/bin/bash
gmt begin simeonof10.15_ell pdf,ps
proj=-JM16.0c+
reg=-R-161.5/-155.8/54.0/56.4
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map simeonof10.15'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Cross-section locations
gmt plot $proj $reg -S=0.1 -Wthicker,blue << EOF
  -159.807    54.681   155.000 68.0k
EOF
gmt plot $proj $reg -S=0.1 -Wthicker,blue << EOF
  -159.807    54.681   155.000 -156.3k
EOF
gmt plot $proj $reg -S=0.1 -Wthin,blue << EOF
  -159.807    54.681   245.000 2.5k
EOF
gmt plot $proj $reg -S=0.1 -Wthin,blue << EOF
  -159.807    54.681   245.000 -2.5k
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -160.432    54.888   -72.733     2.398     2.891
  -160.519    54.947    73.754     2.511     3.694
  -159.990    54.761    80.976     3.600     6.125
  -159.933    54.682    76.856     3.505     4.399
  -159.602    54.670   -81.431     1.520     2.140
  -159.662    54.817   -85.818     2.844     4.766
  -159.526    54.720   -79.369     2.173     3.480
  -159.716    54.679   -80.614     2.098     3.001
  -160.153    54.703    89.698     3.320     5.363
  -160.101    54.771   -85.831     2.708     4.473
  -161.380    54.795   -77.411     3.359     6.069
  -159.797    54.677   -80.456     2.324     3.935
  -160.781    54.557    72.358     2.036     3.216
  -160.510    54.780    66.425     3.390     7.753
  -160.438    54.880    85.350     1.211     1.603
  -160.112    54.947    72.091     2.175     3.223
  -160.517    54.961    86.753     1.295     1.784
  -159.820    54.531    58.039     2.778     7.147
  -161.262    54.684   -76.731     1.575     2.108
  -160.346    54.809   -77.716     3.613     4.502
  -160.989    54.430    64.599     3.801     6.723
  -161.051    54.574    51.552     2.970     4.994
  -161.043    54.385   -27.371     1.118     4.969
  -160.890    54.646   -78.777     3.478     5.270
  -160.550    55.046   -89.683     2.563     4.294
  -159.890    54.743    83.333     2.088     3.816
  -160.409    54.801    72.985     2.723     6.465
  -159.944    54.708    77.403     2.366     3.433
  -159.601    54.761    81.477     1.620     3.480
  -160.322    54.671    76.819     2.813     7.205
  -160.918    54.350    67.964     2.223     4.458
  -160.008    54.797    88.645     2.049     3.877
  -160.723    54.544    76.981     1.303     2.293
  -160.479    54.312   -60.531     4.340     4.702
  -160.491    54.979    68.871     1.983     4.709
  -160.142    54.659    79.300     2.159     3.337
  -160.131    54.518    54.782     3.463     6.345
  -159.835    54.698    74.125     2.421     5.525
  -159.572    54.964    78.929     3.259     7.274
  -159.694    55.115   -78.556     1.246     2.921
  -161.118    54.427   -74.185     0.818     1.777
  -160.866    54.582    82.273     2.775     5.457
  -160.491    54.982    75.683     2.071     4.132
  -160.427    54.923   -77.928     0.629     1.236
  -160.404    54.717    67.338     2.374     6.965
  -160.398    54.885    66.279     2.269     7.175
  -161.265    55.583   -87.490     1.738     3.803
  -160.503    55.007   -76.808     0.621     1.183
  -160.518    54.983   -77.542     0.638     1.202
  -160.575    54.774    86.037     3.023     3.771
  -160.343    54.962   -79.884     1.250     2.336
  -161.247    54.719   -75.901     0.647     1.137
  -159.905    54.710    74.066     1.821     3.457
  -159.893    54.705    72.265     2.499     5.097
  -158.307    55.465    66.650     2.450     5.007
  -160.368    54.801    75.712     2.311     4.801
  -160.150    54.674   -77.732     1.166     2.068
  -160.125    54.681    71.177     2.507     5.652
  -160.426    55.208    73.455     2.737     5.657
  -160.857    54.410    70.922     2.320     5.677
  -158.482    54.918    68.426     2.123     5.337
  -159.485    55.051    73.746     1.472     3.574
  -159.825    54.731    74.603     1.466     3.380
  -160.789    54.433    69.818     2.832     6.625
  -160.835    54.399    80.012     2.010     4.975
  -159.239    54.862    62.859     1.699     5.478
  -159.527    54.785   -85.773     1.063     1.638
  -160.589    54.719    79.391     2.090     5.322
  -160.743    54.780    70.865     2.452     6.771
  -158.598    55.442   -81.444     0.831     1.422
  -158.544    55.372   -87.590     1.551     1.939
  -159.692    55.132    64.900     1.570     2.933
  -159.574    55.225    47.655     2.126     3.694
  -158.458    55.762    83.102     1.273     1.862
  -158.612    55.245    61.170     1.372     3.278
  -158.604    54.835    73.396     2.163     4.115
  -160.071    54.193    87.854     1.518     2.280
  -160.904    54.370    67.547     1.570     2.979
  -160.450    54.710    69.386     4.858     8.701
  -159.515    55.124    76.031     3.977     9.060
  -159.825    54.693    69.009     1.684     4.431
  -159.156    54.902    67.100     1.214     3.437
  -157.910    56.065    63.263     2.453     3.927
  -160.550    54.709    71.622     1.980     4.096
  -159.935    54.735    70.376     1.870     3.986
  -159.328    55.075    73.752     1.145     1.404
  -159.255    54.813    62.580     2.161     4.550
  -160.495    54.941    70.721     1.217     2.013
  -160.213    54.589    73.248     2.257     5.308
  -159.044    55.592    71.447     1.157     1.568
  -159.825    54.635    73.987     2.598     6.013
  -159.975    54.774    87.127     2.323     3.844
  -159.673    54.566    80.451     1.494     3.651
  -160.865    54.386    74.079     2.318     4.683
  -160.870    54.358    74.303     1.146     1.647
  -160.828    54.386    67.097     2.510     6.631
  -160.824    54.319    70.326     2.451     5.418
  -159.804    54.623    71.276     2.233     5.360
  -159.588    55.166    61.813     1.989     3.924
  -159.030    54.846    65.894     2.147     5.685
  -160.948    54.436    68.172     1.960     3.557
  -157.598    55.748    85.473     2.495     4.300
  -157.402    56.234    49.539     1.577     3.315
  -161.176    54.425    56.570     1.612     2.269
  -160.975    54.481    79.257     3.656     6.392
  -160.691    54.513    79.386     2.097     3.397
  -159.893    54.708    76.045     1.438     2.365
  -158.593    54.894    66.584     1.844     4.266
  -159.544    55.057    64.026     1.222     1.764
  -160.824    54.335    80.662     2.507     4.222
  -160.101    54.860    79.273     2.473     5.514
  -160.657    54.534    86.016     2.222     7.795
  -159.254    56.332    38.710     1.472     2.971
  -160.305    54.475    75.251     2.174     4.236
  -158.727    55.939    54.170     1.455     3.052
  -158.562    55.016    66.761     1.090     1.551
  -158.521    55.118    59.201     2.537     4.960
  -159.384    55.163    55.717     0.871     1.288
  -158.662    54.916    63.898     1.341     2.939
  -158.831    55.098    62.732     1.097     1.704
  -158.488    54.922    64.964     1.296     2.206
  -160.743    54.602    61.373     1.565     2.336
  -158.400    54.880    77.686     1.894     3.732
  -158.374    54.882   -88.376     2.178     3.776
  -159.629    55.178    59.290     2.321     4.797
  -160.648    54.665    89.512     2.531     5.112
  -159.345    55.204    66.758     0.965     1.305
  -159.336    55.145    54.426     1.973     3.361
  -158.476    55.119    57.887     2.238     4.378
  -158.864    55.059    60.178     1.730     3.582
  -160.429    54.791   -66.873     4.251     5.961
  -160.363    54.824    80.372     3.135     6.297
  -159.846    54.624    72.278     3.208     4.241
  -159.636    55.163    65.377     1.179     1.594
  -160.811    54.678    60.766     1.684     2.538
  -160.778    54.687    61.896     1.257     1.888
  -159.686    55.197    61.699     1.792     3.513
  -159.344    55.214    62.479     1.275     2.409
  -160.763    54.493    79.028     2.220     3.456
  -160.848    54.912    66.573     0.936     1.582
  -160.136    54.935    74.023     2.135     6.392
  -159.350    55.225    58.565     1.667     3.884
  -160.588    54.267    81.429     1.901     3.996
  -160.386    54.766    75.677     1.974     3.003
  -158.835    55.073    62.615     1.032     1.702
  -160.214    54.682    66.160     1.179     2.002
  -160.434    54.931    69.922     1.503     4.384
  -160.470    54.946    62.428     0.972     1.771
  -160.489    54.979    68.344     1.706     4.623
  -159.234    54.943    56.557     1.758     4.799
  -159.609    55.172    60.850     1.490     3.827
  -160.418    54.837    67.015     2.509     5.104
  -160.494    54.984    61.214     1.462     2.701
  -160.435    54.882    70.931     1.690     4.760
  -160.362    54.921    64.117     2.809     6.058
  -160.393    54.911    71.948     1.519     4.208
  -160.450    54.977    65.169     0.863     1.362
  -161.155    54.527    58.209     1.286     2.050
  -160.457    54.918    71.471     1.946     5.082
  -160.948    54.514    85.828     2.397     5.224
  -158.331    54.941    70.539     1.301     2.137
  -158.508    55.119    63.018     2.261     5.080
  -161.077    54.574    77.526     2.129     4.794
  -159.862    54.892    70.461     1.628     3.175
  -160.474    54.539    68.159     1.490     2.684
  -159.235    54.943    60.270     1.534     3.813
  -161.082    54.532    80.645     1.565     2.609
  -160.368    54.841    82.855     2.312     4.321
  -159.594    55.172    53.642     1.839     2.906
  -160.372    54.834    78.183     2.211     3.795
  -161.287    54.766    72.594     1.341     2.140
  -160.565    54.217    79.740     2.418     4.801
  -160.418    54.909    72.354     2.042     5.212
  -158.478    54.944    68.813     1.301     2.192
  -158.698    54.891    59.862     2.296     5.761
  -160.477    54.977    69.093     1.542     4.399
  -160.346    54.856    81.085     2.176     3.722
  -160.462    54.944    64.669     2.020     5.340
  -160.961    54.539    84.517     2.172     4.810
  -159.726    55.246    61.885     1.676     4.335
  -160.507    55.003    70.020     1.820     3.615
  -160.424    54.862    75.214     1.745     4.214
  -160.548    54.225    80.272     2.080     4.018
  -160.435    54.935    72.846     1.821     4.674
  -159.894    54.887    72.994     1.960     3.447
  -160.454    54.939    69.185     1.074     1.835
  -160.251    54.632    77.571     2.274     4.986
  -160.669    54.716    82.906     2.022     6.257
  -161.017    54.869    73.918     1.851     3.850
  -159.611    55.186    62.660     2.178     5.284
  -160.886    54.414    76.309     2.667     5.455
  -160.710    54.707   -82.526     1.627     2.672
  -158.586    55.083    56.550     1.809     4.638
  -159.333    54.723    68.012     1.392     2.979
  -160.986    54.499    83.092     1.818     3.848
  -159.802    54.753    74.992     1.461     3.499
  -159.886    54.875    83.313     1.423     2.459
  -159.786    54.584    66.308     0.934     1.310
  -159.750    54.458    63.920     2.197     3.960
  -159.805    54.387    72.525     3.314     4.693
  -159.751    54.422    77.520     2.607     4.946
  -159.804    54.332    72.083     2.519     6.627
  -159.737    54.334    64.620     2.168     3.690
  -159.777    54.439    72.185     2.982     5.655
  -159.835    54.520    65.002     4.601     7.290
  -159.960    54.327    59.871     2.455     3.825
  -159.813    54.355    76.623     2.752     5.366
  -159.800    54.494    74.897     3.862     4.916
  -159.899    54.258    61.780     2.298     3.163
  -159.808    54.410    66.732     3.460     6.190
  -159.961    54.267   -89.043     3.669     6.126
  -159.769    54.285    72.155     2.319     3.602
  -159.749    54.595    63.128     2.082     3.530
  -159.922    54.415    46.626     4.271     7.710
  -159.726    54.481    62.137     2.121     2.887
  -159.826    54.286    46.646     2.702     3.107
  -159.766    54.429    74.166     2.670     4.185
  -159.695    54.539    73.209     2.752     4.068
  -159.903    54.274    63.649     2.313     3.163
  -159.760    54.460    64.039     2.278     4.227
  -159.777    54.388    82.621     2.304     3.341
  -159.731    54.496    79.380     3.111     6.305
  -159.688    54.483    68.722     2.191     2.962
  -159.761    54.582    67.851     2.409     4.185
  -159.738    54.436    68.476     1.950     4.642
  -159.654    54.330    55.432     2.539     3.472
  -159.755    54.376    72.224     1.946     2.842
  -159.639    54.238    72.782     2.707     4.013
  -159.805    54.245    76.620     2.026     5.202
  -159.686    54.468    63.217     2.250     3.642
  -159.715    54.205    79.631     2.555     4.983
  -159.603    54.369    59.946     2.730     3.284
  -159.919    54.358    63.282     3.192     4.660
  -159.772    54.336    69.292     2.447     5.903
  -159.833    54.509    57.583     1.963     3.082
  -159.742    54.298    61.900     2.004     3.014
  -159.798    54.511    61.524     3.548     6.760
  -159.747    54.571    65.968     1.756     3.413
  -159.756    54.547    70.391     2.142     4.531
  -159.737    54.270    64.685     2.389     4.840
  -159.628    54.307    83.656     1.419     2.105
  -159.888    54.292    70.579     2.119     3.167
  -159.827    54.308    75.488     2.717     4.885
  -159.766    54.310    68.876     3.197     5.158
  -159.778    54.417    69.968     2.039     4.200
  -159.775    54.221    68.087     2.451     3.302
  -159.790    54.263    72.749     2.935     5.223
  -159.809    54.391    69.629     2.661     6.157
  -159.746    54.371    74.528     2.545     4.519
  -159.786    54.265    67.602     2.853     6.168
  -159.785    54.374    60.571     2.675     3.880
  -159.905    54.334    67.577     2.575     4.284
  -159.785    54.481    73.354     2.980     6.001
  -159.716    54.536    63.398     1.680     2.658
  -159.773    54.618    64.724     1.410     2.326
  -159.757    54.447    71.500     2.292     5.124
  -159.734    54.368    67.495     3.376     7.586
  -159.813    54.295    71.311     2.351     5.293
  -159.778    54.218    73.768     2.330     5.323
  -159.842    54.437    64.147     1.756     2.802
  -159.735    54.377    59.708     2.388     4.425
  -159.789    54.266    76.070     2.247     3.576
  -159.789    54.274    69.113     2.795     4.929
  -159.787    54.421    78.237     2.492     4.789
  -159.684    54.293    77.603     3.592     7.535
  -159.757    54.375    78.012     2.803     6.088
  -159.785    54.357    71.628     2.017     4.827
  -159.770    54.539    74.502     2.325     5.227
  -159.651    54.443    73.032     3.862     9.069
  -159.693    54.490    64.288     2.271     4.283
  -159.797    54.440    63.940     2.381     5.610
  -159.880    54.568    69.033     1.745     2.981
  -159.836    54.525    64.193     2.650     4.766
  -159.746    54.249    78.751     2.394     5.548
  -159.746    54.581    70.882     1.966     4.403
  -159.742    54.451    68.059     1.609     3.983
  -159.801    54.396    67.547     2.555     4.115
  -159.833    54.362    73.136     2.552     5.921
  -159.660    54.294    64.451     1.647     2.463
  -159.590    54.438    82.995     3.579     5.550
  -159.651    54.422    58.644     2.333     2.901
  -159.766    54.504    71.331     1.622     4.404
  -159.792    54.280    73.635     2.119     5.813
  -159.761    54.322    73.820     2.593     6.071
  -159.858    54.215    60.933     2.172     4.035
  -159.702    54.456    66.101     1.848     3.208
  -159.751    54.499    64.574     1.929     3.274
  -159.734    54.535    64.433     1.966     3.207
  -159.601    54.323    83.811     4.109     6.284
  -159.872    54.409    54.782     2.978     4.516
  -159.791    54.090    79.255     2.673     4.544
  -159.739    54.417    71.435     2.308     4.859
  -159.861    54.391    68.410     2.739     6.215
  -159.817    54.428    67.769     2.643     6.524
  -159.788    54.315    69.484     2.012     4.820
  -159.785    54.322    71.408     1.796     3.643
  -159.684    54.257    77.839     2.350     4.506
  -159.684    54.570    83.176     1.964     2.548
  -159.768    54.183    70.907     2.454     5.862
  -159.734    54.130    73.212     2.438     5.853
  -159.781    54.335    84.307     3.394     4.878
  -159.710    54.455    65.642     3.357     4.888
  -159.752    54.368    71.716     2.081     5.141
  -159.868    54.525    58.052     3.552     6.141
  -159.654    54.527    65.862     1.451     2.228
  -159.727    54.482    65.440     1.565     3.193
  -159.765    54.262    66.469     1.528     3.711
  -159.777    54.636    70.093     2.139     4.436
  -160.411    54.919    73.425     3.170     5.104
  -159.764    54.250    69.127     2.182     4.854
  -159.874    54.400    65.099     2.032     4.879
  -159.840    54.372    66.675     2.328     4.982
  -159.766    54.403    64.695     1.717     3.672
  -159.646    54.636    69.711     2.055     4.147
  -159.854    54.477    65.467     1.704     2.807
  -160.486    54.770    58.217     2.032     3.447
  -159.778    54.064    69.607     2.103     4.690
  -159.853    54.342    71.787     1.693     4.001
  -159.763    54.332    72.181     1.766     4.604
  -159.759    54.170    75.703     3.183     4.281
  -159.783    54.074    78.145     1.662     4.030
  -159.759    54.577    74.808     1.316     3.052
  -159.885    54.467    71.153     1.825     4.759
  -159.762    54.509    72.559     1.724     4.151
  -159.813    54.269    76.307     1.789     4.596
  -159.691    54.510    88.775     2.770     5.482
  -159.982    54.201    83.791     2.144     4.647
  -159.758    54.156    80.185     1.855     4.953
  -159.733    54.392    82.218     1.837     3.098
  -159.726    54.527    76.070     1.413     2.144
  -159.822    54.392    73.833     1.902     5.006
  -159.775    54.315    80.527     1.975     4.938
  -159.781    54.563    73.070     1.582     3.766
  -159.730    54.473    82.577     2.396     4.883
  -159.845    54.483    71.797     1.862     4.354
  -159.415    54.514    75.087     1.631     2.592
  -159.790    54.573    77.059     1.692     4.415
  -159.823    54.449    73.984     2.127     4.550
  -159.768    54.417    72.827     1.732     3.341
  -159.771    54.517    63.860     1.859     2.857
  -158.269    55.386    62.976     2.730     4.928
  -160.380    54.896    78.202     1.978     3.545
  -159.812    54.385    73.979     2.231     5.908
  -159.793    54.580    67.589     3.231     7.243
  -159.833    54.226    61.646     2.169     3.318
  -159.821    54.099    75.116     1.763     3.919
  -159.729    54.641    66.683     2.901     5.594
  -159.822    54.428    78.110     1.474     4.186
  -159.833    54.425    73.552     1.945     4.338
  -159.970    54.294    75.554     2.880     5.622
  -160.081    54.190    81.309     2.291     4.841
  -159.877    54.497    81.779     3.248     6.275
  -159.890    54.288    78.365     2.436     6.191
  -159.821    54.411    73.248     1.986     5.638
  -159.851    54.140    79.191     2.772     5.569
  -159.796    54.267    75.762     1.686     4.102
  -159.821    54.488    76.978     2.027     4.061
  -159.701    54.275    72.304     2.420     6.148
  -159.759    54.569    72.604     1.725     4.045
  -159.803    54.264    77.313     1.820     4.781
  -159.706    55.207    62.299     1.853     4.129
  -159.851    54.532    72.233     1.511     3.693
  -159.876    54.454    65.986     1.857     3.193
  -159.804    54.260    71.488     1.628     4.106
  -159.674    54.534    74.268     1.622     3.758
  -159.622    54.989    68.533     1.875     2.962
  -159.765    54.656    75.650     2.120     3.857
  -159.780    54.649    78.516     2.611     5.562
  -159.733    54.492    72.929     2.362     4.772
  -159.810    54.395    77.584     1.558     4.005
  -159.366    55.277    53.755     2.186     4.682
  -159.619    54.658    75.551     1.384     3.592
  -159.699    54.609    72.801     1.589     2.684
  -159.721    54.559    77.364     2.173     4.823
  -159.817    54.519    77.563     2.559     5.741
  -159.703    54.663    68.695     1.453     2.959
  -159.693    54.526    72.785     2.132     5.203
  -156.582    56.348    42.310     1.480     3.156
  -159.798    54.598    89.673     1.188     1.819
  -160.393    54.764    74.133     2.385     3.649
  -159.898    54.308    74.636     1.837     3.649
  -159.939    54.204    84.929     1.938     4.083
  -159.737    54.439    70.447     2.472     5.722
  -159.766    54.624    77.335     1.562     2.709
  -159.799    54.614    75.916     1.445     3.232
  -159.446    55.411    50.884     1.664     3.211
  -160.930    54.363    71.195     2.771     5.669
  -159.778    54.343    75.098     1.587     4.481
  -159.749    54.645    69.625     1.513     3.582
  -159.801    54.356    71.639     1.860     4.809
  -159.806    54.409    68.104     1.688     3.322
  -159.487    55.004    52.457     2.453     4.130
  -160.440    54.873    65.934     2.238     5.509
  -159.006    55.601    46.688     1.317     3.146
  -159.770    54.600    73.366     1.709     4.696
  -159.807    54.211    79.077     2.026     5.505
  -159.772    54.656    73.214     1.586     4.557
  -159.224    55.214    55.766     1.444     3.287
  -159.855    54.294    77.500     2.026     5.053
  -159.764    54.570    75.237     1.425     3.769
  -159.805    54.429    73.876     1.512     4.142
  -159.558    54.937    67.142     1.475     3.108
  -159.773    54.575    69.831     2.076     4.126
  -159.807    54.410    77.290     1.704     4.881
  -159.731    54.692    74.236     1.385     3.870
  -159.802    54.411    76.649     1.596     4.948
  -160.207    54.601    78.520     2.131     5.680
  -159.789    54.584    79.225     1.623     4.909
  -159.796    54.333    75.387     2.093     4.931
  -159.800    54.318    70.114     1.543     4.275
  -159.807    54.437    75.619     1.581     2.956
  -159.767    54.196    75.269     2.113     5.127
  -159.697    54.587    71.379     2.234     5.726
  -160.277    54.430    80.122     2.901     7.296
  -158.623    55.059    63.931     2.069     6.191
  -159.750    54.595    72.119     1.680     4.617
  -160.321    54.867    66.730     2.299     6.374
  -159.771    54.467    80.942     2.291     5.999
  -158.601    55.062    60.353     1.882     3.856
  -158.397    54.918    65.191     2.672     7.581
  -158.790    55.043    64.274     1.203     2.408
  -158.630    54.996    60.651     1.543     3.541
  -158.636    55.370    61.251     1.646     3.125
  -156.302    55.769    60.045     1.938     4.426
  -158.601    55.428    65.006     1.627     2.662
  -158.640    54.943    60.126     1.654     4.367
  -157.313    56.017    55.822     1.452     3.565
  -159.739    54.526    68.390     1.361     2.443
  -156.596    55.395    58.103     1.601     5.120
  -159.350    55.162    58.567     1.557     4.534
  -156.481    55.057    60.280     2.065     5.217
  -158.732    54.829    67.015     1.353     4.091
  -156.408    55.949    88.788     1.669     2.494
  -160.350    54.805    76.534     2.337     5.371
  -158.893    55.044    67.608     1.239     2.368
  -158.782    54.861    70.278     0.936     1.733
  -155.891    55.486    53.858     1.758     5.340
  -156.701    56.319    49.405     1.814     3.611
  -159.715    54.721    67.366     1.439     3.097
  -156.153    55.736    50.418     2.191     2.978
  -158.854    54.385    67.686     2.421     6.228
  -159.793    54.600    71.566     1.753     4.448
  -159.793    54.673    65.414     1.820     4.634
  -159.723    54.341    73.638     2.290     6.015
  -159.812    54.470    79.642     2.097     3.924
  -159.712    54.530    73.759     1.793     5.225
  -159.900    54.137    78.098     2.374     5.470
  -159.810    54.380    73.881     1.398     4.219
  -159.768    54.584    73.351     1.522     3.860
  -159.801    54.318    72.612     2.353     6.047
  -159.867    54.704    72.470     2.028     3.520
  -159.725    54.730    73.729     1.857     3.249
  -159.653    54.889    71.268     1.424     3.231
  -159.642    54.564    76.765     2.036     2.964
  -159.596    54.799    70.375     1.454     3.105
  -159.513    55.425    42.705     2.941     4.962
  -156.548    56.124    67.782     1.524     2.272
  -159.547    55.023    58.025     1.690     3.412
  -159.778    54.522    69.978     2.054     5.283
  -159.798    54.548    81.671     1.688     2.584
  -160.363    54.897    82.686     0.950     1.714
  -159.545    54.555    67.195     1.771     3.699
  -159.829    54.364    72.898     1.827     4.582
  -160.385    54.831    75.315     1.421     2.260
  -156.863    54.900    89.757     2.274     3.179
  -159.396    55.317    55.016     1.513     5.108
  -159.510    55.445    50.939     1.300     4.801
  -160.863    54.379    70.427     0.853     1.439
  -161.098    54.524    70.878     1.431     2.400
  -160.950    54.565    63.795     2.155     7.725
  -160.883    54.506    59.642     2.012     3.709
  -161.092    54.562    75.158     2.461     5.740
  -160.772    54.713    70.503     1.905     3.099
  -161.039    54.521    68.340     2.965     6.219
  -161.130    54.524    79.320     1.444     2.385
  -161.150    54.573    77.581     0.951     1.401
  -161.099    54.508    72.562     1.715     2.850
  -161.283    54.757    77.847     1.448     2.387
  -161.003    54.285    72.987     1.653     2.319
  -160.925    54.353    69.121     1.675     2.398
  -160.475    54.917    76.544     1.358     2.495
  -160.439    54.932    66.704     1.714     5.225
  -160.474    54.984    69.551     1.138     2.461
  -159.719    54.606    76.363     1.692     2.600
  -160.451    54.874    69.128     2.036     6.494
  -157.090    55.234   -88.317     1.344     1.992
  -159.733    54.122    72.184     2.118     2.963
  -159.779    54.501    84.695     1.233     1.991
  -159.488    55.029    59.225     2.183     6.232
  -160.731    55.029    70.727     2.084     6.055
  -159.496    55.325    52.352     1.532     3.485
  -158.632    55.838    57.296     1.961     5.066
  -159.672    55.198    56.631     1.621     4.242
  -156.438    55.109    63.622     2.934     6.585
  -160.555    54.569    69.235     2.442     4.049
  -160.304    54.573    77.475     2.009     4.729
  -160.234    54.517    62.176     1.361     2.275
  -160.177    54.588    71.666     2.546     5.015
  -160.175    54.536    71.399     3.239     5.546
  -159.956    54.629    63.748     1.429     2.285
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
  -158.562    55.016     0.300
  -159.786    54.584     0.300
  -160.863    54.379     0.300
  -160.555    54.569     0.300
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -161.389    54.018   -69.367     1.176     2.068
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -161.366    54.018   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -161.389    54.018     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -161.389    54.018     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -161.389    53.973   5 km
EOF
gmt end
