#!/bin/bash
gmt begin simeonof10.15_dcal pdf,ps
proj=-JM16.0c+
reg=-R-164.6/-152.7/52.2/58.2
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration simeonof10.15'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
  -160.497    55.341
  -160.432    54.888
>
  -160.497    55.341
  -160.519    54.947
>
  -160.497    55.341
  -159.990    54.761
>
  -160.497    55.341
  -159.933    54.682
>
  -160.497    55.341
  -159.602    54.670
>
  -160.497    55.341
  -159.662    54.817
>
  -160.497    55.341
  -159.526    54.720
>
  -160.497    55.341
  -159.716    54.679
>
  -160.497    55.341
  -160.153    54.703
>
  -160.497    55.341
  -160.101    54.771
>
  -160.497    55.341
  -159.797    54.677
>
  -160.497    55.341
  -160.781    54.557
>
  -160.497    55.341
  -160.510    54.780
>
  -160.497    55.341
  -160.112    54.947
>
  -160.497    55.341
  -160.517    54.961
>
  -160.497    55.341
  -160.517    54.961
>
  -160.497    55.341
  -159.820    54.531
>
  -160.497    55.341
  -160.346    54.809
>
  -160.497    55.341
  -161.051    54.574
>
  -160.497    55.341
  -160.890    54.646
>
  -160.497    55.341
  -160.550    55.046
>
  -160.138    54.978
  -159.890    54.743
>
  -160.138    54.978
  -159.890    54.743
>
  -160.497    55.341
  -159.890    54.743
>
  -160.138    54.978
  -160.409    54.801
>
  -160.138    54.978
  -160.409    54.801
>
  -160.497    55.341
  -160.409    54.801
>
  -161.864    55.148
  -160.409    54.801
>
  -161.742    55.421
  -160.409    54.801
>
  -161.742    55.421
  -160.409    54.801
>
  -161.790    55.374
  -160.409    54.801
>
  -161.856    55.346
  -160.409    54.801
>
  -160.138    54.978
  -159.944    54.708
>
  -160.497    55.341
  -159.944    54.708
>
  -160.138    54.978
  -159.601    54.761
>
  -160.497    55.341
  -159.601    54.761
>
  -160.497    55.341
  -160.322    54.671
>
  -160.477    55.349
  -160.322    54.671
>
  -161.864    55.148
  -160.918    54.350
>
  -162.263    54.966
  -160.918    54.350
>
  -160.497    55.341
  -160.008    54.797
>
  -160.477    55.349
  -160.008    54.797
>
  -160.138    54.978
  -160.723    54.544
>
  -160.497    55.341
  -160.723    54.544
>
  -160.477    55.349
  -160.723    54.544
>
  -161.864    55.148
  -160.723    54.544
>
  -160.497    55.341
  -160.491    54.979
>
  -161.790    55.374
  -160.491    54.979
>
  -161.864    55.148
  -160.491    54.979
>
  -161.904    55.317
  -160.491    54.979
>
  -161.998    55.433
  -160.491    54.979
>
  -160.138    54.978
  -160.142    54.659
>
  -160.477    55.349
  -160.142    54.659
>
  -160.477    55.349
  -160.131    54.518
>
  -160.477    55.349
  -160.131    54.518
>
  -160.477    55.349
  -159.835    54.698
>
  -160.477    55.349
  -159.835    54.698
>
  -160.477    55.349
  -159.572    54.964
>
  -160.477    55.349
  -159.572    54.964
>
  -160.477    55.349
  -159.694    55.115
>
  -162.263    54.966
  -161.118    54.427
>
  -160.477    55.349
  -161.118    54.427
>
  -160.477    55.349
  -160.866    54.582
>
  -160.477    55.349
  -160.866    54.582
>
  -161.856    55.346
  -160.866    54.582
>
  -161.742    55.421
  -160.866    54.582
>
  -161.742    55.421
  -160.866    54.582
>
  -162.281    55.107
  -160.866    54.582
>
  -160.477    55.349
  -160.491    54.982
>
  -160.477    55.349
  -160.491    54.982
>
  -161.864    55.148
  -160.491    54.982
>
  -161.742    55.421
  -160.491    54.982
>
  -161.856    55.346
  -160.491    54.982
>
  -161.921    55.453
  -160.491    54.982
>
  -160.477    55.349
  -160.427    54.923
>
  -160.477    55.349
  -160.427    54.923
>
  -161.864    55.148
  -160.427    54.923
>
  -161.790    55.374
  -160.427    54.923
>
  -161.742    55.421
  -160.427    54.923
>
  -161.856    55.346
  -160.427    54.923
>
  -161.904    55.317
  -160.427    54.923
>
  -160.477    55.349
  -160.404    54.717
>
  -160.477    55.349
  -160.404    54.717
>
  -161.864    55.148
  -160.404    54.717
>
  -160.477    55.349
  -160.398    54.885
>
  -160.477    55.349
  -160.398    54.885
>
  -161.790    55.374
  -160.398    54.885
>
  -161.856    55.346
  -160.398    54.885
>
  -162.263    54.966
  -161.265    55.583
>
  -160.477    55.349
  -160.503    55.007
>
  -160.477    55.349
  -160.503    55.007
>
  -161.864    55.148
  -160.503    55.007
>
  -161.742    55.421
  -160.503    55.007
>
  -161.856    55.346
  -160.503    55.007
>
  -161.921    55.453
  -160.503    55.007
>
  -160.477    55.349
  -160.518    54.983
>
  -160.477    55.349
  -160.518    54.983
>
  -161.864    55.148
  -160.518    54.983
>
  -161.998    55.433
  -160.518    54.983
>
  -160.477    55.349
  -160.575    54.774
>
  -160.477    55.349
  -160.575    54.774
>
  -160.477    55.349
  -160.343    54.962
>
  -160.477    55.349
  -160.343    54.962
>
  -161.864    55.148
  -160.343    54.962
>
  -161.864    55.148
  -161.247    54.719
>
  -161.856    55.346
  -161.247    54.719
>
  -161.790    55.374
  -161.247    54.719
>
  -160.477    55.349
  -161.247    54.719
>
  -160.477    55.349
  -161.247    54.719
>
  -161.921    55.453
  -161.247    54.719
>
  -160.477    55.349
  -159.905    54.710
>
  -160.477    55.349
  -159.905    54.710
>
  -160.477    55.349
  -159.893    54.705
>
  -160.477    55.349
  -159.893    54.705
>
  -159.164    56.221
  -158.307    55.465
>
  -159.562    56.152
  -158.307    55.465
>
  -159.589    54.820
  -160.368    54.801
>
  -160.477    55.349
  -160.368    54.801
>
  -160.477    55.349
  -160.368    54.801
>
  -159.589    54.820
  -160.150    54.674
>
  -159.589    54.820
  -160.150    54.674
>
  -160.477    55.349
  -160.150    54.674
>
  -160.477    55.349
  -160.150    54.674
>
  -159.589    54.820
  -160.125    54.681
>
  -159.589    54.820
  -160.125    54.681
>
  -160.477    55.349
  -160.125    54.681
>
  -160.477    55.349
  -160.125    54.681
>
  -160.477    55.349
  -160.426    55.208
>
  -160.477    55.349
  -160.426    55.208
>
  -159.589    54.820
  -160.426    55.208
>
  -159.589    54.820
  -160.426    55.208
>
  -161.790    55.374
  -160.426    55.208
>
  -161.904    55.317
  -160.426    55.208
>
  -161.921    55.453
  -160.426    55.208
>
  -159.589    54.820
  -160.857    54.410
>
  -159.589    54.820
  -160.857    54.410
>
  -160.477    55.349
  -160.857    54.410
>
  -160.477    55.349
  -160.857    54.410
>
  -159.589    54.820
  -158.482    54.918
>
  -160.477    55.349
  -159.485    55.051
>
  -160.477    55.349
  -159.825    54.731
>
  -160.477    55.349
  -159.825    54.731
>
  -160.477    55.349
  -160.789    54.433
>
  -159.589    54.820
  -160.835    54.399
>
  -159.589    54.820
  -160.835    54.399
>
  -159.589    54.831
  -160.835    54.399
>
  -159.589    54.831
  -160.835    54.399
>
  -160.477    55.349
  -160.835    54.399
>
  -160.477    55.349
  -160.835    54.399
>
  -159.589    54.831
  -159.239    54.862
>
  -159.589    54.831
  -159.239    54.862
>
  -159.589    54.820
  -159.239    54.862
>
  -159.589    54.820
  -159.239    54.862
>
  -160.477    55.349
  -159.239    54.862
>
  -160.477    55.349
  -159.239    54.862
>
  -159.589    54.831
  -159.527    54.785
>
  -159.589    54.820
  -159.527    54.785
>
  -160.477    55.349
  -159.527    54.785
>
  -160.477    55.349
  -159.527    54.785
>
  -159.589    54.820
  -160.589    54.719
>
  -159.589    54.820
  -160.589    54.719
>
  -159.589    54.831
  -160.589    54.719
>
  -159.589    54.831
  -160.589    54.719
>
  -160.477    55.349
  -160.589    54.719
>
  -160.477    55.349
  -160.589    54.719
>
  -161.790    55.374
  -160.589    54.719
>
  -161.742    55.421
  -160.589    54.719
>
  -161.856    55.346
  -160.589    54.719
>
  -161.904    55.317
  -160.589    54.719
>
  -160.477    55.349
  -160.743    54.780
>
  -160.477    55.349
  -160.743    54.780
>
  -161.790    55.374
  -160.743    54.780
>
  -161.856    55.346
  -160.743    54.780
>
  -161.904    55.317
  -160.743    54.780
>
  -161.904    55.317
  -160.743    54.780
>
  -162.281    55.107
  -160.743    54.780
>
  -159.589    54.820
  -158.598    55.442
>
  -159.589    54.820
  -158.598    55.442
>
  -159.085    56.126
  -158.544    55.372
>
  -159.164    56.221
  -158.544    55.372
>
  -159.589    54.820
  -158.544    55.372
>
  -159.589    54.831
  -159.692    55.132
>
  -159.589    54.831
  -159.692    55.132
>
  -159.589    54.820
  -159.692    55.132
>
  -159.589    54.820
  -159.692    55.132
>
  -160.477    55.349
  -159.692    55.132
>
  -160.477    55.349
  -159.692    55.132
>
  -160.477    55.349
  -159.692    55.132
>
  -159.589    54.831
  -159.574    55.225
>
  -159.589    54.831
  -159.574    55.225
>
  -159.589    54.820
  -159.574    55.225
>
  -159.589    54.820
  -159.574    55.225
>
  -159.164    56.221
  -158.458    55.762
>
  -159.553    56.285
  -158.458    55.762
>
  -159.551    56.286
  -158.458    55.762
>
  -159.551    56.286
  -158.458    55.762
>
  -159.551    56.286
  -158.458    55.762
>
  -159.589    54.831
  -158.612    55.245
>
  -159.589    54.820
  -158.612    55.245
>
  -159.589    54.820
  -158.612    55.245
>
  -159.085    56.126
  -158.612    55.245
>
  -159.085    56.126
  -158.612    55.245
>
  -159.589    54.831
  -158.604    54.835
>
  -159.589    54.820
  -158.604    54.835
>
  -159.589    54.820
  -160.071    54.193
>
  -159.589    54.820
  -160.071    54.193
>
  -159.589    54.831
  -160.071    54.193
>
  -159.589    54.831
  -160.071    54.193
>
  -159.589    54.820
  -160.904    54.370
>
  -159.589    54.820
  -160.904    54.370
>
  -159.589    54.831
  -160.904    54.370
>
  -159.589    54.831
  -160.904    54.370
>
  -160.477    55.349
  -160.450    54.710
>
  -160.477    55.349
  -160.450    54.710
>
  -160.477    55.349
  -159.515    55.124
>
  -160.477    55.349
  -159.515    55.124
>
  -159.589    54.820
  -159.825    54.693
>
  -159.589    54.820
  -159.825    54.693
>
  -159.589    54.831
  -159.825    54.693
>
  -159.589    54.831
  -159.825    54.693
>
  -160.477    55.349
  -159.825    54.693
>
  -159.589    54.831
  -159.156    54.902
>
  -159.589    54.831
  -159.156    54.902
>
  -159.589    54.820
  -159.156    54.902
>
  -159.589    54.820
  -159.156    54.902
>
  -160.477    55.349
  -159.156    54.902
>
  -160.477    55.349
  -159.156    54.902
>
  -158.414    56.301
  -157.910    56.065
>
  -158.414    56.301
  -157.910    56.065
>
  -159.553    56.285
  -157.910    56.065
>
  -159.589    54.820
  -160.550    54.709
>
  -159.589    54.820
  -160.550    54.709
>
  -159.589    54.831
  -160.550    54.709
>
  -159.589    54.831
  -160.550    54.709
>
  -160.477    55.349
  -160.550    54.709
>
  -161.742    55.421
  -160.550    54.709
>
  -161.856    55.346
  -160.550    54.709
>
  -161.904    55.317
  -160.550    54.709
>
  -159.589    54.831
  -159.935    54.735
>
  -159.589    54.831
  -159.935    54.735
>
  -159.589    54.820
  -159.935    54.735
>
  -159.589    54.820
  -159.935    54.735
>
  -160.477    55.349
  -159.935    54.735
>
  -160.477    55.349
  -159.935    54.735
>
  -160.477    55.349
  -159.935    54.735
>
  -159.589    54.831
  -159.328    55.075
>
  -159.589    54.831
  -159.328    55.075
>
  -159.589    54.820
  -159.328    55.075
>
  -160.477    55.349
  -159.328    55.075
>
  -160.477    55.349
  -159.328    55.075
>
  -160.477    55.349
  -159.328    55.075
>
  -160.477    55.349
  -159.328    55.075
>
  -159.589    54.831
  -159.255    54.813
>
  -159.589    54.831
  -159.255    54.813
>
  -159.589    54.820
  -159.255    54.813
>
  -159.589    54.820
  -159.255    54.813
>
  -160.477    55.349
  -159.255    54.813
>
  -160.477    55.349
  -159.255    54.813
>
  -160.477    55.349
  -159.255    54.813
>
  -160.477    55.349
  -160.495    54.941
>
  -160.477    55.349
  -160.495    54.941
>
  -160.477    55.349
  -160.495    54.941
>
  -159.589    54.831
  -160.495    54.941
>
  -159.589    54.831
  -160.495    54.941
>
  -159.589    54.820
  -160.495    54.941
>
  -159.589    54.820
  -160.495    54.941
>
  -161.742    55.421
  -160.495    54.941
>
  -161.790    55.374
  -160.495    54.941
>
  -161.856    55.346
  -160.495    54.941
>
  -161.904    55.317
  -160.495    54.941
>
  -161.998    55.433
  -160.495    54.941
>
  -160.477    55.349
  -160.213    54.589
>
  -160.477    55.349
  -160.213    54.589
>
  -160.477    55.349
  -160.213    54.589
>
  -159.085    56.126
  -159.044    55.592
>
  -159.562    56.152
  -159.044    55.592
>
  -159.551    56.286
  -159.044    55.592
>
  -159.551    56.286
  -159.044    55.592
>
  -159.589    54.820
  -159.044    55.592
>
  -160.477    55.349
  -159.044    55.592
>
  -159.589    54.820
  -159.825    54.635
>
  -159.589    54.820
  -159.825    54.635
>
  -160.477    55.349
  -159.825    54.635
>
  -160.477    55.349
  -159.825    54.635
>
  -160.477    55.349
  -159.825    54.635
>
  -159.589    54.831
  -159.975    54.774
>
  -159.589    54.831
  -159.975    54.774
>
  -159.589    54.820
  -159.975    54.774
>
  -160.477    55.349
  -159.975    54.774
>
  -160.477    55.349
  -159.975    54.774
>
  -160.477    55.349
  -159.975    54.774
>
  -159.589    54.820
  -159.673    54.566
>
  -159.589    54.820
  -159.673    54.566
>
  -159.589    54.831
  -159.673    54.566
>
  -159.589    54.831
  -159.673    54.566
>
  -160.477    55.349
  -159.673    54.566
>
  -160.477    55.349
  -159.673    54.566
>
  -160.477    55.349
  -159.673    54.566
>
  -160.477    55.349
  -159.673    54.566
>
  -159.589    54.820
  -160.865    54.386
>
  -159.589    54.820
  -160.865    54.386
>
  -159.589    54.831
  -160.865    54.386
>
  -159.589    54.831
  -160.865    54.386
>
  -160.477    55.349
  -160.865    54.386
>
  -160.477    55.349
  -160.865    54.386
>
  -160.477    55.349
  -160.865    54.386
>
  -159.589    54.820
  -160.870    54.358
>
  -159.589    54.820
  -160.870    54.358
>
  -159.589    54.831
  -160.870    54.358
>
  -159.589    54.831
  -160.870    54.358
>
  -159.589    54.820
  -160.828    54.386
>
  -159.589    54.820
  -160.828    54.386
>
  -160.477    55.349
  -160.828    54.386
>
  -160.477    55.349
  -160.828    54.386
>
  -160.477    55.349
  -160.828    54.386
>
  -159.589    54.820
  -160.824    54.319
>
  -159.589    54.820
  -160.824    54.319
>
  -159.589    54.831
  -160.824    54.319
>
  -159.589    54.831
  -160.824    54.319
>
  -159.589    54.820
  -159.804    54.623
>
  -159.589    54.820
  -159.804    54.623
>
  -159.589    54.831
  -159.804    54.623
>
  -159.589    54.831
  -159.804    54.623
>
  -160.477    55.349
  -159.804    54.623
>
  -160.477    55.349
  -159.804    54.623
>
  -159.589    54.820
  -159.588    55.166
>
  -159.589    54.820
  -159.588    55.166
>
  -160.477    55.349
  -159.588    55.166
>
  -160.477    55.349
  -159.588    55.166
>
  -159.589    54.831
  -159.030    54.846
>
  -159.589    54.831
  -159.030    54.846
>
  -159.589    54.820
  -160.948    54.436
>
  -159.589    54.820
  -160.948    54.436
>
  -159.589    54.831
  -160.948    54.436
>
  -159.589    54.831
  -160.948    54.436
>
  -159.589    54.831
  -160.948    54.436
>
  -158.414    56.301
  -157.598    55.748
>
  -158.414    56.301
  -157.598    55.748
>
  -158.414    56.301
  -157.598    55.748
>
  -159.085    56.126
  -157.598    55.748
>
  -158.414    56.301
  -157.402    56.234
>
  -158.414    56.301
  -157.402    56.234
>
  -158.281    56.802
  -157.402    56.234
>
  -158.059    56.913
  -157.402    56.234
>
  -158.231    56.895
  -157.402    56.234
>
  -159.085    56.126
  -157.402    56.234
>
  -159.085    56.126
  -157.402    56.234
>
  -161.904    55.317
  -161.176    54.425
>
  -159.589    54.820
  -160.975    54.481
>
  -159.589    54.831
  -160.975    54.481
>
  -160.477    55.349
  -160.975    54.481
>
  -160.477    55.349
  -160.975    54.481
>
  -160.477    55.349
  -160.975    54.481
>
  -161.904    55.317
  -160.975    54.481
>
  -159.589    54.820
  -160.691    54.513
>
  -159.589    54.831
  -160.691    54.513
>
  -159.589    54.831
  -160.691    54.513
>
  -159.589    54.831
  -160.691    54.513
>
  -160.477    55.349
  -160.691    54.513
>
  -160.477    55.349
  -160.691    54.513
>
  -160.477    55.349
  -160.691    54.513
>
  -159.589    54.820
  -159.893    54.708
>
  -159.589    54.820
  -159.893    54.708
>
  -159.589    54.831
  -159.893    54.708
>
  -159.589    54.831
  -159.893    54.708
>
  -160.477    55.349
  -159.893    54.708
>
  -160.477    55.349
  -159.893    54.708
>
  -160.477    55.349
  -159.893    54.708
>
  -159.589    54.831
  -158.593    54.894
>
  -159.589    54.831
  -158.593    54.894
>
  -159.589    54.820
  -158.593    54.894
>
  -159.589    54.820
  -158.593    54.894
>
  -159.589    54.831
  -159.544    55.057
>
  -159.589    54.831
  -159.544    55.057
>
  -159.589    54.831
  -159.544    55.057
>
  -159.589    54.831
  -159.544    55.057
>
  -159.589    54.820
  -159.544    55.057
>
  -160.477    55.349
  -159.544    55.057
>
  -160.477    55.349
  -159.544    55.057
>
  -160.477    55.349
  -159.544    55.057
>
  -160.477    55.349
  -159.544    55.057
>
  -160.477    55.349
  -159.544    55.057
>
  -159.368    56.031
  -159.544    55.057
>
  -159.589    54.820
  -160.824    54.335
>
  -159.589    54.820
  -160.824    54.335
>
  -159.589    54.820
  -160.101    54.860
>
  -159.589    54.820
  -160.101    54.860
>
  -160.477    55.349
  -160.101    54.860
>
  -160.477    55.349
  -160.101    54.860
>
  -159.589    54.820
  -160.657    54.534
>
  -159.589    54.820
  -160.657    54.534
>
  -160.477    55.349
  -160.657    54.534
>
  -160.477    55.349
  -160.657    54.534
>
  -161.864    55.148
  -160.657    54.534
>
  -161.864    55.148
  -160.657    54.534
>
  -159.316    56.284
  -159.254    56.332
>
  -159.455    56.227
  -159.254    56.332
>
  -159.551    56.286
  -159.254    56.332
>
  -159.551    56.286
  -159.254    56.332
>
  -159.562    56.152
  -159.254    56.332
>
  -159.368    56.031
  -159.254    56.332
>
  -159.558    56.072
  -159.254    56.332
>
  -158.215    56.966
  -159.254    56.332
>
  -159.589    54.820
  -160.305    54.475
>
  -159.589    54.820
  -160.305    54.475
>
  -160.477    55.349
  -160.305    54.475
>
  -160.477    55.349
  -160.305    54.475
>
  -159.085    56.126
  -158.727    55.939
>
  -159.164    56.221
  -158.727    55.939
>
  -159.368    56.031
  -158.727    55.939
>
  -159.316    56.284
  -158.727    55.939
>
  -159.455    56.227
  -158.727    55.939
>
  -159.558    56.072
  -158.727    55.939
>
  -159.562    56.152
  -158.727    55.939
>
  -159.551    56.286
  -158.727    55.939
>
  -159.551    56.286
  -158.727    55.939
>
  -158.231    56.895
  -158.727    55.939
>
  -159.589    54.831
  -158.562    55.016
>
  -159.589    54.820
  -158.562    55.016
>
  -159.589    54.820
  -158.562    55.016
>
  -159.589    54.820
  -158.521    55.118
>
  -159.589    54.831
  -159.384    55.163
>
  -159.589    54.831
  -159.384    55.163
>
  -159.589    54.831
  -159.384    55.163
>
  -159.589    54.820
  -159.384    55.163
>
  -159.589    54.820
  -159.384    55.163
>
  -160.477    55.349
  -159.384    55.163
>
  -160.477    55.349
  -159.384    55.163
>
  -160.477    55.349
  -159.384    55.163
>
  -160.477    55.349
  -159.384    55.163
>
  -159.558    56.072
  -159.384    55.163
>
  -159.085    56.126
  -159.384    55.163
>
  -159.589    54.831
  -158.662    54.916
>
  -159.589    54.831
  -158.662    54.916
>
  -159.589    54.820
  -158.662    54.916
>
  -159.589    54.831
  -158.831    55.098
>
  -159.589    54.820
  -158.831    55.098
>
  -159.368    56.031
  -158.831    55.098
>
  -160.477    55.349
  -158.831    55.098
>
  -160.477    55.349
  -158.831    55.098
>
  -160.477    55.349
  -158.831    55.098
>
  -159.589    54.831
  -158.488    54.922
>
  -159.589    54.831
  -158.488    54.922
>
  -159.589    54.831
  -158.488    54.922
>
  -159.589    54.820
  -158.488    54.922
>
  -160.477    55.349
  -160.743    54.602
>
  -160.477    55.349
  -160.743    54.602
>
  -160.477    55.349
  -160.743    54.602
>
  -159.589    54.831
  -160.743    54.602
>
  -159.589    54.820
  -160.743    54.602
>
  -161.864    55.148
  -160.743    54.602
>
  -159.589    54.831
  -158.400    54.880
>
  -159.589    54.831
  -158.400    54.880
>
  -159.589    54.820
  -158.400    54.880
>
  -159.589    54.820
  -158.400    54.880
>
  -159.589    54.831
  -158.374    54.882
>
  -159.589    54.831
  -158.374    54.882
>
  -159.589    54.820
  -158.374    54.882
>
  -159.589    54.820
  -158.374    54.882
>
  -159.589    54.831
  -159.629    55.178
>
  -159.589    54.831
  -159.629    55.178
>
  -159.589    54.820
  -159.629    55.178
>
  -159.589    54.820
  -159.629    55.178
>
  -160.477    55.349
  -159.629    55.178
>
  -160.477    55.349
  -159.629    55.178
>
  -160.477    55.349
  -159.629    55.178
>
  -160.477    55.349
  -159.629    55.178
>
  -159.368    56.031
  -159.629    55.178
>
  -159.589    54.831
  -160.648    54.665
>
  -159.589    54.831
  -160.648    54.665
>
  -159.589    54.820
  -160.648    54.665
>
  -159.589    54.820
  -160.648    54.665
>
  -160.477    55.349
  -160.648    54.665
>
  -160.477    55.349
  -160.648    54.665
>
  -160.477    55.349
  -160.648    54.665
>
  -161.864    55.148
  -160.648    54.665
>
  -161.864    55.148
  -160.648    54.665
>
  -161.742    55.421
  -160.648    54.665
>
  -161.856    55.346
  -160.648    54.665
>
  -159.589    54.831
  -159.345    55.204
>
  -159.589    54.831
  -159.345    55.204
>
  -159.589    54.831
  -159.345    55.204
>
  -159.589    54.820
  -159.345    55.204
>
  -159.589    54.820
  -159.345    55.204
>
  -160.477    55.349
  -159.345    55.204
>
  -160.477    55.349
  -159.345    55.204
>
  -160.477    55.349
  -159.345    55.204
>
  -160.477    55.349
  -159.345    55.204
>
  -160.477    55.349
  -159.345    55.204
>
  -159.589    54.820
  -159.336    55.145
>
  -159.589    54.820
  -159.336    55.145
>
  -160.477    55.349
  -159.336    55.145
>
  -160.477    55.349
  -159.336    55.145
>
  -159.368    56.031
  -159.336    55.145
>
  -159.589    54.831
  -158.476    55.119
>
  -159.589    54.820
  -158.476    55.119
>
  -159.589    54.820
  -158.476    55.119
>
  -159.589    54.831
  -158.864    55.059
>
  -159.589    54.831
  -158.864    55.059
>
  -159.589    54.820
  -158.864    55.059
>
  -160.477    55.349
  -158.864    55.059
>
  -160.477    55.349
  -158.864    55.059
>
  -160.477    55.349
  -158.864    55.059
>
  -159.589    54.831
  -160.429    54.791
>
  -159.589    54.820
  -160.429    54.791
>
  -159.589    54.820
  -160.429    54.791
>
  -160.477    55.349
  -160.429    54.791
>
  -160.477    55.349
  -160.429    54.791
>
  -160.477    55.349
  -160.429    54.791
>
  -159.589    54.831
  -160.363    54.824
>
  -159.589    54.820
  -160.363    54.824
>
  -159.589    54.820
  -160.363    54.824
>
  -160.477    55.349
  -160.363    54.824
>
  -160.477    55.349
  -160.363    54.824
>
  -160.477    55.349
  -160.363    54.824
>
  -160.477    55.349
  -160.363    54.824
>
  -161.864    55.148
  -160.363    54.824
>
  -161.864    55.148
  -160.363    54.824
>
  -161.742    55.421
  -160.363    54.824
>
  -161.742    55.421
  -160.363    54.824
>
  -159.589    54.820
  -159.846    54.624
>
  -159.589    54.831
  -159.846    54.624
>
  -160.477    55.349
  -159.846    54.624
>
  -160.477    55.349
  -159.846    54.624
>
  -160.477    55.349
  -159.846    54.624
>
  -159.589    54.831
  -159.636    55.163
>
  -159.589    54.831
  -159.636    55.163
>
  -159.589    54.831
  -159.636    55.163
>
  -159.589    54.831
  -159.636    55.163
>
  -159.589    54.820
  -159.636    55.163
>
  -159.589    54.820
  -159.636    55.163
>
  -160.477    55.349
  -159.636    55.163
>
  -160.477    55.349
  -159.636    55.163
>
  -160.477    55.349
  -159.636    55.163
>
  -160.477    55.349
  -159.636    55.163
>
  -160.477    55.349
  -160.811    54.678
>
  -160.477    55.349
  -160.811    54.678
>
  -160.477    55.349
  -160.811    54.678
>
  -160.477    55.349
  -160.811    54.678
>
  -159.589    54.831
  -160.811    54.678
>
  -159.589    54.820
  -160.811    54.678
>
  -161.864    55.148
  -160.811    54.678
>
  -161.742    55.421
  -160.811    54.678
>
  -161.742    55.421
  -160.811    54.678
>
  -161.856    55.346
  -160.811    54.678
>
  -162.281    55.107
  -160.811    54.678
>
  -160.477    55.349
  -160.778    54.687
>
  -160.477    55.349
  -160.778    54.687
>
  -159.589    54.831
  -160.778    54.687
>
  -159.589    54.820
  -160.778    54.687
>
  -161.864    55.148
  -160.778    54.687
>
  -161.864    55.148
  -160.778    54.687
>
  -161.856    55.346
  -160.778    54.687
>
  -161.856    55.346
  -160.778    54.687
>
  -161.742    55.421
  -160.778    54.687
>
  -161.742    55.421
  -160.778    54.687
>
  -162.252    55.149
  -160.778    54.687
>
  -162.252    55.149
  -160.778    54.687
>
  -162.281    55.107
  -160.778    54.687
>
  -159.589    54.820
  -159.686    55.197
>
  -159.589    54.820
  -159.686    55.197
>
  -160.477    55.349
  -159.686    55.197
>
  -160.477    55.349
  -159.686    55.197
>
  -159.368    56.031
  -159.686    55.197
>
  -159.558    56.072
  -159.686    55.197
>
  -159.589    54.820
  -159.344    55.214
>
  -159.589    54.820
  -159.344    55.214
>
  -160.477    55.349
  -159.344    55.214
>
  -160.477    55.349
  -159.344    55.214
>
  -159.368    56.031
  -159.344    55.214
>
  -159.589    54.820
  -160.763    54.493
>
  -159.589    54.820
  -160.763    54.493
>
  -160.477    55.349
  -160.763    54.493
>
  -160.477    55.349
  -160.763    54.493
>
  -161.864    55.148
  -160.763    54.493
>
  -161.864    55.148
  -160.763    54.493
>
  -160.477    55.349
  -160.848    54.912
>
  -160.477    55.349
  -160.848    54.912
>
  -160.477    55.349
  -160.848    54.912
>
  -160.477    55.349
  -160.848    54.912
>
  -161.864    55.148
  -160.848    54.912
>
  -161.864    55.148
  -160.848    54.912
>
  -161.742    55.421
  -160.848    54.912
>
  -161.742    55.421
  -160.848    54.912
>
  -161.856    55.346
  -160.848    54.912
>
  -161.856    55.346
  -160.848    54.912
>
  -161.998    55.433
  -160.848    54.912
>
  -162.252    55.149
  -160.848    54.912
>
  -162.252    55.149
  -160.848    54.912
>
  -162.281    55.107
  -160.848    54.912
>
  -159.589    54.820
  -160.136    54.935
>
  -159.589    54.820
  -160.136    54.935
>
  -160.477    55.349
  -160.136    54.935
>
  -160.477    55.349
  -160.136    54.935
>
  -159.589    54.820
  -159.350    55.225
>
  -159.589    54.820
  -159.350    55.225
>
  -160.477    55.349
  -159.350    55.225
>
  -160.477    55.349
  -159.350    55.225
>
  -159.368    56.031
  -159.350    55.225
>
  -159.368    56.031
  -159.350    55.225
>
  -159.589    54.820
  -160.588    54.267
>
  -159.589    54.820
  -160.588    54.267
>
  -159.589    54.831
  -160.386    54.766
>
  -159.589    54.820
  -160.386    54.766
>
  -160.477    55.349
  -160.386    54.766
>
  -160.477    55.349
  -160.386    54.766
>
  -160.477    55.349
  -160.386    54.766
>
  -161.864    55.148
  -160.386    54.766
>
  -161.864    55.148
  -160.386    54.766
>
  -159.589    54.831
  -158.835    55.073
>
  -159.589    54.831
  -158.835    55.073
>
  -159.589    54.831
  -158.835    55.073
>
  -159.589    54.820
  -158.835    55.073
>
  -160.477    55.349
  -158.835    55.073
>
  -160.477    55.349
  -158.835    55.073
>
  -160.477    55.349
  -158.835    55.073
>
  -160.477    55.349
  -158.835    55.073
>
  -160.477    55.349
  -158.835    55.073
>
  -159.589    54.820
  -160.214    54.682
>
  -159.589    54.820
  -160.214    54.682
>
  -159.589    54.831
  -160.214    54.682
>
  -159.589    54.831
  -160.214    54.682
>
  -159.589    54.831
  -160.214    54.682
>
  -160.477    55.349
  -160.214    54.682
>
  -160.477    55.349
  -160.214    54.682
>
  -160.477    55.349
  -160.214    54.682
>
  -160.477    55.349
  -160.214    54.682
>
  -160.477    55.349
  -160.434    54.931
>
  -160.477    55.349
  -160.434    54.931
>
  -161.864    55.148
  -160.434    54.931
>
  -161.864    55.148
  -160.434    54.931
>
  -161.742    55.421
  -160.434    54.931
>
  -161.742    55.421
  -160.434    54.931
>
  -161.790    55.374
  -160.434    54.931
>
  -161.856    55.346
  -160.434    54.931
>
  -161.856    55.346
  -160.434    54.931
>
  -161.904    55.317
  -160.434    54.931
>
  -160.477    55.349
  -160.470    54.946
>
  -160.477    55.349
  -160.470    54.946
>
  -160.477    55.349
  -160.470    54.946
>
  -160.477    55.349
  -160.470    54.946
>
  -161.864    55.148
  -160.470    54.946
>
  -161.864    55.148
  -160.470    54.946
>
  -161.742    55.421
  -160.470    54.946
>
  -161.790    55.374
  -160.470    54.946
>
  -161.856    55.346
  -160.470    54.946
>
  -160.477    55.349
  -160.489    54.979
>
  -160.477    55.349
  -160.489    54.979
>
  -160.477    55.349
  -160.489    54.979
>
  -160.477    55.349
  -160.489    54.979
>
  -161.864    55.148
  -160.489    54.979
>
  -161.864    55.148
  -160.489    54.979
>
  -161.742    55.421
  -160.489    54.979
>
  -161.790    55.374
  -160.489    54.979
>
  -161.856    55.346
  -160.489    54.979
>
  -161.904    55.317
  -160.489    54.979
>
  -161.998    55.433
  -160.489    54.979
>
  -159.589    54.820
  -159.234    54.943
>
  -159.589    54.820
  -159.234    54.943
>
  -160.477    55.349
  -159.234    54.943
>
  -159.589    54.831
  -159.609    55.172
>
  -159.589    54.831
  -159.609    55.172
>
  -159.589    54.820
  -159.609    55.172
>
  -159.589    54.820
  -159.609    55.172
>
  -160.477    55.349
  -159.609    55.172
>
  -160.477    55.349
  -159.609    55.172
>
  -160.477    55.349
  -159.609    55.172
>
  -159.368    56.031
  -159.609    55.172
>
  -159.562    56.152
  -159.609    55.172
>
  -159.589    54.831
  -160.418    54.837
>
  -159.589    54.831
  -160.418    54.837
>
  -159.589    54.820
  -160.418    54.837
>
  -159.589    54.820
  -160.418    54.837
>
  -160.477    55.349
  -160.418    54.837
>
  -160.477    55.349
  -160.418    54.837
>
  -160.477    55.349
  -160.418    54.837
>
  -161.864    55.148
  -160.418    54.837
>
  -161.864    55.148
  -160.418    54.837
>
  -161.742    55.421
  -160.418    54.837
>
  -161.742    55.421
  -160.418    54.837
>
  -161.856    55.346
  -160.418    54.837
>
  -161.856    55.346
  -160.418    54.837
>
  -160.477    55.349
  -160.494    54.984
>
  -160.477    55.349
  -160.494    54.984
>
  -160.477    55.349
  -160.494    54.984
>
  -161.864    55.148
  -160.494    54.984
>
  -161.864    55.148
  -160.494    54.984
>
  -161.742    55.421
  -160.494    54.984
>
  -161.856    55.346
  -160.494    54.984
>
  -161.998    55.433
  -160.494    54.984
>
  -159.589    54.820
  -160.435    54.882
>
  -160.477    55.349
  -160.435    54.882
>
  -160.477    55.349
  -160.435    54.882
>
  -161.864    55.148
  -160.435    54.882
>
  -161.864    55.148
  -160.435    54.882
>
  -161.742    55.421
  -160.435    54.882
>
  -161.742    55.421
  -160.435    54.882
>
  -161.856    55.346
  -160.435    54.882
>
  -161.856    55.346
  -160.435    54.882
>
  -161.904    55.317
  -160.435    54.882
>
  -159.589    54.820
  -160.362    54.921
>
  -159.589    54.820
  -160.362    54.921
>
  -160.477    55.349
  -160.362    54.921
>
  -160.477    55.349
  -160.362    54.921
>
  -161.864    55.148
  -160.362    54.921
>
  -161.864    55.148
  -160.362    54.921
>
  -161.742    55.421
  -160.362    54.921
>
  -161.742    55.421
  -160.362    54.921
>
  -161.856    55.346
  -160.362    54.921
>
  -161.856    55.346
  -160.362    54.921
>
  -159.589    54.820
  -160.393    54.911
>
  -160.477    55.349
  -160.393    54.911
>
  -160.477    55.349
  -160.393    54.911
>
  -161.864    55.148
  -160.393    54.911
>
  -161.864    55.148
  -160.393    54.911
>
  -161.742    55.421
  -160.393    54.911
>
  -161.742    55.421
  -160.393    54.911
>
  -161.790    55.374
  -160.393    54.911
>
  -161.856    55.346
  -160.393    54.911
>
  -161.856    55.346
  -160.393    54.911
>
  -161.904    55.317
  -160.393    54.911
>
  -160.477    55.349
  -160.450    54.977
>
  -160.477    55.349
  -160.450    54.977
>
  -160.477    55.349
  -160.450    54.977
>
  -160.477    55.349
  -160.450    54.977
>
  -160.477    55.349
  -160.450    54.977
>
  -159.589    54.831
  -160.450    54.977
>
  -159.589    54.831
  -160.450    54.977
>
  -159.589    54.831
  -160.450    54.977
>
  -161.864    55.148
  -160.450    54.977
>
  -161.864    55.148
  -160.450    54.977
>
  -161.742    55.421
  -160.450    54.977
>
  -161.742    55.421
  -160.450    54.977
>
  -161.790    55.374
  -160.450    54.977
>
  -161.856    55.346
  -160.450    54.977
>
  -161.904    55.317
  -160.450    54.977
>
  -161.998    55.433
  -160.450    54.977
>
  -161.864    55.148
  -161.155    54.527
>
  -161.864    55.148
  -161.155    54.527
>
  -160.477    55.349
  -161.155    54.527
>
  -160.477    55.349
  -161.155    54.527
>
  -160.477    55.349
  -161.155    54.527
>
  -161.904    55.317
  -161.155    54.527
>
  -161.856    55.346
  -161.155    54.527
>
  -161.790    55.374
  -161.155    54.527
>
  -162.281    55.107
  -161.155    54.527
>
  -161.742    55.421
  -161.155    54.527
>
  -161.742    55.421
  -161.155    54.527
>
  -160.477    55.349
  -160.457    54.918
>
  -160.477    55.349
  -160.457    54.918
>
  -159.589    54.820
  -160.457    54.918
>
  -159.589    54.820
  -160.457    54.918
>
  -161.864    55.148
  -160.457    54.918
>
  -161.742    55.421
  -160.457    54.918
>
  -161.742    55.421
  -160.457    54.918
>
  -161.790    55.374
  -160.457    54.918
>
  -161.856    55.346
  -160.457    54.918
>
  -161.856    55.346
  -160.457    54.918
>
  -161.904    55.317
  -160.457    54.918
>
  -160.477    55.349
  -160.948    54.514
>
  -160.477    55.349
  -160.948    54.514
>
  -160.477    55.349
  -160.948    54.514
>
  -160.477    55.349
  -160.948    54.514
>
  -159.589    54.820
  -160.948    54.514
>
  -159.589    54.820
  -160.948    54.514
>
  -159.589    54.831
  -160.948    54.514
>
  -161.864    55.148
  -160.948    54.514
>
  -161.864    55.148
  -160.948    54.514
>
  -161.904    55.317
  -160.948    54.514
>
  -161.856    55.346
  -160.948    54.514
>
  -161.856    55.346
  -160.948    54.514
>
  -161.790    55.374
  -160.948    54.514
>
  -162.281    55.107
  -160.948    54.514
>
  -162.281    55.107
  -160.948    54.514
>
  -162.252    55.149
  -160.948    54.514
>
  -162.252    55.149
  -160.948    54.514
>
  -159.589    54.820
  -158.331    54.941
>
  -159.589    54.820
  -158.331    54.941
>
  -159.589    54.820
  -158.508    55.119
>
  -161.864    55.148
  -161.077    54.574
>
  -161.864    55.148
  -161.077    54.574
>
  -160.477    55.349
  -161.077    54.574
>
  -160.477    55.349
  -161.077    54.574
>
  -161.904    55.317
  -161.077    54.574
>
  -161.856    55.346
  -161.077    54.574
>
  -161.856    55.346
  -161.077    54.574
>
  -162.281    55.107
  -161.077    54.574
>
  -162.281    55.107
  -161.077    54.574
>
  -162.252    55.149
  -161.077    54.574
>
  -161.742    55.421
  -161.077    54.574
>
  -161.742    55.421
  -161.077    54.574
>
  -159.589    54.831
  -159.862    54.892
>
  -159.589    54.820
  -159.862    54.892
>
  -159.589    54.820
  -159.862    54.892
>
  -160.477    55.349
  -159.862    54.892
>
  -160.477    55.349
  -159.862    54.892
>
  -160.477    55.349
  -159.862    54.892
>
  -159.589    54.820
  -160.474    54.539
>
  -159.589    54.820
  -160.474    54.539
>
  -159.589    54.831
  -160.474    54.539
>
  -159.589    54.831
  -160.474    54.539
>
  -160.477    55.349
  -160.474    54.539
>
  -160.477    55.349
  -160.474    54.539
>
  -160.477    55.349
  -160.474    54.539
>
  -159.589    54.820
  -159.235    54.943
>
  -159.589    54.820
  -159.235    54.943
>
  -160.477    55.349
  -159.235    54.943
>
  -160.477    55.349
  -159.235    54.943
>
  -161.864    55.148
  -161.082    54.532
>
  -161.864    55.148
  -161.082    54.532
>
  -160.477    55.349
  -161.082    54.532
>
  -160.477    55.349
  -161.082    54.532
>
  -160.477    55.349
  -161.082    54.532
>
  -159.589    54.831
  -161.082    54.532
>
  -161.904    55.317
  -161.082    54.532
>
  -161.856    55.346
  -161.082    54.532
>
  -161.856    55.346
  -161.082    54.532
>
  -162.281    55.107
  -161.082    54.532
>
  -162.252    55.149
  -161.082    54.532
>
  -161.742    55.421
  -161.082    54.532
>
  -161.742    55.421
  -161.082    54.532
>
  -159.589    54.831
  -160.368    54.841
>
  -159.589    54.820
  -160.368    54.841
>
  -159.589    54.820
  -160.368    54.841
>
  -160.477    55.349
  -160.368    54.841
>
  -160.477    55.349
  -160.368    54.841
>
  -160.477    55.349
  -160.368    54.841
>
  -161.864    55.148
  -160.368    54.841
>
  -161.864    55.148
  -160.368    54.841
>
  -161.790    55.374
  -160.368    54.841
>
  -161.742    55.421
  -160.368    54.841
>
  -161.742    55.421
  -160.368    54.841
>
  -161.856    55.346
  -160.368    54.841
>
  -161.856    55.346
  -160.368    54.841
>
  -159.589    54.831
  -159.594    55.172
>
  -159.589    54.831
  -159.594    55.172
>
  -159.589    54.820
  -159.594    55.172
>
  -159.589    54.820
  -159.594    55.172
>
  -160.477    55.349
  -159.594    55.172
>
  -160.477    55.349
  -159.594    55.172
>
  -160.477    55.349
  -159.594    55.172
>
  -159.368    56.031
  -159.594    55.172
>
  -159.589    54.831
  -160.372    54.834
>
  -159.589    54.820
  -160.372    54.834
>
  -159.589    54.820
  -160.372    54.834
>
  -160.477    55.349
  -160.372    54.834
>
  -160.477    55.349
  -160.372    54.834
>
  -160.477    55.349
  -160.372    54.834
>
  -160.477    55.349
  -160.372    54.834
>
  -161.864    55.148
  -160.372    54.834
>
  -161.864    55.148
  -160.372    54.834
>
  -161.790    55.374
  -160.372    54.834
>
  -161.742    55.421
  -160.372    54.834
>
  -161.742    55.421
  -160.372    54.834
>
  -161.856    55.346
  -160.372    54.834
>
  -161.856    55.346
  -160.372    54.834
>
  -161.864    55.148
  -161.287    54.766
>
  -161.864    55.148
  -161.287    54.766
>
  -161.904    55.317
  -161.287    54.766
>
  -161.856    55.346
  -161.287    54.766
>
  -161.856    55.346
  -161.287    54.766
>
  -161.790    55.374
  -161.287    54.766
>
  -161.742    55.421
  -161.287    54.766
>
  -161.742    55.421
  -161.287    54.766
>
  -162.281    55.107
  -161.287    54.766
>
  -162.281    55.107
  -161.287    54.766
>
  -162.252    55.149
  -161.287    54.766
>
  -162.252    55.149
  -161.287    54.766
>
  -160.477    55.349
  -161.287    54.766
>
  -160.477    55.349
  -161.287    54.766
>
  -161.998    55.433
  -161.287    54.766
>
  -159.589    54.831
  -161.287    54.766
>
  -159.589    54.820
  -161.287    54.766
>
  -159.589    54.820
  -160.565    54.217
>
  -159.589    54.820
  -160.565    54.217
>
  -159.589    54.831
  -160.418    54.909
>
  -159.589    54.820
  -160.418    54.909
>
  -160.477    55.349
  -160.418    54.909
>
  -160.477    55.349
  -160.418    54.909
>
  -161.864    55.148
  -160.418    54.909
>
  -161.864    55.148
  -160.418    54.909
>
  -161.742    55.421
  -160.418    54.909
>
  -161.742    55.421
  -160.418    54.909
>
  -161.856    55.346
  -160.418    54.909
>
  -161.856    55.346
  -160.418    54.909
>
  -159.589    54.831
  -158.478    54.944
>
  -159.589    54.831
  -158.478    54.944
>
  -159.589    54.831
  -158.478    54.944
>
  -159.589    54.820
  -158.478    54.944
>
  -159.589    54.820
  -158.478    54.944
>
  -159.589    54.831
  -158.698    54.891
>
  -159.589    54.831
  -158.698    54.891
>
  -159.589    54.820
  -158.698    54.891
>
  -159.589    54.820
  -158.698    54.891
>
  -160.477    55.349
  -160.477    54.977
>
  -160.477    55.349
  -160.477    54.977
>
  -161.864    55.148
  -160.477    54.977
>
  -161.864    55.148
  -160.477    54.977
>
  -161.742    55.421
  -160.477    54.977
>
  -161.790    55.374
  -160.477    54.977
>
  -161.856    55.346
  -160.477    54.977
>
  -159.589    54.831
  -160.346    54.856
>
  -159.589    54.831
  -160.346    54.856
>
  -159.589    54.820
  -160.346    54.856
>
  -159.589    54.820
  -160.346    54.856
>
  -160.477    55.349
  -160.346    54.856
>
  -160.477    55.349
  -160.346    54.856
>
  -160.477    55.349
  -160.346    54.856
>
  -160.477    55.349
  -160.346    54.856
>
  -161.864    55.148
  -160.346    54.856
>
  -161.864    55.148
  -160.346    54.856
>
  -161.790    55.374
  -160.346    54.856
>
  -161.742    55.421
  -160.346    54.856
>
  -161.742    55.421
  -160.346    54.856
>
  -161.856    55.346
  -160.346    54.856
>
  -161.856    55.346
  -160.346    54.856
>
  -161.864    55.148
  -160.462    54.944
>
  -161.864    55.148
  -160.462    54.944
>
  -161.742    55.421
  -160.462    54.944
>
  -161.856    55.346
  -160.462    54.944
>
  -160.477    55.349
  -160.961    54.539
>
  -160.477    55.349
  -160.961    54.539
>
  -160.477    55.349
  -160.961    54.539
>
  -160.477    55.349
  -160.961    54.539
>
  -161.864    55.148
  -160.961    54.539
>
  -161.864    55.148
  -160.961    54.539
>
  -159.589    54.820
  -160.961    54.539
>
  -159.589    54.820
  -160.961    54.539
>
  -159.589    54.831
  -160.961    54.539
>
  -161.856    55.346
  -160.961    54.539
>
  -161.856    55.346
  -160.961    54.539
>
  -161.790    55.374
  -160.961    54.539
>
  -161.742    55.421
  -160.961    54.539
>
  -161.742    55.421
  -160.961    54.539
>
  -162.281    55.107
  -160.961    54.539
>
  -162.281    55.107
  -160.961    54.539
>
  -162.252    55.149
  -160.961    54.539
>
  -162.252    55.149
  -160.961    54.539
>
  -159.589    54.831
  -159.726    55.246
>
  -159.589    54.820
  -159.726    55.246
>
  -159.589    54.820
  -159.726    55.246
>
  -160.477    55.349
  -159.726    55.246
>
  -160.477    55.349
  -159.726    55.246
>
  -160.477    55.349
  -159.726    55.246
>
  -159.368    56.031
  -159.726    55.246
>
  -159.368    56.031
  -159.726    55.246
>
  -159.455    56.227
  -159.726    55.246
>
  -159.455    56.227
  -159.726    55.246
>
  -160.477    55.349
  -160.507    55.003
>
  -160.477    55.349
  -160.507    55.003
>
  -159.589    54.831
  -160.507    55.003
>
  -159.589    54.820
  -160.507    55.003
>
  -161.864    55.148
  -160.507    55.003
>
  -161.864    55.148
  -160.507    55.003
>
  -161.742    55.421
  -160.507    55.003
>
  -161.742    55.421
  -160.507    55.003
>
  -161.856    55.346
  -160.507    55.003
>
  -161.856    55.346
  -160.507    55.003
>
  -161.856    55.346
  -160.507    55.003
>
  -161.998    55.433
  -160.507    55.003
>
  -161.998    55.433
  -160.507    55.003
>
  -161.998    55.433
  -160.507    55.003
>
  -159.589    54.831
  -160.424    54.862
>
  -159.589    54.820
  -160.424    54.862
>
  -160.477    55.349
  -160.424    54.862
>
  -160.477    55.349
  -160.424    54.862
>
  -161.864    55.148
  -160.424    54.862
>
  -161.864    55.148
  -160.424    54.862
>
  -161.790    55.374
  -160.424    54.862
>
  -161.742    55.421
  -160.424    54.862
>
  -161.742    55.421
  -160.424    54.862
>
  -161.856    55.346
  -160.424    54.862
>
  -161.856    55.346
  -160.424    54.862
>
  -161.904    55.317
  -160.424    54.862
>
  -159.589    54.820
  -160.548    54.225
>
  -159.589    54.820
  -160.548    54.225
>
  -159.589    54.831
  -160.548    54.225
>
  -159.589    54.831
  -160.548    54.225
>
  -159.589    54.831
  -160.435    54.935
>
  -159.589    54.820
  -160.435    54.935
>
  -160.477    55.349
  -160.435    54.935
>
  -160.477    55.349
  -160.435    54.935
>
  -160.477    55.349
  -160.435    54.935
>
  -160.477    55.349
  -160.435    54.935
>
  -161.864    55.148
  -160.435    54.935
>
  -161.864    55.148
  -160.435    54.935
>
  -161.742    55.421
  -160.435    54.935
>
  -161.790    55.374
  -160.435    54.935
>
  -161.856    55.346
  -160.435    54.935
>
  -161.856    55.346
  -160.435    54.935
>
  -161.904    55.317
  -160.435    54.935
>
  -159.589    54.831
  -159.894    54.887
>
  -159.589    54.820
  -159.894    54.887
>
  -159.589    54.820
  -159.894    54.887
>
  -160.477    55.349
  -159.894    54.887
>
  -160.477    55.349
  -159.894    54.887
>
  -160.477    55.349
  -160.454    54.939
>
  -160.477    55.349
  -160.454    54.939
>
  -159.589    54.820
  -160.454    54.939
>
  -161.864    55.148
  -160.454    54.939
>
  -161.864    55.148
  -160.454    54.939
>
  -161.742    55.421
  -160.454    54.939
>
  -161.742    55.421
  -160.454    54.939
>
  -161.856    55.346
  -160.454    54.939
>
  -159.589    54.820
  -160.251    54.632
>
  -160.477    55.349
  -160.251    54.632
>
  -160.477    55.349
  -160.251    54.632
>
  -159.589    54.820
  -160.669    54.716
>
  -159.589    54.820
  -160.669    54.716
>
  -160.477    55.349
  -160.669    54.716
>
  -160.477    55.349
  -160.669    54.716
>
  -161.864    55.148
  -160.669    54.716
>
  -161.864    55.148
  -160.669    54.716
>
  -161.856    55.346
  -160.669    54.716
>
  -161.856    55.346
  -160.669    54.716
>
  -161.742    55.421
  -160.669    54.716
>
  -161.742    55.421
  -160.669    54.716
>
  -160.477    55.349
  -161.017    54.869
>
  -160.477    55.349
  -161.017    54.869
>
  -160.477    55.349
  -161.017    54.869
>
  -160.477    55.349
  -161.017    54.869
>
  -161.864    55.148
  -161.017    54.869
>
  -161.864    55.148
  -161.017    54.869
>
  -161.856    55.346
  -161.017    54.869
>
  -161.856    55.346
  -161.017    54.869
>
  -161.742    55.421
  -161.017    54.869
>
  -161.742    55.421
  -161.017    54.869
>
  -159.589    54.831
  -161.017    54.869
>
  -159.589    54.820
  -161.017    54.869
>
  -162.252    55.149
  -161.017    54.869
>
  -162.252    55.149
  -161.017    54.869
>
  -162.281    55.107
  -161.017    54.869
>
  -162.281    55.107
  -161.017    54.869
>
  -161.998    55.433
  -161.017    54.869
>
  -159.589    54.820
  -159.611    55.186
>
  -159.589    54.820
  -159.611    55.186
>
  -160.477    55.349
  -159.611    55.186
>
  -160.477    55.349
  -159.611    55.186
>
  -159.368    56.031
  -159.611    55.186
>
  -159.558    56.072
  -159.611    55.186
>
  -159.562    56.152
  -159.611    55.186
>
  -159.589    54.820
  -160.886    54.414
>
  -159.589    54.820
  -160.886    54.414
>
  -159.589    54.831
  -160.886    54.414
>
  -159.589    54.831
  -160.886    54.414
>
  -160.477    55.349
  -160.886    54.414
>
  -160.477    55.349
  -160.886    54.414
>
  -160.477    55.349
  -160.886    54.414
>
  -160.477    55.349
  -160.886    54.414
>
  -161.864    55.148
  -160.886    54.414
>
  -161.864    55.148
  -160.886    54.414
>
  -160.477    55.349
  -160.710    54.707
>
  -160.477    55.349
  -160.710    54.707
>
  -160.477    55.349
  -160.710    54.707
>
  -160.477    55.349
  -160.710    54.707
>
  -159.589    54.831
  -160.710    54.707
>
  -159.589    54.820
  -160.710    54.707
>
  -159.589    54.820
  -160.710    54.707
>
  -161.864    55.148
  -160.710    54.707
>
  -161.864    55.148
  -160.710    54.707
>
  -161.790    55.374
  -160.710    54.707
>
  -161.856    55.346
  -160.710    54.707
>
  -161.856    55.346
  -160.710    54.707
>
  -161.742    55.421
  -160.710    54.707
>
  -161.742    55.421
  -160.710    54.707
>
  -162.252    55.149
  -160.710    54.707
>
  -162.281    55.107
  -160.710    54.707
>
  -162.281    55.107
  -160.710    54.707
>
  -159.589    54.831
  -158.586    55.083
>
  -159.589    54.831
  -158.586    55.083
>
  -159.589    54.820
  -158.586    55.083
>
  -159.589    54.820
  -158.586    55.083
>
  -159.589    54.820
  -159.333    54.723
>
  -159.589    54.820
  -159.333    54.723
>
  -159.589    54.831
  -159.333    54.723
>
  -159.589    54.831
  -159.333    54.723
>
  -160.477    55.349
  -159.333    54.723
>
  -160.477    55.349
  -159.333    54.723
>
  -160.477    55.349
  -159.333    54.723
>
  -160.477    55.349
  -159.333    54.723
>
  -159.589    54.820
  -160.986    54.499
>
  -161.864    55.148
  -160.986    54.499
>
  -161.864    55.148
  -160.986    54.499
>
  -161.864    55.148
  -160.986    54.499
>
  -159.589    54.831
  -160.986    54.499
>
  -160.477    55.349
  -160.986    54.499
>
  -160.477    55.349
  -160.986    54.499
>
  -160.477    55.349
  -160.986    54.499
>
  -161.904    55.317
  -160.986    54.499
>
  -161.856    55.346
  -160.986    54.499
>
  -161.856    55.346
  -160.986    54.499
>
  -161.790    55.374
  -160.986    54.499
>
  -162.281    55.107
  -160.986    54.499
>
  -162.281    55.107
  -160.986    54.499
>
  -162.252    55.149
  -160.986    54.499
>
  -162.252    55.149
  -160.986    54.499
>
  -159.589    54.820
  -159.802    54.753
>
  -159.589    54.820
  -159.802    54.753
>
  -159.589    54.831
  -159.802    54.753
>
  -159.589    54.831
  -159.802    54.753
>
  -160.477    55.349
  -159.802    54.753
>
  -160.477    55.349
  -159.802    54.753
>
  -160.477    55.349
  -159.802    54.753
>
  -160.477    55.349
  -159.802    54.753
>
  -159.589    54.831
  -159.886    54.875
>
  -159.589    54.820
  -159.886    54.875
>
  -159.589    54.820
  -159.886    54.875
>
  -160.477    55.349
  -159.886    54.875
>
  -159.589    54.820
  -159.786    54.584
>
  -159.589    54.820
  -159.786    54.584
>
  -159.589    54.831
  -159.786    54.584
>
  -159.589    54.831
  -159.786    54.584
>
  -160.477    55.349
  -159.786    54.584
>
  -160.477    55.349
  -159.786    54.584
>
  -159.589    54.820
  -159.750    54.458
>
  -159.589    54.820
  -159.750    54.458
>
  -159.589    54.831
  -159.750    54.458
>
  -160.477    55.349
  -159.750    54.458
>
  -160.477    55.349
  -159.750    54.458
>
  -160.477    55.349
  -159.750    54.458
>
  -159.589    54.820
  -159.805    54.387
>
  -159.589    54.820
  -159.805    54.387
>
  -159.589    54.820
  -159.751    54.422
>
  -159.589    54.820
  -159.751    54.422
>
  -159.589    54.831
  -159.751    54.422
>
  -159.589    54.820
  -159.804    54.332
>
  -159.589    54.820
  -159.804    54.332
>
  -159.589    54.820
  -159.737    54.334
>
  -159.589    54.820
  -159.737    54.334
>
  -159.589    54.831
  -159.737    54.334
>
  -159.589    54.820
  -159.777    54.439
>
  -159.589    54.820
  -159.777    54.439
>
  -160.477    55.349
  -159.777    54.439
>
  -160.477    55.349
  -159.777    54.439
>
  -159.589    54.820
  -159.835    54.520
>
  -159.589    54.820
  -159.835    54.520
>
  -160.477    55.349
  -159.835    54.520
>
  -159.589    54.820
  -159.960    54.327
>
  -159.589    54.820
  -159.960    54.327
>
  -159.589    54.831
  -159.960    54.327
>
  -159.589    54.820
  -159.813    54.355
>
  -159.589    54.820
  -159.813    54.355
>
  -159.589    54.820
  -159.800    54.494
>
  -159.589    54.820
  -159.800    54.494
>
  -160.477    55.349
  -159.800    54.494
>
  -160.477    55.349
  -159.800    54.494
>
  -159.589    54.820
  -159.899    54.258
>
  -159.589    54.820
  -159.899    54.258
>
  -159.589    54.820
  -159.808    54.410
>
  -159.589    54.820
  -159.808    54.410
>
  -159.589    54.831
  -159.808    54.410
>
  -159.589    54.831
  -159.808    54.410
>
  -159.589    54.820
  -159.961    54.267
>
  -159.589    54.831
  -159.961    54.267
>
  -159.589    54.831
  -159.961    54.267
>
  -159.589    54.820
  -159.769    54.285
>
  -159.589    54.820
  -159.749    54.595
>
  -159.589    54.820
  -159.749    54.595
>
  -159.589    54.831
  -159.749    54.595
>
  -159.589    54.831
  -159.749    54.595
>
  -160.477    55.349
  -159.749    54.595
>
  -160.477    55.349
  -159.749    54.595
>
  -160.477    55.349
  -159.749    54.595
>
  -160.477    55.349
  -159.749    54.595
>
  -159.589    54.820
  -159.922    54.415
>
  -159.589    54.820
  -159.922    54.415
>
  -160.477    55.349
  -159.922    54.415
>
  -160.477    55.349
  -159.922    54.415
>
  -159.589    54.820
  -159.726    54.481
>
  -159.589    54.820
  -159.726    54.481
>
  -159.589    54.831
  -159.726    54.481
>
  -159.589    54.831
  -159.726    54.481
>
  -160.477    55.349
  -159.726    54.481
>
  -160.477    55.349
  -159.726    54.481
>
  -160.477    55.349
  -159.726    54.481
>
  -160.477    55.349
  -159.726    54.481
>
  -159.589    54.820
  -159.826    54.286
>
  -159.589    54.820
  -159.826    54.286
>
  -159.589    54.831
  -159.826    54.286
>
  -159.589    54.820
  -159.766    54.429
>
  -159.589    54.820
  -159.766    54.429
>
  -159.589    54.820
  -159.695    54.539
>
  -159.589    54.820
  -159.695    54.539
>
  -160.477    55.349
  -159.695    54.539
>
  -160.477    55.349
  -159.695    54.539
>
  -160.477    55.349
  -159.695    54.539
>
  -160.477    55.349
  -159.695    54.539
>
  -159.589    54.820
  -159.903    54.274
>
  -159.589    54.831
  -159.903    54.274
>
  -159.589    54.820
  -159.760    54.460
>
  -159.589    54.820
  -159.760    54.460
>
  -160.477    55.349
  -159.760    54.460
>
  -160.477    55.349
  -159.760    54.460
>
  -159.589    54.820
  -159.777    54.388
>
  -159.589    54.820
  -159.777    54.388
>
  -159.589    54.820
  -159.731    54.496
>
  -159.589    54.820
  -159.731    54.496
>
  -160.477    55.349
  -159.731    54.496
>
  -160.477    55.349
  -159.731    54.496
>
  -159.589    54.820
  -159.688    54.483
>
  -159.589    54.820
  -159.688    54.483
>
  -159.589    54.831
  -159.688    54.483
>
  -159.589    54.831
  -159.688    54.483
>
  -160.477    55.349
  -159.688    54.483
>
  -160.477    55.349
  -159.688    54.483
>
  -160.477    55.349
  -159.688    54.483
>
  -159.589    54.820
  -159.761    54.582
>
  -159.589    54.820
  -159.761    54.582
>
  -159.589    54.831
  -159.761    54.582
>
  -160.477    55.349
  -159.761    54.582
>
  -160.477    55.349
  -159.761    54.582
>
  -160.477    55.349
  -159.761    54.582
>
  -160.477    55.349
  -159.761    54.582
>
  -159.589    54.820
  -159.738    54.436
>
  -159.589    54.820
  -159.738    54.436
>
  -159.589    54.820
  -159.654    54.330
>
  -159.589    54.831
  -159.654    54.330
>
  -159.589    54.820
  -159.755    54.376
>
  -159.589    54.820
  -159.755    54.376
>
  -159.589    54.831
  -159.755    54.376
>
  -159.589    54.820
  -159.639    54.238
>
  -159.589    54.820
  -159.639    54.238
>
  -159.589    54.820
  -159.805    54.245
>
  -159.589    54.820
  -159.805    54.245
>
  -159.589    54.820
  -159.686    54.468
>
  -159.589    54.820
  -159.686    54.468
>
  -159.589    54.831
  -159.686    54.468
>
  -159.589    54.831
  -159.686    54.468
>
  -160.477    55.349
  -159.686    54.468
>
  -160.477    55.349
  -159.686    54.468
>
  -160.477    55.349
  -159.686    54.468
>
  -160.477    55.349
  -159.686    54.468
>
  -159.589    54.820
  -159.715    54.205
>
  -159.589    54.820
  -159.715    54.205
>
  -159.589    54.820
  -159.603    54.369
>
  -159.589    54.820
  -159.603    54.369
>
  -159.589    54.820
  -159.919    54.358
>
  -159.589    54.820
  -159.919    54.358
>
  -159.589    54.820
  -159.772    54.336
>
  -159.589    54.820
  -159.772    54.336
>
  -159.589    54.820
  -159.833    54.509
>
  -159.589    54.831
  -159.833    54.509
>
  -159.589    54.831
  -159.833    54.509
>
  -160.477    55.349
  -159.833    54.509
>
  -159.589    54.820
  -159.742    54.298
>
  -159.589    54.820
  -159.742    54.298
>
  -159.589    54.820
  -159.798    54.511
>
  -159.589    54.820
  -159.798    54.511
>
  -160.477    55.349
  -159.798    54.511
>
  -159.589    54.820
  -159.747    54.571
>
  -159.589    54.820
  -159.747    54.571
>
  -160.477    55.349
  -159.747    54.571
>
  -160.477    55.349
  -159.747    54.571
>
  -160.477    55.349
  -159.747    54.571
>
  -160.477    55.349
  -159.747    54.571
>
  -159.589    54.820
  -159.756    54.547
>
  -159.589    54.820
  -159.756    54.547
>
  -159.589    54.831
  -159.756    54.547
>
  -159.589    54.831
  -159.756    54.547
>
  -160.477    55.349
  -159.756    54.547
>
  -160.477    55.349
  -159.756    54.547
>
  -160.477    55.349
  -159.756    54.547
>
  -160.477    55.349
  -159.756    54.547
>
  -159.589    54.820
  -159.737    54.270
>
  -159.589    54.820
  -159.737    54.270
>
  -159.589    54.820
  -159.628    54.307
>
  -159.589    54.820
  -159.628    54.307
>
  -159.589    54.820
  -159.888    54.292
>
  -159.589    54.820
  -159.888    54.292
>
  -159.589    54.831
  -159.888    54.292
>
  -159.589    54.831
  -159.888    54.292
>
  -159.589    54.820
  -159.827    54.308
>
  -159.589    54.820
  -159.827    54.308
>
  -159.589    54.820
  -159.827    54.308
>
  -159.589    54.831
  -159.827    54.308
>
  -159.589    54.831
  -159.827    54.308
>
  -159.589    54.820
  -159.766    54.310
>
  -159.589    54.820
  -159.766    54.310
>
  -159.589    54.831
  -159.766    54.310
>
  -159.589    54.831
  -159.766    54.310
>
  -159.589    54.820
  -159.778    54.417
>
  -159.589    54.820
  -159.778    54.417
>
  -159.589    54.831
  -159.778    54.417
>
  -159.589    54.831
  -159.778    54.417
>
  -159.589    54.820
  -159.775    54.221
>
  -159.589    54.820
  -159.775    54.221
>
  -159.589    54.831
  -159.775    54.221
>
  -159.589    54.831
  -159.775    54.221
>
  -159.589    54.820
  -159.790    54.263
>
  -159.589    54.820
  -159.790    54.263
>
  -159.589    54.820
  -159.809    54.391
>
  -159.589    54.820
  -159.809    54.391
>
  -159.589    54.820
  -159.746    54.371
>
  -159.589    54.820
  -159.746    54.371
>
  -159.589    54.831
  -159.746    54.371
>
  -159.589    54.831
  -159.746    54.371
>
  -159.589    54.820
  -159.786    54.265
>
  -159.589    54.820
  -159.786    54.265
>
  -159.589    54.831
  -159.786    54.265
>
  -159.589    54.831
  -159.786    54.265
>
  -159.589    54.820
  -159.785    54.374
>
  -159.589    54.820
  -159.905    54.334
>
  -159.589    54.820
  -159.905    54.334
>
  -159.589    54.820
  -159.905    54.334
>
  -159.589    54.831
  -159.905    54.334
>
  -159.589    54.831
  -159.905    54.334
>
  -159.589    54.820
  -159.785    54.481
>
  -159.589    54.820
  -159.785    54.481
>
  -159.589    54.831
  -159.785    54.481
>
  -160.477    55.349
  -159.785    54.481
>
  -160.477    55.349
  -159.785    54.481
>
  -160.477    55.349
  -159.785    54.481
>
  -160.477    55.349
  -159.785    54.481
>
  -159.589    54.820
  -159.716    54.536
>
  -159.589    54.820
  -159.716    54.536
>
  -160.477    55.349
  -159.716    54.536
>
  -160.477    55.349
  -159.716    54.536
>
  -159.589    54.820
  -159.773    54.618
>
  -159.589    54.831
  -159.773    54.618
>
  -159.589    54.831
  -159.773    54.618
>
  -160.477    55.349
  -159.773    54.618
>
  -160.477    55.349
  -159.773    54.618
>
  -160.477    55.349
  -159.773    54.618
>
  -160.477    55.349
  -159.773    54.618
>
  -159.589    54.820
  -159.757    54.447
>
  -159.589    54.820
  -159.757    54.447
>
  -160.477    55.349
  -159.757    54.447
>
  -160.477    55.349
  -159.757    54.447
>
  -159.589    54.820
  -159.734    54.368
>
  -159.589    54.820
  -159.734    54.368
>
  -159.589    54.820
  -159.813    54.295
>
  -159.589    54.820
  -159.813    54.295
>
  -159.589    54.820
  -159.778    54.218
>
  -159.589    54.820
  -159.842    54.437
>
  -159.589    54.820
  -159.842    54.437
>
  -160.477    55.349
  -159.842    54.437
>
  -160.477    55.349
  -159.842    54.437
>
  -159.589    54.820
  -159.735    54.377
>
  -159.589    54.820
  -159.735    54.377
>
  -159.589    54.820
  -159.789    54.266
>
  -159.589    54.820
  -159.789    54.266
>
  -159.589    54.831
  -159.789    54.266
>
  -159.589    54.831
  -159.789    54.266
>
  -159.589    54.820
  -159.789    54.274
>
  -159.589    54.820
  -159.789    54.274
>
  -159.589    54.831
  -159.789    54.274
>
  -159.589    54.831
  -159.789    54.274
>
  -159.589    54.820
  -159.787    54.421
>
  -159.589    54.820
  -159.787    54.421
>
  -159.589    54.831
  -159.787    54.421
>
  -159.589    54.831
  -159.787    54.421
>
  -159.589    54.820
  -159.684    54.293
>
  -159.589    54.820
  -159.684    54.293
>
  -159.589    54.820
  -159.757    54.375
>
  -159.589    54.820
  -159.757    54.375
>
  -159.589    54.820
  -159.785    54.357
>
  -159.589    54.820
  -159.785    54.357
>
  -159.589    54.831
  -159.785    54.357
>
  -159.589    54.820
  -159.770    54.539
>
  -159.589    54.820
  -159.770    54.539
>
  -160.477    55.349
  -159.770    54.539
>
  -160.477    55.349
  -159.770    54.539
>
  -159.589    54.820
  -159.651    54.443
>
  -159.589    54.820
  -159.651    54.443
>
  -159.589    54.831
  -159.651    54.443
>
  -159.589    54.831
  -159.651    54.443
>
  -159.589    54.820
  -159.693    54.490
>
  -159.589    54.820
  -159.693    54.490
>
  -159.589    54.831
  -159.693    54.490
>
  -159.589    54.831
  -159.693    54.490
>
  -160.477    55.349
  -159.693    54.490
>
  -160.477    55.349
  -159.693    54.490
>
  -160.477    55.349
  -159.693    54.490
>
  -160.477    55.349
  -159.693    54.490
>
  -159.589    54.820
  -159.797    54.440
>
  -159.589    54.820
  -159.797    54.440
>
  -160.477    55.349
  -159.797    54.440
>
  -159.589    54.820
  -159.880    54.568
>
  -159.589    54.820
  -159.880    54.568
>
  -159.589    54.831
  -159.880    54.568
>
  -160.477    55.349
  -159.880    54.568
>
  -160.477    55.349
  -159.880    54.568
>
  -160.477    55.349
  -159.880    54.568
>
  -159.589    54.820
  -159.836    54.525
>
  -159.589    54.820
  -159.836    54.525
>
  -159.589    54.831
  -159.836    54.525
>
  -159.589    54.831
  -159.836    54.525
>
  -160.477    55.349
  -159.836    54.525
>
  -160.477    55.349
  -159.836    54.525
>
  -160.477    55.349
  -159.836    54.525
>
  -159.589    54.820
  -159.746    54.249
>
  -159.589    54.820
  -159.746    54.249
>
  -159.589    54.820
  -159.746    54.581
>
  -159.589    54.820
  -159.746    54.581
>
  -160.477    55.349
  -159.746    54.581
>
  -160.477    55.349
  -159.746    54.581
>
  -159.589    54.820
  -159.742    54.451
>
  -159.589    54.820
  -159.742    54.451
>
  -160.477    55.349
  -159.742    54.451
>
  -160.477    55.349
  -159.742    54.451
>
  -159.589    54.820
  -159.801    54.396
>
  -159.589    54.820
  -159.801    54.396
>
  -159.589    54.820
  -159.833    54.362
>
  -159.589    54.820
  -159.833    54.362
>
  -159.589    54.820
  -159.660    54.294
>
  -159.589    54.820
  -159.660    54.294
>
  -159.589    54.831
  -159.660    54.294
>
  -159.589    54.820
  -159.590    54.438
>
  -159.589    54.820
  -159.590    54.438
>
  -159.589    54.831
  -159.590    54.438
>
  -159.589    54.831
  -159.590    54.438
>
  -159.589    54.820
  -159.651    54.422
>
  -159.589    54.831
  -159.651    54.422
>
  -159.589    54.831
  -159.651    54.422
>
  -159.589    54.820
  -159.766    54.504
>
  -159.589    54.820
  -159.766    54.504
>
  -160.477    55.349
  -159.766    54.504
>
  -160.477    55.349
  -159.766    54.504
>
  -159.589    54.820
  -159.792    54.280
>
  -159.589    54.820
  -159.792    54.280
>
  -159.589    54.820
  -159.761    54.322
>
  -159.589    54.820
  -159.761    54.322
>
  -159.589    54.831
  -159.761    54.322
>
  -159.589    54.831
  -159.761    54.322
>
  -159.589    54.820
  -159.858    54.215
>
  -159.589    54.820
  -159.858    54.215
>
  -159.589    54.831
  -159.858    54.215
>
  -159.589    54.831
  -159.858    54.215
>
  -159.589    54.820
  -159.702    54.456
>
  -159.589    54.820
  -159.702    54.456
>
  -159.589    54.831
  -159.702    54.456
>
  -159.589    54.831
  -159.702    54.456
>
  -159.589    54.820
  -159.751    54.499
>
  -159.589    54.831
  -159.751    54.499
>
  -160.477    55.349
  -159.751    54.499
>
  -160.477    55.349
  -159.751    54.499
>
  -160.477    55.349
  -159.751    54.499
>
  -159.589    54.820
  -159.734    54.535
>
  -159.589    54.820
  -159.734    54.535
>
  -160.477    55.349
  -159.734    54.535
>
  -160.477    55.349
  -159.734    54.535
>
  -160.477    55.349
  -159.734    54.535
>
  -160.477    55.349
  -159.734    54.535
>
  -159.589    54.820
  -159.601    54.323
>
  -159.589    54.820
  -159.601    54.323
>
  -159.589    54.831
  -159.601    54.323
>
  -159.589    54.831
  -159.601    54.323
>
  -159.589    54.820
  -159.872    54.409
>
  -159.589    54.820
  -159.872    54.409
>
  -159.589    54.820
  -159.791    54.090
>
  -159.589    54.831
  -159.791    54.090
>
  -159.589    54.831
  -159.791    54.090
>
  -159.589    54.820
  -159.739    54.417
>
  -159.589    54.820
  -159.739    54.417
>
  -159.589    54.831
  -159.739    54.417
>
  -159.589    54.831
  -159.739    54.417
>
  -159.589    54.820
  -159.861    54.391
>
  -159.589    54.820
  -159.861    54.391
>
  -159.589    54.820
  -159.817    54.428
>
  -159.589    54.820
  -159.817    54.428
>
  -160.477    55.349
  -159.817    54.428
>
  -160.477    55.349
  -159.817    54.428
>
  -159.589    54.820
  -159.788    54.315
>
  -159.589    54.820
  -159.788    54.315
>
  -159.589    54.831
  -159.788    54.315
>
  -159.589    54.831
  -159.788    54.315
>
  -159.589    54.820
  -159.785    54.322
>
  -159.589    54.820
  -159.684    54.257
>
  -159.589    54.820
  -159.684    54.257
>
  -159.589    54.820
  -159.684    54.570
>
  -159.589    54.820
  -159.684    54.570
>
  -160.477    55.349
  -159.684    54.570
>
  -160.477    55.349
  -159.684    54.570
>
  -159.589    54.820
  -159.768    54.183
>
  -159.589    54.820
  -159.734    54.130
>
  -159.589    54.820
  -159.734    54.130
>
  -159.589    54.831
  -159.734    54.130
>
  -159.589    54.820
  -159.781    54.335
>
  -159.589    54.820
  -159.781    54.335
>
  -159.589    54.831
  -159.781    54.335
>
  -159.589    54.820
  -159.710    54.455
>
  -159.589    54.820
  -159.710    54.455
>
  -159.589    54.831
  -159.710    54.455
>
  -159.589    54.831
  -159.710    54.455
>
  -160.477    55.349
  -159.710    54.455
>
  -160.477    55.349
  -159.710    54.455
>
  -160.477    55.349
  -159.710    54.455
>
  -160.477    55.349
  -159.710    54.455
>
  -159.589    54.820
  -159.752    54.368
>
  -159.589    54.820
  -159.752    54.368
>
  -159.589    54.831
  -159.752    54.368
>
  -159.589    54.831
  -159.752    54.368
>
  -159.589    54.820
  -159.868    54.525
>
  -159.589    54.820
  -159.868    54.525
>
  -159.589    54.831
  -159.868    54.525
>
  -160.477    55.349
  -159.868    54.525
>
  -160.477    55.349
  -159.868    54.525
>
  -159.589    54.820
  -159.654    54.527
>
  -159.589    54.820
  -159.654    54.527
>
  -159.589    54.831
  -159.654    54.527
>
  -159.589    54.831
  -159.654    54.527
>
  -160.477    55.349
  -159.654    54.527
>
  -160.477    55.349
  -159.654    54.527
>
  -160.477    55.349
  -159.654    54.527
>
  -159.589    54.820
  -159.727    54.482
>
  -159.589    54.820
  -159.727    54.482
>
  -159.589    54.831
  -159.727    54.482
>
  -160.477    55.349
  -159.727    54.482
>
  -160.477    55.349
  -159.727    54.482
>
  -160.477    55.349
  -159.727    54.482
>
  -159.589    54.820
  -159.765    54.262
>
  -159.589    54.820
  -159.765    54.262
>
  -159.589    54.831
  -159.765    54.262
>
  -159.589    54.831
  -159.765    54.262
>
  -159.589    54.820
  -159.777    54.636
>
  -159.589    54.831
  -159.777    54.636
>
  -160.477    55.349
  -159.777    54.636
>
  -160.477    55.349
  -159.777    54.636
>
  -160.477    55.349
  -159.777    54.636
>
  -160.477    55.349
  -159.777    54.636
>
  -159.589    54.831
  -160.411    54.919
>
  -159.589    54.820
  -160.411    54.919
>
  -160.477    55.349
  -160.411    54.919
>
  -160.477    55.349
  -160.411    54.919
>
  -160.477    55.349
  -160.411    54.919
>
  -159.589    54.820
  -159.764    54.250
>
  -159.589    54.820
  -159.764    54.250
>
  -159.589    54.831
  -159.764    54.250
>
  -159.589    54.831
  -159.764    54.250
>
  -159.589    54.820
  -159.874    54.400
>
  -159.589    54.820
  -159.874    54.400
>
  -159.589    54.831
  -159.874    54.400
>
  -159.589    54.831
  -159.840    54.372
>
  -159.589    54.820
  -159.766    54.403
>
  -159.589    54.820
  -159.766    54.403
>
  -159.589    54.831
  -159.766    54.403
>
  -159.589    54.831
  -159.766    54.403
>
  -159.589    54.820
  -159.646    54.636
>
  -159.589    54.820
  -159.646    54.636
>
  -159.589    54.831
  -159.646    54.636
>
  -160.477    55.349
  -159.646    54.636
>
  -160.477    55.349
  -159.646    54.636
>
  -160.477    55.349
  -159.646    54.636
>
  -159.589    54.820
  -159.854    54.477
>
  -159.589    54.820
  -159.854    54.477
>
  -159.589    54.831
  -159.854    54.477
>
  -159.589    54.831
  -159.854    54.477
>
  -160.477    55.349
  -159.854    54.477
>
  -160.477    55.349
  -159.854    54.477
>
  -160.477    55.349
  -159.854    54.477
>
  -160.477    55.349
  -159.854    54.477
>
  -159.589    54.831
  -160.486    54.770
>
  -159.589    54.831
  -160.486    54.770
>
  -159.589    54.820
  -160.486    54.770
>
  -159.589    54.820
  -160.486    54.770
>
  -160.477    55.349
  -160.486    54.770
>
  -160.477    55.349
  -160.486    54.770
>
  -160.477    55.349
  -160.486    54.770
>
  -160.477    55.349
  -160.486    54.770
>
  -159.589    54.820
  -159.778    54.064
>
  -159.589    54.831
  -159.778    54.064
>
  -159.589    54.831
  -159.778    54.064
>
  -159.589    54.820
  -159.853    54.342
>
  -159.589    54.831
  -159.853    54.342
>
  -159.589    54.831
  -159.853    54.342
>
  -159.589    54.820
  -159.763    54.332
>
  -159.589    54.820
  -159.763    54.332
>
  -159.589    54.831
  -159.763    54.332
>
  -159.589    54.831
  -159.763    54.332
>
  -159.589    54.820
  -159.759    54.170
>
  -159.589    54.820
  -159.759    54.170
>
  -159.589    54.831
  -159.759    54.170
>
  -159.589    54.820
  -159.783    54.074
>
  -159.589    54.831
  -159.783    54.074
>
  -159.589    54.820
  -159.759    54.577
>
  -159.589    54.820
  -159.759    54.577
>
  -159.589    54.831
  -159.759    54.577
>
  -160.477    55.349
  -159.759    54.577
>
  -160.477    55.349
  -159.759    54.577
>
  -160.477    55.349
  -159.759    54.577
>
  -159.589    54.820
  -159.885    54.467
>
  -159.589    54.820
  -159.885    54.467
>
  -160.477    55.349
  -159.885    54.467
>
  -160.477    55.349
  -159.885    54.467
>
  -159.589    54.820
  -159.762    54.509
>
  -159.589    54.820
  -159.762    54.509
>
  -159.589    54.831
  -159.762    54.509
>
  -159.589    54.831
  -159.762    54.509
>
  -160.477    55.349
  -159.762    54.509
>
  -160.477    55.349
  -159.762    54.509
>
  -160.477    55.349
  -159.762    54.509
>
  -160.477    55.349
  -159.762    54.509
>
  -159.589    54.820
  -159.813    54.269
>
  -159.589    54.820
  -159.813    54.269
>
  -159.589    54.831
  -159.813    54.269
>
  -159.589    54.831
  -159.813    54.269
>
  -159.589    54.820
  -159.691    54.510
>
  -159.589    54.820
  -159.691    54.510
>
  -160.477    55.349
  -159.691    54.510
>
  -160.477    55.349
  -159.691    54.510
>
  -160.477    55.349
  -159.691    54.510
>
  -160.477    55.349
  -159.691    54.510
>
  -159.589    54.820
  -159.982    54.201
>
  -159.589    54.820
  -159.982    54.201
>
  -159.589    54.831
  -159.982    54.201
>
  -159.589    54.831
  -159.982    54.201
>
  -159.589    54.820
  -159.758    54.156
>
  -159.589    54.820
  -159.758    54.156
>
  -159.589    54.820
  -159.733    54.392
>
  -159.589    54.820
  -159.733    54.392
>
  -159.589    54.831
  -159.733    54.392
>
  -159.589    54.831
  -159.733    54.392
>
  -159.589    54.820
  -159.726    54.527
>
  -159.589    54.820
  -159.726    54.527
>
  -159.589    54.831
  -159.726    54.527
>
  -160.477    55.349
  -159.726    54.527
>
  -160.477    55.349
  -159.726    54.527
>
  -160.477    55.349
  -159.726    54.527
>
  -160.477    55.349
  -159.726    54.527
>
  -159.589    54.820
  -159.822    54.392
>
  -159.589    54.820
  -159.822    54.392
>
  -159.589    54.831
  -159.822    54.392
>
  -159.589    54.820
  -159.775    54.315
>
  -159.589    54.820
  -159.775    54.315
>
  -159.589    54.831
  -159.775    54.315
>
  -159.589    54.831
  -159.775    54.315
>
  -159.589    54.820
  -159.781    54.563
>
  -159.589    54.820
  -159.781    54.563
>
  -160.477    55.349
  -159.781    54.563
>
  -160.477    55.349
  -159.781    54.563
>
  -159.589    54.820
  -159.730    54.473
>
  -159.589    54.820
  -159.730    54.473
>
  -159.589    54.831
  -159.730    54.473
>
  -159.589    54.831
  -159.730    54.473
>
  -160.477    55.349
  -159.730    54.473
>
  -160.477    55.349
  -159.730    54.473
>
  -160.477    55.349
  -159.730    54.473
>
  -160.477    55.349
  -159.730    54.473
>
  -159.589    54.820
  -159.845    54.483
>
  -159.589    54.820
  -159.845    54.483
>
  -159.589    54.831
  -159.845    54.483
>
  -160.477    55.349
  -159.845    54.483
>
  -160.477    55.349
  -159.845    54.483
>
  -160.477    55.349
  -159.845    54.483
>
  -159.589    54.820
  -159.415    54.514
>
  -159.589    54.820
  -159.415    54.514
>
  -159.589    54.831
  -159.415    54.514
>
  -159.589    54.831
  -159.415    54.514
>
  -159.589    54.820
  -159.790    54.573
>
  -159.589    54.820
  -159.790    54.573
>
  -159.589    54.831
  -159.790    54.573
>
  -159.589    54.831
  -159.790    54.573
>
  -160.477    55.349
  -159.790    54.573
>
  -160.477    55.349
  -159.790    54.573
>
  -160.477    55.349
  -159.790    54.573
>
  -160.477    55.349
  -159.790    54.573
>
  -159.589    54.820
  -159.823    54.449
>
  -159.589    54.820
  -159.823    54.449
>
  -159.589    54.831
  -159.823    54.449
>
  -159.589    54.831
  -159.823    54.449
>
  -160.477    55.349
  -159.823    54.449
>
  -160.477    55.349
  -159.823    54.449
>
  -160.477    55.349
  -159.823    54.449
>
  -160.477    55.349
  -159.823    54.449
>
  -159.589    54.820
  -159.768    54.417
>
  -159.589    54.820
  -159.768    54.417
>
  -159.589    54.831
  -159.768    54.417
>
  -159.589    54.831
  -159.768    54.417
>
  -159.589    54.820
  -159.771    54.517
>
  -160.477    55.349
  -159.771    54.517
>
  -160.477    55.349
  -159.771    54.517
>
  -160.477    55.349
  -159.771    54.517
>
  -160.477    55.349
  -159.771    54.517
>
  -159.085    56.126
  -158.269    55.386
>
  -158.414    56.301
  -158.269    55.386
>
  -158.414    56.301
  -158.269    55.386
>
  -159.368    56.031
  -158.269    55.386
>
  -159.589    54.820
  -158.269    55.386
>
  -160.477    55.349
  -160.380    54.896
>
  -160.477    55.349
  -160.380    54.896
>
  -159.589    54.820
  -160.380    54.896
>
  -159.589    54.820
  -160.380    54.896
>
  -161.864    55.148
  -160.380    54.896
>
  -161.864    55.148
  -160.380    54.896
>
  -161.742    55.421
  -160.380    54.896
>
  -161.742    55.421
  -160.380    54.896
>
  -161.790    55.374
  -160.380    54.896
>
  -161.856    55.346
  -160.380    54.896
>
  -161.856    55.346
  -160.380    54.896
>
  -159.589    54.820
  -159.812    54.385
>
  -159.589    54.820
  -159.793    54.580
>
  -159.589    54.820
  -159.793    54.580
>
  -160.477    55.349
  -159.793    54.580
>
  -160.477    55.349
  -159.793    54.580
>
  -159.589    54.820
  -159.833    54.226
>
  -159.589    54.831
  -159.833    54.226
>
  -159.589    54.831
  -159.833    54.226
>
  -159.589    54.820
  -159.821    54.099
>
  -159.589    54.820
  -159.821    54.099
>
  -159.589    54.831
  -159.821    54.099
>
  -159.589    54.820
  -159.729    54.641
>
  -159.589    54.820
  -159.729    54.641
>
  -159.589    54.831
  -159.729    54.641
>
  -160.477    55.349
  -159.729    54.641
>
  -160.477    55.349
  -159.729    54.641
>
  -160.477    55.349
  -159.729    54.641
>
  -160.477    55.349
  -159.729    54.641
>
  -159.589    54.820
  -159.822    54.428
>
  -159.589    54.820
  -159.822    54.428
>
  -159.589    54.831
  -159.822    54.428
>
  -159.589    54.831
  -159.822    54.428
>
  -160.477    55.349
  -159.822    54.428
>
  -160.477    55.349
  -159.822    54.428
>
  -160.477    55.349
  -159.822    54.428
>
  -159.589    54.820
  -159.833    54.425
>
  -159.589    54.820
  -159.833    54.425
>
  -159.589    54.831
  -159.833    54.425
>
  -159.589    54.831
  -159.833    54.425
>
  -160.477    55.349
  -159.833    54.425
>
  -160.477    55.349
  -159.833    54.425
>
  -160.477    55.349
  -159.833    54.425
>
  -160.477    55.349
  -159.833    54.425
>
  -159.589    54.820
  -159.970    54.294
>
  -159.589    54.820
  -159.970    54.294
>
  -159.589    54.831
  -159.970    54.294
>
  -159.589    54.831
  -159.970    54.294
>
  -159.589    54.820
  -160.081    54.190
>
  -159.589    54.820
  -160.081    54.190
>
  -159.589    54.831
  -160.081    54.190
>
  -159.589    54.820
  -159.877    54.497
>
  -159.589    54.820
  -159.877    54.497
>
  -160.477    55.349
  -159.877    54.497
>
  -160.477    55.349
  -159.877    54.497
>
  -159.589    54.831
  -159.890    54.288
>
  -159.589    54.820
  -159.821    54.411
>
  -159.589    54.820
  -159.821    54.411
>
  -159.589    54.831
  -159.821    54.411
>
  -159.589    54.831
  -159.821    54.411
>
  -159.589    54.820
  -159.851    54.140
>
  -159.589    54.820
  -159.851    54.140
>
  -159.589    54.831
  -159.851    54.140
>
  -159.589    54.820
  -159.796    54.267
>
  -159.589    54.820
  -159.796    54.267
>
  -159.589    54.831
  -159.796    54.267
>
  -159.589    54.820
  -159.821    54.488
>
  -159.589    54.820
  -159.821    54.488
>
  -159.589    54.831
  -159.821    54.488
>
  -160.477    55.349
  -159.821    54.488
>
  -160.477    55.349
  -159.821    54.488
>
  -160.477    55.349
  -159.821    54.488
>
  -159.589    54.820
  -159.701    54.275
>
  -159.589    54.820
  -159.701    54.275
>
  -159.589    54.831
  -159.701    54.275
>
  -159.589    54.820
  -159.759    54.569
>
  -159.589    54.820
  -159.759    54.569
>
  -159.589    54.831
  -159.759    54.569
>
  -160.477    55.349
  -159.759    54.569
>
  -160.477    55.349
  -159.759    54.569
>
  -160.477    55.349
  -159.759    54.569
>
  -160.477    55.349
  -159.759    54.569
>
  -159.589    54.820
  -159.803    54.264
>
  -159.589    54.820
  -159.803    54.264
>
  -159.589    54.831
  -159.803    54.264
>
  -159.589    54.831
  -159.706    55.207
>
  -159.589    54.820
  -159.706    55.207
>
  -159.589    54.820
  -159.706    55.207
>
  -160.477    55.349
  -159.706    55.207
>
  -160.477    55.349
  -159.706    55.207
>
  -160.477    55.349
  -159.706    55.207
>
  -160.477    55.349
  -159.706    55.207
>
  -159.558    56.072
  -159.706    55.207
>
  -159.562    56.152
  -159.706    55.207
>
  -159.589    54.820
  -159.851    54.532
>
  -159.589    54.820
  -159.851    54.532
>
  -159.589    54.831
  -159.851    54.532
>
  -160.477    55.349
  -159.851    54.532
>
  -160.477    55.349
  -159.851    54.532
>
  -160.477    55.349
  -159.851    54.532
>
  -159.589    54.820
  -159.876    54.454
>
  -159.589    54.820
  -159.876    54.454
>
  -159.589    54.831
  -159.876    54.454
>
  -160.477    55.349
  -159.876    54.454
>
  -160.477    55.349
  -159.876    54.454
>
  -160.477    55.349
  -159.876    54.454
>
  -159.589    54.820
  -159.804    54.260
>
  -159.589    54.820
  -159.804    54.260
>
  -159.589    54.831
  -159.804    54.260
>
  -159.589    54.831
  -159.804    54.260
>
  -159.589    54.820
  -159.674    54.534
>
  -159.589    54.820
  -159.674    54.534
>
  -159.589    54.831
  -159.674    54.534
>
  -160.477    55.349
  -159.674    54.534
>
  -160.477    55.349
  -159.674    54.534
>
  -160.477    55.349
  -159.674    54.534
>
  -159.589    54.831
  -159.622    54.989
>
  -159.589    54.831
  -159.622    54.989
>
  -159.589    54.820
  -159.622    54.989
>
  -159.589    54.820
  -159.622    54.989
>
  -160.477    55.349
  -159.622    54.989
>
  -160.477    55.349
  -159.622    54.989
>
  -160.477    55.349
  -159.622    54.989
>
  -160.477    55.349
  -159.622    54.989
>
  -159.589    54.820
  -159.765    54.656
>
  -159.589    54.820
  -159.765    54.656
>
  -159.589    54.831
  -159.765    54.656
>
  -160.477    55.349
  -159.765    54.656
>
  -160.477    55.349
  -159.765    54.656
>
  -160.477    55.349
  -159.765    54.656
>
  -160.477    55.349
  -159.765    54.656
>
  -159.589    54.820
  -159.780    54.649
>
  -159.589    54.820
  -159.780    54.649
>
  -160.477    55.349
  -159.780    54.649
>
  -160.477    55.349
  -159.780    54.649
>
  -159.589    54.820
  -159.733    54.492
>
  -159.589    54.820
  -159.733    54.492
>
  -159.589    54.831
  -159.733    54.492
>
  -160.477    55.349
  -159.733    54.492
>
  -160.477    55.349
  -159.733    54.492
>
  -159.589    54.820
  -159.810    54.395
>
  -159.589    54.820
  -159.810    54.395
>
  -159.589    54.831
  -159.810    54.395
>
  -159.589    54.831
  -159.810    54.395
>
  -159.589    54.820
  -159.366    55.277
>
  -159.589    54.820
  -159.366    55.277
>
  -160.477    55.349
  -159.366    55.277
>
  -160.477    55.349
  -159.366    55.277
>
  -159.085    56.126
  -159.366    55.277
>
  -159.085    56.126
  -159.366    55.277
>
  -159.164    56.221
  -159.366    55.277
>
  -159.164    56.221
  -159.366    55.277
>
  -159.164    56.221
  -159.366    55.277
>
  -159.455    56.227
  -159.366    55.277
>
  -159.589    54.820
  -159.619    54.658
>
  -159.589    54.820
  -159.619    54.658
>
  -159.589    54.831
  -159.619    54.658
>
  -159.589    54.831
  -159.619    54.658
>
  -160.477    55.349
  -159.619    54.658
>
  -160.477    55.349
  -159.619    54.658
>
  -160.477    55.349
  -159.619    54.658
>
  -160.477    55.349
  -159.619    54.658
>
  -159.589    54.820
  -159.699    54.609
>
  -159.589    54.820
  -159.699    54.609
>
  -159.589    54.831
  -159.699    54.609
>
  -160.477    55.349
  -159.699    54.609
>
  -160.477    55.349
  -159.699    54.609
>
  -160.477    55.349
  -159.699    54.609
>
  -159.589    54.820
  -159.721    54.559
>
  -159.589    54.820
  -159.721    54.559
>
  -159.589    54.831
  -159.721    54.559
>
  -159.589    54.831
  -159.721    54.559
>
  -160.477    55.349
  -159.721    54.559
>
  -160.477    55.349
  -159.721    54.559
>
  -160.477    55.349
  -159.721    54.559
>
  -159.589    54.820
  -159.817    54.519
>
  -159.589    54.820
  -159.817    54.519
>
  -160.477    55.349
  -159.817    54.519
>
  -160.477    55.349
  -159.817    54.519
>
  -159.589    54.820
  -159.703    54.663
>
  -159.589    54.820
  -159.703    54.663
>
  -159.589    54.831
  -159.703    54.663
>
  -160.477    55.349
  -159.703    54.663
>
  -160.477    55.349
  -159.703    54.663
>
  -159.589    54.820
  -159.693    54.526
>
  -159.589    54.820
  -159.693    54.526
>
  -159.589    54.831
  -159.693    54.526
>
  -159.589    54.831
  -159.693    54.526
>
  -160.477    55.349
  -159.693    54.526
>
  -160.477    55.349
  -159.693    54.526
>
  -160.477    55.349
  -159.693    54.526
>
  -155.620    55.822
  -156.582    56.348
>
  -155.620    55.822
  -156.582    56.348
>
  -155.620    55.822
  -156.582    56.348
>
  -159.589    54.820
  -159.798    54.598
>
  -159.589    54.820
  -159.798    54.598
>
  -159.589    54.831
  -159.798    54.598
>
  -160.477    55.349
  -159.798    54.598
>
  -160.477    55.349
  -159.798    54.598
>
  -160.477    55.349
  -159.798    54.598
>
  -159.589    54.820
  -160.393    54.764
>
  -159.589    54.820
  -160.393    54.764
>
  -160.477    55.349
  -160.393    54.764
>
  -160.477    55.349
  -160.393    54.764
>
  -160.477    55.349
  -160.393    54.764
>
  -160.477    55.349
  -160.393    54.764
>
  -161.864    55.148
  -160.393    54.764
>
  -161.864    55.148
  -160.393    54.764
>
  -159.589    54.820
  -159.898    54.308
>
  -159.589    54.820
  -159.898    54.308
>
  -159.589    54.831
  -159.898    54.308
>
  -159.589    54.831
  -159.898    54.308
>
  -159.589    54.820
  -159.939    54.204
>
  -159.589    54.820
  -159.939    54.204
>
  -159.589    54.820
  -159.737    54.439
>
  -159.589    54.820
  -159.737    54.439
>
  -159.589    54.831
  -159.737    54.439
>
  -159.589    54.831
  -159.737    54.439
>
  -159.589    54.820
  -159.766    54.624
>
  -159.589    54.820
  -159.766    54.624
>
  -159.589    54.831
  -159.766    54.624
>
  -159.589    54.831
  -159.766    54.624
>
  -160.477    55.349
  -159.766    54.624
>
  -160.477    55.349
  -159.766    54.624
>
  -160.477    55.349
  -159.766    54.624
>
  -160.477    55.349
  -159.766    54.624
>
  -159.589    54.820
  -159.799    54.614
>
  -159.589    54.820
  -159.799    54.614
>
  -159.589    54.831
  -159.799    54.614
>
  -160.477    55.349
  -159.799    54.614
>
  -160.477    55.349
  -159.799    54.614
>
  -160.477    55.349
  -159.799    54.614
>
  -159.589    54.831
  -159.446    55.411
>
  -159.589    54.831
  -159.446    55.411
>
  -160.477    55.349
  -159.446    55.411
>
  -160.477    55.349
  -159.446    55.411
>
  -160.477    55.349
  -159.446    55.411
>
  -160.477    55.349
  -159.446    55.411
>
  -159.589    54.820
  -159.446    55.411
>
  -159.589    54.820
  -159.446    55.411
>
  -159.589    54.831
  -160.930    54.363
>
  -159.589    54.831
  -159.778    54.343
>
  -159.589    54.831
  -159.778    54.343
>
  -159.589    54.831
  -159.749    54.645
>
  -159.589    54.831
  -159.749    54.645
>
  -160.477    55.349
  -159.749    54.645
>
  -160.477    55.349
  -159.749    54.645
>
  -159.589    54.831
  -159.801    54.356
>
  -159.589    54.831
  -159.801    54.356
>
  -159.589    54.831
  -159.806    54.409
>
  -159.589    54.831
  -159.806    54.409
>
  -159.589    54.831
  -159.487    55.004
>
  -159.589    54.831
  -159.487    55.004
>
  -160.477    55.349
  -159.487    55.004
>
  -160.477    55.349
  -159.487    55.004
>
  -160.477    55.349
  -160.440    54.873
>
  -160.477    55.349
  -160.440    54.873
>
  -161.864    55.148
  -160.440    54.873
>
  -161.864    55.148
  -160.440    54.873
>
  -161.742    55.421
  -160.440    54.873
>
  -161.742    55.421
  -160.440    54.873
>
  -161.856    55.346
  -160.440    54.873
>
  -161.856    55.346
  -160.440    54.873
>
  -158.414    56.301
  -159.006    55.601
>
  -159.589    54.831
  -159.006    55.601
>
  -159.589    54.831
  -159.006    55.601
>
  -159.589    54.831
  -159.770    54.600
>
  -159.589    54.831
  -159.770    54.600
>
  -160.477    55.349
  -159.770    54.600
>
  -160.477    55.349
  -159.770    54.600
>
  -159.589    54.831
  -159.807    54.211
>
  -159.589    54.831
  -159.807    54.211
>
  -159.589    54.831
  -159.772    54.656
>
  -159.589    54.831
  -159.772    54.656
>
  -160.477    55.349
  -159.772    54.656
>
  -159.589    54.831
  -159.224    55.214
>
  -159.589    54.831
  -159.224    55.214
>
  -160.477    55.349
  -159.224    55.214
>
  -160.477    55.349
  -159.224    55.214
>
  -159.589    54.831
  -159.855    54.294
>
  -159.589    54.831
  -159.855    54.294
>
  -159.589    54.831
  -159.764    54.570
>
  -159.589    54.831
  -159.764    54.570
>
  -160.477    55.349
  -159.764    54.570
>
  -160.477    55.349
  -159.764    54.570
>
  -159.589    54.831
  -159.805    54.429
>
  -159.589    54.831
  -159.805    54.429
>
  -159.589    54.831
  -159.558    54.937
>
  -159.589    54.831
  -159.558    54.937
>
  -160.477    55.349
  -159.558    54.937
>
  -160.477    55.349
  -159.558    54.937
>
  -159.589    54.831
  -159.773    54.575
>
  -159.589    54.831
  -159.773    54.575
>
  -160.477    55.349
  -159.773    54.575
>
  -160.477    55.349
  -159.773    54.575
>
  -159.589    54.831
  -159.807    54.410
>
  -159.589    54.831
  -159.807    54.410
>
  -159.589    54.831
  -159.731    54.692
>
  -159.589    54.831
  -159.731    54.692
>
  -160.477    55.349
  -159.731    54.692
>
  -160.477    55.349
  -159.731    54.692
>
  -159.589    54.831
  -159.802    54.411
>
  -159.589    54.831
  -159.802    54.411
>
  -159.589    54.831
  -160.207    54.601
>
  -159.589    54.831
  -160.207    54.601
>
  -160.477    55.349
  -160.207    54.601
>
  -160.477    55.349
  -160.207    54.601
>
  -159.589    54.831
  -159.789    54.584
>
  -159.589    54.831
  -159.789    54.584
>
  -160.477    55.349
  -159.789    54.584
>
  -160.477    55.349
  -159.789    54.584
>
  -159.589    54.831
  -159.796    54.333
>
  -159.589    54.831
  -159.796    54.333
>
  -159.589    54.831
  -159.800    54.318
>
  -159.589    54.831
  -159.800    54.318
>
  -159.589    54.831
  -159.807    54.437
>
  -159.589    54.831
  -159.807    54.437
>
  -160.477    55.349
  -159.807    54.437
>
  -160.477    55.349
  -159.807    54.437
>
  -159.589    54.831
  -159.767    54.196
>
  -159.589    54.831
  -159.697    54.587
>
  -159.589    54.831
  -159.697    54.587
>
  -160.477    55.349
  -159.697    54.587
>
  -160.477    55.349
  -159.697    54.587
>
  -159.589    54.831
  -160.277    54.430
>
  -159.589    54.831
  -160.277    54.430
>
  -160.477    55.349
  -160.277    54.430
>
  -160.477    55.349
  -160.277    54.430
>
  -159.589    54.831
  -158.623    55.059
>
  -159.589    54.831
  -159.750    54.595
>
  -159.589    54.831
  -159.750    54.595
>
  -160.477    55.349
  -159.750    54.595
>
  -160.477    55.349
  -159.750    54.595
>
  -159.589    54.831
  -160.321    54.867
>
  -159.589    54.831
  -160.321    54.867
>
  -160.477    55.349
  -160.321    54.867
>
  -160.477    55.349
  -160.321    54.867
>
  -161.864    55.148
  -160.321    54.867
>
  -161.864    55.148
  -160.321    54.867
>
  -161.742    55.421
  -160.321    54.867
>
  -161.742    55.421
  -160.321    54.867
>
  -159.589    54.831
  -159.771    54.467
>
  -159.589    54.831
  -159.771    54.467
>
  -160.477    55.349
  -159.771    54.467
>
  -160.477    55.349
  -159.771    54.467
>
  -159.589    54.831
  -158.601    55.062
>
  -159.589    54.831
  -158.601    55.062
>
  -159.589    54.831
  -158.397    54.918
>
  -159.589    54.831
  -158.397    54.918
>
  -159.589    54.831
  -158.790    55.043
>
  -159.589    54.831
  -158.790    55.043
>
  -159.589    54.831
  -158.790    55.043
>
  -159.589    54.831
  -158.630    54.996
>
  -159.589    54.831
  -158.630    54.996
>
  -159.589    54.831
  -158.630    54.996
>
  -159.368    56.031
  -158.636    55.370
>
  -159.085    56.126
  -158.636    55.370
>
  -159.589    54.831
  -158.636    55.370
>
  -159.589    54.831
  -158.636    55.370
>
  -159.589    54.831
  -158.636    55.370
>
  -159.589    54.831
  -158.636    55.370
>
  -158.414    56.301
  -158.636    55.370
>
  -158.540    56.306
  -158.636    55.370
>
  -158.540    56.306
  -158.636    55.370
>
  -159.316    56.284
  -158.636    55.370
>
  -155.622    55.822
  -156.302    55.769
>
  -155.622    55.822
  -156.302    55.769
>
  -159.085    56.126
  -158.601    55.428
>
  -159.368    56.031
  -158.601    55.428
>
  -158.414    56.301
  -158.601    55.428
>
  -158.414    56.301
  -158.601    55.428
>
  -158.540    56.306
  -158.601    55.428
>
  -158.540    56.306
  -158.601    55.428
>
  -159.589    54.831
  -158.601    55.428
>
  -159.589    54.831
  -158.601    55.428
>
  -159.589    54.831
  -158.601    55.428
>
  -159.589    54.831
  -158.601    55.428
>
  -159.316    56.284
  -158.601    55.428
>
  -159.316    56.284
  -158.601    55.428
>
  -159.589    54.831
  -158.640    54.943
>
  -159.589    54.831
  -158.640    54.943
>
  -158.540    56.306
  -157.313    56.017
>
  -158.540    56.306
  -157.313    56.017
>
  -155.622    55.822
  -157.313    56.017
>
  -155.622    55.822
  -157.313    56.017
>
  -158.281    56.802
  -157.313    56.017
>
  -158.281    56.802
  -157.313    56.017
>
  -158.059    56.913
  -157.313    56.017
>
  -159.085    56.126
  -157.313    56.017
>
  -159.085    56.126
  -157.313    56.017
>
  -159.589    54.831
  -159.739    54.526
>
  -159.589    54.831
  -159.739    54.526
>
  -159.589    54.831
  -159.739    54.526
>
  -160.477    55.349
  -159.739    54.526
>
  -160.477    55.349
  -159.739    54.526
>
  -160.477    55.349
  -159.739    54.526
>
  -160.477    55.349
  -159.739    54.526
>
  -155.622    55.822
  -156.596    55.395
>
  -155.622    55.822
  -156.596    55.395
>
  -159.589    54.831
  -159.350    55.162
>
  -159.589    54.831
  -159.350    55.162
>
  -160.477    55.349
  -159.350    55.162
>
  -160.477    55.349
  -159.350    55.162
>
  -159.368    56.031
  -159.350    55.162
>
  -159.085    56.126
  -159.350    55.162
>
  -155.622    55.822
  -156.481    55.057
>
  -155.622    55.822
  -156.481    55.057
>
  -159.589    54.831
  -158.732    54.829
>
  -159.589    54.831
  -158.732    54.829
>
  -155.622    55.822
  -156.408    55.949
>
  -155.622    55.822
  -156.408    55.949
>
  -155.622    55.822
  -156.408    55.949
>
  -155.620    55.822
  -156.408    55.949
>
  -159.589    54.831
  -160.350    54.805
>
  -159.589    54.831
  -160.350    54.805
>
  -160.477    55.349
  -160.350    54.805
>
  -160.477    55.349
  -160.350    54.805
>
  -161.864    55.148
  -160.350    54.805
>
  -161.864    55.148
  -160.350    54.805
>
  -159.589    54.831
  -158.893    55.044
>
  -159.589    54.831
  -158.893    55.044
>
  -159.589    54.831
  -158.893    55.044
>
  -160.477    55.349
  -158.893    55.044
>
  -160.477    55.349
  -158.893    55.044
>
  -160.477    55.349
  -158.893    55.044
>
  -159.589    54.831
  -158.782    54.861
>
  -159.589    54.831
  -158.782    54.861
>
  -159.589    54.831
  -158.782    54.861
>
  -155.622    55.822
  -155.891    55.486
>
  -155.622    55.822
  -155.891    55.486
>
  -155.622    55.822
  -156.701    56.319
>
  -155.622    55.822
  -156.701    56.319
>
  -158.414    56.301
  -156.701    56.319
>
  -158.414    56.301
  -156.701    56.319
>
  -158.281    56.802
  -156.701    56.319
>
  -158.281    56.802
  -156.701    56.319
>
  -159.589    54.831
  -159.715    54.721
>
  -159.589    54.831
  -159.715    54.721
>
  -160.477    55.349
  -159.715    54.721
>
  -160.477    55.349
  -159.715    54.721
>
  -155.622    55.822
  -156.153    55.736
>
  -155.622    55.822
  -156.153    55.736
>
  -159.589    54.831
  -158.854    54.385
>
  -159.589    54.831
  -159.793    54.600
>
  -159.589    54.831
  -159.793    54.600
>
  -160.477    55.349
  -159.793    54.600
>
  -160.477    55.349
  -159.793    54.600
>
  -159.589    54.831
  -159.793    54.673
>
  -160.477    55.349
  -159.793    54.673
>
  -160.477    55.349
  -159.793    54.673
>
  -159.589    54.831
  -159.723    54.341
>
  -159.589    54.831
  -159.723    54.341
>
  -159.589    54.831
  -159.812    54.470
>
  -159.589    54.831
  -159.812    54.470
>
  -160.477    55.349
  -159.812    54.470
>
  -160.477    55.349
  -159.812    54.470
>
  -159.589    54.831
  -159.712    54.530
>
  -159.589    54.831
  -159.712    54.530
>
  -160.477    55.349
  -159.712    54.530
>
  -160.477    55.349
  -159.712    54.530
>
  -159.589    54.831
  -159.900    54.137
>
  -159.589    54.831
  -159.810    54.380
>
  -159.589    54.831
  -159.810    54.380
>
  -159.589    54.831
  -159.768    54.584
>
  -159.589    54.831
  -159.768    54.584
>
  -160.477    55.349
  -159.768    54.584
>
  -160.477    55.349
  -159.768    54.584
>
  -159.589    54.831
  -159.801    54.318
>
  -159.589    54.831
  -159.801    54.318
>
  -159.589    54.831
  -159.867    54.704
>
  -159.589    54.831
  -159.867    54.704
>
  -160.477    55.349
  -159.867    54.704
>
  -160.477    55.349
  -159.867    54.704
>
  -159.589    54.831
  -159.725    54.730
>
  -159.589    54.831
  -159.725    54.730
>
  -160.477    55.349
  -159.725    54.730
>
  -160.477    55.349
  -159.725    54.730
>
  -159.589    54.831
  -159.653    54.889
>
  -159.589    54.831
  -159.653    54.889
>
  -160.477    55.349
  -159.653    54.889
>
  -160.477    55.349
  -159.653    54.889
>
  -159.589    54.831
  -159.642    54.564
>
  -159.589    54.831
  -159.642    54.564
>
  -160.477    55.349
  -159.642    54.564
>
  -160.477    55.349
  -159.642    54.564
>
  -160.477    55.349
  -159.642    54.564
>
  -159.589    54.831
  -159.596    54.799
>
  -159.589    54.831
  -159.596    54.799
>
  -160.477    55.349
  -159.596    54.799
>
  -160.477    55.349
  -159.596    54.799
>
  -160.477    55.349
  -159.513    55.425
>
  -160.477    55.349
  -159.513    55.425
>
  -159.368    56.031
  -159.513    55.425
>
  -159.368    56.031
  -159.513    55.425
>
  -159.368    56.031
  -159.513    55.425
>
  -159.558    56.072
  -159.513    55.425
>
  -159.558    56.072
  -159.513    55.425
>
  -159.558    56.072
  -159.513    55.425
>
  -159.085    56.126
  -159.513    55.425
>
  -159.085    56.126
  -159.513    55.425
>
  -159.562    56.152
  -159.513    55.425
>
  -159.562    56.152
  -159.513    55.425
>
  -159.562    56.152
  -159.513    55.425
>
  -159.589    54.831
  -159.547    55.023
>
  -159.589    54.831
  -159.547    55.023
>
  -160.477    55.349
  -159.547    55.023
>
  -160.477    55.349
  -159.547    55.023
>
  -159.589    54.831
  -159.778    54.522
>
  -159.589    54.831
  -159.778    54.522
>
  -160.477    55.349
  -159.778    54.522
>
  -159.589    54.831
  -159.798    54.548
>
  -159.589    54.831
  -159.798    54.548
>
  -160.477    55.349
  -159.798    54.548
>
  -160.477    55.349
  -159.798    54.548
>
  -160.477    55.349
  -160.363    54.897
>
  -160.477    55.349
  -160.363    54.897
>
  -161.864    55.148
  -160.363    54.897
>
  -161.864    55.148
  -160.363    54.897
>
  -161.864    55.148
  -160.363    54.897
>
  -161.742    55.421
  -160.363    54.897
>
  -161.742    55.421
  -160.363    54.897
>
  -161.790    55.374
  -160.363    54.897
>
  -161.790    55.374
  -160.363    54.897
>
  -161.790    55.374
  -160.363    54.897
>
  -161.856    55.346
  -160.363    54.897
>
  -161.856    55.346
  -160.363    54.897
>
  -161.904    55.317
  -160.363    54.897
>
  -161.904    55.317
  -160.363    54.897
>
  -161.904    55.317
  -160.363    54.897
>
  -159.589    54.831
  -159.545    54.555
>
  -159.589    54.831
  -159.545    54.555
>
  -160.477    55.349
  -159.545    54.555
>
  -160.477    55.349
  -159.545    54.555
>
  -159.589    54.831
  -159.829    54.364
>
  -159.589    54.831
  -159.829    54.364
>
  -159.589    54.831
  -160.385    54.831
>
  -159.589    54.831
  -160.385    54.831
>
  -160.477    55.349
  -160.385    54.831
>
  -160.477    55.349
  -160.385    54.831
>
  -161.864    55.148
  -160.385    54.831
>
  -161.790    55.374
  -160.385    54.831
>
  -159.589    54.831
  -159.396    55.317
>
  -159.589    54.831
  -159.396    55.317
>
  -160.477    55.349
  -159.396    55.317
>
  -160.477    55.349
  -159.396    55.317
>
  -159.368    56.031
  -159.396    55.317
>
  -159.368    56.031
  -159.396    55.317
>
  -159.264    56.081
  -159.396    55.317
>
  -159.264    56.081
  -159.396    55.317
>
  -159.558    56.072
  -159.396    55.317
>
  -159.558    56.072
  -159.396    55.317
>
  -159.085    56.126
  -159.396    55.317
>
  -159.562    56.152
  -159.396    55.317
>
  -159.483    56.202
  -159.396    55.317
>
  -159.208    56.304
  -159.396    55.317
>
  -160.477    55.349
  -159.510    55.445
>
  -159.368    56.031
  -159.510    55.445
>
  -159.368    56.031
  -159.510    55.445
>
  -159.264    56.081
  -159.510    55.445
>
  -159.264    56.081
  -159.510    55.445
>
  -159.264    56.081
  -159.510    55.445
>
  -159.558    56.072
  -159.510    55.445
>
  -159.558    56.072
  -159.510    55.445
>
  -159.558    56.072
  -159.510    55.445
>
  -159.085    56.126
  -159.510    55.445
>
  -159.085    56.126
  -159.510    55.445
>
  -159.562    56.152
  -159.510    55.445
>
  -159.562    56.152
  -159.510    55.445
>
  -159.483    56.202
  -159.510    55.445
>
  -159.483    56.202
  -159.510    55.445
>
  -159.208    56.304
  -159.510    55.445
>
  -159.208    56.304
  -159.510    55.445
>
  -160.477    55.349
  -160.863    54.379
>
  -160.477    55.349
  -160.863    54.379
>
  -160.477    55.349
  -160.863    54.379
>
  -160.477    55.349
  -161.098    54.524
>
  -160.477    55.349
  -161.098    54.524
>
  -160.477    55.349
  -160.950    54.565
>
  -160.477    55.349
  -160.950    54.565
>
  -160.477    55.349
  -160.883    54.506
>
  -161.864    55.148
  -161.092    54.562
>
  -161.864    55.148
  -161.092    54.562
>
  -160.477    55.349
  -161.092    54.562
>
  -160.477    55.349
  -161.092    54.562
>
  -161.904    55.317
  -161.092    54.562
>
  -161.790    55.374
  -161.092    54.562
>
  -161.742    55.421
  -161.092    54.562
>
  -162.281    55.107
  -161.092    54.562
>
  -162.259    55.145
  -161.092    54.562
>
  -162.259    55.145
  -161.092    54.562
>
  -160.477    55.349
  -160.772    54.713
>
  -160.477    55.349
  -160.772    54.713
>
  -159.589    54.831
  -160.772    54.713
>
  -159.589    54.831
  -160.772    54.713
>
  -161.864    55.148
  -160.772    54.713
>
  -161.864    55.148
  -160.772    54.713
>
  -161.790    55.374
  -160.772    54.713
>
  -161.790    55.374
  -160.772    54.713
>
  -161.742    55.421
  -160.772    54.713
>
  -161.742    55.421
  -160.772    54.713
>
  -161.904    55.317
  -160.772    54.713
>
  -161.904    55.317
  -160.772    54.713
>
  -162.324    54.971
  -160.772    54.713
>
  -162.259    55.145
  -160.772    54.713
>
  -162.281    55.107
  -160.772    54.713
>
  -162.281    55.107
  -160.772    54.713
>
  -161.864    55.148
  -161.039    54.521
>
  -161.864    55.148
  -161.039    54.521
>
  -160.477    55.349
  -161.039    54.521
>
  -160.477    55.349
  -161.039    54.521
>
  -162.324    54.971
  -161.039    54.521
>
  -162.324    54.971
  -161.039    54.521
>
  -161.904    55.317
  -161.039    54.521
>
  -161.904    55.317
  -161.039    54.521
>
  -161.790    55.374
  -161.039    54.521
>
  -161.790    55.374
  -161.039    54.521
>
  -162.281    55.107
  -161.039    54.521
>
  -162.281    55.107
  -161.039    54.521
>
  -162.259    55.145
  -161.039    54.521
>
  -161.742    55.421
  -161.039    54.521
>
  -161.742    55.421
  -161.039    54.521
>
  -161.864    55.148
  -161.130    54.524
>
  -161.864    55.148
  -161.130    54.524
>
  -160.477    55.349
  -161.130    54.524
>
  -160.477    55.349
  -161.130    54.524
>
  -162.324    54.971
  -161.130    54.524
>
  -162.324    54.971
  -161.130    54.524
>
  -161.790    55.374
  -161.130    54.524
>
  -161.790    55.374
  -161.130    54.524
>
  -162.281    55.107
  -161.130    54.524
>
  -162.259    55.145
  -161.130    54.524
>
  -162.259    55.145
  -161.130    54.524
>
  -161.742    55.421
  -161.130    54.524
>
  -161.742    55.421
  -161.130    54.524
>
  -161.864    55.148
  -161.150    54.573
>
  -161.864    55.148
  -161.150    54.573
>
  -160.477    55.349
  -161.150    54.573
>
  -160.477    55.349
  -161.150    54.573
>
  -162.324    54.971
  -161.150    54.573
>
  -162.324    54.971
  -161.150    54.573
>
  -161.904    55.317
  -161.150    54.573
>
  -161.790    55.374
  -161.150    54.573
>
  -162.281    55.107
  -161.150    54.573
>
  -162.281    55.107
  -161.150    54.573
>
  -162.259    55.145
  -161.150    54.573
>
  -162.259    55.145
  -161.150    54.573
>
  -159.589    54.831
  -161.150    54.573
>
  -161.742    55.421
  -161.150    54.573
>
  -161.742    55.421
  -161.150    54.573
>
  -161.864    55.148
  -161.099    54.508
>
  -161.864    55.148
  -161.099    54.508
>
  -160.477    55.349
  -161.099    54.508
>
  -162.324    54.971
  -161.099    54.508
>
  -162.324    54.971
  -161.099    54.508
>
  -161.904    55.317
  -161.099    54.508
>
  -161.904    55.317
  -161.099    54.508
>
  -161.790    55.374
  -161.099    54.508
>
  -161.790    55.374
  -161.099    54.508
>
  -162.281    55.107
  -161.099    54.508
>
  -162.281    55.107
  -161.099    54.508
>
  -162.281    55.107
  -161.099    54.508
>
  -162.259    55.145
  -161.099    54.508
>
  -162.259    55.145
  -161.099    54.508
>
  -161.742    55.421
  -161.099    54.508
>
  -161.742    55.421
  -161.099    54.508
>
  -161.864    55.148
  -161.283    54.757
>
  -161.864    55.148
  -161.283    54.757
>
  -161.904    55.317
  -161.283    54.757
>
  -161.790    55.374
  -161.283    54.757
>
  -161.790    55.374
  -161.283    54.757
>
  -161.742    55.421
  -161.283    54.757
>
  -161.742    55.421
  -161.283    54.757
>
  -162.259    55.145
  -161.283    54.757
>
  -162.259    55.145
  -161.283    54.757
>
  -162.281    55.107
  -161.283    54.757
>
  -162.281    55.107
  -161.283    54.757
>
  -161.998    55.433
  -161.283    54.757
>
  -162.324    54.971
  -161.283    54.757
>
  -162.324    54.971
  -161.283    54.757
>
  -160.477    55.349
  -161.283    54.757
>
  -160.477    55.349
  -161.283    54.757
>
  -161.971    55.507
  -161.283    54.757
>
  -162.788    55.191
  -161.283    54.757
>
  -161.864    55.148
  -161.003    54.285
>
  -161.864    55.148
  -161.003    54.285
>
  -161.864    55.148
  -160.925    54.353
>
  -161.864    55.148
  -160.925    54.353
>
  -160.477    55.349
  -160.475    54.917
>
  -160.477    55.349
  -160.475    54.917
>
  -161.864    55.148
  -160.475    54.917
>
  -161.864    55.148
  -160.475    54.917
>
  -161.864    55.148
  -160.475    54.917
>
  -161.790    55.374
  -160.475    54.917
>
  -161.742    55.421
  -160.475    54.917
>
  -161.742    55.421
  -160.475    54.917
>
  -161.856    55.346
  -160.475    54.917
>
  -161.856    55.346
  -160.475    54.917
>
  -161.904    55.317
  -160.475    54.917
>
  -160.477    55.349
  -160.439    54.932
>
  -161.864    55.148
  -160.439    54.932
>
  -161.864    55.148
  -160.439    54.932
>
  -161.864    55.148
  -160.439    54.932
>
  -161.742    55.421
  -160.439    54.932
>
  -161.742    55.421
  -160.439    54.932
>
  -161.790    55.374
  -160.439    54.932
>
  -161.856    55.346
  -160.439    54.932
>
  -161.856    55.346
  -160.439    54.932
>
  -161.904    55.317
  -160.439    54.932
>
  -160.477    55.349
  -160.474    54.984
>
  -160.477    55.349
  -160.474    54.984
>
  -161.742    55.421
  -160.474    54.984
>
  -161.742    55.421
  -160.474    54.984
>
  -161.790    55.374
  -160.474    54.984
>
  -161.790    55.374
  -160.474    54.984
>
  -161.864    55.148
  -160.474    54.984
>
  -161.864    55.148
  -160.474    54.984
>
  -161.856    55.346
  -160.474    54.984
>
  -161.856    55.346
  -160.474    54.984
>
  -161.998    55.433
  -160.474    54.984
>
  -161.998    55.433
  -160.474    54.984
>
  -160.477    55.349
  -159.719    54.606
>
  -160.477    55.349
  -159.719    54.606
>
  -161.864    55.148
  -160.451    54.874
>
  -161.864    55.148
  -160.451    54.874
>
  -161.790    55.374
  -160.451    54.874
>
  -161.742    55.421
  -160.451    54.874
>
  -161.856    55.346
  -160.451    54.874
>
  -161.856    55.346
  -160.451    54.874
>
  -161.904    55.317
  -160.451    54.874
>
  -160.477    55.349
  -159.779    54.501
>
  -160.477    55.349
  -159.779    54.501
>
  -160.477    55.349
  -159.488    55.029
>
  -160.477    55.349
  -159.488    55.029
>
  -160.477    55.349
  -160.731    55.029
>
  -161.864    55.148
  -160.731    55.029
>
  -161.864    55.148
  -160.731    55.029
>
  -161.742    55.421
  -160.731    55.029
>
  -161.742    55.421
  -160.731    55.029
>
  -161.742    55.421
  -160.731    55.029
>
  -161.790    55.374
  -160.731    55.029
>
  -161.790    55.374
  -160.731    55.029
>
  -161.856    55.346
  -160.731    55.029
>
  -161.856    55.346
  -160.731    55.029
>
  -161.998    55.433
  -160.731    55.029
>
  -161.998    55.433
  -160.731    55.029
>
  -161.971    55.507
  -160.731    55.029
>
  -162.259    55.145
  -160.731    55.029
>
  -162.259    55.145
  -160.731    55.029
>
  -162.281    55.107
  -160.731    55.029
>
  -162.324    54.971
  -160.731    55.029
>
  -161.904    55.317
  -160.731    55.029
>
  -161.904    55.317
  -160.731    55.029
>
  -159.368    56.031
  -159.496    55.325
>
  -159.368    56.031
  -159.496    55.325
>
  -159.558    56.072
  -159.496    55.325
>
  -159.558    56.072
  -159.496    55.325
>
  -159.264    56.081
  -159.496    55.325
>
  -159.264    56.081
  -159.496    55.325
>
  -159.085    56.126
  -159.496    55.325
>
  -159.562    56.152
  -159.496    55.325
>
  -159.562    56.152
  -159.496    55.325
>
  -159.483    56.202
  -159.496    55.325
>
  -159.553    56.285
  -159.496    55.325
>
  -159.553    56.285
  -159.496    55.325
>
  -159.208    56.304
  -159.496    55.325
>
  -159.208    56.304
  -159.496    55.325
>
  -159.085    56.126
  -158.632    55.838
>
  -159.264    56.081
  -158.632    55.838
>
  -159.264    56.081
  -158.632    55.838
>
  -159.368    56.031
  -158.632    55.838
>
  -159.208    56.304
  -158.632    55.838
>
  -159.558    56.072
  -158.632    55.838
>
  -159.483    56.202
  -158.632    55.838
>
  -159.562    56.152
  -158.632    55.838
>
  -159.553    56.285
  -158.632    55.838
>
  -158.281    56.802
  -158.632    55.838
>
  -158.281    56.802
  -158.632    55.838
>
  -159.558    56.072
  -159.672    55.198
>
  -159.264    56.081
  -159.672    55.198
>
  -159.264    56.081
  -159.672    55.198
>
  -159.562    56.152
  -159.672    55.198
>
  -159.085    56.126
  -159.672    55.198
>
  -155.622    55.822
  -156.438    55.109
>
  -155.622    55.822
  -156.438    55.109
>
  -159.589    54.831
  -160.555    54.569
>
  -159.589    54.831
  -160.304    54.573
>
  -159.589    54.831
  -160.304    54.573
>
  -159.589    54.831
  -160.234    54.517
>
  -159.589    54.831
  -160.234    54.517
>
  -159.589    54.831
  -160.177    54.588
>
  -159.589    54.831
  -160.177    54.588
>
  -159.589    54.831
  -160.175    54.536
>
  -159.589    54.831
  -160.175    54.536
>
  -159.589    54.831
  -159.956    54.629
>
  -159.589    54.831
  -159.956    54.629
>
  -159.589    54.831
  -159.956    54.629
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
  -160.497    55.341     0.300
  -160.138    54.978     0.300
  -161.864    55.148     0.300
  -161.742    55.421     0.300
  -161.790    55.374     0.300
  -161.856    55.346     0.300
  -160.477    55.349     0.300
  -162.263    54.966     0.300
  -161.904    55.317     0.300
  -161.998    55.433     0.300
  -162.281    55.107     0.300
  -161.921    55.453     0.300
  -159.164    56.221     0.300
  -159.562    56.152     0.300
  -159.589    54.820     0.300
  -159.589    54.831     0.300
  -159.085    56.126     0.300
  -159.553    56.285     0.300
  -159.551    56.286     0.300
  -158.414    56.301     0.300
  -158.281    56.802     0.300
  -158.059    56.913     0.300
  -158.231    56.895     0.300
  -159.368    56.031     0.300
  -159.316    56.284     0.300
  -159.455    56.227     0.300
  -159.558    56.072     0.300
  -158.215    56.966     0.300
  -162.252    55.149     0.300
  -155.620    55.822     0.300
  -159.589    54.831     0.300
  -158.540    56.306     0.300
  -155.622    55.822     0.300
  -159.264    56.081     0.300
  -159.483    56.202     0.300
  -159.208    56.304     0.300
  -162.259    55.145     0.300
  -162.324    54.971     0.300
  -161.971    55.507     0.300
  -162.788    55.191     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
  -160.432    54.888     0.200
>
  -160.519    54.947     0.200
>
  -159.990    54.761     0.200
>
  -159.933    54.682     0.200
>
  -159.602    54.670     0.200
>
  -159.662    54.817     0.200
>
  -159.526    54.720     0.200
>
  -159.716    54.679     0.200
>
  -160.153    54.703     0.200
>
  -160.101    54.771     0.200
>
  -161.380    54.795     0.200
>
  -159.797    54.677     0.200
>
  -160.781    54.557     0.200
>
  -160.510    54.780     0.200
>
  -160.438    54.880     0.200
>
  -160.112    54.947     0.200
>
  -160.517    54.961     0.200
>
  -159.820    54.531     0.200
>
  -161.262    54.684     0.200
>
  -160.346    54.809     0.200
>
  -160.989    54.430     0.200
>
  -161.051    54.574     0.200
>
  -161.043    54.385     0.200
>
  -160.890    54.646     0.200
>
  -160.550    55.046     0.200
>
  -159.890    54.743     0.200
>
  -160.409    54.801     0.200
>
  -159.944    54.708     0.200
>
  -159.601    54.761     0.200
>
  -160.322    54.671     0.200
>
  -160.918    54.350     0.200
>
  -160.008    54.797     0.200
>
  -160.723    54.544     0.200
>
  -160.479    54.312     0.200
>
  -160.491    54.979     0.200
>
  -160.142    54.659     0.200
>
  -160.131    54.518     0.200
>
  -159.835    54.698     0.200
>
  -159.572    54.964     0.200
>
  -159.694    55.115     0.200
>
  -161.118    54.427     0.200
>
  -160.866    54.582     0.200
>
  -160.491    54.982     0.200
>
  -160.427    54.923     0.200
>
  -160.404    54.717     0.200
>
  -160.398    54.885     0.200
>
  -161.265    55.583     0.200
>
  -160.503    55.007     0.200
>
  -160.518    54.983     0.200
>
  -160.575    54.774     0.200
>
  -160.343    54.962     0.200
>
  -161.247    54.719     0.200
>
  -159.905    54.710     0.200
>
  -159.893    54.705     0.200
>
  -158.307    55.465     0.200
>
  -160.368    54.801     0.200
>
  -160.150    54.674     0.200
>
  -160.125    54.681     0.200
>
  -160.426    55.208     0.200
>
  -160.857    54.410     0.200
>
  -158.482    54.918     0.200
>
  -159.485    55.051     0.200
>
  -159.825    54.731     0.200
>
  -160.789    54.433     0.200
>
  -160.835    54.399     0.200
>
  -159.239    54.862     0.200
>
  -159.527    54.785     0.200
>
  -160.589    54.719     0.200
>
  -160.743    54.780     0.200
>
  -158.598    55.442     0.200
>
  -158.544    55.372     0.200
>
  -159.692    55.132     0.200
>
  -159.574    55.225     0.200
>
  -158.458    55.762     0.200
>
  -158.612    55.245     0.200
>
  -158.604    54.835     0.200
>
  -160.071    54.193     0.200
>
  -160.904    54.370     0.200
>
  -160.450    54.710     0.200
>
  -159.515    55.124     0.200
>
  -159.825    54.693     0.200
>
  -159.156    54.902     0.200
>
  -157.910    56.065     0.200
>
  -160.550    54.709     0.200
>
  -159.935    54.735     0.200
>
  -159.328    55.075     0.200
>
  -159.255    54.813     0.200
>
  -160.495    54.941     0.200
>
  -160.213    54.589     0.200
>
  -159.044    55.592     0.200
>
  -159.825    54.635     0.200
>
  -159.975    54.774     0.200
>
  -159.673    54.566     0.200
>
  -160.865    54.386     0.200
>
  -160.870    54.358     0.200
>
  -160.828    54.386     0.200
>
  -160.824    54.319     0.200
>
  -159.804    54.623     0.200
>
  -159.588    55.166     0.200
>
  -159.030    54.846     0.200
>
  -160.948    54.436     0.200
>
  -157.598    55.748     0.200
>
  -157.402    56.234     0.200
>
  -161.176    54.425     0.200
>
  -160.975    54.481     0.200
>
  -160.691    54.513     0.200
>
  -159.893    54.708     0.200
>
  -158.593    54.894     0.200
>
  -159.544    55.057     0.200
>
  -160.824    54.335     0.200
>
  -160.101    54.860     0.200
>
  -160.657    54.534     0.200
>
  -159.254    56.332     0.200
>
  -160.305    54.475     0.200
>
  -158.727    55.939     0.200
>
  -158.562    55.016     0.200
>
  -158.521    55.118     0.200
>
  -159.384    55.163     0.200
>
  -158.662    54.916     0.200
>
  -158.831    55.098     0.200
>
  -158.488    54.922     0.200
>
  -160.743    54.602     0.200
>
  -158.400    54.880     0.200
>
  -158.374    54.882     0.200
>
  -159.629    55.178     0.200
>
  -160.648    54.665     0.200
>
  -159.345    55.204     0.200
>
  -159.336    55.145     0.200
>
  -158.476    55.119     0.200
>
  -158.864    55.059     0.200
>
  -160.429    54.791     0.200
>
  -160.363    54.824     0.200
>
  -159.846    54.624     0.200
>
  -159.636    55.163     0.200
>
  -160.811    54.678     0.200
>
  -160.778    54.687     0.200
>
  -159.686    55.197     0.200
>
  -159.344    55.214     0.200
>
  -160.763    54.493     0.200
>
  -160.848    54.912     0.200
>
  -160.136    54.935     0.200
>
  -159.350    55.225     0.200
>
  -160.588    54.267     0.200
>
  -160.386    54.766     0.200
>
  -158.835    55.073     0.200
>
  -160.214    54.682     0.200
>
  -160.434    54.931     0.200
>
  -160.470    54.946     0.200
>
  -160.489    54.979     0.200
>
  -159.234    54.943     0.200
>
  -159.609    55.172     0.200
>
  -160.418    54.837     0.200
>
  -160.494    54.984     0.200
>
  -160.435    54.882     0.200
>
  -160.362    54.921     0.200
>
  -160.393    54.911     0.200
>
  -160.450    54.977     0.200
>
  -161.155    54.527     0.200
>
  -160.457    54.918     0.200
>
  -160.948    54.514     0.200
>
  -158.331    54.941     0.200
>
  -158.508    55.119     0.200
>
  -161.077    54.574     0.200
>
  -159.862    54.892     0.200
>
  -160.474    54.539     0.200
>
  -159.235    54.943     0.200
>
  -161.082    54.532     0.200
>
  -160.368    54.841     0.200
>
  -159.594    55.172     0.200
>
  -160.372    54.834     0.200
>
  -161.287    54.766     0.200
>
  -160.565    54.217     0.200
>
  -160.418    54.909     0.200
>
  -158.478    54.944     0.200
>
  -158.698    54.891     0.200
>
  -160.477    54.977     0.200
>
  -160.346    54.856     0.200
>
  -160.462    54.944     0.200
>
  -160.961    54.539     0.200
>
  -159.726    55.246     0.200
>
  -160.507    55.003     0.200
>
  -160.424    54.862     0.200
>
  -160.548    54.225     0.200
>
  -160.435    54.935     0.200
>
  -159.894    54.887     0.200
>
  -160.454    54.939     0.200
>
  -160.251    54.632     0.200
>
  -160.669    54.716     0.200
>
  -161.017    54.869     0.200
>
  -159.611    55.186     0.200
>
  -160.886    54.414     0.200
>
  -160.710    54.707     0.200
>
  -158.586    55.083     0.200
>
  -159.333    54.723     0.200
>
  -160.986    54.499     0.200
>
  -159.802    54.753     0.200
>
  -159.886    54.875     0.200
>
  -159.786    54.584     0.200
>
  -159.750    54.458     0.200
>
  -159.805    54.387     0.200
>
  -159.751    54.422     0.200
>
  -159.804    54.332     0.200
>
  -159.737    54.334     0.200
>
  -159.777    54.439     0.200
>
  -159.835    54.520     0.200
>
  -159.960    54.327     0.200
>
  -159.813    54.355     0.200
>
  -159.800    54.494     0.200
>
  -159.899    54.258     0.200
>
  -159.808    54.410     0.200
>
  -159.961    54.267     0.200
>
  -159.769    54.285     0.200
>
  -159.749    54.595     0.200
>
  -159.922    54.415     0.200
>
  -159.726    54.481     0.200
>
  -159.826    54.286     0.200
>
  -159.766    54.429     0.200
>
  -159.695    54.539     0.200
>
  -159.903    54.274     0.200
>
  -159.760    54.460     0.200
>
  -159.777    54.388     0.200
>
  -159.731    54.496     0.200
>
  -159.688    54.483     0.200
>
  -159.761    54.582     0.200
>
  -159.738    54.436     0.200
>
  -159.654    54.330     0.200
>
  -159.755    54.376     0.200
>
  -159.639    54.238     0.200
>
  -159.805    54.245     0.200
>
  -159.686    54.468     0.200
>
  -159.715    54.205     0.200
>
  -159.603    54.369     0.200
>
  -159.919    54.358     0.200
>
  -159.772    54.336     0.200
>
  -159.833    54.509     0.200
>
  -159.742    54.298     0.200
>
  -159.798    54.511     0.200
>
  -159.747    54.571     0.200
>
  -159.756    54.547     0.200
>
  -159.737    54.270     0.200
>
  -159.628    54.307     0.200
>
  -159.888    54.292     0.200
>
  -159.827    54.308     0.200
>
  -159.766    54.310     0.200
>
  -159.778    54.417     0.200
>
  -159.775    54.221     0.200
>
  -159.790    54.263     0.200
>
  -159.809    54.391     0.200
>
  -159.746    54.371     0.200
>
  -159.786    54.265     0.200
>
  -159.785    54.374     0.200
>
  -159.905    54.334     0.200
>
  -159.785    54.481     0.200
>
  -159.716    54.536     0.200
>
  -159.773    54.618     0.200
>
  -159.757    54.447     0.200
>
  -159.734    54.368     0.200
>
  -159.813    54.295     0.200
>
  -159.778    54.218     0.200
>
  -159.842    54.437     0.200
>
  -159.735    54.377     0.200
>
  -159.789    54.266     0.200
>
  -159.789    54.274     0.200
>
  -159.787    54.421     0.200
>
  -159.684    54.293     0.200
>
  -159.757    54.375     0.200
>
  -159.785    54.357     0.200
>
  -159.770    54.539     0.200
>
  -159.651    54.443     0.200
>
  -159.693    54.490     0.200
>
  -159.797    54.440     0.200
>
  -159.880    54.568     0.200
>
  -159.836    54.525     0.200
>
  -159.746    54.249     0.200
>
  -159.746    54.581     0.200
>
  -159.742    54.451     0.200
>
  -159.801    54.396     0.200
>
  -159.833    54.362     0.200
>
  -159.660    54.294     0.200
>
  -159.590    54.438     0.200
>
  -159.651    54.422     0.200
>
  -159.766    54.504     0.200
>
  -159.792    54.280     0.200
>
  -159.761    54.322     0.200
>
  -159.858    54.215     0.200
>
  -159.702    54.456     0.200
>
  -159.751    54.499     0.200
>
  -159.734    54.535     0.200
>
  -159.601    54.323     0.200
>
  -159.872    54.409     0.200
>
  -159.791    54.090     0.200
>
  -159.739    54.417     0.200
>
  -159.861    54.391     0.200
>
  -159.817    54.428     0.200
>
  -159.788    54.315     0.200
>
  -159.785    54.322     0.200
>
  -159.684    54.257     0.200
>
  -159.684    54.570     0.200
>
  -159.768    54.183     0.200
>
  -159.734    54.130     0.200
>
  -159.781    54.335     0.200
>
  -159.710    54.455     0.200
>
  -159.752    54.368     0.200
>
  -159.868    54.525     0.200
>
  -159.654    54.527     0.200
>
  -159.727    54.482     0.200
>
  -159.765    54.262     0.200
>
  -159.777    54.636     0.200
>
  -160.411    54.919     0.200
>
  -159.764    54.250     0.200
>
  -159.874    54.400     0.200
>
  -159.840    54.372     0.200
>
  -159.766    54.403     0.200
>
  -159.646    54.636     0.200
>
  -159.854    54.477     0.200
>
  -160.486    54.770     0.200
>
  -159.778    54.064     0.200
>
  -159.853    54.342     0.200
>
  -159.763    54.332     0.200
>
  -159.759    54.170     0.200
>
  -159.783    54.074     0.200
>
  -159.759    54.577     0.200
>
  -159.885    54.467     0.200
>
  -159.762    54.509     0.200
>
  -159.813    54.269     0.200
>
  -159.691    54.510     0.200
>
  -159.982    54.201     0.200
>
  -159.758    54.156     0.200
>
  -159.733    54.392     0.200
>
  -159.726    54.527     0.200
>
  -159.822    54.392     0.200
>
  -159.775    54.315     0.200
>
  -159.781    54.563     0.200
>
  -159.730    54.473     0.200
>
  -159.845    54.483     0.200
>
  -159.415    54.514     0.200
>
  -159.790    54.573     0.200
>
  -159.823    54.449     0.200
>
  -159.768    54.417     0.200
>
  -159.771    54.517     0.200
>
  -158.269    55.386     0.200
>
  -160.380    54.896     0.200
>
  -159.812    54.385     0.200
>
  -159.793    54.580     0.200
>
  -159.833    54.226     0.200
>
  -159.821    54.099     0.200
>
  -159.729    54.641     0.200
>
  -159.822    54.428     0.200
>
  -159.833    54.425     0.200
>
  -159.970    54.294     0.200
>
  -160.081    54.190     0.200
>
  -159.877    54.497     0.200
>
  -159.890    54.288     0.200
>
  -159.821    54.411     0.200
>
  -159.851    54.140     0.200
>
  -159.796    54.267     0.200
>
  -159.821    54.488     0.200
>
  -159.701    54.275     0.200
>
  -159.759    54.569     0.200
>
  -159.803    54.264     0.200
>
  -159.706    55.207     0.200
>
  -159.851    54.532     0.200
>
  -159.876    54.454     0.200
>
  -159.804    54.260     0.200
>
  -159.674    54.534     0.200
>
  -159.622    54.989     0.200
>
  -159.765    54.656     0.200
>
  -159.780    54.649     0.200
>
  -159.733    54.492     0.200
>
  -159.810    54.395     0.200
>
  -159.366    55.277     0.200
>
  -159.619    54.658     0.200
>
  -159.699    54.609     0.200
>
  -159.721    54.559     0.200
>
  -159.817    54.519     0.200
>
  -159.703    54.663     0.200
>
  -159.693    54.526     0.200
>
  -156.582    56.348     0.200
>
  -159.798    54.598     0.200
>
  -160.393    54.764     0.200
>
  -159.898    54.308     0.200
>
  -159.939    54.204     0.200
>
  -159.737    54.439     0.200
>
  -159.766    54.624     0.200
>
  -159.799    54.614     0.200
>
  -159.446    55.411     0.200
>
  -160.930    54.363     0.200
>
  -159.778    54.343     0.200
>
  -159.749    54.645     0.200
>
  -159.801    54.356     0.200
>
  -159.806    54.409     0.200
>
  -159.487    55.004     0.200
>
  -160.440    54.873     0.200
>
  -159.006    55.601     0.200
>
  -159.770    54.600     0.200
>
  -159.807    54.211     0.200
>
  -159.772    54.656     0.200
>
  -159.224    55.214     0.200
>
  -159.855    54.294     0.200
>
  -159.764    54.570     0.200
>
  -159.805    54.429     0.200
>
  -159.558    54.937     0.200
>
  -159.773    54.575     0.200
>
  -159.807    54.410     0.200
>
  -159.731    54.692     0.200
>
  -159.802    54.411     0.200
>
  -160.207    54.601     0.200
>
  -159.789    54.584     0.200
>
  -159.796    54.333     0.200
>
  -159.800    54.318     0.200
>
  -159.807    54.437     0.200
>
  -159.767    54.196     0.200
>
  -159.697    54.587     0.200
>
  -160.277    54.430     0.200
>
  -158.623    55.059     0.200
>
  -159.750    54.595     0.200
>
  -160.321    54.867     0.200
>
  -159.771    54.467     0.200
>
  -158.601    55.062     0.200
>
  -158.397    54.918     0.200
>
  -158.790    55.043     0.200
>
  -158.630    54.996     0.200
>
  -158.636    55.370     0.200
>
  -156.302    55.769     0.200
>
  -158.601    55.428     0.200
>
  -158.640    54.943     0.200
>
  -157.313    56.017     0.200
>
  -159.739    54.526     0.200
>
  -156.596    55.395     0.200
>
  -159.350    55.162     0.200
>
  -156.481    55.057     0.200
>
  -158.732    54.829     0.200
>
  -156.408    55.949     0.200
>
  -160.350    54.805     0.200
>
  -158.893    55.044     0.200
>
  -158.782    54.861     0.200
>
  -155.891    55.486     0.200
>
  -156.701    56.319     0.200
>
  -159.715    54.721     0.200
>
  -156.153    55.736     0.200
>
  -158.854    54.385     0.200
>
  -159.793    54.600     0.200
>
  -159.793    54.673     0.200
>
  -159.723    54.341     0.200
>
  -159.812    54.470     0.200
>
  -159.712    54.530     0.200
>
  -159.900    54.137     0.200
>
  -159.810    54.380     0.200
>
  -159.768    54.584     0.200
>
  -159.801    54.318     0.200
>
  -159.867    54.704     0.200
>
  -159.725    54.730     0.200
>
  -159.653    54.889     0.200
>
  -159.642    54.564     0.200
>
  -159.596    54.799     0.200
>
  -159.513    55.425     0.200
>
  -156.548    56.124     0.200
>
  -159.547    55.023     0.200
>
  -159.778    54.522     0.200
>
  -159.798    54.548     0.200
>
  -160.363    54.897     0.200
>
  -159.545    54.555     0.200
>
  -159.829    54.364     0.200
>
  -160.385    54.831     0.200
>
  -156.863    54.900     0.200
>
  -159.396    55.317     0.200
>
  -159.510    55.445     0.200
>
  -160.863    54.379     0.200
>
  -161.098    54.524     0.200
>
  -160.950    54.565     0.200
>
  -160.883    54.506     0.200
>
  -161.092    54.562     0.200
>
  -160.772    54.713     0.200
>
  -161.039    54.521     0.200
>
  -161.130    54.524     0.200
>
  -161.150    54.573     0.200
>
  -161.099    54.508     0.200
>
  -161.283    54.757     0.200
>
  -161.003    54.285     0.200
>
  -160.925    54.353     0.200
>
  -160.475    54.917     0.200
>
  -160.439    54.932     0.200
>
  -160.474    54.984     0.200
>
  -159.719    54.606     0.200
>
  -160.451    54.874     0.200
>
  -157.090    55.234     0.200
>
  -159.733    54.122     0.200
>
  -159.779    54.501     0.200
>
  -159.488    55.029     0.200
>
  -160.731    55.029     0.200
>
  -159.496    55.325     0.200
>
  -158.632    55.838     0.200
>
  -159.672    55.198     0.200
>
  -156.438    55.109     0.200
>
  -160.555    54.569     0.200
>
  -160.304    54.573     0.200
>
  -160.234    54.517     0.200
>
  -160.177    54.588     0.200
>
  -160.175    54.536     0.200
>
  -159.956    54.629     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
  -159.807    54.681     0.000   222.000   222.000
  -159.807    54.681     0.000   444.000   444.000
EOF
gmt end
