#!/bin/bash
gmt begin sapporo1.54_xsec_1 pdf,ps
proj=-JX18.0/-6.7
reg=-R-128.1/100.4/0/85.0
gmt basemap $proj $reg -Bxa10f10+l'Distance (km)' -Bya10f10+l'Depth (km)' -BWesN+t'Cross-section sapporo1.54'
# Event    1 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.898    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.898    55.000
    36.898    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    2 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    88.466    69.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    88.466    66.000
    88.466    72.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    3 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.017    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.017    53.000
    43.017    59.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    4 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    39.585    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    39.585    55.000
    39.585    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    5 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    44.275    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    44.275    60.000
    44.275    66.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    6 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.934    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.934    56.000
    38.934    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    7 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.298    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.298    57.000
    32.298    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    8 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    54.013    66.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    54.013    63.000
    54.013    69.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event    9 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.785    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.785    56.000
     0.785    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   10 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.664    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.664    30.000
     1.664    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   11 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -5.444    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -5.444    24.000
    -5.444    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   12 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.851    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.851    55.000
    36.851    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   13 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.299    38.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.299    35.000
    29.299    41.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    29.299    38.000     0.200
EOF

# Event   14 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.255    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.255    34.000
    38.255    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   15 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    34.386    41.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    34.386    38.000
    34.386    44.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   16 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.904    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.904    36.000
    32.904    42.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   17 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.949    42.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.949    39.000
    29.949    45.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   18 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    45.755    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    45.755    54.000
    45.755    60.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   19 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.189    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.189    58.000
    36.189    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   20 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    33.391    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    33.391    58.000
    33.391    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   21 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    40.768    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    40.768    55.000
    40.768    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   22 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    41.524    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    41.524    57.000
    41.524    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   23 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    44.716    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    44.716    57.000
    44.716    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   24 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    35.116    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    35.116    32.000
    35.116    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   25 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.356    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.356    57.000
    37.356    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   26 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     2.111    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     2.111    54.000
     2.111    60.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   27 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    95.378    78.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    95.378    75.000
    95.378    81.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   28 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     6.726    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     6.726    19.000
     6.726    25.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   29 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.689    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.689    30.000
     0.689    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   30 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    35.529    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    35.529    55.000
    35.529    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   31 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.997    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.997    53.000
    -2.997    59.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   32 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    46.553    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    46.553    57.000
    46.553    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   33 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    44.013    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    44.013    55.000
    44.013    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   34 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.224    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.224    56.000
    38.224    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   35 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -69.876    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -69.876    24.000
   -69.876    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   36 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.825    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.825    56.000
    36.825    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   37 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.146    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.146    56.000
    43.146    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   38 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.321     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.321     3.000
     3.321    10.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   39 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    40.352    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    40.352    56.000
    40.352    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   40 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.084    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.084    23.000
     7.084    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   41 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.342    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.342    20.000
    -1.342    26.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    -1.342    23.000     0.200
EOF

# Event   42 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     2.331    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     2.331    22.000
     2.331    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   43 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.821    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.821    23.000
     0.821    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   44 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.217    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.217    30.000
     0.217    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   45 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     6.837    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     6.837    28.000
     6.837    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   46 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.984    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.984    22.000
     3.984    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   47 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     8.705    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     8.705    22.000
     8.705    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   48 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.438    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.438    29.000
    -4.438    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   49 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.858    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.858    19.000
     3.858    25.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   50 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -14.203    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -14.203    21.000
   -14.203    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   51 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     8.753    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     8.753    24.000
     8.753    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   52 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -9.992    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -9.992    22.000
    -9.992    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   53 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -8.392    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -8.392    20.000
    -8.392    26.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   54 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -0.871    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -0.871    20.000
    -0.871    26.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   55 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -8.902    38.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -8.902    35.000
    -8.902    41.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   56 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.207    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.207    25.000
    -4.207    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   57 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.028    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.028    17.000
    -6.028    23.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   58 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -14.876    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -14.876    21.000
   -14.876    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   59 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.227    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.227    56.000
    43.227    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   60 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -5.220    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -5.220    13.000
    -5.220    19.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   61 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.931    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.931    17.000
    -1.931    23.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   62 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.088    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.088    25.000
    11.088    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   63 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.663    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.663    25.000
    15.663    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   64 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -0.798    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -0.798    22.000
    -0.798    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   65 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    46.517    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    46.517    53.000
    46.517    59.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   66 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.759    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.759    55.000
    15.759    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   67 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.751    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.751    31.000
   -10.751    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   68 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.353    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.353    53.000
    16.353    59.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   69 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     9.674    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     9.674    12.000
     9.674    18.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   70 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.430    71.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.430    68.000
    26.430    74.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   71 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.536    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.536    23.000
    -1.536    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   72 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    46.868    79.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    46.868    76.000
    46.868    82.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   73 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -15.460    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -15.460    26.000
   -15.460    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   74 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.495    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.495    57.000
    38.495    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   75 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    31.432    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    31.432    25.000
    31.432    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   76 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.144    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.144    42.000
    29.144    48.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   77 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.548    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.548    57.000
    37.548    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   78 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.179    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.179    23.000
    -3.179    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   79 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -16.549    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -16.549    25.000
   -16.549    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   80 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    39.235    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    39.235    57.000
    39.235    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   81 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    39.727    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    39.727    56.000
    39.727    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   82 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.935    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.935    56.000
    42.935    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   83 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.053    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.053    60.000
    36.053    66.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   84 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.280    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.280    58.000
    30.280    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   85 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    39.522    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    39.522    58.000
    39.522    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   86 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    35.558    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    35.558    61.000
    35.558    67.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   87 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.810    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.810    23.000
   -10.810    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   88 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     4.969    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     4.969    29.000
     4.969    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   89 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    33.947    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    33.947    59.000
    33.947    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   90 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.728    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.728    33.000
    -3.728    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   91 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.686    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.686    49.000
     1.686    55.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   92 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.371    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.371    57.000
    36.371    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   93 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.178    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.178    36.000
    15.178    42.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   94 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.275    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.275    29.000
    20.275    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   95 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.848    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.848    58.000
    30.848    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   96 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    64.623    70.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    64.623    67.000
    64.623    73.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   97 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.534    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.534    26.000
    29.534    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   98 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.365    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.365    57.000
    32.365    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event   99 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -38.924    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -38.924    30.000
   -38.924    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  100 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.098    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.098    58.000
    32.098    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  101 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     8.321    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     8.321    48.000
     8.321    54.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  102 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.770    41.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.770    38.000
   -29.770    44.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  103 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.627    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.627    23.000
   -11.627    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  104 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    39.206    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    39.206    55.000
    39.206    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  105 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -65.751    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -65.751    35.000
   -65.751    43.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  106 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.310    72.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.310    69.000
    25.310    75.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  107 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -52.497    55.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -52.497    52.000
   -52.497    58.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  108 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.460    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.460    34.000
   -11.460    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  109 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.770    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.770    46.000
    -7.770    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  110 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     4.634    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     4.634    45.000
     4.634    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  111 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.128    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.128    57.000
    37.128    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  112 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.542    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.542    44.000
     0.542    50.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  113 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.998    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.998    58.000
    23.998    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  114 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.967    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.967    29.000
    19.967    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  115 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    39.183    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    39.183    58.000
    39.183    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  116 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.563    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.563    59.000
    25.563    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  117 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -9.433    55.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -9.433    52.000
    -9.433    58.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  118 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.569    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.569    37.000
   -44.569    43.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  119 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -14.592    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -14.592    46.000
   -14.592    52.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  120 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    69.324    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    69.324    55.000
    69.324    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  121 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -66.325    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -66.325    14.000
   -66.325    20.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  122 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -66.008    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -66.008    14.000
   -66.008    20.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  123 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -53.517    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -53.517    30.000
   -53.517    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  124 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.449    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.449    29.000
     1.449    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  125 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.762    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.762    37.000
    17.762    43.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  126 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.682    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.682    18.000
   -10.682    24.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  127 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    33.980    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    33.980    32.000
    33.980    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  128 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.670    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.670    57.000
   -12.670    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  129 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    31.403    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    31.403    56.000
    31.403    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  130 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.690    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.690    15.000
   -29.690    23.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  131 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.960    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.960    59.000
    28.960    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  132 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.651    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.651    57.000
    27.651    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  133 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.124    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.124    29.000
   -29.124    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  134 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.073    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.073    51.000
    -4.073    57.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  135 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    74.286    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    74.286    54.000
    74.286    60.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  136 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    61.969    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    61.969    56.000
    61.969    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  137 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.986    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.986    58.000
    28.986    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  138 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.915    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.915    30.000
    22.915    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  139 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.274    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.274    60.000
    22.274    66.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  140 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    47.538    65.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    47.538    62.000
    47.538    68.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  141 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -32.548    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -32.548    36.000
   -32.548    42.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  142 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.484    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.484    57.000
    37.484    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  143 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.304    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.304    24.000
   -23.304    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  144 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.357    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.357    57.000
    32.357    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  145 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.400    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.400    45.000
    11.400    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  146 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -49.237    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -49.237    49.000
   -49.237    55.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  147 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.907    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.907    56.000
    18.907    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  148 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.544    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.544    43.000
     7.544    49.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  149 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    52.781    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    52.781    58.000
    52.781    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  150 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.138    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.138    43.000
     7.138    49.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  151 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -8.604    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -8.604    33.000
    -8.604    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  152 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.667    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.667    58.000
    42.667    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  153 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.493    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.493    56.000
    25.493    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  154 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.022    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.022    57.000
    27.022    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  155 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.073    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.073    34.000
    14.073    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  156 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.529    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.529    51.000
    23.529    57.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  157 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.322    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.322    55.000
    27.322    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  158 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.684    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.684    58.000
    25.684    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  159 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.109    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.109    56.000
    24.109    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  160 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    79.430    55.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    79.430    52.000
    79.430    58.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  161 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.954    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.954    58.000
    43.954    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  162 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.792    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.792    26.000
    -2.792    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  163 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.100    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.100    58.000
    18.100    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  164 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.661    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.661    57.000
    42.661    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  165 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.880    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.880    57.000
    27.880    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  166 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.652    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.652    28.000
   -19.652    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  167 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.485    67.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.485    64.000
   -12.485    70.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  168 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.733    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.733    58.000
    25.733    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  169 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.360    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.360    59.000
    18.360    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  170 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.968    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.968    53.000
    32.968    59.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  171 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    51.697    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    51.697    55.000
    51.697    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  172 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.805    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.805    59.000
    22.805    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  173 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.428    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.428    57.000
    26.428    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  174 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    45.671    76.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    45.671    73.000
    45.671    79.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  175 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.730    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.730    58.000
    24.730    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  176 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    71.271    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    71.271    48.000
    71.271    54.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  177 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    72.426    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    72.426    49.000
    72.426    55.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  178 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.926    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.926    51.000
    36.926    57.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  179 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.820    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.820    58.000
    17.820    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  180 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.003    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.003    57.000
    24.003    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  181 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.472    68.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.472    65.000
    12.472    71.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  182 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    21.645    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    21.645    56.000
    21.645    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  183 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    52.493    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    52.493    48.000
    52.493    54.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  184 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.825    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.825    56.000
    25.825    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  185 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.655    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.655    54.000
    28.655    60.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  186 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.048    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.048    25.000
    11.048    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  187 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.479    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.479    57.000
    19.479    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  188 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.887    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.887    56.000
    16.887    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  189 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.339    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.339    58.000
    26.339    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  190 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.347    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.347    57.000
    28.347    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  191 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.017    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.017    57.000
    24.017    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  192 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.583    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.583    57.000
    26.583    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  193 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.492    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.492    59.000
    15.492    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  194 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.990    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.990    56.000
    24.990    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  195 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.609    67.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.609    64.000
    13.609    70.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  196 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.783    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.783    57.000
    20.783    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  197 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.188    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.188    59.000
    28.188    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  198 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.524    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.524    61.000
    19.524    67.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  199 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.546    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.546    57.000
    22.546    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  200 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.392    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.392    56.000
    24.392    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  201 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.832    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.832    59.000
    25.832    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  202 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.544    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.544    55.000
    26.544    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  203 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -21.228    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -21.228    57.000
   -21.228    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  204 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.866    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.866    57.000
    20.866    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  205 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.472    55.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.472    52.000
    36.472    58.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  206 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    64.058    55.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    64.058    52.000
    64.058    58.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  207 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.055    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.055    57.000
    17.055    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  208 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.306    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.306    58.000
    24.306    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  209 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.161    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.161    57.000
    24.161    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  210 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.222    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.222    57.000
    32.222    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  211 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.669    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.669    58.000
    20.669    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  212 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.055    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.055    59.000
    32.055    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  213 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.099    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.099    54.000
    22.099    60.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  214 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    48.914    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    48.914    50.000
    48.914    56.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  215 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.782    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.782    57.000
    25.782    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  216 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    65.821    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    65.821    50.000
    65.821    56.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  217 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.505    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.505    57.000
    26.505    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  218 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.224    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.224    58.000
    17.224    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  219 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.632    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.632    57.000
    25.632    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  220 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.250    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.250    55.000
    25.250    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  221 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.165    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.165    45.000
    29.165    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  222 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -43.270    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -43.270    50.000
   -43.270    56.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  223 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -84.465    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -84.465    12.000
   -84.465    20.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  224 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    55.901    55.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    55.901    52.000
    55.901    58.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  225 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.065    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.065    57.000
    24.065    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  226 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.031    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.031    37.000
    -6.031    43.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  227 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.639    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.639    57.000
    24.639    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  228 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.834    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.834    59.000
    25.834    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  229 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.052    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.052    57.000
    22.052    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  230 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    21.922    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    21.922    54.000
    21.922    60.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  231 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -28.026    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -28.026    49.000
   -28.026    55.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  232 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -123.099    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -123.099    13.000
  -123.099    19.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  233 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.310    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.310    53.000
    28.310    59.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  234 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.717    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.717    57.000
    16.717    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  235 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -9.505    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -9.505    25.000
    -9.505    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  236 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.992    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.992    57.000
    26.992    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  237 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.259    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.259    18.000
    20.259    24.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  238 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.798    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.798     6.000
   -12.798    14.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  239 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -5.766    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -5.766     8.000
    -5.766    14.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  240 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.997    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.997    13.000
    -3.997    19.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  241 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -18.046    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -18.046    50.000
   -18.046    56.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  242 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.303    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.303    57.000
    17.303    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  243 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.055    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.055    57.000
    27.055    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  244 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.543    68.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.543    65.000
    10.543    71.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  245 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.527    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.527    57.000
    17.527    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  246 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.790    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.790    55.000
    25.790    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  247 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.678    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.678    54.000
    25.678    60.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  248 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.199    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.199    60.000
    18.199    66.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  249 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -30.618    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -30.618    30.000
   -30.618    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  250 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.393    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.393    54.000
    27.393    60.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  251 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    65.544    74.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    65.544    71.000
    65.544    77.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  252 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.891    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.891    58.000
    26.891    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  253 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.120    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.120    60.000
    18.120    66.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  254 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    36.580    55.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    36.580    52.000
    36.580    58.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  255 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.511    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.511    58.000
    16.511    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  256 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.876    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.876    54.000
    22.876    60.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  257 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.733    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.733    57.000
    22.733    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  258 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.428    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.428    56.000
    26.428    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  259 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -21.897    42.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -21.897    39.000
   -21.897    45.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  260 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.262    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.262    56.000
    17.262    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  261 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.306    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.306    55.000
    24.306    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  262 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.137    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.137    31.000
   -19.137    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  263 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.082    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.082    57.000
    28.082    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  264 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -14.760    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -14.760    51.000
   -14.760    57.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  265 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -31.082    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -31.082    33.000
   -31.082    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  266 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.847    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.847    31.000
   -29.847    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  267 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    53.284    80.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    53.284    77.000
    53.284    83.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  268 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -110.594    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -110.594     6.000
  -110.594    14.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  269 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.974    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.974    56.000
    24.974    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  270 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    81.270    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    81.270    51.000
    81.270    57.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  271 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -30.015    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -30.015    31.000
   -30.015    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  272 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -18.266    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -18.266    47.000
   -18.266    53.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  273 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -80.655    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -80.655    26.000
   -80.655    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  274 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -79.973    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -79.973    27.000
   -79.973    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  275 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.852    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.852    60.000
    16.852    66.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  276 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    21.686    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    21.686    56.000
    21.686    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  277 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.201    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.201    58.000
   -13.201    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  278 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.920    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.920    57.000
    24.920    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  279 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    51.797    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    51.797    61.000
    51.797    67.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  280 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    78.242    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    78.242    55.000
    78.242    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  281 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.307    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.307    56.000
    28.307    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  282 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.528    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.528    57.000
    26.528    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  283 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.546    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.546    57.000
    17.546    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  284 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.611    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.611    58.000
    17.611    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  285 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.316    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.316    58.000
    28.316    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  286 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.179    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.179    61.000
    17.179    67.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  287 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.099    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.099    57.000
    23.099    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  288 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.886    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.886    56.000
    25.886    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  289 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.186    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.186    56.000
    23.186    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  290 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.702    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.702    57.000
    27.702    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  291 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.729    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.729    59.000
    20.729    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  292 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    21.911    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    21.911    59.000
    21.911    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  293 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.675    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.675    60.000
    13.675    66.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  294 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.831    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.831    57.000
    25.831    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  295 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -88.247    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -88.247    28.000
   -88.247    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  296 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -90.777    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -90.777    23.000
   -90.777    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  297 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.299    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.299    60.000
    20.299    66.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  298 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    59.023    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    59.023    61.000
    59.023    67.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  299 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.767    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.767    54.000
    27.767    60.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  300 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -20.932    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -20.932    43.000
   -20.932    49.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  301 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    53.991    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    53.991    58.000
    53.991    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  302 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.890    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.890    59.000
    22.890    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  303 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.541    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.541    30.000
   -76.541    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
   -76.541    33.000     0.200
EOF

# Event  304 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.896    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.896    25.000
   -74.896    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  305 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.181    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.181    25.000
   -74.181    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  306 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -84.285    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -84.285    30.000
   -84.285    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  307 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -77.097    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -77.097    31.000
   -77.097    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  308 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.774    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.774    30.000
   -76.774    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  309 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -79.709    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -79.709    29.000
   -79.709    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  310 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.269    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.269    27.000
   -76.269    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  311 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.578    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.578    31.000
   -74.578    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  312 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -73.461    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -73.461    31.000
   -73.461    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  313 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.243    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.243    28.000
   -76.243    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  314 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.817    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.817    28.000
   -74.817    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  315 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.211    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.211    33.000
   -74.211    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  316 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.061    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.061    30.000
   -74.061    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  317 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -82.834    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -82.834    30.000
   -82.834    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  318 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -73.871    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -73.871    30.000
   -73.871    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  319 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.616    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.616    31.000
   -74.616    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  320 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -77.181    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -77.181    31.000
   -77.181    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  321 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -83.468    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -83.468    29.000
   -83.468    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  322 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.228    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.228    31.000
   -74.228    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  323 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -78.132    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -78.132    30.000
   -78.132    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  324 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -80.208    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -80.208    30.000
   -80.208    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  325 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.244    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.244    27.000
   -74.244    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  326 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -73.868    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -73.868    27.000
   -73.868    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  327 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -83.021    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -83.021    30.000
   -83.021    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  328 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -78.114    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -78.114    29.000
   -78.114    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  329 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -68.726    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -68.726    31.000
   -68.726    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  330 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.740    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.740    27.000
   -74.740    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  331 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -80.134    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -80.134    29.000
   -80.134    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  332 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -73.793    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -73.793    30.000
   -73.793    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  333 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -73.636    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -73.636    32.000
   -73.636    38.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  334 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -79.088    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -79.088    29.000
   -79.088    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  335 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -78.350    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -78.350    30.000
   -78.350    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  336 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.801    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.801    29.000
   -76.801    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  337 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -79.354    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -79.354    28.000
   -79.354    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  338 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -80.350    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -80.350    29.000
   -80.350    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  339 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -77.216    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -77.216    28.000
   -77.216    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  340 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.194    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.194    29.000
   -76.194    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  341 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -68.908    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -68.908    28.000
   -68.908    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  342 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -77.017    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -77.017    29.000
   -77.017    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  343 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -73.643    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -73.643    27.000
   -73.643    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  344 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -77.120    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -77.120    28.000
   -77.120    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  345 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -83.602    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -83.602    14.000
   -83.602    20.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  346 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -83.008    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -83.008    28.000
   -83.008    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  347 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.400    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.400    27.000
   -76.400    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  348 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.391    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.391    27.000
   -74.391    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  349 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.820    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.820    28.000
   -76.820    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  350 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -78.161    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -78.161    29.000
   -78.161    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  351 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -77.118    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -77.118    24.000
   -77.118    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  352 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -83.433    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -83.433    29.000
   -83.433    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  353 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -73.164    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -73.164    31.000
   -73.164    37.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  354 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -81.358    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -81.358    25.000
   -81.358    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  355 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.489    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.489    30.000
   -74.489    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  356 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    21.644    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    21.644    59.000
    21.644    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  357 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -73.211    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -73.211    33.000
   -73.211    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  358 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -81.059    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -81.059    29.000
   -81.059    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  359 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -64.881    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -64.881    28.000
   -64.881    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  360 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.801    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.801    30.000
   -76.801    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  361 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -69.016    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -69.016    23.000
   -69.016    29.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  362 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.933    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.933    30.000
   -76.933    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  363 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -71.340    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -71.340    30.000
   -71.340    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  364 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.415    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.415    27.000
   -74.415    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  365 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.735    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.735    28.000
   -74.735    34.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  366 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -72.273    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -72.273    20.000
   -72.273    26.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  367 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -84.717    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -84.717    27.000
   -84.717    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  368 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.771    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.771    33.000
    10.771    39.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  369 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.715    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.715    57.000
    22.715    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  370 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.879    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.879    25.000
   -76.879    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  371 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -77.666    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -77.666    27.000
   -77.666    33.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  372 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.693    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.693    56.000
    26.693    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  373 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -79.866    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -79.866    29.000
   -79.866    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  374 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -82.060    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -82.060    25.000
   -82.060    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  375 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -82.480    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -82.480    30.000
   -82.480    36.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  376 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -80.154    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -80.154    25.000
   -80.154    31.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  377 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.036    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.036    56.000
    26.036    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  378 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.051    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.051    55.000
    28.051    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  379 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -25.081    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -25.081    18.000
   -25.081    24.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  380 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -84.284    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -84.284    29.000
   -84.284    35.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  381 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.958    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.958    57.000
    25.958    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  382 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.364    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.364    56.000
    25.364    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  383 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.444    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.444    56.000
    25.444    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  384 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -71.160    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -71.160    26.000
   -71.160    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  385 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.974    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.974    21.000
    19.974    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  386 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.044    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.044    57.000
    26.044    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  387 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    66.676    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    66.676    49.000
    66.676    55.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  388 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.172    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.172    56.000
    19.172    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  389 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.144    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.144    59.000
    18.144    65.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  390 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.054    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.054    58.000
    25.054    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  391 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -86.396    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -86.396    26.000
   -86.396    32.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  392 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -77.735    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -77.735    34.000
   -77.735    40.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  393 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.745    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.745    58.000
    29.745    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  394 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.686    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.686    57.000
    43.686    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  395 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    69.786    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    69.786    49.000
    69.786    55.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  396 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.319    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.319    58.000
    18.319    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  397 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.421    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.421    58.000
    17.421    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  398 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    84.349    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    84.349    58.000
    84.349    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  399 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.134    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.134    45.000
    -1.134    51.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  400 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.617    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.617    60.000
    30.617    66.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  401 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.067    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.067    22.000
   -19.067    28.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  402 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.092    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.092    56.000
   -45.092    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  403 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.369    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.369    56.000
    24.369    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  404 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.060    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.060    57.000
    27.060    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  405 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -9.327    43.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -9.327    40.000
    -9.327    46.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  406 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.219    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.219    60.000
    16.219    66.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  407 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    22.221    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    22.221    56.000
    22.221    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  408 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -28.978    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -28.978    24.000
   -28.978    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  409 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    21.940    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    21.940    57.000
    21.940    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  410 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.887    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.887    58.000
    17.887    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  411 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    26.582    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    26.582    57.000
    26.582    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  412 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.320    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.320    61.000
    20.320    67.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  413 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.537    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.537    56.000
    24.537    62.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  414 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.466    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.466    60.000
    17.466    66.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  415 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.476    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.476    58.000
    19.476    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  416 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.282    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.282    58.000
    17.282    64.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  417 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     9.554    68.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     9.554    65.000
     9.554    71.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  418 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -16.529    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -16.529    24.000
   -16.529    30.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  419 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.556    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.556    57.000
    24.556    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  420 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.909    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.909    36.000
   -45.909    42.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  421 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.341    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.341    21.000
   -45.341    27.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  422 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.909    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.909    57.000
    25.909    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  423 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    86.731    69.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    86.731    66.000
    86.731    72.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  424 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -9.021    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -9.021    57.000
    -9.021    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  425 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.798    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.798    57.000
    24.798    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  426 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.409    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.409    57.000
    25.409    63.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  427 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.590    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.590    55.000
    20.590    61.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  428 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.939     8.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.939     4.000
    11.939    12.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  429 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    25.525    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    25.525    54.000
    25.525    60.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF

# Event  430 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.153    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.153     6.000
    24.153    16.000
EOF
# User-defined star
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
EOF


# Event numbers
gmt text $proj $reg -F+f8p,Helvetica,black+a0.+jBL << EOF
    37.098    58.000 1
    88.666    69.000 2
    43.217    56.000 3
    39.785    58.000 4
    44.475    63.000 5
    39.134    59.000 6
    32.498    60.000 7
    54.213    66.000 8
     0.985    59.000 9
     1.864    33.000 10
    -5.244    27.000 11
    37.051    58.000 12
    29.499    38.000 13
    38.455    37.000 14
    34.586    41.000 15
    33.104    39.000 16
    30.149    42.000 17
    45.955    57.000 18
    36.389    61.000 19
    33.591    61.000 20
    40.968    58.000 21
    41.724    60.000 22
    44.916    60.000 23
    35.316    35.000 24
    37.556    60.000 25
     2.311    57.000 26
    95.578    78.000 27
     6.926    22.000 28
     0.889    33.000 29
    35.729    58.000 30
    -2.797    56.000 31
    46.753    60.000 32
    44.213    58.000 33
    38.424    59.000 34
   -69.676    28.000 35
    37.025    59.000 36
    43.346    59.000 37
     3.521     6.000 38
    40.552    59.000 39
     7.284    26.000 40
    -1.142    23.000 41
     2.531    25.000 42
     1.021    26.000 43
     0.417    33.000 44
     7.037    31.000 45
     4.184    25.000 46
     8.905    25.000 47
    -4.238    32.000 48
     4.058    22.000 49
   -14.003    24.000 50
     8.953    27.000 51
    -9.792    25.000 52
    -8.192    23.000 53
    -0.671    23.000 54
    -8.702    38.000 55
    -4.007    28.000 56
    -5.828    20.000 57
   -14.676    24.000 58
    43.427    59.000 59
    -5.020    16.000 60
    -1.731    20.000 61
    11.288    28.000 62
    15.863    28.000 63
    -0.598    25.000 64
    46.717    56.000 65
    15.959    58.000 66
   -10.551    34.000 67
    16.553    56.000 68
     9.874    15.000 69
    26.630    71.000 70
    -1.336    26.000 71
    47.068    79.000 72
   -15.260    29.000 73
    38.695    60.000 74
    31.632    28.000 75
    29.344    45.000 76
    37.748    60.000 77
    -2.979    26.000 78
   -16.349    28.000 79
    39.435    60.000 80
    39.927    59.000 81
    43.135    59.000 82
    36.253    63.000 83
    30.480    61.000 84
    39.722    61.000 85
    35.758    64.000 86
   -10.610    26.000 87
     5.169    32.000 88
    34.147    62.000 89
    -3.528    36.000 90
     1.886    52.000 91
    36.571    60.000 92
    15.378    39.000 93
    20.475    32.000 94
    31.048    61.000 95
    64.823    70.000 96
    29.734    29.000 97
    32.565    60.000 98
   -38.724    34.000 99
    32.298    61.000 100
     8.521    51.000 101
   -29.570    41.000 102
   -11.427    26.000 103
    39.406    58.000 104
   -65.551    39.000 105
    25.510    72.000 106
   -52.297    55.000 107
   -11.260    37.000 108
    -7.570    49.000 109
     4.834    48.000 110
    37.328    60.000 111
     0.742    47.000 112
    24.198    61.000 113
    20.167    32.000 114
    39.383    61.000 115
    25.763    62.000 116
    -9.233    55.000 117
   -44.369    40.000 118
   -14.392    49.000 119
    69.524    58.000 120
   -66.125    17.000 121
   -65.808    17.000 122
   -53.317    33.000 123
     1.649    32.000 124
    17.962    40.000 125
   -10.482    21.000 126
    34.180    35.000 127
   -12.470    60.000 128
    31.603    59.000 129
   -29.490    19.000 130
    29.160    62.000 131
    27.851    60.000 132
   -28.924    32.000 133
    -3.873    54.000 134
    74.486    57.000 135
    62.169    59.000 136
    29.186    61.000 137
    23.115    33.000 138
    22.474    63.000 139
    47.738    65.000 140
   -32.348    39.000 141
    37.684    60.000 142
   -23.104    27.000 143
    32.557    60.000 144
    11.600    48.000 145
   -49.037    52.000 146
    19.107    59.000 147
     7.744    46.000 148
    52.981    61.000 149
     7.338    46.000 150
    -8.404    36.000 151
    42.867    61.000 152
    25.693    59.000 153
    27.222    60.000 154
    14.273    37.000 155
    23.729    54.000 156
    27.522    58.000 157
    25.884    61.000 158
    24.309    59.000 159
    79.630    55.000 160
    44.154    61.000 161
    -2.592    29.000 162
    18.300    61.000 163
    42.861    60.000 164
    28.080    60.000 165
   -19.452    31.000 166
   -12.285    67.000 167
    25.933    61.000 168
    18.560    62.000 169
    33.168    56.000 170
    51.897    58.000 171
    23.005    62.000 172
    26.628    60.000 173
    45.871    76.000 174
    24.930    61.000 175
    71.471    51.000 176
    72.626    52.000 177
    37.126    54.000 178
    18.020    61.000 179
    24.203    60.000 180
    12.672    68.000 181
    21.845    59.000 182
    52.693    51.000 183
    26.025    59.000 184
    28.855    57.000 185
    11.248    28.000 186
    19.679    60.000 187
    17.087    59.000 188
    26.539    61.000 189
    28.547    60.000 190
    24.217    60.000 191
    26.783    60.000 192
    15.692    62.000 193
    25.190    59.000 194
    13.809    67.000 195
    20.983    60.000 196
    28.388    62.000 197
    19.724    64.000 198
    22.746    60.000 199
    24.592    59.000 200
    26.032    62.000 201
    26.744    58.000 202
   -21.028    60.000 203
    21.066    60.000 204
    36.672    55.000 205
    64.258    55.000 206
    17.255    60.000 207
    24.506    61.000 208
    24.361    60.000 209
    32.422    60.000 210
    20.869    61.000 211
    32.255    62.000 212
    22.299    57.000 213
    49.114    53.000 214
    25.982    60.000 215
    66.021    53.000 216
    26.705    60.000 217
    17.424    61.000 218
    25.832    60.000 219
    25.450    58.000 220
    29.365    48.000 221
   -43.070    53.000 222
   -84.265    16.000 223
    56.101    55.000 224
    24.265    60.000 225
    -5.831    40.000 226
    24.839    60.000 227
    26.034    62.000 228
    22.252    60.000 229
    22.122    57.000 230
   -27.826    52.000 231
  -122.899    16.000 232
    28.510    56.000 233
    16.917    60.000 234
    -9.305    28.000 235
    27.192    60.000 236
    20.459    21.000 237
   -12.598    10.000 238
    -5.566    11.000 239
    -3.797    16.000 240
   -17.846    53.000 241
    17.503    60.000 242
    27.255    60.000 243
    10.743    68.000 244
    17.727    60.000 245
    25.990    58.000 246
    25.878    57.000 247
    18.399    63.000 248
   -30.418    33.000 249
    27.593    57.000 250
    65.744    74.000 251
    27.091    61.000 252
    18.320    63.000 253
    36.780    55.000 254
    16.711    61.000 255
    23.076    57.000 256
    22.933    60.000 257
    26.628    59.000 258
   -21.697    42.000 259
    17.462    59.000 260
    24.506    58.000 261
   -18.937    34.000 262
    28.282    60.000 263
   -14.560    54.000 264
   -30.882    36.000 265
   -29.647    34.000 266
    53.484    80.000 267
  -110.394    10.000 268
    25.174    59.000 269
    81.470    54.000 270
   -29.815    34.000 271
   -18.066    50.000 272
   -80.455    29.000 273
   -79.773    30.000 274
    17.052    63.000 275
    21.886    59.000 276
   -13.001    61.000 277
    25.120    60.000 278
    51.997    64.000 279
    78.442    58.000 280
    28.507    59.000 281
    26.728    60.000 282
    17.746    60.000 283
    17.811    61.000 284
    28.516    61.000 285
    17.379    64.000 286
    23.299    60.000 287
    26.086    59.000 288
    23.386    59.000 289
    27.902    60.000 290
    20.929    62.000 291
    22.111    62.000 292
    13.875    63.000 293
    26.031    60.000 294
   -88.047    31.000 295
   -90.577    26.000 296
    20.499    63.000 297
    59.223    64.000 298
    27.967    57.000 299
   -20.732    46.000 300
    54.191    61.000 301
    23.090    62.000 302
   -76.341    33.000 303
   -74.696    28.000 304
   -73.981    28.000 305
   -84.085    33.000 306
   -76.897    34.000 307
   -76.574    33.000 308
   -79.509    32.000 309
   -76.069    30.000 310
   -74.378    34.000 311
   -73.261    34.000 312
   -76.043    31.000 313
   -74.617    31.000 314
   -74.011    36.000 315
   -73.861    33.000 316
   -82.634    33.000 317
   -73.671    33.000 318
   -74.416    34.000 319
   -76.981    34.000 320
   -83.268    32.000 321
   -74.028    34.000 322
   -77.932    33.000 323
   -80.008    33.000 324
   -74.044    30.000 325
   -73.668    30.000 326
   -82.821    33.000 327
   -77.914    32.000 328
   -68.526    34.000 329
   -74.540    30.000 330
   -79.934    32.000 331
   -73.593    33.000 332
   -73.436    35.000 333
   -78.888    32.000 334
   -78.150    33.000 335
   -76.601    32.000 336
   -79.154    31.000 337
   -80.150    32.000 338
   -77.016    31.000 339
   -75.994    32.000 340
   -68.708    31.000 341
   -76.817    32.000 342
   -73.443    30.000 343
   -76.920    31.000 344
   -83.402    17.000 345
   -82.808    31.000 346
   -76.200    30.000 347
   -74.191    30.000 348
   -76.620    31.000 349
   -77.961    32.000 350
   -76.918    27.000 351
   -83.233    32.000 352
   -72.964    34.000 353
   -81.158    28.000 354
   -74.289    33.000 355
    21.844    62.000 356
   -73.011    36.000 357
   -80.859    32.000 358
   -64.681    31.000 359
   -76.601    33.000 360
   -68.816    26.000 361
   -76.733    33.000 362
   -71.140    33.000 363
   -74.215    30.000 364
   -74.535    31.000 365
   -72.073    23.000 366
   -84.517    30.000 367
    10.971    36.000 368
    22.915    60.000 369
   -76.679    28.000 370
   -77.466    30.000 371
    26.893    59.000 372
   -79.666    32.000 373
   -81.860    28.000 374
   -82.280    33.000 375
   -79.954    28.000 376
    26.236    59.000 377
    28.251    58.000 378
   -24.881    21.000 379
   -84.084    32.000 380
    26.158    60.000 381
    25.564    59.000 382
    25.644    59.000 383
   -70.960    29.000 384
    20.174    24.000 385
    26.244    60.000 386
    66.876    52.000 387
    19.372    59.000 388
    18.344    62.000 389
    25.254    61.000 390
   -86.196    29.000 391
   -77.535    37.000 392
    29.945    61.000 393
    43.886    60.000 394
    69.986    52.000 395
    18.519    61.000 396
    17.621    61.000 397
    84.549    61.000 398
    -0.934    48.000 399
    30.817    63.000 400
   -18.867    25.000 401
   -44.892    59.000 402
    24.569    59.000 403
    27.260    60.000 404
    -9.127    43.000 405
    16.419    63.000 406
    22.421    59.000 407
   -28.778    27.000 408
    22.140    60.000 409
    18.087    61.000 410
    26.782    60.000 411
    20.520    64.000 412
    24.737    59.000 413
    17.666    63.000 414
    19.676    61.000 415
    17.482    61.000 416
     9.754    68.000 417
   -16.329    27.000 418
    24.756    60.000 419
   -45.709    39.000 420
   -45.141    24.000 421
    26.109    60.000 422
    86.931    69.000 423
    -8.821    60.000 424
    24.998    60.000 425
    25.609    60.000 426
    20.790    58.000 427
    12.139     8.000 428
    25.725    57.000 429
    24.353    12.000 430
EOF

# Azimuth of the projection plane
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
   100.278     0.100 Azimuth =  120
EOF
gmt end
