#!/bin/bash
gmt begin sapporo1.54_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases sapporo1.54'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     0.500     3.507
     1.000    -0.814
     1.500    -4.651
     2.000    -8.411
     2.500   -12.148
     3.000   -15.876
     3.500   -19.600
     4.000   -23.322
     4.500   -27.043
     5.000   -30.765
     5.500   -34.488
     6.000   -38.213
     6.500   -41.939
     7.000   -45.668
     7.500   -49.400
     8.000   -53.134
     8.500   -56.873
     9.000   -60.615
     9.500   -64.360
    10.000   -68.110
    10.500   -71.864
    11.000   -75.623
    11.500   -79.386
    12.000   -83.154
    12.500   -86.928
    13.000   -90.708
    13.500   -94.493
    14.000   -98.284
    14.500  -102.082
    15.000  -105.886
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -87.708 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000    -4.000 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     8.665    -6.995     0.200
     4.656     1.984     0.200
     3.241     0.546     0.200
     3.350    -1.927     0.200
     3.486     1.942     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     0.147    11.061     0.200
     0.147    11.163     0.200
     0.147    10.960     0.200
     0.287     8.920     0.200
     0.287     8.521     0.200
     0.719     1.335     0.200
     1.247    -2.914     0.200
     1.192    -1.054     0.200
     1.192    -1.155     0.200
     1.623    -7.336     0.200
     1.623    -7.836     0.200
     1.671    -5.653     0.200
     1.671    -5.356     0.200
     1.834    -7.404     0.200
     1.834    -7.505     0.200
     1.930    -8.253     0.200
     1.930    -8.550     0.200
     1.989    -6.537     0.200
     1.989    -6.436     0.200
     2.079    -6.799     0.200
     2.079    -7.299     0.200
     2.112    -9.036     0.200
     2.112    -9.333     0.200
     2.261   -11.245     0.200
     2.261   -11.042     0.200
     2.710   -15.499     0.200
     2.710   -15.194     0.200
     2.710   -15.296     0.200
     2.924   -12.576     0.200
     2.924   -13.076     0.200
     3.384    -8.665     0.200
     3.396   -14.122     0.200
     3.430   -15.124     0.200
     4.032   -21.586     0.200
     4.032   -21.187     0.200
     4.149   -21.304     0.200
     4.149   -20.905     0.200
     4.301   -22.535     0.200
     4.301   -22.738     0.200
     4.494   -26.940     0.200
     4.494   -26.838     0.200
     4.760   -28.284     0.200
     5.532   -30.837     0.200
     5.552   -33.877     0.200
     6.178   -38.240     0.200
     6.196   -39.794     0.200
     6.392   -39.106     0.200
     6.392   -39.004     0.200
     6.606   -36.684     0.200
     6.606   -36.785     0.200
     6.721   -40.842     0.200
     6.721   -40.443     0.200
     7.025   -44.381     0.200
     7.025   -45.185     0.200
     7.025   -45.084     0.200
     7.288   -44.908     0.200
     7.288   -45.408     0.200
     7.521   -44.813     0.200
     7.823   -52.168     0.200
     7.823   -52.371     0.200
     7.998   -55.933     0.200
     9.767   -59.390     0.200
     9.767   -61.788     0.200
     9.767   -58.991     0.200
     0.469     6.004     0.200
     0.764     3.264     0.200
     0.878     2.632     0.200
     1.788    -8.196     0.200
     1.884    -7.244     0.200
     1.884    -6.744     0.200
     2.204   -12.389     0.200
     2.424   -11.373     0.200
     2.518   -11.557     0.200
     2.532   -10.805     0.200
     2.532   -11.205     0.200
     2.790   -11.961     0.200
     3.034   -15.695     0.200
     3.034   -15.894     0.200
     3.533   -24.528     0.200
     3.335   -16.240     0.200
     3.880   -16.519     0.200
     3.880   -16.218     0.200
     4.353   -26.509     0.200
     4.748   -30.024     0.200
     4.598   -23.271     0.200
     4.647   -26.842     0.200
     4.878   -26.165     0.200
     5.250   -26.941     0.200
     5.826   -32.217     0.200
     6.484   -41.064     0.200
     6.541   -40.880     0.200
     6.709   -43.212     0.200
     6.756   -42.704     0.200
     6.981   -41.830     0.200
     7.302   -40.995     0.200
     7.351   -45.555     0.200
     7.612   -45.833     0.200
     7.829   -46.722     0.200
     7.829   -46.422     0.200
     7.889   -45.618     0.200
     7.889   -45.817     0.200
     8.046   -47.585     0.200
     8.028   -49.022     0.200
     8.028   -49.221     0.200
     8.164   -52.332     0.200
     8.164   -51.932     0.200
     8.320   -55.260     0.200
     8.489   -57.619     0.200
     8.489   -57.819     0.200
     8.651   -51.778     0.200
     8.651   -52.179     0.200
     8.868   -52.640     0.200
     8.868   -52.339     0.200
     8.958   -51.482     0.200
     9.029   -53.761     0.200
     9.029   -53.261     0.200
     9.226   -54.979     0.200
     9.527   -57.545     0.200
     9.581   -58.754     0.200
     9.739   -69.269     0.200
    10.163   -64.395     0.200
    10.226   -62.696     0.200
    10.226   -62.395     0.200
    10.231   -63.835     0.200
    12.003   -76.034     0.200
    12.003   -76.334     0.200
    12.137   -85.261     0.200
    12.137   -85.062     0.200
    13.729   -97.751     0.200
    13.857   -90.805     0.200
    13.857   -91.106     0.200
    16.004  -111.842     0.200
    16.004  -111.441     0.200
    17.807  -129.008     0.200
    20.849  -140.443     0.200
    20.862  -140.665     0.200
     0.123    10.765     0.200
     0.339     6.903     0.200
     0.734     1.388     0.200
     1.162    -2.178     0.200
     1.706    -6.412     0.200
     1.679    -7.560     0.200
     1.884    -7.063     0.200
     1.983    -5.192     0.200
     2.112   -10.295     0.200
     2.076    -9.142     0.200
     2.100    -9.905     0.200
     2.295    -9.087     0.200
     2.939   -14.525     0.200
     3.328   -17.832     0.200
     3.441   -16.435     0.200
     4.037   -23.307     0.200
     4.310   -21.957     0.200
     4.507   -25.214     0.200
     4.906   -24.852     0.200
     5.561   -33.613     0.200
     6.183   -37.335     0.200
     6.205   -39.037     0.200
     6.732   -40.740     0.200
     6.850   -36.482     0.200
     6.977   -41.517     0.200
     7.032   -45.261     0.200
     7.884   -45.252     0.200
    18.013  -126.349     0.200
     0.178    10.352     0.200
     0.764     0.755     0.200
     1.221    -2.719     0.200
     1.629    -7.650     0.200
     1.715    -5.369     0.200
     1.826    -6.915     0.200
     2.030    -7.379     0.200
     2.044    -6.807     0.200
     2.136   -10.730     0.200
     2.235    -9.851     0.200
     2.886   -13.505     0.200
     3.282   -17.043     0.200
     3.990   -23.488     0.200
     4.260   -22.073     0.200
     4.591   -23.556     0.200
     4.806   -26.367     0.200
     4.856   -25.943     0.200
     5.511   -33.719     0.200
     6.136   -37.534     0.200
     6.155   -38.139     0.200
     6.350   -39.313     0.200
     6.795   -41.409     0.200
     0.122    14.264     0.200
     0.739     0.707     0.200
     1.157    -1.566     0.200
     1.713    -8.197     0.200
     1.690    -7.444     0.200
     1.893    -7.907     0.200
     1.982    -7.727     0.200
     2.121   -10.128     0.200
     2.069    -9.479     0.200
     2.103    -7.548     0.200
     2.301    -8.821     0.200
     2.942   -14.135     0.200
     3.430   -21.609     0.200
     3.328   -18.367     0.200
     3.443   -15.017     0.200
     6.183   -37.872     0.200
     6.853   -36.112     0.200
     8.425   -49.953     0.200
     0.129    11.118     0.200
     0.309     8.389     0.200
     0.716     1.500     0.200
     1.173    -2.003     0.200
     1.645    -6.961     0.200
     1.677    -5.969     0.200
     1.856    -7.635     0.200
     1.978    -7.518     0.200
     2.079   -10.720     0.200
     2.092   -10.128     0.200
     2.094    -7.197     0.200
     2.261    -9.488     0.200
     2.280    -9.068     0.200
     2.720   -13.018     0.200
     2.938   -13.924     0.200
     3.143   -17.446     0.200
     3.334   -17.477     0.200
     3.442   -14.927     0.200
     4.312   -24.510     0.200
     4.543   -23.823     0.200
     4.646   -23.080     0.200
     4.760   -28.689     0.200
     5.563   -34.155     0.200
     6.188   -38.969     0.200
     6.402   -39.750     0.200
     6.920   -42.173     0.200
     7.693   -52.685     0.200
     9.205   -56.597     0.200
     0.233     9.717     0.200
     0.197     9.856     0.200
     0.733     1.859     0.200
     1.239    -1.171     0.200
     1.571    -6.696     0.200
     1.662    -4.606     0.200
     1.779    -6.309     0.200
     2.049    -9.859     0.200
     2.020    -5.939     0.200
     2.040    -6.583     0.200
     2.192   -10.384     0.200
     2.162    -9.448     0.200
     2.212   -10.040     0.200
     2.739   -12.747     0.200
     2.888   -14.466     0.200
     3.213   -16.766     0.200
     3.398   -15.617     0.200
     4.767   -27.016     0.200
     6.924   -41.386     0.200
     8.306   -50.219     0.200
     0.110    12.571     0.200
     0.970     0.297     0.200
     1.687    -7.447     0.200
     1.829    -6.947     0.200
     2.072   -10.622     0.200
     2.285   -10.392     0.200
     2.475    -9.419     0.200
     2.929   -14.800     0.200
     3.612   -17.442     0.200
     4.340   -18.540     0.200
     4.696   -29.820     0.200
     7.101   -45.057     0.200
     7.486   -49.251     0.200
     0.178    12.018     0.200
     0.599     2.677     0.200
     0.964     0.091     0.200
     1.197    -5.289     0.200
     1.374    -4.885     0.200
     1.690    -6.921     0.200
     1.618    -4.621     0.200
     1.859    -8.274     0.200
     1.743    -6.602     0.200
     1.843    -6.766     0.200
     1.978   -11.051     0.200
     2.304    -8.388     0.200
     2.479   -11.923     0.200
     2.553   -13.279     0.200
     2.610   -10.087     0.200
     3.088   -14.226     0.200
     3.790   -14.500     0.200
     3.781   -20.191     0.200
     4.027   -22.007     0.200
     4.186   -20.048     0.200
     4.870   -27.733     0.200
     5.925   -35.171     0.200
     6.128   -36.601     0.200
     6.291   -31.757     0.200
     6.483   -38.849     0.200
     6.529   -34.316     0.200
     7.941   -46.061     0.200
    18.224  -128.034     0.200
     1.498    -6.705     0.200
     1.460    -3.486     0.200
     1.916    -6.946     0.200
     2.782   -10.402     0.200
     2.939   -14.378     0.200
     3.311   -11.177     0.200
     3.448   -19.513     0.200
     4.908   -24.808     0.200
     0.511     3.518     0.200
     1.225    -5.119     0.200
     1.472    -4.958     0.200
     1.812    -4.735     0.200
     1.944    -7.914     0.200
     2.111    -6.202     0.200
     2.684   -12.367     0.200
     2.812   -11.448     0.200
     3.293   -13.677     0.200
     3.460   -17.980     0.200
     4.232   -21.441     0.200
     4.908   -23.884     0.200
    10.988   -68.603     0.200
     0.146    10.506     0.200
     0.287     8.044     0.200
     0.718     2.389     0.200
     1.191    -1.608     0.200
     1.670    -5.803     0.200
     1.834    -6.983     0.200
     1.988    -6.882     0.200
     2.068    -8.418     0.200
     2.111    -8.788     0.200
     2.080    -8.793     0.200
     2.240   -10.866     0.200
     2.261    -8.531     0.200
     2.693   -12.235     0.200
     2.711   -13.792     0.200
     2.925   -14.570     0.200
     3.163   -18.107     0.200
     3.325   -17.253     0.200
     4.302   -26.233     0.200
     4.495   -27.333     0.200
     4.560   -21.411     0.200
     4.759   -27.729     0.200
     4.897   -26.089     0.200
     5.553   -32.873     0.200
     6.179   -37.737     0.200
     6.197   -39.290     0.200
     6.393   -40.500     0.200
     6.716   -42.747     0.200
     6.722   -39.938     0.200
     6.919   -40.182     0.200
     7.166   -40.015     0.200
     7.522   -45.308     0.200
     8.357   -49.779     0.200
    18.008  -128.707     0.200
     0.356     5.786     0.200
     0.562     2.778     0.200
     1.086    -1.841     0.200
     1.630    -7.084     0.200
     1.630    -7.584     0.200
     1.945    -9.069     0.200
     1.945    -8.671     0.200
     1.842    -7.806     0.200
     1.882    -8.071     0.200
     1.882    -8.270     0.200
     2.213   -10.574     0.200
     2.213   -11.074     0.200
     2.021    -8.471     0.200
     2.213    -7.575     0.200
     2.213    -7.875     0.200
     2.367    -8.447     0.200
     2.367    -8.947     0.200
     2.862   -14.129     0.200
     2.862   -14.328     0.200
     3.240   -13.005     0.200
     3.245   -13.286     0.200
     3.064   -13.547     0.200
     3.064   -13.746     0.200
     3.518   -12.920     0.200
     3.476   -15.590     0.200
     3.476   -15.789     0.200
     3.575   -15.749     0.200
     4.182   -21.986     0.200
     4.182   -22.384     0.200
     4.280   -18.075     0.200
     4.280   -17.677     0.200
     4.449   -21.449     0.200
     4.449   -21.648     0.200
     4.636   -24.384     0.200
     4.636   -24.083     0.200
     5.453   -25.282     0.200
     5.453   -25.083     0.200
     5.684   -32.582     0.200
     6.541   -38.778     0.200
     6.869   -42.150     0.200
     6.999   -37.294     0.200
     6.999   -37.095     0.200
     7.109   -40.762     0.200
     7.109   -40.363     0.200
     7.437   -42.152     0.200
     8.343   -50.884     0.200
     9.253   -66.328     0.200
     9.419   -55.988     0.200
     9.419   -56.488     0.200
     9.622   -67.431     0.200
     9.795   -58.908     0.200
     9.795   -59.209     0.200
    10.269   -64.937     0.200
    10.269   -64.738     0.200
    20.518  -139.819     0.200
     0.052    10.419     0.200
     0.416     3.872     0.200
     0.585     1.518     0.200
     1.954    -8.879     0.200
     1.962    -6.145     0.200
     2.243    -7.043     0.200
     2.416    -8.532     0.200
     3.088   -13.820     0.200
     0.082    10.557     0.200
     0.570     1.081     0.200
     1.678    -9.043     0.200
     1.829    -4.850     0.200
     1.926    -7.907     0.200
     1.983    -6.732     0.200
     2.234    -8.682     0.200
     2.399   -10.899     0.200
     2.870   -14.835     0.200
     3.082   -15.546     0.200
     3.484   -18.295     0.200
     3.589   -13.644     0.200
     4.191   -23.729     0.200
     6.338   -37.781     0.200
     0.107     8.424     0.200
     0.415     4.664     0.200
     0.535     2.847     0.200
     1.028     0.226     0.200
     1.683    -9.539     0.200
     1.796    -6.116     0.200
     1.940    -8.673     0.200
     1.962    -7.386     0.200
     2.265    -8.988     0.200
     2.424    -9.034     0.200
     3.114   -12.891     0.200
     0.124     9.388     0.200
     0.385     5.100     0.200
     0.539     1.229     0.200
     1.057    -0.217     0.200
     1.813    -6.183     0.200
     1.907    -8.134     0.200
     1.993    -8.874     0.200
     2.243    -7.787     0.200
     2.396    -8.651     0.200
     3.093   -13.750     0.200
     0.124    10.513     0.200
     0.361     7.005     0.200
     1.154    -0.139     0.200
     1.702    -8.510     0.200
     1.904    -7.910     0.200
     1.985    -7.478     0.200
     2.064    -8.988     0.200
     2.105    -8.290     0.200
     2.306    -8.674     0.200
     2.942   -14.835     0.200
     6.440   -43.699     0.200
     6.854   -36.836     0.200
     6.932   -44.323     0.200
     0.155    10.926     0.200
     0.278    10.030     0.200
     1.615    -7.340     0.200
     1.825    -6.995     0.200
     1.995    -7.383     0.200
     2.066    -8.651     0.200
     2.072    -7.854     0.200
     2.120    -8.374     0.200
     2.252    -7.555     0.200
     2.918   -13.648     0.200
     3.171   -17.591     0.200
     3.319   -17.374     0.200
     3.424   -14.711     0.200
     4.296   -25.336     0.200
     4.569   -21.979     0.200
     4.671   -23.843     0.200
     6.824   -40.480     0.200
     6.921   -40.348     0.200
     6.915   -44.347     0.200
     0.201    10.433     0.200
     0.234    10.390     0.200
     1.245    -1.650     0.200
     1.575    -7.116     0.200
     1.677    -6.337     0.200
     1.780    -6.599     0.200
     2.031    -5.572     0.200
     2.063   -10.571     0.200
     2.031    -7.556     0.200
     2.199   -10.888     0.200
     2.206    -8.125     0.200
     2.671   -12.865     0.200
     2.878   -14.411     0.200
     3.397   -15.868     0.200
     3.285   -16.327     0.200
     3.344   -14.182     0.200
     3.387   -14.538     0.200
     4.259   -24.207     0.200
     5.493   -29.318     0.200
     5.509   -33.833     0.200
     6.351   -37.521     0.200
     6.394   -43.874     0.200
     6.783   -36.191     0.200
     6.876   -45.165     0.200
     0.122    12.656     0.200
     0.324     8.238     0.200
     1.165    -1.426     0.200
     1.688    -7.996     0.200
     1.662    -8.153     0.200
     1.870    -6.769     0.200
     1.977    -6.163     0.200
     2.093    -7.823     0.200
     2.082    -9.484     0.200
     2.100    -8.035     0.200
     2.278    -9.698     0.200
     2.289    -8.040     0.200
     2.720   -14.700     0.200
     2.941   -15.715     0.200
     3.334   -17.156     0.200
     3.419   -14.878     0.200
     4.042   -24.616     0.200
     4.314   -25.231     0.200
     4.510   -26.432     0.200
     4.910   -26.113     0.200
     5.342   -28.822     0.200
     5.565   -32.882     0.200
     6.188   -38.654     0.200
     6.209   -38.304     0.200
     6.403   -42.448     0.200
     6.446   -43.020     0.200
     6.735   -39.988     0.200
     6.935   -45.318     0.200
     7.037   -45.551     0.200
     7.261   -44.155     0.200
     7.464   -45.093     0.200
     0.113    11.633     0.200
     0.334     8.624     0.200
     1.156    -1.423     0.200
     1.689    -7.307     0.200
     1.671    -7.748     0.200
     1.880    -6.387     0.200
     1.971    -7.244     0.200
     2.095    -9.200     0.200
     2.072    -7.466     0.200
     2.108    -7.600     0.200
     2.287   -12.261     0.200
     2.299    -7.645     0.200
     2.726   -13.200     0.200
     2.949   -14.263     0.200
     3.123   -15.683     0.200
     3.340   -17.656     0.200
     3.452   -14.207     0.200
     4.049   -23.122     0.200
     4.321   -24.750     0.200
     4.517   -24.971     0.200
     4.629   -27.412     0.200
     4.917   -25.637     0.200
     5.572   -33.403     0.200
     6.195   -39.156     0.200
     6.216   -39.826     0.200
     6.409   -41.956     0.200
     6.859   -38.193     0.200
     7.675   -52.786     0.200
     8.405   -49.205     0.200
     0.119    11.669     0.200
     0.354     7.211     0.200
     1.153    -1.114     0.200
     1.715    -8.915     0.200
     1.695    -7.271     0.200
     1.898    -7.736     0.200
     1.980    -6.327     0.200
     2.124    -9.875     0.200
     2.106    -7.329     0.200
     2.658   -12.416     0.200
     2.945   -14.904     0.200
     3.116   -17.325     0.200
     3.445   -14.776     0.200
     4.626   -23.705     0.200
     4.785   -27.234     0.200
     6.856   -37.888     0.200
     0.085     8.543     0.200
     1.028    -0.353     0.200
     1.548    -6.823     0.200
     1.615    -7.771     0.200
     1.807    -4.042     0.200
     1.947    -8.482     0.200
     2.258    -8.338     0.200
     2.525   -10.008     0.200
     3.010   -15.783     0.200
     3.612   -15.272     0.200
     4.601   -26.607     0.200
     4.496   -23.075     0.200
     0.156    11.549     0.200
     0.284     8.496     0.200
     1.201    -1.574     0.200
     1.621    -4.605     0.200
     1.622    -7.940     0.200
     1.829    -7.508     0.200
     2.000    -4.928     0.200
     2.078    -9.379     0.200
     2.120    -6.716     0.200
     2.242   -10.579     0.200
     2.252    -7.907     0.200
     2.703   -11.611     0.200
     2.699   -15.064     0.200
     2.913   -12.866     0.200
     3.171   -17.734     0.200
     3.313   -18.524     0.200
     3.419   -14.904     0.200
     4.290   -25.512     0.200
     4.570   -25.785     0.200
     4.772   -27.778     0.200
     6.167   -38.009     0.200
     6.380   -39.775     0.200
     6.820   -37.723     0.200
     6.931   -46.227     0.200
     6.909   -45.241     0.200
     7.014   -44.857     0.200
    18.477  -134.344     0.200
     0.141    12.583     0.200
     0.172    10.004     0.200
     0.424     5.636     0.200
     0.711     2.519     0.200
     1.303    -4.635     0.200
     1.311    -5.496     0.200
     1.388    -2.943     0.200
     1.497    -5.392     0.200
     1.559    -6.354     0.200
     1.995    -7.190     0.200
     2.715   -14.010     0.200
     2.863   -12.499     0.200
     3.390   -12.382     0.200
     3.377   -18.991     0.200
     7.890   -52.243     0.200
     0.478     7.550     0.200
     0.707     4.289     0.200
     1.129     0.928     0.200
     1.291    -0.222     0.200
     1.850    -8.942     0.200
     1.934    -6.496     0.200
     2.253   -12.898     0.200
     2.338   -10.892     0.200
     3.784   -19.057     0.200
     3.884   -20.100     0.200
     4.109   -21.548     0.200
     6.912   -48.486     0.200
     7.560   -47.943     0.200
     7.585   -51.146     0.200
     1.302    -4.793     0.200
     1.515    -4.526     0.200
     1.459    -2.751     0.200
     1.892    -6.474     0.200
     1.936    -5.882     0.200
     1.928    -5.628     0.200
     2.003    -7.996     0.200
     2.605   -10.088     0.200
     3.445   -18.424     0.200
     4.166   -20.555     0.200
     4.810   -24.485     0.200
     1.230    -5.147     0.200
     1.303    -7.135     0.200
     1.437    -5.708     0.200
     1.872    -5.498     0.200
     1.839    -6.430     0.200
     1.917    -6.921     0.200
     2.570   -10.596     0.200
     2.706   -12.907     0.200
     3.179   -15.924     0.200
     3.236   -12.718     0.200
     3.520   -19.519     0.200
     3.873   -20.929     0.200
     4.121   -22.787     0.200
     4.282   -19.868     0.200
     4.880   -24.826     0.200
     6.482   -32.626     0.200
     6.578   -38.676     0.200
    18.584  -132.266     0.200
     0.268     9.535     0.200
     0.166    11.350     0.200
     1.210    -1.853     0.200
     1.605    -8.171     0.200
     1.672    -6.175     0.200
     1.814    -7.984     0.200
     2.065   -10.555     0.200
     2.003    -7.488     0.200
     2.062    -7.365     0.200
     2.132    -7.354     0.200
     2.241    -7.235     0.200
     2.697   -12.681     0.200
     2.908   -14.172     0.200
     3.311   -17.744     0.200
     3.415   -15.251     0.200
     4.018   -22.760     0.200
     4.478   -23.450     0.200
     4.579   -23.147     0.200
     5.537   -32.822     0.200
     6.165   -39.920     0.200
     6.378   -40.171     0.200
     6.421   -42.530     0.200
     6.703   -43.364     0.200
     6.814   -41.993     0.200
     6.905   -44.885     0.200
     7.011   -44.242     0.200
     0.169    11.913     0.200
     0.469     6.106     0.200
     0.721     2.695     0.200
     1.266    -5.781     0.200
     1.475    -5.500     0.200
     1.420    -4.556     0.200
     1.521    -5.657     0.200
     1.803    -9.892     0.200
     1.871    -9.364     0.200
     2.063    -8.334     0.200
     1.988    -5.664     0.200
     2.068    -6.404     0.200
     2.889   -14.027     0.200
     2.720   -13.168     0.200
     2.856   -11.167     0.200
     3.189   -17.031     0.200
     3.248   -12.889     0.200
     3.409   -20.706     0.200
     3.330   -15.506     0.200
     4.025   -22.723     0.200
     4.273   -23.882     0.200
     4.641   -29.062     0.200
     4.432   -23.029     0.200
     4.752   -25.066     0.200
     5.534   -33.367     0.200
     6.157   -36.106     0.200
     6.170   -36.522     0.200
     6.780   -44.578     0.200
     6.633   -38.214     0.200
     6.670   -40.370     0.200
     6.725   -40.106     0.200
     6.733   -42.973     0.200
     6.865   -43.247     0.200
     6.905   -41.033     0.200
     7.021   -37.500     0.200
     6.998   -43.579     0.200
     7.261   -43.810     0.200
     7.376   -42.742     0.200
     9.477   -67.052     0.200
    13.324   -92.608     0.200
     0.109    12.327     0.200
     0.376     7.276     0.200
     1.136    -0.314     0.200
     1.720    -7.424     0.200
     1.715    -7.786     0.200
     1.920    -8.173     0.200
     1.969    -7.435     0.200
     2.133    -7.614     0.200
     2.046    -5.856     0.200
     2.122    -7.793     0.200
     2.332   -12.149     0.200
     2.324   -12.696     0.200
     2.641   -13.920     0.200
     2.727   -12.266     0.200
     3.096   -14.966     0.200
     3.341   -15.910     0.200
     3.459   -16.652     0.200
     3.698   -17.140     0.200
     4.050   -22.408     0.200
     4.506   -22.861     0.200
     4.525   -24.464     0.200
     4.783   -28.632     0.200
     5.576   -32.780     0.200
     6.949   -45.591     0.200
     0.139    11.317     0.200
     0.338     7.728     0.200
     0.753     0.476     0.200
     1.175    -0.915     0.200
     1.680    -6.921     0.200
     1.723    -7.277     0.200
     1.880    -7.163     0.200
     2.000    -7.463     0.200
     2.127    -9.205     0.200
     2.087    -7.010     0.200
     2.085    -7.254     0.200
     2.302   -11.637     0.200
     2.284    -8.052     0.200
     2.697   -12.143     0.200
     2.924   -13.139     0.200
     3.310   -17.595     0.200
     4.019   -21.074     0.200
     4.137   -19.715     0.200
     4.293   -21.940     0.200
     4.491   -25.017     0.200
     4.546   -21.763     0.200
     5.544   -33.793     0.200
     6.411   -40.886     0.200
     6.834   -40.318     0.200
    18.488  -135.748     0.200
     0.173    10.892     0.200
     0.278     9.250     0.200
     0.752     1.232     0.200
     1.218    -1.719     0.200
     1.526    -4.903     0.200
     1.621    -6.300     0.200
     1.701    -6.530     0.200
     1.822    -6.279     0.200
     2.022    -6.509     0.200
     2.094    -8.211     0.200
     2.135   -10.396     0.200
     2.050    -7.393     0.200
     2.236    -7.013     0.200
     2.640   -10.613     0.200
     2.677   -12.484     0.200
     2.893   -13.629     0.200
     3.186   -17.912     0.200
     3.286   -17.092     0.200
     3.291   -16.245     0.200
     3.420   -17.332     0.200
     3.368   -14.684     0.200
     3.623   -13.771     0.200
     3.999   -22.783     0.200
     4.102   -20.964     0.200
     4.269   -24.246     0.200
     4.462   -25.375     0.200
     4.588   -25.347     0.200
     4.651   -24.751     0.200
     4.793   -27.866     0.200
     4.864   -25.108     0.200
     5.498   -30.221     0.200
     5.519   -33.888     0.200
     6.145   -36.731     0.200
     6.164   -37.806     0.200
     6.574   -36.826     0.200
     6.689   -40.864     0.200
     6.888   -43.986     0.200
     6.993   -45.285     0.200
     7.255   -44.511     0.200
     7.791   -53.582     0.200
     7.836   -46.325     0.200
     7.886   -55.898     0.200
    12.333   -81.377     0.200
     1.132    -1.750     0.200
     1.269    -2.196     0.200
     1.866    -6.308     0.200
     2.037    -6.728     0.200
     2.182    -9.341     0.200
     2.802   -13.990     0.200
     2.899   -13.071     0.200
     2.894   -13.889     0.200
     3.463   -16.042     0.200
     3.480   -17.465     0.200
     3.822   -21.220     0.200
     4.139   -21.374     0.200
     0.161    11.160     0.200
     0.278     9.151     0.200
     0.731     1.771     0.200
     1.205    -1.164     0.200
     1.515    -4.177     0.200
     1.616    -6.694     0.200
     1.680    -5.002     0.200
     1.824    -7.056     0.200
     2.003    -7.755     0.200
     2.075    -8.633     0.200
     2.065    -8.508     0.200
     2.125    -9.820     0.200
     2.236   -10.539     0.200
     2.247    -7.880     0.200
     2.696   -13.217     0.200
     2.910   -13.986     0.200
     3.176   -17.232     0.200
     3.399   -16.499     0.200
     3.305   -16.818     0.200
     3.310   -18.279     0.200
     3.381   -15.939     0.200
     3.416   -17.035     0.200
     3.638   -14.271     0.200
     4.018   -24.106     0.200
     4.118   -20.281     0.200
     4.287   -21.754     0.200
     4.479   -24.350     0.200
     4.575   -24.769     0.200
     4.668   -25.710     0.200
     5.538   -32.588     0.200
     6.164   -37.262     0.200
     6.182   -39.411     0.200
     6.816   -37.833     0.200
     6.931   -43.860     0.200
     6.906   -44.672     0.200
     7.011   -43.000     0.200
     7.274   -45.323     0.200
     7.904   -55.199     0.200
     0.344     7.813     0.200
     0.729     1.315     0.200
     1.155    -0.901     0.200
     1.462    -4.027     0.200
     1.889    -7.566     0.200
     1.976    -6.923     0.200
     2.110    -8.569     0.200
     2.069    -8.269     0.200
     2.107    -7.856     0.200
     2.300    -9.587     0.200
     2.301    -8.633     0.200
     2.705   -11.430     0.200
     2.721   -12.920     0.200
     2.946   -15.075     0.200
     3.330   -16.241     0.200
     3.334   -18.373     0.200
     4.043   -23.849     0.200
     4.704   -26.793     0.200
     5.567   -33.158     0.200
     5.927   -36.556     0.200
     6.189   -38.876     0.200
     6.857   -42.034     0.200
     6.938   -45.024     0.200
     7.933   -54.665     0.200
    18.464  -132.992     0.200
     0.898     4.243     0.200
     1.435    -0.503     0.200
     1.891    -1.953     0.200
     2.317    -4.444     0.200
     2.535    -8.464     0.200
     2.675    -6.901     0.200
     3.145    -8.702     0.200
     4.899   -18.302     0.200
     0.181     9.500     0.200
     0.328     8.138     0.200
     0.710     1.732     0.200
     1.156    -1.011     0.200
     1.465    -4.195     0.200
     1.678    -5.962     0.200
     1.875    -6.982     0.200
     1.960    -8.875     0.200
     1.966    -6.979     0.200
     2.084   -10.836     0.200
     2.074    -7.504     0.200
     2.110    -7.844     0.200
     2.298    -9.589     0.200
     2.701   -10.389     0.200
     2.731   -13.340     0.200
     2.952   -15.335     0.200
     3.345   -18.796     0.200
     3.429   -16.462     0.200
     4.710   -27.260     0.200
     5.576   -33.516     0.200
     6.861   -37.243     0.200
     6.946   -45.744     0.200
     1.438    -4.508     0.200
     1.773    -5.036     0.200
     1.920    -6.497     0.200
     1.881    -4.658     0.200
     2.002    -7.119     0.200
     1.891    -5.571     0.200
     2.498    -8.816     0.200
     2.491    -8.591     0.200
     2.637   -10.224     0.200
     3.092   -10.655     0.200
     3.164   -10.933     0.200
     3.548   -17.611     0.200
     3.797   -17.009     0.200
     4.922   -22.457     0.200
    12.648   -81.591     0.200
     1.192    -2.951     0.200
     1.386    -4.071     0.200
     1.647    -3.362     0.200
     1.845    -6.650     0.200
     2.651    -9.195     0.200
     3.048   -10.762     0.200
     3.131   -10.703     0.200
     3.828   -15.510     0.200
     3.824   -17.357     0.200
     4.070   -21.952     0.200
     4.227   -19.153     0.200
     4.653   -22.652     0.200
     5.275   -22.257     0.200
     5.953   -30.848     0.200
     5.968   -33.331     0.200
     6.534   -37.869     0.200
     7.171   -37.467     0.200
     7.569   -40.685     0.200
     7.851   -49.036     0.200
     8.439   -47.176     0.200
    11.108   -67.289     0.200
    11.311   -69.216     0.200
    12.264   -76.408     0.200
    13.139   -85.659     0.200
    13.517   -90.653     0.200
    13.762   -91.796     0.200
    15.006   -97.841     0.200
    15.343  -102.508     0.200
    18.633  -132.810     0.200
    19.335  -136.556     0.200
     0.478     4.216     0.200
     0.809     2.123     0.200
     1.490    -5.850     0.200
     1.792    -5.319     0.200
     1.898    -7.780     0.200
     1.996    -7.895     0.200
     2.398    -9.945     0.200
     2.412    -9.095     0.200
     2.621    -8.726     0.200
     2.763   -13.229     0.200
     3.223   -11.784     0.200
     3.232   -15.078     0.200
     3.292   -12.997     0.200
     0.792     1.641     0.200
     1.783    -5.997     0.200
     1.872    -4.802     0.200
     1.915    -8.181     0.200
     2.009    -6.135     0.200
     2.411    -9.876     0.200
     2.405    -8.993     0.200
     2.782   -11.648     0.200
     3.243   -14.265     0.200
     3.252   -14.563     0.200
     3.312   -13.439     0.200
     1.427    -5.001     0.200
     1.866    -8.141     0.200
     1.828    -6.717     0.200
     1.922    -7.919     0.200
     2.483    -9.686     0.200
     2.560    -9.137     0.200
     2.695   -12.400     0.200
     3.027   -15.232     0.200
     3.160   -14.149     0.200
     3.170   -14.459     0.200
     3.225   -11.223     0.200
     3.864   -17.453     0.200
     0.514     3.424     0.200
     1.470    -6.372     0.200
     1.825    -6.619     0.200
     1.925    -7.299     0.200
     1.939    -8.750     0.200
     2.342   -10.527     0.200
     2.453    -9.041     0.200
     2.689   -12.510     0.200
     3.143   -12.899     0.200
     3.152   -13.185     0.200
     3.216   -11.212     0.200
     0.828     2.405     0.200
     1.274    -4.256     0.200
     1.488    -4.716     0.200
     1.909    -6.485     0.200
     1.916    -5.097     0.200
     1.983    -7.208     0.200
     2.166    -5.720     0.200
     2.385    -8.969     0.200
     2.420   -11.070     0.200
     2.600   -10.763     0.200
     2.744    -9.845     0.200
     3.152   -11.268     0.200
     3.210   -14.621     0.200
     3.272   -13.087     0.200
     3.469   -18.822     0.200
     3.906   -18.485     0.200
     4.320   -19.308     0.200
     4.831   -23.488     0.200
     6.042   -32.901     0.200
     6.052   -36.205     0.200
     6.546   -33.861     0.200
     6.621   -36.250     0.200
     6.882   -38.531     0.200
    10.958   -65.017     0.200
    12.551   -81.931     0.200
     0.462     4.299     0.200
     1.517    -5.764     0.200
     1.465    -2.502     0.200
     1.626    -3.298     0.200
     1.782    -4.554     0.200
     1.952    -4.961     0.200
     1.876    -6.541     0.200
     1.994    -6.265     0.200
     2.397   -10.043     0.200
     2.400    -8.160     0.200
     2.585    -9.022     0.200
     2.739    -9.900     0.200
     3.188   -10.133     0.200
     3.264   -11.555     0.200
     1.403    -4.247     0.200
     1.840    -7.296     0.200
     1.926    -6.212     0.200
     1.875    -6.603     0.200
     1.921    -6.749     0.200
     2.322    -9.474     0.200
     2.496   -10.300     0.200
     2.583   -12.056     0.200
     2.709   -14.034     0.200
     3.182   -15.021     0.200
     3.192   -15.346     0.200
     3.242   -12.936     0.200
     3.884   -19.485     0.200
     4.897   -23.588     0.200
     6.260   -38.606     0.200
     0.842     2.893     0.200
     1.477    -5.533     0.200
     1.906    -5.819     0.200
     1.924    -5.998     0.200
     1.865    -5.823     0.200
     1.969    -6.422     0.200
     2.371    -9.184     0.200
     2.433    -9.141     0.200
     2.586   -10.002     0.200
     2.730   -10.556     0.200
     3.188   -11.462     0.200
     3.197   -12.356     0.200
     4.845   -20.591     0.200
     0.610     2.800     0.200
     0.859     2.287     0.200
     1.358    -4.707     0.200
     1.583    -3.843     0.200
     1.870    -7.035     0.200
     1.903    -5.004     0.200
     2.527    -7.763     0.200
     2.633   -12.149     0.200
     2.741   -11.544     0.200
     3.228   -12.008     0.200
     3.240   -13.365     0.200
     3.279   -11.598     0.200
     3.928   -18.775     0.200
     0.470     4.048     0.200
     1.510    -5.517     0.200
     1.865    -7.166     0.200
     1.949    -6.133     0.200
     2.387   -10.893     0.200
     2.409    -9.415     0.200
     2.575    -9.655     0.200
     2.728   -10.524     0.200
     3.177   -12.763     0.200
     3.186   -14.038     0.200
     3.254   -14.180     0.200
     3.884   -19.155     0.200
     4.304   -19.480     0.200
     6.024   -32.999     0.200
     6.030   -34.195     0.200
     6.266   -37.673     0.200
     6.736   -41.682     0.200
     0.664     2.883     0.200
     1.306    -3.290     0.200
     1.763    -5.475     0.200
     1.758    -5.818     0.200
     1.824    -7.691     0.200
     2.225    -7.399     0.200
     2.520   -10.850     0.200
     2.597    -9.204     0.200
     2.629   -11.212     0.200
     3.114   -12.608     0.200
     3.126   -12.964     0.200
     3.166   -13.232     0.200
     3.814   -15.777     0.200
     4.204   -18.238     0.200
     0.585     3.743     0.200
     0.870     2.405     0.200
     1.381    -3.097     0.200
     1.852    -5.031     0.200
     1.847    -5.571     0.200
     1.915    -6.037     0.200
     2.316    -9.237     0.200
     2.599   -10.710     0.200
     2.717    -9.442     0.200
     3.196   -12.631     0.200
     3.207   -11.969     0.200
     3.252   -10.409     0.200
     3.897   -17.853     0.200
    21.552  -149.928     0.200
     0.823     2.438     0.200
     1.460    -3.245     0.200
     1.499    -3.088     0.200
     1.867    -4.870     0.200
     1.878    -4.320     0.200
     1.818    -5.603     0.200
     1.885    -6.738     0.200
     1.975    -7.472     0.200
     2.439   -10.297     0.200
     2.617   -11.744     0.200
     2.752   -11.229     0.200
     2.977   -13.348     0.200
     3.217   -12.969     0.200
     3.227   -13.276     0.200
     3.283   -13.056     0.200
     3.487   -19.618     0.200
     3.921   -19.280     0.200
     4.328   -19.189     0.200
     4.841   -22.441     0.200
     6.623   -36.940     0.200
     0.204     7.707     0.200
     0.607     2.718     0.200
     0.896     1.058     0.200
     1.359    -5.113     0.200
     1.582    -3.173     0.200
     1.595    -3.693     0.200
     1.822    -8.071     0.200
     1.889    -6.911     0.200
     2.238    -7.581     0.200
     2.290    -8.613     0.200
     2.537   -10.942     0.200
     2.576    -9.698     0.200
     2.692   -12.353     0.200
     3.068   -12.799     0.200
     3.173   -14.602     0.200
     3.183   -14.945     0.200
     3.584   -19.435     0.200
     4.931   -23.351     0.200
     0.609     3.376     0.200
     1.365    -3.987     0.200
     1.819    -6.505     0.200
     1.782    -5.837     0.200
     1.865    -6.464     0.200
     2.528   -11.480     0.200
     2.651   -11.376     0.200
     3.126   -13.423     0.200
     3.136   -14.754     0.200
     3.185   -11.290     0.200
     3.828   -18.667     0.200
     0.567     3.797     0.200
     0.863     2.702     0.200
     1.400    -3.110     0.200
     1.555    -2.532     0.200
     1.865    -4.373     0.200
     1.850    -6.599     0.200
     1.926    -5.286     0.200
     2.597   -11.555     0.200
     2.719   -10.448     0.200
     3.194   -12.506     0.200
     3.205   -12.835     0.200
     3.896   -19.054     0.200
    21.554  -148.499     0.200
     0.669     3.580     0.200
     1.297    -2.109     0.200
     1.652    -3.682     0.200
     1.847    -4.063     0.200
     1.793    -5.961     0.200
     1.843    -3.928     0.200
     2.278    -6.510     0.200
     2.595   -10.766     0.200
     2.564    -9.380     0.200
     2.665    -9.483     0.200
     3.157   -11.590     0.200
     3.169   -13.959     0.200
     3.641   -17.934     0.200
     4.093   -18.260     0.200
     4.982   -22.450     0.200
     0.230     9.641     0.200
     0.324     7.665     0.200
     0.761     1.024     0.200
     1.191     0.001     0.200
     1.497    -3.398     0.200
     1.726    -6.864     0.200
     1.865    -6.986     0.200
     2.013   -10.163     0.200
     2.102    -8.600     0.200
     2.070    -7.669     0.200
     2.292   -10.596     0.200
     2.268    -8.838     0.200
     2.671    -9.632     0.200
     2.684   -12.129     0.200
     2.909   -14.173     0.200
     3.293   -16.348     0.200
     3.297   -18.481     0.200
     3.645   -14.995     0.200
     4.477   -24.659     0.200
     6.820   -38.137     0.200
     0.769     3.568     0.200
     1.473    -3.265     0.200
     1.841    -4.717     0.200
     1.943    -4.674     0.200
     2.683    -9.410     0.200
     2.812    -9.505     0.200
     3.282   -11.408     0.200
     3.292   -11.723     0.200
     0.733     3.366     0.200
     1.518    -4.327     0.200
     1.746    -4.932     0.200
     1.878    -6.111     0.200
     1.976    -6.721     0.200
     2.368    -8.070     0.200
     2.460   -10.481     0.200
     2.706    -9.369     0.200
     2.843   -11.614     0.200
     3.307   -11.411     0.200
     3.316   -12.711     0.200
     1.522    -5.219     0.200
     1.859    -7.007     0.200
     1.969    -7.489     0.200
     1.979    -5.600     0.200
     1.985    -8.981     0.200
     2.388    -8.767     0.200
     2.404    -9.273     0.200
     2.563   -10.515     0.200
     2.721   -10.226     0.200
     2.961   -11.843     0.200
     3.166   -11.442     0.200
     3.175   -13.809     0.200
     3.454   -17.064     0.200
     3.873   -18.551     0.200
     4.813   -25.133     0.200
     4.828   -21.106     0.200
     6.020   -34.700     0.200
     6.606   -34.491     0.200
    18.591  -132.393     0.200
     1.557    -7.017     0.200
     1.763    -3.953     0.200
     2.010    -6.992     0.200
     1.866    -7.222     0.200
     2.004    -8.594     0.200
     2.379    -8.471     0.200
     2.558   -11.152     0.200
     2.725   -10.559     0.200
     3.162   -10.717     0.200
     3.170   -12.666     0.200
     3.246   -12.980     0.200
     3.871   -19.762     0.200
     6.255   -36.660     0.200
     0.726     2.765     0.200
     1.530    -5.632     0.200
     1.889    -7.106     0.200
     1.982    -8.450     0.200
     2.068    -7.789     0.200
     2.470    -9.511     0.200
     2.357    -8.742     0.200
     2.709   -12.107     0.200
     2.849   -11.532     0.200
     3.310   -11.763     0.200
     3.320   -15.457     0.200
     3.379   -14.335     0.200
     4.015   -18.499     0.200
     0.368     7.148     0.200
     0.746     0.975     0.200
     1.148    -0.661     0.200
     1.453    -3.015     0.200
     1.911    -9.264     0.200
     1.981    -6.781     0.200
     2.057    -6.882     0.200
     2.110    -8.357     0.200
     2.313   -11.990     0.200
     2.716   -12.484     0.200
     2.715   -13.533     0.200
     2.947   -15.086     0.200
     3.325   -18.062     0.200
     3.328   -18.182     0.200
     3.686   -16.111     0.200
     4.038   -23.678     0.200
     4.513   -24.728     0.200
     6.430   -43.497     0.200
     6.936   -45.055     0.200
     7.930   -55.049     0.200
     0.070    13.718     0.200
     0.367     7.486     0.200
     0.770     1.824     0.200
     1.373    -2.880     0.200
     1.614    -4.022     0.200
     1.613    -6.291     0.200
     1.689    -5.507     0.200
     2.027   -10.138     0.200
     1.948    -6.819     0.200
     2.095    -8.893     0.200
     2.082    -7.058     0.200
     2.306    -9.980     0.200
     2.637    -9.446     0.200
     2.807   -11.852     0.200
     3.249   -16.870     0.200
     3.328   -13.356     0.200
     4.382   -21.784     0.200
     4.731   -24.830     0.200
     6.098   -34.167     0.200
     6.098   -37.158     0.200
     6.697   -39.169     0.200
     0.222     6.505     0.200
     1.343    -4.334     0.200
     1.817    -6.964     0.200
     1.879    -5.724     0.200
     2.279    -9.215     0.200
     2.551   -10.828     0.200
     2.576   -13.633     0.200
     3.172   -13.510     0.200
     3.183   -15.861     0.200
     3.598   -19.513     0.200
     3.872   -17.695     0.200
     0.053    14.305     0.200
     0.796     0.859     0.200
     1.393    -3.583     0.200
     1.636    -6.276     0.200
     1.600    -5.832     0.200
     1.709    -6.390     0.200
     2.028    -9.896     0.200
     1.923    -6.483     0.200
     2.121    -9.441     0.200
     2.060    -6.520     0.200
     2.326   -11.040     0.200
     2.611   -12.687     0.200
     2.782   -10.305     0.200
     3.215   -13.350     0.200
     3.216   -15.371     0.200
     3.224   -17.112     0.200
     3.302   -13.101     0.200
     3.376   -17.935     0.200
     3.925   -20.832     0.200
     4.182   -23.000     0.200
     4.357   -23.535     0.200
     4.753   -25.083     0.200
     6.072   -34.911     0.200
     6.072   -34.899     0.200
     6.310   -41.450     0.200
     6.624   -42.404     0.200
     6.673   -37.942     0.200
     6.788   -42.604     0.200
     6.909   -42.723     0.200
     7.171   -41.853     0.200
     8.134   -48.271     0.200
    12.849   -89.749     0.200
    20.544  -142.671     0.200
     0.753     2.563     0.200
     1.891    -3.792     0.200
     1.913    -5.196     0.200
     1.976    -4.283     0.200
     2.326    -7.701     0.200
     2.660    -9.161     0.200
     2.819    -7.800     0.200
     3.971   -16.418     0.200
     4.573   -20.499     0.200
     0.280    11.774     0.200
     1.162    -0.990     0.200
     1.554    -6.217     0.200
     1.478    -4.410     0.200
     1.812    -6.491     0.200
     1.953   -10.864     0.200
     2.096    -9.190     0.200
     2.167   -10.343     0.200
     2.139    -8.559     0.200
     2.290   -10.543     0.200
     2.656   -12.942     0.200
     2.796   -13.877     0.200
     2.992   -14.484     0.200
     3.146   -17.974     0.200
     3.404   -17.449     0.200
     3.441   -15.138     0.200
     3.410   -18.836     0.200
     3.505   -18.050     0.200
     3.706   -18.437     0.200
     4.115   -24.294     0.200
     4.523   -24.319     0.200
     4.565   -25.544     0.200
     5.630   -34.501     0.200
     6.263   -39.469     0.200
     6.504   -43.132     0.200
     6.796   -41.364     0.200
     6.805   -43.660     0.200
     6.891   -37.387     0.200
     6.994   -45.750     0.200
     7.106   -46.188     0.200
     7.996   -55.404     0.200
    18.371  -134.293     0.200
     0.519     3.535     0.200
     1.448    -5.117     0.200
     1.859    -5.755     0.200
     1.830    -4.821     0.200
     1.875    -6.867     0.200
     2.365    -9.785     0.200
     2.451    -7.514     0.200
     2.610    -9.542     0.200
     2.743   -10.765     0.200
     3.209   -12.552     0.200
     3.219   -14.863     0.200
     3.274   -11.607     0.200
     4.853   -25.151     0.200
     6.291   -38.237     0.200
     0.461     7.226     0.200
     0.693     7.189     0.200
     1.510    -4.926     0.200
     1.568    -5.552     0.200
     1.685    -6.548     0.200
     1.991    -9.054     0.200
     2.207    -8.919     0.200
     2.248   -10.013     0.200
     2.466   -11.504     0.200
     2.526   -11.118     0.200
     2.734   -14.712     0.200
     2.701   -10.664     0.200
     3.187   -16.569     0.200
     3.131   -17.189     0.200
     3.366   -17.755     0.200
     3.741   -20.723     0.200
     3.744   -20.617     0.200
     3.843   -18.367     0.200
     4.115   -20.994     0.200
     4.455   -27.756     0.200
     4.454   -25.749     0.200
     4.579   -24.892     0.200
     4.731   -27.028     0.200
     4.933   -27.313     0.200
     5.329   -27.463     0.200
     5.948   -35.797     0.200
     5.983   -35.797     0.200
     6.626   -40.583     0.200
     6.599   -42.323     0.200
     6.627   -42.126     0.200
     6.846   -45.576     0.200
     7.045   -36.877     0.200
     7.123   -47.337     0.200
     7.277   -44.213     0.200
     7.384   -48.005     0.200
     7.452   -47.564     0.200
     8.353   -52.132     0.200
     8.254   -57.194     0.200
     8.348   -58.395     0.200
     8.600   -53.154     0.200
     8.424   -60.090     0.200
     8.557   -55.810     0.200
     9.880   -68.729     0.200
    10.794   -69.728     0.200
    11.857   -80.206     0.200
     0.600     2.531     0.200
     1.372    -3.337     0.200
     1.886    -6.440     0.200
     1.899    -6.861     0.200
     2.173    -6.447     0.200
     2.344    -7.766     0.200
     2.510   -10.512     0.200
     2.664   -10.909     0.200
     3.259   -13.767     0.200
     3.270   -12.124     0.200
     0.306     8.929     0.200
     0.715     0.947     0.200
     1.176    -1.656     0.200
     1.485    -4.764     0.200
     1.675    -6.477     0.200
     1.852    -6.499     0.200
     1.979    -7.619     0.200
     2.076    -8.707     0.200
     2.095    -8.197     0.200
     2.093    -7.824     0.200
     2.257   -10.740     0.200
     2.277    -7.865     0.200
     2.679   -13.401     0.200
     2.719   -12.279     0.200
     2.936   -14.261     0.200
     3.146   -16.413     0.200
     3.328   -17.090     0.200
     3.333   -16.840     0.200
     3.410   -14.792     0.200
     4.041   -22.983     0.200
     4.545   -23.773     0.200
     4.694   -26.485     0.200
     4.907   -25.530     0.200
     5.562   -32.905     0.200
     6.188   -36.831     0.200
     6.206   -38.426     0.200
     6.432   -41.679     0.200
     6.723   -42.801     0.200
     6.732   -41.090     0.200
     6.844   -38.638     0.200
     7.035   -45.198     0.200
     7.874   -47.000     0.200
     7.928   -55.317     0.200
    18.459  -132.832     0.200
     0.569     1.648     0.200
     1.392    -2.639     0.200
     1.897    -7.862     0.200
     1.961    -6.296     0.200
     2.009    -7.014     0.200
     2.232    -8.586     0.200
     2.217    -7.618     0.200
     2.780   -12.441     0.200
     2.861   -12.007     0.200
     3.067   -14.145     0.200
     3.469   -16.103     0.200
     3.474   -17.369     0.200
     3.577   -12.304     0.200
     6.572   -41.351     0.200
     6.969   -38.856     0.200
     7.066   -44.127     0.200
     7.090   -43.995     0.200
     0.062    10.798     0.200
     0.392     5.029     0.200
     0.525     3.118     0.200
     1.050     0.076     0.200
     1.368    -3.180     0.200
     1.504    -5.599     0.200
     1.778    -8.579     0.200
     1.802    -5.741     0.200
     1.927    -9.105     0.200
     1.910    -7.775     0.200
     1.987    -7.515     0.200
     2.224   -10.739     0.200
     2.253    -8.160     0.200
     2.808   -11.837     0.200
     2.902   -13.911     0.200
     3.104   -14.740     0.200
     3.510   -18.402     0.200
     3.516   -18.171     0.200
     0.279     8.855     0.200
     0.741     1.098     0.200
     1.210    -2.081     0.200
     1.520    -4.382     0.200
     1.690    -6.377     0.200
     1.619    -7.141     0.200
     1.824    -7.119     0.200
     1.978    -7.228     0.200
     2.012    -6.874     0.200
     2.084    -8.788     0.200
     2.129   -10.096     0.200
     2.058    -8.561     0.200
     2.241    -9.748     0.200
     2.243    -7.406     0.200
     2.647   -10.707     0.200
     2.688   -14.109     0.200
     2.902   -12.316     0.200
     3.180   -18.118     0.200
     3.409   -18.376     0.200
     3.297   -15.017     0.200
     3.301   -15.867     0.200
     3.408   -15.350     0.200
     4.009   -23.503     0.200
     4.472   -24.172     0.200
     5.509   -30.845     0.200
     6.156   -39.453     0.200
     6.174   -36.617     0.200
     6.400   -40.892     0.200
     6.699   -40.872     0.200
     6.692   -42.256     0.200
     6.941   -46.339     0.200
     6.810   -37.179     0.200
     6.898   -45.785     0.200
     7.865   -49.747     0.200
     7.896   -54.810     0.200
    13.068   -85.573     0.200
    14.702  -106.372     0.200
     0.598     2.424     0.200
     1.376    -3.718     0.200
     1.829    -5.806     0.200
     1.788    -7.093     0.200
     1.923    -4.789     0.200
     1.914    -6.197     0.200
     2.276    -9.256     0.200
     2.535    -8.559     0.200
     2.531   -11.546     0.200
     2.656   -12.020     0.200
     3.129   -13.603     0.200
     3.139   -14.031     0.200
     3.189   -13.414     0.200
     3.831   -17.561     0.200
     1.311    -3.969     0.200
     1.715    -5.273     0.200
     1.631    -4.324     0.200
     1.829    -5.493     0.200
     1.873    -4.779     0.200
     2.272    -8.723     0.200
     2.575    -9.938     0.200
     2.601   -10.158     0.200
     2.700   -10.519     0.200
     3.194   -13.465     0.200
     3.206   -13.335     0.200
     3.240   -15.122     0.200
     3.892   -16.886     0.200
     0.223     9.808     0.200
     0.294     8.271     0.200
     0.744     1.185     0.200
     1.202    -1.116     0.200
     1.510    -4.093     0.200
     1.699    -5.869     0.200
     1.838    -8.384     0.200
     1.985    -6.160     0.200
     2.009    -8.013     0.200
     2.096   -10.266     0.200
     2.064    -7.669     0.200
     2.118    -8.380     0.200
     2.257    -9.958     0.200
     2.253   -11.534     0.200
     2.656    -9.934     0.200
     2.689   -11.472     0.200
     2.907   -13.483     0.200
     3.298   -16.884     0.200
     3.303   -16.430     0.200
     3.412   -14.276     0.200
     3.638   -14.955     0.200
     4.011   -22.376     0.200
     4.476   -24.414     0.200
     4.572   -22.048     0.200
     4.665   -25.605     0.200
     5.510   -32.097     0.200
     5.532   -32.800     0.200
     6.158   -36.719     0.200
     6.402   -42.171     0.200
     6.693   -43.290     0.200
     6.815   -37.174     0.200
     7.804   -54.203     0.200
     7.845   -48.121     0.200
     7.870   -50.386     0.200
     7.899   -55.216     0.200
     0.306     8.745     0.200
     0.732     1.445     0.200
     1.185    -1.311     0.200
     1.494    -4.888     0.200
     1.692    -5.580     0.200
     1.646    -6.408     0.200
     1.852    -6.639     0.200
     1.994    -7.344     0.200
     2.093    -8.577     0.200
     2.102    -9.880     0.200
     2.081    -8.003     0.200
     2.265    -9.737     0.200
     2.269    -9.268     0.200
     2.704   -13.657     0.200
     2.923   -13.803     0.200
     3.153   -18.896     0.200
     3.313   -16.470     0.200
     3.318   -16.615     0.200
     3.400   -14.722     0.200
     3.427   -14.589     0.200
     4.026   -22.566     0.200
     4.297   -24.860     0.200
     4.555   -25.341     0.200
     4.492   -26.834     0.200
     4.681   -25.827     0.200
     4.893   -25.836     0.200
     5.525   -31.685     0.200
     5.548   -32.910     0.200
     6.172   -38.609     0.200
     6.192   -38.729     0.200
     6.417   -41.665     0.200
     6.707   -44.459     0.200
     6.718   -39.903     0.200
     6.832   -41.506     0.200
     6.918   -45.332     0.200
     7.283   -44.812     0.200
     7.819   -50.606     0.200
     7.861   -47.752     0.200
     7.885   -51.306     0.200
     7.914   -55.017     0.200
     9.462   -65.480     0.200
    13.093   -85.989     0.200
     0.184    10.237     0.200
     0.349     7.401     0.200
     0.718     0.796     0.200
     1.145    -0.630     0.200
     1.452    -3.574     0.200
     1.694    -9.027     0.200
     1.895    -8.106     0.200
     1.965    -7.113     0.200
     2.103    -9.607     0.200
     2.060    -7.231     0.200
     2.117    -7.952     0.200
     2.301   -10.365     0.200
     2.714   -11.585     0.200
     2.732   -13.535     0.200
     2.957   -14.580     0.200
     3.341   -17.958     0.200
     3.346   -17.289     0.200
     3.459   -16.594     0.200
     4.055   -23.362     0.200
     4.525   -24.571     0.200
     4.715   -26.598     0.200
     5.552   -32.336     0.200
     5.578   -32.772     0.200
     6.201   -37.690     0.200
     6.446   -43.875     0.200
     6.976   -45.079     0.200
     7.850   -51.771     0.200
     7.918   -52.544     0.200
     7.945   -55.579     0.200
     0.232    10.468     0.200
     0.263     9.684     0.200
     0.742     1.017     0.200
     1.222    -0.811     0.200
     1.532    -4.226     0.200
     1.684    -7.158     0.200
     1.808    -7.299     0.200
     2.017    -9.623     0.200
     2.076   -10.974     0.200
     2.049    -7.441     0.200
     2.142    -8.869     0.200
     2.634   -11.882     0.200
     2.683   -12.715     0.200
     2.895   -13.733     0.200
     3.292   -16.719     0.200
     3.297   -17.481     0.200
     3.401   -13.200     0.200
     4.004   -22.597     0.200
     4.465   -24.302     0.200
     5.523   -32.465     0.200
     6.394   -41.877     0.200
     7.794   -53.458     0.200
     7.858   -51.182     0.200
     0.215    10.453     0.200
     0.731     2.000     0.200
     1.250    -2.050     0.200
     1.552    -6.320     0.200
     1.562    -4.752     0.200
     1.653    -5.011     0.200
     1.762    -6.084     0.200
     2.036    -9.460     0.200
     2.024    -7.280     0.200
     2.033    -6.872     0.200
     2.173   -10.803     0.200
     2.175    -8.484     0.200
     2.200    -7.680     0.200
     2.604   -10.283     0.200
     2.750   -12.094     0.200
     2.682   -12.541     0.200
     2.883   -15.103     0.200
     3.226   -19.197     0.200
     3.290   -17.019     0.200
     3.296   -17.001     0.200
     3.342   -12.875     0.200
     3.603   -17.441     0.200
     4.002   -23.074     0.200
     4.454   -24.733     0.200
     4.617   -23.278     0.200
     4.762   -29.566     0.200
     5.504   -31.794     0.200
     5.517   -32.720     0.200
     6.149   -36.243     0.200
     6.161   -38.029     0.200
     6.391   -40.623     0.200
     6.566   -35.858     0.200
     6.690   -44.612     0.200
     6.917   -45.209     0.200
     7.788   -54.304     0.200
     7.819   -47.278     0.200
     7.848   -52.702     0.200
     7.883   -53.528     0.200
     8.287   -50.637     0.200
    10.101   -67.119     0.200
    18.485  -132.615     0.200
     0.207     9.976     0.200
     0.305     8.961     0.200
     1.185    -0.632     0.200
     1.494    -3.714     0.200
     1.690    -6.238     0.200
     1.851    -7.130     0.200
     1.993    -7.536     0.200
     2.090    -9.230     0.200
     2.102    -7.611     0.200
     2.081    -7.844     0.200
     2.263   -10.203     0.200
     2.673   -10.691     0.200
     2.705   -12.620     0.200
     2.924   -14.454     0.200
     3.314   -16.932     0.200
     3.319   -17.078     0.200
     3.428   -14.043     0.200
     3.655   -17.331     0.200
     4.027   -22.226     0.200
     4.493   -24.385     0.200
     4.774   -26.908     0.200
     5.549   -32.566     0.200
     6.174   -39.171     0.200
     6.418   -41.324     0.200
     6.709   -44.828     0.200
     6.944   -44.002     0.200
     7.820   -52.362     0.200
     7.886   -50.760     0.200
     7.915   -54.874     0.200
     0.218    10.294     0.200
     0.268    10.192     0.200
     0.727     1.358     0.200
     1.210    -1.348     0.200
     1.520    -3.987     0.200
     1.606    -7.210     0.200
     1.671    -6.392     0.200
     1.815    -6.128     0.200
     1.961    -9.271     0.200
     2.003    -8.686     0.200
     2.065    -9.972     0.200
     2.063    -7.107     0.200
     2.225   -10.838     0.200
     2.131    -7.548     0.200
     2.242    -7.982     0.200
     2.646   -10.284     0.200
     2.712   -12.765     0.200
     2.698   -12.322     0.200
     2.909   -13.214     0.200
     3.182   -17.667     0.200
     3.307   -16.321     0.200
     3.312   -16.482     0.200
     3.378   -13.892     0.200
     3.416   -16.093     0.200
     3.635   -18.248     0.200
     4.019   -21.902     0.200
     4.479   -23.792     0.200
     4.578   -23.443     0.200
     5.519   -31.369     0.200
     5.538   -32.761     0.200
     6.166   -38.960     0.200
     6.182   -36.777     0.200
     6.409   -42.380     0.200
     7.873   -51.367     0.200
     7.904   -53.974     0.200
     0.667     2.850     0.200
     1.302    -2.601     0.200
     1.761    -5.240     0.200
     2.224    -7.530     0.200
     2.524    -9.928     0.200
     2.599    -9.011     0.200
     2.632   -11.238     0.200
     3.119   -11.373     0.200
     3.130   -13.333     0.200
     3.169   -11.771     0.200
     1.262    -5.342     0.200
     1.459    -4.672     0.200
     1.524    -3.926     0.200
     1.828    -7.259     0.200
     1.841    -5.185     0.200
     1.954    -5.757     0.200
     1.936    -9.408     0.200
     2.460   -10.197     0.200
     2.548    -9.806     0.200
     2.693   -11.776     0.200
     3.150   -13.566     0.200
     3.159   -14.460     0.200
     3.855   -19.317     0.200
     6.235   -37.372     0.200
     6.719   -39.118     0.200
     0.265    10.035     0.200
     0.710     1.911     0.200
     1.204    -1.732     0.200
     1.515    -4.706     0.200
     1.653    -6.276     0.200
     1.598    -6.628     0.200
     1.812    -5.605     0.200
     1.990    -8.551     0.200
     2.047    -7.471     0.200
     2.127    -9.607     0.200
     2.073   -10.296     0.200
     2.214   -11.756     0.200
     2.247    -7.715     0.200
     2.705   -14.020     0.200
     2.651    -8.518     0.200
     2.712   -13.039     0.200
     2.920   -13.644     0.200
     3.178   -17.823     0.200
     3.372   -18.484     0.200
     3.320   -17.335     0.200
     3.326   -17.102     0.200
     3.386   -14.913     0.200
     4.033   -22.410     0.200
     4.572   -25.499     0.200
     4.491   -23.938     0.200
     5.533   -32.192     0.200
     5.551   -32.745     0.200
     6.180   -39.870     0.200
     6.423   -43.682     0.200
     6.737   -44.923     0.200
     6.907   -41.524     0.200
     7.678   -48.281     0.200
     7.678   -49.685     0.200
     7.733   -49.622     0.200
     7.822   -53.430     0.200
     8.331   -48.682     0.200
     8.660   -51.091     0.200
    11.067   -71.404     0.200
     0.330     5.391     0.200
     0.371     3.401     0.200
     1.109    -0.720     0.200
     1.190    -1.872     0.200
     1.482    -4.329     0.200
     1.429    -3.941     0.200
     1.603    -6.281     0.200
     1.830    -8.763     0.200
     2.000    -8.636     0.200
     2.052    -7.697     0.200
     2.381    -9.727     0.200
     2.848   -13.838     0.200
     3.098   -14.153     0.200
     3.248   -15.104     0.200
     3.701   -18.987     0.200
     3.710   -19.153     0.200
     3.923   -19.321     0.200
     4.408   -24.391     0.200
     4.824   -25.967     0.200
     6.790   -41.905     0.200
     7.117   -39.758     0.200
     0.095    11.732     0.200
     0.831     2.221     0.200
     1.470    -5.752     0.200
     1.495    -3.225     0.200
     1.587    -4.366     0.200
     1.902    -6.824     0.200
     1.813    -6.525     0.200
     1.876    -6.017     0.200
     1.973    -6.399     0.200
     2.376    -9.450     0.200
     2.434   -11.095     0.200
     2.603   -10.845     0.200
     2.742   -11.477     0.200
     3.203   -13.690     0.200
     3.213   -15.789     0.200
     3.425   -14.600     0.200
     3.908   -21.422     0.200
     4.318   -20.939     0.200
     5.417   -28.461     0.200
     6.287   -39.252     0.200
     0.277     8.980     0.200
     0.725     1.789     0.200
     1.202    -1.527     0.200
     1.512    -4.356     0.200
     1.615    -6.714     0.200
     1.674    -5.677     0.200
     1.824    -6.437     0.200
     1.998    -6.961     0.200
     2.069    -9.218     0.200
     2.123    -9.910     0.200
     2.069    -7.625     0.200
     2.250    -7.450     0.200
     2.702   -13.168     0.200
     2.914   -13.811     0.200
     3.311   -16.174     0.200
     3.316   -16.230     0.200
     4.023   -22.453     0.200
     4.484   -24.485     0.200
     4.766   -29.694     0.200
     5.523   -31.813     0.200
     5.543   -32.732     0.200
     6.170   -37.008     0.200
     6.414   -41.736     0.200
     7.667   -49.076     0.200
     7.667   -49.459     0.200
     7.814   -53.327     0.200
     7.909   -55.445     0.200
    18.473  -134.221     0.200
    20.757  -144.618     0.200
     0.043     9.724     0.200
     0.797     2.026     0.200
     1.384    -4.972     0.200
     1.401    -2.603     0.200
     1.590    -5.597     0.200
     1.631    -4.722     0.200
     1.717    -4.619     0.200
     1.950    -5.513     0.200
     1.975    -6.520     0.200
     1.919    -6.753     0.200
     2.053    -7.993     0.200
     2.124   -10.333     0.200
     2.334    -9.282     0.200
     2.610   -12.257     0.200
     2.779   -11.293     0.200
     3.210   -13.767     0.200
     3.215   -14.728     0.200
     3.924   -21.578     0.200
     4.181   -21.428     0.200
     4.759   -23.776     0.200
     4.770   -23.106     0.200
     5.440   -29.047     0.200
     6.071   -36.549     0.200
     6.309   -39.785     0.200
     6.589   -39.867     0.200
     6.668   -40.297     0.200
     6.806   -44.649     0.200
     6.907   -42.851     0.200
     7.170   -42.285     0.200
     7.287   -48.595     0.200
     7.434   -47.272     0.200
     7.546   -46.201     0.200
     7.588   -49.053     0.200
     7.648   -48.565     0.200
     7.696   -50.987     0.200
     7.881   -52.020     0.200
     7.981   -49.598     0.200
     8.246   -52.791     0.200
     9.372   -66.299     0.200
    12.838   -85.885     0.200
    14.328   -93.116     0.200
    18.545  -130.779     0.200
     0.371     5.071     0.200
     1.378    -2.836     0.200
     1.659    -4.641     0.200
     1.627    -7.039     0.200
     1.692    -5.201     0.200
     2.011    -6.899     0.200
     1.926    -7.515     0.200
     2.063    -9.546     0.200
     2.073    -7.892     0.200
     2.120    -6.565     0.200
     2.307    -9.903     0.200
     2.477   -11.394     0.200
     2.604   -11.300     0.200
     2.782   -12.566     0.200
     3.210   -15.706     0.200
     3.217   -14.636     0.200
     3.919   -20.896     0.200
     4.357   -22.974     0.200
     5.425   -29.419     0.200
     6.306   -43.654     0.200
     6.809   -42.202     0.200
     7.580   -49.442     0.200
     7.714   -44.106     0.200
     0.215    10.451     0.200
     0.738     1.474     0.200
     1.254    -2.157     0.200
     1.554    -6.585     0.200
     1.566    -4.648     0.200
     1.660    -5.351     0.200
     1.762    -5.575     0.200
     1.957    -7.256     0.200
     2.043    -8.385     0.200
     2.030    -8.071     0.200
     2.186    -9.202     0.200
     2.178    -9.162     0.200
     2.201    -8.782     0.200
     2.203    -8.156     0.200
     2.601   -10.266     0.200
     2.776   -12.730     0.200
     2.877   -12.212     0.200
     3.283   -16.697     0.200
     3.289   -16.678     0.200
     3.995   -22.856     0.200
     4.448   -23.935     0.200
     4.621   -26.200     0.200
     6.142   -39.727     0.200
     6.155   -37.520     0.200
     6.384   -41.208     0.200
     6.780   -36.634     0.200
     7.499   -48.634     0.200
     7.645   -49.750     0.200
     7.700   -50.425     0.200
     7.782   -52.296     0.200
     7.901   -54.178     0.200
     8.020   -52.569     0.200
     0.365     8.219     0.200
     0.682     4.095     0.200
     0.795     4.013     0.200
     0.983     0.629     0.200
     1.587    -4.902     0.200
     1.590    -3.703     0.200
     1.649    -7.372     0.200
     1.851    -7.068     0.200
     2.140   -11.846     0.200
     2.331    -9.889     0.200
     2.572   -13.033     0.200
     2.629   -12.956     0.200
     2.785   -13.494     0.200
     3.185   -16.650     0.200
     3.246   -17.515     0.200
     3.399   -19.039     0.200
     3.745   -21.601     0.200
     3.746   -21.242     0.200
     4.149   -20.427     0.200
     4.459   -27.138     0.200
     4.622   -24.624     0.200
     4.957   -28.346     0.200
     5.154   -26.872     0.200
     6.598   -42.468     0.200
     6.639   -43.068     0.200
     6.850   -47.844     0.200
     6.906   -41.015     0.200
     7.315   -43.399     0.200
     7.405   -47.848     0.200
     7.937   -51.788     0.200
     8.062   -52.949     0.200
     8.107   -54.279     0.200
     0.569     1.740     0.200
     1.408    -3.839     0.200
     1.879    -6.470     0.200
     2.026    -7.431     0.200
     2.222    -9.671     0.200
     2.306    -8.924     0.200
     2.765   -10.665     0.200
     2.956   -13.334     0.200
     3.057   -14.331     0.200
     3.463   -16.091     0.200
     3.468   -17.063     0.200
     4.175   -22.659     0.200
     4.629   -23.965     0.200
     5.554   -32.883     0.200
     5.736   -33.338     0.200
     6.322   -37.125     0.200
     6.335   -38.553     0.200
     6.565   -43.820     0.200
     6.578   -34.930     0.200
     7.081   -46.098     0.200
     7.678   -49.400     0.200
     7.822   -49.664     0.200
     7.821   -51.659     0.200
     8.082   -55.410     0.200
     0.241     9.943     0.200
     0.295     7.952     0.200
     0.722     1.321     0.200
     1.226    -2.078     0.200
     1.538    -5.164     0.200
     1.577    -5.890     0.200
     1.655    -5.055     0.200
     1.770    -5.900     0.200
     1.788    -6.492     0.200
     1.948    -6.252     0.200
     2.007    -7.437     0.200
     2.044    -7.883     0.200
     2.053    -8.175     0.200
     2.150    -9.974     0.200
     2.151    -7.097     0.200
     2.228    -6.936     0.200
     2.230    -9.005     0.200
     2.628    -8.915     0.200
     2.798   -13.194     0.200
     2.930   -14.373     0.200
     3.304   -16.753     0.200
     3.310   -17.223     0.200
     3.624   -14.879     0.200
     4.016   -22.914     0.200
     4.472   -24.071     0.200
     4.594   -22.932     0.200
     4.659   -25.186     0.200
     4.757   -27.590     0.200
     5.395   -32.545     0.200
     5.518   -33.715     0.200
     5.577   -34.308     0.200
     6.163   -36.683     0.200
     6.177   -39.724     0.200
     6.406   -40.879     0.200
     6.701   -40.832     0.200
     6.924   -45.200     0.200
     7.663   -49.233     0.200
     7.664   -48.251     0.200
     7.804   -51.699     0.200
     7.838   -48.359     0.200
     7.866   -51.644     0.200
     7.923   -54.580     0.200
     8.044   -52.503     0.200
     0.555     2.484     0.200
     1.011    -0.974     0.200
     1.348    -2.670     0.200
     1.351    -1.945     0.200
     1.378    -2.118     0.200
     1.604    -6.090     0.200
     1.627    -6.213     0.200
     1.701    -5.555     0.200
     1.690    -5.515     0.200
     1.782    -4.818     0.200
     2.306   -10.137     0.200
     2.368    -9.904     0.200
     3.232   -14.089     0.200
     3.741   -17.308     0.200
     3.752   -16.981     0.200
     0.235    10.435     0.200
     0.235     9.846     0.200
     1.234    -2.643     0.200
     1.546    -4.423     0.200
     1.763    -6.703     0.200
     1.782    -6.396     0.200
     2.014    -6.175     0.200
     2.045    -7.744     0.200
     2.144    -7.581     0.200
     2.200    -9.573     0.200
     2.158    -8.630     0.200
     2.223    -8.777     0.200
     2.620   -10.890     0.200
     2.791   -12.597     0.200
     2.922   -14.060     0.200
     3.298   -17.455     0.200
     3.303   -17.427     0.200
     4.009   -23.520     0.200
     4.465   -24.459     0.200
     4.651   -24.165     0.200
     5.389   -31.348     0.200
     5.570   -31.001     0.200
     0.153    10.475     0.200
     0.339     6.379     0.200
     0.674     3.257     0.200
     1.504    -3.558     0.200
     1.607    -7.218     0.200
     1.627    -6.347     0.200
     1.644    -5.600     0.200
     1.860    -5.545     0.200
     1.992    -9.020     0.200
     2.154    -7.567     0.200
     2.141    -7.445     0.200
     2.266    -9.700     0.200
     2.547   -12.096     0.200
     2.833   -11.086     0.200
     2.938   -14.493     0.200
     3.342   -15.526     0.200
     4.050   -23.450     0.200
     5.430   -33.302     0.200
     5.595   -31.445     0.200
     6.433   -43.410     0.200
     6.925   -39.981     0.200
     7.717   -48.798     0.200
     7.864   -50.156     0.200
     0.477     4.446     0.200
     0.496     3.353     0.200
     0.570     3.096     0.200
     0.590     2.378     0.200
     1.069    -1.905     0.200
     1.399    -3.570     0.200
     1.423    -4.256     0.200
     1.634    -6.815     0.200
     1.656    -5.932     0.200
     1.636    -6.101     0.200
     2.255    -9.620     0.200
     2.366    -9.951     0.200
     2.372   -12.337     0.200
     2.457   -10.516     0.200
     2.740   -12.290     0.200
     3.197   -15.676     0.200
     3.706   -17.612     0.200
     4.405   -22.180     0.200
     0.492     2.841     0.200
     0.693     2.771     0.200
     1.219    -3.412     0.200
     1.479    -3.937     0.200
     1.499    -4.797     0.200
     1.753    -4.242     0.200
     2.033    -5.025     0.200
     2.100    -5.847     0.200
     2.143    -6.702     0.200
     2.485    -9.645     0.200
     2.869   -11.703     0.200
     2.950   -12.083     0.200
     3.378   -11.349     0.200
     3.388   -13.375     0.200
     4.080   -17.699     0.200
     5.459   -28.305     0.200
     0.310     7.748     0.200
     0.365     6.611     0.200
     0.720     1.460     0.200
     1.175    -0.981     0.200
     1.484    -4.475     0.200
     1.681    -5.714     0.200
     1.647    -6.727     0.200
     1.838    -6.781     0.200
     1.856    -7.069     0.200
     1.981    -6.936     0.200
     2.083    -9.260     0.200
     2.093    -9.589     0.200
     2.092    -8.049     0.200
     2.208    -9.916     0.200
     2.188    -8.093     0.200
     2.272   -10.265     0.200
     2.282    -8.574     0.200
     2.682   -11.550     0.200
     2.821   -14.340     0.200
     2.935   -13.768     0.200
     2.960   -14.173     0.200
     3.326   -17.658     0.200
     3.330   -18.104     0.200
     4.039   -23.153     0.200
     4.545   -22.804     0.200
     4.504   -25.704     0.200
     4.905   -25.714     0.200
     5.417   -35.050     0.200
     5.538   -33.773     0.200
     5.604   -33.571     0.200
     6.185   -41.198     0.200
     6.204   -38.909     0.200
     6.430   -43.350     0.200
     6.453   -38.388     0.200
     6.738   -45.232     0.200
     6.843   -38.159     0.200
     6.956   -44.321     0.200
     7.538   -47.884     0.200
     7.679   -50.357     0.200
     7.733   -49.456     0.200
     7.873   -48.312     0.200
     7.897   -51.778     0.200
     7.950   -55.559     0.200
     8.493   -54.148     0.200
     8.709   -50.206     0.200
    10.190   -63.258     0.200
    13.092   -85.250     0.200
    18.462  -130.486     0.200
     0.640     2.527     0.200
     0.931     1.093     0.200
     1.114     1.115     0.200
     1.310    -1.617     0.200
     1.287    -4.195     0.200
     1.311    -3.433     0.200
     1.377    -3.242     0.200
     2.032    -7.511     0.200
     2.313    -8.997     0.200
     2.649   -11.650     0.200
     2.766   -14.258     0.200
     3.102   -15.633     0.200
     3.128   -14.732     0.200
     3.606   -17.087     0.200
     3.621   -18.174     0.200
     4.140   -18.111     0.200
     4.613   -22.003     0.200
     0.296    10.545     0.200
     0.274    12.166     0.200
     1.169    -1.514     0.200
     1.548    -6.046     0.200
     1.485    -4.441     0.200
     1.561    -6.155     0.200
     1.784    -5.808     0.200
     1.803    -6.130     0.200
     1.914    -7.838     0.200
     1.946   -10.037     0.200
     2.103    -8.933     0.200
     2.166    -8.923     0.200
     2.136    -8.377     0.200
     2.219   -11.106     0.200
     2.237    -8.377     0.200
     2.288    -7.889     0.200
     2.719   -11.742     0.200
     2.688    -9.174     0.200
     2.896   -14.065     0.200
     3.021   -15.333     0.200
     3.404   -14.380     0.200
     3.403   -18.550     0.200
     3.409   -17.541     0.200
     3.439   -15.366     0.200
     3.703   -18.133     0.200
     4.115   -23.991     0.200
     4.528   -22.910     0.200
     4.647   -27.685     0.200
     4.563   -25.096     0.200
     5.618   -34.938     0.200
     5.672   -33.974     0.200
     6.262   -39.666     0.200
     6.272   -39.871     0.200
     6.503   -44.418     0.200
     6.824   -45.866     0.200
     7.686   -50.015     0.200
     7.765   -50.510     0.200
     7.767   -51.662     0.200
     7.956   -52.054     0.200
     8.018   -57.229     0.200
     8.176   -53.054     0.200
    10.079   -62.874     0.200
     0.509     4.889     0.200
     0.587     5.227     0.200
     0.911     0.964     0.200
     1.003     0.936     0.200
     1.105    -1.993     0.200
     1.127    -0.999     0.200
     1.394    -1.543     0.200
     1.408    -3.807     0.200
     1.578    -4.487     0.200
     1.765    -5.224     0.200
     1.816    -6.329     0.200
     1.866    -5.602     0.200
     2.033    -7.501     0.200
     2.136   -10.669     0.200
     2.228    -7.486     0.200
     2.759   -15.638     0.200
     2.821   -13.298     0.200
     2.877   -16.661     0.200
     2.848   -13.547     0.200
     3.324   -15.949     0.200
     3.340   -16.036     0.200
     4.007   -20.791     0.200
     5.375   -29.746     0.200
     0.148     6.914     0.200
     0.217     7.216     0.200
     0.599     2.414     0.200
     0.866     1.550     0.200
     1.347    -4.608     0.200
     1.367    -4.034     0.200
     1.578    -4.633     0.200
     1.776    -7.087     0.200
     1.826    -5.699     0.200
     1.899    -7.784     0.200
     1.929    -6.444     0.200
     1.970    -8.235     0.200
     2.284    -9.693     0.200
     2.316    -9.306     0.200
     2.638   -14.326     0.200
     2.702   -12.454     0.200
     2.778   -12.754     0.200
     3.211   -14.591     0.200
     3.222   -15.240     0.200
     3.911   -19.783     0.200
     5.289   -28.365     0.200
     6.284   -37.896     0.200
     0.066    10.403     0.200
     0.181     9.665     0.200
     0.537     4.375     0.200
     0.808     2.178     0.200
     1.410    -4.602     0.200
     1.430    -4.235     0.200
     1.514    -3.811     0.200
     1.819    -7.380     0.200
     1.818    -6.538     0.200
     1.834    -7.861     0.200
     1.989    -7.374     0.200
     2.019    -8.125     0.200
     2.342   -10.341     0.200
     2.377    -7.461     0.200
     2.457   -12.003     0.200
     2.574   -14.306     0.200
     2.744   -11.880     0.200
     2.826   -12.784     0.200
     3.253   -14.525     0.200
     3.263   -16.658     0.200
     3.445   -13.224     0.200
     3.955   -21.579     0.200
     4.353   -21.196     0.200
     5.334   -33.184     0.200
     0.191     9.081     0.200
     0.345     5.991     0.200
     0.642     2.991     0.200
     1.316    -2.479     0.200
     1.606    -6.687     0.200
     1.627    -7.124     0.200
     1.636    -5.626     0.200
     2.065    -7.621     0.200
     2.175    -9.493     0.200
     2.172    -7.925     0.200
     2.259   -10.162     0.200
     2.376   -12.664     0.200
     2.565   -11.277     0.200
     2.870   -12.245     0.200
     2.971   -13.642     0.200
     3.379   -16.087     0.200
     3.388   -15.656     0.200
     4.086   -19.689     0.200
     4.506   -24.384     0.200
     5.466   -30.040     0.200
     5.629   -30.416     0.200
     6.226   -35.931     0.200
     6.233   -38.733     0.200
     6.469   -43.715     0.200
     6.742   -41.083     0.200
     6.809   -45.693     0.200
     6.956   -40.369     0.200
     7.450   -46.939     0.200
     7.598   -48.728     0.200
     7.655   -46.436     0.200
     7.748   -51.777     0.200
     7.755   -52.195     0.200
     7.816   -50.341     0.200
     7.852   -52.671     0.200
     7.895   -48.333     0.200
     7.972   -54.871     0.200
     8.114   -50.869     0.200
     8.404   -56.183     0.200
     0.283     8.914     0.200
     0.728     1.726     0.200
     1.199    -1.321     0.200
     1.509    -4.339     0.200
     1.621    -6.505     0.200
     1.679    -5.818     0.200
     1.728    -6.188     0.200
     1.811    -6.609     0.200
     1.829    -7.596     0.200
     1.998    -7.148     0.200
     2.075    -8.388     0.200
     2.071    -7.050     0.200
     2.119    -8.474     0.200
     2.250   -10.918     0.200
     2.233   -11.004     0.200
     2.257    -7.557     0.200
     2.804   -13.000     0.200
     2.915   -14.017     0.200
     2.942   -14.053     0.200
     3.310   -16.832     0.200
     3.315   -17.487     0.200
     3.398   -17.309     0.200
     3.389   -16.037     0.200
     4.022   -22.718     0.200
     4.292   -25.671     0.200
     4.485   -26.777     0.200
     4.673   -25.441     0.200
     4.769   -24.784     0.200
     5.401   -31.226     0.200
     5.522   -31.265     0.200
     5.586   -31.996     0.200
     6.169   -39.972     0.200
     6.413   -41.206     0.200
     6.434   -34.558     0.200
     7.016   -44.016     0.200
     7.279   -44.340     0.200
     7.523   -48.590     0.200
     7.594   -49.331     0.200
     7.665   -48.501     0.200
     7.933   -55.080     0.200
     8.356   -48.507     0.200
    10.630   -65.592     0.200
     0.021    11.037     0.200
     0.106    11.234     0.200
     0.486     4.470     0.200
     0.806     2.224     0.200
     1.461    -5.019     0.200
     1.478    -3.470     0.200
     1.480    -4.435     0.200
     1.797    -6.886     0.200
     1.843    -6.430     0.200
     1.879    -3.973     0.200
     1.892    -7.896     0.200
     2.005    -7.368     0.200
     2.010    -7.427     0.200
     2.396    -9.560     0.200
     2.403   -10.800     0.200
     2.418   -11.677     0.200
     2.535   -13.967     0.200
     2.720   -11.540     0.200
     2.812   -12.450     0.200
     3.230   -14.589     0.200
     3.239   -15.088     0.200
     3.934   -19.517     0.200
     4.344   -20.504     0.200
     4.518   -24.335     0.200
     5.314   -33.651     0.200
     5.472   -30.459     0.200
     6.313   -42.639     0.200
     7.448   -48.306     0.200
     7.599   -50.914     0.200
     7.672   -51.425     0.200
     7.732   -47.507     0.200
     7.813   -53.371     0.200
     0.126    12.765     0.200
     0.226     8.897     0.200
     0.334     7.474     0.200
     0.783     2.234     0.200
     1.339    -2.404     0.200
     1.653    -6.045     0.200
     1.652    -6.227     0.200
     1.671    -6.212     0.200
     1.809    -6.410     0.200
     2.024    -7.124     0.200
     2.056    -8.039     0.200
     2.110    -9.055     0.200
     2.118    -6.691     0.200
     2.267    -9.809     0.200
     2.382   -11.459     0.200
     2.515    -9.675     0.200
     2.611   -12.830     0.200
     2.721   -12.612     0.200
     2.842   -14.538     0.200
     3.229   -14.215     0.200
     3.236   -17.125     0.200
     3.939   -23.229     0.200
     6.327   -43.723     0.200
     7.720   -51.180     0.200
     7.776   -49.236     0.200
     1.134    -1.908     0.200
     1.179    -2.748     0.200
     1.758    -5.887     0.200
     1.875    -8.212     0.200
     2.099    -9.703     0.200
     2.120   -10.079     0.200
     2.689   -12.102     0.200
     2.712   -12.548     0.200
     3.103   -14.023     0.200
     3.350   -17.571     0.200
     3.476   -18.360     0.200
     3.857   -19.943     0.200
     3.863   -20.119     0.200
     4.569   -23.604     0.200
     6.958   -46.646     0.200
     7.469   -47.431     0.200
     0.159    10.976     0.200
     0.333     8.766     0.200
     0.410     5.432     0.200
     0.688     2.131     0.200
     1.141    -0.625     0.200
     1.450    -3.545     0.200
     1.678    -5.769     0.200
     1.832    -5.735     0.200
     1.862    -7.678     0.200
     1.880    -7.272     0.200
     1.945    -6.626     0.200
     2.061    -7.397     0.200
     2.175    -9.931     0.200
     2.167    -8.047     0.200
     2.224    -8.683     0.200
     2.281   -11.487     0.200
     2.317    -8.519     0.200
     2.420    -8.793     0.200
     2.510   -10.624     0.200
     2.661   -11.707     0.200
     2.822   -11.730     0.200
     2.857   -13.126     0.200
     2.997   -14.070     0.200
     3.120   -15.656     0.200
     3.362   -17.439     0.200
     3.613   -18.292     0.200
     4.035   -21.971     0.200
     4.328   -23.458     0.200
     4.513   -23.931     0.200
     4.677   -24.023     0.200
     4.741   -26.163     0.200
     5.640   -31.661     0.200
     6.221   -42.478     0.200
     6.466   -45.335     0.200
     6.879   -38.247     0.200
     6.992   -47.217     0.200
     7.716   -54.564     0.200
     7.934   -53.674     0.200
     7.987   -56.950     0.200
     8.156   -52.414     0.200
     0.247    10.349     0.200
     0.211    11.172     0.200
     0.277     8.699     0.200
     0.438     4.998     0.200
     0.685     3.057     0.200
     0.880     1.873     0.200
     1.179    -3.184     0.200
     1.235    -1.566     0.200
     1.316    -2.450     0.200
     1.434    -2.672     0.200
     1.500    -4.474     0.200
     1.537    -3.858     0.200
     1.570    -4.002     0.200
     1.706    -5.400     0.200
     1.722    -4.896     0.200
     1.735    -5.312     0.200
     1.775    -5.481     0.200
     1.819    -6.799     0.200
     1.896    -5.939     0.200
     2.079    -7.216     0.200
     2.070    -7.551     0.200
     2.187    -8.244     0.200
     2.281   -12.046     0.200
     2.276    -8.383     0.200
     2.252    -8.909     0.200
     2.319    -8.153     0.200
     2.604   -11.956     0.200
     2.948   -15.368     0.200
     3.383   -16.654     0.200
     3.571   -19.839     0.200
     4.003   -24.206     0.200
     4.281   -24.642     0.200
     5.160   -29.304     0.200
     6.189   -41.726     0.200
     6.431   -45.075     0.200
     6.941   -46.266     0.200
     0.079    11.210     0.200
     0.508     4.603     0.200
     0.447     6.535     0.200
     0.664     1.973     0.200
     1.001    -0.213     0.200
     1.111    -0.710     0.200
     1.157    -1.960     0.200
     1.220    -2.065     0.200
     1.243     0.304     0.200
     1.334    -3.589     0.200
     1.417    -3.713     0.200
     1.460    -3.778     0.200
     1.583    -2.176     0.200
     1.714    -6.113     0.200
     1.730    -4.937     0.200
     1.817    -6.188     0.200
     1.810    -5.251     0.200
     1.882    -6.440     0.200
     1.878    -5.635     0.200
     1.909    -5.016     0.200
     1.978    -5.887     0.200
     2.009    -7.069     0.200
     2.044    -7.687     0.200
     2.049    -5.833     0.200
     2.036    -8.624     0.200
     2.410   -10.771     0.200
     2.488    -9.869     0.200
     2.486   -10.586     0.200
     2.563   -15.030     0.200
     2.770   -11.898     0.200
     2.851   -11.461     0.200
     2.978   -13.280     0.200
     3.491   -16.838     0.200
     0.392     5.424     0.200
     0.618     1.639     0.200
     0.660     0.029     0.200
     0.793     1.108     0.200
     0.962    -0.261     0.200
     1.066     1.160     0.200
     1.164    -2.651     0.200
     1.264    -1.338     0.200
     1.469    -4.427     0.200
     1.600    -6.167     0.200
     1.584    -4.065     0.200
     1.622    -2.683     0.200
     1.649    -5.441     0.200
     1.836    -6.369     0.200
     2.335    -8.774     0.200
     2.410   -13.147     0.200
     2.437    -9.708     0.200
     3.316   -15.090     0.200
     3.375   -16.259     0.200
     0.408     4.510     0.200
     0.428     3.367     0.200
     0.483     5.723     0.200
     0.817     0.933     0.200
     0.976    -1.112     0.200
     0.956    -0.064     0.200
     1.003    -0.057     0.200
     1.301    -3.920     0.200
     1.346    -1.151     0.200
     1.451    -5.678     0.200
     1.439    -3.274     0.200
     1.428    -2.651     0.200
     1.502    -4.602     0.200
     1.694    -5.773     0.200
     1.702    -6.139     0.200
     1.925    -6.182     0.200
     2.143    -6.818     0.200
     2.255    -8.346     0.200
     2.244   -10.211     0.200
     2.288   -13.101     0.200
     2.375   -10.256     0.200
     2.386    -9.619     0.200
     2.427   -10.014     0.200
     3.147   -13.243     0.200
     3.360   -15.994     0.200
     0.536     4.274     0.200
     0.815     0.642     0.200
     0.926    -0.188     0.200
     0.936     1.195     0.200
     1.217    -0.212     0.200
     1.406    -4.318     0.200
     1.473    -4.226     0.200
     1.586    -3.499     0.200
     1.595    -5.203     0.200
     1.661    -5.778     0.200
     1.763    -5.628     0.200
     1.769    -7.120     0.200
     1.860    -5.991     0.200
     1.939    -5.789     0.200
     2.248    -9.987     0.200
     2.277    -9.517     0.200
     2.561   -12.805     0.200
     2.577   -12.929     0.200
     2.723   -14.541     0.200
     2.835   -13.107     0.200
     3.004   -16.162     0.200
     3.204   -16.399     0.200
     3.323   -19.183     0.200
     3.442   -20.063     0.200
     3.796   -21.082     0.200
     3.920   -23.715     0.200
     4.320   -28.290     0.200
     4.644   -27.640     0.200
     5.038   -33.046     0.200
     5.466   -36.495     0.200
     5.733   -37.366     0.200
     1.055     0.029     0.200
     1.091    -0.426     0.200
     1.562    -2.444     0.200
     1.915    -3.748     0.200
     1.903    -3.475     0.200
     2.088    -6.031     0.200
     2.119    -5.420     0.200
     2.557    -9.387     0.200
     2.553    -9.454     0.200
     2.733    -7.982     0.200
     2.922   -14.260     0.200
     2.919   -12.775     0.200
     2.933   -11.018     0.200
     3.061   -11.874     0.200
     3.420   -13.846     0.200
     4.064   -19.357     0.200
     6.610   -37.075     0.200
     1.019    -0.349     0.200
     1.092    -0.181     0.200
     1.299    -1.043     0.200
     1.830    -3.370     0.200
     1.848    -3.761     0.200
     1.915    -4.262     0.200
     2.551    -8.644     0.200
     2.920   -13.831     0.200
     2.918   -11.453     0.200
     3.060   -11.262     0.200
     3.418   -13.827     0.200
     4.062   -19.041     0.200
     1.001    -1.263     0.200
     1.179    -2.899     0.200
     1.304    -3.368     0.200
     1.483    -4.243     0.200
     1.449    -2.948     0.200
     1.554    -4.083     0.200
     1.682    -4.738     0.200
     1.692    -3.851     0.200
     2.010    -7.349     0.200
     2.192    -8.923     0.200
     2.239    -9.705     0.200
     2.288    -9.567     0.200
     2.347   -10.331     0.200
     2.569   -14.770     0.200
     2.784   -11.682     0.200
     2.847   -12.263     0.200
     2.880   -13.613     0.200
     2.873   -12.816     0.200
     3.210   -16.676     0.200
     3.254   -15.292     0.200
     3.382   -16.847     0.200
     3.603   -18.238     0.200
     3.716   -20.132     0.200
     3.903   -19.642     0.200
     4.125   -22.103     0.200
     4.372   -23.009     0.200
     4.576   -23.275     0.200
     4.858   -25.217     0.200
     5.034   -28.595     0.200
     5.779   -32.618     0.200
     5.907   -32.871     0.200
     6.296   -38.904     0.200
     1.099    -1.401     0.200
     1.248    -2.833     0.200
     1.285    -2.891     0.200
     1.323    -3.599     0.200
     1.497    -4.227     0.200
     1.482    -4.453     0.200
     1.662    -5.348     0.200
     1.813    -6.122     0.200
     1.821    -6.093     0.200
     1.894    -6.909     0.200
     1.977    -6.219     0.200
     2.008    -8.306     0.200
     2.475   -10.515     0.200
     2.461    -9.269     0.200
     2.512   -13.183     0.200
     2.739   -12.180     0.200
     2.832   -12.747     0.200
     0.239     5.429     0.200
     0.396     2.932     0.200
     0.456     3.443     0.200
     0.691     2.402     0.200
     0.960    -1.231     0.200
     1.276    -1.349     0.200
     1.285    -3.744     0.200
     1.481    -3.646     0.200
     1.529    -4.980     0.200
     1.547    -3.457     0.200
     1.625    -3.813     0.200
     1.626    -5.743     0.200
     1.647    -5.310     0.200
     1.843    -6.946     0.200
     1.881    -6.535     0.200
     2.080    -7.046     0.200
     2.123    -8.018     0.200
     2.134   -11.863     0.200
     2.272    -8.720     0.200
     2.409    -8.786     0.200
     2.471    -9.435     0.200
     2.697   -13.206     0.200
     2.821   -12.343     0.200
     3.050   -15.090     0.200
     3.169   -15.972     0.200
     3.294   -17.121     0.200
     3.558   -17.189     0.200
     5.648   -34.956     0.200
     0.695     2.086     0.200
     1.365    -1.973     0.200
     1.429    -3.193     0.200
     1.851    -5.384     0.200
     1.978    -5.297     0.200
     2.746    -9.935     0.200
     2.951   -13.044     0.200
     3.255   -13.777     0.200
     0.271     5.153     0.200
     0.352     3.182     0.200
     0.780     0.937     0.200
     1.097    -2.219     0.200
     1.399    -3.407     0.200
     1.409    -3.335     0.200
     1.633    -5.417     0.200
     1.654    -5.483     0.200
     1.725    -6.020     0.200
     1.717    -6.485     0.200
     1.837    -7.399     0.200
     1.851    -6.641     0.200
     2.166   -11.223     0.200
     2.175    -7.588     0.200
     2.181    -8.309     0.200
     2.186    -8.455     0.200
     2.263    -8.688     0.200
     2.257    -7.987     0.200
     2.334    -9.531     0.200
     2.413    -9.936     0.200
     2.427    -9.387     0.200
     2.694   -11.363     0.200
     2.846   -11.560     0.200
     2.899   -13.844     0.200
     3.034   -15.222     0.200
     3.157   -16.524     0.200
     3.652   -19.435     0.200
     4.366   -23.346     0.200
     0.124    11.082     0.200
     0.635     2.473     0.200
     0.970     0.559     0.200
     1.077    -0.256     0.200
     1.184     0.951     0.200
     1.242    -2.173     0.200
     1.288    -3.741     0.200
     1.499    -4.324     0.200
     1.528    -1.852     0.200
     1.688    -5.708     0.200
     1.735    -4.798     0.200
     1.752    -4.736     0.200
     1.765    -5.648     0.200
     1.845    -6.203     0.200
     1.931    -6.508     0.200
     1.900    -4.817     0.200
     1.996    -8.887     0.200
     2.100    -8.288     0.200
     2.118    -6.127     0.200
     2.469    -9.961     0.200
     2.545   -11.370     0.200
     2.536   -13.891     0.200
     2.829   -12.293     0.200
     2.908   -13.893     0.200
     3.035   -14.215     0.200
     0.267     9.385     0.200
     0.366     5.559     0.200
     0.361     6.311     0.200
     0.799     2.414     0.200
     1.111    -2.147     0.200
     1.374    -2.204     0.200
     1.345    -1.876     0.200
     1.576    -5.101     0.200
     1.625    -4.666     0.200
     1.644    -4.871     0.200
     1.730    -5.370     0.200
     1.738    -6.129     0.200
     1.811    -5.046     0.200
     1.823    -5.825     0.200
     2.153    -8.284     0.200
     2.163    -8.314     0.200
     2.195    -7.626     0.200
     2.192   -10.831     0.200
     2.239    -8.731     0.200
     2.384    -9.019     0.200
     2.401    -9.039     0.200
     2.824   -12.959     0.200
     3.018   -17.198     0.200
     3.392   -18.572     0.200
     3.638   -18.958     0.200
     4.768   -30.787     0.200
     5.214   -34.514     0.200
     0.999     0.197     0.200
     1.324    -1.398     0.200
     1.355    -1.966     0.200
     1.803    -3.777     0.200
     1.893    -3.928     0.200
     2.081    -8.281     0.200
     2.544    -8.870     0.200
     2.522    -9.786     0.200
     2.649   -12.186     0.200
     2.856   -11.251     0.200
     2.914   -12.804     0.200
     3.042   -12.349     0.200
     3.559   -13.760     0.200
     0.233    10.676     0.200
     0.309     7.341     0.200
     0.425     4.872     0.200
     0.863     2.205     0.200
     1.169    -2.998     0.200
     1.409    -3.106     0.200
     1.347    -2.465     0.200
     1.411    -0.994     0.200
     1.533    -4.747     0.200
     1.568    -4.356     0.200
     1.578    -3.283     0.200
     1.699    -5.621     0.200
     1.748    -5.654     0.200
     1.801    -6.751     0.200
     1.776    -5.433     0.200
     1.765    -6.215     0.200
     1.801    -3.648     0.200
     2.099    -7.584     0.200
     2.103    -8.010     0.200
     2.256   -11.554     0.200
     2.259    -7.744     0.200
     2.216    -9.301     0.200
     2.217    -9.137     0.200
     2.285    -8.278     0.200
     2.337    -7.544     0.200
     2.327    -8.205     0.200
     2.336    -7.405     0.200
     2.496   -10.976     0.200
     2.616   -11.775     0.200
     2.711   -11.997     0.200
     2.830   -15.255     0.200
     2.958   -15.028     0.200
     3.082   -16.746     0.200
     3.191   -13.499     0.200
     3.397   -15.325     0.200
     4.009   -24.934     0.200
     4.291   -23.684     0.200
     4.711   -30.184     0.200
     5.158   -33.555     0.200
     5.428   -34.715     0.200
     5.951   -36.991     0.200
     6.450   -42.904     0.200
     6.454   -39.044     0.200
     6.756   -45.208     0.200
     6.829   -38.341     0.200
     6.829   -38.641     0.200
     7.014   -44.996     0.200
     7.033   -48.392     0.200
     7.499   -48.261     0.200
     7.607   -50.195     0.200
     7.954   -55.981     0.200
     7.990   -51.323     0.200
     8.013   -57.566     0.200
     8.115   -52.188     0.200
     8.203   -57.086     0.200
     0.238     9.573     0.200
     0.297     6.894     0.200
     0.430     4.685     0.200
     0.869     1.653     0.200
     1.335    -2.127     0.200
     1.418    -2.950     0.200
     1.404    -1.807     0.200
     1.520    -4.588     0.200
     1.556    -3.924     0.200
     1.702    -5.339     0.200
     1.738    -4.676     0.200
     1.754    -6.283     0.200
     1.775    -5.563     0.200
     1.808    -6.312     0.200
     1.793    -4.025     0.200
     2.265    -8.199     0.200
     2.272    -7.921     0.200
     2.315    -8.774     0.200
     2.753   -12.768     0.200
     2.954   -14.342     0.200
     3.078   -15.868     0.200
     3.391   -16.096     0.200
     4.288   -23.407     0.200
     4.708   -27.631     0.200
     5.948   -37.258     0.200
     6.450   -39.360     0.200
     0.691     0.735     0.200
     1.275    -3.057     0.200
     1.508    -3.770     0.200
     1.648    -3.580     0.200
     1.649    -4.219     0.200
     1.695    -4.274     0.200
     1.738    -6.553     0.200
     1.975    -5.160     0.200
     2.003    -7.962     0.200
     2.087    -8.125     0.200
     2.444    -9.719     0.200
     2.580   -14.649     0.200
     0.152     8.730     0.200
     0.487     4.915     0.200
     0.487     6.299     0.200
     0.518     3.323     0.200
     0.963     0.919     0.200
     1.050    -0.932     0.200
     1.187    -2.676     0.200
     1.178     0.702     0.200
     1.257    -3.204     0.200
     1.359    -2.746     0.200
     1.556    -4.574     0.200
     1.571    -5.642     0.200
     1.609    -4.473     0.200
     1.676    -4.971     0.200
     1.887    -7.355     0.200
     2.028    -6.955     0.200
     2.198    -8.318     0.200
     2.419   -13.435     0.200
     2.532    -9.429     0.200
     2.623   -11.508     0.200
     2.891   -13.105     0.200
     2.982   -14.295     0.200
     3.109   -15.600     0.200
     3.401   -16.854     0.200
     3.619   -18.878     0.200
     0.368     6.261     0.200
     0.446     4.173     0.200
     0.704     2.701     0.200
     0.762     0.654     0.200
     0.798     1.331     0.200
     1.005    -1.125     0.200
     1.178    -2.306     0.200
     1.296    -2.755     0.200
     1.503    -3.133     0.200
     1.524    -5.279     0.200
     1.544    -5.406     0.200
     1.593    -5.073     0.200
     1.629    -4.026     0.200
     1.873    -6.668     0.200
     2.162    -9.098     0.200
     2.469   -10.161     0.200
     2.464   -10.377     0.200
     2.632   -12.327     0.200
     2.682   -11.786     0.200
     2.790   -13.527     0.200
     3.053   -14.346     0.200
     3.048   -16.290     0.200
     3.238   -17.518     0.200
     3.380   -20.521     0.200
     3.436   -18.209     0.200
     3.550   -19.429     0.200
     3.675   -20.665     0.200
     4.030   -23.443     0.200
     4.151   -23.651     0.200
     4.547   -28.512     0.200
     4.875   -29.806     0.200
     5.266   -34.321     0.200
     5.691   -37.873     0.200
     6.480   -44.311     0.200
     7.036   -44.721     0.200
     0.510     5.173     0.200
     0.549     5.463     0.200
     0.766     1.068     0.200
     0.893    -0.153     0.200
     0.956     1.157     0.200
     1.156     0.316     0.200
     1.405    -4.089     0.200
     1.442    -3.853     0.200
     1.617    -7.103     0.200
     1.700    -4.629     0.200
     1.796    -7.879     0.200
     1.861    -5.631     0.200
     1.883    -6.032     0.200
     2.213    -9.402     0.200
     2.539   -10.921     0.200
     2.802   -12.661     0.200
     2.819   -13.728     0.200
     2.998   -15.288     0.200
     3.157   -16.618     0.200
     3.187   -15.268     0.200
     3.298   -16.099     0.200
     3.322   -17.751     0.200
     3.442   -18.159     0.200
     3.656   -19.237     0.200
     3.789   -20.259     0.200
     3.924   -21.731     0.200
     4.302   -23.917     0.200
     4.645   -26.404     0.200
     4.861   -27.237     0.200
     5.515   -31.963     0.200
     6.266   -40.683     0.200
     6.808   -42.768     0.200
     7.382   -51.443     0.200
     0.236    10.066     0.200
     0.312     7.048     0.200
     0.421     5.012     0.200
     0.858     2.146     0.200
     1.164    -2.858     0.200
     1.404    -2.677     0.200
     1.348    -2.792     0.200
     1.535    -4.719     0.200
     1.571    -4.374     0.200
     1.695    -5.485     0.200
     1.752    -5.395     0.200
     1.797    -7.314     0.200
     1.769    -5.330     0.200
     1.799    -4.300     0.200
     2.104    -7.639     0.200
     2.106    -7.804     0.200
     2.252   -11.631     0.200
     2.254    -8.206     0.200
     2.218    -8.855     0.200
     2.287    -8.046     0.200
     2.330    -9.224     0.200
     2.834   -14.509     0.200
     2.963   -15.484     0.200
     5.955   -37.944     0.200
     6.459   -39.501     0.200
     7.019   -45.652     0.200
     7.612   -49.055     0.200
     1.219    -2.385     0.200
     1.778    -8.436     0.200
     1.803    -7.118     0.200
     2.006    -8.437     0.200
     2.199    -9.571     0.200
     2.278    -8.957     0.200
     2.239    -9.439     0.200
     2.506   -11.010     0.200
     2.629   -10.908     0.200
     2.685   -10.565     0.200
     2.752   -13.392     0.200
     2.865   -12.395     0.200
     3.099   -15.809     0.200
     3.234   -16.766     0.200
     3.356   -16.352     0.200
     3.449   -19.482     0.200
     3.578   -19.896     0.200
     3.702   -21.324     0.200
     3.955   -22.130     0.200
     4.201   -23.219     0.200
     4.628   -28.052     0.200
     4.912   -28.359     0.200
     5.071   -27.898     0.200
     5.251   -28.705     0.200
     5.331   -33.355     0.200
     5.777   -37.678     0.200
     5.790   -33.699     0.200
     6.046   -39.823     0.200
     6.569   -41.608     0.200
     7.074   -41.216     0.200
     0.256    10.344     0.200
     0.912     0.960     0.200
     1.285    -1.774     0.200
     1.498    -4.103     0.200
     1.727    -6.081     0.200
     1.684    -4.908     0.200
     1.695    -5.461     0.200
     1.851    -7.714     0.200
     2.045    -6.566     0.200
     2.158    -8.628     0.200
     2.146    -8.038     0.200
     2.308    -8.987     0.200
     2.319   -12.435     0.200
     2.274    -7.513     0.200
     2.450    -9.804     0.200
     2.577   -11.430     0.200
     2.765   -14.970     0.200
     2.765   -14.371     0.200
     2.803   -14.092     0.200
     2.924   -14.503     0.200
     3.048   -15.144     0.200
     3.311   -17.394     0.200
     3.549   -18.928     0.200
     3.983   -22.674     0.200
     4.258   -22.489     0.200
     4.632   -26.148     0.200
     4.717   -26.855     0.200
     5.137   -29.168     0.200
     6.419   -38.920     0.200
     6.421   -41.862     0.200
     6.786   -39.147     0.200
     6.786   -39.448     0.200
     6.870   -44.104     0.200
     6.977   -44.606     0.200
     6.999   -47.600     0.200
     7.570   -49.997     0.200
     7.602   -51.997     0.200
     7.922   -55.841     0.200
     7.984   -57.506     0.200
     8.171   -56.031     0.200
    12.365   -85.785     0.200
     0.438     7.490     0.200
     0.581     5.031     0.200
     0.607     4.006     0.200
     0.933    -0.327     0.200
     1.093     0.108     0.200
     1.490    -3.560     0.200
     1.481    -3.675     0.200
     1.509    -4.366     0.200
     1.551    -2.416     0.200
     1.617    -5.400     0.200
     1.796    -5.958     0.200
     1.875    -6.779     0.200
     1.939    -8.806     0.200
     1.966    -5.370     0.200
     2.073    -7.642     0.200
     2.065    -7.690     0.200
     2.406   -11.023     0.200
     2.731   -14.700     0.200
     2.893   -15.730     0.200
     3.074   -17.576     0.200
     3.224   -18.452     0.200
     3.346   -19.310     0.200
     3.577   -21.213     0.200
     3.680   -20.287     0.200
     3.835   -22.806     0.200
     0.532     1.772     0.200
     0.559     1.204     0.200
     0.875     0.598     0.200
     0.891     0.278     0.200
     0.982    -1.189     0.200
     1.218    -2.770     0.200
     1.483    -4.964     0.200
     1.531    -5.296     0.200
     1.668    -5.946     0.200
     1.826    -6.435     0.200
     2.206    -8.904     0.200
     2.306    -9.070     0.200
     2.956   -13.457     0.200
     3.254   -14.707     0.200
     3.324   -15.621     0.200
     3.451   -17.357     0.200
     3.967   -18.411     0.200
     4.425   -23.944     0.200
     0.247    10.376     0.200
     0.371     5.461     0.200
     0.409     5.458     0.200
     0.789     2.008     0.200
     1.114    -2.095     0.200
     1.317    -1.930     0.200
     1.429    -3.392     0.200
     1.652    -4.766     0.200
     1.628    -5.501     0.200
     1.668    -4.673     0.200
     1.724    -6.647     0.200
     1.750    -5.961     0.200
     1.843    -5.509     0.200
     1.866    -7.328     0.200
     1.911    -7.565     0.200
     2.162   -11.527     0.200
     2.182    -7.755     0.200
     2.184    -8.304     0.200
     2.202    -8.184     0.200
     2.294    -9.316     0.200
     2.317    -6.721     0.200
     2.379    -8.997     0.200
     2.427    -9.617     0.200
     2.534   -11.709     0.200
     2.530   -11.183     0.200
     2.683   -13.527     0.200
     2.811   -12.693     0.200
     2.841   -12.433     0.200
     2.881   -15.225     0.200
     3.020   -16.220     0.200
     3.143   -17.214     0.200
     3.467   -17.088     0.200
     3.637   -19.772     0.200
     3.984   -21.287     0.200
     4.060   -24.279     0.200
     4.351   -25.922     0.200
     4.534   -23.908     0.200
     4.699   -26.751     0.200
     4.706   -26.553     0.200
     4.766   -29.055     0.200
     5.209   -33.398     0.200
     5.478   -36.943     0.200
     5.549   -29.482     0.200
     6.001   -40.625     0.200
     6.901   -43.340     0.200
     7.092   -48.610     0.200
     7.671   -50.251     0.200
     8.011   -57.829     0.200
     1.100    -1.393     0.200
     1.235    -1.973     0.200
     1.251    -1.587     0.200
     1.445    -3.526     0.200
     1.546    -4.325     0.200
     1.656    -3.619     0.200
     1.685    -6.247     0.200
     1.690    -4.209     0.200
     1.746    -4.288     0.200
     1.959    -7.730     0.200
     1.993    -5.008     0.200
     2.003    -7.104     0.200
     2.529   -13.883     0.200
     2.639   -11.772     0.200
     2.936   -13.202     0.200
     3.006   -12.907     0.200
     3.133   -13.843     0.200
     3.445   -15.631     0.200
     4.107   -19.623     0.200
     4.783   -24.745     0.200
     6.040   -35.702     0.200
     6.484   -34.780     0.200
     0.257     9.361     0.200
     0.373     5.591     0.200
     0.804     2.224     0.200
     1.118    -2.315     0.200
     1.382    -2.691     0.200
     1.347    -2.267     0.200
     1.582    -5.011     0.200
     1.652    -4.959     0.200
     1.627    -4.360     0.200
     1.739    -6.106     0.200
     1.742    -6.010     0.200
     1.825    -6.424     0.200
     1.810    -5.647     0.200
     2.157    -8.148     0.200
     2.200    -8.009     0.200
     2.160    -8.835     0.200
     2.248    -8.932     0.200
     2.194   -11.708     0.200
     2.332    -8.796     0.200
     2.386    -9.218     0.200
     2.529   -10.140     0.200
     2.671   -12.739     0.200
     2.820   -11.660     0.200
     2.878   -15.815     0.200
     3.011   -16.620     0.200
     3.134   -17.631     0.200
     3.384   -18.865     0.200
     3.453   -16.729     0.200
     3.631   -19.763     0.200
     4.057   -25.082     0.200
     4.343   -25.763     0.200
     4.761   -30.289     0.200
     5.206   -34.004     0.200
     5.476   -36.057     0.200
     0.186     6.900     0.200
     0.438     5.016     0.200
     0.633     1.537     0.200
     0.698     0.682     0.200
     1.046    -1.872     0.200
     1.076    -2.797     0.200
     1.146    -1.225     0.200
     1.224    -1.794     0.200
     1.334    -2.101     0.200
     1.333    -3.754     0.200
     1.416    -2.901     0.200
     1.671    -6.372     0.200
     1.780    -4.736     0.200
     1.880    -7.209     0.200
     1.908    -9.602     0.200
     2.073    -8.613     0.200
     2.119    -8.271     0.200
     2.114    -8.527     0.200
     2.163    -9.079     0.200
     2.300    -9.313     0.200
     2.584   -10.410     0.200
     3.032   -16.020     0.200
     3.153   -15.949     0.200
     3.259   -15.200     0.200
     3.385   -18.906     0.200
     3.503   -19.241     0.200
     3.628   -20.300     0.200
     3.925   -20.111     0.200
     4.564   -27.887     0.200
     0.595     3.153     0.200
     0.715     0.237     0.200
     0.721     2.140     0.200
     0.709     2.531     0.200
     0.961     1.060     0.200
     1.037    -1.076     0.200
     1.082    -1.901     0.200
     1.045     0.170     0.200
     1.064     1.678     0.200
     1.310    -1.629     0.200
     1.387    -3.573     0.200
     1.567    -4.864     0.200
     1.530    -2.901     0.200
     1.676    -7.014     0.200
     1.642    -2.545     0.200
     1.760    -5.679     0.200
     1.844    -6.750     0.200
     2.265    -9.577     0.200
     2.263    -8.028     0.200
     2.489   -14.307     0.200
     2.533    -8.597     0.200
     2.902   -14.271     0.200
     3.264   -15.073     0.200
     3.316   -17.015     0.200
     3.444   -17.465     0.200
     3.963   -21.127     0.200
     6.356   -42.195     0.200
     6.779   -37.875     0.200
     0.179     9.882     0.200
     0.255     8.484     0.200
     0.558     3.169     0.200
     1.006     0.391     0.200
     1.255    -1.530     0.200
     1.292    -3.185     0.200
     1.405    -3.876     0.200
     1.415    -2.074     0.200
     1.415    -3.105     0.200
     1.563    -4.695     0.200
     1.592    -4.598     0.200
     1.613    -4.450     0.200
     1.784    -3.978     0.200
     1.811    -6.446     0.200
     1.860    -5.704     0.200
     1.945    -8.179     0.200
     1.952    -6.299     0.200
     1.961    -6.305     0.200
     2.132    -8.114     0.200
     2.159    -8.084     0.200
     2.174    -8.332     0.200
     2.347    -8.434     0.200
     2.368    -9.900     0.200
     2.401    -9.349     0.200
     2.411   -13.863     0.200
     2.489   -10.731     0.200
     2.617   -11.090     0.200
     2.723   -13.042     0.200
     2.837   -13.873     0.200
     2.962   -15.429     0.200
     3.465   -17.870     0.200
     4.172   -23.274     0.200
     0.083     9.794     0.200
     0.355     5.447     0.200
     0.642     1.560     0.200
     1.094    -0.861     0.200
     1.157    -0.865     0.200
     1.289    -3.440     0.200
     1.297    -3.102     0.200
     1.358    -4.732     0.200
     1.380    -2.445     0.200
     1.494    -5.159     0.200
     1.668    -6.366     0.200
     1.733    -3.608     0.200
     1.864    -6.479     0.200
     1.841    -6.046     0.200
     1.866    -5.946     0.200
     1.889    -5.655     0.200
     1.943    -5.691     0.200
     2.031    -8.864     0.200
     2.035    -8.102     0.200
     2.043    -7.254     0.200
     2.431    -9.844     0.200
     2.485   -10.278     0.200
     2.517   -14.379     0.200
     2.686   -10.225     0.200
     2.911   -12.273     0.200
     5.803   -37.539     0.200
     6.278   -36.014     0.200
     0.229     8.088     0.200
     0.483     5.440     0.200
     0.714     2.403     0.200
     0.851    -0.125     0.200
     0.980    -0.218     0.200
     1.400    -3.541     0.200
     1.401    -4.373     0.200
     1.449    -3.478     0.200
     1.559    -4.872     0.200
     1.810    -6.333     0.200
     1.858    -6.166     0.200
     2.177    -8.279     0.200
     2.455   -10.574     0.200
     2.519   -10.822     0.200
     2.999   -15.934     0.200
     3.173   -16.354     0.200
     3.172   -18.518     0.200
     3.328   -19.570     0.200
     3.450   -19.609     0.200
     3.674   -20.609     0.200
     3.788   -20.031     0.200
     3.936   -22.623     0.200
     4.347   -27.547     0.200
     4.655   -28.630     0.200
     5.059   -31.144     0.200
     5.494   -35.825     0.200
     0.079     9.865     0.200
     0.643     1.496     0.200
     1.153    -1.287     0.200
     1.285    -3.570     0.200
     1.294    -3.056     0.200
     1.378    -1.693     0.200
     1.485    -4.306     0.200
     1.492    -4.312     0.200
     1.670    -5.453     0.200
     1.864    -6.598     0.200
     1.866    -5.068     0.200
     1.943    -6.812     0.200
     2.032    -7.923     0.200
     2.031    -7.726     0.200
     2.040    -6.780     0.200
     2.431   -10.195     0.200
     2.443   -10.182     0.200
     2.486   -10.335     0.200
     2.519   -13.172     0.200
     2.537   -12.032     0.200
     2.687   -11.503     0.200
     2.786   -13.750     0.200
     2.912   -14.136     0.200
     3.196   -14.445     0.200
     3.420   -15.833     0.200
     3.864   -22.330     0.200
     4.121   -20.851     0.200
     4.255   -22.207     0.200
     5.282   -30.879     0.200
     5.804   -37.414     0.200
     6.279   -36.669     0.200
     6.626   -35.764     0.200
     6.832   -43.391     0.200
     6.861   -46.015     0.200
     7.465   -51.366     0.200
     7.636   -51.572     0.200
     0.375     2.627     0.200
     0.406     2.924     0.200
     0.649     2.746     0.200
     0.773     0.989     0.200
     0.950    -1.297     0.200
     1.058    -0.524     0.200
     1.352    -4.643     0.200
     1.405    -5.536     0.200
     1.425    -3.160     0.200
     1.430    -2.724     0.200
     1.503    -3.338     0.200
     1.541    -5.438     0.200
     1.669    -6.003     0.200
     1.733    -6.550     0.200
     1.832    -6.470     0.200
     1.891    -6.455     0.200
     1.918    -5.102     0.200
     1.973    -6.932     0.200
     2.112    -6.864     0.200
     2.244   -12.741     0.200
     2.272    -8.925     0.200
     2.786   -13.309     0.200
     2.877   -11.811     0.200
     3.144   -15.567     0.200
     3.363   -17.715     0.200
     3.654   -18.215     0.200
     3.873   -19.484     0.200
     4.321   -24.080     0.200
     0.139    10.202     0.200
     0.379     7.407     0.200
     0.726     2.696     0.200
     0.738     1.620     0.200
     0.893    -0.006     0.200
     0.939    -0.134     0.200
     1.274    -2.081     0.200
     1.315    -3.958     0.200
     1.334    -2.384     0.200
     1.410    -2.990     0.200
     1.424    -3.636     0.200
     1.566    -3.438     0.200
     1.676    -4.008     0.200
     2.223   -10.344     0.200
     4.090   -20.524     0.200
     4.401   -26.200     0.200
     4.401   -25.798     0.200
     7.311   -43.642     0.200
     0.349     5.969     0.200
     0.311     8.548     0.200
     0.331     6.922     0.200
     0.708     2.872     0.200
     0.793     2.482     0.200
     1.090    -1.816     0.200
     1.323    -1.319     0.200
     1.356    -2.951     0.200
     2.646   -13.060     0.200
     4.513   -25.633     0.200
     4.635   -24.518     0.200
     6.904   -41.423     0.200
     0.307     8.431     0.200
     0.343     6.194     0.200
     0.345     6.544     0.200
     0.721     3.016     0.200
     0.785     2.180     0.200
     1.085    -1.941     0.200
     1.345    -2.356     0.200
     1.337    -1.125     0.200
     1.353    -2.017     0.200
     2.637   -12.325     0.200
     4.504   -24.800     0.200
     4.639   -23.873     0.200
     6.910   -42.571     0.200
     6.910   -41.070     0.200
     0.398     2.809     0.200
     0.595     0.663     0.200
     0.689     2.391     0.200
     0.945    -1.330     0.200
     1.247    -1.506     0.200
     1.292    -3.730     0.200
     2.547   -12.824     0.200
     4.411   -23.200     0.200
     4.459   -24.926     0.200
     0.134     9.437     0.200
     0.356     6.692     0.200
     0.614     2.014     0.200
     0.739     0.943     0.200
     0.985    -0.644     0.200
     1.148    -1.221     0.200
     1.224    -0.615     0.200
     1.262    -2.515     0.200
     1.279    -3.356     0.200
     1.489    -2.533     0.200
     2.209    -9.737     0.200
     4.071   -19.555     0.200
     4.233   -22.821     0.200
     0.284     8.537     0.200
     0.370     5.409     0.200
     0.811     2.428     0.200
     1.113    -1.630     0.200
     1.337    -2.245     0.200
     1.367    -3.189     0.200
     1.855    -6.661     0.200
     2.662   -13.135     0.200
     4.529   -23.116     0.200
     4.663   -24.170     0.200
     6.883   -43.552     0.200
     8.298   -47.403     0.200
     0.351     6.695     0.200
     0.308     8.047     0.200
     0.710     3.310     0.200
     0.795     2.521     0.200
     1.092    -1.696     0.200
     1.324    -2.059     0.200
     1.357    -2.591     0.200
     2.648   -12.712     0.200
     4.515   -23.888     0.200
     4.638   -27.311     0.200
     6.901   -40.344     0.200
     6.901   -40.544     0.200
    10.508   -67.380     0.200
    16.651  -115.618     0.200
     0.285     9.117     0.200
     0.396     5.421     0.200
     0.705     3.005     0.200
     1.135    -2.214     0.200
     1.402    -3.877     0.200
     2.694   -13.230     0.200
     4.561   -24.804     0.200
     4.667   -23.991     0.200
     6.823   -39.927     0.200
     8.579   -52.403     0.200
    17.954  -127.781     0.200
     0.331     7.332     0.200
     0.547     2.571     0.200
     0.565     2.622     0.200
     0.703     0.847     0.200
     1.049    -1.428     0.200
     1.215    -1.703     0.200
     1.405    -5.531     0.200
     1.472    -4.546     0.200
     1.582    -5.439     0.200
     1.627    -3.664     0.200
     1.896    -7.782     0.200
     3.758   -18.792     0.200
     4.421   -27.222     0.200
    10.707   -70.475     0.200
     0.151    10.002     0.200
     0.375     7.206     0.200
     0.747     1.619     0.200
     0.727     2.458     0.200
     0.929     0.133     0.200
     1.310    -3.217     0.200
     1.345    -2.537     0.200
     1.407    -3.508     0.200
     1.418    -3.051     0.200
     1.429    -3.187     0.200
     1.578    -3.239     0.200
     1.685    -4.164     0.200
     2.216   -10.152     0.200
     4.083   -21.334     0.200
     7.315   -45.800     0.200
     1.180    -2.207     0.200
     1.182    -1.859     0.200
     3.048   -12.721     0.200
     4.913   -23.219     0.200
    14.136   -94.411     0.200
     0.234     9.165     0.200
     0.429     5.078     0.200
     0.660     3.949     0.200
     0.879     1.904     0.200
     1.159    -2.172     0.200
     1.444    -4.109     0.200
     1.451    -3.629     0.200
     1.501    -3.724     0.200
     2.735   -14.144     0.200
     4.602   -23.904     0.200
     4.660   -27.147     0.200
     0.174     9.547     0.200
     0.481     6.013     0.200
     0.539     4.669     0.200
     0.608     3.487     0.200
     0.859     0.036     0.200
     0.881     0.237     0.200
     1.076    -0.637     0.200
     1.381    -2.918     0.200
     1.473    -4.733     0.200
     1.510    -3.293     0.200
     1.519    -2.972     0.200
     1.776    -4.835     0.200
     2.376   -10.042     0.200
     4.243   -21.925     0.200
     7.151   -44.125     0.200
     7.151   -43.710     0.200
     0.286     8.520     0.200
     0.363     5.676     0.200
     0.732     3.591     0.200
     0.804     2.619     0.200
     1.106    -1.877     0.200
     1.343    -3.063     0.200
     1.359    -2.772     0.200
     2.654   -13.533     0.200
     4.660   -28.923     0.200
     6.890   -40.619     0.200
     1.119    -1.945     0.200
     1.246    -3.498     0.200
     2.903   -14.815     0.200
     4.524   -23.908     0.200
     4.758   -24.124     0.200
     6.771   -37.927     0.200
     0.148    11.883     0.200
     0.543     5.456     0.200
     0.577     4.789     0.200
     0.774     2.044     0.200
     0.987     1.305     0.200
     1.096    -1.357     0.200
     1.120    -0.507     0.200
     1.223    -0.997     0.200
     1.310    -0.653     0.200
     1.347    -2.617     0.200
     1.449    -4.039     0.200
     1.678    -5.100     0.200
     1.768    -5.371     0.200
     1.911    -5.407     0.200
     3.081   -17.069     0.200
     4.751   -29.225     0.200
     4.942   -27.495     0.200
     6.550   -37.249     0.200
     0.230     8.789     0.200
     0.267     8.138     0.200
     0.406     5.312     0.200
     0.722     3.093     0.200
     0.849     2.277     0.200
     1.147    -1.282     0.200
     1.320    -2.241     0.200
     1.377    -1.842     0.200
     1.405    -3.050     0.200
     1.874    -4.998     0.200
     2.700   -13.603     0.200
     4.567   -26.084     0.200
     4.685   -26.124     0.200
     5.439   -33.231     0.200
     6.846   -41.326     0.200
     6.841   -43.971     0.200
     8.272   -48.522     0.200
    10.074   -66.666     0.200
    17.970  -128.246     0.200
     0.162    10.778     0.200
     0.305     9.539     0.200
     0.436     5.296     0.200
     0.664     3.553     0.200
     0.886     1.538     0.200
     1.167    -2.272     0.200
     1.252    -1.070     0.200
     1.457    -3.648     0.200
     1.443    -3.834     0.200
     1.848    -8.156     0.200
     2.742   -13.602     0.200
    10.005   -63.338     0.200
     0.278     8.448     0.200
     0.318     6.783     0.200
     0.348     5.530     0.200
     0.778     2.604     0.200
     1.093    -1.978     0.200
     1.321    -3.410     0.200
     1.390    -2.220     0.200
     1.872    -4.274     0.200
     2.622   -13.068     0.200
     0.253     7.457     0.200
     0.578     3.267     0.200
     0.565     4.275     0.200
     0.938    -1.031     0.200
     0.927    -0.784     0.200
     1.060    -1.015     0.200
     1.854    -6.328     0.200
     2.375   -13.108     0.200
     4.241   -21.161     0.200
     4.597   -27.046     0.200
     0.220     9.394     0.200
     0.387     5.903     0.200
     0.692     3.738     0.200
     0.834     2.340     0.200
     1.124    -2.173     0.200
     1.295    -2.090     0.200
     1.399    -3.080     0.200
     2.688   -14.137     0.200
     4.555   -22.511     0.200
     4.652   -26.616     0.200
     6.866   -41.982     0.200
     6.866   -41.778     0.200
     9.527   -69.533     0.200
    10.053   -65.926     0.200
    12.962   -87.028     0.200
     0.272     8.102     0.200
     0.342     6.360     0.200
     0.311     8.347     0.200
     0.715     3.231     0.200
     0.785     2.815     0.200
     1.084    -1.956     0.200
     1.348    -2.112     0.200
     1.346    -2.567     0.200
     2.638   -13.504     0.200
     4.504   -22.181     0.200
     6.910   -38.444     0.200
     6.910   -37.944     0.200
     6.910   -39.373     0.200
     0.160    13.146     0.200
     0.401     9.421     0.200
     0.661     4.770     0.200
     0.756     4.058     0.200
     0.943     1.731     0.200
     1.366    -2.383     0.200
     1.332    -2.516     0.200
     1.437    -2.918     0.200
     1.458    -2.907     0.200
     2.236    -9.752     0.200
     4.103   -19.835     0.200
     4.435   -26.381     0.200
     7.291   -45.395     0.200
     0.231     8.944     0.200
     0.285     8.743     0.200
     0.391     5.585     0.200
     1.131    -2.373     0.200
     1.312    -2.022     0.200
     1.395    -2.760     0.200
     4.554   -22.306     0.200
     4.554   -20.806     0.200
     4.667   -28.360     0.200
     6.862   -41.946     0.200
     6.862   -40.145     0.200
     0.392     4.311     0.200
     0.439     4.531     0.200
     0.835    -0.002     0.200
     0.818     0.123     0.200
     0.836    -0.142     0.200
     7.348   -40.380     0.200
     7.348   -40.084     0.200
    10.577   -66.434     0.200
     0.408     4.534     0.200
     0.418     4.825     0.200
     0.718     1.210     0.200
     0.784     0.415     0.200
     0.814     0.166     0.200
     0.865    -0.669     0.200
     1.161    -3.445     0.200
     1.256    -4.445     0.200
     1.483    -3.845     0.200
     1.567    -4.916     0.200
     3.977   -17.108     0.200
     7.382   -46.839     0.200
     7.382   -47.038     0.200
     0.195     9.707     0.200
     0.319     6.288     0.200
     0.427     4.133     0.200
     0.824     2.066     0.200
     0.848     1.598     0.200
     1.172    -2.853     0.200
     1.373    -3.926     0.200
     1.951    -6.204     0.200
     2.684   -13.785     0.200
     4.752   -27.353     0.200
     6.842   -41.392     0.200
     6.842   -41.591     0.200
     9.463   -66.242     0.200
     0.160    10.835     0.200
     0.311     8.441     0.200
     0.434     5.423     0.200
     0.659     3.606     0.200
     0.885     0.653     0.200
     1.164    -2.412     0.200
     1.247    -1.040     0.200
     1.457    -3.582     0.200
     2.741   -13.800     0.200
     4.607   -24.060     0.200
     4.663   -24.319     0.200
     6.822   -39.452     0.200
     9.498   -69.231     0.200
     0.203     9.342     0.200
     0.439     5.146     0.200
     0.716     2.167     0.200
     1.178    -3.089     0.200
     1.302    -2.013     0.200
     1.441    -3.601     0.200
     1.888    -5.678     0.200
     2.735   -12.344     0.200
     4.602   -24.523     0.200
     4.704   -25.734     0.200
     6.813   -43.008     0.200
     6.813   -43.110     0.200
     6.858   -41.530     0.200
     8.246   -49.535     0.200
     8.616   -50.257     0.200
     9.472   -68.252     0.200
    12.336   -85.186     0.200
    21.349  -149.007     0.200
    21.435  -148.217     0.200
     0.245    10.640     0.200
     0.318     7.919     0.200
     0.583     5.203     0.200
     0.769     3.620     0.200
     1.026    -0.543     0.200
     1.216     0.042     0.200
     1.366    -2.507     0.200
     1.456    -3.859     0.200
     1.447    -3.174     0.200
     1.704    -3.740     0.200
     2.628   -13.008     0.200
     4.492   -22.899     0.200
     4.519   -25.773     0.200
     6.957   -41.957     0.200
     6.957   -42.057     0.200
    17.819  -127.381     0.200
    20.763  -145.893     0.200
    21.258  -149.978     0.200
     0.190     9.764     0.200
     0.283     8.198     0.200
     0.427     5.036     0.200
     1.163    -2.300     0.200
     1.282    -1.651     0.200
     1.438    -3.717     0.200
     1.863    -5.690     0.200
     2.729   -13.117     0.200
     6.826   -40.195     0.200
     0.465     3.694     0.200
     0.440     3.597     0.200
     1.161    -2.379     0.200
     1.283    -3.232     0.200
     2.609   -13.568     0.200
     4.473   -23.670     0.200
     4.798   -27.977     0.200
     0.267     8.322     0.200
     0.344     6.283     0.200
     0.314     7.935     0.200
     1.085    -1.311     0.200
     1.350    -2.917     0.200
     2.640   -13.225     0.200
     4.507   -24.100     0.200
     4.633   -24.884     0.200
     6.909   -42.133     0.200
     6.909   -42.032     0.200
    13.000   -88.132     0.200
    21.298  -153.460     0.200
    21.807  -151.294     0.200
     0.272     7.928     0.200
     0.368     5.390     0.200
     0.807     2.277     0.200
     1.112    -1.984     0.200
     1.349    -1.208     0.200
     1.359    -3.236     0.200
     2.656   -12.741     0.200
     4.523   -22.923     0.200
     4.668   -25.509     0.200
     6.826   -39.923     0.200
     6.886   -41.824     0.200
     6.886   -40.824     0.200
     8.310   -47.960     0.200
     9.530   -68.899     0.200
    12.259   -82.258     0.200
    18.661  -132.193     0.200
     0.642     1.814     0.200
     2.858   -13.442     0.200
     4.724   -22.587     0.200
     0.271     8.212     0.200
     0.392     7.152     0.200
     0.646     3.805     0.200
     1.027    -1.275     0.200
     1.332    -3.442     0.200
     1.747    -4.451     0.200
     2.607   -12.059     0.200
     4.473   -22.200     0.200
     4.555   -25.210     0.200
     6.959   -41.924     0.200
     6.959   -40.024     0.200
    21.813  -152.873     0.200
     0.126    11.492     0.200
     0.274     8.298     0.200
     0.554     2.728     0.200
     0.697     3.002     0.200
     1.003     0.204     0.200
     1.237    -2.015     0.200
     1.284    -2.929     0.200
     1.390    -3.781     0.200
     1.407    -3.602     0.200
     1.933    -5.340     0.200
     2.858   -15.388     0.200
     4.761   -25.429     0.200
     9.383   -68.906     0.200
     0.256     8.570     0.200
     0.367     5.548     0.200
     0.292     9.221     0.200
     0.719     3.186     0.200
     0.810     2.016     0.200
     1.109    -2.064     0.200
     1.368    -2.791     0.200
     2.661   -13.583     0.200
     4.528   -24.262     0.200
     4.655   -28.287     0.200
     6.886   -42.593     0.200
     6.886   -42.993     0.200
    10.518   -69.638     0.200
    12.998   -89.541     0.200
    21.791  -154.509     0.200
     0.271     7.896     0.200
     0.281     8.375     0.200
     0.282     8.568     0.200
     0.366     5.688     0.200
     0.806     1.854     0.200
     1.110    -1.875     0.200
     1.359    -2.988     0.200
     2.655   -13.575     0.200
     4.522   -25.757     0.200
     4.665   -25.275     0.200
     6.823   -42.689     0.200
     6.888   -41.246     0.200
     6.888   -40.746     0.200
     9.533   -69.644     0.200
    10.106   -65.766     0.200
    10.535   -64.877     0.200
    13.015   -86.880     0.200
    16.662  -113.594     0.200
    21.379  -148.733     0.200
     0.221     9.082     0.200
     0.284     8.505     0.200
     0.399     5.231     0.200
     1.305    -1.272     0.200
     1.406    -3.665     0.200
     2.697   -13.619     0.200
     4.564   -25.498     0.200
     4.670   -26.147     0.200
    14.477   -96.540     0.200
    20.729  -147.305     0.200
    21.397  -148.191     0.200
     0.268     8.225     0.200
     0.304     8.076     0.200
     0.350     6.012     0.200
     0.718     3.046     0.200
     0.793     2.578     0.200
     1.092    -2.309     0.200
     1.333    -3.130     0.200
     1.353    -2.762     0.200
     2.645   -12.027     0.200
     4.512   -25.705     0.200
     4.642   -25.050     0.200
     0.156    10.782     0.200
     0.421     5.674     0.200
     0.633     4.739     0.200
     0.872     2.261     0.200
     1.145    -2.394     0.200
     1.228    -0.299     0.200
     1.451    -4.087     0.200
     1.815    -8.112     0.200
     2.730   -15.036     0.200
     4.596   -26.680     0.200
     4.636   -24.033     0.200
     6.839   -38.789     0.200
     6.839   -38.389     0.200
    12.892   -88.576     0.200
     0.263     8.695     0.200
     0.219     9.000     0.200
     0.419     5.063     0.200
     0.719     2.344     0.200
     0.862     1.906     0.200
     1.159    -2.504     0.200
     1.312    -1.555     0.200
     1.878    -5.106     0.200
     2.714   -15.287     0.200
     0.266     8.920     0.200
     0.298     9.093     0.200
     0.716     3.461     0.200
     0.973    -0.285     0.200
     1.237    -1.154     0.200
     1.317    -3.393     0.200
     1.411    -3.489     0.200
     1.671    -3.813     0.200
     7.011   -39.209     0.200
     7.011   -39.505     0.200
     0.383     5.070     0.200
     1.118    -2.005     0.200
     1.278    -1.782     0.200
     1.403    -3.247     0.200
     2.688   -14.289     0.200
     4.554   -25.952     0.200
     4.637   -27.084     0.200
     9.537   -68.406     0.200
    10.037   -62.051     0.200
    12.946   -87.183     0.200
    21.287  -152.492     0.200
     0.301     8.866     0.200
     0.283     7.731     0.200
     0.343     6.428     0.200
     0.731     3.226     0.200
     1.087    -1.635     0.200
     1.340    -1.953     0.200
     1.348    -1.314     0.200
     2.634   -11.480     0.200
     4.501   -25.762     0.200
     4.645   -23.826     0.200
     6.910   -38.951     0.200
     6.910   -39.435     0.200
     0.304    10.704     0.200
     0.423     5.548     0.200
     0.671     3.482     0.200
     1.156    -2.078     0.200
     1.263    -1.986     0.200
     2.728   -13.419     0.200
     4.594   -25.981     0.200
     4.664   -25.681     0.200
     6.832   -39.007     0.200
     6.832   -39.406     0.200
     8.329   -48.061     0.200
    10.018   -62.105     0.200
    12.924   -85.435     0.200
     0.200     9.423     0.200
     0.281     8.556     0.200
     0.419     5.468     0.200
     0.866     1.515     0.200
     1.157    -2.708     0.200
     1.863    -5.302     0.200
     2.720   -12.844     0.200
     4.586   -25.819     0.200
     0.224     8.858     0.200
     0.281     9.030     0.200
     0.400     5.388     0.200
     0.709     2.183     0.200
     0.844     2.190     0.200
     1.139    -2.863     0.200
     1.308    -2.316     0.200
     1.404    -4.267     0.200
     2.697   -13.037     0.200
     0.257     8.200     0.200
     0.330     7.696     0.200
     0.386     6.994     0.200
     0.387     7.666     0.200
     0.703     3.160     0.200
     0.998    -0.796     0.200
     1.275    -2.276     0.200
     1.340    -1.324     0.200
     2.558   -10.753     0.200
     4.425   -24.816     0.200
     4.560   -23.116     0.200
     6.995   -39.309     0.200
     6.995   -42.558     0.200
     0.258     7.910     0.200
     0.366     5.091     0.200
     0.293     8.263     0.200
     0.721     3.243     0.200
     0.808     2.368     0.200
     1.108    -1.928     0.200
     1.331    -2.089     0.200
     1.366    -4.126     0.200
     1.848    -8.642     0.200
     2.660   -12.325     0.200
     6.887   -40.427     0.200
     6.887   -41.200     0.200
    16.649  -115.086     0.200
    18.643  -133.690     0.200
     0.312     7.608     0.200
     0.285     7.475     0.200
     0.531     3.270     0.200
     0.683     4.731     0.200
     0.917     1.233     0.200
     0.934     0.708     0.200
     0.972     1.691     0.200
     1.092    -1.814     0.200
     1.193    -2.393     0.200
     1.292    -1.156     0.200
     1.341     0.091     0.200
     1.384    -3.748     0.200
     2.761   -13.106     0.200
     0.177    10.141     0.200
     0.441     4.977     0.200
     1.176    -2.730     0.200
     2.743   -14.603     0.200
     6.812   -40.076     0.200
     0.188     9.704     0.200
     0.189    10.403     0.200
     0.312     6.278     0.200
     0.437     4.000     0.200
     0.822     1.383     0.200
     0.859     1.329     0.200
     1.181    -1.992     0.200
     1.384    -4.413     0.200
     1.956    -5.442     0.200
     2.695   -13.470     0.200
     4.562   -26.842     0.200
     4.758   -25.684     0.200
     6.831   -42.379     0.200
     8.477   -49.863     0.200
    13.066   -86.838     0.200
    16.686  -116.102     0.200
     0.343     5.719     0.200
     0.561     3.885     0.200
     0.509     2.963     0.200
     0.682     1.875     0.200
     0.944    -0.239     0.200
     0.994    -1.014     0.200
     1.452    -5.741     0.200
     1.926    -5.969     0.200
     2.322   -11.040     0.200
     4.644   -28.519     0.200
     7.177   -42.239     0.200
     8.607   -53.451     0.200
    10.476   -64.607     0.200
    13.399   -90.277     0.200
    22.207  -155.265     0.200
     0.128    11.542     0.200
     0.273     8.719     0.200
     0.554     3.518     0.200
     1.003     0.195     0.200
     1.238    -1.665     0.200
     1.391    -3.214     0.200
     1.407    -3.520     0.200
     1.935    -4.938     0.200
     2.858   -14.696     0.200
     0.235     8.696     0.200
     0.378     5.748     0.200
     0.297     8.596     0.200
     0.703     3.252     0.200
     1.118    -2.296     0.200
     1.309    -1.459     0.200
     1.386    -3.196     0.200
     2.677   -13.115     0.200
     4.544   -26.790     0.200
     0.290     8.509     0.200
     0.390     5.861     0.200
     0.835     1.851     0.200
     1.129    -2.381     0.200
     2.688   -12.595     0.200
     4.555   -26.771     0.200
     4.663   -27.798     0.200
     4.663   -24.189     0.200
     6.862   -38.704     0.200
     6.862   -39.805     0.200
     8.358   -50.829     0.200
     9.520   -69.194     0.200
    14.482   -96.366     0.200
     0.307     7.139     0.200
     0.356     6.003     0.200
     0.769     2.205     0.200
     0.787     2.421     0.200
     1.101    -2.106     0.200
     1.332    -2.531     0.200
     1.383    -1.951     0.200
     1.399    -2.354     0.200
     1.873    -5.608     0.200
     2.633   -12.673     0.200
     4.500   -24.756     0.200
     6.903   -39.450     0.200
     0.291     8.662     0.200
     0.291     8.440     0.200
     0.428     5.296     0.200
     0.683     3.217     0.200
     1.163    -2.894     0.200
     1.858    -5.566     0.200
     2.731   -12.909     0.200
     4.598   -23.578     0.200
     6.825   -41.687     0.200
     0.139    10.303     0.200
     0.461     5.797     0.200
     0.572     5.093     0.200
     0.762     1.764     0.200
     0.883     0.836     0.200
     1.142    -1.991     0.200
     1.717    -4.733     0.200
     2.425   -11.049     0.200
     4.291   -23.322     0.200
     7.122   -42.844     0.200
     0.190     9.015     0.200
     0.433     4.403     0.200
     1.170    -2.655     0.200
     1.871    -7.523     0.200
     9.483   -68.134     0.200
     0.189     8.464     0.200
     0.451     5.158     0.200
     0.640     1.791     0.200
     0.813     0.711     0.200
     0.929    -1.695     0.200
     0.971    -0.914     0.200
     1.377    -4.994     0.200
     1.407    -3.043     0.200
     2.275   -10.334     0.200
     4.141   -22.213     0.200
     7.245   -44.005     0.200
     0.345     6.229     0.200
     0.266     8.244     0.200
     0.313     8.547     0.200
     0.314     7.802     0.200
     0.710     3.348     0.200
     0.789     2.155     0.200
     1.086    -1.867     0.200
     2.642   -10.885     0.200
     4.509   -23.459     0.200
     4.634   -25.030     0.200
     6.907   -37.606     0.200
     6.907   -39.114     0.200
    10.088   -65.034     0.200
     0.360     4.802     0.200
     0.509     4.377     0.200
     0.572     3.472     0.200
     0.956    -1.206     0.200
     1.457    -6.096     0.200
     1.942    -7.419     0.200
     7.174   -42.708     0.200
     0.305     7.982     0.200
     0.793     2.794     0.200
     1.093    -1.689     0.200
     2.645   -11.015     0.200
     4.512   -23.792     0.200
     4.642   -24.317     0.200
     6.902   -41.496     0.200
     6.902   -39.746     0.200
     0.160    10.711     0.200
     0.320     8.605     0.200
     0.428     5.511     0.200
     0.652     4.326     0.200
     0.879     2.226     0.200
     1.157    -1.683     0.200
     1.242    -0.203     0.200
     1.453    -3.275     0.200
     1.833    -4.887     0.200
     2.736   -13.143     0.200
     4.602   -23.198     0.200
     4.654   -24.837     0.200
     6.829   -40.002     0.200
    21.290  -150.023     0.200
     0.221     9.045     0.200
     0.255     9.091     0.200
     0.425     5.088     0.200
     0.726     2.334     0.200
     0.868     1.760     0.200
     1.166    -2.702     0.200
     1.318    -1.506     0.200
     1.887    -3.887     0.200
     2.718   -12.107     0.200
     0.202     9.040     0.200
     0.198     9.645     0.200
     0.554     3.177     0.200
     0.768     2.278     0.200
     0.995     0.601     0.200
     1.295    -3.599     0.200
     1.985    -6.998     0.200
     2.842   -12.857     0.200
     4.709   -24.741     0.200
     4.808   -25.859     0.200
     6.699   -37.111     0.200
    12.933   -87.031     0.200
     0.091     9.130     0.200
     0.365     5.445     0.200
     0.649     1.146     0.200
     0.657     0.793     0.200
     0.978    -1.086     0.200
     1.299    -4.285     0.200
     1.554    -4.543     0.200
     2.224    -8.180     0.200
     4.088   -19.179     0.200
     0.453     4.351     0.200
     0.462     4.557     0.200
     0.715     2.428     0.200
     0.831     0.049     0.200
     0.938    -0.920     0.200
     0.947    -0.220     0.200
     1.161    -0.199     0.200
     1.265    -2.687     0.200
     1.364    -3.542     0.200
     1.432    -1.893     0.200
     1.526    -5.173     0.200
     1.802    -6.404     0.200
     3.198   -13.869     0.200
     5.047   -26.682     0.200
    11.997   -75.487     0.200
     1.138     0.058     0.200
     1.823    -3.763     0.200
     4.591   -23.188     0.200
     6.452   -35.288     0.200
    11.672   -68.984     0.200
    11.915   -73.757     0.200
    19.279  -133.815     0.200
     0.251     7.134     0.200
     0.447     5.320     0.200
     0.692     1.247     0.200
     0.823     0.686     0.200
     0.930    -0.607     0.200
     0.994    -2.020     0.200
     1.357    -4.641     0.200
     1.504    -4.295     0.200
     2.244    -9.759     0.200
     2.244    -9.657     0.200
     0.222     8.960     0.200
     0.284     9.283     0.200
     0.399     5.527     0.200
     0.844     2.120     0.200
     1.139    -2.205     0.200
     1.305    -0.993     0.200
     1.858    -8.953     0.200
     1.858    -6.801     0.200
     2.697   -12.019     0.200
     4.670   -25.759     0.200
     0.122     7.575     0.200
     0.513     2.872     0.200
     0.559     2.016     0.200
     0.677     0.979     0.200
     1.034    -0.339     0.200
     1.127    -1.389     0.200
     1.175    -2.612     0.200
     1.281    -3.180     0.200
     1.361    -5.089     0.200
     1.870    -5.334     0.200
     2.985   -15.987     0.200
     2.985   -14.088     0.200
     4.848   -24.238     0.200
     6.631   -38.565     0.200
     0.154    10.126     0.200
     0.244     8.750     0.200
     0.367     5.464     0.200
     0.303     8.494     0.200
     0.704     2.883     0.200
     0.812     2.254     0.200
     1.107    -2.388     0.200
     1.153    -1.858     0.200
     1.313    -1.644     0.200
     1.375    -3.690     0.200
     1.837    -6.729     0.200
     2.665   -12.996     0.200
     3.157   -17.498     0.200
     4.532   -23.670     0.200
     4.532   -24.170     0.200
     4.646   -27.284     0.200
     5.947   -36.524     0.200
     6.885   -41.174     0.200
     6.885   -38.775     0.200
    12.983   -88.280     0.200
    16.635  -114.434     0.200
     0.330     7.501     0.200
     0.703     3.782     0.200
     0.998    -0.572     0.200
     1.275    -2.553     0.200
     1.763    -4.845     0.200
     2.558   -10.830     0.200
     4.424   -22.393     0.200
     0.195     9.662     0.200
     0.283     8.481     0.200
     0.283     9.457     0.200
     0.423     5.323     0.200
     0.694     3.432     0.200
     0.870     2.055     0.200
     1.160    -2.727     0.200
     1.286    -1.625     0.200
     1.863    -7.266     0.200
     2.724   -13.310     0.200
     4.591   -21.982     0.200
     4.679   -24.192     0.200
     6.833   -40.574     0.200
     8.351   -50.196     0.200
     0.411     4.972     0.200
     0.858     1.692     0.200
     1.147    -2.474     0.200
     1.423    -4.315     0.200
     2.712   -13.092     0.200
     3.206   -19.025     0.200
     4.579   -22.763     0.200
     4.668   -27.473     0.200
     6.822   -42.373     0.200
     6.842   -40.610     0.200
    10.041   -64.699     0.200
    12.947   -86.144     0.200
    16.591  -114.951     0.200
    18.625  -133.621     0.200
    21.315  -149.791     0.200
     0.349     5.370     0.200
     0.536     3.429     0.200
     0.879     0.068     0.200
     0.951    -0.003     0.200
     0.998    -0.017     0.200
     1.260    -1.805     0.200
     1.264    -2.436     0.200
     1.517    -5.347     0.200
     1.885    -6.538     0.200
     3.170   -14.367     0.200
     5.027   -25.232     0.200
     0.680     2.378     0.200
     1.484    -2.848     0.200
     1.535    -2.037     0.200
     0.286     8.064     0.200
     0.274     7.554     0.200
     0.360     5.627     0.200
     0.800     2.490     0.200
     1.104    -1.937     0.200
     1.165    -1.868     0.200
     1.347    -2.254     0.200
     1.354    -3.276     0.200
     2.650   -12.747     0.200
     4.517   -24.229     0.200
     4.517   -24.128     0.200
     4.659   -27.362     0.200
     0.154    10.932     0.200
     0.433     4.782     0.200
     0.648     4.254     0.200
     1.161    -2.183     0.200
     1.834    -6.619     0.200
     2.741   -13.383     0.200
     3.241   -18.125     0.200
     4.607   -23.635     0.200
     4.654   -26.239     0.200
     6.825   -42.438     0.200
     9.992   -63.432     0.200
    12.552   -79.001     0.200
    12.552   -79.004     0.200
    12.898   -86.872     0.200
    21.290  -151.072     0.200
     0.510     2.220     0.200
     0.648     1.341     0.200
     2.951   -11.849     0.200
     3.476   -19.892     0.200
     4.812   -24.542     0.200
     9.435   -65.189     0.200
     0.271     8.247     0.200
     0.303     7.933     0.200
     0.350     6.241     0.200
     0.722     2.850     0.200
     0.792     2.130     0.200
     1.092    -1.891     0.200
     1.350    -2.580     0.200
     1.336    -1.129     0.200
     1.356    -2.258     0.200
     2.643   -11.664     0.200
     3.133   -17.894     0.200
     4.510   -23.342     0.200
     6.903   -38.596     0.200
     0.687     2.418     0.200
     2.288    -7.848     0.200
     2.822   -13.949     0.200
     4.150   -17.771     0.200
     4.277   -21.281     0.200
     7.300   -43.603     0.200
    13.077   -83.561     0.200
     4.915   -21.993     0.200
     6.580   -35.464     0.200
     3.068    -9.677     0.200
     4.932   -23.660     0.200
     9.737   -59.405     0.200
    12.624   -78.693     0.200
    14.108   -87.435     0.200
    16.222  -104.067     0.200
    18.538  -123.985     0.200
    21.326  -147.265     0.200
     1.917    -3.912     0.200
     3.020   -10.612     0.200
     3.531   -17.428     0.200
     4.757   -20.703     0.200
     6.587   -38.013     0.200
     0.303     6.739     0.200
     0.310     6.402     0.200
     0.500     3.088     0.200
     0.906     0.636     0.200
     0.948     0.183     0.200
     1.071    -1.403     0.200
     1.224    -3.244     0.200
     1.294    -0.870     0.200
     1.538    -2.815     0.200
     2.375   -10.730     0.200
     2.659   -12.651     0.200
     2.701   -10.568     0.200
     2.736   -12.189     0.200
     3.292   -20.696     0.200
     4.587   -24.180     0.200
     0.128    11.623     0.200
     0.546     3.683     0.200
     1.396    -3.765     0.200
     1.415    -3.849     0.200
     2.849   -13.330     0.200
     3.340   -20.086     0.200
     4.716   -24.201     0.200
     0.270     8.181     0.200
     0.352     6.182     0.200
     0.794     2.675     0.200
     1.094    -1.750     0.200
     1.352    -3.023     0.200
     2.267    -9.720     0.200
     2.267    -9.419     0.200
     2.569   -10.292     0.200
     2.617   -11.826     0.200
     2.617   -11.525     0.200
     2.645   -12.714     0.200
     2.645   -12.613     0.200
     4.512   -23.995     0.200
     4.512   -23.194     0.200
     4.646   -25.346     0.200
     4.646   -24.046     0.200
     6.901   -42.126     0.200
     0.240    10.785     0.200
     0.280     8.939     0.200
     0.325     7.813     0.200
     0.386     8.867     0.200
     0.451     8.562     0.200
     0.566     5.467     0.200
     0.774     3.255     0.200
     1.026    -0.722     0.200
     1.024    -0.351     0.200
     1.196     1.405     0.200
     1.199     0.390     0.200
     1.375    -3.181     0.200
     1.441    -3.081     0.200
     1.556    -4.320     0.200
     1.692    -4.468     0.200
     2.159    -6.828     0.200
     2.260    -9.653     0.200
     2.260    -9.454     0.200
     2.556   -12.027     0.200
     2.556   -11.427     0.200
     2.602   -10.475     0.200
     2.602    -9.674     0.200
     2.633   -11.462     0.200
     2.633   -10.962     0.200
     3.152   -16.904     0.200
     3.152   -16.205     0.200
     4.497   -22.536     0.200
     4.497   -22.136     0.200
     4.509   -25.834     0.200
     6.958   -42.350     0.200
     8.422   -52.564     0.200
     9.967   -64.159     0.200
    10.820   -68.993     0.200
    12.887   -87.221     0.200
     0.188    10.185     0.200
     0.389     5.615     0.200
     1.117    -2.064     0.200
     2.621   -12.540     0.200
     2.669   -11.936     0.200
     2.698   -13.668     0.200
     3.200   -18.073     0.200
     4.564   -24.017     0.200
     4.622   -23.453     0.200
     5.364   -33.388     0.200
     6.868   -42.378     0.200
     6.868   -39.468     0.200
     6.868   -39.730     0.200
    12.567   -81.245     0.200
    21.266  -148.370     0.200
     0.162     9.388     0.200
     0.382     6.122     0.200
     1.384    -2.830     0.200
     2.299    -9.236     0.200
     2.601   -10.706     0.200
     2.649   -10.540     0.200
     2.677   -10.929     0.200
     3.166   -15.641     0.200
     4.544   -20.908     0.200
     4.665   -26.349     0.200
     5.439   -33.380     0.200
     7.302   -45.896     0.200
     8.577   -49.950     0.200
    12.988   -86.598     0.200
    14.499   -97.976     0.200
    15.554  -105.944     0.200
    16.634  -112.374     0.200
    23.232  -171.532     0.200
     0.164     9.395     0.200
     0.241     8.257     0.200
     0.283     8.437     0.200
     0.384     5.219     0.200
     0.468     5.981     0.200
     0.717     2.978     0.200
     0.828     2.066     0.200
     1.126    -2.374     0.200
     1.321    -1.174     0.200
     1.386    -3.738     0.200
     1.857    -5.471     0.200
     2.603   -12.113     0.200
     2.651   -10.951     0.200
     2.680   -11.840     0.200
     3.169   -16.447     0.200
     4.546   -23.214     0.200
     0.163    11.033     0.200
     0.242     8.830     0.200
     0.432     5.512     0.200
     0.662     3.532     0.200
     0.882     2.048     0.200
     1.163    -2.546     0.200
     1.454    -4.269     0.200
     2.362   -10.158     0.200
     2.662   -12.374     0.200
     2.710   -11.781     0.200
     2.739   -12.501     0.200
     3.236   -18.271     0.200
     4.605   -23.961     0.200
     0.579     0.873     0.200
     1.158    -1.581     0.200
     1.445    -2.812     0.200
     2.398    -9.506     0.200
     2.677   -11.525     0.200
     2.753   -11.357     0.200
     4.284   -21.795     0.200
     4.596   -22.355     0.200
     0.136    10.247     0.200
     0.792     2.252     0.200
     1.093    -2.001     0.200
     1.350    -2.821     0.200
     2.265    -9.232     0.200
     2.567   -11.706     0.200
     2.615   -10.139     0.200
     2.643   -10.729     0.200
     3.132   -17.335     0.200
     4.510   -23.108     0.200
     0.337     9.001     0.200
     0.376     8.177     0.200
     0.458     8.276     0.200
     0.765     2.841     0.200
     0.848     2.414     0.200
     0.881     2.265     0.200
     1.082    -0.903     0.200
     1.211    -1.193     0.200
     1.337    -2.868     0.200
     1.525    -3.264     0.200
     1.585    -4.249     0.200
     1.823    -6.297     0.200
     1.823    -6.000     0.200
     2.132    -9.295     0.200
     2.132    -8.998     0.200
     2.185    -8.954     0.200
     2.185    -8.251     0.200
     2.207    -9.677     0.200
     2.207    -9.177     0.200
     2.658   -14.963     0.200
     2.658   -14.463     0.200
     4.071   -22.759     0.200
     4.071   -20.556     0.200
     0.198    12.129     0.200
     0.246     8.689     0.200
     0.213     9.634     0.200
     0.510     4.411     0.200
     0.765     2.742     0.200
     1.327    -2.064     0.200
     2.417    -9.621     0.200
     2.720   -12.141     0.200
     2.769   -11.096     0.200
     2.797   -12.659     0.200
     3.275   -18.733     0.200
     4.664   -25.043     0.200
     4.779   -25.598     0.200
     6.743   -41.956     0.200
     0.234     9.012     0.200
     0.414     5.922     0.200
     0.656     3.645     0.200
     1.143    -2.319     0.200
     1.828    -8.252     0.200
     2.344    -9.381     0.200
     2.644   -11.787     0.200
     2.721   -12.215     0.200
     3.220   -18.033     0.200
     4.587   -23.871     0.200
     0.134     9.591     0.200
     0.313     6.507     0.200
     0.436     4.117     0.200
     1.955    -6.781     0.200
     2.312   -11.256     0.200
     2.617   -12.933     0.200
     2.617   -12.532     0.200
     2.667   -12.819     0.200
     2.667   -13.418     0.200
     2.693   -13.342     0.200
     4.560   -25.518     0.200
     4.560   -21.418     0.200
     0.146    11.046     0.200
     0.260     8.125     0.200
     0.318     9.233     0.200
     0.444     4.886     0.200
     0.376     8.053     0.200
     1.172    -2.276     0.200
     1.235    -0.182     0.200
     1.469    -4.304     0.200
     1.841    -8.301     0.200
     4.618   -23.130     0.200
     4.663   -24.948     0.200
     6.814   -39.565     0.200
     6.814   -39.325     0.200
     6.814   -39.564     0.200
     9.988   -64.542     0.200
    12.893   -87.351     0.200
    15.037  -102.908     0.200
     0.400     5.368     0.200
     2.252   -11.920     0.200
     2.624   -12.630     0.200
     2.672   -11.153     0.200
     2.701   -12.554     0.200
     2.701   -13.154     0.200
     4.567   -23.527     0.200
     4.567   -26.326     0.200
     4.664   -24.402     0.200
     6.852   -40.254     0.200
     9.513   -67.483     0.200
     9.514   -69.829     0.200
    12.958   -87.823     0.200
     0.192     9.669     0.200
     0.217     8.864     0.200
     0.441     4.966     0.200
     0.705     2.185     0.200
     0.887     1.835     0.200
     1.179    -2.521     0.200
     1.880    -5.633     0.200
     1.881    -5.665     0.200
     2.288   -12.370     0.200
     2.663   -12.381     0.200
     2.663   -13.281     0.200
     2.712   -11.709     0.200
     2.712   -12.809     0.200
     2.740   -13.404     0.200
     2.740   -13.704     0.200
     4.607   -23.880     0.200
     4.607   -26.880     0.200
     0.167     9.831     0.200
     0.239     8.624     0.200
     0.399     5.256     0.200
     0.470     5.997     0.200
     0.727     3.269     0.200
     0.841     2.151     0.200
     0.922     2.082     0.200
     1.141    -2.555     0.200
     1.327    -2.141     0.200
     1.396    -3.245     0.200
     2.237   -11.591     0.200
     2.615   -12.496     0.200
     2.664   -10.034     0.200
     2.692   -12.616     0.200
     4.559   -22.598     0.200
     0.100     9.642     0.200
     0.245     5.746     0.200
     1.039    -1.927     0.200
     1.195    -1.871     0.200
     1.121    -1.924     0.200
     1.214    -1.658     0.200
     1.805    -6.683     0.200
     1.806    -6.698     0.200
     2.648   -14.917     0.200
     2.678   -12.279     0.200
     2.678   -12.978     0.200
     2.968   -14.673     0.200
     2.968   -15.173     0.200
     3.045   -14.712     0.200
     3.045   -15.611     0.200
     4.902   -24.885     0.200
     4.902   -26.486     0.200
     6.622   -43.094     0.200
     6.624   -38.952     0.200
     8.134   -52.998     0.200
     9.414   -68.968     0.200
    12.181   -75.806     0.200
     0.130    11.261     0.200
     0.328     6.881     0.200
     0.377     7.044     0.200
     0.555     3.377     0.200
     1.004     0.459     0.200
     1.286    -3.300     0.200
     1.393    -3.473     0.200
     1.408    -3.153     0.200
     1.936    -5.266     0.200
     1.937    -5.293     0.200
     2.406   -12.499     0.200
     2.480   -11.851     0.200
     2.858   -14.527     0.200
     0.187     9.319     0.200
     0.219     8.817     0.200
     0.408     5.201     0.200
     0.853     1.807     0.200
     1.148    -2.442     0.200
     1.412    -3.426     0.200
     2.253   -11.682     0.200
     2.327    -9.725     0.200
     2.629   -12.892     0.200
     2.705   -12.615     0.200
     3.195   -18.940     0.200
     4.572   -26.392     0.200
     0.353     3.383     0.200
     0.559     1.457     0.200
     0.597     1.256     0.200
     0.915     1.063     0.200
     1.141    -2.797     0.200
     1.653    -2.979     0.200
     1.652    -2.987     0.200
     2.483   -14.627     0.200
     2.501   -11.107     0.200
     2.789   -12.618     0.200
     2.866   -13.155     0.200
     3.412   -20.066     0.200
     4.720   -23.344     0.200
     4.720   -25.242     0.200
     0.131    10.899     0.200
     0.294     8.823     0.200
     0.295     8.187     0.200
     0.277     7.661     0.200
     0.352     6.177     0.200
     0.792     2.633     0.200
     1.095    -2.077     0.200
     1.348    -2.285     0.200
     1.847    -3.306     0.200
     2.189   -11.837     0.200
     2.189   -10.939     0.200
     2.264   -10.224     0.200
     2.264    -9.724     0.200
     2.566   -11.805     0.200
     2.566   -11.204     0.200
     2.643   -13.226     0.200
     2.643   -12.328     0.200
     3.131   -18.698     0.200
     3.131   -17.799     0.200
     4.510   -23.407     0.200
     4.652   -24.911     0.200
     4.652   -24.708     0.200
     6.901   -41.523     0.200
     0.335     5.806     0.200
     0.447     3.850     0.200
     0.617     5.076     0.200
     0.847     1.185     0.200
     1.013    -0.774     0.200
     0.990    -0.149     0.200
     1.187    -0.405     0.200
     1.277    -3.657     0.200
     1.362    -0.828     0.200
     1.511    -3.941     0.200
     2.309   -13.664     0.200
     2.315   -10.856     0.200
     2.600   -11.882     0.200
     2.677   -13.018     0.200
     3.232   -18.832     0.200
     4.529   -26.520     0.200
     0.555     0.965     0.200
     0.668     0.205     0.200
     1.005    -1.498     0.200
     1.037     0.286     0.200
     1.137    -1.152     0.200
     1.377    -3.150     0.200
     2.337   -10.300     0.200
     2.337    -9.699     0.200
     2.357   -12.358     0.200
     2.357   -13.264     0.200
     2.612   -10.743     0.200
     2.689   -10.467     0.200
     4.215   -20.753     0.200
     4.215   -24.855     0.200
     4.528   -22.563     0.200
     4.528   -20.860     0.200
     8.127   -47.956     0.200
     0.216     4.566     0.200
     0.539     1.517     0.200
     0.661     0.050     0.200
     0.891     0.758     0.200
     0.983    -1.360     0.200
     1.124    -1.222     0.200
     2.315   -10.260     0.200
     2.315    -9.760     0.200
     2.336   -12.937     0.200
     2.336   -13.039     0.200
     2.590   -11.998     0.200
     2.590   -11.197     0.200
     2.667   -12.425     0.200
     2.667   -12.324     0.200
     4.506   -24.720     0.200
     4.506   -21.521     0.200
     0.227    12.456     0.200
     0.316    10.532     0.200
     0.436     9.836     0.200
     0.593     7.235     0.200
     0.681     4.868     0.200
     0.808     3.948     0.200
     0.935     2.019     0.200
     1.274    -1.237     0.200
     1.353    -2.330     0.200
     1.489    -2.843     0.200
     1.523    -3.224     0.200
     1.518    -2.682     0.200
     1.784    -4.715     0.200
     1.785    -4.766     0.200
     1.862    -6.084     0.200
     2.168    -8.782     0.200
     2.244    -8.886     0.200
     4.111   -22.252     0.200
     4.501   -26.015     0.200
     4.501   -26.376     0.200
     6.673   -43.270     0.200
     7.270   -44.308     0.200
     1.735    -1.659     0.200
     3.545   -11.815     0.200
     4.446   -20.366     0.200
     5.349   -24.280     0.200
     6.484   -34.356     0.200
     6.546   -30.140     0.200
     7.044   -41.462     0.200
     8.298   -45.888     0.200
     8.806   -51.894     0.200
     9.563   -61.885     0.200
    12.378   -75.907     0.200
    12.915   -82.543     0.200
    13.245   -80.408     0.200
    15.438  -103.110     0.200
    15.534  -103.360     0.200
    19.789  -126.742     0.200
    20.745  -140.938     0.200
     0.157     9.829     0.200
     0.256     8.469     0.200
     0.351     6.051     0.200
     0.796     2.645     0.200
     1.092    -1.715     0.200
     1.360    -3.022     0.200
     2.573   -11.484     0.200
     2.573   -11.984     0.200
     2.650   -11.508     0.200
     4.516   -24.282     0.200
     4.516   -23.682     0.200
     0.541     3.632     0.200
     0.571     2.086     0.200
     0.713     1.192     0.200
     0.704     1.482     0.200
     0.871     0.376     0.200
     0.961     0.139     0.200
     1.032    -1.912     0.200
     1.312    -4.502     0.200
     1.335    -2.310     0.200
     1.374    -5.365     0.200
     1.381    -5.784     0.200
     1.474    -3.614     0.200
     1.489    -5.310     0.200
     1.489    -4.607     0.200
     1.800    -7.260     0.200
     1.874    -6.520     0.200
     3.735   -19.213     0.200
     3.735   -18.010     0.200
     4.418   -25.661     0.200
     0.235     4.449     0.200
     0.674     0.316     0.200
     0.850     1.265     0.200
     1.328    -1.537     0.200
     1.329    -1.650     0.200
     1.603    -5.236     0.200
     2.279    -8.063     0.200
     2.285    -4.627     0.200
     2.306   -11.295     0.200
     2.630    -9.381     0.200
     2.630    -8.983     0.200
     4.165   -22.045     0.200
     4.467   -21.610     0.200
     4.467   -19.712     0.200
     6.305   -38.277     0.200
     9.657   -58.428     0.200
     0.550     2.597     0.200
     1.179    -2.729     0.200
     1.604    -3.474     0.200
     2.430   -14.011     0.200
     2.444   -10.455     0.200
     2.486    -7.086     0.200
     2.731   -12.534     0.200
     2.808   -12.071     0.200
     4.661   -24.925     0.200
     9.642   -68.403     0.200
     0.578     2.094     0.200
     1.150    -1.844     0.200
     1.642    -4.000     0.200
     1.873    -5.816     0.200
     2.954   -12.339     0.200
     3.299   -14.158     0.200
     5.120   -27.099     0.200
     5.120   -23.599     0.200
     6.637   -41.188     0.200
     0.440     2.666     0.200
     1.136    -1.595     0.200
     6.654   -34.917     0.200
     0.162    10.844     0.200
     0.235     9.135     0.200
     0.246     8.983     0.200
     0.328     8.969     0.200
     0.328     8.313     0.200
     0.421     5.644     0.200
     0.384     8.219     0.200
     0.646     3.916     0.200
     0.872     2.053     0.200
     1.149    -2.115     0.200
     1.240    -0.898     0.200
     1.240    -1.234     0.200
     1.448    -4.095     0.200
     1.552    -4.916     0.200
     2.289   -11.877     0.200
     2.289   -11.674     0.200
     2.353   -10.102     0.200
     2.653   -12.498     0.200
     2.653   -12.897     0.200
     2.729   -12.427     0.200
     2.729   -13.325     0.200
     4.595   -23.875     0.200
     4.595   -26.477     0.200
     4.645   -25.950     0.200
     4.645   -26.051     0.200
     0.213     8.870     0.200
     0.193     9.619     0.200
     0.422     5.239     0.200
     0.869     1.662     0.200
     1.158    -2.899     0.200
     1.282    -1.431     0.200
     1.434    -3.630     0.200
     1.860    -5.555     0.200
     2.275   -12.092     0.200
     2.346   -10.148     0.200
     2.647   -12.097     0.200
     2.724   -13.021     0.200
     4.590   -25.791     0.200
     0.149    11.199     0.200
     0.454     4.805     0.200
     0.637     2.608     0.200
     0.965     0.429     0.200
     1.146    -2.399     0.200
     1.239    -2.470     0.200
     1.764    -6.354     0.200
     1.798    -7.275     0.200
     2.530   -13.992     0.200
     2.530   -13.187     0.200
     2.564   -10.651     0.200
     2.622    -8.219     0.200
     2.855   -12.890     0.200
     2.932   -13.328     0.200
     4.603   -24.409     0.200
     4.791   -25.464     0.200
     6.714   -41.017     0.200
     6.737   -40.136     0.200
     9.707   -61.810     0.200
    11.208   -72.180     0.200
    12.300   -77.175     0.200
    12.490   -86.419     0.200
    15.166  -108.848     0.200
     0.244     8.815     0.200
     0.299     8.968     0.200
     0.370     5.505     0.200
     0.815     1.611     0.200
     1.111    -2.160     0.200
     1.316    -2.126     0.200
     1.377    -3.497     0.200
     2.218   -11.862     0.200
     2.290    -9.045     0.200
     2.395    -8.565     0.200
     2.592   -12.004     0.200
     2.668   -12.527     0.200
     4.535   -23.803     0.200
     4.535   -25.103     0.200
     4.651   -24.873     0.200
     6.512   -41.274     0.200
     6.807   -38.844     0.200
     6.807   -40.844     0.200
     6.882   -40.905     0.200
     7.693   -53.624     0.200
     7.999   -54.509     0.200
     8.100   -59.009     0.200
    10.075   -65.432     0.200
    11.249   -73.553     0.200
    13.099   -93.799     0.200
     0.270     8.449     0.200
     0.219     8.961     0.200
     0.478     6.169     0.200
     0.639     3.048     0.200
     0.844     0.560     0.200
     0.950    -0.913     0.200
     0.980    -0.066     0.200
     1.319    -2.991     0.200
     1.398    -4.313     0.200
     1.820    -8.973     0.200
     1.908    -6.491     0.200
     1.908    -6.788     0.200
     2.043    -6.440     0.200
     2.214    -9.486     0.200
     2.290   -10.289     0.200
     2.290    -9.890     0.200
     4.157   -18.261     0.200
     4.527   -24.708     0.200
     0.366     6.421     0.200
     0.496     3.898     0.200
     0.651     2.686     0.200
     0.754     0.915     0.200
     0.978    -0.278     0.200
     1.136    -2.381     0.200
     1.406    -3.147     0.200
     1.481    -6.236     0.200
     1.481    -6.041     0.200
     1.488    -6.353     0.200
     1.521    -4.680     0.200
     1.585    -4.525     0.200
     1.623    -4.935     0.200
     1.775    -4.834     0.200
     1.867    -7.456     0.200
     1.869    -6.604     0.200
     1.910    -7.713     0.200
     1.910    -8.416     0.200
     1.922    -7.909     0.200
     1.984    -8.279     0.200
     1.984    -7.678     0.200
     2.844   -15.562     0.200
     3.845   -19.374     0.200
     3.845   -20.069     0.200
     4.480   -26.777     0.200
     6.655   -39.836     0.200
     0.132    10.561     0.200
     0.275     7.821     0.200
     0.359     5.753     0.200
     1.102    -2.010     0.200
     1.353    -2.753     0.200
     1.456    -4.427     0.200
     2.194   -11.001     0.200
     2.379    -8.480     0.200
     3.136   -18.165     0.200
     4.515   -23.602     0.200
     4.515   -27.102     0.200
     0.175     9.786     0.200
     0.256     9.214     0.200
     0.233     8.558     0.200
     0.415     4.998     0.200
     0.856     1.911     0.200
     1.156    -2.712     0.200
     1.326    -1.998     0.200
     1.326    -2.138     0.200
     1.409    -4.331     0.200
     1.512    -5.894     0.200
     2.250   -11.673     0.200
     2.327   -10.532     0.200
     2.436    -9.286     0.200
     2.706   -13.041     0.200
     3.192   -18.546     0.200
     3.192   -18.139     0.200
     4.573   -23.621     0.200
     4.573   -26.723     0.200
     4.696   -26.025     0.200
     0.257     7.856     0.200
     0.305     7.062     0.200
     0.452     4.778     0.200
     1.182    -2.952     0.200
     1.578    -5.292     0.200
     1.855    -5.593     0.200
     2.315   -12.461     0.200
     2.382    -9.393     0.200
     2.479    -7.075     0.200
     2.759   -13.134     0.200
     3.256   -18.190     0.200
     4.625   -24.595     0.200
     4.625   -26.396     0.200
     4.677   -27.136     0.200
     8.590   -52.073     0.200
     0.143    11.136     0.200
     0.264     8.112     0.200
     0.298     8.021     0.200
     0.464     4.765     0.200
     0.914     1.506     0.200
     1.194    -2.879     0.200
     1.244    -1.159     0.200
     1.588    -4.853     0.200
     1.865    -6.000     0.200
     2.325   -12.126     0.200
     2.491    -8.194     0.200
     2.770   -13.635     0.200
     2.770   -13.834     0.200
     3.266   -18.559     0.200
     3.266   -18.661     0.200
     4.636   -27.398     0.200
     4.687   -27.413     0.200
     0.126    11.164     0.200
     0.261     8.064     0.200
     0.341     7.263     0.200
     1.004    -0.891     0.200
     1.267    -2.308     0.200
     1.361    -1.921     0.200
     1.372    -3.402     0.200
     1.780    -6.358     0.200
     1.781    -6.366     0.200
     2.109   -10.565     0.200
     2.282    -6.658     0.200
     2.555    -9.812     0.200
     2.555   -10.812     0.200
     4.422   -21.185     0.200
     4.576   -24.388     0.200
     4.576   -25.788     0.200
     0.154    11.192     0.200
     0.251     8.759     0.200
     0.316     8.802     0.200
     0.315     8.913     0.200
     0.383     7.488     0.200
     0.436     5.498     0.200
     0.654     2.866     0.200
     0.836     2.923     0.200
     1.165    -2.940     0.200
     1.241    -1.732     0.200
     1.241    -1.072     0.200
     1.460    -4.902     0.200
     2.071    -7.865     0.200
     2.302   -12.419     0.200
     2.302   -11.720     0.200
     2.463    -9.037     0.200
     2.744   -12.230     0.200
     2.744   -12.629     0.200
     3.243   -17.740     0.200
     3.243   -17.439     0.200
     4.610   -23.886     0.200
     4.610   -26.285     0.200
     4.726   -31.551     0.200
     4.661   -23.286     0.200
     6.427   -45.109     0.200
     6.821   -40.443     0.200
     0.218     8.566     0.200
     0.260     9.140     0.200
     0.447     4.589     0.200
     0.432     6.550     0.200
     0.710     3.448     0.200
     0.892     0.513     0.200
     1.185    -2.774     0.200
     1.451    -4.764     0.200
     1.554    -5.250     0.200
     2.291   -11.624     0.200
     2.744   -12.492     0.200
     2.744   -13.094     0.200
     3.233   -19.090     0.200
     4.611   -22.170     0.200
     4.705   -25.938     0.200
     0.185     9.500     0.200
     0.225     8.707     0.200
     0.422     4.846     0.200
     0.461     6.440     0.200
     0.864     1.688     0.200
     1.320    -0.938     0.200
     1.522    -4.915     0.200
     2.259   -11.689     0.200
     2.445    -7.275     0.200
     2.715   -11.844     0.200
     2.715   -12.743     0.200
     4.718   -30.130     0.200
     0.193     9.214     0.200
     0.286     7.012     0.200
     0.405     5.289     0.200
     0.851     1.768     0.200
     1.143    -2.532     0.200
     1.297    -2.031     0.200
     1.517    -5.314     0.200
     2.106    -8.216     0.200
     2.255   -12.586     0.200
     2.255   -12.086     0.200
     2.430    -8.156     0.200
     2.704   -12.950     0.200
     4.571   -26.023     0.200
     4.670   -25.352     0.200
     6.825   -41.171     0.200
     8.582   -53.472     0.200
    10.053   -61.188     0.200
    12.960   -87.336     0.200
    16.603  -114.433     0.200
    21.320  -149.868     0.200
     0.277     7.939     0.200
     0.347     5.969     0.200
     1.090    -2.070     0.200
     1.345    -2.859     0.200
     1.449    -3.912     0.200
     2.186   -12.286     0.200
     2.186   -12.184     0.200
     2.368    -9.261     0.200
     2.639   -12.738     0.200
     4.506   -24.320     0.200
     4.506   -26.418     0.200
     4.646   -25.552     0.200
     4.646   -26.052     0.200
     6.906   -41.261     0.200
     8.557   -49.435     0.200
     0.224     9.107     0.200
     0.182    10.154     0.200
     0.289     9.158     0.200
     0.290     9.120     0.200
     0.430     5.190     0.200
     0.415     6.805     0.200
     0.684     3.702     0.200
     0.878     1.886     0.200
     1.165    -2.432     0.200
     1.273    -0.945     0.200
     1.444    -3.528     0.200
     1.548    -5.010     0.200
     1.859    -7.069     0.200
     2.285   -11.788     0.200
     2.285   -11.687     0.200
     2.456    -9.815     0.200
     2.733   -13.482     0.200
     2.733   -12.881     0.200
     4.599   -22.948     0.200
     4.599   -26.448     0.200
     4.677   -26.209     0.200
     0.205     9.778     0.200
     0.402     5.319     0.200
     0.431     7.112     0.200
     0.687     3.686     0.200
     0.850     1.724     0.200
     1.139    -2.774     0.200
     2.257   -12.390     0.200
     2.257   -12.089     0.200
     2.428    -8.130     0.200
     2.704   -11.977     0.200
     4.571   -24.444     0.200
     4.571   -24.647     0.200
     4.660   -25.282     0.200
     6.815   -40.991     0.200
     6.851   -41.677     0.200
     8.573   -54.205     0.200
    11.261   -74.007     0.200
    12.950   -87.859     0.200
     0.133    11.694     0.200
     0.277     8.322     0.200
     0.345     8.222     0.200
     0.354     8.079     0.200
     0.440     5.511     0.200
     0.622     3.692     0.200
     1.161    -2.365     0.200
     1.210    -0.857     0.200
     1.578    -5.197     0.200
     1.817    -5.570     0.200
     2.314   -12.149     0.200
     2.750   -15.063     0.200
     4.640   -26.266     0.200
     9.511   -70.071     0.200
     0.167     9.946     0.200
     0.239     8.492     0.200
     0.277     9.079     0.200
     0.392     5.619     0.200
     0.467     5.791     0.200
     0.720     3.266     0.200
     0.835     2.290     0.200
     1.133    -2.315     0.200
     1.322    -2.225     0.200
     1.392    -3.396     0.200
     2.233   -11.650     0.200
     2.415    -7.118     0.200
     2.686   -12.722     0.200
     2.686   -13.323     0.200
     3.175   -17.609     0.200
     4.553   -23.503     0.200
     4.673   -26.018     0.200
     6.830   -38.880     0.200
     6.830   -41.477     0.200
     6.861   -41.386     0.200
     8.317   -52.184     0.200
     8.585   -54.724     0.200
    12.986   -87.225     0.200
    13.430   -91.796     0.200
    14.984  -107.159     0.200
    20.743  -145.134     0.200
    22.269  -158.010     0.200
     1.094    -1.213     0.200
     2.791    -9.136     0.200
     3.166   -13.518     0.200
     3.779   -20.262     0.200
     3.779   -21.360     0.200
     4.210   -22.722     0.200
     4.210   -24.222     0.200
     4.969   -26.882     0.200
     6.290   -38.343     0.200
     8.093   -50.614     0.200
     8.093   -45.915     0.200
     9.077   -53.996     0.200
    12.427   -78.895     0.200
    14.619  -101.673     0.200
     0.606     2.436     0.200
     0.673     1.827     0.200
     2.221   -10.900     0.200
     2.909   -15.323     0.200
     3.184   -16.038     0.200
     3.799   -20.728     0.200
     4.208   -20.785     0.200
     4.985   -28.040     0.200
     0.181    10.330     0.200
     0.225     9.263     0.200
     0.295     9.422     0.200
     0.426     5.515     0.200
     0.679     3.776     0.200
     1.160    -2.635     0.200
     1.270    -1.549     0.200
     1.442    -4.033     0.200
     1.546    -5.303     0.200
     1.854    -5.852     0.200
     2.283   -11.972     0.200
     2.453    -7.651     0.200
     2.730   -12.731     0.200
     2.730   -12.932     0.200
     3.225   -19.112     0.200
     3.225   -18.311     0.200
     4.596   -22.299     0.200
     4.596   -26.399     0.200
     0.325     8.520     0.200
     0.304     8.067     0.200
     0.454     5.667     0.200
     0.715     2.957     0.200
     0.900     0.403     0.200
     0.812     1.111     0.200
     1.138    -1.706     0.200
     1.220    -2.929     0.200
     1.393    -2.430     0.200
     1.457    -3.274     0.200
     1.638    -7.172     0.200
     1.638    -7.571     0.200
     1.865    -5.470     0.200
     1.758    -5.779     0.200
     2.107    -8.534     0.200
     2.580   -13.937     0.200
     2.580   -14.737     0.200
     3.973   -22.194     0.200
     3.973   -21.093     0.200
     4.432   -26.048     0.200
     6.606   -41.469     0.200
     7.404   -43.952     0.200
     8.733   -57.157     0.200
     9.618   -56.028     0.200
    10.486   -64.974     0.200
    13.211   -82.794     0.200
     0.134    10.158     0.200
     0.274     7.688     0.200
     0.295     8.160     0.200
     0.353     5.767     0.200
     0.794     2.469     0.200
     1.096    -1.986     0.200
     1.343    -1.323     0.200
     2.191   -10.363     0.200
     2.191   -11.162     0.200
     2.374    -6.967     0.200
     2.644   -10.837     0.200
     3.133   -16.620     0.200
     4.511   -24.117     0.200
     0.236     6.755     0.200
     0.343     4.794     0.200
     0.613     2.002     0.200
     0.899     0.671     0.200
     1.066     1.000     0.200
     1.124    -2.809     0.200
     1.165    -0.949     0.200
     1.217    -2.919     0.200
     1.650    -5.139     0.200
     1.771    -7.644     0.200
     2.497   -14.285     0.200
     2.878   -14.844     0.200
     3.426   -20.107     0.200
     4.732   -26.809     0.200
     0.242     8.144     0.200
     0.266     8.126     0.200
     0.493     5.643     0.200
     0.644     2.584     0.200
     0.983    -0.216     0.200
     1.084    -2.053     0.200
     1.319    -3.148     0.200
     1.409    -4.549     0.200
     1.544    -4.086     0.200
     1.572    -4.681     0.200
     1.821    -8.912     0.200
     1.824    -6.227     0.200
     2.053    -6.069     0.200
     2.297   -10.400     0.200
     2.297   -10.696     0.200
     2.764   -15.210     0.200
     4.163   -21.352     0.200
     4.163   -23.352     0.200
     4.550   -25.004     0.200
     4.550   -25.903     0.200
     0.201     9.725     0.200
     0.276     9.243     0.200
     0.276     9.290     0.200
     0.424     5.754     0.200
     0.434     6.562     0.200
     0.702     3.083     0.200
     0.870     1.360     0.200
     1.162    -1.347     0.200
     1.293    -1.390     0.200
     1.869    -5.989     0.200
     2.723   -12.291     0.200
     2.723   -11.791     0.200
     3.214   -16.748     0.200
     3.214   -18.049     0.200
     4.590   -25.365     0.200
     4.590   -22.967     0.200
     6.839   -42.361     0.200
    12.322   -86.485     0.200
    13.410   -87.958     0.200
     1.506    -3.787     0.200
     3.156   -15.878     0.200
     3.756   -20.197     0.200
     4.306   -21.321     0.200
     4.306   -20.723     0.200
     4.973   -26.286     0.200
     6.393   -37.103     0.200
     7.477   -43.349     0.200
     8.194   -50.588     0.200
     9.164   -53.147     0.200
     9.703   -64.153     0.200
     9.651   -59.903     0.200
    10.877   -64.432     0.200
    10.891   -71.277     0.200
    12.089   -75.240     0.200
    12.933   -82.534     0.200
    14.739  -101.265     0.200
    14.808   -98.515     0.200
    15.215  -110.142     0.200
    15.556  -117.083     0.200
    15.840  -102.774     0.200
    18.850  -130.867     0.200
    19.358  -133.463     0.200
    20.704  -146.246     0.200
    21.264  -142.591     0.200
    22.682  -165.939     0.200
     0.677     1.232     0.200
     3.194   -14.455     0.200
     3.789   -22.107     0.200
     3.789   -21.810     0.200
     5.016   -24.196     0.200
     0.461     3.268     0.200
     0.428     4.356     0.200
     0.705     1.623     0.200
     0.620     2.612     0.200
     1.104    -1.969     0.200
     3.272   -15.768     0.200
     3.860   -22.298     0.200
     4.454   -25.115     0.200
     5.099   -27.573     0.200
     5.099   -25.174     0.200
     9.553   -66.113     0.200
    12.719   -87.819     0.200
     1.143    -1.652     0.200
     1.388    -3.867     0.200
     0.087     8.229     0.200
     0.309     3.216     0.200
     0.396     4.689     0.200
     0.480     3.665     0.200
     0.693     2.862     0.200
     0.718     0.950     0.200
     0.822     2.870     0.200
     1.042    -1.699     0.200
     1.066    -1.438     0.200
     1.486    -2.664     0.200
     1.091    -1.362     0.200
     3.121   -15.956     0.200
     3.724   -22.170     0.200
     4.265   -22.508     0.200
     4.936   -29.174     0.200
     0.370     4.427     0.200
     0.501     2.805     0.200
     1.045    -0.855     0.200
     1.071    -2.040     0.200
     1.499    -3.378     0.200
     0.400     3.830     0.200
     1.046    -0.916     0.200
     1.045    -1.609     0.200
     3.156   -14.302     0.200
     3.756   -20.910     0.200
     4.309   -22.721     0.200
     4.974   -25.122     0.200
     4.974   -23.521     0.200
     8.197   -45.695     0.200
     9.700   -67.537     0.200
    11.976   -73.648     0.200
     0.029    10.002     0.200
     0.336     3.188     0.200
     0.413     4.351     0.200
     0.701     0.995     0.200
     0.738     2.401     0.200
     0.882     2.441     0.200
     1.047    -2.290     0.200
     1.016    -0.961     0.200
     1.280    -0.861     0.200
     1.545    -3.588     0.200
     0.018    10.091     0.200
     0.364     3.217     0.200
     0.423     3.760     0.200
     0.672     1.331     0.200
     0.767     2.222     0.200
     0.924     1.691     0.200
     0.979    -0.184     0.200
     1.059    -1.879     0.200
     1.146     0.965     0.200
     1.254    -0.775     0.200
     1.388    -2.682     0.200
     1.435    -3.268     0.200
     1.401    -2.643     0.200
     1.587    -2.238     0.200
     3.206   -16.987     0.200
     3.798   -22.952     0.200
     4.387   -23.844     0.200
     0.402     3.547     0.200
     0.719     0.624     0.200
     1.058    -1.114     0.200
     1.118    -1.942     0.200
     1.118    -1.883     0.200
     1.497    -3.979     0.200
     1.497    -3.557     0.200
     2.018    -6.488     0.200
     3.147   -15.624     0.200
     3.747   -21.460     0.200
     4.298   -23.120     0.200
     4.964   -29.027     0.200
     4.964   -23.527     0.200
     8.187   -50.902     0.200
     0.456     3.058     0.200
     0.411     4.101     0.200
     1.041    -1.645     0.200
     1.528    -2.993     0.200
     0.070     8.059     0.200
     0.302     3.984     0.200
     0.419     4.082     0.200
     0.723     2.636     0.200
     0.724     1.009     0.200
     1.025    -2.109     0.200
     1.057    -1.308     0.200
     1.078     0.729     0.200
     1.099    -1.467     0.200
     1.099    -2.704     0.200
     1.289    -1.511     0.200
     1.316    -1.163     0.200
     1.319    -3.068     0.200
     1.387    -3.251     0.200
     1.506    -4.343     0.200
     1.506    -3.639     0.200
     1.506    -2.100     0.200
     1.506    -3.670     0.200
     1.946    -6.855     0.200
     2.010    -7.778     0.200
     2.010    -7.388     0.200
     2.026    -9.196     0.200
     2.330   -10.156     0.200
     2.375   -11.639     0.200
     2.846   -15.632     0.200
     3.141   -14.672     0.200
     3.739   -21.639     0.200
     4.248   -23.737     0.200
     4.310   -21.722     0.200
     4.310   -20.722     0.200
     4.424   -22.381     0.200
     4.960   -27.231     0.200
     4.960   -23.536     0.200
     9.186   -57.801     0.200
    10.898   -70.484     0.200
    12.562   -82.318     0.200
    13.659   -91.882     0.200
    13.659   -90.686     0.200
    14.757  -101.596     0.200
    22.703  -160.985     0.200
     1.062    -2.024     0.200
     1.144    -1.733     0.200
     3.100   -17.622     0.200
     3.713   -21.627     0.200
     0.695     0.399     0.200
     1.389    -2.722     0.200
     1.430    -4.155     0.200
     1.575    -4.035     0.200
     0.033    10.377     0.200
     0.333     3.047     0.200
     0.453     4.267     0.200
     0.412     4.614     0.200
     0.702     0.935     0.200
     0.695     1.273     0.200
     0.736     2.685     0.200
     0.878     2.081     0.200
     1.020    -0.520     0.200
     1.045    -2.102     0.200
     1.099    -2.032     0.200
     1.105     1.021     0.200
     1.541    -4.384     0.200
     1.541    -5.556     0.200
     0.046     9.753     0.200
     0.341     3.152     0.200
     0.390     4.792     0.200
     0.477     3.495     0.200
     0.725     0.368     0.200
     0.685     1.428     0.200
     0.712     2.919     0.200
     1.062    -2.517     0.200
     1.023    -0.808     0.200
     1.123    -1.368     0.200
     1.277    -0.967     0.200
     1.346    -3.143     0.200
     1.528    -3.342     0.200
     0.367     4.340     0.200
     1.061    -1.985     0.200
     1.144    -1.640     0.200
     3.103   -14.557     0.200
     3.716   -21.180     0.200
     4.183   -21.194     0.200
     4.908   -23.963     0.200
     4.908   -22.963     0.200
     0.013    10.022     0.200
     0.367     2.883     0.200
     0.451     3.696     0.200
     0.416     4.120     0.200
     0.698     1.209     0.200
     0.667     1.302     0.200
     0.761     2.091     0.200
     0.921     2.044     0.200
     0.978    -0.458     0.200
     1.064    -1.916     0.200
     1.142     0.839     0.200
     1.250    -0.501     0.200
     1.585    -5.197     0.200
     1.057    -1.983     0.200
     1.050    -1.111     0.200
     1.498    -3.905     0.200
     1.043    -1.110     0.200
     1.075    -2.316     0.200
     1.152    -2.241     0.200
     0.451     2.563     0.200
     0.699     0.586     0.200
     1.067    -1.506     0.200
     0.449     3.356     0.200
     0.421     3.763     0.200
     1.069    -1.806     0.200
     3.220   -15.304     0.200
     3.812   -23.451     0.200
     3.812   -20.851     0.200
     4.400   -20.590     0.200
     5.044   -29.328     0.200
    12.082   -76.012     0.200
     1.063    -2.136     0.200
     1.127    -2.035     0.200
     0.487     3.769     0.200
     0.384     4.254     0.200
     1.057    -1.957     0.200
     1.049    -1.062     0.200
     1.500    -2.997     0.200
     1.500    -2.996     0.200
     2.015    -8.445     0.200
     3.161   -16.464     0.200
     3.763   -21.831     0.200
     3.763   -22.130     0.200
     4.297   -21.479     0.200
     4.297   -21.979     0.200
     4.977   -27.324     0.200
     4.977   -24.424     0.200
     9.710   -68.669     0.200
     0.180     6.572     0.200
     0.196     7.076     0.200
     0.767     2.420     0.200
     1.166    -2.429     0.200
     1.420    -1.626     0.200
     0.455     3.487     0.200
     0.412     4.164     0.200
     1.066    -1.261     0.200
     3.208   -13.868     0.200
     3.802   -21.978     0.200
     4.379   -20.277     0.200
     5.031   -26.039     0.200
     0.372     4.376     0.200
     1.075    -1.314     0.200
     1.061    -1.822     0.200
     3.147   -16.109     0.200
     3.752   -22.495     0.200
     4.263   -20.698     0.200
     4.959   -27.864     0.200
     0.364     2.648     0.200
     1.060    -1.752     0.200
     1.583    -3.524     0.200
     3.205   -15.870     0.200
     3.798   -22.756     0.200
     4.384   -20.836     0.200
     4.384   -21.133     0.200
     5.028   -28.170     0.200
     5.028   -23.771     0.200
     0.379     2.554     0.200
     0.447     3.819     0.200
     0.423     3.956     0.200
     0.660     1.360     0.200
     0.774     1.857     0.200
     0.938     1.501     0.200
     0.963    -0.196     0.200
     1.068    -2.212     0.200
     1.241    -0.460     0.200
     1.416    -3.213     0.200
     1.602    -3.472     0.200
     3.811   -24.200     0.200
     0.380     4.345     0.200
     0.499     3.196     0.200
     0.714     0.534     0.200
     1.074    -1.471     0.200
     1.472    -2.856     0.200
     3.144   -15.450     0.200
     3.748   -21.001     0.200
     4.269   -20.924     0.200
     4.269   -21.125     0.200
     4.957   -27.635     0.200
     8.157   -48.573     0.200
     9.149   -56.528     0.200
    12.077   -76.829     0.200
     0.744     0.195     0.200
     1.105    -1.430     0.200
     1.443    -3.703     0.200
     3.114   -14.271     0.200
     3.720   -20.869     0.200
     4.243   -20.749     0.200
     4.243   -23.647     0.200
     4.503   -25.700     0.200
     4.927   -26.918     0.200
     8.132   -48.740     0.200
    12.093   -75.708     0.200
     0.394     4.605     0.200
     0.474     3.451     0.200
     1.053    -1.923     0.200
     1.038    -1.017     0.200
     1.515    -5.270     0.200
     3.166   -16.542     0.200
     3.765   -22.244     0.200
     4.314   -22.246     0.200
     4.983   -30.062     0.200
     0.499     3.559     0.200
     1.053    -1.217     0.200
     1.065    -1.996     0.200
     3.162   -17.806     0.200
     3.765   -23.016     0.200
     3.765   -21.816     0.200
     4.977   -24.219     0.200
     9.720   -70.250     0.200
     0.388     4.284     0.200
     0.759     0.315     0.200
     1.039    -1.660     0.200
     1.137    -1.895     0.200
     3.096   -15.542     0.200
     3.706   -20.770     0.200
     4.905   -27.969     0.200
     0.399     4.269     0.200
     0.484     4.281     0.200
     1.034    -2.322     0.200
     1.086    -1.079     0.200
     3.126   -14.985     0.200
     3.730   -20.709     0.200
     4.267   -24.533     0.200
     4.941   -27.707     0.200
     0.399     4.121     0.200
     1.033    -0.953     0.200
     1.050    -1.970     0.200
     4.207   -19.898     0.200
     4.207   -21.199     0.200
     4.821   -22.337     0.200
    12.198   -77.806     0.200
    12.429   -81.709     0.200
    14.748  -100.724     0.200
    15.067  -103.359     0.200
     0.393     4.155     0.200
     0.476     3.597     0.200
     1.052    -1.692     0.200
     1.042    -1.050     0.200
     3.163   -18.510     0.200
     3.763   -22.631     0.200
     4.980   -27.817     0.200
     0.423     3.913     0.200
     0.396     4.238     0.200
     0.480     3.825     0.200
     1.042    -1.402     0.200
     1.485    -4.248     0.200
     3.142   -14.555     0.200
     3.142   -12.860     0.200
     3.744   -21.634     0.200
     4.285   -22.090     0.200
     4.285   -22.387     0.200
     4.957   -27.111     0.200
     9.724   -66.928     0.200
    11.989   -74.768     0.200
     3.176   -15.102     0.200
     3.783   -19.742     0.200
     4.265   -22.906     0.200
     4.986   -27.384     0.200
     0.553     3.154     0.200
     1.054    -1.990     0.200
     1.155    -2.000     0.200
     1.379    -2.863     0.200
     3.092   -16.035     0.200
     3.705   -21.174     0.200
     3.705   -20.776     0.200
     4.175   -21.662     0.200
     4.175   -21.861     0.200
     0.398     4.286     0.200
     0.470     3.531     0.200
     1.049    -1.558     0.200
     3.163   -15.157     0.200
     3.762   -21.452     0.200
     4.981   -23.284     0.200
    20.711  -145.834     0.200
     0.415     4.099     0.200
     1.064    -1.542     0.200
     1.581    -4.019     0.200
     3.207   -17.604     0.200
     3.800   -22.506     0.200
     4.380   -23.207     0.200
     5.029   -23.887     0.200
     0.402     4.297     0.200
     0.727     0.588     0.200
     1.032    -0.994     0.200
     1.085    -1.064     0.200
     1.127    -1.882     0.200
     3.126   -15.307     0.200
     3.729   -22.517     0.200
     0.384     4.444     0.200
     0.488     3.575     0.200
     1.053    -1.120     0.200
     1.495    -2.942     0.200
     7.393   -46.876     0.200
     0.476     3.992     0.200
     0.711     2.841     0.200
     1.060    -0.917     0.200
     3.176   -13.896     0.200
     3.775   -20.181     0.200
     4.323   -21.846     0.200
     4.994   -26.321     0.200
     8.211   -49.480     0.200
    11.957   -73.795     0.200
    12.600   -84.525     0.200
     1.064    -1.559     0.200
     1.134    -1.928     0.200
     1.399    -3.478     0.200
     3.111   -13.579     0.200
     3.724   -21.683     0.200
     4.193   -22.863     0.200
     4.193   -21.763     0.200
     4.917   -27.011     0.200
     0.017    10.633     0.200
     0.356     3.382     0.200
     0.426     4.500     0.200
     0.679     1.277     0.200
     0.766     2.363     0.200
     0.987    -0.472     0.200
     1.052    -1.703     0.200
     1.262    -0.583     0.200
     1.580    -2.309     0.200
     3.198   -14.571     0.200
     3.198   -13.372     0.200
     3.790   -22.349     0.200
     4.381   -24.389     0.200
     4.381   -21.688     0.200
     5.021   -27.479     0.200
     5.021   -24.479     0.200
     0.519     3.699     0.200
     0.655     2.766     0.200
     1.068    -1.268     0.200
     3.763   -18.683     0.200
     4.969   -23.108     0.200
     8.151   -47.358     0.200
    12.057   -75.578     0.200
    14.689  -102.016     0.200
     0.701     0.728     0.200
     1.041    -2.366     0.200
     1.028    -1.333     0.200
     2.859   -16.353     0.200
     3.166   -16.701     0.200
     3.763   -21.909     0.200
     3.763   -21.713     0.200
     4.335   -23.653     0.200
     0.218     9.457     0.200
     0.188     9.967     0.200
     0.281     9.771     0.200
     0.282     8.498     0.200
     0.431     5.343     0.200
     0.422     6.496     0.200
     0.693     3.435     0.200
     0.878     1.990     0.200
     1.866    -6.239     0.200
     2.079    -7.447     0.200
     4.718   -30.836     0.200
     0.031    10.514     0.200
     0.331     3.177     0.200
     0.425     4.370     0.200
     0.700     0.891     0.200
     0.750     2.284     0.200
     0.887     2.289     0.200
     1.017    -1.169     0.200
     1.549    -3.184     0.200
     3.172   -14.886     0.200
     3.172   -13.687     0.200
     3.766   -22.034     0.200
     3.766   -22.733     0.200
     4.352   -23.313     0.200
     4.352   -22.415     0.200
     4.994   -28.143     0.200
     9.657   -68.764     0.200
    12.104   -75.556     0.200
     0.375     3.935     0.200
     1.114    -1.602     0.200
     3.118   -15.447     0.200
     3.726   -21.942     0.200
     4.222   -19.253     0.200
     4.927   -28.192     0.200
     0.500     3.133     0.200
     1.017    -1.155     0.200
     3.149   -12.414     0.200
     3.735   -20.487     0.200
     4.400   -20.874     0.200
     4.978   -24.706     0.200
     8.293   -47.597     0.200
     9.614   -66.525     0.200
    10.990   -66.484     0.200
    22.754  -159.888     0.200
     3.046   -13.081     0.200
     4.180   -20.350     0.200
     4.855   -25.329     0.200
     8.073   -48.641     0.200
    12.131   -76.990     0.200
    12.449   -84.872     0.200
     0.798     1.747     0.200
     0.996    -0.411     0.200
     3.178   -13.198     0.200
     3.766   -19.965     0.200
     4.395   -21.696     0.200
     4.395   -20.196     0.200
     5.004   -26.106     0.200
     6.486   -37.783     0.200
     9.214   -53.759     0.200
     9.616   -69.008     0.200
    21.483  -149.589     0.200
     1.050    -2.168     0.200
     1.123    -1.840     0.200
     1.507    -3.204     0.200
     1.507    -3.672     0.200
     3.160   -14.643     0.200
     3.160   -12.743     0.200
     3.760   -21.467     0.200
     4.306   -23.388     0.200
     4.977   -27.242     0.200
     8.194   -46.745     0.200
     0.358     3.102     0.200
     1.044    -1.924     0.200
     1.595    -3.927     0.200
     3.199   -14.728     0.200
     3.199   -14.529     0.200
     5.024   -25.898     0.200
     5.024   -25.098     0.200
     0.414     4.157     0.200
     0.451     3.720     0.200
     3.193   -15.142     0.200
     3.193   -13.243     0.200
     3.787   -20.981     0.200
     4.365   -20.997     0.200
     5.015   -26.698     0.200
     8.253   -51.250     0.200
     0.411     3.972     0.200
     3.201   -12.909     0.200
     3.795   -21.843     0.200
     4.371   -20.603     0.200
     4.371   -22.603     0.200
     5.023   -25.771     0.200
     5.023   -23.572     0.200
     0.686     2.359     0.200
     1.084    -0.936     0.200
     1.652    -4.254     0.200
     1.652    -4.331     0.200
     2.219   -10.280     0.200
     2.930   -15.732     0.200
     3.254   -15.415     0.200
     3.841   -22.016     0.200
     4.450   -20.930     0.200
     5.082   -27.151     0.200
     5.082   -24.151     0.200
     6.535   -35.012     0.200
     7.407   -44.365     0.200
     8.337   -47.841     0.200
    15.345  -106.898     0.200
     0.589     3.480     0.200
     1.065    -1.973     0.200
     3.094   -14.429     0.200
     3.709   -20.430     0.200
     4.161   -23.353     0.200
     4.161   -22.654     0.200
     4.896   -27.061     0.200
     0.154     5.577     0.200
     0.390     4.059     0.200
     0.390     4.790     0.200
     0.408     2.780     0.200
     0.860     0.922     0.200
     1.119    -3.143     0.200
     1.188    -1.628     0.200
     1.766    -6.640     0.200
     1.766    -5.679     0.200
     1.767    -6.330     0.200
     1.767    -6.705     0.200
     2.104    -9.268     0.200
     2.104    -7.217     0.200
     2.719   -13.099     0.200
     3.230   -19.708     0.200
     3.230   -20.107     0.200
     4.584   -25.609     0.200
     4.584   -23.609     0.200
     4.590   -25.591     0.200
     4.782   -28.550     0.200
     6.864   -39.504     0.200
     6.740   -41.270     0.200
     0.212     9.240     0.200
     0.196     9.706     0.200
     0.272     8.756     0.200
     0.273     9.436     0.200
     0.432     4.947     0.200
     0.431     5.569     0.200
     0.703     3.191     0.200
     0.878     1.840     0.200
     1.169    -2.609     0.200
     1.291    -1.684     0.200
     1.439    -3.590     0.200
     1.874    -5.927     0.200
     1.873    -6.571     0.200
     2.080    -6.830     0.200
     2.731   -13.368     0.200
     2.731   -12.469     0.200
     3.221   -18.917     0.200
     4.598   -26.942     0.200
     4.598   -23.340     0.200
     0.483     3.688     0.200
     0.682     3.081     0.200
     1.028    -0.962     0.200
     1.458    -2.737     0.200
     2.125    -8.035     0.200
     3.117   -12.276     0.200
     3.721   -18.910     0.200
     4.932   -24.787     0.200
    12.102   -75.279     0.200
    15.867  -105.346     0.200
     0.482     3.810     0.200
     1.057    -1.636     0.200
     0.152     9.790     0.200
     0.254     8.338     0.200
     0.284     9.106     0.200
     0.285     8.345     0.200
     0.374     5.593     0.200
     0.479     5.892     0.200
     0.724     3.698     0.200
     0.816     1.700     0.200
     1.116    -1.867     0.200
     1.331    -1.920     0.200
     2.214   -10.795     0.200
     2.142    -9.438     0.200
     2.667   -13.066     0.200
     4.534   -23.347     0.200
     4.663   -25.730     0.200
     4.663   -23.636     0.200
     6.821   -42.820     0.200
     6.878   -40.694     0.200
     8.328   -53.003     0.200
     8.575   -54.533     0.200
     8.575   -51.634     0.200
    12.998   -86.657     0.200
    13.434   -88.463     0.200
    14.966  -107.624     0.200
    19.764  -137.837     0.200
     0.383     4.246     0.200
     1.045    -1.295     0.200
     1.110    -1.298     0.200
     1.433    -3.823     0.200
     2.747   -11.356     0.200
     2.828   -15.346     0.200
     3.116   -12.580     0.200
     3.116   -14.978     0.200
     4.231   -23.528     0.200
     4.927   -23.573     0.200
     4.927   -27.370     0.200
     6.319   -36.617     0.200
     8.120   -49.896     0.200
     9.777   -70.103     0.200
    10.858   -69.384     0.200
    12.083   -76.915     0.200
    12.521   -86.213     0.200
     0.632     3.146     0.200
     1.063    -1.052     0.200
     1.429    -5.104     0.200
     2.086    -7.186     0.200
     2.842   -15.637     0.200
     3.127   -13.469     0.200
     4.223   -22.622     0.200
     4.935   -25.598     0.200
     4.977   -27.534     0.200
     1.091    -1.220     0.200
     1.445    -3.143     0.200
     2.163   -11.611     0.200
     2.856   -16.496     0.200
     3.143   -16.980     0.200
     3.751   -22.462     0.200
     4.238   -21.573     0.200
     0.513     4.233     0.200
     1.098    -0.933     0.200
     2.839   -15.434     0.200
     3.128   -15.405     0.200
     3.735   -20.338     0.200
     0.181     9.589     0.200
     0.257     9.508     0.200
     0.227     8.797     0.200
     0.419     5.112     0.200
     0.861     1.810     0.200
     1.160    -2.518     0.200
     1.322    -1.415     0.200
     1.518    -4.675     0.200
     1.884    -6.674     0.200
     1.885    -6.703     0.200
     2.098    -8.504     0.200
     2.255   -11.849     0.200
     2.255   -11.646     0.200
     2.441    -8.436     0.200
     2.711   -12.901     0.200
     3.198   -17.220     0.200
     4.578   -24.484     0.200
     4.578   -25.082     0.200
     4.721   -29.374     0.200
     4.697   -25.352     0.200
     0.133    10.331     0.200
     0.291     8.142     0.200
     0.274     7.530     0.200
     0.357     5.530     0.200
     0.496     4.964     0.200
     0.732     2.042     0.200
     0.797     2.299     0.200
     1.100    -1.899     0.200
     1.352    -3.199     0.200
     1.345    -1.465     0.200
     1.456    -4.317     0.200
     2.193   -11.093     0.200
     2.377    -7.838     0.200
     2.647   -11.591     0.200
     3.135   -17.053     0.200
     4.514   -23.772     0.200
     0.881     2.510     0.200
     0.914     2.662     0.200
     2.340   -11.727     0.200
     2.340   -10.727     0.200
     2.685    -8.967     0.200
     2.685   -10.467     0.200
     3.256   -17.060     0.200
     4.265   -22.632     0.200
     4.529   -19.626     0.200
     1.140    -1.880     0.200
     2.145   -10.801     0.200
     2.736    -9.743     0.200
     2.833   -15.621     0.200
     3.111   -14.408     0.200
     3.724   -20.848     0.200
     4.184   -19.035     0.200
     4.184   -19.137     0.200
     4.915   -26.403     0.200
     0.175     9.975     0.200
     0.232     8.945     0.200
     0.265     8.791     0.200
     0.265     9.386     0.200
     0.407     5.114     0.200
     0.465     6.038     0.200
     0.725     2.909     0.200
     0.850     1.840     0.200
     0.917     1.300     0.200
     1.149    -2.776     0.200
     2.109    -8.570     0.200
     2.246   -11.584     0.200
     2.430    -7.822     0.200
     2.701   -12.704     0.200
     3.188   -17.951     0.200
     3.188   -16.551     0.200
     4.567   -22.284     0.200
     4.687   -23.376     0.200
     4.687   -25.876     0.200
     0.179     9.526     0.200
     0.270     9.454     0.200
     0.269     9.099     0.200
     0.227     8.811     0.200
     0.407     5.119     0.200
     0.459     6.499     0.200
     0.719     2.886     0.200
     0.850     2.029     0.200
     1.148    -2.569     0.200
     1.316    -1.578     0.200
     2.108    -7.204     0.200
     2.248   -11.924     0.200
     2.430    -8.109     0.200
     2.702   -12.913     0.200
     2.702   -12.811     0.200
     3.190   -18.288     0.200
     3.190   -17.690     0.200
     4.569   -22.292     0.200
     4.569   -26.292     0.200
     0.154     9.930     0.200
     0.257     8.429     0.200
     0.306     7.623     0.200
     0.307     7.786     0.200
     0.356     5.557     0.200
     1.096    -2.487     0.200
     1.362    -3.661     0.200
     2.158    -9.167     0.200
     2.203   -11.667     0.200
     2.203   -11.266     0.200
     2.275    -9.140     0.200
     2.275    -9.539     0.200
     2.380    -7.663     0.200
     2.653   -12.221     0.200
     3.145   -16.312     0.200
     4.520   -24.697     0.200
     4.520   -25.297     0.200
     4.641   -24.647     0.200
     4.641   -26.147     0.200
     4.785   -30.662     0.200
    14.567   -99.540     0.200
     0.422     4.369     0.200
     0.443     3.623     0.200
     2.161    -9.931     0.200
     2.869   -15.868     0.200
     3.777   -20.654     0.200
     3.777   -19.253     0.200
     5.011   -26.076     0.200
     0.741     2.772     0.200
     1.429    -4.247     0.200
     2.165   -10.879     0.200
     2.165   -10.579     0.200
     2.223    -8.515     0.200
     2.599   -10.519     0.200
     2.599   -10.019     0.200
     3.104   -14.245     0.200
     4.464   -22.860     0.200
     4.464   -23.360     0.200
     4.551   -23.919     0.200
     6.967   -37.293     0.200
     0.176     9.345     0.200
     0.262     9.428     0.200
     0.231     9.007     0.200
     0.410     5.053     0.200
     0.465     5.399     0.200
     0.726     2.964     0.200
     0.852     1.886     0.200
     1.151    -2.658     0.200
     1.878    -7.442     0.200
     2.247   -11.652     0.200
     2.324    -8.778     0.200
     2.324    -8.979     0.200
     2.432    -8.007     0.200
     2.703   -13.083     0.200
     2.703   -12.384     0.200
     4.570   -22.764     0.200
     4.570   -25.064     0.200
     4.690   -23.869     0.200
     0.319     5.564     0.200
     0.357     4.871     0.200
     0.539     3.785     0.200
     0.720     1.052     0.200
     0.926     0.447     0.200
     0.926    -0.082     0.200
     0.956    -0.286     0.200
     1.078    -3.026     0.200
     1.420    -5.276     0.200
     1.785    -7.736     0.200
     1.927    -7.359     0.200
     1.902    -7.647     0.200
     2.063    -7.655     0.200
     2.286   -10.938     0.200
     2.286    -9.938     0.200
     4.149   -19.983     0.200
     4.149   -22.784     0.200
     4.633   -27.936     0.200
     0.174    10.040     0.200
     0.231     8.597     0.200
     0.305     7.363     0.200
     0.424     5.347     0.200
     0.668     2.074     0.200
     1.156    -2.432     0.200
     1.844    -6.138     0.200
     2.285   -12.490     0.200
     2.352   -10.232     0.200
     2.451    -8.047     0.200
     2.729   -13.079     0.200
     2.729   -12.978     0.200
     4.596   -23.039     0.200
     4.596   -26.039     0.200
     0.237     8.525     0.200
     0.317     8.211     0.200
     0.316     8.984     0.200
     0.658     2.404     0.200
     1.151    -2.161     0.200
     1.251    -1.629     0.200
     2.285   -11.852     0.200
     2.448    -9.100     0.200
     2.728   -12.574     0.200
     2.728   -12.274     0.200
     4.594   -22.531     0.200
     4.594   -26.131     0.200
     4.653   -26.713     0.200
     0.169    10.241     0.200
     0.237     9.037     0.200
     0.287     8.649     0.200
     0.385     5.652     0.200
     0.711     3.220     0.200
     0.829     2.402     0.200
     1.125    -2.240     0.200
     1.315    -1.953     0.200
     1.389    -3.426     0.200
     1.493    -4.500     0.200
     2.230   -11.374     0.200
     2.230   -11.175     0.200
     2.303    -9.499     0.200
     2.409    -7.545     0.200
     2.681   -13.089     0.200
     2.681   -12.987     0.200
     4.548   -24.164     0.200
     4.548   -25.266     0.200
     4.663   -25.719     0.200
     4.663   -24.317     0.200
     0.612     3.114     0.200
     0.677     1.132     0.200
     1.068    -0.971     0.200
     1.458    -2.655     0.200
     2.843   -11.416     0.200
     2.895   -16.365     0.200
     3.179   -12.959     0.200
     3.179   -15.959     0.200
     4.242   -20.664     0.200
     4.242   -22.664     0.200
     4.985   -27.835     0.200
    12.016   -76.802     0.200
     0.079     9.028     0.200
     0.320     3.582     0.200
     0.389     3.960     0.200
     0.484     4.385     0.200
     0.707     0.855     0.200
     0.692     2.584     0.200
     0.829     2.533     0.200
     1.051    -2.190     0.200
     1.056    -1.454     0.200
     1.054     1.415     0.200
     1.311    -2.588     0.200
     2.156   -11.634     0.200
     2.813   -12.971     0.200
     2.855   -16.902     0.200
     3.153   -12.965     0.200
     3.153   -15.965     0.200
     4.292   -24.264     0.200
     4.292   -21.764     0.200
     0.121    10.952     0.200
     0.361     5.872     0.200
     0.278     9.105     0.200
     0.509     5.319     0.200
     0.798     2.664     0.200
     1.106    -1.947     0.200
     1.349    -2.691     0.200
     1.360    -2.764     0.200
     1.452    -4.787     0.200
     2.189   -10.561     0.200
     2.646   -14.862     0.200
     0.189     9.244     0.200
     0.182     8.769     0.200
     0.540     5.032     0.200
     0.885     0.338     0.200
     1.072    -0.650     0.200
     1.176    -1.834     0.200
     1.783    -5.825     0.200
     1.784    -5.814     0.200
     1.913    -9.208     0.200
     2.117    -6.062     0.200
     2.374    -9.021     0.200
     2.374   -11.322     0.200
     4.241   -20.005     0.200
     4.344   -23.776     0.200
     0.369     4.988     0.200
     0.377     4.674     0.200
     0.511     4.010     0.200
     0.902    -0.722     0.200
     1.579    -4.503     0.200
     1.734    -7.907     0.200
     1.924    -7.172     0.200
     1.926    -6.328     0.200
     2.019    -6.742     0.200
     2.239   -10.096     0.200
     4.100   -19.617     0.200
     4.100   -23.024     0.200
     4.202   -23.423     0.200
     4.617   -27.500     0.200
     4.617   -27.601     0.200
     0.161    10.784     0.200
     0.244     8.657     0.200
     0.438     5.339     0.200
     0.888     1.820     0.200
     1.849    -7.587     0.200
     2.300   -12.823     0.200
     2.300   -11.425     0.200
     2.465    -8.158     0.200
     2.744   -12.903     0.200
     2.744   -13.504     0.200
     4.610   -25.165     0.200
     4.610   -26.165     0.200
     0.132    11.504     0.200
     0.269     9.817     0.200
     0.378     6.965     0.200
     0.557     3.263     0.200
     0.703     2.937     0.200
     1.005     0.092     0.200
     1.242    -1.145     0.200
     1.394    -3.423     0.200
     1.670    -6.985     0.200
     1.939    -6.076     0.200
     1.952    -7.852     0.200
     2.407   -12.359     0.200
     2.584   -10.153     0.200
     2.860   -14.900     0.200
     4.726   -24.273     0.200
     0.351     7.546     0.200
     0.472     5.764     0.200
     0.570     4.439     0.200
     0.630     3.179     0.200
     0.690     2.441     0.200
     0.803     1.487     0.200
     0.972    -0.283     0.200
     1.030    -1.528     0.200
     1.305    -3.973     0.200
     1.302    -1.485     0.200
     1.312    -3.927     0.200
     1.416    -2.506     0.200
     1.458    -3.206     0.200
     1.606    -4.604     0.200
     1.669    -2.991     0.200
     1.807    -6.473     0.200
     1.849    -8.890     0.200
     1.851    -7.844     0.200
     1.851    -8.969     0.200
     3.022   -15.303     0.200
     3.667   -18.440     0.200
     4.390   -25.976     0.200
     4.390   -23.676     0.200
     6.565   -39.701     0.200
     8.852   -58.403     0.200
    10.770   -67.803     0.200
    13.552   -86.398     0.200
    17.500  -119.347     0.200
    21.182  -153.067     0.200
     0.104     9.278     0.200
     0.434     3.318     0.200
     0.597     2.573     0.200
     1.079    -0.921     0.200
     1.215    -3.367     0.200
     1.243    -2.066     0.200
     1.810    -7.237     0.200
     1.899    -7.257     0.200
     1.898    -7.247     0.200
     2.547   -14.481     0.200
     2.682    -9.665     0.200
     2.976   -14.678     0.200
     2.976   -15.076     0.200
     4.737   -26.900     0.200
     4.840   -24.967     0.200
     4.840   -28.069     0.200
     8.649   -50.009     0.200
    12.303   -77.800     0.200
     0.143    11.001     0.200
     0.200     9.325     0.200
     0.637     3.606     0.200
     0.944     0.165     0.200
     1.308    -3.023     0.200
     1.752    -5.445     0.200
     2.045    -9.778     0.200
     2.045    -9.380     0.200
     2.217    -5.938     0.200
     2.489   -11.171     0.200
     2.489   -11.472     0.200
     4.356   -21.845     0.200
     4.356   -24.645     0.200
     4.536   -24.161     0.200
     4.536   -25.062     0.200
     7.057   -39.743     0.200
     8.445   -48.965     0.200
    12.802   -82.147     0.200
     0.608     3.249     0.200
     1.691    -5.939     0.200
     1.690    -6.729     0.200
     1.979    -7.150     0.200
     2.517   -12.762     0.200
     2.587    -7.573     0.200
     2.905   -11.940     0.200
     2.905   -12.440     0.200
     4.531   -25.480     0.200
     4.760   -23.561     0.200
     4.760   -24.960     0.200
     8.441   -46.747     0.200
     9.544   -67.292     0.200
     9.667   -55.422     0.200
    11.388   -72.064     0.200
    13.048   -83.897     0.200
    16.256  -109.873     0.200
     0.063    13.109     0.200
     0.338     8.141     0.200
     0.695     1.896     0.200
     0.733     2.836     0.200
     0.916     1.998     0.200
     1.070    -1.349     0.200
     1.121    -1.425     0.200
     1.124     1.549     0.200
     1.148    -0.987     0.200
     1.374    -1.963     0.200
     1.374    -1.609     0.200
     2.491   -14.434     0.200
     2.808   -12.599     0.200
     4.213   -23.229     0.200
     4.213   -22.929     0.200
     4.639   -22.042     0.200
     4.639   -24.842     0.200
     0.161     9.775     0.200
     0.254     8.884     0.200
     0.349     6.164     0.200
     0.318     7.818     0.200
     0.319     8.652     0.200
     0.467     6.318     0.200
     0.795     2.648     0.200
     1.088    -1.641     0.200
     1.464    -4.497     0.200
     2.202   -11.065     0.200
     2.374    -7.332     0.200
     2.649   -12.741     0.200
     2.649   -12.542     0.200
     4.515   -22.616     0.200
     4.515   -25.913     0.200
     4.629   -26.127     0.200
     4.629   -25.127     0.200
     6.903   -41.510     0.200
     8.541   -50.326     0.200
    13.079   -94.668     0.200
     0.186     9.530     0.200
     0.239     9.485     0.200
     2.266   -11.955     0.200
     2.266   -12.353     0.200
     2.456    -9.293     0.200
     2.725   -12.505     0.200
     2.725   -14.200     0.200
     4.592   -23.086     0.200
     0.135     9.370     0.200
     0.471     2.257     0.200
     0.515     2.812     0.200
     1.000    -0.892     0.200
     1.761    -7.518     0.200
     1.954    -6.834     0.200
     2.494   -13.458     0.200
     2.494   -12.857     0.200
     2.594    -7.915     0.200
     2.900   -13.333     0.200
     2.900   -12.931     0.200
     4.260   -22.325     0.200
     4.603   -24.111     0.200
     4.761   -24.098     0.200
     4.761   -26.098     0.200
     9.487   -68.275     0.200
    11.470   -74.594     0.200
    15.141  -108.163     0.200
     0.154    11.134     0.200
     0.254     8.770     0.200
     0.329     8.412     0.200
     0.328     9.262     0.200
     0.428     5.421     0.200
     0.642     4.131     0.200
     0.879     1.932     0.200
     1.155    -2.232     0.200
     1.233    -0.578     0.200
     1.456    -4.246     0.200
     1.560    -6.068     0.200
     1.826    -9.216     0.200
     2.297   -11.630     0.200
     2.737   -14.561     0.200
     4.647   -25.613     0.200
     0.198     9.161     0.200
     0.209     9.694     0.200
     0.297     8.694     0.200
     0.400     5.647     0.200
     0.434     7.335     0.200
     0.689     3.943     0.200
     0.847     2.260     0.200
     1.136    -1.819     0.200
     1.289    -1.092     0.200
     1.412    -3.429     0.200
     1.516    -4.656     0.200
     2.110    -8.224     0.200
     2.253   -12.128     0.200
     2.253   -12.832     0.200
     2.426    -7.688     0.200
     2.701   -13.120     0.200
     2.701   -12.323     0.200
     4.568   -22.392     0.200
     4.568   -26.994     0.200
     4.660   -24.618     0.200
     6.853   -38.051     0.200
    13.130   -95.421     0.200
    13.399   -86.436     0.200
    14.994  -105.993     0.200
    16.600  -112.400     0.200
     0.667     1.372     0.200
     1.820    -7.776     0.200
     2.543   -13.709     0.200
     2.911   -12.568     0.200
     2.911   -13.869     0.200
     4.456   -22.953     0.200
     4.456   -21.855     0.200
     4.760   -22.500     0.200
     0.216     8.832     0.200
     0.695     3.387     0.200
     0.878     1.488     0.200
     1.168    -3.041     0.200
     1.869    -7.844     0.200
     2.282   -12.076     0.200
     2.282   -12.277     0.200
     2.457    -7.929     0.200
     2.732   -12.240     0.200
     4.599   -23.013     0.200
     4.599   -24.914     0.200
     4.685   -24.261     0.200
     0.156    11.057     0.200
     0.249     8.646     0.200
     0.306     8.149     0.200
     0.307     8.049     0.200
     0.442     4.961     0.200
     0.662     2.821     0.200
     0.841     1.608     0.200
     1.172    -2.524     0.200
     1.247    -1.498     0.200
     1.334    -2.752     0.200
     1.567    -5.011     0.200
     2.066    -8.297     0.200
     2.304   -11.478     0.200
     2.304   -12.177     0.200
     2.469    -7.884     0.200
     2.748   -13.444     0.200
     2.748   -12.944     0.200
     4.614   -22.604     0.200
     4.670   -25.955     0.200
     4.670   -26.756     0.200
     6.814   -40.800     0.200
    12.343   -86.291     0.200
    21.305  -149.297     0.200
     0.142    10.555     0.200
     0.347     6.291     0.200
     0.306     8.649     0.200
     0.487     5.929     0.200
     0.718     2.022     0.200
     0.790     2.887     0.200
     1.089    -1.890     0.200
     1.351    -2.280     0.200
     1.350    -2.534     0.200
     1.454    -3.945     0.200
     2.191   -11.517     0.200
     2.191   -10.517     0.200
     2.370    -9.590     0.200
     2.642   -11.811     0.200
     4.509   -23.391     0.200
     4.509   -24.489     0.200
     4.640   -24.748     0.200
     0.228     9.142     0.200
     0.291     9.382     0.200
     0.433     5.459     0.200
     0.411     7.760     0.200
     0.681     3.837     0.200
     0.881     2.009     0.200
     1.270    -0.895     0.200
     1.447    -3.642     0.200
     1.551    -4.837     0.200
     1.859    -7.089     0.200
     1.858    -7.062     0.200
     2.289   -11.411     0.200
     2.736   -13.187     0.200
     4.602   -26.258     0.200
     4.677   -27.116     0.200
     0.208     9.397     0.200
     0.284     7.380     0.200
     0.543     3.458     0.200
     0.758     2.520     0.200
     0.984     1.208     0.200
     1.078    -1.584     0.200
     1.633    -5.877     0.200
     1.972    -5.111     0.200
     1.971    -6.750     0.200
     1.976    -7.034     0.200
     2.370   -12.841     0.200
     2.370   -13.138     0.200
     2.565   -10.422     0.200
     2.565   -12.320     0.200
     3.313   -17.839     0.200
     4.700   -25.000     0.200
     4.700   -27.203     0.200
     4.794   -26.389     0.200
     4.794   -26.194     0.200
    11.768   -78.158     0.200
    12.437   -85.961     0.200
    12.511   -79.543     0.200
     0.245     8.841     0.200
     0.319     9.086     0.200
     0.388     8.183     0.200
     0.427     5.664     0.200
     0.877     2.031     0.200
     0.937    -0.107     0.200
     1.451    -3.953     0.200
     1.555    -4.811     0.200
     1.834    -8.438     0.200
     2.292   -12.471     0.200
     2.454   -10.179     0.200
     2.734   -14.072     0.200
     3.233   -17.790     0.200
     4.600   -23.626     0.200
     4.654   -26.230     0.200
     0.216     9.555     0.200
     0.413     7.050     0.200
     0.322     9.011     0.200
     0.394     6.108     0.200
     0.663     3.285     0.200
     0.844     2.198     0.200
     1.126    -2.222     0.200
     1.265    -2.117     0.200
     1.416    -3.117     0.200
     1.521    -4.451     0.200
     1.823    -7.740     0.200
     1.822    -6.427     0.200
     1.822    -5.970     0.200
     1.822    -7.708     0.200
     2.113    -8.703     0.200
     2.113    -8.394     0.200
     2.421    -8.487     0.200
     2.700   -12.241     0.200
     2.700   -12.741     0.200
     4.567   -23.599     0.200
     4.639   -26.883     0.200
     4.639   -26.781     0.200
    10.950   -69.863     0.200
    11.743   -77.484     0.200
    12.594   -82.595     0.200
     0.325     7.141     0.200
     0.376     7.032     0.200
     0.551     3.557     0.200
     0.699     2.937     0.200
     1.000     0.540     0.200
     1.051    -1.356     0.200
     1.240    -1.564     0.200
     1.394    -3.751     0.200
     1.665    -6.836     0.200
     1.934    -7.369     0.200
     2.403   -13.409     0.200
     2.578    -9.970     0.200
     2.578   -12.071     0.200
     2.854   -14.030     0.200
     2.854   -13.729     0.200
     4.721   -23.100     0.200
     4.721   -25.901     0.200
     4.761   -27.770     0.200
     4.761   -26.770     0.200
     0.288     9.072     0.200
     0.330     7.662     0.200
     0.378     9.313     0.200
     0.557     5.867     0.200
     0.779     3.187     0.200
     0.788     2.004     0.200
     1.028    -0.040     0.200
     1.381    -3.605     0.200
     1.488    -4.975     0.200
     1.688    -6.802     0.200
     1.687    -6.765     0.200
     2.192    -9.999     0.200
     2.343    -7.162     0.200
     2.343    -9.063     0.200
     2.637   -11.911     0.200
     2.637   -11.710     0.200
     4.505   -24.724     0.200
     4.505   -24.224     0.200
     4.501   -21.977     0.200
     4.501   -22.176     0.200
    10.351   -64.329     0.200
    16.569  -113.854     0.200
    21.151  -148.775     0.200
     0.581     2.286     0.200
     0.632     1.746     0.200
     0.915    -0.499     0.200
     1.793    -6.837     0.200
     2.524   -13.395     0.200
     2.524   -12.696     0.200
     2.604   -10.127     0.200
     2.604   -11.830     0.200
     2.918   -12.284     0.200
     2.918   -13.784     0.200
     3.456   -18.338     0.200
     4.563   -24.049     0.200
     4.775   -22.356     0.200
     4.775   -26.454     0.200
    15.142  -107.101     0.200
     0.163     9.919     0.200
     0.361     6.024     0.200
     0.309     8.019     0.200
     0.465     5.231     0.200
     0.702     3.773     0.200
     0.806     2.469     0.200
     1.100    -2.036     0.200
     2.151    -9.583     0.200
     2.211   -11.163     0.200
     2.211   -11.757     0.200
     2.385    -9.490     0.200
     2.659   -11.881     0.200
     2.659   -13.975     0.200
     4.526   -23.250     0.200
     4.526   -26.453     0.200
     4.640   -24.969     0.200
     4.640   -25.867     0.200
     6.892   -41.780     0.200
     6.892   -41.053     0.200
     8.053   -52.141     0.200
     8.313   -54.657     0.200
     8.414   -55.034     0.200
     8.552   -49.870     0.200
    11.792   -75.886     0.200
    13.412   -90.137     0.200
    14.954  -103.412     0.200
    16.638  -114.695     0.200
    19.635  -139.148     0.200
     0.084     8.437     0.200
     0.684     0.708     0.200
     0.752     1.824     0.200
     1.007    -0.411     0.200
     1.085     1.338     0.200
     1.314    -4.122     0.200
     1.755    -7.662     0.200
     2.273    -9.757     0.200
     2.403    -8.110     0.200
     2.452   -13.852     0.200
     2.452   -13.651     0.200
     2.759   -11.794     0.200
     2.759   -10.394     0.200
     4.189   -25.541     0.200
     4.586   -20.914     0.200
     9.899   -70.725     0.200
     0.710     2.933     0.200
     0.719     1.217     0.200
     2.536   -12.620     0.200
     2.861    -9.432     0.200
     4.266   -20.864     0.200
     4.695   -20.660     0.200
     0.272     8.981     0.200
     1.868    -6.945     0.200
     2.117    -9.032     0.200
     0.808     3.010     0.200
     1.972    -8.171     0.200
     4.623   -29.102     0.200
     9.919   -73.327     0.200
    13.383   -87.698     0.200
     0.515     5.751     0.200
     1.756    -7.642     0.200
     1.966    -5.552     0.200
     0.316     8.048     0.200
     2.163    -8.788     0.200
     0.273     9.144     0.200
     1.869    -9.488     0.200
     2.113    -8.829     0.200
     2.113    -7.674     0.200
     4.714   -28.721     0.200
     5.610   -35.685     0.200
     8.012   -48.207     0.200
     8.310   -53.867     0.200
     9.504   -69.564     0.200
    10.519   -68.472     0.200
    13.428   -89.787     0.200
    14.487   -98.855     0.200
    14.614   -99.231     0.200
    17.733  -125.277     0.200
    17.965  -127.857     0.200
     0.303     8.337     0.200
     2.099    -8.360     0.200
     4.693   -26.812     0.200
    12.588   -80.409     0.200
    22.223  -156.166     0.200
     1.459    -0.433     0.200
     2.525    -7.334     0.200
     4.271   -19.247     0.200
     0.298     8.669     0.200
     0.298     7.401     0.200
     1.842    -8.513     0.200
     2.147    -8.699     0.200
     2.147    -9.003     0.200
     2.147    -9.303     0.200
     4.651   -23.513     0.200
     6.885   -38.155     0.200
     6.885   -40.084     0.200
     8.047   -51.307     0.200
     8.408   -51.439     0.200
     9.538   -70.616     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.471     3.847     0.200
     0.791     1.716     0.200
     1.556     1.466     0.200
     0.253     3.692     0.200
     0.769     2.336     0.200
     1.498     1.225     0.200
     3.345    -8.339     0.200
     0.452     3.178     0.200
     0.816     0.634     0.200
     1.350     0.482     0.200
     1.602     0.694     0.200
     4.765   -10.566     0.200
     0.529     3.094     0.200
     0.869     2.326     0.200
     1.532    -2.719     0.200
     2.209    -5.156     0.200
     0.678    -0.141     0.200
     1.023     1.026     0.200
     1.061     1.209     0.200
     1.271     0.158     0.200
     1.924    -4.366     0.200
     2.298    -3.998     0.200
     3.456    -8.717     0.200
     1.547     3.947     0.200
     1.809    -0.156     0.200
     3.136    -6.402     0.200
     0.935     1.129     0.200
     1.565     1.260     0.200
     1.698    -2.470     0.200
     2.033    -3.774     0.200
     2.271    -3.628     0.200
     0.925     2.227     0.200
     1.938    -3.798     0.200
     2.266    -3.979     0.200
     2.529    -2.312     0.200
     3.074    -8.296     0.200
     1.473    -1.314     0.200
     1.574     0.480     0.200
     1.464    -1.678     0.200
     1.552     1.346     0.200
     1.888    -4.318     0.200
     2.132    -3.343     0.200
     0.880     1.430     0.200
     1.619    -1.291     0.200
     1.544    -0.839     0.200
     0.882     1.454     0.200
     1.518    -0.404     0.200
     1.597     0.106     0.200
     1.482    -2.331     0.200
     0.832     0.644     0.200
     0.871     1.619     0.200
     1.586    -2.444     0.200
     1.556    -2.483     0.200
     1.608     0.210     0.200
     1.813    -2.496     0.200
     2.180    -4.238     0.200
     3.258    -8.303     0.200
     1.520     0.161     0.200
     1.866    -2.809     0.200
     0.843     1.831     0.200
     1.962    -3.231     0.200
     0.962     1.635     0.200
     1.656    -0.387     0.200
     1.976    -3.508     0.200
     1.226    -0.589     0.200
     1.563     1.942     0.200
     1.570    -1.093     0.200
     1.792    -3.532     0.200
     1.567     0.547     0.200
     3.149    -8.811     0.200
     0.929     1.827     0.200
     1.635    -0.153     0.200
     1.606    -1.228     0.200
     1.814    -3.153     0.200
     3.105    -8.670     0.200
     0.937     2.188     0.200
     1.186    -1.010     0.200
     1.582    -0.952     0.200
     1.724    -3.363     0.200
     1.972    -3.430     0.200
     1.234    -0.092     0.200
     1.499    -0.885     0.200
     1.490    -0.538     0.200
     1.426    -0.983     0.200
     3.374    -8.539     0.200
     0.851     1.148     0.200
     1.470    -2.381     0.200
     1.652     0.852     0.200
     2.183    -4.984     0.200
     3.144    -8.748     0.200
     0.851     2.373     0.200
     1.448     1.231     0.200
     1.491     1.600     0.200
     1.414    -0.559     0.200
     1.389     3.225     0.200
     1.570    -1.334     0.200
     1.956    -1.863     0.200
     2.476    -5.027     0.200
     3.263    -8.000     0.200
     4.723   -11.759     0.200
     0.833     1.072     0.200
     1.572    -0.639     0.200
     1.511    -1.703     0.200
     1.154    -1.136     0.200
     1.565    -2.471     0.200
     1.945    -4.128     0.200
     1.076     1.467     0.200
     1.841    -3.092     0.200
     1.286    -1.975     0.200
     1.596    -0.300     0.200
     1.976    -3.864     0.200
     2.264    -5.170     0.200
     0.906     1.363     0.200
     1.545    -2.595     0.200
     1.813    -2.899     0.200
     0.960     1.037     0.200
     1.625    -0.831     0.200
     1.658     0.316     0.200
     1.893    -3.532     0.200
     1.974    -3.776     0.200
     0.879     1.107     0.200
     0.801     1.337     0.200
     0.372     2.574     0.200
     1.091     0.083     0.200
     0.169     3.966     0.200
     1.399    -0.603     0.200
     0.211     4.628     0.200
     0.814     1.428     0.200
     1.460    -2.545     0.200
     0.670     1.013     0.200
     0.911     0.494     0.200
     1.028     2.891     0.200
     1.256     0.960     0.200
     1.299    -0.521     0.200
     1.287     2.152     0.200
     1.376     0.043     0.200
     1.452    -0.861     0.200
     1.410     0.260     0.200
     1.625    -1.662     0.200
     1.831    -2.563     0.200
     1.848    -2.926     0.200
     0.503     3.190     0.200
     0.673     1.014     0.200
     0.911     0.746     0.200
     1.257     1.173     0.200
     1.289     0.864     0.200
     1.379     0.426     0.200
     1.413    -0.546     0.200
     1.471    -0.402     0.200
     1.627    -1.029     0.200
     0.230     4.498     0.200
     0.441     3.297     0.200
     0.655     2.721     0.200
     0.743     2.624     0.200
     1.073     0.350     0.200
     1.111     0.168     0.200
     1.364    -0.856     0.200
     1.483    -1.228     0.200
     1.670    -1.573     0.200
     1.786    -3.561     0.200
     0.020     9.100     0.200
     0.410     2.145     0.200
     0.623     1.698     0.200
     0.929    -0.209     0.200
     1.075    -0.922     0.200
     1.835    -4.038     0.200
     1.136    -0.216     0.200
     1.191    -0.642     0.200
     1.388    -0.994     0.200
     1.705    -1.753     0.200
     1.846    -3.628     0.200
     1.890    -1.596     0.200
     2.517    -6.384     0.200
     0.263     2.926     0.200
     0.264     3.815     0.200
     0.692     0.239     0.200
     0.753    -0.194     0.200
     1.130    -0.349     0.200
     1.427    -1.469     0.200
     1.424     0.224     0.200
     1.720    -2.247     0.200
     1.755    -2.848     0.200
     0.260     5.010     0.200
     0.281     4.437     0.200
     0.697     1.752     0.200
     0.700     0.770     0.200
     1.110    -0.649     0.200
     1.376    -0.878     0.200
     0.199     4.142     0.200
     1.095     0.219     0.200
     1.203    -1.200     0.200
     1.670    -3.398     0.200
     0.247     3.931     0.200
     0.636     1.106     0.200
     0.698     0.544     0.200
     0.877     1.690     0.200
     1.060    -0.619     0.200
     0.737     0.837     0.200
     1.189    -0.688     0.200
     1.953    -4.401     0.200
     0.373     2.901     0.200
     0.629     1.484     0.200
     0.732     1.396     0.200
     0.908     1.128     0.200
     1.059    -0.263     0.200
     1.685    -2.542     0.200
     0.071     6.713     0.200
     0.549     1.171     0.200
     0.706     0.747     0.200
     0.992    -0.019     0.200
     0.121     5.438     0.200
     0.999     0.816     0.200
     0.088     5.208     0.200
     0.404     2.285     0.200
     0.690     0.706     0.200
     2.288    -5.648     0.200
     0.200     1.379     0.200
     0.757     1.961     0.200
     0.148     2.516     0.200
     0.851     1.959     0.200
     0.663     2.145     0.200
     0.776     0.665     0.200
     0.096     6.478     0.200
     0.371     4.375     0.200
     0.898     0.548     0.200
     1.150     0.059     0.200
     0.078     7.034     0.200
     0.372     4.201     0.200
     0.594     1.290     0.200
     0.754     1.214     0.200
     0.805     1.387     0.200
     0.916    -0.123     0.200
     1.177    -0.008     0.200
     1.626    -1.950     0.200
     0.310     3.788     0.200
     0.367     3.202     0.200
     0.585     2.884     0.200
     0.690     1.001     0.200
     0.760     3.401     0.200
     1.163    -0.245     0.200
     1.428    -1.476     0.200
     0.185     4.669     0.200
     0.390     2.094     0.200
     1.086    -0.627     0.200
     1.431    -2.112     0.200
     0.067     8.250     0.200
     0.398     3.559     0.200
     0.706     0.940     0.200
     0.010     8.947     0.200
     0.353     2.206     0.200
     0.410     3.978     0.200
     0.745     2.349     0.200
     0.899     2.380     0.200
     0.997    -0.282     0.200
     1.563    -2.182     0.200
     0.086     7.187     0.200
     0.432     1.296     0.200
     0.802     2.125     0.200
     0.994     1.574     0.200
     0.191     6.834     0.200
     0.315     3.199     0.200
     0.360     4.609     0.200
     0.595     1.824     0.200
     0.599     3.207     0.200
     0.722     2.643     0.200
     0.748     1.062     0.200
     0.804     1.588     0.200
     0.942     1.946     0.200
     1.213    -0.665     0.200
     0.110     7.463     0.200
     0.291     3.952     0.200
     0.403     3.720     0.200
     0.685     2.604     0.200
     0.738     0.787     0.200
     1.034     1.280     0.200
     0.079     8.179     0.200
     0.339     2.882     0.200
     0.688     1.293     0.200
     0.680     2.708     0.200
     0.749     1.051     0.200
     0.833     2.949     0.200
     0.064     8.433     0.200
     0.320     3.062     0.200
     0.706     1.078     0.200
     0.709     2.763     0.200
     1.508    -1.774     0.200
     0.076     7.869     0.200
     0.311     2.889     0.200
     0.663     1.369     0.200
     0.715     0.918     0.200
     0.704     2.959     0.200
     0.046     8.642     0.200
     0.324     2.961     0.200
     0.703     1.014     0.200
     0.728     2.374     0.200
     0.865     2.155     0.200
     1.032    -0.333     0.200
     1.102    -0.353     0.200
     1.093     1.777     0.200
     1.528    -2.603     0.200
     0.012    10.219     0.200
     0.365     3.044     0.200
     0.418     4.124     0.200
     0.670     1.606     0.200
     0.761     2.269     0.200
     0.980    -0.364     0.200
     1.253    -0.505     0.200
     0.186     6.548     0.200
     0.303     3.288     0.200
     0.372     4.109     0.200
     0.611     2.798     0.200
     0.755     0.881     0.200
     0.725     2.516     0.200
     0.951     1.465     0.200
     1.213    -1.462     0.200
     1.391    -1.595     0.200
     0.010    10.393     0.200
     0.357     2.808     0.200
     0.447     4.097     0.200
     0.419     4.419     0.200
     0.677     1.306     0.200
     0.758     2.353     0.200
     0.912     2.372     0.200
     0.989    -0.491     0.200
     1.090    -1.005     0.200
     1.135     0.952     0.200
     1.261    -0.534     0.200
     0.308     3.048     0.200
     0.606     3.289     0.200
     0.752     1.076     0.200
     0.723     2.917     0.200
     0.947     2.359     0.200
     1.197    -0.615     0.200
     1.213    -1.513     0.200
     1.389    -2.220     0.200
     1.389    -1.915     0.200
     1.390    -1.917     0.200
     0.076     8.306     0.200
     0.326     3.129     0.200
     0.384     4.267     0.200
     0.487     3.312     0.200
     0.671     1.255     0.200
     0.691     2.822     0.200
     0.700     1.074     0.200
     0.834     2.456     0.200
     1.056     1.367     0.200
     1.134    -0.750     0.200
     1.498    -1.907     0.200
     0.081     8.098     0.200
     0.343     2.785     0.200
     0.365     4.770     0.200
     0.685     1.003     0.200
     0.676     2.873     0.200
     0.833     2.253     0.200
     1.048     0.329     0.200
     1.499    -1.864     0.200
     0.017     8.893     0.200
     0.371     2.937     0.200
     0.664     1.177     0.200
     0.763     2.367     0.200
     0.926     2.225     0.200
     0.973    -0.120     0.200
     1.145     0.064     0.200
     1.247    -0.098     0.200
     1.589    -2.842     0.200
     0.028     8.412     0.200
     0.379     2.907     0.200
     0.696     1.483     0.200
     0.659     1.301     0.200
     0.772     2.473     0.200
     0.963    -0.211     0.200
     0.937     2.283     0.200
     1.156     0.173     0.200
     1.240    -0.433     0.200
     1.600    -3.107     0.200
     0.171     6.602     0.200
     0.312     3.209     0.200
     0.364     4.479     0.200
     0.546     4.098     0.200
     0.616     3.040     0.200
     0.741     2.779     0.200
     0.740     0.798     0.200
     0.790     0.926     0.200
     0.963     2.260     0.200
     1.230    -1.335     0.200
     1.407    -2.383     0.200
     0.074     8.036     0.200
     0.327     2.878     0.200
     0.699     0.918     0.200
     0.692     2.497     0.200
     0.835     2.896     0.200
     1.500    -1.198     0.200
     0.008     9.264     0.200
     0.367     2.406     0.200
     0.666     1.485     0.200
     0.703     1.575     0.200
     0.739     1.705     0.200
     0.755     2.419     0.200
     0.980    -0.007     0.200
     0.916     2.717     0.200
     1.580    -2.305     0.200
     0.109     7.230     0.200
     0.321     2.857     0.200
     0.710     1.094     0.200
     0.756     1.090     0.200
     0.662     2.700     0.200
     0.802     2.258     0.200
     1.467    -1.266     0.200
     0.014    10.079     0.200
     0.446     3.566     0.200
     0.420     4.313     0.200
     0.672     1.758     0.200
     0.695     1.211     0.200
     0.739     1.331     0.200
     0.763     2.230     0.200
     0.981    -0.427     0.200
     0.920     2.356     0.200
     1.254    -0.537     0.200
     0.102     7.416     0.200
     0.316     3.359     0.200
     0.650     1.755     0.200
     0.672     2.924     0.200
     0.807     2.872     0.200
     1.031     1.465     0.200
     1.146     0.027     0.200
     1.472    -1.996     0.200
     0.130     7.414     0.200
     0.291     3.480     0.200
     0.394     4.259     0.200
     0.498     3.970     0.200
     0.665     2.899     0.200
     0.742     0.671     0.200
     0.779     2.919     0.200
     1.011     1.373     0.200
     1.260    -1.188     0.200
     0.057     8.515     0.200
     0.329     2.680     0.200
     0.722     1.331     0.200
     0.697     1.096     0.200
     0.708     2.870     0.200
     0.851     2.326     0.200
     0.084     7.723     0.200
     0.331     2.881     0.200
     0.374     4.732     0.200
     0.697     0.989     0.200
     0.747     1.266     0.200
     0.679     2.816     0.200
     0.826     2.320     0.200
     1.046     0.929     0.200
     1.492    -2.170     0.200
     0.168     6.496     0.200
     0.288     3.146     0.200
     0.524     4.040     0.200
     0.592     1.634     0.200
     0.636     2.846     0.200
     0.741     2.989     0.200
     0.767     1.073     0.200
     0.973     2.114     0.200
     1.225    -1.106     0.200
     1.405    -2.418     0.200
     0.107     7.031     0.200
     0.297     2.827     0.200
     0.730     1.570     0.200
     0.683     2.635     0.200
     0.732     0.779     0.200
     0.803     2.581     0.200
     1.466    -1.271     0.200
     0.051     8.753     0.200
     0.329     2.952     0.200
     0.697     1.020     0.200
     0.716     2.556     0.200
     0.858     2.426     0.200
     1.083     1.212     0.200
     0.209     5.315     0.200
     0.738     3.136     0.200
     1.014     0.944     0.200
     0.062     8.223     0.200
     0.327     2.822     0.200
     0.704     2.621     0.200
     0.699     1.091     0.200
     0.846     2.762     0.200
     1.510    -2.823     0.200
     0.029     8.273     0.200
     0.378     3.076     0.200
     0.661     1.225     0.200
     0.757     0.876     0.200
     0.774     2.391     0.200
     0.963    -0.126     0.200
     0.938     2.080     0.200
     1.157     1.012     0.200
     1.241    -0.121     0.200
     1.601    -2.033     0.200
     0.088     7.555     0.200
     0.309     3.115     0.200
     0.728     1.633     0.200
     0.692     2.500     0.200
     0.718     1.024     0.200
     0.821     2.590     0.200
     1.067    -0.828     0.200
     0.114     3.411     0.200
     0.338     3.257     0.200
     0.680     1.292     0.200
     1.476    -0.501     0.200
     0.197     6.100     0.200
     0.300     3.148     0.200
     0.376     3.746     0.200
     0.580     2.721     0.200
     0.606     3.117     0.200
     0.764     0.629     0.200
     1.202    -0.915     0.200
     0.057     8.453     0.200
     0.326     2.677     0.200
     0.700     1.247     0.200
     0.711     2.591     0.200
     0.852     2.421     0.200
     1.039    -0.439     0.200
     1.077     1.371     0.200
     1.515    -1.939     0.200
     0.009     9.281     0.200
     0.365     2.920     0.200
     0.669     1.321     0.200
     0.758     2.284     0.200
     0.917     2.372     0.200
     0.981    -0.140     0.200
     1.138     1.222     0.200
     0.104     7.305     0.200
     0.295     2.873     0.200
     0.687     2.602     0.200
     0.733     1.088     0.200
     1.038     0.784     0.200
     1.468    -1.962     0.200
     0.078     8.078     0.200
     0.325     2.679     0.200
     0.702     1.008     0.200
     0.689     2.655     0.200
     0.831     2.626     0.200
     1.054     1.295     0.200
     0.048     7.516     0.200
     0.339     2.908     0.200
     0.391     4.018     0.200
     0.687     0.978     0.200
     1.026    -0.274     0.200
     1.525    -2.132     0.200
     0.179     6.567     0.200
     0.312     3.075     0.200
     0.363     4.287     0.200
     0.551     4.115     0.200
     0.610     3.168     0.200
     0.733     2.814     0.200
     0.744     0.786     0.200
     0.794     1.327     0.200
     0.955     2.094     0.200
     1.223    -0.969     0.200
     0.360     3.065     0.200
     0.805     3.443     0.200
     1.073     0.788     0.200
     1.299    -1.567     0.200
     0.041     9.267     0.200
     0.326     3.531     0.200
     0.452     3.753     0.200
     0.414     4.035     0.200
     0.692     1.695     0.200
     0.733     2.466     0.200
     0.871     2.215     0.200
     1.533    -2.664     0.200
     0.305     2.984     0.200
     0.638     2.869     0.200
     0.738     0.715     0.200
     0.770     1.152     0.200
     1.246    -1.529     0.200
     1.426    -2.251     0.200
     0.091     7.951     0.200
     0.825     1.879     0.200
     1.586    -2.888     0.200
     0.201     5.733     0.200
     0.506     4.472     0.200
     0.654     2.440     0.200
     1.373    -0.843     0.200
     0.053     7.367     0.200
     0.727    -0.191     0.200
     0.708     0.389     0.200
     1.340    -1.348     0.200
     1.588    -1.926     0.200
     0.066     8.279     0.200
     0.394     4.382     0.200
     0.476     3.819     0.200
     0.702     1.085     0.200
     0.703     2.644     0.200
     0.843     2.679     0.200
     0.036     9.582     0.200
     0.425     4.100     0.200
     0.443     3.840     0.200
     0.673     1.366     0.200
     0.684     1.279     0.200
     0.785     2.204     0.200
     0.979    -0.376     0.200
     0.933     1.994     0.200
     1.161     0.799     0.200
     1.263    -0.539     0.200
     0.010     9.281     0.200
     0.352     2.943     0.200
     0.679     1.280     0.200
     0.700     1.626     0.200
     0.723     0.964     0.200
     0.749     2.425     0.200
     0.902     2.170     0.200
     0.997    -0.321     0.200
     1.565    -2.533     0.200
     0.003     9.567     0.200
     0.360     2.876     0.200
     0.672     1.458     0.200
     0.703     1.872     0.200
     0.751     2.431     0.200
     0.908     2.238     0.200
     0.989    -0.032     0.200
     1.129     0.785     0.200
     1.257    -0.331     0.200
     1.572    -2.467     0.200
     0.079     5.693     0.200
     0.443     3.408     0.200
     1.863    -3.223     0.200
     2.899    -6.249     0.200
     0.211     5.658     0.200
     0.311     2.800     0.200
     0.366     4.182     0.200
     0.701     3.112     0.200
     1.193    -0.842     0.200
     1.368    -1.539     0.200
     0.115     6.323     0.200
     0.404     3.349     0.200
     0.795     3.238     0.200
     2.750    -4.542     0.200
     0.065     7.929     0.200
     0.331     2.675     0.200
     0.387     4.111     0.200
     0.699     2.436     0.200
     0.695     1.142     0.200
     0.845     2.317     0.200
     1.067     1.139     0.200
     1.041    -0.646     0.200
     1.509    -2.734     0.200
     0.299     3.073     0.200
     0.513     3.887     0.200
     0.650     2.658     0.200
     0.758     1.399     0.200
     0.739     0.632     0.200
     1.252    -0.812     0.200
     0.148     5.934     0.200
     0.315     2.587     0.200
     0.365     4.508     0.200
     0.728     1.139     0.200
     0.778     1.560     0.200
     1.108    -0.728     0.200
     1.178     0.271     0.200
     1.429    -2.259     0.200
     0.135     6.567     0.200
     0.327     3.236     0.200
     0.356     4.353     0.200
     0.533     3.847     0.200
     0.635     2.999     0.200
     0.712     0.903     0.200
     0.779     2.995     0.200
     0.995     0.851     0.200
     0.130     6.670     0.200
     0.308     2.619     0.200
     0.377     3.419     0.200
     0.759     2.020     0.200
     0.728     0.879     0.200
     1.005     0.811     0.200
     1.445    -1.272     0.200
     2.758    -5.993     0.200
     0.319     3.264     0.200
     0.245     1.938     0.200
     0.413     1.593     0.200
     0.513     1.704     0.200
     0.477     1.301     0.200
     1.007     0.355     0.200
     1.092     1.518     0.200
     0.188     6.432     0.200
     0.316     2.927     0.200
     0.359     4.528     0.200
     0.600     3.072     0.200
     0.745     1.001     0.200
     0.803     0.913     0.200
     0.945     1.893     0.200
     1.204     0.972     0.200
     1.216    -1.363     0.200
     1.391    -1.864     0.200
     0.034     8.235     0.200
     0.345     2.618     0.200
     0.671     0.719     0.200
     0.694     1.187     0.200
     0.780     2.121     0.200
     0.920     2.143     0.200
     0.994     0.035     0.200
     0.195     3.976     0.200
     0.279     3.122     0.200
     0.396     2.274     0.200
     0.396     2.004     0.200
     0.460     2.753     0.200
     1.745    -2.124     0.200
     2.316    -5.757     0.200
     0.142     6.022     0.200
     0.317     4.607     0.200
     0.367     2.497     0.200
     0.790     2.679     0.200
     0.989     1.556     0.200
     1.211    -1.167     0.200
     1.458    -2.448     0.200
     2.806    -7.856     0.200
     0.379     1.535     0.200
     0.608     0.742     0.200
     0.738     0.966     0.200
     0.092     5.917     0.200
     0.704     0.302     0.200
     0.827     2.356     0.200
     1.095     1.127     0.200
     1.617    -1.889     0.200
     2.582    -4.855     0.200
     0.073     7.186     0.200
     0.413     2.005     0.200
     0.771     1.187     0.200
     0.935     1.208     0.200
     1.131    -0.669     0.200
     1.724    -2.887     0.200
     0.291     3.832     0.200
     0.921     2.152     0.200
     1.026    -0.130     0.200
     2.512    -4.661     0.200
     0.716     0.883     0.200
EOF
gmt end
