#!/bin/bash
gmt begin sapporo1.54_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional sapporo1.54'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.000    38.968
    14.500    38.690
    15.000    38.410
    15.500    38.127
    16.000    37.839
    16.500    37.546
    17.000    37.244
    17.500    36.933
    18.000    36.611
    18.500    36.275
    19.000    35.923
    19.500    35.553
    20.000    35.162
    20.500    34.749
    21.000    34.311
    21.500    33.847
    22.000    33.353
    22.500    32.829
    23.000    32.272
    23.500    31.387
    24.000    30.120
    24.500    28.844
    25.000    27.558
    25.500    26.261
    26.000    24.953
    26.500    23.633
    27.000    22.299
    27.500    20.948
    28.000    19.577
    28.500    18.193
    29.000    16.799
    29.500    15.397
    30.000    13.987
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    16.577 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     0.500     5.130
     1.000     5.824
     1.500     6.787
     2.000     7.793
     2.500     8.812
     3.000     9.837
     3.500    10.863
     4.000    11.891
     4.500    12.918
     5.000    13.944
     5.500    14.971
     6.000    15.996
     6.500    17.019
     7.000    18.041
     7.500    19.061
     8.000    20.079
     8.500    21.095
     9.000    22.108
     9.500    23.119
    10.000    24.126
    10.500    25.131
    11.000    26.133
    11.500    27.132
    12.000    28.127
    12.500    29.119
    13.000    30.106
    13.500    31.090
    14.000    32.070
    14.500    32.945
    15.000    33.669
    15.500    34.352
    16.000    34.909
    16.500    35.393
    17.000    35.813
    17.500    36.288
    18.000    36.585
    18.500    36.826
    19.000    37.010
    19.500    37.138
    20.000    37.207
    20.500    37.219
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    27.106 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    -3.000 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     0.500    13.522
     1.000    19.216
     1.500    25.394
     2.000    31.649
     2.500    37.927
     3.000    44.214
     3.500    50.505
     4.000    56.798
     4.500    63.092
     5.000    69.385
     5.500    75.677
     6.000    81.967
     6.500    88.256
     7.000    94.542
     7.500   100.825
     8.000   107.106
     8.500   113.382
     9.000   119.655
     9.500   125.925
    10.000   132.190
    10.500   138.451
    11.000   144.707
    11.500   150.959
    12.000   157.206
    12.500   163.447
    13.000   169.682
    13.500   175.912
    14.000   182.136
    14.500   188.353
    15.000   194.564
    15.500   200.769
    16.000   206.966
    16.500   213.156
    17.000   219.338
    17.500   230.172
    18.000   236.422
    18.500   242.659
    19.000   248.883
    19.500   255.093
    20.000   261.289
    20.500   267.470
    21.000   273.636
    21.500   279.787
    22.000   285.922
    22.500   292.041
    23.000   298.143
    23.500   304.229
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    54.798 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    -3.000 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    20.419   249.331     0.150
    20.767   260.265     0.150
    21.847   267.667     0.150
    14.431   202.064     0.150
    14.673   208.243     0.150
    14.673   208.043     0.150
    20.999   252.413     0.150
    21.333   262.512     0.150
    22.426   268.757     0.150
    25.397   283.089     0.150
    28.383   295.241     0.150
    28.496   300.919     0.150
    21.462   260.198     0.150
    21.235   266.891     0.150
    27.946   299.021     0.150
    14.001   206.990     0.150
    23.898    30.599     0.150
    23.898   282.400     0.150
    27.867   300.376     0.150
    28.597   209.860     0.150
    28.597   307.860     0.150
    21.445   257.963     0.150
    27.986   299.629     0.150
    27.951   299.296     0.150
    28.464   295.811     0.150
    27.638   302.329     0.150
    21.220   280.428     0.150
    21.429   259.289     0.150
    24.421   284.074     0.150
    27.593  -307.013     0.150
    27.593   295.049     0.150
     4.799    39.633     0.150
    28.010   299.456     0.150
    28.472   302.209     0.150
    21.478   260.704     0.150
    21.458   707.904     0.150
    21.381   273.474     0.150
    21.431   267.865     0.150
    21.431    55.061     0.150
    21.431   715.662     0.150
    17.354   235.333     0.150
    19.981   255.676     0.150
    20.555   256.968     0.150
    21.370   268.065     0.150
    21.363   266.547     0.150
    21.628   268.056     0.150
    23.465   280.020     0.150
    25.387   291.590     0.150
    26.330   292.875     0.150
    27.624   302.480     0.150
    28.116   304.733     0.150
    29.605  -341.392     0.150
    29.605   312.359     0.150
    21.338   267.326     0.150
    21.338   715.928     0.150
    21.549   267.464     0.150
    27.664  -315.841     0.150
    27.664  -316.040     0.150
    28.164   215.474     0.150
    28.558   307.372     0.150
    21.312   266.627     0.150
    21.378   267.373     0.150
    21.368   268.320     0.150
    20.031   256.256     0.150
    21.303    54.313     0.150
    21.303   716.712     0.150
    21.532   266.951     0.150
    21.532    54.850     0.150
    21.532   276.951     0.150
    21.532   298.748     0.150
    27.620  -314.428     0.150
    27.620  -314.827     0.150
    21.298   264.026     0.150
    21.353   262.681     0.150
    21.295   718.442     0.150
    21.554    57.224     0.150
    23.461   280.967     0.150
    27.577   302.438     0.150
    21.282   262.830     0.150
    21.282    57.431     0.150
    21.282   714.830     0.150
    21.592   269.010     0.150
    21.592    57.811     0.150
    20.117   254.667     0.150
    21.398   264.918     0.150
    21.398    56.918     0.150
    21.587   268.712     0.150
    23.602   279.500     0.150
    27.730   300.327     0.150
    28.506   309.762     0.150
    21.290   261.982     0.150
    23.675   276.294     0.150
    28.275   374.610     0.150
    18.494   258.619     0.150
    21.323   267.514     0.150
    21.323   281.514     0.150
    21.369   259.482     0.150
    19.549   240.220     0.150
    20.701   250.876     0.150
    21.078   253.771     0.150
    21.078   288.771     0.150
    21.179   258.791     0.150
    28.004  -299.808     0.150
    28.004   293.646     0.150
    28.329   293.857     0.150
    28.549   295.291     0.150
    21.433    54.697     0.150
    21.433   706.298     0.150
    21.458   260.600     0.150
    21.458    56.100     0.150
    28.474   298.023     0.150
    28.474   210.023     0.150
    21.449   257.878     0.150
    21.449    50.878     0.150
    21.449   291.081     0.150
    21.449   707.175     0.150
    21.487   261.432     0.150
    21.487   294.432     0.150
    26.587   295.415     0.150
    27.954   294.469     0.150
    21.457   258.265     0.150
    20.781   288.550     0.150
    21.023   254.722     0.150
    21.819   265.935     0.150
    23.929   276.809     0.150
    25.846   290.432     0.150
    26.614  -289.087     0.150
    26.614   294.472     0.150
    27.972  -311.032     0.150
    27.972   298.628     0.150
    27.972  -311.732     0.150
    28.019  -306.981     0.150
    28.485   298.634     0.150
    21.413   707.485     0.150
    21.484   259.857     0.150
    21.484   295.357     0.150
    27.890  -312.472     0.150
    28.400   301.643     0.150
    21.413   272.538     0.150
    23.883   274.706     0.150
    28.433   301.606     0.150
    21.433    56.255     0.150
    21.433   708.255     0.150
    22.272   272.460     0.150
    23.899   276.477     0.150
     9.946    35.027     0.150
     9.946    40.027     0.150
    20.177   503.625     0.150
    20.535   273.445     0.150
    20.759   256.337     0.150
    21.384   263.537     0.150
    21.384   295.537     0.150
    21.384   713.537     0.150
    24.423   285.078     0.150
    25.590   288.460     0.150
    25.590   356.460     0.150
    26.384  -295.903     0.150
    26.384   297.191     0.150
    27.762   298.113     0.150
    20.349   251.808     0.150
    21.421   258.301     0.150
    21.421   705.301     0.150
    27.895  -311.037     0.150
    27.895  -311.537     0.150
    28.405   299.789     0.150
    21.309   257.819     0.150
    21.415   258.285     0.150
    21.415   296.285     0.150
    21.415   707.285     0.150
    28.419   205.544     0.150
    16.712   221.741     0.150
    21.439   296.583     0.150
    21.439   707.583     0.150
    21.462   262.314     0.150
    28.481   209.400     0.150
    20.963   254.004     0.150
    21.308   291.977     0.150
    21.308   706.977     0.150
    21.788   264.380     0.150
    25.809   288.447     0.150
    27.837  -301.857     0.150
    28.355   297.738     0.150
    28.711    33.278     0.150
    10.168    41.735     0.150
    20.417   252.132     0.150
    20.417   282.132     0.150
    21.438   262.218     0.150
    21.438   706.218     0.150
    21.474    57.996     0.150
    21.474   262.796     0.150
    21.474   298.796     0.150
    23.905   304.422     0.150
    27.949   298.229     0.150
    27.996  -307.210     0.150
    28.462   301.242     0.150
    25.508   236.297     0.150
    25.532   235.699     0.150
    25.530   235.409     0.150
    21.454   261.302     0.150
    25.491   236.691     0.150
    27.817  -311.532     0.150
    21.149   257.303     0.150
    17.664    43.686     0.150
    25.483   234.878     0.150
    21.326   259.768     0.150
    29.732   301.672     0.150
     2.648    26.525     0.150
     2.648    31.625     0.150
     4.515    38.040     0.150
     4.638    35.096     0.150
    12.659   364.096     0.150
    21.302   257.635     0.150
    28.183   210.344     0.150
    28.183   211.136     0.150
    28.359   209.080     0.150
    16.615   222.872     0.150
    21.394   264.099     0.150
    25.780   287.917     0.150
    26.584   296.535     0.150
    28.171   301.014     0.150
    21.093   263.960     0.150
    19.984   254.494     0.150
    20.566   259.710     0.150
    23.470   279.813     0.150
    23.885   283.272     0.150
    25.402   293.269     0.150
    26.216   297.771     0.150
    10.004    47.015     0.150
    25.565   234.218     0.150
     4.530    36.099     0.150
    10.978    41.681     0.150
    28.379   209.323     0.150
    28.677    65.838     0.150
    28.677   298.033     0.150
    12.618   364.338     0.150
    20.341   253.119     0.150
    21.339    51.965     0.150
    23.548   274.893     0.150
    27.844  -310.544     0.150
    27.844   660.151     0.150
    28.359   209.441     0.150
    10.005    46.562     0.150
    10.005   388.562     0.150
    10.005   594.562     0.150
    10.005   602.062     0.150
    10.005   809.359     0.150
    10.053    35.146     0.150
    21.305   258.634     0.150
    20.376   254.626     0.150
    21.811   265.578     0.150
    21.185   255.999     0.150
    10.577    37.217     0.150
    10.577    44.217     0.150
    22.373   271.257     0.150
    24.105   251.550     0.150
    24.105   280.550     0.150
    24.105   465.550     0.150
    24.105   469.847     0.150
    20.675    78.121     0.150
    20.675   261.422     0.150
     6.858    32.335     0.150
     8.246    40.635     0.150
     8.616    35.319     0.150
    11.016    38.815     0.150
    15.032   762.442     0.150
    20.696    56.850     0.150
    21.349   706.522     0.150
    21.435    58.122     0.150
    21.435   260.524     0.150
    24.026   248.381     0.150
    27.831    64.778     0.150
    28.344   209.492     0.150
    20.763    39.488     0.150
    20.763   259.088     0.150
    21.774   267.384     0.150
    23.485   466.820     0.150
    25.768   232.477     0.150
    28.323    81.456     0.150
     4.473    35.930     0.150
     4.798    27.135     0.150
     4.798    33.135     0.150
    21.934   268.167     0.150
    28.740   207.337     0.150
     4.633    44.911     0.150
    21.298   707.132     0.150
    21.350    58.421     0.150
    24.009   245.093     0.150
    28.653   206.693     0.150
    29.457   199.655     0.150
     4.523    29.176     0.150
     4.668    33.988     0.150
     6.826    39.801     0.150
    20.777   260.701     0.150
    20.777    52.099     0.150
    20.777    61.498     0.150
    20.777   284.295     0.150
    21.333   707.898     0.150
    21.804   269.011     0.150
    25.827   289.065     0.150
    26.349   228.426     0.150
    27.868  -311.318     0.150
    28.683  -323.234     0.150
    28.683    66.829     0.150
    28.683   207.227     0.150
    10.045    31.167     0.150
    20.796    52.897     0.150
    20.796   259.397     0.150
    20.796   278.897     0.150
    21.813   265.037     0.150
    21.813   306.037     0.150
     2.858    24.645     0.150
    23.420   474.680     0.150
    10.088    29.052     0.150
    21.791   263.975     0.150
    23.568   272.341     0.150
    23.568   324.041     0.150
    23.568   473.341     0.150
    28.365   208.166     0.150
    29.444   198.847     0.150
    29.444   302.727     0.150
     4.665    35.157     0.150
    10.106    41.055     0.150
    10.106   604.258     0.150
    20.777    56.427     0.150
    21.330   260.070     0.150
    21.330   292.070     0.150
    21.330   707.672     0.150
    21.379    57.800     0.150
    21.803   269.147     0.150
    21.803   286.147     0.150
    21.803   307.147     0.150
    23.585   471.560     0.150
    27.865  -312.582     0.150
    16.612    49.826     0.150
    20.331   260.927     0.150
    20.331   288.927     0.150
    20.729   281.786     0.150
    21.397   291.985     0.150
    22.744   279.566     0.150
    23.537   255.514     0.150
    23.537   276.217     0.150
    23.537   322.014     0.150
    23.537   466.217     0.150
    23.537   474.217     0.150
    26.580   295.498     0.150
    28.170   210.748     0.150
     9.984   390.701     0.150
    21.271   261.483     0.150
    26.228   228.841     0.150
    28.094  -309.553     0.150
    28.695    65.843     0.150
    21.210   261.320     0.150
    21.822   297.383     0.150
    28.250    84.873     0.150
     2.688    22.349     0.150
     6.792    29.452     0.150
    10.037    31.190     0.150
    10.037   391.386     0.150
    10.037   599.589     0.150
    10.037   605.190     0.150
    21.287   257.591     0.150
    21.287   289.192     0.150
    21.369    53.642     0.150
    23.518   274.768     0.150
    23.518   324.768     0.150
    23.518   473.565     0.150
    10.018    47.251     0.150
    10.018   595.548     0.150
    18.610   233.080     0.150
    20.691   258.494     0.150
    21.305   261.927     0.150
    21.305   296.130     0.150
    21.305   706.927     0.150
    21.402   273.697     0.150
    21.714   289.751     0.150
    23.492   254.103     0.150
    23.492   274.299     0.150
    23.492   326.603     0.150
    26.263   228.466     0.150
    27.789  -311.503     0.150
    28.179   297.795     0.150
    16.649    45.093     0.150
    16.649    52.995     0.150
    20.768   262.728     0.150
    21.318   261.313     0.150
    21.318   709.012     0.150
    22.177   268.289     0.150
    26.331   228.386     0.150
    27.849  -312.294     0.150
    10.164   598.437     0.150
    10.164   603.937     0.150
    10.164   813.234     0.150
    16.686    47.326     0.150
    21.427   260.599     0.150
    21.427   708.099     0.150
    23.628   255.819     0.150
    23.628   276.116     0.150
    23.628   301.616     0.150
    23.628   329.319     0.150
    23.628   467.819     0.150
    23.628   474.116     0.150
    26.414   227.102     0.150
    28.759  -321.817     0.150
    28.759   300.340     0.150
    10.476   595.428     0.150
    10.476   601.428     0.150
    10.476   810.729     0.150
    13.070   568.759     0.150
    17.072    43.949     0.150
    17.072    52.449     0.150
    17.072   242.949     0.150
    18.777   246.052     0.150
    20.784   255.639     0.150
    21.170   263.124     0.150
    21.398   261.767     0.150
    21.398   291.466     0.150
    22.207   267.533     0.150
    24.254   685.942     0.150
    24.282   281.111     0.150
    26.232   291.053     0.150
    28.167    65.970     0.150
    28.167   298.868     0.150
    28.385   209.728     0.150
    28.385   301.427     0.150
    28.385   386.427     0.150
    28.499  -319.286     0.150
    28.499    65.999     0.150
    28.499   297.101     0.150
    28.516   303.102     0.150
    10.064   597.276     0.150
    10.064   603.971     0.150
    10.064   811.971     0.150
    21.317   259.790     0.150
    21.317   257.853     0.150
    23.541   256.498     0.150
    23.541   274.294     0.150
    23.541   325.396     0.150
    27.931   297.970     0.150
    28.695   205.554     0.150
    23.499   277.439     0.150
    23.508   279.004     0.150
    23.508   297.602     0.150
    23.508   327.602     0.150
    10.088   387.030     0.150
    10.088   602.030     0.150
    10.088   811.030     0.150
    23.572   278.975     0.150
    23.572   322.975     0.150
    23.572   692.771     0.150
    28.508    71.515     0.150
     9.997   601.113     0.150
    21.290   261.523     0.150
    21.290   709.322     0.150
    23.473   256.753     0.150
    23.473   274.352     0.150
    23.473   323.352     0.150
    23.473   470.053     0.150
    23.473   474.952     0.150
    25.721   288.815     0.150
    27.863   301.414     0.150
    28.110   212.199     0.150
    28.710   298.639     0.150
    23.486   257.550     0.150
    23.486   273.452     0.150
    23.486   322.952     0.150
    23.486   467.651     0.150
    23.486   692.651     0.150
    26.302   228.297     0.150
    22.480   271.294     0.150
    22.480   488.994     0.150
    12.641   364.171     0.150
    12.641   364.170     0.150
    21.305   259.762     0.150
    21.368   261.906     0.150
    22.159    56.993     0.150
    22.159   273.188     0.150
    23.554   323.714     0.150
    26.313   228.086     0.150
    28.174   302.000     0.150
    10.041   392.415     0.150
    10.041   602.212     0.150
    10.041   606.115     0.150
    12.594   364.212     0.150
    20.912   256.839     0.150
    20.912   284.042     0.150
    21.315   259.292     0.150
    21.315   706.347     0.150
    23.516   277.861     0.150
    23.804   279.298     0.150
    23.804   327.594     0.150
    26.285   228.545     0.150
    26.563   297.796     0.150
    28.152   211.377     0.150
    28.152   297.658     0.150
    28.709    65.659     0.150
    28.709   205.928     0.150
    29.388   200.414     0.150
    20.408   260.474     0.150
    20.408   284.575     0.150
    20.408   722.278     0.150
    22.299   279.210     0.150
    20.262   256.355     0.150
    20.262   285.855     0.150
    21.290   258.757     0.150
    23.467   324.449     0.150
    20.511   263.028     0.150
    20.511   278.328     0.150
    23.131   286.680     0.150
    23.131   329.680     0.150
     9.737   401.535     0.150
     9.737   615.035     0.150
    20.538   263.294     0.150
    23.173   282.937     0.150
    23.173   326.539     0.150
    23.442    64.306     0.150
    23.442   329.407     0.150
    25.376   294.332     0.150
    27.532    72.567     0.150
    27.532   379.270     0.150
    27.583   307.781     0.150
    23.206    69.296     0.150
    23.206   285.296     0.150
    23.206   290.597     0.150
    23.206   329.296     0.150
    23.206   482.796     0.150
     9.973    31.909     0.150
    23.426    65.207     0.150
    23.426   276.605     0.150
    23.426   327.406     0.150
    23.426   694.707     0.150
    28.664    69.625     0.150
     9.967    42.686     0.150
    12.617   363.314     0.150
    12.617   363.313     0.150
    20.276   251.685     0.150
    21.156   256.810     0.150
    21.156   708.411     0.150
    26.195   228.192     0.150
    26.195   442.273     0.150
    27.893    68.492     0.150
    27.893   295.793     0.150
    27.893   320.793     0.150
    27.893   381.092     0.150
    28.043   211.073     0.150
    28.043   210.692     0.150
    28.043   297.343     0.150
    16.575    49.025     0.150
    20.899   257.061     0.150
    21.266   260.185     0.150
    21.266   708.885     0.150
    21.732   266.644     0.150
    23.491    63.322     0.150
    23.491   274.822     0.150
    23.491   298.822     0.150
    23.491   325.522     0.150
    24.687    69.360     0.150
    25.752   288.232     0.150
    26.571   294.071     0.150
    27.889    73.697     0.150
    10.080    29.497     0.150
    10.080    36.997     0.150
    12.637   574.215     0.150
    16.634   752.010     0.150
    20.956   259.082     0.150
    22.172    54.290     0.150
    22.172   271.391     0.150
    23.558   327.714     0.150
    23.847    60.339     0.150
    24.022   686.598     0.150
    25.799   288.056     0.150
    26.602   298.690     0.150
    27.947    71.295     0.150
    27.947   300.494     0.150
    27.947   320.795     0.150
    27.947   656.494     0.150
    28.185   300.611     0.150
    28.360   302.975     0.150
    28.450    70.515     0.150
    23.517   279.050     0.150
     9.988    42.511     0.150
    12.543   363.841     0.150
    28.723    69.769     0.150
    21.315    57.615     0.150
    21.315   262.514     0.150
    21.315   293.714     0.150
    21.319   263.357     0.150
    21.319   274.755     0.150
    21.319   293.959     0.150
    21.319   704.654     0.150
     8.806   836.901     0.150
    19.797   261.346     0.150
    20.666    54.300     0.150
    20.666   290.703     0.150
    22.622   279.677     0.150
    25.066   466.816     0.150
    26.757   231.209     0.150
    29.594    78.008     0.150
    29.594   405.309     0.150
    20.042   257.500     0.150
    20.764   288.181     0.150
    20.764   288.782     0.150
    25.851   451.057     0.150
    20.778    45.629     0.150
     9.707    43.629     0.150
    16.267   223.276     0.150
    21.158   258.205     0.150
    21.158   708.705     0.150
    25.959   444.813     0.150
    12.640   364.436     0.150
    16.635    52.921     0.150
    16.635   221.320     0.150
    20.351   261.251     0.150
    21.309   259.337     0.150
    21.309   259.167     0.150
    21.373   262.579     0.150
    23.555   276.159     0.150
    23.555   301.058     0.150
    25.803   289.828     0.150
    26.316   227.711     0.150
    26.316   440.504     0.150
    27.948   300.401     0.150
    28.177    86.827     0.150
    28.735    71.076     0.150
    28.735   204.076     0.150
    10.053    43.169     0.150
    11.774    47.880     0.150
    12.605   363.983     0.150
    18.876   243.098     0.150
    19.726   276.284     0.150
    21.320   258.974     0.150
    21.320   708.575     0.150
    21.746   268.814     0.150
    21.746   304.611     0.150
    24.724   284.552     0.150
    26.297   228.481     0.150
    27.915   213.711     0.150
    28.163   301.618     0.150
    28.707  -312.507     0.150
    28.707   206.180     0.150
    21.309    59.675     0.150
    22.236   264.361     0.150
    24.715   281.923     0.150
    26.286   227.185     0.150
    26.286   440.509     0.150
    28.700    67.220     0.150
    10.079    42.310     0.150
    11.799    46.730     0.150
    19.752    51.920     0.150
    19.752   254.420     0.150
    20.348   281.960     0.150
    21.770   266.373     0.150
    21.770   287.373     0.150
    22.269   270.543     0.150
    22.269   307.844     0.150
    23.842   277.986     0.150
    24.751   242.583     0.150
    24.751   285.083     0.150
    24.751   343.884     0.150
    24.751   457.884     0.150
    25.095    66.562     0.150
    25.792   290.429     0.150
    26.322   228.453     0.150
    27.941    71.150     0.150
    28.187   297.982     0.150
     9.077   403.111     0.150
     9.077   618.111     0.150
    10.782    40.110     0.150
    10.782    46.110     0.150
    15.793   221.637     0.150
    18.768    55.322     0.150
    20.152   256.971     0.150
    20.177   261.981     0.150
    20.177   282.379     0.150
    21.153    57.183     0.150
    21.416    60.817     0.150
    23.806   335.322     0.150
    24.290   287.472     0.150
    24.290   303.569     0.150
    25.300   454.824     0.150
    29.929   312.566     0.150
    10.486   594.671     0.150
    10.486   601.070     0.150
    20.185    50.888     0.150
    20.185    53.988     0.150
    20.185    59.288     0.150
    20.185   278.688     0.150
    21.209   259.540     0.150
    21.336   265.453     0.150
    24.363   340.030     0.150
    25.226    67.254     0.150
    25.226   311.754     0.150
    25.226   349.554     0.150
    25.647   286.346     0.150
    25.647   312.247     0.150
    26.669   223.223     0.150
    26.669   437.600     0.150
    10.046    41.894     0.150
    11.769    47.991     0.150
    12.590   364.162     0.150
    19.718   252.621     0.150
    20.703   260.225     0.150
    20.910   258.308     0.150
    21.331   261.798     0.150
    21.331   274.599     0.150
    21.331   707.001     0.150
    22.150   266.946     0.150
    24.715    65.013     0.150
    25.752   288.703     0.150
    26.293   228.236     0.150
    27.902   298.814     0.150
    28.725    71.617     0.150
    28.725   297.719     0.150
     9.651   825.534     0.150
    11.976   582.579     0.150
    14.808   344.077     0.150
    14.808   554.327     0.150
    18.850    51.393     0.150
    18.850   258.596     0.150
    19.358   510.628     0.150
    20.704   264.049     0.150
    20.704   283.744     0.150
    20.704   723.947     0.150
    20.704    55.455     0.150
    20.704   288.455     0.150
    20.704   723.455     0.150
    21.185   267.367     0.150
    21.185   719.992     0.150
    21.264    59.118     0.150
    22.682   274.875     0.150
    22.682   315.969     0.150
    23.877    66.218     0.150
    23.877   282.718     0.150
    23.877   337.515     0.150
    24.333   291.506     0.150
    24.333   305.303     0.150
    24.333   696.108     0.150
    24.408   294.901     0.150
    24.954   298.895     0.150
    25.398   240.436     0.150
    25.398   292.725     0.150
    25.398   454.897     0.150
    25.398   683.585     0.150
    26.127   300.968     0.150
    27.160   302.305     0.150
    28.586    82.670     0.150
    28.586   308.568     0.150
    28.586   389.170     0.150
    29.990    77.981     0.150
    29.990   312.981     0.150
    11.872   586.764     0.150
    23.835    67.803     0.150
    23.835   334.303     0.150
    18.851    55.061     0.150
    21.266   268.579     0.150
    23.879   283.093     0.150
    21.265   292.559     0.150
     6.784   429.871     0.150
    11.993   373.784     0.150
    11.993   584.635     0.150
    14.800   555.131     0.150
    18.871   259.168     0.150
    19.523   252.153     0.150
    20.211   255.627     0.150
    20.716    53.033     0.150
    20.716   286.236     0.150
    20.716   716.931     0.150
    21.187   263.316     0.150
    21.487   263.240     0.150
    22.703   273.451     0.150
    23.898   254.396     0.150
    23.898   285.201     0.150
    24.352    65.808     0.150
    25.149   242.701     0.150
    25.149   292.405     0.150
    25.419   239.454     0.150
    26.140   297.341     0.150
    27.460   218.233     0.150
    28.585    68.198     0.150
    21.434   267.938     0.150
    22.666   280.263     0.150
    23.862    67.706     0.150
    23.862   286.408     0.150
    28.680    68.177     0.150
    28.680   206.376     0.150
    25.415   238.520     0.150
    28.663    71.624     0.150
    25.414   239.103     0.150
    28.682    71.691     0.150
    25.378   455.203     0.150
    28.552    69.606     0.150
    28.552   208.306     0.150
    20.650    54.869     0.150
    20.650   262.166     0.150
    24.359   342.583     0.150
    28.523  -317.660     0.150
    28.523  -310.762     0.150
    28.523    72.094     0.150
    28.523   208.793     0.150
     9.264    30.669     0.150
    20.332   261.197     0.150
    20.660    53.477     0.150
    20.660   280.977     0.150
    20.660   717.278     0.150
    21.602   300.885     0.150
    22.800   279.499     0.150
    23.996    64.647     0.150
    23.996   283.647     0.150
    23.996   302.049     0.150
    23.996   332.350     0.150
    25.480   238.662     0.150
    27.705   300.355     0.150
    28.465    72.092     0.150
    20.711    56.912     0.150
    20.711   283.713     0.150
    28.595    72.709     0.150
    20.768    57.382     0.150
    28.661    73.474     0.150
    18.838    55.454     0.150
    18.838   269.751     0.150
    20.715    56.853     0.150
    20.715   286.259     0.150
    20.715   290.556     0.150
    20.715   718.158     0.150
    21.451   267.567     0.150
    25.390   240.350     0.150
    25.390   457.873     0.150
    25.421   239.499     0.150
     9.129    30.083     0.150
    20.654    54.585     0.150
    20.654   285.284     0.150
    20.654   289.085     0.150
    20.654   721.386     0.150
    21.218   280.902     0.150
    21.218   294.004     0.150
    23.849    66.398     0.150
    28.551   305.728     0.150
    22.688   264.600     0.150
     9.253    36.419     0.150
     9.253    41.118     0.150
    18.932    48.961     0.150
    22.754   279.567     0.150
    23.950    66.110     0.150
    23.950   332.609     0.150
    25.496   239.082     0.150
    25.496   455.801     0.150
    20.609   258.049     0.150
    20.609    52.855     0.150
    20.609   259.355     0.150
    21.543   264.958     0.150
    23.931    67.196     0.150
    23.931   283.796     0.150
    25.410   454.375     0.150
     9.214    35.000     0.150
    20.800    55.893     0.150
    20.800   266.596     0.150
    20.800   284.393     0.150
    20.800   722.096     0.150
    21.338    60.719     0.150
    22.715   283.445     0.150
    22.715   317.046     0.150
    23.911    66.090     0.150
    23.911   288.691     0.150
    23.911   338.988     0.150
    20.703    57.013     0.150
    20.703   283.413     0.150
    20.757    51.546     0.150
    20.757   288.745     0.150
    25.411   239.673     0.150
    25.411   456.642     0.150
    20.760    55.889     0.150
    20.760   285.990     0.150
    25.407   456.235     0.150
    18.844   266.636     0.150
    20.829   284.876     0.150
    23.855    69.160     0.150
    23.855   286.660     0.150
    25.422   458.080     0.150
    21.221   264.844     0.150
    21.221    56.950     0.150
    21.221   291.547     0.150
    23.435   280.615     0.150
    18.861    54.034     0.150
    18.861   268.534     0.150
    20.668    54.644     0.150
    20.668   281.043     0.150
    21.493   269.423     0.150
    21.493   303.326     0.150
    23.894    66.297     0.150
    23.894   285.297     0.150
    23.894   332.496     0.150
    25.400   240.444     0.150
    10.090    45.144     0.150
    12.648   363.396     0.150
    15.559   212.214     0.150
    20.363   261.253     0.150
    21.324   258.355     0.150
    21.324   263.636     0.150
    21.324   707.933     0.150
    21.382   262.188     0.150
    22.179    56.962     0.150
    22.179   268.267     0.150
    22.285   267.121     0.150
    22.285   480.324     0.150
    23.568    65.350     0.150
    23.568   276.647     0.150
    23.568   297.147     0.150
    24.765    65.887     0.150
    24.765   306.684     0.150
    24.765   344.887     0.150
    25.112   286.630     0.150
    26.331   227.857     0.150
    26.331   685.568     0.150
    27.958   298.624     0.150
    28.205   297.033     0.150
    29.441   199.481     0.150
     9.152    30.711     0.150
    12.011   373.896     0.150
    12.011   584.396     0.150
    14.746   556.024     0.150
    17.692   526.887     0.150
    18.842   256.432     0.150
    18.842   268.729     0.150
    20.222   261.317     0.150
    20.636    53.293     0.150
    20.636   716.894     0.150
    21.111   262.570     0.150
    21.111   495.093     0.150
    21.175    56.202     0.150
    21.482    56.018     0.150
    21.482   267.319     0.150
    21.482   283.319     0.150
    21.482   304.916     0.150
    21.482   492.319     0.150
    22.682   276.405     0.150
    22.682   290.308     0.150
    23.032    62.524     0.150
    23.878    66.357     0.150
    23.878   283.657     0.150
    24.353   283.311     0.150
    24.353   303.909     0.150
    24.931   290.261     0.150
    25.375   296.961     0.150
    25.375   455.942     0.150
    26.176   297.840     0.150
    26.657  -301.604     0.150
    29.998    72.632     0.150
    29.998   325.632     0.150
    21.320    53.607     0.150
    21.320   263.607     0.150
    21.320   288.307     0.150
    21.320   295.807     0.150
    21.320   708.709     0.150
    19.442    56.420     0.150
    19.442   249.521     0.150
    19.442   298.217     0.150
    20.617    53.701     0.150
    20.617   283.201     0.150
    21.381    52.837     0.150
    21.381   288.138     0.150
    21.381   297.540     0.150
    10.770   593.617     0.150
    20.477   255.141     0.150
    21.213   263.046     0.150
    21.213   283.745     0.150
    21.213   707.546     0.150
    24.340   280.254     0.150
    25.982   289.689     0.150
    26.921   436.317     0.150
    21.232   260.863     0.150
    21.232   289.863     0.150
    21.232   705.863     0.150
    22.411   270.503     0.150
    19.343    58.005     0.150
    21.082    56.306     0.150
    21.082   267.907     0.150
    21.082   287.606     0.150
    21.082   294.806     0.150
    21.082   715.106     0.150
    16.643    56.500     0.150
    16.643   222.898     0.150
    21.291   263.160     0.150
    21.291   709.160     0.150
    22.282   266.591     0.150
    21.170    52.352     0.150
    21.170   263.454     0.150
    21.170   285.352     0.150
    21.170   290.255     0.150
    21.170   712.153     0.150
    21.945   268.714     0.150
    25.996   449.358     0.150
    10.046    43.870     0.150
    12.604   363.981     0.150
    19.719   251.681     0.150
    21.309   260.623     0.150
    22.141    56.317     0.150
    24.789   281.815     0.150
    26.289   227.537     0.150
    26.289   227.756     0.150
    27.912   299.070     0.150
    20.992   290.630     0.150
    12.551   365.300     0.150
    21.305   259.743     0.150
    26.247   227.855     0.150
    27.859   299.355     0.150
    21.305   262.898     0.150
    21.305   292.699     0.150
    26.333   442.803     0.150
    25.587   232.503     0.150
    21.423   261.671     0.150
    21.423   274.773     0.150
    21.423   706.976     0.150
    21.535   262.296     0.150
    22.178   269.367     0.150
    25.667   233.728     0.150
    26.296   228.643     0.150
    28.819   204.888     0.150
    12.594   364.687     0.150
    12.594   569.336     0.150
    16.585    43.322     0.150
    16.585    53.822     0.150
    16.585   220.322     0.150
    20.352    54.151     0.150
    20.908   254.171     0.150
    21.285   258.438     0.150
    21.285   258.668     0.150
    21.285   705.070     0.150
    22.115    55.378     0.150
    22.115   268.077     0.150
    22.224   265.211     0.150
    23.503   273.381     0.150
    24.770   278.403     0.150
    25.053   285.898     0.150
    25.053   457.597     0.150
    25.564   234.161     0.150
    25.564   282.297     0.150
    25.757   290.277     0.150
    26.564  -294.704     0.150
    26.564   295.859     0.150
    27.787   299.293     0.150
    27.898   299.099     0.150
    28.129   296.822     0.150
    28.154   298.506     0.150
    25.607   233.234     0.150
     9.958    46.185     0.150
    12.610   363.287     0.150
    16.569    45.033     0.150
    16.569    55.632     0.150
    20.320   254.065     0.150
    20.748   260.267     0.150
    21.151   260.171     0.150
    22.205   291.363     0.150
    24.726   280.144     0.150
    25.442   234.593     0.150
    25.742   287.239     0.150
    28.034   295.342     0.150
    21.116    57.185     0.150
    21.116   266.283     0.150
    21.116   293.486     0.150
    25.306   240.239     0.150
    12.646   364.051     0.150
    16.638    46.961     0.150
    16.638    55.359     0.150
    21.300   259.256     0.150
    21.300   706.053     0.150
    21.362   264.534     0.150
    21.787   267.473     0.150
    25.106   282.138     0.150
    25.595   234.158     0.150
    25.595   281.260     0.150
    25.808   289.739     0.150
    25.870   290.179     0.150
    26.313   227.939     0.150
    26.313   226.697     0.150
    28.173   299.832     0.150
    28.204   297.777     0.150
    20.702    55.269     0.150
    20.702   283.069     0.150
    20.702   289.269     0.150
    20.702   716.370     0.150
    24.936   241.789     0.150
    24.936   456.289     0.150
    24.989   243.995     0.150
    25.924   229.476     0.150
    25.367   236.143     0.150
    25.592   234.031     0.150
    12.619   364.765     0.150
    20.393   251.195     0.150
    20.940   255.509     0.150
    21.334   260.715     0.150
    21.759   269.254     0.150
    22.260   265.906     0.150
    24.813   279.611     0.150
    25.086    66.930     0.150
    25.086   284.129     0.150
    25.619   233.861     0.150
    25.619   447.190     0.150
    25.782   286.807     0.150
    26.317   228.355     0.150
    26.575  -289.832     0.150
    26.575   295.051     0.150
    28.177   299.062     0.150
    28.183   211.258     0.150
    25.580   234.222     0.150
    25.332   242.803     0.150
    12.646   363.728     0.150
    21.311   260.400     0.150
    21.371   262.072     0.150
    25.606   233.526     0.150
    26.321   228.028     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    15.008    40.479     0.200
    18.009    34.455     0.200
    20.419    31.331     0.200
    20.767    30.265     0.200
    21.847    32.667     0.200
    26.028    22.867     0.200
    27.946    16.487     0.200
    17.807    31.666     0.200
    20.999    29.413     0.200
    20.849    37.164     0.200
    20.862    36.810     0.200
    21.333    30.512     0.200
    22.426    28.757     0.200
    24.273    24.208     0.200
    24.273    24.608     0.200
    25.397    24.089     0.200
    25.273    29.535     0.200
    25.333    29.835     0.200
    25.773    28.698     0.200
    26.015    21.880     0.200
    26.827    19.405     0.200
    27.675    22.509     0.200
    28.040    21.248     0.200
    28.383    14.241     0.200
    28.496    15.919     0.200
    28.651    18.114     0.200
    18.013    34.447     0.200
    24.179    23.482     0.200
    28.000    16.895     0.200
    21.474    28.384     0.200
    27.973    16.537     0.200
    24.145    24.423     0.200
    24.105    25.781     0.200
    18.224    33.987     0.200
    23.940    24.577     0.200
    18.019    38.425     0.200
    21.235    32.891     0.200
    18.008    31.993     0.200
    24.635    28.658     0.200
    27.946    17.021     0.200
    19.478    33.283     0.200
    21.284    31.200     0.200
    24.019    26.280     0.200
    23.898    29.701     0.200
    24.738    29.899     0.200
    26.023    28.901     0.200
    26.825    26.535     0.200
    27.867    20.376     0.200
    28.391    17.268     0.200
    28.597    19.059     0.200
    28.754    20.031     0.200
    29.860    16.121     0.200
    21.307    32.493     0.200
    21.429    27.765     0.200
    24.128    24.267     0.200
    27.940    16.784     0.200
    28.453    15.794     0.200
    19.612    30.647     0.200
    21.445    29.256     0.200
    24.160    23.776     0.200
    27.980    17.996     0.200
    28.663    17.217     0.200
    29.969    12.777     0.200
    18.456    32.841     0.200
    19.616    31.002     0.200
    21.445    28.963     0.200
    24.163    23.239     0.200
    27.986    17.629     0.200
    28.501    16.414     0.200
    29.976    12.407     0.200
    18.471    33.893     0.200
    19.646    31.182     0.200
    21.470    27.890     0.200
    24.192    23.122     0.200
    28.530    15.800     0.200
    18.477    33.356     0.200
    21.440    27.277     0.200
    24.140    23.772     0.200
    27.951    17.296     0.200
    28.464    16.412     0.200
    29.940    12.085     0.200
    18.007    31.072     0.200
    20.096    33.967     0.200
    20.023    33.193     0.200
    23.906    28.881     0.200
    28.134    19.534     0.200
    29.620    17.190     0.200
    18.476    33.395     0.200
    20.401    29.942     0.200
    21.431    29.812     0.200
    18.433    32.944     0.200
    19.261    31.087     0.200
    20.062    31.942     0.200
    21.429    30.489     0.200
    24.421    28.074     0.200
    27.593    17.448     0.200
    28.100    17.133     0.200
    19.658    33.584     0.200
    21.473    28.397     0.200
    21.463    28.719     0.200
    28.547    16.248     0.200
    18.488    32.576     0.200
    20.474    32.399     0.200
    21.488    29.470     0.200
    24.194    24.497     0.200
    28.010    17.659     0.200
    28.524    16.563     0.200
    30.000    12.241     0.200
    18.499    32.693     0.200
    19.603    31.006     0.200
    20.415    30.834     0.200
    21.460    29.441     0.200
    21.498    29.194     0.200
    27.960    17.178     0.200
    28.472    16.611     0.200
    15.022    38.944     0.200
    20.412    31.047     0.200
    21.439    29.454     0.200
    21.478    29.704     0.200
    24.821    26.586     0.200
    27.947    17.411     0.200
    27.990    17.605     0.200
    28.459    16.631     0.200
    28.459    16.530     0.200
    29.935    12.904     0.200
    14.980    41.508     0.200
    18.464    31.844     0.200
    18.464    32.243     0.200
    19.631    33.222     0.200
    19.631    33.425     0.200
    20.478    30.842     0.200
    20.816    31.398     0.200
    21.060    30.646     0.200
    21.458    28.303     0.200
    21.464    29.637     0.200
    21.855    29.872     0.200
    24.178    25.160     0.200
    24.178    25.457     0.200
    25.883    23.764     0.200
    28.001    16.552     0.200
    28.001    17.349     0.200
    28.057    17.900     0.200
    28.516    16.140     0.200
    29.991    12.729     0.200
    18.619    36.714     0.200
    18.619    37.214     0.200
    21.381    38.474     0.200
    21.381    39.274     0.200
    21.614    35.759     0.200
    21.614    36.659     0.200
    28.158    22.390     0.200
    28.158    22.990     0.200
    19.605    30.449     0.200
    20.459    31.489     0.200
    21.435    29.394     0.200
    21.449    30.635     0.200
    24.152    24.385     0.200
    24.152    24.682     0.200
    28.040    19.514     0.200
    28.491    16.154     0.200
    28.552    15.641     0.200
    29.965    11.847     0.200
    18.663    35.564     0.200
    19.410    35.849     0.200
    19.410    36.248     0.200
    20.373    37.109     0.200
    21.431    31.264     0.200
    21.431    32.061     0.200
    21.658    32.606     0.200
    21.658    33.004     0.200
    23.982    28.486     0.200
    23.982    28.884     0.200
    28.193    20.352     0.200
    28.193    21.055     0.200
    14.404    38.556     0.200
    17.354    41.332     0.200
    18.633    36.406     0.200
    19.335    35.216     0.200
    19.981    34.676     0.200
    20.336    35.225     0.200
    21.370    32.666     0.200
    21.363    33.747     0.200
    21.628    33.257     0.200
    23.465    31.020     0.200
    23.908    28.840     0.200
    23.908    29.240     0.200
    24.237    31.502     0.200
    24.416    31.610     0.200
    25.114    30.568     0.200
    25.387    26.590     0.200
    26.193    27.182     0.200
    26.330    30.875     0.200
    27.152    26.990     0.200
    27.552    21.224     0.200
    27.624    21.480     0.200
    27.624    21.880     0.200
    28.116    21.133     0.200
    28.505    19.697     0.200
    28.557    20.592     0.200
    29.102    18.630     0.200
    29.605    17.059     0.200
    18.532    37.106     0.200
    18.532    37.806     0.200
    21.527    35.148     0.200
    18.594    37.030     0.200
    19.335    35.385     0.200
    20.382    33.569     0.200
    20.594    32.284     0.200
    21.349    31.876     0.200
    21.589    32.078     0.200
    21.589    32.677     0.200
    23.906    28.043     0.200
    23.906    28.944     0.200
    28.130    19.745     0.200
    18.612    37.523     0.200
    21.393    34.068     0.200
    21.393    34.869     0.200
    21.608    33.563     0.200
    18.554    37.122     0.200
    19.352    34.806     0.200
    19.352    35.107     0.200
    20.068    34.446     0.200
    20.444    34.858     0.200
    20.654    33.413     0.200
    21.338    31.428     0.200
    21.469    34.102     0.200
    21.549    34.163     0.200
    23.556    30.143     0.200
    23.919    28.510     0.200
    23.919    28.709     0.200
    24.346    31.526     0.200
    25.492    27.358     0.200
    26.302    26.902     0.200
    27.664    21.804     0.200
    27.664    22.003     0.200
    27.648    20.190     0.200
    28.164    20.673     0.200
    29.648    16.753     0.200
    18.572    33.099     0.200
    20.366    33.163     0.200
    21.312    33.127     0.200
    21.312    33.229     0.200
    21.567    32.152     0.200
    21.567    32.449     0.200
    28.088    19.051     0.200
    28.088    19.348     0.200
    18.567    36.307     0.200
    19.355    38.111     0.200
    20.061    33.875     0.200
    21.347    34.863     0.200
    21.347    34.965     0.200
    21.457    36.779     0.200
    21.563    33.348     0.200
    21.563    33.747     0.200
    25.480    26.734     0.200
    27.639    22.640     0.200
    28.163    20.127     0.200
    19.912    33.954     0.200
    18.579    36.147     0.200
    18.579    36.647     0.200
    19.397    34.599     0.200
    19.397    34.799     0.200
    21.378    31.475     0.200
    21.378    32.076     0.200
    21.575    33.183     0.200
    21.575    33.882     0.200
    28.207    19.787     0.200
    28.207    20.287     0.200
    29.692    16.358     0.200
    19.257    34.956     0.200
    19.257    35.155     0.200
    21.283    32.304     0.200
    21.283    32.804     0.200
    21.368    35.121     0.200
    21.552    33.164     0.200
    21.552    33.562     0.200
    23.828    30.605     0.200
    23.828    31.406     0.200
    25.388    26.707     0.200
    28.052    20.310     0.200
    28.052    20.810     0.200
    29.538    16.966     0.200
    29.538    17.767     0.200
    18.537    36.702     0.200
    19.309    35.893     0.200
    20.031    34.256     0.200
    20.424    34.978     0.200
    20.622    34.360     0.200
    21.303    32.813     0.200
    21.444    33.369     0.200
    21.532    34.951     0.200
    23.521    30.333     0.200
    23.876    28.386     0.200
    23.876    28.589     0.200
    25.465    25.842     0.200
    26.286    28.266     0.200
    27.620    20.697     0.200
    27.620    21.095     0.200
    27.615    21.254     0.200
    28.120    20.263     0.200
    28.638    24.714     0.200
    29.604    16.544     0.200
    18.582    35.121     0.200
    19.260    34.207     0.200
    19.260    34.504     0.200
    19.935    35.327     0.200
    21.344    34.277     0.200
    21.576    32.180     0.200
    23.833    28.837     0.200
    23.833    29.634     0.200
    27.516    21.260     0.200
    28.048    19.651     0.200
    28.048    19.854     0.200
    18.628    36.280     0.200
    19.311    34.313     0.200
    19.311    34.912     0.200
    19.956    33.778     0.200
    20.319    34.040     0.200
    21.622    33.335     0.200
    25.367    25.635     0.200
    28.090    19.853     0.200
    28.090    20.653     0.200
    29.579    16.477     0.200
    29.579    16.777     0.200
    18.559    36.170     0.200
    19.275    34.813     0.200
    19.275    35.714     0.200
    19.973    35.679     0.200
    20.562    34.798     0.200
    21.295    32.242     0.200
    21.554    34.224     0.200
    23.461    31.467     0.200
    23.846    28.372     0.200
    25.406    27.072     0.200
    27.555    23.591     0.200
    27.577    21.938     0.200
    27.577    22.339     0.200
    28.074    20.739     0.200
    29.560    17.199     0.200
    18.599    36.442     0.200
    19.218    35.214     0.200
    19.871    34.597     0.200
    20.266    35.983     0.200
    20.458    34.544     0.200
    21.282    32.131     0.200
    21.282    32.431     0.200
    21.283    37.714     0.200
    21.592    33.510     0.200
    23.358    31.098     0.200
    23.795    28.808     0.200
    25.303    27.504     0.200
    26.136    26.982     0.200
    27.451    21.332     0.200
    27.994    20.802     0.200
    29.483    17.425     0.200
    18.500    32.157     0.200
    19.642    34.821     0.200
    21.483    29.636     0.200
    21.499    29.154     0.200
    21.499    29.553     0.200
    28.517    15.257     0.200
    28.517    15.956     0.200
    18.472    37.070     0.200
    18.472    37.471     0.200
    21.237    36.805     0.200
    21.237    37.205     0.200
    21.467    35.119     0.200
    21.467    36.020     0.200
    28.080    21.938     0.200
    18.591    34.978     0.200
    18.591    35.178     0.200
    19.419    34.314     0.200
    19.419    35.114     0.200
    20.117    33.167     0.200
    20.465    35.503     0.200
    20.693    33.446     0.200
    21.398    32.218     0.200
    21.398    32.818     0.200
    21.587    33.212     0.200
    23.602    29.900     0.200
    24.533    29.236     0.200
    25.521    27.105     0.200
    27.689    21.099     0.200
    27.730    21.327     0.200
    27.730    21.427     0.200
    28.228    20.110     0.200
    29.713    16.179     0.200
    29.713    16.380     0.200
    18.519    31.013     0.200
    18.519    31.314     0.200
    20.195    30.960     0.200
    20.781    30.823     0.200
    21.369    31.758     0.200
    21.369    32.657     0.200
    21.516    32.039     0.200
    21.516    32.437     0.200
    28.269    17.228     0.200
    28.269    17.427     0.200
    21.577    32.236     0.200
    21.577    32.736     0.200
    18.545    34.162     0.200
    18.545    34.362     0.200
    19.446    32.645     0.200
    20.188    33.984     0.200
    20.544    31.829     0.200
    20.769    30.602     0.200
    21.542    30.189     0.200
    21.542    30.788     0.200
    21.575    30.004     0.200
    23.675    27.294     0.200
    24.008    24.407     0.200
    24.008    24.606     0.200
    24.601    25.788     0.200
    25.600    23.334     0.200
    26.392    23.086     0.200
    27.772    18.480     0.200
    27.765    19.065     0.200
    28.275    17.010     0.200
    28.583    21.212     0.200
    29.757    13.912     0.200
    18.494    35.619     0.200
    19.379    36.302     0.200
    19.379    37.202     0.200
    21.323    34.614     0.200
    21.323    34.813     0.200
    21.491    34.651     0.200
    21.491    35.350     0.200
    25.584    31.384     0.200
    18.371    31.672     0.200
    18.371    31.973     0.200
    19.473    29.810     0.200
    19.473    30.610     0.200
    20.366    29.882     0.200
    20.771    33.165     0.200
    20.972    29.914     0.200
    21.314    27.630     0.200
    21.369    28.482     0.200
    21.796    31.702     0.200
    23.570    28.991     0.200
    23.862    27.590     0.200
    24.020    23.747     0.200
    24.767    26.028     0.200
    25.818    21.265     0.200
    27.963    16.731     0.200
    28.365    15.641     0.200
    29.838    11.554     0.200
    19.306    36.883     0.200
    21.306    32.545     0.200
    21.540    32.816     0.200
    23.874    28.570     0.200
    28.114    20.095     0.200
    13.289    41.670     0.200
    18.077    30.492     0.200
    19.549    28.322     0.200
    19.549    29.220     0.200
    20.701    30.376     0.200
    21.078    28.576     0.200
    21.179    30.291     0.200
    21.346    28.745     0.200
    22.197    28.411     0.200
    23.885    25.718     0.200
    24.067    22.586     0.200
    24.067    23.382     0.200
    24.210    25.924     0.200
    25.080    23.764     0.200
    25.073    26.853     0.200
    26.215    21.526     0.200
    27.035    21.456     0.200
    28.004    14.646     0.200
    28.329    15.857     0.200
    28.549    14.690     0.200
    18.459    32.901     0.200
    18.459    33.299     0.200
    20.437    31.317     0.200
    20.785    31.854     0.200
    21.022    30.786     0.200
    21.458    29.401     0.200
    21.822    30.554     0.200
    23.649    29.338     0.200
    23.926    27.200     0.200
    24.142    24.581     0.200
    24.142    24.980     0.200
    25.849    23.661     0.200
    27.960    17.027     0.200
    28.018    17.049     0.200
    28.474    16.323     0.200
    29.949    12.708     0.200
    18.488    31.930     0.200
    18.488    32.633     0.200
    19.595    33.016     0.200
    20.414    30.956     0.200
    20.995    30.076     0.200
    21.449    27.378     0.200
    21.487    29.331     0.200
    23.628    28.851     0.200
    23.902    26.155     0.200
    24.145    23.911     0.200
    24.145    24.809     0.200
    24.616    28.413     0.200
    24.824    26.588     0.200
    25.818    22.390     0.200
    26.587    22.915     0.200
    27.991    17.031     0.200
    28.466    16.195     0.200
    28.577    16.301     0.200
    29.942    12.261     0.200
    29.942    12.659     0.200
    18.489    32.110     0.200
    19.608    32.048     0.200
    19.608    32.649     0.200
    20.429    30.464     0.200
    21.009    30.491     0.200
    21.457    28.867     0.200
    21.488    29.111     0.200
    21.488    29.509     0.200
    24.158    24.950     0.200
    24.158    25.551     0.200
    28.006    17.749     0.200
    28.481    15.503     0.200
    28.481    15.800     0.200
    29.957    12.274     0.200
    29.957    12.673     0.200
    13.914    37.788     0.200
    18.475    31.453     0.200
    18.475    32.351     0.200
    19.608    31.232     0.200
    19.608    32.131     0.200
    20.441    31.515     0.200
    20.781    30.550     0.200
    21.023    30.823     0.200
    21.450    28.037     0.200
    21.819    29.833     0.200
    23.654    29.020     0.200
    23.929    26.110     0.200
    24.643    28.478     0.200
    24.850    26.055     0.200
    25.846    23.432     0.200
    26.614    23.472     0.200
    27.972    16.628     0.200
    27.972    17.327     0.200
    28.019    17.078     0.200
    28.485    16.833     0.200
    29.961    12.613     0.200
    20.481    30.550     0.200
    18.485    32.348     0.200
    18.485    33.149     0.200
    19.537    31.075     0.200
    19.537    31.575     0.200
    20.347    31.123     0.200
    20.700    32.105     0.200
    20.932    30.699     0.200
    21.413    28.184     0.200
    21.484    29.357     0.200
    21.734    30.437     0.200
    24.090    24.941     0.200
    24.757    24.664     0.200
    27.890    16.603     0.200
    27.927    17.166     0.200
    28.400    16.342     0.200
    29.878    13.003     0.200
    18.474    34.044     0.200
    19.606    31.833     0.200
    21.473    30.043     0.200
    28.483    15.932     0.200
    18.476    33.183     0.200
    19.576    33.647     0.200
    20.401    31.114     0.200
    20.748    33.564     0.200
    20.985    30.300     0.200
    21.431    29.495     0.200
    21.475    29.585     0.200
    23.614    27.623     0.200
    23.890    29.204     0.200
    24.126    25.945     0.200
    24.810    26.857     0.200
    25.811    24.979     0.200
    27.981    17.861     0.200
    28.448    16.210     0.200
    29.924    11.983     0.200
    20.053    32.963     0.200
    18.461    32.988     0.200
    18.461    33.089     0.200
    20.394    30.429     0.200
    20.749    30.978     0.200
    21.413    28.241     0.200
    21.784    31.204     0.200
    23.605    26.452     0.200
    23.883    26.706     0.200
    24.109    24.075     0.200
    24.109    24.177     0.200
    24.802    24.987     0.200
    27.920    17.597     0.200
    27.976    17.345     0.200
    28.433    16.606     0.200
    20.048    31.993     0.200
    18.473    30.795     0.200
    18.473    31.193     0.200
    20.410    31.188     0.200
    20.994    30.373     0.200
    21.433    28.958     0.200
    22.272    29.460     0.200
    23.899    27.875     0.200
    24.131    25.468     0.200
    24.819    26.733     0.200
    25.820    22.554     0.200
    26.593    23.030     0.200
    27.990    18.836     0.200
    28.455    16.304     0.200
    14.328    43.882     0.200
    18.545    34.675     0.200
    20.177    33.125     0.200
    20.535    33.649     0.200
    20.759    32.540     0.200
    21.384    31.834     0.200
    21.565    32.029     0.200
    22.097    30.223     0.200
    23.393    29.097     0.200
    23.450    33.836     0.200
    23.664    28.636     0.200
    23.999    29.318     0.200
    24.423    28.578     0.200
    24.590    26.130     0.200
    25.708    28.283     0.200
    26.384    25.191     0.200
    27.762    19.113     0.200
    27.754    18.905     0.200
    28.265    19.245     0.200
    29.747    15.149     0.200
    18.493    32.472     0.200
    20.349    30.808     0.200
    20.698    32.233     0.200
    20.932    31.002     0.200
    21.421    28.601     0.200
    23.562    27.307     0.200
    23.837    27.102     0.200
    24.097    25.068     0.200
    24.759    24.341     0.200
    25.759    25.669     0.200
    27.895    15.744     0.200
    27.895    16.244     0.200
    27.928    17.364     0.200
    28.405    16.488     0.200
    20.851    30.166     0.200
    24.357    26.256     0.200
    26.337    23.145     0.200
    28.470    16.158     0.200
    18.474    33.102     0.200
    20.372    30.451     0.200
    20.726    31.825     0.200
    20.958    29.914     0.200
    21.415    28.285     0.200
    22.238    28.682     0.200
    22.238    29.478     0.200
    23.584    27.668     0.200
    23.861    26.735     0.200
    24.102    23.928     0.200
    24.102    24.225     0.200
    24.781    23.999     0.200
    24.776    27.861     0.200
    26.565    23.278     0.200
    27.907    17.519     0.200
    27.907    17.918     0.200
    27.953    16.781     0.200
    28.419    17.146     0.200
    28.731    16.770     0.200
    29.896    13.211     0.200
    20.367    31.399     0.200
    21.138    35.649     0.200
    18.462    33.315     0.200
    20.442    31.711     0.200
    20.788    31.677     0.200
    21.027    30.689     0.200
    21.439    28.483     0.200
    21.462    29.814     0.200
    21.825    30.074     0.200
    23.654    27.527     0.200
    23.931    27.095     0.200
    24.148    25.057     0.200
    24.851    27.262     0.200
    25.852    23.576     0.200
    26.623    23.583     0.200
    27.966    16.404     0.200
    28.022    17.551     0.200
    28.481    17.400     0.200
    28.675    17.437     0.200
    29.956    13.087     0.200
    20.745    34.825     0.200
    13.513    40.346     0.200
    13.774    35.396     0.200
    14.502    39.503     0.200
    18.370    32.262     0.200
    20.356    32.581     0.200
    20.763    30.837     0.200
    20.963    30.004     0.200
    21.308    27.278     0.200
    21.788    30.380     0.200
    23.560    26.692     0.200
    23.852    26.588     0.200
    24.757    23.729     0.200
    25.809    21.947     0.200
    27.837    15.783     0.200
    27.953    16.624     0.200
    28.355    15.738     0.200
    14.566    42.205     0.200
    15.016    35.157     0.200
    20.417    32.132     0.200
    20.761    31.610     0.200
    21.000    31.523     0.200
    21.438    30.318     0.200
    21.474    31.796     0.200
    22.279    29.398     0.200
    23.629    28.441     0.200
    23.905    26.422     0.200
    24.138    24.710     0.200
    24.138    24.909     0.200
    24.826    26.075     0.200
    27.949    17.229     0.200
    27.996    18.184     0.200
    28.480    15.967     0.200
    25.508    23.297     0.200
    28.358    16.539     0.200
    28.358    17.141     0.200
    20.369    33.649     0.200
    20.951    30.752     0.200
    21.374    28.817     0.200
    24.064    25.028     0.200
    24.064    25.629     0.200
    25.532    23.297     0.200
    27.944    19.740     0.200
    28.389    16.557     0.200
    20.356    34.252     0.200
    25.523    22.859     0.200
    25.530    23.706     0.200
    20.287    31.930     0.200
    20.297    31.701     0.200
    20.880    31.007     0.200
    21.355    28.560     0.200
    21.454    29.302     0.200
    22.149    33.200     0.200
    24.020    24.856     0.200
    24.693    27.204     0.200
    25.491    23.793     0.200
    27.817    17.845     0.200
    27.873    17.396     0.200
    28.328    16.382     0.200
    20.456    31.797     0.200
    20.467    31.970     0.200
    21.400    30.273     0.200
    24.114    25.307     0.200
    25.577    23.635     0.200
    19.946    36.511     0.200
    15.534    35.230     0.200
    20.686    31.715     0.200
    21.029    30.706     0.200
    21.149    33.303     0.200
    24.019    24.510     0.200
    25.461    24.883     0.200
    28.321    17.409     0.200
    29.965    13.223     0.200
    17.914    34.266     0.200
    20.377    32.229     0.200
    15.550    36.299     0.200
    17.677    36.471     0.200
    17.913    33.922     0.200
    20.391    32.208     0.200
    24.019    25.667     0.200
    25.483    24.581     0.200
    25.893    24.053     0.200
    27.978    19.859     0.200
    28.371    16.882     0.200
    15.918    36.223     0.200
    25.271    26.362     0.200
    15.563    35.625     0.200
    16.652    35.910     0.200
    17.940    34.284     0.200
    20.370    31.922     0.200
    20.381    31.872     0.200
    20.974    31.079     0.200
    21.326    29.468     0.200
    21.380    30.135     0.200
    21.795    29.497     0.200
    23.575    29.521     0.200
    23.865    27.139     0.200
    24.031    26.001     0.200
    25.817    23.855     0.200
    25.893    23.862     0.200
    27.965    18.292     0.200
    28.198    18.066     0.200
    28.374    16.919     0.200
    29.732    10.672     0.200
    29.847    13.730     0.200
    14.511    41.480     0.200
    16.651    35.406     0.200
    20.366    31.555     0.200
    20.377    31.727     0.200
    20.776    31.170     0.200
    20.974    29.858     0.200
    21.302    28.435     0.200
    21.357    29.491     0.200
    23.569    28.376     0.200
    24.847    27.694     0.200
    25.475    23.733     0.200
    25.822    21.588     0.200
    25.881    23.080     0.200
    27.964    17.383     0.200
    28.183    17.436     0.200
    28.359    17.080     0.200
    29.831    13.101     0.200
    16.615    35.872     0.200
    17.652    36.364     0.200
    17.954    34.041     0.200
    20.344    32.560     0.200
    20.936    30.944     0.200
    21.321    29.453     0.200
    21.394    30.100     0.200
    24.012    26.346     0.200
    24.735    27.904     0.200
    25.780    25.717     0.200
    27.829    18.902     0.200
    27.927    20.255     0.200
    28.171    18.213     0.200
    28.700    17.835     0.200
    29.819    12.781     0.200
    18.145    34.388     0.200
    20.903    31.184     0.200
    21.093    32.960     0.200
    21.105    33.387     0.200
    21.233    29.525     0.200
    24.249    24.737     0.200
    26.624    23.415     0.200
    28.635    17.151     0.200
    28.734    18.793     0.200
    17.826    33.684     0.200
    20.709    32.588     0.200
    21.030    30.678     0.200
    25.597    22.728     0.200
    26.083    22.622     0.200
    28.303    16.900     0.200
    14.136    41.740     0.200
    16.250    39.872     0.200
    17.416    37.897     0.200
    19.984    35.494     0.200
    19.995    35.130     0.200
    20.356    35.655     0.200
    20.566    34.210     0.200
    21.339    32.390     0.200
    23.099    35.290     0.200
    23.202    35.940     0.200
    23.470    31.313     0.200
    23.885    28.369     0.200
    24.441    29.201     0.200
    25.402    26.769     0.200
    25.594    26.885     0.200
    27.560    22.081     0.200
    27.609    23.017     0.200
    27.944    21.306     0.200
    28.933    18.461     0.200
    29.079    17.762     0.200
    29.591    17.386     0.200
    17.962    33.848     0.200
    19.563    34.018     0.200
    20.273    31.878     0.200
    20.284    31.860     0.200
    20.878    30.929     0.200
    21.298    30.134     0.200
    22.784    32.295     0.200
    23.479    29.265     0.200
    23.970    24.841     0.200
    25.565    22.194     0.200
    25.806    23.171     0.200
    27.868    17.745     0.200
    29.766    13.804     0.200
    14.971    37.854     0.200
    15.594    36.389     0.200
    16.171    36.852     0.200
    24.073    25.830     0.200
    28.461    18.426     0.200
    15.565    35.859     0.200
    17.935    33.700     0.200
    18.652    35.122     0.200
    19.637    34.130     0.200
    20.378    30.991     0.200
    21.325    29.942     0.200
    22.699    31.738     0.200
    22.699    33.840     0.200
    23.872    24.807     0.200
    24.033    26.032     0.200
    27.973    17.957     0.200
    28.203    17.669     0.200
    28.379    16.823     0.200
    28.677    16.033     0.200
    29.851    13.536     0.200
    15.118    41.581     0.200
    19.964    36.774     0.200
    22.950    36.438     0.200
    23.665    29.342     0.200
    25.463    28.943     0.200
    14.731    36.268     0.200
    19.248    33.560     0.200
    19.907    32.573     0.200
    19.917    31.704     0.200
    20.497    31.681     0.200
    25.507    24.613     0.200
    27.490    18.078     0.200
    28.016    15.937     0.200
    28.972    13.772     0.200
    17.970    34.289     0.200
    18.655    34.293     0.200
    19.592    34.163     0.200
    20.341    32.119     0.200
    20.940    30.626     0.200
    21.339    29.665     0.200
    21.410    30.545     0.200
    22.746    33.197     0.200
    23.548    28.393     0.200
    24.030    24.568     0.200
    24.744    25.429     0.200
    24.796    26.637     0.200
    25.781    21.833     0.200
    25.876    23.325     0.200
    27.844    17.854     0.200
    27.932    17.029     0.200
    28.186    17.466     0.200
    28.359    17.140     0.200
    28.715    13.794     0.200
    29.834    13.232     0.200
    20.283    32.276     0.200
    25.808    24.042     0.200
    28.121    18.152     0.200
    17.897    35.089     0.200
    17.640    35.233     0.200
    17.941    33.152     0.200
    18.621    34.157     0.200
    19.607    34.200     0.200
    20.328    32.044     0.200
    20.338    32.010     0.200
    20.338    31.588     0.200
    20.933    30.579     0.200
    21.305    28.517     0.200
    21.305    29.533     0.200
    21.380    30.154     0.200
    23.997    25.418     0.200
    24.806    26.023     0.200
    25.852    23.772     0.200
    27.816    18.453     0.200
    27.924    17.499     0.200
    28.158    17.556     0.200
    28.333    17.120     0.200
    29.409    12.810     0.200
    20.376    34.226     0.200
    20.387    32.148     0.200
    21.811    31.578     0.200
    25.888    23.649     0.200
    28.189    17.328     0.200
    28.365    16.488     0.200
    29.462    14.393     0.200
    29.837    13.313     0.200
    17.614    32.666     0.200
    17.614    32.427     0.200
    17.841    34.046     0.200
    20.710    30.612     0.200
    20.710    31.194     0.200
    21.185    26.897     0.200
    21.185    27.159     0.200
    22.203    33.011     0.200
    22.280    31.085     0.200
    22.280    29.312     0.200
    24.052    23.731     0.200
    26.096    21.727     0.200
    26.220    21.737     0.200
    28.344    15.820     0.200
    28.344    16.949     0.200
    28.538    15.282     0.200
    29.838    11.398     0.200
    29.993    11.002     0.200
    20.351    34.409     0.200
    22.734    32.609     0.200
    25.868    23.274     0.200
    25.868    24.184     0.200
    28.176    17.844     0.200
    28.350    16.721     0.200
    28.697    15.677     0.200
    29.418    14.670     0.200
    18.072    35.610     0.200
    18.072    35.462     0.200
    20.928    34.003     0.200
    22.373    32.257     0.200
    24.105    28.550     0.200
    18.082    35.559     0.200
    18.082    33.930     0.200
    20.952    33.233     0.200
    20.952    32.651     0.200
    26.341    23.564     0.200
    26.427    24.161     0.200
    21.423    29.876     0.200
    29.478    13.779     0.200
    17.596    35.500     0.200
    20.269    32.261     0.200
    20.280    32.004     0.200
    20.280    32.192     0.200
    23.969    25.774     0.200
    25.803    23.976     0.200
    28.288    16.874     0.200
    15.561    36.466     0.200
    19.548    34.941     0.200
    20.312    31.822     0.200
    20.323    32.168     0.200
    20.323    31.465     0.200
    20.737    33.369     0.200
    21.349    28.221     0.200
    21.349    29.150     0.200
    21.435    30.325     0.200
    22.781    32.356     0.200
    24.026    25.381     0.200
    25.857    23.212     0.200
    28.344    16.793     0.200
    28.742    15.341     0.200
    29.820    13.267     0.200
    14.432    39.968     0.200
    17.819    34.040     0.200
    19.683    32.839     0.200
    20.291    31.099     0.200
    20.302    30.570     0.200
    20.763    32.888     0.200
    20.922    29.937     0.200
    21.170    29.638     0.200
    21.170    28.318     0.200
    21.258    29.614     0.200
    21.774    30.184     0.200
    22.679    31.177     0.200
    22.679    29.558     0.200
    23.485    30.121     0.200
    25.790    22.020     0.200
    25.768    23.277     0.200
    27.906    17.325     0.200
    28.239    15.736     0.200
    28.572    12.055     0.200
    29.409    12.268     0.200
    29.709    12.690     0.200
    25.838    23.073     0.200
    28.323    17.053     0.200
    20.568    32.208     0.200
    20.579    32.441     0.200
    21.462    32.670     0.200
    21.501    29.930     0.200
    23.781    28.509     0.200
    24.248    25.263     0.200
    26.119    24.246     0.200
    28.601    16.859     0.200
    28.740    16.236     0.200
    17.910    34.666     0.200
    18.627    35.103     0.200
    20.371    32.151     0.200
    20.381    31.484     0.200
    21.298    30.034     0.200
    21.350    32.218     0.200
    21.807    34.094     0.200
    22.687    32.515     0.200
    22.687    32.745     0.200
    24.009    25.093     0.200
    24.769    27.718     0.200
    25.883    23.486     0.200
    27.970    19.673     0.200
    28.360    17.016     0.200
    28.653    15.791     0.200
    29.457    13.174     0.200
    29.832    13.540     0.200
    17.942    34.286     0.200
    17.942    33.864     0.200
    19.634    34.283     0.200
    20.382    32.006     0.200
    20.382    32.108     0.200
    20.393    31.519     0.200
    20.984    30.177     0.200
    21.333    30.297     0.200
    21.333    29.633     0.200
    21.382    30.635     0.200
    22.701    33.732     0.200
    22.701    32.959     0.200
    23.587    32.406     0.200
    24.841    26.616     0.200
    25.827    24.565     0.200
    25.906    23.439     0.200
    26.349    23.621     0.200
    26.625    22.843     0.200
    27.868    17.846     0.200
    27.976    17.689     0.200
    28.386    16.904     0.200
    28.683    16.126     0.200
    29.458    12.977     0.200
    26.176    25.904     0.200
    28.228    21.048     0.200
    29.234    15.164     0.200
    20.357    31.801     0.200
    20.796    34.897     0.200
    21.218    32.167     0.200
    21.813    32.336     0.200
    22.657    32.679     0.200
    23.168    28.637     0.200
    26.274    23.162     0.200
    18.079    32.809     0.200
    20.206    32.290     0.200
    20.217    31.921     0.200
    21.375    29.949     0.200
    23.420    27.781     0.200
    26.227    23.279     0.200
    27.786    19.130     0.200
    28.280    17.562     0.200
    15.553    35.275     0.200
    17.934    33.893     0.200
    17.934    32.983     0.200
    19.631    33.787     0.200
    20.364    30.636     0.200
    20.375    31.688     0.200
    20.969    30.477     0.200
    21.317    29.111     0.200
    21.317    28.672     0.200
    21.791    29.875     0.200
    23.568    27.442     0.200
    24.021    23.551     0.200
    24.765    26.878     0.200
    24.834    23.807     0.200
    25.814    23.037     0.200
    26.329    22.446     0.200
    27.960    16.694     0.200
    28.365    16.765     0.200
    29.444    12.467     0.200
    29.837    13.177     0.200
    15.570    35.792     0.200
    17.939    34.747     0.200
    17.939    33.278     0.200
    19.636    32.947     0.200
    20.380    31.360     0.200
    20.391    31.748     0.200
    20.983    30.618     0.200
    21.330    28.672     0.200
    21.330    28.273     0.200
    21.379    31.394     0.200
    21.803    33.647     0.200
    22.700    33.179     0.200
    23.585    30.560     0.200
    24.038    24.169     0.200
    24.782    27.190     0.200
    25.826    23.702     0.200
    26.347    22.667     0.200
    27.865    18.707     0.200
    27.975    17.631     0.200
    29.458    13.352     0.200
    29.856    13.179     0.200
    14.477    37.237     0.200
    14.993    38.324     0.200
    14.993    37.723     0.200
    17.957    34.328     0.200
    17.957    33.906     0.200
    19.596    33.454     0.200
    20.331    31.130     0.200
    20.342    31.408     0.200
    20.933    30.603     0.200
    21.323    28.955     0.200
    21.323    29.401     0.200
    21.397    30.086     0.200
    22.744    31.715     0.200
    23.537    28.217     0.200
    24.733    26.754     0.200
    24.797    27.084     0.200
    25.776    22.579     0.200
    25.861    23.387     0.200
    25.861    23.957     0.200
    26.305    22.811     0.200
    26.580    22.498     0.200
    27.828    17.932     0.200
    27.924    16.311     0.200
    28.170    17.850     0.200
    28.170    17.584     0.200
    28.344    17.016     0.200
    29.408    13.297     0.200
    29.818    13.312     0.200
    17.919    34.503     0.200
    20.384    32.126     0.200
    21.307    30.757     0.200
    25.889    23.793     0.200
    28.367    16.670     0.200
    28.662    15.633     0.200
    29.457    13.835     0.200
    17.942    33.932     0.200
    18.573    34.971     0.200
    20.259    32.095     0.200
    20.270    31.067     0.200
    20.868    30.990     0.200
    21.271    29.882     0.200
    23.463    29.906     0.200
    23.943    25.502     0.200
    26.228    23.041     0.200
    27.857    18.321     0.200
    28.094    18.664     0.200
    28.094    17.864     0.200
    28.267    17.041     0.200
    28.695    13.343     0.200
    29.346    12.756     0.200
    29.742    14.031     0.200
    21.343    31.072     0.200
    25.868    23.662     0.200
    26.312    23.004     0.200
    17.771    33.428     0.200
    20.325    33.156     0.200
    20.336    33.026     0.200
    20.813    33.161     0.200
    21.142    30.223     0.200
    21.210    32.422     0.200
    21.822    34.282     0.200
    23.516    26.620     0.200
    25.783    24.052     0.200
    25.783    22.763     0.200
    26.227    22.655     0.200
    28.068    17.393     0.200
    28.250    16.873     0.200
    29.453    12.626     0.200
    29.717    13.458     0.200
    16.599    35.801     0.200
    17.930    33.160     0.200
    17.930    34.480     0.200
    19.609    34.028     0.200
    20.923    30.655     0.200
    21.287    30.091     0.200
    21.369    30.243     0.200
    22.126    34.006     0.200
    22.737    32.329     0.200
    22.737    33.461     0.200
    23.518    29.666     0.200
    25.772    23.463     0.200
    26.278    22.683     0.200
    28.315    17.287     0.200
    28.678    13.845     0.200
    29.400    12.760     0.200
    29.788    13.695     0.200
    17.917    34.523     0.200
    19.658    33.655     0.200
    21.314    30.982     0.200
    21.314    28.931     0.200
    21.357    30.672     0.200
    22.189    33.964     0.200
    24.029    24.390     0.200
    25.904    24.113     0.200
    25.904    23.664     0.200
    26.347    22.846     0.200
    28.381    16.802     0.200
    28.658    13.870     0.200
    29.472    14.056     0.200
    29.853    12.224     0.200
    17.963    33.640     0.200
    20.286    31.015     0.200
    20.297    31.903     0.200
    20.691    32.994     0.200
    20.890    30.473     0.200
    21.305    30.208     0.200
    21.305    29.630     0.200
    21.402    29.604     0.200
    21.714    33.048     0.200
    22.119    32.427     0.200
    22.776    32.256     0.200
    22.776    31.076     0.200
    23.492    28.799     0.200
    23.981    25.200     0.200
    25.736    22.820     0.200
    25.819    22.636     0.200
    26.263    22.849     0.200
    27.789    17.458     0.200
    27.881    17.787     0.200
    28.130    16.272     0.200
    28.303    17.058     0.200
    28.713    15.014     0.200
    29.366    13.178     0.200
    29.779    13.040     0.200
    21.325    28.199     0.200
    26.290    23.123     0.200
    28.331    15.947     0.200
    24.798    28.261     0.200
    26.308    22.913     0.200
    17.827    34.005     0.200
    19.738    32.504     0.200
    20.411    32.052     0.200
    20.422    31.822     0.200
    21.239    30.584     0.200
    21.239    30.134     0.200
    21.268    30.750     0.200
    21.874    32.482     0.200
    25.891    23.500     0.200
    26.334    22.341     0.200
    28.179    16.994     0.200
    28.360    16.486     0.200
    28.568    15.251     0.200
    17.933    34.404     0.200
    17.933    33.506     0.200
    18.643    34.926     0.200
    19.632    32.877     0.200
    20.366    32.018     0.200
    20.377    32.089     0.200
    20.768    34.126     0.200
    20.971    30.759     0.200
    21.318    30.012     0.200
    21.318    29.110     0.200
    21.374    30.456     0.200
    22.177    31.188     0.200
    23.570    30.322     0.200
    24.023    25.443     0.200
    25.816    23.220     0.200
    25.887    24.212     0.200
    25.887    24.080     0.200
    26.331    22.992     0.200
    27.849    16.796     0.200
    27.962    16.875     0.200
    28.191    18.244     0.200
    28.191    17.998     0.200
    28.367    17.251     0.200
    28.677    15.729     0.200
    29.839    13.463     0.200
    19.613    35.532     0.200
    17.624    35.895     0.200
    21.328    29.769     0.200
    25.829    23.833     0.200
    28.316    17.022     0.200
    17.764    36.135     0.200
    18.022    34.919     0.200
    18.022    35.036     0.200
    19.590    34.241     0.200
    20.416    32.301     0.200
    20.427    32.135     0.200
    21.001    30.970     0.200
    21.427    30.209     0.200
    21.427    29.201     0.200
    21.463    30.781     0.200
    21.802    33.427     0.200
    23.628    30.116     0.200
    24.129    25.069     0.200
    25.108    26.158     0.200
    25.828    25.936     0.200
    25.970    23.708     0.200
    26.414    23.008     0.200
    27.997    18.335     0.200
    28.284    17.653     0.200
    28.456    16.866     0.200
    28.759    14.144     0.200
    29.932    13.350     0.200
    18.008    34.390     0.200
    18.777    34.751     0.200
    18.828    34.655     0.200
    18.836    34.066     0.200
    19.959    34.215     0.200
    20.784    32.139     0.200
    20.795    31.839     0.200
    21.241    30.603     0.200
    21.170    33.925     0.200
    21.398    28.408     0.200
    21.398    30.068     0.200
    21.394    30.510     0.200
    22.207    30.533     0.200
    22.850    30.715     0.200
    24.254    24.942     0.200
    24.282    27.310     0.200
    25.177    27.164     0.200
    25.203    26.964     0.200
    25.500    25.050     0.200
    25.747    21.889     0.200
    26.247    22.985     0.200
    26.247    24.024     0.200
    26.232    22.053     0.200
    26.691    22.298     0.200
    28.167    17.869     0.200
    28.385    17.927     0.200
    28.516    16.243     0.200
    28.516    16.704     0.200
    28.516    18.130     0.200
    28.704    16.606     0.200
    21.376    30.235     0.200
    21.518    31.284     0.200
    26.229    22.385     0.200
    28.115    18.191     0.200
    28.282    16.845     0.200
    21.310    29.291     0.200
    21.310    28.951     0.200
    24.008    25.974     0.200
    25.794    25.336     0.200
    25.866    23.783     0.200
    26.309    22.715     0.200
    28.346    16.943     0.200
    29.820    13.352     0.200
    18.579    35.106     0.200
    20.336    31.200     0.200
    20.347    31.486     0.200
    20.940    30.860     0.200
    21.317    27.861     0.200
    21.317    29.251     0.200
    21.389    30.223     0.200
    21.762    33.958     0.200
    22.735    35.203     0.200
    23.541    29.498     0.200
    24.011    25.422     0.200
    24.738    26.034     0.200
    25.784    22.724     0.200
    25.863    23.300     0.200
    25.863    23.784     0.200
    26.307    22.724     0.200
    27.829    18.362     0.200
    27.931    18.173     0.200
    28.171    17.114     0.200
    28.171    17.786     0.200
    28.345    16.837     0.200
    28.695    14.140     0.200
    28.695    15.757     0.200
    29.819    13.638     0.200
    14.640    35.594     0.200
    23.499    31.439     0.200
    25.829    24.350     0.200
    26.272    23.033     0.200
    26.402    22.458     0.200
    23.508    31.902     0.200
    26.285    23.750     0.200
    20.370    34.045     0.200
    21.298    29.879     0.200
    21.298    30.613     0.200
    23.572    28.170     0.200
    25.882    23.511     0.200
    26.326    23.037     0.200
    28.360    16.903     0.200
    28.655    15.859     0.200
    29.456    13.961     0.200
    21.252    30.392     0.200
    26.263    24.013     0.200
    26.707    22.552     0.200
    28.508    18.413     0.200
    28.508    16.960     0.200
    21.307    29.791     0.200
    21.359    30.384     0.200
    24.017    25.964     0.200
    25.888    23.373     0.200
    26.332    23.056     0.200
    28.190    16.669     0.200
    28.366    17.313     0.200
    19.564    34.898     0.200
    20.268    32.856     0.200
    21.290    29.822     0.200
    21.290    30.712     0.200
    21.396    30.389     0.200
    21.700    32.637     0.200
    22.785    31.210     0.200
    23.473    29.153     0.200
    25.721    26.114     0.200
    25.798    23.993     0.200
    25.798    24.698     0.200
    26.242    22.896     0.200
    27.769    19.320     0.200
    27.863    18.014     0.200
    28.110    16.638     0.200
    28.110    17.908     0.200
    28.110    18.394     0.200
    28.283    17.121     0.200
    28.710    15.939     0.200
    29.758    13.605     0.200
    26.317    22.866     0.200
    20.280    32.370     0.200
    21.436    28.883     0.200
    21.548    28.971     0.200
    22.885    32.660     0.200
    22.885    31.070     0.200
    23.486    29.050     0.200
    24.658    27.359     0.200
    24.955    25.687     0.200
    25.669    25.684     0.200
    25.858    23.972     0.200
    25.858    23.672     0.200
    25.981    22.522     0.200
    26.302    22.894     0.200
    26.439    21.255     0.200
    28.190    17.966     0.200
    28.190    17.767     0.200
    28.356    16.723     0.200
    29.309    13.929     0.200
    29.837    13.438     0.200
    21.485    31.482     0.200
    25.674    25.896     0.200
    15.583    39.578     0.200
    19.279    37.547     0.200
    19.290    37.818     0.200
    20.884    36.120     0.200
    20.830    37.746     0.200
    21.485    35.708     0.200
    22.480    34.094     0.200
    23.484    34.674     0.200
    23.484    34.194     0.200
    24.850    32.038     0.200
    24.850    30.139     0.200
    24.830    31.864     0.200
    25.287    29.311     0.200
    25.293    29.665     0.200
    27.214    25.746     0.200
    27.367    24.462     0.200
    29.763    18.706     0.200
    26.628    23.342     0.200
    25.862    24.081     0.200
    25.862    23.780     0.200
    26.305    22.904     0.200
    28.344    16.108     0.200
    21.509    33.230     0.200
    26.016    25.934     0.200
    14.960    37.307     0.200
    19.629    32.668     0.200
    20.351    31.797     0.200
    20.362    32.326     0.200
    20.758    33.744     0.200
    20.957    30.819     0.200
    21.305    29.660     0.200
    21.305    28.941     0.200
    21.368    30.125     0.200
    21.368    30.507     0.200
    21.782    30.088     0.200
    22.159    33.594     0.200
    22.712    33.197     0.200
    22.712    34.111     0.200
    23.554    26.909     0.200
    24.829    25.986     0.200
    25.127    24.102     0.200
    25.379    23.275     0.200
    25.804    23.460     0.200
    25.870    23.842     0.200
    25.870    23.279     0.200
    26.048    22.309     0.200
    26.155    21.633     0.200
    26.313    22.836     0.200
    26.612    21.177     0.200
    26.730    22.941     0.200
    27.831    18.199     0.200
    27.948    17.639     0.200
    28.174    17.203     0.200
    28.174    17.703     0.200
    28.174    18.226     0.200
    28.349    16.858     0.200
    29.434    12.906     0.200
    29.822    13.570     0.200
    21.268    30.242     0.200
    26.335    22.774     0.200
    21.412    30.283     0.200
    23.512    30.655     0.200
    26.285    22.548     0.200
    17.961    34.190     0.200
    18.625    34.534     0.200
    19.583    33.205     0.200
    20.310    32.371     0.200
    20.321    30.146     0.200
    20.710    30.100     0.200
    20.912    31.339     0.200
    21.315    29.241     0.200
    21.315    28.644     0.200
    21.400    30.152     0.200
    21.400    30.554     0.200
    21.735    29.239     0.200
    22.139    33.722     0.200
    23.516    27.361     0.200
    23.804    27.196     0.200
    23.998    25.234     0.200
    24.300    25.309     0.200
    24.712    25.995     0.200
    25.080    25.270     0.200
    25.757    22.205     0.200
    25.842    23.917     0.200
    25.842    24.152     0.200
    25.842    24.046     0.200
    26.108    20.724     0.200
    26.285    23.182     0.200
    26.563    24.596     0.200
    26.564    20.086     0.200
    26.682    21.355     0.200
    27.810    18.343     0.200
    27.904    18.154     0.200
    28.152    18.229     0.200
    28.152    17.658     0.200
    28.152    18.858     0.200
    28.152    18.631     0.200
    28.325    16.236     0.200
    28.709    13.260     0.200
    29.388    12.684     0.200
    29.800    13.925     0.200
    21.559    32.212     0.200
    25.807    24.982     0.200
    17.667    41.356     0.200
    19.147    38.388     0.200
    20.408    37.427     0.200
    20.849    37.630     0.200
    21.075    36.396     0.200
    21.075    37.092     0.200
    22.299    38.609     0.200
    22.797    31.894     0.200
    24.538    31.673     0.200
    24.982    30.737     0.200
    27.021    25.001     0.200
    29.495    16.325     0.200
    26.347    22.496     0.200
    17.960    34.133     0.200
    19.559    34.814     0.200
    20.262    32.554     0.200
    20.273    32.126     0.200
    20.867    31.292     0.200
    21.290    29.556     0.200
    21.290    29.837     0.200
    21.398    30.264     0.200
    21.398    30.389     0.200
    21.694    32.736     0.200
    23.300    30.795     0.200
    23.467    31.748     0.200
    23.959    24.810     0.200
    24.271    28.364     0.200
    24.751    26.327     0.200
    25.794    23.998     0.200
    26.231    22.758     0.200
    26.237    22.961     0.200
    27.857    18.412     0.200
    28.105    17.818     0.200
    28.105    18.017     0.200
    28.105    18.457     0.200
    28.278    16.803     0.200
    29.753    13.685     0.200
    18.019    38.814     0.200
    18.019    39.013     0.200
    21.451    34.225     0.200
    21.360    30.486     0.200
    26.336    21.949     0.200
    28.194    17.219     0.200
    17.613    39.752     0.200
    20.028    36.063     0.200
    20.028    37.123     0.200
    20.511    37.028     0.200
    23.684    31.203     0.200
    23.827    29.729     0.200
    26.089    26.939     0.200
    26.309    26.436     0.200
    26.315    26.675     0.200
    28.163    23.935     0.200
    21.252    39.403     0.200
    21.537    35.955     0.200
    23.131    39.282     0.200
    24.435    32.800     0.200
    24.990    31.585     0.200
    25.507    29.951     0.200
    25.769    30.250     0.200
    25.945    31.562     0.200
    27.852    23.984     0.200
    15.327    40.801     0.200
    16.222    40.060     0.200
    19.250    39.354     0.200
    19.250    37.092     0.200
    19.956    37.290     0.200
    19.966    35.664     0.200
    20.538    36.595     0.200
    21.326    36.073     0.200
    21.326    34.397     0.200
    21.326    35.038     0.200
    21.354    38.267     0.200
    21.595    35.938     0.200
    23.173    35.937     0.200
    23.442    35.407     0.200
    23.864    32.182     0.200
    24.421    32.757     0.200
    24.720    32.952     0.200
    24.974    27.993     0.200
    25.376    30.832     0.200
    26.004    27.964     0.200
    26.010    29.116     0.200
    26.194    29.584     0.200
    26.328    26.018     0.200
    27.532    24.970     0.200
    27.583    24.683     0.200
    27.918    24.710     0.200
    28.077    22.517     0.200
    29.009    18.840     0.200
    21.400    37.874     0.200
    21.556    35.296     0.200
    23.206    37.097     0.200
    26.030    28.878     0.200
    26.030    28.881     0.200
    21.169    32.681     0.200
    17.594    36.274     0.200
    21.511    29.684     0.200
    21.511    30.665     0.200
    21.608    34.228     0.200
    23.426    31.506     0.200
    25.788    23.934     0.200
    25.788    24.044     0.200
    26.226    23.787     0.200
    26.232    23.229     0.200
    28.117    18.068     0.200
    15.553    36.428     0.200
    17.922    34.210     0.200
    17.922    33.960     0.200
    21.312    29.640     0.200
    21.362    30.569     0.200
    21.362    32.143     0.200
    26.331    21.879     0.200
    26.336    22.912     0.200
    26.336    22.912     0.200
    28.371    15.245     0.200
    28.664    16.227     0.200
    17.813    33.546     0.200
    17.813    33.927     0.200
    17.813    33.825     0.200
    19.681    32.780     0.200
    20.276    31.685     0.200
    20.287    31.165     0.200
    21.156    29.671     0.200
    21.156    27.911     0.200
    21.251    29.978     0.200
    21.251    29.703     0.200
    21.764    28.915     0.200
    23.470    28.414     0.200
    23.780    29.997     0.200
    25.155    24.608     0.200
    25.780    21.257     0.200
    26.189    21.410     0.200
    26.195    22.232     0.200
    26.187    22.884     0.200
    26.626    22.074     0.200
    26.641    21.761     0.200
    26.763    21.493     0.200
    27.699    16.059     0.200
    27.893    17.293     0.200
    28.043    17.698     0.200
    28.043    17.243     0.200
    28.043    16.923     0.200
    28.043    17.442     0.200
    28.222    16.251     0.200
    29.397    12.287     0.200
    29.691    13.205     0.200
    17.592    36.275     0.200
    17.921    34.364     0.200
    19.603    34.094     0.200
    19.603    33.844     0.200
    20.288    32.196     0.200
    20.299    32.198     0.200
    20.712    33.849     0.200
    20.899    30.861     0.200
    21.266    29.985     0.200
    21.360    30.565     0.200
    21.360    30.091     0.200
    21.732    31.144     0.200
    23.491    29.623     0.200
    23.785    26.887     0.200
    23.951    26.153     0.200
    24.687    27.360     0.200
    25.092    24.999     0.200
    25.752    23.432     0.200
    26.013    23.526     0.200
    26.121    23.446     0.200
    26.243    22.237     0.200
    26.248    23.118     0.200
    26.248    23.118     0.200
    26.571    23.471     0.200
    27.768    18.000     0.200
    27.889    17.797     0.200
    28.723    15.085     0.200
    29.379    13.699     0.200
    29.759    13.674     0.200
    17.947    33.964     0.200
    17.947    33.066     0.200
    19.615    34.491     0.200
    20.352    31.619     0.200
    20.363    31.414     0.200
    20.751    31.970     0.200
    20.956    31.082     0.200
    21.387    30.277     0.200
    21.387    30.152     0.200
    21.777    33.497     0.200
    23.232    31.183     0.200
    23.558    29.214     0.200
    23.847    28.839     0.200
    24.022    24.797     0.200
    24.335    27.442     0.200
    24.754    27.052     0.200
    24.818    27.873     0.200
    24.818    27.345     0.200
    25.116    25.224     0.200
    25.612    24.524     0.200
    25.799    23.056     0.200
    25.879    23.438     0.200
    25.879    23.953     0.200
    25.879    23.629     0.200
    25.963    21.444     0.200
    26.037    23.262     0.200
    26.144    23.018     0.200
    26.316    22.821     0.200
    26.322    22.873     0.200
    26.601    22.614     0.200
    26.718    21.273     0.200
    27.843    18.103     0.200
    27.947    17.494     0.200
    28.185    18.173     0.200
    28.185    17.412     0.200
    28.360    17.072     0.200
    28.403    17.051     0.200
    28.694    14.810     0.200
    28.643    17.462     0.200
    29.092    14.851     0.200
    29.833    13.279     0.200
    26.321    22.239     0.200
    21.405    30.820     0.200
    26.250    23.070     0.200
    21.096    33.609     0.200
    25.825    26.379     0.200
    25.831    26.657     0.200
    26.551    26.259     0.200
    28.450    17.413     0.200
    26.340    23.199     0.200
    26.340    23.195     0.200
    18.073    32.179     0.200
    21.512    29.650     0.200
    23.517    31.152     0.200
    25.877    24.051     0.200
    25.877    23.711     0.200
    26.315    23.162     0.200
    26.320    22.254     0.200
    28.819    15.877     0.200
    21.386    30.455     0.200
    26.251    22.928     0.200
    26.415    23.137     0.200
    17.970    32.799     0.200
    17.970    33.455     0.200
    19.548    33.969     0.200
    20.266    32.634     0.200
    20.859    31.047     0.200
    21.296    29.545     0.200
    21.408    30.033     0.200
    21.685    33.309     0.200
    23.461    30.578     0.200
    25.706    26.383     0.200
    26.234    23.053     0.200
    26.234    23.053     0.200
    26.234    22.833     0.200
    27.763    18.069     0.200
    27.849    21.164     0.200
    28.276    16.482     0.200
    28.723    12.869     0.200
    29.752    13.660     0.200
    17.954    34.821     0.200
    19.594    34.428     0.200
    20.333    31.276     0.200
    21.315    30.514     0.200
    21.394    30.758     0.200
    21.394    30.995     0.200
    21.748    31.964     0.200
    23.527    29.696     0.200
    24.311    27.346     0.200
    25.851    23.978     0.200
    26.295    23.200     0.200
    26.295    22.711     0.200
    26.576    22.068     0.200
    27.916    20.479     0.200
    28.160    18.217     0.200
    28.160    18.934     0.200
    28.160    18.455     0.200
    26.290    22.749     0.200
    26.290    22.949     0.200
    17.673    36.067     0.200
    21.339    31.981     0.200
    25.883    24.358     0.200
    26.326    22.192     0.200
    26.326    23.583     0.200
    26.326    22.641     0.200
    28.192    17.212     0.200
    18.038    38.007     0.200
    21.161    33.566     0.200
    21.161    32.226     0.200
    21.329    36.001     0.200
    21.469    32.076     0.200
    23.983    30.728     0.200
    25.784    26.247     0.200
    25.873    26.477     0.200
    25.873    24.653     0.200
    26.235    25.418     0.200
    27.466    23.185     0.200
    28.824    18.638     0.200
    28.824    15.157     0.200
    26.231    23.270     0.200
    26.307    23.150     0.200
    21.299    30.929     0.200
    28.647    15.276     0.200
    15.565    35.398     0.200
    21.319    29.552     0.200
    21.365    29.791     0.200
    21.365    29.416     0.200
    24.031    25.704     0.200
    25.835    24.953     0.200
    25.902    23.568     0.200
    26.346    22.101     0.200
    26.346    22.312     0.200
    27.981    19.613     0.200
    28.204    17.099     0.200
    28.204    17.607     0.200
    28.204    18.005     0.200
    28.667    15.804     0.200
    28.667    15.109     0.200
    29.466    13.230     0.200
    29.852    13.270     0.200
    21.129    32.464     0.200
    17.590    38.492     0.200
    20.799    35.946     0.200
    20.799    36.344     0.200
    21.022    34.052     0.200
    21.022    33.849     0.200
    23.175    33.216     0.200
    25.391    27.565     0.200
    25.835    25.940     0.200
    29.769    12.970     0.200
    17.663    31.274     0.200
    17.663    32.022     0.200
    17.663    31.900     0.200
    20.038    31.785     0.200
    21.109    28.980     0.200
    21.255    27.251     0.200
    21.255    29.272     0.200
    22.225    31.791     0.200
    23.933    27.552     0.200
    25.559    23.137     0.200
    25.809    21.933     0.200
    26.161    20.755     0.200
    26.584    19.842     0.200
    26.605    20.405     0.200
    28.375    13.236     0.200
    28.414    14.564     0.200
    28.822    12.296     0.200
    29.797    10.154     0.200
    15.438    39.911     0.200
    17.942    41.661     0.200
    19.108    39.184     0.200
    19.119    38.850     0.200
    19.797    39.545     0.200
    19.797    38.346     0.200
    20.666    37.300     0.200
    20.745    38.080     0.200
    22.295    35.291     0.200
    22.622    33.677     0.200
    22.992    32.852     0.200
    23.491    33.037     0.200
    24.031    33.322     0.200
    24.057    35.123     0.200
    24.057    34.994     0.200
    24.360    34.258     0.200
    24.734    33.727     0.200
    25.066    30.847     0.200
    25.291    31.211     0.200
    25.418    29.611     0.200
    25.761    31.543     0.200
    25.857    29.435     0.200
    26.000    28.114     0.200
    26.243    29.102     0.200
    26.643    26.445     0.200
    26.757    24.611     0.200
    26.757    25.311     0.200
    27.132    25.042     0.200
    28.310    23.363     0.200
    28.786    21.736     0.200
    28.786    21.236     0.200
    29.554    18.782     0.200
    29.594    19.208     0.200
    29.765    16.775     0.200
    29.765    17.017     0.200
    29.765    16.205     0.200
    29.945    16.060     0.200
    21.355    31.031     0.200
    21.796    30.129     0.200
    23.563    30.208     0.200
    25.874    23.538     0.200
    26.318    23.041     0.200
    26.318    22.001     0.200
    28.659    16.941     0.200
    17.440    37.372     0.200
    20.891    32.102     0.200
    20.891    32.305     0.200
    24.290    26.938     0.200
    26.443    22.811     0.200
    26.887    22.090     0.200
    28.758    17.288     0.200
    16.390    38.123     0.200
    20.042    34.305     0.200
    20.053    34.367     0.200
    20.743    33.227     0.200
    20.764    36.282     0.200
    20.764    33.243     0.200
    20.965    34.810     0.200
    21.679    32.807     0.200
    23.210    33.340     0.200
    23.454    30.884     0.200
    24.441    28.566     0.200
    25.407    25.980     0.200
    25.851    26.136     0.200
    25.851    25.386     0.200
    26.142    23.469     0.200
    26.815    23.546     0.200
    27.710    19.923     0.200
    27.858    20.092     0.200
    28.670    17.414     0.200
    29.319    17.735     0.200
    14.765    37.907     0.200
    19.400    36.812     0.200
    21.001    34.832     0.200
    21.314    35.000     0.200
    21.314    34.675     0.200
    22.588    34.607     0.200
    24.903    29.897     0.200
    25.346    29.402     0.200
    25.346    28.721     0.200
    27.239    23.530     0.200
    29.886    17.442     0.200
    21.299    34.045     0.200
    25.354    29.108     0.200
    21.387    30.277     0.200
    26.240    23.262     0.200
    28.106    17.463     0.200
    21.410    30.295     0.200
    26.282    23.031     0.200
    16.267    38.572     0.200
    17.976    34.108     0.200
    17.976    34.241     0.200
    19.407    34.830     0.200
    19.977    32.678     0.200
    20.595    31.772     0.200
    21.158    32.299     0.200
    21.408    30.787     0.200
    21.408    31.084     0.200
    21.448    33.223     0.200
    23.180    31.102     0.200
    23.740    27.770     0.200
    25.462    26.168     0.200
    25.516    25.145     0.200
    25.959    23.766     0.200
    27.841    19.477     0.200
    27.841    18.305     0.200
    29.489    15.280     0.200
    17.933    34.073     0.200
    19.626    32.859     0.200
    20.351    32.251     0.200
    20.957    30.781     0.200
    21.309    30.587     0.200
    21.309    29.368     0.200
    21.309    29.608     0.200
    21.373    29.579     0.200
    21.373    30.029     0.200
    21.781    32.062     0.200
    23.555    30.358     0.200
    24.010    24.848     0.200
    24.752    26.396     0.200
    25.125    25.704     0.200
    25.376    23.789     0.200
    25.803    21.828     0.200
    25.872    23.823     0.200
    26.316    22.154     0.200
    26.316    22.535     0.200
    27.834    18.422     0.200
    27.948    17.901     0.200
    28.177    16.696     0.200
    28.177    18.027     0.200
    28.177    18.320     0.200
    28.352    16.881     0.200
    28.677    14.982     0.200
    28.677    15.452     0.200
    29.825    13.092     0.200
    21.147    30.701     0.200
    21.147    31.631     0.200
    28.415    15.901     0.200
    20.982    31.634     0.200
    21.283    31.170     0.200
    26.849    22.179     0.200
    26.849    21.390     0.200
    26.347    22.678     0.200
    26.326    22.862     0.200
    26.326    23.519     0.200
    21.310    30.149     0.200
    21.310    31.133     0.200
    21.421    30.083     0.200
    23.466    29.071     0.200
    25.799    23.840     0.200
    26.243    23.303     0.200
    26.243    22.963     0.200
    27.851    19.395     0.200
    21.433    30.752     0.200
    26.242    22.747     0.200
    21.279    30.556     0.200
    26.356    22.544     0.200
    21.404    29.294     0.200
    21.693    30.490     0.200
    23.469    28.467     0.200
    25.797    23.997     0.200
    26.241    21.859     0.200
    21.348    29.744     0.200
    21.439    28.966     0.200
    26.292    22.895     0.200
    26.320    22.370     0.200
    26.320    22.590     0.200
    17.960    33.714     0.200
    17.960    33.035     0.200
    17.960    34.191     0.200
    19.590    34.474     0.200
    19.590    33.115     0.200
    19.726    32.581     0.200
    20.322    32.226     0.200
    20.333    31.051     0.200
    20.924    30.597     0.200
    21.320    29.599     0.200
    21.320    28.990     0.200
    21.399    29.857     0.200
    21.746    30.111     0.200
    22.243    29.010     0.200
    23.528    30.812     0.200
    24.007    26.024     0.200
    24.308    27.221     0.200
    24.724    27.348     0.200
    24.790    27.466     0.200
    25.070    23.625     0.200
    25.088    24.817     0.200
    25.088    27.208     0.200
    25.340    23.678     0.200
    25.768    22.070     0.200
    25.853    23.846     0.200
    25.853    23.963     0.200
    25.853    23.276     0.200
    25.853    24.424     0.200
    25.853    23.674     0.200
    26.009    22.282     0.200
    26.116    21.754     0.200
    26.297    22.841     0.200
    26.572    21.377     0.200
    26.572    22.783     0.200
    26.690    22.914     0.200
    27.821    18.210     0.200
    27.915    18.313     0.200
    28.163    18.422     0.200
    28.336    16.697     0.200
    28.707    15.680     0.200
    29.399    12.751     0.200
    29.811    13.490     0.200
    15.557    36.062     0.200
    17.919    34.316     0.200
    21.313    31.134     0.200
    21.313    31.489     0.200
    21.359    30.173     0.200
    21.359    30.446     0.200
    21.814    32.637     0.200
    25.899    24.172     0.200
    26.343    22.893     0.200
    28.661    15.641     0.200
    21.414    30.058     0.200
    25.829    23.331     0.200
    26.273    22.990     0.200
    26.273    22.271     0.200
    15.529    35.330     0.200
    17.632    35.141     0.200
    17.952    32.792     0.200
    17.952    33.206     0.200
    19.591    34.274     0.200
    19.591    33.824     0.200
    19.716    32.766     0.200
    20.314    32.092     0.200
    20.325    31.586     0.200
    20.918    30.243     0.200
    21.309    29.593     0.200
    21.309    29.253     0.200
    21.309    29.476     0.200
    21.392    29.761     0.200
    21.741    32.430     0.200
    22.236    28.861     0.200
    23.519    29.886     0.200
    23.995    24.831     0.200
    24.308    25.303     0.200
    24.715    25.223     0.200
    25.763    25.496     0.200
    25.842    23.952     0.200
    25.842    23.671     0.200
    26.286    22.236     0.200
    26.286    22.505     0.200
    27.908    17.460     0.200
    28.325    16.402     0.200
    28.700    14.618     0.200
    29.799    12.994     0.200
    21.389    30.750     0.200
    17.668    35.745     0.200
    17.956    34.548     0.200
    17.956    33.458     0.200
    17.956    34.981     0.200
    19.104    33.642     0.200
    19.606    33.349     0.200
    19.606    32.994     0.200
    19.606    33.923     0.200
    19.752    32.420     0.200
    20.348    31.960     0.200
    20.359    31.262     0.200
    20.359    32.332     0.200
    20.743    31.153     0.200
    20.950    30.741     0.200
    21.330    29.971     0.200
    21.330    29.233     0.200
    21.770    30.373     0.200
    22.173    31.269     0.200
    22.269    28.543     0.200
    23.554    29.546     0.200
    23.842    27.185     0.200
    24.026    26.848     0.200
    24.751    26.583     0.200
    24.810    25.146     0.200
    24.810    27.498     0.200
    24.810    26.299     0.200
    25.095    22.362     0.200
    25.108    24.780     0.200
    25.108    25.420     0.200
    25.359    23.609     0.200
    25.792    22.730     0.200
    25.878    22.588     0.200
    25.878    23.029     0.200
    25.878    23.502     0.200
    26.028    22.005     0.200
    26.135    25.833     0.200
    26.322    22.211     0.200
    26.322    21.840     0.200
    26.592    20.131     0.200
    26.592    21.201     0.200
    26.707    24.452     0.200
    26.709    20.607     0.200
    27.068    20.970     0.200
    27.844    18.184     0.200
    27.941    19.349     0.200
    28.187    17.783     0.200
    28.360    16.661     0.200
    28.700    15.991     0.200
    29.424    12.488     0.200
    29.424    13.347     0.200
    29.834    12.960     0.200
    18.768    37.521     0.200
    19.441    36.667     0.200
    19.452    36.705     0.200
    20.177    38.282     0.200
    20.586    34.449     0.200
    20.586    34.098     0.200
    21.097    34.990     0.200
    21.123    37.233     0.200
    21.416    33.516     0.200
    22.611    35.373     0.200
    23.655    32.953     0.200
    24.290    29.870     0.200
    24.856    30.362     0.200
    24.856    28.174     0.200
    25.110    26.804     0.200
    25.300    28.273     0.200
    25.787    27.538     0.200
    26.821    23.139     0.200
    27.114    24.922     0.200
    29.929    16.765     0.200
    21.097    35.278     0.200
    25.276    29.403     0.200
    13.628    42.912     0.200
    17.168    36.394     0.200
    19.642    33.383     0.200
    20.175    32.333     0.200
    20.175    33.853     0.200
    20.851    31.813     0.200
    20.863    31.462     0.200
    21.005    30.222     0.200
    21.005    30.771     0.200
    21.209    30.140     0.200
    21.336    32.554     0.200
    22.356    28.654     0.200
    22.651    28.376     0.200
    22.802    29.252     0.200
    23.372    31.995     0.200
    24.031    30.206     0.200
    24.133    26.220     0.200
    24.363    28.829     0.200
    24.911    27.136     0.200
    25.226    27.054     0.200
    25.573    22.501     0.200
    25.647    24.646     0.200
    25.697    23.569     0.200
    25.947    21.836     0.200
    26.225    23.214     0.200
    26.374    23.066     0.200
    26.669    22.232     0.200
    26.669    21.522     0.200
    27.180    19.313     0.200
    27.662    18.081     0.200
    28.108    15.493     0.200
    28.108    16.923     0.200
    28.507    14.923     0.200
    28.485    17.128     0.200
    28.659    16.202     0.200
    29.659    11.827     0.200
    26.343    22.770     0.200
    25.899    26.130     0.200
    21.165    30.275     0.200
    23.917    30.814     0.200
    26.606    21.785     0.200
    29.834    13.316     0.200
    17.977    34.330     0.200
    17.977    33.862     0.200
    17.977    34.440     0.200
    19.571    32.839     0.200
    19.571    33.043     0.200
    19.718    32.023     0.200
    20.311    31.803     0.200
    20.322    31.547     0.200
    20.703    33.026     0.200
    20.910    30.609     0.200
    21.331    29.271     0.200
    21.331    29.642     0.200
    21.331    28.599     0.200
    21.416    30.006     0.200
    21.416    30.405     0.200
    21.730    32.748     0.200
    22.150    33.145     0.200
    22.230    30.504     0.200
    23.518    29.676     0.200
    24.715    26.810     0.200
    24.772    24.567     0.200
    25.070    24.141     0.200
    25.321    22.866     0.200
    25.752    25.804     0.200
    25.849    23.225     0.200
    25.849    23.374     0.200
    25.849    23.534     0.200
    26.206    21.898     0.200
    26.293    22.056     0.200
    26.293    22.857     0.200
    27.820    16.775     0.200
    27.902    19.014     0.200
    28.334    16.375     0.200
    28.450    15.261     0.200
    28.725    16.015     0.200
    28.725    15.015     0.200
    28.741    15.875     0.200
    29.809    12.959     0.200
    15.215    38.710     0.200
    15.215    37.171     0.200
    15.840    39.510     0.200
    17.766    38.554     0.200
    18.234    36.036     0.200
    18.850    36.194     0.200
    18.990    36.251     0.200
    19.358    35.995     0.200
    19.358    36.956     0.200
    19.358    36.854     0.200
    19.358    36.706     0.200
    19.514    36.237     0.200
    20.704    35.174     0.200
    20.704    34.697     0.200
    20.704    38.455     0.200
    20.704    35.470     0.200
    20.704    36.713     0.200
    21.185    33.593     0.200
    21.185    34.039     0.200
    21.264    40.719     0.200
    22.500    35.593     0.200
    22.682    33.571     0.200
    23.021    36.109     0.200
    23.186    34.890     0.200
    23.877    30.617     0.200
    23.975    29.561     0.200
    23.975    32.381     0.200
    23.975    29.881     0.200
    24.333    30.803     0.200
    24.408    28.979     0.200
    24.408    29.925     0.200
    24.408    32.878     0.200
    24.710    28.004     0.200
    24.977    25.243     0.200
    24.977    27.087     0.200
    24.954    27.981     0.200
    24.954    30.895     0.200
    24.954    27.473     0.200
    25.398    26.717     0.200
    25.639    28.660     0.200
    25.762    25.623     0.200
    26.127    25.570     0.200
    26.205    24.259     0.200
    26.341    26.172     0.200
    26.607    24.283     0.200
    26.655    24.013     0.200
    26.930    23.391     0.200
    27.160    23.305     0.200
    27.439    26.759     0.200
    28.586    18.224     0.200
    28.712    17.092     0.200
    28.890    17.676     0.200
    28.917    18.807     0.200
    29.103    20.537     0.200
    29.180    17.686     0.200
    29.180    21.436     0.200
    29.180    20.343     0.200
    29.573    15.533     0.200
    29.732    17.190     0.200
    29.747    16.970     0.200
    29.747    19.041     0.200
    29.990    14.481     0.200
    17.823    39.058     0.200
    17.823    38.503     0.200
    20.753    35.411     0.200
    21.242    34.460     0.200
    25.407    28.682     0.200
    14.820    37.709     0.200
    17.917    38.165     0.200
    18.825    38.071     0.200
    19.213    35.639     0.200
    19.213    34.772     0.200
    19.213    37.420     0.200
    20.824    34.573     0.200
    20.824    33.464     0.200
    20.824    36.745     0.200
    20.824    35.167     0.200
    21.032    36.813     0.200
    21.336    32.621     0.200
    21.336    33.371     0.200
    22.639    36.262     0.200
    23.836    31.234     0.200
    23.835    33.702     0.200
    24.273    30.933     0.200
    24.273    31.449     0.200
    24.575    29.578     0.200
    24.841    26.584     0.200
    25.030    30.460     0.200
    25.403    28.878     0.200
    25.503    26.211     0.200
    25.625    26.292     0.200
    26.069    27.094     0.200
    26.205    27.606     0.200
    26.205    28.247     0.200
    26.478    25.427     0.200
    26.478    27.810     0.200
    28.738    18.085     0.200
    29.879    13.470     0.200
    17.645    37.419     0.200
    21.063    35.334     0.200
    24.786    27.933     0.200
    25.841    26.026     0.200
    21.165    34.258     0.200
    25.395    28.134     0.200
    14.765    37.246     0.200
    20.672    35.339     0.200
    20.672    35.698     0.200
    21.142    34.525     0.200
    29.139    16.055     0.200
    29.535    12.500     0.200
    14.742    36.918     0.200
    15.216    38.184     0.200
    16.750    39.085     0.200
    17.768    38.261     0.200
    17.768    38.699     0.200
    19.504    36.348     0.200
    19.515    37.161     0.200
    20.707    33.831     0.200
    20.707    34.550     0.200
    21.139    36.567     0.200
    21.188    34.054     0.200
    21.188    34.397     0.200
    22.683    32.844     0.200
    24.709    27.970     0.200
    24.956    29.619     0.200
    25.400    28.653     0.200
    27.161    24.087     0.200
    28.713    18.401     0.200
    28.713    20.612     0.200
    28.919    19.871     0.200
    29.991    16.555     0.200
    21.225    34.095     0.200
    20.777    35.836     0.200
    20.777    33.602     0.200
    21.266    34.094     0.200
    22.675    34.816     0.200
    24.974    29.188     0.200
    28.667    19.594     0.200
    19.521    36.304     0.200
    20.699    35.961     0.200
    20.699    36.227     0.200
    21.148    36.724     0.200
    21.177    33.917     0.200
    21.177    33.190     0.200
    22.688    34.653     0.200
    24.341    31.068     0.200
    24.958    29.470     0.200
    25.401    28.073     0.200
    15.860    38.408     0.200
    16.768    37.410     0.200
    16.768    37.566     0.200
    17.767    38.155     0.200
    17.767    38.553     0.200
    17.767    37.350     0.200
    17.767    38.311     0.200
    18.871    35.965     0.200
    19.366    34.238     0.200
    19.366    35.183     0.200
    19.366    35.683     0.200
    19.366    35.035     0.200
    19.523    35.653     0.200
    19.535    35.060     0.200
    19.535    35.623     0.200
    19.535    35.826     0.200
    20.716    32.627     0.200
    20.716    33.806     0.200
    20.716    33.635     0.200
    20.716    33.494     0.200
    21.155    33.304     0.200
    21.187    33.691     0.200
    21.284    32.404     0.200
    21.487    32.342     0.200
    22.509    35.416     0.200
    22.703    31.850     0.200
    23.041    31.102     0.200
    23.204    28.899     0.200
    23.655    29.632     0.200
    23.898    30.099     0.200
    23.985    27.956     0.200
    23.985    31.784     0.200
    23.985    30.589     0.200
    24.352    28.207     0.200
    24.419    28.736     0.200
    24.419    30.119     0.200
    24.419    30.525     0.200
    24.721    27.762     0.200
    24.721    27.996     0.200
    24.721    28.496     0.200
    24.975    27.061     0.200
    24.975    28.498     0.200
    24.975    28.326     0.200
    24.975    27.584     0.200
    24.988    28.779     0.200
    24.988    29.677     0.200
    25.149    26.201     0.200
    25.419    27.211     0.200
    25.650    25.373     0.200
    25.650    25.951     0.200
    25.650    26.060     0.200
    25.773    24.262     0.200
    25.773    24.918     0.200
    25.773    25.325     0.200
    25.773    26.934     0.200
    26.140    26.841     0.200
    26.216    25.457     0.200
    26.216    23.832     0.200
    26.216    24.747     0.200
    26.216    26.551     0.200
    26.352    25.070     0.200
    26.352    26.164     0.200
    26.353    25.658     0.200
    26.620    25.798     0.200
    26.641    23.377     0.200
    26.951    21.581     0.200
    27.180    21.103     0.200
    27.460    20.733     0.200
    28.585    18.902     0.200
    28.730    16.045     0.200
    28.730    16.905     0.200
    28.938    18.292     0.200
    29.756    12.837     0.200
    20.590    35.436     0.200
    21.067    34.182     0.200
    25.415    28.377     0.200
    19.512    36.099     0.200
    20.586    36.392     0.200
    21.065    34.695     0.200
    21.065    34.898     0.200
    24.353    32.223     0.200
    28.469    19.988     0.200
    21.176    36.105     0.200
    20.785    36.814     0.200
    20.785    35.820     0.200
    21.280    34.618     0.200
    21.280    33.144     0.200
    21.434    32.938     0.200
    22.666    34.064     0.200
    23.862    32.806     0.200
    24.969    28.291     0.200
    25.412    28.925     0.200
    25.412    28.255     0.200
    28.680    16.376     0.200
    21.083    34.556     0.200
    25.349    27.951     0.200
    21.178    34.825     0.200
    22.670    36.684     0.200
    24.940    28.389     0.200
    25.384    28.492     0.200
    28.580    18.416     0.200
    29.736    14.828     0.200
    21.104    35.145     0.200
    25.479    27.677     0.200
    21.259    33.987     0.200
    25.406    27.882     0.200
    21.144    34.186     0.200
    25.369    27.685     0.200
    19.500    37.358     0.200
    20.773    36.251     0.200
    20.773    34.172     0.200
    20.773    36.805     0.200
    20.773    33.805     0.200
    21.263    33.962     0.200
    22.674    33.819     0.200
    24.971    29.212     0.200
    25.415    27.496     0.200
    25.415    26.879     0.200
    28.663    19.827     0.200
    21.281    34.158     0.200
    21.281    34.056     0.200
    22.668    34.376     0.200
    24.632    28.088     0.200
    24.971    28.702     0.200
    25.414    27.947     0.200
    25.414    27.564     0.200
    26.126    25.523     0.200
    28.682    17.894     0.200
    17.731    37.840     0.200
    19.498    36.970     0.200
    19.509    37.097     0.200
    20.667    36.745     0.200
    20.667    36.926     0.200
    21.149    33.898     0.200
    21.149    34.392     0.200
    21.149    34.692     0.200
    21.466    33.202     0.200
    22.673    33.411     0.200
    24.334    29.826     0.200
    24.934    28.402     0.200
    24.934    29.121     0.200
    24.934    29.432     0.200
    25.140    27.623     0.200
    25.378    27.814     0.200
    26.226    24.943     0.200
    26.226    25.863     0.200
    27.160    23.545     0.200
    27.416    21.362     0.200
    28.552    21.506     0.200
    28.552    16.806     0.200
    28.893    19.230     0.200
    29.985    15.977     0.200
    17.702    37.937     0.200
    19.530    36.078     0.200
    20.650    35.568     0.200
    20.650    34.986     0.200
    20.650    33.166     0.200
    20.650    35.978     0.200
    21.122    34.366     0.200
    21.122    34.565     0.200
    24.359    29.482     0.200
    24.944    28.755     0.200
    24.944    28.865     0.200
    25.388    27.745     0.200
    25.388    27.456     0.200
    25.815    25.462     0.200
    27.185    24.010     0.200
    27.423    21.832     0.200
    28.523    18.996     0.200
    28.898    18.912     0.200
    21.194    34.408     0.200
    25.394    27.663     0.200
    21.169    33.899     0.200
    22.662    33.669     0.200
    25.374    28.413     0.200
    28.893    17.458     0.200
    29.183    15.828     0.200
    21.084    34.117     0.200
    25.374    28.712     0.200
    19.396    36.966     0.200
    21.145    34.641     0.200
    24.952    29.331     0.200
    25.396    28.529     0.200
    28.546    17.198     0.200
    25.399    27.996     0.200
    14.748    36.871     0.200
    15.067    38.640     0.200
    15.977    39.323     0.200
    17.652    38.869     0.200
    17.652    39.396     0.200
    17.652    39.978     0.200
    17.652    39.279     0.200
    18.956    35.061     0.200
    19.629    35.205     0.200
    19.641    35.400     0.200
    20.333    34.094     0.200
    20.332    34.998     0.200
    20.660    34.446     0.200
    20.660    34.977     0.200
    20.660    35.087     0.200
    21.074    35.844     0.200
    21.074    36.145     0.200
    21.289    35.233     0.200
    21.602    32.386     0.200
    22.800    31.097     0.200
    23.203    29.203     0.200
    23.996    30.248     0.200
    24.472    29.082     0.200
    24.861    31.343     0.200
    25.036    28.501     0.200
    25.036    28.313     0.200
    25.128    30.130     0.200
    25.480    27.252     0.200
    25.480    27.541     0.200
    25.913    28.673     0.200
    27.298    23.214     0.200
    27.508    21.960     0.200
    28.465    21.194     0.200
    25.393    28.399     0.200
    17.744    38.477     0.200
    19.520    36.118     0.200
    19.520    36.454     0.200
    20.686    34.750     0.200
    20.686    34.922     0.200
    20.686    35.664     0.200
    21.164    34.332     0.200
    24.951    28.509     0.200
    24.951    30.157     0.200
    25.395    27.557     0.200
    25.395    28.323     0.200
    26.359    28.431     0.200
    28.723    19.848     0.200
    14.674    39.542     0.200
    17.731    41.460     0.200
    21.149    36.150     0.200
    25.337    30.947     0.200
    21.056    35.012     0.200
    22.677    34.034     0.200
    25.352    28.176     0.200
    14.817    39.577     0.200
    17.775    38.426     0.200
    17.775    39.493     0.200
    21.132    36.900     0.200
    21.194    34.704     0.200
    21.463    33.544     0.200
    22.679    34.551     0.200
    24.954    28.317     0.200
    24.954    29.196     0.200
    25.398    27.030     0.200
    25.398    28.120     0.200
    26.663    23.690     0.200
    28.595    21.009     0.200
    20.768    36.172     0.200
    20.768    37.148     0.200
    21.260    34.314     0.200
    21.260    33.841     0.200
    22.670    35.091     0.200
    25.410    28.236     0.200
    28.661    18.572     0.200
    21.148    34.913     0.200
    25.399    28.216     0.200
    25.384    27.746     0.200
    29.117    14.870     0.200
    29.732    14.226     0.200
    17.785    38.650     0.200
    17.785    39.150     0.200
    17.785    39.259     0.200
    18.838    36.454     0.200
    19.488    36.970     0.200
    19.500    36.893     0.200
    20.715    35.884     0.200
    20.715    36.001     0.200
    20.715    37.455     0.200
    20.715    36.212     0.200
    21.119    37.132     0.200
    21.203    35.274     0.200
    21.203    34.852     0.200
    21.451    33.864     0.200
    22.668    34.359     0.200
    23.864    32.100     0.200
    24.386    29.645     0.200
    24.688    30.606     0.200
    24.947    28.910     0.200
    24.947    29.566     0.200
    25.390    28.553     0.200
    25.390    28.772     0.200
    25.617    29.341     0.200
    25.740    29.156     0.200
    26.183    27.425     0.200
    27.143    24.635     0.200
    28.913    19.388     0.200
    29.975    15.085     0.200
    14.644    36.857     0.200
    20.593    35.735     0.200
    20.593    32.535     0.200
    21.075    34.735     0.200
    21.075    34.910     0.200
    24.347    29.525     0.200
    24.903    28.638     0.200
    25.346    27.659     0.200
    21.260    33.497     0.200
    21.260    35.597     0.200
    22.681    33.614     0.200
    24.977    28.527     0.200
    25.421    27.919     0.200
    25.421    28.060     0.200
    25.421    28.339     0.200
    16.704    39.845     0.200
    19.378    36.478     0.200
    20.654    36.612     0.200
    20.654    36.855     0.200
    20.654    37.085     0.200
    20.654    35.386     0.200
    21.134    36.578     0.200
    21.147    35.037     0.200
    22.653    34.553     0.200
    23.849    33.499     0.200
    25.358    28.452     0.200
    28.872    19.375     0.200
    20.734    36.009     0.200
    21.213    34.040     0.200
    21.213    33.814     0.200
    22.688    33.796     0.200
    26.281    23.130     0.200
    21.230    33.903     0.200
    22.693    31.427     0.200
    25.424    26.502     0.200
    21.103    33.318     0.200
    21.103    33.920     0.200
    21.173    36.400     0.200
    22.675    33.870     0.200
    24.349    30.841     0.200
    25.365    27.516     0.200
    25.365    28.676     0.200
    16.853    37.988     0.200
    17.849    39.004     0.200
    17.849    39.765     0.200
    19.567    36.257     0.200
    19.578    35.456     0.200
    20.235    34.758     0.200
    20.820    35.665     0.200
    20.820    36.180     0.200
    20.820    37.036     0.200
    21.157    36.696     0.200
    21.270    34.176     0.200
    21.270    33.776     0.200
    22.754    34.867     0.200
    23.304    28.942     0.200
    23.679    33.615     0.200
    23.950    32.910     0.200
    24.691    28.872     0.200
    24.691    31.952     0.200
    25.052    28.249     0.200
    25.052    28.839     0.200
    25.496    27.373     0.200
    25.496    26.582     0.200
    29.024    18.192     0.200
    17.635    38.379     0.200
    17.635    38.014     0.200
    17.635    39.169     0.200
    17.635    39.379     0.200
    18.888    36.441     0.200
    19.567    36.521     0.200
    19.578    36.458     0.200
    20.609    35.835     0.200
    20.609    35.724     0.200
    20.609    33.454     0.200
    20.609    36.565     0.200
    21.055    34.380     0.200
    21.055    33.856     0.200
    21.245    35.637     0.200
    21.543    32.558     0.200
    22.735    34.045     0.200
    23.931    30.396     0.200
    24.417    29.217     0.200
    24.966    28.204     0.200
    24.966    28.713     0.200
    24.966    29.023     0.200
    25.410    26.785     0.200
    25.410    27.174     0.200
    27.437    21.675     0.200
    15.269    41.844     0.200
    16.816    40.797     0.200
    17.850    39.124     0.200
    20.800    38.065     0.200
    20.800    36.690     0.200
    21.126    38.297     0.200
    21.270    34.137     0.200
    21.270    34.707     0.200
    23.911    32.488     0.200
    25.014    29.973     0.200
    25.014    30.473     0.200
    25.123    28.648     0.200
    25.458    28.898     0.200
    25.458    27.952     0.200
    26.573    26.208     0.200
    27.506    23.839     0.200
    28.666    20.997     0.200
    20.703    35.503     0.200
    21.186    33.503     0.200
    21.186    33.078     0.200
    24.950    29.843     0.200
    25.394    27.275     0.200
    25.394    27.126     0.200
    25.436    27.674     0.200
    17.825    37.887     0.200
    17.825    37.777     0.200
    19.504    36.991     0.200
    20.757    34.628     0.200
    20.757    35.147     0.200
    21.244    33.757     0.200
    21.244    33.554     0.200
    24.967    28.858     0.200
    24.967    29.108     0.200
    24.967    29.471     0.200
    25.411    28.404     0.200
    25.411    27.751     0.200
    27.458    22.046     0.200
    28.645    20.093     0.200
    17.832    38.061     0.200
    17.832    38.206     0.200
    19.497    35.250     0.200
    20.760    33.869     0.200
    20.760    35.135     0.200
    20.760    35.588     0.200
    20.760    35.748     0.200
    21.251    34.062     0.200
    21.251    33.960     0.200
    24.964    28.529     0.200
    24.964    29.232     0.200
    25.407    28.192     0.200
    25.407    27.879     0.200
    28.652    19.893     0.200
    28.936    18.878     0.200
    18.844    36.436     0.200
    19.469    36.752     0.200
    19.480    38.382     0.200
    21.051    35.587     0.200
    21.331    33.694     0.200
    21.331    36.719     0.200
    22.659    32.819     0.200
    23.855    32.660     0.200
    24.273    34.389     0.200
    24.590    30.439     0.200
    24.978    31.456     0.200
    25.422    29.640     0.200
    25.519    29.964     0.200
    27.105    25.032     0.200
    28.966    19.561     0.200
    29.954    17.588     0.200
    20.564    33.665     0.200
    21.043    35.052     0.200
    21.043    33.376     0.200
    17.903    38.111     0.200
    17.903    38.268     0.200
    19.625    35.768     0.200
    20.234    34.164     0.200
    20.245    33.344     0.200
    20.245    34.297     0.200
    20.852    32.954     0.200
    21.221    32.168     0.200
    21.221    33.266     0.200
    21.221    34.547     0.200
    21.221    33.860     0.200
    21.341    33.105     0.200
    21.693    33.236     0.200
    22.163    32.451     0.200
    23.435    30.916     0.200
    25.744    25.862     0.200
    25.744    26.823     0.200
    26.188    25.364     0.200
    28.224    19.219     0.200
    28.659    19.446     0.200
    25.847    24.174     0.200
    26.290    22.958     0.200
    17.718    38.896     0.200
    17.718    39.275     0.200
    18.861    36.835     0.200
    19.524    37.800     0.200
    19.535    36.898     0.200
    20.668    36.625     0.200
    20.668    36.238     0.200
    20.668    36.344     0.200
    20.668    37.105     0.200
    21.137    35.271     0.200
    21.137    34.771     0.200
    21.493    33.826     0.200
    22.699    34.346     0.200
    23.894    31.797     0.200
    24.956    29.376     0.200
    24.956    30.368     0.200
    25.167    27.646     0.200
    25.400    28.498     0.200
    25.807    26.565     0.200
    28.912    19.245     0.200
    25.387    28.521     0.200
    14.966    36.139     0.200
    17.942    33.476     0.200
    17.942    34.108     0.200
    17.942    34.007     0.200
    17.942    34.663     0.200
    19.624    32.780     0.200
    19.624    33.397     0.200
    19.624    34.272     0.200
    19.764    31.743     0.200
    20.363    31.253     0.200
    20.374    31.946     0.200
    20.374    34.422     0.200
    20.762    31.102     0.200
    20.967    30.711     0.200
    21.324    29.011     0.200
    21.324    29.378     0.200
    21.324    29.238     0.200
    21.382    30.157     0.200
    21.382    29.063     0.200
    21.788    30.127     0.200
    22.179    29.962     0.200
    22.285    28.324     0.200
    22.814    33.858     0.200
    23.568    28.850     0.200
    24.027    24.699     0.200
    24.765    27.184     0.200
    24.828    26.823     0.200
    24.828    27.127     0.200
    24.828    27.542     0.200
    25.112    23.630     0.200
    25.126    25.214     0.200
    25.126    26.769     0.200
    25.126    26.230     0.200
    25.378    23.618     0.200
    25.378    25.532     0.200
    25.810    22.983     0.200
    25.887    23.511     0.200
    25.887    23.612     0.200
    26.047    22.470     0.200
    26.047    24.127     0.200
    26.153    23.978     0.200
    26.331    22.763     0.200
    26.610    21.839     0.200
    26.610    22.644     0.200
    26.610    22.097     0.200
    26.726    22.703     0.200
    26.728    23.093     0.200
    27.087    19.693     0.200
    27.851    16.874     0.200
    27.958    17.624     0.200
    28.205    18.236     0.200
    28.368    16.634     0.200
    28.685    12.733     0.200
    28.685    13.030     0.200
    28.679    13.022     0.200
    29.441    12.942     0.200
    29.441    14.309     0.200
    29.841    13.044     0.200
    16.717    37.628     0.200
    17.692    37.403     0.200
    17.692    38.942     0.200
    17.692    37.641     0.200
    17.692    37.742     0.200
    18.842    36.131     0.200
    19.420    34.357     0.200
    19.420    36.724     0.200
    19.510    35.530     0.200
    19.521    35.608     0.200
    20.222    36.317     0.200
    20.636    34.484     0.200
    20.636    34.214     0.200
    21.111    34.019     0.200
    21.111    34.343     0.200
    21.175    33.401     0.200
    21.482    32.819     0.200
    22.559    36.245     0.200
    22.682    31.608     0.200
    23.032    31.723     0.200
    23.134    29.337     0.200
    23.878    30.056     0.200
    24.031    32.968     0.200
    24.353    27.511     0.200
    24.461    29.375     0.200
    24.461    31.804     0.200
    24.461    30.546     0.200
    24.461    30.304     0.200
    24.764    27.279     0.200
    24.764    28.822     0.200
    24.931    27.933     0.200
    24.931    28.116     0.200
    24.931    27.659     0.200
    25.032    29.789     0.200
    25.164    25.644     0.200
    25.693    28.171     0.200
    25.693    26.082     0.200
    25.817    26.026     0.200
    25.817    27.584     0.200
    26.176    26.739     0.200
    26.259    24.665     0.200
    26.259    26.176     0.200
    26.396    27.465     0.200
    26.398    25.854     0.200
    26.657    25.326     0.200
    26.657    23.447     0.200
    26.896    22.738     0.200
    27.178    21.443     0.200
    27.409    21.647     0.200
    28.513    16.198     0.200
    28.513    17.459     0.200
    28.507    17.248     0.200
    28.739    16.767     0.200
    28.739    16.986     0.200
    28.884    18.032     0.200
    29.133    16.403     0.200
    29.133    17.013     0.200
    29.675    12.871     0.200
    29.675    13.004     0.200
    29.675    13.261     0.200
    29.998    15.030     0.200
    14.666    38.896     0.200
    17.686    38.473     0.200
    20.621    36.029     0.200
    20.621    37.107     0.200
    21.105    35.060     0.200
    21.105    35.861     0.200
    25.356    28.099     0.200
    29.662    17.994     0.200
    21.120    32.162     0.200
    21.122    35.151     0.200
    21.122    33.952     0.200
    25.371    27.178     0.200
    21.422    30.227     0.200
    26.321    21.942     0.200
    26.321    22.282     0.200
    21.063    35.226     0.200
    25.885    27.874     0.200
    21.066    34.527     0.200
    25.340    27.983     0.200
    21.411    30.036     0.200
    21.411    31.036     0.200
    23.549    29.083     0.200
    26.322    23.772     0.200
    26.322    22.643     0.200
    26.322    22.932     0.200
    28.716    14.487     0.200
    26.119    21.202     0.200
    26.316    23.230     0.200
    26.316    22.741     0.200
    20.970    30.956     0.200
    21.360    28.271     0.200
    21.360    30.296     0.200
    23.565    28.665     0.200
    25.878    24.076     0.200
    25.878    23.755     0.200
    26.322    22.717     0.200
    14.865    38.893     0.200
    21.263    34.810     0.200
    25.439    28.956     0.200
    15.467    39.858     0.200
    20.978    34.251     0.200
    21.274    34.394     0.200
    21.274    32.793     0.200
    21.821    37.504     0.200
    23.549    33.540     0.200
    25.836    27.754     0.200
    25.836    27.934     0.200
    26.280    26.816     0.200
    27.964    22.220     0.200
    26.322    21.794     0.200
    21.219    32.243     0.200
    26.260    22.948     0.200
    21.393    30.276     0.200
    25.807    24.519     0.200
    26.251    23.732     0.200
    26.251    22.662     0.200
    17.729    35.815     0.200
    19.612    33.497     0.200
    20.949    30.941     0.200
    21.320    29.408     0.200
    21.320    30.428     0.200
    21.320    30.307     0.200
    21.387    30.606     0.200
    21.387    29.528     0.200
    21.771    32.349     0.200
    23.551    31.179     0.200
    25.872    23.560     0.200
    25.872    24.392     0.200
    25.872    23.079     0.200
    26.316    22.421     0.200
    26.316    22.933     0.200
    17.711    38.688     0.200
    19.442    37.818     0.200
    19.453    37.904     0.200
    20.617    36.185     0.200
    20.617    36.404     0.200
    20.617    36.302     0.200
    20.617    36.607     0.200
    21.111    37.832     0.200
    21.128    34.959     0.200
    21.128    33.638     0.200
    22.615    35.392     0.200
    24.286    29.993     0.200
    24.870    30.280     0.200
    25.313    28.040     0.200
    27.110    23.828     0.200
    21.172    33.770     0.200
    21.172    31.423     0.200
    26.175    23.275     0.200
    29.760    12.909     0.200
    26.251    22.712     0.200
    15.550    35.784     0.200
    20.792    31.406     0.200
    21.381    30.208     0.200
    21.381    31.040     0.200
    21.381    33.938     0.200
    21.522    30.243     0.200
    23.423    29.407     0.200
    25.184    24.431     0.200
    25.788    24.403     0.200
    25.788    24.504     0.200
    25.788    23.614     0.200
    25.854    22.570     0.200
    26.232    21.707     0.200
    26.232    23.227     0.200
    26.232    22.258     0.200
    29.275    16.661     0.200
    15.766    35.507     0.200
    17.500    36.177     0.200
    18.189    34.173     0.200
    18.246    33.973     0.200
    20.477    33.840     0.200
    20.477    33.037     0.200
    20.477    33.737     0.200
    20.477    32.487     0.200
    20.840    31.271     0.200
    20.840    31.095     0.200
    21.182    31.198     0.200
    21.213    30.440     0.200
    21.213    29.325     0.200
    21.213    29.546     0.200
    21.213    33.506     0.200
    21.839    30.039     0.200
    22.329    29.770     0.200
    22.697    30.932     0.200
    23.131    29.161     0.200
    23.681    30.945     0.200
    24.340    27.554     0.200
    25.602    25.329     0.200
    25.723    23.809     0.200
    25.982    25.089     0.200
    26.020    23.234     0.200
    26.268    22.655     0.200
    26.477    21.919     0.200
    26.477    22.019     0.200
    26.477    22.719     0.200
    26.477    22.119     0.200
    26.477    22.479     0.200
    26.715    22.743     0.200
    26.921    20.637     0.200
    26.921    21.247     0.200
    26.939    22.824     0.200
    27.041    20.797     0.200
    27.615    19.620     0.200
    27.779    17.869     0.200
    28.061    16.108     0.200
    28.061    15.128     0.200
    28.054    14.967     0.200
    28.675    15.329     0.200
    28.818    16.098     0.200
    28.887    15.491     0.200
    29.114    15.639     0.200
    15.421    38.591     0.200
    17.502    37.393     0.200
    18.095    34.677     0.200
    18.095    34.802     0.200
    21.300    31.521     0.200
    21.300    33.978     0.200
    21.300    34.177     0.200
    21.445    35.590     0.200
    21.529    31.684     0.200
    21.529    32.009     0.200
    23.244    32.494     0.200
    23.538    28.588     0.200
    25.616    26.076     0.200
    25.616    26.318     0.200
    25.616    25.748     0.200
    26.059    25.542     0.200
    26.059    25.104     0.200
    26.298    25.380     0.200
    21.227    30.729     0.200
    21.227    30.129     0.200
    21.232    30.432     0.200
    21.232    28.863     0.200
    21.946    31.539     0.200
    23.670    29.321     0.200
    24.523    26.886     0.200
    25.939    23.434     0.200
    26.330    22.888     0.200
    26.383    22.695     0.200
    26.383    21.545     0.200
    28.219    16.326     0.200
    28.521    15.944     0.200
    16.256    38.533     0.200
    19.450    37.376     0.200
    19.450    36.481     0.200
    19.967    36.223     0.200
    20.588    33.673     0.200
    21.082    35.223     0.200
    21.082    35.407     0.200
    21.340    34.323     0.200
    21.340    34.495     0.200
    23.153    35.737     0.200
    25.468    30.728     0.200
    25.468    28.441     0.200
    25.912    27.284     0.200
    25.912    26.846     0.200
    26.378    26.132     0.200
    26.824    24.941     0.200
    27.572    20.478     0.200
    21.045    30.460     0.200
    21.045    30.725     0.200
    25.703    24.995     0.200
    28.412    18.153     0.200
    28.412    19.153     0.200
    15.529    36.896     0.200
    15.529    36.197     0.200
    17.910    34.331     0.200
    17.910    36.112     0.200
    17.910    34.823     0.200
    19.752    32.725     0.200
    20.410    31.545     0.200
    20.967    30.842     0.200
    21.291    30.371     0.200
    21.291    29.960     0.200
    21.291    29.621     0.200
    21.350    30.694     0.200
    21.350    30.569     0.200
    22.834    32.554     0.200
    23.559    29.188     0.200
    24.845    28.082     0.200
    25.112    27.069     0.200
    25.869    24.471     0.200
    25.869    24.233     0.200
    25.869    24.694     0.200
    25.869    23.432     0.200
    25.869    22.932     0.200
    25.816    24.654     0.200
    26.299    23.011     0.200
    26.306    22.732     0.200
    26.313    23.356     0.200
    26.628    22.861     0.200
    27.101    22.050     0.200
    27.828    15.575     0.200
    27.956    20.073     0.200
    28.171    18.402     0.200
    28.171    18.586     0.200
    28.171    18.785     0.200
    28.347    16.516     0.200
    28.655    14.721     0.200
    28.655    16.081     0.200
    28.655    16.382     0.200
    28.655    17.022     0.200
    29.819    13.538     0.200
    24.288    26.308     0.200
    25.322    25.223     0.200
    26.329    22.056     0.200
    26.329    22.735     0.200
    16.307    37.707     0.200
    17.353    37.205     0.200
    17.353    36.763     0.200
    19.417    34.414     0.200
    19.433    35.618     0.200
    19.433    35.028     0.200
    19.433    35.825     0.200
    20.070    32.795     0.200
    20.028    33.643     0.200
    20.634    32.708     0.200
    21.170    33.547     0.200
    21.170    30.852     0.200
    21.170    31.051     0.200
    21.400    32.196     0.200
    21.484    35.088     0.200
    21.945    30.214     0.200
    22.608    34.481     0.200
    23.220    29.334     0.200
    23.463    29.697     0.200
    24.121    31.317     0.200
    24.590    28.411     0.200
    24.590    29.450     0.200
    24.779    27.640     0.200
    24.889    29.119     0.200
    24.889    28.561     0.200
    25.500    25.526     0.200
    25.552    25.456     0.200
    25.552    26.574     0.200
    25.552    26.816     0.200
    25.552    26.316     0.200
    25.812    24.774     0.200
    25.924    23.734     0.200
    25.983    24.993     0.200
    25.990    24.811     0.200
    25.996    25.159     0.200
    25.996    25.288     0.200
    26.347    26.042     0.200
    26.376    23.438     0.200
    26.831    24.815     0.200
    26.831    25.608     0.200
    26.831    24.596     0.200
    27.621    20.971     0.200
    27.875    20.011     0.200
    28.044    18.642     0.200
    28.741    15.100     0.200
    29.119    15.068     0.200
    29.119    15.299     0.200
    29.523    15.681     0.200
    21.391    30.639     0.200
    25.790    23.270     0.200
    26.233    22.874     0.200
    26.233    22.600     0.200
    17.951    33.785     0.200
    17.951    33.293     0.200
    17.951    34.316     0.200
    19.594    34.080     0.200
    19.719    32.978     0.200
    20.370    31.382     0.200
    20.328    31.857     0.200
    20.721    32.994     0.200
    20.921    30.654     0.200
    21.309    30.342     0.200
    21.309    29.920     0.200
    21.309    29.779     0.200
    21.309    29.521     0.200
    21.390    30.429     0.200
    21.745    30.540     0.200
    22.141    33.520     0.200
    22.239    28.569     0.200
    22.782    32.943     0.200
    23.522    28.298     0.200
    23.997    25.466     0.200
    24.311    29.200     0.200
    24.789    26.315     0.200
    24.793    25.616     0.200
    24.793    27.975     0.200
    25.067    23.777     0.200
    25.091    24.794     0.200
    25.091    26.700     0.200
    25.767    24.903     0.200
    25.845    23.808     0.200
    25.845    23.589     0.200
    25.845    23.691     0.200
    26.012    24.453     0.200
    26.119    24.400     0.200
    26.289    23.131     0.200
    26.289    22.701     0.200
    27.049    20.219     0.200
    27.049    22.039     0.200
    27.812    17.942     0.200
    27.912    17.570     0.200
    28.154    18.141     0.200
    28.154    17.313     0.200
    28.154    18.352     0.200
    28.154    18.454     0.200
    28.162    18.148     0.200
    28.328    16.518     0.200
    28.699    16.189     0.200
    28.699    16.291     0.200
    28.649    16.977     0.200
    28.699    14.541     0.200
    28.721    15.029     0.200
    29.397    13.672     0.200
    29.802    13.416     0.200
    17.848    38.409     0.200
    17.848    38.089     0.200
    19.469    35.958     0.200
    19.469    37.509     0.200
    19.906    34.306     0.200
    20.542    34.278     0.200
    20.992    35.876     0.200
    20.992    34.852     0.200
    20.992    36.333     0.200
    21.278    35.265     0.200
    23.466    32.368     0.200
    25.151    29.342     0.200
    25.383    29.218     0.200
    25.827    27.208     0.200
    25.827    27.681     0.200
    29.041    19.896     0.200
    29.351    16.240     0.200
    29.986    15.178     0.200
    25.840    24.412     0.200
    26.283    22.833     0.200
    26.283    22.085     0.200
    27.020    20.344     0.200
    17.974    34.135     0.200
    17.974    33.117     0.200
    17.974    33.756     0.200
    17.974    34.316     0.200
    19.550    33.420     0.200
    20.319    31.252     0.200
    20.277    31.962     0.200
    20.868    30.342     0.200
    21.305    30.113     0.200
    21.305    30.238     0.200
    21.412    30.366     0.200
    21.412    29.889     0.200
    21.692    34.224     0.200
    22.106    32.695     0.200
    22.187    28.553     0.200
    24.264    29.442     0.200
    24.744    27.746     0.200
    25.042    26.116     0.200
    25.042    25.827     0.200
    25.714    25.592     0.200
    25.803    23.842     0.200
    25.803    23.422     0.200
    26.233    22.529     0.200
    26.240    22.749     0.200
    26.247    22.974     0.200
    26.247    22.704     0.200
    26.527    21.438     0.200
    27.776    16.731     0.200
    27.859    18.554     0.200
    28.117    18.042     0.200
    28.117    17.583     0.200
    28.289    17.744     0.200
    28.726    13.342     0.200
    28.726    14.723     0.200
    15.548    36.089     0.200
    17.916    32.549     0.200
    19.651    34.956     0.200
    19.651    34.307     0.200
    21.305    29.578     0.200
    21.305    29.820     0.200
    21.305    29.301     0.200
    21.305    31.000     0.200
    21.356    30.108     0.200
    21.356    30.909     0.200
    25.607    22.526     0.200
    25.830    24.500     0.200
    25.889    23.969     0.200
    25.889    24.406     0.200
    25.889    24.508     0.200
    26.319    23.485     0.200
    26.333    22.229     0.200
    26.333    21.861     0.200
    28.659    15.778     0.200
    21.414    29.888     0.200
    25.587    22.421     0.200
    26.269    22.203     0.200
    18.096    32.998     0.200
    18.096    33.623     0.200
    18.096    33.271     0.200
    18.096    33.404     0.200
    18.953    33.497     0.200
    19.457    32.416     0.200
    20.323    31.718     0.200
    20.280    31.319     0.200
    20.280    31.725     0.200
    20.848    31.591     0.200
    21.423    28.890     0.200
    21.423    28.452     0.200
    21.535    28.671     0.200
    21.535    29.773     0.200
    21.647    30.562     0.200
    23.485    28.913     0.200
    24.180    26.457     0.200
    24.666    25.121     0.200
    24.753    23.617     0.200
    24.964    25.007     0.200
    25.214    22.475     0.200
    25.667    22.579     0.200
    25.673    23.879     0.200
    25.853    23.952     0.200
    25.853    23.679     0.200
    25.884    21.722     0.200
    25.990    21.943     0.200
    26.290    22.679     0.200
    26.296    23.065     0.200
    26.296    22.753     0.200
    26.447    21.858     0.200
    27.844    18.147     0.200
    27.844    19.242     0.200
    28.183    18.063     0.200
    28.183    17.391     0.200
    28.349    17.545     0.200
    28.551    18.181     0.200
    28.845    14.760     0.200
    28.819    15.583     0.200
    28.845    12.869     0.200
    28.845    14.416     0.200
    29.313    11.983     0.200
    29.313    13.327     0.200
    29.313    12.803     0.200
    29.830    13.468     0.200
    15.499    36.429     0.200
    21.291    30.847     0.200
    21.396    30.659     0.200
    25.558    22.154     0.200
    25.801    24.105     0.200
    26.244    21.666     0.200
    28.709    17.063     0.200
    28.656    14.241     0.200
    28.656    13.483     0.200
    17.935    34.335     0.200
    17.935    33.335     0.200
    17.935    33.139     0.200
    17.935    33.557     0.200
    17.935    33.968     0.200
    19.104    34.320     0.200
    20.352    31.350     0.200
    20.311    31.797     0.200
    20.311    32.340     0.200
    20.715    33.227     0.200
    20.908    30.773     0.200
    21.285    29.481     0.200
    21.285    29.262     0.200
    21.285    28.758     0.200
    21.374    30.183     0.200
    21.736    32.000     0.200
    22.115    31.976     0.200
    22.224    30.512     0.200
    22.784    32.864     0.200
    23.259    29.931     0.200
    23.259    32.564     0.200
    23.503    29.982     0.200
    24.312    26.737     0.200
    24.312    27.847     0.200
    24.770    26.302     0.200
    24.792    27.562     0.200
    25.053    27.695     0.200
    25.090    25.204     0.200
    25.090    27.071     0.200
    25.090    24.864     0.200
    25.564    22.313     0.200
    25.757    23.180     0.200
    25.821    24.648     0.200
    25.821    24.167     0.200
    25.821    23.871     0.200
    25.821    22.867     0.200
    25.821    24.328     0.200
    26.011    23.602     0.200
    26.011    24.770     0.200
    26.011    23.453     0.200
    26.011    22.414     0.200
    26.119    23.820     0.200
    26.119    24.601     0.200
    26.119    22.159     0.200
    26.265    22.650     0.200
    26.564    25.859     0.200
    26.575    22.746     0.200
    26.575    23.074     0.200
    26.575    21.637     0.200
    27.047    21.730     0.200
    27.047    22.402     0.200
    27.047    20.609     0.200
    27.380    19.349     0.200
    27.787    18.094     0.200
    27.898    18.997     0.200
    27.883    17.749     0.200
    28.129    18.326     0.200
    28.129    18.006     0.200
    28.129    16.947     0.200
    28.129    17.545     0.200
    28.129    18.619     0.200
    28.154    18.209     0.200
    28.303    17.971     0.200
    28.684    12.618     0.200
    28.684    12.720     0.200
    28.684    12.899     0.200
    28.724    15.190     0.200
    29.385    14.635     0.200
    29.385    13.038     0.200
    29.777    13.569     0.200
    18.078    33.950     0.200
    20.221    32.169     0.200
    20.795    31.568     0.200
    21.376    30.346     0.200
    21.376    31.194     0.200
    21.515    28.388     0.200
    21.515    30.466     0.200
    24.640    27.500     0.200
    25.607    22.343     0.200
    25.788    24.079     0.200
    25.788    23.399     0.200
    25.788    24.610     0.200
    25.966    24.238     0.200
    26.231    22.434     0.200
    26.231    22.231     0.200
    26.423    22.688     0.200
    28.117    18.823     0.200
    29.264    15.425     0.200
    17.812    34.595     0.200
    17.812    33.279     0.200
    17.812    32.595     0.200
    19.641    32.185     0.200
    19.678    32.791     0.200
    19.678    33.836     0.200
    20.320    30.766     0.200
    20.278    30.778     0.200
    20.278    32.147     0.200
    20.748    33.466     0.200
    20.901    29.282     0.200
    21.151    28.941     0.200
    21.151    29.671     0.200
    21.250    29.965     0.200
    21.250    30.215     0.200
    21.758    30.486     0.200
    22.205    27.863     0.200
    23.200    28.052     0.200
    23.771    25.988     0.200
    23.773    25.846     0.200
    24.726    26.945     0.200
    25.045    23.321     0.200
    25.150    24.905     0.200
    25.150    21.883     0.200
    25.150    24.395     0.200
    25.442    21.968     0.200
    25.742    23.849     0.200
    25.742    22.058     0.200
    25.742    22.888     0.200
    25.742    24.220     0.200
    26.073    24.188     0.200
    26.073    22.249     0.200
    26.172    22.665     0.200
    26.179    22.585     0.200
    26.186    22.571     0.200
    26.186    21.411     0.200
    26.637    21.406     0.200
    26.637    19.535     0.200
    27.098    23.080     0.200
    27.098    19.420     0.200
    27.690    16.256     0.200
    27.885    17.479     0.200
    28.034    16.309     0.200
    28.034    16.940     0.200
    28.034    17.430     0.200
    28.175    17.692     0.200
    28.567    16.525     0.200
    29.390    13.017     0.200
    29.683    12.802     0.200
    19.975    33.895     0.200
    21.116    34.333     0.200
    21.116    34.552     0.200
    21.116    32.923     0.200
    21.371    34.136     0.200
    21.371    35.710     0.200
    21.451    35.772     0.200
    23.512    30.535     0.200
    25.306    26.864     0.200
    25.489    27.754     0.200
    25.932    26.433     0.200
    28.719    16.964     0.200
    17.922    33.717     0.200
    17.922    34.576     0.200
    17.922    34.225     0.200
    17.922    34.678     0.200
    19.635    33.144     0.200
    19.635    32.589     0.200
    19.635    33.761     0.200
    20.406    31.388     0.200
    20.364    30.901     0.200
    20.364    32.057     0.200
    20.961    30.514     0.200
    21.300    29.396     0.200
    21.300    28.771     0.200
    21.362    30.183     0.200
    21.362    30.034     0.200
    21.787    29.973     0.200
    22.277    28.252     0.200
    23.216    29.265     0.200
    24.835    26.084     0.200
    25.106    23.536     0.200
    25.595    22.080     0.200
    25.763    23.541     0.200
    25.808    23.239     0.200
    25.870    23.695     0.200
    25.870    23.336     0.200
    25.870    24.523     0.200
    26.161    22.441     0.200
    26.300    22.602     0.200
    26.307    22.522     0.200
    26.313    22.611     0.200
    26.313    21.955     0.200
    26.617    22.634     0.200
    26.617    21.525     0.200
    27.092    23.387     0.200
    27.092    20.777     0.200
    27.335    20.674     0.200
    27.830    18.143     0.200
    27.838    18.052     0.200
    27.951    18.235     0.200
    28.173    18.028     0.200
    28.173    17.918     0.200
    28.173    17.449     0.200
    28.173    17.746     0.200
    28.388    16.340     0.200
    28.667    16.083     0.200
    28.667    15.403     0.200
    28.679    16.923     0.200
    28.679    15.814     0.200
    29.438    13.049     0.200
    29.438    13.151     0.200
    29.721    12.490     0.200
    29.821    13.613     0.200
    17.085    37.253     0.200
    17.555    37.900     0.200
    17.555    38.281     0.200
    17.555    39.300     0.200
    20.702    33.038     0.200
    20.702    35.479     0.200
    20.702    35.870     0.200
    20.983    32.918     0.200
    24.936    26.389     0.200
    24.936    27.363     0.200
    25.082    29.039     0.200
    25.702    26.640     0.200
    17.093    38.662     0.200
    17.675    38.816     0.200
    21.102    35.575     0.200
    24.989    28.644     0.200
    25.621    23.254     0.200
    26.322    22.758     0.200
    18.210    33.974     0.200
    19.863    32.865     0.200
    21.085    30.734     0.200
    21.084    29.624     0.200
    21.394    31.904     0.200
    21.394    28.632     0.200
    21.394    27.944     0.200
    23.017    31.159     0.200
    25.924    20.233     0.200
    26.473    20.795     0.200
    26.473    21.526     0.200
    26.917    19.675     0.200
    28.908    15.513     0.200
    21.390    31.085     0.200
    25.367    23.897     0.200
    26.000    23.783     0.200
    20.371    31.558     0.200
    21.294    30.265     0.200
    21.294    30.085     0.200
    21.294    29.921     0.200
    21.352    29.895     0.200
    21.352    30.692     0.200
    25.592    22.633     0.200
    25.873    24.095     0.200
    25.873    24.431     0.200
    26.317    22.417     0.200
    26.317    22.902     0.200
    28.351    17.819     0.200
    29.447    13.478     0.200
    29.823    13.735     0.200
    25.592    22.406     0.200
    17.965    35.354     0.200
    17.965    33.969     0.200
    17.965    33.602     0.200
    19.476    32.998     0.200
    19.595    33.668     0.200
    19.595    33.369     0.200
    19.595    35.225     0.200
    19.745    32.755     0.200
    20.393    31.394     0.200
    20.351    33.075     0.200
    20.732    33.936     0.200
    20.940    30.509     0.200
    21.334    29.810     0.200
    21.334    31.449     0.200
    21.334    30.931     0.200
    21.405    29.789     0.200
    21.405    30.065     0.200
    21.759    30.453     0.200
    22.260    28.605     0.200
    22.459    29.582     0.200
    23.547    27.092     0.200
    24.315    30.427     0.200
    24.315    28.406     0.200
    24.799    27.048     0.200
    24.799    26.933     0.200
    24.799    26.513     0.200
    24.813    25.111     0.200
    25.096    25.707     0.200
    25.086    23.930     0.200
    25.348    24.566     0.200
    25.619    23.135     0.200
    25.782    22.507     0.200
    25.873    23.841     0.200
    25.873    23.440     0.200
    25.873    23.558     0.200
    25.873    23.729     0.200
    26.123    23.221     0.200
    26.123    23.582     0.200
    26.317    23.212     0.200
    26.317    22.724     0.200
    26.575    23.750     0.200
    27.057    23.708     0.200
    27.057    23.426     0.200
    27.841    18.378     0.200
    27.932    19.715     0.200
    28.177    18.363     0.200
    28.183    17.791     0.200
    28.183    17.961     0.200
    28.183    17.164     0.200
    28.356    17.562     0.200
    28.710    12.638     0.200
    28.710    15.699     0.200
    29.414    13.750     0.200
    29.831    13.558     0.200
    17.954    33.772     0.200
    17.954    34.249     0.200
    17.954    34.069     0.200
    19.435    33.681     0.200
    19.583    35.897     0.200
    19.583    33.924     0.200
    19.583    33.776     0.200
    20.353    31.464     0.200
    20.311    31.654     0.200
    20.905    31.331     0.200
    21.304    30.068     0.200
    21.304    29.228     0.200
    21.304    30.486     0.200
    21.393    30.026     0.200
    21.393    30.252     0.200
    22.314    28.278     0.200
    22.416    29.695     0.200
    25.330    27.373     0.200
    25.330    25.572     0.200
    25.580    22.976     0.200
    25.830    23.854     0.200
    25.830    24.464     0.200
    26.106    26.322     0.200
    26.106    25.353     0.200
    26.274    23.146     0.200
    26.562    22.347     0.200
    26.562    22.667     0.200
    28.140    17.999     0.200
    28.140    17.510     0.200
    28.140    18.319     0.200
    28.313    17.575     0.200
    28.703    15.319     0.200
    29.381    14.057     0.200
    29.788    13.566     0.200
    20.938    36.612     0.200
    20.938    36.839     0.200
    20.941    37.028     0.200
    25.332    30.443     0.200
    25.834    30.694     0.200
    26.241    29.061     0.200
    26.241    28.858     0.200
    29.846    18.054     0.200
    25.332    30.099     0.200
    15.546    36.336     0.200
    17.931    34.813     0.200
    17.931    34.592     0.200
    17.931    34.323     0.200
    19.467    33.782     0.200
    19.630    35.117     0.200
    19.630    33.774     0.200
    19.630    34.229     0.200
    20.368    31.605     0.200
    20.368    31.934     0.200
    21.311    30.759     0.200
    21.311    30.171     0.200
    21.311    29.759     0.200
    21.311    30.028     0.200
    21.371    30.058     0.200
    21.371    30.820     0.200
    23.737    26.942     0.200
    24.349    28.309     0.200
    24.349    25.913     0.200
    24.832    27.798     0.200
    24.832    25.528     0.200
    25.606    23.172     0.200
    25.878    24.270     0.200
    25.878    23.847     0.200
    25.878    24.371     0.200
    26.157    23.452     0.200
    26.321    23.023     0.200
    26.321    22.884     0.200
    26.614    25.045     0.200
    26.614    24.360     0.200
    28.182    18.079     0.200
    28.182    18.325     0.200
    28.357    17.832     0.200
    28.390    16.689     0.200
    28.676    16.918     0.200
    28.650    14.707     0.200
    28.676    16.698     0.200
    29.830    13.845     0.200
    25.606    22.583     0.200
    21.604    38.138     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     0.147     7.801     0.200
     0.147     6.903     0.200
     0.147     7.903     0.200
     0.287     7.065     0.200
     0.287     6.269     0.200
     0.287     7.269     0.200
     0.719     6.128     0.200
     0.719     6.230     0.200
     1.247     7.064     0.200
     1.192     7.110     0.200
     1.192     6.712     0.200
     1.600     5.747     0.200
     1.600     5.950     0.200
     1.623     6.878     0.200
     1.623     7.675     0.200
     1.623     6.675     0.200
     1.671     7.413     0.200
     1.671     7.116     0.200
     1.834     7.923     0.200
     1.834     7.220     0.200
     1.834     8.220     0.200
     1.930     8.396     0.200
     1.930     8.099     0.200
     1.989     9.405     0.200
     2.079     9.054     0.200
     2.079     9.351     0.200
     2.112     8.673     0.200
     2.112     7.970     0.200
     2.112     9.869     0.200
     2.112     8.970     0.200
     2.240     7.473     0.200
     2.261     9.033     0.200
     2.261     8.237     0.200
     2.261     9.237     0.200
     2.710    11.091     0.200
     2.710    11.786     0.200
     2.710    10.989     0.200
     2.924    11.595     0.200
     2.924    11.493     0.200
     2.924    11.790     0.200
     3.384    12.826     0.200
     3.390    13.058     0.200
     3.430    13.585     0.200
     4.032    14.169     0.200
     4.032    14.567     0.200
     4.301    14.123     0.200
     4.301    14.420     0.200
     4.494    14.775     0.200
     4.494    14.877     0.200
     4.494    15.174     0.200
     4.760    14.065     0.200
     5.626    16.263     0.200
     6.178    17.116     0.200
     6.178    17.514     0.200
     6.196    17.107     0.200
     6.196    17.311     0.200
     6.392    19.228     0.200
     6.392    19.024     0.200
     6.435    15.523     0.200
     6.606    19.926     0.200
     6.606    19.528     0.200
     6.721    21.283     0.200
     6.721    21.181     0.200
     6.715    19.049     0.200
     6.715    19.252     0.200
     6.831    18.901     0.200
     6.831    19.901     0.200
     7.025    21.031     0.200
     7.025    20.632     0.200
     7.288    20.966     0.200
     7.288    21.865     0.200
     7.288    20.568     0.200
     7.725    22.068     0.200
     7.725    22.670     0.200
     7.725    22.466     0.200
     7.814    22.025     0.200
     7.814    22.424     0.200
     8.168    22.003     0.200
     8.168    22.300     0.200
     8.429    22.247     0.200
     8.775    25.609     0.200
     8.775    25.211     0.200
     9.234    24.957     0.200
     9.234    24.855     0.200
     9.434    23.520     0.200
     9.446    26.388     0.200
    10.564    26.042     0.200
    10.564    26.339     0.200
    12.780    31.574     0.200
    12.780    31.473     0.200
    13.178    29.828     0.200
     0.469     6.999     0.200
     0.469     7.198     0.200
     0.836     5.711     0.200
     0.836     5.512     0.200
     0.764     7.561     0.200
     0.764     7.361     0.200
     0.764     6.561     0.200
     0.878     7.223     0.200
     0.878     7.624     0.200
     1.748     9.076     0.200
     1.595     8.860     0.200
     1.595     8.660     0.200
     1.595     7.860     0.200
     1.788     8.611     0.200
     1.884     6.489     0.200
     2.082     7.179     0.200
     2.082     7.378     0.200
     2.204     7.754     0.200
     2.424     9.183     0.200
     2.424     9.382     0.200
     2.518     9.885     0.200
     2.518     9.084     0.200
     2.532     8.919     0.200
     2.532     9.419     0.200
     2.790    10.917     0.200
     2.793    11.875     0.200
     2.793    11.574     0.200
     2.793    10.875     0.200
     3.034    10.070     0.200
     3.034    10.370     0.200
     3.533    13.042     0.200
     3.533    12.241     0.200
     3.540    13.166     0.200
     3.335    11.556     0.200
     3.335    11.857     0.200
     3.805    14.074     0.200
     3.880    15.195     0.200
     4.353    12.676     0.200
     4.353    12.977     0.200
     4.598    15.819     0.200
     4.598    16.319     0.200
     4.647    14.241     0.200
     4.647    13.840     0.200
     4.647    13.241     0.200
     4.878    15.545     0.200
     4.878    15.345     0.200
     4.878    14.545     0.200
     5.250    15.209     0.200
     5.761    18.247     0.200
     5.761    18.047     0.200
     5.761    17.247     0.200
     5.826    15.481     0.200
     5.897    16.655     0.200
     6.484    16.807     0.200
     6.484    17.307     0.200
     6.541    18.138     0.200
     6.541    17.138     0.200
     6.922    17.687     0.200
     6.709    17.175     0.200
     6.709    16.875     0.200
     6.786    19.275     0.200
     6.786    18.275     0.200
     6.756    15.626     0.200
     6.987    18.932     0.200
     6.981    19.003     0.200
     6.981    19.403     0.200
     7.079    18.859     0.200
     7.302    21.260     0.200
     7.254    19.820     0.200
     7.254    19.420     0.200
     7.261    21.734     0.200
     7.261    21.334     0.200
     7.261    20.734     0.200
     7.333    19.897     0.200
     7.333    19.596     0.200
     7.333    18.897     0.200
     7.326    22.975     0.200
     7.351    18.686     0.200
     7.351    17.686     0.200
     7.629    21.447     0.200
     7.629    21.646     0.200
     7.607    22.704     0.200
     7.612    21.639     0.200
     7.829    25.102     0.200
     7.829    24.802     0.200
     7.829    24.102     0.200
     7.889    25.405     0.200
     8.046    23.576     0.200
     8.028    23.783     0.200
     8.028    23.584     0.200
     8.028    22.783     0.200
     8.164    22.193     0.200
     8.164    22.593     0.200
     8.164    20.197     0.200
     8.164    20.597     0.200
     8.272    23.935     0.200
     8.320    20.382     0.200
     8.489    22.409     0.200
     8.489    22.810     0.200
     8.921    21.366     0.200
     8.868    23.984     0.200
     8.868    23.584     0.200
     8.868    22.984     0.200
     8.889    27.738     0.200
     8.958    22.938     0.200
     8.958    23.137     0.200
     9.029    26.099     0.200
     9.029    26.499     0.200
     9.000    26.437     0.200
     9.226    28.810     0.200
     9.226    27.810     0.200
     9.448    29.209     0.200
     9.527    28.288     0.200
     9.581    27.559     0.200
     9.892    26.029     0.200
     9.893    28.023     0.200
     9.893    28.523     0.200
    10.043    28.176     0.200
    10.043    27.276     0.200
    10.163    26.069     0.200
    10.226    29.134     0.200
    10.596    30.817     0.200
    10.645    28.240     0.200
    10.876    26.547     0.200
    11.028    30.781     0.200
    11.116    26.745     0.200
    11.261    28.053     0.200
    11.261    27.854     0.200
    11.859    31.074     0.200
    11.859    31.375     0.200
    11.871    31.935     0.200
    11.974    28.740     0.200
    11.974    28.439     0.200
    11.974    27.740     0.200
    12.003    30.394     0.200
    12.003    30.794     0.200
    12.179    29.341     0.200
    12.179    29.741     0.200
    12.137    29.837     0.200
    12.137    30.138     0.200
    12.881    31.154     0.200
    13.282    32.468     0.200
    13.729    27.250     0.200
    13.778    33.678     0.200
    13.857    32.757     0.200
    13.857    33.058     0.200
    14.055    33.450     0.200
    14.055    33.851     0.200
    14.054    33.466     0.200
    14.054    33.267     0.200
    14.368    34.793     0.200
    14.431    35.064     0.200
    14.431    35.365     0.200
    14.673    31.743     0.200
    15.133    36.870     0.200
    16.004    35.711     0.200
    11.116    27.245     0.200
     0.123     7.525     0.200
     0.339     6.897     0.200
     1.162     6.994     0.200
     1.654     6.750     0.200
     1.706     7.752     0.200
     1.679     6.964     0.200
     1.884     8.472     0.200
     1.983     9.820     0.200
     2.112     7.310     0.200
     2.076     8.433     0.200
     2.100    10.551     0.200
     2.295    10.377     0.200
     2.939    11.653     0.200
     3.422    12.716     0.200
     3.328    10.822     0.200
     3.422    11.721     0.200
     3.441    15.495     0.200
     4.037    12.548     0.200
     4.171    15.986     0.200
     4.310    15.364     0.200
     4.507    14.060     0.200
     4.780    12.874     0.200
     4.906    16.407     0.200
     5.561    16.765     0.200
     5.652    17.099     0.200
     6.183    16.504     0.200
     6.205    17.246     0.200
     6.398    17.997     0.200
     6.619    18.410     0.200
     6.732    20.097     0.200
     6.942    20.647     0.200
     6.850    19.719     0.200
     6.877    23.397     0.200
     7.032    21.592     0.200
     7.203    21.595     0.200
     7.462    21.578     0.200
     7.533    24.741     0.200
     7.832    19.259     0.200
     7.884    23.655     0.200
     8.414    22.467     0.200
     8.551    24.865     0.200
     9.258    25.615     0.200
     9.332    25.755     0.200
     9.458    24.778     0.200
     0.178     7.510     0.200
     1.626     6.207     0.200
     1.629     6.675     0.200
     1.715     7.674     0.200
     1.826     7.768     0.200
     2.030     9.089     0.200
     2.044    10.132     0.200
     2.136     8.055     0.200
     2.235     9.907     0.200
     2.886    11.303     0.200
     3.434    11.911     0.200
     3.282    11.687     0.200
     3.390    14.417     0.200
     3.990    12.424     0.200
     4.455    13.995     0.200
     4.591    14.405     0.200
     4.806    13.897     0.200
     4.856    16.317     0.200
     5.511    16.669     0.200
     5.594    16.705     0.200
     6.136    17.374     0.200
     6.350    15.878     0.200
     6.681    17.015     0.200
     6.702    20.771     0.200
     6.795    19.489     0.200
     6.824    23.351     0.200
     6.965    17.698     0.200
     7.683    20.325     0.200
     7.782    19.164     0.200
     7.830    23.613     0.200
     8.081    20.683     0.200
     8.367    21.342     0.200
     8.741    25.973     0.200
     9.273    25.770     0.200
     9.401    24.174     0.200
     0.349     6.641     0.200
     0.739     5.202     0.200
     1.157     6.511     0.200
     1.665     5.885     0.200
     1.713     7.419     0.200
     1.690     6.798     0.200
     1.893     8.020     0.200
     1.982     7.982     0.200
     2.121     7.361     0.200
     2.069     7.969     0.200
     2.103    10.575     0.200
     2.301     9.266     0.200
     2.942    10.788     0.200
     3.430    11.091     0.200
     3.328    11.284     0.200
     3.443    13.941     0.200
     4.785    14.277     0.200
     6.853    19.147     0.200
     8.425    22.798     0.200
     0.129     7.593     0.200
     0.309     7.187     0.200
     0.716     5.942     0.200
     1.173     7.103     0.200
     1.617     6.718     0.200
     1.645     7.096     0.200
     1.677     7.225     0.200
     1.856     8.538     0.200
     1.978    10.108     0.200
     2.079     8.328     0.200
     2.092     7.779     0.200
     2.094    10.652     0.200
     2.261     6.806     0.200
     2.280    11.092     0.200
     2.938    11.516     0.200
     3.143    10.310     0.200
     3.395    11.575     0.200
     3.334    11.293     0.200
     3.412    14.372     0.200
     3.442    13.023     0.200
     4.164    15.596     0.200
     4.312    13.869     0.200
     4.543    15.075     0.200
     4.646    15.681     0.200
     4.760    14.547     0.200
     4.908    15.922     0.200
     5.563    17.274     0.200
     6.188    16.878     0.200
     6.402    16.483     0.200
     6.920    19.437     0.200
     6.846    19.605     0.200
     7.693    19.515     0.200
     8.379    22.412     0.200
     9.205    23.877     0.200
    10.187    25.110     0.200
    11.253    28.273     0.200
    11.355    29.387     0.200
    13.291    32.490     0.200
     0.233     7.475     0.200
     0.197     6.695     0.200
     0.733     6.438     0.200
     1.560     5.883     0.200
     1.571     5.762     0.200
     1.662     7.491     0.200
     1.779     7.927     0.200
     2.049     6.779     0.200
     2.020    10.518     0.200
     2.040    10.281     0.200
     2.192     7.514     0.200
     2.162     8.358     0.200
     2.212    10.073     0.200
     2.739    10.622     0.200
     2.888    11.384     0.200
     3.213    10.093     0.200
     3.398    16.439     0.200
     4.606    15.335     0.200
     4.709    16.330     0.200
     4.767    15.462     0.200
     6.792    19.826     0.200
     6.924    19.792     0.200
     8.306    22.156     0.200
     9.268    23.931     0.200
     9.392    24.388     0.200
    10.123    25.658     0.200
    11.187    28.836     0.200
     0.110     8.767     0.200
     0.374     6.678     0.200
     0.525     7.320     0.200
     0.970     7.426     0.200
     1.687     6.455     0.200
     1.754     5.573     0.200
     1.829     7.697     0.200
     2.072     8.172     0.200
     2.285     9.379     0.200
     2.475    10.762     0.200
     2.929    10.167     0.200
     3.612    14.899     0.200
     4.340    15.396     0.200
     4.696    13.243     0.200
     6.601    16.414     0.200
     7.032    19.987     0.200
     7.101    18.876     0.200
     7.486    20.689     0.200
     7.536    19.203     0.200
    10.373    24.889     0.200
     0.178     7.982     0.200
     0.337     6.427     0.200
     0.599     5.970     0.200
     0.964     6.205     0.200
     1.197     4.688     0.200
     1.332     5.211     0.200
     1.374     6.628     0.200
     1.690     6.633     0.200
     1.618     7.480     0.200
     1.859     6.963     0.200
     1.743     7.314     0.200
     1.843     8.950     0.200
     2.304     7.767     0.200
     2.479    10.729     0.200
     2.553     7.862     0.200
     2.610    10.196     0.200
     3.088    10.623     0.200
     3.790    15.423     0.200
     3.781    12.537     0.200
     4.027    13.659     0.200
     4.186    13.804     0.200
     4.870    13.820     0.200
     5.925    16.510     0.200
     6.128    15.144     0.200
     6.168    15.682     0.200
     6.406    19.902     0.200
     6.424    19.688     0.200
     6.483    19.203     0.200
     6.529    19.463     0.200
     6.619    17.613     0.200
     6.786    20.467     0.200
     6.957    19.368     0.200
     7.131    21.442     0.200
     7.131    18.435     0.200
     7.183    21.834     0.200
     7.941    20.990     0.200
     8.178    22.221     0.200
     9.793    24.273     0.200
     9.796    22.342     0.200
    10.819    27.205     0.200
    12.692    29.548     0.200
    12.808    26.189     0.200
    15.378    35.193     0.200
     0.471     4.689     0.200
     0.791     4.659     0.200
     1.271     3.862     0.200
     1.299     5.627     0.200
     1.498     5.305     0.200
     1.916     7.131     0.200
     2.782    10.823     0.200
     2.939    11.291     0.200
     3.448    11.651     0.200
     4.723    15.675     0.200
     4.908    16.508     0.200
     6.336    15.946     0.200
     6.656    20.110     0.200
     6.791    18.640     0.200
     0.511     5.145     0.200
     1.225     4.712     0.200
     1.232     6.021     0.200
     1.472     6.224     0.200
     1.944     7.519     0.200
     2.111    10.073     0.200
     2.684    11.386     0.200
     2.812    10.383     0.200
     2.940    12.389     0.200
     3.293    12.577     0.200
     3.460    11.325     0.200
     3.986    13.490     0.200
     4.232    14.320     0.200
     4.908    17.226     0.200
     6.372    16.142     0.200
     6.678    20.276     0.200
     6.821    18.903     0.200
     7.160    19.947     0.200
     7.955    21.871     0.200
     9.242    25.452     0.200
    10.988    29.078     0.200
     0.146     7.138     0.200
     0.150     6.994     0.200
     0.287     7.195     0.200
     0.718     5.768     0.200
     1.191     6.847     0.200
     1.599     7.083     0.200
     1.623     7.004     0.200
     1.670     7.653     0.200
     1.834     8.246     0.200
     1.988     9.943     0.200
     2.068     8.710     0.200
     2.111     9.505     0.200
     2.080     9.171     0.200
     2.240     8.704     0.200
     2.261     8.959     0.200
     2.693    10.614     0.200
     2.711    10.509     0.200
     2.925    11.414     0.200
     3.163    10.339     0.200
     3.325    11.345     0.200
     3.389    13.595     0.200
     3.431    15.105     0.200
     4.032    12.087     0.200
     4.150    15.920     0.200
     4.302    13.539     0.200
     4.495    14.794     0.200
     4.560    15.929     0.200
     4.663    15.828     0.200
     4.759    14.803     0.200
     4.897    15.298     0.200
     5.553    16.446     0.200
     6.179    16.634     0.200
     6.197    17.130     0.200
     6.393    17.544     0.200
     6.716    18.972     0.200
     6.722    22.701     0.200
     6.739    21.007     0.200
     6.832    19.221     0.200
     6.919    19.903     0.200
     7.166    20.719     0.200
     7.449    23.218     0.200
     7.711    19.157     0.200
     8.357    22.617     0.200
     9.435    24.441     0.200
    10.165    24.623     0.200
    11.235    27.834     0.200
     0.198     4.477     0.200
     0.124     5.739     0.200
     0.124     5.137     0.200
     0.356     4.926     0.200
     0.562     3.831     0.200
     1.086     5.912     0.200
     1.530     5.725     0.200
     1.630     6.463     0.200
     1.630     5.564     0.200
     1.945     8.287     0.200
     1.945     7.888     0.200
     1.842     7.289     0.200
     1.842     7.090     0.200
     1.882     7.124     0.200
     1.882     6.624     0.200
     2.213     8.558     0.200
     2.213     7.757     0.200
     2.021     7.004     0.200
     2.213     9.257     0.200
     2.213     8.757     0.200
     2.367     8.362     0.200
     2.367     7.963     0.200
     2.862    10.190     0.200
     3.240    12.480     0.200
     3.240    11.781     0.200
     3.245    12.414     0.200
     3.064    11.327     0.200
     3.064    10.827     0.200
     3.518    14.138     0.200
     3.518    13.536     0.200
     3.476    12.225     0.200
     3.476    12.026     0.200
     3.575    14.863     0.200
     4.182    12.980     0.200
     4.182    12.781     0.200
     4.280    15.144     0.200
     4.280    14.644     0.200
     4.446    13.698     0.200
     4.605    13.649     0.200
     4.605    12.849     0.200
     4.449    13.865     0.200
     4.449    13.666     0.200
     4.636    14.680     0.200
     4.636    14.481     0.200
     5.043    15.540     0.200
     5.043    14.739     0.200
     5.453    18.646     0.200
     5.453    17.946     0.200
     5.748    17.510     0.200
     5.699    16.280     0.200
     5.684    15.658     0.200
     5.684    15.259     0.200
     6.343    17.368     0.200
     6.329    17.122     0.200
     6.329    16.723     0.200
     6.476    19.506     0.200
     6.541    16.247     0.200
     6.584    16.051     0.200
     6.747    20.344     0.200
     6.871    21.198     0.200
     6.871    20.398     0.200
     6.924    21.787     0.200
     6.866    20.459     0.200
     6.869    18.128     0.200
     6.965    19.701     0.200
     6.999    19.903     0.200
     7.065    17.840     0.200
     7.109    19.826     0.200
     7.109    19.627     0.200
     7.174    18.867     0.200
     7.290    21.510     0.200
     7.319    22.178     0.200
     7.394    19.200     0.200
     7.437    20.603     0.200
     7.531    19.498     0.200
     7.693    22.309     0.200
     7.693    21.809     0.200
     7.665    21.939     0.200
     7.712    23.986     0.200
     7.805    19.197     0.200
     7.805    18.498     0.200
     7.970    19.279     0.200
     7.970    18.580     0.200
     8.004    21.980     0.200
     8.343    22.224     0.200
     8.147    19.906     0.200
     8.147    19.507     0.200
     8.263    20.357     0.200
     8.457    23.395     0.200
     8.457    22.895     0.200
     8.560    23.393     0.200
     8.560    22.694     0.200
     8.665    23.072     0.200
     8.688    24.196     0.200
     8.665    26.363     0.200
     8.665    25.465     0.200
     8.903    25.293     0.200
     9.170    24.570     0.200
     9.223    23.956     0.200
     9.360    25.858     0.200
     9.360    25.358     0.200
     9.419    25.771     0.200
     9.419    25.669     0.200
     9.560    24.723     0.200
     9.574    25.463     0.200
     9.622    22.297     0.200
     9.720    25.755     0.200
     9.720    25.153     0.200
     9.732    25.617     0.200
     9.774    26.829     0.200
     9.795    27.383     0.200
     9.795    27.281     0.200
     9.891    26.360     0.200
     9.891    26.161     0.200
     9.932    25.183     0.200
     9.932    24.683     0.200
    10.269    26.748     0.200
    10.292    25.477     0.200
    10.461    29.113     0.200
    10.549    26.873     0.200
    10.549    26.474     0.200
    10.646    28.351     0.200
    10.687    28.466     0.200
    10.755    26.970     0.200
    11.200    27.881     0.200
    11.344    28.307     0.200
    11.438    29.800     0.200
    11.438    29.101     0.200
    11.541    27.905     0.200
    11.603    29.579     0.200
    11.603    29.180     0.200
    11.799    29.991     0.200
    11.799    29.890     0.200
    12.181    28.436     0.200
    12.387    29.026     0.200
    12.545    30.181     0.200
    13.357    32.010     0.200
    13.357    31.710     0.200
    13.638    32.731     0.200
    13.719    32.786     0.200
    13.719    32.485     0.200
    14.001    31.990     0.200
    14.001    31.189     0.200
    14.260    34.172     0.200
    14.756    32.687     0.200
    14.878    30.959     0.200
    14.906    34.030     0.200
    14.906    33.631     0.200
    15.646    33.900     0.200
    15.646    33.001     0.200
    17.853    36.236     0.200
     0.052     6.453     0.200
     0.257     4.251     0.200
     0.416     4.600     0.200
     0.585     4.629     0.200
     1.034     6.984     0.200
     1.581     6.603     0.200
     1.612     5.646     0.200
     1.954     7.254     0.200
     1.962     9.157     0.200
     2.243     9.580     0.200
     3.088    11.824     0.200
     3.593    17.127     0.200
     6.595    16.488     0.200
     6.994    19.828     0.200
     7.083    18.497     0.200
     7.410    19.886     0.200
     7.538    20.284     0.200
    10.327    24.739     0.200
     0.082     6.088     0.200
     0.570     4.594     0.200
     1.052     6.261     0.200
     1.556     5.984     0.200
     1.577     5.740     0.200
     1.678     7.163     0.200
     1.829     8.792     0.200
     1.926     7.167     0.200
     1.983     7.995     0.200
     2.234     9.267     0.200
     2.399    11.147     0.200
     2.870    11.348     0.200
     3.082    11.280     0.200
     3.484    11.684     0.200
     3.589    16.252     0.200
     4.191    12.925     0.200
     4.461    13.682     0.200
     4.616    14.269     0.200
     5.056    15.641     0.200
     6.595    15.881     0.200
     6.986    21.011     0.200
     7.079    18.125     0.200
     7.407    21.501     0.200
     7.539    19.356     0.200
     8.391    23.212     0.200
     9.585    25.585     0.200
    10.316    25.751     0.200
    11.375    28.594     0.200
     0.107     5.362     0.200
     0.256     4.429     0.200
     0.415     4.972     0.200
     0.535     4.465     0.200
     1.565     6.547     0.200
     1.683     5.172     0.200
     1.796     6.855     0.200
     1.940     7.974     0.200
     1.962     7.915     0.200
     2.265     9.481     0.200
     3.114    12.078     0.200
     6.628    16.162     0.200
     7.017    19.924     0.200
     7.112    18.015     0.200
     7.440    19.383     0.200
    10.346    25.679     0.200
    11.401    29.367     0.200
     0.124     6.363     0.200
     0.227     4.959     0.200
     0.385     5.312     0.200
     0.539     3.818     0.200
     1.057     6.364     0.200
     1.537     5.565     0.200
     1.813     8.141     0.200
     1.907     7.055     0.200
     1.993     8.046     0.200
     2.243     9.533     0.200
     2.396    11.342     0.200
     3.093    11.407     0.200
     3.604    15.247     0.200
     6.612    16.142     0.200
     6.995    19.678     0.200
     7.093    18.024     0.200
     7.422    18.887     0.200
    10.322    25.252     0.200
    11.373    28.685     0.200
     0.124     6.990     0.200
     0.231     6.735     0.200
     0.361     6.527     0.200
     0.746     5.331     0.200
     1.154     7.368     0.200
     1.679     6.444     0.200
     1.702     7.575     0.200
     1.724     7.314     0.200
     1.904     8.117     0.200
     1.985    10.074     0.200
     2.133     7.537     0.200
     2.064     9.349     0.200
     2.105     9.269     0.200
     2.306    10.520     0.200
     2.942    12.098     0.200
     3.442    14.264     0.200
     4.309    14.147     0.200
     6.396    18.794     0.200
     6.440    15.886     0.200
     6.854    19.448     0.200
     6.932    18.533     0.200
     7.257    19.545     0.200
     7.380    19.410     0.200
     9.465    24.480     0.200
    10.192    23.789     0.200
    11.276    28.040     0.200
     0.142     7.080     0.200
     0.155     8.135     0.200
     0.278     7.599     0.200
     0.721     5.426     0.200
     1.593     6.248     0.200
     1.615     6.501     0.200
     1.670     6.955     0.200
     1.825     8.051     0.200
     1.995     8.568     0.200
     2.066     7.733     0.200
     2.072     8.959     0.200
     2.120     9.098     0.200
     2.252     9.559     0.200
     2.702    11.314     0.200
     2.918    11.095     0.200
     3.171     9.934     0.200
     3.319    11.109     0.200
     3.424    12.880     0.200
     4.296    13.711     0.200
     4.569    16.529     0.200
     4.671    16.226     0.200
     4.762    14.573     0.200
     4.891    15.771     0.200
     6.430    16.510     0.200
     6.824    19.308     0.200
     6.921    19.277     0.200
     6.915    18.151     0.200
     7.242    18.932     0.200
     7.375    19.479     0.200
     8.349    20.909     0.200
    10.167    24.798     0.200
    11.226    28.434     0.200
     0.113     7.499     0.200
     0.201     7.666     0.200
     0.234     7.481     0.200
     0.746     5.707     0.200
     1.245     7.287     0.200
     1.571     6.484     0.200
     1.575     6.134     0.200
     1.677     6.350     0.200
     1.780     7.548     0.200
     2.031     9.112     0.200
     2.063     7.346     0.200
     2.031     9.318     0.200
     2.199     7.655     0.200
     2.167     9.029     0.200
     2.206     9.869     0.200
     2.671    10.243     0.200
     2.878    11.732     0.200
     3.397    12.173     0.200
     3.285    11.977     0.200
     3.387    13.694     0.200
     4.259    14.109     0.200
     5.509    16.420     0.200
     6.351    17.696     0.200
     6.677    22.089     0.200
     6.783    19.465     0.200
     6.876    17.569     0.200
     7.205    19.136     0.200
     7.341    19.547     0.200
     9.383    24.210     0.200
    10.124    24.870     0.200
    11.181    28.138     0.200
     0.122     6.996     0.200
     0.188     6.422     0.200
     0.324     7.035     0.200
     0.721     5.498     0.200
     1.165     7.118     0.200
     1.284     7.532     0.200
     1.634     6.451     0.200
     1.688     7.318     0.200
     1.662     5.929     0.200
     1.870     7.994     0.200
     1.977     8.443     0.200
     2.093     8.495     0.200
     2.082     7.619     0.200
     2.100     9.018     0.200
     2.278     8.433     0.200
     2.289     9.507     0.200
     2.720     9.779     0.200
     2.941    11.896     0.200
     3.406    11.878     0.200
     3.334    11.718     0.200
     3.419    14.513     0.200
     3.445    13.320     0.200
     4.042    12.348     0.200
     4.314    13.977     0.200
     4.510    14.694     0.200
     4.767    14.695     0.200
     4.910    14.026     0.200
     5.342    17.878     0.200
     5.565    16.380     0.200
     6.188    16.601     0.200
     6.209    16.862     0.200
     6.403    16.799     0.200
     6.446    15.794     0.200
     6.735    22.720     0.200
     6.833    20.775     0.200
     6.850    19.077     0.200
     6.850    19.277     0.200
     6.935    17.788     0.200
     7.261    19.385     0.200
     7.389    18.892     0.200
     7.464    23.515     0.200
     8.396    21.542     0.200
     8.551    24.527     0.200
     9.457    24.358     0.200
    11.261    28.200     0.200
    11.560    27.917     0.200
    14.987    33.624     0.200
     0.113     8.303     0.200
     0.197     7.322     0.200
     0.334     7.022     0.200
     0.718     4.642     0.200
     1.156     6.733     0.200
     1.292     8.144     0.200
     1.640     6.481     0.200
     1.660     6.155     0.200
     1.689     6.517     0.200
     1.671     7.023     0.200
     1.880     9.079     0.200
     2.095     7.371     0.200
     2.108     9.624     0.200
     2.287     8.740     0.200
     2.299    10.899     0.200
     2.660    10.183     0.200
     2.949    11.808     0.200
     3.123    10.776     0.200
     3.406    10.481     0.200
     3.452    12.939     0.200
     4.049    12.575     0.200
     4.321    14.299     0.200
     4.526    15.402     0.200
     4.517    14.509     0.200
     4.764    14.429     0.200
     4.917    16.346     0.200
     5.572    16.301     0.200
     6.216    16.983     0.200
     6.409    16.426     0.200
     6.453    15.920     0.200
     6.925    18.905     0.200
     6.859    19.585     0.200
     6.942    18.007     0.200
     7.268    18.104     0.200
     7.395    19.321     0.200
     7.450    19.078     0.200
     7.675    19.853     0.200
     8.405    21.142     0.200
     9.466    24.260     0.200
    10.204    24.639     0.200
    11.271    27.491     0.200
     0.119     7.953     0.200
     0.223     7.241     0.200
     0.354     7.309     0.200
     1.153     6.885     0.200
     1.669     6.363     0.200
     1.688     6.142     0.200
     1.715     6.433     0.200
     1.695     6.670     0.200
     1.898     7.892     0.200
     1.980     9.336     0.200
     2.658    10.227     0.200
     3.116    10.385     0.200
     3.445    15.237     0.200
     4.524    14.651     0.200
     4.626    15.758     0.200
     4.785    14.606     0.200
     6.444    16.048     0.200
     6.947    17.173     0.200
     6.856    19.436     0.200
     6.936    18.306     0.200
     7.261    19.514     0.200
     7.385    19.965     0.200
     7.443    18.789     0.200
     8.430    21.070     0.200
    10.204    24.766     0.200
    11.276    28.056     0.200
     0.085     6.047     0.200
     0.257     3.841     0.200
     0.416     4.379     0.200
     0.554     4.076     0.200
     1.028     6.139     0.200
     1.548     6.177     0.200
     1.585     5.746     0.200
     1.615     5.785     0.200
     1.807     9.151     0.200
     1.947     6.517     0.200
     2.258    10.888     0.200
     2.525    10.168     0.200
     3.010    10.111     0.200
     3.612    14.083     0.200
     4.392    15.583     0.200
     4.601    14.149     0.200
     4.496    15.575     0.200
     6.617    16.621     0.200
     7.010    20.433     0.200
     7.102    19.455     0.200
     7.612    19.404     0.200
     0.152     7.315     0.200
     0.156     7.566     0.200
     0.284     7.074     0.200
     0.730     5.563     0.200
     1.249     8.904     0.200
     1.201     6.474     0.200
     1.604     6.562     0.200
     1.621     6.167     0.200
     1.622     5.752     0.200
     1.681     7.063     0.200
     1.829     8.135     0.200
     2.000    10.140     0.200
     2.078     8.238     0.200
     2.069    10.339     0.200
     2.242     8.023     0.200
     2.252     9.804     0.200
     2.703    10.537     0.200
     2.913    11.686     0.200
     3.171    10.878     0.200
     3.400    10.803     0.200
     3.419    14.583     0.200
     4.290    14.419     0.200
     4.570    17.152     0.200
     4.772    14.799     0.200
     6.380    17.025     0.200
     6.423    15.921     0.200
     6.820    17.890     0.200
     6.931    19.702     0.200
     6.909    17.552     0.200
     7.236    19.434     0.200
     7.368    20.099     0.200
     7.419    18.906     0.200
     7.721    19.885     0.200
     8.358    21.452     0.200
     9.424    24.303     0.200
    10.164    24.871     0.200
    11.226    27.181     0.200
    11.526    26.873     0.200
    12.314    27.575     0.200
     0.141     7.416     0.200
     0.172     7.056     0.200
     0.424     6.321     0.200
     0.711     6.164     0.200
     1.292     5.288     0.200
     1.303     5.162     0.200
     1.311     5.766     0.200
     1.388     6.865     0.200
     1.497     7.595     0.200
     1.559     5.873     0.200
     1.995     9.779     0.200
     2.863    10.953     0.200
     3.390    15.510     0.200
     3.377    10.354     0.200
     4.656    14.735     0.200
     4.832    15.176     0.200
     6.414    15.417     0.200
     6.736    19.454     0.200
     7.391    19.209     0.200
     7.890    20.390     0.200
    11.062    29.370     0.200
     0.478     8.129     0.200
     0.707     7.855     0.200
     0.849     6.499     0.200
     0.973     7.252     0.200
     1.129     8.538     0.200
     1.850     6.619     0.200
     1.934     9.242     0.200
     2.253     7.621     0.200
     2.338    10.032     0.200
     3.784    13.648     0.200
     3.884    13.588     0.200
     4.109    15.758     0.200
     6.912    18.053     0.200
     7.054    17.393     0.200
     7.560    20.586     0.200
     7.585    19.189     0.200
     7.896    20.266     0.200
     7.965    21.255     0.200
     8.074    20.186     0.200
    11.550    27.921     0.200
     0.816     6.574     0.200
     1.302     5.590     0.200
     1.350     6.030     0.200
     1.348     6.257     0.200
     1.515     6.917     0.200
     1.459     7.468     0.200
     1.602     7.792     0.200
     1.892     7.416     0.200
     1.936     7.601     0.200
     1.928     8.991     0.200
     2.003     8.221     0.200
     2.152    11.378     0.200
     2.605    11.091     0.200
     2.756    11.334     0.200
     2.944    12.732     0.200
     3.282    13.190     0.200
     3.445    12.583     0.200
     4.166    14.881     0.200
     4.765    15.882     0.200
     4.810    16.961     0.200
     6.305    16.612     0.200
     6.636    19.948     0.200
     6.906    23.598     0.200
     7.100    21.738     0.200
     9.213    24.475     0.200
     9.959    26.265     0.200
    10.978    30.272     0.200
    12.533    31.234     0.200
     0.529     4.887     0.200
     0.869     5.825     0.200
     1.230     4.898     0.200
     1.303     5.157     0.200
     1.306     5.615     0.200
     1.437     5.686     0.200
     1.532     6.976     0.200
     1.872     6.707     0.200
     1.839     6.401     0.200
     1.917     9.484     0.200
     2.209    10.084     0.200
     2.570    10.474     0.200
     2.706    10.286     0.200
     3.015    12.278     0.200
     3.106    15.008     0.200
     3.179    11.956     0.200
     3.236    14.796     0.200
     3.520    12.283     0.200
     3.873    13.656     0.200
     4.121    14.865     0.200
     4.282    14.893     0.200
     4.786    15.005     0.200
     4.880    16.914     0.200
     6.018    15.323     0.200
     6.262    15.888     0.200
     6.578    19.089     0.200
     6.714    18.503     0.200
     7.237    18.507     0.200
     7.615    22.187     0.200
     9.150    24.680     0.200
     9.540    26.229     0.200
    11.236    27.635     0.200
    12.598    30.837     0.200
    18.584    40.980     0.200
     0.135     7.445     0.200
     0.268     6.593     0.200
     0.166     7.776     0.200
     0.727     5.131     0.200
     1.210     6.492     0.200
     1.588     5.483     0.200
     1.605     5.690     0.200
     1.605     6.283     0.200
     1.672     6.808     0.200
     1.814     6.848     0.200
     2.065     7.914     0.200
     2.003     8.036     0.200
     2.062     8.947     0.200
     2.225     8.055     0.200
     2.132     8.242     0.200
     2.241     9.757     0.200
     2.697    10.541     0.200
     2.908    11.078     0.200
     3.311    12.376     0.200
     3.415    14.159     0.200
     4.018    13.123     0.200
     4.287    14.985     0.200
     4.478    14.553     0.200
     4.579    14.576     0.200
     4.766    14.391     0.200
     4.882    17.746     0.200
     5.537    16.394     0.200
     6.181    16.878     0.200
     6.378    17.583     0.200
     6.421    15.582     0.200
     6.814    18.994     0.200
     6.905    17.731     0.200
     7.233    19.208     0.200
     7.367    19.246     0.200
     7.416    18.777     0.200
    11.215    27.530     0.200
     0.169     7.094     0.200
     0.469     6.094     0.200
     0.721     4.945     0.200
     1.266     5.284     0.200
     1.521     6.010     0.200
     1.803     6.124     0.200
     1.871     6.024     0.200
     2.063     7.288     0.200
     1.988     8.860     0.200
     2.068     8.823     0.200
     2.363     7.582     0.200
     2.889     9.345     0.200
     2.720    10.419     0.200
     2.856    11.235     0.200
     3.189     9.448     0.200
     3.248    13.162     0.200
     3.409     9.579     0.200
     3.330    11.999     0.200
     3.387    12.637     0.200
     3.531    12.652     0.200
     4.024    14.905     0.200
     4.025    13.093     0.200
     4.273    14.099     0.200
     4.641    12.900     0.200
     4.432    14.643     0.200
     4.752    14.610     0.200
     4.857    15.381     0.200
     5.473    17.492     0.200
     5.516    16.696     0.200
     5.534    14.980     0.200
     6.157    17.014     0.200
     6.170    16.259     0.200
     6.225    20.419     0.200
     6.373    16.687     0.200
     6.413    15.622     0.200
     6.780    17.133     0.200
     6.536    18.790     0.200
     6.633    20.452     0.200
     6.628    20.613     0.200
     6.725    19.587     0.200
     6.733    16.688     0.200
     6.773    20.024     0.200
     6.865    17.350     0.200
     6.905    17.877     0.200
     7.021    20.129     0.200
     6.998    18.394     0.200
     7.078    21.267     0.200
     7.203    19.005     0.200
     7.376    19.990     0.200
     7.415    21.427     0.200
     7.376    18.588     0.200
     7.388    19.048     0.200
     7.455    21.962     0.200
     7.916    18.685     0.200
     7.773    23.051     0.200
     7.782    19.251     0.200
     8.013    22.551     0.200
     8.056    20.651     0.200
     8.305    23.839     0.200
     8.418    23.819     0.200
     8.640    24.038     0.200
     8.888    25.336     0.200
     9.004    24.181     0.200
     9.127    25.050     0.200
     9.291    24.941     0.200
     9.312    24.194     0.200
     9.456    24.707     0.200
     9.465    24.611     0.200
    10.035    24.955     0.200
    10.040    24.701     0.200
    10.148    26.638     0.200
    10.257    26.360     0.200
    10.413    27.040     0.200
    10.400    23.692     0.200
    11.038    27.847     0.200
    11.246    26.218     0.200
    11.122    29.263     0.200
    11.271    26.527     0.200
    11.297    30.226     0.200
    12.096    27.297     0.200
    12.462    28.635     0.200
    13.287    29.601     0.200
    13.413    31.535     0.200
    14.460    32.811     0.200
    15.143    31.339     0.200
     0.109     8.315     0.200
     0.376     6.404     0.200
     0.736     5.298     0.200
     1.136     7.133     0.200
     1.685     6.120     0.200
     1.705     6.287     0.200
     1.720     6.720     0.200
     1.715     5.971     0.200
     1.920     7.982     0.200
     1.969     8.508     0.200
     2.046     9.015     0.200
     2.122     9.219     0.200
     2.332     8.069     0.200
     2.324     9.862     0.200
     2.641     8.570     0.200
     2.727    10.161     0.200
     3.096    10.753     0.200
     3.341    12.003     0.200
     3.459    12.626     0.200
     3.698    12.831     0.200
     4.050    13.721     0.200
     4.506    15.900     0.200
     4.525    14.780     0.200
     4.783    14.671     0.200
     5.576    16.913     0.200
     6.455    16.257     0.200
     6.871    19.300     0.200
     6.949    17.997     0.200
     6.976    18.775     0.200
     7.273    19.008     0.200
     7.395    19.584     0.200
     7.653    20.679     0.200
    10.220    24.919     0.200
    12.256    27.459     0.200
    18.463    36.527     0.200
     0.139     7.608     0.200
     0.338     6.597     0.200
     0.753     5.052     0.200
     1.175     6.825     0.200
     1.664     6.316     0.200
     1.680     6.730     0.200
     1.723     6.934     0.200
     1.880     8.395     0.200
     2.000     8.597     0.200
     2.127     9.806     0.200
     2.087     9.088     0.200
     2.085     9.709     0.200
     2.302     7.870     0.200
     2.284     9.390     0.200
     2.697     9.868     0.200
     2.924    11.718     0.200
     3.310    11.707     0.200
     3.425    13.369     0.200
     3.660    13.123     0.200
     4.019    13.431     0.200
     4.137    15.054     0.200
     4.293    13.242     0.200
     4.491    14.930     0.200
     4.546    15.287     0.200
     4.799    14.735     0.200
     4.889    17.183     0.200
     5.544    16.346     0.200
     6.834    19.976     0.200
     6.942    18.325     0.200
    11.254    28.400     0.200
     0.173     7.258     0.200
     0.157     6.849     0.200
     0.278     6.930     0.200
     0.752     5.401     0.200
     1.218     6.767     0.200
     1.254     6.441     0.200
     1.526     6.768     0.200
     1.614     6.549     0.200
     1.621     7.164     0.200
     1.701     7.334     0.200
     1.822     7.918     0.200
     2.022     9.184     0.200
     2.094     8.637     0.200
     2.135     8.063     0.200
     2.050     9.460     0.200
     2.245     8.582     0.200
     2.236     9.980     0.200
     2.640    10.467     0.200
     2.677     9.837     0.200
     2.893    11.317     0.200
     3.186    10.001     0.200
     3.286    11.831     0.200
     3.291    11.673     0.200
     3.420    12.469     0.200
     3.368    13.775     0.200
     3.398    14.022     0.200
     3.623    12.798     0.200
     3.999    13.413     0.200
     4.102    14.204     0.200
     4.462    15.203     0.200
     4.588    15.342     0.200
     4.651    15.002     0.200
     4.793    14.942     0.200
     4.864    16.316     0.200
     5.519    16.666     0.200
     5.598    17.251     0.200
     5.872    17.655     0.200
     6.145    16.463     0.200
     6.164    17.548     0.200
     6.390    16.410     0.200
     6.402    15.968     0.200
     6.574    19.958     0.200
     6.682    17.205     0.200
     6.781    20.339     0.200
     6.801    19.315     0.200
     6.952    18.946     0.200
     6.888    17.990     0.200
     6.914    18.392     0.200
     6.946    19.016     0.200
     6.993    19.475     0.200
     7.137    20.790     0.200
     7.215    19.476     0.200
     7.255    19.411     0.200
     7.347    19.544     0.200
     7.398    19.145     0.200
     7.417    19.526     0.200
     7.544    22.043     0.200
     7.553    22.930     0.200
     7.692    20.313     0.200
     7.831    21.689     0.200
     7.886    18.654     0.200
     8.666    23.942     0.200
     9.406    24.313     0.200
    10.145    24.686     0.200
    11.209    28.468     0.200
    12.333    28.152     0.200
    15.037    32.397     0.200
     0.737     4.234     0.200
     1.023     7.207     0.200
     1.061     7.260     0.200
     1.132     5.729     0.200
     1.269     6.727     0.200
     1.271     8.010     0.200
     1.866     8.065     0.200
     1.924     8.381     0.200
     2.037     9.070     0.200
     2.182     9.372     0.200
     2.298    10.525     0.200
     2.802    10.138     0.200
     2.894    10.770     0.200
     3.465    13.208     0.200
     3.463    12.425     0.200
     3.822    12.736     0.200
     4.451    15.891     0.200
     6.644    21.907     0.200
     8.233    23.056     0.200
     0.146     7.143     0.200
     0.161     7.579     0.200
     0.278     6.611     0.200
     0.731     5.817     0.200
     1.205     7.285     0.200
     1.515     7.569     0.200
     1.600     6.284     0.200
     1.616     6.386     0.200
     1.680     7.349     0.200
     1.824     8.071     0.200
     1.968     7.881     0.200
     2.003     8.574     0.200
     2.075     8.533     0.200
     2.065     9.355     0.200
     2.125     8.653     0.200
     2.236     8.152     0.200
     2.247    10.027     0.200
     2.651    10.517     0.200
     2.696    10.583     0.200
     2.910    11.294     0.200
     3.176    10.785     0.200
     3.305    11.883     0.200
     3.310    12.021     0.200
     3.381    14.789     0.200
     3.416    13.386     0.200
     3.638    13.094     0.200
     4.018    14.568     0.200
     4.118    14.798     0.200
     4.479    14.975     0.200
     4.575    15.464     0.200
     4.668    15.382     0.200
     4.772    14.561     0.200
     5.538    16.830     0.200
     5.888    17.537     0.200
     6.408    16.169     0.200
     6.421    15.923     0.200
     6.816    18.905     0.200
     6.931    18.967     0.200
     6.906    16.953     0.200
     6.931    18.362     0.200
     6.961    20.012     0.200
     7.233    18.837     0.200
     7.366    18.293     0.200
     7.416    19.005     0.200
     7.726    19.297     0.200
     7.847    20.670     0.200
     7.904    19.013     0.200
     8.680    23.951     0.200
     9.420    24.615     0.200
    10.160    25.186     0.200
    11.221    28.305     0.200
    11.369    29.376     0.200
    12.319    27.489     0.200
    18.479    36.803     0.200
    20.755    35.038     0.200
     0.195     7.247     0.200
     0.344     6.704     0.200
     0.729     5.415     0.200
     1.155     6.941     0.200
     1.462     7.258     0.200
     1.655     6.606     0.200
     1.702     6.852     0.200
     1.889     8.477     0.200
     1.982     7.591     0.200
     1.976     8.259     0.200
     2.110     8.696     0.200
     2.069     9.174     0.200
     2.107     9.737     0.200
     2.300     8.480     0.200
     2.705    10.651     0.200
     2.721    10.572     0.200
     2.946    11.938     0.200
     3.330    11.459     0.200
     3.681    12.859     0.200
     4.043    12.136     0.200
     4.704    15.426     0.200
     5.567    16.352     0.200
     5.927    17.156     0.200
     6.448    15.679     0.200
     6.857    19.101     0.200
     6.938    18.350     0.200
     7.004    21.588     0.200
     7.389    19.588     0.200
     7.446    19.428     0.200
     7.885    22.302     0.200
     7.933    19.137     0.200
     8.417    21.091     0.200
     8.726    24.485     0.200
     9.465    23.862     0.200
    11.273    27.969     0.200
    13.129    29.905     0.200
     1.336     8.403     0.200
     1.435     9.245     0.200
     1.809    11.882     0.200
     1.954    11.196     0.200
     1.865    10.233     0.200
     1.984    10.836     0.200
     2.236    12.897     0.200
     2.317    12.959     0.200
     3.136    14.403     0.200
     4.426    18.839     0.200
     4.823    19.714     0.200
     4.823    20.214     0.200
     4.899    19.824     0.200
     6.551    23.244     0.200
     6.684    21.796     0.200
     6.701    20.793     0.200
     0.181     7.128     0.200
     0.328     6.413     0.200
     0.710     5.955     0.200
     1.156     6.953     0.200
     1.465     7.045     0.200
     1.630     7.223     0.200
     1.678     7.656     0.200
     1.875     8.365     0.200
     1.960     7.375     0.200
     1.966     8.299     0.200
     2.084     7.916     0.200
     2.074     9.039     0.200
     2.110     9.620     0.200
     2.277     8.668     0.200
     2.298    11.430     0.200
     2.701    10.718     0.200
     2.731    11.368     0.200
     2.952    11.793     0.200
     3.345    11.205     0.200
     3.684    13.253     0.200
     4.054    13.937     0.200
     4.755    14.849     0.200
     4.710    15.279     0.200
     5.576    17.171     0.200
     5.931    18.022     0.200
     6.445    16.032     0.200
     6.457    15.587     0.200
     6.861    19.576     0.200
     6.946    17.682     0.200
     6.972    17.878     0.200
     7.272    19.375     0.200
     7.454    18.647     0.200
     7.942    18.557     0.200
     8.727    23.393     0.200
    13.107    29.287     0.200
     0.559     4.938     0.200
     0.935     6.155     0.200
     1.378     6.479     0.200
     1.438     6.583     0.200
     1.565     8.100     0.200
     1.698     7.543     0.200
     1.773     7.673     0.200
     1.920     7.956     0.200
     1.881     7.911     0.200
     2.002     9.194     0.200
     1.891     8.094     0.200
     2.033     8.937     0.200
     2.271     9.858     0.200
     2.294     9.090     0.200
     2.498    10.212     0.200
     2.491    10.295     0.200
     2.637    10.589     0.200
     3.092    11.276     0.200
     3.164    13.039     0.200
     3.548    10.955     0.200
     3.548    11.353     0.200
     3.816    14.827     0.200
     3.797    13.047     0.200
     4.389    15.736     0.200
     4.922    16.923     0.200
     5.292    17.599     0.200
     5.934    17.109     0.200
     5.943    18.006     0.200
     6.188    16.047     0.200
     6.517    19.903     0.200
     6.504    17.961     0.200
     6.652    20.938     0.200
     6.645    19.209     0.200
     6.663    18.199     0.200
     7.007    22.583     0.200
     6.981    20.785     0.200
     7.149    19.936     0.200
     7.166    19.235     0.200
     7.560    22.135     0.200
     7.560    20.037     0.200
     7.656    20.013     0.200
     8.005    22.941     0.200
     8.005    23.340     0.200
     8.353    25.874     0.200
    10.867    29.744     0.200
    12.648    30.754     0.200
    12.648    31.152     0.200
    15.338    37.362     0.200
     1.386     6.882     0.200
     1.591     8.284     0.200
     1.845     9.314     0.200
     1.784     7.836     0.200
     1.987     9.658     0.200
     1.875     7.966     0.200
     1.909     7.972     0.200
     2.266    10.007     0.200
     2.277     9.272     0.200
     2.529     9.340     0.200
     2.522    10.816     0.200
     2.651    10.610     0.200
     3.074    12.477     0.200
     3.048    12.883     0.200
     3.351    13.749     0.200
     3.121    11.429     0.200
     3.131    11.811     0.200
     3.183    12.103     0.200
     3.578    12.097     0.200
     3.820    15.268     0.200
     3.824    13.630     0.200
     4.070    14.360     0.200
     4.227    15.019     0.200
     4.401    16.495     0.200
     4.827    16.923     0.200
     4.653    15.549     0.200
     4.939    17.213     0.200
     5.003    18.662     0.200
     5.275    18.295     0.200
     5.312    17.363     0.200
     5.603    18.463     0.200
     5.953    17.183     0.200
     5.968    17.406     0.200
     6.201    16.690     0.200
     6.210    15.981     0.200
     6.331    19.967     0.200
     6.439    20.707     0.200
     6.425    21.872     0.200
     6.465    19.401     0.200
     6.521    20.624     0.200
     6.521    20.948     0.200
     6.534    17.402     0.200
     6.652    22.021     0.200
     6.660    17.927     0.200
     6.676    19.037     0.200
     6.822    22.243     0.200
     6.795    20.557     0.200
     6.999    19.178     0.200
     7.057    22.490     0.200
     7.171    23.166     0.200
     7.218    23.622     0.200
     7.183    19.520     0.200
     7.174    21.129     0.200
     7.254    23.302     0.200
     7.510    20.006     0.200
     7.567    22.842     0.200
     7.577    20.422     0.200
     7.674    20.494     0.200
     7.936    23.142     0.200
     7.815    24.646     0.200
     7.768    20.593     0.200
     7.851    23.226     0.200
     8.104    24.381     0.200
     8.216    24.972     0.200
     8.347    26.436     0.200
     8.439    25.364     0.200
     8.692    27.416     0.200
     8.736    24.900     0.200
     8.892    26.082     0.200
     8.933    25.598     0.200
     9.004    25.768     0.200
     9.111    26.521     0.200
     9.256    27.832     0.200
     9.283    26.515     0.200
     9.483    27.179     0.200
     9.802    30.255     0.200
     9.931    28.960     0.200
     9.962    25.592     0.200
    10.064    28.406     0.200
    10.198    28.845     0.200
    10.215    29.640     0.200
    10.541    28.834     0.200
    10.938    29.199     0.200
    11.072    29.638     0.200
    11.108    32.214     0.200
    11.140    30.845     0.200
    12.655    31.166     0.200
    12.657    31.239     0.200
    12.857    35.412     0.200
    12.971    32.482     0.200
    13.517    36.102     0.200
    14.268    35.343     0.200
    14.375    34.091     0.200
    14.681    37.524     0.200
    15.006    33.330     0.200
    15.343    35.803     0.200
    15.343    32.803     0.200
     0.478     4.794     0.200
     0.809     5.530     0.200
     1.309     5.503     0.200
     1.490     5.889     0.200
     1.473     7.186     0.200
     1.792     7.466     0.200
     1.905     8.746     0.200
     1.898     7.229     0.200
     1.996     7.682     0.200
     2.149     9.300     0.200
     2.398     9.388     0.200
     2.412    10.223     0.200
     2.621    11.782     0.200
     2.763    10.724     0.200
     3.167    13.411     0.200
     3.223    12.766     0.200
     3.232    12.658     0.200
     3.927    14.540     0.200
     4.515    15.686     0.200
     4.742    17.040     0.200
     4.742    17.540     0.200
     5.421    18.111     0.200
     6.639    20.302     0.200
     6.790    19.139     0.200
     7.683    21.711     0.200
     8.467    25.559     0.200
    10.970    29.254     0.200
     1.292     6.363     0.200
     1.492     6.324     0.200
     1.464     7.451     0.200
     1.552     8.129     0.200
     1.783     7.726     0.200
     1.872     7.693     0.200
     1.888     8.503     0.200
     1.883     8.568     0.200
     1.915     8.186     0.200
     2.132     9.660     0.200
     2.411     9.408     0.200
     2.405     9.775     0.200
     2.642    10.705     0.200
     2.782    11.074     0.200
     3.243    11.693     0.200
     3.312    12.893     0.200
     4.533    16.643     0.200
     5.440    18.052     0.200
     6.327    16.801     0.200
     6.655    20.473     0.200
     6.808    20.092     0.200
     8.482    26.554     0.200
     0.546     4.846     0.200
     0.880     5.853     0.200
     1.305     5.894     0.200
     1.427     5.973     0.200
     1.619     8.131     0.200
     1.866     8.241     0.200
     1.828     7.292     0.200
     1.863     7.282     0.200
     1.955     9.202     0.200
     1.922     8.186     0.200
     2.220     9.811     0.200
     2.325     8.793     0.200
     2.483    11.046     0.200
     2.560    11.144     0.200
     2.695    10.575     0.200
     3.027    11.697     0.200
     3.027    12.098     0.200
     3.160    11.145     0.200
     3.225    12.381     0.200
     3.532    12.107     0.200
     3.864    13.934     0.200
     4.271    15.182     0.200
     4.445    15.150     0.200
     5.354    16.541     0.200
     5.648    17.107     0.200
     6.242    15.580     0.200
     6.251    15.569     0.200
     6.567    19.286     0.200
     6.698    20.454     0.200
     6.703    17.792     0.200
     6.720    18.295     0.200
     7.041    19.848     0.200
     7.226    18.792     0.200
     7.300    21.832     0.200
     7.612    22.588     0.200
     7.717    18.967     0.200
     8.394    25.060     0.200
     0.514     4.726     0.200
     0.882     5.930     0.200
     1.363     6.322     0.200
     1.470     6.272     0.200
     1.825     7.433     0.200
     1.925     8.563     0.200
     1.987     8.742     0.200
     2.342     9.392     0.200
     2.689    11.349     0.200
     3.143    12.052     0.200
     3.216    15.200     0.200
     4.442    15.894     0.200
     4.824    16.435     0.200
     4.824    17.035     0.200
     6.569    19.764     0.200
     0.483     4.803     0.200
     0.828     5.785     0.200
     1.327     5.962     0.200
     1.488     6.783     0.200
     1.597     7.400     0.200
     1.482     7.749     0.200
     1.909     7.362     0.200
     1.916     8.682     0.200
     1.928     8.746     0.200
     1.800     7.638     0.200
     1.879     6.718     0.200
     1.983     8.307     0.200
     2.166     9.366     0.200
     2.385     9.508     0.200
     2.420     9.903     0.200
     2.600    11.206     0.200
     2.744    10.620     0.200
     2.966    11.935     0.200
     3.152    13.863     0.200
     3.310    12.019     0.200
     3.201    11.287     0.200
     3.210    12.181     0.200
     3.272    13.656     0.200
     3.469    12.162     0.200
     3.920    14.898     0.200
     3.906    13.257     0.200
     4.157    14.137     0.200
     4.320    16.227     0.200
     4.496    16.176     0.200
     4.765    15.642     0.200
     4.742    16.301     0.200
     4.831    17.270     0.200
     5.380    18.864     0.200
     5.401    17.617     0.200
     5.702    18.210     0.200
     6.042    17.629     0.200
     6.052    18.017     0.200
     6.287    16.379     0.200
     6.297    16.464     0.200
     6.426    19.653     0.200
     6.546    20.254     0.200
     6.525    21.494     0.200
     6.557    22.121     0.200
     6.621    19.874     0.200
     6.613    18.473     0.200
     6.754    21.326     0.200
     6.753    18.140     0.200
     6.904    19.377     0.200
     6.771    19.031     0.200
     6.926    21.820     0.200
     6.882    19.326     0.200
     7.090    19.308     0.200
     7.145    20.457     0.200
     7.266    25.846     0.200
     7.258    20.447     0.200
     7.356    23.900     0.200
     7.596    21.005     0.200
     7.665    22.090     0.200
     7.667    24.165     0.200
     7.668    20.160     0.200
     7.764    20.034     0.200
     8.014    21.623     0.200
     7.946    24.920     0.200
     8.206    24.882     0.200
     8.317    26.587     0.200
     8.452    25.006     0.200
     8.830    24.593     0.200
     9.099    25.457     0.200
     9.196    25.528     0.200
     9.321    23.865     0.200
     9.838    25.331     0.200
     9.717    25.244     0.200
    10.039    28.492     0.200
    10.647    27.393     0.200
    11.050    28.186     0.200
    10.958    29.467     0.200
    11.047    30.724     0.200
    12.153    30.822     0.200
    12.551    30.972     0.200
    12.730    32.090     0.200
    13.472    34.423     0.200
    14.482    33.639     0.200
    15.238    32.814     0.200
     0.462     5.442     0.200
     1.369     5.958     0.200
     1.517     6.026     0.200
     1.626     8.960     0.200
     1.782     8.136     0.200
     1.951     8.167     0.200
     1.952     9.145     0.200
     1.876     9.036     0.200
     2.397     9.961     0.200
     3.188    11.725     0.200
     3.264    15.833     0.200
     4.493    16.501     0.200
     6.622    20.654     0.200
     0.564     4.751     0.200
     0.871     5.873     0.200
     1.262     5.613     0.200
     1.403     5.961     0.200
     1.586     7.326     0.200
     1.827     6.817     0.200
     1.840     7.259     0.200
     1.926     8.362     0.200
     1.875     7.954     0.200
     1.921     8.626     0.200
     2.213    10.012     0.200
     2.322     8.840     0.200
     2.496    10.703     0.200
     2.583     9.688     0.200
     2.709    10.224     0.200
     3.182    11.707     0.200
     3.242    14.002     0.200
     4.285    15.834     0.200
     4.457    14.823     0.200
     4.897    16.693     0.200
     6.260    16.282     0.200
     6.575    19.311     0.200
     6.704    20.598     0.200
     6.733    19.259     0.200
     7.622    21.888     0.200
     8.397    24.847     0.200
    19.292    38.703     0.200
     0.496     4.897     0.200
     0.842     5.958     0.200
     1.477     6.049     0.200
     1.608     8.118     0.200
     1.495     7.535     0.200
     1.906     7.247     0.200
     1.924     8.534     0.200
     1.813     7.824     0.200
     1.865     8.123     0.200
     1.940     8.350     0.200
     1.969    10.010     0.200
     2.371     9.312     0.200
     2.433    10.592     0.200
     2.586    11.802     0.200
     2.730    12.126     0.200
     3.188    12.683     0.200
     4.482    15.682     0.200
     4.777    14.242     0.200
     4.777    15.042     0.200
     4.845    17.447     0.200
     4.845    17.846     0.200
     6.607    21.483     0.200
     6.756    20.138     0.200
     7.750    21.538     0.200
     8.008    23.532     0.200
     8.008    24.232     0.200
     9.834    27.217     0.200
    10.944    29.071     0.200
    20.432    40.544     0.200
     0.610     5.215     0.200
     0.859     6.603     0.200
     1.171     6.562     0.200
     1.358     6.988     0.200
     1.520     8.200     0.200
     1.744     7.980     0.200
     1.801     9.314     0.200
     1.870     8.514     0.200
     1.866     9.560     0.200
     1.920     8.926     0.200
     1.903     8.120     0.200
     2.200    10.460     0.200
     2.319     9.767     0.200
     2.527    10.846     0.200
     2.633    10.599     0.200
     2.741    11.350     0.200
     3.228    11.758     0.200
     3.240    12.525     0.200
     3.279    13.571     0.200
     3.894    15.895     0.200
     3.928    13.497     0.200
     4.315    15.975     0.200
     4.484    16.008     0.200
     5.406    17.744     0.200
     5.679    18.459     0.200
     6.308    16.423     0.200
     6.593    20.698     0.200
     6.748    18.587     0.200
     7.275    20.436     0.200
     8.403    25.974     0.200
     9.148    25.573     0.200
    10.884    29.912     0.200
     1.371     6.456     0.200
     1.510     7.234     0.200
     1.474     7.558     0.200
     1.634     7.888     0.200
     1.791     7.860     0.200
     1.865     7.393     0.200
     1.949     7.213     0.200
     1.962     9.066     0.200
     2.178    10.546     0.200
     2.387     9.110     0.200
     2.409     9.844     0.200
     2.575     9.915     0.200
     2.728    11.123     0.200
     3.177    12.080     0.200
     3.186    12.779     0.200
     3.254    13.491     0.200
     3.421    12.940     0.200
     3.884    13.637     0.200
     4.304    14.732     0.200
     4.482    15.659     0.200
     5.382    17.353     0.200
     6.024    17.661     0.200
     6.030    15.589     0.200
     6.266    15.836     0.200
     6.276    16.217     0.200
     6.611    20.210     0.200
     6.736    18.348     0.200
     6.746    21.241     0.200
     6.755    18.129     0.200
     7.072    20.331     0.200
     7.235    19.523     0.200
     7.256    19.584     0.200
     7.746    20.563     0.200
     8.448    26.378     0.200
    10.960    30.163     0.200
     0.664     5.474     0.200
     0.962     6.596     0.200
     1.237     6.681     0.200
     1.306     7.275     0.200
     1.631     8.091     0.200
     1.763     7.741     0.200
     1.758     8.299     0.200
     1.979     9.030     0.200
     1.976     9.064     0.200
     2.225    10.159     0.200
     2.520     9.915     0.200
     2.629    11.442     0.200
     3.114    11.774     0.200
     3.166    14.977     0.200
     3.292    13.101     0.200
     4.373    16.081     0.200
     6.486    20.427     0.200
     0.870     6.028     0.200
     1.226     6.171     0.200
     1.381     7.665     0.200
     1.563     7.841     0.200
     1.792     7.866     0.200
     1.852     9.066     0.200
     1.847     8.324     0.200
     1.905     8.946     0.200
     1.915     8.328     0.200
     1.890     8.624     0.200
     2.212    10.868     0.200
     2.316     9.652     0.200
     2.512    10.363     0.200
     2.599    10.349     0.200
     2.717    10.975     0.200
     3.196    12.583     0.200
     3.252    13.428     0.200
     3.383    13.297     0.200
     3.897    15.203     0.200
     4.292    16.590     0.200
     4.463    16.597     0.200
     5.380    17.894     0.200
     6.271    16.495     0.200
     6.280    16.493     0.200
     6.577    20.525     0.200
     6.705    21.632     0.200
     6.725    18.597     0.200
     6.740    19.025     0.200
     7.626    22.686     0.200
     8.394    27.717     0.200
     9.139    26.024     0.200
     9.721    29.236     0.200
    11.016    30.923     0.200
     0.507     4.902     0.200
     0.823     6.124     0.200
     1.283     6.349     0.200
     1.567     7.938     0.200
     1.499     7.635     0.200
     1.867     7.233     0.200
     1.878     9.204     0.200
     1.901     9.233     0.200
     1.818     7.910     0.200
     1.885     8.023     0.200
     1.975     8.979     0.200
     2.164     9.773     0.200
     2.376    10.290     0.200
     2.439     9.559     0.200
     2.617    10.479     0.200
     2.752    10.903     0.200
     2.977    12.282     0.200
     3.149    15.067     0.200
     3.217    12.476     0.200
     3.227    12.363     0.200
     3.283    13.708     0.200
     3.431    12.885     0.200
     3.487    12.126     0.200
     3.921    14.263     0.200
     4.328    16.510     0.200
     4.502    16.481     0.200
     4.841    17.527     0.200
     5.412    17.867     0.200
     5.705    18.444     0.200
     6.066    17.231     0.200
     6.300    16.506     0.200
     6.309    16.997     0.200
     6.433    20.953     0.200
     6.623    20.931     0.200
     6.630    18.755     0.200
     6.754    22.101     0.200
     6.761    19.018     0.200
     6.778    19.925     0.200
     7.099    20.878     0.200
     7.272    21.056     0.200
     7.284    20.621     0.200
     7.356    23.185     0.200
     7.669    23.523     0.200
     7.678    21.718     0.200
     7.974    23.364     0.200
     8.449    26.426     0.200
     9.193    26.742     0.200
    10.029    27.987     0.200
    11.021    28.205     0.200
    10.948    30.467     0.200
    12.689    30.943     0.200
     0.204     4.792     0.200
     0.607     5.085     0.200
     0.896     6.010     0.200
     1.228     5.337     0.200
     1.359     7.007     0.200
     1.582     7.111     0.200
     1.595     7.652     0.200
     1.783     7.160     0.200
     1.926     7.493     0.200
     1.822     7.711     0.200
     1.889     8.425     0.200
     1.915     7.726     0.200
     2.238     8.850     0.200
     2.290     8.249     0.200
     2.537     9.866     0.200
     2.576     9.904     0.200
     2.692    11.160     0.200
     3.068    11.161     0.200
     3.068    11.559     0.200
     3.173    10.945     0.200
     3.227    13.807     0.200
     3.357    12.791     0.200
     3.584    11.146     0.200
     3.584    11.943     0.200
     3.873    13.770     0.200
     4.267    15.175     0.200
     4.437    15.185     0.200
     4.931    16.820     0.200
     6.247    16.070     0.200
     6.256    14.967     0.200
     6.551    19.619     0.200
     6.679    20.029     0.200
     6.700    17.488     0.200
     7.225    17.854     0.200
     7.600    22.279     0.200
     7.882    23.984     0.200
     8.368    26.315     0.200
     0.609     5.166     0.200
     1.279     5.947     0.200
     1.365     7.044     0.200
     1.635     7.591     0.200
     1.606     7.931     0.200
     1.819     7.436     0.200
     1.782     7.366     0.200
     1.865     8.199     0.200
     1.977     8.593     0.200
     1.924     7.913     0.200
     2.267     9.210     0.200
     2.270    10.173     0.200
     2.528     9.162     0.200
     2.545     9.973     0.200
     2.651    10.728     0.200
     3.041    13.179     0.200
     3.126    11.189     0.200
     3.136    12.067     0.200
     3.185    12.702     0.200
     3.817    15.529     0.200
     3.828    14.000     0.200
     4.227    15.339     0.200
     4.399    15.329     0.200
     4.950    17.398     0.200
     5.313    16.664     0.200
     5.600    18.316     0.200
     5.954    17.188     0.200
     6.203    16.178     0.200
     6.212    16.072     0.200
     6.517    20.012     0.200
     6.647    21.000     0.200
     6.660    18.248     0.200
     6.676    18.765     0.200
     6.999    18.989     0.200
     7.184    19.330     0.200
     7.564    21.394     0.200
     7.675    19.101     0.200
     7.910    23.356     0.200
     7.910    23.656     0.200
     8.340    24.339     0.200
     9.746    25.932     0.200
    10.838    28.983     0.200
    12.666    29.856     0.200
    12.666    30.757     0.200
     1.246     6.720     0.200
     1.400     7.825     0.200
     1.571     8.429     0.200
     1.555     8.612     0.200
     1.814     8.586     0.200
     1.865     9.089     0.200
     1.850     9.164     0.200
     1.911     9.456     0.200
     1.926     9.285     0.200
     1.874     7.883     0.200
     2.205    11.027     0.200
     2.327     9.604     0.200
     2.496    11.626     0.200
     2.597    10.455     0.200
     2.719    11.022     0.200
     3.105    14.523     0.200
     3.194    12.479     0.200
     3.205    13.357     0.200
     3.253    13.691     0.200
     3.883    16.445     0.200
     3.896    13.288     0.200
     4.295    16.634     0.200
     4.467    16.630     0.200
     4.893    17.658     0.200
     5.382    17.954     0.200
     5.667    18.627     0.200
     6.272    16.566     0.200
     6.281    17.160     0.200
     6.583    20.730     0.200
     6.712    21.629     0.200
     6.743    19.063     0.200
     7.631    23.704     0.200
     7.743    21.392     0.200
     8.403    24.693     0.200
     9.743    28.057     0.200
    12.633    31.329     0.200
    20.366    41.790     0.200
     0.669     5.484     0.200
     0.937     6.858     0.200
     1.186     6.849     0.200
     1.582     8.933     0.200
     1.652     8.211     0.200
     1.724     8.570     0.200
     1.847     9.836     0.200
     1.793     8.261     0.200
     1.843     9.185     0.200
     1.932     9.947     0.200
     1.972     8.476     0.200
     2.278    10.812     0.200
     2.242    10.223     0.200
     2.595    11.210     0.200
     2.564    11.374     0.200
     2.665    11.394     0.200
     3.030    14.133     0.200
     3.157    12.347     0.200
     3.169    12.413     0.200
     3.204    13.404     0.200
     3.321    12.741     0.200
     3.641    11.999     0.200
     3.641    12.300     0.200
     3.816    15.960     0.200
     3.855    14.503     0.200
     4.239    16.023     0.200
     4.407    16.064     0.200
     4.771    17.010     0.200
     4.982    18.848     0.200
     5.331    17.280     0.200
     6.225    16.649     0.200
     6.233    16.652     0.200
     6.515    21.063     0.200
     6.640    22.102     0.200
     6.685    19.482     0.200
     7.013    20.844     0.200
     7.199    19.480     0.200
     7.203    19.937     0.200
     7.566    22.200     0.200
     7.820    24.437     0.200
     8.325    26.439     0.200
     8.680    25.202     0.200
     8.680    26.003     0.200
     9.652    27.858     0.200
     9.890    29.073     0.200
    10.809    30.154     0.200
    12.537    28.182     0.200
    12.687    30.435     0.200
     0.230     7.159     0.200
     0.324     6.262     0.200
     0.761     5.365     0.200
     1.497     7.580     0.200
     1.657     5.905     0.200
     1.726     7.507     0.200
     1.865     8.879     0.200
     2.009     7.498     0.200
     2.070    10.892     0.200
     2.292     8.804     0.200
     2.671    10.873     0.200
     3.293    11.615     0.200
     3.411    13.242     0.200
     3.645    12.910     0.200
     4.806    14.358     0.200
     5.890    17.513     0.200
     6.820    19.660     0.200
     7.848    23.461     0.200
     8.690    24.634     0.200
     0.769     6.164     0.200
     1.234     6.631     0.200
     1.499     8.141     0.200
     1.473     7.743     0.200
     1.470     8.479     0.200
     1.841     8.153     0.200
     1.833     9.239     0.200
     1.943     8.855     0.200
     2.419    11.401     0.200
     2.683    12.326     0.200
     3.282    13.333     0.200
     3.345    14.602     0.200
     4.560    16.717     0.200
     4.802    17.595     0.200
     4.802    17.894     0.200
     6.362    17.388     0.200
     6.678    21.408     0.200
     0.733     5.851     0.200
     1.258     6.020     0.200
     1.490     7.213     0.200
     1.426     7.872     0.200
     1.518     6.886     0.200
     1.820     9.171     0.200
     1.746     8.034     0.200
     1.878     7.495     0.200
     1.976     8.550     0.200
     2.074    11.198     0.200
     2.460    10.297     0.200
     3.307    12.819     0.200
     3.520    14.028     0.200
     4.593    16.809     0.200
     6.390    16.837     0.200
     6.713    21.066     0.200
     6.843    23.549     0.200
     6.868    21.252     0.200
     7.759    23.856     0.200
     0.465     5.005     0.200
     0.851     6.198     0.200
     1.393     6.671     0.200
     1.470     7.972     0.200
     1.522     5.669     0.200
     1.787     7.981     0.200
     1.859     8.034     0.200
     1.969     8.952     0.200
     1.979     9.838     0.200
     1.978     9.744     0.200
     2.183     9.751     0.200
     2.388     9.064     0.200
     2.404    10.578     0.200
     2.563    10.122     0.200
     2.721    11.277     0.200
     2.961    12.373     0.200
     3.144    14.236     0.200
     3.166    11.780     0.200
     3.175    11.882     0.200
     3.245    12.361     0.200
     3.417    12.956     0.200
     3.873    12.630     0.200
     4.127    14.766     0.200
     4.297    15.288     0.200
     4.475    15.405     0.200
     4.715    15.906     0.200
     4.813    15.767     0.200
     4.828    16.592     0.200
     4.828    17.092     0.200
     5.374    17.921     0.200
     5.373    16.527     0.200
     5.684    17.894     0.200
     6.015    17.732     0.200
     6.020    17.679     0.200
     6.256    16.020     0.200
     6.267    15.799     0.200
     6.404    19.192     0.200
     6.545    21.556     0.200
     6.577    18.183     0.200
     6.606    20.135     0.200
     6.729    18.207     0.200
     6.742    20.953     0.200
     6.748    18.682     0.200
     6.955    22.667     0.200
     7.064    17.899     0.200
     7.225    19.616     0.200
     7.248    19.851     0.200
     7.318    24.530     0.200
     7.345    23.210     0.200
     7.641    19.756     0.200
     7.648    21.685     0.200
     7.738    19.633     0.200
     7.923    24.470     0.200
     8.325    24.774     0.200
     8.446    25.470     0.200
     8.726    25.104     0.200
     8.726    25.504     0.200
     9.188    25.704     0.200
     9.898    27.426     0.200
    10.643    27.728     0.200
    10.961    29.615     0.200
    11.417    31.590     0.200
    12.555    31.409     0.200
    12.555    32.110     0.200
    12.786    32.124     0.200
    14.480    33.449     0.200
    15.247    35.004     0.200
     0.851     6.207     0.200
     1.557     5.566     0.200
     1.763     8.260     0.200
     2.010     8.673     0.200
     1.866     7.855     0.200
     2.408     8.836     0.200
     2.558     9.782     0.200
     2.725    11.430     0.200
     3.162    11.727     0.200
     3.246    14.047     0.200
     3.428    13.434     0.200
     3.914    16.256     0.200
     4.481    15.643     0.200
     5.692    18.507     0.200
     6.615    20.332     0.200
     6.753    22.129     0.200
     7.655    22.603     0.200
     0.726     5.606     0.200
     1.268     5.882     0.200
     1.530     5.719     0.200
     1.491     7.474     0.200
     1.414     7.771     0.200
     1.889     7.732     0.200
     1.734     7.536     0.200
     1.819     8.445     0.200
     1.982     8.347     0.200
     2.067     9.457     0.200
     2.470     9.355     0.200
     2.357    10.372     0.200
     2.709    10.262     0.200
     3.310    13.044     0.200
     3.320    12.337     0.200
     4.015    14.922     0.200
     4.599    16.105     0.200
     5.507    17.505     0.200
     5.802    18.066     0.200
     6.395    16.754     0.200
     6.404    16.841     0.200
     6.720    20.351     0.200
     6.851    21.529     0.200
     6.858    18.748     0.200
     6.875    19.551     0.200
     7.195    21.108     0.200
     7.766    22.146     0.200
     7.774    21.454     0.200
     7.871    20.529     0.200
     8.544    26.065     0.200
     0.368     6.028     0.200
     0.746     5.419     0.200
     1.148     6.932     0.200
     1.453     7.377     0.200
     1.685     6.457     0.200
     1.727     7.176     0.200
     1.911     8.022     0.200
     2.004     7.548     0.200
     2.110     9.306     0.200
     2.329     7.650     0.200
     2.716    10.425     0.200
     2.947    10.939     0.200
     3.325    11.428     0.200
     3.686    13.316     0.200
     4.513    15.664     0.200
     4.704    15.431     0.200
     5.928    17.146     0.200
     6.430    16.292     0.200
     6.443    15.639     0.200
     6.859    19.684     0.200
     6.936    18.584     0.200
     6.964    19.062     0.200
     7.261    19.891     0.200
     7.443    19.269     0.200
     7.886    23.301     0.200
     7.930    19.787     0.200
     8.732    23.428     0.200
     0.070     8.016     0.200
     0.367     6.447     0.200
     0.770     6.045     0.200
     1.420     5.861     0.200
     1.373     7.216     0.200
     1.614     7.301     0.200
     1.613     6.914     0.200
     1.689     7.423     0.200
     1.930     7.814     0.200
     2.027     7.472     0.200
     1.948     8.399     0.200
     2.095     8.679     0.200
     2.082     8.839     0.200
     2.306     8.319     0.200
     2.637     9.364     0.200
     2.807    11.374     0.200
     3.242    11.200     0.200
     3.249    12.213     0.200
     3.328    13.998     0.200
     3.356     9.963     0.200
     3.356    10.763     0.200
     3.509    12.181     0.200
     3.950    12.033     0.200
     4.382    14.992     0.200
     4.563    14.887     0.200
     4.758    13.605     0.200
     4.758    14.503     0.200
     4.731    15.926     0.200
     4.731    16.226     0.200
     6.098    17.475     0.200
     6.336    15.496     0.200
     6.346    15.570     0.200
     6.697    16.976     0.200
     6.834    18.080     0.200
     7.147    18.230     0.200
     7.302    20.420     0.200
     7.737    22.647     0.200
     7.820    18.172     0.200
     9.956    24.243     0.200
    12.460    30.722     0.200
    12.460    31.620     0.200
    12.852    30.155     0.200
     0.222     4.648     0.200
     0.623     4.764     0.200
     0.904     6.283     0.200
     1.214     6.069     0.200
     1.343     6.064     0.200
     1.578     7.622     0.200
     1.766     7.431     0.200
     1.817     7.331     0.200
     1.879    10.109     0.200
     1.924     8.086     0.200
     1.929     7.328     0.200
     2.246     9.527     0.200
     2.279     9.438     0.200
     2.551    10.167     0.200
     2.576     9.671     0.200
     2.687     9.673     0.200
     3.172    11.621     0.200
     3.183    11.892     0.200
     3.224    13.409     0.200
     3.350    12.640     0.200
     3.598    12.050     0.200
     4.432    15.112     0.200
     4.764    15.445     0.200
     4.764    15.545     0.200
     4.943    17.552     0.200
     6.244    15.167     0.200
     6.253    15.466     0.200
     6.544    19.965     0.200
     6.671    21.184     0.200
     6.709    18.736     0.200
     7.036    20.725     0.200
     8.359    25.487     0.200
    18.583    37.174     0.200
    19.246    37.438     0.200
     0.053     8.163     0.200
     0.387     6.064     0.200
     0.796     5.596     0.200
     1.429     5.203     0.200
     1.393     6.822     0.200
     1.636     6.490     0.200
     1.600     6.712     0.200
     1.709     7.039     0.200
     1.982     7.450     0.200
     2.028     6.917     0.200
     1.923     8.537     0.200
     2.121     8.234     0.200
     2.060     9.041     0.200
     2.326     7.941     0.200
     2.463     9.931     0.200
     2.611    10.011     0.200
     2.782    11.016     0.200
     3.215    13.056     0.200
     3.216    11.048     0.200
     3.224    12.260     0.200
     3.302    13.844     0.200
     3.376    10.184     0.200
     3.376    10.383     0.200
     3.485    12.712     0.200
     3.925    13.779     0.200
     3.971    14.635     0.200
     4.357    14.735     0.200
     4.538    14.827     0.200
     4.753    15.916     0.200
     4.772    15.893     0.200
     5.445    17.234     0.200
     5.430    16.218     0.200
     5.431    15.199     0.200
     5.749    17.287     0.200
     6.072    16.721     0.200
     6.310    15.641     0.200
     6.321    15.515     0.200
     6.466    20.124     0.200
     6.618    20.445     0.200
     6.624    17.277     0.200
     6.673    19.410     0.200
     6.810    20.306     0.200
     6.788    17.562     0.200
     6.809    17.822     0.200
     6.909    20.957     0.200
     7.121    19.474     0.200
     7.276    18.766     0.200
     7.305    18.829     0.200
     7.390    21.340     0.200
     7.414    21.755     0.200
     7.712    20.984     0.200
     7.699    19.037     0.200
     7.795    18.616     0.200
     8.134    20.655     0.200
     7.984    22.411     0.200
     8.263    22.851     0.200
     8.517    24.189     0.200
     8.700    23.045     0.200
     9.138    22.936     0.200
     9.259    23.429     0.200
     9.361    23.338     0.200
     9.957    25.385     0.200
    10.117    25.810     0.200
    10.153    29.092     0.200
    10.715    26.133     0.200
    11.037    27.882     0.200
    11.131    31.281     0.200
    12.237    29.679     0.200
    12.483    27.898     0.200
    12.483    28.798     0.200
    12.849    29.226     0.200
    14.553    31.941     0.200
     1.365     7.124     0.200
     1.570     8.522     0.200
     1.579     7.321     0.200
     1.707     7.832     0.200
     1.891     9.582     0.200
     1.976     8.892     0.200
     1.956     9.021     0.200
     2.087     9.697     0.200
     2.326     9.399     0.200
     2.476    10.659     0.200
     2.660    11.111     0.200
     2.819    11.656     0.200
     3.263    12.965     0.200
     3.343    14.339     0.200
     3.512    13.863     0.200
     3.971    14.113     0.200
     4.394    17.167     0.200
     4.573    17.188     0.200
     4.740    17.134     0.200
     5.471    18.604     0.200
     5.781    18.986     0.200
     6.354    17.698     0.200
     6.364    17.677     0.200
     6.702    22.233     0.200
     6.826    20.285     0.200
     6.837    21.662     0.200
     6.846    20.761     0.200
     7.161    19.876     0.200
     7.744    25.075     0.200
     8.539    28.804     0.200
     9.904    30.465     0.200
    11.048    31.613     0.200
     0.157     8.923     0.200
     0.280     8.686     0.200
     0.617     5.964     0.200
     1.162     7.294     0.200
     1.503     6.116     0.200
     1.554     6.317     0.200
     1.478     7.106     0.200
     1.812     8.211     0.200
     1.912     7.942     0.200
     1.953     7.262     0.200
     2.096     8.097     0.200
     2.167     7.868     0.200
     2.139     9.694     0.200
     2.290    10.331     0.200
     2.656     9.862     0.200
     2.694    10.621     0.200
     2.796    10.030     0.200
     2.992    11.444     0.200
     3.146    11.043     0.200
     3.404    11.732     0.200
     3.441    13.197     0.200
     3.410    11.664     0.200
     3.505    13.155     0.200
     3.706    13.003     0.200
     4.115    12.932     0.200
     4.190    15.055     0.200
     4.523    15.276     0.200
     4.651    13.584     0.200
     4.565    15.088     0.200
     4.749    15.135     0.200
     5.618    15.496     0.200
     5.630    16.963     0.200
     5.672    17.171     0.200
     5.965    17.545     0.200
     6.263    16.973     0.200
     6.273    17.050     0.200
     6.504    16.050     0.200
     6.516    15.815     0.200
     6.676    19.155     0.200
     6.847    18.852     0.200
     6.805    18.644     0.200
     6.891    19.539     0.200
     6.994    18.338     0.200
     7.031    20.201     0.200
     7.017    17.972     0.200
     7.324    19.390     0.200
     7.465    19.838     0.200
     7.637    21.937     0.200
     7.900    18.864     0.200
     7.927    21.454     0.200
     7.996    18.851     0.200
     8.485    25.144     0.200
     8.743    25.033     0.200
    10.090    24.813     0.200
    11.267    27.472     0.200
    12.257    26.720     0.200
    12.999    28.156     0.200
    14.782    31.755     0.200
     0.519     5.026     0.200
     0.833     5.960     0.200
     1.279     6.257     0.200
     1.448     6.285     0.200
     1.572     8.041     0.200
     1.511     8.555     0.200
     1.859     8.486     0.200
     1.907     9.030     0.200
     1.830     8.830     0.200
     1.875     7.599     0.200
     1.963     8.375     0.200
     2.174     9.708     0.200
     2.365     9.386     0.200
     2.451    10.580     0.200
     2.610     9.729     0.200
     2.743    10.475     0.200
     3.209    11.832     0.200
     3.219    11.616     0.200
     3.274    14.174     0.200
     3.420    13.271     0.200
     3.912    15.530     0.200
     3.913    14.521     0.200
     4.319    15.783     0.200
     4.492    15.756     0.200
     4.745    16.804     0.200
     4.853    17.051     0.200
     5.403    17.134     0.200
     5.695    17.724     0.200
     6.291    16.769     0.200
     6.613    20.210     0.200
     6.743    21.488     0.200
     6.768    19.199     0.200
     7.659    22.803     0.200
     7.765    20.562     0.200
     8.438    26.716     0.200
     0.461     7.170     0.200
     0.257     9.358     0.200
     0.693     8.663     0.200
     0.750     6.903     0.200
     1.066     6.718     0.200
     1.510     6.827     0.200
     1.568     7.052     0.200
     1.724     7.626     0.200
     1.685     7.193     0.200
     1.991     8.220     0.200
     2.207     9.693     0.200
     2.248     9.117     0.200
     2.466     9.679     0.200
     2.526    10.179     0.200
     2.734     9.751     0.200
     2.701    10.934     0.200
     3.187    11.263     0.200
     3.105    11.425     0.200
     3.131    10.519     0.200
     3.366    11.873     0.200
     3.741    12.098     0.200
     3.744    12.164     0.200
     3.843    14.310     0.200
     3.866    13.634     0.200
     4.115    13.931     0.200
     4.115    13.829     0.200
     4.100    13.509     0.200
     4.455    12.672     0.200
     4.454    14.573     0.200
     4.579    15.521     0.200
     4.731    16.239     0.200
     4.933    15.287     0.200
     5.124    15.557     0.200
     5.329    17.269     0.200
     5.948    15.339     0.200
     5.983    17.136     0.200
     6.073    17.580     0.200
     6.347    17.784     0.200
     6.626    17.334     0.200
     6.599    17.448     0.200
     6.627    17.513     0.200
     6.860    16.297     0.200
     7.045    20.237     0.200
     7.123    17.729     0.200
     7.156    20.947     0.200
     7.254    20.804     0.200
     7.277    19.638     0.200
     7.356    18.608     0.200
     7.423    20.729     0.200
     7.680    20.032     0.200
     7.714    23.430     0.200
     7.797    20.262     0.200
     7.862    19.608     0.200
     8.019    22.874     0.200
     8.030    21.743     0.200
     8.353    21.076     0.200
     8.145    20.694     0.200
     8.254    21.131     0.200
     8.305    22.135     0.200
     8.600    23.096     0.200
     8.557    21.591     0.200
     8.876    23.865     0.200
     9.142    24.763     0.200
     9.279    24.171     0.200
     9.442    24.269     0.200
     9.713    23.099     0.200
     9.882    24.130     0.200
     9.937    22.983     0.200
    10.093    27.672     0.200
    10.352    24.642     0.200
    10.244    23.903     0.200
    10.794    26.186     0.200
    10.758    26.613     0.200
    11.345    26.157     0.200
    11.677    27.683     0.200
    11.857    24.685     0.200
    13.289    28.170     0.200
    15.187    31.222     0.200
     0.600     5.041     0.200
     0.833     6.713     0.200
     1.372     6.732     0.200
     1.565     7.974     0.200
     1.739     8.351     0.200
     1.835     8.723     0.200
     1.886     7.832     0.200
     1.899     7.377     0.200
     1.945     8.837     0.200
     2.173    10.180     0.200
     2.344     9.583     0.200
     2.510     9.753     0.200
     2.664    10.450     0.200
     2.770    11.210     0.200
     3.259    11.508     0.200
     3.270    12.377     0.200
     3.426    12.555     0.200
     3.922    15.471     0.200
     4.513    15.476     0.200
     5.707    16.936     0.200
     6.329    16.178     0.200
     6.621    20.277     0.200
     6.745    20.821     0.200
     6.791    18.192     0.200
     7.672    22.112     0.200
     8.429    25.977     0.200
     0.193     7.264     0.200
     0.306     7.051     0.200
     0.715     5.572     0.200
     1.176     6.794     0.200
     1.485     6.984     0.200
     1.614     6.684     0.200
     1.675     6.970     0.200
     1.959     7.452     0.200
     1.852     8.401     0.200
     1.979     8.420     0.200
     2.076     8.084     0.200
     2.095     7.868     0.200
     2.093     9.293     0.200
     2.257     8.275     0.200
     2.277     9.744     0.200
     2.679    10.254     0.200
     2.681    10.730     0.200
     2.719     9.783     0.200
     2.936    11.352     0.200
     3.146    11.102     0.200
     3.328    11.373     0.200
     3.333    11.522     0.200
     3.666    12.932     0.200
     4.041    12.658     0.200
     4.545    15.272     0.200
     4.759    14.682     0.200
     4.694    15.037     0.200
     4.907    16.054     0.200
     5.540    15.462     0.200
     5.562    16.604     0.200
     5.640    17.391     0.200
     5.915    17.486     0.200
     6.188    17.107     0.200
     6.206    16.888     0.200
     6.432    15.954     0.200
     6.445    15.710     0.200
     6.617    18.692     0.200
     6.723    16.859     0.200
     6.732    20.753     0.200
     6.919    18.573     0.200
     6.823    20.689     0.200
     6.844    19.447     0.200
     6.932    17.726     0.200
     6.957    18.228     0.200
     6.989    20.252     0.200
     7.258    18.511     0.200
     7.389    18.991     0.200
     7.596    21.666     0.200
     7.874    21.821     0.200
     7.928    18.791     0.200
     8.375    21.580     0.200
     8.709    24.381     0.200
     9.959    25.093     0.200
    10.184    25.668     0.200
    10.331    27.752     0.200
    10.913    26.665     0.200
    11.250    28.325     0.200
    12.290    26.788     0.200
    12.457    30.239     0.200
    13.086    29.599     0.200
    14.586    31.896     0.200
    14.724    30.285     0.200
    14.755    32.019     0.200
    14.994    32.338     0.200
     0.569     4.838     0.200
     1.076     6.517     0.200
     1.392     7.333     0.200
     1.550     6.889     0.200
     1.543     6.665     0.200
     1.819     7.441     0.200
     1.841     8.987     0.200
     1.897     8.035     0.200
     1.961     8.586     0.200
     2.009     9.627     0.200
     2.232     8.723     0.200
     2.217     9.497     0.200
     2.780    10.834     0.200
     2.861    10.991     0.200
     3.067    12.283     0.200
     3.469    12.387     0.200
     3.787    13.683     0.200
     4.181    14.375     0.200
     4.825    16.171     0.200
     5.700    17.459     0.200
     6.584    16.738     0.200
     6.969    21.740     0.200
     7.066    19.410     0.200
     7.577    19.244     0.200
    20.441    43.029     0.200
     0.062     6.945     0.200
     0.392     5.390     0.200
     0.525     4.840     0.200
     1.050     6.614     0.200
     1.368     6.812     0.200
     1.504     6.623     0.200
     1.531     6.105     0.200
     1.778     7.027     0.200
     1.802     8.147     0.200
     1.927     8.086     0.200
     1.910     7.982     0.200
     1.987     8.184     0.200
     2.224     8.013     0.200
     2.253     9.574     0.200
     2.808    10.803     0.200
     2.902    10.509     0.200
     3.104    11.443     0.200
     3.510    11.708     0.200
     3.516    11.845     0.200
     3.821    13.177     0.200
     4.862    15.131     0.200
     7.005    20.120     0.200
     0.225     7.057     0.200
     0.279     6.936     0.200
     0.741     5.642     0.200
     1.210     6.960     0.200
     1.520     7.055     0.200
     1.607     6.436     0.200
     1.690     7.070     0.200
     1.619     6.792     0.200
     1.824     8.008     0.200
     1.978     7.601     0.200
     2.012     8.713     0.200
     2.084     7.862     0.200
     2.129     7.944     0.200
     2.058     9.065     0.200
     2.241     8.036     0.200
     2.243    10.015     0.200
     2.713    10.318     0.200
     2.647    10.600     0.200
     2.688    10.222     0.200
     2.902    11.216     0.200
     3.180     9.976     0.200
     3.409    11.905     0.200
     3.297    11.615     0.200
     3.301    11.363     0.200
     3.376    13.294     0.200
     3.408    13.516     0.200
     3.631    12.707     0.200
     4.009    13.300     0.200
     4.111    15.313     0.200
     4.472    14.899     0.200
     4.782    14.883     0.200
     4.660    14.803     0.200
     5.301    17.830     0.200
     5.509    16.398     0.200
     5.529    16.658     0.200
     5.606    16.972     0.200
     5.881    17.260     0.200
     6.156    17.450     0.200
     6.400    16.298     0.200
     6.699    19.808     0.200
     6.692    17.791     0.200
     6.941    19.086     0.200
     6.789    20.363     0.200
     6.810    19.117     0.200
     6.898    18.083     0.200
     6.924    18.185     0.200
     6.955    20.627     0.200
     7.225    18.868     0.200
     7.357    20.433     0.200
     7.408    18.239     0.200
     7.562    22.338     0.200
     7.840    21.691     0.200
     7.865    21.000     0.200
     7.896    19.247     0.200
     8.098    21.983     0.200
     8.355    20.179     0.200
     8.693    24.244     0.200
     8.674    24.661     0.200
     9.446    21.347     0.200
    10.169    25.120     0.200
    11.216    27.001     0.200
    12.325    28.856     0.200
    13.068    29.385     0.200
    14.564    32.325     0.200
    14.702    30.715     0.200
    16.681    34.118     0.200
     0.598     5.005     0.200
     0.922     7.324     0.200
     1.286     6.680     0.200
     1.376     6.433     0.200
     1.596     8.463     0.200
     1.829     7.636     0.200
     1.788     8.320     0.200
     1.874     9.418     0.200
     1.914     7.846     0.200
     1.976     9.722     0.200
     2.264     9.869     0.200
     2.276     9.628     0.200
     2.535    11.008     0.200
     2.531     9.349     0.200
     2.656    11.486     0.200
     3.129    11.370     0.200
     3.139    12.850     0.200
     3.331    13.016     0.200
     4.405    16.081     0.200
     6.524    21.553     0.200
     0.656     5.038     0.200
     0.906     6.012     0.200
     1.078     4.004     0.200
     1.162     5.026     0.200
     1.311     5.487     0.200
     1.545     7.656     0.200
     1.715     5.875     0.200
     1.631     8.049     0.200
     1.813     8.224     0.200
     1.895     8.573     0.200
     1.829     8.043     0.200
     1.952     7.610     0.200
     2.246     9.979     0.200
     2.272     9.378     0.200
     2.575    10.138     0.200
     2.601    10.134     0.200
     2.700    10.970     0.200
     3.194    11.914     0.200
     3.206    11.875     0.200
     3.354    12.645     0.200
     4.442    15.051     0.200
     5.367    16.954     0.200
     6.269    16.422     0.200
     6.548    18.168     0.200
     7.656    23.044     0.200
     0.223     7.172     0.200
     0.294     6.847     0.200
     0.744     5.590     0.200
     1.202     7.149     0.200
     1.510     7.355     0.200
     1.622     6.247     0.200
     1.699     6.951     0.200
     1.838     8.029     0.200
     1.985     7.605     0.200
     2.009     8.829     0.200
     2.096     6.917     0.200
     2.064     8.986     0.200
     2.118     8.552     0.200
     2.257     7.837     0.200
     2.253     9.790     0.200
     2.656    10.375     0.200
     2.689    10.196     0.200
     2.907    11.051     0.200
     3.298    11.587     0.200
     3.303    11.533     0.200
     3.638    12.316     0.200
     4.011    13.363     0.200
     4.117    13.828     0.200
     4.476    14.640     0.200
     4.572    15.523     0.200
     4.665    15.037     0.200
     5.510    16.570     0.200
     5.532    16.811     0.200
     5.886    17.384     0.200
     6.402    16.062     0.200
     6.415    16.118     0.200
     6.815    19.339     0.200
     6.902    17.931     0.200
     6.928    18.326     0.200
     6.961    20.537     0.200
     7.411    19.188     0.200
     7.804    18.705     0.200
     7.845    21.218     0.200
     7.870    20.436     0.200
     7.899    18.994     0.200
     8.682    24.262     0.200
    10.184    28.225     0.200
    13.084    29.186     0.200
    14.580    32.229     0.200
    14.718    30.619     0.200
     0.141     7.413     0.200
     0.208     6.932     0.200
     0.306     6.784     0.200
     0.732     5.512     0.200
     1.185     6.829     0.200
     1.494     6.930     0.200
     1.625     6.789     0.200
     1.692     7.113     0.200
     1.646     7.354     0.200
     1.852     8.551     0.200
     1.977     7.690     0.200
     1.994     8.393     0.200
     2.093     7.837     0.200
     2.102     8.027     0.200
     2.081     9.077     0.200
     2.265     8.428     0.200
     2.269    10.079     0.200
     2.673    10.766     0.200
     2.704     9.703     0.200
     2.923    11.247     0.200
     3.153    10.261     0.200
     3.410    11.261     0.200
     3.313    11.394     0.200
     3.318    11.340     0.200
     3.400    12.482     0.200
     3.427    13.561     0.200
     3.655    12.808     0.200
     4.026    12.677     0.200
     4.133    14.923     0.200
     4.297    14.911     0.200
     4.555    15.399     0.200
     4.492    14.939     0.200
     4.681    15.331     0.200
     4.893    15.963     0.200
     5.323    16.738     0.200
     5.525    16.684     0.200
     5.548    16.616     0.200
     5.630    17.357     0.200
     5.903    17.477     0.200
     6.172    17.026     0.200
     6.192    16.797     0.200
     6.348    18.782     0.200
     6.417    15.972     0.200
     6.430    15.922     0.200
     6.707    16.887     0.200
     6.718    19.261     0.200
     6.814    20.344     0.200
     6.936    18.912     0.200
     6.832    19.333     0.200
     6.918    18.131     0.200
     6.943    18.329     0.200
     6.978    20.233     0.200
     7.244    18.622     0.200
     7.373    19.411     0.200
     7.426    19.195     0.200
     7.576    21.251     0.200
     7.585    22.343     0.200
     7.649    19.697     0.200
     7.819    18.611     0.200
     7.861    21.514     0.200
     7.885    20.638     0.200
     7.914    18.600     0.200
     8.118    20.827     0.200
     8.431    23.467     0.200
     8.698    23.652     0.200
     8.778    24.222     0.200
     8.838    22.719     0.200
     9.002    23.002     0.200
     9.055    26.289     0.200
     9.273    22.736     0.200
     9.448    28.401     0.200
     9.462    22.539     0.200
     9.497    22.828     0.200
     9.655    25.988     0.200
     9.704    26.614     0.200
     9.916    25.541     0.200
     9.948    24.470     0.200
    10.192    24.514     0.200
    10.187    25.278     0.200
    10.322    26.698     0.200
    10.449    26.515     0.200
    10.513    25.371     0.200
    10.902    26.728     0.200
    11.242    28.068     0.200
    11.418    27.606     0.200
    12.301    27.504     0.200
    12.301    27.805     0.200
    12.450    30.171     0.200
    13.093    28.865     0.200
    13.257    30.955     0.200
    13.752    31.872     0.200
    14.591    31.985     0.200
    14.729    30.375     0.200
    14.745    32.378     0.200
    15.132    32.968     0.200
     0.184     7.421     0.200
     0.349     6.693     0.200
     0.718     5.383     0.200
     1.145     7.102     0.200
     1.452     7.219     0.200
     1.653     6.279     0.200
     1.694     6.698     0.200
     1.895     8.151     0.200
     1.972     7.350     0.200
     1.965     8.439     0.200
     2.103     8.123     0.200
     2.060     8.727     0.200
     2.117     9.158     0.200
     2.301     8.116     0.200
     2.311    10.100     0.200
     2.714    10.490     0.200
     2.732     9.884     0.200
     2.957    11.554     0.200
     3.341    11.572     0.200
     3.346    11.625     0.200
     3.439    12.533     0.200
     3.459    15.696     0.200
     3.692    12.980     0.200
     4.055    13.249     0.200
     4.170    14.704     0.200
     4.525    14.960     0.200
     4.715    15.242     0.200
     5.552    16.374     0.200
     5.578    16.665     0.200
     5.938    17.875     0.200
     6.446    16.239     0.200
     6.868    19.422     0.200
     6.976    18.553     0.200
     7.896    21.818     0.200
     7.918    21.059     0.200
     7.945    18.653     0.200
     8.737    25.508     0.200
     0.232     7.314     0.200
     0.263     6.953     0.200
     0.742     5.674     0.200
     1.222     7.569     0.200
     1.593     5.131     0.200
     1.532     7.352     0.200
     1.684     6.574     0.200
     1.808     7.421     0.200
     2.017     8.879     0.200
     2.076     8.698     0.200
     2.049     9.209     0.200
     2.226     7.447     0.200
     2.142     8.733     0.200
     2.683     9.817     0.200
     2.895    11.049     0.200
     3.292    11.415     0.200
     3.297    11.551     0.200
     3.622    12.654     0.200
     4.004    13.102     0.200
     4.465    14.820     0.200
     4.652    15.035     0.200
     5.523    16.668     0.200
     6.407    15.959     0.200
     6.801    19.258     0.200
     6.891    19.100     0.200
     6.916    18.409     0.200
     7.401    18.250     0.200
     7.794    19.867     0.200
     7.832    22.324     0.200
     7.858    22.522     0.200
     8.664    24.115     0.200
     0.248     7.181     0.200
     0.215     7.462     0.200
     0.731     6.144     0.200
     1.250     7.186     0.200
     1.543     6.572     0.200
     1.552     6.663     0.200
     1.562     7.342     0.200
     1.653     7.390     0.200
     1.762     8.312     0.200
     1.949     8.026     0.200
     2.036     8.215     0.200
     2.024     8.757     0.200
     2.033     9.048     0.200
     2.173     8.116     0.200
     2.175     8.087     0.200
     2.200     8.395     0.200
     2.604    10.580     0.200
     2.750    10.484     0.200
     2.682     9.976     0.200
     2.883    11.037     0.200
     3.226    10.424     0.200
     3.290    11.282     0.200
     3.296    11.414     0.200
     3.342    13.371     0.200
     3.393    14.473     0.200
     3.603    12.828     0.200
     4.002    12.877     0.200
     4.085    15.202     0.200
     4.454    14.790     0.200
     4.617    15.395     0.200
     4.762    14.507     0.200
     4.640    14.822     0.200
     5.504    15.447     0.200
     5.517    16.587     0.200
     5.573    17.144     0.200
     5.858    17.312     0.200
     6.149    16.716     0.200
     6.161    16.977     0.200
     6.391    15.991     0.200
     6.403    16.454     0.200
     6.690    17.697     0.200
     6.752    18.679     0.200
     6.785    19.092     0.200
     6.917    18.746     0.200
     6.883    17.951     0.200
     6.907    18.373     0.200
     6.927    20.231     0.200
     7.212    19.013     0.200
     7.351    20.286     0.200
     7.395    18.277     0.200
     7.534    21.556     0.200
     7.788    17.990     0.200
     7.819    21.932     0.200
     7.848    20.389     0.200
     7.883    18.876     0.200
     8.381    23.468     0.200
     8.642    24.416     0.200
     9.383    23.575     0.200
     9.896    24.387     0.200
    10.101    25.800     0.200
    10.257    27.079     0.200
    10.844    26.022     0.200
    11.076    27.118     0.200
    11.176    28.254     0.200
    12.357    27.373     0.200
    12.380    29.898     0.200
    13.000    29.364     0.200
    14.497    32.497     0.200
    14.635    30.887     0.200
    16.617    32.657     0.200
     0.207     7.418     0.200
     0.305     6.973     0.200
     0.731     5.706     0.200
     1.185     7.204     0.200
     1.494     7.302     0.200
     1.623     6.389     0.200
     1.690     7.212     0.200
     1.851     8.136     0.200
     1.975     7.489     0.200
     1.993     8.778     0.200
     2.090     8.339     0.200
     2.102     8.899     0.200
     2.081     9.145     0.200
     2.263     8.324     0.200
     2.269    10.155     0.200
     2.689    11.558     0.200
     2.673    10.642     0.200
     2.705    10.164     0.200
     2.924    11.211     0.200
     3.153    10.833     0.200
     3.314    11.654     0.200
     3.319    11.500     0.200
     3.428    14.625     0.200
     3.655    12.879     0.200
     4.027    13.537     0.200
     4.134    14.588     0.200
     4.493    14.604     0.200
     4.682    15.197     0.200
     4.774    14.219     0.200
     5.549    16.679     0.200
     6.431    16.085     0.200
     6.832    18.900     0.200
     6.919    18.593     0.200
     6.944    18.493     0.200
     6.978    20.600     0.200
     7.245    19.484     0.200
     7.427    18.957     0.200
     7.820    19.373     0.200
     7.862    22.481     0.200
     7.886    20.201     0.200
     7.915    18.565     0.200
     0.218     7.756     0.200
     0.268     7.463     0.200
     0.727     5.715     0.200
     1.210     7.279     0.200
     1.588     5.858     0.200
     1.520     7.457     0.200
     1.606     6.455     0.200
     1.671     6.689     0.200
     1.815     7.718     0.200
     1.961     7.310     0.200
     2.003     8.325     0.200
     2.065     7.895     0.200
     2.063     9.219     0.200
     2.225     7.628     0.200
     2.131     8.330     0.200
     2.242    10.131     0.200
     2.646    10.618     0.200
     2.712    10.550     0.200
     2.698     9.912     0.200
     2.909    11.351     0.200
     3.182    10.564     0.200
     3.307    11.608     0.200
     3.312    11.549     0.200
     3.378    12.972     0.200
     3.416    12.830     0.200
     3.635    12.871     0.200
     4.019    12.897     0.200
     4.116    14.664     0.200
     4.479    14.823     0.200
     4.578    16.163     0.200
     4.766    14.575     0.200
     4.667    15.036     0.200
     5.519    15.085     0.200
     5.538    16.566     0.200
     5.608    17.348     0.200
     5.887    17.396     0.200
     6.166    15.940     0.200
     6.182    17.050     0.200
     6.409    15.898     0.200
     6.422    16.153     0.200
     6.703    17.267     0.200
     6.790    20.256     0.200
     6.815    19.267     0.200
     6.906    17.902     0.200
     6.931    17.912     0.200
     6.959    20.282     0.200
     7.234    18.978     0.200
     7.367    19.020     0.200
     7.416    19.148     0.200
     7.554    22.141     0.200
     7.566    21.599     0.200
     7.809    18.262     0.200
     7.846    21.128     0.200
     7.873    20.322     0.200
     7.904    18.553     0.200
     8.341    19.857     0.200
     8.677    24.032     0.200
     8.825    22.405     0.200
     8.990    22.679     0.200
     9.261    22.018     0.200
     9.457    22.228     0.200
     9.485    22.010     0.200
     9.782    23.737     0.200
     9.929    23.929     0.200
    10.153    25.614     0.200
    10.297    27.229     0.200
    10.880    26.022     0.200
    13.053    31.265     0.200
     0.667     5.103     0.200
     0.960     6.373     0.200
     1.230     5.732     0.200
     1.302     5.884     0.200
     1.625     7.918     0.200
     1.658     8.531     0.200
     1.756     6.789     0.200
     1.761     7.832     0.200
     1.893     8.890     0.200
     1.824     8.299     0.200
     1.974     8.754     0.200
     1.978     7.804     0.200
     2.224     8.924     0.200
     2.302    10.418     0.200
     2.524     9.830     0.200
     2.599     9.750     0.200
     2.632    10.574     0.200
     3.119    11.490     0.200
     3.130    11.858     0.200
     3.294    12.348     0.200
     3.788    15.478     0.200
     4.206    15.993     0.200
     4.376    16.117     0.200
     6.488    20.972     0.200
     6.615    21.690     0.200
     6.653    19.540     0.200
     7.590    22.409     0.200
     0.879     5.818     0.200
     1.262     4.244     0.200
     1.346     5.870     0.200
     1.459     6.052     0.200
     1.524     8.094     0.200
     1.643     7.603     0.200
     1.909     7.701     0.200
     1.828     6.949     0.200
     1.841     7.390     0.200
     1.954     9.075     0.200
     1.976     8.617     0.200
     1.936     8.078     0.200
     2.217     9.504     0.200
     2.339     8.978     0.200
     2.460     9.970     0.200
     2.548     8.937     0.200
     2.693     9.855     0.200
     3.150    11.119     0.200
     3.159    11.214     0.200
     3.379    11.937     0.200
     3.869    15.122     0.200
     3.855    13.493     0.200
     4.269    15.763     0.200
     4.445    15.307     0.200
     5.349    16.952     0.200
     5.363    16.185     0.200
     5.651    17.734     0.200
     6.235    15.913     0.200
     6.571    19.296     0.200
     6.704    20.843     0.200
     6.719    18.765     0.200
     7.614    21.920     0.200
     7.616    19.795     0.200
     7.658    21.110     0.200
     7.713    18.970     0.200
     8.404    26.306     0.200
     0.207     7.408     0.200
     0.265     7.233     0.200
     0.710     5.932     0.200
     1.204     6.977     0.200
     1.515     7.039     0.200
     1.573     6.561     0.200
     1.653     7.029     0.200
     1.598     6.775     0.200
     1.812     8.078     0.200
     1.943     7.647     0.200
     1.990     8.702     0.200
     2.047     7.829     0.200
     2.127     7.998     0.200
     2.073     9.127     0.200
     2.214     8.188     0.200
     2.247    10.095     0.200
     2.705     9.858     0.200
     2.705    10.155     0.200
     2.651    10.585     0.200
     2.712     9.573     0.200
     2.920    11.142     0.200
     3.178    10.834     0.200
     3.372    13.066     0.200
     3.320    11.376     0.200
     3.326    11.315     0.200
     3.386    13.509     0.200
     3.645    12.686     0.200
     4.033    12.659     0.200
     4.126    14.776     0.200
     4.572    14.571     0.200
     4.491    14.615     0.200
     4.749    13.803     0.200
     4.678    14.729     0.200
     4.895    15.298     0.200
     5.533    15.745     0.200
     5.551    16.744     0.200
     5.897    17.203     0.200
     6.180    17.908     0.200
     6.423    15.764     0.200
     6.737    16.603     0.200
     6.907    18.819     0.200
     6.825    18.977     0.200
     6.943    18.399     0.200
     6.969    20.098     0.200
     7.535    19.194     0.200
     7.575    21.917     0.200
     7.678    19.315     0.200
     7.678    18.815     0.200
     7.733    17.776     0.200
     7.822    18.437     0.200
     7.857    21.525     0.200
     7.884    20.115     0.200
     7.917    18.630     0.200
     8.331    20.695     0.200
     8.660    22.964     0.200
     8.686    23.959     0.200
     9.151    24.126     0.200
     9.426    23.423     0.200
     9.637    27.165     0.200
     9.792    23.851     0.200
     9.901    25.377     0.200
     9.938    24.744     0.200
    10.141    25.578     0.200
    10.303    26.587     0.200
    10.506    25.317     0.200
    10.888    26.256     0.200
    11.067    26.269     0.200
    11.222    27.663     0.200
    11.322    32.297     0.200
    11.361    27.935     0.200
    11.407    27.906     0.200
    12.260    28.245     0.200
    13.043    28.214     0.200
    16.665    33.042     0.200
     0.330     4.699     0.200
     0.371     4.224     0.200
     1.109     6.303     0.200
     1.190     5.963     0.200
     1.254     5.115     0.200
     1.482     6.855     0.200
     1.429     6.477     0.200
     1.603     6.637     0.200
     1.672     8.341     0.200
     1.830     6.592     0.200
     2.000     6.816     0.200
     2.052     8.103     0.200
     2.381     9.064     0.200
     2.848    10.111     0.200
     3.098    11.098     0.200
     3.248    11.948     0.200
     3.701    12.653     0.200
     3.710    12.255     0.200
     3.923    13.564     0.200
     4.416    15.909     0.200
     4.824    15.555     0.200
     4.998    16.121     0.200
     5.905    17.637     0.200
     6.200    18.395     0.200
     6.790    16.506     0.200
     7.117    20.195     0.200
     7.245    21.100     0.200
     7.274    18.967     0.200
     8.164    22.673     0.200
     8.212    21.418     0.200
     8.932    26.108     0.200
     0.095     6.843     0.200
     0.499     6.036     0.200
     0.831     6.361     0.200
     1.307     5.303     0.200
     1.470     5.398     0.200
     1.495     7.113     0.200
     1.587     6.631     0.200
     1.888     6.720     0.200
     1.902     7.065     0.200
     1.813     7.296     0.200
     1.920     7.550     0.200
     1.876     7.562     0.200
     1.973     7.928     0.200
     2.170     8.727     0.200
     2.376     9.134     0.200
     2.434     7.854     0.200
     2.603     9.884     0.200
     2.742    10.654     0.200
     3.203    11.373     0.200
     3.213    11.364     0.200
     3.425    12.093     0.200
     3.915    13.263     0.200
     3.908    13.052     0.200
     4.318    15.160     0.200
     4.493    14.220     0.200
     5.400    16.734     0.200
     5.698    17.666     0.200
     6.287    15.284     0.200
     6.617    19.840     0.200
     6.635    16.230     0.200
     6.748    20.503     0.200
     6.768    18.870     0.200
     7.422    19.247     0.200
     7.573    18.877     0.200
     7.582    18.771     0.200
     7.661    23.248     0.200
     7.646    18.629     0.200
     7.707    21.617     0.200
     8.445    25.203     0.200
     0.212     7.193     0.200
     0.277     6.935     0.200
     0.725     5.710     0.200
     1.202     7.050     0.200
     1.512     7.229     0.200
     1.595     6.553     0.200
     1.615     6.530     0.200
     1.674     7.141     0.200
     1.824     7.991     0.200
     1.962     7.776     0.200
     1.998     8.559     0.200
     2.069     7.931     0.200
     2.123     8.503     0.200
     2.069     9.022     0.200
     2.233     8.209     0.200
     2.250    10.719     0.200
     2.704     9.814     0.200
     2.704    10.416     0.200
     2.654    10.506     0.200
     2.702     9.744     0.200
     2.914    10.965     0.200
     3.311    11.443     0.200
     3.316    11.385     0.200
     3.385    14.268     0.200
     3.642    12.576     0.200
     4.023    13.027     0.200
     4.122    15.270     0.200
     4.484    14.542     0.200
     4.571    15.529     0.200
     4.766    14.362     0.200
     4.672    14.747     0.200
     5.543    16.690     0.200
     6.170    17.669     0.200
     6.414    16.129     0.200
     6.821    18.774     0.200
     6.936    18.327     0.200
     6.966    19.985     0.200
     7.524    20.170     0.200
     7.667    19.601     0.200
     7.814    19.686     0.200
     7.852    21.841     0.200
     7.878    19.837     0.200
     7.909    20.677     0.200
     8.350    21.934     0.200
     8.684    24.428     0.200
     9.148    23.220     0.200
     9.424    24.396     0.200
    10.161    25.899     0.200
    13.062    29.149     0.200
    13.735    32.691     0.200
    14.560    31.962     0.200
    20.757    34.642     0.200
     0.043     5.793     0.200
     0.395     5.384     0.200
     0.797     6.290     0.200
     1.384     6.446     0.200
     1.401     7.452     0.200
     1.590     6.745     0.200
     1.631     8.056     0.200
     1.717     7.663     0.200
     1.950     8.941     0.200
     1.975     8.543     0.200
     1.919     7.991     0.200
     2.017     8.160     0.200
     2.053     9.031     0.200
     2.124     9.410     0.200
     2.334     8.462     0.200
     2.457     9.823     0.200
     2.610    10.232     0.200
     2.779    11.063     0.200
     3.210    12.531     0.200
     3.215    11.369     0.200
     3.223    11.482     0.200
     3.350    14.004     0.200
     3.480    12.580     0.200
     3.924    12.806     0.200
     3.967    14.500     0.200
     4.181    14.307     0.200
     4.354    14.985     0.200
     4.534    15.179     0.200
     4.780    15.311     0.200
     4.759    16.756     0.200
     4.770    15.728     0.200
     5.154    16.949     0.200
     5.440    17.511     0.200
     5.427    16.654     0.200
     5.430    14.926     0.200
     5.745    17.842     0.200
     6.070    16.959     0.200
     6.071    16.249     0.200
     6.176    19.524     0.200
     6.309    15.872     0.200
     6.463    19.072     0.200
     6.574    21.380     0.200
     6.612    20.931     0.200
     6.589    19.002     0.200
     6.609    18.967     0.200
     6.643    16.372     0.200
     6.668    19.976     0.200
     6.805    20.776     0.200
     6.806    18.272     0.200
     6.907    18.492     0.200
     6.984    21.593     0.200
     7.170    18.424     0.200
     7.287    18.458     0.200
     7.304    23.857     0.200
     7.384    22.919     0.200
     7.409    22.422     0.200
     7.434    19.634     0.200
     7.546    18.741     0.200
     7.583    17.503     0.200
     7.588    18.641     0.200
     7.648    18.337     0.200
     7.696    18.776     0.200
     7.708    21.641     0.200
     7.711    22.104     0.200
     7.746    20.404     0.200
     7.793    18.952     0.200
     7.981    23.747     0.200
     7.981    21.756     0.200
     8.183    20.392     0.200
     8.258    23.423     0.200
     8.246    19.266     0.200
     8.366    24.462     0.200
     8.383    24.365     0.200
     8.511    24.867     0.200
     8.598    24.547     0.200
     8.697    23.197     0.200
     8.861    25.690     0.200
     8.866    23.131     0.200
     8.990    23.785     0.200
     9.135    23.383     0.200
     9.254    25.104     0.200
     9.270    26.618     0.200
     9.358    22.684     0.200
     9.372    22.221     0.200
     9.416    25.112     0.200
     9.426    25.089     0.200
     9.448    26.438     0.200
     9.480    27.460     0.200
     9.634    25.171     0.200
     9.771    24.561     0.200
     9.946    27.324     0.200
    10.001    26.489     0.200
    10.111    27.703     0.200
    10.146    29.188     0.200
    10.348    25.837     0.200
    10.710    27.317     0.200
    11.124    31.483     0.200
    11.169    29.044     0.200
    11.235    28.688     0.200
    12.076    29.269     0.200
    12.449    30.815     0.200
    12.489    28.549     0.200
    12.578    31.507     0.200
    12.838    32.269     0.200
    13.042    32.685     0.200
    13.054    32.152     0.200
    13.290    31.898     0.200
    13.405    32.155     0.200
    13.543    32.647     0.200
    13.714    31.445     0.200
    13.946    33.646     0.200
    14.328    33.882     0.200
    14.547    33.029     0.200
    14.939    33.657     0.200
    15.057    31.171     0.200
    15.182    32.922     0.200
    16.444    35.190     0.200
    17.521    34.921     0.200
     0.371     4.606     0.200
     0.801     4.986     0.200
     1.378     6.962     0.200
     1.464     5.255     0.200
     1.659     7.480     0.200
     1.627     6.051     0.200
     1.692     7.090     0.200
     1.973     8.317     0.200
     2.011     8.576     0.200
     1.926     7.961     0.200
     2.063     7.665     0.200
     2.120     9.699     0.200
     2.307     9.310     0.200
     2.477     9.326     0.200
     2.604    10.155     0.200
     2.782    10.867     0.200
     3.210    11.380     0.200
     3.217    11.999     0.200
     3.491    12.804     0.200
     3.919    13.000     0.200
     4.357    14.892     0.200
     4.539    15.268     0.200
     5.427    16.405     0.200
     6.677    19.918     0.200
     6.816    21.695     0.200
     7.580    19.880     0.200
     7.714    23.513     0.200
     7.749    22.701     0.200
     0.215     7.368     0.200
     0.253     6.933     0.200
     0.738     5.664     0.200
     1.254     7.050     0.200
     1.548     6.014     0.200
     1.554     6.446     0.200
     1.566     7.011     0.200
     1.660     7.007     0.200
     1.762     7.617     0.200
     1.957     7.443     0.200
     2.043     7.738     0.200
     2.030     8.391     0.200
     2.186     7.775     0.200
     2.178     8.164     0.200
     2.201     9.599     0.200
     2.203     9.373     0.200
     2.601    10.430     0.200
     2.776    10.279     0.200
     2.877    11.108     0.200
     3.305    12.713     0.200
     3.283    11.466     0.200
     3.289    11.399     0.200
     3.339    13.311     0.200
     3.598    12.793     0.200
     3.995    12.962     0.200
     4.080    14.869     0.200
     4.448    14.567     0.200
     4.621    15.157     0.200
     4.634    14.897     0.200
     5.555    16.057     0.200
     5.853    17.283     0.200
     6.142    16.801     0.200
     6.155    16.957     0.200
     6.384    15.876     0.200
     6.397    18.527     0.200
     6.780    19.163     0.200
     6.901    18.150     0.200
     6.922    20.197     0.200
     7.499    20.167     0.200
     7.643    19.582     0.200
     7.645    20.171     0.200
     7.700    19.718     0.200
     7.782    18.669     0.200
     7.813    21.903     0.200
     7.842    20.466     0.200
     7.901    18.476     0.200
     8.020    21.882     0.200
     8.434    22.157     0.200
     8.638    24.079     0.200
     9.105    24.023     0.200
     9.378    23.837     0.200
    10.105    25.860     0.200
    12.361    26.026     0.200
    12.361    26.128     0.200
    13.003    29.334     0.200
    14.499    31.077     0.200
    16.618    34.154     0.200
     0.365     7.635     0.200
     0.602     5.669     0.200
     0.682     7.047     0.200
     0.795     7.529     0.200
     0.983     7.024     0.200
     1.587     7.283     0.200
     1.590     7.547     0.200
     1.649     6.558     0.200
     1.885     7.505     0.200
     2.140     8.422     0.200
     2.331     9.197     0.200
     2.629     9.814     0.200
     2.785    10.495     0.200
     3.185    11.336     0.200
     3.246    11.614     0.200
     3.399    11.736     0.200
     3.745    12.199     0.200
     3.746    12.287     0.200
     3.870    14.137     0.200
     4.149    13.478     0.200
     4.459    14.167     0.200
     4.622    15.259     0.200
     4.957    15.847     0.200
     5.154    15.458     0.200
     5.831    15.257     0.200
     6.037    17.550     0.200
     6.382    18.719     0.200
     6.850    17.061     0.200
     6.906    19.808     0.200
     7.315    20.528     0.200
     7.405    20.682     0.200
     7.468    21.153     0.200
     8.062    20.922     0.200
     8.107    20.396     0.200
     8.348    22.276     0.200
     0.569     5.039     0.200
     1.091     6.843     0.200
     1.408     6.754     0.200
     1.533     6.895     0.200
     1.815     8.004     0.200
     1.849     9.000     0.200
     1.879     8.158     0.200
     2.026     8.942     0.200
     2.222     9.045     0.200
     2.306     9.667     0.200
     2.369    10.037     0.200
     2.765    11.614     0.200
     2.956    10.781     0.200
     3.057    11.903     0.200
     3.463    12.069     0.200
     3.468    12.206     0.200
     3.775    13.827     0.200
     4.629    15.357     0.200
     4.815    15.993     0.200
     5.554    15.865     0.200
     5.736    17.346     0.200
     6.032    18.087     0.200
     6.335    17.746     0.200
     6.565    16.770     0.200
     6.578    19.619     0.200
     6.958    19.576     0.200
     7.081    18.542     0.200
     7.100    21.026     0.200
     7.821    18.804     0.200
     7.876    18.961     0.200
     7.962    20.759     0.200
     7.993    24.303     0.200
     8.023    20.457     0.200
     8.082    19.667     0.200
     0.227     6.843     0.200
     0.241     7.480     0.200
     0.295     6.255     0.200
     0.722     5.477     0.200
     1.226     6.681     0.200
     1.538     6.644     0.200
     1.560     6.784     0.200
     1.577     7.091     0.200
     1.655     7.487     0.200
     1.770     8.146     0.200
     1.788     8.225     0.200
     1.948     7.863     0.200
     2.007     8.567     0.200
     2.044     8.347     0.200
     2.053     9.239     0.200
     2.150     7.803     0.200
     2.205     8.569     0.200
     2.151     9.092     0.200
     2.228     9.896     0.200
     2.230     9.566     0.200
     2.628    10.727     0.200
     2.798    10.046     0.200
     2.930    10.711     0.200
     3.304    11.236     0.200
     3.310    11.368     0.200
     3.331    13.319     0.200
     3.624    12.805     0.200
     4.016    12.827     0.200
     4.105    14.390     0.200
     4.472    14.709     0.200
     4.594    14.584     0.200
     4.659    15.032     0.200
     4.757    14.787     0.200
     5.395    14.628     0.200
     5.577    16.007     0.200
     5.594    17.306     0.200
     5.877    17.404     0.200
     6.163    16.667     0.200
     6.177    17.107     0.200
     6.406    15.537     0.200
     6.421    18.867     0.200
     6.722    17.050     0.200
     6.805    19.182     0.200
     6.924    18.187     0.200
     6.948    20.613     0.200
     7.519    18.648     0.200
     7.588    19.747     0.200
     7.663    19.467     0.200
     7.664    18.859     0.200
     7.719    19.314     0.200
     7.804    18.917     0.200
     7.838    21.129     0.200
     7.866    20.607     0.200
     7.923    18.728     0.200
     8.044    19.923     0.200
     8.311    22.201     0.200
     8.664    24.187     0.200
     8.746    24.128     0.200
     9.018    26.250     0.200
     9.131    23.843     0.200
     9.404    23.446     0.200
     9.614    25.998     0.200
     9.657    26.696     0.200
     9.772    23.659     0.200
     9.879    25.407     0.200
     9.917    24.668     0.200
    10.123    25.662     0.200
    10.153    26.108     0.200
    10.280    26.828     0.200
    10.320    24.367     0.200
    10.411    26.500     0.200
    10.486    25.226     0.200
    10.866    26.682     0.200
    11.299    30.543     0.200
    11.339    28.575     0.200
    11.385    27.929     0.200
    12.238    29.083     0.200
    12.624    30.775     0.200
    13.023    30.009     0.200
    13.711    31.393     0.200
    14.119    32.532     0.200
    14.522    32.125     0.200
    14.708    32.258     0.200
    15.096    33.025     0.200
    16.643    34.180     0.200
     0.522     5.280     0.200
     0.555     4.198     0.200
     0.633     5.281     0.200
     0.672     4.827     0.200
     0.933     4.377     0.200
     1.011     5.875     0.200
     1.348     6.836     0.200
     1.351     7.109     0.200
     1.378     6.987     0.200
     1.604     6.249     0.200
     1.627     6.381     0.200
     1.701     6.320     0.200
     1.690     6.945     0.200
     1.782     9.075     0.200
     2.306     9.058     0.200
     2.368     8.733     0.200
     2.481     8.916     0.200
     2.737    10.131     0.200
     3.232    11.151     0.200
     3.294    11.427     0.200
     3.752    13.080     0.200
     3.863    13.287     0.200
     4.968    15.994     0.200
     7.055    18.535     0.200
     0.235     7.136     0.200
     0.235     7.138     0.200
     0.289     6.201     0.200
     0.727     6.192     0.200
     1.234     7.278     0.200
     1.558     6.394     0.200
     1.546     7.437     0.200
     1.658     7.633     0.200
     1.763     7.607     0.200
     1.782     7.991     0.200
     1.952     8.100     0.200
     2.014     9.469     0.200
     2.045     8.316     0.200
     2.144     8.959     0.200
     2.200     8.103     0.200
     2.158     8.292     0.200
     2.223     9.437     0.200
     2.620    10.599     0.200
     2.791     9.906     0.200
     2.922    10.678     0.200
     3.298    11.595     0.200
     3.303    11.430     0.200
     3.616    13.081     0.200
     4.009    13.288     0.200
     4.098    15.055     0.200
     4.465    15.074     0.200
     5.389    14.691     0.200
     5.570    16.073     0.200
     6.797    19.254     0.200
     0.129     5.619     0.200
     0.153     6.542     0.200
     0.339     5.871     0.200
     0.674     5.960     0.200
     1.344     5.542     0.200
     1.325     6.863     0.200
     1.504     7.472     0.200
     1.607     6.373     0.200
     1.627     6.642     0.200
     1.644     6.939     0.200
     1.820     7.992     0.200
     1.860     8.118     0.200
     1.992     7.081     0.200
     2.008     8.589     0.200
     2.154     8.186     0.200
     2.141     8.142     0.200
     2.266     8.485     0.200
     2.547     9.610     0.200
     2.833     9.863     0.200
     2.938    10.745     0.200
     3.342    11.022     0.200
     3.351    11.128     0.200
     3.589    13.243     0.200
     4.050    12.468     0.200
     4.651    15.048     0.200
     5.430    14.960     0.200
     6.419    19.122     0.200
     6.433    15.950     0.200
     6.780    19.706     0.200
     6.925    18.919     0.200
     7.711    18.544     0.200
     7.717    19.471     0.200
     7.864    21.756     0.200
     0.477     5.000     0.200
     0.496     4.184     0.200
     0.570     5.612     0.200
     0.590     4.686     0.200
     1.013     4.350     0.200
     1.069     5.499     0.200
     1.321     6.551     0.200
     1.399     6.745     0.200
     1.423     6.756     0.200
     1.634     6.405     0.200
     1.656     6.642     0.200
     1.636     6.773     0.200
     1.770     6.408     0.200
     1.771     8.804     0.200
     2.366     8.750     0.200
     2.372     8.580     0.200
     2.457     8.797     0.200
     2.740     9.892     0.200
     3.197    10.559     0.200
     3.706    12.017     0.200
     3.717    12.689     0.200
     4.951    15.689     0.200
     5.783    15.382     0.200
     0.492     4.592     0.200
     0.693     5.447     0.200
     1.167     5.917     0.200
     1.219     4.506     0.200
     1.399     7.211     0.200
     1.479     6.678     0.200
     1.499     7.235     0.200
     1.719     8.775     0.200
     1.733     8.208     0.200
     1.815     7.645     0.200
     1.753     7.273     0.200
     2.033     9.503     0.200
     2.143     8.323     0.200
     2.495     9.321     0.200
     2.869    10.955     0.200
     2.950    11.305     0.200
     3.243    12.686     0.200
     3.564    13.341     0.200
     4.646    16.408     0.200
     5.610    16.461     0.200
     6.758    19.865     0.200
     0.195     7.090     0.200
     0.310     7.055     0.200
     0.365     5.915     0.200
     0.720     5.473     0.200
     1.175     6.957     0.200
     1.484     6.951     0.200
     1.620     7.062     0.200
     1.681     7.355     0.200
     1.647     6.554     0.200
     1.838     8.126     0.200
     1.856     8.409     0.200
     1.965     7.941     0.200
     1.981     8.749     0.200
     2.083     8.162     0.200
     2.093     8.241     0.200
     2.092     8.356     0.200
     2.208     8.006     0.200
     2.188     9.235     0.200
     2.272     8.851     0.200
     2.282    10.138     0.200
     2.283     9.724     0.200
     2.682    10.771     0.200
     2.821    10.055     0.200
     2.935    11.519     0.200
     2.960    10.923     0.200
     3.326    11.458     0.200
     3.330    11.404     0.200
     3.377    13.155     0.200
     3.412    12.951     0.200
     3.666    12.992     0.200
     4.039    12.940     0.200
     4.145    14.801     0.200
     4.545    15.231     0.200
     4.504    14.710     0.200
     4.763    14.381     0.200
     4.693    14.805     0.200
     4.905    16.531     0.200
     5.417    14.853     0.200
     5.604    16.374     0.200
     5.914    17.352     0.200
     6.185    16.791     0.200
     6.204    17.065     0.200
     6.430    15.836     0.200
     6.453    18.865     0.200
     6.738    16.835     0.200
     6.824    19.837     0.200
     6.843    19.411     0.200
     6.956    18.299     0.200
     6.989    20.311     0.200
     7.537    21.614     0.200
     7.538    19.902     0.200
     7.596    22.224     0.200
     7.679    19.356     0.200
     7.680    19.840     0.200
     7.733    19.230     0.200
     7.873    22.189     0.200
     7.897    20.707     0.200
     7.950    18.489     0.200
     8.075    20.734     0.200
     8.493    20.561     0.200
     8.709    24.037     0.200
     8.850    23.190     0.200
     9.171    23.947     0.200
     9.459    27.882     0.200
     9.665    26.182     0.200
     9.713    26.620     0.200
     9.811    23.780     0.200
     9.926    25.531     0.200
     9.959    24.652     0.200
    10.190    26.051     0.200
    10.198    26.063     0.200
    10.332    26.696     0.200
    10.459    26.509     0.200
    10.525    25.749     0.200
    10.644    25.359     0.200
    10.913    26.718     0.200
    11.359    28.217     0.200
    11.353    30.379     0.200
    11.391    28.541     0.200
    12.290    27.343     0.200
    12.459    30.377     0.200
    12.678    31.018     0.200
    13.092    28.985     0.200
    13.267    30.947     0.200
    13.522    33.569     0.200
    13.762    32.169     0.200
    13.935    32.650     0.200
    14.592    31.787     0.200
    14.756    32.471     0.200
    16.712    34.741     0.200
     0.640     3.946     0.200
     0.727     5.127     0.200
     0.864     5.330     0.200
     1.114     6.318     0.200
     1.310     6.523     0.200
     1.287     4.790     0.200
     1.311     5.119     0.200
     1.377     5.542     0.200
     1.487     7.360     0.200
     1.719     7.153     0.200
     2.032     7.095     0.200
     2.086     8.771     0.200
     2.123     8.239     0.200
     2.313     8.125     0.200
     2.475     9.133     0.200
     2.649     9.106     0.200
     2.766     8.939     0.200
     3.102     9.708     0.200
     3.606    11.437     0.200
     3.621    12.555     0.200
     3.636    12.786     0.200
     4.762    15.641     0.200
     5.655    15.924     0.200
     6.818    21.347     0.200
     6.922    21.530     0.200
     7.038    19.975     0.200
     8.562    24.998     0.200
    19.608    38.584     0.200
     0.165     8.718     0.200
     0.296     7.682     0.200
     0.274     8.846     0.200
     0.615     5.961     0.200
     1.169     6.898     0.200
     1.493     6.212     0.200
     1.548     6.371     0.200
     1.485     7.007     0.200
     1.561     6.720     0.200
     1.784     8.022     0.200
     1.803     8.294     0.200
     1.914     7.803     0.200
     1.946     7.036     0.200
     2.103     8.197     0.200
     2.166     8.062     0.200
     2.136     9.911     0.200
     2.219     7.942     0.200
     2.237     9.733     0.200
     2.288     9.940     0.200
     2.292     9.588     0.200
     2.719    10.113     0.200
     2.688    10.470     0.200
     2.896    10.445     0.200
     3.021    11.382     0.200
     3.268     9.505     0.200
     3.404    13.212     0.200
     3.403    11.622     0.200
     3.409    11.551     0.200
     3.439    13.511     0.200
     3.703    13.032     0.200
     4.115    12.924     0.200
     4.187    14.677     0.200
     4.528    14.794     0.200
     4.647    13.604     0.200
     4.563    14.793     0.200
     4.747    14.946     0.200
     5.494    15.022     0.200
     5.667    17.108     0.200
     5.672    16.245     0.200
     5.962    17.362     0.200
     6.262    16.262     0.200
     6.272    17.052     0.200
     6.511    18.861     0.200
     6.503    16.143     0.200
     6.842    19.994     0.200
     6.824    17.009     0.200
     6.888    19.062     0.200
     7.015    18.278     0.200
     7.028    20.127     0.200
     7.633    21.565     0.200
     7.620    19.517     0.200
     7.686    20.043     0.200
     7.765    19.523     0.200
     7.767    19.305     0.200
     7.823    18.847     0.200
     7.899    18.464     0.200
     7.924    21.171     0.200
     7.956    21.798     0.200
     8.018    18.770     0.200
     8.176    21.119     0.200
     8.546    22.213     0.200
     8.738    24.565     0.200
     8.823    23.475     0.200
     9.211    23.644     0.200
     9.480    24.013     0.200
     9.494    26.843     0.200
     9.679    25.589     0.200
     9.854    24.545     0.200
    10.079    24.913     0.200
    10.079    27.116     0.200
     9.995    24.098     0.200
    10.342    25.347     0.200
    10.378    28.730     0.200
    10.938    25.298     0.200
    11.401    28.294     0.200
    12.261    25.651     0.200
    12.279    28.243     0.200
    12.461    30.117     0.200
    12.989    28.256     0.200
    14.502    31.601     0.200
    14.777    32.696     0.200
    16.641    33.445     0.200
     0.509     4.993     0.200
     0.587     6.187     0.200
     0.852     4.696     0.200
     0.911     6.107     0.200
     1.003     6.530     0.200
     1.105     5.840     0.200
     1.127     5.981     0.200
     1.394     7.472     0.200
     1.408     6.602     0.200
     1.765     7.936     0.200
     1.866     8.166     0.200
     1.969     7.853     0.200
     2.033     8.514     0.200
     2.136     7.512     0.200
     2.821     9.713     0.200
     2.877     8.864     0.200
     2.848    10.499     0.200
     3.324    11.240     0.200
     3.340    11.761     0.200
     3.371    12.193     0.200
     0.148     4.174     0.200
     0.217     4.767     0.200
     0.599     4.609     0.200
     0.866     5.992     0.200
     1.198     5.620     0.200
     1.347     5.876     0.200
     1.367     6.246     0.200
     1.776     6.877     0.200
     1.886     7.587     0.200
     1.899     7.044     0.200
     1.929     7.389     0.200
     1.970     6.816     0.200
     2.207     9.338     0.200
     2.284     8.350     0.200
     2.316     8.977     0.200
     2.638     8.413     0.200
     2.702     9.366     0.200
     2.778     9.681     0.200
     3.211    11.027     0.200
     3.222    11.797     0.200
     3.389    12.347     0.200
     3.884    14.775     0.200
     4.472    14.814     0.200
     5.289    14.776     0.200
     5.324    17.270     0.200
     5.438    16.138     0.200
     5.669    17.446     0.200
     6.241    18.862     0.200
     6.284    15.766     0.200
     6.583    18.872     0.200
     6.710    20.998     0.200
     6.749    18.937     0.200
     7.633    22.521     0.200
     8.397    25.409     0.200
     9.964    27.617     0.200
     0.066     6.121     0.200
     0.181     6.384     0.200
     0.537     5.728     0.200
     0.808     6.165     0.200
     1.218     5.571     0.200
     1.410     6.436     0.200
     1.430     6.703     0.200
     1.516     7.204     0.200
     1.514     7.119     0.200
     1.819     7.160     0.200
     1.818     7.776     0.200
     1.854     7.455     0.200
     1.834     7.187     0.200
     1.989     7.972     0.200
     2.019     7.722     0.200
     2.150     8.505     0.200
     2.342     8.664     0.200
     2.377     9.354     0.200
     2.457     9.012     0.200
     2.574     8.149     0.200
     2.744    10.075     0.200
     2.826    10.415     0.200
     3.127    12.995     0.200
     3.253    11.726     0.200
     3.263    11.808     0.200
     3.445    12.184     0.200
     3.939    15.024     0.200
     3.955    13.238     0.200
     4.353    15.194     0.200
     4.524    15.094     0.200
     5.334    14.648     0.200
     5.486    15.269     0.200
     6.639    20.412     0.200
     0.191     5.808     0.200
     0.345     5.508     0.200
     0.642     5.650     0.200
     1.316     6.681     0.200
     1.460     6.602     0.200
     1.606     5.991     0.200
     1.627     6.157     0.200
     1.636     6.848     0.200
     1.776     7.211     0.200
     1.817     6.539     0.200
     1.968     6.371     0.200
     1.980     8.437     0.200
     2.065     8.741     0.200
     2.175     7.962     0.200
     2.172     7.987     0.200
     2.259     8.281     0.200
     2.376     7.817     0.200
     2.527     8.748     0.200
     2.565     9.404     0.200
     2.870    10.545     0.200
     2.971    10.770     0.200
     3.379    11.403     0.200
     3.388    11.804     0.200
     4.106    14.617     0.200
     4.682    15.099     0.200
     5.466    14.651     0.200
     5.564    16.909     0.200
     5.629    16.245     0.200
     5.888    17.229     0.200
     6.226    16.679     0.200
     6.233    16.606     0.200
     6.450    18.671     0.200
     6.469    15.551     0.200
     6.728    20.526     0.200
     6.808    18.394     0.200
     6.809    16.684     0.200
     6.940    20.748     0.200
     6.956    18.162     0.200
     7.461    21.665     0.200
     7.542    21.825     0.200
     7.655    19.303     0.200
     7.748    21.520     0.200
     7.755    18.639     0.200
     7.816    18.223     0.200
     7.852    22.512     0.200
     7.852    18.605     0.200
     7.895    21.603     0.200
     7.972    18.409     0.200
     8.114    21.651     0.200
     8.339    20.631     0.200
     8.404    20.061     0.200
     8.477    22.514     0.200
     8.637    24.650     0.200
     8.728    25.282     0.200
     9.125    23.352     0.200
     9.285    26.785     0.200
     9.507    22.790     0.200
     9.536    22.050     0.200
     9.558    28.191     0.200
     9.840    25.804     0.200
     9.903    25.374     0.200
    10.126    26.372     0.200
    10.217    28.405     0.200
    10.830    26.648     0.200
    11.222    31.774     0.200
    12.165    28.572     0.200
    13.651    31.829     0.200
    15.224    32.069     0.200
     0.212     7.017     0.200
     0.283     7.288     0.200
     0.369     5.683     0.200
     0.728     5.902     0.200
     1.199     6.999     0.200
     1.509     6.985     0.200
     1.602     6.794     0.200
     1.621     6.873     0.200
     1.679     7.205     0.200
     1.728     7.727     0.200
     1.811     8.162     0.200
     1.829     8.347     0.200
     1.966     7.749     0.200
     1.998     9.376     0.200
     2.075     7.978     0.200
     2.071     8.229     0.200
     2.119     8.167     0.200
     2.167     9.300     0.200
     2.250     8.741     0.200
     2.233     7.831     0.200
     2.257    10.054     0.200
     2.258     9.538     0.200
     2.657     9.387     0.200
     2.657    10.086     0.200
     2.804     9.970     0.200
     2.915    12.374     0.200
     2.942    10.666     0.200
     3.310    11.267     0.200
     3.315    11.511     0.200
     3.354    12.849     0.200
     3.398    12.745     0.200
     3.389    12.845     0.200
     3.644    12.674     0.200
     4.022    12.753     0.200
     4.123    14.473     0.200
     4.485    14.857     0.200
     4.673    14.860     0.200
     4.673    15.161     0.200
     4.769    14.740     0.200
     5.313    17.392     0.200
     5.401    14.662     0.200
     5.586    16.201     0.200
     5.617    17.338     0.200
     5.894    17.116     0.200
     6.169    16.499     0.200
     6.187    16.995     0.200
     6.413    15.751     0.200
     6.434    18.511     0.200
     6.729    19.864     0.200
     6.800    20.039     0.200
     6.822    18.779     0.200
     6.937    19.443     0.200
     6.967    21.088     0.200
     6.967    21.288     0.200
     7.514    21.805     0.200
     7.523    20.400     0.200
     7.574    22.104     0.200
     7.665    18.839     0.200
     7.666    18.630     0.200
     7.720    19.206     0.200
     7.814    19.306     0.200
     7.853    21.749     0.200
     7.878    20.453     0.200
     7.933    19.516     0.200
     8.100    21.463     0.200
     8.301    19.620     0.200
     8.356    22.874     0.200
     8.473    21.115     0.200
     8.513    23.649     0.200
     8.686    24.026     0.200
     8.831    22.536     0.200
     8.996    22.816     0.200
     9.092    24.687     0.200
     9.149    23.820     0.200
     9.267    23.252     0.200
     9.426    24.394     0.200
     9.490    22.142     0.200
     9.641    26.189     0.200
     9.790    23.150     0.200
     9.903    25.328     0.200
     9.937    25.031     0.200
    10.168    25.235     0.200
    10.308    26.106     0.200
    10.308    26.705     0.200
    10.630    26.337     0.200
    10.890    26.213     0.200
    11.314    25.360     0.200
    11.366    28.551     0.200
    12.236    28.304     0.200
    12.313    30.203     0.200
    12.434    30.294     0.200
    13.069    29.685     0.200
    13.738    32.076     0.200
    13.910    32.562     0.200
    14.566    32.404     0.200
    14.732    32.270     0.200
    16.686    34.673     0.200
     0.021     6.249     0.200
     0.106     6.553     0.200
     0.486     5.511     0.200
     0.806     6.277     0.200
     1.461     6.341     0.200
     1.478     6.937     0.200
     1.480     6.513     0.200
     1.797     7.014     0.200
     1.843     7.982     0.200
     1.894     8.885     0.200
     1.892     7.506     0.200
     2.005     8.390     0.200
     2.010     8.033     0.200
     2.396     9.529     0.200
     2.403     8.639     0.200
     2.418     8.964     0.200
     2.535     8.606     0.200
     2.720    10.043     0.200
     2.812    10.574     0.200
     3.230    10.999     0.200
     3.239    11.590     0.200
     3.448    12.950     0.200
     3.934    12.480     0.200
     3.939    14.016     0.200
     4.344    14.597     0.200
     4.518    14.662     0.200
     5.314    14.278     0.200
     5.472    15.934     0.200
     6.313    15.314     0.200
     6.640    21.594     0.200
     6.661    16.554     0.200
     6.772    20.663     0.200
     6.793    19.009     0.200
     7.448    18.272     0.200
     7.599    17.703     0.200
     7.609    18.196     0.200
     7.672    18.052     0.200
     7.686    22.796     0.200
     7.732    21.558     0.200
     7.813    18.114     0.200
     8.467    25.276     0.200
     0.126     7.783     0.200
     0.226     6.315     0.200
     0.334     6.657     0.200
     0.783     6.415     0.200
     1.339     7.320     0.200
     1.653     7.263     0.200
     1.662     7.748     0.200
     1.652     7.168     0.200
     1.671     7.452     0.200
     1.809     8.134     0.200
     1.971     8.749     0.200
     2.024     8.625     0.200
     2.056     8.651     0.200
     2.110     8.019     0.200
     2.118     9.232     0.200
     2.382     8.952     0.200
     2.515     9.900     0.200
     2.721     9.893     0.200
     2.842    10.386     0.200
     3.229    11.265     0.200
     3.939    13.176     0.200
     4.566    14.362     0.200
     6.327    15.811     0.200
     6.707    21.180     0.200
     6.835    19.788     0.200
     6.847    21.644     0.200
     7.720    19.155     0.200
     0.814     5.932     0.200
     1.179     6.770     0.200
     1.257     6.358     0.200
     1.460     7.895     0.200
     1.489     7.154     0.200
     1.758     7.919     0.200
     1.875     7.150     0.200
     2.099     7.539     0.200
     2.120     8.889     0.200
     2.290     8.498     0.200
     2.689    10.450     0.200
     3.103    11.520     0.200
     3.350    10.832     0.200
     3.476    11.662     0.200
     3.857    12.120     0.200
     4.146    14.042     0.200
     4.569    13.909     0.200
     5.017    15.385     0.200
     5.199    15.959     0.200
     6.128    17.624     0.200
     6.412    19.501     0.200
     6.958    16.930     0.200
     7.335    21.828     0.200
     8.216    21.754     0.200
     8.374    24.904     0.200
     8.409    21.894     0.200
     0.159     7.670     0.200
     0.333     7.141     0.200
     0.410     5.847     0.200
     0.688     5.707     0.200
     1.141     7.121     0.200
     1.450     7.207     0.200
     1.658     7.384     0.200
     1.678     7.846     0.200
     1.832     8.256     0.200
     1.862     7.909     0.200
     1.880     8.290     0.200
     1.938     8.016     0.200
     2.061     8.782     0.200
     2.175     8.044     0.200
     2.167     9.349     0.200
     2.224     9.173     0.200
     2.281     8.509     0.200
     2.317     9.292     0.200
     2.420     9.887     0.200
     2.510     9.044     0.200
     2.661     9.982     0.200
     2.813    10.207     0.200
     2.822    10.897     0.200
     2.857     9.994     0.200
     2.918    10.574     0.200
     2.997    10.958     0.200
     3.120    11.228     0.200
     3.362    11.099     0.200
     3.413    12.703     0.200
     3.446    12.722     0.200
     3.490    13.009     0.200
     3.613    11.870     0.200
     3.963    13.189     0.200
     4.035    12.147     0.200
     4.328    13.628     0.200
     4.513    14.764     0.200
     4.677    15.154     0.200
     4.741    13.803     0.200
     5.184    14.339     0.200
     5.204    15.507     0.200
     5.453    14.995     0.200
     5.526    16.444     0.200
     5.640    16.411     0.200
     5.951    17.290     0.200
     6.241    16.902     0.200
     6.466    15.676     0.200
     6.879    18.549     0.200
     6.879    19.049     0.200
     6.992    17.334     0.200
     7.572    21.262     0.200
     7.714    20.205     0.200
     7.768    19.381     0.200
     7.910    21.526     0.200
     7.910    22.126     0.200
     7.934    19.843     0.200
     7.987    18.225     0.200
     8.156    20.850     0.200
     8.529    21.496     0.200
     8.745    23.782     0.200
     8.745    24.183     0.200
     8.887    22.926     0.200
     9.207    22.787     0.200
     9.546    22.032     0.200
     0.247     7.492     0.200
     0.211     7.009     0.200
     0.277     6.347     0.200
     0.685     5.482     0.200
     0.754     7.683     0.200
     0.973     5.017     0.200
     1.179     6.222     0.200
     1.235     7.066     0.200
     1.316     7.117     0.200
     1.393     7.222     0.200
     1.500     6.471     0.200
     1.537     7.333     0.200
     1.570     7.355     0.200
     1.706     7.966     0.200
     1.722     8.088     0.200
     1.735     7.834     0.200
     1.775     7.869     0.200
     1.779     8.609     0.200
     1.819     7.541     0.200
     1.896     8.243     0.200
     2.079     9.218     0.200
     2.070     8.519     0.200
     2.164     8.522     0.200
     2.187     8.253     0.200
     2.224     9.228     0.200
     2.281     7.752     0.200
     2.276     9.811     0.200
     2.252     8.595     0.200
     2.296     9.580     0.200
     2.312     9.798     0.200
     2.319    10.205     0.200
     2.472     8.633     0.200
     2.476     9.780     0.200
     2.604     9.796     0.200
     2.679    10.510     0.200
     2.742    10.776     0.200
     2.731    10.404     0.200
     2.823     9.324     0.200
     2.817    10.309     0.200
     2.948    10.278     0.200
     3.072    10.425     0.200
     3.150    11.920     0.200
     3.331    10.706     0.200
     3.383    12.703     0.200
     3.571    11.095     0.200
     3.902    12.541     0.200
     4.003    11.968     0.200
     4.281    12.114     0.200
     4.621    14.452     0.200
     4.703    13.092     0.200
     4.711    17.503     0.200
     5.152    13.655     0.200
     5.160    14.859     0.200
     5.422    14.307     0.200
     5.473    15.902     0.200
     6.189    15.645     0.200
     6.431    15.534     0.200
     6.752    16.283     0.200
     6.815    18.948     0.200
     6.815    18.746     0.200
     6.941    17.870     0.200
     0.079     6.691     0.200
     0.508     5.682     0.200
     0.447     6.393     0.200
     0.664     5.367     0.200
     0.874     5.810     0.200
     1.001     6.633     0.200
     1.111     6.645     0.200
     1.157     6.612     0.200
     1.220     6.274     0.200
     1.243     7.505     0.200
     1.334     6.440     0.200
     1.417     6.874     0.200
     1.460     6.671     0.200
     1.583     8.536     0.200
     1.714     7.113     0.200
     1.730     7.820     0.200
     1.817     8.107     0.200
     1.810     8.395     0.200
     1.882     8.152     0.200
     1.878     7.991     0.200
     1.978     8.431     0.200
     2.009     8.669     0.200
     2.044     8.457     0.200
     2.049     9.104     0.200
     2.036     7.754     0.200
     2.410     9.093     0.200
     2.488     9.773     0.200
     2.486     9.904     0.200
     2.560     9.639     0.200
     2.572     9.900     0.200
     2.563     8.004     0.200
     2.770     9.386     0.200
     2.851    10.542     0.200
     2.978    11.163     0.200
     3.245    12.244     0.200
     3.279    11.243     0.200
     3.491    12.678     0.200
     3.944    12.387     0.200
     0.314     3.970     0.200
     0.392     4.568     0.200
     0.618     4.523     0.200
     0.660     4.341     0.200
     0.688     5.504     0.200
     0.793     5.586     0.200
     0.962     5.710     0.200
     0.958     5.963     0.200
     0.986     6.626     0.200
     1.012     5.822     0.200
     1.066     7.203     0.200
     1.164     5.357     0.200
     1.264     7.384     0.200
     1.303     7.228     0.200
     1.391     7.501     0.200
     1.469     6.596     0.200
     1.600     6.572     0.200
     1.584     7.057     0.200
     1.622     8.408     0.200
     1.649     7.092     0.200
     1.761     7.484     0.200
     1.765     8.442     0.200
     1.803     8.299     0.200
     1.836     7.710     0.200
     1.841     8.156     0.200
     2.106     8.963     0.200
     2.335     8.791     0.200
     2.410     7.717     0.200
     2.437     9.400     0.200
     2.562     9.445     0.200
     2.954    11.364     0.200
     2.942    10.500     0.200
     3.004    11.282     0.200
     3.375    11.948     0.200
     3.503    12.758     0.200
     3.825    13.106     0.200
     4.021    13.112     0.200
     0.408     4.970     0.200
     0.428     4.531     0.200
     0.483     5.992     0.200
     0.540     4.523     0.200
     0.684     6.044     0.200
     0.817     5.694     0.200
     0.976     5.633     0.200
     0.956     6.677     0.200
     1.003     6.127     0.200
     1.171     7.065     0.200
     1.301     5.940     0.200
     1.346     8.219     0.200
     1.439     7.439     0.200
     1.428     7.457     0.200
     1.502     6.397     0.200
     1.481     8.242     0.200
     1.694     7.457     0.200
     1.702     7.562     0.200
     1.805     7.870     0.200
     1.836     8.295     0.200
     1.884     9.542     0.200
     1.925     8.266     0.200
     2.021     8.439     0.200
     2.143     9.316     0.200
     2.255     8.915     0.200
     2.244     8.639     0.200
     2.288     7.525     0.200
     2.375     9.615     0.200
     2.321     9.935     0.200
     2.386     9.083     0.200
     2.427     9.604     0.200
     2.788    10.591     0.200
     2.871    10.818     0.200
     2.919    10.259     0.200
     3.147    10.999     0.200
     3.233    11.289     0.200
     3.360    11.810     0.200
     3.657    12.452     0.200
     3.872    13.039     0.200
     4.323    13.481     0.200
     0.377     5.565     0.200
     0.536     6.307     0.200
     0.815     5.961     0.200
     0.926     6.062     0.200
     1.164     5.076     0.200
     1.217     7.563     0.200
     1.406     6.853     0.200
     1.473     7.474     0.200
     1.586     7.464     0.200
     1.595     7.446     0.200
     1.661     7.385     0.200
     1.763     8.291     0.200
     1.769     7.719     0.200
     1.860     8.662     0.200
     1.939     8.244     0.200
     2.022     8.566     0.200
     2.248     9.535     0.200
     2.277     9.693     0.200
     2.456    10.210     0.200
     2.601    10.310     0.200
     2.561     9.781     0.200
     2.601    10.110     0.200
     2.664     9.575     0.200
     2.577     9.394     0.200
     2.723     9.594     0.200
     2.755    10.917     0.200
     2.717     9.851     0.200
     2.838    10.744     0.200
     2.835    10.579     0.200
     2.817    10.291     0.200
     3.004    10.608     0.200
     3.151    10.289     0.200
     3.204    11.376     0.200
     3.327    11.236     0.200
     3.323    11.382     0.200
     3.442    11.796     0.200
     3.648    12.491     0.200
     3.920    12.811     0.200
     4.320    13.348     0.200
     1.055     6.656     0.200
     1.028     7.770     0.200
     1.091     6.829     0.200
     1.256     8.109     0.200
     1.299     7.401     0.200
     1.376     8.305     0.200
     1.452     8.420     0.200
     1.410     8.707     0.200
     1.471     8.299     0.200
     1.562     8.240     0.200
     1.625     9.293     0.200
     1.687     9.370     0.200
     1.830     9.612     0.200
     1.831     9.700     0.200
     1.848     9.692     0.200
     1.947     9.638     0.200
     1.915    10.114     0.200
     1.903     9.951     0.200
     1.965    10.826     0.200
     2.088     8.994     0.200
     2.119     9.233     0.200
     2.307    10.440     0.200
     2.394    11.120     0.200
     2.504    12.036     0.200
     2.508    11.996     0.200
     2.557     9.826     0.200
     2.553    10.875     0.200
     2.733    12.266     0.200
     2.922    10.765     0.200
     2.919    11.098     0.200
     2.933    12.133     0.200
     3.061    12.140     0.200
     3.253    13.905     0.200
     3.420    13.454     0.200
     3.584    13.139     0.200
     4.064    14.540     0.200
     4.709    17.211     0.200
     6.610    22.825     0.200
     6.610    22.920     0.200
     1.053     6.653     0.200
     1.092     6.791     0.200
     1.289     8.289     0.200
     1.299     7.375     0.200
     1.379     8.545     0.200
     1.413     8.752     0.200
     1.450     8.514     0.200
     1.471     8.568     0.200
     1.561     8.526     0.200
     1.627     9.455     0.200
     1.688     9.633     0.200
     1.830     9.682     0.200
     1.830     9.782     0.200
     1.848     9.866     0.200
     1.905    10.300     0.200
     1.947     9.918     0.200
     1.915    10.189     0.200
     1.967     9.978     0.200
     2.086     9.289     0.200
     2.118    10.021     0.200
     2.306     9.928     0.200
     2.507    12.378     0.200
     2.551    11.361     0.200
     2.555    11.516     0.200
     2.732    12.552     0.200
     2.920    10.758     0.200
     2.918    11.889     0.200
     3.060    12.728     0.200
     3.418    13.744     0.200
     3.583    14.223     0.200
     0.441     3.628     0.200
     0.655     5.429     0.200
     0.743     6.003     0.200
     1.001     5.386     0.200
     1.179     5.514     0.200
     1.073     7.747     0.200
     1.111     6.609     0.200
     1.304     6.053     0.200
     1.364     7.562     0.200
     1.483     6.566     0.200
     1.449     7.367     0.200
     1.483     7.470     0.200
     1.554     7.539     0.200
     1.682     7.148     0.200
     1.639     7.849     0.200
     1.692     7.532     0.200
     1.786     9.128     0.200
     1.928     7.278     0.200
     2.010     8.416     0.200
     2.192     8.292     0.200
     2.239     9.042     0.200
     2.288     8.864     0.200
     2.250     9.216     0.200
     2.200     9.398     0.200
     2.347     9.782     0.200
     2.439     8.409     0.200
     2.569     7.495     0.200
     2.784    10.183     0.200
     2.847    10.256     0.200
     2.880     9.566     0.200
     2.873    10.537     0.200
     3.210    10.418     0.200
     3.254    11.091     0.200
     3.382    11.504     0.200
     3.603    14.227     0.200
     3.716    12.507     0.200
     3.903    12.730     0.200
     4.372    13.257     0.200
     4.576    15.274     0.200
     4.620    14.965     0.200
     4.858    16.084     0.200
     5.034    14.826     0.200
     6.296    16.302     0.200
     6.711    18.157     0.200
     0.544     5.291     0.200
     0.623     4.573     0.200
     0.929     5.800     0.200
     1.075     6.300     0.200
     1.099     6.913     0.200
     1.248     5.971     0.200
     1.285     6.345     0.200
     1.323     6.100     0.200
     1.313     7.715     0.200
     1.497     6.866     0.200
     1.482     6.939     0.200
     1.662     6.944     0.200
     1.665     8.716     0.200
     1.813     7.987     0.200
     1.821     8.086     0.200
     1.894     8.233     0.200
     1.835     8.422     0.200
     2.031     8.235     0.200
     2.028     8.369     0.200
     1.977     8.371     0.200
     2.008     7.609     0.200
     2.087     8.979     0.200
     2.380     8.661     0.200
     2.475     9.357     0.200
     2.461     9.923     0.200
     2.512     9.028     0.200
     2.739    10.276     0.200
     2.832    10.587     0.200
     2.958    10.314     0.200
     3.248    11.632     0.200
     3.468    12.169     0.200
     3.915    13.545     0.200
     0.239     4.608     0.200
     0.396     4.167     0.200
     0.456     4.572     0.200
     0.691     5.733     0.200
     0.728     6.098     0.200
     0.788     3.690     0.200
     0.960     5.492     0.200
     1.220     6.660     0.200
     1.276     7.004     0.200
     1.285     6.096     0.200
     1.354     6.791     0.200
     1.481     7.212     0.200
     1.529     6.347     0.200
     1.547     7.335     0.200
     1.625     8.030     0.200
     1.626     6.920     0.200
     1.647     7.374     0.200
     1.687     7.706     0.200
     1.843     7.678     0.200
     1.881     8.040     0.200
     2.080     9.117     0.200
     2.123     8.712     0.200
     2.131     9.219     0.200
     2.133     9.295     0.200
     2.134     6.986     0.200
     2.268     8.529     0.200
     2.272     9.481     0.200
     2.306     8.678     0.200
     2.380     8.819     0.200
     2.403     9.547     0.200
     2.409    10.074     0.200
     2.471     9.956     0.200
     2.821    10.067     0.200
     2.942    11.264     0.200
     3.050     9.699     0.200
     3.169    10.507     0.200
     3.294    10.853     0.200
     3.558    10.972     0.200
     3.596    12.723     0.200
     3.795    11.698     0.200
     4.229    12.238     0.200
     4.503    14.236     0.200
     4.838    15.334     0.200
     4.928    13.384     0.200
     5.378    14.131     0.200
     5.383    16.169     0.200
     5.648    14.577     0.200
     1.142     7.374     0.200
     1.136     6.945     0.200
     1.191     7.009     0.200
     1.365     7.273     0.200
     1.388     7.707     0.200
     1.429     7.529     0.200
     1.705     8.904     0.200
     1.836     9.580     0.200
     1.846     9.157     0.200
     1.851     9.000     0.200
     1.890     9.653     0.200
     1.949     9.662     0.200
     1.978     9.622     0.200
     2.067     8.881     0.200
     2.461    10.986     0.200
     2.517    11.232     0.200
     2.530    11.383     0.200
     2.593     9.940     0.200
     2.746    10.862     0.200
     2.951    12.166     0.200
     3.216    14.171     0.200
     0.271     4.382     0.200
     0.352     4.039     0.200
     0.390     3.396     0.200
     0.780     5.747     0.200
     0.838     5.766     0.200
     0.981     4.003     0.200
     1.097     5.646     0.200
     1.319     6.252     0.200
     1.399     7.118     0.200
     1.409     6.802     0.200
     1.545     7.413     0.200
     1.604     6.625     0.200
     1.633     7.492     0.200
     1.654     7.144     0.200
     1.725     7.523     0.200
     1.717     7.009     0.200
     1.809     8.831     0.200
     1.837     7.809     0.200
     1.851     7.941     0.200
     1.880     8.107     0.200
     2.166     7.471     0.200
     2.175     9.374     0.200
     2.181     8.691     0.200
     2.186     9.434     0.200
     2.257     8.712     0.200
     2.327    10.099     0.200
     2.334     9.517     0.200
     2.354     9.580     0.200
     2.413     9.390     0.200
     2.427    10.021     0.200
     2.550     9.185     0.200
     2.694    10.104     0.200
     2.791    10.673     0.200
     2.846    10.439     0.200
     2.899     9.515     0.200
     2.930    10.253     0.200
     3.034    10.347     0.200
     3.157    10.605     0.200
     3.405    10.516     0.200
     3.477    12.071     0.200
     3.652    11.221     0.200
     4.077    11.862     0.200
     4.366    13.599     0.200
     5.226    14.555     0.200
     5.496    15.509     0.200
     6.529    17.955     0.200
     0.124     6.855     0.200
     0.542     6.175     0.200
     0.635     5.490     0.200
     0.814     5.901     0.200
     0.970     6.583     0.200
     1.077     6.624     0.200
     1.184     6.775     0.200
     1.242     6.704     0.200
     1.288     6.364     0.200
     1.499     7.703     0.200
     1.528     8.461     0.200
     1.688     7.100     0.200
     1.735     7.551     0.200
     1.752     8.353     0.200
     1.765     8.502     0.200
     1.767     9.283     0.200
     1.845     8.362     0.200
     1.931     8.765     0.200
     1.996     8.300     0.200
     2.100     8.685     0.200
     2.118    10.086     0.200
     2.469     9.987     0.200
     2.444     9.371     0.200
     2.545    10.401     0.200
     2.829    10.880     0.200
     3.035    11.479     0.200
     0.267     7.138     0.200
     0.366     5.587     0.200
     0.361     5.849     0.200
     0.813     7.375     0.200
     0.799     6.529     0.200
     0.971     5.031     0.200
     1.111     6.100     0.200
     1.374     7.221     0.200
     1.345     6.664     0.200
     1.398     7.147     0.200
     1.544     7.446     0.200
     1.576     6.865     0.200
     1.625     7.789     0.200
     1.644     7.770     0.200
     1.730     7.674     0.200
     1.738     7.477     0.200
     1.795     8.810     0.200
     1.811     8.031     0.200
     1.823     8.188     0.200
     1.877     8.264     0.200
     2.153     8.837     0.200
     2.163     8.818     0.200
     2.195     9.343     0.200
     2.192     7.979     0.200
     2.238     9.636     0.200
     2.326     9.520     0.200
     2.384     9.535     0.200
     2.401    10.047     0.200
     2.677     9.926     0.200
     2.824     9.606     0.200
     2.886     9.183     0.200
     3.018    10.042     0.200
     3.141    10.508     0.200
     3.392    10.874     0.200
     3.459    12.803     0.200
     3.638    11.110     0.200
     4.065    11.730     0.200
     4.768    13.115     0.200
     5.214    14.016     0.200
     5.483    15.570     0.200
     0.817     6.836     0.200
     0.999     6.113     0.200
     1.130     6.985     0.200
     1.181     7.496     0.200
     1.324     7.623     0.200
     1.355     7.665     0.200
     1.427     7.817     0.200
     1.594     8.969     0.200
     1.694     9.598     0.200
     1.720    10.101     0.200
     1.747     9.988     0.200
     1.755     9.996     0.200
     1.804     8.118     0.200
     1.893     9.782     0.200
     2.033    11.243     0.200
     2.081     9.193     0.200
     2.544    10.683     0.200
     2.522    11.638     0.200
     2.575    11.321     0.200
     2.649    10.064     0.200
     2.856    11.249     0.200
     2.914    11.863     0.200
     3.042    12.276     0.200
     3.284    13.152     0.200
     3.364    13.322     0.200
     3.559    13.133     0.200
     4.023    14.329     0.200
     0.233     7.535     0.200
     0.309     6.138     0.200
     1.169     6.111     0.200
     1.347     7.126     0.200
     1.533     6.562     0.200
     1.578     7.331     0.200
     1.699     7.820     0.200
     1.748     8.057     0.200
     1.801     7.330     0.200
     1.776     7.733     0.200
     1.765     7.948     0.200
     1.907     8.197     0.200
     2.099     8.958     0.200
     2.103     8.611     0.200
     2.256     7.527     0.200
     2.259     9.393     0.200
     2.216     8.988     0.200
     2.217     8.175     0.200
     2.285     8.687     0.200
     2.337     9.676     0.200
     2.327     9.801     0.200
     2.336    10.088     0.200
     2.479     8.618     0.200
     2.496     9.522     0.200
     2.616     9.721     0.200
     2.711    10.108     0.200
     2.760    10.339     0.200
     2.740     9.776     0.200
     2.830     9.327     0.200
     2.841    10.502     0.200
     2.958    10.129     0.200
     3.082    10.486     0.200
     3.167    12.190     0.200
     3.191    11.915     0.200
     3.337    10.609     0.200
     3.397    11.813     0.200
     3.406    12.410     0.200
     3.580    11.471     0.200
     3.916    12.759     0.200
     4.009    11.668     0.200
     4.291    13.072     0.200
     4.461    14.191     0.200
     4.633    14.385     0.200
     4.711    13.273     0.200
     4.717    14.405     0.200
     5.158    13.857     0.200
     5.169    14.923     0.200
     5.428    14.109     0.200
     5.485    15.946     0.200
     5.783    17.365     0.200
     5.805    16.500     0.200
     5.951    15.104     0.200
     6.382    19.469     0.200
     6.450    15.482     0.200
     6.454    16.833     0.200
     6.829    18.351     0.200
     6.829    18.152     0.200
     6.829    18.652     0.200
     7.014    17.798     0.200
     7.033    16.778     0.200
     7.499    18.039     0.200
     7.493    20.912     0.200
     7.607    20.275     0.200
     7.699    18.709     0.200
     7.697    18.421     0.200
     7.954    17.832     0.200
     7.990    21.611     0.200
     7.992    23.590     0.200
     8.013    18.337     0.200
     8.115    21.351     0.200
     8.203    22.019     0.200
     8.691    23.925     0.200
     8.911    22.559     0.200
    11.215    27.873     0.200
    13.003    30.510     0.200
     0.238     7.335     0.200
     0.297     6.144     0.200
     0.430     5.692     0.200
     0.773     7.188     0.200
     0.869     6.665     0.200
     0.983     4.939     0.200
     1.172     6.127     0.200
     1.335     7.224     0.200
     1.418     6.860     0.200
     1.404     7.523     0.200
     1.520     6.866     0.200
     1.556     7.545     0.200
     1.575     7.529     0.200
     1.702     7.847     0.200
     1.738     7.928     0.200
     1.754     8.242     0.200
     1.775     7.593     0.200
     1.793     9.187     0.200
     1.903     8.402     0.200
     2.091     8.904     0.200
     2.090     8.613     0.200
     2.206     8.768     0.200
     2.266     8.472     0.200
     2.265     9.572     0.200
     2.272     9.092     0.200
     2.315     9.692     0.200
     2.327     9.749     0.200
     2.330    10.222     0.200
     2.476     8.512     0.200
     2.489     9.869     0.200
     2.611     9.636     0.200
     2.699     9.613     0.200
     2.736    10.075     0.200
     2.753    10.480     0.200
     2.827     9.313     0.200
     2.954    10.031     0.200
     3.078    10.286     0.200
     3.186    12.431     0.200
     3.335    10.792     0.200
     3.391    11.833     0.200
     3.577    11.467     0.200
     3.910    12.476     0.200
     4.007    11.751     0.200
     4.288    13.472     0.200
     4.455    14.017     0.200
     4.708    13.168     0.200
     5.156    13.745     0.200
     5.166    15.023     0.200
     5.426    13.992     0.200
     5.948    15.589     0.200
     6.450    16.934     0.200
     6.824    18.874     0.200
     6.824    18.573     0.200
     7.010    18.106     0.200
     0.697     5.414     0.200
     0.700     4.284     0.200
     0.823     5.549     0.200
     1.045     6.852     0.200
     1.042     5.485     0.200
     1.110     6.391     0.200
     1.203     6.415     0.200
     1.275     6.374     0.200
     1.376     7.588     0.200
     1.395     7.766     0.200
     1.508     7.545     0.200
     1.648     8.021     0.200
     1.673     8.023     0.200
     1.783     8.041     0.200
     1.975     9.300     0.200
     1.976     9.194     0.200
     2.087     9.488     0.200
     2.444     9.830     0.200
     2.580     8.935     0.200
     0.152     5.875     0.200
     0.487     5.866     0.200
     0.487     6.160     0.200
     0.518     5.301     0.200
     0.783     5.611     0.200
     0.963     6.308     0.200
     1.050     6.596     0.200
     1.187     6.196     0.200
     1.257     6.176     0.200
     1.359     6.583     0.200
     1.571     6.618     0.200
     1.609     6.966     0.200
     1.676     7.792     0.200
     1.683     8.206     0.200
     1.849     7.572     0.200
     1.887     7.732     0.200
     1.920     8.646     0.200
     2.419     8.518     0.200
     2.532     8.494     0.200
     2.623    10.334     0.200
     2.721    10.392     0.200
     2.891    10.007     0.200
     2.982    10.543     0.200
     3.109    10.969     0.200
     3.401    11.062     0.200
     0.368     6.426     0.200
     0.446     5.815     0.200
     0.762     5.822     0.200
     0.798     5.910     0.200
     1.005     6.097     0.200
     1.179     5.669     0.200
     1.178     6.578     0.200
     1.296     7.199     0.200
     1.350     8.172     0.200
     1.503     7.675     0.200
     1.524     7.038     0.200
     1.544     7.105     0.200
     1.593     7.629     0.200
     1.629     8.309     0.200
     1.857     8.246     0.200
     1.873     8.255     0.200
     2.026     8.881     0.200
     2.404    10.261     0.200
     2.469     9.901     0.200
     2.464    10.070     0.200
     2.609     9.477     0.200
     2.632     9.601     0.200
     2.682     9.527     0.200
     2.790    10.462     0.200
     3.030    10.658     0.200
     3.053    11.493     0.200
     3.048     9.458     0.200
     3.238    11.138     0.200
     3.380    10.582     0.200
     3.436    12.118     0.200
     3.550    11.888     0.200
     3.556    11.426     0.200
     3.675    12.141     0.200
     3.875    12.101     0.200
     4.030    13.083     0.200
     4.151    12.883     0.200
     4.547    12.659     0.200
     4.875    15.137     0.200
     5.104    15.363     0.200
     5.245    16.318     0.200
     5.266    14.466     0.200
     5.691    14.511     0.200
     5.740    17.034     0.200
     5.957    14.898     0.200
     6.480    16.397     0.200
     7.036    18.413     0.200
     0.312     5.912     0.200
     0.510     6.595     0.200
     0.549     6.149     0.200
     0.766     5.912     0.200
     0.893     6.132     0.200
     1.099     5.621     0.200
     1.156     7.764     0.200
     1.405     7.053     0.200
     1.442     7.323     0.200
     1.531     7.284     0.200
     1.617     7.281     0.200
     1.700     8.614     0.200
     1.796     7.394     0.200
     1.861     8.435     0.200
     1.883     8.279     0.200
     1.957     8.810     0.200
     2.213     9.624     0.200
     2.231     9.819     0.200
     2.395     9.901     0.200
     2.536     9.461     0.200
     2.539     9.825     0.200
     2.672     9.370     0.200
     2.802    10.657     0.200
     2.819     8.949     0.200
     2.998    10.564     0.200
     3.157    10.212     0.200
     3.187    11.261     0.200
     3.298    11.160     0.200
     3.322    10.984     0.200
     3.442    11.384     0.200
     3.656    11.287     0.200
     3.789    12.533     0.200
     3.924    12.160     0.200
     4.302    14.349     0.200
     4.329    12.236     0.200
     4.645    14.641     0.200
     4.861    14.825     0.200
     5.009    15.097     0.200
     5.044    14.283     0.200
     5.475    15.256     0.200
     5.515    15.695     0.200
     6.266    16.126     0.200
     6.808    17.697     0.200
     7.382    17.909     0.200
     0.236     7.490     0.200
     0.312     6.100     0.200
     0.987     4.928     0.200
     1.164     6.259     0.200
     1.404     6.853     0.200
     1.348     7.210     0.200
     1.409     7.298     0.200
     1.535     6.930     0.200
     1.575     7.365     0.200
     1.571     7.903     0.200
     1.695     7.862     0.200
     1.752     8.098     0.200
     1.771     7.770     0.200
     1.797     7.474     0.200
     1.769     8.201     0.200
     1.799     8.942     0.200
     1.904     8.327     0.200
     2.104     8.893     0.200
     2.106     8.671     0.200
     2.252     7.569     0.200
     2.254     9.439     0.200
     2.218     8.664     0.200
     2.287     9.158     0.200
     2.334    10.209     0.200
     2.330     9.651     0.200
     2.342    10.018     0.200
     2.484     8.557     0.200
     2.494     9.938     0.200
     2.621     9.659     0.200
     2.714    10.670     0.200
     2.736    10.110     0.200
     2.765    10.675     0.200
     2.834     9.266     0.200
     2.845    10.341     0.200
     2.963    10.266     0.200
     3.087    10.522     0.200
     3.188    12.642     0.200
     3.401    12.149     0.200
     3.585    11.109     0.200
     3.920    12.493     0.200
     4.014    11.904     0.200
     4.296    13.108     0.200
     4.466    14.230     0.200
     4.716    13.212     0.200
     5.163    13.597     0.200
     5.174    15.060     0.200
     5.433    14.145     0.200
     5.489    16.079     0.200
     5.955    15.140     0.200
     6.459    16.868     0.200
     6.834    19.988     0.200
     6.834    19.488     0.200
     7.019    20.434     0.200
     7.612    20.212     0.200
    12.627    29.880     0.200
     0.801     4.500     0.200
     1.095     7.063     0.200
     1.132     7.137     0.200
     1.219     6.522     0.200
     1.203     7.202     0.200
     1.447     7.952     0.200
     1.464     7.455     0.200
     1.564     8.785     0.200
     1.670     8.653     0.200
     1.778     6.684     0.200
     1.803     7.599     0.200
     2.006     8.134     0.200
     1.967     9.288     0.200
     2.199     9.180     0.200
     2.278     9.663     0.200
     2.239     8.808     0.200
     2.240     9.395     0.200
     2.432     9.865     0.200
     2.506     9.690     0.200
     2.629    10.059     0.200
     2.752    10.627     0.200
     2.746    11.897     0.200
     3.099     9.676     0.200
     3.234    11.403     0.200
     3.356    12.677     0.200
     3.449    10.894     0.200
     3.578    11.881     0.200
     3.702    12.036     0.200
     3.955    11.986     0.200
     4.011    13.437     0.200
     4.201    13.121     0.200
     4.531    14.265     0.200
     4.628    12.239     0.200
     4.912    14.719     0.200
     5.071    16.168     0.200
     5.251    15.365     0.200
     5.331    14.325     0.200
     5.777    15.432     0.200
     5.790    16.868     0.200
     6.046    15.581     0.200
     6.104    17.709     0.200
     6.569    16.476     0.200
     7.074    18.584     0.200
     7.441    20.907     0.200
     7.441    20.704     0.200
     7.633    20.162     0.200
     8.226    21.938     0.200
     8.605    23.613     0.200
    11.779    29.472     0.200
    13.048    31.865     0.200
     0.238     6.297     0.200
     0.256     7.181     0.200
     0.466     6.033     0.200
     1.575     8.194     0.200
     1.684     7.721     0.200
     1.695     7.392     0.200
     1.898     8.024     0.200
     2.045     9.003     0.200
     2.146     8.536     0.200
     2.215     8.520     0.200
     2.256     8.941     0.200
     2.319     7.112     0.200
     2.274     9.335     0.200
     2.465     9.203     0.200
     2.450     8.078     0.200
     2.577     9.595     0.200
     2.640     9.967     0.200
     2.734     9.464     0.200
     2.765     9.409     0.200
     2.710    10.948     0.200
     2.780    10.127     0.200
     2.803     9.260     0.200
     2.924    10.056     0.200
     3.048    10.304     0.200
     3.142    12.304     0.200
     3.176    12.114     0.200
     3.311    10.230     0.200
     3.351    11.270     0.200
     3.355    12.221     0.200
     3.549    10.957     0.200
     3.875    12.655     0.200
     3.983    11.797     0.200
     4.258    13.088     0.200
     4.417    13.831     0.200
     4.632    14.623     0.200
     4.594    14.458     0.200
     4.717    14.427     0.200
     4.681    12.944     0.200
     5.131    13.291     0.200
     5.137    14.026     0.200
     5.402    14.237     0.200
     5.447    16.301     0.200
     6.182    18.329     0.200
     6.336    17.328     0.200
     6.419    16.959     0.200
     6.421    15.344     0.200
     6.786    18.579     0.200
     6.786    18.079     0.200
     6.870    19.201     0.200
     6.870    19.402     0.200
     6.947    19.503     0.200
     6.977    18.349     0.200
     6.999    16.894     0.200
     7.149    19.546     0.200
     7.389    21.242     0.200
     7.446    21.378     0.200
     7.470    18.802     0.200
     7.570    20.030     0.200
     7.802    18.322     0.200
     7.922    19.228     0.200
     7.948    21.826     0.200
     7.984    18.006     0.200
     8.152    22.044     0.200
     8.171    18.724     0.200
     8.274    23.414     0.200
     8.446    21.114     0.200
     8.630    22.965     0.200
     8.642    24.526     0.200
     8.767    23.362     0.200
     8.869    23.068     0.200
     9.013    22.990     0.200
     9.037    26.411     0.200
     9.126    25.372     0.200
     9.257    22.249     0.200
     9.457    25.905     0.200
     9.492    24.406     0.200
     9.568    22.916     0.200
     9.645    26.923     0.200
    10.032    28.602     0.200
    10.033    26.389     0.200
    10.508    26.849     0.200
    11.027    27.494     0.200
    11.158    28.258     0.200
    12.365    25.978     0.200
    12.555    29.160     0.200
    12.933    30.141     0.200
    14.435    31.019     0.200
    17.637    33.653     0.200
     0.235     6.620     0.200
     0.438     6.955     0.200
     0.581     6.776     0.200
     0.607     6.575     0.200
     0.933     6.369     0.200
     1.002     4.966     0.200
     1.093     6.805     0.200
     1.437     7.591     0.200
     1.490     7.377     0.200
     1.481     7.482     0.200
     1.509     7.356     0.200
     1.551     8.157     0.200
     1.617     7.491     0.200
     1.856     8.399     0.200
     1.875     8.480     0.200
     1.939     7.433     0.200
     1.966     9.314     0.200
     2.073     9.374     0.200
     2.065     9.069     0.200
     2.325     9.830     0.200
     2.396     9.702     0.200
     2.406     9.780     0.200
     2.731     8.598     0.200
     2.893    10.306     0.200
     3.074    10.192     0.200
     3.224    10.535     0.200
     3.346    11.115     0.200
     3.577    11.523     0.200
     3.680    12.318     0.200
     3.835    12.211     0.200
     4.250    12.167     0.200
     0.390     3.984     0.200
     0.532     4.226     0.200
     0.559     4.208     0.200
     0.790     5.719     0.200
     0.875     5.625     0.200
     0.891     5.832     0.200
     0.982     5.879     0.200
     1.048     6.604     0.200
     1.218     5.921     0.200
     1.175     7.628     0.200
     1.342     7.678     0.200
     1.340     7.593     0.200
     1.483     6.432     0.200
     1.531     6.267     0.200
     1.668     7.369     0.200
     1.826     7.630     0.200
     1.853     8.413     0.200
     1.914     7.898     0.200
     2.206     9.288     0.200
     2.306     9.423     0.200
     2.352     7.982     0.200
     2.956    11.243     0.200
     3.451    12.861     0.200
     4.425    15.193     0.200
     0.247     7.329     0.200
     0.409     5.848     0.200
     1.014     4.683     0.200
     1.114     6.317     0.200
     1.317     6.846     0.200
     1.429     7.536     0.200
     1.443     7.373     0.200
     1.575     7.434     0.200
     1.652     7.931     0.200
     1.628     6.912     0.200
     1.668     7.846     0.200
     1.724     7.494     0.200
     1.750     7.893     0.200
     1.843     8.309     0.200
     1.843     8.606     0.200
     1.866     8.242     0.200
     1.911     8.213     0.200
     2.162     7.583     0.200
     2.182     9.450     0.200
     2.184     9.135     0.200
     2.202     9.018     0.200
     2.294     9.042     0.200
     2.360    10.079     0.200
     2.379     9.453     0.200
     2.427     9.893     0.200
     2.534     8.644     0.200
     2.530     9.593     0.200
     2.683    10.009     0.200
     2.737     9.870     0.200
     2.811    10.313     0.200
     2.841    10.564     0.200
     2.881     9.389     0.200
     2.932    10.495     0.200
     3.020    10.271     0.200
     3.143    10.639     0.200
     3.192    12.364     0.200
     3.202    12.349     0.200
     3.387    10.690     0.200
     3.467    12.157     0.200
     3.491    12.275     0.200
     3.637    11.574     0.200
     3.984    12.019     0.200
     4.060    11.639     0.200
     4.351    13.134     0.200
     4.534    14.304     0.200
     4.699    14.476     0.200
     4.706    14.800     0.200
     4.766    13.202     0.200
     4.860    15.003     0.200
     5.209    13.430     0.200
     5.227    15.312     0.200
     5.478    13.984     0.200
     5.549    16.261     0.200
     5.674    16.796     0.200
     6.001    15.378     0.200
     6.515    17.289     0.200
     6.800    16.465     0.200
     6.901    19.484     0.200
     6.901    17.484     0.200
     7.077    19.621     0.200
     7.092    17.350     0.200
     7.498    21.110     0.200
     7.671    20.396     0.200
     7.742    19.271     0.200
     7.794    18.060     0.200
     8.889    24.581     0.200
    12.723    29.733     0.200
    13.095    29.694     0.200
    17.772    33.514     0.200
     0.651     5.180     0.200
     0.877     6.547     0.200
     1.061     7.098     0.200
     1.100     5.939     0.200
     1.235     6.763     0.200
     1.251     6.674     0.200
     1.365     8.248     0.200
     1.404     8.794     0.200
     1.445     6.914     0.200
     1.546     6.936     0.200
     1.656     8.750     0.200
     1.650     8.622     0.200
     1.705     7.977     0.200
     1.746     8.294     0.200
     1.841     8.392     0.200
     1.959     7.912     0.200
     1.993    10.115     0.200
     2.003     8.706     0.200
     1.999     9.045     0.200
     2.402     9.449     0.200
     2.529     8.366     0.200
     2.575    10.830     0.200
     2.639    10.382     0.200
     2.661    10.427     0.200
     2.684    10.953     0.200
     2.936    10.610     0.200
     3.006    11.498     0.200
     3.133    11.813     0.200
     3.385    13.768     0.200
     3.909    15.260     0.200
     4.107    14.444     0.200
     4.423    15.864     0.200
     4.783    15.158     0.200
     6.792    22.911     0.200
     0.257     7.417     0.200
     0.373     5.567     0.200
     0.364     5.974     0.200
     0.804     6.737     0.200
     0.981     4.671     0.200
     1.118     6.180     0.200
     1.382     7.596     0.200
     1.409     7.288     0.200
     1.347     6.808     0.200
     1.554     7.091     0.200
     1.582     6.965     0.200
     1.652     7.842     0.200
     1.627     7.837     0.200
     1.739     7.728     0.200
     1.742     7.587     0.200
     1.805     8.852     0.200
     1.825     8.533     0.200
     1.810     8.300     0.200
     1.887     8.306     0.200
     2.157     8.852     0.200
     2.200     9.453     0.200
     2.160     9.024     0.200
     2.248     8.688     0.200
     2.194     7.729     0.200
     2.328    10.157     0.200
     2.332     9.115     0.200
     2.386     9.779     0.200
     2.529     8.215     0.200
     2.671     9.958     0.200
     2.820    10.718     0.200
     2.903    10.454     0.200
     2.878     9.334     0.200
     3.011    10.284     0.200
     3.134    10.548     0.200
     3.384    10.628     0.200
     3.453    12.229     0.200
     3.631    11.357     0.200
     4.057    11.882     0.200
     4.343    13.539     0.200
     4.518    14.399     0.200
     4.688    14.623     0.200
     4.761    13.271     0.200
     5.206    13.575     0.200
     6.506    17.397     0.200
     0.186     5.427     0.200
     0.438     5.785     0.200
     0.619     4.269     0.200
     0.633     5.213     0.200
     0.698     4.956     0.200
     0.772     5.180     0.200
     1.046     6.484     0.200
     1.070     6.709     0.200
     1.076     5.644     0.200
     1.146     6.726     0.200
     1.224     6.615     0.200
     1.334     6.823     0.200
     1.333     6.743     0.200
     1.416     7.468     0.200
     1.476     7.476     0.200
     1.671     7.098     0.200
     1.780     8.722     0.200
     1.880     8.155     0.200
     1.911     9.392     0.200
     1.908     7.026     0.200
     2.073     8.407     0.200
     2.119     8.168     0.200
     2.163     9.149     0.200
     2.228     8.799     0.200
     2.300     9.155     0.200
     2.375     8.883     0.200
     2.584    10.742     0.200
     2.624     9.771     0.200
     3.032    10.010     0.200
     3.153    11.203     0.200
     3.259    12.167     0.200
     3.385    10.893     0.200
     3.503    11.517     0.200
     3.628    11.764     0.200
     3.893    12.370     0.200
     3.925    14.298     0.200
     4.130    12.598     0.200
     4.564    13.232     0.200
     4.837    14.745     0.200
     0.372     4.965     0.200
     0.595     5.067     0.200
     0.715     4.764     0.200
     0.721     5.589     0.200
     0.709     5.936     0.200
     0.961     6.596     0.200
     1.037     6.106     0.200
     1.082     5.675     0.200
     1.045     6.411     0.200
     1.064     7.591     0.200
     1.095     6.123     0.200
     1.310     7.420     0.200
     1.387     6.521     0.200
     1.374     7.474     0.200
     1.471     7.632     0.200
     1.567     7.020     0.200
     1.530     7.352     0.200
     1.642     8.947     0.200
     1.721     8.128     0.200
     1.760     7.868     0.200
     1.765     7.610     0.200
     1.772     8.334     0.200
     2.094     8.568     0.200
     2.150     9.218     0.200
     2.265     8.783     0.200
     2.263     9.895     0.200
     2.489     7.956     0.200
     2.864    10.481     0.200
     2.902    10.943     0.200
     2.943    10.264     0.200
     2.946    10.623     0.200
     3.264    10.413     0.200
     3.316    11.104     0.200
     3.444    12.613     0.200
     3.672    13.558     0.200
     4.429    13.519     0.200
     4.692    15.650     0.200
     5.096    14.441     0.200
     6.779    18.003     0.200
     0.179     6.671     0.200
     0.255     6.789     0.200
     0.558     5.555     0.200
     1.006     6.938     0.200
     1.010     5.686     0.200
     1.255     7.115     0.200
     1.292     6.292     0.200
     1.405     6.670     0.200
     1.415     7.758     0.200
     1.415     6.950     0.200
     1.563     7.020     0.200
     1.592     7.594     0.200
     1.613     7.649     0.200
     1.634     8.007     0.200
     1.784     8.948     0.200
     1.811     7.934     0.200
     1.860     8.158     0.200
     1.945     8.071     0.200
     1.950     8.916     0.200
     1.952     8.591     0.200
     1.961     8.378     0.200
     2.132     8.292     0.200
     2.159     8.769     0.200
     2.174     9.400     0.200
     2.347    10.180     0.200
     2.368     9.230     0.200
     2.401     9.948     0.200
     2.411     8.229     0.200
     2.489     9.718     0.200
     2.723     9.297     0.200
     2.789    10.521     0.200
     2.837    10.256     0.200
     2.962    10.401     0.200
     3.219    12.502     0.200
     3.231    11.261     0.200
     3.465    10.931     0.200
     3.902    11.936     0.200
     4.598    13.108     0.200
     0.083     5.849     0.200
     0.355     5.064     0.200
     0.642     4.820     0.200
     0.993     5.420     0.200
     1.094     6.446     0.200
     1.157     6.709     0.200
     1.289     5.973     0.200
     1.297     6.276     0.200
     1.380     7.502     0.200
     1.494     6.772     0.200
     1.668     6.745     0.200
     1.638     7.793     0.200
     1.733     8.893     0.200
     1.864     8.059     0.200
     1.841     7.727     0.200
     1.866     8.234     0.200
     1.889     8.274     0.200
     1.943     8.933     0.200
     2.031     7.613     0.200
     2.035     8.162     0.200
     2.043     8.868     0.200
     2.055     8.325     0.200
     2.328     8.343     0.200
     2.314    10.003     0.200
     2.431     9.744     0.200
     2.444     9.590     0.200
     2.485     9.807     0.200
     2.446     9.863     0.200
     2.517     7.938     0.200
     2.537    10.307     0.200
     2.588     9.614     0.200
     2.686     9.470     0.200
     2.785    10.306     0.200
     2.785    10.709     0.200
     2.911    10.538     0.200
     3.195    11.026     0.200
     3.199    12.674     0.200
     3.198    12.494     0.200
     3.419    11.714     0.200
     3.721    13.685     0.200
     3.863    12.126     0.200
     4.120    13.431     0.200
     4.255    14.658     0.200
     4.445    17.040     0.200
     4.553    13.277     0.200
     5.002    15.438     0.200
     5.010    13.441     0.200
     5.281    14.180     0.200
     5.803    14.892     0.200
     6.278    17.043     0.200
     6.626    19.789     0.200
     6.626    19.788     0.200
     7.278    24.473     0.200
     0.229     6.671     0.200
     0.483     6.509     0.200
     0.544     6.698     0.200
     0.714     6.309     0.200
     0.851     6.215     0.200
     1.017     5.678     0.200
     0.980     6.308     0.200
     1.400     7.304     0.200
     1.401     7.091     0.200
     1.449     7.636     0.200
     1.459     7.518     0.200
     1.559     7.350     0.200
     1.810     8.420     0.200
     1.874     9.069     0.200
     1.826     7.332     0.200
     1.858     9.355     0.200
     2.317    10.304     0.200
     2.455     9.595     0.200
     2.519    10.141     0.200
     2.605     9.342     0.200
     2.999    10.539     0.200
     3.172     9.722     0.200
     3.328    10.800     0.200
     3.450    11.585     0.200
     3.674    10.972     0.200
     3.936    12.212     0.200
     4.347    12.216     0.200
     4.655    14.015     0.200
     5.059    14.698     0.200
     0.079     5.850     0.200
     0.359     4.982     0.200
     0.643     4.771     0.200
     1.153     6.713     0.200
     1.285     6.072     0.200
     1.294     6.371     0.200
     1.378     7.299     0.200
     1.485     6.543     0.200
     1.492     6.466     0.200
     1.636     7.778     0.200
     1.670     6.687     0.200
     1.729     8.592     0.200
     1.864     8.026     0.200
     1.866     8.002     0.200
     1.887     8.351     0.200
     1.941     9.324     0.200
     1.943     7.804     0.200
     2.032     7.565     0.200
     2.031     8.066     0.200
     2.040     8.370     0.200
     2.053     8.112     0.200
     2.329     8.194     0.200
     2.312    10.399     0.200
     2.431     9.502     0.200
     2.443     9.158     0.200
     2.441     9.491     0.200
     2.486     9.557     0.200
     2.519     7.380     0.200
     2.537    10.274     0.200
     2.587     9.792     0.200
     2.687     9.816     0.200
     2.786    10.056     0.200
     2.783    10.695     0.200
     2.912    10.190     0.200
     3.167    11.611     0.200
     3.196    10.872     0.200
     3.200    12.035     0.200
     3.195    12.383     0.200
     3.420    10.967     0.200
     3.721    12.547     0.200
     3.864    12.074     0.200
     4.121    12.889     0.200
     4.255    14.416     0.200
     4.445    14.796     0.200
     4.554    13.229     0.200
     5.003    14.789     0.200
     5.011    13.587     0.200
     5.282    13.926     0.200
     5.301    15.804     0.200
     5.368    16.532     0.200
     5.804    14.643     0.200
     6.279    16.701     0.200
     6.626    20.154     0.200
     6.626    17.747     0.200
     6.787    18.778     0.200
     6.832    17.947     0.200
     6.861    17.003     0.200
     7.278    23.134     0.200
     7.795    22.102     0.200
    12.351    30.845     0.200
     0.375     4.027     0.200
     0.406     3.758     0.200
     0.572     3.930     0.200
     0.649     5.236     0.200
     0.773     5.375     0.200
     0.950     5.418     0.200
     0.994     6.403     0.200
     1.058     6.557     0.200
     1.186     6.054     0.200
     1.352     6.031     0.200
     1.390     7.480     0.200
     1.425     7.273     0.200
     1.430     7.314     0.200
     1.503     7.961     0.200
     1.541     6.326     0.200
     1.669     6.830     0.200
     1.733     6.974     0.200
     1.832     7.325     0.200
     1.891     8.428     0.200
     1.918     9.420     0.200
     1.973     8.979     0.200
     2.079     9.131     0.200
     2.112     9.746     0.200
     2.244     7.311     0.200
     2.272     8.883     0.200
     2.786    10.693     0.200
     2.877    10.625     0.200
     2.951    11.957     0.200
     3.363    11.056     0.200
     3.637    13.660     0.200
     3.873    12.602     0.200
     4.321    12.971     0.200
     0.139     6.992     0.200
     0.379     6.696     0.200
     0.726     6.243     0.200
     0.738     5.805     0.200
     0.893     5.292     0.200
     0.907     5.337     0.200
     0.939     5.965     0.200
     1.274     7.144     0.200
     1.315     6.474     0.200
     1.334     7.345     0.200
     1.410     7.357     0.200
     1.424     7.394     0.200
     1.566     7.837     0.200
     1.676     8.259     0.200
     2.223     8.678     0.200
     4.090    13.891     0.200
     4.401    12.756     0.200
     4.401    13.955     0.200
     6.572    17.419     0.200
     7.311    18.798     0.200
     7.311    19.197     0.200
     8.300    21.956     0.200
     9.531    25.787     0.200
     9.909    20.875     0.200
    10.561    27.870     0.200
    10.741    26.272     0.200
    12.659    30.887     0.200
    13.056    28.953     0.200
    13.266    32.306     0.200
    16.108    35.142     0.200
    17.584    34.806     0.200
    17.814    35.225     0.200
    20.067    35.836     0.200
     0.349     5.552     0.200
     0.311     6.486     0.200
     0.331     5.955     0.200
     0.708     6.056     0.200
     0.793     6.468     0.200
     0.918     5.014     0.200
     1.090     6.105     0.200
     1.323     7.584     0.200
     1.344     7.542     0.200
     1.356     6.703     0.200
     2.646    10.042     0.200
     4.513    14.758     0.200
     4.635    16.027     0.200
     4.635    17.327     0.200
     4.635    15.327     0.200
     6.904    17.857     0.200
     6.904    18.357     0.200
     8.547    24.078     0.200
    12.660    30.184     0.200
    17.664    34.088     0.200
     0.307     6.781     0.200
     0.343     5.762     0.200
     0.345     6.049     0.200
     0.721     6.056     0.200
     0.785     6.704     0.200
     0.926     4.961     0.200
     1.085     6.200     0.200
     1.345     6.677     0.200
     1.337     7.566     0.200
     1.353     7.478     0.200
     1.833     8.282     0.200
     2.637     9.594     0.200
     4.504    14.910     0.200
     4.639    14.734     0.200
     6.910    18.832     0.200
     6.910    19.129     0.200
     8.550    23.691     0.200
     9.558    21.027     0.200
    12.673    30.079     0.200
    16.134    34.183     0.200
     0.240     4.426     0.200
     0.398     4.081     0.200
     0.595     4.180     0.200
     0.689     5.687     0.200
     0.752     3.847     0.200
     0.945     5.497     0.200
     1.183     6.619     0.200
     1.247     7.071     0.200
     1.292     5.747     0.200
     2.547     9.397     0.200
     4.411    15.250     0.200
     4.459    13.888     0.200
     4.459    15.188     0.200
     6.616    18.511     0.200
     7.039    19.279     0.200
     7.039    19.378     0.200
     8.371    22.838     0.200
    10.370    28.404     0.200
     0.134     6.618     0.200
     0.356     6.325     0.200
     0.614     5.513     0.200
     0.739     5.853     0.200
     0.751     5.417     0.200
     0.725     4.913     0.200
     0.985     5.783     0.200
     1.149     6.774     0.200
     1.148     6.978     0.200
     1.224     6.898     0.200
     1.262     6.655     0.200
     1.279     6.456     0.200
     1.439     7.383     0.200
     1.489     7.600     0.200
     2.209     9.206     0.200
     4.071    14.376     0.200
     4.233    13.076     0.200
     7.376    21.802     0.200
     8.137    22.720     0.200
    10.569    28.337     0.200
    20.107    38.328     0.200
     0.284     6.526     0.200
     0.370     5.521     0.200
     0.329     5.905     0.200
     0.811     6.476     0.200
     0.944     5.124     0.200
     1.113     6.156     0.200
     1.337     7.736     0.200
     1.367     6.490     0.200
     1.369     7.661     0.200
     1.855     8.493     0.200
     2.662     9.578     0.200
     4.529    14.792     0.200
     4.663    15.226     0.200
     4.663    17.527     0.200
     6.820    19.444     0.200
     6.883    18.315     0.200
     6.883    19.316     0.200
     8.298    21.804     0.200
     8.574    23.380     0.200
     9.639    26.750     0.200
    10.096    25.819     0.200
    10.527    27.985     0.200
    10.980    28.101     0.200
    12.264    28.024     0.200
    12.654    30.064     0.200
    12.750    29.849     0.200
    13.005    30.474     0.200
    13.313    30.082     0.200
    14.516    32.839     0.200
    15.184    32.239     0.200
    16.148    34.396     0.200
    17.681    34.840     0.200
     0.331     5.966     0.200
     0.351     5.728     0.200
     0.308     6.626     0.200
     0.710     6.137     0.200
     0.795     6.647     0.200
     0.921     5.083     0.200
     1.092     6.180     0.200
     1.324     7.570     0.200
     1.346     7.513     0.200
     1.357     6.590     0.200
     2.648     9.525     0.200
     4.515    14.540     0.200
     4.638    15.096     0.200
     4.638    17.096     0.200
     6.796    18.617     0.200
     6.901    17.988     0.200
     6.901    17.688     0.200
     6.901    18.288     0.200
     8.291    22.470     0.200
     8.550    23.249     0.200
     9.616    27.003     0.200
    10.086    25.524     0.200
    10.508    26.397     0.200
    10.956    27.370     0.200
    12.248    26.595     0.200
    12.659    29.696     0.200
    12.727    29.200     0.200
    12.997    29.953     0.200
    13.079    28.589     0.200
    14.511    32.480     0.200
    14.918    33.233     0.200
    15.542    34.055     0.200
    15.546    33.110     0.200
    16.126    34.032     0.200
    17.665    34.371     0.200
     0.285     6.537     0.200
     0.291     5.970     0.200
     0.396     5.648     0.200
     0.705     5.932     0.200
     0.841     6.555     0.200
     0.936     5.044     0.200
     1.135     6.122     0.200
     1.306     7.223     0.200
     1.358     7.418     0.200
     1.402     6.603     0.200
     2.694     9.430     0.200
     4.561    14.544     0.200
     4.667    14.997     0.200
     6.823    19.839     0.200
     6.857    17.749     0.200
     6.857    19.238     0.200
     8.262    22.345     0.200
     8.579    23.643     0.200
     9.514    20.836     0.200
     9.629    26.698     0.200
    10.063    28.834     0.200
    10.506    27.165     0.200
    10.982    28.710     0.200
    11.267    29.082     0.200
    12.293    28.302     0.200
    12.617    30.172     0.200
    12.738    32.817     0.200
    12.970    30.405     0.200
    13.125    32.296     0.200
    14.989    31.606     0.200
    15.545    35.051     0.200
    16.131    34.913     0.200
    20.732    38.824     0.200
     0.331     6.361     0.200
     0.547     5.632     0.200
     0.565     5.634     0.200
     1.049     6.080     0.200
     1.134     5.786     0.200
     1.215     7.240     0.200
     1.227     6.398     0.200
     1.290     5.768     0.200
     1.405     5.822     0.200
     1.472     7.640     0.200
     1.497     7.348     0.200
     1.582     7.955     0.200
     1.627     8.431     0.200
     1.896     7.694     0.200
     3.758    13.470     0.200
     4.421    13.927     0.200
     7.599    18.637     0.200
    10.707    28.574     0.200
    11.516    28.730     0.200
    13.462    31.835     0.200
    13.658    33.031     0.200
    14.234    33.310     0.200
    15.228    33.413     0.200
    17.452    32.951     0.200
     0.151     6.934     0.200
     0.375     6.821     0.200
     0.747     5.682     0.200
     0.727     6.218     0.200
     0.905     5.230     0.200
     0.929     6.051     0.200
     0.918     5.190     0.200
     1.310     6.416     0.200
     1.345     7.203     0.200
     1.407     7.477     0.200
     1.418     7.351     0.200
     1.429     7.228     0.200
     1.578     7.576     0.200
     1.685     8.236     0.200
     2.216     8.736     0.200
     4.083    14.449     0.200
     4.406    13.184     0.200
     6.577    17.844     0.200
     7.315    18.727     0.200
     8.304    22.692     0.200
     9.539    25.574     0.200
     9.910    21.549     0.200
    10.572    28.028     0.200
    10.746    27.696     0.200
    11.821    28.142     0.200
    12.655    29.308     0.200
    12.667    30.967     0.200
    13.066    30.065     0.200
    14.922    32.758     0.200
    15.510    34.598     0.200
    15.544    33.501     0.200
    16.117    34.614     0.200
    17.585    34.671     0.200
     0.457     4.976     0.200
     0.737     5.208     0.200
     1.000     5.638     0.200
     1.073     6.888     0.200
     1.180     6.237     0.200
     1.182     6.718     0.200
     1.189     7.133     0.200
     1.953     9.118     0.200
     3.048    10.536     0.200
     4.792    15.784     0.200
     4.913    15.880     0.200
     6.553    20.238     0.200
     6.553    20.788     0.200
     8.703    24.442     0.200
     9.294    22.046     0.200
    10.351    30.117     0.200
    12.629    29.334     0.200
    15.035    33.108     0.200
    15.313    37.012     0.200
    18.160    36.388     0.200
     0.234     6.243     0.200
     0.312     6.433     0.200
     0.429     5.668     0.200
     0.660     5.666     0.200
     0.911     5.337     0.200
     0.879     6.509     0.200
     1.159     6.239     0.200
     1.250     6.880     0.200
     1.328     7.272     0.200
     1.444     6.514     0.200
     1.451     6.638     0.200
     1.501     7.050     0.200
     1.840     9.039     0.200
     2.735     9.944     0.200
     4.602    14.869     0.200
     4.660    15.088     0.200
     6.827    18.398     0.200
     6.827    19.632     0.200
     9.598    25.459     0.200
    10.004    27.820     0.200
    10.969    25.962     0.200
    12.330    28.080     0.200
    12.562    30.121     0.200
    12.704    29.412     0.200
    13.160    28.492     0.200
    13.238    30.338     0.200
    14.420    32.792     0.200
    15.178    32.883     0.200
    15.517    32.086     0.200
    17.598    35.002     0.200
     0.174     6.735     0.200
     0.481     5.752     0.200
     0.539     6.473     0.200
     0.608     6.069     0.200
     0.859     5.142     0.200
     0.881     6.185     0.200
     0.947     4.819     0.200
     1.076     6.112     0.200
     1.381     7.148     0.200
     1.473     6.675     0.200
     1.510     7.348     0.200
     1.519     7.945     0.200
     1.776     8.240     0.200
     2.376     8.843     0.200
     4.243    13.855     0.200
     4.530    12.799     0.200
     7.151    21.113     0.200
     7.151    19.801     0.200
     8.434    22.946     0.200
     9.752    22.164     0.200
    10.598    29.388     0.200
    10.865    26.767     0.200
    11.984    30.713     0.200
    12.739    31.305     0.200
    12.937    32.894     0.200
    15.352    31.956     0.200
     0.286     6.456     0.200
     0.363     5.556     0.200
     0.337     5.764     0.200
     0.732     5.957     0.200
     0.804     6.520     0.200
     0.944     4.983     0.200
     1.106     6.284     0.200
     1.343     7.526     0.200
     1.370     7.512     0.200
     1.359     6.442     0.200
     1.854     8.260     0.200
     2.654    11.030     0.200
     4.521    14.040     0.200
     4.660    14.618     0.200
     6.818    19.231     0.200
     6.890    18.389     0.200
     6.890    17.499     0.200
     8.571    23.567     0.200
     9.537    21.006     0.200
    10.102    27.199     0.200
    10.530    28.008     0.200
    10.978    27.478     0.200
    12.663    30.272     0.200
    12.663    29.929     0.200
    12.751    29.098     0.200
    13.012    30.051     0.200
    13.321    29.243     0.200
    14.523    32.706     0.200
    14.941    33.730     0.200
    15.188    32.348     0.200
    16.150    33.832     0.200
     0.629     4.676     0.200
     0.614     5.148     0.200
     0.732     4.665     0.200
     0.908     6.615     0.200
     1.059     6.350     0.200
     1.099     6.690     0.200
     1.119     5.959     0.200
     1.246     6.365     0.200
     1.252     6.707     0.200
     2.903    10.731     0.200
     4.524    15.014     0.200
     4.758    15.183     0.200
     6.771    20.695     0.200
     6.771    20.654     0.200
     8.435    22.378     0.200
     9.341    27.696     0.200
     9.550    22.464     0.200
    10.143    29.242     0.200
    10.798    30.199     0.200
    12.306    30.604     0.200
    12.436    31.879     0.200
    13.268    33.071     0.200
    14.584    34.020     0.200
    15.208    35.233     0.200
    15.236    34.602     0.200
    15.303    33.227     0.200
    17.259    37.198     0.200
    17.903    36.582     0.200
     0.148     7.652     0.200
     0.543     6.644     0.200
     0.577     6.147     0.200
     0.774     6.246     0.200
     0.961     6.174     0.200
     0.987     7.164     0.200
     1.096     6.094     0.200
     1.120     6.817     0.200
     1.223     7.310     0.200
     1.310     7.295     0.200
     1.347     7.162     0.200
     1.449     6.876     0.200
     1.566     7.399     0.200
     1.631     8.645     0.200
     1.678     7.904     0.200
     1.768     8.350     0.200
     1.911     8.782     0.200
     3.081    10.432     0.200
     4.751    14.938     0.200
     4.942    15.205     0.200
     6.550    17.946     0.200
     6.550    17.492     0.200
     6.878    18.613     0.200
     8.660    23.216     0.200
     9.318    19.844     0.200
     9.680    26.518     0.200
    10.267    27.365     0.200
    11.016    28.826     0.200
    12.181    30.488     0.200
    12.181    30.230     0.200
    12.569    30.504     0.200
    12.610    32.724     0.200
    15.356    33.781     0.200
    15.400    34.466     0.200
    15.952    34.221     0.200
    17.329    33.969     0.200
     0.230     6.404     0.200
     0.267     6.981     0.200
     0.268     7.464     0.200
     0.406     5.753     0.200
     0.722     5.963     0.200
     0.849     6.587     0.200
     0.955     5.056     0.200
     1.147     6.105     0.200
     1.320     7.396     0.200
     1.377     7.529     0.200
     1.405     6.695     0.200
     1.874     8.382     0.200
     2.700     9.484     0.200
     4.567    14.396     0.200
     4.685    14.918     0.200
     5.439    16.218     0.200
     6.846    18.071     0.200
     6.846    17.801     0.200
     6.846    18.337     0.200
     6.841    18.859     0.200
     8.272    22.163     0.200
     8.597    23.367     0.200
     9.500    21.285     0.200
     9.647    25.109     0.200
    10.074    25.427     0.200
    10.523    25.894     0.200
    11.000    26.326     0.200
    12.618    29.248     0.200
    12.618    29.939     0.200
    12.756    28.933     0.200
    12.981    29.213     0.200
    13.134    29.026     0.200
    13.274    29.736     0.200
    14.488    32.623     0.200
    14.940    32.651     0.200
    15.159    33.292     0.200
    15.159    33.289     0.200
    15.563    33.173     0.200
    15.572    32.673     0.200
    16.149    34.232     0.200
    16.620    33.540     0.200
     0.162     7.028     0.200
     0.305     6.858     0.200
     0.436     5.834     0.200
     0.664     6.066     0.200
     0.886     6.687     0.200
     0.918     5.404     0.200
     1.167     6.304     0.200
     1.252     7.210     0.200
     1.334     7.352     0.200
     1.457     6.924     0.200
     1.443     6.577     0.200
     1.848     8.552     0.200
     2.742     9.821     0.200
     4.608    14.541     0.200
     4.668    15.145     0.200
     6.820    18.955     0.200
     6.820    18.674     0.200
    10.005    24.859     0.200
    12.911    32.152     0.200
    17.601    34.785     0.200
    18.606    35.190     0.200
    19.556    35.249     0.200
     0.278     6.612     0.200
     0.318     5.847     0.200
     0.348     5.398     0.200
     0.778     6.479     0.200
     0.774     5.922     0.200
     0.971     4.822     0.200
     1.093     6.207     0.200
     1.321     6.442     0.200
     1.390     7.629     0.200
     1.400     7.517     0.200
     1.872     8.815     0.200
     2.622     9.657     0.200
     4.670    15.659     0.200
     6.913    20.286     0.200
     6.913    19.271     0.200
     0.253     6.230     0.200
     0.459     5.536     0.200
     0.578     5.748     0.200
     0.565     6.398     0.200
     0.938     5.450     0.200
     0.927     6.180     0.200
     1.031     5.051     0.200
     1.060     6.021     0.200
     1.466     7.582     0.200
     4.597    14.037     0.200
     7.137    19.296     0.200
     7.137    18.999     0.200
     0.220     6.597     0.200
     0.301     6.957     0.200
     0.387     5.752     0.200
     0.692     6.092     0.200
     0.834     6.639     0.200
     0.920     5.127     0.200
     1.124     6.246     0.200
     1.295     7.455     0.200
     1.343     7.496     0.200
     1.399     6.839     0.200
     1.840     8.193     0.200
     2.688     9.499     0.200
     4.555    14.114     0.200
     4.652    14.573     0.200
     4.652    14.456     0.200
     6.866    18.150     0.200
     6.866    18.142     0.200
     6.866    17.743     0.200
     6.866    18.790     0.200
     9.527    21.892     0.200
    10.053    25.841     0.200
    12.962    30.101     0.200
    13.286    29.927     0.200
    14.473    32.564     0.200
    17.640    34.898     0.200
     0.272     6.343     0.200
     0.342     5.716     0.200
     0.311     6.780     0.200
     0.715     6.162     0.200
     0.785     6.646     0.200
     0.921     5.064     0.200
     1.084     6.160     0.200
     1.332     7.566     0.200
     1.348     7.583     0.200
     1.346     6.600     0.200
     2.638     9.529     0.200
     4.504    15.344     0.200
     4.635    14.022     0.200
     6.910    18.159     0.200
     6.910    17.969     0.200
     6.910    18.469     0.200
     6.910    18.519     0.200
     8.546    22.876     0.200
    10.953    27.286     0.200
    13.006    29.334     0.200
    17.672    34.820     0.200
     0.160     8.854     0.200
     0.401     8.149     0.200
     0.618     7.009     0.200
     0.661     7.009     0.200
     0.756     7.201     0.200
     0.913     6.670     0.200
     0.937     6.184     0.200
     0.943     6.918     0.200
     1.366     7.780     0.200
     1.332     7.071     0.200
     1.445     7.854     0.200
     1.437     7.856     0.200
     1.458     7.703     0.200
     1.584     8.534     0.200
     2.236     8.932     0.200
     4.103    13.343     0.200
     4.435    14.461     0.200
     7.291    18.721     0.200
     7.291    18.831     0.200
     7.291    19.131     0.200
     7.291    18.530     0.200
    10.346    26.784     0.200
    10.346    23.424     0.200
    13.057    32.093     0.200
    13.284    29.197     0.200
    14.546    28.369     0.200
     0.231     6.673     0.200
     0.285     7.146     0.200
     0.391     5.810     0.200
     0.710     6.185     0.200
     0.835     6.723     0.200
     0.937     5.329     0.200
     1.131     6.274     0.200
     1.312     7.457     0.200
     1.360     7.497     0.200
     1.395     6.786     0.200
     1.855     8.218     0.200
     4.554    15.618     0.200
     4.667    15.411     0.200
     4.667    14.110     0.200
     6.862    18.103     0.200
     6.862    18.493     0.200
     6.862    18.294     0.200
     6.862    18.919     0.200
     8.578    25.457     0.200
     9.631    24.977     0.200
     9.517    20.800     0.200
    10.069    23.773     0.200
    12.740    31.893     0.200
    12.977    31.228     0.200
    14.925    33.894     0.200
    16.134    34.280     0.200
    17.658    35.116     0.200
     0.392     5.475     0.200
     0.439     5.625     0.200
     0.684     5.670     0.200
     0.835     5.612     0.200
     0.818     5.305     0.200
     0.836     5.301     0.200
     1.161     6.204     0.200
     1.143     5.308     0.200
     7.348    19.701     0.200
     7.348    19.498     0.200
     7.348    19.099     0.200
    10.577    30.217     0.200
    13.512    31.169     0.200
     0.408     5.505     0.200
     0.418     5.590     0.200
     0.718     5.287     0.200
     0.784     5.117     0.200
     0.814     5.467     0.200
     0.865     5.263     0.200
     1.161     5.516     0.200
     1.167     5.742     0.200
     1.256     5.810     0.200
     1.483     7.460     0.200
     1.567     7.277     0.200
     1.589     8.027     0.200
     1.616     7.705     0.200
     1.881     8.510     0.200
     3.977    16.552     0.200
     4.538    14.001     0.200
     7.382    19.319     0.200
     7.382    18.921     0.200
     7.382    18.819     0.200
     9.898    22.062     0.200
    13.532    34.449     0.200
    17.632    34.001     0.200
     0.195     6.811     0.200
     0.319     5.567     0.200
     0.427     5.195     0.200
     0.824     5.971     0.200
     0.848     6.387     0.200
     1.043     5.008     0.200
     1.172     6.313     0.200
     1.373     6.466     0.200
     1.951     8.621     0.200
     2.684     9.468     0.200
     4.752    14.630     0.200
     6.842    17.644     0.200
     6.842    18.745     0.200
     6.842    18.445     0.200
     9.463    21.897     0.200
    15.101    30.958     0.200
    15.101    30.956     0.200
    19.601    37.045     0.200
     0.160     7.032     0.200
     0.311     6.668     0.200
     0.434     5.926     0.200
     0.659     5.907     0.200
     0.885     6.774     0.200
     0.913     5.447     0.200
     1.164     6.210     0.200
     1.247     7.340     0.200
     1.329     7.491     0.200
     1.457     6.894     0.200
     1.843     8.690     0.200
     2.741     9.607     0.200
     4.607    13.727     0.200
     4.663    15.080     0.200
     4.663    15.611     0.200
     6.822    18.687     0.200
     6.822    18.386     0.200
     6.822    18.886     0.200
     6.815    18.263     0.200
     8.576    23.417     0.200
    10.001    27.866     0.200
    10.459    28.441     0.200
    10.459    28.941     0.200
    10.971    27.459     0.200
    12.556    30.765     0.200
    12.705    31.230     0.200
    13.232    30.332     0.200
    14.881    32.636     0.200
    15.175    31.105     0.200
    15.175    31.103     0.200
    15.517    34.807     0.200
    17.596    34.953     0.200
    19.558    35.709     0.200
     0.203     6.502     0.200
     0.258     7.160     0.200
     0.439     5.743     0.200
     0.716     5.710     0.200
     0.883     6.756     0.200
     0.963     4.931     0.200
     1.178     6.115     0.200
     1.302     6.972     0.200
     1.382     7.143     0.200
     1.487     6.317     0.200
     1.527     6.948     0.200
     1.441     6.954     0.200
     1.631     7.437     0.200
     1.714     7.464     0.200
     1.770     7.715     0.200
     1.834     7.859     0.200
     1.823     7.396     0.200
     1.888     8.187     0.200
     2.074     8.658     0.200
     2.173     8.112     0.200
     2.195     8.146     0.200
     2.293     9.302     0.200
     2.279     9.266     0.200
     2.289     7.459     0.200
     2.603     9.289     0.200
     2.810    10.070     0.200
     2.735     9.446     0.200
     3.072    10.012     0.200
     3.381    11.304     0.200
     3.449    11.913     0.200
     3.573    10.776     0.200
     3.901    12.041     0.200
     4.005    11.028     0.200
     4.282    12.498     0.200
     4.444    13.609     0.200
     4.620    13.751     0.200
     4.602    14.659     0.200
     4.704    14.676     0.200
     4.764    14.665     0.200
     5.161    14.337     0.200
     5.264    15.335     0.200
     5.765    17.286     0.200
     5.875    16.412     0.200
     6.208    17.225     0.200
     6.444    16.465     0.200
     6.813    17.756     0.200
     6.813    18.459     0.200
     6.813    17.858     0.200
     6.813    18.358     0.200
     6.858    19.335     0.200
     7.626    16.873     0.200
     7.696    17.653     0.200
     8.246    20.635     0.200
     8.301    21.691     0.200
     8.616    22.319     0.200
     9.309    24.125     0.200
     9.472    21.128     0.200
     9.652    27.026     0.200
    10.053    27.362     0.200
    10.516    24.145     0.200
    10.516    24.645     0.200
    11.016    26.315     0.200
    11.899    27.602     0.200
    12.336    26.405     0.200
    12.584    28.817     0.200
    12.759    30.767     0.200
    13.239    30.068     0.200
    13.168    27.597     0.200
    13.458    28.688     0.200
    13.800    32.218     0.200
    14.125    30.830     0.200
    14.937    32.849     0.200
    15.032    34.743     0.200
    15.032    34.442     0.200
    15.138    32.358     0.200
    15.138    32.356     0.200
    15.573    34.735     0.200
    16.148    34.918     0.200
    17.652    33.470     0.200
    17.652    34.767     0.200
    17.995    35.662     0.200
    19.557    35.386     0.200
    20.696    35.452     0.200
     0.245     7.638     0.200
     0.318     6.783     0.200
     0.436     7.599     0.200
     0.583     6.685     0.200
     0.769     7.019     0.200
     0.786     5.517     0.200
     1.026     6.514     0.200
     1.216     7.300     0.200
     1.211     7.359     0.200
     1.366     7.052     0.200
     1.456     6.901     0.200
     1.447     7.607     0.200
     1.566     7.715     0.200
     1.590     7.936     0.200
     1.607     8.540     0.200
     1.669     8.019     0.200
     1.704     8.350     0.200
     1.982     8.467     0.200
     2.071     8.418     0.200
     2.155     9.438     0.200
     2.539     9.964     0.200
     2.628     9.726     0.200
     3.233    10.160     0.200
     4.492    14.572     0.200
     4.519    13.950     0.200
     4.901    14.692     0.200
     5.316    12.456     0.200
     5.700    16.072     0.200
     6.022    16.110     0.200
     6.502    18.509     0.200
     6.674    18.609     0.200
     6.957    17.699     0.200
     6.957    17.999     0.200
     6.957    18.299     0.200
     7.118    18.823     0.200
     8.432    22.891     0.200
     9.481    24.846     0.200
     9.644    21.740     0.200
     9.984    26.778     0.200
     9.984    23.399     0.200
    10.376    25.399     0.200
    10.832    25.086     0.200
    11.120    30.821     0.200
    11.120    30.120     0.200
    12.099    28.591     0.200
    12.210    26.397     0.200
    12.581    29.576     0.200
    12.628    28.666     0.200
    12.592    28.547     0.200
    13.346    29.190     0.200
    14.157    31.581     0.200
    14.237    30.740     0.200
    14.355    31.673     0.200
    14.432    32.468     0.200
    14.802    31.049     0.200
    14.822    32.222     0.200
    14.783    32.472     0.200
    15.201    31.991     0.200
    15.321    32.200     0.200
    15.321    32.198     0.200
    15.407    33.296     0.200
    15.410    32.158     0.200
    15.991    34.276     0.200
    17.545    31.137     0.200
     0.190     6.767     0.200
     0.283     6.873     0.200
     0.427     5.694     0.200
     0.692     6.007     0.200
     0.874     6.573     0.200
     0.937     5.239     0.200
     1.163     6.201     0.200
     1.282     7.319     0.200
     1.356     7.355     0.200
     1.438     6.793     0.200
     1.863     8.485     0.200
     2.729    10.536     0.200
     4.680    14.391     0.200
     6.826    18.313     0.200
     6.826    18.524     0.200
     6.826    18.223     0.200
     0.465     5.005     0.200
     0.440     4.706     0.200
     0.808     6.105     0.200
     0.954     5.602     0.200
     1.139     4.936     0.200
     1.161     6.285     0.200
     1.283     6.164     0.200
     2.609     9.586     0.200
     4.473    16.633     0.200
     4.798    14.737     0.200
     4.798    15.291     0.200
     6.897    19.352     0.200
     6.897    19.649     0.200
     8.705    23.546     0.200
    13.219    31.162     0.200
    17.908    34.606     0.200
     0.267     6.165     0.200
     0.344     5.666     0.200
     0.314     6.516     0.200
     0.710     6.188     0.200
     0.788     6.586     0.200
     0.917     5.172     0.200
     1.085     6.215     0.200
     1.327     7.597     0.200
     1.344     7.597     0.200
     1.350     6.524     0.200
     1.827     8.408     0.200
     2.640     9.764     0.200
     4.507    14.480     0.200
     4.507    14.878     0.200
     4.633    14.911     0.200
     6.791    19.729     0.200
     6.909    18.531     0.200
     6.909    18.152     0.200
     6.909    18.351     0.200
     8.544    23.163     0.200
     9.560    22.007     0.200
    10.089    26.843     0.200
    10.089    27.441     0.200
    10.951    26.181     0.200
    11.231    28.914     0.200
    11.231    29.715     0.200
    12.665    28.473     0.200
    13.000    30.264     0.200
    13.333    29.627     0.200
    15.540    35.024     0.200
    17.667    33.409     0.200
    19.653    35.427     0.200
     0.272     6.079     0.200
     0.278     6.417     0.200
     0.368     5.461     0.200
     0.740     6.123     0.200
     0.807     6.442     0.200
     0.953     5.047     0.200
     1.112     6.190     0.200
     1.349     7.817     0.200
     1.379     7.670     0.200
     1.359     6.299     0.200
     1.552     6.851     0.200
     1.603     7.658     0.200
     1.605     7.525     0.200
     1.722     7.962     0.200
     1.746     7.085     0.200
     1.795     7.907     0.200
     1.862     8.476     0.200
     1.862     8.327     0.200
     2.153     8.540     0.200
     2.375     9.546     0.200
     2.656     9.463     0.200
     2.673     9.065     0.200
     2.891    10.120     0.200
     4.523    14.473     0.200
     4.668    14.988     0.200
     4.668    14.886     0.200
     5.336    15.890     0.200
     5.464    16.695     0.200
     5.649    15.935     0.200
     5.839    17.615     0.200
     6.503    18.964     0.200
     6.826    19.801     0.200
     6.886    18.571     0.200
     6.886    18.399     0.200
     6.886    18.102     0.200
     8.310    21.485     0.200
     9.530    20.594     0.200
    10.108    27.294     0.200
    10.108    25.169     0.200
    10.539    26.679     0.200
    10.986    24.251     0.200
    12.259    27.396     0.200
    12.664    28.430     0.200
    13.017    30.154     0.200
    13.319    30.680     0.200
    13.537    29.481     0.200
    14.957    33.709     0.200
    15.180    32.703     0.200
    15.181    32.701     0.200
    15.573    34.019     0.200
    17.693    33.770     0.200
    20.777    37.599     0.200
     0.549     4.561     0.200
     0.642     5.071     0.200
     0.944     5.348     0.200
     1.000     6.790     0.200
     1.888     9.179     0.200
     2.858    10.708     0.200
     4.719    16.206     0.200
     4.724    19.034     0.200
     6.716    21.362     0.200
     6.716    20.192     0.200
     6.716    21.292     0.200
     0.271     6.333     0.200
     0.298     5.818     0.200
     0.392     6.312     0.200
     0.646     6.149     0.200
     0.749     6.449     0.200
     0.838     5.007     0.200
     1.027     6.103     0.200
     1.266     7.416     0.200
     1.278     7.479     0.200
     1.332     6.344     0.200
     1.747     8.350     0.200
     2.607     9.165     0.200
     4.473    13.393     0.200
     4.555    14.032     0.200
     4.555    14.632     0.200
     5.379    14.820     0.200
     6.712    18.759     0.200
     6.959    18.684     0.200
     6.959    17.474     0.200
     8.467    21.982     0.200
    10.045    25.167     0.200
    10.438    27.980     0.200
    10.872    25.715     0.200
    12.199    28.535     0.200
    12.963    30.117     0.200
    15.466    34.705     0.200
    17.840    36.098     0.200
    17.840    35.308     0.200
     0.126     7.223     0.200
     0.274     6.690     0.200
     0.554     5.629     0.200
     0.697     5.859     0.200
     1.003     6.891     0.200
     0.992     5.620     0.200
     1.237     7.261     0.200
     1.284     6.401     0.200
     1.390     6.565     0.200
     1.407     7.177     0.200
     1.396     7.101     0.200
     1.933     9.079     0.200
     2.858     9.746     0.200
     4.761    15.831     0.200
     6.701    21.921     0.200
     6.701    19.585     0.200
     9.383    21.444     0.200
     9.968    27.317     0.200
    12.863    30.584     0.200
    17.590    35.034     0.200
     0.256     6.495     0.200
     0.367     5.598     0.200
     0.292     6.972     0.200
     0.719     6.189     0.200
     0.810     6.533     0.200
     0.935     4.971     0.200
     1.109     6.143     0.200
     1.329     7.577     0.200
     1.360     7.510     0.200
     1.368     6.614     0.200
     1.533     6.888     0.200
     1.588     7.448     0.200
     1.591     7.612     0.200
     1.713     7.796     0.200
     1.754     8.807     0.200
     1.768     8.046     0.200
     1.749     7.272     0.200
     1.848     7.524     0.200
     1.848     8.221     0.200
     1.786     7.935     0.200
     2.034     8.647     0.200
     2.144     8.766     0.200
     2.194     8.681     0.200
     2.149     8.808     0.200
     2.206     9.041     0.200
     2.282    10.050     0.200
     2.282     9.145     0.200
     2.217     7.112     0.200
     2.366     9.574     0.200
     2.446     9.439     0.200
     2.679     9.915     0.200
     2.661     9.723     0.200
     2.700     9.776     0.200
     2.674     9.474     0.200
     2.812    10.061     0.200
     2.884    10.329     0.200
     3.142    10.216     0.200
     3.454    11.379     0.200
     3.523    11.970     0.200
     3.973    12.218     0.200
     4.071    11.076     0.200
     4.528    13.938     0.200
     4.655    14.755     0.200
     4.655    13.805     0.200
     4.838    14.525     0.200
     5.443    14.759     0.200
     5.646    16.293     0.200
     6.498    18.548     0.200
     6.514    16.466     0.200
     6.813    18.378     0.200
     6.813    18.779     0.200
     6.886    17.636     0.200
     6.886    18.126     0.200
     6.886    17.926     0.200
     7.046    18.849     0.200
     8.291    20.528     0.200
     8.567    22.307     0.200
     9.536    19.941     0.200
    10.088    26.253     0.200
    10.088    25.772     0.200
    10.518    26.537     0.200
    10.972    25.234     0.200
    12.392    29.862     0.200
    12.937    29.806     0.200
    12.998    28.900     0.200
    13.313    29.771     0.200
    13.313    30.021     0.200
    14.199    31.079     0.200
    14.510    32.554     0.200
    14.898    32.927     0.200
    15.191    29.249     0.200
    15.191    29.247     0.200
    16.647    34.312     0.200
    17.672    32.954     0.200
    18.642    35.133     0.200
     0.271     6.226     0.200
     0.281     6.809     0.200
     0.282     6.596     0.200
     0.282     7.526     0.200
     0.366     5.617     0.200
     0.737     5.995     0.200
     0.806     6.591     0.200
     0.949     4.915     0.200
     1.110     6.146     0.200
     1.347     7.581     0.200
     1.375     7.546     0.200
     1.359     6.531     0.200
     1.550     6.902     0.200
     1.599     7.532     0.200
     1.605     7.665     0.200
     1.719     7.824     0.200
     1.745     7.132     0.200
     1.771     8.025     0.200
     1.796     7.934     0.200
     1.859     8.046     0.200
     1.859     8.194     0.200
     2.154     8.754     0.200
     2.268     8.421     0.200
     2.655     9.006     0.200
     2.675     9.378     0.200
     2.892    10.246     0.200
     3.141    10.038     0.200
     3.639    10.726     0.200
     4.068    11.019     0.200
     4.351    12.526     0.200
     4.519    13.756     0.200
     4.665    14.556     0.200
     4.665    14.900     0.200
     4.841    14.396     0.200
     5.461    16.860     0.200
     5.650    16.153     0.200
     6.504    18.484     0.200
     6.513    16.483     0.200
     6.888    18.254     0.200
     6.888    18.316     0.200
     6.888    18.214     0.200
     7.048    18.838     0.200
     8.256    21.743     0.200
     9.122    23.746     0.200
     9.533    20.744     0.200
    10.106    26.055     0.200
    10.106    23.133     0.200
    10.535    24.146     0.200
    12.258    30.443     0.200
    12.664    29.513     0.200
    13.015    30.209     0.200
    13.536    30.299     0.200
    14.526    32.573     0.200
    15.183    32.106     0.200
    15.184    32.103     0.200
    16.662    34.444     0.200
    17.690    33.904     0.200
    18.658    35.258     0.200
    20.777    38.130     0.200
     0.221     6.411     0.200
     0.284     6.684     0.200
     0.399     5.527     0.200
     0.706     6.157     0.200
     0.845     6.434     0.200
     0.937     5.154     0.200
     1.139     6.002     0.200
     1.305     7.561     0.200
     1.359     7.630     0.200
     1.406     6.386     0.200
     1.555     7.452     0.200
     1.749     8.977     0.200
     1.749     7.879     0.200
     1.795     7.942     0.200
     1.857     8.418     0.200
     2.113     8.732     0.200
     2.252     9.109     0.200
     2.284    10.030     0.200
     2.235     8.204     0.200
     2.643     9.343     0.200
     2.697     9.114     0.200
     3.941    12.001     0.200
     4.670    14.095     0.200
     4.670    14.392     0.200
     4.670    15.205     0.200
     5.424    12.598     0.200
     6.484    16.324     0.200
     6.659    18.476     0.200
     6.853    18.073     0.200
     6.853    17.917     0.200
     6.853    18.019     0.200
     7.014    18.540     0.200
     7.666    16.933     0.200
     8.014    20.760     0.200
     8.016    20.553     0.200
     8.260    22.494     0.200
     9.511    21.046     0.200
     9.630    25.507     0.200
    10.061    26.478     0.200
    10.061    26.751     0.200
    10.506    23.288     0.200
    10.984    23.706     0.200
    12.828    28.784     0.200
    12.900    29.945     0.200
    12.968    30.051     0.200
    13.276    29.659     0.200
    13.486    30.648     0.200
    13.590    30.401     0.200
    13.837    31.913     0.200
    14.181    31.693     0.200
    14.477    32.440     0.200
    14.740    31.584     0.200
    14.922    32.952     0.200
    15.116    32.086     0.200
    15.546    31.969     0.200
    16.612    33.529     0.200
    17.651    33.603     0.200
    20.729    35.489     0.200
    20.729    35.387     0.200
     0.268     6.290     0.200
     0.304     6.766     0.200
     0.350     5.726     0.200
     0.718     6.130     0.200
     0.793     6.662     0.200
     0.927     4.997     0.200
     1.092     6.266     0.200
     1.333     7.660     0.200
     1.353     7.522     0.200
     1.353     6.630     0.200
     2.645    10.346     0.200
     4.512    13.662     0.200
     4.642    15.136     0.200
     4.642    14.855     0.200
     6.902    17.159     0.200
     6.902    18.761     0.200
     6.902    18.960     0.200
    12.734    30.810     0.200
     0.156     7.200     0.200
     0.339     6.762     0.200
     0.421     6.005     0.200
     0.633     6.326     0.200
     0.884     5.697     0.200
     0.872     6.835     0.200
     1.145     6.349     0.200
     1.228     7.690     0.200
     1.300     7.640     0.200
     1.451     6.881     0.200
     1.815     8.738     0.200
     2.730     9.653     0.200
     4.596    13.380     0.200
     5.347    13.617     0.200
     6.788    17.306     0.200
     6.839    19.202     0.200
     6.839    19.002     0.200
     9.571    27.325     0.200
     9.521    21.035     0.200
     9.984    23.380     0.200
    10.434    25.257     0.200
    12.556    29.694     0.200
    12.677    28.875     0.200
    12.892    29.661     0.200
    15.478    31.687     0.200
    15.490    32.049     0.200
    16.065    32.137     0.200
    17.575    34.622     0.200
     0.263     6.868     0.200
     0.264     7.258     0.200
     0.219     6.386     0.200
     0.419     5.655     0.200
     0.719     5.947     0.200
     0.862     6.577     0.200
     0.957     5.074     0.200
     1.159     6.215     0.200
     1.312     7.429     0.200
     1.378     7.663     0.200
     1.878     8.418     0.200
     4.692    16.189     0.200
     4.692    15.260     0.200
     6.833    19.195     0.200
     0.266     6.946     0.200
     0.298     7.066     0.200
     0.469     6.973     0.200
     0.470     7.166     0.200
     0.590     6.453     0.200
     0.716     6.992     0.200
     0.763     5.536     0.200
     0.973     6.493     0.200
     1.193     7.427     0.200
     1.237     7.319     0.200
     1.317     6.682     0.200
     1.411     7.577     0.200
     1.671     8.300     0.200
     2.574     8.504     0.200
     4.480    14.564     0.200
     4.480    14.149     0.200
     7.011    17.125     0.200
     7.011    18.226     0.200
     7.011    17.726     0.200
     9.694    20.771     0.200
    10.006    27.879     0.200
    10.006    23.707     0.200
    10.373    26.792     0.200
    12.930    31.556     0.200
    17.555    32.885     0.200
    17.771    36.053     0.200
     0.210     6.772     0.200
     0.318     6.799     0.200
     0.383     5.949     0.200
     0.672     6.371     0.200
     0.832     6.609     0.200
     0.902     5.487     0.200
     1.118     6.380     0.200
     1.278     7.309     0.200
     1.324     7.769     0.200
     1.403     6.748     0.200
     1.823     8.590     0.200
     2.688     9.053     0.200
     4.554    13.069     0.200
     4.637    15.100     0.200
     4.637    15.358     0.200
     4.637    15.702     0.200
     5.394    14.276     0.200
     6.792    19.952     0.200
     6.871    18.445     0.200
     6.871    17.937     0.200
     6.871    18.039     0.200
     6.871    18.180     0.200
     9.537    22.819     0.200
    10.037    26.386     0.200
    10.472    25.904     0.200
    12.946    30.634     0.200
    13.285    29.479     0.200
    14.460    31.773     0.200
    15.511    33.202     0.200
    17.622    33.901     0.200
     0.301     7.096     0.200
     0.283     6.405     0.200
     0.343     5.905     0.200
     0.783     6.871     0.200
     0.731     6.176     0.200
     0.935     5.104     0.200
     1.087     6.430     0.200
     1.340     6.879     0.200
     1.348     7.580     0.200
     1.362     7.515     0.200
     1.841     8.674     0.200
     2.634     9.974     0.200
     4.501    13.887     0.200
     4.645    15.906     0.200
     4.645    15.168     0.200
     6.803    20.015     0.200
     6.910    17.066     0.200
     6.910    18.066     0.200
     6.910    18.387     0.200
     8.315    22.576     0.200
     8.377    22.052     0.200
     8.556    24.065     0.200
     9.556    20.233     0.200
    10.528    25.547     0.200
    13.021    30.460     0.200
    15.560    33.028     0.200
     0.303     6.720     0.200
     0.304     7.743     0.200
     0.423     5.924     0.200
     0.671     5.824     0.200
     0.872     6.776     0.200
     0.918     5.941     0.200
     1.156     6.373     0.200
     1.263     7.017     0.200
     1.336     7.267     0.200
     1.441     6.936     0.200
     1.846     8.470     0.200
     2.728    10.322     0.200
     4.664    15.935     0.200
     4.664    15.083     0.200
     6.817    20.103     0.200
     6.832    17.971     0.200
     6.832    17.728     0.200
     6.832    17.431     0.200
     6.832    18.494     0.200
     8.216    22.074     0.200
     8.329    22.963     0.200
     8.576    23.071     0.200
    10.018    26.048     0.200
    12.573    29.209     0.200
    12.924    30.129     0.200
    13.245    29.936     0.200
    15.175    32.855     0.200
    15.176    32.853     0.200
    17.611    35.025     0.200
     0.200     6.630     0.200
     0.281     6.888     0.200
     0.282     6.790     0.200
     0.419     5.870     0.200
     0.698     6.028     0.200
     0.866     6.762     0.200
     0.939     5.207     0.200
     1.157     6.367     0.200
     1.290     7.208     0.200
     1.359     7.408     0.200
     1.863     8.521     0.200
     2.720    10.829     0.200
     4.586    12.545     0.200
     4.679    14.766     0.200
     6.833    18.223     0.200
     6.833    18.360     0.200
     9.496    23.553     0.200
     0.224     6.341     0.200
     0.281     6.677     0.200
     0.281     6.770     0.200
     0.400     5.689     0.200
     0.709     6.078     0.200
     0.844     6.601     0.200
     0.940     5.276     0.200
     1.139     6.260     0.200
     1.308     7.483     0.200
     1.362     7.851     0.200
     1.404     6.666     0.200
     1.860     7.747     0.200
     2.697    10.184     0.200
     4.672    14.928     0.200
     6.853    18.982     0.200
     6.853    18.271     0.200
    10.064    24.721     0.200
     0.257     6.346     0.200
     0.330     6.599     0.200
     0.386     6.536     0.200
     0.387     6.823     0.200
     0.703     6.741     0.200
     0.869     5.000     0.200
     0.998     6.297     0.200
     1.275     6.464     0.200
     1.301     7.466     0.200
     1.340     7.612     0.200
     1.763     8.521     0.200
     2.558    10.989     0.200
     4.560    14.528     0.200
     4.560    14.195     0.200
     6.995    17.110     0.200
     6.995    17.610     0.200
     6.995    17.446     0.200
     9.645    20.035     0.200
    10.486    26.778     0.200
    13.415    29.745     0.200
    15.292    30.989     0.200
    15.292    30.987     0.200
    17.665    34.393     0.200
     0.258     6.278     0.200
     0.366     5.719     0.200
     0.292     6.481     0.200
     0.293     6.503     0.200
     0.721     6.277     0.200
     0.808     6.557     0.200
     0.936     5.268     0.200
     1.108     6.362     0.200
     1.331     7.859     0.200
     1.361     7.906     0.200
     1.366     6.441     0.200
     1.848     8.622     0.200
     2.660     9.949     0.200
     4.655    15.263     0.200
     4.655    14.552     0.200
     6.887    18.419     0.200
     6.887    18.185     0.200
     8.293    22.608     0.200
     8.293    21.710     0.200
     9.537    21.191     0.200
    10.090    25.157     0.200
    10.519    23.925     0.200
    12.261    27.905     0.200
    13.000    30.482     0.200
    13.314    29.757     0.200
    14.512    32.636     0.200
    14.957    34.334     0.200
    15.191    31.603     0.200
    15.192    31.601     0.200
    16.649    34.593     0.200
    17.673    33.040     0.200
     0.312     6.264     0.200
     0.285     5.986     0.200
     0.531     5.312     0.200
     0.582     5.814     0.200
     0.682     6.650     0.200
     0.683     6.155     0.200
     0.917     6.404     0.200
     0.934     6.312     0.200
     0.972     6.666     0.200
     1.092     6.163     0.200
     1.193     6.294     0.200
     1.292     7.629     0.200
     1.341     8.258     0.200
     1.384     6.667     0.200
     1.534     8.307     0.200
     2.761    10.794     0.200
     4.372    15.188     0.200
     6.936    19.164     0.200
     6.936    18.538     0.200
    12.422    30.447     0.200
     0.177     6.896     0.200
     0.281     6.880     0.200
     0.282     6.872     0.200
     0.441     5.815     0.200
     0.689     6.126     0.200
     0.889     6.790     0.200
     0.941     5.382     0.200
     1.176     6.334     0.200
     1.274     7.395     0.200
     1.358     7.818     0.200
     1.869     8.651     0.200
     2.743     9.848     0.200
     4.688    15.460     0.200
     4.688    14.160     0.200
     6.812    18.766     0.200
     6.812    18.067     0.200
     6.812    18.669     0.200
     0.188     6.660     0.200
     0.189     6.697     0.200
     0.312     5.418     0.200
     0.437     5.057     0.200
     0.822     5.660     0.200
     0.859     6.235     0.200
     1.046     4.745     0.200
     1.181     5.973     0.200
     1.384     6.304     0.200
     1.956     8.731     0.200
     2.695     9.506     0.200
     4.562    12.822     0.200
     4.758    15.642     0.200
     4.758    15.228     0.200
     6.831    18.051     0.200
     6.831    18.137     0.200
     6.831    18.215     0.200
     8.477    22.732     0.200
     9.454    21.021     0.200
    10.164    23.937     0.200
    10.623    25.189     0.200
    12.666    29.991     0.200
    13.066    31.076     0.200
    13.286    29.762     0.200
    15.093    30.814     0.200
    15.093    30.812     0.200
    16.686    34.826     0.200
     0.343     5.786     0.200
     0.561     5.932     0.200
     0.508     5.453     0.200
     0.509     6.245     0.200
     0.509     5.515     0.200
     0.682     5.529     0.200
     0.944     5.969     0.200
     1.051     5.419     0.200
     0.994     5.689     0.200
     1.130     5.199     0.200
     1.452     6.341     0.200
     1.563     7.748     0.200
     1.624     7.831     0.200
     1.926     8.607     0.200
     2.184     8.999     0.200
     2.322     8.881     0.200
     2.501     9.597     0.200
     2.558     8.835     0.200
     2.953    10.022     0.200
     4.279    11.345     0.200
     4.644    13.333     0.200
     4.644    13.493     0.200
     5.151    15.070     0.200
     5.626    15.729     0.200
     5.977    16.634     0.200
     6.107    16.119     0.200
     6.140    17.725     0.200
     6.230    16.874     0.200
     6.744    18.778     0.200
     6.761    16.988     0.200
     6.855    19.189     0.200
     7.177    18.595     0.200
     7.177    18.724     0.200
     7.177    18.924     0.200
     7.338    19.247     0.200
     7.589    20.418     0.200
     7.856    21.006     0.200
     7.931    17.331     0.200
     8.323    20.751     0.200
     8.342    21.034     0.200
     8.607    21.141     0.200
     8.497    18.528     0.200
     8.565    22.431     0.200
     8.700    22.354     0.200
     8.664    22.474     0.200
     9.068    23.861     0.200
     9.249    21.944     0.200
     9.509    23.209     0.200
     9.643    22.844     0.200
     9.718    20.675     0.200
     9.966    22.778     0.200
    10.476    27.729     0.200
    10.785    23.826     0.200
    11.213    29.832     0.200
    12.765    30.214     0.200
    12.906    29.569     0.200
    13.070    30.459     0.200
    13.399    30.812     0.200
    13.674    30.160     0.200
    13.944    29.631     0.200
    14.927    32.988     0.200
    15.114    31.909     0.200
    15.273    33.050     0.200
    15.272    30.608     0.200
    15.272    30.606     0.200
    17.072    34.449     0.200
    17.794    32.656     0.200
    17.794    33.226     0.200
     0.128     7.303     0.200
     0.273     6.888     0.200
     0.273     6.812     0.200
     0.554     5.725     0.200
     0.699     5.941     0.200
     0.993     5.701     0.200
     1.003     6.887     0.200
     1.238     7.243     0.200
     1.285     6.496     0.200
     1.397     7.987     0.200
     1.391     6.557     0.200
     1.407     7.271     0.200
     1.935     9.165     0.200
     2.858    10.045     0.200
     4.724    17.261     0.200
     4.762    13.818     0.200
     6.701    20.598     0.200
     6.701    19.598     0.200
     6.701    19.837     0.200
    10.485    23.739     0.200
    12.462    30.160     0.200
    14.766    30.580     0.200
    17.592    35.098     0.200
     0.235     6.504     0.200
     0.378     5.728     0.200
     0.296     6.788     0.200
     0.297     6.938     0.200
     0.703     6.039     0.200
     0.824     6.633     0.200
     0.927     5.132     0.200
     1.118     6.199     0.200
     1.309     7.466     0.200
     1.350     7.490     0.200
     1.386     6.671     0.200
     1.843     7.535     0.200
     2.677    10.505     0.200
     4.654    14.736     0.200
     6.874    18.349     0.200
     6.874    18.427     0.200
     6.874    18.428     0.200
     9.531    21.474     0.200
    12.631    29.644     0.200
    14.590    30.549     0.200
    17.654    35.698     0.200
     0.227     6.473     0.200
     0.290     6.641     0.200
     0.289     6.651     0.200
     0.390     5.870     0.200
     0.705     6.106     0.200
     0.835     6.776     0.200
     0.933     5.342     0.200
     1.129     6.445     0.200
     1.307     7.474     0.200
     1.355     7.708     0.200
     1.397     6.823     0.200
     1.851     8.623     0.200
     2.688     9.752     0.200
     4.663    15.029     0.200
     4.663    15.209     0.200
     6.819    19.549     0.200
     6.862    17.981     0.200
     6.862    17.942     0.200
     6.862    18.145     0.200
     9.520    21.578     0.200
    10.064    24.776     0.200
    10.064    25.737     0.200
    12.288    26.429     0.200
    12.622    29.934     0.200
    12.972    30.138     0.200
    13.494    29.967     0.200
    14.482    32.717     0.200
    14.602    32.188     0.200
    15.181    33.763     0.200
    15.181    33.761     0.200
    17.652    34.434     0.200
     0.273     7.093     0.200
     0.274     6.985     0.200
     0.307     6.097     0.200
     0.356     5.629     0.200
     0.769     6.010     0.200
     0.787     6.592     0.200
     0.971     5.056     0.200
     1.101     6.141     0.200
     1.332     6.643     0.200
     1.383     7.445     0.200
     1.399     7.662     0.200
     1.873     8.918     0.200
     2.633     9.660     0.200
     4.500    14.372     0.200
     4.673    13.742     0.200
     6.903    18.221     0.200
     6.903    17.623     0.200
     6.903    18.623     0.200
     9.537    19.408     0.200
    12.696    30.115     0.200
     0.182     6.846     0.200
     0.291     6.882     0.200
     0.291     7.073     0.200
     0.428     5.874     0.200
     0.683     6.100     0.200
     0.876     6.745     0.200
     0.931     5.210     0.200
     1.163     6.300     0.200
     1.273     7.417     0.200
     1.349     7.533     0.200
     1.443     6.838     0.200
     1.858     8.493     0.200
     2.731    11.098     0.200
     4.598    15.016     0.200
     4.675    15.412     0.200
     4.675    15.282     0.200
     6.825    19.222     0.200
     6.825    18.322     0.200
    10.483    24.732     0.200
    12.575    30.325     0.200
     0.139     7.088     0.200
     0.461     6.127     0.200
     0.478     6.835     0.200
     0.479     5.824     0.200
     0.572     6.643     0.200
     0.762     5.719     0.200
     0.865     5.521     0.200
     0.883     6.412     0.200
     1.142     6.282     0.200
     1.299     7.444     0.200
     1.717     8.269     0.200
     2.425     9.618     0.200
     4.491    13.799     0.200
     4.491    13.947     0.200
     7.122    18.304     0.200
     7.122    18.202     0.200
     7.122    18.124     0.200
     0.190     6.421     0.200
     0.276     6.521     0.200
     0.277     6.513     0.200
     0.433     5.583     0.200
     0.697     5.903     0.200
     0.880     6.574     0.200
     0.945     5.515     0.200
     1.170     6.187     0.200
     1.285     7.241     0.200
     1.871     8.507     0.200
     1.871     8.296     0.200
     4.688    17.533     0.200
     4.688    14.584     0.200
     6.819    19.298     0.200
     9.483    22.246     0.200
     0.189     6.258     0.200
     0.451     6.001     0.200
     0.569     5.632     0.200
     0.640     5.304     0.200
     0.813     5.689     0.200
     0.929     5.122     0.200
     0.971     5.737     0.200
     0.976     5.077     0.200
     1.377     6.097     0.200
     1.407     7.248     0.200
     1.765     8.218     0.200
     2.275     9.128     0.200
     4.141    14.740     0.200
     4.493    12.550     0.200
     7.245    19.619     0.200
     7.245    21.416     0.200
     7.245    20.206     0.200
    11.886    28.165     0.200
    13.040    31.943     0.200
    14.215    29.165     0.200
    14.215    29.786     0.200
     0.345     5.732     0.200
     0.266     6.361     0.200
     0.313     6.710     0.200
     0.314     6.598     0.200
     0.710     6.174     0.200
     0.789     6.653     0.200
     0.918     5.150     0.200
     1.086     6.184     0.200
     1.344     7.573     0.200
     1.326     7.587     0.200
     1.351     6.591     0.200
     1.828     8.431     0.200
     1.828     7.907     0.200
     2.642    10.233     0.200
     4.509    15.745     0.200
     4.634    14.862     0.200
     4.634    15.088     0.200
     6.907    18.054     0.200
     6.907    18.250     0.200
     6.907    18.836     0.200
    10.088    24.733     0.200
    10.088    25.460     0.200
    10.507    24.941     0.200
    12.664    30.273     0.200
    13.000    30.053     0.200
    14.556    29.447     0.200
     0.360     5.607     0.200
     0.509     5.666     0.200
     0.508     5.377     0.200
     0.572     5.826     0.200
     0.691     5.432     0.200
     0.956     6.046     0.200
     0.994     5.901     0.200
     1.066     5.362     0.200
     1.147     4.822     0.200
     1.457     6.493     0.200
     1.942     8.585     0.200
     2.325     9.075     0.200
     4.658    13.243     0.200
     7.174    18.781     0.200
     7.174    18.984     0.200
     7.174    19.650     0.200
     8.732    24.158     0.200
    13.077    30.701     0.200
    13.077    30.700     0.200
    14.288    31.561     0.200
     0.267     6.332     0.200
     0.351     5.653     0.200
     0.305     6.688     0.200
     0.304     6.798     0.200
     0.718     6.072     0.200
     0.793     6.586     0.200
     0.926     5.034     0.200
     1.093     6.195     0.200
     1.332     7.603     0.200
     1.353     7.659     0.200
     1.353     6.553     0.200
     1.836     8.465     0.200
     2.645    10.473     0.200
     4.512    15.488     0.200
     4.642    15.669     0.200
     6.902    18.700     0.200
     6.902    18.400     0.200
     6.902    19.000     0.200
     8.332    22.890     0.200
    10.515    24.833     0.200
    12.664    30.307     0.200
    12.664    30.307     0.200
    14.562    32.660     0.200
     0.160     7.013     0.200
     0.320     6.649     0.200
     0.320     6.441     0.200
     0.320     6.922     0.200
     0.428     5.884     0.200
     0.652     6.175     0.200
     0.903     5.836     0.200
     0.879     6.826     0.200
     1.157     6.483     0.200
     1.242     7.381     0.200
     1.320     7.579     0.200
     1.453     6.825     0.200
     1.833     8.665     0.200
     2.736     9.353     0.200
     4.602    14.977     0.200
     4.654    15.373     0.200
     4.654    15.514     0.200
     6.829    18.484     0.200
     6.829    17.984     0.200
     6.829    18.933     0.200
     8.235    22.003     0.200
     9.507    21.539     0.200
    10.452    24.510     0.200
    12.558    30.424     0.200
    12.558    30.423     0.200
    13.237    30.051     0.200
    14.414    33.171     0.200
    14.638    31.553     0.200
    15.184    31.461     0.200
    15.184    31.453     0.200
     0.221     6.581     0.200
     0.255     7.192     0.200
     0.425     5.704     0.200
     0.726     5.987     0.200
     0.868     6.739     0.200
     0.966     5.196     0.200
     1.166     6.154     0.200
     1.318     7.487     0.200
     1.386     7.686     0.200
     1.422     6.768     0.200
     1.887     8.664     0.200
     2.718    10.442     0.200
     6.827    18.648     0.200
    12.604    30.674     0.200
     0.202     6.481     0.200
     0.198     6.820     0.200
     0.554     5.473     0.200
     0.768     5.970     0.200
     0.995     6.929     0.200
     1.050     5.485     0.200
     1.295     6.432     0.200
     1.313     7.419     0.200
     1.460     7.505     0.200
     1.985     8.468     0.200
     1.985     9.190     0.200
     2.842    10.371     0.200
     4.709    14.783     0.200
     4.808    16.232     0.200
     6.699    18.264     0.200
     6.699    18.365     0.200
     8.217    21.744     0.200
     8.276    20.307     0.200
     8.426    17.611     0.200
    10.040    24.372     0.200
    10.040    27.212     0.200
    12.507    29.086     0.200
    12.507    29.086     0.200
    12.933    30.411     0.200
    13.134    30.422     0.200
    13.134    29.734     0.200
    13.381    33.283     0.200
    14.765    31.136     0.200
    17.666    33.674     0.200
     0.091     6.248     0.200
     0.365     5.850     0.200
     0.649     5.137     0.200
     0.657     5.144     0.200
     0.795     4.933     0.200
     0.780     4.903     0.200
     0.978     5.497     0.200
     1.206     7.030     0.200
     1.287     6.991     0.200
     1.320     6.801     0.200
     1.299     6.242     0.200
     1.328     7.206     0.200
     1.554     7.676     0.200
     2.224     9.458     0.200
     4.088    14.701     0.200
     0.453     5.223     0.200
     0.462     5.415     0.200
     0.715     6.058     0.200
     0.819     6.152     0.200
     0.819     5.955     0.200
     0.831     5.305     0.200
     0.882     5.612     0.200
     0.938     5.564     0.200
     0.947     6.051     0.200
     1.161     7.056     0.200
     1.265     6.549     0.200
     1.340     6.967     0.200
     1.364     6.785     0.200
     1.432     7.892     0.200
     1.526     6.697     0.200
     1.802     8.284     0.200
     3.198    10.988     0.200
     4.629    14.579     0.200
     5.047    17.308     0.200
     6.547    19.707     0.200
    11.997    30.807     0.200
    14.979    33.205     0.200
     0.638     6.393     0.200
     1.014     7.699     0.200
     1.138     7.654     0.200
     4.591    17.263     0.200
     5.304    21.434     0.200
     6.452    23.543     0.200
     6.452    21.843     0.200
     6.452    23.240     0.200
     7.256    21.039     0.200
     9.021    27.984     0.200
     9.681    29.056     0.200
    11.672    34.629     0.200
    11.648    34.323     0.200
    11.915    31.993     0.200
    12.581    32.019     0.200
    12.592    32.618     0.200
    12.592    31.314     0.200
    15.149    32.212     0.200
    15.149    36.342     0.200
    16.683    38.545     0.200
     0.251     6.159     0.200
     0.328     6.061     0.200
     0.447     6.168     0.200
     0.588     5.520     0.200
     0.692     5.410     0.200
     0.823     5.979     0.200
     0.930     5.729     0.200
     0.994     5.285     0.200
     1.035     5.410     0.200
     1.357     6.247     0.200
     1.464     7.590     0.200
     1.504     7.432     0.200
     1.807     8.296     0.200
     1.808     8.279     0.200
     2.244     8.794     0.200
     2.244     8.896     0.200
     4.520    13.928     0.200
     7.266    19.384     0.200
     8.671    24.844     0.200
     0.222     6.398     0.200
     0.283     6.679     0.200
     0.284     6.670     0.200
     0.399     5.727     0.200
     0.706     6.047     0.200
     0.844     6.631     0.200
     0.938     5.240     0.200
     1.139     6.198     0.200
     1.305     7.450     0.200
     1.360     7.919     0.200
     1.858     8.208     0.200
     1.858     8.505     0.200
     2.697    10.507     0.200
     4.670    14.585     0.200
     6.853    18.010     0.200
     6.853    18.471     0.200
     6.853    18.209     0.200
     6.853    19.112     0.200
     8.299    21.356     0.200
    12.614    29.679     0.200
    12.614    29.679     0.200
    14.611    34.873     0.200
     0.122     4.617     0.200
     0.477     4.868     0.200
     0.513     4.745     0.200
     0.559     4.118     0.200
     0.677     4.639     0.200
     0.917     5.133     0.200
     1.034     6.074     0.200
     1.127     6.387     0.200
     1.175     5.723     0.200
     1.217     6.434     0.200
     1.281     6.688     0.200
     1.287     6.915     0.200
     1.361     6.162     0.200
     1.870     8.719     0.200
     2.985    10.898     0.200
     4.848    17.067     0.200
     6.631    19.256     0.200
     6.631    20.154     0.200
     7.989    22.127     0.200
    12.279    33.539     0.200
    14.851    33.732     0.200
     0.154     6.904     0.200
     0.244     6.541     0.200
     0.367     5.609     0.200
     0.304     7.347     0.200
     0.304     6.847     0.200
     0.304     6.558     0.200
     0.303     6.755     0.200
     0.704     6.278     0.200
     0.812     6.415     0.200
     0.922     5.131     0.200
     1.107     6.077     0.200
     1.153     6.434     0.200
     1.313     7.766     0.200
     1.346     7.576     0.200
     1.375     6.448     0.200
     1.520     7.056     0.200
     1.581     7.744     0.200
     1.740     8.888     0.200
     1.764     8.003     0.200
     1.837     8.457     0.200
     1.780     8.020     0.200
     2.145     8.752     0.200
     2.267     8.234     0.200
     2.359     9.663     0.200
     2.544     7.605     0.200
     2.665     9.686     0.200
     2.675     9.476     0.200
     2.810    10.400     0.200
     2.878    10.402     0.200
     3.157    10.144     0.200
     3.144    10.100     0.200
     3.454    11.289     0.200
     3.521    11.998     0.200
     3.643    10.676     0.200
     3.973    12.226     0.200
     4.075    10.942     0.200
     4.449    16.279     0.200
     4.353    12.586     0.200
     4.532    15.308     0.200
     4.646    14.774     0.200
     4.646    14.001     0.200
     4.797    16.006     0.200
     4.837    14.550     0.200
     5.336    15.218     0.200
     5.545    15.683     0.200
     5.644    16.333     0.200
     5.947    16.295     0.200
     6.280    17.412     0.200
     6.436    18.484     0.200
     6.516    16.556     0.200
     6.691    18.607     0.200
     6.885    18.241     0.200
     6.885    18.038     0.200
     6.885    18.343     0.200
     6.885    18.640     0.200
     7.046    18.865     0.200
     7.074    17.035     0.200
     7.546    20.431     0.200
     7.697    16.963     0.200
     7.765    17.981     0.200
     8.047    20.880     0.200
     8.048    20.277     0.200
     8.277    22.503     0.200
     8.277    21.699     0.200
     8.252    21.399     0.200
     8.312    22.142     0.200
     8.354    21.794     0.200
     8.416    20.079     0.200
     8.742    23.578     0.200
     9.671    21.634     0.200
    10.073    26.334     0.200
    10.133    25.342     0.200
    11.689    29.079     0.200
    12.641    30.147     0.200
    12.641    30.146     0.200
    12.983    30.079     0.200
    13.308    29.690     0.200
    13.308    30.081     0.200
    14.579    30.819     0.200
    14.579    29.756     0.200
    16.635    34.965     0.200
    17.656    33.623     0.200
     0.257     6.263     0.200
     0.330     6.510     0.200
     0.387     6.444     0.200
     0.703     6.658     0.200
     0.701     5.876     0.200
     0.869     5.013     0.200
     0.998     6.215     0.200
     1.275     6.482     0.200
     1.301     7.382     0.200
     1.340     7.521     0.200
     1.763     8.512     0.200
     2.558    10.106     0.200
     4.424    14.727     0.200
     4.560    15.542     0.200
     6.996    18.517     0.200
     6.996    18.470     0.200
     8.348    20.211     0.200
     8.470    23.407     0.200
    12.730    29.551     0.200
     0.195     6.665     0.200
     0.283     6.835     0.200
     0.283     7.030     0.200
     0.423     5.797     0.200
     0.694     6.032     0.200
     0.870     6.582     0.200
     0.938     5.289     0.200
     1.160     6.301     0.200
     1.286     7.332     0.200
     1.357     7.398     0.200
     1.863     8.299     0.200
     2.724    10.251     0.200
     4.591    15.865     0.200
     4.679    16.333     0.200
     6.830    19.134     0.200
     6.830    18.744     0.200
     6.833    18.389     0.200
     8.277    20.518     0.200
     8.351    21.978     0.200
     9.494    21.123     0.200
    12.322    29.035     0.200
    12.945    32.669     0.200
    13.466    33.983     0.200
     0.200     6.253     0.200
     0.292     6.188     0.200
     0.292     6.679     0.200
     0.292     6.179     0.200
     0.411     5.197     0.200
     0.690     5.942     0.200
     0.858     6.079     0.200
     0.929     4.951     0.200
     1.285     7.387     0.200
     1.349     7.448     0.200
     1.595     7.475     0.200
     1.732     7.780     0.200
     1.801     7.772     0.200
     1.797     6.818     0.200
     1.852     7.821     0.200
     2.226     7.914     0.200
     2.634     8.950     0.200
     2.712     9.938     0.200
     2.831     9.956     0.200
     3.206     9.381     0.200
     4.579    14.655     0.200
     4.668    14.518     0.200
     4.792    14.666     0.200
     5.598    16.459     0.200
     5.794    17.478     0.200
     5.904    16.483     0.200
     6.447    18.749     0.200
     6.822    19.273     0.200
     6.842    18.139     0.200
     6.842    18.338     0.200
     6.842    18.538     0.200
     6.842    18.538     0.200
     7.003    18.864     0.200
     8.239    22.234     0.200
     8.279    22.202     0.200
     9.067    23.979     0.200
     9.180    24.052     0.200
     9.333    24.467     0.200
     9.506    20.350     0.200
    10.041    23.615     0.200
    10.041    26.204     0.200
    10.490    23.770     0.200
    10.481    26.951     0.200
    11.268    29.391     0.200
    11.771    29.416     0.200
    11.779    29.317     0.200
    11.779    29.156     0.200
    11.901    30.794     0.200
    11.923    29.840     0.200
    11.923    29.731     0.200
    11.973    29.946     0.200
    11.998    30.187     0.200
    12.050    30.217     0.200
    12.192    30.271     0.200
    12.204    31.009     0.200
    12.494    30.663     0.200
    12.594    30.509     0.200
    12.578    30.854     0.200
    12.579    31.664     0.200
    12.594    30.512     0.200
    12.608    31.137     0.200
    12.760    31.034     0.200
    12.802    31.394     0.200
    12.947    30.790     0.200
    12.911    31.833     0.200
    12.984    31.590     0.200
    12.995    30.992     0.200
    13.021    31.460     0.200
    13.110    32.726     0.200
    13.137    32.531     0.200
    13.203    31.619     0.200
    13.260    31.346     0.200
    13.261    30.031     0.200
    13.261    29.929     0.200
    13.325    31.404     0.200
    13.328    32.111     0.200
    13.475    33.019     0.200
    13.475    31.233     0.200
    13.504    31.869     0.200
    13.688    33.337     0.200
    13.910    32.573     0.200
    13.960    33.050     0.200
    14.053    33.375     0.200
    14.064    31.565     0.200
    14.148    31.078     0.200
    14.241    33.079     0.200
    14.456    32.682     0.200
    14.623    29.781     0.200
    16.591    34.670     0.200
    17.633    33.115     0.200
    20.710    38.401     0.200
     0.349     5.361     0.200
     0.536     5.474     0.200
     0.688     5.804     0.200
     0.857     6.130     0.200
     0.879     5.675     0.200
     0.946     5.595     0.200
     0.951     6.040     0.200
     0.998     6.383     0.200
     1.260     7.131     0.200
     1.264     6.582     0.200
     1.320     6.825     0.200
     1.429     7.158     0.200
     1.517     6.733     0.200
     1.885     8.515     0.200
     3.170    11.536     0.200
     5.027    18.065     0.200
     6.510    19.658     0.200
     6.511    19.793     0.200
     7.770    22.630     0.200
    12.060    31.592     0.200
    14.993    34.635     0.200
     6.813    24.029     0.200
     6.813    24.041     0.200
     7.000    20.564     0.200
     7.159    17.891     0.200
     7.586    22.999     0.200
     8.758    28.331     0.200
     8.758    28.034     0.200
     9.253    23.957     0.200
    11.714    34.383     0.200
    20.408    39.372     0.200
    20.408    41.607     0.200
     0.121     6.834     0.200
     0.286     6.501     0.200
     0.274     5.945     0.200
     0.360     5.542     0.200
     0.735     5.863     0.200
     0.800     6.510     0.200
     0.945     4.810     0.200
     1.104     6.067     0.200
     1.165     6.356     0.200
     1.347     7.425     0.200
     1.354     6.445     0.200
     1.372     7.335     0.200
     1.854     8.513     0.200
     1.855     8.451     0.200
     2.650    10.524     0.200
     2.650    10.626     0.200
     4.517    15.839     0.200
     4.659    15.069     0.200
     6.894    19.646     0.200
     0.154     7.013     0.200
     0.321     6.658     0.200
     0.322     6.650     0.200
     0.322     6.850     0.200
     0.322     6.510     0.200
     0.433     5.855     0.200
     0.648     6.140     0.200
     0.884     6.694     0.200
     0.903     5.473     0.200
     1.161     6.364     0.200
     1.238     7.367     0.200
     1.318     7.523     0.200
     1.834     8.384     0.200
     1.834     8.759     0.200
     2.741    10.321     0.200
     3.241     9.489     0.200
     4.607    15.843     0.200
     4.654    15.190     0.200
     4.654    15.299     0.200
     6.823    19.248     0.200
     6.825    18.863     0.200
     6.825    19.042     0.200
     6.825    18.862     0.200
     6.825    18.788     0.200
     8.190    21.227     0.200
     8.230    21.519     0.200
     8.307    17.769     0.200
     8.345    21.278     0.200
     9.992    26.503     0.200
     9.992    26.724     0.200
    10.962    28.076     0.200
    12.552    30.272     0.200
    12.530    31.275     0.200
    12.552    28.890     0.200
    12.552    30.322     0.200
    12.898    30.384     0.200
    13.232    29.916     0.200
    13.232    30.092     0.200
    13.435    31.624     0.200
    14.643    32.308     0.200
    14.643    32.509     0.200
    14.643    31.179     0.200
    15.183    33.146     0.200
    17.586    34.880     0.200
    17.586    35.091     0.200
     0.858     5.376     0.200
     0.999     6.429     0.200
     1.095     6.812     0.200
     1.229     7.846     0.200
     2.951    12.556     0.200
     3.476    10.829     0.200
     4.812    16.237     0.200
     6.680    19.834     0.200
     6.680    18.856     0.200
     7.969    21.849     0.200
     9.435    22.415     0.200
     9.436    20.577     0.200
    10.256    29.273     0.200
    12.296    35.049     0.200
    14.805    36.023     0.200
     0.271     6.471     0.200
     0.302     6.906     0.200
     0.303     6.797     0.200
     0.350     5.748     0.200
     0.722     6.208     0.200
     0.792     6.689     0.200
     0.930     5.481     0.200
     1.092     6.286     0.200
     1.350     6.771     0.200
     1.336     7.835     0.200
     1.356     7.604     0.200
     1.839     8.022     0.200
     2.643    10.382     0.200
     3.133    10.066     0.200
     4.510    15.897     0.200
     6.903    18.473     0.200
     6.903    19.172     0.200
     6.903    18.561     0.200
     8.336    20.998     0.200
     8.555    21.388     0.200
    15.204    32.313     0.200
    15.204    32.315     0.200
     0.783     6.261     0.200
     1.514     9.224     0.200
     1.514     9.054     0.200
     2.288    11.289     0.200
     2.288    10.189     0.200
     2.822    10.067     0.200
     4.150    16.260     0.200
     4.277    15.584     0.200
     4.277    13.384     0.200
     4.277    13.714     0.200
     6.443    19.405     0.200
     6.443    18.705     0.200
     7.298    20.394     0.200
     7.300    21.408     0.200
     7.300    20.588     0.200
     7.300    20.408     0.200
     7.300    21.320     0.200
     8.181    21.420     0.200
     8.183    24.596     0.200
     8.183    22.296     0.200
     8.379    23.064     0.200
     8.397    26.600     0.200
     8.820    24.056     0.200
     8.966    26.266     0.200
     9.958    24.462     0.200
    10.363    28.104     0.200
    10.363    30.454     0.200
    10.609    30.590     0.200
    11.865    29.029     0.200
    12.927    33.331     0.200
    12.904    32.252     0.200
    12.928    33.330     0.200
    13.077    34.281     0.200
    13.688    32.128     0.200
    13.688    33.553     0.200
    14.169    34.475     0.200
    14.169    33.345     0.200
    14.169    33.520     0.200
    16.844    35.524     0.200
     0.979     8.292     0.200
     1.883    10.662     0.200
     1.883    10.217     0.200
     3.054    12.681     0.200
     4.723    16.631     0.200
     4.915    17.155     0.200
     6.578    19.309     0.200
     6.580    21.729     0.200
     6.580    21.487     0.200
     6.580    21.432     0.200
     6.580    21.126     0.200
     8.093    24.565     0.200
     8.144    22.979     0.200
    10.256    29.434     0.200
    12.202    34.584     0.200
    14.908    34.886     0.200
    14.911    34.858     0.200
    18.105    37.735     0.200
     1.949    10.148     0.200
     3.068    12.870     0.200
     3.579    13.210     0.200
     4.789    17.926     0.200
     4.932    17.620     0.200
     6.540    22.223     0.200
     6.541    20.636     0.200
     6.541    22.148     0.200
     6.541    21.659     0.200
     7.906    22.815     0.200
     7.972    24.286     0.200
     8.056    24.544     0.200
     8.437    22.318     0.200
     9.291    23.769     0.200
     9.293    23.978     0.200
    10.328    31.269     0.200
    11.060    28.901     0.200
    12.214    34.838     0.200
    12.191    32.190     0.200
    12.214    31.048     0.200
    12.624    34.156     0.200
    12.645    31.507     0.200
    14.939    34.879     0.200
    14.939    35.867     0.200
    14.939    34.828     0.200
    18.162    39.090     0.200
     1.917    10.234     0.200
     1.917     9.974     0.200
     3.020    12.570     0.200
     3.531    12.701     0.200
     4.757    17.210     0.200
     4.883    18.320     0.200
     6.586    18.521     0.200
     6.587    21.135     0.200
     6.587    18.394     0.200
     6.587    20.933     0.200
     6.587    20.212     0.200
     7.998    24.329     0.200
     8.103    22.698     0.200
     8.215    22.336     0.200
    10.330    30.153     0.200
    12.258    34.206     0.200
    12.258    31.106     0.200
    14.892    35.467     0.200
    14.895    35.431     0.200
     0.303     5.609     0.200
     0.310     5.420     0.200
     0.500     4.906     0.200
     0.588     5.380     0.200
     0.662     5.913     0.200
     0.906     5.974     0.200
     0.948     6.078     0.200
     0.985     6.443     0.200
     1.071     5.945     0.200
     1.224     5.865     0.200
     1.294     7.444     0.200
     1.538     8.219     0.200
     2.375     8.934     0.200
     2.659    10.612     0.200
     2.701    10.925     0.200
     2.736    10.414     0.200
     3.292     9.631     0.200
     4.587    16.406     0.200
     6.950    19.592     0.200
    12.450    32.641     0.200
    14.547    34.783     0.200
     0.128     7.095     0.200
     0.272     6.619     0.200
     0.272     6.595     0.200
     0.546     5.722     0.200
     0.697     5.759     0.200
     0.995     6.785     0.200
     0.989     5.451     0.200
     1.277     6.390     0.200
     1.240     7.217     0.200
     1.394     7.125     0.200
     1.396     6.500     0.200
     1.415     6.984     0.200
     1.930     9.076     0.200
     2.849    11.042     0.200
     3.340     9.715     0.200
     4.716    15.758     0.200
     4.757    15.563     0.200
     4.757    15.784     0.200
     5.371    14.117     0.200
     6.709    22.140     0.200
     6.709    19.599     0.200
     6.709    19.587     0.200
     8.209    21.467     0.200
     8.230    23.660     0.200
     8.670    23.919     0.200
    10.485    26.763     0.200
    10.485    28.239     0.200
    11.058    28.741     0.200
    12.869    30.214     0.200
    14.758    32.354     0.200
     0.270     6.287     0.200
     0.300     6.738     0.200
     0.301     6.825     0.200
     0.352     5.632     0.200
     0.723     6.102     0.200
     0.794     6.573     0.200
     0.931     5.070     0.200
     1.094     6.168     0.200
     1.337     7.640     0.200
     1.352     6.659     0.200
     1.358     7.594     0.200
     1.841     8.383     0.200
     2.267     8.683     0.200
     2.267     9.082     0.200
     2.569    10.359     0.200
     2.617    10.595     0.200
     2.617    10.696     0.200
     2.645    10.268     0.200
     4.512    14.482     0.200
     4.512    14.783     0.200
     4.646    15.217     0.200
     4.646    13.275     0.200
     6.900    17.926     0.200
     6.901    18.203     0.200
     6.901    19.102     0.200
     6.901    18.703     0.200
     6.901    19.301     0.200
     8.336    21.427     0.200
     8.424    21.401     0.200
     8.847    23.898     0.200
     9.550    21.643     0.200
     9.550    21.225     0.200
     9.627    26.786     0.200
    10.520    25.138     0.200
    10.520    27.165     0.200
    12.666    29.923     0.200
    12.666    28.980     0.200
    12.666    29.922     0.200
    13.547    32.642     0.200
    14.562    30.495     0.200
    14.562    32.421     0.200
    14.562    29.854     0.200
    14.565    32.376     0.200
     0.270     7.152     0.200
     0.240     7.500     0.200
     0.280     7.141     0.200
     0.325     6.315     0.200
     0.386     7.099     0.200
     0.450     7.355     0.200
     0.451     6.967     0.200
     0.451     7.547     0.200
     0.566     6.600     0.200
     0.774     6.867     0.200
     0.772     5.598     0.200
     1.026     6.430     0.200
     1.024     6.756     0.200
     1.196     7.251     0.200
     1.199     7.310     0.200
     1.375     6.859     0.200
     1.435     7.554     0.200
     1.441     6.885     0.200
     1.583     7.835     0.200
     1.591     8.642     0.200
     1.556     7.647     0.200
     1.692     8.404     0.200
     1.692     7.494     0.200
     1.692     8.254     0.200
     1.706     7.398     0.200
     1.796     7.950     0.200
     1.969     8.429     0.200
     2.119     9.678     0.200
     2.123     8.733     0.200
     2.182     8.941     0.200
     2.195     8.685     0.200
     2.260     8.624     0.200
     2.260     9.224     0.200
     2.281     9.281     0.200
     2.556     9.173     0.200
     2.556     9.873     0.200
     2.602    10.640     0.200
     2.633    10.277     0.200
     2.904    10.211     0.200
     2.974    11.600     0.200
     3.152    10.224     0.200
     3.152    10.923     0.200
     3.236    10.038     0.200
     3.741    10.748     0.200
     4.179    11.130     0.200
     4.497    14.930     0.200
     4.446    12.623     0.200
     4.509    14.383     0.200
     4.509    14.823     0.200
     4.587    13.677     0.200
     5.298    13.772     0.200
     6.533    18.169     0.200
     6.663    18.151     0.200
     6.956    18.576     0.200
     6.957    18.009     0.200
     6.957    18.191     0.200
     6.958    17.909     0.200
     6.958    18.259     0.200
     7.610    20.196     0.200
     8.208    21.550     0.200
     8.422    23.822     0.200
     8.445    21.346     0.200
     8.476    20.246     0.200
     8.740    22.610     0.200
     9.159    23.419     0.200
     9.466    27.936     0.200
     9.650    19.641     0.200
     9.650    19.406     0.200
     9.967    23.986     0.200
    10.359    25.961     0.200
    10.359    26.111     0.200
    10.820    27.734     0.200
    11.110    27.748     0.200
    12.213    29.779     0.200
    12.617    29.564     0.200
    12.594    28.069     0.200
    12.617    29.733     0.200
    12.617    29.563     0.200
    12.887    29.910     0.200
    13.342    29.483     0.200
    13.483    30.516     0.200
    13.507    31.781     0.200
    14.514    32.072     0.200
    14.514    31.386     0.200
    14.514    29.873     0.200
    14.900    32.724     0.200
    14.900    31.006     0.200
    15.390    31.600     0.200
    17.528    33.463     0.200
     0.229     6.286     0.200
     0.188     6.759     0.200
     0.341     6.183     0.200
     0.341     6.394     0.200
     0.389     5.614     0.200
     0.399     6.700     0.200
     0.644     6.443     0.200
     0.840     6.350     0.200
     0.880     5.392     0.200
     1.117     6.117     0.200
     1.248     7.689     0.200
     1.300     7.792     0.200
     1.805     8.648     0.200
     1.805     7.938     0.200
     2.621     9.466     0.200
     2.669     9.915     0.200
     2.698     9.972     0.200
     3.200    10.217     0.200
     4.564    15.897     0.200
     4.622    15.621     0.200
     5.364    15.658     0.200
     6.775    20.089     0.200
     6.867    18.420     0.200
     6.868    18.384     0.200
     6.868    18.004     0.200
     6.868    18.592     0.200
     8.247    23.139     0.200
     8.247    21.795     0.200
     8.389    21.168     0.200
     8.758    22.558     0.200
     9.570    26.971     0.200
     9.544    19.630     0.200
     9.544    19.667     0.200
    10.008    24.863     0.200
    10.008    28.423     0.200
    10.444    26.625     0.200
    10.444    23.675     0.200
    10.933    29.074     0.200
    11.223    28.088     0.200
    12.290    27.230     0.200
    12.589    30.041     0.200
    12.567    29.045     0.200
    12.589    30.390     0.200
    12.589    30.040     0.200
    12.918    30.700     0.200
    13.275    29.565     0.200
    13.275    29.980     0.200
    13.473    32.228     0.200
    14.433    33.024     0.200
    14.599    31.308     0.200
    14.599    31.448     0.200
    14.599    29.558     0.200
    14.602    31.412     0.200
    14.982    34.117     0.200
    15.484    32.156     0.200
    16.575    34.025     0.200
     0.162     6.439     0.200
     0.243     6.394     0.200
     0.284     6.518     0.200
     0.285     6.438     0.200
     0.285     6.208     0.200
     0.382     5.474     0.200
     0.469     6.357     0.200
     0.717     6.160     0.200
     0.825     6.303     0.200
     0.940     5.062     0.200
     1.123     6.126     0.200
     1.322     7.902     0.200
     1.364     7.717     0.200
     1.384     6.185     0.200
     1.724     7.909     0.200
     1.782     7.939     0.200
     1.855     8.530     0.200
     1.855     8.089     0.200
     2.021     8.744     0.200
     2.133     8.844     0.200
     2.299     9.205     0.200
     2.273     9.412     0.200
     2.350     9.705     0.200
     2.526     7.549     0.200
     2.601     9.483     0.200
     2.649    10.117     0.200
     2.677     9.692     0.200
     2.688    10.065     0.200
     2.659     9.299     0.200
     2.797    10.097     0.200
     2.868    10.362     0.200
     3.166    10.181     0.200
     3.127    10.037     0.200
     3.438    11.308     0.200
     3.507    11.902     0.200
     3.626    10.613     0.200
     3.958    12.048     0.200
     4.057    10.890     0.200
     4.337    12.422     0.200
     4.544    14.606     0.200
     4.665    14.282     0.200
     5.215    14.168     0.200
     5.439    15.060     0.200
     5.630    16.227     0.200
     6.499    16.389     0.200
     6.822    19.624     0.200
     6.869    18.163     0.200
     6.870    17.878     0.200
     6.870    18.257     0.200
     6.870    18.256     0.200
     6.870    18.405     0.200
     7.302    20.218     0.200
     8.318    21.635     0.200
     8.318    22.410     0.200
     8.393    20.629     0.200
     8.577    23.643     0.200
     9.101    23.828     0.200
     9.213    23.817     0.200
     9.523    21.050     0.200
     9.523    20.979     0.200
     9.634    25.699     0.200
     9.979    23.682     0.200
    10.080    26.267     0.200
    10.517    27.047     0.200
    10.517    25.598     0.200
    10.660    26.626     0.200
    10.981    27.984     0.200
    11.264    28.185     0.200
    12.278    27.850     0.200
    12.637    30.113     0.200
    12.614    29.215     0.200
    12.637    29.144     0.200
    12.637    30.112     0.200
    12.839    29.700     0.200
    12.988    30.559     0.200
    13.297    29.932     0.200
    13.297    29.186     0.200
    13.509    30.656     0.200
    13.509    31.914     0.200
    13.517    31.589     0.200
    14.499    32.433     0.200
    14.974    29.602     0.200
    14.974    29.883     0.200
    15.180    29.640     0.200
    15.554    31.612     0.200
    16.634    34.311     0.200
    19.615    37.495     0.200
     0.164     6.591     0.200
     0.241     5.989     0.200
     0.283     6.604     0.200
     0.384     5.521     0.200
     0.468     6.051     0.200
     0.717     5.939     0.200
     0.828     6.442     0.200
     0.941     5.125     0.200
     1.126     5.967     0.200
     1.321     7.287     0.200
     1.364     7.486     0.200
     1.386     6.527     0.200
     1.857     8.740     0.200
     2.603    10.426     0.200
     2.651    11.065     0.200
     2.680    10.534     0.200
     3.169    11.527     0.200
     4.546    16.850     0.200
     6.868    19.492     0.200
     8.317    21.779     0.200
     0.309     7.107     0.200
     0.163     7.205     0.200
     0.242     6.783     0.200
     0.393     6.630     0.200
     0.432     5.968     0.200
     0.662     5.988     0.200
     0.882     6.717     0.200
     0.914     5.344     0.200
     1.163     6.243     0.200
     1.251     7.315     0.200
     1.331     7.285     0.200
     1.454     6.947     0.200
     1.844     8.721     0.200
     2.362     9.749     0.200
     2.662    10.946     0.200
     2.710    11.091     0.200
     2.739    10.852     0.200
     3.236    10.847     0.200
     4.605    16.274     0.200
     4.663    16.090     0.200
     6.824    19.031     0.200
     8.242    23.300     0.200
     9.498    21.089     0.200
    12.560    28.413     0.200
     0.411     4.231     0.200
     0.492     4.078     0.200
     0.579     4.167     0.200
     0.782     5.204     0.200
     0.851     6.195     0.200
     0.874     5.727     0.200
     1.073     5.502     0.200
     1.158     6.110     0.200
     1.208     6.732     0.200
     1.445     7.234     0.200
     1.445     7.648     0.200
     2.398     9.733     0.200
     2.677    10.287     0.200
     2.753    11.193     0.200
     4.284    14.723     0.200
     4.596    15.991     0.200
     6.974    21.836     0.200
     6.987    20.392     0.200
     6.989    20.463     0.200
     6.989    20.560     0.200
     6.989    20.372     0.200
     7.860    21.320     0.200
     8.496    23.220     0.200
     9.990    28.815     0.200
    12.408    34.945     0.200
    14.524    35.881     0.200
    14.524    35.662     0.200
    14.524    35.982     0.200
    15.032    34.305     0.200
    19.982    37.907     0.200
     0.136     6.874     0.200
     0.273     6.075     0.200
     0.300     6.083     0.200
     0.299     6.569     0.200
     0.351     5.466     0.200
     0.492     6.018     0.200
     0.726     5.892     0.200
     0.792     6.417     0.200
     0.933     4.770     0.200
     0.938     7.609     0.200
     1.093     6.099     0.200
     1.340     7.626     0.200
     1.350     6.411     0.200
     1.360     7.491     0.200
     1.842     8.376     0.200
     2.265     9.130     0.200
     2.567    10.105     0.200
     2.615    10.942     0.200
     2.643    11.115     0.200
     3.132    10.207     0.200
     4.510    15.630     0.200
     6.901    18.586     0.200
     6.902    18.629     0.200
     6.902    18.160     0.200
     8.425    22.998     0.200
     0.337     7.657     0.200
     0.376     7.410     0.200
     0.458     7.748     0.200
     0.622     6.936     0.200
     0.765     6.767     0.200
     0.848     7.002     0.200
     0.881     6.812     0.200
     0.958     7.217     0.200
     1.082     6.466     0.200
     1.117     6.364     0.200
     1.211     7.266     0.200
     1.337     7.098     0.200
     1.525     8.096     0.200
     1.545     8.169     0.200
     1.585     7.798     0.200
     1.605     7.968     0.200
     1.823     9.020     0.200
     1.823     8.817     0.200
     2.132     9.617     0.200
     2.132     9.312     0.200
     2.185     9.803     0.200
     2.207     9.435     0.200
     2.207     9.537     0.200
     2.658     9.277     0.200
     2.658     9.074     0.200
     4.071    13.989     0.200
     4.071    14.786     0.200
     0.198     7.186     0.200
     0.198     7.429     0.200
     0.198     7.179     0.200
     0.246     6.619     0.200
     0.213     6.605     0.200
     0.510     5.738     0.200
     0.462     6.105     0.200
     0.765     5.967     0.200
     0.950     6.908     0.200
     0.918     7.182     0.200
     1.031     5.564     0.200
     1.252     6.376     0.200
     1.327     7.412     0.200
     1.445     7.625     0.200
     1.961     8.903     0.200
     2.417     9.190     0.200
     2.720     9.648     0.200
     2.769    10.474     0.200
     2.797     9.758     0.200
     3.275     9.371     0.200
     4.664    14.670     0.200
     4.779    15.523     0.200
     6.742    18.498     0.200
     6.743    18.475     0.200
     6.743    18.905     0.200
     6.743    18.506     0.200
     6.932    20.091     0.200
     8.266    21.689     0.200
     8.300    24.685     0.200
     8.300    22.249     0.200
     8.692    23.863     0.200
     9.395    19.375     0.200
     9.396    21.667     0.200
    10.561    28.551     0.200
    12.548    32.802     0.200
    12.526    33.324     0.200
    13.180    31.109     0.200
    14.720    29.273     0.200
    14.720    29.011     0.200
    15.061    31.229     0.200
    15.061    31.227     0.200
     0.174     7.090     0.200
     0.234     6.894     0.200
     0.320     6.987     0.200
     0.397     6.497     0.200
     0.414     6.104     0.200
     0.656     5.973     0.200
     0.847     7.239     0.200
     0.864     6.848     0.200
     0.901     5.519     0.200
     1.143     6.281     0.200
     1.251     7.224     0.200
     1.319     7.438     0.200
     1.828     8.594     0.200
     2.344     9.768     0.200
     2.644    10.471     0.200
     2.721    10.476     0.200
     3.220     9.958     0.200
     4.587    16.198     0.200
     6.843    18.692     0.200
     8.246    24.154     0.200
     0.134     6.469     0.200
     0.188     6.929     0.200
     0.313     5.677     0.200
     0.436     5.345     0.200
     0.555     5.854     0.200
     0.823     5.924     0.200
     0.857     6.424     0.200
     1.046     5.222     0.200
     1.180     6.358     0.200
     1.382     6.701     0.200
     1.955     8.710     0.200
     2.312     8.050     0.200
     2.312     8.950     0.200
     2.617    10.488     0.200
     2.617    10.788     0.200
     2.667    10.904     0.200
     2.693    10.601     0.200
     4.560    14.816     0.200
     4.560    17.716     0.200
     6.832    19.125     0.200
     0.146     7.166     0.200
     0.260     6.231     0.200
     0.317     6.565     0.200
     0.318     6.159     0.200
     0.318     6.739     0.200
     0.444     5.783     0.200
     0.376     6.581     0.200
     0.650     6.180     0.200
     0.895     6.523     0.200
     0.829     7.490     0.200
     0.909     5.359     0.200
     1.172     6.092     0.200
     1.235     7.455     0.200
     1.323     7.423     0.200
     1.469     6.622     0.200
     1.426     6.724     0.200
     1.841     8.579     0.200
     4.618    14.973     0.200
     4.663    15.550     0.200
     4.663    15.439     0.200
     5.357    15.645     0.200
     6.812    18.619     0.200
     6.814    18.571     0.200
     6.814    18.251     0.200
     6.814    18.788     0.200
     6.814    18.452     0.200
     8.225    22.595     0.200
     8.225    21.552     0.200
     8.225    22.897     0.200
     8.334    21.256     0.200
     8.576    24.086     0.200
     9.493    19.852     0.200
     9.593    26.914     0.200
     9.988    25.011     0.200
    10.449    25.298     0.200
    10.449    26.321     0.200
    10.970    28.045     0.200
    12.543    30.091     0.200
    12.543    28.799     0.200
    12.893    29.701     0.200
    13.221    30.180     0.200
    13.221    28.949     0.200
    14.654    31.706     0.200
    14.657    31.670     0.200
    15.037    31.985     0.200
    17.584    31.958     0.200
     0.193     6.306     0.200
     0.292     6.253     0.200
     0.292     6.473     0.200
     0.291     6.262     0.200
     0.213     6.178     0.200
     0.400     5.487     0.200
     0.440     6.029     0.200
     0.696     5.942     0.200
     0.847     6.277     0.200
     0.929     5.113     0.200
     1.138     5.978     0.200
     1.295     7.350     0.200
     1.351     7.697     0.200
     1.851     8.436     0.200
     1.850     8.452     0.200
     2.252     7.082     0.200
     2.624     9.734     0.200
     2.624     8.834     0.200
     2.672    11.073     0.200
     2.672    10.273     0.200
     2.701    10.241     0.200
     2.701     9.942     0.200
     4.567    15.358     0.200
     4.567    14.158     0.200
     4.664    15.625     0.200
     4.664    15.026     0.200
     4.664    13.995     0.200
     5.413    15.886     0.200
     6.851    18.820     0.200
     6.852    19.195     0.200
     6.852    18.124     0.200
     6.852    18.694     0.200
     6.852    18.899     0.200
     8.289    19.824     0.200
     8.289    19.741     0.200
     8.374    21.793     0.200
     8.577    24.670     0.200
     9.513    20.847     0.200
     9.514    21.217     0.200
     9.622    27.175     0.200
    10.496    28.171     0.200
    10.496    28.673     0.200
    12.607    31.286     0.200
    12.592    27.449     0.200
    12.607    30.135     0.200
    12.958    31.734     0.200
    13.273    28.879     0.200
    13.273    28.765     0.200
    14.613    32.530     0.200
    17.641    34.088     0.200
     0.266     7.039     0.200
     0.267     7.031     0.200
     0.267     6.921     0.200
     0.192     6.610     0.200
     0.217     6.714     0.200
     0.430     6.132     0.200
     0.441     5.801     0.200
     0.705     5.916     0.200
     0.887     6.899     0.200
     0.884     7.228     0.200
     0.955     5.505     0.200
     1.179     6.291     0.200
     1.291     7.286     0.200
     1.373     8.028     0.200
     2.288     7.552     0.200
     2.288     7.451     0.200
     2.663     9.467     0.200
     2.663     9.067     0.200
     2.712    10.304     0.200
     2.712     9.504     0.200
     2.740    10.375     0.200
     2.740    10.175     0.200
     4.607    15.090     0.200
     4.607    14.390     0.200
     4.698    17.221     0.200
     4.698    13.321     0.200
     6.811    19.215     0.200
     8.279    22.090     0.200
     0.167     6.868     0.200
     0.239     6.320     0.200
     0.267     6.994     0.200
     0.268     6.883     0.200
     0.268     6.993     0.200
     0.399     5.654     0.200
     0.470     6.123     0.200
     0.727     6.028     0.200
     0.841     6.595     0.200
     0.922     7.552     0.200
     0.955     5.064     0.200
     1.141     6.197     0.200
     1.327     7.531     0.200
     1.378     7.531     0.200
     1.396     6.719     0.200
     1.871     8.472     0.200
     1.872     8.461     0.200
     2.237     7.511     0.200
     2.615     9.791     0.200
     2.664    10.624     0.200
     2.692    10.201     0.200
     4.559    15.512     0.200
     4.683    12.954     0.200
     6.837    19.628     0.200
     6.852    17.957     0.200
     6.854    18.832     0.200
     6.854    17.812     0.200
     6.854    19.047     0.200
     6.854    18.910     0.200
     8.280    22.081     0.200
     8.320    20.687     0.200
     8.595    24.412     0.200
    10.527    24.762     0.200
    12.628    30.627     0.200
     0.100     5.446     0.200
     0.245     4.452     0.200
     0.466     4.478     0.200
     0.484     5.961     0.200
     0.620     4.872     0.200
     0.621     5.471     0.200
     0.648     4.850     0.200
     0.755     5.102     0.200
     0.858     5.106     0.200
     0.892     6.107     0.200
     1.039     5.287     0.200
     1.195     6.568     0.200
     1.121     5.933     0.200
     1.199     6.425     0.200
     1.214     6.650     0.200
     1.394     6.253     0.200
     1.805     8.046     0.200
     1.806     8.042     0.200
     2.648     8.414     0.200
     2.648     8.015     0.200
     2.678    10.060     0.200
     2.678     9.662     0.200
     2.968    10.879     0.200
     2.968    10.277     0.200
     3.045    11.579     0.200
     3.045    11.379     0.200
     4.645    15.408     0.200
     4.645    14.560     0.200
     4.902    17.506     0.200
     4.902    16.705     0.200
     5.023    13.897     0.200
     5.023    15.295     0.200
     6.622    19.616     0.200
     6.624    19.418     0.200
     6.624    19.257     0.200
     6.624    19.417     0.200
     6.624    19.616     0.200
     6.624    19.104     0.200
     7.849    23.122     0.200
     7.848    22.721     0.200
     7.848    20.518     0.200
     8.134    22.456     0.200
     8.339    22.801     0.200
     8.553    24.702     0.200
     9.414    20.323     0.200
     9.416    21.340     0.200
    10.164    27.800     0.200
    10.164    27.124     0.200
    12.181    31.906     0.200
    12.595    30.936     0.200
    12.595    29.436     0.200
    12.941    30.769     0.200
    13.072    34.761     0.200
    14.874    32.634     0.200
    14.874    32.731     0.200
    14.874    31.442     0.200
    15.267    33.452     0.200
    15.267    32.753     0.200
    18.038    34.975     0.200
     0.130     7.164     0.200
     0.271     6.724     0.200
     0.271     6.618     0.200
     0.328     6.152     0.200
     0.377     6.286     0.200
     0.555     5.500     0.200
     0.701     5.802     0.200
     0.831     7.181     0.200
     1.004     6.766     0.200
     0.996     5.561     0.200
     1.240     7.305     0.200
     1.286     6.268     0.200
     1.393     6.426     0.200
     1.408     7.049     0.200
     1.400     7.746     0.200
     1.936     9.036     0.200
     1.937     9.027     0.200
     2.406     7.800     0.200
     2.480     9.333     0.200
     2.782     8.617     0.200
     2.858     8.824     0.200
     8.207    20.207     0.200
     8.207    22.951     0.200
     0.187     6.565     0.200
     0.275     6.636     0.200
     0.219     6.296     0.200
     0.408     5.683     0.200
     0.450     5.997     0.200
     0.710     5.858     0.200
     0.853     6.594     0.200
     0.902     7.423     0.200
     0.945     5.116     0.200
     1.148     6.052     0.200
     1.307     7.398     0.200
     1.367     7.700     0.200
     1.412     6.665     0.200
     1.865     8.681     0.200
     1.866     8.694     0.200
     2.253     7.452     0.200
     2.327     9.089     0.200
     2.629    10.067     0.200
     2.705    10.376     0.200
     3.195     9.761     0.200
     4.572    14.190     0.200
     4.679    15.641     0.200
     0.100     4.515     0.200
     0.223     4.078     0.200
     0.353     3.860     0.200
     0.513     6.092     0.200
     0.619     5.056     0.200
     0.620     5.351     0.200
     0.597     4.314     0.200
     0.700     4.514     0.200
     0.915     6.499     0.200
     1.024     5.934     0.200
     1.073     6.256     0.200
     1.141     5.564     0.200
     1.179     6.823     0.200
     1.207     5.894     0.200
     1.653     8.322     0.200
     1.652     8.303     0.200
     2.483     8.106     0.200
     2.501     9.694     0.200
     2.789    10.638     0.200
     2.866    10.841     0.200
     3.412    10.368     0.200
     4.492    16.562     0.200
     4.720    16.800     0.200
     4.720    15.599     0.200
     6.810    19.605     0.200
     7.889    19.616     0.200
    12.338    29.266     0.200
     0.131     7.317     0.200
     0.294     6.911     0.200
     0.295     7.135     0.200
     0.295     7.002     0.200
     0.277     6.313     0.200
     0.352     5.733     0.200
     0.498     6.241     0.200
     0.732     5.904     0.200
     0.792     6.597     0.200
     0.939     4.885     0.200
     0.944     7.529     0.200
     1.095     6.060     0.200
     1.348     6.715     0.200
     1.346     7.545     0.200
     1.366     7.405     0.200
     1.846     8.299     0.200
     1.847     8.264     0.200
     2.189     7.004     0.200
     2.189     7.605     0.200
     2.264     9.125     0.200
     2.566     9.598     0.200
     2.566     9.801     0.200
     2.643     9.707     0.200
     3.131    10.011     0.200
     4.510    14.920     0.200
     4.510    15.818     0.200
     4.652    15.262     0.200
     4.652    13.723     0.200
     4.652    15.559     0.200
     6.900    17.586     0.200
     6.901    17.680     0.200
     6.901    18.508     0.200
     6.901    18.508     0.200
     6.901    19.399     0.200
     6.901    17.016     0.200
     8.345    21.831     0.200
     8.345    21.050     0.200
     8.424    20.594     0.200
     9.635    26.501     0.200
    10.529    26.543     0.200
    10.529    28.270     0.200
    12.672    30.163     0.200
    12.747    30.794     0.200
    13.553    31.683     0.200
    14.562    34.393     0.200
    14.562    31.761     0.200
    15.562    35.233     0.200
     0.292     6.124     0.200
     0.329     5.799     0.200
     0.335     5.423     0.200
     0.447     5.212     0.200
     0.512     5.162     0.200
     0.567     5.020     0.200
     0.617     6.533     0.200
     0.847     6.150     0.200
     0.977     6.240     0.200
     1.013     6.015     0.200
     0.990     6.181     0.200
     1.187     7.378     0.200
     1.263     7.191     0.200
     1.277     6.027     0.200
     1.362     8.043     0.200
     1.511     8.323     0.200
     2.309     7.588     0.200
     2.315     8.517     0.200
     2.600    10.194     0.200
     2.677    10.797     0.200
     3.232    10.512     0.200
     4.529    14.687     0.200
     7.002    20.545     0.200
     0.199     3.850     0.200
     0.350     4.882     0.200
     0.425     3.612     0.200
     0.555     4.487     0.200
     0.535     6.226     0.200
     0.668     4.582     0.200
     0.823     5.771     0.200
     0.823     5.474     0.200
     0.821     5.300     0.200
     0.902     5.640     0.200
     0.874     6.275     0.200
     1.005     5.641     0.200
     1.037     6.667     0.200
     1.137     6.307     0.200
     1.201     7.154     0.200
     1.377     7.126     0.200
     2.337     9.606     0.200
     2.357     7.957     0.200
     2.357     7.761     0.200
     2.612    10.482     0.200
     2.689    11.292     0.200
     4.215    14.775     0.200
     4.215    12.478     0.200
     4.528    16.332     0.200
     6.352    20.543     0.200
     7.064    21.418     0.200
     7.065    21.423     0.200
     7.065    21.109     0.200
     7.065    20.320     0.200
     7.877    23.203     0.200
     8.127    25.930     0.200
     9.967    26.360     0.200
     9.967    27.657     0.200
    10.499    29.253     0.200
    12.193    31.874     0.200
    12.464    32.168     0.200
    12.464    34.113     0.200
    14.449    35.367     0.200
    14.998    32.142     0.200
    15.007    34.046     0.200
    17.590    37.446     0.200
    17.590    36.532     0.200
     0.216     4.291     0.200
     0.367     4.825     0.200
     0.415     3.866     0.200
     0.476     4.665     0.200
     0.539     4.421     0.200
     0.556     5.726     0.200
     0.661     4.396     0.200
     0.882     5.626     0.200
     0.891     5.712     0.200
     0.983     5.536     0.200
     1.048     6.280     0.200
     1.124     6.295     0.200
     2.315     9.102     0.200
     2.315     9.902     0.200
     2.336     7.852     0.200
     2.590     9.885     0.200
     2.590    10.486     0.200
     2.667     9.991     0.200
     2.667    10.593     0.200
     4.204    16.252     0.200
     4.506    15.332     0.200
     4.506    16.832     0.200
     0.227     8.802     0.200
     0.316     8.262     0.200
     0.324     8.267     0.200
     0.436     8.365     0.200
     0.593     8.035     0.200
     0.593     7.416     0.200
     0.592     7.345     0.200
     0.681     7.406     0.200
     0.808     7.326     0.200
     0.935     7.042     0.200
     0.972     6.906     0.200
     1.010     6.363     0.200
     1.036     7.361     0.200
     1.274     7.383     0.200
     1.353     7.164     0.200
     1.440     7.749     0.200
     1.489     7.878     0.200
     1.523     7.780     0.200
     1.518     7.933     0.200
     1.640     8.910     0.200
     1.775     6.542     0.200
     1.784     8.735     0.200
     1.785     8.719     0.200
     1.862     8.519     0.200
     2.168     8.948     0.200
     2.244     9.063     0.200
     4.111    12.481     0.200
     4.501    14.330     0.200
     4.501    12.750     0.200
     6.673    18.383     0.200
     7.269    18.675     0.200
     7.270    18.212     0.200
     7.270    18.501     0.200
     7.270    18.110     0.200
     7.270    18.161     0.200
     8.397    22.064     0.200
     8.650    21.410     0.200
     8.797    21.432     0.200
     9.839    21.042     0.200
     9.840    20.836     0.200
    10.406    24.117     0.200
    10.666    26.432     0.200
    10.842    26.130     0.200
    11.071    27.549     0.200
    12.768    30.252     0.200
    13.082    30.411     0.200
    14.190    30.116     0.200
    14.190    28.821     0.200
    15.409    31.126     0.200
    15.610    32.088     0.200
     1.073     8.750     0.200
     1.310     8.683     0.200
     1.347     8.657     0.200
     1.595    10.457     0.200
     1.735    10.946     0.200
     1.736    11.012     0.200
     3.545    16.197     0.200
     4.239    14.096     0.200
     4.217    16.756     0.200
     4.446    18.288     0.200
     4.446    15.155     0.200
     5.049    21.652     0.200
     5.165    18.601     0.200
     5.349    21.852     0.200
     5.349    22.453     0.200
     6.042    21.759     0.200
     6.071    24.326     0.200
     6.484    23.907     0.200
     6.484    22.407     0.200
     6.544    23.002     0.200
     6.546    23.076     0.200
     6.546    22.849     0.200
     6.546    22.779     0.200
     6.546    22.978     0.200
     6.546    23.084     0.200
     6.774    23.625     0.200
     6.867    25.235     0.200
     7.012    21.238     0.200
     7.044    20.769     0.200
     7.044    20.570     0.200
     7.044    20.747     0.200
     7.123    24.945     0.200
     7.190    26.663     0.200
     7.206    26.676     0.200
     7.567    22.662     0.200
     7.751    27.011     0.200
     7.868    26.752     0.200
     8.015    27.435     0.200
     8.017    27.026     0.200
     8.298    27.728     0.200
     8.298    28.126     0.200
     8.660    23.112     0.200
     8.806    26.600     0.200
     8.806    26.319     0.200
     8.848    25.611     0.200
     9.436    26.656     0.200
     9.567    26.812     0.200
    10.556    31.376     0.200
    10.556    31.978     0.200
    10.789    32.465     0.200
    10.993    32.785     0.200
    11.136    33.017     0.200
    11.580    33.427     0.200
    11.897    31.227     0.200
    12.235    34.586     0.200
    12.378    35.422     0.200
    12.807    37.218     0.200
    12.915    34.849     0.200
    12.957    35.469     0.200
    14.568    33.565     0.200
    14.568    37.865     0.200
    14.651    35.589     0.200
    15.120    37.719     0.200
    15.120    35.797     0.200
    15.175    36.483     0.200
    15.438    37.309     0.200
    15.534    36.686     0.200
    15.534    35.948     0.200
    16.446    40.343     0.200
    17.942    40.193     0.200
    20.987    46.149     0.200
     0.157     6.764     0.200
     0.256     6.401     0.200
     0.313     6.654     0.200
     0.313     6.544     0.200
     0.351     5.590     0.200
     0.472     6.387     0.200
     0.704     6.175     0.200
     0.796     6.597     0.200
     0.917     7.890     0.200
     0.915     5.109     0.200
     1.092     6.251     0.200
     1.318     7.808     0.200
     1.341     7.641     0.200
     1.360     6.519     0.200
     1.827     7.542     0.200
     1.826     7.579     0.200
     1.826     7.379     0.200
     2.573    10.260     0.200
     2.650    11.268     0.200
     4.516    15.883     0.200
     4.635    13.902     0.200
     4.635    15.202     0.200
     5.430    16.119     0.200
     6.900    17.063     0.200
     6.901    22.058     0.200
     6.901    17.308     0.200
     6.901    17.858     0.200
     6.901    18.183     0.200
     6.901    17.068     0.200
     8.318    20.315     0.200
     8.318    22.166     0.200
     9.611    23.930     0.200
     9.611    26.730     0.200
    10.502    26.233     0.200
    10.502    25.633     0.200
    12.249    29.046     0.200
    12.655    30.160     0.200
    13.537    32.619     0.200
     0.541     5.478     0.200
     0.571     5.232     0.200
     0.713     5.280     0.200
     0.704     5.582     0.200
     0.871     5.831     0.200
     0.961     5.481     0.200
     1.032     5.857     0.200
     1.245     6.068     0.200
     1.335     7.323     0.200
     1.374     5.761     0.200
     1.381     5.678     0.200
     1.474     7.201     0.200
     1.489     6.519     0.200
     1.489     7.316     0.200
     1.591     7.230     0.200
     1.635     8.527     0.200
     1.800     7.393     0.200
     1.847     8.028     0.200
     1.849     8.444     0.200
     1.874     8.321     0.200
     3.735    13.605     0.200
     4.418    13.439     0.200
     4.418    12.970     0.200
     7.620    19.175     0.200
     7.620    18.480     0.200
     7.620    19.175     0.200
     7.620    19.309     0.200
     7.620    19.043     0.200
     8.977    24.844     0.200
     8.977    23.148     0.200
    10.843    29.083     0.200
    10.843    27.154     0.200
    13.487    35.300     0.200
    13.845    32.724     0.200
    14.126    32.588     0.200
    15.596    34.375     0.200
     0.235     3.854     0.200
     0.411     4.401     0.200
     0.586     6.058     0.200
     0.674     4.926     0.200
     0.850     5.476     0.200
     0.790     6.073     0.200
     0.908     6.197     0.200
     1.047     6.874     0.200
     1.328     7.814     0.200
     1.329     8.041     0.200
     1.603     7.084     0.200
     2.279    10.094     0.200
     2.554    11.090     0.200
     2.630    12.002     0.200
     4.165    14.689     0.200
     4.165    14.306     0.200
     4.467    16.464     0.200
     4.467    17.066     0.200
     4.933    12.730     0.200
     6.305    20.412     0.200
     7.128    20.308     0.200
     7.128    19.706     0.200
     7.128    20.947     0.200
     7.128    20.611     0.200
     7.903    20.763     0.200
     7.903    21.240     0.200
     8.078    23.728     0.200
     8.078    24.626     0.200
     9.061    27.054     0.200
     9.657    24.296     0.200
     9.921    24.835     0.200
     9.961    25.706     0.200
     9.961    26.854     0.200
     9.961    29.151     0.200
    10.454    28.197     0.200
    12.123    31.022     0.200
    12.169    30.181     0.200
    12.518    31.651     0.200
    12.501    31.503     0.200
    12.519    31.104     0.200
    13.398    32.667     0.200
    14.385    33.115     0.200
    14.385    33.428     0.200
    14.385    35.670     0.200
    14.385    34.225     0.200
    14.983    36.139     0.200
    14.986    33.506     0.200
    15.567    32.927     0.200
    15.662    33.314     0.200
    15.662    34.096     0.200
    17.162    37.916     0.200
    20.764    37.985     0.200
     0.158     5.885     0.200
     0.248     5.436     0.200
     0.331     5.067     0.200
     0.542     5.016     0.200
     0.550     5.016     0.200
     0.631     5.971     0.200
     0.536     6.577     0.200
     0.652     5.226     0.200
     0.931     6.372     0.200
     0.970     6.117     0.200
     1.036     6.639     0.200
     1.179     6.081     0.200
     1.147     5.949     0.200
     1.174     6.838     0.200
     1.363     7.325     0.200
     1.604     8.318     0.200
     1.604     8.338     0.200
     2.430     7.672     0.200
     2.444     8.508     0.200
     2.444     9.309     0.200
     2.486    10.618     0.200
     2.731     9.166     0.200
     2.731    10.066     0.200
     2.808    10.268     0.200
     4.661    13.439     0.200
     6.871    19.926     0.200
     9.642    20.984     0.200
     0.457     4.272     0.200
     0.517     5.076     0.200
     0.578     5.167     0.200
     0.762     5.219     0.200
     0.753     6.126     0.200
     0.823     5.605     0.200
     0.975     6.632     0.200
     1.150     6.791     0.200
     1.150     6.294     0.200
     1.150     6.190     0.200
     1.166     7.207     0.200
     1.642     8.770     0.200
     1.643     8.741     0.200
     1.643     8.501     0.200
     1.873     8.987     0.200
     2.985     9.674     0.200
     3.223    13.503     0.200
     4.427    15.896     0.200
     4.770    15.611     0.200
     5.284    18.042     0.200
     6.637    18.354     0.200
     6.637    21.954     0.200
     6.637    21.554     0.200
     6.637    21.082     0.200
     6.637    21.951     0.200
     7.333    22.332     0.200
     8.124    24.364     0.200
     9.577    21.144     0.200
     9.658    25.181     0.200
    11.005    32.382     0.200
    14.958    36.151     0.200
    14.958    36.602     0.200
    14.958    36.302     0.200
    15.366    34.392     0.200
    16.713    35.372     0.200
     0.508     5.080     0.200
     0.594     4.779     0.200
     0.747     5.986     0.200
     0.916     5.821     0.200
     1.136     6.254     0.200
     1.155     7.032     0.200
     1.143     6.534     0.200
     1.143     6.268     0.200
     1.626     8.703     0.200
     1.627     7.964     0.200
     1.889     8.646     0.200
     4.413    16.483     0.200
     4.784    15.055     0.200
     5.301    17.636     0.200
     6.478    17.149     0.200
     6.654    20.577     0.200
     6.654    21.460     0.200
     6.654    21.766     0.200
     7.343    20.961     0.200
     7.343    20.063     0.200
     8.141    24.313     0.200
     9.658    25.544     0.200
    11.857    32.691     0.200
    14.940    35.783     0.200
     0.162     7.199     0.200
     0.235     6.848     0.200
     0.246     6.717     0.200
     0.327     6.881     0.200
     0.328     6.897     0.200
     0.421     5.985     0.200
     0.384     6.610     0.200
     0.646     6.053     0.200
     0.872     6.621     0.200
     0.835     7.348     0.200
     0.896     5.243     0.200
     1.149     6.189     0.200
     1.161     6.851     0.200
     1.240     7.330     0.200
     1.312     7.278     0.200
     1.448     6.902     0.200
     1.552     7.078     0.200
     1.824     8.563     0.200
     1.825     8.248     0.200
     1.825     8.600     0.200
     2.086     8.790     0.200
     2.289     8.080     0.200
     2.289     7.978     0.200
     2.353     9.633     0.200
     2.353     9.734     0.200
     2.653    10.636     0.200
     2.653    10.035     0.200
     2.729    10.742     0.200
     2.729    10.141     0.200
     4.595    14.568     0.200
     4.645    15.488     0.200
     4.645    13.465     0.200
     4.645    14.988     0.200
     4.742    12.861     0.200
     5.587    15.998     0.200
     6.444    16.313     0.200
     6.837    18.113     0.200
     6.837    18.722     0.200
     6.837    18.019     0.200
     7.998    20.372     0.200
     8.234    24.336     0.200
     8.357    21.493     0.200
     9.168    23.762     0.200
     9.515    20.018     0.200
    10.446    27.263     0.200
    10.607    27.387     0.200
    12.322    27.897     0.200
    12.562    29.995     0.200
    12.689    30.111     0.200
    16.078    32.467     0.200
     0.213     6.538     0.200
     0.193     6.573     0.200
     0.286     6.685     0.200
     0.422     5.695     0.200
     0.424     6.169     0.200
     0.691     5.964     0.200
     0.869     6.577     0.200
     0.877     7.385     0.200
     0.934     5.118     0.200
     1.158     6.205     0.200
     1.282     7.256     0.200
     1.353     7.428     0.200
     1.434     6.791     0.200
     1.860     8.617     0.200
     2.275     7.772     0.200
     2.346     9.442     0.200
     2.647     9.630     0.200
     2.724    10.238     0.200
     4.676    15.852     0.200
     6.831    19.219     0.200
     8.274    22.014     0.200
    12.584    29.913     0.200
     0.100     7.643     0.200
     0.149     7.178     0.200
     0.454     5.509     0.200
     0.547     5.828     0.200
     0.547     6.429     0.200
     0.547     6.332     0.200
     0.539     6.026     0.200
     0.556     6.722     0.200
     0.637     5.679     0.200
     0.811     5.446     0.200
     0.965     6.552     0.200
     0.965     6.677     0.200
     1.079     6.614     0.200
     1.146     5.647     0.200
     1.181     6.429     0.200
     1.239     6.554     0.200
     1.257     6.847     0.200
     1.289     6.270     0.200
     1.764     7.751     0.200
     1.764     8.126     0.200
     1.763     8.178     0.200
     1.798     7.037     0.200
     1.931     8.229     0.200
     2.530     7.888     0.200
     2.564     9.293     0.200
     2.622    10.411     0.200
     2.855     9.892     0.200
     2.932     9.994     0.200
     2.932    10.494     0.200
     4.603    15.194     0.200
     4.603    14.912     0.200
     4.685    12.784     0.200
     4.791    15.400     0.200
     5.095    14.356     0.200
     5.431    16.118     0.200
     6.389    16.351     0.200
     6.712    18.331     0.200
     6.714    19.064     0.200
     6.714    18.767     0.200
     6.714    18.148     0.200
     6.714    19.219     0.200
     6.737    20.001     0.200
     7.870    20.662     0.200
     7.945    20.199     0.200
     7.945    21.847     0.200
     7.945    20.122     0.200
     7.945    21.200     0.200
     8.226    22.442     0.200
     8.447    19.542     0.200
     8.514    23.653     0.200
     9.007    23.619     0.200
     9.423    24.351     0.200
     9.478    21.730     0.200
     9.707    26.731     0.200
    10.215    25.131     0.200
    10.215    24.607     0.200
    10.415    26.836     0.200
    10.879    27.952     0.200
    11.000    27.158     0.200
    11.208    27.115     0.200
    12.300    29.829     0.200
    12.284    30.690     0.200
    12.300    29.578     0.200
    12.490    29.452     0.200
    12.490    28.655     0.200
    12.517    28.845     0.200
    13.050    29.199     0.200
    13.190    29.382     0.200
    13.313    29.650     0.200
    14.775    32.884     0.200
    14.775    30.314     0.200
    14.775    31.485     0.200
    15.166    33.927     0.200
    15.166    32.325     0.200
    15.224    31.456     0.200
    15.224    32.674     0.200
    15.284    34.341     0.200
    15.284    32.341     0.200
    15.315    32.888     0.200
    15.877    33.131     0.200
     0.164     6.837     0.200
     0.244     6.501     0.200
     0.298     6.868     0.200
     0.299     7.058     0.200
     0.370     5.625     0.200
     0.465     6.420     0.200
     0.707     6.196     0.200
     0.815     6.437     0.200
     0.913     7.893     0.200
     0.926     5.038     0.200
     1.111     6.087     0.200
     1.316     7.795     0.200
     1.351     7.586     0.200
     1.377     6.481     0.200
     1.668     8.178     0.200
     1.769     8.009     0.200
     1.840     8.413     0.200
     1.841     8.012     0.200
     1.841     8.362     0.200
     2.142     8.846     0.200
     2.142     9.086     0.200
     2.218     7.265     0.200
     2.290     9.324     0.200
     2.395    10.002     0.200
     2.592    10.405     0.200
     2.668    10.013     0.200
     2.668    10.113     0.200
     4.535    15.028     0.200
     4.535    14.628     0.200
     4.651    15.377     0.200
     4.651    15.137     0.200
     4.651    14.677     0.200
     4.771    13.092     0.200
     5.431    15.074     0.200
     5.431    15.774     0.200
     5.641    16.323     0.200
     6.012    14.586     0.200
     6.276    17.510     0.200
     6.433    19.278     0.200
     6.471    15.037     0.200
     6.512    16.656     0.200
     6.807    19.407     0.200
     6.880    19.013     0.200
     6.882    18.338     0.200
     6.882    18.578     0.200
     6.882    18.037     0.200
     6.882    18.638     0.200
     6.882    17.901     0.200
     6.882    18.238     0.200
     7.043    19.161     0.200
     7.071    17.834     0.200
     7.344    18.149     0.200
     7.484    17.911     0.200
     7.484    21.909     0.200
     7.543    21.027     0.200
     7.615    17.780     0.200
     7.693    17.170     0.200
     7.893    17.634     0.200
     7.999    18.004     0.200
     8.043    21.381     0.200
     8.043    20.921     0.200
     8.044    20.974     0.200
     8.100    17.026     0.200
     8.171    21.794     0.200
     8.262    18.033     0.200
     8.313    21.955     0.200
     8.313    22.070     0.200
     8.314    23.029     0.200
     8.314    21.939     0.200
     8.404    21.392     0.200
     8.412    19.983     0.200
     8.531    22.429     0.200
     8.562    23.726     0.200
     8.822    23.599     0.200
     9.223    23.485     0.200
     9.352    22.409     0.200
     9.537    20.631     0.200
     9.537    20.305     0.200
     9.621    26.470     0.200
    10.075    23.372     0.200
    10.075    26.282     0.200
    10.506    26.340     0.200
    10.506    26.140     0.200
    10.669    26.621     0.200
    10.967    28.767     0.200
    11.219    25.865     0.200
    11.249    29.369     0.200
    12.268    27.985     0.200
    12.640    29.714     0.200
    12.625    29.849     0.200
    12.640    28.936     0.200
    12.731    28.877     0.200
    12.985    30.419     0.200
    13.099    29.380     0.200
    13.235    32.011     0.200
    13.306    29.445     0.200
    13.521    32.254     0.200
    14.582    32.674     0.200
    14.582    31.234     0.200
    14.582    29.399     0.200
    14.582    29.204     0.200
    14.754    31.897     0.200
    15.195    29.961     0.200
    15.195    29.795     0.200
    15.543    33.767     0.200
    15.543    33.267     0.200
    16.128    33.938     0.200
    16.635    34.220     0.200
    17.659    33.869     0.200
     0.270     7.060     0.200
     0.219     7.151     0.200
     0.547     6.231     0.200
     0.547     6.323     0.200
     0.478     6.839     0.200
     0.639     6.149     0.200
     0.825     6.684     0.200
     0.844     6.464     0.200
     0.950     5.918     0.200
     0.980     6.373     0.200
     1.007     5.959     0.200
     1.319     6.923     0.200
     1.398     6.895     0.200
     1.439     8.020     0.200
     1.820     6.975     0.200
     1.820     6.475     0.200
     1.908     8.736     0.200
     1.908     8.439     0.200
     2.043     9.373     0.200
     2.214     9.267     0.200
     2.214     8.869     0.200
     2.290     9.281     0.200
     2.290     8.984     0.200
     4.157    15.803     0.200
     4.157    13.202     0.200
     4.527    14.672     0.200
     4.527    13.875     0.200
     7.225    17.002     0.200
     7.224    18.862     0.200
     8.426    23.383     0.200
     8.426    22.883     0.200
     8.626    21.145     0.200
    13.040    30.307     0.200
    14.235    29.732     0.200
     0.496     5.734     0.200
     0.608     5.731     0.200
     0.651     5.627     0.200
     0.754     5.618     0.200
     0.851     5.799     0.200
     0.851     5.690     0.200
     0.851     6.096     0.200
     0.978     6.008     0.200
     1.136     6.073     0.200
     1.213     6.065     0.200
     1.248     5.564     0.200
     1.406     7.319     0.200
     1.481     6.039     0.200
     1.481     6.235     0.200
     1.488     5.959     0.200
     1.521     7.176     0.200
     1.585     7.422     0.200
     1.607     7.571     0.200
     1.623     8.080     0.200
     1.775     8.517     0.200
     1.867     8.379     0.200
     1.867     8.535     0.200
     1.869     8.484     0.200
     1.910     7.838     0.200
     1.984     8.366     0.200
     1.984     8.468     0.200
     2.844    10.013     0.200
     3.845    14.648     0.200
     3.845    14.047     0.200
     4.480    14.746     0.200
     4.480    12.145     0.200
     4.480    13.848     0.200
     5.309    12.732     0.200
     6.318    16.444     0.200
     6.655    20.759     0.200
     6.992    16.088     0.200
     7.510    18.892     0.200
     7.511    18.977     0.200
     8.353    23.151     0.200
     8.675    21.736     0.200
     8.759    25.305     0.200
     8.922    22.906     0.200
     9.040    22.546     0.200
     9.724    26.443     0.200
     9.900    23.085     0.200
    10.839    29.310     0.200
    10.839    29.138     0.200
    11.015    29.377     0.200
    11.604    27.804     0.200
    12.446    28.587     0.200
    12.861    30.740     0.200
    13.390    32.913     0.200
    13.954    30.984     0.200
    13.954    33.179     0.200
    13.954    31.523     0.200
    14.323    30.978     0.200
    15.775    34.828     0.200
    15.775    33.429     0.200
     0.132     7.096     0.200
     0.287     6.778     0.200
     0.288     6.967     0.200
     0.275     6.225     0.200
     0.359     5.643     0.200
     0.497     6.128     0.200
     0.799     6.513     0.200
     0.735     5.956     0.200
     1.102     6.171     0.200
     1.353     6.446     0.200
     1.456     6.838     0.200
     1.347     7.611     0.200
     1.347     7.424     0.200
     1.371     7.433     0.200
     1.853     8.513     0.200
     1.854     8.529     0.200
     2.194     7.835     0.200
     2.161     8.736     0.200
     2.379    10.171     0.200
     3.136     9.641     0.200
     4.515    15.040     0.200
     4.515    13.739     0.200
     4.658    14.570     0.200
     4.777    12.952     0.200
     5.657    15.912     0.200
     0.175     6.899     0.200
     0.256     7.157     0.200
     0.256     7.249     0.200
     0.233     6.421     0.200
     0.415     5.709     0.200
     0.468     6.180     0.200
     0.732     5.907     0.200
     0.856     6.651     0.200
     0.921     7.595     0.200
     0.965     5.678     0.200
     1.156     6.247     0.200
     1.326     7.662     0.200
     1.326     7.256     0.200
     1.409     6.694     0.200
     1.387     7.755     0.200
     1.512     6.898     0.200
     1.884     8.657     0.200
     1.884     8.391     0.200
     1.885     8.623     0.200
     2.103     9.332     0.200
     2.250     7.489     0.200
     2.250     8.090     0.200
     2.327     9.286     0.200
     2.436    10.912     0.200
     2.706    10.662     0.200
     3.192    10.390     0.200
     4.573    13.078     0.200
     4.573    14.375     0.200
     4.724    13.365     0.200
     4.696    15.336     0.200
     6.838    17.674     0.200
     6.838    16.393     0.200
     8.361    21.521     0.200
     8.317    20.467     0.200
    12.617    30.058     0.200
     0.148     7.185     0.200
     0.257     6.512     0.200
     0.304     6.868     0.200
     0.305     6.560     0.200
     0.305     6.853     0.200
     0.383     6.643     0.200
     0.452     5.738     0.200
     0.662     5.987     0.200
     0.837     7.442     0.200
     0.902     6.584     0.200
     0.923     5.645     0.200
     1.182     6.320     0.200
     1.244     7.501     0.200
     1.244     7.169     0.200
     1.337     7.510     0.200
     1.578     7.004     0.200
     1.854     8.454     0.200
     1.855     8.991     0.200
     2.055     8.752     0.200
     2.315     7.601     0.200
     2.382     9.817     0.200
     2.759    11.123     0.200
     2.759    10.220     0.200
     3.256    10.619     0.200
     4.625    13.843     0.200
     4.625    14.543     0.200
     4.708    12.518     0.200
     4.677    15.537     0.200
     4.677    15.018     0.200
     6.803    16.168     0.200
     6.804    19.914     0.200
     6.804    16.102     0.200
     6.804    18.973     0.200
     8.232    22.459     0.200
     8.590    25.577     0.200
     8.590    23.975     0.200
    10.461    27.782     0.200
    10.461    27.934     0.200
    10.461    27.133     0.200
    12.353    29.853     0.200
    12.353    28.553     0.200
    12.542    30.754     0.200
     0.143     7.201     0.200
     0.264     6.594     0.200
     0.298     6.993     0.200
     0.298     6.899     0.200
     0.382     6.416     0.200
     0.464     5.757     0.200
     0.667     5.890     0.200
     0.837     7.206     0.200
     0.914     6.707     0.200
     0.932     5.300     0.200
     1.194     6.237     0.200
     1.244     7.254     0.200
     1.244     7.125     0.200
     1.345     7.478     0.200
     1.588     7.243     0.200
     1.864     8.936     0.200
     1.864     8.717     0.200
     1.865     8.708     0.200
     2.043     8.454     0.200
     2.325     7.639     0.200
     2.325     7.741     0.200
     2.491    10.200     0.200
     2.770    10.347     0.200
     3.266     9.859     0.200
     3.266    10.257     0.200
     4.636    12.965     0.200
     4.687    15.273     0.200
     4.696    12.725     0.200
     5.544    16.256     0.200
     6.398    14.884     0.200
     6.791    18.266     0.200
     6.792    18.410     0.200
     6.792    18.836     0.200
     6.792    18.320     0.200
     7.953    20.593     0.200
     8.230    22.026     0.200
     8.313    21.541     0.200
     8.600    24.007     0.200
    10.465    27.769     0.200
    10.567    26.548     0.200
    11.121    25.158     0.200
    12.533    31.561     0.200
    13.203    29.892     0.200
    13.203    30.071     0.200
    14.675    30.491     0.200
     0.126     7.131     0.200
     0.261     6.102     0.200
     0.341     6.307     0.200
     0.372     6.610     0.200
     0.535     6.376     0.200
     0.702     6.599     0.200
     0.967     7.850     0.200
     1.004     6.103     0.200
     1.267     6.564     0.200
     1.322     7.229     0.200
     1.361     7.390     0.200
     1.372     6.574     0.200
     1.780     8.305     0.200
     1.781     8.243     0.200
     2.109     7.073     0.200
     2.109     7.273     0.200
     2.282    10.451     0.200
     2.555    11.265     0.200
     2.555     9.765     0.200
     4.422    17.281     0.200
     4.576    16.076     0.200
     4.576    14.676     0.200
     5.458    15.888     0.200
     6.993    19.024     0.200
     8.369    22.064     0.200
     8.486    22.346     0.200
     9.587    24.507     0.200
    10.508    25.901     0.200
    12.742    30.817     0.200
     0.154     7.498     0.200
     0.251     6.936     0.200
     0.316     7.241     0.200
     0.315     7.191     0.200
     0.383     6.892     0.200
     0.436     6.079     0.200
     0.836     7.608     0.200
     0.887     6.853     0.200
     0.909     5.456     0.200
     1.165     6.333     0.200
     1.241     7.415     0.200
     1.241     7.536     0.200
     1.324     7.427     0.200
     1.460     7.060     0.200
     1.565     7.191     0.200
     2.071     8.996     0.200
     2.302     7.688     0.200
     2.302     7.887     0.200
     2.463    10.604     0.200
     2.744    11.030     0.200
     2.744    10.331     0.200
     3.243    10.612     0.200
     4.610    16.053     0.200
     4.610    14.252     0.200
     4.726    12.653     0.200
     4.661    15.041     0.200
     4.661    15.565     0.200
     4.661    13.662     0.200
     5.571    16.277     0.200
     6.427    15.535     0.200
     6.821    18.814     0.200
     6.821    16.119     0.200
     7.981    21.381     0.200
     8.233    20.600     0.200
     8.341    21.931     0.200
     8.573    22.101     0.200
     9.498    20.279     0.200
     9.499    19.220     0.200
    11.149    25.638     0.200
    11.262    27.721     0.200
    11.930    27.542     0.200
    12.552    28.781     0.200
    14.647    31.715     0.200
    14.647    31.825     0.200
    15.177    29.861     0.200
    15.177    30.717     0.200
     0.218     6.560     0.200
     0.193     6.714     0.200
     0.260     6.970     0.200
     0.447     5.709     0.200
     0.432     6.277     0.200
     0.892     6.661     0.200
     0.887     7.507     0.200
     0.961     5.664     0.200
     1.185     6.351     0.200
     1.294     7.551     0.200
     1.379     7.666     0.200
     1.451     6.994     0.200
     1.554     6.874     0.200
     2.291     8.269     0.200
     2.472    10.867     0.200
     2.744    11.284     0.200
     2.744    11.081     0.200
     3.233    10.376     0.200
     4.611    15.999     0.200
     4.611    14.397     0.200
     4.705    16.202     0.200
     4.705    14.499     0.200
     6.806    17.657     0.200
     8.280    21.562     0.200
     9.467    23.399     0.200
    12.574    29.601     0.200
     0.185     6.726     0.200
     0.255     6.956     0.200
     0.256     7.146     0.200
     0.225     6.337     0.200
     0.422     5.612     0.200
     0.461     6.041     0.200
     0.864     6.542     0.200
     0.914     7.407     0.200
     0.966     5.049     0.200
     1.163     6.092     0.200
     1.320     7.573     0.200
     1.320     7.443     0.200
     1.387     7.627     0.200
     1.522     6.762     0.200
     2.094     9.217     0.200
     2.259     7.757     0.200
     2.445    10.790     0.200
     2.715    10.536     0.200
     4.718    13.640     0.200
     5.591    16.358     0.200
     6.830    18.848     0.200
     8.353    22.399     0.200
     0.193     6.559     0.200
     0.212     6.585     0.200
     0.286     6.744     0.200
     0.286     6.602     0.200
     0.286     6.844     0.200
     0.286     7.344     0.200
     0.405     5.736     0.200
     0.441     6.360     0.200
     0.699     6.111     0.200
     0.851     6.648     0.200
     0.893     7.662     0.200
     0.935     5.264     0.200
     1.143     6.246     0.200
     1.297     6.988     0.200
     1.297     7.660     0.200
     1.356     7.726     0.200
     1.517     6.779     0.200
     2.106     8.497     0.200
     2.255     7.377     0.200
     2.430    10.225     0.200
     2.704    10.127     0.200
     4.571    14.741     0.200
     4.670    14.704     0.200
     4.670    15.485     0.200
     4.670    14.485     0.200
     4.670    15.384     0.200
     4.740    12.572     0.200
     5.416    14.675     0.200
     5.416    15.573     0.200
     5.605    16.319     0.200
     6.441    14.895     0.200
     6.825    19.436     0.200
     6.825    20.436     0.200
     6.847    18.207     0.200
     6.847    18.676     0.200
     6.847    19.871     0.200
     6.847    18.223     0.200
     8.009    19.379     0.200
     8.252    22.392     0.200
     8.291    21.669     0.200
     8.291    21.107     0.200
     8.291    21.631     0.200
     8.370    20.406     0.200
     8.370    22.711     0.200
     8.582    24.126     0.200
     8.794    23.360     0.200
     9.508    21.675     0.200
     9.508    21.345     0.200
     9.627    26.845     0.200
    10.053    25.309     0.200
    10.053    25.966     0.200
    10.053    27.669     0.200
    10.500    24.850     0.200
    10.500    26.350     0.200
    10.632    26.146     0.200
    11.183    26.588     0.200
    11.270    28.761     0.200
    11.774    29.583     0.200
    12.303    27.302     0.200
    12.303    27.505     0.200
    12.605    30.233     0.200
    12.590    29.905     0.200
    12.605    29.389     0.200
    12.960    28.644     0.200
    13.199    30.087     0.200
    13.477    29.609     0.200
    13.486    30.964     0.200
    13.486    32.503     0.200
    13.486    33.707     0.200
    14.468    32.934     0.200
    14.617    31.809     0.200
    14.617    31.106     0.200
    14.617    29.528     0.200
    14.617    31.465     0.200
    14.718    30.726     0.200
    14.999    32.982     0.200
    14.999    31.747     0.200
    14.999    31.951     0.200
    15.172    31.844     0.200
    15.541    32.419     0.200
    16.603    33.625     0.200
    17.644    33.822     0.200
    17.960    35.394     0.200
    18.876    36.403     0.200
    19.590    36.271     0.200
     0.132     7.200     0.200
     0.301     6.907     0.200
     0.301     6.798     0.200
     0.300     6.878     0.200
     0.277     6.305     0.200
     0.347     5.652     0.200
     0.496     6.173     0.200
     0.728     5.981     0.200
     0.788     6.648     0.200
     0.933     4.920     0.200
     0.942     7.585     0.200
     1.090     6.193     0.200
     1.345     6.627     0.200
     1.343     7.480     0.200
     1.360     7.419     0.200
     1.449     6.805     0.200
     2.186     7.301     0.200
     2.171     8.859     0.200
     2.368     9.976     0.200
     2.639     9.915     0.200
     4.506    14.930     0.200
     4.506    14.430     0.200
     4.646    14.689     0.200
     4.646    14.201     0.200
     4.790    12.955     0.200
     5.668    16.060     0.200
     6.490    14.770     0.200
     6.804    20.211     0.200
     6.905    19.542     0.200
     6.906    18.436     0.200
     6.906    18.018     0.200
     6.906    18.382     0.200
     8.068    20.799     0.200
     8.343    21.016     0.200
     8.429    22.305     0.200
     8.557    23.456     0.200
     9.553    22.633     0.200
     9.630    26.536     0.200
    10.525    25.288     0.200
    10.525    28.187     0.200
    10.525    26.687     0.200
    10.699    27.948     0.200
    11.822    29.851     0.200
    12.674    30.110     0.200
    13.015    30.823     0.200
    13.555    32.130     0.200
    14.557    31.233     0.200
    15.557    31.862     0.200
     0.224     6.770     0.200
     0.182     6.958     0.200
     0.289     7.002     0.200
     0.290     7.048     0.200
     0.430     5.904     0.200
     0.415     6.491     0.200
     0.684     6.164     0.200
     0.878     6.746     0.200
     0.868     7.498     0.200
     0.932     5.331     0.200
     1.165     6.297     0.200
     1.273     7.374     0.200
     1.350     7.462     0.200
     1.444     6.908     0.200
     1.548     6.992     0.200
     1.859     8.553     0.200
     1.859     8.527     0.200
     2.079     8.731     0.200
     2.285     7.583     0.200
     2.285     7.786     0.200
     2.456    10.083     0.200
     2.733    10.561     0.200
     4.599    14.974     0.200
     4.677    13.176     0.200
     4.677    15.169     0.200
     4.721    12.848     0.200
     5.578    16.496     0.200
     6.822    19.840     0.200
     6.823    18.722     0.200
     6.823    18.910     0.200
     7.985    21.342     0.200
    10.484    27.250     0.200
    10.484    27.102     0.200
    10.988    28.626     0.200
    12.574    30.569     0.200
     0.205     6.761     0.200
     0.298     6.876     0.200
     0.298     6.978     0.200
     0.297     6.897     0.200
     0.431     6.400     0.200
     0.687     6.081     0.200
     0.850     6.435     0.200
     0.882     7.550     0.200
     0.923     5.066     0.200
     1.286     7.525     0.200
     1.344     7.387     0.200
     1.416     6.523     0.200
     1.520     6.618     0.200
     1.845     8.244     0.200
     1.846     7.702     0.200
     1.846     8.210     0.200
     2.107     8.861     0.200
     2.257     7.213     0.200
     2.428     9.910     0.200
     2.704     9.894     0.200
     4.571    14.611     0.200
     4.660    14.945     0.200
     4.660    15.164     0.200
     4.746    12.018     0.200
     5.405    14.780     0.200
     5.606    16.004     0.200
     6.815    19.018     0.200
     6.815    19.619     0.200
     6.849    19.370     0.200
     6.851    18.213     0.200
     6.851    16.705     0.200
     6.851    18.330     0.200
     8.012    21.012     0.200
     8.242    20.564     0.200
     8.280    22.718     0.200
     8.280    21.395     0.200
     8.372    21.365     0.200
     8.503    20.562     0.200
     8.573    23.909     0.200
     9.615    26.248     0.200
    10.042    25.458     0.200
    10.488    24.437     0.200
    10.488    25.859     0.200
    10.632    25.600     0.200
    10.973    27.596     0.200
    11.184    24.811     0.200
    11.261    29.339     0.200
    12.302    25.687     0.200
    12.302    27.687     0.200
    12.600    29.605     0.200
    12.586    29.696     0.200
    12.601    29.245     0.200
    12.950    29.727     0.200
    13.269    29.353     0.200
    13.269    29.802     0.200
    13.397    31.514     0.200
    13.482    31.219     0.200
    13.482    31.918     0.200
    14.460    32.605     0.200
    14.614    29.699     0.200
    14.718    31.306     0.200
    15.181    32.936     0.200
    15.181    30.826     0.200
    15.529    33.830     0.200
    16.596    34.478     0.200
     0.133     7.448     0.200
     0.277     6.659     0.200
     0.345     6.830     0.200
     0.354     6.830     0.200
     0.440     6.023     0.200
     0.622     6.124     0.200
     0.805     7.420     0.200
     0.892     6.788     0.200
     0.883     5.526     0.200
     1.161     6.327     0.200
     1.210     7.373     0.200
     1.296     7.410     0.200
     1.407     6.567     0.200
     1.578     7.004     0.200
     1.817     7.890     0.200
     2.314     7.607     0.200
     2.750    10.223     0.200
     4.616    13.651     0.200
     4.640    14.670     0.200
     6.823    18.492     0.200
     9.511    20.851     0.200
    10.422    25.743     0.200
    12.534    28.054     0.200
    13.223    29.405     0.200
    14.646    31.099     0.200
     0.167     6.807     0.200
     0.239     6.243     0.200
     0.277     6.747     0.200
     0.277     7.087     0.200
     0.277     6.998     0.200
     0.277     6.846     0.200
     0.392     5.734     0.200
     0.467     6.026     0.200
     0.720     5.904     0.200
     0.835     6.655     0.200
     0.918     7.414     0.200
     0.946     5.115     0.200
     1.133     6.264     0.200
     1.322     7.481     0.200
     1.369     7.586     0.200
     1.392     6.671     0.200
     1.495     6.976     0.200
     1.862     8.304     0.200
     1.863     8.458     0.200
     1.863     8.286     0.200
     2.124     8.174     0.200
     2.233     7.570     0.200
     2.415    10.247     0.200
     2.686    10.080     0.200
     2.686    10.279     0.200
     3.175     9.979     0.200
     4.553    14.993     0.200
     4.553    14.594     0.200
     4.673    14.850     0.200
     4.673    15.287     0.200
     4.673    15.588     0.200
     4.748    12.674     0.200
     4.748    13.213     0.200
     5.440    16.047     0.200
     5.621    15.680     0.200
     5.621    16.328     0.200
     6.830    19.921     0.200
     6.859    18.704     0.200
     6.861    17.860     0.200
     6.861    18.360     0.200
     6.861    18.161     0.200
     6.861    18.638     0.200
     8.023    20.451     0.200
     8.023    20.904     0.200
     8.278    23.022     0.200
     8.278    22.522     0.200
     8.317    19.672     0.200
     8.317    22.269     0.200
     8.317    22.196     0.200
     8.317    19.942     0.200
     8.383    20.732     0.200
     8.383    21.490     0.200
     8.509    20.635     0.200
     8.509    22.225     0.200
     8.585    24.136     0.200
     8.585    23.737     0.200
     8.820    23.294     0.200
     9.514    20.301     0.200
     9.514    20.210     0.200
     9.514    21.601     0.200
     9.640    25.727     0.200
    10.079    24.310     0.200
    10.079    23.798     0.200
    10.079    25.911     0.200
    10.520    26.033     0.200
    10.520    25.760     0.200
    10.989    26.884     0.200
    11.200    24.098     0.200
    11.200    26.427     0.200
    11.272    28.680     0.200
    11.272    28.379     0.200
    11.799    29.230     0.200
    12.287    26.933     0.200
    12.287    27.136     0.200
    12.630    29.986     0.200
    12.615    29.318     0.200
    12.630    29.735     0.200
    12.986    30.182     0.200
    13.288    29.829     0.200
    13.288    30.251     0.200
    13.430    30.002     0.200
    13.502    30.693     0.200
    13.502    31.854     0.200
    13.502    30.408     0.200
    13.510    31.068     0.200
    13.510    33.068     0.200
    13.510    31.869     0.200
    14.495    32.571     0.200
    14.603    30.901     0.200
    14.603    32.011     0.200
    14.603    29.815     0.200
    14.603    30.261     0.200
    14.736    30.799     0.200
    14.736    32.259     0.200
    14.984    34.367     0.200
    14.984    30.867     0.200
    15.559    32.358     0.200
    15.559    33.858     0.200
    16.629    33.664     0.200
    17.668    33.835     0.200
    17.956    35.380     0.200
    19.104    37.783     0.200
     0.690     4.707     0.200
     0.957     6.594     0.200
     1.094     6.095     0.200
     1.163     7.085     0.200
     1.232     7.485     0.200
     1.259     7.602     0.200
     1.295     7.323     0.200
     1.350     7.369     0.200
     1.428     8.195     0.200
     1.428     8.242     0.200
     1.453     7.637     0.200
     1.514     8.047     0.200
     1.534     7.162     0.200
     1.608     9.086     0.200
     1.632     8.795     0.200
     1.666     8.622     0.200
     1.874     9.256     0.200
     1.906     8.753     0.200
     2.091     7.934     0.200
     2.090     8.826     0.200
     2.199     8.580     0.200
     2.228    10.165     0.200
     2.438     9.335     0.200
     2.430     8.893     0.200
     2.525    11.531     0.200
     2.637    11.207     0.200
     2.694    10.842     0.200
     2.759    11.228     0.200
     2.791    11.671     0.200
     2.898     9.806     0.200
     3.166    12.496     0.200
     3.166    12.695     0.200
     3.343    11.485     0.200
     3.517    13.520     0.200
     3.779    12.736     0.200
     4.210    14.066     0.200
     4.210    14.507     0.200
     4.415    13.122     0.200
     4.969    16.650     0.200
     4.969    18.451     0.200
     4.987    15.649     0.200
     4.987    16.739     0.200
     5.488    17.850     0.200
     6.290    19.139     0.200
     6.846    22.909     0.200
     6.848    22.066     0.200
     6.848    22.226     0.200
     6.848    23.027     0.200
     6.848    22.399     0.200
     7.319    21.402     0.200
     7.319    21.352     0.200
     7.319    20.423     0.200
     7.986    24.461     0.200
     7.986    25.043     0.200
     8.093    23.193     0.200
     8.093    24.091     0.200
     8.332    23.111     0.200
     8.332    25.310     0.200
     8.808    23.950     0.200
     9.077    24.314     0.200
    10.396    27.320     0.200
    10.396    24.620     0.200
    10.790    29.523     0.200
    11.958    32.737     0.200
    12.427    30.317     0.200
    12.549    29.690     0.200
    12.758    34.680     0.200
    14.619    32.938     0.200
    14.619    36.438     0.200
    14.767    34.485     0.200
    14.767    33.524     0.200
    14.767    33.895     0.200
    15.177    32.605     0.200
    15.177    33.526     0.200
    15.662    33.389     0.200
    15.662    34.768     0.200
    17.680    36.736     0.200
    17.680    38.212     0.200
    17.680    38.009     0.200
    19.401    39.838     0.200
     0.606     5.552     0.200
     0.667     5.079     0.200
     0.673     5.295     0.200
     0.762     6.125     0.200
     0.853     5.934     0.200
     0.949     6.516     0.200
     1.086     6.666     0.200
     1.141     6.294     0.200
     1.431     8.400     0.200
     2.221     8.183     0.200
     2.909    10.050     0.200
     3.184    13.640     0.200
     3.799    12.666     0.200
     4.208    15.996     0.200
     4.985    17.019     0.200
     6.844    19.651     0.200
     7.296    21.066     0.200
     9.514    25.401     0.200
    11.939    30.865     0.200
    14.777    35.396     0.200
     0.181     7.048     0.200
     0.225     6.883     0.200
     0.295     7.066     0.200
     0.295     6.958     0.200
     0.412     6.522     0.200
     0.426     6.003     0.200
     0.679     6.169     0.200
     0.875     6.837     0.200
     0.864     7.468     0.200
     0.927     5.562     0.200
     1.160     6.385     0.200
     1.270     7.447     0.200
     1.344     7.527     0.200
     1.442     7.060     0.200
     1.546     6.964     0.200
     1.853     8.084     0.200
     1.854     8.099     0.200
     2.283     7.661     0.200
     2.283     7.861     0.200
     2.453    10.182     0.200
     2.730    10.449     0.200
     2.730    10.248     0.200
     3.225    10.276     0.200
     4.596    15.366     0.200
     4.596    14.866     0.200
     4.671    15.492     0.200
     8.261    20.498     0.200
    12.574    27.177     0.200
     0.325     7.029     0.200
     0.304     6.728     0.200
     0.454     6.246     0.200
     0.715     6.278     0.200
     0.726     6.878     0.200
     0.727     5.888     0.200
     0.727     6.869     0.200
     0.900     5.939     0.200
     0.812     5.799     0.200
     1.138     6.244     0.200
     1.044     6.159     0.200
     1.057     6.033     0.200
     1.220     6.275     0.200
     1.393     7.605     0.200
     1.457     7.507     0.200
     1.638     6.234     0.200
     1.463     8.122     0.200
     1.492     7.761     0.200
     1.865     8.684     0.200
     1.756     8.540     0.200
     1.756     8.651     0.200
     1.758     8.607     0.200
     2.107     8.463     0.200
     2.580     8.239     0.200
     2.704     9.489     0.200
     2.704    10.188     0.200
     3.973    13.084     0.200
     3.973    13.484     0.200
     4.432    13.166     0.200
     4.432    13.725     0.200
     5.232    13.271     0.200
     5.232    13.492     0.200
     5.738    16.781     0.200
     6.191    16.218     0.200
     6.191    16.897     0.200
     6.606    18.553     0.200
     6.606    18.253     0.200
     7.402    18.481     0.200
     7.404    18.397     0.200
     7.404    19.247     0.200
     7.404    18.673     0.200
     8.320    22.749     0.200
     8.320    22.648     0.200
     8.733    22.215     0.200
     8.733    24.235     0.200
     8.733    21.886     0.200
     8.733    23.261     0.200
     8.745    23.695     0.200
     8.931    21.292     0.200
     8.931    22.422     0.200
     9.021    20.925     0.200
     9.309    24.216     0.200
     9.618    25.811     0.200
     9.955    21.400     0.200
     9.955    20.970     0.200
     9.956    20.907     0.200
    10.486    26.671     0.200
    10.486    24.870     0.200
    10.688    28.222     0.200
    10.688    28.823     0.200
    10.991    27.585     0.200
    11.721    26.158     0.200
    11.770    25.267     0.200
    11.770    26.187     0.200
    12.172    30.103     0.200
    13.211    29.974     0.200
    13.196    30.672     0.200
    13.211    29.763     0.200
    13.429    31.726     0.200
    13.628    31.512     0.200
    13.815    32.628     0.200
    13.875    29.614     0.200
    13.875    30.125     0.200
    13.875    29.875     0.200
    14.057    29.666     0.200
    14.057    29.057     0.200
    14.079    31.330     0.200
    14.097    31.424     0.200
    14.097    31.534     0.200
    14.430    31.503     0.200
    14.430    29.644     0.200
    15.504    31.690     0.200
    15.504    30.820     0.200
    15.599    33.909     0.200
    15.644    33.786     0.200
    15.644    34.786     0.200
    17.557    31.903     0.200
    17.557    33.153     0.200
    17.557    32.896     0.200
    17.961    36.641     0.200
    19.642    36.223     0.200
    20.185    36.788     0.200
     0.134     6.817     0.200
     0.274     6.034     0.200
     0.295     6.532     0.200
     0.353     5.398     0.200
     0.495     5.904     0.200
     0.729     5.847     0.200
     0.794     6.356     0.200
     0.941     7.682     0.200
     0.937     4.920     0.200
     1.096     5.956     0.200
     1.343     7.606     0.200
     1.364     7.461     0.200
     2.191     8.121     0.200
     2.191     7.121     0.200
     2.374    10.183     0.200
     2.644    11.028     0.200
     3.133    10.527     0.200
     3.133    10.228     0.200
     4.511    15.242     0.200
     0.236     4.784     0.200
     0.343     4.718     0.200
     0.496     5.871     0.200
     0.633     5.416     0.200
     0.613     4.864     0.200
     0.697     5.145     0.200
     0.899     6.065     0.200
     1.038     6.152     0.200
     1.066     6.429     0.200
     1.124     5.402     0.200
     1.165     6.561     0.200
     1.217     6.096     0.200
     1.650     8.156     0.200
     1.771     6.621     0.200
     2.497     8.038     0.200
     2.878    10.799     0.200
     3.426    10.407     0.200
     4.732    14.765     0.200
     6.804    19.428     0.200
    12.323    34.120     0.200
     0.242     6.609     0.200
     0.266     6.608     0.200
     0.493     6.558     0.200
     0.536     6.034     0.200
     0.537     6.416     0.200
     0.644     5.796     0.200
     0.835     6.351     0.200
     0.863     6.164     0.200
     0.983     6.091     0.200
     0.968     5.521     0.200
     1.084     6.166     0.200
     1.029     5.737     0.200
     1.319     6.672     0.200
     1.409     6.583     0.200
     1.462     7.693     0.200
     1.544     7.700     0.200
     1.557     7.688     0.200
     1.572     7.580     0.200
     1.821     6.668     0.200
     1.821     6.871     0.200
     1.823     8.543     0.200
     1.824     8.511     0.200
     2.053     9.060     0.200
     2.297     9.215     0.200
     2.297     8.910     0.200
     2.515     8.904     0.200
     2.764     9.060     0.200
     4.163    15.336     0.200
     4.163    13.938     0.200
     4.550    14.828     0.200
     5.050    12.959     0.200
     7.213    19.808     0.200
     7.214    18.903     0.200
     7.214    19.232     0.200
     8.378    22.603     0.200
     8.641    23.201     0.200
     8.741    21.973     0.200
    13.044    30.862     0.200
    14.246    30.095     0.200
    17.719    33.253     0.200
     0.206     7.123     0.200
     0.201     6.652     0.200
     0.276     7.287     0.200
     0.276     7.447     0.200
     0.424     6.135     0.200
     0.434     6.071     0.200
     0.702     5.653     0.200
     0.888     6.903     0.200
     0.945     5.276     0.200
     1.162     6.583     0.200
     1.293     6.882     0.200
     1.364     7.222     0.200
     1.868     8.750     0.200
     1.869     8.697     0.200
     2.087     8.631     0.200
     2.087     8.869     0.200
     2.723    10.753     0.200
     2.723    10.854     0.200
     3.214    10.826     0.200
     3.214    10.326     0.200
     4.590    15.269     0.200
     4.590    15.769     0.200
     4.684    15.594     0.200
     4.684    15.165     0.200
     4.684    15.266     0.200
     4.684    15.715     0.200
     4.722    12.456     0.200
     4.722    13.175     0.200
     5.414    14.247     0.200
     5.586    16.215     0.200
     5.586    16.895     0.200
     6.839    19.822     0.200
     6.827    18.139     0.200
     6.829    18.143     0.200
     6.829    18.553     0.200
     6.829    18.331     0.200
     7.990    20.577     0.200
     7.990    21.237     0.200
     8.242    21.444     0.200
     8.284    21.530     0.200
     8.284    21.640     0.200
     8.284    21.261     0.200
     8.351    21.241     0.200
     8.351    21.592     0.200
     8.480    21.590     0.200
     8.480    22.723     0.200
     8.597    23.007     0.200
     8.597    24.308     0.200
     8.784    22.326     0.200
     9.042    22.916     0.200
     9.490    20.932     0.200
     9.490    20.418     0.200
     9.490    21.379     0.200
     9.635    26.291     0.200
    10.046    23.394     0.200
    10.502    26.170     0.200
    10.502    24.971     0.200
    10.502    25.971     0.200
    10.997    27.103     0.200
    11.164    25.477     0.200
    11.285    28.139     0.200
    11.769    29.093     0.200
    12.322    28.530     0.200
    12.590    29.436     0.200
    12.575    29.783     0.200
    12.590    29.482     0.200
    12.951    29.489     0.200
    13.251    29.697     0.200
    13.251    29.521     0.200
    13.251    29.798     0.200
    13.410    29.238     0.200
    13.470    31.783     0.200
    13.470    32.541     0.200
    13.470    32.853     0.200
    14.458    32.408     0.200
    15.018    31.987     0.200
    15.018    30.776     0.200
    15.157    30.560     0.200
    15.546    32.413     0.200
    15.546    34.413     0.200
    16.590    35.026     0.200
    17.642    34.095     0.200
     0.721     4.618     0.200
     0.672     4.539     0.200
     1.046     5.290     0.200
     1.048     5.737     0.200
     1.119     5.837     0.200
     1.069     7.396     0.200
     1.300     7.088     0.200
     1.269     7.301     0.200
     1.322     6.900     0.200
     1.406     6.844     0.200
     1.466     6.602     0.200
     1.404     7.349     0.200
     1.469     6.593     0.200
     1.506     8.596     0.200
     1.506     7.596     0.200
     1.506     7.776     0.200
     1.506     7.620     0.200
     1.553     7.884     0.200
     1.623     7.830     0.200
     1.674     8.157     0.200
     1.781     8.728     0.200
     1.853     9.024     0.200
     1.922     8.259     0.200
     1.929     8.417     0.200
     2.009     7.661     0.200
     2.009     8.922     0.200
     2.009     7.903     0.200
     2.009     8.071     0.200
     2.218     8.369     0.200
     2.334     8.383     0.200
     2.318    10.098     0.200
     2.394     7.867     0.200
     2.548    10.005     0.200
     2.633    10.265     0.200
     2.683    10.603     0.200
     2.629    11.753     0.200
     2.864     8.961     0.200
     2.809    11.261     0.200
     3.156    11.736     0.200
     3.156    12.337     0.200
     3.248    10.697     0.200
     3.434    12.564     0.200
     3.771    11.964     0.200
     3.756    12.035     0.200
     3.756    11.734     0.200
     3.953    13.606     0.200
     4.252    12.956     0.200
     4.306    14.300     0.200
     4.306    16.019     0.200
     4.306    15.421     0.200
     4.306    15.222     0.200
     4.306    14.870     0.200
     4.426    14.458     0.200
     4.428    15.063     0.200
     4.522    14.191     0.200
     4.686    16.153     0.200
     4.895    14.478     0.200
     4.895    15.240     0.200
     4.895    14.842     0.200
     4.895    14.592     0.200
     4.973    16.727     0.200
     5.262    17.899     0.200
     5.377    15.149     0.200
     5.431    16.829     0.200
     5.431    17.290     0.200
     5.431    17.188     0.200
     5.905    19.133     0.200
     6.267    19.691     0.200
     6.303    19.668     0.200
     6.393    21.155     0.200
     6.543    18.240     0.200
     6.779    19.613     0.200
     6.780    17.592     0.200
     6.780    21.639     0.200
     6.780    21.111     0.200
     6.780    20.971     0.200
     6.781    20.612     0.200
     7.039    21.794     0.200
     7.066    19.859     0.200
     7.477    19.366     0.200
     7.405    19.777     0.200
     7.405    19.251     0.200
     7.405    20.399     0.200
     7.650    20.952     0.200
     7.922    21.088     0.200
     7.922    22.115     0.200
     7.922    23.467     0.200
     7.959    21.386     0.200
     8.057    18.667     0.200
     8.157    24.120     0.200
     8.194    24.241     0.200
     8.269    20.525     0.200
     8.269    23.564     0.200
     8.269    23.924     0.200
     8.214    21.117     0.200
     8.310    22.533     0.200
     8.522    22.662     0.200
     8.522    21.514     0.200
     8.522    27.213     0.200
     8.824    26.336     0.200
     8.976    26.081     0.200
     9.067    26.659     0.200
     9.164    26.617     0.200
     9.164    22.898     0.200
     9.164    23.918     0.200
     9.241    23.723     0.200
     9.394    25.818     0.200
     9.476    27.226     0.200
     9.533    24.293     0.200
     9.703    21.388     0.200
     9.705    22.856     0.200
     9.705    26.907     0.200
     9.705    21.856     0.200
     9.651    25.487     0.200
     9.828    28.038     0.200
     9.868    26.727     0.200
    10.505    28.675     0.200
    10.581    30.645     0.200
    10.931    31.232     0.200
    10.877    29.433     0.200
    10.891    30.468     0.200
    10.961    25.192     0.200
    10.961    27.556     0.200
    10.961    31.653     0.200
    11.976    32.853     0.200
    11.959    29.721     0.200
    11.976    29.621     0.200
    12.089    32.192     0.200
    12.578    30.576     0.200
    12.578    30.276     0.200
    12.542    32.198     0.200
    12.746    30.816     0.200
    12.823    30.358     0.200
    12.823    29.616     0.200
    12.823    34.038     0.200
    12.894    31.107     0.200
    12.894    30.498     0.200
    12.933    30.879     0.200
    12.933    31.239     0.200
    12.933    31.688     0.200
    12.933    35.637     0.200
    13.414    33.824     0.200
    13.792    33.874     0.200
    14.672    34.241     0.200
    14.739    33.860     0.200
    14.739    36.560     0.200
    14.808    32.662     0.200
    14.808    32.959     0.200
    14.808    33.752     0.200
    14.808    32.862     0.200
    15.215    34.140     0.200
    15.215    34.710     0.200
    15.215    35.413     0.200
    15.215    32.632     0.200
    15.556    31.548     0.200
    15.556    37.728     0.200
    15.556    31.931     0.200
    16.747    34.567     0.200
    16.747    37.125     0.200
    17.766    36.812     0.200
    17.766    39.144     0.200
    17.766    36.062     0.200
    17.766    37.644     0.200
    17.766    37.511     0.200
    18.850    44.096     0.200
    18.990    38.852     0.200
    18.990    41.704     0.200
     0.456     4.894     0.200
     0.677     5.205     0.200
     0.704     5.128     0.200
     0.745     6.229     0.200
     0.997     6.504     0.200
     1.059     6.098     0.200
     1.100     6.764     0.200
     1.100     6.963     0.200
     1.100     6.565     0.200
     1.563     8.582     0.200
     1.952     9.866     0.200
     3.194    12.624     0.200
     3.789    11.885     0.200
     4.362    15.212     0.200
     4.362    15.891     0.200
     4.838    16.364     0.200
     4.838    17.036     0.200
     5.016    16.969     0.200
     5.016    17.570     0.200
     5.377    17.904     0.200
     5.377    19.154     0.200
     6.723    19.366     0.200
     6.725    22.797     0.200
     6.725    22.321     0.200
     6.725    22.248     0.200
     7.867    22.063     0.200
     7.867    25.094     0.200
     8.214    22.735     0.200
     8.214    25.345     0.200
     9.649    24.362     0.200
     9.649    25.503     0.200
    11.925    30.801     0.200
    11.943    30.243     0.200
    12.792    30.328     0.200
    12.858    30.691     0.200
     0.461     4.758     0.200
     0.620     5.655     0.200
     0.816     5.498     0.200
     0.802     6.854     0.200
     1.092     6.528     0.200
     1.092     6.165     0.200
     1.104     5.834     0.200
     1.856     9.593     0.200
     3.272    12.469     0.200
     3.272    12.774     0.200
     3.860    11.814     0.200
     3.860    11.517     0.200
     4.454    13.668     0.200
     4.454    16.090     0.200
     4.454    14.488     0.200
     4.454    13.894     0.200
     4.746    15.737     0.200
     4.746    16.877     0.200
     4.746    16.682     0.200
     5.099    17.254     0.200
     5.281    17.593     0.200
     5.281    18.937     0.200
     6.536    19.188     0.200
     6.615    23.663     0.200
     6.626    20.359     0.200
     6.628    21.181     0.200
     6.628    22.806     0.200
     6.628    20.712     0.200
     6.628    22.295     0.200
     7.388    21.886     0.200
     7.388    23.239     0.200
     7.770    23.617     0.200
     7.770    24.430     0.200
     8.118    24.274     0.200
     8.118    26.422     0.200
     8.118    25.485     0.200
     8.370    24.585     0.200
     8.370    24.897     0.200
     9.553    22.152     0.200
     9.556    21.946     0.200
     9.715    26.137     0.200
    10.814    28.636     0.200
    10.814    30.151     0.200
    12.595    33.073     0.200
    12.719    29.832     0.200
    12.794    29.244     0.200
    12.794    30.603     0.200
    14.953    32.707     0.200
    14.953    33.433     0.200
    14.953    32.730     0.200
    15.359    35.723     0.200
    15.415    37.166     0.200
    15.415    32.401     0.200
    15.415    34.666     0.200
    15.767    36.656     0.200
    16.771    38.242     0.200
    17.917    37.634     0.200
     0.360     5.053     0.200
     0.561     5.211     0.200
     0.599     5.804     0.200
     1.068     5.674     0.200
     1.143     6.615     0.200
     1.205     6.575     0.200
     1.389     6.897     0.200
     4.181    14.896     0.200
     5.018    14.927     0.200
     5.534    16.624     0.200
     6.889    17.784     0.200
     6.891    17.411     0.200
     7.366    20.532     0.200
     8.377    21.636     0.200
    12.016    32.263     0.200
    14.715    34.992     0.200
    14.715    35.336     0.200
    17.645    36.130     0.200
     0.309     3.757     0.200
     0.396     5.218     0.200
     0.480     4.940     0.200
     0.655     4.756     0.200
     0.693     6.002     0.200
     0.727     4.881     0.200
     0.718     5.134     0.200
     0.822     6.891     0.200
     1.042     5.545     0.200
     1.050     7.281     0.200
     1.066     6.188     0.200
     1.127     6.224     0.200
     1.486     8.390     0.200
     1.486     8.379     0.200
     5.450    16.303     0.200
     6.800    19.881     0.200
     8.289    24.348     0.200
    17.745    36.707     0.200
     0.403     5.113     0.200
     0.631     5.004     0.200
     0.685     6.003     0.200
     0.738     5.430     0.200
     0.800     6.885     0.200
     1.127     5.663     0.200
     1.463     8.314     0.200
     2.052     8.558     0.200
     2.052     9.628     0.200
     3.121    11.259     0.200
     3.724    11.220     0.200
     4.265    12.920     0.200
     4.265    15.615     0.200
     4.265    15.013     0.200
     4.937    15.556     0.200
     4.937    15.861     0.200
     4.936    15.684     0.200
     5.474    15.826     0.200
     6.822    18.697     0.200
     6.824    18.293     0.200
     6.824    21.267     0.200
     7.414    20.646     0.200
     7.414    21.413     0.200
     7.414    21.194     0.200
     7.966    22.329     0.200
     8.313    24.426     0.200
     8.566    25.421     0.200
     9.744    24.189     0.200
     9.747    23.820     0.200
    12.009    33.807     0.200
    11.991    29.033     0.200
    12.009    29.009     0.200
    12.928    29.731     0.200
    12.974    30.260     0.200
     0.370     5.263     0.200
     0.501     5.020     0.200
     0.679     4.609     0.200
     0.688     5.294     0.200
     0.680     5.973     0.200
     0.749     4.915     0.200
     0.833     6.618     0.200
     1.045     6.341     0.200
     1.071     5.534     0.200
     1.050     7.238     0.200
     1.148     6.806     0.200
     1.148     6.482     0.200
     1.499     8.111     0.200
     1.499     7.920     0.200
     2.016     8.109     0.200
     4.906    14.584     0.200
     0.400     5.247     0.200
     0.470     4.945     0.200
     0.674     4.760     0.200
     0.706     5.171     0.200
     0.709     6.079     0.200
     0.845     6.874     0.200
     1.046     6.147     0.200
     1.045     5.676     0.200
     1.117     6.832     0.200
     1.509     7.083     0.200
     2.006     8.553     0.200
     2.006     9.295     0.200
     3.156    13.219     0.200
     3.156    13.422     0.200
     3.756    12.027     0.200
     4.309    13.579     0.200
     4.309    15.977     0.200
     4.309    15.477     0.200
     4.525    14.951     0.200
     4.892    14.851     0.200
     4.892    15.663     0.200
     4.974    18.508     0.200
     5.429    17.380     0.200
     5.429    17.903     0.200
     5.429    18.005     0.200
     6.776    19.608     0.200
     6.778    19.587     0.200
     6.778    22.157     0.200
     6.778    20.056     0.200
     6.778    23.017     0.200
     6.778    21.209     0.200
     7.407    19.685     0.200
     7.407    20.717     0.200
     7.407    20.226     0.200
     7.920    22.395     0.200
     7.920    24.629     0.200
     8.197    24.393     0.200
     8.267    21.890     0.200
     8.267    26.281     0.200
     8.520    25.730     0.200
     9.654    26.265     0.200
     9.700    21.913     0.200
     9.703    23.482     0.200
     9.703    25.131     0.200
    10.879    32.198     0.200
    10.959    30.467     0.200
    11.976    29.846     0.200
    11.958    28.031     0.200
    11.976    30.916     0.200
    12.545    31.559     0.200
    12.580    31.349     0.200
    14.742    32.817     0.200
    14.809    31.776     0.200
    14.809    32.159     0.200
    14.809    35.479     0.200
    15.553    35.256     0.200
    18.851    39.061     0.200
    19.357    37.389     0.200
    20.707    39.308     0.200
     0.336     3.660     0.200
     0.453     4.685     0.200
     0.413     5.224     0.200
     0.701     4.605     0.200
     0.704     4.537     0.200
     0.692     5.031     0.200
     0.738     5.986     0.200
     0.882     6.736     0.200
     1.047     5.311     0.200
     1.016     5.981     0.200
     1.098     6.333     0.200
     1.098     5.974     0.200
     1.108     7.247     0.200
     1.280     7.347     0.200
     1.401     7.514     0.200
     1.545     8.094     0.200
     1.970     8.761     0.200
     4.855    14.694     0.200
     6.743    20.755     0.200
     6.743    21.753     0.200
     7.413    20.249     0.200
     0.364     3.991     0.200
     0.444     4.916     0.200
     0.423     5.302     0.200
     0.692     4.812     0.200
     0.672     5.244     0.200
     0.741     4.840     0.200
     0.767     6.165     0.200
     0.924     7.031     0.200
     0.979     6.213     0.200
     1.059     5.669     0.200
     1.086     5.655     0.200
     1.086     6.213     0.200
     1.146     7.255     0.200
     1.254     7.592     0.200
     1.388     7.132     0.200
     1.435     6.845     0.200
     1.401     7.143     0.200
     1.587     8.139     0.200
     1.587     8.167     0.200
     1.928     8.059     0.200
     3.206    11.824     0.200
     3.798    11.516     0.200
     4.387    14.378     0.200
     4.387    14.839     0.200
     4.813    14.663     0.200
     5.029    15.541     0.200
     5.029    14.940     0.200
     5.355    14.121     0.200
     6.700    16.544     0.200
     6.702    16.718     0.200
     6.702    20.716     0.200
     7.413    21.767     0.200
     7.413    21.597     0.200
     7.844    19.854     0.200
     9.621    20.561     0.200
     9.700    24.884     0.200
    11.934    32.285     0.200
    12.645    30.564     0.200
    14.796    37.070     0.200
    15.285    32.761     0.200
     0.402     5.125     0.200
     0.471     5.145     0.200
     0.663     5.001     0.200
     0.719     5.137     0.200
     0.715     5.225     0.200
     0.704     6.160     0.200
     0.834     7.081     0.200
     1.039     5.832     0.200
     1.058     6.138     0.200
     1.118     6.913     0.200
     1.118     6.621     0.200
     1.063     7.337     0.200
     1.497     8.506     0.200
     1.497     8.738     0.200
     1.497     8.550     0.200
     2.018     9.046     0.200
     2.018     9.272     0.200
     3.147    11.802     0.200
     3.147    13.201     0.200
     3.747    12.093     0.200
     3.747    11.897     0.200
     4.298    14.718     0.200
     4.298    16.163     0.200
     4.525    14.721     0.200
     4.903    15.576     0.200
     4.903    16.005     0.200
     4.964    16.098     0.200
     4.964    19.199     0.200
     5.440    16.917     0.200
     5.440    17.831     0.200
     6.788    19.341     0.200
     6.790    19.671     0.200
     6.790    21.890     0.200
     6.790    21.687     0.200
     6.790    20.887     0.200
     7.410    19.445     0.200
     7.410    19.415     0.200
     7.410    20.970     0.200
     7.931    22.463     0.200
     8.187    21.083     0.200
     8.220    20.595     0.200
     8.279    23.005     0.200
     9.169    26.314     0.200
     9.651    26.042     0.200
    10.881    27.745     0.200
    11.985    32.700     0.200
    11.986    29.894     0.200
    14.738    37.236     0.200
    14.798    34.972     0.200
    14.798    33.456     0.200
    17.757    37.438     0.200
    20.201    39.986     0.200
     0.456     4.910     0.200
     0.411     5.020     0.200
     0.687     4.712     0.200
     0.703     5.305     0.200
     0.728     6.048     0.200
     1.041     5.798     0.200
     1.032     6.399     0.200
     1.528     8.132     0.200
     1.528     8.184     0.200
     1.987     8.738     0.200
     5.412    17.377     0.200
     6.758    20.356     0.200
     6.760    20.178     0.200
     9.682    25.198     0.200
     0.302     4.072     0.200
     0.419     5.281     0.200
     0.452     5.074     0.200
     0.663     4.871     0.200
     0.700     4.978     0.200
     0.723     6.029     0.200
     0.724     5.061     0.200
     1.025     5.653     0.200
     1.057     5.966     0.200
     1.078     7.243     0.200
     1.099     5.921     0.200
     1.099     6.769     0.200
     1.099     5.863     0.200
     1.289     7.438     0.200
     1.316     7.327     0.200
     1.319     7.168     0.200
     1.387     6.881     0.200
     1.425     7.397     0.200
     1.469     6.875     0.200
     1.506     8.170     0.200
     1.506     7.920     0.200
     1.506     8.068     0.200
     1.506     7.948     0.200
     1.572     8.185     0.200
     1.633     8.183     0.200
     1.667     8.068     0.200
     1.791     8.727     0.200
     1.865     8.633     0.200
     1.911     8.311     0.200
     1.946     8.654     0.200
     2.010     8.297     0.200
     2.010     8.937     0.200
     2.010     8.640     0.200
     2.010     8.484     0.200
     2.026     7.246     0.200
     2.320    10.342     0.200
     2.330     8.541     0.200
     2.375     7.989     0.200
     2.618    10.367     0.200
     2.685    10.618     0.200
     2.846     9.128     0.200
     3.141    12.636     0.200
     3.141    13.035     0.200
     3.245    11.113     0.200
     3.434    12.640     0.200
     3.739    11.857     0.200
     3.768    11.924     0.200
     3.953    13.599     0.200
     4.248    12.818     0.200
     4.310    13.981     0.200
     4.310    16.200     0.200
     4.310    16.496     0.200
     4.310    15.098     0.200
     4.310    15.200     0.200
     4.424    14.395     0.200
     4.430    15.340     0.200
     4.543    13.974     0.200
     4.686    16.454     0.200
     4.893    14.481     0.200
     4.893    15.590     0.200
     4.893    14.997     0.200
     4.893    14.614     0.200
     4.893    15.145     0.200
     4.960    16.214     0.200
     4.960    17.511     0.200
     5.264    17.277     0.200
     5.374    15.280     0.200
     5.436    17.316     0.200
     5.436    17.551     0.200
     5.436    17.652     0.200
     5.907    18.984     0.200
     6.183    19.036     0.200
     6.268    19.391     0.200
     6.309    19.702     0.200
     6.400    20.105     0.200
     6.400    20.808     0.200
     6.543    18.579     0.200
     6.782    20.630     0.200
     6.784    20.702     0.200
     6.784    21.624     0.200
     6.784    21.523     0.200
     6.784    21.327     0.200
     6.784    21.426     0.200
     7.044    21.819     0.200
     7.067    20.077     0.200
     7.427    20.074     0.200
     7.426    20.474     0.200
     7.740    23.643     0.200
     7.926    23.535     0.200
     7.926    24.394     0.200
     7.926    23.996     0.200
     7.926    24.191     0.200
     7.980    19.668     0.200
     8.149    22.409     0.200
     8.162    24.369     0.200
     8.200    23.998     0.200
     8.234    20.195     0.200
     8.274    23.815     0.200
     8.274    24.136     0.200
     8.274    24.401     0.200
     8.310    19.260     0.200
     8.524    23.287     0.200
     8.524    24.623     0.200
     8.943    23.828     0.200
     9.063    24.871     0.200
     9.075    27.060     0.200
     9.186    24.590     0.200
     9.186    24.715     0.200
     9.186    25.793     0.200
     9.282    27.604     0.200
     9.400    26.102     0.200
     9.484    27.424     0.200
     9.537    24.944     0.200
     9.670    25.814     0.200
     9.670    24.744     0.200
     9.700    21.442     0.200
     9.703    22.113     0.200
     9.703    25.363     0.200
     9.836    28.316     0.200
     9.875    28.285     0.200
    10.234    25.610     0.200
    10.513    28.105     0.200
    10.592    31.058     0.200
    10.896    28.729     0.200
    10.896    25.830     0.200
    10.898    26.504     0.200
    10.941    31.856     0.200
    10.968    28.454     0.200
    10.968    29.290     0.200
    10.968    29.391     0.200
    10.968    28.204     0.200
    11.557    32.197     0.200
    11.993    31.534     0.200
    11.993    29.572     0.200
    12.562    30.193     0.200
    12.568    32.216     0.200
    12.568    29.318     0.200
    12.759    32.093     0.200
    12.759    31.093     0.200
    12.759    32.601     0.200
    12.841    30.767     0.200
    12.841    30.900     0.200
    12.910    32.578     0.200
    12.910    31.836     0.200
    12.910    32.938     0.200
    12.910    34.375     0.200
    12.943    31.655     0.200
    14.757    35.385     0.200
    14.800    33.545     0.200
    14.800    33.779     0.200
    14.800    32.678     0.200
    15.206    34.911     0.200
    15.206    35.833     0.200
    15.206    35.138     0.200
    15.206    34.138     0.200
    15.549    31.708     0.200
    15.549    32.175     0.200
    15.549    34.432     0.200
    16.768    35.839     0.200
    17.767    36.873     0.200
    17.767    36.373     0.200
    18.995    38.318     0.200
    19.535    37.420     0.200
     0.365     3.815     0.200
     0.418     5.195     0.200
     0.697     4.648     0.200
     0.670     5.174     0.200
     0.739     4.683     0.200
     0.761     6.018     0.200
     0.919     6.872     0.200
     0.980     6.162     0.200
     1.062     5.453     0.200
     1.091     6.122     0.200
     1.091     6.188     0.200
     1.141     7.337     0.200
     1.253     7.517     0.200
     1.397     7.059     0.200
     1.437     6.893     0.200
     1.518     6.766     0.200
     1.583     8.093     0.200
     1.583     7.848     0.200
     1.932     8.138     0.200
     4.818    13.835     0.200
     0.372     4.884     0.200
     0.590     4.557     0.200
     0.611     5.623     0.200
     0.755     5.327     0.200
     0.725     6.370     0.200
     0.951     6.882     0.200
     1.144     6.347     0.200
     1.213     7.430     0.200
     1.391     8.156     0.200
     1.391     7.340     0.200
     1.391     8.129     0.200
     2.124     7.868     0.200
     3.100    10.476     0.200
     3.713    11.533     0.200
     3.713    11.736     0.200
     4.186    13.167     0.200
     4.906    14.314     0.200
     5.014    14.195     0.200
     5.535    15.478     0.200
     6.888    18.051     0.200
     6.890    21.035     0.200
     7.379    20.259     0.200
     7.379    19.151     0.200
     9.568    25.579     0.200
     0.357     4.074     0.200
     0.447     4.912     0.200
     0.419     5.399     0.200
     0.695     4.827     0.200
     0.677     5.256     0.200
     0.731     4.925     0.200
     0.758     6.177     0.200
     0.912     7.157     0.200
     0.989     6.193     0.200
     1.056     5.701     0.200
     1.090     6.117     0.200
     1.090     6.246     0.200
     1.135     7.271     0.200
     1.261     7.582     0.200
     1.389     7.258     0.200
     1.430     7.147     0.200
     1.399     7.137     0.200
     1.575     8.405     0.200
     1.575     8.121     0.200
     1.940     8.544     0.200
     4.826    14.186     0.200
     5.367    16.606     0.200
     6.712    19.173     0.200
     6.714    21.735     0.200
     7.412    22.488     0.200
     9.693    26.167     0.200
    11.941    32.333     0.200
     0.033     5.722     0.200
     0.333     3.947     0.200
     0.453     4.891     0.200
     0.412     5.461     0.200
     0.702     4.725     0.200
     0.700     5.022     0.200
     0.695     5.319     0.200
     0.736     6.169     0.200
     0.878     6.879     0.200
     1.020     6.183     0.200
     1.045     5.526     0.200
     1.099     5.719     0.200
     1.099     5.981     0.200
     1.105     7.773     0.200
     1.541     8.206     0.200
     1.541     8.070     0.200
     1.974     8.196     0.200
     4.859    14.357     0.200
     5.399    15.074     0.200
     6.747    19.128     0.200
     7.414    18.973     0.200
     0.046     5.591     0.200
     0.341     3.812     0.200
     0.390     5.513     0.200
     0.477     4.884     0.200
     0.697     4.715     0.200
     0.725     4.734     0.200
     0.685     5.314     0.200
     0.712     6.146     0.200
     0.864     6.771     0.200
     1.062     5.372     0.200
     1.023     6.159     0.200
     1.123     6.697     0.200
     1.123     6.670     0.200
     1.084     7.685     0.200
     1.277     7.537     0.200
     1.346     6.991     0.200
     1.528     8.119     0.200
     1.528     7.812     0.200
     1.986     8.983     0.200
     4.874    14.382     0.200
     5.407    16.968     0.200
     6.757    18.420     0.200
     0.367     5.068     0.200
     0.554     4.878     0.200
     0.592     4.432     0.200
     0.606     5.772     0.200
     0.752     5.268     0.200
     0.723     6.365     0.200
     0.797     5.335     0.200
     0.947     6.802     0.200
     1.061     5.498     0.200
     1.144     6.329     0.200
     1.197     7.002     0.200
     1.213     7.348     0.200
     1.389     7.889     0.200
     1.389     7.607     0.200
     1.390     7.619     0.200
     2.125     8.946     0.200
     3.103    11.807     0.200
     3.716    11.452     0.200
     4.183    14.702     0.200
     4.908    17.644     0.200
     5.016    15.460     0.200
     6.889    18.240     0.200
     6.891    18.871     0.200
     7.373    19.347     0.200
     7.373    20.401     0.200
     7.373    19.760     0.200
     9.562    24.644     0.200
    12.021    30.192     0.200
     0.367     3.782     0.200
     0.451     4.672     0.200
     0.416     5.226     0.200
     0.698     4.591     0.200
     0.667     5.174     0.200
     0.742     4.863     0.200
     0.761     6.081     0.200
     0.921     6.959     0.200
     0.978     6.248     0.200
     1.064     5.463     0.200
     1.093     5.551     0.200
     1.093     6.117     0.200
     1.142     7.153     0.200
     1.250     7.503     0.200
     1.585     8.428     0.200
     1.585     8.183     0.200
     1.930     7.897     0.200
     4.816    14.380     0.200
     0.384     5.264     0.200
     0.487     4.972     0.200
     0.671     4.683     0.200
     0.735     5.009     0.200
     0.700     5.214     0.200
     1.057     5.589     0.200
     1.050     6.200     0.200
     1.134     6.451     0.200
     1.498     8.048     0.200
     1.498     7.554     0.200
     2.017     8.935     0.200
     4.905    15.102     0.200
     5.435    17.040     0.200
     6.784    19.585     0.200
     6.787    16.980     0.200
    14.805    32.589     0.200
     0.365     5.215     0.200
     0.505     4.919     0.200
     0.681     4.821     0.200
     0.685     5.064     0.200
     0.676     5.897     0.200
     0.753     4.834     0.200
     0.833     6.877     0.200
     1.043     5.944     0.200
     1.075     5.580     0.200
     1.048     7.168     0.200
     1.152     6.574     0.200
     1.499     8.078     0.200
     2.016     9.092     0.200
     4.907    15.456     0.200
     6.783    20.480     0.200
     8.973    21.599     0.200
     0.451     4.946     0.200
     0.417     5.006     0.200
     0.664     5.139     0.200
     0.747     5.306     0.200
     0.763     6.143     0.200
     1.067     6.030     0.200
     1.145     7.234     0.200
     1.589     8.638     0.200
     7.405    22.448     0.200
     0.696     4.774     0.200
     1.069     5.816     0.200
     1.089     6.337     0.200
     1.089     6.220     0.200
     1.156     7.125     0.200
     1.240     7.605     0.200
     1.600     8.623     0.200
     1.601     8.515     0.200
     1.914     9.485     0.200
     3.220    11.097     0.200
     3.220    10.397     0.200
     3.812    11.794     0.200
     4.400    16.053     0.200
     4.400    16.432     0.200
     4.801    16.933     0.200
     5.044    16.209     0.200
     5.044    17.709     0.200
     5.340    17.595     0.200
     6.686    21.386     0.200
     6.687    21.224     0.200
     6.688    19.469     0.200
     7.405    20.219     0.200
     9.700    25.124     0.200
     9.700    25.474     0.200
    10.887    31.623     0.200
    11.920    30.028     0.200
    11.903    31.322     0.200
    12.585    31.905     0.200
    14.798    34.682     0.200
     0.606     4.443     0.200
     0.616     5.677     0.200
     0.740     5.067     0.200
     0.790     5.120     0.200
     0.963     6.901     0.200
     1.063     5.324     0.200
     1.127     6.106     0.200
     1.190     6.548     0.200
     1.190     6.904     0.200
     1.230     6.990     0.200
     1.407     7.771     0.200
     1.407     7.672     0.200
     2.108     9.126     0.200
     4.999    14.659     0.200
     5.518    16.330     0.200
     6.871    19.314     0.200
     6.873    19.564     0.200
     6.874    21.047     0.200
     7.372    23.053     0.200
    12.010    30.472     0.200
     0.487     4.962     0.200
     0.384     4.841     0.200
     0.673     4.659     0.200
     0.735     4.898     0.200
     0.699     4.943     0.200
     1.057     5.647     0.200
     1.049     5.945     0.200
     1.134     6.380     0.200
     1.134     6.236     0.200
     1.500     8.043     0.200
     1.500     8.059     0.200
     2.015     8.302     0.200
     3.161    11.354     0.200
     3.763    12.135     0.200
     4.297    14.624     0.200
     4.297    15.095     0.200
     4.297    15.695     0.200
     4.508    14.133     0.200
     4.903    15.178     0.200
     4.977    15.965     0.200
     5.433    17.675     0.200
     6.783    19.880     0.200
     6.784    21.329     0.200
     6.785    21.867     0.200
     7.392    21.602     0.200
     7.926    22.631     0.200
     8.273    22.753     0.200
     9.710    21.875     0.200
    11.970    33.803     0.200
    14.807    34.367     0.200
    14.807    33.222     0.200
    15.566    32.830     0.200
     0.180     5.004     0.200
     0.732     5.281     0.200
     0.767     6.875     0.200
     0.832     4.833     0.200
     1.037     6.839     0.200
     1.166     6.413     0.200
     1.420     8.436     0.200
     1.420     8.142     0.200
     2.102     8.702     0.200
     4.236    14.401     0.200
     4.236    15.593     0.200
     4.973    15.595     0.200
     4.973    16.197     0.200
     5.540    16.312     0.200
     5.540    18.082     0.200
     6.880    20.928     0.200
     6.882    22.190     0.200
     7.500    22.902     0.200
     8.026    24.369     0.200
     8.374    20.304     0.200
     8.374    25.804     0.200
     9.782    21.910     0.200
     9.782    24.871     0.200
    12.103    32.993     0.200
     0.455     4.809     0.200
     0.412     5.056     0.200
     0.739     5.029     0.200
     1.066     5.924     0.200
     1.136     7.213     0.200
     1.580     8.413     0.200
     3.208    11.992     0.200
     3.802    11.862     0.200
     4.379    15.524     0.200
     5.031    16.520     0.200
     7.403    20.620     0.200
     0.372     5.124     0.200
     0.509     4.789     0.200
     0.650     4.484     0.200
     0.710     5.117     0.200
     0.756     5.071     0.200
     0.662     5.732     0.200
     0.802     6.493     0.200
     1.075     6.204     0.200
     1.061     5.547     0.200
     1.023     6.946     0.200
     1.155     6.385     0.200
     1.467     7.792     0.200
     3.147    11.216     0.200
     3.752    11.755     0.200
     4.263    15.087     0.200
     4.959    17.464     0.200
     6.815    22.252     0.200
     9.744    21.278     0.200
     0.364     4.054     0.200
     0.446     4.821     0.200
     0.420     5.253     0.200
     0.672     5.241     0.200
     0.695     4.747     0.200
     0.739     4.881     0.200
     0.763     6.141     0.200
     0.981     6.080     0.200
     1.089     6.521     0.200
     1.089     5.740     0.200
     1.089     5.806     0.200
     1.060     5.679     0.200
     1.142     7.294     0.200
     1.254     7.487     0.200
     1.583     8.599     0.200
     1.584     8.284     0.200
     1.584     8.643     0.200
     1.932     8.295     0.200
     1.932     8.584     0.200
     3.205    11.520     0.200
     3.798    11.706     0.200
     4.384    14.851     0.200
     4.384    16.171     0.200
     4.384    15.866     0.200
     4.817    14.410     0.200
     4.817    15.207     0.200
     5.028    16.047     0.200
     5.358    17.318     0.200
     5.358    17.896     0.200
     6.703    19.198     0.200
     6.705    19.786     0.200
     6.705    20.778     0.200
     6.705    20.525     0.200
     7.410    20.021     0.200
     9.627    21.206     0.200
     9.627    24.276     0.200
     9.696    26.075     0.200
    11.934    28.595     0.200
     0.447     4.757     0.200
     0.423     5.063     0.200
     0.660     5.113     0.200
     0.757     4.462     0.200
     0.774     5.765     0.200
     0.938     6.697     0.200
     0.963     6.083     0.200
     1.068     5.425     0.200
     1.087     5.932     0.200
     1.087     5.928     0.200
     1.158     6.784     0.200
     1.241     7.428     0.200
     1.416     6.845     0.200
     1.602     8.089     0.200
     1.602     7.422     0.200
     1.602     8.109     0.200
     1.913     8.228     0.200
     3.220    10.229     0.200
     3.220     9.933     0.200
     3.811    11.236     0.200
     3.811    11.135     0.200
     4.401    15.247     0.200
     4.554    14.459     0.200
     4.799    14.775     0.200
     5.044    14.244     0.200
     5.044    18.541     0.200
     5.339    17.063     0.200
     6.685    19.976     0.200
     6.686    19.260     0.200
     6.687    21.694     0.200
     7.407    19.205     0.200
     7.407    22.464     0.200
     7.829    22.303     0.200
     9.703    25.451     0.200
     9.703    24.381     0.200
     9.703    25.983     0.200
    11.921    32.291     0.200
    14.800    36.583     0.200
    14.895    34.985     0.200
    20.787    38.223     0.200
     0.380     5.011     0.200
     0.499     5.032     0.200
     0.714     4.925     0.200
     0.650     4.993     0.200
     0.672     5.905     0.200
     0.807     6.897     0.200
     1.074     6.007     0.200
     1.031     7.035     0.200
     1.093     5.874     0.200
     1.146     6.593     0.200
     1.146     6.418     0.200
     1.472     8.306     0.200
     1.472     8.149     0.200
     1.472     8.329     0.200
     2.043     8.278     0.200
     2.043     9.068     0.200
     2.043     9.767     0.200
     3.144    11.019     0.200
     3.144    11.919     0.200
     3.748    11.969     0.200
     4.269    12.926     0.200
     4.269    15.186     0.200
     4.269    15.436     0.200
     4.498    12.314     0.200
     4.931    15.270     0.200
     4.931    15.461     0.200
     4.931    15.911     0.200
     4.957    15.657     0.200
     4.957    17.357     0.200
     5.460    17.780     0.200
     5.460    17.889     0.200
     5.460    18.290     0.200
     6.810    19.905     0.200
     6.812    20.244     0.200
     6.812    22.613     0.200
     6.812    22.213     0.200
     6.812    20.998     0.200
     7.391    19.156     0.200
     7.391    20.256     0.200
     7.391    19.488     0.200
     7.391    20.332     0.200
     7.953    22.087     0.200
     7.953    24.997     0.200
     7.953    23.237     0.200
     8.157    24.314     0.200
     8.157    24.514     0.200
     8.300    22.801     0.200
     8.300    23.851     0.200
     8.300    25.361     0.200
     9.621    25.256     0.200
     9.741    24.156     0.200
    10.859    30.983     0.200
    11.986    31.904     0.200
    11.986    29.925     0.200
    12.514    30.572     0.200
    12.956    31.164     0.200
    14.706    34.485     0.200
    14.706    36.485     0.200
    14.782    33.080     0.200
    14.782    34.900     0.200
    14.782    32.860     0.200
    14.782    33.909     0.200
     0.394     5.212     0.200
     0.618     4.500     0.200
     0.744     5.127     0.200
     0.742     5.239     0.200
     1.105     6.302     0.200
     1.144     6.278     0.200
     1.144     6.414     0.200
     1.144     7.101     0.200
     1.260     7.128     0.200
     1.443     7.895     0.200
     1.443     7.338     0.200
     1.443     7.916     0.200
     2.072     8.862     0.200
     3.114    11.609     0.200
     3.720    11.643     0.200
     3.720    11.541     0.200
     4.243    14.000     0.200
     4.243    15.039     0.200
     4.243    15.277     0.200
     4.503    13.099     0.200
     4.927    16.160     0.200
     4.927    17.363     0.200
     4.958    15.282     0.200
     4.958    12.442     0.200
     5.491    17.331     0.200
     5.491    18.870     0.200
     5.491    18.671     0.200
     6.841    21.866     0.200
     6.842    21.403     0.200
     6.842    22.403     0.200
     6.842    21.763     0.200
     6.843    21.338     0.200
     7.405    20.409     0.200
     7.405    20.255     0.200
     7.984    24.194     0.200
     7.984    25.084     0.200
     8.132    24.650     0.200
     8.226    21.853     0.200
     8.331    23.317     0.200
     8.331    24.036     0.200
     9.619    24.929     0.200
     9.619    25.605     0.200
     9.768    22.788     0.200
     9.768    21.956     0.200
    10.870    31.796     0.200
    12.014    31.465     0.200
    12.514    29.918     0.200
    14.700    34.605     0.200
    14.700    36.207     0.200
    14.750    34.379     0.200
    15.617    32.495     0.200
    17.702    36.906     0.200
     0.394     5.164     0.200
     0.474     4.875     0.200
     0.683     4.705     0.200
     0.722     4.825     0.200
     0.697     5.200     0.200
     0.708     6.089     0.200
     0.851     6.861     0.200
     1.053     5.560     0.200
     1.038     6.118     0.200
     1.121     6.635     0.200
     1.120     6.741     0.200
     1.120     6.331     0.200
     1.515     8.258     0.200
     3.166    12.172     0.200
     3.765    11.773     0.200
     4.314    15.270     0.200
     4.886    15.794     0.200
     4.983    15.058     0.200
     5.420    20.059     0.200
     6.770    22.206     0.200
     6.771    18.804     0.200
     7.400    20.554     0.200
     9.652    25.229     0.200
    11.967    30.111     0.200
    14.818    33.825     0.200
     0.374     5.072     0.200
     0.499     4.899     0.200
     0.697     5.121     0.200
     0.670     4.786     0.200
     0.747     4.988     0.200
     0.679     5.904     0.200
     0.826     6.734     0.200
     1.053     6.033     0.200
     1.065     5.584     0.200
     1.046     7.008     0.200
     1.145     6.973     0.200
     1.145     6.544     0.200
     1.146     6.848     0.200
     1.146     6.969     0.200
     1.492     8.308     0.200
     1.492     7.149     0.200
     1.492     8.328     0.200
     2.023     8.740     0.200
     3.162    11.237     0.200
     3.765    11.600     0.200
     3.765    11.701     0.200
     4.287    14.005     0.200
     4.287    15.404     0.200
     4.912    15.384     0.200
     4.912    15.911     0.200
     4.977    15.161     0.200
     4.977    16.861     0.200
     5.439    15.853     0.200
     5.439    18.963     0.200
     6.789    20.595     0.200
     6.791    20.406     0.200
     6.791    20.683     0.200
     6.791    22.183     0.200
     6.792    21.707     0.200
     7.383    19.007     0.200
     7.383    18.660     0.200
     7.383    20.578     0.200
     7.932    19.868     0.200
     8.279    23.822     0.200
     9.720    22.337     0.200
     9.624    25.546     0.200
     9.723    25.089     0.200
     9.723    23.276     0.200
    11.968    31.331     0.200
    11.968    33.975     0.200
    14.712    34.948     0.200
    14.712    37.346     0.200
    17.750    38.428     0.200
     0.388     4.953     0.200
     0.524     4.638     0.200
     0.592     4.318     0.200
     0.636     5.639     0.200
     0.767     5.142     0.200
     0.759     5.136     0.200
     1.039     5.407     0.200
     1.167     6.517     0.200
     1.137     6.221     0.200
     1.225     6.979     0.200
     1.405     7.809     0.200
     3.096    12.076     0.200
     3.706    11.762     0.200
     4.905    15.875     0.200
     6.878    21.399     0.200
     7.397    19.919     0.200
    12.030    31.533     0.200
     0.399     4.949     0.200
     0.484     4.804     0.200
     0.636     4.602     0.200
     0.730     5.108     0.200
     0.683     5.822     0.200
     0.732     5.153     0.200
     0.803     6.688     0.200
     1.034     5.506     0.200
     1.034     7.172     0.200
     1.086     6.351     0.200
     1.130     6.794     0.200
     1.466     8.245     0.200
     3.126    11.436     0.200
     3.730    11.998     0.200
     4.267    13.331     0.200
     4.941    15.566     0.200
     6.820    21.421     0.200
     7.409    23.446     0.200
     9.635    28.659     0.200
    12.003    33.217     0.200
    17.726    34.967     0.200
     0.468     4.823     0.200
     0.399     5.107     0.200
     0.717     4.814     0.200
     0.687     4.767     0.200
     0.697     5.195     0.200
     0.716     6.053     0.200
     0.858     6.859     0.200
     1.033     6.160     0.200
     1.050     5.578     0.200
     1.114     6.280     0.200
     1.115     6.316     0.200
     1.083     7.196     0.200
     1.522     8.192     0.200
     1.993     8.710     0.200
     4.879    14.816     0.200
     1.196     6.292     0.200
     2.133     9.299     0.200
     2.133     9.889     0.200
     2.133     9.639     0.200
     4.207    15.286     0.200
     4.207    15.677     0.200
     4.207    15.927     0.200
     4.585    12.665     0.200
     4.821    18.220     0.200
     5.003    15.503     0.200
     5.003    16.093     0.200
     5.003    16.343     0.200
     5.571    17.378     0.200
     5.571    18.070     0.200
     5.571    18.371     0.200
     6.911    22.137     0.200
     6.913    21.366     0.200
     6.913    22.104     0.200
     6.913    21.891     0.200
     7.507    18.159     0.200
     7.507    19.696     0.200
     8.082    20.156     0.200
     8.057    21.492     0.200
     8.057    24.754     0.200
     8.057    24.305     0.200
     8.104    24.003     0.200
     8.336    19.496     0.200
     8.336    20.098     0.200
     8.648    23.579     0.200
     8.648    25.360     0.200
     8.903    23.884     0.200
     9.264    24.169     0.200
     9.264    22.931     0.200
     9.680    24.914     0.200
     9.680    23.711     0.200
     9.810    22.098     0.200
     9.812    21.788     0.200
     9.812    25.069     0.200
    10.966    28.806     0.200
    12.126    32.271     0.200
    12.126    28.641     0.200
    12.429    31.537     0.200
    12.429    30.435     0.200
    12.581    29.556     0.200
    12.899    34.348     0.200
    13.083    30.557     0.200
    14.662    35.247     0.200
    14.662    35.977     0.200
    14.662    35.196     0.200
    15.067    35.543     0.200
    15.067    36.339     0.200
    15.639    34.472     0.200
    16.814    37.247     0.200
    19.128    39.950     0.200
    19.504    40.360     0.200
     0.393     5.048     0.200
     0.476     4.918     0.200
     0.679     4.733     0.200
     0.724     4.881     0.200
     0.704     5.958     0.200
     0.699     5.105     0.200
     1.052     5.588     0.200
     1.042     6.092     0.200
     1.123     6.451     0.200
     3.163    11.541     0.200
     3.763    11.945     0.200
     4.980    15.436     0.200
     6.775    20.112     0.200
     0.447     4.702     0.200
     0.423     5.025     0.200
     0.694     4.971     0.200
     0.757     5.350     0.200
     0.774     6.238     0.200
     0.963     6.241     0.200
     1.087     6.247     0.200
     1.068     5.912     0.200
     1.157     7.446     0.200
     1.601     8.657     0.200
     6.687    19.876     0.200
     9.607    23.418     0.200
    15.463    34.737     0.200
     0.396     5.140     0.200
     0.480     5.045     0.200
     0.654     4.844     0.200
     0.728     5.197     0.200
     0.692     5.994     0.200
     0.718     5.307     0.200
     0.821     6.778     0.200
     1.042     5.719     0.200
     1.067     6.388     0.200
     1.049     7.159     0.200
     1.127     6.384     0.200
     1.127     7.283     0.200
     1.127     6.397     0.200
     1.485     8.261     0.200
     1.485     7.461     0.200
     1.485     8.313     0.200
     2.030     8.097     0.200
     2.030     9.449     0.200
     2.030     9.347     0.200
     3.142    11.976     0.200
     3.142    11.773     0.200
     3.744    12.046     0.200
     3.744    11.851     0.200
     4.285    13.756     0.200
     4.285    15.935     0.200
     4.285    15.138     0.200
     4.285    15.287     0.200
     4.916    15.017     0.200
     4.916    16.314     0.200
     4.957    16.686     0.200
     4.957    17.686     0.200
     5.451    16.752     0.200
     5.451    18.026     0.200
     6.799    18.198     0.200
     6.801    17.138     0.200
     6.801    22.067     0.200
     6.801    21.325     0.200
     6.801    21.252     0.200
     7.405    20.158     0.200
     7.405    20.744     0.200
     7.405    20.313     0.200
     7.943    20.097     0.200
     7.943    23.948     0.200
     7.943    23.745     0.200
     8.543    21.729     0.200
     9.641    25.729     0.200
     9.724    22.416     0.200
     9.726    22.727     0.200
     9.726    23.633     0.200
    11.989    32.493     0.200
    12.533    33.077     0.200
    12.763    33.892     0.200
    12.951    31.568     0.200
    14.726    37.286     0.200
    14.788    33.302     0.200
    15.576    35.561     0.200
    17.744    37.954     0.200
    17.744    37.306     0.200
    20.686    40.531     0.200
     0.538     5.912     0.200
     0.674     5.610     0.200
     0.785     6.672     0.200
     1.185     8.160     0.200
     1.184     8.165     0.200
     1.476     9.562     0.200
     1.476     9.308     0.200
     1.476     9.558     0.200
     2.039    10.305     0.200
     3.176    13.818     0.200
     3.783    14.436     0.200
     4.265    14.897     0.200
     4.265    15.817     0.200
     4.458    16.759     0.200
     4.986    17.794     0.200
     4.986    20.095     0.200
     4.934    18.520     0.200
     4.934    18.711     0.200
     5.447    19.072     0.200
     6.801    20.728     0.200
     6.803    19.937     0.200
     6.803    23.096     0.200
     6.803    23.255     0.200
     7.349    23.519     0.200
     8.289    22.678     0.200
     9.585    26.825     0.200
    10.846    29.711     0.200
    11.951    33.966     0.200
    11.951    35.116     0.200
    12.578    31.099     0.200
    14.674    35.942     0.200
    14.801    33.471     0.200
    14.801    36.362     0.200
     0.376     4.906     0.200
     0.553     4.876     0.200
     0.580     4.452     0.200
     0.606     5.618     0.200
     0.713     6.256     0.200
     0.795     5.293     0.200
     0.764     5.247     0.200
     0.941     6.877     0.200
     1.054     5.595     0.200
     1.155     6.347     0.200
     1.195     6.783     0.200
     1.196     6.727     0.200
     1.196     7.329     0.200
     1.202     7.148     0.200
     1.379     7.863     0.200
     2.135     8.868     0.200
     3.092    10.897     0.200
     3.705    11.741     0.200
     3.705    11.541     0.200
     4.175    14.760     0.200
     4.175    14.561     0.200
     4.896    17.941     0.200
     5.025    14.913     0.200
     5.546    16.956     0.200
     6.889    22.692     0.200
     6.900    19.751     0.200
     6.901    19.600     0.200
     6.901    22.339     0.200
     6.902    22.238     0.200
     7.380    19.866     0.200
     7.380    20.687     0.200
     8.042    20.675     0.200
     8.647    21.438     0.200
     9.137    23.345     0.200
     9.563    24.929     0.200
     9.563    27.378     0.200
     9.836    25.231     0.200
    11.069    27.921     0.200
    12.032    31.334     0.200
    12.032    33.763     0.200
    14.639    33.143     0.200
    14.639    36.744     0.200
    14.702    32.998     0.200
    14.702    35.658     0.200
    15.111    31.824     0.200
    15.687    34.269     0.200
    17.637    35.997     0.200
    20.581    38.199     0.200
     0.398     5.019     0.200
     0.470     4.943     0.200
     0.681     4.773     0.200
     0.719     4.968     0.200
     0.700     5.172     0.200
     0.711     6.116     0.200
     0.852     6.918     0.200
     1.039     6.165     0.200
     1.049     5.672     0.200
     1.117     6.754     0.200
     1.117     6.875     0.200
     1.117     6.176     0.200
     1.117     6.879     0.200
     1.117     6.231     0.200
     1.077     7.110     0.200
     1.515     8.909     0.200
     1.515     7.679     0.200
     1.515     8.929     0.200
     2.000     9.008     0.200
     3.163    12.200     0.200
     3.762    11.906     0.200
     4.315    13.651     0.200
     4.315    15.362     0.200
     4.315    15.600     0.200
     4.524    14.116     0.200
     4.886    15.586     0.200
     4.886    16.344     0.200
     5.422    16.566     0.200
     5.422    18.043     0.200
     5.422    18.195     0.200
     6.769    20.367     0.200
     6.771    19.666     0.200
     6.771    22.096     0.200
     6.771    21.733     0.200
     7.404    19.740     0.200
     7.404    19.331     0.200
     7.404    23.534     0.200
     7.913    20.822     0.200
     8.203    23.083     0.200
     8.203    26.383     0.200
     8.513    22.307     0.200
     9.655    28.239     0.200
     9.655    25.739     0.200
    10.877    32.583     0.200
    10.900    28.212     0.200
    14.744    36.350     0.200
    14.817    34.202     0.200
    14.817    33.652     0.200
    15.224    34.505     0.200
    17.775    37.903     0.200
    20.711    38.131     0.200
    20.711    39.111     0.200
     0.452     4.763     0.200
     0.415     4.914     0.200
     0.700     4.876     0.200
     0.739     4.983     0.200
     0.758     6.071     0.200
     0.981     6.210     0.200
     1.064     5.880     0.200
     1.094     6.204     0.200
     1.095     6.211     0.200
     1.138     7.244     0.200
     1.581     8.395     0.200
     1.581     7.955     0.200
     1.581     8.393     0.200
     1.934     9.223     0.200
     3.207    12.623     0.200
     3.800    12.200     0.200
     3.800    12.001     0.200
     4.380    14.880     0.200
     4.380    15.528     0.200
     4.546    14.788     0.200
     4.820    15.553     0.200
     5.029    15.753     0.200
     5.029    17.351     0.200
     5.359    16.803     0.200
     6.705    22.419     0.200
     6.707    21.979     0.200
     7.406    20.093     0.200
     9.690    28.059     0.200
    14.786    34.390     0.200
    14.786    37.691     0.200
    14.876    35.662     0.200
    17.841    37.536     0.200
    20.768    37.980     0.200
     0.402     5.047     0.200
     0.480     4.826     0.200
     0.637     4.615     0.200
     0.687     5.877     0.200
     0.805     6.726     0.200
     1.032     5.551     0.200
     1.038     7.387     0.200
     1.085     6.420     0.200
     1.468     8.301     0.200
     3.126    12.605     0.200
     3.729    11.875     0.200
     6.818    19.352     0.200
    12.004    28.348     0.200
     0.384     5.223     0.200
     0.488     4.956     0.200
     0.669     4.710     0.200
     0.702     5.233     0.200
     0.736     4.923     0.200
     0.689     5.994     0.200
     0.831     6.861     0.200
     1.053     6.210     0.200
     1.056     5.598     0.200
     1.054     7.041     0.200
     1.135     6.763     0.200
     1.135     6.409     0.200
     1.495     8.337     0.200
     1.496     7.854     0.200
     2.019     8.826     0.200
     4.907    15.162     0.200
     5.438    15.350     0.200
     6.789    16.974     0.200
     6.789    19.709     0.200
     7.393    19.455     0.200
    11.973    30.541     0.200
    16.733    36.587     0.200
     0.476     5.037     0.200
     0.725     5.419     0.200
     0.694     5.126     0.200
     0.687     5.143     0.200
     0.711     5.892     0.200
     0.861     7.108     0.200
     1.026     6.630     0.200
     1.060     6.082     0.200
     1.122     6.802     0.200
     1.122     6.700     0.200
     1.123     6.923     0.200
     1.123     6.798     0.200
     1.082     7.147     0.200
     1.525     8.700     0.200
     1.525     8.200     0.200
     1.526     8.142     0.200
     1.989     9.113     0.200
     1.989     9.480     0.200
     3.176    12.431     0.200
     3.775    12.534     0.200
     3.775    12.339     0.200
     4.323    15.347     0.200
     4.323    15.550     0.200
     4.323    15.886     0.200
     4.519    13.168     0.200
     4.877    16.030     0.200
     4.994    17.114     0.200
     4.994    17.911     0.200
     5.410    17.784     0.200
     5.410    18.167     0.200
     5.410    18.518     0.200
     6.758    20.659     0.200
     6.760    20.778     0.200
     6.760    22.208     0.200
     6.760    19.135     0.200
     7.395    20.671     0.200
     7.395    18.601     0.200
     7.395    20.602     0.200
     7.395    18.829     0.200
     7.901    22.160     0.200
     7.901    24.988     0.200
     8.200    22.609     0.200
     8.211    24.276     0.200
     8.211    26.276     0.200
     9.154    28.065     0.200
     9.154    23.464     0.200
     9.684    23.983     0.200
     9.652    24.203     0.200
     9.652    25.156     0.200
    10.869    29.858     0.200
    11.957    32.769     0.200
    11.939    29.243     0.200
    11.957    29.417     0.200
    12.542    30.733     0.200
    12.600    31.152     0.200
    12.600    29.652     0.200
    14.743    36.747     0.200
    14.829    35.207     0.200
    14.829    34.840     0.200
    14.829    35.207     0.200
    14.829    34.090     0.200
    15.541    37.009     0.200
    16.742    36.155     0.200
    17.785    37.275     0.200
    17.785    38.267     0.200
     0.363     4.863     0.200
     0.551     4.822     0.200
     0.601     4.121     0.200
     0.744     5.089     0.200
     0.794     5.161     0.200
     1.064     5.271     0.200
     1.134     6.178     0.200
     1.195     6.539     0.200
     1.195     6.614     0.200
     1.195     6.204     0.200
     1.223     6.853     0.200
     1.399     7.573     0.200
     1.400     6.819     0.200
     2.116     9.113     0.200
     3.111    12.342     0.200
     3.724    11.499     0.200
     4.193    13.921     0.200
     4.193    14.921     0.200
     4.917    16.473     0.200
     4.917    17.973     0.200
     5.007    15.614     0.200
     5.525    17.697     0.200
     6.879    20.916     0.200
     6.881    20.895     0.200
     6.881    21.555     0.200
     6.881    20.677     0.200
     7.371    20.825     0.200
     7.371    19.235     0.200
     7.371    19.427     0.200
     8.021    23.802     0.200
     8.080    22.656     0.200
     9.565    25.151     0.200
     9.565    24.726     0.200
    12.013    28.757     0.200
    14.724    35.169     0.200
    17.656    37.671     0.200
     0.017     5.866     0.200
     0.356     4.010     0.200
     0.441     5.009     0.200
     0.426     5.325     0.200
     0.689     4.793     0.200
     0.679     5.207     0.200
     0.733     4.681     0.200
     0.766     6.097     0.200
     0.917     6.925     0.200
     0.987     6.108     0.200
     1.052     5.557     0.200
     1.084     6.055     0.200
     1.084     6.354     0.200
     1.083     6.168     0.200
     1.142     7.163     0.200
     1.262     7.468     0.200
     1.395     7.047     0.200
     1.580     8.788     0.200
     1.580     7.639     0.200
     1.935     8.325     0.200
     3.198    11.982     0.200
     3.790    11.469     0.200
     4.381    13.911     0.200
     4.381    13.670     0.200
     4.557    13.719     0.200
     4.820    14.195     0.200
     5.021    16.200     0.200
     5.021    16.800     0.200
     5.363    14.776     0.200
     6.707    18.585     0.200
     6.709    18.292     0.200
     6.710    21.676     0.200
     7.417    22.182     0.200
     7.417    20.273     0.200
     7.417    20.670     0.200
     7.852    22.759     0.200
     9.700    24.903     0.200
     9.700    24.102     0.200
     9.700    25.102     0.200
     1.068     6.196     0.200
     1.021     7.347     0.200
     1.166     7.492     0.200
     1.166     7.813     0.200
     1.166     7.711     0.200
     1.299     7.490     0.200
     1.471     9.176     0.200
     1.471     9.090     0.200
     2.044     9.035     0.200
     2.044     9.363     0.200
     3.763    13.296     0.200
     4.264    15.976     0.200
     4.264    16.952     0.200
     4.264    16.655     0.200
     4.478    13.560     0.200
     4.935    15.236     0.200
     4.935    15.724     0.200
     4.969    18.626     0.200
     4.969    18.024     0.200
     5.456    16.791     0.200
     5.456    18.041     0.200
     5.456    18.194     0.200
     6.808    21.484     0.200
     6.810    21.302     0.200
     6.810    21.842     0.200
     6.810    21.092     0.200
     6.810    21.288     0.200
     7.367    20.737     0.200
     7.370    20.864     0.200
     7.370    20.356     0.200
     7.370    20.183     0.200
     7.951    20.705     0.200
     7.951    25.334     0.200
     7.951    22.553     0.200
     8.151    26.000     0.200
     8.297    21.721     0.200
     8.297    24.491     0.200
     8.297    24.850     0.200
     8.556    25.422     0.200
     8.878    24.515     0.200
     9.129    26.583     0.200
     9.129    23.454     0.200
     9.129    25.872     0.200
     9.602    25.509     0.200
     9.602    25.657     0.200
     9.742    24.299     0.200
     9.745    23.968     0.200
     9.745    25.691     0.200
    10.838    28.833     0.200
    10.982    30.660     0.200
    11.971    29.566     0.200
    12.494    31.008     0.200
    12.891    31.233     0.200
    12.947    31.914     0.200
    12.947    31.347     0.200
    14.689    32.399     0.200
    14.689    36.899     0.200
    14.789    36.211     0.200
    16.704    37.834     0.200
    17.728    38.249     0.200
    19.478    41.605     0.200
     0.452     4.736     0.200
     0.414     5.146     0.200
     0.701     4.594     0.200
     0.692     4.849     0.200
     0.701     4.932     0.200
     0.733     6.154     0.200
     0.871     6.884     0.200
     1.041     5.441     0.200
     1.028     5.841     0.200
     1.098     6.057     0.200
     1.099     6.373     0.200
     1.099     5.951     0.200
     1.099     7.094     0.200
     1.533     8.402     0.200
     1.534     7.508     0.200
     1.982     9.186     0.200
     2.859     9.012     0.200
     3.166    11.026     0.200
     3.763    11.564     0.200
     4.335    12.353     0.200
     4.335    14.283     0.200
     4.866    15.243     0.200
     4.987    15.080     0.200
     4.987    18.080     0.200
     5.407    17.068     0.200
     6.742    22.097     0.200
     6.753    19.332     0.200
     6.755    19.467     0.200
     6.755    21.842     0.200
     6.755    21.511     0.200
     7.417    21.087     0.200
     9.676    25.154     0.200
     9.676    27.857     0.200
    11.969    32.189     0.200
    14.766    32.455     0.200
     0.218     6.886     0.200
     0.188     6.875     0.200
     0.281     7.147     0.200
     0.282     6.693     0.200
     0.431     5.905     0.200
     0.422     6.345     0.200
     0.693     5.949     0.200
     0.878     6.546     0.200
     0.876     7.279     0.200
     0.940     5.362     0.200
     1.167     6.235     0.200
     1.865     8.156     0.200
     1.866     8.466     0.200
     2.079     9.093     0.200
     4.683    13.623     0.200
     4.718    12.867     0.200
     6.821    17.946     0.200
     6.822    16.728     0.200
     6.822    18.774     0.200
     7.984    20.518     0.200
     8.344    22.664     0.200
    12.578    28.949     0.200
     0.031     5.919     0.200
     0.331     4.087     0.200
     0.440     5.004     0.200
     0.425     5.347     0.200
     0.689     4.756     0.200
     0.700     5.160     0.200
     0.703     4.556     0.200
     0.750     6.046     0.200
     0.887     6.832     0.200
     1.017     5.969     0.200
     1.037     5.403     0.200
     1.086     6.110     0.200
     1.086     6.379     0.200
     1.086     6.383     0.200
     1.086     5.876     0.200
     1.117     7.069     0.200
     1.549     8.200     0.200
     1.549     7.775     0.200
     1.550     7.753     0.200
     1.966     8.320     0.200
     1.966     8.813     0.200
     3.172    11.744     0.200
     3.172    12.041     0.200
     3.766    11.306     0.200
     3.766    11.103     0.200
     4.352    12.493     0.200
     4.352    13.665     0.200
     4.352    15.064     0.200
     4.849    14.263     0.200
     4.849    14.865     0.200
     4.994    16.079     0.200
     4.994    16.880     0.200
     5.394    15.835     0.200
     5.394    17.605     0.200
     6.739    18.195     0.200
     6.741    18.725     0.200
     6.741    21.994     0.200
     6.741    21.596     0.200
     6.741    21.206     0.200
     7.424    19.873     0.200
     7.883    22.980     0.200
     7.883    23.660     0.200
     8.231    22.982     0.200
     8.231    25.501     0.200
     9.657    20.962     0.200
     9.659    23.758     0.200
     9.659    23.531     0.200
     9.691    25.714     0.200
     9.691    26.367     0.200
     9.691    28.367     0.200
    10.901    30.744     0.200
    11.966    30.319     0.200
    11.966    30.787     0.200
    12.104    30.295     0.200
    14.782    31.952     0.200
    14.782    36.753     0.200
    14.840    34.272     0.200
     0.375     5.052     0.200
     0.525     4.844     0.200
     0.614     4.500     0.200
     0.738     5.208     0.200
     0.770     5.219     0.200
     0.760     6.345     0.200
     0.986     6.760     0.200
     1.053     5.461     0.200
     1.114     6.235     0.200
     1.170     6.922     0.200
     1.170     6.633     0.200
     1.170     6.427     0.200
     1.246     6.996     0.200
     1.426     7.778     0.200
     1.426     7.818     0.200
     2.089     8.680     0.200
     3.118    11.405     0.200
     3.118    12.405     0.200
     3.726    11.500     0.200
     4.222    12.947     0.200
     4.222    14.717     0.200
     4.479    14.025     0.200
     4.927    15.793     0.200
     4.927    17.293     0.200
     4.978    14.944     0.200
     5.503    17.559     0.200
     6.855    18.295     0.200
     6.856    17.461     0.200
     6.856    22.172     0.200
     6.857    20.857     0.200
     7.385    19.631     0.200
     7.385    20.701     0.200
     7.385    19.679     0.200
     7.997    20.483     0.200
     9.592    25.199     0.200
    12.009    32.558     0.200
    14.673    37.060     0.200
    14.742    34.166     0.200
    14.742    34.685     0.200
     0.743     4.647     0.200
     1.017     5.531     0.200
     1.586     8.838     0.200
     1.587     8.606     0.200
     1.935     8.168     0.200
     1.935     8.617     0.200
     1.935     9.117     0.200
     3.149    13.156     0.200
     3.149    13.054     0.200
     3.735    12.318     0.200
     4.400    15.285     0.200
     4.400    16.556     0.200
     4.400    16.056     0.200
     4.400    15.705     0.200
     4.807    15.595     0.200
     4.807    15.906     0.200
     4.631    13.762     0.200
     4.978    18.206     0.200
     5.379    17.793     0.200
     5.379    17.232     0.200
     6.715    20.844     0.200
     6.717    18.775     0.200
     6.717    21.314     0.200
     6.717    18.615     0.200
     6.717    22.275     0.200
     6.717    21.257     0.200
     7.471    20.020     0.200
     7.492    19.658     0.200
     7.492    20.568     0.200
     7.492    20.070     0.200
     7.862    20.504     0.200
     7.862    24.754     0.200
     7.862    24.094     0.200
     8.026    21.933     0.200
     8.282    23.349     0.200
     9.047    24.423     0.200
     9.614    21.682     0.200
     9.617    23.508     0.200
     9.768    25.458     0.200
     9.768    25.808     0.200
    10.990    32.546     0.200
    11.998    32.939     0.200
    11.980    29.792     0.200
    11.998    29.069     0.200
    12.169    30.889     0.200
    12.657    31.196     0.200
    12.907    31.549     0.200
    12.908    31.761     0.200
    14.847    34.165     0.200
    14.847    33.835     0.200
    14.847    35.515     0.200
    14.847    34.636     0.200
    14.858    36.403     0.200
    16.853    37.338     0.200
    17.849    36.584     0.200
    17.849    37.498     0.200
    17.849    38.304     0.200
    18.932    40.461     0.200
     0.433     4.549     0.200
     0.506     5.345     0.200
     0.654     5.565     0.200
     0.810     4.736     0.200
     0.965     6.921     0.200
     1.145     7.113     0.200
     1.373     8.439     0.200
     1.373     8.266     0.200
     1.373     8.436     0.200
     2.142     9.224     0.200
     3.046    12.923     0.200
     4.180    15.181     0.200
     4.180    15.381     0.200
     4.180    15.482     0.200
     4.180    16.131     0.200
     4.515    14.179     0.200
     4.515    12.880     0.200
     4.855    17.411     0.200
     4.855    17.711     0.200
     5.024    15.508     0.200
     5.566    17.394     0.200
     6.914    23.064     0.200
     6.915    20.593     0.200
     6.915    21.463     0.200
     6.915    22.973     0.200
     6.916    21.248     0.200
     7.438    19.158     0.200
     7.438    19.959     0.200
     7.438    20.034     0.200
     7.448    19.943     0.200
     8.019    21.783     0.200
     8.057    23.908     0.200
     8.073    24.856     0.200
     8.272    22.227     0.200
     8.404    24.977     0.200
     8.846    23.830     0.200
     9.612    24.318     0.200
     9.612    24.593     0.200
     9.612    23.893     0.200
    10.770    29.784     0.200
    10.896    30.511     0.200
    11.931    31.234     0.200
    12.080    31.605     0.200
    12.081    29.925     0.200
    12.449    30.384     0.200
    12.449    32.183     0.200
    12.512    29.948     0.200
    13.580    33.384     0.200
    14.683    34.112     0.200
    14.683    36.112     0.200
    14.675    34.580     0.200
    16.743    36.449     0.200
    16.743    36.669     0.200
     0.651     5.187     0.200
     0.928     7.363     0.200
     1.165     7.292     0.200
     1.285     7.518     0.200
     1.397     7.700     0.200
     1.340     7.585     0.200
     1.430     7.603     0.200
     1.576     8.288     0.200
     1.588     7.580     0.200
     1.588     8.400     0.200
     1.588     8.564     0.200
     1.588     8.429     0.200
     1.735     9.102     0.200
     1.930     9.081     0.200
     1.969     9.451     0.200
     1.877     9.072     0.200
     2.487    10.602     0.200
     3.178    12.652     0.200
     3.178    13.449     0.200
     3.766    12.577     0.200
     4.395    14.247     0.200
     4.395    15.739     0.200
     4.395    15.942     0.200
     4.594    14.019     0.200
     4.594    13.222     0.200
     4.808    15.232     0.200
     4.808    15.521     0.200
     5.004    17.131     0.200
     5.004    18.631     0.200
     5.366    17.095     0.200
     5.366    17.970     0.200
     6.706    21.310     0.200
     6.708    20.891     0.200
     6.708    19.852     0.200
     6.708    19.255     0.200
     7.453    21.519     0.200
     7.453    21.855     0.200
     7.453    21.793     0.200
     7.453    20.293     0.200
     7.852    22.434     0.200
     7.988    21.910     0.200
     8.200    23.830     0.200
     8.200    24.549     0.200
     8.244    22.528     0.200
     8.286    25.434     0.200
     8.444    23.188     0.200
     9.024    24.825     0.200
     9.024    24.028     0.200
     9.214    25.875     0.200
     9.616    21.294     0.200
     9.735    25.723     0.200
    10.600    29.037     0.200
    10.983    29.665     0.200
    10.934    32.038     0.200
    11.966    31.104     0.200
    11.948    31.222     0.200
    12.100    30.925     0.200
    12.627    30.576     0.200
    12.623    31.026     0.200
    12.817    31.852     0.200
    13.726    31.947     0.200
    14.864    34.208     0.200
    14.864    36.465     0.200
    14.864    33.731     0.200
    14.829    33.182     0.200
    14.829    36.682     0.200
    15.269    35.242     0.200
    16.816    37.640     0.200
    16.816    38.492     0.200
    17.850    38.390     0.200
    17.850    37.022     0.200
    18.894    44.543     0.200
    20.800    39.659     0.200
     0.394     5.176     0.200
     0.476     4.891     0.200
     0.675     4.735     0.200
     0.702     5.176     0.200
     0.724     4.835     0.200
     0.703     5.995     0.200
     0.843     6.876     0.200
     1.046     6.103     0.200
     1.050     5.562     0.200
     1.123     6.451     0.200
     1.123     6.911     0.200
     1.123     6.611     0.200
     1.507     8.130     0.200
     1.507     8.196     0.200
     2.008     8.554     0.200
     2.008     9.184     0.200
     3.160    12.443     0.200
     3.160    13.143     0.200
     3.760    12.139     0.200
     3.760    11.939     0.200
     4.306    12.733     0.200
     4.306    15.363     0.200
     4.306    15.763     0.200
     4.519    14.277     0.200
     4.895    14.845     0.200
     4.895    15.395     0.200
     4.977    17.138     0.200
     5.429    15.970     0.200
     5.429    17.661     0.200
     6.766    24.060     0.200
     6.777    19.998     0.200
     6.779    19.657     0.200
     6.779    20.807     0.200
     6.779    20.307     0.200
     6.779    20.704     0.200
     7.401    20.181     0.200
     7.401    20.022     0.200
     7.401    22.218     0.200
     7.920    21.844     0.200
     8.194    23.286     0.200
     9.648    26.742     0.200
     9.648    26.317     0.200
     9.648    27.517     0.200
    10.891    29.215     0.200
    11.973    32.892     0.200
    12.004    31.228     0.200
    12.581    29.591     0.200
    14.737    32.836     0.200
    14.737    37.336     0.200
    14.810    34.694     0.200
    20.703    38.213     0.200
     0.358     3.842     0.200
     0.425     4.561     0.200
     0.443     5.307     0.200
     0.673     4.501     0.200
     0.684     5.229     0.200
     0.742     4.728     0.200
     0.785     6.115     0.200
     0.979     6.062     0.200
     0.933     6.873     0.200
     1.044     5.446     0.200
     1.066     5.984     0.200
     1.161     7.213     0.200
     1.263     7.443     0.200
     1.595     8.262     0.200
     1.595     8.260     0.200
     3.199    12.042     0.200
     3.199    12.241     0.200
     3.789    11.457     0.200
     3.789    10.957     0.200
     5.024    17.539     0.200
     5.024    18.636     0.200
     6.697    20.862     0.200
     7.430    18.563     0.200
     0.414     5.057     0.200
     0.451     4.780     0.200
     0.700     4.932     0.200
     0.723     4.999     0.200
     1.056     5.906     0.200
     1.096     6.362     0.200
     1.095     6.124     0.200
     1.125     7.231     0.200
     1.565     7.963     0.200
     1.565     8.416     0.200
     1.565     8.421     0.200
     1.950     8.881     0.200
     1.950     9.522     0.200
     3.193    11.616     0.200
     3.193    12.116     0.200
     3.787    11.981     0.200
     4.365    14.656     0.200
     4.365    15.637     0.200
     4.365    15.535     0.200
     4.365    14.957     0.200
     4.545    13.640     0.200
     4.545    13.140     0.200
     4.836    15.569     0.200
     4.836    16.448     0.200
     4.836    15.827     0.200
     5.015    16.655     0.200
     5.015    17.252     0.200
     5.375    17.611     0.200
     5.375    18.048     0.200
     5.375    18.298     0.200
     6.723    20.354     0.200
     6.723    22.623     0.200
     6.723    19.725     0.200
     6.723    22.002     0.200
     7.409    22.612     0.200
     7.409    20.287     0.200
     7.409    20.630     0.200
     7.409    18.009     0.200
     8.212    24.938     0.200
     8.253    23.161     0.200
     9.643    23.171     0.200
     9.646    25.615     0.200
     9.686    25.548     0.200
     9.686    24.947     0.200
    10.950    29.490     0.200
    12.628    30.813     0.200
    12.628    32.313     0.200
    14.779    33.102     0.200
    14.779    36.500     0.200
    14.860    31.988     0.200
    14.860    34.429     0.200
    14.860    34.296     0.200
    20.757    38.839     0.200
     1.062     5.994     0.200
     1.098     6.232     0.200
     1.098     5.943     0.200
     1.098     6.318     0.200
     1.129     7.222     0.200
     1.257     7.803     0.200
     1.572     8.166     0.200
     1.572     7.761     0.200
     1.572     8.214     0.200
     1.943     8.543     0.200
     1.943     9.230     0.200
     3.201    12.103     0.200
     3.201    12.403     0.200
     3.795    11.772     0.200
     3.795    12.068     0.200
     4.371    15.557     0.200
     4.371    15.448     0.200
     4.543    13.843     0.200
     4.829    15.207     0.200
     4.829    14.926     0.200
     5.023    16.941     0.200
     5.023    17.140     0.200
     5.368    17.645     0.200
     5.368    18.016     0.200
     6.714    18.347     0.200
     6.716    17.759     0.200
     6.716    18.240     0.200
     7.405    18.133     0.200
     7.405    19.697     0.200
     7.858    24.149     0.200
     8.205    21.224     0.200
     9.685    23.360     0.200
     9.685    25.134     0.200
    10.955    29.806     0.200
    12.636    31.299     0.200
    14.780    33.175     0.200
    14.780    36.577     0.200
    14.868    33.799     0.200
    14.868    35.174     0.200
    16.765    35.155     0.200
     1.084     6.099     0.200
     1.074     7.085     0.200
     1.652     8.626     0.200
     1.652     8.494     0.200
     1.652     8.674     0.200
     1.863     9.333     0.200
     2.219     8.459     0.200
     2.930     9.856     0.200
     2.930     9.556     0.200
     3.254    12.471     0.200
     3.841    12.523     0.200
     4.450    13.103     0.200
     4.450    18.013     0.200
     4.450    15.013     0.200
     4.450    15.123     0.200
     4.570    17.612     0.200
     4.570    14.612     0.200
     4.750    15.282     0.200
     4.750    16.722     0.200
     4.750    15.673     0.200
     5.082    17.142     0.200
     5.082    18.142     0.200
     5.292    18.073     0.200
     5.292    18.893     0.200
     6.535    21.686     0.200
     6.636    19.632     0.200
     6.637    22.361     0.200
     6.637    23.091     0.200
     6.637    21.391     0.200
     6.638    22.201     0.200
     7.377    22.656     0.200
     7.408    20.514     0.200
     7.407    20.005     0.200
     7.780    24.185     0.200
     7.780    23.875     0.200
     7.930    23.707     0.200
     8.128    23.837     0.200
     8.128    26.397     0.200
     8.128    24.907     0.200
     8.186    24.217     0.200
     8.337    27.254     0.200
     9.560    23.858     0.200
     9.728    25.622     0.200
     9.728    26.422     0.200
     9.728    25.122     0.200
    10.894    31.813     0.200
    11.034    32.082     0.200
    11.034    31.682     0.200
    12.115    33.566     0.200
    12.704    31.494     0.200
    14.831    37.068     0.200
    14.940    36.318     0.200
    14.940    34.023     0.200
    15.345    34.869     0.200
    17.912    36.821     0.200
    20.829    38.736     0.200
    20.829    39.176     0.200
     0.570     4.866     0.200
     0.578     4.500     0.200
     0.589     5.734     0.200
     0.701     6.230     0.200
     0.812     5.190     0.200
     0.924     6.805     0.200
     1.065     5.584     0.200
     1.162     6.391     0.200
     1.212     7.097     0.200
     1.193     7.328     0.200
     1.368     8.132     0.200
     1.368     7.710     0.200
     2.147     8.958     0.200
     3.094    11.739     0.200
     3.709    12.161     0.200
     3.709    11.861     0.200
     4.161    13.689     0.200
     4.161    13.587     0.200
     4.444    14.784     0.200
     4.444    13.186     0.200
     4.896    16.707     0.200
     4.896    18.707     0.200
     5.039    15.882     0.200
     5.554    17.336     0.200
     6.909    22.504     0.200
     6.911    21.482     0.200
     6.911    19.392     0.200
     6.912    22.049     0.200
     7.368    17.861     0.200
     7.368    21.460     0.200
     9.546    25.344     0.200
    14.621    32.012     0.200
    17.625    37.537     0.200
    17.625    34.869     0.200
     0.154     4.036     0.200
     0.287     4.427     0.200
     0.390     4.818     0.200
     0.390     4.670     0.200
     0.390     4.541     0.200
     0.390     4.951     0.200
     0.342     4.053     0.200
     0.408     4.323     0.200
     0.585     4.171     0.200
     0.786     6.726     0.200
     0.860     6.009     0.200
     0.834     4.184     0.200
     1.119     5.716     0.200
     1.188     6.923     0.200
     1.250     7.175     0.200
     1.766     7.889     0.200
     1.767     8.931     0.200
     1.767     7.880     0.200
     2.104     8.220     0.200
     2.104     9.092     0.200
     2.719    10.264     0.200
     3.230     9.899     0.200
     4.584    14.805     0.200
     4.584    15.805     0.200
     4.590    14.827     0.200
     4.590    15.436     0.200
     4.782    13.973     0.200
     4.782    14.242     0.200
     5.303    16.406     0.200
     5.607    16.547     0.200
     6.863    18.796     0.200
     6.864    18.049     0.200
     6.864    19.904     0.200
     6.740    20.438     0.200
     8.024    20.231     0.200
     8.156    23.420     0.200
     8.188    20.557     0.200
     8.188    23.748     0.200
     8.187    20.398     0.200
     8.187    21.949     0.200
     8.383    20.904     0.200
     8.503    24.072     0.200
     8.503    26.771     0.200
     8.702    24.042     0.200
     9.520    27.000     0.200
     9.949    25.695     0.200
    10.385    27.175     0.200
    10.385    26.902     0.200
    10.385    29.300     0.200
    11.666    30.548     0.200
    12.549    31.053     0.200
    12.533    29.251     0.200
    13.254    29.029     0.200
    13.254    31.017     0.200
    13.294    32.258     0.200
    14.607    31.100     0.200
    14.607    30.857     0.200
    14.607    32.440     0.200
    15.246    31.184     0.200
    15.428    33.853     0.200
    15.428    35.353     0.200
    17.903    37.151     0.200
    19.590    37.035     0.200
     0.212     6.688     0.200
     0.196     6.639     0.200
     0.272     6.949     0.200
     0.273     7.081     0.200
     0.432     5.704     0.200
     0.431     6.248     0.200
     0.703     5.848     0.200
     0.878     6.632     0.200
     0.885     7.319     0.200
     0.949     5.407     0.200
     1.169     6.337     0.200
     1.291     7.441     0.200
     1.367     7.600     0.200
     1.439     6.867     0.200
     1.874     8.561     0.200
     1.873     8.477     0.200
     2.080     8.793     0.200
     2.731     9.833     0.200
     2.731    10.536     0.200
     3.221     9.609     0.200
     3.221    10.609     0.200
     4.598    13.853     0.200
     4.598    15.947     0.200
     4.690    16.173     0.200
     4.690    15.470     0.200
     4.715    12.887     0.200
     5.578    16.053     0.200
     6.819    18.652     0.200
     6.821    18.433     0.200
     6.821    19.355     0.200
     7.982    21.434     0.200
     8.281    21.343     0.200
     8.281    22.241     0.200
     8.343    21.828     0.200
    10.503    27.942     0.200
    12.583    29.714     0.200
     0.483     5.210     0.200
     0.626     5.521     0.200
     0.729     5.359     0.200
     0.682     6.180     0.200
     0.741     4.838     0.200
     1.028     6.238     0.200
     1.095     5.913     0.200
     1.029     7.524     0.200
     1.129     6.655     0.200
     1.129     6.968     0.200
     1.129     6.468     0.200
     1.129     6.922     0.200
     1.458     8.935     0.200
     1.458     8.702     0.200
     2.057     8.284     0.200
     2.057     9.136     0.200
     2.057     9.284     0.200
     2.125     8.539     0.200
     2.823     9.706     0.200
     3.117    12.465     0.200
     3.117    13.066     0.200
     3.721    12.620     0.200
     3.721    12.722     0.200
     4.260    15.762     0.200
     4.260    16.633     0.200
     4.260    16.133     0.200
     4.517    14.028     0.200
     4.942    15.420     0.200
     4.942    15.068     0.200
     4.942    16.170     0.200
     4.932    17.293     0.200
     5.479    16.823     0.200
     5.479    17.401     0.200
     5.479    17.800     0.200
     6.827    22.092     0.200
     6.829    21.661     0.200
     6.829    21.310     0.200
     7.415    18.755     0.200
     7.415    18.873     0.200
     7.415    20.889     0.200
     7.971    24.255     0.200
     7.971    22.536     0.200
     8.233    20.969     0.200
     8.233    24.372     0.200
     8.318    21.716     0.200
     8.318    25.173     0.200
     8.571    22.303     0.200
     8.897    24.714     0.200
     9.635    25.881     0.200
     9.635    25.104     0.200
     9.635    26.104     0.200
    10.881    32.459     0.200
    11.009    27.183     0.200
    12.012    32.608     0.200
    11.994    28.881     0.200
    12.012    28.908     0.200
    12.529    31.429     0.200
    12.932    35.132     0.200
    12.979    29.891     0.200
    14.717    37.198     0.200
    14.760    35.160     0.200
    14.760    35.558     0.200
    15.168    35.586     0.200
    15.599    34.973     0.200
    15.599    35.602     0.200
    15.867    35.572     0.200
    17.718    37.837     0.200
    17.718    37.076     0.200
    19.406    41.278     0.200
     0.387     4.896     0.200
     0.482     5.006     0.200
     0.680     4.756     0.200
     0.730     5.102     0.200
     0.695     5.197     0.200
     1.057     5.692     0.200
     1.041     6.383     0.200
     1.509     8.191     0.200
     2.006     9.361     0.200
     4.893    16.238     0.200
     7.917    25.312     0.200
     0.152     6.614     0.200
     0.254     6.275     0.200
     0.284     6.472     0.200
     0.285     6.517     0.200
     0.285     6.165     0.200
     0.285     6.673     0.200
     0.374     5.522     0.200
     0.479     6.230     0.200
     0.724     6.132     0.200
     0.816     6.442     0.200
     0.942     5.117     0.200
     1.116     6.159     0.200
     1.373     6.342     0.200
     1.367     7.699     0.200
     1.477     6.556     0.200
     1.854     8.102     0.200
     1.854     7.852     0.200
     1.855     7.841     0.200
     2.214     7.756     0.200
     2.142     8.673     0.200
     2.142     8.790     0.200
     2.142     8.938     0.200
     2.667    10.160     0.200
     2.667    10.058     0.200
     4.534    15.678     0.200
     4.663    14.260     0.200
     4.663    15.268     0.200
     4.663    15.369     0.200
     4.663    15.073     0.200
     4.663    14.362     0.200
     4.764    12.590     0.200
     4.764    12.794     0.200
     5.447    14.828     0.200
     5.639    16.158     0.200
     5.639    16.283     0.200
     5.639    16.478     0.200
     6.821    19.795     0.200
     6.877    19.073     0.200
     6.878    18.252     0.200
     6.878    18.620     0.200
     6.878    18.729     0.200
     6.878    18.706     0.200
     8.040    20.788     0.200
     8.040    21.514     0.200
     8.291    23.235     0.200
     8.328    22.226     0.200
     8.328    21.337     0.200
     8.401    20.896     0.200
     8.401    21.451     0.200
     8.575    23.619     0.200
     8.526    20.471     0.200
     8.526    21.392     0.200
     8.834    23.794     0.200
     9.092    24.488     0.200
     9.528    21.131     0.200
     9.637    26.824     0.200
    10.090    26.284     0.200
    10.090    26.441     0.200
    10.090    25.042     0.200
    10.980    28.251     0.200
    11.261    26.969     0.200
    11.218    25.002     0.200
    11.218    26.228     0.200
    11.809    27.875     0.200
    12.269    27.611     0.200
    12.648    29.997     0.200
    12.633    29.419     0.200
    12.998    29.700     0.200
    13.307    29.990     0.200
    13.307    29.623     0.200
    13.307    29.849     0.200
    13.434    31.117     0.200
    13.520    30.824     0.200
    13.520    31.012     0.200
    13.520    31.223     0.200
    13.528    32.247     0.200
    14.585    29.207     0.200
    14.585    32.887     0.200
    14.585    29.246     0.200
    14.509    32.568     0.200
    14.966    33.639     0.200
    15.183    33.248     0.200
    15.559    32.519     0.200
    15.559    34.417     0.200
    16.645    34.438     0.200
    17.675    34.374     0.200
    17.675    34.921     0.200
     1.045     5.746     0.200
     1.110     6.456     0.200
     1.159     7.201     0.200
     1.159     6.791     0.200
     1.159     6.490     0.200
     1.158     6.893     0.200
     1.158     6.522     0.200
     1.387     6.873     0.200
     1.340     7.730     0.200
     1.432     6.879     0.200
     1.433     7.185     0.200
     1.416     7.630     0.200
     1.535     7.348     0.200
     1.611     8.169     0.200
     1.574     8.301     0.200
     1.710     8.442     0.200
     1.681     8.664     0.200
     1.867     8.395     0.200
     1.906     9.113     0.200
     1.960     9.013     0.200
     2.081     9.301     0.200
     2.081     9.922     0.200
     2.081     8.903     0.200
     2.081     9.121     0.200
     2.181     8.586     0.200
     2.244    10.043     0.200
     2.374     7.859     0.200
     2.590    10.304     0.200
     2.747    10.557     0.200
     2.739    10.692     0.200
     2.755    11.183     0.200
     2.828     8.505     0.200
     2.828     9.403     0.200
     2.838     9.140     0.200
     3.116    11.643     0.200
     3.116    11.444     0.200
     3.322    11.617     0.200
     3.507    13.366     0.200
     3.846    12.532     0.200
     4.026    14.103     0.200
     4.231    14.689     0.200
     4.231    15.228     0.200
     4.231    14.431     0.200
     4.231    14.880     0.200
     4.326    14.672     0.200
     4.489    13.218     0.200
     4.499    15.305     0.200
     4.499    15.649     0.200
     4.758    16.643     0.200
     4.927    17.113     0.200
     4.969    15.361     0.200
     4.969    15.869     0.200
     5.333    18.325     0.200
     5.497    17.395     0.200
     5.497    18.157     0.200
     6.319    19.962     0.200
     6.367    20.122     0.200
     6.616    19.056     0.200
     6.850    21.642     0.200
     6.850    21.872     0.200
     6.850    20.970     0.200
     6.850    21.431     0.200
     6.850    20.733     0.200
     7.106    22.236     0.200
     7.138    20.742     0.200
     7.394    20.154     0.200
     7.394    19.622     0.200
     7.394    19.815     0.200
     7.394    20.276     0.200
     7.396    20.200     0.200
     7.964    21.578     0.200
     7.991    23.527     0.200
     7.991    23.355     0.200
     7.991    23.957     0.200
     8.120    24.148     0.200
     8.217    22.213     0.200
     8.224    24.649     0.200
     8.338    23.283     0.200
     8.338    23.911     0.200
     8.594    22.639     0.200
     8.594    23.420     0.200
     8.864    23.667     0.200
     9.152    23.512     0.200
     9.152    24.211     0.200
     9.152    24.809     0.200
     9.152    25.270     0.200
     9.604    24.510     0.200
     9.604    24.736     0.200
     9.777    24.471     0.200
     9.779    22.657     0.200
     9.779    24.985     0.200
    10.432    28.972     0.200
    10.817    27.977     0.200
    10.817    26.676     0.200
    10.858    27.499     0.200
    11.024    29.279     0.200
    11.024    29.662     0.200
    12.011    30.744     0.200
    12.083    31.506     0.200
    12.521    30.190     0.200
    12.499    30.149     0.200
    12.796    33.780     0.200
    12.932    34.078     0.200
    12.932    33.696     0.200
    14.685    34.943     0.200
    14.685    32.540     0.200
    14.746    32.727     0.200
    14.746    33.426     0.200
    14.746    32.637     0.200
    14.746    33.254     0.200
    15.154    32.921     0.200
    15.154    33.663     0.200
    15.154    32.163     0.200
    15.154    33.522     0.200
    15.630    31.736     0.200
    16.717    36.617     0.200
    16.717    36.839     0.200
    17.692    36.938     0.200
    19.058    38.910     0.200
    19.420    39.177     0.200
    19.521    37.198     0.200
     0.532     4.946     0.200
     0.622     4.755     0.200
     0.632     5.761     0.200
     0.728     5.339     0.200
     0.778     5.315     0.200
     0.984     7.040     0.200
     1.063     5.858     0.200
     1.108     6.591     0.200
     1.178     7.090     0.200
     1.178     6.801     0.200
     1.178     6.806     0.200
     1.429     8.430     0.200
     1.429     8.458     0.200
     2.086     8.859     0.200
     2.086     9.406     0.200
     2.150     8.165     0.200
     2.842     9.487     0.200
     3.127    12.560     0.200
     4.223    13.966     0.200
     4.470    14.491     0.200
     4.935    17.358     0.200
     4.977    15.947     0.200
     5.498    17.955     0.200
     6.850    20.368     0.200
     6.852    21.835     0.200
     6.852    20.686     0.200
     6.853    22.457     0.200
     7.375    18.032     0.200
     7.375    22.483     0.200
     7.993    22.020     0.200
     8.339    23.276     0.200
     9.585    25.398     0.200
    11.022    25.042     0.200
    11.999    32.109     0.200
    14.666    35.196     0.200
    14.749    36.385     0.200
    14.749    35.768     0.200
    14.749    33.795     0.200
    17.686    37.274     0.200
     0.356     5.123     0.200
     0.533     4.959     0.200
     0.639     4.388     0.200
     0.635     5.712     0.200
     0.712     5.073     0.200
     0.779     5.027     0.200
     0.779     6.320     0.200
     0.995     6.813     0.200
     1.073     5.398     0.200
     1.091     6.088     0.200
     1.179     6.610     0.200
     1.268     6.913     0.200
     1.445     7.694     0.200
     2.163     7.715     0.200
     2.856     8.922     0.200
     3.143    10.976     0.200
     3.751    11.776     0.200
     4.238    15.005     0.200
     6.836    20.239     0.200
     0.513     5.009     0.200
     0.759     5.270     0.200
     0.728     5.228     0.200
     1.005     6.609     0.200
     1.052     5.770     0.200
     1.098     6.525     0.200
     2.144     7.925     0.200
     2.839     9.218     0.200
     3.128    10.944     0.200
     3.735    11.863     0.200
    17.703    37.619     0.200
     0.181     6.692     0.200
     0.256     6.891     0.200
     0.257     6.925     0.200
     0.227     6.247     0.200
     0.419     5.580     0.200
     0.463     5.927     0.200
     0.728     5.718     0.200
     0.861     6.543     0.200
     0.916     7.328     0.200
     0.965     4.981     0.200
     1.160     6.089     0.200
     1.322     7.307     0.200
     1.415     6.627     0.200
     1.386     7.377     0.200
     1.518     6.733     0.200
     1.884     8.204     0.200
     1.884     8.462     0.200
     1.885     8.428     0.200
     2.098     8.248     0.200
     2.255     7.327     0.200
     2.255     7.429     0.200
     2.441     9.961     0.200
     2.711    10.006     0.200
     3.198    10.034     0.200
     4.578    15.321     0.200
     4.578    15.219     0.200
     4.721    12.867     0.200
     4.697    13.043     0.200
     4.697    15.332     0.200
     5.595    14.131     0.200
     6.832    15.957     0.200
     6.834    19.485     0.200
     7.996    18.891     0.200
     8.312    23.786     0.200
    12.611    32.164     0.200
     0.133     7.012     0.200
     0.291     6.754     0.200
     0.274     6.183     0.200
     0.357     5.589     0.200
     0.496     6.127     0.200
     0.732     5.983     0.200
     0.797     6.493     0.200
     0.942     4.805     0.200
     0.943     7.596     0.200
     1.100     6.057     0.200
     1.352     6.533     0.200
     1.345     7.597     0.200
     1.368     7.539     0.200
     1.456     6.635     0.200
     2.193     7.233     0.200
     2.377    10.479     0.200
     2.647    10.432     0.200
     2.647    10.729     0.200
     3.135    10.837     0.200
     4.514    15.543     0.200
     4.514    15.145     0.200
     6.897    18.391     0.200
     8.344    21.256     0.200
    12.669    32.517     0.200
     1.092     7.729     0.200
     1.427     8.902     0.200
     1.428     8.922     0.200
     2.340     8.846     0.200
     2.340     8.546     0.200
     2.349    10.640     0.200
     2.685    11.421     0.200
     2.685    10.819     0.200
     3.256    11.459     0.200
     3.256    11.658     0.200
     4.265    15.490     0.200
     4.265    16.389     0.200
     4.529    17.997     0.200
     4.529    15.399     0.200
     7.040    18.879     0.200
    12.479    32.709     0.200
     0.560     4.889     0.200
     0.598     4.238     0.200
     0.600     5.638     0.200
     0.745     5.241     0.200
     0.803     5.123     0.200
     0.725     6.086     0.200
     0.945     6.519     0.200
     1.069     5.369     0.200
     1.140     6.325     0.200
     1.203     6.631     0.200
     1.204     6.684     0.200
     1.216     6.875     0.200
     1.391     7.734     0.200
     1.392     7.593     0.200
     1.392     7.753     0.200
     2.123     9.055     0.200
     2.145     7.464     0.200
     2.736    11.463     0.200
     2.776    11.294     0.200
     2.833     9.033     0.200
     2.833     9.330     0.200
     3.111    11.196     0.200
     3.111    11.298     0.200
     3.724    11.739     0.200
     4.184    13.747     0.200
     4.184    15.770     0.200
     4.915    17.742     0.200
     4.915    16.742     0.200
     5.015    14.846     0.200
     6.886    19.248     0.200
     6.888    18.957     0.200
     6.888    21.594     0.200
     7.365    20.373     0.200
     7.365    20.120     0.200
     8.027    19.669     0.200
     8.635    22.070     0.200
     9.556    24.300     0.200
     9.556    24.476     0.200
     9.823    22.667     0.200
     9.825    23.071     0.200
    11.053    28.343     0.200
    12.014    28.797     0.200
    14.718    34.939     0.200
    17.648    37.785     0.200
     0.175     6.925     0.200
     0.232     6.438     0.200
     0.265     7.027     0.200
     0.265     7.086     0.200
     0.407     5.761     0.200
     0.465     6.203     0.200
     0.725     6.286     0.200
     0.850     6.698     0.200
     0.917     7.404     0.200
     0.957     5.138     0.200
     1.149     6.250     0.200
     1.508     6.602     0.200
     1.875     8.316     0.200
     1.876     8.565     0.200
     2.109     8.123     0.200
     2.246     7.397     0.200
     2.430    10.048     0.200
     2.701    11.388     0.200
     2.701     9.489     0.200
     3.188    10.602     0.200
     4.567    16.102     0.200
     4.567    13.002     0.200
     4.687    15.606     0.200
     4.687    15.405     0.200
     4.733    12.684     0.200
     6.828    19.218     0.200
     6.844    19.604     0.200
     6.845    19.819     0.200
     6.845    18.603     0.200
     8.007    21.541     0.200
     8.314    22.077     0.200
     8.599    23.653     0.200
     9.650    26.391     0.200
    10.525    27.101     0.200
    10.525    28.376     0.200
    10.525    26.276     0.200
    11.798    29.720     0.200
    11.798    29.820     0.200
    12.619    29.795     0.200
    12.619    30.440     0.200
     0.179     6.696     0.200
     0.270     6.815     0.200
     0.269     6.804     0.200
     0.227     6.327     0.200
     0.407     5.602     0.200
     0.459     6.068     0.200
     0.719     5.897     0.200
     0.850     6.559     0.200
     0.952     5.059     0.200
     1.148     6.157     0.200
     1.316     7.540     0.200
     1.407     6.610     0.200
     1.374     7.445     0.200
     1.510     6.904     0.200
     1.871     8.339     0.200
     1.872     8.512     0.200
     2.108     8.770     0.200
     2.248     7.698     0.200
     2.248     8.198     0.200
     2.430    10.670     0.200
     2.702    10.003     0.200
     2.702    10.503     0.200
     3.190    10.606     0.200
     3.190    10.805     0.200
     4.569    15.716     0.200
     4.569    15.216     0.200
     4.734    12.638     0.200
     6.844    18.129     0.200
     6.845    17.376     0.200
     8.007    19.646     0.200
     8.368    21.276     0.200
     0.154     6.945     0.200
     0.257     6.508     0.200
     0.306     6.798     0.200
     0.307     7.058     0.200
     0.307     6.788     0.200
     0.356     5.571     0.200
     0.474     6.399     0.200
     0.709     6.198     0.200
     0.800     6.497     0.200
     0.921     5.039     0.200
     0.920     7.833     0.200
     1.096     6.076     0.200
     1.322     7.766     0.200
     1.347     7.472     0.200
     1.362     6.429     0.200
     1.466     6.766     0.200
     1.832     8.537     0.200
     1.833     7.951     0.200
     1.833     8.576     0.200
     2.158     8.852     0.200
     2.158     9.192     0.200
     2.158     9.042     0.200
     2.203     6.962     0.200
     2.203     7.261     0.200
     2.275     8.525     0.200
     2.380     9.802     0.200
     2.653     9.514     0.200
     3.145    10.474     0.200
     4.520    14.029     0.200
     4.641    13.082     0.200
     4.641    16.012     0.200
     4.641    15.212     0.200
     4.785    12.755     0.200
     4.785    13.035     0.200
     5.435    14.848     0.200
     5.656    16.470     0.200
     6.895    19.013     0.200
     6.897    18.728     0.200
     6.897    19.288     0.200
     6.897    18.089     0.200
     6.897    18.969     0.200
     6.897    18.851     0.200
     8.058    19.671     0.200
     8.058    21.231     0.200
     8.058    21.431     0.200
     8.321    19.490     0.200
     8.321    22.560     0.200
     8.321    19.972     0.200
     8.321    21.536     0.200
     8.419    20.542     0.200
     8.419    23.221     0.200
     8.553    23.463     0.200
     9.550    21.127     0.200
     9.617    26.641     0.200
    12.654    30.198     0.200
    13.321    29.991     0.200
    14.567    32.076     0.200
    17.920    36.141     0.200
     0.727     4.950     0.200
     1.036     5.983     0.200
     1.066     5.892     0.200
     1.151     7.259     0.200
     1.581     8.592     0.200
     1.581     8.594     0.200
     1.935     8.657     0.200
     2.161     7.953     0.200
     2.869     9.892     0.200
     4.386    15.989     0.200
     4.386    15.588     0.200
     4.816    14.471     0.200
     5.011    19.591     0.200
     5.011    17.492     0.200
     5.367    16.381     0.200
     6.709    18.953     0.200
     6.711    19.201     0.200
     6.711    18.759     0.200
     6.711    17.214     0.200
     7.854    21.771     0.200
    14.865    35.443     0.200
    14.865    35.592     0.200
    14.865    34.574     0.200
    19.301    38.128     0.200
     0.741     6.536     0.200
     1.020     6.377     0.200
     1.429     6.881     0.200
     1.744     8.400     0.200
     1.744     9.210     0.200
     1.745     9.224     0.200
     2.165     7.691     0.200
     2.165     7.892     0.200
     2.218     9.829     0.200
     2.218    10.429     0.200
     2.223     9.815     0.200
     2.316    10.532     0.200
     2.599    10.933     0.200
     3.104    12.434     0.200
     3.104    11.934     0.200
     4.464    15.061     0.200
     4.551    13.546     0.200
     4.551    15.546     0.200
     4.866    14.229     0.200
     4.866    14.529     0.200
     5.383    19.037     0.200
     5.383    18.338     0.200
     5.719    18.324     0.200
     6.966    19.797     0.200
     6.967    19.602     0.200
     6.967    19.751     0.200
     6.967    20.071     0.200
     6.967    19.761     0.200
     6.967    20.289     0.200
     8.128    22.162     0.200
     8.128    22.962     0.200
     8.291    23.302     0.200
     8.291    24.446     0.200
     8.488    23.411     0.200
     8.488    25.061     0.200
     8.463    26.197     0.200
     9.634    22.209     0.200
    10.869    27.121     0.200
    11.150    30.843     0.200
    12.190    30.700     0.200
    12.677    32.224     0.200
    13.374    32.858     0.200
    14.499    34.329     0.200
    15.295    32.747     0.200
    15.467    36.259     0.200
     0.176     6.892     0.200
     0.262     7.070     0.200
     0.231     6.491     0.200
     0.410     5.680     0.200
     0.465     6.198     0.200
     0.726     6.057     0.200
     0.852     6.620     0.200
     0.917     7.647     0.200
     0.959     5.170     0.200
     1.151     6.178     0.200
     1.322     7.711     0.200
     1.381     7.576     0.200
     1.510     6.969     0.200
     1.877     9.186     0.200
     1.878     8.825     0.200
     2.107     9.205     0.200
     2.247     7.265     0.200
     2.324     9.272     0.200
     2.432    10.209     0.200
     2.703    10.452     0.200
     2.703     9.952     0.200
     4.570    15.365     0.200
     4.570    14.265     0.200
     4.690    15.144     0.200
     4.690    17.564     0.200
     4.690    14.765     0.200
     4.730    13.052     0.200
     5.604    15.247     0.200
     6.842    18.241     0.200
     6.843    18.366     0.200
     6.843    17.538     0.200
     8.005    20.728     0.200
     8.366    21.335     0.200
    14.621    34.854     0.200
     0.319     5.501     0.200
     0.357     5.469     0.200
     0.539     5.768     0.200
     0.546     5.284     0.200
     0.720     5.156     0.200
     0.926     5.949     0.200
     0.926     5.872     0.200
     0.956     5.624     0.200
     1.078     5.211     0.200
     1.052     5.762     0.200
     1.144     5.597     0.200
     1.281     6.233     0.200
     1.420     6.282     0.200
     1.785     7.314     0.200
     1.925     8.354     0.200
     1.925     8.675     0.200
     1.927     8.683     0.200
     1.902     7.948     0.200
     2.063     8.968     0.200
     2.286     9.460     0.200
     2.539     9.977     0.200
     4.149    15.322     0.200
     4.149    14.223     0.200
     4.633    15.171     0.200
     5.026    14.240     0.200
     6.014    17.253     0.200
     7.211    19.853     0.200
     7.212    18.900     0.200
     7.212    19.868     0.200
     8.376    21.650     0.200
     8.748    23.578     0.200
    11.592    27.892     0.200
    13.109    31.823     0.200
    14.250    33.447     0.200
     0.174     6.784     0.200
     0.231     6.488     0.200
     0.305     6.677     0.200
     0.403     6.379     0.200
     0.424     5.781     0.200
     0.668     6.030     0.200
     0.855     7.289     0.200
     0.873     6.536     0.200
     0.916     5.325     0.200
     1.156     6.088     0.200
     1.260     7.343     0.200
     1.334     7.443     0.200
     1.443     6.766     0.200
     1.548     6.978     0.200
     1.843     8.734     0.200
     1.844     8.670     0.200
     2.285     7.477     0.200
     2.352     9.291     0.200
     2.451    10.736     0.200
     2.729    10.290     0.200
     2.729    10.189     0.200
     4.596    13.206     0.200
     4.596    14.612     0.200
     6.831    17.594     0.200
     0.170     7.107     0.200
     0.237     6.864     0.200
     0.317     7.014     0.200
     0.316     6.953     0.200
     0.395     6.552     0.200
     0.421     5.951     0.200
     0.658     5.992     0.200
     0.846     7.093     0.200
     0.871     6.467     0.200
     0.906     5.299     0.200
     1.151     6.390     0.200
     1.251     7.280     0.200
     1.323     7.488     0.200
     1.548     7.223     0.200
     1.833     8.516     0.200
     1.834     9.159     0.200
     2.086     8.431     0.200
     2.285     7.721     0.200
     2.448    10.226     0.200
     2.728    10.760     0.200
     2.728    10.359     0.200
     4.594    14.581     0.200
     4.653    15.689     0.200
     4.653    14.789     0.200
     4.738    12.654     0.200
     5.587    16.002     0.200
     6.835    19.427     0.200
     7.996    20.544     0.200
     8.244    22.913     0.200
    12.568    30.645     0.200
    17.668    34.917     0.200
     0.169     7.010     0.200
     0.237     6.513     0.200
     0.287     7.011     0.200
     0.287     6.970     0.200
     0.287     7.220     0.200
     0.385     5.754     0.200
     0.462     6.243     0.200
     0.711     6.033     0.200
     0.829     6.649     0.200
     0.912     7.541     0.200
     0.936     5.039     0.200
     1.125     6.223     0.200
     1.315     7.524     0.200
     1.360     7.458     0.200
     1.389     6.716     0.200
     1.493     6.897     0.200
     1.852     7.499     0.200
     1.852     9.401     0.200
     1.852     8.901     0.200
     1.853     9.414     0.200
     2.129     8.732     0.200
     2.129     8.873     0.200
     2.230     7.492     0.200
     2.303     9.136     0.200
     2.409    10.103     0.200
     2.681     9.922     0.200
     2.681    10.524     0.200
     4.548    14.738     0.200
     4.548    13.637     0.200
     4.663    12.921     0.200
     4.663    15.093     0.200
     4.663    14.292     0.200
     4.756    12.619     0.200
     4.756    13.010     0.200
     4.814    16.634     0.200
     5.432    15.921     0.200
     5.627    15.702     0.200
     6.866    18.128     0.200
     6.867    18.151     0.200
     6.867    18.272     0.200
     6.867    18.003     0.200
     6.867    17.882     0.200
     6.867    18.448     0.200
     8.029    20.817     0.200
     8.029    20.286     0.200
     8.311    22.233     0.200
     8.390    21.678     0.200
     8.390    21.517     0.200
     8.575    24.038     0.200
     9.522    21.115     0.200
     9.630    26.130     0.200
    10.979    28.192     0.200
    11.793    29.690     0.200
    12.282    28.587     0.200
    12.282    28.388     0.200
    12.630    30.069     0.200
    13.113    28.681     0.200
    13.292    29.916     0.200
    13.421    31.985     0.200
    13.511    31.531     0.200
    14.597    33.873     0.200
    14.597    30.763     0.200
    14.597    31.673     0.200
    14.978    29.925     0.200
     0.564     5.266     0.200
     0.612     5.490     0.200
     0.677     5.027     0.200
     0.812     5.490     0.200
     0.790     6.308     0.200
     0.989     6.732     0.200
     1.068     6.248     0.200
     1.113     5.969     0.200
     1.211     7.000     0.200
     1.211     7.488     0.200
     1.458     8.873     0.200
     1.458     8.892     0.200
     2.202     8.103     0.200
     2.843    11.230     0.200
     2.895     9.317     0.200
     3.179    12.811     0.200
     3.179    12.413     0.200
     4.242    15.301     0.200
     4.432    14.476     0.200
     4.985    17.023     0.200
     4.985    16.422     0.200
     5.461    17.736     0.200
     5.461    17.854     0.200
     6.817    21.489     0.200
     6.819    21.428     0.200
     6.819    20.827     0.200
     6.819    22.319     0.200
     6.819    22.956     0.200
     6.819    22.331     0.200
     7.328    22.668     0.200
     8.125    25.085     0.200
     8.125    22.881     0.200
    10.822    28.411     0.200
    11.947    31.634     0.200
    12.016    29.876     0.200
    14.645    37.100     0.200
    14.645    33.100     0.200
    14.791    36.618     0.200
    17.711    37.829     0.200
    17.711    37.219     0.200
    17.711    37.321     0.200
     0.079     5.471     0.200
     0.320     4.062     0.200
     0.389     5.114     0.200
     0.484     5.117     0.200
     0.665     4.492     0.200
     0.732     4.886     0.200
     0.707     5.030     0.200
     0.692     5.788     0.200
     0.829     6.589     0.200
     1.051     5.332     0.200
     1.056     5.932     0.200
     1.054     6.969     0.200
     1.131     6.187     0.200
     1.311     6.906     0.200
     1.494     8.394     0.200
     1.494     7.968     0.200
     1.494     7.934     0.200
     2.813    10.173     0.200
     2.855     8.582     0.200
     3.153    10.797     0.200
     4.292    14.059     0.200
     4.292    15.008     0.200
     4.969    14.409     0.200
     7.397    19.255     0.200
    11.978    31.069     0.200
    14.800    34.328     0.200
    17.753    37.014     0.200
    19.367    39.492     0.200
    20.689    38.350     0.200
    20.689    38.756     0.200
     0.121     7.367     0.200
     0.284     6.280     0.200
     0.361     5.752     0.200
     0.278     7.131     0.200
     0.509     6.198     0.200
     0.748     6.018     0.200
     0.798     6.724     0.200
     0.956     5.258     0.200
     0.957     7.858     0.200
     1.106     6.218     0.200
     1.349     6.802     0.200
     1.383     7.707     0.200
     1.360     7.782     0.200
     1.452     6.590     0.200
     1.863     7.751     0.200
     2.189     8.085     0.200
     2.162     9.055     0.200
     2.646     8.846     0.200
     6.894    17.870     0.200
     8.056    19.887     0.200
     0.189     6.854     0.200
     0.182     6.763     0.200
     0.479     6.261     0.200
     0.480     6.032     0.200
     0.541     5.829     0.200
     0.540     6.532     0.200
     0.728     6.292     0.200
     0.868     5.356     0.200
     0.885     6.193     0.200
     0.956     5.252     0.200
     1.072     6.272     0.200
     1.144     8.319     0.200
     1.176     6.016     0.200
     1.783     7.493     0.200
     1.784     7.517     0.200
     1.913     6.911     0.200
     2.117     9.335     0.200
     2.374     9.131     0.200
     2.374     9.432     0.200
     2.435     9.485     0.200
     4.241    14.843     0.200
     4.344    14.440     0.200
     4.537    17.294     0.200
     7.151    20.320     0.200
     7.151    18.974     0.200
     8.440    24.344     0.200
    10.872    26.858     0.200
    12.942    32.185     0.200
     0.369     5.490     0.200
     0.377     5.501     0.200
     0.511     5.711     0.200
     0.596     5.104     0.200
     0.596     5.205     0.200
     0.768     5.132     0.200
     0.907     5.593     0.200
     0.902     5.805     0.200
     0.971     6.118     0.200
     1.002     5.672     0.200
     1.112     5.302     0.200
     1.377     6.214     0.200
     1.579     7.692     0.200
     1.592     7.902     0.200
     1.734     6.529     0.200
     1.924     8.593     0.200
     1.926     8.568     0.200
     2.019     9.397     0.200
     2.239     8.641     0.200
     2.590     9.974     0.200
     4.100    14.710     0.200
     4.100    13.913     0.200
     4.202    13.929     0.200
     4.617    14.578     0.200
     7.257    20.090     0.200
     7.258    18.561     0.200
     7.258    19.477     0.200
     7.258    17.922     0.200
     8.423    20.666     0.200
    12.699    30.468     0.200
    14.205    31.896     0.200
    14.205    33.482     0.200
    14.205    32.896     0.200
     0.161     7.039     0.200
     0.244     6.597     0.200
     0.305     6.772     0.200
     0.392     6.448     0.200
     0.438     5.867     0.200
     0.665     5.962     0.200
     0.846     7.267     0.200
     0.888     6.720     0.200
     0.919     5.381     0.200
     1.169     6.240     0.200
     1.251     7.204     0.200
     1.335     7.590     0.200
     1.563     7.042     0.200
     1.848     8.908     0.200
     1.849     8.926     0.200
     2.300     7.440     0.200
     2.465     9.814     0.200
     2.744    10.557     0.200
     2.744    10.956     0.200
     4.610    15.578     0.200
     4.669    16.188     0.200
     4.669    15.891     0.200
     6.818    19.102     0.200
     8.242    23.098     0.200
    12.556    31.698     0.200
     0.132     7.184     0.200
     0.269     6.913     0.200
     0.269     6.741     0.200
     0.269     6.796     0.200
     0.329     6.239     0.200
     0.378     6.302     0.200
     0.557     5.632     0.200
     0.703     5.819     0.200
     0.833     7.256     0.200
     0.998     5.586     0.200
     1.005     6.821     0.200
     1.242     7.222     0.200
     1.288     6.358     0.200
     1.394     6.499     0.200
     1.408     7.185     0.200
     1.402     7.192     0.200
     1.670     6.964     0.200
     1.939     8.888     0.200
     1.939     8.591     0.200
     1.939     8.997     0.200
     1.952     8.839     0.200
     1.952     8.058     0.200
     2.407     8.160     0.200
     2.584    10.198     0.200
     2.860    10.779     0.200
     2.860    10.881     0.200
     4.726    15.796     0.200
     4.767    15.222     0.200
     4.767    14.586     0.200
     6.696    17.186     0.200
     6.698    17.791     0.200
     6.698    15.670     0.200
     6.698    15.991     0.200
     6.698    19.518     0.200
     6.698    15.803     0.200
     7.859    19.942     0.200
     7.859    20.673     0.200
     8.208    21.021     0.200
     8.208    21.367     0.200
     8.219    20.010     0.200
     8.219    20.912     0.200
    10.489    25.695     0.200
    10.489    26.652     0.200
    11.703    29.679     0.200
    12.462    29.720     0.200
    12.462    30.420     0.200
    12.448    27.921     0.200
    12.462    28.220     0.200
    13.339    32.481     0.200
    17.667    33.834     0.200
     0.351     6.512     0.200
     0.472     5.958     0.200
     0.570     5.852     0.200
     0.630     5.879     0.200
     0.690     5.846     0.200
     0.803     6.074     0.200
     0.972     5.907     0.200
     1.029     6.640     0.200
     1.030     7.182     0.200
     1.305     5.870     0.200
     1.280     6.687     0.200
     1.302     7.306     0.200
     1.312     5.827     0.200
     1.364     6.015     0.200
     1.416     7.443     0.200
     1.458     7.273     0.200
     1.606     8.061     0.200
     1.596     7.680     0.200
     1.669     8.679     0.200
     1.807     8.117     0.200
     1.849     8.194     0.200
     1.849     8.875     0.200
     1.851     8.078     0.200
     1.851     8.203     0.200
     3.022    10.232     0.200
     3.022    10.032     0.200
     3.667    12.909     0.200
     3.667    11.609     0.200
     4.390    14.765     0.200
     4.390    13.425     0.200
     4.390    13.665     0.200
     4.390    14.565     0.200
     4.390    14.215     0.200
     6.565    19.991     0.200
     7.687    18.994     0.200
     7.687    18.883     0.200
     7.687    18.294     0.200
     7.687    19.303     0.200
     7.687    18.958     0.200
     8.248    22.744     0.200
     8.852    21.300     0.200
     8.852    20.850     0.200
     8.852    21.750     0.200
     9.021    23.478     0.200
     9.021    22.828     0.200
     9.021    22.704     0.200
     9.021    24.029     0.200
     9.053    21.654     0.200
     9.217    22.637     0.200
     9.217    21.747     0.200
     9.281    21.365     0.200
     9.281    20.495     0.200
     9.624    23.485     0.200
     9.687    25.650     0.200
    10.168    22.245     0.200
    10.170    22.573     0.200
    10.733    26.753     0.200
    10.770    27.917     0.200
    10.770    25.357     0.200
    10.858    24.934     0.200
    10.858    26.891     0.200
    10.858    26.591     0.200
    11.427    23.551     0.200
    12.075    26.291     0.200
    12.075    25.961     0.200
    12.075    26.491     0.200
    12.269    26.626     0.200
    12.439    29.239     0.200
    13.552    30.601     0.200
    13.537    29.770     0.200
    13.726    30.914     0.200
    13.779    28.930     0.200
    13.779    28.716     0.200
    13.779    28.910     0.200
    13.811    33.131     0.200
    14.147    30.479     0.200
    14.147    31.809     0.200
    14.195    29.845     0.200
    14.438    33.814     0.200
    14.438    31.414     0.200
    15.304    32.208     0.200
    15.629    31.939     0.200
    15.643    32.470     0.200
    15.766    34.007     0.200
    17.389    32.817     0.200
    17.389    33.702     0.200
    17.389    33.472     0.200
    17.389    34.872     0.200
    17.389    33.573     0.200
     0.104     5.885     0.200
     0.232     5.257     0.200
     0.434     5.284     0.200
     0.434     5.592     0.200
     0.433     5.627     0.200
     0.494     5.323     0.200
     0.597     4.965     0.200
     0.665     5.223     0.200
     0.670     6.369     0.200
     0.946     5.511     0.200
     1.117     6.612     0.200
     1.079     6.474     0.200
     1.215     5.737     0.200
     1.243     6.500     0.200
     1.323     6.997     0.200
     1.362     6.234     0.200
     1.810     7.127     0.200
     1.855     8.330     0.200
     1.855     8.170     0.200
     1.899     8.898     0.200
     1.898     8.271     0.200
     2.547     7.833     0.200
     2.682    11.054     0.200
     2.976    10.328     0.200
     2.976    10.828     0.200
     4.737    12.816     0.200
     4.737    15.676     0.200
     4.737    15.277     0.200
     4.737    14.836     0.200
     4.840    15.672     0.200
     4.840    14.872     0.200
     5.210    15.651     0.200
     6.624    20.631     0.200
     6.625    20.075     0.200
     6.625    19.634     0.200
     6.625    18.743     0.200
     6.626    19.758     0.200
     6.626    18.825     0.200
     7.784    22.126     0.200
     7.784    20.704     0.200
     8.031    22.004     0.200
     8.031    20.836     0.200
     8.031    21.310     0.200
     8.031    22.345     0.200
     8.142    23.258     0.200
     8.142    21.848     0.200
     8.649    24.723     0.200
     8.649    23.723     0.200
    10.345    26.971     0.200
    10.345    28.229     0.200
    11.018    27.171     0.200
    11.529    31.012     0.200
    12.303    31.775     0.200
    12.303    30.997     0.200
    14.852    33.554     0.200
    14.852    31.679     0.200
    15.239    32.322     0.200
     0.143     7.462     0.200
     0.200     6.885     0.200
     0.422     6.869     0.200
     0.422     7.018     0.200
     0.421     6.569     0.200
     0.637     6.632     0.200
     0.744     6.132     0.200
     0.879     5.263     0.200
     0.944     6.332     0.200
     1.005     8.386     0.200
     1.203     6.312     0.200
     1.308     6.479     0.200
     1.751     7.911     0.200
     1.752     8.548     0.200
     1.752     7.898     0.200
     1.751     8.661     0.200
     2.045     6.980     0.200
     2.045     7.681     0.200
     2.217     9.570     0.200
     2.321     8.987     0.200
     2.321     8.856     0.200
     2.489     9.792     0.200
     2.489     9.493     0.200
     4.356    15.408     0.200
     4.356    13.809     0.200
     4.536    15.503     0.200
     4.536    14.903     0.200
     4.536    12.243     0.200
     4.536    14.739     0.200
     5.478    15.418     0.200
     5.478    16.319     0.200
     5.819    14.966     0.200
     6.633    15.641     0.200
     6.700    19.758     0.200
     6.700    19.258     0.200
     7.057    17.491     0.200
     7.057    18.163     0.200
     7.055    18.757     0.200
     7.057    19.091     0.200
     7.057    18.943     0.200
     7.057    18.082     0.200
     8.219    21.881     0.200
     8.219    21.151     0.200
     8.404    21.080     0.200
     8.404    22.121     0.200
     8.404    22.961     0.200
     8.445    23.491     0.200
     8.445    22.591     0.200
     8.580    21.957     0.200
     8.580    22.591     0.200
     9.196    22.621     0.200
     9.570    26.261     0.200
     9.570    24.261     0.200
     9.692    20.770     0.200
     9.692    20.813     0.200
    10.513    25.575     0.200
    10.513    25.358     0.200
    11.129    26.874     0.200
    11.397    27.108     0.200
    11.869    32.532     0.200
    12.089    27.160     0.200
    12.688    28.481     0.200
    12.802    31.450     0.200
    13.434    33.767     0.200
    13.484    32.590     0.200
    14.406    28.866     0.200
    14.406    29.426     0.200
    14.406    29.276     0.200
    14.406    29.096     0.200
    14.786    32.886     0.200
    14.786    32.286     0.200
    14.786    30.687     0.200
    15.525    34.170     0.200
    15.525    31.071     0.200
    16.775    33.284     0.200
    17.785    34.539     0.200
    17.785    34.895     0.200
    17.785    34.156     0.200
    17.785    35.016     0.200
    17.773    35.323     0.200
     0.507     6.253     0.200
     0.608     5.984     0.200
     0.608     6.338     0.200
     0.608     5.935     0.200
     0.608     6.037     0.200
     0.608     6.158     0.200
     0.628     5.236     0.200
     1.060     6.959     0.200
     1.105     7.257     0.200
     1.691     8.229     0.200
     1.690     9.012     0.200
     1.979     9.076     0.200
     1.979     9.389     0.200
     2.517     8.260     0.200
     2.587    11.246     0.200
     2.905    11.541     0.200
     2.905    12.041     0.200
     4.531    15.266     0.200
     4.531    15.567     0.200
     4.531    16.164     0.200
     4.760    16.285     0.200
     4.760    17.086     0.200
     6.767    18.059     0.200
     6.767    21.540     0.200
     6.765    18.538     0.200
     6.767    16.969     0.200
     6.767    21.179     0.200
     6.767    17.968     0.200
     7.922    20.565     0.200
     7.922    24.237     0.200
     7.906    24.274     0.200
     7.906    19.876     0.200
     7.906    20.377     0.200
     8.277    20.867     0.200
     8.277    24.449     0.200
     8.277    22.039     0.200
     8.441    24.828     0.200
     8.441    24.231     0.200
     8.679    23.752     0.200
     9.348    24.344     0.200
     9.544    21.981     0.200
     9.667    28.217     0.200
    10.149    25.092     0.200
    10.149    28.498     0.200
    10.149    26.498     0.200
    11.043    26.773     0.200
    11.043    26.062     0.200
    11.135    28.689     0.200
    11.388    33.136     0.200
    12.306    30.528     0.200
    12.306    29.648     0.200
    12.306    29.629     0.200
    12.450    31.648     0.200
    13.084    31.392     0.200
    13.048    30.861     0.200
    13.201    31.785     0.200
    13.201    31.387     0.200
    13.201    35.258     0.200
    13.271    31.461     0.200
    14.729    33.849     0.200
    14.729    34.232     0.200
    14.729    34.349     0.200
    15.122    34.297     0.200
    15.122    36.168     0.200
    15.215    35.783     0.200
    15.297    35.144     0.200
    17.335    35.495     0.200
    17.909    36.885     0.200
    17.909    37.342     0.200
    17.909    37.701     0.200
    17.909    38.213     0.200
    17.909    38.342     0.200
    19.343    42.205     0.200
     0.063     7.907     0.200
     0.338     6.441     0.200
     0.401     7.172     0.200
     0.432     5.658     0.200
     0.522     5.643     0.200
     0.695     5.532     0.200
     0.733     6.516     0.200
     0.773     6.484     0.200
     0.905     6.684     0.200
     0.905     6.857     0.200
     0.916     7.022     0.200
     1.040     6.415     0.200
     1.070     6.107     0.200
     1.121     6.298     0.200
     1.124     7.686     0.200
     1.148     7.081     0.200
     1.350     6.773     0.200
     1.374     7.760     0.200
     1.374     7.644     0.200
     1.428     7.656     0.200
     2.456     9.657     0.200
     2.491     8.053     0.200
     2.808    11.149     0.200
     3.871    14.043     0.200
     4.213    14.256     0.200
     4.213    14.155     0.200
     4.639    17.880     0.200
     4.639    16.680     0.200
     7.002    19.506     0.200
     7.002    19.446     0.200
     7.738    21.893     0.200
     8.121    22.150     0.200
     9.861    26.537     0.200
     9.861    27.840     0.200
    12.335    30.070     0.200
    13.237    31.567     0.200
    14.532    31.161     0.200
     0.161     6.818     0.200
     0.254     6.490     0.200
     0.349     5.724     0.200
     0.318     6.583     0.200
     0.319     6.511     0.200
     0.319     6.202     0.200
     0.319     6.710     0.200
     0.467     6.470     0.200
     0.698     6.369     0.200
     0.795     6.619     0.200
     0.909     5.253     0.200
     1.088     6.313     0.200
     1.335     7.786     0.200
     1.360     6.579     0.200
     1.464     6.535     0.200
     1.821     7.944     0.200
     1.821     8.370     0.200
     1.820     8.400     0.200
     1.820     8.830     0.200
     2.202     7.131     0.200
     2.202     8.034     0.200
     2.162     8.742     0.200
     2.162     8.992     0.200
     2.374    10.021     0.200
     2.649    10.213     0.200
     2.649     9.713     0.200
     4.515    15.828     0.200
     4.515    14.930     0.200
     4.629    15.401     0.200
     4.629    15.100     0.200
     4.629    14.139     0.200
     4.629    15.702     0.200
     6.787    18.425     0.200
     6.787    19.425     0.200
     6.858    19.093     0.200
     6.892    18.698     0.200
     6.903    18.442     0.200
     6.903    18.724     0.200
     6.902    18.579     0.200
     6.903    18.263     0.200
     6.903    18.677     0.200
     6.903    18.544     0.200
     8.065    20.668     0.200
     8.065    21.707     0.200
     8.314    22.205     0.200
     8.314    22.155     0.200
     8.314    21.655     0.200
     8.541    23.349     0.200
     8.425    21.409     0.200
     8.425    23.261     0.200
     8.425    22.300     0.200
     8.553    21.706     0.200
     8.826    23.122     0.200
     9.084    23.718     0.200
     9.605    26.736     0.200
     9.559    20.769     0.200
    10.075    28.550     0.200
    10.496    25.255     0.200
    10.496    27.939     0.200
    10.946    28.281     0.200
    11.239    26.453     0.200
    11.792    29.512     0.200
    12.247    27.199     0.200
    12.596    30.027     0.200
    12.613    30.031     0.200
    12.653    30.111     0.200
    12.653    29.430     0.200
    12.986    30.874     0.200
    13.079    29.599     0.200
    13.408    31.954     0.200
    13.325    29.353     0.200
    13.535    31.289     0.200
    13.535    31.968     0.200
    13.535    32.726     0.200
    14.561    33.096     0.200
    14.561    29.748     0.200
    14.774    32.184     0.200
    14.942    30.355     0.200
    14.942    30.547     0.200
    14.942    32.145     0.200
    14.942    32.746     0.200
    14.942    32.848     0.200
    15.217    29.848     0.200
    16.643    35.598     0.200
    17.722    35.312     0.200
     0.186     6.766     0.200
     0.229     6.435     0.200
     0.238     7.288     0.200
     0.239     7.146     0.200
     0.436     5.535     0.200
     0.469     6.035     0.200
     0.742     5.811     0.200
     0.876     6.608     0.200
     0.924     7.386     0.200
     0.983     5.128     0.200
     1.178     6.178     0.200
     1.528     6.734     0.200
     1.904     8.727     0.200
     1.903     8.675     0.200
     2.084     9.318     0.200
     2.266     8.028     0.200
     2.266     8.333     0.200
     2.456    10.906     0.200
     2.725    10.570     0.200
     2.725    10.070     0.200
     4.592    15.189     0.200
     6.818    18.352     0.200
     6.816    19.500     0.200
     6.818    19.360     0.200
     6.818    18.251     0.200
     7.980    21.058     0.200
     8.317    22.920     0.200
     8.317    20.374     0.200
     8.341    21.439     0.200
     8.465    19.819     0.200
    12.605    33.404     0.200
    12.605    27.951     0.200
    14.645    31.159     0.200
     0.115     5.292     0.200
     0.135     5.236     0.200
     0.471     4.392     0.200
     0.515     5.457     0.200
     0.515     5.605     0.200
     0.515     5.462     0.200
     0.602     5.080     0.200
     0.591     5.910     0.200
     0.813     5.088     0.200
     1.000     6.133     0.200
     1.046     6.614     0.200
     1.761     7.158     0.200
     1.765     7.466     0.200
     1.764     7.500     0.200
     1.764     8.820     0.200
     1.764     9.019     0.200
     1.954     8.090     0.200
     1.954     8.211     0.200
     2.494     7.802     0.200
     2.494     8.404     0.200
     2.594    10.541     0.200
     2.900    10.465     0.200
     2.900    10.762     0.200
     4.260    15.300     0.200
     4.603    14.491     0.200
     4.603    15.592     0.200
     4.603    15.491     0.200
     4.603    13.049     0.200
     4.603    17.190     0.200
     4.603    15.292     0.200
     4.722    16.309     0.200
     4.761    15.553     0.200
     4.761    15.756     0.200
     5.128    14.362     0.200
     6.692    20.415     0.200
     6.724    20.138     0.200
     6.740    20.560     0.200
     6.734    19.663     0.200
     6.734    20.182     0.200
     6.734    19.022     0.200
     6.734    19.736     0.200
     6.734    17.322     0.200
     7.891    20.672     0.200
     7.891    23.222     0.200
     7.891    20.320     0.200
     7.943    21.818     0.200
     7.973    21.672     0.200
     7.983    20.598     0.200
     7.984    22.238     0.200
     7.983    21.389     0.200
     7.983    20.529     0.200
     8.248    21.118     0.200
     8.248    22.817     0.200
     8.248    22.458     0.200
     8.248    20.958     0.200
     8.418    21.368     0.200
     8.418    24.329     0.200
     8.418    21.778     0.200
     8.515    24.141     0.200
     9.440    27.745     0.200
     9.487    21.299     0.200
     9.746    23.730     0.200
     9.746    26.991     0.200
     9.746    26.780     0.200
    10.243    28.269     0.200
    10.243    25.976     0.200
    10.243    25.175     0.200
    10.885    28.290     0.200
    11.026    26.768     0.200
    11.026    27.936     0.200
    11.026    27.639     0.200
    11.026    25.639     0.200
    11.470    30.654     0.200
    12.280    31.904     0.200
    12.337    31.434     0.200
    12.337    29.394     0.200
    12.337    31.203     0.200
    12.463    30.464     0.200
    12.463    28.566     0.200
    12.651    32.076     0.200
    12.976    30.939     0.200
    13.079    31.574     0.200
    13.142    30.950     0.200
    13.227    29.051     0.200
    13.227    32.852     0.200
    13.287    28.649     0.200
    14.542    33.112     0.200
    14.542    31.702     0.200
    14.751    33.163     0.200
    14.751    31.362     0.200
    14.751    31.721     0.200
    14.763    30.123     0.200
    15.141    32.474     0.200
    15.141    31.213     0.200
    15.141    34.013     0.200
    15.141    33.513     0.200
    15.309    35.454     0.200
    17.424    36.577     0.200
    17.967    35.703     0.200
    17.967    35.996     0.200
    18.975    37.412     0.200
     0.154     7.348     0.200
     0.254     6.721     0.200
     0.329     6.972     0.200
     0.328     6.910     0.200
     0.428     5.941     0.200
     0.377     6.770     0.200
     0.642     6.176     0.200
     0.879     6.684     0.200
     0.829     7.486     0.200
     0.895     5.684     0.200
     1.155     6.222     0.200
     1.233     7.379     0.200
     1.311     7.535     0.200
     1.456     6.848     0.200
     1.560     6.985     0.200
     1.826     8.783     0.200
     2.079     8.747     0.200
     2.297     8.682     0.200
     2.737    10.859     0.200
     4.603    16.185     0.200
     4.647    17.067     0.200
     6.831    18.850     0.200
     6.829    18.866     0.200
     6.831    18.834     0.200
     7.991    19.500     0.200
     8.227    20.487     0.200
     8.351    22.388     0.200
    12.554    29.090     0.200
    17.651    35.017     0.200
     0.198     6.343     0.200
     0.209     6.371     0.200
     0.296     6.415     0.200
     0.297     6.484     0.200
     0.297     6.593     0.200
     0.400     5.540     0.200
     0.434     6.143     0.200
     0.689     6.048     0.200
     0.847     6.447     0.200
     0.885     7.518     0.200
     0.924     5.226     0.200
     1.136     6.067     0.200
     1.289     7.467     0.200
     1.345     7.618     0.200
     1.412     6.505     0.200
     1.516     7.111     0.200
     1.846     8.593     0.200
     1.845     8.205     0.200
     2.110     8.631     0.200
     2.110     9.131     0.200
     2.253     7.406     0.200
     2.253     7.507     0.200
     2.426     9.998     0.200
     2.701    10.485     0.200
     4.568    14.600     0.200
     4.568    14.702     0.200
     4.660    15.627     0.200
     4.660    14.236     0.200
     4.660    15.767     0.200
     5.407    14.999     0.200
     6.815    20.275     0.200
     6.815    20.377     0.200
     6.853    18.320     0.200
     6.853    18.586     0.200
     6.853    18.726     0.200
     6.853    17.961     0.200
     8.015    20.704     0.200
     8.015    21.572     0.200
     8.246    22.477     0.200
     8.284    20.736     0.200
     8.284    21.533     0.200
     8.284    21.493     0.200
     8.284    21.634     0.200
     8.375    21.365     0.200
     8.375    21.780     0.200
     8.375    21.467     0.200
     8.505    21.001     0.200
     8.572    24.470     0.200
     8.572    23.869     0.200
     9.516    21.069     0.200
     9.516    21.149     0.200
    10.046    24.643     0.200
    10.046    25.870     0.200
    10.490    25.655     0.200
    10.490    27.187     0.200
    11.187    25.780     0.200
    11.187    29.702     0.200
    11.766    30.291     0.200
    12.299    26.072     0.200
    12.299    27.877     0.200
    12.604    30.418     0.200
    12.604    30.316     0.200
    12.604    29.683     0.200
    12.953    30.640     0.200
    13.130    29.474     0.200
    13.200    30.750     0.200
    13.272    30.144     0.200
    13.399    31.738     0.200
    13.476    30.041     0.200
    13.476    31.548     0.200
    13.485    30.353     0.200
    13.485    33.189     0.200
    13.485    31.431     0.200
    14.463    33.017     0.200
    14.612    29.012     0.200
    14.612    32.785     0.200
    14.612    29.379     0.200
    14.612    29.012     0.200
    14.722    30.887     0.200
    14.722    31.903     0.200
    14.994    31.329     0.200
    15.530    34.065     0.200
    16.600    35.088     0.200
    17.635    33.004     0.200
    17.704    34.847     0.200
     1.019     7.088     0.200
     1.095     7.199     0.200
     1.241     6.785     0.200
     1.617     8.991     0.200
     1.616     8.417     0.200
     1.616     8.577     0.200
     2.011     8.778     0.200
     2.543     8.631     0.200
     2.543     9.229     0.200
     2.911    12.237     0.200
     4.456    16.805     0.200
     4.456    17.305     0.200
     4.760    17.254     0.200
     4.760    16.754     0.200
     6.802    20.585     0.200
     6.801    20.881     0.200
     6.803    20.833     0.200
     7.828    22.696     0.200
     7.828    23.080     0.200
     7.828    22.888     0.200
     7.956    23.535     0.200
     8.310    24.403     0.200
     8.310    26.282     0.200
     9.606    22.675     0.200
    10.053    27.929     0.200
    10.053    28.886     0.200
    12.275    32.062     0.200
    12.276    29.143     0.200
    14.706    31.418     0.200
    14.706    36.520     0.200
    15.101    34.581     0.200
    15.118    37.382     0.200
    17.848    34.905     0.200
    20.542    42.977     0.200
     0.216     6.638     0.200
     0.190     6.746     0.200
     0.279     6.924     0.200
     0.279     6.905     0.200
     0.431     5.750     0.200
     0.425     6.327     0.200
     0.695     5.968     0.200
     0.878     6.655     0.200
     0.878     7.433     0.200
     0.942     5.144     0.200
     1.168     6.195     0.200
     1.284     7.338     0.200
     1.361     7.423     0.200
     1.441     6.827     0.200
     1.869     8.458     0.200
     1.868     7.868     0.200
     2.079     8.201     0.200
     2.282     7.533     0.200
     2.282     7.732     0.200
     2.457    10.888     0.200
     2.732    10.481     0.200
     4.599    15.297     0.200
     4.685    16.086     0.200
     4.685    13.715     0.200
     5.406    16.574     0.200
     6.821    17.126     0.200
     6.821    19.058     0.200
     6.821    18.995     0.200
     6.821    18.648     0.200
     7.983    19.585     0.200
     8.343    22.318     0.200
     8.598    23.827     0.200
     9.486    21.587     0.200
    10.496    25.523     0.200
    10.496    26.079     0.200
    12.579    30.666     0.200
    12.579    27.505     0.200
    17.703    35.558     0.200
     0.156     7.242     0.200
     0.249     6.661     0.200
     0.306     6.907     0.200
     0.307     7.049     0.200
     0.388     6.695     0.200
     0.442     5.928     0.200
     0.662     6.248     0.200
     0.841     7.482     0.200
     0.892     6.826     0.200
     0.918     5.498     0.200
     1.172     6.426     0.200
     1.247     7.496     0.200
     1.334     7.570     0.200
     1.567     7.083     0.200
     1.849     8.644     0.200
     1.848     8.554     0.200
     2.066     8.877     0.200
     2.304     7.580     0.200
     2.469    10.263     0.200
     2.748    10.201     0.200
     4.614    14.822     0.200
     4.614    15.123     0.200
     4.670    15.478     0.200
     4.670    13.587     0.200
     4.718    12.764     0.200
     5.370    14.707     0.200
     6.769    17.873     0.200
     6.822    20.363     0.200
     6.803    17.880     0.200
     6.814    18.520     0.200
     6.814    18.261     0.200
     6.814    18.149     0.200
     6.814    18.913     0.200
     6.814    17.819     0.200
     7.975    21.041     0.200
     7.975    20.242     0.200
     8.227    19.764     0.200
     8.237    20.582     0.200
     8.238    20.131     0.200
     8.237    21.979     0.200
     8.237    20.923     0.200
     8.471    22.600     0.200
     8.582    24.014     0.200
     9.490    20.795     0.200
     9.604    26.598     0.200
    10.000    22.715     0.200
    10.000    27.875     0.200
    10.461    26.030     0.200
    10.461    26.388     0.200
    10.978    27.762     0.200
    11.722    29.671     0.200
    12.343    28.933     0.200
    12.494    28.866     0.200
    12.511    29.068     0.200
    12.551    30.101     0.200
    12.551    28.120     0.200
    12.551    28.821     0.200
    12.905    29.271     0.200
    13.173    29.043     0.200
    13.150    32.151     0.200
    13.368    29.970     0.200
    13.423    30.729     0.200
    13.433    32.274     0.200
    13.433    30.124     0.200
    14.413    31.679     0.200
    14.652    31.677     0.200
    14.652    31.058     0.200
    14.652    32.677     0.200
    14.652    32.578     0.200
    14.652    30.478     0.200
    14.664    31.641     0.200
    14.676    31.638     0.200
    14.676    31.337     0.200
    15.035    31.810     0.200
    15.168    32.772     0.200
    15.168    31.487     0.200
    15.508    34.289     0.200
    17.597    34.219     0.200
    17.666    35.282     0.200
    19.550    36.051     0.200
     0.142     7.172     0.200
     0.270     6.376     0.200
     0.347     5.731     0.200
     0.306     6.877     0.200
     0.307     6.875     0.200
     0.307     6.649     0.200
     0.487     6.334     0.200
     0.718     6.199     0.200
     0.790     6.596     0.200
     0.925     5.018     0.200
     0.932     7.758     0.200
     1.089     6.205     0.200
     1.333     7.557     0.200
     1.351     7.533     0.200
     1.350     6.670     0.200
     1.454     6.670     0.200
     1.834     8.177     0.200
     1.833     8.638     0.200
     1.833     8.111     0.200
     2.168     8.591     0.200
     2.191     7.167     0.200
     2.191     7.667     0.200
     2.370     9.278     0.200
     2.642    10.002     0.200
     2.642    10.104     0.200
     4.509    14.818     0.200
     4.509    14.619     0.200
     4.640    15.588     0.200
     4.640    15.186     0.200
     4.640    15.877     0.200
     4.640    12.846     0.200
     4.640    16.088     0.200
     5.445    15.894     0.200
     6.860    18.776     0.200
     6.894    20.981     0.200
     6.906    18.404     0.200
     6.906    17.755     0.200
     6.906    17.646     0.200
     6.906    18.681     0.200
     6.906    18.314     0.200
     8.067    21.217     0.200
     8.067    20.877     0.200
     8.323    25.505     0.200
     8.333    19.402     0.200
     8.333    21.281     0.200
     8.334    24.875     0.200
     8.333    20.509     0.200
     8.428    23.225     0.200
     8.428    21.236     0.200
     8.428    23.076     0.200
     8.551    24.341     0.200
     8.553    19.995     0.200
     9.555    20.392     0.200
     9.621    26.554     0.200
    10.515    23.364     0.200
    10.515    25.922     0.200
    11.244    28.674     0.200
    11.812    29.588     0.200
    12.667    29.608     0.200
    12.667    28.455     0.200
    13.548    31.624     0.200
    14.558    33.542     0.200
    14.558    30.933     0.200
    14.558    29.843     0.200
    17.742    34.349     0.200
    19.651    36.127     0.200
     0.228     6.932     0.200
     0.178     7.171     0.200
     0.292     7.269     0.200
     0.291     7.239     0.200
     0.433     6.034     0.200
     0.411     6.651     0.200
     0.681     6.241     0.200
     0.881     6.884     0.200
     0.864     7.570     0.200
     0.931     5.437     0.200
     1.167     6.345     0.200
     1.270     7.516     0.200
     1.348     7.546     0.200
     1.447     7.101     0.200
     1.551     7.238     0.200
     1.859     7.824     0.200
     1.858     8.260     0.200
     2.076     8.726     0.200
     2.289     7.732     0.200
     2.736    10.712     0.200
     4.602    15.031     0.200
     4.677    15.562     0.200
     4.677    13.733     0.200
     6.821    19.015     0.200
     6.821    17.269     0.200
     8.260    23.950     0.200
     8.343    21.475     0.200
    12.570    30.561     0.200
     0.194     6.482     0.200
     0.208     6.598     0.200
     0.207     6.635     0.200
     0.284     6.178     0.200
     0.442     6.003     0.200
     0.543     5.575     0.200
     0.758     5.978     0.200
     0.897     7.425     0.200
     0.984     6.926     0.200
     1.037     5.552     0.200
     1.078     6.600     0.200
     1.282     6.526     0.200
     1.306     7.424     0.200
     1.633     7.031     0.200
     1.972     8.446     0.200
     1.971     9.776     0.200
     1.971     8.729     0.200
     1.976     8.652     0.200
     2.370     7.524     0.200
     2.370     7.930     0.200
     2.565    10.655     0.200
     2.565    10.350     0.200
     3.313    11.925     0.200
     4.700    15.638     0.200
     4.700    14.739     0.200
     4.794    15.333     0.200
     4.794    14.833     0.200
     4.794    14.208     0.200
     4.794    14.568     0.200
     6.946    19.529     0.200
     8.215    22.716     0.200
     8.272    20.447     0.200
     8.272    23.049     0.200
     8.272    21.448     0.200
     8.272    20.698     0.200
     8.707    24.974     0.200
     9.008    24.463     0.200
     9.715    25.112     0.200
    10.036    25.339     0.200
    10.036    25.730     0.200
    10.036    26.862     0.200
    10.549    25.477     0.200
    10.549    28.883     0.200
    11.768    29.255     0.200
    12.437    26.145     0.200
    12.511    29.427     0.200
    12.511    29.269     0.200
    12.511    29.840     0.200
    13.082    30.492     0.200
    13.269    27.329     0.200
    13.386    32.177     0.200
    13.449    29.634     0.200
    14.420    33.097     0.200
    14.589    29.892     0.200
    14.754    30.005     0.200
    14.754    30.505     0.200
    14.754    29.357     0.200
    15.606    33.960     0.200
    16.534    33.530     0.200
    17.659    34.502     0.200
    17.659    33.760     0.200
    17.731    34.716     0.200
    19.699    37.098     0.200
     0.162     7.204     0.200
     0.245     6.781     0.200
     0.318     6.961     0.200
     0.319     7.023     0.200
     0.319     6.874     0.200
     0.388     6.623     0.200
     0.427     5.998     0.200
     0.653     6.050     0.200
     0.840     7.318     0.200
     0.877     6.760     0.200
     0.904     5.332     0.200
     0.937     6.162     0.200
     1.156     6.292     0.200
     1.245     7.233     0.200
     1.321     7.393     0.200
     1.451     6.936     0.200
     1.555     7.047     0.200
     1.834     8.593     0.200
     1.833     8.494     0.200
     2.080     8.440     0.200
     2.292     7.544     0.200
     2.292     7.743     0.200
     2.454    10.266     0.200
     2.734    10.293     0.200
     3.233    11.668     0.200
     4.600    16.714     0.200
     4.654    15.686     0.200
     4.654    14.947     0.200
     6.830    19.229     0.200
     6.830    16.889     0.200
     6.830    18.838     0.200
     6.830    17.319     0.200
     7.991    21.682     0.200
     8.237    22.319     0.200
     8.237    20.479     0.200
     8.351    23.052     0.200
    10.454    24.671     0.200
    10.454    25.207     0.200
    12.561    29.715     0.200
     0.195     6.640     0.200
     0.216     6.857     0.200
     0.413     6.195     0.200
     0.322     6.983     0.200
     0.322     7.123     0.200
     0.321     6.972     0.200
     0.394     5.844     0.200
     0.663     5.715     0.200
     0.862     7.138     0.200
     0.899     4.886     0.200
     0.844     6.596     0.200
     0.920     5.829     0.200
     1.126     6.050     0.200
     1.265     6.940     0.200
     1.319     6.942     0.200
     1.416     6.794     0.200
     1.521     6.914     0.200
     1.823     8.018     0.200
     1.822     8.103     0.200
     1.822     8.205     0.200
     2.113     8.663     0.200
     2.113     8.515     0.200
     2.258     7.512     0.200
     2.258     7.613     0.200
     2.421     9.908     0.200
     2.700     9.951     0.200
     2.700    10.251     0.200
     4.567    14.672     0.200
     4.639    14.530     0.200
     4.639    14.730     0.200
     4.639    13.530     0.200
     5.382    14.155     0.200
     6.793    19.290     0.200
     6.861    18.022     0.200
     6.861    17.881     0.200
     6.861    18.100     0.200
     6.861    17.881     0.200
     8.022    20.281     0.200
     8.022    20.152     0.200
     8.226    22.368     0.200
     8.262    21.421     0.200
     8.262    22.050     0.200
     8.262    20.977     0.200
     8.262    21.309     0.200
     8.382    20.746     0.200
     8.382    20.641     0.200
     8.382    21.047     0.200
     8.551    23.973     0.200
     8.516    21.646     0.200
     8.516    21.798     0.200
     8.516    20.357     0.200
     9.028    23.812     0.200
     9.590    25.549     0.200
     9.531    19.531     0.200
     9.531    19.709     0.200
    10.023    25.640     0.200
    10.023    25.351     0.200
    10.023    26.992     0.200
    10.463    25.275     0.200
    10.463    25.955     0.200
    10.950    26.572     0.200
    11.239    27.103     0.200
    11.191    25.578     0.200
    11.191    26.078     0.200
    11.191    25.406     0.200
    11.743    29.425     0.200
    12.295    27.281     0.200
    12.594    29.738     0.200
    12.594    30.022     0.200
    12.594    29.405     0.200
    12.594    28.956     0.200
    12.932    30.242     0.200
    13.197    33.004     0.200
    13.273    29.750     0.200
    13.373    30.406     0.200
    13.465    30.824     0.200
    13.465    33.055     0.200
    13.465    28.555     0.200
    13.465    31.230     0.200
    13.465    30.625     0.200
    13.477    32.239     0.200
    13.477    32.446     0.200
    13.477    31.559     0.200
    14.445    32.489     0.200
    14.606    30.186     0.200
    14.606    31.616     0.200
    14.606    29.139     0.200
    14.723    30.921     0.200
    14.723    31.093     0.200
    14.723    30.765     0.200
    14.988    34.319     0.200
    14.988    31.042     0.200
    14.988    33.753     0.200
    15.504    32.335     0.200
    16.585    33.423     0.200
    17.610    34.955     0.200
    17.610    34.326     0.200
    17.679    34.436     0.200
     0.129     7.211     0.200
     0.272     6.760     0.200
     0.272     6.479     0.200
     0.271     6.754     0.200
     0.325     6.268     0.200
     0.376     6.308     0.200
     0.551     5.658     0.200
     0.699     5.893     0.200
     0.831     7.249     0.200
     1.000     6.884     0.200
     0.993     5.646     0.200
     1.051     6.290     0.200
     1.240     7.235     0.200
     1.282     6.427     0.200
     1.394     6.439     0.200
     1.411     7.124     0.200
     1.397     7.254     0.200
     1.665     6.915     0.200
     1.957     8.768     0.200
     1.957     8.936     0.200
     1.934     9.060     0.200
     1.933     9.034     0.200
     2.403     7.713     0.200
     2.403     8.014     0.200
     2.578    10.263     0.200
     2.854    10.840     0.200
     2.854    11.539     0.200
     4.721    16.255     0.200
     4.721    15.857     0.200
     4.761    15.492     0.200
     4.761    16.281     0.200
     5.371    15.373     0.200
     6.693    22.449     0.200
     6.704    19.645     0.200
     6.704    19.755     0.200
     6.704    19.915     0.200
     6.704    20.165     0.200
     6.704    19.434     0.200
     7.865    21.566     0.200
     7.865    22.218     0.200
     8.225    21.927     0.200
     8.225    21.607     0.200
     8.225    23.767     0.200
     8.208    19.452     0.200
     8.208    21.862     0.200
     8.208    20.539     0.200
     8.208    21.515     0.200
     8.674    25.325     0.200
     9.385    20.959     0.200
     9.384    21.733     0.200
    10.486    25.799     0.200
    10.486    25.682     0.200
    11.035    24.137     0.200
    12.466    29.325     0.200
    13.050    28.243     0.200
    13.119    30.221     0.200
    13.344    33.230     0.200
    13.344    31.031     0.200
    14.568    32.174     0.200
    14.763    33.060     0.200
    17.594    35.431     0.200
     0.237     7.644     0.200
     0.288     7.122     0.200
     0.330     6.556     0.200
     0.378     7.647     0.200
     0.455     7.414     0.200
     0.456     7.585     0.200
     0.557     6.727     0.200
     0.765     5.655     0.200
     0.779     6.844     0.200
     0.788     6.496     0.200
     0.798     7.819     0.200
     1.028     6.351     0.200
     1.190     7.458     0.200
     1.381     6.848     0.200
     1.410     8.208     0.200
     1.431     7.608     0.200
     1.488     6.931     0.200
     1.688     7.627     0.200
     1.688     8.303     0.200
     1.687     8.563     0.200
     1.687     8.282     0.200
     2.192     9.013     0.200
     2.192     8.703     0.200
     2.222     7.671     0.200
     2.222     7.870     0.200
     2.343     9.959     0.200
     2.343    10.061     0.200
     2.637    10.119     0.200
     2.637    10.418     0.200
     4.505    14.820     0.200
     4.505    15.420     0.200
     4.501    15.273     0.200
     4.501    14.974     0.200
     4.505    15.570     0.200
     4.505    14.559     0.200
     5.289    14.568     0.200
     6.945    18.651     0.200
     6.956    18.435     0.200
     6.956    17.976     0.200
     6.956    18.337     0.200
     8.115    20.641     0.200
     8.199    21.018     0.200
     8.199    20.720     0.200
     8.474    21.364     0.200
     8.474    21.774     0.200
     8.474    22.704     0.200
     8.621    24.895     0.200
     8.621    21.385     0.200
     8.988    23.211     0.200
     9.459    25.807     0.200
     9.651    21.030     0.200
     9.958    26.983     0.200
    10.351    25.694     0.200
    10.351    26.202     0.200
    10.816    24.779     0.200
    11.107    30.081     0.200
    11.270    25.023     0.200
    11.270    25.724     0.200
    11.669    28.824     0.200
    12.553    29.908     0.200
    12.570    29.907     0.200
    12.610    29.687     0.200
    12.610    28.626     0.200
    12.610    28.026     0.200
    12.878    31.107     0.200
    13.244    30.546     0.200
    13.265    29.197     0.200
    13.337    29.075     0.200
    13.476    29.634     0.200
    13.476    29.798     0.200
    13.500    32.310     0.200
    13.500    29.990     0.200
    13.500    31.451     0.200
    14.517    30.258     0.200
    14.517    30.963     0.200
    14.795    31.343     0.200
    14.795    30.042     0.200
    15.382    33.784     0.200
    16.569    33.632     0.200
    17.812    35.136     0.200
     0.527     6.265     0.200
     0.581     5.918     0.200
     0.581     5.757     0.200
     0.581     5.751     0.200
     0.632     5.141     0.200
     0.771     5.339     0.200
     0.915     5.829     0.200
     0.935     6.956     0.200
     1.131     6.346     0.200
     1.220     7.926     0.200
     1.724     9.243     0.200
     1.723     9.018     0.200
     1.793     7.581     0.200
     1.956     9.125     0.200
     1.956     8.695     0.200
     2.604    11.724     0.200
     2.604    10.724     0.200
     2.918    11.759     0.200
     2.918    12.158     0.200
     3.456    10.680     0.200
     4.563    16.156     0.200
     4.563    15.953     0.200
     4.563    16.746     0.200
     4.563    14.874     0.200
     4.563    16.855     0.200
     4.775    17.086     0.200
     4.775    16.484     0.200
     6.733    20.739     0.200
     6.742    21.114     0.200
     6.742    19.586     0.200
     7.898    23.658     0.200
     7.922    21.307     0.200
     7.922    21.506     0.200
     8.254    24.057     0.200
     8.254    22.498     0.200
     8.474    26.216     0.200
     8.474    25.615     0.200
     8.689    25.904     0.200
     9.515    23.496     0.200
    10.178    28.002     0.200
    10.178    27.135     0.200
    10.178    28.931     0.200
    10.838    30.429     0.200
    11.023    26.989     0.200
    12.302    32.846     0.200
    12.302    28.385     0.200
    12.302    28.025     0.200
    12.469    31.100     0.200
    13.076    32.813     0.200
    13.195    33.325     0.200
    14.751    36.367     0.200
    14.751    33.906     0.200
    14.751    34.145     0.200
    14.751    33.938     0.200
    15.245    35.094     0.200
    17.358    37.511     0.200
     0.163     6.832     0.200
     0.248     6.485     0.200
     0.361     5.699     0.200
     0.308     6.740     0.200
     0.309     6.723     0.200
     0.465     6.415     0.200
     0.702     6.278     0.200
     0.806     6.611     0.200
     0.919     5.998     0.200
     0.918     5.191     0.200
     0.912     7.878     0.200
     1.100     6.222     0.200
     1.313     7.751     0.200
     1.370     6.532     0.200
     1.474     6.725     0.200
     1.831     8.253     0.200
     1.830     8.616     0.200
     1.830     8.382     0.200
     2.151     8.705     0.200
     2.211     7.121     0.200
     2.211     7.426     0.200
     2.385     9.890     0.200
     2.385     9.991     0.200
     2.659     9.793     0.200
     2.659    10.191     0.200
     4.526    14.907     0.200
     4.526    14.704     0.200
     4.640    15.576     0.200
     4.640    15.474     0.200
     4.640    14.576     0.200
     5.427    14.794     0.200
     6.797    20.006     0.200
     6.892    18.441     0.200
     6.892    17.949     0.200
     6.892    17.496     0.200
     6.892    18.402     0.200
     6.892    16.222     0.200
     8.053    20.651     0.200
     8.053    19.893     0.200
     8.278    22.415     0.200
     8.313    21.233     0.200
     8.313    22.116     0.200
     8.313    22.094     0.200
     8.313    21.625     0.200
     8.414    21.247     0.200
     8.414    21.044     0.200
     8.414    22.942     0.200
     8.552    24.121     0.200
     8.542    21.195     0.200
     8.542    20.195     0.200
     9.081    23.857     0.200
     9.547    20.035     0.200
     9.547    20.036     0.200
     9.613    26.343     0.200
    10.074    25.858     0.200
    10.501    26.154     0.200
    10.501    26.686     0.200
    10.501    27.084     0.200
    10.957    24.465     0.200
    11.239    27.367     0.200
    11.228    26.242     0.200
    11.228    25.156     0.200
    11.792    28.309     0.200
    12.258    29.968     0.200
    12.646    29.949     0.200
    12.646    28.659     0.200
    12.646    29.441     0.200
    12.984    30.096     0.200
    13.090    28.866     0.200
    13.243    31.175     0.200
    13.243    30.425     0.200
    13.517    30.982     0.200
    13.527    31.754     0.200
    13.527    31.160     0.200
    14.498    32.930     0.200
    14.573    31.587     0.200
    14.573    32.861     0.200
    14.573    30.040     0.200
    14.763    31.411     0.200
    14.763    31.223     0.200
    14.954    30.512     0.200
    14.954    30.942     0.200
    14.954    31.113     0.200
    16.638    34.859     0.200
    17.655    33.383     0.200
    17.724    34.491     0.200
     0.084     4.869     0.200
     0.370     4.252     0.200
     0.395     4.907     0.200
     0.445     6.062     0.200
     0.600     5.364     0.200
     0.684     4.624     0.200
     0.752     5.874     0.200
     0.904     6.419     0.200
     1.007     6.218     0.200
     1.087     6.314     0.200
     1.085     7.095     0.200
     1.071     6.093     0.200
     1.109     5.947     0.200
     1.314     7.118     0.200
     1.755     6.987     0.200
     2.273     9.178     0.200
     2.452     8.455     0.200
     2.452     8.154     0.200
     2.759    11.567     0.200
     4.154    13.990     0.200
     4.154    13.490     0.200
     4.154    14.160     0.200
     4.154    12.809     0.200
     4.154    15.090     0.200
     4.189    11.507     0.200
     4.586    16.144     0.200
     4.586    18.144     0.200
     5.744    16.898     0.200
     7.065    20.708     0.200
     7.065    19.948     0.200
     7.065    19.329     0.200
     7.065    20.436     0.200
     7.748    20.265     0.200
     7.748    21.599     0.200
     8.062    23.075     0.200
     8.062    24.975     0.200
     8.215    23.291     0.200
     8.215    22.531     0.200
     8.566    23.787     0.200
     8.566    23.338     0.200
     8.566    25.396     0.200
     8.780    23.605     0.200
     8.780    23.384     0.200
     9.838    24.446     0.200
     9.838    27.353     0.200
     9.838    27.052     0.200
     9.899    21.845     0.200
    10.421    27.650     0.200
    11.294    30.648     0.200
    12.379    28.804     0.200
    13.295    31.091     0.200
    14.471    32.238     0.200
    14.471    32.669     0.200
    17.085    34.507     0.200
    17.555    34.593     0.200
     1.428     7.697     0.200
     1.428     7.728     0.200
     2.150    10.225     0.200
     2.536     9.471     0.200
     4.266    14.878     0.200
     4.695    18.174     0.200
     6.942    19.862     0.200
     6.942    20.653     0.200
     7.720    21.768     0.200
     8.091    21.643     0.200
     9.875    27.767     0.200
    12.287    32.425     0.200
    14.592    35.501     0.200
    14.592    33.157     0.200
    17.675    37.800     0.200
     0.272     6.594     0.200
     1.868     8.556     0.200
     1.867     8.337     0.200
     2.117     8.390     0.200
     4.713    13.683     0.200
     6.854    18.612     0.200
     6.854    19.381     0.200
     6.854    17.652     0.200
     8.016    18.494     0.200
     8.316    22.700     0.200
     8.377    22.453     0.200
     0.808     7.441     0.200
     0.808     6.901     0.200
     0.808     6.312     0.200
     1.974     8.237     0.200
     1.972     8.557     0.200
     1.972     8.057     0.200
     2.050     8.051     0.200
     2.800    10.339     0.200
     2.800     9.858     0.200
     3.905    12.602     0.200
     4.590    13.050     0.200
     4.623    12.193     0.200
     6.263    15.985     0.200
     7.443    19.568     0.200
     7.443    18.408     0.200
     7.443    19.408     0.200
     7.443    18.682     0.200
     8.608    25.363     0.200
     8.608    20.822     0.200
     8.974    21.597     0.200
     8.974    24.852     0.200
     8.974    23.053     0.200
     9.917    23.371     0.200
     9.919    21.959     0.200
    10.930    26.312     0.200
    11.839    27.955     0.200
    12.418    29.446     0.200
    13.383    30.789     0.200
    13.873    30.674     0.200
    14.026    29.157     0.200
    14.026    28.577     0.200
    15.405    32.408     0.200
    17.633    32.635     0.200
    17.633    32.442     0.200
     0.515     5.720     0.200
     1.966     7.639     0.200
     4.629    13.235     0.200
     6.746    18.214     0.200
     6.746    19.299     0.200
     7.903    22.023     0.200
     8.260    22.219     0.200
    11.038    27.766     0.200
    12.348    31.062     0.200
     0.316     6.675     0.200
     1.824     7.556     0.200
     1.823     8.255     0.200
     2.163     8.819     0.200
     2.163     8.577     0.200
     4.632    15.370     0.200
     4.666    13.290     0.200
     5.661    16.196     0.200
     6.903    16.344     0.200
     6.903    19.204     0.200
     6.903    18.509     0.200
     6.903    17.969     0.200
     8.065    20.984     0.200
     8.065    20.390     0.200
     8.317    21.156     0.200
     8.317    20.765     0.200
     8.426    20.463     0.200
    11.240    28.075     0.200
    11.240    26.028     0.200
    13.538    33.275     0.200
    14.561    31.137     0.200
    14.561    31.770     0.200
    14.561    30.715     0.200
     8.317    20.725     0.200
     0.273     6.902     0.200
     0.273     6.386     0.200
     0.273     7.362     0.200
     1.869     8.177     0.200
     1.869     7.874     0.200
     1.868     8.320     0.200
     2.113     8.651     0.200
     2.697     9.406     0.200
     4.680    14.966     0.200
     4.680    15.107     0.200
     4.680    14.427     0.200
     4.680    13.837     0.200
     4.714    13.565     0.200
     5.610    16.254     0.200
     6.850    18.277     0.200
     6.850    18.633     0.200
     6.850    18.312     0.200
     6.850    19.902     0.200
     8.012    20.401     0.200
     8.012    20.626     0.200
     8.012    20.735     0.200
     8.271    21.265     0.200
     8.310    21.510     0.200
     8.310    21.787     0.200
     8.373    20.728     0.200
     8.373    20.986     0.200
     8.373    21.556     0.200
     9.071    24.229     0.200
     9.504    21.466     0.200
     9.504    22.077     0.200
     9.504    20.150     0.200
    10.073    25.553     0.200
    10.073    25.785     0.200
    10.519    26.627     0.200
    10.519    25.951     0.200
    11.188    25.652     0.200
    11.188    25.324     0.200
    12.298    26.362     0.200
    12.619    29.964     0.200
    12.619    29.864     0.200
    12.619    29.973     0.200
    12.979    29.918     0.200
    13.209    31.017     0.200
    13.209    30.172     0.200
    13.277    30.491     0.200
    13.428    29.677     0.200
    13.499    31.248     0.200
    13.499    31.498     0.200
    13.499    31.928     0.200
    13.492    30.929     0.200
    13.492    28.660     0.200
    14.487    32.320     0.200
    14.614    30.610     0.200
    14.614    30.184     0.200
    14.725    31.110     0.200
    14.725    31.386     0.200
    14.995    32.594     0.200
    15.164    29.986     0.200
    15.164    29.527     0.200
    15.164    30.742     0.200
    15.559    34.508     0.200
    16.620    33.927     0.200
    17.664    32.825     0.200
    17.733    34.851     0.200
    17.733    34.708     0.200
     8.311    21.169     0.200
     0.302     6.907     0.200
     0.303     6.551     0.200
     0.303     6.661     0.200
     0.303     6.438     0.200
     1.843     8.587     0.200
     1.842     8.796     0.200
     1.842     8.366     0.200
     2.099     8.946     0.200
     2.099     8.356     0.200
     2.714    10.019     0.200
     4.659    14.720     0.200
     4.659    14.388     0.200
     4.693    15.194     0.200
     5.598    16.348     0.200
     6.844    18.658     0.200
     6.844    18.439     0.200
     6.844    18.119     0.200
     6.844    19.068     0.200
     8.005    21.619     0.200
     8.005    20.638     0.200
     8.229    21.456     0.200
     8.267    20.456     0.200
     8.267    22.761     0.200
     8.365    23.223     0.200
     8.365    21.633     0.200
     9.030    22.010     0.200
     9.512    20.537     0.200
    10.030    24.975     0.200
    10.478    24.913     0.200
    10.478    27.257     0.200
    11.176    27.653     0.200
    11.176    24.853     0.200
    12.588    30.283     0.200
    12.588    29.364     0.200
    12.937    30.817     0.200
    13.186    31.836     0.200
    13.260    30.050     0.200
    13.470    32.898     0.200
    13.470    33.105     0.200
    13.470    32.425     0.200
    14.622    33.795     0.200
    14.622    33.502     0.200
    14.622    33.201     0.200
    14.709    31.907     0.200
    15.004    32.291     0.200
    15.182    30.143     0.200
    15.520    34.370     0.200
    17.621    35.048     0.200
    17.690    35.050     0.200
    17.690    34.561     0.200
     8.268    19.967     0.200
     1.459    10.783     0.200
     2.322    12.364     0.200
     4.237    18.517     0.200
     4.237    15.118     0.200
     4.271    17.221     0.200
     7.291    22.233     0.200
     7.291    22.936     0.200
     7.291    25.874     0.200
     8.451    24.513     0.200
     8.809    27.389     0.200
    10.291    27.362     0.200
    10.291    31.956     0.200
    15.276    38.891     0.200
     0.298     6.487     0.200
     0.298     6.291     0.200
     1.842     8.761     0.200
     1.842     9.167     0.200
     1.842     8.752     0.200
     2.147     8.843     0.200
     2.147     8.709     0.200
     2.663    10.282     0.200
     4.530    14.997     0.200
     4.651    14.786     0.200
     4.651    15.126     0.200
     4.651    15.257     0.200
     4.651    14.106     0.200
     4.685    15.721     0.200
     5.645    16.459     0.200
     6.885    18.236     0.200
     6.885    18.411     0.200
     6.885    18.512     0.200
     6.885    19.108     0.200
     8.047    21.001     0.200
     8.047    21.144     0.200
     8.047    20.854     0.200
     8.284    23.688     0.200
     8.319    21.855     0.200
     8.319    23.087     0.200
     8.408    21.444     0.200
     8.408    21.644     0.200
     8.828    24.841     0.200
     9.086    24.532     0.200
     9.538    20.691     0.200
     9.538    20.559     0.200
     9.538    21.300     0.200
     9.538    21.021     0.200
    10.081    26.324     0.200
    10.081    25.297     0.200
    10.511    27.002     0.200
    10.511    26.845     0.200
    11.223    26.240     0.200
    11.223    25.680     0.200
    12.263    29.748     0.200
    12.646    30.181     0.200
    12.646    30.203     0.200
    12.646    29.751     0.200
    12.646    29.991     0.200
    13.241    31.323     0.200
    13.311    29.779     0.200
    13.518    31.621     0.200
    13.518    31.237     0.200
    13.518    30.226     0.200
    13.527    32.564     0.200
    13.527    32.720     0.200
    13.527    32.430     0.200
    14.579    31.521     0.200
    14.759    31.599     0.200
    14.759    31.858     0.200
    14.759    32.009     0.200
    15.195    32.097     0.200
    15.195    32.321     0.200
    17.664    33.803     0.200
    17.664    34.660     0.200
    17.733    34.924     0.200
     8.320    22.053     0.200
     5.399    20.586     0.200
     6.636    23.037     0.200
     6.636    22.907     0.200
     7.798    25.588     0.200
     8.159    26.967     0.200
    14.517    35.738     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     3.169    21.702     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.099     4.431     0.200
     0.206     3.990     0.200
     1.556     9.632     0.200
     0.167     3.948     0.200
     0.253     3.854     0.200
     0.769     5.832     0.200
     1.498     9.225     0.200
     1.812     9.558     0.200
     0.050     4.115     0.200
     0.452     4.824     0.200
     0.115     4.819     0.200
     0.262     3.202     0.200
     0.678     3.533     0.200
     0.740     5.808     0.200
     0.112     2.291     0.200
     0.545     3.634     0.200
     1.649    10.749     0.200
     1.547    11.938     0.200
     1.891    11.926     0.200
     3.082    17.031     0.200
     0.122     3.932     0.200
     0.161     3.766     0.200
     0.591     4.651     0.200
     0.925     6.355     0.200
     1.303     7.447     0.200
     1.647     9.029     0.200
     1.938    10.329     0.200
     0.090     3.829     0.200
     1.574     9.106     0.200
     3.292    17.951     0.200
     0.106     3.697     0.200
     0.792     5.799     0.200
     0.124     4.575     0.200
     1.544     9.997     0.200
     0.078     4.418     0.200
     1.518    10.009     0.200
     1.655     9.412     0.200
     0.074     3.777     0.200
     0.033     4.543     0.200
     0.832     6.016     0.200
     1.465    10.836     0.200
     0.159     4.189     0.200
     0.078     3.371     0.200
     2.180    11.538     0.200
     0.240     4.230     0.200
     1.583    10.861     0.200
     0.037     4.129     0.200
     0.470     4.869     0.200
     0.843     6.120     0.200
     0.243     4.279     0.200
     0.192     3.342     0.200
     1.570    10.357     0.200
     0.118     3.648     0.200
     1.460     8.092     0.200
     0.184     4.125     0.200
     0.929     6.330     0.200
     0.170     3.179     0.200
     0.863     6.187     0.200
     0.267     4.175     0.200
     1.297     8.361     0.200
     0.166     2.703     0.200
     0.494     4.765     0.200
     2.111    12.005     0.200
     0.154     3.506     0.200
     0.450     4.858     0.200
     0.028     4.604     0.200
     1.652    10.349     0.200
     1.985    10.971     0.200
     0.037     4.704     0.200
     0.150     3.725     0.200
     0.437     4.872     0.200
     3.379    17.545     0.200
     0.074     2.283     0.200
     0.390     4.199     0.200
     0.753     5.855     0.200
     0.125     4.331     0.200
     0.250     4.627     0.200
     1.154     6.676     0.200
     1.490     8.256     0.200
     0.070     5.555     0.200
     0.367     3.586     0.200
     0.173     3.972     0.200
     0.270     4.135     0.200
     3.240    16.775     0.200
     0.248     3.984     0.200
     0.088     4.751     0.200
     0.521     4.895     0.200
     0.083     4.576     0.200
     0.088     5.459     0.200
     0.351     4.382     0.200
     0.372     3.434     0.200
     0.169     2.356     0.200
     0.253     3.776     0.200
     0.211     4.065     0.200
     0.346     4.284     0.200
     0.168     2.502     0.200
     0.500     4.627     0.200
     0.593     4.740     0.200
     0.670     4.740     0.200
     0.820     5.796     0.200
     0.911     6.036     0.200
     1.903    11.554     0.200
     0.167     1.186     0.200
     0.503     4.665     0.200
     0.591     4.745     0.200
     0.673     4.787     0.200
     0.820     5.870     0.200
     0.911     6.001     0.200
     1.257     8.263     0.200
     1.905    11.307     0.200
     2.505    12.999     0.200
     0.230     3.298     0.200
     0.020     5.003     0.200
     0.444     4.329     0.200
     0.695     4.499     0.200
     0.895     5.566     0.200
     0.992     7.330     0.200
     1.258     8.829     0.200
     1.592    10.126     0.200
     2.189    11.757     0.200
     0.263     2.798     0.200
     0.264     3.197     0.200
     0.692     4.297     0.200
     0.753     5.386     0.200
     0.776     5.223     0.200
     1.107     8.150     0.200
     1.448     9.271     0.200
     0.260     3.816     0.200
     0.281     3.968     0.200
     0.199     3.924     0.200
     0.307     5.353     0.200
     0.247     3.587     0.200
     0.636     4.550     0.200
     0.698     4.628     0.200
     0.105     3.983     0.200
     0.635     4.500     0.200
     0.208     3.884     0.200
     0.373     3.762     0.200
     0.071     3.933     0.200
     0.329     3.719     0.200
     0.445     3.440     0.200
     0.706     5.394     0.200
     1.255     7.889     0.200
     1.203     9.696     0.200
     1.203     9.246     0.200
     1.823    10.458     0.200
     1.823    10.578     0.200
     0.518     4.286     0.200
     0.680     5.094     0.200
     0.852     4.396     0.200
     3.409    19.749     0.200
     4.169    22.079     0.200
     4.169    23.079     0.200
     0.121     3.473     0.200
     0.510     4.039     0.200
     0.510     4.043     0.200
     0.502     3.828     0.200
     0.648     4.626     0.200
     0.404     4.079     0.200
     0.434     5.524     0.200
     0.588     4.529     0.200
     0.689     4.650     0.200
     0.690     4.740     0.200
     0.690     4.970     0.200
     0.707     4.848     0.200
     0.708     5.137     0.200
     1.138     8.115     0.200
     0.200     1.486     0.200
     0.542     3.792     0.200
     0.542     3.591     0.200
     0.749     4.976     0.200
     0.932     6.638     0.200
     0.196     1.583     0.200
     0.486     4.603     0.200
     0.486     4.502     0.200
     0.486     4.503     0.200
     0.624     4.085     0.200
     0.757     4.832     0.200
     0.148     1.683     0.200
     0.462     4.613     0.200
     0.462     4.314     0.200
     0.603     4.076     0.200
     0.709     5.133     0.200
     0.965     6.252     0.200
     0.193     4.070     0.200
     0.274     4.220     0.200
     0.230     2.885     0.200
     0.310     2.150     0.200
     0.776     5.712     0.200
     0.916     6.181     0.200
     1.009     6.190     0.200
     1.009     6.101     0.200
     1.426    11.730     0.200
     1.426    10.999     0.200
     1.426    10.832     0.200
     1.434    10.840     0.200
     0.096     4.094     0.200
     0.371     5.086     0.200
     0.898     6.132     0.200
     0.078     4.296     0.200
     0.372     4.962     0.200
     0.754     5.211     0.200
     0.805     5.313     0.200
     1.177     7.270     0.200
     0.310     4.469     0.200
     0.367     4.196     0.200
     0.585     5.733     0.200
     0.585     5.355     0.200
     0.760     6.327     0.200
     0.831     5.950     0.200
     0.185     3.746     0.200
     0.286     4.679     0.200
     0.390     3.667     0.200
     0.067     5.396     0.200
     0.320     3.917     0.200
     0.473     4.911     0.200
     0.398     5.256     0.200
     0.706     4.953     0.200
     0.706     5.862     0.200
     0.842     6.660     0.200
     0.010     4.809     0.200
     0.410     4.970     0.200
     0.722     5.217     0.200
     0.899     7.218     0.200
     1.121     7.448     0.200
     1.563     8.788     0.200
     1.563     8.762     0.200
     1.952    11.319     0.200
     0.086     4.235     0.200
     0.432     3.588     0.200
     0.705     4.883     0.200
     1.092     6.770     0.200
     1.856     9.788     0.200
     0.191     4.570     0.200
     0.315     3.862     0.200
     0.595     4.598     0.200
     0.722     6.335     0.200
     0.748     5.568     0.200
     1.213     7.331     0.200
     1.388     7.987     0.200
     0.110     5.004     0.200
     0.291     4.165     0.200
     0.079     4.858     0.200
     0.339     3.647     0.200
     0.064     4.829     0.200
     0.320     3.684     0.200
     0.718     5.136     0.200
     1.072     7.616     0.200
     1.117     7.228     0.200
     1.508     8.453     0.200
     1.509     8.450     0.200
     2.006    10.545     0.200
     0.076     4.899     0.200
     0.311     3.940     0.200
     0.046     4.900     0.200
     0.324     3.554     0.200
     0.704     5.198     0.200
     0.865     7.006     0.200
     1.102     6.692     0.200
     1.102     7.447     0.200
     1.093     7.521     0.200
     0.012     5.604     0.200
     0.186     4.561     0.200
     0.303     3.853     0.200
     0.010     5.855     0.200
     0.188     4.650     0.200
     0.308     3.668     0.200
     0.076     4.894     0.200
     0.326     3.682     0.200
     0.691     5.918     0.200
     0.834     6.832     0.200
     1.056     7.146     0.200
     1.134     6.535     0.200
     0.081     4.772     0.200
     0.343     3.869     0.200
     0.017     4.951     0.200
     0.371     4.025     0.200
     0.699     5.033     0.200
     0.926     7.216     0.200
     0.973     6.372     0.200
     1.093     6.529     0.200
     1.247     7.721     0.200
     0.028     4.817     0.200
     0.379     3.925     0.200
     0.449     4.681     0.200
     0.421     5.055     0.200
     0.659     5.110     0.200
     0.757     5.116     0.200
     0.772     6.151     0.200
     0.963     6.164     0.200
     0.937     7.102     0.200
     0.171     4.602     0.200
     0.312     3.791     0.200
     0.364     4.968     0.200
     0.546     4.867     0.200
     0.741     6.368     0.200
     0.074     4.709     0.200
     0.327     3.745     0.200
     0.692     5.742     0.200
     0.835     6.785     0.200
     1.057     6.865     0.200
     1.500     8.393     0.200
     0.008     5.059     0.200
     0.367     3.775     0.200
     0.666     5.325     0.200
     0.703     4.914     0.200
     0.755     6.174     0.200
     0.980     6.419     0.200
     0.916     7.033     0.200
     1.097     8.139     0.200
     0.109     4.655     0.200
     0.321     3.681     0.200
     0.014     5.535     0.200
     0.102     4.424     0.200
     0.316     3.842     0.200
     0.130     4.725     0.200
     0.291     3.675     0.200
     0.498     4.849     0.200
     0.665     5.848     0.200
     0.779     6.542     0.200
     1.011     6.903     0.200
     1.144     6.711     0.200
     0.057     4.967     0.200
     0.329     3.689     0.200
     0.084     4.484     0.200
     0.331     3.655     0.200
     0.168     4.433     0.200
     0.288     3.489     0.200
     0.741     6.272     0.200
     0.973     6.780     0.200
     0.107     4.427     0.200
     0.297     3.521     0.200
     0.051     4.956     0.200
     0.329     3.681     0.200
     1.014     7.171     0.200
     1.077     8.924     0.200
     0.062     4.755     0.200
     0.327     3.663     0.200
     0.846     6.849     0.200
     1.070     7.321     0.200
     1.510     8.577     0.200
     0.029     4.626     0.200
     0.378     3.837     0.200
     0.661     5.132     0.200
     0.938     7.203     0.200
     1.241     7.642     0.200
     0.088     4.684     0.200
     0.309     3.661     0.200
     0.355     3.306     0.200
     0.338     3.870     0.200
     0.680     4.645     0.200
     0.809     6.776     0.200
     1.016     7.254     0.200
     1.185     8.791     0.200
     1.185     9.060     0.200
     0.197     4.405     0.200
     0.300     3.651     0.200
     0.057     4.802     0.200
     0.326     3.683     0.200
     1.117     7.933     0.200
     2.000    10.778     0.200
     0.009     4.961     0.200
     0.365     3.805     0.200
     0.669     5.162     0.200
     0.917     7.118     0.200
     1.095     6.473     0.200
     0.104     4.518     0.200
     0.295     3.515     0.200
     0.727     5.097     0.200
     0.733     5.236     0.200
     1.127     7.861     0.200
     0.078     4.845     0.200
     0.325     3.690     0.200
     0.048     4.296     0.200
     0.339     3.655     0.200
     0.391     4.763     0.200
     1.123     7.352     0.200
     1.989    10.183     0.200
     0.179     4.427     0.200
     0.312     3.518     0.200
     0.610     5.565     0.200
     0.733     6.097     0.200
     0.955     6.839     0.200
     0.109     4.376     0.200
     0.360     4.280     0.200
     0.519     6.231     0.200
     0.655     5.904     0.200
     0.766     6.435     0.200
     1.166     8.172     0.200
     1.165     7.927     0.200
     3.158    17.365     0.200
     0.041     5.145     0.200
     0.326     3.755     0.200
     0.149     4.585     0.200
     0.305     3.603     0.200
     0.091     4.791     0.200
     0.366     5.123     0.200
     0.614     5.066     0.200
     0.500     4.941     0.200
     0.711     5.569     0.200
     1.010     6.598     0.200
     1.010     6.984     0.200
     1.010     7.115     0.200
     1.010     6.615     0.200
     1.010     7.674     0.200
     0.825     6.211     0.200
     0.983     6.221     0.200
     0.201     4.279     0.200
     0.242     4.361     0.200
     1.145     7.962     0.200
     2.142    10.964     0.200
     0.053     4.470     0.200
     0.403     4.973     0.200
     0.727     5.309     0.200
     0.708     4.922     0.200
     0.798     6.051     0.200
     1.020     6.250     0.200
     1.047     7.092     0.200
     1.047     6.717     0.200
     1.046     6.674     0.200
     0.996     6.217     0.200
     1.400     7.783     0.200
     0.066     4.887     0.200
     0.324     3.689     0.200
     0.036     5.342     0.200
     0.010     5.133     0.200
     0.352     3.811     0.200
     0.679     5.271     0.200
     0.749     6.142     0.200
     0.902     7.112     0.200
     0.997     6.347     0.200
     1.096     6.893     0.200
     1.265     7.815     0.200
     1.950    11.123     0.200
     0.003     5.271     0.200
     0.360     3.881     0.200
     0.411     5.099     0.200
     0.454     4.892     0.200
     0.672     5.324     0.200
     0.703     5.038     0.200
     0.731     5.047     0.200
     0.751     6.166     0.200
     0.908     7.108     0.200
     0.989     6.388     0.200
     1.098     7.201     0.200
     0.079     3.593     0.200
     0.415     3.412     0.200
     0.442     4.669     0.200
     0.443     4.874     0.200
     0.640     5.522     0.200
     0.686     5.209     0.200
     0.802     4.995     0.200
     0.988     7.237     0.200
     1.074     7.201     0.200
     1.074     7.912     0.200
     1.074     7.511     0.200
     1.074     7.721     0.200
     1.863    10.203     0.200
     4.450    22.513     0.200
     0.211     4.397     0.200
     0.311     3.623     0.200
     0.366     4.994     0.200
     0.763     5.242     0.200
     0.115     4.219     0.200
     0.404     4.621     0.200
     1.129     7.429     0.200
     0.065     4.621     0.200
     0.331     3.649     0.200
     0.699     5.887     0.200
     0.845     6.994     0.200
     1.067     7.083     0.200
     1.129     7.102     0.200
     1.129     6.762     0.200
     1.509     8.468     0.200
     0.140     4.554     0.200
     0.299     3.656     0.200
     0.383     5.021     0.200
     0.513     4.985     0.200
     0.616     4.592     0.200
     0.650     5.752     0.200
     0.769     6.451     0.200
     0.758     5.263     0.200
     0.739     5.344     0.200
     0.997     6.703     0.200
     1.252     7.106     0.200
     1.238     7.304     0.200
     1.433     8.185     0.200
     1.433     8.005     0.200
     1.433     8.174     0.200
     1.641     8.853     0.200
     0.148     4.158     0.200
     0.315     3.460     0.200
     0.365     4.974     0.200
     0.763     6.520     0.200
     2.756    13.893     0.200
     0.135     4.721     0.200
     0.327     3.698     0.200
     0.130     4.290     0.200
     0.308     3.435     0.200
     0.377     4.716     0.200
     0.628     4.512     0.200
     0.780     6.366     0.200
     1.159     7.453     0.200
     1.445     8.338     0.200
     1.445     8.385     0.200
     2.758    13.756     0.200
     0.319     3.378     0.200
     0.245     2.692     0.200
     0.413     3.462     0.200
     0.513     4.275     0.200
     0.477     3.584     0.200
     0.763     5.288     0.200
     0.881     6.168     0.200
     0.879     6.667     0.200
     0.914     7.009     0.200
     1.007     6.472     0.200
     0.188     4.585     0.200
     0.316     3.683     0.200
     0.359     5.006     0.200
     0.034     4.681     0.200
     0.345     3.675     0.200
     0.422     4.770     0.200
     0.443     4.983     0.200
     0.671     5.053     0.200
     0.694     5.346     0.200
     0.780     6.058     0.200
     0.920     7.161     0.200
     0.994     6.656     0.200
     1.065     6.595     0.200
     1.066     6.531     0.200
     0.279     3.639     0.200
     0.396     3.693     0.200
     0.396     3.854     0.200
     0.396     3.734     0.200
     0.650     4.723     0.200
     1.744     9.860     0.200
     0.142     3.890     0.200
     0.317     4.699     0.200
     0.367     3.664     0.200
     0.670     4.817     0.200
     1.458     7.931     0.200
     0.065     4.589     0.200
     0.379     3.679     0.200
     0.738     4.960     0.200
     0.913     6.802     0.200
     0.092     3.851     0.200
     0.304     3.694     0.200
     0.288     3.259     0.200
     0.667     4.802     0.200
     0.703     5.400     0.200
     0.667     4.498     0.200
     0.704     5.356     0.200
     0.704     5.528     0.200
     1.081     6.729     0.200
     2.582    12.968     0.200
     0.073     4.180     0.200
     0.413     3.792     0.200
     1.069     6.981     0.200
     0.291     3.750     0.200
     0.493     4.401     0.200
     0.710     6.116     0.200
     0.719     4.921     0.200
     0.921     6.860     0.200
     0.884     6.823     0.200
     0.885     6.567     0.200
     1.026     6.572     0.200
     1.428     7.947     0.200
     0.716     5.803     0.200
     1.904    10.890     0.200
     2.904    16.757     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     0.147    14.004     0.200
     0.147    14.106     0.200
     0.147    13.903     0.200
     0.287    14.667     0.200
     0.287    14.269     0.200
     0.719    15.730     0.200
     1.247    22.064     0.200
     1.192    22.813     0.200
     1.192    22.712     0.200
     1.623    25.175     0.200
     1.623    24.675     0.200
     1.671    27.819     0.200
     1.671    28.116     0.200
     1.834    29.322     0.200
     1.834    29.220     0.200
     1.930    30.396     0.200
     1.930    30.099     0.200
     1.989    33.303     0.200
     1.989    33.405     0.200
     2.079    34.851     0.200
     2.079    34.351     0.200
     2.112    33.267     0.200
     2.112    32.970     0.200
     2.261    34.033     0.200
     2.261    34.237     0.200
     2.710    38.786     0.200
     2.710    39.091     0.200
     2.710    38.989     0.200
     2.924    45.993     0.200
     2.924    45.493     0.200
     3.384    59.122     0.200
     3.396    53.890     0.200
     3.430    53.585     0.200
     4.032    59.169     0.200
     4.032    59.567     0.200
     4.149    61.800     0.200
     4.149    62.199     0.200
     4.301    63.623     0.200
     4.301    63.420     0.200
     4.494    63.072     0.200
     4.494    63.174     0.200
     4.760    67.065     0.200
     5.532    79.962     0.200
     5.552    77.327     0.200
     6.178    85.514     0.200
     6.196    84.311     0.200
     6.392    88.923     0.200
     6.392    89.024     0.200
     6.606    95.630     0.200
     6.606    95.528     0.200
     6.721    93.783     0.200
     6.721    94.181     0.200
     7.025    96.335     0.200
     7.025    95.531     0.200
     7.025    95.632     0.200
     7.288   101.068     0.200
     7.288   100.568     0.200
     7.521   105.842     0.200
     7.823   104.526     0.200
     7.823   104.323     0.200
     7.998   104.275     0.200
     9.767   136.240     0.200
     9.767   133.841     0.200
     9.767   136.638     0.200
     0.469    15.399     0.200
     0.764    18.561     0.200
     0.878    20.223     0.200
     1.788    27.611     0.200
     1.884    30.489     0.200
     1.884    30.989     0.200
     2.204    31.754     0.200
     2.424    37.183     0.200
     2.518    38.885     0.200
     2.532    39.919     0.200
     2.532    39.519     0.200
     2.790    43.917     0.200
     3.034    45.070     0.200
     3.034    44.870     0.200
     3.533    46.241     0.200
     3.335    50.556     0.200
     3.880    61.195     0.200
     3.880    61.495     0.200
     4.353    60.676     0.200
     4.748    65.069     0.200
     4.598    68.819     0.200
     4.647    66.241     0.200
     4.878    71.545     0.200
     5.250    78.209     0.200
     5.826    84.481     0.200
     6.484    88.807     0.200
     6.541    90.138     0.200
     6.709    91.175     0.200
     6.756    92.626     0.200
     6.981    98.003     0.200
     7.302   105.260     0.200
     7.351   101.686     0.200
     7.612   106.639     0.200
     7.829   110.102     0.200
     7.829   110.403     0.200
     7.889   112.405     0.200
     7.889   112.205     0.200
     8.046   113.576     0.200
     8.028   111.783     0.200
     8.028   111.584     0.200
     8.164   111.197     0.200
     8.164   111.597     0.200
     8.320   111.382     0.200
     8.489   112.409     0.200
     8.489   112.210     0.200
     8.651   121.510     0.200
     8.651   121.110     0.200
     8.868   124.984     0.200
     8.868   125.285     0.200
     8.958   127.938     0.200
     9.029   127.099     0.200
     9.029   127.599     0.200
     9.226   129.810     0.200
     9.527   133.288     0.200
     9.581   133.159     0.200
     9.739   125.813     0.200
    10.163   139.171     0.200
    10.226   142.134     0.200
    10.226   142.434     0.200
    10.231   141.082     0.200
    12.003   164.394     0.200
    12.003   164.093     0.200
    12.137   157.837     0.200
    12.137   158.036     0.200
    13.729   177.250     0.200
    13.857   186.757     0.200
    13.857   186.457     0.200
    16.004   208.711     0.200
    16.004   209.111     0.200
    17.807   227.666     0.200
    20.849   277.164     0.200
    20.862   277.208     0.200
     0.123    13.224     0.200
     0.339    13.698     0.200
     0.734    16.090     0.200
     1.162    21.096     0.200
     1.706    27.752     0.200
     1.679    26.065     0.200
     1.884    30.671     0.200
     1.983    34.520     0.200
     2.112    32.009     0.200
     2.076    32.433     0.200
     2.100    32.152     0.200
     2.295    36.877     0.200
     2.939    44.353     0.200
     3.328    48.822     0.200
     3.441    52.495     0.200
     4.037    57.548     0.200
     4.310    64.364     0.200
     4.507    65.060     0.200
     4.906    73.407     0.200
     5.561    77.765     0.200
     6.183    86.504     0.200
     6.205    85.246     0.200
     6.732    94.097     0.200
     6.850   100.719     0.200
     6.977    98.234     0.200
     7.032    95.592     0.200
     7.884   112.655     0.200
    18.013   234.447     0.200
     0.178    13.910     0.200
     0.764    16.064     0.200
     1.221    21.736     0.200
     1.629    24.975     0.200
     1.715    28.974     0.200
     1.826    29.669     0.200
     2.030    33.289     0.200
     2.044    34.132     0.200
     2.136    32.055     0.200
     2.235    34.907     0.200
     2.886    44.303     0.200
     3.282    48.687     0.200
     3.990    56.424     0.200
     4.260    63.264     0.200
     4.591    68.405     0.200
     4.806    69.897     0.200
     4.856    71.317     0.200
     5.511    76.669     0.200
     6.136    85.374     0.200
     6.155    85.151     0.200
     6.350    87.878     0.200
     6.795    94.689     0.200
     0.122    16.699     0.200
     0.739    15.499     0.200
     1.157    21.613     0.200
     1.713    26.122     0.200
     1.690    26.399     0.200
     1.893    30.020     0.200
     1.982    31.982     0.200
     2.121    32.361     0.200
     2.069    31.969     0.200
     2.103    34.575     0.200
     2.301    37.266     0.200
     2.942    44.788     0.200
     3.430    47.091     0.200
     3.328    48.284     0.200
     3.443    53.941     0.200
     6.183    85.966     0.200
     6.853   101.147     0.200
     8.425   118.798     0.200
     0.129    13.694     0.200
     0.309    14.585     0.200
     0.716    15.840     0.200
     1.173    21.501     0.200
     1.645    25.995     0.200
     1.677    27.624     0.200
     1.856    29.538     0.200
     1.978    32.108     0.200
     2.079    30.929     0.200
     2.092    31.779     0.200
     2.094    34.754     0.200
     2.261    35.806     0.200
     2.280    36.592     0.200
     2.720    41.457     0.200
     2.938    44.914     0.200
     3.143    45.513     0.200
     3.334    49.293     0.200
     3.442    54.023     0.200
     4.312    61.869     0.200
     4.543    67.176     0.200
     4.646    69.977     0.200
     4.760    66.649     0.200
     5.563    77.274     0.200
     6.188    84.979     0.200
     6.402    88.483     0.200
     6.920    96.437     0.200
     7.693   101.414     0.200
     9.205   127.775     0.200
     0.233    14.376     0.200
     0.197    13.795     0.200
     0.733    16.538     0.200
     1.239    23.637     0.200
     1.571    24.762     0.200
     1.662    28.690     0.200
     1.779    29.327     0.200
     2.049    31.180     0.200
     2.020    34.518     0.200
     2.040    34.281     0.200
     2.192    33.514     0.200
     2.162    33.858     0.200
     2.212    34.272     0.200
     2.739    42.122     0.200
     2.888    43.384     0.200
     3.213    47.593     0.200
     3.398    52.439     0.200
     4.767    68.462     0.200
     6.924    97.292     0.200
     8.306   116.156     0.200
     0.110    14.767     0.200
     0.970    19.726     0.200
     1.687    26.354     0.200
     1.829    29.697     0.200
     2.072    30.872     0.200
     2.285    35.379     0.200
     2.475    40.161     0.200
     2.929    43.866     0.200
     3.612    54.899     0.200
     4.340    68.396     0.200
     4.696    64.243     0.200
     7.101    97.177     0.200
     7.486   100.689     0.200
     0.178    15.582     0.200
     0.599    14.670     0.200
     0.964    19.405     0.200
     1.197    18.688     0.200
     1.374    22.628     0.200
     1.690    26.933     0.200
     1.618    27.780     0.200
     1.859    28.963     0.200
     1.743    28.314     0.200
     1.843    30.150     0.200
     1.978    28.572     0.200
     2.304    37.767     0.200
     2.479    37.729     0.200
     2.553    37.862     0.200
     2.610    42.196     0.200
     3.088    47.623     0.200
     3.790    61.423     0.200
     3.781    55.537     0.200
     4.027    58.659     0.200
     4.186    63.804     0.200
     4.870    69.820     0.200
     5.925    83.510     0.200
     6.128    86.144     0.200
     6.291    94.245     0.200
     6.483    91.003     0.200
     6.529    96.463     0.200
     7.941   112.990     0.200
    18.224   236.987     0.200
     1.498    23.305     0.200
     1.460    25.754     0.200
     1.916    31.431     0.200
     2.782    45.323     0.200
     2.939    44.491     0.200
     3.311    55.148     0.200
     3.448    49.551     0.200
     4.908    73.508     0.200
     0.511    13.745     0.200
     1.225    19.411     0.200
     1.472    24.525     0.200
     1.812    31.558     0.200
     1.944    31.019     0.200
     2.111    36.073     0.200
     2.684    41.386     0.200
     2.812    44.883     0.200
     3.293    52.277     0.200
     3.460    51.325     0.200
     4.232    63.320     0.200
     4.908    74.425     0.200
    10.988   151.478     0.200
     0.146    13.438     0.200
     0.287    13.795     0.200
     0.718    16.768     0.200
     1.191    22.247     0.200
     1.670    27.653     0.200
     1.834    29.746     0.200
     1.988    32.943     0.200
     2.068    33.009     0.200
     2.111    33.505     0.200
     2.080    32.871     0.200
     2.240    34.004     0.200
     2.261    36.759     0.200
     2.693    41.714     0.200
     2.711    40.509     0.200
     2.925    44.014     0.200
     3.163    45.239     0.200
     3.325    49.345     0.200
     4.302    59.939     0.200
     4.495    62.694     0.200
     4.560    69.929     0.200
     4.759    67.603     0.200
     4.897    71.998     0.200
     5.553    78.347     0.200
     6.179    86.034     0.200
     6.197    84.830     0.200
     6.393    87.544     0.200
     6.716    91.772     0.200
     6.722    94.701     0.200
     6.919    98.403     0.200
     7.166   103.519     0.200
     7.522   105.362     0.200
     8.357   117.617     0.200
    18.008   231.993     0.200
     0.356    12.926     0.200
     0.562    14.030     0.200
     1.086    19.912     0.200
     1.630    25.564     0.200
     1.630    25.064     0.200
     1.945    29.888     0.200
     1.945    30.287     0.200
     1.842    29.090     0.200
     1.882    29.624     0.200
     1.882    29.425     0.200
     2.213    33.757     0.200
     2.213    33.257     0.200
     2.021    32.004     0.200
     2.213    36.757     0.200
     2.213    36.456     0.200
     2.367    38.963     0.200
     2.367    38.463     0.200
     2.862    43.190     0.200
     2.862    42.991     0.200
     3.240    51.882     0.200
     3.245    51.715     0.200
     3.064    47.827     0.200
     3.064    47.628     0.200
     3.518    57.536     0.200
     3.476    54.026     0.200
     3.476    53.827     0.200
     3.575    55.863     0.200
     4.182    61.781     0.200
     4.182    61.383     0.200
     4.280    67.644     0.200
     4.280    68.042     0.200
     4.449    67.666     0.200
     4.449    67.466     0.200
     4.636    68.481     0.200
     4.636    68.781     0.200
     5.453    83.946     0.200
     5.453    84.146     0.200
     5.684    81.259     0.200
     6.541    92.247     0.200
     6.869    95.429     0.200
     6.999   102.903     0.200
     6.999   103.102     0.200
     7.109   101.627     0.200
     7.109   102.025     0.200
     7.437   106.802     0.200
     8.343   116.224     0.200
     9.253   119.005     0.200
     9.419   132.669     0.200
     9.419   132.169     0.200
     9.622   125.297     0.200
     9.795   137.281     0.200
     9.795   136.980     0.200
    10.269   140.748     0.200
    10.269   140.947     0.200
    20.518   271.146     0.200
     0.052    11.453     0.200
     0.416    12.202     0.200
     0.585    13.231     0.200
     1.954    30.254     0.200
     1.962    33.157     0.200
     2.243    37.881     0.200
     2.416    39.860     0.200
     3.088    48.023     0.200
     0.082    12.189     0.200
     0.570    12.492     0.200
     1.678    24.562     0.200
     1.829    31.792     0.200
     1.926    30.667     0.200
     1.983    32.995     0.200
     2.234    36.068     0.200
     2.399    37.147     0.200
     2.870    42.649     0.200
     3.082    46.178     0.200
     3.484    51.485     0.200
     3.589    58.252     0.200
     4.191    60.226     0.200
     6.338    89.173     0.200
     0.107    10.565     0.200
     0.415    12.972     0.200
     0.535    13.567     0.200
     1.028    20.816     0.200
     1.683    24.172     0.200
     1.796    29.855     0.200
     1.940    30.177     0.200
     1.962    31.915     0.200
     2.265    36.380     0.200
     2.424    39.522     0.200
     3.114    49.476     0.200
     0.124    11.863     0.200
     0.385    12.812     0.200
     0.539    12.018     0.200
     1.057    20.964     0.200
     1.813    30.141     0.200
     1.907    30.055     0.200
     1.993    31.046     0.200
     2.243    37.133     0.200
     2.396    39.342     0.200
     3.093    48.207     0.200
     0.124    12.990     0.200
     0.361    14.226     0.200
     1.154    22.970     0.200
     1.702    25.575     0.200
     1.904    30.219     0.200
     1.985    32.273     0.200
     2.064    32.349     0.200
     2.105    33.870     0.200
     2.306    37.520     0.200
     2.942    44.098     0.200
     6.440    85.284     0.200
     6.854   100.448     0.200
     6.932    94.533     0.200
     0.155    14.033     0.200
     0.278    15.599     0.200
     1.615    25.001     0.200
     1.825    29.551     0.200
     1.995    32.568     0.200
     2.066    32.733     0.200
     2.072    33.658     0.200
     2.120    34.098     0.200
     2.252    37.559     0.200
     2.918    44.794     0.200
     3.171    45.934     0.200
     3.319    49.109     0.200
     3.424    53.880     0.200
     4.296    60.711     0.200
     4.569    69.529     0.200
     4.671    69.726     0.200
     6.824    96.206     0.200
     6.921    98.277     0.200
     6.915    94.151     0.200
     0.201    14.466     0.200
     0.234    15.082     0.200
     1.245    23.287     0.200
     1.575    24.434     0.200
     1.677    27.248     0.200
     1.780    29.048     0.200
     2.031    35.112     0.200
     2.063    30.745     0.200
     2.031    33.118     0.200
     2.199    33.155     0.200
     2.206    36.068     0.200
     2.671    40.642     0.200
     2.878    43.232     0.200
     3.397    52.173     0.200
     3.285    49.477     0.200
     3.344    52.794     0.200
     3.387    53.295     0.200
     4.259    61.109     0.200
     5.493    80.711     0.200
     5.509    76.521     0.200
     6.351    89.696     0.200
     6.394    84.198     0.200
     6.783    99.664     0.200
     6.876    92.569     0.200
     0.122    15.097     0.200
     0.324    14.734     0.200
     1.165    21.919     0.200
     1.688    25.818     0.200
     1.662    25.129     0.200
     1.870    30.693     0.200
     1.977    33.443     0.200
     2.093    34.096     0.200
     2.082    32.221     0.200
     2.100    34.018     0.200
     2.278    35.933     0.200
     2.289    37.807     0.200
     2.720    39.779     0.200
     2.941    43.196     0.200
     3.334    49.616     0.200
     3.419    53.614     0.200
     4.042    56.348     0.200
     4.314    61.176     0.200
     4.510    63.893     0.200
     4.910    72.225     0.200
     5.342    78.178     0.200
     5.565    78.579     0.200
     6.188    85.300     0.200
     6.209    86.061     0.200
     6.403    85.799     0.200
     6.446    86.095     0.200
     6.735    94.919     0.200
     6.935    93.589     0.200
     7.037    95.398     0.200
     7.261   101.283     0.200
     7.464   104.413     0.200
     0.113    13.903     0.200
     0.334    15.322     0.200
     1.156    21.733     0.200
     1.689    26.517     0.200
     1.671    25.724     0.200
     1.880    31.279     0.200
     1.971    32.228     0.200
     2.095    32.771     0.200
     2.072    34.041     0.200
     2.108    34.624     0.200
     2.287    33.540     0.200
     2.299    38.399     0.200
     2.726    41.408     0.200
     2.949    44.808     0.200
     3.123    46.876     0.200
     3.340    49.246     0.200
     3.452    54.939     0.200
     4.049    57.975     0.200
     4.321    61.799     0.200
     4.517    65.509     0.200
     4.629    65.305     0.200
     4.917    72.846     0.200
     5.572    78.201     0.200
     6.195    84.929     0.200
     6.216    84.683     0.200
     6.409    86.426     0.200
     6.859    99.185     0.200
     7.675   100.952     0.200
     8.405   119.142     0.200
     0.119    14.055     0.200
     0.354    14.309     0.200
     1.153    21.986     0.200
     1.715    25.433     0.200
     1.695    26.670     0.200
     1.898    30.290     0.200
     1.980    33.336     0.200
     2.124    32.662     0.200
     2.106    34.863     0.200
     2.658    40.824     0.200
     2.945    44.080     0.200
     3.116    45.084     0.200
     3.445    54.237     0.200
     4.626    68.958     0.200
     4.785    68.606     0.200
     6.856    99.436     0.200
     0.085    10.246     0.200
     1.028    20.240     0.200
     1.548    24.177     0.200
     1.615    24.586     0.200
     1.807    32.151     0.200
     1.947    30.517     0.200
     2.258    36.888     0.200
     2.525    40.571     0.200
     3.010    44.509     0.200
     3.612    57.083     0.200
     4.601    65.547     0.200
     4.496    66.973     0.200
     0.156    14.668     0.200
     0.284    14.175     0.200
     1.201    22.474     0.200
     1.621    27.866     0.200
     1.622    24.553     0.200
     1.829    29.135     0.200
     2.000    35.140     0.200
     2.078    32.238     0.200
     2.120    35.745     0.200
     2.242    34.323     0.200
     2.252    37.202     0.200
     2.703    42.537     0.200
     2.699    38.991     0.200
     2.913    45.487     0.200
     3.171    45.780     0.200
     3.313    47.827     0.200
     3.419    53.583     0.200
     4.290    60.419     0.200
     4.570    65.753     0.200
     4.772    67.799     0.200
     6.167    85.516     0.200
     6.380    88.025     0.200
     6.820    98.890     0.200
     6.931    92.600     0.200
     6.909    93.153     0.200
     7.014    95.632     0.200
    18.477   235.754     0.200
     0.141    15.416     0.200
     0.172    13.455     0.200
     0.424    14.122     0.200
     0.711    16.766     0.200
     1.303    21.463     0.200
     1.311    20.766     0.200
     1.388    24.865     0.200
     1.497    24.595     0.200
     1.559    24.873     0.200
     1.995    32.779     0.200
     2.715    40.378     0.200
     2.863    44.852     0.200
     3.390    55.510     0.200
     3.377    48.655     0.200
     7.890   105.792     0.200
     0.478    17.129     0.200
     0.707    18.456     0.200
     1.129    23.538     0.200
     1.291    25.642     0.200
     1.850    28.119     0.200
     1.934    32.242     0.200
     2.253    32.223     0.200
     2.338    35.931     0.200
     3.784    56.745     0.200
     3.884    57.689     0.200
     4.109    60.758     0.200
     6.912    89.952     0.200
     7.560   103.485     0.200
     7.585   100.790     0.200
     1.302    21.293     0.200
     1.515    25.815     0.200
     1.459    26.468     0.200
     1.892    31.416     0.200
     1.936    32.898     0.200
     1.928    32.991     0.200
     2.003    32.120     0.200
     2.605    42.091     0.200
     3.445    50.583     0.200
     4.166    62.881     0.200
     4.810    71.860     0.200
     1.230    19.500     0.200
     1.303    18.958     0.200
     1.437    23.084     0.200
     1.872    32.008     0.200
     1.839    30.401     0.200
     1.917    31.484     0.200
     2.570    40.872     0.200
     2.706    41.286     0.200
     3.179    47.757     0.200
     3.236    52.096     0.200
     3.520    50.983     0.200
     3.873    56.656     0.200
     4.121    59.763     0.200
     4.282    65.893     0.200
     4.880    72.914     0.200
     6.482    97.212     0.200
     6.578    93.089     0.200
    18.584   239.980     0.200
     0.268    14.894     0.200
     0.166    14.678     0.200
     1.210    22.391     0.200
     1.605    23.982     0.200
     1.672    27.308     0.200
     1.814    28.348     0.200
     2.065    30.812     0.200
     2.003    32.637     0.200
     2.062    33.947     0.200
     2.132    35.340     0.200
     2.241    37.660     0.200
     2.697    41.341     0.200
     2.908    44.078     0.200
     3.311    48.576     0.200
     3.415    53.159     0.200
     4.018    57.725     0.200
     4.478    66.253     0.200
     4.579    68.576     0.200
     5.537    78.093     0.200
     6.165    83.568     0.200
     6.378    87.583     0.200
     6.421    86.082     0.200
     6.703    90.895     0.200
     6.814    94.494     0.200
     6.905    93.430     0.200
     7.011    96.194     0.200
     0.169    15.293     0.200
     0.469    15.492     0.200
     0.721    17.144     0.200
     1.266    19.585     0.200
     1.475    24.047     0.200
     1.420    23.888     0.200
     1.521    24.811     0.200
     1.803    26.221     0.200
     1.871    28.121     0.200
     2.063    32.987     0.200
     1.988    34.161     0.200
     2.068    35.026     0.200
     2.889    43.845     0.200
     2.720    41.318     0.200
     2.856    46.035     0.200
     3.189    46.846     0.200
     3.248    52.162     0.200
     3.409    47.579     0.200
     3.330    51.199     0.200
     4.025    57.894     0.200
     4.273    61.700     0.200
     4.641    63.900     0.200
     4.432    65.741     0.200
     4.752    70.110     0.200
     5.534    77.480     0.200
     6.157    87.214     0.200
     6.170    87.060     0.200
     6.780    91.235     0.200
     6.633    94.651     0.200
     6.670    93.226     0.200
     6.725    94.587     0.200
     6.733    91.888     0.200
     6.865    94.253     0.200
     6.905    97.279     0.200
     7.021   103.129     0.200
     6.998    96.594     0.200
     7.261   101.628     0.200
     7.376   104.990     0.200
     9.477   122.769     0.200
    13.324   174.271     0.200
     0.109    14.514     0.200
     0.376    14.802     0.200
     1.136    22.434     0.200
     1.720    27.021     0.200
     1.715    26.572     0.200
     1.920    30.282     0.200
     1.969    32.008     0.200
     2.133    35.101     0.200
     2.046    35.116     0.200
     2.122    34.719     0.200
     2.332    34.569     0.200
     2.324    33.862     0.200
     2.641    38.972     0.200
     2.727    42.361     0.200
     3.096    47.053     0.200
     3.341    51.003     0.200
     3.459    52.626     0.200
     3.698    56.933     0.200
     4.050    58.721     0.200
     4.506    67.400     0.200
     4.525    66.178     0.200
     4.783    67.171     0.200
     5.576    78.913     0.200
     6.949    93.594     0.200
     0.139    14.108     0.200
     0.338    14.495     0.200
     0.753    15.552     0.200
     1.175    22.622     0.200
     1.680    26.730     0.200
     1.723    27.231     0.200
     1.880    30.496     0.200
     2.000    32.597     0.200
     2.127    33.407     0.200
     2.087    34.783     0.200
     2.085    34.506     0.200
     2.302    34.472     0.200
     2.284    37.687     0.200
     2.697    41.868     0.200
     2.924    45.421     0.200
     3.310    48.707     0.200
     4.019    59.431     0.200
     4.137    63.155     0.200
     4.293    64.039     0.200
     4.491    64.930     0.200
     4.546    69.287     0.200
     5.544    77.244     0.200
     6.411    87.522     0.200
     6.834    96.577     0.200
    18.488   234.576     0.200
     0.173    14.359     0.200
     0.278    14.828     0.200
     0.752    16.299     0.200
     1.218    22.669     0.200
     1.526    25.666     0.200
     1.621    26.164     0.200
     1.701    27.533     0.200
     1.822    30.215     0.200
     2.022    33.985     0.200
     2.094    33.739     0.200
     2.135    32.364     0.200
     2.050    33.660     0.200
     2.236    37.781     0.200
     2.640    42.268     0.200
     2.677    41.138     0.200
     2.893    44.317     0.200
     3.186    45.900     0.200
     3.286    48.729     0.200
     3.291    49.673     0.200
     3.420    51.168     0.200
     3.368    52.775     0.200
     3.623    58.798     0.200
     3.999    57.312     0.200
     4.102    61.204     0.200
     4.269    61.260     0.200
     4.462    64.004     0.200
     4.588    66.542     0.200
     4.651    68.405     0.200
     4.793    68.141     0.200
     4.864    72.316     0.200
     5.498    79.912     0.200
     5.519    76.666     0.200
     6.145    86.361     0.200
     6.164    85.650     0.200
     6.574    94.857     0.200
     6.689    93.118     0.200
     6.888    93.990     0.200
     6.993    94.776     0.200
     7.255   100.809     0.200
     7.791   102.463     0.200
     7.836   110.631     0.200
     7.886   102.052     0.200
    12.333   165.652     0.200
     1.132    20.928     0.200
     1.269    23.227     0.200
     1.866    31.065     0.200
     2.037    34.070     0.200
     2.182    34.372     0.200
     2.802    42.138     0.200
     2.899    45.004     0.200
     2.894    44.071     0.200
     3.463    53.324     0.200
     3.480    52.232     0.200
     3.822    55.337     0.200
     4.139    61.535     0.200
     0.161    14.376     0.200
     0.278    14.713     0.200
     0.731    16.419     0.200
     1.205    22.980     0.200
     1.515    26.170     0.200
     1.616    25.683     0.200
     1.680    28.646     0.200
     1.824    29.469     0.200
     2.003    32.371     0.200
     2.075    32.932     0.200
     2.065    32.855     0.200
     2.125    32.747     0.200
     2.236    34.254     0.200
     2.247    37.129     0.200
     2.696    40.786     0.200
     2.910    44.294     0.200
     3.176    46.387     0.200
     3.399    51.583     0.200
     3.305    49.383     0.200
     3.310    48.021     0.200
     3.381    51.789     0.200
     3.416    51.386     0.200
     3.638    58.594     0.200
     4.018    56.365     0.200
     4.118    62.197     0.200
     4.287    64.118     0.200
     4.479    65.373     0.200
     4.575    66.863     0.200
     4.668    67.780     0.200
     5.538    78.330     0.200
     6.164    86.210     0.200
     6.182    84.407     0.200
     6.816    98.701     0.200
     6.931    94.967     0.200
     6.906    93.656     0.200
     7.011    97.431     0.200
     7.274   100.367     0.200
     7.904   103.114     0.200
     0.344    14.704     0.200
     0.729    15.915     0.200
     1.155    22.238     0.200
     1.462    25.258     0.200
     1.889    30.274     0.200
     1.976    32.658     0.200
     2.110    33.696     0.200
     2.069    33.174     0.200
     2.107    34.338     0.200
     2.300    36.480     0.200
     2.301    37.463     0.200
     2.705    42.752     0.200
     2.721    41.572     0.200
     2.946    43.938     0.200
     3.330    50.459     0.200
     3.334    48.411     0.200
     4.043    57.136     0.200
     4.704    67.426     0.200
     5.567    78.352     0.200
     5.927    82.156     0.200
     6.189    85.093     0.200
     6.857    95.304     0.200
     6.938    93.951     0.200
     7.933   104.239     0.200
    18.464   236.844     0.200
     0.898    22.221     0.200
     1.435    28.245     0.200
     1.891    35.926     0.200
     2.317    41.959     0.200
     2.535    42.311     0.200
     2.675    46.678     0.200
     3.145    54.292     0.200
     4.899    79.824     0.200
     0.181    13.128     0.200
     0.328    14.710     0.200
     0.710    15.955     0.200
     1.156    22.148     0.200
     1.465    25.147     0.200
     1.678    27.656     0.200
     1.875    30.568     0.200
     1.960    30.375     0.200
     1.966    32.400     0.200
     2.084    30.916     0.200
     2.074    34.039     0.200
     2.110    34.417     0.200
     2.298    36.430     0.200
     2.701    43.718     0.200
     2.731    41.368     0.200
     2.952    43.793     0.200
     3.345    48.205     0.200
     3.429    52.224     0.200
     4.710    67.076     0.200
     5.576    78.171     0.200
     6.861   100.177     0.200
     6.946    93.385     0.200
     1.438    24.286     0.200
     1.773    30.470     0.200
     1.920    31.956     0.200
     1.881    33.013     0.200
     2.002    32.991     0.200
     1.891    32.297     0.200
     2.498    41.212     0.200
     2.491    41.295     0.200
     2.637    42.589     0.200
     3.092    51.276     0.200
     3.164    52.438     0.200
     3.548    53.455     0.200
     3.797    59.047     0.200
     4.922    76.126     0.200
    12.648   171.754     0.200
     1.192    20.934     0.200
     1.386    23.681     0.200
     1.647    29.629     0.200
     1.845    30.314     0.200
     2.651    43.910     0.200
     3.048    50.284     0.200
     3.131    52.012     0.200
     3.828    61.173     0.200
     3.824    59.229     0.200
     4.070    59.560     0.200
     4.227    65.519     0.200
     4.653    70.549     0.200
     5.275    83.395     0.200
     5.953    88.383     0.200
     5.968    86.206     0.200
     6.534    93.002     0.200
     7.171   106.166     0.200
     7.569   110.921     0.200
     7.851   108.226     0.200
     8.439   121.864     0.200
    11.108   155.214     0.200
    11.311   157.348     0.200
    12.264   169.234     0.200
    13.139   177.517     0.200
    13.517   180.102     0.200
    13.762   183.851     0.200
    15.006   202.730     0.200
    15.343   204.803     0.200
    18.633   240.406     0.200
    19.335   250.716     0.200
     0.478    13.794     0.200
     0.809    18.331     0.200
     1.490    23.989     0.200
     1.792    30.566     0.200
     1.898    30.229     0.200
     1.996    32.082     0.200
     2.398    38.089     0.200
     2.412    39.223     0.200
     2.621    43.782     0.200
     2.763    42.124     0.200
     3.223    52.766     0.200
     3.232    49.658     0.200
     3.292    52.951     0.200
     0.792    17.500     0.200
     1.783    29.726     0.200
     1.872    32.693     0.200
     1.915    30.186     0.200
     2.009    34.098     0.200
     2.411    38.408     0.200
     2.405    39.175     0.200
     2.782    44.074     0.200
     3.243    50.693     0.200
     3.252    50.583     0.200
     3.312    52.893     0.200
     1.427    23.573     0.200
     1.866    29.241     0.200
     1.828    29.891     0.200
     1.922    30.587     0.200
     2.483    40.046     0.200
     2.560    42.144     0.200
     2.695    41.575     0.200
     3.027    45.397     0.200
     3.160    49.145     0.200
     3.170    49.031     0.200
     3.225    53.381     0.200
     3.864    59.934     0.200
     0.514    13.726     0.200
     1.470    23.073     0.200
     1.825    29.933     0.200
     1.925    31.262     0.200
     1.939    30.096     0.200
     2.342    36.392     0.200
     2.453    40.099     0.200
     2.689    41.349     0.200
     3.143    50.052     0.200
     3.152    49.947     0.200
     3.216    53.200     0.200
     0.828    18.985     0.200
     1.274    21.272     0.200
     1.488    25.083     0.200
     1.909    31.760     0.200
     1.916    33.283     0.200
     1.983    32.506     0.200
     2.166    37.667     0.200
     2.385    38.808     0.200
     2.420    37.403     0.200
     2.600    41.307     0.200
     2.744    45.120     0.200
     3.152    51.863     0.200
     3.210    49.681     0.200
     3.272    52.457     0.200
     3.469    50.662     0.200
     3.906    59.757     0.200
     4.320    67.227     0.200
     4.831    73.270     0.200
     6.042    88.129     0.200
     6.052    85.017     0.200
     6.546    97.254     0.200
     6.621    96.374     0.200
     6.882    99.326     0.200
    10.958   154.467     0.200
    12.551   169.472     0.200
     0.462    13.543     0.200
     1.517    24.624     0.200
     1.465    26.836     0.200
     1.626    29.261     0.200
     1.782    31.136     0.200
     1.952    34.145     0.200
     1.876    31.036     0.200
     1.994    33.665     0.200
     2.397    37.961     0.200
     2.400    39.918     0.200
     2.585    42.760     0.200
     2.739    44.964     0.200
     3.188    53.725     0.200
     3.264    53.833     0.200
     1.403    23.859     0.200
     1.840    29.564     0.200
     1.926    32.362     0.200
     1.875    30.954     0.200
     1.921    31.720     0.200
     2.322    37.035     0.200
     2.496    39.703     0.200
     2.583    39.688     0.200
     2.709    40.224     0.200
     3.182    48.707     0.200
     3.192    48.587     0.200
     3.242    52.002     0.200
     3.884    58.308     0.200
     4.897    74.490     0.200
     6.260    86.782     0.200
     0.842    19.759     0.200
     1.477    24.049     0.200
     1.906    32.348     0.200
     1.924    32.534     0.200
     1.865    31.525     0.200
     1.969    33.010     0.200
     2.371    38.312     0.200
     2.433    39.592     0.200
     2.586    41.802     0.200
     2.730    44.126     0.200
     3.188    52.386     0.200
     3.197    51.677     0.200
     4.845    76.447     0.200
     0.610    15.016     0.200
     0.859    19.501     0.200
     1.358    22.488     0.200
     1.583    27.861     0.200
     1.870    30.413     0.200
     1.903    33.120     0.200
     2.527    42.846     0.200
     2.633    40.599     0.200
     2.741    43.350     0.200
     3.228    52.657     0.200
     3.240    51.525     0.200
     3.279    54.071     0.200
     3.928    59.895     0.200
     0.470    13.471     0.200
     1.510    24.734     0.200
     1.865    30.194     0.200
     1.949    32.912     0.200
     2.387    36.910     0.200
     2.409    38.844     0.200
     2.575    41.915     0.200
     2.728    44.123     0.200
     3.177    50.880     0.200
     3.186    49.779     0.200
     3.254    50.991     0.200
     3.884    58.637     0.200
     4.304    66.732     0.200
     6.024    87.661     0.200
     6.030    86.589     0.200
     6.266    87.836     0.200
     6.736    93.246     0.200
     0.664    16.175     0.200
     1.306    22.875     0.200
     1.763    29.843     0.200
     1.758    29.401     0.200
     1.824    28.837     0.200
     2.225    37.159     0.200
     2.520    39.616     0.200
     2.597    42.813     0.200
     2.629    41.442     0.200
     3.114    49.774     0.200
     3.126    49.643     0.200
     3.166    50.176     0.200
     3.814    60.613     0.200
     4.204    65.962     0.200
     0.585    15.457     0.200
     0.870    19.829     0.200
     1.381    24.564     0.200
     1.852    32.066     0.200
     1.847    31.426     0.200
     1.915    32.328     0.200
     2.316    37.152     0.200
     2.599    41.349     0.200
     2.717    44.975     0.200
     3.196    51.383     0.200
     3.207    52.259     0.200
     3.252    54.729     0.200
     3.897    60.203     0.200
    21.552   281.765     0.200
     0.823    18.921     0.200
     1.460    25.990     0.200
     1.499    26.932     0.200
     1.867    32.530     0.200
     1.878    33.305     0.200
     1.818    30.809     0.200
     1.885    31.023     0.200
     1.975    32.080     0.200
     2.439    38.559     0.200
     2.617    40.682     0.200
     2.752    43.903     0.200
     2.977    46.282     0.200
     3.217    51.476     0.200
     3.227    51.363     0.200
     3.283    52.708     0.200
     3.487    50.228     0.200
     3.921    59.263     0.200
     4.328    67.510     0.200
     4.841    74.527     0.200
     6.623    95.728     0.200
     0.204    11.792     0.200
     0.607    14.882     0.200
     0.896    19.010     0.200
     1.359    22.109     0.200
     1.582    28.510     0.200
     1.595    28.254     0.200
     1.822    28.414     0.200
     1.889    30.925     0.200
     2.238    37.248     0.200
     2.290    37.249     0.200
     2.537    39.866     0.200
     2.576    41.904     0.200
     2.692    41.559     0.200
     3.068    48.661     0.200
     3.173    48.945     0.200
     3.183    48.818     0.200
     3.584    52.349     0.200
     4.931    75.421     0.200
     0.609    15.566     0.200
     1.365    23.344     0.200
     1.819    29.936     0.200
     1.782    29.866     0.200
     1.865    30.899     0.200
     2.528    39.162     0.200
     2.651    41.728     0.200
     3.126    49.189     0.200
     3.136    48.067     0.200
     3.185    52.501     0.200
     3.828    58.000     0.200
     0.567    15.146     0.200
     0.863    19.987     0.200
     1.400    24.924     0.200
     1.555    28.612     0.200
     1.865    32.990     0.200
     1.850    30.464     0.200
     1.926    33.285     0.200
     2.597    40.455     0.200
     2.719    44.022     0.200
     3.194    51.479     0.200
     3.205    51.357     0.200
     3.896    58.988     0.200
    21.554   283.224     0.200
     0.669    16.984     0.200
     1.297    23.861     0.200
     1.652    29.411     0.200
     1.847    32.936     0.200
     1.793    29.963     0.200
     1.843    32.985     0.200
     2.278    39.111     0.200
     2.595    41.210     0.200
     2.564    41.973     0.200
     2.665    43.894     0.200
     3.157    51.648     0.200
     3.169    49.512     0.200
     3.641    54.999     0.200
     4.093    63.726     0.200
     4.982    77.348     0.200
     0.230    14.256     0.200
     0.324    14.161     0.200
     0.761    16.267     0.200
     1.191    23.851     0.200
     1.497    26.580     0.200
     1.726    27.706     0.200
     1.865    30.379     0.200
     2.013    30.157     0.200
     2.102    33.512     0.200
     2.070    33.790     0.200
     2.292    35.304     0.200
     2.268    36.583     0.200
     2.671    43.873     0.200
     2.684    41.626     0.200
     2.909    44.097     0.200
     3.293    49.615     0.200
     3.297    47.566     0.200
     3.645    58.012     0.200
     4.477    65.005     0.200
     6.820    98.461     0.200
     0.769    18.964     0.200
     1.473    26.243     0.200
     1.841    32.153     0.200
     1.943    34.254     0.200
     2.683    44.326     0.200
     2.812    46.819     0.200
     3.282    54.333     0.200
     3.292    54.217     0.200
     0.733    18.050     0.200
     1.518    26.085     0.200
     1.746    30.034     0.200
     1.878    31.495     0.200
     1.976    32.851     0.200
     2.368    39.369     0.200
     2.460    38.797     0.200
     2.706    44.829     0.200
     2.843    45.331     0.200
     3.307    54.819     0.200
     3.316    53.709     0.200
     1.522    25.269     0.200
     1.859    30.234     0.200
     1.969    31.952     0.200
     1.979    34.038     0.200
     1.985    30.771     0.200
     2.388    39.064     0.200
     2.404    38.878     0.200
     2.563    40.821     0.200
     2.721    44.277     0.200
     2.961    47.473     0.200
     3.166    51.980     0.200
     3.175    49.782     0.200
     3.454    52.122     0.200
     3.873    59.030     0.200
     4.813    71.267     0.200
     4.828    75.592     0.200
     6.020    85.879     0.200
     6.606    97.835     0.200
    18.591   239.978     0.200
     1.557    24.166     0.200
     1.763    31.360     0.200
     2.010    33.274     0.200
     1.866    30.156     0.200
     2.004    31.547     0.200
     2.379    39.174     0.200
     2.558    40.083     0.200
     2.725    44.029     0.200
     3.162    52.627     0.200
     3.170    50.836     0.200
     3.246    52.047     0.200
     3.871    57.765     0.200
     6.255    88.634     0.200
     0.726    17.306     0.200
     1.530    25.020     0.200
     1.889    30.732     0.200
     1.982    31.249     0.200
     2.068    33.640     0.200
     2.470    39.957     0.200
     2.357    38.470     0.200
     2.709    42.160     0.200
     2.849    45.531     0.200
     3.310    54.544     0.200
     3.320    51.037     0.200
     3.379    53.345     0.200
     4.015    61.922     0.200
     0.368    14.528     0.200
     0.746    15.919     0.200
     1.148    22.331     0.200
     1.453    26.080     0.200
     1.911    29.022     0.200
     1.981    32.908     0.200
     2.057    34.322     0.200
     2.110    33.907     0.200
     2.313    34.337     0.200
     2.716    41.925     0.200
     2.715    40.848     0.200
     2.947    43.939     0.200
     3.325    48.530     0.200
     3.328    48.486     0.200
     3.686    57.714     0.200
     4.038    57.204     0.200
     4.513    65.664     0.200
     6.430    85.292     0.200
     6.936    93.881     0.200
     7.930   103.787     0.200
     0.070    15.118     0.200
     0.367    14.845     0.200
     0.770    17.248     0.200
     1.373    24.614     0.200
     1.614    28.301     0.200
     1.613    26.012     0.200
     1.689    28.322     0.200
     2.027    30.472     0.200
     1.948    32.200     0.200
     2.095    33.078     0.200
     2.082    34.640     0.200
     2.306    36.217     0.200
     2.637    43.364     0.200
     2.807    44.374     0.200
     3.249    48.213     0.200
     3.328    53.298     0.200
     4.382    65.992     0.200
     4.731    69.926     0.200
     6.098    87.972     0.200
     6.098    84.975     0.200
     6.697    94.976     0.200
     0.222    10.948     0.200
     1.343    22.564     0.200
     1.817    29.431     0.200
     1.879    31.909     0.200
     2.279    36.438     0.200
     2.551    40.267     0.200
     2.576    37.970     0.200
     3.172    50.021     0.200
     3.183    47.892     0.200
     3.598    52.550     0.200
     3.872    59.854     0.200
     0.053    15.364     0.200
     0.796    16.795     0.200
     1.393    24.322     0.200
     1.636    26.490     0.200
     1.600    26.212     0.200
     1.709    27.837     0.200
     2.028    30.718     0.200
     1.923    32.037     0.200
     2.121    33.033     0.200
     2.060    34.740     0.200
     2.326    35.541     0.200
     2.611    39.610     0.200
     2.782    45.416     0.200
     3.215    51.056     0.200
     3.216    49.048     0.200
     3.224    47.459     0.200
     3.302    53.043     0.200
     3.376    49.684     0.200
     3.925    57.779     0.200
     4.182    60.772     0.200
     4.357    63.735     0.200
     4.753    70.115     0.200
     6.072    86.717     0.200
     6.072    86.721     0.200
     6.310    84.941     0.200
     6.624    90.277     0.200
     6.673    95.710     0.200
     6.788    93.363     0.200
     6.909    95.656     0.200
     7.171   101.790     0.200
     8.134   114.655     0.200
    12.849   167.626     0.200
    20.544   268.829     0.200
     0.753    17.656     0.200
     1.891    34.082     0.200
     1.913    33.123     0.200
     1.976    35.292     0.200
     2.326    38.899     0.200
     2.660    44.111     0.200
     2.819    48.656     0.200
     3.971    63.113     0.200
     4.573    71.088     0.200
     0.280    17.389     0.200
     1.162    22.294     0.200
     1.554    24.918     0.200
     1.478    25.203     0.200
     1.812    29.808     0.200
     1.953    28.262     0.200
     2.096    32.796     0.200
     2.167    33.067     0.200
     2.139    34.292     0.200
     2.290    35.331     0.200
     2.656    40.261     0.200
     2.796    42.128     0.200
     2.992    45.444     0.200
     3.146    45.043     0.200
     3.404    50.732     0.200
     3.441    53.795     0.200
     3.410    49.464     0.200
     3.505    52.155     0.200
     3.706    55.804     0.200
     4.115    58.135     0.200
     4.523    66.276     0.200
     4.565    65.889     0.200
     5.630    78.260     0.200
     6.263    85.973     0.200
     6.504    87.152     0.200
     6.796    94.753     0.200
     6.805    92.644     0.200
     6.891   100.640     0.200
     6.994    94.338     0.200
     7.106    96.136     0.200
     7.996   104.749     0.200
    18.371   233.672     0.200
     0.519    13.929     0.200
     1.448    23.887     0.200
     1.859    31.486     0.200
     1.830    31.830     0.200
     1.875    30.696     0.200
     2.365    37.585     0.200
     2.451    41.580     0.200
     2.610    42.729     0.200
     2.743    44.175     0.200
     3.209    51.731     0.200
     3.219    49.616     0.200
     3.274    53.974     0.200
     4.853    72.051     0.200
     6.291    87.769     0.200
     0.461    16.467     0.200
     0.693    21.069     0.200
     1.510    25.327     0.200
     1.568    25.857     0.200
     1.685    27.193     0.200
     1.991    30.822     0.200
     2.207    35.295     0.200
     2.248    35.015     0.200
     2.466    37.882     0.200
     2.526    39.476     0.200
     2.734    40.048     0.200
     2.701    43.434     0.200
     3.187    47.263     0.200
     3.131    45.519     0.200
     3.366    49.670     0.200
     3.741    54.200     0.200
     3.744    54.367     0.200
     3.843    58.607     0.200
     4.115    61.431     0.200
     4.455    61.469     0.200
     4.454    63.471     0.200
     4.579    66.818     0.200
     4.731    67.739     0.200
     4.933    71.490     0.200
     5.329    79.269     0.200
     5.948    83.339     0.200
     5.983    84.034     0.200
     6.626    92.131     0.200
     6.599    89.846     0.200
     6.627    90.615     0.200
     6.846    91.556     0.200
     7.045   104.237     0.200
     7.123    95.331     0.200
     7.277   101.536     0.200
     7.384    99.888     0.200
     7.452   101.694     0.200
     8.353   115.177     0.200
     8.254   108.131     0.200
     8.348   108.824     0.200
     8.600   119.096     0.200
     8.424   108.644     0.200
     8.557   115.591     0.200
     9.880   129.159     0.200
    10.794   146.483     0.200
    11.857   157.287     0.200
     0.600    14.541     0.200
     1.372    24.135     0.200
     1.886    31.332     0.200
     1.899    31.178     0.200
     2.173    37.078     0.200
     2.344    39.184     0.200
     2.510    39.753     0.200
     2.664    42.450     0.200
     3.259    51.508     0.200
     3.270    53.377     0.200
     0.306    15.051     0.200
     0.715    15.272     0.200
     1.176    21.896     0.200
     1.485    24.984     0.200
     1.675    27.071     0.200
     1.852    30.600     0.200
     1.979    32.021     0.200
     2.076    32.885     0.200
     2.095    33.766     0.200
     2.093    34.093     0.200
     2.257    34.474     0.200
     2.277    37.744     0.200
     2.679    40.254     0.200
     2.719    42.185     0.200
     2.936    44.551     0.200
     3.146    46.602     0.200
     3.328    49.577     0.200
     3.333    49.920     0.200
     3.410    53.517     0.200
     4.041    57.958     0.200
     4.545    67.272     0.200
     4.694    67.537     0.200
     4.907    72.753     0.200
     5.562    78.507     0.200
     6.188    87.107     0.200
     6.206    85.888     0.200
     6.432    87.153     0.200
     6.723    91.859     0.200
     6.732    93.753     0.200
     6.844    98.447     0.200
     7.035    95.716     0.200
     7.874   110.723     0.200
     7.928   103.490     0.200
    18.459   236.901     0.200
     0.569    13.037     0.200
     1.392    25.233     0.200
     1.897    30.134     0.200
     1.961    32.986     0.200
     2.009    33.227     0.200
     2.232    36.123     0.200
     2.217    36.796     0.200
     2.780    43.234     0.200
     2.861    45.289     0.200
     3.067    47.283     0.200
     3.469    53.387     0.200
     3.474    52.225     0.200
     3.577    59.334     0.200
     6.572    90.281     0.200
     6.969   100.740     0.200
     7.066    97.410     0.200
     7.090    98.026     0.200
     0.062    12.045     0.200
     0.392    12.890     0.200
     0.525    13.641     0.200
     1.050    21.114     0.200
     1.368    24.212     0.200
     1.504    24.521     0.200
     1.778    27.027     0.200
     1.802    30.346     0.200
     1.927    29.486     0.200
     1.910    30.482     0.200
     1.987    32.283     0.200
     2.224    33.814     0.200
     2.253    36.975     0.200
     2.808    44.404     0.200
     2.902    44.208     0.200
     3.104    47.443     0.200
     3.510    51.907     0.200
     3.516    52.245     0.200
     0.279    14.436     0.200
     0.741    15.939     0.200
     1.210    22.163     0.200
     1.520    26.055     0.200
     1.690    27.468     0.200
     1.619    25.292     0.200
     1.824    29.407     0.200
     1.978    32.398     0.200
     2.012    33.416     0.200
     2.084    32.964     0.200
     2.129    32.546     0.200
     2.058    32.667     0.200
     2.241    35.138     0.200
     2.243    37.515     0.200
     2.647    42.303     0.200
     2.688    39.722     0.200
     2.902    45.817     0.200
     3.180    45.577     0.200
     3.409    49.905     0.200
     3.297    51.013     0.200
     3.301    50.261     0.200
     3.408    52.915     0.200
     4.009    56.800     0.200
     4.472    65.399     0.200
     5.509    79.500     0.200
     6.156    83.849     0.200
     6.174    87.040     0.200
     6.400    87.298     0.200
     6.699    93.308     0.200
     6.692    91.791     0.200
     6.941    92.687     0.200
     6.810    99.219     0.200
     6.898    92.388     0.200
     7.865   107.797     0.200
     7.896   103.341     0.200
    13.068   176.182     0.200
    14.702   188.113     0.200
     0.598    14.405     0.200
     1.376    23.833     0.200
     1.829    30.836     0.200
     1.788    28.720     0.200
     1.923    33.738     0.200
     1.914    32.146     0.200
     2.276    36.328     0.200
     2.535    42.208     0.200
     2.531    39.149     0.200
     2.656    41.186     0.200
     3.129    49.070     0.200
     3.139    48.850     0.200
     3.189    50.467     0.200
     3.831    59.176     0.200
     1.311    22.288     0.200
     1.715    29.074     0.200
     1.631    28.350     0.200
     1.829    31.141     0.200
     1.873    32.731     0.200
     2.272    36.776     0.200
     2.575    41.638     0.200
     2.601    41.935     0.200
     2.700    43.571     0.200
     3.194    50.511     0.200
     3.206    50.875     0.200
     3.240    49.775     0.200
     3.892    61.067     0.200
     0.223    14.274     0.200
     0.294    14.152     0.200
     0.744    16.090     0.200
     1.202    22.953     0.200
     1.510    26.152     0.200
     1.699    28.154     0.200
     1.838    28.428     0.200
     1.985    33.605     0.200
     2.009    32.227     0.200
     2.096    31.714     0.200
     2.064    33.681     0.200
     2.118    34.052     0.200
     2.257    35.243     0.200
     2.253    33.587     0.200
     2.656    43.273     0.200
     2.689    42.391     0.200
     2.907    44.746     0.200
     3.298    49.181     0.200
     3.303    49.728     0.200
     3.412    54.060     0.200
     3.638    57.918     0.200
     4.011    57.965     0.200
     4.476    65.241     0.200
     4.572    69.523     0.200
     4.665    67.834     0.200
     5.510    78.273     0.200
     5.532    78.014     0.200
     6.158    86.618     0.200
     6.402    86.062     0.200
     6.693    90.769     0.200
     6.815    99.339     0.200
     7.804   102.104     0.200
     7.845   109.022     0.200
     7.870   107.241     0.200
     7.899   102.994     0.200
     0.306    14.882     0.200
     0.732    16.114     0.200
     1.185    22.427     0.200
     1.494    25.027     0.200
     1.692    28.312     0.200
     1.646    26.554     0.200
     1.852    30.450     0.200
     1.994    32.592     0.200
     2.093    33.337     0.200
     2.102    32.226     0.200
     2.081    33.675     0.200
     2.265    35.628     0.200
     2.269    36.181     0.200
     2.704    40.503     0.200
     2.923    44.747     0.200
     3.153    44.261     0.200
     3.313    49.894     0.200
     3.318    49.840     0.200
     3.400    53.380     0.200
     3.427    54.061     0.200
     4.026    58.075     0.200
     4.297    61.212     0.200
     4.555    65.899     0.200
     4.492    63.139     0.200
     4.681    67.932     0.200
     4.893    72.162     0.200
     5.525    78.981     0.200
     5.548    78.213     0.200
     6.172    85.026     0.200
     6.192    85.297     0.200
     6.417    86.870     0.200
     6.707    89.887     0.200
     6.718    94.659     0.200
     6.832    95.333     0.200
     6.918    93.228     0.200
     7.283   101.066     0.200
     7.819   106.009     0.200
     7.861   109.714     0.200
     7.885   106.638     0.200
     7.914   103.502     0.200
     9.462   124.039     0.200
    13.093   176.264     0.200
     0.184    13.921     0.200
     0.349    14.392     0.200
     0.718    15.184     0.200
     1.145    22.305     0.200
     1.452    25.516     0.200
     1.694    24.901     0.200
     1.895    29.851     0.200
     1.965    32.240     0.200
     2.103    32.521     0.200
     2.060    34.028     0.200
     2.117    34.458     0.200
     2.301    35.718     0.200
     2.714    42.787     0.200
     2.732    41.185     0.200
     2.957    44.656     0.200
     3.341    48.971     0.200
     3.346    49.723     0.200
     3.459    52.696     0.200
     4.055    57.851     0.200
     4.525    66.062     0.200
     4.715    67.843     0.200
     5.552    78.874     0.200
     5.578    78.965     0.200
     6.201    86.507     0.200
     6.446    85.239     0.200
     6.976    94.654     0.200
     7.850   105.460     0.200
     7.918   106.059     0.200
     7.945   103.552     0.200
     0.232    15.119     0.200
     0.263    14.953     0.200
     0.742    15.870     0.200
     1.222    23.663     0.200
     1.532    26.454     0.200
     1.684    26.574     0.200
     1.808    28.921     0.200
     2.017    30.785     0.200
     2.076    30.604     0.200
     2.049    33.608     0.200
     2.142    34.030     0.200
     2.634    40.883     0.200
     2.683    41.020     0.200
     2.895    44.244     0.200
     3.292    49.212     0.200
     3.297    48.551     0.200
     3.401    54.931     0.200
     4.004    57.602     0.200
     4.465    65.124     0.200
     5.523    78.168     0.200
     6.394    86.204     0.200
     7.794   102.664     0.200
     7.858   106.217     0.200
     0.215    14.762     0.200
     0.731    16.644     0.200
     1.250    22.987     0.200
     1.552    24.765     0.200
     1.562    26.541     0.200
     1.653    28.090     0.200
     1.762    29.210     0.200
     2.036    31.317     0.200
     2.024    33.257     0.200
     2.033    33.849     0.200
     2.173    32.718     0.200
     2.175    35.087     0.200
     2.200    36.395     0.200
     2.604    41.881     0.200
     2.750    42.984     0.200
     2.682    41.176     0.200
     2.883    42.634     0.200
     3.226    45.424     0.200
     3.290    48.879     0.200
     3.296    49.012     0.200
     3.342    54.070     0.200
     3.603    54.727     0.200
     4.002    57.076     0.200
     4.454    64.489     0.200
     4.617    69.196     0.200
     4.762    65.808     0.200
     5.504    78.447     0.200
     5.517    77.790     0.200
     6.149    86.919     0.200
     6.161    85.375     0.200
     6.391    87.389     0.200
     6.566    95.652     0.200
     6.690    89.396     0.200
     6.917    93.347     0.200
     7.788   101.689     0.200
     7.819   109.330     0.200
     7.848   104.490     0.200
     7.883   104.376     0.200
     8.287   115.360     0.200
    10.101   135.199     0.200
    18.485   237.649     0.200
     0.207    14.119     0.200
     0.305    15.072     0.200
     1.185    23.104     0.200
     1.494    26.203     0.200
     1.690    27.611     0.200
     1.851    29.937     0.200
     1.993    32.378     0.200
     2.090    32.639     0.200
     2.102    34.499     0.200
     2.081    33.844     0.200
     2.263    35.124     0.200
     2.673    42.843     0.200
     2.705    41.564     0.200
     2.924    44.111     0.200
     3.314    49.454     0.200
     3.319    49.401     0.200
     3.428    54.625     0.200
     3.655    55.879     0.200
     4.027    58.437     0.200
     4.493    65.604     0.200
     4.774    68.719     0.200
     5.549    78.577     0.200
     6.174    84.487     0.200
     6.418    87.232     0.200
     6.709    89.544     0.200
     6.944    95.093     0.200
     7.820   104.273     0.200
     7.886   107.201     0.200
     7.915   103.664     0.200
     0.218    14.655     0.200
     0.268    15.565     0.200
     0.727    15.914     0.200
     1.210    22.880     0.200
     1.520    26.457     0.200
     1.606    24.955     0.200
     1.671    27.088     0.200
     1.815    30.218     0.200
     1.961    30.009     0.200
     2.003    31.426     0.200
     2.065    31.395     0.200
     2.063    34.219     0.200
     2.225    33.729     0.200
     2.131    35.130     0.200
     2.242    36.928     0.200
     2.646    42.715     0.200
     2.712    41.550     0.200
     2.698    41.713     0.200
     2.909    45.050     0.200
     3.182    46.064     0.200
     3.307    49.909     0.200
     3.312    49.849     0.200
     3.378    53.772     0.200
     3.416    52.330     0.200
     3.635    54.570     0.200
     4.019    58.596     0.200
     4.479    65.924     0.200
     4.578    68.264     0.200
     5.519    79.183     0.200
     5.538    78.167     0.200
     6.166    84.541     0.200
     6.182    87.050     0.200
     6.409    86.000     0.200
     7.873   106.322     0.200
     7.904   104.350     0.200
     0.667    16.204     0.200
     1.302    23.485     0.200
     1.761    30.032     0.200
     2.224    37.025     0.200
     2.524    40.627     0.200
     2.599    43.051     0.200
     2.632    41.473     0.200
     3.119    51.091     0.200
     3.130    49.358     0.200
     3.169    51.702     0.200
     1.262    19.944     0.200
     1.459    24.552     0.200
     1.524    26.594     0.200
     1.828    29.348     0.200
     1.841    31.691     0.200
     1.954    33.376     0.200
     1.936    29.379     0.200
     2.460    39.072     0.200
     2.548    41.237     0.200
     2.693    42.156     0.200
     3.150    49.521     0.200
     3.159    48.812     0.200
     3.855    57.891     0.200
     6.235    87.515     0.200
     6.719    95.464     0.200
     0.265    15.334     0.200
     0.710    16.135     0.200
     1.204    22.376     0.200
     1.515    25.640     0.200
     1.653    26.834     0.200
     1.598    25.377     0.200
     1.812    30.680     0.200
     1.990    31.303     0.200
     2.047    33.532     0.200
     2.127    32.998     0.200
     2.073    31.229     0.200
     2.214    32.587     0.200
     2.247    37.298     0.200
     2.705    40.155     0.200
     2.651    44.585     0.200
     2.712    41.276     0.200
     2.920    44.845     0.200
     3.178    45.834     0.200
     3.372    49.066     0.200
     3.320    49.173     0.200
     3.326    49.510     0.200
     3.386    52.908     0.200
     4.033    58.362     0.200
     4.572    66.071     0.200
     4.491    66.014     0.200
     5.533    78.643     0.200
     5.551    78.440     0.200
     6.180    83.908     0.200
     6.423    84.968     0.200
     6.737    90.010     0.200
     6.907    96.819     0.200
     7.678   105.518     0.200
     7.678   104.112     0.200
     7.733   105.276     0.200
     7.822   103.242     0.200
     8.331   118.195     0.200
     8.660   122.363     0.200
    11.067   150.269     0.200
     0.330    12.000     0.200
     0.371    10.825     0.200
     1.109    21.502     0.200
     1.190    21.963     0.200
     1.482    25.355     0.200
     1.429    24.677     0.200
     1.603    25.836     0.200
     1.830    27.893     0.200
     2.000    31.415     0.200
     2.052    33.404     0.200
     2.381    37.964     0.200
     2.848    43.211     0.200
     3.098    47.897     0.200
     3.248    49.948     0.200
     3.701    55.153     0.200
     3.710    55.155     0.200
     3.923    59.263     0.200
     4.408    63.906     0.200
     4.824    70.655     0.200
     6.790    94.106     0.200
     7.117   102.795     0.200
     0.095    13.643     0.200
     0.831    18.861     0.200
     1.470    23.699     0.200
     1.495    26.714     0.200
     1.587    27.431     0.200
     1.902    31.265     0.200
     1.813    29.796     0.200
     1.876    31.562     0.200
     1.973    33.128     0.200
     2.376    38.134     0.200
     2.434    37.654     0.200
     2.603    41.285     0.200
     2.742    43.453     0.200
     3.203    50.474     0.200
     3.213    48.563     0.200
     3.425    53.993     0.200
     3.908    56.852     0.200
     4.318    65.560     0.200
     5.417    80.041     0.200
     6.287    86.683     0.200
     0.277    14.536     0.200
     0.725    16.312     0.200
     1.202    22.550     0.200
     1.512    25.932     0.200
     1.615    25.631     0.200
     1.674    27.844     0.200
     1.824    30.092     0.200
     1.998    33.059     0.200
     2.069    32.228     0.200
     2.123    32.605     0.200
     2.069    33.826     0.200
     2.250    37.617     0.200
     2.702    40.948     0.200
     2.914    44.566     0.200
     3.311    50.138     0.200
     3.316    50.182     0.200
     4.023    58.129     0.200
     4.484    65.338     0.200
     4.766    65.761     0.200
     5.523    78.817     0.200
     5.543    78.292     0.200
     6.170    86.575     0.200
     6.414    86.730     0.200
     7.667   104.499     0.200
     7.667   104.107     0.200
     7.814   103.186     0.200
     7.909   102.974     0.200
    18.473   235.795     0.200
    20.757   271.142     0.200
     0.043    10.590     0.200
     0.797    17.994     0.200
     1.384    22.743     0.200
     1.401    25.452     0.200
     1.590    26.245     0.200
     1.631    27.954     0.200
     1.717    29.764     0.200
     1.950    33.542     0.200
     1.975    33.043     0.200
     1.919    31.694     0.200
     2.053    33.133     0.200
     2.124    32.207     0.200
     2.334    37.462     0.200
     2.610    40.029     0.200
     2.779    44.367     0.200
     3.210    50.531     0.200
     3.215    49.674     0.200
     3.924    57.010     0.200
     4.181    62.307     0.200
     4.759    71.553     0.200
     4.770    72.431     0.200
     5.440    79.910     0.200
     6.071    85.046     0.200
     6.309    86.575     0.200
     6.589    92.103     0.200
     6.668    93.273     0.200
     6.806    91.670     0.200
     6.907    95.492     0.200
     7.170   101.323     0.200
     7.287    97.356     0.200
     7.434   101.634     0.200
     7.546   104.936     0.200
     7.588   102.938     0.200
     7.648   104.633     0.200
     7.696   103.174     0.200
     7.881   105.830     0.200
     7.981   110.256     0.200
     8.246   112.368     0.200
     9.372   121.424     0.200
    12.838   171.269     0.200
    14.328   193.882     0.200
    18.545   240.675     0.200
     0.371    12.505     0.200
     1.378    24.759     0.200
     1.659    28.581     0.200
     1.627    25.551     0.200
     1.692    28.691     0.200
     2.011    33.373     0.200
     1.926    31.063     0.200
     2.063    31.766     0.200
     2.073    33.639     0.200
     2.120    35.895     0.200
     2.307    36.310     0.200
     2.477    38.224     0.200
     2.604    40.850     0.200
     2.782    43.164     0.200
     3.210    48.583     0.200
     3.217    49.796     0.200
     3.919    57.601     0.200
     4.357    64.290     0.200
     5.425    79.234     0.200
     6.306    82.648     0.200
     6.809    94.176     0.200
     7.580   102.380     0.200
     7.714   110.411     0.200
     0.215    14.767     0.200
     0.738    16.265     0.200
     1.254    22.952     0.200
     1.554    24.543     0.200
     1.566    26.710     0.200
     1.660    27.905     0.200
     1.762    29.718     0.200
     1.957    31.943     0.200
     2.043    32.539     0.200
     2.030    32.591     0.200
     2.186    34.576     0.200
     2.178    34.465     0.200
     2.201    35.298     0.200
     2.203    35.970     0.200
     2.601    41.828     0.200
     2.776    42.881     0.200
     2.877    45.409     0.200
     3.283    49.067     0.200
     3.289    49.200     0.200
     3.995    57.161     0.200
     4.448    65.168     0.200
     4.621    66.356     0.200
     6.142    83.301     0.200
     6.155    85.757     0.200
     6.384    86.673     0.200
     6.780    99.163     0.200
     7.499   101.569     0.200
     7.645   103.370     0.200
     7.700   103.815     0.200
     7.782   103.571     0.200
     7.901   104.077     0.200
     8.020   108.081     0.200
     0.365    15.537     0.200
     0.682    17.746     0.200
     0.795    19.927     0.200
     0.983    20.325     0.200
     1.587    26.881     0.200
     1.590    28.144     0.200
     1.649    25.656     0.200
     1.851    30.003     0.200
     2.140    31.023     0.200
     2.331    36.799     0.200
     2.572    38.485     0.200
     2.629    39.712     0.200
     2.785    42.296     0.200
     3.185    47.137     0.200
     3.246    47.512     0.200
     3.399    49.037     0.200
     3.745    53.402     0.200
     3.746    53.787     0.200
     4.149    62.681     0.200
     4.459    62.167     0.200
     4.622    67.958     0.200
     4.957    70.949     0.200
     5.154    76.356     0.200
     6.598    89.697     0.200
     6.639    89.918     0.200
     6.850    89.361     0.200
     6.906    97.308     0.200
     7.315   103.129     0.200
     7.405   100.479     0.200
     7.937   107.181     0.200
     8.062   108.524     0.200
     8.107   108.096     0.200
     0.569    13.139     0.200
     1.408    24.354     0.200
     1.879    31.158     0.200
     2.026    33.142     0.200
     2.222    34.845     0.200
     2.306    37.268     0.200
     2.765    44.715     0.200
     2.956    45.880     0.200
     3.057    46.903     0.200
     3.463    53.269     0.200
     3.468    52.406     0.200
     4.175    60.961     0.200
     4.629    68.758     0.200
     5.554    78.365     0.200
     5.736    81.546     0.200
     6.322    89.503     0.200
     6.335    88.346     0.200
     6.565    87.670     0.200
     6.578    96.820     0.200
     7.081    95.741     0.200
     7.678   104.382     0.200
     7.822   107.002     0.200
     7.821   105.004     0.200
     8.082   106.467     0.200
     0.241    14.777     0.200
     0.295    13.857     0.200
     0.722    15.774     0.200
     1.226    22.485     0.200
     1.538    25.644     0.200
     1.577    25.693     0.200
     1.655    28.088     0.200
     1.770    29.544     0.200
     1.788    29.326     0.200
     1.948    32.762     0.200
     2.007    32.770     0.200
     2.044    33.050     0.200
     2.053    32.942     0.200
     2.150    33.100     0.200
     2.151    35.990     0.200
     2.228    37.693     0.200
     2.230    35.668     0.200
     2.628    43.727     0.200
     2.798    42.843     0.200
     2.930    44.305     0.200
     3.304    49.431     0.200
     3.310    49.071     0.200
     3.624    57.704     0.200
     4.016    57.530     0.200
     4.472    65.506     0.200
     4.594    69.084     0.200
     4.659    68.126     0.200
     4.757    67.685     0.200
     5.395    75.527     0.200
     5.518    76.804     0.200
     5.577    77.405     0.200
     6.163    86.769     0.200
     6.177    84.006     0.200
     6.406    87.436     0.200
     6.701    93.392     0.200
     6.924    93.492     0.200
     7.663   104.264     0.200
     7.664   105.257     0.200
     7.804   104.620     0.200
     7.838   108.629     0.200
     7.866   105.904     0.200
     7.923   104.127     0.200
     8.044   108.619     0.200
     0.555    13.596     0.200
     1.011    19.274     0.200
     1.348    24.336     0.200
     1.351    25.109     0.200
     1.378    25.487     0.200
     1.604    26.046     0.200
     1.627    26.381     0.200
     1.701    28.519     0.200
     1.690    28.343     0.200
     1.782    30.876     0.200
     2.306    36.058     0.200
     2.368    37.533     0.200
     3.232    50.651     0.200
     3.741    57.617     0.200
     3.752    58.181     0.200
     0.235    15.136     0.200
     0.235    14.544     0.200
     1.234    22.075     0.200
     1.546    26.539     0.200
     1.763    28.607     0.200
     1.782    29.288     0.200
     2.014    34.172     0.200
     2.045    33.215     0.200
     2.144    35.358     0.200
     2.200    34.501     0.200
     2.158    34.596     0.200
     2.223    35.742     0.200
     2.620    41.599     0.200
     2.791    43.305     0.200
     2.922    44.475     0.200
     3.298    48.595     0.200
     3.303    48.734     0.200
     4.009    56.788     0.200
     4.465    64.973     0.200
     4.651    69.001     0.200
     5.389    76.589     0.200
     5.570    80.573     0.200
     0.153    13.542     0.200
     0.339    13.172     0.200
     0.674    16.761     0.200
     1.504    26.574     0.200
     1.607    24.973     0.200
     1.627    26.241     0.200
     1.644    27.337     0.200
     1.860    31.718     0.200
     1.992    30.881     0.200
     2.154    35.586     0.200
     2.141    35.441     0.200
     2.266    35.686     0.200
     2.547    38.911     0.200
     2.833    45.664     0.200
     2.938    44.347     0.200
     3.342    51.422     0.200
     4.050    57.667     0.200
     5.430    75.460     0.200
     5.595    80.630     0.200
     6.433    85.450     0.200
     6.925    98.718     0.200
     7.717   105.772     0.200
     7.864   107.358     0.200
     0.477    14.000     0.200
     0.496    13.282     0.200
     0.570    14.515     0.200
     0.590    14.186     0.200
     1.069    19.499     0.200
     1.399    24.444     0.200
     1.423    24.256     0.200
     1.634    25.905     0.200
     1.656    27.240     0.200
     1.636    26.671     0.200
     2.255    35.550     0.200
     2.366    37.450     0.200
     2.372    35.182     0.200
     2.457    38.695     0.200
     2.740    42.591     0.200
     3.197    48.359     0.200
     3.706    56.619     0.200
     4.405    66.059     0.200
     0.492    12.692     0.200
     0.693    16.647     0.200
     1.219    21.006     0.200
     1.479    25.678     0.200
     1.499    25.235     0.200
     1.753    30.873     0.200
     2.033    35.703     0.200
     2.100    36.222     0.200
     2.143    36.223     0.200
     2.485    40.131     0.200
     2.869    45.755     0.200
     2.950    47.005     0.200
     3.378    56.312     0.200
     3.388    54.491     0.200
     4.080    64.020     0.200
     5.459    81.030     0.200
     0.310    13.954     0.200
     0.365    13.915     0.200
     0.720    15.873     0.200
     1.175    22.557     0.200
     1.484    25.251     0.200
     1.681    27.954     0.200
     1.647    26.255     0.200
     1.838    30.026     0.200
     1.856    30.110     0.200
     1.981    32.749     0.200
     2.083    32.462     0.200
     2.093    32.341     0.200
     2.092    33.856     0.200
     2.208    34.306     0.200
     2.188    35.735     0.200
     2.272    35.251     0.200
     2.282    37.138     0.200
     2.682    42.171     0.200
     2.821    42.155     0.200
     2.935    45.019     0.200
     2.960    45.123     0.200
     3.326    48.958     0.200
     3.330    48.605     0.200
     4.039    57.740     0.200
     4.545    68.231     0.200
     4.504    64.509     0.200
     4.905    72.531     0.200
     5.417    73.454     0.200
     5.538    77.146     0.200
     5.604    78.674     0.200
     6.185    82.690     0.200
     6.204    85.365     0.200
     6.430    85.437     0.200
     6.453    90.865     0.200
     6.738    89.735     0.200
     6.843    98.911     0.200
     6.956    94.999     0.200
     7.538   103.102     0.200
     7.679   103.455     0.200
     7.733   105.430     0.200
     7.873   109.390     0.200
     7.897   106.407     0.200
     7.950   103.689     0.200
     8.493   115.961     0.200
     8.709   124.236     0.200
    10.190   140.851     0.200
    13.092   176.985     0.200
    18.462   239.315     0.200
     0.640    15.344     0.200
     0.931    19.746     0.200
     1.114    23.419     0.200
     1.310    24.625     0.200
     1.287    21.590     0.200
     1.311    22.818     0.200
     1.377    24.343     0.200
     2.032    33.197     0.200
     2.313    37.324     0.200
     2.649    41.403     0.200
     2.766    41.139     0.200
     3.102    46.509     0.200
     3.128    47.914     0.200
     3.606    55.136     0.200
     3.621    54.356     0.200
     4.140    64.805     0.200
     4.613    70.386     0.200
     0.296    16.482     0.200
     0.274    17.647     0.200
     1.169    21.898     0.200
     1.548    24.969     0.200
     1.485    25.308     0.200
     1.561    25.119     0.200
     1.784    29.924     0.200
     1.803    29.993     0.200
     1.914    30.502     0.200
     1.946    28.935     0.200
     2.103    33.197     0.200
     2.166    34.464     0.200
     2.136    34.411     0.200
     2.219    33.344     0.200
     2.237    36.432     0.200
     2.288    37.940     0.200
     2.719    42.714     0.200
     2.688    44.669     0.200
     2.896    43.945     0.200
     3.021    45.183     0.200
     3.404    53.810     0.200
     3.403    49.622     0.200
     3.409    50.750     0.200
     3.439    53.511     0.200
     3.703    56.032     0.200
     4.115    58.424     0.200
     4.528    67.794     0.200
     4.647    65.405     0.200
     4.563    66.293     0.200
     5.618    77.583     0.200
     5.672    79.643     0.200
     6.262    85.762     0.200
     6.272    85.751     0.200
     6.503    85.847     0.200
     6.824    90.810     0.200
     7.686   103.942     0.200
     7.765   105.023     0.200
     7.767   103.903     0.200
     7.956   107.298     0.200
     8.018   103.371     0.200
     8.176   110.721     0.200
    10.079   139.015     0.200
     0.509    15.093     0.200
     0.587    16.985     0.200
     0.911    19.207     0.200
     1.003    21.030     0.200
     1.105    20.141     0.200
     1.127    21.581     0.200
     1.394    26.372     0.200
     1.408    24.401     0.200
     1.578    27.121     0.200
     1.765    30.135     0.200
     1.816    30.044     0.200
     1.866    31.766     0.200
     2.033    33.215     0.200
     2.136    32.112     0.200
     2.228    37.138     0.200
     2.759    39.634     0.200
     2.821    43.213     0.200
     2.877    40.964     0.200
     2.848    43.499     0.200
     3.324    50.641     0.200
     3.340    50.860     0.200
     4.007    59.473     0.200
     5.375    77.912     0.200
     0.148     9.873     0.200
     0.217    11.564     0.200
     0.599    14.409     0.200
     0.866    18.894     0.200
     1.347    22.376     0.200
     1.367    23.348     0.200
     1.578    26.980     0.200
     1.776    28.478     0.200
     1.826    30.885     0.200
     1.899    30.243     0.200
     1.929    32.190     0.200
     1.970    31.215     0.200
     2.284    36.049     0.200
     2.316    37.075     0.200
     2.638    38.514     0.200
     2.702    41.667     0.200
     2.778    42.884     0.200
     3.211    49.726     0.200
     3.222    49.297     0.200
     3.911    58.557     0.200
     5.289    77.576     0.200
     6.284    87.969     0.200
     0.066    11.723     0.200
     0.181    13.283     0.200
     0.537    15.126     0.200
     0.808    18.361     0.200
     1.410    23.640     0.200
     1.430    24.407     0.200
     1.514    26.518     0.200
     1.819    29.059     0.200
     1.818    29.877     0.200
     1.834    28.882     0.200
     1.989    32.472     0.200
     2.019    32.324     0.200
     2.342    36.563     0.200
     2.377    40.151     0.200
     2.457    37.215     0.200
     2.574    37.251     0.200
     2.744    43.075     0.200
     2.826    43.814     0.200
     3.253    50.632     0.200
     3.263    48.706     0.200
     3.445    55.785     0.200
     3.955    57.636     0.200
     4.353    65.991     0.200
     5.334    73.648     0.200
     0.191    12.910     0.200
     0.345    12.910     0.200
     0.642    15.849     0.200
     1.316    23.881     0.200
     1.606    25.491     0.200
     1.627    25.458     0.200
     1.636    27.145     0.200
     2.065    33.741     0.200
     2.175    34.064     0.200
     2.172    35.589     0.200
     2.259    35.081     0.200
     2.376    34.918     0.200
     2.565    40.103     0.200
     2.870    45.244     0.200
     2.971    45.867     0.200
     3.379    51.602     0.200
     3.388    52.202     0.200
     4.086    62.155     0.200
     4.506    65.862     0.200
     5.466    79.448     0.200
     5.629    82.343     0.200
     6.226    88.781     0.200
     6.233    86.106     0.200
     6.469    85.851     0.200
     6.742    93.961     0.200
     6.809    90.684     0.200
     6.956    98.962     0.200
     7.450   102.292     0.200
     7.598   103.468     0.200
     7.655   106.901     0.200
     7.748   103.419     0.200
     7.755   103.139     0.200
     7.816   106.223     0.200
     7.852   104.605     0.200
     7.895   109.806     0.200
     7.972   104.807     0.200
     8.114   111.651     0.200
     8.404   112.158     0.200
     0.283    14.588     0.200
     0.728    16.302     0.200
     1.199    22.700     0.200
     1.509    25.885     0.200
     1.621    25.972     0.200
     1.679    27.805     0.200
     1.728    28.426     0.200
     1.811    29.662     0.200
     1.829    29.046     0.200
     1.998    32.876     0.200
     2.075    33.177     0.200
     2.071    34.428     0.200
     2.119    33.968     0.200
     2.250    34.142     0.200
     2.233    33.731     0.200
     2.257    37.653     0.200
     2.804    43.169     0.200
     2.915    44.374     0.200
     2.942    44.867     0.200
     3.310    49.466     0.200
     3.315    48.909     0.200
     3.398    50.745     0.200
     3.389    51.845     0.200
     4.022    57.852     0.200
     4.292    60.304     0.200
     4.485    63.056     0.200
     4.673    68.161     0.200
     4.769    70.740     0.200
     5.401    76.961     0.200
     5.522    79.349     0.200
     5.586    79.900     0.200
     6.169    83.598     0.200
     6.413    87.251     0.200
     6.434    94.312     0.200
     7.016    96.517     0.200
     7.279   101.452     0.200
     7.523   102.099     0.200
     7.594   102.774     0.200
     7.665   105.038     0.200
     7.933   103.817     0.200
     8.356   118.874     0.200
    10.630   147.337     0.200
     0.021    11.448     0.200
     0.106    13.353     0.200
     0.486    14.213     0.200
     0.806    18.376     0.200
     1.461    24.240     0.200
     1.478    26.138     0.200
     1.480    25.214     0.200
     1.797    29.114     0.200
     1.843    30.482     0.200
     1.879    33.661     0.200
     1.892    30.006     0.200
     2.005    32.790     0.200
     2.010    32.832     0.200
     2.396    38.429     0.200
     2.403    37.341     0.200
     2.418    36.765     0.200
     2.535    36.807     0.200
     2.720    42.944     0.200
     2.812    43.873     0.200
     3.230    50.098     0.200
     3.239    49.789     0.200
     3.934    59.279     0.200
     4.344    66.498     0.200
     4.518    66.162     0.200
     5.314    72.778     0.200
     5.472    79.136     0.200
     6.313    83.814     0.200
     7.448   100.872     0.200
     7.599   101.303     0.200
     7.672   102.251     0.200
     7.732   107.359     0.200
     7.813   103.114     0.200
     0.126    15.283     0.200
     0.226    13.417     0.200
     0.334    14.157     0.200
     0.783    17.915     0.200
     1.339    24.422     0.200
     1.653    27.060     0.200
     1.652    26.867     0.200
     1.671    27.253     0.200
     1.809    29.833     0.200
     2.024    33.425     0.200
     2.056    33.151     0.200
     2.110    33.218     0.200
     2.118    35.732     0.200
     2.267    35.596     0.200
     2.382    36.253     0.200
     2.515    40.701     0.200
     2.611    39.475     0.200
     2.721    41.893     0.200
     2.842    42.386     0.200
     3.229    50.464     0.200
     3.236    47.688     0.200
     3.939    55.676     0.200
     6.327    83.010     0.200
     7.720   103.456     0.200
     7.776   106.509     0.200
     1.134    20.801     0.200
     1.179    20.871     0.200
     1.758    29.317     0.200
     1.875    29.345     0.200
     2.099    32.335     0.200
     2.120    32.389     0.200
     2.689    41.755     0.200
     2.712    41.778     0.200
     3.103    48.121     0.200
     3.350    49.535     0.200
     3.476    51.263     0.200
     3.857    57.315     0.200
     3.863    57.250     0.200
     4.569    67.909     0.200
     6.958    92.727     0.200
     7.469   102.168     0.200
     0.159    14.170     0.200
     0.333    15.442     0.200
     0.410    13.646     0.200
     0.688    15.906     0.200
     1.141    22.221     0.200
     1.450    25.506     0.200
     1.678    27.846     0.200
     1.832    30.955     0.200
     1.862    29.608     0.200
     1.880    30.389     0.200
     1.945    32.333     0.200
     2.061    33.882     0.200
     2.175    33.644     0.200
     2.167    35.349     0.200
     2.224    35.873     0.200
     2.281    34.209     0.200
     2.317    37.891     0.200
     2.420    39.686     0.200
     2.510    39.644     0.200
     2.661    41.584     0.200
     2.822    44.798     0.200
     2.857    44.094     0.200
     2.997    45.958     0.200
     3.120    46.828     0.200
     3.362    49.900     0.200
     3.613    54.071     0.200
     4.035    58.846     0.200
     4.328    63.227     0.200
     4.513    66.466     0.200
     4.677    69.654     0.200
     4.741    68.803     0.200
     5.640    81.312     0.200
     6.221    82.132     0.200
     6.466    84.176     0.200
     6.879    99.549     0.200
     6.992    92.834     0.200
     7.716    99.986     0.200
     7.934   105.243     0.200
     7.987   103.026     0.200
     8.156   110.952     0.200
     0.247    15.297     0.200
     0.211    15.407     0.200
     0.277    14.245     0.200
     0.438    13.766     0.200
     0.685    16.779     0.200
     0.880    19.502     0.200
     1.179    20.425     0.200
     1.235    23.168     0.200
     1.316    23.913     0.200
     1.434    26.043     0.200
     1.500    25.572     0.200
     1.537    26.935     0.200
     1.570    27.449     0.200
     1.706    28.771     0.200
     1.722    29.588     0.200
     1.735    29.435     0.200
     1.775    30.064     0.200
     1.819    29.643     0.200
     1.896    32.048     0.200
     2.079    34.421     0.200
     2.070    33.918     0.200
     2.187    35.558     0.200
     2.281    33.650     0.200
     2.276    37.210     0.200
     2.252    36.197     0.200
     2.319    38.307     0.200
     2.604    40.194     0.200
     2.948    43.677     0.200
     3.383    51.102     0.200
     3.571    51.697     0.200
     4.003    55.968     0.200
     4.281    61.114     0.200
     5.160    74.054     0.200
     6.189    82.247     0.200
     6.431    83.729     0.200
     6.941    92.768     0.200
     0.079    12.792     0.200
     0.508    14.782     0.200
     0.447    15.494     0.200
     0.664    15.267     0.200
     1.001    19.833     0.200
     1.111    21.546     0.200
     1.157    21.212     0.200
     1.220    22.374     0.200
     1.243    25.205     0.200
     1.334    23.140     0.200
     1.417    24.674     0.200
     1.460    25.471     0.200
     1.583    29.536     0.200
     1.714    28.213     0.200
     1.730    29.721     0.200
     1.817    30.208     0.200
     1.810    30.995     0.200
     1.882    31.252     0.200
     1.878    31.991     0.200
     1.909    33.230     0.200
     1.978    33.730     0.200
     2.009    33.169     0.200
     2.044    33.257     0.200
     2.049    35.203     0.200
     2.036    32.154     0.200
     2.410    37.493     0.200
     2.488    39.973     0.200
     2.486    39.204     0.200
     2.563    36.304     0.200
     2.770    43.587     0.200
     2.851    45.643     0.200
     2.978    46.363     0.200
     3.491    53.078     0.200
     0.392    13.268     0.200
     0.618    14.023     0.200
     0.660    13.240     0.200
     0.793    16.987     0.200
     0.962    19.010     0.200
     1.066    22.503     0.200
     1.164    20.658     0.200
     1.264    23.984     0.200
     1.469    24.995     0.200
     1.600    25.872     0.200
     1.584    27.656     0.200
     1.622    29.808     0.200
     1.649    27.592     0.200
     1.836    30.410     0.200
     2.335    37.991     0.200
     2.410    35.118     0.200
     2.437    39.101     0.200
     3.316    51.336     0.200
     3.375    51.348     0.200
     0.408    12.673     0.200
     0.428    11.937     0.200
     0.483    15.391     0.200
     0.817    17.295     0.200
     0.976    18.438     0.200
     0.956    19.075     0.200
     1.003    20.026     0.200
     1.301    22.143     0.200
     1.346    25.813     0.200
     1.451    23.392     0.200
     1.439    25.540     0.200
     1.428    25.957     0.200
     1.502    25.491     0.200
     1.694    28.160     0.200
     1.702    27.961     0.200
     1.925    32.368     0.200
     2.143    36.113     0.200
     2.255    36.814     0.200
     2.244    34.740     0.200
     2.288    32.728     0.200
     2.375    37.310     0.200
     2.386    38.177     0.200
     2.427    38.604     0.200
     3.147    49.795     0.200
     3.360    51.310     0.200
     0.536    15.010     0.200
     0.815    16.961     0.200
     0.926    18.358     0.200
     0.936    19.944     0.200
     1.217    24.165     0.200
     1.406    23.853     0.200
     1.473    25.279     0.200
     1.586    28.261     0.200
     1.595    26.750     0.200
     1.661    27.486     0.200
     1.763    29.689     0.200
     1.769    28.320     0.200
     1.860    31.263     0.200
     1.939    33.041     0.200
     2.248    35.035     0.200
     2.277    36.091     0.200
     2.561    38.484     0.200
     2.577    38.691     0.200
     2.723    39.993     0.200
     2.835    43.680     0.200
     3.004    44.007     0.200
     3.204    47.775     0.200
     3.323    47.382     0.200
     3.442    48.889     0.200
     3.796    54.961     0.200
     3.920    54.811     0.200
     4.320    58.246     0.200
     4.644    65.372     0.200
     5.038    67.869     0.200
     5.466    72.982     0.200
     5.733    77.464     0.200
     1.055    21.156     0.200
     1.091    21.430     0.200
     1.562    28.837     0.200
     1.915    34.614     0.200
     1.903    34.650     0.200
     2.088    35.795     0.200
     2.119    37.030     0.200
     2.557    41.826     0.200
     2.553    41.675     0.200
     2.733    46.766     0.200
     2.922    44.265     0.200
     2.919    45.695     0.200
     2.933    47.734     0.200
     3.061    49.440     0.200
     3.420    54.653     0.200
     4.064    62.040     0.200
     6.610    95.325     0.200
     1.019    20.051     0.200
     1.092    21.693     0.200
     1.299    24.977     0.200
     1.830    33.282     0.200
     1.848    33.264     0.200
     1.915    34.091     0.200
     2.551    42.462     0.200
     2.920    44.660     0.200
     2.918    46.987     0.200
     3.060    50.029     0.200
     3.418    54.643     0.200
     4.062    62.329     0.200
     1.001    18.792     0.200
     1.179    20.717     0.200
     1.304    22.756     0.200
     1.483    25.465     0.200
     1.449    26.070     0.200
     1.554    27.039     0.200
     1.682    28.945     0.200
     1.692    30.032     0.200
     2.010    32.916     0.200
     2.192    34.987     0.200
     2.239    35.144     0.200
     2.288    36.270     0.200
     2.347    36.680     0.200
     2.569    36.690     0.200
     2.784    44.081     0.200
     2.847    44.756     0.200
     2.880    44.066     0.200
     2.873    44.740     0.200
     3.210    47.614     0.200
     3.254    49.895     0.200
     3.382    50.902     0.200
     3.603    53.930     0.200
     3.716    54.304     0.200
     3.903    58.527     0.200
     4.125    60.529     0.200
     4.372    64.554     0.200
     4.576    68.375     0.200
     4.858    72.084     0.200
     5.034    72.232     0.200
     5.779    83.132     0.200
     5.907    85.442     0.200
     6.296    87.200     0.200
     1.099    20.612     0.200
     1.248    22.171     0.200
     1.285    22.845     0.200
     1.323    22.901     0.200
     1.497    25.764     0.200
     1.482    25.239     0.200
     1.662    27.944     0.200
     1.813    30.186     0.200
     1.821    30.387     0.200
     1.894    31.034     0.200
     1.977    33.371     0.200
     2.008    31.909     0.200
     2.475    39.056     0.200
     2.461    40.021     0.200
     2.512    37.126     0.200
     2.739    42.679     0.200
     2.832    43.986     0.200
     0.239    10.207     0.200
     0.396    10.868     0.200
     0.456    12.572     0.200
     0.691    16.233     0.200
     0.960    17.992     0.200
     1.276    24.204     0.200
     1.285    21.995     0.200
     1.481    26.012     0.200
     1.529    25.647     0.200
     1.547    27.535     0.200
     1.625    28.731     0.200
     1.626    26.819     0.200
     1.647    27.674     0.200
     1.843    29.978     0.200
     1.881    31.141     0.200
     2.080    34.617     0.200
     2.123    34.512     0.200
     2.134    30.885     0.200
     2.272    36.781     0.200
     2.409    39.474     0.200
     2.471    40.057     0.200
     2.697    40.816     0.200
     2.821    44.167     0.200
     3.050    46.000     0.200
     3.169    47.507     0.200
     3.294    48.853     0.200
     3.558    54.073     0.200
     5.648    78.177     0.200
     0.695    15.999     0.200
     1.365    25.372     0.200
     1.429    25.429     0.200
     1.851    31.699     0.200
     1.978    34.322     0.200
     2.746    45.062     0.200
     2.951    46.066     0.200
     3.255    51.420     0.200
     0.271    10.585     0.200
     0.352    10.235     0.200
     0.780    16.551     0.200
     1.097    19.748     0.200
     1.399    24.618     0.200
     1.409    24.896     0.200
     1.633    27.288     0.200
     1.654    27.644     0.200
     1.725    28.523     0.200
     1.717    27.907     0.200
     1.837    29.402     0.200
     1.851    30.441     0.200
     2.166    32.166     0.200
     2.175    35.967     0.200
     2.181    35.386     0.200
     2.186    35.332     0.200
     2.263    36.638     0.200
     2.257    37.212     0.200
     2.334    37.212     0.200
     2.413    38.390     0.200
     2.427    39.224     0.200
     2.694    42.604     0.200
     2.846    45.439     0.200
     2.899    44.218     0.200
     3.034    45.542     0.200
     3.157    46.707     0.200
     3.652    53.721     0.200
     4.366    64.099     0.200
     0.124    13.556     0.200
     0.635    15.189     0.200
     0.970    19.981     0.200
     1.077    21.325     0.200
     1.184    24.675     0.200
     1.242    22.704     0.200
     1.288    22.063     0.200
     1.499    25.703     0.200
     1.528    28.761     0.200
     1.688    28.100     0.200
     1.735    29.951     0.200
     1.752    30.353     0.200
     1.765    29.701     0.200
     1.845    30.761     0.200
     1.931    32.165     0.200
     1.900    33.231     0.200
     1.996    31.101     0.200
     2.100    33.784     0.200
     2.118    36.287     0.200
     2.469    39.487     0.200
     2.545    39.600     0.200
     2.536    36.904     0.200
     2.829    44.380     0.200
     2.908    44.358     0.200
     3.035    46.578     0.200
     0.267    14.740     0.200
     0.366    12.892     0.200
     0.361    13.544     0.200
     0.799    18.428     0.200
     1.111    20.100     0.200
     1.374    25.322     0.200
     1.345    25.063     0.200
     1.576    26.467     0.200
     1.625    27.891     0.200
     1.644    28.067     0.200
     1.730    29.275     0.200
     1.738    28.680     0.200
     1.811    31.226     0.200
     1.823    30.688     0.200
     2.153    34.837     0.200
     2.163    35.014     0.200
     2.195    36.343     0.200
     2.192    33.080     0.200
     2.239    36.124     0.200
     2.384    38.738     0.200
     2.401    39.047     0.200
     2.824    43.606     0.200
     3.018    43.245     0.200
     3.392    49.374     0.200
     3.638    53.906     0.200
     4.768    64.716     0.200
     5.214    69.915     0.200
     0.999    20.211     0.200
     1.324    25.123     0.200
     1.355    25.165     0.200
     1.803    32.333     0.200
     1.893    33.985     0.200
     2.081    33.392     0.200
     2.544    42.086     0.200
     2.522    40.736     0.200
     2.649    40.865     0.200
     2.856    45.948     0.200
     2.914    45.566     0.200
     3.042    48.577     0.200
     3.559    57.536     0.200
     0.233    15.336     0.200
     0.309    13.541     0.200
     0.425    13.389     0.200
     0.863    19.484     0.200
     1.169    20.412     0.200
     1.409    25.111     0.200
     1.347    24.525     0.200
     1.411    27.278     0.200
     1.533    25.960     0.200
     1.568    27.052     0.200
     1.578    28.331     0.200
     1.699    28.418     0.200
     1.748    29.354     0.200
     1.801    29.330     0.200
     1.776    30.131     0.200
     1.765    29.147     0.200
     1.801    32.432     0.200
     2.099    34.458     0.200
     2.103    34.111     0.200
     2.256    33.629     0.200
     2.259    37.494     0.200
     2.216    35.090     0.200
     2.217    35.276     0.200
     2.285    37.488     0.200
     2.337    39.274     0.200
     2.327    38.398     0.200
     2.336    39.389     0.200
     2.496    39.022     0.200
     2.616    40.624     0.200
     2.711    42.312     0.200
     2.830    41.428     0.200
     2.958    44.227     0.200
     3.082    44.986     0.200
     3.191    50.415     0.200
     3.397    52.712     0.200
     4.009    55.367     0.200
     4.291    62.272     0.200
     4.711    64.176     0.200
     5.158    69.760     0.200
     5.428    74.007     0.200
     5.951    82.205     0.200
     6.450    86.283     0.200
     6.454    90.231     0.200
     6.756    90.112     0.200
     6.829    98.453     0.200
     6.829    98.152     0.200
     7.014    95.497     0.200
     7.033    92.477     0.200
     7.499   101.941     0.200
     7.607   102.177     0.200
     7.954   103.332     0.200
     7.990   108.712     0.200
     8.013   102.939     0.200
     8.115   110.351     0.200
     8.203   107.223     0.200
     0.238    14.335     0.200
     0.297    12.843     0.200
     0.430    13.293     0.200
     0.869    19.063     0.200
     1.335    24.622     0.200
     1.418    25.457     0.200
     1.404    26.320     0.200
     1.520    25.866     0.200
     1.556    27.248     0.200
     1.702    28.749     0.200
     1.738    30.131     0.200
     1.754    28.843     0.200
     1.775    29.992     0.200
     1.808    29.906     0.200
     1.793    31.886     0.200
     2.265    37.174     0.200
     2.272    37.592     0.200
     2.315    37.594     0.200
     2.753    42.378     0.200
     2.954    44.832     0.200
     3.078    45.786     0.200
     3.391    51.833     0.200
     4.288    62.472     0.200
     4.708    66.668     0.200
     5.948    81.890     0.200
     6.450    89.836     0.200
     0.691    14.581     0.200
     1.275    22.474     0.200
     1.508    26.444     0.200
     1.648    29.421     0.200
     1.649    28.807     0.200
     1.695    29.671     0.200
     1.738    28.263     0.200
     1.975    34.400     0.200
     2.003    32.168     0.200
     2.087    33.687     0.200
     2.444    39.230     0.200
     2.580    37.036     0.200
     0.152    11.774     0.200
     0.487    14.666     0.200
     0.487    16.061     0.200
     0.518    13.701     0.200
     0.963    20.209     0.200
     1.050    20.096     0.200
     1.187    21.097     0.200
     1.178    24.299     0.200
     1.257    21.977     0.200
     1.359    24.483     0.200
     1.556    26.591     0.200
     1.571    25.819     0.200
     1.609    27.764     0.200
     1.676    28.593     0.200
     1.887    30.432     0.200
     2.028    33.675     0.200
     2.198    35.701     0.200
     2.419    35.018     0.200
     2.532    41.295     0.200
     2.623    41.035     0.200
     2.891    44.806     0.200
     2.982    45.443     0.200
     3.109    46.668     0.200
     3.401    51.261     0.200
     3.619    53.613     0.200
     0.368    13.629     0.200
     0.446    13.112     0.200
     0.704    16.806     0.200
     0.762    15.924     0.200
     0.798    17.308     0.200
     1.005    18.996     0.200
     1.178    21.281     0.200
     1.296    23.199     0.200
     1.503    26.979     0.200
     1.524    25.242     0.200
     1.544    25.511     0.200
     1.593    26.833     0.200
     1.629    28.605     0.200
     1.873    30.856     0.200
     2.162    34.197     0.200
     2.469    39.300     0.200
     2.464    38.969     0.200
     2.632    40.398     0.200
     2.682    41.925     0.200
     2.790    42.361     0.200
     3.053    46.798     0.200
     3.048    44.754     0.200
     3.238    47.333     0.200
     3.380    47.176     0.200
     3.436    50.618     0.200
     3.550    51.685     0.200
     3.675    52.938     0.200
     4.030    57.286     0.200
     4.151    59.485     0.200
     4.547    62.558     0.200
     4.875    67.832     0.200
     5.266    71.161     0.200
     5.691    76.112     0.200
     6.480    85.491     0.200
     7.036    96.210     0.200
     0.510    15.395     0.200
     0.549    16.450     0.200
     0.766    16.412     0.200
     0.893    17.730     0.200
     0.956    20.298     0.200
     1.156    23.463     0.200
     1.405    24.053     0.200
     1.442    25.026     0.200
     1.617    25.281     0.200
     1.700    29.415     0.200
     1.796    28.093     0.200
     1.861    31.638     0.200
     1.883    31.678     0.200
     2.213    34.924     0.200
     2.539    39.926     0.200
     2.802    43.454     0.200
     2.819    42.745     0.200
     2.998    44.763     0.200
     3.157    46.610     0.200
     3.187    48.561     0.200
     3.298    49.961     0.200
     3.322    48.785     0.200
     3.442    50.782     0.200
     3.656    53.987     0.200
     3.789    55.634     0.200
     3.924    56.859     0.200
     4.302    62.247     0.200
     4.645    66.641     0.200
     4.861    70.125     0.200
     5.515    78.496     0.200
     6.266    84.825     0.200
     6.808    93.600     0.200
     7.382    96.409     0.200
     0.236    14.790     0.200
     0.312    13.299     0.200
     0.421    13.436     0.200
     0.858    19.331     0.200
     1.164    20.458     0.200
     1.404    25.454     0.200
     1.348    24.210     0.200
     1.535    26.028     0.200
     1.571    27.103     0.200
     1.695    28.463     0.200
     1.752    29.696     0.200
     1.797    28.673     0.200
     1.769    30.100     0.200
     1.799    31.743     0.200
     2.104    34.495     0.200
     2.106    34.370     0.200
     2.252    33.467     0.200
     2.254    36.939     0.200
     2.218    35.563     0.200
     2.287    37.756     0.200
     2.330    37.448     0.200
     2.834    42.266     0.200
     2.963    43.864     0.200
     5.955    81.343     0.200
     6.459    89.868     0.200
     7.019    94.934     0.200
     7.612   103.411     0.200
     1.219    22.022     0.200
     1.778    27.184     0.200
     1.803    28.997     0.200
     2.006    31.735     0.200
     2.199    34.477     0.200
     2.278    36.663     0.200
     2.239    35.409     0.200
     2.506    39.190     0.200
     2.629    41.755     0.200
     2.685    43.209     0.200
     2.752    41.729     0.200
     2.865    44.999     0.200
     3.099    46.269     0.200
     3.234    48.005     0.200
     3.356    50.872     0.200
     3.449    49.597     0.200
     3.578    51.779     0.200
     3.702    52.833     0.200
     3.955    57.088     0.200
     4.201    60.917     0.200
     4.628    64.637     0.200
     4.912    70.024     0.200
     5.071    73.668     0.200
     5.251    76.467     0.200
     5.331    73.427     0.200
     5.777    78.026     0.200
     5.790    82.275     0.200
     6.046    81.284     0.200
     6.569    89.976     0.200
     7.074   100.482     0.200
     0.256    15.481     0.200
     0.912    19.229     0.200
     1.285    23.973     0.200
     1.498    25.895     0.200
     1.727    28.516     0.200
     1.684    28.822     0.200
     1.695    28.492     0.200
     1.851    29.369     0.200
     2.045    34.403     0.200
     2.158    34.592     0.200
     2.146    34.937     0.200
     2.308    37.241     0.200
     2.319    34.013     0.200
     2.274    38.036     0.200
     2.450    39.277     0.200
     2.577    40.195     0.200
     2.765    40.409     0.200
     2.765    41.008     0.200
     2.803    42.059     0.200
     2.924    44.056     0.200
     3.048    45.906     0.200
     3.311    48.931     0.200
     3.549    52.158     0.200
     3.983    57.097     0.200
     4.258    62.789     0.200
     4.632    66.623     0.200
     4.717    67.627     0.200
     5.137    73.725     0.200
     6.419    89.660     0.200
     6.421    86.745     0.200
     6.786    96.780     0.200
     6.786    96.479     0.200
     6.870    93.501     0.200
     6.977    95.149     0.200
     6.999    92.593     0.200
     7.570   101.632     0.200
     7.602   100.264     0.200
     7.922   102.830     0.200
     7.984   102.404     0.200
     8.171   107.624     0.200
    12.365   161.878     0.200
     0.438    16.256     0.200
     0.581    16.679     0.200
     0.607    16.173     0.200
     0.933    18.369     0.200
     1.093    22.004     0.200
     1.490    26.279     0.200
     1.481    25.982     0.200
     1.509    25.856     0.200
     1.551    28.657     0.200
     1.617    26.991     0.200
     1.796    30.009     0.200
     1.875    30.781     0.200
     1.939    30.034     0.200
     1.966    34.017     0.200
     2.073    33.874     0.200
     2.065    33.666     0.200
     2.406    37.178     0.200
     2.731    39.996     0.200
     2.893    42.208     0.200
     3.074    43.992     0.200
     3.224    46.133     0.200
     3.346    47.713     0.200
     3.577    50.426     0.200
     3.680    53.420     0.200
     3.835    54.008     0.200
     0.532    12.426     0.200
     0.559    12.407     0.200
     0.875    18.125     0.200
     0.891    18.132     0.200
     0.982    18.476     0.200
     1.218    21.624     0.200
     1.483    24.733     0.200
     1.531    25.368     0.200
     1.668    27.467     0.200
     1.826    30.130     0.200
     2.206    35.288     0.200
     2.306    37.122     0.200
     2.956    45.743     0.200
     3.254    50.464     0.200
     3.324    50.949     0.200
     3.451    51.764     0.200
     3.967    61.044     0.200
     4.425    64.693     0.200
     0.247    15.329     0.200
     0.371    12.888     0.200
     0.409    13.644     0.200
     0.789    17.809     0.200
     1.114    20.216     0.200
     1.317    24.448     0.200
     1.429    25.235     0.200
     1.652    28.333     0.200
     1.628    27.115     0.200
     1.668    28.745     0.200
     1.724    27.892     0.200
     1.750    29.092     0.200
     1.843    31.406     0.200
     1.866    30.043     0.200
     1.911    30.713     0.200
     2.162    31.782     0.200
     2.182    35.950     0.200
     2.184    35.432     0.200
     2.202    35.921     0.200
     2.294    36.639     0.200
     2.317    39.680     0.200
     2.379    38.652     0.200
     2.427    38.994     0.200
     2.534    39.046     0.200
     2.530    39.491     0.200
     2.683    40.208     0.200
     2.811    43.610     0.200
     2.841    44.466     0.200
     2.881    42.490     0.200
     3.020    44.271     0.200
     3.143    45.737     0.200
     3.467    52.356     0.200
     3.637    53.074     0.200
     3.984    58.519     0.200
     4.060    57.037     0.200
     4.351    61.235     0.200
     4.534    66.906     0.200
     4.699    67.375     0.200
     4.706    67.702     0.200
     4.766    66.401     0.200
     5.209    70.930     0.200
     5.478    72.785     0.200
     5.549    81.660     0.200
     6.001    79.581     0.200
     6.901    94.882     0.200
     7.092    93.448     0.200
     7.671   103.396     0.200
     8.011   102.630     0.200
     1.100    20.639     0.200
     1.235    22.763     0.200
     1.251    23.474     0.200
     1.445    25.414     0.200
     1.546    26.636     0.200
     1.656    29.550     0.200
     1.685    27.509     0.200
     1.690    29.649     0.200
     1.746    30.694     0.200
     1.959    31.512     0.200
     1.993    34.915     0.200
     2.003    33.006     0.200
     2.529    36.766     0.200
     2.639    41.082     0.200
     2.936    45.610     0.200
     3.006    47.298     0.200
     3.133    48.912     0.200
     3.445    53.372     0.200
     4.107    62.644     0.200
     4.783    71.058     0.200
     6.040    85.285     0.200
     6.484    95.102     0.200
     0.257    14.519     0.200
     0.373    13.067     0.200
     0.804    18.338     0.200
     1.118    20.078     0.200
     1.382    24.995     0.200
     1.347    24.707     0.200
     1.582    26.668     0.200
     1.652    28.138     0.200
     1.627    28.236     0.200
     1.739    28.728     0.200
     1.742    28.892     0.200
     1.825    30.127     0.200
     1.810    30.605     0.200
     2.157    35.055     0.200
     2.200    36.054     0.200
     2.160    34.422     0.200
     2.248    36.095     0.200
     2.194    32.229     0.200
     2.332    37.912     0.200
     2.386    38.576     0.200
     2.529    40.512     0.200
     2.671    40.755     0.200
     2.820    44.820     0.200
     2.878    41.834     0.200
     3.011    43.690     0.200
     3.134    45.149     0.200
     3.384    48.925     0.200
     3.453    52.432     0.200
     3.631    52.959     0.200
     4.057    56.179     0.200
     4.343    61.235     0.200
     4.761    65.068     0.200
     5.206    70.270     0.200
     5.476    73.622     0.200
     0.186    10.626     0.200
     0.438    13.785     0.200
     0.633    14.213     0.200
     0.698    14.656     0.200
     1.046    19.086     0.200
     1.076    18.746     0.200
     1.146    21.726     0.200
     1.224    22.716     0.200
     1.334    24.624     0.200
     1.333    22.942     0.200
     1.416    25.468     0.200
     1.671    27.098     0.200
     1.780    30.921     0.200
     1.880    30.452     0.200
     1.908    28.623     0.200
     2.073    32.907     0.200
     2.119    34.168     0.200
     2.114    33.822     0.200
     2.163    34.251     0.200
     2.300    36.756     0.200
     2.584    41.343     0.200
     3.032    44.713     0.200
     3.153    47.203     0.200
     3.259    50.070     0.200
     3.385    48.893     0.200
     3.503    50.919     0.200
     3.628    52.361     0.200
     3.925    58.497     0.200
     4.564    63.533     0.200
     0.595    15.067     0.200
     0.715    14.561     0.200
     0.721    16.589     0.200
     0.709    16.733     0.200
     0.961    20.299     0.200
     1.037    19.700     0.200
     1.082    19.776     0.200
     1.045    21.107     0.200
     1.064    22.990     0.200
     1.310    24.616     0.200
     1.387    24.216     0.200
     1.567    26.520     0.200
     1.530    27.751     0.200
     1.676    26.552     0.200
     1.642    30.345     0.200
     1.760    29.571     0.200
     1.844    30.189     0.200
     2.265    35.783     0.200
     2.263    37.301     0.200
     2.489    35.557     0.200
     2.533    42.147     0.200
     2.902    43.849     0.200
     3.264    50.311     0.200
     3.316    49.409     0.200
     3.444    51.519     0.200
     3.963    58.257     0.200
     6.356    85.125     0.200
     6.779    97.901     0.200
     0.179    13.476     0.200
     0.255    13.593     0.200
     0.558    14.352     0.200
     1.006    20.531     0.200
     1.255    23.615     0.200
     1.292    22.690     0.200
     1.405    24.272     0.200
     1.415    26.258     0.200
     1.415    25.247     0.200
     1.563    26.621     0.200
     1.592    27.289     0.200
     1.613    27.852     0.200
     1.784    31.753     0.200
     1.811    29.832     0.200
     1.860    31.556     0.200
     1.945    30.774     0.200
     1.952    32.794     0.200
     1.961    32.979     0.200
     2.132    34.589     0.200
     2.159    35.168     0.200
     2.174    35.205     0.200
     2.347    38.578     0.200
     2.368    37.535     0.200
     2.401    38.745     0.200
     2.411    34.432     0.200
     2.489    39.125     0.200
     2.617    41.327     0.200
     2.723    41.493     0.200
     2.837    42.959     0.200
     2.962    43.901     0.200
     3.465    51.533     0.200
     4.172    60.285     0.200
     0.083    11.448     0.200
     0.355    12.564     0.200
     0.642    14.420     0.200
     1.094    21.048     0.200
     1.157    22.310     0.200
     1.289    22.373     0.200
     1.297    22.876     0.200
     1.358    22.466     0.200
     1.380    25.204     0.200
     1.494    24.772     0.200
     1.668    27.046     0.200
     1.733    31.094     0.200
     1.864    30.858     0.200
     1.841    30.828     0.200
     1.866    31.433     0.200
     1.889    32.172     0.200
     1.943    33.234     0.200
     2.031    31.812     0.200
     2.035    32.662     0.200
     2.043    33.669     0.200
     2.431    38.844     0.200
     2.485    39.506     0.200
     2.517    36.038     0.200
     2.686    43.570     0.200
     2.911    46.038     0.200
     5.803    78.693     0.200
     6.278    89.743     0.200
     0.229    12.671     0.200
     0.483    15.109     0.200
     0.714    16.707     0.200
     0.851    16.914     0.200
     0.980    19.407     0.200
     1.400    24.503     0.200
     1.401    23.691     0.200
     1.449    25.537     0.200
     1.559    26.350     0.200
     1.810    29.920     0.200
     1.858    31.056     0.200
     2.177    35.333     0.200
     2.455    38.595     0.200
     2.519    39.641     0.200
     2.999    44.141     0.200
     3.173    47.209     0.200
     3.172    45.021     0.200
     3.328    47.098     0.200
     3.450    49.486     0.200
     3.674    52.972     0.200
     3.788    55.838     0.200
     3.936    56.212     0.200
     4.347    59.517     0.200
     4.655    64.615     0.200
     5.059    70.198     0.200
     5.494    74.224     0.200
     0.079    11.451     0.200
     0.643    14.373     0.200
     1.153    21.814     0.200
     1.285    22.173     0.200
     1.294    22.871     0.200
     1.378    25.900     0.200
     1.485    25.442     0.200
     1.492    25.568     0.200
     1.670    27.991     0.200
     1.864    30.729     0.200
     1.866    32.299     0.200
     1.943    32.101     0.200
     2.032    32.768     0.200
     2.031    32.965     0.200
     2.040    34.073     0.200
     2.431    38.502     0.200
     2.443    38.759     0.200
     2.486    39.463     0.200
     2.519    37.278     0.200
     2.537    38.774     0.200
     2.687    42.316     0.200
     2.786    42.056     0.200
     2.912    44.190     0.200
     3.196    49.575     0.200
     3.420    52.663     0.200
     3.864    55.074     0.200
     4.121    61.685     0.200
     4.255    63.018     0.200
     5.282    74.926     0.200
     5.804    78.839     0.200
     6.279    89.099     0.200
     6.626    96.950     0.200
     6.832    93.447     0.200
     6.861    91.410     0.200
     7.465    98.157     0.200
     7.636   101.369     0.200
     0.375    10.129     0.200
     0.406    11.063     0.200
     0.649    15.736     0.200
     0.773    16.477     0.200
     0.950    17.723     0.200
     1.058    20.658     0.200
     1.352    22.430     0.200
     1.405    22.604     0.200
     1.425    25.375     0.200
     1.430    25.915     0.200
     1.503    26.766     0.200
     1.541    25.420     0.200
     1.669    27.423     0.200
     1.733    28.170     0.200
     1.832    30.223     0.200
     1.891    31.428     0.200
     1.918    33.319     0.200
     1.973    32.581     0.200
     2.112    35.449     0.200
     2.244    32.209     0.200
     2.272    36.586     0.200
     2.786    42.490     0.200
     2.877    45.821     0.200
     3.144    47.410     0.200
     3.363    49.650     0.200
     3.654    54.965     0.200
     3.873    58.102     0.200
     4.321    62.471     0.200
     0.139    12.992     0.200
     0.379    14.996     0.200
     0.726    17.243     0.200
     0.738    16.403     0.200
     0.893    17.890     0.200
     0.939    18.664     0.200
     1.274    23.444     0.200
     1.315    22.376     0.200
     1.334    24.345     0.200
     1.410    25.260     0.200
     1.424    24.894     0.200
     1.566    27.938     0.200
     1.676    29.560     0.200
     2.223    34.178     0.200
     4.090    61.391     0.200
     4.401    61.955     0.200
     4.401    62.357     0.200
     7.311   102.798     0.200
     0.349    12.954     0.200
     0.311    14.787     0.200
     0.331    13.556     0.200
     0.708    17.056     0.200
     0.793    18.366     0.200
     1.090    20.007     0.200
     1.323    25.181     0.200
     1.356    24.203     0.200
     2.646    39.941     0.200
     4.513    64.758     0.200
     4.635    68.327     0.200
     6.904    96.857     0.200
     0.307    14.586     0.200
     0.343    13.066     0.200
     0.345    13.447     0.200
     0.721    17.455     0.200
     0.785    17.907     0.200
     1.085    19.801     0.200
     1.345    24.575     0.200
     1.337    25.660     0.200
     1.353    25.080     0.200
     2.637    40.493     0.200
     4.504    65.410     0.200
     4.639    69.039     0.200
     6.910    95.832     0.200
     6.910    97.332     0.200
     0.398    10.780     0.200
     0.595    12.580     0.200
     0.689    16.187     0.200
     0.945    17.596     0.200
     1.247    23.471     0.200
     1.292    22.148     0.200
     2.547    38.197     0.200
     4.411    65.149     0.200
     4.459    64.388     0.200
     0.134    12.118     0.200
     0.356    13.825     0.200
     0.614    14.314     0.200
     0.739    15.751     0.200
     0.985    19.084     0.200
     1.148    21.779     0.200
     1.224    23.898     0.200
     1.262    22.757     0.200
     1.279    22.257     0.200
     1.489    27.299     0.200
     2.209    34.502     0.200
     4.071    61.977     0.200
     4.233    61.975     0.200
     0.284    14.225     0.200
     0.370    12.822     0.200
     0.811    18.675     0.200
     1.113    20.656     0.200
     1.337    24.537     0.200
     1.367    24.189     0.200
     1.855    30.493     0.200
     2.662    40.180     0.200
     4.529    67.592     0.200
     4.663    69.226     0.200
     6.883    94.315     0.200
     8.298   118.804     0.200
     0.351    13.728     0.200
     0.308    14.226     0.200
     0.710    17.537     0.200
     0.795    18.447     0.200
     1.092    20.180     0.200
     1.324    24.470     0.200
     1.357    24.590     0.200
     2.648    40.325     0.200
     4.515    66.540     0.200
     4.638    65.596     0.200
     6.901    97.888     0.200
     6.901    97.688     0.200
    10.508   143.097     0.200
    16.651   217.906     0.200
     0.285    14.834     0.200
     0.396    13.347     0.200
     0.705    17.135     0.200
     1.135    20.520     0.200
     1.402    24.205     0.200
     2.694    40.727     0.200
     4.561    66.544     0.200
     4.667    69.497     0.200
     6.823    96.741     0.200
     8.579   119.444     0.200
    17.954   231.842     0.200
     0.331    13.959     0.200
     0.547    13.534     0.200
     0.565    13.931     0.200
     0.703    14.921     0.200
     1.049    19.580     0.200
     1.215    22.639     0.200
     1.405    22.619     0.200
     1.472    24.941     0.200
     1.582    26.256     0.200
     1.627    28.931     0.200
     1.896    30.194     0.200
     3.758    56.470     0.200
     4.421    61.330     0.200
    10.707   143.977     0.200
     0.151    13.032     0.200
     0.375    14.720     0.200
     0.747    16.580     0.200
     0.727    17.015     0.200
     0.929    18.750     0.200
     1.310    23.014     0.200
     1.345    24.402     0.200
     1.407    24.676     0.200
     1.418    25.351     0.200
     1.429    25.427     0.200
     1.578    28.377     0.200
     1.685    29.584     0.200
     2.216    34.236     0.200
     4.083    60.449     0.200
     7.315   100.727     0.200
     1.180    21.436     0.200
     1.182    21.816     0.200
     3.048    48.337     0.200
     4.913    75.181     0.200
    14.136   188.740     0.200
     0.234    13.844     0.200
     0.429    13.668     0.200
     0.660    17.166     0.200
     0.879    19.509     0.200
     1.159    21.044     0.200
     1.444    24.818     0.200
     1.451    25.434     0.200
     1.501    26.347     0.200
     2.735    40.647     0.200
     4.602    68.267     0.200
     4.660    66.190     0.200
     0.174    13.035     0.200
     0.481    15.652     0.200
     0.539    15.473     0.200
     0.608    15.669     0.200
     0.859    17.242     0.200
     0.881    17.885     0.200
     1.076    20.912     0.200
     1.381    24.748     0.200
     1.473    24.775     0.200
     1.510    26.948     0.200
     1.519    27.445     0.200
     1.776    30.740     0.200
     2.376    37.543     0.200
     4.243    63.055     0.200
     7.151    99.113     0.200
     7.151    99.526     0.200
     0.286    14.253     0.200
     0.363    12.955     0.200
     0.732    18.254     0.200
     0.804    18.715     0.200
     1.106    20.284     0.200
     1.343    23.831     0.200
     1.359    24.442     0.200
     2.654    39.623     0.200
     4.660    64.415     0.200
     6.890    97.389     0.200
     1.119    20.459     0.200
     1.246    21.467     0.200
     2.903    43.333     0.200
     4.524    66.713     0.200
     4.758    71.183     0.200
     6.771    97.695     0.200
     0.148    14.855     0.200
     0.543    16.339     0.200
     0.577    16.350     0.200
     0.774    17.551     0.200
     0.987    21.070     0.200
     1.096    20.594     0.200
     1.120    21.919     0.200
     1.223    23.506     0.200
     1.310    25.592     0.200
     1.347    24.365     0.200
     1.449    24.977     0.200
     1.678    28.506     0.200
     1.768    30.045     0.200
     1.911    32.876     0.200
     3.081    44.635     0.200
     4.751    65.938     0.200
     4.942    71.502     0.200
     6.550    93.946     0.200
     0.230    13.404     0.200
     0.267    13.481     0.200
     0.406    13.453     0.200
     0.722    17.565     0.200
     0.849    19.286     0.200
     1.147    21.703     0.200
     1.320    24.193     0.200
     1.377    25.732     0.200
     1.405    25.097     0.200
     1.874    32.530     0.200
     2.700    40.484     0.200
     4.567    65.396     0.200
     4.685    67.719     0.200
     5.439    75.718     0.200
     6.846    95.801     0.200
     6.841    93.058     0.200
     8.272   117.163     0.200
    10.074   135.126     0.200
    17.970   231.688     0.200
     0.162    14.028     0.200
     0.305    15.655     0.200
     0.436    14.029     0.200
     0.664    16.863     0.200
     0.886    19.280     0.200
     1.167    21.101     0.200
     1.252    24.007     0.200
     1.457    25.526     0.200
     1.443    25.077     0.200
     1.848    28.857     0.200
     2.742    41.321     0.200
    10.005   137.062     0.200
     0.278    14.014     0.200
     0.318    13.147     0.200
     0.348    12.496     0.200
     0.778    18.182     0.200
     1.093    19.906     0.200
     1.321    23.044     0.200
     1.390    25.629     0.200
     1.872    33.213     0.200
     2.622    39.454     0.200
     0.253    12.534     0.200
     0.578    14.842     0.200
     0.565    15.593     0.200
     0.938    17.747     0.200
     0.927    17.774     0.200
     1.060    20.216     0.200
     1.854    30.804     0.200
     2.375    34.468     0.200
     4.241    63.793     0.200
     4.597    65.037     0.200
     0.220    13.800     0.200
     0.387    13.650     0.200
     0.692    17.592     0.200
     0.834    19.037     0.200
     1.124    20.348     0.200
     1.295    23.853     0.200
     1.399    24.940     0.200
     2.688    39.702     0.200
     4.555    68.716     0.200
     4.652    66.573     0.200
     6.866    95.540     0.200
     6.866    95.743     0.200
     9.527   121.290     0.200
    10.053   135.443     0.200
    12.962   172.601     0.200
     0.272    13.542     0.200
     0.342    13.216     0.200
     0.311    14.579     0.200
     0.715    17.562     0.200
     0.785    18.546     0.200
     1.084    19.759     0.200
     1.348    24.883     0.200
     1.346    24.400     0.200
     2.638    39.329     0.200
     4.504    68.044     0.200
     6.910    99.968     0.200
     6.910   100.468     0.200
     6.910    99.039     0.200
     0.160    16.354     0.200
     0.401    17.446     0.200
     0.661    18.009     0.200
     0.756    19.201     0.200
     0.943    20.618     0.200
     1.366    24.980     0.200
     1.332    24.173     0.200
     1.437    25.856     0.200
     1.458    26.305     0.200
     2.236    35.030     0.200
     4.103    62.343     0.200
     4.435    62.461     0.200
     7.291   100.651     0.200
     0.231    13.572     0.200
     0.285    14.445     0.200
     0.391    13.410     0.200
     1.131    20.274     0.200
     1.312    24.257     0.200
     1.395    25.186     0.200
     4.554    68.918     0.200
     4.554    70.418     0.200
     4.667    65.110     0.200
     6.862    95.493     0.200
     6.862    97.294     0.200
     0.392    12.171     0.200
     0.439    13.328     0.200
     0.835    16.714     0.200
     0.818    16.508     0.200
     0.836    16.598     0.200
     7.348   106.802     0.200
     7.348   107.099     0.200
    10.577   145.420     0.200
     0.408    12.704     0.200
     0.418    13.192     0.200
     0.718    15.588     0.200
     0.784    16.117     0.200
     0.814    16.467     0.200
     0.865    16.666     0.200
     1.161    19.813     0.200
     1.256    20.708     0.200
     1.483    25.858     0.200
     1.567    26.476     0.200
     3.977    62.552     0.200
     7.382   101.018     0.200
     7.382   100.819     0.200
     0.195    13.612     0.200
     0.319    12.669     0.200
     0.427    12.695     0.200
     0.824    18.569     0.200
     0.848    18.586     0.200
     1.172    20.613     0.200
     1.373    23.568     0.200
     1.951    32.871     0.200
     2.684    39.968     0.200
     4.752    67.830     0.200
     6.842    95.644     0.200
     6.842    95.445     0.200
     9.463   123.311     0.200
     0.160    14.032     0.200
     0.311    14.668     0.200
     0.434    14.125     0.200
     0.659    16.806     0.200
     0.885    18.372     0.200
     1.164    20.909     0.200
     1.247    23.941     0.200
     1.457    25.597     0.200
     2.741    41.107     0.200
     4.607    68.227     0.200
     4.663    69.080     0.200
     6.822    97.187     0.200
     9.498   121.009     0.200
     0.203    13.401     0.200
     0.439    13.942     0.200
     0.716    16.510     0.200
     1.178    20.514     0.200
     1.302    24.069     0.200
     1.441    25.254     0.200
     1.888    32.136     0.200
     2.735    42.446     0.200
     4.602    67.659     0.200
     4.704    68.477     0.200
     6.813    93.459     0.200
     6.813    93.358     0.200
     6.858    95.835     0.200
     8.246   115.635     0.200
     8.616   122.319     0.200
     9.472   121.475     0.200
    12.336   161.905     0.200
    21.349   278.619     0.200
    21.435   281.122     0.200
     0.245    15.538     0.200
     0.318    14.283     0.200
     0.583    16.885     0.200
     0.769    19.019     0.200
     1.026    20.014     0.200
     1.216    24.400     0.200
     1.366    24.852     0.200
     1.456    25.301     0.200
     1.447    25.807     0.200
     1.704    30.400     0.200
     2.628    39.626     0.200
     4.492    67.072     0.200
     4.519    64.750     0.200
     6.957    97.399     0.200
     6.957    97.299     0.200
    17.819   229.540     0.200
    20.763   269.988     0.200
    21.258   275.814     0.200
     0.190    13.563     0.200
     0.283    13.873     0.200
     0.427    13.593     0.200
     1.163    21.002     0.200
     1.282    24.022     0.200
     1.438    25.093     0.200
     1.863    31.633     0.200
     2.729    41.536     0.200
     6.826    96.524     0.200
     0.465    13.005     0.200
     0.440    12.402     0.200
     1.161    20.879     0.200
     1.283    22.461     0.200
     2.609    38.687     0.200
     4.473    65.930     0.200
     4.798    68.135     0.200
     0.267    13.665     0.200
     0.344    13.166     0.200
     0.314    14.216     0.200
     1.085    20.418     0.200
     1.350    24.122     0.200
     2.640    39.663     0.200
     4.507    66.179     0.200
     4.633    67.911     0.200
     6.909    96.250     0.200
     6.909    96.351     0.200
    13.000   172.264     0.200
    21.298   273.132     0.200
    21.807   285.493     0.200
     0.272    13.384     0.200
     0.368    12.765     0.200
     0.807    18.442     0.200
     1.112    20.284     0.200
     1.349    25.817     0.200
     1.359    23.994     0.200
     2.656    40.463     0.200
     4.523    67.676     0.200
     4.668    67.988     0.200
     6.826    96.801     0.200
     6.886    96.102     0.200
     6.886    97.102     0.200
     8.310   118.485     0.200
     9.530   121.992     0.200
    12.259   163.294     0.200
    18.661   241.586     0.200
     0.642    14.671     0.200
     2.858    43.807     0.200
     4.724    72.034     0.200
     0.271    13.633     0.200
     0.392    15.012     0.200
     0.646    16.750     0.200
     1.027    19.303     0.200
     1.332    23.244     0.200
     1.747    30.549     0.200
     2.607    40.165     0.200
     4.473    67.393     0.200
     4.555    66.032     0.200
     6.959    97.474     0.200
     6.959    99.375     0.200
    21.813   284.037     0.200
     0.126    14.020     0.200
     0.274    13.792     0.200
     0.554    13.824     0.200
     0.697    16.961     0.200
     1.003    20.290     0.200
     1.237    22.761     0.200
     1.284    22.799     0.200
     1.390    24.065     0.200
     1.407    24.575     0.200
     1.933    33.384     0.200
     2.858    41.848     0.200
     4.761    69.932     0.200
     9.383   119.038     0.200
     0.256    13.695     0.200
     0.367    12.899     0.200
     0.292    15.072     0.200
     0.719    17.590     0.200
     0.810    18.233     0.200
     1.109    20.143     0.200
     1.368    24.614     0.200
     2.661    39.723     0.200
     4.528    66.438     0.200
     4.655    64.956     0.200
     6.886    95.326     0.200
     6.886    94.926     0.200
    10.518   141.037     0.200
    12.998   170.800     0.200
    21.791   281.975     0.200
     0.271    13.328     0.200
     0.281    14.013     0.200
     0.282    14.221     0.200
     0.366    13.023     0.200
     0.806    17.990     0.200
     1.110    20.349     0.200
     1.359    24.234     0.200
     2.655    39.608     0.200
     4.522    64.821     0.200
     4.665    68.157     0.200
     6.823    93.972     0.200
     6.888    96.714     0.200
     6.888    97.214     0.200
     9.533   121.299     0.200
    10.106   136.657     0.200
    10.535   146.146     0.200
    13.015   173.810     0.200
    16.662   220.147     0.200
    21.379   279.495     0.200
     0.221    13.512     0.200
     0.284    14.184     0.200
     0.399    13.230     0.200
     1.305    24.865     0.200
     1.406    24.488     0.200
     2.697    40.411     0.200
     4.564    65.923     0.200
     4.670    67.392     0.200
    14.477   193.440     0.200
    20.729   267.887     0.200
    21.397   280.391     0.200
     0.268    13.587     0.200
     0.304    14.164     0.200
     0.350    13.026     0.200
     0.718    17.431     0.200
     0.793    18.459     0.200
     1.092    19.567     0.200
     1.333    23.562     0.200
     1.353    24.329     0.200
     2.645    40.948     0.200
     4.512    64.662     0.200
     4.642    67.937     0.200
     0.156    13.900     0.200
     0.421    14.105     0.200
     0.633    17.425     0.200
     0.872    19.736     0.200
     1.145    20.550     0.200
     1.228    24.290     0.200
     1.451    24.981     0.200
     1.815    28.238     0.200
     2.730    39.653     0.200
     4.596    65.380     0.200
     4.636    68.819     0.200
     6.839    98.202     0.200
     6.839    98.602     0.200
    12.892   169.661     0.200
     0.263    13.970     0.200
     0.219    13.386     0.200
     0.419    13.452     0.200
     0.719    16.748     0.200
     0.862    19.179     0.200
     1.159    20.715     0.200
     1.312    24.729     0.200
     1.878    32.520     0.200
     2.714    39.072     0.200
     0.266    14.243     0.200
     0.298    15.066     0.200
     0.716    17.796     0.200
     0.973    19.197     0.200
     1.237    23.616     0.200
     1.317    22.979     0.200
     1.411    24.780     0.200
     1.671    29.651     0.200
     7.011   101.226     0.200
     7.011   100.929     0.200
     0.383    12.746     0.200
     1.118    20.380     0.200
     1.278    23.809     0.200
     1.403    24.849     0.200
     2.688    39.553     0.200
     4.554    65.272     0.200
     4.637    65.803     0.200
     9.537   122.623     0.200
    10.037   138.987     0.200
    12.946   172.134     0.200
    21.287   273.896     0.200
     0.301    14.897     0.200
     0.283    13.405     0.200
     0.343    13.303     0.200
     0.731    17.875     0.200
     1.087    20.129     0.200
     1.340    24.879     0.200
     1.348    25.682     0.200
     2.634    41.275     0.200
     4.501    64.387     0.200
     4.645    69.207     0.200
     6.910    99.465     0.200
     6.910    98.981     0.200
     0.304    16.790     0.200
     0.423    14.018     0.200
     0.671    16.925     0.200
     1.156    21.069     0.200
     1.263    23.314     0.200
     2.728    41.220     0.200
     4.594    66.041     0.200
     4.664    67.732     0.200
     6.832    97.830     0.200
     6.832    97.431     0.200
     8.329   118.759     0.200
    10.018   138.548     0.200
    12.924   173.434     0.200
     0.200    13.431     0.200
     0.281    14.185     0.200
     0.419    13.870     0.200
     0.866    18.860     0.200
     1.157    20.464     0.200
     1.863    32.021     0.200
     2.720    41.630     0.200
     4.586    66.045     0.200
     0.224    13.341     0.200
     0.281    14.668     0.200
     0.400    13.392     0.200
     0.709    16.383     0.200
     0.844    19.101     0.200
     1.139    19.955     0.200
     1.308    23.889     0.200
     1.404    23.861     0.200
     2.697    40.981     0.200
     0.257    13.346     0.200
     0.330    14.298     0.200
     0.386    14.736     0.200
     0.387    15.425     0.200
     0.703    17.241     0.200
     0.998    19.196     0.200
     1.275    23.264     0.200
     1.340    25.510     0.200
     2.558    40.489     0.200
     4.425    63.810     0.200
     4.560    68.227     0.200
     6.995   100.809     0.200
     6.995    97.559     0.200
     0.258    13.078     0.200
     0.366    12.418     0.200
     0.293    14.124     0.200
     0.721    17.679     0.200
     0.808    18.557     0.200
     1.108    20.260     0.200
     1.331    24.562     0.200
     1.366    23.242     0.200
     1.848    28.372     0.200
     2.660    40.949     0.200
     6.887    97.517     0.200
     6.887    96.744     0.200
    16.649   218.394     0.200
    18.643   239.727     0.200
     0.312    13.866     0.200
     0.285    13.185     0.200
     0.531    13.910     0.200
     0.683    18.405     0.200
     0.917    19.607     0.200
     0.934    19.414     0.200
     0.972    21.166     0.200
     1.092    20.065     0.200
     1.193    21.493     0.200
     1.292    24.730     0.200
     1.341    26.957     0.200
     1.384    23.964     0.200
     2.761    42.192     0.200
     0.177    13.693     0.200
     0.441    13.815     0.200
     1.176    20.834     0.200
     2.743    40.348     0.200
     6.812    96.368     0.200
     0.188    13.465     0.200
     0.189    14.181     0.200
     0.312    12.520     0.200
     0.437    12.752     0.200
     0.822    17.856     0.200
     0.859    18.532     0.200
     1.181    21.668     0.200
     1.384    23.304     0.200
     1.956    33.731     0.200
     2.695    40.506     0.200
     4.562    64.525     0.200
     4.758    69.626     0.200
     6.831    94.441     0.200
     8.477   119.927     0.200
    13.066   174.872     0.200
    16.686   218.123     0.200
     0.343    12.583     0.200
     0.561    15.131     0.200
     0.509    13.155     0.200
     0.682    15.529     0.200
     0.944    18.668     0.200
     0.994    18.888     0.200
     1.452    23.341     0.200
     1.926    32.607     0.200
     2.322    35.479     0.200
     4.644    64.493     0.200
     7.177   101.525     0.200
     8.607   118.942     0.200
    10.476   145.229     0.200
    13.399   178.113     0.200
    22.207   289.533     0.200
     0.128    14.102     0.200
     0.273    14.188     0.200
     0.554    14.623     0.200
     1.003    20.288     0.200
     1.238    23.141     0.200
     1.391    24.657     0.200
     1.407    24.670     0.200
     1.935    33.815     0.200
     2.858    42.545     0.200
     0.235    13.402     0.200
     0.378    13.329     0.200
     0.297    14.548     0.200
     0.703    17.339     0.200
     1.118    20.098     0.200
     1.309    24.767     0.200
     1.386    24.569     0.200
     2.677    40.505     0.200
     4.544    64.221     0.200
     0.290    14.313     0.200
     0.390    13.674     0.200
     0.835    18.581     0.200
     1.129    20.241     0.200
     2.688    41.252     0.200
     4.555    64.467     0.200
     4.663    65.600     0.200
     4.663    69.209     0.200
     6.862    98.746     0.200
     6.862    97.645     0.200
     8.358   116.585     0.200
     9.520   121.484     0.200
    14.482   193.717     0.200
     0.307    13.296     0.200
     0.356    13.129     0.200
     0.769    17.608     0.200
     0.787    18.193     0.200
     1.101    19.938     0.200
     1.332    24.143     0.200
     1.383    25.746     0.200
     1.399    25.662     0.200
     1.873    31.918     0.200
     2.633    40.059     0.200
     4.500    65.372     0.200
     6.903    98.822     0.200
     0.291    14.482     0.200
     0.291    14.273     0.200
     0.428    13.874     0.200
     0.683    16.900     0.200
     1.163    20.400     0.200
     1.858    31.643     0.200
     2.731    41.798     0.200
     4.598    68.516     0.200
     6.825    95.022     0.200
     0.139    13.088     0.200
     0.461    15.033     0.200
     0.572    16.541     0.200
     0.762    17.024     0.200
     0.883    18.513     0.200
     1.142    20.883     0.200
     1.717    29.668     0.200
     2.425    37.517     0.200
     4.291    62.632     0.200
     7.122    99.804     0.200
     0.190    12.824     0.200
     0.433    13.083     0.200
     1.170    20.785     0.200
     1.871    29.956     0.200
     9.483   121.820     0.200
     0.189    12.258     0.200
     0.451    14.200     0.200
     0.640    14.605     0.200
     0.813    16.986     0.200
     0.929    16.923     0.200
     0.971    18.538     0.200
     1.377    22.597     0.200
     1.407    25.147     0.200
     2.275    35.225     0.200
     4.141    60.740     0.200
     7.245   101.119     0.200
     0.345    13.139     0.200
     0.266    13.564     0.200
     0.313    14.811     0.200
     0.314    14.083     0.200
     0.710    17.572     0.200
     0.789    17.957     0.200
     1.086    19.888     0.200
     2.642    42.030     0.200
     4.509    66.847     0.200
     4.634    67.784     0.200
     6.907   100.750     0.200
     6.907    99.242     0.200
    10.088   137.030     0.200
     0.360    12.006     0.200
     0.509    14.565     0.200
     0.572    14.927     0.200
     0.956    17.944     0.200
     1.457    23.095     0.200
     1.942    31.483     0.200
     7.174   100.984     0.200
     0.305    14.088     0.200
     0.793    18.686     0.200
     1.093    20.195     0.200
     2.645    41.973     0.200
     4.512    66.588     0.200
     4.642    68.669     0.200
     6.902    96.750     0.200
     6.902    98.500     0.200
     0.160    13.913     0.200
     0.320    15.021     0.200
     0.428    14.085     0.200
     0.652    17.377     0.200
     0.879    19.826     0.200
     1.157    21.483     0.200
     1.242    24.681     0.200
     1.453    25.825     0.200
     1.833    31.835     0.200
     2.736    41.654     0.200
     4.602    68.977     0.200
     4.654    68.373     0.200
     6.829    96.785     0.200
    21.290   276.421     0.200
     0.221    13.479     0.200
     0.255    14.192     0.200
     0.425    13.602     0.200
     0.726    16.885     0.200
     0.868    19.137     0.200
     1.166    20.654     0.200
     1.318    24.885     0.200
     1.887    33.914     0.200
     2.718    42.340     0.200
     0.202    13.082     0.200
     0.198    13.621     0.200
     0.554    14.273     0.200
     0.768    17.669     0.200
     0.995    20.527     0.200
     1.295    22.330     0.200
     1.985    32.769     0.200
     2.842    44.071     0.200
     4.709    69.583     0.200
     4.808    70.435     0.200
     6.699    97.064     0.200
    12.933   172.012     0.200
     0.091    10.948     0.200
     0.365    12.750     0.200
     0.649    14.137     0.200
     0.657    13.944     0.200
     0.978    18.497     0.200
     1.299    21.742     0.200
     1.554    26.576     0.200
     2.224    36.358     0.200
     4.088    62.701     0.200
     0.453    13.422     0.200
     0.462    13.814     0.200
     0.715    16.757     0.200
     0.831    16.703     0.200
     0.938    17.864     0.200
     0.947    18.754     0.200
     1.161    23.056     0.200
     1.265    22.646     0.200
     1.364    23.785     0.200
     1.432    26.794     0.200
     1.526    25.397     0.200
     1.802    29.682     0.200
     3.198    50.187     0.200
     5.047    74.410     0.200
    11.997   164.807     0.200
     1.138    22.854     0.200
     1.823    32.758     0.200
     4.591    68.763     0.200
     6.452    93.943     0.200
    11.672   164.798     0.200
    11.915   164.893     0.200
    19.279   252.347     0.200
     0.251    12.159     0.200
     0.447    14.270     0.200
     0.692    15.105     0.200
     0.823    17.175     0.200
     0.930    18.026     0.200
     0.994    17.886     0.200
     1.357    22.544     0.200
     1.504    25.831     0.200
     2.244    35.193     0.200
     2.244    35.294     0.200
     0.222    13.398     0.200
     0.284    14.971     0.200
     0.399    13.524     0.200
     0.844    19.033     0.200
     1.139    20.600     0.200
     1.305    25.153     0.200
     1.858    28.255     0.200
     1.858    30.407     0.200
     2.697    42.007     0.200
     4.670    67.784     0.200
     0.122    10.015     0.200
     0.513    13.152     0.200
     0.559    13.211     0.200
     0.677    14.538     0.200
     1.034    20.371     0.200
     1.127    21.184     0.200
     1.175    20.926     0.200
     1.281    22.485     0.200
     1.361    22.162     0.200
     1.870    32.117     0.200
     2.985    43.805     0.200
     2.985    45.703     0.200
     4.848    72.864     0.200
     6.631    94.256     0.200
     0.154    13.201     0.200
     0.244    13.642     0.200
     0.367    12.812     0.200
     0.303    14.560     0.200
     0.704    16.981     0.200
     0.812    18.517     0.200
     1.107    19.780     0.200
     1.153    21.239     0.200
     1.313    24.664     0.200
     1.375    23.847     0.200
     1.837    30.059     0.200
     2.665    40.389     0.200
     3.157    45.746     0.200
     4.532    67.105     0.200
     4.532    66.605     0.200
     4.646    65.774     0.200
     5.947    82.592     0.200
     6.885    96.741     0.200
     6.885    99.140     0.200
    12.983   171.775     0.200
    16.635   218.762     0.200
     0.330    14.108     0.200
     0.703    17.858     0.200
     0.998    19.414     0.200
     1.275    22.982     0.200
     1.763    30.461     0.200
     2.558    40.406     0.200
     4.424    66.227     0.200
     0.195    13.563     0.200
     0.283    14.140     0.200
     0.283    15.132     0.200
     0.423    13.797     0.200
     0.694    17.336     0.200
     0.870    19.481     0.200
     1.160    20.504     0.200
     1.286    24.128     0.200
     1.863    30.049     0.200
     2.724    41.251     0.200
     4.591    69.967     0.200
     4.679    69.529     0.200
     6.833    96.295     0.200
     8.351   117.080     0.200
     0.411    13.197     0.200
     0.858    18.875     0.200
     1.147    20.501     0.200
     1.423    24.184     0.200
     2.712    41.235     0.200
     3.206    45.181     0.200
     4.579    68.951     0.200
     4.668    66.018     0.200
     6.822    94.273     0.200
     6.842    96.440     0.200
    10.041   136.415     0.200
    12.947   173.193     0.200
    16.591   217.370     0.200
    18.625   239.436     0.200
    21.315   277.144     0.200
     0.349    12.361     0.200
     0.536    14.173     0.200
     0.879    17.675     0.200
     0.951    19.040     0.200
     0.998    19.982     0.200
     1.260    23.432     0.200
     1.264    22.883     0.200
     1.517    25.034     0.200
     1.885    31.214     0.200
     3.170    49.136     0.200
     5.027    75.466     0.200
     0.680    16.001     0.200
     1.484    26.872     0.200
     1.535    28.706     0.200
     0.286    13.802     0.200
     0.274    13.046     0.200
     0.360    12.843     0.200
     0.800    18.510     0.200
     1.104    20.168     0.200
     1.165    21.457     0.200
     1.347    24.726     0.200
     1.354    23.844     0.200
     2.650    40.325     0.200
     4.517    66.237     0.200
     4.517    66.339     0.200
     4.659    65.967     0.200
     0.154    14.013     0.200
     0.433    13.455     0.200
     0.648    17.242     0.200
     1.161    21.063     0.200
     1.834    30.109     0.200
     2.741    41.520     0.200
     3.241    46.788     0.200
     4.607    68.644     0.200
     4.654    66.991     0.200
     6.825    94.263     0.200
     9.992   136.704     0.200
    12.552   172.422     0.200
    12.552   172.421     0.200
    12.898   171.483     0.200
    21.290   275.359     0.200
     0.510    12.438     0.200
     0.648    14.326     0.200
     2.951    47.255     0.200
     3.476    49.727     0.200
     4.812    71.839     0.200
     9.435   123.798     0.200
     0.271    13.670     0.200
     0.303    13.998     0.200
     0.350    13.248     0.200
     0.722    17.307     0.200
     0.792    17.990     0.200
     1.092    19.985     0.200
     1.350    24.470     0.200
     1.336    25.636     0.200
     1.356    24.905     0.200
     2.643    41.283     0.200
     3.133    44.865     0.200
     4.510    66.997     0.200
     6.903    99.672     0.200
     0.687    16.178     0.200
     2.288    37.989     0.200
     2.822    42.567     0.200
     4.150    65.360     0.200
     4.277    64.384     0.200
     7.300   102.608     0.200
    13.077   178.381     0.200
     4.915    76.459     0.200
     6.580    96.330     0.200
     3.068    51.772     0.200
     4.932    75.120     0.200
     9.737   135.637     0.200
    12.624   174.156     0.200
    14.108   195.139     0.200
    16.222   220.861     0.200
    18.538   247.333     0.200
    21.326   279.897     0.200
     1.917    34.493     0.200
     3.020    49.871     0.200
     3.531    53.301     0.200
     4.757    74.571     0.200
     6.587    93.933     0.200
     0.303    12.808     0.200
     0.310    12.620     0.200
     0.500    13.105     0.200
     0.906    18.775     0.200
     0.948    19.176     0.200
     1.071    20.046     0.200
     1.224    21.264     0.200
     1.294    25.045     0.200
     1.538    27.992     0.200
     2.375    36.832     0.200
     2.659    40.612     0.200
     2.701    43.526     0.200
     2.736    42.614     0.200
     3.292    45.233     0.200
     4.587    67.707     0.200
     0.128    14.195     0.200
     0.546    14.620     0.200
     1.396    24.199     0.200
     1.415    24.484     0.200
     2.849    43.741     0.200
     3.340    46.815     0.200
     4.716    70.258     0.200
     0.270    13.588     0.200
     0.352    13.230     0.200
     0.794    18.573     0.200
     1.094    20.168     0.200
     1.352    24.058     0.200
     2.267    35.683     0.200
     2.267    35.984     0.200
     2.569    41.159     0.200
     2.617    40.595     0.200
     2.617    40.896     0.200
     2.645    40.268     0.200
     2.645    40.369     0.200
     4.512    66.380     0.200
     4.512    67.181     0.200
     4.646    67.717     0.200
     4.646    69.017     0.200
     6.901    96.102     0.200
     0.240    15.599     0.200
     0.280    14.541     0.200
     0.325    14.315     0.200
     0.386    16.599     0.200
     0.451    17.586     0.200
     0.566    16.801     0.200
     0.774    18.767     0.200
     1.026    19.830     0.200
     1.024    20.156     0.200
     1.196    25.352     0.200
     1.199    24.410     0.200
     1.375    24.359     0.200
     1.441    25.785     0.200
     1.556    26.846     0.200
     1.692    29.430     0.200
     2.159    36.411     0.200
     2.260    35.624     0.200
     2.260    35.823     0.200
     2.556    39.173     0.200
     2.556    39.773     0.200
     2.602    41.640     0.200
     2.602    42.441     0.200
     2.633    41.277     0.200
     2.633    41.777     0.200
     3.152    46.224     0.200
     3.152    46.923     0.200
     4.497    67.529     0.200
     4.497    67.930     0.200
     4.509    64.483     0.200
     6.958    97.009     0.200
     8.422   116.123     0.200
     9.967   135.486     0.200
    10.820   147.734     0.200
    12.887   170.910     0.200
     0.188    13.959     0.200
     0.389    13.414     0.200
     1.117    20.318     0.200
     2.621    39.966     0.200
     2.669    41.516     0.200
     2.698    40.372     0.200
     3.200    46.017     0.200
     4.564    67.397     0.200
     4.622    69.121     0.200
     5.364    74.057     0.200
     6.868    95.195     0.200
     6.868    98.105     0.200
     6.868    97.842     0.200
    12.567   170.465     0.200
    21.266   277.585     0.200
     0.162    12.638     0.200
     0.382    13.775     0.200
     1.384    24.884     0.200
     2.299    36.807     0.200
     2.601    41.385     0.200
     2.649    42.520     0.200
     2.677    42.692     0.200
     3.166    47.782     0.200
     4.544    70.106     0.200
     4.665    67.091     0.200
     5.439    75.560     0.200
     7.302   100.366     0.200
     8.577   121.843     0.200
    12.988   173.559     0.200
    14.499   192.433     0.200
    15.554   205.612     0.200
    16.634   220.811     0.200
    23.232   293.812     0.200
     0.164    12.685     0.200
     0.241    13.090     0.200
     0.283    14.104     0.200
     0.384    12.920     0.200
     0.468    15.348     0.200
     0.717    17.337     0.200
     0.828    18.645     0.200
     1.126    20.170     0.200
     1.321    25.287     0.200
     1.386    24.027     0.200
     1.857    31.716     0.200
     2.603    40.028     0.200
     2.651    42.159     0.200
     2.680    41.831     0.200
     3.169    47.027     0.200
     4.546    67.850     0.200
     0.163    14.305     0.200
     0.242    13.684     0.200
     0.432    14.168     0.200
     0.662    16.788     0.200
     0.882    19.717     0.200
     1.163    20.743     0.200
     1.454    24.848     0.200
     2.362    37.149     0.200
     2.662    40.946     0.200
     2.710    42.491     0.200
     2.739    42.352     0.200
     3.236    46.547     0.200
     4.605    68.274     0.200
     0.579    12.467     0.200
     1.158    21.610     0.200
     1.445    26.132     0.200
     2.398    38.534     0.200
     2.677    42.088     0.200
     2.753    43.791     0.200
     4.284    64.024     0.200
     4.596    69.694     0.200
     0.136    12.971     0.200
     0.792    18.116     0.200
     1.093    19.900     0.200
     1.350    24.211     0.200
     2.265    36.130     0.200
     2.567    39.706     0.200
     2.615    42.243     0.200
     2.643    42.213     0.200
     3.132    45.406     0.200
     4.510    67.228     0.200
     0.337    15.758     0.200
     0.376    15.707     0.200
     0.458    17.451     0.200
     0.765    18.165     0.200
     0.848    19.400     0.200
     0.881    19.913     0.200
     1.082    20.771     0.200
     1.211    23.063     0.200
     1.337    23.903     0.200
     1.525    27.291     0.200
     1.585    27.501     0.200
     1.823    30.223     0.200
     1.823    30.520     0.200
     2.132    33.414     0.200
     2.132    33.711     0.200
     2.185    34.803     0.200
     2.185    35.506     0.200
     2.207    34.537     0.200
     2.207    35.037     0.200
     2.658    38.277     0.200
     2.658    38.777     0.200
     4.071    58.786     0.200
     4.071    60.989     0.200
     0.198    16.100     0.200
     0.246    13.619     0.200
     0.213    13.906     0.200
     0.510    14.636     0.200
     0.765    18.065     0.200
     1.327    24.510     0.200
     2.417    38.788     0.200
     2.720    42.347     0.200
     2.769    44.376     0.200
     2.797    43.356     0.200
     3.275    46.871     0.200
     4.664    68.369     0.200
     4.779    70.124     0.200
     6.743    93.104     0.200
     0.234    13.699     0.200
     0.414    14.205     0.200
     0.656    16.778     0.200
     1.143    20.585     0.200
     1.828    28.368     0.200
     2.344    37.573     0.200
     2.644    41.174     0.200
     2.721    42.281     0.200
     3.220    46.458     0.200
     4.587    68.003     0.200
     0.134    12.269     0.200
     0.313    12.777     0.200
     0.436    12.845     0.200
     1.955    32.386     0.200
     2.312    35.050     0.200
     2.617    39.488     0.200
     2.617    39.888     0.200
     2.667    40.603     0.200
     2.667    40.004     0.200
     2.693    40.601     0.200
     4.560    65.816     0.200
     4.560    69.915     0.200
     0.146    13.965     0.200
     0.260    13.333     0.200
     0.318    15.598     0.200
     0.444    13.783     0.200
     0.376    15.581     0.200
     1.172    21.193     0.200
     1.235    24.555     0.200
     1.469    25.122     0.200
     1.841    28.579     0.200
     4.618    69.372     0.200
     4.663    68.451     0.200
     6.814    96.911     0.200
     6.814    97.151     0.200
     6.814    96.913     0.200
     9.988   135.511     0.200
    12.893   170.902     0.200
    15.037   198.283     0.200
     0.400    13.387     0.200
     2.252    33.182     0.200
     2.624    39.934     0.200
     2.672    42.373     0.200
     2.701    41.541     0.200
     2.701    40.942     0.200
     4.567    67.958     0.200
     4.567    65.158     0.200
     4.664    69.026     0.200
     6.852    96.994     0.200
     9.513   123.070     0.200
     9.514   120.726     0.200
    12.958   171.734     0.200
     0.192    13.510     0.200
     0.217    13.214     0.200
     0.441    13.801     0.200
     0.705    16.316     0.200
     0.887    19.599     0.200
     1.179    21.092     0.200
     1.880    32.033     0.200
     1.881    32.018     0.200
     2.288    33.451     0.200
     2.663    40.967     0.200
     2.663    40.067     0.200
     2.712    42.604     0.200
     2.712    41.504     0.200
     2.740    41.475     0.200
     2.740    41.175     0.200
     4.607    68.390     0.200
     4.607    65.390     0.200
     0.167    13.169     0.200
     0.239    13.418     0.200
     0.399    13.252     0.200
     0.470    15.420     0.200
     0.727    17.829     0.200
     0.841    18.997     0.200
     0.922    20.552     0.200
     1.141    20.298     0.200
     1.327    24.429     0.200
     1.396    24.719     0.200
     2.237    33.210     0.200
     2.615    39.889     0.200
     2.664    43.323     0.200
     2.692    41.299     0.200
     4.559    68.711     0.200
     0.100    11.645     0.200
     0.245    10.655     0.200
     1.039    18.888     0.200
     1.195    22.068     0.200
     1.121    20.531     0.200
     1.214    22.650     0.200
     1.805    29.476     0.200
     1.806    29.468     0.200
     2.648    38.117     0.200
     2.678    41.361     0.200
     2.678    40.662     0.200
     2.968    44.777     0.200
     2.968    44.277     0.200
     3.045    46.278     0.200
     3.045    45.379     0.200
     4.902    73.307     0.200
     4.902    71.705     0.200
     6.622    89.545     0.200
     6.624    93.718     0.200
     8.134   109.917     0.200
     9.414   119.600     0.200
    12.181   168.187     0.200
     0.130    13.864     0.200
     0.328    13.452     0.200
     0.377    14.586     0.200
     0.555    14.500     0.200
     1.004    20.565     0.200
     1.286    22.468     0.200
     1.393    24.426     0.200
     1.408    25.049     0.200
     1.936    33.515     0.200
     1.937    33.503     0.200
     2.406    35.699     0.200
     2.480    37.833     0.200
     2.858    42.725     0.200
     0.187    13.065     0.200
     0.219    13.196     0.200
     0.408    13.382     0.200
     0.853    18.893     0.200
     1.148    20.552     0.200
     1.412    24.865     0.200
     2.253    33.452     0.200
     2.327    36.890     0.200
     2.629    39.768     0.200
     2.705    41.576     0.200
     3.195    45.060     0.200
     4.572    65.190     0.200
     0.353    10.459     0.200
     0.559    12.657     0.200
     0.597    13.214     0.200
     0.915    19.399     0.200
     1.141    20.064     0.200
     1.653    30.121     0.200
     1.652    30.103     0.200
     2.483    35.106     0.200
     2.501    38.992     0.200
     2.789    43.238     0.200
     2.866    44.241     0.200
     3.412    48.269     0.200
     4.720    71.198     0.200
     4.720    69.300     0.200
     0.131    13.520     0.200
     0.294    14.715     0.200
     0.295    14.096     0.200
     0.277    13.212     0.200
     0.352    13.233     0.200
     0.792    18.503     0.200
     1.095    19.865     0.200
     1.348    24.715     0.200
     1.847    33.693     0.200
     2.189    32.004     0.200
     2.189    32.902     0.200
     2.264    35.125     0.200
     2.264    35.625     0.200
     2.566    39.598     0.200
     2.566    40.200     0.200
     2.643    39.707     0.200
     2.643    40.605     0.200
     3.131    44.011     0.200
     3.131    44.910     0.200
     4.510    66.920     0.200
     4.652    68.262     0.200
     4.652    68.465     0.200
     6.901    96.711     0.200
     0.335    12.521     0.200
     0.447    12.813     0.200
     0.617    17.436     0.200
     0.847    18.150     0.200
     1.013    19.515     0.200
     0.990    19.681     0.200
     1.187    23.378     0.200
     1.277    21.929     0.200
     1.362    26.446     0.200
     1.511    26.331     0.200
     2.309    32.588     0.200
     2.315    35.517     0.200
     2.600    40.194     0.200
     2.677    40.598     0.200
     3.232    45.914     0.200
     4.529    64.187     0.200
     0.555    12.089     0.200
     0.668    13.582     0.200
     1.005    18.641     0.200
     1.037    21.065     0.200
     1.137    21.612     0.200
     1.377    24.431     0.200
     2.337    36.504     0.200
     2.337    37.106     0.200
     2.357    34.863     0.200
     2.357    33.957     0.200
     2.612    41.584     0.200
     2.689    43.393     0.200
     4.215    63.681     0.200
     4.215    59.580     0.200
     4.528    68.129     0.200
     4.528    69.832     0.200
     8.127   114.829     0.200
     0.216     8.893     0.200
     0.539    12.319     0.200
     0.661    13.295     0.200
     0.891    18.611     0.200
     0.983    18.337     0.200
     1.124    21.295     0.200
     2.315    36.102     0.200
     2.315    36.602     0.200
     2.336    33.852     0.200
     2.336    33.751     0.200
     2.590    39.885     0.200
     2.590    40.686     0.200
     2.667    40.991     0.200
     2.667    41.093     0.200
     4.506    65.531     0.200
     4.506    68.730     0.200
     0.227    17.003     0.200
     0.316    16.864     0.200
     0.436    18.566     0.200
     0.593    19.106     0.200
     0.681    18.506     0.200
     0.808    20.127     0.200
     0.935    20.743     0.200
     1.274    24.284     0.200
     1.353    24.766     0.200
     1.489    26.978     0.200
     1.523    27.280     0.200
     1.518    27.732     0.200
     1.784    31.015     0.200
     1.785    30.992     0.200
     1.862    31.218     0.200
     2.168    34.648     0.200
     2.244    36.063     0.200
     4.111    60.082     0.200
     4.501    64.131     0.200
     4.501    63.770     0.200
     6.673    90.383     0.200
     7.270   101.311     0.200
     1.735    33.095     0.200
     3.545    59.197     0.200
     4.446    68.686     0.200
     5.349    82.852     0.200
     6.484    95.509     0.200
     6.546   100.978     0.200
     7.044    99.622     0.200
     8.298   120.329     0.200
     8.806   124.499     0.200
     9.563   129.667     0.200
    12.378   172.020     0.200
    12.915   176.150     0.200
    13.245   184.896     0.200
    15.438   206.110     0.200
    15.534   207.788     0.200
    19.789   269.632     0.200
    20.745   274.580     0.200
     0.157    12.964     0.200
     0.256    13.601     0.200
     0.351    13.090     0.200
     0.796    18.597     0.200
     1.092    20.151     0.200
     1.360    24.219     0.200
     2.573    40.060     0.200
     2.573    39.560     0.200
     2.650    41.567     0.200
     4.516    66.183     0.200
     4.516    66.783     0.200
     0.541    14.478     0.200
     0.571    13.529     0.200
     0.713    15.475     0.200
     0.704    15.582     0.200
     0.871    17.831     0.200
     0.961    19.387     0.200
     1.032    18.755     0.200
     1.312    21.786     0.200
     1.335    24.424     0.200
     1.374    22.159     0.200
     1.381    21.881     0.200
     1.474    25.904     0.200
     1.489    24.519     0.200
     1.489    25.222     0.200
     1.800    28.792     0.200
     1.874    31.024     0.200
     3.735    55.605     0.200
     3.735    56.808     0.200
     4.418    62.837     0.200
     0.235     9.151     0.200
     0.674    13.825     0.200
     0.850    18.281     0.200
     1.328    25.064     0.200
     1.329    24.963     0.200
     1.603    26.881     0.200
     2.279    37.594     0.200
     2.285    41.135     0.200
     2.306    34.889     0.200
     2.630    43.299     0.200
     2.630    43.698     0.200
     4.165    61.384     0.200
     4.467    67.863     0.200
     4.467    69.761     0.200
     6.305    88.013     0.200
     9.657   134.999     0.200
     0.550    13.615     0.200
     1.179    20.880     0.200
     1.604    28.662     0.200
     2.430    34.672     0.200
     2.444    38.508     0.200
     2.486    42.718     0.200
     2.731    42.166     0.200
     2.808    44.169     0.200
     4.661    68.439     0.200
     9.642   124.734     0.200
     0.578    13.667     0.200
     1.150    21.190     0.200
     1.642    28.895     0.200
     1.873    31.708     0.200
     2.954    46.834     0.200
     3.299    51.915     0.200
     5.120    75.458     0.200
     5.120    78.958     0.200
     6.637    91.754     0.200
     0.440    11.476     0.200
     1.136    21.153     0.200
     6.654    98.358     0.200
     0.162    14.097     0.200
     0.235    13.848     0.200
     0.246    13.920     0.200
     0.328    15.529     0.200
     0.328    14.873     0.200
     0.421    14.078     0.200
     0.384    15.915     0.200
     0.646    16.858     0.200
     0.872    19.519     0.200
     1.149    20.892     0.200
     1.240    23.932     0.200
     1.240    23.596     0.200
     1.448    24.902     0.200
     1.552    26.180     0.200
     2.289    33.979     0.200
     2.289    34.182     0.200
     2.353    37.031     0.200
     2.653    40.636     0.200
     2.653    40.238     0.200
     2.729    42.242     0.200
     2.729    41.344     0.200
     4.595    68.169     0.200
     4.595    65.568     0.200
     4.645    67.090     0.200
     4.645    66.988     0.200
     0.213    13.136     0.200
     0.193    13.476     0.200
     0.422    13.695     0.200
     0.869    19.077     0.200
     1.158    20.302     0.200
     1.282    24.256     0.200
     1.434    25.088     0.200
     1.860    31.695     0.200
     2.275    33.475     0.200
     2.346    36.844     0.200
     2.647    40.927     0.200
     2.724    41.535     0.200
     4.590    66.154     0.200
     0.149    14.178     0.200
     0.454    13.908     0.200
     0.637    15.374     0.200
     0.965    19.756     0.200
     1.146    20.546     0.200
     1.239    22.351     0.200
     1.764    28.977     0.200
     1.798    28.732     0.200
     2.530    36.685     0.200
     2.530    37.490     0.200
     2.564    40.699     0.200
     2.622    44.310     0.200
     2.855    44.298     0.200
     2.932    45.400     0.200
     4.603    67.795     0.200
     4.791    70.502     0.200
     6.714    93.462     0.200
     6.737    94.798     0.200
     9.707   132.629     0.200
    11.208   152.318     0.200
    12.300   169.189     0.200
    12.490   163.757     0.200
    15.166   194.927     0.200
     0.244    13.702     0.200
     0.299    14.958     0.200
     0.370    12.925     0.200
     0.815    17.937     0.200
     1.111    20.087     0.200
     1.316    24.225     0.200
     1.377    24.081     0.200
     2.218    32.565     0.200
     2.290    36.824     0.200
     2.395    39.402     0.200
     2.592    39.905     0.200
     2.668    40.913     0.200
     4.535    67.028     0.200
     4.535    65.728     0.200
     4.651    68.277     0.200
     6.512    89.156     0.200
     6.807    97.507     0.200
     6.807    95.507     0.200
     6.882    96.938     0.200
     7.693   100.470     0.200
     7.999   105.704     0.200
     8.100   103.226     0.200
    10.075   136.372     0.200
    11.249   151.770     0.200
    13.099   168.580     0.200
     0.270    13.857     0.200
     0.219    13.354     0.200
     0.478    15.738     0.200
     0.639    15.852     0.200
     0.844    17.464     0.200
     0.950    18.121     0.200
     0.980    19.568     0.200
     1.319    23.423     0.200
     1.398    23.692     0.200
     1.820    27.475     0.200
     1.908    31.736     0.200
     1.908    31.439     0.200
     2.043    34.475     0.200
     2.214    34.869     0.200
     2.290    35.585     0.200
     2.290    35.984     0.200
     4.157    64.999     0.200
     4.527    65.977     0.200
     0.366    13.752     0.200
     0.496    13.835     0.200
     0.651    15.729     0.200
     0.754    16.025     0.200
     0.978    19.313     0.200
     1.136    20.370     0.200
     1.406    25.014     0.200
     1.481    23.438     0.200
     1.481    23.633     0.200
     1.488    23.459     0.200
     1.521    25.778     0.200
     1.585    27.227     0.200
     1.623    27.580     0.200
     1.775    30.712     0.200
     1.867    29.949     0.200
     1.869    30.835     0.200
     1.910    30.541     0.200
     1.910    29.838     0.200
     1.922    30.592     0.200
     1.984    31.468     0.200
     1.984    32.069     0.200
     2.844    41.404     0.200
     3.845    57.648     0.200
     3.845    56.953     0.200
     4.480    62.949     0.200
     6.655    93.462     0.200
     0.132    13.198     0.200
     0.275    13.327     0.200
     0.359    12.943     0.200
     1.102    20.070     0.200
     1.353    24.345     0.200
     1.456    24.740     0.200
     2.194    32.936     0.200
     2.379    39.171     0.200
     3.136    44.641     0.200
     4.515    66.841     0.200
     4.515    63.341     0.200
     0.175    13.298     0.200
     0.256    14.351     0.200
     0.233    13.226     0.200
     0.415    13.302     0.200
     0.856    19.057     0.200
     1.156    20.450     0.200
     1.326    24.569     0.200
     1.326    24.428     0.200
     1.409    23.897     0.200
     1.512    24.398     0.200
     2.250    33.387     0.200
     2.327    36.083     0.200
     2.436    39.513     0.200
     2.706    41.162     0.200
     3.192    45.390     0.200
     3.192    45.796     0.200
     4.573    67.977     0.200
     4.573    64.875     0.200
     4.696    68.040     0.200
     0.257    13.012     0.200
     0.305    13.161     0.200
     0.452    13.836     0.200
     1.182    20.722     0.200
     1.578    26.305     0.200
     1.855    31.566     0.200
     2.315    33.902     0.200
     2.382    38.317     0.200
     2.479    42.583     0.200
     2.759    42.123     0.200
     3.256    47.022     0.200
     4.625    68.043     0.200
     4.625    66.242     0.200
     4.677    66.537     0.200
     8.590   119.975     0.200
     0.143    14.002     0.200
     0.264    13.395     0.200
     0.298    13.993     0.200
     0.464    14.058     0.200
     0.914    19.809     0.200
     1.194    21.038     0.200
     1.244    23.754     0.200
     1.588    26.946     0.200
     1.865    31.356     0.200
     2.325    34.440     0.200
     2.491    41.700     0.200
     2.770    41.847     0.200
     2.770    41.648     0.200
     3.266    46.859     0.200
     3.266    46.757     0.200
     4.636    65.465     0.200
     4.687    66.472     0.200
     0.126    13.691     0.200
     0.261    13.282     0.200
     0.341    14.087     0.200
     1.004    19.223     0.200
     1.267    23.074     0.200
     1.361    25.340     0.200
     1.372    24.074     0.200
     1.780    29.305     0.200
     1.781    29.318     0.200
     2.109    31.673     0.200
     2.282    39.051     0.200
     2.555    41.365     0.200
     2.555    40.365     0.200
     4.422    67.381     0.200
     4.576    67.276     0.200
     4.576    65.877     0.200
     0.154    14.287     0.200
     0.251    13.796     0.200
     0.316    15.132     0.200
     0.315    15.230     0.200
     0.383    15.162     0.200
     0.436    14.239     0.200
     0.654    15.961     0.200
     0.836    19.666     0.200
     1.165    20.396     0.200
     1.241    23.134     0.200
     1.241    23.794     0.200
     1.460    24.349     0.200
     2.071    33.609     0.200
     2.302    33.688     0.200
     2.302    34.387     0.200
     2.463    40.304     0.200
     2.744    42.729     0.200
     2.744    42.331     0.200
     3.243    47.209     0.200
     3.243    47.510     0.200
     4.610    68.452     0.200
     4.610    66.053     0.200
     4.726    63.103     0.200
     4.661    70.065     0.200
     6.427    83.633     0.200
     6.821    96.173     0.200
     0.218    12.942     0.200
     0.260    14.353     0.200
     0.447    13.537     0.200
     0.432    15.206     0.200
     0.710    17.678     0.200
     0.892    18.380     0.200
     1.185    20.960     0.200
     1.451    24.291     0.200
     1.554    25.874     0.200
     2.291    34.269     0.200
     2.744    42.480     0.200
     2.744    41.878     0.200
     3.233    45.673     0.200
     4.611    70.194     0.200
     4.705    68.303     0.200
     0.185    13.196     0.200
     0.225    13.207     0.200
     0.422    13.302     0.200
     0.461    15.671     0.200
     0.864    19.001     0.200
     1.320    25.503     0.200
     1.522    25.562     0.200
     2.259    33.557     0.200
     2.445    41.690     0.200
     2.715    42.536     0.200
     2.715    41.636     0.200
     4.718    64.371     0.200
     0.193    13.082     0.200
     0.286    12.751     0.200
     0.405    13.400     0.200
     0.851    18.812     0.200
     1.143    20.363     0.200
     1.297    23.949     0.200
     1.517    25.075     0.200
     2.106    33.974     0.200
     2.255    32.573     0.200
     2.255    33.073     0.200
     2.430    40.522     0.200
     2.704    41.220     0.200
     4.571    65.538     0.200
     4.670    68.188     0.200
     6.825    95.538     0.200
     8.582   118.431     0.200
    10.053   140.169     0.200
    12.960   172.245     0.200
    16.603   218.125     0.200
    21.320   277.177     0.200
     0.277    13.497     0.200
     0.347    12.922     0.200
     1.090    19.763     0.200
     1.345    24.084     0.200
     1.449    25.105     0.200
     2.186    31.501     0.200
     2.186    31.602     0.200
     2.368    38.175     0.200
     2.639    40.118     0.200
     4.506    65.930     0.200
     4.506    63.832     0.200
     4.646    67.498     0.200
     4.646    66.998     0.200
     6.906    97.069     0.200
     8.557   121.956     0.200
     0.224    13.591     0.200
     0.182    13.794     0.200
     0.289    14.947     0.200
     0.290    14.923     0.200
     0.430    13.802     0.200
     0.415    15.108     0.200
     0.684    17.406     0.200
     0.878    19.473     0.200
     1.165    20.899     0.200
     1.273    24.561     0.200
     1.444    25.393     0.200
     1.548    25.992     0.200
     1.859    30.176     0.200
     2.285    33.982     0.200
     2.285    34.083     0.200
     2.456    39.388     0.200
     2.733    41.256     0.200
     2.733    41.858     0.200
     4.599    69.177     0.200
     4.599    65.677     0.200
     4.677    67.473     0.200
     0.205    13.882     0.200
     0.402    13.376     0.200
     0.431    15.744     0.200
     0.687    17.452     0.200
     0.850    18.744     0.200
     1.139    20.033     0.200
     2.257    32.815     0.200
     2.257    33.116     0.200
     2.428    40.512     0.200
     2.704    42.191     0.200
     4.571    67.111     0.200
     4.571    66.908     0.200
     4.660    68.066     0.200
     6.815    95.518     0.200
     6.851    95.541     0.200
     8.573   117.507     0.200
    11.261   151.542     0.200
    12.950   171.527     0.200
     0.133    14.368     0.200
     0.277    13.878     0.200
     0.345    15.131     0.200
     0.354    15.160     0.200
     0.440    14.322     0.200
     0.622    16.155     0.200
     1.161    20.888     0.200
     1.210    23.383     0.200
     1.578    26.405     0.200
     1.817    30.816     0.200
     2.314    34.207     0.200
     2.750    40.022     0.200
     4.640    66.670     0.200
     9.511   120.427     0.200
     0.167    13.288     0.200
     0.239    13.270     0.200
     0.277    14.619     0.200
     0.392    13.464     0.200
     0.467    15.147     0.200
     0.720    17.685     0.200
     0.835    19.007     0.200
     1.133    20.377     0.200
     1.322    24.250     0.200
     1.392    24.483     0.200
     2.233    33.070     0.200
     2.415    41.247     0.200
     2.686    41.080     0.200
     2.686    40.478     0.200
     3.175    45.979     0.200
     4.553    67.692     0.200
     4.673    67.588     0.200
     6.830    97.921     0.200
     6.830    95.324     0.200
     6.861    96.036     0.200
     8.317   114.396     0.200
     8.585   117.237     0.200
    12.986   172.881     0.200
    13.430   177.201     0.200
    14.984   192.965     0.200
    20.743   270.353     0.200
    22.269   288.043     0.200
     1.094    20.696     0.200
     2.791    46.769     0.200
     3.166    49.894     0.200
     3.779    55.436     0.200
     3.779    54.338     0.200
     4.210    61.609     0.200
     4.210    60.109     0.200
     4.969    72.650     0.200
     6.290    87.639     0.200
     8.093   111.493     0.200
     8.093   116.193     0.200
     9.077   127.814     0.200
    12.427   170.017     0.200
    14.619   191.141     0.200
     0.606    14.583     0.200
     0.673    15.307     0.200
     2.221    33.583     0.200
     2.909    42.948     0.200
     3.184    47.740     0.200
     3.799    55.365     0.200
     4.208    63.496     0.200
     4.985    71.819     0.200
     0.181    13.948     0.200
     0.225    13.764     0.200
     0.295    15.326     0.200
     0.426    14.052     0.200
     0.679    17.380     0.200
     1.160    20.606     0.200
     1.270    23.886     0.200
     1.442    24.849     0.200
     1.546    25.663     0.200
     1.854    31.275     0.200
     2.283    33.761     0.200
     2.453    41.480     0.200
     2.730    41.949     0.200
     2.730    41.748     0.200
     3.225    45.475     0.200
     3.225    46.276     0.200
     4.596    69.767     0.200
     4.596    65.667     0.200
     0.325    15.039     0.200
     0.304    14.158     0.200
     0.454    14.766     0.200
     0.715    17.288     0.200
     0.900    18.439     0.200
     0.812    17.379     0.200
     1.138    21.094     0.200
     1.220    21.516     0.200
     1.393    25.465     0.200
     1.457    25.906     0.200
     1.638    25.634     0.200
     1.638    25.234     0.200
     1.865    31.884     0.200
     1.758    29.432     0.200
     2.107    33.662     0.200
     2.580    37.739     0.200
     2.580    36.940     0.200
     3.973    57.383     0.200
     3.973    58.484     0.200
     4.432    62.725     0.200
     6.606    90.853     0.200
     7.404   104.342     0.200
     8.733   117.761     0.200
     9.618   136.611     0.200
    10.486   145.070     0.200
    13.211   181.825     0.200
     0.134    12.836     0.200
     0.274    13.185     0.200
     0.295    14.073     0.200
     0.353    12.838     0.200
     0.794    18.365     0.200
     1.096    19.966     0.200
     1.343    25.575     0.200
     2.191    33.519     0.200
     2.191    32.720     0.200
     2.374    40.583     0.200
     2.644    42.128     0.200
     3.133    46.128     0.200
     4.511    66.242     0.200
     0.236    11.474     0.200
     0.343    11.668     0.200
     0.613    14.274     0.200
     0.899    18.674     0.200
     1.066    22.359     0.200
     1.124    19.712     0.200
     1.165    22.381     0.200
     1.217    21.466     0.200
     1.650    27.906     0.200
     1.771    27.821     0.200
     2.497    35.739     0.200
     2.878    42.799     0.200
     3.426    48.507     0.200
     4.732    67.966     0.200
     0.242    12.984     0.200
     0.266    13.452     0.200
     0.493    15.519     0.200
     0.644    15.484     0.200
     0.983    19.474     0.200
     1.084    19.666     0.200
     1.319    23.281     0.200
     1.409    23.669     0.200
     1.544    26.841     0.200
     1.572    26.814     0.200
     1.821    27.567     0.200
     1.824    30.308     0.200
     2.053    35.060     0.200
     2.297    35.613     0.200
     2.297    35.317     0.200
     2.764    40.161     0.200
     4.163    62.039     0.200
     4.163    60.039     0.200
     4.550    66.125     0.200
     4.550    65.226     0.200
     0.201    13.742     0.200
     0.276    14.764     0.200
     0.276    14.826     0.200
     0.424    14.245     0.200
     0.434    15.263     0.200
     0.702    17.141     0.200
     0.870    18.783     0.200
     1.162    21.923     0.200
     1.293    24.511     0.200
     1.869    31.447     0.200
     2.723    42.253     0.200
     2.723    42.753     0.200
     3.214    47.626     0.200
     3.214    46.326     0.200
     4.590    66.569     0.200
     4.590    68.968     0.200
     6.839    94.623     0.200
    12.322   160.331     0.200
    13.410   180.640     0.200
     1.506    26.373     0.200
     3.156    47.337     0.200
     3.756    55.035     0.200
     4.306    64.921     0.200
     4.306    65.519     0.200
     4.973    73.329     0.200
     6.393    90.956     0.200
     7.477   106.413     0.200
     8.194   113.542     0.200
     9.164   130.418     0.200
     9.703   130.189     0.200
     9.651   133.413     0.200
    10.877   153.433     0.200
    10.891   146.870     0.200
    12.089   166.895     0.200
    12.933   176.516     0.200
    14.739   193.962     0.200
    14.808   198.084     0.200
    15.215   194.608     0.200
    15.556   194.502     0.200
    15.840   214.510     0.200
    18.850   246.690     0.200
    19.358   254.284     0.200
    20.704   268.455     0.200
    21.264   283.321     0.200
    22.682   288.375     0.200
     0.677    14.799     0.200
     3.194    49.522     0.200
     3.789    53.784     0.200
     3.789    54.081     0.200
     5.016    76.265     0.200
     0.461    12.508     0.200
     0.428    12.933     0.200
     0.705    15.743     0.200
     0.620    15.030     0.200
     1.104    20.146     0.200
     3.272    49.774     0.200
     3.860    55.017     0.200
     4.454    64.090     0.200
     5.099    74.558     0.200
     5.099    76.957     0.200
     9.553   125.230     0.200
    12.719   166.934     0.200
     1.143    21.240     0.200
     1.388    23.940     0.200
     0.087     9.970     0.200
     0.309     9.413     0.200
     0.396    12.616     0.200
     0.480    13.275     0.200
     0.693    16.737     0.200
     0.718    15.322     0.200
     0.822    19.336     0.200
     1.042    19.170     0.200
     1.066    19.922     0.200
     1.486    27.093     0.200
     1.091    20.483     0.200
     3.121    46.556     0.200
     3.724    52.423     0.200
     4.265    62.912     0.200
     4.936    69.684     0.200
     0.370    11.833     0.200
     0.501    12.841     0.200
     1.045    20.068     0.200
     1.071    19.409     0.200
     1.499    26.642     0.200
     0.400    11.840     0.200
     1.046    20.045     0.200
     1.045    19.316     0.200
     3.156    48.922     0.200
     3.756    54.323     0.200
     4.309    63.579     0.200
     4.974    74.508     0.200
     4.974    76.109     0.200
     8.197   118.495     0.200
     9.700   126.749     0.200
    11.976   166.237     0.200
     0.029    10.583     0.200
     0.336     9.926     0.200
     0.413    12.615     0.200
     0.701    15.042     0.200
     0.738    17.189     0.200
     0.882    20.111     0.200
     1.047    18.686     0.200
     1.016    19.387     0.200
     1.280    24.785     0.200
     1.545    27.360     0.200
     0.018    10.448     0.200
     0.364    10.514     0.200
     0.423    12.239     0.200
     0.672    14.791     0.200
     0.767    17.587     0.200
     0.924    20.195     0.200
     0.979    19.416     0.200
     1.059    19.325     0.200
     1.146    23.927     0.200
     1.254    24.342     0.200
     1.388    25.116     0.200
     1.435    25.478     0.200
     1.401    25.417     0.200
     1.587    29.545     0.200
     3.206    47.223     0.200
     3.798    53.117     0.200
     4.387    64.034     0.200
     0.402    11.593     0.200
     0.719    15.019     0.200
     1.058    20.076     0.200
     1.118    20.452     0.200
     1.118    20.504     0.200
     1.497    26.006     0.200
     1.497    26.433     0.200
     2.018    33.929     0.200
     3.147    47.404     0.200
     3.747    53.593     0.200
     4.298    62.968     0.200
     4.964    70.395     0.200
     4.964    75.895     0.200
     8.187   113.083     0.200
     0.456    12.183     0.200
     0.411    12.340     0.200
     1.041    19.204     0.200
     1.528    27.613     0.200
     0.070     9.463     0.200
     0.302    10.041     0.200
     0.419    12.476     0.200
     0.723    17.107     0.200
     0.724    15.506     0.200
     1.025    18.426     0.200
     1.057    19.857     0.200
     1.078    22.329     0.200
     1.099    20.553     0.200
     1.099    19.308     0.200
     1.289    24.313     0.200
     1.316    25.187     0.200
     1.319    23.355     0.200
     1.387    24.522     0.200
     1.506    25.818     0.200
     1.506    26.521     0.200
     1.506    28.060     0.200
     1.506    26.495     0.200
     1.946    32.130     0.200
     2.010    32.476     0.200
     2.010    32.867     0.200
     2.026    31.387     0.200
     2.330    36.518     0.200
     2.375    35.942     0.200
     2.846    41.378     0.200
     3.141    48.238     0.200
     3.739    53.255     0.200
     4.248    61.349     0.200
     4.310    64.598     0.200
     4.310    65.598     0.200
     4.424    66.231     0.200
     4.960    72.112     0.200
     4.960    75.808     0.200
     9.186   126.192     0.200
    10.898   147.809     0.200
    12.562   169.294     0.200
    13.659   181.699     0.200
    13.659   182.894     0.200
    14.757   193.978     0.200
    22.703   293.748     0.200
     1.062    19.243     0.200
     1.144    21.191     0.200
     3.100    44.476     0.200
     3.713    52.736     0.200
     0.695    14.319     0.200
     1.389    25.102     0.200
     1.430    24.490     0.200
     1.575    27.506     0.200
     0.033    11.042     0.200
     0.333     9.721     0.200
     0.453    13.344     0.200
     0.412    12.875     0.200
     0.702    14.990     0.200
     0.695    15.194     0.200
     0.736    17.427     0.200
     0.878    19.668     0.200
     1.020    19.910     0.200
     1.045    18.839     0.200
     1.099    19.985     0.200
     1.105    23.148     0.200
     1.541    26.479     0.200
     1.541    25.312     0.200
     0.046    10.669     0.200
     0.341     9.991     0.200
     0.390    12.599     0.200
     0.477    13.040     0.200
     0.725    14.890     0.200
     0.685    15.142     0.200
     0.712    17.177     0.200
     1.062    18.755     0.200
     1.023    19.690     0.200
     1.123    21.123     0.200
     1.277    24.608     0.200
     1.346    23.811     0.200
     1.528    27.268     0.200
     0.367    11.693     0.200
     1.061    19.272     0.200
     1.144    21.274     0.200
     3.103    47.604     0.200
     3.716    53.257     0.200
     4.183    62.601     0.200
     4.908    74.347     0.200
     4.908    75.347     0.200
     0.013    10.279     0.200
     0.367    10.243     0.200
     0.451    12.719     0.200
     0.416    12.461     0.200
     0.698    15.200     0.200
     0.667    14.667     0.200
     0.761    17.331     0.200
     0.921    20.498     0.200
     0.978    19.123     0.200
     1.064    19.401     0.200
     1.142    23.708     0.200
     1.250    24.542     0.200
     1.585    26.550     0.200
     1.057    19.179     0.200
     1.050    19.930     0.200
     1.498    26.104     0.200
     1.043    19.784     0.200
     1.075    19.220     0.200
     1.152    20.833     0.200
     0.451    11.596     0.200
     0.699    14.583     0.200
     1.067    19.860     0.200
     0.449    12.341     0.200
     0.421    12.193     0.200
     1.069    19.615     0.200
     3.220    49.196     0.200
     3.812    52.896     0.200
     3.812    55.495     0.200
     4.400    67.534     0.200
     5.044    71.709     0.200
    12.082   165.984     0.200
     1.063    19.164     0.200
     1.127    20.548     0.200
     0.487    13.523     0.200
     0.384    11.950     0.200
     1.057    19.218     0.200
     1.049    19.945     0.200
     1.500    27.043     0.200
     1.500    27.050     0.200
     2.015    31.911     0.200
     3.161    46.854     0.200
     3.763    53.534     0.200
     3.763    53.235     0.200
     4.297    64.595     0.200
     4.297    64.095     0.200
     4.977    72.363     0.200
     4.977    75.263     0.200
     9.710   125.826     0.200
     0.180    10.172     0.200
     0.196    11.002     0.200
     0.767    17.773     0.200
     1.166    20.925     0.200
     1.420    26.811     0.200
     0.455    12.598     0.200
     0.412    12.408     0.200
     1.066    20.096     0.200
     3.208    50.390     0.200
     3.802    54.167     0.200
     4.379    67.431     0.200
     5.031    74.723     0.200
     0.372    11.820     0.200
     1.075    20.220     0.200
     1.061    19.430     0.200
     3.147    46.919     0.200
     3.752    52.654     0.200
     4.263    64.689     0.200
     4.959    71.464     0.200
     0.364     9.929     0.200
     1.060    19.476     0.200
     1.583    28.193     0.200
     3.205    48.325     0.200
     3.798    53.308     0.200
     4.384    66.968     0.200
     4.384    66.671     0.200
     5.028    72.547     0.200
     5.028    76.945     0.200
     0.379    10.137     0.200
     0.447    12.764     0.200
     0.423    12.430     0.200
     0.660    14.589     0.200
     0.774    17.359     0.200
     0.938    20.298     0.200
     0.963    19.091     0.200
     1.068    19.183     0.200
     1.241    24.389     0.200
     1.416    25.158     0.200
     1.602    28.612     0.200
     3.811    52.135     0.200
     0.380    11.960     0.200
     0.499    13.193     0.200
     0.714    14.835     0.200
     1.074    20.036     0.200
     1.472    26.628     0.200
     3.144    47.519     0.200
     3.748    54.069     0.200
     4.269    64.586     0.200
     4.269    64.386     0.200
     4.957    71.657     0.200
     8.157   114.814     0.200
     9.149   126.734     0.200
    12.077   165.070     0.200
     0.744    15.088     0.200
     1.105    20.712     0.200
     1.443    25.192     0.200
     3.114    48.109     0.200
     3.720    53.643     0.200
     4.243    64.238     0.200
     4.243    61.340     0.200
     4.503    64.501     0.200
     4.927    71.761     0.200
     8.132   114.150     0.200
    12.093   166.523     0.200
     0.394    12.504     0.200
     0.474    12.945     0.200
     1.053    19.161     0.200
     1.038    19.766     0.200
     1.515    25.082     0.200
     3.166    46.871     0.200
     3.765    53.176     0.200
     4.314    64.169     0.200
     4.983    69.757     0.200
     0.499    13.548     0.200
     1.053    19.873     0.200
     1.065    19.327     0.200
     3.162    45.534     0.200
     3.765    52.400     0.200
     3.765    53.600     0.200
     4.977    75.462     0.200
     9.720   124.435     0.200
     0.388    12.062     0.200
     0.759    15.515     0.200
     1.039    19.149     0.200
     1.137    20.869     0.200
     3.096    46.478     0.200
     3.706    53.462     0.200
     4.905    70.273     0.200
     0.399    12.254     0.200
     0.484    13.976     0.200
     1.034    18.397     0.200
     1.086    20.671     0.200
     3.126    47.639     0.200
     3.730    53.998     0.200
     4.267    60.932     0.200
     4.941    71.261     0.200
     0.399    12.117     0.200
     1.033    19.740     0.200
     1.050    19.068     0.200
     4.207    64.376     0.200
     4.207    63.075     0.200
     4.821    74.220     0.200
    12.198   166.525     0.200
    12.429   167.236     0.200
    14.748   194.672     0.200
    15.067   198.441     0.200
     0.393    12.024     0.200
     0.476    13.137     0.200
     1.052    19.384     0.200
     1.042    19.818     0.200
     3.163    44.845     0.200
     3.763    52.742     0.200
     4.980    71.936     0.200
     0.423    12.384     0.200
     0.396    12.163     0.200
     0.480    13.443     0.200
     1.042    19.461     0.200
     1.485    25.488     0.200
     3.142    48.374     0.200
     3.142    50.070     0.200
     3.744    53.351     0.200
     4.285    63.732     0.200
     4.285    63.435     0.200
     4.957    72.186     0.200
     9.724   127.837     0.200
    11.989   165.375     0.200
     3.176    48.519     0.200
     3.783    56.036     0.200
     4.265    62.517     0.200
     4.986    72.494     0.200
     0.553    14.235     0.200
     1.054    19.114     0.200
     1.155    21.144     0.200
     1.379    24.761     0.200
     3.092    45.897     0.200
     3.705    53.041     0.200
     3.705    53.440     0.200
     4.175    61.960     0.200
     4.175    61.760     0.200
     0.398    12.258     0.200
     0.470    12.955     0.200
     1.049    19.454     0.200
     3.163    48.200     0.200
     3.762    53.906     0.200
     4.981    76.485     0.200
    20.711   269.014     0.200
     0.415    12.406     0.200
     1.064    19.763     0.200
     1.581    27.645     0.200
     3.207    46.623     0.200
     3.800    53.603     0.200
     4.380    64.528     0.200
     5.029    76.851     0.200
     0.402    12.343     0.200
     0.727    15.144     0.200
     1.032    19.676     0.200
     1.085    20.662     0.200
     1.127    20.682     0.200
     3.126    47.308     0.200
     3.729    52.172     0.200
     0.384    12.143     0.200
     0.488    13.346     0.200
     1.053    19.970     0.200
     1.495    27.011     0.200
     7.393   101.205     0.200
     0.476    13.529     0.200
     0.711    17.079     0.200
     1.060    20.316     0.200
     3.176    49.728     0.200
     3.775    55.441     0.200
     4.323    64.745     0.200
     4.994    73.716     0.200
     8.211   114.979     0.200
    11.957   165.699     0.200
    12.600   167.855     0.200
     1.064    19.761     0.200
     1.134    20.787     0.200
     1.399    24.548     0.200
     3.111    48.742     0.200
     3.724    52.899     0.200
     4.193    61.121     0.200
     4.193    62.221     0.200
     4.917    71.473     0.200
     0.017    10.966     0.200
     0.356    10.522     0.200
     0.426    13.024     0.200
     0.679    14.877     0.200
     0.766    17.697     0.200
     0.987    19.288     0.200
     1.052    19.378     0.200
     1.262    24.687     0.200
     1.580    29.337     0.200
     3.198    49.482     0.200
     3.198    50.681     0.200
     3.790    53.569     0.200
     4.381    63.370     0.200
     4.381    66.071     0.200
     5.021    73.101     0.200
     5.021    76.101     0.200
     0.519    14.090     0.200
     0.655    15.884     0.200
     1.068    20.118     0.200
     3.763    56.698     0.200
     4.969    76.427     0.200
     8.151   115.898     0.200
    12.057   165.916     0.200
    14.689   192.200     0.200
     0.701    14.776     0.200
     1.041    18.480     0.200
     1.028    19.255     0.200
     2.859    40.910     0.200
     3.166    46.721     0.200
     3.763    53.462     0.200
     3.763    53.657     0.200
     4.335    63.181     0.200
     0.218    13.823     0.200
     0.188    13.735     0.200
     0.281    15.405     0.200
     0.282    14.146     0.200
     0.431    13.968     0.200
     0.422    14.955     0.200
     0.693    17.308     0.200
     0.878    19.570     0.200
     1.866    31.138     0.200
     2.079    34.202     0.200
     4.718    63.672     0.200
     0.031    11.142     0.200
     0.331     9.798     0.200
     0.425    12.879     0.200
     0.700    14.910     0.200
     0.750    17.304     0.200
     0.887    20.063     0.200
     1.017    19.199     0.200
     1.549    27.849     0.200
     3.172    48.643     0.200
     3.172    49.842     0.200
     3.766    53.403     0.200
     3.766    52.704     0.200
     4.352    63.864     0.200
     4.352    64.763     0.200
     4.994    71.880     0.200
     9.657   124.661     0.200
    12.104   166.897     0.200
     0.375    11.443     0.200
     1.114    20.716     0.200
     3.118    47.002     0.200
     3.726    52.700     0.200
     4.222    65.314     0.200
     4.927    70.492     0.200
     0.500    13.140     0.200
     1.017    19.220     0.200
     3.149    50.656     0.200
     3.735    54.318     0.200
     4.400    67.255     0.200
     4.978    75.007     0.200
     8.293   118.518     0.200
     9.614   126.043     0.200
    10.990   153.648     0.200
    22.754   295.867     0.200
     3.046    47.923     0.200
     4.180    63.381     0.200
     4.855    71.911     0.200
     8.073   113.057     0.200
    12.131   165.996     0.200
    12.449   164.484     0.200
     0.798    17.723     0.200
     0.996    19.545     0.200
     3.178    50.449     0.200
     3.766    55.476     0.200
     4.395    66.341     0.200
     4.395    67.841     0.200
     5.004    74.131     0.200
     6.486    92.140     0.200
     9.214   130.805     0.200
     9.616   123.591     0.200
    21.483   280.720     0.200
     1.050    18.862     0.200
     1.123    20.651     0.200
     1.507    26.979     0.200
     1.507    26.516     0.200
     3.160    48.643     0.200
     3.160    50.542     0.200
     3.760    53.839     0.200
     4.306    62.863     0.200
     4.977    72.438     0.200
     8.194   117.387     0.200
     0.358    10.272     0.200
     1.044    18.993     0.200
     1.595    28.012     0.200
     3.199    49.343     0.200
     3.199    49.542     0.200
     5.024    74.738     0.200
     5.024    75.539     0.200
     0.414    12.447     0.200
     0.451    12.760     0.200
     3.193    48.815     0.200
     3.193    50.714     0.200
     3.787    54.880     0.200
     4.365    66.437     0.200
     5.015    73.752     0.200
     8.253   114.063     0.200
     0.411    12.209     0.200
     3.201    51.204     0.200
     3.795    54.170     0.200
     4.371    66.948     0.200
     4.371    64.948     0.200
     5.023    74.839     0.200
     5.023    77.038     0.200
     0.686    16.109     0.200
     1.084    20.779     0.200
     1.652    28.826     0.200
     1.652    28.754     0.200
     2.219    34.159     0.200
     2.930    42.956     0.200
     3.254    49.771     0.200
     3.841    54.923     0.200
     4.450    68.213     0.200
     5.082    74.642     0.200
     5.082    77.642     0.200
     6.535    95.886     0.200
     7.407   104.007     0.200
     8.337   119.154     0.200
    15.345   200.469     0.200
     0.589    15.273     0.200
     1.065    19.365     0.200
     3.094    47.540     0.200
     3.709    53.861     0.200
     4.161    59.989     0.200
     4.161    60.689     0.200
     4.896    71.007     0.200
     0.154     8.653     0.200
     0.390    11.881     0.200
     0.390    12.611     0.200
     0.408    10.956     0.200
     0.860    18.150     0.200
     1.119    19.275     0.200
     1.188    22.165     0.200
     1.766    28.729     0.200
     1.766    29.690     0.200
     1.767    29.056     0.200
     1.767    28.681     0.200
     2.104    32.881     0.200
     2.104    34.931     0.200
     2.719    41.365     0.200
     3.230    44.997     0.200
     3.230    44.598     0.200
     4.584    66.203     0.200
     4.584    68.203     0.200
     4.590    66.338     0.200
     4.782    67.231     0.200
     6.864    97.990     0.200
     6.740    93.739     0.200
     0.212    13.477     0.200
     0.196    13.624     0.200
     0.272    14.207     0.200
     0.273    14.901     0.200
     0.432    13.595     0.200
     0.431    14.209     0.200
     0.703    17.262     0.200
     0.878    19.421     0.200
     1.169    20.814     0.200
     1.291    24.176     0.200
     1.439    25.226     0.200
     1.874    31.608     0.200
     1.873    30.946     0.200
     2.080    34.825     0.200
     2.731    41.333     0.200
     2.731    42.232     0.200
     3.221    45.609     0.200
     4.598    65.150     0.200
     4.598    68.751     0.200
     0.483    13.358     0.200
     0.682    16.751     0.200
     1.028    19.628     0.200
     1.458    26.458     0.200
     2.125    34.539     0.200
     3.117    50.164     0.200
     3.721    55.620     0.200
     4.932    73.992     0.200
    12.102   167.117     0.200
    15.867   212.474     0.200
     0.482    13.467     0.200
     1.057    19.543     0.200
     0.152    12.825     0.200
     0.254    13.431     0.200
     0.284    14.800     0.200
     0.285    14.056     0.200
     0.374    13.092     0.200
     0.479    15.487     0.200
     0.724    18.194     0.200
     0.816    18.051     0.200
     1.116    20.495     0.200
     1.331    24.740     0.200
     2.214    33.553     0.200
     2.142    33.470     0.200
     2.667    40.363     0.200
     4.534    67.475     0.200
     4.663    67.674     0.200
     4.663    69.768     0.200
     6.821    93.795     0.200
     6.878    97.081     0.200
     8.328   113.805     0.200
     8.575   117.221     0.200
     8.575   120.119     0.200
    12.998   173.700     0.200
    13.434   180.617     0.200
    14.966   192.139     0.200
    19.764   258.039     0.200
     0.383    11.920     0.200
     1.045    19.637     0.200
     1.110    20.936     0.200
     1.433    24.884     0.200
     2.747    43.658     0.200
     2.828    41.306     0.200
     3.116    49.842     0.200
     3.116    47.444     0.200
     4.231    61.228     0.200
     4.927    75.113     0.200
     4.927    71.316     0.200
     6.319    89.962     0.200
     8.120   112.750     0.200
     9.777   125.721     0.200
    10.858   148.100     0.200
    12.083   165.103     0.200
    12.521   164.588     0.200
     0.632    15.800     0.200
     1.063    20.237     0.200
     1.429    23.516     0.200
     2.086    34.597     0.200
     2.842    41.287     0.200
     3.127    49.162     0.200
     4.223    61.966     0.200
     4.935    73.257     0.200
     4.977    72.146     0.200
     1.091    20.627     0.200
     1.445    25.796     0.200
     2.163    31.715     0.200
     2.856    40.719     0.200
     3.143    45.976     0.200
     3.751    52.678     0.200
     4.238    63.306     0.200
     0.513    14.509     0.200
     1.098    21.056     0.200
     2.839    41.421     0.200
     3.128    47.245     0.200
     3.735    54.465     0.200
     0.181    13.223     0.200
     0.257    14.652     0.200
     0.227    13.348     0.200
     0.419    13.502     0.200
     0.861    19.054     0.200
     1.160    20.722     0.200
     1.322    25.057     0.200
     1.518    25.733     0.200
     1.884    31.064     0.200
     1.885    31.053     0.200
     2.098    33.517     0.200
     2.255    33.327     0.200
     2.255    33.530     0.200
     2.441    40.461     0.200
     2.711    41.409     0.200
     3.198    46.831     0.200
     4.578    67.219     0.200
     4.578    66.622     0.200
     4.721    65.187     0.200
     4.697    68.734     0.200
     0.133    12.992     0.200
     0.291    13.961     0.200
     0.274    13.023     0.200
     0.357    12.679     0.200
     0.496    14.897     0.200
     0.732    16.714     0.200
     0.797    18.262     0.200
     1.100    20.135     0.200
     1.352    23.885     0.200
     1.345    25.476     0.200
     1.456    24.838     0.200
     2.193    32.831     0.200
     2.377    39.780     0.200
     2.647    41.432     0.200
     3.135    45.740     0.200
     4.514    66.645     0.200
     0.881    20.149     0.200
     0.914    20.970     0.200
     2.340    35.147     0.200
     2.340    36.147     0.200
     2.685    44.819     0.200
     2.685    43.319     0.200
     3.256    48.158     0.200
     4.265    62.787     0.200
     4.529    71.099     0.200
     1.140    20.947     0.200
     2.145    32.163     0.200
     2.736    45.064     0.200
     2.833    41.131     0.200
     3.111    47.895     0.200
     3.724    53.739     0.200
     4.184    64.770     0.200
     4.184    64.669     0.200
     4.915    72.039     0.200
     0.175    13.475     0.200
     0.232    13.588     0.200
     0.265    14.107     0.200
     0.265    14.686     0.200
     0.407    13.271     0.200
     0.465    15.343     0.200
     0.725    17.426     0.200
     0.850    18.858     0.200
     0.917    19.664     0.200
     1.149    20.230     0.200
     2.109    33.672     0.200
     2.246    33.397     0.200
     2.430    40.847     0.200
     2.701    41.388     0.200
     3.188    45.901     0.200
     3.188    47.302     0.200
     4.567    69.202     0.200
     4.687    70.506     0.200
     4.687    68.006     0.200
     0.179    13.106     0.200
     0.270    14.854     0.200
     0.269    14.484     0.200
     0.227    13.366     0.200
     0.407    13.270     0.200
     0.459    15.701     0.200
     0.719    17.296     0.200
     0.850    19.059     0.200
     1.148    20.419     0.200
     1.316    24.790     0.200
     2.108    35.020     0.200
     2.248    33.100     0.200
     2.430    40.569     0.200
     2.702    41.202     0.200
     2.702    41.303     0.200
     3.190    45.606     0.200
     3.190    46.204     0.200
     4.569    69.216     0.200
     4.569    65.216     0.200
     0.154    13.015     0.200
     0.257    13.568     0.200
     0.306    13.758     0.200
     0.307    13.937     0.200
     0.356    12.681     0.200
     1.096    19.475     0.200
     1.362    23.618     0.200
     2.158    34.051     0.200
     2.203    32.462     0.200
     2.203    32.862     0.200
     2.275    36.425     0.200
     2.275    36.025     0.200
     2.380    40.001     0.200
     2.653    40.914     0.200
     3.145    46.675     0.200
     4.520    65.829     0.200
     4.520    65.229     0.200
     4.641    68.312     0.200
     4.641    66.812     0.200
     4.785    65.175     0.200
    14.567   192.243     0.200
     0.422    12.830     0.200
     0.443    12.505     0.200
     2.161    33.351     0.200
     2.869    41.591     0.200
     3.777    54.994     0.200
     3.777    56.394     0.200
     5.011    74.292     0.200
     0.741    17.607     0.200
     1.429    24.381     0.200
     2.165    32.491     0.200
     2.165    32.791     0.200
     2.223    36.015     0.200
     2.599    41.533     0.200
     2.599    42.033     0.200
     3.104    47.934     0.200
     4.464    66.561     0.200
     4.464    66.061     0.200
     4.551    67.245     0.200
     6.967   102.263     0.200
     0.176    12.863     0.200
     0.262    14.681     0.200
     0.231    13.642     0.200
     0.410    13.260     0.200
     0.465    14.707     0.200
     0.726    17.509     0.200
     0.852    18.950     0.200
     1.151    20.399     0.200
     1.878    30.175     0.200
     2.247    33.364     0.200
     2.324    37.772     0.200
     2.324    37.570     0.200
     2.432    40.709     0.200
     2.703    41.052     0.200
     2.703    41.751     0.200
     4.570    68.765     0.200
     4.570    66.464     0.200
     4.690    70.064     0.200
     0.319    11.951     0.200
     0.357    12.018     0.200
     0.539    14.588     0.200
     0.720    15.464     0.200
     0.926    18.990     0.200
     0.926    18.471     0.200
     0.956    18.864     0.200
     1.078    18.570     0.200
     1.420    23.163     0.200
     1.785    28.013     0.200
     1.927    31.232     0.200
     1.902    30.448     0.200
     2.063    33.667     0.200
     2.286    34.860     0.200
     2.286    35.860     0.200
     4.149    63.123     0.200
     4.149    60.322     0.200
     4.633    64.870     0.200
     0.174    13.534     0.200
     0.231    13.230     0.200
     0.305    13.482     0.200
     0.424    13.836     0.200
     0.668    15.459     0.200
     1.156    20.721     0.200
     1.844    30.795     0.200
     2.285    33.274     0.200
     2.352    36.885     0.200
     2.451    41.041     0.200
     2.729    41.587     0.200
     2.729    41.689     0.200
     4.596    69.010     0.200
     4.596    66.010     0.200
     0.237    13.273     0.200
     0.317    14.554     0.200
     0.316    15.313     0.200
     0.658    15.582     0.200
     1.151    20.890     0.200
     1.251    23.430     0.200
     2.285    33.922     0.200
     2.448    39.926     0.200
     2.728    42.059     0.200
     2.728    42.359     0.200
     4.594    69.481     0.200
     4.594    65.881     0.200
     4.653    66.489     0.200
     0.169    13.631     0.200
     0.237    13.775     0.200
     0.287    14.390     0.200
     0.385    13.363     0.200
     0.711    17.471     0.200
     0.829    19.008     0.200
     1.125    20.301     0.200
     1.315    24.395     0.200
     1.389    24.396     0.200
     1.493    25.397     0.200
     2.230    33.293     0.200
     2.230    33.492     0.200
     2.303    36.636     0.200
     2.409    40.705     0.200
     2.681    40.621     0.200
     2.681    40.723     0.200
     4.548    66.937     0.200
     4.548    65.836     0.200
     4.663    67.690     0.200
     4.663    69.093     0.200
     0.612    15.373     0.200
     0.677    14.683     0.200
     1.068    20.420     0.200
     1.458    26.548     0.200
     2.843    45.527     0.200
     2.895    41.622     0.200
     3.179    50.709     0.200
     3.179    47.709     0.200
     4.242    64.301     0.200
     4.242    62.301     0.200
     4.985    72.023     0.200
    12.016   163.876     0.200
     0.079    10.620     0.200
     0.320     9.992     0.200
     0.389    11.743     0.200
     0.484    14.086     0.200
     0.707    15.011     0.200
     0.692    16.437     0.200
     0.829    19.148     0.200
     1.051    18.863     0.200
     1.056    19.702     0.200
     1.054    22.527     0.200
     1.311    23.675     0.200
     2.156    31.543     0.200
     2.813    43.372     0.200
     2.855    40.281     0.200
     3.153    50.199     0.200
     3.153    47.199     0.200
     4.292    61.708     0.200
     4.292    64.208     0.200
     0.121    13.377     0.200
     0.361    13.112     0.200
     0.278    14.681     0.200
     0.509    15.518     0.200
     0.798    18.654     0.200
     1.106    20.198     0.200
     1.349    24.322     0.200
     1.360    24.472     0.200
     1.452    24.290     0.200
     2.189    33.285     0.200
     2.646    38.146     0.200
     0.189    13.024     0.200
     0.182    12.413     0.200
     0.540    15.852     0.200
     0.885    18.055     0.200
     1.072    20.831     0.200
     1.176    21.715     0.200
     1.783    29.882     0.200
     1.784    29.918     0.200
     1.913    29.110     0.200
     2.117    36.335     0.200
     2.374    38.531     0.200
     2.374    36.230     0.200
     4.241    64.943     0.200
     4.344    63.239     0.200
     0.369    12.381     0.200
     0.377    12.235     0.200
     0.511    14.242     0.200
     0.902    17.352     0.200
     1.579    27.121     0.200
     1.734    26.826     0.200
     1.924    31.367     0.200
     1.926    32.240     0.200
     2.019    33.702     0.200
     2.239    34.743     0.200
     4.100    62.515     0.200
     4.100    59.109     0.200
     4.202    60.734     0.200
     4.617    64.984     0.200
     4.617    64.882     0.200
     0.161    14.008     0.200
     0.244    13.554     0.200
     0.438    14.109     0.200
     0.888    19.599     0.200
     1.849    29.449     0.200
     2.300    33.240     0.200
     2.300    34.639     0.200
     2.465    41.212     0.200
     2.744    42.057     0.200
     2.744    41.456     0.200
     4.610    67.176     0.200
     4.610    66.176     0.200
     0.132    14.145     0.200
     0.269    15.210     0.200
     0.378    14.540     0.200
     0.557    14.421     0.200
     0.703    17.018     0.200
     1.005    20.231     0.200
     1.242    23.730     0.200
     1.394    24.491     0.200
     1.670    26.464     0.200
     1.939    32.770     0.200
     1.952    31.237     0.200
     2.407    35.860     0.200
     2.584    41.601     0.200
     2.860    42.381     0.200
     4.726    70.397     0.200
     0.351    14.582     0.200
     0.472    15.228     0.200
     0.570    15.852     0.200
     0.630    15.799     0.200
     0.690    16.266     0.200
     0.803    17.565     0.200
     0.972    19.187     0.200
     1.030    19.102     0.200
     1.305    22.170     0.200
     1.302    24.596     0.200
     1.312    22.357     0.200
     1.416    25.863     0.200
     1.458    26.003     0.200
     1.606    27.561     0.200
     1.669    30.449     0.200
     1.807    29.716     0.200
     1.849    28.145     0.200
     1.851    29.228     0.200
     1.851    28.103     0.200
     3.022    45.232     0.200
     3.667    55.009     0.200
     4.390    61.965     0.200
     4.390    64.265     0.200
     6.565    91.791     0.200
     8.852   118.900     0.200
    10.770   147.917     0.200
    13.552   185.046     0.200
    17.500   231.177     0.200
    21.182   271.208     0.200
     0.104    11.354     0.200
     0.434    12.003     0.200
     0.597    14.535     0.200
     1.079    20.685     0.200
     1.215    20.967     0.200
     1.243    22.828     0.200
     1.810    29.025     0.200
     1.899    30.773     0.200
     1.898    30.771     0.200
     2.547    36.532     0.200
     2.682    44.054     0.200
     2.976    44.926     0.200
     2.976    44.527     0.200
     4.737    67.976     0.200
     4.840    71.973     0.200
     4.840    68.872     0.200
     8.649   123.223     0.200
    12.303   168.630     0.200
     0.143    13.872     0.200
     0.200    13.324     0.200
     0.637    16.362     0.200
     0.944    19.082     0.200
     1.308    23.178     0.200
     1.752    29.648     0.200
     2.045    31.181     0.200
     2.045    31.579     0.200
     2.217    38.470     0.200
     2.489    38.692     0.200
     2.489    38.392     0.200
     4.356    65.408     0.200
     4.356    62.608     0.200
     4.536    66.704     0.200
     4.536    65.804     0.200
     7.057   101.603     0.200
     8.445   120.190     0.200
    12.802   174.268     0.200
     0.608    15.435     0.200
     1.691    27.928     0.200
     1.690    27.129     0.200
     1.979    32.498     0.200
     2.517    37.659     0.200
     2.587    44.246     0.200
     2.905    46.240     0.200
     2.905    45.740     0.200
     4.531    65.266     0.200
     4.760    71.785     0.200
     4.760    70.386     0.200
     8.441   122.328     0.200
     9.544   123.880     0.200
     9.667   138.217     0.200
    11.388   156.039     0.200
    13.048   177.463     0.200
    16.256   215.732     0.200
     0.063    14.367     0.200
     0.338    14.901     0.200
     0.695    15.812     0.200
     0.733    17.516     0.200
     0.916    20.342     0.200
     1.070    20.077     0.200
     1.121    21.028     0.200
     1.124    24.057     0.200
     1.148    22.010     0.200
     1.374    25.559     0.200
     1.374    25.914     0.200
     2.491    35.454     0.200
     2.808    43.649     0.200
     4.213    61.155     0.200
     4.213    61.455     0.200
     4.639    70.880     0.200
     4.639    68.081     0.200
     0.161    12.997     0.200
     0.254    13.970     0.200
     0.349    13.154     0.200
     0.318    14.193     0.200
     0.319    15.042     0.200
     0.467    15.681     0.200
     0.795    18.568     0.200
     1.088    20.161     0.200
     1.464    24.836     0.200
     2.202    33.034     0.200
     2.374    40.220     0.200
     2.649    40.315     0.200
     2.649    40.514     0.200
     4.515    67.828     0.200
     4.515    64.531     0.200
     4.629    66.600     0.200
     4.629    67.600     0.200
     6.903    96.763     0.200
     8.541   120.752     0.200
    13.079   167.298     0.200
     0.186    13.258     0.200
     0.239    14.263     0.200
     2.266    33.427     0.200
     2.266    33.028     0.200
     2.456    39.906     0.200
     2.725    42.070     0.200
     2.725    40.375     0.200
     4.592    68.884     0.200
     0.135    12.076     0.200
     0.471    11.681     0.200
     0.515    13.137     0.200
     1.000    19.133     0.200
     1.761    27.759     0.200
     1.954    32.301     0.200
     2.494    36.501     0.200
     2.494    37.103     0.200
     2.594    44.041     0.200
     2.900    44.762     0.200
     2.900    45.164     0.200
     4.260    62.999     0.200
     4.603    68.092     0.200
     4.761    71.256     0.200
     4.761    69.256     0.200
     9.487   121.748     0.200
    11.470   155.154     0.200
    15.141   195.115     0.200
     0.154    14.223     0.200
     0.254    13.862     0.200
     0.329    15.004     0.200
     0.328    15.840     0.200
     0.428    13.996     0.200
     0.642    16.996     0.200
     0.879    19.544     0.200
     1.155    20.894     0.200
     1.233    24.129     0.200
     1.456    24.911     0.200
     1.560    25.188     0.200
     1.826    27.361     0.200
     2.297    34.385     0.200
     2.737    40.257     0.200
     4.647    67.466     0.200
     0.198    13.117     0.200
     0.209    13.871     0.200
     0.297    14.648     0.200
     0.400    13.650     0.200
     0.434    16.034     0.200
     0.689    17.752     0.200
     0.847    19.220     0.200
     1.136    20.942     0.200
     1.289    24.724     0.200
     1.412    24.856     0.200
     1.516    25.713     0.200
     2.110    34.045     0.200
     2.253    33.007     0.200
     2.253    32.304     0.200
     2.426    40.897     0.200
     2.701    40.985     0.200
     2.701    41.782     0.200
     4.568    69.100     0.200
     4.568    64.499     0.200
     4.660    68.720     0.200
     6.853    99.218     0.200
    13.130   167.576     0.200
    13.399   181.941     0.200
    14.994   194.329     0.200
    16.600   220.088     0.200
     0.667    14.732     0.200
     1.820    28.671     0.200
     2.543    37.229     0.200
     2.911    45.737     0.200
     2.911    44.436     0.200
     4.456    66.305     0.200
     4.456    67.402     0.200
     4.760    72.852     0.200
     0.216    13.168     0.200
     0.695    17.318     0.200
     0.878    19.077     0.200
     1.168    20.353     0.200
     1.869    29.583     0.200
     2.282    33.633     0.200
     2.282    33.432     0.200
     2.457    41.288     0.200
     2.732    42.481     0.200
     4.599    69.097     0.200
     4.599    67.197     0.200
     4.685    69.586     0.200
     0.156    14.182     0.200
     0.249    13.642     0.200
     0.306    14.286     0.200
     0.307    14.200     0.200
     0.442    13.808     0.200
     0.662    16.079     0.200
     0.841    18.463     0.200
     1.172    20.948     0.200
     1.247    23.486     0.200
     1.334    23.959     0.200
     1.567    26.382     0.200
     2.066    33.076     0.200
     2.304    34.680     0.200
     2.304    33.980     0.200
     2.469    41.564     0.200
     2.748    41.601     0.200
     2.748    42.101     0.200
     4.614    69.822     0.200
     4.670    67.578     0.200
     4.670    66.777     0.200
     6.814    95.690     0.200
    12.343   160.933     0.200
    21.305   277.443     0.200
     0.142    13.391     0.200
     0.347    13.243     0.200
     0.306    14.787     0.200
     0.487    15.674     0.200
     0.718    16.398     0.200
     0.790    18.705     0.200
     1.089    19.924     0.200
     1.351    24.791     0.200
     1.350    24.502     0.200
     1.454    25.170     0.200
     2.191    32.366     0.200
     2.191    33.366     0.200
     2.370    37.876     0.200
     2.642    41.104     0.200
     4.509    66.916     0.200
     4.509    65.818     0.200
     4.640    68.186     0.200
     0.228    13.710     0.200
     0.291    15.207     0.200
     0.433    14.124     0.200
     0.411    15.983     0.200
     0.681    17.483     0.200
     0.881    19.654     0.200
     1.270    24.535     0.200
     1.447    25.351     0.200
     1.551    26.238     0.200
     1.859    30.141     0.200
     1.858    30.151     0.200
     2.289    34.431     0.200
     2.736    41.614     0.200
     4.602    65.930     0.200
     4.677    66.562     0.200
     0.208    13.559     0.200
     0.284    13.069     0.200
     0.543    14.325     0.200
     0.758    17.697     0.200
     0.984    20.926     0.200
     1.078    20.007     0.200
     1.633    26.828     0.200
     1.972    34.391     0.200
     1.971    32.737     0.200
     1.976    32.543     0.200
     2.370    34.626     0.200
     2.370    34.329     0.200
     2.565    40.951     0.200
     2.565    39.053     0.200
     3.313    48.518     0.200
     4.700    69.138     0.200
     4.700    66.934     0.200
     4.794    69.638     0.200
     4.794    69.833     0.200
    11.768   157.552     0.200
    12.437   163.145     0.200
    12.511   171.052     0.200
     0.245    13.742     0.200
     0.319    15.476     0.200
     0.388    15.951     0.200
     0.427    14.209     0.200
     0.877    19.600     0.200
     0.937    18.662     0.200
     1.451    25.108     0.200
     1.555    26.344     0.200
     1.834    28.297     0.200
     2.292    33.446     0.200
     2.454    38.965     0.200
     2.734    40.691     0.200
     3.233    46.969     0.200
     4.600    68.515     0.200
     4.654    66.986     0.200
     0.216    13.877     0.200
     0.413    15.324     0.200
     0.322    15.463     0.200
     0.394    14.005     0.200
     0.663    16.566     0.200
     0.844    19.104     0.200
     1.126    20.339     0.200
     1.265    23.221     0.200
     1.416    25.255     0.200
     1.521    26.015     0.200
     1.823    28.768     0.200
     1.822    30.064     0.200
     1.822    30.521     0.200
     1.822    28.783     0.200
     2.113    33.624     0.200
     2.113    33.933     0.200
     2.421    40.010     0.200
     2.700    41.849     0.200
     2.700    41.349     0.200
     4.567    67.871     0.200
     4.639    66.030     0.200
     4.639    66.132     0.200
    10.950   149.474     0.200
    11.743   157.726     0.200
    12.594   169.672     0.200
     0.325    13.647     0.200
     0.376    14.569     0.200
     0.551    14.596     0.200
     0.699    16.940     0.200
     1.000    20.564     0.200
     1.051    19.688     0.200
     1.240    23.282     0.200
     1.394    24.177     0.200
     1.665    26.517     0.200
     1.934    31.361     0.200
     2.403    34.713     0.200
     2.578    41.666     0.200
     2.578    39.564     0.200
     2.854    43.140     0.200
     2.854    43.441     0.200
     4.721    71.458     0.200
     4.721    68.658     0.200
     4.761    67.589     0.200
     4.761    68.589     0.200
     0.288    14.850     0.200
     0.330    14.275     0.200
     0.378    16.885     0.200
     0.557    17.026     0.200
     0.779    18.794     0.200
     0.788    17.797     0.200
     1.028    20.550     0.200
     1.381    24.059     0.200
     1.488    24.831     0.200
     1.688    27.002     0.200
     1.687    27.022     0.200
     2.192    33.914     0.200
     2.343    39.760     0.200
     2.343    37.859     0.200
     2.637    40.918     0.200
     2.637    41.119     0.200
     4.505    65.519     0.200
     4.505    66.019     0.200
     4.501    68.173     0.200
     4.501    67.974     0.200
    10.351   143.001     0.200
    16.569   218.033     0.200
    21.151   274.870     0.200
     0.581    13.925     0.200
     0.632    14.411     0.200
     0.915    17.829     0.200
     1.793    29.081     0.200
     2.524    37.157     0.200
     2.524    37.856     0.200
     2.604    42.025     0.200
     2.604    40.322     0.200
     2.918    46.158     0.200
     2.918    44.658     0.200
     3.456    50.879     0.200
     4.563    67.355     0.200
     4.775    73.285     0.200
     4.775    69.187     0.200
    15.142   196.199     0.200
     0.163    13.184     0.200
     0.361    13.245     0.200
     0.309    14.207     0.200
     0.465    14.548     0.200
     0.702    17.832     0.200
     0.806    18.611     0.200
     1.100    20.003     0.200
     2.151    33.510     0.200
     2.211    33.121     0.200
     2.211    32.527     0.200
     2.385    38.288     0.200
     2.659    41.387     0.200
     2.659    39.293     0.200
     4.526    67.407     0.200
     4.526    64.204     0.200
     4.640    67.974     0.200
     4.640    67.076     0.200
     6.892    96.261     0.200
     6.892    96.988     0.200
     8.053   109.166     0.200
     8.313   111.844     0.200
     8.414   113.497     0.200
     8.552   121.426     0.200
    11.792   160.309     0.200
    13.412   178.505     0.200
    14.954   196.113     0.200
    16.638   218.562     0.200
    19.635   254.136     0.200
     0.084    10.109     0.200
     0.684    14.405     0.200
     0.752    16.894     0.200
     1.007    19.767     0.200
     1.085    23.065     0.200
     1.314    22.198     0.200
     1.755    27.487     0.200
     2.273    35.770     0.200
     2.403    40.022     0.200
     2.452    35.253     0.200
     2.452    35.455     0.200
     2.759    43.467     0.200
     2.759    44.868     0.200
     4.189    58.357     0.200
     4.586    70.945     0.200
     9.899   127.546     0.200
     0.710    17.155     0.200
     0.719    15.620     0.200
     2.536    38.170     0.200
     2.861    47.874     0.200
     4.266    64.581     0.200
     4.695    73.374     0.200
     0.272    14.434     0.200
     1.868    30.480     0.200
     2.117    33.380     0.200
     0.808    19.191     0.200
     1.972    31.327     0.200
     4.623    63.497     0.200
     9.919   125.343     0.200
    13.383   180.370     0.200
     0.515    16.067     0.200
     1.756    27.538     0.200
     1.966    33.819     0.200
     0.316    14.386     0.200
     2.163    34.538     0.200
     0.273    14.603     0.200
     1.869    27.939     0.200
     2.113    33.485     0.200
     2.113    34.640     0.200
     4.714    65.708     0.200
     5.610    76.682     0.200
     8.012   112.269     0.200
     8.310   112.590     0.200
     9.504   120.806     0.200
    10.519   142.223     0.200
    13.428   179.177     0.200
    14.487   191.320     0.200
    14.614   193.481     0.200
    17.733   229.915     0.200
    17.965   231.979     0.200
     0.303    14.411     0.200
     2.099    33.676     0.200
     4.693    67.194     0.200
    12.588   171.732     0.200
    22.223   288.952     0.200
     1.459    28.783     0.200
     2.525    43.243     0.200
     4.271    66.299     0.200
     0.298    14.635     0.200
     0.298    13.367     0.200
     1.842    28.373     0.200
     2.147    34.303     0.200
     2.147    33.999     0.200
     2.147    33.699     0.200
     4.651    69.646     0.200
     6.885    99.758     0.200
     6.885    97.829     0.200
     8.047   109.875     0.200
     8.408   116.969     0.200
     9.538   120.438     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     8.665   166.566     0.200
     4.656    95.235     0.200
     3.241    65.458     0.200
     3.350    65.165     0.200
     3.486    71.770     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.471    13.289     0.200
     0.791    17.559     0.200
     1.556    32.632     0.200
     0.253     8.754     0.200
     0.769    17.733     0.200
     1.498    31.225     0.200
     3.345    58.665     0.200
     0.452    12.222     0.200
     0.816    16.973     0.200
     1.350    27.530     0.200
     1.602    32.792     0.200
     4.765    84.882     0.200
     0.529    13.687     0.200
     0.869    19.723     0.200
     1.532    27.976     0.200
     2.209    39.084     0.200
     0.678    13.432     0.200
     1.023    21.508     0.200
     1.061    22.459     0.200
     1.271    25.612     0.200
     1.924    34.182     0.200
     2.298    42.025     0.200
     3.456    60.508     0.200
     1.547    34.938     0.200
     1.809    36.082     0.200
     3.136    56.403     0.200
     0.935    19.850     0.200
     1.565    32.600     0.200
     1.698    31.543     0.200
     2.033    36.937     0.200
     2.271    41.858     0.200
     0.925    20.756     0.200
     1.938    35.029     0.200
     2.266    41.407     0.200
     2.529    48.340     0.200
     3.074    53.277     0.200
     1.473    28.186     0.200
     1.574    32.006     0.200
     1.464    27.651     0.200
     1.552    32.429     0.200
     1.888    33.503     0.200
     2.132    39.360     0.200
     0.880    19.054     0.200
     1.619    31.131     0.200
     1.544    30.097     0.200
     0.882    19.130     0.200
     1.518    30.009     0.200
     1.597    32.104     0.200
     1.482    27.351     0.200
     0.832    17.317     0.200
     0.871    19.068     0.200
     1.586    29.326     0.200
     1.556    28.680     0.200
     1.608    32.418     0.200
     1.813    33.824     0.200
     2.180    39.437     0.200
     3.258    56.960     0.200
     1.520    30.598     0.200
     1.866    34.560     0.200
     0.843    18.722     0.200
     1.962    36.066     0.200
     0.962    20.897     0.200
     1.656    32.790     0.200
     1.976    36.064     0.200
     1.226    23.971     0.200
     1.563    33.243     0.200
     1.570    30.357     0.200
     1.792    32.366     0.200
     1.567    31.938     0.200
     3.149    54.270     0.200
     0.929    20.430     0.200
     1.635    32.591     0.200
     1.606    30.931     0.200
     1.814    33.186     0.200
     3.105    53.523     0.200
     0.937    20.957     0.200
     1.186    22.749     0.200
     1.582    30.732     0.200
     1.724    31.172     0.200
     1.972    36.075     0.200
     1.234    24.631     0.200
     1.499    29.141     0.200
     1.490    29.314     0.200
     1.426    27.571     0.200
     3.374    59.036     0.200
     0.851    18.198     0.200
     1.470    27.072     0.200
     1.652    33.949     0.200
     2.183    38.751     0.200
     3.144    54.236     0.200
     0.851    19.409     0.200
     1.448    30.235     0.200
     1.491    31.474     0.200
     1.414    27.771     0.200
     1.389    31.043     0.200
     1.570    30.122     0.200
     1.956    37.320     0.200
     2.476    44.559     0.200
     3.263    57.366     0.200
     4.723    82.836     0.200
     0.833    17.761     0.200
     1.572    30.842     0.200
     1.511    28.555     0.200
     1.154    21.973     0.200
     1.565    28.877     0.200
     1.945    34.837     0.200
     1.076    23.017     0.200
     1.841    33.785     0.200
     1.286    23.780     0.200
     1.596    31.663     0.200
     1.976    35.722     0.200
     2.264    40.169     0.200
     0.906    19.512     0.200
     1.545    28.355     0.200
     1.813    33.423     0.200
     0.960    20.275     0.200
     1.625    31.719     0.200
     1.658    33.531     0.200
     1.893    34.390     0.200
     1.974    35.754     0.200
     0.879    18.717     0.200
     0.801    17.385     0.200
     0.372    10.034     0.200
     1.091    21.944     0.200
     0.169     7.356     0.200
     1.399    27.411     0.200
     0.211     8.862     0.200
     0.814    17.729     0.200
     1.460    26.692     0.200
     0.670    14.439     0.200
     0.911    18.735     0.200
     1.028    23.473     0.200
     1.256    26.109     0.200
     1.299    25.502     0.200
     1.287    27.940     0.200
     1.376    27.605     0.200
     1.452    28.220     0.200
     1.410    28.507     0.200
     1.625    30.895     0.200
     1.831    34.103     0.200
     1.848    34.095     0.200
     0.503    13.266     0.200
     0.673    14.487     0.200
     0.911    19.001     0.200
     1.257    26.360     0.200
     1.289    26.691     0.200
     1.379    28.045     0.200
     1.413    27.752     0.200
     1.471    29.068     0.200
     1.627    31.552     0.200
     0.230     9.095     0.200
     0.441    12.128     0.200
     0.655    15.836     0.200
     0.743    17.503     0.200
     1.073    21.849     0.200
     1.111    22.414     0.200
     1.364    26.460     0.200
     1.483    28.470     0.200
     1.670    31.883     0.200
     1.786    32.222     0.200
     0.020     9.503     0.200
     0.410    10.356     0.200
     0.623    14.171     0.200
     0.929    18.398     0.200
     1.075    20.601     0.200
     1.835    32.723     0.200
     1.136    22.544     0.200
     1.191    23.209     0.200
     1.388    26.807     0.200
     1.705    32.404     0.200
     1.846    33.357     0.200
     1.890    36.253     0.200
     2.517    44.032     0.200
     0.263     8.200     0.200
     0.264     9.095     0.200
     0.692    14.097     0.200
     0.753    14.886     0.200
     1.130    22.285     0.200
     1.427    27.118     0.200
     1.424    28.751     0.200
     1.720    32.203     0.200
     1.755    32.297     0.200
     0.260    10.216     0.200
     0.281    10.068     0.200
     0.697    15.714     0.200
     0.700    14.784     0.200
     1.110    21.591     0.200
     1.376    26.688     0.200
     0.199     8.120     0.200
     1.095    22.156     0.200
     1.203    22.898     0.200
     1.670    30.051     0.200
     0.247     8.888     0.200
     0.636    13.850     0.200
     0.698    14.528     0.200
     0.877    19.246     0.200
     1.060    20.608     0.200
     0.737    15.606     0.200
     1.189    23.133     0.200
     1.953    34.719     0.200
     0.373    10.363     0.200
     0.629    14.075     0.200
     0.732    16.064     0.200
     0.908    19.314     0.200
     1.059    20.952     0.200
     1.685    31.200     0.200
     0.071     8.135     0.200
     0.549    12.160     0.200
     0.706    14.894     0.200
     0.992    19.856     0.200
     0.121     7.871     0.200
     0.999    20.831     0.200
     0.088     6.969     0.200
     0.404    10.379     0.200
     0.690    14.530     0.200
     2.288    40.189     0.200
     0.200     5.385     0.200
     0.757    17.133     0.200
     0.148     5.481     0.200
     0.851    18.996     0.200
     0.663    15.430     0.200
     0.776    16.212     0.200
     0.096     8.394     0.200
     0.371    11.796     0.200
     0.898    18.532     0.200
     1.150    23.091     0.200
     0.078     8.597     0.200
     0.372    11.661     0.200
     0.594    13.181     0.200
     0.754    16.313     0.200
     0.805    17.512     0.200
     0.916    18.220     0.200
     1.177    23.571     0.200
     1.626    30.628     0.200
     0.310     9.989     0.200
     0.367    10.555     0.200
     0.585    14.597     0.200
     0.690    14.825     0.200
     0.760    18.616     0.200
     1.163    23.042     0.200
     1.428    27.125     0.200
     0.185     8.384     0.200
     0.390     9.907     0.200
     1.086    21.125     0.200
     1.431    26.550     0.200
     0.067     9.588     0.200
     0.398    11.526     0.200
     0.706    15.086     0.200
     0.010     9.153     0.200
     0.353     9.278     0.200
     0.410    12.181     0.200
     0.745    17.268     0.200
     0.899    20.390     0.200
     0.997    19.691     0.200
     1.563    29.116     0.200
     0.086     8.915     0.200
     0.432     9.955     0.200
     0.802    18.198     0.200
     0.994    21.475     0.200
     0.191    10.656     0.200
     0.315     9.511     0.200
     0.360    11.826     0.200
     0.595    13.738     0.200
     0.599    15.210     0.200
     0.722    17.100     0.200
     0.748    16.045     0.200
     0.804    17.689     0.200
     0.942    20.823     0.200
     1.213    23.628     0.200
     0.110     9.668     0.200
     0.291     9.783     0.200
     0.403    11.800     0.200
     0.685    16.331     0.200
     0.738    15.563     0.200
     1.034    21.984     0.200
     0.079     9.764     0.200
     0.339     9.670     0.200
     0.688    15.083     0.200
     0.680    16.325     0.200
     0.749    16.055     0.200
     0.833    19.642     0.200
     0.064     9.719     0.200
     0.320     9.465     0.200
     0.706    15.226     0.200
     0.709    16.962     0.200
     1.508    28.437     0.200
     0.076     9.383     0.200
     0.311     9.120     0.200
     0.663    14.642     0.200
     0.715    15.241     0.200
     0.704    17.059     0.200
     0.046     9.564     0.200
     0.324     9.452     0.200
     0.703    15.094     0.200
     0.728    16.962     0.200
     0.865    19.483     0.200
     1.032    20.344     0.200
     1.102    21.724     0.200
     1.093    23.678     0.200
     1.528    27.999     0.200
     0.012    10.456     0.200
     0.365    10.347     0.200
     0.418    12.492     0.200
     0.670    15.025     0.200
     0.761    17.511     0.200
     0.980    19.271     0.200
     1.253    24.595     0.200
     0.186    10.264     0.200
     0.303     9.360     0.200
     0.372    11.563     0.200
     0.611    15.044     0.200
     0.755    16.007     0.200
     0.725    17.034     0.200
     0.951    20.507     0.200
     1.213    22.836     0.200
     1.391    26.257     0.200
     0.010    10.589     0.200
     0.357     9.949     0.200
     0.447    13.045     0.200
     0.419    12.813     0.200
     0.677    14.866     0.200
     0.758    17.536     0.200
     0.912    20.634     0.200
     0.989    19.318     0.200
     1.090    20.832     0.200
     1.135    23.685     0.200
     1.261    24.722     0.200
     0.308     9.223     0.200
     0.606    15.428     0.200
     0.752    16.143     0.200
     0.723    17.404     0.200
     0.947    21.325     0.200
     1.197    23.370     0.200
     1.213    22.777     0.200
     1.389    25.607     0.200
     1.389    25.912     0.200
     1.390    25.916     0.200
     0.076     9.824     0.200
     0.326     9.662     0.200
     0.384    11.964     0.200
     0.487    13.072     0.200
     0.671    14.703     0.200
     0.691    16.658     0.200
     0.700    15.104     0.200
     0.834    19.151     0.200
     1.056    22.516     0.200
     1.134    21.971     0.200
     1.498    28.097     0.200
     0.081     9.722     0.200
     0.343     9.649     0.200
     0.365    12.086     0.200
     0.685    14.724     0.200
     0.676    16.417     0.200
     0.833    18.937     0.200
     1.048    21.318     0.200
     1.499    28.153     0.200
     0.017     9.232     0.200
     0.371    10.375     0.200
     0.664    14.478     0.200
     0.763    17.653     0.200
     0.926    20.766     0.200
     0.973    19.372     0.200
     1.145    23.003     0.200
     1.247    24.871     0.200
     1.589    28.988     0.200
     0.028     8.977     0.200
     0.379    10.495     0.200
     0.696    15.424     0.200
     0.659    14.511     0.200
     0.772    17.930     0.200
     0.963    19.084     0.200
     0.937    21.051     0.200
     1.156    23.327     0.200
     1.240    24.405     0.200
     1.600    28.950     0.200
     0.171    10.022     0.200
     0.312     9.461     0.200
     0.364    11.767     0.200
     0.546    15.027     0.200
     0.616    15.377     0.200
     0.741    17.618     0.200
     0.740    15.625     0.200
     0.790    16.741     0.200
     0.963    21.541     0.200
     1.230    23.301     0.200
     1.407    25.797     0.200
     0.074     9.520     0.200
     0.327     9.434     0.200
     0.699    14.924     0.200
     0.692    16.352     0.200
     0.835    19.627     0.200
     1.500    28.842     0.200
     0.008     9.418     0.200
     0.367     9.751     0.200
     0.666    14.833     0.200
     0.703    15.656     0.200
     0.739    16.513     0.200
     0.755    17.541     0.200
     0.980    19.630     0.200
     0.916    21.072     0.200
     1.580    29.343     0.200
     0.109     9.405     0.200
     0.321     9.291     0.200
     0.710    15.321     0.200
     0.756    16.228     0.200
     0.662    15.966     0.200
     0.802    18.321     0.200
     1.467    28.121     0.200
     0.014    10.355     0.200
     0.446    12.508     0.200
     0.420    12.729     0.200
     0.672    15.210     0.200
     0.695    15.122     0.200
     0.739    16.138     0.200
     0.763    17.516     0.200
     0.981    19.213     0.200
     0.920    20.791     0.200
     1.254    24.588     0.200
     0.102     9.464     0.200
     0.316     9.683     0.200
     0.650    14.772     0.200
     0.672    16.384     0.200
     0.807    19.038     0.200
     1.031    22.115     0.200
     1.146    22.982     0.200
     1.472    27.482     0.200
     0.130    10.018     0.200
     0.291     9.315     0.200
     0.394    12.154     0.200
     0.498    13.950     0.200
     0.665    16.227     0.200
     0.742    15.540     0.200
     0.779    18.522     0.200
     1.011    21.626     0.200
     1.260    24.050     0.200
     0.057     9.666     0.200
     0.329     9.268     0.200
     0.722    15.798     0.200
     0.697    15.060     0.200
     0.708    17.058     0.200
     0.851    19.380     0.200
     0.084     9.414     0.200
     0.331     9.514     0.200
     0.374    12.225     0.200
     0.697    14.941     0.200
     0.747    16.218     0.200
     0.679    16.416     0.200
     0.826    18.874     0.200
     1.046    21.875     0.200
     1.492    27.707     0.200
     0.168     9.855     0.200
     0.288     8.918     0.200
     0.524    14.537     0.200
     0.592    13.486     0.200
     0.636    15.588     0.200
     0.741    17.835     0.200
     0.767    16.438     0.200
     0.973    21.612     0.200
     1.225    23.428     0.200
     1.405    25.735     0.200
     0.107     9.169     0.200
     0.297     8.771     0.200
     0.730    16.202     0.200
     0.683    16.322     0.200
     0.732    15.442     0.200
     0.803    18.657     0.200
     1.466    28.089     0.200
     0.051     9.766     0.200
     0.329     9.551     0.200
     0.697    14.976     0.200
     0.716    16.893     0.200
     0.858    19.619     0.200
     1.083    22.906     0.200
     0.209     9.499     0.200
     0.738    17.909     0.200
     1.014    21.261     0.200
     0.062     9.474     0.200
     0.327     9.367     0.200
     0.704    16.732     0.200
     0.699    15.097     0.200
     0.846    19.716     0.200
     1.510    27.429     0.200
     0.029     8.861     0.200
     0.378    10.650     0.200
     0.661    14.461     0.200
     0.757    16.030     0.200
     0.774    17.886     0.200
     0.963    19.171     0.200
     0.938    20.867     0.200
     1.157    24.196     0.200
     1.241    24.736     0.200
     1.601    30.040     0.200
     0.088     9.317     0.200
     0.309     9.302     0.200
     0.728    16.205     0.200
     0.692    16.361     0.200
     0.718    15.408     0.200
     0.821    19.036     0.200
     1.067    20.552     0.200
     0.114     5.695     0.200
     0.338    10.030     0.200
     0.680    14.905     0.200
     1.476    29.062     0.200
     0.197    10.038     0.200
     0.300     9.158     0.200
     0.376    11.269     0.200
     0.580    14.335     0.200
     0.606    15.258     0.200
     0.764    15.927     0.200
     1.202    23.155     0.200
     0.057     9.603     0.200
     0.326     9.202     0.200
     0.700    15.273     0.200
     0.711    16.834     0.200
     0.852    19.477     0.200
     1.039    20.376     0.200
     1.077    22.938     0.200
     1.515    28.409     0.200
     0.009     9.461     0.200
     0.365    10.235     0.200
     0.669    14.713     0.200
     0.758    17.462     0.200
     0.917    20.747     0.200
     0.981    19.507     0.200
     1.138    24.014     0.200
     0.104     9.393     0.200
     0.295     8.788     0.200
     0.687    16.369     0.200
     0.733    15.768     0.200
     1.038    21.574     0.200
     1.468    27.450     0.200
     0.078     9.645     0.200
     0.325     9.181     0.200
     0.702    15.073     0.200
     0.689    16.463     0.200
     0.831    19.271     0.200
     1.054    22.402     0.200
     0.048     8.483     0.200
     0.339     9.694     0.200
     0.391    11.841     0.200
     0.687    14.745     0.200
     1.026    20.286     0.200
     1.525    28.419     0.200
     0.179    10.147     0.200
     0.312     9.329     0.200
     0.363    11.563     0.200
     0.551    15.152     0.200
     0.610    15.384     0.200
     0.733    17.497     0.200
     0.744    15.689     0.200
     0.794    17.240     0.200
     0.955    21.219     0.200
     1.223    23.522     0.200
     0.360    10.268     0.200
     0.805    19.564     0.200
     1.073    22.289     0.200
     1.299    24.443     0.200
     0.041    10.090     0.200
     0.326    10.067     0.200
     0.452    12.814     0.200
     0.414    12.326     0.200
     0.692    15.552     0.200
     0.733    17.154     0.200
     0.871    19.658     0.200
     1.533    28.050     0.200
     0.305     9.083     0.200
     0.638    15.651     0.200
     0.738    15.490     0.200
     0.770    16.566     0.200
     1.246    23.433     0.200
     1.426    26.302     0.200
     0.091     9.771     0.200
     0.825    18.410     0.200
     1.586    28.889     0.200
     0.201     9.759     0.200
     0.506    14.615     0.200
     0.654    15.535     0.200
     1.373    26.664     0.200
     0.053     8.438     0.200
     0.727    14.364     0.200
     0.708    14.562     0.200
     1.340    25.499     0.200
     1.588    29.877     0.200
     0.066     9.597     0.200
     0.394    12.275     0.200
     0.476    13.351     0.200
     0.702    15.156     0.200
     0.703    16.735     0.200
     0.843    19.566     0.200
     0.036    10.303     0.200
     0.425    12.611     0.200
     0.443    12.706     0.200
     0.673    14.841     0.200
     0.684    14.979     0.200
     0.785    17.936     0.200
     0.979    19.242     0.200
     0.933    20.682     0.200
     1.161    24.053     0.200
     1.263    24.755     0.200
     0.010     9.481     0.200
     0.352     9.991     0.200
     0.679    14.888     0.200
     0.700    15.642     0.200
     0.723    15.448     0.200
     0.749    17.435     0.200
     0.902    20.233     0.200
     0.997    19.640     0.200
     1.565    28.815     0.200
     0.003     9.631     0.200
     0.360    10.080     0.200
     0.672    14.921     0.200
     0.703    15.948     0.200
     0.751    17.467     0.200
     0.908    20.429     0.200
     0.989    19.771     0.200
     1.129    23.401     0.200
     1.257    24.854     0.200
     1.572    29.014     0.200
     0.079     7.283     0.200
     0.443    12.274     0.200
     1.863    34.103     0.200
     2.899    51.818     0.200
     0.211     9.878     0.200
     0.311     9.033     0.200
     0.366    11.514     0.200
     0.701    17.159     0.200
     1.193    23.047     0.200
     1.368    25.858     0.200
     0.115     8.629     0.200
     0.404    11.434     0.200
     0.795    19.158     0.200
     2.750    50.548     0.200
     0.065     9.223     0.200
     0.331     9.298     0.200
     0.387    11.865     0.200
     0.699    16.442     0.200
     0.695    15.072     0.200
     0.845    19.236     0.200
     1.067    22.505     0.200
     1.041    20.204     0.200
     1.509    27.491     0.200
     0.299     9.054     0.200
     0.513    14.165     0.200
     0.650    15.682     0.200
     0.758    16.583     0.200
     0.739    15.442     0.200
     1.252    24.274     0.200
     0.148     8.908     0.200
     0.315     8.890     0.200
     0.365    11.814     0.200
     0.728    15.730     0.200
     0.778    17.136     0.200
     1.108    21.469     0.200
     1.178    23.871     0.200
     1.429    26.356     0.200
     0.135     9.272     0.200
     0.327     9.788     0.200
     0.356    11.483     0.200
     0.533    14.517     0.200
     0.635    15.723     0.200
     0.712    15.171     0.200
     0.779    18.590     0.200
     0.995    20.782     0.200
     0.130     9.270     0.200
     0.308     8.779     0.200
     0.377    10.973     0.200
     0.759    17.219     0.200
     0.728    15.466     0.200
     1.005    20.938     0.200
     1.445    27.662     0.200
     2.758    49.256     0.200
     0.319     9.648     0.200
     0.245     6.852     0.200
     0.413     9.872     0.200
     0.513    11.986     0.200
     0.477    10.865     0.200
     1.007    20.530     0.200
     1.092    23.397     0.200
     0.188    10.194     0.200
     0.316     9.265     0.200
     0.359    11.717     0.200
     0.600    15.098     0.200
     0.745    15.928     0.200
     0.803    17.002     0.200
     0.945    20.820     0.200
     1.204    25.087     0.200
     1.216    22.996     0.200
     1.391    26.007     0.200
     0.034     8.920     0.200
     0.345     9.525     0.200
     0.671    14.152     0.200
     0.694    15.096     0.200
     0.780    17.740     0.200
     0.920    20.571     0.200
     0.994    19.935     0.200
     0.195     7.890     0.200
     0.279     8.719     0.200
     0.396    10.214     0.200
     0.396     9.943     0.200
     0.460    11.964     0.200
     1.745    32.824     0.200
     2.316    40.632     0.200
     0.142     8.866     0.200
     0.317    10.957     0.200
     0.367     9.844     0.200
     0.790    18.496     0.200
     0.989    21.365     0.200
     1.211    23.097     0.200
     1.458    26.748     0.200
     2.806    48.353     0.200
     0.379     9.132     0.200
     0.608    12.928     0.200
     0.738    15.757     0.200
     0.092     7.761     0.200
     0.704    14.395     0.200
     0.827    18.912     0.200
     1.095    23.058     0.200
     1.617    30.491     0.200
     2.582    46.871     0.200
     0.073     8.641     0.200
     0.413    10.273     0.200
     0.771    16.636     0.200
     0.935    19.936     0.200
     1.131    21.975     0.200
     1.724    31.641     0.200
     0.291     9.652     0.200
     0.921    20.610     0.200
     1.026    20.431     0.200
     2.512    45.649     0.200
     0.716    15.233     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
