#!/bin/bash
gmt begin sapporo1.54_tt5e_local_20180905.1808.01 pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance sapporo1.54'
# Event name
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.200   110.000 Single event: 20180905.1808.01              
EOF
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.400     9.080
     0.500    10.456
     0.600    11.831
     0.700    13.207
     0.800    14.583
     0.900    15.959
     1.000    17.334
     1.100    18.710
     1.200    20.086
     1.300    21.461
     1.400    22.837
     1.500    24.213
     1.600    25.588
     1.700    26.964
     1.800    28.340
     1.900    29.716
     2.000    31.091
     2.100    32.467
     2.200    33.843
     2.300    35.218
     2.400    36.594
     2.500    37.970
     2.600    39.345
     2.700    40.721
     2.800    42.097
     2.900    43.473
     3.000    44.848
     3.100    46.224
     3.200    47.599
     3.300    48.975
     3.400    50.350
     3.500    51.725
     3.600    53.100
     3.700    54.475
     3.800    55.850
     3.900    57.225
     4.000    58.600
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    51.100 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     5.747
     0.200     6.560
     0.300     7.724
     0.400     9.101
     0.500    10.603
     0.600    12.179
     0.700    13.800
     0.800    15.447
     0.900    17.110
     1.000    18.784
     1.100    20.466
     1.200    22.152
     1.300    23.841
     1.400    25.533
     1.500    27.227
     1.600    28.923
     1.700    30.619
     1.800    32.317
     1.900    34.015
     2.000    35.714
     2.100    37.413
     2.200    39.113
     2.300    40.813
     2.400    42.513
     2.500    44.214
     2.600    45.915
     2.700    47.616
     2.800    49.317
     2.900    51.018
     3.000    52.720
     3.100    54.421
     3.200    56.123
     3.300    57.825
     3.400    59.526
     3.500    61.228
     3.600    62.930
     3.700    64.631
     3.800    66.333
     3.900    68.035
     4.000    69.737
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    61.930 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.400    16.015
     0.500    18.446
     0.600    20.877
     0.700    23.308
     0.800    25.739
     0.900    28.170
     1.000    30.601
     1.100    33.032
     1.200    35.463
     1.300    37.894
     1.400    40.325
     1.500    42.756
     1.600    45.187
     1.700    47.617
     1.800    50.048
     1.900    52.479
     2.000    54.910
     2.100    57.341
     2.200    59.772
     2.300    62.203
     2.400    64.634
     2.500    67.065
     2.600    69.496
     2.700    71.927
     2.800    74.358
     2.900    76.789
     3.000    79.220
     3.100    81.650
     3.200    84.081
     3.300    86.512
     3.400    88.942
     3.500    91.372
     3.600    93.802
     3.700    96.232
     3.800    98.662
     3.900   101.092
     4.000   103.522
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    91.802 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100    10.146
     0.200    11.578
     0.300    13.625
     0.400    16.043
     0.500    18.674
     0.600    21.427
     0.700    24.250
     0.800    27.115
     0.900    30.005
     1.000    32.912
     1.100    35.830
     1.200    38.754
     1.300    41.685
     1.400    44.619
     1.500    47.556
     1.600    50.496
     1.700    53.438
     1.800    56.380
     1.900    59.324
     2.000    62.270
     2.100    65.215
     2.200    68.162
     2.300    71.109
     2.400    74.057
     2.500    77.004
     2.600    79.953
     2.700    82.901
     2.800    85.850
     2.900    88.799
     3.000    91.748
     3.100    94.698
     3.200    97.647
     3.300   100.596
     3.400   103.546
     3.500   106.496
     3.600   109.446
     3.700   112.395
     3.800   115.345
     3.900   118.295
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   108.446 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     0.721    13.027     0.200
     0.672    12.387     0.200
     1.046    17.496     0.200
     1.048    17.969     0.200
     1.119    18.898     0.200
     1.069    19.867     0.200
     1.300    22.258     0.200
     1.269    22.105     0.200
     1.322    22.328     0.200
     1.406    23.246     0.200
     1.466    23.707     0.200
     1.404    23.738     0.200
     1.469    23.738     0.200
     1.506    26.168     0.200
     1.506    25.168     0.200
     1.506    25.348     0.200
     1.506    25.195     0.200
     1.553    26.008     0.200
     1.623    26.766     0.200
     1.674    27.695     0.200
     1.781    29.508     0.200
     1.853    30.648     0.200
     1.922    30.688     0.200
     1.929    30.926     0.200
     2.009    31.105     0.200
     2.009    32.367     0.200
     2.009    31.348     0.200
     2.009    31.516     0.200
     2.218    34.258     0.200
     2.334    35.617     0.200
     2.318    37.148     0.200
     2.394    35.809     0.200
     2.548    39.738     0.200
     2.633    40.988     0.200
     2.683    41.918     0.200
     2.629    42.438     0.200
     2.864    42.387     0.200
     2.809    44.047     0.200
     3.156    48.566     0.200
     3.156    49.168     0.200
     3.248    48.605     0.200
     3.434    52.637     0.200
     3.771    55.977     0.200
     3.756    55.867     0.200
     3.756    55.566     0.200
     3.953    59.738     0.200
     4.252    62.578     0.200
     4.306    64.547     0.200
     4.306    66.266     0.200
     4.306    65.668     0.200
     4.306    65.469     0.200
     4.306    65.117     0.200
     4.426    66.105     0.200
     4.428    66.738     0.200
     4.522    66.969     0.200
     4.686    70.836     0.200
     4.895    71.605     0.200
     4.895    72.367     0.200
     4.895    71.969     0.200
     4.895    71.719     0.200
     4.973    74.766     0.200
     5.262    79.309     0.200
     5.377    77.898     0.200
     5.431    80.207     0.200
     5.431    80.668     0.200
     5.431    80.566     0.200
     5.905    88.039     0.200
     6.267    92.828     0.200
     6.303    93.219     0.200
     6.393    95.766     0.200
     6.543    94.598     0.200
     6.779    98.719     0.200
     6.780    96.719     0.200
     6.780   100.766     0.200
     6.780   100.238     0.200
     6.780   100.098     0.200
     6.781    99.742     0.200
     7.039   103.938     0.200
     7.066   102.316     0.200
     7.477   106.621     0.200
     7.405   106.195     0.200
     7.405   105.668     0.200
     7.405   106.816     0.200
     7.650   110.227     0.200
     7.922   113.539     0.200
     7.922   114.566     0.200
     7.922   115.918     0.200
     7.959   114.266     0.200
     8.057   112.688     0.200
     8.157   119.309     0.200
     8.194   119.867     0.200
     8.269   117.027     0.200
     8.269   120.066     0.200
     8.269   120.426     0.200
     8.214   116.969     0.200
     8.310   119.508     0.200
     8.522   122.117     0.200
     8.522   120.969     0.200
     8.522   126.668     0.200
     8.824   129.316     0.200
     8.976   130.836     0.200
     9.067   132.469     0.200
     9.164   133.566     0.200
     9.164   129.848     0.200
     9.164   130.867     0.200
     9.241   131.566     0.200
     9.394   135.445     0.200
     9.476   137.816     0.200
     9.533   135.539     0.200
     9.703   134.617     0.200
     9.705   136.117     0.200
     9.705   140.168     0.200
     9.705   135.117     0.200
     9.651   138.117     0.200
     9.828   142.727     0.200
     9.868   141.887     0.200
    10.505   151.266     0.200
    10.581   154.129     0.200
    10.931   158.797     0.200
    10.877   156.367     0.200
    10.891   157.566     0.200
    10.961   153.105     0.200
    10.961   155.469     0.200
    10.961   159.566     0.200
    11.976   172.617     0.200
    11.959   169.277     0.200
    11.976   169.387     0.200
    12.089   173.266     0.200
    12.578   177.367     0.200
    12.578   177.066     0.200
    12.542   178.566     0.200
    12.746   179.566     0.200
    12.823   180.008     0.200
    12.823   179.266     0.200
    12.823   183.688     0.200
    12.894   181.578     0.200
    12.894   180.969     0.200
    12.933   181.809     0.200
    12.933   182.168     0.200
    12.933   182.617     0.200
    12.933   186.566     0.200
    13.414   190.367     0.200
    13.792   194.828     0.200
    14.672   205.457     0.200
    14.739   205.867     0.200
    14.739   208.566     0.200
    14.808   205.469     0.200
    14.808   205.766     0.200
    14.808   206.559     0.200
    14.808   205.668     0.200
    15.215   211.695     0.200
    15.215   212.266     0.200
    15.215   212.969     0.200
    15.215   210.188     0.200
    15.556   213.086     0.200
    15.556   219.266     0.200
    15.556   213.469     0.200
    16.747   230.008     0.200
    16.747   232.566     0.200
    17.766   244.137     0.200
    17.766   246.469     0.200
    17.766   243.387     0.200
    17.766   244.969     0.200
    17.766   244.836     0.200
    18.850   264.070     0.200
    18.990   260.469     0.200
    18.990   263.320     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.067     6.176     0.200
     0.320     7.648     0.200
     0.473    10.426     0.200
     0.398     9.898     0.200
     0.706    13.195     0.200
     0.706    14.098     0.200
     0.842    16.488     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.506    43.945     0.200
     3.156    84.168     0.200
     3.756    98.867     0.200
     4.306   115.168     0.200
     4.306   115.766     0.200
     4.973   131.367     0.200
     6.393   165.566     0.200
     7.477   193.668     0.200
     8.194   209.168     0.200
     9.164   237.367     0.200
     9.703   243.418     0.200
     9.651   246.043     0.200
    10.877   280.367     0.200
    10.891   273.969     0.200
    12.089   307.969     0.200
    12.933   327.445     0.200
    14.739   365.969     0.200
    14.808   370.891     0.200
    15.215   372.164     0.200
    15.556   376.039     0.200
    15.840   399.367     0.200
    18.850   466.664     0.200
    19.358   480.195     0.200
    20.704   510.070     0.200
    21.264   531.469     0.200
    22.682   553.070     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.067    10.367     0.200
     0.398    16.168     0.200
     0.706    23.328     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.067    10.367     0.200
     0.398    16.168     0.200
     0.706    23.328     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
