#!/bin/bash
gmt begin sapporo1.54_tt5e_local_19820321.0232.06 pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance sapporo1.54'
# Event name
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.200   110.000 Single event: 19820321.0232.06              
EOF
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.500    11.363
     0.600    12.738
     0.700    14.114
     0.800    15.490
     0.900    16.866
     1.000    18.241
     1.100    19.617
     1.200    20.993
     1.300    22.368
     1.400    23.744
     1.500    25.120
     1.600    26.495
     1.700    27.871
     1.800    29.247
     1.900    30.622
     2.000    31.998
     2.100    33.374
     2.200    34.750
     2.300    36.125
     2.400    37.501
     2.500    38.877
     2.600    40.252
     2.700    41.628
     2.800    43.004
     2.900    44.379
     3.000    45.755
     3.100    47.131
     3.200    48.507
     3.300    49.882
     3.400    51.258
     3.500    52.633
     3.600    54.008
     3.700    55.383
     3.800    56.758
     3.900    58.133
     4.000    59.508
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    52.008 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.341
     0.200     5.430
     0.300     6.866
     0.400     8.464
     0.500    10.131
     0.600    11.822
     0.700    13.520
     0.800    15.221
     0.900    16.923
     1.000    18.626
     1.100    20.330
     1.200    22.034
     1.300    23.738
     1.400    25.442
     1.500    27.146
     1.600    28.851
     1.700    30.555
     1.800    32.260
     1.900    33.964
     2.000    35.669
     2.100    37.373
     2.200    39.078
     2.300    40.782
     2.400    42.487
     2.500    44.191
     2.600    45.896
     2.700    47.600
     2.800    49.305
     2.900    51.009
     3.000    52.713
     3.100    54.418
     3.200    56.122
     3.300    57.826
     3.400    59.531
     3.500    61.235
     3.600    62.939
     3.700    64.643
     3.800    66.347
     3.900    68.051
     4.000    69.755
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    61.939 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.500    19.959
     0.600    22.390
     0.700    24.821
     0.800    27.252
     0.900    29.683
     1.000    32.114
     1.100    34.545
     1.200    36.976
     1.300    39.407
     1.400    41.838
     1.500    44.269
     1.600    46.700
     1.700    49.131
     1.800    51.562
     1.900    53.993
     2.000    56.423
     2.100    58.854
     2.200    61.285
     2.300    63.716
     2.400    66.147
     2.500    68.578
     2.600    71.009
     2.700    73.440
     2.800    75.871
     2.900    78.302
     3.000    80.733
     3.100    83.164
     3.200    85.595
     3.300    88.026
     3.400    90.456
     3.500    92.886
     3.600    95.316
     3.700    97.746
     3.800   100.176
     3.900   102.606
     4.000   105.036
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    93.316 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     7.719
     0.200     9.652
     0.300    12.196
     0.400    15.009
     0.500    17.918
     0.600    20.855
     0.700    23.801
     0.800    26.750
     0.900    29.702
     1.000    32.654
     1.100    35.608
     1.200    38.561
     1.300    41.515
     1.400    44.469
     1.500    47.423
     1.600    50.378
     1.700    53.332
     1.800    56.286
     1.900    59.241
     2.000    62.195
     2.100    65.150
     2.200    68.104
     2.300    71.059
     2.400    74.013
     2.500    76.967
     2.600    79.922
     2.700    82.876
     2.800    85.831
     2.900    88.785
     3.000    91.739
     3.100    94.693
     3.200    97.648
     3.300   100.602
     3.400   103.556
     3.500   106.510
     3.600   109.464
     3.700   112.418
     3.800   115.371
     3.900   118.325
     4.000   121.278
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   108.464 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.386    23.051     0.200
     1.591    26.851     0.200
     1.845    30.851     0.200
     1.784    28.650     0.200
     1.987    32.851     0.200
     1.875    29.851     0.200
     1.909    30.251     0.200
     2.266    36.450     0.200
     2.277    35.851     0.200
     2.529    38.851     0.200
     2.522    40.251     0.200
     2.651    41.551     0.200
     3.074    48.351     0.200
     3.048    48.450     0.200
     3.351    52.851     0.200
     3.121    47.851     0.200
     3.131    48.351     0.200
     3.183    49.251     0.200
     3.578    53.851     0.200
     3.820    59.851     0.200
     3.824    58.251     0.200
     4.070    61.851     0.200
     4.227    64.351     0.200
     4.401    67.851     0.200
     4.827    73.251     0.200
     4.653    69.851     0.200
     4.939    74.851     0.200
     5.003    77.051     0.200
     5.275    79.851     0.200
     5.312    79.351     0.200
     5.603    83.851     0.200
     5.953    86.650     0.200
     5.968    87.051     0.200
     6.201    89.051     0.200
     6.210    88.450     0.200
     6.331    93.851     0.200
     6.439    95.851     0.200
     6.425    96.851     0.200
     6.465    94.851     0.200
     6.521    96.727     0.200
     6.521    97.051     0.200
     6.534    93.650     0.200
     6.652    99.650     0.200
     6.660    95.650     0.200
     6.676    96.950     0.200
     6.822   101.851     0.200
     6.795    99.851     0.200
     6.999   100.851     0.200
     7.057   104.851     0.200
     7.171   106.851     0.200
     7.218   107.851     0.200
     7.183   103.351     0.200
     7.174   104.851     0.200
     7.254   107.950     0.200
     7.510   107.650     0.200
     7.567   111.150     0.200
     7.577   108.851     0.200
     7.674   110.051     0.200
     7.936   115.751     0.200
     7.815   115.851     0.200
     7.768   111.251     0.200
     7.851   114.851     0.200
     8.104   118.950     0.200
     8.216   120.851     0.200
     8.347   123.851     0.200
     8.439   123.851     0.200
     8.692   128.851     0.200
     8.736   126.851     0.200
     8.892   129.851     0.200
     8.933   129.851     0.200
     9.004   130.851     0.200
     9.111   132.851     0.200
     9.256   135.851     0.200
     9.283   134.851     0.200
     9.483   137.851     0.200
     9.802   144.650     0.200
     9.931   144.851     0.200
     9.962   141.851     0.200
    10.064   145.851     0.200
    10.198   147.851     0.200
    10.215   148.851     0.200
    10.541   151.851     0.200
    10.938   156.851     0.200
    11.072   158.851     0.200
    11.108   161.851     0.200
    11.140   160.851     0.200
    12.655   178.851     0.200
    12.657   178.950     0.200
    12.857   185.450     0.200
    12.971   183.851     0.200
    13.517   193.851     0.200
    14.268   201.851     0.200
    14.375   201.851     0.200
    14.681   208.851     0.200
    15.006   208.450     0.200
    15.343   214.851     0.200
    15.343   211.851     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.161     5.650     0.200
     0.591    11.551     0.200
     0.925    17.150     0.200
     1.303    22.650     0.200
     1.647    28.251     0.200
     1.938    32.950     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.192    34.851     0.200
     1.386    39.851     0.200
     1.647    48.851     0.200
     1.845    51.851     0.200
     2.651    74.851     0.200
     3.048    85.851     0.200
     3.131    88.551     0.200
     3.828   105.851     0.200
     3.824   103.851     0.200
     4.070   107.051     0.200
     4.227   114.851     0.200
     4.653   124.851     0.200
     5.275   144.950     0.200
     5.953   157.851     0.200
     5.968   155.851     0.200
     6.534   169.251     0.200
     7.171   189.851     0.200
     7.569   199.251     0.200
     7.851   199.851     0.200
     8.439   220.351     0.200
    11.108   284.851     0.200
    11.311   289.351     0.200
    12.264   312.351     0.200
    13.139   330.851     0.200
    13.517   337.851     0.200
    13.762   344.450     0.200
    15.006   377.851     0.200
    15.343   383.851     0.200
    18.633   457.851     0.200
    19.335   476.351     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.925    31.551     0.200
     1.938    57.650     0.200
     2.266    67.851     0.200
     2.529    77.851     0.200
     3.074    89.150     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.925    31.551     0.200
     1.938    57.650     0.200
     2.266    67.851     0.200
     2.529    77.851     0.200
     3.074    89.150     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
