#!/bin/bash
gmt begin sapporo1.54_tt5e_local_19700120.1733.04 pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance sapporo1.54'
# Event name
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.200   110.000 Single event: 19700120.1733.04              
EOF
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.100     6.320
     0.200     7.013
     0.300     8.025
     0.400     9.232
     0.500    10.538
     0.600    11.884
     0.700    13.245
     0.800    14.612
     0.900    15.981
     1.000    17.353
     1.100    18.725
     1.200    20.098
     1.300    21.472
     1.400    22.846
     1.500    24.220
     1.600    25.594
     1.700    26.968
     1.800    28.343
     1.900    29.717
     2.000    31.092
     2.100    32.466
     2.200    33.841
     2.300    35.215
     2.400    36.590
     2.500    37.965
     2.600    39.340
     2.700    40.714
     2.800    42.089
     2.900    43.463
     3.000    44.838
     3.100    46.212
     3.200    47.587
     3.300    48.961
     3.400    50.336
     3.500    51.710
     3.600    53.085
     3.700    54.459
     3.800    55.834
     3.900    57.208
     4.000    58.583
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    51.085 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.100    11.160
     0.200    12.381
     0.300    14.164
     0.400    16.291
     0.500    18.596
     0.600    20.972
     0.700    23.376
     0.800    25.791
     0.900    28.211
     1.000    30.634
     1.100    33.059
     1.200    35.486
     1.300    37.913
     1.400    40.340
     1.500    42.768
     1.600    45.197
     1.700    47.626
     1.800    50.054
     1.900    52.483
     2.000    54.912
     2.100    57.341
     2.200    59.771
     2.300    62.200
     2.400    64.629
     2.500    67.058
     2.600    69.487
     2.700    71.916
     2.800    74.345
     2.900    76.774
     3.000    79.203
     3.100    81.632
     3.200    84.062
     3.300    86.491
     3.400    88.920
     3.500    91.349
     3.600    93.778
     3.700    96.207
     3.800    98.636
     3.900   101.065
     4.000   103.494
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    91.778 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     0.198     6.785     0.200
     0.124     7.188     0.200
     0.124     6.586     0.200
     0.356     9.086     0.200
     0.562    10.387     0.200
     1.086    18.586     0.200
     1.530    23.586     0.200
     1.630    25.484     0.200
     1.630    24.586     0.200
     1.945    30.984     0.200
     1.945    30.586     0.200
     1.842    28.785     0.200
     1.842    28.586     0.200
     1.882    29.086     0.200
     1.882    28.586     0.200
     2.213    34.387     0.200
     2.213    33.586     0.200
     2.021    30.586     0.200
     2.213    35.086     0.200
     2.213    34.586     0.200
     2.367    35.984     0.200
     2.367    35.586     0.200
     2.862    43.586     0.200
     3.240    50.285     0.200
     3.240    49.586     0.200
     3.245    50.285     0.200
     3.064    47.086     0.200
     3.064    46.586     0.200
     3.518    55.188     0.200
     3.518    54.586     0.200
     3.476    52.785     0.200
     3.476    52.586     0.200
     3.575    56.586     0.200
     4.182    61.785     0.200
     4.182    61.586     0.200
     4.280    65.086     0.200
     4.280    64.586     0.200
     4.446    65.586     0.200
     4.605    67.387     0.200
     4.605    66.586     0.200
     4.449    65.785     0.200
     4.449    65.586     0.200
     4.636    68.785     0.200
     4.636    68.586     0.200
     5.043    74.387     0.200
     5.043    73.586     0.200
     5.453    82.285     0.200
     5.453    81.586     0.200
     5.748    84.586     0.200
     5.699    82.785     0.200
     5.684    81.984     0.200
     5.684    81.586     0.200
     6.343    91.387     0.200
     6.329    90.984     0.200
     6.329    90.586     0.200
     6.476    95.086     0.200
     6.541    92.586     0.200
     6.584    92.887     0.200
     6.747    99.086     0.200
     6.871   101.387     0.200
     6.871   100.586     0.200
     6.924   102.586     0.200
     6.866   100.586     0.200
     6.869    98.285     0.200
     6.965   100.984     0.200
     6.999   101.586     0.200
     7.065   100.285     0.200
     7.109   102.785     0.200
     7.109   102.586     0.200
     7.174   102.586     0.200
     7.290   106.586     0.200
     7.319   107.586     0.200
     7.394   105.484     0.200
     7.437   107.387     0.200
     7.531   107.387     0.200
     7.693   112.086     0.200
     7.693   111.586     0.200
     7.665   111.387     0.200
     7.712   113.984     0.200
     7.805   110.285     0.200
     7.805   109.586     0.200
     7.970   112.285     0.200
     7.970   111.586     0.200
     8.004   115.387     0.200
     8.343   119.586     0.200
     8.147   114.984     0.200
     8.147   114.586     0.200
     8.263   116.785     0.200
     8.457   122.086     0.200
     8.457   121.586     0.200
     8.560   123.285     0.200
     8.560   122.586     0.200
     8.665   124.188     0.200
     8.688   125.586     0.200
     8.665   127.484     0.200
     8.665   126.586     0.200
     8.903   129.188     0.200
     9.170   131.586     0.200
     9.223   131.586     0.200
     9.360   135.086     0.200
     9.360   134.586     0.200
     9.419   135.688     0.200
     9.419   135.586     0.200
     9.560   136.285     0.200
     9.574   137.188     0.200
     9.622   134.586     0.200
     9.720   139.188     0.200
     9.720   138.586     0.200
     9.732   139.188     0.200
     9.774   140.887     0.200
     9.795   141.688     0.200
     9.795   141.586     0.200
     9.891   141.785     0.200
     9.891   141.586     0.200
     9.932   141.086     0.200
     9.932   140.586     0.200
    10.269   146.586     0.200
    10.292   145.586     0.200
    10.461   151.188     0.200
    10.549   149.984     0.200
    10.549   149.586     0.200
    10.646   152.586     0.200
    10.687   153.188     0.200
    10.755   152.484     0.200
    11.200   158.586     0.200
    11.344   160.688     0.200
    11.438   163.285     0.200
    11.438   162.586     0.200
    11.541   162.586     0.200
    11.603   164.984     0.200
    11.603   164.586     0.200
    11.799   167.688     0.200
    11.799   167.586     0.200
    12.181   170.586     0.200
    12.387   173.586     0.200
    12.545   176.586     0.200
    13.357   187.887     0.200
    13.357   187.586     0.200
    13.638   191.887     0.200
    13.719   192.887     0.200
    13.719   192.586     0.200
    14.001   195.387     0.200
    14.001   194.586     0.200
    14.260   200.586     0.200
    14.756   204.887     0.200
    14.878   204.586     0.200
    14.906   207.984     0.200
    14.906   207.586     0.200
    15.646   216.484     0.200
    15.646   215.586     0.200
    17.853   244.586     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     0.356    17.086     0.200
     0.562    20.586     0.200
     1.086    32.586     0.200
     1.630    44.586     0.200
     1.630    44.086     0.200
     1.945    52.586     0.200
     1.945    52.984     0.200
     1.842    50.586     0.200
     1.882    51.586     0.200
     1.882    51.387     0.200
     2.213    59.586     0.200
     2.213    59.086     0.200
     2.021    55.586     0.200
     2.213    62.586     0.200
     2.213    62.285     0.200
     2.367    66.586     0.200
     2.367    66.086     0.200
     2.862    76.586     0.200
     2.862    76.387     0.200
     3.240    89.688     0.200
     3.245    89.586     0.200
     3.064    83.586     0.200
     3.064    83.387     0.200
     3.518    98.586     0.200
     3.476    94.586     0.200
     3.476    94.387     0.200
     3.575    97.586     0.200
     4.182   110.586     0.200
     4.182   110.188     0.200
     4.280   117.586     0.200
     4.280   117.984     0.200
     4.449   119.586     0.200
     4.449   119.387     0.200
     4.636   122.586     0.200
     4.636   122.887     0.200
     5.453   147.586     0.200
     5.453   147.785     0.200
     5.684   147.586     0.200
     6.541   168.586     0.200
     6.869   175.586     0.200
     6.999   184.586     0.200
     6.999   184.785     0.200
     7.109   184.586     0.200
     7.109   184.984     0.200
     7.437   193.586     0.200
     8.343   213.586     0.200
     9.253   226.984     0.200
     9.419   242.586     0.200
     9.419   242.086     0.200
     9.622   237.586     0.200
     9.795   251.586     0.200
     9.795   251.285     0.200
    10.269   260.586     0.200
    10.269   260.785     0.200
    20.518   510.586     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     8.665   267.688     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
